﻿USE sofia;
DROP TABLE IF EXISTS sofia.hebsg_vpl;
CREATE TABLE hebsg_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES hebsg_vpl WRITE;
INSERT INTO hebsg_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1"," זֶה סֵפֶר תּוֹלְדֹת הַמָּשִׁיחַ יֵשׁוּעַ בֶּן־דָּוִד בֶּן־אַבְרָהָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","אַבְרָהָם הוֹלִיד אֶת־יִצְחָק וְיִצְחָק הוֹלִיד אֶת־יַעֲקֹב וְיַעֲקֹב הוֹלִיד אֶת־יְהוּדָה וְאֶת־אֶחָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","וִיהוּדָה הוֹלִיד אֶת־פֶּרֶץ וְאֶת־זֶרַח מִתָּמָר וּפֶרֶץ הוֹלִיד אֶת־חֶצְרוֹן וְחֶצְרוֹן הוֹלִיד אֶת־רָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","וְרָם הוֹלִיד אֶת־עַמִּינָדָב וְעַמִּינָדָב הוֹלִיד אֶת־נַחְשׁוֹן וְנַחְשׁוֹן הוֹלִיד אֶת־שַׂלְמוֹן׃ ");
INSERT INTO hebsg_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","וְשַׂלְמוֹן הוֹלִיד אֶת־בֹּעַז מֶרָחָב וּבֹעַז הוֹלִיד אֶת־עוֹבֵד מֵרוּת וְעוֹבֵד הוֹלִיד אֶת־יִשָׁי׃ ");
INSERT INTO hebsg_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","וְיִשַׁי הוֹלִיד אֶת־הַמֶּלֶךְ דָּוִד וְדָוִד הוֹלִיד אֶת־שְׁלֹמֹה מֵהָאִשָּׁה אֲשֶׁר לָקַח מֵאוּרִיָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","וּשְׁלֹמֹה הוֹלִיד אֶת־רְחַבְעָם וּרְחַבְעָם הוֹלִיד אֶת־אֲבִיָּה וַאֲבִיָּה הוֹלִיד אֶת־אָסָא׃ ");
INSERT INTO hebsg_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","וְאָסָא הוֹלִיד אֶת־יְהוֹשָׁפָט וִיהוֹשָׁפָט הוֹלִיד אֶת־יְהוֹרָם וִיהוֹרָם הוֹלִיד אֶת־עֻזִּיָּהוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","וְעֻזִּיָּהוּ הוֹלִיד אֶת־יוֹתָם וְיוֹתָם הוֹלִיד אֶת־אָחָז וְאָחָז הוֹלִיד אֶת־חִזְקִיָּהוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","וְחִזְקִיָּהוּ הוֹלִיד אֶת־מְנַשֶּׁה וּמְנַשֶּׁה הוֹלִיד אֶת־אָמוֹן וְאָמוֹן הוֹלִיד אֶת־יֹאשִׁיָּהוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","וְיֹאשִׁיָּהוּ הוֹלִיד אֶת־יְכָנְיָהוּ וְאֶת־אֶחָיו בִּימֵי גְלוֹתָם בָּבֶלָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","וְאַחֲרֵי הָגְלָם לְבָבֶל יְכָנְיָהוּ הוֹלִיד אֶת־שְׁאַלְתִּיאֵל וּשְׁאַלְתִּיאֵל הוֹלִיד אֶת־זְרֻבָּבֶל׃ ");
INSERT INTO hebsg_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","וּזְרֻבָּבֶל הוֹלִיד אֶת־אֲבִיהוּד וַאֲבִיהוּד הוֹלִיד אֶת־אֶלְיָקִים וְאֶלְיָקִים הוֹלִיד אֶת־עַזּוּר׃ ");
INSERT INTO hebsg_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","וְעַזּוּר הוֹלִיד אֶת־צָדוֹק וְצָדוֹק הוֹלִיד אֶת־יָכִין וְיָכִין הוֹלִיד אֶת־אֱלִיהוּד׃ ");
INSERT INTO hebsg_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","וֶאֱלִיהוּד הוֹלִיד אֶת־אֶלְעָזָר וְאֶלְעָזָר הוֹלִיד אֶת־מַתָּן וּמַתָּן הוֹלִיד אֶת־יַעֲקֹב׃ ");
INSERT INTO hebsg_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","וְיַעֲקֹב הוֹלִיד אֶת־יוֹסֵף אִישׁ מִרְיָם אֲשֶׁר נוֹלַד מִמֶּנָּה יֵשׁוּעַ הַנִּקְרָא מָשִׁיחַ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","וְהִנֵּה כָּל־הַדֹּרוֹת מֵאַבָרָהָם עַד־דָּוִד אַרְבָּעָה עָשָׂר דֹּרוֹת וּמִדָּוִד עַד־גָּלוּת בָּבֶל אַרְבָּעָה עָשָׂר דֹּרוֹת וּמִגָּלוּת בָּבֶל עַד־הַמַּשִׁיחַ אַרְבָּעָה עָשָׂר דֹּרוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","וְזֹאת הָיְתָה לֵדַת יֵשׁוּעַ הַמָּשִׁיחַ כַּאֲשֶׁר מִרְיָם אִמּוֹ מְאֹרָשָׂה הָיְתָה לָיוֹסֵף טֶרֶם יָבוֹא אֵלֶיהָ וַתִּמָּצֵא כִּי הָרָה הִיא כִּי מֵרוּחַ הַקֹּדֶשׁ הָרָתָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","וְיוֹסֵף אִישָׁהּ צַדִּיק הָיָה וְלֹא אָבָה לְתִתָּהּ לְדִבַּת־עָם וַיֹּאמֶר לְשַׁלְּחָהּ בַּסָּתֶר׃ ");
INSERT INTO hebsg_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","עוֹדֶנּוּ מְדַבֵּר אֶל־לִבּוֹ כָּזֹאת וְהִנֵּה מַלְאַךְ יְהוָֹה נִרְאָה אֵלָיו בַּחֲלוֹם לֵאמֹר יוֹסֶף בֶּן־דָּוִד אַל־תִּירָא מִקַּחַת אֵלֶיךָ אֶת־מִרְיָם אִשְׁתֶּךָ כִּי הַיֶּלֶד בְּקִרְבָּהּ נוֹצַר מֵרוּחַ הַקֹּדֶשׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","וְהִיא יֹלֶדֶת בֵּן וְקָרָאתָ אֶת־שְׁמוֹ יֵשׁוּעַ כִּי הוּא יוֹשִׁיעַ אֶת־עַמּוֹ מֵחַטֹּאתֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","וְכָל־זֹאת הָיְתָה לְמַלֹּאת אֵת אֲשֶׁר־דִּבֶּר יְהוָֹה בְּיַד־הַנָּבִיא לֵאמֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","הִנֵּה הָעַלְמָה הָרָה וְיֹלֶדֶת בֵּן וְקָרְאוּ שְׁמוֹ עִמָּנוּאֵל אֲשֶׁר יֵאָמֵר אֵל עִמָּנוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","וַיִּיקַץ יוֹסֵף מִשְּׁנָתוֹ וַיַּעַשׂ כַּאֲשֶׁר צִוָּה אֹתוֹ מַלְאַךְ יְהוָֹה וַיִּקַּח אֶת־אִשְׁתּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","וְלֹא יָדַע אֹתָהּ עַד כִּי־יָלְדָה בֵּן אֶת־בְּכוֹרָהּ וַיִּקְרָא אֶת־שְׁמוֹ יֵשׁוּעַ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","וַיְהִי כַּאֲשֶׁר נוֹלַד יֵשׁוּעַ בְּבֵית־לֶחֶם יְהוּדָה בִּימֵי הַמֶּלֶךְ הוֹרְדוֹס וְהִנֵּה חֹזֵי כוֹכָבִים בָּאוּ מֵאֶרֶץ קֶדֶם יְרוּשָׁלַיְמָה לֵאמֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","אַיֵּה הַמֶּלֶךְ הַנּוֹלָד לַיְּהוּדִים כִּי רָאִנוּ כוֹכָבוֹ בַּקֶּדֶם וַנָּבֹא לְהִשְׁתַּחֲוֹת לוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","וַיִּשְׁמַע הַמֶּלֶךְ הוֹרְדוֹס וַיָּנַע לְבָבוֹ וּלְבַב כָּל־יְרוּשָׁלַיִם עִמּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","וַיַּקְהֵל אֶת־כָּל־רָאשֵׁי הַכֹּהֲנִים וְהַסּוֹפְרִים בָּעָם וַיִּשְׁאַל אֶת־פִּיהֶם לֵאמֹר אַיֵּה יִוָּלֵד הַמָּשִׁיחַ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","וַיֹּאמְרוּ אֵלָיו בְּבֵית־לֶחֶם יְהוּדָה כִּי כֹה־כָּתוּב בְּיַד־הַנָּבִיא׃ ");
INSERT INTO hebsg_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","וְאַתָּה בֵּית־לֶחֶם אֶרֶץ יְהוּדָה אֵינְךָ צָעִיר בְּאַלֻּפֵי יְהוּדָה כִּי מִמְּךָ יֵצֵא מוֹשֵׁל אֲשֶׁר יִרְעֶה אֶת־עַמִּי יִשְׂרָאֵל׃ ");
INSERT INTO hebsg_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","וַיִּקְרָא הוֹרְדוֹס אֶל־חֹזֵי הַכּוֹכָבִים בַּסֵּתֶר וַיַּחְקֹר אֹתָם לָדַעַת אֶת־הָעֵת אֲשֶׁר נִרְאָה הַכּוֹכָב׃ ");
INSERT INTO hebsg_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","וַיִּשְׁלַח אֹתָם בֵּית־לֶחֶם וַיֹּאמַר לְכוּ וְדִרְשׁוּ הֵיטֵב עַל־הַיֶּלֶד וְכַאֲשֶׁר תִּמְצְאוּן אֹתוֹ שׁוּבוּ וְהַגִּידוּ לִי וְאָבֹאָה לְהִשְׁתַּחֲוֹת־לוֹ גַּם־אָנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","וַיִּשְׁמְעוּ אֶל־הַמֶּלֶךְ וַיֵּלֵכוּ וְהִנֵּה הַכּוֹכָב אֲשֶׁר־רָאוּ בַקֶּדֶם עָלָה לִפְנֵיהֶם עַד אֲשֶׁר־בָּא וַיַּעֲמֹד מִמַּעַל לַאֲשֶׁר הָיָה שָׁם הַיָּלֶד׃ ");
INSERT INTO hebsg_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","וְהֵם חָזוּ בַכּוֹכָב וַיִּשְׂמְחוּ שִׂמְחָה גְדֹלָה עַד־מְאֹד׃ ");
INSERT INTO hebsg_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","וַיָּבֹאוּ הַבַּיְתָה וַיִּרְאוּ אֶת־הַיֶּלֶד עִם־מִרְיָם אִמּוֹ וַיִּפְּלוּ וַיִּשְׁתַּחֲווּ־לוֹ וַיִּפְתְּחוּ אֶת־אֹצְרֹתֵיהֶם וַיַּקְרִיבוּ לוֹ מִנְחָה זָהָב וּלְבוֹנָה וָמֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","וְהֵם צֻוּוּ בַחֲלוֹם לְבִלְתִּי שׁוּב אֶל־הוֹרְדוּס וַיִּפְנוּ וַיֵּלְכוּ בְּדֶרֶךְ אַחֵר לְאַרְצָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","וַיְהִי בְּלֶכְתָּם וַיֵּרָא מַלְאַךְ יְהוָֹה אֶל־יוֹסֵף בַּחֲלוֹם לֵאמֹר קוּם קַח אֶת־הַיֶּלֶד וְאֶת־אִמּוֹ וּבְרַח־לְךָ מִצְרַיְמָה וְשֶׁב־שָׁם עַד־אֲשֶׁר אֹמַר אֵלֶיךָ כִּי הוֹרְדוֹס מְבַקֵּשׁ אֶת־נֶפֶשׁ הַיֶּלֶד לְקַחְתָּהּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","וַיָּקָם וַיִּקַּח אֶת־הַיֶּלֶד וְאֶת־אִמּוֹ לָיְלָה וַיֵּלֶךְ מִצְרָיְמָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","וַיֵּשֶׁב שָׁם עַד־מוֹת הוֹרְדוֹס לְמַלֹּאת אֶת אֲשֶׁר דִּבֶּר יְהוָֹה בְּיַד־הַנָּבִיא לֵאמֹר מִמִּצְרַיִם קָרָאתִי לִבְנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","וַיְהִי כִּרְאוֹת הוֹרְדוֹס כִּי הֵתֵלוּ בוֹ הַחֹזִים וַיִּקְצֹף עַד־מְאֹד וַיִּשְׁלַח וַיַּךְ אֶת־כָּל־הַיְלָדִים אֲשֶׁר בְּבֵית־לֶחֶם וּבְכָל־גְּבוּלֶיהָ מִבֶּן־שְׁנָתַיִם וּלְמָטָּה לְפִי הָעֵת אֲשֶׁר חָקַר מִפִּי הַחֹזִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","אָז הוּקַם אֲשֶׁר נֶאֱמַר בְּיַד־יִרְמְיָהוּ הַנָּבִיא לֵאמֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","קוֹל בְּרָמָה נִשְׁמָע נְהִי בְּכִי תַמְרוּרִים רָחֵל מְבַכָּה עַל־בָּנֶיהָ מֵאֲנָה לְהִנָּחֵם כִּי אֵינֶנּוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","וַיְהִי אַחֲרֵי מוֹת הוֹרְדוֹס וַיֵּרָא מַלְאַךְ יְהוָֹה בַּחֲלוֹם אֶל־יוֹסֵף בְּמִצְרַיִם לֵאמֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","קוּם קַח אֶת־הַיֶּלֶד וְאֶת־אִמּוֹ וְלֵךְ שׁוּב אַרְצָה יִשְׂרָאֵל כִּי־מֵתוּ הַמְבַקְשִׁים אֶת־נֶפֶשׁ הַיָּלֶד׃ ");
INSERT INTO hebsg_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","וַיָּקָם וַיִּקַּח אֶת־הַיֶּלֶד וְאֶת־אִמּוֹ וַיָּבֹא אַרְצָה יִשְׂרָאֵל׃ ");
INSERT INTO hebsg_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","וּבְשָׁמְעוֹ כִּי אַרְקְלוֹס מָלַךְ בִּיהוּדָה תַּחַת הוֹרְדוֹס אָבִיו וַיִּירָא לָלֶכֶת שָׁמָּה וַיֻּגַּד־לוֹ דָבָר בַּחֲלוֹם וַיִּסֹּב אֶל־גְּלִילוֹת הַגָּלִיל׃ ");
INSERT INTO hebsg_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","וַיָּבֹא וַיֵּשֶׁב בָּעִיר הַנִּקְרֵאת נְצָרֶת לְמַלֹּאת אֶת־דִּבְרֵי הַנְּבִיאִים כִּי נָצְרִי יִקָּרֵא לוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","וַיְהִי בַּיָּמִים הָהֵם וַיָּבֹא יוֹחָנָן הַמְטַבֵּל וַיִּקְרָא בְמִדְבַּר יְהוּדָה וַיֹּאמַר׃ ");
INSERT INTO hebsg_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","שׁוּבוּ כִּי־מַלְכוּת הַשָּׁמַיִם קָרְבָה לָבֹא׃ ");
INSERT INTO hebsg_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","הוּא אֲשֶׁר נִבָּא עָלָיו יְשַׁעְיָהוּ הַנָּבִיא לֵאמֹר קוֹל קוֹרֵא בַּמִּדְבָּר פַּנּוּ דֶּרֶךְ יְהוָֹה יַשְּׁרוּ מְסִלּוֹתָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","וְיוֹחָנָן הָיָה לָבוּשׁ שְׂעַר גְּמַלִּים וְאֵזוֹר עוֹר אָזוּר בְּמָתְנָיו וּמַאֲכָלוֹ חֲגָבִים וּדְבַשׁ מִיָּעַר׃ ");
INSERT INTO hebsg_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","וַיֵּצְאוּ אֵלָיו יְרוּשָׁלַיִם וְכָל־יְהוּדָה וְכָל־כִּכַּר הַיַּרְדֵּן׃ ");
INSERT INTO hebsg_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","וַיִּטָּבְלוּ עַל־יָדוֹ בַּיַּרְדֵּן בְּהִתְוַדֹּתָם אֶת־חַטֹּאתֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","אַךְ כַּאֲשֶׁר רָאָה רַבִּים מִן־הַפְּרוּשִׁים וּמִן־הַצַּדּוּקִים בָּאִים אֵלָיו לְהִטָּבֵל וַיֹּאמֶר לָהֶם יַלְדֵי צִפְעֹנִים מִי הוֹרָה אֶתְכֶם לְהִמָּלֵט עַל־נַפְשְׁכֶם מִפְּנֵי חֲרוֹן אַף הַבָּא׃ ");
INSERT INTO hebsg_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","לָכֵן עֲשׂוּ פְרִי טוֹב לִתְשׁוּבָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","וְאַל־תֶּהְגּוּ בִלְבַבְכֶם לֵאמֹר אַבְרָהָם לָנוּ לְאָב כִּי אֲנִי אֹמֵר לָכֶם גַּם מִן־אֲבָנִים אֵלֶּה תַּשִּׂיג יַד־אֱלֹהִים לְהָקִים בָּנִים לְאַבְרָהָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","וְגַם־כְּבָר נָטוּי הַגַּרְזֶן עַל־שֹׁרֶשׁ הָעֵצִים וְלָכֵן כָּל־עֵץ אֲשֶׁר לֹא יַעֲשֶׂה פְרִי טוֹב יִגָּדַע וְהָשְׁלַךְ בְּמוֹ־אֵשׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","וַאֲנִי הִנְנִי מְטַבֵּל אֶתְכֶם בַּמַּיִם לִתְשׁוּבָה אַךְ הַבָּא אַחֲרַי חָסֹן הוּא מִמֶּנִּי אֲשֶׁר קָטֹנְתִּי מִשְּׂאֵת אֶת־נְעָלָיו הוּא יְטַבֵּל אֶתְכֶם בְּרוּחַ הַקֹּדֶשׁ וּבָאֵשׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","אֲשֶׁר מִזְרֵהוּ בְיָדוֹ לִזְרוֹת וּלְהָבֵר אֶת־גָּרְנוֹ וְאָסַף אֶת־הַחִטִּים אֶל־תּוֹךְ אֲסָמָיו וְאֶת־הַמֹּץ יִשְׂרֹף בַּאֵשׁ אֲשֶׁר לֹא תִכְבֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","אָז יָבֹא יֵשׁוּעַ מִן־הַגָּלִיל אֶל־הַיַּרְדֵּן לִפְנֵי יוֹחָנָן לְהִטָּבֵל עַל־יָדוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","וַיַּעֲצָר־בּוֹ יוֹחָנָן לֵאמֹר הֲלֹא נָכוֹן לִי לְהִטָּבֵל עַל־יָדְךָ וְאַתָּה בָּאתָ אֵלָי׃ ");
INSERT INTO hebsg_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","וַיַּעַן יֵשׁוּעַ וַיֹּאמֶר אֵלָיו הֶרֶף כַּיּוֹם כִּי־כֹה יָאֲתָה לָנוּ לְמַלֵּא כָל־צְדָקָה וַיִּרֶף מִמֶּנּוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","וַיִּטָּבֵל יֵשׁוּעַ וַיְמַהֵר וַיַּעַל מִן־הַמָּיִם וְהִנֵּה נִפְתְחוּ־לוֹ הַשָּׁמַיִם וַיַּרְא אֶת־רוּחַ אֱלֹהִים יֹרֶדֶת בִּדְמוּת־יוֹנָה וַתָּנַח עָלָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","וְהִנֵּה קוֹל קֹרֵא מִשָּׁמַיִם זֶה הוּא בְנִי יְדִידִי בּוֹ רָצְתָה נַפְשִׁי׃ ");
INSERT INTO hebsg_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","אָז הוּבַל יֵשׁוּעַ בָּרוּחַ הַמִּדְבָּרָה לְבַעֲבוּר יְנַסֵּהוּ שָׁם הַשָּׂטָן׃ ");
INSERT INTO hebsg_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","וַיָּצָם אַרְבָּעִים יוֹם וְאַרְבָּעִים לָיְלָה וַיִּרְעָב׃ ");
INSERT INTO hebsg_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","וַיִּגַּשׁ הַמְנַסֶּה וַיֹּאמֶר אֵלָיו אִם בֶּן־הָאֱלֹהִים אַתָּה אֱמֹר וַאֲבָנִים אֵלֶּה תִּהְיֶיןָ לְלָחֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","וַיַּעַן וַיֹּאמַר כָּתוּב כִּי לֹא עַל־הַלֶּחֶם לְבַדּוֹ יִחְיֶה הָאָדָם כִּי עַל־כָּל־מוֹצָא פִי־יְהוָֹה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","וַיִּקָּחֵהוּ הַשָּׂטָן אֶל־עִיר הַקֹּדֶשׁ וַיַּעֲמִדֵהוּ עַל־פִּנַּת גַּג בֵּית־הַמִּקְדָּשׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","וַיֹּאמֶר אֵלָיו אִם בֶּן־הָאֱלֹהִים אַתָּה הִתְנַפֵּל אָרְצָה כִּי כָתוּב כִּי מַלְאָכָיו יְצַוֶּה־לָּךְ עַל־כַּפַּיִם יִשָּׂאוּנְךָ פֶּן־תִּגֹּף בָּאֶבֶן רַגְלֶךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","וַיֹּאמֶר אֵלָיו יֵשׁוּעַ וְעוֹד כָּתוּב לֹא תְנַסֶּה אֶת־יְהוָֹה אֱלֹהֶיךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","וַיּוֹסֶף הַשָּׂטָן וַיִּקָּחֵהוּ אֶל־הַר גָּבֹהַּ מְאֹד וַיַּרְאֵהוּ אֶת־כָּל־מַמְלְכוֹת הָאָרֶץ וּכְבוֹדָן׃ ");
INSERT INTO hebsg_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","וַיֹּאמֶר אֵלָיו אֶת־כָּל־אֵלֶּה אֶתֶּן־לְךָ אִם־תִּפֹּל וְתִשְׁתַּחֲוֶה לִי׃ ");
INSERT INTO hebsg_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","אָז אָמַר אֵלָיו יֵשׁוּעַ גֶּשׁ־הָלְאָה הַשָּׂטָן כִּי כָתוּב לַיהוָֹה אֱלֹהֶיךָ תִשְׁתַּחֲוֶה וְאֹתוֹ לְבַדּוֹ תַּעֲבֹד׃ ");
INSERT INTO hebsg_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","וַיִּרֶף מִמֶּנּוּ הַשָּׂטָן וַיִּגְּשׁוּ אֵלָיו מַלְאָכִים וַיְשָׁרְתֻהוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","וַיְהִי כְשָׁמְעוֹ יֵשׁוּעַ כִּי נִסְגַּר יוֹחָנָן וַיָּשָׁב הַגָּלִילָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","וַיַּעֲזֹב אֶת־נְצָרֶת וַיָּבֹא וַיֵּשֶׁב בִּכְפַר־נַחוּם עַל־שְׂפַת הַיָּם בִּגְבוּלֵי זְבֻלוּן וְנַפְתָּלִי׃ ");
INSERT INTO hebsg_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","לְמַלֹּאת אֵת אֲשֶׁר־נֶאֶמַר בְּיַד־יְשַׁעְיָהוּ הַנָּבִיא לֵאמֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","אַרְצָה זְבֻלוּן וְאַרְצָה נַפְתָּלִי דֶּרֶךְ הַיָּם עֵבֶר הַיַּרְדֵּן גְּלִיל הַגּוֹיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","הָעָם הַהֹלְכִים בַּחֹשֶׁךְ רָאוּ אוֹר גָּדוֹל יֹשְׁבֵי בְּאֶרֶץ צַלְמָוֶת אוֹר נָגַהּ עֲלֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","מֵהָעֵת הַהִיא הֵחֵל יֵשׁוּעַ לִקְרֹא וְלֵאמֹר שׁוּבוּ מִדַּרְכֵיכֶם כִּי מַלְכוּת הַשָּׁמַיִם קָרְבָה לָבֹא׃ ");
INSERT INTO hebsg_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","וַיִּתְהַלֵּךְ יֵשׁוּעַ עַל־יַד יַם־הַגָּלִיל וַיַּרְא שְׁנֵי אַחִים שִׁמְעוֹן הַנִּקְרָא פֶּטְרוֹס וְאַנְדְּרַי אָחִיו פֹּרְשִׂים מִכְמֹרֶת עַל־פְּנֵי־הַיָּם כִּי דַיָּגִים הָיוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","וַיֹּאמֶר אֲלֵיהֶם לְכוּ אַחֲרָי וְאֶעֱשֶׂה אֶתְכֶם לְדַיְּגֵי אָדָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","וַיַּעַזְבוּ אֶת־מִכְמֹרוֹתָם כְּרָגַע וַיֵּלְכוּ אַחֲרָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","וַיַּעֲבֹר מִשָּׁם וַיַּרְא שְׁנֵי אַחִים אֲחֵרִים יַעֲקֹב בֶּן־זַבְדִּי וְיוֹחָנָן אָחִיו בָּאֳנִיָּה עִם־זַבְדִּי אֲבִיהֶם מְתַקְּנִים מִכְמֹרוֹתָם וַיִּקְרָא אֲלֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","וְגַם־הֵמָּה כְּרֶגַע עָזְבוּ אֶת־הָאֳנִיָּה וְאֶת־אֲבִיהֶם וַיֵּלְכוּ אַחֲרָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","וַיָּסָב יֵשׁוּעַ בְּכָל־הַגָּלִיל וַיְּלַמֶּד־שָׁם בְּבָתֵּי הַכְּנֵסֶת קָרֹא בְּשׂרַת הַמַּלְכוּת וְרָפֹא כָּל־מַחֲלָה וְכָל־מַדְוֶה בָּעָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","וַיֵּצֵא שָׁמְעוֹ בְּכָל־אֲרָם וַיָּבִיאוּ אֵלָיו אֵת כָּל־הַחוֹלִים אֲשֶׁר דָּבְקוּ בָם תַּחֲלֻאִים שׁוֹנִים וָחֳלָיִם רָעִים אֲחֻזֵי רוּחוֹת רָעוֹת מֻכֵּי יָרֵחַ וּנְכֵי עֲצָמוֹת וַיִּרְפָּאֵם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","וַיֵּלְכוּ אַחֲרָיו קָהָל רָב מִן־הַגָּלִיל וּמִן־דֶּכַּפֹּלִיס וּמִן־יְרוּשָׁלַיִם וִיהוּדָה וְעֵבֶר הַיַּרְדֵּן׃ ");
INSERT INTO hebsg_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","וַיְהִי כַּאֲשֶׁר רָאָה אֶת־הֲמוֹן הָעָם וַיַּעַל אֶל־הָהָר וַיֵּשֶׁב שָׁם וַיִּגְּשׁוּ אֵלָיו תַּלְמִידָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","וַיִּפְתַּח אֶת־פִּיהוּ וַיּוֹרֶה לָהֶם לֵאמֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","אַשְׁרֵי עֲנִיֵּי הָרוּחַ כִּי לָהֶם מַלְכוּת הַשָּׁמָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","אַשְׁרֵי הַמִּתְאַבְּלִים כִּי־הֵם יְנֻחָמוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","אַשְׁרֵי הָעֲנָוִים כִּי־הֵם יִירְשׁוּ־אָרֶץ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","אַשְׁרֵי הָרְעֵבִים וְהַצְּמֵאִים לִצְדָקָה כִּי־הֵם יִרְוָיֻן׃ ");
INSERT INTO hebsg_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","אַשְׁרֵי בַּעֲלֵי־רַחֲמִים כִּי־הֵם יְרֻחָמוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","אַשְׁרֵי בָּרֵי לֵבָב כִּי־הֵם יֶחֱזוּ אֶת־אֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","אַשְׁרֵי עֹשֵׂי שָׁלוֹם כִּי־הֵם יִקָּרְאוּ בְּנֵי־אֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","אַשְׁרֵי הַנִּרְדָּפִים עֵקֶב צִדְקָתָם כִּי לָהֶם מַלְכוּת הַשָּׁמָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","אַשְׁרֵיכֶם אִם־יְחָרְפוּ אִם־יִרְדְּפוּ אֶתְכֶם וּבַשֶּׁקֶר יָבִיאוּ דִבַּתְכֶם רָעָה בַּעֲבוּר שְׁמִי׃ ");
INSERT INTO hebsg_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","שִׂישׂוּ וְגִילוּ כִּי שְׂכַרְכֶם הַרְבֶּה מְאֹד בַּשָּׁמָיִם כִּי־כֵן רָדְפוּ אֶת־הַנְּבִיאִים אֲשֶׁר הָיוּ לִפְנֵיכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","אַתֶּם מֶלַח הָאָרֶץ וְאִם־הַמֶּלַח יָפוּג טַעְמוֹ בַּמֶּה יָמְלָח תָּפֵל לֹא־יִצְלַח לַכֹּל כִּי אִם־יְזֹרֶה הַחוּצָה וְהָיָה לְמִרְמַס רָגֶל׃ ");
INSERT INTO hebsg_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","אַתֶּם אוֹר הָעוֹלָם עִיר יֹשֶׁבֶת עַל־הָהָר לֹא תוּכַל לְהִסָּתֵר׃ ");
INSERT INTO hebsg_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","וְאֵין מַדְלִיקִים נֵר לְתִתּוֹ תַּחַת הָאֵיפָה כִּי אִם־אֶל־הַמְּנֹרָה לְהָאִיר לְכֹל אֲשֶׁר בַּבָּיִת׃ ");
INSERT INTO hebsg_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","כֹּה יָאֵר אוֹרְכֶם לְעֵנֵי בְנֵי־הָאָדָם וְרָאוּ מַעֲשֵׂיכֶם הַטּוֹבִים וְאֶת־אֲבִיכֶם בַּשָּׁמַיִם יְכַבֵּדוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","אַל תַּחְשְׁבוּ כִּי בָאתִי לְהָפֵר הַתּוֹרָה אוֹ הַנְּבִיאִים לֹא לְהָפֵר בָּאתִי כִּי אִם־לְמַלְּאֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","כִּי הֵן אָמֵן אָנֹכִי מַגִּיד לָכֶם עַד אֲשֶׁר הַשָּׁמַיִם וְהָאָרֶץ יַעֲבֹרוּן לֹא תַעֲבֹר יוּד אַחַת מִן־הַתּוֹרָה אַף לֹא קוֹץ אֶחָד עַד כִּי־כֻלָּם יָקוּמוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","לָכֵן כָּל־הַמֵּפִיר אַחַת מִמִּצְוֹת קְטַנּוֹת אֵלֶּה וְהוֹרָה כָזֹאת לַאֲנָשִׁים נִקְלֶה יִקָּרֵא בְּמַלְכוּת הַשָּׁמַיִם וְהָעֹשֶׂה אֹתָן וּמְלַמֵּד לַעֲשׂוֹתָן נִכְבָּד יִקָּרֵא בְּמַלְכוּת הַשָּׁמָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","וַאֲנִי אֹמֵר לָכֶם אִם לֹא־תִגְדַּל צִדְקַתְכֶם מִצִּדְקַת הַסּוֹפְרִים וְהַפְּרוּשִׁים לֹא תָבֹאוּ לְמַלְכוּת הַשָּׁמָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","שְׁמַעְתֶּם אֵת אֲשֶׁר נֶאֱמַר לַקַּדְמֹנִים לֹא תִּרְצָח וְהָאִישׁ אֲשֶׁר יִרְצַח יִנָּתֵן לַמִּשְׁפָּט בִּפְלִלִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","וַאֲנִי אֹמֵר לָכֶם הַמִּתְעַבֵּר בְּאָחִיו חִנָּם יִנָּתֵן לַמִּשְׁפָּט בִּפְלִלִים וְהַקֹּרֵא לְאָחִיו רֵיקָה יִנָּתֵן בִּידֵי הַסַּנְהֶדְרִין וְאִם נָבָל יִקְרָא־לוֹ יִפֹּל לְאֵשׁ גֵּיהִנֹּם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","עַל־כֵּן אֵפוֹא כִּי־תַקְרִיב קָרְבָּן עַל־הַמִּזְבֵּחַ וְלִבְּךָ יַגֶּד־לְךָ שָׁם כִּי־דְבַר רִיב לְאָחִיךָ עִמָּךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","הַנַּח שָׁם קָרְבָּנְךָ לִפְנֵי הַמִּזְבֵּחַ וְלֵךְ הִתְרַפֵּס וּרְהַב אָחִיךָ וְאָז בֹּא וְהַקְרֵב קָרְבָּנֶךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","מַהֵר הַשְׁלֵם עִם־אִישׁ רִיבְךָ בְּעוֹדְךָ עִמּוֹ בַדָּרֶךְ פֶּן־יַסְגִּיר אֹתְךָ אִישׁ רִיבְךָ בִּידֵי הַשֹּׁפֵט וְהַשֹּׁפֵט יַסְגִּירְךָ בְּיַד הַשֹּׁטֵר וְהוּא יִתֶּנְךָ לְבֵית הַסֹּהַר׃ ");
INSERT INTO hebsg_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","וַאֲנִי אָמֵן אֹמֵר לְךָ כִּי לֹא תַעֲלֶה מִשָּׁם עַד אֲשֶׁר תְּשַׁלֵּם אֶת־הַפְּרוּטָה הָאַחֲרֹנָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","שְׁמַעְתֶּם אֵת אֲשֶׁר נֶאֱמַר לַקַּדְמֹנִים לֹא תִּנְאָף׃ ");
INSERT INTO hebsg_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","וַאֲנִי אֹמֵר לָכֶם כָּל־הַנֹּתֵן עֵינוֹ בְאִשָּׁה לַחֲשָׁק־בָּהּ בְּרוּחַ־זְנוּנִים נָאַף אֹתָהּ בְּלִבּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","וְאִם עֵינְךָ הַיְמָנִית תַּכְשִׁילֶךָ נַקְּרֶהָ וְהַשְׁלִיכֶהָ מִמֶּךָ טוֹב לְךָ בַּאֲבֹד אֵבֶר אֶחָד מֵהָשְׁלַךְ כָּל־בְּשָׂרְךָ לְגֵיהִנֹּם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","וְאִם־יָדְךָ הַיְמָנִית תַּכְשִׁילֶךָ קַצְּצֶהָ וְהַשְׁלִיכֶהָ מִמֶּךָּ טוֹב לְךָ בַּאֲבֹד אֵבֶר אֶחָד מֵהָשְׁלַךְ כָּל־בְּשָׂרְךָ לְגֵיהִנֹּם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","וְנֶאֱמַר כִּי־יְשַׁלַּח אִישׁ אִשְׁתּוֹ וְנָתַן בְּיָדָהּ סֵפֶר כְּרִיתֻת׃ ");
INSERT INTO hebsg_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","וַאֲנִי אֹמֵר לָכֶם אִם יְשַׁלַּח אִישׁ אִשְׁתּוֹ אִם לֹא עַל־דְּבַר זְנוּת מֵשִׂים אֹתָהּ לְנֹאָפֶת וְהַלֹּקֵחַ גְּרוּשָׁה לוֹ לְאִשָּׁה נֹאֵף הוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","וְעוֹד שְׁמַעְתֶּם אֵת אֲשֶׁר נֶאֱמַר לַקַּדְמֹנִים לֹא תִשָּׁבַע לַשֶּׁקֶר וְאֶת־נְדָרֶיךָ תְּשַׁלֵּם לַיהוָֹה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","וַאֲנִי אֹמֵר לָכֶם לֹא תִשָּׁבַע כָּל־שְׁבוּעָה לֹא תִשָּׁבַע בַּשָּׁמַיִם כִּי־כִסֵּא אֱלֹהִים הֵמָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","וְלֹא בָאָרֶץ כִּי־הֲדֹם רַגְלָיו הִיא וְלֹא בִירוּשָׁלַיִם כִּי־הִיא קִרְיַת מֶלֶךְ רָב׃ ");
INSERT INTO hebsg_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","וְלֹא תִשָּׁבַע בְּרֹאשֶׁךָ כִּי־לֹא תוּכַל לַהֲפֹךְ שֵׂעָר אֶחָד לָבָן אוֹ שָׁחֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","אַךְ זֶה יְהִי דְבַרְכֶם הֵן הֵן לֹא לֹא וְיֹתֵר מִזֶּה מִמְּקוֹר הָרָע הוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","שְׁמַעְתֶּם כִּי נֶאֱמַר עַיִן תַּחַת עַיִן וְשֵׁן תַּחַת שֵׁן׃ ");
INSERT INTO hebsg_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","וַאֲנִי אֹמֵר לָכֶם לֹא תִתְיַצֵּב בִּפְנֵי הַבָּא לְהָרַע לָךְ אִם יַכְּךָ עַל־הַלְּחִי הַיְמָנִית תֶּן־לוֹ גַּם־הַשְּׂמָאלִית׃ ");
INSERT INTO hebsg_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","וְכָל־הֶחָפֵץ לָרִיב עִמְּךָ לָקַחַת הַכְּתֹנֶת מֵעָלֶיךָ הַנַּח לוֹ גַּם־מְעִילֶךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","וְהַנֹּגֵשׂ בְּךָ לָלֶכֶת עִמּוֹ כִּבְרַת אֶרֶץ אֶחָת לֵךְ עִמּוֹ שְׁתָּיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","תֵּן לַמְבַקֵּשׁ מִמֶּךָּ וּמֵאֵת הֶחָפֵץ לִלְוֹת מִיָּדְךָ אַל־תַּסְתֵּר פָּנֶיךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","שְׁמַעְתֶּם כִּי נֶאֱמַר וְאָהַבְתָּ אֶת־רֵעֲךָ וְאָיַבְתָּ אֶת־אֹיְבֶךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","וַאֲנִי אֹמֵר לָכֶם אֶהֱבוּ אֶת־אֹיְבֵיכֶם בָּרֲכוּ אֶת־מְקַלְלֵיכֶם הֵיטִיבוּ לְשׂנְאֵיכֶם וְהַעְתִּירוּ בְּעַד מַכְאִיבֵיכֶם וְרֹדְפֵיכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","לְמַעַן תִּהְיוּ בָנִים אֶל־אֲבִיכֶם בַּשָּׁמַיִם הַמֵּאִיר שִׁמְשׁוֹ לָרָעִים וְלַטּוֹבִים וּמַמְטִיר לַצַּדִּיקִים וְלָרְשָׁעִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","כִּי אִם־תֶּאֱהָבוּן אֶת־אֹהֲבֵיכֶם מַה־שָּׂכָר לָכֶם הֲלֹא גַם־הַמֹּכְסִים יַעֲשׂוּן כְּמוֹ־כֵן׃ ");
INSERT INTO hebsg_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","וְאִם־תִּפְקְדוּ לְשָׁלוֹם רַק אֶת־אֲחֵיכֶם מַה־יִּתְרוֹן לָכֶם כֵּן יַעֲשׂוּן גַּם־הַמֹּכְסִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","לָכֵן הֱיוּ תְמִימִם כַּאֲשֶׁר אֲבִיכֶם בַּשָּׁמַיִם תָּמִים הוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","הִשָּׁמְרוּ לָכֶם מֵעֲשׂוֹת צְדָקָה לְמַרְאֵה עֵינֵי הָאָדָם פֶּן שָׂכָר לֹא תַשִּׂיגוּ מֵאֵת אֲבִיכֶם שֶׁבַּשָּׁמָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","לָכֵן בַּעֲשׂוֹתְךָ צְדָקָה לֹא תַשְׁמִיעַ קוֹל תְּרוּעָה לְפָנֶיךָ כַּאֲשֶׁר יַעֲשׂוּ הַחֲנֵפִים בְּבָתֵּי הַכְּנֵסֶת וּבָרְחֹבוֹת לְמַעַן יַשִּׂיגוּ כָבוֹד לְעֵינֵי בְנֵי־הָאָדָם אָמֵן אֲנִי אֹמֵר לָכֶם הִנֵּה שְׂכָרָם לִפְנֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","וְאַתָּה בַּעֲשׂוֹתְךָ צְדָקָה אַל־תֵּדַע שְׂמֹאלְךָ אֵת אֲשֶׁר עֹשָׂה יְמִינֶךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","לְמַעַן תִּהְיֶה צִדְקָתְךָ בַּסָּתֶר וְאָבִיךָ הָרֹאֶה בַסֵּתֶר גְּמוּלְךָ בַּגַּלוּי יְשַׁלֶּם־לָךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","וְכִי תָבֹאוּ לְהִתְפַּלֵּל אַל־תִּהְיוּ כְּאַנְשֵׁי חֹנֶף הָאֹהֲבִים לַעֲמֹד לְהִתְפַּלֵּל בְּבָתֵּי הַכְּנֵסֶת וּפִנּוֹת הַשְּׁוָקִים לְמַעַן תִּירְאֶינָה אֹתָם עֵינֵי בְנֵי־הָאָדָם אָמֵן אֲנִי אֹמֵר לָכֶם הִנֵּה שְׂכָרָם לִפְנֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","וְאַתָּה בִּתְפִלָּתְךָ בֹּא בַחֲדָרֶיךָ וּסְגֹר דְּלָתְךָ בַּעֲדֶךָ וְהִתְפַּלֵּל אֶל־אָבִיךָ אֲשֶׁר סֵתֶר סְבִיבָיו וְאָבִיךָ הָרֹאֶה בַסֵּתֶר גְּמוּלְךָ בַּגַּלוּי יְשַׁלֶּם־לָךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","וְכַאֲשֶׁר אַתֶּם מִתְפַּלְּלִים אַל־תְּבַטְּאוּ בִשְׂפָתַיִם כַּגּוֹיִם אֲשֶׁר יַחְשֹׁב לִבָּם כִּי־יִשָּׁמְעוּ בַּעֲטֶרֶת דְּבָרִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","לָכֵן אַל־תִּשְׁווּ לָמוֹ כִּי יֹדֵעַ אֲבִיכֶם מַה־מַּחְסוֹרְכֶם טֶרֶם תִּשְׁאֲלוּ מִיָּדוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","וְאַתֶּם כֹּה תִתְפַּלָּלוּ אָבִינוּ שֶׁבַּשָּׁמַיִם יִתְקַדַּשׁ שְׁמֶךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","תָּבֹא מַלְכוּתֶךָ יֵעָשֶׂה רְצוֹנְךָ בָּאָרֶץ כַּאֲשֶׁר נַעֲשָׂה בַשָּׁמָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","תֶּן־לָנוּ הַיּוֹם לֶחֶם חֻקֵּנוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","וּסְלַח־לָנוּ אֶת־אַשְׁמָתֵנוּ כַּאֲשֶׁר סֹלְחִים אֲנַחְנוּ לַאֲשֶׁר אָשְׁמוּ לָנוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","וְאַל־תְּבִיאֵנוּ לִידֵי מַסָּה כִּי אִם־הַצִּילֵנוּ מִן־הָרָע כִּי לְךָ הַמַּמְלָכָה וְהַגְּבוּרָה וְהַתִּפְאֶרֶת לְעוֹלְמֵי עוֹלָמִים אָמֵן׃ ");
INSERT INTO hebsg_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","כִּי אִם־תִּסְלְחוּ לִבְנֵי־אָדָם אֶת־אַשְׁמָתָם גַּם־אֲבִיכֶם בַּשָּׁמַיִם יִסְלַח לָכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","וְאִם־לֹא תִסְלְחוּ לִבְנֵי־אָדָם אֶת־אַשְׁמָתָם גַּם־אֲבִיכֶם לֹא־יִסְלַח לָכֶם אַשְׁמַתְכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","וְכִי תָצוּמוּ אַל־תִּהְיוּ כְחַנְפֵי־לֵב מַקְדִּירֵי פָנִים אֲשֶׁר יַפִּילוּ פְנֵיהֶם לְהִוָּדַע לִבְנֵי־אָדָם בְּתַעֲנִיתָם אָמֵן אֲנִי אֹמֵר לָכֶם הִנֵּה שְׂכָרָם לִפְנֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","וְאַתָּה כִּי תָצוּם תָּסוּךְ רֹאשְׁךָ וְתִרְחַץ פָּנֶיךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","וְלֹא תִוָּדַע לְאָדָם בְּתַעֲנִיתְךָ כִּי אִם־לְאָבִיךָ בַּסָּתֶר וְאָבִיךָ הָרֹאֶה בַסֵּתֶר גְּמוּלְךָ בַּגַּלוּי יְשַׁלֶּם־לָךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","לֹא תַאַצְרוּ לָכֶם אוֹצָרוֹת בְּקֶרֶב הָאָרֶץ שֶׁשָּׁם יֹאכַל עָשׁ וְרָקָב וְגַנָּבִים יַחְתְּרוּ וְיִגְנֹבוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","אֶפֶס אִצְרוּ לָכֶם אוֹצָרוֹת בַּשָּׁמָיִם שָׁם לֹא יֹאכַל עָשׁ וְרָקָב וְגַנָּבִים לֹא יַחְתְּרוּ וְלֹא יִגְנֹבוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","כִּי בִמְקוֹם אוֹצָרֶךָ שָׁם יִהְיֶה גַם־לִבֶּךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","נֵר הַגּוּף הוּא הָעָיִן לָכֵן אִם־עֵינְךָ תְּמִימָה בְּכָל־חַדְרֵי בִטְנֶךָ יִהְיֶה אוֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","וְאִם־עֵינְךָ רָעָה חֹשֶׁךְ בְּכָל־חַדְרֵי בִטְנֶךָ וְאִם־הָאוֹר בְּךָ חֹשֶׁךְ מַה־גָּדוֹל חָשְׁכֶּךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","לֹא־יוּכַל אִישׁ לַעֲבֹד אֲדֹנִים שְׁנָיִם כִּי אִם־יִשְׂנָא אֶת־הָאֶחָד וְאֶת־הָאַחֵר יֶאֱהַב אוֹ יִדְבַּק בָּאֶחָד וְהַשֵּׁנִי נִמְאָס בְּעֵינָיו לֹא תוּכְלוּ לַעֲבֹד אֶת־הָאֱלֹהִים וְאֶת־הַמָּמוֹן׃ ");
INSERT INTO hebsg_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","לָכֵן הִנְנִי אֹמֵר לָכֶם לֹא תִדְאֲגוּ לְנַפְשְׁכֶם מַה־תֹּאכְלוּ מַה־תִּשְׁתּוּ וּמַה־כְּסוּת לְכַסּוֹת בְּשַׂרְכֶם הֲלֹא הַנֶּפֶשׁ יְקָרָה מֵאֹכֶל וּבְשַׂר אִישׁ מִכְּסוּתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","הַבִּיטוּ אֶל־עוֹף הַשָּׁמָיִם לֹא יִזְרְעוּ לֹא יִקְצְרוּ וְלֹא יַאַסְפוּ לִמְגוּרוֹת וַאֲבִיכֶם בַּשָּׁמַיִם מְכַלְכֵּל אֹתָם וְאַתֶּם הֲלֹא נַעֲלֵיתֶם יֶתֶר הַרְבֵּה עֲלֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","וּמִי הוּא הֶחָרֵד מִכֶּם יוּכַל לְהוֹסִיף עַל־קוֹמָתוֹ גֹּמֶד אֶחָד׃ ");
INSERT INTO hebsg_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","וְלָמָּה תִדְאֲגוּ לִכְסוּת הִתְבּוֹנְנוּ אֶל־שׁוֹשַׁנֵּי הַשָּׂדֶה אֵיכָה יַעֲלוּ יָצִיצוּ וְלֹא יִיגְעוּן וְלֹא יִטְווּן׃ ");
INSERT INTO hebsg_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","וַאֲנִי אֹמֵר לָכֶם גַּם־שְׁלֹמֹה בְּכָל־הֲדָרוֹ לֹא־הָיָה לָבוּשׁ כְּאַחַת מֵהֶן׃ ");
INSERT INTO hebsg_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","וְאִם־כָּכָה יַעֲטֶה אֱלֹהִים אֶת־עֵשֶׂב הַשָּׂדֶה אֲשֶׁר יָצִיץ הַיּוֹם וּלְמָחֳרָתוֹ יֻתַּן בְּתַנּוּר אַף כִּי־אֶתְכֶם קְטַנֵּי אֱמֻנָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","לָכֵן אַל־תֶּחֶרְדוּ לֵאמֹר מַה־נֹּאכַל וּמַה־נִּשְׁתֶּה אוֹ מַה־נִּלְבָּשׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","כִּי כָל־אֵלֶּה מְבַקְשִׁים הַגּוֹיִם וַאֲבִיכֶם בַּשָּׁמַיִם יֹדֵעַ כִּי אֵלֶּה מַחְסֹרֵיכֶם הֵמָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","אַךְ בַּקְּשׁוּ רִאשֹׁנָה מַלְכוּת אֱלֹהִים וְצִדְקָתוֹ וְכָל־הַחֲפָצִים הָהֵם יִנָּתְנוּ לָכֶם מַתָּנוֹת נוֹסָפוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","לָכֵן אַל־תִּדְאֲגוּ לְיוֹם מָחָר יוֹם מָחָר יִדְאַג לְעַצְמוֹ דַּי לַיּוֹם בְּצָרָתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","לֹא תִשְׁפְּטוּ וְלֹא תִשָּׁפֵטוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","כִּי בַמִּשְׁפָּט אֲשֶׁר תִּשְׁפֹּטוּ תִּשָּׁפְטוּ גַם־אַתֶּם וּבַמִּדָּה אֲשֶׁר תָּמֹדּוּ יִמַּד לָכֶם גַּם־אַתֶּם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","וְלָמָּה תַבִּיט אֶל־שְׁבָבִים אֲשֶׁר בְּעֵין אָחִיךָ וְלֹא תָשֶׁת־לֵב אֶל־הַקּוֹרָה אֲשֶׁר בְּעֵינֶךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","אוֹ אֵיךְ תֹּאמַר לְאָחִיךָ הֶרֶף וְאָסִירָה שְׁבָבִים מֵעֵינֶךָ וְהִנֵּה קוֹרָה בְּעֵינֶךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","הָסֵר חָנֵף רִאשֹׁנָה אֶת־הַקּוֹרָה מֵעֵינֶךָ וְאַחֲרֵי כֵן רָאֹה תִרְאֶה לְהָסִיר שְׁבָבִים מֵעֵין אָחִיךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","לֹא תִתְּנוּ הַקֹּדֶשׁ לַכְּלָבִים וְאֶת־פְּנִינֵיכֶם לַחֲזִירִים פֶּן־יִרְמְסוּם בְּרַגְלֵיהֶם וְשָׁבוּ וְטָרְפוּ אֶתְכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","שַׁאֲלוּ וְיִנָּתֵן לָכֶם דִּרְשׁוּ וְתִמְצָאוּ דִּפְקוּ וְיִפָּתַח לָכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","כִּי כָּל־הַשֹּׁאֵל יִקַּח וְהַדֹּרֵשׁ יִמְצָא וְהַדֹּפֵק יִפָּתַח לוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","כִּי מִי אִישׁ מִכֶּם אֲשֶׁר בְּנוֹ שָׁאַל מִמֶּנּוּ לָחֶם וַיִּתֵּן־לוֹ אָבֶן׃ ");
INSERT INTO hebsg_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","אוֹ אִם־בִּקֵּשׁ דָּג וַיִּתֵּן־לוֹ נָחָשׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","וְאַף כִּי רָעִים אַתֶּם תֵּדְעוּן לָתֵת מַתָּנוֹת טֹבוֹת לִבְנֵיכֶם אַף כִּי־אֲבִיכֶם שֶׁבַּשָּׁמַיִם יִתֶּן־טוֹב לְדֹרְשָׁיו׃ ");
INSERT INTO hebsg_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","לָכֵן כֹּל אֲשֶׁר תַּחְפְּצוּ שֶׁיַּעֲשׂוּן לָכֶם אֲנָשִׁים עֲשׂוּ לָהֶם כְּמוֹ־כֵן גַּם־אַתֶּם כִּי זֹאת הַתּוֹרָה וְהַנְּבִיאִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","בֹּאוּ בַשַּׁעַר הַצָּר כִּי רָחָב הַשַּׁעַר וְהַדֶּרֶךְ רְחָבָה הַמּוֹלִיכָה אֶל־הָאֲבָדּוֹן וְרַבִּים הֵם הַבָּאִים שָׁמָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","וּמַה־צַּר הַשַּׁעַר וְהַדֶּרֶךְ מַה־צָּרָה הַמּוֹלִיכָה אֶל־הַחַיִּים וּמֹצְאֶיהָ מְתֵי מִסְפָּר הֵם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","הִשָּׁמְרוּ לָכֶם מִנְּבִיאֵי שָׁקֶר הַבָּאִים לִפְנֵיכֶם בְּעוֹר כְּבָשִׂים וְהֵם זְאֵבֵי טָרֶף׃ ");
INSERT INTO hebsg_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","בְּפִרְיָם תַּכִּירוּ אֹתָם הֲיִבְצְרוּ עֲנָבִים מֵעַקְרַבִּים אוֹ תְאֵנִים מִצְּנִינִם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","כֵּן כָּל־עֵץ טוֹב יַעֲשֶׂה פְרִי טוֹב וְעֵץ נִשְׁחָת פְּרִי מָשְׁחָת׃ ");
INSERT INTO hebsg_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","עֵץ טוֹב לֹא־יוּכַל לַעֲשׂוֹת פְּרִי מָשְׁחָת וְעֵץ נִשְׁחָת לֹא־יוּכַל לַעֲשׂוֹת פְּרִי טוֹב׃ ");
INSERT INTO hebsg_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","וְכָל־עֵץ בִּלְתִּי עֹשֶׂה פְרִי טוֹב יִגָּדַע וְיֻתַּן לְמַאֲכֹלֶת אֵשׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","עַל־כֵּן בְּפִרְיָם תַּכִּירוּ אֹתָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","לֹא כָל־הַקֹּרֵא לִי אָדוֹן אָדוֹן יָבֹא לְמַלְכוּת הַשָּׁמָיִם כִּי אִם־הָעֹשֶׂה רְצוֹן אָבִי אֲשֶׁר בַּשָּׁמָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","וְהָיָה בַּיּוֹם הַהוּא יֹאמְרוּ אֵלַי רַבִּים אֲדֹנִי אֲדֹנִי הֲלֹא בְשִׁמְךָ נִבֵּאנוּ בְּשִׁמְךָ גֵּרַשְׁנוּ שֵׁדִים וּבְשִׁמְךָ עָשִׂינוּ נִפְלָאוֹת רַבּוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","אָז כֹּה אַגִּיד לָהֶמלֹא יָדַעְתִּי אֶתְכֶם מֵעוֹדִי סוּרוּ מִמֶּנִּי פֹּעֲלֵי אָוֵן׃ ");
INSERT INTO hebsg_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","לָכֵן כָּל־הַשֹּׁמֵעַ לִדְבָרַי אֵלֶּה וְעֹשֶׂה אֹתָם אֶעֶרְכֶנּוּ לַחֲכַם־לֵב אֲשֶׁר בָּנָה בֵיתוֹ עַל־הַסָּלַע׃ ");
INSERT INTO hebsg_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","הַגֶּשֶׁם נִתַּךְ אַרְצָה נַחֲלֵי מַיִם יִשְׁטֹפוּ וְרוּחַ גְּדוֹלָה בָּאָה וַיִּפְגְּעוּ בַבַּיִת הַהוּא וְלֹא נָפַל כִּי יֻסַּד בַּסָּלַע׃ ");
INSERT INTO hebsg_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","וְכָל־הַשֹּׁמֵעַ לִדְבָרַי אֵלֶּה וְלֹא יַעֲשֶׂה אֹתָם נִמְשַׁל לַחֲסַר־לֵב אֲשֶׁר בָּנָה בֵיתוֹ עַל־הַחוֹל׃ ");
INSERT INTO hebsg_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","הַגֶּשֶׁם נִתַּךְ אַרְצָה נַחֲלֵי מַיִם יִשְׁטֹפוּ וְרוּחַ גְּדוֹלָה בָּאָה וַיִּפְגְּעוּ בַבַּיִת הַהוּא וַיִּפֹּל וַיְהִי לְמַפֵּלָה גְדוֹלָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","וַיְהִי כְּכַלּוֹת יֵשׁוּעַ אֶת־הַדְּבָרִים הָאֵלֶּה וַיִּתְמְהוּ הֲמוֹן הָעָם עַל־תּוֹרָתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","כִּי הָיָה מוֹרֶה אֹתָם כְּהוֹרֹת אִישׁ־שִׁלְטוֹן וְלֹא כַסּוֹפְרִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","וַיֵּרֶד מִן־הָהָר וַהֲמוֹן עַם רָב הֹלְכִים אַחֲרָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","וְהִנֵּה אִישׁ מְצֹרָע בָּא וַיִּשְׁתַּחוּ־לוֹ לֵאמֹר אֲדֹנִי אִם־חָפֵץ אַתָּה הֲלֹא תוּכַל לְטַהֲרֵנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","וַיּוֹשֶׁט אֶת־יָדוֹ וַיִּגַּע־בּוֹ יֵשׁוּעַ וַיֹּאמַר חָפֵץ אֲנִי וּטְהָר וַיִּטְהַר מִצָּרַעְתּוֹ כְּרָגַע׃ ");
INSERT INTO hebsg_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","וַיֹּאמֶר אֵלָיו יֵשׁוּעַ רְאֵה אַל־תַּגֵּד לְאִישׁ רַק לֵךְ וְהֵרָאֵה לְעֵינֵי הַכֹּהֵן וְהַקְרֵב אֶת־הַקָּרְבָּן אֲשֶׁר צִוָּה מֹשֶׁה לְעֵדוּת לָהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","וְכַאֲשֶׁר בָּא יֵשׁוּעַ אֶל־כְּפַר־נַחוּם וַיִּגַּשׁ אֵלָיו שַׂר־מֵאָה אֶחָד וַיִּתְחַנֶּן־לוֹ לֵאמֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","אֲדֹנִי הִנֵּה נַעֲרִי נָפַל לְמִשְׁכָּב בְּבֵיתִי נְכֵה־עֲצָמוֹת וּמְעֻנֶּה מְאֹד׃ ");
INSERT INTO hebsg_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","וַיֹּאמֶר אֵלָיו יֵשׁוּעַ הִנְנִי בָא וּרְפָאתִיו׃ ");
INSERT INTO hebsg_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","וַיַּעַן שַׂר־הַמֵּאָה וַיֹּאמַר אֲדֹנִי נְקַלֹּתִי מִזֹּאת כִּי אַתָּה תָבֹא בְצֵל קֹרָתִי אַךְ רַק דַּבְּרָה דָּבָר וְהַנַּעַר יֶחִי׃ ");
INSERT INTO hebsg_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","כִּי גַם־אֲנִי סָר לְמִשְׁמַעַת מֶמְשָׁלָה וַאֲנָשַׁי סָרִים לְמִשְׁמַעְתִּי וְכִי אֹמַר לְאֶחָד מֵהֶם לֵךְ וְיֵלֵךְ וּלְאַחֵר בֹּא וְיָבֹא וּלְעַבְדִּי עֲשֵׂה־זֹאת וְיַעֲשֶׂה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","וַיִּשְׁמַע יֵשׁוּעַ וַיִּשְׁתָּאֶה וַיֹּאמֶר אֶל־הַהֹלְכִים אַחֲרָיו אָמֵן אֲנִי מַגִּיד לָכֶם אֱמוּנָה גְּדוֹלָה כָמוֹהָ גַּם־בְּיִשְׂרָאֵל לֹא מָצָאתִי׃ ");
INSERT INTO hebsg_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","וְהִנְנִי אֹמֵר לָכֶם כִּי רַבִּים יָבֹאוּ מִמִּזְרָח וּמִמַּעֲרָב וְיֵשְׁבוּ בִּמְסִבָּה עִם־אַבְרָהָם יִצְחָק וְיַעֲקֹב בְּמַלְכוּת הַשָּׁמָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","וּבְנֵי הַמַּלְכוּת יִדַּחוּ אֶל־הַחֹשֶׁךְ הַחוּצָה שָׁם יִהְיֶה בְכִי וַחֲרֹק שִׁנָּיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","וְאֶל־שַׂר־הַמֵּאָה אָמַר יֵשׁוּעַ לֵךְ כַּאֲשֶׁר הֶאֱמַנְתָּ כֵּן יָקוּם לָךְ וַיְחִי הַנַּעַר מֵחָלְיוֹ בַּשָּׁעָה הַהִיא׃ ");
INSERT INTO hebsg_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","וַיָּבֹא יֵשׁוּעַ בֵּית־פֶּטְרוֹס וַיַּרְא אֶת־חֹתַנְתּוֹ שֹׁכֶבֶת חוֹלַת קַדָּחַת׃ ");
INSERT INTO hebsg_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","וַיִּגַּע בְּיָדָהּ וַתִּרֶף הַקַּדַּחַת מִמֶּנָּה וַתָּקָם וַתְּשָׁרֵת לִפְנֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","וַיְהִי בָּעֶרֶב וַיָּבִיאוּ אֵלָיו רַבִּים אֲשֶׁר דָּבְקוּ בָּם רוּחוֹת רָעוֹת וַיְגָרֶשׁ אֶת־הָרוּחוֹת בִּדְבַר־פִּיו וְאֵת כָּל־הַחוֹלִים הֶחֱיָה מֵחָלְיָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","לְמַלֹּאת אֵת אֲשֶׁר נֶאֱמַר בְּיַד־יְשַׁעְיָהוּ הַנָּבִיא לֵאמֹר חֳלָיֵנוּ הוּא נָשָׂא וּמַכְאֹבֵינוּ סְבָלָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","וַיְהִי כִּרְאוֹת יֵשׁוּעַ הֲמוֹן עַם רָב סָבִיב־לוֹ וַיְצַו לַעֲבֹר מִשָּׁם אֶל־עֵבֶר הַיָּם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","וַיִּגַּשׁ אֵלָיו אַחַד הַסּוֹפְרִים וַיֹּאמֶר לוֹ רַבִּי אֵלֵךְ אַחֲרֶיךָ אֶל־כָּל־אֲשֶׁר תֵּלֵךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","וַיֹּאמֶר אֵלָיו יֵשׁוּעַ הַשּׁוּעָלִים חוֹרִים לָהֶם וְצִפּוֹר הַשָּׁמַיִם קֵן לָהּ וּבֶן־הָאָדָם אֵין לוֹ מָקוֹם לְהָנִיחַ אֶת־רֹאשׁוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","וְאִישׁ אַחֵר מִקֶּרֶב תַּלְמִידָיו אָמַר אֵלָיו אֲדֹנִי תְּנָה־לִּי לָלֶכֶת וְלִקְבֹּר אֶת־אָבִי רִאשֹׁנָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","וַיֹּאמֶר אֵלָיו יֵשׁוּעַ לֵךְ אַחֲרָי וְהַנַּח לַמֵּתִים לִקְבֹּר אֶת־מֵתֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","וַיֵּרֶד בָּאֳנִיָּה וְתַלְמִידָיו יָרְדוּ עִמּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","וְהִנֵּה סַעַר גָּדוֹל נֵעוֹר בַּיָּם עַד־כַּסּוֹת הַגַּלִּים אֶת־הָאֳנִיָּה וְהוּא נִרְדָּם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","וַיִּגְּשׁוּ אֵלָיו וַיְעִירֻהוּ וַיִּקְרָאוּ הוֹשִׁיעָה אֲדֹנֵינוּ כִּי אָבָדְנוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","וַיֹּאמֶר אֲלֵיהֶם לָמָּה אַתֶּם חֲרֵדִים קְטַנֵּי אֱמֻנָה וַיָּקָם וַיִּגְעַר בָּרוּחוֹת וּבַיָּם וַתְּהִי דְּמָמָה גְדוֹלָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","וַיִּתְמְהוּ הָאֲנָשִׁים לֵאמֹר מִי הוּא זֶה אֲשֶׁר גַּם־הָרוּחוֹת וְהַיָּם מַקְשִׁיבִים לְקֹלוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","וַיְהִי כְּבֹאוֹ אֶל־עֵבֶר הַיָּם אֶל־אֶרֶץ הַגַּדְרִיִּם וַיִּפְגְּשֻׁהוּ שְׁנֵי אֲנָשִׁים אֲשֶׁר דָּבְקוּ בָּם רוּחוֹת רָעוֹת יֹצְאִים מִבָּתֵּי הַקְּבָרוֹת וּפְנֵיהֶם זֹעֲפִים עַד־מְאֹד עַד־אֲשֶׁר לֹא יָכֹל אִישׁ לַעֲבֹר בַּדֶּרֶךְ הַהוּא מִפָּחַד׃ ");
INSERT INTO hebsg_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","וְהִנֵּה הֵם צֹעֲקִים לֵאמֹר מַה־לָּנוּ וָלָךְ יֵשׁוּעַ בֶּן־הָאֱלֹהִים הַאִם בָּאתָ לְעַנּוֹתֵנוּ טֶרֶם בָּאָה הָעֵת׃ ");
INSERT INTO hebsg_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","וְעֵדֶר חֲזִירִים רַבִּים הָיָה רֹעֶה שָׁם מֵרָחוֹק לָהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","וַיִּתְחַנְּנוּ־לוֹ הָרוּחוֹת לֵאמֹר אִם לְגָרְשֵׁנוּ אַתָּה אֹמֵר תִּנָּה־לָנוּ לָבוֹא בְּעֵדֶר הַחֲזִירִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","וַיֹּאמֶר לָהֶם לְכוּ וַיֵּצְאוּ וַיָּבֹאוּ בְּעֵדֶר הַחֲזִירִים וְהִנֵּה כָּל־הָעֵדֶר שָׁטְפוּ בַמּוֹרָד אֶל־תּוֹךְ הַיָּם וַיֹּאבְדוּ בַּמָּיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","וְהָרֹעִים נָסוּ וַיָּבֹאוּ הָעִירָה וַיַּגִּידוּ אֶת־כָּל אֲשֶׁר נִהְיָתָה וְאֵת אֲשֶׁר קָרָה לַאֲשֶׁר דָּבְקוּ בָּם הָרוּחוֹת הָרָעוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","וְהִנֵּה כָּל־הָעִיר יָצְאָה לִקְרַאת יֵשׁוּעַ וַיִּרְאֻהוּ וַיִּפְצְרוּ־בוֹ לַעֲבֹר מִגְּבוּלָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","וַיֵּרֶד בָּאֳנִיָּה וַיַּעֲבֹר וַיָּבֹא אֶל־עִירוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","וְהִנֵּה הֵבִיאוּ אֵלָיו אִישׁ נְכֵה עֲצָמוֹת שֹׁכֵב עַל־הַמִּטָּה וּבִרְאוֹת יֵשׁוּעַ אֶת־אֱמוּנָתָם אָמַר אֶל־נְכֵה הָעֲצָמוֹת חֲזַק בְּנִי נִסְלְחוּ־לְךָ חַטֹּאתֶיךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","וְשָׁם אֲנָשִׁים סוֹפְרִים אָמְרוּ בְלִבָּם הָאִישׁ הַזֶּה מְגַדֵּף הוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","וַיֵּדַע יֵשׁוּעַ אֶת־מַחְשְׁבֹתָם וַיֹּאמַר מַדּוּעַ תֶּהְגּוּ רָעוֹת בִּלְבַבְכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","כִּי מָה נָקֵל אִם לֵאמֹר נִסְלְחוּ־לְךָ חַטֹּאתֶיךָ אוֹ לֵאמֹר קוּם וְהִתְהַלָּךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","אַךְ לְמַעַן תֵּדְעוּן כִּי יֵשׁ רִשְׁיוֹן לְבֶן־הָאָדָם בָּאָרֶץ לִסְלֹחַ חַטָּאִים אָז אָמַר אֶל־נְכֵה הָעֲצָמוֹת קוּם שָׂא אֶת־מִטָּתְךָ וְלֶךְ־לְךָ אֶל־בֵּיתֶךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","וַיָּקָם וַיֵּלֶךְ אֶל־בֵּיתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","וַיִּרְאוּ הֲמוֹן הָעָם וַיִשְׁתּוֹמֲמוּ וַיִּתְּנוּ כָבוֹד לֵאלֹהִים אֲשֶׁר נָתַן שִׁלְטוֹן כָּזֶה לִבְנֵי־אָדָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","וַיַּעֲבֹר יֵשׁוּעַ מִשָּׁם וַיַּרְא אִישׁ אֶחָד יֹשֵׁב בְּבֵית־הַמֶּכֶס וּשְׁמוֹ מַתִּתְיָהוּ וַיֹּאמֶר אֵלָיו לֵךְ אַחֲרָי וַיָּקָם וַיֵּלֶךְ אַחֲרָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","וַיְהִי בְּשִׁבְתּוֹ עַל־הַלֶּחֶם בְּבֵיתוֹ וְהִנֵּה מוֹכְסִים וְחַטָּאִים רַבִּים בָּאוּ וַיֵּשְׁבוּ לֶאֱכֹל עִם־יֵשׁוּעַ וְתַלְמִידָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","וַיִּרְאוּ הַפְּרוּשִׁים וַיֹּאמְרוּ אֶל־תַּלְמִידָיו מַדּוּעַ יֹאכַל רַבְּכֶם עִם־הַמּוֹכְסִים וְהַחַטָּאִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","וַיִּשְׁמַע יֵשׁוּעַ וַיֹּאמֶר אֲלֵיהֶם הַחֲזָקִים אֵין לָהֶם דָּבָר עִם־הָרֹפֵא כִּי אִם־הַחוֹלִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","וְאַתֶּם לְכוּ לִמְדוּ לָדַעַת מַה־זֶּה חֶסֶד חָפַצְתִּי וְלֹא זָבַח כִּי לֹא־בָאתִי לִקְרֹא לַצַּדִּיקִים לָבֹא כִּי אִם־לַחַטָּאִים לִתְּשׁוּבָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","וַיִּגְּשׁוּ אֵלָיו תַּלְמִידֵי יוֹחָנָן וַיֹּאמְרוּ מַדּוּעַ אֲנַחְנוּ עִם־הַפְּרוּשִׁים מַרְבִּים לָצוּם וְתַלְמִידֶיךָ לֹא יָצֻמוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","וַיֹּאמֶר אֲלֵיהֶם יֵשׁוּעַ הֲיִתְאַבְּלוּ קְרֻאֵי הַחֲתֻנָּה בְּעוֹד הֶחָתָן עִמָּהֶם וְהִנֵּה יָמִים יָבֹאוּ וְלֻקַּח מֵהֶם הֶחָתָן וְאָז יָצֻמוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","וְאֵין תֹּפְרִים טְלָאָה חֲדָשָׁה עַל־שִׂמְלָה בָלָה פֶּן־הַטְּלָאָה בְּמִלֻּאָתָהּ תִּגְרַע מִן־הַשִּׂמְלָה וְתוֹסִיף עַל־קְרָעֶיהָ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","וְתִירוֹשׁ לֹא יֻתַּן בְּנֹאדוֹת בָּלִים פֶּן־יִבָּקְעוּ הַנֹּאדוֹת וְנִשְׁפַּךְ הַיַּיִן וְהַנֹּאדוֹת יִכְלָיוּן אֲבָל תִּירוֹשׁ יֻתַּן בְּנֹאדוֹת חֲדָשִׁים וּשְׁמֻרִים יִהְיוּ שְׁנֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","עוֹדֶנּוּ מְדַבֵּר אֲלֵיהֶם כַּדְּבָרִים הָאֵלֶּה וְהִנֵּה אַחַד הָרָאשִׁים בָּא וַיִּשְׁתַּחוּ־לוֹ לֵאמֹר בִּתִּי מֵתָה עָלַי בָּזֶה אֲבָל בֹּא וְשִׂים־נָא יָדְךָ עָלֶיהָ וְחָיֹה תִחְיֶה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","וַיָּקָם יֵשׁוּעַ וַיֵּלֶךְ עִמּוֹ הוּא וְתַלְמִידָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","וְהִנֵּה אִשָּׁה זָבַת־דָּם אֲשֶׁר יְמֵי זוֹבָהּ נִמְשְׁכוּ שְׁתֵּים עֶשְׂרֶה שָׁנָה קָרְבָה וַתִּגַּע בִּכְנַף בִּגְדוֹ מֵאַחֲרָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","כִּי אָמְרָה בְּלִבָּהּ אִם אַךְ־אֶגַּע בְּבִגְדוֹ וְאִוָּשֵׁעָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","וַיִּפֶן יֵשׁוּעַ וַיַּרְא אֹתָהּ וַיֹּאמַר חִזְקִי בִתִּי אֱמוּנָתֵךְ הוֹשִׁיעָה לָּךְ וּבָעֵת הַהִיא עָלְתָה אֲרֻכָה לָהּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","וַיָּבֹא יֵשׁוּעַ אֶל־בֵּית־הָרֹאשׁ וַיַּרְא אֶת־הַמְחַלְּלִים בַּחֲלִלִים וְאֶת־הָעָם הֹמֶה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","וַיֹּאמַר צְאוּ מִזֶּה הַיַּלְדָּה לֹא מֵתָה כִּי רַק יְשֵׁנָה הִיא וַיִּלְעֲגוּ לוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","וְכַאֲשֶׁר הוֹצִיאוּ אֶת־הָעָם מִשָּׁם וַיָּבֹא הַבָּיְתָה וַיַּחֲזֶק בְּיָדָהּ וַתָּקָם הַנַּעֲרָה עַל־רַגְלֶיהָ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","וְהַשְּׁמֻעָה הַזֹּאת יָצְאָה בְּכָל־הָאָרֶץ הַהִיא׃ ");
INSERT INTO hebsg_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","וַיַּעֲבֹר יֵשׁוּעַ מִשָּׁם וּשְׁנֵי אֲנָשִׁים עִוְרִים הָלְכוּ אַחֲרָיו צֹעֲקִים וְקֹרִאים חָנֵּנוּ בֶּן־דָּוִד׃ ");
INSERT INTO hebsg_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","וּכְבֹאוֹ אֶל־הַבַּיִת וַיִּגְּשׁוּ לְפָנָיו הַעִוְרִים וַיֹּאמֶר יֵשׁוּעַ אֲלֵיהֶם הֲתַאֲמִינוּ כִּי יֶשׁ־לְאֵל יָדִי לַעֲשׂוֹת כָּזֹאת וַיַּעֲנוּ אֹתוֹ הֵן אֲדֹנֵינוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","וַיִּגַּע בְּעֵינֵיהֶם וַיֹּאמַר כֶּאֱמוּנַתְכֶם כֵּן יָקוּם לָכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","וַתִּפָּקַחְנָה עֵינֵיהֶם וַיָּעַד בָּם יֵשׁוּעַ לֵאמֹר רְאוּ לְבִלְתִּי יִוָּדַע הַדָּבָר לְאִישׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","וְהֵם יָצְאוּ וַיֹּצִיאוּ אֶת־שָׁמְעוֹ בְּכָל־הָאָרֶץ הַהִיא׃ ");
INSERT INTO hebsg_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","אַךְ הֵם יֹצְאִים וְאִישׁ אִלֵּם הוּבָא לְפָנָיו אֲשֶׁר רוּחַ רָע דָּבַק בּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","וַיְגָרֶשׁ אֶת־הָרוּחַ הָרָע מִמֶּנּוּ וְהָאִלֵּם הֵחֵל לְדַבֵּר וַיִּתְמְהוּ הֲמוֹן הָעָם וַיֹּאמְרוּ מֵעוֹלָם לֹא־נִרְאֲתָה כָזֹאת בְּיִשְׂרָאֵל׃ ");
INSERT INTO hebsg_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","אֶפֶס הַפְּרוּשִׁים אָמְרוּ עַל־יְדֵי שַׂר־הַשֵּׁדִים הוּא מְגָרֵשׁ אֶת־הַשֵּׁדִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","וַיָּסָב יֵשׁוּעַ בְּכָל־הֶעָרִים וְהַכְּפָרִים וַיּוֹרֶה לָהֶם בְּבָתֵּי הַכְּנֵסֶת מְבַשֵּׂר בְּשׂוֹרַת הַמַּלְכוּת וְרֹפֵא כָל־מַחֲלָה וְכָל־מַדְוֶה בָּעָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","וְכַאֲשֶׁר רָאָה אֶת־הַהֲמֹנִים נִכְמְרוּ רַחֲמָיו עֲלֵיהֶם כִּי הֵם מִתְעַלְּפִים וּנְפֹצִים כַּצֹּאן אֲשֶׁר אֵין־לָהֶם רֹעֶה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","וַיֹּאמֶר אֶל־תַּלְמִידָיו אוּלָם הַקָּצִיר רַב וְהַפֹּעֲלִים מְעַטִּים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","עַל־כֵּן הַעְתִּירוּ אֶל־אֲדוֹן הַקָּצִיר לִשְׁלֹחַ פֹּעֲלִים לִקְצִירוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","וַיִּקְרָא אֵלָיו שְׁנֵים עָשָׂר תַּלְמִידָיו וַיִּתֵּן בְּיָדָם כֹּחַ עַל־רוּחוֹת הַטֻּמְאָה לְגָרְשָׁן וְלִרְפֹּא כָּל־מַחֲלָה וְכָל־מַדְוֶה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","וְאֵלֶּה שְׁמוֹת שְׁנֵים עָשָׂר הַשְּׁלִיחִים הָרִאשׁוֹן שִׁמְעוֹן הַמְכֻנֶּה פֶטְרוֹס וְאַנְדְּרַי אָחִיו יַעֲקֹב בֶּן־זַבְדִּי וְיוֹחָנָן אָחִיו׃ ");
INSERT INTO hebsg_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","פִּילִפּוֹס וּבַר־תַּלְמַי תּוֹמָא וּמַתִּתְיָהוּ הַמּוֹכֵס יַעֲקֹב בֶּן־חַלְפַּי וְלַבַּי הַמְּכֻנֶּה תַדָּי׃ ");
INSERT INTO hebsg_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","שִׁמְעוֹן הַכְּנַעֲנִי וִיהוּדָה אִישׁ־קְרִיּוֹת הוּא הַמַּסְגִּיר אֹתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","אֶת־שְׁנֵים עָשָׂר הָאֵלֶּה שָׁלַח יֵשׁוּעַ וַיְצַו עֲלֵיהֶם לֵאמֹר אַל־תָּשִׂימוּ לְדֶרֶךְ הַגּוֹיִם פַּעֲמֵיכֶם וְאֶל־עָרֵי הַשֹּׁמְרֹנִים אַל־תָּבֹאוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","כִּי אִם־לְצֹאן אֹבְדוֹת מִבֵּית יִשְׂרָאֵל תֵּלֵכוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","וְכַאֲשֶׁר תֵּלְכוּן קִרְאוּ לֵאמֹר מַלְכוּת הַשָּׁמַיִם קְרוֹבָה לָבֹא׃ ");
INSERT INTO hebsg_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","רִפְאוּ אֶת־הַחוֹלִים הָקִימוּ אֶת־הַמֵּתִים טַהֲרוּ אֶת־הַמְצֹרָעִים וְגָרְשׁוּ אֶת־הָרוּחוֹת הָרָעוֹת חִנָּם לְקַחְתֶּם וְחִנָּם תִּתֵּנוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","אַל־תִּקְחוּ לָכֶם זָהָב אוֹ כֶסֶף אוֹ נְחֹשֶׁת בַּכִּיס׃ ");
INSERT INTO hebsg_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","וְלֹא יַלְקוּט לַדֶּרֶךְ וְלֹא חֲלִיפוֹת בְּגָדִים וְלֹא נַעֲלַיִם וְלֹא מַטֶּה כִּי־נָכוֹן לַפֹּעֵל דֵּי מִחְיָתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","וּבְכָל־עִיר אוֹ כְפָר אֲשֶׁר תָּבֹאוּ דִּרְשׁוּ מִי הוּא שָׁמָּה הַנִּכְבָּד וִישַׁבְתֶּם עִמּוֹ עַד כִּי־תַעֲבֹרוּן׃ ");
INSERT INTO hebsg_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","וּבְבֹאֲכֶם הַבָּיְתָה תִּפְקְדוּ לִשְׁלוֹם הַבָּיִת׃ ");
INSERT INTO hebsg_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","אִם־נֶחְשָׁב הַבַּיִת מְאוּמָה יָחוּל שְׁלוֹמְכֶם עָלָיו וְאִם לֹא־נֶחְשָׁב הַבַּיִת מְאוּמָה שְׁלוֹמְכֶם אֲלֵיכֶם יָשׁוּב׃ ");
INSERT INTO hebsg_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","וְכָל־אִישׁ אֲשֶׁר לֹא־יֶאֱסֹף אֶתְכֶם וְלֹא יַקְשִׁיב לְדִבְרֵיכֶם צְאוּ לָכֶם מִן־הַבַּיִת הַהוּא אוֹ מִן־הָעִיר הַהִיא וּנְעַרְתֶּם אֶת־הָאָבָק מֵעַל רַגְלֵיכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","אָמֵן אֲנִי מַגִּיד לָכֶם נָקֵל יִהְיֶה יוֹם הַמִּשְׁפָּט לְאֶרֶץ סְדֹם וַעֲמֹרָה מֵאֲשֶׁר לָעִיר הַזֹּאת׃ ");
INSERT INTO hebsg_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","הִנֵּה אָנֹכִי שֹׁלֵחַ אֶתְכֶם כְּצֹאן בְּקֶרֶב זְאֵבִים עַל־כֵּן הֱיוּ עֲרוּמִים כַּנְּחָשִׁים וּתְמִימִים כַּיּוֹנִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","רַק הִשָּׁמְרוּ לָכֶם מִפְּנֵי בְנֵי־אָדָם כִּי הֵם יַסְגִּירוּ אֶתְכֶם לִידֵי־הַסַּנְהֶדְרִין וְהֻכֵּיתֶם בַּשּׁוֹטִים בְּבָתֵּי הַכְּנֵסֶת׃ ");
INSERT INTO hebsg_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","וְלִפְנֵי מֹשְׁלִים וּמְלָכִים תּוּבָלוּ לְמַעֲנִי לִהְיוֹת לְעֵדוּת לָהֶם וְלַגּוֹיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","וְכַאֲשֶׁר יַסְגִּירוּ אֶתְכֶם אַל־תֶּחֶרְדוּ לֵאמֹר אֵיכָה נְדַבֵּר אוֹ מַה־נְּדַבֵּר כִּי בְּעֶצֶם הָעֵת הַהִיא יוּשַׂם בְּפִיכֶם אֵת אֲשֶׁר־תְּדַבֵּרוּן׃ ");
INSERT INTO hebsg_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","כִּי לֹא אַתֶּם הֵם הַמְדַבְּרִים כִּי אִם רוּחַ־אֲבִיכֶם הַדֹּבֵר בָּכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","וְאָח יַסְגִּיר אֶת־אָחִיו לַמָּוֶת וְאָב אֶת־בְּנוֹ וְיָקוּמוּ בָנִים עַל־אֲבוֹתָם וְהֵמִיתוּם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","וְאַתֶּם שְׂנֻאִים תִּהְיוּ לְכָל־אָדָם בַּעֲבוּר שְׁמִי אַךְ הַמְחַכֶּה עַד־הַקֵּץ יִוָּשֵׁעַ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","וְכִי־יִרְדְּפוּ אֶתְכֶם בְּעִיר אַחַת נוּסוּ לָכֶם אֶל־עִיר אַחֶרֶת אָמֵן אֲנִי אֹמֵר לָכֶם לֹא תְכַלּוּ לַעֲבֹר עָרֵי יִשְׂרָאֵל עַד כִּי־יָבֹא בֶּן־הָאָדָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","הַתַּלְמִיד אֵינֶנּוּ רַב מִרָבּוֹ וְעֶבֶד מֵאֲדֹנָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","דַּי לַתַּלְמִיד לִהְיוֹת כְּרַבּוֹ וְלָעֶבֶד כַּאדֹנָיו אִם בַּעַל־זְבוּב קָרְאוּ לְבַעַל הַבַּיִת אַף כִּי־לְאַנְשֵׁי בֵיתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","עַל־כֵּן אַל־תִּירְאוּ מִפְּנֵיהֶם כִּי אֵין־דָּבָר נִסְתָּר אֲשֶׁר לֹא יִגָּלֶה וְאֵין נֶעְלָם אֲשֶׁר לֹא יִוָּדֵעַ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","אֵת אֲשֶׁר אַגֵּדְכֶם בְּחֹשֶׁךְ הַגִּידוּ לְעֵין הַשָּׁמֶשׁ וְאֵת אֲשֶׁר תִּשְׁמַע אָזְנְכֶם בְּלַחַשׁ הַשְׁמִיעוּ עַל־הַגַּגּוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","וְאַל־תִּירְאוּ מִפְּנֵי הֹרְגֵי הַבָּשָׂר וְלַהֲרֹג אֶת־הַנֶּפֶשׁ לֹא תַשִּׂיג יָדָם כִּי אִם־יִרְאוּ מִפָּנָיו אֲשֶׁר יָדָיו רַב לוֹ לַהֲרֹג גַּם אֶת־הַנֶּפֶשׁ וְגַם אֶת־הַבָּשָׂר בְּגֵיהִנֹּם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","הֲלֹא שְׁתֵּי צִפֳּרִים נִמְכָּרוֹת בְּאִסָּר אֶחָד וְאַחַת מֵהֶן לֹא תִפֹּל אַרְצָה בִּבְלִי רְצוֹן אֲבִיכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","וְאַתֶּם גַּם־שַׂעֲרוֹת רֹאשְׁכֶם נִמְנוּ לְמִסְפָּרָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","עַל־כֵּן אַל־תִּירָאוּ עֶרְכְּכֶם רַב מִצִּפֳּרִים רַבּוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","לָכֵן כָּל־אִישׁ אֲשֶׁר יַאֲמִירֵנִי לִפְנֵי בְנֵי־הָאָדָם אַאֲמִירֶנּוּ לִפְנֵי אָבִי בַשָּׁמַיִם גַּם־אָנֹכִי׃ ");
INSERT INTO hebsg_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","וְכָל־אִישׁ אֲשֶׁר יְכַחֶשׁ־בִּי לִפְנֵי בְנֵי־הָאָדָם אֲכַחֶשׁ־בּוֹ לִפְנֵי אָבִי בַשָּׁמַיִם גַּם־אָנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","אַל־תַּחְשְׁבוּ כִּי בָאתִי לְהָבִיא שָׁלוֹם בָּאָרֶץ לֹא בָאתִי לְהָבִיא שָׁלוֹם כִּי אִם־חָרֶב׃ ");
INSERT INTO hebsg_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","כִּי בָאתִי לְהַפְרִיד בֵּין אִישׁ לְאָבִיו בֵּין בַּת לְאִמָּהּ וּבֵין כַּלָּה לַחֲמוֹתָהּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","וְאֹיְבֵי אִישׁ אַנְשֵׁי בֵיתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","הָאֹהֵב אֶת־אָבִיו אוֹ אֶת־אִמּוֹ יוֹתֵר מִמֶּנִּי אֵינֶנּוּ שׁוֶֹה לִי וְהָאֹהֵב אֶת־בְּנוֹ אוֹ אֶת־בִּתּוֹ יוֹתֵר מִמֶּנִּי אֵינֶנּוּ שׁוֶֹה לִי׃ ");
INSERT INTO hebsg_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","וּמִי אֲשֶׁר לֹא־יִקַּח אֶת־צְלָבוֹ וְיֵלֵךְ אַחֲרָי אֵינֶנּוּ שׁוֶֹה לִי׃ ");
INSERT INTO hebsg_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","הַמֹּצֵא אֶת־נַפְשׁוֹ תֹּאבַד לוֹ וְהַמַּשְׁלִיךְ אֶת־נַפְשׁוֹ בִּגְלָלִי יִמְצָאֶנָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","הַמְקַבֵּל פְּנֵיכֶם מְקַבֵּל פָּנָי וְהַמְקַבֵּל פָּנַי הוּא מְקַבֵּל פְּנֵי שֹׁלְחִי׃ ");
INSERT INTO hebsg_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","הַמְקַבֵּל פְּנֵי נָבִיא בְּשֵׁם נָבִיא יַשִּׂיג שְׂכַר נָבִיא וְהַמְקַבֵּל פְּנֵי צַדִּיק בְּשֵׁם צַדִּיק יַשִּׂיג שְׂכַר צַדִּיק׃ ");
INSERT INTO hebsg_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","וּמִי אֲשֶׁר יַשְׁקֶה אֶת־אַחַד הַקְּטַנִּים הָאֵלֶּה רַק כּוֹס מַיִם קָרִים בְּשֵׁם תַּלְמִיד אָמֵן אֲנִי מַגִּיד לָכֶם כִּי לֹא־יֹאבַד שְׂכָרוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","וַיְהִי כְּכַלּוֹת יֵשׁוּעַ לְצַוֹּת אֶת־שְׁנֵים עָשָׂר תַּלְמִידָיו וַיַּעֲבֹר מִשָּׁם לְלַמֵּד וּלְהַשְׁמִיעַ יְשׁוּעָתוֹ בְּעָרֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","וְיוֹחָנָן בְּבֵית הָאֲסוּרִים שָׁמַע אֶת־עֲלִלוֹת הַמָּשִׁיחַ וַיִּשְׁלַח אֵלָיו שְׁנַיִם מִתַּלְמִידָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","וַיֹּאמַר הַאַתָּה הוּא הַבָּא אוֹ אִם־נְחַכֶּה לְאַחֵר׃ ");
INSERT INTO hebsg_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","וַיַּעַן יֵשׁוּעַ וַיֹּאמֶר אֲלֵיהֶם לְכוּ וְהַגִּידוּ לְיוֹחָנָן אֵת אֲשֶׁר־שְׁמַעְתֶּם וְאֵת אֲשֶׁר־רְאִיתֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","עִוְרִים רֹאִים וּפִסְחִים הֹלְכִים מְצֹרָעִים נִרְפָּאִים וְחֵרְשִׁים שֹׁמְעִים מֵתִים קָמִים וַעֲנִיִּים מִתְבַּשְּׂרִים יְשׁוּעָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","וְאַשְׁרֵי הָאִישׁ אֲשֶׁר לֹא־יִכָּשֵׁל בִּי׃ ");
INSERT INTO hebsg_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","וּבְלֶכְתָּם הֵחֵל יֵשׁוּעַ לְדַבֵּר אֶל־הֲמוֹן הָעָם עַל־יוֹחָנָן מַה־זֶּה יְצָאתֶם הַמִּדְבָּרָה לִרְאוֹת הַאִם קָנֶה אֲשֶׁר יִנּוֹעַ מִפְּנֵי־רוּחַ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","אַךְ מַה־זֶּה יְצָאתֶם לִרְאוֹת הַאִם אִישׁ לָבוּשׁ בִּגְדֵי חֲמֻדוֹת הִנֵּה לֹבְשֵׁי חֲמֻדוֹת בְּבָתֵּי מְלָכִים הֵמָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","אַךְ מַה־זֶּה יְצָאתֶם הַאִם לִרְאוֹת אִישׁ נָבִיא הֵן אֲנִי אֹמֵר לָכֶם כִּי גַם־גָּדוֹל הוּא מִנָּבִיא׃ ");
INSERT INTO hebsg_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","זֶה הוּא אֲשֶׁר כָּתוּב עָלָיו הִנְנִי שֹׁלֵחַ מַלְאָכִי לְפָנֶיךָ וּפִנָּה דַרְכְּךָ לְפָנֶיךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","אָמֵן אֲנִי אֹמֵר לָכֶם לֹא קָם בֵּין יְלִידֵי אִשָּׁה גָּדוֹל מִיּוֹחָנָן הַמְטַבֵּל וְהַקָּטֹן בְּמַלְכוּת הַשָּׁמַיִם יִגְדַּל מִמֶּנּוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","וּמִימֵי יוֹחָנָן הַמְטַבֵּל עַד־הֵנָּה מַלְכוּת הַשָּׁמַיִם נִתְפְּשָׂה בְחָזְקָה וּזְרֹעֵי־כֹחַ יַחֲזִיקוּ בָהּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","כִּי כָל־הַנְּבִיאִים וְהַתּוֹרָה עַד־יוֹחָנָן נִבָּאוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","וְאִם־תֹּאבוּ לִשְׁמֹעַ זֶה הוּא אֵלִיָּהוּ הֶעָתִיד לָבֹא׃ ");
INSERT INTO hebsg_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","מִי אֲשֶׁר אָזְנַיִם לוֹ לִשְׁמֹעַ יִשְׁמָע׃ ");
INSERT INTO hebsg_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","וְאֶל־מִי אֲדַמֶּה אֶת־הַדּוֹר הַזֶּה נִדְמֶה הוּא לַיְלָדִים יֹשְׁבִים בִּשְׁוָקִים וְקֹרִאים לְרֵעֵיהֶם לֵאמֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","מְזַמְּרִים הָיִינוּ לָכֶם וְלֹא רְקַדְתֶּם מְקוֹנְנִים וְלֹא סְפַדְתֶּם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","כִּי־בָא יוֹחָנָן לֹא אֹכֵל וְלֹא שֹׁתֶה וְאָמְרוּ שֵׁד בּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","וּבֶן־הָאָדָם בָּא אֹכֵל וְשֹׁתֶה וְהֵם אֹמְרִים הִנֵּה אִישׁ זוֹלֵל וְסֹבֵא וְאֹהֵב לַמֹּכְסִים וְחַטָּאִים אַךְ הַחָכְמָה תִּצְטַדֵּק בְּבַנֶיהָ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","אָז הֵחֵל לָגֹל חֶרְפָּה עַל־הֶעָרִים אֲשֶׁר נַעֲשׂוּ בְתוֹכָן רֹב נִפְלְאוֹתָיו וְלֹא שָׁבוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","אוֹי לָךְ כּוֹרָזִין אוֹי לָךְ בֵּית־צָיְדָה כִּי לוּ נַעֲשׂוּ בְצוֹר וּבְצִידוֹן הַנִּפְלָאוֹת אֲשֶׁר נַעֲשׂוּ בְּתוֹכְכֶן כְּבָר שָׁבוּ בְּשַׂק וָאֵפֶר׃ ");
INSERT INTO hebsg_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","אֶפֶס אֲנִי אֹמֵר לָכֶן נָקֵל יִהְיֶה יוֹם הַמִּשְׁפָּט לְצוֹר וּלְצִידוֹן מֵאֲשֶׁר לָכֶן׃ ");
INSERT INTO hebsg_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","וְאַתְּ כְּפַר־נַחוּם אֲשֶׁר רוֹמַמְתְּ עַד־הַשָּׁמַיִם אֶל־שְׁאוֹל תּוּרָדִי כִּי לוּ נַעֲשׂוּ בִסְדֹם הַנִּפְלָאוֹת אֲשֶׁר נַעֲשׂוּ בְּתוֹכֵכִי וְעָמְדָה עַל־תִּלָּהּ עַד־הַיּוֹם הַזֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","אֶפֶס אֲנִי אֹמֵר לָכֶן נָקֵל יִהְיֶה יוֹם הַמִּשְׁפָּט לְאַדְמַת סְדֹם מֵאֲשֶׁר לָכֶן׃ ");
INSERT INTO hebsg_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","בָּעֵת הַהִיא עָנָה יֵשׁוּעַ וַיֹּאמַר אוֹדְךָ אָבִי אֲדוֹן הַשָּׁמַיִם וְהָאָרֶץ כִּי הִסְתַּרְתָּ אֶת־אֵלֶּה מֵעֵינֵי חֲכָמִים וּנְבוֹנִים וְגִלִּיתָ אֹתָם לְעוֹלָלִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","אָכֵן אָבִי כֵּן הָיָה הָרָצוֹן לְפָנֶיךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","הַכֹּל נִמְסַר בְּיָדִי מֵאֵת אָבִי וְאֵין אִישׁ יֹדֵעַ אֶת־הַבֵּן זוּלָתִי הָאָב וְאֶת־הָאָב אֵין אִישׁ יֹדֵעַ זוּלָתִי הַבֵּן וְהַהוּא אֲשֶׁר חָפֵץ בּוֹ הַבֵּן לְגַלּוֹתוֹ לוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","פְּנוּ־אֵלַי כָּל־עָמֵל וּמְסֻבָּל וַאֲנִי אֶתֵּן לָכֶם מַרְגּוֹעַ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","שְׂאוּ אֶת־עֻלִּי עֲלֵיכֶם וְלִמְדוּ מִמֶּנִּי כִּי־עָנָיו אָנֹכִי וְשַׁח לֵבָב וְתִמְצְאוּ מְנוּחָה לְנַפְשֹׁתֵיכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","כִּי עֻלִּי רַךְ וּמַשָּׂאִי קָל׃ ");
INSERT INTO hebsg_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","בָּעֵת הַהִיא הָלַךְ יֵשׁוּעַ בִּשְׂדֵה קָמָה בְּיוֹם הַשַּׁבָּת וַיִּרְעֲבוּ תַלְמִידָיו וַיָּחֵלּוּ לִקְטֹף מְלִילֹת בְּיָדָם וַיֹּאכֵלוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","וַיִּרְאוּ הַפְּרוּשִׁים וַיֹּאמְרוּ אֵלָיו הִנֵּה תַלְמִידֶיךָ עֹשִׂים אֵת אֲשֶׁר לֹא־יֵעָשֶׂה בַשַּׁבָּת׃ ");
INSERT INTO hebsg_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","וַיֹּאמֶר אֲלֵיהֶם הֲלֹא קְרָאתֶם מֶה עָשָׂה דָוִד כַּאֲשֶׁר רָעֵב הוּא וְאֵלֶּה אֲשֶׁר אִתּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","אֲשֶׁר בָּא אֶל־בֵּית הָאֱלֹהִים וַיֹּאכַל אֶת־לֶחֶם הַפָּנִים אֲשֶׁר עַל־פִּי הַתּוֹרָה לֹא יֹאכַל הוּא וּנְעָרָיו בִּלְתִּי אִם־הַכֹּהֲנִים לְבַדָּם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","וְגַם הֲלֹא קְרָאתֶם בַּתּוֹרָה כִּי הַכֹּהֲנִים בַּמִּקְדָּשׁ יְחַלְּלוּ אֶת־יוֹם הַשַּׁבָּת וְאֵין בָּהֶם עָוֹן׃ ");
INSERT INTO hebsg_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","וַאֲנִי אֹמֵר לָכֶם כִּי יֵשׁ בָּזֶה גָּדוֹל מִן־הַמִּקְדָּשׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","וְלוּ יְדַעְתֶּם מַה־זֶּה חֶסֶד חָפַצְתִּי וְלֹא זָבַח לֹא הִרְשַׁעְתֶּם אֶת־הַנְּקִיִּם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","כִּי בֶּן־הָאָדָם גַּם־אֲדוֹן הַשַּׁבָּת הוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","וַיַּעֲבֹר מִשָּׁם וַיָּבֹא אֶל־בֵּית־הַכְּנֵסֶת אֲשֶׁר לָהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","וְהִנֵּה־שָׁם אִישׁ אֲשֶׁר יָדוֹ יְבֵשָׁה וַיִּשְׁאָלֻהוּ לֵאמֹר הַאִם כַּתּוֹרָה לְרַפֵּא בַשַּׁבָּת לְמַעַן תִּמְצָא יָדָם לְשִׂטְנוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","וַיֹּאמֶר אֲלֵיהֶם מִי אִישׁ מִכֶּם אֲשֶׁר־לוֹ כַּבְשָׂה וְהִיא כִי תִפּוֹל אֶל־הַבּוֹר בַּשַּׁבָּת לֹא יַחֲזִיק בָּהּ וְיַעֲלֶנָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","וּמַה־יָּקָר עֵרֶךְ אָדָם מִן־הַכֶּבֶשׂ עַל־כֵּן כַּתּוֹרָה הוּא לַעֲשׂוֹת טוֹב בַּשַּׁבָּת׃ ");
INSERT INTO hebsg_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","אָז אָמַר אֶל־הָאִישׁ הוֹשֵׁט אֶת־יָדֶךָ וַיּוֹשֶׁט אֹתָהּ וַתָּשָׁב לְאֵיתָנָהּ כָּאַחֶרֶת׃ ");
INSERT INTO hebsg_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","וְהַפְּרוּשִׁים יָצְאוּ וַיָּשִׁיתוּ עֵצוֹת עָלָיו בַּמֶּה לְהַשְׁחִיתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","וַיֵּדַע יֵשׁוּעַ וַיִּפֶן וַיֵּלֶךְ מִשָּׁם וַיֵּלֶךְ אַחֲרָיו הֲמוֹן עַם רָב וַיְרַפֵּא אֶת־כֻּלָּם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","וַיָּעַד בָּם לְבִלְתִּי יְגַלּוּ אֹתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","לְמַלֹּאת אֵת אֲשֶׁר־דִּבֶּר יְשַׁעְיָהוּ הַנָּבִיא לֵאמֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","הֵן עַבְדִּי בָּחַרְתִּי בוֹ יְדִידִי רָצְתָה נַפְשִׁי נָתַתִּי רוּחִי עָלָיו מִשְׁפָּט לַגּוֹיִם יוֹצִיא׃ ");
INSERT INTO hebsg_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","לֹא יִצְעַק וְלֹא יִשָּׂא וְלֹא־יִשָּׁמַע בַּחוּץ קוֹלוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","קָנֶה רָצוּץ לֹא יִשְׁבּוֹר וּפִשְׁתָּה כֵהָה לֹא יְכַבֶּנָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","עַד־יוֹצִיא לָנֶצַח מִשְׁפָּט וְלִשְׁמוֹ גּוֹיִם יְיַחֵלוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","אָז הוּבָא לְפָנָיו אִישׁ עִוֵּר וְאִלֵּם אֲשֶׁר רוּחַ רָע דָּבַק בּוֹ וַיִּרְפָּאֵהוּ וְהָעִוֵּר הָאִלֵּם דִבֶּר וְרָאָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","וַיִּשְׁתָּאוּ כָּל־הֲמוֹן הָעָם וַיֹּאמְרוּ הֲכִי זֶה בֶּן־דָּוִד׃ ");
INSERT INTO hebsg_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","וְהַפְּרוּשִׁים שָׁמְעוּ וְאָמְרוּ אֵין זֶה מְגָרֵשׁ אֶת־הַשֵּׁדִים כִּי אִם בְּבַעַל־זְבוּב שַׂר הַשֵּׁדִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","וַיֵּדַע יֵשׁוּעַ אֶת־מַחְשְׁבֹתָם וַיֹּאמֶר אֲלֵיהֶם כָּל־מַמְלָכָה הַנִּפְלְגָה עַל־נַפְשָׁהּ תֶּחֱרָב וְכָל־עִיר וּבַיִת הַנִּפְלְגִים עַל־נַפְשָׁם לֹא יָקוּמוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","וְאִם־הַשָּׂטָן מְגָרֵשׁ אֶת־הַשָּׂטָן נִפְלָג הוּא עַל־נַפְשׁוֹ וְאֵיךְ תָּקוּם מַלְכוּתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","וְאִם־אֲנִי גֹרֵשׁ אֶת־הַשֵּׁדִים בְּבַעַל־זְבוּב בְּנֵיכֶם בְּמִי יְגָרְשׁוּ אֹתָם עַל־כֵּן הֵם יִהְיוּ שֹׁפְטֵיכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","אֶפֶס אִם בְּרוּחַ אֱלֹהִים אֲנִי גֹרֵשׁ אֶת־הַשֵּׁדִים מַלְכוּת אֱלֹהִים בָּאָה אֲלֵיכֶם אֶל־נָכוֹן׃ ");
INSERT INTO hebsg_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","אוֹ אֵיךְ יוּכַל אִישׁ לָבֹא בֵּית הַגִּבּוֹר וְלִשְׁלֹל אֶת־כֵּלָיו אִם־לֹא יֶאֱסֹר אֶת־הַגִּבּוֹר רִאשֹׁנָה וְאַחַר יִשְׁלֹל אֵת אֲשֶׁר בְּבֵיתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","מִי אֲשֶׁר אֵינֶנּוּ לִי לְצָרַי הוּא וּמִי אֲשֶׁר אֵינֶנּוּ מְאַסֵּף אִתִּי מְפַזֵּר הוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","עַל־כֵּן אֲנִי אֹמֵר לָכֶם כָּל־חֵטְא וְגִדּוּפָה יְכֻפְּרוּ לָאָדָם אֶפֶס הַמְגַדֵּף אֶת־הָרוּחַ לֹא יְכֻפַּר־לוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","וּמִי אֲשֶׁר יְדַבֵּר דָּבָר בְּבֶן־הָאָדָם יְכֻפַּר־לוֹ וּמִי אֲשֶׁר יְדַבֵּר בְּרוּחַ הַקֹּדֶשׁ לֹא יְכֻפַּר־לוֹ לֹא־בָעוֹלָם הַזֶּה וְלֹא־בָעוֹלָם הַבָּא׃ ");
INSERT INTO hebsg_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","אוֹ עֲשׂוּ אֶת־הָעֵץ טוֹב וּפִרְיוֹ טוֹב אוֹ עֲשׂוּ אֶת־הָעֵץ רָע וּפִרְיוֹ רָע כִּי בְּפִרְיוֹ נִכַּר הָעֵץ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","יַלְדֵי צִפְעֹנִים אֵיךְ תּוּכְלוּ לְדַבֵּר טֹבוֹת בְּרָעַתְכֶם כִּי־מִמְּלֹא הַלֵּב יַבִּיעַ הַפֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","אִישׁ־טוֹב מֵאוֹצָרוֹ לִבּוֹ הַטּוֹב יוֹצִיא טֹבוֹת וְאִישׁ־רָע מֵאוֹצָרוֹ הָרָע יוֹצִיא רָעוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","וַאֲנִי אֹמֵר לָכֶם כִּי עַל כָּל־שִׂיחַ תָּפֵל אֲשֶׁר יְבַטְּאוּ בְנֵי הָאָדָם יִתְּנוּ חֶשְׁבּוֹן בְּיוֹם הַמִּשְׁפָּט׃ ");
INSERT INTO hebsg_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","כִּי בִּדְבָרֶיךָ תִּצָּדֵק וּבִדְבָרֶיךָ תֶּאְשָׁם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","וַיַּעֲנוּ אֲנָשִׁים מִן־הַסּוֹפְרִים וְהַפְּרוּשִׁים לֵאמֹר רַבִּי חָפַצְנוּ לִרְאוֹת אוֹת מֵאוֹתֹתֶיךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","וַיַּעַן וַיֹּאמֶר אֲלֵיהֶם דּוֹר רָע וּמְנָאֵף מְבַקֵּשׁ אוֹת וְאוֹת לֹא יִנָּתֶן־לוֹ זוּלָתִי אוֹת יוֹנָה הַנָּבִיא׃ ");
INSERT INTO hebsg_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","כִּי כַּאֲשֶׁר הָיָה יוֹנָה בִּמְעֵי הַדָּג שְׁלֹשָׁה יָמִים וּשְׁלֹשָׁה לֵילוֹת כֵּן יִהְיֶה בֶן־הָאָדָם בְּלֵב הָאָרֶץ שְׁלֹשָׁה יָמִים וּשְׁלֹשָׁה לֵילוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","אַנְשֵׁי נִינְוֵה יָקוּמוּ בַמִּשְׁפָּטּ עִם־הַדּוֹר הַזֶּה וְיַרְשִׁיעוּ אֹתוֹ כִּי שָׁבוּ בִּקְרִיאַת יוֹנָה וְהִנֵּה יֶשְׁנוֹ בָזֶה גָּדוֹל מִיּוֹנָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","מַלְכַּת תֵּימָן תָּקוּם בַּמִּשְׁפָּט עִם־הַדּוֹר הַזֶּה וְתַרְשִׁיעַ אֹתוֹ כִּי בָאָה מִקְצוֹת הָאָרֶץ לִשְׁמֹעַ חָכְמַת שְׁלֹמֹה וְהִנֵּה יֶשְׁנוֹ בָזֶה גָּדוֹל מִשְּׁלֹמֹה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","וְרוּחַ הַטֻּמְאָה בְּצֵאתָהּ מִן־הָאָדָם תְּשׁוֹטֵט בְּאֶרֶץ תַּלְאוּבֹת תְּבַקֵּשׁ וְלֹא־תִמְצָא מַרְגֵּעָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","אָז תֹּאמַר אָשׁוּבָה אֶל־מִשְׁכָּנִי אֲשֶׁר יָצָאתִי מִשָּׁם וּבְשׁוּבָהּ תִּמְצָאֶנּוּ רֵק מִבְּלִי יֹשֵׁב וּמְנֻקֶּה וּמְפֹאָר׃ ");
INSERT INTO hebsg_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","אָז תֵּלֵךְ וְלָקְחָה לָּהּ שֶׁבַע רוּחוֹת אֲחֵרוֹת רָעוֹת מִמֶּנָּה וּבָאוּ וְשָׁכְנוּ שָׁם וְהָיְתָה אַחֲרִית הָאִישׁ הַהוּא רָעָה מֵרֵאשִׁיתוֹ וְכֵן יִהְיֶה לַדּוֹר הָרָע הַזֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","עוֹדֶנוּ מְדַבֵּר אֶל־הֲמוֹן הָעָם וְהִנֵּה אִמּוֹ וְאֶחָיו עָמְדוּ בַחוּץ וּמְבַקְשִׁים לְדַבֵּר אִתּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","וַיֻגַּד לוֹ הִנֵּה אִמְּךָ וְאַחֶיךָ עֹמְדִים בַּחוּץ וּמְבַקְשִׁים לְדַבֵּר אִתָּךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","וַיַּעַן וַיֹּאמֶר אֶל־הַמַּגִּיד לוֹ מִי אִמִּי וּמִי אֶחָי׃ ");
INSERT INTO hebsg_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","וַיֵּט אֶת־יָדוֹ עַל־תַּלְמִידָיו וַיֹּאמַר הִנֵּה אִמִּי וְאֶחָי׃ ");
INSERT INTO hebsg_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","כִּי אִישׁ אִישׁ אֲשֶׁר יַעֲשֶׂה רְצוֹן אָבִי בַּשָּׁמָיִם הוּא אָחִי וַאֲחֹתִי וְאִמִּי׃ ");
INSERT INTO hebsg_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","בַּיּוֹם הַהוּא יָצָא יֵשׁוּעַ מִן־הַבָּיִת וַיֵּשֶׁב עַל־שְׂפַת הַיָּם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","וַהֲמוֹן עַם רָב נִקְהֲלוּ אֵלָיו וַיֵּרֶד וַיֵּשֶׁב בָּאֳנִיָּה וְכָל־הָעָם עֹמְדִים עַל־הַחוֹף׃ ");
INSERT INTO hebsg_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","וַיִּשָּׂא דְבָרָיו בִּמְשָׁלִים רַבִּים וַיֹּאמַר הִנֵּה הַזּוֹרֵעַ יָצָא לִזְרֹעַ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","וּבְזָרְעוֹ פִּזַּר מִן־הַזֶּרַע עַל־יַד הַדָּרֶךְ וַיָּבֹא עוֹף הַשָּׁמַיִם וַיֹּאכְלֶנּוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","וְיֵשׁ מִן־הַזֶּרַע אֲשֶׁר נָפַל עַל־אַדְמַת סֶלַע וְלֹא הָיָה שָׁם דֵּי אֲדָמָה וַיְמַהֵר לִצְמֹחַ מִבְּלִי אֲשֶׁר הָיָה לוֹ עֹמֶק אֲדָמָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","וַיְהִי כִּזְרֹחַ הַשֶּׁמֶשׁ וַיִּצָּרֵב וַיִּיבָשׁ כִּי לֹא הָיָה־לוֹ שֹׁרֶשׁ לְמָטָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","וְיֵשׁ אֲשֶׁר נָפַל אֶל־הַקֹּצִים וַיַּעֲלוּ הַקֹּצִים וַיְבַלְּעוּ אֹתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","וְיֵשׁ אֲשֶׁר נָפַל עַל־חֶלְקָה טוֹבָה וַיַּעַשׂ תְּבוּאָה זֶה מֵאָה שְׁעָרִים וְזֶה שִׁשִּׁים שְׁעָרִים וְזֶה שְׁלֹשִׁים שְׁעָרִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","מִי אֲשֶׁר אָזְנַיִם לוֹ לִשְׁמֹעַ יִשְׁמָע׃ ");
INSERT INTO hebsg_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","וַיִּגְּשׁוּ תַלְמִידָיו וַיֹּאמְרוּ אֵלָיו מַדּוּעַ תְּמַשֵּׁל לָהֶם מְשָׁלִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","וַיַּעַן וַיֹּאמֶר אֲלֵיהֶם כִּי לָכֶם נִתַּן לָדַעַת רָזֵי מַלְכוּת הַשָּׁמָיִם וְלָהֶם לֹא נִתָּן׃ ");
INSERT INTO hebsg_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","כִּי מִי אֲשֶׁר יֶשׁ־לוֹ יֻתַּן לוֹ וְיַעְדִּיף וּמִי אֲשֶׁר אֵין־לוֹ יֻקַּח מִמֶּנּוּ גַּם אֶת־אֲשֶׁר לוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","עַל־כֵּן מְשָׁלִים אֶמְשֹׁל לָהֶם כִּי בִרְאֹתָם לֹא יִרְאוּ וּבְשָׁמְעָם לֹא יִשְׁמְעוּ וְלֹא יָבִינוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","וְהוּקַם בָּם דְּבַר הַנְּבוּאָה מִפִּי יְשַׁעְיָהוּ לֵאמֹר שִׁמְעוּ שָׁמוֹעַ וְאַל־תָּבִינוּ וּרְאוּ רָאוֹ וְאַל־תֵּדָעוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","הַשְׁמֵן לֵב־הָעָם הַזֶּה וְאָזְנָיו הַכְבֵּד וְעֵינָיו הָשַׁע פֶּן־יִרְאֶה בְעֵינָיו וּבְאָזְנָיו יִשְׁמָע וּלְבָבוֹ יָבִין וָשָׁב וְרָפָא לוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","וְאַתֶּם אַשְׁרֵי עֵינֵיכֶם כִּי רָאוּ וְאָזְנֵיכֶם כִּי שָׁמֵעוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","כִּי־אָמֵן אֲנִי אֹמֵר לָכֶם נְבִיאִים וְצַדִּיקִים רַבִּים נִכְסְפוּ לִרְאוֹת אֵת אֲשֶׁר אַתֶּם רֹאִים וְלֹא רָאוּ וְלִשְׁמֹעַ אֵת אֲשֶׁר אַתֶּם שֹׁמְעִים וְלֹא שָׁמֵעוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","עַל־כֵּן שִׁמְעוּ־נָא אַתֶּם אֶת מְשַׁל הַזּוֹרֵעַ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","כָּל־הַשֹּׁמֵעַ דְּבַר הַמַּלְכוּת וְלֹא יִתְבּוֹנֶן־בּוֹ וּבָא הָרָע וְחָטַף אֵת אֲשֶׁר נִזְרַע בִּלְבָבוֹ זֶה הוּא הַזָּרוּעַ עַל־יַד הַדָּרֶךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","וְהַנִּזְרָע עַל־אַדְמַת סָלַע זֶה הוּא הַשֹּׁמֵעַ אֶת־הַדָּבָר וְעַד־מְהֵרָה יְקַבְּלֶנּוּ בְּשִׂמְחָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","אֶפֶס כִּי אֵין־לוֹ שֹׁרֶשׁ בְּנַפְשׁוֹ וּבִן רֶגַע הוּא וְכִי תִקְרֶה כָל־צָרָה וְרָדְפוּ אֹתוֹ עַל־דְּבַר אֱמוּנָתוֹ יִכָּשֵׁל כְּרָגַע׃ ");
INSERT INTO hebsg_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","וְהַנִּזְרָע אֶל־הַקֹּצִים זֶה הַשֹּׁמֵעַ אֶת־הַדָּבָר וְדַאֲגַת הָעוֹלָם הַזֶּה וְנִכְלֵי הָעֹשֶר מְבַלְּעִים אֵת־הַדָּבָר וְלֹא יַעֲשֶׂה־צֶּמַח׃ ");
INSERT INTO hebsg_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","וְהַנִּזְרָע עַל־הַחֶלְקָה הַטּוֹבָה הוּא הַשֹּׁמֵעַ אֶת־הַדָּבָר וּמִתְבּוֹנֶן־בּוֹ וְעֹשֶׂה פְרִי תְבוּאָה וְנֹתֵן זֶה מֵאָה שְׁעָרִים וְזֶה שִׁשִּׁים שְׁעָרִים וְזֶה שְׁלֹשִׁים שְׁעָרִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","וַיִּשָּׂא לִפְנֵיהֶם מָשָׁל אַחֵר וַיֹּאמַר דָּמְתָה מַלְכוּת הַשָּׁמַיִם לְאִישׁ הַזּוֹרֵעַ זֶרַע טוֹב בְּשָׂדֵהוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","וּבִהְיוֹת אֲנָשָׁיו יְשֵׁנִים בָּא אֹיְבוֹ וַיִּזְרַע זוֹנִין בְּתוֹךְ הַחִטִּים וַיֵּלַךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","וְכַאֲשֶׁר צָץ הַקָּנֶה וְהַחִטָּה אָבִיב נִרְאוּ אָז גַּם־הַזּוֹנִין׃ ");
INSERT INTO hebsg_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","וַיִּגְּשׁוּ הָעֲבָדִים אֶל־אֲדֹנֵיהֶם וַיֹּאמְרוּ אֲדֹנֵינוּ הֲלֹא־זֶרַע טוֹב זָרַעְתָּ בְשָׂדֶךָ וּמֵאַיִן שָׁם הַזּוֹנִין׃ ");
INSERT INTO hebsg_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","וַיֹּאמֶר אֲלֵיהֶם אִישׁ אֹיֵב עָשָׂה זֹאת וַיֹּאמְרוּ אֵלָיו הָעֲבָדִים הֲתַחְפֹּץ כִּי־נֵלֵךְ לַעֲקוֹר אֹתָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","וַיֹּאמֶר לֹא כִּי־בְעוֹד תְּעַקְּרוּ אֶת־הַזּוֹנִין פֶּן־תְּשָׁרְשׁוּ גַּם־הַחִטִּים עִמָּהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","הַנִּיחוּ לָהֶם וְגָדְלוּ שְׁנֵיהֶם יַחְדָּו עַד־הַקָּצִיר וּלְעֵת הַקָּצִיר אֹמַר לַקּוֹצְרִים לִקְּטוּ אֶת־הַזּוֹנִין רִאשֹׁנָה וְאַלְּמוּ אֹתָם לַאֲלֻמִּים לְשָׂרְפָם וְאֶת־הַחִטִּים אִסְפוּ אֶל־גָּרְנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","וַיִּשָּׂא לִפְנֵיהֶם מָשָׁל אַחֵר וַיֹּאמַר דָּמְתָה מַלְכוּת הַשָּׁמַיִם לְגַרְגַּר חַרְדָּל אֲשֶׁר לָקַח אִישׁ וַיִּזְרַע בְּשָׂדֵהוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","הֲלֹא קָטֹן הוּא מִכָּל־זֶרַע אַךְ כַּאֲשֶׁר יִצְמַח יִגְדַּל מִכָּל־יֶרֶק וְהָיָה לְעֵץ עַד־אֲשֶׁר יָבֹא עוֹף הַשָּׁמַיִם וְקִנְּנוּ בַּעֲנָפָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","וַיְמַשֵּׁל לָהֶם מָשָׁל אַחֵר לֵאמֹר דָּמְתָה מַלְכוּת הַשָּׁמַיִם לִשְׂאֹר אֲשֶׁר לָקְחָה אִשָּׁה וַתָּלָשׁ בִּשְׁלֹשׁ סְאִים קֶמַח עַד־אֲשֶׁר חָמְצָה כָּל־הָעֲרִיסָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","כָּל־אֵלֶּה דִּבֶּר יֵשׁוּעַ אֶל־הֲמוֹן הָעָם בִּמְשָׁלִים וּבִבְלִי מָשָׁל לֹא דִּבֶּר אֲלֵיהֶם דָּבָר׃ ");
INSERT INTO hebsg_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","לְמַלֹּאת אֵת אֲשֶׁר דִּבֶּר הַנָּבִיא לֵאמֹר אֶפְתְּחָה בְמָשָׁל פִּי אַבִּיעָה חִידוֹת מִנִּי־קֶדֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","אָז שִׁלַּח יֵשׁוּעַ אֶת־הֲמוֹן הָעָם וַיָּבֹא הַבָּיְתָה וַיִּגְּשׁוּ אֵלָיו תַּלְמִידָיו וַיֹּאמְרוּ בָּאֶר־נָא לָנוּ אֶת־מְשַׁל הַזּוֹנִין בַּשָּׂדֶה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","וַיַּעַן וַיֹּאמֶר אֲלֵיהֶם הַזּוֹרֵעַ הַזֶּרַע הַטּוֹב הוּא בֶּן־הָאָדָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","וְהַשָּׂדֶה הוּא הָעוֹלָם וְהַזֶּרַע הַטּוֹב בְּנֵי הַמַּלְכוּת וְהַזּוֹנִין בְּנֵי הָרַע הֵמָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","הָאֹיֵב הַזּוֹרֵעַ אֹתָם הוּא הַשָּׂטָן הַקָּצִיר קֵץ הָעוֹלָם וְהַקֹּצְרִים הֵם הַמַּלְאָכִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","וְכַאֲשֶׁר הַזּוֹנִין יְלֻקְּטוּ וְהָיוּ לְמַאֲכֹלֶת אֵשׁ כֵּן יִהְיֶה בְּקֵץ הָעוֹלָם הַזֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","בֶּן־הָאָדָם יִשְׁלַח אֶת־מַלְאָכָיו וְהֵסִירוּ מִתּוֹךְ מַלְכוּתוֹ כָּל־מַכְשֵׁלָה וְכָל־עֹשֶׂה עַוְלָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","וְהִשְׁלִיכוּ אֹתָם אֶל־כִּבְשַׁן אֵשׁ שָׁם יִהְיֶה בְכִי וַחֲרֹק שִׁנָּיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","וְהַצַּדִּיקִים יַזְהִירוּ אָז כַּשֶּׁמֶשׁ בְּמַלְכוּת אֲבִיהֶם מִי אֲשֶׁר אָזְנַיִם לוֹ לִשְׁמֹעַ יִשְׁמָע׃ ");
INSERT INTO hebsg_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","עוֹד דָּמְתָה מַלְכוּת הַשָּׁמַיִם לְאוֹצָר טָמוּן בַּשָּׁדֶה אֲשֶׁר יִמְצָאֵהוּ אִישׁ וְיַצְפִּנֵהוּ וּבְשִׂמְחָתוֹ יֵלֵךְ וְיִמְכֹּר אֶת־כָּל־אֲשֶׁר־לוֹ וְקָנָה לוֹ אֶת־הַשָּׂדֶה הַהוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","עוֹד דָּמְתָה מַלְכוּת הַשָּׁמָיִם לְאִישׁ סוֹחֵר הַמְבַקֵּשׁ פְּנִינִים יְקָרוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","וּבְמָצְאוֹ פְּנִינָה אַחַת יִקְרַת־עֶרֶךְ עַד־מְאֹד יֵלֵךְ וְיִמְכֹּר אֶת־כָּל־אֲשֶׁר־לוֹ וְיִקְנֶהָ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","עוֹד דָּמְתָה מַלְכוּת הַשָּׁמַיִם לְמִכְמֹרֶת פְּרוּשָׂה עַל־פְּנֵי הַיָּם אֲשֶׁר יֵאָסְפוּ בָהּ מִמִּינִים שׁוֹנִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","וּבְהִמָּלְאָהּ יִמְשְׁכוּ אֹתָהּ אֶל־הַחוֹף וְיֵשְׁבוּ וְיִבְחֲרוּ אֶת־הַטּוֹבִים לְשׂוּמָם אֶל־הַכֵּלִים וְאֶת־הָרָעִים יַשְׁלִיכוּ חוּצָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","כָּכָה יִהְיֶה בְּקֵץ הָעוֹלָם כִּי הַמַּלְאָכִים יָבֹאוּ וְהִבְדִּילוּ אֶת־הָרְשָׁעִים מִתּוֹךְ הַצַּדִּיקִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","וְהִשְׁלִיכוּ אֹתָם אֶל־כִּבְשַׁן אֵשׁ שָׁם יִהְיֶה בְכִי וַחֲרֹק שִׁנָּיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","וַיֹּאמֶר אֲלֵיהֶם יֵשׁוּעַ הֲכִי בַנְתֶּם כָּל־אֵלֶּה וַיֹּאמְרוּ הֵן אֲדֹנֵּנוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","וַיֹּאמֶר אֲלֵיהֶם לָכֵן כָּל־סוֹפֵר מַשְׂכִּיל לְמַלְכוּת הַשָּׁמַיִם נִדְמֶה לְאִישׁ בַּעַל־הַבַּיִת הַמּוֹצִיא מֵאוֹצָרוֹ חֲדָשׁוֹת וְגַם־יְשָׁנוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","וַיְהִי כְּכַלּוֹת יֵשׁוּעַ אֶת־הַמְּשָׁלִים הָאֵלֶּה וַיַּעֲבֹר מִשָּׁם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","וַיָּבֹא אֶל־אַרְצוֹ וַיּוֹרֶה לָהֶם בְּבֵית הַכְּנֵסֶת וְהֵמָּה כֵּן תָּמְהוּ לֵאמֹר מֵאַיִן לָזֶה הַחָכְמָה וְהַנִּפְלָאוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","הַאֵין זֶה בֶּן־הֶחָרָשׁ הֲכִי לֹא נִקְרֵאת אִמּוֹ מִרְיָם וְאֶחָיו יַעֲקֹב וְיוֹסֵף שִׁמְעוֹן וִיהוּדָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","וְאַחְיֹתָיו הֲלֹא הֵנָּה כֻּלָּן אִתָּנוּ וּמֵאַיִן לוֹ כָּל־אֵלֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","וַיְהִי לָהֶם לְאֶבֶן נָגֶף וְיֵשׁוּעַ אָמַר אֲלֵיהֶם אֵין נָבִיא בִּבְלִי כָבוֹד זוּלָתִי בְּאֶרֶץ מוֹלַדְתּוֹ וּבְתוֹךְ בֵּיתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","וְלֹא־פָעַל שָׁם נִפְלָאוֹת רַבּוֹת מִפְּנֵי חֹסֶר אֱמוּנָתָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","בָּעֵת הַהִיא שָׁמַע הוֹרְדוֹס טֶטְרַרְךְ אֶת־שֵׁמַע יֵשׁוּעַ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","וַיֹּאמֶר אֶל־עֲבָדָיו הֲלֹא הוּא יוֹחָנָן הַמְטַבֵּל הוּא קָם מִן־הַמֵּתִים עַל־כֵּן גָּבְרָה יָדוֹ לַעֲשׂוֹת נִפְלָאוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","כִּי הוֹרְדוֹס תָּפַשׂ אֶת־יוֹחָנָן וַיַּאַסְרֵהוּ וְנָתוֹן אֹתוֹ בַּמִּשְׁמָר עַל־דְּבַר הוֹרוֹדְיָה אֵשֶׁת פִּילִפּוֹס אָחִיו׃ ");
INSERT INTO hebsg_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","כִּי הוֹכִיחוֹ יוֹחָנָן בְּאָמְרוֹ לֹא כַתּוֹרָה לָקַחַת אֹתָהּ לְךָ לְאִשָּׁה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","וַיְבַקֵּשׁ הֲמִיתוֹ אֶפֶס כִּי יָרֵא אֶת־הָעָם אֲשֶׁר חִשְּׁבוּ אֹתוֹ לְנָבִיא׃ ");
INSERT INTO hebsg_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","וַיְהִי בְּיוֹם הֻלֶּדֶת אֶת־הוֹרְדוֹס וַתִּרְקֹד בַּת־הוֹרוֹדְיָה בְּמָחוֹל לִפְנֵיהֶם וַתִּיטַב בְּעֵינֵי הוֹרְדוֹס׃ ");
INSERT INTO hebsg_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","וּבִגְלַל הַדָּבָר הַזֶּה נִשְׁבַּע לָתֶת־לָהּ כָּל־אֲשֶׁר תִּשְׁאַל מִמֶּנּוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","וְהִיא כַּאֲשֶׁר שׂוּמָה בְּפִיהָ מֵאִמָּהּ אָמְרָה אֵלָיו תְּנָה־לִּי בַּזֶּה בַּסֵּפֶל אֶת־רֹאשׁ יוֹחָנָן הַמְטַבֵּל׃ ");
INSERT INTO hebsg_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","וַיֵּצֶר לַמֶּלֶךְ מְאֹד וְאַךְ בַּעֲבוּר שְׁבוּעָתוֹ וְהַיֹּשְׁבִים בִּמְסִבּוֹ צִוָּה לְתִתּוֹ לָהּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","וַיִּשְׁלַח וַיִּשָּׂא אֶת־רֹאשׁ יוֹחָנָן מֵעָלָיו בַּמִּשְׁמָר׃ ");
INSERT INTO hebsg_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","וַיּוּבָא אֶת־רֹאשׁוֹ בַּסֵּפֶל וַיִּנָּתֵן לִידֵי הַנַּעֲרָה וְהִיא הֱבִיאַתְהוּ אֶל־אִמָּהּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","וַיָּבֹאוּ תַלְמִידָיו וַיִּשְׂאוּ אֶת־הֶחָלָל וַיִּקְבְּרֻהוּ וַיָּבֹאוּ וַיַּגִּידוּ לְיֵשׁוּעַ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","כִּשְׁמֹעַ יֵשׁוּעַ אֶת־הַדָּבָר הַזֶּה וַיַּעֲבֹר מִשָּׁם בָּאֳנִיָּה וַיָּבֹא אֶל־מָקוֹם שָׁמֵם לְבַדּוֹ וַיִּשְׁמְעוּ הֲמוֹן הָעָם וַיֵּלְכוּ אַחֲרָיו מִן־הֶעָרִים דֶּרֶךְ הַיַּבָּשָׁה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","וַיֵּצֵא יֵשׁוּעַ וַיַּרְא הֲמוֹן עַם־רָב וְרַחֲמָיו נִכְמְרוּ עֲלֵיהֶם וַיִּרְפָּא אֶת־חוֹלֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","וַיְהִי לִפְנוֹת־עֶרֶב וַיִּגְּשׁוּ אֵלָיו תַּלְמִידָיו וַיֹּאמְרוּ הַמָּקוֹם שָׁמֵם וְהַיּוֹם רַד מְאֹד שַׁלַּח אֶת־הֲמוֹן הָעָם וְיֵלְכוּ אֶל־הַכְּפָרִים לִקְנוֹת לָהֶם אֹכֶל׃ ");
INSERT INTO hebsg_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","וַיֹּאמֶר אֲלֵיהֶם יֵשׁוּעַ לֹא הֻטַּל עֲלֵיהֶם לָלֶכֶת לִקְנוֹת תְּנוּ לָהֶם אַתֶּם לֶאֱכֹל׃ ");
INSERT INTO hebsg_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","וַיֹּאמְרוּ אֵלָיו לֹא־נִמְצָא אִתָּנוּ פֹּה כִּי אִם־חָמֵשׁ כִּכְּרוֹת־לֶחֶם וְדָגִים שְׁנָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","וַיֹּאמַר הֲבִיאוּם אֵלַי הֵנָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","וַיְצַו אֶת־הֲמוֹן הָעָם לָשֶׁבֶת שָׁם בִּנְאוֹת דֶּשֶׁא וַיִּקַּח אֶת־חֲמֵשֶׁת הַלֶּחֶם וְאֶת־שְׁנֵי־הַדָּגִים וַיִּשָּׂא עֵינָיו לַמָּרוֹם וַיְבָרֶךְ וַיִּפְרֹס וַיִּתֵּן אֶת־הַלֶּחֶם אֶל־הַתַּלְמִידִים וְהַתַּלְמִידִים אֶל־הֲמוֹן הָעָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","וַיֹּאכְלוּ כֻלָּם וַיִּשְׂבָּעוּ וַיִּשְׂאוּ אֶת־הַפְּתוֹתִים הַנּוֹתָרִים שְׁנֵים עָשָׂר סַלִּים מְלֵאִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","וְהָאֹכְלִים הָיוּ כַּחֲמֵשֶׁת אַלְפֵי אִישׁ מִלְּבַד נָשִׁים וָטָף׃ ");
INSERT INTO hebsg_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","וַיֶּחֱזַק יֵשׁוּעַ עַל־תַּלְמִידָיו לְמַהֵר לָרֶדֶת בָּאֳנִיָּה וְלַעֲבֹר לְפָנָיו אֶל־עֵבֶר הַיָּם עַד כִּי יְשַׁלַּח אֶת־הֲמוֹן הָעָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","וַיְהִי בְּשַׁלְּחוֹ אֶת־הֲמוֹן הָעָם וַיַּעַל אֶל־הָהָר בָּדָד לְהִתְפַּלֵּל וַיְהִי־עֶרֶב וַיִּוָּתֵר שָׁם לְבַדּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","וְהָאֳנִיָּה בָאָה אָז בְּלֵב הַיָּם בְּצָרָה גְדוֹלָה מִפְּנֵי מִשְׁבָּרָיו כִּי נָשַׁף הָרוּחַ לִקְרָאתָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","וַיְהִי בְּאַשְׁמֻרָה הָרְבִיעִית בַּלָּיְלָה וַיָּבֹא אֲלֵיהֶם יֵשׁוּעַ דֹּרֵךְ עַל־פְּנֵי הַיָּם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","כִּרְאוֹת אֹתוֹ הַתַּלְמִידִים דֹּרֵךְ עַל־פְּנֵי הַיָּם וַיָּחִילוּ וַיֹּאמְרוּ כִּי רוּחַ הוּא בֶחָזוֹן וַיִּצְעֲקוּ מִפָּחַד׃ ");
INSERT INTO hebsg_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","וַיְמַהֵר יֵשׁוּעַ וַיְדַבֵּר עַל־לִבָּם וַיֹּאמַר חִזְקוּ אֲנִי הוּא אַל־תִּירָאוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","וַיַּעַן פֶּטְרוֹס וַיֹּאמֶר אֵלָיו אֲדֹנִי אִם־אַתָּה הוּא צַו וְאָבֹא אֵלֶיךָ עַל־פְּנֵי הַמָּיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","וַיֹּאמֶר בֹּא וַיֵּרֶד פֶּטְרוֹס מִן־הָאֳנִיָּה וַיֵּלֶךְ עַל־פְּנֵי הַמַּיִם לָבֹא אֶל־יֵשׁוּעַ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","וּבִרְאֹתוֹ אֶת־הָרוּחַ חֲזָקָה וַיִּירָא וַיָּחֶל לִטְבֹּעַ וַיִּצְעַק לֵאמֹר אֲדֹנִי הוֹשִׁיעָה נָּא׃ ");
INSERT INTO hebsg_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","וַיְמַהֵר יֵשׁוּעַ וַיִּשְׁלַח יָדוֹ וַיַּחֲזֶק־בּוֹ וַיֹּאמֶר אֵלָיו קְטֹן אֱמוּנָה לָמָּה־זֶּה פָּסַחְתָּ עַל־שְׁתֵּי סְעִפִּים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","וַיָּבֹאוּ אֶל־הָאֳנִיָּה וַיִּשְׁתֹּק הָרוּחַ מִזַּעְפּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","וְנִגְּשׁוּ וַיִּשְׁתַּחֲווּ־לוֹ הָאֲנָשִׁים אֲשֶׁר בָּאֳנִיָּה לֵאמֹר אָכֵן בֶּן־אֱלֹהִים אָתָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","וַיַּעַבְרוּ וַיָּבֹאוּ אַרְצָה גְּנֵיסָרֶת׃ ");
INSERT INTO hebsg_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","וַיַּכִּירוּ אֹתוֹ אַנְשֵׁי הַמָּקוֹם הַהוּא וַיִּשְׁלְחוּ אֶל־כָּל־הַכִּכָּר מִסָּבִיב וַיָּבִיאוּ אֵלָיו אֵת כָּל־חוֹלֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","וַיִּתְחַנְּנוּ אֵלָיו לָתֵת לָהֶם לָגַעַת בִּכְנַף בִּגְדוֹ וַיְהִי כֹּל אֲשֶׁר נָגַע־בּוֹ וָחָי׃ ");
INSERT INTO hebsg_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","אָז בָּאוּ לִפְנֵי יֵשׁוּעַ פְּרוּשִׁים וְסוֹפְרִים מִירוּשָׁלַיִם לֵאמֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","מַדּוּעַ יַעַזְבוּ תַלְמִידֶיךָ אֵת קַבָּלַת הַזְּקֵנִים כִּי לֹא יִרְחֲצוּ אֶת־יְדֵיהֶם לַאֲכִילַת לָחֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","וַיַּעַן וַיֹּאמֶר אֲלֵיהֶם וּמַדּוּעַ תַּעַזְבוּ גַם־אַתֶּם אֶת־מִצְוַת אֱלֹהִים בַּעֲבוּר קַבָּלַתְכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","כִּי אֱלֹהִים צִוָּה לֵאמֹר כַּבֵּד אֶת־אָבִיךָ וְאֶת־אִמֶּךָ וּמְקַלֵּל אָבִיו וְאִמּוֹ מוֹת יוּמָת׃ ");
INSERT INTO hebsg_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","וְאַתֶּם אֹמְרִים אִישׁ כִּי־יֹאמַר לְאָבִיו אוֹ לְאִמּוֹ קָרְבָּן כָּל־הֲנָאָה אֲשֶׁר תֶּהֱנֶה מִמֶּנִּי הֲרֵי זֶה נֶדֶר׃ ");
INSERT INTO hebsg_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","וְאֵין עָלָיו לְכַבֵּד עוֹד אֶת־אָבִיו וְאֶת־אִמּוֹ וְהֵפַרְתֶּם אֶת־מִצְוַת אֱלֹהִים בְּקַבָּלַתְכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","חַנְפֵי־לֵב הֵיטֵב נִבָּא עֲלֵיכֶם יְשַׁעְיָהוּ לֵאמֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","הָעָם הַזֶּה בְּפִּיו וּבִשְׂפָתָיו כִּבְּדוּנִי וְלִבּוֹ רִחַק מִמֶּנִּי׃ ");
INSERT INTO hebsg_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","וְתֹהוּ יִרְאָתָם אֹתִי מִצְוֹת אֲנָשִׁים מְלַמְּדִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","וַיִּקְרָא אֶל־הָעָם וַיֹּאמֶר אֲלֵיהֶם שִׁמְעוּ וְהַשְׂכִּילוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","אֲשֶׁר יָבֹא אֶל־תּוֹךְ הַפֶּה לֹא יְטַמֵּא אֶת־הָאָדָם אֶפֶס אֲשֶׁר יֵצֵא מִתּוֹךְ הַפֶּה הוּא יְטַמֵּא אֶת־הָאָדָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","וַיִּגְּשׁוּ אֵלָיו תַּלְמִידָיו וַיֹּאמְרוּ הֲיָדַעְתָּ כִּי נִכְשְׁלוּ הַפְּרוּשִׁים בְּשָׁמְעָם הַדָּבָר הַזֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","וַיַּעַן וַיֹּאמַר כָּל־מַטָּע אֲשֶׁר אָבִי בַּשָּׁמַיִם לֹא נְטָעוֹ יְשֹׁרָשׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","הַנִּיחוּ לָהֶם הֵם עִוְרִים מְנַהֲלִים לְעִוְרִים וְכִי עִוֵּר מְנַהֵל לְעִוֵּר שְׁנֵיהֶם יִפְּלוּ אֶל־הַבּוֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","וַיַּעַן פֶּטְרוֹס וַיֹּאמֶר אֵלָיו בָּאֶר־לָנוּ אֶת־הַמָּשָׁל הַזֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","וַיֹּאמַר יֵשׁוּעַ הֲכִי גַם־אַתֶּם עוֹד בִּבְלִי בִינָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","הֲלֹא תַשְׂכִּילוּ כִּי כָל־אֲשֶׁר יָבֹא אֶל־תּוֹךְ הַפֶּה יֵרֵד אֶל־הַכָּרֵשׂ וּמִשָּׁם יֵצֵא הַפַּרְשְׁדֹנָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","אַךְ הַיֹּצֵא מִתּוֹךְ הַפֶּה יָבֹא מִתּוֹךְ הַלֵּב וְהוּא יְטַמֵּא אֶת־הָאָדָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","כִּי מִתּוֹךְ הַלֵּב יֵצְאוּ יִצְרֵי מַחְשְׁבוֹת רָעוֹת רָצֹחַ נָאֹף וְזָנֹה גָּנֹב עֵדוּת שֶׁקֶר וְגִדּוּפִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","אֵלֶּה הֵם אֲשֶׁר יְטַמְּאוּ אֶת־הָאָדָם אַךְ אָכוֹל בְּיָדַיִם אֲשֶׁר לֹא רֻחֲצוּ לֹא יְטַמֵּא אֶת־הָאָדָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","וַיֵּצֵא יֵשׁוּעַ מִשָּׁם וַיָּבֹא אֶל־גְּלִילוֹת צוֹר וְצִידוֹן׃ ");
INSERT INTO hebsg_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","וְהִנֵּה אִשָּׁה כְּנַעֲנִית יֹצֵאת מִגְּבוּלוֹת הָהֵם וַתִּצְעַק אֵלָיו לֵאמֹר חָנֵּנִי אֲדֹנִי בֶּן־דָּוִד בִּתִּי רוּחַ רָעָה בָּהּ וְעָנְיָהּ מֹרֶה מְאֹד׃ ");
INSERT INTO hebsg_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","וְלֹא־עָנָה אֹתָהּ דָּבָר וַיִּגְּשׁוּ תַלְמִידָיו וַיְבַקְשׁוּ מִלְּפָנָיו לֵאמֹר שַׁלַּח אֹתָהּ כִּי־צֹעֶקֶת הִיא אַחֲרֵינוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","וַיַּעַן וַיֹּאמַר לֹא שֻׁלַּחְתִּי כִּי אִם־לְצֹאן אֹבְדוֹת לְבֵית יִשְׂרָאֵל׃ ");
INSERT INTO hebsg_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","וְהִיא בָאָה וַתִּשְׁתַּחוּ לוֹ לֵאמֹר הוֹשִׁיעָה לִּי אֲדֹנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","וַיַּעַן וַיֹּאמַר לֹא־נָכוֹן לָקַחַת אֶת־לֶחֶם הַבָּנִים וּלְהַשְׁלִיכוֹ לִפְנֵי הַכְּלָבִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","וַתֹּאמַר כֵּן אֲדֹנִי אֶפֶס גַּם־הַכְּלָבִים יֹאכְלוּן מִן־הַפְּתוֹתִים הַנֹּפְלִים מֵעַל־שֻׁלְחַן אֲדֹנֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","וַיַּעַן יֵשׁוּעַ וַיֹּאמֶר אֵלֶיהָ אִשָּׁה גְּדוֹלָה אֱמוּנָתֵךְ יְהִי־לָךְ כַּאֲשֶׁר עִם־לְבָבֵךְ וַתֵּרָפֵא בִתָּהּ בָּעֵת הַהִיא׃ ");
INSERT INTO hebsg_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","וַיַּעֲבֹר יֵשׁוּעַ מִשָּׁם וַיָּבֹא עַל־יַד יַם הַגָּלִיל וַיַּעַל אֶל־הָהָר וַיֵּשֶׁב שָׁם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","וַיָּבֹאוּ לְפָנָיו הֲמוֹן עַם־רָב וְעִמָּהֶם פִּסְחִים עִוְרִים חֵרְשִׁים נִדְכָּאִים וְרַבִּים כְּמוֹהֶם וַיַּצִּיגוּם לְרַגְלֵי יֵשׁוּעַ וְהוּא רִפָּא אֹתָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","וְהָעָם כֵּן תָּמְהוּ בִּרְאוֹתָם הָאִלְּמִים מְדַבְּרִים הַנִּדְכָּאִים נִרְפָּאִים הַפִּסְחִים הֹלְכִים וְהַעִוְרִים רֹאִים וַיִּתְּנוּ כָבוֹד לֵאלֹהֵי יִשְׂרָאֵל׃ ");
INSERT INTO hebsg_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","וַיִּקְרָא יֵשׁוּעַ אֶל־תַּלְמִידָיו וַיֹּאמַר מָלֵאתִי רַחֲמִים עַל־הָעָם כִּי עָמְדוּ עִמָּדִי זֶה שְׁלֹשֶׁת יָמִים וְאֵין לָהֶם מַה־לֶּאֱכֹל וְאֵין אֶת־נַפְשִׁי לְשַׁלְּחָם רְעֵבִים פֶּן־יִתְעַלְּפוּ בַּדָּרֶךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","וַיֹּאמְרוּ אֵלָיו תַּלְמִידָיו מֵאַיִן לָנוּ דֵּי־לֶחֶם בַּמִּדְבָר לְהַשְׂבִּיעַ הָמוֹן רָב כָּמֹהוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","וַיֹּאמֶר יֵשׁוּעַ אֲלֵיהֶם כַּמָּה לָכֶם לָחֶם וַיֹּאמְרוּ שִׁבְעָה וּמְעַט דָּגִים קְטַנִּים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","וַיְצַו אֶת־הֲמוֹן הָעָם לָשֶׁבֶת עַל־הָאָרֶץ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","וַיִּקַּח אֶת־שִׁבְעַת הַלֶּחֶם וְאֶת־הַדָּגִים וַיְבָרֵךְ וַיִּפְרֹס וַיִּתֵּן אֶל־תַּלְמִידָיו וְהַתַּלְמִידִים אֶל־הֲמוֹן הָעָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","וַיֹּאכְלוּ כֻלָּם וַיִּשְׂבָּעוּ וַיִּשְׂאוּ אֶת־הַפְּתוֹתִים הַנּוֹתָרִים שִׁבְעָה סַלִּים מְלֵאִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","וְהָאֹכְלִים הָיוּ אַרְבַּעַת אַלְפֵי אִישׁ מִלְּבַד נָשִׁים וָטָף׃ ");
INSERT INTO hebsg_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","אָז שִׁלַּח אֶת־הֲמוֹן הָעָם וְהוּא יָרַד בָּאֳנִיָּה וַיָּבֹא גְּבוּלֹת מָגָדוֹן׃ ");
INSERT INTO hebsg_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","וַיָּבֹאוּ פְרוּשִׁים וְצַדּוּקִים לְפָנָיו לְנַסּוֹתוֹ וַיִּשְׁאֲלוּ מִמֶּנּוּ לְהַרְאוֹתָם אוֹת מִן־הַשָּׁמָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","וַיַּעַן וַיֹּאמֶר אֲלֵיהֶם לְעֵת־עֶרֶב תֹּאמְרוּ הִנֵּה יוֹם־צַח בָּא כִּי אָדְמוּ הַשָּׁמָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","וּבַבֹּקֶר תֹּאמְרוּ יוֹם־סְעָרָה הַיּוֹם כִּי אָדְמוּ הַשָּׁמָיִם וְקָדָרוּ חֲנֵפִים יֹדְעִים אַתֶּם לִבְחֹן פְּנֵי הַשָּׁמַיִם וְלִבְחֹן אֹתוֹת הָעִתִּים לֹא תוּכָלוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","דֹּר רָע וּמְנָאֵף מְבַקֶּשׁ־לוֹ אוֹת וְאוֹת לֹא יִנָּתֶן־לוֹ זוּלָתִי אוֹת יוֹנָה הַנָּבִיא וַיַּעַזְבֵם וַיֵּלֶךְ לוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","וְכַאֲשֶׁר בָּאוּ תַלְמִידָיו אֶל־עֵבֶר הַיָּם שָׁכְחוּ לָקַחַת אִתָּם צֵדָה לַדָּרֶךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","וְיֵשׁוּעַ אָמַר אֲלֵיהֶם רְאוּ וְהִשָּׁמְרוּ לָכֶם מִשְּׂאֹר הַפְּרוּשִׁים וְהַצַּדּוּקִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","וַיְהִי הֵם נְדוֹנִים לֵאמֹר כִּי לֹא־לָקַחְנוּ לָחֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","וַיֵּדַע יֵשׁוּעַ וַיֹּאמֶר אֲלֵיהֶם קְטַנֵּי אֱמוּנָה לָמָּה־זֶּה אַתֶּם נְדוֹנִים כִּי לֹא־לְקַחְתֶּם לָחֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","הֲכִי עוֹד לֹא תַשְׂכִּילוּ וְלֹא תִזְכְּרוּ אֶת־חֲמֵשֶׁת הַלֶּחֶם אָכְלוּ חֲמֵשֶׁת אֲלָפִים וְכַמָּה סַלִּים אֲשֶׁר נְשָׂאתֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","וְגַם־שִׁבְעַת הַלֶּחֶם אָכְלוּ אַרְבַּעַת אֲלָפִים וְכַמָּה סַלִּים אֲשֶׁר נְשָׂאתֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","וְאֵיךְ לֹא תַשְׂכִּילוּ כִּי לֹא עַל־דְּבַר לֶחֶם אָמַרְתִּי לָכֶם כִּי אִם־לְהִשָּׁמֵר מִשְּׂאֹר הַפְּרוּשִׁים וְהַצַּדּוּקִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","אָז הֵבִינוּ כִּי לֹא אָמַר לָהֶם לְהִשָּׁמֵר מִשְּׂאֹר הַלָּחֶם כִּי אִם־מִתּוֹרַת הַפְּרוּשִׁים וְהַצַּדּוּקִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","וַיָּבֹא יֵשׁוּעַ אֶל־גְּלִילוֹת קִיסְרִין אֲשֶׁר לְפִילִפּוֹס וַיִּשְׁאַל אֶת־תַּלְמִידָיו לֵאמֹר מָה־אֹמְרִים הָאֲנָשִׁים עָלַי מִי הוּא בֶּן־הָאָדָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","וַיַּעֲנוּ יֵשׁ אֹמְרִים יוֹחָנָן הַמְטַבֵּל וְיֵשׁ אֹמְרִים אֵלִיָּהוּ וַאֲחֵרִים אֹמְרִים יִרְמְיָהוּ אוֹ אֶחָד מִן־הַנְּבִיאִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","וַיֹּאמֶר אֲלֵיהֶם וְאַתֶּם מַה־תֹּאמְרוּ עָלַי מִי אָנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","וַיַּעַן שִׁמְעוֹן פֶּטְרוֹס וַיֹּאמַר אַתָּה הוּא הַמָּשִׁיחַ בֶּן־אֱלֹהִים חַיִּים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","וַיַּעַן יֵשׁוּעַ וַיֹּמֶר אֵלָיו אַשְׁרֶיךָ שִׁמְעוֹן בַּר־יוֹנָה לֹא בָשָׂר וָדָם גִּלָּה־לְךָ זֶה כִּי אִם־אָבִי אֲשֶׁר בַּשָּׁמָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","וְגַם־אֲנִי אַגִּיד לְךָ כִּי אַתָּה הוּא כֵּיפָא וְעַל־הַכֵּף הַזֶּה אֶבְנֶה אֶת־קְהִלָּתִי וְשַׁעֲרֵי שְׁאוֹל לֹא יִגְבְּרוּ עָלֶיהָ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","וְנָתַתִּי לְךָ אֶת־מַפְתְּחוֹת מַלְכוּת הַשָּׁמָיִם אֶת־אֲשֶׁר תֶּאֱסֹר עַל־הָאָרֶץ אָסוּר יִהְיֶה בַּשָּׁמַיִם וְאֶת־אֲשֶׁר תַּתִּיר עַל־הָאָרֶץ מֻתָּר יִהְיֶה בַשָּׁמָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","אָז צִוָּה עַל־תַּלְמִידָיו לְבִלְתִּי הַגֵּד לְאִישׁ כִּי הוּא יֵשׁוּעַ הַמָּשִׁיחַ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","מֵהָעֵת הַהִיא הֵחֵל יֵשׁוּעַ לְהוֹרֹת לְתַלְמִידָיו כִּי עָלָיו לָלֶכֶת יְרוּשָׁלַיְמָה לִהְיוֹת מְעֻנֶּה עַד־מְאֹד עַל־יְדֵי הַזְּקֵנִים וְרָאשֵׁי הַכֹּהֲנִים וְהַסּוֹפְרִים וְגַם מוֹת יוּמָת וּבַיּוֹם הַשְּׁלִשִׁי יָקוּם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","וַיִּקָּחֵהוּ פֶטְרוֹס וַיָּחֶל לִגְעָר־בּוֹ לֵאמֹר חָלִלָה לְּךָ אֲדֹנִי חָלִלָה לְּךָ מִדָּבָר כָּזֶה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","וַיִּפֶן וַיֹּאמֶר אֶל־פֶּטְרוֹס סוּר שָׂטָן מֵעַל פָּנַי לְמוֹקֵשׁ אַתָּה לִי כִּי לֹא תַשְׂכִּיל אֵת אֲשֶׁר לֵאלֹהִים כִּי־אִם אֵת אֲשֶׁר לָאָדָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","אָז אָמַר יֵשׁוּעַ אֶל־תַּלְמִידָיו מִי הֶחָפֵץ לָלֶכֶת אַחֲרַי יַשְׁלִיךְ אֶת־נַפְשׁוֹ מִנֶּגֶד וְיִשָּׂא אֶת־צְלָבוֹ וְיֵלֵךְ אַחֲרָי׃ ");
INSERT INTO hebsg_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","כִּי מִי הֶחָפֵץ לְהַצִּיל אֶת־נַפְשׁוֹ תִּכָּרֶת־לוֹ וּמִי אֲשֶׁר יַכְרִית אֶת־נַפְשׁוֹ לְמַעֲנִי יִמְצָאֶנָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","כִּי מַה־בֶּצַע לְאִישׁ אִם יִקְנֶה־לּוֹ אֶת־כָּל־הָאָרֶץ וְנַפְשׁוֹ תִכָּרֶת־לוֹ אוֹ מַה־יִּתֵּן אִישׁ פִּדְיוֹן נַפְשׁוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","כִּי עָתִיד בֶּן־הָאָדָם לָבֹא בִּכְבוֹד אָבִיו עִם־מַלְאָכָיו וְאָז יְשַׁלֵּם לְכָל־אִישׁ כְּמַעֲשֵׂהוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","אָמֵן אֲנִי אֹמֵר לָכֶם יֵשׁ מִן־הַנִּצָּבִים פֹּה אֲשֶׁר לֹא־יִטְעֲמוּ מָוֶת עַד כִּי־יִרְאוּ אֶת־בֶּן־הָאָדָם בָּא בְּמַלְכוּתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","וְאַחֲרֵי שֵׁשֶׁת יָמִים לָקַח יֵשׁוּעַ אִתּוֹ אֶת־פֶּטְרוֹס וְאֶת־יַעֲקֹב וְאֶת־יוֹחָנָן אָחִיו וַיַּעַל עִמָּהֶם לְבַדָּם אֶל־הַר גָּבֹהַּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","וַיִּשְׁתַּנֶּה לְעֵינֵיהֶם פָּנָיו הִזְהִירוּ כַּשֶּׁמֶשׁ וּלְבוּשָׁיו הִלְבִּינוּ כָּאוֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","וַיֶּחֱזוּ אֶת־מֹשֶׁה וְאֶת־אֵלִיָּהוּ וְהִנָּם מְדַבְּרִים אִתּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","וַיַּעַן פֶּטְרוֹס וַיֹּאמֶר אֶל־יֵשׁוּעַ טוֹב לָנוּ אֲדֹנִי לָשֶׁבֶת פֹּה אִם יֵשׁ אֶת־נַפְשְׁךָ נַעֲשֶׂה־פֹּה שָׁלֹשׁ סֻכּוֹת אַחַת לְךָ אַחַת לְמֹשֶׁה וְאַחַת לְאֵלִיָּהוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","עוֹדֶנּוּ מְדַבֵּר וְהִנֵּה עָנָן בָּהִיר סֹכֵךְ עֲלֵיהֶם וְהִנֵּה קוֹל־קוֹרֵא מִן־הֶעָנָן זֶה־בְּנִי יְדִידִי אֲשֶׁר רָצְתָה נַפְשִׁי בּוֹ אֵלָיו תִּשְׁמָעוּן׃ ");
INSERT INTO hebsg_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","כִּשְׁמֹעַ הַתַּלְמִידִים וַיִּפְּלוּ עַל־פְּנֵיהֶם וַיִּירְאוּ מְאֹד׃ ");
INSERT INTO hebsg_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","וַיִּגַּשׁ יֵשׁוּעַ וַיִּגַּע־בָּם וַיֹּאמַר קוּמוּ אַל־תִּירָאוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","וַיִּשְׂאוּ אֶת־עֵינֵיהֶם וַיִּרְאוּ כִּי אֵין אִישׁ זוּלָתִי יֵשׁוּעַ לְבַדּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","וּבְרִדְתָּם מִן־הָהָר צִוָּה עֲלֵיהֶם יֵשׁוּעַ לֵאמֹר אַל־תַּגִּידוּ אֶת־הַמַּרְאֶה לְאִישׁ עַד כִּי־יָקוּם בֶּן־הָאָדָם מִן־הַמֵּתִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","וַיִּשְׁאָלֻהוּ תַלְמִידָיו לֵאמֹר לָמָּה־זֶּה יֹאמְרוּ הַסּוֹפְרִים כִּי אֵלִיָּהוּ בֹּא יָבֹא רִאשׁוֹנָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","וַיַּעַן יֵשׁוּעַ וַיֹּאמֶר אֲלֵיהֶם אָכֵן אֵלִיָּהוּ יָבֹא בָרִאשׁוֹנָה לְהָשִׁיב אֶת־הַכֹּל׃ ");
INSERT INTO hebsg_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","אֶפֶס אֲנִי אֹמֵר לָכֶם כִּי אֵלִיָּהוּ כְּבָר בָּא וְלֹא הִכִּירֻהוּ וַיַּעֲשׂוּ־בוֹ כִּרְצוֹנָם וְכֵן גַּם־בֶּן־הָאָדָם יְעֻנֶּה תַּחַת יָדָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","אָז הִשְׂכִּילוּ הַתַּלְמִידִים כִּי עַל־יוֹחָנָן הַמְטַבֵּל דִּבֶּר אֲלֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","וַיְהִי בְּבֹאָם אֶל־הֲמוֹן הָעָם וַיִּגַּשׁ אֵלָיו אִישׁ וַיִּכְרַע עַל־בִּרְכָּיו׃ ");
INSERT INTO hebsg_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","וַיֹּאמַר אֲדֹנִי חוּסָה־נָּא עַל־בְּנִי כִּי־מֻכֵּה יָרֵחַ הוּא וּמְעֻנֶּה עַד־מְאֹד כִּי־פְעָמִים רַבּוֹת יִפֹּל אֶל־תּוֹךְ הָאֵשׁ וּפְעָמִים רַבּוֹת אֶל־תּוֹךְ הַמָּיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","וַאֲנִי הֲבִיאֹתִיו אֶל־תַּלְמִידֶיךָ וְלֹא מָצְאָה יָדָם לְרַפֵּא אֹתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","וַיַּעַן יֵשׁוּעַ וַיֹּאמֶר הוֹי דּוֹר לֹא־אֵמֻן בּוֹ דּוֹר תַּהְפֻּכֹת עַד־מָתַי אֶהְיֶה עִמָּכֶם עַד־מָתַי אֶשָּׂא אֶתְכֶם הֲבִיאֻהוּ אֵלַי הֵנָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","וַיִּגְעַר־בּוֹ יֵשׁוּעַ וַיֵּצֵא הָרוּחַ הָרָע מִמֶּנּוּ וַיֵּרָפֵא הַנַּעַר בָּעֵת הַהִיא׃ ");
INSERT INTO hebsg_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","אָז נִגְּשׁוּ הַתַּלְמִידִים לְבַדָּם אֶל־יֵשׁוּעַ וַיֹּאמְרוּ מַדּוּעַ לֹא מָצְאָה יָדֵנוּ אֲנַחְנוּ לְגָרְשׁוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","וַיֹּאמֶר יֵשׁוּעַ אֲלֵיהֶם מִפְּנֵי חֹסֶר אֱמוּנַתְכֶם כִּי הֵן אֲנִי אֹמֵר לָכֶם אִם־יֵשׁ בָּכֶם אֱמוּנָה כְּגַרְגַּר חַרְדָּל וַאֲמַרְתֶּם לָהָר הַזֶּה הֵעָתֵק מִזֶּה שָׁמָּה וְיֵעָתֵק מִמְּקוֹמוֹ וְלֹא יִפָּלֵא מִכֶּם דָּבָר׃ ");
INSERT INTO hebsg_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","מִן רוּחַ כָּזֶה לֹא־יְגֹרָשׁ כִּי אִם־בִּתְפִלָּה וּבְצוֹם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","וַיְהִי בְּעָבְרָם בַּגָּלִיל וַיֹּאמֶר יֵשׁוּעַ אֲלֵיהֶם הִנֵּה בֶּן־הָאָדָם יִסָּגֵר בִּידֵי אֲנָשִׁים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","וְהֵם יַהַרְגֻהוּ וּבַיּוֹם הַשְּׁלִישִׁי יָקוּם וַיִּתְעַצְּבוּ מְאֹד׃ ");
INSERT INTO hebsg_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","וַיְהִי כְּבֹאָם כְּפַר־נַחוּם וַיִּגְּשׁוּ הַמְמֻנִּים עַל־מַחֲצִית הַשֶּׁקֶל אֶל־פֶּטְרוֹס וַיֹּאמְרוּ הֲלֹא יְשַׁלֵּם רַבְּכֶם אֶת־מַחֲצִית הַשָּׁקֶל׃ ");
INSERT INTO hebsg_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","וַיֹּאמֶר הֵן וַיָּבֹא הַבַּיְתָה וַיְקַדְּמֶנּוּ יֵשׁוּעַ לֵאמֹר מַה־יֶּהְגֶּה לִבְּךָ שִׁמְעוֹן מִמִּי יִקְחוּ מַלְכֵי־הָאָרֶץ מֶכֶס וָמַס מִבְּנֵיהֶם אוֹ מִן־הַזָּרִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","וַיֹּאמֶר אֵלָיו מִן־הַזָּרִים וַיֹּאמֶר אֵלָיו יֵשׁוּעַ לָכֵן חָפְשִׁים הֵם הַבָּנִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","אֶפֶס פֶּן־נִתֵּן מוֹקֵשׁ לִפְנֵיהֶם לֵךְ אֶל־הַיָּם וְהַשְׁלֵךְ חַכָּה וְלָקַחְתָּ אֶת־הַדָּג אֲשֶׁר יַעֲלֶה רִאשֹׁנָה וּפָתַחְתָּ אֶת־פִּיו וּמָצָאתָ בוֹ שֶׁקֶל כֶּסֶף אֹתוֹ קַח וְשַׁלֵּם לָהֶם בַּעֲדִי וּבַעֲדֶךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","בָּעֵת הַהִיא בָּאוּ הַתַּלְמִידִים לִפְנֵי יֵשׁוּעַ וַיֹּאמְרוּ מִי הוּא הַגָּדוֹל בְּמַלְכוּת הַשָּׁמָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","וַיִּקְרָא יֵשׁוּעַ אֶל־יֶלֶד אֶחָד וַיַּצִּיגֵהוּ בְּתוֹכָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","וַיֹּאמַר אָמֵן אֲנִי אֹמֵר לָכֶם אִם־לֹא תָשׁוּבוּ לִהְיוֹת כַּיְלָדִים בֹּא לֹא תָבֹאוּ לְמַלְכוּת הַשָּׁמָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","לָכֵן מִי אֲשֶׁר יַשְׁפִּיל אֶת־נַפְשׁוֹ כַּיֶּלֶד הַזֶּה הוּא הַגָּדוֹל בְּמַלְכוּת הַשָּׁמָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","וּמִי אֲשֶׁר יְקַבֵּל יֶלֶד כָּזֶה בִּשְׁמִי אֹתִי הוּא מְקַבֵּל׃ ");
INSERT INTO hebsg_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","וּמִי אֲשֶׁר יַכְשִׁיל אֵת אַחַד הַקְּטַנִּים הָאֵלֶּה הַמַּאֲמִינִים בִּי טוֹב לוֹ כִּי יִתְלֶה פֶּלַח־רֶכֶב עַל־צַוָּארוֹ וְיִשְׁקַע בִּמְצוּלוֹת יָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","אוֹי לָעוֹלָם מִפְּנֵי מוֹקְשֶׁיהָ כִּי־הַמּוֹקְשִׁים בֹּא יָבֹאוּ אֶל־נָכוֹן אַךְ אוֹי לָאִישׁ הַהוּא אֲשֶׁר הַמּוֹקֵשׁ בָּא עַל־יָדוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","וְאִם־יָדְךָ אוֹ רַגְלְךָ תַּכְשִׁילְךָ קַצֵּץ אֹתָהּ וְהַשְׁלִיכֶהָ מִמֶּךָ טוֹב לְךָ לָבֹא אֶל־הַחַיִּים קְטוּעַ־יָד אוֹ רֶגֶל מִהְיוֹת לְךָ שְׁתֵּי יָדַיִם וּשְׁתֵּי רַגְלַיִם וּלְהָשְׁלַךְ לְאֵשׁ עוֹלָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","וְאִם־עֵינְךָ תַּכְשִׁילְךָ נַקֵּר אֹתָהּ וְהַשְׁלִיכֶהָ מִמֶּךָ טוֹב לְךָ לָבוֹא אֶל־הַחַיִּים בְּעַיִן אַחַת מִהְיוֹת לְךָ שְׁתֵּי עֵינַיִם וּלְהָשְׁלַךְ לְאֵשׁ גֵּיהִנֹּם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","הִשָּׁמְרוּ לָכֶם מִבְּזוֹת אַחַד הַקְּטַנִּים הָאֵלֶּה כִּי הִנְנִי אֹמֵר לָכֶם אֲשֶׁר מַלְאָכֵיהֶם בַּשָּׁמַיִם רֹאִים תָּמִיד אֶת־פְּנֵי אָבִי אֲשֶׁר בַּשָּׁמָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","כִּי בָא בֶן־הָאָדָם לְהוֹשִׁיעַ אֶת־הָאֹבֵד׃ ");
INSERT INTO hebsg_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","מַה־תְּחַשְּׁבוּן אַתֶּם כִּי־תִהְיֶיןָ לְאִישׁ מֵאָה צֹאן וְאַחַת מֵהֵן תֵּלֵךְ וְתֵתַע הַאִם לֹא יַעֲזֹב אֶת־הַתִּשְׁעִים וְאֶת־הַתֵּשַׁע וְיֵלֵךְ בֶּהָרִים לְבַקֵּשׁ אֶת־הַתֹּעָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","וְהָיָה כִּי יִמְצָאֶנָּה הִנְנִי אֹמֵר לָכֶם כִּי־יִרֶב לִשְׂמֹחַ עָלֶיהָ מֵעַל הַתִּשְׁעִים וְהַתֵּשַׁע אֲשֶׁר לֹא־תָעוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","וְכֵן אֵין רָצוֹן לִפְנֵי אֲבִיכֶם בַּשָּׁמָיִם כִּי יֹאבַד אֶחָד מִן־הַקְּטַנִּים הָאֵלֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","וְכִי יֶחְטָא־לְךָ אָחִיךָ לֵךְ וְהוֹכִיחֵהוּ בֵּינְךָ וּבֵינוֹ לְבָד אִם־יַקְשִׁיב אֵלֶיךָ הֲלֹא הִצַּלְתָּ אֶת־אָחִיךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","וְאִם־לֹא יַקְשִׁיב לְקוֹלְךָ וְלָקַחְתָּ לְּךָ עוֹד אֶחָד אוֹ שְׁנָיִם כִּי עַל־פִּי שְׁנַיִם אוֹ שְׁלֹשָׁה עֵדִים יָקוּם כָּל־דָּבָר׃ ");
INSERT INTO hebsg_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","וְאִם יְמָאֵן לְהַקְשִׁיב לָהֶם וְהִגַּדְתָּ אֶל־הָעֵדָה וְאִם גַּם־אֶל־הָעֵדָה מָאֵן יְמָאֵן לִשְׁמֹעַ וְהָיָה לְךָ כְּגוֹי וּכְמוֹכֵס׃ ");
INSERT INTO hebsg_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","אָמֵן אֲנִי אֹמֵר לָכֶם אֵת אֲשֶׁר תַּאַסְרוּ עַל־הָאָרֶץ אָסוּר יִהְיֶה בַּשָּׁמָיִם וְאֵת אֲשֶׁר תָּתִּירוּ עַל־הָאָרֶץ מֻתָּר יִהְיֶה בַּשָּׁמָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","וְאוֹסִיף אֹמַר לָכֶם אִם שְׁנַיִם מִכֶּם נוֹעֲדוּ יַחְדָּו בָּאָרֶץ עַל־כָּל־דָּבָר אֲשֶׁר יִשְׁאָלוּ וְנָתַן לָהֶם אָבִי בַּשָּׁמַיִם כְּכֹל מִשְׁאֲלוֹת לִבָּם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","כִּי בְּכָל־מָקוֹם אֲשֶׁר שְׁנַיִם אוֹ שְׁלֹשָׁה יִקָּהֲלוּ בִשְׁמִי שָׁמָּה אֶהְיֶה אֲנִי בְּתוֹכָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","אָז נִגַּשׁ פֶּטְרוֹס וַיֹּאמֶר לוֹ אֲדֹנִי עַד־כַּמֶּה פְעָמִים יֶחְטָא־לוֹ אָחִי וְאֶסְלַח לוֹ הַאִם עַד־שֶׁבַע פְּעָמִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","וַיֹּאמֶר אֵלָיו יֵשׁוּעַ לֹא־אָמַרְתִּי לְךָ עַד־שֶׁבַע פְּעָמִים כִּי־אִם עַד־שִׁבְעִים וָשֶׁבַע׃ ");
INSERT INTO hebsg_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","לָכֵן דָּמְתָה מַלְכוּת הַשָּׁמַיִם לְמֶלֶךְ אֲשֶׁר בִּקֵּשׁ חֶשְׁבּוֹן מִן־עֲבָדָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","וְכַאֲשֶׁר הֵחֵל לְחַשֵּׁב וַיָּבִיאוּ אֵלָיו אִישׁ אֲשֶׁר נָשָׁה בוֹ עֲשֶׂרֶת אֲלָפִים כִּכַּר־כָּסֶף׃ ");
INSERT INTO hebsg_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","וְלֹא הָיָה בְיָדוֹ לְשַׁלֵּם וַיְצַו עָלָיו אֲדֹנָיו כִּי יִמָּכֵר הוּא וְאִשְׁתּוֹ וּבָנָיו וְכָל־אֲשֶׁר־לוֹ וְשַׁלֵּם יְשַׁלֵּם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","וַיִּפֹּל הָעֶבֶד וַיִּשְׁתַּחוּ לוֹ לֵאמֹר אֲדֹנִי הַאֲרֶךְ־נָא אַפְּךָ וְאֶת־כָּל־נִשְׁיִי אֲשַׁלֵּמָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","וַיִּכָּמְרוּ רַחֲמֵי הָאָדוֹן עַל־הָעֶבֶד הַהוּא וַיְשַׁלְּחֵהוּ וְשָׁמוֹט לוֹ חוֹבוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","וַיֵּצֵא הָעֶבֶד הַהוּא מִלְּפָנָיו וַיִּמְצָא אֵת אַחַד הָעֲבָדִים אִישׁ עֲמִיתוֹ אֲשֶׁר נָשָׁה בוֹ מֵאָה כָסֶף וַיִּתְפָּשׂ־בּוֹ וַיְחַנְּקֵהוּ לֵאמֹר שַׁלֶּם־לִי אֵת אֲשֶׁר נָשִׁיתָ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","וַיִּפֹּל הָעֶבֶד אִישׁ עֲמִיתוֹ לִפְנֵי רַגְלָיו וַיִּתְחַנֶּן־לוֹ לֵאמֹר הַאֲרֶךְ־נָא אַפְּךָ וַאֲשַׁלְּמָה לְךָ הַכָּל׃ ");
INSERT INTO hebsg_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","וְלֹא אָבָה אַךְ הָלַךְ וַיִּתְּנֵהוּ אֶל־הַמִּשְׁמָר עַד־אֲשֶׁר יְשַׁלֵּם אֶת־נִשְׁיוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","וְאֶחָיו הָעֲבָדִים בִּרְאוֹתָם אֶת־אֲשֶׁר קָרָה הִתְעַצְּבוּ עַד־מְאֹד וַיָּבֹאוּ וַיְסַפְּרוּ לַאֲדֹנֵיהֶם אֶת־כָּל אֲשֶׁר קָרָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","אָז קָרָא לוֹ אֲדֹנָיו וַיֹּאמֶר אֵלָיו עֶבֶד בְּלִיַּעַל אֶת־כָּל־הַחוֹב הַהוּא שָׁמַטְתִּי לְךָ כַּאֲשֶׁר הִתְחַנַּנְתָּ לְפָנָי׃ ");
INSERT INTO hebsg_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","הֲלֹא הָיָה גַם־עָלֶיךָ לְרַחֵם עַל־הָעֶבֶד אָחִיךָ כַּאֲשֶׁר רִחַמְתִּי עָלֶיךָ אָנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","וַיִּחַר אַף אֲדֹנָיו וַיִּתְּנֵהוּ בְּיַד־נֹגְשִׁים עַד־כִּי־יְשַׁלֵּם אֶת־כָּל־אֲשֶׁר נָשָׁה בוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","כָּכָה יַעֲשֶׂה לָכֶם גַּם־אָבִי בַּשָּׁמָיִם אִם־לֹא תִסְלְחוּ בְּכָל־לִבְּכֶם אִישׁ אִישׁ לְאָחִיו עַל־חַטֹּאתָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","וַיְהִי כַּאֲשֶׁר כִּלָּה יֵשׁוּעַ לְדַבֵּר אֵת הַדְּבָרִים הָאֵלֶּה וַיַּעֲבֹר מִן־הַגָּלִיל וַיָּבֹא גְבוּל יְהוּדָה מֵעֵבֶר לַיַּרְדֵן׃ ");
INSERT INTO hebsg_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","וַהֲמוֹן עַם־רָב הָלְכוּ אַחֲרָיו וַיִּרְפָּאֵם שָׁם מֵחָלְיָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","וַיִּגְּשׁוּ אֵלָיו מִן־הַפְּרוּשִׁים וַיְנַסּוּ אֹתוֹ לֵאמֹר הֲיֵשׁ בְּיַד אִישׁ לְשַׁלַּח אֶת־אִשְׁתּוֹ עַל־כָּל־דָּבָר׃ ");
INSERT INTO hebsg_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","וַיַּעַן וַיֹּאמַר הֲלֹא קְרָאתֶם כִּי הָעֹשֶׂה מִקֶּדֶם זָכָר וּנְקֵבָה עָשָׂה אֹתָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","וְאָמַר עַל־כֵּן יַעֲזָב־אִישׁ אֶת־אָבִיו וְאֶת־אִמּוֹ וְדָבַק בְּאִשְׁתּוֹ וְהָיוּ שְׁנֵיהֶם לְבָשָׂר אֶחָד׃ ");
INSERT INTO hebsg_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","וְלָזֹאת אֵפוֹא אֵינָם עוֹד שְׁנַיִם כִּי אִם־בָּשָׂר אֶחָד וְלָכֵן אֵת אֲשֶׁר חִבֵּר אֱלֹהִים אַל־יַפְרֵד אָדָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","וַיֹּאמְרוּ אֵלָיו וְלָמָּה־זֶּה צִוָּה מֹשֶׁה לָתֵת סֵפֶר כְּרִיתֻת וּלְשַׁלְּחָהּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","וַיֹּאמֶר אֲלֵיהֶם בַּעֲבוּר קְשִׁי לְבַבְכֶם נָתַן לָכֶם מֹשֶׁה לְשַׁלַּח אֶת־נְשֵׁיכֶם אֲבָל לֹא הָיָה כֵן מִקֶּדֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","וַאֲנִי אֹמֵר לָכֶם אִישׁ אִישׁ אֲשֶׁר יְשַׁלַּח אֶת־אִשְׁתּוֹ אִם לֹא עַל־דְּבַר זְנוּת וְנֹשֵׂא לוֹ אַחֶרֶת נֹאֵף הוּא וְהַנֹּשֵׂא אֶת־הַגְּרוּשָׁה נֹאֵף הוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","וַיֹּאמְרוּ אֵלָיו תַּלְמִידָיו אִם דְּבַר אִישׁ וְאִשָּׁה כָּכָה הוּא לֹא־טוֹב לָקַחַת אִשָּׁה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","וַיֹּאמֶר אֲלֵיהֶם לֹא כָל־אִישׁ רַב־כֹּחַ הוּא לִסְבֹּל הַדָּבָר הַזֶּה כִּי־אִם רַק אֵלֶּה אֲשֶׁר נִתַּן לָהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","כִּי יֵשׁ סָרִיסִים אֲשֶׁר נוֹלְדוּ כֵן מֵרֶחֶם אִמָּם וְיֵשׁ אֲשֶׁר נַעֲשׂוּ סָרִיסִים בִּידֵי אָדָם וְיֵשׁ אֲשֶׁר מִנַּפְשָׁם נִהְיוּ לְסָרִיסִים לְמַעַן מַלְכוּת הַשָּׁמָיִם מִי אֲשֶׁר כֹּחוֹ רַב לוֹ לִסְבֹּל יִסְבֹּל׃ ");
INSERT INTO hebsg_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","אָז הוּבְאוּ יְלָדִים לְפָנָיו לְבַעֲבוּר יָשִׂים אֶת־יָדָיו עֲלֵיהֶם וְיִתְפַּלֵּל בַּעֲדָם וַיִּגְעֲרוּ־בָם הַתַּלְמִידִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","וַיֹּאמֶר יֵשׁוּעַ אֲלֵיהֶם הַנִּיחוּ לַיְלָדִים וְאַל־תִּכְלְאוּ אֹתָם מִבֹּא אֵלָי כִּי מֵאֵלֶּה מַלְכוּת הַשָּׁמָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","וַיָּשֶׂם אֶת־יָדָיו עֲלֵיהֶם וַיִּפֶן וַיֵּלַךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","וְהִנֵּה־אִישׁ נִגַּשׁ אֵלָיו וַיֹּאמַר רַבִּי הַטּוֹב אֵי־זֶה הַטּוֹב אֶעֱשֶׂה לָרֶשֶׁת חַיֵּי עוֹלָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","וַיֹּאמֶר אֵלָיו לָמָּה־זֶּה קָרָאתָ לִי טוֹב אֵין־טוֹב כִּי אִם־אֶחָד הוּא הָאֱלֹהִים וְאִם־נִכְסַפְתָּ לָבֹא אֶל־הַחַיִּים שְׁמֹר אֵת הַמִּצְוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","וַיֹּאמֶר אֵלָיו אֵי־זֹה הֵנָּה וַיַּעַן יֵשׁוּעַ לֹא תִּרְצָח לֹא תִּנְאָף לֹא תִּגְנֹב לֹא־תַעֲנֶה עֵד שָׁקֶר׃ ");
INSERT INTO hebsg_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","כַּבֵּד אֶת־אָבִיךָ וְאֶת־אִמֶּךָ וְאָהַבְתָּ לְרֵעֲךָ כָּמוֹךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","וַיֹּאמֶר הַנַּעַר אֵלָיו כָּל־אֵלֶּה שָׁמַרְתִּי מִנְּעוּרָי וּמַה־יֶּחְסַר לִי עוֹד׃ ");
INSERT INTO hebsg_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","וַיֹּאמֶר אֵלָיו יֵשׁוּעַ אִם־חָפַצְתָּ לִהְיוֹת תָּמִים לֵךְ וּמְכֹר אֶת־כָּל־אֲשֶׁר־לְךָ וְתֵן לַעֲנִיִּים וְהָיָה לְךָ אוֹצָר בַּשָּׁמָיִם וּבֹא וְלֵךְ אַחֲרָי׃ ");
INSERT INTO hebsg_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","וְהַנַּעַר כְּשָׁמְעוֹ הַדָּבָר הַזֶּה הִתְעַצֵּב אֶל־לִבּוֹ וַיֵּלֶךְ־לוֹ כִּי־נְכָסִים רַבִּים הָיוּ לוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","וַיֹּאמֶר יֵשׁוּעַ אֶל־תַּלְמִידָיו אָמֵן אֲנִי אֹמֵר לָכֶם מַה־קָּשֶׁה לְאִישׁ עָשִׁיר לָבֹא אֶל־מַלְכוּת הַשָּׁמָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","וְעוֹד אֲנִי אֹמֵר לָכֶם כִּי־נָקֵל לַגָּמָל לַעֲבֹר דֶּרֶךְ חֻר הַמַּחַט מִבֹּא עָשִׁיר אֶל־מַלְכוּת הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","וְתַלְמִידָיו שָׁמְעוּ וַיִּשְׁתּוֹמְמוּ עַד־מְאֹד לֵאמֹר מִי אֵפוֹא יוּכַל לְהִוָּשֵׁעַ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","וַיַּבֶּט־בָּם יֵשׁוּעַ וַיֹּאמֶר אֲלֵיהֶם מִבְּנֵי־אָדָם יִפָּלֵא הַדָּבָר הַזֶּה אַךְ מֵאֱלֹהִים לֹא יִפָּלֵא כָּל־דָּבָר׃ ");
INSERT INTO hebsg_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","וַיַּעַן פֶּטְרוֹס וַיֹּאמֶר אֵלָיו הִנֵּה אֲנַחְנוּ עָזַבְנוּ אֶת־כֹּל וַנֵּלֶךְ אַחֲרֶיךָ וּמָה אֵפוֹא יִהְיֶה־לָּנוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","וַיֹּאמֶר יֵשׁוּעַ אֲלֵיהֶם אָמֵן אֲנִי אֹמֵר לָכֶם כִּי אַתֶּם הַהֹלְכִים אַחֲרָי כַּאֲשֶׁר יֵשֵׁב בֶּן־הָאָדָם עַל־כִּסֵּא כְבוֹדוֹ בְּהִתְחַדֵּשׁ הַבְּרִיאָה גַּם־אַתֶּם תֵּשְׁבוּ אָז עַל־שְׁנֵים עָשָׂר כִּסְאוֹת לִשְׁפֹּט אֶת־שְׁנֵים עָשָׂר שִׁבְטֵי יִשְׂרָאֵל׃ ");
INSERT INTO hebsg_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","וְכָל־אִישׁ אֲשֶׁר יַעֲזֹב בָּתִּים אוֹ אַחִים אוֹ אֲחָיוֹת אוֹ אָב אוֹ אֵם אוֹ אִשָּׁה אוֹ בָנִים אוֹ שָׂדוֹת לְמַעַן שְׁמִי יִמְצָא מֵאָה שְׁעָרִים וְחַיֵּי עוֹלָם יִירָשׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","וְרַבִּים הֵם הָרִאשֹׁנִים אֲשֶׁר יִהְיוּ אַחֲרֹנִים וְהָאַחֲרֹנִים רִאשֹׁנִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","כִּי דָּמְתָה מַלְכוּת הַשָּׁמַיִם לְבַעַל־הַבָּיִת אֲשֶׁר הִשְׁכִּים וַיֵּצֵא בַבֹּקֶר וַיִּשְׂכֹּר פֹּעֲלִים לְכַרְמוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","וּשְׂכַר הַפֹּעֲלִים נָקַב שֶׁקֶל לַיּוֹם וַיִּשְׁלַח אֹתָם אֶל־הַכָּרֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","וַיֵּצֵא בַּשָּׁעָה הַשְּׁלִישִׁית וַיַּרְא אֲנָשִׁים אֲחֵרִים עֹמְדִים בִּבְלִי מְלָאכָה בַּשּׁוּק׃ ");
INSERT INTO hebsg_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","וַיֹּאמֶר אֲלֵיהֶם לְכוּ אֶל־כַּרְמִי גַּם־אַתֶּם וְדֵי שְׂכַרְכֶם אֶתֵּן לָכֶם כַּמִּשְׁפָּט וַיֵּלְכוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","וַיּוֹסֶף וַיֵּצֵא בַּשָּׁעָה הַשִּׁשִּׁית וְהַתְּשִׁיעִית וַיַּעַשׂ כְּמוֹ־כֵן׃ ");
INSERT INTO hebsg_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","וּבַשָּׁעָה הָעַשְׁתֵּי עֶשְׂרֵה יָצָא וַיִּמְצָא אֲחֵרִים עֹמְדִים וַיֹּאמֶר אֲלֵיהֶם מַדּוּעַ תַּעַמְדוּ פֹה כָּל־הַיּוֹם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","וַיֹּאמְרוּ אֵלָיו כִּי לֹא־שָׂכַר אֹתָנוּ אִישׁ וַיֹּאמֶר אֲלֵיהֶם לְכוּ אֶל־כַּרְמִי גַּם־אַתֶּם וּשְׂכַרְכֶם יֻתַּן לָכֶם כַּמִּשְׁפָּט׃ ");
INSERT INTO hebsg_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","וַיְהִי לִפְנוֹת עֶרֶב וַיֹּאמֶר אֲדוֹן הַכֶּרֶם אֶל־פְּקִידוֹ קְרָא אֶת־הַפֹּעֲלִים וְתֵן לָהֶם שְׂכָרָם הָחֵל מִן־הָאַחֲרֹנִים עַד הָרִאשֹׁנִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","וַיָּבֹאוּ הַנִּשְׂכָּרִים בְּשָׁעָה עַשְׁתֵּי עֶשְׂרֵה וַיִּקְחוּ שֶׁקֶל לְאִישׁ אִישׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","וְהָרִאשֹׁנִים בָּאוּ וַיֹּאמְרוּ בְלִבָּם כִּי יַשִּׂיגוּ יוֹתֵר אַךְ גַּם־הֵמָּה הִשִּׂיגוּ רַק שֶׁקֶל אֶחָד לָאִישׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","וַיִּקְחוּ וַיִּלֹּנוּ עַל־בַּעַל הַבַּיִת לֵאמֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","הָאַחֲרֹנִים הָאֵלֶּה עָבְדוּ שָׁעָה אַחַת וַתְּשַׁו אֹתָם כָּמֹנוּ אֲשֶׁר הָיִינוּ כָּל־הַיּוֹם לָשֵׂאת סֵבֶל וְהַחֹרֶב אֲכָלָנוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","וַיַּעַן וַיֹּאמֶר לְאֶחָד מֵהֶם רֵעִי לֹא עֲשַׁקְתִּיךָ הֲלֹא שֶׁקֶל נָקַבְתָּ לִּי שְׂכָרֶךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","קַח אֵת אֲשֶׁר־לְךָ וָלֵךְ וַאֲנִי עִם־לִבִּי לָתֵת לָזֶה הָאַחֲרוֹן כָּמוֹךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","הַאֵין נָכוֹן לִי לַעֲשׂוֹת בְּשֶׁלִּי כַּאֲשֶׁר עִם־לְבָבִי אוֹ הַאִם רָעָה עֵינְךָ בַּאֲשֶׁר טוֹב אָנֹכִי׃ ");
INSERT INTO hebsg_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","כָּכָה יִהְיוּ הָאַחֲרֹנִים רִאשֹׁנִים וְהָרִאשֹׁנִים אַחֲרֹנִים כִּי רַבִּים הֵם הַקְּרוּאִים וּמְעַטִים הַנִּבְחָרִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","וַיְהִי כַּעֲלוֹת יֵשׁוּעַ יְרוּשָׁלָיְמָה וַיִּקַּח אֶת־שְׁנֵים עָשָׂר הַתַּלְמִידִים לְבַדָּם וַיֹּאמֶר אֲלֵיהֶם בַּדָּרֶךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","הִנֵּה אֲנַחְנוּ עֹלִים יְרוּשָׁלָיְמָה וּבֶן־הָאָדָם יִסָּגֵר בִּידֵי רָאשֵׁי הַכֹּהֲנִים וְהַסֹּפְרִים וְהִרְשִׁיעוּ אֹתוֹ לָמוּת׃ ");
INSERT INTO hebsg_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","וְהִסְגִּירוּ אֹתוֹ לַגּוֹיִם לְהִתְעַלֶּל־בּוֹ לְיַסְּרוֹ בַשּׁוֹטִים וְלִצְלֹב אֹתוֹ וּבַיּוֹם הַשְּׁלִישִׁי יָקוּם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","אָז נִגְּשָׁה אֵלָיו אֵם בְּנֵי זַבְדִּי עִם־בָּנֶיהָ לְהִשְׁתַּחֲוֹת לוֹ וּלְבַקֵּשׁ מִיָּדוֹ דָּבָר׃ ");
INSERT INTO hebsg_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","וַיֹּאמֶר אֵלֶיהָ מַה־בַּקָּשָׁתֵךְ וַתֹּאמֶר אֵלָיו צַו־נָא וּשְׁנֵי בָנַי אֵלֶּה יֵשְׁבוּ אֶחָד לִימִינְךָ וְאֶחָד לִשְׂמֹאלְךָ בְּמַלְכוּתֶךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","וַיַּעַן יֵשׁוּעַ וַיֹּאמֶר לֹא יְדַעְתֶּם אֵת אֲשֶׁר תִּשְׁאָלוּן הֲתוּכְלוּ לִשְׁתּוֹת אֶת־הַכּוֹס אֲשֶׁר אֲנִי אֶשְׁתֶּה וּלְהִטָּבֵל טְבִילָה אֲשֶׁר אֲנִי נִטְּבָּל וַיֹּאמְרוּ אֵלָיו נוּכָל׃ ");
INSERT INTO hebsg_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","וַיֹּאמֶר אֲלֵיהֶם כּוֹסִי שָׁתֹה תִשְׁתּוּ וּטְבִילָה אֲשֶׁר אֲנִי נִטְּבָּל תִטָּבֵלוּ אֲבָל לָשֶׁבֶת לִימִינִי וְלִשְׂמֹאלִי אֵין בְּיָדִי לָתֵת כִּי אִם לָאֵלֶּה אֲשֶׁר יָעַד אֹתָם אָבִי׃ ");
INSERT INTO hebsg_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","וְהָעֲשָׂרָה בְּשָׁמְעָם כָּזֹאת חָרָה אַפָּם בִּשְׁנֵי הָאַחִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","וַיִּקְרָא יֵשׁוּעַ וַיֹּאמֶר אֲלֵיהֶם הֵן יְדַעְתֶּם כִּי־הַמֹּשְׁלִים בַּגּוֹיִם יִמְשְׁלוּ בָם כָּשָׂרִים בָּעֲבָדִים וּגְדוֹלֵיהֶם שֹׁלְטִים עֲלֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","וְלֹא יִהְיֶה כֵן בְּקִרְבְּכֶם כִּי אִם מִי־הֶחָפֵץ לִהְיוֹת גָּדוֹל בָּכֶם יִהְיֶה לָכֶם לִמְשָׁרֵת׃ ");
INSERT INTO hebsg_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","וּמִי־מִכֶּם הֶחָפֵץ לִהְיוֹת לְרֹאשׁ יִהְיֶה לָכֶם לְעָבֶד׃ ");
INSERT INTO hebsg_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","כַּאֲשֶׁר גַּם בֶּן־הָאָדָם לֹא בָא לְמַעַן יְשָׁרְתֻהוּ אֲחֵרִים כִּי אִם־לְשָׁרֵת הוּא וְלָתֵת אֶת־נַפְשׁוֹ כֹּפֶר בְּעַד רַבִּים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","וַיֵּצְאוּ מִירִיחוֹ וַהֲמוֹן עַם־רָב הֹלְכִים אַחֲרָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","וְהִנֵּה שְׁנֵי־עִוְרִים יָשְׁבוּ עַל־הַדָּרֶךְ וּבְשָׁמְעָם כִּי יֵשׁוּעַ עֹבֵר שָׁם וַיִּצְעֲקוּ לֵאמֹר הוֹשִׁיעָה־נָּא אֲדֹנֵינוּ בֶּן־דָּוִד׃ ");
INSERT INTO hebsg_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","וַיִּגְעַר־בָּם הָעָם לְהַחֲשׁוֹתָם וְהֵם הוֹסִיפוּ לִקְרֹא וְלֵאמֹר הוֹשִׁיעָה־נָּא אֲדֹנֵינוּ בֶּן־דָּוִד׃ ");
INSERT INTO hebsg_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","וַיַּעֲמֹד יֵשׁוּעַ וַיִּקְרָא אֲלֵיהֶם וַיֹּאמַר מַה־תְּבַקְשׁוּן וְאֶעֱשֶׂה לָכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","וַיֹּאמְרוּ אֵלָיו אֲדֹנֵינוּ כִּי תִפָּקַחְנָה עֵינֵינוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","וַיִּכָּמְרוּ רַחֲמֵי יֵשׁוּעַ עֲלֵיהֶם וַיִּגַּע בְּעֵינֵיהֶם וְעַד־מְהֵרָה הוּשָׁב לָהֶם אוֹר עֵינֵיהֶם וַיֵּלְכוּ אַחֲרָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","וַיְהִי כַּאֲשֶׁר בָּאוּ מִקָּרוֹב לִירוּשָׁלַיִם אֶל־בֵּית־פַּגַּי אֶל־הַר הַזֵּיתִים וַיִּשְׁלַח יֵשׁוּעַ שְׁנַיִם מִתַּלְמִידָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","וַיֹּאמֶר אֲלֵיהֶם לְכוּ אֶל־הַכְּפָר אֲשֶׁר מִנֶּגֶד וּמְצָאתֶם שָׁם אָתוֹן אֲסוּרָה וְעַיִר אֶצְלָהּ הַתִּירוּם וַהֲבִיאוּם אֵלָי׃ ");
INSERT INTO hebsg_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","וְכִי־יֹאמַר אִישׁ אֲלֵיכֶם דָּבָר וַאֲמַרְתֶּם הָאָדוֹן יֶשׁ־לוֹ חֵפֶץ בָּם וְעַד מְהֵרָה יְשַׁלְּחֵם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","וְכָל־זֹאת הָיָה לְמַלֹּאת אֵת אֲשֶׁר נֶאֱמַר בְּיַד־הַנָּבִיא לֵאמֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","אִמְרוּ לְבַת־צִיּוֹן הִנֵּה מַלְכֵּךְ יָבוֹא לָךְ עָנִי וְרֹכֵב עַל־חֲמוֹר וְעַל־עַיִר בֶּן־אֲתֹנוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","וַיֵּלְכוּ הַתַּלְמִידִים וַיַּעֲשׂוּ כַּאֲשֶׁר צִוָּה אֹתָם יֵשׁוּעַ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","וַיָּבִיאוּ אֶת־הָאָתוֹן וְאֶת־הָעַיִר וַיָּשִׂימוּ עַל־גַּבָּם אֶת־בִּגְדֵיהֶם וְהוּא יָשַׁב עֲלֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","וְרַבִּים מִן־הָעָם פָּרְשׂוּ אֶת־בִּגְדֵיהֶם עַל־פְּנֵי הַדָּרֶךְ וְיֵשׁ מֵהֶם אֲשֶׁר כָּרְתוּ זְמֹרוֹת מִן־הָעֵצִים וַיִּשְׁטְחוּ אֹתָן שָׁמָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","וַהֲמוֹן הָעָם הַהֹלֵךְ מִלְּפָנָיו וּמֵאַחֲרָיו עָנוּ לֵאמֹר הוֹשַׁע־נָא לְבֶן־דָּוִד בָּרוּךְ הַבָּא בְּשֵׁם יְהוָֹה הוֹשַׁע־נָא בִּשְׁמֵי מָרוֹם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","וּבְבֹאוֹ יְרוּשָׁלָיִם וַתֵּהוֹם כָּל־הָעִיר לֵאמֹר מִי הוּא זֶה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","וַיֹּאמְרוּ הֲמוֹן הָעָם זֶה הוּא הַנָּבִיא יֵשׁוּעַ מִנְּצֶרֶת אֲשֶׁר בַּגָּלִיל׃ ");
INSERT INTO hebsg_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","וַיָּבוֹא יֵשׁוּעַ אֶל־מִקְדַּשׁ הָאֱלֹהִים וַיְגָרֶשׁ מִשָּׁם כָּל־הַמּוֹכְרִים וְהַקּוֹנִים בַּמִּקְדָּשׁ וַיַּהֲפֹךְ אֶת־שֻׁלְחֲנוֹת מַחֲלִפֵי הַכֶּסֶף וְאֶת־מוֹשְׁבוֹת מֹכְרֵי הַיּוֹנִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","וַיֹּאמֶר אֲלֵיהֶם הֵן כָּתוּב כִּי בֵיתִי בֵּית־תְּפִלָּה יִקָּרֵא וְאַתֶּם עֲשִׂיתֶם אֹתוֹ לִמְעָרַת פָּרִיצִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","וַיִּגְּשׁוּ אֵלָיו עִוְרִים וּפִסְחִים בְּבֵית הַמִּקְדָּשׁ וַיִּרְפָּאֵם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","וַיִּרְאוּ רָאשֵׁי הַכֹּהֲנִים וְהַסּוֹפְרִים אֵת הַנִּפְלָאוֹת אֲשֶׁר עָשָׂה וְאֵת הַיְלָדִים קֹרְאִים וְעֹנִים בַּמִּקְדָּשׁ הוֹשַׁע־נָא לְבֶן־דָּוִד וַיִּחַר לָהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","וַיֹּאמְרוּ אֵלָיו הֲכִי שָׁמַעְתָּ מָה אֵלֶּה אֹמְרִים וַיֹּאמֶר אֲלֵיהֶם יֵשׁוּעַ הֵן הֲלֹא קְרָאתֶם מִפִּי עוֹלְלִים וְיוֹנְקִים יִסַּדְתָּ עֹז׃ ");
INSERT INTO hebsg_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","וַיַּעַזְבֵם וַיֵּצֵא אֶל־מִחוּץ לָעִיר אֶל־בֵּית־עַנְיָה וַיָּלֶן שָׁם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","וַיָּשָׁב הָעִירָה בַּבֹּקֶר וְהוּא רָעֵב׃ ");
INSERT INTO hebsg_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","וַיַּרְא תְּאֵנָה אַחַת בַּדָּרֶךְ וַיִּקְרַב אֵלֶיהָ וְלֹא־מְצָא בָהּ מְאוּמָה זוּלָתִי עָלִים לְבַדָּם וַיֹּאמֶר לָהּ לֹא־תַעֲשִׂי עוֹד פְּרִי מֵעַתָּה וְעַד־עוֹלָם וַתִּיבַשׁ הַתְּאֵנָה פִּתְאֹם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","וְהַתַּלְמִידִים רָאוּ וַיִּתְמְהוּ לֵאמֹר אֵיךְ יָבְשָׁה הַתְּאֵנָה פִּתְאֹם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","וַיַּעַן יֵשׁוּעַ וַיֹּאמֶר אֲלֵיהֶם אָמֵן אֲנִי אֹמֵר לָכֶם אִם־יֵשׁ בָּכֶם אֱמוּנָה וְאֵינְכֶם פֹּסְחִים עַל־שְׁתֵּי הַסְּעִפִּים לֹא לְבַד כַּמַּעֲשֶׂה הַזֶּה אֲשֶׁר נַעֲשָׂה לַתְּאֵנָה תַּעֲשׂוּ כִּי אִם־גַּם תֹּאמְרוּ לָהָר הַזֶּה הִנָּשֵׂא וְהִתְנַפֵּל אֶל־תּוֹךְ הַיָּם וִיהִי כֵן׃ ");
INSERT INTO hebsg_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","וְכָל־דָּבָר אֲשֶׁר תִּשְׁאֲלוּ בִתְפִלָּה אִם רַק בֶּאֱמוּנָה שְׁאֶלְתֶּם יֻתַּן לָכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","וַיָּבֹא אֶל־הַמִּקְדָּשׁ וַיִּגְּשׁוּ אֵלָיו רָאשֵׁי הַכֹּהֲנִים וְזִקְנֵי הָעָם בְּעוֹדוֹ מְלַמֵּד לָעָם וַיֹּאמְרוּ בְּאֵיזֶה רִשְׁיוֹן אַתָּה עֹשֶׂה אֵלֶּה וּמִי־נָתַן לְךָ הָרִשְׁיוֹן הַזֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","וַיַּעַן יֵשׁוּעַ וַיֹּאמֶר אֲלֵיהֶם אֶשְׁאַל מִכֶּם גַּם־אָנֹכִי שְׁאַלָה אַחַת וְאִם־תַּגִּידוּ לִי גַּם־אָנֹכִי אַגִּיד לָכֶם בְּאֵיזֶה רִשְׁיוֹן אֲנִי עֹשֶׂה אֵלֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","טְבִילַת יוֹחָנָן מִפִּי־מִי הָיְתָה מִצְוָתָהּ מִן־הַשָּׁמַיִם אוֹ מִבְּנֵי־אָדָם וַיְהִי הֵם שֹׁקְלִים בְּדַעְתָּם לֵאמֹר אִם נֹאמַר מִן־הַשָּׁמַיִם יֹאמַר לָנוּ וּמַדּוּעַ לֹא הֶאֱמַנְתֶּם לוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","וְאִם נֹאמַר מִבְּנֵי אָדָם יְרֵאִים אֲנַחְנוּ אֶת־הֲמוֹן הָעָם כִּי־כֻלָּם חִשְּׁבוּ אֶת־יוֹחָנָן לְנָבִיא׃ ");
INSERT INTO hebsg_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","וַיַּעֲנוּ אֶת־יֵשׁוּעַ וַיֹּאמְרוּ לֹא יָדָעְנוּ וַיֹּאמֶר אֲלֵיהֶם גַּם־אֲנִי לֹא אַגִּיד לָכֶם בְּאֵיזֶה רִשְׁיוֹן אֲנִי עֹשֶׂה אֵלֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","אֲבָל מַה־יַּחֲשֹׁב לִבְּכֶם אִישׁ הָיָה וְלוֹ שְׁנֵי בָנִים וַיָּבֹא אֶל־הָאֶחָד וַיֹּאמֶר לְכָה־בְּנִי וַעֲבֹד הַיּוֹם אֶת־כַּרְמִי׃ ");
INSERT INTO hebsg_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","וַיַּעַן וַיֹּאמֶר לֹא חָפָצְתִּי וְאַחֲרֵי־כֵן נֶהְפַּךְ עָלָיו לִבּוֹ וַיֵּלַךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","וַיָּבֹא אֶל־הַשֵּׁנִי וַיְדַבֵּר כַּדָּבָר הַזֶּה וַיַּעַן וַיֹּאמֶר הִנְנִי אֲדֹנִי וְלֹא הָלָךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","מִי מִשְּׁנֵיהֶם מִלֵּא אַחַר רְצוֹן אָבִיו וַיֹּאמְרוּ הָרִאשׁוֹן וַיֹּאמֶר עֲלֵיהֶם יֵשׁוּעַ אָמֵן אֲנִי אֹמֵר לָכֶם כִּי הַמּוֹכְסִים וְהַזֹּנוֹת יַקְדִּימוּ לָבֹא לְמַלְכוּת הָאֱלֹהִים מִכֶּם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","כִּי יוֹחָנָן בָּא אֲלֵיכֶם בָּדֶרֶךְ צְדָקָה וְלֹא הֶאֱמַנְתֶּם לוֹ וְהַמּוֹכְסִים וְהַזֹּנוֹת הֶאֱמִינוּ לוֹ וְאַתֶּם רְאִיתֶם כָּל־זֹאת וְלֹא הֲשִׁיבֹתֶם אֶל־לִבְּכֶם לְהַאֲמִין לוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","שִׁמְעוּ מָשָׁל אַחֵר אִישׁ הָיָה בַּעַל־בַּיִת אֲשֶׁר נָטַע כֶּרֶם וַיְעַזְּקֵהוּ מִסָּבִיב וְיֶקֶב חָצֵב בּוֹ וַיִּבֶן מִגְדָּל בְּתוֹכוֹ וְנָתַן אֹתוֹ לַנֹּטְרִים וְהָלַךְ מִחוּץ לָאָרֶץ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","כְּבֹא עֵת הַבָּצִיר שָׁלַח אֶת־עֲבָדָיו אֶל־הַנֹּטְרִים לְהָבִיא אֶת־פִּרְיוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","וַיִּתְפְּשׂוּ הַנֹּטְרִים בַּעֲבָדָיו וַיַּכּוּ אֶת־אֶחָד מֵהֶם וְאֶת־אַחֵר הָרְגוּ וְאֶת־אַחֵר סִקֵּלוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","וַיּוֹסֶף וַיִּשְׁלַח עֲבָדִים אֲחֵרִים רַבִּים מִן־הָרִאשֹׁנִים וְגַם־לָהֶם עָשׂוּ כֵן׃ ");
INSERT INTO hebsg_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","וְאַחֲרֵי־כֵן שָׁלַח אֲלֵיהֶם אֶת־בְּנוֹ כִּי אָמַר אֶת־בְּנִי יִירָאוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","וְהַנֹּטְרִים כִּרְאוֹתָם אֶת־הַבֵּן וַיֹּאמְרוּ אִישׁ אֶל־אָחִיו הִנֵּה הַיּוֹרֵשׁ לְכוּ וְנַהַרְגֵהוּ וְנִירַשׁ לָנוּ אֶת־יְרֻשָּׁתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","וַיִּתְפְּשׂוּ בּוֹ וַיַּשְׁלִיכֻהוּ אֶל־מִחוּץ לַכֶּרֶם וַיַּהַרְגֻהוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","וְעַתָּה כְּבֹא בַּעַל הַכָּרֶם מַה־יַּעֲשֶׂה לַנֹּטְרִים הָהֵם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","וַיֹּאמְרוּ אֵלָיו הַשְׁמֵד יַשְׁמִיד אֶת־בְּנֵי הַבְּלִיַּעַל הָאֵלֶּה וְנָתַן כַּרְמוֹ לְנֹטְרִים אֲחֵרִים אֲשֶׁר יִתְּנוּ לוֹ אֶת־פִּרְיוֹ בְּעִתּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","וַיֹּאמֶר אֲלֵיהֶם יֵשׁוּעַ הֲלֹא קְרָאתֶם בַּכְּתוּבִים אֶבֶן מָאֲסוּ הַבּוֹנִים הָיְתָה לְרֹאשׁ פִּנָּה מֵאֵת יְהוָֹה הָיְתָה זֹּאת הִיא נִפְלָאת בְּעֵינֵינוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","עַל־כֵּן אֲנִי אֹמֵר לָכֶם כִּי תוּסַר מַלְכוּת הָאֱלֹהִים מִכֶּם וְתִנָּתֵן לְגוֹי אֲשֶׁר יִתֵּן אֶת־פִּרְיָהּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","וְהַנֹּפֵל עַל־הָאֶבֶן הַזֹּאת יִתְפּוֹרָר וְכָל־מִי אֲשֶׁר תִּפֹּל עָלָיו תְּדַכְּאֶנּוּ לֶעָפָר׃ ");
INSERT INTO hebsg_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","וְרָאשֵׁי הַכֹּהֲנִים וְהַפְּרוּשִׁים בְּשָׁמְעָם אֶת־מְשָׁלָיו יָדְעוּ כִּי עֲלֵיהֶם דִּבֵּר׃ ");
INSERT INTO hebsg_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","וַיְבַקְשׁוּ לְתָפְשׂוֹ אַךְ יָרְאוּ מִפְּנֵי הֲמוֹן הָעָם כִּי חִשְּׁבוּ אֹתוֹ לְנָבִיא׃ ");
INSERT INTO hebsg_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","וַיַּעַן יֵשׁוּעַ עוֹד וַיִּשָּׂא לָהֶם מְשָׁלוֹ לֵאמֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","דָּמְתָה מַלְכוּת הַשָּׁמַיִם לְמֶלֶךְ אֲשֶׁר הֵכִין חֲתֻנָּה לִבְנוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","וַיִּשְׁלַח אֶת־מְשָׁרְתָיו לִקְרֹא אֶת־הַקְּרֻאִים אֶל־הַמִּשְׁתֶּה וְלֹא אָבוּ לָבֹא׃ ");
INSERT INTO hebsg_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","וַיֹּסֶף וַיִּשְׁלַח מְשָׁרְתִים אֲחֵרִים לֵאמֹר הַגִּידוּ לַקְּרֻאִים הִנֵּה הֲכִינוֹתִי הַכֵּרָה הַבָּקָר וְהַמְּרִיאִים טְבוּחִים וְהַכֹּל עָרוּךְ בֹּאוּ־נָא אֶל־מִשְׁתֵּה הַחֲתֻנָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","וְהֵם לֹא־שָׁתוּ לִבָּם גַּם־לָזֹאת וַיֵּלְכוּ לָהֶם אִישׁ אֶל־שָׂדֵהוּ וְאִישׁ אֶל־מִסְחָרוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","וְהַנִּשְׁאָרִים מֵהֶם תָּפְשׂוּ בִמְשָׁרְתָיו וַיָּזִידוּ עֲלֵיהֶם וַיַּהַרְגוּם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","וַיִּתְעַבֵּר הַמֶּלֶךְ וַיִּשְׁלַח אֶת־צְבָאָיו וַיַּשְׁמֵד אֶת־הַמְרַצְּחִים הָאֵלֶּה וְאֶת־עִירָם שָׁלַח בָּאֵשׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","אָז אָמַר אֶל־מְשָׁרְתָיו מִשְׁתֵּה־הַחֲתֻנָּה עָרוּךְ וְהַקְּרֻאִים לֹא־נִמְצְאוּ כֵן׃ ");
INSERT INTO hebsg_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","לָכֵן לְכוּ־נָא אֶל־פֶּתַח עֵינַיִם בְּרֹאשׁ נְתִיבוֹת וְכָל־אִישׁ אֲשֶׁר תִּמְצְאוּ קִרְאוּ אֹתוֹ אֶל־הַמִּשְׁתֶּהּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","וַיֵּצְאוּ הַמְשָׁרְתִים הָהֵם אֶל־הַנְּתִיבוֹת וַיַּאַסְפוּ מִכֹּל אֲשֶׁר מָצָאוּ גַּם־רָעִים וְגַם־טוֹבִים וַיִּמָּלֵא בֵית־הַחֲתֻנָּה אֶת־הַקְּרֻאִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","וַיְהִי כְּבוֹא הַמֶּלֶךְ לִרְאוֹת אֶת־הַבָּאִים וַיַּרְא אִישׁ מֵהֶם אֲשֶׁר אֵינֶנּוּ מְלֻבָּשׁ לְבוּשׁ הַחֲתֻנָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","וַיֹּאמֶר אֵלָיו רֵעִי אֵיךְ בָּאתָ הֲלֹם בִּלְתִּי מְלֻבָּשׁ לְבוּשׁ הַחֲתֻנָּה וַיְהִי כְּמַחֲרִישׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","וַיְצַו הַמֶּלֶךְ אֶת־מְשָׁרְתָיו לֵאמֹר אִסְרוּ אֹתוֹ יָדָיו וְרַגְלָיו וּנְשָׂאתֶּם וְהַשְׁלִיכֻהוּ אֶל־מְקוֹם אֹפֶל וְצַלְמָוֶת שָׁם יִהְיֶה בְכִי וַחֲרֹק שִׁנָּיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","כִּי רַבִּים הֵם הַנִּקְרָאִים וְהַנִּבְחָרִים מְעַטִּים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","אָז הָלְכוּ הַפְּרוּשִׁים וַיִּוָּעֲצוּ יַחְדָּו אֵיךְ יְנַקְּשֻׁהוּ בִדְבָרָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","וַיִּשְׁלְחוּ אֵלָיו אֶת־תַּלְמִידֵיהֶם עִם־אַנְשֵׁי הוֹרְדוֹס לֵאמֹר רַבִּי יָדַעְנוּ כִּי־אִישׁ נֶאֱמָן אַתָּה וְאֶת־דֶּרֶךְ אֱלֹהִים תּוֹרֶה בְמֵישָׁרִים לֹא תָגוּר מִפְּנֵי־אִישׁ כִּי לֹא תִשָּׂא פְּנֵי־גָבֶר׃ ");
INSERT INTO hebsg_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","לָכֵן הַגֶּד־לָנוּ מַה־יֶּהְגֶּה לִבֶּךָ הֲנָכוֹן הוּא לָתֵת מַס לַקֵּיסַר אִם־אַיִן׃ ");
INSERT INTO hebsg_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","וְיֵשׁוּעַ יָדַע אֶת־מְזִמָּתָם וַיֹּאמַר חֲנֵפִים לָמָּה־זֶּה תְּנַסּוּנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","הַרְאוּנִי אֶת־כֶּסֶף הַמָּס וַיָּבִיאוּ אֵלָיו אֶת־הַכָּסֶף׃ ");
INSERT INTO hebsg_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","וַיֹּאמֶר אֲלֵיהֶם לְמִי הַתְּמוּנָה וְהַכְּתֹבֶת הָהֵנָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","וַיֹּאמְרוּ אֵלָיו לַקֵּיסָר וַיֹּאמֶר אֲלֵיהֶם עַל־כֵּן הָבוּ לַקֵּיסַר אֵת אֲשֶׁר לַקֵּיסַר וְלֵאלֹהִים אֵת אֲשֶׁר לֵאלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","וַיִּשְׁמְעוּ וַיִּשְׁתָּאוּ וַיַּעַזְבוּ אֹתוֹ וַיֵּלְכוּ לָהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","בַּיּוֹם הַהוּא נִגְּשׁוּ אֵלָיו צַדּוּקִים הָאֹמְרִים כִּי אֵין תְּקוּמָה לַמֵּתִים וַיִּשְׁאָלֻהוּ לֵאמֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","רַבִּי הִנֵּה מֹשֶׁה אָמַר אִישׁ כִּי־יָמוּת וּבָנִים אֵין־לוֹ וְיִבֵּם אָחִיו אֶת־אִשְׁתּוֹ וְהֵקִים זֶרַע עַל־שֵׁם אָחִיו׃ ");
INSERT INTO hebsg_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","וְאִתָּנוּ הָיוּ שִׁבְעָה אַחִים הָרִאשׁוֹן לָקַח לוֹ אִשָּׁה וַיָּמָת וְזֶרַע לֹא הִשְׁאִיר אַחֲרָיו וַיַּעֲזֹב אֶת־אִשְׁתּוֹ לְאָחִיו׃ ");
INSERT INTO hebsg_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","וּכְמוֹ־כֵן גַּם־הַשֵּׁנִי וְגַם־הַשְּׁלִישִׁי עַד הַשְּׁבִיעִי׃ ");
INSERT INTO hebsg_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","וְאַחֲרֵי כֻלָּם מֵתָה הָאִשָּׁה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","וְעַתָּה לְמִי מִן־הַשִּׁבְעָה תִּהְיֶה לְאִשָּׁה בַתְּקוּמָה אַחֲרֵי אֲשֶׁר הָיְתָה אֵשֶׁת כֻּלָּם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","וַיַּעַן יֵשׁוּעַ וַיֹּאמֶר אֲלֵיהֶם שְׁגִיתֶם כִּי לֹא יְדַעְתֶּם אֶת־הַתּוֹרָה וְלֹא אֶת־גְּבוּרַת הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","כִּי בַּתְּקוּמָה לֹא יִבְעֲלוּ וְלֹא תִבָּעַלְנָה כִּי אִם־יִהְיוּ כְּמַלְאֲכֵי־אֵל בַּשָּׁמָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","וְעַל־דְּבַר תְּקוּמַת הַמֵּתִים הֲלֹא קְרָאתֶם אֵת אֲשֶׁר־נֶאֱמַר לָכֶם מִפִּי הָאֱלֹהִים לֵאמֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","אָנֹכִי אֱלֹהֵי אַבְרָהָם וֵאלֹהֵי יִצְחָק וֵאלֹהֵי יַעֲקֹב וַיהוָֹה אֵינֶנּוּ אֱלֹהֵי הַמֵּתִים כִּי אִם־אֱלֹהֵי הַחַיִּים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","וַיִּשְׁמְעוּ הֲמוֹן הָעָם וַיֹּאמְרוּ מַה־נִּפְלְאָה תּוֹרָתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","וְהַפְּרוּשִׁים שָׁמְעוּ כִּי סָכַר פִּי הַצַּדּוּקִים וַיִּוָּעֲדוּ שָׁם יַחְדָּו׃ ");
INSERT INTO hebsg_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","וְתַלְמִיד חָכָם אֶחָד מֵהֶם שָׁאַל אֹתוֹ וַיְנַסֵּהוּ לֵאמֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","רַבִּי אֵי־זוּ הִיא הַמִּצְוָה הַגְּדוֹלָה בַּתּוֹרָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","וַיֹּאמֶר יֵשׁוּעַ אֵלָיו וְאָהַבְתָּ אֵת יְהוָֹה אֱלֹהֶיךָ בְּכָל־לְבָבְךָ וּבְכָל־נַפְשְׁךָ וּבְכָל־מַדָּעֶךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","זוּ הִיא הַמִּצְוָה הַגְּדֹלָה וְהָרִאשֹׁנָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","וְהַשְּׁנִיָּה דָּמְתָה לָּהּ וְאָהַבְתָּ לְרֵעֲךָ כָּמוֹךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","וְעַל־שְׁתֵּי הַמִּצְוֹת הָאֵלֶּה תְּלוּיִים כָּל־הַתּוֹרָה וְהַנְּבִיאִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","וַיְהִי בְּהִתְאַסֵּף הַפְּרוּשִׁים שָׁאַל אֹתָם יֵשׁוּעַ לֵאמֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","מַה־תֹּאמְרוּן עַל־הַמָּשִׁיחַ בֶּן־מִי הוּא וַיֹּאמְרוּ אֵלָיו בֶּן־דָּוִד׃ ");
INSERT INTO hebsg_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","וַיֹּאמֶר אֲלֵיהֶם אִם־כֵּן אֵפוֹא אֵיךְ קֹרֵא לוֹ דָּוִד בָּרוּחַ אָדוֹן בְּאָמְרוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","נְאֻם יְהוָֹה לַאדֹנִי שֵׁב לִימִינִי עַד־אָשִׁית אֹיְבֶיךָ הֲדֹם לְרַגְלֶיךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","וְאִם־דָּוִד קֹרֵא לוֹ אָדוֹן אֵיךְ הוּא בְנוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","וְלֹא־יָכֹל אִישׁ לְהַשִׁיב אֹתוֹ דָּבָר גַּם־לֹא הֵעֵז עוֹד אִישׁ לְהִתְוַכַּח אִתּוֹ בִּדְבָרִים מֵהַיּוֹם הַהוּא וָמָעְלָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","אָז יְדַבֵּר יֵשׁוּעַ אֶל־הֲמוֹן הָעָם וְאֶל־תַּלְמִידָיו לֵאמֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","הַסּוֹפְרִים וְהַפְּרוּשִׁים יֹשְׁבִים עַל־כִּסֵּא מֹשֶׁה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","לָכֵן כֹּל אֲשֶׁר־יֹאמְרוּ אֲלֵיכֶם לִשְׁמֹר תִּשְׁמְרוּ וַעֲשִׂיתֶם אַךְ כְּמַעֲשֵׂיהֶם אַל־תַּעֲשׂוּ כִּי הֵם אֹמְרִים וְאֵינָם עֹשִׂים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","כִּי קֹשְׁרִים מַשָּׂא קָשֶׁה כָּבֵד מִנְּשׁא וְעֹמְסִים עַל־שְׁכֶם אֲנָשִׁים וְאֵין אֶת־נַפְשָׁם לְהָנִיעַ אֹתוֹ גַּם־בְּאֶצְבָּעָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","וְכָל־מַעֲשֵׂיהֶם יַעֲשׂוּן לְהֵרָאוֹת בָּם לְעֵינֵי בְנֵי־אָדָם יַרְחִיבוּ לָהֶם הַתְּפִלִּין וְהַצִּיצִית יַגְדִּילוּן׃ ");
INSERT INTO hebsg_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","וְאֹהֲבִים הֵם אֶת־הַמְּקֹמוֹת הַנִּכְבָּדִים בְּבָתֵּי הַמִּשְׁתֶּה וְאֶת־הַמּוֹשָׁבוֹת הָרִאשֹׁנִים בְּבָתֵּי־הַכְּנֵסֶת׃ ");
INSERT INTO hebsg_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","שְׁאֵלַת שָׁלוֹם לָהֶם בַּשְּׁוָקִים וּלְהִקָּרֵא בְּשֵׁם רַבִּי בְּפִי הָאֲנָשִׁים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","אָכֵן אַתֶּם אַל־יִקָּרֵא לְאִישׁ מִכֶּם רַבִּי כִּי רַב אֶחָד לָכֶם הַמָּשִׁיח וְאַתֶּם כֻּלְּכֶם אַחִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","וְאַל־תֹּאמְרוּ לְאִישׁ בָּאָרֶץ אָבִי אַתָּה כִּי אָב אֶחָד לָכֶם הוּא אֲשֶׁר בַּשָּׁמָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","וְאַל־יִקָּרֵא לְאִישׁ מִכֶּם מוֹרֶה דֶרֶךְ כִּי מוֹרֶה אֶחָד לָכֶם הַמָּשִׁיחַ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","וְהַגָּדוֹל בֵּינֵיכֶם יִהְיֶה לִמְשָׁרֵת לָכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","וְהַמִּתְנַשֵּׂא בְגַאֲוָתוֹ יִשָּׁפֵל וּשְׁפַל רוּחַ יִנָּשֵׂא׃ ");
INSERT INTO hebsg_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","אַךְ־אוֹי לָכֶם סוֹפְרִים וּפְרוּשִׁים חֲנֵפִים כִּי תִסְגְּרוּ מַלְכוּת הַשָּׁמַיִם מִפְּנֵי בְנֵי־הָאָדָם אַתֶּם לֹא תָבֹאוּ שָׁמָּה וְאֶת־הַבָּאִים לֹא תִתְּנוּ לָבֹא׃ ");
INSERT INTO hebsg_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","אוֹי לָכֶם סוֹפְרִים וּפְרוּשִׁים חֲנֵפִים כִּי תֹאכְלוּן אֶת־בָּתֵי הָאַלְמָנוֹת וּלְמַרְאֵה עַיִן תַּרְבּוּ תְפִילָּה וְלָכֵן גַם־קַו הַמִּשְׁפָּט יִנָּטֶה עֲלֵיכֶם פִּי־שְׁנָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","אוֹי לָכֶם סוֹפְרִים וּפְרוּשִׁים חֲנֵפִים כִּי תָּסֹבּוּ יָם וְיַבָּשָׁה לַעֲשׂוֹת גֵּר אֶחָד וְאַחֲרֵי אֲשֶׁר נַעֲשָׂה כֵן תַּעֲשׂוּהוּ לְבֶן־גֵּיהִנֹּם כִּפְלַיִם יוֹתֵר מִכֶּם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","אוֹי לָכֶם מְנַהֲלִים עִוְרִים הָאֹמְרִים כִּי יִשָּׁבַע אִישׁ בַּהֵיכָל אֵין־דָּבָר וְכִי יִשָּׁבַע בִּזְהַב הַהֵיכָל שְׁבוּעָתוֹ עָלָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","סְכָלִים וְעִוְרִים מָה הוּא הַגָּדוֹל הַזָּהָב אוֹ הַהֵיכָל הַמְקַדֵּשׁ אֶת־הַזָּהָב׃ ");
INSERT INTO hebsg_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","וְכִי־יִשָּׁבַע אִישׁ בַּמִּזְבֵּחַ אֵין־דָּבָר וְכִי־יִשָּׁבַע בַּקָּרְבָּן אֲשֶׁר עַל־גַּבּוֹ שְׁבוּעָתוֹ עָלָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","עִוְרִים מָה הוּא הַגָּדוֹל הַקָּרְבָּן אוֹ הַמִּזְבֵּחַ הַמְקַדֵּשׁ אֶת־הַקָּרְבָּן׃ ");
INSERT INTO hebsg_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","לָכֵן הַנִּשְׁבָּע בַּמִּזְבֵּחַ נִשְׁבַּע בּוֹ וּבְכָל אֲשֶׁר עַל־גַּבּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","וְהַנִּשְׁבָּע בַּהֵיכָל נִשְׁבַּע בּוֹ וּבַשֹּׁכֵן בּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","וְהַנִּשְׁבָּע בַּשָּׁמָיִם נִשְׁבַּע בְּכִסֵּא אֱלֹהִים וּבַיֹּשֵׁב עָלָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","אוֹי לָכֶם סוֹפְרִים וּפְרוּשִׁים חֲנֵפִים כִּי תְעַשְּׂרוּ אֶת־הַמִּנְתָּא וְאֶת־הַשֶּׁבֶת וְאֶת־הַכַּמֹּן וְתַעַזְבוּ אֶת־הַנִּכְבָּדוֹת בַּתּוֹרָה אֶת־הַמִּשְׁפָּט אֶת־הַחֶסֶד וְאֶת־הָאֱמוּנָה אֵלֶּה עֲלֵיכֶם לַעֲשׂוֹת וְאֶת־אֵלֶּה אַל־תַּעֲזֹבוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","מְנַהֲלִים עִוְרִים הַמְסַנְּנִים אֶת־הַיַּתּוּשׁ וּבֹלְעִים אֶת־הַגָּמָל׃ ");
INSERT INTO hebsg_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","אוֹי לָכֶם סוֹפְרִים וּפְרוּשִׁים חֲנֵפִים הַמְטַהֲרִים אֶת־הַכּוֹס וְאֶת־הַקְּעָרָה מִחוּץ וּמִבִּפְנִים מְלֵאוֹת הֵן עֹשֶׁק וְעַוְלָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","פָּרוּשׁ עִוֵּר טַהֵר רִאשֹׁנָה אֶת־הַכּוֹס וְאֶת־הַקְּעָרָה מִבִּפְנִים וְאָז תִּטְהַרְנָה גַּם־מִחוּץ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","אוֹי לָכֶם סוֹפְרִים וּפְרוּשִׁים חֲנֵפִים הַדֹּמִים לִקְבָרִים מְלֻבָּנִים בַּשִּׂיד הַנִּרְאִים יָפִים מִחוּץ וּמִבִּפְנִים מְלֵאִים הֵם עַצְמוֹת אָדָם וְכָל־טֻמְאָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","כֵּן נִרְאִים גַּם־אַתֶּם מִחוּץ כְּצַדִּיקִים לְעֵינֵי אֲנָשִׁים וּמִבִּפְנִים הִנְּכֶם מְלֵאִים חֹנֶף וָאָוֶן׃ ");
INSERT INTO hebsg_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","אוֹי לָכֶם סוֹפְרִים וּפְרוּשִׁים חֲנֵפִים הַבֹּנִים אֶת־קִבְרֵי הַנְּבִיאִים וְאֶת־מַצְּבוֹת קְבֻרַת הַצַּדִּיקִים תְּפָאֵרוּן׃ ");
INSERT INTO hebsg_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","וְתֹאמְרוּן אִם־הָיִינוּ בִימֵי אֲבוֹתֵינוּ לֹא־הָיְתָה יָדֵנוּ עִמָּהֶם לִשְׁפֹּךְ דַּם־הַנְּבִיאִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","עַל־כֵּן עֵדִים אַתֶּם בָּכֶם כִּי־בָנִים הִנְּכֶם לַאֲשֶׁר הָרְגוּ אֶת־הַנְּבִיאִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","וְגַם־אַתֶּם מַלְאוּ כַּיּוֹם אֶת־מִדַּת אֲבוֹתֵיכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","נְחָשִׁים יִלְדֵי צִפְעֹנִים אֵיכָה תִנָּצְלוּ מִדִּין גֵּיהִנֹּם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","עַל־כֵּן הִנְנִי שֹׁלֵחַ אֲלֵיכֶם נְבִיאִים חֲכָמִים וְסוֹפְרִים וּמֵהֶם תַּהַרְגוּ וְתִצְלְבוּ וּמֵהֶם תְּיַסְּרוּ בְּבָתֵּי הַכְּנֵסֶת אֲשֶׁר לָכֶם וְתִרְדְּפוּם מֵעִיר לָעִיר׃ ");
INSERT INTO hebsg_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","לְבַעֲבוּר יָבֹא עֲלֵיכֶם כָּל־דָּם נָקִי הַשָּׁפוּךְ עַל־הָאָרֶץ מִדַּם־הֶבֶל הַצַּדִּיק עַד־דַּם זְכַרְיָה בֶן־בֶּרֶכְיָה אֲשֶׁר הֲרַגְתֶּם אֹתוֹ בֵּין הַהֵיכָל וְלַמִּזְבֵּחַ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","אָמֵן אֲנִי אֹמֵר לָכֶם כִּי כָּל־אֵלֶּה יָבֹאוּ עַל־הַדּוֹר הַזֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","יְרוּשָׁלַיִם יְרוּשָׁלַיִם הַהֹרֶגֶת אֶת־הַנְּבִיאִים וְהַסֹּקֶלֶת אֶת־הַשְּׁלוּחִים אֵלָיִךְ עַד־כַּמֶּה פְּעָמִים חָפַצְתִּי לְקַבֵּץ אֶת־בָּנַיִךְ כַּאֲשֶׁר תְּקַבֵּץ תַּרְנְגֹלֶת אֶת־אֶפְרֹחֶיהָ תַּחַת כְּנָפֶיהָ וְלֹא אֲבִיתֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","הִנֵּה בֵיתְכֶם יִשָּׁאֵר לָכֶם חָרְבָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","כִּי אֲנִי אֹמֵר לָכֶם לֹא תִרְאוּנִי עוֹד מִן־הַיּוֹם הַזֶּה עַד כִּי־תֹאמְרוּן בָּרוּךְ הַבָּא בְּשֵׁם יְהוָֹה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","וַיֵּצֵא יֵשׁוּעַ מִן־הַהֵיכָל וַיֵּלֶךְ לְדַרְכּוֹ וַיִּגְּשׁוּ אֵלָיו תַּלְמִידָיו לְהַרְאֹתוֹ אֶת־בִּנְיְנֵי הַהֵיכָל׃ ");
INSERT INTO hebsg_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","וַיַּעַן יֵשׁוּעַ וַיֹּאמֶר אֲלֵיהֶם הֲלֹא רְאִיתֶם כָּל־אֵלֶּה אָמֵן אֲנִי אֹמֵר לָכֶם כִּי כֻלָּם יֵהָרְסוּן וְלֹא־תִשָּׁאֵר אֶבֶן עַל־אָבֶן׃ ");
INSERT INTO hebsg_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","וּבְשִׁבְתּוֹ עַל־הַר הַזֵּיתִים וַיִּגְּשׁוּ אֵלָיו תַּלְמִידָיו לְבַדָּם וַיֹּאמְרוּ הַגֶּד־נָא לָנוּ מָתַי תִּקְרֶאנָה אֵלֶּה וּמָה אוֹת בּוֹאֲךָ וְקֵץ הָעוֹלָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","וַיַּעַן יֵשׁוּעַ וַיֹּאמֶר אֲלֵיהֶם הִשָּׁמְרוּ לָכֶם פֶּן־יַתְעֶה אֶתְכֶם אִישׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","כִּי רַבִּים יָבֹאוּ בִשְׁמֵי לֵאמֹר אֲנִי הוּא הַמָּשִׁיחַ וְהִתְעוּ אֶת־רַבִּים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","וְהָיָה כִּי־תִשְׁמְעוּ מִלְחָמָה אוֹ שְׁמֻעוֹת מִלְחָמָה רְאוּ אַל־תִּבָּהֵלוּ כִּי כָל־אֵלֶּה תִּקְרֶאנָה וְעוֹד לֹא הַקֵּץ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","כִּי יָקוּם גּוֹי עַל־גּוֹי וּמַמְלָכָה עַל־מַמְלָכָה וְהָיָה רָעָב וְדֶבֶר וְרַעַשׁ בִּמְקוֹמוֹת רַבִּים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","וְכָל־אֵלֶּה רַק רֵאשִׁית הַחֲבָלִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","אָז יָצִיקוּ לָכֶם מִסָּבִיב וְהָרְגוּ בָכֶם וּשְׂנוּאִים תִּהְיוּ לְכָל־הָעַמִּים בַּעֲבוּר שְׁמִי׃ ");
INSERT INTO hebsg_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","וְרַבִּים יִכָּשְׁלוּ אָז וְהִסְגִּירוּ אִישׁ אֶת־רֵעֵהוּ וְאִישׁ אֶת־אָחִיו יִשְׂנָאוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","וְקָמוּ נְבִיאֵי שֶׁקֶר רַבִּים וְהִתְעוּ רַבִּים אַחֲרֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","וְאַחֲרֵי אֲשֶׁר יִרְבֶּה הַפָּשַׁע תָּפוּג אַהֲבַת רַבִּים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","אַךְ הַמְחַכֶּה עַד־הַקֵּץ הוּא יִוָּשֵׁעַ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","וּבְשׂוֹרַת הַמַּלְכוּת הַזֹּאת תִּקָּרֵא בְכָל־הָאָרֶץ לְעֵדוּת לְכָל־הַגּוֹיִם וְאַחַר יָבֹא הַקֵּץ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","לָכֵן כַּאֲשֶׁר תִּרְאוּ אֶת־הַשִּׁקּוּץ הַמְשֹׁמֵם הָאָמוּר בְּיַד־דָּנִיֵּאל הַנָּבִיא עֹמֵד בִּמְקוֹם קֹדֶשׁ וְהַמַּשְׂכִּיל יָבִין׃ ");
INSERT INTO hebsg_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","אָז אֵלֶּה אֲשֶׁר בִּיהוּדָה יָנוּסוּ אֶל־הֶהָרִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","וּמִי אֲשֶׁר עַל־הַגָּג לֹא יֵרֵד לָקַחַת דָּבָר מִבֵּיתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","וּמִי אֲשֶׁר בַּשָּׂדֶה לֹא יָשׁוּב לְבֵיתוֹ לָשֵׂאת אֶת־שִׂמְלָתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","אַךְ־אוֹי לֶהָרוֹת וְלַמֵּינִיקוֹת בַּיָּמִים הָהֵמָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","וְאַתֶּם הִתְפַּלְלוּ לְבִלְתִּי תִהְיֶה מְנוּסַתְכֶם בַּחֹרֶף וְלֹא בַּשַּׁבָּת׃ ");
INSERT INTO hebsg_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","כִּי אָז תִּהְיֶה צָרָה גְדוֹלָה אֲשֶׁר כָּמוֹהָ לֹא־נִהְיְתָה מֵרֵאשִׁית יְמוֹת עוֹלָם וְעַד־הַיּוֹם הַזֶּה וְכָמוֹהָ לֹא־תֹסִף׃ ");
INSERT INTO hebsg_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","וְלוּלֵא יִקְצְרוּ הַיָּמִים הָאֵלֶּה לֹא יִנָּצֵל כָּל־בָּשָׂר אַךְ לְמַעַן הַבְּחִירִים הַיָּמִים הָאֵלֶּה יִקְצָרוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","וְאָז אִם־יֹאמַר אֲלֵיכֶם אִישׁ הִנֵּה הַמָּשִׁיחַ פֹּה אוֹ הִנּוֹ־שָׁם אַל־תַּאֲמִינוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","כִּי מְשִׁיחֵי־שֶׁקֶר וּנְבִיאֵי־כָזָב יָקוּמוּ וְנָתְנוּ אֹתוֹת וּמוֹפְתִים גְּדֹלִים לְנַסּוֹת אִם יֶשׁ־לְאֵל יָדָם לְהַתְעוֹת גַּם־אֶת־הַבְּחִירִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","רְאוּ כִּי מֵרֹאשׁ הִגַּדְתִּי לָכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","לָכֵן כִּי־יֹאמְרוּ לָכֶם הִנּוֹ בַמִּדְבָּר אַל־תֵּצֵאוּ הִנּוֹ בַחֲדָרִים אַל־תַּאֲמִינוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","כִּי כַּבָּרָק יֵצֵא מִמִּזְרָח וְיֵרָאֶה עַד־אַחֲרִית יָם כֵּן תִּהְיֶה בִּיאַת פְּנֵי בֶן־הָאָדָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","בַּאֲשֶׁר פְּגָרִים שָׁם יִקָּבְצוּ הַנְּשָׁרִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","וְאַחֲרֵי צוֹק הָעִתִּים הָאֵלֶּה פִּתְאֹם תֶּחְשַׁךְ הַשֶּׁמֶשׁ וְהַיָּרֵחַ לֹא יַגִּיהַּ אוֹרוֹ הַכּוֹכָבִים יִפְּלוּ מִן־הַשָּׁמַיִם וּצְבָא הַמָּרוֹם יָזֻעוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","אָז יֵרָאֶה אוֹת בֶּן־הָאָדָם בַּשָּׁמָיִם וְסָפְדוּ כָּל־מִשְׁפְּחוֹת הָאֲדָמָה וְרָאוּ אֶת־בֶּן־הָאָדָם בָּא בְּעַנְנֵי הַשָּׁמַיִם בְּעֹז וּבְהָדָר גָּדוֹל׃ ");
INSERT INTO hebsg_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","וְהוּא יִשְׁלַח אֶת־מַלְאָכָיו בְּקוֹל שׁוֹפָר חָזָק וְקִבְּצוּ אֶת־בְּחִירָיו מֵאַרְבַּע הָרוּחוֹת מִקְצֵה הַשָּׁמַיִם עַד־קְצֵה הַשָּׁמָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","קְחוּ לָכֶם מָשָׁל מִן־הַתְּאֵנָה אִם רָטוֹב עֲנָפָהּ וְעָלֶיהָ צָמָחוּ יֹדְעִים אַתֶּם כִּי קָרוֹב הַקָּיִץ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","וְכֵן גַּם־כַּאֲשֶׁר תִּרְאוּ כָּל־אֵלֶּה יָדוֹעַ תֵּדְעוּ כִּי־קָרוֹב הוּא לַפָּתַח׃ ");
INSERT INTO hebsg_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","אָמֵן אֲנִי אֹמֵר לָכֶם כִּי לֹא יַעֲבֹר הַדּוֹר הַזֶּה עַד אֲשֶׁר־יָקוּמוּ כָּל־אֵלֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","הַשָּׁמַיִם וְהָאָרֶץ יַעֲבֹרוּ וּדְבָרַי לֹא יַעֲבֹרוּן׃ ");
INSERT INTO hebsg_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","וְעַל־מוֹעֵד הַיּוֹם הַהוּא וְהַשָּׁעָה הַהִיא אֵין אִישׁ יֹדֵעַ וְלֹא מַלְאָךְ בַּשָּׁמַיִם בִּלְתִּי הָאָב לְבַדּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","וְכִימֵי נֹחַ כֵּן בִּיאַת בֶּן־הָאָדָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","כִּי כַּאֲשֶׁר לִפְנֵי יְמֵי הַמַּבּוּל אָכְלוּ וְשָׁתוּ בָּעֲלוּ נָשִׁים וְנָשִׁים נִבְעָלוּ עַד־הַיּוֹם אֲשֶׁר־בָּא נֹחַ אֶל־הַתֵּבָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","וְהֵם לֹא יָדְעוּ עַד כִּי־בָא הַמַּבּוּל וַיִּמַח אֶת־כֻּלָּם כֵּן תִּהְיֶה בִּיאַת בֶּן־הָאָדָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","אָז יִהְיוּ שְׁנַיִם בַּשָּׂדֶה אֶחָד יֵאָסֵף וְאֶחָד יֵעָזֵב׃ ");
INSERT INTO hebsg_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","שְׁתַּיִם טֹחֵנוֹת בָּרֵחָיִם אַחַת תֵּאָסֵף וְאַחַת תֵּעָזֵב׃ ");
INSERT INTO hebsg_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","לָכֵן הִתְיַצְּבוּ עַל־מִשְׁמַרְתְּכֶם כִּי אֵינְכֶם יֹדְעִים שָׁעָה בּוֹא אֲדֹנֵיכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","רַק זֹאת שִׂימוּ עַל־לֵב כִּי לוּ־יָדַע בַּעַל הַבַּיִת אֶת־הָאַשְׁמוּרָה בָּהּ יָבוֹא הַגַּנָּב הָיָה עֹמֵד עַל־מִשְׁמַרְתּוֹ וְלֹא נָתַן לַחְתֹּר אֶת־בֵּיתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","לָכֵן גַּם־אַתֶּם הֱיוּ נְכֹנִים כִּי בֶן־הָאָדָם יָבוֹא בְשָׁעָה אֲשֶׁר לֹא תָשִׂמוּ עַל־לֵב׃ ");
INSERT INTO hebsg_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","וּמִי־אֵפוֹא הוּא עֶבֶד נֶאֱמָן וְנָבוֹן אֲשֶׁר אֲדֹנָיו הִפְקִידוֹ עַל־בְּנֵי בֵיתוֹ לָתֵת לָהֶם אָכְלָם בְּעִתּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","אַשְׁרֵי הָעֶבֶד הַהוּא אֲשֶׁר בְּבֹא אֲדֹנָיו יִמְצָאֶנּוּ כִּי כֵן עָשָׂה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","אָמֵן אֲנִי אֹמֵר לָכֶם כִּי יַפְקִדֵהוּ עַל־כָּל־אֲשֶׁר יֶשׁ־לוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","וְאִם עֶבֶד רָע יֹאמַר בְּלִבּוֹ בֹּשֵׁשׁ אֲדֹנִי לָבוֹא׃ ");
INSERT INTO hebsg_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","וְהֵחֵל לְהַכּוֹת אֶת־אֶחָיו הָעֲבָדִים וְלֶאֱכֹל וְלִשְׁתּוֹת עִם־הַסֹּבְאִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","בּוֹא יָבוֹא אֲדֹנֵי הָעֶבֶד הַזֶּה בְּיוֹם אֲשֶׁר לֹא יְצַפֶּה לּוֹ וּבְשָׁעָה אֲשֶׁר לֹא יֵדָע׃ ");
INSERT INTO hebsg_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","וְאָז יְשַׁסֵּף אֹתוֹ וְנָתַן אֶת־חֶלְקוֹ עִם־הַחֲנֵפִים שָׁם יִהְיֶה בְכִי וַחֲרֹק שִׁנָּיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","אָז תִּדְמֶה מַלְכוּת הַשָּׁמַיִם לְעֶשֶׂר בְּתוּלוֹת אֲשֶׁר לָקְחוּ אֶת־נֵרֹתֵיהֶן וַתֵּצֶאנָה לִקְרַאת הֶחָתָן׃ ");
INSERT INTO hebsg_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","חָמֵשׁ מֵהֵן בְּנוֹת־כֶּסֶל וְחָמֵשׁ בְּנוֹת תְּבוּנָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","וְהַכְּסִילוֹת לָקְחוּ אֶת־נֵרֹתֵיהֶן וְלֹא־לָקְחוּ עִמָּהֶן שָׁמֶן׃ ");
INSERT INTO hebsg_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","וְהַנְּבוֹנוֹת לָקְחוּ שֶׁמֶן בִּכְלֵיהֶן עִם־הַנֵּרוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","וְכַאֲשֶׁר אֵחַר הֶחָתָן לָבֹא נָמוּ יָשְׁנוּ כֻלָּן׃ ");
INSERT INTO hebsg_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","וַיְהִי בַּחֲצִי הַלַּיְלָה וַתַּעֲבֹר הָרִנָּה הִנֵּה הֶחָתָן בָּא צְאֶינָה לִקְרָאתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","אָז הֵקִיצוּ כָּל־הַבְּתוּלוֹת הָאֵלֶּה וַתֵּיטַבְנָה אֶת־נֵרֹתֵיהֶן׃ ");
INSERT INTO hebsg_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","וַתֹּאמַרְנָה הַכְּסִילוֹת אֶל־הַנְּבוֹנוֹת תְּנֶינָה לָנוּ מִשַּׁמְנְכֶן פֶּן־יִכְבּוּ נֵרֹתֵינוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","וְהַנְּבוֹנוֹת עָנוּ לֵאמֹר לֹא כֵן פֶּן־לֹא יִשְׂפֹּק לָנוּ וְלָכֶן לֵכְנָה אֶל־מֹכְרֵי שֶׁמֶן וּקְנֶינָה לָכֵן׃ ");
INSERT INTO hebsg_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","וַיְהִי בְּלֶכְתָּן לִקְנוֹת וְהִנֵּה הֶחָתָן בָּא וְאֵלֶּה אֲשֶׁר נָכֹנוּ בָּאוּ אִתּוֹ אֶל־חֲתֻנָּתוֹ וְהַדֶּלֶת נִסְגָּרָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","וְאַחֲרֵי־כֵן בָּאוּ יֶתֶר הַבְּתוּלוֹת וַתֹּאמַרְנָה אֲדֹנֵינוּ אֲדֹנֵינוּ פְּתַח־נָא לָנוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","וְהוּא עָנָה וְאָמַר אָמֵן אֲנִי אֹמֵר לָכֶן כִּי לֹא יָדַעְתִּי אֶתְכֶן׃ ");
INSERT INTO hebsg_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","עַל־כֵּן עִמְדוּ עַל־מִשְׁמַרְתְּכֶם כִּי אֵינְכֶם יֹדְעִים אֶת־הַיּוֹם וְאֶת־הַשָּׁעָה אֲשֶׁר יָבֹא בָהּ בֶּן־הָאָדָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","כִּי כְּמוֹ־אִישׁ נֹסֵעַ אֶל־מִחוּץ לָאָרֶץ אֲשֶׁר קָרָא לַעֲבָדָיו וַיַּפְקֵד בְּיָדָם אֶת־הוֹנוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","לְאֶחָד מֵהֶם נָתָן חָמֵשׁ כִּכָּרִים לְאַחֵר שְׁתַּיִם וּלְאַחֵר אֶחָת לְאִישׁ אִישׁ כְּפִי יְכֹלֶת יָדוֹ וַיְמַהֵר וַיִּסַּע לְדַרְכּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","וְזֶה אֲשֶׁר לָקַח חָמֵשׁ הַכִּכָּרִים הָלַךְ וַיִּסְחַר בָּהֶן וַיַּעַשׂ חָמֵשׁ כִּכָּרִים אֲחֵרוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","וְכֵן זֶה אֲשֶׁר לָקַח שְׁתָּיִם רָכַשׁ שְׁתַּיִם אֲחֵרוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","וְזֶה אֲשֶׁר לָקַח אֶת־הַכִּכָּר הָאֵחַת אָזַל לוֹ וַיַּחְפֹּר בָּאֲדָמָה וַיִּטְמֹן אֶת־כֶּסֶף אֲדֹנָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","וְאַחֲרֵי יָמִים רַבִּים שָׁב אֲדוֹן הָעֲבָדִים הָאֵלֶּה מִדַּרְכּוֹ וַיְחַשֵּׁב עִמָּהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","וַיִּגַּשׁ זֶה אֲשֶׁר לָקַח חָמֵשׁ הַכִּכָּרִים וַיָּבֵא חָמֵשׁ כִּכָּרִים אֲחֵרוֹת לֵאמֹר אֲדֹנִי חָמֵשׁ כִּכָּרִים נָתַתָּ בְּיָדִי וְהִנֵּה רָכַשְׁתִּי עוֹד חָמֵשׁ כִּכָּרִים אֲחֵרוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","וַיַּעַן אֹתוֹ אֲדֹנָיו הֵיטַבְתָּ עֶבֶד טוֹב וְנֶאֱמָן נֶאֱמָן הָיִיתָ בִמְעַט וַאֲנִי אַפְקִידְךָ עַל־הַרְבֵּה בֹּא אֶל־שִׂמְחַת אֲדֹנֶיךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","וְזֶה אֲשֶׁר לָקַח כִּכְּרַיִם נִגַּשׁ גַּם־הוּא וַיֹּאמַר אֲדֹנִי שְׁתֵּי כִכָּרִים נָתָתָּ לִּי וְהִנֵּה רָכַשְׁתִּי עֲלֵיהֶן עוֹד כִּכְּרָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","וַיַּעַן אֹתוֹ אֲדֹנָיו הֵיטַבְתָּ עֶבֶד טוֹב וְנֶאֱמָן נֶאֱמָן הָיִיתָ בִמְעַט וַאֲנִי אַפְקִידְךָ עַל־הַרְבֵּה בֹּא אֶל־שִׂמְחַת אֲדֹנֶיךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","וַיִּגַּשׁ גַּם־זֶה אֲשֶׁר לָקַח כִּכָּר אַחַת וַיֹּאמַר אֲדֹנִי יְדַעְתִּיךָ כִּי־אִישׁ קָשֶׁה אָתָּה קֹצֵר בַּאֲשֶׁר לֹא זָרַעְתַּ וְכֹנֵס בַּאֲשֶׁר לֹא פִזָּרְתָּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","וָאִירָא וָאֵלֵךְ וָאֶטְמֹן כִּכָּרְךָ בָּאֲדָמָה וְעַתָּה הֵא־לְךָ אֵת אֲשֶׁר־לָךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","וַיַּעַן אֲדֹנָיו וַיֹּאמֶר אֵלָיו עֶבֶד רָע וְעָצֵל יָדַעְתָּ כִּי־קֹצֵר אֲנִי בַּאֲשֶׁר לֹא זָרַעְתִּי וְכֹנֵס אֲנִי בַּאֲשֶׁר לֹא פִזָּרְתִּי׃ ");
INSERT INTO hebsg_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","וְעַל־כֵּן הָיָה עָלֶיךָ לָתֵת כַּסְפִּי לְמַחֲלִיפֵי־כָסֶף וַאֲנִי בְּבֹאִי הָיִיתִי מֹצֵא אֵת אֲשֶׁר־לִי בְּתַרְבִּית׃ ");
INSERT INTO hebsg_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","לָכֵן קְחוּ אֶת־הַכִּכָּר מִיָּדוֹ וּתְנוּ לָזֶה אֲשֶׁר־לוֹ כִּכָּרִים עָשֶׂר׃ ");
INSERT INTO hebsg_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","כִּי מִי אֲשֶׁר יֶשׁ־לוֹ יִנָּתֵן־לוֹ וְיַעְדִּיף וּמִי אֲשֶׁר אֵין־לוֹ יֻקַּח מִמֶּנּוּ גַּם אֵת אֲשֶׁר יֶשׁ־לוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","וְאֶת הָעֶבֶד הַזֶּה אֲשֶׁר לֹא יִצְלַח לַכֹּל הַשְׁלִיכוּ אֶל־אֹפֶל וְצַלְמָוֶת שָׁם יִהְיֶה בְכִי וַחֲרֹק שִׁנָּיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","וְהָיָה כִּי יָבוֹא בֶּן־הָאָדָם בִּגְדֻלָּתוֹ וְכָל־הַמַּלְאָכִים הַקְּדשִׁים עִמּוֹ אָז יֵשֵׁב עַל־כִּסֵּא כְבוֹדוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","וְנִקְבְּצוּ לְפָנָיו כָּל־הַגּוֹיִם וְהִפְרִיד בֵּינֵיהֶם בֵּין אֶחָד לָאֶחָד כַּאֲשֶׁר יַפְרִיד הָרֹעֶה אֶת־הַכְּשָׂבִים מִבֵּין הָעִזִּים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","וְהֶעֱמִיד אֶת־הַכְּשָׂבִים לִימִינוֹ וְאֶת־הָעִזִּים לִשְׂמֹאלוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","אָז יֹאמַר הַמֶּלֶךְ לַאֲשֶׁר מִימִינוֹ בֹּאוּ בְּרוּכֵי אָבִי וּרְשׁוּ אֶת־הַמַּלְכוּת אֲשֶׁר הִתְעַתְּדָה לָכֶם לְמִן־הִוָּסֵד עוֹלָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","כִּי רָעַבְתִּי וַתַּאֲכִילֻנִי צָמֵאתִי וַתַּשְׁקוּנִי אֹרֵחַ הָיִיתִי וַתַּאַסְפוּנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","עֵרֹם וַתְּכַסֻּנִי חָלִיתִי וַתְּבַקְּרֻנִי עָצוּר בַּכֶּלֶא הָיִיתִי וַתָּבֹאוּ אֵלָי׃ ");
INSERT INTO hebsg_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","אָז יַעֲנוּ אֹתוֹ הַצַּדִּיקִים לֵאמֹר אֲדֹנֵינוּ מָתַי רְאִינוּךָ רָעֵב וַנַּשְׂבִּיעֶךָ אוֹ צָמֵא וַנַּשְׁקֶךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","מָתַי רְאִינוּךָ אֹרֵחַ וַנְּאַסְפֶךָ אוֹ עֵרֹם וַנְּכַסֶּךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","וּמָתַי רְאִינוּךָ חֹלֶה אוֹ עָצוּר בַּכֶּלֶא וַנָּבֹא אֵלֶיךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","וְהַמֶּלֶךְ יַעֲנֶה אֹתָם לֵאמֹר אָמֵן אֲנִי אֹמֵר לָכֶם אֵת אֲשֶׁר עֲשִׂיתֶם לְאֶחָד מֵאַחַי הַקְּטַנִּים הָאֵלֶּה לְנַפְשִׁי עֲשִׂיתֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","אָז יֹאמַר גַּם־לַאֲשֶׁר מִשְּׂמֹאלוֹ לְכוּ מֵעָלַי אֲרוּרִים אֶל־אֵשׁ עוֹלָם אֲשֶׁר הִתְעַתְּדָה לְשָׂטָן וּלְמַלְאָכָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","כִּי רָעַבְתִּי וְלֹא נְתַתֶּם לִי לֶאֱכֹל צָמֵאתִי וְלֹא נְתַתֶּם לִי לִשְׁתּוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","אֹרֵחַ הָיִיתִי וְלֹא אֲסַפְתּוּנִי עֵרֹם וְלֹא כִסִּיתוּנִי חֹלֶה הָיִיתִי וְעָצוּר בַּכֶּלֶא וְלֹא בִקַּרְתּוּנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","וְהֵם גַּם־הֵם יַעֲנוּ אֵלָיו לֵאמֹר אֲדֹנֵינוּ מָתַי רְאִינוּךָ רָעֵב אוֹ צָמֵא אוֹ אֹרֵחַ אוֹ עָרֹם אוֹ חֹלֶה אוֹ עָצוּר בַּכֶּלֶא וְלֹא בָאנוּ לְעֶזְרֶךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","וְהוּא יַעֲנֶה אֹתָם לֵאמֹר אָמֵן אֲנִי אֹמֵר לָכֶם אֵת אֲשֶׁר לֹא עֲשִׂיתֶם לְאַחַד הַקְּטַנִּים הָאֵלֶּה לְנַפְשִׁי לֹא עֲשִׂיתֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","וְכֵן יֵלְכוּ אֵלֶּה לְדִרְאוֹן עוֹלָם וְהַצַּדִּיקִים לְחַיֵּי עוֹלָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","וַיְּהִיא כַּאֲשֶׁר כִּלָּה יֵשׁוּעַ לְדַבֵּר כָּל־הַדְּבָרִים הָאֵלֶּה ַֹויאמֶר אֶל־תַּלְמִידָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","הֲלֹא יְדַעְתֶּם כִּי אַחֲרֵי יוֹמַיִם יִהְיֶה הַפָּסַח וְאֵת בֶּן־הָאָדָם יַסְגִּירוּ לְהִצָּלֵב׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","וַיִּקְּהֲלוּ רָאשֵׁי הַכֹּהֲנִים וְהַסּוֹפְרִים וְזִקְנֵי הָעָם אֶל־חֲצַר הַכֹּהֵן הַגָּדוֹל וּשְׁמוֹ קַיָּפָא׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","וַיִּוָּעֲצוּ לִתְפֹּשׂ אֶת־יֵשׁוּעַ בְּעָרְמָה וְלַהֲמִיתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","אַךְ אָמְרוּ לֹא בֶחָג פֶּן־תִּתְעֹרֵר מְהוּמָה בָּעָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","וַיְהִי בִּהְיוֹת יֵשׁוּעַ בְּבֵית־עַנְיָה בְּבֵית שִׁמְעוֹן הַמְּצֹרָע׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","וַתָּבֹא אֵלָיו אִשָּׁה וּבְיָדָהּ צְלֹחִית שֶׁמֶן יְקַר־עֵרֶךְ מְאֹד וַתִּצֹּק עַל־רֹאשׁוֹ בִּמְסִבּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","וַיִּרְאוּ הַתַּלְמִידִים וַיִּחַר לָהֶם לֵאמֹר עַל־מֶה נִבְלַע הַשֶּׁמֶן הַזֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","הֲלֹא טוֹב הָיָה לְתִתּוֹ בְכֶסֶף רָב וְלַחֲלֹק מִכְרוֹ לָעֲנִיִּים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","וַיֵּדַע יֵשׁוּעַ וַיֹּאמֶר אֲלֵיהֶם לָמָּה־זֶּה תַּלְאוּ אֶת־הָאִשָּׁה הֲלֹא טוֹב גְּמָלָתְנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","כִּי אֶת־הָעֲנִיִּים תִּמְצְאוּ לִפְנֵיכֶם תָּמִיד וְאוֹתִי לֹא תִמְצְאוּ תָּמִיד לִפְנֵיכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","כִּי בַּאֲשֶׁר יָצְקָה הַשֶּׁמֶן הַזֶּה עַל־גְּוִיָּתִי הֵכִינָה אֹתִי לִקְבֻרָתִי׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","אָמֵן אֲנִי אֹמֵר לָכֶם בְּכָל־מָקוֹם אֲשֶׁר תִּשָּׁמַע הַבְּשׂוֹרָה הַזֹּאת בְּכָל־הָאָרֶץ יְסֻפַּר גַּם אֲשֶׁר עָשְׂתָה הִיא לָהּ לְזִכָּרוֹן׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","אָז קָם אֶחָד מִשְּׁנֵים הֶעָשָׂר וּשְׁמוֹ יְהוּדָה אִישׁ־קְרִיּוֹת וַיֵּלֶךְ אֶל־רָאשֵׁי הַכֹּהֲנִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","וַיֹּאמֶר מַה־תֹּאמְרוּ לָתֶת־לִי כִּי אַסְגִּיר אֹתוֹ בְּיֶדְכֶם וַיִּשְׁקְלוּ־לוֹ שְׁלֹשִׁים כָּסֶף׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","וּמִן־הָעֵת הַהִיא בִּקֶּשׁ־לוֹ תֹּאֲנָה לְהַסְגִּיר אֹתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","וְלִפְנֵי הָרִאשׁוֹן לְחַג הַמַּצּוֹת בָּאוּ הַתַּלְמִידִים לִפְנֵי יֵשׁוּעַ לֵאמֹר אֵיפֹה תִרְצֶה כִּי־נָכִין לְךָ לֶאֱכֹל אֶת־הַפָּסַח׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","וַיֹּאמֶר לְכוּ הָעִירָה לִפְלֹנִי אַלְמֹנִי וְהִגַּדְתֶּם לוֹ כֹּה אָמַר רַבֵּנוּ הֵן עִתִּי בָאָה וְהִנְנִי לָחֹג אֶת־חַג הַפֶּסַח עִם־תַּלְמִידַי בְּבֵיתֶךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","וַיַּעֲשׂוּ הַתַּלְמִידִים כַּאֲשֶׁר צִוָּה אֹתָם יֵשׁוּעַ וַיָּכִינוּ אֶת־הַפָּסַח׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","וַיְהִי בָּעָרֶב וַיֵּשֶׁב בִּמְסִבּוֹ עִם־שְׁנֵים עָשָׂר׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","וּבְעוֹד הֵם אֹכְלִים וַיֹּאמַר אָמֵן אֲנִי אֹמֵר לָכֶם כִּי־אֶחָד מִכֶּם יַסְגִּיר אֹתִי׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","וַיִּתְעַצְּבוּ אֶל־לִבָּם עַד־מְאֹד וַיָּחֵלּוּ לֵאמֹר לוֹ הַאֲנִי הוּא אֲדֹנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","וַיַּעַן וַיֹּאמַר הַטֹּבֵל אֶת־יָדוֹ עִמִּי בַּקְּעָרָה הוּא הַמַּסְגִיר אֹתִי׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","הֵן בֶּן־הָאָדָם הֹלֵךְ כַּכָּתוּב עָלָיו אַךְ אוֹי לָאִישׁ הַהוּא אֲשֶׁר יַסְגִּיר אֵת בֶּן־הָאָדָם בְּיַד מְבַקְשֵׁי נַפְשׁוֹ טוֹב הָיָה לָאִישׁ הַהוּא אִם־לֹא יָצָא מֵרָחֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","וִיהוּדָה הַמַּסְגִּיר אֹתוֹ עָנָה וְאָמַר הַאֲנִי הוּא רַבִּי וַיֹּאמֶר אֵלָיו אַתָּה אָמָרְתָּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","וּבְאָכְלָם וַיִּקַּח יֵשׁוּעַ אֶת־הַלֶּחֶם וַיְבָרֶךְ וַיִּבְצַע וַיִּתֵּן לַתַּלְמִידִים וַיֹּאמַר קְחוּ אִכְלוּ זֶה הוּא בְּשָׂרִי׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","וַיִּקַּח אֶת־הַכּוֹס וַיְבָרֶךְ וַיִּתֵּן לָהֶם לֵאמֹר שְׁתוּ כֻלְּכֶם מִמֶּנָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","כִּי זֶה הוּא דָמִי דַּם־הַבְּרִית הַחֲדָשָׁה הַשָּׁפוּךְ בְּעַד רַבִּים לִסְלִיחַת חַטֹּאתָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","וַאֲנִי מַגִּיד לָכֶם כִּי מֵעַתָּה לֹא אֶשְׁתֶּה עוֹד מִפְּרִי הַגֶּפֶן הַזֶּה עַד הַיּוֹם הַהוּא אֲשֶׁר חָדָשׁ אֶשְׁתֵּהוּ עִמָּכֶם בְּמַלְכוּת אָבִי׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","וַיִּקְרְאוּ אֶת־הַהַלֵּל וַיֵּצְאוּ אֶל־הַר הַזֵּיתִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","אָז אָמַר אֲלֵיהֶם יֵשׁוּעַ הֵן כֻּלְּכֶם תִּכָּשְׁלוּ בִי בַּלַּיְלָה הַזֶּה כִּי כָּתוּב אַכֶּה אֶת־הָרֹעֶה וּתְפוּצֶיןָ הַצֹּאן׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","וְאַחֲרֵי תְקוּמָתִי מִן־הַמֵּתִים אֵלֵךְ לִפְנֵיכֶם הַגָּלִילָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","וַיַּעַן פֶּטְרוֹס וַיֹּאמֶר אֵלָיו אַף אִם־כֻּלָּם יִכָּשְׁלוּ בְךָ אֲנִי לֹא אֶכָּשֵׁל לְעוֹלָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","וַיֹּאמֶר אֵלָיו יֵשׁוּעַ אָמֵן אֲנִי אֹמֵר לָךְ כִּי בַּלַּיְלָה הַזֶּה טֶרֶם יִקְרָא הַתַּרְנְגֹל תְּכַחֶשׁ־בִּי שָׁלֹשׁ פְּעָמִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","וַיֹּאמֶר אֵלָיו פֶּטְרוֹס אַף אִם־יִהְיֶה עָלַי לָמוּת אִתְּךָ כַּחַשׁ לֹא אֲכַחֶשׁ־בָּךְ וְכֵן דִּבְּרוּ גַּם כָּל־הַתַּלְמִידִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","וְאַחֲרֵי־כֵן בָּא יֵשׁוּעַ עִמָּהֶם אֶל־הַמָּקוֹם הַנִּקְרָא גַּת־שְׁמֵנָה וַיֹּאמֶר אֶל־תַּלְמִידָיו שְׁבוּ־לָכֶם פֹּה עַד־כִּי אֵלֵךְ וְהִתְפַּלַּלְתִּי שָׁמָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","וַיִּקַּח אִתּוֹ אֶת־פֶּטְרוֹס וְאֶת־שְׁנֵי בְנֵי זַבְדִּי וַיָּחֶל לְהִתְיַפֵּחַ וּלְהִשּׁוֹמֵם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","וַיֹּאמֶר אֲלֵיהֶם נַפְשִׁי מָרָה־לִי מְאֹד עַד־מָוֶת עִמְדוּ בָזֶה וְשִׁקְדוּ עִמִּי׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","וַיַּעֲבֹר הָלְאָה מְעַט־מִזְעָר וַיִּפֹּל עַל־פָּנָיו וַיִּתְפַּלֵּל וַיֹּאמַר אָבִי אִם־יִתָּכֵן הַדָּבָר תַּעֲבָר־נָא הַכּוֹס הַזֹּאת מֵעָלַי אַךְ לֹא כִרְצוֹנִי כִּי אִם־כַּאֲשֶׁר רָצִיתָ אָתָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","וַיָּבֹא אֶל־הַתַּלְמִידִים וַיִּמְצָאֵם יְשֵׁנִים וַיֹּאמֶר אֶל־פֶּטְרוֹס הַאִם לֹא־הָיָה לְאֵל יֶדְכֶם לִשְׁקֹד עִמִּי שָׁעָה אֶחָת׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","שִׁקְדוּ וְהִתְפַּלְּלוּ פֶּן־תָּבֹאוּ לְמַסָּה הֵן הָרוּחַ חֲפֵצָה אַךְ הַבָּשָׂר רָפֶה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","וַיּוֹסֶף וַיֵּלֶךְ־לוֹ שֵׁנִית וַיִּתְפַּלֵּל וַיֹּאמַר אָבִי אִם זֹאת לֹא תִתָּכֵן לַעֲבֹר בִּלְתִּי אִם־שָׁתִיתִי אוֹתָהּ יֵעָשֶׂה רְצוֹנֶךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","וַיּוֹסֶף וַיָּשָׁב וַיִּמְצָאֵם יְשֵׁנִים עוֹד כִּי עֵינֵיהֶם הָיוּ כְּבֵדוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","וַיַּעֲזֹב אֹתָם וַיֵּלֶךְ עוֹד וַיִּתְפַּלֵּל שְׁלִישִׁית וַיְדַבֵּר כַּדְּבָרִים הָאֵלֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","אָז שָׁב אֶל־תַּלְמִידָיו וַיֹּאמֶר אֲלֵיהֶם תְּנוּ שֵׁנָה לְעֵינֵיכֶם וּמְנוּחָה הִנֵּה בָּאָה הַשָּׁעָה וּבֶן־הָאָדָם נִסְגַּר בִּידֵי חַטָּאִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","קוּמוּ וְנֵלֵכָה הִנֵּה הַמַּסְגִּיר אֹתִי הֹלֵךְ וְקָרֵב׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","עוֹדֶנּוּ מְדַבֵּר וְהִנֵּה יְהוּדָה אֶחָד מִשְּׁנֵים הֶעָשָׂר בָּא וְעִמּוֹ הָמוֹן־רַב בַּחֲרָבוֹת וּבְמַטּוֹת מֵאֵת רָאשֵׁי הַכֹּהֲנִים וְזִקְנֵי הָעָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","וְהַמַּסְגִּיר אֹתוֹ נָתַן לָהֶם אוֹת לֵאמֹר הָאִישׁ אֲשֶׁר אֲנַשֶּׁק־לוֹ זֶה הוּא תִּפְשׂוּ אֹתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","וַיְמַהֵר וַיִּגַּשׁ אֶל־יֵשׁוּעַ וַיֹּאמֶר הֲשָׁלוֹם לְךָ רַבִּי וַיִּשָּׁקֵהוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","וַיֹּאמֶר אֵלָיו יֵשׁוּעַ רֵעִי עַל־מֶה בָּאתָ וְהֵם נָפְלוּ עַל־יֵשׁוּעַ וַיִּשְׁלְחוּ בּוֹ אֶת־יְדֵיהֶם וַיִּתְפְּשֻׂהוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","וְהִנֵּה אֶחָד מֵאַנְשֵׁי יֵשׁוּעַ שָׁלַח אֶת־יָדוֹ וַיִּשְׁלֹף אֶת־חַרְבּוֹ וַיַּךְ אֶת־עֶבֶד הַכֹּהֵן הַגָּדוֹל וַיְקַצֵּץ אֶת־אָזְנוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","וַיֹּאמֶר אֵלָיו יֵשׁוּעַ הָשֵׁב חַרְבְּךָ אֶל־מְקוֹמָהּ כִּי כָּל־תֹּפְשֵׂי חֶרֶב בַּחֶרֶב יֹאבֵידוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","אוֹ הֲתֹאמַר בְּלִבְּךָ כִּי לֹא אוּכַל לִשְׁאֹל מֵאֵת אָבִי אֲשֶׁר יִשְׁלַח לִי גַּם־עַתָּה רַב מִשְּׁנֵים עָשָׂר גְּדוּדִים מַלְאָכִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","אֲבָל אֵיךְ יִכֹּנוּ הַכְּתוּבִים כִּי כָל־אֵלֶּה תִּקְרֶאנָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","בָּעֵת הַהִיא אָמַר יֵשׁוּעַ אֶל־הֲמוֹן הָעָם הֲבַחֲרָבוֹת וּבְמַטּוֹת בָּאתֶם לִתְפֹּשׂ אֹתִי כְּפָרִיץ וְיוֹם יוֹם יָשַׁבְתִּי לְהוֹרֹת לָכֶם בַּמִּקְדָּשׁ וְלֹא שְׁלַחְתֶּם בִּי יָד׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","אֲבָל כָּל־זֹאת הָיְתָה לְמַלֹּאת אֶת־כִּתְבֵי הַנְּבִיאִים אָז עָזְבוּ אֹתוֹ תַלְמִידָו כֻּלָּם וַיָּנֻסוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","וְתֹפְשֵׂי יֵשׁוּעַ הוֹלִיכוּ אֹתוֹ אֶל־קַיָּפָא הַכֹּהֵן הַגָּדוֹל אֲשֶׁר בְּבֵיתוֹ נִקְהֲלוּ הַסּוֹפְרִים וְהַזְּקֵנִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","וּפֶטְרוֹס הָלַךְ אַחֲרָיו מֵרָחוֹק עַד־לַחֲצַר הַכֹּהֵן הַגָּדוֹל וַיָּבוֹא וַיֵּשֶׁב שָׁם עִם־הַמְשָׁרְתִים לִרְאוֹת אֵיךְ יִפֹּל דָּבָר׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","וְרָאשֵׁי הַכֹּהֲנִים וְהַזְּקֵנִים וְכָל־הַסַּנְהֶדְרִין בִּקְשׁוּ עֵדוּת שֶׁקֶר עַל־יֵשׁוּעַ לַהֲמִיתוֹ וְלֹא מָצָאוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","וְאַף כִּי עֵדֵי־שֶׁקֶר רַבִּים בָּאוּ שָׁם לֹא מָצָאוּ וְאַחֲרֵי־כֵן נִגְּשׁוּ שְׁנָיִם עֵדֵי־שֶׁקֶר׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","וַיַּעֲנוּ כִּי זֶה אָמַר יָדִי רָב לִי לַהֲרֹס אֶת־הֵיכַל הָאֱלֹהִים וְלִבְנוֹתוֹ בִּשְׁלֹשֶׁת יָמִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","וַיָּקָם הַכֹּהֵן הַגָּדוֹל וַיֹּאמֶר אֵלָיו הֲלֹא תַעֲנֶה דָבָר מָשׂתגה־זֹּאת הֵעִידוּ בְךָ אֵלֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","וַיִּדֹּם יֵשׁוּעַ וַיֹּאמֶר אֵלָיו הַכֹּהֵן הַגָּדוֹל הִנְנִי מַשְׁבִּיעֲךָ בֵּאלֹהִים חַיִּים כִּי תַגִּיד לָנוּ אִם־אַתָּה הוּא הַמָּשִׁיחַ בֶּן־הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","וַיֹּאמֶר אֵלָיו יֵשׁוּעַ אַתָּה אָמָרְתָּ אָכֵן אֲנִי מַגִּיד לָכֶם כִּי מֵעַתָּה תִרְאוּ אֶת־בֶּן־הָאָדָם יֹשֵׁב לִימִין הַגְּבוּרָה וּבָא בְּעַנְנֵי הַשָּׁמָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","אָז יִקְרַע הַכֹּהֵן הַגָּדוֹל אֶת־בְּגָדָיו לֵאמֹר מְגַדֵּף הוּא מַה־לָּנוּ עוֹד וּלְעֵדִים הִנֵּה זֶה שְׁמַעְתֶּם גִּדּוּפוֹ מִפִּיו׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","אִמְרוּ מַה־דַּעְתְּכֶם וַיַּעֲנוּ וַיֹּאמְרוּ מִשְׁפַּט־מָוֶת לוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","אָז יָרְקוּ בְּפָנָיו וַיַּכֻּהוּ בְּאֶגְרֹף וְיֵשׁ מֵהֶם אֲשֶׁר מַחֲאוּ אֹתוֹ מַכַּת לֶחִי׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","וַיֹּאמְרוּ הִנָּבֵא לָנוּ מָשִׁיחַ מִי זֶה הַמַּכֶּה אֹתָךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","וּפֶטְרוֹס יָשַׁב מִחוּץ בְּתוֹךְ הֶחָצֵר וַתִּגַּשׁ אֵלָיו שִׁפְחָה אַחַת לֵאמֹר גַּם־אַתָּה הָיִיתָ עִם־יֵשׁוּעַ הַגָּלִילִי׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","וַיְכַחֵשׁ לְעֵינֵי כֻלָּם לֵאמֹר לֹא יָדַעְתִּי מָה־אַתְּ אֹמָרֶת׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","וַיֵּצֵא אֶל־הָאוּלָם וַתִּרְאֵהוּ שִׁפְחָה אַחֶרֶת וַתֹּאמֶר אֶל־הָעֹמְדִים שָׁם גַּם־זֶה הָיָה עִם־יֵשׁוּעַ הַנָּצְרִי׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","וַיּוֹסֶף לְכַחֵשׁ וַיִּשָּׁבַע לֵאמֹר לֹא יָדַעְתִּי אֶת־הָאִישׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","וְעוֹד מְעַט וַיִּגְּשׁוּ הָעֹמְדִים שָׁם וַיֹּאמְרוּ אֶל־פֶּטְרוֹס אוּלָם גַּם־אַתָּה אֶחָד מֵהֶם כִּי גַּם־בִּשְׂפָתְךָ תִּתְנַכֵּר׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","וַיָּחֶל לַעֲנוֹת בְּאָלָה וּבִשְׁבֻעָה לֵאמֹר לֹא יָדַעְתִּי אֶת־הָאִישׁ וּבְרֶגַע זֶה קָרָה הַתַּרְנְגֹל׃ ");
INSERT INTO hebsg_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","וַיִּזְכֹּר פֶּטְרוֹס אֶת־דְּבַר יֵשׁוּעַ אֲשֶׁר אָמַר כִּי־טֶרֶם יִקְרָא הַתַּרְנְגֹל תְּכַחֶשׁ־בִּי שָׁלֹשׁ פְּעָמִים וַיֵּצֵא הַחוּצָה וַיְמָרֵר בַּבֶּכִי׃ ");
INSERT INTO hebsg_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","הַבֹּקֶר אוֹר וְכָל־רָאשֵׁי הַכֹּהֲנִים וְזִּקְנֵי הָעָם נוֹסְדוּ יַחַד עַל־יֵשׁוּעַ לַהֲמִיתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","וַיַּאַסְרוּ אֹתוֹ וַיּוֹלִיכֻהוּ וַיַּסְגִּירֻהוּ בִידֵי פּוֹנְטִיוֹס פִילָטוֹס הַפֶּחָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","וַיַּרְא יְהוּדָה הַמַּסְגִּיר אֹתוֹ כִּי הִרְשִׁיעֻהוּ וַיִּנָּחֵם וַיָּשֶׁב אֶת־שְׁלֹשִׁים הַכֶּסֶף אֶל־רָאשֵׁי הַכֹּהֲנִים וְאֶל־הַזְּקֵנִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","וַיֹּאמַר חָטָאתִי בַּאֲשֶׁר הִסְגַּרְתִּי דָם נָקִי וְהֵם אָמְרוּ מַה־לָּנוּ וְלָזֹאת רְאֵה אָתָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","וַיַּשְׁלֵךְ אֶת־הַכֶּסֶף בַּהֵיכָל וַיֵּצֵא וַיֵּלֶךְ וַיֵּחָנַק׃ ");
INSERT INTO hebsg_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","וַיִּקְחוּ רָאשֵׁי הַכֹּהֲנִים אֶת־הַכֶּסֶף וַיֹּאמְרוּ לֹא־כַתּוֹרָה הוּא לְתִתּוֹ אֶל־הָאוֹצָר כִּי־שְׂכַר דָּמִים הוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","וַיִּוָּעֲצוּ וַיִּקְנוּ בַכֶּסֶף הַזֶּה אֶת־שְׂדֵה הַיּוֹצֵר לִקְבוּרַת גֵּרִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","עַל־כֵּן יִקָּרֵא לַשָּׂדֶה הַהוּא שְׂדֵה דָמִים עַד הַיּוֹם הַזֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","אָז הוּקַם הַדָּבָר אֲשֶׁר נֶאֱמַר בְּיַד־הַנָּבִיא לֵאמֹר וַיִּקְחוּ אֶת־שְׁלֹשִׁים הַכֶּסֶף אֶדֶר הַיְקָר אֲשֶׁר יָקַר מֵעַל־בְּנֵי יִשְׂרָאֵל׃ ");
INSERT INTO hebsg_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","וַיִּתְּנוּם בְּעַד־שְׂדֵה הַיּוֹצֵר כַּאֲשֶׁר צִוָּה אֹתִי אֲדֹנָי׃ ");
INSERT INTO hebsg_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","וְיֵשׁוּעַ עֹמֵד לִפְנֵי הַפֶּחָה וַיִּשְׁאַל אֹתוֹ הַפֶּחָה לֵאמֹר הַאַתָּה הוּא מֶלֶךְ הַיְּהוּדִים וַיֹּאמֶר אֵלָיו יֵשׁוּעַ אַתָּה אָמָרְתָּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","וְרָאשֵׁי הַכֹּהֲנִים וְהַזְּקֵנִים הֵבִיאוּ עָלָיו שִׂטְנָתָם וְלֹא עָנָה אֹתָם דָּבָר׃ ");
INSERT INTO hebsg_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","וַיֹּאמֶר אֵלָיו פִּילָטוֹס הֲלֹא שֹׁמֵעַ אַתָּה עַד־כַּמָּה הִכְבִּירוּ לַעֲנוֹת בָּךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","וְלֹא נָתַן לוֹ מַעֲנֶה אַף לֹא דָבָר אֶחָד עַד אֲשֶׁר־הָיָה לְפֶלֶא בְּעֵינֵי הַפֶּחָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","וּבֶחַג הַזֶּה הַסְכֵּן הִסְכִּין הַפֶּחָה לְשַׁלַּח אֶחָד מֵהָאֲסִירִים אֲשֶׁר יִבְחֲרוּ בוֹ הָעָם לַחָפְשִׁי׃ ");
INSERT INTO hebsg_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","וּבָעֵת הַהִיא הָיָה לָהֶם אִישׁ אָסִיר נוֹדַע לָעָם וּשְׁמוֹ בַּר־אַבָּא׃ ");
INSERT INTO hebsg_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","וַיְהִי בְּהִקָּהֲלָם וַיֹּאמֶר אֲלֵיהֶם פִּילָטוֹס בְּמִי תִבְחֲרוּ וַאֲשַׁלְּחֵהוּ לָכֶם בְּבַר־אַבָּא אוֹ בְיֵשׁוּעַ הַנִּקְרָא מָשִׁיחַ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","כִּי יָדַע אֲשֶׁר מִקִּנְאָתָם בּוֹ הִסְגִּירֻהוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","וְגַם־בְּשִׁבְתּוֹ בִּמְקוֹם הַמִּשְׁפָּט שָׁלְחָה לּוֹ אִשְׁתּוֹ לֵאמֹר אַל־תִּתְעָרַב בִּדְבַר הַצַּדִּיק הַזֶּה כִּי זֶה הַיּוֹם עֻנֵּיתִי בַחֲלוֹם עַד־מְאֹד עַל־אֹדוֹתָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","וְרָאשֵׁי הַכֹּהֲנִים וְהַזְּקֵנִים הֵסִיתוּ אֶת־הֲמוֹן הָעָם לִשְׁאֹל לָהֶם אֵת בַּר־אַבָּא וּלְהַשְׁמִיד אֶת־יֵשׁוּעַ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","וַיַּעַן הַפֶּחָה וַיֹּאמֶר אֲלֵיהֶם אֶת־מִי מִן־הַשְּׁנַיִם תַּחְפְּצוּ וַאֲשַׁלְּחֵהוּ לָכֶם וַיֹּאמְרוּ אֵת בַּר־אַבָּא׃ ");
INSERT INTO hebsg_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","וַיֹּאמֶר אֲלֵיהֶם פִּילָטוֹס וּמָה־אֶעֱשֶׂה לְיֵשׁוּעַ הַנִּקְרָא מָשִׁיחַ וַיֹּאמְרוּ כֻלָּם יִצָּלֵב׃ ");
INSERT INTO hebsg_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","וַיֹּאמֶר וְלָמָּה מֶה־רָעָה עָשָׂה וְהֵם הוֹסִיפוּ לִצְעֹק וְלֵאמֹר יִצָּלֵב׃ ");
INSERT INTO hebsg_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","וַיַּרְא פִּילָטוֹס כִּי לֹא־יָכֹל לָהֶם אַךְ עוֹד תּוֹסִיף הַמְּהוּמָה וַיִּקַּח מַיִם וַיִּרְחַץ אֶת־יָדָיו לְעֵינֵי הָעָם וַיֹּאמַר נָקִי אָנֹכִי מִדַּם הַצַּדִּיק הַזֶּה רְאוּ אַתֶּם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","וַיַּעֲנוּ כָל־הָעָם לֵאמֹר דָּמוֹ עָלֵינוּ וְעַל־בָּנֵינוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","אָז שִׁלַּח לָהֶם אֵת בַּר־אַבָּא וְאֵת יֵשׁוּעַ יִסַּר בַּשּׁוֹטִים וַיִּתְּנֵהוּ לְהִצָּלֵב׃ ");
INSERT INTO hebsg_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","וַיִּקְחוּ אַנְשֵׁי צְבָא הַפֶּחָה אֶת־יֵשׁוּעַ אֶל־חֲצַר הַמִּשְׁפָּט הוּא פְּרַטוֹרִין וַיַּזְעִיקוּ עָלָיו אֵת כָּל־הַגְּדוּד׃ ");
INSERT INTO hebsg_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","וַיַּפְשִׁיטוּ אֹתוֹ וַיַּלְבִּישֻׁהוּ מְעִיל אַרְגָּמָן׃ ");
INSERT INTO hebsg_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","וַיְשָׂרְגוּ כֶּתֶר קוֹצִים וַיָּשִׂימוּ עַל־רֹאשׁוֹ וְקָנֶה בִימִינוֹ וַיִּכְרְעוּ לְפָנָיו עַל־בִּרְכֵיהֶם וַיְהַתְּלוּ בוֹ לֵאמֹר יְחִי מֶלֶךְ הַיְּהוּדִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","וַיָּרֹקּוּ בְּפָנָיו וַיִּקְחוּ אֶת־הַקָּנֶה וַיַּכֻּהוּ עַל־רֹאשׁוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","וְאַחֲרֵי אֲשֶׁר הֵתֵלּוּ בוֹ הִפְשִׁיטוּ אֹתוֹ אֶת־הַמְּעִיל וַיַּלְבִּישֻׁהוּ אֶת־בְּגָדָיו וַיּוֹלִיכֻהוּ לִצְלֹב אֹתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","וְכַאֲשֶׁר יָצְאוּ פָּגְעוּ בְּאִישׁ קוּרִינִי וּשְׁמוֹ שִׁמְעוֹן אֹתוֹ אִלְּצוּ לַהֲלֹךְ אִתָּם וְלָשֵׂאת לוֹ אֶת־צְלָבוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","וַיָּבֹאוּ אֶל־הַמָּקוֹם הַנִּקְרָא גָּלְגָּלְתָּא אֲשֶׁר יֵאָמֵר מְקוֹם הַגֻּלְגֹּלֶת׃ ");
INSERT INTO hebsg_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","וַיִּתְּנוּ־לוֹ יַיִן מָהוּל בְּרֹאשׁ לִשְׁתּוֹת וַיִּטְעַם וְלֹא אָבָה לִשְׁתּוֹתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","וַיִּצְלְבוּ אֹתוֹ שָׁם וַיְחַלְּקוּ אֶת־בְּגָדָיו וַיַּפִּילוּ עֲלֵיהֶם גּוֹרָל לְמַלּאֹת אֶת אֲשֶׁר־נֶאֱמַר בְּפִי הַנָּבִיא יְחַלְּקוּ בְגָדַי לָהֶם וְעַל־לְבוּשִׁי יַפִּילוּ גוֹרָל׃ ");
INSERT INTO hebsg_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","וַיֵּשְׁבוּ וַיִּשְׁמְרוּ אֹתוֹ שָׁמָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","וַיָּשִׂימוּ דְבַר אַשְׁמָתוֹ בִּכְתֹבֶת מֵעַל לְרֹאשׁוֹ זֶה הוּא יֵשׁוּעַ מֶלֶךְ הַיְּהוּדִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","וְאַחֲרֵי־כֵן נִצְלְבוּ עִמּוֹ שְׁנֵי אַנְשֵׁי־חָמָס אֶחָד מִימִינוֹ וְאֶחָד מִשְּׂמֹאלוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","וְהָעֹבְרִים שָׁם גִּדְּפוּ אֹתוֹ וַיָּנִיעוּ אַחֲרָיו אֶת־רֹאשָׁם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","וַיֹאמְרוּ אַתָּה הוּא הַהֹרֵס אֶת־הַהֵיכָל וְהַבּוֹנֶה אֹתוֹ בִּשְׁלֹשֶׁת יָמִים הוֹשִׁיעָה אֶת־נַפְשֶׁךָ אִם בֶּן־אֱלֹהִים אַתָּה רְדָה מִן־הָעֵץ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","וְכֵן גַּם־שָׂחֲקוּ עָלָיו רָאשֵׁי הַכֹּהֲנִים עִם־הַסּוֹפְרִים וְהַזְּקֵנִים לֵאמֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","אֶת־אֲחֵרִים הוֹשִׁיעַ וְאֶת־נַפְשׁוֹ לֹא יוּכַל לְהוֹשִׁיעַ אִם־מֶלֶךְ יִשְׂרָאֵל הוּא יֵרֶד־נָא עַתָּה מִן־הָעֵץ וְנַאֲמִין בּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","בֹּטֵחַ בֵּאלֹהִים יַצִּילֵהוּ כִּי חָפֵץ בּוֹ כִּי הֲלֹא אָמַר בֶּן־הָאֱלֹהִים אָנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","וְגַם־אַנְשֵׁי־הֶחָמָס אֲשֶׁר נִצְלְבוּ עִמּוֹ חֵרְפֻהוּ כְּמוֹ־כֵן׃ ");
INSERT INTO hebsg_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","וְחֹשֶׁךְ כִּסָּה אֶת־פְּנֵי כָל־הָאָרֶץ מִן־הַשָּׁעָה הַשִּׁשִּׁית עַד הַשָּׁעָה הַתְּשִׁיעִית׃ ");
INSERT INTO hebsg_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","וּבַשָּׁעָה הַתְּשִׁיעִית צָעַק יֵשׁוּעַ בְּקוֹל גָּדוֹל לֵאמֹר אֱלָהִי אֱלָהִי לְמָה שְׁבַקְתָּנִי אֲשֶׁר יֵאָמֵר אֵלִי אֵלִי לָמָה עֲזַבְתָּנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","וּמִן־הָעֹמְדִים שָׁם כַּאֲשֶׁר שָׁמְעוּ אָמְרוּ הוּא קֹרֵא אֶל־אֵלִיָּהוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","וַיְמַהֵר אֶחָד מֵהֶם וַיָּרָץ וַיִּקַּח סְפוֹג אֲשֶׁר מִלְאוֹ חֹמֶץ וַיְשִׂימֵהוּ עַל־קָנֶה וַיַּשְׁקֵהוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","וְיֶתֶר הָאֲנָשִׁים אָמְרוּ הֶרֶף וְנִרְאֶה אִם־יָבֹא אֵלִיָּהוּ לְהוֹשִׁיעַ לוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","וְיֵשׁוּעַ הֹסִיף וַיִּקְרָא בְקוֹל גָּדוֹל וַיַּפְקֵד אֶת־רוּחוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","וְהִנֵּה פָּרֹכֶת הַהֵיכָל נִקְרְעָה לִשְׁנַיִם קְרָעִים מִלְמַעְלָה לְמָטָּה אֶרֶץ רָעֲשָׁה וְצוּרִים הִתְבַּקָּעוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","וּקְבָרִים נִפְתָּחוּ וַיָּקִיצוּ רַבִּים מֵעַצְמוֹת הַקְּדוֹשִׁים אֲשֶׁר בָּאָרֶץ יְשֵׁנִים הֵמָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","וַיֵּצְאוּ מִקִּבְרֵיהֶם אַחֲרֵי תְקוּמָתוֹ וַיָּבֹאוּ אֶל־עִיר הַקֹּדֶשׁ וַיֵּרָאוּ לָרַבִּים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","וְשַׂר־הַמֵּאָה וְהָאֲנָשִׁים אֲשֶׁר אִתּוֹ הַשֹּׁמְרִים אֶת־יֵשׁוּעַ בִּרְאוֹתָם אֶת־הָרַעַשׁ וְאֶת־כָּל־אֲשֶׁר קָרָה חָרְדוּ עַד־מְאֹד וַיֹּאמְרוּ אָכֵן זֶה הָיָה בֶּן־אֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","וְנָשִׁים רַבּוֹת אֲשֶׁר הָלְכוּ אַחֲרֵי יֵשׁוּעַ מִן־הַגָּלִיל לְשָׁרְתוֹ הָיוּ רֹאוֹת אֶת־הַנַּעֲשָׂה שָׁם מֵרָחוֹק׃ ");
INSERT INTO hebsg_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","וּבֵינֵהֶן הָיְתָה מִרְיָם הַמַּגְדָּלִית וּמִרְיָם אֵם־יַעֲקֹב וְיוֹסֵי וְאֵם בְּנֵי זַבְדִּי׃ ");
INSERT INTO hebsg_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","וַיְהִי בָעֶרֶב וַיָּבֹא אִישׁ עָשִׁיר מִן־הָרָמָתַיִם וּשְׁמוֹ יוֹסֵף וְגַם־הוּא הָיָה אֶחָד מִתַּלְמִידֵי יֵשׁוּעַ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","הוּא בָא אֶל־פִּילָטוֹס וַיִּשְׁאַל מִמֶּנּוּ אֶת־גּוּף יֵשׁוּעַ וַיְצַו פִּילָטוֹס כִּי־יִנָּתֵן לוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","וַיִּקַּח יוֹסֵף אֶת־הַגּוּף וַיַּעֲטֵהוּ בְּתַכְרִיךְ־בַּד טָהוֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","וַיְשִׂימֵהוּ בְּקֶבֶר חָדָשׁ אֲשֶׁר חָצַּב־לוֹ בַּצּוּר וַיָּגֶל אֶבֶן גְּדוֹלָה עַל־פִּי הַקֶּבֶר וַיֵּלַךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","וּמִרְיָם הַמַּגְדָּלִית וּמִרְיָם הָאַחֶרֶת הָיוּ יֹשְׁבוֹת שָׁם מִמּוּל הַקָּבֶר׃ ");
INSERT INTO hebsg_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","וַיְהִי מִמָּחֳרָת אַחֲרֵי עֶרֶב הַשַּׁבָּת וַיִּקָּהֲלוּ רָאשֵׁי הַכֹּהֲנִים וְהַפְּרוּשִׁים אֶל־פִּילָטוֹס׃ ");
INSERT INTO hebsg_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","וַיֹּאמְרוּ אֲדֹנֵינוּ זָכַרְנוּ כִּי בְּעוֹדֶנּוּ חַי אָמַר הַמַּתְעֶה הַהוּא מִקְצֵה שְׁלֹשֶׁת יַמִים אָקוּם׃ ");
INSERT INTO hebsg_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","לָכֵן צַוֵּה־נָא לִנְצֹר אֶת־הַקֶּבֶר עַד־יוֹם הַשְּׁלִישִׁי פֶּן־יָבֹאוּ תַלְמִידָיו בַּלַיְלָה וּגְנָבֻהוּ וְאָמְרוּ אֶל־הָעָם הִנֵּה־קָם מִן־הַמֵּתִים וְרָעָה הַמִּרְמָה הָאַחֲרֹנָה מִן־הָרִאשֹׁנָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","וַיֹּאמֶר אֲלֵיהֶם פִּילָטוֹס הֵא־לָכֶם אַנְשֵׁי מִשְׁמָר לְכוּ וְנִצְרוּ כַּאֲשֶׁר תֵּדָעוּן׃ ");
INSERT INTO hebsg_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","וַיֵּלְכוּ וַיִּצְּרוּ אֶת־הַקֶּבֶר וַיַּחְתְּמוּ אֶת־הָאָבֶן וַיַּעֲמִידוּ עָלָיו אֶת־הַמִּשְׁמָר׃ ");
INSERT INTO hebsg_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","וַיְהִי אַחַר הַשַּׁבָּת לִפְנוֹת־בֹּקֶר בְּאֶחָד־בַּשַּׁבָּת וַתָּבֹא מִרְיָם הַמַּגְדָּלִית וּמִרְיָם הָאַחֶרֶת לִרְאוֹת אֶת־הַקָּבֶר׃ ");
INSERT INTO hebsg_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","וַיְהִי רַעַשׁ גָּדוֹל כִּי־מַלְאַךְ יְהוָֹה יָרַד מִן־הַשָּׁמַיִם וַיָּבֹא וַיָּגֶל אֶת־הָאֶבֶן מִן־הַפֶּתַח וַיֵּשֶׁב עָלֶיהָ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","וּמַרְאֵהוּ כַּבָּרָק וּלְבוּשׁוֹ לָבָן כַּשָּׁלֶג׃ ");
INSERT INTO hebsg_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","וּמֵאֵימָתוֹ אַנְשֵׁי הַמִּשְׁמָר נִבְהָלוּ וַיִּהְיוּ כַּמֵּתִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","וַיַּעַן הַמַּלְאָךְ וַיֹּאמֶר אֶל־הַנָּשִׁים אַל־תִּירֶאןָ הֵן יָדַעְתִּי כִּי אֶת־יֵשׁוּעַ הַנִּצְלָב תְּבַקֵּשְׁנָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","אֵינֶנּוּ פֹה כִּי הוּא קָם כַּאֲשֶׁר אָמָר בֹּאנָה וּרְאֶינָה אֶת־הַמָּקוֹם אֲשֶׁר שָׁכַב־שָׁם הָאָדוֹן׃ ");
INSERT INTO hebsg_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","וּמִהַרְתֶּן אֶל־תַּלְמִידָיו וַאֲמַרְתֶּן כִּי הוּא קָם מִן־הַמֵּתִים וְהִנֵּה הוּא הוֹלֵךְ לִפְנֵיכֶם הַגָּלִילָה וְשָׁם תִּרְאוּ אֹתוֹ הִנֵּה אָמַרְתִּי לָכֶן׃ ");
INSERT INTO hebsg_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","וַתֵּצֶאנָה כְּרֶגַע מִן־הַקֶּבֶר בְּיִרְאָה וּבְשָׂשׂוֹן רָב וַתָּרֹצְנָה לְהַגִּיד לְתַלְמִידָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","הֵנָּה הֹלְכוֹת לְסַפֵּר אֶל־תַּלְמִידָיו וַיֵּרָא אֲלֵיהֶן יֵשׁוּעַ וַיֹּאמֶר שָׁלוֹם וַתִּגַּשְׁנָה וַתֹּאחַזְנָה בְרַגְלָיו וַתִּשְׁתַּחֲוֶיןָ לוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","וַיֹּאמֶר אֲלֵיהֶן יֵשׁוּעַ אַל־תִּירֶאנָה לֵכְנָה הַגֵּדְנָה לְאַחַי כִּי יֵלְכוּ הַגָּלִילָה וְשָׁם יִרְאוּנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","וַיְהִי בְּלֶכְתָּן וְהִנֵּה אֲנָשִׁים מֵאַנְשֵׁי הַמִּשְׁמָר בָּאוּ הָעִירָה וַיַּגִּידוּ לְרָאשֵׁי הַכֹּהֲנִים אֶת־כֹּל אֲשֶׁר קָרָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","וַיִּקָּהֲלוּ עִם־הַזְּקֵנִים וַיִּוָּעֲצוּ וַיִּתְּנוּ־כֶסֶף רָב אֶל־אַנְשֵׁי הַצָּבָא לֵאמֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","אִמְרוּ כִּי־בָאוּ תַלְמִידָיו לָיְלָה וַיִּגְנְבֻהוּ בְּעוֹד אֲנַחְנוּ יְשֵׁנִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","וְכִי־יִשָּׁמַע הַדָּבָר לְאָזְנֵי הַפֶּחָה אֲנַחְנוּ נְדַבֵּר עַל־לִבּוֹ וְהָיִינוּ לְמָגֵן לָכֶם מִכָּל־רָע׃ ");
INSERT INTO hebsg_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","וַיִּקְחוּ אֶת־הַכֶּסֶף וַיַּעֲשׂוּ כַּאֲשֶׁר שָׂמוּ בְּפִיהֶם וְהַשְּׁמוּעָה הַזֹּאת יָצְאָה בֵּין הַיְּהוּדִים עַד הַיּוֹם הַזֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","וְאַחַד עָשָׂר הַתַּלְמִידִים הָלְכוּ הַגָּלִילָה אֶל־הָהָר הַהוּא אֲשֶׁר יָעַד לָהֶם יֵשׁוּעַ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","וַיְהִי כִּרְאוֹתָם אֹתוֹ וַיִּשְׁתַּחֲווּ־לוֹ וְיֵשׁ מֵהֶם פָּסְחוּ עַל־שְׁתֵּי סְעִפִּים׃ ");
INSERT INTO hebsg_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","וַיִּגַּשׁ יֵשׁוּעַ וַיְדַבֵּר אֲלֵיהֶם לֵאמֹר נִתַּן־לִי כָּל־מִמְשָׁל בַּשָּׁמַיִם וּבָאָרֶץ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","לְכוּ אֶל־כָּל־הָעַמִּים לְהוֹרֹתָם וְלַעֲשׂתָם לִי לְתַלְמִידִים וּלְטַבֵּל אֹתָם בְּשֵׁם הָאָב וְהַבֵּן וְרוּחַ הַקֹּדֶשׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","וְלִמַּדְתֶּם אֹתָם לִשְׁמֹר אֶת־כָּל־אֲשֶׁר צִוִּיתִי אֶתְכֶם וְהִנֵּה אָנֹכִי אֶהְיֶה עִמָּכֶם עַד־אַחֲרִית הַשָּׁנִים לְעֵת קֵץ הָעוֹלָם אָמֵן׃ ");
INSERT INTO hebsg_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","תְּחִלַּת הַבְּשׂוֹרָה לְיֵשׁוּעַ הַמָּשִׁיחַ בֶּן־הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","כַּכָּתוּב בְּדִבְרֵי הַנְּבִיאִים הִנְנִי שֹׁלֵחַ מַלְאָכִי לְפָנֶיךָ וּפִנָּה־דַרְכְּךָ לְפָנֶיךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","קוֹל קוֹרֵא בַּמִּדְבָּר פַּנּוּ דֶּרֶךְ יְהוָֹה יַשְּׁרוּ מְסִלּוֹתָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","וַיָּבֹא יוֹחָנָן לְטַבֵּל בַּמִּדְבָּר וְהוּא קָרָא אֶל־הָעָם לָשׁוּב מִדַּרְכָּם וּלְהִטָּבֵל לִסְלִיחַת עֲוֹנָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","וַיֵּצְאוּ אֵלָיו כָּל־אֶרֶץ יְהוּדָה וְכָל־ישְׁבֵי יְרוּשָׁלָיִם וַיִּטָּבְלוּ עַל־יָדוֹ בְּתוֹךְ הַיַּרְדֵּן בְּהִתְוַדֹּתָם אֶת־חַטֹּאתֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","וְיוֹחָנָן לְבוּשׁוֹ שְׂעַר גְּמַלִּים וְאֵזוֹר עוֹר אָזוּר בְּמָתְנָיו וּמַאֲכָלוֹ חֲגָבִים וּדְבַשׁ מִיָּעַר׃ ");
INSERT INTO hebsg_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","וַיִּקְרָא לֵאמֹר הִנֵּה חָסִין מִמֶּנִּי בָּא אַחֲרָי אֲשֶׁר קַל־עֶרֶךְ אֲנִי מִכְּרֹעַ לְפָנָיו לְהַתִּיר שְׂרוֹךְ נְעָלָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","אֲנִי מְטַבֵּל אֶתְכֶם בַּמָּיִם אַךְ הוּא יְטַבֵּל אֶתְכֶם בְּרוּחַ־הַקֹּדֶשׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","וַיְהִי בַּיָּמִים הָהֵם וַיָּבֹא יֵשׁוּעַ מִנְּצֶרֶת מִן־הַגָּלִיל וַיִּטָּבֵל עַל־יַד יוֹחָנָן בַּיַּרְדֵּן׃ ");
INSERT INTO hebsg_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","וְהוּא אַךְ־עָלֹה עָלָה מִן־הַמָּיִם וַיַּרְא וְהִנֵּה נִפְתְּחוּ הַשָּׁמַיִם וְהָרוּחַ יָרְדָה עָלָיו בִּדְמוּת יוֹנָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","וַיְהִי קוֹל מִן־הַשָּׁמַיִם אַתָּה הוּא בְּנִי יְדִידִי בְּךָ רָצְתָה נַפְשִׁי׃ ");
INSERT INTO hebsg_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","וְאַחֲרֵי־כֵן נְשָׂאוֹ הָרוּחַ וַיַּנִּחֵהוּ בַּמִּדְבָּר׃ ");
INSERT INTO hebsg_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","וַיְהִי בַמִּדְבָּר אַרְבָּעִים יוֹם עִם־חַיַּת הַשָּׂדֶה וַיְנַסֵּהוּ הַשָּׁטָן וּמַלְאֲכֵי אֱלֹהִים שֵׁרְתֻהוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","וְאַחֲרֵי אֲשֶׁר הָסְגַּר יוֹחָנָן בָּא יֵשׁוּעַ הַגָּלִילָה וַיִּקְרָא אֶת־בְּשׂוֹרַת מַלְכוּת הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","וַיֹּאמַר הִנֵּה מָלְאוּ הַיָּמִים וּמַלְכוּת הָאֱלֹהִים קְרֹבָה לָבֹא שׁוּבוּ מִדַּרְכֵיכֶם וְהַאֲמִינוּ בַבְּשׂוֹרָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","וַיְהִי בְּלֶכְתּוֹ עַל־שְׂפַת יַם־הַגָּלִיל וַיַּרְא אֶת־שִׁמְעוֹן וְאֶת־אַנְדְּרַי אֲחִי שִׁמְעוֹן פֹּרְשִׂים מִכְמֹרֶת עַל־פְּנֵי הַיָּם כִּי דַיָּגִים הָיוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","וַיֹּאמֶר אֲלֵיהֶם יֵשׁוּעַ לְכוּ אַחֲרַי וְאֶעֱשֶׂה אֶתְכֶם לְדַיְּגֵי אָדָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","וַיַּעַזְבוּ אֶת־מִכְמֹרוֹתָם כְּרָגַע וַיֵּלְכוּ אַחֲרָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","וַיַּעֲבֹר מְעַט־מִזְעָר וַיַּרְא אֶת־יַעֲקֹב בֶּן־זַבְדִּי וְאֶת־יוֹחָנָן אָחִיו וְגַם־הֵם בָּאָנִיָּה מְתַקְּנִים מִכְמֹרוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","וַיִּקְרָא אֲלֵיהֶם פִּתְאֹם וַיַּעַזְבוּ אֶת־זַבְדִּי אֲבִיהֶם בָּאָנִיָּה עִם־הַפֹּעֲלִים הַשְּׂכִירִים וַיֵּלְכוּ אַחֲרָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","וַיָּבֹאוּ אֶל־כְּפַר־נַחוּם וַיַּחַשׁ לָבֹא בְּיוֹם הַשַּׁבָּת אֶל־בֵּית־הַכְּנֶסֶת וַיְלַמֵּד שָׁמָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","וַיִּתְמְהוּ עַל־תּוֹרָתוֹ כִּי יָדַע לְלַמְּדָם כְּאִישׁ אֲשֶׁר שִׁלְטוֹן בְּיָדוֹ וְלֹא כַּסּוֹפְרִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","וְשָׁם נִמְצָא אִישׁ בְּבֵית־הַכְּנֵסֶת אֲשֶׁר דָּבַק בּוֹ רוּחַ טֻמְאָה וַיִּצְעַק לֵאמֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","הוֹי יֵשׁוּעַ הַנָּצְרִי מַה־לָּנוּ וָלָךְ הַאִם לְהַשְׁמִידֵנוּ בָאתָ הֲלֹא יְדַעְתִּיךָ מִי אַתָּה קְדוֹשׁ הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","וַיִּגְעַר־בּוֹ יֵשׁוּעַ לֵאמֹר דֹּם וְצֵא מִמֶּנּוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","וַיִּטְרֹף אֹתוֹ רוּחַ הַטֻּמְאָה וַיִּצְעַק צְעָקָה גְדֹלָה וְאַחֲרֵי־כֵן יָצָא מִמֶּנּוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","וַיִּשְׁתָּאוּ כֻלָּם וַיִּתְמְהוּ אִישׁ אֶל־אָחִיו לֵאמֹר מַה־זֹּאת מַה־תּוֹרָה חֲדָשָׁה אִתּוֹ כִּי גַּם־אֶת־הָרוּחוֹת הַטְּמֵאוֹת הוּא מְצַוֶּה בֶּעֱזוּזוֹ וְהֵן שֹׁמְעוֹת בְּקֹלוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","וְשָׁמְעוֹ יָצָא עַד־מְהֵרָה בְּכָל־הַכִּכָּר וּמִסָּבִיב לַגָּלִיל׃ ");
INSERT INTO hebsg_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","וַיֵּצְאוּ מִבֵּית־הַכְּנֵסֶת וַיָּבֹאוּ בֵּיתָה שִׁמְעוֹן וְאַנְדְּרַי וְעִמָּהֶם גַּם־יַעֲקֹב וְיוֹחָנָן׃ ");
INSERT INTO hebsg_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","וְחֹתֶנֶת שִׁמְעוֹן שָׁכְבָה חוֹלַת־קַדָּחַת וּכְבֹאוֹ סִפְּרוּ לוֹ עַל־דְּבַר מַחֲלָתָהּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","וַיִּגַּשׁ וַיַּחֲזֶק בְּיָדָהּ וַיְקִימֶהָ וְהַקַּדַּחַת רָפְתָה מִמֶּנָּה וַתָּקָם וַתְּשָׁרֵת אֹתָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","וַיְהִי בָּעֶרֶב אַחֲרֵי בוֹא הַשָּׁמֶשׁ וַיָּבִיאוּ אֵלָיו אֵת כָּל־הַחוֹלִים וְאֵת אֲשֶׁר רוּחַ רָעָה מְבַעִתָּם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","וְכָל־יוֹשְׁבֵי הָעִיר נֶאֶסְפוּ יַחְדָּו פֶּתַח הַבָּיִת׃ ");
INSERT INTO hebsg_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","וַיִּרְפָּא רַבִּים מֵהֶם אֲשֶׁר חָלוּ בְּתַחֲלֻאִים שׁוֹנִים וְרוּחוֹת רָעוֹת רַבּוֹת גֵּרֵשׁ וְלֹא־נָתַן לָרוּחוֹת הָרָעוֹת לְדַבֵּר דָּבָר כִּי יָדְעוּ מִי הוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","וַיַּשְׁכֵּם מִמָּחֳרָת טֶרֶם עָלָה הַשָּׁחַר וַיֵּצֵא וַיִּפְגַּע בְּמָקוֹם חָרֵב וַיִּתְפַּלֵּל שָׁמָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","וְשִׁמְעוֹן וְהָאֲנָשִׁים אֲשֶׁר אִתּוֹ חָרְדוּ אַחֲרָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","וַיִּמְצָאֻהוּ וַיֹּאמְרוּ אֵלָיו הִנֵּה כֻלָּם מְבַקְשִׁים פָּנֶיךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","וַיֹּאמֶר אֲלֵיהֶם לְכוּ וְנָסוּרָה מִזֶּה אֶל־עָרֵי הַפְּרָזוֹת הַקְּרֹבוֹת לָנוּ וְקָרָאתִי גַּם־שָׁמָּה כִּי עַל־כֵּן יָצָאתִי מִבֵּיתִי׃ ");
INSERT INTO hebsg_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","וַיָּסַר אֶל־בָּתֵּי־הַכְּנֵסֶת בְּכָל־הַגָּלִיל וַיִּקְרָא שָׁם וַיְגָרֶשׁ אֶת־הַשֵּׁדִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","וַיָּבֹא אֵלָיו אִישׁ מְצֹרָע וַיִּתְחַנֵּן וַיִּכְרַע לְפָנָיו וַיֹּאמַר אִם־חָפֵץ אַתָּה הֲלֹא תוּכַל לְטַהֲרֵנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","וַיְרַחֵם עָלָיו יֵשׁוּעַ וַיּוֹשֶׁט אֶת־יָדוֹ וַיִּגַּע־בּוֹ וַיֹּאמַר חָפֵץ אֲנִי וּטְהָר׃ ");
INSERT INTO hebsg_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","עוֹד הַדָּבָר בְּפִיו וְהַצָּרַעַת סָרָה מִבְּשָׂרוֹ כְרֶגַע וַיִּטְהָר׃ ");
INSERT INTO hebsg_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","וַיָּעַד־בּוֹ וַיְשַׁלְּחֵהוּ מֵעַל־פָּנָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","לֵאמֹר רְאֵה אַל־תַּגֵּד לְאִישׁ דָּבָר רַק־לֵךְ וְהֵרָאֵה לְעֵינֵי הַכֹּהֵן וְהַקְרֵב אֶת־הַקָּרְבָּן עַל־טָהֳרָתְךָ כַּאֲשֶׁר צִוָּה מֹשֶׁה לְעֵדוּת לָהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","וַיְהִי כְּצֵאתוֹ וַיָּחֶל לְהַגִּיד וּלְהַשְׁמִיעַ אֶת־הַדָּבָר בָּרַבִּים עַד אֲשֶׁר לֹא־יָכֹל עוֹד יֵשׁוּעַ לָבֹא בָעִיר בַּגָּלוּי כִּי אִם־הִתְגּוֹרֵר בַּחוּץ בְּצִיָּה וַעֲרָבָה וַיָּבֹאוּ אֵלָיו מִכָּל־עֵבֶר וּפִנָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","וַיְהִי מִיָּמִים וַיָּשָׁב אֶל־כְּפַר־נַחוּם וְהַקּוֹל נִשְׁמַע לֵאמֹר הִנֵּה הוּא יֹשֵׁב בַּבָּיִת׃ ");
INSERT INTO hebsg_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","וַיִּקָּהֲלוּ אֵלָיו רַבִּים מְהֵרָה עַד־אֲשֶׁר לֹא־נָשָׂא אֹתָם הַמָּקוֹם לַעֲמֹד יַחְדָּו אַף־לְנֹכַח הַפֶּתַח מִחוּץ וַיְדַבֵּר אֲלֵיהֶם אֶת־דְּבָרָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","וַיָּבֹאוּ אֵלָיו אֲנָשִׁים מְבִיאֵי אִישׁ נְכֵה עֲצָמוֹת וְאַרְבָּעָה נֹשְׂאִים אֹתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","וְכַאֲשֶׁר לֹא יָכְלוּ לָגֶשֶׁת אֵלָיו מֵרֹב הָעָם הֵסִירוּ אֶת־הַגָּג מֵעַל־הַבַּיִת אֲשֶׁר הוּא יֹשֵׁב בּוֹ וַיּוֹרִידוּ דֶרֶךְ שָׁם אֶת־הַמִּשְׁכָּב אֲשֶׁר נְכֵה הָעֲצָמוֹת שָׁכַב עָלָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","כִּרְאוֹת יֵשׁוּעַ אֶת־אֱמוּנָתָם וַיֹּאמֶר אֶל־נְכֵה הָעֲצָמוֹת בְּנִי נִסְלְחוּ־לְךָ חָטֹּאתֶיךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","וַאֲנָשִׁים מִן־הַסּוֹפְרִים יָשְׁבוּ שָׁם מְדַבְּרִים אֶל־לִבָּם לֵאמֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","לָמָּה מְדַבֵּר גִּדּוּפִים כָּאֵלֶּה מִי יוּכַל לִסְלֹחַ חֲטָאִים בִּלְתִּי הָאֱלֹהִים לְבַדּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","וְעַד־מְהֵרָה יָדַע יֵשׁוּעַ בְּרוּחוֹ כִּי־כֵן חָשְׁבוּ בְלִבָּם וַיֹּאמֶר אֲלֵיהֶם לָמָּה־זֶּה תֶהְגּוּ כָזֹאת בְּלִבְּכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","כִּי מֶה נָקֵל אִם־לֵאמֹר אֶל־נְכֵה הָעֲצָמוֹת נִסְלְחוּ־לְךָ חַטֹּאתֶיךָ אוֹ לֵאמֹר קוּם שָׂא אֶת־מִשְׁכָּבְךָ וְהִתְהַלֵּךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","אַךְ לְמַעַן תֵּדְעוּן כִּי יֵשׁ רִשְׁיוֹן לְבֶן־הָאָדָם בָּאָרֶץ לִסְלֹחַ חֲטָאִים אָז אָמַר אֶל־נְכֵה הָעֲצָמוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","הִנֵּה אֲנִי אֹמֵר לָךְ קוּם שָׂא אֶת־מִשְׁכָּבְךָ וְלֶךְ־לְךָ אֶל־בֵּיתֶךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","וַיְמַהֵר וַיָּקָם וַיִּשָּׂא אֶת־מִשְׁכָּבוֹ וַיֵּצֵא לְעֵינֵי כֻלָּם וּפַלָּצוּת אָחֲזָה אֶת־כֻּלָּם וַיִּתְּנוּ כָבוֹד לֵאלֹהִים לֵאמֹר מֵעוֹלָם לֹא־רָאִינוּ כָּזֹאת׃ ");
INSERT INTO hebsg_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","וַיּוֹסֶף וַיֵּצֵא אֶל־שְׂפַת הַיָּם וְכָל־הָעָם בָּאוּ אֵלָיו וַיָּשֶׂם אֶת־תּוֹרָתוֹ לִפְנֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","כַּאֲשֶׁר עָבַר מִשָּׁם רָאָה אֶת־לֵוִי בֶּן־חַלְפַי יֹשֵׁב בְּבֵית הַמֶּכֶס וַיֹּאמֶר אֵלָיו לֵךְ אַחֲרָי וַיָּקָם וַיֵּלֶךְ אַחֲרָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","וַיְהִי בְּשִׁבְתּוֹ עַל־הַלֶּחֶם בְּבֵיתוֹ וַיֵּשְׁבוּ מוֹכְסִים וְחַטָּאִים רַבִּים עִם־יֵשׁוּעַ וְתַלְמִידָיו כִּי רַבִּים הָיוּ אֲשֶׁר הָלְכוּ אַחֲרָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","וַיִּרְאוּ הַסּוֹפְרִים וְהַפְּרוּשִׁים כִּי הוּא אֹכֵל עִם־הַחַטָּאִים וְהַמּוֹכְסִים וַיֹּאמְרוּ אֶל־תַּלְמִידָיו מַדּוּעַ הוּא אֹכֵל וְשֹׁתֵה עִם־הַמּוֹכְסִים וְהַחַטָּאִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","וַיִּשְׁמַע יֵשׁוּעַ וַיֹּאמֶר אֲלֵיהֶם הַחֲזָקִים אֵין לָהֶם דָּבָר עִם־הָרֹפֵא כִּי אִם־הַחוֹלִים לֹא־בָאתִי לִקְרֹא לַצַּדִּיקִים לָבֹא אֵלַי כִּי אִם־לַחַטָּאִים לִתְשׁוּבָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","וְתַלְמִידֵי יוֹחָנָן וְהַפְּרוּשִׁים אֲשֶׁר עִנּוּ בַצּוֹם נַפְשָׁם בָּאוּ וַיֹּאמְרוּ אֵלָיו עַל־מָה תַלְמִידֵי יוֹחָנָן וְהַפְּרוּשִׁים צָמִים וְתַלְמִידֶיךָ לֹא יָצֻמוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","וַיֹּאמֶר אֲלֵיהֶם יֵשׁוּעַ הֲכִי יָצֻמוּ בְּנֵי הַחֲתֻנָּה בְּעוֹד הֶחָתָן עִמָּהֶם כָּל־עוֹד אֲשֶׁר הֶחָתָן בְּתוֹכָם לֹא יוּכְלוּ לָצוּם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","הִנֵּה יָמִים בָּאִים וְלֻקַּח מֵהֶם הֶחָתָן וְאָז יָצֻמוּ בַּיָּמִים הָהֵם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","וְאֵין־תֹּפְרִים טְלָאָה חֲדָשָׁה עַל־שִׂמְלָה בָלָה פֶּן־הַטְּלָאָה הַחֲדָשָׁה בְּמִלֻּאָתָהּ תִּגְרַע מִן־הַשִּׂמְלָה הַבָּלָה וְתוֹסִיף עַל־קְרָעֶיהָ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","וְתִירוֹשׁ לֹא יֻתַּן בְּנֹאדוֹת בָּלִים פֶּן־יְבַקַּע הַתִּירוֹשׁ אֶת־הַנֹּאדוֹת וְנִשְׁפַּךְ הַיַּיִן וְהַנֹּאדוֹת יִכְלָיוּן אֲבָל תִּירוֹשׁ יֻתַּן בְּנֹאדוֹת חֲדָשִׁים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","וַיְהִי הַיּוֹם וַיֵּלֶךְ בִּשְׂדֵה קָמָה בַּשַּׁבָּת וְתַלְמִידָיו בַּעֲשׂוֹתָם דַּרְכָּם שָׁם הֵחֵלוּ לִקְטֹף מְלִילוֹת בְּיָדָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","וַיֹּאמְרוּ אֵלָיו הַפְּרוּשִׁים רְאֵה מַדּוּעַ הֵם עֹשִׂים אֵת אֲשֶׁר־לֹא יֵעָשֶׂה בַשַּׁבָּת׃ ");
INSERT INTO hebsg_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","וַיֹּאמֶר אֲלֵיהֶם הֲלֹא קְרָאתֶם אֶת־אֲשֶׁר עָשָׂה דָוִד בִּהְיוֹתוֹ בְחֶסֶר וּבְכָפָן הוּא וָאֵלֶּה אֲשֶׁר אִתּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","אֲשֶׁר בָּא אֶל־בֵּית הָאֱלֹהִים בִּימֵי אֶבְיָתָר הַכֹּהֵן הַגָּדוֹל וַיֹּאכַל אֶת־לֶחֶם הַפָּנִים וַיִּתֵּן גַּם־לַאֲנָשָׁיו אֲשֶׁר עַל־פִּי הַתּוֹרָה לֹא יֹאכַל בִּלְתִּי אִם־הַכֹּהֲנִים לְבַדָּם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","וַיֹּאמֶר אֲלֵיהֶם הֵן הַשַּׁבָּת הוּכַן בַּעֲבוּר הָאָדָם וְלֹא הָאָדָם בַּעֲבוּר הַשַּׁבָּת׃ ");
INSERT INTO hebsg_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","עַל־כֵּן בֶּן־הָאָדָם גַּם־אֲדוֹן הַשַּׁבָּת הוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","וַיּוֹסֶף וַיָּבֹא אֶל־בֵּית־הַכְּנֵסֶת וְשָׁם־אִישׁ אֲשֶׁר יָדוֹ יְבֵשָׁה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","וְהֵם אָרְבוּ לוֹ אִם־יִרְפָּאֵהוּ בַּשַּׁבָּת לְמַעַן תִּמְצָא יָדָם לְשִׂטְנוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","וַיֹּאמֶר אֶל־הָאִישׁ אֲשֶׁר יָדוֹ יְבֵשָׁה קוּם וַעֲמֹד בְּתוֹךְ הַקָּהָל׃ ");
INSERT INTO hebsg_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","אָז אָמַר אֲלֵיהֶם הֲכִי כַדָּת לְהֵיטִיב בַּשַּׁבָּת אוֹ לְהָרַע לְהַצִּיל נֶפֶשׁ אוֹ לְשַׁחֲתָהּ וַיַּחֲרִישׁוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","וַיַּשְׁקֵף אֲלֵיהֶם מִסָּבִיב בְּפָנִים זֹעֲפִים כִּי מַר־לוֹ מְאֹד מִקְּשִׁי לִבָּם וַיֹּאמֶר אֶל־הָאִישׁ הַהוּא הוֹשֵׁט אֶת־יָדֶךָ וַיֹּשֶׁט אֹתָהּ וַתָּשָׁב יָדוֹ לְאֵיתָנָהּ כָּאַחֶרֶת׃ ");
INSERT INTO hebsg_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","וְהַפְּרוּשִׁים יָצְאוּ וַיָּחִישׁוּ לְהִוָּעֵץ עִם־אַנְשֵׁי הוֹרְדוֹס בַּמֶּה לְהַשְׁחִיתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","וַיִּפֶן יֵשׁוּעַ וַיַּעֲבֹר מִשָּׁם עִם־תַּלְמִידָיו דֶּרֶךְ הַיָּם וַהֲמוֹן עַם־רָב הָלְכוּ אַחֲרָיו מִן־הַגָּלִיל וּמִן־יְהוּדָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","וּמִירוּשָׁלַיִם וּמֵאֱדוֹם וּמֵעֵבֶר לַיַּרְדֵּן וּמִסְּבִיבוֹת צֹר וְצִידוֹן קָהָל גָּדוֹל בָּאוּ אֵלָיו כִּי שָׁמְעוּ אֵת כָּל־אֲשֶׁר עָשָׂה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","וַיֹּאמֶר אֶל־תַּלְמִידָיו לְהָכֶן־לוֹ אֳנִיָּה קְטַנָּה מִפְּנֵי הֲמוֹן הָעָם לְבִלְתִּי יִדְחֲקוּן אֹתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","כִּי הֶעֱלָה אֲרֻכָה לָרַבִּים עַד־אֲשֶׁר הִתְמַלְּאוּ עָלָיו כָּל־הַמְנֻגָּעִים בִּרְצוֹתָם לִנְגֹּעַ בּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","וְאֵלֶּה אֲשֶׁר רוּחַ טֻמְאָה בָּם בִּרְאוֹתָם אֹתוֹ נָפְלוּ לְפָנָיו וַיִּצְעֲקוּ לֵאמֹר אַתָּה הוּא בֶּן־הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","וְהוּא גָעֹר גָּעַר בָּם לְבִלְתִּי יוֹדִיעוּ מִי הוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","וַיַּעַל אֶל־הָהָר וַיִּקְרָא אֶל־אֵלֶּה אֲשֶׁר חָפֵץ בָּם וַיָּבֹאוּ אֵלָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","וַיִּפְקֹד שְׁנֵים עָשָׂר אֲנָשִׁים לִהְיוֹת אֶצְלוֹ וְלִקְרֹא אֶת־בְּשׂוֹרָתוֹ בְּכֹל אֲשֶׁר יִשְׁלָחֵם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","וְכֹחַ נָתַן בְּיָדָם לִרְפֹּא אֶת־הַתַּחֲלֻאִים לְגָרֵשׁ רוּחוֹת רָעוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","וַיְכַנֶּה אֶת־שִׁמְעוֹן בְּשֵׁם פֶּטְרוֹס׃ ");
INSERT INTO hebsg_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","וְאֶת־יַעֲקֹב בֶּן־זַבְדִּי וְאֶת־יוֹחָנָן אֲחִי יַעֲקֹב כִּנָּה בְּשֵׁם בְּנֵי־רָגֶשׁ אֲשֶׁר הוּא כְּשֵׁם בְּנֵי־רָעַם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","וְאֶת־אַנְדְּרַי וְאֶת־פִּילִפּוּס וְאֶת־בַּר־תַּלְמַי וְאֶת־מַתִּתְיָהוּ וְאֶת־תּוֹמָא וְאֶת־יַעֲקֹב בֶּן־חַלְפַי וְאֶת־תַּדַּי וְאֶת־שִׁמְעוֹן הַכְּנַעֲנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","וְאֶת־יְהוּדָה אִישׁ־קְרִיּוֹת הוּא הַמַּסְגִּיר אֹתוֹ וַיָּבֹא הַבָּיְתָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","וַהֲמוֹן הָעָם נִקְבְּצוּ שָׁם לָרֹב עַד כִּי־לֹא יָכְלוּ לֶאֱכָל־לָחֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","וְכַאֲשֶׁר שָׁמְעוּ בְנֵי מִשְׁפַּחְתּוֹ יָצְאוּ לְהַחֲזִיק בּוֹ כִּי אָמְרוּ סָר טַעְמוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","וְהַסּוֹפְרִים אֲשֶׁר יָרְדוּ מִירוּשָׁלַיִם אָמְרוּ כִּי בַּעַל־זְבוּב דָּבַק בּוֹ וְכִי עַל־יְדֵי שַׂר־הַשֵּׁדִים הוּא מְגָרֵשׁ אֶת־הַשֵּׁדִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","וַיִּקְרָא אֲלֵיהֶם לָבֹא אֵלָיו וַיִּפְתַּח בְּמָשָׁל פִּיו לֵאמֹר אֵיךְ יוּכַל הַשָּׂטָן לְגָרֵשׁ אֶת־הַשָּׂטָן׃ ");
INSERT INTO hebsg_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","הֲלֹא מַמְלָכָה הַנִּפְלְגָה עַל־נַפְשָׁהּ הַמַּמְלָכָה הַהִיא לֹא תָקוּם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","וּבַיִת הַנִּפְלָג עַל־נַפְשׁוֹ הַבַּיִת הַהוּא לֹא־יוּכַל לָקוּם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","וְאִם־הַשָּׂטָן קָם עַל־נַפְשׁוֹ כִּי נִפְלְגָה רוּחוֹ לֹא־יוּכַל קוּם כִּי בָא עַד־קִצּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","לֹא יוּכַל אִישׁ לָבֹא בֵּית הַגִּבּוֹר וְלִשְׁלֹל אֶת־כֵּלָיו אִם־לֹא יֶאְסֹר אֶת־הַגִּבּוֹר רִאשֹׁנָה וְאַחַר יִשְׁלֹל אֵת אֲשֶׁר בְּבֵיתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","אָמֵן אֲנִי אֹמֵר לָכֶם הֵן יֵשׁ סְלִיחָה לִבְנֵי אָדָם עַל־כָּל־עֲוֹנוֹתָם וְגִדֻּפֹתָם אֶשֶׁר יְגַדֵּפוּן׃ ");
INSERT INTO hebsg_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","אֶפֶס הַמְגַדֵּף אֶת־רוּחַ הַקֹּדֶשׁ לֹא תִהְיֶה־לּוֹ סְלִיחָה עֲדֵי־עַד כִּי יִנָּתֵן לַמִּשְׁפָּט בִּפְּלִלִים לְעוֹלְמֵי עוֹלָמִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","כִּי־הֵם אָמְרוּ רוּחַ טֻמְאָה דָבְקָה בּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","וַיָּבֹאוּ אִמּוֹ וְאֶחָיו וַיַּעַמְדוּ מִחוּץ וַיִּשְׁלְחוּ אֵלָיו לָצֵאת אֲלֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","וְעַם־רָב אֲשֶׁר יָשְׁבוּ סָבִיב לוֹ אָמְרוּ אֵלָיו הִנֵּה אִמְּךָ וְאַחֶיךָ מִחוּץ מְבַקְשִׁים לִרְאוֹתֶךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","וַיַּעַן וַיֹּאמֶר אֲלֵיהֶם מִי אִמִּי וּמִי אֶחָי׃ ");
INSERT INTO hebsg_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","וַיַּבֵּט כֹּה וָכֹה אֶל־הַיֹּשְׁבִים סָבִיב לוֹ וַיֹּאמַר הִנֵּה אִמִּי וְאֶחָי׃ ");
INSERT INTO hebsg_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","כִּי אִישׁ אִישׁ אֲשֶׁר יַעֲשֶׂה רְצוֹן הָאֱלֹהִים הוּא אָחִי וַאֲחֹתִי וְאִמִּי׃ ");
INSERT INTO hebsg_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","וַיָּשָׁב וַיָּחֶל לְלַמֵּד עוֹד הַפַּעַם עַל־שְׂפַת הַיָּם וַהֲמוֹן עַם־רָב נִקְהֲלוּ אֵלָיו עַד אֲשֶׁר־יָרַד וַיֵּשֶׁב בָּאֳנִיָּה בְּתוֹךְ הַיָּם וְכָל־הָעָם עֹמְדִים עַל־הַחוֹף בַּיַּבָּשָׁה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","וַיְאַלְּפֵם דְּבָרִים רַבִּים בִּמְשָׁלָיו וַיַּטֵּף אֲלֵיהֶם לִקְחוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","הַאֲזִינוּ לְאִמְרֵי־פִי הִנֵּה הַזֹּרֵעַ יָצָא לִזְרֹעַ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","וַיְהִי בְּזָרְעוֹ וַיְפַזֵּר מִן־הַזֶּרַע עַל־יַד הַדָּרֶךְ וַיָּבֹא עוֹף הַשָּׁמַיִם וַיֹאכְלֶנּוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","וְיֵשׁ מִן־הַזֶּרַע אֲשֶׁר נָפַל עַל־אַדְמַת סֶלַע וְלֹא הָיָה שָׁם דֵּי עָפָר וַיְמַהֵר לִצְמֹחַ מִבְּלִי אֲשֶׁר הָיָה לוֹ עֹמֶק אֲדָמָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","וַיְהִי כִּזְרֹחַ הַשֶּׁמֶשׁ וַיִּצָּרֵב וַיִּיבָשׁ כִּי לֹא הָיָה־לוֹ שֹׁרֶשׁ לְמָטָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","וְיֵשׁ אֲשֶׁר נָפַל אֶל־הַקֹּצִים וַיַּעֲלוּ הַקֹּצִים וַיְבַלְּעֻהוּ וְלֹא עָשָׂה תְּבוּאָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","וְיֵשׁ אֲשֶׁר נָפַל עַל־חֶלְקָה טוֹבָה וַיּוֹצֵא פְּרִי תְבוּאָה הֹלֵךְ הָלוֹךְ וָרָב עַד אֲשֶׁר־עָשָׂה שְׁלֹשִׁים שְׁעָרִים וְשִׁשִּׁים שְׁעָרִים וּמֵאָה שְׁעָרִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","וַיֹּאמַר אֲלֵיהֶם מִי אֲשֶׁר אָזְנַיִם לוֹ לִשְׁמֹעַ יִשְׁמָע׃ ");
INSERT INTO hebsg_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","וַיְהִי בְּשִׁבְתּוֹ לְבַדּוֹ וַיָּבֹאוּ אֵלֶּה אֲשֶׁר דָּבְקוּ בוֹ עִם־שְׁנֵים הֶעָשָׂר וַיִּשְׁאָלֻהוּ עַל־דְּבַר מְשָׁלָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","וַיֹּאמֶר אֲלֵיהֶם לָכֶם נִתַּן לָדַעַת רָזֵי מַלְכוּת הָאֱלֹהִים וְאֵלֶּה אֲשֶׁר מִבַּחוּץ רַק מְשָׁלִים יִשְׁמְעוּ בַּכֹּל׃ ");
INSERT INTO hebsg_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","לְמַעַן רָאוֹ יִרְאוּ וְלֹא יֵדְעוּ וְשָׁמוֹעַ יִשְׁמְעוּ וְלֹא יָבִינוּ פֶּן־יָשׁוּבוּ וְנִסְלַח לָהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","וַיֹּאמֶר אֲלֵיהֶם אִם־הַמָּשָׁל הַזֶּה לֹא הֲבִינוֹתֶם אֵיךְ תָּבִינוּ שְׁאָר הַמְּשָׁלִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","הַזֹּרֵעַ הֲלֹא הוּא הַזֹּרֵעַ אֶת־דְּבַר הַמַּלְכוּת׃ ");
INSERT INTO hebsg_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","וַאֲשֶׁר עַל־יַד הַדֶּרֶךְ הֵם אֵלֶּה אֲשֶׁר יְקַבְּלוּ אֶת־הַזֶּרַע בְּשָׁמְעָם אֶת־אֲשֶׁר נֶאֱמַר לָהֶם אַךְ הַשָּׂטָן יָחִישׁ לָבוֹא וְנָשָׂא אֶת־הַזֶּרַע הַזָּרוּעַ בָּם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","וְכֵן הַזֶּרַע הַזָּרוּעַ עַל־חֶלְקַת סֶלַע הֵם אֵלֶּה אֲשֶׁר יְמַהֲרוּ לִשְׁמֹעַ אֶת־דְּבַר הַמַּלְכוּת בְּשִׂמְחָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","אֶפֶס כִּי־אֵין לָהֶם שֹׁרֶשׁ בְּנַפְשָׁם וְרַק כִּמְעַט רֶגַע יַעֲמֹדוּ וְאַחֲרֵי־כֵן כִּי תִקְרֶה כָל־צָרָה וְרָדְפוּ אֹתָם עַל־דְּבַר אֱמוּנָתָם יִכָּשְׁלוּ כְּרָגַע׃ ");
INSERT INTO hebsg_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","וְהַזֶּרַע הַזָּרוּעַ אֶל־הַקֹּצִים הֵם אֵלֶּה אֲשֶׁר יִשְׁמְעוּ דְּבַר־הַמַּלְכוּת׃ ");
INSERT INTO hebsg_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","וְדַאֲגוֹת הָעוֹלָם הַזֶּה וְנִכְלֵי הָעשֶׁר וַחֲפָצִים אֲחֵרִים בָּאִים וּמְבַלְּעִים אֶת־הַדָּבָר וְלֹא יַעֲשֶׂה־צֶּמַח׃ ");
INSERT INTO hebsg_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","וְהַזֶּרַע הַזָּרוּעַ בַּחֶלְקָה הַטּוֹבָה הֵם הַשֹּׁמְעִים אֶת־הַדָּבָר וְיִצְפְּנֻהוּ עַד אֲשֶׁר־יָנוּב תְּנוּבָה שְׁלֹשִׁים שְׁעָרִים וְשִׁשִּׁים שְׁעָרִים וּמֵאָה שְׁעָרִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","וַיֹּאמֶר אֲלֵיהֶם הֲיוּבָא הַנֵּר לְשׂוּמוֹ תַּחַת הָאֵיפָה אוֹ תַּחַת הַמִּטָּה וְלֹא לְהַעֲלֹתוֹ אֶל־הַמְּנוֹרָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","כִּי אֵין־דָּבָר נֶעְלָם אֲשֶׁר לֹא־יִגָּלֶה וְאֵין נִסְתָּר אֲשֶׁר־לֹא יֵצֵא לָאוֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","מִי אֲשֶׁר אָזְנַיִם לוֹ לִשְׁמֹעַ יִשְׁמָע׃ ");
INSERT INTO hebsg_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","וַיֹּאמֶר אֲלֵיהֶם שִׂימוּ לִבְּכֶם לַאֲשֶׁר אַתֶּם שֹׁמְעִים בַּמִּדָּה אֲשֶׁר אַתֶּם תָּמֹדּוּ בָּהּ יִמַּד לָכֶם גַּם־אַתֶּם וְעוֹד יֻתַּן לָכֶם נוֹסָפוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","כִּי מִי אֲשֶׁר יֶשׁ־לוֹ יֻתַּן לוֹ עוֹד וּמִי אֲשֶׁר אֵין־לוֹ יֻקַּח מִמֶּנּוּ גַּם אֲשֶׁר יֶשׁ־לוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","וַיֹּאמֶר עוֹד נִמְשָׁלָה מַלְכוּת הָאֱלֹהִים כָּאִישׁ הַשָּׁת זֶרַע בָּאָרֶץ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","וְהָלַךְ־לוֹ לִישׁוֹן וְקָם לַיְלָה וָיוֹם וְהַזֶּרַע יִצְמַח וְיִגְדָּל אַךְ אֵיכָה נֶעֶשְׂתָה כָזֹאת הוּא לֹא יֵדָע׃ ");
INSERT INTO hebsg_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","כִּי הָאָרֶץ תּוֹצִיא צִמְחָהּ מֵאֵלֶיהָ אֶת־הַקָּנֶה רִאשֹׁנָה אַחֲרֵי־כֵן אֶת־הַשִּׁבֹּלֶת וַאַחֲרֵי־כֵן אֶת־הַחִטָּה בַּשִּׁבֹּלֶת הַמְּלֵאָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","וְאָז יָחִישׁ יָנִיף מַגָּל עַל־תְּבוּאַת הַקָּמָה כִּי בָשַׁל קָצִיר׃ ");
INSERT INTO hebsg_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","וַיּוֹסֶף וַיֹּאמַר מַה־דְּמוּת לְמַלְכוּת הָאֱלֹהִים וּמַה־מָּשָׁל נְשַׁוֶּה־לָּהּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","דִּמְיוֹנָהּ לְגַרְגַּר חַרְדָּל אֲשֶׁר הוּשַׁת בָּאָרֶץ וְהוּא קָטֹן מִכָּל־זֶרַע אֲשֶׁר עַל־פְּנֵי הָאֲדָמָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","וְאַחֲרֵי אֲשֶׁר נִזְרַע יָצִיץ יִגְדַּל מִכָּל־יֶרֶק וַעֲנָפִים גְּדוֹלִים יוֹצִיא עַד־אֲשֶׁר עוֹף הַשָּׁמַיִם יְקַנְּנוּ בְצִלּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","וּבְמְשָׁלִים רַבִּים כָּאֵלֶּה הִטִּיף אֲלֵיהֶם מִלָּתוֹ כְּפִי־אֲשֶׁר יָכְלוּ שְׂאֵת׃ ");
INSERT INTO hebsg_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","וְלֹא דִבֶּר אֲלֵיהֶם דָּבָר בִּבְלִי מָשָׁל וּבְשִׁבְתּוֹ עִם־תַּלְמִידָיו לְבַדָּם בֵּאֵר לָהֶם אֶת־הַמְּשָׁלִים כֻּלָּם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","בַּיּוֹם הַהוּא לְעֵת עֶרֶב אָמַר אֲלֵיהֶם נַעְבְּרָה־נָּא אֶל־עֵבֶר הַיָּם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","וַיְשַׁלְּחוּ אֶת־הֲמוֹן הָעָם וַיַּעֲבִירוּ אֹתוֹ בָּאֳנִיָּה הַהִיא אֲשֶׁר יָשַׁב בָּהּ מֵאָז וָאֳנִיּוֹת אֲחֵרוֹת סָבִיב לוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","וַתָּקָם סוּפָה וּסְעָרָה גְדוֹלָה בַּיָּם וְהַגַּלִּים שָׁטְפוּ אֶל־הָאֳנִיָּה עַד־לְמַלְּאוֹתָהּ מָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","וְהוּא נִרְדָּם בְּיַרְכְּתֵי הָאֳנִיָּה וְהַכְּסָתוֹת מְרַאֲשֹׁתָיו וַיָּעִירוּ אֹתוֹ לֵאמֹר רַבֵּנוּ הֲכִי לֹא תָחוּשׁ לָנוּ כִּי אֹבְדִים אֲנָחְנוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","וַיֵּעוֹר וַיִּגְעַר בָּרוּחַ וַיֹּאמֶר אֶל־הַיָּם דֹּם וְהֵרָגַע וַיִּשְׁתֹּק הָרוּחַ וַתְּהִי דְּמָמָה גְדוֹלָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","אָז אָמַר אֲלֵיהֶם מַדּוּעַ כֹּה תֶחֱרָדוּן הַעוֹד אֵין אֵמֻן בָּכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","וְהֵם יָרְאוּ יִרְאָה גְדוֹלָה וַיֹּאמְרוּ אִישׁ אֶל־אָחִיו מִי הוּא זֶה אֲשֶׁר גַּם־הָרוּחַ וְהַיָּם מַקְשִׁיבִים לְקוֹלוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","וַיָּבֹאוּ אֶל־עֵבֶר הַיָּם אֶל־מְקוֹם מוֹשַׁב הַגֵּרַזִיִּים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","וְהוּא יָצָא מִן־הָאֳנִיָּה וְהִנֵּה־אִישׁ יוֹצֵא לִקְרָאתוֹ מִן־הַקְּבָרִים אֲשֶׁר־רוּחַ טֻמְאָה מְבַעִתּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","וּמוֹשָׁבוֹ הָיָה בֵּין הַקְּבָרִים וְלֹא יָכֹל עוֹד אִישׁ לֶאְסֹר אֹתוֹ וְאַף לֹא בְזִקִּים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","כִּי־פְעָמִים רַבּוֹת נֶאְסַר בְּזִקִּים וּבְכַבְלֵי בַרְזֵל וַיְנַתֵּק אֶת־הַזִּקִּים וְאֶת־הַכְּבָלִים שִׁבֵּר וְלֹא הָיָה לְאֵל יַד־אִישׁ לְכָבְשׁוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","וְהָיָה צֹעֵק תָּמִיד לַיְלָה וְיוֹמָם בֵּין הַקְּבָרִים וְהֶהָרִים וְטֹרֵף בָּאֲבָנִים נַפְשׁוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","וַיְהִי כִּרְאֹתוֹ אֶת־יֵשׁוּעַ מֵרָחוֹק וַיָּרָץ וַיִּשְׁתַּחוּ לוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","וַיִּצְעַק בְּקוֹל גָּדוֹל וַיֹּאמַר מַה־לִּי וָלָךְ יֵשׁוּעַ בֶּן־אֵל עֶלְיוֹן הִנְנִי מַשְׁבִּיעֲךָ בֵאלֹהִים כִּי לֹא תְעַנֵּנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","כִּי הוּא אָמַר אֵלָיו צֵא רוּחַ טֻמְאָה מִן־הָאִישׁ הַזֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","וַיִּשְׁאָלֵהוּ לֵאמֹר מַה־שְׁמֶךָ וַיֹּאמַר מַחֲנַיִם שְׁמִי כִּי־רַבִּים אֲנָחְנוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","וַיִּפְצַר־בּוֹ מְאֹד לְבִלְתִּי שַׁלְּחָם אֶל־מִחוּץ לָאָרֶץ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","וְעֵדֶר חֲזִירִים רַבִּים הָיָה רֹעֶה שָׁם מִצֵּלַע הָהָר׃ ");
INSERT INTO hebsg_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","וַיִּתְחַנְּנוּ־לוֹ לֵאמֹר שַׁלְּחֵנוּ־נָא אֶל־הַחֲזִירִים וְנָבוֹאָה בָּהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","וַיַּנַּח לָהֶם יֵשׁוּעַ וְהָרוּחוֹת הַטְּמֵאוֹת הָאֵלֶּה יָצְאוּ וַתָּבֹאנָה אֶל־תּוֹךְ הַחֲזִירִים וַיִּשְׁטֹף כָּל־הָעֵדֶר בַּמּוֹרָד אֶל־תּוֹךְ הַיָּם וְהֵם כֻּלָּם כְּאַלְפַּיִם טֻבְּעוּ בַּיָּם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","וְרֹעֵי הַחֲזִירִים נָסוּ וַיַּגִּידוּ אֶת־הַדָּבָר בָּעִיר וּבַשָּׂדֶה וַיֵּצְאוּ בְנֵי הַמָּקוֹם לִרְאוֹת אֵת אֲשֶׁר נִהְיָתָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","וַיָּבֹאוּ אֶל־יֵשׁוּעַ וַיִּרְאוּ אֶת־הָאִישׁ בַּעַל מְעוֹן הַשֵּׁדִים בַּעַל מַחֲנָיִם וְהוּא יֹשֵׁב מְלֻבָּשׁ בְּגָדִים וְדַעְתּוֹ יְשָׁרָה וַיִּירָאוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","וְהָרֹאִים אֶת־הַמַּעֲשֶׂה בְּעֵינֵיהֶם סִפְּרוּ לָהֶם אֶת־אֲשֶׁר נַעֲשָׂה לְבַעַל מְעוֹן הַשֵּׁדִים וּלְעֵדֶר הַחֲזִירִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","וַיָּחֵלּוּ לִפְצַר־בּוֹ כִּי יַעֲבֹר מִגְּבוּלֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","וַיֵּרֶד אֶל־הָאֳנִיָּה וּבַעַל מְעוֹן הַשֵּׁדִים פָּגַע בּוֹ לְתִתּוֹ לִהְיוֹת אֶצְלוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","וְלֹא נְתָנוֹ יֵשׁוּעַ אַךְ אָמַר אֵלָיו שׁוּב לְבֵיתְךָ וּלְמוֹלַדְתֶּךָ וְהַגֵּד לָהֶם מֶה־עָשָׂה לְךָ יְהוָֹה וּמָה־רַבּוּ רַחֲמָיו אֵלֶיךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","וַיֵּלֶךְ וַיָּחֶל לְהַשְׁמִיעַ בְּדֶכַּפּוֹלִיס אֵת אֲשֶׁר עָשָׂה לוֹ יֵשׁוּעַ וַיִּתְפַּלְּאוּ כֻלָּם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","וַיָּשָׁב יֵשׁוּעַ וַיַּעֲבֹר בָּאֳנִיָּה אֶל־עֵבֶר הַיָּם וְעַם־רָב נִקְבְּצוּ אֵלָיו וְהוּא עֹמֵד עַל־שְׂפַת הַיָּם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","וְהִנֵּה אַחַד רָאשֵׁי בֵּית־הַכְּנֵסֶת בָּא אֵלָיו וּשְׁמוֹ יָאִיר וְכִרְאֹתוֹ אֹתוֹ נָפַל לְרַגְלָיו אָרְצָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","וַיִּתְחַנֵּן אֵלָיו מְאֹד לֵאמֹר בִּתִּי הַיַּלְדָּה הִגִּיעָה עַד־שַׁעֲרֵי מָוֶת הוֹאֶל־נָא וָבֹא שִׂים יָדֶיךָ עָלֶיהָ וְשָׁבָה וּתְחִי מֵחָלְיָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","וַיֵּלֶךְ אִתּוֹ וַהֲמוֹן עַם־רָב הָלְכוּ אַחֲרָיו וַיִּדְחָקֻהוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","וְאִשָּׁה זָבָה הָיְתָה שָּׁם אֲשֶׁר יְמֵי זוֹבָהּ נִמְשְׁכוּ שְׁתֵּים עֶשְׂרֶה שָׁנָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","וְהִיא נָשְׂאָה מַכְאוֹבִים רַבִּים מִידֵי רֹפְאִים שׁוֹנִים וְכֹל אֲשֶׁר־לָהּ פִּזְּרָה בִלְתִּי הוֹעִיל כִּי נִגְעָהּ הָלַךְ הָלוֹךְ וְקָשֶׁה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","וַיְהִי כְּשָׁמְעָהּ אֶת־שֵׁמַע יֵשׁוּעַ וַתָּבֹא בְּקֶרֶב הֲמוֹן הָעָם מֵאַחֲרָיו וַתִּגַּע בִּכְנַף בִּגְדוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","כִּי אָמְרָה בְלִבָּהּ אִם רַק־אֶגַּע בִּבְגָדָיו וְאִוָּשֵׁעָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","וַיִּיבַשׁ מְקוֹר דָּמֶיהָ פִּתְאֹם וַתַּכֵּר כִּי נִרְפָּא הַנֶּגַע בִּבְשָׂרָהּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","וְיֵשׁוּעַ יָדַע בְּנַפְשׁוֹ כְּרֶגַע כִּי גְבוּרָה יָצְאָה מִמֶּנּוּ וַיִּפֶן בְּתוֹךְ הָעָם וַיֹּאמַר מִי־נָגַע בִּבְגָדָי׃ ");
INSERT INTO hebsg_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","וַיֹּאמְרוּ אֵלָיו תַּלְמִידָיו הִנְּךָ רֹאֶה כִּי הָעָם יִדְחֲקוּן מִסָּבִיב וְאַתָּה תִּשְׁאַל מִי־נָגַע בִּבְגָדָי׃ ");
INSERT INTO hebsg_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","וַיַּבֵּט מִסָּבִיב לִרְאוֹת אֹתָהּ אֲשֶׁר עָשְׂתָה כָּזֹאת׃ ");
INSERT INTO hebsg_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","וְהָאִשָּׁה יָרְאָה וְחָרְדָה כִּי יָדְעָה אֶת־אֲשֶׁר נַעֲשָׂה לָּהּ וַתָּבֹא וַתִּפֹּל לְפָנָיו אַרְצָה וַתַּגֶּד־לוֹ הָאֱמֶת׃ ");
INSERT INTO hebsg_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","וַיֹּאמֶר אֵלֶיהָ בִּתִּי אֱמוּנָתֵךְ הוֹשִׁיעָה לָּךְ לְכִי לְשָׁלוֹם וְחָיְתָה נַפְשֵׁךְ מִתַּחֲלוּאָיְכִי׃ ");
INSERT INTO hebsg_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","עוֹדֶנּוּ מְדַבֵּר וְאַנְשֵׁי רֹאשׁ בֵּית־הַכְּנֵסֶת בָּאוּ מִבֵּיתוֹ וַיֹּאמְרוּ מֵתָה בִתְּךָ וְלָמָּה־זֶּה תַּלְאֶה עוֹד אֶת־הַרָבִּי׃ ");
INSERT INTO hebsg_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","כִּשְׁמוֹעַ יֵשׁוּעַ אֶת־הַדָּבָר הָאָמוּר וַיֹּאמֶר אֶל־רֹאשׁ בֵּית־הַכְּנֵסֶת אַל־תִּירָא אַךְ־הַאֲמֵן׃ ");
INSERT INTO hebsg_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","וְלֹא נָתַן לְאִישׁ לָלֶכֶת עִמּוֹ בִּלְתִּי לְפֶטְרוֹס וְיַעֲקֹב וְיוֹחָנָן אֲחִי יַעֲקֹב׃ ");
INSERT INTO hebsg_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","וַיָּבֹאוּ בֵּית־רֹאשׁ בֵּית־הַכְּנֵסֶת וַיַּרְא אֶת־מְהוּמַת הַבֹּכִים וְאֶת־הַמְיַלְלִים הָרַבִּים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","וַיָּבֹא וַיֹּאמֶר אֲלֵיהֶם מַה־תֶּהֱמוּ וּמַה־תִּבְכּוּ הַיַּלְדָּה לֹא מֵתָה כִּי אִם־יְשֵׁנָה הִיא׃ ");
INSERT INTO hebsg_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","וַיִּלְעֲגוּ לוֹ אַךְ הוּא הוֹצִיא אֶת־כֻּלָּם מִן־הַבָּיִת וַיִּקַּח אֶת־אֲבִי הַנַּעֲרָה וְאֶת־אִמָּה וְאֶת־אֲשֶׁר אִתּוֹ וַיָּבֹא הַחַדְרָה אֲשֶׁר הַנַּעֲרָה שָׁמָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","וַיַּחֲזֵק בְּיַד הַנַּעֲרָה וַיֹּאמֶר טַלְיְתָא קוּמִי אֲשֶׁר יֵאָמַר נַעֲרָה קוּמִי׃ ");
INSERT INTO hebsg_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","וַתָּקָם הַנַּעֲרָה פִּתְאֹם וַתִּהֲלַךְ וְהִיא בַּת־שְׁתֵּים עֶשְׂרֵה שָׁנָה וַיִּתְפַּלְּאוּ הַפְלֵא וָפֶלֶא׃ ");
INSERT INTO hebsg_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","וַיְצַו עֲלֵיהֶם וַיַּזְהִירֵם לְבִלְתִּי יִוָּדַע הַדָּבָר לְאִישׁ אָז אָמַר לָתֶת־לָהּ לֶאֱכֹל׃ ");
INSERT INTO hebsg_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","וַיֵּצֵא מִשָּׁם וַיָּבֹא אֶל־אֶרֶץ מוֹלַדְתּוֹ וְתַלְמִידָיו הָלְכוּ אַחֲרָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","וַיְהִי בְּיוֹם הַשַּׁבָּת וַיָּחֶל לְלַמֵּד בְּבֵית־הַכְּנֵסֶת וְרַבִּים שָׁמְעוּ וַיִּתְמְהוּ לֵאמֹר מֵאַיִן לָזֶה כָּל־אֵלֶּה מַה־מְּנַת חָכְמָתוֹ וְאֵיךְ נִפְלָאוֹת כָּאֵלֶּה תַּעֲשֶׂינָה יָדָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","הֲלֹא זֶה הוּא הֶחָרָשׁ בֶּן־מִרְיָם וַאֲחִי יַעֲקֹב וְיוֹסֵי וִיהוּדָה וְשִׁמְעוֹן וְגַם־אַחְיוֹתָו הֲלֹא כֻלָּן אִתָּנוּ פֹּה כִּי הוּא הָיָה לָהֶם לְאֶבֶן נֶגֶף׃ ");
INSERT INTO hebsg_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","וַיֹּאמֶר אֲלֵיהֶם יֵשׁוּעַ אֵין נָבִיא בִּבְלִי כָבוֹד זוּלָתִי בְּאֶרֶץ מוֹלַדְתּוֹ בְּקֶרֶב מִשְׁפַּחְתּוֹ וּבְתוֹךְ בֵּיתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","וְלֹא יָכֹל לַעֲשׂוֹת נִפְלָאוֹת שָׁמָּה בִּלְעֲדֵי חוֹלִים אֲחָדִים אֲשֶׁר שָׂם יָדָיו עֲלֵיהֶם וַיִּרְפָּאֵם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","וְשַׁמָּה הֶהֱזִיקַתְהוּ מִפְּנֵי חֹסֶר אֱמוּנָתָם וַיֵּלֶךְ וַיָּסָב לְלַמֵּד בַּכְּפָרִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","וַיִּקְרָא אֶל־שְׁנֵים הֶעָשָׂר וַיָּחֶל לִשְׁלֹחַ אֹתָם שְׁנַיִם שְׁנָיִם וְכֹחַ נָתַן בְּיָדָם עַל־רוּחוֹת הַטֻּמְאָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","וַיְצַו אֹתָם לְבִלְתִּי יִשְׂאוּ צֵדָה לְדַרְכָּם זוּלָתִי מַטֶּה לְבַדּוֹ וְלֹא לֶחֶם וְלֹא יַלְקוּט וְלֹא כֶסֶף בַּכִּיס׃ ");
INSERT INTO hebsg_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","כִּי אִם־לְהַנְעִיל סַנְדָּל לְכַף רַגְלָם וַחֲלִיפוֹת בְּגָדִים בַּל־יִלְבָּשׁוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","וַיֹּאמֶר אֲלֵיהֶם כִּי תָבֹאוּ לְאַחַד הַבָּתִּים בְּאַחַד הַמְּקוֹמוֹת שְׁבוּ בַבַּיִת הַהוּא עַד־אֲשֶׁר תַּעֲבֹרוּן׃ ");
INSERT INTO hebsg_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","וְכָל־אֲשֶׁר לֹא־יַאַסְפוּ אֶתְכֶם הַבַּיְתָה וְלֹא יִשְׁמְעוּ בְקֹלְכֶם צְאוּ מִשָּׁם וּנְעַרְתֶּם אֶת־הָאָבָק מֵעַל רַגְלֵיכֶם לְעֵדוּת לָהֶם אָמֵן אֲנִי אֹמֵר לָכֶם לִסְדֹם וְלַעֲמֹרָה יֵקַל בְּיוֹם הַדִּין מִן־הָעִיר הַהִיא׃ ");
INSERT INTO hebsg_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","וַיֵּצֵאוּ וַיִּקְרְאוּ אֶל־הָעָם לָשׁוּב׃ ");
INSERT INTO hebsg_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","וַיְגָרְשׁוּ רוּחוֹת רָעוֹת רַבּוֹת וְאֶת־חוֹלִים רַבִּים סָכוּ בְשֶׁמֶן וַיִּרְפְּאוּ אֹתָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","וַיִּשְׁמַע הַמֶּלֶךְ הוֹרְדוֹס עַל־יֵשׁוּעַ כִּי נוֹדַע הָיָה שְׁמוֹ בָּאָרֶץ וַיֹּאמֶר כִּי יוֹחָנָן הַמְטַבֵּל קָם מִן־הַמֵּתִים עַל־כֵּן גָּבְרָה יָדוֹ לַעֲשׂוֹת נִפְלָאוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","וְיֵשׁ אֲשֶׁר אָמְרוּ כִּי־הוּא אֵלִיָּהוּ וַאֲחֵרִים אָמְרוּ כִּי־הוּא נָבִיא אוֹ כְּאַחַד הַנְּבִיאִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","וְהוֹרְדוֹס שָׁמַע וַיֹּאמַר זֶה הוּא יוֹחָנָן אֲשֶׁר נָשָׂאתִי אֶת־רֹאשׁוֹ מֵעָלָיו הוּא קָם מִן־הַמֵּתִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","הוּא הוֹרְדוֹס אֲשֶׁר שָׁלַח וַיִּתְפֹּשׂ בְּיוֹחָנָן וַיַּאַסְרֵהוּ וַיִּתְּנֵהוּ בְּבֵית הַסֹּהַר עַל־דְּבַר הוֹרוֹדְיָה אֵשֶׁת פִּילִפּוֹס אָחִיו אֲשֶׁר אֹתָהּ לָקַח לוֹ לְאִשָּׁה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","כִּי יוֹחָנָן אָמַר אֶל־הוֹרְדוֹס לֹא כַתּוֹרָה לָקַחַת אֵשֶׁת אָחִיךָ לְךָ לְאִשָּׁה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","וַתִּשְׂטֹם אֹתוֹ הוֹרוֹדְיָה וַתְּבַקֵּשׁ לַהֲמִיתוֹ וְלֹא יָכְלָה לּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","כִּי הוֹרְדוֹס הָיָה יָרֵא אֶת־יוֹחָנָן בַּאֲשֶׁר יָדַע כִּי אִישׁ צַדִּיק וְקָדוֹשׁ הוּא וַיָּגֶן עָלָיו וְרַבּוֹת עָשָׂה לְפִי דְבָרוֹ אֲשֶׁר אִוָּה לִשְׁמֹעַ לוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","וַיְהִי הַיּוֹם הוּא יוֹם הֻלֶּדֶת אֶת־הוֹרְדוֹס וַיַּעַשׂ מִשְׁתֶּה לִגְדֹלָיו לְשָׂרֵי אֲלָפָיו וּלְרָאשֵׁי הַגָּלִיל׃ ");
INSERT INTO hebsg_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","וַתָּבֹא בַת־הוֹרוֹדְיָה וַתְּרַקֶּד־שָׁם בְּמָחוֹל וַתִּיטַב בְּעֵינֵי הוֹרְדוֹס וּבְעֵינֵי הַיּשְׁבִים בִּמְסִבּוֹ וַיֹּאמֶר הַמֶּלֶךְ אֶל־הַנַּעֲרָה שַׁאֲלִי מִמֶּנִּי וְאֶתֶּן־לָךְ כָּל־בַּקָּשָׁתֵךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","וַיִּשָּׁבַע לָהּ לֵאמֹר כָּל־אֲשֶׁר תִּשְׁאֲלִי מִמֶּנִּי גַּם עַד־חֲצִי הַמַּלְכוּת כֵּן אֶעֱשֶׂה לָּךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","וַתֵּצֵא וַתֹּאמֶר אֶל־אִמָּהּ מָה אֶשְׁאָל וַתַּעַן לֵאמֹר אֶת־רֹאשׁ יוֹחָנָן הַמְטַבֵּל׃ ");
INSERT INTO hebsg_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","וַתְּמַהֵר וַתָּשָׁב אֶל־הַמֶּלֶךְ וַתֹּאמַר שְׁאֵלָתִי כִּי תִתֶּן־לִי כַּיּוֹם בַּסֵּפֶל אֶת־רֹאשׁ יוֹחָנָן הַמְטַבֵּל׃ ");
INSERT INTO hebsg_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","וַיִּתְעַצֵּב הַמֶּלֶךְ עַד־מְאֹד אֶפֶס בַּעֲבוּר הַשְּׁבוּעָה וְהַיּשְׁבִים עִמּוֹ בִּמְסִבּוֹ לֹא אָבָה לְהָשִׁיב אֶת־פָּנֶיהָ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","וַיְמַהֵר הַמֶּלֶךְ וַיִּשְׁלַח אֶחָד מִן־הַטַּבָּחִים וַיְצַוֵּהוּ לְהָבִיא אֶת־רֹאשׁ יוֹחָנָן וַיֵּלֶךְ וַיִּכְרֹת אֶת־רֹאשׁוֹ בְּבֵית הַסֹּהַר׃ ");
INSERT INTO hebsg_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","וַיְבִיאֵהוּ בַסֵּפֶל וַיִּתְּנֵהוּ לַנַּעֲרָה וְהַנַּעֲרָה נָתְנָה אֹתוֹ לְאִמָּהּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","וַיִּשְׁמְעוּ תַלְמִידָיו וַיָּבֹאוּ וַיִּשְׂאוּ אֶת־הֶחָלָל וַיִּקְבְּרֻהוּ בְּמוֹ־קָבֶר׃ ");
INSERT INTO hebsg_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","וַיִּקָּבְצוּ הַשְּׁלִיחִים אֶל־יֵשׁוּעַ וַיַּגִּידוּ לוֹ אֶת־כָּל־אֲשֶׁר עָשׂוּ וְאֵת אֲשֶׁר לִמֵּדוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","וַיֹּאמֶר אֲלֵיהֶם לְכוּ וְנֵלְכָה אֶל־מָקוֹם שָׁמֵם וְתַרְגִּיעוּ שָׁם מְעָט כִּי רַבּוּ הַבָּאִים וְהַשָּׁבִים עַד־אֲשֶׁר לֹא מָצְאוּ לָהֶם עֵת לֶאֱכָל־לָחֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","וַיֵּלְכוּ בָאֳנִיָּה לְבַדָּם אֶל־מָקוֹם שָׁמֵם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","כִּרְאוֹת הֲמוֹן הָעָם אֹתָם הֹלְכִים הִכִּירוּ אֹתוֹ רַבִּים מֵהֶם וַיָּרוּצוּ דֶּרֶךְ הַיָּבָּשָׁה מִכָּל־הֶעָרִים וַיַּקְדִּימוּ לָבֹא אֵלָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","וַיֵּצֵא יֵשׁוּעַ וַיַּרְא הֲמוֹן עַם־רָב וְרַחֲמָיו נִכְמְרוּ עֲלֵיהֶם כִּי הָיוּ כַּצֹּאן אֲשֶׁר אֵין־לָהֶם רֹעֶה וַיָּחֶל לְהוֹרֹתָם דְּבָרִים שׁוֹנִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","וַיְהִי כִּי־פָנָה הַיּוֹם וַיָּבֹאוּ אֵלָיו תַּלְמִידָיו וַיֹּאמְרוּ הַמָּקוֹם שָׁמֵם וְהַיּוֹם רַד מְאֹד׃ ");
INSERT INTO hebsg_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","שַׁלְּחֵם מֵעַל פָּנֶיךָ וְיֵלְכוּ אֶל־הֶעָרִים וְחַצְרֵיהֶן מִסָּבִיב לִקְנוֹת לָהֶם לֶחֶם כִּי אֵין לָהֶם מַה־שֶׁיּאֹכֵלוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","וַיַּעַן וַיֹּאמֶר אֲלֵיהֶם תְּנוּ לָהֶם אַתֶּם לֶאֱכֹל וַיֹּאמְרוּ אֵלָיו וְכִי נֵלֵךְ לִקְנוֹת לָהֶם לֶחֶם בְּמָאתַיִם דִּינָר וּמָצָא לָהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","וַיֹּאמֶר אֲלֵיהֶם כַּמָּה כִּכְּרוֹת־לֶחֶם לָכֶם לְכוּ וּרְאוּ וַיִּרְאוּ וַיֹּאמְרוּ חֲמִשָּׁה לֶחֶם וְדָגִים שְׁנָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","וַיְצַו אֹתָם כִּי ישִׁבוּם כֻּלָּם חֶבֶל חֶבֶל בִּנְאוֹת דֶּשֶׁא׃ ");
INSERT INTO hebsg_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","וַיֵּשְׁבוּ לָהֶם שׁוּרָה עַל־שׁוּרָה מֵאָה מֵאָה אִישׁ וַחֲמִשִּׁים חֲמִשִּׁים אִישׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","וַיִּקַּח אֶת־חֲמֵשֶׁת הַלֶּחֶם וְאֶת־שְׁנֵי הַדָּגִים וַיִּשָּׂא עֵינָיו לַמָּרוֹם וַיְבָרֶךְ וַיִּפְרֹס אֶת־הַלֶּחֶם וַיִּתֶּן לְתַלְמִידָיו לָשׂוּם לִפְנֵיהֶם וְאֶת־שְׁנֵי הַדָּגִים חִלַּק לְכֻלָּם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","וַיֹּאכְלוּ כֻלָּם וַיִּשְׂבָּעוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","וַיִּשְׂאוּ שְׁנֵים עָשָׂר סַלִּים מְלֵאִים מִן־הַפְּתוֹתִים הַנּוֹתָרִים וּמִן־הַדָּגִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","וְאֵלֶּה אֲשֶׁר לָחֲמוּ בַּלֶּחֶם הַהוּא הָיוּ כַּחֲמֶשֶׁת אַלְפֵי אִישׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","אָז חָזַק דְּבָרוֹ עַל־תַּלְמִידָיו לָרֶדֶת בָּאֳנִיָּה וְלַעֲבֹר לְפָנָיו אֶל־עֵבֶר הַיָּם אֶל־בֵּית צָיְדָה בְּעוֹד הוּא יְשַׁלַּח אֶת־הָעָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","וְאַחֲרֵי אֲשֶׁר פָּטַר אֹתָם עָלָה עַל־הָהָר לְהִתְפַּלֵּל׃ ");
INSERT INTO hebsg_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","וְהָאֳנִיָּה בָאָה בְּלֵב הַיָּם אַחֲרֵי בֹּא הָעָרֶב וַיִּוָּתֵר הוּא לְבַדּוֹ בַּיַּבָּשָׁה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","וַיַּרְא אֶת־הַשָּׁטִים בָּאֳנִיָּה בְּצָרָה גְדוֹלָה כִּי הַסַּעַר הוֹלֵךְ וְסֹעֵר נֶגֶד פְּנֵיהֶם וַיָּבֹא אֲלֵיהֶם בְּעוֹד לַיְלָה לְעֵת הָאַשְׁמֹרֶת הָרְבִיעִית דֹּרֵךְ עַל־פְּנֵי הַיָּם וַיּוֹאֶל לַעֲבֹר אֹתָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","וְהֵם רָאוּ אֹתוֹ דֹּרֵךְ עַל־פְּנֵי הַיָּם וַיַּחְשְׁבוּ כִּי חֲזוֹן־רוּחַ הוּא וַיִּצְעָקוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","כִּי־כֻלָּם רָאוּ אֹתוֹ וְנִבְהָלוּ וַיְמַהֵר לְדַבֵּר עַל־לִבָּם וַיֹּאמֶר אֲלֵיהֶם חִזְקוּ אֲנִי הוּא אַל־תִּירָאוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","וַיֵּרֶד אֲלֵהֶם אֶל־תּוֹךְ הָאֳנִיָּה וְהָרוּחַ שָׁכָכָה וְהֵם כֵּן תָּמְהוּ בְּתִמְהוֹן לֵבָב יֶתֶר מְאֹד׃ ");
INSERT INTO hebsg_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","כִּי גַּם־בִּדְבַר־כִּכְּרוֹת הַלֶּחֶם עַד־כֹּה לֹא הִשְׂכִּילוּ כִּי הָיוּ כִּבְדֵי־לֵב׃ ");
INSERT INTO hebsg_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","וַיַּעַבְרוּ וַיָּבֹאוּ אַרְצָה גִנֵּיסַר וַיִּקְרְבוּ אֶל־הַחוֹף׃ ");
INSERT INTO hebsg_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","וְעוֹד הֵם עֹלִים מִן־הָאֳנִיָּה וְאַנְשֵׁי הַמָּקוֹם הִכִּירֻהוּ כְּרָגַע׃ ");
INSERT INTO hebsg_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","וַיָּרֻצוּ בְּכָל־הַכִּכָּר וַיָּחֵלּוּ לָשֵׂאת אֶת־הַחוֹלִים עַל־מִשְׁכָּבָם לַהֲבִיאָם אֶל־הַמָּקוֹם אֲשֶׁר שָׁמְעוּ כִּי־הוּא שָׁם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","וּבְכָל־מָקוֹם אֲשֶׁר בָּא שָׁמָּה בִּכְפָרִים אוֹ בְעָרִים וְחַצְרֵיהֶן שָׁם שָׂמוּ אֶת־הַחוֹלִים לְפָנָיו עַל־פְּנֵי חוּצוֹת וַיִּתְחַנְּנוּ־לוֹ לְתִתָּם לָגַעַת בִּכְנַף בִּגְדוֹ וַיְהִי כֹּל אֲשֶׁר נָגַע־בּוֹ וָחָי׃ ");
INSERT INTO hebsg_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","וַיִּקָּהֲלוּ אֵלָיו פְּרוּשִׁים וְסוֹפְרִים אֲחָדִים אֲשֶׁר בָּאוּ מִירוּשָׁלָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","וַיִּרְאוּ אֵת אֲחָדִים מִתַּלְמִידָיו אֹכְלִים לֶחֶם בְּיָדַיִם טְמֵאוֹת כִּי לֹא רָחָצוּ וַיּוֹכִיחוּ אֹתָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","כִּי הַפְּרוּשִׁים וְכָל־הַיְּהוּדִים לֹא יֹאכְלוּ לֶחֶם בִּלְתִּי אִם־יִרְחֲצוּ אֶת־יְדֵיהֶם עַד־הַפרק כִּי אֶת־קַבָּלַת הַזְּקֵנִים יִשְׁמֹרוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","וּבְבוֹאָם מִן־הַשּׁוּק לֹא יֹאכְלוּ בִּבְלִי רָחְצָה וְעוֹד רַבּוֹת קִבְּלוּ עֲלֵיהֶם לִשְׁמֹר כְּמוֹ טְבִילַת כֹּסוֹת וְכַדִּים וְכִיֹּרוֹת וּמִטּוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","וַיִּשְׁאֲלוּ אֹתוֹ הַפְּרוּשִׁים וְהַסּוֹפְרִים לֵאמֹר מַדּוּעַ לֹא יִשְׁמְרוּ תַלְמִידֶיךָ אֶת־מְסֹרַת הַזְּקֵנִים כִּי הֵם אֹכְלִים לֶחֶם בְּלִי נְטִילַת יָדָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","וַיֹּאמֶר אֲלֵיהֶם חַנְפֵי־לֵב הֵיטֵב נִבָּא עֲלֵיכֶם יְשַׁעְיָהוּ כַּכָּתוּב הָעָם הַזֶּה בִּשְׂפָתָיו כִּבְּדוּנִי וְלִבּוֹ רִחַק מִמֶּנִּי׃ ");
INSERT INTO hebsg_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","וְתֹהוּ יִרְאָתָם אֹתִי מִצְוֹת אֲנָשִׁים מְלַמְּדִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","כִּי מִצְוֹת אֱלֹהִים עֲזַבְתֶּם וַתִּשְׁמְרוּ מְסֹרַת אֲנָשִׁים טְבִילַת כַּדִּים וְכֹסוֹת וְכָאֵלֶּה רַבּוֹת אַתֶּם עֹשִׂים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","וַיֹּאמֶר אֲלֵיהֶם הֵיטַבְתֶּם לִמְאֹס בְּמִצְוֹת אֱלֹהִים לְמַעַן תִּנְצְרוּ אֶת־קַבָּלַתְכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","כִּי־מֹשֶׁה אָמַר כַּבֵּד אֶת־אָבִיךָ וְאֶת־אִמֶּךָ וּמְקַלֵּל אָבִיו וְאִמּוֹ מוֹת יוּמָת׃ ");
INSERT INTO hebsg_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","וְאַתֶּם אֹמְרִים אִישׁ כִּי־יֹאמַר לְאָבִיו אוֹ לְאִמּוֹ קָרְבָּן כָּל־הַנָּאָה אֲשֶׁר תֶּהְנֶה מִמֶּנּוּ הֲרֵי זֶה נֶדֶר׃ ");
INSERT INTO hebsg_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","וְלֹא תִתְּנוּ לוֹ לַעֲשׂוֹת עוֹד מְאוּמָה לְאָבִיו וּלְאִמּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","וַתָּפֵרוּ אֶת־דְּבַר אֱלֹהִים מִפְּנֵי מְסֹרַתְכֶם אֲשֶׁר תִּמְסְרוּ אַתֶּם וְכֵן רַבּוֹת אַתֶּם עֹשִׂים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","וַיּוֹסֶף וַיִּקְרָא אֶל־הָעָם וַיֹּאמֶר אֲלֵיהֶם הַאֲזִינוּ אֵלַי כֻּלְּכֶם וְהַשְׂכִּילוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","אֵין דָּבָר אֲשֶׁר יָבֹא בְּקֶרֶב הָאָדָם מִחוּצָה־לּוֹ יוּכַל לְטַמֵּא אֹתוֹ כִּי אִם־זֶה אֲשֶׁר יֵצֵא מִמֶּנּוּ הוּא יְטַמֵּא אֶת־הָאָדָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","מִי אֲשֶׁר־אָזְנַיִם לוֹ לִשְׁמֹעַ יִשְׁמָע׃ ");
INSERT INTO hebsg_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","וְכַאֲשֶׁר שָׁב מִתּוֹךְ הָעָם הַבָּיְתָה וַיִּשְׁאֲלוּ אֹתוֹ תַּלְמִידָיו עַל־דְּבַר מְשָׁלוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","וַיֹּאמֶר אֲלֵיהֶם הֲכִי גַם־אַתֶּם עוֹד בִּבְלִי בִינָה הֲלֹא תַשְׂכִּילוּ כִּי כָּל־הַבָּא מִחוּץ אֶל־תּוֹךְ הָאָדָם לֹא יְטַמְּאֶנּוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","כִּי לֹא־יָבֹא אֶל־לִבּוֹ כִּי אִם־אֶל־כְּרֵשׂוֹ וּמִשָּׁם יֵצֵא הַפַּרְשְׁדֹנָה אֲשֶׁר יְזַקֵּק כָּל־מָזוֹן׃ ");
INSERT INTO hebsg_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","וַיֹּאמַר אָכֵן הַיֹּצֵא מִתּוֹךְ הָאָדָם הוּא יְטַמְּאֶנּוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","כִּי מִתּוֹךְ הָאָדָם מִתּוֹךְ לִבּוֹ יֵצְאוּ יִצְרֵי מַחֲשָׁבוֹת רָעוֹת זְנוּנִים גְּנֵבָה וָרָצַח׃ ");
INSERT INTO hebsg_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","נִאֻפִים אַהֲבַת בֶּצַע וָרֶשַׁע רְמִיָּה וְזִמָּה וְרָעַת־עַיִן גִּדּוּפִים גֵּאוּת וּנְבָלָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","כָּל־הָרָעוֹת הָאֵלֶּה מִתּוֹךְ הָאָדָם הֵן יֹצְאוֹת וּמְטַמְּאוֹת אֹתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","וַיָּקָם וַיֵּלֶךְ מִשָּׁם אֶל־גְּבוּל צוֹר וְצִידוֹן וַיָּבֹא אֶל־אַחַד הַבָּתִּים וְלֹא אָבָה אֲשֶׁר יַכִּירֶנּוּ אִישׁ אַךְ לֹא יָכֹל לְהִסָּתֵר׃ ");
INSERT INTO hebsg_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","כִּי אִשָּׁה אֲשֶׁר בִּתָּהּ הַיַּלְדָּה רוּחַ טֻמְאָה מְבַעִתָּהּ שָׁמְעָה עָלָיו וַתְּמַהֵר וַתָּבֹא וַתִּפֹּל לְרַגְלָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","וְהָאִשָּׁה יְוָנִית וּמוֹלַדְתָּהּ אֲרַם־צֹר וַתְּבַקְשֵׁהוּ לְהַרְחִיק אֶת־הָרוּחַ הָרָעָה מִקֶּרֶב בִּתָּהּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","וַיֹּאמֶר אֵלֶיהָ יֵשׁוּעַ נָתוֹן לַבָּנִים לִשְׂבֹּעַ רִאשׁוֹנָה כִּי לֹא־נָכוֹן לָקַחַת אֶת־לֶחֶם הַבָּנִים וּלְהַשְׁלִיכוֹ לִפְנֵי הַכְּלָבִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","וַתַּעַן וַתֹּאמֶר אֵלָיו כֵּן אֲדֹנִי אֶפֶס גַּם־הַכְּלָבִים יֹאכְלוּ תַּחַת הַשֻּׁלְחָן מִפְּתוֹתֵי לֶחֶם הַבָּנִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","וַיֹּאמֶר אֵלֶיהָ יַעַן כָּזֹאת דִּבַּרְתְּ לְכִי־לָךְ סָרָה הָרוּחַ הָרָעָה מִבִּתֵּךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","וַתָּשָׁב אֶל־בֵּיתָהּ וַתִּמְצָא אֶת־בִּתָּהּ שֹׂכֶבֶת עַל־מִטָּתָהּ וְהָרוּחַ הָרָעָה סָרָה מֵעָלֶיהָ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","וַיִּפֶן וַיֵּצֵא מִגְּבוּל צוֹר דֶּרֶךְ צִידוֹן וַיָּבֹא עַד־יָם הַגָּלִיל בְּתוֹךְ גְּבוּל דֶּכַּפּוֹלִיס׃ ");
INSERT INTO hebsg_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","וַיָּבִיאוּ אֵלָיו אִישׁ חֵרֵשׁ וְאִלֵּם וַיִּפְצְרוּ־בוֹ לָשׂוּם אֶת־יָדוֹ עָלָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","וַיִּקָּחֵהוּ מִקֶּרֶב הָעָם לְבַדּוֹ וַיָּשָׂם אֶת־אֶצְבְּעֹתָיו בְּאָזְנָיו וַיָּרָק וַיִּגַּע בִּלְשׁוֹנוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","וַיִּשָּׂא עֵינָיו לַמָּרוֹם וַיֵּאָנַח וַיֹּאמֶר לוֹ אִפַּתַּח אֲשֶׁר יֵאָמֵר הִתְפַּתֵּחַ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","וַיִּפָּתְחוּ אָזְנָיו וּמוֹסְרֵי לְשׁוֹנוֹ נִתָּקוּ וַיְדַבֵּר בְּשָׂפָה בְרוּרָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","וַיְצַו עֲלֵיהֶם לְבִלְתִּי יַגִּידוּ לְאִישׁ וְכַאֲשֶׁר יְצַוֶּה עֲלֵיהֶם כֵּן יוֹסִיפוּ לְהַשְׁמִיעַ אֶת־הַדָּבָר בָּרַבִּים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","וַיִּתְמְהוּ עַד־מְאֹד לֵאמֹר כָּל־אֲשֶׁר עָשָׂה טוֹב מְאֹד כִּי עַל־פִּיו חֵרְשִׁים שֹׁמְעִים וְאִלְּמִים מְדַבְּרִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","וַיְהִי בַּיָּמִים הָהֵם וַיִּתְאַסְּפוּ אֵלָיו עַם־רָב וְלֹא הָיָה לָהֶם כָּל־אֹכֶל לְמַלֵּא לְנַפְשָׁם וַיִּקְרָא יֵשׁוּעַ אֶל־תַּלְמִידָיו וַיֹּאמֶר אֲלֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","מָלֵאתִי רַחֲמִים עַל־הָעָם כִּי עָמְדוּ עִמָּדִי זֶה שְׁלֹשֶׁת יָמִים וְאֵין לָהֶם מַה־לֶּאֱכֹל׃ ");
INSERT INTO hebsg_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","וְכִי אֲשַׁלְּחֵם רְעֵבִים לְבָתֵּיהֶם יִתְעַלְּפוּ בַּדָּרֶךְ וְיֵשׁ מֵהֶם אֲשֶׁר בָּאוּ מִמֶּרְחָק׃ ");
INSERT INTO hebsg_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","וַיַּעֲנוּ אֹתוֹ תַלְמִידָיו מֵאַיִן תַּשִּׂיג יַד־אִישׁ בַּמִּדְבָּר לְהַשְׂבִּיעַ אֶת־אֵלֶּה לָחֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","וַיִּשְׁאַל אֹתָם לֵאמֹר כַּמָּה לָכֶם לֶחֶם וַיֹּאמְרוּ שִׁבְעָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","וַיְצַו אֶת־הֲמוֹן הָעָם לָשֶׁבֶת עַל־הָאָרֶץ וַיִקַּח אֶת־שִׁבְעַת הַלֶּחֶם וַיְבָרֶךְ וַיִּפְרֹס וַיִּתֵּן אֶל־תַּלְמִידָיו לָשׂוּם לִפְנֵיהֶם וַיָּשִׂמוּ לִפְנֵי הֲמוֹן הָעָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","וּמְעַט דָּגִים קְטַנִּים הָיוּ לָהֶם אֲשֶׁר בֵּרַךְ עֲלֵיהֶם וַיֹּאמֶר לָשׂוּם לִפְנֵיהֶם גַּם־אֶת־אֵלֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","וַיֹּאכְלוּ וַיִּשְׂבָּעוּ וַיִּשְׂאוּ אֶת־הַפְּתוֹתִים הַנּוֹתָרִים שִׁבְעָה סַלִּים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","וְהֵם הָיוּ כְּאַרְבַּעַת אַלְפֵי־אִישׁ וְאַחֲרֵי־כֵן שִׁלַּח אֶת־הָעָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","אָז יָרַד בָּאֳנִיָּה עִם־תַּלְמִידָיו וַיָּבֹא שְׂדֵה דַלְמָנוּתָא׃ ");
INSERT INTO hebsg_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","וַיֵּצְאוּ הַפְּרוּשִׁים וַיָּחֵלּוּ לְהִתְוַכַּח אִתּוֹ וּלְבַעֲבוּר נַסּוֹתוֹ שָׁאֲלוּ לָתֵת לָהֶם אוֹת מִן־הַשָּׁמָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","וַיֵּאָנַח בִּמְרִירוּת רוּחוֹ לֵאמֹר מַדּוּעַ יְבַקֵּשׁ הַדּוֹר הַזֶּה אוֹת אָמֵן אֲנִי אֹמֵר לָכֶם כִּי אוֹת לֹא יִנָּתֵן לַדּוֹר הַזֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","וַיַּעֲזֹב אֹתָם וַיָּשָׁב וַיַּעֲבֹר בָּאֳנִיָּה אֶל־עֵבֶר הַיָּם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","וְהֵם שָׁכְחוּ לָקַחַת אִתָּם צֵדָה לַדָּרֶךְ וְלֹא־נִמְצָא בָאֳנִיָּתָם בִּלְתִּי כִּכַּר־לֶחֶם אֶחָת׃ ");
INSERT INTO hebsg_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","וְהוּא הִזְהִיר אֹתָם לֵאמֹר רְאוּ הִשָּׁמְרוּ לָכֶם מֵחֻמְצַת הַפְּרוּשִׁים וּמִשְּׂאֹר הוֹרְדוֹס׃ ");
INSERT INTO hebsg_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","וַיְהִי הֵם נְדוֹנִים אִישׁ אֶת־אָחִיו לֵאמֹר עַל כִּי־לֶחֶם אֵין אִתָּנוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","וַיֵּדַע יֵשׁוּעַ וַיֹּאמֶר אֲלֵיהֶם לָמָּה־זֶּה אַתֶּם נְדוֹנִים עַל כִּי־אֵין לָכֶם לָחֶם הֲכִי לֹא תָבִינוּ וְלֹא תַשְׂכִּילוּ וְלִבְּכֶם כָּבֵד עַד־כֹּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","עֵינַיִם לָכֶם וְלֹא תִרְאוּ וְאָזְנַיִם לָכֶם וְלֹא תַקְשִׁיבוּ וְלֹא תִזְכֹּרוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","כַּאֲשֶׁר פָּרַסְתִּי אֶת־חֲמֵשֶׁת הַלֶּחֶם לַחֲמֵשֶׁת אֲלָפִים כַּמָּה סַלִּים מְלֵאִים פְּתוֹתִים נְשָׂאתֶם מֵהֶם וַיֹּאמְרוּ אֵלָיו שְׁנֵים־עָשָׂר׃ ");
INSERT INTO hebsg_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","וּמִן־הַשֶּׁבַע לְאַרְבַּעַת הָאֲלָפִים כַּמָּה סַלִּים מְלֵאִים פְּתוֹתִים נְשָׂאתֶם מֵהֶם וַיֹּאמְרוּ אֵלָיו שִׁבְעָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","וַיֹּאמֶר אֲלֵיהֶם הֲכִי עוֹד לֹא תַשְׂכִּילוּ עַד־כֹּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","וַיָּבֹאוּ אֶל־בֵּית צָיְדָה וַיָּבִיאוּ אֵלָיו אִישׁ עִוֵּר וַיְבַקְשֻׁהוּ לְתִתּוֹ לָגַעַת בּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","וַיַּחֲזֵק בְּיַד הָעִוֵּר וַיּוֹצִיאֵהוּ אֶל־מִחוּץ לָעִיר וַיָּרָק בְּעֵינָיו וְאֶת־יָדָיו שָׂם עָלָיו וַיִּשְׁאָלֵהוּ אִם־הוּא רֹאֶה מְאוּמָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","וַיִּשָּׂא אֶת־עֵינָיו וַיֹּאמַר אֲנִי רֹאֶה אֲנָשִׁים כִּי אֲנִי רֹאֶה אֹתָם הֹלְכִים כְּמוֹ־עֵצִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","וַיָּשֶׂם אֶת־יָדָיו שֵׁנִית עַל־עֵינָיו וַיִּפְקַח אֹתָן אָז הִתְרַפֵּא וַיַּרְא כָּל־דָּבָר אֶל־נָכוֹן׃ ");
INSERT INTO hebsg_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","וַיְשַׁלְּחֵהוּ אֶל־בֵּיתוֹ וַיֹּאמַר אַל־תָּבֹא בָּעִיר וְאַל לְהַגִּיד לְאִישׁ דָּבָר בָּעִיר׃ ");
INSERT INTO hebsg_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","וַיֵּצֵא יֵשׁוּעַ מִשָּׁם וַיֵּלֶךְ עִם־תַּלְמִידָיו אֶל־הַכְּפָרִים בְּקִיסְרִין אֲשֶׁר לְפִילִפּוֹס וַיְהִי בַּדֶּרֶךְ וַיִּשְׁאַל אֹתָם לֵאמֹר מָה־אֹמְרִים הָאֲנָשִׁים עָלַי מִי־אָנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","וַיַּעֲנוּ וַיֹּאמְרוּ יוֹחָנָן הַמְטַבֵּל וְיֵשׁ אֹמְרִים אֵלִיָּהוּ וַאֲחֵרִים אֹמְרִים אֶחָד מִן־הַנְּבִיאִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","וַיִּשְׁאַל אֹתָם לֵאמֹר וְאַתֶּם מַה־תֹּאמְרוּ עָלַי מִי־אָנִי וַיַּעַן פֶּטְרוֹס וַיֹּאמֶר אֵלָיו אַתָּה הוּא הַמָּשִׁיחַ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","וַיְצַו עֲלֵיהֶם לְבִלְתִּי הַגֵּד לְאִישׁ עַל־אֹדוֹתָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","אָז הֵחֵל לְהוֹרֹתָם לֵאמֹר רַבִּים מַכְאֹבִים לְבֶן־הָאָדָם וְהַזְּקֵנִים וְרָאשֵׁי הַכֹּהֲנִים וְהַסּוֹפְרִים יִמְאֲסוּ בוֹ וִימִיתֻהוּ וּמִקְצֵה שְׁלֹשֶׁת יָמִים יָקוּם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","וְאֶת־הַדָּבָר הַזֶּה הִגִּיד בַּאֵר הֵיטֵב וַיִּקַּח אֹתוֹ פֶּטְרוֹס וַיָּחֶל לְהוֹכִיחוֹ בִּדְבָרִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","אַךְ הוּא פָּנָה כֹּה וָכֹה וַיַּבֵּט אֶל־תַּלְמִידָיו וַיִּגְעַר בְּפֶטְרוֹס לֵאמֹר סוּר שָׁטָן מֵעַל־פָּנַי כִּי לֹא תַשְׂכִּיל אֶת־אֲשֶׁר לֵאלֹהִים כִּי אִם־אֶת־אֲשֶׁר לָאָדָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","וַיִּקְרָא אֶל־הָעָם וְאֶל־תַּלְמִידָיו וַיֹּאמֶר אֲלֵיהֶם מִי־הֶחָפֵץ לָלֶכֶת אַחֲרַי יַשְׁלִיךְ אֶת־נַפְשׁוֹ מִנֶּגֶד וְיִשָּׂא אֶת־צְלָבוֹ וְיֵלֵךְ אַחֲרָי׃ ");
INSERT INTO hebsg_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","כִּי מִי־הֶחָפֵץ לְהַצִּיל אֶת־נַפְשׁוֹ תִּכָּרֶת־לוֹ וּמִי־אֲשֶׁר־יַכְרִית אֶת־נַפְשׁוֹ לְמַעֲנִי וּלְמַעַן הַבְּשׂוֹרָה יִמְצָאֶנָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","כִּי מַה־בֶּצַע לְאִישׁ אִם־יִקְנֶה־לּוֹ אֶת־כָּל־הָאָרֶץ וְנַפְשׁוֹ תִּכָּרֶת־לוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","אוֹ מַה־יִּתֶּן אִישׁ פִּדְיוֹן נַפְשׁוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","כִּי כָּל־אִישׁ אֲשֶׁר יֵבוֹשׁ מִמֶּנִּי וּמִדְּבָרַי בַּדּוֹר הַבֹּגֵד וְהַפּשֵׁעַ הַזֶּה אַף בֶּן־הָאָדָם יֵבוֹשׁ מִמֶּנּוּ גַּם־הוּא כַּאֲשֶׁר יָבֹא בִכְבוֹד אָבִיו עִם־מַלְאָכָיו הַקְּדוֹשִׁים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","וַיֹּאמֶר אֲלֵיהֶם אָמֵן אֲנִי אֹמֵר לָכֶם יֵשׁ מִן־הַנִּצָּבִים פֹּה אֲשֶׁר לֹא־יִטְעֲמוּ מָוֶת עַד כִּי־יִרְאוּ צֵאת מַלְכוּת אֱלֹהִים בִּגְבוּרָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","וְאַחֲרֵי שֵׁשֶׁת יָמִים לָקַח יֵשׁוּעַ אֶת־פֶּטְרוֹס וְאֶת־יַעֲקֹב וְאֶת־יוֹחָנָן אִתּוֹ וַיְבִיאֵם אֶל־הַר גָּבֹהַּ לְבַדָּם וַיִּשְׁתַּנֶּה לְעֵינֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","וּבְגָדָיו נוֹצְצוּ וְהִלְבִּינוּ אֵין כּוֹבֵס בָּאָרֶץ יוּכַל לְכַבֵּס בְּגָדִים לְבָנִים כְּמוֹהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","וְהִנֵּה אֵלִיָּהוּ וּמשֶׁה נִרְאוּ אֲלֵיהֶם מִדַּבְּרִים עִם־יֵשׁוּעַ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","וַיַּעַן פֶּטְרוֹס וַיֹּאמֶר אֶל־יֵשׁוּעַ רַבִּי טוֹב לָנוּ לָשֶׁבֶת פֹּה נַעֲשֶׂה־נָּא שָׁלֹשׁ סֻכּוֹת אַחַת לְךָ אַחַת לְמֹשֶׁה וְאַחַת לְאֵלִיָּהוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","כִּי הוּא לֹא־יָדַע מַה־לְּדַבֵּר כִּי נָפְלָה עֲלֵיהֶם אֵימָתָה וָפָחַד׃ ");
INSERT INTO hebsg_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","וְהִנֵּה עָנָן סָכַךְ עֲלֵיהֶם וְקוֹל יֹצֵא מִן־הֶעָנָן לֵאמֹר זֶה בְּנִי יְדִידִי אֵלָיו תִּשְׁמָעוּן׃ ");
INSERT INTO hebsg_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","וּפִתְאֹם הִבִּיטוּ מִסָּבִיב וְלֹא־רָאוּ עוֹד אִישׁ זוּלָתִי יֵשׁוּעַ לְבַדּוֹ אִתָּם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","וַיְהִי בְּרִדְתָּם מִן־הָהָר וַיְצַו אֹתָם לְבִלְתִּי הַגֵּד לְאִישׁ אֶת־אֲשֶׁר רָאוּ עַד כִּי־יָקוּם בֶּן־הָאָדָם מִן־הַמֵּתִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","וְהֵם שָׁמְרוּ אֶת־הַדָּבָר בְּלִבָּם וַיַּחְקְרוּ בֵינֵיהֶם מַה־הִיא הַתְּקוּמָה מִן־הַמֵּתִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","וַיִּשְׁאֲלוּ אֹתוֹ לֵאמֹר לָמָּה־זֶּה יֹאמְרוּ הַסּוֹפְרִים כִּי אֵלִיָּהוּ בֹּא יָבֹא רִאשׁוֹנָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","וַיֹּאמֶר אֲלֵיהֶם אָכֵן אֵלִיָּהוּ יָבֹא רִאשׁוֹנָה וְהֵשִׁיב אֶת־הַכֹּל וּכְמוֹ שֶׁכָּתוּב עַל בֶּן־הָאָדָם כֵּן גַּם־הוּא נָכוֹן לִהְיוֹת מְעֻנֶּה וּמְדֻכָּא וְנִגְזָר מֵאֶרֶץ חַיִּים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","אֶפֶס אֲנִי אֹמֵר לָכֶם כִּי גַּם־אֵלִיָּהוּ כְּבָר בָּא וַיַּעֲשׂוּ־בוֹ כִּרְצוֹנָם כַּכָּתוּב עָלָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","וַיְהִי כְּבֹאָם אֶל־שְׁאָר הַתַּלְמִידִים וַיִּרְאוּ עַם־רָב סְבִיבוֹתָם וְסוֹפְרִים מִתְוַכְּחִים עִמָּהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","וְכָל־הָעָם כִּרְאוֹתָם אֹתוֹ הִשְׁתָּאוּ תָּמָהוּ וַיָּרֻצוּ וַיִּשְׁאֲלוּ־לוֹ לְשָׁלוֹם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","וְהוּא שָׁאַל אוֹתָם מָה־אַתֶּם מִתְוַכְּחִים עִמָּהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","וַיַּעַן אֹתוֹ אֶחָד מִן־הָעָם רַבִּי הֵבֵאתִי לְךָ בָּזֶה אֶת־בְּנִי אֲשֶׁר־רוּחַ אִלֵּם מְבַעֲתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","וּלְעֵת יַחֲזִיק בּוֹ יִטְרְפֶנּוּ יוֹרִיד רִירוֹ וְשִׁנָּיו יַחֲרֹק עַד־אֲשֶׁר יָבֵשׁ כֹּחוֹ וָאֹמַר אֶל־תַּלְמִידֶיךָ לְגָרְשׁוֹ וְלֹא יָכֹלוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","וַיַּעַן וַיֹּאמֶר אֲלֵיהֶם הוֹי דּוֹר לֹא אֵמֻן בּוֹ עַד־מָתַי אֶהְיֶה עִמָּכֶם עַד־מָתַי אֶשָּׂא אֶתְכֶם הֲבִיאֻהוּ אֵלַי הֵנָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","וַיְבִיאֻהוּ לְפָנָיו וְכַאֲשֶׁר רָאָהוּ הָרוּחַ וַיַּחְתֹּף אֹתוֹ חָתֹף וְטָרֹף וַיִּפֹּל אַרְצָה וַיִּתְגֹּלֵל בְּרִירוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","וַיִּשְׁאַל אֶת־אָבִיו מֵאֵיזֶה יוֹם דָּבַק בּוֹ זֶה וַיֹּאמֶר מִימֵי נְעוּרָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","וּפְעָמִים רַבּוֹת הִפִּילוֹ בָאֵשׁ וּבַמַּיִם לְהַאֲבִידוֹ אַךְ אִם יֶשׁ־לְאֵל יָדְךָ לַעֲשׂוֹת דָּבָר חוּסָה־נָּא עָלֵינוּ וְהוֹשִׁיעֵנוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","וַיֹּאמֶר אֵלָיו יֵשׁוּעַ אִם יֶשׁ־לְאֵל יָדְךָ לְהַאֲמִין אָתָּה לְמַאֲמִין כָּל־דָּבָר יֵעָשֶׂה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","וַיִּצְעַק אֲבִי הַיֶּלֶד וַיֹּאמַר בִּדְמָעוֹת הִנְנִי מַאֲמִין אֲדֹנִי הוֹשִׁיעָה לַחֲסַר אֱמוּנָה כָּמֹנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","וַיַּרְא יֵשׁוּעַ כִּי הֶהָמוֹן הֹלֵךְ הָלוֹךְ וָרָב וַיִּגְעַר בְּרוּחַ הַטֻּמְאָה לֵאמֹר אֲנִי מְצַוְּךָ צֵא מִמֶּנּוּ רוּחַ אִלֵּם וְחֵרֵשׁ אַל־תּוֹסִף לָבוֹא־בוֹא עוֹד׃ ");
INSERT INTO hebsg_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","וַיִּצְעַק וַיִּטְרֹף אֶת־נַפְשׁוֹ בְּאַפּוֹ וַיֵּצֵא וְהַנַּעַר נִשְׁאַר כַּמֵּת וְרַבִּים אָמְרוּ כִּי־גָוָע׃ ");
INSERT INTO hebsg_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","וְיֵשׁוּעַ הֶחֱזִיק בְּיָדוֹ וַיְקִימֵהוּ וַיָּקֹם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","וַיְהִי בְּבֹאוֹ הַבַּיְתָה וַיִּשְׁאֲלוּ אֹתוֹ תַּלְמִידָיו וְהֵם לְבַדָּם אִתּוֹ מַדּוּעַ לֹא מָצְאָה יָדֵנוּ אֲנַחְנוּ לְגָרְשׁוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","וַיֹּאמֶר אֲלֵיהֶם מִין רוּחַ רָע כָּזֶה לֹא־יְגֹרָשׁ כִּי אִם־בִּתְפִלָּה וּבְצוֹם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","וַיֵּצְאוּ מִשָּׁם וַיַּעַבְרוּ בַגָּלִיל וְלֹא אָבָה שָׁם לְהִוָּדַע לְאִישׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","כִּי הִקְדִּישׁ עִתּוֹ לְלַמֵּד לְתַלְמִידָיו וְלָשִׂים לִפְנֵיהֶם אֵיךְ בֶּן־הָאָדָם יִסָּגֵר בִּידֵי אֲנָשִׁים אֲשֶׁר יְמִיתֻהוּ וְאַחֲרֵי אֲשֶׁר יוּמַת יָקוּם בַּיּוֹם הַשְּׁלִישִׁי וָחָי׃ ");
INSERT INTO hebsg_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","וְהֵם לֹא הֵבִינוּ אֶת־דְּבָרוֹ וַיִּירְאוּ לִשְׁאֹל אֹתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","וַיָּבֹאוּ אֶל־כְּפַר־נַחוּם וַיְהִי בַבַּיִת וַיִּשְׁאַל אֹתָם מַה־דִּין וּדְבָרִים הָיוּ בֵינֵיכֶם בַּדָּרֶךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","וְלֹא עָנוּ דָבָר כִּי רָבוּ בֵינֵיהֶם בַּדֶּרֶךְ מִי הוּא הַגָּדוֹל בָּהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","וַיֵּשֶׁב וַיִּקְרָא אֶל־שְׁנֵים הֶעָשָׂר וַיֹּאמֶר אֲלֵיהֶם מִי־הֶחָפֵץ לִהְיוֹת רִאשׁוֹן עָלָיו לִהְיוֹת אַחֲרוֹן לְכֻלָּם וּמְשָׁרֵת לְכֻלָּם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","וַיִּקַּח יֶלֶד וַיַּצִּיגֵהוּ בְתוֹכָם וְאַחֲרֵי אֲשֶׁר חִבֶּק־לוֹ אָמַר אֲלֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","מִי־הוּא הַמְקַבֵּל בִּשְׁמִי אַחַד הַיְלָדִים כָּזֶה אֹתִי הוּא מְקַבֵּל וְהַמְקַבֵּל אֹתִי אֵינֶנּוּ מְקַבֵּל אֹתִי כִּי אִם־פְּנֵי שֹׁלְחִי׃ ");
INSERT INTO hebsg_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","וַיֹּאמֶר יוֹחָנָן אֵלָיו רַבִּי רָאִינוּ אִישׁ מְגָרֵשׁ רוּחוֹת רָעוֹת בְּשִׁמְךָ וַנִּכְלָא אֹתוֹ מִפְּעֻלָּתוֹ אַחֲרֵי אֲשֶׁר לֹא־הָלַךְ אַחֲרֵינוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","וַיֹּאמֶר יֵשׁוּעַ אַל־תִּכְלְאוּ אֹתוֹ כִּי אֵין אִישׁ אֲשֶׁר כֹּה עֹשֶׂה בִשְׁמִי נִפְלָאוֹת וְכֹה יָשׁוּב יְדַבֶּר־בִּי סָרָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","כִּי אִישׁ אֲשֶׁר אֵינֶנּוּ לְצָרֵינוּ לָנוּ הוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","וְכָל־הַנֹּתֶן לָכֶם בִּשְׁמִי כּוֹס מַיִם לִשְׁתּוֹת עֵקֶב אֲשֶׁר תָּכֹסּוּ עַל־הַמָּשִׁיחַ אָמֵן אֲנִי אֹמֵר לָכֶם כִּי לֹא־יֹאבַד שְׂכָרוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","וְכָל־הַנֹּתֵן מִכְשֹׁל לִפְנֵי אַחַד הַקְּטַנִּים הַמַּאֲמִינִים בִּי טוֹב לוֹ כִּי יִתָּלֶה פֶּלַח־רֶכֶב עַל־צַוָּארוֹ וְהֻשְׁלָךְ בַּיָּם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","וְאִם־יָדְךָ לְמִכְשׁוֹל לְךָ קַצֵּץ אֹתָה טוֹב לְךָ לָבֹא אֶל־הַחַיִּים קְטוּעַ־יָד מִהְיוֹת לְךָ שְׁתֵּי יָדַיִם וְלָבֹא אֶל־גֵּיהִנֹּם אֶל־הָאֵשׁ אֲשֶׁר עַד־עוֹלָם תּוּקָד׃ ");
INSERT INTO hebsg_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","אֲשֶׁר־שָׁם תּוֹלַעְתָּם לֹא תָמוּת וְאִשָּׁם לֹא תִכְבֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","וְאִם־רַגְלְךָ לְמִכְשׁוֹל לְךָ קַצֵּץ אֹתָהּ טוֹב לְךָ לָבֹא אֶל־הַחַיִּים קְטוּעַ־רֶגֶל מִהְיוֹת לְךָ שְׁתֵּי רַגְלַיִם וְלָבֹא אֶל־גֵּיהִנֹּם אֶל־הָאֵשׁ אֲשֶׁר לֹא תִכְבֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","אֲשֶׁר־שָׁם תּוֹלַעְתָּם לֹא תָמוּת וְאִשָּׁם לֹא תִכְבֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","וְאִם־עֵינְךָ תַּכְשִׁילְךָ נַקֵּר אֹתָהּ טוֹב לְךָ לָבֹא אֶל־מַלְכוּת הָאֱלֹהִים בְּעַיִן אַחַת מִהְיוֹת לְךָ שְׁתֵּי עֵינַיִם וּלְהָשְׁלַךְ אֶל־גֵּיהִנֹּם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","אֲשֶׁר־שָׁם תּוֹלַעְתָּם לֹא תָמוּת וְאִשָּׁם לֹא תִכְבֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","כִּי כָּל־אָדָם בָּאֵשׁ יִצָּרֵף כְּמוֹ כָל־קָרְבַּן בַּמֶּלַח יָמְלָח׃ ");
INSERT INTO hebsg_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","וְהַמֶּלַח טוֹב הוּא אַךְ אִם־יָפוּג טַעַם הַמֶּלַח בַּמֶּה תּוּכְלוּ לְתַקֵּן אֹתוֹ שִׁמְרוּ אֶת־הַמֶּלַח בְּתוֹכְכֶם וְאֶת־הַשָּׁלוֹם בֵּין אִישׁ וּבֵין אָחִיו׃ ");
INSERT INTO hebsg_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","וַיָּקָם וַיֵּלֶךְ מִשָּׁם אֶל־גְּבוּל יְהוּדָה וְאֶל־מֵעֵבֶר לַיַּרְדֵּן וְהָמוֹן רָב הוֹסִיפוּ לְהִקָּבֵץ אֵלָיו וַיּוֹרֶה לָהֶם כְּפִי מִשְׁפָּטוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","וַיִגְּשׁוּ אֵלָיו פְּרוּשִׁים לְנַסּוֹתוֹ וַיִּשְׁאָלֻהוּ אִם יֵשׁ בְּיַד אִישׁ לְשַׁלַּח אֶת־אִשְׁתּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","וַיַּעַן וַיֹּאמֶר אֲלֵיהֶם מַה־צִוָּה אֶתְכֶם מֹשֶׁה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","וַיֹּאמְרוּ מֹשֶׁה נָתַן לָנוּ לִכְתָּב־לָהּ סֵפֶר כְּרִיתֻת וּלְשַׁלְּחָהּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","וַיֹּאמֶר אֲלֵיהֶם יֵשׁוּעַ בַּעֲבוּר קְשִׁי לְבַבְכֶם כָּתַב לָכֶם אֶת־הַמִּצְוָה הַזֹּאת׃ ");
INSERT INTO hebsg_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","אֲבָל בִּימֵי הַבְּרִיאָה מִקֶּדֶם זָכָר וּנְקֵבָה עָשָׂה אֹתָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","עַל־כֵּן יַעֲזָב־אִישׁ אֶת־אָבִיו וְאֶת־אִמּוֹ וְדָבַק בְּאִשְׁתּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","וְהָיוּ שְׁנֵיהֶם לְבָשָׂר אֶחָד וְאִם־כֵּן אֵינָם עוֹד שְׁנַיִם כִּי אִם־בָּשָׂר אֶחָד׃ ");
INSERT INTO hebsg_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","לָכֵן אֵת אֲשֶׁר־חִבֵּר אֱלֹהִים אַל־יַפְרֵד אָדָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","וּבַבַּיִת שָׁאֲלוּ אֹתוֹ תַּלְמִידָיו שֵׁנִית עַל־הַדָּבָר הַזֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","וַיֹּאמֶר אֲלֵיהֶם אִישׁ כִּי־יְשַׁלַּח אֶת־אִשְׁתּוֹ וְנָשָׂא לוֹ אַחֶרֶת נֹאֵף הוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","וְאִשָּׁה כִּי־תֵצֵא מִבֵּית בַּעְלָהּ וְהָיְתָה לְאִישׁ אַחֵר נֹאֶפֶת הִיא׃ ");
INSERT INTO hebsg_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","וַיָּבִיאוּ אֵלָיו יְלָדִים לְבַעֲבוּר יָשִׂים אֶת־יָדָיו עֲלֵיהֶם וְתַלְמִידָיו גָּעֲרוּ בִּמְבִיאֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","וַיַּרְא יֵשׁוּעַ וַיִּחַר־לוֹ וַיֹּאמֶר אֲלֵיהֶם הַנִּיחוּ לַיְלָדִים לָבֹא אֵלַי וְאַל־תִּכְלְאוּ אֹתָם כִּי מֵאֵלֶּה מַלְכוּת הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","אָמֵן אֲנִי אֹמֵר לָכֶם מִי אֲשֶׁר־לֹא יְקַבֵּל אֶת־מַלְכוּת הָאֱלֹהִים כַּיֶּלֶד בֹּא לֹא־יָבֹא בָהּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","וַיְחַבְּקֵם בִּזְרֹעֹתָיו וְאֶת־יָדָיו שָׂם עֲלֵיהֶם וַיְבָרֲכֵם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","וַיְהִי בְּצֵאתוֹ לְדַרְכּוֹ וַיָּרָץ אֵלָיו אִישׁ וַיִּכְרַע לְפָנָיו לֵאמֹר רַבִּי הַטּוֹב מַה־לִּי לַעֲשׂוֹת לָרֶשֶׁת חַיֵּי עוֹלָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","וַיֹּאמֶר אֵלָיו יֵשׁוּעַ לָמָּה־זֶּה תִּקְרָא לִי טוֹב אֵין טוֹב כִּי אִם־אֶחָד הוּא הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","וְאַתָּה יָדַעְתָּ אֶת־הַמִּצְוֹת לֹא תִּרְצָח לֹא תִּנְאָף לֹא תִּגְנֹב לֹא־תַעֲנֶה עֵד שָׁקֶר לֹא תַעֲשֹׁק כַּבֵּד אֶת־אָבִיךָ וְאֶת־אִמֶּךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","וַיֹּאמֶר אֵלָיו רַבִּי אֶת־כָּל־אֵלֶּה שָׁמַרְתִּי מִנְּעוּרָי׃ ");
INSERT INTO hebsg_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","וַיִּרְאֵהוּ יֵשׁוּעַ וַיֶּאֱהָבֵהוּ וַיֹּאמֶר אֵלָיו עוֹד אַחַת אַתָּה חָסֵר לֵךְ מְכֹר אֶת־כָּל־אֲשֶׁר־לְךָ וְתֵן לַעֲנִיִּים וְהָיָה־לְךָ אוֹצָר בַּשָּׁמָיִם וּבֹא שָׂא אֶת־הַצְּלָב וְלֵךְ אַחֲרָי׃ ");
INSERT INTO hebsg_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","וַיִּפְּלוּ פָנָיו עַל־הַדָּבָר הַזֶּה וַיִּתְעַצֵּב אֶל־לִבּוֹ וַיֵּלֶךְ־לוֹ כִּי־נְכָסִים רַבִּים הָיוּ לוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","וַיַּבֵּט יֵשׁוּעַ מִסָּבִיב וַיֹּאמֶר אֶל־תַּלְמִידָיו מַה־קָּשֶׁה לְבַעֲלֵי נְכָסִים לָבֹא אֶל־מַלְכוּת הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","וַיִּשְׁתּוֹמְמוּ תַלְמִידָיו עַל־דְּבָרָיו וַיּוֹסֶף יֵשׁוּעַ וַיַּעַן וַיֹּאמֶר אֲלֵיהֶם בָּנַי מַה־כָּבֵד לַבֹּטְחִים עַל־חֵילָם לָבֹא אֶל־מַלְכוּת הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","נָקֵל לַגָּמָל לַעֲבֹר דֶּרֶךְ חֻר הַמַּחַט מִבֹּא עָשִׁיר אֶל־מַלְכוּת הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","וַיּוֹסִיפוּ לְהִשְׁתּוֹמֵם יֶתֶר מְאֹד וַיֹּאמְרוּ אִישׁ אֶל־אָחִיו וּמִי אֵפוֹא יוּכַל לְהִוָּשֵׁעַ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","וַיַּבֶּט־בָּם יֵשׁוּעַ וַיֹּאמַר מִבְּנֵי אָדָם יִפָּלֵא הַדָּבָר אַךְ לֹא מֵאֱלֹהִים כִּי מֵאֱלֹהִים לֹא יִפָּלֵא כָּל־דָּבָר׃ ");
INSERT INTO hebsg_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","וַיָּחֶל פֶּטְרוֹס וַיֹּאמֶר אֵלָיו הִנֵּה אֲנַחְנוּ עָזַבְנוּ אֶת־כֹּל וַנֵּלֶךְ אַחֲרֶיךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","וַיֹּאמֶר יֵשׁוּעַ אָמֵן אֲנִי אֹמֵר לָכֶם כִּי אֵין אִישׁ אֲשֶׁר עָזַב בַּיִת אוֹ אַחִים אוֹ אֲחָיוֹת אוֹ אָב אוֹ אֵם אוֹ אֶת־אִשְׁתּוֹ אוֹ בָנִים אוֹ שָׂדוֹת לְמַעַן הַבְּשׂוֹרָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","אֲשֶׁר לֹא יִמְצָא לְרַגְלֵי הָרְדִיפוֹת בָּעֵת הַזֹּאת מֵאָה שְׁעָרִים בָּתִּים וְאַחִים וַאֲחָיוֹת וְאִמּוֹת וּבָנִים וְשָׂדוֹת וְלֶעָתִיד לָבֹא חַיֵּי עוֹלָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","וְרַבִּים הֵם הָרִאשֹׁנִים אֲשֶׁר יִהְיוּ אַחֲרֹנִים וְהָאַחֲרֹנִים רִאשֹׁנִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","וּבִהְיוֹתָם בַּדֶּרֶךְ לַעֲלוֹת יְרוּשָׁלַיְמָה וַיֵּלֶךְ יֵשׁוּעַ לִפְנֵיהֶם וְהֵם הָלְכוּ אַחֲרָיו בְּמָגוֹר וָפָחַד וַיִּקַּח אֵלָיו שֵׁנִית אֶת־שְׁנֵים הֶעָשָׂר וַיָּחֶל לְהַגִּיד לָהֶם אֶת־אֲשֶׁר יִקְרֶה אֹתוֹ לֵאמֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","הִנֵּה אֲנַחְנוּ עֹלִים יְרוּשָׁלַיְמָה וּבֶן־הָאָדָם יִסָּגֵר בִּידֵי רָאשֵׁי הַכֹּהֲנִים וְהַסּוֹפְרִים וְהִרְשִׁיעוּ אֹתוֹ לָמוּת וְנָתוֹן אֹתוֹ בִּידֵי הַגּוֹיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","וְהֵם יְהָתֵלּוּ בוֹ וְיָרְקוּ בְּפָנָיו וְיַכֻּהוּ בַּשֹּׁטִים וִימִיתֻהוּ וּבַיּוֹם הַשְּׁלִישִׁי יָקוּם וְיֶחִי׃ ");
INSERT INTO hebsg_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","וַיִּגְּשׁוּ אֵלָיו יַעֲקֹב וְיוֹחָנָן בְּנֵי־זַבְדִּי לֵאמֹר רַבֵּנוּ חֲפֵצִים אֲנַחְנוּ כִּי־תַעֲשֶׂה לָּנוּ אֵת אֲשֶׁר־נִשְׁאַל מִמֶּךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","וַיֹּאמֶר אֲלֵיהֶם מַה־חֶפְצְכֶם כִּי־אֶעֱשֶׂה לָכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","וַיֹּאמְרוּ אֵלָיו תְּנָה־לָּנוּ לָשֶׁבֶת אֶחָד לִימִינְךָ וְאֶחָד לִשְׂמֹלְךָ בִּכְבוֹדֶךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","וַיֹּאמֶר אֲלֵיהֶם יֵשׁוּעַ לֹא יְדַעְתֶּם אֵת אֲשֶׁר תִּשְׁאָלוּן הֲתוּכְלוּ לִשְׁתּוֹת אֶת־הַכּוֹס אֲשֶׁר אֲנִי אֶשְׁתֶּה וּלְהִטָּבֵל בַּטְּבִילָה אֲשֶׁר אִטָּבֵל אָנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","וַיֹּאמְרוּ אֵלָיו נוּכָל וַיֹּאמֶר אֲלֵיהֶם יֵשׁוּעַ אֶת־הַכּוֹס אֲשֶׁר אֶשְׁתֶּה תִּשְׁתּוּ וּבַטְּבִילָה אֲשֶׁר אִטָּבֵל תִּטָּבֵלוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","אֲבָל לָשֶׁבֶת לִימִינִי וְלִשְׂמֹאלִי אֵין בְּיָדִי לָתֵת כִּי אִם־יִנָּתֵן לַאֲשֶׁר נָכוֹן לָהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","וְהָעֲשָׂרָה בְּשָׁמְעָם זֹאת חָרָה אַפָּם בְּיַעֲקֹב וְיוֹחָנָן׃ ");
INSERT INTO hebsg_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","וַיִּקְרָא יֵשׁוּעַ וַיֹּאמֶר אֲלֵיהֶם הֵן יְדַעְתֶּם כִּי הַנִּבְחָרִים לִמְשֹׁל בַּגּוֹיִם מֹשְׁלִים בָּם כְּשָׂרִים בַּעֲבָדִים וּגְדוֹלֵיהֶם שֹׁלְטִים עֲלֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","וְלֹא יִהְיֶה כֵן בְּקִרְבְּכֶם כִּי אִם־מִי הֶחָפֵץ לִהְיוֹת גָּדוֹל בָּכֶם יִהְיֶה לָכֶם לִמְשָׁרֵת׃ ");
INSERT INTO hebsg_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","וּמִי מִכֶּם הֶחָפֵץ לִהְיוֹת לְרֹאשׁ יִהְיֶה עֶבֶד לַכֹּל׃ ");
INSERT INTO hebsg_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","כִּי גַּם בֶּן־הָאָדָם לֹא בָא לְמַעַן יְשָׁרְתֻהוּ אֲחֵרִים כִּי אִם־לְשָׁרֵת וְלָתֵת אֶת־נַפְשׁוֹ כֹּפֶר בְּעַד־רַבִּים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","וַיָּבֹאוּ אֶל־יְרִיחוֹ וַיְהִי בְּצֵאתוֹ מִן־הָעִיר וְתַלְמִידָיו וַהֲמוֹן עַם־רָב אַחֲרָיו וְהִנֵּה בַּרְטִימַי בֶּן־טִימַי עִוֵּר מְבַקֵּשׁ נְדָבוֹת יֹשֵׁב עַל־יַד הַדָּרֶךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","וּבְשָׁמְעוֹ כִּי יֵשׁוּעַ הַנָּצְרִי עֹבֵר שָׁם וַיָּחֶל לִצְעֹק וְלִקְרֹא רַחֶם־נָא עָלַי יֵשׁוּעַ בֶּן־דָּוִד׃ ");
INSERT INTO hebsg_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","וַיִּגְעֲרוּ־בוֹ רַבִּים לְהַחְשׁוֹתוֹ וְהוּא קָרָא בְּיֶתֶר אֹמֶץ לֵאמֹר בֶּן־דָּוִד רַחֶם־נָא עָלָי׃ ");
INSERT INTO hebsg_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","וַיַּעֲמֹד יֵשׁוּעַ וַיֹּאמֶר קִרְאוּ־לוֹ וַיִּקְרְאוּ לָעִוֵּר וַיֹּאמְרוּ אֵלָיו חֲזַק קוּם־לָךְ הִנֵּה הוּא קֹרְאֶךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","וַיַּשְׁלֵךְ אֶת־בִּגְדוֹ מֵעָלָיו וַיָּקָם וַיָּבֹא לִפְנֵי יֵשׁוּעַ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","וַיַּעַן יֵשׁוּעַ וַיֹּאמֶר אֵלָיו מַה־תְּבַקֵּשׁ מֶנִּי לַעֲשׂוֹת לָךְ וַיֹּאמֶר הָעִוֵּר רִבּוֹנִי לְהָשִׁיב לִי אוֹר עֵינָי׃ ");
INSERT INTO hebsg_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","וַיֹּאמֶר אֵלָיו יֵשׁוּעַ לֵךְ אֱמוּנָתְךָ הוֹשִׁיעָה לָּךְ וְאוֹר עֵינָיו שָׁב אֵלָיו כְּרֶגַע וַיֵּלֶךְ אַחֲרָיו בַּדָּרֶךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","וַיְהִי כַּאֲשֶׁר הִקְרִיבוּ לָבֹא יְרוּשָׁלַיְמָה אֵצֶל בֵּית־פַּגֵּי וּבֵית־עַנְיָה בְּהַר הַזֵּיתִים וַיִּשְׁלַח שְׁנַיִם מִתַּלְמִידָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","וַיֹּאמֶר אֲלֵיהֶם לְכוּ אֶל־הַכְּפָר אֲשֶׁר מִנֶּגֶד וְהָיָה כְּבֹאֲכֶם שָׁמָּה תִּמְצְאוּ לִפְנֵיכֶם עַיִר אָסוּר אֲשֶׁר לֹא־רָכָב עָלָיו אִישׁ הַתִּירוּ אֹתוֹ וַהֲבִיאֻהוּ אֵלָי׃ ");
INSERT INTO hebsg_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","וְכִי־יֹאמַר אֲלֵיכֶם אִישׁ לָמָּה תַעֲשׂוּ כָזֹאת וַאֲמַרְתֶּם אֹתוֹ יִעֵד הָאָדוֹן לְחֶפְצוֹ וְאָז יָחִישׁ לְשָׁלְחוֹ הֵנָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","וַיֵּלְכוּ וַיִּמְצְאוּ אֶת־הָעַיִר אָסוּר מִחוּץ לַשַּׁעַר עַל־פֶּתַח עֵינָיִם וַיַּתִּירוּ אֹתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","וַאֲנָשִׁים מִן־הָעֹמְדִים שָׁם אָמְרוּ אֲלֵיהֶם לָמָּה תַעֲשׂוּ כָזֹאת כִּי תַתִּירוּ אֶת־הָעָיִר׃ ");
INSERT INTO hebsg_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","וַיַּעֲנוּ אֹתָם כַּאֲשֶׁר צִוָּה יֵשׁוּעַ וַיַּנִּיחוּ לָהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","וַיָּבִיאוּ אֶת־הָעַיִר אֶל־יֵשׁוּעַ וַיָּשִׂימוּ עָלָיו אֶת־בִּגְדֵיהֶם וְהוּא יָשַׁב עֲלֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","וְרַבִּים פָּרְשׂוּ אֶת־בִּגְדֵיהֶם עַל־פְּנֵי הַדָּרֶךְ וַאֲנָשִׁים אֲחֵרִים שָׁטְחוּ לְרַגְלָיו זְמֹרוֹת עֵצִים אֲשֶׁר כָּרְתוּ בַּשָּׂדֶה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","וְהַהֹלְכִים לְפָנָיו עִם־הַבָּאִים אַחֲרָיו עָנוּ וְקָרְאוּ הוֹשַׁע־נָא בָּרוּךְ הַבָּא בְּשֵׁם יְהוָֹה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","בְּרוּכָה מַלְכוּת דָּוִד אָבִינוּ הַבָּאָה בְּשֵׁם יְהוָֹה הוֹשַׁע־נָא בִּשְׁמֵי מָרוֹם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","וַיָּבֹא יֵשׁוּעַ יְרוּשָׁלָיִם אֶל־בֵּית הַמִּקְדָּשׁ וַיַּרְא אֶת־כָּל־אֲשֶׁר שָׁם מִסָּבִיב וְלִפְנוֹת־עֶרֶב יָצָא אֶל־בֵּית־עַנְיָה עִם־שְׁנֵים הֶעָשָׂר׃ ");
INSERT INTO hebsg_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","וַיְהִי מִמָּחֳרָת בְּצֵאתָם מִבֵּית־עַנְיָה וַיִּרְעָב׃ ");
INSERT INTO hebsg_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","וַיַּרְא תְּאֵנָה אַחַת מֵרָחוֹק אֲשֶׁר הוֹצִיאָה עָלִים וַיָּבֹא לִרְאוֹת אִם־יִמְצָא בָהּ פְּרִי־מַאֲכָל וַיִּקְרַב אֵלֶיהָ וְלֹא־מָצָא בָהּ זוּלָתִי עָלִים לְבַדָּם כִּי עֵת הַתְּאֵנִים עוֹד לֹא הִגִּיעָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","וַיַּעַן יֵשׁוּעַ וַיֹּאמֶר לָהּ לֹא יֹאכַל עוֹד אִישׁ מִפִּרְיֵךְ מֵעַתָּה וְעַד־עוֹלָם וְתַלְמִידָיו שָׁמְעוּ אֶת־הַדָּבָר׃ ");
INSERT INTO hebsg_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","וַיָּבֹאוּ יְרוּשָׁלַיִם וַיֵּלֶךְ יֵשׁוּעַ אֶל־בֵּית הַמִּקְדָּשׁ וַיָּחֶל לְגָרֵשׁ מִשָּׁם אֶת־הַמּוֹכְרִים וְאֶת־הַקּוֹנִים וְאֶת־שֻׁלְחֲנוֹת מַחֲלִיפֵי הַכֶּסֶף הָפַךְ וְאֶת־מוֹשְׁבוֹת מֹכְרֵי הַיּוֹנִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","וְלֹא נָתַן לְאִישׁ לְהַעֲבִיר כֵּלִים דֶּרֶךְ הַמִּקְדָּשׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","וַיּוֹרֶה לָהֶם לֵאמֹר הֲלֹא כָתוּב כִּי בֵיתִי בֵּית־תְּפִלָּה יִקָּרֵא לְכָל־הָעַמִּים וְאַתֶּם עֲשִׂיתֶם אֹתוֹ לִמְעָרַת פָּרִצִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","וְרָאשֵׁי הַכֹּהֲנִים וְהַסּוֹפְרִים שָׁמְעוּ וַיִּתְנַכְּלוּ לְהַאֲבִידוֹ כִּי יָרְאוּ מִפָּנָיו אַחֲרֵי אֲשֶׁר כָּל־הָעָם הִתְפַּלְּאוּ עַל־תּוֹרָתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","וְיוֹם יוֹם כְּבֹא הָעָרֶב יָצָא אֶל־מִחוּץ לָעִיר׃ ");
INSERT INTO hebsg_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","וַיְהִי בַּבֹּקֶר וַיַּעַבְרוּ וַיִּרְאוּ אֶת־הַתְּאֵנָה כִּי יָבְשָׁה מֵעָנָף וְעַד־שֹׁרֶשׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","וַיִּזְכֹּר פֶּטְרוֹס וַיֹּאמֶר אֵלָיו רַבִּי הִנֵּה יָבְשָׁה הַתְּאֵנָה אֲשֶׁר אֵרָרְתָּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","וַיַּעַן יֵשׁוּעַ וַיֹּאמֶר אֲלֵיהֶם רְעוּ אֱמוּנָה בֵאלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","אָמֵן אֲנִי אֹמֵר לָכֶם כָּל־אִישׁ אֲשֶׁר יֹאמַר אֶל־הָהָר הַזֶּה הִנָּשֵׂא וְהִתְנַפֵּל אֶל־תּוֹךְ הַיָּם וְלֹא יִפָּלֵג בְּלִבּוֹ כִּי אִם־יַאֲמִין כִּי יְהִי כַּאֲשֶׁר אָמָר כֵּן יִהְיֶה־לּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","עַל־כֵּן אֲנִי אֹמֵר לָכֶם עַל־כָּל־אֲשֶׁר תִּשְׁאֲלוּ וְתִתְפַּלָּלוּ בִּטְחוּ כִּי יֵעָשֶׂה לָכֶם וְכֵן יֵעָשׂ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","וְכִי־תַעַמְדוּ לְהִתְפַּלֵּל סִלְחוּ לְכָל־אִישׁ אֵת אֲשֶׁר חָטָא לָכֶם לְמַעַן גַּם־אֲבִיכֶם בַּשָּׁמַיִם יִסְלַח לָכֶם אֶת־חַטֹּאתֵיכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","וְאִם־לֹא תִסְלְחוּ אַתֶּם גַּם־אֲבִיכֶם שֶׁבַּשָׁמַיִם לֹא־יִסְלַח לָכֶם אֶת־חַטֹּאתֵיכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","וַיָּשׁוּבוּ וַיָּבֹאוּ יְרוּשָׁלָיְמָה וַיְהִי הוּא מִתְהַלֵּךְ בַּמִּקְדָּשׁ וַיָּבֹאוּ אֵלָיו רָאשֵׁי הַכֹּהֲנִים וְהַסּוֹפְרִים וְהַזְּקֵנִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","וַיֹּאמְרוּ אֵלָיו בְּאֵיזֶה רִשְׁיוֹן אַתָּה עֹשֶׂה אֵלֶּה וּמִי־נָתַן לְךָ הָרִשְׁיוֹן הַזֶּה לַעֲשׂוֹת אֵלֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","וַיֹּאמֶר יֵשׁוּעַ אֲלֵיהֶם אֶשְׁאַל מִכֶּם דָּבָר וּתְנוּ לִי מַעֲנֶה וְאָז אַגִּיד לָכֶם בְּאֵיזֶה רִשְׁיוֹן אֲנִי עֹשֶׂה אֵלֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","הַגִּידוּ לִי טְבִילַת יוֹחָנָן מִפִּי־מִי הָיְתָה מִצְוָתָהּ מִן־הַשָּׁמַיִם אוֹ מִבְּנֵי־אָדָם תְּנוּ לִי מַעֲנֶה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","וַיְהִי הֵם שֹׁקְלִים בְּדַעְתָּם לֵאמֹר אִם־נֹאמַר מִן־הַשָּׁמַיִם יֹאמַר וּמַדּוּעַ לֹא הֶאֱמַנְתֶּם לוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","וְאִם־נֹאמַר מִבְּנֵי אָדָם יְרֵאִים אֲנַחְנוּ אֶת־הָעָם כִּי־כֻלָּם חִשְּׁבוּ אֶת־יוֹחָנָן לְנָבִיא נֶאֱמָן׃ ");
INSERT INTO hebsg_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","וַיַּעֲנוּ אֶת־יֵשׁוּעַ וַיֹּאמְרוּ לֹא יָדָעְנוּ וַיֹּאמֶר אֲלֵיהֶם יֵשׁוּעַ גַּם־אֲנִי לֹא אַגִּיד לָכֶם בְּאֵיזֶה רִשְׁיוֹן אֲנִי עֹשֶׂה אֵלֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","וַיִּפְתַּח בְּמָשָׁל פִּיו וַיֹּאמֶר אֲלֵיהֶם אִישׁ נָטַע כֶּרֶם וַיְעַזְּקֵהוּ מִסָּבִיב וְיֶקֶב חָצֵב בּוֹ וַיִּבֶן מִגְדָּל בְּתוֹכוֹ וְנָתַן אֹתוֹ לַנֹּטְרִים וְהָלַךְ בַּדֶּרֶךְ לְמֵרָחוֹק׃ ");
INSERT INTO hebsg_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","וּלְעֵת הַבָּצִיר שָׁלַח אֶת־עַבְדּוֹ לָקַחַת מִידֵי הַנֹּטְרִים מִפְּרִי הַכָּרֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","וַיִּתְפְּשׂוּ בוֹ וַיַּכֻּהוּ וַיְשַׁלְּחוּ אֹתוֹ רֵיקָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","וַיּוֹסֶף וַיִּשְׁלַח אֲלֵיהֶם עֶבֶד אַחֵר וְאֹתוֹ סָקְלוּ בָאֲבָנִים וַיִּפְצְעוּ אֶת־רֹאשׁוֹ וַיְשַׁלְּחֻהוּ בְּחֶרְפָּה גְדוֹלָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","וַיִּשְׁלַח אֲלֵיהֶם עוֹד אֶחָד וְאֹתוֹ הָרָגוּ וְכֵן אֲחֵרִים רַבִּים מֵהֶם אֲשֶׁר הִכּוּ וּמֵהֶם אֲשֶׁר הָרָגוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","וַיְהִי־לוֹ עוֹד בֵּן יָחִיד אֲשֶׁר אָהֵב וְאֹתוֹ שָׁלַח אֲלֵיהֶם אַחֲרֵי כֻלָּם כִּי אָמַר אֶת־בְּנִי יִירָאוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","וְהַנֹּטְרִים הָהֵם רָאוּ וַיֹּאמְרוּ אִישׁ אֶל־אָחִיו הִנֵּה הַיּוֹרֵשׁ לְכוּ וְנַהַרְגֵהוּ וְלָנוּ תִסֹּב הַנַּחֲלָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","וַיִּתְפְּשׂוּ־בוֹ וַיַּהַרְגֻהוּ וַיַּשְׁלִיכֻהוּ אֶל־מִחוּץ לַכֶּרֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","וּמָה אֵפוֹא יַעֲשֶׂה בַּעַל הַכָּרֶם הוּא יָבֹא וְהֶאֱבִיד אֶת־עֹבְדֵי הָאֲדָמָה וְאֶת־כַּרְמוֹ יִתֵּן בִּידֵי אֲחֵרִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","הֲלֹא קְרָאתֶם אֶת־הַכָּתוּב הַהוּא אֶבֶן מָאֲסוּ הַבּוֹנִים הָיְתָה לְרֹאשׁ פִּנָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","מֵאֵת יְהוָֹה הָיְתָה זֹאת הִיא נִפְלָאת בְּעֵינֵינוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","וַיְבַקְשׁוּ לְתָפְשׂוֹ אֶפֶס כִּי יָרְאוּ מִפְּנֵי הָעָם בַּאֲשֶׁר הֵבִינוּ כִּי עֲלֵיהֶם דִּבֶּר אֶת־הַמָּשָׁל הַזֶּה וַיַּעַזְבוּ אֹתוֹ וַיֵּלְכוּ לָהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","וַיִּשְׁלְחוּ אֵלָיו אֲנָשִׁים מִן־הַפְּרוּשִׁים וּמֵאַנְשֵׁי הוֹרְדוֹס לְצֹדֵד אֹתוֹ בִּדְבָרָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","וַיָּבֹאוּ וַיֹּאמְרוּ אֵלָיו רַבֵּנוּ יָדַעְנוּ כִּי־אִישׁ נֶאֱמָן אַתָּה וְלֹא־תָגוּר מִפְּנֵי אִישׁ כִּי לֹא תִשָּׂא פְּנֵי גֶבֶר וְאֶת־דֶּרֶךְ אֱלֹהִים תּוֹרֶה בְּמֵישָׁרִים הֲנָכוֹן הוּא לָתֵת מַס לַקֵּיסַר אִם־אַיִן הֲנִתֵּן אוֹ לֹא נִתֵּן׃ ");
INSERT INTO hebsg_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","וְהוּא בִּרְאֹתוֹ אֶת־חֲנֻפָתָם אָמַר אֲלֵיהֶם לָמָּה־זֶּה תְנַסּוּנִי הָבִיאוּ לִי דִּינַר אֶחָד וְאֶרְאֶה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","וַיָּבִיאוּ וַיֹּאמֶר אֲלֵיהֶם לְמִי הַתְּמוּנָה וְהַכְּתֹבֶת הָהֵנָּה וַיֹּאמְרוּ לַקֵּיסָר׃ ");
INSERT INTO hebsg_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","וַיֹּאמֶר יֵשׁוּעַ אֲלֵיהֶם הָבוּ אֵפוֹא לַקֵּיסַר אֵת אֲשֶׁר לַקֵּיסַר וְלֵאלֹהִים אֵת אֲשֶׁר לֵאלֹהִים וַיִּתְמְהוּ עָלָיו עַד־מְאֹד׃ ");
INSERT INTO hebsg_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","וַיָּבֹאוּ אֵלָיו צַדּוּקִים הָאֹמְרִים כִּי־אֵין תְּקוּמָה לַמֵּתִים וַיִּשְׁאָלֻהוּ לֵאמֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","רַבֵּנוּ הִנֵּה מֹשֶׁה כָּתַב לָנוּ כִּי יָמוּת אֶחָד מִשְּׁנֵי אַחִים וְעָזַב אִשָּׁה וּבֵן אֵין לוֹ יְבָמָהּ יָבֹא עָלֶיהָ וְהֵקִים זֶרַע עַל־שֵׁם אָחִיו׃ ");
INSERT INTO hebsg_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","וְאִתָּנוּ הָיוּ שִׁבְעָה אַחִים הָרִאשׁוֹן מֵהֶם לָקַח לוֹ אִשָּׁה וַיָּמָת וְלֹא־הִשְׁאִיר זֶרַע אַחֲרָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","וְהַשֵּׁנִי יִבֵּם אֹתָהּ וַיָּמָת גַּם־הוּא לֹא בָנִים וּכְמוֹ־כֵן הַשְּׁלִישִׁי׃ ");
INSERT INTO hebsg_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","עַד אֲשֶׁר כָּל־הַשִּׁבְעָה בְּעָלוּהָ וַיָּמוּתוּ וְזֶרַע לֹא־הִשְׁאִירוּ אַחֲרֵיהֶם וְאַחֲרֵי כֻלָּם מֵתָה גַּם־הָאִשָּׁה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","וְעַתָּה לְמִי מֵהֶם תִּהְיֶה לְאִשָּׁה בַתְּקוּמָה אַחֲרֵי אֲשֶׁר הָיְתָה אֵשֶׁת כָּל־הַשִּׁבְעָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","וַיֹּאמֶר אֲלֵיהֶם יֵשׁוּעַ הוּא הַדָּבָר אֲשֶׁר שְׁגִיתֶם בּוֹ כִּי אֶת־הַתּוֹרָה לֹא יְדַעְתֶּם וְלֹא אֶת־נִפְלְאוֹת אֵל׃ ");
INSERT INTO hebsg_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","כִּי בִתְקוּמָתָם מִן־הַמֵּתִים לֹא יִבְעֲלוּ וְלֹא תִבָּעַלְנָה כִּי אִם־יִהְיוּ כְּמַלְאֲכֵי הַשָּׁמָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","וְעַל־דְּבַר הַמֵּתִים כִּי־יָקִיצוּ הֲלֹא קְרָאתֶם בְּסֵפֶר מֹשֶׁה כַּאֲשֶׁר דִּבֶּר אֵלָיו הָאֱלֹהִים בַּסְּנֶה לֵאמֹר אָנֹכִי אֱלֹהֵי אַבְרָהָם וֵאלֹהֵי יִצְחָק וֵאלֹהֵי יַעֲקֹב׃ ");
INSERT INTO hebsg_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","וְהוּא אֵינֶנּוּ אֱלֹהֵי הַמֵּתִים כִּי אִם־אֱלֹהֵי הַחַיִּים שְׁגִיתֶם הַרְבֵּה מְאֹד׃ ");
INSERT INTO hebsg_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","וְאֶחָד מִן־הַסּוֹפְרִים בָּא וַיִּשְׁמַע אֹתָם נִדְבָּרִים יַחְדָּו וּבִרְאֹתוֹ כִּי הֵיטֵב עָנָה עַל־דִּבְרֵיהֶם וַיִּשְׁאָלֵהוּ מָה־רֵאשִׁית כָּל־הַמִּצְוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","וַיַּעַן יֵשׁוּעַ הָרִאשֹׁנָה הֲלֹא הִיא שְׁמַע יִשְׂרָאֵל יְהוָֹה אֱלֹהֵינוּ יְהוָֹה אֶחָד׃ ");
INSERT INTO hebsg_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","וְאָהַבְתָּ אֵת יְהוָֹה אֱלֹהֶיךָ בְּכָל־לְבָבְךָ וּבְכָל־נַפְשְׁךָ וּבְכָל־מַדָּעֲךָ וּבְכָל־מְאֹדֶךָ זֹאת הִיא הַמִּצְוָה הָרִאשֹׁנָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","וְהַשְּׁנִיָּה הֲלֹא הִיא וְאָהַבְתָּ לְרֵעֲךָ כָּמוֹךָ וְאֵין מִצְוָה גְדוֹלָה מִשְׁתַּיִם אֵלֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","וַיֹּאמֶר אֵלָיו הַסּוֹפֵר אָמֵן רַבִּי אֱמֶת דִּבַּרְתָּ כִּי אֶחָד הוּא וְאֵין עוֹד מִלְּבַדּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","וּלְאַהֲבָה אֹתוֹ בְּכָל־לֵב וּבְכָל־מַדָּע וּבְכָל־מְאֹד וְלֶאֱהֹב אִישׁ אֶת־רֵעֵהוּ כְּנַפְשׁוֹ הִיא גְדֹלָה מִכָּל־עֹלָה וָזָבַח׃ ");
INSERT INTO hebsg_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","וַיַּרְא יֵשׁוּעַ כִּי־הִשְׂכִּיל לַעֲנוֹת אֹתוֹ וַיֹּאמֶר אֵלָיו הִנְּךָ לֹא־רָחוֹק מִמַּלְכוּת אֱלֹהִים וְלֹא־הֵעֵז עוֹד אִישׁ לְהִתְוַכַּח עִמּוֹ בִּדְּבָרִים מֵהַיּוֹם הַהוּא וָמָעְלָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","וַיְהִי בְּהוֹרֹת יֵשׁוּעַ בַּמִּקְדָּשׁ וַיַּעַן וַיֹּאמַר אֵיךְ יֹאמְרוּ הַסּוֹפְרִים כִּי הַמָּשִׁיחַ בֶּן־דָּוִד הוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","וְדָוִד הֲלֹא הוּא אָמַר בְּרוּחַ הַקֹּדֶשׁ נְאֻם יְהוָֹה לַאדֹנִי שֵׁב לִימִינִי עַד־אָשִׁית אֹיְבֶיךָ הֲדֹם לְרַגְלֶיךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","וְאִם־דָּוִד קֹרֵא לוֹ אָדוֹן אֵיךְ הוּא בְּנוֹ וְרֹב הָעָם הִקְשִׁיבוּ לִדְבָרָיו בְּעֹנֶג־רָב׃ ");
INSERT INTO hebsg_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","וַיּוֹסֶף לְלַמֵּד וַיֹּאמֶר הִשָּׁמְרוּ לָכֶם מִן־הַסּוֹפְרִים הַמִּתְעַנְּגִים עַל־לֶכְתָּם מְלֻבָּשִׁים מְעִיל וְעַל־שְׁאֵלַת שָׁלוֹם לָהֶם בַּשְּׁוָקִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","עַל־הַמּוֹשָׁבוֹת הָרִאשֹׁנִים בְּבָתֵּי־הַכְּנֵסֶת וְעַל־הַמְּקֹמוֹת הַנִּכְבָּדִים בְּבָתֵּי הַמִּשְׁתֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","הָאֹכְלִים אֶת־בָּתֵּי אַלְמָנוֹת וּלְמַרְאֵה עַיִן יַרְבּוּ תְפִלָּה אֵלֶּה הֵם אֲשֶׁר יִנָּטֶה עֲלֵיהֶם קַו הַמִּשְׁפָּט פִּי שְׁנָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","וְכַאֲשֶׁר יֵשׁוּעַ יָשַׁב לְנֹכַח אֲרוֹן הָאוֹצָר וַיַּרְא אֶת־הָעָם נֹתְנִים בּוֹ מָעוֹת וְרַבִּים עֲשִׁירִים נָתְנוּ הַרְבֵּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","וְאִשָּׁה אַלְמָנָה עֲנִיָּה בָּאָה וַתָּשָׂם שָׁם שְׁתֵּי פְרוּטוֹת הֵן רֶבַע אִסָּר׃ ");
INSERT INTO hebsg_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","וַיִּקְרָא אֶל־תַּלְמִידָיו וַיֹּאמֶר אֲלֵיהֶם אָמֵן אֲנִי אֹמֵר לָכֶם הָאַלְמָנָה הָעֲנִיָּה הַזֹּאת הִרְבְּתָה לָתֵת מִכָּל־הַנֹּתְנִים פֹּה אֶל־אֲרוֹן הָאוֹצָר׃ ");
INSERT INTO hebsg_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","כִּי כֻלָּם נָתְנוּ מִמּוֹתָרָם וְהִיא מִמַּחְסֹרָהּ נָתְנָה אֶת־כָּל־אֲשֶׁר־לָהּ אֵת כָּל־מִחְיָתָהּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","וַיֵּצֵא מִן־הַהֵיכָל וַיֹּאמֶר אֵלָיו אֶחָד מִתַּלְמִידָיו רַבִּי רְאֵה אֶת־הָאֲבָנִים וְאֶת־הַבִּנְיָנִים הָאֵלֶּה מַה־נֶּהְדָּרוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","וַיֹּאמֶר אֵלָיו יֵשׁוּעַ הֲרָאִיתָ אֶת־הַבִּנְיָנִים הַנִּשְׂגָּבִים הָאֵלֶּה כֻּלָּם יֵהָרֵסוּ לֹא־תִשָּׁאֵר פֹּה אֶבֶן עַל־אָבֶן׃ ");
INSERT INTO hebsg_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","וּבְשִׁבְתּוֹ עַל־הַר הַזֵּיתִים לְנֹכַח הַהֵיכָל וַיִּשְׁאָלֻהוּ פֶטְרוֹס וְיַעֲקֹב וְיוֹחָנָן וְאַנְדְּרַי בִּהְיוֹתָם אִתּוֹ לְבַדָּם לֵאמֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","הַגֶּד־נָא לָנוּ מָתַי תִּקְרֶאנָה אֵלֶּה וּמַה־הוּא הָאוֹת לַמּוֹעֵד הַהוּא כִּי כָל־אֵלֶּה תִּכְלֶינָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","וַיָּחֶל יֵשׁוּעַ לְדַבֵּר אֲלֵיהֶם לֵאמֹר הִשָּׁמְרוּ לָכֶם פֶּן־יַתְעֶה אֶתְכֶם אִישׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","כִּי רַבִּים יָבֹאוּ בִשְׁמִי וְאָמְרוּ כִּי אֲנִי הוּא וְהִתְעוּ אֶת־רַבִּים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","וְכִי־תִשְׁמְעוּ קְרָבוֹת וּשְׁמֻעוֹת מִלְחָמָה אַל־תִּבָּהֵלוּ כָּל־אֵלֶּה תִּהְיֶינָה וְעוֹד לֹא־זֶה הַקֵּץ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","כִּי־יָקוּם גּוֹי עַל־גּוֹי וּמַמְלָכָה עַל־מַמְלָכָה וְרַעַשׁ עַל־רַעַשׁ יָבֹא וְרָעָב מְהוּמוֹת וְכָל־אֵלֶּה רַק רֵאשִׁית הַחֲבָלִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","וְאַתֶּם הִשָּׁמְרוּ בְנַפְשׁוֹתֵיכֶם כִּי־יַסְגִּירוּ אֶתְכֶם בִּידֵי הַסַּנְהֶדְרִין וְתֻכּוּ בְּבָתֵּי־הַכְּנֵסֶת וּבַעֲבוּרִי תַעַמְדוּ לִפְנֵי מֹשְׁלִים וּמְלָכִים לְעֵדוּת לָהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","וְהַבְּשׂוֹרָה תִקָּרֵא רִאשֹׁנָה בְּקֶרֶב כָּל־הַגּוֹיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","וְכִי־יוֹלִיכוּ אֶתְכֶם לְהַסְגִּירְכֶם בִּידֵי הַמִּשְׁפָּט אַל־תִּדְאֲגוּ וְאַל־תְּחַשְּׁבוּ בְּטֶרֶם בֹּא הַמּוֹעֵד מַה־תְּדַבֵּרוּ כִּי כַאֲשֶׁר יוּשַׂם בְּפִיכֶם בָּעֵת הַהִיא כֵּן תְּדַבְּרוּן כִּי לֹא אַתֶּם הַמְדַבְּרִים כִּי אִם־רוּחַ הַקֹּדֶשׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","וְאָח יַסְגִּיר אֶת־אָחִיו לַמָּוֶת וְאָב אֶת־בְּנוֹ וְקָמוּ בָנִים עַל־אֲבוֹתָם וְהֵמִיתוּ אֹתָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","וְאַתֶּם שְׂנוּאִים תִּהְיוּ לְכָל־אָדָם לְמַעַן שְׁמִי אַךְ הַמְחַכֶּה עַד־הַקֵּץ הוּא יִוָּשֵׁעַ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","וְכִי תִרְאוּ אֶת־הַשִּׁקּוּץ הַמְשֹׁמֵם הַנֶּאֱמָר בְּיַד־דָּנִיֵּאל הַנָּבִיא עֹמֵד בַּמָּקוֹם אֲשֶׁר לֹא נָכוֹן לוֹ הַקֹּרֵא יָבִין אָז אֵלֶּה אֲשֶׁר בִּיהוּדָה יָנוּסוּ אֶל־הֶהָרִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","וּמִי אֲשֶׁר עַל־הַגָּג לֹא יֵרֵד הַבָּיְתָה וְלֹא יָבֹא לָקַחַת מִתּוֹכוֹ מְאוּמָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","וּמִי אֲשֶׁר בַּשָּׂדֶה לֹא יָשׁוּב לְבֵיתוֹ לָקַחַת אֶת־שִׂמְלָתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","אַךְ אוֹי לֶהָרוֹת וְלַמֵּינִיקוֹת בַּיָּמִים הָהֵמָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","וְאַתֶּם הִתְפַּלֵלוּ לְבִלְתִּי תִהְיֶה זֹאת בַּחֹרֶף׃ ");
INSERT INTO hebsg_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","כִּי הַיָּמִים הָאֵלֶּה יְמֵי צָרָה הֵם אֲשֶׁר כָּמוֹהָ לֹא־הָיְתָה מֵרֵאשִׁית יְמֵי הַבְּרִיאָה אֲשֶׁר בָּרָא אֱלֹהִים עַד־הַיּוֹם הַזֶּה וְכָמוֹהָ לֹא־תֹסִף׃ ");
INSERT INTO hebsg_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","וְלוּלֵא יְקַצֵּר יְהוָֹה אֶת־הַיָּמִים הָאֵלֶּה לֹא־יִנָּצֵל כָּל־בָּשָׂר אַךְ לְמַעַן בְּחִירָיו אֲשֶׁר רָצָה בָם יְקַצֵּר אֶת־הַיָּמִים הָאֵלֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","וְאָז אִם־יֹאמַר אֲלֵיכֶם אִישׁ הִנֵּה הַמָּשִׁיחַ פֹּה אוֹ הִנּוֹ שָׁם אַל־תַּאֲמִינוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","כִּי מְשִׁיחֵי שֶׁקֶר וּנְבִיאֵי כָזָב יָקוּמוּ וְנָתְנוּ אֹתוֹת וּמוֹפְתִים לְנַסּוֹת אִם יֶשׁ־לְאֵל יָדָם לְהַתְעוֹת גַּם־אֶת־הַבְּחִירִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","וְאַתֶּם הִשָּׁמְרוּ בְנַפְשׁוֹתֵיכֶם רְאוּ כִּי מֵרֹאשׁ הִגַּדְתִּי לָכֶם אֶת־כֹּל׃ ");
INSERT INTO hebsg_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","אַךְ בַּיָּמִים הָהֵם כַּעֲבוֹר הַצָּרָה הַהִיא תֶּחְשַׁךְ הַשֶּׁמֶשׁ וְהַיָּרֵחַ לֹא־יַגִּיהַּ אוֹרוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","הַכּוֹכָבִים יִפְּלוּ מִן־הַשָּׁמָיִם וּצְבָא הַמָּרוֹם יָזֻעוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","וְאָז יִרְאוּ אֶת־בֶּן־הָאָדָם בָּא בַעֲנָנִים בְּעֹז וּבְהָדָר גָּדוֹל׃ ");
INSERT INTO hebsg_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","וְהוּא יִשְׁלַח אֶת־מַלְאָכָיו וִיקַבֵּץ אֶת־בְּחִירָיו מֵאַרְבַּע הָרוּחוֹת מִקְצֵה הָאָרֶץ עַד־קְצֵה הַשָּׁמָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","וּקְחוּ לָכֶם מָשָׁל מִן־הַתְּאֵנָה אִם רָטוֹב עֲנָפָהּ וְעָלֶיהָ צָמָחוּ יֹדְעִים אַתֶּם כִּי קָרוֹב הַקָּיִץ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","וְכֵן גַּם־אַתֶּם כַּאֲשֶׁר תִּרְאוּ כִּי קָמוּ כָּל־אֵלֶּה יָדוֹעַ תֵּדְעוּ כִּי־קָרוֹב הוּא לַפָּתַח׃ ");
INSERT INTO hebsg_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","אָמֵן אֲנִי אֹמֵר לָכֶם כִּי לֹא יַעֲבֹר הַדּוֹר הַזֶּה עַד אֲשֶׁר־יָקוּמוּ כָּל־אֵלֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","הַשָּׁמַיִם וְהָאָרֶץ יַעֲבֹרוּ וּדְבָרַי לֹא יַעֲבֹרוּן׃ ");
INSERT INTO hebsg_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","וְעַל־מוֹעֵד הַיּוֹם הַהוּא וְהַשָּׁעָה הַהִיא אֵין אִישׁ יֹדֵעַ וְלֹא מַלְאָךְ בַּשָּׁמַיִם וְלֹא הַבֵּן בִּלְתִּי הָאָב׃ ");
INSERT INTO hebsg_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","עַל־כֵּן שִׂימוּ לְבַבְכֶם שִׁקְדוּ וְהִתְפַּלֵּלוּ כִּי אֵינְכֶם יֹדְעִים מָתַי יָבֹא הַמּוֹעֵד הַזֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","הֲלֹא הוּא כְּאִישׁ נֹסֵעַ אֶל־מִחוּץ לָאָרֶץ אֲשֶׁר עָזַב אֶת־בֵּיתוֹ וַיְחַלֵּק אֶת־הַמִּשְׂרָה לַעֲבָדָיו לְאִישׁ אִישׁ אֶת־מְלַאכְתּוֹ וְאֶת־הַשֹּׁעֵר צִוָּה לִשְׁקֹד עַל־הַשָּׁעַר׃ ");
INSERT INTO hebsg_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","לָכֵן הִתְיַצְּבוּ עַל־מִשְׁמַרְתְּכֶם כִּי לֹא תֵדְעוּ מָתַי יָבֹא בַּעַל הַבָּיִת אִם־בָּעֶרֶב אוֹ־בַחֲצִי הַלַּיְלָה אִם־לְעֵת קְרֹא הַתַּרְנְגֹל אוֹ כְּאוֹר הַבֹּקֶר׃ ");
INSERT INTO hebsg_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","פֶּן־יָבֹא פִּתְאֹם וּמָצָא אֶתְכֶם יְשֵׁנִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","וְאֵת אֲשֶׁר אֲנִי אֹמֵר לָכֶם הִנְנִי אֹמֵר לַכֹּל שְׁקֹדוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","וַיְהִי יוֹמַיִם לִפְּנֵי הַפֶּסַח וְחַג־הַמַּצּוֹת וַיְבַקְשׁוּ רָאשֵׁי הַכֹּהֲנִים וְהַסּוֹפְרִים לְתָפְשׂוֹ בְּעָרְמָה וְלַהֲמִיתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","אַךְ אָמְרוּ לֹא בֶחָג פֶּן־תִּתְעֹרֵר מְהוּמָה בָּעָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","וַיְהִי בְּשִׁבְתּוֹ בִּמְסִבָּה בְּבֵית שִׁמְעוֹן הַמְצֹרָע בְּבֵית־עַנְיָה וַתָּבֹא אִשָּׁה וּבְיָדָהּ צְלֹחִית שֶׁמֶן נֵרְדְּ זַךְ וִיקַר־עֶרֶךְ מְאֹד וַתְּשַׁבֵּר אֶת־הַצְּלֹחִית וַתִּצֹּק אֹתוֹ עַל־רֹאשׁוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","וַיֵּרַע הַדָּבָר בְּעֵינֵי אֲנָשִׁים מִן־הַיֹּשְׁבִים שָׁם וַיֹּאמְרוּ בְנַפְשָׁם עַל־מָה נִבְלַע הַשֶּׁמֶן הַזֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","הֲלֹא טוֹב הָיָה לְתִתּוֹ בַכֶּסֶף כְּעֶרְכּוֹ יוֹתֵר מִשְּׁלֹשׁ מֵאוֹת דִּינָר וּלְחַלֵּק מִכְרוֹ לָעֲנִיִּים וַיִּלֹּנוּ עָלֶיהָ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","וַיֹּאמֶר יֵשׁוּעַ הַנִּיחוּ לָהּ לָמָּה־זֶּה תַּלְאוּ אֹתָהּ הֲלֹא טוֹב גְּמָלָתְנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","כִּי אֶת־הָעֲנִיִּים תִּמְצְאוּ לִפְנֵיכֶם תָּמִיד וּבְכָל־עֵת אֲשֶׁר תִּרְצוּ תּוּכְלוּ לְהֵיטִיב לָהֶם וְאֹתִי לֹא־תִמְצְאוּ לִפְנֵיכֶם תָּמִיד׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","וְהִיא עָשְׂתָה כַּאֲשֶׁר מָצְאָה יָדָהּ כִּי הִקְדִּימָה וַתִּמְשַׁח אֶת־בְּשָׂרִי לִקְבוּרָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","אָמֵן אֲנִי אֹמֵר לָכֶם בְּכָל־מָקוֹם אֲשֶׁר תִּשָּׁמַע הַבְּשׂוֹרָה בְּכָל־הָאָרֶץ יְסֻפַּר גַּם־אֲשֶׁר עָשְׂתָה הִיא לָהּ לְזִכָּרוֹן׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","וִיהוּדָה אִישׁ־קְרִיּוֹת אֶחָד מִשְּׁנֵים הֶעָשָׂר הָלַךְ אֶל־רָאשֵׁי הַכֹּהֲנִים וַיֹּאמֶר לְהַסְגִּיר אֹתוֹ בְּיָדָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","וְהֵם כְּשָׁמְעָם כֵּן שָׂמְחוּ וַיַּבְטִיחוּ לָתֶת־לוֹ כָּסֶף וַיְבַקֵּשׁ תֹּאֲנָה לְהַסְגִּיר אֹתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","וַיְהִי בָּרִאשׁוֹן לְחַג הַמַּצּוֹת לְמוֹעֵד זֶבַח הַפָּסַח וַיֹּאמְרוּ אֵלָיו תַּלְמִידָיו אֵיפֹה תִרְצֶה כִּי נֵלֵךְ לְהָכִין לְךָ לֶאֱכֹל אֶת־הַפָּסַח׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","וַיִּשְׁלַח שְׁנַיִם מִתַּלְמִידָיו וַיֹּאמֶר אֲלֵיהֶם לְכוּ הָעִירָה וּפָגַע בָּכֶם אִישׁ נֹשֵׂא כַד־מַיִם לְכוּ אַחֲרָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","וּבַפֶּתַח אֲשֶׁר יָבֹא תֹּאמְרוּ שָׁם אֶל־בַּעַל הַבָּיִת כֹּה אָמַר רַבֵּנוּ אַיֵּה חֲדַר הָאֹרְחִים לִי וּלְתַלְמִידַי לֶאֱכֹל שָׁם אֶת־הַפָּסַח׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","וְהוּא יַרְאֶה לָכֶם עֲלִיָּה גְדוֹלָה רְצוּפָה כְסָתוֹת וַעֲרוּכָה בַכֹּל וְשָׁם תָּכִינוּ לָנוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","וַיֵּצְאוּ הַתַּלְמִידִים וַיָּבֹאוּ הָעִירָה וַיִּמְצְאוּ כַּאֲשֶׁר דִּבֶּר לָהֶם וַיָּכִינוּ אֶת־הַפָּסַח׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","וַיְהִי בָּעָרֶב וַיָּבֹא שָׁם עִם־שְׁנֵים הֶעָשָׂר׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","וּבְעוֹד הֵם אֹכְלִים בִּמְסִבָּם וַיֹּאמֶר יֵשׁוּעַ אָמֵן אֲנִי אֹמֵר לָכֶם כִּי אֶחָד מִכֶּם הָאֹכֵל עִמָּדִי יַסְגִּירֵנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","וַיֵּצַר לָהֶם מְאֹד וַיֹּאמְרוּ אִישׁ אִישׁ מֵהֶם אֵלָיו הַאֲנִי הוּא הֲלֹא׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","וַיֹּאמֶר אֲלֵיהֶם אֶחָד מִשְּׁנֵים הֶעָשָׂר הַטֹּבֵל אֶת־יָדוֹ עִמִּי בַּקְּעָרָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","הֵן בֶּן־הָאָדָם הֹלֵךְ כַּכָּתוּב עָלָיו אַךְ אוֹי לָאִישׁ הַהוּא אֲשֶׁר יַסְגִּיר אֶת־בֶּן־הָאָדָם בְּיַד מְבַקְשֵׁי נַפְשׁוֹ טוֹב הָיָה לָאִישׁ הַהוּא אִם לֹא־יָצָא מֵרָחֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","וַיְהִי בְּאָכְלָם וַיִּקַּח יֵשׁוּעַ אֶת־הַלֶּחֶם וַיְבָרֵךְ וַיִּבְצַע וַיִּתֵּן לָהֶם וַיֹּאמַר קְחוּ אִכְלוּ זֶה הוּא בְּשָׂרִי׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","וַיִּקַּח אֶת־הַכּוֹס וַיְבָרֵךְ וַיִּתֵּן לָהֶם וַיִּשְׁתּוּ כֻלָּם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","וַיֹּאמֶר אֲלֵיהֶם זֶה הוּא דָמִי דַּם־הַבְּרִית הַחֲדָשָׁה הַשָּׁפוּךְ בְּעַד רַבִּים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","אָמֵן אֲנִי אֹמֵר לָכֶם כִּי לֹא אֶשְׁתֶּה עוֹד מִפְּרִי הַגָּפֶן עַד־הַיּוֹם הַהוּא אֲשֶׁר חָדָשׁ אֶשְׁתֵּהוּ בְּמַלְכוּת הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","וַיִּקְרְאוּ אֶת־הַהַלֵּל וַיֵּצְאוּ אֶל־הַר הַזֵּיתִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","וַיֹּאמֶר אֲלֵיהֶם יֵשׁוּעַ הֵן כֻלְּכֶם תִּכָּשְׁלוּ בִי בַּלַיְלָה הַזֶּה כִּי כָתוּב אַכֶּה אֶת־הָרֹעֶה וּתְפוּצֶיןָ הַצֹּאן׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","וְאַחֲרֵי תְקוּמָתִי מִן־הַמֵּתִים אֵלֵךְ לִפְנֵיכֶם הַגָּלִילָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","וַיֹּאמֶר אֵלָיו פֶּטְרוֹס אַף אִם־כֻּלָּם יִכָּשְׁלוּ בְךָ אֲנִי לֹא אֶכָּשֵׁל׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","וַיֹּאמֶר אֵלָיו יֵשׁוּעַ אָמֵן אֲנִי אֹמֵר לָךָ כִּי עַתָּה בַּלַּיְלָה הַזֶּה טֶרֶם יִקְרָא הַתַּרְנְגֹל פַּעֲמַיִם תְּכַחֶשׁ־בִּי שָׁלֹשׁ פְּעָמִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","וְהוּא הוֹסִיף לְדַבֵּר בְּיֶתֶר אֹמֶץ אַף אִם־יִהְיֶה עָלַי לָמוּת אִתְּךָ כַּחֵשׁ לֹא־אֲכַחֵשׁ בָּךְ וְכֵן דִּבְּרוּ גַּם־כֻּלָּם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","וַיָּבֹאוּ אֶל־מְקוֹם גָּדֵר הַנִּקְרָא גַּת־שְׁמֵנָה וַיֹּאמֶר אֶל־תַּלְמִידָיו שְׁבוּ־לָכֶם פֹּה עַד כִּי אֶתְפַּלָּל׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","וַיִּקַּח אִתּוֹ אֶת־פֶּטְרוֹס וְאֶת־יַעֲקֹב וְאֶת־יוֹחָנָן וַיָּחֶל לְהִשְׁתּוֹחֵחַ וּלְהִשּׁוֹמֵם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","וַיֹּאמֶר אֲלֵיהֶם נַפְשִׁי מָרָה־לִי עַד מְאֹד עַד־מָוֶת עִמְדוּ־בָזֶה וּשְׁקֹדוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","וַיַּעֲבֹר הָלְאָה מְעַט מִזְעָר וַיִּפֹּל אַרְצָה וַיִּתְפַּלֵּל לְהַעֲבִיר מֵעָלָיו אֶת־הַשָּׁעָה אִם־יִתָּכֵן הַדָּבָר׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","וַיִּקְרָא אַבָּא אַבָּא הֵן כֹּל תּוּכָל הַעֲבֶר־נָא מֵעָלַי אֶת־הַכּוֹס הַזֹּאת אַךְ־לֹא כִרְצוֹנִי כִּי אִם־כַּאֲשֶׁר רָצִיתָ אָתָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","וַיָּבֹא וַיִּמְצָאֵם יְשֵׁנִים וַיִּפֶן אֶל־פֶּטְרוֹס וַיֹּאמַר שִׁמְעוֹן הֲכִי תִישָׁן הֲכִי־לֹא יָכֹלְתָּ לִשְׁקֹד שָׁעָה אֶחָת׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","שִׁקְדוּ וְהִתְפַּלְּלוּ פֶּן־תָּבֹאוּ לְמַסָּה הֵן הָרוּחַ חֲפֵצָה אַךְ הַבָּשָׂר רָפֶה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","וַיִּפֶן וַיֵּלֶךְ־לוֹ עוֹד וַיִּתְפַּלֵּל כַּדְּבָרִים הָרִאשֹׁנִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","וַיָּשָׁב וַיִּמְצָאֵם יְשֵׁנִים עוֹד כִּי הָיוּ עֵינֵיהֶם כְּבֵדוֹת וְלֹא יָדְעוּ מַה־לַּעֲנוֹת אֹתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","וַיָּבֹא פַּעַם שְׁלִישִׁית וַיֹּאמֶר אֲלֵיהֶם תְּנוּ שֵׁנָה לְעֵינֵיכֶם וּמְנוּחָה רַב־לָכֶם הִנֵּה בָּאָה הַשָּׁעָה וּבֶן־הָאָדָם נִסְגַּר בִּידֵי חַטָּאִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","קוּמוּ וְנֵלֵכָה הִנֵּה הַמַּסְגִּיר אֹתִי הֹלֵךְ וְקָרֵב׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","עֹדֶנּוּ מְדַבֵּר וִיהוּדָה אֶחָד מִשְּׁנֵים הֶעָשָׂר בָּא פִּתְאֹם וְעִמּוֹ הָמוֹן־רַב בַּחֲרָבוֹת וּבְמַטּוֹת מֵאֵת רָאשֵׁי הַכֹּהֲנִים וְהַסּוֹפְרִים וְהַזְּקֵנִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","וְהַמַּסְגִּיר אֹתוֹ נָתַן לָהֶם אוֹת לֵאמֹר הָאִישׁ אֲשֶׁר אֲנַשֶּׁק־לוֹ זֶה הוּא תִּפְשׂוּ אֹתוֹ שִׂימוּ עָלָיו מִשְׁמָר וְהוֹלִיכֻהוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","וַיָּבֹא וַיִּגַּשׁ אֵלָיו פִּתְאֹם וַיֹּאמֶר רַבִּי רַבִּי וַיִּשָּׁקֵהוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","וַיִּשְׁלְחוּ־בוֹ אֶת־יְדֵיהֶם וַיִּתְפְּשֻׂהוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","וְאֶחָד מִן־הַנִּצָּבִים עִמּוֹ שָׁלַף אֶת־חַרְבּוֹ וַיַּךְ אֶת־עֶבֶד הַכֹּהֵן הַגָּדוֹל וַיְקַצֵּץ אֶת־אָזְנוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","וַיַּעַן יֵשׁוּעַ וַיֹּאמֶר אֲלֵיהֶם הֲבַחֲרָבוֹת וּבְמַטּוֹת בָּאתֶם לִתְפֹּשׂ אֹתִי כְּפָרִיץ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","וְיוֹם יוֹם יָשַׁבְתִּי לְהוֹרֹת לָכֶם בַּמִּקְדָּשׁ וְלֹא שְׁלַחְתֶּם בִּי יָד אַךְ לְהָקִים אֶת־הַכְּתוּבִים עֲשִׂיתֶם כָּזֹאת׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","וְהַתַּלְמִידִים עָזְבוּ אֹתוֹ כֻּלָּם וַיָּנֻסוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","וְנַעַר אֶחָד הָלַךְ אַחֲרָיו וְהוּא לָבוּשׁ כְּתֹנֶת־בַּד עַל־בְּשָׂרוֹ וַיֹּאחֲזֻהוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","וַיַּעֲזֹב אֶת־כֻּתָּנְתּוֹ בְּיָדָם וַיָּנָס עָרֹם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","וַיּוֹלִיכוּ אֶת־יֵשׁוּעַ אֶל־הַכֹּהֵן הַגָּדוֹל וַיִּקָּהֲלוּ עָלָיו כָּל־רָאשֵׁי הַכֹּהֲנִים וְהַזְּקֵנִים וְהַסּוֹפְרִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","וּפֶטְרוֹס הָלַךְ אַחֲרָיו מֵרָחוֹק עַד־לַחֲצַר הַכֹּהֵן הַגָּדוֹל פְּנִימָה וַיֵּשֶׁב שָׁם עִם־הַמְשָׁרְתִים וַיִּתְחַמֵּם נֶגֶד הָאוֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","וְרָאשֵׁי הַכֹּהֲנִים וְכָל־הַסַּנְהֶדְרִין בִּקְשׁוּ עֵדוּת עַל־יֵשׁוּעַ לַהֲמִיתוֹ וְלֹא מָצָאוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","כִּי עֵדוּת־שֶׁקֶר עָנוּ בוֹ רַבִּים אֶפֶס עֵדוּתָם לֹא נִמְצְאָה כֵּן׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","וַיָּקוּמוּ אֲנָשִׁים וַיַּעֲנוּ עֵדוּת־שֶׁקֶר בְּפָנָיו לֵאמֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","שָׁמַעְנוּ אֹתוֹ אֹמֵר אֲנִי אֶהֱרֹס אֶת־הַהֵיכָל הַזֶּה מַעֲשֵׁה יָדָיִם וּבִשְׁלֹשֶׁת יָמִים אֶבְנֶה הֵיכָל אַחֵר אֲשֶׁר אֵינֶנּוּ מַעֲשֶׂה יָדָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","אַךְ גַּם־בָּזֹאת דִּבְרֵי עֵדוּתָם יַחְדָּו לֹא נָכֹנוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","וַיָּקָם הַכֹּהֵן הַגָּדוֹל בְּתוֹכָם וַיִּשְׁאַל אֶת־יֵשׁוּעַ לֵאמֹר הֲלֹא תַעֲנֶה דָבָר מַה־זֹּאת הֵעִידוּ בְךָ אֵלֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","וַיִּדֹּם וְלֹא עָנָה מְאוּמָה וַיּוֹסֶף הַכֹּהֵן הַגָּדוֹל וַיִּשְׁאָלֵהוּ עוֹד לֵאמֹר הַאַתָּה הוּא הַמָּשִׁיחַ בֶּן־הַמְבֹרָךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","וַיֹּאמֶר יֵשׁוּעַ אֲנִי הוּא וְאַתֶּם תִּרְאוּ אֶת־בֶּן־הָאָדָם יֹשֵׁב לִימִין הַגְּבוּרָה וּבָא בְּעַנְנֵי הַשָּׁמָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","וַיִּקְרַע הַכֹּהֵן הַגָּדוֹל אֶת־בְּגָדָיו וַיֹּאמַר מַה־לָּנוּ עוֹד וְלָעֵדִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","הֲלֹא שְׁמַעְתֶּם גִּדּוּפוֹ אִמְרוּ מַה־דַּעְתְּכֶם וַיַּרְשִׁיעוּ אֹתוֹ כֻּלָּם כִּי־מִשְׁפָּט־מָוֶת לוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","וַיָּחֵלּוּ אֲנָשִׁים מֵהֶם לָרֹק בּוֹ וַיְחַפּוּ אֶת־פָּנָיו וַיַּכֻּהוּ בָאֶגְרֹף וַיֹּאמְרוּ אֵלָיו הִנָּבֵא לָנוּ וְהַמְשָׁרְתִים קִדְּמוּ אֹתוֹ בְּמַכּוֹת לֶחִי׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","וַיְהִי בִּהְיוֹת פֶּטְרוֹס בֶּחָצֵר מִתָּחַת וַתָּבֹא אַחַת הַשְּׁפָחוֹת מִבֵּית הַכֹּהֵן הַגָּדוֹל׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","וַתֵּרֶא אֶת־פֶּטְרוֹס מִתְחַמֵּם וַתַּבֵּט בְּפָנָיו וַתֹּאמַר וְאַף־אַתָּה הָיִיתָ עִם־יֵשׁוּעַ הַנָּצְרִי׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","וַיְכַחֵשׁ לֵאמֹר לֹא אֵדַע וְלֹא אָבִין אֵת אֲשֶׁר תְּדַבֵּרִי וַיֵּצֵא הַחוּצָה אֶל־הָאוּלָם וַיִּקְרָא אָז הַתַּרְנְגֹל׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","וַתִּרְאֵהוּ הַשִּׁפְחָה עוֹד וַתּוֹסֶף וַתֹּאמֶר אֶל־הָעֹמְדִים שָׁם זֶה הוּא אֶחָד מֵהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","וַיְכַחֵשׁ פַּעַם שֵׁנִית וְעוֹד מְעַט וְגַם־הָעֹמְדִים שָׁם אָמְרוּ אֶל־פֶּטְרוֹס אָכֵן הִנְּךָ מֵהֶם כִּי גְלִילִי אַתָּה וּלְשׁוֹנְךָ כִּלְשׁוֹנָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","וַיָּחֵל לַעֲנוֹת בְּאָלָה וּבִשְׁבֻעָה לֵאמֹר לֹא יָדַעְתִּי אֶת־הָאִישׁ אֲשֶׁר אֲמַרְתֶּם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","וַיִּקְרָא הַתַּרְנְגֹל שֵׁנִית וַיִּזְכֹּר פֶּטְרוֹס אֶת־הַדָּבָר אֲשֶׁר דִּבֶּר־לוֹ יֵשׁוּעַ כִּי טֶרֶם יִקְרָא הַתַּרְנְגֹל פַּעֲמַיִם תְּכַחֶשׁ־בִּי שָׁלֹשׁ פְּעָמִים וַיָּשֶׂם עַל־לִבּוֹ וַיֵּבְךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","וַיְהִי כַּעֲלוֹת הַשַּׁחַר וְרָאשֵׁי הַכֹּהֲנִים נוֹסְדוּ־יַחַד עִם־הַזְּקֵנִים וְהַסּוֹפְרִים וְכָל־הַסַּנְהֶדְרִין וַיַּאַסְרוּ אֶת־יֵשׁוּעַ וַיּוֹלִיכֻהוּ וַיַּסְגִּירֻהוּ בִּידֵי פִילָטוֹס׃ ");
INSERT INTO hebsg_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","וַיִּשְׁאַל אֹתוֹ פִּילָטוֹס הַאַתָּה הוּא מֶלֶךְ הַיְּהוּדִים וַיַּעַן וַיֹּאמֶר אֵלָיו אַתָּה אָמָרְתָּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","וְרָאשֵׁי הַכֹּהֲנִים הֵבִיאוּ עָלָיו שִׂטְנוֹת רַבּוֹת וְהוּא לֹא־נָתַן מַעֲנֶה אַף־לֹא דָבָר אֶחָד׃ ");
INSERT INTO hebsg_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","וַיּוֹסֶף פִּילָטוֹס וַיִּשְׁאָלֵהוּ לֵאמֹר הַאִם לֹא תַעֲנֶה דָבָר רְאֵה כַּמָּה שִׂטְנוֹת הֵבִיאוּ עָלֶיךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","וְיֵשׁוּעַ לֹא־נָתַן מַעֲנֶה אַף־לֹא דָבָר אֶחָד עַד אֲשֶׁר־הָיָה לְפֶלֶא בְּעֵינֵי פִילָטוֹס׃ ");
INSERT INTO hebsg_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","וּבֶחָג הַזֶּה הַסְכֵּן הִסְכִּין לְשַׁלַּח לָהֶם אֶחָד מֵהָאֲסִירִים חָפְשִׁי אֶת־הָאֶחָד אֲשֶׁר יְבַקֵּשׁוּן׃ ");
INSERT INTO hebsg_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","וַיְהִי אִישׁ וּשְׁמוֹ בַּר־אַבָּא אָסוּר עִם־הַמֹּרְדִים אֲשֶׁר רָצְחוּ נֶפֶשׁ בְּיוֹם הַמֶּרֶד׃ ");
INSERT INTO hebsg_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","וַיִּשָׂא הֶהָמוֹן אֶת־קוֹלוֹ וַיָּחֵלּוּ לִשְׁאֹל לַעֲשׂוֹת לָהֶם כַּאֲשֶׁר עָשָׂה לָהֶם כְּפַעַם בְּפָעַם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","וַיַּעַן אֹתָם פִּילָטוֹס וַיֹּאמַר הֲתַחְפְּצוּ כִּי־אֲשַׁלַּח לָכֶם אֶת־מֶלֶךְ הַיְּהוּדִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","כִּי הִכִּיר אֲשֶׁר מִקִּנְאָתָם בּוֹ הִסְגִּירֻהוּ רָאשֵׁי הַכֹּהֲנִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","וְרָאשֵׁי הַכֹּהֲנִים הֵסִיתוּ אֶת־הֶהָמוֹן כִּי יְבַקְשֻׁהוּ לְשַׁלַּח לָהֶם רַק אֵת בַּר־אַבָּא׃ ");
INSERT INTO hebsg_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","וַיּוֹסֶף פִּילָטוֹס וַיַּעַן וַיֹּאמֶר אֶלֵיהֶם וּמַה אֶעֱשֶׂה לָזֶה אֲשֶׁר אַתֶּם קֹרִאיִם מֶלֶךְ הַיְּהוּדִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","וַיּוֹסִיפוּ לִצְעֹק לֵאמֹר הַצְלֵב אֹתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","וַיֹּאמֶר אֲלֵיהֶם פִּילָטוֹס וְלָמָּה מֶה רָעָה עָשָׂה וְהֵם הוֹסִיפוּ לִצְעֹק עוֹד יֶתֶר הַרְבֵּה הַצְלֵב אֹתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","וַיּוֹאֶל פִּילָטוֹס לַעֲשׂוֹת כִּרְצוֹן הֶהָמוֹן וַיְשַׁלַּח לָהֶם אֵת בַּר־אַבָּא וְאֵת יֵשׁוּעַ יִסַּר בַּשּׁוֹטִים וַיִּתְּנֵהוּ לְהִצָּלֵב׃ ");
INSERT INTO hebsg_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","וַיּוֹלִיכֻהוּ אַנְשֵׁי הַצָּבָא אֶל־הֶחָצֵר הַפְּנִימִית הוּא פְּרַטוֹרִין וַיַּזְעִיקוּ עָלָיו אֶת־כָּל־הַגְּדוּד׃ ");
INSERT INTO hebsg_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","וַיַּלְבִּשֻׁהוּ מְעִיל אַרְגָּמָן וַיְשָׂרְגוּ כֶתֶר קוֹצִים וַיָּשִׂימוּ עַל־רֹאשׁוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","וַיָּחֵלּוּ לְפָקְדוֹ לֵאמֹר יְחִי מֶלֶךְ הַיְּהוּדִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","וְהִכּוּ אֹתוֹ בְקָנֶה עַל־רֹאשׁוֹ וְיָרְקוּ בְּפָנָיו וְעַל־בִּרְכֵּיהֶם כָרְעוּ וַיִּשְׁתַּחֲווּ לוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","וְאַחֲרֵי אֲשֶׁר הֵתֵלּוּ בוֹ הִפְשִׁיטוּ אֹתוֹ אֶת־מְעִיל הָאַרְגָּמָן וַיַּלְבִּישֻׁהוּ אֶת־בְּגָדָיו וַיּוֹלִיכֻהוּ לִצְלֹב אֹתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","וְאִישׁ אֶחָד עָבַר שָׁם בְּבֹאוֹ מִן־הַשָּׂדֶה הוּא שִׁמְעוֹן הַקּוּרִינִי אֲבִי אֲלֶכְסַנְדְּרוֹס וְרוּפוֹס אֹתוֹ אִלְּצוּ לַהֲלֹךְ אִתָּם וְלָשֵׂאת לוֹ אֶת־צְלָבוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","וַיָּבִיאוּ אֹתוֹ אֶל־גָּלְגָּלְתָּא אֲשֶׁר יֵאָמֵר מְקוֹם הַגֻּלְגֹּלֶת׃ ");
INSERT INTO hebsg_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","וַיִּתְּנוּ־לוֹ יַיִן מָהוּל בְּמֹר וְלֹא שָׁתָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","וַיִּצְלְבוּ אֹתוֹ וַיְחַלְּקוּ אֶת־בְּגָדָיו לָהֶם לְפִי הַגּוֹרָל אֲשֶׁר הִפִּילוּ עֲלֵיהֶם לָקַח אִישׁ אִישׁ חֶלְקוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","וְהָעֵת אֲשֶׁר צָלְבוּ אֹתוֹ הָיְתָה הַשָּׁעָה הַשְּׁלִישִׁית׃ ");
INSERT INTO hebsg_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","וּכְתֹבֶת דְּבַר־אַשְׁמָתוֹ שָׂמוּ מִלְמַעְלָה עַל־הָעֵץ לֵאמֹר מֶלֶךְ הַיְּהוּדִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","וְגַם־שְׁנֵי אַנְשֵׁי חָמָס נִצְלְבוּ עִמּוֹ אֶחָד מִימִינוֹ וְאֶחָד מִשְּׂמֹאלוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","וַיִּמָּלֵא הַכָּתוּב הָאֹמֵר וְאֶת־פּשְׁעִים נִמְנָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","וְהָעֹבְרִים שָׁם גִּדְּפוּ אֹתוֹ וַיָּנִיעוּ אַחֲרָיו אֶת־רֹאשָׁם לֵאמֹר הוֹי אַתָּה הַמַּחֲרִיב אֶת־הַהֵיכָל וְהַבּוֹנֶה אֹתוֹ בִּשְׁלֹשֶׁת יָמִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","הוֹשִׁיעָה לְנַפְשֶׁךָ וּרְדָה מִן־הָעֵץ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","וְכֵן גַּם־רָאשֵׁי הַכֹּהֲנִים וְהַסּוֹפְרִים שָׂחֲקוּ אִישׁ אֶל־רֵעֵהוּ לֵאמֹר הוּא הַמּוֹשִׁיעַ לַאֲחֵרִים וּלְנַפְשׁוֹ לֹא יוּכַל לְהוֹשִׁיעַ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","הַמָּשִׁיחַ מֶלֶךְ יִשְׂרָאֵל הוּא יֵרֶד עַתָּה מִן־הָעֵץ וְנִרְאֶה וְנַאֲמִין בּוֹ וְגַם־הַנִּצְלָבִים עִמּוֹ כְּמוֹ־כֵן חֵרְפֻהוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","וַיְהִי בַּשָּׁעָה הַשִּׁשִּׁית וְחֹשֶׁךְ כִּסָּה אֶת־פְּנֵי כָל־הָאָרֶץ עַד הַשָּׁעָה הַתְּשִׁיעִית׃ ");
INSERT INTO hebsg_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","וּבַשָּׁעָה הַתְּשִׁיעִית צָעַק יֵשׁוּעַ בְּקוֹל גָּדוֹל אֱלָהִי אֱלָהִי לְמָה שְׁבַקְתָּנִי אֲשֶׁר יֵאָמֵר אֵלִי אֵלִי לָמָה עֲזַבְתָּנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","וּמִן־הָעֹמֵדִים שָׁם כַּאֲשֶׁר שָׁמְעוּ אָמְרוּ הִנֵּה הוּא קֹרֵא אֶל־אֵלִיָּהוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","וַיָּרָץ אֶחָד מֵהֶם וַיִּקַּח סְפוֹג אֲשֶׁר מִלְאוֹ חֹמֶץ וַיְשִׂימֵהוּ עַל־קָנֶה וַיַּשְׁקֵהוּ וַיֹּאמֶר הֶרֶף וְנִרְאֶה אִם־יָבֹא אֵלִיָּהוּ לְהוֹרִיד אֹתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","וְיֵשׁוּעַ קָרָא בְּקוֹל גָּדוֹל וַיַּפְקֵד אֶת־רוּחוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","וְהִנֵּה פָּרֹכֶת הַהֵיכָל נִקְרְעָה לִשְׁנַיִם קְרָעִים מִלְמַעְלָה לְמָטָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","וְשַׂר־הַמֵּאָה הָעֹמֵד מִמֻּלוֹ בִרְאֹתוֹ כַּאֲשֶׁר צָעַק וְכַאֲשֶׁר גָּוַע וַיֹּאמַר אָכֵן הָאִישׁ הַזֶּה הָיָה בֶּן־אֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","וְגַם־נָשִׁים הָיוּ רֹאוֹת שָׁמָּה מֵרָחוֹק וּבֵינֵהֶן מִרְיָם הַמַּגְדָּלִית וּמִרְיָם אֵם־יַעֲקֹב הַקָּטֹן וְיוֹסֵי וּשְׁלֹמִית׃ ");
INSERT INTO hebsg_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","הֲלֹא הֵנָּה אֲשֶׁר הָלְכוּ אַחֲרָיו וַיְשָׁרְתֻהוּ בִּהְיוֹתוֹ בַגָּלִיל וְעוֹד אֲחֵרוֹת רַבּוֹת אֲשֶׁר־עָלוּ עִמּוֹ יְרוּשָׁלָיְמָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","וַיְהִי בָּעֶרֶב בְּיוֹם הַהֲכָנָה הַהוּא כִּי עֶרֶב שַׁבָּת הָיָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","וַיָּבֹא יוֹסֵף מִן־הָרָמָתַיִם הוּא יוֹעֵץ נִכְכָּד וְגַם־הוּא חִכָּה לְמַלְכוּת הָאֱלֹהִים וַיָּבֹא אֶל־פִּילָטוֹס בְּאֹמֶץ־לֵב וַיִּשְׁאַל מִמֶּנּוּ אֶת־גּוּף יֵשׁוּעַ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","וַיִּשְׁתָּאֶה פִּילָטוֹס לֵאמֹר הַאִם הוּא כְּבָר מֵת וַיִּקְרָא אֶל שַׂר הַמֵּאָה וַיִּשְׁאָלֵהוּ אִם כְּבַר מֵת׃ ");
INSERT INTO hebsg_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","וְכַאֲשֶׁר שָׁמַע מִן־שַׂר הַמֵּאָה כִּי־כֵן הוּא וַיִּתֵּן אֶת־הַגּוּף אֶל־יוֹסֵף׃ ");
INSERT INTO hebsg_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","וְהוּא לָקַח תַכְרִיךְ־בּוּץ וַיֹּרִידֵהוּ מִן־הָעֵץ וַיַּעֲטֵהוּ בַּתַּכְרִיךְ וַיְשִׂימֵהוּ בַּקֶּבֶר אֲשֶׁר חָצַב־לוֹ בַּצּוּר וַיָּגֶל אֶבֶן עַל־פִּי הַקָּבֶר׃ ");
INSERT INTO hebsg_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","וּמִרְיָם הַמַּגְדָּלִית וּמִרְיָם אֵם יוֹסֵי רָאוּ אֶת־הַמָּקוֹם בַּאֲשֶׁר הוּשַׂם שָׁמָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","וְכִמְעַט עָבַר הַשַּׁבָּת וּמִרְיָם הַמַּגְדַּלִית וּמִרְיָם אֵם יַעֲקֹב וּשְׁלֹמִית קָנוּ סַמִּים לָבֹא וְלִמְשֹׁחַ אֹתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","וּבָאֶחָד בַּשַּׁבָּת בַּבֹּקֶר הַשְׁכֵּם בָּאוּ אֶל־הַקָּבֶר עִם־עֲלוֹת הַשָּׁמֶשׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","וַתֹּאמַרְנָה אִשָּׁה אֶל־אֲחוֹתָהּ מִי יָגֶל־לָנוּ אֶת־הָאֶבֶן מֵעַל פִּי־הַקָּבֶר׃ ");
INSERT INTO hebsg_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","וַתִּשָּׂאנָה אֶת־עֵינֵיהֶן וַתִּרְאֶינָה כִּי הָאֶבֶן נָגֹלָּה כִּי גְדוֹלָה הָיְתָה מְאֹד׃ ");
INSERT INTO hebsg_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","וַתָּבֹאנָה אֶל־תּוֹךְ הַקָּבֶר וַתִּרְאֶינָה נַעַר אֶחָד עֹטֶה מְעִיל לָבָן יֹשֵׁב מֵעֵבֶר הַיָּמִין וַתִּבָּהַלְנָה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","וַיֹּאמֶר אֲלֵיהֶן אַל־תִּבָּהַלְנָה הִנֵּה אַתֶּן מְבַקְשׁוֹת אֶת־יֵשׁוּעַ הַנָּצְרִי אֲשֶׁר נִצְלָב הֲלֹא הוּא קָם וְאֵינֶנּוּ פֹה רְאֶינָה אֶת־הַמָּקוֹם אֲשֶׁר שָׂמוּהוּ שָׁמָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","אַךְ־לֵכְנָה וְהַגֵּדְנָה לְתַלְמִידָיו וּלְפֶטְרוֹס כִּי הוּא הוֹלֵךְ לִפְנֵיכֶם הַגָּלִילָה וְשָׁם תִּרְאוּ אֹתוֹ כַּאֲשֶׁר דִּבֶּר לָכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","וַתְּמַהֵרְנָה לָצֵאת מִן־הַקֶּבֶר וַתָּנוֹסְנָה כִּי חִיל וָפַחַד אֲחָזוּן וְלֹא־הִגִּידוּ לְאִישׁ דָּבָר כִּי יָרְאוּ מְאֹד׃ ");
INSERT INTO hebsg_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","וַיְהִי בָּאֶחָד בַּשַּׁבָּת בַּבֹּקֶר אַחֲרֵי תְקוּמָתוֹ וַיֵּרָא אֶל־מִרְיָם הַמַּגְּדָּלִית רִאשׁוֹנָה הִיא הָאִשָּׁה אֲשֶׁר הֶעֱבִיר מִמֶּנָּה שֶׁבַע רוּחוֹת רָעוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","וְהִיא הָלְכָה וַתַּגֵּד לְאַנְשֵׁי בְרִיתוֹ אֲשֶׁר הָיוּ עִמּוֹ וְהֵם מִתְאַבְּלִים וּבֹכִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","וְאַחֲרֵי אֲשֶׁר שָׁמְעוּ כִּי הוּא חָי וְכִי נִרְאָה אֵלֶיהָ לֹא הֶאֱמִינוּ לָהּ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","וְאַחֲרֵי־כֵן נִרְאָה בִּדְמוּת אַחֶרֶת אֶל־שְׁנַיִם מֵהֶם עַל־פְּנֵי הַשָּׂדֶה כַּאֲשֶׁר הָלְכוּ לְדַרְכָּם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","וַיָּשׁוּבוּ וַיַּגִּידוּ לַאֲחֵרִים וְלֹא הֶאֱמִינוּ גַּם־בְּדִבְרֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","וַיֵּרָא אַחֲרֵי־כֵן אֶל־אַחַד הֶעָשָׂר בְּשִׁבְתָּם עַל־הַשֻּׁלְחָן וַיּוֹכִיחֵם עַל־חֹסֶר אֱמוּנָתָם וְעַל־קְשִׁי לִבָּם כִּי לֹא־הֶאֱמִינוּ לְאֵלֶּה אֲשֶׁר רָאוּ אֹתוֹ אַחֲרֵי תְקוּמָתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","וַיֹּאמֶר אֲלֵיהֶם לְכוּ בְכָל־הָאָרֶץ וְקִרְאוּ אֶת־הַבְּשׂוֹרָה לְכָל־בָּשָׂר׃ ");
INSERT INTO hebsg_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","מִי אֲשֶׁר יַאֲמִין וְיִטָּבֵל יִוָּשֵׁעַ וּמִי אֲשֶׁר לֹא־יַאֲמִין יֶאְשָׁם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","וְאֵלֶּה הָאֹתוֹת אֲשֶׁר יֵעָשׂוּ בִידֵי הַמַּאֲמִינִים רוּחוֹת רָעוֹת יַעֲבִירוּ בִשְׁמִי וּבִלְשֹׁנוֹת חֲדָשׁוֹת יְדַבֵּרוּן׃ ");
INSERT INTO hebsg_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","נְחָשִׁים כִּי־יִשְׂאוּ אוֹ כִי־יִשְׁתּוּ סַמִּים אֲשֶׁר מָוֶת בָּם לֹא יָרֵעוּ וְלֹא יַשְׁחִיתוּ לָהֶם וִידֵיהֶם יָשִׂימוּ עַל־חוֹלִים וְחָיוּ מֵחָלְיָם׃ ");
INSERT INTO hebsg_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","וַיְהִי כַּאֲשֶׁר כִּלָּה הָאָדוֹן יֵשׁוּעַ לְדַבֵּר אֲלֵיהֶם וַיַּעַל הַשָּׁמַיְמָה וַיֵּשֶׁב לִימִין הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","וְהֵם יָצְאוּ וַיְבַשְּׂרוּ אֶת־הַבְּשׂוֹרָה בְּכָל־מָקוֹם וְיַד־הָאָדוֹן הָיְתָה עִמָּם בִּמְלַאכְתָּם וַיָּקֶם אֶת־דְּבָרוֹ בְּאֹתוֹת אֲשֶׁר נַעֲשׂוּ בִּידֵיהֶם אָמֵן׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","הֵן יְדֵי רַבִּים כָּתְבוּ עַל־סֵפֶר אֶת־מַעַרְכֵי הַדְּבָרִים אֲשֶׁר כּוֹנְנוּ בְתוֹכֵנוּ אֶל־נָכוֹן׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","כַּאֲשֶׁר מָסְרוּ לָנוּ אֵלֶּה אֲשֶׁר הָיוּ עֵדִים רֹאִים מֵרֹאשׁ וּמְשָׁרְתֵי דְּבַר־יְהוָֹה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","וּבְכֵן גַּם־אֲנִי אֲשֶׁר בָּחַנְתִּי הֵיטֵב אֶת־הַדְּבָרִים הָהֵם מֵרֵאשִׁיתָם הֲכִינֹתִי אֶת־לִבִּי לְכָתְבָם אֵלֶיךָ תְּאוֹפִילוֹס גִּבּוֹר הֶחָיִל דָּבָר דָּבֻר עַל־אָפְנָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","לְבַעֲבוּר תֵּדַע כִּי תוֹרַת אֱמֶת לָמַדְתָּ מִפִּי מְלַמְּדֶיךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","אִישׁ כֹּהֵן הָיָה בִּימֵי הוֹרְדוֹס מֶלֶךְ יְהוּדָה וּשְׁמוֹ זְכַרְיָהוּ מִמִּשְׁמֶרֶת אֲבִיָּה וְלוֹ אִשָּׁה מִבְּנוֹת אַהֲרֹן אֱלִישֶׁבַע שְׁמָהּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","וּשְׁנֵיהֶם הָיוּ צַדִּיקִים לִפְנֵי הָאֱלֹהִים וְהֹלְכִים בִּדְרָכָיו בְּכָל־מִצְוֹתָיו וְחֻקֹּתָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","וְלֹא־הָיָה לָהֶם וָלָד כִּי אֱלִישֶׁבַע עֲקָרָה וּשְׁנֵיהֶם בָּאוּ בַיָּמִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","וַיְהִי הַיּוֹם בְּכַהֲנוֹ לִפְנֵי הָאֱלֹהִים בְּסֵדֶר מִשְׁמַרְתּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","וַיָּבֹא אֶל־הֵיכַל יְהוָֹה לְהַקְטִיר קְטֹרֶת לְפִי־גוֹרָלוֹ כְּמִשְׁפַּט עֲבֹדַת הַכֹּהֲנִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","וְכָל־קְהַל הָעָם מִתְפַּלְּלִים אָז מִחוּץ בְּעֵת הַקְטֵר הַקְּטֹרֶת׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","וַיֵּרָא אֵלָיו מַלְאַךְ יְהוָֹה עֹמֵד אֵצֶל מִזְבַּח הַקְּטֹרֶת לִימִינוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","וַיַּרְא זְכַרְיָהוּ וַיֶּחֱרָד וְאֵימָה נָפְלָה עָלָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","וַיֹּאמֶר אֵלָיו הַמַּלְאָךְ אַל־תִּירָא זְכַרְיָהוּ כִּי תְפִלָּתְךָ עָלְתָה לְרָצוֹן וְאֱלִישֶׁבַע אִשְׁתְּךָ תֵּלֵד לְךָ בֵן וְקָרָאתָ שְׁמוֹ יוֹחָנָן׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","וְהָיָה־לְךָ לְשִׂמְחָה וּלְשָׂשׂוֹן וְרַבִּים בְּהִוָּלְדוֹ יַעֲלֹזוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","כִּי־יִגְדַּל לִפְנֵי יְהוָֹה וְיַיִן וְשֵׁכָר לֹא יִשְׁתֶּה וְרוּחַ הַקֹּדֶשׁ יִמָּלֵא בְּעוֹד הֱיוֹתוֹ בְּבֶטֶן אִמּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","וְרַבִּים מִבְּנֵי יִשְׂרָאֵל יָשִׁיב אֶל־יְהוָֹה אֱלֹהֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","וְהָלַךְ לְפָנָיו בְּרוּחַ אֵלִיָּהוּ וּבִגְבוּרָתוֹ לְהָשִׁיב לֵב אָבוֹת עַל־בָּנִים וּלְפשְׁעִים רוּחַ דֵּעָה יְשָׁרָה וְהֶעֱמִיד לִפְנֵי יְהוָֹה עָם אֲשֶׁר לִבּוֹ נָכוֹן עִמּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","וַיֹּאמֶר זְכַרְיָהוּ אֶל־הַמַּלְאָךְ בַּמָּה אֵדַע זֹאת הֵן אֲנִי זָקַנְתִּי וְאִשְׁתִּי בָּאָה בַיָּמִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","וַיַּעַן הַמַּלְאָךְ וַיֹּאמֶר אֵלָיו אָנֹכִי גַבְרִיאֵל הָעֹמֵד לִפְנֵי הָאֱלֹהִים שֻׁלַּחְתִּי לְדַבֵּר אֵלֶיךָ וּלְבַשֶּׂרְךָ כָּזֹאת׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","וְהִנֵּה אַתָּה תֵאָלֵם וְלֹא תוּכַל דַבֵּר עַד אֲשֶׁר יָקוּם הַדָּבָר הַזֶּה עֵקֶב אֲשֶׁר לֹא הֶאֱמַנְתָּ לִדְבָרַי אֲשֶׁר יָקוּמוּ בְּעִתָּם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","וְהָעָם הוֹחִילוּ לִזְכַרְיָהוּ עַד־בּוֹשׁ וַיִּתְפַּלְאוּ כִּי הִתְמַהְמַהּ בַּהֵיכָל׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","וּבְצֵאתוֹ לֹא יָכֹל דַּבֵּר אֲלֵיהֶם וַיַּכִּירוּ כִּי־חִזָּיוֹן חָזָה בַּהֵיכָל וַיָּנַע לָהֶם בְּרֹאשׁוֹ כִּי הוּא אִלֵּם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","וְכַאֲשֶׁר מָלְאוּ יְמֵי עֲבֹדָתוֹ וַיֵּלֶךְ וַיָּשָׁב אֶל־בֵּיתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","וַיְהִי אַחֲרֵי הַיָּמִים הָאֵלֶּה וַתַּהַר אֱלִישֶׁבַע אִשְׁתּוֹ וַתַּסְתֵּר חֲמִשָּׁה חֳדָשִׁים לֵאמֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","כָּכָה עָשָׂה לִי יְהוָֹה בַּיָּמִים אֲשֶׁר פְּקָדַנִי וְאָסַף אֶת־חֶרְפָּתִי לְעֵינֵי בְנֵי־אָדָם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","וּבַחֹדֶשׁ הַשִּׁשִּׁי שֻׁלַּח גַּבְרִיאֵל הַמַּלְאָךְ מִלִּפְנֵי אֱלֹהִים אֶל־עִיר בַּגָּלִיל וּשְׁמָהּ נְצָרֶת׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","אֶל־עַלְמָה בְּתוּלָה מְאֹרָשָׂה לְאִישׁ וּשְׁמוֹ יוֹסֵף מִבֵּית דָּוִד וְהָעַלְמָה שְׁמָהּ מִרְיָם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","וַיָּבֹא הַמַּלְאָךְ אֵלֶיהָ הַבָּיְתָה וַיֹּאמֶר שָׁלוֹם לָךְ הַבַּת רֻחָמָה יְהוָֹה עִמָּךְ בְּרוּכָה אַתְּ בַּנָּשִׁים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","וְהִיא בִּרְאוֹתָה וַתִּתְחַלְחַל לִדְבָרוֹ וַתֹּאמֶר בְּלִבָּהּ מָה הַבְּרָכָה הַזֹּאת׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","וַיֹּאמֶר אֵלֶיהָ הַמַּלְאָךְ אַל־תִּירְאִי מִרְיָם כִּי־מָצָאת חֵן בְּעֵינֵי הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","וְהִנָּךְ הָרָה וְיָלַדְתְּ בֵּן וְקָרָאת שְׁמוֹ יֵשׁוּעַ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","וְהוּא גָּדוֹל יִהְיֶה וּבֶן־עֶלְיוֹן יִקָּרֵא וְנָתַן לוֹ יְהוָֹה אֱלֹהִים אֶת־כִּסֵּא דָּוִד אָבִיו׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","וּמָלַךְ עַל־בֵּית יַעֲקֹב לְעוֹלָם וָעֶד וּלְמַלְכוּתוֹ אֵין קֵץ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","וַתֹּאמֶר מִרְיָם אֶל־הַמַּלְאָךְ אֵיכָה תִהְיֶה כָזֹאת וַאֲנִי אֵינֶנִּי יֹדַעַת אִישׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","וַיַּעַן הַמַּלְאָךְ וַיֹּאמֶר אֵלֶיהָ רוּחַ הַקֹּדֶשׁ תָּבֹא עָלַיִךְ וְכֹחַ עֶלְיוֹן יָסֶךְ־לָךְ עַל־כֵּן גַּם־הַקָּדוֹשׁ הַיִּלוֹד יִקָּרֵא בֶּן־אֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","וְהִנֵּה אֱלִישֶׁבַע מוֹדַעְתֵּךְ הַנִּקְרֵאת עֲקָרָה הָרָה גַּם־הִיא לָלַת בֵּן בְּזִקְנָתָהּ וְזֶה־לָּהּ הַחֹדֶשׁ הַשִּׁשִּׁי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","כִּי מֵאֱלֹהִים לֹא יִפָּלֵא כָּל־דָּבָר׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","וַתֹּאמֶר מִרְיָם הִנְנִי שִׁפְחַת יְהוָֹה יְהִי־לִי כִדְבָרֶךָ וַיֵּלֶךְ הַמַּלְאָךְ מֵאִתָּהּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","וַתָּקָם מִרְיָם בַּיָּמִים הָהֵם וַתַּחַשׁ לָלֶכֶת הָהָרָה אֶל־עִיר יְהוּדָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","וַתָּבֹא בֵּית זְכַרְיָה וַתִּפְקֹד אֶת־אֱלִישֶׁבַע לְשָׁלוֹם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","וַיְהִי כִּשְׁמֹעַ אֱלִישֶׁבַע פְּקוּדַת שָׁלוֹם מִפִּי מִרְיָם וַיִּרְקַד הַיֶּלֶד בְּקִרְבָּהּ וַתִּמָּלֵא אֱלִישֶׁבַע רוּחַ הַקֹּדֶשׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","וַתִּקְרָא בְקוֹל גָּדוֹל וַתֹּאמַר בְּרוּכָה אַתְּ מִנָּשִׁים וּבָרוּךְ פְּרִי בִטְנֵךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","וּמֵאַיִן בָּאַתְנִי כָזֹאת כִּי־אֵם אֲדֹנִי אֶלַי תָּבֹא׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","כִּי כַּאֲשֶׁר שָׁמְעָה אָזְנִי קוֹל פְּקוּדַת שָׁלוֹם מִפִּיךְ רָקַד הַיֶּלֶד בְּקִרְבִּי מֵרֹב שִׂמְחָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","אַשְׁרֵךְ כִּי תַאֲמִינִי כִּי יָקוּם הַדָּבָר הָאָמוּר לָךְ מִפִּי־יְהוָֹה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","וַתַּעַן מִרְיָם וַתֹּאמַר תְּגַדֵּל נַפְשִׁי אֶת־יְהוָֹה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","וְתָגֵל רוּחִי בֵּאלֹהֵי יִשְׁעִי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","כִּי רָאָה בָעֳנִי שִׁפְחָתוֹ מֵהַיּוֹם הַזֶּה וָמַעְלָה יְאַשְּׁרוּנִי כָּל־הַדֹּרוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","גְּדֹלוֹת עָשָׂה עִמָּדִי אַדִּיר הוּא וְקָדוֹשׁ שְׁמוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","וְחַסְדּוֹ עַל־יְרֵאָיו בְּכָל־דּוֹר וָדוֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","בִּזְרֹעוֹ עָשָׂה נִפְלָאוֹת הֵפִיץ גֵּאִים בִּמְזִמַּת לִבָּם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","שַׁלִּיטִים הָדַף מִכִּסְאוֹתָם וַיָּשֶׂם שְׁפָלִים לַמָּרוֹם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","רְעֵבִים מִלֵּא טוֹב וַעֲשִׁירִים שָׁלַח רֵיקָם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","הֶחֱזִיק בְּיִשְׂרָאֵל עַבְדּוֹ וַיִּזְכָּר־לוֹ אֶת־רַחֲמָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","כַּאֲשֶׁר דִּבֶּר לַאֲבֹתֵינוּ לְאַבְרָהָם וּלְזַרְעוֹ עַד־עוֹלָם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","וַתֵּשֶׁב עִמָּהּ מִרְיָם כִּשְׁלֹשֶׁת יְרָחִים וַתָּשָׁב אֶל־בֵּיתָהּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","וַיִּמְלְאוּ יְמֵי אֱלִישֶׁבַע לָלֶדֶת וַתֵּלֶד בֵּן׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","וּשְׁכֵנֶיהָ וּקְרוֹבֶיהָ שָׁמְעוּ כִּי־הִגְדִּיל יְהוָֹה חַסְדּוֹ עָלֶיהָ וַיִּשְׂמְחוּ אִתָּהּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","וַיְהִי בַּיּוֹם הַשְּׁמִינִי וַיָּבֹאוּ לָמוּל אֶת־הַיָּלֶד וַיִּקְרְאוּ לוֹ זְכַרְיָהוּ עַל־שֵׁם אָבִיו׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","וַתַּעַן אִמּוֹ וַתֹּאמַר לֹא־כֵן כִּי הוּא יוֹחַנָן יִקָּרֵא׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","וַיֹּאמְרוּ אֵלֶיהָ הֲלֹא אֵין־בְּמִשְׁפַּחְתֵּךְ אִישׁ נִקְרָא בַּשֵּׁם הַזֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","וַיִּתְּנוּ אוֹת לְאָבִיו לֵאמֹר מָה־עִם לְבָבוֹ מַה־יִּקְרָא־לוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","וַיִּשְׁאַל לוּחַ וַיִּכְתֹּב עָלָיו לֵאמֹר יוֹחָנָן שְׁמוֹ וַיִּתְמְהוּ כֻלָּם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","וּפִתְאֹם נִפְתַּח פִּיהוּ וּמִלָּתוֹ עַל־לְשֹׁנוֹ וַיְבָרֶךְ אֶת־הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","וַתִּפֹּל יִרְאָה עַל־כָּל־שְׁכֵנֵיהֶם מִסָּבִיב וְהַדְּבָרִים הָאֵלֶּה סֻפְּרוּ בְּכָל־הָרֵי יְהוּדָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","וְכָל־הַשֹּׁמְעִים דִבְּרוּ עַל־לִבָּם לֵאמֹר מַה יִהְיֶה אֵפוֹא הַיֶּלֶד הַזֶּה וְיַד־יְהוָֹה הָיְתָה עָלָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","וַיִּמָלֵא זְכַרְיָהוּ אָבִיו רוּחַ הַקֹּדֶשׁ וַיִּנָּבֵא לֵאמֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","בָּרוּךְ יְהוָֹה אֱלֹהֵי יִשְׂרָאֵל כִּי פָקַד וְשָׁלַח פְּדוּת לְעַמוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","וַיָּרֶם לָנוּ קֶרֶן יְשׁוּעָה בְּבֵית־דָּוִד עַבְדּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","כַּאֲשֶׁר דִּבֶּר בְּפִי־נְבִיאָיו הַקְּדוֹשִׁים אֲשֶׁר מִקֶּדֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","לְהוֹשִׁיעַ לָנוּ מִיַּד אֹיְבֵינוּ וּמִכַּף כָּל־שׂנְאֵינוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","לִגְמָל־חֶסֶד עִם־אֲבוֹתֵינוּ וְלִזְכֹּר אֶת־בְּרִית קָדְשׁוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","אֶת־בְּרִית הַשְּׁבוּעָה אֲשֶׁר נִשְׁבַּע לְאַבְרָהָם אֲבִינוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","כִּי יַצִּילֵנוּ מִיַּד־צָר וְיִתְּנֵנוּ לְעָבְדוֹ בִּבְלִי־פָחָד׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","וְנִתְהַלֵּךְ בְּקֹדֶשׁ וּבִצְדָקָה לְפָנָיו כָּל־יְמֵי חַיֵּינוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","וְגַם־אַתָּה הַיֶּלֶד נְבִיא־עֶלְיוֹן תִּקָּרֵא כִּי לִפְנֵי יְהוָֹה תֵּלֵךְ וְאֶת־דְּרָכָיו תְּפַנֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","וְנָתַתָּ דַּעַת יְשׁוּעָה לְעַמּוֹ הִיא הַסְּלִיחָה לְחַטֹּאתָם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","בִּזְרֹחַ לָנוּ אוֹר־בֹּקֶר מִמָּרוֹם מִמְּקוֹר רַחֲמֵי אֱלֹהֵינוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","לְהָאִיר לְישְׁבֵי חֹשֶׁךְ וְצַלְמָוֶת וּלְיַשֵּׁר אַשּׁוּרֵינוּ בְּמַעְגְּלֵי שָׁלוֹם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","וַיִּגְדַּל הַיֶּלֶד הוֹלֵךְ וְחָזֵק בָּרוּחַ וַיִּתְגּוֹרֵר בַּמִּדְבָּר עַד־יוֹם הֵרָאֹתוֹ אֶל־יִשְׁרָאֵל׃ ");
INSERT INTO hebsg_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","וִיְהִי בַּיָּמִים הָהֵם וַיֵּצֵא דְבַר מַלְכוּת מִלִּפְנֵי הַקֵּיסַר אוֹגוּסְטוֹס לִמְנוֹת כָּל־ישְׁבֵי הָאָרֶץ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","הוּא הַמִּפְקָד הָרִאשׁוֹן אֲשֶׁר נַעֲשָׂה בִּימֵי קוּרִינִיּוֹס פַּחַת אֲרָם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","וַיֵּלְכוּ כֻלָּם לְהִמָּנוֹת אִישׁ אִישׁ לְעִירוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","וַיַּעַל גַּם־יוֹסֵף מִן־הַגָּלִיל מֵעִיר נְצָרֶת אֶל־עִיר דָּוִד הִיא בֵּית־לָחֶם כִּי מִמִּשְׁפַּחַת בֵּית דָּוִד הוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","וַיָּבֹא עִם־מִרְיָם הַמְאֹרָשָׂה לוֹ לָבֹא עַל־הַפְּקוּדִים וְהִיא הָרָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","וַיְהִי בִּהְיוֹתָם שָׁם וַיִּמְלְאוּ יָמֶיהָ לָלֶדֶת׃ ");
INSERT INTO hebsg_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","וַתֵּלֶד אֶת־בְּנָהּ הַבְּכוֹר וַתְּחַתְּלֵהוּ בַחֲתוּלוֹת וַתָּשֶׂם אֹתוֹ בָּאֵבוּס כִּי לֹא־מָצְאוּ מָקוֹם לָהֶם בַּמָּלוֹן׃ ");
INSERT INTO hebsg_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","וְרֹעִים הָיוּ לֵנִים בַּשָּׂדֶה בָּאָרֶץ הַהִיא וְנֹטְרִים אֶת־עֶדְרֵיהֶם בְּאַשְׁמֻרוֹת הַלָּיְלָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","וְהִנֵּה מַלְאַךְ יְהוָֹה נִצָּב עֲלֵיהֶם וּכְבוֹד יְהוָֹה זָרַח לָהֶם מִסָּבִיב וַיִּירְאוּ יִרְאָה גְדוֹלָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","וַיֹּאמֶר אֲלֵיהֶם הַמַּלְאָךְ אַל־תִּירָאוּ מְבַשֵּׂר טוֹב אֲנִי לָכֶם וְרַב שָׂשׂוֹן לְכָל־הָעָם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","כִּי מוֹשִׁיעַ יֻלַּד לָכֶם הַיּוֹם הֲלֹא הוּא הַמָּשִׁיחַ הָאָדוֹן בְּעִיר דָּוִד׃ ");
INSERT INTO hebsg_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","וְזֶה לָכֶם הָאוֹת כִּי תִמְצְאוּ יֶלֶד בַּחֲתוּלָתוֹ שֹׁכֵב בָּאֵבוּס׃ ");
INSERT INTO hebsg_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","וּפִתְאֹם נִרְאוּ עִם־הַמַּלְאָךְ הֲמוֹן צְבָא הַשָּׁמָיִם מְזַמְּרִים לֵאלֹהִים וְאֹמְרִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","כָּבוֹד לֵאלֹהִים בַּמָּרוֹם שָׁלוֹם עֲלֵי־אָרֶץ וְלִבְנֵי אָדָם רָצוֹן׃ ");
INSERT INTO hebsg_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","וַיְהִי כַּאֲשֶׁר עָלוּ מֵעֲלֵיהֶם הַמַּלְאָכִים הַשָּׁמָיְמָה וַיֹּאמְרוּ הָרֹעִים אִישׁ אֶל־רֵעֵהוּ נֵלְכָה־נָּא עַד בֵּית־לֶחֶם וְנִרְאֶה אֶת־הַדָּבָר הַנַּעֲשָׂה שָּׁם אֲשֶׁר הוֹדִיעַ לָנוּ יְהוָֹה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","וַיָּחִישׁוּ וַיָּבֹאוּ וַיִּמְצְאוּ אֶת־מִרְיָם וְאֶת־יוֹסֵף וְהַיֶּלֶד שֹׁכֵב בָּאֵבוּס׃ ");
INSERT INTO hebsg_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","וַיִּרְאוּ וַיַּשְׁמִיעוּ אֶת־הַדָּבָר אֲשֶׁר הֻגַּד לָהֶם עַל־הַיֶּלֶד הַזֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","וַיִּתְמְהוּ הַשֹּׁמְעִים עַל־הַדְּבָרִים אֲשֶׁר־הִגִּידוּ לָהֶם הָרֹעִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","וּמִרְיָם שָׁמְרָה אֶת־כָּל־הַדְּבָרִים הָאֵלֶּה וַתֶּהְגֶּה בָּם בְּלִבָּהּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","וְהָרֹעִים שָׁבוּ וַיִּתְּנוּ כָבוֹד וָעֹז לֵאלֹהִים עַל־כֹּל אֲשֶׁר שָׁמְעוּ וְרָאוּ כְּפִי־אֲשֶׁר דִּבֶּר אֲלֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","וְכִמְלֹאת שְׁמֹנַת יָמִים לְהִמּוֹלוֹ וַיִּקָרֵא שְׁמוֹ יֵשׁוּעַ כַּשֵּׁם אֲשֶׁר קָרָא־לוֹ הַמַּלְאָךְ טֶרֶם נוֹצַר בַּבָּטֶן׃ ");
INSERT INTO hebsg_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","וְכַאֲשֶׁר מָלְאוּ לָהֶם יְמֵי טָהֳרָם לְפִי תּוֹרַת משֶׁה וַיַּעֲלוּ אֹתוֹ יְרוּשָׁלַיְמָה לְהַעֲמִידוֹ לִפְנֵי יְהוָֹה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","כַּכָּתוּב בְּתוֹרַת יְהוָֹה כָּל־זָכָר פֶּטֶר רֶחֶם קָדוֹשׁ יִקָּרֵא לַיהוָֹה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","וּלְהַקְרִיב קָרְבָּן כְּמִצְוַת תּוֹרַת יְהוָֹה שְׁתֵּי־תֹרִים אוֹ שְׁנֵי בְּנֵי יוֹנָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","וְהִנֵּה אִישׁ הָיָה בִּירוּשָׁלַיִם וּשְׁמוֹ שִׁמְעוֹן אִישׁ צַדִּיק וְחָסִיד וּמְחַכֶּה לְנֶחָמַת יִשְׁרָאֵל וְרוּחַ הַקֹּדֶשׁ נָחָה עָלָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","וְדָבָר נִגְלָה לּוֹ בְּרוּחַ הַקֹּדֶשׁ כִּי לֹא יִרְאֶה־מָּוֶת עַד־אֲשֶׁר יִרְאֶה אֶת־מְשִׁיחַ יְהוָֹה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","וַיָּבֹא בָרוּחַ אֶל־הַמִּקְדָּשׁ וְהָאָבוֹת הֵבִיאוּ אֶת־הַיֶּלֶד יֵשׁוּעַ לַעֲשׂוֹת לוֹ כְּפִי־מִשְׁפַּט הַתּוֹרָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","וַיִּקָחֵהוּ עַל־זְרֹעֹתָיו וַיְבָרֶךְ אֶת־הָאֱלֹהִים וַיֹּאמַר׃ ");
INSERT INTO hebsg_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","כִּדְבָרְךָ יְהוָֹה הַיּוֹם תֶּאֱסֹף אֶת־עַבְדְּךָ בְּשָׁלוֹם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","כִּי יְשׁוּעָתְךָ רָאוּ עֵינָי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","אֲשֶׁר הֲכִינֹתָ לִפְנֵי כָּל־הָעַמִּים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","אוֹר לְהָאִיר לַגּוֹיִם וּכְבוֹד יִשְׁרָאֵל עַמֶּךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","וַיִּתְמְהוּ יוֹסֵף וְאִמּוֹ עַל־הַדְּבָרִים הַנֶּאֱמָרִים עָלָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","וַיְבָרֶךְ אֹתָם שִׁמְעוֹן וַיֹּאמֶר אֶל־מִרְיָם אִמּוֹ הַיֶּלֶד הַזֶּה נִצָּב לְמַפֶּלֶת רַבִּים בְּיִשְׂרָאֵל וְלִתְקוּמָתָם וּלְאוֹת מְדָנִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","וּבְנַפְשֵׁךְ תַּעֲבֹר חֶרֶב חֹדֶרֶת לְהִתְגַּלּוֹת חִקְרֵי־לֵב רַבִּים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","וְאִשָּׁה נְבִיאָה הָיְתָה שָּׁם חַנָּה בַּת־פְּנוּאֵל לְמַטֵּה אֲשֵׁר הִיא זְקֵנָה בָּאָה בַיָּמִים וְשֶׁבַע שָׁנִים יָשְׁבָה עִם־בַּעְלָהּ מִיּוֹם אֲשֶׁר לְקָחָהּ בִּבְתוּלֶיהָ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","וְהָאַלְמָנָה הַזֹּאת כְּבַת אַרְבַּע וּשְׁמֹנִים שָׁנָה לֹא מָשָׁה מִבֵּית הָאֱלֹהִים בַּעֲבֹדָתָהּ לְפָנָיו בְּצוֹם וּבִתְפִלָּה לַיְלָה וָיוֹם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","וַתָּקָם בָּעֵת הַהִיא וַתְּבָרֶךְ אֶת־הָאֱלֹהִים וַתְּדַבֵּר עָלָיו אֶל־כָּל־אֲשֶׁר חִכָּה לִגְאֻלַּת יְרוּשָׁלָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","כְּכַלּוֹתָם לַעֲשׂוֹת כָּל־הַמִּצְוָה כְּפִי־תוֹרַת יְהוָֹה וַיָּשׁוּבוּ הַגָּלִילָה אֶל־נְצֶרֶת עִירָם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","וַיִּגְדַּל הַיֶּלֶד וַיֶּחֱזַק בָּרוּחַ וַיִמָּלֵא חָכְמָה גַּם־חֵן אֱלֹהִים הוּצַק עָלָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","וַיַעֲלוּ אֲבוֹתָיו יְרוּשָׁלַיְמָה מִדֵּי שָׁנָה בְשָׁנָה לָחֹג חַג־הַפָּסַח׃ ");
INSERT INTO hebsg_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","וּבִהְיוֹתוֹ בֶּן־שְׁתֵּים עֶשְׁרֵה שָׁנָה וַיַּעֲלוּ עִמּוֹ כְּמִשְׁפַּט הֶחָג׃ ");
INSERT INTO hebsg_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","וַיִּמָּלְאוּ הַיָּמִים וַיָּשׁוּבוּ לְדַרְכָּם וַיִּוָּתֵר הַנַּעַר יֵשׁוּעַ בִּירוּשָׁלַיִם וְיוֹסֵף וְאִמּוֹ לֹא יָדָעוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","וּבְחָשְׁבָם כִּי עִם־חֶבֶל אֹרְחִים הָלַךְ וַיֵּלְכוּ כְּדֶרֶךְ־יוֹם וַיְבַקְשֻׁהוּ בֵּין קְרוֹבֵיהֶם וּמְיֻדָּעֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","וְאַחֲרֵי אֲשֶׁר לֹא מָצְאוּ אֹתוֹ שָׁבוּ וַיְבַקְשֻׁהוּ בִּירוּשָׁלָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","וַיְהִי אַחֲרֵי שְׁלֹשֶׁת יָמִים וַיִּמְצְאוּ אֹתוֹ ישֵׁב בְּתוֹךְ הַמּוֹרִים בַּמִּקְדָּשׁ שֹׁמֵעַ אֶת־תּוֹרָתָם וְשֹׁאֵל אֹתָם שְׁאֵלוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","וְכָל־שֹׁמְעָיו תָּמָהוּ עַל־חָכְמָתוֹ וְעַל־תְּשׁוּבֹתָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","וַיְהִי כִּרְאוֹתָם אֹתוֹ וַיִּשְׁתָּאוּ וַתֹּאמֶר אֵלָיו אִמּוֹ מַה־זֹּאת עָשִׂיתָ לָּנוּ בְּנִי הֲלֹא בִּקַּשְׁנוּךָ גַּם־אָבִיךָ גַּם־אֲנִי בִּדְאָגָה גְדוֹלָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","וַיֹּאמֶר אֲלֵיהֶם מַדּוּעַ בִּקַּשְׁתֶּם אֹתִי הַאִם לֹא יְדַעְתֶּם כִּי עָלַי לִהְיוֹת בְּבֵית אָבִי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","וְלֹא הֵבִינוּ אֶת־הַדָּבָר אֲשֶׁר דִּבֶּר אֲלֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","וַיֵּרֶד אִתָּם וַיָּבֹא אֶל־נְצָרֶת וַיְהִי סָר אֶל־מִשְׁמַעְתָּם וְאִמּוֹ שָׁמְרָה אֵת כָּל־הַדְּבָרִים הָאֵלֶּה בְּלִבָּהּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","וְיֵשׁוּעַ הֹלֵךְ וְגָדֵל בְּחָכְמָה וּבְקוֹמָה וּבְחֵן עִם־אֱלֹהִים וְעִם־אֲנָשִׁים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","בִּשְׁנַת חֲמֵשׁ עֶשְׂרֵה לְמַלְכוּת טִבַרְיוֹס קֵיסָר בִּימֵי פוֹנְטִיּוֹס פִּילָטוֹס פַּחַת יְהוּדָה וְהוֹרְדוֹס טֶטְרַרְךְ בַּגָּלִיל וּפִילִפּוֹס אָחִיו טֶטְרַרְךְ בְּפֶלֶךְ יְטוּר וּפֶלֶךְ טַרְכוֹנָה וְלוּסָנִיָּס טֶטְרַרְךְ בְּאָבֵל׃ ");
INSERT INTO hebsg_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","וּבִהְיוֹת חָנָן וְקַיָּפָא הַכֹּהֲנִים הַגְּדוֹלִים הָיֹה הָיָה דְבַר אֱלֹהִים אֶל־יוֹחָנָן בֶּן־זְכַרְיָהוּ בַּמִּדְבָּר׃ ");
INSERT INTO hebsg_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","וַיָּבֹא אֶל־כָּל־כִּכַּר הַיַּרְדֵּן וַיִּקְרָא אֶל־הָעָם לָשׁוּב מִדַּרְכָּם וּלְהִטָּבֵל לִסְלִיחַת עֲוֹנָם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","כַּכָּתוּב בְּסֵפֶר דִּבְרֵי יְשַׁעְיָהוּ הַנָּבִיא קוֹל קֹרֵא בַּמִּדְבָּר פַּנּוּ דֶּרֶךְ יְהוָֹה יַשְּׁרוּ מְסִלּותָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","כָּל־גֶּיא יִנָּשֵׂא וְכָל־הַר וְגִבְעָה יִשְׁפָּלוּ וְהָיָה הֶעָקֹב לְמִשׁוֹר וְהָרְכָסִים לְבִקְעָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","וְרָאוּ כָּל־בָּשָׂר אֵת יְשׁוּעַת אֱלֹהֵינוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","וַיֹּאמֶר אֶל־הֲמוֹן הָעָם אֲשֶׁר בָּאוּ אֵלָיו לְהִטָּבֵל יַלְדֵי צִפְעֹנִים מִי הוֹרָה אֶתְכֶם לְהִמָּלֵט עַל־נַפְשְׁכֶם מִפְּנֵי חֲרוֹן אַף הַבָּא׃ ");
INSERT INTO hebsg_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","לָכֵן עֲשׂוּ פְרִי־טוֹב לִתְשׁוּבָה וְאַל־תֶּהְגוּ בִלְבַבְכֶם לֵאמֹר אַבְרָהָם לָנוּ לְאָב כִּי אֲנִי אֹמֵר לָכֶם גַּם מִן־אֲבָנִים אֵלֶּה תַּשִּׂיג יַד־אֱלֹהִים לְהָקִים בָּנִים לְאַבְרָהָם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","וְגַם־כְּבָר נָטוּי הַגַּרְזֶן עַל־שֹׁרֶשׁ הָעֵצִים וְלָכֵן כָּל־עֵץ אֲשֶׁר לֹא יַעֲשֶׂה פְרִי־טוֹב יִגָּדַע וְהָשְׁלַךְ בְּמוֹ־אֵשׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","וַיִּשְׁאֲלוּ אֹתוֹ הֲמוֹן הָעָם לֵאמֹר וּמַה לָנוּ לַעֲשׂוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","וַיַּעַן וַיֹּאמֶר אֲלֵיהֶם מִי אֲשֶׁר־לוֹ כֻּתֳּנוֹת שְׁתַּיִם יַחֲלֹק עִם־הָאִישׁ אֲשֶׁר אֵין־לוֹ וּמִי אֲשֶׁר־לוֹ מָזוֹן יַעֲשֶׂה כְמוֹ־כֵן׃ ");
INSERT INTO hebsg_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","וַיָּבֹאוּ אֵלָיו גַּם־מוֹכְסִים לִטְבִילָתוֹ וַיֹּאמְרוּ אֵלָיו רַבֵּנוּ מַה־נַּעֲשֶׂה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","וַיֹּאמֶר אֲלֵיהֶם יֶתֶר עַל־מֶכֶס הַנָּקוּב לָכֶם אַל־תִּנְגֹּשׂוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","וַיִּשְׁאֲלוּ אֹתוֹ גַּם־אַנְשֵׁי הַצָּבָא לֵאמֹר וַאֲנַחְנוּ מַה־נַּעֲשֶׂה וַיֹּאמֶר אֲלֵיהֶם אַל־תַּעַשְׁקוּ וְאַל־תּוֹנוּ אִישׁ וְדַי לָכֶם כִּי תַשִּׂיגוּ שְׂכַרְכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","וּבְעוֹד הָעָם הָיוּ מְחַכִּים וְכֻלָּם דֹּבְרִים בְּלִבָּם אִם לֹא יוֹחָנָן הוּא הַמָּשִׁיחַ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","וַיַּעַן יוֹחָנָן וַיֹּאמֶר אֲלֵיהֶם הֶן־אֲנִי מְטַבֵּל אֶתְכֶם בַּמָּיִם אַךְ בֹּא יָבֹא חָסֹן מִמֶּנִּי אֲשֶׁר קָטֹנְתִּי מֵהַתֵּר אֶת־שְׂרוֹךְ נְעָלָיו וְהוּא יְטַבֵּל אֶתְכֶם בְּרוּחַ הַקֹּדֶשׁ וּבָאֵשׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","אֲשֶׁר מִזְרֵהוּ בְיָדוֹ לִזְרוֹת וּלְהָבֵר אֶת־גָּרְנוֹ וְאָסַף אֶת־הַחִטִּים אֶל־תּוֹךְ אֲסָמָיו וְאֶת־הַמֹּץ יִשְׂרֹף בָּאֵשׁ אֲשֶׁר לֹא־תִכְבֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","כָּהֵנָּה וְכָהֵנָּה הִזְהִיר מְבַשֵּׂר טוֹב הַזֶּה אֶת־הָעָם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","וְהוֹרְדוֹס טֶטְרַרְךְ אֲשֶׁר הוּכַח עַל־דְּבַר הוֹרוֹדְיָה אֵשֶׁת אָחִיו וְעַל־כָּל־הָרָעוֹת אֲשֶׁר עָשָׂה הוֹרְדוֹס׃ ");
INSERT INTO hebsg_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","הוֹסִיף עַל־כָּל־אֵלֶּה וַיַּסְגֵּר אֶת־יוֹחָנָן בְּבֵית הָאֲסוּרִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","וַיְהִי בְּהִטָּבֵל כָּל־הָעָם וַיִּטָּבֵל גַּם־יֵשׁוּעַ וְהַשָּׁמַיִם נִפְתְּחוּ בְּהִתְפַּלְּלוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","וַיֵּרֶד עָלָיו רוּחַ הַקֹּדֶשׁ בִּדְמוּת גּוּף יוֹנָה וְהִנֵּה קוֹל קֹרֵא מִן־הַשָּׁמַיִם אַתָּה הוּא בְּנִי יְדִידִי בְּךָ רָצְתָה נַפְשִׁי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","וְיֵשׁוּעַ הָיָה כְּבֶן־שְׁלֹשִׁים שָׁנָה בְּהַחִלּוֹ אֶת־עֲבֹדַתוֹ וַיַּחְשְׁבֻהוּ לְבֶן־יוֹסֵף בֶּן־עֵלִי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","בֶּן־מַתָּת בֶּן־לֵוִי בֶּן־מַלְכִּי בֶּן־יַנַּי בֶּן־יוֹסֵף׃ ");
INSERT INTO hebsg_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","בֶּן־מַתִּתְיָהוּ בֶּן־אָמוֹץ בֶּן־נַחוּם בֶּן־חֶסְלִי בֶּן־נַגָּי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","בֶּן־מַחַת בֶּן־מַתִּתְיָהוּ בֶּן שִׁמְעִי בֶּן־יוֹסֵף בֶּן־יוֹדָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","בֶּן־יוֹחָנָן בֶּן־רֵישָׁא בֶּן־זְרֻבָּבֶל בֶּן־שְׁאַלְתִּיאֵל בֶּן־נֵרִי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","בֶּן־מַלְכִּי בֶּן־אַדִּי בֶּן־קוֹסָם בֶּן־אַלְמוֹדָם בֶּן־עֵר׃ ");
INSERT INTO hebsg_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","בֶּן־יֵשׁוּעַ בֶּן־אֱלִיעֶזֶר בֶּן־יוֹרִים בֶּן־מַתָּת בֶּן־לֵוִי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","בֶּן־שִׁמְעוֹן בֶּן־יְהוּדָה בֶּן־יוֹסֵף בֶּן־יוֹנָם בֶּן־אֶלְיָקִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","בֶּן־מַלְיָא בֶּן־מִינָא בֶּן־מַתַּתָּה בֶּן־נָתָן בֶּן־דָוִד׃ ");
INSERT INTO hebsg_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","בֶּן־יִשַׁי בֶּן־עוֹבֵד בֶּן־בֹּעַז בֶּן־שַׂלְמוֹן בֶּן־נַחְשׁוֹן׃ ");
INSERT INTO hebsg_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","בֶּן־עַמִּינָדָב בֶּן־אַרְנִי בֶּן־חֶצְרוֹן בֶּן־פֶּרֶץ בֶּן־יְהוּדָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","בֶּן־יַעֲקֹב בֶּן־יִצְחָק בֶּן־אַבְרָהָם בֶּן־תֶּרַח בֶּן־נָחוֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","בֶּן־שְׂרוּג בֶּן־רְעוּ בֶּן־פֶּלֶג בֶּן־עֵבֶר בֶּן־שָׁלַח׃ ");
INSERT INTO hebsg_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","בֶּן־קֵינָן בֶּין־אַרְפַּכְשַׁד בֶּן־שֵׁם בֶּן־נֹחַ בֶּן־לָמֶךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","בֶּן־מְתוּשֶׁלַח בֶּן־חֲנוֹךְ בֶּן־יֶרֶד בֶּן־מַהֲלַלְאֵל בֶּן־קֵינָן׃ ");
INSERT INTO hebsg_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","בֶּן־אֱנוֹשׁ בֶּן־שֵׁת בֶּן־אָדָם בֶּן־אֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","וְיֵשׁוּעַ שָׁב מִן־הַיַּרְדֵּן מָלֵא רוּחַ הַקֹּדֶשׁ וַיּוֹבִילֵהוּ הָרוּחַ הַמִּדְבָּרָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","וְשָׁם נִסָּה אֹתוֹ הַשָּׂטָן אַרְבָּעִים יוֹם וְלֹא־אָכַל מְאוּמָה עַד־תֹּם כָּל־הַיָּמִים הָהֵם וַיִּרְעָב׃ ");
INSERT INTO hebsg_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","וַיֹּאמֶר אֵלָיו הַשָּׂטָן אִם בֶּן־הָאֱלֹהִים אַתָּה אֱמֹר־נָא אֶל־הָאֶבֶן הַזֹּאת וּתְהִי לְלָחֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","וַיַּעַן אֹתוֹ יֵשׁוּעַ הֵן כָּתוּב כִּי לֹא עַל־הַלֶּחֶם לְבַדּוֹ יִחְיֶה הָאָדָם כִּי עַל־כָּל־מוֹצָא פִּי־יְהוָֹה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","וַיַּעֲלֵהוּ וַיַּרְאֵהוּ אֶת־כָּל־מַמְלְכוֹת הָאָרֶץ בְּרֶגַע אֶחָד׃ ");
INSERT INTO hebsg_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","וַיֹּאמֶר אֵלָיו הַשָּׁטָן לְךָ אֶתֵּן אֶת־כָּל־הַמֶּמְשָׁלָה הַזֹּאת וְאֶת־כָּל־כְּבוֹדָהּ כִּי לִי נְתוּנָה וְלַאֲשֶׁר אֶחְפֹּץ אֶתְּנֶנָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","וְעַל־כֵּן אִם תִּשְׁתַּחֲוֶה לְפָנָי כָּל־הַכָּבוֹד הַזֶּה לְךָ יִהְיֶה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","וַיַּעַן יֵשׁוּעַ וַיֹּאמֶר אֵלָיו סוּר מִמֶּנִי הַשָּׂטָן כִּי כָּתוּב לַיהוָֹה אֱלֹהֶיךָ תִּשְׁתַּחֲוֶה וְאֹתוֹ לְבַדּוֹ תַּעֲבֹד׃ ");
INSERT INTO hebsg_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","וַיְבִיאֵהוּ יְרוּשָׁלַיְמָה וַיַּעֲמִדֵהוּ עַל־פִּנַּת גַּג בֵּית־הַמִּקְדָּשׁ וַיֹּאמֶר אֵלָיו אִם בֶּן־הָאֱלֹהִים אַתָּה הִתְנַפֵּל מִזֶּה אָרְצָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","כִּי כָתוּב כִּי מַלְאָכָיו יְצַוֶּה־לָּךְ לְשָׁמְרֶךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","עַל־כַּפַּיִם יִשָּׂאוּנְךָ פֶּן־תִּגֹּף בָּאֶבֶן רַגְלֶךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","וַיַּעַן יֵשׁוּעַ וַיֹּאמֶר אֵלָיו הֵן נֶאֱמַר לֹא תְנַסֶּה אֶת־יְהוָֹה אֱלֹהֶיךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","וְכַאֲשֶׁר כִּלָּה הַשָּׂטָן אֶת־הַמַּסּוֹת וַיִּרֶף מִמֶּנּוּ עַד־עֵת׃ ");
INSERT INTO hebsg_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","וַיָּשָׁב יֵשׁוּעַ בִּגְבוּרַת הָרוּחַ אֶל־הַגָּלִיל וְשָׁמְעוֹ יָצָא בְּכָל־הַכִּכָּר׃ ");
INSERT INTO hebsg_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","וְהוּא הוֹרָה לָהֶם בְּבָתֵּי־הַכְּנֵסֶת וְכֻלָּם נָתְנוּ לוֹ כָּבוֹד׃ ");
INSERT INTO hebsg_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","וַיָּבֹא אֶל־נְצֶרֶת אֲשֶׁר הוּא גֻּדַּל שָׁם וַיֵּלֶךְ אֶל־בֵּית־הַכְּנֵסֶת בְּיוֹם הַשַּׁבָּת כְּמִשְׁפָּטוֹ וַיָּקָם לִקְרֹא׃ ");
INSERT INTO hebsg_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","וַיִּתְּנוּ לוֹ סֵפֶר יְשַׁעְיָה הַנָּבִיא וַיִּפְתַּח אֶת־הַסֵּפֶר וַיִּמְצָא אֶת־הַדָּבָר הַכָּתוּב שָׁמָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","רוּחַ אֲדֹנָי יֱהוִֹה עָלָי יַעַן מָשַׁח יְהוָֹה אֹתִי לְבַשֵּׂר עֲנָוִים שְׁלָחַנִי לַחֲבשׁ לְנִשְׁבְּרֵי־לֵב לִקְרֹא לִשְׁבוּיִם דְּרוֹר וּלְעִוְרִים פְּקַח־קוֹחַ לְשַׁלַּח רְצוּצִים חָפְשִׁים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","לִקְרֹא שְׁנַת־רָצוֹן לַיהוָֹה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","וַיָּגֶל אֶת־הַסֵּפֶר וַיִּתְּנֵהוּ בִּידֵי הַמְשָׁרֵת וַיֵּשֵׁב וְעֵינֵי כָּל־אֲשֶׁר בְּבֵית־הַכְּנֵסֶת נְשֻׂאוֹת אֵלָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","וַיַּעַן וַיֹּאמֶר אֲלֵיהֶם הוּקַם הַכָּתוּב הַזֶּה הַיּוֹם בְּאָזְנֵיכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","וְכֻלָּם נָשְׂאוּ לוֹ עֵדוּת כִּי נִפְלְאוּ בְעֵינֵיהֶם דִּבְרֵי־חֵן אֲשֶׁר יָצְאוּ מִפִּיו וַיֹּאמְרוּ הֲלֹא זֶה הוּא בֶן־יוֹסֵף׃ ");
INSERT INTO hebsg_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","וַיֹּאמֶר אֲלֵיהֶם אָכֵן תֹּאמְרוּ לִי אֶת־הַמָּשָׁל הַהוּא רֹפֵא רְפָא אֶת־נַפְשֶׁךָ וּכְכֹל אֲשֶׁר שָׁמַעְנוּ כִּי נַעֲשָׂה בִּכְפַר־נַחוּם עֲשֵׂה־כֵן גַּם־הֲלֹם בְּעִירֶךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","וַיֹּאמַר הֵן דְּבַר אֱמֶת אֲנִי מַגִּיד לָכֶם אֵין נָבִיא רָצוּי בְּאֶרֶץ מוֹלַדְתּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","אָמֵן אֲנִי אֹמֵר לָכֶם אַלְמָנוֹת רַבּוֹת הָיוּ בְיִשְׂרָאֵל בִּימֵי אֵלִיָּהוּ בְּהֵעָצֵר הַשָּׁמַיִם שָׁלֹשׁ שָׁנִים וְשִׁשָּׁה חֳדָשִׁים וְרָעָב גָּדוֹל הָיָה בְכָל־הָאָרֶץ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","וְלֹא שֻׁלַּח אֵלִיָּהוּ אֶל־אַחַת מֵהֶן בִּלְתִּי אֶל־אִשָּׁה אַלְמָנָה בְּצָרְפַת אֲשֶׁר לְצִידוֹן׃ ");
INSERT INTO hebsg_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","וּמְצֹרָעִים רַבִּים הָיוּ בְיִשְׂרָאֵל בִּימֵי אֱלִישָׁע הַנָּבִיא וְלֹא נִרְפָּא אֶחָד מֵהֶם בִּלְתִּי אִם־נַעֲמָן הָאֲרַמִּי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","וַיִּמָּלְאוּ כֻלָּם חֵמָה בְּבֵית־הַכְּנֵסֶת בְּשָׁמְעָם אֶת־אֵלֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","וַיָּקוּמוּ וַיּוֹצִיאֻהוּ אֶל־מִחוּץ לָעִיר וַיְבִיאֻהוּ אֶל־גַּב הָהָר אֲשֶׁר עִירָם בְּנוּיָה עָלָיו לְהַשְׁלִיכוֹ אֶל־מִתַּחַת לָהָר׃ ");
INSERT INTO hebsg_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","אַךְ־הוּא עָבַר בְּתוֹכָם וַיֵּלֶךְ לְדַרְכּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","וַיֵּרֶד אֶל־כְּפַר־נַחוּם עִיר הַגָּלִיל וַיְלַמֵּד לָעָם מִדֵּי שַׁבָּת בְּשַׁבַּתּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","וַיִּתְמְהוּ עַל־תּוֹרָתוֹ כִּי כִּדְבַר שִׁלְטוֹן הָיָה דְבָרוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","וְאִישׁ הָיָה בְּבֵית־הַכְּנֵסֶת וּבוֹ דָבַק רוּחַ טָמֵא וְנִתְעָב וַיִּקְרָא בְּקוֹל גָּדוֹל׃ ");
INSERT INTO hebsg_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","הֶרֶף מִמֶּנּוּ מַה־לָּנוּ וָלָךְ יֵשׁוּעַ הַנָּצְרִי הַאִם לְהַשְׁמִידֵנוּ בָּאתָ הֲלֹא יְדַעְתִּיךָ מִי אַתָּה קְדוֹשׁ הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","וַיִּגְעַר־בּוֹ יֵשׁוּעַ לֵאמֹר דּוֹם וְצֵא מִמֶּנּוּ וַיַּפִּילֵהוּ הָרוּחַ הָרָע בְּתוֹךְ הַקָּהָל וַיֵּצֵא מִמֶּנּוּ וְרָעָה לֹא עָשָׂה לוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","וּפַלָּצוּת אָחֲזָה כֻלָּם וַיֹּאמְרוּ אִישׁ אֶל־רֵעֵהוּ מָה הַדָּבָר הַזֶּה כִּי־בְשִׁלְטוֹן וּבִגְבוּרָה הוּא מְצַוֶּה אֶת־רוּחוֹת הַטֻּמְאָה וְהֵן יֹצְאוֹת מִבַּעְלֵיהֶן׃ ");
INSERT INTO hebsg_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","וַיֵּצֵא שָׁמְעוֹ בְּכָל־הַכִּכָּר לְכָל־קְצוֹתָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","וַיָּקָם וַיֵּצֵא מִבֵּית־הַכְּנֵסֶת וַיָּבֹא בֵּיתָה שִׁמְעוֹן וְחֹתֶנֶת שִׁמְעוֹן שֹׁכֶבֶת חוֹלַת קַדַּחַת אֲנוּשָׁה וַיִּפְגְּעוּ־בוֹ בַּעֲדָהּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","וַיִּתְיַצֵּב עָלֶיהָ וַיִּגְעַר בַּקַּדַּחַת וַתִּרֶף מִמֶּנָּה וּכְרֶגַע קָמָה וַתְּשָׁרֵת אֹתָם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","וּכְבֹא הַשֶּׁמֶשׁ הֵבִיאוּ אֵלָיו כָּל־אֵלֶּה אֲשֶׁר אַנְשֵׁי מַכְאֹבוֹת לָהֶם וִידוּעֵי חֳלָיִים שׁוֹנִים וַיָּשֶׂם אֶת־יָדָיו עַל־כָּל־אֶחָד מֵהֶם וַיִּרְפָּאֵם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","וְגַם־רוּחוֹת רָעִים יָצְאוּ מֵרַבִּים קֹרְאִים וְאֹמְרִים אַתָּה הוּא הַמָּשִׁיחַ בֶּן־הָאֱלֹהִים אַךְ הוּא גָעַר בָּם וְלֹא נְתָנָם לְדַבֵּר כִּי יָדְעוּ אֲשֶׁר הוּא הַמָּשִׁיחַ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","וְכַעֲלוֹת הַשַּׁחַר יָצָא וַיֵּלֶךְ אֶל־מָקוֹם חָרֵב וַהֲמוֹן הָעָם בִּקְשֻׁהוּ וַיָּבֹאוּ אֵלָיו וַיַּחֲזִיקוּ־בוֹ לְבִלְתִּי יַעֲבֹר מֵהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","אַךְ הוּא אָמַר אֲלֵיהֶם הֵן עָלַי לְהַשְׁמִיעַ אֶת־מַלְכוּת הָאֱלֹהִים גַּם־בְּעָרִים אֲחֵרוֹת כִּי עַל־כֵּן שֻׁלָּחְתִּי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","וַיְהִי קוֹרֵא אֶת־בְּשׁרָתוֹ בְּבָתֵּי־הַכְּנֵסֶת אֲשֶׁר בַּגָּלִיל׃ ");
INSERT INTO hebsg_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","וַיְהִי בְּעָמְדוֹ עַל־יַד יַם־גִּנֵּיסָר וַהֲמוֹן הָעָם יִדְחֲקוּן אֹתוֹ וַיִּשְׁמְעוּ אֶת־דְּבַר הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","וַיַּרְא שְׁתֵּי אֳנִיּוֹת עֹמְדוֹת עַל־שְׂפַת הַיָּם וְהַדַּיָּגִים יָצְאוּ מֵהֶן לְכַבֵּס אֶת־הַמִּכְמֹרוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","וַיֵּרֶד אֶל־אַחַת מִן־הָאֳנִיּוֹת אֲשֶׁר לְשִׁמְעוֹן וַיְבַקְשֵׁהוּ לְהַעֲבִירוֹ מְעַט מִן־הַיַּבָּשָׁה וַיֵּשֶׁב וַיְלַמֵּד לַהֲמוֹן הָעָם מִתּוֹךְ הָאֳנִיָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","וְכַהֲתִימוֹ לְלַמֵּד וַיֹּאמֶר אֶל־שִׁמְעוֹן נְהַג אֶל־פְּנֵי הַמְּצוּלָה וְהַשְׁלִיכוּ מִכְמֹרוֹתֵיכֶם לָצוּד שָׁמָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","וַיַּעַן שִׁמְעוֹן וַיֹּאמֶר אֵלָיו אֲדֹנִי יָגַעְנוּ כָּל־הַלַּיְלָה וְלֹא לָכַדְנוּ מְאוּמָה אַךְ עַל־דְּבָרְךָ אַשְׁלִיךְ אֶת־הַמִּכְמֹרוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","וַיַּעֲשׂוּ־כֵן וַיִּלְכְּדוּ דָגִים רַבִּים מְאֹד עַד־אֲשֶׁר מִכְמֹרוֹתָם נִקְרָעוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","וַיִּתְּנוּ אוֹת לְחַבְרֵיהֶם אֲשֶׁר בָּאֳנִיָּה הַשֵּׁנִית לָבֹא וְלַעֲזֹר לָהֶם וַיָּבֹאוּ וַיְמַלְאוּ אֶת־שְׁתֵּי הָאֳנִיּוֹת עַד־לִשְׁקֹעַ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","וַיַּרְא שִׁמְעוֹן פֶּטְרוֹס וַיִּפֹּל לְרַגְלֵי יֵשׁוּעַ וַיֹּאמַר אֲדֹנִי לֵךְ מֵעָלַי כִּי־אִישׁ חֵטְא אָנֹכִי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","כִּי חִיל אָחַז אֹתוֹ וְאֶת־כֹּל אֲשֶׁר אִתּוֹ עַל־צֵיד הַדָּגִים אֲשֶׁר צָדוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","וְכֵן גַּם־הִתְחַלְחֲלוּ יַעֲקֹב וְיוֹחָנָן בְּנֵי זַבְדִּי חַבְרֵי שִׁמְעוֹן וַיֹּאמֶר יֵשׁוּעַ אֶל־שִׁמְעוֹן אַל־תִּירָא כִּי מֵהַיּוֹם וָמַעְלָה תָּצוּד אֲנָשִׁים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","וְהֵם הוֹלִיכוּ אֶת־הָאֳנִיּוֹת אֶל־הַיַּבָּשָׁה וַיַּעַזְבוּ אֶת־כֹּל וַיֵּלְכוּ אַחֲרָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","וַיְהִי בְּלֶכְתּוֹ בְּאַחַת הֶעָרִים וְהִנֵּה־אִישׁ לִקְרָאתוֹ אֲשֶׁר בְּשָׂרוֹ מָלֵא צָרָעַת וּבִרְאוֹתוֹ אֶת־יֵשׁוּעַ נָפַל עַל־אַפָּיו וַיִּתְחַנֶּן־לוֹ לֵאמֹר אֲדֹנִי אִם־חָפֵץ אַתָּה הֲלֹא תוּכַל לְטַהֲרֵנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","וַיּוֹשֶׁט אֶת־יָדוֹ וַיִּגַּע־בּוֹ וַיֹּאמֶר חָפֵץ אֲנִי וּטְהָר וְהַצָּרַעַת סָרָה מִמֶּנּוּ כְּרָגַע׃ ");
INSERT INTO hebsg_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","וַיְצַו עָלָיו לְבִלְתִּי הַגֵּד לְאִישׁ רַק לֵךְ וְהֵרָאֵה לְעֵינֵי הַכֹּהֵן וְהַקְרֵב אֶת־הַקָּרְבָּן עַל־טָהֳרָתְךָ כַּאֲשֶׁר צִוָּה מֹשֶׁה לְעֵדוּת לָהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","וּבְכָל־זֹאת שָׁמְעוֹ יָצָא יָצוֹא וְגָדֵל וְעַם־רָב נִקְהֲלוּ לִשְׁמֹעַ דְּבָרוֹ וְלִמְצֹא מָזוֹר לְמַחֲלָתָם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","אַךְ הוּא חָמַק עָבַר אֶל־הַמִּדְבָּר לְהִתְפַּלֵּל׃ ");
INSERT INTO hebsg_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","וַיְהִי הַיּוֹם בְּהוֹרֹתוֹ אֶת־הָעָם וַיֵּשְׁבוּ לְפָנָיו פְּרוּשִׁים וּמוֹרֵי הַתּוֹרָה אֲשֶׁר בָּאוּ מִכָּל־כְּפָרֵי הַגָּלִיל מִיהוּדָה וּמִירוּשָׁלַיִם וּגְבוּרַת יְהוָֹה הִתְנֹסְסָה בוֹ לְרַפְּאוֹתָם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","וְהִנֵּה אֲנָשִׁים נֹשְׂאִים אִישׁ נְכֵה עֲצָמוֹת בַּמִּטָּה וּמְבַקְשִׁים לַהֲבִיאוֹ לְפָנָיו הַבָּיְתָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","וְלֹא־מָצְאוּ דֶרֶךְ לַהֲבִיאוֹ מֵרֹב הָעָם וַיַּעֲלוּ עַל־הַגָּג וַיּוֹרִידוּ אֹתוֹ עַל־מִטָּתוֹ דֶּרֶךְ הָאֲרֻבָּה בַּסִּפּוּן אֶל־תּוֹךְ הַבַּיִת לִפְנֵי יֵשׁוּעַ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","וּבִרְאוֹתוֹ אֶת־אֱמוּנָתָם וַיֹּאמֶר בֶּן־אָדָם נִסְלְחוּ־לְךָ חַטֹּאתֶיךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","וַיָּחֵלּוּ הַסּוֹפְרִים וְהַפְּרוּשִׁים לַהְגּוֹת בְּלִבָּם לֵאמֹר מִי הוּא זֶה הַמְדַבֵּר גִּדּוּפִים מִי יוּכַל לִסְלֹחַ חֲטָאִים בִּלְתִּי הָאֱלֹהִים לְבַדּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","וַיַּרְא יֵשׁוּעַ אֶת־הֶגְיוֹנָם וַיַּעַן וַיֹּאמֶר אֲלֵיהֶם לָמָּה־זֶּה תֶּהְגּוּ בְּלִבְּכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","כִּי מַה־נָּקֵל אִם לֵאמֹר נִסְלְחוּ־לְךָ חַטֹּאתֶיךָ אוֹ לֵאמֹר קוּם וְהִתְהַלֵּךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","אַךְ לְמַעַן תֵּדְעוּן כִּי יֵשׁ רִשְׁיוֹן לְבֶן־הָאָדָם בָּאָרֶץ לִסְלֹחַ חֲטָאִים אָז אָמַר אֶל־נְכֵה הָעֲצָמוֹת הִנֵּה אֲנִי אֹמֵר לָךְ קוּם שָׂא אֶת־מִטָּתְךָ וְלֶךְ־לְךָ אֶל־בֵּיתֶךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","וַיְמַהֵר וַיָּקָם לִפְנֵיהֶם וַיִּשָּׂא אֶת־מִשְׁכָּבוֹ וַיֵּלֶךְ אֶל־בֵּיתוֹ וְנָתוֹן כָּבוֹד לֵאלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","וּפַלָּצוּת אָחֲזָה אֶת־כֻּלָּם וַיִּתְּנוּ כָבוֹד לֵאלֹהִים וְלִבָּם מָלֵא יִרְאָה וַיֹּאמְרוּ הַיּוֹם רָאִינוּ נִפְלָאוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","וַיְהִי אַחֲרֵי הַדְּבָרִים הָאֵלֶּה וַיֵּצֵא וַיַּרְא מוֹכֵס אֶחָד יוֹשֵׁב בְּבֵית־הַמֶּכֶס וּשְׁמוֹ לֵוִי וַיֹּאמֶר אֵלָיו לֵךְ אַחֲרָי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","וַיַּעֲזֹב אֶת־כֹּל וַיָּקָם וַיֵּלֶךְ אַחֲרָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","וַיַּעַשׂ־לוֹ לֵוִי מִשְׁתֶּה גָדוֹל בְּבֵיתוֹ וּמוֹכְסִים רַבִּים עִם־אֲנָשִׁים אֲחֵרִים יָשְׁבוּ אִתָּם אֶל־הַשֻּׁלְחָן׃ ");
INSERT INTO hebsg_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","וַיִּלּוֹנוּ הַפְּרוּשִׁים וְהַסּוֹפְרִים אֲשֶׁר בָּהֶם עַל־תַּלְמִידָיו לֵאמֹר מַדּוּעַ אַתֶּם אֹכְלִים וְשֹׁתִים עִם־הַמּוֹכְסִים וְהַחַטָּאִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","וַיַּעַן יֵשׁוּעַ וַיֹּאמֶר אֲלֵיהֶם הַחֲזָקִים אֵין לָהֶם דָּבָר עִם־הָרֹפֵא כִּי אִם־הַחוֹלִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","לֹא בָאתִי לִקְרֹא צַדִּיקִים כִּי אִם־חַטָּאִים לִתְשׁוּבָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","וַיֹּאמְרוּ אֵלָיו לָמָּה תַּלְמִידֵי יוֹחָנָן מַכְבִּירִים לָצוּם וּמַרְבִּים לְהִתְפַּלֵּל וְכֵן יַעֲשׂוּ גַּם־תַּלְמִידֵי הַפְּרוּשִׁים וְתַלְמִידֶיךָ אֹכְלִים וְשֹׁתִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","וַיֹּאמֶר אֲלֵיהֶם יֵשׁוּעַ אֵיךְ תּוּכְלוּ לְאַלֵּץ אֶת־בְּנֵי הַחֲתֻנָּה לָצוּם בְּעוֹד הֶחָתָן עִמָּהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","הִנֵּה יָמִים בָּאִים וְלֻקַּח מֵהֶם הֶחָתָן וְאָז יָצֻמוּ בַּיָּמִים הָהֵם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","וַיִּשָּׂא אֲלֵיהֶם גַּם אֶת־הַמָּשָׁל הַזֶּה אֵין אִישׁ קֹרֵעַ בֶּגֶד חָדָשׁ לִתְפֹּר הַקְּרָעִים עַל־שִׂמְלָה בָלָה כִּי אִם־כֵּן הַבֶּגֶד הֶחָדָשׁ יִהְיֶה קָרֻעַ וְגַם־הַטְּלָאָה מִבֶּגֶד הֶחָדָשׁ לֹא תִשְׁוֶה לַשִּׂמְלָה הַבָּלָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","וְתִירוֹשׁ לֹא יֻתַּן בְּנֹאדוֹת בָּלִים פֶּן־יְבַקַּע הַתִּירוֹשׁ אֶת־הַנֹּאדוֹת וְנִשְׁפַּךְ הַיַּיִן וְהַנֹּאדוֹת יִכְלָיוּן׃ ");
INSERT INTO hebsg_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","אַךְ תִּירוֹשׁ יֻתַּן בְּנֹאדוֹת חֲדָשִׁים וּשְׁנֵיהֶם יַחְדָּו יִשָּׁמֵרוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","וְאֵין אִישׁ שֹׁתֶה יַיִן יָשָׁן אֲשֶׁר יָחוּשׁ יִתְאַוֶּה מִיַּד לַתִּירוֹשׁ כִּי יֹאמַר הֲלֹא הַיָּשָׁן טוֹב מִמֶּנוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","וַיְהִי בְּיוֹם הַשַּׁבָּת אַחֲרֵי תְנוּפַת הָעֹמֶר וַיֵּלֶךְ בִּשְׂדֵה קָמָה וְתַלְמִידָיו קָטְפוּ מְלִילוֹת וַיִּכְתְּשׁוּן בִּידֵיהֶם וַיֹּאכֵלוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","וַיֹּאמְרוּ אֲנָשִׁים פְּרוּשִׁים מַדּוּעַ אַתֶּם עֹשִׂים אֵת אֲשֶׁר לֹא יֵעָשֶׂה בַּשַּׁבָּת׃ ");
INSERT INTO hebsg_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","וַיַּעַן אֹתָם יֵשׁוּעַ וַיֹּאמֶר הֲלֹא קְרָאתֶם אֵת אֲשֶׁר עָשָׂה דָוִד כַּאֲשֶׁר רָעֵב הוּא וְאֵלֶּה אֲשֶׁר אִתּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","כַּאֲשֶׁר בָּא אֶל־בֵּית הָאֱלֹהִים וַיִּקַּח אֶת־לֶחֶם הַפָּנִים וַיֹּאכַל וַיִּתֵּן גַּם־לָאֵלֶּה אֲשֶׁר אִתּוֹ אֲשֶׁר לֹא־כַתּוֹרָה לָהֶם לֶאֱכֹל בִּלְתִּי לַכֹּהֲנִים לְבַדָּם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","וַיֹּאמֶר אֲלֵיהֶם עוֹד כִּי בֶּן־הָאָדָם אֲדוֹן הַשַּׁבָּת הוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","וַיְהִי בְּיוֹם שַׁבָּת אַחֵר וַיָּבֹא וַיְלַמֵּד בְּבֵית־הַכְּנֵסֶת וְשָׁם אִישׁ אֲשֶׁר יָדוֹ הַיְמָנִית יָבֵשָׁה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","וְהַסּוֹפְרִים וְהַפְּרוּשִׁים אֹרְבִים לוֹ לִרְאוֹת אִם־יִרְפָּא בַשַּׁבָּת לְבַעֲבוּר יִמְצְאוּ עָלָיו שִׂטְנָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","וַיַּרְא אֶת־מַחְשְׁבוֹתָם וַיֹּאמֶר אֶל־הָאִישׁ אֲשֶׁר יָדוֹ יְבֵשָׁה קוּם וַעֲמוֹד בְּתוֹךְ הַקָּהָל וַיָּקָם וַיַּעֲמֹד׃ ");
INSERT INTO hebsg_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","וַיֹּאמֶר אֲלֵיהֶם יֵשׁוּעַ אֶשְׁאֲלָה אֶתְכֶם שְׁאֵלָה הֲכִי כַדָּת לְהֵיטִיב בַּשַּׁבָּת אוֹ לְהָרַע לְהַצִּיל נֶפֶשׁ אוֹ לְשַׁחֲתָהּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","וַיַּשְׁקֵף אֲלֵיהֶם מִסָּבִיב וַיֹּאמֶר אֵלָיו הוֹשֵׁט אֶת־יָדְךָ וַיַּעַשׂ כֵּן וַתָּשָׁב יָדוֹ לְאֵיתָנָהּ כָּאַחֶרֶת׃ ");
INSERT INTO hebsg_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","וַיִּמָּלְאוּ חֵמָה גְדוֹלָה וַיֹּאמְרוּ אִישׁ אֶל־רֵעֵהוּ מַה־לַּעֲשׂוֹת לְיֵשׁוּעַ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","וַיְהִי בַּיָּמִים הָהֵם וַיֵּצֵא אֶל־הָהָר לְהִתְפַּלֵּל וַיַּאֲרֵךְ בִּתְפִלָּתוֹ לֵאלֹהִים כָּל־הַלָּיְלָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","וּכְאוֹר הַבֹּקֶר וַיִּקְרָא אֶל־תַּלְמִידָיו וַיִּבְחַר מֵהֶם שְׁנֵים־עָשָׂר אֲשֶׁר קָרָא אֹתָם בְּשֵׁם שְׁלִיחִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","אֶת־שִׁמְעוֹן אֲשֶׁר קָרָא לוֹ בְּשֵׁם כֵּיפָא וְאֶת־אַנְדְּרַי אָחִיו אֶת־יַעֲקֹב וְאֶת־יוֹחָנָן אֶת־פִּילִפּוֹס וְאֶת־בַּר־תַּלְמָי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","אֶת־מַתִּתְיָהוּ וְאֶת־תּוֹמָא אֶת־יַעֲקֹב בֶּן־חַלְפַּי וְאֶת־שִׁמְעוֹן אֲשֶׁר קָרָא לוֹ הַקַּנָּאִי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","אֶת־יְהוּדָה בֶּן־יַעֲקֹב וְאֶת־יְהוּדָה אִישׁ־קְרִיּוֹת הוּא הַמַּסְגִּיר אֹתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","וַיֵּרֶד אִתָּם וַיַּעֲמֹד בַּמִּישׁוֹר בְּקֶרֶב קָהָל גָּדוֹל מִתַּלְמִידָיו וְקִבּוּץ עַם־רָב מִכָּל־יְהוּדָה וִירוּשָׁלַיִם וְחוֹף צוֹר וְצִידוֹן הַבָּאִים לִשְׁמֹעַ דְּבָרָיו וְלִמְצֹא מָזוֹר לְמַחֲלָתָם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","וְאֵלֶּה הַבָּאִים אֲשֶׁר הֶעֱבִיר מֵהֶם רוּחוֹת הַטֻּמְאָה הַמְבַעֲתוֹת אֹתָם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","וְהֶהָמוֹן כֻּלָּם מְבַקְשִׁים לָגַעַת בּוֹ כִּי גְבוּרָה יָצְאָה מֵאִתּוֹ לְהַעֲלוֹת אֲרֻכָה לְכֻלָּם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","וְהוּא נָשָׂא עֵינָיו אֶל־תַּלְמִידָיו וַיֹּאמַר אַשְׁרֵיכֶם הָעֲנִיִּים כִּי־לָכֶם מַלְכוּת הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","אַשְׁרֵיכֶם הָרְעֵבִים כַּיּוֹם כִּי שָׂבֹעַ תִּשְׂבָּעוּן אַשְׁרֵיכֶם הַבֹּכִים כַּיּוֹם כִּי שָׂחֹק תִּשְׂחָקוּן׃ ");
INSERT INTO hebsg_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","אַשְׁרֵיכֶם אִם־אֲנָשִׁים יִשְׂנְאוּ יְנַדּוּ אוֹ יְגַדְּפוּ אֶתְכֶם וְאֶת־שִׁמְכֶם כְּשֵׁם רָע יִמְחוּ בַּעֲבוּר בֶּן־הָאָדָם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","שִׂמְחוּ וְגִילוּ בַּיּוֹם הַהוּא כִּי שְׂכַרְכֶם רַב בַּשָּׁמָיִם כִּי כֵן־עָשׂוּ אֲבוֹתֵיהֶם אֶל־הַנְּבִיאִים מִקֶּדֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","אַךְ־אוֹי לָכֶם עֲשִׁירִים כִּי־הִשַּׂגְתֶּם תַּנְחוּמֹתֵיכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","אוֹי לָכֶם הַשְּׂבֵעִים הַיּוֹם כִּי אַחֲרֵי־כֵן תִּרְעָבוּ אוֹי לָכֶם הַמְצַחֲקִים הַיּוֹם כִּי־נוֹעַדְתֶּם לְאֵבֶל וָבֶכִי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","אוֹי לָכֶם הַמְהֻלָּלִים בְּפִי כָּל־בְּנֵי־הָאָדָם כִּי כָּכָה עָשׂוּ אֲבוֹתֵיהֶם גַּם־לִנְבִיאֵי שָׁקֶר׃ ");
INSERT INTO hebsg_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","אֲבָל אַתֶּם הַמַּקְשִׁיבִים לְקוֹלִי לָכֶם אֲנִי אֹמֵר אֶהֱבוּ אֶת־אֹיְבֵיכֶם הֵיטִיבוּ לְשׁנְאֵיכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","בָּרְכוּ אֶת־אֹרַרֵיכֶם וְהַעְתִּירוּ בְּעַד רֹדְפֵיכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","הַמַּכְּךָ עַל־לְחִי אַחַת הַטֵּה־לוֹ גַּם־הָאַחֶרֶת הַנֹּשֵׂא מְעִילְךָ מֵעָלֶיךָ לֹא־תִמְנַע מִמֶּנוּ גַּם־כֻּתָּנְתֶּךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","תְּנָה לְכָל־שֹׁאֵל מִמְּךָ וּמֵאֵת הַלּוֶֹה לֹא־תְבַקֵּשׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","וְכָל־אֲשֶׁר תַּחְפְּצוּ שֶׁיַּעֲשׂוּן לָכֶם אֲנָשִׁים כֵּן תַּעֲשׂוּן לָהֶם גַּם־אַתֶּם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","אִם־תֶּאֱהָבוּן אֶת־אֹהֲבֵיכֶם מַה־צְּדָקָה לָכֶם הֲלֹא גַּם־הַחַטָּאִים אֶת אֹהֲבֵיהֶם יֶאֱהָבוּן׃ ");
INSERT INTO hebsg_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","וְכִי־תַעֲשׂוּ טוֹב לְמֵטִיבֵיכֶם מַה־צְּדָקָה לָכֶם הֲלֹא כְמוֹ־כֵן יַעֲשׂוּ גַּם־הַחַטָּאִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","וְאִם־תַּלְווּ אֶת־אֲנָשִׁים בְּתִקְוַתְכֶם כִּי יְשַׁלֵּמוּ לָכֶם מַה־צְּדָקָה לָכֶם גַּם־חַטָּאִים מַלְוִים חַטָּאִים כִּי גְמוּלָם יוּשַׁב לָהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","אַךְ אֶהֱבוּ אֶת־אֹיְבֵיכֶם הֵיטִיבוּ לָהֶם חִנָּם וְלֹא תְצַפּוּ לִגְמוּל אָז יִגְדַּל שְׂכַרְכֶם וִהְיִיתֶם בְּנֵי עֶלְיוֹן כִּי טוֹב הוּא לָרָעִים וְלַאֲשֶׁר טוֹבָה לֹא יַכִּירוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","הֱיוּ מְרַחֲמִים כִּי אֲבִיכֶם הוּא רַחוּם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","לֹא תִשְׁפְּטוּ אֲחֵרִים וְלֹא תִשָּׁפְטוּ מִלִּפְנֵיהֶם לֹא תַאֲשִׁימוּ אֹתָם וְלֹא יַאֲשִׁימוּ אֶתְכֶם הַצְדִּיקוּם וְיַצְדִּיקוּ אֶתְכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","תְּנוּ וְיִנָּתֵן לָכֶם מִדָּה מְלֵאָה עַל־כָּל־גְּדוֹתֶיהָ יָשִׁיבוּ אֶל־חֵיקְכֶם אֲשֶׁר יָעִיקוּ תַחְתֶּיהָ וַאֲשֶׁר יָנִיעוּ אֹתָהּ כִּי בְסַאסְּאָה אֲשֶׁר תָּמֹדּוּ בָּהּ יִמַּד לָכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","וַיִּשָּׂא מְשָׁלוֹ וַיֹּאמַר הֲיִנְהַג עִוֵּר אֶת־הָעִוֵּר הֲלֹא יִפְּלוּ שְׁנֵיהֶם אֶל־הַבּוֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","הַתַּלְמִיד לֹא יִגְדַּל מִרָבּוֹ וְאִם שָׁלֵם הוּא יְהִי כְרַבּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","לָמָּה תַבִּיט אֶל־שְׁבָבִים אֲשֶׁר בְּעֵין אָחִיךָ וְלֹא תָשֶׁת־לֵב אֶל־הַקּוֹרָה אֲשֶׁר בְּעֵינֶךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","וְאֵיךְ תֹּאמַר לְאָחִיךָ הַנִּיחֵנִי אָחִי וְאָסִירָה שְׁבָבִים מֵעֵינֶךָ וְלֹא תָשִׁית לֵב אֶל־הַקּוֹרָה אֲשֶׁר בְּעֵינְךָ גַּם־אָתָּה הָסֵר חָנֵף רִאשׁוֹנָה אֶת־הַקּוֹרָה מֵעֵינֶךָ וְאַחֲרֵי־כֵן תִּרְאֶה לְהָסִיר שְׁבָבִים מֵעֵין אָחִיךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","אֵין עֵץ טוֹב אֲשֶׁר יַעֲשֶׂה פְּרִי מָשְׁחָת וְאֵין עֵץ נִשְׁחָת אֲשֶׁר יַעֲשֶׂה פְּרִי טוֹב׃ ");
INSERT INTO hebsg_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","כִּי כָל־עֵץ וָעֵץ בְּמוֹ־פִרְיוֹ יִתְנַכָּר תְּאֵנִים לֹא יֵאָסְפוּ מִצְּנִנִים וְלֹא עֲנָבִים מֵעַקְרַבִּים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","אִישׁ טוֹב מֵאוֹצַר לִבּוֹ הַטּוֹב יוֹצִיא טוֹב וְאִישׁ רָע מֵאוֹצַר לִבּוֹ הָרָע יוֹצִיא רָע כִּי־מִמְּלֹא הַלֵּב יַבִּיעַ כָּל־פֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","וּמַדּוּעַ אַתֶּם קֹרִאים לִי בְּשֵׁם אָדוֹן אָדוֹן וְלֹא תַעֲשׂוּן אֵת אֲשֶׁר־אֲנִי מְצַוֶּה אֶתְכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","כָּל־הַבָּא אֵלַי וְשָׁמַע דְּבָרַי וְעָשָׂה אֹתָם הִנֵּה אַגִּיד לָכֶם לְמִי הוּא דוֹמֶה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","הֲלֹא דוֹמֶה הוּא לְאִישׁ בֹּנֶה בַּיִת אֲשֶׁר הֶעֱמִיק לַחְפֹּר וַיִּתֵּן יְסוּדָתוֹ בְּסָלַע וּכְבֹא מָטָר סֹחֵף וְנַחַל פָּרַץ עַל־הַבַּיִת לֹא יָכֹל לְהָנִיעַ אֹתוֹ כִּי בְסֶלַע יְסוּדָתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","אַךְ הַשֹּׁמֵעַ דְּבָרַי וְאֹתָם אֵינֶנּוּ עֹשֶׂה דּוֹמֶה הוּא לְאִישׁ בֹּנֶה בֵיתוֹ עַל־הֶעָפָר וְאֵין לוֹ יְסוֹד מִתָּחַת וּבַעֲבֹר עָלָיו שֶׁטֶף מַיִם נָפַל הַבַּיִת פִּתְאֹם וַיְהִי לְמַפֵּלָה גְדוֹלָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","כְּכַלֹּתוֹ לְדַבֵּר אֶת־דְּבָרָיו בְּאָזְנֵי הָעָם וַיָּבֹא אֶל־כְּפַר־נַחוּם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","וְשָׁם עֶבֶד לְשַׂר־מֵאָה אֶחָד חָלָה לָמוּת וְהוּא יָקָר הָיָה בְּעֵינָיו עַד־מְאֹד׃ ");
INSERT INTO hebsg_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","וּבְשָׁמְעוֹ אֶת־שֵׁמַע יֵשׁוּעַ וַיִּשְׁלַח אֵלָיו מִקְצוֹת זִקְנֵי הַיְּהוּדִים לְבַקְשׁוֹ לָבֹא וּלְרַפֵּא אֶת־עַבְדּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","וַיָּבֹאוּ אֶל־יֵשׁוּעַ וַיִּפְצְרוּ־בוֹ לֵאמֹר כִּי יָאֳתָה לּוֹ לְמַלֵּא אֶת־בַּקָּשָׁתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","כִּי אֹהֵב הוּא לְעַמֵּנוּ וּבֵית־הַכְּנֵסֶת בָּנָה־לָנוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","וַיֶּלֶךְ אִתָּם יֵשׁוּעַ וְכַאֲשֶׁר הִקְרִיב אֶל־הַבַּיִת וְרֶוַח לֹא רָחוֹק בֵּינֵיהֶם וַיִּשְׁלַח לוֹ שַׂר־הַמֵּאָה רֵעִים לֵאמֹר אֲדֹנִי אַל־תַּלְאֶה אֶת־נַפְשְׁךָ נְקַלֹּתִי מִזֹּאת כִּי אַתָּה תָבֹא בְּצֵל קֹרָתִי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","וּבַעֲבוּר זֹאת לֹא נֶחְשְׁבָה נַפְשִׁי בְּעֵינַי לָבֹא לְפָנֶיךָ אַךְ תְּנָה אֹמֶר וְנַעֲרִי יֶחִי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","כִּי גַּם־אָנֹכִי עֹמֵד תַּחַת יַד מֶמְשָׁלָה וְאַנְשֵׁי צָבָא תַּחַת יָדִי וְכִי אֹמַר לְאֶחָד מֵהֶם לֵךְ וְיֵלֵךְ וּלְאַחֵר בֹּא וְיָבֹא וּלְעַבְדִּי עֲשֵׂה־זֹאת וְיַעֲשֶׂה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","וַיִּשְׁמַע יֵשׁוּעַ אֶת־דְּבָרָיו וַיִּשְׁתָּאֶה וַיִּפֶן וַיֹּאמֶר אֶל־הָעָם הַהֹלֵךְ אַחֲרָיו הִנְנִי מַגִּיד לָכֶם אֱמוּנָה גְּדוֹלָה כָמוֹהָ גַּם־בְּיִשְׂרָאֵל לֹא־מָצָאתִי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","וַיָּשׁוּבוּ הַשְּׁלוּחִים אֶל־הַבָּיִת וַיִּמְצְאוּ כִּי נִרְפָּא הָעֶבֶד הַחֹלֶה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","וַיְהִי מִמָּחָרָת וַיֵּלֶךְ אֶל־עִיר וּשְׁמָהּ נָעִין וְתַלְמִידָיו הָלְכוּ אַחֲרָיו וַהֲמוֹן עַם־רָב׃ ");
INSERT INTO hebsg_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","וְכַאֲשֶׁר קָרַב אֶל־שַׁעַר הָעִיר וְהִנֵּה אֲנָשִׁים מוֹצִיאִים מִשָּׁם אִישׁ מֵת בֵּן יָחִיד לְאִמּוֹ וְהִיא אִשָּׁה אַלְמָנָה וְרַבִּים מִן־הָעִיר עִמָּהּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","וַיַּרְא אֹתָהּ הָאָדוֹן וְרַחֲמָיו נִכְמְרוּ אֵלֶיהָ וַיֹּאמֶר לָהּ אַל־תִּבְכִּי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","וַיִּגַּשׁ וַיִּגַּע בַּמִּשְׁכָּב וְנֹשְׂאָיו עָמָדוּ וַיֹּאמֶר הִנֵּה אֲנִי מְדַבֵּר אֵלֶיךָ קוּם בָּחוּר׃ ");
INSERT INTO hebsg_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","וַיִּיקַץ הַמֵּת וַיֵּשֶׁב וַיָּחֶל לְדַבֵּר וְהוּא נְתָנוֹ אֶל־אִמּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","וְחִיל אָחַז אֶת־כֻּלָּם וַיְהַלְּלוּ אֶת־הָאֱלֹהִים וַיֹּאמְרוּ כִּי־נָבִיא גָדוֹל קָם בְּקִרְבֵּנוּ וְכִי־פָקַד אֱלֹהִים אֶת־עַמּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","וּשְׁמוּעַת הַדָּבָר הַזֶּה יָצְאָה בְּכָל־יְהוּדָה וּבְכָל־הַכִּכָּר מִסָּבִיב׃ ");
INSERT INTO hebsg_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","וּלְיוֹחָנָן הִגִּידוּ תַלְמִידָיו אֶת־כָּל־אֵלֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","וַיִּקְרָא אֵלָיו יוֹחָנָן שְׁנַיִם מִתַּלְמִידָיו וַיִּשְׁלָחֵם אֶל־יֵשׁוּעַ לֵאמֹר הַאַתָּה הוּא הַבָּא אוֹ אִם־נְחַכֶּה לְאַחֵר׃ ");
INSERT INTO hebsg_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","וַיָּבֹאוּ אֵלָיו הָאֲנָשִׁים וַיֹּאמְרוּ יוֹחָנָן הַמְטַבֵּל שְׁלָחָנוּ אֵלֶיךָ לֵאמֹר הַאַתָּה הוּא הַבָּא אוֹ אִם־נְחַכֶּה לְאַחֵר׃ ");
INSERT INTO hebsg_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","וּבָעֵת הַהִיא הֶעֱלָה אֲרֻכָה לְרַבִּים מֵחֳלָיִים וּנְגָעִים וּמֵרוּחוֹת רָעוֹת וּלְעִוְרִים רַבִּים הֵשִׁיב אוֹר עֵינֵהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","וַיַּעַן יֵשׁוּעַ וַיֹּאמֶר אֲלֵיהֶם לְכוּ וְהַגִּידוּ לְיוֹחָנָן אֵת אֲשֶׁר רְאִיתֶם וְאֵת אֲשֶׁר־שְׁמַעְתֶּם כִּי עִוְרִים רֹאִים פִּסְחִים הֹלְכִים מְצֹרָעִים נִרְפָּאִים חֵרְשִׁים שֹׁמְעִים מֵתִים קָמִים וַעֲנִיִּים מִתְבַּשְּׂרִים יְשׁוּעָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","וְאַשְׁרֵי הָאִישׁ אֲשֶׁר לֹא־יִכָּשֵׁל בִּי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","וַיְהִי כַּאֲשֶׁר הָלְכוּ מַלְאֲכֵי יוֹחָנָן וַיָּחֶל לְדַבֵּר אֶל־הֲמוֹן־הָעָם עַל־יוֹחָנָן מַה־זֶּה יְצָאתֶם הַמִּדְבָּרָה לִרְאוֹת הַאִם קָנֶה אֲשֶׁר יִנּוֹעַ מִפְּנֵי־רוּחַ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","אַךְ מַה־זֶּה יְצָאתֶם לִרְאוֹת הַאִם אִישׁ לָבוּשׁ בִּגְדֵי חֲמֻדוֹת הִנֵּה לְבֻשֵׁי חֲמֻדוֹת וּמִתְעַדְּנִים בַּעֲדָנִים בְּחַצְרוֹת מְלָכִים הֵמָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","אַךְ מַה־זֶּה יְצָאתֶם לִרְאוֹת הַאִם אִישׁ נָבִיא הֵן אֲנִי אֹמֵר לָכֶם כִּי גַּם־גָּדוֹל הוּא מִנָּבִיא׃ ");
INSERT INTO hebsg_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","כִּי זֶה הוּא אֲשֶׁר כָּתוּב עָלָיו הִנְנִי שֹׁלֵחַ מַלְאָכִי לְפָנֶיךָ וּפִנָּה־דַרְכְּךָ לְפָנֶיךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","אֲנִי אֹמֵר לָכֶם לֹא קָם בֵּין יִלּוֹדֵי אִשָּׁה גָּדוֹל מִיּוֹחָנָן וְהַקָּטֹן בְּמַלְכוּת הָאֱלֹהִים יִגְדַּל מִמֶּנּוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","וְכָל־הָעָם וְהַמֹּכְסִים עִמָּהֶם כַּאֲשֶׁר שָׁמְעוּ כָזֹאת נָתְנוּ לֵאלֹהִים צֶדֶק וַיִּטָּבְלוּ בִּטְבִילַת יוֹחָנָן׃ ");
INSERT INTO hebsg_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","אַךְ־הַפְּרוּשִׁים וְחַכְמֵי הַתּוֹרָה נִאֲצוּ אֶת־עֲצַת אֱלֹהִים וְלֹא נִטְבְּלוּ בִּטְבִילָתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","וַיֹּאמֶר הָאָדוֹן וְאֶל־מִי אֲדַמֶּה בְנֵי הַדּוֹר הַזֶּה וּלְמִי הֵם דֹּמִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","דֹּמִים הֵם לַיְלָדִים יֹשְׁבִים בִּשְׁוָקִים וְזֶה אֶל־זֶה קֹרְאִים וְאֹמְרִים מְזַמְּרִים הָיִינוּ לָכֶם וְלֹא רְקַדְתֶּם מְקוֹנְנִים וְלֹא סְפַדְתֶּם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","כִּי בָא יוֹחָנָן הַמְטַבֵּל לֹא אָכַל לֶחֶם וְלֹא־שָׁתָה יַיִן וַתֹּאמְרוּ כִּי שֵׁד בּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","וּבֶן־הָאָדָם בָּא אָכַל וְשָׁתָה וַתֹּאמְרוּ הִנֵּה אִישׁ זוֹלֵל וְסֹבֵא וְאֹהֵב לַמּוֹכְסִים וְלַחַטָּאִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","אַךְ הַחָכְמָה תִּצְטַדֵּק בְּמַעֲשֵׂי בָנֶיהָ כֻּלָּם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","וְאַחַד הַפְּרוּשִׁים קָרָא לוֹ לָבֹא לֶאֱכֹל אִתּוֹ לָחֶם וַיָּבֹא אֶל־בֵּית הַפָּרוּשׁ וַיֵּשֶׁב בִּמְסִבּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","וְהִנֵּה אִשָּׁה חֹטַאַת בָּעִיר וְכַאֲשֶׁר שָׁמְעָה כִּי־הוּא יֹשֵׁב בִּמְסִבָּה בְּבֵית הַפָּרוּשׁ וַתִּקַּח צְלֹחִית שֶׁמֶן הַמֹּר׃ ");
INSERT INTO hebsg_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","וַתָּבֹא וַתַּעֲמֹד מֵאַחֲרָיו לְנֹכַח רַגְלָיו וַתֵּבְךְ וַתָּחֶל לִשְׁפֹּךְ דִּמְעוֹתֶיהָ עֲלֵי־רַגְלָיו וְלִמְחוֹת אֶת־הַדִּמְעָה מֵעֲלֵיהֶן בְּשַׂעֲרוֹת רֹאשָׁהּ וַתִּשַּׁק אֶת־רַגְלָיו וּמָשׁוֹחַ אוֹתָן בַּשָּׁמֶן׃ ");
INSERT INTO hebsg_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","וְהַפָּרוּשׁ אֲשֶׁר קְרָאוֹ לֶאֱכֹל אִתּוֹ רָאָה וַיֹּאמֶר אֶל־לִבּוֹ לוּ הָיָה נָבִיא אָז יָדַע מִי־הִיא וּמָה־הִיא הַנֹּגַעַת בּוֹ כִּי אֵשֶׁת חֵטְא הִיא׃ ");
INSERT INTO hebsg_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","וַיַּעַן יֵשׁוּעַ וַיֹּאמֶר אֵלָיו שִׁמְעוֹן דָּבָר־לִי אֵלֶיךָ וַיֹּאמֶר דַּבֵּר רַבִּי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","וַיֹּאמֶר נֹשֶׁה אֶחָד הָיוּ־לוֹ שְׁנֵי בַעֲלֵי־חוֹב חוֹב הָאֶחָד חֲמֵשׁ מֵאוֹת כֶּסֶף וְחוֹב הַשֵּׁנִי חֲמִשִּׁים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","וְיַעַן כִּי לֹא הִשִּׂיגָה יָדָם לְשַׁלֶּם־לוֹ וַיַּשְׁמֵט מַשֵּׁה יָדוֹ מִשְּׁנֵיהֶם וְעַתָּה אֵיזֶה מִשְּׁנֵיהֶם יוֹסִיף לְאַהֲבָה אֹתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","וַיַּעַן שִׁמְעוֹן וַיֹּאמַר זֶה הוּא לְפִי מַחֲשַׁבְתִּי אֲשֶׁר שָׁמַט לוֹ הַרְבֵּה וַיֹּאמֶר אֵלָיו כֵּן חָרָצְתָּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","וַיִּפֶן אֶל־הָאִשָּׁה וַיֹּאמֶר אֶל־שִׁמְעוֹן הֲרֹאֶה אַתָּה אֶת־הָאִשָּׁה הַזֹּאת הִנֵּה בָּאתִי לְבֵיתְךָ וּמַיִם לֹא נָתַתָּ לְרַגְלָי וְהִיא דִּמְעוֹתֶיהָ שָׁפְכָה עַל־רַגְלַי וַתִּמַח אֶת־הַדִּמְעָה מֵעֲלֵיהֶן בְּשַׂעֲרוֹתֶיהָ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","מִנְּשִׁיקוֹת פִּיךָ אַתָּה לֹא נְשַׁקְתָּנִי וְהִיא מֵאָז בָּאתִי לֹא חָדְלָה מִנַּשֵּׁק אֶת־רַגְלָי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","אַתָּה לֹא מָשַׁחְתָּ בְּשֶׁמֶן רֹאשִׁי וְהִיא מָשְׁחָה רַגְלַי בְּשֶׁמֶן הַמֹּר׃ ");
INSERT INTO hebsg_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","עַל־כֵּן אֲנִי אֹמֵר אֵלֶיךָ חַטֹּאתֶיהָ הָרַבּוֹת נִסְלְחוּ־לָהּ כִּי אַהֲבָתָהּ רַבָּה וּמִי אֲשֶׁר מְעַט מִזְעָר נִסְלַח־לוֹ אַהֲבָתוֹ מְעַט מִזְעָר׃ ");
INSERT INTO hebsg_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","וַיֹּאמֶר אֵלֶיהָ נִסְלְחוּ־לָךְ חַטֹּאתָיִךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","וְהַיֹּשְׁבִים אִתּוֹ בִּמְסִבָּה הֵחֵלּוּ לְדַבֵּר עַל־לִבָּם מִי הוּא זֶה הֲגַם סֹלֵחַ לַעֲוֹנוֹת הוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","וַיֹּאמֶר אֶל־הָאִשָּׁה אֱמוּנָתֵךְ הוֹשִׁיעָה לָּךְ לְכִי לְשָׁלוֹם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","וַיְהִי אַחֲרֵי־כֵן וַיַּעֲבֹר בְּעָרִים וּבִכְפָרִים קוֹרֵא וּמַשְׁמִיעַ אֶת־מַלְכוּת הָאֱלֹהִים וְעִמּוֹ שְׁנֵים הֶעָשָׂר׃ ");
INSERT INTO hebsg_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","וְנָשִׁים אֲשֶׁר נִרְפְּאוּ מֵחֳלָיִים וּמֵרוּחוֹת רָעוֹת מִרְיָם הַנִּקְרֵאת מַגְדָּלִית אֲשֶׁר גֹּרְשׁוּ מִמֶּנָּה שֶׁבַע רוּחוֹת רָעוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","וְיוֹחָנָה אֵשֶׁת כּוּזָא סֹכֵן הוֹרְדוֹס וְשׁוֹשַׁנָּה וְרַבּוֹת אֲחֵרוֹת אֲשֶׁר כִּלְכְּלוּ אֹתוֹ מֵרְכוּשָׁן׃ ");
INSERT INTO hebsg_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","וַיְהִי בְּהִקָּבֵץ אֵלָיו הֲמוֹן עַם־רָב אֲשֶׁר בָּאוּ מִכָּל־עִיר וָעִיר וַיִּשָּׂא אֶת־מְשָׁלוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","הַזֹּרֵעַ יָצָא לִזְרֹעַ וּבְזָרְעוֹ פִּזַּר מִן־הַזֶּרַע עַל־יַד הַדָּרֶךְ וַיְהִי לְמִרְמַס רֶגֶל וּלְמַאֲכָל לְעוֹף הַשָּׁמָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","וְיֵשׁ אֲשֶׁר נָפַל עַל־פְּנֵי הַסָּלַע וַיַּעַשׂ צֶמַח וַיִּיבַשׁ כִּי לֹא הָיָה־לוֹ לֵחַ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","וְיֵשׁ אֲשֶׁר נָפַל אֶל־הַקּוֹצִים וַיַּעֲלוּ הַקּוֹצִים עִמּוֹ וַיְבַלְּעֻהוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","וְיֵשׁ אֲשֶׁר נָפַל עַל־חֶלְקָה טוֹבָה וַיַּעַל וַיַּעַשׂ פְּרִי תְבוּאָה מֵאָה שְׁעָרִים וּמִדֵּי דַבְּרוֹ כָּזֹאת קָרָה מִי אֲשֶׁר אָזְנַיִם לוֹ לִשְׁמֹעַ יִשְׁמָע׃ ");
INSERT INTO hebsg_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","וַיִּשְׁאֲלוּ אֹתוֹ תַּלְמִידָיו לֵאמֹר מָה הַמָּשָׁל הַזֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","וַיֹּאמַר לָכֶם נִתַּן לָדַעַת רָזֵי מַלְכוּת הָאֱלֹהִים וְלָאֲחֵרִים רַק־בִּמְשָׁלִים לְמַעַן בִּרְאוֹתָם לֹא יִרְאוּ וּבְשָׁמְעָם לֹא יָבִינוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","וְזֶה הוּא הַמָּשָׁל הַזֶּרַע הוּא דְּבַר הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","וַאֲשֶׁר עַל־יַד הַדֶּרֶךְ הֵם אֲשֶׁר שָׁמְעוּ וְהַשָּׂטָן בָּא וַיִּטְרֹף דְּבַר הָאֱלֹהִים מִלִּבָּם פֶּן־יַאֲמִינוּ וְיִוָּשֵׁעוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","וַאֲשֶׁר עַל־הַסֶּלַע הֵם הַשֹּׁמְעִים הַמְקַבְּלִים אֶת־הַדָּבָר בְּשִׂמְחָה אַךְ אֵין לָהֶם שֹׁרֶשׁ וְרַק לַמִּצְעָר יַאֲמִינוּ וּבְיוֹם מַסָּה יִסֹּגוּ אָחוֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","וְהַנֹּפֵל אֶל־הַקּוֹצִים הֵם הַשֹּׁמְעִים הַהֹלְכִים לְדַרְכָּם וְנִבְלָעִים בְּרֹב דְּאָגָה בְּעֹשֶׁר וּבְתַעֲנֻגוֹת בְּנֵי־אָדָם וְלֹא־יַעֲשׂוּ פֶּרִי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","וַאֲשֶׁר עַל־הַחֶלְקָה הַטּוֹבָה הֵם הַשֹּׁמְעִים אֶת־הַדָּבָר בְּלֵב טוֹב וּבְרוּחַ נָכוֹן וְתוֹחַלְתָּם אִתָּם עַד־אֲשֶׁר יַעֲשׂוּן פֶּרִי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","וְאֵין־אִישׁ מַדְלִיק נֵר לְכַסֹּתוֹ בְמִכְסֶה אוֹ לְתִתּוֹ מִתַּחַת לַמִּטָּה כִּי אִם־יִתְּנֵהוּ אֶל־הַמְּנוֹרָה וְכָל־הַבָּאִים יִרְאוּ בְּאוֹרוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","כִּי אֵין־נֶעְלָם אֲשֶׁר לֹא יִגָּלֶה וְאֵין נִסְתָּר אֲשֶׁר לֹא יִוָּדַע וְלֹא יֵצֵא לָאוֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","עַל־כֵּן שִׂימוּ לִבְּכֶם אֶל־אֲשֶׁר תִּשְׁמָעוּן כִּי מִי אֲשֶׁר יֶשׁ־לוֹ יֻתַּן לוֹ עוֹד וּמִי אֲשֶׁר אֵין־לוֹ יֻקַּח מִמֶּנּוּ גַּם אֶת־אֲשֶׁר יַחֲשֹׁב כִּי יֶשׁ־לוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","וַיָּבֹאוּ אֵלָיו אִמּוֹ וְאֶחָיו וְלֹא יָכְלוּ קְרֹב אֵלָיו מִפְּנֵי רֹב הָעָם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","וַיֻּגַּד־לוֹ לֵאמֹר אִמְּךָ וְאַחֶיךָ עֹמְדִים בַּחוּץ וּמְבַקְשִׁים לִרְאוֹתֶךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","וַיַּעַן וַיֹּאמֶר אֲלֵיהֶם אֵלֶּה הֵם אִמִּי וְאֶחָי הַשֹּׁמְעִים אֶת־דְּבַר הָאֱלֹהִים וְהָעֹשִׂים אֹתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","וַיְהִי הַיּוֹם וַיֵּרֶד אֶל־כְּלִי שַׁיִט הוּא וְתַלְמִידָיו וַיֹּאמֶר אֲלֵיהֶם נַעְבְּרָה־נָּא אֶל־עֵבֶר הַיָּם וַיִּנְהֲגוּ אֶת־כְּלִי הַשָּׁיִט׃ ");
INSERT INTO hebsg_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","וְהוּא שָׁכַב וַיֵּרָדַם בְּעוֹד הֵם שָׁטִים וְרוּחַ סְעָרָה הִתְעוֹרְרָה בַּיָּם וַיִּשְׁטְפוּ עֲלֵיהֶם מַיִם כַּבִּירִים וַיַּגִּיעוּ עַד־שַׁעֲרֵי מָוֶת׃ ");
INSERT INTO hebsg_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","וַיִּגְּשׁוּ וַיָּעִירוּ אֹתוֹ לֵאמֹר אֲדֹנֵינוּ אֲדֹנֵינוּ הֵן אֹבְדִים אֲנָחְנוּ וַיֵּעוֹר וַיִּגְעַר בָּרוּחַ וּבִשְׁאוֹן הַמַּיִם וַיִּשְׁתְּקוּ וְהַסְּעָרָה קָמָה לִדְמָמָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","וַיֹּאמֶר אֲלֵיהֶם אַיֶּה אֵפוֹא הִיא אֱמוּנַתְכֶם וְהֵם פָּחֲדוּ וְתָמְהוּ וְאָמְרוּ אִישׁ אֶל־רֵעֵהוּ מִי הוּא זֶה אֲשֶׁר יְצַוֶּה גַּם־אֶת־הָרוּחַ וְגַם־אֶת־הַמַּיִם וְהֵם שֹׁמְעִים בְּקוֹלוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","וַיָּבֹאוּ אֶרֶץ הַגַּדְרִיִּם אֲשֶׁר מִמּוּל הַגָּלִיל׃ ");
INSERT INTO hebsg_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","וַיֵּצֵא אֶל־הַיַּבָּשָׁה וַיִּפְגְּשֵׁהוּ אִישׁ מִן־הָעִיר אֲשֶׁר רוּחוֹת רָעוֹת בּוֹ וְהוּא עָרֹם בְּלִי לְבוּשׁ מִיָּמִים רַבִּים וּבַבַּיִת לֹא שָׁכַן כִּי אִם־בִּקְבָרִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","וְכִרְאוֹתוֹ אֶת־יֵשׁוּעַ וַיִּפֹּל לְפָנָיו וַיִּקְרָא בְקוֹל גָּדוֹל מַה־לִּי וָלָךְ יֵשׁוּעַ בֶּן־אֵל עֶלְיוֹן הִנְנִי מִתְחַנֵּן אַל־נָא תְּעַנֵּנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","כִּי הוּא צִוָּה אֶת־רוּחַ הַטֻּמְאָה לָצֵאת מִן־הָאִישׁ הַזֶּה אֲשֶׁר פְּעָמִים רַבּוֹת תָּפַשׂ בּוֹ וְהוּא אָסוּר בְּזִקִּים וְשָׁמוּר בְּכַבְלֵי בַרְזֶל וַיְנַתֵּק אֶת־מוֹסְרוֹתָיו וּבְכֹחַ הָרוּחַ הָרָע נִדַּח הַמִּדְבָּרָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","וַיִּשְׁאַל אֹתוֹ יֵשׁוּעַ לֵאמֹר מַה־שְּׁמֶךָ וַיֹּאמֶר מַחֲנַיִם כִּי־שֵׁדִים רַבִּים שָׁכְנוּ בְּקִרְבּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","וַיִּפְצְרוּ־בוֹ לְבִלְתִּי יְצַוֵּם לָרֶדֶת אֶל־הַתְּהוֹם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","וְעֵדֶר חֲזִירִים רַבִּים הָיָה רֹעֶה שָׁם בָּהָר וַיִּתְחַנְּנוּ־לוֹ לְתִתָּם לָבֹא אֶל־תּוֹכָם וַיַּנַּח לָהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","וַיֵּצְאוּ הַשֵּׁדִים מִן־הָאִישׁ וַיָּבֹאוּ אֶל־תּוֹךְ הַחֲזִירִים וַיִּשְׁטֹף הָעֵדֶר בַּמּוֹרָד וַיִּטְבְּעוּ בְּתוֹךְ הַיָּם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","וְהָרֹעִים בִּרְאוֹתָם אֵת אֲשֶׁר קָרָה וַיָּנוּסוּ וַיַּגִּידוּ אֶת־הַדָּבָר בָּעִיר וּבַשָּׂדֶה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","וַיֵּצְאוּ בְנֵי הַמָּקוֹם לִרְאוֹת אֵת אֲשֶׁר נַעֲשָׂה וַיָּבֹאוּ אֶל־יֵשׁוּעַ וַיִּמְצְאוּ אֶת־הָאִישׁ אֲשֶׁר יָצְאוּ הַשֵּׁדִים מִמֶּנּוּ מְלֻבָּשׁ בְּגָדִים וְדַעְתּוֹ יְשָׁרָה וְיֹשֵׁב לְרַגְלֵי יֵשׁוּעַ וַיִּירָאוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","וְהָרֹאִים אֶת־הַמַּעֲשֶׂה בְּעֵינֵיהֶם סִפְּרוּ לָהֶם אֵיךְ נִרְפָּא בַּעַל מְעוֹן הַשֵּׁדִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","וְכָל־בְּנֵי הַמָּקוֹם מֵאֶרֶץ הַגַּדְרִיִּם וּמִסְּבִיבֹתֶיהָ בִּקְּשׁוּ מִמֶּנּוּ לָלֶכֶת מֵאִתָּם כִּי־זַלְעָפָה אֲחָזָתַם וַיֵּרֶד אֶל־כְּלִי שַׁיִט וַיָּשָׁב לְדַרְכּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","וְהָאִישׁ אֲשֶׁר הַשֵּׁדִים יָצְאוּ מִמֶּנּוּ הִפְצִיר בּוֹ לְתִתּוֹ לִהְיוֹת אֶצְלוֹ אַךְ יֵשׁוּעַ שִׁלְּחוֹ לֵאמֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","שׁוּב אֶל־בֵּיתְךְ וְסַפֵּר אֶת־הַגְּדֹלוֹת אֲשֶׁר עָשָׂה־לְךָ הָאֱלֹהִים וַיֵּלֶךְ וַיַּגֵּד בְּכָל־הָעִיר אֵת אֲשֶׁר עָשָׂה־לוֹ יֵשׁוּעַ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","וּבְשׁוּב יֵשׁוּעַ וַיֵּצֵא הָעָם לְקַבֵּל פָּנָיו כִּי חִכּוּ לוֹ כֻּלָּם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","וְהִנֵּה אִישׁ בָּא וּשְׁמוֹ יָאִיר רֹאשׁ בֵּית־הַכְּנֵסֶת וַיִּפֹּל לְרַגְלֵי יֵשׁוּעַ וַיִּתְחַנֵּן לָבֹא אֶל־בֵּיתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","כִּי בִּתּוֹ יְחִידָתוֹ כְּבַת שְׁתֵּים עֶשְׂרֶה שָׁנָה נָטְתָה לָמוּת וַיְהִי בְּלֶכְתּוֹ וַיִּדְחָקֻהוּ הֲמוֹן הָעָם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","וְאִשָּׁה זָבַת־דָּם אֲשֶׁר יְמֵי זֹבָהּ נִמְשְׁכוּ שְׁתֵּים עֶשְׂרֵה שָׁנָה וְכָל־רְכוּשָׁהּ הוֹצִיאָה לָרֹפְאִים וְיַד אָדָם לֹא הִשִּׂיגָה לְהָבִיא לָהּ מַרְפֵּא׃ ");
INSERT INTO hebsg_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","הָאִשָּׁה הַזֹּאת קָרְבָה אֵלָיו מֵאַחֲרָיו וַתִּגַּע בִּכְנַף בִּגְדוֹ וְזוֹב דָּמֶיהָ עָמַד כְּרָגַע׃ ");
INSERT INTO hebsg_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","וְיֵשׁוּעַ שָׁאַל לֵאמֹר מִי־זֶה נָגַע־בִּי וַיְכַחֲשׁוּ כֻּלָּם אַךְ פֶּטְרוֹס עָנָה וְאֵלֶּה אֲשֶׁר אִתּוֹ אֲדֹנִי הֲמוֹן הָעָם לֹחֲצִים וְדֹחֲקִים אֹתְךָ מִסָּבִיב וְאַתָּה תֹאמַר מִי־זֶה נָגַע בִּי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","וַיֹּאמֶר יֵשׁוּעַ נָגַע בִּי אֶחָד כִּי יָדַעְתִּי בְנַפְשִׁי כִּי גְבוּרָה יָצְאָה מֵאִתִּי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","וַתֵּרֶא הָאִשָּׁה כִּי לֹא־נִסְתְּרָה מִנֶּגֶד עֵינָיו וַתָּבֹא בְּחֶרְדָּתָהּ וַתִּפֹּל לְפָנָיו וַתַּגֵּד לִפְנֵי כָל־הָעָם עַל־מֶה נָגְעָה בּוֹ וְכִי נִרְפְּאָה לְפֶתַע פִּתְאֹם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","וַיֹּאמֶר אֵלֶיהָ חִזְקִי בִּתִּי אֱמוּנָתֵךְ הוֹשִׁיעָה לָּךְ לְכִי לְשָׁלוֹם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","עֹדֶנּוּ מְדַבֵּר וְאִישׁ מֵאַנְשֵׁי רֹאשׁ בֵּית־הַכְּנֵסֶת בָּא וַיֹּאמַר מֵתָה בִתְּךָ וְאַל־תַּלְאֶה עוֹד אֶת־הָרַבִּי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","כִּשְׁמֹעַ יֵשׁוּעַ וַיֹּאמֶר אֵלָיו אַל־תִּירָא אַךְ־הַאֲמֵן וְלָהּ תִּהְיֶה תְּשׁוּעָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","וַיָּבֹא הַבַּיְתָה וְלֹא־נָתַן לְאִישׁ לָבֹא אִתּוֹ בִּלְתִּי לְפֶטְרוֹס וְיוֹחָנָן וְיַעֲקֹב וַאֲבִי הַיַּלְדָּה וְאִמָּהּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","וְכֻלָּם בֹּכִים וְסֹפְדִים לָהּ וְהוּא אָמַר אַל־תִּבְכּוּ כִּי הִיא לֹא מֵתָה כִּי אִם־יְשֵׁנָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","וַיִּלְעֲגוּ לוֹ כִּי הֵם יָדְעוּ כִּי־מֵתָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","וְהוּא הוֹצִיא אֶת־כֻּלָּם מִן הַבָּיִת וְהֶחֱזִיק בְּיָדָהּ וַיִּקְרָא לֵאמֹר קוּמִי לָךְ נַעֲרָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","וַתָּשָׁב רוּחָהּ אֵלֶיהָ וַתָּקָם פִּתְאֹם וַיְצַו לָתֶת־לָהּ לֶאֱכֹל׃ ");
INSERT INTO hebsg_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","וַיִּתְפַּלְּאוּ אֲבוֹתֶיהָ עַד־מְאֹד וְהוּא צִוָּה עֲלֵיהֶם לְבִלְתִּי הַגֵּד לְאִישׁ אֵת אֲשֶׁר נַעֲשָׂה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","וַיִּקְרָא אֶל־שְׁנֵים הֶעָשָׂר וַיִּתֵּן לָהֶם גְּבוּרָה וּמֶמְשָׁלָה עַל־כָּל־רוּחוֹת רָעוֹת וְלִרְפֹּא כָּל־מַחֲלָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","וַיִּשְׁלָחֵם לִקְרֹא אֶת־מַלְכוּת הָאֱלֹהִים וּלְהָקִים אֶת־הַחוֹלִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","וַיְצַו אֲלֵיהֶם לֵאמֹר לֹא תִקְחוּ מְאוּמָה לַדָּרֶךְ לֹא מַטֶּה וְלֹא יַלְקוּט וְלֹא לֶחֶם וְלֹא כֶסֶף וְלֹא חֲלִיפוֹת בְּגָדִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","וּבַבַּיִת אֲשֶׁר תָּבֹאוּ שָׁם תִּשְׁכְּנוּ וּמִשָּׁם תֵּצֵאוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","וְהָיָה אִם לֹא יַאַסְפוּ אֶתְכֶם הַבָּיְתָה צְאוּ מִן־הָעִיר הַהִיא וּנְעַרְתֶּם אֶת־הֶאָבָק מֵעַל רַגְלֵיכֶם לְעֵדוּת לָהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","וַיֵּצְאוּ וַיַּעַבְרוּ בִכְפָרִים וּבְכָל־מָקוֹם קֹרִאים אֶת־הַבְּשׂוֹרָה וְרֹפְאִים אֶת־הַחוֹלִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","וְהוֹרְדוֹס טֶטְרַרְךְ שָׁמַע אֶת־כָּל־אֲשֶׁר נַעֲשָׂה וַתִּפָּעֶם רוּחוֹ כִּי־יֵשׁ אֲשֶׁר אָמְרוּ יוֹחָנָן קָם מִן־הַמֵּתִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","וְיֵשׁ אֲשֶׁר אָמְרוּ כִּי נִגְלָה אֵלִיָּהוּ וַאֲחֵרִים אָמְרוּ כִּי קָם נָבִיא אֶחָד מִן־הַנְּבִיאִים הַקַּדְמֹנִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","וַיֹּאמֶר הוֹרְדוֹס הֵן רֹאשׁ יוֹחָנָן נָשָׂאתִי מֵעָלָיו וּמִי־אֵפוֹא הוּא אֲשֶׁר אָנֹכִי שֹׁמֵעַ עָלָיו כָּזֹאת וַיְבַקֵּשׁ לִרְאוֹתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","וּבְשׁוּב הַשְּׁלִיחִים הִגִּידוּ לוֹ אֶת־כָּל־אֲשֶׁר עָשׂוּ וַיִּקָּחֵם וַיֵּלֶךְ עִמָּהֶם לְבַדָּם אֶל־עִיר הַנִּקְרֵאת בֵּית־צָיְדָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","וַהֲמוֹן הָעָם יָדְעוּ וַיֵּלְכוּ אַחֲרָיו וְהוּא קִבֵּל פְּנֵיהֶם וַיְדַבֵּר אֲלֵיהֶם עַל־מַלְכוּת הָאֱלֹהִים וְרָפוֹא אֶת־הַדֹּרְשִׁים לְהֵרָפֵא׃ ");
INSERT INTO hebsg_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","וְכַאֲשֶׁר רָפָה הַיּוֹם לַעֲרֹב וַיָּבֹאוּ שְׁנֵים הֶעָשָׂר וַיֹּאמְרוּ אֵלָיו שַׁלַּח אֶת־הֲמוֹן הָעָם וְיֵלְכוּ אֶל־הֶעָרִים וְחַצְרֵיהֶן מִסָּבִיב לִמְצֹא אֹכֶל וּמָקוֹם לָלוּן כִּי־פֹה בְמָקוֹם שָׁמֵם אֲנָחְנוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","וַיֹּאמֶר אֲלֵיהֶם תְּנוּ לָהֶם אַתֶּם לֶאֱכֹל וַיֹּאמְרוּ לֹא נִמְצָא אִתָּנוּ בִּלְתִּי חֲמִשָּׁה לֶחֶם וְדָגִים שְׁנַיִם אוֹ הֲנֵלֵךְ לִקְנוֹת אֹכֶל לְכָל־הָעָם הַזֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","אֲשֶׁר הָיוּ כַּחֲמֵשֶׁת אַלְפֵי־אִישׁ וַיֹּאמֶר אֶל־תַּלְמִידָיו הוֹשִׁיבוּ אֹתָם שׁוּרוֹת שׁוּרוֹת כַּחֲמִשִּׁים אִישׁ בַּשּׁוּרָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","וַיַּעֲשׂוּ־כֵן וַיּוֹשִׁיבוּ אֶת־כֻּלָּם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","וַיִּקַּח אֶת־חֲמֵשֶׁת הַלֶּחֶם וְאֶת־שְׁנֵי הַדָּגִים וַיִּשָּׂא עֵינָיו לַמָּרוֹם וַיְבָרֵךְ וַיִּפְרֹס וַיִּתֵּן לְתַלְמִידָיו לָשׂוּם לִפְנֵי הָעָם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","וַיֹּאכְלוּ כֻלָּם וַיִּשְׂבָּעוּ וַיִּשְׂאוּ שְׁנֵים עָשָׂר סַלִּים מִן־הַפְּתוֹתִים הַנּוֹתָרִים לָהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","וַיְהִי בְּהִתְפַּלְּלוֹ לְבַדּוֹ וְתַלְמִידָיו בָּאוּ לְפָנָיו וַיּשְׁאַל אֹתָם לֵאמֹר מָה־אֹמְרִים עָלַי הֲמוֹן הָעָם מִי־אָנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","וַיַּעֲנוּ וַיֹּאמְרוּ יוֹחָנָן הַמְטַבֵּל וְיֵשׁ אֹמְרִים אֵלִיָּהוּ וַאֲחֵרִים אֹמְרִים נָבִיא אֶחָד קָם מִן־הַנְּבִיאִים הַקַּדְמֹנִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","וַיֹּאמֶר אֲלֵיהֶם וְאַתֶּם מַה תֹּאמְרוּ עָלַי מִי־אָנִי וַיַּעַן פֶּטְרוֹס וַיֹּאמֶר מְשִׁיחַ הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","אָז הֵעִיד בָּם וַיְצַוֵּם לְבִלְתִּי הַגֵּד הַדָּבָר לְאִישׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","וַיֹּאמַר רַבִּים מַכְאֹבִים נָכֹנוּ לְבֶן־הָאָדָם וְהַזְּקֵנִים וְרָאשֵׁי הַכֹּהֲנִים וְהַסּוֹפְרִים יִמְאֲסוּ־בוֹ וִימִיתֻהוּ וּבַיּוֹם הַשְּׁלִישִׁי יָקוּם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","וַיֹּאמֶר אֶל־כֻּלָּם מִי הֶחָפֵץ לָלֶכֶת אַחֲרָי יַשְׁלִיךְ אֶת־נַפְשׁוֹ מִנֶּגֶד וְיִשָּׂא אֶת־צְלָבוֹ יוֹם יוֹם וְיֵלֵךְ אַחֲרָי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","כִּי מִי הֶחָפֵץ לְהַצִּיל אֶת־נַפְשׁוֹ תִּכָּרֶת־לוֹ וּמִי אֲשֶׁר יַכְרִית אֶת־נַפְשׁוֹ לְמַעֲנִי יִמְצָאֶנָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","כִּי מַה־בֶּצַע לְאִישׁ אִם יִקְנֶה־לּוֹ אֶת־כָּל־הָאָרֶץ וְאֶת־נַפְשׁוֹ יְאַבֵּד אוֹ יַשְׁחִיתֶנָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","כִּי כָל־אִישׁ אֲשֶׁר יֵבוֹשׁ מִמֶּנִּי וּמִדְּבָרָי אַף בֶּן־הָאָדָם יֵבוֹשׁ מִמֶּנּוּ כַּאֲשֶׁר יָבֹא בִכְבוֹדוֹ וּבִכְבוֹד אָבִיו וְהַמַּלְאָכִים הַקְּדוֹשִׁים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","וְאָמֵן אֲנִי אֹמֵר לָכֶם יֵשׁ מִן־הַנִּצָּבִים פֹּה אֲשֶׁר לֹא־יִטְעֲמוּ מָוֶת עַד כִּי־יִרְאוּ אֶת־מַלְכוּת הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","וַיְהִי כִּשְׁמֹנַת יָמִים אַחֲרֵי הַדְּבָרִים הָאֵלֶּה וַיִּקַּח אִתּוֹ אֶת־פֶּטְרוֹס וְאֶת־יוֹחָנָן וְאֶת־יַעֲקֹב וַיַּעַל אֶל־הָהָר וַיִּתְפַּלֵּל׃ ");
INSERT INTO hebsg_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","וַיְשֻׁנֶּה מַרְאֵה פָנָיו בְּהִתְפַּלְּלוֹ וּלְבוּשׁוֹ נֶהְפַּךְ לְלָבָן וּבָהִיר עַד־מְאֹד׃ ");
INSERT INTO hebsg_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","וְהִנֵּה שְׁנֵי אֲנָשִׁים דִּבְּרוּ אִתּוֹ מֹשֶׁה וְאֵלִיָּהוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","אֲשֶׁר נִרְאוּ בִכְבוֹדָם וְנִדְבְּרוּ עַל־אֲשֶׁר עָלָיו לְהַשְׁלִים חֻקּוֹ בִּירוּשָׁלָיִם לִהְיוֹת נִגְזָר מֵאֶרֶץ חַיִּים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","וְתַרְדֵּמָה נָפְלָה עַל־פֶּטְרוֹס וְעַל־אֲשֶׁר אִתּוֹ וְכַאֲשֶׁר הֵקִיצוּ רָאוּ אֶת־כְּבוֹדוֹ וְאֶת־שְׁנֵי הָאֲנָשִׁים הַנִּצָּבִים עָלָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","וַיְהִי בַּעֲלוֹתָם מֵעָלָיו וַיֹּאמֶר פֶּטְרוֹס אֶל־יֵשׁוּעַ אֲדֹנִי טוֹב לָנוּ לָשֶׁבֶת פֹּה נַעֲשֶׂה־נָּא שָׁלֹשׁ סֻכּוֹת אַחַת לְךָ אַחַת לְמֹשֶׁה וְאַחַת לְאֵלִיָּהוּ כִּי לֹא יָדַע מַה־לְּדַבֵּר׃ ");
INSERT INTO hebsg_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","עוֹדֶנּוּ מְדַבֵּר כָּזֹאת וְהִנֵּה עָנָן סָכַךְ עֲלֵיהֶם וַיָּבֹאוּ בְתוֹךְ הֶעָנָן וַיִּירָאוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","וְהִנֵּה קוֹל יֹצֵא מִתּוֹךְ הֶעָנָן לֵאמֹר זֶה־בְּנִי יְדִידִי אֵלָיו תִּשְׁמָעוּן׃ ");
INSERT INTO hebsg_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","וּבְהִשָּׁמַע הַקּוֹל עָמַד יֵשׁוּעַ לְבַדּוֹ וְהֵם הֶחֱרִישׁוּ לֹא־הִגִּידוּ דָבָר לְאִישׁ בַּיָּמִים הָהֵם מִכֹּל אֲשֶׁר רָאוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","וַיְהִי מִמָּחֳרָת בְּרִדְתָּם מִן־הָהָר וַיִּפְגְּשׁוּ אֹתוֹ רַבִּים מִן־הָעָם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","וְהִנֵּה אֶחָד מֵהֶם קָרָא לֵאמֹר אָנָּא רַבִּי הַבֶּט־נָא לִבְנִי כִּי בְּנִי יְחִידִי הוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","וְרוּחַ דָּבַק בּוֹ וְהוּא צֹעֵק פִּתְאֹם כִּי יִטְרְפֶנּוּ עַד־אֲשֶׁר יוֹרִיד רִירוֹ וְלֹא יִרֶף מִמֶּנּוּ עַד־אֲשֶׁר יְשִׁיבֶנּוּ עַד־דַּכָּא׃ ");
INSERT INTO hebsg_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","וָאֶשְׁאַל מִתַּלְמִידֶיךָ לְגָרְשׁוֹ וְלֹא יָכֹלוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","וַיַּעַן יֵשׁוּעַ וַיֹּאמַר הוֹי דּוֹר לֹא־אֵמֻן בּוֹ דּוֹר תַּהְפֻּכֹת עַד־מָתַי אֶהְיֶה עִמָּכֶם עַד־מָתַי אֶשָּׂא אֶתְכֶם הָבֵא אֶת־בִּנְךָ הֵנָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","וְהוּא טֶרֶם בָּא וַיַּרְעֵשׁ אֹתוֹ הָרוּחַ וַיִּטְרְפֵהוּ וְיֵשׁוּעַ גָּעַר בְּרוּחַ הַטֻּמְאָה וְאֶת־הַנַּעַר הֶחֱיָה מֵחָלְיוֹ וַיָּשֶׁב אֹתוֹ לְאָבִיו׃ ");
INSERT INTO hebsg_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","וַיִּתְמְהוּ כֻלָּם עַל־גֹּדֶל עֹז הָאֱלֹהִים וּבְעוֹד הֵם מִתְפַּלְּאִים עַל־כָּל־אֲשֶׁר עָשָׂה יֵשׁוּעַ וַיֹּאמֶר אֶל־תַּלְמִידָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","שִׂימוּ אַתֶּם אֶת־הַדְּבָרִים הָאֵלֶּה בְּאָזְנֵיכֶם כִּי הִנֵּה בֶּן־הָאָדָם יִסָּגֵר בִּידֵי אֲנָשִׁים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","וְהֵם לֹא הֵבִינוּ אֶת־דְּבָרוֹ כִּי סָתוּם הָיָה לָהֶם מֵהָבִין אֹתוֹ וְגַם־יָרְאוּ לִשְׁאֹל אֹתוֹ עַל־הַדָּבָר הַזֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","אָז עָלָה עַל־לִבָּם לָדוֹן מִי הוּא הַגָּדוֹל בָּהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","וְיֵשׁוּעַ בִּרְאוֹתוֹ מַחְשְׁבוֹת לִבָּם וַיִּקַּח יֶלֶד וַיַּעֲמִדֵהוּ אֶצְלוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","וַיֹּאמֶר אֲלֵיהֶם מִי הוּא הַמְקַבֵּל יֶלֶד כָּזֶה בִּשְׁמִי אֹתִי הוּא מְקַבֵּל וְהַמְקַבֵּל אֹתִי הוּא מְקַבֵּל פְּנֵי שֹׁלְחִי וְהַקָּטֹן בְּכֻלְּכֶם הוּא הַגָּדוֹל בָּכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","וַיַּעַן יוֹחָנָן וַיֹּאמַר אֲדֹנִי רָאִינוּ אִישׁ מְגָרֵשׁ רוּחוֹת רָעוֹת בִּשְׁמֶךָ וַנִּכְלָא אֹתוֹ מִפְּעֻלָּתוֹ אַחֲרֵי אֲשֶׁר לֹא־הָלַךְ עִמָּנוּ בְּלֶכְתֵּנוּ אַחֲרֶיךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","וַיֹּאמֶר אֵלָיו יֵשׁוּעַ אַל־תִּכְלְאוּ אֹתוֹ כִּי אִישׁ אֲשֶׁר אֵינֶנּוּ לְצָרֵינוּ לָנוּ הוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","וַיְהִי כַּאֲשֶׁר קָרְבוּ הַיָּמִים לְהִלָּקְחוֹ וַיָּשֶׂם אֶת־פָּנָיו בְּחָזְקָה לַעֲלוֹת יְרוּשָׁלָיְמָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","וַיִּשְׁלַח מַלְאָכִים לְפָנָיו וַיֵּלְכוּ וַיָּבֹאוּ אֶל־אַחַד הַכְּפָרִים בְּשֹׁמְרוֹן לְהָכִין לוֹ מָלוֹן׃ ");
INSERT INTO hebsg_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","וְלֹא פָתְחוּ לוֹ דַלְתָּם בִּרְאוֹתָם כִּי פָנָיו מֻעָדוֹת יְרוּשָׁלָיְמָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","וַיֵּרְאוּ יַעֲקֹב וְיוֹחָנָן תַּלְמִידָיו וַיֹּאמְרוּ אֲדֹנֵינוּ הֶחָפֵץ אַתָּה כִּי־נֹאמַר וְתֵרֵד אֵשׁ מִן־הַשָּׁמַיִם וְתֹאכַל אֹתָם כַּאֲשֶׁר עָשָׂה אֵלִיָּהוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","וַיִּפֵן וַיִּגְעַר־בָּם אֵינְכֶם יוֹדְעִים מֵאַיִן מְקוֹר רוּחֲכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","כִּי לֹא בָא בֶּן־הָאָדָם לְהַשְׁמִיד נֶפֶשׁ כִּי אִם־לְהוֹשִׁיעַ לָהֶן וַיֵּלְכוּ אֶל־כְּפָר אַחֵר׃ ");
INSERT INTO hebsg_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","וּבְלֶכְתָּם בַּדֶּרֶךְ וַיֹאמֶר אֵלָיו אִישׁ אֵלְכָה אַחֲרֶיךָ אֶל־אֲשֶׁר תֵּלֵךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","וַיֹּאמֶר אֵלָיו יֵשׁוּעַ הַשּׁוּעָלִים חֹרִים לָהֶם וְצִפּוֹר שָׁמַיִם קֵן לָהּ וּבֶן־הָאָדָם אֵין־לוֹ מָקוֹם לְהָנִיחַ אֶת־רֹאשׁוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","וְאֶל־אִישׁ אַחֵר אָמַר לֵךְ אַחֲרָי וַיֹּאמֶר אֵלָיו הָאִישׁ אֲדֹנִי תְּנָה־לִּי לָלֶכֶת וְלִקְבֹּר אֶת־אָבִי רִאשֹׁנָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","וַיֹּאמֶר אֵלָיו יֵשׁוּעַ הַנַּח לַמֵּתִים לִקְבֹּר אֶת־מֵתֵיהֶם וְאַתָּה לֵךְ וְהַשְׁמַע מַלְכוּת הָאֱלֹהִים בָּאָרֶץ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","וְעוֹד אִישׁ אַחֵר אָמַר אֵלָיו אֵלְכָה אַחֲרֶיךָ אֲדֹנִי אֶפֶס תְּנָה־לִּי רִאשֹׁנָה לְהִפָּרֵד מִבְּנֵי בֵיתִי בְּדִבְרֵי שָׁלוֹם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","וַיֹּאמֶר אֵלָיו יֵשׁוּעַ כָּל־אִישׁ הַשָּׂם יָדוֹ עַל־מַחֲרֵשָׁתוֹ וּמַבִּיט אֲחֹרַנִּית אֵינֶנּוּ נָכוֹן לְמַלְכוּת הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","אַחֲרֵי הַדְּבָרִים הָאֵלֶּה הִבְדִּיל הָאָדוֹן עוֹד שִׁבְעִים אֲנָשִׁים וַיִּשְׁלָחֵם שְׁנַיִם שְׁנַיִם לְפָנָיו אֶל־כָּל־עִיר וּמָקוֹם אֲשֶׁר שָׂם פָּנָיו לָבֹא שָׁמָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","וַיֹּאמֶר אֲלֵיהֶם הַקָּצִיר רַב וְהַפֹּעֲלִים מְעַטִּים עַל־כֵּן הַעְתִּירוּ אֶל־אֲדוֹן הַקָּצִיר לִשְׁלֹחַ פֹּעֲלִים לִקְצִירוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","וְאַתֶּם לְכוּ־נָא הִנֵּה אָנֹכִי שֹׁלֵחַ אֶתְכֶם כָּצֹאן בְּקֶרֶב זְאֵבִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","לֹא תִשְׂאוּ כִיס וְיַלְקוּט אוֹ נְעָלִים וְלֹא תִשְׁאֲלוּ לִשְׁלוֹם־אִישׁ בַּדָּרֶךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","וְאֶל־כָּל־בַּיִת אֲשֶׁר תָּבֹאוּ בוֹ אִמְרוּ בְּפֵתַח דִּבְרֵיכֶם שָׁלוֹם לַבַּיִת הַזֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","אִם אִישׁ שָׁלוֹם שֹׁכֵן שָׁם שְׁלֹמְכֶם יִשְׁכֹּן עָלָיו וְאִם־לֹא שְׁלֹמְכֶם אֲלֵיכֶם יָשׁוּב׃ ");
INSERT INTO hebsg_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","וּבַבַּיִת הַהוּא תֵּשְׁבוּ וְתֹאכְלוּ וְתִשְׁתּוּ מֵאֲשֶׁר יִנָּתֵן לָכֶם כִּי נָכוֹן לַפֹּעֵל דֵּי שְׂכָרוֹ וְלֹא תֵצְאוּ מִבַּיִת לְבָיִת׃ ");
INSERT INTO hebsg_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","וְאֶל־כָּל־עִיר אֲשֶׁר תָּבֹאוּ וְיֹשְׁבֶיהָ יַחֲזִיקוּ בָכֶם אִכְלוּ שָׁם מֵאֵת אֲשֶׁר יוּשַׂם לִפְנֵיכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","וְאֶת־הַחוֹלִים אֲשֶׁר בְּתוֹכָהּ תִּרְפָּאוּן וְכֹה תֹאמְרוּן אֲלֵיהֶם הִנֵּה קָרְבָה אֲלֵיכֶם מַלְכוּת הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","וּבְכָל־עִיר אֲשֶׁר תָּבֹאוּ וְלֹא יַחֲזִיקוּ בָכֶם צְאוּ אֶל־רְחֹבֹתֶיהָ וֶאֱמֹרוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","גַּם־עֲפַר עִירְכֶם הַמֻּדְבָּק בְּרַגְלֵינוּ נְנַעֵר אֲלֵיכֶם אַךְ דְּעוּ זֹאת כִּי קָרְבָה מַלְכוּת הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","אֲנִי הִנְנִי מַגִּיד לָכֶם כִּי יֵקַל הַמִּשְׁפָּט לִסְדֹם בַּיּוֹם הַהוּא מִן־הָעִיר הַהִיא׃ ");
INSERT INTO hebsg_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","אוֹי־לָךְ כּוֹרָזִין אוֹי־לָךְ בֵּית־צָיְדָה כִּי לוּ נַעֲשׂוּ בְּצוֹר וּבְצִידוֹן הַנִּפְלָאוֹת אֲשֶׁר נַעֲשׂוּ בְתוֹכְכֶן כְּבָר שָׁבוּ וְהִתְפַּלְּשׁוּ בְּשַׂק וָאֵפֶר׃ ");
INSERT INTO hebsg_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","אַךְ לְצוֹר וּלְצִידוֹן יֵקַל יוֹם הַמִּשְׁפָּט מֵאֲשֶׁר לָכֶן׃ ");
INSERT INTO hebsg_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","וְאַתּ כְּפַר־נַחוּם אֲשֶׁר רוֹמַמְתְּ עַד־הַשָּׁמָיִם אֶל־שְׁאוֹל תּוּרָדִי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","הַשֹּׁמֵעַ אֲלֵיכֶם אֵלַי הוּא שֹׁמֵעַ וְהַמֹּאֵס בָּכֶם בִּי הוּא מֹאֵס וְהַמֹּאֵס בִּי מֹאֵס הוּא בְּשֹׁלְחִי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","וַיָּשֻׁבוּ הַשִּׁבְעִים בְּשִׂמְחַת לִבָּם לֵאמֹר אֲדֹנֵינוּ בְּשִׁמְךָ נִכְבְּשׁוּ גַּם־הַשֵּׁדִים תַּחַת יָדֵינוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","וַיֹּאמֶר אֲלֵיהֶם רָאִיתִי אֶת־הַשָּׂטָן נָפַל כְּבָרָק מִן־הַשָּׁמָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","וַאֲנִי הִנְנִי נֹתֵן מֶמְשָׁלָה בְּיֶדְכֶם לִרְמֹס נְחָשִׁים וְעַקְרַבִּים וְכָל־גְּבוּרַת אוֹיֵב וְאֵין נֹגֵעַ בָּכֶם לְרָעָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","אַךְ אַל־תִּשְׂמְחוּ עַל כִּי־הָרוּחוֹת נִכְבָּשִׁים תַּחַת יֶדְכֶם כִּי אִם־שִׂמְחוּ עַל אֲשֶׁר־נִכְתְּבוּ שְׁמוֹתֵיכֶם בַּשָּׁמָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","בָּעֵת הַהִיא עָלַץ לֵב יֵשׁוּעַ בְּרוּחַ הַקֹּדֶשׁ וַיֹּאמֶר אוֹדְךָ אָבִי אֲדוֹן הַשָּׁמַיִם וְהָאָרֶץ כִּי הִסְתַּרְתָּ אֶת־אֵלֶּה מֵחֲכָמִים וּנְבֹנִים וְגִלִּיתָ אֹתָם לְעוֹלָלִים אָכֵן אָבִי כֵּן־רָצִיתָ אָתָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","הַכֹּל נִמְסַר בְּיָדִי מֵאֵת אָבִי וְאֵין אִישׁ יֹדֵעַ מִי הוּא הַבֵּן זוּלָתִי הָאָב וּמִי הוּא הָאָב אֵין אִישׁ יֹדֵעַ זוּלָתִי הַבֵּן וְהוּא אֲשֶׁר חָפֵץ בּוֹ הַבֵּן לְגַלּוֹתוֹ לוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","וַיִּפֶן אֶל־תַּלְמִידָיו לְבַדָּם וַיֹּאמֶר אַשְׁרֵי הָעֵינַיִם הָרֹאוֹת אֵת אֲשֶׁר אַתֶּם רֹאִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","כִּי אֲנִי מַגִּיד לָכֶם רַבִּים נְבִיאִים וּמְלָכִים נִכְסְפוּ לִרְאוֹת אֵת אֲשֶׁר אַתֶּם רֹאִים וְלֹא רָאוּ וְלִשְׁמֹעַ אֵת אֲשֶׁר אַתֶּם שֹׁמְעִים וְלֹא שָׁמֵעוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","וַיָּקָם תַּלְמִיד חָכָם אֶחָד לְנַסּוֹתוֹ וַיֹּאמַר רַבִּי מֶה עָלַי לַעֲשׂוֹת לָרֶשֶׁת חַיֵּי עוֹלָם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","וַיֹּאמֶר אֵלָיו מַה־כַּתוּב בַּתּוֹרָה אֵיךְ קָרָאתָ בָּהּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","וַיַּעַן וַיֹּאמַר וְאָהַבְתָּ אֵת יְהוָֹה אֱלֹהֶיךָ בְּכָל־לְבָבְךָ וּבְכָל־נַפְשְׁךָ וּבְכָל־מְאֹדֶךָ עוּבְכָל־ מַדָּעֲכָא וּלְרֵעֲךָ כָּמוֹךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","וַיֹּאמֶר אֵלָיו טוֹב עָנִיתָ עֲשֶׂה־כֵן וְתִחְיֶה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","וַיּוֹאֶל לְהַצְדִּיק נַפְשׁוֹ וַיֹּאמֶר אֶל־יֵשׁוּעַ וּמִי הוּא רֵעִי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","וַיַּעַן יֵשׁוּעַ וַיֹּאמַר אִישׁ אֶחָד יָרַד מִירוּשָׁלַיִם לִירִיחוֹ וַיִּפֹּל בִּידֵי שֹׁדְדִים אֲשֶׁר הִפְשִׁיטֻהוּ הִכֻּהוּ וַיִּפְנוּ וַיַּעַזְבוּ אֹתוֹ וְכִמְעַט לֹא נוֹתְרָה־בוֹ נְשָׁמָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","וַיִּקֶר לְאִישׁ כֹּהֵן מִקְרֵהוּ לָבֹא בַדֶּרֶךְ הַהוּא וַיִּרְאֵהוּ וַיֵּט מִפָּנָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","וְגַם־אִישׁ לֵוִי נִקְרָה בַמָּקוֹם הַהוּא וַיִּגַּשׁ וַיִּרְאֵהוּ וַיַּעֲבֹר מֵעָלָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","אַךְ אִישׁ שֹׁמְרוֹנִי בְּלֶכְתּוֹ לְמַסָּעָיו נִגַּשׁ אֵלָיו וַיִּרְאֵהוּ וַיִּכָּמְרוּ רַחֲמָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","וַיִּקְרַב וַיְחַבֵּשׁ אֶת־פְּצָעָיו וְשֶׁמֶן וְיַיִן יָצַק עָלָיו וַיַּרְכִּבֵהוּ עַל־בְּהֶמְתּוֹ וַיְבִאֵהוּ אֶל־הַמָּלוֹן וַיָּחָשׁ לוֹ לְכָל־מַחְסֹרָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","וּלְמָחֳרָת בְּנָסְעוֹ הוֹצִיא שְׁנֵי דִינָרִים וַיִּתֵּן לְבַעַל הַמָּלוֹן וַיֹּאמַר חוּשָׁה לּוֹ לְכָל־מַחְסֹרָיו וְכִי תוֹסִיף לְהוֹצִיא עָלָיו אֲנִי בְּשׁוּבִי אֲשַׁלֵּמָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","וְעַתָּה מַה־תֹּאמַר מִי מִשְּׁלֹשָׁה אֵלֶּה הָיָה רֵעַ לָאִישׁ אֲשֶׁר נָפַל בִּידֵי הַשֹּׁדְדִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","וַיַּעַן וַיֹּאמֶר זֶה הוּא אֲשֶׁר גָּמַל עִמּוֹ חָסֶד וַיֹּאמֶר אֵלָיו יֵשׁוּעַ לֵךְ וַעֲשֶׂה גַּם־אַתָּה כָּמֹהוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","וּבְנָסְעָם וַיָּבֹא אֶל־אַחַד הַכְּפָרִים וְשָׁם אִשָּׁה אַחַת וּשְׁמָהּ מַרְתָּא אֲשֶׁר אָסְפָה אֹתוֹ אֶל־בֵּיתָהּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","וְלָהּ אָחוֹת וּשְׁמָהּ מִרְיָם אֲשֶׁר יָשְׁבָה לְרַגְלֵי יֵשׁוּעַ לִשְׁמֹעַ אֶל־דְּבָרוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","וּמָרְתָּא עָיְפָה נַפְשָׁהּ מֵרֹב עֲבֹדָתָהּ וַתִּגַּשׁ אֵלָיו וַתֹּאמֶר הֲלֹא תָחוּשׁ לִי אֲדֹנִי כִּי אֲחוֹתִי עֲזָבַתְנִי לְשָׁרֵת לְבַדִּי אֱמָר־נָא אֵלֶיהָ לַעֲזֹר עַל־יָדִי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","וַיַּעַן יֵשׁוּעַ וַיֹּאמֶר אֵלֶיהָ מַרְתָּא מַרְתָּא עֲיֵפָה וִיגֵעָה אַתְּ מֵעִנְיָנִים רַבִּים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","וְאֵין דָּבָר נָחוּץ בִּלְתִּי עִנְיָן אֶחָד וּמִרְיָם בָּחֲרָה בַּחֵלֶק הַטּוֹב אֲשֶׁר לֹא־יֻקַּח מִיָּדֶיהָ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","וַיְהִי כְּכַלֹּתוֹ אֶת־תְּפִלָּתוֹ בְּמָקוֹם אֶחָד וַיֹּאמֶר אֵלָיו אֶחָד מִתַּלְמִידָיו יְלַמְּדֵנוּ אֲדֹנֵינוּ לְהִתְפַּלֵּל כַּאֲשֶׁר הוֹרָה כֵן גַּם־יוֹחָנָן לְתַלְמִידָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","וַיֹּאמֶר אֲלֵיהֶם כֹּה תֹאמְרוּן בִּתְפִלַּתְכֶם אָבִינוּ שֶׁבַּשָּׁמַיִם יִתְקַדַּשׁ שְׁמֶךָ תָּבֹא מַלְכוּתֶךָ יֵעָשֶׂה רְצוֹנְךָ בָּאָרֶץ כַּאֲשֶׁר נַעֲשָׂה בַשָּׁמָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","תֶּן־לָנוּ לֶחֶם חֻקֵּנוּ יוֹם בְּיוֹמוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","וּסְלַח לָנוּ אֶת־אַשְׁמוֹתֵינוּ כִּי גַּם־אֲנַחְנוּ סֹלְחִים לְכָל־אֲשֶׁר אָשַׁם לָנוּ וְאַל־תְּבִיאֵנוּ לִידֵי נִסָּיוֹן כִּי אִם־הַצִּילֵנוּ מִן־הָרָע׃ ");
INSERT INTO hebsg_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","וַיֹּאמֶר אֲלֵיהֶם מִי־בָכֶם אֲשֶׁר לוֹ אֹהֵב וְהוּא בָא אֶל־בֵּיתוֹ בַּחֲצוֹת הַלַּיְלָה וְקֹרֵא אֵלָיו קוּמָה רֵעִי הַלְוֵנִי־נָא שָׁלֹשׁ כִּכְּרוֹת־לָחֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","כִּי־אֹהֲבֵי עֹבֵר אֹרַח בָּא אֶל־בֵּיתִי וְאֵין־לִי פַת־לֶחֶם לְתִתּוֹ לְפָנָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","וְהַשֹּׁכֵן בַּבַּיִת עֹנֶה וְאֹמֵר אַל־תַּלְאֶה אֹתִי כִּי הַדֶּלֶת כְּבָר סֻגְּרָה וִילָדַי עִמִּי בְמִטָּתִי לֹא־אוּכַל לָקוּם לָתֶת לָךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","הֵן אֲנִי אֹמֵר לָכֶם כִּי הוּא יָקוּם וְיִתֶּן־לוֹ כְּכֹל אֲשֶׁר יֶחְסָר לֹא בַעֲבוּר כִּי אֹהֲבוֹ הוּא כִּי אִם־מֵאֲשֶׁר יִפְצַר־בּוֹ וְלֹא יַחֲשֹׁךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","וְגַם־אֲנִי אֹמֵר לָכֶם שַׁאֲלוּ וְיִנָּתֵן לָכֶם דִּרְשׁוּ וְתִמְצָאוּ דִּפְקוּ וְיִפָּתַח לָכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","כִּי כָּל־הַשֹּׁאֵל יִקַּח וְהַדֹּרֵשׁ יִמְצָא וְהַדֹּפֵק יִפָּתַח לוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","וּמִי אָב בָּכֶם אֲשֶׁר בְּנוֹ שָׁאַל מִמֶּנּוּ לֶחֶם וְהוּא יִתֶּן־לוֹ אָבֶן אִם־בִּקֵּשׁ דָּג וְתַחַת דָּג יִתֶּן־לוֹ נָחָשׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","אוֹ בֵיצָה כִּי־יִשְׁאַל וְהוּא יִתֶּן־לוֹ עַקְרָב׃ ");
INSERT INTO hebsg_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","וְאַתֶּם כִּי רָעִים הִנְּכֶם אַתֶּם יֹדְעִים לָתֵת מַתָּנוֹת טֹבוֹת לִבְנֵיכֶם אַף־כִּי הָאָב מִן־הַשָּׁמַיִם יִתֵּן רוּחַ קָדְשׁוֹ לְדֹרְשָׁיו׃ ");
INSERT INTO hebsg_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","וַיְהִי הַיּוֹם וַיְגָרֵשׁ רוּחַ רָע מֵאִישׁ אִלֵּם וְאַחֲרֵי אֲשֶׁר יָצָא הָרוּחַ הָרָע הֵחֵל הָאִלֵּם לְדַבֵּר וַיְהִי לְפֶלֶא בְּעֵינֵי הָעָם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","וְיֵשׁ מֵהֶם אָמְרוּ בְּבַעַל זְבוּב שַׂר־הַשֵּׁדִים הוּא מְגָרֵשׁ אֶת־הַשֵּׁדִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","וְיֵשׁ אֲשֶׁר רָצוּ לְנַסּוֹתוֹ וַיִּשְׁאֲלוּ מִמֶּנּוּ אוֹת מִן־הַשָּׁמָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","וְהוּא יָדַע אֶת־מַחְשְׁבֹתָם וַיֹּאמֶר אֲלֵיהֶם כָּל־מַמְלָכָה הַנִּפְלְגָה עַל־נַפְשָׁהּ תֶּחֱרָב וּבָתֶּיהָ בְתוֹכָהּ בַּיִת עַל־בַּיִת יִפֹּלוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","וְאִם גַּם־הַשָּׂטָן נִפְלַג עַל־נַפְשׁוֹ אֵיךְ תָּקוּם מַלְכוּתוֹ כִּי אֲמַרְתֶּם בְּבַעַל־זְבוּב אֲנִי מְגָרֵשׁ אֶת־הַשֵּׁדִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","וְאִם־אֲנִי מְגָרֵשׁ אֶת־הַשֵּׁדִים בְּבַעַל־זְבוּב בְּנֵיכֶם בְּמִי יְגָרְשׁוּ אֹתָם עַל־כֵּן הֵם יִהְיוּ שֹׁפְטֵיכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","וְאִם־בְּאֶצְבַּע אֱלֹהִים אֲנִי מְגָרֵשׁ אֶת־הַשֵּׁדִים מַלְכוּת הָאֱלֹהִים בָּאָה אֲלֵיכֶם אֶל־נָכוֹן׃ ");
INSERT INTO hebsg_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","בִּשְׁמֹר הַגִּבּוֹר אֶת־אַרְמוֹנוֹ וּכְלֵי נִשְׁקוֹ עָלָיו שָׁלוֹם יִהְיֶה לְכָל־קִנְיָנָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","וְאִם־תַּקִּיף מִמֶּנּוּ יָבֹא עָלָיו וְיָכֹל לוֹ יִשָּׂא מִמֶּנּוּ אֶת־נִשְׁקוֹ אֲשֶׁר בָּטַח־בּוֹ אַחַר יְחֻלַּק שְׁלָלוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","מִי אֲשֶׁר אֵינֶנּוּ לִי לְצָרַי הוּא וּמִי אֲשֶׁר אֵינֶנּוּ מְאַסֵּף אִתִּי מְפַזֵּר הוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","וְרוּחַ הַטֻּמְאָה בְּצֵאתָהּ מִן־הָאָדָם תְּשׁוֹטֵט בְּאֶרֶץ תַּלְאוּבֹת תְּבַקֵּשׁ וְלֹא־תִמְצָא מַרְגֵּעָה אָז תֹּאמַר אָשׁוּבָה אֶל־מִשְׁכָּנִי אֲשֶׁר יָצָאתִי מִשָּׁם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","וּבְשׁוּבָהּ תִּמְצָאֶנּוּ מְנֻקֶּה וּמְפֹאָר׃ ");
INSERT INTO hebsg_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","אָז תֵּלֵךְ וְלָקְחָה לָּהּ שֶׁבַע רוּחוֹת אֲחֵרוֹת רָעוֹת מִמֶּנָּה וּבָאוּ וְשָׁכְנוּ שָׁם וְהָיְתָה אַחֲרִית הָאִישׁ הַהוּא רָעָה מֵרֵאשִׁיתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","וַיְהִי כְּדַבְּרוֹ אֶת־הַדְּבָרִים הָאֵלֶּה וַתִּשָּׂא אִשָּׁה אַחַת מִתּוֹךְ הָעָם אֶת־קוֹלָהּ וַתֹּאמֶר אֵלָיו אַשְׁרֵי רֶחֶם הוֹרָתְךָ וְהַשָּׁדַיִם אֲשֶׁר יָנָקְתָּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","וַיֹּאמַר אַף כִּי־אַשְׁרֵי הַשֹּׁמְעִים אֶת־דְּבַר הָאֱלֹהִים וְשֹׁמְרִים אֹתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","וּבְהִקָּבֵץ אֵלָיו עַם־רָב וַיָּחֶל לְדַבֵּר הַדּוֹר הַזֶּה דּוֹר רָע הוּא וּמְבַקֵּשׁ אוֹת וְאוֹת לֹא יִנָּתֵן־לוֹ זוּלָתִי אוֹת יוֹנָה הַנָּבִיא׃ ");
INSERT INTO hebsg_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","כִּי כַּאֲשֶׁר הָיָה יוֹנָה לְאוֹת לְאַנְשֵׁי נִינְוֵה כֵּן יִהְיֶה גַם־בֶּן־הָאָדָם לַדּוֹר הַזֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","מַלְכַּת תֵּימָן תָּקוּם בַּמִּשְׁפָּט עִם־אַנְשֵׁי הַדּוֹר הַזֶּה וְתַרְשִׁיעַ אֹתָם כִּי בָאָה מִקְצוֹת הָאָרֶץ לִשְׁמֹעַ חָכְמַת שְׁלֹמֹה וְהִנֵּה יֶשְׁנוֹ בָזֶה גָּדוֹל מִשְּׁלֹמֹה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","אַנְשֵׁי נִינְוֵה יָקוּמוּ בַמִּשְׁפָּט עִם־הַדּוֹר הַזֶּה וְיַרְשִׁיעוּ אֹתוֹ כִּי שָׁבוּ בִּקְרִיאַת יוֹנָה וְהִנֵּה יֶשְׁנוֹ בָזֶה גָּדוֹל מִיּוֹנָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","אֵין מַדְלִיק־נֵר וּמֵשִׂים אֹתוֹ בַמִּסְתָּר אוֹ־מִתַּחַת לָאֵיפָה כִּי אִם אֶל־הַמְּנוֹרָה לְבַעֲבוּר יִרְאוּ הַבָּאִים אֶת־אוֹרוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","נֵר הַגּוּף הוּא הָעָיִן אִם־עֵינְךָ תְמִימָה בְּכָל־חַדְרֵי בִטְנְךָ יִהְיֶה אוֹר וְאִם־עֵינְךָ רָעָב חֹשֶׁךְ בְּכָל־חַדְרֵי בִטְנֶךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","עַל־כֵּן הִשָּׁמֵר־לְךָ לְבִלְתִּי יֶחְשַׁךְ הָאוֹר אֲשֶׁר בְּקִרְבֶּךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","אִם כָּל־גּוּפְךָ מָלֵא אוֹר וְאֵין חֹשֶׁךְ בְּכָל־חֲדָרָיו אָז יַגִּיהַּ לְךָ כְּלַפִּיד בָּהִיר בִּמְלֹא אוֹרוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","עוֹדֶנּוּ מְדַבֵּר וּפָרוּשׁ אֶחָד קָרָא־לוֹ לֶאֱכֹל אִתּוֹ לָחֶם וַיָּבֹא וַיֵּשֶׁב אֶל־שֻׁלְחָנוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","וַיַּרְא הַפָּרוּשׁ וַיִּתְמַהּ כִּי לֹא־רָחַץ אֶת־יָדָיו לִפְנֵי אָכְלוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","וַיֹּאמֶר אֵלָיו הָאָדוֹן הִנֵּה אַתֶּם הַפְּרוּשִׁים תְּטַהֲרוּ אֶת־הַכּוֹס וְאֶת־הַקְּעָרָה מִחוּץ וְקִרְבְּכֶם מָלֵא עֹשֶׁק וָאָוֶן׃ ");
INSERT INTO hebsg_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","כְּסִילִים הֲלֹא עֹשֵׂה הַחִיצוֹן הוּא עָשָׂה גַם אֶת־הַקֶּרֶב׃ ");
INSERT INTO hebsg_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","אֲבָל־תְּנוּ מֵאֲשֶׁר בְּקִרְבְּכֶם לָחֹן עֲנִיִּים וְהַכֹּל טָהוֹר יִהְיֶה לָכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","אַךְ אוֹי לָכֶם פְּרוּשִׁים כִּי תְעַשְּׂרוּ אֶת־הַמִּנְתָּא וְאֶת־הַפֵּיגַם וְאֶת־כָּל־יֶרֶק הַשָּׂדֶה וְתַעַזְבוּ אֶת־הַמִּשְׁפָּט וְאֶת־אַהֲבַת הָאֱלֹהִים אֵלֶּה עֲלֵיכֶם לַעֲשׂוֹת וְאֶת־אֵלֶּה אַל־תַּעֲזֹבוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","אוֹי לָכֶם פְּרוּשִׁים כִּי אֹהֲבִים אַתֶּם אֶת־הַמּוֹשָׁבוֹת הָרִאשֹׁנִים בְּבָתֵּי־הַכְּנֵסֶת וּשְׁאֵלַת שְׁלֹמְכֶם בַּשְּׁוָקִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","אוֹי לָכֶם הַסּוֹפְרִים וְהַפְּרוּשִׁים הַחֲנֵפִים כִּי כִּקְבָרִים כְּמוּסִים מֵעַיִן אַתֶּם וּבְנֵי אָדָם דֹּרְכִים עֲלֵיהֶם מִבְּלִי־דָעַת׃ ");
INSERT INTO hebsg_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","וַיַּעַן אֶחָד מֵבַּעֲלֵי הַתּוֹרָה וַיֹּאמֶר אֵלָיו רַבֵּנוּ בִּדְבָרֶיךָ אֵלֶּה חֵרַפְתָּ גַּם־אֹתָנוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","וַיֹּאמַר אוֹי לָכֶם בַּעֲלֵי הַתּוֹרָה גַּם־אַתֶּם כִּי תַעַמְסוּ עַל־שְׁכֶם אֲנָשִׁים מַשָּׂא כָּבֵד מִנְּשׁא וְאֵין אֶת־נַפְשְׁכֶם לְהָנִיעַ אֹתוֹ גַּם־בְּאַחַת מֵאֶצְבְּעוֹתֵיכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","אוֹי לָכֶם כִּי תִבְנוּ אֶת־קִבְרֵי הַנְּבִיאִים וַאֲבוֹתֵיכֶם הָרְגוּ אֹתָם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","וּבְכֵן אַתֶּם מְעִידִים לְמַעֲשֵׂי אֲבוֹתֵיכֶם וְנֹטִים אַחֲרֵיהֶם כִּי הֵם הָרְגוּ אֹתָם וְאַתֶּם בּוֹנִים אֶת־קִבְרֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","בַּעֲבוּר זֹאת כֹּה אָמְרָה חָכְמַת הָאֱלֹהִים הִנְנִי שֹׁלֵחַ אֲלֵיהֶם נְבִיאִים וּשְׁלִיחִים וּמֵהֶם יַהַרְגוּ וּמֵהֶם יִרְדֹּפוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","לְמַעַן יִדָּרֵשׁ מִן־הַדּוֹר הַזֶּה דַּם כָּל־הַנְּבִיאִים הַשָּׁפוּךְ לְמִן־הִוָּסֵד הָאָרֶץ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","מִדַּם־הֶבֶל עַד־דַּם זְכַרְיָה אֲשֶׁר נֶהֱרַג בֵּין הַמִּזְבֵּחַ וְלַבָּיִת אָכֵן אֲנִי מַגִּיד לָכֶם כִּי דָרוֹשׁ יִדָּרֵשׁ מִן־הַדּוֹר הַזֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","אוֹי לָכֶם בַּעֲלֵי הַתּוֹרָה כִּי־לְקַחְתֶּם לָכֶם אֶת־מַפְתֵּחַ הַדָּעַת אַתֶּם לֹא תָבֹאוּ שָׁמָּה וְאֶת־הַבָּאִים מִבֹּא תִּכְלָאוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","וַיְהִי בְּצֵאתוֹ מִשָּׁם וַיָּחֵלּוּ הַסּוֹפְרִים וְהַפְּרוּשִׁים לְהָצֶק־לוֹ וּלְהִתְגָּרוֹת בּוֹ עַד אֲשֶׁר־יְדַבֵּר קָשׁוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","וַיֶּאֶרְבוּ לוֹ לָצוּד דָּבָר מִפִּיו לְמַעַן יִמְצְאוּ עָלָיו שִׂטְנָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","וַיְהִי בֵּין־כֹּה וָכֹה וַהֲמוֹן הָעָם הִתְאַסְּפוּ לִרְבָבוֹת עַד אֲשֶׁר־דָּרְכוּ אִישׁ עַל־רֵעֵהוּ וְהוּא הֵחֵל לְדַבֵּר אֶל־תַּלְמִידָיו לֵאמֹר בְּרֵאשִׁית כֹּל הִשָּׁמְרוּ לָכֶם מִשְּׂאֹר הַפְּרוּשִׁים הֲלֹא הוּא הַחֲנֻפָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","וְאֵין דָּבָר נִסְתָּר אֲשֶׁר לֹא יִגָּלֶה וְאֵין נֶעְלָם אֲשֶׁר לֹא יִוָּדֵעַ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","לָכֵן אֶת־אֲשֶׁר דִּבַּרְתֶּם בַּחֹשֶׁךְ יִשָּׁמַע לְעֵין הַשָּׁמֶשׁ וְלַחַשׁ שִׂפְתוֹתֵיכֶם הִשְׁמַעְתֶּם לָאֹזֶן חֶדֶר בְּחֶדֶר יִקָּרֵא עַל־הַגַּגּוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","וַאֲנִי אֹמֵר לָכֶם אֹהֲבַי אַל־תִּירְאוּ מִפְּנֵי מְמִיתֵי הַגֵּו אֲשֶׁר אַחֲרֵי כֵן אֵין־לְאֵל יָדָם לְהָרַע לוֹ עוֹד׃ ");
INSERT INTO hebsg_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","אַךְ אֲנִי מְחַוֶּה לָכֶם אֶת־מִי תִירָאוּ יְראוּ אֹתוֹ אֲשֶׁר יָדָיו רַב לוֹ לְהַשְׁלִיךְ אֶת־הַמּוּמָת אֶל־גֵּיהִנֹּם אָכֵן אֲנִי אֹמֵר לָכֶם אֹתוֹ תִּירָאוּן׃ ");
INSERT INTO hebsg_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","הֲלֹא תִמָּכַרְנָה חָמֵשׁ צִפֳּרִים בִּשְׁנֵי אִסָּרִים וְאֵין־אַחַת מֵהֶן נִשְׁכַּחַת לִפְנֵי אֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","וְאַתֶּם גַּם־שַׂעֲרוֹת רֹאשְׁכֶם נִמְנוּ בְמִסְפָּר כֻּלָּן אַל־תִּירְאוּ עֶרְכְּכֶם רַב מִצִּפֳּרִים רַבּוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","וַאֲנִי הִנְנִי מַגִּיד לָכֶם כָּל־אִישׁ אֲשֶׁר יוֹדֶה בִי לִפְנֵי בְנֵי־אָדָם גַּם־כֵּן בֶּן־הָאָדָם יוֹדֶה בוֹ לִפְנֵי מַלְאֲכֵי הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","וּמִי אֲשֶׁר יְכַחֶשׁ־בִּי לִפְנֵי בְנֵי אָדָם אַכֲחֶשׁ־בּוֹ לִפְנֵי מַלְאֲכֵי הָאֱלֹהִים גַּם־אֲנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","כָּל־אִישׁ אֲשֶׁר יְדַבֵּר דָּבָר בְּבֶן־הָאָדָם יִסָּלַח לוֹ אַךְ הַמְגַדֵּף אֶת־רוּחַ הַקֹּדֶשׁ לוֹ לֹא יִסָּלַח לוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","וְכַאֲשֶׁר יָבִיאוּ אֶתְכֶם אֶל־בָּתֵּי־הַכְּנֵסֶת וְלִפְנֵי הָרָאשִׁים וְהַשַּׁלִיטִים אַל־תֶּחֶרְדוּ לֵאמֹר אֵיכָה נְדַבֵּר אוֹ מַה־נְּדַבֵּר׃ ");
INSERT INTO hebsg_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","כִּי־רוּחַ הַקֹּדֶשׁ יְחַוֶּה לָכֶם בְּעֶצֶם הָעֵת הַהִיא אֵת אֲשֶׁר תְּדַבֵּרוּן׃ ");
INSERT INTO hebsg_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","וַיֹּאמֶר אֵלָיו אֶחָד מִן־הָעָם רַבִּי צַו אֶת־אָחִי לְחַלֵּק אִתִּי אֶת־הַיְרֻשָּׁה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","וַיַּעַן אֹתוֹ וַיֹּאמַר בֶּן־אָדָם מִי שָׂמַנִי לְשֹׂפֵט עֲלֵיכֶם אוֹ לִמְחַלֵּק׃ ");
INSERT INTO hebsg_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","וַיֹּאמֶר אֲלֵיהֶם רְאוּ וְהִשָּׁמְרוּ לָכֶם מִכָּל־בֶּצַע מַעֲשַׁקּוֹת כִּי לֹא בְרֹב נְכָסִים חַיֵּי אָדָם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","וַיִּשָּׂא אֲלֵיהֶם מְשָׁלוֹ וַיֹּאמַר אִישׁ עָשִׁיר הָיָה אֲשֶׁר שָׂדֵהוּ עָשָׂה פְּרִי תְבוּאָה לְמַכְבִּיר׃ ");
INSERT INTO hebsg_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","וְהוּא דִבֵּר עַל־לִבּוֹ מָה־אֶעֱשֶׂה כִּי אֵין־לִי מָקוֹם לְהָכִיל אֶת־תְּבוּאָתִי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","וַיֹּאמַר זֶה אֲשֶׁר אֲנִי עֹשֶׂה אֶהֱרֹס אֶת־בָּתֵּי הַמִּסְכְּנוֹת וּגְדוֹלִים מֵהֶם אֶבְנֶה וְשָׁמָּה אֶאֱסֹף דְּגָנִי וְכָל־טוּבִי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","וְכֹה אֹמַר לְנַפְשִׁי יֶשׁ־לָךְ נַפְשִׁי טוֹבָה הַרְבֵּה צְבוּרָה לְיָמִים רַבִּים הֵרָגְעִי אִכְלִי שְׁתִי וְגִילִי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","אַךְ אֱלֹהִים אָמַר לוֹ סָכָל בַּלַּיְלָה הַזֶּה יִדְרְשׁוּ אֶת־נַפְשְׁךָ מִמֶּךָ וּלְמִי יִהְיֶה אֲשֶׁר הֲכִינוֹתָ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","כֵּן הוּא הָאִישׁ אֲשֶׁר יֶאֱצַר לוֹ אֹצָרוֹת לְבַדּוֹ וְאֵין לוֹ עֹשֶׁר לֵאלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","וַיֹּאמֶר אֶל־תַּלְמִידָיו עַל־כֵּן אֲנִי אֹמֵר לָכֶם לֹא תָחוּשׁוּ לְנַפְשְׁכֶם לֵאמֹר מַה־נֹּאכֵל אוֹ לִבְשַׂרְכֶם מַה־נִלְבָּשׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","הֵן עֵרֶךְ הַנֶּפֶשׁ רַב מֵאֹכֶל וְעֵרֶךְ הַגּוּף מִלְּבוּשָׁיו׃ ");
INSERT INTO hebsg_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","הִתְבּוֹנְנוּ אֶל־הָעֹרְבִים אֲשֶׁר לֹא יִזְרְעוּ וְלֹא יִקְצְרוּ וְאֵין לָהֶם מְגוּרָה אוֹ גֹרֶן וֵאלֹהִים נָתַן לָהֶם לַחְמָם וּמָה רַב עֶרְכְּכֶם מֵעוֹף כָּנָף׃ ");
INSERT INTO hebsg_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","וּמִי מִכֶּם יוּכַל לְהוֹסִיף עַל־קוֹמָתוֹ גֹּמֶד אֶחָד עֵקֶב דַּאֲגָתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","וְעַל־כֵּן אִם דָּבָר קָטֹן לֹא תוּכְלוּ עֲשׂוֹת מַה־תּוֹעִילוּ בְדַאֲגַתְכֶם לְיֶתֶר הַדְּבָרִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","הַבִּיטוּ אֶל־הַשּׁוֹשַׁנִּים אֵיכָה יַעֲלוּ יָצִיצוּ וְלֹא יִיגְעוּן וְלֹא יִטְווּן וַאֲנִי אֹמֵר לָכֶם גַּם שְׁלֹמֹה בְּכָל־הֲדָרוֹ לֹא־הָיָה לָבוּשׁ כְּאֶחָד מֵהֵנָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","וְאִם־כָּכָה יַעֲטֶה אֱלֹהִים אֶת־עֵשֶׂב הַשָּׂדֶה אֲשֶׁר יָצִיץ הַיּוֹם וּלְמָחֳרָתוֹ יֻתַּן בַּתַּנּוּר אַף כִּי־אֶתְכֶם קְטַנֵּי אֱמֻנָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","וְגַם־אַתֶּם לֹא תְבַקְּשׁוּ מַה־תֹּאכְלוּ וּמַה־תִּשְׁתּוּ וְלִבְּכֶם לֹא יָנוּעַ הֵנָּה וָהֵנָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","כִּי כָּאֵלֶּה מְבַקְשִׁים גּוֹיֵי הָאֲרָצוֹת וַאֲבִיכֶם יֹדֵעַ כִּי־אֵלֶּה צָרְכֵיכֶם הֵמָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","אַךְ בַּקְּשׁוּ אֶת־מַלְכוּת הָאֱלֹהִים וְהַחֲפָצִים הָהֵם יִנָּתְנוּ לָכֶם מַתָּנוֹת נוֹסָפוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","אַל־תִּירָא עֵדֶר קָטֹן כִּי חֵפֶץ אֲבִיכֶם הוּא לָתֵת לָכֵם אֶת הַמַּלְכוּת׃ ");
INSERT INTO hebsg_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","מִכְרוּ אֶת אֲשֶׁר לָכֶם וּתְנוּ לָאֶבְיוֹנִים עֲשׂוּ לָכֶם צְרֹרוֹת אֲשֶׁר לֹא יִבֹּלוּ וְאוֹצָר בַּשָּׁמַיִם אֲשֶׁר לֹא יִגָּרַע מִמֶּנּוּ לְעוֹלָם גַּנָּב לֹא־יִגַּשׁ שָׁמָּה וְעָשׁ לֹא יֹאכְלֶנּוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","כִּי בִּקְמוֹם אוֹצַרְכֶם שָׁם יְהִי גַּם־לְבַבְכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","הִתְיַצְּבוּ בְּמָתְנַיִם חֲגֻרִים וְנֵרוֹת דֹּלְקִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","וֶהֱיוּ כַאֲנָשִׁים מְחַכִּים לְשׁוּב אֲדֹנֵיהֶם מִן־חֲתֻנָּתוֹ וְכַאֲשֶׁר יָבֹא וְיִדְפֹּק יִפְתְחוּ־לוֹ כְּרָגַע׃ ");
INSERT INTO hebsg_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","אַשְׁרֵי הָעֲבָדִים הָהֵם אֲשֶׁר בְּשׁוּב אֲדֹנֵיהֶם יִמְצָאֵם שֹׁקְדִים עַל־מִשְׁמַרְתָּם אָמֵן אֲנִי אֹמֵר לָכֶם כִּי הוּא יַחֲגֹר מָתְנָיו יוֹשִׁיבֵם אֶל־הַשֻּׁלְחָן וְיִקְרַב וִישָׁרֵת אֹתָם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","אִם־בָּאַשְׁמֻרָה הַשֵּׁנִית יָבֹא אוֹ אִם־בַּשְּׁלִישִׁית וְכֵן יִמְצָאֵם אַשְׁרֵי הָעֲבָדִים הָהֵם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","וְזֹאת שִׂימוּ עַל־לֵב כִּי־לוּ יָדַע בַּעַל הַבַּיִת אֶת־הַשָּׁעָה בָּה יָבוֹא הַגַּנָּב הָיָה עֹמֵד עַל־מִשְׁמַרְתּוֹ וְלֹא־נָתַן לַחְתֹּר בְּבֵיתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","לָכֵן גַּם־אַתֶּם הֱיוּ נְכֹנִים כִּי בֶּן־הָאָדָם יָבוֹא בְּשָׁעָה אֲשֶׁר לֹא תָשִׂימוּ עַל־לֵב׃ ");
INSERT INTO hebsg_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","וַיֹּאמֶר פֶּטְרוֹס הֲלָנוּ אֲדֹנֵינוּ נָשָׂאתָ אֶת־הַמָּשָׁל הַזֶּה אוֹ אִם־גַּם לְכֻלָּם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","וַיֹּאמֶר הָאָדוֹן וּמִי־הוּא אִישׁ נֶאֱמָן וְנָבוֹן אֲשֶׁר אֲדֹנָיו הִפְקִידוֹ עַל־בְּנֵי בֵיתוֹ לָתֵת לָהֵם אֶת־אָכְלָם בְּעִתּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","אַשְׁרֵי הָעֶבֶד הַהוּא אֲשֶׁר בְּבֹאוֹ יִמְצָאֶנּוּ אֲדֹנָיו כִּי כֵן עָשָׂה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","אָמֵן אֲנִי אֹמֵר לָכֶם כִּי יַפְקִדֵהוּ עַל־כָּל־אֲשֶׁר יֶשׁ־לוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","וְאִם־הָעֶבֶד הַהוּא יֹאמַר בְּלִבּוֹ בֹּשֵׁשׁ אֲדֹנִי לָבֹא וְהֵחֵל לְהַכּוֹת אֶת־הָעֲבָדִים וְאֶת־הַשְּׁפָחוֹת וְלֶאֱכֹל וְלִשְׁתּוֹת וְלִשְׁכֹּר׃ ");
INSERT INTO hebsg_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","בֹּא יָבֹא אֲדֹנֵי הָעֶבֶד הַהוּא בְּיוֹם אֲשֶׁר לֹא־יְצַפֶּה לּוֹ וּבְשָׁעָה אֲשֶׁר לֹא־יֵדַע וִישַׁסֵּף אֹתוֹ וְאֶת־הַסּוֹרְרִים יִתֵּן חֶלְקוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","וְהָעֶבֶד הַיֹּדֵעַ מָה רְצוֹן אֲדֹנָיו וְלֹא יָחוּשׁ וְלֹא יַעֲשֶׂה כִרְצֹנוֹ יִוָּסֵר בְּמַכּוֹת קָשׁוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","וְהוּא אֲשֶׁר אֵינֶנּוּ יֹדֵעַ וְעָשָׂה חֵטְא מִשְׁפַּט מַכּוֹת יִוָּסֵר בְּמַכּוֹת קַלּוֹת כִּי כָל־אִישׁ אֲשֶׁר נִתַּן־לוֹ הַרְבֵּה יִדָּרֵשׁ מִנֶּנּוּ הַרְבֵּה וְאִישׁ אֲשֶׁר הָפְקַד בְּיָדוֹ פִּקָּדוֹן רָב כֵּן יְבֻקַּשׁ מִיָּדוֹ בְּקַו יָתֵר׃ ");
INSERT INTO hebsg_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","וַאֲנִי בָאתִי לְהַבְעִיר אֵשׁ בָּאָרֶץ וּמַה־חֶפְצִי עוֹד אִם כְּבָר בֹּעָרֶת׃ ");
INSERT INTO hebsg_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","וְגַם־טְבִילָה עָלַי לְהִטָּבֶל־בָּהּ וּמַה־צַּר לִי עַד כִּי־תִתֹּם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","הַאִם תַּחְשְׁבוּן כִּי בָאתִי לָתֵת שָׁלוֹם בָּאָרֶץ אֲנִי אֹמֵר לָכֶם לֹא־כֵן כִּי אִם־מַחֲלֹקֶת׃ ");
INSERT INTO hebsg_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","כִּי אִם־חֲמִשָּׁה יִהְיוּ בְּבַיִת אֶחָד יָקוּמוּ מֵעַתָּה שְׁלֹשָׁה עַל־שְׁנַיִם וּשְׁנַיִם עַל־שְׁלֹשָׁה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","אָב יָקוּם בִּבְנוֹ וּבֵן בְּאָבִיו אֵם בְּבִתָּהּ וּבַת בְּאִמָּהּ חָמוֹת בְּכַלַּתָהּ וְכַלָּה בַּחֲמֹתָהּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","וַיֹּאמֶר גַּם אֶל־הֲמוֹן הָעָם כַּאֲשֶׁר תִּרְאוּ עָנָן עֹלֶה מִמַּעֲרָב תָּחִישׁוּ לְהַגִּיד כִּי יָבֹא גֶשֶׁם וְכֵן יִהְיֶה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","וְאִם־רוּחַ נֶגֶב נֹשֶׁבֶת תֹּאמְרוּ כִּי חֹם יָבֹא וְכֵן יִהְיֶה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","הֵן יְדַעְתֶּם חֲנֵפִים לִבְחֹן אֶת־פְּנֵי הָאָרֶץ וְאֶת־פְּנֵי הַשָּׁמָיִם וְאֵיךְ לֹא יְדַעְתֶּם לִבְחֹן גַּם אֶת־הָעֵת הַזֹּאת׃ ");
INSERT INTO hebsg_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","וְגַם מֵרוּחַ מִבִּנַתְכֶם לָמָּה לֹא תוֹצִיאוּ מִשְׁפָּט יָשָׁר׃ ");
INSERT INTO hebsg_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","כַּאֲשֶׁר תֵּלֵךְ עִם־אִישׁ רִיבְךָ אֶל־הָרֹאשׁ הִתְאַמֵּץ לְהִנָּצֵל מִיָּדוֹ עוֹדְךָ בַדָּרֶךְ פֶּן־יוֹבִילְךָ לִפְנֵי הַשֹּׁפֵט וְהַשֹּׁפֵט יַסְגִּירְךָ בְּיַד הַשּׁוֹטֵר וְהַשּׁוֹטֵר יִתֶּנְךָ לְבֵית הַסֹּהַר׃ ");
INSERT INTO hebsg_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","וַאֲנִי אֹמֵר לְךָ כִּי לֹא תַעֲלֶה מִשָּׁם עַד אֲשֶׁר־תְּשַׁלֵּם אֶת־הַפְּרוּטָה הָאַחֲרֹנָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","בָּעֵת הַהִיא בָּאוּ אֲנָשִׁים וַיַּגִּידוּ לוֹ אֶת־דְּבַר הַגְּלִילִים אֲשֶׁר פִּילָטוֹס מָסַךְ דָּמָם עַל־זִבְחֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","וַיַּעַן יֵשׁוּעַ וַיֹּאמֶר אֲלֵיהֶם הַאִם תַּחְשְׁבוּ כִּי־הַגְּלִילִים הָהֵם הָיוּ חַטָּאִים מִכָּל־יֹשְׁבֵי הַגָּלִיל אַחֲרֵי אֲשֶׁר־נָשְׂאוּ עֹנֶשׁ זֶה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","אֲנִי אֹמֵר לָכֶם לֹא־כֵן וְאִם אַתֶּם לֹא תָשׁוּבוּ כֻּלְכֶם כְּמוֹ־כֵן תֹּאבֵדוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","אוֹ שְׁמֹנָה עָשָׂר הָאֲנָשִׁים אֲשֶׁר נָפַל עֲלֵיהֶם הַמִּגְדָּל בִּשְׁלֹּחַ וָמֵתוּ הֲתַחְשְׁבוּ כִּי־אֲשֵׁמִים הָיוּ מִכָּל־ישְׁבֵי יְרוּשָׁלָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","אֲנִי אֹמֵר לָכֶם לֹא־כֵן וְאִם אַתֶּם לֹא תָשׁוּבוּ כֻּלְּכֶם כְּמוֹ־כֵן תֹּאבֵדוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","וַיִּשָׂא מְשָׁלוֹ וַיֹּאמֶר אִישׁ אֶחָד הָיָה אֲשֶׁר־לוֹ תְאֵנָה נְטוּעָה בְכַרְמוֹ וַיָּבֹא לְבַקֵּשׁ אֶת־פִּרְיָהּ וְלֹא מָצָא׃ ");
INSERT INTO hebsg_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","וַיֹּאמֶר אֶל־הַכֹּרֵם הִנֵּה־זֶה שָׁלשׁ שָׁנִים בָּאתִי אֶל־הַתְּאֵנָה הַזֹּאת לְבַקֵּשׁ אֶת־פִּרְיָהּ וְלֹא מָצָאתִי כְּרֹת אֹתָהּ כִּי לָמָּה־זֶּה תַשְׁחִית אֶת־אַדְמָתִי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","וַיַּעַן וַיֹּאמֶר אֵלָיו אֲדֹנִי הַנַּח לָהּ עוֹד הַשָּׁנָה הַזֹּאת עַד כִּי־אֶעְדֹּר וְאֶתֵּן דֹּמֶן מִסָּבִיב לָהּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","אוּלַי תַּעֲשֶׂה פְרִי בַּשָּׁנָה הַבָּאָה וְאִם־אַיִן תִּכְרֹת אֹתָהּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","וַיְהִי בְּיוֹם הַשַּׁבָּת וַיְלַמֵּד בְּאַחַד בָּתֵּי־הַכְּנֵסֶת׃ ");
INSERT INTO hebsg_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","וְשָׁם אִשָּׁה אֲשֶׁר כִּהֲתָה רוּחָהּ וַתֶּחֱלַשׁ זֶה שְׁמֹנֶה עֶשְׂרֶה שָׁנָה וְהִיא כְפוּפָה וְאֵין סוֹמֵךְ וְאֵין זֹקֵף לָהּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","וַיַּרְא אֹתָהּ יֵשׁוּעַ וַיִּקְרָא וַיֹּאמֶר אֵלֶיהָ אִשָּׁה הִנֵּה חֻלַּצְתְּ מֵחָלְיֵךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","וַיָּשֶׂם אֶת־יָדָיו עָלֶיהָ וַתְּמַהֵר וַתַּעֲמֹד בִּמְלֹא קוֹמָתָה וַתִּתֵּן כָּבוֹד לֵאלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","אַךְ רֹאשׁ בֵּית־הַכְּנֵסֶת חָרָה־לוֹ כִּי רִפָּא יֵשׁוּעַ בְּיוֹם הַשַּׁבָּת וַיַּעַן וַיֹּאמֶר אֶל־הָעָם שֵׁשֶׁת יָמִים תֵּעָשֶׂה כָל־מְלָאכָה בָּאֵלֶּה בֹּאוּ וְהֵרָפְאוּ וְלֹא בְּיוֹם הַשַּׁבָּת׃ ");
INSERT INTO hebsg_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","וַיַּעַן הָאָדוֹן וַיֹּאמֶר אֵלָיו חֲנֵפִים הֲלֹא אִישׁ אִישׁ מִכֶּם יַתִּיר אֶת־שׁוֹרוֹ וְאֶת חֲמֹרוֹ מִן־הָאֵבוּס וְיוֹלִיכֶנּוּ לְהַשְׁקֹתוֹ בְּיוֹם הַשַּׁבָּת׃ ");
INSERT INTO hebsg_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","וּבַת־אַבְרָהָם זֹאת אֲשֶׁר אָסַר אֹתָהּ הַשָּׂטָן זֶה שְׁמֹנֶה עֶשְׂרֶה שָׁנָה לֹא תֻתַּר מֵאֲסוּרֶיהָ בְּיוֹם הַשַּׁבָּת׃ ");
INSERT INTO hebsg_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","וּמִדֵּי דַבְּרוֹ כָזֹאת חָפְרוּ כָּל־מִתְקוֹמְמָיו וַיִּשְׂמַח כָּל־הָעָם עַל־כָּל־הַגְּדֹלוֹת אֲשֶׁר עָשְׂתָה יָדוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","וַיֹּאמֶר מַה־דְּמוּת לְמַלְכוּת הָאֱלֹהִים וּמָה אַשְׁוֶה לָהּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","דִּמְיוֹנָהּ כְּגַרְגַּר חַרְדָּל אֲשֶׁר לָקַח אִישׁ וַיִּתְּנֵהוּ בְגַנּוֹ וַיִּצְמַח וַיְהִי לְעֵץ גָּדוֹל עַד־אֲשֶׁר עוֹף הַשָּׁמַיִם קִנְּנוּ בַּעֲנָפָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","וַיּוֹסֶף וַיֹּאמַר מַה־דְּמוּת לְמַלְכוּת הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","דִּמְיוֹנָהּ כִּשְׂאֹר אֲשֶׁר לָקְחָה אִשָּׁה וַתָּלָשׁ בִּשְׁלשׁ סְאִים קֶמַח עַד־אֲשֶׁר חָמְצָה כָּל־הָעֲרִיסָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","וַיַעֲבֹר דֶּרֶךְ עָרִים וּכְפָרִים עָבוֹר וְלַמֵּד וְנָסוֹעַ יְרוּשָׁלָיְמָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","וַיִּשְׁאָלֵהוּ אִישׁ לֵאמֹר אֲדֹנִי הֲרַק מְתֵי מִסְפָּר יִוָּשֵׁעוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","וַיֹּאמֵר אֲלֵיהֶם הִתְאַמְּצוּ לָבֹא בַּשַּׁעַר הַצָּר כִּי אֲנִי אֹמֵר לָכֶם רַבִּים יְבַקְשׁוּ וְלֹא יוּכְלוּ לָבֹא׃ ");
INSERT INTO hebsg_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","בָּעֵת הַהִיא אֲשֶׁר יָקוּם אֲדֹנֵי הַבַּיִת וְסָגַר אֶת־הַדָּלֶת וְאַתֶּם תָּבֹאוּ וְתַעַמְדוּ מִחוּץ מִתְדַּפְּקִים עַל־הַדֶּלֶת לֵאמֹר אֲדֹנֵינוּ פְּתַח־לָנוּ וְהוּא יַעֲנֶה וְיֹאמַר לֹא יָדַעְתִּי אֶתְכֶם אֵי־מִזֶּה אַתֶּם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","אָז תָּחֵלּוּ לֵאמֹר הֲלֹא אָכַלְנוּ וְשָׁתִינוּ לְפָנֶיךָ וּבִרְחֹבֹתֵינוּ הוֹרֵיתָ לָּנוּ תּוֹרָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","וְהוּא יַעֲנֶה הֵן אֲנִי אֹמֵר לָכֶם לֹא יָדַעְתִּי אֵי־מִזֶּה אַתֶּם סוּרוּ מִמֶּנִּי כָּל־פֹּעֲלֵי אָוֶן׃ ");
INSERT INTO hebsg_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","וְאָז יִהְיֶה בְכִי וַחֲרֹק שִׁנָּיִם כִּי תִרְאוּ אַבְרָהָם וְיִצְחָק וְיַעֲקֹב וְכָל־הַנְּבִיאִים בְּמַלְכוּת הָאֱלֹהִים וְאַתֶּם נִדָּחִים תִּהְיוּ מִחוּץ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","וּמִמִּזְרָח וּמִמַּעֲרָב וּמִצָּפוֹן וּמִיָּם יָבֹאוּ וְיֵשְׁבוּ עִמָּם בְּמַלְכוּת הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","וְהִנֵּה יֵשׁ אַחֲרֹנִים אֲשֶׁר יִהְיוּ רִאשֹׁנִים וְרִאשֹׁנִים אֲשֶׁר יִהְיוּ אַחֲרֹנִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","בַּשָּׁעָה הַהִיא בָּאוּ מִקְצוֹת הַפְּרוּשִׁים וַיֹּאמְרוּ אֵלָיו צֵא וְלֵךְ מִזֶּה כִּי הוֹרְדוֹס מְבַקֵּשׁ לְהָרְגֶךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","וַיֹּאמֶר אֲלֵיהֶם לְכוּ וְהַגִּידוּ לַשּׁוּעָל הַזֶּה הִנְנִי מְגָרֵשׁ רוּחוֹת רָעוֹת וְרֹפֵא חוֹלִים הַיּוֹם וּבְיוֹם מָחָר וּבַיּוֹם הַשְּׁלִישִׁי אָבֹא עַד־קִצִּי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","אַךְ הָלוֹךְ אֵלֵךְ הַיּוֹם וּלְיוֹם מָחָר וּלְיוֹם הַבָּא אַחֲרָיו כִי כֵן לֹא־יֵעָשֶׂה כִּי נָבִיא יֹאבַד מִחוּץ לִירוּשָׁלָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","יְרוּשָׁלַיִם יְרוּשָׁלַיִם הַהֹרֶגֶת אֶת־הַנְּבִיאִים וְהַסֹּקֶלֶת אֶת־הַשְּׁלוּחִים אֵלָיִךְ עַד־כַּמֶּה פְעָמִים חָפַצְתִּי לְקַבֵּץ אֶת־בָּנַיִךְ כַּאֲשֶׁר תְּקַבֵּץ תַּרְנְגֹלֶת אֶת־אֶפְרֹחֶיהָ תַּחַת כְּנָפֶיהָ וְלֹא אֲבִיתֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","הִנֵּה בֵּיתְכֶם יִשָּׁאֵר לָכֵם חָרְבָּה וַאֲנִי אָמֵן אֹמֵר לָכֶם כִּי לֹא תִרְאֻנִי עוֹד עַד כִּי־תֹאמְרוּן בָּרוּךְ הַבָּא בְּשֵׁם יְהוָֹה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","וַיְהִי בְּיוֹם הַשַּׁבָּת וַיָּבֹא אֶל־בֵּית אֶחָד מֵרָאשֵׁי הַפְּרוּשִׁים לֶאֱכֹל לָחֶם וְהֵם אָרְבוּ לוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","וְהִנֵּה אִישׁ לְפָנָיו אֲשֶׁר בְּשָׂרוֹ צָבָה מָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","וַיַּעַן יֵשׁוּעַ וַיֹּאמֶר אֶל־בַּעֲלֵי הַתּוֹרָה וְאֶל־הַפְּרוּשִׁים לֵאמֹר הֲכִי כַתּוֹרָה לְרַפֵּא בְּיוֹם הַשַּׁבָּת אִם־לֹא וַיַּחֲרִישׁוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","וַיִּקַח וַיִּרְפָּא אֹתוֹ וַיְשַׁלְּחֵהוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","וַיֹּאמֶר אֲלֵיהֶם מִי־מִכֶּם אֲשֶׁר חֲמֹרוֹ אוֹ שׁוֹרוֹ נָפַל אֶל־הַבּוֹר בְּיוֹם הַשַּׁבָּת וְלֹא יָחִישׁ מַעֲשֵׂהוּ לְהַעֲלֹתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","וְלֹא יָכְלוּ לְהָשִׁיב דָּבָר עַל־זֹאת׃ ");
INSERT INTO hebsg_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","וְכִרְאוֹתוֹ אֶת־הַקְּרֻאִים אֲשֶׁר בָּחֲרוּ לָהֶם אֶת־רָאשֵׁי הַמּוֹשָׁבוֹת וַיִּשָּׂא אֶת־מְשָׁלוֹ אֲלֵיהֶם וַיֹּאמַר׃ ");
INSERT INTO hebsg_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","כִּי־יִקְרָא אֹתְךָ אִישׁ אֶל־חֲתֻנָּתוֹ לֹא תֵשֵׁב עַל־מוֹשָׁב הָרֹאשׁ פֶּן־נִקְרָא שָׁם אִישׁ נִכְבָּד מִמֶּךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","וּבָא הָאִישׁ אֲשֶׁר קָרָא אֶת־שְׁנֵיכֶם וְאָמַר אֵלֶיךָ הַנַּח מְקוֹמְךָ לָאִישׁ הַזֶּה וְאָז תָּקוּם בְּבָשְׁתְּךָ לָקַחַת אֶת־הַמּוֹשָׁב הַשָּׁפֵל׃ ");
INSERT INTO hebsg_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","אַךְ אִם קָרוּא אַתָּה לֵךְ וְשֵׁב עַל־הַמּוֹשָׁב הַשָּׁפֵל וְהַקֹּרֵא אֹתְךָ יָבֹא וְיֹאמַר אֵלֶיךָ יְדִידִי עֲלֵה מִזֶּה מָעְלָה וְהָיָה־לְךָ לְכָבוֹד לִפְנֵי כָּל־הַיֹּשְׁבִים בִּמְסִבָּה עִמָּךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","כִּי כָּל־הַמִּתְנַשֵּׂא בְגַאֲוָתוֹ יִשָּׁפֵל וּשְׁפַל רוּחַ יִנָּשֵׂא׃ ");
INSERT INTO hebsg_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","וַיֹּאמֶר גַּם אֶל־הָאִישׁ אֲשֶׁר קְרָאוֹ לְבֵיתוֹ כִּי־תַעֲשֶׂה מִשְׁתֶּה בַּצָּהֳרַיִם אוֹ בָעֶרֶב לֹא תִקְרָא לְאֹהֲבֶיךָ לְאַחֶיךָ וְלִקְרוֹבֶיךָ אוֹ לִשְׁכֵנֶיךָ הָעֲשִׁירִים כִּי גַם־הֵם יִקְרָאוּךָ לְמִשְׁתֵּיהֶם וְהָיָה־לְךָ תַּשְׁלוּם גְּמוּל׃ ");
INSERT INTO hebsg_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","אֲבָל כִּי־תַעֲשֶׂה מִשְׁתֶּה קְרָא לַעֲנִיִּים וְנִדְכָּאִים לַפִּסְחִים וְלַעִוְרִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","אָז אַשְׁרֶיךָ כִּי אֵין־בְּיָדָם לְשַׁלֶּם־לָךְ וְשֻׁלֹּם יְשֻׁלַּם לְךָ בְּיוֹם תְּקוּמַת הַצַּדִּיקִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","וְאֶחָד מִן־הַיּשְׁבִים עִמּוֹ בִמְסִבָּה כְּשָׁמְעוֹ אֶת־אֵלֶּה עָנָה וְאָמַר אַשְׁרֵי הָאֹכֵל לֶחֶם בְּמַלְכוּת הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","וְהוּא אָמַר אֵלָיו אִישׁ אֶחָד עָשָׂה מִשְׁתֶּה גָדוֹל לִקְרֻאִים רַבִּים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","וַיִּשְׁלַח אֶת־עַבְדּוֹ לִפְנֵי הַמִּשְׁתֶּה אֶל־הַקְּרֻאִים לֵאמֹר בֹּאוּ נָא כִּי כָּל־דָּבָר מוּכָן׃ ");
INSERT INTO hebsg_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","וַיָּחֵלּוּ כֻּלָּם פֶּה אֶחָד לְהִשְׁתַּמֵּט הָרִאשׁוֹן אָמַר שָׂדֶה קָנִיתִי לִי וְלִי נָחוּץ לָלֶכֶת וְלִרְאוֹתוֹ אֱמָר־נָא לַאדֹנֶיךָ כִּי יִסְלַח לִי לַדָּבָר הַזֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","וְהַשֵּׁנִי אָמַר חֲמֵשֶׁת צִמְדֵי־בָקָר קָנִיתִי לִי וַאֲנִי הֹלֵךְ לְבַקְּרָם אֱמָר־נָא לַאדֹנֶיךָ כִּי יִסְלַח לִי לַדָּבָר הַזֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","וְהַשְּׁלִישִׁי אָמַר אִשָּׁה לָקַחְתִּי לִי וְלֹא אוּכַל לָבֹא׃ ");
INSERT INTO hebsg_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","וַיָּשָׁב הָעֶבֶד וַיַּגֵּד לַאדֹנָיו אֶת־הַדְּבָרִים הָאֵלֶּה וַיִּחַר אַפּוֹ וַיֹּאמֶר אֶל־הָעֶבֶד מַהֵר צֵא אֶל־רְחֹבוֹת הָעִיר וְאֶל־חוּצוֹתֶיהָ וְהָבֵא לִי הֵנָּה אֶת־הָעֲנִיִּים וְאֶת־הַנִּדְכָּאִים וְאֶת־הַעִוְרִים וְאֶת־הַפִּסְחִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","וַיֹּאמֶר הָעֶבֶד כֵּן נִהְיָה אֲדֹנִי כַּאֲשֶׁר צִוִּיתָ אַךְ־עוֹד מָקוֹם רֵק בַּבָּיִת׃ ");
INSERT INTO hebsg_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","וַיֹּמֶר הָאָדוֹן אֶל־הָעֶבֶד צֵא אֶל־הַדְּרָכִים וְאֶל־הַגְּדֵרוֹת וְהַחֲזֶק־בָּם לָבֹא לְמַעַן יִמָּלֵא בֵיתִי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","כִּי אֲנִי אֹמֵר לָכֶם מִן־הָאֲנָשִׁים הַקְּרֻאִים הָהֵם לֹא יִטְעַם אִישׁ אֶת־הַמִּשְׁתֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","וַיֵּלֶךְ אִתּוֹ הֲמוֹן עַם־רָב וַיִּפֶן וַיֹּאמֶר אֲלֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","כִּי־יָבֹא אֵלַי אִישׁ וְלֹא יִשְׂנָא אֶת־אָבִיו וְאֶת־אִמּוֹ וְאֶת־אִשְׁתּוֹ וְאֶת־בָּנָיו וְאֶת־אֶחָיו וְאֶת־אַחְיֹתָיו וְאַף גַּם־אֶת־נַפְשׁוֹ לֹא יוּכַל לִהְיוֹת תַּלְמִידִי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","וּמִי אֲשֶׁר לֹא־יִקַּח אֶת־צְלָבוֹ וְיֵלֵךְ אַחֲרָי לֹא יוּכַל לִהְיוֹת תַּלְמִידִי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","כִּי מִי־מִכֶּם הֶחָפֵץ לִבְנוֹת מִגְדָּל וְלֹא יֵשֵׁב לְחַשֵּׁב רִאשֹׁנָה אֶת־הוֹצָאוֹתָיו אִם יָדָיו רַב לוֹ לְכַלֹּתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","פֶּן־בְּיָסְדוֹ אֶת־הַיְסוֹד תִּקְצַר יָדוֹ לְהַשְׁלִימוֹ וְכָל־הָרֹאִים יִלְעֲגוּ־לוֹ לֵאמֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","זֶה הוּא הָאִישׁ אֲשֶׁר הֵחֵל לִבְנוֹת וּלְכַלּוֹת אֵין־לְאֵל יָדוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","אוֹ מִי־הוּא הַמֶּלֶךְ הַיֹּצֵא לְהִתְרָאוֹת פָּנִים בְּמִלְחַמְתּוֹ עִם־מֶלֶךְ אַחֵר וְלֹא־יֵשֵׁב לְהִתְיָעֵץ רִאשֹׁנָה אִם־יוּכַל לַעֲרֹךְ בַּעֲשֶׂרֶת אֲלָפִים לִקְרַאת הַבָּא עָלָיו בְּעֶשְׂרִים אָלֶף׃ ");
INSERT INTO hebsg_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","וְאִם־לֹא אָז יִשְׁלַח מַלְאָכִים עוֹדוֹ מֵרָחוֹק לְבַקֶּשׁ־לוֹ שָׁלוֹם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","וְכֵן כָּל־אִישׁ מִכֶּם אִם לֹא־יִבָּדֵל מִכֹּל אֲשֶׁר לוֹ לֹא־יוּכַל לִהְיוֹת תַּלְמִידִי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","הַמֶּלַח טוֹב הוּא אַךְ אִם גַּם־הַמֶּלַח יָפוּג טַעְמוֹ מִי יְתַקֵּן אֹתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","תָּפֵל לֹא־יִצְלַח לֹא לַאֲדָמָה וְלֹא לְדֹמֶן כִּי אִם־חוּצָה יַשְׁלִיכוּ אֹתוֹ מִי אֲשֶׁר אָזְנַיִם לוֹ לִשְׁמֹעַ יִשְׁמָע׃ ");
INSERT INTO hebsg_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","וַיְהִי כַּאֲשֶׁר בָּאוּ לְפָנָיו כָּל־הַמּוֹכְסִים וְהַחַטָּאִים לִשְׁמֹעַ אֹתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","וַיִּלֹּנוּ הַפְּרוּשִׁים וְהַסּוֹפְרִים לֵאמֹר הָאִישׁ הַלָּזֶה פְּנֵי חַטָּאִים הוּא נֹשֵׂא וְאֹכֵל עִמָּהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","וַיִּשָּׂא אֲלֵיהֶם אֶת־הַמָּשָׁל הַזֶּה לֵאמֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","מִי אִישׁ מִכֶּם אֲשֶׁר־לוֹ מֵאָה צֹאן וְאָבְדָה לּוֹ כִּבְשָׂה אַחַת מֵהֶן וְהוּא לֹא יַעֲזֹב אֶת־הַתִּשְׁעִים וָתֵשַׁע בַּמִּדְבָּר לָלֶכֶת וּלְבַקֵּשׁ עַד כִּי־יִמְצָא אֶת־הָאֹבָדֶת׃ ");
INSERT INTO hebsg_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","וְהָיָה כִּי יִמְצָאֶנָּה יָשִׂישׂ עָלֶיהָ יִשָּׂאֶנָּה בַכָּתֵף׃ ");
INSERT INTO hebsg_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","וְאֶל־בֵּיתוֹ יָבֹא וְיִקְרָא לְאֹהֲבָיו וְלִשְׁכֵנָיו לֵאמֹר שִׂישׂוּ אִתִּי כִּי מָצָאתִי אֶת־אֲבֵדָתִי אֶת־הַכִּבְשָׂה הַזֹּאת׃ ");
INSERT INTO hebsg_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","וַאֲנִי אֹמֵר לָכֶם כָּכָה תִּרֶב הַשִּׂמְחָה בַּשָּׁמַיִם עַל־חֹטֶא אֶחָד הַשָּׁב מֵחֲטָאָיו מֵעַל־תִּשְׁעִים וְתִשְׁעָה אַנְשֵׁי צֶדֶק אֲשֶׁר אֵין לָהֶם דָּבָר לְהִנָּחֵם עָלָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","אוֹ מִי הָאִשָּׁה אֲשֶׁר־לָהּ עֲשָׂרָה כֶסֶף וְאֶחָד מֵהֶם נָפַל וְנִסְתָּר מֵעֵינֶיהָ וְהִיא לֹא תַדְלִיק נֵר וּתְפַנֶּה אֶת־הַבַּיִת וּתְחַפֵּשׂ בְּחֵפֶשׂ מְחֻפָּשׂ עַד כִּי־תִמְצָאֶנּוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","וְהָיָה כִּי־תִמְצָא אֹתוֹ תִּקְרָא לְרֵעוֹתֶיהָ וְלִשְׁכֵנוֹתֶיהָ לֵאמֹר שְׂמַחְנָה בְּשִׂמְחָתִי כִּי מָצָאתִי אֶת־אֲבֵדָתִי אֶת הַכָּסֶף׃ ");
INSERT INTO hebsg_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","וַאֲנִי אֹמֵר לָכֶם כָּכָה תִּהְיֶה שִׂמְחָה לִפְנֵי מַלְאֲכֵי אֱלֹהִים עַל־חֹטֵא אֶחָד הַשָּׁב מֵחֲטָאָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","וַיֹּסֶף וַיֹּאמַר אִישׁ אֶחָד הָיוּ לוֹ שְׁנֵי בָנִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","וְהַקָּטֹן מֵהֶם אָמַר אֶל־אָבִיו תְּנָה־לִּי אָבִי חֵלֶק הַנַחֲלָה אֲשֶׁר יִפֹּל לְחֶבְלִי וַיְחַלֵּק לָהֶם אֶת־נְכָסָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","וְאַחֲרֵי יָמִים אֲחָדִים אָסַף הַבֵּן הַקָּטֹן אֶת־כָּל־אֲשֶׁר לוֹ וַיִּסַּע אֶל־אֶרֶץ רְחוֹקָה וַיְהִי שָׁם לְזוֹלֵל עַד אֲשֶׁר פִּזַּר כָּל־כַּסְפּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","וְאַחֲרֵי אֲשֶׁר בִּלַּע כָּל־אֲשֶׁר הָיָה לוֹ בָּא רָעָב גָּדוֹל בָּאָרֶץ הַהִיא וְהוּא הֵחֵל לִהְיוֹת חֲסַר־לָחֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","וַיֵּלֶךְ וַיִּסְתַּפַּח בְּאֶחָד מִיּשְׁבֵי הָאָרֶץ הַהִיא וַיִּשְׁלָחֵהוּ הַשָּׂדֶה לִרְעוֹת חֲזִירִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","וַיִּתְאַו לְמַלֵּא אֶת־כְּרֵשׂוֹ חֲרוּבִין מֵאֲשֶׁר יֹאכְלוּן הַחֲזִירִים וּפֹרֵשׂ אֵין לוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","וַיָּשֶׁב אֶל־לִבּוֹ וַיֹּאמַר מָה־רַבּוּ הַשְּׂכִירִים תַּחַת יַד אָבִי אֲשֶׁר לָהֶם לֶחֶם דַּי וְהוֹתֵר וְאָנֹכִי מֵת פֹּה בָּרָעָב׃ ");
INSERT INTO hebsg_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","אָקוּם אֵלֵךְ אֶל־אָבִי וְאֹמַר אֵלָיו אָבִי חָטָאתִי גַּם־לַשָּׁמַיִם גַּם־לְפָנֶיךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","קַלֹּתִי מֵהִקָּרֵא בִנְךָ עוֹד שִׂימֵנִי־נָא כְּאַחַד הַשְׂכִירִים בְּבֵיתֶךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","וַיָּקָם וַיָּבֹא אֶל־אָבִיו וְעוֹדֶנּוּ מֵרָחוֹק רָאָה אֹתוֹ אָבִיו וַיִּכָּמְרוּ רַחֲמָיו אֵלָיו וַיָּרָץ וַיִּפֹּל עַל־צַוָּארָיו וְיִּשַּׁק לוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","וְהַבֵּן עָנָה וְאָמַר אָבִי חָטָאתִי גַּם־לַשָּׁמַיִם גַּם־לְפָנֶיךָ קַלֹּתִי מֵהִקָּרֵא בִנְךָ עוֹד׃ ");
INSERT INTO hebsg_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","וַיֹּאמֶר הָאָב אֶל־עֲבָדָיו מַהֲרוּ הָבִיאוּ וְהַלְבִּישֻׁהוּ אֶת־הַמְּעִיל הַטּוֹב וּתְנוּ טַבַּעַת עַל־יָדוֹ וּנְעָלִים לְרַגְלָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","וְאֶת־עֵגֶל הַמַּרְבֵּק קְחוּ וּטְבָחוּ וְנֹאכַל וְנַעֲלֹזָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","כִּי זֶה־בְּנִי מֵת הָיָה וְהִנֵּה הוּא חָי אֹבֵד וְהוּא נִמְצָא אִתָּנוּ וַיָּקוּמוּ כֻלָּם לְהִתְעַלֵּס׃ ");
INSERT INTO hebsg_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","וּבְנוֹ הַגָּדוֹל בָּא מִמְּלַאכְתּוֹ בַשָׂדֶה וַיִּקְרַב אֶל־הַבַּיִת וַיִּשְׁמַע קוֹל שִׁיר וּמָחוֹל׃ ");
INSERT INTO hebsg_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","וַיִּקְרָא אֶל־אַחַד הַנְּעָרִים וַיִּשְׁאַל מַה־זֹּאת׃ ");
INSERT INTO hebsg_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","וַיֹּאמֶר אֵלָיו הֲלֹא אָחִיךָ בָּא וַיִּזְבַּח לוֹ אָבִיךָ אֶת־עֵגֶל הַמַּרְבֵּק אַחֲרֵי אֲשֶׁר שָׁב אֵלָיו בְּשָׁלוֹם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","וַיִּחַר אַפּוֹ וְלֹא אָבָה לָבֹא הַבָּיְתָה וַיֵּצֵא אָבִיו וַיְדַבֵּר עַל־לִבּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","וַיַּעַן וַיֹּאמֶר אֶל־אָבִיו הִנֵּה זֶה שָׁנִים רַבּוֹת עֲבַדְתִּיךָ וּמֵעוֹדִי לֹא עָבַרְתִּי מִמִּצְוֹתֶיךָ וְעוֹד לֹא־נָתַתָּ לִי גְדִי מִן־הַצֹּאן לֶאֱכֹל וּלְהִתְעַלֵּס עִם־רֵעָי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","וּכְבֹא בִנְךָ זֶה רֹעֶה זֹנוֹת אֲשֶׁר הִשְׁחִית אֶת־נַחֲלָתֶךָ זָבַחְתָּ לּוֹ אֶת־עֵגֶל הַמַּרְבֵּק׃ ");
INSERT INTO hebsg_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","וַיֹּאמֶר אֵלָיו בְּנִי הֲלֹא תָמִיד אַתָּה עִמָּדִי וְכֹל אֲשֶׁר־לִי לְךָ הוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","אֲבָל נָאוָה לָנוּ לִשְׂמֹחַ וּלְהִתְעַלֵּס כִּי זֶה־אָחִיךָ מֵת הָיָה וְהִנֵּה הוּא חָי אֹבֵד וְהוּא נִמְצָא אִתָּנוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","וַיֹּאמֶר גַּם אֶל־תַּלְמִידָיו אִישׁ עָשִׁיר הָיָה וְלוֹ סֹכֵן עַל־בֵּיתוֹ אֲשֶׁר הֵבִיאוּ אֵלָיו דִּבָּתוֹ רָעָה לֵאמֹר כִּי הוֹנוֹ הוּא מְפַזֵּר׃ ");
INSERT INTO hebsg_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","וַיִּקְרָא אֵלָיו וַיֹּאמַר מַה־זֹּאת אָנֹכִי שֹׁמֵעַ עָלֶיךָ הָבָה חֶשְׁבּוֹן פְּקֻדָּתֶךָ כִּי לֹא תוּכַל עוֹד לְהִשָּׁאֵר סֹכֵן עַל־הַבָּיִת׃ ");
INSERT INTO hebsg_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","וַיֹּאמֶר הַסֹּכֵן אֶל־לִבּוֹ מָה אֶעֱשֶׂה כִּי־לֹקֵחַ אֲדֹנִי אֶת־פְּקֻדָּתִי מִמֶּנִּי לַעֲבֹד אֶת־הָאֲדָמָה לֹא־תוּכַל וּלְבַקֵּשׁ לֶחֶם נְדָבוֹת חֶרְפָּה הִיא לִי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","יָדַעִתִּי אֵת אֲשֶׁר אֶעֱשֶׂה עַד גַּם־אַחֲרֵי אֲשֶׁר אֶחְדַּל מִהְיוֹת סֹכֵן יַאַסְפוּנִי אֶל־בָּתֵּיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","וַיִּקְרָא אֶל־אִישׁ אִישׁ אֲשֶׁר נָשָׁה בָּם אֲדֹנָיו וַיֹּאמֶר אֶל־הָרִאשׁוֹן מָה חוֹב עָלֶיךָ לְשַׁלֵּם לַאדֹנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","וַיֹּאמֶר מֵאָה בַּת שָׁמֶן וַיֹּאמֶר אֵלָיו מַהֵר קַח אֶת־שְׁטַר הַחוֹב שֵׁב וּכְתֹב חֲמִישִׁים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","וְאֶל־הַשֵּׁנִי אָמַר וְאַתָּה כַּמֶּה עָלֶיךָ לְשַׁלֵּם וַיֹּאמֶר מֵאָה כֹּר חִטִּים וַיֹּאמֶר קַח אֶת־שְׁטַר הַחוֹב וּכְתֹב שְׁמֹנִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","וַיְשַׁבַּח הָאָדוֹן אֶת־בֶּן־הָעַוְלָה אֶת־הַסֹּכֵן אֲשֶׁר שִׂכֵּל אֶת־מַעֲשֵׂהוּ כִּי בְנֵי הָעוֹלָם הַזֶּה מַשְׂכִּילִים הֵם מֵעַל בְּנֵי הָאוֹר בְּדֹרֹתָם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","וְאַף־אֲנִי אֹמֵר לָכֶם קְנוּ לָכֶם אֹהֲבִים בְּכֶסֶף מְקוֹר הָעַוְלָה וְכַאֲשֶׁר יָבֹא עַד־קִצּוֹ אָז יַאַסְפוּ אֶתְכֶם אֶל־מִשְׁכְּנוֹת עוֹלָם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","מִי אֲשֶׁר נֶאֱמָן בְּדָבָר קָטֹן נֶאֱמָן יִהְיֶה גַּם־בְּדָבָר גָּדוֹל וּמִי אֲשֶׁר יְעַוֵּל בְּדָבָר קָטֹן יְעַוֵּל גַּם־בְּדָבָר גָּדוֹל׃ ");
INSERT INTO hebsg_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","וְעַל־כֵּן אִם לֹא־נֶאֱמָנִים הֱיִיתֶם בְּהוֹן מָשְׁחָת מִי יַפְקִיד אֶתְכֶם עַל־הוֹן אֱמֶת׃ ");
INSERT INTO hebsg_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","וְאִם נֶאֱמָנִים לֹא הֱיִיתֶם בְּקִנְיָן עֹבֵר לַאֲחֵרִים קִנְיָן עֹמֵד לְנַפְשְׁכֶם מִי יִתֵּן לָכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","עֶבֶד לֹא יוּכַל לַעֲבֹד אֲדֹנִים שְׁנָיִם כִּי אִם־יִשְׂנָא אֶת־הָאֶחָד וְאֶת־הָאַחֵר יֶאֱהַב אוֹ יִדְבַּק בָּאֶחָד וְהַשֵּׁנִי נִמְאָס בְּעֵינָיו לֹא תוּכְלוּ לַעֲבֹד אֶת־הָאֱלֹהִים וְאֶת־הַמָּמוֹן׃ ");
INSERT INTO hebsg_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","וַיִּשְׁמְעוּ הַפְּרוּשִׁים אֹהֲבֵי כֶסֶף אֶת־כָּל־אֵלֶּה וַיִּשְׂחֲקוּ עָלָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","וַיֹּאמֶר אֲלֵיהֶם אַתֶּם הֵם אֲשֶׁר תַּצְדִּיקוּ נַפְשְׁכֶם לְעֵינֵי אֲנָשִׁים וֵאלֹהִים יֵדַע אֶת־לִבְּכֶם כִּי הַמִּתְנַשֵּׂא לְעֵינֵי אֲנָשִׁים תּוֹעֵבָה הוּא בְּעֵינֵי אֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","הַתּוֹרָה וְהַנְּבִיאִים עַד־יוֹחָנָן תְּקוּפָתָם וּמֵעֵת הַהִיא הֵחֵלָּה בְּשׂרַת מַלְכוּת הָאֱלֹהִים וְכָל־אִישׁ רָץ אַחֲרֶיהָ לִתְפָּשׂ־בָּה בְּחָזְקָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","אַךְ נַקֵל יִהְיֶה לַשָּׁמַיִם אוֹ לָאָרֶץ לַחֲלֹף מֵאֲשֶׁר יִפֹּל קוֹץ אֶחָד מִן־הַתּוֹרָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","כָּל־אִישׁ אֲשֶׁר יְשַׁלַּח אֶת־אִשְׁתּוֹ וְיִקַּח לוֹ אַחֶרֶת נֹאֵף הוּא וְהַלֹּקֵחַ לוֹ אִשָּׁה גְּרוּשָׁה מֵאִישָׁהּ נֹאֵף הוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","אִישׁ עָשִׁיר הָיָה אֲשֶׁר לָבַשׁ שֵׁשׁ וְאַרְגָּמָן וַיַּעֲלֹז בְּתַעֲנוּגִים יוֹם יוֹם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","וְאִישׁ אֶבְיוֹן אֶלְעָזָר שְׁמוֹ שֹׁכֵב לְנֹכַח פֶּתַח בֵּיתוֹ מָלֵא שְׁחִין וַאֲבַעְבֻּעֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","וְהוּא מִתְאַוֶּה לְמַלֵּא רַעֲבוֹן נַפְשׁוֹ מֵהַפְּתֹתִים הַנֹּפְלִים מֵעַל שֻׁלְחַן הֶעָשִׁיר וּכְלָבִים בָּאִים וּמְלַקְּקִים זוֹב נְגָעָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","וַיְהִי כַּאֲשֶׁר מֵת הָאֶבְיוֹן וַיִּשָּׂאֻהוּ הַמַּלְאָכִים אֶל־חֵיק אַבְרָהָם וְגַם־הֶעָשִׁיר מֵת וַיִּקָּבֵר׃ ");
INSERT INTO hebsg_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","וַיִּשָּׂא אֶת־עֵינָיו מֵחֶבְלֵי שְׁאוֹל אֲשֶׁר סַבֻּהוּ וַיַּרְא אֶת־אַבְרָהָם מֵרָחוֹק וְאֶת־אֶלְעָזָר בְּחֵיקוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","וַיִּצְעַק וַיֹּאמֶר אָבִי אַבְרָהָם חָנֵּנִי־נָא וּשְׁלַח אֶת־אֶלְעָזָר לִטְבֹּל אֶת־קְצֵה אֶצְבָּעוֹ בַּמַּיִם לְהָקֵר אֶת־לְשׁוֹנִי כִּי בֹּעֵר אָנֹכִי עַל־הַמּוֹקֵד הַזֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","וַיֹּאמֶר אַבְרָהָם זְכָר־בְּנִי כִּי נִתַּן לְךָ כָּל־טוּבְךָ בְּחַיֶּיךָ וְאֶלְעָזָר בָּאַתְהוּ כָּל־רָעָה וְעַתָּה הוּא מֹצֵא תַּנְחוּמִים וְאַתָּה בְּמָצוֹק׃ ");
INSERT INTO hebsg_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","וּבִלְּבַד כָּל־זֹאת גֵּיא עָמֹק מַבְדִּיל בֵּינֵינוּ וּבֵינֵיכֶם וְאֵין־לְאֵל יַד אִישׁ מִמֶּנּוּ לַעֲבֹר אֲלֵיכֶם וְאֵין אִישׁ מִכֶּם עֹבֵר אֵלֵינוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","וַיֹּאמֶר אִם־כֵּן אָבִי הִנְנִי מְבַקֵּשׁ מִלְפָנֶיךָ לִשְּׁלֹחַ אֹתוֹ אֶל־בֵּית אָבִי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","כִּי יֶשׁ־לִי אַחִים חֲמִישָּׁה וְהוּא יָעִיד בָּם לְבִלְתִּי יָבֹאוּ גַם־הֵם אֶל־הַמָּקוֹם הָרָע הַזֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","וַיֹּאמֶר אַבְרָהָם הֲלֹא יֵשׁ לָהֶם מֹשֶׁה וְהַנְּבִיאִים יִשְׁמְעוּ אֵיפֹא אֲלֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","וַיֹּאמֶר לֹא־כֵן אָבִי אַבְרָהָם אַךְ אִם־אֶחָד מִן־הַמֵּתִים יָבֹא לְהָעִיד בָּם אָז יָשׁוּבוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","וַיֹּאמֶר אֵלָיו אִם לְמֹשֶׁה וְהַנְּבִיאִים אֵינָם שֹׁמְעִים לֹא יַאֲמִינוּ אַף אִם־יָקוּם אֶחָד מִן־הַמֵּתִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","וַיֹּאמֶר אֶל־תַּלְמִידָיו אֵין שַׁלִּיט לִכְלוֹא אֶת־הַמּוֹקְשִׁים אֲשֶׁר לֹא יָבאוּ אַךְ אוֹי לָאִישׁ הַהוּא אֲשֶׁר עַל־יָדוֹ יָבֹאוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","טוֹב לוֹ כִּי־יִתָּלֶה פֶּלַח־רֶכֶב עַל־צַוָּארוֹ וְהֻשְׁלַךְ בַּיָּם מִתֵּת מוֹקֵשׁ לְאַחַד הַקְּטַנִּים הָאֵלֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","וְאַתֶּם הִשָּׁמְרוּ לְנַפְשֹׁתֵיכֶם אִם־יֶחֱטָא לְךָ אָחִיךָ הוֹכֵחַ תּוֹכִיחַ אֹתוֹ וְאִם־יִנָּחֵם סְלַח־לוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","וְאִם־שֶׁבַע פְּעָמִים בַּיּוֹם יֶחֱטָא לְךָ לְךָ וְשֶׁבַע פְּעָמִים יָשׁוּב אֵלֶיךָ וְיֹּמַר נִחָמְתִּי וְסָלַחְתָּ לּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","וַיֹּאמְרוּ הַשְּׁלִיחִים אֶל־הָאָדוֹן הוֹסֵף לָנוּ אֱמוּנָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","וַיֹּאמֶר הָאָדוֹן אִם־יֵשׁ בָּכֶם אֱמוּנָה כְּגַרְגַּר חַרְדָּל וַאֲמַרְתֶּם אֶל־הַשִּׁקְמָה הַזֹּאת הֵעָקְרִי מִשָּׁרְשֵׁךְ וְהִנָּטְעִי בַיָּם וְהִיא תִשְׁמַע בְּקֹלְכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","וּמִי מִכֶּם אֲשֶׁר לוֹ עֶבֶד חֹרֵשׁ אוֹ רֹעֶה בַשָּׂדֶה וּבְשׁוּבוֹ מִשָּׁם יֹאמַר אֵלָיו מַהֵר בֹּא וְשֵׁב אֶל־הַשֻּׁלְחָן׃ ");
INSERT INTO hebsg_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","וְלֹא יֹאמַר אֵלָיו הָכֶן־לִי לֶחֶם הָעֶרֶב וַחֲגֹר מָתְנֶיךָ לְשָׁרְתֵנִי עַד כִּי־אֹכַל וְאֶשְׁתֶּה וְאַחַר תֹּאכַל וְתִשְׁתֶּה גַּם־אָתָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","אוֹ הֲיִתֵּן תּוֹדָה לָעֶבֶד הַזֶּה בַּעֲבוּר כִּי עָשָׂה אֵת אֲשֶׁר צִוָּהוּ נִדְמֶה לִי שֶׁלֹּא׃ ");
INSERT INTO hebsg_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","וְכֵן גַּם־אַתֶּם כַּאֲשֶׁר עֲשִׂיתֶם כָּל־אֲשֶׁר צֻוֵּיתֶם אִמְרוּ עֲבָדִים מִבְּלִי יִתְרוֹן אֲנָחְנוּ כִּי רָק אֶת־אֲשֶׁר עָלֵינוּ לַעֲשׂוֹת עָשִׂינוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","וַיְהִי בְּנָסְעוֹ יְרוּשָׁלָיְמָה וַיַּעֲבֹר דֶּרֶךְ שֹׁמְרוֹן וְהַגָּלִיל׃ ");
INSERT INTO hebsg_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","וַיָּבֹא אֶל־כְּפָר אֶחָד וְשָׁם פָּגְעוּ בוֹ עֲשָׂרָה אֲנָשִׁים מְצֹרָעִים וַיַּעַמְדוּ מֵרָחוֹק׃ ");
INSERT INTO hebsg_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","וַיִּשְׂאוּ אֶת־קוֹלָם וַיִּקְרְאוּ יֵשׁוּעַ רַבֵּנוּ חָנֵּנוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","וַיַּרְא וַיֹּאמֶר אֲלֵיהֶם לְכוּ וְהֵרָאוּ לְעֵינֵי הַכֹּהֲנִים וַיְהִי בְלֶכְתָּם וַיִּטְהָרוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","וְאֶחָד מֵהֶם בִּרְאֹתוֹ כִּי נִרְפָּא מִצָּרַעְתּוֹ וַיָּשָׁב וַיְשַׁבַּח אֶת־הָאֱלֹהִים בְּקוֹל עָז׃ ");
INSERT INTO hebsg_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","וַיִּפֹּל לְרַגְלָיו עַל־אַפָּיו אַרְצָה וַיִּתֶּן־לוֹ תּוֹדָה וְהוּא אִישׁ שֹׁמְרוֹנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","וַיַּעַן יֵשׁוּעַ וַיֹּאמַר הֲלֹא עֲשָׂרָה נִרְפָּאוּ וְאַיֵּה הַתִּשְׁעָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","הֲכִי לֹא־נִמְצָא אֶחָד מֵהֶם שָׁב לָתֵת כָּבוֹד לֵאלֹהִים בִּלְתִּי הַנָּכְרִי הַזֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","וַיֹּאמֶר אֵלָיו קוּם וָלֵךְ אֱמוּנָתְךָ הוֹשִׁיעָה לָּךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","וַיִּשְׁאָלֻהוּ הַפְּרוּשִׁים לֵאמֹר מָתַי תָּבֹא מַלְכוּת הָאֱלֹהִים וַיַּעַן אֹתָם וַיֹּאמַר מַלְכוּת הָאֱלֹהִים לֹא תָבֹא לְעֵינֵי הַמַּבִּיט׃ ");
INSERT INTO hebsg_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","וְלֹא יֹאמְרוּ הִנֵּה־הִיא פֹה אוֹ הִנֵּה־הִיא שָׁם כִּי מַלְכוּת הָאֱלֹהִים בְּקִרְבְּכֶם הִנֶּהָ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","וַיֹּמֶר אֶל־הַתַּלְמִידִים הִנֵּה יָמִים בָּאִים וּתְבַקְשׁוּ לִרְאוֹת יוֹם אֶחָד מִימֵי בֶן־הָאָדָם וְלֹא תִרְאוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","וְכִי־יֹאמְרוּ אֲלֵיכֶם הִנֵּה־הוּא שָׁם אוֹ הִנֵּה־הוּא פֹה אַל־תֵּצְאוּ וְאַל־תֵלְכוּ אַחֲרֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","כִּי כִּבְרֹק בָּרָק מִקְצֵה הֵשָּׁמַיִם מִזֶּה וְהֹלֵךְ וָאוֹר עַד־קְצֵה הַשָּׁמַיִם מִזֶּה כֵּן יֵרָאֶה בֶּן־הָאָדָם בְּיוֹמוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","אַךְ בָּרִאשֹׁנָה עָלָיו לִהְיוֹת מְעֻנֶּה עַד־מְאֹד וְנִמְאָס עַל־פִּי בְנֵי הַדּוֹר הַזֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","וְכַאֲשֶׁר הָיָה בִּימֵי נֹחַ כֵּן יִהְיֶה גַּם־בִּימֵי בֶן־הָאָדָם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","כִּי אָכְלוּ וְשָׁתוּ בָּעֳלוּ נָשִׁים וְנָשִׁים נִבְעָלוּ עַד־הַיּוֹם אֲשֶׁר־בָּא נֹחַ אֶל־הַתֵּבָה וַיָּבֹא הַמַּבּוּל וַיִּמַח אֶת־כֻּלָּם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","וְכַאֲשֶׁר הָיָה גַּם־בִּימֵי לוֹט כִּי אָכְלוּ וְשָׁתוּ קָנוּ וּמָכְרוּ נָטְעוּ וּבָנוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","וַיְהִי בַּיּוֹם אֲשֶׁר־יָצָא לוֹט מִסְּדֹם וַיַּמְטֵר אֲדֹנָי אֵשׁ וְגָפְרִית מִן־הַשָּׁמַיִם וַיְשַׁחֵת אֶת כֻּלָּם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","כֵּן יִהְיֶה בַּיּוֹם אֲשֶׁר בֶּן־הָאָדָם יֵרָאֶה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","בַּיּוֹם הַהוּא מִי אֲשֶׁר יִהְיֶה עַל־הַגָּג וְכֵלָיו בַּבָּיִת לֹא יֵרֵד לָשֵׂאת אֹתָם וְגַם מִי־אֲשֶׁר בַּשָּׁדֶה לֹא יִפְנֶה לְהַבִּיט אַחֲרָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","זִכְרוּ אֶת־אֵשֶׁת לוֹט׃ ");
INSERT INTO hebsg_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","מִי הֶחָפֵץ לְהַצִּיל אֶת־נַפְשׁוֹ תִּכָּרֵת־לוֹ וּמִי אֲשֶׁר יַכְרִית אֶת־נַפְשׁוֹ לְמַעֲנִי יְחַיֶּה אֹתָהּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","וַאֲנִי אֹמֵר לָכֶם בַּלַּיְלָה הַהוּא יִשְׁכְּבוּ שְׁנַיִם בְּמִטָּה אֶחַת אֶחָד יֵאָסֵף וְאֶחָד יֵעָזֵב׃ ");
INSERT INTO hebsg_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","שְׁתַּיִם טֹחֲנוֹת בָּרֵחָיִם אַחַת תֵּאָסֵף וְאַחַת תֵּעָזֵב׃ ");
INSERT INTO hebsg_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","שְׁנַיִם יִהְיוּ בַּשָּׂדֶה אֶחָד יֵאָסֵף וְאֶחָד יֵעָזֵב׃ ");
INSERT INTO hebsg_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","וַיַּעֲנוּ וַיֹּאמְרוּ אֵלָיו אֲדֹנֵינוּ וְאַיֵּה תִקְרֶינָה כָאֵלֶּה וַיֹּאמֶר בַּאֲשֶׁר פְּגָרִים שָׁם יִקָּבְצוּ הַנְּשָׁרִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","וַיּוֹסֶף שְׂאֵת מְשָׁלוֹ אֲלֵיהֶם לְחַלּוֹת פְּנֵי אֵל תָּמִיד וְלֹא יִתְּנוּ דֳמִי לוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","וַיֹּאמַר שֹׁפֵט אֶחָד הָיָה בָעִיר אֲשֶׁר לֹא יָרֵא אֶת־הָאֱלֹהִים וְאֶל־פְּנֵי אָדָם לֹא פָנָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","וְאַלְמָנָה הָיְתָה שָּׁם בָּעִיר וַתָּבֹא אֵלָיו לֵאמֹר שָׁפְטֵנִי־נָא מֵאִישׁ רִיבִי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","וְלֹא אָבָה לִשְׁמֹעַ בְּקוֹלָהּ יָמִים מִסְפָּר וְאַחֲרֵי־כֵן אָמַר בְּלִבּוֹ אַף כִּי אֵינֶנִּי יָרֵא אֶת־הָאֱלֹהִים וְאֶל־פְּנֵי אָדָם לֹא אֵפֶן׃ ");
INSERT INTO hebsg_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","הִנְנִי לָרִיב רִיב הָאַלְמָנָה הַזֹּאת כִּי־תַלְאֶה אֹתִי וְתָבֹא לְהֲצִיקֵנִי בִדְבָרֶיהָ יוֹם יוֹם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","וְעַתָּה שִׁמְעוּ־נָא נְאֻם הָאָדוֹן אֵת אֲשֶׁר אֹמֵר הַשֹּׁפֵט הַבְּלִיָּעַל׃ ");
INSERT INTO hebsg_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","וֵאלֹהִים הַאִם לֹא יָרִיב רִיב בְּחִירָיו הַקֹּרִאים אֵלָיו יוֹמָם וָלָיְלָה וְרַחֲמָיו אֲלֵיהֶם יִתְאַפָּקוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","הֵן אֲנִי אֹמֵר לָכֶם כִּי־יָחִישׁ לָרִיב רִיבָם אַךְ בֶּן־הָאָדָם בְּבֹאוֹ הֲיִמְצָא אֱמוּנָה עֲלֵי־אָרֶץ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","וַיְמַשֵּׁל גַּם אֶת־הַמָּשָׁל הַזֶּה אֶל־הַבֹּטְחִים בְּנַפְשָׁם כִּי צַדִּיקִים הֵם וַאֲחֵרִים בְּעֵינֵיהֶם כְּאֶפֶס נֶחֱשָׁבוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","שְׁנֵי אֲנָשִׁים עָלוּ אֶל־הַהֵיכָל לְהִתְפַּלֵּל אֶחָד פָּרוּשׁ וְאֶחָד מוֹכֵס׃ ");
INSERT INTO hebsg_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","וַיִּגַּשׁ הַפָּרוּשׁ וַיִּתְפַּלֵּל כַּדְּבָרִים הָאֵלֶּה אוֹדְךָ אֱלֹהַי כִּי אֵינֶנִּי כִּשְׁאָר בְּנֵי אָדָם בַּעֲלֵי חָמָס בְּנֵי עַוְלָה וּמְנַאֲפִים וְאַף לֹא כַמּוֹכֵס הַזֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","אָנֹכִי צָם יוֹמַיִם בַּשָּׁבוּעַ וּמְעַשֵּׂר אֲנִי אֶת־כָּל־תְּבוּאֹתָי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","וְהַמּוֹכֵס עָמַד מֵרָחוֹק וְלֹא הֵעִיז לָשֵׂאת אֶת־עֵינָיו לַמָּרוֹם וַיִּסְפֹּק עַל־לִבּוֹ וַיֹּאמַר רַחֶם־נָא אֱלֹהִים עַל־חֹטֵא כָּמֹנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","הֵן אֲנִי אֹמֵר לָכֶם כִּי־נִצְדָּק שָׁב הָאִישׁ הַזֶּה לְבֵיתוֹ מִן־הָאִישׁ הַהוּא כִּי הַמִּתְנַשֵּׂא בְגַאֲוָתוֹ יִשָּׁפֵל וּשְׁפַל רוּחַ יִנָּשֵׂא׃ ");
INSERT INTO hebsg_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","וַיָּבִיאוּ אֵלָיו גַּם אֶת־הַיְלָדִים לְבַעֲבוּר יָשִׂים אֶת־יָדָיו עֲלֵיהֶם וַיִּרְאוּ הַתַּלְמִידִים וַיִּגְעֲרוּ־בָם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","וְיֵשׁוּעַ קָרָא אֹתָם אֵלָיו וַיֹּאמַר הַנִּיחוּ לַיְלָדִים לָבֹא אֵלַי וְאַל־תִּכְלְאוּ אֹתָם כִּי מֵאֵלֶּה מַלְכוּת הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","אָמֵן אֲנִי אֹמֵר לָכֶם מִי אֲשֶׁר־לֹא יְקַבֵּל אֶת־מַלְכוּת הָאֱלֹהִים כַּיָּלֶד בֹּא לֹא־יָבֹא בָהּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","וַיִּשְׁאַל אֹתוֹ אַחַד הַשָּׂרִים לֵאמֹר רַבִּי הַטּוֹב מַה־לִי לַעֲשׂוֹת לָרֶשֶׁת חַיֵּי עוֹלָם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","וַיֹּאמֶר אֵלָיו יֵשׁוּעַ לָמָּה־זֶּה תִּקְרָא לִי טוֹב אֵין טוֹב כִּי אִם־אֶחָד הוּא הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","וְאַתָּה יָדַעְתָּ אֶת־הַמִּצְוֹת לֹא תִּנְאָף לֹא תִּרְצָח לֹא תִּגְנֹב לֹא־תַעֲנֶה עֵד שָׁקֶר כַּבֵּד אֶת־אָבִיךָ וְאֶת־אִמֶּךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","וַיֹּאמֶר אֶת־כָּל־אֵלֶּה שָׁמַרְתִּי מִנְּעוּרָי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","וַיִּשְׁמַע יֵשׁוּעַ וַיֹּאמַר עוֹד אַחַת אַתָּה חָסֵר לֵךְ מְכֹר אֶת־כֹּל אֲשֶׁר־לְךָ וְתֵן לַעֲנִיִּים וְהָיָה־לְךָ אוֹצָר בַּשָּׁמַיִם וּבֹא וְלֵךְ אַחֲרָי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","וַיְהִי כְּשָׁמְעוֹ אֶת־אֵלֶּה וַיִּתְעַצֵּב אֶל־לִבּוֹ כִּי עָשְׁרוֹ הָיָה רַב מְאֹד׃ ");
INSERT INTO hebsg_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","וַיַּרְא אֹתוֹ יֵשׁוּעַ וַיֹּאמַר מַה־קָּשֶׁה לְבַעֲלֵי עשֶׁר לָבֹא אֶל־מַלְכוּת הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","נָקֵל לְחֶבֵל לַעֲבֹר דֶּרֶךְ חֻר הַמַּחַט מִבֹּא עָשִׁיר אֶל־מַלְכוּת הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","וַיֹּאמְרוּ הַשֹּׁמְעִים וּמִי אֵיפוֹא יוּכַל לְהִוָּשֵׁעַ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","וַיֹּאמֶר אֲשֶׁר יִפָּלֵא מִבְּנֵי אָדָם לֹא יִפָּלֵא מֵאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","וַיֹּאמֶר פֶּטְרוֹס הִנֵּה אֲנַחְנוּ עָזַבְנוּ אֶת־בָּתֵּינוּ וַנֵּלֶךְ אַחֲרֶיךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","וַיֹּאמֶר אֲלֵיהֶם אָמֵן אֲנִי אֹמֵר לָכֶם כִּי אֵין־אִישׁ אֲשֶׁר עָזַב בַּיִת אוֹ אִשָּׁה אוֹ אַחִים אוֹ אָבוֹת אוֹ בָנִים לְמַעַן מַלְכוּת הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","אֲשֶׁר לֹא יַשִּׂיג גְּמוּלוֹ פְּעָמִים הַרְבֵּה לָעֵת הַזֹּאת וְלֶעָתִיד לָבֹא חַיֵּי עוֹלָם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","וַיִּקַּח אֵלָיו אֶת שְׁנֵים־הֶעָשָׂר וַיֹּאמֶר אֲלֵיהֶם הִנֵּה אֲנַחְנוּ עֹלִים יְרוּשָׁלָיְמָה וְכָל־הַדְּבָרִים הַכְּתוּבִים בִּידֵי הַנְּבִיאִים עַל בֶּן־הָאָדָם יָקוּמוּ עַד־תֻּמָּם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","כִּי יִסָּגֵר בִּידֵי הַגּוֹיִם וּבוֹ יְהָתֵלּוּ וְיִתְעַלְּלוּ וְיָרְקוּ בְּפָנָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","בַּשֹּׁטִים יְיַסְּרוּ אֹתוֹ אַחֲרֵי־כֵן יְמִיתֻהוּ וּבַיּוֹם הַשְּׁלִישִׁי יָקוּם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","וְהֵם לֹא הֵבִינוּ דָבָר מִכָּל־אֵלֶּה כִּי צָפוּן הָיָה הַדָּבָר מֵעֵינֵיהֶם וְלֹא יָדְעוּ אֵת אֲשֶׁר־דִבֶּר אֲלֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","וַיְהִי כַּאֲשֶׁר הִקְרִיב לָבֹא אֶל־יְרִיחוֹ וְהִנֵּה־אִישׁ עִוֵּר ישֵׁב עַל־הַדֶּרֶךְ וּמְבַקֵּשׁ נְדָבוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","וַיִּשְׁמַע קוֹל הֲמוֹן עֹבְרִים וַיִּשְׁאַל לֵאמֹר מַה־זֹּאת׃ ");
INSERT INTO hebsg_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","וַיַּגִּידוּ לוֹ כִּי־יֵשׁוּעַ הַנָּצְרִי עֹבֵר׃ ");
INSERT INTO hebsg_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","וַיִּצְעַק לֵאמֹר רַחֶם־נָא עָלַי יֵשׁוּע בֶּן־דָּוִד׃ ");
INSERT INTO hebsg_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","וַיִּגְעֲרוּ־בוֹ הַהֹלְכִים לְפָנָיו לְהַחְשׁוֹתוֹ וְהוּא קָרָא עוֹד בְּיֶתֶר אֹמֶץ בֶּן־דָּוִד רַחֶם־נָא עָלָי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","וַיַּעֲמֹד יֵשׁוּעַ וַיְצַו לַהֲבִיאוֹ אֵלָיו וְכַאֲשֶׁר הִקְרִיב לָבֹא וַיִּשְׁאָלֵהוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","מַה־תְּבַקֵּשׁ מִנִּי לַעֲשׂוֹת לָּךְ וַיֹּאמֶר אֲדֹנִי לְהָשִׁיב לִי אוֹר עֵינָי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","וַיֹּאמֶר אֵלָיו יֵשׁוּעַ אוֹר עֵינֶיךָ שָׁב אֵלֶיךָ אֱמוּנָתְךָ הוֹשִׁיעָה לָּךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","וּפִתְאֹם נִפְקְחוּ עֵינָיו וַיֵּלֶךְ אַחֲרָיו וְנָתוֹן כָּבוֹד לֵאלֹהִים וַיַּרְא כָּל־הָעָם וַיְבָרְכוּ אֶת־הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","וַיְהִי כַּאֲשֶׁר בָּא וְעָבַר דֶּרֶךְ יְרִיחוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","וַיָּבֹא אִישׁ וּשְׁמוֹ זַכָּי רֹאשׁ הַמּוֹכְסִים וְהוּא אִישׁ עָשִׁיר׃ ");
INSERT INTO hebsg_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","וַיְבַקֵּשׁ לִרְאוֹת אֶת־יֵשׁוּעַ מַה־תָּאֳרוֹ וְלֹא יָכֹל מִפְּנֵי הָעָם כִּי־שְׁפַל קוֹמָה הָיָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","וַיָּרָץ לְפָנָיו וַיַּעַל עַל־עֵץ שִׁקְמָה לִרְאֹתוֹ כִּי הוּא הַדֶּרֶךְ אֲשֶׁר יַעֲבָר־שָׁמָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","וַיָּבֹא יֵשׁוּעַ אֶל־הַמָּקוֹם הַהוּא וַיִּשָּׂא אֶת־עֵינָיו וַיִּרְאֵהוּ וַיֹּאמֶר אֵלָיו זַכָּי מַהֲרָה רְדָה כִּי הִנְנִי לִשְׁכֹּן הַיּוֹם בְּבֵיתֶךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","וַיְמַהֵר וַיֵּרַד וַיַּאַסְפֵהוּ אֶל־בֵּיתוֹ בְּשִׂמְחַת לִבּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","וַיִּלֹּנוּ כָל־הָרֹאִים לֵאמֹר אֶל־בֵּית אִישׁ חֹטֵא נָטָה לָלוּן׃ ");
INSERT INTO hebsg_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","וַיַּעֲמֹד זַכָּי וַיֹּאמֶר אֶל־הָאָדוֹן רְאֵה אֲדֹנִי הִנְנִי נֹתֵן מַחֲצִית כַּסְפִּי לָעֲנִיִּים וְאִם־עָשַׁקְתִּי אִישׁ מְאוּמָה אָשִׁיב לוֹ אַרְבַּעְתָּיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","וַיֹּאמֶר לוֹ יֵשׁוּעַ הַיּוֹם הָיְתָה תְשׁוּעָה לַבַּיִת הַזֶּה בַּאֲשֶׁר גַּם־הוּא בֶּן־אַבְרָהָם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","כִּי בֶן־הָאָדָם בָּא לְבַקֵּשׁ וּלְהוֹשִׁיעַ אֶת־הָאֹבֵד׃ ");
INSERT INTO hebsg_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","וְכַאֲשֶׁר שָׁמְעוּ אֶת־הַדְּבָרִים הָאֵלֶּה וַיּוֹסֶף וַיְמַשֵּׁל לָהֶם מָשָׁל כִּי קָרוֹב הָיָה לִירוּשָׁלַיִם וְהֵם חָשְׁבוּ כִּי עַד־מְהֵרָה תִגָּלֶה מַלְכוּת הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","וַיֹּאמַר אִישׁ נָדִיב הָלַךְ אֶל־אֶרֶץ רְחוֹקָה לָקַחַת־לוֹ מַמְלָכָה וְלָשׁוּב׃ ");
INSERT INTO hebsg_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","וַיִּקְרָא אֶל־עֲשָׂרָה מֵעֲבָדָיו וַיִּתֵּן לָהֶם עֲשֶׂרֶת מָנִים וַיֹּאמֶר אֲלֵיהֶם סַחֲרוּ בָזֶה עַד בֹּאִי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","וְאַנְשֵׁי עִירוֹ שָׂנְאוּ אֹתוֹ וַיִּשְׁלְחוּ אַחֲרָיו מַלְאָכִים לֵאמֹר אֵין אֶת־נַפְשֵׁנוּ כִּי זֶה יִמְלֹךְ עָלֵינוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","וַיְהִי אַחֲרֵי שׁוּבוֹ וְהַמַּמְלָכָה נָכוֹנָה בְיָדוֹ וַיְצַו לִקְרֹא אֵלָיו אֶת־הָעֲבָדִים הָהֵם אֲשֶׁר נָתַן לָהֶם אֶת־הַכֶּסֶף לִרְאוֹת מֶה־עָשָׂה אִישׁ אִישׁ בְּמִסְחָרוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","וַיָּבֹא הָרִאשׁוֹן וַיֹּאמַר אֲדֹנִי הַמָּנֶה נָתַתָּ לִּי הֶעֱלָה יִתְרוֹן עֲשֶׂרֶת מָנִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","וַיֹּאמֶר אֵלָיו הֵיטַבְתָּ עֶבֶד טוֹב בְּכֶסֶף מְעַט נֶאֱמָן הָיִיתָ הֱיֵה שַׁלִּיט מֵהַיּוֹם עַל־עֶשֶׂר עָרִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","וַיָּבֹא הַשֵּׁנִי וַיֹּאמַר אֲדֹנִי הַמָּנֶה נָתַתָּ לִּי הֶעֱלָה יִתְרוֹן חֲמֵשֶׁת מָנִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","וַיֹּאמֶר גַּם אֶל־זֶה וְאַתָּה הֱיֵה עַל־חָמֵשׁ עָרִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","וְאָחָד מֵהֶם בָּא וַיֹּאמַר הֵא־לְךָ אֲדֹנִי הַמָּנֶה נָתַתָּ לִּי אֲשֶׁר צָרוּר הָיָה בְּמִטְפָּחַת׃ ");
INSERT INTO hebsg_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","כִּי יָרֵאתִי מִפָּנֶיךָ אַחֲרֵי אֲשֶׁר אִישׁ קָשֶׁה אַתָּה נֹשֵׂא בַּאֲשֶׁר לֹא נָתַתָּ וְקוֹצֵר בַּאֲשֶׁר לֹא זָרָעְתָּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","וַיֹּאמֶר אֵלָיו עַל־פִּיךָ אִשָּׁפֵט אִתְּךָ עֶבֶד רָע הֲלֹא יָדַעְתָּ כִּי־אִישׁ קָשֶׁה אָנֹכִי נֹשֵׂא בַּאֲשֶׁר לֹא נָתַתִּי וְקוֹצֵר בַּאֲשֶׁר לֹא זָרָעְתִּי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","וְלָמָּה־זֶּה לֹא נָתַתָּ אֶת־כַּסְפִּי לִמְחַלְּפֵי כָסֶף וַאֲנִי בְּבֹאִי הִשַּׂגְתִּי אֹתוֹ בְּתַרְבִּית׃ ");
INSERT INTO hebsg_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","וַיֹּאמֶר אֶל־הָעֹמְדִים עָלָיו קְחוּ מִיָּדוֹ אֶת־הַמָּנֶה וּתְנוּ לָזֶה אֲשֶׁר־לוֹ עֲשֶׂרֶת הַמָּנִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","וַיֹּאמְרוּ אֵלָיו אֲדֹנֵינוּ הֲלֹא הוּא יֶשׁ־לוֹ עֲשֶׂרֶת מָנִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","אֲנִי אֹמֵר לָכֶם כָּל־אִישׁ אֲשֶׁר יֶשׁ־לוֹ יִנָּתֶן־לוֹ עוֹד וּמִי אֲשֶׁר אֵין לוֹ יֻקַּח מִמֶּנּוּ גַּם אֶת־אֲשֶׁר־בְּיָדוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","אֲבָל אֹיְבַי אֵלֶּה אֲשֶׁר לֹא־אָבוּ כִּי אֶמְלֹךְ עֲלֵיהֶם הָבִיאוּ אֹתָם הֵנָּה וַהֲמִיתוּם לְפָנָי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","וְאַחֲרֵי אֲשֶׁר דִּבֵּר אֶת־הַדְּבָרִים הָאֵלֶּה הָלַךְ לִפְנֵיהֶם וַיַּעַל יְרוּשָׁלָיְמָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","וַיְהִי כַּאֲשֶׁר הִקְרִיב לָבֹא אֵצֶל בֵּית פַּגֵּי וּבֵית־עַנְיָה בָּהָר הַנִּקְרָא הַר הַזֵּיתִים וַיִּשְׁלַח שְׁנַיִם מִתַּלְמִידָיו לֵאמֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","לְכוּ אֶל־הַכְּפָר אֲשֶׁר מִנֶּגֶד וְהָיָה כְּבֹאֲכֶם שָׁמָּה תִּמְצְאוּ עַיִר אָסוּר אֲשֶׁר לֹא־רָכַב עָלָיו אִישׁ הַתִּירוּ אֹתוֹ וַהֲבִיאֻהוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","וְכִי־יִשְׁאַל אֶתְכֶם אִישׁ לָמָּה־זֶּה תַּתִּירוּ אֹתוֹ כֹּה תֹאמְרוּן אֹתוֹ יִעֵד הָאָדוֹן לְחֶפְצוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","וַיֵּלְכוּ הַמַּלְאָכִים וַיִּמְצְאוּ כַּאֲשֶׁר דִּבֶּר אֲלֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","וַיַּתִּירוּ אֶת־הָעָיִר וַיֹּאמֶר אֲלֵיהֶם בְּעָלָיו לָמָּה־זֶּה תַּתִּירוּ אֶת־הָעָיִר׃ ");
INSERT INTO hebsg_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","וַיַּעֲנוּ אֹתוֹ יִעֵד הָאָדוֹן לְחֶפְצוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","וַיָּבִיאוּ אֹתוֹ אֶל־יֵשׁוּעַ וַיָּשִׂימוּ אֶת־בִּגְדֵהֶם עַל־הָעַיִר וַיַּרְכִּיבוּ עָלָיו אֶת־יֵשׁוּעַ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","וַיִּרְכַּב וַיֵּלַךְ וְהֵם פָּרְשׂוּ אֶת־בִּגְדֵיהֶם עַל־הַדָּרֶךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","וַיְהִי כַּאֲשֶׁר הִקְרִיב אֶל־מוֹרַד הַר הַזֵּיתִים וַיָּחֵלוּ כָּל־קְהַל תַּלְמִידָיו לְבָרֵךְ אֶת־הָאֱלֹהִים בְּחֶדְוָה וּבְקוֹל רִנָּה עַל כָּל־הַנִּפְלָאוֹת אֲשֶׁר רָאוּ לֵאמֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","בָּרוּךְ הַמֶּלֶךְ הַבָּא בְּשֵׁם יְהוָֹה שָׁלוֹם בַּשָּׁמַיִם וְכָבוֹד בִּמְרֹמֵי־עָל׃ ");
INSERT INTO hebsg_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","וַאֲנָשִׁים מִן־הַפְּרוּשִׁים אֲשֶׁר בְּקֶרֶב הָעָם אָמְרוּ אֵלָיו רַבִּי גְּעַר בְּתַלְמִידֶיךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","וַיַּעַן וַיֹּאמַר הִנְנִי אֹמֵר לָכֶם אִם־אֵלֶּה יֶחֱשׁוּ אֲבָנִים יִזְעָקוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","וַיִּקְרַב וַיַּרְא אֶת־הָעִיר וַיֵּבְךְ עָלֶיהָ לֵאמֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","לוּ יָדַעַתְּ גַּם־אַתְּ בְּיוֹמֵךְ זֶה מֵאַיִן יָבֹא שְׁלוֹמֵךְ אַךְ נִסְתָּר הוּא מִנֶּגֶד עֵינָיִךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","כִּי הִנֵּה יָמִים בָּאִים וְשָׁפְכוּ עָלַיִךְ אֹיְבִים סֹלְלָה מִסָּבִיב וְהִקִּיפוּךְ וְצָרוּ עָלַיִךְ מִכָּל־עֵבֶר׃ ");
INSERT INTO hebsg_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","וְנִפְּצוּ אֹתָךְ וְאֶת־בָּנַיִךְ בְּקִרְבֵּךְ עַד־עָפָר וְלֹא־יַשְׁאִירוּ בָךְ אֶבֶן עַל־אָבֶן תַּחַת אֲשֶׁר לֹא יָדַעַתְּ עֵת פְּקֻדָּתֵךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","וַיָּבֹא אֶל־הַהֵיכָל וַיָּחֶל לְגָרֵשׁ מִקִּרְבּוֹ אֶת־הַמֹּכְרִים שָּׁם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","וַיֹּאמֶר אֲלֵיהֶם כָּתוּב כִּי בֵיתִי בֵּית־תְּפִילָּה הוּא וְאַתֶּם עֲשִׂיתֶם אֹתוֹ לִמְעָרַת פָּרִיצִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","וַיְהִי מוֹרֶה יוֹם יוֹם בַּהֵיכָל אַךְ רָאשֵׁי הַכֹּהֲנִים וְהַסּוֹפְרִים וְשָׂרֵי הָעָם בִּקְשׁוּ לְהַשְׁמִידוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","וְלֹא מָצְאוּ מַה־לַּעֲשׂוֹת כִּי כָל־הָעָם דָּבְקוּ אַחֲרָיו לִשְׁמֹעַ אֹתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","וַיְהִי הַיּוֹם בִּהְיוֹתוֹ בַהֵיכָל לְהוֹרֹת לָעָם תּוֹרָה וּדְבַר הַבְּשׂרָה וַיִּגְשׁוּ אֵלָיו רָאשֵׁי הַכֹּהֲנִים וְהַסּוֹפְרִים עִם־הַזְּקֵנִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","וַיְדַבְּרוּ אֵלָיו לֵאמֹר אֱמָר לָנוּ בְּאֵיזֶה־זֶה רִשְׁיוֹן אַתָּה עֹשֶׂה אֵלֶּה וּמִי הוּא אֲשֶׁר נָתַן לְךָ אֶת־הָרִשְׁיוֹן הַזֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","וַיַּעַן וַיֹּאמֶר אֲלֵיהֶם אֶשְׁאַל מִכֶּם גַּם־אָנֹכִי דָבָר אִם תַּגִּידוּ לִי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","טְבִילַת יוֹחָנָן מִפִּי־מִי הָיְתָה מִצְוָתָהּ מִן־הַשָּׁמַיִם אוֹ מִבְּנֵי־אָדָם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","וַיְהִי הֵם שֹׁקְלִים בְּדַעְתָּם לֵאמֹר אִם־נֹאמַר מִן־הַשָּׁמַיִם יֹאמַר לָנוּ וּמַדּוּעַ לֹא הֱאֶמַנְתֶּם לוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","וְאִם־נֹאמַר מִבְּנֵי אָדָם יִסְקְלֻנוּ כָל־הָעָם כִּי נָכוֹן הָיָה לָהֶם הַדָּבָר אֲשֶׁר יוֹחָנָן נָבִיא הָיָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","וַיַּעֲנוּ וַיֹּאמְרוּ לֹא יָדַעְנוּ מִפִּי־מִי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","וַיֹּאמֶר יֵשׁוּעַ גַּם־אֲנִי לֹא אַגִּיד לָכֶם בְּאֵיזֶה רִשְׁיוֹן אֲנִי עֹשֶׂה אֵלֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","וַיָּחֶל לְדַבֵּר אֶל־הָעָם אֶת־הַמָּשָׁל הַזֶּה אִישׁ אֶחָד נָטַע כָּרָם וַיִּתֵּן אֶת־הַכֶּרֶם לַנֹּטְרִים וַיֵּלֶךְ חוּצָה לָאָרֶץ לְיָמִים רַבִּים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","וּלְעֵת הַבָּצִיר שָׁלַח אֶת־עַבְדּוֹ אֶל־הַנֹּטְרִים אֲשֶׁר יָבִיא לוֹ מִפְּרִי כַרְמוֹ וְהַנֹּטְרִים הִכֻּהוּ וַיְשַׁלְחֻהוּ רֵיקָם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","וַיּוֹסֶף וַיִּשְׁלַח עֶבֶד אַחֵר וְגַם־אֹתוֹ הִכּוּ גִּדְפוּ וְשִׁלְחוּ רֵיקָם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","וַיִּשְׁלַח אֲלֵיהֶם עוֹד עֶבֶד שְׁלִישִׁי וַיַּכֻּהוּ הַכֵּה וּפָצֹעַ וְהָדְפוּ אֹתוֹ לְמַדְחֵפוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","וַיֹּאמֶר אֲדוֹן הַכֶּרֶם מָה־אֶעֱשֶׂה אֶשְׁלַח אֶת־בְּנִי אֶת־יְדִידִי אוּלַי יִירְאוּ מִפָּנָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","כִּרְאוֹת אֹתוֹ הַנֹּטְרִים נוֹסְדוּ יַחַד לֵאמֹר הִנֵּה הַיּוֹרֵשׁ בָּא לְכוּ וְנַהַרְגֵהוּ וְלָנוּ תִסֹּב הַנַּחֲלָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","וַיֶּהְדְפוּ אֹתוֹ אֶל־מִחוּץ לַכֶּרֶם וַיַּהַרְגֻהוּ וּמָה אֵפוֹא יַעֲשֶׂה לָהֶם אֲדוֹן הַכָּרֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","הוּא יָבֹא וְהֶאֱבִיד אֶת־הַנֹּטְרִים הָהֵם וְאֶת־כַּרְמוֹ יִתֵּן בִּידֵי אֲחֵרִים וַיִּשְׁמְעוּ וַיֹּאמְרוּ חָלִילָה לֹא תִהְיֶה כָּזֹאת׃ ");
INSERT INTO hebsg_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","וַיִּתֵּן עֵינָיו בָּם וַיֹּאמַר וּמַה דְּבַר הַכָּתוּב אֶבֶן מָאֲסוּ הַבּוֹנִים הָיְתָה לְרֹאשׁ פִּנָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","כָּל־הַנֹּפֵל עַל־הָאֶבֶן הַזֹּאת יִתְפּוֹרָר וְכָל־מִי אֲשֶׁר תִּפֹּל עָלָיו תְּדַכְּאֶנּוּ לֶעָפָר׃ ");
INSERT INTO hebsg_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","וַיְבַקְשׁוּ הַסּוֹפְרִים וְרָאשֵׁי הַכֹּהֲנִים לִשְׁלֹחַ בּוֹ יַד בָּעֵת הַהִיא כִּי רָאוּ אֲשֶׁר עֲלֵיהֶם הוּא נֹשֵׂא אֶת־הַמָּשָׁל הַזֶּה אֶפֶס כִּי יָרְאוּ מִפְּנֵי הָעָם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","וַיֶּאֶרְבוּ־לוֹ וַיִּשְׁלְחוּ מְרַגְלִים מִתְחַפְּשִׂים כְּאַנְשֵׁי־צֶדֶק לְצֹדֵד אֹתוֹ בִּדְבָרָיו וּלְהַסְגִּירוֹ לִידֵי הַמִּשְׁפָּט וִידֵי הַפֶּחָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","וַיִּשְׁאֲלוּ אֹתוֹ לֵאמֹר רַבֵּנוּ יָדַעְנוּ כִּי נָכוֹן תֶּהְגֶּה וּתְלַמֵּד לֹא־תִשָׂא פְנֵי־אִישׁ וְאֶת־דֶּרֶךְ הָאֱלֹהִים תּוֹרֶה בְּמֵישָׁרִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","הֲנָכוֹן לָנוּ לָתֵת מַס לַקֵּיסָר אִם־אָיִן׃ ");
INSERT INTO hebsg_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","וַיַּכֵּר אֶת־נִכְלֵיהֶם וַיֹּאמֶר אֲלֵיהֶם מַה־תְּנַסּוּנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","הַרְאוּ לִי דִּינַר אֶחָד לְמִי הַתְּמוּנָה וְהַכְּתֹבֶת הָהֵנָּה וַיֹּאמְרוּ לַקֵּיסָר׃ ");
INSERT INTO hebsg_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","וַיֹּאמֶר אֲלֵיהֶם עַל־כֵּן הָבוּ לַקֵּיסַר אֶת אֲשֶׁר לַקֵּיסָר וְלֵאלֹהִים אֵת אֲשֶׁר לֵאלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","וְלֹא יָכְלוּ לְצֹדֵד אֹתוֹ בְּדַבְּרוֹ לִפְנֵי הָעָם וַיִּתְפַּלְּאוּ עַל־הַמַּעֲנֶה וַיַּחְרִישׁוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","וַיִּגְּשׁוּ אֲנָשִׁים מִן־הַצַּדּוּקִים הָאֹמְרִים כִּי־אֵין תְּחִיַּת הַמֵּתִים וַיִּשְׁאָלֻהוּ לֵאמֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","רַבֵּנוּ הִנֵּה מֹשֶׁה כָּתַב לָנוּ כִּי יָמוּת אֶחָד מִשְּׁנֵי אַחִים וְהוּא בַּעַל אִשָּׁה וּבֵין אֵין־לוֹ אֵשֶׁת הַמֵּת יְבָמָה יָבֹא עָלֶיהָ וְהֵקִים זֶרַע עַל־שֵׁם אָחִיו׃ ");
INSERT INTO hebsg_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","וְאִתָּנוּ הָיוּ שִׁבְעָה אַחִים הָרִאשׁוֹן לָקַח לוֹ אִשָּׁה וַיָּמָת וּבֵן אֵין־לוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","וְהַשֵּׁנִי יִבֵּם אֹתָהּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","וְכֵן גַּם־הַשְּׁלִישִׁי וְכֵן כָּל־הַשִּׁבְעָה וְכֻלָּם מֵתוּ לֹא־בָנִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","וּבָאַחֲרוֹנָה מֵתָה גַּם־הָאִשָּׁה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","וְעַתָּה לְמִי מֵהֶם תִּהְיֶה לְאִשָּׁה בִּתְחִיַּת הַמֵּתִים אַחֲרֵי אֲשֶׁר הָיְתָה אֵשֶׁת כָּל־הַשִּׁבְעָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","וַיֹּאמֶר יֵשׁוּעַ אֲלֵיהֶם בְּנֵי הָעוֹלָם הַזֶּה אֲנָשִׁים יִבְעָלוּ וְנָשִׁים תִּבָּעַלְנָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","אַךְ הָעֹמְדִים לָרֶשֶׁת אֶת־הָעוֹלָם הַבָּא וְלִחְיוֹת מִן־הַמֵּתִים לֹא יִבְעָלוּ וְלֹא תִבָּעַלְנָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","וְלֹא יוּכְלוּ לָמוּת עוֹד כִּי דוּמִים הֵם לְמַּלְאָכִים כִּי בִּהְיוֹתָם בְּנֵי הַתְּחִיָּה בְּנֵי אֱלֹהִים הֵמָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","וְהַמֵּתִים כִּי יָקוּמוּ גַּם־לְמֹשֶׁה הֻגַּד מִתּוֹךְ הַסְּנֶה כַּאֲשֶׁר קָרָא יְהוָֹה אֱלֹהֵי אַבְרָהָם אֱלֹהֵי יִצְחָק וֵאלֹהֵי יַעֲקֹב׃ ");
INSERT INTO hebsg_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","וְהָאֱלֹהִים אֵינֶנּוּ אֱלֹהֵי הַמֵּתִים כִּי אִם־אֱלֹהֵי הַחַיִּים כִּי כֻלָּם חַיִּים לְפָנָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","וַיַּעֲנוּ סוֹפְרִים אֲחָדִים וַיֹּאמְרוּ רַבִּי הֵיטֵב דִּבַּרְתָּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","וְלֹא־הֵעֵז עוֹד אִישׁ מֵהֶם לִשְׁאֹל אֹתוֹ דָּבָר׃ ");
INSERT INTO hebsg_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","וַיֹּאמֶר אֲלֵיהֶם אֵיךְ יֹאמְרוּ כִּי הַמָּשִׁיחַ בֶּן־דָּוִד הוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","וְדָוִד הֲלֹא הוּא אֹמֵר בְּסֵפֶר תְּהִלִּים נְאֻם יְהוָֹה לַאדֹנִי שֵׁב לִימִינִי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","עַד־אָשִׁית אֹיְבֶיךָ הֲדֹם לְרַגְלֶיךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","וְאִם דָּוִד קֹרֵא לוֹ אָדוֹן אֵיךְ הוּא בְּנוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","וַיֹּאמֶר אֶל־תַּלְמִידָיו בְּאָזְנֵי כָל־הָעָם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","הִשָּׁמְרוּ לָכֶם מִן־הַסּוֹפְרִים הַמִּתְעַנְּגִים עַל לֶכְתָּם מְלֻבָּשִׁים מְעִיל וְאֹהֲבִים אֶת־שְׁאֵלַת שָׁלוֹם לָהֶם בַּשְּׁוָקִים וְאֶת־הַמּוֹשָׁבוֹת הָרִאשֹׁנִים בְּבָתֵי־הַכְּנֵסֶת וְאֶת־הַמְּקֹמוֹת הַנִּכְבָּדִים בְּבָתֵּי הַמִּשְׁתֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","הָאֹכְלִים אֶת־בָּתֵּי אַלְמָנוֹת וּלְמַרְאֶה־עַיִן יַרְבּוּ תְפִלָּה אֵלֶּה הֵם אֲשֶׁר יִנָּטֶה עֲלֵיהֶם קַו־הַמִּשְׁפָּט פִּי שְׁנָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","וַיִּשָׂא אֶת־עֵינָיו וַיַּרְא עֲשִׁירֵי־עָם נֹתְנִים מַתְּנַת יָדָם אֶל־אֲרוֹן הָאוֹצָר׃ ");
INSERT INTO hebsg_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","וְאִשָּׁה אַלְמָנָה עֲנִיָּה רָאָה נֹתֶנֶת בּוֹ שְׁתַּיִם פְּרוּטוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","וַיֹּאמַר אָמֵן אֲנִי אֹמֵר לָכֶם הָאַלְמָנָה הָעֲנִיָּה הַזֹּאת נָתְנָה יוֹתֵר מִכֻּלָּם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","כִּי כָל־אֵלֶּה נָתְנוּ לֵאלֹהִים מַתְּנַת יָדָם מִמּוֹתָרָם וְהִיא מִמַּחְסֹרָהּ נָתְנָה אֶת־כָּל־אֲשֶׁר לָהּ אֵת כָּל־מִחְיָתָהּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","אָז נִדְבְּרוּ אִישׁ אֶל־רֵעֵהוּ כִּי נֶאְדָּר הַהֵיכָל בַּאֲבָנִים יָפוֹת וּנְדָבוֹת יְקָרוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","וַיֹּאמַר הֲרֹאִים אַתֶּם אֵלֶּה הִנֵּה יָמִים בָּאִים וְלֹא תִשָּׁאֵר פֹּה אֶבֶן עַל־אֶבֶן אֲשֶׁר לֹא תֻתָּץ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","וַיִּשְׁאֲלוּ אֹתוֹ לֵאמֹר רַבֵּנוּ מָתַי תִּקְרֶינָה אֵלֶּה וּמָה אוֹת לְעֵת בֹּאָן׃ ");
INSERT INTO hebsg_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","וַיֹּאמַר הִשָּׁמְרוּ לָכֶם פֶּן־יַתְעֶה אֶתְכֶם אִישׁ כִּי רַבִּים יָבֹאוּ בִשְׁמִי לֵאמֹר אֲנִי הוּא וְקָרוֹב הַמּוֹעֵד לָבֹא אַל־תֵּלְכוּ אַחֲרֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","וְכִי־תִשְׁמְעוּ קְרָבוֹת וּפְרָצוֹת אַל־תֵּחַתּוּ כִּי אֵלֶּה תִּהְיֶינָה רִאשׁוֹנָה וְעוֹד לֹא הַקֵּץ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","וַיּוֹסֶף לְדַבֵּר אֲלֵיהֶם הִנֵּה גּוֹי יָקוּם עַל־גּוֹי וּמַמְלָכָה עַל־מַמְלָכָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","וְהָאָרֶץ תִּגְעַשׁ תִּרְעַשׁ מֵעֲבָרֶיהָ מִזֶּה וּמִזֶּה וְרָעָב יָבֹא וָדָבֶר וּמֹפְתִים גְּדוֹלִים וְנוֹרָאִים מִן־הַשָּׁמָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","וּבְטֶרֶם יָבֹאוּ כָל־אֵלֶּה יִשְׁלְחוּ בָכֶם מְנַדֵּיכֶם יָד וְרָדְפוּ אֶתְכֶם וְהִסְגִּירוּכֶם לְבָתֵּי הַכְּנֵסֶת וּלְבָתֵּי כְלָאִים וְהוֹבִילוּ אֶתְכֶם לִפְנֵי מְלָכִים וּמֹשְׁלִים לְמַעַן שְׁמִי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","וְזֹאת תִּהְיֶה לְעֵדוּת לָכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","עַל־כֵּן שִׂימוּ עַל־לִבְּכֶם לְבִלְתִּי הָכֵן מֵרֹאשׁ מַה תָּשִׁיבוּ לְהַצְדִּיק נַפְשְׁכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","כִּי אָנֹכִי אֶתֵּן לָכֶם פֶּה וְחָכְמָה עַד אֲשֶׁר כָּל־מִתְקוֹמְמֵיכֶם לֹא יוּכְלוּ לַעֲמֹד לִפְנֵיכֶם וְלָשִׂים לְאַל מִלֵּיכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","וְאַף אַתֶּם תִּמָּסְרוּ עַל־יְדֵי אָבוֹת וְאַחִים וּקְרוֹבִים וְרֵעִים וְגַם־יָמִיתוּ מִכֶּם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","וְאַתֶּם שְׂנוּאִים תִּהְיוּ לְכָל־אָדָם לְמַעַן שְׁמִי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","בְּכָל־זֹאת לֹא יִפֹּל מִשַּׂעֲרַת רֹאשְׁכֶם אָרְצָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","בְּהַאֲרִיךְ רוּחֲכֶם אֶת־נַפְשְׁכֶם תִּשְׁמֹרוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","וְכַאֲשֶׁר תִּרְאוּ אֶת־יְרוּשָׁלַיִם כִּי תַחֲנֶה עָלֶיהָ מַחֲנֶה מִסָּבִיב יָדֹעַ תֵּדְעוּ כִּי שִׁמְמֻתָהּ בָּאָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","אָז אֵלֶּה אֲשֶׁר בִּיהוּדָה יָנוּסוּ אֶל־הֶהָרִים וַאֲשֶׁר בְּתוֹךְ הָעִיר יִבְרְחוּ מִמֶּנָה וְאֲשֶׁר בַּשָּׂדֶה בַּל־יָבֹאוּ בָהּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","כִּי־יְמֵי נְקָמָה הֵם לְמַלְּאֹת כָּל־דְבַר הַכָּתוּב׃ ");
INSERT INTO hebsg_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","אוֹי לֶהָרוֹת וְלַמֵּינִיקוֹת בַּיָּמִים הָהֵמָּה כִּי צָרָה גְדוֹלָה תִּהְיֶה בָאָרֶץ וְקֶצֶף עַל־הָעָם הַזֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","וְנָפְלוּ לְפִי־חֶרֶב וְהָגְלוּ אֶל־כָּל־הָעַמִּים וִירוּשָׁלַיִם תִּהְיֶה לְמִרְמַס הַגּוֹיִם עַד אֲשֶׁר־תִּמָלֶאנָה עִתּוֹת הַגּוֹיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","וּמוֹפְתִים יִנָּתְנוּ בַּשֶּׁמֶשׁ וְיָרֵחַ וְכוֹכָבִים וְהַגּוֹיִם יֵחַתּוּ בָאָרֶץ וּמְבוּכָה תָבֹא עֲלֵיהֶם מִשְּׁאוֹן הַיָּם וּמִשְׁבָּרָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","וּבְנֵי־אָדָם נַפְשָׁם תִּתְעַטֵּף עֲלֵיהֶם מִפַּחַד וּמֵעֲתִידֹת לָבֹא בְּתֵבֵל אָרְצָה כִּי־מוֹסְדוֹת הַשָּׁמַיִם יִרְגָּזוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","וְאָז יִרְאוּ אֶת־בֶּן־הָאָדָם בָּא בֶּעָנָן בְּעֹז וּבְהָדָר גָּדוֹל׃ ");
INSERT INTO hebsg_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","וּכְהָחֵל הַדְּבָרִים הָאֵלֶּה לָקוּם תִּתְעוֹדְדוּ וְתָרִימוּ רֹאשׁ כִּי פְדוּת־נַפְשְׁכֶם קְרוֹבָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","וַיִּשָּׂא אֲלֵיהֶם מְשָׁלוֹ הִתְבּוֹנְנוּ בִתְאֵנָה וּבְכָל־עֲצֵי הַשָּׂדֶה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","כַּאֲשֶׁר יוֹצִיאוּ פֶרַח תַּבִּיטוּ וְתָבִינוּ בְנַפְשְׁכֶם כִּי קָרוֹב הַקָּיִץ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","וְכֵן גַּם־אַתֶּם כַּאֲשֶׁר תִּרְאוּ כִּי קָמוּ כָּל־אֵלֶּה יָדֹעַ תֵּדְעוּ כִּי קְרוֹבָה מַלְכוּת הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","אָמֵן אֲנִי אֹמֵר לָכֶם כִּי לֹא יַעֲבֹר הַדּוֹר הַזֶּה עַד אֲשֶׁר יָקוּמוּ כָּל־אֵלֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","הַשָּׁמַיִם וְהָאָרֶץ יַעֲבֹרוּ וּדְבָרַי לֹא יַעֲבֹרוּן׃ ");
INSERT INTO hebsg_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","אַךְ הִשָּׁמְרוּ לָכֶם פֶּן־יִטְפַּשׁ לִבְּכֶם מֵרֹב מִשְׁתֶּה וְשִׁכָּרוֹן אוֹ מִדַּאֲגוֹת מַחֲסֹרֵי הַחַיִּים וּלְפֶתַע פִּתְאֹם יָבֹא עֲלֵיכֶם הַיּוֹם הַהוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","כִּי כְּפַח יָקוּשׁ יִפֹּל עַל כָּל־ישְׁבֵי הָאָרֶץ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","עַל־כֵּן הִתְעוֹרְרוּ וְהַעְתִּירוּ תָמִיד לְהִנָּתֵן לָכֶם דֵּי־כֹחַ לְהִמָּלֵט מִכָּל־פֶּגַע הַבָּא וְלַעֲמֹד הָכֵן לִפְנֵי בֶן־הָאָדָם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","וַיְהִי יוֹם יוֹם מִשְׁפָּטוֹ לְלַמֵּד בַּהֵיכָל וּבַלַּיְלָה יָצָא לָלוּן בָּהָר הוּא הַר הַזֵּיתִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","וְכָל־הָעָם הִשְׁכִּימוּ בַבֹּקֶר וַיָּבֹאוּ אֵלָיו לְבֵית־הַמִּקְדָּשׁ לִשְׁמֹעַ אֹתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","וַיִּקְרַב חַג הַמַּצּוֹת הוּא חַג הַפָּסַח׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","וְרָאשֵׁי הַכֹּהֲנִים וְהַסּוֹפְרִים בִּקְשׁוּ בַּמָּה אֶת־נַפְשׁוֹ לְקַחְתָּהּ כִּי יָרְאוּ מִפְּנֵי הָעָם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","וִיהוּדָה אֲשֶׁר כִּנּוּהוּ אִישׁ־קְרִיּוֹת אֶחָד מִמִּסְפַּר שְׁנֵים הֶעָשָׂר בָּא בוֹ הַשָּׂטָן׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","וַיֵּלֶךְ וַיְדַבֵּר אֶת־רָאשֵׁי הַכֹּהֲנִים וְאֶת־רָאשֵׁי הַצָּבָא אֵיכָה יַסְגִּיר אֹתוֹ בְּיָדָם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","וַיִּשְׂמְחוּ יַיֵּאֹתוּ לָתֶת־לוֹ כָּסֶף׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","וְהוּא הִבְטִיחָם לְמַלֵּא דְבָרוֹ וְתֹאֲנָה בִּקֶּשׁ־לוֹ לְהַסְגִּירוֹ בְיָדָם בְּסֵתֶר וְלֹא בֶהָמוֹן׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","וַיָּבֹא יוֹם חַג הַמַּצּוֹת הוּא יוֹם זֶבַח הַפָּסַח׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","וַיִּשְׁלַח אֶת־פֶּטְרוֹס וְאֶת־יוֹחָנָן לֵאמֹר לְכוּ הָכִינוּ לָנוּ לֶאֱכֹל אֶת־הַפָּסַח׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","וַיֹּאמְרוּ אֵלָיו אֵיפוֹא תִרְצֶה כִּי־נֵלֵךְ לְהָכִין׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","וַיֹּאמֶר אֲלֵיהֶם הִנֵּה כְּבֹאֲכֶם הָעִירָה וּפָגַע בָּכֶם אִישׁ נֹשֵׂא כַּד מָיִם לְכוּ אַחֲרָיו אֶל־הַבַּיִת אֲשֶׁר יָבֹא שָׁמָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","וַאֲמַרְתֶּם אֶל־בַּעַל הַבָּיִת כֹּה אָמַר רַבֵּנוּ אַיֵּה חֲדַר הָאֹרְחִים לִי וּלְתַלְמִידַי לֶאֱכֹל שָׁם אֶת־הַפָּסַח׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","וְהוּא יַרְאֶה לָכֶם עֲלִיָּה גְדוֹלָה רְצוּפָה כְסָתוֹת וְשָׁם תָּכִינוּ לָנוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","וַיֵּלְכוּ וַיִּמְצְאוּ כַּאֲשֶׁר דִּבֶּר לָהֶם וַיָּכִינוּ אֶת־הַפָּסַח׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","וְכַאֲשֶׁר הִגִּיעַ הַמּוֹעֵד וַיֵּשֶׁב בִּמְסִבּוֹ הוּא וּשְׁנֵים־עָשָׂר הַשְּׁלִיחִים אִתּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","וַיֹּאמֶר אֲלֵיהֶם נִכְסֹף נִכְסַפְתִּי לֶאֱכֹל אֶת־הַפֶּסַח הַזֶּה עִמָּכֶם טֶרֶם תְעֻנֶּה נַפְשִׁי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","כִּי אֲנִי אֹמֵר לָכֶם כִּי לֹא אֹכַל מִמֶּנּוּ עַד מוֹעֵד הֵאָכְלוֹ בְּמַלְכוּת הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","וַיִּקַּח אֶת־הַכּוֹס וַיְבָרֶךְ וַיֹּאמַר קְחוּ זֹאת וְחִלְקוּהָ בֵינֵיכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","כִּי אֲנִי אֹמֵר לָכֶם כִּי לֹא־אֶשְׁתֶּה עוֹד מִפְּרִי הַגָּפֶן עַד כִּי־תָבוֹא מַלְכוּת הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","וַיִּקַח אֶת־הַלֶּחֶם וַיְבָרֶךְ וַיִּבְצַע וַיִּתֶּן לָהֶם לֵאמֹר זֶה הוּא בְּשָׂרִי הַנָּתוּן בַּעַדְכֶם עֲשׂוּ כֵן לְזִכָּרוֹן לִי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","וְכֵן גַּם־אֶת־הַכּוֹס לָקַח אַחֲרֵי אָכְלָם וַיֹּאמַר הַכּוֹס הַזֹּאת הִיא הַבְּרִית הַחֲדָשָׁה בְּדָמִי הַשָּׁפוּךְ בַּעַדְכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","אַך יַד־מַסְגִּירֵנִי הִנֵּה אִתִּי עַל־הַשֻּׁלְחָן׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","הֵן בֶּן־הָאָדָם הֹלֵךְ כַּאֲשֶׁר נִגְזַר עָלָיו אֲבָל אוֹי לָאִישׁ הַהוּא אֲשֶׁר יַסְגִּיר אֹתוֹ בְּיַד מְבַקְשֵׁי נַפְשׁוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","וְהֵם הֵחֵלוּ לַחֲקֹר וְלִדְרֹשׁ בֵּינֵיהֶם מִי־הוּא זֶה אֲשֶׁר יַעֲשֶׂה כָּזֹאת׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","וְגַם־דִּבְרֵי רִיבֹת הָיוּ בֵינֵיהֶם מִי נֶחְשָׁב הַגָּדוֹל בָּהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","וַיֹּאמֶר אֲלֵיהֶם מַלְכֵי הַגּוֹיִם שֹׁלְטִים בָּם וְהַשַּׁלִּיט נִקְרָא רַב חָסֶד׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","וְאַתֶּם לֹא־כֵן אַךְ הַגָּדוֹל בָּכֶם יְהִי כַצָּעִיר וְהָאָדוֹן כִּמְשָׁרֵת׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","כִּי מִי הַגָּדוֹל הַיּשֵׁב לֶאֱכֹל אוֹ הָעֹמֵד לְשָׁרֵת הֲלֹא הַיּשֵׁב לָאֱכֹל וַאֲנִי בְתוֹכְכֶם כִּמְשָׁרֵת׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","וְאַתֶּם הֵם אֲשֶׁר עֲמַדְתֶּם עִמָּדִי וְלֹא עֲזַבְתּוּנִי בַּמַּסּוֹת אֲשֶׁר עָבְרוּ עָלָי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","וְגַם־אֲנִי מַנְחִיל אֶתְכֶם אֶת־הַמַּלְכוּת אֲשֶׁר הִנְחִילַנִי אָבִי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","וּבְמַלְכוּתִי תֹּאכְלוּ וְתִשְׁתּוּ עַל שֻׁלְחָנִי וְתֵשְׁבוּ עַל־כִּסְאוֹת לִשְׁפֹּט אֶת־שְׁנֵים עָשָׂר שִׁבְטֵי יִשְׂרָאֵל׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","וַיֹּאמֶר הָאָדוֹן שִׁמְעוֹן שִׁמְעוֹן שָׁאֹל שְׁאָלְכֶם הַשָּׂטָן לִזְרוֹתְכֶם כִּזְרוֹת הַחִטִּים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","וַאֲנִי הִתְחַנַּנְתִּי בַעַדְךָ לִבְלִי תֶחְדַּל אֱמוּנָתֶךָ וְגַם־אַתָּה כַּהֲשִׁיבְךָ אֶל־לִבְּךָ רְאֵה לְחַזֵּק אֶת־אַחֶיךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","וְהוּא עָנָה וְאָמָר אֲדֹנִי נָכוֹן אָנֹכִי לָלֶכֶת עִמְּךָ גַּם־לְבֵית כֶּלֶא וְגַם־לְשַׁעֲרֵי מָוֶת׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","וַיֹּאמַר הִנְנִי אֹמֵר לְךָ כֵּיפָא לֹא־יִקְרָא הַתַּרְנְגֹל הַיּוֹם עַד אֲשֶׁר־תְּשַׁקֵּר שָׁלֹשׁ פְּעָמִים לֵאמֹר כִּי לֹא־יְדַעְתָּנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","וַיֹּאמֶר אֲלֵיהֶם כַּאֲשֶׁר שָׁלַחְתִּי אֶתְכֶם בְּלִי־צְרוֹר בְּלִי־יַלְקוּט וּבְלִי־נְעָלִים הַחֲסַרְתֶּם דָּבָר וַיֹּאמְרוּ לֹא חָסַרְנוּ דָּבָר׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","וַיֹּאמֶר אֲלֵיהֶם אֶפֶס כַּיּוֹם מִי אֲשֶׁר־לוֹ צְרוֹר יִשָּׂאֵהוּ עִמּוֹ וְכֵן יַלְקוּט וּמִי אֲשֶׁר לֹא־תַשִּׂיג יָדוֹ יִמְכֹּר גַּם־אֶת־בִּגְדוֹ וְיִקְנֶה לּוֹ חָרֶב׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","כִּי אֲנִי אֹמֵר לָכֶם כִּי יָקוּם אֲשֶׁר כָּתוּב עָלָי וְאֶת־פֹּשְׁעִים נִמְנָה כִּי כָל־הַכָּתוּב עָלַי יָקוּם עַד־תֻּמּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","וַיֹּאמְרוּ אֲדֹנֵינוּ הִנֵּה־פֹה אִתָּנוּ חֲרָבוֹת שְׁתָּיִם וַיֹּאמֶר אֲלֵיהֶם רַב לָנוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","וַיֵּצֵא וַיֵּלֶךְ כְּדַרְכּוֹ מֵאָז אֶל־הַר הַזֵּיתִים וְגַם־תַּלְמִידָיו הָלְכוּ אַחֲרָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","וַיִּפְגַּע בַּמָּקוֹם וַיֹּאמֶר אֲלֵיהֶם הִתְפַּלְּלוּ וְלֹא תָבֹאוּ לִידֵי נִסָּיוֹן׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","וְהוּא נִפְרַד מֵהֶם הַרְחֵק כִּקְלֹעַ אָבֶן וַיִּכְרַע וַיִּתְפַּלֵּל לֵאמֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","אָבִי הַעֲבֵר־נָא מֵעָלַי אֶת־הַכּוֹס הַזֹּאת אִם כֵּן רָצִיתָ אָתָּה אַךְ לֹא כִרְצוֹנִי כִּי אִם־כִּרְצוֹנְךָ יֶהִי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","וַיֵּרָא אֵלָיו מַלְאָךְ מִן־הַשָּׁמַיִם וַיְחַזְּקֵהוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","וְכַאֲשֶׁר אָפְפוּ אֹתוֹ חֶבְלֵי־מָוֶת הִתְפַּלֵּל בְּחָזְקָה וְנִטְפֵי זֵעָתוֹ כְּנִטְפֵי־דָם גְּדוֹלִים יָרְדוּ אָרְצָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","וַיָּקָם מִתְּפִלָּתוֹ וַיָּבֹא אֶל־תַּלְמִידָיו וַיִּמְצָאֵם יְשֵׁנִים מֵעִצָּבוֹן׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","וַיֹּאמֶר אֲלֵיהֶם לָמָּה־זֶּה תִּישְׁנוּ קוּמוּ וְהִתְפַּלְלוּ וְלֹא־תָבֹאוּ לִידֵי נִסָּיוֹן׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","עֹדֶנּוּ מְדַבֵּר וְהִנֵּה הֲמוֹן־עָם וְאֶחָד מִשְּׁנֵים־הֶעָשָׂר הַנִּקְרָא יְהוּדָה הֹלֵךְ בְּרֹאשָׁם וַיִּגַּשׁ אֶל־יֵשׁוּעַ לִנְשָׁק־לוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","וַיֹּאמֶר אֵלָיו יֵשׁוּעַ יְהוּדָה הֲתַסְגִּיר אֶת־בֶּן־הָאָדָם בִּנְשִׁיקָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","וַאֲנָשָׁיו אֲשֶׁר אִתּוֹ בִּרְאוֹתָם אֵת אֲשֶׁר תִּקְרֶינָה אָמְרוּ אֲדֹנֵינוּ הֲנַכֶּה בֶחָרֶב׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","וְאֶחָד מֵהֶם הִכָּה אֶת־עֶבֶד הַכֹּהֵן הַגָּדוֹל וַיְקַצֶּץ־לוֹ אָזְנוֹ הַיְמָנִית׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","וַיַּעַן יֵשׁוּעַ וַיֹּאמֶר הַרְפּוּ אַל־תּוֹסִיפוּ וַיִּגַּע בְּאָזְנוֹ וַיִּרְפָּאֵהוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","וַיֹּאמֶר יֵשׁוּעַ אֶל־רָאשֵׁי הַכֹּהֲנִים וְשָׂרֵי הַהֵיכָל וְהַזְּקֵנִים הַבָּאִים עָלָיו הַעַל פָּרִיץ יְצָאתֶם בַּחֲרָבוֹת וּבְמַטּוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","יוֹם יוֹם הָיִיתִי עִמָּכֶם בַּהֵיכָל וְלֹא־שְׁלַחְתֶּם בִּי יָד אַךְ זֹאת הִיא עִתְּכֶם וּמֶמְשֶׁלֶת הַחֹשֶׁךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","וַיַּחֲזִיקוּ־בוֹ וַיּוֹלִיכֻהוּ וַיְבִיאֻהוּ אֶל־בֵּית הַכֹּהֵן הַגָּדוֹל וּפֶטְרוּס הֹלֵךְ אַחֲרָיו מֵרָחוֹק׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","וְכַאֲשֶׁר בִּעֲרוּ אֵשׁ בְּתוֹךְ הֶחָצֵר וּבְשִׁבְתָּם יַחְדָּו וַיֵּשֶׁב גַּם־פֶּטְרוֹס בְּתוֹכָם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","וַתֵּרֶא אֹתוֹ שִׁפְחָה אַחַת יֹשֵׁב נֶגֶד הָאוֹר וַתֶּחֱזֶה־בּוֹ וַתֹּאמֶר גַּם־זֶה הָיָה עִמּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","וַיֵכַחֵשׁ־בּוֹ וַיֹּאמַר אִשָּׁה לֹא יָדַעְתִּי אֹתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","וְעוֹד־מְעַט וַיִּרְאֵהוּ אִישׁ אַחֵר וַיֹּאמַר גַּם־אַתָּה אֶחָד מֵהֶם וַיַּעַן פֶּטְרוֹס בֶּן־אָדָם לֹא מֵהֶם אָנֹכִי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","וּכְשָׁעָה אַחַת אַחֲרֵי־כֵן עָנָה אִישׁ וְהוֹכִיחַ עָלָיו לֵאמֹר אָכֵן גַּם־זֶה הָיָה עִמּוֹ כִּי הוּא גְּלִילִי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","וַיֹּאמֶר פֶּטְרוֹס בֶּן־אָדָם אֵינֶנִּי יֹדֵעַ מָה אַתָּה מְדַבֵּר וְעוֹד דְּבָרוֹ בְּפִיו וּפִתְאֹם קָרָא הַתַּרְנְגֹל׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","וַיִּפֶן הָאָדוֹן וַיֶּחֱזֶה בִּפְנֵי פֶטְרוֹס וַיִּזְכֹּר פֶּטְרוֹס אֶת־דְּבַר הָאָדוֹן אֲשֶׁר דִּבֶּר לוֹ כִּי־בְטֶרֶם יִקְרָא הַתַּרְנְגֹל הַיּוֹם תְּכַחֵשׁ־בִּי שָׁלֹשׁ פְּעָמִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","וַיֵּצֵא הַחוּצָה וַיְמָרֵר בַּבֶּכִי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","וְהָאֲנָשִׁים הַתֹּפְשִׂים אֶת־יֵשׁוּעַ הִכּוּ אֹתוֹ וְהִתְעַלְּלוּ־בוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","חָפוּ אֶת־פָּנָיו וְשָׁאֹל לוֹ לֵאמֹר הִנָּבֵא לָנוּ מִי הוּא הַמַּכֶּה אֹתָךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","וְעוֹד הוֹסִיפוּ דְבָרִים כָּאֵלֶּה לְנָאֵץ אֹתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","וּכְאוֹר הַבֹּקֶר נִקְהֲלוּ זִקְנֵי הָעָם רָאשֵׁי הַכֹּהֲנִים וְהַסּוֹפְרִים וַיְבִיאֻהוּ לִפְנֵי הַסַּנְהֶדְרִין לֵאמֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","הַאִם אַתָּה הוּא הַמָּשִׁיחַ הַגֶּד־לָנוּ וַיֹּאמֶר אֲלֵיהֶם אִם אַגִּיד לָכֶם לֹא תַאֲמִינוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","וְגַם אִם־אֶשְׁאַל לֹא תַעֲנוּ וְלֹא תְשַׁלְּחוּנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","הִנֵּה מֵעַתָּה עֹלֶה בֶן־הָאָדָם לָשֶׁבֶת לִימִין גְּבוּרַת הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","וַיֹּאמְרוּ כֻלָּם הֲכִי־אַתָּה הוּא בֶּן־הָאֱלֹהִים וַיֹּאמֶר אֲלֵיהֶם אַתֶּם אֹמְרִים כִּי־אֲנִי הוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","וַיֹּאמְרוּ מַה־לָּנוּ וּלְעֵדוּת עוֹד הֲלֹא שָׁמַעְנוּ עֵדוּת פִּיהוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","וַיָּקוּמוּ כָל־הַקָּהָל שָׁם וַיֹּלִיכֻהוּ אֶל־פִּילָטוֹס׃ ");
INSERT INTO hebsg_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","וַיָּחֵלּוּ לְשִׂטְנוֹ לֵאמֹר מָצָאנוּ אֶת־הָאִישׁ הַזֶה מְסַלֵּף אֶת־עַמֵּנוּ וּמַשְׁגֶּה אֹתָם מִתֵּת מַס לַקֵּיסַר בְּאָמְרוֹ כִּי הוּא הַמֶּלֶךְ הַמָּשִׁיחַ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","וַיִּשְׁאַל אֹתוֹ פִילָטוֹס לֵאמֹר הַאַתָּה מֶלֶךְ הַיְּהוּדִים וַיַּעַן אֹתוֹ וַיֹּאמֶר אַתָּה אָמָרְתָּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","וַיֹּאמֶר פִּילָטוֹס אֶל־רָאשֵׁי הַכֹּהֲנִים וְאֶל־הֲמוֹן הָעָם אֲנִי לֹא מָצָאתִי עָוֹן בָּאִישׁ הַזֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","אַךְ הֵם הוֹסִיפוּ בְּיֶתֶר עֹז לֵאמֹר כִּי מַדִּיחַ הוּא אֶת־הָעָם בְּתוֹרָתוֹ בְּכָל־יְהוּדָה הָחֵל בַּגָּלִיל וְעַד־הֵנָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","וְכִשְׁמוֹעַ פִּילָטוֹס אֶת־שֵׁם הַגָּלִיל וַיִּשְׁאַל אִם־הָאִישׁ הוּא גְּלִילִי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","וְכַאֲשֶׁר יָדַע כִּי־לְמֶמְשֶׁלֶת הוֹרודוֹס יֵחָשֵׁב וַיִּשְׁלָחֵהוּ אֶל־הוֹרְדוֹס אֲשֶׁר גַּם־הוּא יָשַׁב בִּירוּשָׁלַיִם בַּיָּמִים הָהֵם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","וַיְהִי כִּרְאוֹת הוֹרְדוֹס אֶת־יֵשׁוּעַ וַיִשְׂמַח מְאֹד כִּי נִכְסַף לִרְאוֹתוֹ מִיָּמִים רַבִּים כַּאֲשֶׁר שָׁמַע אֶת־שָׁמְעוֹ וַיְקַו כִּי יַעֲשֶׂה אוֹת לְעֵינָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","וַיִּשְׁאָלֵהוּ שְׁאֵלוֹת שֹׁנוֹת אַךְ הוּא לֹא־עָנָהוּ דָּבָר׃ ");
INSERT INTO hebsg_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","וַיָּקוּמוּ רָאשֵׁי הַכֹּהֲנִים וְהַסּוֹפְרִים וַיֹּסִיפוּ לְשִׂטְנוֹ בְּכָל־מַאֲמַצֵּי כֹחָם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","וַיִּבֶז אֹתוֹ הוֹרְדוֹס וְחֵיל צְבָאוֹ וַיַּלְבֵּשׁ אֹתוֹ מְעִיל אַרְגָּמָן לְהָתֶל־בּוֹ וַיִּשְׁלָחֵהוּ אֶל־פִּילָטוֹס׃ ");
INSERT INTO hebsg_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","בַּיּוֹם הַהוּא הִתְרַצּוּ הוֹרְדוֹס וּפִילָטוֹס אִישׁ אֶל־אָחִיו כִּי עַד־כֹּה הָיְתָה מַשְׂטֵמָה בֵּינֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","וַיִּקְרָא פִילָטוֹס אֶל־רָאשֵׁי הַכֹּהֲנִים וְהַשָּׂרִים וְהָעָם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","וַיֹּאמֶר אֲלֵיהֶם הֲבֵאתֶם אֵלַי אֶת־הָאִישׁ הַזֶּה כִּמְסַלֵּף אֶת־הָעָם וְהִנֵּה חֲקַרְתִּיו לְעֵינֵיכֶם וְלֹא־מָצָאתִי בָאִישׁ הַזֶּה שֶׁמֶץ דָּבָר מִכֹּל אֲשֶׁר תַּרְשִׁיעוּ אֹתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","וְאַף לֹא הוֹרְדוֹס כִּי הוּא הֱשִׁיבוֹ אֵלֵינוּ מִבְּלִי מְצֹא בוֹ חֵטְא מִשְׁפַּט־מָוֶת׃ ");
INSERT INTO hebsg_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","עַל־כֵּן יַסֹּר אֲיַסְּרֶנּוּ וְאַחֲרֵי כֵן אֲשַׁלַּח אֹתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","וְעָלָיו לְשַׁלַּח לָהֶם אֶחָד מֵהָאֲסִירִים חָפְשִׁי בִּימֵי הֶחָג׃ ");
INSERT INTO hebsg_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","אַךְ הֵם קָרְאוּ יַחְדָּו לֵאמֹר אֱסֹף אֶת־הָאִישׁ הַזֶּה וְשַׁלַּח לָנוּ אֶת־בַּר־אַבָּא׃ ");
INSERT INTO hebsg_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","הוּא אֲשֶׁר עָצוּר הָיָה בַּכֶּלֶא בַּעֲבוּר מֶרֶד אֲשֶׁר־נִמְצָא בָּעִיר וָרֶצַח׃ ");
INSERT INTO hebsg_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","וַיּוֹסֶף פִּילָטוֹס וַיְדַבֵּר אֲלֵיהֶם כִּי־חָפֵץ לְשַׁלַּח אֶת־יֵשׁוּעַ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","וְהֵם צָעֲקוּ לֵאמֹר הַצְלֵב הַצְלֵב אֹתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","וַיְדַבֵּר אֲלֵיהֶם שְׁלִישִׁית וְלָמָּה מֶה רָעָה עָשָׂה זֶה לֹא־מָצָאתִי לוֹ מִשְׁפַּט־מָוֶת עַל־כֵּן אֲיַסְּרֶנּוּ וַאֲשַׁלְּחֶנּוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","אַךְ הֵם הֵרִימוּ קוֹלָם וַיִּשְׁאָלוּ וַיִּפְצְרוּ־בוֹ כִּי יִצָּלֵב וַיַּכְרַע קוֹלָם וְקוֹל רָאשֵׁי הַכֹּהֲנִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","וּפִילָטוֹס הוֹצִיא מִשְׁפָּט כִּי תֵעָשֶׂה שֶׁאֱלָתָם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","וַיְשַׁלַּח לָהֶם אֶת־הֶעָצוּר בַּכֶּלֶא בַּעֲבוּר מֶרֶד וָרֶצַח אֶת־הָאִישׁ אֲשֶׁר שָׁאָלוּ וְאֶת־יֵשׁוּעַ נָתַן לִרְצוֹנָם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","וַיּוֹלִיכֻהוּ מִשָּׁם וַיַּחֲזִיקוּ בְאִישׁ אֶחָד אֲשֶׁר בָּא מִן־הַשָּׂדֶה וּשְׁמוֹ שִׁמְעוֹן אִישׁ־קוּרִינִי וַיָּשִׂימוּ עָלָיו אֶת־הַצְּלָב לָשֵׂאת אֹתוֹ אַחֲרֵי יֵשׁוּעַ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","וַהֲמוֹן עַם־רָב הָלְכוּ אַחֲרָיו וַהֲמוֹן נָשִׁים נֹשְׂאוֹת עָלָיו מִסְפֵּד וְקִינָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","וַיִּפֶן יֵשׁוּעַ אֲלֵיהֶן וַיֹּאמַר בְּנוֹת יְרוּשָׁלַיִם אַל־תִּבְכֶּינָה לִּי כִּי אִם־בְּכֶינָה לָכֶן וְלִבְנֵיכֶן׃ ");
INSERT INTO hebsg_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","כִּי הִנֵּה יָמִים בָּאִים וְיֹאמְרוּ אַשְׁרֵי הָעֲקָרוֹת וְהַבֶּטֶן אֲשֶׁר לֹא יָלָדָה וְהַשָּׁדַיִם אֲשֶׁר לֹא הֵינִיקוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","אָז יָחֵלּוּ לֵאמֹר לֶהָרִים נִפְלוּ עָלֵינוּ וְלַגְּבָעוֹת כַּסּוּנוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","כִּי אִם־כָּכָה יַעֲשׂוּ בְּעֵץ לָח מַה־יֵּעָשֶׂה בְּעֵץ יָבֵשׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","וְגַם־שְׁנַיִם אֲחֵרִים פֹּעֲלֵי אָוֶן הוּבָלוּ אִתּוֹ לַמָּוֶת׃ ");
INSERT INTO hebsg_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","וַיָּבֹאוּ אֶל־הַמָּקוֹם הַנִּקְרָא גֻּלְגָּלְתָּא וַיִּצְלְבוּ אֹתוֹ שָׁם וְאֶת־פֹּעֲלֵי הָאָוֶן אֶחָד לִימִינוֹ וְאֶחָד לִשְׂמֹאלוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","וַיֹּאמֶר יֵשׁוּעַ אָבִי סְלַח לָהֶם כִּי אֵינָם יֹדְעִים מָה הֵמָּה עֹשִׂים וַיְחַלְּקוּ לָהֶם אֶת־בְּגָדָיו וַיַּפִּילוּ עֲלֵיהֶם גּוֹרָל׃ ");
INSERT INTO hebsg_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","וְהָעָם עָמְדוּ הִבִּיטוּ בוֹ וְגַם־הַשָּׂרִים לָעֲגוּ־לוֹ לֵאמֹר אֶת־אֲחֵרִים הוֹשִׁיעַ יוֹשַׁע־נָא אֶת־נַפְשׁוֹ אִם־הוּא הַמָּשִׁיחַ בְּחִיר הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","וְכֵן גַּם־אַנְשֵׁי הַצָּבָא שָׂחֲקוּ עָלָיו וַיָּבֹאוּ וַיַּגִּישׁוּ לוֹ חֹמֶץ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","וַיֹּאמְרוּ אִם־אַתָּה הוּא מֶלֶךְ הַיְּהוּדִים הוֹשַׁע אֶת־נַפְשֶׁךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","וַיָּשִׂימוּ כְתֹבֶת מִמַּעַל לוֹ בִּכְתָב יְוָנִי וְרוֹמִי וְעִבְרִי זֶה הוּא מֶלֶךְ הַיְּהוּדִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","וְאֶחָד מִפֹּעֲלֵי הָאָוֶן הַנִּתְלִים אֶצְלוֹ חֵרֵף אֹתוֹ לֵאמֹר הֲלֹא אַתָּה הַמָּשִׁיחַ הוֹשַׁע אֶת־נַפְשְׁךָ וְאֶת־נַפְשֵׁנוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","וַיַּעַן הָאַחֵר וַיִּגְעַר־בּוֹ לֵאמֹר הַאִם לֹא תִירָא אֶת־הָאֱלֹהִים אַחֲרֵי אֲשֶׁר־הָעֹנֶשׁ הַזֶּה הוּשַׁת גַּם־עָלֶיךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","אָכֵן עָלֵינוּ הוּשַׁת כַּמִּשְׁפָּט כִּי כְּמַעֲשֵׂה יָדֵינוּ הוּשַׁב לָנוּ אַךְ זֶה לֹא־עָשָׂה דָבָר רָע׃ ");
INSERT INTO hebsg_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","וַיֹּאמַר אֶל־יֵשׁוּעַ זָכְרֵנִי־נָא אֲדֹנִי כַּאֲשֶׁר תָּבֹא בְּמַלְכוּתֶךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","וַיֹּאמֶר יֵשׁוּעַ אֵלָיו אָמֵן אֲנִי אֹמֵר לְךָ הַיּוֹם תִּהְיֶה עִמִּי בְּגַן־עֵדֶן׃ ");
INSERT INTO hebsg_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","וַיְהִי כְּשָׁעָה הַשִּׁשִּׁית וְחֹשֶׁךְ כִּסָּה אֶת־פְּנֵי כָל־הָאָרֶץ עַד הַשָּׁעָה הַתְּשִׁיעִית׃ ");
INSERT INTO hebsg_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","הַשֶּׁמֶשׁ חָשָׁכָה וּפָרֹכֶת הַהֵיכַל נִקְרְעָה לִשְׁנַיִם קְרָעִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","וַיִּקְרָא יֵשׁוּעַ בְּקוֹל גָּדוֹל וַיֹּאמַר בְּיָדְךָ אָבִי אַפְקִיד רוּחִי וּכְקָרְאוֹ כָזֹאת הוֹצִיא אֶת־נִשְׁמָתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","וְשַׂר־הַמֵּאָה רָאָה אֵת אֲשֶׁר נַעֲשָׂה וַיִּתֵּן כָּבוֹד לֵאלֹהִים לֵאמֹר אָכֵן צַדִּיק הָיָה הָאִישׁ הַזֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","וְכָל־הֲמוֹן הָעָם אֲשֶׁר נִקְהֲלוּ לַמַּרְאֶה הַזֶּה אַחֲרֵי אֲשֶׁר רָאוּ אֵת אֲשֶׁר נַעֲשָׂה סָפְקוּ עַל־לִבָּם וַיָּשׁוּבוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","וְכָל־מְיֻדָּעָיו עָמְדוּ מֵרָחוֹק וְהַנָּשִׁים אֲשֶׁר הָלְכוּ אַחֲרָיו מִן־הַגָּלִיל רָאוּ אֶת־אֵלֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","וַיְהִי אִישׁ אֶחָד וּשְׁמוֹ יוֹסֵף אִישׁ טוֹב וְצַדִּיק מִן־יֹעֲצֵי הַמְּדִינָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","אֲשֶׁר לֹא נָטָה אַחֲרֵי עֲצָתָם וּמַעֲשֵׂיהֶם וְהוּא מִן־הָרָמָתַיִם עִיר־הַיְּהוּדִים וּמְחַכֶּה לְמַלְכוּת הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","הוּא בָא לִפְנֵי פִילָטוֹס וַיִּשְׁאַל מִמֶּנּוּ אֶת־גּוּפַת יֵשׁוּעַ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","וַיֹּרֶד אֹתוֹ וַיַּעֲטֵהוּ בְּתַכְרִיךְ־בַּד וַיִשִׂימֵהוּ בְּקֶבֶר חָצוּב בְּצוּר אֲשֶׁר עוֹד לֹא נִקְבַּר־בּוֹ אָדָם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","וְיוֹם עֶרֶב שַׁבָּת הָיָה וְהַשַּׁבַּת קָרַב וָבָא׃ ");
INSERT INTO hebsg_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","וְהַנָּשִׁים אֲשֶׁר בָּאוּ עִמּוֹ מִן־הַגָּלִיל הָלְכוּ אַחֲרָיו וַתִּרְאֶינָה אֶת־הַקֶּבֶר כַּאֲשֶׁר הוּשַׂם־בּוֹ גּוּפַת יֵשׁוּעַ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","וְאַחֲרֵי־כֵן שָׁבוּ וְהֵכִינוּ בְּשָׂמִים וּזְנִים מְרֻקָּחִים וּבַשַׁבָּת שָׁבְתוּ כַּמִּצְוָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","וּבָאֶחָד בַּשַּׁבָּת טֶרֶם יִבָּקַע הַשַּׁחַר בָּאוּ אֶל־הַקָּבֶר וְהֵבִיאוּ אֶת־הַבְּשָׂמִים אֲשֶׁר הֵכִינוּ וְעִמָּהֶן עוֹד אֲחֵרוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","וְהִנֵּה מָצְאוּ אֶת־הָאֶבֶן גְּלוּלָה מִן־הַקָּבֶר׃ ");
INSERT INTO hebsg_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","וַתָּבֹאנָה אֶל־תּוֹכוֹ אַךְ אֶת־גּוּפַת הָאָדוֹן יֵשׁוּעַ לֹא מָצָאוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","וְכַאֲשֶׁר נָבֹכוּ עַל־הַדָּבָר הַזֶּה וְהִנֵּה שְׁנֵי אֲנָשִׁים בִּבְרַק זֹהַר בִּגְדֵיהֶם נִצָּבִים עֲלֵיהֶן׃ ");
INSERT INTO hebsg_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","וְיִרְאָה אָחֲזָה אֹתָן וּפְנֵיהֶן שַׁחוּ אָרְצָה וְהֵם אַמְרוּ אֲלֵיהֶן לָמָּה־זֶּה תְּבַקֵּשְׁנָה אֶת־הַחַי בֵּין הַמֵּתִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","הוּא אֵינֶנּוּ פֹה כִּי קָם מִן־הַמֵּתִים זְכֹרְנָה אֵת אֲשֶׁר־דִּבֶּר אֲלֵיכֶן בְּעוֹד הֱיוֹתוֹ בַגָּלִיל לֵאמֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","כִּי נָכוֹן לְבֶן־הָאָדָם לְהִנָּתֵן בִּידֵי אֲנָשִׁים חַטָּאִים וּלְהִצָּלֵב וּבָיּוֹם הַשְּׁלִישִׁי יָקוּם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","אָז זָכְרוּ אֶת־דְּבָרָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","שָׁבוּ מִן־הַקֶּבֶר וַתַּגֵּדְנָה אֵת כָּל־הַדְּבָרִים הָאֵלֶּה לְאַחַד הֶעָשָׂר וּלְכָל־זוּלָתָם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","וְאֵלֶּה הֵן אֲשֶׁר אָמְרוּ אֶת־הַדְּבָרִים הָאֵלֶּה אֶל־הַשְּׁלִיחִים מִרְיָם הַמַּגְדָּלִית וְיוֹחָנָה וּמִרְיָם אֵם יַעֲקֹב וְעוֹד נָשִׁים אֲחֵרוֹת עִמָּהֶן׃ ");
INSERT INTO hebsg_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","אַךְ הַדְּבָרִים הָאֵלֶּה הָיוּ בְעֵינֵיהֶם כְּדִבְרֵי־תָפֵל וְלֹא הֶאֱמִינוּ לָהֶן׃ ");
INSERT INTO hebsg_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","וַיָּקָם פֶּטְרוֹס וַיָּרָץ אֶל־הַקֶּבֶר וַיִּשַּׁח לִרְאוֹת אֶל־תּוֹכוֹ וְלֹא־רָאָה כִי אִם־הַתַּכְרִיכִים לְבַדָּם וַיָשָׁב לְבֵיתוֹ מִשְׁתָּאֶה עַל־אֲשֶׁר נַעֲשָׂה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","בַּיּוֹם הַהוּא הָלְכוּ שְׁנַיִם מֵהֶם אֶל־הַכְּפָר הַנִּקְרָא עַמָּאוּס הַרְחֵק כְּשִׁישִּׁים מַעֲנוֹת צֶמֶד שָׂדֶה מִן־יְרוּשָׁלָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","וְהֵמָּה נִדְבְּרוּ אִישׁ אֶל־רֵעֵהוּ עַל כָּל־הַקֹרֹת הָאֵלֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","וַיְהִי כַּאֲשֶׁר שָׁאֲלוּ וְחָקְרוּ בַּדָּבָר וַיִּגַּשׁ גַּם־יֵשׁוּעַ וַיֵּלֶךְ עִמָּהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","וְהֵם לֹא הִכִּירֻהוּ כִּי טַחוּ עֵינֵיהֶם מֵרְאוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","וַיֹּאמֶר אֲלֵיהֶם מָה הַדְּבָרִים הָאֵלֶּה אֲשֶׁר אַתֶּם מְדַבְּרִים אִישׁ אֶל־רֵעֵהוּ פֹּה עֲלֵי־אֹרַח וַיַּעַמְדוּ וּפְנֵיהֶם זֹעֲפִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","וְאֶחָד מֵהֶם וּשְׁמוֹ קְלֵיוֹפָס עָנָה וְאָמָר הַאַתָּה הוּא לְבַדְּךָ אֹרֵחַ בִּירוּשָׁלַיִם מִבְּלִי־דַעַת אֶת־הַמַּעֲשִׂים אֲשֶׁר נַעֲשׂוּ בְתוֹכָהּ בַּיָּמִים הָאֵלֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","וַיֹּאמֶר אֲלֵיהֶם וּמָה הֵמָּה הַמַּעֲשִׂים וַיֹּאמְרוּ אֵלָיו עַל־אֹדוֹת יֵשׁוּעַ הַנָּצְרִי אֲשֶׁר הָיָה נָבִיא גִּבּוֹר חַיִל לִפְנֵי הָאֱלֹהִים וְלִפְנֵי כָל־הָעָם גַּם־בְּמַעֲשָׂיו וְגַם־בִּדְבָרָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","אֲשֶׁר הִסְגִּירֻהוּ רָאשֵׁי כֹהֲנֵינוּ וְשָׂרֵינוּ לְמִשְׁפַּט־מָוֶת וַיִּצְלְבוּ אֹתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","וַאֲנַחְנוּ חִכִּינוּ כִּי־זֶה הוּא אֲשֶׁר יִפְדֶּה אֶת־יִשְׂרָאֵל וְהַיּוֹם הַזֶּה יוֹם שְׁלִישִׁי הוּא מֵעֵת נַעֲשׂוּ אֵלֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","וְגַם־נָשִׁים מִקִּרְבֵּנוּ הִבְהִילוּ אֹתָנוּ כִּי־הִשְׁכִּימוּ לָבֹא אֶל־הַקֶּבֶר בַּבֹּקֶר׃ ");
INSERT INTO hebsg_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","וְלֹא מַצְאוּ אֶת־גְּוִיָּתוֹ וַתָּבֹאנָה וַתֹּאמַרְנָה כִּי חָזוּ מַלְאָכִים בַּמַּחֲזֶה אֲשֶׁר אָמְרוּ כִּי־הוּא חָי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","וַאֲנָשִׁים מִשֶּׁלָּנוּ הָלְכוּ אֶל־הַקָּבֶר וַיִּמְצְאוּ כֵן כַּאֲשֶׁר הִגִּידוּ הַנָּשִׁים אַךְ אֹתוֹ לֹא רָאוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","וַיֹּאמֶר אֲלֵיהֶם הוֹי חַסְרִי תְבוּנָה וּקְשֵׁי לֵב מֵהַאֲמִין בְּכָל־אֲשֶׁר־דִּבְּרוּ הָנְּבִיאִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","הַאִם לֹא־נָכוֹן הָיָה לַמָּשִׁיחַ לָשֵׂאת אֶת־עָנְיוֹ וְלָבֹא אֶל־כְּבוֹדוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","וַיּוֹאֶל לְבָאֵר לָהֶם כָּל־הַכְּתוּבִים הָחֵל מִמּשֶׁה וְעַד כָּל־הַנְּבִיאִים אֲשֶׁר דִּבְּרוּ עָלָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","וַיִּקְרְבוּ אֶל־הַכְּפָר אֲשֶׁר פְּנֵיהֶם הָיוּ מֻעֲדוֹת לָלֶכֶת שָׁמָּה וְהוּא נָטָה פָנָיו כְּהֹלֵךְ לוֹ מִזֶּה וָהָלְאָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","וַיִּפְצְרוּ־בוֹ לֵאמֹר שֶׁב־נָא פֹּה אִתָּנוּ כִּי־הָעֶרֶב הִגִּיעַ וְכִי־פָנָה הַיּוֹם וַיָּבֹא הַבַּיְתָה לָשֶׁבֶת אִתָּם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","וַיְהִי בְּשִׁיבְתּוֹ אִתָּם אֶל־הַשֻּׁלְחָן וַיִּקַּח אֶת־הַלָּחֶם וַיְבָרֶךְ וַיִּבְצַע וַיִּתֵּן לָהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","אָז נִפְקְחוּ עֵינֵיהֶם וַיַּכִּירוּ אֹתוֹ וְהוּא חָמַק עָבַר מִפְּנֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","וַיֹּאמְרוּ אִישׁ אֶל־אָחִיו הַאִם לִבֵּנוּ לֹא הָיָה בֹעֵר בְּקִרְבֵּנוּ כְּדַבְּרוֹ אֵלֵינוּ בַּדָּרֶךְ וּכְבָאֲרוֹ לָנוּ אֶת־הַכְּתוּבִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","וַיָּקוּמוּ בָעֵת הַהִיא וַיָּשׁוּבוּ יְרוּשָׁלָיְמָה וַיִּמְצְאוּ אֶת־אַחַד הֶעָשָׂר וְאֶת־אֲשֶׁר אִתָּם נִקְהָלִים יַחְדָּו׃ ");
INSERT INTO hebsg_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","וְאֹמְרִים כִּי קָם הָאָדוֹן אֶל־נָכוֹן וְכִי נִרְאָה אֶל־שִׁמְעוֹן׃ ");
INSERT INTO hebsg_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","וַיְסַפְּרוּ גַּם־הֵם אֵת אֲשֶׁר קָרָה לָהֶם בַּדָּרֶךְ וְכִי הִכִּירֻהוּ כַּאֲשֶׁר בָּצַע אֶת־הַלָּחֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","עוֹד הֵם מְדַבְּרִים כָּאֵלֶּה וְהִנֵּה הוּא יֵשׁוּעַ עֹמֵד בְּתוֹכָם וַיֹּאמֶר אֲלֵיהֶם שָׁלוֹם עֲלֵכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","וְהֵמָּה חַתּוּ נִבְהָלוּ וַיַּחְשְׁבוּ כִי־רָאוּ רוּחַ׃ ");
INSERT INTO hebsg_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","וַיֹּאמֶר אֲלֵיהֶם לָמָּה־זֶּה מְפַחֲדִים אַתֶּם וְלָמָּה תַּעֲלֶינָה מַחֲשָׁבוֹת בִּלְבַבְכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","רְאוּ אֶת־יָדַי וְאֶת־רַגְלַי כִּי אֲנִי אֲנִי הוּא מִשְׁשׁוּנִי וּרְאוּ כִּי רוּחַ אֵין לוֹ בָּשָׂר וַעֲצָמוֹת כַּאֲשֶׁר אַתֶּם רֹאִים בִּי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","וְאַחֲרֵי אָמְרוֹ כָזֹאת הֶרְאָה אֹתָם אֶת־יָדָיו וְאֶת־רַגְלָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","וּבְעוֹד לֹא הֶאֱמִינוּ מִשִּׂמְחָה וּמִתִּמְהוֹן לֵבָב וַיֹּאמֶר אֲלֵיהֶם הֲיֵשׁ־לָכֶם פֹּה אֹכֶל׃ ");
INSERT INTO hebsg_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","וַיִּתְּנוּ לוֹ מִקְצַת דָּג צִלִי־אֵשׁ וּמִנֹפֶת צוּפִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","וַיִּקַּח וַיֹּאכַל לְעֵינֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","וַיֹּאמֶר אֲלֵיהֶם אֵלֶּה דְּבָרַי אֲשֶׁר דִּבַּרְתִּי אֲלֵיכֶם בְּעוֹד הָיִיתִי עִמָּכֶם כִּי הִמָּלֵא יִמָּלֵא כָל־הַכָּתוּב עָלַי בְּתוֹרַת משֶׁה וּבַנְּבִיאִים וּבְמִזְמוֹרֵי תְהִלִּים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","אָז פָּתַח אֶת־לְבָבָם לְהַשְׂכִּיל אֶת־הַכְּתוּבִים׃ ");
INSERT INTO hebsg_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","וַיֹּאמֶר אֲלֵיהֶם כֵּן כָּתוּב עַל־עֻנּוֹת הַמָּשִׁיחַ וְעַל־תְּקוּמָתוֹ מִן־הַמֵּתִים בַּיּוֹם הַשְּׁלִישִׁי׃ ");
INSERT INTO hebsg_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","וְכִי בִשְׁמוֹ יִקְרְאוּ הַקֹּרְאִים לִתְשׁוּבָה וְלִסְלִיחַת עָוֹן בְּכָל־הַגּוֹיִם הָחֵל מִן־יְרוּשָׁלָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","וְאַתֶּם עֵדִים עַל־אֵלֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","הִנֵּה אָנֹכִי שֹׁלֵחַ אֵת אֲשֶׁר הִבְטִיחַ לָכֶם אָבִי וְאַתֶּם הוֹחִילוּ בָּעִיר יְרוּשָׁלַיִם עַד כִּי־תִלְבְּשׁוּ עֹז מִמָּרוֹם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","וַיּוֹצִיאֵם אֶל־מִחוּץ לָעִיר עַד־בֵּית עַנְיָה וַיִּשָּׂא אֶת־יָדָיו וַיְבָרְכֵם׃ ");
INSERT INTO hebsg_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","וַיְהִי בְּבָרְכוֹ אֹתָם וַיִּפָּרֵד מֵהֶם וַיִּנָּשֵׂא הַשָּׁמָיְמָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","וְהֵם הִשְׁתַּחֲווּ־לוֹ וַיָּשׁוּבוּ לִירוּשָׁלַיִם בְּשִׂמְחָה גְדוֹלָה׃ ");
INSERT INTO hebsg_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","וַיִּהְיוּ בַהֵיכָל מְהַלֲלִים וּמְבָרְכִים אֶת־הָאֱלֹהִים תָּמִיד אָמֵן׃ ");
INSERT INTO hebsg_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","בְּרֵאשִׁית הָיָה הַדָּבָר וְהַדָּבָר הָיָה אֶת־הָאֱלֹהִים וְהוּא הַדָּבָר הָיָה אֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","הוּא הָיָה מֵרֹאשׁ אֶת־הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","כָּל־הַמַּעֲשִׂים נִהְיוּ עַל־יָדוֹ וְאֵין דָּבָר אֲשֶׁר נַעֲשָׂה מִבַּלְעָדָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","בּוֹ נִמְצָא חַיִּים וְהַחַיִּים הֵם אוֹר הָאָדָם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","וְהָאוֹר זֹרֵחַ בַּחֹשֶׁךְ וְהַחֹשֶׁךְ לֹא יְכִילֶנּוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","אִישׁ הָיָה בָאָרֶץ יוֹחָנָן שְׁמוֹ אֲשֶׁר שְׁלָחוֹ אֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","הוּא בָא לְעֵדוּת לְהָעִיד עַל־הָאוֹר לְמַעַן יַאֲמִינוּ כֻלָּם עַל־יָדוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","וְלֹא הוּא הָיָה הָאוֹר כִּי אִם־בָּא לְהָעִיד עַל־הָאוֹר הַהוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","הוּא אוֹר אֱמֶת אֲשֶׁר בָּא לָעוֹלָם לְהָאִיר לְכָל־אָדָם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","הוּא הָיָה בָעוֹלָם וְהָעוֹלָם נִהְיָה עַל־יָדוֹ וְהָעוֹלָם אֹתוֹ לֹא יָדָע׃ ");
INSERT INTO hebsg_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","הוּא בָא אֶל־עַמּוֹ שֶׁלּוֹ וְעַמּוֹ שֶׁלּוֹ לֹא הֶחֱזִיקוּ־בוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","וְאֵלֶּה אֲשֶׁר הֶחֱזִיקוּ־בוֹ נָתַן־כֹּחַ בְּיָדָם לִהְיוֹת בָּנִים לֵאלֹהִים הֲלֹא הֵם הַמַּאֲמִינִים בִּשְׁמוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","אֲשֶׁר לֵדָתָם לֹא מִדָּם וְלֹא מִתַּאֲוַת בָּשָׂר וְלֹא מֵרוּחַ גָּבֶר כִּי אִם־מֵאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","וְהַדָּבָר לָבַשׁ בָּשָׂר וַיִּשְׁכֹּן בְּתוֹכֵנוּ וְאֶת־כְּבוֹדוֹ רָאִינוּ כִּכְבוֹד בֵּן יָחִיד לְאָבִיו מָלֵא חֶסֶד וֶאֱמֶת׃ ");
INSERT INTO hebsg_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","וְיוֹחָנָן הֵעִיד עָלָיו וַיִּקְרָא לֵאמֹר זֶה הוּא אֲשֶׁר אָמַרְתִּי עָלָיו כִּי הוּא בָא אַחֲרַי וְהִנֵּה הוּא לְפָנָי כִּי רִאשׁוֹן־לִי הָיָה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","כִּי מִמְּלֹאוֹ נָשָׂאנוּ כֻלָּנוּ חֶסֶד עַל־חָסֶד׃ ");
INSERT INTO hebsg_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","כִּי הַתּוֹרָה נְתוּנָה בְּיַד־מֹשֶׁה וְחֶסֶד וֶאֱמֶת מִמְּקוֹר יֵשׁוּעַ הַמָּשִׁיח יָצָאוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","אֵת הָאֱלֹהִים לֹא־רָאָה אָדָם מֵעוֹלָם וְהַבֵּן הַיָּחִיד בְּחֵיק הָאָב הוּא הִגִּיד תְּכוּנָתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","וְזֹאת עֵדוּת יוֹחָנָן בִּשְׁלֹחַ הַיְּהוּדִים כֹּהֲנִים וּלְוִיִּם מִירוּשָׁלַיִם לִשְׁאֹל אֹתוֹ מִי הוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","וְהוּא הוֹדָה וְלֹא כִחֵד כִּי הִגִּיד לֵאמֹר אָנֹכִי אֵינֶנִּי הַמָּשִׁיחַ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","וַיִּשְׁאֲלוּ אֹתוֹ מִי אֵפוֹא אָתָּה הַאַתָּה אֵלִיָּהוּ וַיֹּאמֶר אֵינֶנִּי אֵלִיָּהוּ הַאִם הַנָּבִיא אַתָּה וַיַּעַן לֹא׃ ");
INSERT INTO hebsg_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","וַיֹּאמְרוּ אֵלָיו וּמִי אֵפוֹא אָתָּה כִּי עָלֵינוּ לְהָשִׁיב דָּבָר אֶת־שֹׁלְחֵינוּ מָה־תֹּאמַר עַל־נַפְשֶׁךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","וַיֹּאמַר אָנֹכִי קוֹל קוֹרֵא בַּמִּדְבָּר פַּנּוּ דֶּרֶךְ יְהוָֹה כַּאֲשֶׁר דִּבֶּר יְשַׁעְיָהוּ הַנָּבִיא׃ ");
INSERT INTO hebsg_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","וְהַשְּׁלוּחִים הָאֵלֶּה הָיוּ מִן־הַפְּרוּשִׁים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","וַיִּשְׁאֲלוּ וַיֹּאמְרוּ אֵלָיו אִם־אֵינְךָ הַמָּשִׁיחַ וְלֹא אֵלִיָּהוּ וְלֹא הַנָּבִיא לָמָּה־זֶּה מְטַבֵּל הִנֶּךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","וַיַּעַן אֹתָם יוֹחָנָן וַיֹּאמַר אָנֹכִי מְטַבֵּל בַּמָּיִם אַךְ אִישׁ עֹמֵד בְּתוֹכְכֶם אֲשֶׁר לֹא יְדַעְתֶּם אֹתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","זֶה הַבָּא אַחֲרָי אֲשֶׁר הָיָה לְפָנָי וַאֲנִי קַלֹּתִי מֵהַתֶּר־לוֹ שְׂרוֹךְ נְעָלָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","זֹאת הָיְתָה בְּבֵית הָעֲרָבָה מֵעֵבֶר לַיַּרְדֵּן אֲשֶׁר יוֹחָנָן הָיָה מְטַבֵּל שָׁמָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","וַיְהִי מִמָּחֳרָת וַיַּרְא אֶת־יֵשׁוּעַ בָּא אֵלָיו וַיֹּאמַר הִנֵּה שֵׂה הָאֱלֹהִים הַנֹּשֵׂא אֶת־חַטַּאת הָעוֹלָם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","וְהוּא אֲשֶׁר אָמַרְתִּי עָלָיו הִנֵּה אִישׁ בָּא אַחֲרַי וְהִנֵּה הוּא לְפָנָי כִּי רִאשׁוֹן־לִי הָיָה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","וַאֲנִי לֹא יָדַעְתִּי אֹתוֹ אַךְ לְמַעַן יִגָּלֶה לְיִשְׂרָאֵל בָּאתִי אֲנִי לְטַבֵּל בַּמָּיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","וַיָּעַד יוֹחָנָן לֵאמֹר רָאִיתִי אֶת־הָרוּחַ כְּיוֹנָה יֹרֶדֶת מִן־הַשָּׁמַיִם וַתָּנַח עָלָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","וַאֲנִי לֹא יָדַעְתִּי אֹתוֹ אַךְ הַשֹּׁלֵחַ אֹתִי לְטַבֵּל בַּמַּיִם אָמַר אֵלָי אֶת־הַלָּז אֲשֶׁר תִּרְאֶה הָרוּחַ יֹרֶדֶת וְתָנוּחַ עָלָיו זֶה הוּא הַמְטַבֵּל בְּרוּחַ הַקֹּדֶשׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","וַאֲנִי רָאִיתִי וָאָעִיד כִּי־זֶה הוּא בֶּן־הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","וַיְהִי מִמָּחֳרָת וַיַּעֲמֹד יוֹחָנָן עוֹד עִם־שְׁנַיִם מִתַּלְמִידָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","וַיַּרְא אֶת־יֵשׁוּעַ מִתְהַלֵּךְ וַיֹּאמַר הִנֵּה שֵׂה הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","וַיִּשְׁמְעוּ שְׁנֵי תַלְמִידָיו אֶת־אֲשֶׁר דִּבֵּר וַיֵּלְכוּ אַחֲרֵי יֵשׁוּעַ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","וַיִּפֶן יֵשׁוּעַ וַיִּרְאֵם הֹלְכִים אַחֲרָיו וַיֹּאמֶר אֲלֵיהֶם מַה־תְּבַקֵּשׁוּן וַיֹּאמְרוּ אֵלָיו רַבִּי אֲשֶׁר יֵאָמֵר מוֹרִי אַיֵּה מְקוֹם מוֹשָׁבֶךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","וַיֹּאמֶר אֲלֵיהֶם בֹּאוּ וּרְאוּ וַיָּבֹאוּ וַיִּרְאוּ אֶת־מְקוֹם מוֹשָׁבוֹ וַיֵּשְׁבוּ אִתּוֹ בַּיּוֹם הַהוּא וְהָעֵת הָיְתָה כַּשָּׁעָה הָעֲשִׂירִית׃ ");
INSERT INTO hebsg_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","וְאֶחָד מִן־הַשְּׁנַיִם אֲשֶׁר שָׁמְעוּ מֵאֵת יוֹחָנָן וְהָלְכוּ אַחֲרָיו הָיָה אַנְדְּרַי אֲחִי שִׁמְעוֹן פֶּטְרוֹס׃ ");
INSERT INTO hebsg_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","הוּא מָצָא אֶת־אָחִיו אֶת־שִׁמְעוֹן וַיֹּאמֶר אֵלָיו מָצָאנוּ אֶת־הַמָּשִׁיחַ אֲשֶׁר בִּלְשׁוֹן יָוָן כְּרִיסְטוֹס׃ ");
INSERT INTO hebsg_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","וַיְבִיאֵהוּ אֶל־יֵשׁוּעַ וַיִּרְאֵהוּ יֵשׁוּעַ וַיֹּאמַר אַתָּה שִׁמְעוֹן בַּר־יוֹנָה לְךָ יִקָּרֵא כֵיפָא וּבִלְשׁוֹן יָוָן פֶּטְרוֹס׃ ");
INSERT INTO hebsg_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","וַיְהִי מִמָּחֳרָת וַיּוֹאֶל לָלֶכֶת הַגָּלִילָה וַיִּמְצָא אֶת־פִּילִפּוֹס וַיֹּאמֶר אֵלָיו יֵשׁוּעַ לֵךְ אַחֲרָי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","וּפִילִפּוֹס הָיה מִבֵּית־צָיְדָה עִיר אַנְדְּרַי וּפֶטְרוֹס׃ ");
INSERT INTO hebsg_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","וַיִּמְצָא פִּילִפּוֹס אֶת־נְתַנְאֵל וַיֹּאמֶר אֵלָיו מָצָאנוּ אֹתוֹ אֲשֶׁר כָּתַב עָלָיו מֹשֶׁה בַּתּוֹרָה וְהַנְּבִיאִים אֶת־יֵשׁוּעַ בֶּן־יוֹסֵף מִנְּצָרֶת׃ ");
INSERT INTO hebsg_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","וַיֹּאמֶר אֵלָיו נְתַנְאֵל הֲכִי מִנְּצֶרֶת יָבֹא טוֹב וַיֹּאמֶר אֵלָיו פִּילִפּוֹס בֹּא וּרְאֵה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","וַיַּרְא יֵשׁוּעַ אֶת־נְתַנְאֵל בָּא לִקְרָאתוֹ וַיֹּאמֶר עָלָיו אוּלָם זֶה הוּא יִשְׂרְאֵלִי אֲשֶׁר אֵין־בּוֹ רְמִיָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","וַיֹּאמֶר אֵלָיו נְתַנְאֵל מֵאַיִן יָדַעְתָּ אֹתִי וַיַּעַן יֵשׁוּעַ וַיֹּאמֶר אֵלָיו טֶרֶם קָרָא לְךָ פִּילִפּוֹס בִּהְיוֹתְךָ תַּחַת הַתְּאֵנָה רְאִיתִיךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","וַיַּעַן אֹתוֹ נְתַנְאֵל רַבִּי אַתָּה הוּא בֶּן־הָאֱלֹהִים אַתָּה הוּא מֶלֶךְ יִשְׂרָאֵל׃ ");
INSERT INTO hebsg_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","וַיַּעַן יֵשׁוּעַ וַיֹּאמֶר אֵלָיו יַעַן אֲשֶׁר הֶאֱמַנְתָּ בִּי בַּעֲבוּר אָמְרִי לְךָ תַּחַת הַתְּאֵנָה רְאִיתִיךָ לָכֵן גְּדֹלוֹת מֵאֵלֶּה תִּרְאֶה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","וַיֹּאמֶר אֵלָיו אָמֵן אָמֵן אֲנִי אֹמֵר לָכֶם כִּי תִרְאוּ אֶת־הַשָּׁמַיִם פְּתוּחִים וּמַלְאֲכֵי אֱלֹהִים עֹלִים וְיֹרְדִים עַל בֶּן־הָאָדָם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","וּבַיּוֹם הַשְּׁלִישִׁי הָיְתָה חֲתֻנָּה בְּקָנָה אֲשֶׁר לַגָּלִיל וְאֵם יֵשׁוּעַ הָיְתָה שָּׁמָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","וְגַם־יֵשׁוּעַ וְתַלְמִידָיו הָיוּ מִן־קְרוּאֵי הַחֲתֻנָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","וְאַחֲרֵי אֲשֶׁר תַּם הַיָּיִן אָמְרָה אֵם יֵשׁוּעַ אֵלָיו הִנֵּה אֵין לָהֶם יָיִן׃ ");
INSERT INTO hebsg_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","וַיֹּאמֶר אֵלֶיהָ יֵשׁוּעַ מַה־לִּי וָלָךְ אִשָּׁה עוֹד לֹא־בָאָה עִתִּי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","וַתֹּאמֶר אִמּוֹ אֶל־הַמְשָׁרְתִים אֶת־אֲשֶׁר יֹאמַר לָכֶם תַּעֲשׂוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","וְשָׁם נִמְצְאוּ שֵׁשׁ כַּדֵּי־אֶבֶן עֲרֻכוֹת לְטַהֵר אֶת־אֲשֶׁר לֹא טָהוֹר בֵּין הַיְּהוּדִים כַּמִּשְׁפָּט שְׁתַּיִם אוֹ־שָׁלֹשׁ בַּתִּים תָּכִיל כָּל־כָּד׃ ");
INSERT INTO hebsg_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","וַיֹּאמֶר אֲלֵיהֶם יֵשׁוּעַ מַלְאוּ אֶת־הַכַּדִּים מָיִם וַיְמַלְאוּן עַד־הַשָּׂפָה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","וַיֹּאמֶר שַׁאֲבוּ־נָא עַתָּה וְהָבִיאוּ אֶל־פְּקִיד הַמִּשְׁתֶּה וַיָּבִיאוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","וַיִּטְעַם פְּקִיד הַמִּשְׁתֶּה אֶת־הַמַּיִם אֲשֶׁר נֶהֶפְכוּ לְיַיִן מִבְּלִי דַעַת מֵאַיִן בָּא רַק הַמְשָׁרְתִים אֲשֶׁר־שָׁאֲבוּ אֶת־הַמַּיִם יָדָעוּ וַיִּקְרָא רַב בֵּית הַמִּשְׁתֶּה אֶל־הֶחָתָן׃ ");
INSERT INTO hebsg_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","וַיֹּאמֶר אֵלָיו כָּל־אִישׁ יָשִׂים יַיִן טוֹב רִאשׁוֹנָה וְאַחֲרֵי שָׁתוּ הַקְּרֻאִים לָרְוָיָה יָשִׂים יַיִן שְׁפַל־עֶרֶךְ לִפְנֵיהֶם וְאַתָּה צָפַנְתָּ אֶת־הַיַּיִן הַטּוֹב עַד־לָאַחֲרֹנָה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","זֹאת רֵאשִׁית הָאֹתוֹת אֲשֶׁר עָשָׂה יֵשׁוּעַ בְּקָנָה אֲשֶׁר לַגָּלִיל וְשָׁם גִּלָּה כְבוֹדוֹ וַיַּאֲמִינוּ בוֹ תַּלְמִידָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","וְאַחֲרֵי־כֵן יָרַד אֶל־כְּפַר נַחוּם הוּא וְאִמּוֹ וְאֶחָיו וְתַלְמִידָיו וַיֵּשְׁבוּ שָׁם יָמִים לֹא רַבִּים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","וַיִּקְרַב חַג־הַפֶּסַח לַיְּהוּדִים וַיַּעַל יֵשׁוּעַ יְרוּשָׁלָיְמָה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","וַיִּמְצָא אֲנָשִׁים ישְׁבִים בַּהֵיכָל מֹכְרִים בָּקָר וָצֹאן וְיוֹנִים וּמְחַלְּפֵי כָסֶף׃ ");
INSERT INTO hebsg_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","וַיִּקַּח חֲבָלִים וְיְשָׂרֵג אֹתָם לְמַלְקָה בְּיָדוֹ וַיְגָרֶשׁ אֶת־כֻּלָּם אֶל־מִחוּץ לַהֵיכָל גַּם אֶת־הַצֹּאן גַּם אֶת־הַבָּקָר וַיַּשְׁלֵךְ אֶת־כֶּסֶף הַמְחַלְּפִים אַרְצָה וְאֶת־שֻׁלְחֲנֹתֵיהֶם הָפָךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","וְאֶל־מֹכְרֵי הַיּוֹנִים אָמָר הוֹצִיאוּ אֶת־אֵלֶּה מִזֶּה וְלֹא תַעֲשׂוּ אֶת־בֵּית אָבִי לְבֵית מִקָּח וּמִמְכָּר׃ ");
INSERT INTO hebsg_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","אָז זָכְרוּ תַלְמִידָיו אֵת אֲשֶׁר־כָּתוּב קִנְאַת בֵּיתְךָ אֲכָלָתְנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","וַיַּעֲנוּ הַיְּהוּדִים וַיֹּאמְרוּ אֵלָיו מָה אוֹת הֶרְאֵיתָ לָּנוּ כִּי תַעֲשֶׂה כָּזֹאת׃ ");
INSERT INTO hebsg_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","וַיַּעַן יֵשׁוּעַ וַיֹּאמֶר אֲלֵיהֶם הִרְסוּ אֶת־הַהֵיכָל הַזֶּה וַאֲנִי בִּשְׁלֹשֶׁת יָמִים אֲקִימֶנּוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","וַיֹּאמְרוּ הַיְּהוּדִים אַרְבָּעִים שָׁנָה וְשֵׁשׁ שָׁנִים נִבְנָה הַהֵיכָל הַזֶּה וְאַתָּה תְקִימֶנּוּ בִּשְׁלֹשֶׁת יָמִים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","וְהוּא דִבֶּר דְּבָרוֹ עַל־הֵיכַל גְּוִיָּתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","עַל־כֵּן אַחֲרֵי תְקוּמָתוֹ מִן־הַמֵּתִים זָכְרוּ תַלְמִידָיו כִּי־כֹה אָמָר לָהֶם וַיַּאֲמִינוּ בַכָּתוּב וּבִדְבַר יֵשׁוּעַ אֲשֶׁר דִּבֵּר׃ ");
INSERT INTO hebsg_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","וַיְהִי בִּהְיוֹתוֹ בִירוּשָׁלַיִם בְּחַג־הַפֶּסַח וַיַּאֲמִינוּ רַבִּים בִּשְׁמוֹ כִּי רָאוּ אֶת־הָאֹתוֹת אֲשֶׁר עָשָׂה לְעֵינֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","וְיֵשׁוּעַ לֹא הֶאֱמִין לָהֶם יַעַן יָדַע אֶת־יֵצֶר כֻּלָּם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","וּבְיַעַן לֹא בִקֵּשׁ עֵדוּת אִישׁ בְּאִישׁ כִּי אֶת־מַחְשְׁבוֹת אָדָם הוּא הָיָה מֵבִין׃ ");
INSERT INTO hebsg_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","וַיְהִי אִישׁ מִן־הַפְּרוּשִׁים וּשְׁמוֹ נַקְדִּימוֹן קְצִין הַיְּהוּדִים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","הוּא בָא אֶל־יֵשׁוּעַ לַיְלָה וַיֹּאמֶר אֵלָיו רַבִּי יָדַעְנוּ כִּי מֵאֵת אֱלֹהִים בָּאתָ לְמוֹרֶה לָנוּ כִּי אֵין לְאֵל יַד־אִישׁ לַעֲשׂוֹת אֶת־הָאֹתוֹת אֲשֶׁר אַתָּה עֹשֶׂה בִּלְתִּי אִם־אֱלֹהִים עִמּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","וַיַּעַן יֵשׁוּעַ וַיֹּאמֶר אֵלָיו אָמֵן אָמֵן אֲנִי אֹמֵר לָךְ אִם־לֹא יִוָּלֵד אִישׁ מִמְּקוֹר עָל לֹא־יוּכַל לִרְאוֹת אֶת־מַלְכוּת הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","וַיֹּאמֶר אֵלָיו נַקְדִּימוֹן אֵיכָה יוּכַל אִישׁ לְהִוָּלֵד וְהוּא זָקֵן הֲכִי יוּכַל לָשׁוּב לְרֶחֶם אִמּוֹ וּלְהִוָּלֵד שֵׁנִית׃ ");
INSERT INTO hebsg_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","וַיַּעַן יֵשׁוּעַ אָמֵן אָמֵן אֲנִי אֹמֵר לָךְ אִם־לֹא יִוָּלֵד אִישׁ מִן־הַמַּיִם וּמִן־הָרוּחַ לֹא־יוּכַל לָבֹא אֶל־מַלְכוּת הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","הַנּוֹלָד מִן־הַבָּשָׂר בָּשָׂר הוּא וְהַנּוֹלָד מִן־הָרוּחַ רוּחַ הוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","אַל־תִּתְמַהּ עַל־אֲשֶׁר אָמַרְתִּי לָךְ כִּי נָכוֹן לָכֶם לְהִוָּלֵד מִמְּקוֹר עָל׃ ");
INSERT INTO hebsg_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","הָרוּחַ נֹשֶׁבֶת אֶל־אֲשֶׁר תַּחְפֹּץ וְאַתָּה שֹׁמֵעַ אֶת־קוֹלָהּ וְלֹא תֵדַע מֵאַיִן בָּאָה וְאָן הִיא הֹלֶכֶת כְּמוֹ כֵן כָּל־הַנּוֹלָד מִן־הָרוּחַ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","וַיַּעַן נַקְדִּימוֹן וַיֹּאמֶר אֵלָיו אֵיכָה תִקְרֶינָה כָּאֵלֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","וַיַּעַן יֵשׁוּעַ וַיֹּאמֶר אֵלָיו הִנְּךָ מוֹרֶה בְיִשְׂרָאֵל וְאֶת־אֵלֶּה לֹא יָדָעְתָּ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","אָמֵן אָמֵן אֲנִי אֹמֵר לָךְ כִּי אֵת אֲשֶׁר־יָדַעְנוּ נְדַבֵּר וְאֵת אֲשֶׁר־רָאִינוּ נָעִיד וְאַתֶּם לֹא תִשְׁמְעוּ לְעֵדוּתֵנוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","אִם בִּדְבָרִים שְׁפָלִים לֹא הֶאֱמַנְתֶּם לִי אֵיךְ תַּאֲמִינוּ לִי כִּי אַגִּיד רָאמוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","וְאִישׁ לֹא־עָלָה לַמָּרוֹם בִּלְתִּי הוּא אֲשֶׁר־יָרַד מִמָּרוֹם הֲלֹא הוּא בֶּן־הָאָדָם אֲשֶׁר בַּשָּׁמָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","וְכַאֲשֶׁר נִשָּׂא משֶׁה בַּמִּדְבָּר אֶת־הַנָּחָשׁ עַל־הַנֵּס כֵּן יִנָּשֵׂא בֶּן־הָאָדָם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","לְמַעַן אֲשֶׁר לֹא יֹאבַד כָּל־הַמַּאֲמִין בּוֹ כִּי אִם יִמְצָא בוֹ חַיֵּי עוֹלָם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","כִּי־כֵן אֹהֵב אֱלֹהִים אֶת־הָעוֹלָם עַד־אֲשֶׁר נָתַן בַּעֲדוֹ אֶת־בְּנוֹ אֶת־יְחִידוֹ וְכָל־הַמַּאֲמִין בּוֹ לֹא־יֹאבַד כִּי בוֹ יִמְצָא חַיֵּי עוֹלָם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","כִּי לֹא־שָׁלַח אֱלֹהִים אֶת־בְּנוֹ אֶל־הָעוֹלָם לְהַרְשִׁיעוֹ בְּהִשָּׁפְטוֹ כִּי אִם־לְמַעַן יִוָּשַׁע בּוֹ הָעוֹלָם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","הַמַּאֲמִין בּוֹ לֹא יֶאְשַׁם וַאֲשֶׁר לֹא־יַאֲמִין בּוֹ אַשְׁמָתוֹ עָלָיו מִנִּי אָז כִּי לֹא־הֶאֱמִין בְּשֵׁם הַבֵּן הַיָּחִיד לֵאלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","וְזֶה הוּא הַמִּשְׁפָּט כִּי הָאוֹר בָּא אֶל־הָעוֹלָם וּבְנֵי הָאָדָם אָהֲבוּ אֶת־הַחשֶׁךְ מִן־הָאוֹר כִּי רָעִים מַעֲשֵׂיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","כִּי כָל־פֹּעֵל אָוֶן שׁנֵא הוּא אֶת־הָאוֹר וְלֹא יָבֹא אֶל־הָאוֹר לִבְלִי יִבָּחֲנוּ מַעֲשָׂיו׃ ");
INSERT INTO hebsg_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","אֲבָל פֹּעֵל אֱמֶת יָבֹא אֶל־הָאוֹר לְמַעַן יִוָּדְעוּ מַעֲשָׂיו אֲשֶׁר עָשָׂה לִפְנֵי הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","אַחַר הַדְּבָרִים הָאֵלֶּה הָלַךְ יֵשׁוּעַ וְתַלְמִידָיו אֶל־אֶרֶץ יְהוּדָה וַיֵּשֶׁב עִמָּהֶם וַיְטַבֵּל שָׁם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","וְגַם־יוֹחָנָן הָיָה מְטַבֵּל בָּעֵת הַהִיא בְּעֵנוֹן בֹּאֲכָה שָׁלֵם כִּי מַיִם רַבִּים נִמְצְאוּ שָׁם וְהַבָּאִים נִטְבָּלוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","כִּי עוֹד לֹא־נִתַּן יוֹחָנָן אֶל־בֵּית הַכֶּלֶא׃ ");
INSERT INTO hebsg_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","וַיְהִי־רִיב בֵּין תַּלְמִידֵי יוֹחָנָן וּבֵין אַחַד הַיְּהוּדִים עַל־דְּבַר הַטָּהֳרָה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","וַיָּבֹאוּ אֶל־יוֹחָנָן וַיֹּאמְרוּ אֵלָיו רַבֵּנוּ הָאִישׁ אֲשֶׁר הָיָה עִמְּךָ בְּעֵבֶר הַיַּרְדֵּן אֲשֶׁר הַעִידֹתָ לּוֹ הִנֵּה הוּא מְטַבֵּל וְכֻלָּם בָּאִים אֵלָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","וַיַּעַן יוֹחָנָן וַיֹּאמַר לֹא־יוּכַל אִישׁ לָקַחַת דָּבָר אִם לֹא נִתַּן־לוֹ מִמָּרוֹם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","אַתֶּם עֵדַי אֲשֶׁר הִגַּדְתִּי כִּי לֹא־אָנֹכִי הַמָּשִׁיחַ כִּי אִם־שָׁלוּחַ לְפָנָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","מִי אֲשֶׁר־לוֹ הַכַּלָּה הוּא הֶחָתָן וְאֹהֵב הֶחָתָן בְּעָמְדוֹ וּכְשָׁמְעוֹ אֹתוֹ שׂוֹשׂ יָשִׂישׂ לְקוֹל הֶחָתָן עַל־כֵּן מָלְאָה שִׂמְחָתִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","הוּא יֵלֵךְ הָלוֹךְ וָרָב וַאֲנִי אֵלֵךְ הָלוֹךְ וְחָסוֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","הַבָּא מִמָּרוֹם רָם הוּא מִכָּל וְהַבָּא מֵאֶרֶץ מֵעָפָר הוּא וְעַל־עָפָר יְדַבֵּר הַבָּא מִשָּׁמַיִם רָם הוּא עַל־כֹּל׃ ");
INSERT INTO hebsg_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","וְכַאֲשֶׁר רָאָה וְשָׁמַע כֵּן יִתֵּן עֵדוּתוֹ וּלְעֵדוּתוֹ אֵין שֹׁמֵעַ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","וְהַשֹּׁמֵעַ לְעֵדוּתוֹ יַחְתֹּם בְּחוֹתַם יָדוֹ כִּי הָאֱלֹהִים אֱמֶת׃ ");
INSERT INTO hebsg_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","כִּי הוּא אֲשֶׁר שְׁלָחוֹ אֱלֹהִים דִּבְרֵי אֱלֹהִים הוּא מְדַבֵּר כִּי־לֹא בִמְשׂוּרה נָתַן אֶת־רוּחוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","הָאָב אֹהֵב אֶת־הַבֵּן וְאֶת־כָּל נָתַן בְּיָדוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","מִי אֲשֶׁר יַאֲמִין בַּבֵּן יֶשׁ־לוֹ חַיֵּי עוֹלָם וּמִי אֲשֶׁר לֹא יַאֲמִין בַּבֵּן לֹא יִרְאֶה חַיִּים כִּי אִם־חֲרוֹן אַף אֱלֹהִים עָלָיו יָחוּל׃ ");
INSERT INTO hebsg_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","וְכַאֲשֶׁר נוֹדַע לָאָדוֹן כִּי הַפְּרוּשִׁים שָׁמְעוּ לֵאמֹר יֵשׁוּעַ הֶעֱמִיד וְטִבֵּל תַּלְמִידִים רַבִּים מִיּוֹחָנָן׃ ");
INSERT INTO hebsg_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","אַף כִּי־יֵשׁוּעַ לֹא טִבֵּל אֹתָם רַק תַּלְמִידָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","וַיַּעֲזֹב אֶת־יְהוּדָה וַיָּשָׁב וַיִּסַּע הַגָּלִילָה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","וְהָיָה נָכוֹן לוֹ לַעֲבֹר דֶּרֶךְ שֹׁמְרוֹן׃ ");
INSERT INTO hebsg_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","וַיָּבֹא אֶל־עִיר בְּאֶרֶץ שֹׁמְרוֹן וּשְׁמָהּ סוּכַר מִמּוּל חֶלְקַת הַשָּׂדֶה אֲשֶׁר־נָתַן יַעֲקֹב לִבְנוֹ לְיוֹסֵף׃ ");
INSERT INTO hebsg_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","וְשָׁם בְּאֵר יַעֲקֹב וְיֵשׁוּעַ עָיְפָה נַפְשׁוֹ בַדֶּרֶךְ וַיֵּשֶׁב־לוֹ עַל־הַבְּאֵר כְּשָׁעָה הַשִּׁשִּׁית׃ ");
INSERT INTO hebsg_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","וְהִנֵּה אִשָּׁה שֹׁמְרֹנִית בָּאָה לִשְׁאָב־מָיִם וַיֹּאמֶר אֵלֶיהָ יֵשׁוּעַ תְּנִי־נָא לִי לִשְׁתּוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","כִּי תַלְמִידָיו הָלְכוּ הָעִירָה לִשְׁבֹּר לָהֶם אֹכֶל׃ ");
INSERT INTO hebsg_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","וַתֹּאמֶר אֵלָיו הָאִשָּׁה הַשֹּׁמְרֹנִית הֲלֹא יְהוּדִי אַתָּה וְאֵיךְ תִּשְׁאַל מִמֶּנִּי לִשְׁתּוֹת וַאֲנִי אִשָּׁה שֹׁמְרֹנִית כִּי־אֵין דָּבָר לַיְּהוּדִים עִם־הַשֹּׁמְרֹנִים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","וַיַּעַן יֵשׁוּעַ וַיֹּאמֶר אֵלֶיהָ לוּ יָדַעַתְּ אֶת־מַתַּת אֱלֹהִים וּמִי הָאֹמֵר לָךְ תְּנִי לִי לִשְׁתּוֹת אָז שָׁאַלְתְּ אַתְּ מִמֶּנּוּ וְנָתַן לָךְ מַיִם חַיִּים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","וַתֹּאמֶר אֵלָיו הָאִשָּׁה אֲדֹנִי הֵן אֵין־לְךָ בַּמֶּה לִשְׁאֹב וְהַבְּאֵר עֲמֻקָּה וּמֵאַיִן לְךָ אֵפוֹא מַיִם חַיִּים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","הֲגָדוֹל אַתָּה מִיַעֲקֹב אָבִינוּ אֲשֶׁר נָתַן־לָנוּ הַבְּאֵר הַזֹּאת אֲשֶׁר מִמֶּנָּה שָׁתָה הוּא וּבָנָיו וּבְעִירוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","וַיַּעַן יֵשׁוּעַ וַיֹּאמֶר אֵלֶיהָ כָּל־הַשֹּׁתֶה מִן־הַמַּיִם הָאֵלֶּה יִצְמָא עוֹד׃ ");
INSERT INTO hebsg_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","וְכָל־אֲשֶׁר יִשְׁתֶּה מִן־הַמַּיִם אֲשֶׁר אֲנִי נֹתֵן לוֹ לֹא יִצְמָא לְעוֹלָם כִּי הַמַּיִם אֲשֶׁר אֲנִי נֹתֵן יִהְיוּ בוֹ לִמְקוֹר מַיִם נֹבְעִים לְחַיֵּי עוֹלָם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","וַתֹּאמֶר אֵלָיו הָאִשָּׁה תְּנָה־לִּי אֲדֹנִי אֶת־הַמַּיִם הָהֵם וְלֹא־אֶצְמָא עוֹד וְלֹא אָבֹא הֵנָּה לִשְׁאֹב׃ ");
INSERT INTO hebsg_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","וַיֹּאמֶר אֵלֶיהָ יֵשׁוּעַ לְכִי קִרְאִי לְאִישֵׁךְ וּבֹאִי הֵנָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","וַתַּעַן הָאִשָּׁה וַתֹּאמֶר אֵלָיו אֵין־לִי אִישׁ וַיֹּאמֶר אֵלֶיהָ יֵשׁוּעַ כֵּן דִּבַּרְתְּ כִּי אֵין־לָךְ אִישׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","חֲמִשָּׁה בְעָלִים הָיוּ לָךְ וְהוּא אֲשֶׁר עִמֵּךְ כַּיּוֹם אֵינֶנּוּ בַעְלֵךְ וּבָזֹאת אֱמֶת דִּבַּרְתְּ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","וַתֹּאמֶר אֵלָיו הָאִשָּׁה אֲדֹנִי רֹאָה אָנֹכִי כִּי נָבִיא אָתָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","אֲבֹתֵינוּ הִשְׁתַּחֲווּ בָּהָר הַזֶּה וְאַתֶּם אֹמְרִים כִּי יְרוּשָׁלַיִם הַמָּקוֹם לְהִשְׁתַּחֲוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","וַיֹּאמֶר אֵלֶיהָ יֵשׁוּעַ הַאֲמִינִי לִי אִשָּׁה כִּי תָבֹא עֵת אֲשֶׁר לֹא־בָּהָר הַזֶּה וְלֹא בִירוּשָׁלַיִם תִּשְׁתַּחֲווּ לָאָב׃ ");
INSERT INTO hebsg_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","אַתֶּם מִשְׁתַּחֲוִים אֶל־אֲשֶׁר לֹא תֵדְעוּן וַאֲנַחְנוּ מִשְׁתַּחֲוִים אֶל־אֲשֶׁר נֵדָע כִּי הַיְשׁוּעָה בָאָה מִמְּקוֹר הַיְּהוּדִים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","אַךְ תָּבֹא עֵת וְגַם־הִיא בָאָה וְהַמִּשְׁתַּחֲוִים הַנֶּאֶמָנִים יִשְׁתַּחֲווּ לָאָב בָּרוּחַ וּבָאֶמֶת כִּי בְּמִשְׁתַּחֲוִים כָּאֵלֶה חָפֵץ הָאָב׃ ");
INSERT INTO hebsg_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","הָאֱלֹהִים הוּא רוּחַ וְהַמִּשְׁתַּחֲוִים לוֹ עֲלֵיהֶם לְהִשְׁתַּחֲוֹת בְּרוּחַ וּבֶאֱמֶת׃ ");
INSERT INTO hebsg_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","וַתֹּאמֶר אֵלָיו הָאִשָּׁה יָדַעְתִּי כִּי־יָבֹא מָשִׁיחַ עהַנִּקְרָא כְרִיסְטוֹסא וְכַאֲשֶׁר יָבֹא יַגִּיד לָנוּ אֶת־כֹּל׃ ");
INSERT INTO hebsg_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","וַיֹּאמֶר אֵלֶיהָ יֵשׁוּעַ אֲנִי הוּא הַמְדַבֵּר אֵלָיִךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","עוֹד דְּבָרוֹ בְּפִיו וְתַלְמִידָיו בָּאוּ וַיִּתְמְהוּ עַל־דַּבְּרוֹ עִם־אִשָּׁה אַךְ אִישׁ לֹא אָמַר מַה־תְּבַקֵּשׁ אוֹ לָמָּה תְדַּבֵּר אֵלֶיהָ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","וְהָאִשָּׁה עָזְבָה אֶת־כַּדָּהּ וַתֵּלֶךְ הָעִירָה וַתֹּאמֶר אֶל־הָעָם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","בֹּאוּ וּרְאוּ אִישׁ אֲשֶׁר הִגִּיד לִי כָּל־אֲשֶׁר עָשִׂיתִי הַאֵין זֶה הוּא הַמָּשִׁיחַ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","וַיֵּצְאוּ מִן־הָעִיר לָבֹא אֵלָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","וַיְהִי עַד־כֹּה וְעַד כֹּה וַיֹּאמְרוּ אֵלָיו תַּלְמִידָיו רַבִּי אֱכֹל׃ ");
INSERT INTO hebsg_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","וַיֹּאמֶר אֲלֵיהֶם אֲנִי יֶשׁ־לִי לֶאֱכֹל אֹכֶל אֲשֶׁר לֹא יְדַעְתֶּם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","וַיֹּאמְרוּ הַתַּלְמִידִים אִישׁ אֶל־רֵעֵהוּ הַאִם הֵבִיא לוֹ אִישׁ מַאֲכַל לְאָכְלָה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","וַיֹּאמֶר אֲלֵיהֶם יֵשׁוּעַ מַאֲכָלִי הוּא עֲשׂוֹת רְצוֹן שֹׁלְחִי וּלְכַלּוֹת אֶת־פָּעֳלוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","הֵן אַתֶּם אֹמְרִים עוֹד אַרְבָּעָה חֳדָשִׁים טֶרֶם יָבֹא הַקָּצִיר וַאֲנִי אֹמֵר לָכֶם שְׂאוּ אֶת־עֵינֵיכֶם וּרְאוּ אֶל־הַשָּׂדוֹת אֲשֶׁר הִלְבִּינוּ לַקָּצִיר׃ ");
INSERT INTO hebsg_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","הַקּוֹצֵר יִמְצָא שְׂכָרוֹ וּתְבוּאָה יֶאֱסֹף לְחַיֵּי עוֹלָם וְהַזֹּרֵעַ וְהַקּוֹצֵר יִשְׂמְחוּ יַחְדָּו׃ ");
INSERT INTO hebsg_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","לְמַלֹּאת דְּבַר הַמֹּשֵׁל אֶחָד זֹרֵעַ וְאַחֵר קֹצֵר׃ ");
INSERT INTO hebsg_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","אָנֹכִי שָׁלַחְתִּי אֶתְכֶם לִקְצֹר בְּמָקוֹם לֹא עֲמַלְתֶּם שָׁם אֲחֵרִים עָמְלוּ וְאַתֶּם בַּאתֶם עַל־עֲמָלָם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","וְרַבִּים מִן־הַשֹּׁמְרֹנִים בָּעִיר הַהִיא הֶאֱמִינוּ בוֹ בַּעֲבוּר דְּבַר הָאִשָּׁה אֲשֶׁר הֵעִידָה לֵאמֹר הוּא הִגִּיד לִי אֶת־כָּל־אֲשֶׁר עָשִׂיתִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","וַיָּבֹאוּ אֵלָיו הַשֹּׁמְרֹנִים וַיִּקְרְאוּ לוֹ לָשֶׁבֶת אִתָּם וַיֵּשֶׁב שָׁם יוֹמָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","וְעוֹד רַבִּים מֵהֵמָּה הֶאֱמִינוּ בוֹ בַּעֲבוּר דִּבְרֵי פִיהוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","וַיֹּאמְרוּ אֶל־הָאִשָּׁה עַתָּה אֲנַחְנוּ מַאֲמִינִים בּוֹ לֹא־בַעֲבוּר דְּבָרֵךְ כִּי גַּם־אֲנַחְנוּ שָׁמַעְנוּ וַנֵּדַע כִּי־אָמֵן זֶה הוּא הַמָּשִׁיחַ מוֹשִׁיעַ הָעוֹלָם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","וַיְהִי אַחֲרֵי שְׁנַיִם יָמִים וַיִּסַּע לְמַסָּעָיו הַגָּלִילָה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","אַף כִּי הִגִּיד יֵשׁוּעַ כִּי אֵין־כָּבוֹד לְנָבִיא בְּאֶרֶץ מוֹלַדְתּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","וַיָּבֹא אֶל־הַגָּלִיל וַיַּחֲזִיקוּ־בוֹ הַגָּלִילִים כִּי רָאוּ אֵת כָּל־אֲשֶׁר עָשָׂה בִירוּשָׁלַיִם בִּימֵי הֶחָג כִּי גַּם־הֵם חָגְגוּ שָׁם אֶת־הַחַג הַהוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","וַיָּבֹא יֵשׁוּעַ עוֹד הַפַּעַם אֶל־קָנָה בַּגָּלִיל אֲשֶׁר הָפַךְ שָׁם הַמַּיִם לְיָיִן וְאִישׁ הָיָה מֵעַבְדֵי הַמֶּלֶךְ וּבְנוֹ חֹלֶה בִּכְפַר־נַחוּם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","וְכַאֲשֶׁר שָׁמַע כִּי־בָא יֵשׁוּעַ מִיהוּדָה לַגָּלִיל וַיֵּלֶךְ אֵלָיו וַיִּפְצַר־בּוֹ לָרֶדֶת אִתּוֹ וְלִרְפֹּא אֶת־בְּנוֹ אֲשֶׁר נָטָה לָמוּת׃ ");
INSERT INTO hebsg_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","וַיֹּאמֶר אֵלָיו יֵשׁוּעַ אִם־לֹא תִרְאוּ אֹתוֹת וּמֹפְתִים לֹא תַאֲמִינוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","וַיֹּאמֶר אֵלָיו הָאִישׁ רְדָה־נָּא אֲדֹנִי בְּטֶרֶם יָמוּת בְּנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","וַיֹּאמֶר אֵלָיו יֵשׁוּעַ לֵךְ לְדַרְכְּךָ בִּנְךָ חָי וְהָאִישׁ הֶאֱמִין בַּדָּבָר אֲשֶׁר־דִּבֶּר יֵשׁוּעַ וַיֵּלַךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","וַיְהִי בְּלֶכְתּוֹ וַיִּפְגְּעוּ־בוֹ עֲבָדָיו וַיַּגִּידוּ לוֹ לֵאמֹר בִּנְךָ חָי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","וַיִּדְרֹשׁ מֵהֶם אֶת־הַשָּׁעָה אֲשֶׁר הֵחֵל לְהֵרָפֵא מֵחָלְיוֹ וַיֹּאמְרוּ אֵלָיו אֶתְמוֹל בַּשָּׁעָה הַשְּׁבִיעִית סָרָה מִמֶּנּוּ הַקַּדָּחַת׃ ");
INSERT INTO hebsg_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","וַיֵּדַע אָבִיו כִּי הָיָה בַּשָּׁעָה הַהִיא אֲשֶׁר הִגִּיד־לוֹ יֵשׁוּעַ בִּנְךָ חָי וַיַּאֲמֵן הוּא וְכָל־בֵּיתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","זֶה הוּא הָאוֹת הַשֵּׁנִי אֲשֶׁר עָשָׂה יֵשׁוּעַ בַּגָּלִיל בְּשׁוּבוֹ מִיהוּדָה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","וְאַחֲרֵי־כֵן בָּא מוֹעֵד חַג הַיְּהוּדִים וַיַּעַל יֵשׁוּעַ יְרוּשָׁלָיְמָה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","וּבִירוּשָׁלַיִם בְּרֵכַת מַיִם עַל־יַד שַׁעַר הַצֹּאן אֲשֶׁר קָרְאוּ לָהּ בְּלָשׁוֹן עִבְרִית בֵּית־חַסְדָּא וְלָהּ חֲמִשָּׁה אֵלַמּוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","וְשָׁם שָׁכְבוּ רַבִּים חוֹלִים עִוְרִים פִּסְחִים וִיבֵשֵׁי־כֹחַ וְהֵם מְיַחֲלִים שָׁם עַד אֲשֶׁר־יִגּוֹעוּ הַמָּיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","כִּי לְעַד מִן־הָעִתִּים יֵרֵד מַלְאָךְ אֶל־הַבְּרֵכָה וְהִרְתִּיחַ אֶת־הַמָּיִם וְהָיָה הָרִאשׁוֹן הַיֹּרֵד שָׁם אַחֲרֵי אֲשֶׁר רֻתְּחוּ הַמָּיִם וְרָפָא לוֹ מִכָּל־מַחֲלָה אֲשֶׁר דָּבְקָה־בּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","וְאִישׁ הָיָה שָׁם אֲשֶׁר חָלָה אֶת־חָלְיוֹ שְׁמֹנֶה וּשְׁלֹשִׁים שָׁנָה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","וַיַּרְא אֹתוֹ יֵשׁוּעַ שֹׁכֵב עַל־מִשְׁכָּבוֹ וַיֵּדַע כִּי שָׁכַב כֵּן יָמִים רַבִּים וַיֹּאמֶר אֵלָיו הֶחָפֵץ אַתָּה לְהֵרָפֵא׃ ");
INSERT INTO hebsg_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","וַיַּעַן אֹתוֹ הַחוֹלֶה אֲדֹנִי אֵין לִי אִישׁ אֲשֶׁר יוֹרִידֵנִי אֶל־הַבְּרֵכָה לְעֵת רִגְשַׁת הַמַּיִם וַאֲנִי טֶרֶם אֵרֵד וְיָרַד אַחֵר לְפָנָי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","וַיֹּאמֶר אֵלָיו יֵשׁוּעַ קוּם שָׂא אֶת־מִשְׁכָּבְךָ וְהִתְהַלֵּךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","וּפִתְאֹם שָׁב הָאִישׁ לְאֵיתָנוֹ וַיִּשָּׂא אֶת־מִשְׁכָּבוֹ וַיֵּלַךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","וְהַיּוֹם הַהוּא הָיָה יוֹם הַשַּׁבָּת וַיֹּאמְרוּ הַיְּהוּדִים אֶל־הָאִישׁ הַנִּרְפָּא הֲלֹא שַׁבָּת הַיּוֹם וְאֵין לְךָ לָשֵׂאת אֶת־הַמִּשְׁכָּב׃ ");
INSERT INTO hebsg_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","וַיַּעַן אֹתָם לֵאמֹר הָרֹפֵא אֹתִי הוּא אָמַר אֵלַי שָׂא אֶת־מִשְׁכָּבְךָ וְהִתְהַלֵּךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","וַיִּשְׁאָלֻהוּ מִי הוּא הָאִישׁ אֲשֶׁר אָמַר אֵלֶיךָ שָׂא אֶת־מִשְׁכָּבְךָ וְהִתְהַלֵּךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","וְהַנִּרְפָּא לֹא יָדַע מִי הוּא כִּי יֵשׁוּעַ הָלַךְ־לוֹ בְּהִתְאַסֵּף עַם־רָב בַּמָּקוֹם הַהוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","אַחֲרֵי־כֵן מָצָא אֹתוֹ יֵשׁוּעַ בְּבֵית הַמִּקְדָּשׁ וַיֹּאמֶר אֵלָיו רְאֵה כִּי נִרְפֵּאתָ אַל־תּוֹסֶף לַחֲטֹא פֶּן־תְּאֻנֶּה אֵלֶיךָ רָעָה גְּדוֹלָה מִזֹּאת׃ ");
INSERT INTO hebsg_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","וַיֵּלֶךְ הָאִישׁ וַיַּגֵּד לַיְּהוּדִים כִּי־יֵשׁוּעַ הוּא אֲשֶׁר רִפְּאוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","וְעַל־כֵּן רָדְפוּ הַיְּהוּדִים אֶת־יֵשׁוּעַ וַיְבַקְשׁוּ הֲמִיתוֹ עֵקֶב אֲשֶׁר עָשָׂה זֹאת בַּשַּׁבָּת׃ ");
INSERT INTO hebsg_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","וַיַּעַן אֹתָם יֵשׁוּעַ אָבִי פֹּעֵל פְּעֻלָּתוֹ עַד־עָתָּה וְגַם־אֲנִי פֹּעֵל הִנֵּנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","וּבַעֲבוּר זֹאת בִּקְשׁוּ הַיְּהוּדִים בְּחֵפֶץ יֶתֶר לְהָרְגוֹ כִּי לֹא רַק אֶת־יוֹם הַשַּׁבָּת חִלֵּל כִּי אִם גַּם־אָמַר עַל־אֱלֹהִים כִּי הוּא אָבִיו וְכִי הוּא דוֹמֶה לֵאלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","וַיַּעַן יֵשׁוּעַ וַיֹּאמֶר אֲלֵיהֶם אָמֵן אָמֵן אֲנִי אֹמֵר לָכֶם הַבֵּן לֹא־יוּכַל לַעֲשׂוֹת דָּבָר מִלִּבּוֹ בִּלְתִּי אֵת אֲשֶׁר־רֹאֶה מַה־פֹּעֵל הָאָב כִּי אֶת־אֲשֶׁר הוּא עֹשֶׂה עֹשֶׂה גַּם־הַבֵּן כָּמֹהוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","כִּי הָאָב אֹהֵב אֶת־הַבֵּן וּמַרְאֶה אֹתוֹ אֶת־כֹּל אֲשֶׁר הוּא עֹשֶׂה וּגְדֹלוֹת מֵאֵלֶּה יַרְאֶנּוּ לִהְיוֹת לְפֶלֶא בְּעֵינֵיכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","כִּי כַּאֲשֶׁר הָאָב מַעֲלֶה וּמְחַיֶּה אֶת־הַמֵּתִים כֵּן יְחַיֶּה גַּם־הַבֵּן אֶת־אֲשֶׁר חָפֵץ בּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","וְהָאָב לֹא־יִשְׁפֹּט אִישׁ אַךְ כָּל־מִשְׁפָּטוֹ נָתַן בְּיַד הַבֵּן׃ ");
INSERT INTO hebsg_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","לְמַעַן יְכַבְּדוּ כֻלָּם אֶת־הַבֵּן כַּאֲשֶׁר יְכַבְּדוּ אֶת־הָאָב מִי אֲשֶׁר לֹא־יְכַבֵּד אֶת־הַבֵּן אֵינֶנּוּ מְכַבֵּד אֶת הָאָב אֲשֶׁר שְׁלָחוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","אָמֵן אָמֵן אֲנִי אֹמֵר לָכֶם הַמַּקְשִׁיב לִדְבָרַי וּמַאֲמִין בְּשֹׁלְחִי יֶשׁ־לוֹ חַיֵּי עוֹלָם וְלֹא יָבֹא לְהִשָּׁפֵט כִּי־עָבַר מִמָּוֶת לַחַיִּים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","אָמֵן אָמֵן אֲנִי אֹמֵר לָכֶם כִּי־תָבֹא עֵת וְכִי גַם־בָּאָה וְהַמֵּתִים יִשְׁמְעוּ אֶת־קוֹל בֶּן־הָאֱלֹהִים וְהַשֹּׁמְעִים חָיֹה יִחְיוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","כִּי כַּאֲשֶׁר חַיֵּי הָאָב מִמְּקוֹר עַצְמוֹ כֵּן נִתַּן לַבֵּן לִהְיוֹת־לוֹ חַיָּיו מִמְּקוֹר עַצְמוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","וְגַם־כֹּחַ נָתַן בְּיָדוֹ לַעֲשׂוֹת מִשְׁפָּט כִּי בֶן־הָאָדָם הוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","עַל־זֹאת אַל־תִּתַּמְּהוּ תָמֹהַּ כִּי הִנֵּה יוֹם בָּא וְכָל־שֹׁכְנֵי קֶבֶר יִשְׁמְעוּ אֶת־קֹלוֹ וְיַעֲלוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","הָעֹשִׂים טוֹב יַעַמְדוּ לַחַיִּים וְהָעֹשִׂים רָע יַעַמְדוּ לַמִּשְׁפָּט׃ ");
INSERT INTO hebsg_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","לֹא אוּכַל לַעֲשׂוֹת דָּבָר מִלִּבִּי כַּאֲשֶׁר אֶשְׁמַע כֵּן אֶשְׁפֹּט וּמִשְׁפָּטִי מִשְׁפָּט־צֶדֶק כִּי לֹא רְצוֹנִי אֲנִי מְבַקֵּשׁ כִּי אִם־רְצוֹן הָאָב אֲשֶׁר שֹׁלְחִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","אִם־אֲנִי לְבַדִּי מֵעִיד עָלָי לֹא נֶאֶמְנָה עֵדוּתִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","אַךְ יֵשׁ עֵד אַחֵר לִי וְיָדַעְתִּי כִּי עֵדוּתוֹ אֲשֶׁר־הוּא מֵעִיד עָלַי נֶאֱמָנָה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","אַתֶּם שְׁלַחְתֶּם אֶל־יוֹחָנָן וְהוּא הֵעִיד עֵדוּת אֱמֶת׃ ");
INSERT INTO hebsg_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","וַאֲנִי לֹא מֵאָדָם אֶקַּח לִי עֵדוּת אַךְ הַדְּבָרִים הָאֵלֶּה דִּבַּרְתִּי לְמַעַן אַתֶּם תִּוָּשֵׁעוּן׃ ");
INSERT INTO hebsg_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","הוּא הָיָה לַפִּיד בֹּעֵר וּמֵאִיר וּבְאוֹרוֹ הוֹאַלְתֶּם לְהִתְעַלֵּם עַד־אַרְגִּיעָה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","וְלִי עֵדוּת גְּדוֹלָה מֵעֵדוּת יוֹחָנָן כִּי הַמַּעֲשִׂים אֲשֶׁר נָתַן־לִי אָבִי לְכַלּוֹתָם הַמַּעֲשִׂים הָאֵלֶּה אֲנִי עֹשֶׂה וְהֵם מְעִידִים עָלַי כִּי שְׁלָחַנִי הָאָב׃ ");
INSERT INTO hebsg_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","וְהָאָב אֲשֶׁר שְׁלָחַנִי הוּא הֵעִיד עָלָי וְאַתֶּם אֶת־קֹלוֹ לֹא־שְׁמַעְתֶּם מֵעוֹלָם וְאֶת־תָּאֳרוֹ לֹא רְאִיתֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","וְאֵין דְּבָרוֹ שֹׁכֵן בְּקִרְבְּכֶם כִּי אֹתוֹ אֲשֶׁר שָׁלַח לֹא תַאֲמִינוּ בוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","אַתֶּם דֹּרְשִׁים מֵעַל־כִּתְבֵי הַקֹּדֶשׁ כִּי בָּהֶם אַתֶּם אֹמְרִים חַיֵּי עוֹלָם לָכֶם וְהֵם הֵמָּה הַמְּעִידִים עָלָי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","וְלֹא אֲבִיתֶם לָבֹא אֵלָי לִהְיוֹת לָכֶם חַיִּים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","כָּבוֹד לֹא־אֶקַּח מִבְּנֵי אָדָם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","וְאֶתְכֶם יָדַעְתִּי כִּי אֵין־אַהֲבַת אֱלֹהִים בְּקִרְבְּכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","אָנֹכִי הִנֵּה בָאתִי בְּשֵׁם אָבִי וְלֹא הֶחֱזַקְתֶּם בִּי וְאִם־יָבֹא אַחֵר בְּשֵׁם עַצְמוֹ בּוֹ תַּחֲזִיקוּן׃ ");
INSERT INTO hebsg_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","אֵיךְ תּוּכְלוּ לְהַאֲמִין אַחֲרֵי אֲשֶׁר תִּרְדְּפוּ כָבוֹד אִישׁ מֵרֵעֵהוּ וְאֶת־הַכָּבוֹד הַבָּא מֵאֵת הָאֱלֹהִים הָאֶחָד לֹא תְבַקֵּשׁוּן׃ ");
INSERT INTO hebsg_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","אַל־תְּחַשְּׁבוּ כִּי אֲנִי אָבִיא שִׂטְנָה עֲלֵיכֶם לִפְנֵי הָאָב יֵשׁ אֶחָד מֵבִיא שִׂטְנָה עֲלֵיכֶם משֶׁה אֲשֶׁר בְּטַחְתֶּם בּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","כִּי לוּ הֶאֱמַנְתֶּם בְּמשֶׁה הֶאֱמַנְתֶּם גַּם־בִּי כִּי עָלַי הוּא כָתָב׃ ");
INSERT INTO hebsg_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","אַךְ אִם־בִּכְתָבָיו לֹא תַאֲמִינוּ אֵיךְ תַּאֲמִינוּ בִּדְבָרָי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","וַיְהִי אַחֲרֵי־כֵן וַיַּעֲבֹר יֵשׁוּעַ אֶל־עֵבֶר יַם־הַגָּלִיל הוּא יַם טִיבַרְיָה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","וַהֲמוֹן עַם־רָב הָלְכוּ אַחֲרָיו כִּי רָאוּ אֶת־הָאֹתוֹת אֲשֶׁר עָשָׂה לְחוֹלִים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","וַיַּעַל יֵשׁוּעַ אֶל־הָהָר וַיֵּשֶׁב־שָׁם עִם־תַּלְמִידָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","וּמוֹעֵד הַפֶּסַח חַג הַיְּהוּדִים קָרַב לָבוֹא׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","וַיִּשָּׂא יֵשׁוּעַ אֶת־עֵינָיו וַיַּרְא הֲמוֹן עַם־רָב בָּא אֵלָיו וַיֹּאמֶר אֶל־פִּילִפּוֹס מֵאַיִן נִשְׁבֹּר לָהֶם לֶחֶם לֶאֱכֹל׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","וְהוּא דִּבֶּר כָּזֹאת לְנַסּוֹתוֹ כִּי הוּא יָדַע אֶת־אֲשֶׁר יַעֲשֶׂה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","וַיַּעַן אֹתוֹ פִּילִפּוֹס מָאתַיִם דִּינַר לֶחֶם לֹא־יִשְׂפֹּק לָהֶם לֶאֱכֹל מִמֶּנּוּ אִישׁ אִישׁ פַּת קְטַנָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","וְאֶחָד מִתַּלְמִידָיו אַנְדְּרַי אֲחִי שִׁמְעוֹן פֶּטְרוֹס אָמַר אֵלָיו לֵאמֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","יֶשְׁנוֹ פֹּה נַעַר אֶחָד וְלוֹ חֲמִשָּׁה לֶחֶם שְׂעֹרִים וְדָגִים שְׁנָיִם אַךְ מָה אֵלֶּה לְעַם־רָב כָּזֶה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","וַיֹּאמֶר יֵשׁוּעַ הוֹשִׁיבוּ אֶת־הָאֲנָשִׁים וַיֵּשְׁבוּ כַּחֲמֵשֶׁת אֲלָפִים אִישׁ לְמִסְפָּרָם בִּנְאוֹת דֶּשֶׁא אֲשֶׁר נִמְצָא שָׁם לְמַכְבִּיר׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","וַיִּקַּח יֵשׁוּעַ אֶת־כִּכְּרוֹת הַלֶּחֶם וַיְבָרֶךְ וַיְחַלֵּק לְתַלְמִידָיו וְהַתַּלְמִידִים לְכָל־הַיּשְׁבִים שָׁמָּה וְגַם מִן־הַדָּגִים נָתַן לָהֶם כְּאַוַּת נַפְשָׁם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","וְאַחֲרֵי אֲשֶׁר שָׂבְעוּ אָמַר אֶל־תַּלְמִידָיו אִסְפוּ אֶת־הַפְּתוֹתִים הַנּוֹתָרִים לִבְלִי יֹאבַד מְאוּמָה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","וַיַּאַסְפוּ וַיְמַלְאוּ שְׁנֵים־עָשָׂר סַלִּים פְּתוֹתִים אֲשֶׁר הוֹתִירוּ הָאֹכְלִים מִן־חֲמִשָּׁה לַחְמֵי הַשְּׂעֹרִים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","וַיְהִי כִּרְאוֹת הָעָם אֶת־הָאוֹת הַזֶּה אֲשֶׁר עָשָׂה יֵשׁוּעַ וַיֹּאמְרוּ אָמְנָה זֶה הוּא הַנָּבִיא הַבָּא לְתֵבֵל אָרְצָה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","וַיֵּדַע יֵשׁוּעַ כִּי־יָבֹאוּ וְתָפְשׂוּ־בוֹ לַעֲשׁתוֹ לְמֶלֶךְ עַל־כֵּן חָלַץ מֵהֶם עוֹד הַפַּעַם אֶל־הָהָר לְבַדּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","וַיְהִי לְעֵת עֶרֶב וַיֵּלְכוּ תַלְמִידָיו אֶל־הַיָּם וַיֵּרְדוּ בָאֳנִיָּה וַיַּעַבְרוּ אֶל־עֵבֶר הַיָּם אֶל־כְּפַר נַחוּם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","וְהִנֵּה חשֶׁךְ בָּא וְיֵשׁוּעַ עוֹד לֹא־בָא אֲלֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","וַיְהִי סַעַר גָּדוֹל עֹבֵר וְהַיָּם הֹלֵךְ וְסֹעֵר׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","וַיַּחְתְּרוּ כְּמֶרְחַק עֶשְׂרִים וְחָמֵשׁ אוֹ שְׁלשִׁים מַעֲנוֹת וַיִּרְאוּ אֶת־יֵשׁוּעַ הוֹלֵךְ עַל־פְּנֵי הַיָּם הָלוֹךְ וְקָרֵב אֶל־הָאֳנִיָּה וַיִּירָאוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","וַיֹּאמֶר אֲלֵיהֶם אֲנִי הוּא אַל־תִּירָאוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","וַיּוֹאִילוּ לָקַחַת אֹתוֹ אֶל־הָאֳנִיָּה וְהִנֵּה פִּתְאֹם הִגִּיעָה הָאֳנִיָּה אֶל־הַיַּבָּשָׁה אֶל־מְחוֹז חֶפְצָם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","וַיְהִי מִמָּחֳרָת וַיַּרְא הֲמוֹן הָעָם הָעֹמֵד מֵעֵבֶר לַיָּם כִּי מִבַּלְעֲדֵי הָאֳנִיָּה לֹא הָיְתָה שָּׁם אֳנִיָּה אַחֶרֶת כִּי אִם־אַחַת אֲשֶׁר יָרְדוּ־בַהּ תָּלְמִידָיו וְכִי לֹא־יָרַד יֵשׁוּעַ בָּהּ עִם־תַּלְמִידָיו כִּי אִם־תַּלְמִידָיו עָבְרוּ לְבַדָּם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","רַק אֳנִיּוֹת אֲחֵרוֹת הִגִּיעוּ מִטִּיבַרְיָה מִקָּרוֹב לַמָּקוֹם אֲשֶׁר אָכְלוּ־שָׁם אֶת־הַלֶּחֶם כַּאֲשֶׁר בֵּרַךְ הָאָדוֹן׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","וְעַל־כֵּן בִּרְאוֹת הֲמוֹן הָעָם כִּי יֵשׁוּעַ אֵינֶנּוּ שָׁם וְאַף־לֹא תַלְמִידָיו וַיֵּרְדוּ גַם־הֵמָּה בָּאֳנִיּוֹת הָאֵלֶּה וַיָּבֹאוּ כְּפַר־נַחוּם לְבַקֵּשׁ אֶת־יֵשׁוּעַ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","וַיִּמְצָאֻהוּ מֵעֵבֶר לַיָּם וַיֹּאמְרוּ אֵלָיו רַבֵּנוּ מָתַי בָּאתָ הֵנָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","וַיַּעַן אֹתָם יֵשׁוּעַ לֵאמֹר אָמֵן אָמֵן אֲנִי אֹמֵר לָכֶם הֵן לֹא בִקַּשְׁתֶּם אֹתִי יַעַן אֲשֶׁר רְאִיתֶם אֶת־אֹתוֹתַי כִּי אִם־יַעַן מִכִּכְּרוֹת הַלֶּחֶם אֲכַלְתֶּם וּשְׂבַעְתֶּם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","אַל־תַּעַמְלוּ בְּעַד אֹכֶל אֹבֵד כִּי אִם־בְּעַד לֶחֶם עֹמֵד לְחַיֵּי עוֹלָם אֲשֶׁר בֶּן־הָאָדָם יִתֵּן לָכֶם כִּי־עָלָיו חָתַם הָאֱלֹהִים הָאָב אֶת־חֹתָמוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","וַיֹּאמְרוּ אֵלָיו מַה־נַּעֲשֶׂה אֲשֶׁר נִפְעַל פְּעֻלּוֹת אֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","וַיַּעַן יֵשׁוּעַ וַיֹּאמֶר אֲלֵיהֶם זֹאת פְּעֻלַּת אֱלֹהִים כִּי־תַאֲמִינוּ בָאִישׁ אֲשֶׁר שְׁלָחוֹ אֲלֵיכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","וַיֹּאמְרוּ אֵלָיו וּמֶה־הָאוֹת אֲשֶׁר תַּעֲשֶׂה כִּי נִרְאֶה וְנַאֲמִין בָּךְ מַה־תִּפְעָל׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","אֲבוֹתֵינוּ אָכְלוּ אֶת־הַמָּן בַּמִּדְבָּר כַּכָּתוּב לֶחֶם שָׁמַיִם נָתַן־לָמוֹ לֶאֱכֹל׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","וַיֹּאמֶר אֲלֵיהֶם יֵשׁוּעַ אָמֵן אָמֵן אֲנִי אֹמֵר לָכֶם משֶׁה לֹא נָתַן לָכֶם לֶחֶם שָׁמָיִם כִּי אִם־אָבִי נֹתֵן לָכֶם לֶחֶם אֱמֶת מִן־הַשָּׁמָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","כִּי־לֶחֶם אֱלֹהִים הוּא הַיֹּרֵד מִן־הַשָּׁמָיִם וְהַנּוֹתֵן חַיִּים לָעוֹלָם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","וַיֹּאמְרוּ אֵלָיו אֲדֹנֵינוּ תְּנָה־לָּנוּ אֶת־הַלֶּחֶם הַזֶּה תָּמִיד׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","וַיֹּאמֶר אֲלֵיהֶם יֵשׁוּעַ אָנֹכִי הוּא לֶחֶם הַחַיִּים כָּל־הַבָּא אֵלַי לֹא יִרְעָב וְכָל־הַמַּאֲמִין בִּי לֹא יִצְמָא עוֹד לְעוֹלָם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","וָאֹמַר אֲלֵיכֶם אֲשֶׁר רְאִיתֶם אֹתִי וְלֹא הֶאֱמַנְתֶּם בִּי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","כָּל־אִישׁ אֲשֶׁר אֹתוֹ יִתֶּן־לִי הָאָב יָבֹא אֵלָי וְהַבָּא אֵלַי לֹא אֲגָרְשֶׁנּוּ מִפָּנָי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","כִּי יָרַדְתִּי מִן־הַשָּׁמַיִם לֹא לַעֲשׂוֹת רְצוֹנִי כִּי אִם־רְצוֹן הָאָב אֲשֶׁר שֹׁלְחִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","וְזֶה רְצוֹן הָאָב אֲשֶׁר שֹׁלְחִי כִּי אֶת־אֲשֶׁר נָתַן לִי לֹא־יֹאבַד לִי אַף אֶחָד כִּי אֲקִימֶנּוּ בַּיּוֹם הָאַחֲרוֹן׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","כִּי זֶה רְצוֹן אָבִי מִי אֲשֶׁר רֹאֶה אֶת־הַבֵּן וּמַאֲמִין בּוֹ יִהְיוּ־לוֹ חַיֵּי עוֹלָם וַאֲנִי אֲקִימֶנּוּ בַּיּוֹם הָאַחֲרוֹן׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","וַיִּלֹּנוּ עָלָיו הַיְּהוּדִים עַל כִּי־אָמַר אָנֹכִי הוּא לֶחֶם הַיֹּרֵד מִן־הַשָּׁמָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","וַיֹּאמְרוּ הֲלֹא זֶה הוּא יֵשׁוּעַ בֶּן־יוֹסֵף אֲשֶׁר יָדַעְנוּ אֶת־אָבִיו וְאֶת־אִמּוֹ וְאֵיךְ יֹאמַר הוּא מִן־הַשָּׁמַיִם יָרָדְתִּי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","וַיַּעַן יֵשׁוּעַ וַיֹּאמֶר אֲלֵיהֶם אַל־נָא תְהִי תְלוּנָה בֵּינֵיכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","לֹא־יוּכַל אִישׁ לָבֹא אֵלַי בִּלְתִּי אִם־יִמְשְׁכֵהוּ הָאָב אֲשֶׁר שְׁלָחָנִי וַאֲנִי אֲקִימֶנּוּ בַּיּוֹם הָאַחֲרוֹן׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","הֲלֹא כָתוּב בַנְּבִיאִים וְכָל־בָּנַיִךְ לִמּוּדֵי יְהוָֹה כָּל־הַשֹּׁמֵעַ מִן־הָאָב וְלֹמֵד מִמֶּנּוּ יָבֹא אֵלָי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","וְלֹא כִּי־רָאָה אָדָם אֶת־הָאָב כִּי רַק זֶה אֲשֶׁר מֵאֵת יְהוָֹה הוּא רָאָה אֶת־הָאָב׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","אָמֵן אָמֵן אֲנִי אֹמֵר לָכֶם כָּל־הַמַּאֲמִין בִּי יֶשׁ־לוֹ חַיֵּי עוֹלָם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","אֲנִי הוּא לֶחֶם הַחַיִּים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","אֲבוֹתֵיכֶם אָכְלוּ אֶת־הַמָּן בַּמִּדְבָּר וַיָּמֻתוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","וְזֶה הוּא הַלֶּחֶם הַיֹּרֵד מִן־הַשָּׁמָיִם לְבַעֲבוּר יֹאכַל־אָדָם מִמֶּנּוּ וְלֹא יָמוּת׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","אָנֹכִי לֶחֶם חַיִּים הַיֹּרֵד מִן־הַשָּׁמַיִם אָדָם כִּי־יֹאכַל מִלֶּחֶם הַזֶּה וָחַי לְעוֹלָם וְהַלֶּחֶם אֲשֶׁר אֲנִי נֹתֵן בְּשָׂרִי הוּא אֲשֶׁר אֶתְּנֶנּוּ בְּעַד חַיֵּי הָעוֹלָם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","וַיֵּרָגְנוּ הַיְּהוּדִים בֵּינֵיהֶם לֵאמֹר אֵיכָה יוּכַל זֶה לָתֶת־לָנוּ אֶת־בְּשָׂרוֹ לֶאֱכֹל׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","וַיֹּאמֶר אֲלֵיהֶם יֵשׁוּעַ אָמֵן אָמֵן אֲנִי אֹמֵר לָכֶם אִם־לֹא תֹאכְלוּ מִבְּשַׂר בֶּן־הָאָדָם וּמִדָּמוֹ לֹא תִשְׁתּוּ לֹא יִהְיוּ לָכֶם חַיִּים בְּעַצְמוֹתֵיכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","הָאֹכֵל מִבְּשָׂרִי וְהַשֹּׁתֶה מִדָּמִי יֶשׁ־לוֹ חַיֵּי עוֹלָם וַאֲנִי אֲקִימֶנּוּ בַּיּוֹם הָאַחֲרוֹן׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","כִּי בְשָׂרִי הוּא אֹכֶל אֱמֶת וְדָמִי שִׁקּוּי אֱמֶת׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","הָאֹכֵל אֶת־בְּשָׂרִי וְהַשֹּׁתֶה אֶת־דָּמִי הוּא יִשְׁכָּן־בִּי וַאֲנִי בוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","כִּי כְּמוֹ הָאָב הַחַי שְׁלָחַנִי וְאָנֹכִי חַי בִּגְלָלוֹ כֵּן הָאֹכֵל אֹתִי גַּם־הוּא יִחְיֶה בִּגְלָלִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","זֶה הוּא הַלֶּחֶם הַיֹּרֵד מִן־הַשָּׁמָיִם לֹא כַמָּן אֲשֶׁר אָכְלוּ אֲבוֹתֵיכֶם וָמֵתוּ הָאֹכֵל מִן־הַלֶּחֶם הַזֶּה יִחְיֶה לְעוֹלָם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","כַּדְּבָרִים הָאֵלֶּה דִּבֶּר בְּלַמְּדוֹ בְּבֵית הַכְּנֵסֶת בִּכְפַר־נַחוּם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","וְרַבִּים מִתַּלְמִידָיו שָׁמְעוּ וַיֹּאמְרוּ קָשֶׁה הַדָּבָר הַזֶּה מִי יוּכַל לְשָׁמְעוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","וְיֵשׁוּעַ יָדַע בְּנַפְשׁוֹ כִּי תַלְמִידָיו מַלִּינִים עַל־זֶה וַיֹּאמֶר אֲלֵיהֶם הֲזֶה הָיָה לָכֶם לְמוֹקֵשׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","וּמַה־יִּהְיֶה כִּי־תִרְאוּ אֶת־בֶּן־הָאָדָם עֹלֶה אֶל־אֲשֶׁר הָיָה־שָׁם לְפָנִים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","הָרוּחַ הוּא הַמְחַיֶּה וְהַבָּשָׂר לֹא־יִצְלַח לַכֹּל הַדְּבָרִים אֲשֶׁר דִּבַּרְתִּי אֲלֵיכֶם רוּחַ הֵם וְחַיִּים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","אַךְ־יֵשׁ אֲנָשִׁים בָּכֶם אֲשֶׁר אֵין אֵמֻן בָּם כִי יֵשׁוּעַ יָדַע מֵרֹאשׁ מִי אֵלֶּה אֲשֶׁר לֹא יַאֲמִינוּ וּמִי הוּא אֲשֶׁר יַסְגִּירֵהוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","וַיֹּאמַר בַּעֲבוּר זֶה הִגַּדְתִּי לָכֶם כִּי לֹא־יוּכַל אִישׁ לָבֹא אֵלַי בִּלְתִּי אִם־נָתוּן־לוֹ מֵאֵת הָאָב׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","וּבַעֲבוּר הַדָּבָר הַזֶּה שָׁבוּ אָחוֹר רַבִּים מִתַּלְמִידָיו וְלֹא הָלְכוּ עוֹד עִמּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","וַיֹּאמֶר יֵשׁוּעַ אֶל־שְׁנֵים הֶעָשָׂר הֲיֵשׁ אֶת־לִבְּכֶם לָשׁוּב מֵאַחֲרַי גַּם־אַתֶּם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","וַיַּעַן אֹתוֹ שִׁמְעוֹן פֶּטְרוֹס אֲדֹנִי אֶל־מִי נֵלֵךְ וְדִבְרֵי חַיֵּי עוֹלָם עִמָּךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","וַאֲנַחְנוּ הֶאֱמַנּוּ וְגַם־יָדָעְנוּ כִּי אַתָּה הוּא הַמָּשִׁיחַ בֶּן־אֵל חָי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","וַיַּעַן אֹתָם יֵשׁוּעַ הֲלֹא שְׁנֵים עָשָׂר בָּחַרְתִּי בָכֶם וְאֶחָד מִכֶּם שָׂטָן הוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","וְזֹאת דִּבֶּר עַל־יְהוּדָה בֶּן־שִׁמְעוֹן אִישׁ־קְרִיּוֹת כִּי זֶה נָכוֹן הָיָה לְהַסְגִּירוֹ וְהוּא אֶחָד מִשְּׁנֵים הֶעָשָׂר׃ ");
INSERT INTO hebsg_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","אַחֲרֵי־כֵן נָסַע יֵשׁוּעַ הֵנָּה וָהֵנָּה בַּגָּלִיל כִּי לֹא אָבָה לִנְסֹעַ בִּיהוּדָה אַחֲרֵי־אֲשֶׁר בִּקְשׁוּ הַיְּהוּדִים לְהָרְגוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","וַיִּקְרַב חַג הַיְּהוּדִים חַג הַסֻּכּוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","וַיֹּאמְרוּ אֵלָיו אֶחָיו עֲלֵה מִזֶּה וְלֶךְ־לְךָ אֶל־אֶרֶץ יְהוּדָה לְמַעַן יִרְאוּ תַלְמִידֶיךָ גַּם־שָׁם אֶת־הָעֲלִילֹת אֲשֶׁר־אַתָּה עֹשֶׂה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","כִּי אֵין־אִישׁ עֹשֶׂה דָבָר בַּסֵּתֶר וּמְבַקֵּשׁ הוּא לְהִוָּדַע נֶגֶד הַשָּׁמֶשׁ וְאִם כֵּן אַתָּה עֹשֶׂה קוּם הִוָּדַע בָּאָרֶץ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","כִּי־אֶחָיו גַּם־הֵם לֹא הֶאֱמִינוּ בוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","וַיֹּאמֶר אֲלֵיהֶם יֵשׁוּעַ עוֹד לֹא־בָאָה עִתִּי עַד־הֵנָּה וְעִתְּכֶם הִיא אִתְכֵם תָּמִיד׃ ");
INSERT INTO hebsg_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","הָעוֹלָם לֹא־תוּכַל לִשְׂנֹא אֶתְכֶם וְאֹתִי תִשְׂנָא עֵקֶב עֵדוּתִי בָהּ כִּי רָעִים מַעֲשֶׂיהָ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","עֲלוּ אַתֶּם לְעֵת הֶחָג וַאֲנִי לֹא אֶעֱלֶה לְעֵת הֶחָג עַתָּה כִּי לֹא מָלְאָה עִתִּי עַד־כֹּה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","כַּדְּבָרִים הָאֵלֶּה דִבֵּר וַיִּתְמַהְמַהּ בַּגָּלִיל׃ ");
INSERT INTO hebsg_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","וְאַחֲרֵי אֲשֶׁר עָלוּ אֶחָיו לְעֵת הֶחָג עָלָה גַּם־הוּא לֹא בַגָּלוּי כִּי אִם־כְּמִסְתַּתֵּר׃ ");
INSERT INTO hebsg_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","וַיְבַקְשׁוּ אֹתוֹ הַיְּהוּדִים בֶּחָג וַיֹּאמְרוּ אַיֵּה אֵיפֹא הוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","וַיְהִי הָעָם נָדוֹן הַרְבֵּה אֵלֶּה אֹמְרִים כִּי־טוֹב הוּא וְאֵלֶּה אֹמְרִים לֹא כִּי־מַתְעֶה הוּא אֶת־הָעָם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","אֶפֶס אֵין־אִישׁ מְדַבֵּר עָלָיו בַּגָּלוּי מִפְּנֵי יִרְאַת הַיְּהוּדִים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","וַיְהִי בְּתוֹךְ יְמֵי הֶחָג וַיַּעַל יֵשׁוּעַ וַיְלַמֵּד בְּבֵית הַמִּקְדָּשׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","וְהַיְּהוּדִים תָּמְהוּ לֵאמֹר מֵאַיִן יֹדֵעַ זֶה סֵפֶר וְהוּא לֹא לֻמָּד׃ ");
INSERT INTO hebsg_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","וַיַּעַן אֹתָם יֵשׁוּעַ וַיֹּאמַר לֹא תוֹרָתִי שֶׁלִּי אֲנִי מוֹרֶה כִּי אִם־תּוֹרַת שֹׁלְחִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","מִי הָאִישׁ הֶחָפֵץ לַעֲשׂוֹת רְצוֹנוֹ הוּא יֵדַע תּוֹרָתִי אִם־מֵאֵת אֱלֹהִים הִיא אוֹ מִלִּבִּי אֲנִי מוֹרֶה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","הַמּוֹרֶה מִלִּבּוֹ אֶת־כְּבוֹדוֹ הוּא מְבַקֵּשׁ וְהַמְבַקֵּשׁ כְּבוֹד שֹׁלְחוֹ נֶאֱמָן הוּא וְלֹא עַוְלָתָה בּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","הֲלֹא משֶׁה נָתַן לָכֶם אֶת־הַתּוֹרָה וְאֵין־אִישׁ מִכֶּם שֹׁמֵר אֶת־הַתּוֹרָה מַדּוּעַ תְּבַקְשׁוּ לְהָרְגֵנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","וַיַּעַן הָעָם וַיֹּאמַר רוּחַ רָעָה בָּךְ מִי אֵיפֹא מְבַקֵּשׁ לְהָרְגֶךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","וַיַּעַן יֵשׁוּעַ וַיֹּאמֶר אֲלֵיהֶם פְּעֻלָּה אַחַת פָּעַלְתִּי וְכֻלְּכֶם תִּתַּמָּהוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","הֵן משֶׁה נָתַן לָכֶם אֶת־הַמּוּלֹת אַף כִּי־לֹא מִמּשֶׁה הִיא כִּי אִם מִן־הָאָבוֹת וְעַל־כֵּן בַּשַּׁבָּת תָּמוּלוּ בֶּן־זָכָר׃ ");
INSERT INTO hebsg_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","וְעַתָּה אִם־בַּשַּׁבָּת הִמּוֹל יִמּוֹל בֶּן־זָכָר לְבַעֲבוּר לֹא תוּפַר תּוֹרַת משֶׁה לָמָּה־זֶּה תִּתְעַבְּרוּ־בִי עַל כִּי־רִפֵּאתִי אִישׁ כֻּלּוֹ בַּשַּׁבָּת׃ ");
INSERT INTO hebsg_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","אַל־תִּשְׁפְּטוּ לָעֵינָיִם כִּי אִם־מִשְׁפַּט־צֶדֶק שְׁפֹטוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","וַיֹּאמְרוּ אֲחָדִים מִיּשְׁבֵי יְרוּשָׁלָיִם הֲלֹא זֶה הוּא אֲשֶׁר הֵם מְבַקְשִׁים לַהֲמִיתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","וְהִנֵּה הוּא מְדַבֵּר בָּרַבִּים וְהֵם אֵינָם אֹמְרִים לוֹ דָבָר הַאַף אֻמְנָם הִכִּירוּ שָׂרֵינוּ כִּי־בֶּאֱמֶת הוּא הַמָּשִׁיחַ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","אַךְ אֶת־הָאִישׁ הַזֶּה יָדַעְנוּ מֵאַיִן הוּא אֲבָל הַמָּשִׁיחַ בְּבֹאוֹ לֹא־יֵדַע אָדָם מֵאַיִן בָּא׃ ");
INSERT INTO hebsg_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","אָז יְלַמֵּד יֵשׁוּעַ בַּמִּקְדָּשׁ וַיִּקְרָא לֵאמֹר אָכֵן יְדַעְתֶּם אֹתִי גַּם־יְדַעְתֶּם מֵאַיִן אָנֹכִי אַךְ מִלִּבִּי לֹא־בָאתִי כִּי יֵשׁ נֶאֱמָן אֲשֶׁר שְׁלָחַנִי וְאַתֶּם לֹא יְדַעְתֶּם אֹתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","וַאֲנִי יָדַעְתִּי אֹתוֹ כִּי מֵאִתּוֹ אָנֹכִי וְהוּא שְׁלָחָנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","וַיְבַקְשׁוּ לְתָפְשׂוֹ וְאִישׁ לֹא־שָׁלַח בּוֹ יָד כִּי עוֹד לֹא־בָאָה עִתּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","וְרַבִּים מִן־הָעָם הֶאֱמִינוּ־בוֹ וַיֹּאמְרוּ הֲכִי הַמָּשִׁיחַ בְּבֹאוֹ יַעֲשֶׂה אֹתוֹת רַבִּים מֵאֲשֶׁר הוּא עֹשֶׂה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","וַיִּשְׁמְעוּ הַפְּרוּשִׁים כִּי הָעָם מִתְלַחֲשִׁים כָּזֹאת עַל־אֹדוֹתָיו וַיִּשְׁלְחוּ רָאשֵׁי הַכֹּהֲנִים וְהַפְּרוּשִׁים מְשָׁרְתִים לְתָפְשׂוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","וַיֹּאמֶר אֲלֵיהֶם יֵשׁוּעַ עוֹד מְעַט מִזְעָר אֶהְיֶה עִמָּכֶם וְאֵלֵךְ לִי אֶל־שֹׁלְחִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","תְּבַקְשֻׁנִי וְלֹא תִמְצָאֻנִי וּבַאֲשֶׁר אֶהְיֶה אֲנִי לֹא תוּכְלוּ אַתֶּם לָבֹא שָׁמָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","וַיֹּאמְרוּ הַיְּהוּדִים אִישׁ אֶל־אָחִיו אָנָה יֵלֵךְ זֶה כִּי לֹא נִמְצָא אֹתוֹ הֲיֵלֵךְ אֶל־הַנְּפוֹצִים בְּאֶרֶץ יָוָן וּלְלַמֵּד אֶת־הַיְּוָנִים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","מָה־הַדָּבָר הַזֶּה אֲשֶׁר אָמַר תְּבַקְשֻׁנִי וְלֹא תִמְצָאֻנִי וּבַאֲשֶׁר אֶהְיֶה אֲנִי לֹא תוּכְלוּ אַתֶּם לָבֹא שָׁמָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","וַיְהִי בַּיּוֹם הָאַחֲרוֹן הַגָּדוֹל בֶּחָג וַיַּעֲמֹד יֵשׁוּעַ וַיִּקְרָא הוֹי כָּל־צָמֵא לְכוּ אֵלַי וּשְׁתוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","הַמַּאֲמִין בִּי כִּדְבַר הַכָּתוּב מִקִּרְבּוֹ יִזְּלוּ נַחֲלֵי מַיִם חַיִּים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","כָּזֹאת דִּבֶּר עַל־הָרוּחַ אֲשֶׁר תָּנַח עַל־הַמַּאֲמִינִים בּוֹ כִּי עוֹד לֹא־נִשְׁפַּךְ רוּחַ הַקֹּדֶשׁ בְּטֶרֶם לֻקַּח יֵשׁוּעַ אַחַר כָבוֹד׃ ");
INSERT INTO hebsg_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","וְיֵשׁ מִן־הָעָם כְּשָׁמְעָם אֶת־הַדְּבָרִים הָאֵלֶּה אָמְרוּ אָכֵן זֶה הוּא הַנָּבִיא׃ ");
INSERT INTO hebsg_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","וְיֵשׁ אֲשֶׁר אָמְרוּ זֶה הוּא הַמָּשִׁיחַ וַאֲחֵרִים אָמְרוּ הֲמִן־הַגָּלִיל יָבֹא הַמָּשִׁיחַ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","הֲלֹא הַכָּתוּב אֹמֵר כִּי מִזֶּרַע דָּוִד מִבֵּית־לֶחֶם הָעִיר חָנָה דָוִד מִשָּׁם יֵצֵא הַמָּשִׁיחַ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","וַיֵּחָלֵק הָעָם בְּהַצֹּתָם עָלָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","וְיֵשׁ מֵהֶם אֲשֶׁר רָצוּ לְתָפְשׂוֹ וְאִישׁ לֹא־שָׁלַח בּוֹ יָדוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","וַיָּשׁוּבוּ הַמְשָׁרְתִים אֶל־רָאשֵׁי הַכֹּהֲנִים וְהַפְּרוּשִׁים וְהֵם אָמְרוּ אֲלֵיהֶם מַדּוּעַ לֹא־הֲבֵאתֶם אֹתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","וַיַּעֲנוּ הַמְשָׁרְתִים לֵאמֹר מֵעוֹלָם לֹא־דִבֶּר אָדָם כָּמֹהוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","וַיֹּאמְרוּ אֲלֵיהֶם הַפְּרוּשִׁים הֲכִי נִדַּחְתֶּם גַּם־אַתֶּם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","הֲכִי הֶאֱמִין בּוֹ אַחַד הַשָּׂרִים אוֹ אַחַד הַפְּרוּשִׁים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","לְבַד הֶהָמוֹן הַזֶּה אֲשֶׁר אֵינָם יֹדְעִים אֶת־הַתּוֹרָה אֲרוּרִים הֵמָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","וַיֹּאמֶר אֲלֵיהֶם נַקְדִּימוֹן הוּא אֲשֶׁר־בָּא אֵלָיו לְפָנִים וְהוּא אֶחָד מִן־הַפְּרוּשִׁים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","הֲכִי תִשְׁפֹּט תּוֹרָתֵנוּ אֶת־הָאָדָם בְּטֶרֶם יִשָּׁמַע מַה־בְּפִיו וּבְטֶרֶם יִוָּדַע מֶה־עָשָׂה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","וַיַּעֲנוּ וַיֹּאמְרוּ אֵלָיו הֲמִן־הַגָּלִיל גַּם־אַתָּה דְּרֹשׁ וַחֲקֹר כִּי לֹא־קָם נָבִיא מִן־הַגָּלִיל׃ ");
INSERT INTO hebsg_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","וַיֵּלְכוּ אִישׁ אִישׁ לְבֵיתוֹ וְיֵשׁוּעַ הָלַךְ אֶל־הַר הַזֵּיתִים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","וַיְהִי בַּבֹּקֶר וַיָּבֹא עוֹד אֶל־הַהֵיכָל וְכָל־הָעָם בָּאוּ אֵלָיו וַיֵּשֶׁב וַיְלַמְּדֵם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","וְהַסּוֹפְרִים וְהַפְּרוּשִׁים הֵבִיאוּ לְפָנָיו אִשָּׁה אֲשֶׁר נִתְפְּשָׂה בְּנַאֲפוּפֶיהָ וַיַּעֲמִדוּהָ בַּתָּוֶךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","וַיֹּאמְרוּ אֵלָיו רַבֵּנוּ הָאִשָּׁה הַזֹּאת נִתְפְּשָׂה בְּנַאֲפוּפֶיהָ כְּגַנָּב בַּמַּחְתָּרֶת׃ ");
INSERT INTO hebsg_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","וּבַתּוֹרָה צִוָּה־לָנוּ משֶׁה לִסְקֹל בָּאֲבָנִים אִשָּׁה כָזֹאת וּמַה־תֹּאמַר אָתָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","וְכָזֹאת אָמְרוּ לְנַסּוֹתוֹ לִמְצֹא עָלָיו דָּבָר לְשִׂטְנוֹ וַיִּשְׁתּוֹחַח יֵשׁוּעַ וַיְתָו בְּאֶצְבָּעוֹ עַל־הָאָרֶץ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","וְכַאֲשֶׁר הוֹסִיפוּ לִשְׁאֹל אֹתוֹ וַיָּקָם וַיֹּאמֶר אֲלֵיהֶם מִי־בָכֶם נָקִי מֵעָוֹן יַדֶּה־בָּהּ אֶבֶן רִאשׁוֹנָה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","וַיִּשְׁתּוֹחַח שֵׁנִית וַיְתָו עוֹד עַל־הָאָרֶץ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","וְהֵם כְּשָׁמְעָם אֶת־זֹאת וַיַּךְ לִבָּם אֹתָם יָצְאוּ אִישׁ אִישׁ מִזָּקֵן וְעַד־צָעִיר וַיִּוָּתֵר יֵשׁוּעַ לְבַדּוֹ וְהָאִשָּׁה עֹמֶדֶת בַּתָּוֶךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","וַיָּקָם יֵשׁוּעַ וַיַּרְא כִּי אֵין אִישׁ בִּלְתִּי הָאִשָּׁה לְבַדָּה וַיֹּאמַר אִשָּׁה אַיֵּה הֵם שִּׂטְנַיִךְ הֲכִי לֹא הִרְשִׁיעֵךְ אִישׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","וַתֹּאמֶר אֵין גַּם־אֶחָד אֲדֹנִי וַיֹּאמֶר אֵלֶיהָ יֵשׁוּעַ גַּם־אֲנִי לֹא אַרְשִׁיעֵךְ לְכִי לְבֵיתֵךְ וְאַל־תֶּחֶטְאִי עוֹד׃ ");
INSERT INTO hebsg_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","וַיּוֹסֶף יֵשׁוּעַ וַיְדַבֵּר אֲלֵיהֶם לֵאמֹר אָנֹכִי אוֹר הָעוֹלָם הַהֹלֵךְ אַחֲרַי לֹא יֵלֵךְ בַּחֹשֶׁךְ כִּי־לוֹ אוֹר הַחַיִּים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","וַיֹּאמְרוּ אֵלָיו הַפְּרוּשִׁים אַתָּה מֵעִיד עֵדוּת לְנַפְשֶׁךָ עֵדוּתְךָ לֹא נֶאֱמָנָה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","וַיַּעַן יֵשׁוּעַ וַיֹּאמֶר אֲלֵיהֶם אַף אִם־אֲנִי מֵעִיד לְנַפְשִׁי עֵדוּתִי נֶאֱמָנָה כִּי־יָדַעְתִּי מֵאַיִן בָּאתִי וּלאָן אֲנִי הֹלֵךְ וְאַתֶּם אֵינְכֶם יֹדְעִים מֵאַיִן בָּאתִי וּלְאָן אֲנִי הֹלֵךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","אַתֶּם דָּנִים לְעֵינֵי בָשָׂר וַאֲנִי אֵינֶנִּי דָן אַף לֹא־לָאֶחָד׃ ");
INSERT INTO hebsg_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","וְאַף לוּ־דָן הָיִיתִי דִּינִי דִּין אֱמֶת כִּי אֵינֶנִּי לְבַדִּי כִּי אִם־אֲנִי וְהָאָב אֲשֶׁר שְׁלָחָנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","וְגַם בְּתוֹרַתְכֶם כָּתוּב כִּי עַל־פִּי שְׁנַיִם עֵדִים יָקוּם דָּבָר׃ ");
INSERT INTO hebsg_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","אֲנִי הוּא הַמֵעִיד עֵדוּת לְנַפְשִׁי וְאָבִי אֲשֶׁר שְׁלָחַנִי גַּם־הוּא לִי לְעֵד׃ ");
INSERT INTO hebsg_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","וַיֹּאמְרוּ אֵלָיו אָבִיךָ אַיּוֹ וַיַּעַן יֵשׁוּעַ לֹא יְדַעְתֶּם גַּם־אֹתִי וְגַם־לֹא אֶת־אָבִי לוּ יְדַעְתֶּם אֹתִי אָז יְדַעְתֶּם גַּם אֶת־אָבִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","כַּדְּבָרִים הָאֵלֶּה דִּבֶּר יֵשׁוּעַ בְּבֵית הָאוֹצָר כַּאֲשֶׁר לִמַּד בַּהֵיכָל וְלֹא־תְפָשׂוֹ אִישׁ כִּי עוֹד לֹא־בָאָה עִתּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","וַיּוֹסֶף יֵשׁוּעַ וַיֹּאמֶר אֲלֵיהֶם אֲנִי אֵלֶךְ לִי וְאַתֶּם תְּבַקְשֻׁנִי וּבְחַטֹּאתֵיכֶם תָּמוּתוּ וְאֶל־אֲשֶׁר אֲנִי הֹלֵךְ אַתֶּם לֹא־תוּכְלוּ לָבֹא שָׁמָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","וַיֹּאמְרוּ הַיְּהוּדִים הַיְאַבֵּד נַפְשׁוֹ בְּיָדָיִם כִּי אֹמֵר אֶל־אֲשֶׁר אֲנִי הֹלֵךְ אַתֶּם לֹא־תוּכְלוּ לָבֹא שָׁמָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","וַיֹּאמֶר אֲלֵיהֶם אַתֶּם מִשֹּׁכְנֵי מַטָּה וַאֲנִי מִשֹּׁכְנֵי מָעְלָה אַתֶּם מִן־הָעוֹלָם הַזֶּה וַאֲנִי אֵינֶנִּי מִן־הָעוֹלָם הַזֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","לָכֵן אָמַרְתִּי לָכֶם כִּי תָמוּתוּ בְחַטֹּאתֵיכֶם כִּי אִם־לֹא תַאֲמִינוּ־בִי כִּי־אֲנִי הוּא תָּמוּתוּ בְחַטֹּאתֵיכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","וַיֹּאמְרוּ אֵלָיו וּמִי־זֶה אָתָּה וַיֹּאמֶר אֲלֵיהֶם יֵשׁוּעַ אֲנִי הוּא כַּאֲשֶׁר אָמַרְתִּי אֲלֵיכֶם מֵרֹאשׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","יֶשׁ־לִי רַבּוֹת לְדַבֵּר וְלִשְׁפֹּט עֲלֵיכֶם אָכֵן שֹׁלְחִי נֶאֱמָן הוּא וְאֶת־הַדָּבָר אֲשֶׁר אֶשְׁמַע מִמֶּנּוּ אֹתוֹ אֲדַבֵּר אֶל־הָעוֹלָם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","וְהֵם לֹא הֵבִינוּ זֹאת כִּי עַל־הָאָב דִּבֶּר אֲלֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","וַיֹּאמֶר יֵשׁוּעַ כַּאֲשֶׁר תַּגְבִּיהוּ אֶת־בֶּן־הָאָדָם לְמַעְלָה אָז תַּכִּירוּ כִּי־אֲנִי הוּא וְלֹא עָשִׂיתִי מְאוּמָה מִלִּבִּי כִּי אִם־הַדָּבָר אֲשֶׁר הוֹרַנִי הָאָב אֹתוֹ אֲנִי מְדַבֵּר׃ ");
INSERT INTO hebsg_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","וְשֹׁלְחִי עִמָּדִי הוּא לֹא זָנַח אֹתִי גַּלְמוּד כִּי אֶת־הַטּוֹב בְּעֵינָיו אֲנִי עֹשֶׂה תָּמִיד׃ ");
INSERT INTO hebsg_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","וַיְהִי כְּדַבְּרוֹ אֶת־הַדְּבָרִים הָאֵלֶּה וַיַּאֲמִינוּ־בוֹ רַבִּים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","וַיֹּאמֶר יֵשׁוּעַ אֶל־הַיְּהוּדִים הַמַּאֲמִינִים בּוֹ אִם־תַּעַמְדוּ בִּדְבָרַי אָז תִּהְיוּ תַלְמִידַי בֶּאֱמֶת וּבְתָמִים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","כִּי תַשְׂכִּילוּ אֶת־הָאֱמֶת וְהָאֱמֶת תַּעֲשֶׂה אֶתְכֶם חָפְשִׁים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","וַיַּעֲנוּ אֹתוֹ הֵן זֶרַע אַבְרָהָם אֲנַחְנוּ וְלֹא־הָיִינוּ עֲבָדִים לְאָדָם מֵעוֹלָם וְאֵיךְ תֹּאמַר אַתָּה כִּי־חָפְשִׁים תִּהְיוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","וַיַּעַן אֹתָם יֵשׁוּעַ אָמֵן אָמֵן אֲנִי אֹמֵר לָכֶם כָּל־אִישׁ אֲשֶׁר יַעֲשֶׂה חֵטְא עֶבֶד לַחֵטְא הוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","וְהָעֶבֶד לֹא־יֵשֵׁב בַּבַּיִת עַד־עוֹלָם אַךְ הַבֵּן יֵשֵׁב שָׁם עַד־עוֹלָם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","לָכֵן אִם־הַבֵּן יַעֲשֶׂה אֶתְכֶם חָפְשִׁים חָפְשִׁים תִּהְיוּ אֶל־נָכוֹן׃ ");
INSERT INTO hebsg_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","יָדַעְתִּי כִּי־זֶרַע אַבְרָהָם אַתֶּם וּבְכָל־זֹאת תְּבַקְשׁוּ אֶת־נַפְשִׁי לְקַחְתָּהּ כִּי לִדְבָרַי אֵין מְסִלּוֹת בִּלְבַבְכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","אֲנִי מְדַבֵּר אֵת אֲשֶׁר רָאִיתִי אֵצֶל הָאָב וְאַתֶּם עֹשִׂים אֵת אֲשֶׁר שְׁמַעְתֶּם מֵאֵת אֲבִיכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","וַיַעֲנוּ וַיֹּאמְרוּ אֵלָיו אָבִינוּ הוּא אַבְרָהָם וַיֹּאמֶר אֲלֵיהֶם יֵשׁוּעַ לוּ הֱיִיתֶם בְּנֵי אַבְרָהָם כְּמַעֲשֵׂי אַבְרָהָם עֲשִׂיתֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","וְאַתֶּם מְבַקְשִׁים אֶת־נַפְשִׁי לְקַחְתָּהּ בַּאֲשֶׁר אֱמֶת אַגִּיד לָכֶם אֵת אֲשֶׁר שָׁמַעְתִּי מֵאֵת אֱלֹהִים כָּזֹאת לֹא עָשָׂה אַבְרָהָם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","כְּמַעֲשֵׂי אֲבִיכֶם אַתֶּם עֹשִׂים וַיֹּאמְרוּ אֵלָיו לֹא יַלְדֵי זְנוּנִים אֲנָחְנוּ יֶשׁ־לָנוּ אָב אֶחָד אֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","וַיֹּאמֶר אֲלֵיהֶם יֵשׁוּעַ אִם אֱלֹהִים אֲבִיכֶם תֶּאֱהָבוּנִי כִּי מֵאֵת אֱלֹהִים יָצָאתִי וּמֵאִתּוֹ בָאתִי וְלֹא־מִלִּבִּי כִּי־הוּא שְׁלָחָנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","מַדּוּעַ לֹא תָבִינוּ נִיב שְׂפָתָי אֵין זֶה כִּי אִם לֹא־תוּכְלוּן לְהַשְׂכִּיל אֶל־תּוֹרָתִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","אַתֶּם מֵאֵת אֲבִיכֶם הַשָּׂטָן הִנְּכֶם וַתִּתְמַכְּרוּ לַעֲשׂוֹת כְּתַאֲוַת אֲבִיכֶם הוּא הָיָה רֹצֵחַ נְפָשׁוֹת מֵרֹאשׁ וּבְמוֹ־אֱמֶת לֹא עָמַד כִּי אֱמֶת אֵין־בּוֹ כַּאֲשֶׁר יְדַבֵּר כָּזָב מִלִּבּוֹ הוּא דֹבֵר כִּי־מְשַׁקֵּר הוּא וַאֲבִי כָל־מְשַׁקֵּר׃ ");
INSERT INTO hebsg_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","וַאֲנִי כַּאֲשֶׁר אֱמֶת אֲנִי דֹבֵר לֹא תַאֲמִינוּ לִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","מִי־מִכֶּם יַכְזִיבֵנִי עַל־שֶׁמֶץ דָּבָר וְאִם דֹּבֵר אֱמֶת אֲנִי מַדּוּעַ לֹא־תַאֲמִינוּ לִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","מִי אֲשֶׁר מֵאֵת אֱלֹהִים הוּא יִשְׁמַע דִּבְרֵי אֱלֹהִים וְאַתֶּם לֹא תִשְׁמָעוּנִי כִּי לֹא מֵאֵת אֱלֹהִים אַתֶּם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","וַיַּעֲנוּ הַיְּהוּדִים וַיֹּאמְרוּ אֵלָיו הֲלֹא הֵיטֵב דִּבַּרְנוּ כִּי שֹׁמְרוֹנִי אַתָּה וְרוּחַ רָעָה בָּךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","וַיַּעַן יֵשׁוּעַ רוּחַ רָעָה אֵין־בִּי כִּי אִם־מְכַבֵּד אֲנִי אֶת־אָבִי וְאַתֶּם תִּבְזֻנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","וַאֲנִי לֹא אֶת־כְּבוֹדִי אֲנִי מְבַקֵּשׁ יֵשׁ אֶחָד אֲשֶׁר הוּא מְבַקְשׁוֹ וְגַם־יִשְׁפֹּט׃ ");
INSERT INTO hebsg_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","אָמֵן אָמֵן אֲנִי אֹמֵר לָכֶם אִם יִשְׁמֹר אִישׁ אֶת־דְּבָרִי לֹא יִרְאֶה־מָּוֶת לְעוֹלָם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","וַיֹּאמְרוּ אֵלָיו הַיְּהוּדִים עַתָּה יָדַעְנוּ כִּי־רוּחַ רָעָה בָּךְ גַּם־אַבְרָהָם מֵת גַּם־הַנְּבִיאִים וְאַתָּה אָמַרְתָּ אִם יִשְׁמֹר אִישׁ אֶת־דְּבָרִי לֹא יִטְעַם־מָוֶת לְעוֹלָם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","הֲגָדוֹל אַתָּה מֵאַבְרָהָם אָבִינוּ אֲשֶׁר מֵת וְהַנְּבִיאִים כִּי מֵתוּ מַה תַּעֲשֶׂה בְנַפְשֶׁךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","וַיַּעַן יֵשׁוּעַ אִם־אֲנִי אֶתֵּן כָּבוֹד לְנַפְשִׁי כְּבוֹדִי כְאָיִן אַךְ אָבִי הוּא מְכַבְּדֵנִי אֲשֶׁר עָלָיו תֹּאמְרוּן כִּי הוּא אֱלֹהֵיכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","וְאַתֶּם לֹא יְדַעְתֶּם אֹתוֹ אַךְ אֲנִי יֹדֵעַ אֹתוֹ וְכִי־אֹמַר לֹא יְדַעְתִּיו אֶהְיֶה מְכַזֵּב כְּמוֹכֶם אָכֵן יְדַעְתִּיו וְאֶת־דְּבָרוֹ אֲנִי שֹׁמֵר׃ ");
INSERT INTO hebsg_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","אַבְרָהָם אֲבִיכֶם הִתְעַלֵּס לִרְאוֹת אֶת־יוֹמִי וַיַּרְא וַיִּשְׂמַח׃ ");
INSERT INTO hebsg_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","וַיֹּאמְרוּ אֵלָיו הַיְּהוּדִים אֵינְךָ עוֹד בֶּן־חֲמִשִּׁים שָׁנָה וְאֶת־אַבְרָהָם רָאִיתָ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","וַיֹּאמֶר אֲלֵיהֶם יֵשׁוּעַ אָמֵן אָמֵן אֲנִי אֹמֵר לָכֶם אֲנִי הָיִיתִי עוֹד עַד לֹא־הָיָה אַבְרָהָם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","וַיִּשְׂאוּ אֲבָנִים לִרְגֹּם אֹתוֹ אַךְ יֵשׁוּעַ הִסְתַּתֵּר מֵעֵינֵיהֶם וַיֵּצֵא מִן־הַמִּקְדָּשׁ וַיַּעֲבֹר בְּתֹכָם וַיֵּלֶךְ הָלוֹךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","וַיְהִי בְּעָבְרוֹ וַיַּרְא אִישׁ אֲשֶׁר נוֹלַד עִוֵּר מֵרֶחֶם אִמּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","וַיִּשְׁאָלֻהוּ תַלְמִידָיו לֵאמֹר רַבֵּנוּ מִי חָטָא הָאִישׁ הַזֶּה אוֹ יֹלְדָיו כִּי נוֹלַד עִוֵּר׃ ");
INSERT INTO hebsg_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","וַיַּעַן יֵשׁוּעַ לֹא הוּא חָטָא וְלֹא יֹלְדָיו אַךְ לְבַעֲבוּר יֵרָאוּ־בוֹ מַעַלְלֵי־אֵל׃ ");
INSERT INTO hebsg_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","עָלַי לְעוֹלֵל עֲלִלוֹת שֹׁלְחִי בְּעוֹד יוֹם כִּי־יָבֹא לַיְלָה וְאָז לֹא־יוּכַל אִישׁ לַעֲשׂוֹת מְאוּמָה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","בְּעוֹד אֲנִי בָעוֹלָם אוֹר הָעוֹלָם הִנֵּנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","הַדָּבָר יָצָא מִפִּיו וַיָּרֶק רֹק בַּעֲפַר הָאֲדָמָה וַיִּגְבָּל־חֹמֶר וַיִּמְרַח עַל־עֵינָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","וַיֹּאמֶר אֵלָיו הָלֹךְ וְרָחַצְתָּ בִּבְרֵכַת הַשִּׁלֹּחַ אֲשֶׁר יֵאָמֵר שָׁלוּחַ וַיֵּלֶךְ וַיִּרְחַץ וַיָּבֹא בְּעֵינַיִם פְּקֻחוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","וַיֹּאמְרוּ שְׁכֵנָיו הַיֹּדְעִים אֹתוֹ מֵאָז הֲלֹא־זֶה הוּא הַיֹּשֵׁב הַמְבַקֵּשׁ נְדָבוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","אֵלֶּה אָמְרוּ כִּי־זֶה הוּא וְאֵלֶּה לֹא־כֵן רַק דּוֹמֶה־לּוֹ וְהוּא אָמַר אֲנִי הוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","וַיֹּאמְרוּ אֵלָיו אֵיכָה אֵיפוֹא נִפְקְחוּ עֵינֶיךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","וַיַּעַן אִישׁ אֲשֶׁר שְׁמוֹ יֵשׁוּעַ גָּבַל חֹמֶר וַיִּמְרַח עַל־עֵינָי וְכֹה אָמַר אֵלַי הָלֹךְ וְרָחַצְתָּ בִּבְרֵכַת הַשִּׁלֹּחַ וָאֵלֵךְ וָאֶרְחַץ וְעֵינַי נִפְקָחוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","וַיֹּאמְרוּ אֵלָיו וְאַיּוֹ וַיֹּאמֶר לֹא יָדָעְתִּי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","וַיָּבִיאוּ אֶת־הָעִוֵּר הָרֹאֶה הַזֶּה אֶל־הַפְּרוּשִׁים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","וְהַיּוֹם אֲשֶׁר לָשׁ יֵשׁוּעַ אֶת־הַטִּיחַ וְאֶת־עֵינָיו פָּקָח הָיָה יוֹם הַשַּׁבָּת׃ ");
INSERT INTO hebsg_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","וַיּוֹסִיפוּ גַם־הַפְּרוּשִׁים לִשְׁאֹל אֹתוֹ אֵיךְ נִתַּן לוֹ אוֹר עֵינָיו וַיַגֵּד לָהֶם כִּי שָׂם טִיחַ עַל־עֵינַי וָאֶרְחַץ וְהִנֵּה עֵינַי רֹאוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","וְיֵשׁ מִן־הַפְּרוּשִׁים אָמְרוּ הָאִישׁ הַזֶּה אֵינֶנּוּ אִישׁ אֱלֹהִים כִּי אֵינֶנּוּ שֹׁמֵר אֶת־הַשַּׁבָּת וְיֵשׁ אָמְרוּ הֲיוּכַל אִישׁ חֹטֵא לַעֲשׂוֹת מוֹפְתִים כָּאֵלֶה וַיְהִי מָדוֹן בֵּינֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","וַיּוֹסִיפוּ וַיֹּאמְרוּ אֶל־הָעִוֵּר וּמַה־תֹּאמַר אַתָּה עָלָיו כִּי פָּקַח אֶת־עֵינֶיךָ וַיֹּאמֶר כִּי נָבִיא הוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","וְלֹא־הֶאֱמִינוּ לוֹ הַיְּהוּדִים כִּי עִוֵּר הָיָה וְאוֹר עֵינָיו נִתַּן לוֹ עַד־אֲשֶׁר קָרְאוּ לְיֹלְדֵי הָעִוֵּר הָרֹאֶה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","וַיִּשְׁאֲלוּ אֹתָם לֵאמֹר הֲזֶה בִנְכֶם אֲשֶׁר אֲמַרְתֶּם כִּי נוֹלַד עִוֵּר וְאֵיךְ הוּא רֹאֶה עָתָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","וַיַּעֲנוּ אֹתָם יֹלְדָיו וַיֹּאמְרוּ יָדַעְנוּ בְּנֵנוּ הוּא זֶה וְגַם נוֹלַד עִוֵּר׃ ");
INSERT INTO hebsg_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","אֲבָל לֹא יָדַעְנוּ אֵיךְ הוּא רֹאֶה עַתָּה וְלֹא יָדַעְנוּ מִי פָקַח אֶת־עֵינָיו הֲלֹא בָא בַיָּמִים הוּא שַׁאֲלוּ אֹתוֹ וְהוּא בְּפִיו יַגִּיד לָכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","כָּזֹאת דִּבְּרוּ יֹלְדָיו מִיִּרְאָתָם אֶת־הַיְּהוּדִים אֲשֶׁר כְּבָר חָרְצוּ לְנַדּוֹת אֶת־כָּל־אֲשֶׁר יוֹדֶה כִּי הוּא הַמָּשִׁיחַ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","עַל־כֵּן אָמְרוּ יֹלְדָיו כִּי בָא בַשָּׁנִים הוּא שַׁאֲלוּ אֶת־פִּיהוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","אָז קָרְאוּ שֵׁנִית לָעִוֵּר הָרֹאֶה וַיֹּאמְרוּ אֵלָיו שִׂים־נָא כָּבוֹד לֵאלֹהִים אֲנַחְנוּ יָדַעְנוּ כִּי־הָאִישׁ הַזֶּה חֹטֵא הוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","וַיַּעַן וַיֹּאמֶר אִם־חֹטֵא הוּא לֹא יָדָעְתִּי רַק אַחַת יָדַעְתִּי כִּי עִוֵּר הָיִיתִי וְעַתָּה הִנְנִי רֹאֶה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","וַיֹּאמְרוּ אֵלָיו מֶה־עָשָׂה לָךְ אֵיךְ פָּקַח אֶת־עֵינֶיךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","וַיַּעַן אֹתָם הֲלֹא אָמַרְתִּי לָכֶם וְלֹא שְׁמַעְתֶּם וּמַה־לָּכֶם לִשְׁמֹעַ שֵׁנִית הֲגַם אַתֶּם חֲפֵצִים לִהְיוֹת תַּלְמִידָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","וַיְגַדְּפוּ אֹתוֹ וַיֹּאמְרוּ אַתָּה הוּא תַלְמִידוֹ וַאֲנַחְנוּ תַּלְמִידֵי משֶׁה אֲנָחְנוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","יָדַעְנוּ כִּי אֶל־משֶׁה דִּבֶּר אֱלֹהִים וְזֶה הָאִישׁ לֹא יָדַעְנוּ מֵאַיִן הוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","וַיַּעַן הָאִישׁ וַיֹּאמֶר אֲלֵיהֶם דְּבַר פֶּלֶא הוּא אַתֶּם לֹא יְדַעְתֶּם מֵאַיִן הוּא וְהוּא אֶת־עֵינַי פָּקָח׃ ");
INSERT INTO hebsg_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","וַאֲנַחְנוּ יָדַעְנוּ כִּי חַטָּאִים לֹא־יִשְׁמַע אֱלֹהִים כִּי אִם־הַיָּרֵא אֶת־הָאֱלֹהִים וְהָעֹשֶׂה אֶת־רְצוֹנוֹ אֹתוֹ יִשְׁמָע׃ ");
INSERT INTO hebsg_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","מִי שָׁמַע מֵעוֹדוֹ כִּי־פָקַח אִישׁ אֶת־עֵינֵי הַנּוֹלָד עִוֵּר מֵרָחֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","לוּלֵא הָיָה זֶה אִישׁ אֱלֹהִים לֹא־יָכֹל עֲשׂוֹת דָּבָר׃ ");
INSERT INTO hebsg_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","וַיַּעֲנוּ וַיֹּאמְרוּ אֵלָיו הֵן בְּעָוֹן חוֹלָלְתָּ וְאַתָּה תְלַמֵּד אֹתָנוּ וַיִּדְחֲפוּ אֹתוֹ מֵעַל־פְּנֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","וְיֵשׁוּעַ שָׁמַע כִּי דָחֲפוּ אֹתוֹ מֵעַל־פְּנֵיהֶם וַיִּפְגְּשֵׁהוּ וַיֹּאמַר הֲתַאֲמִין בְּבֶן־הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","וַיַּעַן וַיֹּאמַר וּמִי הוּא־זֶה אֲדֹנִי וְאַאֲמִין בּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","וַיֹּאמֶר אֵלָיו יֵשׁוּעַ הֲלֹא רָאִיתָ אֹתוֹ וְהִנֵּה הוּא הַמְדַבֵּר אֵלֶיךָ זֶה הוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","וַיֹּאמַר הִנְנִי מַאֲמִין אֲדֹנִי וַיִּשְׁתַּחוּ לוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","וַיֹּאמֶר יֵשׁוּעַ אֲנִי לָדִין בָּאתִי בָאָרֶץ לְמַעַן הַעִוְרִים יִהְיוּ רֹאִים וְהָרֹאִים יִהְיוּ עִוְרִים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","וּמִן־הַפְּרוּשִׁים אֲשֶׁר הָיוּ עִמּוֹ וְשָׁמְעוּ אֶת־דְּבָרָיו אָמְרוּ הֲגַם אֲנַחְנוּ עִוְרִים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","וַיֹּאמֶר אֲלֵיהֶם יֵשׁוּעַ לוּ עִוְרִים הֱיִיתֶם לֹא־הָיָה בָכֶם עָוֹן אֲבָל אַתֶּם אֹמְרִים כִּי הִנְּכֶם רֹאִים לָכֵן נִמְצָא עָוֹן בָּכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","אָמֵן אָמֵן אֲנִי אֹמֵר לָכֶם אִישׁ אֲשֶׁר לֹא־יַבֹא דֶּרֶךְ הַשַּׁעַר אֶל־מִכְלְאוֹת הַצֹּאן כִּי אִם־יַעֲלֶה בְדֶרֶךְ אַחֵר גַּנָּב הוּא וְשֹׁדֵד׃ ");
INSERT INTO hebsg_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","וְאִישׁ הַבָּא דֶרֶךְ הַשַּׁעַר הוּא רֹעֵה הַצֹּאן׃ ");
INSERT INTO hebsg_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","לוֹ יִפְתַּח הַשֹּׁעֵר וְהַצֹּאן תִּשְׁמַעְנָה בְקֹלוֹ וְהוּא בְּשֵׁמוֹת יִקְרָא אֶל־צֹאנוֹ וְיוֹצִיאֵן׃ ");
INSERT INTO hebsg_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","בְּהוֹצִיאוֹ אֶת־כָּל־צֹאנוֹ יַעֲבֹר לִפְנֵיהֶן וְהָלְכוּ אַחֲרָיו הַצֹּאן כִּי יֹדְעוֹת אֶת־קֹלוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","וְאַחֲרֵי זָר לֹא תֵלַכְנָה כִּי תָנוֹסְנָה מִפָּנָיו יַעַן קוֹל זָרִים לֹא יָדָעוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","אֶת־הַמָּשָׁל הַזֶּה נָשָׂא עֲלֵיהֶם יֵשׁוּעַ וְהֵם לֹא הֵבִינוּ מַה־זֶּה אֲשֶׁר דִּבֶּר אֲלֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","וַיּוֹסֶף יֵשׁוּעַ וַיְדַבֵּר אֲלֵיהֶם אָמֵן אָמֵן אֲנִי אֹמֵר לָכֶם אָנֹכִי שַׁעַר הַצֹּאן׃ ");
INSERT INTO hebsg_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","כֹּל אֲשֶׁר בָּאוּ לְפָנַי גַּנָּבִים הֵם וְשֹׁדְדִים וְלֹא־שָׁמְעוּ אֲלֵיהֶם הַצֹּאן׃ ");
INSERT INTO hebsg_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","אָנֹכִי הַשַּׁעַר אִישׁ כִּי־יָבֹא דֶרֶךְ בִּי יְוָּשֵׁעַ וּבָא וְיֵצֵא וּמָצָא מִרְעֶה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","הַגַּנָּב לֹא יָבֹא כִּי אִם־לִגְנֹב לִשְׁחֹט וּלְהַשְׁמִיד וַאֲנִי בָאתִי לְמַעַן יִמְצְאוּ חַיִּים וְחַיַּת נַפְשָׁם לָרְוָיָה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","אֲנִי הוּא הָרֹעֶה הַטּוֹב הָרֹעֶה הַטּוֹב יִתֵּן אֶת־נַפְשׁוֹ בְּעַד הַצֹּאן׃ ");
INSERT INTO hebsg_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","וְהַשָּׂכִיר אֲשֶׁר אֵינֶנּוּ רֹעֶה וְלֹא־לוֹ הַצֹּאן יִרְאֶה אֶת־הַזְּאֵב בָּא יַעֲזֹב אֶת־הַצֹּאן וְיָנוּס וְהַזְּאֵב יַחֲטֹף וְיָפִיץ אֶת־הַצֹּאן׃ ");
INSERT INTO hebsg_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","וְהַשָּׂכִיר נָס כִּי שָׂכִיר הוּא וְלֹא יִדְאַג לַצֹּאן׃ ");
INSERT INTO hebsg_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","אֲנִי הוּא הָרֹעֶה הַטּוֹב יָדַעְתִּי אֵת אֲשֶׁר־לִי וְנוֹדַעְתִּי לַאֲשֶׁר לִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","כַּאֲשֶׁר גַּם־הָאָב יֹדֵעַ אֹתִי וַאֲנִי יֹדֵעַ אֶת־הָאָב וְאֶת־נַפְשִׁי אֶתֵּן בְּעַד הַצֹּאן׃ ");
INSERT INTO hebsg_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","וְעוֹד צֹאן אֲחֵרוֹת יֶשׁ־לִי אֲשֶׁר אֵינָן מִן־הַמִּכְלָה הַזֹּאת וְעָלַי לִנְהַג גַּם־אֹתָן וְהֵנָּה בְּקוֹלִי תִשְׁמַעְנָה וְהָיָה עֵדֶר אֶחָד וְרֹעֶה אֶחָד׃ ");
INSERT INTO hebsg_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","עַל־כֵּן יֶאֱהָבַנִי הָאָב כִּי אֶת־נַפְשִׁי אֶתֵּן וְאָשִׁיב וְאֶקָּחֶיהָ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","אִישׁ לֹא יִקַּח נַפְשִׁי מִמֶּנִּי כִי אִם־אֲנִי אֶתְּנֶנָּה יֶשׁ־לְאֵל יָדִי לְתִתָּהּ וְיֶשׁ־לְאֵל לַהֲשִׁיבָהּ אֵלָי זֹאת הַמִּצְוָה צֻוֵּיתִי מֵאֵת אָבִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","וַיֵּחָלְקוּ הַיְּהוּדִים עוֹד הַפַּעַם עַל־הַדְּבָרִים הָאֵלֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","רַבִּים מֵהֶם אָמְרוּ רוּחַ רָע בּוֹ וּמְשֻׁגָּע הוּא לָמָּה־זֶּה תִּשְׁמְעוּ אֵלָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","וַאֲחֵרִים אָמְרוּ אֵין הַדְּבָרִים הָאֵלֶּה דִּבְרֵי בַעַל רוּחַ רָע הֲיֵשׁ עִם־רוּחַ רָע לִפְקֹחַ עֵינֵי עִוְרִים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","וַיְהִי בִּימֵי הַחֲנֻכָּה בִּימֵי הַחֹרֶף בִּירוּשָׁלָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","וַיִּתְהַלֵּךְ יֵשׁוּעַ בְּבֵית הַמִּקְדָּשׁ בְּאוּלָם שְׁלֹמֹה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","וַיָּסֹבּוּ אֹתוֹ הַיְהוּדִים וַיֹּאמְרוּ עַד־אָנָה תִמְשְׁכֵנוּ בְנַפְשֵׁנוּ אִם־אַתָּה הוּא הַמָּשִׁיחַ הַגֶּד־לָנוּ לְעֵין הַשָּׁמֶשׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","וַיַּעַן אֹתָם יֵשׁוּעַ הֵן הִגַּדְתִּי לָכֶם וְלֹא הֶאֱמַנְתֶּם בִּי הַמַּעֲשִׂים אֲשֶׁר־אֲנִי עֹשֶׂה בְּשֵׁם אָבִי הֵם לִי לְעֵדוּת׃ ");
INSERT INTO hebsg_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","רַק אַתֶּם לֹא תַאֲמִינוּ כִּי לֹא מִצֹּאנִי אַתֶּם כַּאֲשֶׁר אָמַרְתִּי לָכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","צֹאנִי שֹׁמְעוֹת אֶת־קֹלִי וַאֲנִי יֹדֵעַ אֹתָן וְהֵנָּה הֹלְכוֹת אַחֲרָי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","וְחַיֵּי עוֹלָם אֶתֵּן לָהֶן לֹא תֹאבַדְנָה לָנֶצַח וְלֹא יַחֲטֹף אֹתָן אִישׁ מִיָּדִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","אָבִי אֲשֶׁר נְתָנָן לִי אַדִּיר הוּא מִכֹּל וְאֵין אִישׁ אֲשֶׁר־יוּכַל לַחֲטֹף אֶתְהֶן מִיַּד הָאָב׃ ");
INSERT INTO hebsg_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","וַאֲנִי וְהָאָב אֶחָד׃ ");
INSERT INTO hebsg_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","וַיּוֹסִיפוּ הַיְּהוּדִים וַיִּשְׂאוּ אֲבָנִים לְסָקְלוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","וַיַּעַן אֹתָם יֵשׁוּעַ הֵן מַעֲשִׂים רַבִּים טוֹבִים הֶרְאֵיתִי לָכֶם מֵאֵת הָאָב עַל־אֵי־זֶה מִן־הַמַּעֲשִׂים הָאֵלֶּה תִּסְקְלֻנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","וַיַּעֲנוּ אֹתוֹ הַיְּהוּדִים לֵאמֹר עַל־מַעֲשֶׂה טוֹב לֹא נִסְקְלֶךָ כִּי אִם־עַל־חִלּוּל הַשֵּׁם בַּאֲשֶׁר כִּי אָדָם אַתָּה וְהִנְּךָ אֹמֵר לְנַפְשְׁךָ אֱלֹהִים אָתָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","וַיַּעַן אֹתָם יֵשׁוּעַ הֲלֹא כָתוּב בְּתוֹרַתְכֶם אֲנִי אָמַרְתִּי אֱלֹהִים אַתֶּם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","וְעַתָּה אִם־אֲנָשִׁים נִקְרְאוּ אֱלֹהִים אֲשֶׁר תּוֹרַת הָאֱלֹהִים אִתָּם וּדְבַר הַכָּתוּב אֵין לְהָשִׁיב׃ ");
INSERT INTO hebsg_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","אֵיךְ תֹּאמְרוּן עַל־זֶה אֲשֶׁר קִדְּשׁוֹ הָאָב וַיִּשְׁלָחֵהוּ בָאָרֶץ מְגַדֵּף אָתָּה יַעַן אָמַרְתִּי בֶּן־הָאֱלֹהִים אָנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","אִם־לֹא עָשִׂיתִי אֶת־מַעֲשֵׂי אָבִי לֹא תַאֲמִינוּ לִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","וְאִם־עֲשִׂיתִים אַף כִּי לֹא־אֲבִיתֶם לְהַאֲמִין בִּי הַאֲמִינוּ בְּמַעֲשֵׂי יָדָי לְמַעַן תֵּדְעוּ וְתַאֲמִינוּ כִּי הָאָב בִּי וַאֲנִי בָּאָב׃ ");
INSERT INTO hebsg_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","וַיּוֹסִיפוּ וַיְבַקְשׁוּ לְתָפְשׂוֹ אַךְ הוּא נִמְלַט מִיָּדָם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","וַיֵּצֵא וַיָּשָׁב אֶל־עֵבֶר הַיַּרְדֵּן אֶל־הַמָּקוֹם אֲשֶׁר יוֹחָנָן הָיָה מְטַבֵּל שָׁם בַּתְּחִלָּה וַיֵּשֶׁב שָׁם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","וַיָּבֹאוּ אֵלָיו רַבִּים וַיֹּאמְרוּ הִנֵּה יוֹחָנָן לֹא־נָתַן מוֹפֵת אֲבָל כָּל־אֲשֶׁר דִּבֶּר עַל־הָאִישׁ הַזֶּה אֱמֶת הוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","וַיַּאֲמִינוּ־בוֹ רַבִּים בַּמָּקוֹם הַהוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","וַיְהִי אִישׁ חֹלֶה וּשְׁמוֹ אֶלְעָזָר מִבֵּית־עַנְיָה מְקוֹם מוֹשַׁב מִרְיָם וּמַרְתָא אֲחוֹתָהּ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","הִיא מִרְיָם אֲשֶׁר מָשְׁחָה אֶת־הָאָדוֹן בְּשֶׁמֶן רֹקֵחַ וּבְשַׂעֲרֹתֶיהָ נִגְּבָה אֶת־רַגְלָיו וְאֶלְעָזָר הוּא אָחִיהָ אֲשֶׁר חָלָה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","וַתִּשְׁלַחְנָה הָאֲחָיוֹת אֵלָיו לֵאמֹר אֲדֹנִי הִנֵּה זֶה אֲשֶׁר נַפְשְׁךָ אֲהֵבַתְהוּ חֹלֶה הוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","וַיִשְׁמַע יֵשׁוּעַ וַיֹּאמַר הַמַּחֲלָה הַזֹּאת לֹא לַמָּוֶת כִּי אִם־לִכְבוֹד הָאֱלֹהִים לְמַעַן יִכָּבֶד־בָּהּ בֶּן־הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","וְיֵשׁוּעַ אָהַב אֶת־מַרְתָא וְאֶת־אֲחוֹתָהּ וְאֶת־אֶלְעָזָר׃ ");
INSERT INTO hebsg_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","וַיְהִי בְּשָׁמְעוֹ כִּי חָלָה וַיִּתְמַהְמַהּ וַיֵּשֶׁב יוֹמַיִם בַּמָּקוֹם אֲשֶׁר־הוּא שָׁם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","וְאַחֲרֵי־כֵן אָמַר לְתַלְמִידָיו לְכוּ וְנָשׁוּבָה אֶל־אֶרֶץ יְהוּדָה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","וַיֹּאמְרוּ אֵלָיו תַּלְמִידָיו רַבֵּנוּ הֲלֹא זֶה עַתָּה בִּקְשׁוּ הַיְּהוּדִים לִסְקָלְךָ וְאַתָּה עוֹד תָּשׁוּב שָׁמָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","וַיַּעַן יֵשׁוּעַ הֲלֹא שְׁתֵּים־עֶשְׂרֵה שָׁעוֹת בַּיּוֹם אִישׁ הַהֹלֵךְ בַּיּוֹם לֹא יִכָּשֵׁל כִּי יִרְאֶה אוֹר הָעוֹלָם הַזֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","אֲבָל הַהֹלֵךְ בַּלַּיְלָה יִכָּשֵׁל כִּי הָאוֹר אֵינֶנּוּ־בוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","וְאַחֲרֵי דַבְּרוֹ כָזֹאת אָמַר אֲלֵיהֶם אֶלְעָזָר יְדִידֵנוּ יָשֵׁן וַאֲנִי הֹלֵךְ לְהָעִיר אֹתוֹ מִשְּׁנָתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","וַיַּעֲנוּ תַלְמִידָיו אֲדֹנִי אִם־יָשֵׁן הוּא שְׁנָתוֹ תַחֲלִימֵהוּ וָחָי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","וְיֵשׁוּעַ דִּבֶּר כֵּן עַל־מוֹתוֹ וְהֵם חָשְׁבוּ כִּי עַל־מְנוּחָתוֹ בַּשֵּׁנָה הוּא מְדַבֵּר׃ ");
INSERT INTO hebsg_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","אָז אָמַר אֲלֵיהֶם יֵשׁוּעַ בְּשָׂפָה בְרוּרָה אֶלְעָזָר מֵת׃ ");
INSERT INTO hebsg_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","וַאֲנִי שָׂמֵחַ לְמַעַנְכֶם כִּי לֹא־הָיִיתִי שָׁמָּה לְבַעֲבוּר תַּאֲמִינוּ אַךְ נֵלְכָה־נָּא אֵלָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","וַיֹּאמֶר תּוֹמָא הַנִּקְרָא דִידוּמוֹס אֶל־חֲבֵרָיו הַתַּלְמִידִים נֵלְכָה־נָּא גַּם־אֲנַחְנוּ וְנָמוּתָה עִמּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","וַיָּבֹא יֵשׁוּעַ וַיִּמְצָא כִּי זֶה כְבָר אַרְבָּעָה יָמִים שֹׁכֵב בַּקָּבֶר׃ ");
INSERT INTO hebsg_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","וּבֵית־עַנְיָה קְרֹבָה לִירוּשָׁלָיִם כַּחֲמֵשׁ עֶשְׂרֵה מַעֲנוֹת צֶמֶד שָׂדֶה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","וִיהוּדִים רַבִּים בָּאוּ אֶל־מַרְתָא וּמִרְיָם לְנַחֲמָן עַל־אֲחִיהֶן׃ ");
INSERT INTO hebsg_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","וַיְהִי כִּשְׁמֹעַ מַרְתָא כִּי יֵשׁוּעַ בָּא וַתֵּצֵא לִקְרָאתוֹ וּמִרְיָם יֹשֶׁבֶת בַּבָּיִת׃ ");
INSERT INTO hebsg_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","וַתֹּאמֶר מַרְתָא אֶל־יֵשׁוּעַ אֲדֹנִי לוּ הָיִיתָ פֹּה עִמָּנוּ וְלֹא־מֵת אָחִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","וְגַם־עַתָּה יָדַעְתִּי כִּי כָל־אֲשֶׁר תִּשְׁאַל מֵאֵת הָאֱלֹהִים כֵּן יִתֵּן לְךָ הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","וַיֹּאמֶר אֵלֶיהָ יֵשׁוּעַ הֲלֹא יָקוּם אָחִיךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","וַתֹּאמֶר אֵלָיו מַרְתָא יָדַעְתִּי כִּי יָקוּם בְּיוֹם הַתְּקוּמָה בַּיּוֹם הָאַחֲרוֹן׃ ");
INSERT INTO hebsg_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","וַיֹּאמֶר אֵלֶיהָ יֵשׁוּעַ אֲנֹכִי הַתְּקוּמָה וְהַחַיִּים הַמַּאֲמִין בִּי אַף כִּי־הוּא מֵת יָקוּם וָחָי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","וְכָל־חַי אֲשֶׁר יַאֲמִין־בִּי לֹא יָמוּת לְעוֹלָם הֲתַאֲמִינִי זֹאת אָתְּ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","וַתֹּאמֶר אֵלָיו הֵן אֲדֹנִי הֵן אֲנֹכִי הֶאֱמַנְתִּי כִּי־אַתָּה הוּא הַמָּשִׁיחַ בֶּן־הָאֱלֹהִים הַבָּא אֶל־הָעוֹלָם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","וּבְדַבְּרָהּ כָּזֹאת הָלְכָה וְקָרְאָה לְמִרְיָם אֲחוֹתָהּ בַּסֵּתֶר לֵאמֹר הִנֵּה בָּא הָרַבִּי וְהוּא קֹרֵא לָךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","וַתִּשְׁמַע וַתָּקָם כְּרֶגַע וַתָּבֹא אֵלָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","וְיֵשׁוּעַ טֶרֶם יָבֹא אֶל־הַכְּפָר כִּי אִם־עוֹדֶנּוּ עֹמֵד בַּמָּקוֹם אֲשֶׁר פָּגְשָׁה־בּוֹ מַרְתָא׃ ");
INSERT INTO hebsg_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","וְהַיְּהוּדִים אֲשֶׁר־הָיוּ אִתָּהּ בַּבַּיִת לְנַחֲמָהּ בִּרְאוֹתָם כִּי־קָמָה מִרְיָם וְיָצְאָה פִתְאֹם הָלְכוּ אַחֲרֶיהָ בְּחָשְׁבָם כִּי־לִבְכּוֹת אֶל־הַקֶּבֶר הִיא הֹלָכֶת׃ ");
INSERT INTO hebsg_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","וּמִרְיָם בָּאָה אֶל־הָמָּקוֹם אֲשֶׁר יֵשׁוּעַ עֹמֵד שָׁם וַתִּרְאֵהוּ וַתִּפֹּל לְרַגְלָיו וַתֹּאמֶר לוֹ אֲדֹנִי לוּ הָיִיתָ פֹּה עִמָּנוּ וְלֹא־מֵת אָחִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","כִּרְאוֹת יֵשׁוּעַ אֹתָהּ בֹּכִיָּה וְאֶת־הַיְּהוּדִים בֹּכִים עִמָּהּ וַיֵּמַר רוּחוֹ בְּקִרְבּוֹ וַיִּסָּעֵר לִבּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","וַיֹּאמֶר אָן קְבַרְתֶּם אֹתוֹ וַיֹּאמְרוּ אֵלָיו בֹּא אֲדֹנֵינוּ וּרְאֵה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","וַיֵּבְךְ יֵשׁוּעַ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","וַיֹּאמְרוּ הַיְּהוּדִים רְאוּ מַה־נִּפְלָאָה לּוֹ אַהֲבָתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","וְיֵשׁ מֵהֶם אָמְוּ הַהוּא אֲשֶׁר פָּקַח עֵינֵי הָעִוֵּר לֹא יָכֹל לַעֲצֹר גַּם אֶת־זֶה מִמָּוֶת׃ ");
INSERT INTO hebsg_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","וְיֵשׁוּעַ בְּמַר נַפְשׁוֹ בָּא אֶל־הַקָּבֶר וְהוּא מְעָרָה וְאֶבֶן שׂוּמָה עַל־פִּיהָ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","וַיֹּאמֶר יֵשׁוּעַ גֹּלּוּ אֶת־הָאָבֶן וַתֹּאמֶר אֵלָיו מַרְתָא אֲחוֹת הַמֵּת אֲדֹנִי הִנֵּה הוּא נִבְאָשׁ כִּי־זֶה לוֹ יָמִים אַרְבָּעָה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","וַיֹּאמֶר אֵלֶיהָ יֵשׁוּעַ הֲלֹא אָמַרְתִּי לָךְ אִם־תַּאֲמִינִי אָז תִּרְאִי אֶת־כְּבוֹד הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","וַיָּגֹלּוּ אֶת־הָאֶבֶן אֲשֶׁר הַמֵּת הוּשַׂם שָׁם וְיֵשׁוּעַ נָשָׂא אֶת־עֵינָיו לַמָּרוֹם וַיֹּאמַר אוֹדְךָ אָבִי כִּי עֲנִיתָנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","וַאֲנִי יָדַעְתִּי כִּי מִדֵּי אֲדַבֵּר אַתָּה תַעֲנֶה אֶפֶס בַּעֲבוּר הָעָם הָעֹמֵד עָלַי דִּבַּרְתִּי כֵן לְבַעֲבוּר יַאֲמִינוּ כִּי אַתָּה שְׁלַחְתָּנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","כְּכַלֹּתוֹ לְדַבֵּר כֵּן וַיִּקְרָא בְקוֹל גָּדוֹל אֶלְעָזָר עוּרָה וָצֵאָה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","וַיֵּצֵא הַמֵּת וְיָדָיו וְרַגְלָיו אֲסוּרוֹת בְּתַכְרִיכִין וּפָנָיו קְשׁוּרִים בְּמִטְפָּחַת וַיֹּאמֶר יֵשׁוּעַ אֲלֵיהֶם הַתִּירֻהוּ וּתְנוּ לוֹ לָלָכֶת׃ ");
INSERT INTO hebsg_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","וְרַבִּים מִן־הַיְּהוּדִים אֲשֶׁר בָּאוּ אֶל־מִרְיָם כִּרְאוֹתָם אֶת־אֲשֶׁר עָשָׂה יֵשׁוּעַ וַיַּאֲמִינוּ־בוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","וּמִקְצוֹתָם הָלְכוּ אֶל־הַפְּרוּשִׁים וַיַּגִּידוּ לָהֶם אֶת־אֲשֶׁר עָשָׂה יֵשׁוּעַ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","וַיַּקְהִילוּ רָאשֵׁי הַכֹּהֲנִים וְהַפְּרוּשִׁים אֶת־הַסַּנְהֶדְרִין וַיֹּאמְרוּ מַה־נַּעֲשֶׂה הֲלֹא הָאִישׁ הַזֶּה עֹשֶׂה מוֹפְתִים רַבִּים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","וְאִם־נֶחְדַּל מִמֶּנּוּ כַּיּוֹם הֲלֹא כֻלָּם יַאֲמִינוּ־בוֹ וּבָאוּ הָרוֹמִיִּים וְלָקְחוּ אֶת־מְקוֹמֵנוּ וְאֶת־עַמֵּנוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","וְאֶחָד מֵהֶם קַיָּפָא שְׁמוֹ אֲשֶׁר הָיָה כֹהֵן גָּדוֹל בַּשָּׁנָה הַהִיא אָמַר אֲלֵיהֶם אַתֶּם לֹא־תָבִינוּ דָבָר׃ ");
INSERT INTO hebsg_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","וְגַם לֹא־תַשְּׂכִּילוּ כִּי טוֹב לָכֶם אֲשֶׁר יָמוּת אִישׁ אֶחָד בְּעַד הָעָם מֵאָבְדַן הָעָם כֻּלּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","וְלֹא מִלִּבּוֹ דִּבֶּר כָּזֹאת כִּי אִם־בִּהְיוֹתוֹ כֹּהֵן גָּדוֹל בַּשָּׁנָה הַהִיא נִבָּא בְפִיו כִּי־יֵשׁוּעַ יָמוּת בְּעַד הָעָם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","וְלֹא־לְבַד בְּעַד הָעָם כִּי אִם־גַּם־לְקַבֵּץ אֶת־בְּנֵי הָאֱלֹהִים הַנְּפֹצִים וְהָיוּ לַאֲחָדִים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","וּמִן־הַיּוֹם הַהוּא נוֹעֲצוּ עָלָיו יַחְדָּו לַהֲמִיתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","וְעַל־כֵּן לֹא־הִתְהַלֵּךְ יֵשׁוּעַ עוֹד בֵּין הַיְּהוּדִים בְּגָלוּי כִּי אִם־נָטָה מִשָּׁם עַד־הַכִּכָּר הַקְּרוֹבָה לַמִּדְבָּר אֶל־עִיר וּשְׁמָהּ אֶפְרָיִם וַיָּגָר־שָׁם עִם־תַּלְמִידָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","וַיִּקְרַב חַג־הַפֶּסַח לַיְּהוּדִים וְרַבִּים מִן־הָאָרֶץ עָלוּ יְרוּשָׁלַיְמָה לִפְנֵי הַפֶּסַח לְהִתְקַדֵּשׁ שָׁמָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","וַיְבַקְשׁוּ אֶת־יֵשׁוּעַ וַיֹּאמְרוּ אִישׁ אֶל־רֵעֵהוּ הָעֹמְדִים בְּבֵית הַמִּקְדָּשׁ מַה־יֶּהְגֶּה לִבְּכֶם הַאִם לֹא־יָבֹא אֶל־הֶחָג׃ ");
INSERT INTO hebsg_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","וְרָאשֵׁי הַכֹּהֲנִים וְהַפְּרוּשִׁים נָתְנוּ פְקֻדָּה כִּי אִם־יֵדַע אִישׁ אֶת־מְקוֹמוֹ אַיּוֹ יָבֹא וְיַגִּיד לְמַעַן יִתְפְּשֻׂהוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","וְשֵׁשֶׁת יָמִים לִפְנֵי חַג־הַפֶּסַח בָּא יֵשׁוּעַ אֶל־בֵּית־עַנְיָה וְשָׁם אֶלְעָזָר הַמֵּת אֲשֶׁר הֶחֱיָה מִן־הַמֵּתִים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","וַיַּעֲשׂוּ־לוֹ שָׁם מִשְׁתֶּה בָּעָרֶב וּמַרְתָא מְשָׁרַת אֹתוֹ וְאֶלְעָזָר הָיָה אֶחָד מִן־הַיֹּשְׁבִים אֶל־הַשֻּׁלְחָן׃ ");
INSERT INTO hebsg_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","וַתִּקַּח מִרְיָם מִרְקַחַת נֵרְדְּ זַךְ וִיקַר־עֵרֶךְ מְאֹד לִטְרָא אַחַת מִשְׁקָלָהּ וַתִּמְשַׁח אֶת־רַגְלֵי יֵשׁוּעַ וּבְשַׂעֲרֹתֶיהָ נִגְּבָה אֶת־רַגְלָיו וְהַבַּיִת מָלֵא רֵיחַ הַמִּרְקָחַת׃ ");
INSERT INTO hebsg_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","וְאֶחָד מִתַּלְמִידָיו הוּא יְהוּדָה בֶּן־שִׁמְעוֹן אִישׁ־קְרִיּוֹת אֲשֶׁר אַחֲרֵי־כֵן הִסְגִּירוֹ אָמַר לֵאמֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","עַל־מֶה לֹא־תִמָּכֵר הַמִּרְקַחַת הַזֹּאת בִּשְׁלֹשׁ מֵאוֹת דִּינָר לָתֵת לָעֲנִיִּים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","וְהוּא דִּבֶּר כָזֹאת לֹא מִדַּאֲגָתוֹ לָעֲנִיִּים רַק יַעַן כִּי־גַנָּב הָיָה וַאֲרוֹן אוֹצָרָם בְּיָדוֹ וְנָשָׂא מֵאֲשֶׁר נָתוּן בּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","וַיֹּאמֶר יֵשׁוּעַ הַנַּח־לָהּ לְיוֹם קְבֻרָתִי הֵכִינָה זֹאת׃ ");
INSERT INTO hebsg_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","כִּי אֶת־הָעֲנִיִּים תִּמְצְאוּ לִפְנֵיכֶם תָּמִיד וְאֹתִי לֹא תִמְצְאוּ תָּמִיד לִפְנֵיכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","וְרַבִּים מִן־הַיְּהוּדִים שָׁמְעוּ כִּי הוּא שָׁם וַיָּבֹאוּ לֹא־בַעֲבוּר יֵשׁוּעַ לְבַדּוֹ כִּי אִם־גַּם־לִרְאוֹת אֶת־אֶלְעָזָר אֲשֶׁר הֶחֱיָה מִן־הַמֵּתִים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","וַיִּוָּעֲצוּ רָאשֵׁי הַכֹּהֲנִים לַהֲרֹג גַּם אֶת־אֶלְעָזָר׃ ");
INSERT INTO hebsg_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","כִּי בִּגְלָלוֹ אָזְלוּ יְהוּדִים רַבִּים וַיַּאֲמִינוּ בְּיֵשׁוּעַ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","וַיְהִי מִמָּחֳרָת כִּשְׁמֹעַ רַבִּים מִן־הָעָם מִן־עוֹלֵי הָרֶגֶל כִּי יֵשׁוּעַ בָּא יְרוּשָׁלָיְמָה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","וַיִּקְחוּ כַפּוֹת תְּמָרִים בְּיָדָם וַיֵּצְאוּ לִקְרָאתוֹ וַיָּרִיעוּ הוֹשַׁע־נָא בָּרוּךְ הַבָּא בְּשֵׁם יְהוָֹה מֶלֶךְ יִשְׂרָאֵל׃ ");
INSERT INTO hebsg_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","וַיִּמְצָא יֵשׁוּעַ עַיִר וַיִּרְכַּב עָלָיו כַּכָּתוּב׃ ");
INSERT INTO hebsg_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","אַל־תִּירְאִי בַּת־צִיּוֹן הִנֵּה מַלְכֵּךְ יָבוֹא לָךְ רֹכֵב עַל־עַיִר בֶּן־אֲתֹנוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","וְכָל־זֹאת לֹא־הֵבִינוּ תַלְמִידָיו בַּתְּחִילָּה אַךְ כַּאֲשֶׁר לֻקַּח יֵשׁוּעַ אַחַר כָּבוֹד זָכְרוּ אָז כִּי־כֹה כָּתוּב עָלָיו וְכֹה גַם־עֲשׂוּ לוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","וְהָעָם אֲשֶׁר הָיוּ אִתּוֹ הֵעִידוּ בְפִיהֶם כִּי קָרָא אֶת־אֶלְעָזָר מִן־קִבְרוֹ וַיְחַיֵּהוּ מִן־הַמֵּתִים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","וְעַל־כֵּן יָצְאוּ הָעָם לִקְרָאתוֹ אַחֲרֵי שָׁמְעָם כִּי עָשָׂה אֶת־הָאוֹת הַזֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","וְהַפְּרוּשִׁים אָמְרוּ אִישׁ אֶל־אָחִיו הַרְאִיתֶם כִּי יְדֵיכֶם לֹא תַעֲשֶׂינָה תּוּשִׁיָּה וְאַחֲרָיו כָּל־אָדָם יִמְשֹׁךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","וּבְתוֹךְ עוֹלֵי הָרֶגֶל לְהִשְׁתַּחֲוֹת נִמְצְאוּ גַּם־יְוָנִים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","וְהֵם בָּאוּ אֶל־פִּילִפּוֹס אִישׁ בֵּית־צַיְדָה מִן־הַגָּלִיל וַיְחַלּוּ אֶת־פָּנָיו לֵאמֹר אֲדֹנֵינוּ חֲפֵצִים אֲנַחְנוּ לִרְאוֹת אֶת־יֵשׁוּעַ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","וַיָּבֹא פִילִפּוֹס וַיַּגֵּד לְאַנְדְּרָי וְאַנְדְּרַי וּפִילִיפּוֹס הִגִּידוּ הַדָּבָר לְיֵשׁוּעַ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","וַיַּעַן אֹתָם יֵשׁוּעַ לֵאמֹר הִנֵּה בָּא הַמּוֹעֵד וּבֶן־הָאָדָם נֶאְדָּר יִהְיֶה בִּכְבוֹדוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","אָמֵן אָמֵן אֲנִי אֹמֵר לָכֶם גַּרְגַּר דָּגָן אִם לֹא־יִפֹּל וָמֵת בְּתוֹךְ הָאָרֶץ יִשָּׁאֵר לְבַדּוֹ וְאִם יָמוּת יוֹצִיא זֶרַע רָב׃ ");
INSERT INTO hebsg_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","הָאֹהֵב אֶת־נַפְשׁוֹ תִּכָּרֶת־לוֹ וְהַשּׂנֵא אֶת־נַפְשׁוֹ בָּעוֹלָם הַזֶּה שְׁמֻרָה תִהְיֶה־לּוֹ לְחַיֵּי עַד׃ ");
INSERT INTO hebsg_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","מִי־הֶחָפֵץ לְשָׁרְתֵנִי יֵלֵךְ בְּעִקְּבוֹתַי וּבַאֲשֶׁר אֶהְיֶה אֲנִי שָׁם יִהְיֶה גַם־מְשָׁרְתִי וְכִי אִישׁ יְשָׁרֵת אֹתִי אֹתוֹ יְכַבֵּד הָאָב׃ ");
INSERT INTO hebsg_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","עַתָּה נִבְהֲלָה נַפְשִׁי וּמָה אֹמַר הַצִּילֵנִי אָבִי מִן־עֵת הַמּוֹעֵד הַזֶּה אַךְ עַל־כֵּן בָּאתִי לַמּוֹעֵד הַזֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","אָבִי גַּדֵּל כְּבוֹד שְׁמֶךָ וְהִנֵּה קוֹל עֹנֶה מִשָּׁמַיִם גִּדַּלְתִּי כְבוֹדוֹ וְגַם־אֲגַדְּלֶנּוּ עוֹד׃ ");
INSERT INTO hebsg_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","וְהָעָם הָעֹמְדִים שָׁם שָׁמְעוּ וְאָמְרוּ קוֹל רַעַם הוּא וְיֵשׁ מֵהֶם אָמְרוּ כִּי מַלְאָךְ דִּבֶּר אֵלָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","וַיַּעַן יֵשׁוּעַ וַיֹּאמַר לֹא לְמַעֲנִי הָיָה הַקּוֹל הַזֶּה כִּי אִם־לְמַעַנְכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","עַתָּה נֶחֱרַץ מִשְׁפַּט הָעוֹלָם הַזֶּה וְשַׂר הָעוֹלָם הַזֶּה נִדְחַף לְמַדְחֵפוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","וַאֲנִי כַּאֲשֶׁר אֶנָּשֵׂא מֵעַל־הָאָרֶץ אֶמְשֹׁךְ כָּל־אָדָם אַחֲרָי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","וְהַמִּלִּין הָאֵלֶּה הוֹצִיא כִּי יִרְזְמוּן בְּאֵיזֶה מָוֶת יָמוּת׃ ");
INSERT INTO hebsg_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","וַיַּעֲנוּ אֹתוֹ הָעָם שָׁמַעְנוּ מִפִּי הַתּוֹרָה כִּי הַמָּשִׁיחַ חַי הוּא לְעוֹלָם וְאֵיךְ תֹּאמַר אַתָּה כִּי נָשׂא יִנָּשֵׂא בֶּן־הָאָדָם מִי הוּא זֶה בֶּן־הָאָדָם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","וַיֹּאמֶר אֲלֵיהֶם יֵשׁוּעַ עוֹד מְעַט מִזְעָר יָאִיר הָאוֹר לְעֵינֵיכֶם לְכוּ לְאוֹרוֹ בְּהִמָּצְאוֹ פֶּן־יְכַסֶּה אֶתְכֶם הַחֹשֶׁךְ וְהַהֹלֵךְ בַּחֹשֶׁךְ יֵלֵךְ אֶל־אֲשֶׁר לֹא יֵדָע׃ ");
INSERT INTO hebsg_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","הַאֲמִינוּ בָאוֹר כָּל־עוֹד הוּא זוֹרֵחַ עֲלֵיכֶם לְמַעַן תִּהְיוּ בְנֵי הָאוֹר וְאַחֲרֵי הַדְּבָרִים הָאֵלֶּה הָלַךְ יֵשׁוּעַ וַיִּסָּתֵר מִפְּנֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","וְהֵם לֹא הֶאֱמִינוּ לוֹ אַף כִּי־עָשָׂה אֹתוֹת רַבִּים לִפְנֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","לְמַלֹּאת דְּבַר יְשַׁעְיָהוּ הַנָּבִיא אֲשֶׁר אָמָר יְהוָֹה מִי הֶאֱמִין לִשְׁמֻעָתֵנוּ וּזְרוֹעַ יְהוָֹה עַל־מִי נִגְלָתָה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","וְעַל־כֵּן לְהַאֲמִין לֹא יָכֹלוּ כִּי יְשַׁעְיָהוּ הוֹסִיף לֵאמֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","הֵשַׁע עֵינֵיהֶם וְהִשְׁמִין אֶת־לְבָבָם פֶּן־יִרְאוּ בְעֵינֵיהֶם וּלְבָבָם יָבִין וְשָׁבוּ וְרִפֵּאתִי לָהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","הַדְּבָרִים הָאֵלֵּה דִּבֵּר יְשַׁעְיָהוּ בַּחֲזוֹתוֹ אֶת־כְּבוֹדוֹ וַיִּנָּבֵא עָלָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","אוּלָם גַּם מִן־הַשָּׂרִים הֶאֱמִינוּ־בוֹ רַבִּים אַךְ בַּעֲבוּר הַפְּרוּשִׁים לֹא הוֹדוּ בְפִיהֶם לְבִלְתִּי יְנֻדּוּ מִתּוֹךְ קְהָלָם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","כִּי כְּבוֹד אֲנָשִׁים יָקָר בְּעֵינֵיהֶם מִכְּבוֹד אֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","וַיִּקְרָא יֵשׁוּעַ וַיֹּאמַר הַמַּאֲמִין בִּי לֹא־בִי הוּא מַאֲמִין כִּי אִם־בְּשֹׁלְחִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","וְהָרֹאֶה אֹתִי הוּא רֹאֶה אֶת־שֹׁלְחִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","וַאֲנִי לְאוֹר בָּאתִי אֶל־הָעוֹלָם אֲשֶׁר כָּל־הַמַּאֲמִין בִּי לֹא יִשְׁכֹּן בַּחֲשֵׁכָה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","וְאִישׁ כִּי יִשְׁמַע אֶת־דְּבָרַי וְלֹא יִשְׁמְרֵם אֲנִי לֹא אֶשְׁפֹּט אֹתוֹ כִּי לֹא־לִשְׁפֹּט אֶת־הָעוֹלָם בָּאתִי כִּי אִם־לְהוֹשִׁיעַ אֶת־הָעוֹלָם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","וְכִי יִמְאַס בִּי אִישׁ וְלֹא יִקַּח אֲמָרַי יֵשׁ שֹׁפֵט אֲשֶׁר־יִשְׁפְּטֶנּוּ הַדָּבָר אֲשֶׁר דִּבַּרְתִּי הוּא יִשְׁפְּטֶנּוּ בַּיּוֹם הָאַחֲרוֹן׃ ");
INSERT INTO hebsg_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","כִּי אֲנִי לֹא מִלִּבִּי דִבַּרְתִּי כִי אִם־הָאָב אֲשֶׁר שְׁלָחַנִי הוּא צִוַּנִי אֶת־אֲשֶׁר אֹמַר וְאֶת־אֲשֶׁר אֲדַבֵּר׃ ");
INSERT INTO hebsg_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","וְיָדַעְתִּי כִּי חַיֵּי עוֹלָם מִצְוָתוֹ וְעַל־כֵּן אֶת־אֲשֶׁר אָמַר אֵלַי הָאָב לְדַבֵּר אֹתוֹ אֶשְׁמֹר לְדַבֵּר׃ ");
INSERT INTO hebsg_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","וַיְהִי לִפְנֵי חַג־הַפֶּסַח וַיֵּדַע יֵשׁוּעַ כִּי בָא זְמָנּוֹ לַעֲלוֹת מִן־הָאָרֶץ אֶל־הָאָב וְאֶת־בְּחִירָיו אֲשֶׁר אָהֵב בָּאָרֶץ מֵאָז כֵּן אֲהֵבָם עַד־אַחֲרִית׃ ");
INSERT INTO hebsg_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","אַחֲרֵי סִיוּם סְעוּדַת הַמִּצְוָה וְאַחֲרֵי אֲשֶׁר נָתַן הַשָּׂטָן בְּלֵב יְהוּדָה בֶּן־שִׁמְעוֹן אִישׁ־קְרִיּוֹת לְהַסְגִּיר אֹתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","וַיֵּדַע יֵשׁוּעַ כִּי הָאָב נָתַן בְּיָדוֹ אֶת־כֹּל וְכִי הוּא מֵאֵת אֱלֹהִים יָצָא וְאֶל־אֱלֹהִים יָשׁוּב׃ ");
INSERT INTO hebsg_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","וַיָּקָם מֵעַל הַשֻּׁלְחָן וַיִּפְשֹׁט אֶת־בְּגָדָיו וַיַּחְגֹּר מִטְפַּחַת עַל־מָתְנָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","וְאַחַר יָצַק מַיִם בְּכִיּוֹר וַיָּחֶל לִרְחֹץ רַגְלֵי תַלְמִידָיו וְלִמְחוֹתָן בַּמִּטְפַּחַת אֲשֶׁר־הוּא חָגוּר בָּהּ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","וַיָּבֹא אֶל־שִׁמְעוֹן פֶּטְרוֹס וְהוּא אָמַר אֵלָיו הַאַתָּה אֲדֹנִי תִּרְחַץ אֶת־רַגְלָי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","וַיַּעַן יֵשׁוּעַ וַיֹּאמֶר אֵלָיו אֵת אֲשֶׁר אֲנִי עֹשֶׂה בָזֶה לֹא־תֵדַע עַתָּה אַךְ אַחֲרֵי־כֵן תַּשְׂכִּיל׃ ");
INSERT INTO hebsg_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","וַיֹּאמֶר אֵלָיו פֶּטְרוֹס לֹא־תִרְחַץ רַגְלַי לְעוֹלָם וַיַּעַן אֹתוֹ יֵשׁוּעַ אִם־לֹא אֶרְחָצְךָ אֵין־לְךָ חֵלֶק עִמָּדִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","וַיֹּאמֶר אֵלָיו שִׁמְעוֹן פֶּטְרוֹס בִּי אֲדֹנִי לֹא לְבַד אֶת־רַגְלַי כִּי אִם־גַּם אֶת־יָדַי וְאֶת־רֹאשִׁי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","וַיֹּאמֶר אֵלָיו יֵשׁוּעַ הַמְרֻחָץ אֵין־לוֹ לִרְחֹץ עוֹד זוּלָתִי אֶת־רַגְלָיו כִּי כֻלּוֹ טָהוֹר הוּא וְאַתֶּם הִנְּכֶם טְהוֹרִים אֲבָל לֹא כֻלְּכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","כִּי יָדַע אֹתוֹ אֲשֶׁר יַסְגִּירֶנּוּ עַל־כֵּן אָמַר לֹא כֻלְּכֶם טְהוֹרִים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","וְאַחֲרֵי אֲשֶׁר רָחַץ אֶת־רַגְלֵיהֶם וְלָבַשׁ אֶת־בְּגָדָיו שָׁב וַיֵּשֶׁב וַיֹּאמֶר אֲלֵיהֶם הַיְדַעְתֶּם מַה־זֹּאת עָשִׂיתִי לָכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","אַתֶּם קֹרִאים־לִי רַבִּי וְאָדוֹן וְהֵיטַבְתֶּם לִקְרֹא־לִי כֵן כִּי־אֲנִי הוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","וְעַל־כֵּן אִם־אֲנִי הָאָדוֹן וְהָרַבִּי רָחַצְתִּי אֶת־רַגְלֵיכֶם עֲלֵיכֶם גַּם־אַתֶּם לִרְחֹץ אִישׁ אִישׁ אֶת־רַגְלֵי אָחִיו׃ ");
INSERT INTO hebsg_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","כִּי אֲנִי הוּא מוֹפֶתְכֶם לְמַעַן תַּעֲשׂוּן גַּם־אַתֶּם כַּאֲשֶׁר עָשִׂיתִי לָכֶם אָנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","אָמֵן אָמֵן אֲנִי אֹמֵר לָכֶם אֵין הָעֶבֶד גָּדוֹל מֵאֲדֹנָיו וְאֵין הַשָּׁלִיחַ רַב מִשֹּׁלְחוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","וְאִם־יְדַעְתֶּם זֹאת אַשְׁרֵיכֶם אִם־כֵּן תַּעֲשׂוּן׃ ");
INSERT INTO hebsg_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","וְלֹא עַל־כֻּלְּכֶם דִּבַּרְתִּי כֵן כִּי יָדַעְתִּי אֶת־אֲשֶׁר בָּחַרְתִּי־בָם אַךְ לְמַעַן יָקוּם הַכָּתוּב אוֹכֵל לַחְמִי הִגְדִּיל עָלַי עֲקֵב׃ ");
INSERT INTO hebsg_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","מֵעַתָּה אֲנִי מַגִּיד לָכֶם דָּבָר טֶרֶם בֹּאוֹ לְמַעַן תַּאֲמִינוּ אַחֲרֵי בֹאוֹ כִּי אֲנִי הוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","אָמֵן אָמֵן אֲנִי אֹמֵר לָכֶם הַמְקַבֵּל אֶת־מִי אֲשֶׁר אֶשְׁלַח פָּנַי הוּא מְקַבֵּל וְהַמְקַבֵּל פָּנַי הוּא מְקַבֵּל פְּנֵי שֹׁלְחִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","וַיְהִי כְּדַבֵּר יֵשׁוּעַ אֶת־הַדְּבָרִים הָאֵלֶּה וַתִּפָּעֶם רוּחוֹ בְקִרְבּוֹ וַיַּגֵּד לָהֶם לֵאמֹר אָמֵן אָמֵן אֲנִי אֹמֵר לָכֶם כִּי אֶחָד מִכֶּם יַסְגִּיר אֹתִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","וַיִּתְרָאוּ הַתַּלְמִידִים פָּנִים בְּפָנִים כִּי לֹא יָדְעוּ עַל־מִי דִבֵּר׃ ");
INSERT INTO hebsg_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","וְאֶחָד מִתַּלְמִידָיו אֲשֶׁר יֵשׁוּעַ אֲהֵבוֹ נִשְׁעַן עַל־חֵיקוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","וַיִּרְמָז־לוֹ שִׁמְעוֹן פֶּטְרוֹס וַיֹּאמֶר אֵלָיו אֱמָר־נָא מִי־הוּא זֶה אֲשֶׁר דִּבֶּר עָלָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","וַיִפֹּל עַל־צַוְּארֵי יֵשׁוּעַ וַיֹּאמֶר אֵלָיו אֲדֹנִי מִי הוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","וַיַּעַן יֵשׁוּעַ זֶה הוּא אֲשֶׁר אֶטְבָּל־לוֹ פְרוּסָה וּנְתַתִּיהָ לּוֹ וַיִּטְבֹּל אֶת־הַפְּרוּסָה וַיִּקָחֶהָ וַיִּתְּנֶהָ אֶל־יְהוּדָה בֶּן־שִׁמְעוֹן אִישׁ־קְרִיּוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","וְאַחֲרֵי אָכְלוֹ אֶת־הַפְּרוּסָה בָּא הַשָּׂטָן אֶל־קִרְבּוֹ וַיֹּאמֶר אֵלָיו יֵשׁוּעַ אֵת אֲשֶׁר־תַּעֲשֶׂה מַהֵר וַעֲשֵׂה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","וְלֹא־יָדַע אִישׁ מִן־הַיֹּשְׁבִים שָׁם בַּמְּסִיבָּה עַל־מֶה דִבֶּר אֵלָיו כָּזֹאת׃ ");
INSERT INTO hebsg_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","כִּי יֵשׁ אֲשֶׁר חָשְׁבוּ בִּהְיוֹת צְרוֹר הַכֶּסֶף בְּיַד יְהוּדָה עַל־כֵּן אָמַר אֵלָיו יֵשׁוּעַ קְנֵה־נָא אֶת־אֲשֶׁר יֶחְסַר לָנוּ לֶחָג אוֹ תְּנָא דָבָר לַעֲנִיִּים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","וְהוּא בְּקַחְתּוֹ אֶת־הַפְּרוּסָה אֶל־פִּיו יָצָא פִתְאֹם וַיְהִי לָיְלָה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","וַיְהִי כַּאֲשֶׁר יָצָא וַיֹּאמֶר יֵשׁוּעַ עַתָּה נֶאְדָּר בֶּן־הָאָדָם בְּכָבוֹד וּבוֹ אֱלֹהִים בְּכָבוֹד נֶאְדָּר׃ ");
INSERT INTO hebsg_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","וֵאלֹהִים הוּא יַאְדִּיר אֹתוֹ בִּכְבוֹדוֹ וְגַם־יָחִישׁ לְהַאְדִּירוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","בָּנַי הַיְקָרִים עוֹד־מְעַט מִזְעָר אֵשֵׁב עִמָּכֶם וְאַתֶּם תְּבַקְשׁוּנִי וְכַאֲשֶׁר אָמַרְתִּי אֶל־הַיְּהוּדִים כִּי אֶל־אֲשֶׁר אֲנִי הֹלֵךְ לֹא תוּכְלוּ לָבֹא שָׁמָּה כֵּן אֲנִי אֹמֵר עַתָּה גַּם־אֲלֵיכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","הִנֵּה מִצְוָה חֲדָשָׁה אֲנִי נֹתֵן לָכֶם לְאַהֲבָה אִישׁ אֶת־רֵעֵהוּ כַּאֲשֶׁר אָהַבְתִי אֶתְכֶם כֵּן גַּם־אַתֶּם אִישׁ אֶת־רֵעֵהוּ תֶּאֱהָבוּן׃ ");
INSERT INTO hebsg_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","בָּזֹאת יֵדְעוּ כֻלָּם כִּי תַּלְמִידַי אַתֶּם אִם אַהֲבַת רֵעִים תָּלִין בֵּינֵיכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","וַיֹּאמֶר אֵלָיו שִׁמְעוֹן פֶּטְרוֹס אֲדֹנִי אָנָה אַתָּה הֹלֵךְ וַיַּעַן יֵשׁוּעַ אֶל־אֲשֶׁר אֲנִי הֹלֵךְ לֹא־תוּכַל לָלֶכֶת אַחֲרַי כַּיּוֹם אַךְ הִנֵּה יָמִים בָּאִים וְהָלַכְתָּ אַחֲרָי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","וַיֹּאמֶר אֵלָיו פֶטְרוֹס אֲדֹנִי עַל־מֶה לֹא־אוּכַל לָלֶכֶת אַחֲרֶיךָ כַּיּוֹם הֲלֹא אֶת־נַפְשִׁי אֶתֵּן בַּעֲדֶךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","וַיַּעַן יֵשׁוּעַ הֲתִתֵּן אֶת־נַפְשְׁךָ בַּעֲדִי אָמֵן אָמֵן אֲנִי אֹמֵר לָךְ לֹא יִקְרָא הַתַּרְנְגֹל עַד־אֲשֶׁר תְּכַחֶשׁ־בִּי שָׁלֹשׁ פְּעָמִים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","אַל־יֵחַת לִבְּכֶם הַאֲמִינוּ בֵאלֹהִים וּכְמוֹ־כֵן הַאֲמִינוּ בִּי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","מְעוֹנוֹת רַבּוֹת נִמְצָאוֹת בְּבֵית אָבִי כִּי לוּלֵא כֵן הָיִיתִי מַגִּיד לָכֶם וַאֲנִי הֹלֵךְ לְהָכִין לָכֶם מָקוֹם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","וְאַחֲרֵי אֲשֶׁר אֵלֵךְ וְאָכִין מָקוֹם לָכֶם שׁוֹב אָשׁוּב וְלָקַחְתִּי אֶתְכֶם אֵלָי לְמַעַן תִּהְיוּ עִמִּי שָׁם בַּאֲשֶׁר אֶהְיֶה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","וְאַתֶּם יְדַעְתֶּם אָנָא אֲנִי הֹלֵךְ וְגַם אֶת־הַדֶּרֶךְ יְדַעְתֶּם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","וַיֹּאמֶר אֵלָיו תּוֹמָא אֲדֹנִי לֹא יָדַעְנוּ אָנָה אַתָּה הֹלֵךְ וְאֵיכָה נֵדַע אֶת־הַדָּרֶךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","וַיֹּאמֶר אֵלָיו יֵשׁוּעַ אָנֹכִי הַדֶּרֶךְ וְהָאֱמֶת וְהַחַיִּים וְאִישׁ לֹא־יָבֹא אֶל־הָאָב בִּלְתִּי עַל־יָדִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","לוּ אֹתִי יְדַעְתֶּם יְדַעְתֶּם גַּם אֶת־אָבִי וּמֵעַתָּה יְדַעְתֶּם אֹתוֹ וְגַם־רְאִיתֶם אֹתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","וַיֹּאמֶר אֵלָיו פִילִפּוֹס אֲדֹנִי הַרְאֵנוּ נָא אֶת־הָאָב וְרַב לָנוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","וַיֹּאמֶר אֵלָיו יֵשׁוּעַ הֲלֹא יָמִים רַבִּים הָיִיתִי עִמָּכֶם הֲטֶרֶם תֵּדַע אֹתִי פִּילִפּוֹס הָרֹאֶה אֹתִי רֹאֶה אֶת־הָאָב וְלָמָּה־זֶּה תֹאמַר הַרְאֵנוּ אֶת־הָאָב׃ ");
INSERT INTO hebsg_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","הֲכִי לֹא תַאֲמִין כִּי אֲנִי בָאָב וְהָאָב בִּי הַדְּבָרִים אֲשֶׁר אֲנִי דֹבֵר אֲלֵיכֶם לֹא־מִלִּבִּי אֲנִי דֹבֵר כִּי הָאָב הַשֹּׁכֵן בִּי הוּא פֹעֵל בִּי פְּעֻלּוֹתָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","הַאֲמִינוּ לִי כִּי־אֲנִי בָאָב וְהָאָב בִּי וְאִם־לֹא הַאֲמִינוּ לִי בִּגְלַל הַפְּעֻלּוֹת הָאֵלֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","אָמֵן אָמֵן אֲנִי אֹמֵר לָכֶם הַמַּאֲמִין בִּי אֶת־הַמַּעֲשִׂים אֲשֶׁר אֲנִי עֹשֶׂה יַעֲשֶׂה גַם־הוּא וּגְדֹלוֹת מֵאֵלֶּה יַעֲשֶׂה כִּי אֶל־אָבִי אָנֹכִי הֹלֵךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","וְכָל־אֲשֶׁר תִּשְׁאֲלוּ בִשְׁמִי אֹתוֹ אֶעֱשֶׂה לְבַעֲבוּר יִגְדַּל כְּבוֹד הָאָב בִּבְנוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","כָּל־דָּבָר אֲשֶׁר תִּשְׁאֲלוּ בִשְׁמִי אֲנִי אֶעֱשֶׂנּוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","אִם־אֲהַבְתֶּם אֹתִי אֶת־מְִֹצתַי תִּשְׁמֹרוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","וַאֲנִי אֲחַלֶּה פְנֵי הָאָב וְיִתֵּן לָכֶם מֵלִיץ אַחֵר אֲשֶׁר־יִשְׁכֹּן אִתְּכֶם עֲדֵי־עַד׃ ");
INSERT INTO hebsg_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","הֲלֹא הוּא רוּחַ הָאֱמֶת אֲשֶׁר הָעוֹלָם לֹא־יָכֹל לְקַבְּלוֹ בַּאֲשֶׁר לֹא יִרְאֶנּוּ וְלֹא יֵדָעֶנּוּ וְאַתֶּם יְדַעְתֶּם אֹתוֹ כִּי הוּא שֹׁכֵן אִתְּכֶם וְאַף־הָיֹה יִהְיֶה בְּתוֹכְכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","וַאֲנִי לֹא אֶעֱזָבְכֶם יְתוֹמִים כִּי בֹא אָבֹא אֲלֵיכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","עוֹד מְעַט מִזְעָר וְהָעוֹלָם לֹא יוֹסִיף לִרְאוֹת אֹתִי וְאַתֶּם תִּרְאֻנִי כִּי־אֲנִי חַי וְכֵן גַּם־אַתֶּם תִּחְיוּן׃ ");
INSERT INTO hebsg_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","בַּיּוֹם הַהוּא תֵּדְעוּ כִּי־אֲנִי בְאָבִי וְאַתֶּם בִּי וַאֲנִי בָכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","מִי אֲשֶׁר מִצְוֹתַי אִתּוֹ וְשֹׁמֵר לַעֲשׂוֹתָן זֶה הוּא אֲשֶׁר יֶאֱהָבַנִי וְאֹהֲבִי אָהוּב לְאָבִי וַאֲנִי אֹהֲבֵהוּ וְאֵלָיו אֶתְוַדָּע׃ ");
INSERT INTO hebsg_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","וַיֹּאמֶר אֵלָיו יְהוּדָה לֹא אִישׁ־קְרִיּוֹת וְאֵיכָה אֲדֹנִי תִּקְרֶינָה כָאֵלֶּה כִּי תָבֹא לְהִתְוַדַּע אֵלֵינוּ וְלֹא לָעוֹלָם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","וַיַּעַן יֵשׁוּעַ וַיֹּאמֶר אֵלָיו אִישׁ כִּי יֶאֱהָבַנִי יִשְׁמֹר אֶת־דְּבָרַי וְאָבִי יֶאֱהַב אֹתוֹ וְאֵלָיו נָבֹא וְשָׁכַנּוּ אִתּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","וְאִישׁ אֲשֶׁר לֹא יֶאֱהָבַנִי הוּא לֹא יִשְׁמֹר אֶת־דְּבָרָי וְהַדְּבָרִים אֲשֶׁר שְׁמַעְתֶּם לֹא מִלִּבִּי יָצָאוּ כִּי אִם־מִפִּי הָאָב אֲשֶׁר שְׁלָחָנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","אֶת־אֵלֶּה דִּבַּרְתִּי אֲלֵיכֶם בְּעוֹד שִׁבְתִּי עִמָּכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","וְהַמֵּלִיץ הוּא רוּחַ הַקֹּדֶשׁ אֲשֶׁר־יִשְׁלָחֵהוּ הָאָב בִּשְׁמִי יְלַמֶּדְכֶם אֶת־כֹּל וְאָז תִּזְכְּרוּ כֹּל אֲשֶׁר־הִגַּדְתִּי לָכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","וְעַתָּה שָׁלוֹם אֲנִי מַנִּיחַ לָכֶם אֶת־שְׁלוֹמִי אֲנִי נֹתֵן לָכֶם לֹא כַאַשֶׁר יִתֵּן הָעוֹלָם אֲנִי נֹתֵן לָכֶם אַל־יִרְגַּז לִבְּכֶם וְאַל־יֵחָת׃ ");
INSERT INTO hebsg_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","הֲלֹא שְׁמַעְתֶּם אֵת אֲשֶׁר־אָמַרְתִּי אֲלֵיכֶם כִּי אֵלֵךְ מִכֶּם וְעוֹד אֲשׁוּב אֲלֵיכֶם לוּ אֲהַבְתֶּם אֹתִי הֱיִיתֶם שְׂמֵחִים בְּאָמְרִי לָכֶם כִּי־הֹלֵךְ אֲנִי אֶל־הָאָב כִּי הָאָב גָּדוֹל מִמֶּנִּי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","וְעַתָּה הִגַּדְתִּי לָכֶם הַדָּבָר טֶרֶם בֹּאוֹ לְבַעֲבוּר תַּאֲמִינוּ אַחֲרֵי בֹאוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","וַאֲנִי לֹא־אוּכַל עוֹד לְהַרְבּוֹת אֲמָרִים עִמָּכֶם מִפְּנֵי שַׂר־הָעוֹלָם אֲשֶׁר יָבֹא וְהוּא אֵין־לוֹ חֵלֶק בִּי כָּל־מְאוּמָה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","רַק לְבַעֲבוּר יֵדַע הָעוֹלָם כִּי אֲנִי אֹהֵב אֶת־הָאָב וְעֹשֶׂה אֲנִי כְּכֹל אֲשֶׁר צִוַּנִי הָאָב לְכוּ וְנֵלְכָה מִזֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","אָנֹכִי הַגֶּפֶן גֶּפֶן אֱמֶת וְאָבִי הַכֹּרֵם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","כָּל־זְמוֹרָה מִמֶּנִּי אֲשֶׁר לֹא תַעֲשֶׂה עֲנָבִים יְכְרְתֶנָּה וַאֲשֶׁר תַּעֲשֶׂה עֲנָבִים יְקַיְמֶנָּה לְהַרְבּוֹת אֶת־פִּרְיָהּ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","וְאַתֶּם זַכִּים הִנְּכֶם כַּיּוֹם עַל־פִּי דְבָרַי אֲשֶׁר דִּבַּרְתִּי אֲלֵיכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","הֱיוּ דְבֵקִים בִּי וַאֲנִי בָכֶם כִּי כַּאֲשֶׁר הַזְּמֹרָה פְּרִי בַל־תַּעֲשֶׂה מֵאֵלֶיהָ אִם־לֹא דָבְקָה בַגָּפֶן כֵּן גַּם־אַתֶּם אִם־לֹא תִדְבְּקוּן בִּי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","אֲנֹכִי הַגֶּפֶן וְאַתֶּם הַזְּמֹרוֹת הַדָּבֵק בִּי וְאֲנִי בוֹ הוּא יְשַׁוֶּה רֹב פֶּרִי כִּי בִּלְעָדַי לֹא תוּכְלוּ עֲשׂוֹת מְאוּמָה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","מִי אֲשֶׁר לֹא יִדְבַּק בִי יַשְׁלִיכֻהוּ כְּנֵצֶר אֲשֶׁר יִיבָשׁ וּמְקֹשֵׁשׁ יְקֹשְׁשֶׁנּוּ וּנְתָנוֹ לָאֵשׁ וְהָיָה לְבָעֵר׃ ");
INSERT INTO hebsg_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","אִם־בִּי אַתֶּם דְּבֵקִים וּדְבָרַי שְׁמֻרִים בָּכֶם תִּשְׁאֲלוּ וְיֵעָשֶׂה לָכֶם כְּכָל־מִשְׁאֲלוֹת לִבְּכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","בְּזֹאת יִגְדַּל כְּבוֹד אָבִי כִּי־תַעֲשׂוּ רֹב פֶּרִי וִהְיִיתֶם לִי לְתַלְמִידִים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","כַּאֲשֶׁר אֲהַב אֹתִי הָאָב כֵּן אָהַבְתִּי אֶתְכֶם חֲסוּ בְאַהֲבָתִי תָּמִיד׃ ");
INSERT INTO hebsg_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","אִם אֶת־מִצְוֹתַי תִּשְׁמְרוּ תֶּחֱסוּ בְאַהֲבָתִי תָּמִיד כַּאֲשֶׁר גַּם־אֲנֹכִי מִצְוֹת אָבִי שָׁמַרְתִּי וְאֶחֱסֶה בְאַהֲבָתוֹ תָּמִיד׃ ");
INSERT INTO hebsg_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","אֶת־הַדְּבָרִים הָאֵלֶה דִּבַּרְתִּי אֲלֵיכֶם לְבַעֲבוּר תִּהְיֶה שִׂמְחָתִי עֲלֵיכֶם וְשִׂמְחַתְכֶם תִּמָּלֵא נַפְשֵׁכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","וְזֹאת הִיא מְצְוָתִי לְאַהֲבָה אִישׁ אֶת־אָחִיו כַּאֲשֶׁר אֲנֹכִי אָהַבְתִּי אֶתְכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","אֵין לְאִישׁ אַהֲבָה רַבָּה מֵאֲשֶׁר אִם יִתֵּן אֶת־נַפְשׁוֹ בְּעַד יְדִידָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","וְאַתֶּם יְדִידַי הִנְּכֶם רַק אִם־תַּעֲשׂוּ אֵת אֲשֶׁר־אֲנֹכִי מְצַוֶּה אֶתְכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","לֹא עוֹד עֲבָדִים אֶקְרָא לָכֶם כִּי הָעֶבֶד אֵינֶנּוּ יֹדֵעַ אֶת־אֲשֶׁר אֲדֹנָיו עֹשֶׂה אַךְ לָכֶם קָרָאתִי יְדִידַי כִּי הוֹדַעְתִּי אֶתְכֶם כֹּל אֲשֶׁר שָׁמַעְתִּי מִפִּי אָבִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","לֹא אַתֶּם בְּחַרְתֶּם בִּי רַק־אֲנִי בָּחַרְתִּי בָּכֶם וַאֲנִי מִנִּיתִי אֶתְכֶם לָלֶכֶת וְלַעֲשׂוֹת פֶּרִי וּפֶרְיְכֶם יַעֲמֹד לָעַד וְכָל־דָּבָר אֲשֶׁר תִּשְׁאֲלוּ מֵאֵת הָאָב בִּשְׁמִי אֹתוֹ יִתֵּן לָכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","וְזֹאת הִיא הַמִּצְוָה אֲשֶׁר אֲנִי מְצַוֶּה אֶתְכֶם כִּי אִישׁ אֶת־רֵעֵהוּ תֶּאֱהָבוּן׃ ");
INSERT INTO hebsg_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","אִם־הָעוֹלָם יִשְׂנָא אֶתְכֶם הֲלֹא יְדַעְתֶּם כִּי אֹתִי שָׂנֵא לִפְנֵיכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","לוּ הֱיִיתֶם מִן־הָעוֹלָם הָעוֹלָם יֶאֱהַב אֵת אֲשֶׁר־לוֹ אַךְ יַעַן כִּי־אֵין אַתֶּם מִן־הָעוֹלָם וַאֲנִי בָחַרְתִּי בָכֶם מִן־הָעוֹלָם עַל־כֵּן יִשְׂנָא אֶתְכֶם הָעוֹלָם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","זִכְרוּ אֶת־הַדָּבָר אֲשֶׁר אָמַרְתִּי לָכֶם הָעֶבֶד אֵינֶנּוּ גָדוֹל מֵאֲדֹנָיו אִם־רָדְפוּ אֹתִי גַּם־אֶתְכֶם יִרְדֹּפוּ אִם־שָׁמְרוּ אֶת־דְּבָרַי גַּם אֶת־דִּבְרֵיכֶם יִשְׁמֹרוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","אֲבָל כָּל־אֵלֶּה יַעֲשׂוּ לָכֶם בַּעֲבוּר שְׁמִי כִּי אֵינָם יֹדְעִים אֶת־שֹׁלְחִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","לוּלֵי בָאתִי וְהִגַּדְתִּי לָהֶם לֹא הוּשַׁת עֲלֵיהֶם חֵטְא אֲבָל עַתָּה אֵין מַעֲנֶה בְּפִיהֶם עַל־חַטֹּאתָם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","הַשּׂנֵא אֹתִי הוּא שׂנֵא גַּם־אֶת־אָבִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","לוּלֵי עָשִׂיתִי לִפְנֵיהֶם הַמַּעֲשִׂים אֲשֶׁר לֹא עֲשָׂה אִישׁ אַחֵר לֹא־הוּשַׁת עֲלֵיהֶם חֵטְא אֲבָל עַתָּה רָאוּ אֶת־מַעֲשַׂי וַיִּשְׂנְאוּ גַם־אֹתִי וְגַם אֶת־אָבִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","אַךְ לְמַלֹּאת הַדָּבָר הַכָּתוּב בְּתוֹרָתָם וְשִׂינְאַת חִנָּם שְׂנֵאוּנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","אַךְ כַּאֲשֶׁר יָבֹא הַמֵּלִיץ אֲשֶׁר אֶשְׁלָחֶנּוּ אֲלֵיכֶם מֵאֵת הָאָב הֲלֹא הוּא רוּחַ הָאֱמֶת הַיֹּצֵא מִמְּקוֹר הָאָב הוּא יָעֶד־לִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","וְגַם־אַתֶּם תָּעִידוּ לִי כִּי הֱיִיתֶם עִמָּדִי מֵרֹאשׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","אֶת־אֵלֶּה דִּבַּרְתִּי אֲלֵיכֶם לְמַעַן לֹא תִכָּשֵׁלוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","הֵם יְנַדּוּ אֶתְכֶם מִתּוֹךְ הַקָּהָל וְאַף הִגִּיעַ הַזְּמָן אֲשֶׁר כָּל־הֹרֵג אֶתְכֶם יַחֲשֹׁב בְּלִבּוֹ כִּי קָרְבָּן הוּא מַקְרִיב לֵאלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","וְאֶת־אֵלֶּה יַעֲשׂוּ לָכֶם כִּי גַּם־אֶת־אָבִי וְגַם־אֹתִי לֹא יָדָעוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","וָאַגִּיד לָכֶם אֶת־אֵלֶּה לְמַעַן תִּזְכְּרוּ אֹתָם בְּעִתָּם כִּי אֲנִי הַמְדַבֵּר אֲלֵיכֶם וְלֹא הִקְדַּמְתִּי לְהַגִּיד לָכֶם כָּל־זֶה מֵרֹאשׁ בַּעֲבוּר כִּי הָיִיתִי עִמָּכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","וְעַתָּה הִנְּנִי הֹלֵךְ אֶל־שֹׁלְחִי וְאֵין עוֹד אִישׁ מִכֶּם שֹׁאֵל אֹתִי אָנָה אַתָּה הֹלֵךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","רַק לִבְּכֶם מָלֵא עֶצֶב בְּדַבְּרִי אֲלֵיכֶם הַדְּבָרִים הָאֵלֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","אוּלָם אֱמֶת אַגִּיד לָכֶם כִּי טוֹב לָכֶם אֲשֶׁר אֵלֵךְ כִּי אִם־לֹא אֵלֵךְ לֹא־יָבֹא הַמֵּלִיץ אֲלֵיכֶם וְכִי־אֵלֵךְ אֶשְׁלָחֶנּוּ אֲלֵיכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","וְהוּא בְּבֹאוֹ יוֹכַח אֶת־הָעוֹלָם עַל־דְּבַר חֵטְא צְדָקָה וּמִשְׁפָּט׃ ");
INSERT INTO hebsg_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","עַל־חֵטְא עַל־אֲשֶׁר לֹא הֶאֱמִינוּ בִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","עַל־צְדָקָה עַל־כִּי הֹלֵךְ אֲנִי אֶל־אָבִי וְלֹא תִרְאֻנִי עוֹד׃ ");
INSERT INTO hebsg_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","וְעַל־מִשְׁפָּט עַל־כִּי יַרְשִׁיעַ אֶת־שַׂר הָעוֹלָם הַזֶּה בְּהִשָּׁפְטוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","וְעוֹד לִי מִלִּין רַבּוֹת לְהוֹדִיעֲכֶם אַךְ לֹא־תוּכְלוּ שְׂאֵת אוֹתָן כַּיּוֹם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","וְרוּחַ הָאֱמֶת בְּבֹאוֹ יַנְחֶה אֶתְכֶם אֶל־הָאֱמֶת כֻּלָּהּ כִּי לֹא מִלִּבּוֹ יְדַבֵּר כִּי אִם אֶת־אֲשֶׁר יִשְׁמַע יַשְׁמִיעַ וְיַגִּיד אֶת־הָאֹתִיּוֹת לְאָחוֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","הוּא יְגַדֵּל כְּבוֹדִי כִּי יִקַּח מִשֶּׁלִּי וְהִגִּיד לָכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","כֹּל אֲשֶׁר לְאָבִי לִי הוּא עַל־כֵּן אָמַרְתִּי מִשֶּׁלִּי יִקַּח וְהִגִּיד לָכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","עוֹד כִּמְעַט רֶגַע וְלֹא תִרְאֻנִי עוֹד וְעוֹד כִּמְעַט רֶגַע וְתִרְאֻנִי כִּי אֲנִי הֹלֵךְ אֶל־אָבִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","וְיֵשׁ מִתַּלְמִידָיו אֲשֶׁר נִדְבְּרוּ אָז אִישׁ אֶל־רֵעֵהוּ מַה־זֶּה אֲשֶׁר אָמַר אֵלֵינוּ עוֹד כִּמְעַט רֶגַע וְלֹא תִרְאוּנִי וְעוֹד כִּמְעַט רֶגַע וְתִרְאוּנִי וְכִי אֲנִי הֹלֵךְ אֶל־הָאָב׃ ");
INSERT INTO hebsg_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","וַיֹּאמְרוּ מַה־זֶּה כִּמְעַט רֶגַע אֲשֶׁר אָמַר וַאֲנַחְנוּ לֹא נֵדַע מָה הוּא מְדַבֵּר׃ ");
INSERT INTO hebsg_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","וַיַּרְא יֵשׁוּעַ כִּי מְבַקְשִׁים הֵם לִשְׁאֹל אֶת־פִּהוּ וַיֹּאמֶר אֲלֵיהֶם הֲתַחְקְרוּן זֶה אֶת־זֶה עַל כִּי־אָמַרְתִּי עוֹד כִּמְעַט רֶגַע וְלֹא תִרְאֻנִי וְעוֹד כִּמְעַט רֶגַע וְתִרְאֻנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","אָמֵן אָמֵן אֲנִי אֹמֵר לָכֶם כִּי אַתֶּם תִּבְכּוּ וְתֵילִילוּ וּבְנֵי הָעוֹלָם יָגִילוּ אַתֶּם תִּתְאַבְּלוּ אַךְ אֶבְלְכֶם יֵהָפֵךְ לְשָׂשׂוֹן׃ ");
INSERT INTO hebsg_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","אִשָּׁה תָּחִיל בַּחֲבָלֶיהָ כִּי בָאָה עִתָּהּ וְאַחֲרֵי אֲשֶׁר הִמְלִיטָה אֶת־הַוָּלָד לֹא־תִזְכֹּר עוֹד חֶבְלָהּ מִשִּׂמְחָתָהּ כִּי־אִישׁ נוֹלַד בָּעוֹלָם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","וְגַם־אַתֶּם מְלֵאִים יָגוֹן כַּיּוֹם אַךְ עוֹד אָשׁוּב אֶרְאֶה אֶתְכֶם וְשָׂשׂ לִבְּכֶם וְשִׂמְחַתְכֶם לֹא־יִקַּח מִכֶּם גָּבֶר׃ ");
INSERT INTO hebsg_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","וּבַיּוֹם הַהוּא לֹא תִשְׁאֲלוּ לִי כָּל־שְׁאֵלָה אָמֵן אָמֵן אֲנִי אֹמֵר לָכֶם אִם תְּבַקְשׁוּ דָבָר מֵאֵת הָאָב יִתֵּן לָכֶם בִּשְׁמִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","עַד־עַתָּה לֹא־בִקַּשְׁתֶּם דָּבָר בִּשְׁמִי בַּקְּשׁוּ וְתִקְחוּ וְנַפְשְׁכֶם תִּמָּלֵא שִׂמְחָה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","אֶת־אֵלֶּה בִּמְשָׁלִים דִּבַּרְתִּי אֲלֵיכֶם אַךְ הִגִּיעַ הַמּוֹעֵד וְלֹא אֲדַבֵּר אֲלֵיכֶם עוֹד בִּמְשָׁלִים כִּי אִם־בְּמִלִּים בְּרֻרוֹת אַגֵּדְכֶם עַל־דְּבַר הָאָב׃ ");
INSERT INTO hebsg_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","בַּיּוֹם הַהוּא מִשְׁאֲלוֹתֵיכֶם בִּשְׁמִי תִּשְׁאָלוּ וְאֵינֶנִּי אֹמֵר לָכֶם כִּי אֲנִי אַעְתִּיר בַּעַדְכֶם אֶל־הָאָב׃ ");
INSERT INTO hebsg_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","כִּי־הָאָב גַּם־הוּא אֹהֵב אֶתְכֶם עֵקֶב אֲשֶׁר אֲהַבְתֶּם אֹתִי וַתַּאֲמִינוּ כִּי־מֵאֵת הָאָב יָצָאתִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","יָצָאתִי מֵאֵת הָאָב וּבָאתִי בָעוֹלָם וְעַתָּה אָשׁוּב אֶעֱזֹב אֶת־הָעוֹלָם וְאֵלֶךְ־לִי אֶל־הָאָב׃ ");
INSERT INTO hebsg_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","וַיֹּאמְרוּ תַלְמִידָיו הִנְּךָ מְדַבֵּר עַתָּה בְּמִלִּים בְּרֻרוֹת וְלֹא תַבִּיע מָשָׁל׃ ");
INSERT INTO hebsg_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","עַתָּה יָדַעְנוּ כִּי־אַתָּה יֹדֵעַ כֹּל וְאֵין מַחְסֹר לְךָ אֲשֶׁר יִשְׁאָלְךָ אִישׁ בָּזֹאת נַאֲמִין כִּי מֵאֵת אֱלֹהִים יָצָאתָ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","וַיַּעַן אֹתָם יֵשׁוּעַ הֲכִי תַאֲמִינוּ עָתָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","הִנֵּה הַזְּמָן בָּא וּכְבָר הִגִּיעַ כִּי־תָפוּצוּ אִישׁ אִישׁ לִבֵיתוֹ וְאֹתִי תַעַזְבוּ לְבַדִּי אַךְ אֵינֶנִּי לְבַדִּי כִּי אָבִי עִמָּדִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","וַאֲנִי בַּדְּבָרִים הָאֵלֶּה בָּאתִי לְהַגִּיד לָכֶם כִּי בִי שָׁלוֹם יִהְיֶה־לָכֶם בָּעוֹלָם צָרָה תְּבוֹאַתְכֶם אַךְ־הִתְאַזְּרוּ עֹז אֲנִי נִצַּחְתִּי אֶת־הָעוֹלָם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","אֶת־אֵלֶּה דִּבֶּר יֵשׁוּעַ וַיִּשָּׂא עֵינָיו לַמָּרוֹם וַיֹּאמַר אֲבִי גַּדֵּל כְּבוֹד בִּנְךָ כִּי בָא מוֹעֵד וּבִנְךָ יְגַדֵּל כְּבוֹדֶךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","כַּאֲשֶׁר אַתָּה תַמְשִׁילֵהוּ בְּכָל־בָשָׂר לָתֵת חַיֵּי עוֹלָם לְכֹל אֲשֶׁר־נָתַתָּה לּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","וּמַה חַיֵּי עוֹלָם אֲשֶׁר יֵדְעוּ אֹתְךָ כִּי אַתָּה לְבַדְּךָ אֶל־אֱמֶת וְאֶת־יֵשׁוּעַ הַמָּשִׁיחַ אֲשֶׁר שָׁלָחְתָּ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","אֶת־כְּבוֹדְךָ גִּדַּלְתִּי בָאָרֶץ כִּלִּיתִי אֶת־הַמְּלָאכָה אֲשֶׁר נָתַתָּה לִּי לַעֲשׂתָהּ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","וְעַתָּה כַּבְּדֵנִי־נָא עִמְּךָ אָבִי בַּכָּבוֹד אֲשֶׁר הָיָה־לִי עִמְּךָ טֶרֶם נַעֲשׂוּ שָׁמַיִם וָאָרֶץ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","הוֹדַעְתִּי אֶת־שִׁמְךָ לַאֲנָשִׁים אֲשֶׁר אֹתָם נָתַתָּה־לִּי מִן־הָעוֹלָם לְךָ הָיוּ וְאַתָּה נְתַתָּם לִי וְהֵם אִמְרָתְךָ יִנְצֹרוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","יֹדְעִים הֵם כַּיּוֹם כִּי־כֻלָּם אֲשֶׁר נָתַתָּה לִּי מֵאִתְּךָ הֵמָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","כִּי שַׂמְתִּי לִפְנֵיהֶם אֶת־הַדְּבָרִים אֲשֶׁר שַׂמְתָּ בְּפִי וְהֵם שָׁמְעוּ וַיַּכִּירוּ בֶאֱמֶת כִּי מֵאִתְּךָ יָצָאתִי וַיַּאֲמִינוּ כִּי אַתָּה שְׁלַחְתָּנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","וַאֲנִי בַּעֲדָם מַפְגִּיעַ לֹא בְעַד הָעוֹלָם אֶפְגַּע בְּךָ כִּי אִם־בְּעַד אֵלֶּה אֲשֶׁר נָתַתָּה לִּי כִּי־לְךָ הֵמָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","וְכָל־שֶׁלִּי שֶׁלָּךְ וְשֶׁלָּךְ שֶׁלִּי אֲשֶׁר בָּם אֶתְפָּאָר׃ ");
INSERT INTO hebsg_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","לֹא אֲגוּר עוֹד בָּאָרֶץ וְהֵם גָּרִים בָּאָרֶץ וַאֲנִי בָא אֵלֶיךָ אָבִי קְדֹשִׁי שְׁמֹר בְּשִׁמְךָ אֶת־אֵלֶּה אֲשֶׁר נָתַתָּה לִּי לְמַעַן יִהְיוּ אֶחָד כָּמֹנוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","בִּהְיוֹתִי עִמָּהֶם בָּעוֹלָם שָׁמַרְתִּי אֹתָם בִּשְׁמֶךָ כֹּל אֲשֶׁר נָתַתָּה לִּי שָׁמַרְתִּי וְלֹא־אָבַד אֶחָד מֵהֶם זוּלָתִי בֶּן־הָאֲבַדּוֹן לְמַלֹּאת דְּבַר־הַכָּתוּב׃ ");
INSERT INTO hebsg_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","וְעַתָּה הִנְנִי בָא אֵלֶיךָ וְהַדְּבָרִים הָאֵלֶּה דִּבַּרְתִּי בָאָרֶץ לְמַלֹּאת נַפְשָׁם שִׂמְחָתִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","אֲנִי נָתַתִּי לָהֶם דְּבָרְךָ וְהָעוֹלָם שׂנֵא אֹתָם יַעַן כִּי לֹא מִן־הָעוֹלָם הֵם כַּאֲשֶׁר גַּם־אֲנִי לֹא מִן־הָעוֹלָם אָנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","וַאֲנִי אֵינֶנִּי מַפְגִּיעַ בַּעֲדָם כִּי תִקָּחֵם מִן־הָעוֹלָם רַק כִּי אִם־תַּצִּילֵם מִן־הָרָע׃ ");
INSERT INTO hebsg_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","לֹא מִן־הָעוֹלָם הֵם כַּאֲשֶׁר גַּם־אֲנִי לֹא מִן־הָעוֹלָם אָנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","קַדֵּשׁ אֹתָם בַּאֲמִתֶּךָ דְּבָרְךָ אֱמֶת׃ ");
INSERT INTO hebsg_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","כַּאֲשֶׁר אַתָּה שְׁלַחְתַּנִי בָעוֹלָם כֵּן אֲנִי שְׁלַחְתִּים בָּעוֹלָם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","וּבַעֲדָם הִקְדַּשְׁתִּי אֶת־נַפְשִׁי וְכֵן גַּם־הֵם אֶת־נַפְשָׁם בֶּאֱמֶת יַקְדִּישׁוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","אוּלָם לֹא בְּעַד־אֵלֶּה לְבַדָּם אֲנִי מַעְתִּיר לָךְ כִּי אִם־גַּם־בְּעַד אֵלֶּה אֲשֶׁר יַאֲמִינוּ בִי עַל־פִּי דְבָרָם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","לְמַעַן יִהְיוּ כֻלָּם לְאֶחָד כַּאֲשֶׁר אַתָּה אָבִי בִּי וַאֲנִי בָּךְ כֵּן יִהְיוּ גַם־הֵם בָּנוּ לְבַעֲבוּר יַאֲמִין הָעוֹלָם כִּי אַתָּה שְׁלַחְתָּנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","וַאֲנִי נָתַתִּי לָהֶם אֶת־הַכָּבוֹד אֲשֶׁר נָתָתָּה לִּי לְבַעֲבוּר יִהְיוּ לְאֶחָד כַּאֲשֶׁר גַּם אֲנַחְנוּ אֶחָד׃ ");
INSERT INTO hebsg_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","אֲנִי בָּהֶם וְאַתָּה בִּי לְמַעַן יִהְיוּ תַּמִּים בְּאֶחָד וּלְמַעַן יֵדַע הָעוֹלָם כִּי אַתָּה שְׁלַחְתַּנִי וְכִי אָהַבְתָּ אֹתָם כַּאֲשֶׁר אֲהַבְתָּנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","וַאֲנִי חָפַצְתִּי אָבִי כִּי אֵלֶּה אֲשֶׁר נָתַתָּה לִּי יִהְיוּ עִמִּי גַּם־הֵם בַּאֲשֶׁר אֶהְיֶה לְמַעַן יִרְאוּ אֶת־כְּבוֹדִי אֲשֶׁר נָתַתָּה לִּי כִּי אָהַבְתָּ אֹתִי טֶרֶם הִוָּסֵד אָרֶץ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","אָבִי הַצַּדִּיק הֵן הָעוֹלָם אֵינֶנּוּ יֹדֵעַ אֹתְךָ וַאֲנִי יְדַעְתִּיךָ וְאֵלֶּה יֹדְעִים כִּי אַתָּה שְׁלַחְתָּנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","הוֹדַעְתִּי לָהֶם אֶת־שִׁמְךָ וְכֵן אוֹסִיף לְהוֹדִיעָם לְמַעַן תִּהְיֶה־בָּם הָאַהֲבָה אֲשֶׁר אֲהַבְתָּנִי וְגַם־אֲנִי אֶהְיֶה בְּתוֹכָם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","וַיְכַל יֵשׁוּעַ לְדַבֵּר אֶת־הַדְּבָרִים הָאֵלֶּה וַיֵּצֵא עִם־תַּלְמִידָיו אֶל־עֵבֶר לַנַּחַל קִדְרוֹן וַיָּבֹא לַגָּן אֲשֶׁר שָׁם הוּא וְתַלְמִידָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","וִיהוּדָה הַמַּסְגִּיר יָדַע אֶת־הַמָּקוֹם הַהוּא כִּי יֵשׁוּעַ וְתַלְמִידָיו פְּעָמִים רַבּוֹת נוֹעֲדוּ שָׁם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","וַיִּקַּח יְהוּדָה אֶת־הַגְּדוּד וְאֶת־הַמְשָׁרְתִים אֲשֶׁר לְרָאשֵׁי הַכֹּהֲנִים וְהַפְּרוּשִׁים וַיָּבֹא שָׁם בְּנֵרוֹת וְלַפִּידִים וּכְלֵי־נָשֶׁק׃ ");
INSERT INTO hebsg_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","וְיֵשׁוּעַ יָדַע אֵת כָּל־אֲשֶׁר יְבֹאֶנּוּ וַיֵּצֵא וַיֹּאמֶר אֲלֵיהֶם אֶת־מִי תְבַקֵּשׁוּן׃ ");
INSERT INTO hebsg_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","וַיַעֲנוּ אֹתוֹ אֶת־יֵשׁוּעַ הַנָּצְרִי וַיֹּאמֶר אֲלֵיהֶם יֵשׁוּעַ אֲנִי הוּא וִיהוּדָה הַמַּסְגִּיר עֹמֵד אֶצְלָם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","וַיְהִי כַּאֲשֶׁר אָמַר אֲלֵיהֶם ישׁוּעַ אֲנִי הוּא וַיִּסֹּגוּ אָחוֹר וַיִּפְּלוּ אָרְצָה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","וַיּוֹסֶף וַיִּשְׁאַל אֹתָם אֶת־מִי תְבַקֵּשׁוּ וַיֹּאמְרוּ אֶת־יֵשׁוּעַ הַנָּצְרִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","וַיַעַן יֵשׁוּעַ הֲלֹא אָמַרְתִּי לָכֶם כִּי אֲנִי הוּא עַל־כֵּן אִם־אֹתִי תְבַקְשׁוּ הַנִּיחוּ לָאֵלֶּה וְיֵלֵכוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","לְהָקִים הַדָּבָר אֲשֶׁר אָמָר מֵאֵלֶּה אֲשֶׁר נָתַתָּה לִּי לֹא־אָבַד לִי אַף־אֶחָד׃ ");
INSERT INTO hebsg_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","וְחֶרֶב הָיְתָה בִּידֵי שִׁמְעוֹן פֶּטְרוֹס וַיִּשְׁלֹף אֹתָהּ וַיַּךְ אֶת־עֶבֶד הַכֹּהֵן הַגָּדוֹל וַיְקַצֵּץ אֶת־אָזְנוֹ הַיְמָנִית וְשֵׁם הָעֶבֶד מַלְכוֹס׃ ");
INSERT INTO hebsg_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","וַיֹּאמֶר יֵשׁוּעַ אֶל־פֶּטְרוֹס חָשֵׁב חַרְבְּךָ אֶל־נְדָנָהּ הַאִם אֶת־כּוֹס אֲשֶׁר נָתַן־לִי אָבִי אֲנִי לֹא־אֶשְׁתֶּנָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","וְהַגְּדוּד וְשַׂר הָאֶלֶף וּמְשָׁרְתֵי הַיְּהוּדִים תָּפְשׂוּ אָז אֶת־יֵשׁוּעַ וַיַּאַסְרֻהוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","וַיֹּלִיכֻהוּ בָרִאשׁוֹנָה אֶל־חָנָן כִּי הוּא הָיָה חֹתֵן קַיָּפָא הַכֹּהֵן הַגָּדוֹל בַּשָּׁנָה הַהִיא׃ ");
INSERT INTO hebsg_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","הוּא קַיָּפָא אֲשֶׁר בַּעֲצָתוֹ לַיְּהוּדִים הִגִּיד כִּי טוֹב אֲשֶׁר יֹאבַד אִישׁ־אֶחָד בְּעַד כָּל־הָעָם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","וְשִׁמְעוֹן פֶּטְרוֹס וְתַלְמִיד אַחֵר הָלְכוּ אַחֲרֵי יֵשׁוּעַ וְהַתַּלְמִיד הַהוּא נוֹדָע הָיָה לַכֹּהֵן הַגָּדוֹל וַיָּבֹא עִם־יֵשׁוּעַ לַחֲצַר הַכֹּהֵן הַגָּדוֹל׃ ");
INSERT INTO hebsg_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","וּפֶטְרוֹס עָמַד מִחוּץ לַשָּׁעַר וַיֵּצֵא הַתַּלְמִיד הָאַחֵר הַנּוֹדָע לַכֹּהֵן הַגָּדוֹל וַיְדַבֵּר אֶל־הַשֹּׁעֶרֶת וַיָּבֵא אֶת־פֶּטָרוֹס הַבָּיְתָה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","וַתֹּאמֶר הָאָמָה הַשֹּׁעֶרֶת אֶל־פֶּטְרוֹס הֲלֹא גַם־אַתָּה מִתַּלְמִידֵי הָאִישׁ הַזֶּה וַיֹּאמֶר לֹא אָנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","וְשָׁם עָמְדוּ הָעֲבָדִים וְהַמְשָׁרְתִים וַיְבַעֲרוּ גֶחָלִים לְהִתְחַמֵּם מִפְּנֵי הַקֹּר וַיַּעֲמֹד גַּם־פֶּטְרוֹס עִמָּהֶם וַיִּתְחַמָּם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","וַיִּשְׁאַל הַכֹּהֵן הַגָּדוֹל אֶת־יֵשׁוּעַ עַל־תַּלְמִידָיו וְעַל־תּוֹרָתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","וַיַּעַן אֹתוֹ יֵשׁוּעַ אֲנֹכִי לְעֵין הַשֶּׁמֶשׁ דִּבַּרְתִּי אֶל־הָעוֹלָם וְתָמִיד לִמַּדְתִּי בְּבֵית־הַכְּנֵסֶת וּבְבֵית הַמִּקְדָּשׁ אֲשֶׁר שָׁם כָּל־הַיְּהוּדִים נִקְהָלִים וְלֹא־דִבַּרְתִּי דָבָר בַּסָּתֶר׃ ");
INSERT INTO hebsg_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","וְלָמָּה־זֶּה תִּשְׁאָלֵנִי שְׁאַל־נָא אֶת־הָאֲנָשִׁים אֲשֶׁר שָׁמְעוּ דְבָרָי הִנָּם יֹדְעִים אֶת־אֲשֶׁר הוֹרֵיתִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","וַיְהִי כְּדַבְּרוֹ אֶת־הַדְּבָרִים הָאֵלֶּה וַיַּךְ אֶחָד הַמְשָׁרְתִים הָעֹמֵד שָׁם אֶת־יֵשׁוּעַ עַל־הַלְּחִי וַיֹּאמַר הֲכָזֹאת תַּעֲנֶה אֶת־הַכֹּהֵן הַגָּדוֹל׃ ");
INSERT INTO hebsg_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","וַיַּעַן אֹתוֹ יֵשׁוּעַ אִם־רָעָה דִבַּרְתִּי עֲנֵה בִי אֶת־הָרָעָה וְאִם־נְכוֹנָה עַל־מֶה הִכִּיתָנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","וְחָנָן שָׁלַח אֹתוֹ אָסוּר אֶל־קַיָּפָא הַכֹּהֵן הַגָּדוֹל׃ ");
INSERT INTO hebsg_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","וְשִׁמְעוֹן פֶּטְרוֹס עֹמֵד וּמִתְחַמֵּם וַיֹּאמְרוּ אֵלָיו הֲלֹא גַם־אַתָּה מִתַּלְמִידָיו וַיְכַחֵשׁ וַיֹּאמֶר לֹא אָנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","וְאֶחָד מֵעַבְדֵי הַכֹּהֵן הַגָּדוֹל מוֹדָע לָאִישׁ הַהוּא אֲשֶׁר קִצֵּץ פֶּטְרוֹס אֶת־אָזְנוֹ אָמַר אֵלָיו הֲלֹא אֲנִי רְאִיתִיךָ עִמּוֹ בַּגָּן׃ ");
INSERT INTO hebsg_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","וַיּוֹסֶף פֶּטְרוֹס וַיְכַחֵשׁ וּבְרֶגַע זֶה קָרָא הַתַּרְנְגֹל׃ ");
INSERT INTO hebsg_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","וַיּוֹלִיכוּ אֶת־יֵשׁוּעַ מִבֵּית קַיָּפָא אֶל־בֵּית הַמִּשְׁפָּט כַּעֲלוֹת הַבֹּקֶר וְהֶם לֹא בָאוּ לְתוֹךְ בֵּית הַמִּשְׁפָּט לְבִלְתִּי יִטַּמְּאוּ וְלֹא יוּכְלוּ לֶאֱכֹל אֶת־הַפָּסַח׃ ");
INSERT INTO hebsg_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","וַיֵּצֵא פִילָטוֹס אֲלֵיהֶם וַיֹּאמַר מַה־שִּׂיטְנָה תָבִיאוּ עַל־הָאִישׁ הַזֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","וַיַּעֲנוּ וַיֹּאמְרוּ אֵלָיו לוּלֵא הָיָה זֶה פֹּעֵל־אָוֶן לֹא הִסְגַּרְנוּ אֹתוֹ בְּיָדֶיךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","וַיֹּאמֶר אֲלֵיהֶם פִּילָטוֹס קְחוּ אֹתוֹ אַתֶּם וְשִׁיפְטֻהוּ עַל־פִּי תוֹרַתְכֶם וַיֹּאמְרוּ אֵלָיו הַיְּהוּדִים אֵין־לָנוּ כֹחַ לְהָמִית נֶפֶשׁ אָדָם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","לְמַלֹּאת דְּבַר יֵשׁוּעַ אֲשֶׁר הִגִּיד מַה־יִּהְיֶה מוֹתוֹ אֲשֶׁר יוּמָת׃ ");
INSERT INTO hebsg_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","וַיָּשָׁב פִּילָטוֹס אֶל־בֵּית הַמִּשְׁפָּט וַיִּקְרָא אֶל־יֵשׁוּעַ וַיֹּאמֶר אֵלָיו הַאַתָּה הוּא מֶלֶךְ הַיְּהוּדִים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","וַיַּעַן יֵשׁוּעַ הֲמִלִּבְּךָ אַתָּה דֹבֵר כֵּן אוֹ כֵן הִגִּידוּ־לְךָ עָלַי אֲחֵרִים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","וַיַּעַן פִּילָטוֹס הֲכִי יְהוּדִי אֲנֹכִי הֵן עַמְּךָ וְרָאשֵׁי הַכֹּהֲנִים הִסְגִּירוּךָ בְיָדִי מֶה עָשִׂתָה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","וַיַּעַן יֵשׁוּעַ מַלְכוּתִי אֵינֶנָּה מִן־הָעוֹלָם הַזֶּה אִלּוּ מִן־הָעוֹלָם הַזֶּה הָיְתָה מַלְכוּתִי מְשָׁרְתַי יִלָּחֲמוּ לִי לְבִלְתִּי אֶנָּתֵן בִּידֵי הַיְּהוּדִים אַךְ עַתָּה מַלְכוּתִי אֵינֶנָּה מִפֹּה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","וַיֹּאמֶר אֵלָיו פִּילָטוֹס אִם־כֵּן מֶלֶךְ אָתָּה וַיַּעַן יֵשׁוּעַ אַתָּה אָמַרְתָּ כִּי־מֶלֶךְ אָנִי לָזֹאת נוֹלַדְתִּי וְלָזֹאת בָּאתִי בָעוֹלָם לְהָעִיד עַל־הָאֱמֶת מִי אֲשֶׁר לָאֱמֶת יִשְׁמַע אֶת־קוֹלִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","וַיֹּאמֶר אֵלָיו פִּילָטוֹס מָה הִיא הָאֱמֶת וְאַחֲרֵי דַבְּרוֹ כָזֹאת שָׁב אֶל־הַיְּהוּדִים וַיֹּאמֶר אֲלֵיהֶם אֲנִי לֹא־מָצָאתִי בוֹ עֲוֹן׃ ");
INSERT INTO hebsg_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","וְהִנֵּה זֶה הַחֹק מֵאָז לְשַׁלַּח לָכֶם בַּפֶּסַח אֶחָד מֵהָאֲסִירִים לַחָפְשִׁי וְעַתָּה אִם־טוֹב בְּעֵינֵיכֶם אֲשַׁלַּח לָכֶם אֶת־מֶלֶךְ הַיְּהוּדִים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","וַיּוֹסִיפוּ וַיִּצְעֲקוּ לֵאמֹר לֹא אֶת־זֶה כִּי אִם אֶת־בַּר־אַבָּא וּבַר־אַבָּא הָיָה שׁוֹדֵד׃ ");
INSERT INTO hebsg_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","אָז יִקַּח פִּילָטוֹס אֶת־יֵשׁוּעַ וַיְיַסֵּר אֹתוֹ בַּשּׁוֹטִים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","וְאַנְשֵׁי הַצָּבָא שָׂרְגוּ כֶתֶר קוֹצִים וַיָּשִׂימוּ עַל־רֹאשׁוֹ וַיַּלְבִּישֻׁהוּ מְעִיל אַרְגָּמָן׃ ");
INSERT INTO hebsg_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","וַיִּגְשׁוּ אֵלָיו וַיִּקְרְאוּ יְחִי מֶלֶךְ הַיְּהוּדִים וַיַּכֻּהוּ עַל־הַלֶּחִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","וַיָּשָׁב פִּילָטוֹס וַיֵּצֵא הַחוּצָה וַיֹּאמֶר אֲלֵיהֶם הִנֵּה אוֹצִיאֶנּוּ לִפְנֵיכֶם לְבַעֲבוּר תֵּדְעוּ כִּי לֹא־מָצָאתִי בוֹ עָוֹן׃ ");
INSERT INTO hebsg_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","וַיֵּצֵא יֵשׁוּעַ הַחוּצָה נֹשֵׂא כֶתֶר הַקּוֹצִים וּמְעִיל הָאַרְגָּמָן עָלָיו וַיֹּאמֶר אֲלֵיהֶם פִּילָטוֹס הִנֵּה הַגָּבֶר׃ ");
INSERT INTO hebsg_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","וְרָאשֵׁי הַכֹּהֲנִים וְהַמְשַׁרְתִים כִּרְאוֹתָם אֹתוֹ צָעֲקוּ לֵאמֹר הַצְלֵב הַצְלֵב אֹתוֹ וַיֹּאמֶר אֲלֵיהֶם פִּילָטוֹס קְחוּ אֹתוֹ אַתֶּם וְהַצְלִיבֻהוּ כִּי אֲנִי לֹא־מָצָאתִי בוֹ עָוֹן׃ ");
INSERT INTO hebsg_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","וַיַּעֲנוּ אֹתוֹ הַיְּהוּדִים הִנֵּה יֶשׁ־לָנוּ תּוֹרָה וּלְפִי תוֹרָתֵנוּ מִשְׁפָּט־מָוֶת לוֹ כִּי־מִתְאַמֵּר לֵאמֹר בֶּן־הָאֱלֹהִים הוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","כִּשְׁמֹעַ פִּילָטוֹס אֶת־הַדָּבָר הַזֶּה וַיִּירָא יֶתֶר מְאֹד׃ ");
INSERT INTO hebsg_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","וַיָּשָׁב וַיָּבֹא אֶל־בֵּית הַמִּשְׁפָּט וַיֹּאמֶר אֶל־יֵשׁוּעַ אֵי מִזֶּה אָתָּה וְיֵשׁוּעַ לֹא־עָנָה אֹתוֹ מְאוּמָה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","וַיֹּאמֶר אֵלָיו פִּילָטוֹס הַאֵלַי לֹא תְדַבֵּר הֲלֹא תֵדַע כִּי יָדִי רַב־לִי לְשַׁלֵּחֲךָ וְרַב־לִי לִצְלָבֶךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","וַיַעַן אֹתוֹ יֵשׁוּעַ אֵין־לְךָ כֹחַ עָלַי לוּלֵא נִתַּן־לְךָ מֵעָל עַל־כֵּן עֲוֹן מַסְגִּירַי בְּיָדֶיךָ גָּדוֹל מֵעֲוֹנֶךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","וְעַל־זֹאת בִּקֵשׁ פִּילָטוֹס לְשַׁלְּחוֹ וְהַיְּהוּדִים צָעֲקוּ וְאָמְרוּ אִם־תְּשַׁלַּח אֶת־הָאִישׁ הַזֶּה אֵינְךָ אֹהֵב אֶת־הַקֵּיסָר כִּי הַמִּתְקוֹמֵם לִהְיוֹת לְמֶלֶךְ הוּא מִתְקוֹמֵם עַל־הַקֵּיסָר׃ ");
INSERT INTO hebsg_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","כִּשְׁמֹעַ פִּילְטוֹס אֶת־הַדְּבָרִים הָאֵלֶּה הוֹצִיא אֶת־יֵשׁוּעַ הַחוּצָה וַיֵּשֶׁב עַל־כִּסֵּא הַמִּשְׁפָּט בַּמָּקוֹם הַנִּקְרָא מַרְצֶפֶת אֲבָנִים וּבְעִבְרִית גַּבְּתָא׃ ");
INSERT INTO hebsg_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","וַיֹּאמַר ֵֶאל־הַיְּהוּדִים בָּעֶרֶב הַפֶּסַח הַהוּא כַּשָּׁעָה הַשִּׁשִּׁית הִנֵּה מַלְכְּכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","וַיִּצְעֲקוּ הַיְצֵא הַיְצֵא אֹתוֹ צְלֹב אֹתוֹ וַיֹּאמֶר אֲלֵיהֶם פִּילָטוֹס הֲצָלֹב אֶצְלֹב אֶת־מַלְכְּכֶם וַיַּעֲנוּ רָאשֵׁי הַכֹּהֲנִים אֵין־לָנוּ מֶלֶךְ כִּי אִם־הַקֵּיסָר׃ ");
INSERT INTO hebsg_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","אָז נְתָנוֹ בְיָדָם לִצְלֹב אֹתוֹ וַיִּקְחוּ אֶת־יֵשׁוּעַ וַיּוֹלִיכֻהוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","וַיַּשִּׂיאוּ אֹתוֹ אֶת־עֵץ צְלָבוֹ וַיְבִיאֻהוּ אֶל־הַמָּקוֹם הַנִּקְרָא מְקוֹם הַגֻּלְגֹּלֶת וּבְעִבְרִית גָּלְגָּלְתָּא׃ ");
INSERT INTO hebsg_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","וַיִּצְלְבוּ אֹתוֹ שָׁם וּשְׁנֵי אֲנָשִׁים אֲחֵרִים עִמּוֹ מֵעֵבֶר מִזֶּה וּמִזֶּה וְיֵשׁוּעַ בֵּין שְׁנֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","וַיִּכְתֹּב פִּילָטוֹס כְּתֹבֶת עַל־לוּחַ וַיִשִׂימֵהוּ עַל־הַצְּלָב יֵשׁוּעַ הַנָּצְרִי מֶלֶךְ הַיְּהוּדִים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","וִיהוּדִים רַבִּים קָרְאוּ אֶת־הַכְּתֹבֶת כִּי הַמָּקוֹם אֲשֶׁר נִצְלַב־שָׁם יֵשׁוּעַ קָרוֹב לָעִיר וְהַכְּתֹבֶת כְּתוּבָה עִבְרִית רוֹמִית וִיוָנִית׃ ");
INSERT INTO hebsg_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","וַיֹּאמְרוּ רָאשֵׁי כֹהֲנֵי הַיְּהוּדִים אֶל־פִּילָטוֹס אַל־תִּכְתֹּב מֶלֶךְ הַיְּהוּדִים רַק כִּי אָמַר אֲנִי מֶלֶךְ הַיְּהוּדִים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","וַיַּעַן פִּילָטוֹס אֶת־אֲשֶׁר כָּתַבְתִּי כָּתַבְתִּי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","וַיְהִי כַּאֲשֶׁר צָלְבוּ אַנְשֵׁי הַצָּבָא אֶת־יֵשׁוּעַ וַיִּקְחוּ אֶת־בְּגָדָיו וַיְחַלְּקוּם אַרְבָּעָה רֹבַע לְאִישׁ אִישׁ וְגַם אֶת־כֻּתַּנְתּוֹ וְהַכְּתֹנֶת לֹא הָיְתָה תְּפוּרָה כִּי אִם־מַעֲשֶׂה אֹרֵג מִשָּׂפָה עַד־הַשָּׂפָה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","וַיֹּאמְרוּ אִישׁ אֶל־רֵעֵהוּ לֹא נִקְרְעָה אֹתָהּ אַךְ נַפִּילָה עָלֶיהָ גּוֹרָל לְמִי תִהְיֶה לְהָקִים דְּבַר הַכָּתוּב יְחַלְּקוּ בְגָדַי לָהֶם וְעַל־לְבוּשִׁי יַפִּילוּ גוֹרָל וַיַּעֲשׂוּ־כֵן אַנְשֵׁי הַצָּבָא׃ ");
INSERT INTO hebsg_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","וְעַל־יַד צְלַב יֵשׁוּעַ עָמְדוּ אִמּוֹ וַאֲחוֹת אִמּוֹ וּמִרְיָם אֵשֶׁת קְלוֹפָס וּמִרְיָם הַמַּגְדָּלִית׃ ");
INSERT INTO hebsg_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","וַיַּרְא יֵשׁוּעַ אֶת־אִמּוֹ וְאֶת־תַּלְמִידוֹ אֲשֶׁר אָהַב עֹמְדִים אֶצְלוֹ וַיֹּאמֶר אֶל־אִמּוֹ אִשָּׁה רְאִי זֶה בְּנֵךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","וְאַחַר אָמַר אֶל־תַּלְמִידוֹ רְאֵה זֹאת אִמֶּךָ וַיַּאַסְפָהּ הַתַּלְמִיד אֶל־בֵּיתוֹ מֵהַיּוֹם הַהוּא וָמָעְלָה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","וְיֵשׁוּעַ בְּדַעְתּוֹ אַחֲרֵי־כֵן כִּי נִשְׁלַם כָּל־דָּבָר אַךְ לְמַלֹּאת אֶת־הַכָּתוּב אָמַר צָמֵאתִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","וְשָׁם עָמַד כְּלִי מָלֵא חֹמֶץ וַיִּטְבְּלוּ סְפוֹג בַּחֹמֶץ וַיָּשִׂימוּ עַל־רֹאשׁ אֵזוֹב וַיַּגִיעוּהוּ אֶל־פִּיו׃ ");
INSERT INTO hebsg_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","וַיִּטְעַם יֵשׁוּעַ מִן־הַחֹמֶץ וַיֹּאמֶר נִשְׁלָם וַיֵּט אֶת־רֹאשׁוֹ וַיַּפְקֵד אֶת־רוּחוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","וְהַיְּהוּדִים חָשׁוּ לְבִלְתִּי הַשְׁאֵר אֶת־הַפְּגָרִים עַל־הָעֵץ בְּיוֹם הַשַּׁבָּת כִּי־עֶרֶב שַׁבָּת הָיָה וְהַשַּׁבָּת הַהוּא גָּדוֹל הוּא עַל־כֵּן שָׁאֲלוּ מִפִּלָטוֹס לְשַׁבֵּר אֶת־שׁוֹקֵיהֶם כִּי יָמוּתוּ וּלְהוֹרִידָם מִן־הָעֵץ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","וַיָּבֹאוּ אַנְשֵׁי הַצָּבָא וַיְשַׁבְּרוּ אֶת־שׁוֹקֵי הָאֶחָד וְאֶת־שׁוֹקֵי הַשֵּׁנִי אֲשֶׁר נִצְלְבוּ עִמּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","וַיָּבֹאוּ אֶל־יֵשׁוּעַ וַיִּרְאוּ כִּי־כְבָר מֵת וְלֹא שִׁבְּרוּ אֶת־שׁוֹקָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","אַךְ אֶחָד מֵאַנְשֵׁי הַצָּבָא דְּקָרוֹ בַחֲנִית בְּצִדּוֹ וַיֵּצֵא דָם וָמָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","וְהַמֵּעִיד עַל־זֶה רָאָה אֶת־הַדָּבָר וְעֵדוּתוֹ נֶאֱמָנָה וְהוּא יֹדֵעַ כִּי אֱמֶת יֶהְגֶּה חִכּוֹ לְבַעֲבוּר תַּאֲמִינוּ גַּם־אַתֶּם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","וְכָל־זֶה הָיָה לְקַיֵּם אֶת־הַכָּתוּב וְעֶצֶם לֹא־תִשְׁבְּרוּ בוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","וְעוֹד כָּתוּב לֵאמֹר וְהִבִּטוּ אֵלָיו אֵת אֲשֶׁר־דָּקָרוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","וַיְהִי אַחַר הַדְּבָרִים הָאֵלֶּה יוֹסֵף מִן־הָרָמָתַיִם הוּא אֲשֶׁר הָיָה תַּלְמִיד יֵשׁוּעַ בַּסֵּתֶר מִיִּרְאָתוֹ אֶת־הַיְּהוּדִים וַיִּשְׁאַל מֵאֵת פִּילָטוֹס לָתֶת־לוֹ לָשֵׂאת אֶת־גּוּפַת יֵשׁוּעַ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","וַיִתֶּן־לוֹ פִּילָטוֹס רִשְׁיוֹן וַיָּבֹא וַיִּשָׂא אֶת־גּוּפַת יֵשׁוּעַ וְנַקְדִּימוֹן אֲשֶׁר לְפָנִים בָּא אֶל־יֵשׁוּעַ בַּלַּיְלָה בָּא גַּם־הוּא וְהֵבִיא סַמִּים בְּלוּלִים מֹר־וַאֲהָלוֹת כְּמֵאָה לִיטָרִין׃ ");
INSERT INTO hebsg_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","וַיִּקְחוּ אֶת־גּוּפַת יֵשׁוּעַ וַיַּעֲטוּהָ בְתַכְרִיכִים אֲשֶׁר מִלְאוּ בְשָׂמִים כְּדֶרֶךְ קְבוּרַת הַיְּהוּדִים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","וּבַמָּקוֹם אֲשֶׁר נִצְלַב־שָׁם הָיָה גָן וּבוֹ קֶבֶר חָדָשׁ אֲשֶׁר עוֹד לֹא־נִקְבַּר בּוֹ אִישׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","וּבִהְיוֹת הַיּוֹם עֶרֶב שַׁבָּת לַיְּהוּדִים וְהַקֶּבֶר קָרוֹב קָבְרוּ בוֹ אֶת־יֵשׁוּעַ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","וַיְהִי בָּאֶחָד בַּשַּׁבָּת וַתָּבֹא מִרְיָם הַמַּגְדָּלִית לִפְנוֹת בֹּקֶר בַּחֲשֵׁכָה אֶל־הַקָּבֶר וַתֵּרֶא אֶת־הָאֶבֶן מְגוֹלָלָה מֵעַל־הַקָּבֶר׃ ");
INSERT INTO hebsg_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","וַתָּרָץ וַתָּבֹא אֶל־שִׁמְעוֹן פֶּטְרוּס וְאֶל־הַתַּלְמִיד הָאַחֵר אֲשֶׁר אָהַב אֹתוֹ יֵשׁוּעַ וַתֹּאמֶר אֲלֵיהֶם הִנֵּה נָשְׂאוּ אֶת־אֲדֹנֵינוּ מִן־הַקֶּבֶר וַאֲנַחְנוּ לֹא נֵדַע אָנָה שָׂמוּ אֹתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","וַיֵּצֵא פֶטְרוֹס וְהַתַּלְמִיד הָאַחֵר וַיֵּלְכוּ אֶל־הַקָּבֶר׃ ");
INSERT INTO hebsg_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","וּשְׁנֵיהֶם רָצוּ יַחְדָּו וַיְמַהֵר הַתַּלְמִיד הָאַחֵר לָרוּץ וַיַּעֲבֹר אֶת־פֶּטְרוֹס וַיָּבֹא רִאשׁוֹן אֶל־הַקָּבֶר׃ ");
INSERT INTO hebsg_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","וַיִּשַּׁח וַיַּשְׁקֵף אֶל־תּוֹכוֹ וַיַּרְא אֶת־הַתַּכְרִיכִים מֻנָּחִים לְבַדָּם וְלֹא יָרַד פְּנִימָה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","וְגַם־שִׁמְעוֹן פֶּטְרוֹס בָּא אַחֲרָיו וַיֵּרֶד אֶל־הַקָּבֶר וַיַּרְא אֶת־הַתַּכְרִיכִים מֻנָּחִים לְבַדָּם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","וְהַמִּטְפַּחַת אֲשֶׁר הָיְתָה עַל־רֹאשׁוֹ אֵינֶנָּה עִם־הַתַּכְרִיכִים כִּי אִם־צְנוּפָה לְבַדָּהּ בְּמָקוֹם אַחֵר׃ ");
INSERT INTO hebsg_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","וַיֵּרֶד שָׁם גַּם־הַתַּלְמִיד הָאַחֵר אֲשֶׁר־בָּא רִאשׁוֹן אֶל־הַקֶּבֶר וַיַּרְא וַיַּאֲמֵן׃ ");
INSERT INTO hebsg_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","כִּי עַד־עַתָּה לֹא־הֵבִינוּ עוֹד אֶת־הַכְּתוּבִים כִּי נָכוֹן לוֹ לָקוּם מִן־הַמֵּתִים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","וַיָּשֻׁבוּ הַתַּלְמִידִים וַיֵּלְכוּ אֶל־בֵּיתָם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","וּמִרְיָם עָמְדָה מִחוּץ לַקֶּבֶר וַתֵּבְ וַיְהִי בִּבְכּוֹתָהּ וַתִּשַּׁח וַתַּשְׁקֵף אֶל־תּוֹךְ הַקָּבֶר׃ ");
INSERT INTO hebsg_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","וַתֵּרֶא שְׁנֵי מַלְאָכִים עֹטִים לְבָנִים וְישְׁבִים בַּמָּקוֹם אֲשֶׁר שָׂמוּ אֶת־גּוּפַת יֵשׁוּעַ אֶחָד מְרַאֲשֹׁתָיו וְאֶחָד מַרְגְּלֹתָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","וַיֹּאמְרוּ אֵלֶיהָ אִשָּׁה לָמֶה תִבְכִּי אֲלֵיהֶם כִּי נָשְׂאוּ אֶת־אֲדֹנִי מִזֶּה וְלֹא אֵדַע אָנָה שָׂמֻהוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","עוֹד הִיא מְדַבֶּרֶת כָּזֹאת וַתֵּפֶן מֵאַחֲרֶיהָ וַתֵּרֶא אֶת־יֵשׁוּעַ עֹמֵד וְלֹא יָדְעָה כִּי הוּא יֵשׁוּעַ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","וַיֹּאמֶר אֵלֶיהָ יֵשׁוּעַ אִשָּׁה לָמֶה תִבְכִּי אֶת־מִי תְבַקֵּשִׁי וְהִיא חָשְׁבָה כִּי־נֹטֵר הַגָּן הוּא וַתֹּאֶר אֵלָיו אֲדֹנִי אִם־אַתָּה נָשָׂאתָ אֹתוֹ מִזֶּה הַגִּידָה־נָא לִי אֵיפֹא שַׂמְתָּ אֹתוֹ וַאֲנִי אֵלֵךְ וְאֶשָּׂאֶנּוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","וַיֹּאמֶר אֵלֶיהָ יֵשׁוּעַ מִרְיָם וַתֵּפֶן וַתֹּאמֶר אֵלָיו עִבְרִית רַבּוּנִי אֲשֶׁר יֵאָמֵר רַבִּי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","וַיֹּאמֵר אֵלֶיהָ יֵשׁוּעַ אַל־תִּגְּעִי בִי כִּי עוֹד לֹא עָלִיתִי אֶל־הָאָב אַךְ לְכִי אֶל־אַחַי וְאִמְרִי אֲלֵיהֶם הִנְנִי עֹלֶה אֶל־אָבִי וַאֲבִיכֶם אֶל־אֱלֹהַי וֵאלֹהֵיכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","וַתָּבֹא מִרְיָם הַמַּגְדָּלִית וַתַּגֵּד לַתַּלְמִידִים כִּי־רָאֲתָה אֶת־הָאָדוֹן וְכִי כָּזֹאת דִּבֶּר אֵלֶיהָ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","וַיְהִי בָּעֶרֶב בַּשַּׁבָּת הַהוּא כַּאֲשֶׁר נִסְגְּרוּ דַלְתוֹת הַבַּיִת אֲשֶׁר נִקְבְּצוּ שָׁם הַתַּלְמִידִים מִיִּרְאָתָם אֶת־הַיְּהוּדִים וַיָּבֹא יֵשׁוּעַ וַיַּעֲמֹד בְּתוֹכָם וַיֹּאמֶר אֲלֵיהֶם שָׁלוֹם עֲלֵיכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","וְאַחֲרֵי דַבְּרוֹ כָזֹאת הֶרְאָם אֶת־יָדָיו וְאֶת־צִדּוֹ וַיִּשְׂמְחוּ הַתַּלְמִידִים בִּרְאוֹתָם אֶת־הָאָדוֹן׃ ");
INSERT INTO hebsg_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","וַיּוֹסֶף יֵשׁוּעַ וַיֹּאמֶר אֲלֵיהֶם שָׁלוֹם לָכֶם כַּאֲשֶׁר שָׁלַח אֹתִי הָאָב כֵּן הִנְנִי שֹׁלֵחַ אֶתְכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","וְאַחֲרֵי דַבְּרוֹ כָזֹאת וַיִּפַּח בָּהֶם וַיֹּאמֶר אֲלֵיהֶם קְחוּ לָכֶם אֶת־רוּחַ הַקֹּדֶשׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","אִישׁ אִישׁ אֲשֶׁר תִּסְלְחוּ לוֹ אֶת־חֲטָאָיו וְנִסְלַח לוֹ וְאִם תְּשִׁיתוּם עָלָיו עָלָיו יִהְיוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","וְתוֹמָא הַנִּקְרָא דִידוּמוֹס אֶחָד מִשְּׁנֵים הֶעָשָׂר לֹא־הָיָה עִמָּהֶם בְּבֹא יֵשׁוּעַ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","וַיֹּאמְרוּ אֵלָיו יֶתֶר הַתַּלְמִידִים רָאִינוּ אֶת־הָאָדוֹן וַיֹּאמֶר אֲלֵיהֶם אִם־לֹּא אֶרְאֶה אֶת־מַדְקְרוֹת הַמַּסְמְרִים בְּיָדָיו וְלֹא אֶתְקַע אֶת־אֶצְבָּעִי בְּנִקְבֵי הַמַּסְמְרִים הָאֵלֶּה ובְיָדִי לֹא אֶגַּע בְּצִדּוֹ לֹא אַאֲמִינָה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","וּמִקְצֵה שְׁמֹנַת יָמִים נִקְהֲלוּ הַתַּלְמִידִים בַּבַּיִת פְּנִימָה עוֹד הַפַּעַם וְתוֹמָא עִמָּהֶם וַיָּבֹא יֵשׁוּעַ כַּאֲשֶׁר סֻגְּרוּ הַדְּלָתוֹת וַיַּעֲמֹד בְּתוֹכָם וַיֹּאמֶר שָׁלוֹם עֲלֵיכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","וְאַחַר אָמַר אֶל־תּוֹמָא הוֹשֵׁט אֶת־אֶצְבָּעֲךָ הֵנָּה וּרְאֵה אֶת־יָדַי וְהוֹשֵׁט אֶת־יָדְךָ וּמֻשֵּׁנִי בְצִדִּי וְאַל־תְּהִי חֲסַר אֱמוּנָה כִּי אִם־הַאֲמֵן תַּאֲמִין׃ ");
INSERT INTO hebsg_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","וַיַּעַן תּוֹמָא וַיֹּאמֶר אֵלָיו אֲדֹנִי וֵאלֹהָי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","וַיֹּאמֶר אֵלָיו יֵשׁוּעַ יַעַן אֲשֶׁר רְאִיתַנִי הֱאֶמַנְתָּ תּוֹמָא אַשְׁרֵי אֵלֶּה הַמַּאֲמִינִים וְרָאוֹ לֹא רָאוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","וְגַם־מוֹפְתִים אֲחֵרִים רַבִּים עָשָׂה יֵשׁוּעַ לְעֵינֵי תַלְמִידָיו אֲשֶׁר לֹא־נִכְתְּבוּ בַּסֵּפֶר הַזֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","אַךְ־אֵלֶּה נִכְתְּבוּ לְבַעֲבוּר תַּאֲמִינוּ כִּי יֵשׁוּעַ הוּא הַמָּשִׁיחַ בֶּן־הָאֱלֹהִים וּלְבַעֲבוּר יִהְיוּ לָכֶם חַיִּים עֵקֶב אֱמוּנַתְכֶם בִּשְׁמוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","וַיְהִי אַחֲרֵי־כֵן וַיּוֹסֵף יֵשׁוּעַ לְהֵרָאוֹת אֶל־תַּלְמִידָיו עַל־יַם טְבַרְיָה וְכֹה נִרְאָה אֲלֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","כַּאֲשֶׁר יָשְׁבוּ יַחְדָּו שִׁמְעוֹן פֶּטְרוֹס וְתוֹמָא הַנִּקְרָא דִידוּמוֹס וּנְתַנְאֵל מִקָּנָה אֲשֶׁר בַּגָּלִיל וּבְנֵי זַבְדִּי וּשְׁנַיִם אֲחֵרִים מִתַּלְמִידָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","וַיֹּאמֶר אֲלֵיהֶם שִׁמְעוֹן פֶּטְרוֹס הִנְנִי הֹלֵךְ לָדִיג וַיֹּאמְרוּ אֵלָיו עִמָּךְ נֵלֵךְ גַּם־אֲנָחְנוּ וַיֵּצְאוּ מִיָּד וַיֵּרְדוּ אֶל־הָאֳנִיָּה וְלֹא לָכְדוּ מְאוּמָה בַּלַּיְלָה הוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","הַבֹּקֶר אוֹר וְהִנֵּה יֵשׁוּעַ עֹמֵד עַל־שְׂפַת הַיָּם וְהַתַּלְמִידִים לֹא יָדְעוּ כִּי יֵשׁוּעַ הוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","וַיֹּאמֶר אֲלֵיהֶם יֵשׁוּעַ בָּנַי הֲיֵשׁ־לָכֶם דָּבָר לֶאֱכֹל וַיַּעֲנוּ וַיֹּמְרוּ אָיִן׃ ");
INSERT INTO hebsg_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","וַיֹּאמֶר אֲלֵיהֶם פִּרְשׂוּ אֶת־הַמִּכְמֹרֶת מִימִין לָאֳנִיָּה וּמְצָאתֶם וַיִפְרְשׂוּ וְלֹא־יָכְלוּ עוֹד לְמָשְׁכָהּ מֵרֹב דָּגִים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","וְהַתַּלְמִיד הַהוּא אֲשֶׁר יֵשׁוּעַ אֲהֵבוֹ אָמַר אֶל־פֶּטְרוֹס הָאָדוֹן הוּא וְכִשְׁמֹעַ שִׁמְעוֹן פֶּטְרוֹס כִּי הוּא הָאָדוֹן וַיַּעַט אֶת־מְעִילוֹ כִּי עֵרֹם הָיָה וַיִּתְנַפֵּל אֶל־הַיָּם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","וְיֶתֶר הַתַּלְמִידִים בָּאוּ בָאֳנִיָּתָם כִּי לֹא הִרְחִיקוּ מִן־הַיַּבָּשָׁה כִּי אִם־כְּמָאתַיִם אַמָּה וַיִּמְשְׁכוּ אֶת־הַמִכְמֹרֶת עִם־הַדָּגִים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","וַיֵּצְאוּ אֶל־הַיַּבָּשָׁה וַיִּרְאוּ גַּחֲלֵי־אֵשׁ עֲרוּכִים שָׁם וְדָג עֲלֵיהֶם וְכִכַּר לָחֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","וַיֹּאמֶר אֲלֵיהֶם יֵשׁוּעַ הָבִיאוּ הֲלֹם מִן־הַדָּגִים אֲשֶׁר לְכַדְתֶּם עָתָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","וַיַּעַל שִׁמְעוֹן פֶּטְרוֹס וַיִּמְשֹׁךְ אֶת־הַמִּכְמֹרֶת אֶל־הַיַּבָּשָׁה וְהִיא מְלֵאָה דָגִים גְּדוֹלִים מֵאָה וַחֲמִישִׁים וּשְׁלשָׁה וּבְכָל־זֹאת לֹא נִקְרְעָה הַמִּכְמֹרֶת מֵרֹב הַדָּגִים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","וַיֹּאמֶר אֲלֵיהֶם יֵשׁוּעַ בֹּאוּ אִכְלוּ אֲרֻחַת הַבֹּקֶר וְאֵין גַּם־אֶחָד בַּתַּלְמִידִים אֲשֶׁר מְלָאוֹ לִבּוֹ לִשְׁאֹל מִי אָתָּה כִּי יָדְעוּ אֲשֶׁר הוּא הָאָדוֹן׃ ");
INSERT INTO hebsg_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","וַיָּבֹא יֵשׁוּעַ וַיִּקַּח אֶת־הַלֶּחֶם וַיִּתֵּן לָהֶם וְגַם אֶת־הַדָּגָה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","וְזֹאת הַפַּעַם הַשְּׁלִישִׁית אֲשֶׁר־נִרְאָה יֵשׁוּעַ אֶל־תַּלְמִידָיו אַחֲרֵי קוּמוֹ מִן־הַמֵּתִים׃ ");
INSERT INTO hebsg_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","וַיְהִי אַחֲרֵי אֲרֻחָתָם וַיֹּאמֶר יֵשׁוּעַ אֶל־שִׁמְעוֹן פֶּטְרוֹס שִׁמְעוֹן בַּר־יוֹנָה הַאֹהֵב אַתָּה אֹתִי יֶתֶר מֵאֵלֶּה וַיֹּאמֶר אֵלָיו הֵן אֲדֹנִי אַתָּה יָדַעְתָּ כִּי אֲהַבְתִּיךָ וַיֹּאמֶר אֵלָיו נַהֵל אֶת־עָלוֹתָי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","וַיֹּאמֶר אֵלָיו פַּעַם שֵׁנִית שִׁמְעוֹן בַּר־יוֹנָה הַאֹהֵב אַתָּה אֹתִי וַיֹּאמֶר אֵלָיו הֵן אֲדֹנִי אַתָּה יָדַעְתָּ כִּי אֲהַבְתִּיךָ וַיֹּאמֶר אֵלָיו נְחֵה אֶת־צֹאנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","וַיֹּאמֶר אֵלָיו פַּעַם שְׁלִישִׁית שִׁמְעוֹן בַּר־יוֹנָה הַאֹהֵב אַתָּה אֹתִי וַיִּתְעַצֵּב פֶּטְרוֹס אֶל־לִבּוֹ כִּי אָמַר אֵלָיו פַּעַם שְׁלִישִׁית הַאֹהֵב אַתָּה אֹתִי וַיֹּאמֶר אֵלָיו אֲדֹנִי אַתָּה אֶל־כֹּל יָדַעְתָּ אַתָּה יָדַעְתָּ כִּי אֲהַבְתִּיךָ וַיֹּאמֶר אֵלָיו יֵשׁוּעַ רְעֵה אֶת־צֹאנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","אָמֵן אָמֵן אֲנִי אֹמֵר לָךְ בְּעוֹד נַעַר הָיִיתָ בְּיָדְךָ חָגַרְתָּ אֶת־מָתְנֶיךָ וַתֵּלֶךְ אֶל־אֲשֶׁר חָפַצְתָּ וְכִי תִזְקַן תִּפְרֹשׂ כַּפֶּיךָ וְאַחֵר יַחְגָּרְךָ וּנְשָׂאֲךָ אֶל־אֲשֶׁר לֹא תַחְפֹּץ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","וְאוּלָם כָּזֹאת הוּא דִבֵּר בְּרָמְזוֹ לוֹ בְּאֵיזֶה מָוֶת הוּא יָמוּת אֲשֶׁר יִגְדַּל בּוֹ כְּבוֹד אֱלֹהִים וְאַחֲרֵי דַבְּרוֹ כָזֹאת אָמַר אֵלָיו לֵךְ אַחֲרָי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","וַיִּפֶן פֶּטְרוֹס וַיַּרְא אֶת־הַתַּלְמִיד אֲשֶׁר יֵשׁוּעַ אֲהֵבוֹ הֹלֵךְ אַחֲרֵיהֶם וְהוּא אֲשֶׁר נָפַל עַל־צַוָּארוֹ בְּמִשְׁתֵּה הָעֶרֶב וְאָמַר אֲדֹנִי מִי הוּא־זֶה אֲשֶׁר יַסְגִּירֶךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","וַיְהִי בִּרְאוֹת אֹתוֹ פֶּטְרוֹס וַיֹּאמֶר אֶל־יֵשׁוּעַ אֲדֹנִי וְזֶה מָה אַחֲרִיתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","וַיֹּאמֶר אֵלָיו יֵשׁוּעַ אִם־חָפַצְתִּי כִּי יִשָּׁאֵר עַד־אֲשֶׁר אָבֹא אַךְ מַה־לָּךְ לֵךְ אַחֲרָי׃ ");
INSERT INTO hebsg_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","עַל־כֵּן יָצָא הַדָּבָר הַזֶּה בֵּין הָאַחִים כִּי הַתַּלְמִיד הַהוּא לֹא יָמוּת וְיֵשׁוּעַ לֹא אָמַר־לוֹ כִּי לֹא־יָמוּת רַק אָמַר אִם־חָפַצְתִּי כִּי־יִשָּׁאֵר עַד־אֲשֶׁר אָבֹא אַךְ מַה־לָּךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","זֶה הוּא הַתַּלְמִיד הַנֹּתֵן אֶת־עֵדוּתוֹ לָאֵלֶּה וְהוּא אֲשֶׁר כָּתַב כָּל־אֵלֶּה וְיָדַעְנוּ כִּי עֵדוּתוֹ נֶאֱמָנָה׃ ");
INSERT INTO hebsg_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","וְעוֹד יֵשׁ מַעֲשִׂים רַבִּים אֲחֵרִים אֲשֶׁר עָשָׂה יֵשׁוּעַ אַךְ אִם־יִכָּתְבוּ כֻלָּם אֶחָד אַחַר אֶחָד יַחֲשֹׁב לְבָבִי כִּי לֹא תָכִיל כָּל־הָעוֹלָם אֶת־הַסְּפָרִים אֲשֶׁר יִכָּתֵבוּן אָמֵן׃ ");
INSERT INTO hebsg_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","הִנֵּה הַסֵּפֶר הָרִאשׁוֹן תְּאוֹפִילוֹס כָּתַבְתִּי בוֹ כָּל־אֲשֶׁר עָשָׂה יֵשׁוּעַ וְכָל־אֲשֶׁר הוֹרָה מִיּוֹם הַחִלּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","עַד־הַיּוֹם אֲשֶׁר נַעֲלָה מֵאִתָּנוּ אַחֲרֵי תִתּוֹ אֶת־מִצְוֹתָיו בְּרוּחַ הַקֹּדֶשׁ אֶל־שְׁלִיחָיו אֲשֶׁר־בָּחַר בָּהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","וַאֲשֶׁר אַחֲרֵי עֻנּוֹתוֹ הִתְיַצֵּב עֲלֵיהֶם חָי בְּאֹתוֹת רַבִּים בְּהִגָּלוֹת נִגְלוֹת אֲלֵיהֶם אַרְבָּעִים יוֹם וַיְדַבֵּר עַל־מַלְכוּת הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","וְכַאֲשֶׁר סָעַד עִמָּהֶם יַחְדָּו צִוָּה אֹתָם לֵאמֹר לֹא־תֵצְאוּ מִירוּשָׁלַיִם כִּי אִם־תּוֹחִילוּ אֶל־דְּבַר הָאָב אֲשֶׁר שְׁמַעְתֶּם מִפִּי׃ ");
INSERT INTO hebsg_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","כִּי יוֹחָנָן טִבֵּל בַּמָּיִם וְאַתֶּם תִּטָּבְלוּ בְּרוּחַ הַקֹּדֶשׁ בְּעוֹד לֹא־כַבִּיר אַחֲרֵי הַיָּמִים הָאֵלֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","וַיְהִי בְּהִתְאַסְּפָם יַחַד וַיִּשְׁאָלֻהוּ לֵאמֹר אֲדֹנֵינוּ הֲתָשִׁיב בָּעֵת הַזֹּאת אֶת־הַמַּלְכוּת לְיִשְׂרָאֵל׃ ");
INSERT INTO hebsg_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","וַיֹּאמֶר אֲלֵיהֶם לֹא לָכֶם לָדַעַת אֶת־הָעִתִּים וְאֶת־הַמוֹעֲדִים אֲשֶׁר יָעַד הָאָב בְּמֶמְשַׁלְתּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","אֲבָל תִּתְאַזְּרוּ עֹז כְּנֹחַ עֲלֵיכֶם רוּחַ הַקֹּדֶשׁ וִהְיִיתֶם עֵדַי בִּירוּשָׁלַיִם וּבְכָל־יְהוּדָה וּבְשֹׁמְרוֹן וְעַד־קְצֵה הָאָרֶץ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","כְּכַלֹּתוֹ לְדַבֵּר אֶת־הַדְּבָרִים הָאֵלֶּה נַעֲלָה מֵהֶם וְעֵינֵיהֶם רֹאוֹת וַיִּשָּׂאֵהוּ עָנָן מִנֶּגֶד עֵינֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","וַיַּבִּיטוּ אַחֲרָיו בַּעֲלֹתוֹ הַשָּׁמָיְמָה וְהִנֵּה שְׁנֵי אֲנָשִׁים לְבֻשֵׁי לָבָן נִצָּבִים עֲלֵיהֶם וְאֹמְרִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","אַנְשֵׁי הַגָּלִיל לָמָּה־זֶּה אַתֶּם עֹמְדִים וּמַבִּיטִים הַשָּׁמָיְמָה יֵשׁוּעַ זֶה אֲשֶׁר לֻקַּח מֵעֲלֵיכֶם וַיַּעַל לַמָּרוֹם כֵּן יָבֹא כַּאֲשֶׁר רְאִיתֶם אֹתוֹ עֹלֶה לַמָּרוֹם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","וַיִּפְנוּ וַיֵּלְכוּ יְרוּשָׁלַיְמָה מִן־הָהָר הַנִּקְרָא הַר־הַזֵּיתִים הַקָּרוֹב לִירוּשָׁלַיִם כְּדֶרֶךְ תְּחוּם שַׁבָּת׃ ");
INSERT INTO hebsg_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","וַיָּבֹאוּ וַיַּעֲלוּ אֶל־הָעֲלִיָּה אֲשֶׁר גָּרוּ שָׁם פֶּטְרוֹס וְיוֹחָנָן וְיַעֲקֹב וְאַנְדְּרַי פִּילִפּוֹס וְתוֹמָא בַּר־תַּלְמַי וּמַתִּתְיָהוּ יַעֲקֹב בֶּן־חַלְפַי וְשִׁמְעוֹן הַקַּנָּאִי וִיהוּדָה בֶּן־יַעֲקֹב׃ ");
INSERT INTO hebsg_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","כָּל־אֵלֶּה שָׁקְדוּ יַחְדָּו עַל־הַתְּפִלָּה וּבְתַחֲנוּנִים בְּלֵב אֶחָד עִם־הַנָּשִׁים עִם־מִרְיָם אֵם יֵשׁוּעַ וְעִם־אֶחָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","בַּיָּמִים הָהֵם וּפֶטְרוֹס קָם בְּתוֹךְ הָאַחִים הַנִּקְהָלִים אֲשֶׁר הָיָה מִסְפָּרָם כְּמֵאָה וְעֶשְׂרִים וַיֹּאמַר׃ ");
INSERT INTO hebsg_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","אֲנָשִׁים אַחִים נָכוֹן הָיָה כִּי יָקוּם דְּבַר הַכָּתוּב אֲשֶׁר רוּחַ הַקֹּדֶשׁ דִּבֶּר מִקֶּדֶם בְּפִי דָוִד עַל־יְהוּדָה אֲשֶׁר הָיָה לִמְנַהֵל לִלְכֹדֵי יֵשׁוּעַ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","כִּי־נִמְנָה אִתָּנוּ וְהָעֲבֹדָה הַזֹּאת נָפְלָה לּוֹ בְּגוֹרָלוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","וְהִנֵּה הוּא קָנָה־לוֹ שָׂדֶה בִּשְׂכַר פִּשְׁעוֹ וַיִּפֹּל מְלֹא קוֹמָתוֹ אַרְצָה וַיִּבָּקַע בַּתָּוֶךְ וְכָל־מֵעָיו נִשְׁפָּכוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","וְהַדָּבָר נוֹדַע לְכָל־ישְׁבֵי יְרוּשָׁלָיִם כִּי לְבַעֲבוּר זֹאת נִקְרָא הַשָּׂדֶה הַהוּא בִּשְׂפָתָם חֲקַל־דְּמָא כִּי הוּא שְׂדֵה דָמִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","כִּי־כָתוּב בְּסֵפֶר הַתְּהִלִּים תְּהִי־טִירָתוֹ נְשַׁמָּה וְאַל־יְהִי בָהּ ישֵׁב וְעוֹד ופְקֻדָּתוֹ יִקַּח אַחֵר׃ ");
INSERT INTO hebsg_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","וְעַל־כֵּן נָכוֹן לָנוּ כִּי מִן־הָאֲנָשִׁים הָאֵלֶּה אֲשֶׁר הָלְכוּ אִתָּנוּ כָּל־יְמֵי הֱיוֹת יֵשׁוּעַ אֲדֹנֵינוּ יוֹצֵא וָבָא לְפָנֵינוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","הָחֵל מִטְּבִילַת יוֹחָנָן עַד־הַיּוֹם אֲשֶׁר לֻקַּח מִמֶּנּוּ אֲשֶׁר אֶחָד מֵהֶם יִהְיֶה עִמָּנוּ לְעֵד עַל־תְּקוּמָתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","וַיַּעֲמִידוּ שְׁנָיִם אֶת־יוֹסֵף הַנִּקְרָא בַּר־שַׁבָּא וּמְכֻנָּה יוּסְטוֹס וְאֶת־מַתִּתְיָהוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","וַיִּתְפַּלְּלוּ וַיֹּאמְרוּ אַתָּה יְהוָֹה יֹדֵעַ כָּל־לְבָבוֹת הַרְאֵנוּ־נָא אֶת־הָאֶחָד מִן־הַשְּׁנַיִם אֲשֶׁר אַתָּה בָּחַרְתָּ בּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","כִּי יִקַּח גּוֹרַל הָעֲבוֹדָה הַזֹּאת וּמַלְאֲכוּת־יָהּ אֲשֶׁר יְהוּדָה שָׂטָה מֵעָלֶיהָ וַיֵּלֶךְ לִמְקוֹמוֹ שֶׁלּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","וַיַּפִּילוּ עֲלֵיהֶם גּוֹרָלוֹת וַיִּפֹּל הַגּוֹרָל עַל־מַתִּתְיָהוּ וַיִּמָּנֶה עִם־אַחַד עָשָׂר הַשְּׁלִיחִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","וּבְיוֹם מְלֹאת שִׁבְעַת הַשָׁבֻעוֹת נֶאֶסְפוּ כֻלָּם לֵב אֶחָד בְּמָקוֹם אֶחָד׃ ");
INSERT INTO hebsg_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","וְהִנֵּה קוֹל שָׁאוֹן מִן־הַשָּׁמַיִם פִּתְאֹם שֹׁאֵן כִּשְׁאוֹן רַעַשׁ גָּדוֹל וַיִּמָּלֵא כָּל־בֵּית שִׁבְתָּם אֹתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","וַתֵּרָאֶינָה אֲלֵיהֶם לִשֹׁנוֹת כְּמַרְאֵה אֵשׁ אֲשֶׁר נִפְלְגוּ וְנִחֲתוּ אַחַת אַחַת עַל אֶחָד אֶחָד מֵהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","וַיִּמָּלְאוּ כֻלָּם רוּחַ הַקֹּדֶשׁ וַיָּחֵלּוּ לְדַבֵּר בִּלְשֹׁנוֹת אֲחֵרוֹת וַיּוֹצִיאוּ מִלִּים מִפִּיהֶם כַּאֲשֶׁר שָׂם בָּהֶם הָרוּחַ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","וִיהוּדִים יִרְאֵי אֱלֹהִים גָּרוּ בִירוּשָׁלַיִם מִכָּל־אַרְצוֹת הַגּוֹיִם אֲשֶׁר תַּחַת הַשָּׁמָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","וַיְהִי בְּהִשָּׁמַע קוֹל הַשָּׁאוֹן הַהוּא וַיְּתְאַסְּפוּ עַם־רָב וַתְּהִי מְבוּכָה בֵּינֵיהֶם כִּי־אִישׁ אִישׁ מֵהֶם שָׁמַע אֹתָם מְדַבְּרִים בִּלְשׁוֹן אַרְצוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","וַיִּשְׁתּוֹמְמוּ כֻלָּם וַיִּתְמְהוּ וַיֹּאמְרוּ אִישׁ אֶל־אָחִיו הֲלֹא כָּל־הַמְדַבְּרִים הָאֵלֶּה בְּנֵי הַגָּלִיל הֵמָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","וְאֵיךְ נִשְׁמַע מִפִּיהֶם וְכָל־אֶחָד מֵאִתָּנוּ שְׂפַת־אֶרֶץ מוֹלַדְתֵּנוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","שְׂפַת פָּרָס וּמָדַי וְעֵילָם ישְׁבֵי אֲרַם נַהֲרַיִם וִיהוּדָה וְקַפּוּדְקִיָּא פָּנְטוֹס וְאַסְיָא׃ ");
INSERT INTO hebsg_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","פְּרוּגְיָא וּפַמְפּוּלְיָא מִצְרַיִם וְחֶבֶל לוּב עַל־יַד קוּרִינִי וְגֵרִים וִיהוּדִים הַבָּאִים מֵרוֹמִי׃ ");
INSERT INTO hebsg_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","גַּם־שְׂפַת כְּרֵתִי וַעֲרָב אֲשֶׁר אֲנַחְנוּ לִלְשֹׁנֹתֵינוּ שֹׁמְעִים אֹתָם מְסַפְּרִים אֶת־נִפְלְאוֹת הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","וַיִּשְׁתּוֹמְמוּ כֻלָּם וַיִּבָּהֵלוּ וַיֹּאמְרוּ אִישׁ אֶל־רֵעֵהוּ מַה־זֹאת׃ ");
INSERT INTO hebsg_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","וַאֲחֵרִים לָעֲגוּ לָמוֹ וְאָמְרוּ כִּי־מְלֵאֵי תִירוֹשׁ הֵמָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","אָז יָקוּם פֶּטְרוֹס וְאַחַד הֶעָשָׂר עִמּוֹ וַיִּשָּׂא אֶת־קוֹלוֹ וַיַּעַן וַיֹּאמֶר אֲלֵיהֶם דְּעוּ לָכֶם זֹאת אִישׁ יְהוּדָה וְכָל־ישְׁבֵי יְרוּשָׁלַיִם הַאֲזִינוּ אִמְרָתִי׃ ");
INSERT INTO hebsg_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","כִּי לֹא שִׁכּוֹרִים אֵלֶּה כַּאֲשֶׁר תַּחְשְׁבוּן אַתֶּם כִּי הֲלֹא הַשָּׁעָה הַשְּׁלִישִׁית בַּיּוֹם הוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","אַךְ זֶה הוּא הַדָּבָר הָאָמוּר בְּיַד־יוֹאֵל הַנָּבִיא׃ ");
INSERT INTO hebsg_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","וְהָיָה בְּאַחֲרִית הַיָּמִים נְאֻם יְהוָֹה אֶשְׁפּוֹךְ אֶת־רוּחִי עַל־כָּל־בָּשָׂר וְנִבְּאוּ בְּנֵיכֶם וּבְנֹתֵיכֶם וּבַחוּרֵיכֶם חֶזְיֹנוֹת יִרְאוּ וְזִקְנֵיכֶם חֲלוֹמוֹת יַחֲלֹמוּן׃ ");
INSERT INTO hebsg_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","וְגַם עַל־עֲבָדַי וְעַל־שִׁפְחוֹתַי בַּיָּמִים הָהֵמָּה אֶשְׁפּוֹךְ אֶת־רוּחִי וְנִבָּאוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","וְנָתַתִּי מוֹפְתִים בַּשָּׁמַיִם מִמַּעַל וְאֹתוֹת בָּאָרֶץ מִתָּחַת דָּם וָאֵשׁ וְתִימְרוֹת עָשָׁן׃ ");
INSERT INTO hebsg_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","הַשֶּׁמֶשׁ יֵהָפֵךְ לְחשֶׁךְ וְהַיָּרֵחַ לְדָם לִפְנֵי בּוֹא יוֹם יְהוָֹה הַגָּדוֹל וְהַנּוֹרָא׃ ");
INSERT INTO hebsg_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","וְהָיָה כֹּל אֲשֶׁר־יִקְרָא בְּשֵׁם יְהוָֹה יִמָּלֵט׃ ");
INSERT INTO hebsg_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","אַנְשֵׁי יִשְׂרָאֵל הַקְשִׁיבוּ לִדְבָרַי אֵלֶּה הִנֵּה יֵשׁוּעַ הַנָּצְרִי אִישׁ נֶאֱמָן לָכֶם מֵאֵת הָאֱלֹהִים בִּגְבוּרוֹת בְּנִפְלָאוֹת וּבְמוֹפְתִים אֲשֶׁר עָשָׂה אֱלֹהִים עַל־יָדוֹ לְעֵינֵיכֶם כַּאֲשֶׁר יְדַעְתֶּם גַּם־אַתֶּם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","הוּא זֶה אֲשֶׁר מִסּוֹד אֱלֹהִים וּמִדַּעְתּוֹ מִקֶּדֶם נִגְזַר עָלָיו לְהִנָּתֵן לַמָּוֶת וְאַתֶּם בִּידֵי בְלִיַּעַל הוֹקַעְתֶּם וַהֲמִיתֶם אֹתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","וֵאלֹהִים הִתִּיר חֶבְלֵי הַמָּוֶת וַיְקִימֵהוּ מִן־הַמֵּתִים כִּי הַמָּוֶת לֹא עָצַר כֹּחַ לְהַחֲזִיק בּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","כִּי־עָלָיו אָמַר דָּוִד שִׁוִּיתִי יְהוָֹה לְנֶגְדִּי תָמִיד כִּי מִימִינִי בַּל־אֶמּוֹט׃ ");
INSERT INTO hebsg_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","לָכֵן שָׂמַח לִבִּי וַתָּגֶל לְשׁוֹנִי אַף־בְּשָׂרִי יִשְׁכֹּן לָבֶטַח׃ ");
INSERT INTO hebsg_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","כִּי לֹא־תַעֲזֹב נַפְשִׁי לִשְׁאוֹל לֹא־תִתֵּן חֲסִידְךָ לִרְאוֹת שָׁחַת׃ ");
INSERT INTO hebsg_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","הוֹדַעְתָּנִי אָרְחוֹת חַיִּים תַּשְׂבִּיעֵנִי שְׂמָחוֹת אֶת־פָּנֶיךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","אֲנָשִׁים אַחִים תְּנוּ לִי פִּתְחוֹן פֶּה לְדַבֵּר אֲלֵיכֶם לְעֵינֵי כֹל עַל־דָּוִד רֹאשׁ הָאָבוֹת כִּי גַם־מֵת וְגַם־נִקְבַּר וְקִבְרוֹ עִמָּנוּ עַד־הַיּוֹם הַזֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","וְהוּא בִּהְיוֹתוֹ נָבִיא וְיֹדֵעַ כִּי שְׁבוּעָה נִשְׁבַּע לוֹ אֱלֹהִים לְהוֹשִׁיב אֶחָד מִיֹּצְאֵי יְרֵכוֹ לְהָקִים אֶת־הַמָּשִׁיחַ כְּפִי הַבָּשָׂר עַל־כִּסְאוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","וּבַחֲזוֹתוֹ זֹאת מִקֶּדֶם דִּבֶּר עַל־תְּקוּמַת הַמָּשִׁיחַ כִּי לֹא־תַעֲזֹב נַפְשׁוֹ לִשְׁאוֹל וּבְשָׂרוֹ לֹא־יִרְאֶה שָׁחָת׃ ");
INSERT INTO hebsg_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","הוּא יֵשׁוּעַ זֶה אֲשֶׁר אֱלֹהִים הֲקִימוֹ מִן־הַמֵּתִים וַאֲנַחְנוּ כֻּלָּנוּ עֵדִים לוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","וְעַתָּה כִּי־נִשָּׂא לִימִין הָאֱלֹהִים וְאֶת־הַבְטָחַת רוּחַ הַקֹּדֶשׁ לָקַח מֵאֵת אָבִיו שָׁפַךְ אֶת־הָרוּחַ הַזֶּה כַּאֲשֶׁר אַתֶּם רֹאִים וְשֹׁמְעִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","כִּי דָוִד לֹא עָלָה הַשָּׁמָיְמָה וְהוּא בְּפִיו אָמַר נְאֻם יְהוָֹה לַאדֹנִי שֵׁב לִימִינִי׃ ");
INSERT INTO hebsg_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","עַד־אָשִׁית אֹיְבֶיךָ הֲדֹם לְרַגְלֶיךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","עַל־כֵּן יֵדַע־נָא כָּל־בֵּית יִשְׂרָאֵל בֶּאֱמֶת כִּי שָׂם אֱלֹהִים לְאָדוֹן וּלְמָשִׁיחַ אֶת־יֵשׁוּעַ זֶה אֲשֶׁר אַתֶּם הוֹקַעְתֶּם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","וַיְהִי כְשָׁמְעָם וַיִּגַּע הַדָּבָר כְּמַדְקְרוֹת חֶרֶב אֶל־לִבָּם וַיֹּאמְרוּ אֶל־פֶּטְרוֹס וְאֶל־יֶתֶר הַשְּׁלִיחִים אֲנָשִׁים אַחִים מָה אֵיפוֹא נַעֲשֶׂה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","וַיֹּאמֶר פֶּטְרוֹס אֲלֵיהֶם שׁוּבוּ מִדַּרְכֵיכֶם וְהִטָּבְלוּ כָּל־אִישׁ מִכֶּם בְּשֵׁם יֵשׁוּעַ הַמָּשִׁיחַ לִסְלִיחַת חַטֹּאתֵיכֶם וְאֶת־מַתְּנַת רוּחַ הַקֹּדֶשׁ תַּשִּׂיגוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","כִּי דְבַר הַהַבְטָחָה לָכֶם הוּא וְלִבְנֵיכֶם וּלְכָל־הָרְחוֹקִים לְכָל־אֲשֶׁר יִקְרָא אֹתָם לוֹ יְהוָֹה אֱלֹהֵינוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","וְכֵן בִּדְבָרִים רַבִּים אֲחֵרִים הֵעִיד בָּם וַיַּזְהִירֵם לֵאמֹר הִמָּלְטוּ־לָכֶם מִן־הַדּוֹר הָעִקֵּשׁ הַזֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","וַיִּשְׁמְעוּ אֶל־דְּבָרוֹ בְּשִׂמְחָה וַיִּטָּבֵלוּ עַד־אֲשֶׁר נוֹסְפוּ עֲלֵיהֶם בַּיּוֹם הַהוּא כִּשְׁלשֶׁת אַלְפֵי נָפֶשׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","וְשֹׁקְדִים הָיוּ תָמִיד עַל־תּוֹרַת הַשְּׁלִיחִים בְּהִתְחַבְּרוּתָם אֲלֵיהֶם וּבִפְרֹס לַחְמָם וּבִתְפִלָּתָם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","וְיִרְאָה נָפְלָה עַל־כָּל־הַנְּשָׁמָה וּמוֹפְתִים וְאֹתוֹת רַבִּים נַעֲשׂוּ בִּידֵי הַשְּׁלִיחִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","וְכָל־הַמַּאֲמִינִים יָשְׁבוּ כְאַחִים יַחְדָּו וְכָל־אֲשֶׁר לָהֶם נָתְנוּ לִהְיוֹת לְנַחֲלַת כֻּלָּם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","וַיִּמְכְּרוּ אֶת־אֲחֻזָּתָם וְאֶת־קִנְיָנָם וַיְחַלְּקוּ אֹתָם לְכֻלָּם לְאִישׁ אִישׁ כְּפִי מַחְסֹרוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","וּמִדֵּי יוֹם בְּיוֹם זֶה דַרְכָּם תָּמִיד לְבַקֵּר בַּהֵיכָל בְּלֵב אֶחָד וְלַחְמָם פָּרְסוּ בְּבָתֵיהֶם וַיֹּאכְלוּ לֶחֶם חֻקָּם בְּשִׂמְחָה וּבְתֹם לֵבָב׃ ");
INSERT INTO hebsg_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","וַיְבָרְכוּ אֶת־הָאֱלֹהִים וַיִּמְצְאוּ חֵן בְּעֵינֵי כָל־הָעָם וְהָאָדוֹן הוֹסִיף יוֹם יוֹם עַל־הָעֵדָה אֶת־הַנּוֹשָׁעִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","וּפֶטְרוֹס וְיוֹחָנָן עָלוּ אֶל־בֵּית הַמִּקְדָּשׁ לְעֵת הַתְּפִילָּה בַּשָּׁעָה הַתְּשִׁיעִית׃ ");
INSERT INTO hebsg_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","וְאִישׁ פִּסֵּחַ מִבֶּטֶן אִמּוֹ הוּבָא שָׁמָּה אֲשֶׁר הוֹשִׁיבֻהוּ יוֹם יוֹם לִפְנֵי שַׁעַר הַהֵיכָל הַנִּקְרָא שַׁעַר הַתִּפְאֶרֶת לְבַקֵּשׁ נְדָבוֹת מִיַּד בָּאֵי הַהֵיכָל׃ ");
INSERT INTO hebsg_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","וּבִרְאֹתוֹ אֶת־פֶּטְרוֹס וְאֵת־יוֹחָנָן בָּאִים אֶל־הַהֵיכָל וַיְבַקֵּשׁ מִיָּדָם נְדָבָה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","וַיָּשֶׂם פֶּטְרוֹס אֶת־עֵינָיו עָלָיו וְכֵן גַּם־יוֹחָנָן וַיֹּאמַר הַבִּיטָה אֵלֵינוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","וַיִּפֶן אֲלֵיהֶם בְּתֹחַלְתּוֹ כִּי יַשִּׂיג מִיָּדָם מְאוּמָה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","וַיֹּאמֶר פֶּטְרוֹס כֶּסֶף וְזָהָב אֵין־לִי אֲבָל אֵת אֲשֶׁר בְּיָדִי אֶתֶּן־לָךְ בְּשֵׁם־יֵשׁוּעַ הַמָּשִׁיחַ הַנָּצְרִי קוּם וְהִתְהַלֵּךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","וַיֶּאֱחֹז בְּיַד יְמִינוֹ וַיְקִימֵהוּ וּפִתְאֹם הִתְחַזְּקוּ רַגְלָיו וְקַרְסֻלָּיו׃ ");
INSERT INTO hebsg_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","וַיְדַלֵּג מִתַּחְתָּיו וַיַּעֲמֹד וַיִּתְהַלֵּךְ וַיָּבֹא עִמָּהֶם אֵל־הַהֵיכָל הוֹלֵךְ וּמְדַלֵּג וּמְשִׁבֵּחַ אֶת־הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","וַיִּרְאֵהוּ כָל־הָעָם מִתְהַלֵּךְ וּמְשַׁבֵּחַ אֶת־הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","וַיַּכִּירוּ אֹתוֹ כִּי הוּא זֶה הַיּשֵׁב לִפְנֵי הַהֵיכָל לִפְנֵי שַׁעַר הַתִּפְאֶרֶת לְבַקֵּשׁ נְדָבוֹת וַיִּמָּלְאוּ תִמָּהוֹן וּפַלָּצוּת עַל־אֲשֶׁר נַעֲשָׂה לּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","וְהוּא כִי דָבַק אַחֲרֵי פֶטְרוֹס וְיוֹחָנָן וְכָל־הָעָם רָצוּ אֲלֵיהֶם אֶל־הָאוּלָם הַנִּקְרָא אוּלָם שְׁלֹמֹה וַיָּשֹׁמּוּ עַד־מְאֹד׃ ");
INSERT INTO hebsg_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","וַיַּרְא פֶּטְרוֹס וַיַּעַן וַיֹּאמֶר אֶל־הָעָם אַנְשֵׁי יִשְׂרָאֵל לָמָּה תִשְׁתּוֹמְמוּ עַל־זֹאת וְלָמָּה תַבִּיטוּ אֵלֵינוּ כְּאִלּוּ הוּא מִתְהַלֵּךְ בְּכֹחֵנוּ אוֹ בְצִדְקָתֵנוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","אֱלֹהֵי אַבְרָהָם יִצְחָק וְיַעֲקֹב אֱלֹהֵי אֲבוֹתֵינוּ הִגְדִּיל כְּבוֹד יֵשׁוּעַ עַבְדּוֹ אֲשֶׁר אַתֶּם הִסְגַּרְתֶּם אֹתוֹ וְכִחַשְׁתֶּם בּוֹ לִפְנֵי פִילָטוֹס כַּאֲשֶׁר שָׁפַט לְשַׁלְּחוֹ לַחָפְשִׁי׃ ");
INSERT INTO hebsg_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","וְאַתֶּם כִּחַשְׁתֶּם בַּקָּדוֹשׁ וּבַצַדִּיק וּשְׁאֶלְתֶּם כִּי־יֻחַן לָכֶם אִישׁ רֹצֵחַ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","וְאֶת־שַׂר הַחַיִּים הֲרַגְתֶּם אֲשֶׁר אֱלֹהִים הֵקִים אֹתוֹ מִן־הַמֵּתִים וַאֲנַחְנוּ עֵדָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","וּבֶאֱמוּנָתֵנוּ בִשְׁמוֹ שְׁמוֹ נָתַן כֹּחַ לָאִישׁ הַזֶּה אֲשֶׁר אַתֶּם רֹאִים וּמַכִּירִים כִּי עַל־יָדוֹ נָתְנָה־לּוֹ אֱמוּנָתֵנוּ מַרְפֵּא לְעַצְמוֹתָיו לְעֵינֵי כֻלְּכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","וְעַתָּה אֶחָי יָדַעְתִּי כִּי בִּבְלִי־דַעַת עֲשִׂיתֶם גַּם־אַתֶּם גַּם־שָׂרֵיכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","אֲבָל הַדָּבָר כִּי יְעֻנֶּה הַמָּשִׁיחַ הֵקִים אֱלֹהִים כַּאֲשֶׁר הִגִּיד מִקֶּדֶם בְּיַד־כָּל־נְבִיאָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","עַל־כֵּן שׁוּבוּ סוּרוּ מִדַּרְכֵיכֶם לְמַעַן תִּמָּחֶינָה חַטֹּאתֵיכֶם וְתָבֹאנָה עִתּוֹת מְשִׁיבוֹת נֶפֶשׁ מִלִּפְנֵי יְהוָֹה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","וְיִשְׁלַח אֶת־יֵשׁוּעַ מְשִׁיחוֹ אֲשֶׁר מְבֻשָׂר לָכֶם מִקֶּדֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","אֲשֶׁר יְקַבְּלֵהוּ זְבוּל הַשָּׁמַיִם עַד־אֲשֶׁר יָשׁוּב הַכֹּל עַל־מְכוֹנוֹ כַּאֲשֶׁר דִּבֶּר אֱלֹהִים בְּיַד־נְבִיאָיו הַקְּדוֹשִׁים מִימוֹת עוֹלָם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","הֵן משֶׁה אָמַר אֶל־אֲבוֹתֵינוּ נָבִיא מִקֶּרֶב אֲחֵיכֶם כָּמֹנִי יָקִים לָכֶם יְהוָֹה אֱלֹהִים אֵלָיו תִּשְׁמְעוּן כְּכֹל אֲשֶׁר יְדַבֵּר אֲלֵיכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","וְהָיָה כָּל־הַנֶּפֶשׁ אֲשֶׁר לֹא־תִשְׁמַע אֶל־הַנָּבִיא הַהוּא וְנִכְרְתָה מֵעַמֶּיהָ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","וְגַם כָּל־הַנְּבִיאִים מִשְּׁמוּאֵל וְהַבָּאִים אַחֲרָיו אֲשֶׁר נִבָּאוּ כֻּלָּם הִגִּידוּ דִּבְרֵי הַיָּמִים הָאֵלֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","אַתֶּם בְּנֵי הַנְּבִיאִים וְהַבְּרִית אֲשֶׁר כָּרַת אֱלֹהִים עִם־אֲבוֹתֵיכֶם לֵאמֹר אֶל־אַבְרָהָם וְנִבְרְכוּ בְזַרְעֲךָ כֹּל מִשְׁפְּחוֹת הָאֲדָמָה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","וְלָכֶם הֵקִים אֱלֹהִים אֶת־עַבְדּוֹ יֵשׁוּעַ רִאשֹׁנָה וַיִּשְׁלָחֵהוּ לְבָרֵךְ אֶתְכֶם כִּי תָשׁוּבוּ אִישׁ אִישׁ מֵעֲוֹנֹתֵיכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","וַיְהִי כְּדַבְּרָם אֶל־הָעָם וַיָּקוּמוּ עֲלֵיהֶם הַכֹּהֲנִים וְשַׂר צְבָא הַהֵיכָל וְהַצַּדּוּקִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","כִּי־צַר לָהֶם עַל־אֲשֶׁר הוֹרוּ לָעָם וְעַל־אֲשֶׁר הִגִּדוּ בְיֵשׁוּעַ אֶת־תְּחִיַּת הַמֵּתִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","וַיִשְׁלְחוּ יְדֵיהֶם בָּם וַיִּתְּנוּם בַּמִּשְׁמָר עַד־לְמָחָר כִּי־כְבָר הִגִּיעַ הָעָרֶב׃ ");
INSERT INTO hebsg_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","אַךְ רַבִּים מִשֹּׁמְעֵי דִבְרֵי הַבְּשׂוֹרָה הֶאֱמִינוּ וַיְהִי מִסְפַּר הָאֲנָשִׁים כַּחֲמֵשֶׁת אֲלָפִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","וַיְהִי מִמָּחֳרָת וַיִּקָּהֲלוּ הַשָּׂרִים הַזְּקֵנִים וְהַסּוֹפְרִים בִּירוּשָׁלָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","וְחָנָן הַכֹּהֵן הַגָּדוֹל וְקַיָּפָה וְיוֹחָנָן וַאֲלֶכְסַנְדְּרוֹס וְכָל־אֲשֶׁר לְמִשְׁפַּחַת בֵּית הַכֹּהֵן הַגָּדוֹל׃ ");
INSERT INTO hebsg_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","וַיַּעֲמִידוּ אֹתָם בַּתָּוֶךְ וַיִּשְׁאָלוּם לֵאמֹר בְּכֹחַ־מִי אוֹ בְּשֶׁם־מִי עֲשִׂיתֶם כָּזֹאת׃ ");
INSERT INTO hebsg_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","וּפֶטְרוֹס מָלֵא רוּחַ הַקֹּדֶשׁ עָנָה אֹתָם לֵאמֹר שְׁמָעוּנִי שָׂרֵי הָעָם וְהַזְּקֵנִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","כִּי־נֵחָקֵר הַיּוֹם עַל־אֹדוֹת מַעֲשֶׂה טוֹב לְיָדוּעַ חֹלִי וּבְמִי בָּאַתְהוּ יְשׁוּעָה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","יִוָּדַע לָכֶם כֻּלְּכֶם וּלְכָל־עַם יִשְׂרָאֵל כִּי־בְשֵׁם יֵשׁוּעַ הַמָּשִׁיחַ הַנָּצְרִי אֲשֶׁר אַתֶּם צְלַבְתֶּם וֵאלֹהִים הֱקִימוֹ מִן־הַמֵּתִים בִּשְׁמוֹ הוּא עֹמֵד לִפְנֵיכֶם בָּרִיא אוּלָם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","זֹאת הִיא הָאֶבֶן אֲשֶׁר מְאַסְתֶּם אַתֶּם הַבּוֹנִים וַתְּהִי לְרֹאשׁ פִּנָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","וְאֵין יֶשַׁע בִּלְתּוֹ כִּי לֹא־נִתַּן שֵׁם אַחֵר לִבְנֵי אָדָם תַּחַת הַשָּׁמַיִם אֲשֶׁר־בּוֹ נִוָּשֵׁעָה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","וַיְהִי כַּאֲשֶׁר רָאוּ אֹמֶץ לֵב פֶּטְרוֹס וְיוֹחָנָן וְגַם־הֵבִינוּ כִּי הֶדְיוֹטִים הֵם וְלֹא מְלֻמְּדֵי סֵפֶר כֵּן תָּמְהוּ עֲלֵיהֶם וַיַּכִּירוּם כִּי הָיוּ עִם־יֵשׁוּעַ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","וּבִרְאֹתָם אֶת־הָאִישׁ הַנִּרְפָּא עֹמֵד עִמָּהֶם לֹא יָכְלוּ לַעֲנוֹת בָּם דָּבָר׃ ");
INSERT INTO hebsg_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","וַיְצַוּוּ אֹתָם לָצֵאת אֶל־מִחוּץ לַסַּנְהֶדְרִין וַיִּוָּעֲצוּ בֵּינֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","וַיֹּאמְרוּ מַה־נַּעֲשֶׂה לָאֲנָשִׁים הָאֵלֶּה כִּי מוֹפֵת בָּרוּר נַעֲשָׂה עַל־יְדֵיהֶם גָּלוּי הוּא לְכָל־ישְׁבֵי יְרוּשָׁלַיִם וְאֵין לְכַחֵשׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","אַךְ פֶּן־תִּפְרֹץ הַשְּׁמוּעָה וּפָשְׁתָה בָעָם נִגְעֲרָה בָּם לְבִלְתִּי דַבֵּר עוֹד לְאִישׁ בַּשֵּׁם הַזֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","וַיִּקְרְאוּ אֹתָם וַיְצַוּוּ עֲלֵיהֶם לְבִלְתִּי דַבֵּר דָּבָר וְלֹא לְלַמֵּד בְּשֵׁם יֵשׁוּעַ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","וַיַּעֲנוּ אֹתָם פֶּטְרוֹס וְיוֹחָנָן וַיֹּאמְרוּ הֲכִי טוֹב בְּעֵינֵי הָאֱלֹהִים כִּי נִשְׁמַע אֲלֵיכֶם מִשְּׁמֹעַ אֵלָיו שִׁפְטוּ־נָא אַתֶּם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","כִּי לֹא נוּכַל לַחֲדֹל מִדַּבֵּר אֵת אֲשֶׁר רָאִינוּ וְשָׁמָעְנוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","וְהֵם הוֹסִיפוּ לִגְעָר־בָּם וַיְשַׁלְּחוּם מִבְּלִי מְצֹא יָדַיִם לַעֲנוֹשׁ אֹתָם מִיִּרְאָתָם אֶת־הָעָם כִּי כֻלָּם נָתְנוּ כָבוֹד לֵאלֹהִים עַל־דְּבַר הַמַּעֲשֶׂה הַהוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","כִּי לְמַעְלָה מֵאַרְבָּעִים שָׁנָה הָיָה הָאִישׁ אֲשֶׁר נַעֲשָׂה־עִמּוֹ אוֹת הָרְפוּאָה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","וַיְהִי כַּאֲשֶׁר שֻׁלְּחוּ וַיָּבֹאוּ אֶל־אֲחֵיהֶם וַיְסַפְּרוּ לָהֶם אֵת אֲשֶׁר אָמְרוּ אֲלֵיהֶם רָאשֵׁי הַכֹּהֲנִים וְהַזְּקֵנִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","וְהֵם שָׁמְעוּ וַיִּשְׂאוּ אֶת־קוֹלָם בְּלֵב אֶחָד אֶל־אֱלֹהִים וַיֹּאמְרוּ יְהוָֹה אַתָּה הוּא אֲשֶׁר עָשִׂיתָ אֶת־הַשָּׁמַיִם וְאֶת־הָאָרֶץ וְאֶת־הַיָּם וְאֶת־כָּל־אֲשֶׁר־בָּם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","וּבְפִי עַבְדְּךָ דָּוִד אָבִינוּ אָמַרְתָּ בְּרוּחַ הַקֹּדֶשׁ לָמָּה רָגְשׁוּ גוֹיִם וּלְאֻמִּים יֶהְגּוּ־רִיק׃ ");
INSERT INTO hebsg_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","יִתְיַצְּבוּ מַלְכֵי־אֶרֶץ וְרוֹזְנִים נוֹסְדוּ־יַחַד עַל־יְהוָֹה וְעַל־מְשִׁיחוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","כִּי בֶאֱמֶת עַל־יֵשׁוּעַ עַבְדְּךָ הַקָּדוֹשׁ אֲשֶׁר אַתָּה נָסַכְתָּ נוֹסְדוּ יַחְדָּו בָּעִיר הַזֹּאת גַּם־הוֹרְדוּס וּפָנְטִיּוֹס פִּילָטוֹס עִם־הַגּוֹיִם וַעֲמָמֶיךָ יִשְׂרָאֵל׃ ");
INSERT INTO hebsg_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","וַיַּעֲשׂוּ אֵת אֲשֶׁר יֵעָשֶׂה לְפִי יָדְךָ וּלְפִי עֲצָתְךָ אֲשֶׁר חָרַצְתָּ מִקֶּדֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","וְעַתָּה יְהוָֹה הַשְׁקִיפָה אֶל־גַּעֲרָתָם וּתְנָה לַעֲבָדֶיךָ לְדַבֵּר דְּבָרְךָ בְּיָד רָמָה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","כִּי תִשְׁלַח יָדְךָ לְרַפֵּא חוֹלִים וְלַעֲשׂוֹת אֹתוֹת וּמוֹפְתִים בְּשֵׁם יֵשׁוּעַ עַבְדְּךָ הֲקָּדוֹשׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","וַיְהִי בְּהִתְפַּלְּלָם וַיָּנַע הַמָּקוֹם אֲשֶׁר נִקְהֲלוּ שָׁמָּה וַיִּמָּלְאוּ כֻלָּם רוּחַ הַקֹּדֶשׁ וַיְדַבְּרוּ דְבַר הָאֱלֹהִים בְּיָד רָמָה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","וּקְהַל הַמַּאֲמִינִים הָיָה לָהֶם לֵב אֶחָד וְנֶפֶשׁ אַחַת וְלֹא אָמַר אִישׁ מֵהֶם עַל־שֶׁלּוֹ כִּי לוֹ הוּא כִּי אִם־אֶת־אֲשֶׁר הָיָה לָהֶם לְנַחֲלַת כֻּלָּם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","וְהַשְּׁלִיחִים נָתְנוּ עֵדוּתָם עַל־תְּחִיַּת הָאָדוֹן יֵשׁוּעַ בְּעֹז גָּדוֹל וְחֵן רַב הוּצַק עַל־פְּנֵי כֻלָּם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","וְלֹא נִמְצָא בָהֶם אִישׁ חָסֵר מְאוּמָה כִּי כָל־בַּעֲלֵי שָׂדוֹת וּבָתִּים מָכְרוּ אֹתָם וַיָּבִיאוּ אֶת־כֶּסֶף מְחִירָם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","אֲשֶׁר שָׂמוּ לְרַגְלֵי הַשְּׁלִיחִים לְהֵחָלֵל לְאִישׁ אִישׁ כְּדֵי מַחְסֹרוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","וְיוֹסֵף אֲשֶׁר קָרְאוּ לוֹ הַשְּׁלִיחִים בַּר־נַבָּא עַל־כִּי הוּא מוֹכִיחַ כְּנָבִיא אִישׁ לֵוִי מֵאֶרֶץ קַפְרוֹס׃ ");
INSERT INTO hebsg_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","מָכַר אֶת־הַשָּׂדֶה אֲשֶׁר הָיָה לוֹ וַיָּבֵא וַיָּשֶׂם אֶת־כַּסְפּוֹ לְרַגְלֵי הַשְּׁלִיחִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","וְאִישׁ אֶחָד חֲנַנְיָה שְׁמוֹ וְשֵׁם אִשְׁתּוֹ שַׁפִּירָא מָכַר אֶת־אֲחֻזָּתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","וַיַּסְתֵּר חֵלֶק מִן־הַמְּחִיר וְאִשְׁתּוֹ יֹדָעַת וְחֵלֶק אֶחָד הֵבִיא וַיָּשֶׂם לְרַגְלֵי הַשְּׁלִיחִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","וַיֹּאמֶר פֶּטְרוֹס לָמָּה־זֶּה חֲנַנְיָה מִלֵּא הַשָּׂטָן אֶת־לִבְּךָ לְכַחֵשׁ בְּרוּחַ הַקֹּדֶשׁ וּלְהַסְתִּיר מִן־מְחִיר הַשָּׂדֶה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","הֲלֹא לְךָ הָיָה עַד לֹא־נִמְכַּר וְגַם־אַחֲרֵי הִמָּכְרוֹ הֲלֹא הָיָה בְיָדֶךָ לָמָּה מְלָאֲךָ לִבְּךָ לַעֲשׂוֹת כֵּן לֹא בַאֲנָשִׁים שִׁקַּרְתָּ כִּי אִם־בֵּאלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","כִּשְׁמֹעַ חֲנַנְיָה אֶת־הַדְּבָרִים הָאֵלֶּה וַיִּפֹּל אַרְצָה וַתֵּצֵא נִשְׁמָתוֹ וְיִרְאָה גְדוֹלָה נָפְלָה עַל כָּל־הַשֹּׁמְעִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","וַיָּקוּמוּ הַנְּעָרִים וַיַּאַסְפוּ אֹתוֹ וַיֹּצִיאֻהוּ וַיִּקְבְּרֻהוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","וַיְהִי כְּמִשְׁלֹש שָׁעוֹת וַתָּבוֹא אִשְׁתּוֹ וְלֹא יָדְעָה אֵת אֲשֶׁר נַעֲשָׂה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","וַיַּעַן פֶּטְרוֹס וַיֹּאמֶר אֵלֶיהָ הַגִּידִי־לִי הַבְעַד כֶּסֶף זֶה מְכַרְתֶּם אֶת־הַשָּׂדֶה וַתֹּאמֶר הֵן בְּעַד כֶּסֶף זֶה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","וַיֹּאמֶר אֵלֶיהָ פֶּטְרוֹס לָמָּה־זֶּה קְשַׁרְתֶּם יַחַד לְנַסּוֹת אֶת־רוּחַ יְהוָֹה הִנֵּה רַגְלֵי הַמְקַבְּרִים אֶת־אִישֵׁךְ בַּפֶּתַח וּנְשָׂאוּךְ גַּם־אוֹתֵךְ הַחוּצָה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","וַתִּפֹּל פִּתְאֹם לְרַגְלָיו וַתֵּצֵא נִשְׁמָתָהּ וַיָּבֹאוּ הַנְּעָרִים וַיִּמְצָאֻהָ כִּי מֵתָה וַיּוֹצִיאוּ אֹתָהּ וַיִּקְבְּרֻהָ אֵצֶל אִישָׁהּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","וַתְּהִי יִרְאָה גְדוֹלָה עַל כָּל־הַקָּהָל וְעַל כָּל־הַשֹּׁמְעִים אֶת־הַדָּבָר הַזֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","וְאֹתוֹת וּמוֹפְתִים רַבִּים נַעֲשׂוּ בְּקֶרֶב הָעָם עַל־יְדֵי הַשְּׁלִיחִים וַיִּקָּהֲלוּ כֻלָּם בְּלֵב אֶחָד בְּאוּלָם שְׁלֹמֹה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","וּמִשְּׁאָר הָאֲנָשִׁים אֵין אִישׁ אֲשֶׁר מְלָאוֹ לִבּוֹ לְדָבְקָה־בָּם אַךְ־יָקְרוּ בְּעֵינֵי הָעָם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","וּמַאֲמִינִים רַבִּים נִסְפְּחוּ עַל־הָאָדוֹן הֲמוֹן אֲנָשִׁים וְנָשִׁים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","עַד כִּי־נָשְׂאוּ אֶת־הַחוֹלִים אֶל־הָרְחֹבוֹת וְהִשְׁכִּיבוּם בְּמִטוֹת וּמִשְׁכָּבוֹת בְּאָמְרָם כִּי פֶטְרוֹס יַעֲבֹר שָׁמָּה וְצִלּוֹ יִנָּטֶה עַל־אֲחָדִים מֵהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","וְגַם־הֲמוֹן עָם מִן־הֶעָרִים אֲשֶׁר מִסָּבִיב לִירוּשָׁלָיִם נָהֲרוּ וַיָּבִיאוּ אֶת־הַחוֹלִים וְאֶת־הַנַּעֲנִים תַּחַת יְדֵי רוּחוֹת טְמֵאוֹת וְכֻלָּם נִרְפָּאוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","וַיָּקָם הַכֹּהֵן הַגָּדוֹל וְכָל־הַנִּלְוִים עָלָיו וְהֵם מֵעֲדַת הַצַּדּוּקִים וַיִּמָּלְאוּ קִנְאָה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","וַיִּשְׁלְחוּ אֶת־יְדֵיהֶם בַּשְּׁלִיחִים וַיִּתְּנוּם בְּמִשְׁמַר הַקָּהַל׃ ");
INSERT INTO hebsg_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","וַיְהִי בַלַּיְלָה וַיִּפְתַּח מַלְאַךְ יְהוָֹה אֶת־דַּלְתֵי בֵית־הַכֶּלֶא וַיּוֹצִיאֵם וַיֹּאמַר׃ ");
INSERT INTO hebsg_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","לְכוּ וְעִמְדוּ בַהֵיכָל וְדַבְּרוּ אֶל־הָעָם אֶת־כָּל־דִּבְרֵי הַחַיִּים הָאֵלֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","וַיִּשְׁמְעוּ וַיַּשְׁכִּימוּ בַבֹּקֶר וַיָּבֹאוּ אֶל־הַהֵיכָל וַיְלַמֵּדוּן וַיָּבֹא הַכֹּהֵן הַגָּדוֹל וַאֲשֶׁר אִתּוֹ וַיַּקְהִלוּ אֶת־הַסַּנְהֶדְרִין וְאֶת־כָּל־זִקְנֵי בְנֵי יִשְׂרָאֵל וַיִּשְׁלְחוּ לְהָבִיא אֹתָם מִבֵּית הַכֶּלֶא׃ ");
INSERT INTO hebsg_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","וְהַמְשָׁרְתִים בָּאוּ וְלֹא מְצָאוּם בְּבֵית הַכֶּלֶא וַיָּשֻׁבוּ וַיַּגִּידוּ לֵאמֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","מָצָאנוּ אֶת־בֵּית הַכֶּלֶא סָגוּר וּמְסֻגָּר וְאֶת־הַשֹּׁמְרִים עֹמְדִים עַל־מִשְׁמַרְתָּם לִפְנֵי הַשְּׁעָרִים וַנִּפְתַּח וַנֵּרֶא וְאֵין אָדָם בַּבַּיִת פְּנִימָה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","וְהַכֹּהֵן וְשַׂר צְבָא הַהֵיכָל וְרָאשֵׁי הַכֹּהֲנִים בְּשָׁמְעָם אֶת־הַדְּבָרִים הָאֵלֶּה נָבֹכוּ עַד־מְאֹד לֵאמֹר מַה־יִּהְיֶה מִכָּל־אֵלֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","אָז בָּא אִישׁ אֶחָד וְהִגִּיד לָהֶם לֵאמֹר הָאֲנָשִׁים אֲשֶׁר נְתַתֶּם בְּבֵית הַכֶּלֶא הִנָּם עֹמְדִים בַּהֵיכָל וּמוֹרִים אֶת־הָעָם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","וַיֵּלֶךְ שַׂר הַצָּבָא עִם־מְשָׁרְתָיו וַיִּקָּחֵם אַךְ־לֹא בְחָזְקָה כִּי יָרְאוּ מִפְּנֵי הָעָם פֶּן יִסָּקֵלוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","וַיָּבִיאוּ אֹתָם וַיַּעֲמִידוּם לִפְנֵי הַסַּנְהֶדְרִין וַיִּשְׁאַל אֹתָם הַכֹּהֵן הַגָּדוֹל לֵאמֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","הֲלֹא צַוֹּה צִוִּינוּ עֲלֵיכֶם לְבִלְתִּי הוֹרֹת בַּשֵּׁם הַזֶּה וְאַתֶּם הִנֵּה מִלֵּאתֶם אֶת־יְרוּשָׁלַיִם תּוֹרַת פִּיכֶם וּבִקַּשְׁתֶּם לְהָבִיא עָלֵינוּ דַּם הָאִישׁ הַזֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","וַיַּעַן פֶּטְרוֹס וְהַשְּׁלִיחִים וַיֹּאמְרוּ הֲלֹא עָלֵינוּ לִשְׁמֹעַ אֶל־מִצְוַת אֱלֹהִים מִשְּׁמֹעַ אֶל־מִצְוַת אֲנָשִׁים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","אֱלֹהֵי אֲבוֹתֵינוּ הֵקִים אֶת־יֵשׁוּעַ אֲשֶׁר שְׁלַחְתֶּם בּוֹ יָד וַתִּתְלוּ אֹתוֹ עַל־הָעֵץ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","אֹתוֹ הֵרִים אֱלֹהִים בִּימִינוֹ לְשַׂר וּלְמוֹשִׁיעַ לְיִשְׂרָאֵל לְהָשִׁיב אֶת־לִבָּם וְלִסְלוֹחַ לָהֶם אֶת־חַטֹּאתֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","וַאֲנַחְנוּ עֵדִים וְכֵן רוּחַ הַקֹּדֶשׁ אֲשֶׁר חָלַק אֱלֹהִים לְשֹׁמְעָיו עֵד עַל־הַדְּבָרִים הָאֵלֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","וַיְהִי כְשָׁמְעָם וַיִּגַּע הַדָּבָר עַד־נַפְשָׁם וַיִתְנַכְּלוּ אֹתָם לַהֲמִיתָם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","וַיָּקָם אֶחָד מִן־הַפְּרוּשִׁים מִקֶּרֶב הַסַּנְהֶדְרִין וּשְׁמוֹ גַּמְלִיאֵל מוֹרֵה הַתּוֹרָה וְנִכְבָּד בְּעֵינֵי כָל־הָעָם וַיְצַו לְהוֹצִיא אֶת־הַשְּׁלִיחִים מִלִּפְנֵיהֶם מְעַט מִזְעָר׃ ");
INSERT INTO hebsg_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","וַיֹּאמֶר אֲלֵיהֶם אַנְשֵׁי יִשְׂרָאֵל הִשָּׁמְרוּ לָכֶם בָּאֲשֶׁר אַתֶּם אֹמְרִים לַעֲשׂוֹת לָאֲנָשִׁים הָאֵלֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","כִּי לִפְנֵי הַיָּמִים הָאֵלֶּה קָם תּוֹדָס אֲשֶׁר הִתְנַשֵּׂא לֵאמֹר אֲנִי הוּא הַגָּבֶר וּכְאַרְבַּע מֵאוֹת אִישׁ הִתְלַקְּטוּ אֵלָיו עַד אֲשֶׁר־נֶהֱרָג וְכָל־הַנִּלְוִים עָלָיו נָפֹצוּ וְהָיוּ כְּלֹא הָיוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","וְאַחֲרָיו קָם יְהוּדָה הַגְּלִילִי בִּימֵי הַמִּפְקָד אֲשֶׁר הִדִּיחַ עַם־רָב אַחֲרָיו וְגַם־הוּא נָפַל וְכָל־הַנִּלְוִים עָלָיו נִפְזָרוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","וְעַתָּה אֲנִי אֹמֵר אֲלֵיכֶם חִדְלוּ לָכֶם מִן־הָאֲנָשִׁים הָאֵלֶּה וְהַנִּיחוּ לָהֶם כִּי אִם־מֵאָדָם יָצְאָה הָעֵצָה וְהַפְּעֻלָּה הַזֹּאת הוּפֵר תּוּפָר׃ ");
INSERT INTO hebsg_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","וְאִם־מֵאֵת אֱלֹהִים יָצְאָה לֹא תוּכְלוּ לַהֲפִירָהּ פֶּן־תִּמָּצְאוּ נִלְחָמִים בֵּאלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","וַיִּשְׁמְעוּ בְקוֹלוֹ וַיִּקְרְאוּ אֶל־הַשְּׁלִיחִים וְאַחֲרֵי אֲשֶׁר יִסְּרוּ אֹתָם וְצִוּוּ עֲלֵיהֶם לְבִלְתִּי דַבֵּר עוֹד בְּשֵׁם יֵשׁוּעַ שִׁלְּחוּם לְדַרְכָּם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","וְהֵם יָצְאוּ שְׂמֵחִים מִלִּפְנֵי הַסַּנְהֶדְרִין עַל־כִּי נֶחְשְׁבוּ רְאוּיִם לָשֵׂאת חֶרְפָּה עַל־שְׁמוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","וְלֹא חָדְלוּ יוֹם יוֹם לְלַמֵּד בְּבֵית הַמִּקְדַּשׁ אוֹ בְּבָתֵּי אֲנָשִׁים וּלְבַשֵּׂר בְּשׂוֹרַת יֵשׁוּעַ הַמָּשִׁיחַ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","וְהַתַּלְמִידִים גָּבְרוּ הָלוֹךְ וְגָבֹר בַּיָּמִים הָהֵם וַיִּלֹּנוּ הַתַּלְמִידִים הַיְּוָנִים עַל־הָעִבְרִיִּים לֵאמֹר כִּי הִתְעַלְּמוּ מֵאַלְמְנוֹתֵיהֶם וְלֹא נָתְנוּ לָהֶן יוֹם יוֹם אֶת־מַחְסוֹרָן׃ ");
INSERT INTO hebsg_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","וַיִּקְרְאוּ שְׁנֵים הֶעָשָׂר אֶל־קְהַל הַתַּלְמִידִים וַיֹּאמְרוּ לֹא־נָכוֹן לָנוּ לַעֲזֹב אֶת־דְּבַר הָאֱלֹהִים וְלַעֲבֹד עֲבֹדַת הַשֻּׁלְחָנוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","עַל־כֵּן אַחֵינוּ לְכוּ חֲזוּ מִכֶּם שִׁבְעָה אֲנָשִׁים יְדֻעִים מְלֵאֵי רוּחַ הַקֹּדֶשׁ וּמְלֵאֵי חָכְמָה וְאֹתָם נַפְקִידָה עַל־הָעֲבֹדָה הַזֹּאת׃ ");
INSERT INTO hebsg_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","וַאֲנַחְנוּ עַל־מִשְׁמֶרֶת הַתְּפִלָּה נַעֲמֹדָה וְעַל־עֲבֹדַת דְּבַר הַבְּשׂוֹרָה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","וַיִּיטַב הַדָּבָר בְּעֵינֵי כָל־הַקָּהָל וַיִּבְחֲרוּ אֶת־סְטְפָנוֹס אִישׁ מָלֵא אֱמוּנָה וְרוּחַ הַקֹּדֶשׁ וְאֶת־פִּילִפּוֹס וְאֶת־פְּרוֹכוֹרוֹס וְאֶת־נִיקָנוֹר וְאֶת־טִימוֹן וְאֶת־פַּרְמְנָס וְאֶת־נִיקְלָס גֵּר אַנְטְיוֹכְיָא׃ ");
INSERT INTO hebsg_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","אֶת־אֵלֶּה הֶעֱמִידוּ לִפְנֵי הַשְּׁלִיחִים וְהֵם הִתְפַּלְּלוּ וְסָמְכוּ אֶת־יְדֵיהֶם עֲלֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","וַיְהִי דְבַר אֱלֹהִים הֹלֵךְ הָלֹךְ וּפָרֹץ וּמִסְפַּר הַתַּלְמִידִים הָלוֹךְ וָרָב עַד־מְאֹד בִּירוּשָׁלַיִם וְגַם־הָמוֹן רָב מִן־הַכֹּהֲנִים נָטוּ אַחֲרֵי הָאֱמוּנָה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","סְטְפָנוֹס אִישׁ מָלֵא חֶסֶד וּגְבוּרָה עָשָׂה אֹתוֹת וּמֹפְתִים גְּדֹלִים בְּקֶרֶב הָעָם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","וַיָּקוּמוּ אֲנָשִׁים מִבֵּית־הַכְּנֵסֶת אֲשֶׁר עַל־שֵׁם־הַלִּיבַרְטִינִים יֵחָשֵׁב וְהַקּוּרִינִים וְהָאֲלֶכְסַנְדְּרִיִּים וּמִן־בְּנֵי קִילִיקִיָּא וְאַסְיָּא וַיִתְוַכְּחוּ עִם־סְטְפָנוֹס׃ ");
INSERT INTO hebsg_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","וְלֹא יָכְלוּ לְהָשִׁיב עַל־דִּבְרֵי חָכְמָתוֹ אֲשֶׁר־הִבִּיעַ לָהֶם רוּחוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","וַיּוֹשִׁיבוּ אֲנָשִׁים נֶגְדּוֹ אֲשֶׁר הֵעִדֻהוּ לֵאמֹר שָׁמַעְנוּ אֹתוֹ מְדַבֵּר דִּבְרֵי גִדּוּפִים בְּמֹשֶׁה וּבֵאלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","וַיְעוֹרְרוּ אֶת־הָעָם וְאֶת־הַזְּקֵנִים וְאֶת־הַסּוֹפְרִים וַיָּקוּמוּ עָלָיו וַיִּתְפְּשֻׂהוּ וַיְבִיאֻהוּ לִפְנֵי הַסַּנְהֶדְרִין׃ ");
INSERT INTO hebsg_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","וַיּוֹשִׁיבוּ עֵדֵי־שֶׁקֶר וַיְעִידֻהוּ לֵאמֹר הָאִישׁ הַזֶּה לֹא יֶחְדַּל מִדַּבֵּר גִּדּוּפִים עַל־הַמָּקוֹם הַקָּדוֹשׁ הַזֶּה וְעַל־הַתּוֹרָה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","כִּי שָׁמַעְנוּ אֹתוֹ אֹמֵר יֵשׁוּעַ הַנָּצְרִי הוּא יַהֲרוֹס אֶת־הַמָּקוֹם הַזֶּה וְיָמִיר אֶת־הַחֻקִּים אֲשֶׁר נָתַן־לָנוּ מֹשֶׁה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","וַיָּשִׂימוּ כָּל־הַיּוֹשְׁבִים בַּסַּנְהֶדְרִין אֶת־עֵינָם בּוֹ וַיִּרְאוּ אֶת־פָּנָיו כִּפְנֵי מַלְאַךְ אֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","וַיֹּאמֶר הַכֹּהֵן הַגָּדוֹל הַאֻמְנָם כֵּן הַדָּבָר׃ ");
INSERT INTO hebsg_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","וַיַּעַן וַיֹּאמַר שְׁמָעוּנִי אַחַי וַאֲבוֹתָי אֵל אֱלֹהֵי הַכָּבוֹד נִרְאֶה אֶל־אַבְרָהָם אָבִינוּ בִּהְיוֹתוֹ בַּאֲרַם נַהֲרַיִם טֶרֶם יָשַׁב בְּחָרָן׃ ");
INSERT INTO hebsg_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","וַיֹּאמֶר אֵלָיו לֶךְ־לְךָ מֵאַרְצְךָ וּמִמּוֹלַדְתֶּךָ וּבֹא אֶל־הָאָרֶץ אֲשֶׁר אַרְאֶךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","אָז יָצָא מֵאֶרֶץ כַּשְׂדִּים וַיֵּשֶׁב בְּחָרָן וְאַחֲרֵי מוֹת אָבִיו הֶעֱבִיר אֹתוֹ מִשָּׁם אֶל־הָאָרֶץ הַזֹּאת אֲשֶׁר אַתֶּם יֹשְבִים בָּהּ כַּיּוֹם הַזֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","וְלֹא־נָתַן לוֹ נַחֲלָה בָּהּ עַד־מִדְרַךְ כַּף־רָגֶל אַךְ אָמַר לְתִתָּהּ לוֹ לַאֲחֻזָּה וּלְזַרְעוֹ אַחֲרָיו בְּטֶרֶם הָיָה־לוֹ זָרַע׃ ");
INSERT INTO hebsg_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","וְכֹה אָמַר אֱלֹהִים כִּי־גֵר יִהְיֶה זַרְעוֹ בְּאֶרֶץ לֹא לָהֶם וַעֲבָדוּם וְעִנּוּ אֹתָם אַרְבַּע מֵאוֹת שָׁנָה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","וְגַם אֶת־הַגּוֹי אֲשֶׁר יַעֲבֹדוּ דָּן אָנֹכִי אָמַר אֱלֹהִים וְאַחֲרֵי־כֵן יֵצְאוּ וְיַעַבְדֻנִי בַּמָּקוֹם הַזֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","וַיִּתֶּן־לוֹ אֶת בְּרִית הַמִּילָה וְאָז נוֹלַד־לוֹ יִצְחָק וַיָּמָל אֹתוֹ בַּיּוֹם הַשְּׁמִינִי וְיִצְחָק הוֹלִיד אֶת־יַעֲקֹב וְיַעֲקֹב אֶת־שְׁנֵים הֶעָשָׂר רָאשֵׁי הָאָבוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","וַיְקַנְאוּ רָאשֵׁי הָאָבוֹת בְּיוֹסֵף וַיִּמְכְּרוּ אֹתוֹ לַהֲבִיאוֹ מִצְרָיְמָה וֵאלֹהִים הָיָה עִמּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","וַיּוֹשַׁע־לוֹ מִכָּל־צָרוֹתָיו וְחֵן וְחָכְמָה נָתַן־לוֹ לְעֵינֵי פַרְעֹה מֶלֶךְ מִצְרָיִם וַיְשִׁיתֵהוּ עַל־מִצְרַיִם וְעַל כָּל־בֵּיתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","וַיָּבֹא רָעָב בְּכָל־אֶרֶץ מִצְרַיִם וּבְאֶרֶץ כְּנָעַן וְצָרָה גְדוֹלָה וְלֹא־מָצְאוּ אֲבוֹתֵינוּ טֶרֶף לְבֵיתָם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","וַיִּשְׁמַע יַעֲקֹב כִּי יֶשׁ־שֶׁבֶר בְּמִצְרַיִם וַיִּשְׁלַח אֶת־אֲבוֹתֵינוּ פַּעַם אֶחָת׃ ");
INSERT INTO hebsg_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","וּבַפַּעַם הַשֵּׁנִית הִתְוַדַּע יוֹסֵף אֶל־אֶחָיו וַתִּוָּדַע לְפַרְעֹה מִשְׁפַּחַת יוֹסֵף׃ ");
INSERT INTO hebsg_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","וַיִּשְׁלַח יוֹסֵף וַיִּקְרָא אֵלַיו אֶת־יַעֲקֹב אָבִיו וְאֶת־כָּל־מוֹלַדְתּוֹ חָמֵשׁ וְשִׁבְעִים נָפֶשׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","וַיֵּרֶד יַעֲקֹב מִצְרָיְמָה וַיָּמָת שָׁם הוּא וַאֲבֹתֵינוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","וַיִּנָּשְׂאוּ שְׁכֶמָה וַיִּקָּבְרוּ בַּקֶּבֶר אֲשֶׁר קָנָה אַבְרָהָם בִּמְחִיר כֶּסֶף מִיַּד בְּנֵי־חֲמוֹר בִּשְׁכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","וַיְהִי כַּאֲשֶׁר קָרְבוּ הַיָּמִים אֲשֶׁר הִבְטִיחַ אֱלֹהִים בִּשְׁבֻעָתוֹ לְאַבְרָהָם וַיֵּרֶב הָעָם בְּמִצְרַיִם וַיַּעַצְמוּ בִּמְאֹד מְאֹד׃ ");
INSERT INTO hebsg_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","עַד כִּי־קָם מֶלֶךְ חָדָשׁ בְּמִצְרַיִם אֲשֶׁר לֹא־יָדַע אֶת־יוֹסֵף׃ ");
INSERT INTO hebsg_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","הוּא הִתְחַכֵּם לִבְנֵי מִשְׁפַּחְתֵּנוּ וַיִּלְחַץ אֶת־אֲבוֹתֵינוּ לִנְטֹש אֶת־עֹלְלֵיהֶם לְבִלְתִּי הַחֲיוֹתָם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","בָּעֵת הַהִיא נוֹלַד משֶׁה וַיְהִי־טוֹב לֵאלֹהִים וּשְׁלֹשָה חֳדָשִׁים נִצְפַּן בְּבֵית אָבִיהוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","וְאַחֲרֵי נֻטַּשׁ אָסְפָה אֹתוֹ בַּת־פַּרְעֹה וַתְּגַדְּלֵהוּ לָהּ לְבֵן׃ ");
INSERT INTO hebsg_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","וַיְהִי מַשְׂכִּיל בְּכָל־חָכְמַת מִצְרָיִם שַׂגִּיא־כֹחַ בִּדְבָרָיו וְרַב־פְּעָלִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","וְכַאֲשֶׁר מָלְאוּ־לוֹ אַרְבָּעִים שָׁנָה שָׂם עַל־לִבּוֹ לִפְקֹד אֶת־אֶחָיו אֶת־בְּנֵי יִשְׂרָאֵל׃ ");
INSERT INTO hebsg_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","וַיַּרְא אִישׁ אֶחָד מֵהֶם מֻכֶּה עַל־לֹא־דָבָר וַיָּגֶן עָלָיו וַיִּקֹּם נִקְמַת הַמֻכֶּה וַיַּךְ אֶת־הַמִּצְרִי׃ ");
INSERT INTO hebsg_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","וַיֹּאמֶר בְּלִבּוֹ כִּי יָבִינוּ אֶחָיו אֲשֶׁר עַל־יָדוֹ תָּבוֹא לָהֶם תְּשׁוּעַת אֱלֹהִים וְהֵם לֹא הֵבִינוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","וַיֵּצֵא בַּיוֹם הַשֵּׁנִי וְהִנֵּה שְׁנֵי אֲנָשִׁים נִצִּים וַיְבַקֵּשׁ לַעֲשׂוֹת שָׁלוֹם בֵּינֵיהֶם וַיֹּאמַר הֲלֹא אֲנָשִׁים אַחִים אַתֶּם לָמָּה תַעַשְׁקוּ אִישׁ אֶת־אָחִיו׃ ");
INSERT INTO hebsg_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","וְהַשֹּׁלֵחַ יָד בְּאָחִיו הֲדָפוֹ לֵאמֹר מִי שָׂמְךָ לְאִישׁ שַׂר וְשֹׁפֵט עָלֵינוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","הַלְהָרְגֵנִי אַתָּה אֹמֵר כַּאֲשֶׁר הָרָגְתָּ אֶתְמֹל אֶת־הַמִּצְרִי׃ ");
INSERT INTO hebsg_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","וְעַל־הַדָּבָר הַזֶּה בָּרַח מֹשֶׁה וַיָּגָר בְּאֶרֶץ מִדְיָן וַיּוֹלֶד שָׁם שְׁנֵי בָנִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","וְכִמְלֹאת לוֹ אַרְבָּעִים שָׁנָה וַיֵּרָא אֵלָיו מַלְאָךְ יְהוָֹה בְּמִדְבַּר הַר סִינַי בְּלַבַּת־אֵשׁ מִתּוֹךְ הַסְּנֶה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","וַיַּרְא משֶׁה וַיִּתְמַהּ עַל־הַמַּרְאֶה וַיָּסַר לִרְאוֹת וְהִנֵּה קוֹל יְהוָֹה מִדַּבֵּר אֵלָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","אָנֹכִי אֱלֹהֵי אָבִיךָ אֱלֹהֵי אַבְרָהָם אֱלֹהֵי יִצְחָק וֵאלֹהֵי יַעֲקֹב וַיֶּחֱרַד משֶׁה כִּי יָרֵא מֵהַבִּיט׃ ");
INSERT INTO hebsg_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","וַיֹּאמֶר אֵלָיו יְהוָֹה שַׁל נְעָלֶיךָ מֵעַל רַגְלֶיךָ כִּי הַמָּקוֹם אֲשֶׁר אַתָּה עוֹמֵד עָלָיו אַדְמַת־קֹדֶשׁ הוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","רָאֹה רָאִיתִי אֶת־עֳנִי עַמִּי אֲשֶׁר בְּמִצְרַיִם וְאֶת־צַעֲקָתָם שָׁמָעְתִּי וָאֵרֵד לְהַצִּילָם וְעַתָּה לְכָה וְאֶשְׁלָחֲךָ מִצְרַיְמָה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","הוּא משֶׁה אֲשֶׁר כִּחֲשׁוּ־בוֹ לֵאמֹר מִי שָׂמְךָ לְשַׂר וְשֹׁפֵט אֹתוֹ שָׁלַח אֱלֹהִים בְּיַד הַמַּלְאָךְ הַנִּרְאֶה אֵלָיו בַּסְּנֶה לִהְיוֹת לְשַׂר וּלְגֹאֵל׃ ");
INSERT INTO hebsg_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","וְהוּא הוֹצִיאָם וַיַּעַשׂ אֹתוֹת וּמֹפְתִים בְּמִצְרַיִם וּבְיַם־סוּף וּבַמִּדְבָּר אַרְבָּעִים שָׁנָה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","הוּא משֶׁה אֲשֶׁר אָמַר לִבְנֵי יִשְׂרָאֵל נָבִיא מֵאֲחֵיכֶם כָּמֹנִי יָקִים לָכֶם יְהוָֹה אֱלֹהֵיכֶם אֵלָיו תִּשְׁמָעוּן׃ ");
INSERT INTO hebsg_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","הוּא אֲשֶׁר הָיָה בַקָּהָל וּבַמִּדְבָּר עִם־הַמַּלְאָךְ הַדֹּבֵר אֵלָיו בְּהַר סִינַי וְעִם־אֲבוֹתֵינוּ וְהוּא קִבֵּל תּוֹרַת חַיִּים לָתֶת־לָנוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","וַאֲבֹתֵינוּ לֹא אָבוּ לִשְׁמֹעַ לוֹ כִּי הִמְרוּ אֶת־רוּחוֹ וַיִּתְּנוּ אֶת־לִבָּם לָשׁוּב מִצְרָיְמָה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","וַיֹּאמְרוּ אֶל־אַהֲרֹן עֲשֵׂה־לָנוּ אֱלֹהִים אֲשֶׁר יֵלְכוּ לְפָנֵינוּ כִּי־זֶה משֶׁה הָאִישׁ אֲשֶׁר הֶעֱלָנוּ מֵאֶרֶץ מִצְרַיִם לֹא יָדַעְנוּ מֶה־הָיָה לוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","וַיַּעֲשׂוּ עֵגֶל בַּיָּמִים הָהֵם וַיַּעֲלוּ עֹלוֹת לַמַּסֵּכָה וַיְצַחֲקוּ לִפְנֵי מַעֲשֵׂי יְדֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","וֵאלֹהִים סָר מֵעֲלֵיהֶם וַיִּתְּנֵם לַעֲבֹד אֶת־צְבָא הַשָּׁמָיִם כַּכָּתוּב בְּסֵפֶר הַנְּבִיאִים הַזְּבָחִים וּמִנְחָה הִגַּשְׁתֶּם־לִי בַמִּדְבָּר אַרְבָּעִים שָׁנָה בֵּית יִשְׂרָאֵל׃ ");
INSERT INTO hebsg_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","וּנְשָׂאתֶם אֵת סֻכַּת מֹלֶךְ וְאֶת־כֹּכַב אֱלֹהֵיכֶם רֵיפָן הַצְּלָמִים אֲשֶׁר עֲשִׂיתֶם לְהִשְׁתַּחֲוֹת לָהֶם וְהִגְלֵיתִי אֶתְכֶם מֵהָלְאָה לְבָבֶל׃ ");
INSERT INTO hebsg_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","וַאֲבֹתֵינוּ מִשְׁכַּן הָעֵדוּת הָיָה לָהֶם בַּמִּדְבָּר אֲשֶׁר עָשָׂה משֶׁה כַּתַּבְנִית אֲשֶׁר רָאָה כְּפִי אֲשֶׁר צִוָּה אֹתוֹ אֱלֹהִים הַמְדַבֵּר אֵלָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","וַאֲבֹתֵינוּ עִם־יְהוֹשֻׁעַ בְּרֹאשָׁם לָקְחוּ וַיְבִיאֻהוּ אִתָּם אֶל־אַרְצוֹת הַגּוֹיִם אֲשֶׁר הוֹרִישָׁם אֱלֹהִים מִפְּנֵי אֲבוֹתֵינוּ עַד־יְמֵי דָוִד׃ ");
INSERT INTO hebsg_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","וְהוּא מָצָא חֵן בְּעֵינֵי אֱלֹהִים וַיִּתֵּן אֶת־לִבּוֹ לִמְצֹא מִשְׁכָּנוֹת לֵאלֹהֵי יַעֲקֹב׃ ");
INSERT INTO hebsg_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","וּשְׁלֹמֹה בָּנָה־לוֹ בָיִת׃ ");
INSERT INTO hebsg_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","אַךְ אֵל עֶלְיוֹן לֹא יֵשֵׁב בְּבָתִּים מַעֲשֵׂי יָדָיִם כַּאֲשֶׁר אָמַר הַנָּבִיא׃ ");
INSERT INTO hebsg_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","הַשָּׁמַיִם כִּסְאִי וְהָאָרֶץ הֲדֹם רַגְלָי אֵי־זֶה בַיִת אֲשֶׁר תִּבְנוּ־לִי אָמַר יְהוָֹה וְאֵי־זֶה מָקוֹם מְנוּחָתִי׃ ");
INSERT INTO hebsg_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","הֲלֹא אֶת־כָּל־אֵלֶּה יָדִי עָשָׂתָה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","קְשֵׁי עֹרֶף כִּבְדֵי לֵב וְעַרְלֵי אֹזֶן מַמְרִים הֱיִיתֶם תָּמִיד עִם־רוּחַ הַקֹּדֶשׁ גַּם־אַתֶּם גַּם־אֲבוֹתֵיכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","מִי מִן־הַנְּבִיאִים לֹא רָדְפוּ אֹתוֹ אֲבוֹתֵיכֶם הֲלֹא הָרְגוּ אֶת־הַמְבַשְּׂרִים מִקֶּדֶם כִּי בֹא יָבֹא הַצַּדִּיק אֲשֶׁר אַתֶּם הִסְגַּרְתֶּם וַתִּהְיוּ לוֹ לִמְרַצְּחִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","אַתֶּם אֲשֶׁר קִבַּלְתֶּם אֶת־הַתּוֹרָה מִלִּפְנֵי רִבְבֹת קֹדֶשׁ וְלֹא שְׁמַרְתֶּם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","וַיְהִי כְּשָׁמְעָם אֶת־הַדָּבָר הַזֶּה וַיִּגַּע עַד־נַפְשָׁם וַיַּחַרְקוּ עָלָיו שִׁנֵּיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","וְהוּא מָלֵא רוּחַ הַקֹּדֶשׁ וַיַּבֵּט הַשָּׁמָיְמָה וַיַּרְא אֶת־כְּבוֹד אֱלֹהִים וְאֶת־יֵשׁוּעַ עֹמֵד לִימִין הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","וַיֹּאמֶר הִנְנִי רֹאֶה אֶת־הַשָּׁמַיִם נִפְתָּחִים וְאֵת בֶּן־הָאָדָם עֹמֵד לִימִין הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","וַיִּזְעֲקוּ בְּקוֹל גָּדוֹל וַיַּאַטְמוּ אֶת־אָזְנֵיהֶם וַיִּפְּלוּ עָלָיו יָחַד׃ ");
INSERT INTO hebsg_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","וַיּוֹצִיאֻהוּ אֶל־מִחוּץ לָעִיר וַיִּרְגְּמוּ אֹתוֹ אָבֶן וְהָעֵדִים הִפְשִׁיטוּ אֶת־מְעִילֵיהֶם לְרַגְלֵי נַעַר אֶחָד וּשְׁמוֹ שָׁאוּל׃ ");
INSERT INTO hebsg_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","וַיִּרְגְּמוּ אֶת־סְטְפָנוֹס וְהוּא מְשַׁוֵּעַ וְקֹרֵא יֵשׁוּעַ אֲדֹנִי קַח־נָא אֶת־רוּחִי׃ ");
INSERT INTO hebsg_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","וַיִּכְרַע עַל־בִּרְכָּיו וַיִּקְרָא בְקוֹל גָּדוֹל יְהוָֹה אַל־נָא תָשֵׁת עֲלֵיהֶם חַטָּאת וַיְהִי כַּאֲשֶׁר אָמַר אֶת־הַדָּבָר הַזֶּה וַיִּישָׁן׃ ");
INSERT INTO hebsg_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","וְשָׁאוּל נָטָה אַחֲרֵיהֶם לַהֲמִיתוֹ וְאֶת־הָעֵדָה בִּירוּשָׁלַיִם רָדְפוּ בָּעֵת הַהִיא עַד־מְאֹד וַיָּפֻצוּ כֻלָּם לְכָל־עֵבֶר בִּיהוּדָה וּבְשֹׁמְרוֹן זוּלָתִי הַשְּׁלִיחִים לְבַדָּם נִשְׁאָרוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","וַאֲנָשִׁים חֲסִידִים נָשְׂאוּ אֶת־סְטְפָנוֹס וַיִּקְבְּרֻהוּ וַיִּסְפְּדוּ עָלָיו מִסְפֵּד גָּדוֹל׃ ");
INSERT INTO hebsg_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","וְשָׁאוּל רָדַף אֶת־הָעֵדָה עַד־חָרְמָה הָלֹךְ מִבַּיִת לְבַיִת וְסָחוֹב אֲנָשִׁים וְנָשִׁים לְתִתָּם בְּבֵית הַכֶּלֶא׃ ");
INSERT INTO hebsg_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","וְהַנְּפוֹצִים שָׁטוּ בָאָרֶץ וַיַּשְׁמִיעוּ אֶת־דְּבַר הַבְּשׂוֹרָה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","וַיֵּרֶד פִּילִפּוֹס אֶל־עִיר שֹׁמְרוֹן וַיִּקְרָא בְאָזְנֵיהֶם אֶת־קְרִיאַת הַמָּשִׁיחַ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","וַיַּקְשֵׁב הֲמוֹן הָעָם אֶל־אִמְרֵי פִילִפּוֹס בְּלֵב אֶחָד כִּי שָׁמְעוּ גַּם־רָאוּ אֶת־הָאֹתוֹת אֲשֶׁר עָשָׂה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","כִּי רַבִּים הָיוּ שָׁם אֲשֶׁר רוּחוֹת הַטֻּמְאָה דָּבְקוּ בָם וְהֵנָּה יָצְאוּ מֵהֶם יָצֹא וְצָעֹק בְּקוֹל גָּדוֹל וּנְכֵי עֲצָמוֹת וּפִסְחִים רַבִּים עַל־יָדוֹ נִרְפָּאוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","וַתְּהִי שִׂמְחָה גְדוֹלָה בָּעִיר הַהִיא׃ ");
INSERT INTO hebsg_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","וְאִישׁ הָיָה בָעִיר וּשְׁמוֹ שִׁמְעוֹן אֲשֶׁר מִלְּפָנִים הִגְדִּיל מַעֲשֵׂהוּ בִכְשָׁפָיו עַד־אֲשֶׁר שָׁמְמוּ עָלָיו הַשֹּׁמְרֹנִים בַּאֲשֶׁר הוּא אָמַר כִּי־אִישׁ גָּדוֹל הוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","וְכֻלָּם הִקְשִׁיבוּ אֵלָיו מִקָּטוֹן וְעַד־גָּדוֹל לֵאמֹר זוּ כֹחוֹ כֹּחַ אֱלֹהִים כִּי רַב הוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","וְהֵם נָתְנוּ־לוֹ אֹזֶן קַשֶּׁבֶת כִּי יָמִים רַבִּים בִּכְשָׁפָיו הָיָה מַפְלִיא לַעֲשׂוֹת לְעֵינֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","וַיְהִי כַּאֲשֶׁר הֶאֱמִינוּ לְפִילִפּוֹס אֲשֶׁר בִּשַּׂר לָהֶם אֶת־מַלְכוּת הָאֱלֹהִים וְאֶת־שֵׁם יֵשׁוּעַ הַמָּשִׁיחַ וַיִּטָּבְלוּ גַּם־אֲנָשִׁים וְגַם־נָשִׁים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","וַיַּאֲמֵן שִׁמְעוֹן גַּם־הוּא וַיִּטָּבֵל וַיִּסְתַּפַּח עַל־פִּילִפּוֹס וּבִרְאֹתוֹ אֶת־אֹתוֹתָיו אֲשֶׁר עָשָׂה וְאֶת־מֹפְתָיו הַגְּדֹלִים וַיִּשְׁתּוֹמֵם עַד־מְאֹד׃ ");
INSERT INTO hebsg_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","וַיְהִי כִּשְׁמֹעַ הַשְּׁלִיחִים אֲשֶׁר בִּירוּשָׁלַיִם כִּי־קִבְּלָה שֹׁמְרוֹן אֶת־דְּבַר הָאֱלֹהִים וַיִּשְׁלְחוּ אֲלֵיהֶם אֶת־פֶּטְרוֹס וְאֶת־יוֹחָנָן׃ ");
INSERT INTO hebsg_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","וַיֵּרְדוּ וַיִּתְפַּלְּלוּ בַעֲדָם כִּי תָנוּחַ עֲלֵיהֶם רוּחַ הַקֹּדֶשׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","כִּי עַד־עַתָּה לֹא צָלְחָה עַל־אִישׁ מֵהֶם רַק כִּי־נִטְבָּלִים הָיוּ בְשֵׁם הָאָדוֹן יֵשׁוּעַ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","וַיִּסְמְכוּ אֶת־יְדֵיהֶם עֲלֵיהֶם וַתָּנַח עֲלֵיהֶם רוּחַ הַקֹּדֶשׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","וַיְהִי כִּרְאוֹת שִׁמְעוֹן כִּי רוּחַ הַקֹּדֶשׁ נִתְּנָה בָהֶם אַחֲרֵי אֲשֶׁר סָמְכוּ הַשְּׁלִיחִים אֶת־יְדֵיהֶם עֲלֵיהֶם וַיַּקְרֵב לָהֶם כָּסֶף׃ ");
INSERT INTO hebsg_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","וַיֹּאמַר תְּנוּ־לִי אֶת־הַכֹּחַ הַזֶּה גַּם־אָנִי לְמַעַן תִּצְלַח רוּחַ הַקֹּדֶשׁ עַל־כָּל־אֲשֶׁר אֶסְמֹךְ אֶת־יָדַי עָלָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","וַיֹּאמֶר אֵלָיו פֶּטְרוֹס אָבֹד תֹּאבַד אַתָּה עִם־כַּסְפֶּךָ בַּאֲשֶׁר חָשְׁבָה נַפְשְׁךָ כִּי תִקְנֶה מַתַּת הָאֱלֹהִים בַּכָּסֶף׃ ");
INSERT INTO hebsg_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","אֵין־לְךָ חֵלֶק וְנַחֲלָה בַּדָּבָר הַזֶּה כִּי לֹא יָשָׁר לִבְּךָ לִפְנֵי הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","וְעַתָּה שׁוּבָה מֵרָעָתְךָ וְהִתְפַּלֵּל אֶל־יְהוָֹה אוּלַי יִסְלַח לְךָ לְנִכְלֵי לִבֶּךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","כִּי בִּמְרוֹרַת רֹאשׁ רְאִיתִיךָ וּבְמוֹ חַרְצֻבּוֹת רֶשַׁע׃ ");
INSERT INTO hebsg_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","וַיַּעַן שִׁמְעוֹן וַיֹּאמַר הַעְתִּירוּ בַעֲדִי אֶל־יְהוָֹה לְבִלְתִּי יָבֹא עָלַי דָּבָר מִכֹּל אֲשֶׁר אֲמַרְתֶּם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","וְהֵם דִּבְּרוּ דְבַר יְהוָֹה הָעֵד וְדַבֵּר וַיָּשֻׁבוּ יְרוּשָׁלָיְמָה אַחֲרֵי אֲשֶׁר הִשְׁמִיעוּ אֶת־דְּבַר הַבְּשׂוֹרָה בִּכְפָרִים רַבִּים אֲשֶׁר לַשֹּׁמְרֹנִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","וַיְדַבֵּר מַלְאַךְ יְהוָֹה אֶל־פִּילִפּוֹס לֵאמֹר קוּם לֶךְ־לְךָ הַנֶּגְבָּה בַּדֶּרֶךְ הַנְּשַׁמָּה הַיֹּרֶדֶת מִירוּשָׁלַיִם בֹּאֲךָ עַזָּתָה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","וַיָּקָם וַיֵּלַךְ וְהִנֵּה אִישׁ גִּבּוֹר חַיִל כּוּשִׁי לְפָנָיו סְרִיס הַמַּלְכָּה קַנְדַּק מֵאֶרֶץ כּוּשׁ וְהוּא שַׂר לְכָל־בֵּית אוֹצָרָהּ אֲשֶׁר בָּא יְרוּשָׁלַיִם לְהִשְׁתַּחֲוֹת שָׁמָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","וְעַתָּה הוּא שָׁב לְדַרְכּוֹ יוֹשֵׁב בְּמֶרְכַּבְתּוֹ וְקֹרֵא בְּסֵפֶר יְשַׁעְיָהוּ הַנָּבִיא׃ ");
INSERT INTO hebsg_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","וַיֹּאמֶר הָרוּחַ אֶל־פִּילִפּוֹס נְטֵה לְךָ וְהִתְהַלֵּךְ אֵצֶל הַמֶּרְכָּבָה הַזֹּאת׃ ");
INSERT INTO hebsg_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","וַיָּרָץ אֵלָיו פִּילִפּוֹס וַיִּשְׁמַע כִּי הוּא קֹרֵא בְסֵפֶר יְשַׁעְיָהוּ הַנָּבִיא וַיֹּאמֶר הֲכִי יָדַעְתָּ אֶת־אֲשֶׁר אַתָּה קֹרֵא׃ ");
INSERT INTO hebsg_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","וַיֹּאמַר אֵיכָה אֵדַע בִּלְתִּי אִם־יוֹרֵנִי אִישׁ וַיְבַקֵּשׁ אֶת־פִּילִפּוֹס לַעֲלוֹת וְלָשֶׁבֶת אִתּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","וְזֶה הוּא הַכָּתוּב אֲשֶׁר קָרָא בַסֵּפֶר כַּשֶּׂה לַטֶּבַח יוּבָל וּכְרָחֵל לִפְנֵי גֹזְזֶיהָ נֶאֱלָמָה וְלֹא יִפְתַּח פִּיו׃ ");
INSERT INTO hebsg_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","בְּשִׁפְלוֹ מִשְׁפָּטוֹ לֻקָּח וְאֶת־דּוֹרוֹ מִי יְשׂוֹחֵחַ כִּי נִגְזַר מֵאֶרֶץ חַיָּיו׃ ");
INSERT INTO hebsg_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","וַיַּעַן הַסָּרִיס וַיֹּאמֶר אֶל־פִּילִפּוֹס אֶשְׁאֲלָה־נָּא מִמְּךָ עַל־מִי מְדַבֵּר הַנָּבִיא עַל־נַפְשׁוֹ אוֹ עַל־אִישׁ אַחֵר׃ ");
INSERT INTO hebsg_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","וַיִּפְתַּח פִּילִפּוֹס אֶת־פִּיו וַיָּחֶל מִן־הַכָּתוּב הַזֶּה וַיַּגֶּד־לוֹ אֶת־בְּשׂוֹרַת יֵשׁוּעַ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","וַיְהִי בְּנָסְעָם בַּדֶּרֶךְ וַיָּבֹאוּ אֶל־מָיִם וַיֹּאמֶר הַסָּרִיס הִנֵּה־מַיִם לְפָנֵינוּ מַה־יַּעַצְרֵנִי מֵהִטָּבֵל׃ ");
INSERT INTO hebsg_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","וַיֹּאמֶר פִּילִפּוֹס אִם־מַאֲמִין אַתָּה בְּכָל־לְבָבְךָ מֻתָּר־לָךְ וַיַּעַן וַיֹּאמֶר אֲנִי מַאֲמִין כִּי יֵשׁוּעַ הַמָּשִׁיחַ בֶּן־הָאֱלֹהִים הוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","וַיְצַו וַתַּעֲמֹד הַמֶּרְכָּבָה וַיֵּרְדוּ שְׁנֵיהֶם אֶל־הַמַּיִם גַּם־פִּילִפּוֹס גַּם־הַסָּרִיס וַיְטַבֵּל אֹתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","וַיְהִי בַּעֲלוֹתָם מִן־הַמַּיִם וַיִּשָּׂא רוּחַ יְהוָֹה אֶת־פִּילִפּוֹס וְהַסָּרִיס לֹא רָאָהוּ עוֹד וַיַּעֲבֹר שָׂמֵחַ לְדַרְכּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","וּפִילִפּוֹס נִמְצָא בְאַשְׁדּוֹד וַיַּעֲבֹר וַיְבַשֵּׂר אֶת־הַבְּשׂוֹרָה בְּכָל־הֶעָרִים עַד־בֹּאוֹ קִסְרִין׃ ");
INSERT INTO hebsg_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","וְשָׁאוּל עוֹדֶנּוּ עוֹרֵר זַעַם וָמָוֶת בַּחֲמַת אַפּוֹ עַל־תַּלְמִידֵי הָאָדוֹן וַיֵּלֶךְ אֶל־הַכֹּהֵן הַגָּדוֹל׃ ");
INSERT INTO hebsg_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","וַיִּשְׁאַל סְפָרִים מִמֶּנּוּ אֶל־בָּתֵּי הַכְּנֶסֶת אֲשֶׁר בְּדַמֶּשֶׂק לְהַחֲזִיק בְּיָדוֹ כִּי יִמְצָא תֹעִים בַּדֶּרֶךְ הַהִיא אֲנָשִׁים אוֹ נָשִׁים לַהֲבִיאָם אֲסוּרִים יְרוּשָׁלָיְמָה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","וַיְהִי הוּא הֹלֵךְ וְקָרֵב אֶל־דַּמָּשֶׂק וְהִנֵּה אוֹר מִן־הַשָּׁמַיִם זָרַח עָלָיו כְּבָרָק מִסָּבִיב׃ ");
INSERT INTO hebsg_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","וַיִּפֹּל עַל־פָּנָיו אָרְצָה וַיִּשְׁמַע קוֹל מִדַּבֵּר אֵלָיו שָׁאוּל שָׁאוּל לָמָּה־זֶּה תִּרְדְּפֵנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","וַיֹּאמֶר מִי אַתָּה אֲדֹנִי וַיֹּאמֶר אָנֹכִי יֵשׁוּעַ אֲשֶׁר אַתָּה רֹדֵף קָשֶׁה לְךָ לָבְעֹט בַּדָּרְבֹנוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","וְהוּא חָרֵד וְנִבְעָת וַיֹּאמֶר אָדוֹנִי מַה־תַּחְפֹּץ וְאֶעֱשֶׂה וַיָּעַן הָאָדוֹן אַ ָ קוּם לְךָ וְלֵךְ הָעִירָה וְשָׁם יֵאָמֵר אֵלֶיךָ אֶת־אֲשֶׁר תַּעֲשֶׂה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","וְהָאֲנָשִׁים אֲשֶׁר הָלְכוּ אִתּוֹ עָמְדוּ כְנֶאֱלָמִים כִּי שָׁמְעוּ אֶת־הַקּוֹל וְאִישׁ לֹא רָאוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","וַיָּקָם שָׁאוּל מִן־הָאָרֶץ וַיִּפְתַּח אֶת־עֵינָיו וְלֹא רָאָה כָּל־מְאוּמָה וַיַּחֲזִיקוּ בְיָדוֹ וַיּוֹלִיכֻהוּ דַּמָּשֶׂק׃ ");
INSERT INTO hebsg_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","וּשְׁלשֶׁת יָמִים לֹא הָיָה לוֹ אוֹר עֵינָיו וְלֹא אָכַל וְלֹא שָׁתָה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","וְתַלְמִיד אֶחָד הָיָה בְדַמֶּשֶׂק וּשְׁמוֹ חֲנַנְיָה וַיֹּאמֶר אֵלָיו הָאָדוֹן בַּמַרְאֶה חֲנַנְיָה וַיֹּאמֶר הִנְנִי אֲדֹנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","וַיֹּאמֶר אֵלָיו הָאָדוֹן קוּם וָלֵךְ אֶל־הָרְחוֹב הַנִּקְרָא הָרְחוֹב הַיָּשָׁר וּדְרשׁ בְּבֵית יְהוּדָה אַחֲרֵי אִישׁ טַרְסִי וּשְׁמוֹ שָׁאוּל כִּי הִנּוֹ מִתְפַּלֵּל׃ ");
INSERT INTO hebsg_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","וְהוּא חָזָה בַּמַּחֲזֶה אִישׁ בָּא אֵלָיו וּשְׁמוֹ חֲנַנְיָה אֲשֶׁר שָׂם אֶת־יָדָיו עָלָיו לְהָשֶׁב־לוֹ אוֹר עֵנָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","וַיַּעַן חֲנַנְיָה וַיֹּאמַר אֲדֹנִי שָׁמַעְתִּי מִפִּי רַבִּים עַד־כַּמָּה הִרְבָּה הָרֵעַ הָאִישׁ הַזֶּה לִקְדוֹשֶׁיךָ אֲשֶׁר בִּירוּשָׁלָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","וְגַם־פֹּה יֶשׁ כֹּחַ בְּיָדוֹ מִפִּי רָאשֵׁי הַכֹּהֲנִים לֶאְסֹר אֶת־כֹּל הַקֹּרִאים בִּשְׁמֶךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","וַיֹּאמֶר אֵלָיו הָאָדוֹן לֵךְ כִּי־כְלִי חֵפֶץ הוּא אֲשֶׁר בָּחַרְתִּי בוֹ לָשֵׂאת אֶת־שְׁמִי לִפְנֵי גוֹיִם וּמְלָכִים וּבְנֵי יִשְׂרָאֵל׃ ");
INSERT INTO hebsg_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","וַאֲנִי אַרְאֵהוּ עַד־כַּמָּה לוֹ לְהִתְעַנּוֹת בַּעֲבוּר שְׁמִי׃ ");
INSERT INTO hebsg_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","וַיֵּלֶךְ חֲנַנְיָה וַיָּבֹא הַבַּיְתָה וַיָּשֶׂם אֶת־יָדָיו עָלָיו וַיֹּאמַר שָׁאוּל אָחִי הִנֵּה הָאָדוֹן יֵשׁוּעַ הַנִּרְאֶה אֵלֶיךָ בַּדֶּרֶךְ אֲשֶׁר־בָּאתָ הֵנָּה שְׁלָחַנִי אֵלֶיךָ כִּי תִפָּקַחְנָה עֵינֶיךָ וְתִמָּלֵא רוּחַ הַקֹּדֶשׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","וּכְרֶגַע נָפְלוּ מֵעַל עֵינָיו כְּקַשְׂקַשִּׂים וַתִּפָּקַחְנָה וַיָּקָם וַיִּטָּבֵל׃ ");
INSERT INTO hebsg_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","וַיֹּאכַל לֶחֶם וַיִּתְחַזָּק וַיֵּשֶׁב שָׁאוּל עִם־הַתַּלְמִידִים יָמִים אֲחָדִים בְּדַמָּשֶׂק׃ ");
INSERT INTO hebsg_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","וַיְמַהֵר וַיִּקְרָא בְּבָתֵּי־הַכְּנֶסֶת בְּשֵׁם יֵשׁוּעַ לֵאמֹר כִּי־הוּא הַמָּשִׁיחַ בֶּן־הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","וְכָל־הַשֹּׁמְעִים נִבְהֲלוּ לֵאמֹר הֲלֹא זֶה הוּא אֲשֶׁר הִשְׁמִיד בִּירוּשָׁלַיִם אֶת־הַקֹּרִאים בַּשֵּׁם הַזֶּה וּלְבַעֲבוּר זֹאת בָּא גַם־הֵנָּה לְהוֹלִיךְ אֹתָם אֲסוּרִים אֶל־רָאשֵׁי הַכֹּהֲנִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","וַיְהִי שָׁאוּל הוֹלֵךְ וְחָזֵק וּמְסַכְסֵךְ אֶת־הַיְּהוּדִים בְּדַמָּשֶׂק כִּי הוֹרָה לָהֶם דֵּי בָאֵר כִּי־זֶה הוּא הַמָּשִׁיחַ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","וַיְהִי מִקֵּץ יָמִים רַבִּים וַיִּקְשְׁרוּ עָלָיו הַיְּהוּדִים לְהָרְגוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","וַיִּוָּדַע לְשָׁאוּל קִשְׁרָם וְכִי גַם־שֹׁמְרִים הֵם אֶת־הַשְּׁעָרִים יוֹמָם וָלַיְלָה לְהָרְגוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","וַיִּקְחוּ אֹתוֹ הַתַּלְמִידִים לָיְלָה וַיּוֹרִידֻהוּ בַסַּל מֵעַל הַחוֹמָה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","וַיָּבֹא יְרוּשָׁלַיִם וַיְבַקֵּשׁ לְדָבְקָה בַתַּלְמִידִים וְהֵם כֻּלָּם יָרְאוּ מִפָּנָיו וְלֹא הֶאֱמִינוּ כִּי־תַלְמִיד הוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","וַיִּקַּח אֹתוֹ בַּר־נַבָּא וַיְבִיאֵהוּ אֶת־הַשְּׁלִיחִים וַיְסַפֵּר לָהֶם אֵת אֲשֶׁר־רָאָה בַדֶּרֶךְ אֶת־הָאָדוֹן וְאֶת־אֲשֶׁר דִּבֶּר אִתּוֹ וְכִי גַּם־קָרָא בְדַמֶּשֶׂק בְּשֵׁם יֵשׁוּעַ לְעֵינֵי כֹל׃ ");
INSERT INTO hebsg_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","וַיְהִי אִתָּם יוֹצֵא וָבָא בִּירוּשָׁלָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","וַיִּקְרָא בְּשֵׁם הָאָדוֹן יֵשׁוּעַ לְעֵינֵי הַשָּׁמֶשׁ וַיִּתְוַכַּח עִם־הַיְּהוּדִים הַיְּוָנִים וְהֵם בִּקְשׁוּ אֶת־נַפְשׁוֹ לְקַחְתָּהּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","וַיִּוָּדַע הַדָּבָר אֶל־הָאַחִים וַיְבִיאֻהוּ לְקִסְרִין וּמִשָּׁם שִׁלְּחֻהוּ אֶל־טַרְסוֹס׃ ");
INSERT INTO hebsg_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","וַיְהִי שָׁלוֹם לַעֲדַת אֲדֹנָי וַתִּכֹּן עַל־כַּנָּהּ בְּכָל־אֶרֶץ יְהוּדָה וּבַגָּלִיל וּבְשֹׁמְרוֹן וְכַאֲשֶׁר הִתְהַלְּכוּ בְּיִרְאַת יְהוָֹה וְרוּחַ הַקֹּדֶשׁ מְנַהֵל אֹתָם כֵּן רַבּוּ וְכֵן עָצֵמוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","וּפֶטְרוֹס הָלַךְ הָלֹךְ וְסָבֹב מִמָּקוֹם לְמָקוֹם וַיִּפְקֹד גַּם אֶת־הַקְּדוֹשִׁים הַיֹּשְׁבִים בְּלֹד׃ ");
INSERT INTO hebsg_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","וַיִּמְצָא שָׁם אִישׁ נְכֵה־עֲצָמוֹת וּשְׁמוֹ אֲנִיַּס שֹׁכֵב עַל־עֶרֶשׂ דְּוָי זֶה שְׁמֹנֶה שָׁנִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","וַיֹּאמֶר אֵלָיו פֶּטְרוֹס אֲנִיַּס הֲלֹא יֵשׁוּעַ הַמָּשִׁיחַ רֹפְאֶךָ קוּם הַצַּע־לְךָ עַרְשֶׂךָ וַיָּקָם פִּתְאֹם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","וַיִּרְאוּ אֹתוֹ כָּל־יֹשְׁבֵי לֹד וְיֹשְׁבֵי הַשָּׁרוֹן וַיָּשׁוּבוּ אֶל־הָאָדוֹן׃ ");
INSERT INTO hebsg_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","וּבְיָפוֹ הָיְתָה תַלְמִידָה אַחַת וּשְׁמָהּ טָבִיתָא וּבִשְׂפַת עֵבֶר צְבִיָּה וְהִיא רַבַּת פְּעָלִים טוֹבִים וּצְדָקוֹת אֲשֶׁר פִּזֵּרָה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","וַיְהִי בַּיָּמִים הָהֵם וַתֶּחֱלֶה וַתָּמֹת וַיִּרְחֲצוּ אוֹתָהּ וַיַּשְׁכִּיבֻהָ בַּעֲלִיָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","וְלֹד קְרֹבָה לְיָפוֹ וְהַתַּלְמִידִים שָׁמְעוּ כִּי־פֶטְרוֹס שָׁמָּה וַיִּשְׁלְחוּ אֵלָיו שְׁנַיִם אֲנָשִׁים וַיִּפְצְרוּ־בוֹ לֵאמֹר בֹּאָה־נָּא אֵלֵינוּ אַל־תְּאַחַר׃ ");
INSERT INTO hebsg_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","וַיָּקָם פֶּטְרוֹס וַיֵּלֶךְ וַיָּבֹא אִתָּם וַיַּעֲלוּהוּ אֶל־הָעֲלִיָּה וְהִנֵּה כָּל־הָאַלְמָנוֹת עָמְדוּ עָלָיו בְּבֶכִי לְהַרְאֹתוֹ אֶת־הַכֻּתֳּנֹת וְאֶת־הַשְּׂמָלוֹת אֲשֶׁר עָשְׂתָה לָהֵן צְבִיָּה בְּעוֹדָהּ עִמָּהֶן׃ ");
INSERT INTO hebsg_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","וַיּוֹצֵא פֶטְרוֹס אֶת־כֻּלָּם הַחוּצָה וַיִּכְרַע עַל־בִּרְכָּיו וַיִּתְפַּלֵּל וַיִּפֶן אֶל־הַמֵּתָה וַיֹּאמֶר טָבִיתָא קוּמִי וַתִּפְקַח אֶת־עֵינֶיהָ וַתֵּרֶא אֶת־פֶּטְרוֹס וַתֵּשֶׁב׃ ");
INSERT INTO hebsg_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","וַיִּשְׁלַח אֶת־יָדוֹ וַיְקִימֶהָ וְאַחַר קָרָא לַקְּדוֹשִׁים וְלָאַלְמָנוֹת וַיַּעֲמִידֶהָ חַיָּה לִפְנֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","וְהַדָּבָר הַזֶּה נוֹדַע לְכָל־יֹשְׁבֵי יָפוֹ וַיַּאֲמִינוּ רַבִּים בָּאָדוֹן׃ ");
INSERT INTO hebsg_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","וַיֵּשֶׁב יָמִים רַבִּים בְּיָפוֹ בְּבֵית שִׁמְעוֹן הַבּוּרְסִי׃ ");
INSERT INTO hebsg_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","אִישׁ הָיָה בְּקִסְרִין קָרְנֵלִיּוֹס שְׁמוֹ הוּא שַׂר־מֵאָה בִּצְבָא הַחַיִל אֲשֶׁר קָרְאוּ לוֹ הַגְּדוּד הָאִיטַלְקִי׃ ");
INSERT INTO hebsg_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","וְהוּא אִישׁ חָסִיד וִירֵא אֱלֹהִים עִם־כָּל־בֵּיתוֹ וּפִזַּר נָתַן לָעָם לָרֹב וַיִּתְפַּלֵּל לֵאלֹהִים תָּמִיד׃ ");
INSERT INTO hebsg_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","וַיְהִי הַיּוֹם כְּשָׁעָה הַתְּשִׁיעִית וְהִנֵּה מַלְאַךְ אֱלֹהִים נִרְאָה אֵלָיו בַּמַּחֲזֶה וַיֹּאמַר קָרְנֵילִיּוֹס׃ ");
INSERT INTO hebsg_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","וַיַּבֵּט אֵלָיו וַיִּירָא וַיֹּאמֶר מָה אֲדֹנִי מְצַוֶּה וַיֹּמֶר אֵלָיו תְּפִלָּתְךָ וְצִדְקֹתֶיךָ עָלוּ לְזִכָּרוֹן לִפְנֵי אֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","וְעַתָּה שְׁלַח־לְךָ אֲנָשִׁים אֶל־יָפוֹ וּקְרָא אֵילֶךָ אֶת־שִׁמְעוֹן הַמְכֻנֶּה כֵּיפָא׃ ");
INSERT INTO hebsg_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","הֲלֹא הוּא מִתְגּוֹרֵר עִם־אִישׁ אֶחָד וּשְׁמוֹ שִׁמְעוֹן הַבּוּרְסִי וּבֵיתוֹ עֹמֵד עַל־שְׂפַת הַיָּם הוּא יֹאמַר לְךָ אֶת־אֲשֶׁר עָלֶיךָ לַעֲשׂוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","וַיֵּלֶךְ הַמַּלְאָךְ כַּאֲשֶׁר כִּלָּה לְדַבֵּר אֵלָיו וְהוּא קָרָא אֶל־שְׁנַיִם מֵעַבְדֵי בֵיתוֹ וְאֶל־אִישׁ חַיִל אֶחָד יְרֵא אֱלֹהִים מִן־הָעֹמְדִים לְפָנָיו תָּמִיד׃ ");
INSERT INTO hebsg_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","וַיְסַפֵּר לָהֶם אֵת כָּל־הַדְּבָרִים הָאֵלֶּה וַיִּשְׁלָחֵם יָפוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","וַיְהִי מִמָּחֳרָת כַּאֲשֶׁר הָלְכוּ בַדֶּרֶךְ הָלֹךְ וְקָרֹב אֶל־הָעִיר וַיַּעַל כֵּיפָא לְהִתְפַּלֵּל כְּשָׁעָה הַשִּׁשִּׁית עַל־הַגָּג׃ ");
INSERT INTO hebsg_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","וַיִּרְעַב וַיִּתְאָו לְהָשִׁיב נַפְשׁוֹ וּבְעוֹד הֲכִינוֹ לוֹ אֹכֶל וַתִּתְעַטֵּף נַפְשׁוֹ בְמַרְאוֹת אֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","וַיַּרְא אֶת־הַשָּׁמַיִם פְּתוּחִים וְתֵבָה אַחַת כִּירִיעָה גְדוֹלָה קְשׁוּרָה בְּאַרְבַּע כַּנְפוֹתֶיהָ יוֹרֶדֶת וַתָּנַח עַל־פְּנֵי הָאָרֶץ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","וּבְתוֹכָהּ מִכָּל־חַיַּת הַשָּׂדֶה הַהֹלְכֹת עַל־אַרְבַּע וְרֶמֶשׂ הָאֲדָמָה וְעוֹף הַשָּׁמָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","וַיְהִי אֵלָיו קוֹל קוּם כֵּיפָא זְבַח וֶאֱכֹל׃ ");
INSERT INTO hebsg_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","וַיֹּאמֶר כֵּיפָא חָלִילָה לִּי אֲדֹנִי כִּי מֵעוֹדִי לֹא בָא אֶל־פִּי בְּשַׂר פִּגּוּל אוֹ שֶׁקֶץ טָמֵא׃ ");
INSERT INTO hebsg_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","וְהִנֵּה קוֹל אֵלָיו שֵׁנִית אֶת־אֲשֶׁר טִהַר אֱלֹהִים לֹא תְשַׁקֵּץ אָתָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","וְהַחִזָּיוֹן הַזֶּה שֻׁלַּשׁ שָׁלֹשׁ פְּעָמִים וַתָּשָׁב הַתֵּבָה וַתַּעַל הַשָּׁמָיְמָה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","וַתִּפָּעֶם רוּחַ כֵּיפָא לָדַעַת מָה הוּא הַמַּחֲזֶה אֲשֶׁר חָזָה וְהִנֵּה הָאֲנָשִׁים שְׁלוּחֵי קָרְנֵילִיּוֹס מְבַקְשִׁים בֵּית שִׁמְעוֹן וְעֹמְדִים עַל־הַפָּתַח׃ ");
INSERT INTO hebsg_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","וַיִּקְרְאוּ וַיֹּאמְרוּ הֲמִתְגּוֹרֵר בָּזֶה שִׁמְעוֹן הַמְכֻנֶּה כֵּיפָא׃ ");
INSERT INTO hebsg_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","וּבְעוֹד כֵּיפָא הֹגֶה בִלְבָבוֹ עַל־דְּבַר הַמַּחֲזֶה וַיֹּאמֶר אֵלָיו הָרוּחַ הִנֵּה שְׁלֹשָׁה אֲנָשִׁים מְבַקְשִׁים אֹתָךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","וְעַתָּה קוּם רֵד וָלֵךְ אִתָּם וְאַל־תִּפְסַח הֵנָּה וְהֵנָּה כִּי אָנֹכִי שְׁלַחְתִּים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","וַיֵּרֶד כֵּיפָא אֶל־הָאֲנָשִׁים הַנִּשְׁלָחִים אֵלָיו מֵאֵת קָרְנֵילִיּוֹס וַיֹּאמַר אֲנִי הָאִישׁ אֲשֶׁר אַתֶּם מְבַקְשִׁים עַל־מַה בָּאתֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","וַיַּעֲנוּ לֵאמֹר קָרְנֵילִיּוֹס אֶחָד מִשָּׂרֵי הַמֵּאוֹת אִישׁ צַּדִיק וִירֵא אֱלֹהִים אֲשֶׁר לוֹ שֵׁם טוֹב בְּכָל־עַם הַיְּהוּדִים נִתְּנָה לּוֹ מִצְוַת יְהוָֹה מִפִּי מַלְאָךְ קָדוֹשׁ לִקְרֹא לְךָ אֶל־בֵּיתוֹ לְבַעֲבוּר יִשְׁמַע מִדַּבְּרֹתֶיךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","וַיִּקְרָא אֹתָם וַיָּלִינוּ אִתּוֹ בַּבָּיִת וַיְהִי מִמָּחֳרָת וַיָּקָם כֵּיפָא וַיֵּלֶךְ אִתָּם וַאֲחָדִים מִן־הָאַחִים אֲשֶׁר בְּיָפוֹ הָלְכוּ עִמּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","וּלְמָחֳרָתוֹ בָּאוּ אֶל־קִסְרִין וְקָרְנֵילִיּוֹס חִכָּה לָהֶם וְעִמּוֹ קְרֹבָיו וּמְיֻדָּעָיו אֲשֶׁר הִקְהִילָם בְּבֵיתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","וַיְהִי כְּבוֹא כֵּיפָא וַיֵּצֵא קָרְנֵילִיּוֹס לִקְרָאתוֹ וַיִּפֹּל לְרַגְלָיו וַיִּשְׁתָּחוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","וַיָּקֶם אֹתוֹ כֵּיפָא וַיֹּאמַר קוּם נָא גַּם־אֲנִי אֱנוֹשׁ אָנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","וַיְדַבֵּר אִתּוֹ וַיָּבֹא הַחַדְרָה וַיִּמְצָא רַבִּים נִקְהָלִים שָׁמָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","וַיֹּאמֶר אֲלֵיהֶם אַתֶּם יְדַעְתֶּם כִּי לֹא־נָכוֹן לְאִישׁ יְהוּדִי לִקְרֹב אֶל־אִישׁ נָכְרִי לְדָבְקָה בּוֹ וֵאלֹהִים הֶרְאַנִי לְבִלְתִּי קְרֹא שֶׁקֶץ אוֹ טָמֵא לְכָל־בֶּן־אָדָם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","עַל־כֵּן לֹא נִמְנַעְתִּי מִבּוֹא אֲלֵיכֶם כִּי קְרָאתֶם לִי וְעַתָּה אֶשְׁאֲלָה עַל־מַה־זֶּה קְרָאתֶם לִי לָבוֹא׃ ");
INSERT INTO hebsg_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","וַיֹּאמֶר קָרְנֵילִיּוֹס לִפְנֵי אַרְבָּעָה יָמִים יָשַׁבְתִּי בְצוֹם עַד־הַשָּׁעָה הַזֹּאת וְכַאֲשֶׁר הִתְפַּלַּלְתִּי בְּבֵיתִי בַּשָּׁעָה הַתְּשִׁיעִית וְהִנֵּה אִישׁ עֹטֶה אוֹר נִצָּב עָלָי׃ ");
INSERT INTO hebsg_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","וַיֹּאמַר תְּפִלָּתְךָ קָרְנֵילִיּוֹס שָׁמַע אֱלֹהִים וַיִּזְכָּר־לְךָ אֶת־צִדְקֹתֶיךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","וְעַתָּה שְׁלַח אֶל־יָפוֹ וּקְרָא אֵלֶיךָ אֶת־שִׁמְעוֹן הַמְכֻנֶּה כֵּיפָא הֲלֹא הוּא מִתְגּוֹרֵר בְּבֵית שִׁמְעוֹן הַבּוּרְסִי עַל־שְׂפַת הַיָּם אֲשֶׁר בְּבוֹאוֹ יְדַבֶּר־לָךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","וָאֲמַהֵר וָאֶשְׁלַח אֵלֶיךָ וְאַתָּה הֵיטַבְתָּ כִּי־בָאתָ וְהִנֵּה אֲנַחְנוּ כֻלָּנוּ פֹּה לִפְנֵי הָאֱלֹהִים לִשְׁמֹעַ כְּכֹל אֲשֶׁר צֻוֵּיתָ מֵאֵת יְהוָֹה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","וַיִּפְתַּח כֵּיפָא אֶת־פִּיו וַיֹּאמַר עַתָּה אָמֵן יָדַעְתִּי כִּי אֵין נוֹשֵׂא פָנִים עִם־אֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","כִּי אִם־אִישׁ הַיָּרֵא אֹתוֹ וּפֹעֵל צֶדֶק מִכָּל־גּוֹי וָגוֹי יָפִיק רָצוֹן מִמֶּנּוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","וְהוּא שָׁלַח דְּבָרוֹ לִבְנֵי יִשְׂרָאֵל וַיְבַשֵּׂר אֹתָם שָׁלוֹם בְּיַד יֵשׁוּעַ הַמָּשִׁיחַ הוּא אֲדוֹן כֹּל׃ ");
INSERT INTO hebsg_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","כִּי הֲלֹא יְדַעְתֶּם אֶת־הַדָּבָר אֲשֶׁר קָרָה בְּאֶרֶץ יְהוּדָה הָחֵל בַּגָּלִיל אַחֲרֵי קְרִיאַת יוֹחָנָן לִטְבִילָתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","אֵת אֲשֶׁר־מָשַׁח אֱלֹהִים אֶת־יֵשׁוּעַ הַנָּצְרִי בְּרוּחַ קָדְשׁוֹ וּגְבוּרָתוֹ וְהוּא הָלַךְ בָּאָרֶץ הָלֹךְ וַעֲשׂה טוֹב וְאֶת־הָרְצוּצִים תַּחַת יַד הַשָּׂטָן שִׁלַּח חָפְשִׁי כִּי הָאֱלֹהִים הָיָה עִמּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","וַאֲנַחְנוּ עֵדִים עַל־כָּל־אֲשֶׁר עָשָׂה בְּאֶרֶץ הַיְּהוּדִים וּבִירוּשָׁלָיִם וְעַל־אֲשֶׁר הֵם הֲרָגֻהוּ וַיִּתְלוּ אֹתוֹ עַל־הָעֵץ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","וְאֹתוֹ הֵקִים אֱלֹהִים בַּיּוֹם הַשְּׁלִישִׁי וַיִּתְּנֵהוּ לְהִגָּלוֹת לְעֵינֵי הָרֹאִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","לֹא לְעֵינֵי כָּל־הָעָם כִּי אִם־לְעֵינֵי הָעֵדִים אֲשֶׁר בָּחַר בָּם אֱלֹהִים מִקֶּדֶם וַאֲנַחְנוּ הֵם אֲשֶׁר אָכַלְנוּ וְשָׁתִינוּ עִמּוֹ אַחֲרֵי קוּמוֹ מִן־הַמֵּתִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","וְהוּא צִוָּה אֹתָנוּ לִקְרֹא בְאָזְנֵי הָעָם וּלְהָעִיד לִפְנֵיהֶם כִּי זֶה הוּא אֲשֶׁר נְתָנוֹ אֱלֹהִים לְשֹׁפֵט הַחַיִּים וְהַמֵּתִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","וְגַם כָּל־הַנְּבִיאִים מְעִידִים עָלָיו כִּי שְׁמוֹ יִהְיֶה לְכָל־הַמַּאֲמִינִים בּוֹ לִסְלִיחַת עָוֹן׃ ");
INSERT INTO hebsg_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","עוֹד כֵּיפָא מְדַבֵּר אֶת־הַדְּבָרִים הָאֵלֶּה וְרוּחַ הַקֹּדֶשׁ צָלְחָה עַל־כָּל הַשֹּׁמְעִים דְּבָרוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","וְהַנִּמּוֹלִים הַמַּאֲמִינִים אֲשֶׁר בָּאוּ עִם־כֵּיפָא הִתַּמְּהוּ תָּמָהוּ כִּי־מַתְּנַת רוּחַ הַקֹּדֶשׁ גַּם עַל־הַגּוֹיִם נִשְׁפָּכָה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","כִּי שָׁמְעוּ אֹתָם מְדַבְּרִים בִּלְשֹׁנוֹת וְנֹתְנִים גֹּדֶל לֵאלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","וַיַּעַן פֶּטְרוֹס וַיֹּאמַר הֲיוּכַל אִישׁ לַעֲצֹר בַּמַּיִם לְבִלְתִּי יִטָּבְלוּ אֲנָשִׁים אֵלֶּה אֲשֶׁר צָלְחָה רוּחַ הַקֹּדֶשׁ עֲלֵיהֶם כְּמוֹהֶם כָּמֹנוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","וַיְצַו אֹתָם כִּי יִטָּבְלוּ בְּשֵׁם יֵשׁוּעַ הַמָּשִׁיחַ וְהֵם בִּקְשֻׁהוּ כִּי יֵשֵׁב עִמָּהֶם יָמִים אֲחָדִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","וְהַשְּׁלִיחִים וְהָאַחִים אֲשֶׁר בִּיהוּדָה שָׁמְעוּ כִּי גַּם־הַגּוֹיִם קִבְּלוּ אֶת־דְּבַר הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","וּפֶטְרוֹס בָּא יְרוּשָׁלָיִם וַיַּלִּינוּ עָלָיו הַנִּמּוֹלִים לֵאמֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","בֵּית אֲנָשִׁים עֲרֵלִים בָּאתָ וַתִּתְעָרֶב־בָּם לֶאֱכֹל אִתָּם לָחֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","וַיָּחֶל פֶּטְרוֹס וַיְסַפֵּר לָהֶם דָּבָר דָּבָר עַל־אָפְנָיו לֵאמֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","מִתְפַּלֵּל הָיִיתִי בְּעִיר יָפוֹ וַתִּפֹּל עָלַי הָרוּחַ וָאֵרֶא בַמַּחֲזֶה וְהִנֵּה־תֵבָה אַחַת כִּירִיעָה גְדוֹלָה קְשׁוּרָה בְּאַרְבַּע כַּנְפוֹתֶיהָ יֹרֶדֶת מִן־הַשָּׁמַיִם וַתָּבֹא עָדָי׃ ");
INSERT INTO hebsg_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","וָאֵפֶן לְהַבִּיט וָאָבִין וָאֵרֶא בָהּ בֶּהֱמַת הָאָרֶץ וְחַיַּת הַשָּׂדֶה הַהֹלְכֹת עַל־אַרְבַּע וְרֶמֶשׂ הָאֲדָמָה וְעוֹף הַשָּׁמָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","וָאֶשְׁמַע גַּם־קוֹל מֵדַּבֵּר אֵלַי קוּם כֵּיפָא זְבַח וֶאֱכֹל׃ ");
INSERT INTO hebsg_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","וָאֹמַר חָלִילָה לִּי אֲדֹנִי כִּי מֵעוֹדִי לֹא־בָא אֶל־פִּי בְּשַׂר פִּגּוּל אוֹ שֶׁקֶץ טָמֵא׃ ");
INSERT INTO hebsg_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","וַיַּעַן הַקּוֹל שֵׁנִית מִן־הַשָּׁמָיִם אֶת־אֲשֶׁר טִהַר הָאֱלֹהִים לֹא תְשַׁקֵּץ אָתָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","וְהַחִזָּיוֹן הַזֶּה נִרְאָה אֵלַי שָׁלֹשׁ פְּעָמִים וְאַחֲרֵי־כֵן הוּרַם הַכֹּל וַיַּעַל הַשָּׁמָיְמָה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","וְכִמְעַט רֶגַע וְהִנֵּה שְׁלֹשָׁה אֲנָשִׁים עֹמְדִים עַל־פֶּתַח הַבַּיִת אֲשֶׁר הָיִינוּ שָׁם כִּי נִשְׁלְחוּ אֵלַי מִקִּסְרִין׃ ");
INSERT INTO hebsg_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","וְהָרוּחַ דִּבֶּר בִּי לָלֶכֶת אִתָּם וְלֹא לִפְסֹחַ הֵנָּה וָהֵנָּה וַיֵּלְכוּ אִתִּי גַּם־שֵׁשֶׁת הָאַחִים הָאֵלֶּה וַנָּבֹא אֶל־בֵּית הָאִישׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","וַיַּגֶּד־לָנוּ אֵת אֲשֶׁר־רָאָה מַלְאָךְ נִצָּב בְּבֵיתוֹ אֲשֶׁר צִוָּה אֹתוֹ לֵאמֹר שְׁלַח אֶל־יָפוֹ וּקְרָא אֵלֶיךָ אֶת־שִׁמְעוֹן הַמְכֻנֶּה כֵּיפָא׃ ");
INSERT INTO hebsg_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","וְהוּא יְדַבֵּר אֵלֶיךָ דְּבָרִים אֲשֶׁר תִּוָּשַׁע בָּם אַתָּה וְכָל־בֵּיתֶךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","וְכַאֲשֶׁר הַחִלֹּתִי לְדַבֵּר וַתִּצְלַח עֲלֵיהֶם רוּחַ הַקֹּדֶשׁ כַּאֲשֶׁר צָלְחָה עָלֵינוּ בַּתְּחִלָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","וָאֶזְכֹּר אֶת־דְּבַר הָאָדוֹן אֲשֶׁר אָמָר יוֹחָנָן טִבֵּל בַּמַּיִם וְאַתֶּם תִּטָּבְלוּ בְּרוּחַ הַקֹּדֶשׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","וְעַתָּה אַחֲרֵי אֲשֶׁר נָתַן לָהֶם אֱלֹהִים אֶת־הַמַּתָּנָה הַזֹּאת כַּאֲשֶׁר נָתַן גַּם־לָנוּ הַמַּאֲמִינִים בָּאָדוֹן יֵשׁוּעַ הַמָּשִׁיחַ אֲנִי מִי אֲנִי כִּי אָבֹא לִכְלוֹא אֶת־הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","וַיְהִי כְּשָׁמְעָם אֶת־הַדְּבָרִים הָאֵלֶּה וַיַּחֲרִישׁוּ וַיִּתְּנוּ כָבוֹד לֵאלֹהִים לֵאמֹר אָכֵן גַּם־לַגּוֹיִם נָתַן אֱלֹהִים לָשׁוּב לְדֶרֶךְ הַחַיִּים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","וְהַנְּפוֹצִים מִפְּנֵי הַצָּרָה אֲשֶׁר עָבְרָה עֲלֵיהֶם עַל־דִּבְרַת סְטְפָנוֹס הָלְכוּ עַד־פִּינוּקְיָא וְקַפְרוֹס וְאַנְטְיוֹכְיָא וְלֹא הִגִּידוּ דְבַר הַבְּשׂוֹרָה לְאִישׁ זוּלָתִי לַיְּהוּדִים לְבַדָּם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","וּמֵהֶם הָיוּ אַנְשֵׁי קַפְרוֹס וְקוּרִינִי אֲשֶׁר בָּאוּ אַנְטְיוֹכְיָא וַיְדַבְּרוּ גַּם־אֶל־הַיְּוָנִים וַיְבַשְּׂרוּם אֶת־הָאָדוֹן יֵשׁוּעַ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","וְיַד יְהוָֹה הָיְתָה עֲלֵיהֶם וְרַבִּים בְּמִסְפָּר הֶאֱמִינוּ וַיָּשׁוּבוּ אֶל־הָאָדוֹן׃ ");
INSERT INTO hebsg_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","וּשְׁמוּעָתָם בָּאָה אֶל־אָזְנֵי הָעֵדָה אֲשֶׁר בִּירוּשָׁלָיִם וַיִּשְׁלְחוּ אֶת־בַּר־נַבָּא אֶל־אַנְטְיוֹכְיָא׃ ");
INSERT INTO hebsg_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","וַיָּבֹא וַיַּרְא אֶת־חֶסֶד הָאֱלֹהִים וַיִּשְׂמָח וַיְדַבֵּר עַל־לֵב כֻּלָּם לְדָבְקָה בָאָדוֹן בְּרוּחַ נָכוֹן׃ ");
INSERT INTO hebsg_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","כִּי אִישׁ טוֹב הָיָה וּמָלֵא רוּחַ הַקֹּדֶשׁ וֶאֱמוּנָה וְעַם־רָב נִסְפְּחוּ עַל־הָאָדוֹן׃ ");
INSERT INTO hebsg_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","וַיֵּלֶךְ מִשָּׁם אֶל־טַרְסוֹס לְבַקֵּשׁ אֶת־שָׁאוּל׃ ");
INSERT INTO hebsg_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","וַיִּמְצָאֵהוּ וַיְבִיאֵהוּ אַנְטְיוֹכְיָא וַיֵּשְׁבוּ שָׁם שָׁנָה תְמִימָה בְּקֶרֶב הַקָּהָל וַיְלַמְּדוּ תוֹרָה לָרַבִּים אָז הוּחַל בְּאַנְטְיוֹכְיָא לִקְרֹא לַתַּלְמִידִים מְשִׁיחִיִּים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","וַיְהִי בַּיָּמִים הָהֵם וַיֵּרְדוּ נְבִיאִים מִירוּשָׁלַיִם אַנְטְיוֹכְיָא׃ ");
INSERT INTO hebsg_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","וַיָּקָם אֶחָד מֵהֶם וּשְׁמוֹ אֲגָבוֹס וְהָרוּחַ דִּבֶּר בּוֹ כִּי רָעָב גָּדוֹל יִהְיֶה בְּכָל־הָאָרֶץ הוּא הָרָעָב אֲשֶׁר בָּא בִּימֵי קְלוֹדְיוֹס׃ ");
INSERT INTO hebsg_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","וַיִּתְנַדְּבוּ הַתַּלְמִידִים לִשְׁלֹחַ אִישׁ אִישׁ מֵהֶם כַּאֲשֶׁר תַּשִּׂיג יָדוֹ לַעֲזֹר לָאַחִים הַיֹּשְׁבִים בִּיהוּדָה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","וַיַעֲשׂוּ כֵן וַיִּשְׁלְחוּ נִדְבַת יָדָם אֶל־הַזְּקֵנִים עַל־יַד בַּר־נַבָּא וְשָׁאוּל׃ ");
INSERT INTO hebsg_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","בָּעֵת הַהִיא שָׁלַח הוֹרְדוֹס הַמֶּלֶךְ אֶת־יָדוֹ בְּאַנְשֵׁי הָעֵדָה לְעַנּוֹתָם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","וַיַּהֲרֹג אֶת־יַעֲקֹב אֲחִי יוֹחָנָן בֶּחָרֶב׃ ");
INSERT INTO hebsg_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","וַיַּרְא כִּי־טוֹב הַדָּבָר בְּעֵינֵי הַיְּהוּדִים וַיּוֹסֶף וַיִּתְפֹּשׂ גַּם־אֶת־פֶּטְרוֹס וְהַיָּמִים יְמֵי חַג־הַמַּצּוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","וַיַּחֲזֶק־בּוֹ וַיִּתְּנֵהוּ בְּבֵית הַכֶּלֶא וַיִּשְׁמְרֻהוּ אַרְבַּע מַחְלְקוֹת אַנְשֵׁי הַצָּבָא אַרְבָּעָה אַרְבָּעָה כָּל־מַחְלְקָה כִּי אָמַר לְהַעֲמִידוֹ לִפְנֵי הָעָם אַחֲרֵי הַפָּסַח׃ ");
INSERT INTO hebsg_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","וַיְהִי פֶּטְרוֹס עָצוּר בְּבֵית כִּלְאוֹ אַךְ הָעֵדָה הֶעְתִּירָה בַעֲדוֹ אֶל־אֱלֹהִים בְּחָזְקָה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","וְאַחֲרֵי אֲשֶׁר חָפֵץ הוֹרְדוֹס לַהֲבִיאוֹ לַמִּשְׁפָּט בַּלַּיְלָה הַהוּא שָׁכַב פֶּטְרוֹס עַל־מִשְׁכָּבוֹ בֵּין שְׁנֵי אֲנָשִׁים חֲמֻשִּׁים אָסוּר בִּשְׁנַיִם כְּבָלִים וְשֹׁמְרֵי בֵית הַכֶּלֶא נִצָּבִים עַל־הַסָּף׃ ");
INSERT INTO hebsg_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","וְהִנֵּה מַלְאַךְ יְהוָֹה נִצָּב עָלָיו וְאוֹר נָגַהּ בְּלִשְׁכָּתוֹ וַיִּגַּע בְּכַף יֶרֶךְ פֶּטְרוֹס וַיְעִירֵהוּ לֵאמֹר קוּם מַהֵר וַיִּמַּסּוּ אֲסוּרָיו מֵעַל יָדָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","וַיֹּאמֶר אֵלָיו הַמַּלְאָךְ חֲגֹר מָתְנֶיךָ וּנְעָלֶיךָ שִׂים בְּרַגְלֶיךָ וַיַּעַשׂ כֵּן וַיֹּאמֶר אֵלָיו וְאֶת־מְעִילְךָ עֲטֵה וְלֵךְ אַחֲרָי׃ ");
INSERT INTO hebsg_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","וַיֵּצֵא וַיֵּלֶךְ אַחֲרָיו וְנַפְשׁוֹ לֹא יָדְעָה אִם־אֱמֶת הוּא אֲשֶׁר נַעֲשָׂה לּוֹ בְּיַד הַמַּלְאָךְ כִּי כְּחִזָּיוֹן נִרְאָה בְעֵינָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","וַיַּעַבְרוּ אֶת־טוּר הַשֹּׁמְרִים הָרִאשׁוֹנִים וְאֶת־טוּר הַשְּׁנִיִּים וַיָּבֹאוּ אֶל־שַׁעַר הַבַּרְזֶל הַיֹּצֵא הָעִירָה אֲשֶׁר נִפְתַּח לִפְנֵיהֶם מֵאֵלָיו וַיֵּצְאוּ בוֹ וַיַּעַבְרוּ רְחוֹב אֶחָד וַיַּעַל הַמַּלְאָךְ מֵעָלָיו פִּתְאֹם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","וַיֹּאמֶר פֶּטְרוֹס כְּשׁוּב דַּעְתּוֹ אֵלָיו עַתָּה יָדַעְתִּי אֶל־נָכוֹן כִּי שָׁלַח יְהוָֹה אֶת־מַלְאָכוֹ וַיַּצִּילֵנִי מִכַּף הוֹרְדוֹס וּמִכָּל־צְדִיַּת עַם־הַיְּהוּדִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","עוֹדֶנּוּ מְדַבֵּר אֶל־לִבּוֹ וַיָּבֹא אֶל־בֵּית מִרְיָם אֵם יוֹחָנָן הַמְכֻנֶּה מַרְקוֹס וְשָׁם רַבִּים נִקְהָלִים וּמִתְפַּלְּלִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","וַיִּדְפֹּק עַל־דֶּלֶת הַשָּׁעַר וַתָּבֹא נַעֲרָה אַחַת לְקוֹל הַדֹּפֵק וּשְׁמָהּ רוֹדִי׃ ");
INSERT INTO hebsg_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","וַתַּכֵּר אֶת־קוֹל פֶּטְרוֹס ומִשִּׂמְחָתָהּ לֹא־פָתְחָה לּוֹ אֶת־הַדָּלֶת כִּי אִם־רָצָה הַבַּיְתָה וַתַּגֵּד לָהֶם כִּי־פֶטְרוֹס עֹמֵד עַל־הַפָּתַח׃ ");
INSERT INTO hebsg_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","וַיֹּאמְרוּ אֵלֶיהָ מִשְׁתַּגֵּעָה אָתְּ וְהִיא אָמְרָה לֹא כִּי־כֵן הַדָּבָר אָז אָמְרוּ כִּי־מַלְאָכוֹ הוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","וּפֶטְרוֹס הוֹסִיף לִדְפֹּק וַיִּפְתְּחוּ וַיִּרְאוּ אֹתוֹ וַיְהִי לְפֶלֶא בְּעֵינֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","וַיָּנֶף יָדוֹ לָהֶם לַחְשׁוֹת וַיְסַפֵּר לָהֶם אֵת אֲשֶׁר־הוֹצִיאוֹ הָאָדוֹן מִבֵּית הַכֶּלֶא וַיֹּאמֶר הַגִּידוּ זֹאת לְיַעֲקֹב וְלָאַחִים וַיֵּצֵא וַיֵּלֶךְ־לוֹ לְמָקוֹם אַחֵר׃ ");
INSERT INTO hebsg_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","הַבֹּקֶר אוֹר וּמְהוּמָה רַבָּה הָיְתָה בֵּין אַנְשֵׁי הַצָּבָא לֵאמֹר מֶה־הָיָה לְפֶטְרוֹס׃ ");
INSERT INTO hebsg_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","וְהוֹרְדוֹס דָּרַשׁ אֹתוֹ וְלֹא מְצָאוֹ וַיַּחֲקֹר אֶת־הַשֹּׁמְרִים וַיִּתֵּן דָּתוֹ לַהֲמִיתָם וַיֵּרֶד מִיהוּדָה אֶל־קִסְרִין וַיֵּשֶׁב שָׁם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","אָז חָרָה אַפּוֹ בַּצֹּרִים וּבַצִּדֹנִים וְהֵם בָּאוּ אֵלָיו בְּלֵב אֶחָד וַיְדַבְּרוּ עַל־לֵב בְּלַסְטוֹס אֲשֶׁר עַל־חֲדַר הַמֶּלֶךְ לְהַפְגִּיעַ בַּעֲדָם וְלַעֲשׂוֹת שָׁלוֹם לָהֶם כִּי מֵאֶרֶץ הַמֶּלֶךְ הוֹצִיאוּ לָהֶם אֶת־שֶׁבֶר רַעֲבוֹן אַרְצוֹתָם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","וַיְהִי הַיּוֹם יוֹם מוֹעֵד וַיִּלְבַּשׁ הוֹרְדוֹס בִּגְדֵי מַלְכוּת וַיֵּשֶׁב עַל־כִּסֵּא הַמִּשְׁפָּט וַיִּשָּׂא אֲלֵיהֶם מִדַּבְּרֹתָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","וַיָּרִיעוּ הָאָם לֵאמֹר קוֹל אֱלֹהִים הוּא וְלֹא קוֹל אָדָם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","וַיַּכֵּהוּ מַלְאַךְ־יְהוָֹה כְּרֶגַע כִּי לֹא־נָתַן כָּבוֹד לֵאלֹהִים וַיֹּאכְלֻהוּ תוֹלָעִים וַיָּמֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","וּדְבַר אֱלֹהִים עָלָה עָלֹה וָרָב׃ ");
INSERT INTO hebsg_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","וַיָּשׁוּבוּ בַּר־נַבָּא וְשָׁאוּל מִירוּשָׁלָיִם אַחֲרֵי אֲשֶׁר מִלְאוּ אֶת־פְּקֻדָּתָם הַנְּתוּנָה לָהֶם וַיִּקְחוּ אִתָּם אֶת־יוֹחָנָן הַמְכֻנֶּה מַרְקוֹס׃ ");
INSERT INTO hebsg_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","וַיִּהְיוּ בַּקָּהָל אֲשֶׁר בְּאַנְטְיוֹכְיָא נְבִיאִים וּמְלַמְּדִים וְאֵלֶּה שְׁמוֹתָם בַּר־נַבָּא וְשִׁמְעוֹן הַנִּקְרָא גַם־נִיגַר וְלוּקְיוֹס הַקּוּרִינִי וּמְנַחֵם אֲשֶׁר הָיָה אָמוֹן עִם־הוֹרְדוֹס טֶטְרַרְךְ וְשָׁאוּל׃ ");
INSERT INTO hebsg_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","וּבַעֲבוֹדָתָם אֶת־יְהוָֹה וּבְצוֹמָם הָיָה דְבַר רוּחַ הַקֹּדֶשׁ הַבְדִּילוּ־נָא לִי אֶת־בַּר־נַבָּא וְאֶת־שָׁאוּל לַעֲשׂוֹת בַּמְּלָאכָה אֲשֶׁר קְרָאתִים לָהּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","וַיָּצוּמוּ וַיִּתְפַּלְּלוּ וַיִּסְמְכוּ אֶת־יְדֵיהֶם עֲלֵיהֶם וַיְשַׁלְּחוּם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","וַיֵּלְכוּ שְׁלִיחֵי רוּחַ הַקֹּדֶשׁ הָאֵלֶּה אֶל־סְלוּקְיָא וְשָׁם יָרְדוּ בָאֳנִיָּה לָבֹא אֶל־קַפְרוֹס׃ ");
INSERT INTO hebsg_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","בְּבוֹאָם עִירָה סְלָמִים הִגִּידוּ אֶת־דְּבַר הָאֱלֹהִים בְּבָתֵּי־הַכְּנֵסֶת אֲשֶׁר לַיְּהוּדִים וְגַם־יוֹחָנָן הָיָה עִמָּם לְשָׁרְתָם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","וַיְהִי כַּאֲשֶׁר תַּמּוּ לִסְבֹּב בְּכָל־הָאִי עַד־פָּפוֹס וַיִּמְצְאוּ שָׁם אִישׁ מְכַשֵּׁף וּנְבִיא־שָׁקֶר וְהוּא אִישׁ יְהוּדִי וּשְׁמוֹ בַּר־יֵשׁוּעַ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","הוּא הָיָה עִם־סֶרְגִּיּוֹס פּוֹלוֹס נְצִיב הָאִי וְזֶה אִישׁ חֲכַם־לֵב קָרָא אֶת־בַּר־נַבָּא וְאֶת־שָׁאוּל לָבוֹא אֵלָיו לִשְׁמֹעַ מִפִּיהֶם דְּבַר הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","וְאַלִּימָא הַמְכַשֵּׁף כִּי־כֵן מְתֻרְגָּם שְׁמוֹ הָיָה לָהֶם לְשָׂטָן כִּי יָזַם לְהָסֵב אֶת־הַנְּצִיב מֵהַאֲמִין׃ ");
INSERT INTO hebsg_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","רַק שָׁאוּל אֲשֶׁר נִקְרָא גַם־פּוֹלוֹס מָלֵא רוּחַ הַקֹּדֶשׁ הִשְׁגִּיחַ אֵלָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","וַיִּקְרָא הוֹי בֶּן־בְּלִיַּעַל מָלֵא כָל־עָרְמָה וּמִרְמָה וְשׂוֹנֵא כָל־צֶדֶק הֲכִי לֹא תֶחְדַּל עוֹד מֵעַקֵּשׁ אֶת־דַּרְכֵי יְהוָֹה הַיְשָׁרִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","וְעַתָּה הִנֵּה יַד־יְהוָֹה תִּגַּע בְּךָ וְהָיִיתָ עִוֵּר עַד לִמְלֹא־יָמִים וְאוֹר הַשֶּׁמֶשׁ לֹא תִרְאֶה וּבִן רֶגַע כְּדַבְּרוֹ הָיְתָה עָלָיו אֲפֵלָה וַחֲשֵׁכָה וַיֵּתַע וַיְגַשֵּׁשׁ אָנֶה וָאָנֶה לִמְצֹא אִישׁ לַנְחֹתוֹ בְיָדוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","כִּרְאוֹת הַנְּצִיב אֶת־אֲשֶׁר נַעֲשָׂה הֶאֱמִין וַיִּשְׁתָּאֶה לְתוֹרַת הָאָדוֹן׃ ");
INSERT INTO hebsg_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","וַיָּשָׁב פּוֹלוֹס וְהַנִּלְוִים עָלָיו מִפָּפוֹס בָּאֳנִיָּה וַיַּעֲלוּ אֶל־פַּרְגִי אֲשֶׁר בְּפַמְפּוּלְיָא וְשָׁם נִפְרַד יוֹחָנָן מֵעֲלֵיהֶם לָשׁוּב יְרוּשָׁלָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","וְהֵם נָסְעוּ מִפַּרְגִי וַיֵּלְכוּ אֶל־אַנְטְיוֹכְיָא אֲשֶׁר בְּפִיסִדְיָא וַיָּבֹאוּ בְיוֹם הַשַּׁבָּת אֶל־בֵּית־הַכְּנֵסֶת וַיֵּשֵׁבוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","וַיְהִי אַחֲרֵי הִקָּרֵא בַתּוֹרָה וּבַנָּבִיא וַיִּשְׁלְחוּ רָאשֵׁי בֵית־הַכְּנֵסֶת לֵאמֹר לָהֶם אֲנָשִׁים אַחִים אִם־יֵשׁ לָכֶם דָּבָר לְהוֹכַח אֶת־הָעָם דַּבֵּרוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","וַיַּעֲמֹד פּוֹלוֹס וַיְנֹפֵף יָדוֹ וַיֹּאמַר אַנְשֵׁי יִשְׂרָאֵל וְגַם־הַיְרֵאִים אֶת־הָאֱלֹהִים שְׁמָעוּנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","אֱלֹהֵי יִשְׂרָאֵל אֱלֹהֵי הָעָם הַזֶּה הוּא בָחַר בַּאֲבוֹתֵינוּ וַיָּרֶם קֶרֶן לָעָם בִּהְיוֹתָם גֵּרִים בְּאֶרֶץ מִצְרַיִם וְהוּא הוֹצִיאָם מִשָּׁם בִּזְרֹעַ נְטוּיָה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","וַיִּשָּׂא אֹתָם וַיְכַלְכְּלֵם אַרְבָּעִים שָׁנָה בַּמִדְבָּר׃ ");
INSERT INTO hebsg_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","וַיַּשְׁמֵד מִפְּנֵיהֶם שִׁבְעָה גוֹיִם בְּאֶרֶץ כְּנָעַן וַיַּפֵּל לָהֶם בַּחֶבֶל אֶת־אַדְמָתָם לִירֻשַׁת נַחֲלָה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","אַחֲרֵי־כֵן נָתַן לָהֶם שֹׁפְטִים לְשָׁפְטָם כְּאַרְבַּע מֵאוֹת וַחֲמִשִּׁים שָׁנָה עַד־שְׁמוּאֵל הַנָּבִיא׃ ");
INSERT INTO hebsg_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","בְּיָמָיו שָׁאֲלוּ לִמְלֹךְ עֲלֵיהֶם מֶלֶךְ וְהָאֱלֹהִים נָתַן לָהֶם אֶת־שָׁאוּל בֶּן־קִישׁ אִישׁ יְמִינִי לְמֶלֶךְ עֲלֵיהֶם אַרְבָּעִים שָׁנָה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","וְאַחֲרֵי הֲסִירוֹ אֹתוֹ מִמְּלֹךְ הֵקִים אֶת־דָּוִד לְמֶלֶךְ עֲלֵיהֶם אֲשֶׁר אָמַר עָלָיו וַיְעִידֶנּוּ מָצָאתִי אֶת־דָּוִד בֶּן־יִשַׁי אִישׁ כִּלְבָבִי אֲשֶׁר כָּל־חֶפְצִי יַשְׁלִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","מִזַּרְעוֹ הֵבִיא הָאֱלֹהִים כִּדְבָרוֹ אֶת־יֵשׁוּעַ לְיִשְׂרָאֵל לְמוֹשִׁיעַ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","וַיְהִי אַחֲרֵי קְרֹא יוֹחָנָן אֶל־כָּל־עַם יִשְׂרָאֵל לִתְשׁוּבָה וּלְהִטָּבֵל לִפְנֵי בֹאוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","וּכְכַלּוֹת יוֹחָנָן אֶת־מְרוּצָתוֹ אָמַר וּמַה־תְּחַשְׁבוּן עָלַי מִי־אָנִי לֹא אֲנִי הוּא כִּי הִנֵּה אַחֵר בָּא אַחֲרַי וְהוּא אֲשֶׁר קַלֹּתִי מֵהַתֶּר־לוֹ שְׂרוֹךְ נְעָלָיו אֲשֶׁר בְּרַגְלָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","אַתֶּם אֲנָשִׁים אַחִים זֶרַע אַבְרָהָם וְכָל־יִרְאֵי אֱלֹהִים הַנִּמְצְאִים בְּתוֹכֲכֶם אֵלֵינוּ דְּבַר הַיְשׁוּעָה הַזֹּאת שָׁלוּחַ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","כִּי־הַיּשְׁבִים בִּירוּשָׁלַיִם וְרָאשֵׁיהֶם יַעַן אֲשֶׁר לֹא יָדְעוּ אֹתוֹ וְאֶת־דִּבְרֵי הַנְּבִיאִים הַנִּקְרָאִים מִדֵּי שַׁבָּת בְּשַׁבַּתּוֹ מִלְאוּ אֹתָם בְּמִשְׁפָּטָם אֲשֶׁר שְׁפָטֻהוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","וְאַף כִּי־לֹא מָצְאוּ־בוֹ חֵטְא מִשְׁפַּט־מָוֶת בִּקְשׁוּ מֵאֵת פִּילָטוֹס לַהֲמִיתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","כְּבַצְּעָם אֶת־הַכֹּל אֲשֶׁר כָּתוּב עָלָיו הוֹרִדֻהוּ מֵעַל הָעֵץ וַיַּשְׁכִּיבֻהוּ בַּקָּבֶר׃ ");
INSERT INTO hebsg_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","וְהָאֱלֹהִים הֲקִימוֹ מֵעִם־הַמֵּתִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","וְהוּא יָמִים רַבִּים נִגְלֹה נִגְלָה אֶל־אֲשֶׁר עָלוּ עִמּוֹ מֵהַגָּלִיל לִירוּשָׁלָיִם וַאֲשֶׁר עַתָּה כַּיּוֹם הֵם עֵדִים לוֹ נֶגֶד הָעָם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","וְכֹה אֲנַחְנוּ מוֹדִיעִים לָכֶם כִּי שְׁבוּעָתוֹ לַאֲבֹתֵינוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","הֵקִים אֱלֹהִים עַתָּה לְבָנֵינוּ אֶת־דְּבָרוֹ בַּהֲקִימוֹ אֶת־יֵשׁוּעַ כַּאֲשֶׁר גַּם כָּתוּב בַּמִּזְמוֹר הַשֵּׁנִי בְּנִי אַתָּה אֲנִי הַיּוֹם יְלִדְתִּיךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","וּבַדָּבָר אֲשֶׁר הֵקִים אֹתוֹ מִבֵּין הַמֵּתִים אֲשֶׁר לֹא יָשׁוּב עוֹד לְשַׁחַת־בְּלִי כֹּה אָמָר אֶתֵּן לָכֶם חַסְדֵּי דָוִד הַנֶּאֱמָנִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","עַל־כֵּן הוּא אֹמֵר עוֹד בְּמִזְמֹר אַחֵר לֹא־תִּתֵּן חֲסִידְךָ לִרְאוֹת שָׁחַת׃ ");
INSERT INTO hebsg_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","כִּי דָוִד אַחֲרֵי לֶכְתּוֹ בְדֹרֹתָיו בַּעֲצַת אֱלֹהִים הוּא גָוַע וַיֵּאָסֶף אֶל־אֲבוֹתָיו וַיַּרְא שָׁחַת׃ ");
INSERT INTO hebsg_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","אַךְ־זֶה אֲשֶׁר הָאֱלֹהִים הֲקִימוֹ הוּא לֹא־רָאָה שָׁחַת׃ ");
INSERT INTO hebsg_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","לָכֵן אֲנָשִׁים אַחִים יִוָּדַע לָכֶם כִּי עַל־יְדֵי־זֶה הֻגַּד לָכֶם סְלִיחַת הַחֲטָאִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","כִּי־בַכֹּל אֲשֶׁר לֹא־נִצְדַּקְתֶּם בְּתוֹרַת משֶׁה כָּל־הַמַּאֲמִין יִצְדַּק־בּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","לָכֵן הִשָּׁמְרוּ לָכֶם פֶּן־יָבוֹא עֲלֵיכֶם אֲשֶׁר כָּתוּב בַּנְּבִיאִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","רְאוּ אַתֶּם בֹּזִים וְהִתַּמְּהוּ וָשֹׁמּוּ כִּי־פֹעַל פֹּעֵל אֲנִי בִּימֵיכֶם פֹּעַל אֲשֶׁר לֹא תַאֲמִינוּ כִּי־יְסֻפַּר לָכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","וַיְהִי בְּצֵאתָם וַיְבַקְשׁוּם לְדַבֵּר אֲלֵיהֶם כַּדְּבָרִים הָאֵלֶּה עוֹד שֵׁנִית גַּם־בְּיוֹם הַשַּׁבָּת הָאַחֵר׃ ");
INSERT INTO hebsg_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","בְּהִפָּרֵד הַקָּהָל נָטוּ יְהוּדִים רַבִּים וְגֵרִים הַיְרֵאִים אֶת־יְהוָֹה וַיֵּלְכוּ אַחֲרֵי פוֹלוֹס וּבַר־נַבָּא וְהֵם אָמְרוּ לָהֶם וַיַּזְהִירוּם לִהְיוֹת דְּבֵקִים בְּחֶסֶד הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","וַיְהִי בְּיוֹם הַשַּׁבָּת הָאַחֵר וַתִּקָּהֵל כִּמְעַט כָּל־הָעִיר לִשְׁמֹעַ אֶת־דְּבַר יְהוָֹה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","אוּלָם כִּרְאוֹת הַיְּהוּדִים אֶת־הֲמוֹן הָעָם נֶהְפַּךְ לִבָּם לְקִנְאָה וַיִּהְיוּ מַלְעִיבִים בְּפוֹלוֹס וְכָל־דְּבָרָיו עִצֵּבוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","וַיַּעֲנוּ אֹתָם פּוֹלוֹס וּבַר־נַבָּא בְּאֹמֶץ לֵב וַיֹּאמְרוּ הָיֹה תִהְיוּ אַתֶּם הָרִאשׁוֹנִים לְהַשְׁמִיעֲכֶם אֶת־דְּבַר הָאֱלֹהִים וְאַתֶּם הִנְּכֶם בּוֹזִים לוֹ הֲלֹא מֶרְיְכֶם עָנָה בָכֶם כִּי לֹא נֶחְשָׁבִים אַתֶּם לְהִכָּתֵב לְחַיֵּי עוֹלָם לָכֵן סַבֹּנוּ מִכֶּם וַנִּשַׁע אֶל־הַגּוֹיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","כִּי כֹה צִוָּה עָלֵינוּ הָאָדוֹן לֵאמֹר וּנְתַתִּיךָ לְאוֹר גּוֹיִם לִהְיוֹת לִישׁוּעָה עַד־קְצֵה הָאָרֶץ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","וַיִּשְׁמְעוּ הַגּוֹיִם וַיִּשְׂמְחוּ וַיְהַלְלוּ אֶת־דְּבַר יְהוָֹה וַיַּאֲמִינוּ כֻלָּם אֲשֶׁר נִפְקְדוּ לְחַיֵּי עוֹלָם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","וַיְהִי דְבַר יְהוָֹה נִפְרָץ בְּכָל־הַמָּקוֹם מִסָּבִיב׃ ");
INSERT INTO hebsg_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","רַק הַיְּהוּדִים הִצּוּ וַיָּסִיתוּ אֶת־הַנָּשִׁים הַיְקָרוֹת וְיִרְאוֹת יְהוָֹה וְאֶת־רָאשֵׁי הָעִיר לִקְצָף־קֶצֶף עַל־פּוֹלוֹס וְעַל־בַּר־נַבָּא וַיְגָרְשׁוּם מִגֵּו גְּבוּלָם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","וְהֵם נִעֲרוּ אֶת־אֲבַק רַגְלֵיהֶם עֲלֵיהֶם וַיֵּלְכוּ לְאִיקָנְיוֹן׃ ");
INSERT INTO hebsg_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","וְהַתַּלְמִידִים נִמְלְאוּ שִׂמְחָה וְרוּחַ הַקֹּדֶשׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","וַיְהִי בְּאִיקָנְיוֹן וַיָּבֹאוּ שְׁנֵיהֶם אֶל־בֵּית־הַכְּנֵסֶת אֲשֶׁר לַיְּהוּדִים וַיַּפְלִיאוּ לְלַמֵּד עַד כִּי־הָמוֹן רַב מִן־הַיְּהוּדִים וּמִן־הַיְּוָנִים נֶאֶמְנוּ וְהֶאֱמִינוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","רַק הַיְּהוּדִים אֲשֶׁר לֹא הָיוּ מַאֲמִינִים מָסְכוּ רֹגֶז וְכַעַס בְּלֵב הַגּוֹיִם עַל־הָאַחִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","וְהֵם הֶאֱרִיכוּ בַּמָּקוֹם הַזֶּה וַיְדַבְּרוּ בְּאֹמֶץ לֵב בְּשֵׁם יְהוָֹה הַמֵּעִיד עַל־דְּבַר חַסְדּוֹ וַיִּתֵּן אֹתוֹת וּמוֹפְתִים בְּיָדָם לַעֲשׁתָם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","וַהֲמוֹן הָעִיר חָלַק לִבָּם וַיֵּחָצוּ וַיְהִי הַחֵצִי אַחֲרֵי הַיְּהוּדִים וְהַחֵצִי אַחֲרֵי הַשְּׁלִיחִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","אָז נוֹסְדוּ יַחַד הַגּוֹיִם וְהַיְּהוּדִים עִם־רָאשֵׁיהֶם וַיִּתְנַכְּלוּ לְהַבְזוֹתָם וּלְסָקְלָם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","וַיִּגָּלֶה לָהֶם הַדָּבָר וַיִּמְלְטוּ לְעָרֵי לוּקוֹנְיָא אֶל־לוּסְטְרָא וְאֶל־דַּרְבִי וּסְבִיבוֹתֵיהֶן׃ ");
INSERT INTO hebsg_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","וַיְבַשְּׂרוּ שָׁמָּה אֶת־דְּבַר הַבְּשׁרָה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","וְשָׁם בְּלוּסְטְרָא נִמְצָא אִישׁ נְכֵה רַגְלָיִם פִּסֵּחַ ישֵׁב מִיּוֹם הִוָּלְדוֹ וְלֹא־יָדַע לֶכֶת מֵעוֹדוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","וַיִּשְׁמַע אֶת־פּוֹלוֹס בְּדַבְּרוֹ וְהוּא הִבִּיט עָלָיו וַיֵּדַע כִּי הוּא מַאֲמִין וְכָשֵׁר לְהִוָּשֵׁעַ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","וַיִּשָּׂא אֶת־קוֹלוֹ וַיִּקְרָא קוּם וַעֲמֹד קוֹמְמִיוּת עַל־רַגְלֶיךָ וַיְקַפֵּץ וַיָּקָם וַיִּתְהַלָּךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","כִּרְאוֹת הֲמוֹן הָעָם אֶת־מַעֲשֶׂה פוֹלוֹס וַיָּרִימוּ קוֹלָם וַיֹּאמְרוּ בְּלָשׁוֹן לוּקוֹנִית אָכֵן הִדַּמּוּ הָאֱלֹהִים לִבְנֵי־הָאָדָם וַיֵּרְדוּ אֵלֵינוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","וַיִּקְרְאוּ לְבַר־נַבָּא בֵּל וּלְפוֹלוֹס קָרְאוּ הֶרְמִיס בַּאֲשֶׁר הוּא רֹאשׁ הַמְדַבְּרִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","וְכֹהֵן בֵּית־בֵּל אֲשֶׁר נֹכַח הָעִיר הֵבִיא פָּרִים וַעֲטָרוֹת לִפְנֵי הַשַּׁעַר וַיְבַקֵּשׁ הוּא וַהֲמוֹן הָעָם לִזְבֹּחַ לָהֶם זֶבַח׃ ");
INSERT INTO hebsg_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","כִּשְׁמֹעַ זֹאת בַּר־נַבָּא וּפוֹלוֹס הַשְּׁלִיחִים קָרְעוּ בִגְדֵיהֶם וַיָּרוּצוּ אֶל־בֵּינוֹת הָעָם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","וַיִּצְעֲקוּ וַיֹּאמְרוּ אַתֶּם אֲנָשִׁים לָמָּה תַעֲשׂוּ כָזֹאת הֲלֹא גַּם־אֲנַחְנוּ בְּנֵי־אָדָם כְּמוֹכֶם תְּכוּנָה אַחַת לְכֻלָּנוּ וַאֲנַחְנוּ מְלַמְּדִים אֶתְכֶם אֶת־דִּבְרֵי הַמַּלְאֲכוּת לְמַעַן תִּנָּזְרוּ מֵאַחֲרֵי לֹא־אֱלֹהִים אֵלֶּה וּדְבַקְתֶּם בֵּאלֹהִים חַיִּים עֹשֶׂה שָׁמַיִם וָאָרֶץ וְאֶת־הַיָּם וְאֶת־כָּל־אֲשֶׁר־בָּם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","וַאֲשֶׁר בִּימֵי קֶדֶם הִנִּיחַ לְכָל־הַגּוֹיִם לָלֶכֶת בְּדַרְכֵיהֶם אֲשֶׁר בָּחָרוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","אַף כִּי־לֹא מָנַע עֵדְוֹתָיו כִּי טוֹב הוּא בְּתִתּוֹ לָכֶם מְטַר אַרְצְכֶם מִן־הַשָּׁמַיִם וּשְׁנוֹת רָב־תְּבוּאוֹת לְמַלֵּא נַפְשֹׁתֵיכֶם מִחְיָה וְשִׂמְחָה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","וְאַף גַּם־בְּדַבְּרָם כָּזֹאת הָיְתָה יְגִיעָתָם רַבָּה לְהַשְׁקִיט אֶת־הֲמוֹן הָעָם מִזְּבֹחַ לָהֶם זָבַח׃ ");
INSERT INTO hebsg_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","וְהִנֵּה אֲנָשִׁים יְהוּדִים בָּאוּ מֵאַנְטְיוֹכְיָא וּמֵאִיקָנְיוֹן וַיַּדִּיחוּ אֶת־הֲמוֹן הָעָם וַיִּרְגְּמוּ אֶת־פּוֹלוֹס בָּאֲבָנִים וַיִּשְׁמְטוּהוּ אֶל־מִחוּץ לָעִיר כִּי אָמְרוּ מֵת הוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","וַיִּהְיוּ הַתַּלְמִידִים עֹטְרִים אֵלָיו וַיָּקָם וַיָּשָׁב הָעִירָה וּבְיוֹם הַמָּחֳרָת יָצָא עִם־בַּר־נַבָּא וַיֵּלֶךְ לְדַרְבִי׃ ");
INSERT INTO hebsg_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","וַיְבַשְּׂרוּ בָּעִיר הַהִיא אֶת־הַבְּשׁרָה וַיַּעֲשׂוּ תַלְמִידִים הַרְבֵּה וְאַחֲרֵי־כֵן שָׁבוּ אֶל־לוּסְטְרָא וְאִיקָנְיוֹן וְאַנְטְיוֹכְיָא׃ ");
INSERT INTO hebsg_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","וַיְאַמְּצוּ שָׁם אֶת־לֵב הַתַּלְמִידִים וַיַּזְהִירוּם לַעֲמֹד בֶּאֱמוּנָתָם וּלְהַאֲמִין כִּי רַק־בְּדֵי עָמָל וּתְלָאָה זֶה בֹאנֵנוּ אֶל־מַלְכוּת הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","וַיִּבְחֲרוּ לָהֶם אֲנָשִׁים זְקֵנִים בְּכָל־עֵדָה וְעֵדָה וַיִּתְפַּלְּלוּ וַיָּצוּמוּ וַיַּפְקִידוּם בְּיַד הָאָדוֹן אֲשֶׁר הֶאֱמִינוּ־בוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","וְהֵמָּה עָבְרוּ בְּפִיסְדְיָא וַיָּבֹאוּ אֶל־פַּמְפּוּלְיָא׃ ");
INSERT INTO hebsg_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","וַיְדַבְּרוּ אֶת־הַדָּבָר בְּפַרְגִי וַיֵּרְדוּ מִשָּׁם אֶל־אַטַּלְיָא׃ ");
INSERT INTO hebsg_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","וּמִשָּׁם הָלְכוּ דֶרֶךְ־יָם וַיָּבֹאוּ אֶל־אַנְטְיוֹכְיָא אֲשֶׁר שָׁם הָפְקְדוּ בְּחֶסֶד אֱלֹהִים עַל־הַמְּלָאכָה אֲשֶׁר כִּלּוּ לַעֲשׂוֹת עַד־תֻּמָּהּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","וּבְבֹאָם שָׁמָּה אָסְפוּ אֶת־הָעֵדָה וַיְסַפְּרוּ אֶת־כָּל־אֲשֶׁר עָשָׂה לָהֶם הָאֱלֹהִים וְכִי־פָתַח לַגּוֹיִם אֶת־הַשַּׁעַר אֲשֶׁר מַאֲמִינִים יָבֹאוּ בוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","וַיֵּשְׁבוּ עִם־הַתַּלְמִידִים מֶשֶׁךְ יָמִים לֹא־מְעָט׃ ");
INSERT INTO hebsg_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","וּמְתֵי מִסְפָּר בָּאוּ מֵאֶרֶץ יְהוּדָה וַיּוֹכִיחוּ אֶת־הָאַחִים אִם־לֹא הִמּוֹל תִּמֹּלוּ כְּמִצְוַת תּוֹרַת משֶׁה לֹא תִּוָּשֵׁעוּן׃ ");
INSERT INTO hebsg_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","וַיִּתְוַכְּחוּ הַרְבֵּה פּוֹלוֹס וּבַר־נַבָּא עִמָּהֵם וַיִּקֶשׁ הָרִיב וַתְּהִי עֲצָתָם עָלֹה יַעֲלוּ פּוֹלוֹס וּבַר־נַבָּא וְאַנְשֵׁי מִסְפָּר אֲחֵרִים יְרוּשָׁלַיְמָה וְהֵבִיאוּ אֶת־דְּבַר הָרִיב עַד־הַשְּׁלִיחִים וְהַזְּקֵנִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","וַתֵּצֵא הָעֵדָה עִמָּם לְשַׁלְּחָם וְהֵמָּה נָסְעוּ דֶרֶךְ פִּינוּקְיָא וְדֶרֶךְ שֹׁמְרוֹן הָלֹךְ וְסַפֵּר אֶת־תְּשׁוּבַת הַגּוֹיִם וַיִּתְּנוּ בְלֵב כָּל־הָאַחִים שִׂמְחָה גְדוֹלָה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","וַיְהִי כְּבֹאָם יְרוּשָׁלַיְמָה וַיְקַבְּלוּ אֹתָם הָעֵדָה וְהַשְּׁלִיחִים וְהַזְּקֵנִים וְהֵם סִפְּרוּ אֶת־הַגְּדֹלוֹת אֲשֶׁר עָשָׂה הָאֱלֹהִים עִמָּהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","וַיָּקוּמוּ אֲחָדִים מֵעֲדַת הַפְּרוּשִׁים אֲשֶׁר גַּם־הֵם הָיוּ מִן־הַמַּאֲמִינִים וַיֹּאמְרוּ אַךְ הִמּוֹל יִמֹּלוּ וְגַם־יְצֻוּוּ לִשְׁמֹר אֶת־תּוֹרַת משֶׁה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","וַיִּקָּהֲלוּ הַשְּׁלִיחִים וְהַזְּקֵנִים לְהִתְיָעֵץ עַל־הַדָּבָר הַזֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","וַיְהִי בִּרְבוֹת דִּבְרֵי הָרִיב וַיָּקָם פֶּטְרוֹס וַיֹאמֶר אֲלֵיהֶם אֲנָשִׁים אַחִים אַתֶּם יְדַעְתֶּם כִּי לִפְנֵי יָמִים רַבִּים בִּי בָּחַר הָאֱלֹהִים מִקִּרְבְּכֶם אֲשֶׁר מִפִּי יִשְׁמְעוּ הַגּוֹיִם אֶת־דְּבַר הַבְּשׂרָה וַיַאֲמִינוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","וְהָאֱלֹהִים יֹדֵעַ הַלְּבָבוֹת הֵקִים עֵדוּת בָּהֶם וַיִּתֵּן אֶת־רוּחַ הַקֹּדֶשׁ גַּם־עֲלֵיהֶם כַּאֲשֶׁר נְתָנוֹ עָלֵינוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","וְלֹא הִבְדִּיל בֵּינֵינוּ וּבֵינֵיהֶם וַיְחַטֵּא אֶת־לִבּוֹתָם עַל־יְדֵי הָאֱמוּנָה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","וְעַתָּה אֵפוֹא מַה־תְּנַסּוּ אֶת־הָאֱלֹהִים לְהָבִיא צַוְּרֵי הַתַּלְמִידִים בָּעֹל אֲשֶׁר גַּם־אֲבוֹתֵינוּ גַּם־אֲנַחְנוּ לֹא יָכֹלְנוּ שְׂאֵתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","אֲבָל מַאֲמִינִים אֲנַחְנוּ כִּי בְחֶסֶד יֵשׁוּעַ הַמָּשִׁיחַ אֲדֹנֵינוּ נִוָּשַׁע גַּם־אֲנַחְנוּ וְגַם־הֵם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","וַיַּחֲרִישׁוּ כָל־הַקָּהָל הַחֲרֵשׁ וְשָׁמֹעַ אֶת־בַּר־נַבָּא וְאֶת־פּוֹלוֹס מְסַפְּרִים כִּי הִפְלִיא הָאֱלֹהִים לַעֲשׂת עַל־יְדֵיהֶם אֶת־הָאֹתוֹת וְאֶת־הַמּוֹפְתִים בְּקֶרֶב הַגּוֹיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","הֵם כִּלּוּ לְסַפֵּר וַיַּחֲרִישׁוּ וְיַעֲקֹב עָנָה וַיֹּאמַר אֲנָשִׁים אַחִים שִׁמְעוּ לִי׃ ");
INSERT INTO hebsg_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","כֹּה סִפֵּר שִׁמְעוֹן אֵיךְ לְמַבָּרִאשׁוֹנָה פָּקַד הָאֱלֹהִים אֶת־הַגּוֹיִם לָקַחַת לוֹ מִקִּרְבָּם עָם לִשְׁמוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","וְעֵדִים הֵם לַדְּבָרִים הָאֵלֶּה דִּבְרֵי הַנְּבִיאִים כַּכָּתוּב׃ ");
INSERT INTO hebsg_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","אַחֲרֵי זֹאת אָשׁוּב וְאָקִים אֶת־סֻכַּת דָּוִד הַנֹּפֶלֶת וַהֲרִיסֹתֶיהָ אָקִים וּבְנִיתִיהָ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","לְמַעַן יִדְרְשׁוּ אֶת־יְהוָֹה שְׁאֵרִית אָדָם וְכָל־הַגּוֹיִם אֲשֶׁר נִקְרָא שְׁמִי עֲלֵיהֶם נְאֻם־יְהוָֹה עֹשֶׂה כָל־אֵלֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","נוֹדָעִים לֵאלֹהִים מֵעוֹלָם כָּל־מַעֲשָׂיו׃ ");
INSERT INTO hebsg_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","עַל־כֵּן חָרַצְתִּי כִּי אֵין לְהַפְחִיד אֶת־הַגּוֹיִים הַשָּׁבִים וּבָאִים אֶל־הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","כִּי אִם־כָּתֹב לָהֶם אֲשֶׁר יִבָּדְלוּ מִשִּׁקּוּצֵי הָאֱלִילִים וּמִן־נִאֻפִים וּמִן־הַנֶּחֱנָק וּמִן־הַדָּם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","כִּי יֵשׁ לְמשֶׁה מֵאָז וְעַד־הַיּוֹם קֹרְאֵי שְׁמוֹ בְּכָל־עִיר וָעִיר וְהוּא נִקְרָא בְּבָתֵּי־הַכְּנֵסֶת בְּכָל־שַׁבָּת וְשַׁבָּת׃ ");
INSERT INTO hebsg_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","וַיִּישַׁר בְּעֵינֵי הַשְּׁלִיחִים וְהַזְּקֵנִים וְכָל־הָעֵדָה לִבְחֹר מֵהֶם אֲנָשִׁים לְשָׁלְחָם אֶל־אַנְטְיוֹכְיָא עִם־פּוֹלוֹס וְעִם־בַּר־נַבָּא אֶת־יְהוּדָה הַמְכֻנֶּה בַּר־שַׁבָּא וְאֶת־סִילָא נְשֻׂאֵי פָנִים בְּתוֹךְ הָאַחִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","וַיִּכְתְּבוּ סֵפֶר וְנָתֹן עַל־יָדָם לֵאמֹר אֲנַחְנוּ הַשְּׁלִיחִים וְזִקְנֵי הָאַחִים הִנְנוּ פֹקְדִים לְשָׁלוֹם אֶת־הָאַחִים מִבֵּין־הַגּוֹיִם אֲשֶׁר בְּאַנְטְיוֹכְיָא וּבְסוּרְיָא וּבְקִילִיקְיָא׃ ");
INSERT INTO hebsg_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","שָׁמֹעַ שָׁמַעְנוּ כִּי מְתֵי מִסְפָּר יָצְאוּ מִקִּרְבֵּנוּ אֲלֵיכֶם וְהֵם מַשְׁגִּים אֶתְכֶם וְאֶת־לִבְּכֶם יְסַכְסְכוּ בְּאָמְרָם לָכֶם לְהִמּוֹל וְלִשְׁמֹר אֶת־הַתּוֹרָה אֲשֶׁר לֹא צִוִּינוּ אֹתָם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","לָכֵן יָעַצְנוּ כֻלָּנוּ לֵב אֶחָד לִבְחֹר אֲנָשִׁים לְשָׁלְחָם אֲלֵיכֶם עִם־אֲהוּבֵינוּ עִם־בַּר־נַבָּא וּפוֹלוֹס׃ ");
INSERT INTO hebsg_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","אֲנָשִׁים אֲשֶׁר נָתְנוּ אֶת־נַפְשָׁם בְּעַד־שֵׁם אֲדֹנֵינוּ יֵשׁוּעַ הַמָּשִׁיח׃ ");
INSERT INTO hebsg_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","לָכֵן שָׁלַחְנוּ אֶת־יְהוּדָה וְאֶת־סִילָא אֲשֶׁר בְּמוֹ־פִיהֶם יַגִּידוּ לָכֶם כָּזֹאת׃ ");
INSERT INTO hebsg_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","כִּי טוֹב לִפְנֵי רוּחַ הַקֹּדֶשׁ וְכֵן לְפָנֵינוּ לִבְלִי הַכְבֵּד עֲלֵיכֶם עוֹד מַשָּׂא בִּלְתִּי אִם אֶת־הַחֻקִּים הָאֵלֶה לְבַדָּם אֲשֶׁר לֹא יוּכְלוּן לַעֲבֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","חִדְלוּ לָכֶם מִזִּבְחֵי אֱלִילִים וּמִן־הַדָּם וּמִן־הַנֶּחֱנָק וּמִן־נִאֻפִים אִם־מֵאֵלֶּה תִּשָּׁמֵרוּ וִהְיִיתֶם עֹשֵׂי טוֹב וְשָׁלוֹם לָכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","וְהָאֲנָשִׁים שֻׁלְּחוּ וְהֵם בָּאוּ אֶל־אַנְטְיוֹכְיָא וַיַּאַסְפוּ אֶת־הָעָם וַיִּתְנוּ לָהֶם אֶת־הַסֵּפֶר׃ ");
INSERT INTO hebsg_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","וַיְהִי בְּקָרְאָם בּוֹ וַיִּשְׂמְחוּ כִּי־נֻחָמוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","וִיהוּדָה וְסִילָא אֲשֶׁר הָיוּ גַם־הֵם מִן־הַנְּבִיאִים הוֹכִיחוּ אֶת־הָאַחִים בְּרֹב דְּבָרִים וַיְאַמְּצוּם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","וְכִמְלֹאת יְמֵי שִׁבְתָּם שָׁם שֻׁלְּחוּ מֵעִם־הָאַחִים בְּשָׁלוֹם לָשׁוּב אֶל־אֵלֶּה אֲשֶׁר שְׁלָחוּם אֲלֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","וַיּוֹאֶל סִלָא לָשֶׁבֶת שָׁם עוֹד׃ ");
INSERT INTO hebsg_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","וּפוֹלוֹס וּבַר־נַבָּא נִשְׁאֲרוּ בְאַנְטְיוֹכְיָא לַמֵּד וְדַבֵּר אֶת־דְּבַר־יְהוָֹה הֵם וְעוֹד אֲחֵרִים יַחְדָּו׃ ");
INSERT INTO hebsg_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","וַיְהִי אַחֲרֵי יָמִים מִסְפָּר וַיֹּאמֶר פּוֹלוֹס אֶל־בַּר־נַבָּא הָבָה וְנָשׁוּבָה וּבָאנוּ אֶל־אַחֵינוּ בְּכָל־הֶעָרִים אֲשֶׁר הֵבֵאנוּ שָׁם אֶת־דְּבַר יְהוָֹה וְנִרְאֶה מָה אִתָּם וְנֵדָעָה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","וַיְבַקֵּשׁ בַּר־נַבָּא לָקַחַת עִמָּהֵם גַּם אֶת־יוֹחָנָן הַמְכֻנֶּה מַרְקוֹס׃ ");
INSERT INTO hebsg_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","אֶפֶס כִּי פּוֹלוֹס כִּהָה בוֹ בְּאָמְרוֹ לֹא־יִתָּכֵן לָשׁוּב לָקַחַת עִמָּהֵם אִישׁ אֲשֶׁר נִפְרַד מֵעִמָּם בְּפַמְפּוּלְיָא וְלֹא הָלַךְ אִתָּם לַמְּלָאכָה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","וַיִּתְעַבְּרוּ אִישׁ בְּאָחִיו וַיִּתְפָּרְדוּ וַיִּקַּח בַּר־נַבָּא אֶת־מַרְקוֹס וַיִּסַּע בָּאֳנִיָּה אֶל־קַפְרוֹס׃ ");
INSERT INTO hebsg_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","וּפוֹלוֹס לָקַח־לוֹ אֶת־סִילָא וּבָרוּךְ לְחֶסֶד יְהוָֹה מֵאֵת הָאַחִים וַיִּסַּע וַיֵּלַךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","וַיַּעֲבֹר בְּסוּרְיָא וּבְקִילִיקְיָא וַיְאַמֵּץ אֶת־הָעֵדוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","וַיָּבֹא גַּם אֶל־דַּרְבִי וְאֶל־לוּסְטְרָא וְהִנֵּה־שָׁם תַּלְמִיד אֶחָד וּשְׁמוֹ טִימוֹתִיּוּס בֶּן־אִשָּׁה יְהוּדִית מַאֲמֶנֶת וְאָבִיו יְוָנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","וַיְהִי רְצוּי הָאַחִים בְּלוּסְטְרָא וּבְאִיקָנְיוֹן וַיְשַׁבְּחוּהוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","וַיִּישַׁר בְּעֵינֵי פוֹלוֹס לְהֹלִיכֵהוּ עִמּוֹ בְּדַרְכּוֹ לְמַסָּעָיו וַיִּקַּח וַיָּמָל אֹתוֹ לְמַעַן הַיְּהוּדִים אֲשֶׁר בַּמְּקֹמוֹת הָהֵם יַעַן כֻּלָּם יָדְעוּ אֶת־אָבִיו כִּי יְוָנִי הוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","וּבְכָל־מְקוֹם בֹּאָם הוֹרוּ לָהֶם לְקַבֵּל עֲלֵיהֶם רַק־אֶת־הַמִּצְוֹת אֲשֶׁר קִיְּמוּ הַשְּׁלִיחִים וְהַזְּקֵנִים בִּירוּשָׁלָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","וַתִּתְחַזַּקְנָה הָעֵדוֹת בֶּאֱמוּנָה לְהַאֲמִין וַיִּרֶב מִסְפָּרָן הָלֹךְ וָרָב מִיּוֹם אֶל־יוֹם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","וַיַּעַבְרוּ בִפְרוּגְיָא וּבְאֶרֶץ גָּלַטְיָא כִּי הֱנִיאָם רוּחַ הַקֹּדֶשׁ מִדַּבֵּר אֶת־הַדָּבָר בְּאַסְיָא׃ ");
INSERT INTO hebsg_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","וְהֵם בָּאוּ עַד־מוּסְיָא וַיְנַסּוּ לַעֲשׂוֹת דַּרְכָּם אֶל־בִּיתוּנְיָא וְלֹא־נְתָנָם רוּחַ יֵשׁוּעַ לַעֲבֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","וַיִּטּוּי מִמּוּסְיָא וַיֵּרְדוּ אֶל־טְרוֹאָס׃ ");
INSERT INTO hebsg_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","וְאֶל־פּוֹלוֹס נִרְאָה חָזוֹן לָיְלָה וַיַּרְא אִישׁ מוּקְדוֹן עֹמֵד לְפָנָיו מְבַקֵּשׁ וְאֹמֵר עֲבָר־נָא אֶל־מַקְדּוֹנְיָא וְעָזְרֵנוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","וְאַחֲרֵי רְאוֹתוֹ אֶת־הֶחָזוֹן הָיָה עִם־לְבָבֵנוּ לְהָחִישׁ בֹּאֵנוּ אֶל־מַקְדּונְיָא בַּאֲשֶׁר הֵיטֵב יָדַעְנוּ כִּי נִקְרֵאנוּ מֵאֱלֹהִים לְבַשֵּׂר שָׁם אֶת־הַבְּשׂוֹרָה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","וַנֵּצֵא אֶת־טְרוֹאַס וַנָּבֹא בָאֲנִיָּה דֶּרֶךְ יְשָׁרָה אֶל־סַמּוֹתְרַקְיָא וּבַיּוֹם הַשֵּׁנִי אֶל־נַפּוֹלִיס׃ ");
INSERT INTO hebsg_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","וּמִשָּׁם אֶל־פִּילִפִּי הָעִיר הָרִאשׁוֹנָה עַל־קְצֵה גְבוּל מַקְדּוֹנְיָא וְרֵאשִׁית מוֹשָׁב לְאַנְשֵׁי שָׂדָי וַנֵּשֶׁב בָּהּ יָמִים מִסְפָּר׃ ");
INSERT INTO hebsg_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","וּבְיוֹם הַשַּׁבָּת יָצָאנוּ אֶת־הַשַּׁעַר עַל־יַד הַנָּהָר אֶל־מְקוֹם זֶה דִמִּינוּ שֶׁשָּׁם בֵּית הַתְּפִילָּה וַנֵּשֶׁב וַנְּדַבֵּר אֶל־הַנָּשִׁים אֲשֶׁר הִתְאַסְּפוּ שָׁמָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","וְאִשָּׁה יִרְאַת־אֱלֹהִים לוּדְיָא שְׁמָהּ רֹכֶלֶת בְּאַרְגָּמָן מֵעִיר תִּאֲטִירָא הִיא הִקְשִׁיבָה וַתִּשְׁמָע וַיהוָֹה פָּתַח אֶת־לִבָּהּ לְהַקְשִׁיב אֶל־דִּבְרֵי פוֹלוֹס׃ ");
INSERT INTO hebsg_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","וַיְהִי כִּי נִטְבְּלָה הִיא וּבֵיתָהּ וַתְּדַבֵּר אֵלֵינוּ לֵאמֹר אִם כֹּה תַחְשְׁבֻנִי לְמַאֲמִינָה בָּאָדוֹן בֹּאוּ־נָא אֶל־בֵּיתִי וּשְׁבוּ־בוֹ וַתָּאֶץ בָּנוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","וַיְהִי כְּבֹאֵנוּ לְבֹא בֵית הַתְּפִילָה וַתִּפְגְּשֵׁנוּ שִׁפְחָה וְהִיא רוּחַ לָהּ לְגַלּוֹת נְצֻרוֹת וְעֹשָׂה הוֹן יָקָר לַאדֹנֶיהָ בִּקְסָמֶיהָ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","וַתְּהִי הֹלֶכֶת אַחֲרֵי פוֹלוֹס וְאַחֲרֵינוּ קָרֹא וְאָמֹר הִנֵּה הָאֲנָשִׁים הָאֵלֶּה עֹבְדִים לְאֵל עֶלְיוֹן וְאֶת־דֶּרֶךְ הַיְשׁוּעָה אֶתְכֶם יְלַמֵּדוּן׃ ");
INSERT INTO hebsg_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","כֹּה עָשְׂתָה יָמִים רַבִּים וַיָּקָץ פּוֹלוֹס בַּעֲשׂתָהּ כָּזֹאת וַיִּפֶן וַיֹּאמֶר אֶל־הָרוּחַ בְּשֵׁם יֵשׁוּעַ הַמָּשִׁיחַ אֲנִי מְצַוְּךָ לָצֵאת מִקִּרְבָּהּ וַיֵּצֵא הָרוּחַ כְּרָגַע׃ ");
INSERT INTO hebsg_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","כִּרְאוֹת אֲדֹנֶיהָ כִּי תוֹחֶלֶת הוֹנָם אָבָדָה וַיִּתְפְּשׂוּ אֶת־פּוֹלוֹס וְאֶת־סִילָא וַיִּמְשְׁכוּם אֶל־פְּקוּדוֹת הָעִיר הַשָּׁעְרָה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","וַיִתְנַהֲגוּם לִפְנֵי הָרָאשִׁים וַיֹּאמְרוּ הָאֲנָשִׁים הָאֵלֶּה מְתַעְתְּעִים אֶת־עִירֵנוּ כִּי יְהוּדִים הֵם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","לַמֵּד יְלַמְּדוּ דִבְרֵי־דָת אֲשֶׁר לֹא כְדָתֵינוּ לַעֲשׂוֹתָם כִּי אֲנַחְנוּ רוֹמִיִּים אֲנָחְנוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","וַיָּקָם הֲמוֹן הָעָם עֲלֵיהֶם וְהָרָאשִׁים קָרְעוּ אֶת־בִּגְדֵהֶם מֵעֲלֵיהֶם וַיְצַוּוּ לְיַסְּרָם בַּשּׁוֹטִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","וְאַחֲרֵי הַכּוֹת אֹתָם מַכּוֹת רַבּוֹת הִשְׁלִיכֻם אֶל־בֵּית הַכֶּלֶא וּפְקִיד הַכֶּלֶא צֻוָּה הַחֲזֵק עֲלֵיהֶם מִשְׁמָר׃ ");
INSERT INTO hebsg_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","וְהוּא אַחֲרֵי צֻוֹּתוֹ כֵּן הֶחְבִּיאָם בְּמַחֲבֹאֵי הַכֶּלֶא וַיָּשֶׂם רַגְלֵיהֶם בַּסָּד׃ ");
INSERT INTO hebsg_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","וַיִּתְפַּלְלוּ פּוֹלוֹס וְסִילָא בַּחֲצוֹת הַלָּיְלָה וַיָּשִׁירוּ לֵאלֹהִים וַיִּשְׁמְעוּ לָהֶם הָאֲסִירִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","וַיְהִי פִתְאֹם רַעַשׁ גָּדוֹל עַד כִּי נָעוּ מוֹסְדֵי בֵית הַכֶּלֶא וּפִתְאֹם נִפְתְּחוּ כָל־הַדְּלָתוֹת וַאֲסוּרֵי הָאֲסִירִים נָמָסּוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","וּפְקִיד הַכֶּלֶא נֵעוֹר נִבְהָל מִשְּׁנָתוֹ וַיַּרְא אֶת־הַדְּלָתוֹת כֻּלָּן וְהֵנָּה פְּתֻחוֹת וַיִּשְׁלֹף חֶרֶב לִסְפּוֹת אֶת־נַפְשׁוֹ בְּחָשְׁבוֹ כִּי הָאֲסִירִים נִמְלָטוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","וַיִשָּׂא פוֹלוֹס אֶת־קוֹלוֹ וַיִּקְרָא חֲדָל אַל־תַּעַשׂ לְךָ מְאוּמָה רָע כִּי הִנֵּה אֲנַחְנוּ פֹּה כֻּלָּנוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","וַיְצַו לְהָבִיא נֵר לְהָאֶר־לוֹ וַיְהִי נֶחְפָּז לָבֹא אֶל־הַבַּיִת פְּנִימָה וְהוּא חָרֵד וּמַרְעִיד וַיִּפֹּל לְרַגְלֵי פוֹלוֹס וְסִילָא׃ ");
INSERT INTO hebsg_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","וַיּוֹצִיאֵם וַיֹּאמַר רַבּוֹתַי מָה־אֶעֱשֶׂה לְהוֹשִׁיעַ אֶת־נַפְשִׁי׃ ");
INSERT INTO hebsg_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","וְהֵם אָמְרוּ הַאֲמִינָה בָּאָדוֹן יֵשׁוּעַ הַמָּשִׁיחַ וְתִוָּשַׁע נַפְשְׁךָ וְנֶפֶשׁ בֵּיתֶךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","וַיַּגִּידוּ־לוֹ אֶת־דְּבַר יְהוָֹה וּלְכָל־אֲשֶׁר־אִתּוֹ בְּבֵיתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","וַיִּקָּחֵם אֵלָיו בָּעֵת הַזֹּאת בְּעוֹד לַיְלָה וַיִּרְחַץ אֶת־פִּצְעֵיהֶם וַיִּטָּבֵל הוּא וְכָל־אֲשֶׁר־לוֹ מִבְּלִי־בֹשׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","וַיְבִיאֵם אֶת־בֵּיתוֹ וַיַּעֲרֹךְ לִפְנֵיהֶם שֻׁלְחָן וַיִּשְׂמַח הוּא וְכָל־בֵּיתוֹ כִּי הָפַךְ לִבָּם לְהַאֲמִין בֵּאלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","וַּיְהִי כְּאוֹר הַיּוֹם וַיִּשְׁלְחוּ הָרָאשִׁים אֶת־עַבְדֵּי הַפְּקֻדּוֹת לֵאמֹר שַׁלַּח אֶת־הָאֲנָשִׁים הָאֵלֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","וַיַּגֵּד פְּקִיד הַכֶּלֶא אֶת־הַדָּבָר לְפוֹלוֹס הִנֵּה שָׁלְחוּ אֵלַי הָרָאשִׁים לְתִתְּכֶם לָצֵאת מִזֶּה וְעַתָּה צְאוּ וּלְכוּ לְשָׁלוֹם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","וַיֹּאמֶר פּוֹלוֹס אֲלֵיהֶם יַסֹּר יִסְּרוּנוּ בְּלֹא־דִין וּמִשְׁפָּט לְעֵינֵי כֹל אַף כִּי־אַנְשֵׁי רוֹמִי אֲנָחְנוּ וְגַם־הִשְׁלִיכֻנוּ אֶל־הַכֶּלֶא וְעַתָּה אֲנַחְנוּ מוּצָאִים דְּחוּפִים בַּסֵּתֶר לֹא־כֵן הֵם יָבֹאוּ וְהוֹצִיאֻנוּ מִזֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","וַיָּשִׁיבוּ עַבְדֵי הַפְּקֻדּוֹת אֶת־הַדְּבָרִים הָאֵלֶּה אֶל־הָרָאשִׁים וַיִּירָאוּ יַעַן שָׁמְעוּ כִּי אַנְשֵׁי רוֹמִי הֵם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","וַיָּבֹאוּ וַיְרַצּוּם וַיּוֹצִיאוּם וַיְבַקְשׁוּם לַעֲזֹב אֶת־הָעִיר׃ ");
INSERT INTO hebsg_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","וַיֵּצְאוּ מִבֵּית הַכֶּלֶא וַיָּבֹאוּ בֵיתָה לוּדְיָא וְאַחֲרֵי רְאוֹתָם אֶת־הָאַחִים וְדַבְּרָם לָהֶם נִחֻמִּים יָצְאוּ וַיִּסָּעוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","וַיְהִי אַחֲרֵי נָסְעָם בְּאַמְפִפּוֹלִיס וּבְאַפֹּלוֹנְיָא בָּאוּ אֶל־תַּסְלוֹנִיקִי וְשָׁם בֵּית־כְּנֵסֶת לַיְּהוּדִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","וּפוֹלוֹס כַּאֲשֶׁר הִסְכִּין בָּא אֲלֵיהֶם וַיִּתְוַכַּח עִמָּהֶם בְּהָבֵן בַּמִּקְרָא שְׁלֹשֶׁת יְמֵי שַׁבָּתוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","הוּא בֵּאֵר לָהֶם אֶת־הַכְּתוּבִים וַיְבוֹנְנֵם כִּי־כֵן נִגְזָר אֲשֶׁר יְעֻנֶּה הַמָּשִׁיחַ וְיָקוּם מֵעִם הַמֵּתִים וְכִי־זֶה יֵשׁוּעַ אֲשֶׁר בִּשְׁמוֹ אֲנִי קֹרֵא לָכֶם הוּא זֶה הַמָּשִׁיחַ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","וַיַּט לְבַב מִסְפָּר אַחֲרָיו וַיִּדְבְּקוּ בְפוֹלוֹס וּבְסִילָא וְגַם־יְוָנִים רַבִּים אֲשֶׁר יָרְאוּ אֶת־הָאֱלֹהִים וְנָשִׁים נִכְבָּדוֹת בְּמִסְפָּר לֹא־מְעָט׃ ");
INSERT INTO hebsg_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","וַיְקַנְאוּ בָם הַסּוֹרְרִים שֶׁבַּיְהוּדִים וַיְלַקְּטוּ לָהֶם מִסְפַּר אֲנָשִׁים רֵיקִים מִן־הַשְּׁוָקִים וַיִּקְרְאוּ מָלֵא לִהְיוֹת מְהוּמָה בָעִיר וְאָז נָסַבּוּ עַל־בֵּית יָסוֹן וַיָּהִינוּ לְהוֹצִיאָם הַחוּצָה אֶל־הָעָם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","וַיְהִי כִּי לֹא־מְצָאוּם וַיִּסְּחוּ אֶת־יָסוֹן וַאֲחָדִים מִן־הָאַחִים עַד־לִפְנֵי רָאשֵׁי הָעִיר וַיִּקְרָאוּ אֵלֶּה הַמַּרְגִּיזִים אֶת־כָּל־הָאָרֶץ מִקָּצֶה הִנֵּה הֵם בָּאוּ גַּם־הֵנָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","וְיָסוֹן הוּא הַמְאַסֵּף אֹתָם בְּצֵל קֹרָתוֹ וְאֵלֶּה כֻלָּם מַעֲבִרִים עַל־דָּתֵי הַקֵּיסָר וְגַם־כִּי אֹמְרִים יֶשְׁנוֹ מֶלֶךְ אַחֵר וְהוּא יֵשׁוּעַ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","וַיִּהְיוּ מְיָרְאִים אֶת־הָעָם וְאֶת־רָאשֵׁי הָעִיר אֲשֶׁר שָׁמְעוּ אֶת־זֹאת׃ ");
INSERT INTO hebsg_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","וְהֵם לָקְחוּ עֲרֻבָּה מֵאֵת יָסוֹן וּמֵאֵת הָאֲחֵרִים וַיְשַׁלְּחוּם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","וְהָאַחִים הֵחִישׁוּ מִפְלָט לְפוֹלוֹס וְסִילָא לַיְלָה וַיְשַׁלְּחוּם אֶל־בְּרוֹאָה וְהֵם כְּבֹאָם שָׁמָּה בָּאוּ אֶל־בֵּית־הַכְּנֵסֶת אֲשֶׁר לַיְּהוּדִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","וְאֵלֶּה הָיוּ טוֹבִים מִיהוּדֵי תַסְלוֹנִיקִי כִּי לָקְחוּ אֶת־הַדָּבָר בְּלֵב מָלֵא רָצוֹן וַיַּחְקְרוּ בַכְּתוּבִים יוֹם יוֹם לָדַעַת אִם כִּדְבָרָם כֶּן־הוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","וְרַבִּים מֵהֶם הֶאֱמִינוּ וְנָשִׁים גְּבִירוֹת יְוָנִיּוֹת וַאֲנָשִׁים בְּמִסְפָּר לֹא־מְעָט׃ ");
INSERT INTO hebsg_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","כִּשְׁמֹעַ הַיְּהוּדִים בְּתַסְלוֹנִיקִי כִּי גַם־בִּבְרוֹאָה פּוֹלוֹס מַשְׁמִיעַ אֶת־דְּבַר אֱלֹהִים וַיָּבֹאוּ וַיַּצּוּ אֶת־הֲמוֹן הָעָם גַּם־פֹּה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","וְהָאַחִים הֵחִישׁוּ לְמַלֵּט אֶת־פּוֹלוֹס וַיְהִי הוּא הָלַךְ עַד־הַיָּם וְסִילָא וְטִימוֹתִיּוּס נִשְׁאֲרוּ בָזֶה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","וַאֲשֶׁר אָרְחוּ לְחֶבְרָה עִם־פּוֹלוֹס הוֹלִיכֻהוּ עַד אַתִּינַס אֲשֶׁר שָׁם שָׂם פּוֹלוֹס בְּפִיהֶם צָו לְסִילָא וּלְטִימוֹתִיּוֹס כִּי־יָבֹאוּ אֵלָיו עַד־מְהֵרָה וְהֵם שָׁבוּ וַיֵּלֵכוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","עוֹד פּוֹלוֹס מְצַפֶּה לִקְרַאת בֹּאָם בְּאַתִּינַס וְרוּחוֹ הִתְמַרְמַר בְּקִרְבּוֹ מִמַּרְאֵה עֵינָיו כִּי מָלְאָה הָעִיר אֱלִילִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","וַיְדַבֵּר עַל־כָּכָה עִם־הַיְּהוּדִים בְּבֵית־הַכְּנֵסֶת וְעִם־יִרְאֵי אֱלֹהִים וְגַם־בְּשַׁעַר יוֹם יוֹם עִם־כָּל־הַנִּמְצָאִים שָׁמָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","וַיִּתְעָרְבוּ אִתּוֹ גַּם־אֲחָדִים מֵחַכְמֵי בֵּית אַפִּיקוֹרוֹס הַמְכַחֲשִׁים וּמֵחַכְמֵי בֵּית הָאִסְטְוָה הַמַּצְנִיעִים וַיְהִי אֵלֶּה אֹמְרִים לוֹ מַה־לֶּאֱוִיל שְׂפָתַיִם הַזֶּה מָה הוּא אֹמֵר לְהַגִּיד וְאֵלֶּה כְּפִי הַנִּשְׁמָע הוּא מְלַמֵּד דַּעַת אֱלֹהִים זָרִים יַעַן כִּי־בִּשֵּׂר אֶת־יֵשׁוּעַ וְאֶת־תְּחִיַּת הַמֵּתִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","וַיִּקָּחֻהוּ אֶל־הָאַרְיוֹפָגוֹס וַיֹּאמְרוּ מִי־יִתֵּן וְיָדַעְנוּ מַה־הִיא הַתּוֹרָה הַחֲדָשָׁה אֲשֶׁר אַתָּה מְלַמֵּד׃ ");
INSERT INTO hebsg_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","כִּי־דְבָרִים זָרִים אַתָּה קוֹרֵא בְאָזְנֵינוּ עַל־כֵּן אֲנַחְנוּ מְבַקְשִׁים לְדֵעָה מָה הִיא׃ ");
INSERT INTO hebsg_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","וְהָאַתִּינִיִּים כֻּלָּם וְגַם־הַנָּכְרִים הַמִתְגּוֹרְרִים בְּקִרְבָּם הֵם הֵכִינוּ לִבָּם רַק לַחֲדָשׁוֹת אִם־כֹּה לְסַפֵּר אוֹ כֹה לִשְׁמֹעַ מַה־יְסֻפָּר׃ ");
INSERT INTO hebsg_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","וּפוֹלוֹס הָעֳמָד בְּתוֹךְ הָאַרְיוֹפָגוֹס בַּתַּוֶךְ וַיֹּאמַר אַתֶּם אַנְשֵׁי אַתִּינַס רָאֹה רָאִיתִי אֶתְכֶם כִּי לִבְּכֶם עִמָּכֶם בְּכֹל אֲשֶׁר תִּנְהָגוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","כִּי בְּהִתְהַלְּכִי כֹה וְעַל־עֲבֹדֹתֵיכֶם לֵאלֹהֵיכֶם אֲנִי הִתְבֹּנַנְתִּי וָאֵרֶא גַם־מִזְבֵּחַ וְעָלָיו כָּתוּב לֵאלֹהִים לֹא־יְדַעֲנוּהוּ וְהִנֵּה הַלָּז אֲשֶׁר תְּכַבְּדוּן אֹתוֹ וְלֹא תֵדָעוּהוּ אֹתוֹ אֲנִי מוֹדִיעַ אֶתְכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","הָאֱלֹהִים אֲשֶׁר בָּרָא אֶת־הָעוֹלָם וְכֹל אֲשֶׁר־בּוֹ הוּא אֲדֹנֵי הַשָּׁמַיִם וְהָאָרֶץ לֹא יֵשֵׁב בְּמִקְדָּשִׁים אֲשֶׁר עָשׂוּ לוֹ יָדָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","אַף לֹא־יְכַלְכְּלֻהוּ יְדֵי אָדָם כְּמוֹ אִם צֹרֶךְ לְפָנָיו לְמִי וָמִי הֲלֹא הוּא הַנֹּתֵן חַיִּים וּנְשָׁמָה וְהַכֹּל לַכֹּל׃ ");
INSERT INTO hebsg_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","וְהוּא עָשָׂה מִדָּם אֶחָד אֶת־כָּל בְּנֵי־אָדָם לָשֶׁבֶת עַל־כָּל־פְּנֵי הָאֲדָמָה וַיְמֹדֵד מִדַּת יְמֵיהֶם וּלְמוֹשְׁבוֹתֵיהֶם גְּבוּלוֹת הִצִּיב׃ ");
INSERT INTO hebsg_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","לְמַעַן אֲשֶׁר יִדְרְשׁוּ אַחֲרֵי אֱלֹהִים אוּלַי יְמַשְּׁשֻׁהוּ וְיִמְצָאֻהוּ אַף כִּי־רָחוֹק אֵינֶנּוּ מִכָּל־אֶחָד מִמֶּנּוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","כִּי־בוֹ אֲנַחְנוּ חַיִּים מִתְעוֹרְרִים וְהוִֹים כַּאֲשֶׁר גַּם־שֹׁרְרוּ מִכֶּם אֲנָשִׁים כִּי בְּנֵי־אֱלֹהִים אֲנָחְנוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","וְאַף גַּם־בִּהְיוֹתֵנוּ בְנֵי אֱלֹהִים חָלִילָה לָּנוּ מֵחֲשֹׁב כִּי דֹמֶה הָאֱלֹהִים לַזָּהָב לַכֶּסֶף אוֹ לָאָבֶן אוֹ לְתַבְנִית כֹּל מַעֲשֶׂה אָדָם חָרָשׁ וְחשֵׁב׃ ");
INSERT INTO hebsg_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","אֶת־יְמֵי אֵין־דַּעַת הֶעֱבִיר אֵפוֹא אֱלֹהִים וְעַל־כֵּן הוּא מְצַוֶּה אֶת־בְּנֵי הָאָדָם עַתָּה כִּי בֹא יָבֹאוּ אֵלָיו מִכָּל־קְצוֹת הָאָרֶץ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","כִּי הוּא הִקְדִּישׁ יוֹם מוֹעֵד לִשְׁפָּט־בּוֹ תֵבֵל בְּצֶדֶק עַל־יַד אִישׁ אֲשֶׁר בָּחַר בּוֹ וַיִּתְּנֵהוּ נֶאֱמָן לַכֹּל בַּהֲקִיצוֹ אֹתוֹ מֵעִם־הַמֵּתִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","וַיְהִי כְּשָׁמְעָם אֹתוֹ מְדַבֵּר מִקּוּם הַמֵּתִים אֵלֶּה לָעֲגוּ־לוֹ וְאֵלֶּה אָמְרוּ עוֹד נִשְׁמָעֲךָ עַל־כָּכָה שֵׁנִית׃ ");
INSERT INTO hebsg_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","וַיֵּצֵא פוֹלוֹס מִתּוֹכָם וַיֵּלַךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","וּקְצַת אֲנָשִׁים דָּבְקוּ אַחֲרָיו וַיַּאֲמִינוּ וּבֵינֵיהֶם גַּם־דִּיּוֹנוּסְיוֹס אֶחָד מֵהַשֹּׁפְטִים מִן־אַרְיוֹפָגוֹס וְאִשָּׁה אַחַת אֲשֶׁר שְׁמָהּ דָּמָרִיס וְעוֹד אֲחֵרִים עִמָּהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","אַחַר הַדְּבָרִים הָאֵלֶּה עָזַב אֶת־אַתִּינַס וַיָּבֹא אֶל־קוֹרִנְתּוֹס׃ ");
INSERT INTO hebsg_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","וַיִּמְצָא שָׁם אִישׁ יְהוּדִי אֲשֶׁר הָיָה שְׁמוֹ עֲקִילַס וְהוּא יְלִיד פּוֹנְטוֹס וְעַתָּה זֶה מִקָּרוֹב בָּא מֵאִיטַלְיָא עִם־פְּרִיסְקְלָה אִשְׁתּוֹ כִּי מֵאֵת קְלוֹדְיוֹס יָצָא צָו אֶל־כָּל־הַיְּהוּדִים לְהֵעָלוֹת מִקֶּרֶב רוֹמִי וּלְעָזְבָהּ וַיָּבֹא אֲלֵיהֶם אֶל־מְעוֹנָם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","וְיַעַן כִּי הָיוּ בַעֲלֵי מְלָאכָה אַחַת עַל־כֵּן הוֹאִיל לָשֶׁבֶת עִמָּהֶם וַעֲשׂה בַמְּלָאכָה וְהֵם אֹרְגִים מַסֵּכוֹת לְאֹהָלִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","וּבְכָל־שַׁבָּת וְשַׁבָּת דִּבֶּר עִם־הַיְּהוּדִים בְּבֵּת־הַכְּנֵסֶת וַיְלַמֵּד דַּעַת גַּם־אֶת־הַיְּהוּדִים וְגַם־אֶת־הַיְּוָנִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","וַיְהִי כְּבֹא אֵלָיו סִילָא וְטִמוֹתִיּוֹס מִמַּקְדּוֹנְיָא הִתְנַדֵּב פּוֹלוֹס כֻּלּוֹ רַק לִדְבַר הַדָּבָר בְּהַרְאֹתוֹ לַיְּהוּדִים בָּרוּר כִּי יֵשׁוּעַ הוּא הַמָּשִׁיחַ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","וְהֵם כִּי מָרוּ וְגַם־גִּדְּפוּ וַיְנַעֵר הוּא אֶת־חִצְנוֹ וַיֹּאמֶר אֲלֵיהֶם דִּמְכֶם בְּרֹאשְׁכֶם וַאֲנִי נָקִי מִכֶּם אֵלְכָה־לִּי עַתָּה אֶל־הַגּוֹיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","וַיֵּלֵךְ מִשָּׁם וַיָּבֹא בֵּיתָה אִישׁ אֶחָד טִיטוֹס יוּסְטוֹס הָיָה שְׁמוֹ הוּא הָיָה יְרֵא אֱלֹהִים וּבֵיתוֹ אֵצֶל בֵּית־הַכְּנֵסֶת׃ ");
INSERT INTO hebsg_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","וּקרִיסְפּוֹס רֹאשׁ בֵּית־הַכְּנֵסֶת הֶאֱמִין בָּאָדוֹן הוּא וְכָל־בֵּיתוֹ עִמּוֹ וְעוֹד קוֹרִנְתִּים רַבִּים כַּאֲשֶׁר שָׁמְעוּ כֵּן הֶאֱמִינוּ וַיִּטָּבֵלוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","וּדְבַר הָאָדוֹן הָיָה אֶל־פּוֹלוֹס בֶּחָזוֹן לָיְלָה אַל־תִּירָא כִּי אִם־תְּדַבֵּר וְלֹא תֶחֱרָשׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","כִּי־עִמְּךָ אָנֹכִי וְאִישׁ לֹא יִגַּע בְּךָ לְרָעָה כִּי עַם־רָב לִי בָּעִיר הַזֹּאת׃ ");
INSERT INTO hebsg_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","וַיֵּשֵׁב שָׁם שָׁנָה וְשִׁשָּׁה חֳדָשִׁים וַיְלַמֵּד אֹתָם אֶת־דְּבַר הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","וַיְהִי אָז גַּלִּיּוֹן נְצִיב מְדִינַת אֲכַיָּא וְהַיְּהוּדִים כֻּלָּם יַחַד קָמוּ עַל־פּוֹלוֹס וַיַּעֲמִידוּהוּ לִפְנֵי כִסֵּא הַמִּשְׁפָּט׃ ");
INSERT INTO hebsg_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","וַיֹּאמְרוּ הָאִישׁ הַזֶּה מְפַתֶּה אֶת־הָעָם לַעֲבֹד אֶת־הָאֱלֹהִים בַּעֲבֹדָה אֲשֶׁר לֹא כַתּוֹרָה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","וְאוּלָם אַךְ־הוֹאִיל פּוֹלוֹס לִפְתֹּחַ שְׂפָתָיו וְגַלִּיּוֹן הִקְדִּימוֹ וַיֹּאמֶר אֶל־הַיְּהוּדִים לוּ אִם־הָיָה דִין רֶשַׁע אוֹ דְּבַר בְּלִיַּעַל כִּי־אָז נָשָׂאתִי אֶת־פְּנֵיכֶם אַתֶּם הַיְּהוּדִים כַּמִּשְׁפָּט׃ ");
INSERT INTO hebsg_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","אֶפֶס כִּי־רַק בְּתוֹכָחוֹת עַל־מִלִּין עַל־שִׂים שֵׁמוֹת וְעַל־תּוֹרַתְכֶם אַתֶּם נְדוֹנִים הָבוּ לָכֶם עֵצָה אַתֶּם לְבַדְּכֶם לָדַעַת מָה הַטּוֹב וַאֲנִי אֵין נַפְשִׁי לִהְיוֹת שֹׁפֵט עַל־הַדָּבָר הַזֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","וַיְגָרֶשׁ אֹתָם מִלִּפְנֵי כִסֵּא הַמִּשְׁפָּט׃ ");
INSERT INTO hebsg_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","וַיִּתְפְּשׂוּ כֻלָּם אֶת־סוֹסְתְּנִיס רֹאשׁ בֵּית הַכְּנֵסֶת וַיַּכֻּהוּ לִפְנֵי־כִסֵּא הַמִּשְׁפָּט וְגַלִּיוֹן רֹאֶה וַיְהִי כְּלֹא רֹאֶה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","וַיִּתְמַהְמַהּ שָׁם פּוֹלוֹס עוֹד יָמִים רַבִּים אַחַר כֵּן נִפְרַד מֵעִם הָאַחִים וַיֵּשֵׁב בָּאֳנִיָּה לָלֶכֶת אֶל־סוּרְיָא וְהוּא לָקַח עִמּוֹ אֶת־פְּרִיסְקְלָה וְאֶת־עֲקִילַס וַיְגַלַּח אֶת־רֹאשׁוֹ בְּקַנְכְּרַי כִּמְלֹאת יְמֵי נִדְרוֹ אֲשֶׁר נָדָר׃ ");
INSERT INTO hebsg_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","וַיָּבֹאוּ לְאֶפְסוֹס וַיַּנִּיחֵם שָׁם וְהוּא בָא אֶל־בֵּית־הַכְּנֵסֶת וַיְדַבֶּר־שָׁם אֶל־הַיְּהוּדִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","וְהֵם חִלּוּ אֶת־פָּנָיו כִּי יַאֲרִיךְ לָשֶׁבֶת בְּתוֹכָם רַק הוּא לֹא נֵאוֹת לָהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","כִּי אִם־נִפְרַד מֵעִמָּם בְּאָמְרוֹ חַיָּב אֲנִי לָחֹג אֶת־הֶחָג הַבָּא בִּירוּשָׁלַיִם וְאַחֲרֵי־כֵן אָשׁוּבָה אֲלֵיכֶם אִם־יִרְצֶה יְהוָֹה וַיֵּלֶךְ דֶּרֶךְ יָם מֵאֶפְסוֹס׃ ");
INSERT INTO hebsg_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","וַיָּבֹא אֶל־קִסְרִין וַיַּעַל לִפְקֹד אֶת־הָעֵדָה לְשָׁלוֹם וַיָּשָׁב לָרֶדֶת אֶל־אַנְטְיוֹכְיָא׃ ");
INSERT INTO hebsg_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","וַיְהִי שָׁם יָמִים אֲחָדִים וַיֵּצֵא מִשָּׁם וַיַּעֲבֹר הָלֹךְ וְעָבֹר בְּאֶרֶץ גָּלַטְיָא וּפְרוּגְיָא וַיְאַמֵּץ אֶת־כָּל־הַתַּלְמִידִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","וְאִישׁ אֶחָד יְהוּדִי בָּא אֶל־אֶפְסוֹס שְׁמוֹ אַפּוֹלוֹס וַאֲלֶכְסַנְדְּרִיָּא עִיר מוֹלַדְתּוֹ אִישׁ דְּבָרִים וּמָהִיר בַּכְּתוּבִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","הוּא יָדַע אֶת־דֶּרֶךְ הָאָדוֹן וְרוּחוֹ כִּלַהַט יָצָא וַיְדַבֵּר וַיְלַמֵּד הֵיטֵב אֶת־דִּבְרֵי יֵשׁוּעַ רַק הוּא לֹא יָדַע כִּי אִם־טְבִילַת יוֹחָנָן לְבַדָּהּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","וְהוּא הֵחֵל לְהַשְׁמִיעַ דְּבָרוֹ בְּאֹמֶץ לֵב בְּבֵית הַכְּנֵסֶת וַיִּשְׁמְעוּ אֹתוֹ פְּרִיסְקְלָה וַעֲקִילַס וַיְבִיאֻהוּ אֶל־בֵּיתָם וַיְבוֹנְנוּהוּ אֶת־דֶּרֶךְ הָאֱלֹהִים עוֹד יוֹתֵר מְפֹרָשׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","וּבִנְטוֹת לִבּוֹ לָלֶכֶת אֶל־אֲכַיָּא וַיְעוֹרוּהוּ הָאַחִים וַיִּכְתְּבוּ אֶל־הַתַּלְמִידִים לֶאֱסֹף אֹתוֹ אֲלֵיהֶם וְהוּא כְּבֹאוֹ שָׁמָּה עָזַר הַרְבֵּה לַאֲשֶׁר הָפְנוּ לְהַאֲמִין עַל־יְדֵי הֶחָסֶד׃ ");
INSERT INTO hebsg_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","כִּי הוּא גָבַר עַל־הַיְּהוּדִים בִּפְנֵי־כֹל וַיֹּכַח בַּכְּתוּבִים כִּי יֵשׁוּעַ הוּא הַמָּשִׁיחַ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","וַיְהִי בִּהְיוֹת אַפּוֹלוֹס בְּקוֹרִנְתּוֹס וּפוֹלוֹס אַחֲרֵי עָבְרוֹ בָאֲרָצוֹת הָעִלִּיּוֹת בָּא אֶל־אֶפְסוֹס וַיִּמְצָא־שָׁם תַּלְמִידִים אֲחָדִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","וַיֹּאמֶר אֲלֵיהֶם הֲבֹא בָא גַם־רוּחַ הַקֹּדֶשׁ עֲלֵיכֶם כַּאֲשֶׁר הֱיִיתֶם לְמַאֲמִינִים וְהֵם עָנוּהוּ גַּם כִּי־יֵשׁ רוּחַ הַקֹּדֶשׁ אֲנַחְנוּ לֹא שָׁמָעְנוּ עוֹד׃ ");
INSERT INTO hebsg_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","וַיֹּאמַר וְעַל־מָה אֵפוֹא אַתֶּם נִטְבַּלְתֶּם וַיֹּאמְרוּ עַל־הַטְּבִלָה לְיוֹחָנָן׃ ");
INSERT INTO hebsg_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","וַיֹּאמֶר פּוֹלוֹס יוֹחָנָן הִטְבִּיל בִּטְבִילַת הַתְּשׁוּבָה וַיַּגֵּד לָעָם כִּי־הַאֲמֵן יַאֲמִינוּ בְהַלָּז אֲשֶׁר יָבֹא אַחֲרָיו וְהַלָּז הוּא זֶה הַמָּשִׁיחַ יֵשׁוּעַ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","כְּשָׁמְעָם אֶת־זֹאת שָׁבוּ נִטְבְּלוּ עַל־שֵׁם הָאָדוֹן יֵשׁוּעַ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","וּפוֹלוֹס סָמַךְ יָדָיו עֲלֵיהֶם וַיָּנַח עֲלֵיהֶם רוּחַ הַקֹּדֶשׁ וַיְדַבְּרוּ בִלְשֹׁנוֹת וַיִּתְנַבָּאוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","וַיְהִי מִסְפָּרָם כִּשְׁנֵים עָשָׂר אִישׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","וַיָּבֹא אֶל־בֵּית־הַכְנֵסֶת וַיַּגֵּד דְּבָרָיו בְּאֹמֶץ לֵב שְׁלֹשָׁה חֳדָשִׁים בִּנְכֹחוֹת וְשׂוּם שֵׂכֶל עַל־אֹדוֹת מַלְכוּת הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","וַיְהִי כִּי־נִמְצְאוּ בָהֶם אֲחָדִים עַרְלֵי לֵב אֲשֶׁר מֵאָנוּ לְהַאֲמִין וְגַם־טָפְלוּ דָבָר מַר עַל־הַדֶּרֶךְ הַזֶּה לִפְנֵי הָעָם וַיֵּשְׂטְ מֵעֲלֵיהֶם וְגַם־אֶת־הַתַּלְמִידִים הִבְדִּיל מִתּוֹכָם וְהוּא הָיָה מְדַבֵּר יוֹם יוֹם בְּבֵית הַמִּדְרָשׁ אֲשֶׁר לְטוּרְנוּס׃ ");
INSERT INTO hebsg_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","וַיְהִי הוּא עֹשֶׂה כָזֶה שְׁנָתַיִם יָמִים עַד כִּי־שָׁמְעוּ כָּל־יֹשְׁבֵי אַסְיָא אֶת־דְּבַר הָאָדוֹן יֵשׁוּעַ כַּיְּהוּדִים כַּיְּוָנִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","וְהָאֱלֹהִים עָשָׂה נִפְלָאוֹת גְּדוֹלוֹת עַל־יְדֵי פוֹלוֹס׃ ");
INSERT INTO hebsg_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","כִּי גַם־חֲגֹרוֹת וּמִטְפְּחוֹת יֶזַע מֵעַל עוֹר בְּשָׂרוֹ הִנִּיחוּ עַל־הַחוֹלִים וְסָר חָלְיָם וְהָרוּחוֹת הָרָעוֹת מִגַּוָּם גֹּרָשׁוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","וְגַם־הָיוּ אֲנָשִׁים יְהוּדִים מְלַחֲשִׁי מִתְהַלְּכִים בָּאָרֶץ וְהֶם נוֹעֲזוּ לְהַזְכִּיר שֵׁם הָאָדוֹן יֵשׁוּעַ אֶל־אֲשֶׁר רוּחוֹת רָעוֹת נֹאחֲזוּ בְקִרְבָּם בְּקָרְאָם אֲנִי מַשְׁבִּיעֲכֶם בְּשֵׁם יֵשׁוּעַ אֲשֶׁר פּוֹלוֹס יִקְרָאֵהוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","וְהֵם אֲשֶׁר כֹּה עָשׂוּ הֵם הָיוּ שִׁבְעַת בְּנֵי סְקֵוָה יְהוּדִי וְרֹאשׁ כֹּהֲנִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","וַיַּעַן הָרוּחַ הָרָעָה וַיֹּאמֶר אֲלֵיהֶם יָדַעְתִּי אֶת־יֵשׁוּעַ וְאֶת־פּוֹלוֹס אֲנִי מַכִּיר רַק אַתֶּם מִי אַתֶּם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","וַיִּתְנַפֵּל עֲלֵיהֶם הָאִישׁ אֲשֶׁר הָרוּחַ הָרָעָה בְקִרְבּוֹ וַיֶּחֱזַק מֵהֶם וַיַּכְרִיעֵם עַד כִּי־עֵירֻמִּים וְנִמְחָצִים נָסוּ מִן־הַבַּיִת הַהוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","וַיִּוָּדַע הַדָּבָר לְכָל־הַיְּהודִים וְהַיְּוָנִים הַיּוֹשְׁבִים בְּאֶפְסוֹס וּפַחַד נָפַל עַל־כֻּלָם וַיִּגְדַּל שֵׁם הָאָדוֹן יֵשׁוּעַ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","וְגַם רַבִּים מִן־הַמַּאֲמִינִים בָּאוּ לִהִתְוַדּוֹת וּלְגַלּוֹת אֶת־מַעֲשֵׂיהֶם אֲשֶׁר עָשׂוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","וְרַבִּים אֲשֶׁר שָׁעוּ בְהַבְלֵי שָׁוְא הֵבִיאוּ סִפְרֵיהֶם וַיִּשְּׂרְפוּם בָּאֵשׁ לְעֵינֵי־כֹל וַיִּמְנוּ מִסְפַּר שָׁוְיָם וַיְהִי חֲמִישִּׁים אֶלֶף כָּסֶף׃ ");
INSERT INTO hebsg_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","וּדְבַר־יְהוָֹה נִשְׂגַּב עַד־לִמְאֹד וְנַעֲלָה הָלֹךְ וְעָלֹה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","וַיְהִי כִּכְלוֹת הַדְּבָרִים הָאֵלֶּה וַיִּתֵּן פּוֹלוֹס אֶל־לִבּוֹ לְהִתְהַלֵּךְ בְּמַקְדּוֹנְיָא וּבַאֲכַיָּא וּמִשָּׁם וָהָלְאָה עַד־יְרוּשָׁלָיִם וַיֹּאמֶר אַחֲרֵי הֱיוֹתִי שָׁמָּה רָאֹה אֶרְאֶה עוֹד אֶת־רוֹמִי׃ ");
INSERT INTO hebsg_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","וַיִּשְׁלַח שְׁנַיִם נְעָרִים מִמְּשָׁרְתָיו אֶת־טִימוֹתִיּוֹס וְאֶת־אֲרִסְטוֹס לָלֶכֶת לְפָנָיו אֶל־מַקְדּוֹנְיָא וְהוּא אֵחַר עוֹד יְמֵי מִסְפָּר בְּאַסְיָא׃ ");
INSERT INTO hebsg_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","בָּעֵת הַהִיא קָם שָׁאוֹן לֹא־מְעָט עַל־דִּבְרַת דֶּרֶךְ יְהוָֹה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","כִּי אִישׁ אֶחָד דְּמַטְרִיּוֹס שְׁמוֹ חָרַשׁ כֶּסֶף הוּא הָיָה עֹשֶׂה מִקְדְּשֵׁי־כֶסֶף קְטַנִּים בְּתַבְנִית הַמִּקְדָּשׁ לְשֵׁם אַרְטְמִיס וַיְסַבֵּב בָּזֶה לֶחָרָשִׁים מַשְׂכֹּרֶת לֹא־מִצְעָר׃ ");
INSERT INTO hebsg_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","וַיִּקְבֹּץ אֹתָם עִם־עֹזְרֵי מְלַאכְתָּם וַיֹּאמַר אֲנָשִׁים אַתֶּם יְדַעְתֶּם כִּי בַּמְּלָאכָה הַזֹּאת רָכַשְׁנוּ לָנוּ אֶת־לַחְמֵנוּ וְאֶת־טוּבֵנוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","וְהִנֵּה עֵינֵיכֶם רֹאוֹת וְאָזְנֵיכֶם שֹׁמְעוֹת כִּי־לֹא רַק בְּאֶפְסוֹס לְבַדָּהּ כִי אִם־גַּם בְּכַל־אַסְיָא פּוֹלוֹס הַזֶּה מְפַתֶּה הֲמוֹן עַם־רָב לַהֲסִירָם מֵאַחֲרֵי אֱלֹהֵיהֶם כִּי יֹאמַר אָמֹר לֹא־אֱלֹהִים הֵמָּה אֲשֶׁר תַּעֲשֶׂינָה יָדָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","וְעָתָּה הַמְעַט הָרָעָה הַזֹּאת לְבַדָּהּ לְהִלָּקַח מִיָּדֵינוּ הַמְּלָאכָה הַזֹּאת כִּי אִם־עוֹד רָעַת הָרָעוֹת תִּפָּתַח עַל־הַמִּקְדָּשׁ לָאֱלָהוּת הַגְּדוֹלָה אַרְטְמִיס כִּי לְאֶפֶס וּלְאַיִן יֵחָשֵׁב וְיֵקַל כְּבוֹד הוֹדָהּ אֲשֶׁר יְכַבְּדוּהָ כָּל־אַסְיָא וְכָל־יֹשְׁבֵי תֵבֵל׃ ");
INSERT INTO hebsg_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","וַיְהִי כְּשָׁמְעָם אֶת־הַדְּבָרִים הָאֵלֶּה וַיִּמָּלְאוּ חֵמָה וַיִּתְּנוּ קוֹלָם וַיִּקְרָאוּ גְּדוֹלָה אַרְטְמִיס לָעָם בְּאֶפְסוֹס׃ ");
INSERT INTO hebsg_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","וַתֵּהֹם הָעִיר וַתִּמָּלֵא רַעַשׁ גָּדוֹל וְהֵם כֻּלָּם הִשְׂתָּעֲרוּ כְּאִישׁ אֶחָד אֶל־בֵּית־הַמִּשְׂחָק וַיַּחֲזִיקוּ בְגָיוֹס וּבַאֲרִסְטַרְכוֹס אֲנָשִׁים מַקְדּוֹנִים הַהֹלְכִים עִם פּוֹלוֹס לְשָׁמְרוֹ בַדָּרֶךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","וּפוֹלוֹס חָפֵץ לָצֵת אֶל־הָעָם רַק הַתַּלְמִידִים לֹא נְתָנוּהוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","וְגַם־אֲחָדִים רָאשֵׁי עָם מֵאַסְיָא אֲשֶׁר אֵהֲבוּהוּ גַם־הֵם שָׁלְחוּ לוֹ לְהַזְהִירוֹ כִּי יִמָּנַע מֵהֲלֹךְ אֶל־בֵּית־הַמִּשְׂחָק׃ ");
INSERT INTO hebsg_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","וַיְהִי הֵם שֹׁאֲגִים אֵלֶּה זֹאת וַאַחֵרִים אַחֶרֶת כִּי הָיָה הֶהָמוֹן נָבוּךְ וְרֻבָּם גַּם־לֹא יָדְעוּ בְּשֶׁלְּמַה הֵם נִזְעָקוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","וַיּוּבָא מִבֵּינוֹת הָעָם אֲלֶכְסַנְדְּרוֹס כִּי הַיְּהוּדִים שָׂמוּהוּ בְרֹאשָׁם וַיִּשָּׂא אֲלֶכְסֵנְדְּרוֹס אֶת־יָדוֹ לְאוֹת כִּי חָפֵץ הוּא לְהָשִׁיב אֲמָרִים לִפְנֵי הָעָם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","וַיִּוָּדַע לָהֶם כִּי־הוּא יְהוּדִי וַיִּשְׂאוּ כֻלָּם קוֹל חָזָק וּכְמוֹ שְׁתַּיִם שָׁעוֹת קָרְאוּ וְלֹא דָמּוּ גְּדוֹלָה אַרְטְמִיס לָעָם בְּאֶפְסוֹס׃ ");
INSERT INTO hebsg_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","וַיַּהַס סוֹפֵר הָעִיר אֶת־הָעָם וַיֹּאמַר אַתֶּם אַנְשֵׁי אֶפְסוֹס מִי הוּא הָאִישׁ אֲשֶׁר לֹא יֵדַע כִּי הָעִיר אֶפְסוֹס מְשָׁרַת אֶת־אַרְטְמִיס הַגְּדוֹלָה וְאֶת־תַּבְנִיתָהּ אֲשֶׁר נָפְלָה מִן־הַשָּׁמָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","וְהִנֵּה כִּי זֹאת אֱמוּנָה וְאֵין מִי לְהַכְזִיבֶנָּה הֲלֹא יָאֲתָה לָכֶם לִשְׁקֹט מִמְּהוּמָה וּמֵעֲשׂוֹת מְאוּם בְּטֶרֶם תְּחַשֵּׁבוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","כִּי אַתֶּם הֲבֵאתֶם אֶת־הָאֲנָשִׁים הָאֵלֶּה הֵנָּה וְהֵם לֹא בָזְזוּ אֶת־הַמִּקְדָּשׁוֹת וְאַף־לֹא בָזוּ לֵאלָהוּתֵנוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","וְאִם דְּבַר רִיב לִדְמַטְרִיּוֹס וְהֶחָרָשִׁים אֲשֶׁר אִתּוֹ עִם־אִישׁ־מִי הֲלֹא יֵשׁ בְּקִרְבֵּנוּ מִשְׁפָּט וּנְצִיבִים נִצָּבִים עֲלֵינוּ הָבָה יִקְרְאוּ הֵם לְבַדָּם עֲלֵיהֶם לַשֹּׁפְטִים וּשְׁפָטוּם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","וְאִם עוֹד לָכֶם כֻּלְּכֶם לְבַקֵּשׁ דָּבָר הִנֵּה בְּהִתְאַסֵּף כָּל־הָעָם לְפִי חֹק יֵצֵא מִשְׁפַּטְכֶם וְדִינְכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","כִּי הַיּוֹם אֲנַחְנוּ נְתֻנִים בְּיִרְאָה פֶּן־יִתְגֹּלֵל עָלֵינוּ עֲוֹן מֶרֶד לְהַבְאִישֵׁנוּ בִּגְלַל הַיּוֹם הַזֶּה מַה־לָּנוּ לָגֹל מֵעָלֵינוּ חַטָּאת אֲשֶׁר לֹא חָטָאנוּ בִּלְתִּי אִם הַמְּהוּמָה הַזֹּאת׃ ");
INSERT INTO hebsg_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","וּכְכַלֹּאתוֹ לְדַבֵּר שִׁלַּח אֶת־הַקָּהָל׃ ");
INSERT INTO hebsg_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","וַיְהִי אַחֲרֵי הַמְּהוּמָה וּפוֹלוֹס אָסַף אֶת־הַתַּלְמִידִים וַיְדַבֵּר עַל־לִבָּם וּבְבִרְכָתוֹ אֹתָם לְשָׁלוֹם נִפְרַד מֵהֶם וַיֵּצֵא לָלֶכֶת אֶל־מַקְדּוֹנְיָא׃ ");
INSERT INTO hebsg_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","וְאַחֲרֵי עָבְרוֹ בַמְּדִינוֹת הָהֵן וְאַמְּצוֹ אֶת־לִבּוֹתָם בְּמִדַּבְּרֹתָיו הָרַבִּים בָּא אֶל־אֶרֶץ יָוָן׃ ");
INSERT INTO hebsg_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","וַיְהִי אַחֲרֵי שִׁבְתּוֹ שָׁם שְׁלֹשָׁה חֳדָשִׁים וַתִּשָּׂאֵהוּ רוּחוֹ לָלֶכֶת אֶל־סוּרְיָא רַק מֵאֲשֶׁר טָמְנוּ לוֹ הַיְּהוּדִים מוֹקֵשׁ עַל־כֵּן נוֹעַץ לָשׁוּב דֶּרֶךְ מַקְדּוֹנְיָא׃ ");
INSERT INTO hebsg_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","וַיִּלָּווּ אֵלָיו לְלַוֹּתוֹ בַדֶּרֶךְ עַד־אַסְיָא סוֹפַטְרוֹס בֶּן־פּוּרֹס הַבְּרוֹאִי וּמֵהַתַּסְלְנִיקִים אֲרִסְטַרְכוֹס וּסְקוֹנְדוֹס וְגָיוֹס הַדַּרְבִי וְטִימוֹתִיּוֹס וּמֵאַסְיָא טוּכִיקוֹס וּטְרוֹפִימוֹס׃ ");
INSERT INTO hebsg_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","וְאֵלֶּה הָלְכוּ לְפָנֵינוּ וַיְחַכּוּ לָנוּ בִּטְרוֹאַס עַד־בֹּאֵנוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","וַאֲנַחְנוּ עָבַרְנוּ מִפִּילִפִּי בָּאֳנִיָּה אַחֲרֵי תֹם חַג־הַמַּצּוֹת וַנְּהִי בַּדֶּרֶךְ חֲמִישָּׁה יָמִים עַד־בֹּאֵנוּ אֲלֵיהֶם אֶל־טְרוֹאַס וַנֵּשֶׁב־שָׁם שִׁבְעַת יָמִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","בַּיּוֹם הָרִאשׁוֹן בַּשַּׁבָּת וַאֲנַחְנוּ נֶאֱסָפִים לִפְרֹס אֶת־הַלֶּחֶם וּפוֹלוֹס נָשָׂא מִדַּבְּרֹתָיו אֲלֵיהֶם יַעַן הָיָה עִם־לִבּוֹ לָלֶכֶת מֵהֶם בְּיוֹם הַמָּחֳרָת וַיֶּרֶב מִדַּבְּרֹתָיו עַד חֲצִי הַלָּיְלָה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","וְנֵרוֹת רַבִּים הֵאִירוּ בַּעֲלִיָּה אֲשֶׁר שָׁם הָיִינוּ נֶאֱסָפִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","וְהִנֵּה נַעַר אֶחָד וּשְׁמוֹ אַבְטוּכוֹס בְּשִׁבְתּוֹ עַל־סַף הַחַלּוֹן בְּהַאֲרִיךְ פּוֹלוֹס לְהַטִּיף אִמְרוֹתָיו נָם שְׁנָתוֹ וַתִּתְקְפֵהוּ הַשֵּׁנָה וַיִּפֹּל אַרְצָה מִן־הָעֲלִיָּה אֲשֶׁר גֹּבַהּ לָהּ שָׁלֹשׁ קוֹמוֹת וַיִּשָּׂאֻהוּ וְהוּא מֵת׃ ");
INSERT INTO hebsg_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","וַיֵּרֶד פּוֹלוֹס וַיִּתְמוֹדֵד עָלָיו וַיַּחֲזֶק־בּוֹ וַיֹּאמַר אַל־נָא תִּצְעֲקוּ כִּי עוֹד נִשְׁמָתוֹ בּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","וַיָּשָׁב וַיַּעַל וַיִּפְרֹס אֶת־הַלֶּחֶם וַיֹּאכַל וַיֶּרֶב לְדַבֵּר אִתָּם עַד־עֲלוֹת הַשַּׁחַר וַיֵּלַךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","וְאֶת־הַנַּעַר הֶעֱלוּ חָי וַיִּתְנַחֲמוּ בוֹ לֹא־מְעָט׃ ");
INSERT INTO hebsg_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","וַאֲנַחְנוּ קִדַּמְנוּ לָרֶדֶת בָּאֳנִיָּה וַנַּעֲבֹר אֶל־אַסּוֹס לִכְנוֹס שָׁם אֵלֵינוּ אֶת־פּוֹלוֹס כִּי־כֵן צִוָּה וְהוא אִוָּה לָבֹא שָׁם רַגְלִי דֶּרֶךְ הַיַּבָּשָׁה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","וַיִּפְגֹּשׁ אֹתָנוּ בְּאַסּוֹס וַנִּקַּח אֹתוֹ אֵלֵינוּ וַנָּבֹא אֶל־מִיטוּלִינִי׃ ");
INSERT INTO hebsg_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","מִשָּׁם עֲבַרְנוּ בָאֳנִיָּה וַנָּבֹא בְיוֹם הַמָּחָר אֶל־נֹכַח כִּיּוֹס וּבַיּוֹם הַשְּׁלִישִׁי עָבַרְנוּ אֶל־סָמוֹס וַנָּלֶן בִּטְרוֹגוּלְיוֹן וַנָּבֹא לְמָחֳרָתוֹ אֶל־מִילִיטוֹס׃ ");
INSERT INTO hebsg_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","כִּי־יָעַץ פּוֹלוֹס לַחֲלוֹף עַל־פְּנֵי אֶפְסוֹס לִבְלִי הֱיוֹת לוֹ סִבָּה לִהְתְמַהְמֵהַּ בְּאַסְיָא בַּאֲשֶׁר הָיָה נֶחְפָּז בְּכָל־יְכָלְתּוֹ לְהַגִּיעַ עַד־יְרוּשָׁלַיִם לְיוֹם חַג־הַשָּׁבֻעוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","וּמִמִּלִיטוֹס שָׁלַח אֶל־אֶפְסוֹס לִקְרֹא אֶת־זִקְנֵי הָעֵדָה לְבֹאָם אֵלָיו שָׁמָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","וּכְבֹאָם אָמַר אֲלֵיהֶם אַתֶּם יְדַעְתֶּם אֶת־דָּרְכִּי וּפְעֻלָּתִי לִפְנֵיכֶם בְּכָל־הַיָּמִים אֲשֶׁר יָשַׁבְתִּי בְתוֹכְכֶם לְמִן־הַיּוֹם הָרִאשׁוֹן אֲשֶׁר דָּרְכָה כַף־רַגְלִי עַל־אַדְמַת אַסְיָא׃ ");
INSERT INTO hebsg_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","אֲשֶׁר עָבַדְתִּי אֶת־הָאָדוֹן בַּעֲנָוָה גְדוֹלָה וּבִדְמָעוֹת בִּתְלָאוֹת אֲשֶׁר מְצָאֻנִי עַל־יְדֵי הַיְּהוּדִים אֲשֶׁר יָקְשׁוּ לִי׃ ");
INSERT INTO hebsg_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","אֲשֶׁר לֹא־כִחַדְתִּי מִכֶּם כָּל־הַטּוֹב לָכֶם כִּי אִם־הִגַּדְתִּי וַאֲלַמֶּדְכֶם מָה הַטּוֹב בַּחוּצוֹת וּבַבָּתִּים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","יַעַן קָרָאתִי גַּם־לַיְּהוּדִים וְגַם־לַיְּוָנִים כִּי יְשׁוּבוּן אֶל־הָאֱלֹהִים וְהֶאֱמִינוּ בַאֲדֹנֵינוּ יֵשׁוּע הַמָּשִׁיחַ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","וְעַתָּה הִנְנִי מְמֻשָּׁךְ עַל־פִּי הָרוּחַ לַהֲלֹךְ יְרוּשָׁלָיְמָה וַאֲנִי לֹא יָדַעְתִּי דְּבַר־מָה יִקְרֵנִי שָׁם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","זוּלָתִי אֲשֶׁר־רוּחַ הַקֹּדֶשׁ יְנַבֵּא עָלַי בְּכָל־עִיר וָעִיר לֵאמֹר כִּי־כְבָלִים וַחֲבָלִים נָכֹנוּ לִי׃ ");
INSERT INTO hebsg_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","אֲבָל־נַפְשִׁי לֹא תִיקַר לִי מִתִּתָּהּ לְמַעַן מַלֵּא וְכַלֵּה אֶת־מְרוּצָתִי וְאֶת־פְּקֻדָּתִי הַשּׂוּמָה עָלַי מֵאֵת הָאָדוֹן יֵשׁוּעַ לְהוֹדִיעַ אֶת־בְּשׂרַת חֶסֶד אֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","וְעַתָּה הִנֵּה־נָא יָדַעְתִּי כִּי אַתֶּם כֻּלְּכֶם אֲשֶׁר בִּימֵי מַהֲלָכַי וּמַסָּעַי הוֹרֵיתִי אֶתְכֶם אֶת־מַלְכוּת הָאֱלֹהִים כִּי לֹא־תֹסִפוּן עוֹד לִרְאוֹת אֶת־פָּנָי׃ ");
INSERT INTO hebsg_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","עַל־כֵּן עֵד אֲנִי הַיּוֹם בִּפְנֵיכֶם כִּי־נָקִי אָנֹכִי מִדְּמֵי כֻלְּכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","כִּי אֲנִי מִבְּלִי כַחֵד דָּבָר הוֹדַעְתִּי אֶתְכֶם אֶת־עֲצַת הָאֱלֹהִים כְּתֻמָּהּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","שִׁיתוּ לִבְּכֶם עֲלֵיכֶם וְעַל־כָּל־הָעֵדֶר אֲשֶׁר רוּחַ הַקֹּדֶשׁ הֲקִימְכֶם לְמַנְהִיגִים לוֹ לִרְעוֹת אֶת־עֲדַת הָאֱלֹהִים אֲשֶׁר קָנָה־לוֹ בְּדָמוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","אֲנִי יָדַעְתִּי כִּי אַחֲרֵי מוֹתִי יִפְּלוּ בָכֶם זְאֵבֵי־טֶרֶף אֲשֶׁר עַל־הָעֵדֶר לֹא־יַחֲמֹלוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","גַּם־כִּי יָקוּמוּ מִקִּרְבְּכֶם אֲנָשִׁים אֲשֶׁר תַּהְפֻּכוֹת יְדַבֵּרוּ לְהַתְעוֹת אֶת־הַתַּלְמִידִים אַחֲרֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","עַל־כֵּן עוּרוּ וְזִכְרוּ כִּי שָׁלֹשׁ שָׁנִים יוֹמָם וָלַיְלָה אֲנִי בְדִמְעוֹתַי לֹא חָדַלְתִּי מֵהוֹכַח וּמֵאַמֵּץ אֶת־כֹּל׃ ");
INSERT INTO hebsg_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","וְעַתָּה אָחַי הִנְנִי מַפְקִיד אֶתְכֶם בְּיַד הָאֱלֹהִים וּדְבַר חַסְדּוֹ אֲשֶׁר־לוֹ הַכֹּחַ לַהֲקִימְכֶם וְלָתֵת לָכֶם נַחֲלָה בְּקֶרֶב כָּל־הַקְּדוֹשִׁים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","כֶּסֶף וְזָהָב וּשְׂמָלֹת לֹא בִקַּשְׁתִּי מֵאֵת כָּל־אִישׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","וְאַתֶּם הֲלֹא יְדַעְתֶּם כִּי בַּעֲדִי וּבְעַד אֲשֶׁר הָיוּ עִמִּי אֵלֶּה שְׁתֵּי יָדַי עַשׂוּ מִחְיָה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","כִּי בַּכֹּל וָכֹל הֶרְאֵיתִי אֶתְכֶם כִּי־אַךְ יַעֲבֹד אִישׁ וְעָשׂה בַמְּלָאכָה לְנַפְשׁוֹ וְגַם־לְנֶפֶשׁ הָאֶבְיוֹן וְהָיוּ לָכֶם לְזִכָּרוֹן דִּבְרֵי הָאָדֹן יֵשׁוּעַ כִּי־הוּא אָמַר טוֹב נְתֹן מִקָּחַת׃ ");
INSERT INTO hebsg_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","כְּכַלֹּתוֹ לְדַבֵּר כָּרַע עַל־בִּרְכָּיו וַיִּתְפַּלֵּל עִם־כֻּלָּם יַחְדָּו׃ ");
INSERT INTO hebsg_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","וְהֵם כֻּלָּם בָּכוּ הַרְבֵּה בֶכֶה וַיִּפְּלוּ עַל־צַוְּארֵי פוֹלוֹס וַיִּשָּׁקוּהוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","וְיוֹתֵר נֶעֶצְבוּ אֶל־לִבָּם עַל־הַדָּבָר אֲשֶׁר דִּבֵּר כִּי לֹא־יוֹסִיפוּן עוֹד לִרְאוֹת אֶת־פָּנָיו וַיֵּלְכוּ אַחֲרָיו עַד־הַסְּפִינָה וַיְשַׁלְּחוּהוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","וַיְהִי אַחֲרֵי נִפְרַדְנוּ מֵהֶם וַנַּעֲבֹר בָּאֳנִיָּה בָּאנוּ דֶּרֶךְ יְשָׁרָה אֶל־קוֹס וּבְיוֹם הַמָּחֳרָת אֶל־רוֹדוֹס וּמִשָּׁם אֶל־פַּטָּרָה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","שָׁם מָצָאנוּ אֳנִיָּה מִתְעַתֶּדֶת לַהֲלֹךְ אֶל־פִּינוּקְיָא וַנֵּרֶד־בָּהּ וַנַּעֲבֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","וְאַחֲרֵי אֲשֶׁר נִשְׁקַף לָנוּ הָאִי קַפְרוֹס אֲשֶׁר עֲזַבְנֻהוּ לִשְׂמֹאלֵנוּ נָטִינוּ אֶל־סוּרְיָא וַנַּגִּיעַ אֶל־צוֹר כִּי־שָׁם הֹעֲלָה הַמַּשָּׂא אֲשֶׁר הוּבָא בָאֳנִיָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","וַאֲנַחְנוּ בְּמָצְאֵנוּ אֶת־הַתַּלְמִידִים יָשַׁבְנוּ שָׁם עִמָּהֶם שִׁבְעַת יָמִים וְהֵם אָמְרוּ אֶל־פּוֹלוֹס בְּנוֹחַ עֲלֵיהֶם הָרוּחַ כִּי לֹא־יַעֲלֶה לִירוּשָׁלָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","וַיְהִי כִּי מָלְאוּ לָנוּ יְמֵי שִׁבְתֵּנוּ יָצָאנוּ לָלֶכֶת בְּשַׁלְּחָם אֹתָנוּ כֻלָּם עִם־נְשֵׁיהֶם וּבְנֵיהֶם עַד־מִחוּץ לָעִיר וְעַל־הַחוֹף כָּרַעְנוּ יַחְדָּו וַנִּתְפַּלָּל׃ ");
INSERT INTO hebsg_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","וַנְּבָרֶךְ אִישׁ אֶת־רֵעֵהוּ וַיָּרַדְנוּ בָאֳנִיָּה וְהֵם שָבוּ לְבֵיתָם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","וַנַּעַשׂ אֶת־דַּרְכֵּנוּ מִצֹּר וַנָּבֹא אֶל־עַכּוֹ שָׁם שָׁאַלְנוּ לִשְׁלוֹם הָאַחִים וַנֵּשֶׁב עִמָּם יוֹם אֶחָד׃ ");
INSERT INTO hebsg_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","וּמִמָּחֳרָת אֲנַחְנוּ אֲשֶׁר הָיִינוּ אִם פּוֹלוֹס יָצָאנוּ וַנֵּלֶךְ אֶל־קִסְרִין אֲשֶׁר שָׁם בָּאנוּ אֶל־בֵּית פִּילִפּוֹס הַמְבַשֵּׂר וְהוּא אֶחָד מֵהַשִּׁבְעָה וַנֵּשֶׁב עִמּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","וְלוֹ אַרְבַּע בָּנוֹת בְּתוּלוֹת וְהֵן מִתְנַבְּאוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","וַיְהִי כְּשִׁבְתֵּנוּ פֹה יָמִים אֲחָדִים וְנָבִיא אֶחָד יָרַד עַד־כֹּה מִיהוּדָה וּשְׁמוֹ אֲגָבוֹס׃ ");
INSERT INTO hebsg_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","וְהוּא בָא אֵלֵינוּ וַיִּקַּח אֶת־אֵזוֹר פּוֹלוֹס וַיֶּאְסָר־בּוֹ אֶת־יָדָיו וְאֶת־רַגְלָיו וַיֹּאמֶר כֹּה אָמַר רוּחַ הַקֹּדֶשׁ כָּכָה יַאַסְרוּ הַיְּהוּדִים בִּירוּשָׁלַיִם אֶת־הָאִישׁ אֲשֶׁר־לוֹ הָאֵזוֹר הַזֶּה וְהִסְגִּירֻהוּ בִּידֵי הַגּוֹיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","לְשֵׁמַע הַדְּבָרִים הָאֵלֶּה חִלִּינוּ אֶת־פָּנָיו אֲנַחְנוּ וְאַנְשֵׁי הָעִיר כִּי־יֶחְדַּל מֵעֲלוֹת לִירוּשָׁלָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","וּפוֹלוֹס עָנָה לָמָּה תַעֲשׂוּ כֹה כִּי תִבְכּוּ וְתַכְאִיבוּ אֶת־לִבִּי וַאֲנִי הִנְנִי נָכוֹן לֹא־רַק לָתֵת גֵּוִי לְאֹסְרִים כִּי אִם־גַּם לְהַקְרִיב נַפְשִׁי לִמְמִיתִים בִּירוּשָׁלַיִם בְּעַד־שֵׁם הָאָדוֹן יֵשׁוּעַ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","וַיְהִי כִּי לֹא־אָבָה לִשְׁמֹעַ וַנַּחֲרֵשׁ מִמֶּנּוּ וַנֹּאמַר רְצוֹן יְהוָֹה יֵעָשֶׂה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","וְאַחֲרֵי הַיָּמִים הָאֵלֶּה נָשָׂאנוּ אֶת־אֲשֶׁר לָנוּ וַנִּסַּע לַעֲלוֹת יְרוּשָׁלָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","וַיַּעֲלוּ עִמָּנוּ גַם־תַּלְמִידִים אֲחָדִים מִקִּסְרִין וְאֵלֶּה הֵבִיאוּ אִתָּם אֶת־מְנָסוֹן הַקַּפְרוֹסִי וְהוּא תַּלְמִיד זָקֵן וַיּוֹאֶל הָאִישׁ וַיִּתְּנֵנוּ לָשֶׁבֶת עִמּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","וַיְהִי כְּבֹאֵנוּ יְרוּשָׁלָיְמָה קִבְּלוּנוּ הָאַחִים בְּשִׂמְחָה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","וּמִמָּחֳרָת לְקָחָנוּ פוֹלוֹס וַנֵּלֶךְ אֶל־יַעֲקֹב וְכָל־הַזְּקֵנִים גַּם־הֵם בָּאוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","וַיִּשְׁאַל לָהֶם לְשָׁלוֹם וְאַחֲרֵי־כֵן הֵחֵל לְסַפֵּר בְּאָזְנֵיהֶם מֵהָחֵל וְעַד־כַּלֵּה אֶת אֲשֶׁר הִגְדִּיל הָאֱלֹהִים לַעֲשׂוֹת בְּקֶרֶב הַגּוֹיִם בַּעֲבֹדָתוֹ אֲשֶׁר עֲבָדוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","וַיִּשְׁמְעוּ וַיְבָרְכוּ אֶת־הֲאֱלֹהִים וַיֹאמְרוּ אֵלָיו הֲלֹא רֹאֶה אַתָּה אָחִינוּ כִּי כַמָּה אֲלָפִים מִן־הַיְּהוּדִים הָיוּ לְמַאֲמִינִים וְכֻלָּם מַחֲזִיקִים בַּתּוֹרָה בְּקִנְאָה גְדוֹלָה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","וְהֵם שָׁמְעוּ עָלֶיךָ כִּי אַתָּה לִמַּדְתָּ אֶת־כָּל־הַיְּהוּדִים הַיּוֹשְׁבִים בְּקֶרֶב הַגּוֹיִם לָסוּר מֵאַחֲרֵי מֹשֶׁה וְגַם־כִּי אָמַרְתָּ אֲשֶׁר לֹא יָמוּלוּ אֶת־בְּנֵיהֶם וּבְדַרְכֵי הַתּוֹרָה לֹא יֵלֵכוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","וְעַתָּה מַה־נַּעֲשֶׂה כִּי שָׁמֹעַ יִשְׁמְעוּן כִּי־בָאתָ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","לָכֵן עֲשֵׂה כַּאֲשֶׁר נֹאמַר אֵלֶיךָ יֶשְׁנָם אִתָּנוּ אַרְבָּעָה אֲנָשִׁים אֲשֶׁר נֶדֶר נְזִירִים עֲלֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","אֹתָם קְחָה אֵלֶיךָ וְהִתְקַדִּשְׁתָּ גַּם־אַתָּה אִתָּם וּמִכִּיסְךָ תִּתֵּן לָהֶם אֲשֶׁר יְגַלְּחוּ אֶת־שְׂעַר נִזְרָם וּבָזֶה יֵדְעוּ כֻלָּם כִּי אַךְ־שְׁמוּעַת שָׁוְא הִיא אֲשֶׁר שָׁמְעוּ עָלֶיךָ בַּאֲשֶׁר גַּם־אַתָּה תִשְׁמֹר לַעֲשׁוֹת כְּכָל־הַכָּתוּב בַּתּוֹרָה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","וְעַל־אֹדוֹת הַגּוֹיִם הַמַּאֲמִינִים אֲנַחְנוּ כְּבָר צִוִּינוּ עִם־הַסֵּפֶר כִּי הֵם אֶת־כָּל־אֵלֶּה לֹא יִשְׁמֹרוּ וְרַק יִבָּדְלוּ מִזִּבְחֵי אֱלִילִים וּמִן־הַדָּם וּמִן־הַנֶּחֱנָק וּמִן־הַנִּאֻפִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","וַיִּקַּח פּוֹלוֹס אֶת־הָאֲנָשִׁים וַיִּתְקַדֵּשׁ אִתָּם מִמָּחֳרָת וַיָּבֹא עִמָּהֶם אֶל־הַמִּקְדָּשׁ לְהַגִּיד כִּי־מָלְאוּ יְמֵי טָהֳרָתָם וְעוֹד עֲלֵיהֶם רַק לְהָבִיא אִישׁ אִישׁ אֶת־קָרְבָּנוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","בִּמְלֹאת שִׁבְעַת הַיָּמִים וַיִּרְאֻהוּ הַיְּהוּדִים אֲשֶׁר מֵאַסְיָא כִּי בָא אֶל־הַמִּקְדָּשׁ וַיְעוֹרְרוּ אֶת־כָּל־הֶהָמוֹן וַיִּשְׁלְחוּ־בוֹ אֶת־יְדֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","וַיִּזְעָקוּ אַנְשֵׁי יִשְׂרָאֵל חוּשׁוּ לְעֶזְרָה הִנֵּה הָאִישׁ אֲשֶׁר בְּכָל־מְקוֹם בֹּאוֹ הוּא מְלַמֵּד סָרָה לַהֲסִירָם מֵהָעָם מֵהַתּוֹרָה וּמֵהַמָּקוֹם הַזֶּה וְעַתָּה עוֹד הֵבִיא יְוָנִים אֶל־הַמִּקְדָּשׁ וַיְטַמֵּא אֶת־הַמָּקוֹם הַקָּדוֹשׁ הַזֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","כִּי לִפְנֵי זֶה רָאוּ אֶת־טְרוֹפִימוֹס הָאֶפְסִי מִתְהַלֵּךְ עִמּוֹ בָּעִיר וַיַּחְשְׁבוּ כִּי־פוֹלוֹס הֱבִיאָהוּ גַם אֶל־הַמִּקְדָּשׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","וַתִּרְעַשׁ כָּל־הָעִיר וְכָל־הָעָם הִתְקַבָּצוּ וַיִּתְפְּשׂוּ אֶת־פּוֹלוֹס וַיִּסְחָבוּהוּ מִתּוֹךְ הַמִּקְדָּשׁ הַחוּצָה וְהַדְּלָתוֹת בִּן־רֶגַע סֻגָּרוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","וַיְהִי כִּי אָמְרוּ לַהֲמִיתוֹ וַיֻּגַּד לְשַׂר הָאֶלֶף כִּי יְרוּשָׁלַיִם כֻלָּה הִתְקוֹמָמָה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","וְהוּא הִצְבִּיא מִבְּלִי־בוֹשׁ חֶבֶל אַנְשֵׁי צָבָא וְשָׂרֵי מֵאוֹת וַיָּרָץ אֶל־תּוֹךְ הָעָם וְהֵם רָאוּ אֶת־שַׂר־הָאֶלֶף וְאֶת־אַנְשֵׁי הַצָּבָא וַיַּחְדְּלוּ מֵהַכּוֹת אֶת־פּוֹלוֹס׃ ");
INSERT INTO hebsg_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","וְשַׂר־הָאֶלֶף הִקְרִיב וַיַּחֲזֶק־בּוֹ וַיְצַו לְאָסְרוֹ בִּשְׁנַיִם כְּבָלִים וַיִּשְׁאַל מִי הוּא־זֶה וּמַזֶּה אֲשֶׁר עָשָׂה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","וַיַּעַן הָעָם וַיִּקְרְאוּ אֵלֶּה כֹה וְאֵלֶּה כֹה וְיַעַן אֲשֶׁר לֹא יָכוֹל לְהַצִּיל דָּבָר לַאֲמִתּוֹ כִּי רַב הַשָּׁאוֹן עַל־כֵּן צִוָּה לַהֲבִיאֵהוּ אֶל־הַמְּצוּדָה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","בְּהַגִּיעָם אֶל־הַמַּעֲלוֹת נְשָׂאֻהוּ אַנְשֵׁי הַצָּבָא לְפַלְּטוֹ מִתִּגְרַת הָעָם כִּי עָצְמָה מְאֹד׃ ");
INSERT INTO hebsg_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","כִּי עַם־רָב הִתְרֹצְצוּ אַחֲרָיו בְּקָרְאָם הַחֲרֵם אֹתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","וַיְהִי טֶרֶם הוּבָא פוֹלוֹס אֶל־תּוֹךְ הַמְּצוּדָה וְהוּא אָמַר אֶל־שַׂר־הָאֶלֶף הֲתִתְּנֵנִי לְדַבֵּר אֵלֶיךָ דְּבַר־מָה וַיֹּאמֶר הֲיוֹדֵעַ אַתָּה לְדַבֵּר יְוַנִית׃ ");
INSERT INTO hebsg_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","הַאֵינְךָ אַתָּה אִישׁ מִצְרַיִם הַהוּא אֲשֶׁר זֶה מִקָּרוֹב הֵקִים מֶרֶד וַיּוֹצֵא אַרְבַּעַת אֲלָפִים אַנְשֵׁי דָמִים אַחֲרָיו הַמִּדְבָּרָה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","וַיֹּאמֶר פּוֹלוֹס לֹא כִּי־אֲנִי יְהוּדִי יְלִיד עִיר טַרְסוֹס אֶזְרַח עִיר מְהֻלָּלָה בְּקִילִיקְיָא וְאָנֹכִי אֲבַקֶּשְׁךָ תְּנֵנִי־נָא לְדַבֵּר אֶל־הָעָם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","וּבְתֵת אֹתוֹ לְדַבֵּר הִתְיַצֵּב פּוֹלוס עַל־הַמַּעֲלוֹת וַיְנֹפֵף יָדוֹ אֶל־מוּל הָעָם וַתְּהִי דֻמִיָּה גְדוֹלָה וַיְדַבֵּר אֲלֵיהֶם בְּעִבְרִית לֵאמֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","אֲנָשִׁים אַחִים וְאָבוֹת שִׁמְעוּ־נָא וַאֲדַבֵּרָה לְמַעַן לִפְנֵיכֶם אֶצְטַדָּק׃ ");
INSERT INTO hebsg_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","כְּשָׁמְעָם כִּי בְעִבְרִית יְדַבֵּר אֲלֵיהֶם וַיּוֹסִיפוּ עוֹד לְהַחֲרִישׁ וְהוּא אָמָר׃ ");
INSERT INTO hebsg_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","אִישׁ־יְהוּדִי אֲנֹכִי בְּעִיר טַרְסוֹס בְּקִילִיקְיָא יֻלַּדְתִּי פֹה בָּעִיר הַזֹּאת גֻּדַּלְתִּי לְרַגְלֵי גַמְלִיאֵל וַיְמַלְאֵנִי לִמּוּדֵי תוֹרַת אֲבוֹתֵינוּ לְכָל־חֻקֶּיהָ גַּם־הָיִיתִי מְקַנֵּא לֵאלֹהִים כַּאֲשֶׁר הִנְּכֶם אַתֶּם הַיּוֹם כֻּלְּכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","וְאָנֹכִי רָדַפְתִּי אֶת־הַדֶּרֶךְ הַזֶּה עַד־לַמָּוֶת וַאֲנָשִׁים גַּם־נָשִׁים אָסַרְתִּי וָאֶתְּנֵם בְּבֵית הַכֶּלֶא׃ ");
INSERT INTO hebsg_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","כַּאֲשֶׁר כֹּה־יְעִידוּן־לִי גַּם־הַכֹּהֵן הַגָּדוֹל וְכָל־בֵּית הַזְּקֵנִים אֲשֶׁר אִמְּצוּ־לִי בְּאִגְּרוֹתֵיהֶם אֶל־הָאַחִים לֶלֶכֶת לְדַמֶּשֶׂק לַהֲבִיאָם גַּם־מִשָּׁם אֲסוּרִים לִירוּשָׁלַיִם לְמַעַן יֵעָנֵשׁוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","אֲנִי בַדֶּרֶךְ קָרוֹב לְבֹא דַמָּשֶׂק וְהִנֵּה בַּחֲצִי הַיּוֹם פִּתְאֹם אוֹר גָּדוֹל מִשָּׁמַיִם נָגַה עָלַי וַיְסֻבֵּנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","וָאֶפֹּל אַרְצָה וָאֶשְׁמַע קוֹל מִדַּבֵּר אֵלָי שָׁאוּל שָׁאוּל לָמָּה תִּרְדְּפֵנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","וָאַעַן אָנִי מִי אַתָּה אֲדֹנִי וַיֹּאמֶר אֵלַי אֲנִי יֵשׁוּעַ הַנָּצְרִי אֲשֶׁר אַתָּה מְרַדֵּף׃ ");
INSERT INTO hebsg_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","וַאֲשֶׁר הָיוּ עִמִּי רָאוּ אֶת־הָאוֹר וַיִּירָאוּ רַק אֶת־הַקּוֹל הַמְדַבֵּר אֵלַי לֹא שָׁמֵעוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","וָאֹמַר וּמָה אֵפוֹא אֶעֱשֶׂה אֲדֹנִי וַיֹּאמֶר הָאָדוֹן אֵלַי קוּם וָלֵךְ לְדַמֶּשֶׂק וְשָׁם יֻגַּד לְךָ כֹּל אֲשֶׁר תְּצֻוֶּה לַעֲשׂוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","וַאֲנִי לֹא־יָכֹלְתִּי לִרְאוֹת בְּעֵינַי כִי־כָהוּ מִפְּנֵי נֹגַהּ הָאוֹר וַיַּנְחוּנִי בְיָד הַהֹלְכִים עִמִּי וָאָבֹא לְדַמָּשֶׂק׃ ");
INSERT INTO hebsg_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","וְשָׁם אִישׁ וּשְׁמוֹ חֲנַנְיָה יְרֵא אֱלֹהִים כְּפִי הַתּוֹרָה וְרָצוּי לְכָל־הַיְּהוּדִים הַיֹּשְׁבִים שָׁם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","וְהוּא בָא אֵלַי וַיִּגַּשׁ וַיֹּאמַר אָחִי שָׁאוּל פְּקַח עֵינֶיךָ וּרְאֵה וּבְרֶגַע הַזֶּה נִפְקְחוּ עֵינַי וָאֶרְאֵהוּ אֹתוֹ לְפָנָי׃ ");
INSERT INTO hebsg_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","וַיֹּאמַר אֱלֹהֵי אֲבוֹתֵינוּ בָּחַר בְּךָ לָדַעַת אֶת־רְצוֹנוֹ וְלִרְאוֹת אֶת־הַצַּדִּיק וְלִשְׁמֹעַ אֶת־קוֹלוֹ מִפִּיו׃ ");
INSERT INTO hebsg_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","כִּי הָיֹה תִהְיֶה־לּוֹ לְעֵד נֶגֶד כָּל־הָאָדָם בַּדָּבָר אֲשֶׁר רָאִיתָ וַאֲשֶׁר שָׁמָעְתָּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","וְעַתָּה לָמָּה תִתְמַהְמֵהַּ קוּם הִטָּבֵל וְהִתְרַחֵץ מֵחַטֹּאתֶיךָ בְּקָרְאֲךָ בְּשֵׁם הָאָדוֹן׃ ");
INSERT INTO hebsg_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","וַיְהִי בְּשׁוּבִי לִירוּשָׁלַיִם וַאֲנִי הִתְפַּלַּלְתִּי בַמִּקְדָּשׁ וְרוּחַ יְהוָֹה לְבָשָׁתְנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","וָאֵרֶא אֹתוֹ מְדַבֵּר אֵלַי חוּשָׁה מַהֲרָה מִירוּשָׁלָיִם כִּי אֶת־עֵדוּתְךָ עָלַי לֹא־יִקָּחוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","וָאֹמַר אֲדֹנִי הֲלֹא הֵם יוֹדְעִים הֵיטֵב כִּי אֲנִי הוּא אֲשֶׁר אֶת־מַאֲמִינֶיךָ כִּלֵּאתִי בְּבָתֵּי כְלָאִים וּבְבָתֵּי־הַכְּנֵסֶת הִכֵּיתִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","וּבְהִשָּׁפֵךְ דַּם־סְטְפָנוֹס עֵדְךָ גַּם־אֲנִי עֲמַדְתִּי שָׁם נָטִיתִי אַחֲרֵיהֶם לַהֲמִיתוֹ וְאֶת־בִּגְדֵי מְרַצְחָיו אֲנִי נָטָרְתִּי׃ ");
INSERT INTO hebsg_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","וַיֹּאמֶר אֵלַי לֵךְ כִּי בַמֶּרְחַקִּים אֶל־הַגּוֹיִם אֲנִי אֶשְׁלָחֶךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","וַיִּשְׁמְעוּ אֹתוֹ עַד־הַדָּבָר הַזֶּה וְאָז נָתְנוּ קוֹלָם וַיִּקְרָאוּ הִכָּחֵד יִכָּחֵד אִישׁ כָּזֶה מֵעַל־פְּנֵי הָאֲדָמָה אֵין לוֹ חַיִּים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","וַיְהִי הֵם שֹׁאֲגִים וּפֹשְׁטִים אֶת־בִּגְדֵיהֶם וּמְעַפְּרִים בֶּעָפָר עַד־לְמָעְלָה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","וַיְצַו שַׂר הָאֶלֶף לַהֲבִיאוֹ אֶל־תּוֹךְ הַמְּצוּדָה וְשָׁם צִוָּה עָלָיו לְעַנּוֹתוֹ בְּמַכּוֹת אַכְזְרִיּוֹת לְמַעַן יִוָּדַע לוֹ עַל־מֶה כָּכָה עָלָיו הִתְרַגָּזוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","וַיְהִי בְּהֵאָסְרוֹ לְהֵעָנוֹתוֹ וַיֹּאמֶר פּוֹלוֹס אֶל־שַׂר־הַמֵּאָה הַנִּצָּב עָלָיו הַאַף אֻמְנָם יֶשׁ־לָכֶם הָרִשְׁיוֹן לְעַנּוֹת אֶזְרַח רוֹמִי וּמַה־גַּם בְּלֹא־דִין וּמִשְׁפָּט׃ ");
INSERT INTO hebsg_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","וְשַׂר הַמֵּאָה בְּשָׁמְעוֹ כָזֹאת מִהַר אֶל־שַׂר־הָאֶלֶף וַיְסַפֶּר־לוֹ וְגַם־אָמַר רְאֵה מָה אַתָּה אֹמֵר לַעֲשׂוֹת כִּי הָאִישׁ הַזֶּה אֶזְרַח רוֹמִי הוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","וַיָּבֹא שַׂר־הָאֶלֶף וַיֹּאמַר אֵלָיו אֱמָר־לִי הַאֻמְנָם כִּי אֶזְרַח רוֹמִי אָתָּה וַיֹּאמַר כִּדְבָרֶךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","וַיַּעַן שַׂר־הָאֶלֶף אָנִי קָנִיתִי לִי זְכוּת אֶזְרָח כָּזֹאת בְּכֶסֶף מָלֵא וַאֲנִי הֵשִׁיב פּוֹלוֹס אֲנִי גַּם־יֻלַּדְתִּי בָהּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","וְעַד־מְהֵרָה הִרְפּוּ מִמֶּנוּ הַמְבַקְשִׁים לְעַנּוֹתוֹ וְשַׂר הָאֶלֶף פָּחַד בְּשָׁמְעוֹ כִּי זֶה אֲשֶׁר אֲסָרוֹ אֶזְרַח רוֹמִי הוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","בַּיּוֹם הָאַחֵר נִכְסַף לְבָרֶר־לוֹ אֶת־הַדָּבָר לַאֲמִתּוֹ עַל־מָה יַרְשִׁיעוּ אֹתוֹ הַיְּהוּדִים וַיַּתִּירֵהוּ וַיְצַו לְהִתְאַסֵּף רָאשֵׁי הַכֹּהֲנִים וְכָל־הַסַּנְהֶדְרִין וְהוּא הוֹרִיד אֶת־פּוֹלוֹס וַיַּעֲמִדֵהוּ לִפְנֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","וּפוֹלוֹס נָתַן עֵינָיו עַל־הַסַּנְהֶדְרִין וַיֹּאמַר אֲנָשִׁים אַחִים אֲנִי בְּלֵב טָהוֹר הִתְהַלַּכְתִּי לִפְנֵי אֱלֹהִים עַד־הַיּוֹם הַזֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","וַחֲנַנְיָה הַכֹּהֵן הַגָּדוֹל צִוָּה אֶת־הָעֹמְדִים עָלָיו לְהַכֹּתוֹ עַל־פִּיו׃ ");
INSERT INTO hebsg_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","וַיֹּאמֶר אֵלָיו פּוֹלוֹס וְאֹתְךָ יַכֶּה אֱלֹהִים אַתָּה קִיר טוּחַ הֵן אַתָּה יֹשֵׁב פֹּה לְשָׁפְטֵנִי עַל־פִּי הַתּוֹרָה וְהִנֵּה צִוִּיתָ לְהַכֹּתִי בְּלֹא־מִשְׁפָּט׃ ");
INSERT INTO hebsg_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","וַיֹּאמְרוּ הָעֹמְדִים שָׁם הֲגַם אֶת־הַכֹּהֵן הַגָּדוֹל לֵאלֹהִים אַתָּה מְקַלֵּל׃ ");
INSERT INTO hebsg_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","וַיֹּאמֶר פּוֹלוֹס אַחַי לֹא יָדַעְתִּי כִּי הוּא הַכֹּהֵן הַגָּדוֹל כִּי־כָתוּב וְנָשִׂיא בְעַמְּךָ לֹא תָאֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","וּפוֹלוֹס יָדַע כִּי מִפְלַגְתָּם הָאַחַת צַדּוּקִים וּמִפְלַגְתָּם הַשֵּׁנִית פְּרוּשִׁים וַיִּתֵּן קוֹלוֹ וַיֹּאמֶר בְּתוֹךְ הַסַּנְהֶדְרִין אֲנָשִׁים אַחִים אֲנִי פָּרוּשׁ בֶּן־פָּרוּשׁ וְעַל־תִּקְוָתִי לִתְחִיַּת הַמֵּתִים אֲנִי לַמִּשְׁפָּט הֻגָּשְׁתִּי׃ ");
INSERT INTO hebsg_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","בְּאָמְרוֹ כָזֹאת פָּרְצָה מְרִיבָה בֵּין הַפְּרוּשִׁים וּבֵין הַצַּדּוּקִים וְהָאֲסֵפָה נִקְרְעָה לִקְרָעִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","כִּי הַצַּדּוּקִים אָמְרוּ אֵין תְּחִיַּת הַמֵּתִים וְאֵין מַלְאָכִים וְאַף־אֵין רוּחַ וְהַפְּרוּשִׁים אָמְרוּ יֵשׁ וָיֵשׁ כָּל־אֵלֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","וַיָּקָם שָׁאוֹן גָּדוֹל וְהַסּוֹפְרִים הַפְּרוּשִׁים עָמְדוּ וַיִּתְוַכְּחוּ וַיֹּאמְרוּ אֵין אֲנַחְנוּ מֹצְאִים אָוֶן בָּאִישׁ הַזֶּה אִם כֹּה רוּחַ דִּבֶּר אֵלָיו אוֹ מַלְאָךְ אֲנַחְנוּ לֹא נָרִיב אֶל־אֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","וַיְהִי כִּי־חָזַק הָרִיב וְשַׂר־הָאֶלֶף דָּאַג לְפוֹלוֹס פֶּן־יִטְרְפֻהוּ בְאַפָּם וַיְצַו אֶת־אַנְשֵׁי הַצָּבָא לְקַחְתּוֹ מִבֵּינֹתָם וְלַהֲשִׁבוֹ אֶל־הַמְּצוּדָה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","וּבַלַּיְלָה הַהוּא נִרְאָה אֵלָיו הָאָדוֹן וַיֹּאמֶר חֲזָק כִּי כַּאֲשֶׁר הַעִידֹתָ לִּי בִּירוּשָׁלַיִם כֵּן תְּעִידֵנִי גַּם־בְּרוֹמִי׃ ");
INSERT INTO hebsg_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","וַיְהִי בִּהְיוֹת יוֹמָם וְהַיְּהוּדִים נוֹסְדוּ וַיִּשְׂאוּ בְאָלָה נַפְשָׁם אִם יֹאכְלוּ וְאִם יִשְׁתּוּ עַד אִם־הֲמִיתָם אֶת־פּוֹלוֹס׃ ");
INSERT INTO hebsg_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","וַיִּהְיוּ הַבָּאִים בִּשְׁבוּעַת הָאָלָה הַזֹּאת יוֹתֵר מֵאַרְבָּעִים אִישׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","וְהֵם הָלְכוּ אֶל־רָאשֵׁי הַכֹּהֲנִים וְאֶל־הַזְּקֵנִים וַיֹּאמְרוּ אֲנַחְנוּ נִשְׁבַּעְנוּ בִּשְׁבוּעַת אָלָה לְבִלְתִּי בֹא אֶל־פִּינוּ מְאוּם עַד אִם־הֵמַתְנוּ אֶת־פּוֹלוֹס׃ ");
INSERT INTO hebsg_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","עַל־כֵּן אַתֶּם וְהַסַּנְהֶדְרִין אִמְרוּ לְשַׂר־הָאֶלֶף כִּי יוֹרִידֵהוּ מָחָר אֲלֵיכֶם כְּמוֹ אִם אַתֶּם חֲפֵצִים לַחֲקֹר הֵיטֵב אֶת־מִשְׁפָּטוֹ וְדִינוֹ וַאֲנַחְנוּ נִהְיֶה נְכֹנִים לַהֲמִיתוֹ בְּטֶרֶם יַגִּיעַ אֲלֵיכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","וַיִּוָּדַע דְּבַר הַצְּדִיָּה הַזֹּאת לְבֶן־אֲחוֹת פּוֹלוֹס וַיְמַהֵר וַיָּבֹא אֶל־הַמְּצוּדָה וַיַּגֵּד לְפוֹלוֹס׃ ");
INSERT INTO hebsg_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","וַיִּקְרָא פוֹלוֹס אֶל־אֶחָד מִשָּׂרֵי הַמֵּאוֹת וַיֹּאמֶר לוֹ קְחָה אֶת־הַנַּעַר הַזֶּה וְהָבֵא אֹתוֹ אֶל־שַׂר־הָאֶלֶף כִּי־דָבָר לוֹ אֵלָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","וַיִּקָּחֵהוּ וַיְבִיאֵהוּ אֶל־שַׂר־הָאֶלֶף וַיֹּאמַר פּוֹלוֹס הָאַסִּיר קְרָאַנִי אֵלָיו וַיְבַקְשֵׁנִי לְהָבִיא אֶת־הַנַּעַר הַזֶּה לְפָנֶיךָ בַּאֲשֶׁר דָּבָר לוֹ לְהַגִּיד לָךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","וַיֶּחֱזַק שַׂר הָאֶלֶף בְּיָדוֹ וַיַּטֵּהוּ הַצִּדָּה וַיִּשְׁאָלֵהוּ מַה־דָּבָר לָאַט עִמְּךָ לְגַלּוֹתוֹ לִי׃ ");
INSERT INTO hebsg_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","וַיֹּאמַר כֹּה־חִבְּלוּ הַיְּהוּדִים עֵצָה בַסָּתֶר לְבַקֵּשׁ מֵאִתְּךָ לְהוֹרִיד אֶת־פּוֹלוֹס מָחָר אֶל־הַסַּנְהֶדְרִין כְּמוֹ אִם־חָפֵץ אַתָּה לַחֲקֹר הֵיטֵב אֶת־מִשְׁפָּטוֹ וְדִינוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","וְעַתָּה אַתָּה אַל־תִּשְׁמַע לָהֶם כִּי יוֹתֵר מֵאַרְבָּעִים אֲנָשִׁים יֶאֶרְבוּ לוֹ וְהֵם נִשְׁבְּעוּ בִשְׁבוּעַת אָלָה לְבִלְתִּי אָכֹל וְשָׁתוֹ עַד אִם־הֲמִיתָם אֹתוֹ וְעַתָּה הֵם מוּכָנִים וּמְיַחֲלִים לְמוֹ־פִיךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","וְשַׂר־הָאֶלֶף שִׁלַּח אֶת־הַנַּעַר וַיְצַוֵּהוּ מֵהַגִּיד לְאִישׁ אֶת־אֲשֶׁר הוֹדַע אֹתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","וַיִּקְרָא לִשְׁנֵי שָׂרֵי מֵאוֹת וַיֹּאמַר הַעֲמִידוּ מָאתַיִם אַנְשֵׁי צָבָא חֲלוּצִים וּנְכֹנִים לָלֶכֶת לִקִסְרִין וְשִׁבְעִים פָּרָשִׁים וּמָאתַיִם נֹשְׂאֵי רְמָחִים בַּשָּׁעָה הַשְּׁלִישִׁית בַּלַּיְלָה יִהְיוּ נְכֹנִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","גַּם־בַּהֲמוֹת מַשָּׂא תָּבִיאוּ לָשֵׂאת אֶת־פּוֹלוֹס וְלַהֲבִיאֵהוּ שָׁלֵם אֶל־הַפֶּחָה אֶל־פִּילִיכַס׃ ");
INSERT INTO hebsg_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","וַיִּכְתֹּב אִגֶּרֶת וּבָהּ כַּדְּבָרִים הָאֵלֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","מִמֶּנִי קְלוֹדְיוֹס לוּסִיאַס אֶל־פִּילִיכַס הַפֶּחָה וְהַנִּכְבָּד עַד־מְאֹד בְּרָכָה וְשָׁלוֹם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","אֶת־הָאִישׁ הַזֶּה אֲשֶׁר הַיְּהוּדִים תְּפָשׂוּהוּ וַיֹּאמְרוּ לַהֲמִיתוֹ אֹתוֹ הִצַּלְתִּי בְּמַהֲרִי עִם־אַנְשֵׁי הַצָּבָא יַעַן שָׁמַעְתִּי כִּי־אֶזְרַח רוֹמִי הוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","וּבַאֲשֶׁר חָפַצְתִּי לְדֵעָה עַל־דְּבַר מָה הֵם מַרְשִׁיעִים אֹתוֹ הִקְרַבְתִּיו לִפְנֵי הַסַּנְהֶדְרִין׃ ");
INSERT INTO hebsg_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","וָאֶשְׁמַע כִּי רַק עַל־אֹדוֹת דְּבַר רִיב בְּחִקְרֵי תוֹרָתָם הֵם מַרְשִׁיעִים אֹתוֹ וְלֹא עַל־דְּבַר־אָוֶן לִהְיוֹת רָשָׁע לָמוּת אוֹ אֲסִיר עֹנִי בְּכַבְלֵי בַרְזֶל׃ ");
INSERT INTO hebsg_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","וַיְהִי כִּי הֻגַּד לִי אֲשֶׁר כּוֹנְנוּ לְהַשְׁחִיתוֹ מִהַרְתִּי וָאֶשְׁלָחֵהוּ אֵלֶיךָ וְגַם אֶת־שׂטְנָיו יָעַדְתִּי לָבֹא וּלְדַבֵּר לְפָנֶיךָ שָׁלוֹם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","וַיִּקְחוּ אַנְשֵׁי הַצָּבָא אֶת־פּוֹלוֹס כַּאֲשֶׁר צֻוּוּ וַיְבִיאֻהוּ בְּעוֹד לַיְלַה אֶל־אַנְטִפַּטְרִיס׃ ");
INSERT INTO hebsg_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","וּמִמָּחֳרָת נְתָנוּהוּ עַל־יַד הַפָּרָשִׁים וְהֵם שָׁבוּ אֶל־הַמְּצוּדָה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","וְאֵלֶּה בָּאוּ אֶל־קִסְרִין וַיִּתְּנוּ אֶת־הָאִגֶּרֶת אֶל־יַד הַפֶּחָה וְגַם אֶת־פּוֹלוֹס הֶעֱמִידוּ לְפָנָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","וַיְהִי בְּקָרְאוֹ וַיִּשְׁאַל מֵאֵי־זוֹ מְדִינָה הוּא וַיִּשְׁמַע כִּי־מִקִּילִיקְיָא הוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","וַיֹּאמַר אָנֹכִי אֶבְחָנְךָ אַחֲרֵי בֹא הֵנָּה גַּם־שׂטְנֶיךָ וַיְצַו לְשָׁמְרוֹ בְּבֵית הַמִּשְׁפָּט אֲשֶׁר לְהוֹרְדוֹס׃ ");
INSERT INTO hebsg_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","וַיְהִי אַחֲרֵי חֲמִישָּׁה יָמִים וַיֵּרֶד חֲנַנְיָה הַכֹּהֵן הַגָּדוֹל וְהַזְּקֵנִים וְאִישׁ אֶחָד יֹדֵעַ דַּבֵּר טַרְטֻלּוֹס שְׁמוֹ וַיִּלֹּנוּ עַל־פּוֹלוֹס לִפְנֵי הַפֵּחָה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","הוּא נִקְרָא וְטַרְטֻלּוֹס הֵחֵל לִשִׂטְנוֹ וַיֹּאמַר אֲשֶׁר עַל־יָדְךָ הַשְׁקֵט וּבִטְחָה לָנוּ וַתָּבֹאנָה טוֹבוֹת הַרְבֵּה לָעָם הַזֶּה יַעַן הִשְׂכַּלְתָּ לַעֲשׂוֹת עִמָּנוּ בְּשׁוּם שֶׂכֶל׃ ");
INSERT INTO hebsg_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","עַל־זֶה אֲנַחְנוּ מוֹדִים לְךָ פִּילִיכַס הַנִּכְבָּד וּמְבָרְכִים אֹתְךָ בְּכָל־יוֹם וּבְכָל־מָקוֹם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","וְאוּלָם לְמַעַן חֲדֹל מֵהוֹגִיעֲךָ הַרְבֵּה עַל־כֵּן אֲשַׁחְרְךָ בְּקֹצֶר מִלִּים כִּי תִשְׁמָעֵנוּ בְּרֹב חַסְדֶּךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","אֲנַחְנוּ מָצָאנוּ אֶת־הָאִישׁ הַזֶּה כַּדֶּבֶר יַהֲלֹךְ מְשַׁלַּח מְדָנִים בֵּין כָּל־הַיְּהוּדִים בְּכָל־הָאָרֶץ וְהוּא מַנְהִיג לְמִפְלֶגֶת הַנָּצְרִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","וְגַם־הוּא חָמַס מְזִמָּה לְחַלֵּל אֶת־הַמִּקְדָּשׁ וַאֲנַחְנוּ תְּפַשְׂנֻהוּ וַנֹּאמֶר לַעֲשׂוֹת בּוֹ מִשְׁפָּט כָּתוּב בְּתוֹרָתֵנוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","וַיָּבֹא לוּסִיאַס שַׂר־הָאֶלֶף בְּיָד־חֲזָקָה וַיִּגְזְלֵהוּ מִיָּדֵנוּ וְאֶת־שִׂטְנָיו צִוָּה לָבֹא עָדֶיךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","וְהִנֵּה פִּיו יַעֲנֶה בּוֹ אִם־תַּחְקְרֵהוּ וְאַתָּה תִבְחַן וְיָדַעְתָּ אֶת־הַתְּלוּנָּה אֲשֶׁר אֲנַחְנוּ מַלִּינִים עָלָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","וְהַיְּהוּדִים הֵעִידוּ וַיֹּאמְרוּ כֵּנִים הַדְּבָרִים הָאֵלֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","וּפוֹלוֹס עָנָה בְּתֵת לוֹ הַפֶּחָה אוֹת לַעֲנוֹת מִדַּעְתִּי כִי שֹׁפֵט אַתָּה לָעָם הַזֶּה זֶה שָׁנִים רַבּוֹת עַל־כֵּן אֶעֱנֶה צִדְקִי בִי בְּלֵב נָכוֹן וּבָטוּחַ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","הַנָּקֵל לְךָ לָדַעַת כִּי עוֹד לֹא חָלְפוּ יוֹתֵר מִשְּׁנֵים עָשָׂר יוֹם מִיּוֹם עֲלֹתִי לִירוּשָׁלַיִם לְהִשְׁתַּחֲוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","וְהֵם לֹא מְצָאֻנִי מֵשִׂיחַ עִם־אִישׁ בַּמִּקְדָּשׁ אוֹ־מְסַבֵּב דָּבָר לְהִזָּעֵק הָעָם אַף לֹא־בְּבָתֵּי־הַכְּנֵסֶת אוֹ בָּעִיר׃ ");
INSERT INTO hebsg_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","וְכֵן גַּם־לֹא יוּכְלוּ לְהוֹכַח לְפָנֶיךָ כִּי אֱמֶת הַתְּלוּנָּה אֲשֶׁר הֵם מַלִּינִים עָלָי׃ ");
INSERT INTO hebsg_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","אוּלָם אֶת־זֹאת אֲנִי מוֹדֶה לְפָנֶיךָ כִּי אֲנִי בַּדֶּרֶךְ הַהִיא אֲשֶׁר יִקְּבוּהָ מִפְלַגָּה בָּהּ אֲנִי עֹבֵד אֶת־אֱלֹהֵי אֲבוֹתֵינוּ וְכִי אֲנִי מַאֲמִין בְּכָל־הַכָּתוּב בַּתּוֹרָה וּבַנְּבִיאִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","וְזֹאת תִּקְוָתִי בִי לֵאלֹהִים אֲשֶׁר גַּם־הֵם מַחֲזִיקִים בָּהּ כִּי כָּל־מֵתֵי עוֹלָם יְקוּמוּן לִתְחִיַת הַמֵּתִים לַצַּדִּיקִים וְלָרְשָׁעִים יַחְדָּו׃ ");
INSERT INTO hebsg_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","וְאֶל־זֶה הָיִיתִי עָמֵל תָּמִיד לִהְיוֹתִי בַר־לֵבָב לִפְנֵי אֱלֹהִים וְאָדָם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","וְאַחֲרֵי שָׁנִים רַבּוֹת בָּאתִי יְרוּשָׁלַיְמָה בִּנְדָבוֹת לַעֲנִיֵּי עַמִּי וּלְהַקְרִיב קָרְבָּן׃ ");
INSERT INTO hebsg_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","וְכֹה אַחֲרֵי הִתְקַדִּשְׁתִּי מְצָאֻנִי בַמִּקְדָּשׁ וְלֹא בְמַקְהֲלוֹת עָם וְלֹא בִתְשֻׁאוֹת הָמוֹן רָב׃ ");
INSERT INTO hebsg_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","וִיהוּדִים אֲחָדִים מֵאַסְיָא הֵם אֲשֶׁר עֲלֵיהֶם הָיָה לִקְרֹא אֵלֶיךָ עָלַי אִם כָּל־דְּבַר פֶּשַׁע בִּי מָצָאוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","וְאוּלָם הַגֵּד יַגִּידוּ כֹה הָאֲנָשִׁים הָאֵלֶּה מָה־עָוֶל נִמְצָא בִי בְּעָמְדִי לִפְנֵי הַסַּנְהֶדְרִין׃ ");
INSERT INTO hebsg_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","אִם רַק־בִּגְלַל הַדָּבָר הָאֶחָד אֲשֶׁר־פָּצוּ שְׂפָתַי בְּעָמְדִי בֵינֵיהֶם עַל־דְּבַר תְּחִיַּת הַמֵּתִים הֲבִיאֹתֶם אֹתִי הַיּוֹם בַּמִּשְׁפָּט לִפְנֵיכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","וְיַעַן אֲשֶׁר יָדַע הֵיטֵב פִּילִיכַס אֶת־הַדָּבָר וַיּוֹעִדֵם לְיוֹם מוֹעֵד אַחֵר וַיֹּאמַר בְּבֹא אֵלַי לוּסִיאַס שַׂר־הָאֶלֶף וְהוֹצֵאתִי אֶת־מִשְׁפַּטְכֶם לָאוֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","וְאֶת־שַׂר הַמֵּאָה צִוָּה לָתֵת אֹתוֹ בַּמִּשְׁמָר וַהַנָחָה יַעֲשֶׂה־לּוֹ לְהָנִיחַ אֶת־מְיֻדָּעָיו לָבֹא אֵלָיו וּלְשָׁרְתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","וְאַחֲרֵי יָמִים אֲחָדִים בָּא פִילִיכַס וּדְרוּסִלָּה אִשְׁתּוֹ הַיְּהוּדִיָּה וַיְצַו לְהוֹצִיא אֵלָיו אֶת־פּוֹלוֹס וַיִּשְׁמַע אֹתוֹ עַל־דְּבַר הָאֱמוּנָה בַּמָּשִׁיחַ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","וּכְדַבְּרוֹ עַל־עֲשֵׂה צֶדֶק עַל־הַצְנֵעַ לֶכֶת וְעַל־יוֹם הַדִּין הֶעָתִיד לְקֵץ הַיָּמִים וַיֶּחֱרַד פִּילִיכַס וַיַּעַן לֶךְ־נָא עַתָּה עַד־אֶמְצָא עֶת־לִי וְקָרָאתִי לָךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","וּבְכָל־זֶה הוּא גַם דִּמָּה לְסַבֵּב אֲשֶׁר פּוֹלוֹס יִשְׁקֹל עַל־יָדוֹ מַשְׂאַת כֶּסֶף לְמַעַן יַתִּירֵהוּ וְעַל־כֵּן קְרָאוֹ אֵלָיו פְּעָמִים רַבּוֹת וַיְדַבֵּר עִמּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","וַיְהִי מִקֵּץ שְׁנָתַיִם יָמִים וַיָּקָם פרקיּוֹס פֶּסְטוֹס תַּחַת פִּילִיכַס וְיַעַן אֲשֶׁר חָפֵץ פִּילִיכַס לְהָפִיק רָצוֹן מֵאֵת הַיְּהוּדִים הִנִּיחַ אֶת־פּוֹלוֹס בְּבֵית הַכֶּלֶא וַיַּעַזְבֵהוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","וַיְהִי אַחֲרֵי שְׁלֹשָׁה יָמִים כְּבֹא פֶסְטוֹס אֶל־הַמְּדִינָה וַיַּעַל מִקִּסְרִין לִירוּשָׁלָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","וַיִּלֹּנוּ רָאשֵׁי הַכֹּהֲנִים וַאֲצִילֵי הַיְּהוּדִים בְּאָזְנָיו עַל־פּוֹלוֹס וַיִּפְצְרוּ־בוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","וַיִּשְׁאֲלוּ מֵאִתּוֹ לִגְמֹל לָהֶם הַחֶסֶד נֶגְדּוֹ כִּי יְצַוֶּה לַהֲבִיאֵהוּ לִירוּשָׁלָיִם יַעַן כִּי הִתְנַכְּלוּ־בוֹ לְהַשְׁחִיתוֹ בַדָּרֶךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","וּפֶסְטוֹס עָנָה הֵן פּוֹלוֹס עָצוּר בַּמִּשְׁמֶרֶת בְּקִסְרִין וְכִי גַם־הוּא מַהֵר יָשׁוּב שָׁמָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","וְעוֹד אָמַר וְאַדִּירֵיכֶם אֲשֶׁר בָּכֶם עַתָּה יֵרְדוּ־נָא גַם־הֵם אַחֲרָי וְאִם עָוֹן בָּאִישׁ הַזֶּה שָׁם הֵם יְעִידֻהוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","וְאַחֲרֵי אֲשֶׁר לֹא הֶאֱרִיךְ לָשֶׁבֶת עִמָּהֶם רַק שְׁמֹנָה יָמִים אוֹ עֲשָׂרָה שָׁב אֶל־קִסְרִין וּמִמָּחֳרָת לְיוֹם שׁוּבוֹ יָשַׁב עַל־כִּסְאוֹ לַמִּשְׁפָּט וַיְצַו לְהָבִיא אֶת־פּוֹלוֹס לְפָנָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","אַךְ הוּא הוּבָא וַיָּסֹבּוּ אֹתוֹ הַיְּהוּדִים הַבָּאִים מִירוּשָׁלַיִם וַיַּשִּׂיאוּ עָלָיו עֲוֹנוֹת רַבִּים וּכְבֵדִים אֲשֶׁר לֹא־יָכְלוּ לְהַעֲמִידָם עַל־דְּבַר אֱמֶת׃ ");
INSERT INTO hebsg_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","וּפוֹלוֹס הִצְטַדֵּק לֵאמֹר לֹא לְתוֹרַת הַיְּהוּדִים וְלֹא לַמִּקְדָּשׁ וְאַף לֹא לְהַקֵּיסַר עַד מָה חָטָאתִי׃ ");
INSERT INTO hebsg_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","וּפֶסְטוֹס בְּבַקְּשׁוֹ לְהָפִיק רָצוֹן מֵאֵת הַיְּהוּדִים הוּא עָנָה וְאֲמַר אֶל־פּוֹלוֹס הֲיֵשׁ אֶת־נַפְשְׁךָ כִּי־תוּבָא לִירוּשָׁלַיִם לְהִשָּׁפֵט שָׁם עַל־הַדָּבָר הַזֶּה לְפָנָי׃ ");
INSERT INTO hebsg_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","וַיֹּאמֶר פּוֹלוֹס לִפְנֵי כֵס הַמִּשְׁפָּט לְהַקֵּיסַר אֲנִי עֹמֵד וּפֹה יֵעָשֶׂה מִשְׁפָּטִי לַיְהוּדִים לֹא עָשִׂיתִי מְאוּם רָע כַּאֲשֶׁר גַּם־אַתָּה הֵיטֵב יָדָעְתָּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","אִם־כֹּה רָשַׁעְתִּי פָּעַלְתִּי אָוֶן וַאֲנִי בֶן־מָוֶת הִנְנִי נָכוֹן לָמוּת וְאִם לֹא־כֵן כַּאֲשֶׁר הֵמָּה יַרְשִׁיעֻנִי אֵין אִישׁ אֵפוֹא אֲשֶׁר יִמְלָאֶנּוּ לִבּוֹ לְתִתְּנֵנִי בְיָדָם אֶל־הַקֵּיסַר אֲנִי קֹרֵא׃ ");
INSERT INTO hebsg_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","אָז נוֹעַץ פֶּסְטוֹס אֶת־אַנְשֵׁי עֲצָתוֹ וְאַחֲרֵי־כֵן אָמָר אֶל־הַקֵּיסַר קָרָאתָ וְאֶל־הַקֵּיסַר תֵּלֵךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","וַיְהִי אַחֲרֵי יָמִים אֲחָדִים וַיָּבֹא הַמֶּלֶךְ אַגְרִפַּס עִם־בֶּרְנִיקָה אֶל־קִסְרִין לִפְקֹד אֶת־פֶּסְטוֹס לְשָׁלוֹם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","וּבְשִׁבְתָּם שָׁם מִסְפָּר יָמִים הוֹדִיעַ פֶּסְטוֹס לַמֶּלֶךְ אֶת־דִּבְרֵי פוֹלוֹס וַיֹּאמֶר לוֹ אִישׁ אֶחָד אַסִּיר נִמְצָא פֹה אֲשֶׁר פִּילִיכַס הִשְׁאִירוֹ אַחֲרָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","וַאֲנִי בְּבֹאִי לִירוּשָׁלַיִם הֵלִינוּ עָלָיו בְּאָזְנַי רָאשֵׁי הַכֹּהֲנִים וְזִקְנֵי הַיְהוּדִים וַיִּפְצְרוּ־בִי לִגְמָר־לוֹ מִשְׁפַּט־מָוֶת׃ ");
INSERT INTO hebsg_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","וָאַעַן אֹתָם כִּי אֵין זֹאת דֶּרֶךְ הָרוֹמִיִּים לְהוֹצִיא נֶפֶשׁ אִישׁ לְשַׁחֲתָהּ בְּטֶרֶם יַעַמְדוּ מַרְשִׁיעָיו בְּפָנָיו עַיִן בְּעָיִן לְהִמָּצֵא לוֹ יָדַיִם לָגֹל מֵעָלָיו אֶת־אֲשֶׁר שָׁתוּ עָלָיו אִם יוּכָל׃ ");
INSERT INTO hebsg_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","לָכֵן בְּהִקָּבְצָם הֵנָּה אָז מִבְּלִי־בוֹשׁ יָשַׁבְתִּי מִמָּחֳרָת לְיוֹם שׁוּבִי עַל־כִּסֵּא הַמִּשְׁפָּט וָאֲצַו לְהָבִיא אֶת־הָאִישׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","אֲבָל בְּקוּם שׂטְנָיו לְשִׂטְנוֹ נִלְאוּ לִמְצֹא תוֹכְחוֹת אֱמֶת לְהִגָּלוֹת עָלָיו עֲוֹנוֹתָיו כְּפִי אֲשֶׁר יִחָלְתִּי׃ ");
INSERT INTO hebsg_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","רַק בְּדִבְרֵי חֵקֶר בַּעֲבוֹדַת אֱלֹהֵיהֶם סְבָבֻהוּ וְעַל־דְּבַר אִישׁ אֶחָד יֵשׁוּעַ שְׁמוֹ שֶׁהוּא כְבָר מֵת וּפוֹלוֹס אֹמֵר כִּי הוּא חָי עָלָיו הָיוּ נְדוֹנִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","וַאֲנִי כִּי נִפְלְאוּ מִמֶּנִי תְּכוּנוֹת הָרִיבֹת הָאֵלֶּה וָאֶשְׁאָלֵהוּ אִם יִשָּׂאֵהוּ לִבּוֹ לָלֶכֶת לִירוּשָלַיִם לְהִשָּׁפֶט־שָׁם עַל־אֵלֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","אֲבָל פּוֹלוֹס שָׁאַל לְהִוָּתֵר בַּמִּשְׁמֶרֶת עַד־צֵאת מִשְׁפָּטוֹ מִלִּפְנֵי אֲגוּסְטוֹס עַל־כֵּן צִוִּיתִי לְהַחֲזִיק בּוֹ עַד־אֲשֶׁר אֶשְׁלָחֵהוּ לְהַקֵּיסָר׃ ");
INSERT INTO hebsg_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","וַיֹּאמֶר אַגְרִפַּס אֶל־פֶּסְטוֹס גַּם־אֲנִי נִכְסֹף נִכְסַפְתִּי לִשְׁמֹעַ אֶת־הָאִישׁ הַזֶּה וַיֹּאמֶר מָחָר וְאַתָּה תִּשְׁמָעֶנּוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","וַיְהִי מִמָּחֳרָת וַיָּבֹאוּ אַגְרִפַּס וּבֶרְנִיקָה בְּכָבוֹד גָּדוֹל אֶל־בֵּית הַמִּשְׁפָּט עִם־שָׂרֵי הָאֶלֶף וְטוּבֵי הָעִיר וּפֶסְטוֹס צִוָּה וַיּוּבָא פּוֹלוֹס׃ ");
INSERT INTO hebsg_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","וַיֹּאמֶר פֶּסְטוֹס הַמֶּלֶךְ אַגְרִפַּס וְעָל־הָאֲנָשִׁים פֹּה אַתֶּם־הִנְּכֶם רֹאִים אֶת־זֶה אֲשֶׁר עָלָיו צָעֹק יִצְעֲקוּ אֵלַי כָל־הֲמוֹן הַיְּהוּדִים בִּירוּשָׁלַיִם וּבָעִיר הַזֹּאת כִּי־חָיוֹ לֹא יִחְיֶה עוֹד׃ ");
INSERT INTO hebsg_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","וַאֲנִי מָצָאתִי כִּי לֹא־מְאוּם עָשָׂה לְהוּמֹת עַל־כָּכָה וְהוּא גַּם־הוּא קָרָא אֶל־אֲגוּסְטוֹס עַל־כֵּן גָּמַרְתִּי לְשָׁלְחוֹ אֶל־הַקֵּיסָר׃ ");
INSERT INTO hebsg_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","רַע לֹא־יָדַעְתִּי דְבָרִים בְּרֻרִים עַל־אֹדוֹתָיו לְכָתְבָם לַאדֹנִי וּבִגְלַל זֶה הֶעֱמַדְתִּיו לִפְנֵיכֶם וּבְיוֹתֵר לְפָנֶיךָ הַמֶּלֶךְ אַגְרִפַּס וְאַחֲרֵי הִבָּחֲנוֹ אֵדַע מָה אֶכְתֹּב׃ ");
INSERT INTO hebsg_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","כִּי לֹא־כָשֵׁר הַדָּבָר לִשְׁלֹחַ אִישׁ אָסוּר בְּחַבְלֵי חַטָּאתוֹ מִבְּלִי הוֹדַע מָה הִיא חַטָּאתוֹ אֲשֶׁר נֶאֱחָז בָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","וְאַגְרִפַּס אָמַר אֶל־פּוֹלוֹס הִנֵּה נָתוּן לְךָ לְדַבֵּר כֹּל לְמַעַן תִּצְטַדָּק אָז הֵרִים פּוֹלוֹס אֶת־יָדוֹ וַיִּצְטַדֵּק לֵאמֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","הַמֶּלֶךְ אַגְרִפַּס בְּאָשְׁרִי הַיּוֹם לִהְיוֹת תְחִנָּה לְהִצְטַדֵּק לְפָנֶיךָ עַל־כֹּל אֲשֶׁר הַיְּהוּדִים יַרְשִׁיעֻנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","כִּי כָל־חֻקֵּי הַיְּהוּדִים וְחִקְרֵי מִשְׁפְּטֵיהֶם אַתָּה יֹדֵעַ הֵיטֵב וּבְכֵן אֶתְחַנֶּן־לְךָ הַקְשִׁיבָה לִּי בְּאֹרֶךְ רוּחֶךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","אֶת־אָרְחוֹת חַיַּי מֵאָז הַחִלֹּתִי לָלֶכֶת בָּהֶם מִנְּעוּרַי בְּקֶרֶב עַמִּי וּבִירוּשָׁלָיִם כָּל־עַם הַיְּהוּדִים יֹדְעִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","וַאֲשֶׁר מֵעוֹדִי הֵם יַכִּירוּ בִי לוּ יֹאבוּ וִיעִדֻנִי כִּי חָבֵר הָיִיתִי לַעֲדַת הַפְּרוּשִׁים הַדְּבֵקִים בַּתּוֹרָה לְכָל־מִשְׁפָּטֶיהָ וּפִקּוּדֶיהָ בְּכָל־מְאֹדָם וּכְמֹהֶם חָיִיתִי׃ ");
INSERT INTO hebsg_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","וְעַתָּה עַל־דִּבְרַת תּוֹחַלְתִּי לִמְלֹאת דְּבַר הָאֱלֹהִים אֲשֶׁר דִּבֶּר לַאֲבֹתֵינוּ אֲנִי עֹמֵד הַיּוֹם לַמִּשְׁפָּט׃ ");
INSERT INTO hebsg_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","אִם לֹא כָּל־שְׁנֵים עָשָׂר שְׁבָטֵינוּ מְיַחֲלִים כֵּן וּמִתְפַּלְּלִים עַל־כָּכָה לַיְלָה וְיוֹמָם בִּגְלַל הַתּוֹחֶלֶת הַזֹּאת הַמֶּלֶךְ הַיְּהוּדִים יַרְשִׁיעֻנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","הַאֻמְנָם אֵינְכֶם מַאֲמִינִים כִּי אֱלֹהִים מְחַיֶּה מֵתִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","וַאֲנִי גַּם־אֲנִי דִמִּיתִי לְהַכְזִיב אֶת־שֵׁם יֵשׁוּעַ הַנָּצְרִי וּלְמָרֲרֵהוּ הַרְבֵּה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","אֲשֶׁר כֵּן עָשִׂיתִי בִירוּשָׁלַיִם וְרַבִּים מֵהַקְּדוֹשִׁים כִּלֵּאתִי בְּבָתֵּי הַכְּלָאִים בָּרִשְׁיוֹן אֲשֶׁר קִבַּלְתִּי מֵאֵת רָאשֵׁי הַכֹּהֲנִים וְכִי הוּמְתוּ נָתַתִּי צֶדֶק לְמִשְׁפָּטָם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","וּבְכָל־בָּתֵּי־הַכְּנֵסֶת הוֹסַפְתִּי לְיַסְּרָה אֹתָם פְּעָמִים רַבּוֹת וָאַכְבִּיד יָדִי עֲלֵיהֶם עַד־לְחָרֵף וְכֹה בְּשֶׁטֶף אַפִּי הֲצִיקוֹתִי לָהֶם גַּם־בֶּעָרִים מִחוּץ לָאָרֶץ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","לְבַעֲבוּר עֲשׂוֹת כָּכָה הָלַכְתִּי לְדַמָּשֶׂק בְּרִשְׁיוֹן הַכֹּהֲנִים הָרָאשִׁים וּבְמַלְּאָם אֶת־יָדִי׃ ");
INSERT INTO hebsg_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","וַיְהִי בַּדֶּרֶךְ לְעֵת הַצָּהֳרָיִם הַמֶּלֶךְ וְהִנֵּה אוֹר מִן־הַשָּׁמַיִם וְנֹגַהּ לוֹ גָּדוֹל מִנֹּגַהּ הַשֶּׁמֶשׁ וַיִּגַּהּ בַּעֲדֵנִי וּבְעַד הַהֹלְכִים עִמִּי׃ ");
INSERT INTO hebsg_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","אֲנַחְנוּ כֻלָּנוּ נָפַלְנוּ לָאָרֶץ וַאֲנִי שָׁמַעְתִּי קוֹל קֹרֵא אֵלַי בְּעִבְרִית שָׁאוּל שָׁאוּל מַה תִּרְדָּף־לִי קָשֶׁה לְּךָ לְהַכּוֹת הַדָּרְבָן אָחוֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","וָאֹמַר אֲנִי מִי אַתָּה אָדוֹן וַיֹּאמֶר הָאָדוֹן אֲנִי יֵשׁוּעַ אֲשֶׁר אַתָּה רֹדֶף־לִי׃ ");
INSERT INTO hebsg_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","אֲבָל קוּם וַעֲמֹד עַל־רַגְלֶיךָ כִּי עַל־כֵּן נִרְאֵיתִי אֵלֶיךָ לִבְחָר־בְּךָ לִמְשָׁרֵת וְעֵד לַאֲשֶׁר רָאִיתָ וַאֲשֶׁר אַרְאֲךָ עוֹד׃ ");
INSERT INTO hebsg_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","לְהַצִּילְךָ מִן־הָעָם וּמִן־הַגּוֹיִם אֲשֶׁר אֶשְׁלָחֲךָ אֲלֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","לִפְקֹחַ אֶת־עֵינֵיהֶם וְלַהֲשִׁיבָם מֵחשֶׁךְ לְאוֹרָה וּמִשִּׁלְטוֹן הַשָּׂטָן אֶל־הָאֱלֹהִים לְמַעַן יִמְצְאוּ אֶת־סְלִיחַת הַחֲטָאִים וְנַחֲלָה בְּקֶרֶב הַקְּדוֹשִׁים בְּהַאֲמִינָם בִּי׃ ");
INSERT INTO hebsg_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","עַל־כֵּן הַמֶּלֶךְ אַגְרִפַּס לֹא הִמְרֵיתִי בַּמַּרְאֶה אֲשֶׁר הָרְאֵיתִי מִן־הַשָּׁמָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","כִּי אִם־אֶל־הַיּשְׁבִים בְּדַמֶּשֶׂק רִאשׁוֹנָה וּבִירוּשָׁלַיִם וּבְכָל־אֶרֶץ הַיְּהוּדִים וְגַם־לַגּוֹיִם קָרָאתִי לָשׁוּב וּבֹא אֶל־הָאֱלֹהִים בַּעֲשׂה טוֹב כְּיָאוּת לַשָּׁבִים בֶּאֱמֶת׃ ");
INSERT INTO hebsg_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","בַּעֲבוּר זֶה תְּפָשׂוּנִי הַיְּהוּדִים בַּמִּקְדָּשׁ וַיְבַקְשׁוּ לַהֲמִיתֵנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","וּבְעֶזְרִי מֵעִם הָאֱלֹהִים עוֹדֶנִּי חַי עַד־הַיּוֹם הַזֶּה וַאֲנִי מֵעִיד וּמְלַמֵּד בִּפְנֵי קָטֹן וְגָדוֹל רַק אֶת־זֶה אֲשֶׁר גַּם־הַנְּבִיאִים וְגַם־משֶׁה דִּבְּרוּ כִּי־הָיֹה יִהְיֶה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","אֲשֶׁר הַמָּשִׁיחַ יְעֻנֶּה וְרִאשׁוֹן יָקוּם מֵעִם־הַמֵּתִים לְהָאֶר־אוֹר בְּקֶרֶב הָעָם וּבְקֶרֶב הַגּוֹיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","וַיְהִי הוּא כֹה מִצְטַדֵּק וּפֶסְטוֹס קָרָא בְקוֹל רָם מְשֻׁגָּע אַתָּה פּוֹלוֹס זֹה חָכְמָתְךָ הָרַבָּה עָשְׂתָה לְּךָ שִׁגָּעוֹן׃ ");
INSERT INTO hebsg_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","וּפוֹלוֹס אָמַר לֹא פֶּסְטוֹס הַנִּכְבָּד לֹא מְשֻׁגָּע אָנֹכִי כִּי אִם־דִּבְרֵי אֱמֶת נְכֹחִים לְמֵבִין אֲנִי דֹבֵר׃ ");
INSERT INTO hebsg_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","וְהַמֶּלֶךְ אֲשֶׁר שָׂשׂ אֲנִי לְדַבֵּר לְפָנָיו הוּא יֹדֵעַ אֵת אֲשֶׁר דִּבֵּרְתִּי וַאֲנִי נוֹכַחְתִּי כִּי לֹא־נִסְתָּר מִמֶּנּוּ דָּבָר מִכָּל־הַדְּבָרִים הָאֵלֶּה כִי לֹא־בְמַחֲבֵא הָיוּ וְנַעֲלָמִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","הֲמַאֲמִין אַתָּה הַמֶּלֶךְ אַגְרִפַּס בַּנְּבִיאִים אֲנִי יָדַעְתִּי כִּי מַאֲמִין הִנֶּךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","וְאַגְרִפַּס אָמַר אֶל־פּוֹלוֹס בִּמְעַט אַתָּה אֹמֵר לְפַתֹּתֵנִי כִּי־הֱיוֹת אֶהְיֶה מַאֲמִין בִּמְשִׁיחֲךָ כָּמוֹךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","וַיֹּאמֶר פּוֹלוֹס זֹאת שְׁאֵלָתִי מֵאֵת הָאֱלֹהִים כִּי־בִמְעַט אוֹ־בְהַרְבֵּה לֹא אַתָּה לְבַדְּךָ כִּי־אִם גַּם־כָּל־הַשֹּׁמְעִים אֹתִי הַיּוֹם יִהְיוּ כָמֹנִי חוּץ מִן־הַזִּקִּים הָאֵלֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","בְּדַבְּרוֹ הַדָּבָר הַזֶּה וַיָּקָם הַמֶּלֶך וְהַפֶּחָה וּבֶרְנִיקָה וְהַיּשְׁבִים אִתָּם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","וּבְלֶכְתָּם נִדְבְּרוּ אִישׁ אֶל־רֵעֵהוּ וַיֹּאמְרוּ אָכֵן הָאִישׁ הַזֶּה לֹא־עָשָׂה דָבָר לִהְיוֹת לוֹ דִּין רָשָׁע לָמוּת אוֹ לְהֵאָסֵר בַּזִּקִּים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","וַיֹּאמֶר אַגְרִפַּס אֶל־פֶּסְטוֹס שָׁלֹחַ יְשֻׁלַּח הָאִישׁ הַזֶּה אִם־לֹא קָרָא אֶל־הַקֵּיסַר לַעֲשׂוֹת לוֹ מִשְׁפָּטוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","וַיְהִי כִּי־נָכוֹן הַדָּבָר לְהַעֲבִירֵנוּ אִיטַלְיָא וַיִּמָּסֵר פּוֹלוֹס עִם־מִסְפַּר אַסִּירִים אֲחֵרִים עַל־יַד שַׂר־הַמֵּאָה מִצְּבָא אֲגוּסְטוֹס וּשְׁמוֹ יוּלִיּוֹס׃ ");
INSERT INTO hebsg_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","וַנֵּרֶד בָּאֳנִיָּה אַדְרָמִטִּית אֲשֶׁר נְשָׁאתְנוּ עַל־פְּנֵי עָרֵי הַיָּם בְּאַסְיָא וַנַּעֲבֹר וְאִתָּנוּ בְּחֶבְרָתֵנוּ אֲרִסְטַרְכוֹס הַמַּקְדּוֹנִי מִתַּסְלוֹנִיקִי׃ ");
INSERT INTO hebsg_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","וּמִמָּחֳרָת בָּאנוּ אֶל־צִידוֹן וְיוּלִיּוֹס הִתְחַסֵּד עִם־פּוֹלוֹס וַיִּתְּנֵהוּ לָלֶכֶת אֶל־אֹהֲבָיו לְהָשִׁיב נַפְשׁוֹ עַל־יָדָם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","וַנַּעֲבֹר מִזֶּה וַנָּסָב מִנֶּגֶד לָאִי קַפְרוֹס יַעַן הָלַךְ הָרוּחַ אֶל־עֵבֶר פָּנֵינוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","אַחַר־כֵּן עָבַרְנוּ בַיָּם מִמּוּל קִילִיקְיָא וּפַמְפּוּלְיָא וַנָּבֹא אֶל־מוּרָא אֲשֶׁר בְּלוּקְיָא׃ ");
INSERT INTO hebsg_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","וְשָׁם מָצָא שַׂר־הַמֵּאָה אֳנִיָּה אֲלֶכְסַנְדְּרִית מֻעֶדֶת לְאִיטַלְיָא וַיִּקָּחֵנוּ וַיְבִיאֵנוּ אֵלֶיהָ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","רַק אֳנִיָּתֵנוּ הִתְנַהֲלָה לְאִטָּהּ יָמִים רַבִּים וּבִיגִיעָה הִגַּעְנוּ עַד־לִפְנֵי קְנִידוֹס וְהָרוּחַ לֹא נְתָנָנוּ לְקָרְבָה אֶל־הַחוֹף וַנַּעֲבֹר אֵצֶל קְרֵיטִי מִמּוּל סַלְמוֹנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","וְכֹה הָיִינוּ עֲמֵלִים לֶאֱחֹז דַּרְכֵּנוּ עַל־פְּנֵי הַחוֹף לְאָרְכּוֹ עַד־בֹּאֵנוּ אֶל־הַמָּקוֹם אֲשֶׁר קֹרָא לוֹ יְפֵה־מְבוֹא־יָם וּקְרוֹבָה לוֹ הָעִיר לָסִּיָּא׃ ");
INSERT INTO hebsg_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","וַיִּרְבּוּ בֵּין כֹּה וָכֹה הַיָּמִים וְיוֹרְדֵי הַיָּם לֹא יַעַבְרוּ עוֹד לָבֶטַח כִּי גַם־הַצוֹם כְּבָר עָבָר וַיַּזְהִירֵם פּוֹלוֹס׃ ");
INSERT INTO hebsg_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","וַיֹּאמֶר אֲלֵיהֶם אַתֶּם אֲנָשִׁים הִנֵּה אֲנִי רֹאֶה כִּי עַל־דַּרְכֵּנוּ הַזֶּה רָעָה נִשְׁקֶפֶת לְסַבֵּב נֶזֶק גָּדוֹל וְלֹא רַק לָאֳנִיָּה וּלְמַשָּׂאָהּ יֵשׁ דְּאָגָה כִּי אִם־גַּם לְנַפְשֹׁתֵינוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","וְשַׂר הַמֵּאָה שָׁמַע אֶל־רַב הַחֹבֵל וְאֶל־בַּעַל הָאֳנִיָּה וְאֶל־דִּבְרֵי פוֹלוֹס לֹא־שָׁמַע׃ ");
INSERT INTO hebsg_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","וּבִהְיוֹת מְבוֹא הַיָּם לֹא טוֹב לַחֲרָף־בּוֹ עַל־כֵּן יָעֲצוּ רֻבֵּי הָאֲנָשִׁים לַחֲלֹף מִזֶּה בְּחָשְׁבָם אוּלַי עוֹד יוּכְלוּ לְהַגִּיעַ עַד־לְפֵינִיכַס לַחֲרָף־שָׁם וְהוּא מְבוֹא הַיָּם בִּקְרֵיטִי בְּקֶרֶן מַעֲרָב הַנּוֹטֶה גַּם־לְצָפוֹן וְגַם־לְדָרוֹם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","וְיַעַן כִּי־נָשַׁב רוּחַ מִדָּרוֹם רַק לְאָט עַל־כֵּן קִוּוּ לְהַגִּיעַ עַד־מְחוֹז חֶפְצָם וַיַּעֲלוּ אֶת־הָעוֹגִינִים וַיַּעַבְרוּ מִקָּרוֹב לִשְׂפַת קְרֵיטִי׃ ");
INSERT INTO hebsg_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","וַיְהִי מַהֵר אַחֲרֵי־כֵן וַיִּסְעַר סַעַר גָּדוֹל אֶל־מוּל הָאִי וְשֵׁם הַסַּעַר הַהוּא נִקְרָא אַוְרִיקְלִידוֹן׃ ");
INSERT INTO hebsg_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","וְהָאֳנִיָּה סֹעֲרָה וַתֻּדָּח וּמֵאֲשֶׁר לֹא עָצְרָה כֹּחַ לַעֲמֹד בִּפְנֵי הַסַּעַר עַל־כֵּן אָסַפְנוּ אֶת־יָדֵינוּ מֵעָבְדָהּ לְמַעַן תֵּלֵךְ אֶל־אֲשֶׁר יַתְעֶנָּה הַסָּעַר׃ ");
INSERT INTO hebsg_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","כֹּה עָבְרָה דְחוּפָה בִמְרוּצָתָהּ לְצֵלַע אִי־קָטֹן הַנִּקְרָא קְלַאוּדָה וּבְדֵי־עָמָל הֶחֱזַקְנוּ בַסְּפִינָה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","אֹתָהּ מָשְׁכוּ אֲלֵיהֶם וַיְכוֹנְנוּ תַחְבֻּלוֹת לְעֶזְרָה וַיְחַבְּשׁוּ אֶת־הָאֳנִיָּה בַּעֲבֹתִים וּמִיִּרְאָתָם פֶּן־תּוּטַל עַל־רֻכְסֵי הַחוֹל הוֹרִידוּ אֶת־הַמִּפְרָשִׂים וַנַּעֲבֹר הָלְאָה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","וְכַאֲשֶׁר טֻלְטַלְנוּ בַסַּעַר אָנֶה וָאָנֶה טַלְטֵלָה נוֹרָאָה מְאֹד הֵחֵלוּ מִמָּחֳרָת לְהָקֵל עַל־הָאֳנִיָּה וַיַּטִּילוּ אֶת־כָּל־הַמַּשָּׂא אֶל־הַיָּם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","וּבַיּוֹם הַשְּׁלִישִׁי הֵטִילוּ בִידֵיהֶם גַּם אֶת־כָּל־כְּלֵי הָאֳנִיָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","וְיָמִים מִסְפָּר אֲשֶׁר אֵין שֶׁמֶשׁ בַּיּוֹם וְיָרֵחַ וְכוֹכָבִים בַּלַּיְלָה וְהַסַּעַר הוֹלֵךְ וְזֹעֵף אָז אָבְדָה גַּם־שְׁאֵרִית תִּקְוָתֵנוּ לְהִנָּצֵל׃ ");
INSERT INTO hebsg_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","וּבַאֲשֶׁר מָנְעוּ כֻלָּם אֹכֶל מִפִּיהֶם וַיַּעֲמֹד פּוֹלוֹס בְּתוֹכָם וַיֹּאמַר אַתֶּם אֲנָשִׁים טוֹב הֱיִיתֶם עֹשִׂים אִם־לַעֲצָתִי שְׁמַעְתֶּם לִבְלִי־עֲזֹב אֶת־קְרֵיטִי כִּי אָז לֹא הִשִּׂיגָנוּ הַנֶּזֶק הַזֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","וְעַתָּה אֲאַמִּצְכֶם בְּמוֹ־פִי לֹא תִתְמוֹגְגוּ וְלֹא תִמַּסּוּ כִּי גַם־נֶפֶשׁ אַחַת מִכֶּם כֻּלְּכֶם לֹא־תֹאבַד זוּלָתִי רַק הָאֳנִיָּה לְבַדָּהּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","כִּי־בַלַּיְלָה הַזֶּה נִרְאָה אֵלַי מַלְאַךְ הָאֱלֹהִים אֲשֶׁר־לוֹ אֲנִי וְאֹתוֹ אֶעֱבֹד׃ ");
INSERT INTO hebsg_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","וַיֹּאמַר אַל־תִּירָא שָׁאוּל כִּי לִפְנֵי הַקֵּיסַר תִּתְיַצֵּב וְהָאֱלֹהִים נָתַן־לְךָ מַתָּנָה נַפְשׁוֹת כָּל־הָעֹבְרִים עִמָּךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","לָכֵן הִתְחַזְּקוּ־נָא אַתֶּם אֲנָשִׁים וַאֲנִי בֵּאלֹהִים בָּטַחְתִּי כִּי כַאֲשֶׁר הֻגַּד לִי כֵּן גַּם־יֶהִי׃ ");
INSERT INTO hebsg_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","וְאוּלָם אֶל־אַחַד הָאִיִּים נִדָּחֶה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","וּבְלֵיל הָאַרְבָּעָה עָשָׂר מֵאָז הָשְׁלַכְנוּ כֹה וָכֹה בְּיַם אַדְרִיָּה בַּחֲצִי הַלָּיְלָה וְלֵב הַמַּלָּחִים אָמַר לָהֶם כִּי־הָאֳנִיָּה קָרְבָה לְיַבֶּשֶׁת אָרֶץ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","וַיּוֹרִידוּ אֶת־הָעֹפֶרֶת וַיַּעֲלוּ וַיִּמְצְאוּ מִדַּת הָעֹמֶק עֶשְׂרִים קוֹמָה וַיִּרְחֲקוּ מְעַט וַיִּשְׁנוּ עוֹד וַיִּמְצְאוּ רַק קוֹמוֹת חֲמֵשׁ עֶשְׂרֵה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","אַךְ הֵם יָרְאוּ פֶּן־יִפְגְּעוּ בְצוּרֵי מִכְשׁוֹל וַיַּשְׁלִיכוּ מֵאֲחֹרֵי הָאֳנִיָּה אַרְבָּעָה עוֹגִינִים וַיּוֹחִילוּ לְאוֹר הַבֹּקֶר׃ ");
INSERT INTO hebsg_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","וְהַמַּלָּחִים יָזְמוּ לִבְרֹחַ מֵעַל הָאֳנִיָּה וַיִּגְּשׁוּ לְהַתִּיר אֶת־הָעֲבָרָה וּלְהוֹרִידָהּ בְּהַעֲרִימָם לֵאמֹר כִּי גַּם־מֵרֹאשׁ הָאֳנִיָּה יוֹרִידוּ אֶת־הָעוֹגִינִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","אֲבָל פּוֹלוֹס אָמַר אֶל־שַׂר הַמֵּאָה וְאֶל־אַנְשֵׁי הַצָּבָא אִם־אֵלֶּה לֹא יִוָּתְרוּ בָאֳנִיָּה לֹא תוּכְלוּ לְהִנָּצֵל׃ ");
INSERT INTO hebsg_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","אָז כָּרְתוּ אַנְשֵׁי הַצָּבָא אֶת־מֵיתְרֵי הָעֲבָרָה וְהִיא נָפְלָה אֶל־הַיָּם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","וּבְטֶרֶם אוֹר הַבֹּקֶר הִפְצִיר בָּם פּוֹלוֹס לִבְרוֹת לֶחֶם אָמֹר לָהֶם זֶה הַיּוֹם הָאַרְבָּעָה עָשָׂר אֲשֶׁר אַתֶּם נַעֲנִים מִבִּלְתִּי אֲכֹל אוֹ טְעֹם מְאוּמָה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","עַל־כֵּן אֲנִי מַפְצִיר בָּכֶם לִסְעַד לִבְּכֶם וּבָזֹאת תִּנָּצֵלוּ כִּי לֹא־יִפֹּל מִשַּׂעֲרוֹת רֹאשְׁכֶם כֻּלְּכֶם אַף־אֶחָד אָרְצָה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","וְאַחֲרֵי דַבְּרוֹ כָזֹאת לָקַח לֶחֶם וַיּוֹדֶה עָלָיו לֵאלֹהִים לִפְנֵי כֻלָּם וַיִּפְרֹס וַיָּחֶל לֶאֱכֹל׃ ");
INSERT INTO hebsg_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","וַתְּחִי רוּחַ כֻּלָם וַיִּקְחוּ לֶחֶם גַּם־הֵם וַיֹּאכֵלוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","וְכָל־מִסְפַּר הָאֲנָשִׁים אֲשֶׁר בָּאֳנִיָּה מָאתַיִם וְשִׁבְעִים נֶפֶשׁ וְשֵׁשׁ נְפָשׁוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","וַיְהִי אַחֲרֵי אָכְלָם לְמַלֵּא נַפְשָׁם הֵקֵלּוּ עוֹד מֵעַל הָאֳנִיָּה וַיַּשְׁלִיכוּ גַם־אֶת־הַצֵּדָה אֶל־הַיָּם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","הַבֹּקֶר הָיָה וְהֵם לֹא־הִכִּירוּ אֶת־הָאָרֶץ כִּי אִם־רָאוּ לְשׁוֹן־יָם וְחוֹף רְחַב יָדָיִם וַיִּוָּעֲצוּ לְהָבִיא שָׁם אֶת־הָאֳנִיָּה אִם־יוּכָלוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","וַיְקַצְּצוּ אֶת־הָעוֹגִינִים לְעָזְבָם בַּיָּם גַּם־הִתִּירוּ אֶת־הַמְּשׁוֹטִים מִמַּאֲסָרָם וַיִּפְרְשׂוּ אֶת־הַמִּפְרָשׂ לִפְנֵי הָרוּחַ לְהָרִיץ אֶת־הָאֳנִיָּה אֶל־הַחוֹף׃ ");
INSERT INTO hebsg_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","וְהָאֳנִיָּה נֶהְדְּפָה עַל־מָקוֹם לֹא־עָמוֹק תַּחְתֶּיהָ וַיִּדְבַּק רֹאשָׁהּ בַּקַּרְקַע מִבְּלִי לָמוּשׁ וְגַלֵּי הַיָּם הֵנִיעוּ בְחֵילָם אֶת־אֲחוֹרֶיהָ וַתִּשָּׁבֵר לִשְׁבָרִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","וַיֹּאמְרוּ אַנְשֵׁי הַצָּבָא לַהֲרֹג אֶת־הָאַסִּירִים פֶּן־יִשְׂחוּ בַמַּיִם וְיִמָּלֵטוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","וְשַׂר הַמֵּאָה בְּחֶפְצוֹ לְהַצִּיל אֶת־פּוֹלוֹס לֹא נְתָנָם לְבַצַּע מְזִמָּתָם וְגַם־צִוָּה מִי הַיֹּדֵעַ לִשְׂחוֹת יִתְנַפֵּל רִאשֹׁנָה אֶל־הַמַּיִם לְהִנָּצֵל אֶל־הַיַּבָּשָׁה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","וְהַנִּשְׁאָרִים יַחֲזִיקוּ בִקְרָשִׁים וּשְׁאָר שִׁבְרֵי הָאֳנִיָּה לְהַצִּיל אֶת־נַפְשָׁם וַיְהִי כֵן וַיִּמָּלְטוּ כֻלָּם אֶל־הַיַּבָּשָׁה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","וְאַחֲרֵי אֲשֶׁר נִמְלַטְנוּ שָׁמַעְנוּ כִּי מְלִיטִי שֵׁם הָאִי הַזֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","וְהַלֹּעֲזִים הֵטִיבוּ עִמָּנוּ עַד־לִמְאֹד כִּי־בִעֲרוּ אֵשׁ לְהָחֶם־לָנוּ וַיַּאַסְפוּ אֶת־כֻּלָּנוּ אֲלֵיהֶם מִפְּנֵי הַגֶּשֶׁם אֲשֶׁר הֶאֱרִיךְ לָרֶדֶת וּמִפְּנֵי הַקֹּר׃ ");
INSERT INTO hebsg_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","וּפוֹלוֹס אָסַף מְלֹא יָדָיו נְצָרִים וַיִּתְּנֵם עַל־הַמּוֹקֵד וְהִנֵּה הִשְׂתָּרֵג צֶפַע עַל־יָדוֹ בְּפִגְעוֹ־בָהּ בְּנוּסוֹ מִפְּנֵי הַחֹם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","כִּרְאֹת הַלֹּעֲזִים אֶת־הַזֹּחֵל מְצֻמָּד עַל־יָדוֹ וַיֹּאמְרוּ אִישׁ אֶל־רֵעֵהוּ אָכֵן רֹצֵחַ הוּא הָאִישׁ הַזֶּה כִּי נִקְמַת הָאֱלֹהִים דְּבָקַתּוּ לְבִלְתִּי הַחֲיֹתוֹ אַחֲרֵי כִּי־נִצַּל מִמּוּת בַּיָּם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","אֲבָל הוּא הִשְׁלִיךְ אֶת־הַזֹּחֵל אֶל־הָאֵשׁ וְלוֹ לֹא־נֶעֶשְׂתָה מְאוּמָה רָע׃ ");
INSERT INTO hebsg_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","וְהֵם עוֹד מְחַכִּים לִרְאוֹת כִּי יִצְבֶּה בְשָׂרוֹ אוֹ כִי יִפֹּל וָמֵת וּכְחַכּוֹתָם כֹּה־עַד־בּוֹשׁ וַיִרְאוּ כִּי לֹא־נָגְעָה בּוֹ רָעָה אָז חָשְׁבוּ אַחֶרֶת וַיֹּאמְרוּ אֱלֹהִים הוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","וּבְקִרְבַת הַמָּקוֹם הַהוּא הָיְתָה אֲחֻזַּת־שָׂדֶה לִקְצִין הָאִי וּשְׁמוֹ פּוֹבְלִיּוֹס וְהוּא לְקָחָנוּ אֵלָיו וַיְכַלְכְּלֵנוּ בְּלֵב טוֹב שְׁלֹשָׁה יָמִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","וַיְהִי אֲבִי פוֹבְלִיּוֹס נֹפֵל לַמִּשְׁכָּב בַּחֲלֹתוֹ בַקַּדַּחַת וּבַחֲלִי הַמֵּעָיִם וַיָּבֹא אֵלָיו פּוֹלוֹס וַיִּתְפַּלֵּל בַּעֲדוֹ וַיָּשֶׂם יָדָיו עָלָיו וַיִּרְפָּאֵהוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","וְאַחֲרֵי עֲשׁתוֹ כָזֹאת בָּאוּ אֵלָיו גַּם־מִכָּל־הָאִי אֲשֶׁר לָהֶם כָּל־חֹלִי וְגַם־הֵם נִרְפָּאוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","וַיִּתְּנוּ לָנוּ מַתָּנוֹת רַבּוֹת וּבְעָבְרֵנוּ מֵהֶם מִלְאוּ לָנוּ כָּל־מַחְסֹרֵינוּ עַל־הַדָּרֶךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","וְאַחֲרֵי שְׁלֹשָׁה חֳדָשִׁים עָבַרְנוּ מִשָּׁם בָּאֳנִיָּה אֲלֶכְסַנְדְּרִית אֲשֶׁר שָׁבְתָה שָּׁם כָּל־יְמוֹת הַחֹרֶף וְהִיא נֹשֵׂאת אוֹת עַל־נִסָּהּ תְּאוֹמִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","וַנָּבֹא אֶל־סַרְקוּסָא וַנֵּשֶׁב־שָׁם שְׁלֹשָׁה יָמִים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","מִשָּׁם עָבַרְנוּ וַנָּסָב וַנָּבֹא אֶל־רֶגְיוֹן וּבִנְסֹעַ מִמָּחֳרָת רוּחַ מִדָּרוֹם בָּאנוּ בַיּוֹם הַשֵּׁנִי אֶל־פּוֹטִיּוֹלִי׃ ");
INSERT INTO hebsg_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","שָׁם מָצָאנוּ אַחִים וְהֵם שִׁחֲרֻנוּ לָשֶׁבֶת אִתָּם שִׁבְעָה יָמִים וְאַחַר־כֵּן הָלַכְנוּ לָבֹא רוֹמִי׃ ");
INSERT INTO hebsg_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","וַיִּשְׁמְעוּ שָׁם הָאַחִים כִּי אֲנַחְנוּ בָאִים וַיֵּצְאוּ לִקְרָאתֵנוּ עַד־שַׁעַר אַפִּיּוֹס וְעַד־שְׁלֹשֶׁת מְלוֹנִים וּפוֹלוֹס רָאָה אֹתָם וַיְבָרֶךְ אָת־הָאֱלֹהִים וַתְּחִי רוּחוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","כְּבֹאֵנוּ רוֹמִי מָסַר שַׂר הַמֵּאָה אֶת־הָאֲסִירִים אֶל־יַד שַׂר צְבָא שֹׁמְרֵי רֹאשׁ הַקֵּיסָר וְרַק פּוֹלוֹס הֻחַן בְּחֶסֶד לָשֶׁבֶת לְבַדּוֹ עִם־אִישׁ צָבָא אֶחָד לְשָׁמְרוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","וַיְהִי אַחֲרֵי שְׁלֹשֶׁת יָמִים וַיִּקְרָא אֵלָיו אֶת־רָאשֵׁי הַיְּהוּדִים וּבְבֹאָם אָמַר אֲלֵיהֶם אֲנָשִׁים אַחִים אַף כִּי־לֹא פָשַׁעְתִּי בְעַמִּי וּמִתּוֹרֹת אֲבוֹתֵינוּ לֹא רָשַׁעְתִּי בְּכָל־זֹאת אֲסָרוּנִי בִירוּשָׁלַיִם וַיִּתְּנוּנִי בִּידֵי הָרוֹמִיִּים׃ ");
INSERT INTO hebsg_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","וְהֵם בְּחָנוּנִי חֲקָרוּנִי וַיְבַקְשׁוּ לְשַׁלְּחֵנִי לַמֶּרְחָב יַעַן לֹא־נִמְצָא בִי חֵטְא מִשְׁפָּט־מָוֶת׃ ");
INSERT INTO hebsg_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","וְהַיְּהוּדִים הִקְשׁוּ לְשִׂטְנִי עַל־כֵּן הָיִיתִי אָנוּס לִקְרֹא אֶל־הַקֵּיסָר רַק לֹא־לְהַלְשִׁין אֶת־עַמִּי עַל־דָּבָר׃ ");
INSERT INTO hebsg_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","בִּגְלַל הַדָּבָר הַזֶּה קָרָאתִי אֶתְכֶם אֵלַי לִרְאֹתְכֶם וּלְדַבֵּר אִתְּכֶם לְמַעַן תִּקְוַת יִשְׂרָאֵל אֲנִי אָסוּר בַּכֶּבֶל הַזֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","וַיֹּאמְרוּ אֵלָיו לֹא אִגְּרוֹת בָּאוּנוּ מִיהוּדָה וְאַף לֹא־אֶחָד מִן־הָאַחִים בָּא לְהוֹדִיעַ עָלֶיךָ אוֹ לְדַבֶּר־בְּךָ דָּבָר רָע׃ ");
INSERT INTO hebsg_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","וְעַתָּה הִנֵּה אֲנַחְנוּ מְבַקְשִׁים לִשְׁמֹעַ מִפִּיךָ אֶת־אֲשֶׁר עִם־לִבֶּךָ בְּשֶׁכְּבָר שָׁמֹעַ שָׁמַעְנוּ עַל־הַמִּפְלַגָּה הַזֹּאת כִּי יַמְרוּהָ בְּכָל־הַמְּקוֹמוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","וַיַּקְדִּישׁוּ לוֹ יוֹם מוֹעֵד וּבַיּוֹם הַהוּא בָּאוּ אֵלָיו רַבִּים אֶל־בֵּית מְלוֹנוֹ אָז דִּבֶּר אֲלֵיהֶם אֶת־דִּבְרֵי מַלְכוּת הָאֱלֹהִים בַּאֵר הֵיטֵב גַּם־הוֹכִיחַ לְמַכְבִּיר עַל־אֱמֶת יֵשׁוּעַ מִתּוֹרַת משֶׁה וְהַנְּבִיאִים מֵהַבֹּקֶר עַד־הָעָרֶב׃ ");
INSERT INTO hebsg_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","וַיִּהְיוּ בָהֶם אֲשֶׁר הָפְנוּ לְהַאֲמִין בִּדְבָרָיו וַאֲשֶׁר פָּנוּ מֵעִמּוֹ וְלֹא הֶאֱמִינוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","וַיָּשׁוּבוּ לָלֶכֶת וְהֵם נְדוֹנִים עַל־אֹדוֹתָיו וּפוֹלוֹס דִּבֶּר עוֹד רַק אֶת־הַדְּבָרִים הָאֵלֶּה הֵיטֵב דִּבֶּר רוּחַ הַקֹּדֶשׁ עַל־פִּי יְשַׁעְיָהוּ הַנָּבִיא לַאֲבֹתֵיכֶם לֵאמֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","לֵךְ וְאָמַרְתָּ לָעָם הַזֶּה שִׁמְעוּ שָׁמוֹעַ וְאַל־תָּבִינוּ וּרְאוּ רָאוֹ וְאַל־תֵּדָעוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","כִּי שָׁמֵן לֵב־הָעָם הַזֶּה וְאָזְנָיו כָּבְדוּ מִשְּׁמוֹעַ וְאֶת־עֵינָיו הֵשַׁע פֶּן־יִרְאֶה בְעֵינָיו וּבְאָזְנָיו יִשְׁמָע וּלְבָבוֹ יָבִין וָשָׁב וְאֶרְפָּאֵהוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","לָכֵן דְּעוּ כִּי אֶל־הַגּוֹיִם נִשְׁלְחָה תְּשׁוּעַת אֱלֹהִים וְהֵם יִשְׁמָעוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","הוּא כִּלָּה לְדַבֵּר וְהַיְּהוּדִים הָלְכוּ מֵעָלָיו בְּתֹכְחוֹת דְּבָרִים בִּינֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","וְהוּא יָשַׁב שְׁתַּיִם שָׁנִים תְּמִימוֹת בִּמְעֹנָתוֹ אֲשֶׁר שְׂכָרָהּ לוֹ וַיְקַבֵּל אֶת־כָּל־אֲשֶׁר בָּאוּ אֵלָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","וַיִּקְרָא אֶת־מַלְכוּת הָאֱלֹהִים וַיְלַמֵּד אֶת־דַּרְכֵי יֵשׁוּעַ הַמָּשִׁיחַ אֲדֹנֵינוּ בְּלֵב אֱמוּנִים בְּאֵין מַפְרִיעַ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","פּוֹלוֹס עֶבֶד יֵשׁוּעַ הַמָּשִׁיחַ שָׁלִיחַ נִבְחָר וּמְקֻדָּשׁ לְבַשֵּׂר אֶת־בְּשׁרַת הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","אֲשֶׁר מִקֶּדֶם הִגִּיד אֹתָהּ עַל־פִּי נְבִיאָיו בְּכִתְבֵי הַקֹּדֶשׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","עַל־דְּבַר בְּנוֹ אֲשֶׁר יָצָא מִזֶּרַע דָּוִד לְפִי בְשָׂרוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","וְהוּכַן בֶּן־הָאֱלֹהִים בִּגְבוּרָה לְפִי רוּחַ הַקֹּדֶשׁ בַּהֲקִיצוֹ מִן־הַמֵּתִים הוּא יֵשׁוּעַ הַמָּשִׁיחַ אֲדֹנֵינוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","וְעַל־יָדוֹ נִתַּן לָנוּ חֵן וּמַלְאֲכוּת־יָהּ לְהַטּוֹת אֶת־לֵב כָּל־הַגּוֹיִם לָאֱמוּנָה בַּעֲבוּר שְׁמוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","וּבְתוֹכָם הִנְּכֶם גַּם־אַתֶּם קְרִיאֵי יֵשׁוּעַ הַמָּשִׁיחַ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","כָּל־הַקָּהָל בְּרוֹמִי יְדִידֵי אֱלֹהִים בְּחִירָיו וּקְדֹשָׁיו חֶסֶד וְשָׁלוֹם יִתֵּן לָכֶם אֱלֹהִים אָבִינוּ וְיֵשׁוּעַ הַמָּשִׁיחַ אֲדֹנֵינוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","בְּפֵתַח דְּבָרַי אוֹדֶה אֶת־אֱלֹהַי בְּיֵשׁוּעַ הַמָּשִׁיחַ בְּעַד־כֻּלְכֶם כִּי אֱמוּנַתְכֶם שָׁמְעָה בְּכָל הָעוֹלָם׃ ");
INSERT INTO hebsg_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","וְהָאֱלֹהִים אֲשֶׁר בִּבְשׁרַת בְּנוֹ אֲנִי עֹבֵד אֹתוֹ בְּרוּחִי וְנַפְשִׁי הוּא עֵדִי כִּי לֹא־חָדַלְתִּי מֵהַזְכִּיר אֶתְכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","וּמַעְתִּיר אֲנִי תָמִיד בִּתְפִלּוֹתַי לְמָתַי אֵפוֹא אַצְלִיחַ דַּרְכִּי בִּרְצוֹן אֱלֹהַי לָבוֹא אֲלֵיכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","כִּי־נִכְסֹף נִכְסַפְתִּי לִרְאֹתְכֶם וּלְהַאֲצִיל מִן־מַתְּנַת הָרוּחַ עֲלֵיכֶם לְהוֹסִיף לָכֶם אֹמֶץ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","וְגַם־כֵּן לְהִתְנַחֵם עִמָּכֶם יַחְדָּו בֶּאֱמוּנַת אִישׁ וְאִישׁ מִמֶּנּוּ כְּמוֹכֶם כָּמֹנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","וְאֵין־נַפְשִׁי לְהַעֲלִים מִכֶּם אַחַי כִּי־רַבּוֹת נָתַתִּי אֶת־לִבִּי לָבוֹא אֲלֵיכֶם לִמְצֹא לִי מְעַט פְּרִי גַם־בָכֶם כְּמוֹ גַם־בְּיֶתֶר הַגּוֹיִם וְנִמְנַעְתִּי עַד־עָתָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","הִנֵּה בַּעַל חוֹב אֲנִי לִבְנֵי הַיְּוָנִים וְגַם־לִבְנֵי עַם לֹעֵז לִבְנֵי בִינָה וְלִבְנֵי בְלִי־בִינָה׃ ");
INSERT INTO hebsg_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","וּבְכֵן נָכוֹן אֲנִי לְפִי יְכָלְתִּי לְהַגִּיד אֶת־הַבְּשׁרָה גַּם־לָכֶם בְּנֵי רוֹמִי׃ ");
INSERT INTO hebsg_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","כִּי לֹא־אֵבוֹשׁ מִבְּשׁרַת הַמָּשִׁיחַ אֲשֶׁר גְּבוּרַת אֱלֹהִים הִיא לִתְשׁוּעָה אֶל־כָּל־מַאֲמִין הַיְּהוּדִי בְּרֹאשׁ וְגַם־הַיְּוָנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","כִּי־בָהּ נִגְלְתָה צִדְקַת אֱלֹהִים מִמְּקוֹר אֱמוּנָה לְמַעַן נִחְיֶה בֶאֱמוּנָה כַּכָּתוּב וְצַדִּיק בֶּאֱמוּנָתוֹ יִחְיֶה׃ ");
INSERT INTO hebsg_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","וַחֲרוֹן אֱלֹהִים מִשָּׁמַיִם נִשְׁקָף עַל־עֹשֵׂי רִשְׁעָה וּבְנֵי עַוְלָה הַכֹּבְשִׁים אֶת־הָאֱמֶת בְּעַוְלָתָה׃ ");
INSERT INTO hebsg_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","כִּי דַּעַת אֱלֹהִים בְּרוּרָה בְקִרְבָּם כִּי גִלָּה לָהֶם אֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","כִּי חֶבְיוֹן עֻזּוֹ נֵצַח גְּבוּרָתוֹ וֵאלֹהוּתוֹ נוֹדְעוּ וְיָצְאוּ לָאוֹרָה עַל־יְדֵי פְעֻלּוֹתָיו מִיּוֹם בְּרֹא אֶרֶץ וְשָׁמָיִם עַד־כִּי אֵין־לָהֶם פֶּה לְהִצְטַדָּק׃ ");
INSERT INTO hebsg_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","כִּי יֹדְעִים הֵם אֶת־הָאֱלֹהִים וְלֹא נָתְנוּ לוֹ כְבוֹדוֹ אַף־לֹא הוֹדוּ לוֹ כִּי אִם־בְּמוֹעֲצוֹתֵיהֶם יֶהְבָּלוּ וְלִבָּם הַנִּבְעָר הָלַךְ חֲשֵׁכִים׃ ");
INSERT INTO hebsg_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","יִתְאַמְּרוּ כִּי חֲכָמִים הֵם עַל־כֵּן נִבְעָרוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","וַיָּמִירוּ כְבוֹד אֲדֹנָי אֵל עוֹלָם בִּדְמוּת תַּבְנִית אָדָם בֶּן־תְּמוּתָה וְתַבְנִית עוֹף הַשָּׁמַיִם וְהוֹלֵךְ עַל־אַרְבַּע וְרֶמֶשׂ הָאֲדָמָה׃ ");
INSERT INTO hebsg_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","עַל־כֵּן אֱלֹהִים הִסְגִּירָם בְּיַד שְׁרִרוּת לִבָּם לְטֻמְאָה וּלְחַלֵּל בְּשָׂרָם הֵם בֵּינֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","אֲשֶׁר הֵמִירוּ אֱלֹהֵי אֱמֶת בַּשָּׁקֶר וַיִּירְאוּ וַיַּעַבְדוּ אֶת־הַנּוֹצָר עַל־פְּנֵי הַיּוֹצֵר בָּרוּךְ הוּא לְעוֹלָם וָעֶד אָמֵן׃ ");
INSERT INTO hebsg_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","בַּעֲבוּר זֹאת הִסְגִּירָם אֱלֹהִים בְּיַד קְלוֹן תְּשׁוּקָתָם כִּי גַּם־נְשֵׁיהֶם הֶחֱלִיפוּ אֹרַח חֻקָּתָן בְּאֹרַח זָר׃ ");
INSERT INTO hebsg_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","כַּאֲשֶׁר גַּם־הַגְּבָרִים חָדְלוּ מִבּוֹא אֶל־הַנָּשִׁים כְּדֶרֶךְ כָּל־הָאָרֶץ וַתִּבְעַר־בָּם אֵשׁ תַּאֲוָתָם אִישׁ אֶל־רֵעֵהוּ וְגֶבֶר בְּגֶבֶר יִתְעַלְּלוּ לְקִיקָלוֹן וְעֵקֶב תַּעְתֻּעֵיהֶם לָקְחוּ דֵי־גְמוּל בְּנַפְשׁוֹתָם׃ ");
INSERT INTO hebsg_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","וְכַאֲשֶׁר לֹא חָפְצוּ הַשְׂכֵּל וְיָדֹעַ אֶת־הָאֱלֹהִים כֵּן עֲזָבָם בִּמְשׁוּבַת לִבָּם לַעֲשׂוֹת אֵת אֲשֶׁר־לֹא יֵעָשֶׂה׃ ");
INSERT INTO hebsg_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","עַד אֲשֶׁר מָלְאוּ כָּל־עַוְלָה זְנוּת רֶשַׁע בֶּצַע וָאָוֶן וְגַם־קִנְאָה וְרֶצַח מָדוֹן וּרְמִיָּה וּמְזִמָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","כֻּלָּם מַלְשִׁינִים וְהֹלְכֵי רָכִיל שׁנְאֵי אֱלֹהִים וְהוֹלְלִים גֵּאִים וּרְהָבִים חָרָשֵׁי מַשְׁחִית וּמַמְרִים לְהוֹרֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","חַסְרֵי דַּעַת וּמְפִירֵי בְרִית אַכְזָרִים נֹטְרֵי שִׂנְאָה אֲשֶׁר חֲנִינָה לֹא יֵדָעוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","וְהֵם אַף־כִּי יֹדְעִים מִשְׁפַּט אֱלֹהִים כִּי־הָעֹשִׂים מַעֲשִׂים כָּאֵלֶּה בְּנֵי־מָוֶת הֵם בְּכָל־זֹאת לֹא לְבַד כִּי יַעֲשׂוּם כִּי־אִם גַּם־יְאַשְּׁרוּן עוֹד עֹשֵׂיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","עַל־כֵּן בֶּן־אָדָם קָטֹן אוֹ גָדוֹל אֵין צְדָקָה לְךָ לִהְיוֹת שֹׁפֵט כִּי בַדָּבָר אֲשֶׁר תַּרְשִׁיעַ אֶת־רֵעֲךָ תַּרְשִׁיעַ גַּם אֶת־נַפְשְׁךָ אַחֲרֵי אֲשֶׁר גַּם־אַתָּה הַשֹּׁפֵט עָשִׂיתָ כְּמַעֲשֵׂהוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","וַאֲנַחְנוּ הֲלֹא יָדַעְנוּ כִּי בְּמֵישָׁרִים יִשְׁפֹּט אֱלֹהִים כָּל־פֹּעֲלֵי אָוֶן׃ ");
INSERT INTO hebsg_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","וְאַתָּה בֶן־אָדָם בְּשָׁפְטְךָ אֹתָם וּכְמַעֲשֵׂיהֶם גַּם־אַתָּה עֹשֶׂה הֲתֹאמַר אֶל־לִבְּךָ כִּי תִמָּלֵט מִמִּשְׁפַּט אֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","אוֹ הֲתָבוּז רֹב טוּבוֹ וְחֶמְלָתוֹ וְאֶרֶךְ אַפּוֹ וְלֹא תִתְבּוֹנֵן כִּי־בְטוּבוֹ הוּא מַדְרִיכְךָ לָשׁוּב אֵלָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","וּבִשְׁרִרוּת לִבְּךָ וּבְעָרְפְּךָ הַקָּשֶׁה תִּצְבָּר־לְךָ עֶבְרָה לַיּוֹם הַגָּדוֹל וְהַנּוֹרָא בְּהִגָּלוֹת נִגְלוֹת צִדְקַת מִשְׁפַּט אֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","אֲשֶׁר יִגְמֹל לְאִישׁ אִישׁ כְּמִפְעָלָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","חַיֵּי עוֹלָם לְשֹׁקְדֵי עֲשׂה־טוֹב שֹׁחֲרֵי כָבוֹד וְהָדָר אֲשֶׁר לֹא יַעֲבֹר לָנֶצַח׃ ");
INSERT INTO hebsg_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","וְזַעַף וְעֶבְרָה לִבְנֵי מֶרִי הַמְמָאֲנִים לִשְׁמֹעַ דִּבְרֵי אֱמֶת וְלַעֲשׂוֹת עָוֶל יָהִינוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","צָרָה וְצוּקָה לְכָל־נֶפֶשׁ אִישׁ הַפֹּעֵל רָע הַיְּהוּדִי בְּרֹאשׁ וְגַם־הַיְּוָנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","וְכָבוֹד וְהָדָר וְשָׁלוֹם לְכָל־פֹּעֵל טוֹב הַיְּהוּדִי בְּרֹאשׁ וְגַם־הַיְּוָנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","כִּי אֵין־מַשּׂא פָנִים עִם־הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","כִּי כָל־אֵלֶּה אֲשֶׁר חָטְאוּ בִּבְלִי־תוֹרָה גַּם בִּבְלִי־תוֹרָה יֹאבֵדוּ וְאֵלֶּה אֲשֶׁר חָטְאוּ וְתוֹרַת אֲדֹנָי אִתָּם עַל־פִּי הַתּוֹרָה הַזֹּאת יִשָּׁפֵטוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","כִּי לֹא שֹׁמְעֵי הַתּוֹרָה צַדִּיקִים הֵם לִפְנֵי אֱלֹהִים כִּי אִם־שֹׁמְרֵי הַתּוֹרָה יִצְדָּקוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","כִּי הַגּוֹיִם אֲשֶׁר אֵין־לָהֶם אוֹר תּוֹרָה וְעֹשִׂים כְּדִבְרֵי הַתּוֹרָה עַל־פִּי אוֹר דַּעְתָּם הֵם אֲשֶׁר תּוֹרָה אֵין לָהֶם יִהְיוּ תוֹרָה לְנַפְשָׁם׃ ");
INSERT INTO hebsg_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","בְּהַרְאֹתָם כִּי מִשְׁפַּט הַתּוֹרָה כָּתוּב עַל־לוּחַ לִבָּם בַּאֲשֶׁר דַּעְתָּם תַּגִּיד לָהֶם וְעֶשְׁתֹּנוֹתֵיהֶם חֲלִיפוֹת שׂטְנוֹת אוֹ מְזַכּוֹת אִשָּׁה אֶת־אֲחוֹתָהּ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","בַּיּוֹם הַהוּא אֲשֶׁר יִשְׁפֹּט אֱלֹהִים אֶת־סִתְרֵי בְנֵי אָדָם עַל־פִּי יֵשׁוּעַ הַמָּשִׁיחַ כַּאֲשֶׁר הוֹדַעְתִּי בִּבְשׁרָתִי׃ ");
INSERT INTO hebsg_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","וְאַתָּה כִּי נִקְרֵאתָ בְשֵׁם יְהוּדִי וַתָּשֶׁת מִבְטַחֲךָ בַתּוֹרָה וּבֵאלֹהִים תִּתְהַלֵּל נַפְשֶׁךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","כִּי יָדַעְתָּ אֶת־רְצוֹנוֹ וְתָבִין לְהַבְדִּיל בֵּין־טוֹב לָרָע לִהְיוֹתְךָ מַשְׂכִּיל בַּתּוֹרָה׃ ");
INSERT INTO hebsg_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","וְלִבְּךָ בָטוּחַ כִּי אַתָּה הוּא הַמְנַהֵל לְעִוְרִים וְאוֹר לְישְׁבֵי חשֶׁךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","מוֹרֶה לִפְתָאיִם אַלּוּף לִילָדִים וְחוֹתַם תָּכְנִית בְּדַעַת וֶאֱמֶת בַּתּוֹרָה׃ ");
INSERT INTO hebsg_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","וְאַתָּה הַמְאַלֵּף אֶת־אֲחֵרִים הֲלֹא תְאַלֵּף אֶת־נַפְשֶׁךָ אַתָּה הַקֹּרֵא לֹא־תִגְנֹב הֲתִגְנֹב אָתָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","אַתָּה הַאֹמֵר לֹא־תִנְאָף הֲתִנְאֹף אָתָּה אַתָּה אֲשֶׁר תְּשַׁקֵּץ אֶת־הָאֱלִילִים הֲתִמְעַל מַעַל בַּקֹּדֶשׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","אַתָּה כִּי תִתְהַלֵּל בַּתּוֹרָה הַתְחַלֵּל שֵׁם הָאֱלֹהִים וְסוּר מִן־הַתּוֹרָה׃ ");
INSERT INTO hebsg_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","כִּי בִגְלַלְכֶם שֵׁם אֱלֹהִים מְחֻלָּל בַּגּוֹיִם כְּמוֹ שֶׁכָּתוּב׃ ");
INSERT INTO hebsg_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","כִּי אָמֵן הַמּוּלָה לְהוֹעִיל לְךָ אִם־תִּשְׁמֹר אֶת־הַתּוֹרָה אַךְ אִם אֶת־הַתּוֹרָה הֵפַרְתָּ הֲלֹא מוּלָתְךָ לְעָרְלָה נִהְיָתָה׃ ");
INSERT INTO hebsg_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","וְאִם הֶעָרֵל יַעֲשֶׂה כְּמִשְׁפַּט הַתּוֹרָה עָרְלָתוֹ לְמוּלָה תֵּחָשֶׁב־לוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","וְהֶעָרֵל הַזֶּה מִלֵּדָה הָעֹשֶׂה כְמִשְׁפַּט הַתּוֹרָה יָדִין אֹתְךָ אֲשֶׁר יֶשׁ־לְךָ סֵפֶר הַמִּצְוָה וְאוֹת בְּרִית הַמּוּלוֹת וְאֶת־הַתּוֹרָה הֵפַרְתָּ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","כִּי לֹא־זֶה הוּא יְהוּדִי אֲשֶׁר לָעֵינָיִם וְלֹא זֹאת הִיא הַמּוּלָה אֲשֶׁר לַמַּרְאֶה בַּבָּשָׂר׃ ");
INSERT INTO hebsg_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","אַךְ זֶה יְהוּדִי אֲשֶׁר בְּתוֹךְ לִבּוֹ הוּא יְהוּדִי וְהַמּוּלָה מוּלַת הַלֵּבָב הִיא לְפִי רוּחַ הַדִּבֵּר וְלֹא לְפִי אוֹת הַכְּתָב אֲשֶׁר תְּהִלָּתוֹ לֹא מִבְּנֵי אָדָם כִּי אִם מֵאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","אִם כֵּן אֵפוֹא מַה־יִּתָרוֹן לִיהוּדִי וּמַה־בֶּצַע לוֹ בִּבְרִית הַמּוּלוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","רַב מְאֹד מִכָּל־עֵבֶר וְיִתְרוֹן הָרֹאשׁ כִּי־הָפְקְדוּ אִתָּם דִּבְרֵי אֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","וּמָה אֵפוֹא אִם־מִקְצָתָם לֹא הֶאֱמִינוּ הֶהָפֵר יָפֵר חֹסֶר אֱמוּנָתָם אֶת־אֱמוּנַת אֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","חָלִילָה אַךְ אֱלֹהִים נֶאֱמָן הוּא וְכָל־אָדָם כֹּזֵב כַּכָּתוּב לְמַעַן־תִּצְדַּק בִּדְבָרֶיךָ וְתִזְכֶּה בְּהִשָּׁפְטֶךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","אַךְ אִם־יִוָּדַע עֹז צִדְקַת אֱלֹהִים עַל־יְדֵי פְשָׁעֵינוּ מַה־נֹּאמַר אֱלֹהֵי עָוֶל הוּא אֲשֶׁר יָעִיר חֲמָתוֹ עָלֵינוּ כְּדֶרֶךְ בְּנֵי־אָדָם אֲנִי מְדַבֵּר׃ ");
INSERT INTO hebsg_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","חָלִילָה כִּי אִם־כֵּן אֵיךְ־יִשְׁפֹּט אֱלֹהִים אֶת־הָאָרֶץ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","וְאִם־פִּשְׁעִי וְכַחֲשִׁי בֵאלֹהִים יִתֶּן־לוֹ עֹז וְכָבוֹד מִשְׁנֶה לָמָּה־זֶּה אֵצֵא רָשָׁע בְּהִשָּׁפְטִי׃ ");
INSERT INTO hebsg_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","אַךְ הֲלֹא זֶה הוּא דְּבַר מְנַדֵּינוּ הַמּוֹצִיאִים דִּבָּתֵנוּ רָעָה לֵאמֹר כִּי אֲנַחְנוּ אֹמְרִים נַעֲשֶׂה רָע בִּגְלַל הַטּוֹב אֲשֶׁר יָבֹא בַּעֲקֵבוֹ אֵלֶּה הֵם אֲשֶׁר בְּהִשָּׁפְטָם יֶאְשָׁמוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","וּמָה עַתָּה הֲיֵשׁ יִתְרוֹן לָנוּ אֶפֶס וָאָיִן כִּי לִפְנֵי כֵן הוֹכַחְנוּ כִּי יְהוּדִים וִיוָנִים בֶּעָוֹן הֵמָּה יָחַד׃ ");
INSERT INTO hebsg_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","כַּכָּתוּב אֵין צַדִּיק אֵין גַּם־אֶחָד׃ ");
INSERT INTO hebsg_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","אֵין מַשְׂכִּיל אֵין דֹּרֵשׁ אֶת־אֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","הַכֹּל סָר יַחְדָּו נֶאֱלָחוּ אֵין עֹשֶׂה־טוֹב אֵין גַּם אֶחָד׃ ");
INSERT INTO hebsg_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","קֶבֶר־פָּתוּחַ גְּרֹנָם לְשׁוֹנָם יַחֲלִיקוּן חֲמַת עַכְשׁוּב תַּחַת שְׂפָתֵימוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","אֲשֶׁר אָלָה פִּיהֶם מָלֵא וּמְרֹרוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","רַגְלֵיהֶם יְמַהֲרוּ לִשְׁפָּךְ־דָּם׃ ");
INSERT INTO hebsg_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","שֹׁד וָשֶׁבֶר בִּמְסִלּוֹתָם׃ ");
INSERT INTO hebsg_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","וְדֶרֶךְ שָׁלוֹם לֹא יָדָעוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","אֵין פַּחַד אֱלֹהִים לְנֶגֶד עֵינֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","וַאֲנַחְנוּ יָדַעְנוּ כִּי כָל־אֲשֶׁר תַּגִּיד הַתּוֹרָה לָאֵלֶּה אֲשֶׁר קִבְּלוּ אֶת־הַתּוֹרָה תָּשִׂים דְּבָרֶיהָ וּבָזֹאת יִסָּכֵר כָּל־פֶּה וְכָל־הָאָרֶץ תֶּאְשַׁם לִפְנֵי אֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","יַעַן בְּמַּעֲשִׂים אֲשֶׁר צִוְּתָה הַתּוֹרָה לֹא יִצְדַּק כָּל־בָּשָׂר לְפָנָיו כִּי מִמְּקוֹר הַתּוֹרָה יָצְאָה דַּעַת הַחֵטְא׃ ");
INSERT INTO hebsg_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","וְעַתָּה מִבַּלְעֲדֵי הַתּוֹרָה יָצְאָה צִדְקַת אֱלֹהִים לָאוֹר אֲשֶׁר הֵעִידוּ עָלֶיהָ הַתּוֹרָה וְהַנְּבִיאִים׃ ");
INSERT INTO hebsg_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","וְצִדְקַת אֱלֹהִים בֶּאֱמוּנַת יֵשׁוּעַ הַמָּשִׁיחַ נְתוּנָה לְכָל־בְּנֵי אָדָם לִבְנֵי אֱמֻנִים כֻּלָּם כִּי אֵין־מַבְדִּיל׃ ");
INSERT INTO hebsg_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","כִּי־כֻּלָּם חָטָאוּ וַיִּסֹּגוּ מֵאַחֲרֵי כְבוֹד אֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","וּבְחִנּוֹ חִנָּם כֻּלָּם יִצְדָּקוּ כִּי־פָדָה אֹתָם יֵשׁוּעַ הַמָּשִׁיחַ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","הוּא אֲשֶׁר הִקְדִּישׁוֹ אֱלֹהִים מִקֶּדֶם לְכַפֵּר עָלֵינוּ בְדָמוֹ עַל־פִּי אֱמוּנָתֵנוּ לְבַעֲבוּר גַּלּוֹת אֶת־צִדְקָתוֹ וְחֶמְלָתוֹ בַּאֲשֶׁר סָלַח לַעֲוֹנוֹת עַמּוֹ מִימֵי קֶדֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","וְגַם לְגַלּוֹת אֶת־צִדְקָתוֹ לְעֵת כָּזֹאת כִּי הוּא הַצַּדִּיק וְהוּא הַמַּצְדִּיק אֶת־הַמַּאֲמִין בְּיֵשׁוּעַ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","אַיֵּה אֵפוֹא עַתָּה גְּאוֹן הַמִּתְהַלְּלִים אֵין כָּל־מְאוּמָה עַל־פִּי אֵיזֶה חֹק עַל־פִּי חָק־הַמַּעֲשֶׂה לֹא כִּי אִם עַל־פִּי חָק־הָאֱמוּנָה׃ ");
INSERT INTO hebsg_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","לָכֵן חָרַצְנוּ לֵאמֹר בָּאֱמוּנָה יִצְדַּק אִישׁ מִבַּלְעֲדֵי הַמַּעֲשִׂים אֲשֶׁר עַל־פִּי הַתּוֹרָה׃ ");
INSERT INTO hebsg_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","הַאֱלֹהִים לַיְּהוּדִים לְבַד הוּא וְלֹא לַגּוֹיִם אָכֵן גַּם־אֱלֹהֵי הַגּוֹיִם הוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","כִּי הוּא אֱלֹהִים אֶחָד אֲשֶׁר יַצְדִּיק אֶת־הַמּוּלִים בָּאֱמוּנָה וְאֶת־הָעֲרֵלִים גַּם־כֵּן עַל־יְדֵי הָאֱמוּנָה׃ ");
INSERT INTO hebsg_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","הֲכִי נָפִיר אֶת־הַתּוֹרָה בֶּאֱמוּנָתֵנוּ חָלִילַה אַךְ נְקַיֵּם אֶת־הַתּוֹרָה׃ ");
INSERT INTO hebsg_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","וּמַה־נֹּאמַר עַל־אַבְרָהָם אָבִינוּ מַה־יִּתְרוֹן מָצָא בְּמַעֲשֵׂהוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","כִּי לוּ־נִצְדַּק אַבְרָהָם בְּמַעֲשָׂיו נָאוָה־לוֹ תְהִלָּה אַךְ־לֹא לִפְנֵי אֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","כִּי מַה־דְּבַר הַתּוֹרָה וְהֶאֱמִן אַבְרָהָם בֵּאלֹהִים וַיַּחְשְׁבֶהָ לּוֹ צְדָקָה׃ ");
INSERT INTO hebsg_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","וּלְאִישׁ אֲשֶׁר מַעֲשֵׂהוּ בְיָדוֹ לֹא יֵחָשֵׁב שְׂכָרוֹ כְּמַתְּנַת חִנָּם כִּי אִם־כְּשִׁלֻּמַת חוֹב׃ ");
INSERT INTO hebsg_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","אַךְ אִישׁ אֲשֶׁר מַעֲשֵׂה יָדָיו אֵין אִתּוֹ וְהוּא מַאֲמִין בַּמַּצְדִּיק אֶת־הָרָשָׁע עֵקֶב אֱמוּנָתוֹ אֱמוּנָתוֹ זוּ תֵּחָשֵׁב לִצְדָקָה׃ ");
INSERT INTO hebsg_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","כַּאֲשֶׁר גַּם־דָּוִד מְאַשֵּׁר אֶת־הָאָדָם אֲשֶׁר אֱלֹהִים יַצְדִּיקֶנּוּ לֹא עַל־פִּי פָעֳלוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","אַשְׁרֵי נְשׂוּי־פֶּשַׁע כְּסוּי חֲטָאָה׃ ");
INSERT INTO hebsg_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","אַשְׁרֵי אָדָם לֹא־יַחְשֹׁב יְהוָֹה לוֹ עָוֹן׃ ");
INSERT INTO hebsg_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","וָאשֶׁר הַזֶּה לְמִי לְנִמּוֹלִים אוֹ גַם־לַעֲרֵלִים יַעַן נִקְרָא בָזֶה כִּי אֱמוּנַת אַבְרָהָם נֶחְשְׁבָה לּוֹ לִצְדָקָה׃ ");
INSERT INTO hebsg_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","וּמָתַי נֶחְשְׁבָה־לּוֹ כֵן אַחֲרֵי הִמֹּלוֹ אוֹ טֶרֶם הִמֹּלוֹ לֹא אַחֲרֵי הִמֹּלוֹ כִּי אִם־טֶרֶם הִמֹּלוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","וְאוֹת בְּרִית הַמּוּלוֹת נָשָׂא לִהְיוֹת לוֹ לְחוֹתַם צִדְקָתוֹ עֵקֶב אֲשֶׁר הֶאֱמִין בְּעוֹדֶנּוּ עָרֵל לְמַעַן יִהְיֶה לְאָב לְכָל־הַמַּאֲמִינִים אַף כִּי־הֵם עֲרֵלִים אֲשֶׁר גַּם־אֱמוּנָתָם תֵּחָשֵׁב לָהֶם לִצְדָקָה׃ ");
INSERT INTO hebsg_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","וְהוּא אָב לְנִמּוֹלִים אַךְ־לֹא רַק לְנִמּוֹלִים לְבַדָּם כִּי־אִם־גַּם־לָאֵלֶּה הַהֹלְכִים בְּעִקְּבוֹת אֱמוּנָתוֹ אֲשֶׁר הִתְהַלֵּךְ אַבְרָהָם אָבִינוּ בְּעוֹדֵנוּ עָרֵל׃ ");
INSERT INTO hebsg_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","כִּי לֹא בִגְלַל הַתּוֹרָה בָּאָה הַהַבְטָחָה לְאַבְרָהָם וּלְזַרְעוֹ לִהְיוֹת יוֹרֵשׁ הָאָרֶץ כִּי אִם־בִּגְלַל צִדְקַת אֱמוּנָתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","כִּי אִם־בַּעֲלֵי הַתּוֹרָה יוֹרְשִׁים הֵם אֱמוּנָה תִהְיֶה לָרִיק וְהַבְטָחָה לְלֹא־דָבָר׃ ");
INSERT INTO hebsg_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","כִּי מִפְּאַת הַתּוֹרָה יֵצֵא הַקָּצֶף כִּי בַאֲשֶׁר אֵין תּוֹרָה אֵין פָּשַׁע׃ ");
INSERT INTO hebsg_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","עַל־כֵּן בְּדֶרֶךְ אֱמוּנָה תִּמָּצֵא לְמַעַן תִּכּוֹן בְּחֶסֶד וְהַהַבְטָחָה תִהְיֶה נְכוֹנָה לְכָל־הַזָּרַע לֹא לִבְנֵי הַתּוֹרָה לְבַדָּם כִּי־אִם גַּם־לִבְנֵי אֱמוּנַת אַבְרָהָם אֲשֶׁר הוּא אָב לְכֻלָּנוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","כַּכָּתוּב כִּי אַב הֲמוֹן גּוֹיִם נְתַתִּיךָ לִפְנֵי אֱלֹהִים זֶה בָּטַח בּוֹ לִבּוֹ הַנֹּתֵן חַיִּים לַמֵּתִים וְהַקֹּרֵא לָאַיִן כַּיֵּשׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","וְאַף כִּי לֹא נִרְאָה פֶתַח תִּקְוָה הֶחֱזִיק בְּתִקְוָתוֹ לְהִנָּתֵן אַב־הֲמוֹן גּוֹיִם כַּאֲשֶׁר נֶאֱמַר כֹּה יִהְיֶה זַרְעֶךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","וְכַאֲשֶׁר לֹא הִתְרַפָּה בֶאֱמוּנָתוֹ הִבִּיט אֶל־בְּשָׂרוֹ אֲשֶׁר הָיָה כַמֵּת בִּהְיוֹתוֹ כְּבֶן־מְאַת שָׁנָה וְאֶל־רֶחֶם שָׂרָה אֲשֶׁר בָּלָה׃ ");
INSERT INTO hebsg_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","וְרוּחוֹ לֹא נִפְלְגָה בְקִרְבּוֹ מִבְּלִי אֵמֻן בִּדְבַר אֱלֹהִים כִּי אִם־הִתְגַּבֵּר בֶּאֱמוּנָתוֹ וְנָתוֹן כָּבוֹד לֵאלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","וְנַפְשׁוֹ יֹדַעַת מְאֹד כִּי תַשִּׂיג יַד אֵל לְמַלֹּאת אֵת אֲשֶׁר דִּבֵּר׃ ");
INSERT INTO hebsg_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","וְעַל־כֵּן נֶחְשְׁבָה לוֹ לִצְדָקָה׃ ");
INSERT INTO hebsg_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","וְלֹא נִכְתַּב רַק לְמַעֲנוֹ לְבַדּוֹ כִּי לוֹ נֶחְשָׁבָה׃ ");
INSERT INTO hebsg_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","כִּי אִם־גַּם לְמַעֲנֵנוּ אֲשֶׁר כֵּן תֵּחָשֵׁב־לָנוּ הַמַּאֲמִינִים בַּמֵּקִים אֶת־יֵשׁוּעַ אֲדֹנֵינוּ מִן־הַמֵּתִים׃ ");
INSERT INTO hebsg_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","אֲשֶׁר נִמְסַר לַמָּוֶת בִּפְשָׁעֵינוּ וְהֻקַּם עָל לִצְדָקָה לָנוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","עַל־כֵּן כַּאֲשֶׁר נִצְדַּקְנוּ בָאֱמוּנָה שָׁלוֹם יִשְׁפָּת־לָנוּ אֱלֹהִים עַל־יְדֵי יֵשׁוּעַ הַמָּשִׁיחַ אֲדֹנֵינוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","אֲשֶׁר גַּם עַל־יָדוֹ מָצָאנוּ בְדֶרֶךְ אֱמוּנָה אֶת־שַׁעַר הַחֶסֶד אֲשֶׁר אֲנַחְנוּ בָאִים בּוֹ וּבְעֹז הָאֱלֹהִים נָרִים קֶרֶן כַּאֲשֶׁר קִוִּינוּ לוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","וְלֹא־זֹאת לְבַד כִּי אִם־גַּם בְּצָרָה נָרִים רֹאשׁ אַחֲרֵי אֲשֶׁר יָדַעְנוּ כִּי־צָרָה תוֹלִיד אֶת־עֹצֶר רוּחַ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","וְעֹצֶר הָרוּחַ אֶת־בְּחִינַת לֵב וּבְחִינַת הַלֵּב אֶת־תִּקְוַת נֶפֶשׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","וְהַתִּקְוָה לֹא תֵבוֹשׁ בַּאֲשֶׁר הוּצַק בְּלִבֵּנוּ אַהֲבַת־אֵל בְּרוּחַ קָדְשׁוֹ אֲשֶׁר נָתַן עָלֵינוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","כִּי בְעוֹד הָיִינוּ רְפֵי יָדָיִם מֵת הַמָּשִׁיחַ בְּעִתּוֹ בְּעַד הַחַטָּאִים בְּנַפְשׁוֹתָם׃ ");
INSERT INTO hebsg_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","הֵן תִּיקַר לְאָדָם נַפְשׁוֹ מִתִּתּוֹ אֹתָהּ בְּעַד נֶפֶשׁ צַדִּיק וּבְעַד הַצְּדָקָה אוּלַי אִישׁ מִתְנַדֵּב יַעְצָר־כֹּחַ לָמוּת בַּעֲדָּהּ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","וֵאלֹהִים גִּלָּה אַהֲבָתוֹ לְעֵינֵינוּ כִּי בְעוֹד הָיִינוּ חֹטְאִים נָתַן הַמָּשִׁיחַ אֶת־נַפְשׁוֹ בַּעֲדֵנוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","אַף כִּי־עַתָּה אַחֲרֵי אֲשֶׁר נִצְדַּקְנוּ בְדָמוֹ תּוֹשִׁיעַ לָנוּ יָדוֹ לְהִמָּלֵט מֵחֲרוֹן־אָף׃ ");
INSERT INTO hebsg_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","כִּי אִם־בְּעוֹד אוֹיְבִים הָיִינוּ אֲנַחְנוּ הִתְרַצְּנוּ אֶל־הָאֱלֹהִים בְּמוֹת בְּנוֹ אַף כִּי־אַחֲרֵי אֲשֶׁר רָצָה בָּנוּ בְּחַיֵּי בְנוֹ נִוָּשֵׁעַ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","וְלֹא־זֹאת לְבַד כִּי אִם־גַּם רָמָה קַרְנֵנוּ בֵאלֹהִים עַל־יְדֵי יֵשׁוּעַ הַמָּשִׁיחַ אֲדֹנֵינוּ אֲשֶׁר בּוֹ לָקַח רָצוֹן מִיָּדֵינוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","לָכֵן כַּאֲשֶׁר הַחֵטְא עָלָה בָאָרֶץ עַל־יְדֵי אָדָם אֶחָד וְהַמָּוֶת בָּא לְרַגְלֵי הַחֵטְא כֵּן פָּגַע הַמָּוֶת בְּכָל־בְּנֵי אָדָם בַּאֲשֶׁר כֻּלָּם חָטָאוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","כִּי נִמְצָא חֵטְא בָּאָרֶץ גַּם־לִפְנֵי מַתָּן הַתּוֹרָה וְאַף כִּי חֵטְא לֹא יֵחָשֵׁב בִּבְלִי־תוֹרָה׃ ");
INSERT INTO hebsg_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","בְּכָל־זֹאת שָׁלַט הַמָּוֶת מֵאָדָם עַד־משֶׁה גַּם־בַּפּשְׁעִים אֲשֶׁר פִּשְׁעָם לֹא נִדְמָה לְפֶשַׁע אָדָם הוּא הָאָדָם הָרִאשׁוֹן אֲשֶׁר בִּדְמוּתוֹ כְּצַלְמוֹ הָאָדָם הָאַחֲרוֹן הִתְעַתֵּד לָבוֹא׃ ");
INSERT INTO hebsg_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","אֶפֶס כִּי אֵין עֵרֶךְ הַפֶּשַׁע כְּעֵרֶךְ מַתְּנַת חִנָּם כִּי אִם־בְּפֶשַׁע אֶחָד מֵתוּ רַבִּים כַּמֶּה פְעָמִים יֶתֶר עַל־הַמִּדָּה יוֹעִיל לְרַבִּים חֶסֶד אֱלֹהִים וּמַתְּנַת יָדוֹ עַל־פִּי חֶסֶד הָאִישׁ הָאֶחָד יֵשׁוּעַ הַמָּשִׁיחַ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","וְלֹא כַמִּשְׁפָּט הַנֶּחֱרַץ בִּגְלַל הַפּשֵׁעַ הָאֶחָד נִתְּנָה לָּנוּ הַמַּתָּת כִּי הַמִּשְׁפָּט יָצָא לְהַרְשִׁיעַ אֶת־כֻּלָּם בְּפֶשַׁע אֶחָד וְהַמַּתָּת הִיא לְטַהֵר אֶת־כֻּלָּם מִפְּשָׁעִים רַבִּים׃ ");
INSERT INTO hebsg_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","כִּי אִם־בְּפֶשַׁע הָאֶחָד שָׁלַט הַמָּוֶת בָּנוּ עַל־יְדֵי הָאֶחָד אַף כִּי־נֹשְׂאֵי שִׁפְעַת הַחֶסֶד וּמַתְּנַת הַצְּדָקָה יִמְשְׁלוּ בַחַיִּים עַל־יְדֵי הָאֶחָד הוּא יֵשׁוּעַ הַמָּשִׁיחַ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","לָכֵן כַּאֲשֶׁר בְּפֶשַׁע אִישׁ אֶחָד נִשְׁפְּטוּ כָל־בְּנֵי־אָדָם וַיֶּאְשָׁמוּ כֵּן גַּם־בְּצִדְקַת אִישׁ אֶחָד יִזְכּוּ כָל־בְּנֵי־אָדָם לְחַיֵּי צְדָקָה׃ ");
INSERT INTO hebsg_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","כִּי כַּאֲשֶׁר בְּהַפְצַר אִישׁ אֶחָד רַבִּים יָצְאוּ אֲשֵׁמִים כֵּן גַּם־בְּהַקְשֵׁב הָאֶחָד רַבִּים יֵצְאוּ נְקִיִּים׃ ");
INSERT INTO hebsg_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","וּבֵין כֹּה וָכֹה בָּאָה הַתּוֹרָה לְבַעֲבוּר יִגְדַּל הַפָּשַׁע אַךְ בַּאֲשֶׁר גָּדַל הַפֶּשַׁע שָׁם גָּדַל הַחֶסֶד יֶתֶר מְאֹד׃ ");
INSERT INTO hebsg_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","וְכַאֲשֶׁר שָׁלַט הַחֵטְא בַּמָּוֶת כֵּן יִמְשֹׁל הַחֶסֶד עַל־יְדֵי הַצְּדָקָה לְחַיֵּי עוֹלָם בְּיֵשׁוּעַ הַמָּשִׁיחַ אֲדֹנֵינוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","וּמַה־נֹּאמַר עָתָּה הֲנַעֲמֹד עוֹד בַּחַטָּאָה לְמַעַן יִגְדַּל הֶחָסֶד׃ ");
INSERT INTO hebsg_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","חָלִילָה אֲנַחְנוּ אֲשֶׁר כַּמֵּתִים נֶחְשַׁבְנוּ לַחֵטְא אֵיךְ נִחְיֶה־בּוֹ עוֹד׃ ");
INSERT INTO hebsg_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","הֲלֹא יְדַעְתֶּם כִּי כֻּלָּנוּ הַנִּטְבָּלִים בְּשֵׁם יֵשׁוּעַ הַמָּשִׁיחַ בְּמוֹתוֹ נִטְבָּלְנוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","וְכַאֲשֶׁר נִטְבַּלְנוּ בְמוֹתוֹ כֵּן נִקְבַּרְנוּ עִמּוֹ וְכַאֲשֶׁר אֲבִי־כֹל בִּכְבוֹדוֹ הֲקִימוֹ מִן־הַמֵּתִים כֵּן גַּם־עָלֵינוּ לָקוּם לְהִתְהַלֵּךְ לְפָנָיו בְּחַיִּים חֲדָשִׁים׃ ");
INSERT INTO hebsg_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","כִּי אִם־הָיִינוּ דְבֵקִים בּוֹ כַּעֲנָפִים בָּעֵץ וְנֶחְשָׁבִים כְּמוֹ־מֵתִים בְּמוֹתוֹ הֲלֹא נִשְׁוֶה־לּוֹ גַּם־בַּתְּקוּמָה׃ ");
INSERT INTO hebsg_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","בְּדַעְתֵּנוּ כִּי הָאָדָם הַקַּדְמֹנִי בְּקִרְבֵּנוּ נִתְלָה כָּמֹהוּ לְמַעַן יֶחְדַּל עֶצֶם הָאָדָם הַחֹטֵא הַזֶּה לְבִלְתִּי נִהְיֶה עוֹד עֲבָדִים לַחֵטְא׃ ");
INSERT INTO hebsg_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","כִּי הַמֵּת חָפְשִׁי הוּא מִן־הַחֵטְא׃ ");
INSERT INTO hebsg_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","וְהִנֵּה אִם־מֵתִים אֲנַחְנוּ עִם־הַמָּשִׁיחַ סָמוּךְ לִבֵּנוּ כִּי גַם־נִחְיֶה עִמּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","בְּדַעְתֵּנוּ כִּי הַמָּשִׁיחַ אֲשֶׁר קָם מִן־הַמֵּתִים לֹא יִישַׁן עוֹד וְלֹא יִשְׁלַט־בּוֹ הַמָּוֶת שֵׁנִית׃ ");
INSERT INTO hebsg_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","כִּי בַּאֲשֶׁר מֵת מֵת הוּא פַּעַם אַחַת לַחֵטְא וּבַאֲשֶׁר חַי חַי הוּא לֵאלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","כֵּן חִשְׁבוּ נַפְשְׁכֶם גַּם־אַתֶּם מֵתִים לַחֲטָאָה וְחַיִּים לֵאלֹהִים בְּיֵשׁוּעַ הַמָּשִׁיחַ אֲדוֹנֵינוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","אַל־יִשׁלֹט אֵפוֹא הַחֵטְא בִּבְשַׂרְכֶם הַהֹלֵךְ לָמוּת לִנְטוֹת אַחֲרָיו בְּתַאֲוָתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","וְאַל־תִּתְּנוּ אֶת־אֵבָרֵיכֶם לִהְיוֹת כְּלֵי־אָוֶן לַחֵטְא אַךְ הַקְרִיבוּ אֶת־נַפְשְׁכֶם לֵאלֹהִים כְּחַיִּים מִן־הַמֵּתִים וְאֶת־אֵבָרֵיכֶם כְּלֵי צְדָקָה לֵאלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","וְהַחֵטְא לֹא יִשְׂתָּרֵר עֲלֵיכֶם כִּי אֵינְכֶם תַּחַת יַד־הַתּוֹרָה כִּי אִם־תַּחַת יַד תּוֹרַת חָסֶד׃ ");
INSERT INTO hebsg_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","וּמָה אֵפוֹא הֲכִי נֶחְטָא יַעַן תַּחַת יַד־הַתּוֹרָה אֵין אֲנַחְנוּ עוֹד כִּי אִם־תַּחַת יַד תּוֹרַת חֶסֶד חָלִילָה׃ ");
INSERT INTO hebsg_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","הֲלֹא יְדַעְתֶּם כִּי לְמִי אֲשֶׁר תָּפִיקוּ נַפְשְׁכֶם כַּעֲבָדִים סָרִים לְמִשְׁמַעְתּוֹ לוֹ אַתֶּם לַעֲבָדִים כַּאֲשֶׁר אֵלָיו תִּשְׁמָעוּן אִם עֲבָדִים לַחֵטְא וְלַמָּוֶת וְאִם לִשְׁמֹעַ בְּקוֹל אֲדֹנָי וְלִצְדָקָה׃ ");
INSERT INTO hebsg_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","וּבָרוּךְ הוּא אֱלֹהִים כִּי אַחֲרֵי הֱיוֹתְכֶם עֲבָדִים לַחֵטְא שַׂמְתֶּם עַל־לִבְּכֶם לִשְׁמֹעַ וְלִשׁמֹר אֶת־הַתּוֹרָה הַהִיא כְּצוּרָתָהּ אֲשֶׁר קִבַּלְתֶּם עֲלֵיכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","וְאַחֲרֵי אֲשֶׁר יְצָאתֶם לַחָפְשִׁי מִיַּד־הַחֵטְא לְעַבְדֵי הַצְּדָקָה הֱיִיתֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","כְּדֶרֶךְ בְּנֵי־אָדָם אֲנִי מְדַבֵּר בַּעֲבוּר רִפְיוֹן בְּשַׂרְכֶם כִּי כַּאֲשֶׁר הִקְרַבְתֶּם אֵבָרֵיכֶם לְתוֹעֵבָה וְעַוְלָתָה לַעֲשׂוֹת עָוֶל כֵּן הַקְדִּישׁוּ־נָא אֵבָרֵיכֶם כַּיּוֹם לְמַעֲשֵׂה הַצְּדָקָה לְמַעַן תִּהְיוּ קְדֹשִׁים׃ ");
INSERT INTO hebsg_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","כִּי־בִהְיוֹתְכֶם לְפָנִים עֲבָדִים לַחֵטְא נִפְרָדִים הֱיִיתֶם מִצְּדָקָה׃ ");
INSERT INTO hebsg_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","וּמָה־פְּרִי מְצָאתֶם אָז מֵהַמַּעֲשִׂים הָהֵם אֲשֶׁר תִּכָּלְמוּ מֵהֶם כַּיּוֹם כִּי עֵקֶב אֵלֶּה אֲבַדּוֹן׃ ");
INSERT INTO hebsg_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","אַךְ עַתָּה כִּי־יְצָאתֶם לַחָפְשִׁי מִיַּד הַחֵטְא וַתִּהְיוּ עֲבָדִים לֵאלֹהִים הֲלֹא תִשְׂאוּ פֶרְיְכֶם בַּקֹּדֶשׁ וְעֵקֶב־זֶה חַיֵּי עוֹלָם׃ ");
INSERT INTO hebsg_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","כִּי מַשְׂכֹּרֶת הַחֵטְא אֲבָדוֹן וּמַתַּת אֲלֹהִים חַיֵּי נֶצַח בְּיֵשׁוּעַ הַמָּשִׁיחַ אֲדֹנֵינוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","הֲלֹא יְדַעְתֶּם אַחַי כִּי לְיֹדְעֵי הַתּוֹרָה אֲנִי מְדַבֵּר כִּי הַתּוֹרָה מֹשֶׁלֶת בָּאָדָם כָּל־עוֹד חַי הִנֵּהוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","כִּי אִשָּׁה בְעֻלַת־בַּעַל צְרוּרָה הִיא עַל־פִּי הַתּוֹרָה בְּחַיֵּי בַעְלָהּ וְכִי־יָמוּת הַבַּעַל יָצְאָה לָּהּ מִתּוֹרַת הַבָּעַל׃ ");
INSERT INTO hebsg_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","וְעַל־כֵּן אִם תֵּדַע אִישׁ אַחֵר בְּעוֹד בַּעְלָהּ חַי נֹאֶפֶת יִקָּרֵא לָהּ אַךְ אַחֲרֵי מוֹת הַבַּעַל חָפְשִׁית הִיא מִן־הַתּוֹרָה וְלֹא נֹאֶפֶת הִיא בִּהְיוֹתָהּ לְאִישׁ אַחֵר׃ ");
INSERT INTO hebsg_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","לָכֵן אַחַי גַּם־אַתֶּם כְּמֵתִים נֶחְשַׁבְתֶּם לַתּוֹרָה בִּבְשַׂר הַמָּשִׁיחַ הַמֵּת וַתָּקוּמוּ וַתִּהְיוּ לְאַחֵר הֲלֹא הוּא אֲשֶׁר קָם מִן־הַמֵּתִים לְמַעַן עֲשׂוֹת פְּרִי לֵאלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","כִּי כָל־עוֹד רָדַפְנוּ חַיֵּי בְשָׂרִים קָרְאָה מִצְוַת הַתּוֹרָה לִתְשׁוּקוֹת אָוֶן בְּקִרְבֵּנוּ אֲשֶׁר הִתְגָּרוּ בָנוּ וַנַּעַשׂ פְּרִי לַמָּוֶת׃ ");
INSERT INTO hebsg_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","אַךְ עַתָּה נֶחְלַצְנוּ מִיַּד הַתּוֹרָה וּמוֹסְרוֹתֶיהָ הִשְׁלַכְנוּ מִמֶּנּוּ אַחֲרֵי אֲשֶׁר מַתְנוּ לָהּ וּבְכֵן עָלֵינוּ לַעֲבֹד אֶת־יְהוָֹה בָּרוּחַ הַחֲדָשָׁה וְלֹא לְפִי־טַעַם הַמִּלּוֹת הַנּוֹשָׁנוֹת בַּתּוֹרָה׃ ");
INSERT INTO hebsg_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","וּמַה־נֹּאמַר עַתָּה הֲכִי הַתּוֹרָה חֵטְא הִיא חָלִילָה אֶפֶס חֵטְא לֹא יָדַעְתִּי אִם לֹא עַל־פִּי הַתּוֹרָה כִּי לַחְמֹד לֹא יָדַעְתִּי לוּלֵא אָמְרָה הַתּוֹרָה לֹא תַחְמֹד׃ ");
INSERT INTO hebsg_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","וְהַחֵטְא מָצָא־לוֹ תֹאֲנָה בַּמִּצְוָה וַיְעוֹרֵר בִּי כָּל־תַּאֲוָה כִּי מִבַּלְעֲדֵי הַתּוֹרָה הַחֵטְא כַּמֵּת הוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","וַאֲנִי חַי הָיִיתִי לְפָנִים בְּלֹא־תוֹרָה וּכְבוֹא הַמִּצְוָה קָם הַחֵטְא וַיְחִי וְאָנֹכִי נָפַלְתִּי מֵת׃ ");
INSERT INTO hebsg_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","וְהַמִּצְוָה הַזֹּאת אֲשֶׁר חַיִּים בָּהּ נִמְצְאָה־לִּי כַּמָּוֶת׃ ");
INSERT INTO hebsg_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","כִּי־הַחֵטְא בִּמְצֹא תֹאֲנָה בַּמִּצְוָה הִשִּׁיאַנִי וּבְיַד הַמִּצְוָה הַהִיא הֲרָגָנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","וּבְכֵן הַתּוֹרָה קְדשָׁה וְהַמִּצְוָה קְדשָׁה יְשָׁרָה וְטוֹבָה׃ ");
INSERT INTO hebsg_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","הֲכִי נֶהֶפְכָה־לִּי הַטּוֹבָה לַמָּוֶת חָלִילָה אַךְ הַחֵטְא הוּא לְמַעַן יִוָּדַע כַּאֲשֶׁר הוּא בַּהֲבִיאוֹ לִי אֶת־הַמָּוֶת מִן־הַטּוֹבָה כִּי לְנֹכַח הַמִּצְוָה יִגְדַּל וְיַעֲלֶה הַחֵטְא לַחֲטָאָה גְדֹלָה עַד־מְאֹד׃ ");
INSERT INTO hebsg_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","כִּי נוֹדַע לָנוּ כִּי־הַתּוֹרָה תּוֹרַת רוּחַ הִיא וַאֲנִי בָשָׂר אֲנִי נִמְכַּרְתִּי לַחֵטְא׃ ");
INSERT INTO hebsg_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","כִּי הַדָּבָר אֲשֶׁר אֲנִי עֹשֶׂה אֶרְאֶה וְלֹא אָבִין כִּי לֹא־כַאֲשֶׁר רָצְתָה נַפְשִׁי עָשִׂיתִי כִּי אִם־אֶת־אֲשֶׁר שָׂנֵאתִי זֹאת עָשְׂתָה יָדִי׃ ");
INSERT INTO hebsg_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","וּבַעֲשׂוֹתִי הַדָּבָר אֲשֶׁר לֹא־חָפַצְתִּי־בוֹ הִנְנִי נֹתֵן עֵדוּת לַתּוֹרָה כִּי טוֹבָה הִיא׃ ");
INSERT INTO hebsg_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","וְעַתָּה לֹא־עוֹד אָנֹכִי בַּעַל הַמַּעֲשֶׂה הַזֶּה כִּי אִם־הַחֵטְא הַשֹּׁכֵן בְּקִרְבִּי׃ ");
INSERT INTO hebsg_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","כִּי בְקִרְבִּי וּבְשָׂרִי יָדַעְתִּי לֹא יִשְׁכָּן־טוֹב בַּאֲשֶׁר הַחֵפֶץ לַעֲשׂוֹת טוֹב נִמְצָא עִמָּדִי אַךְ לְבַצַּע אֶת־חֶפְצִי לֹא תִמְצָא יָדִי׃ ");
INSERT INTO hebsg_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","כִּי אֵינֶנִּי עֹשֶׂה אֶת־הַדָּבָר הַטּוֹב כַּאֲשֶׁר חָפָצְתִּי אַךְ אֶת־הָרָע אֲשֶׁר לֹא חָפַצְתִּי יָדַי תְּבַצַּעְנָה׃ ");
INSERT INTO hebsg_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","וְאַחֲרֵי אֲשֶׁר עֹשֶׂה אֲנִי אֶת־הַדָּבָר אֲשֶׁר לא חָפָצְתִּי לֹא אָנֹכִי עוֹד בַּעַל הַמָּעֲשֶׂה הַזֶּה כִּי אִם־הַחֵטְא הַשֹּׁכֵן בְּקִרְבִּי׃ ");
INSERT INTO hebsg_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","זֶה הוּא הַחֹק אֲשֶׁר מָצָאתִי בְנַפְשִׁי כַּאֲשֶׁר אֶחְפֹּץ לַעֲשׂוֹת טוֹב כֵּן הָרָע יַעֲמֹד נֶגְדִּי׃ ");
INSERT INTO hebsg_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","כִּי בְתוֹרַת אֱלֹהִים חֶפְצִי כְּחֵפֶץ הָאָדָם הַפְּנִימִי׃ ");
INSERT INTO hebsg_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","אַךְ תּוֹרָה אַחֶרֶת אֲנִי מוֹצֵא בְקֶרֶב מֵעַי הַנִּלְחֶמֶת בְּתוֹרַת שִׂכְלִי וְנַפְשִׁי בַּשְּׁבִי הָלְכָה לִפְנֵי תוֹרַת הַחֵטְא אֲשֶׁר בְּקֶרֶב מֵעָי׃ ");
INSERT INTO hebsg_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","אוֹי לְגֶבֶר אֻמְלָל כָּמֹנִי מִי יַצִּילֵנִי מִגּוּף הַמָּוֶת הַלָּזֶה׃ ");
INSERT INTO hebsg_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","אוֹדֶה הַפַּעַם אֶת־אֱלֹהִים בְּיֵשׁוּעַ הַמָּשִׁיחַ אֲדֹנֵינוּ וּבְכֵן אֵפוֹא עֹבֵד אֲנִי בְּרוּחִי אֶת־תּוֹרַת הָאֱלֹהִים וּבִבְשָׂרִי אֶת־תּוֹרַת הַחֵטְא׃ ");
INSERT INTO hebsg_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","עַל־כֵּן אֵפוֹא אֵין־אַשְׁמָה לַדְּבֵקִים בְּיֵשׁוּעַ הַמָּשִׁיחַ הַמִּתְהַלְכִים שֶׁלֹא כַבָּשָׂר אֶלָא לְפִי הָרוּחַ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","כִּי תּוֹרַת רוּחַ הַחַיִּים בְּיֵשׁוּעַ הַמָּשִׁיחַ חִלְצָה אֶת־נַפְשִׁי מִתּוֹרַת הַחֵטְא וְהַמָּוֶת׃ ");
INSERT INTO hebsg_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","כִּי אֶת־אֲשֶׁר לֹא שָׁתָה הַתּוֹרָה כִּי קָצְרָה יָדָהּ לִכְבּשׁ אֶת־הַבָּשָׂר שָׁת אֱלֹהִים בְּשָׁלְחוֹ אֶת־בְּנוֹ בִּדְמוּת בְּשַׂר הָאָדַם הַחֹטֵא לְקָרְבָּן עַל־הַחֵטְא וּשְׁפָטוֹ לְהָתֵם הַחֵטְא בִּבְשָׂרוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","לְמַעַן תּוּקַם צִדְקַת הַתּוֹרָה בָּנוּ הַהֹלְכִים בְּדֶרֶךְ הַחַיִּים לְפִי־הָרוּחַ וְלֹא לְפִי־הַבָּשָׂר׃ ");
INSERT INTO hebsg_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","כִּי הַהֹלְכִים לְפִי־הַבָּשָׂר יֶהְגּוּ בְּדִבְרֵי הַבָּשָׂר וְהַהֹלְכִים לְפִי־הָרוּחַ בְּדִבְרֵי הָרוּחַ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","כִּי הֶגְיוֹן הַבָּשָׂר מָוֶת וְהֶגְיוֹן הָרוּחַ חַיִּים וְשָׁלוֹם׃ ");
INSERT INTO hebsg_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","יַעַן הֶגְיוֹן הַבָּשָׂר פֹּרֶה שִׂנְאַת אֱלֹהִים כִּי לֹא נִכְנַע מִפְּנֵי תוֹרָתוֹ וְגַם־לְהִכָּנַע לֹא יוּכָל׃ ");
INSERT INTO hebsg_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","וְאֵלֶּה אֲשֶׁר חַיֵּי בְשָׂרִים חַיֵּיהֶם לֹא יוּכְלוּ לְהָפִיק רָצוֹן מֵאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","וְאַתֶּם לֹא חַיֵּי בְשָׂרִים חַיֵּיכֶם כִּי אִם־חַיֵּי הָרוּחַ אִם רַק רוּחַ הָאֱלֹהִים שֹׁכֵן בְּתוֹכְכֶם אֶל־נָכוֹן אַךְ מִי אֲשֶׁר אֵין לוֹ רוּחַ הַמָּשִׁיחַ לֹא לוֹ הוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","וְאִם־הַמָּשִׁיחַ יֵשׁ בָּכֶם הִנֵּה הַגּוּף מֵת הוּא עֵקֶב הַחֵטְא אַךְ הָרוּחַ חַי עֵקֶב הַצְּדָקָה׃ ");
INSERT INTO hebsg_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","וְאִם־רוּחַ אֵל הַמֵּקִים אֶת־יֵשוּעַ מִן־הַמֵּתִים יִשְׁכֹּן בָּכֶם הֲלֹא הוּא אֲשֶׁר הֵקִים אֶת־יֵשׁוּעַ הַמָּשִׁיחַ מִן־הַמֵּתִים יִתֵּן חַיִּים גַּם־לְעַצְמוֹתֵיכֶם הַלְּקֻחִים לַמָּוֶת בָּרוּחַ הַהוּא הַשֹּׁכֵן בָּכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","לָכֵן אַחַי לֹא לַבָּשָׂר נָדָרְנוּ לִחְיוֹת חַיֵּי בְשָׂרִים׃ ");
INSERT INTO hebsg_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","כִּי אִם־חַיֵּי בְשָׂרִים תִחְיוּ מוּת תְּמֻתוּן וְאִם בָּרוּחַ תַּכְחִידוּ אֶת־מַעַלְלֵי הַבָּשָׂר חָיֹה תִחְיוּן׃ ");
INSERT INTO hebsg_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","כִּי כָל־אֵלֶּה אֲשֶׁר בְּרוּחַ אֱלֹהִים יוּבָלוּ בְּנֵי אֱלֹהִים הֵמָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","כִּי לֹא רוּחַ עַבְדוּת קִבַּלְתֶּם אֲשֶׁר תָּשׁוּבוּ לְיִרְאָה כִּי אִם־רוּחַ כְּמִשְׁפַּט הַבָּנִים אֲשֶׁר בּוֹ אָנוּ קֹרִאים אַבָּא אָבִינוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","הוּא הָרוּחַ הַנֹּתֵן עֵדוּת לְנַפְשֵׁנוּ כִּי־בְנֵי אֱלֹהִים הִנֵּנוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","וְאִם־בָּנִים גַּם־יֹרְשִׁים אֲנַחְנוּ יֹרְשֵׁי נַחֲלַת אֱלֹהִים חֵלֶק כְּחֵלֶק עִם־הַמָּשִׁיחַ אִם־אָמְנָם נִתְעַנֶּה עִמּוֹ לְמַעַן גַּם־עִמּוֹ נִכָּבֵד׃ ");
INSERT INTO hebsg_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","כִּי שָׁקַלְתִּי סֵבֶל הַזְמָן הַזֶּה וְאֵינֶנּוּ שׁוֶֹה לְהִשָּׁקֵל עִם־הַכָּבוֹד הַבָּא אֲשֶׁר יֵרָאֶה עָלֵינוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","כִּי גַּם־עֵינֵי הַבְּרִיאָה תְּלוּיוֹת בְּצִפִּיָּתָהּ עַד־יִגָּלֶה כְבוֹד בְּנֵי הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","כִּי לֹא בִרְצוֹנָה נִכְבְּשָׁה הַבְּרִיאָה לְהַבְלֵי־שָׁוְא כִּי אִם־בִּרְצוֹן הַכֹּבֵשׁ אֹתָהּ אֲשֶׁר הִנִּיחַ לָהּ פֶּתַח תִּקְוָה׃ ");
INSERT INTO hebsg_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","כִּי תִגָּאֵל מֵעַבְדוּתָהּ וּמִשְּׁחִיתוֹתֶיהָ לִדְרוֹר לִצְבִי וּלְכָבוֹד עִם־בְּנֵי הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","כִּי הַבְּרִיאָה כֻלָּהּ יָדַעְנוּ כִּי תֶאֱנֹק תִּזְעַק בַּחֲבָלֶיהָ עַד־עָתָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","וְלֹא־הִיא לְבַדָּהּ כִּי אִם־גַּם אָנוּ אֲשֶׁר לָקַחְנוּ רֵאשִׁית הַחֵלֶק כִּפְרִי בִכּוּרִים בְּמַתְּנַת הָרוּחַ גַּם־אָנוּ נֶאֱנָחִים בְּנַפְשֵׁנוּ וּמְחַכִּים לְמִשְׁפַּט הַבָּנִים לִפְדוּת גְּוִיָּתֵנוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","כִּי תְשׁוּעָתֵנוּ עַד־כֹּה רַק בַּתִּקְוָה הִיא אוּלָם תִּקְוָה נִרְאָה לָעֵינַיִם לֹא־עוֹד תִּקְוָה הִיא כִּי דָבָר אֲשֶׁר יִרְאֶה אָדָם בְּעֵינָיו לָמָּה יְקַוֶּה לוֹ עוֹד׃ ");
INSERT INTO hebsg_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","אַךְ אִם־נְקַוֶּה לַדָּבָר אֲשֶׁר לֹא רָאִינוּ נוֹחִיל לוֹ הוֹחִיל וְדוּמָם עַד־בּוֹאוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","וְכָזֹאת גַּם־הָרוּחַ עַזֹר יַעְזָר־לָנוּ בְּרִפְיוֹנֵנוּ כִּי מָה אֵפוֹא לְהִתְפַּלֵּל לֹא נֵדַע כַּאֲשֶׁר נָכוֹן לָנוּ אַךְ הָרוּחַ הַהוּא מַפְגִּיעַ בַּעֲדֵנוּ בַּאֲנָחוֹת עָמְקוּ מִסַּפֵּר׃ ");
INSERT INTO hebsg_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","וְהַבֹּחֵן לִבּוֹת הוּא יֹדֵעַ מָה הֶגְיוֹן הָרוּחַ אֲשֶׁר כְּלֵב אֱלֹהִים בְּעַד קְדשָׁיו יַפְגִּיעַ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","וְכָל־הַמַּעֲשִׂים יָדַעְנוּ כִּי יַעְזְרוּ יַחְדָּו לְטוֹבָה לְאֹהֲבֵי אֱלֹהִים הַקְּרֻאִים בְּסוֹד עֲצָתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","כִּי אֶת־אֵלֶּה אֲשֶׁר יָדַע מִקֶּדֶם אֹתָם יָעַד גַּם־מֵאָז כִּי יִשְׁווּ לִדְמוּת בְּנוֹ לְבַעֲבוּר יִהְיֶה הוּא הַבְּכוֹר לְאַחִים רַבִּים׃ ");
INSERT INTO hebsg_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","וְאֶת־אֵלֶּה אֲשֶׁר יָעַד מֵאָז אֹתָם גַּם־קָרָא וְאֶת־אֵלֶּה אֲשֶׁר קָרָא אֹתָם גַּם־הִצְדִּיק וְאֶת־אֵלֶּה אֲשֶׁר הִצְדִּיק אֹתָם גַּם־כִּבֵּד׃ ");
INSERT INTO hebsg_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","וּמַה־נֹּאמַר עַתָּה עַל־זֹאת אִם־אֱלֹהִים לָנוּ מִי יִתְיַצֵּב בְּפָנֵינוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","הֵן הוּא לֹא חָמַל עַל בֶּן־סְגֻלָּתוֹ כִּי אִם־הִסְגִּירוֹ בְּעַד כֻּלָּנוּ הֲכִי עִמּוֹ לֹא יִתֶּן־לָנוּ כָּל־מִשְׁאֲלוֹתֵינוּ כְּרֹב חַסְדּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","מִי יָשִׁית חַטָּאת עַל־בְּחִירֵי הָאֱלֹהִים הֵן הָאֱלֹהִים הוּא הַמַּצְדִּיק׃ ");
INSERT INTO hebsg_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","מִי־הוּא זֶה הַמַּרְשִׁיעַ הֲלֹא יֵשׁוּעַ הַמָּשִׁיחַ מֵת וָחָי וְגַם־ישֵׁב לִימִין הָאֱלֹהִים וְגַם־הוּא מַפְגִּיעַ בַּעֲדֵּנוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","מִי יַפְרִידֵנוּ מֵאַהֲבַת הַמָּשִׁיחַ הַאִם צַר מֵצִיק וְרֹדֵף אוֹ רְעָבוֹן וּמַעֲרֻמָּה פִּי־חֶרֶב וְכָל־מוֹקְשֵׁי מָוֶת׃ ");
INSERT INTO hebsg_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","כַּכָּתוּב כִּי־עָלֶיךָ הֹרַגְגוּ כָל־הַיּוֹם נֶחְשַׁבְנוּ כְּצֹאן טִבְחָה׃ ");
INSERT INTO hebsg_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","וּבְכָל־אֵלֶּה יֶתֶר הַרְבֵּה מִמְּנַצְּחִים יָכֹל נוּכַל בְּיַד הָאֹהֵב אֶת־נַפְשֵׁנוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","כִּי בָטַחְתִּי כִּי לֹא מָוֶת וְלֹא חַיִּים לֹא מַלְאֲכֵי אֵל לֹא שָׂרֵי הַצָּבָא לֹא אֵלֶּה אֲשֶׁר יֶשְׁנָם וְלֹא אֵלֶּה אֲשֶׁר עֲתִדִים לָבֹא וְלֹא גִבֹּרֵי כֹחַ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","וְלֹא רוּם וְלֹא עֹמֶק וְלֹא אֵיזֶה יְקוּם אַחֵר יִהְיֶה לְאֵל יָדָם לְהַפְרִידֵנוּ מֵאַהֲבַת הָאֱלֹהִים אֲשֶׁר בְּיֵשׁוּעַ הַמָּשִׁיחַ אֲדֹנֵינוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","הִנֵּה אֱמֶת אֲנִי דֹבֵר בַּמָּשִׁיחַ וְלֹא אֲכַזֵּב וְחִקְרֵי לִבִּי יְעִידוּן לִי בְּרוּחַ הַקֹּדֶשׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","כִּי צַר לִי מְאֹד וְכָל־הַיּוֹם לִבִּי עָלַי דַּוָּי׃ ");
INSERT INTO hebsg_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","עַד אֲשֶׁר־בִּקְשָׁה נַפְשִׁי לֵאמֹר לוּ הַחֲרֵם יַחֲרִים הַמָּשִׁיחַ אֹתִי תַּחַת אַחַי שְׁאֵרִי וּבְשָׂרִי׃ ");
INSERT INTO hebsg_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","אֲשֶׁר הֵם בְּנֵי יִשְׂרָאֵל וְלָהֶם מִשְׁפַּט הַבָּנִים וְהַכָּבוֹד וְהַבְּרִיתוֹת מַתָּן הַתּוֹרָה עֲבֹדַת הַקֹּדֶשׁ וְדִבְרֵי הַהַבְטָחוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","הָאָבוֹת לָהֶם הֵם וְהַמָּשִׁיחַ לְפִי־בְשָׂרוֹ מֵהֶם יָצָא אֲשֶׁר עַל־הַכֹּל הוּא הָאֱלֹהִים הַמְבֹרָךְ לְעוֹלָם וָעֶד אָמֵן׃ ");
INSERT INTO hebsg_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","אֶפֶס לֹא־כֵן הַדָּבָר וּדְבַר־אֱלֹהִים לֹא נָפַל אָרְצָה כִּי לֹא־כֻּלָּם אֲשֶׁר מִיִּשְׂרָאֵל יִשְׂרְאֵלִים הֵם׃ ");
INSERT INTO hebsg_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","וְלֹא כָל־זֶרַע אַבְרָהָם בָּנִים הֵם כִּי אַךְ בְּיִצְחָק יִקָּרֵא לְךָ זָרַע׃ ");
INSERT INTO hebsg_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","וְזֶה יוֹרֵנוּ כִּי לֹא בְנֵי־הַבָּשָׂר בְּנֵי אֱלֹהִים הֵם כִּי אִם־רַק בְּנֵי הַהַבְטָחָה יֵחָשְׁבוּ לְזָרַע׃ ");
INSERT INTO hebsg_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","כִּי זֶה דְבַר הַהַבְטָחָה לַמּוֹעֵד אָשׁוּב וּלְשָׂרָה בֵן׃ ");
INSERT INTO hebsg_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","וּמִלְּבַד זֹאת גַּם־רִבְקָה בִּהְיוֹתָהּ הָרָה בֶן־יָחִיד לְיִצְחָק אָבִינוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","בְּטֶרֶם נוֹלְדוּ יְלָדֶיהָ עַד לֹא־עָשׂוּ מְאוּמָה מִטּוֹב עַד־רָע לְמַעַן תָּקוּם עֲצַת אֱלֹהִים לְפִי־בְחִירָתוֹ לֹא עֵקֶּב מַעֲשִׂים כִּי אִם־כִּרְצוֹן הַבֹּחֵר׃ ");
INSERT INTO hebsg_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","הֻגַּד לָהּ כִּי־רַב יַעֲבֹד צָעִיר׃ ");
INSERT INTO hebsg_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","כַּכָּתוּב וָאֹהַב אֶת־יַעֲקֹב וְאֶת־עֵשָׂו שָׂנֵאתִי׃ ");
INSERT INTO hebsg_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","וּמַה־נֹּאמַר עָתָּה הֲכִי יֵשׁ עַוְלָתָה בֵאלֹהִים חָלִילָה׃ ");
INSERT INTO hebsg_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","כִּי אֶל־משֶׁה אָמַר וְחַנֹּתִי אֶת־אֲשֶׁר אָחֹן וְרִחַמְתִּי אֶת־אֲשֶׁר אֲרַחֵם׃ ");
INSERT INTO hebsg_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","וּמִפְּנֵי זֶה אֵין הַדָּבָר בְּיַד הָרֹצֶה וְלֹא בְּיַד הָרָץ כִּי אִם־בְּיַד אֱלֹהֵי הַחֲנִינָה׃ ");
INSERT INTO hebsg_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","כִּי־כֵן הַכָּתוּב אֹמֵר לְפַרְעֹה בַּעֲבוּר זֹאת הֶעֱמַדְתִּיךָ בַּעֲבוּר הַרְאֹתְךָ אֶת־כֹּחִי וּלְמַעַן סַפֵּר שְׁמִי בְּכָל־הָאָרֶץ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","וְזֶה יוֹרֶה לָּנוּ כִּי אֶת־אֲשֶׁר יִרְצֶה יְחֻנֶּנּוּ וְאֶת־אֲשֶׁר יִרְצֶה יַכְבִּיד אֶת־לִבּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","וְכִי תֹאמַר אֵלַי הֲלֹא רְצוֹנוֹ אֵין לְהַפְרִיעַ וְאִם־כֵּן לָמָּה־זֶּה יִפְקֹד עָוֹן׃ ");
INSERT INTO hebsg_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","אֲבָל מִי אַתָּה הוּא בֶּן־אָדָם כִּי תָרִיב רִיב עִם־הָאֱלֹהִים הֲיֹאמַר יֵצֶר לְיֹצְרוֹ לָמָּה־זֶּה כֹּה יְצַרְתָּנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","הַאֵין שִׁלְטוֹן לְיֹצֵר הַחֹמֶר לַעֲשׂוֹת מִגֹּלֶם הַהוּא כְּלִי אֶחָד לְכָבוֹד וּכְלִי אַחֵר לְקָלוֹן׃ ");
INSERT INTO hebsg_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","וּמָה אֵפוֹא אִם־חָפֵץ הָאֱלֹהִים לְהַרְאוֹת אֶת־זַעְמוֹ וּלְהוֹדִיעַ אֶת־גְּבוּרָתוֹ וְיִשָּׂא בְּאֹרֶךְ רוּחוֹ אֶת־כְּלֵי הַזַּעַם אֲשֶׁר נָכוֹנוּ לַאֲבַדּוֹן׃ ");
INSERT INTO hebsg_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","וְאֶת־עשֶׁר תִּפְאַרְתּוֹ הוֹדִיעַ בִּכְלֵי הַחֲנִינָה אֲשֶׁר הֲכִינָם מֵאָז לְכָבוֹד׃ ");
INSERT INTO hebsg_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","וּכְלֵי הַחֲנִינָה אֲנַחְנוּ אֵלֶּה אֲשֶׁר בָּחַר בָּנוּ לֹא מִן־הַיְּהוּדִים לְבַדָּם כִּי אִם־גַּם מִן־הַגּוֹיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","כַּאֲשֶׁר גַּם־דִּבֶּר בְּהוֹשֵׁעַ אֶקְרָא לְלֹא־עַמִּי עַמִּי׃ ");
INSERT INTO hebsg_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","וּלְלֹא־רֻחָמָה רֻחָמָה וְהָיָה בִּמְקוֹם אֲשֶׁר־יֵאָמֵר לָהֶם לֹא־עַמִּי אַתֶּם שָׁם יִקָּרְאוּ בְּנֵי אֵל־חָי׃ ");
INSERT INTO hebsg_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","וִישַׁעְיָה קֹרֵא עַל־יִשְׂרָאֵל לֵאמֹר כִּי אִם־יִהְיֶה מִסְפַּר בְּנֵי יִשְׂרָאֵל כְּחוֹל הַיָּם שְׁאָר יָשׁוּב בּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","כִּלָּיוֹן חָרוּץ שׁוֹטֵף צְדָקָה כִּי כָלָה וְנֶחֱרָצָה אֲדֹנָי עֹשֶׂה בְּקֶרֶב הָאָרֶץ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","וְכַאֲשֶׁר אָמַר יְשַׁעְיָה לְפָנִים לוּלֵי יְהוָֹה צְבָאוֹת הוֹתִיר לָנוּ זָרַע כִּסְדֹם הָיִינוּ לַעֲמֹרָה דָּמִינוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","וְעַתָּה מַה־נֹּאמַר כִּי הַגּוֹיִם אֲשֶׁר לֹא רָדְפוּ אֶת־הַצְּדָקָה הִשִּׂיגוּ צְדָקָה הִיא הַצְּדָקָה אֲשֶׁר מִמְּקוֹר אֱמוּנָה׃ ");
INSERT INTO hebsg_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","וּבְנֵי יִשְׂרָאֵל אֲשֶׁר רָדְפוּ אֶת־תּוֹרַת הַצְּדָקָה לֹא הִשִּׂיגוּ אֶת־תּוֹרַת הַצְּדָקָה׃ ");
INSERT INTO hebsg_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","וְיַעַן־מָה יַעַן כִּי־לֹא בֶאֱמוּנָה רָדְפוּ כִּי מִמַּעֲשֵׂי הַתּוֹרָה בִּפְעֻלּוֹת וַיִּתְנַגְּפוּ בְּאֶבֶן נָגֶף׃ ");
INSERT INTO hebsg_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","כַּכָּתוּב הִנְנִי יִסַּד בְּצִיּוֹן אֶבֶן נֶגֶף וְצוּר מִכְשׁוֹל וְהַמַּאֲמִין בּוֹ לֹא יֵבוֹשׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","אַחַי תַּאֲוַת לִבִּי וּתְפִלָּתִי לֵאלֹהִים בְּעַד יִשְׂרָאֵל אֲשֶׁר יִוָּשֵׁעוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","כִּי עֵדוּת אֲנִי לָהֶם כִּי קִנְאַת אֱלֹהִים אִתָּם אַךְ לֹא־בְהַשְׂכֵּל׃ ");
INSERT INTO hebsg_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","כִּי מֵאֲשֶׁר צִדְקַת אֱלֹהִים הִשְׂכִּילוּ וַיִּתְאַמְּצוּ לְהָקִים צִדְקַת נַפְשָׁם לֹא נִכְנַע לִבָּם לִפְנֵי צִדְקַת אֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","כִּי תַכְלִית הַתּוֹרָה הוּא הַמָּשִׁיחַ לִצְדָקָה לְכָל־הַמַּאֲמִין בּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","כִּי משֶׁה כֹתֵב עַל־הַצְּדָקָה לְפִי מִשְׁפְּטֵי הַתּוֹרָה אֲשֶׁר יַעֲשֶׂה אֹתָם הָאָדָם וָחַי בָּהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","וְהַצְּדָקָה מִמְּקוֹר הָאֱמוּנָה תִּקְרָא כָזֹאת אַל־תֹּאמַר בִּלְבָבְךָ מִי יַעֲלֶה הַשָּׁמָיְמָה זֶה הוּא לְהוֹרִיד אֶת־הַמָּשִׁיחַ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","אוֹ מִי־יֵרֵד שְׁאֹלָה זֶה הוּא לְהַעֲלוֹת אֶת־הַמָּשִׁיחַ מִן־הַמֵּתִים׃ ");
INSERT INTO hebsg_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","וּמָה הִיא אֹמֶרֶת כִּי קָרוֹב אֵלֶיךָ הַדָּבָר בְּפִיךָ וּבִלְבָבֶךָ וְזֶה הוּא דְבַר הָאֱמוּנָה אֲשֶׁר אֲנַחְנוּ מְבַשְּׂרִים׃ ");
INSERT INTO hebsg_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","כִּי אִם־בְּפִיךָ תוֹדֶה כִּי יֵשׁוּעַ הוּא הָאָדוֹן וּבִלְבָבְךָ תַאֲמִין כִּי אֱלֹהִים הֲקִימוֹ מִן־הַמֵּתִים תִּוָּשֵׁעַ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","כִּי בִלְבָבוֹ יַאֲמִין בּוֹ הָאָדָם וְהָיָה־לוֹ לִצְדָקָה וּבְפִיהוּ יוֹדֶה־לּוֹ וְהָיָה־לוֹ לִישׁוּעָה׃ ");
INSERT INTO hebsg_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","כִּי הַכָּתוּב אֹמֵר וְהַמַּאֲמִין בּוֹ לֹא יֵבוֹשׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","וְאֵין מַבְדִּיל בֵּין־יְהוּדִי לַיְּוָנִי כִּי הֲלֹא הוּא אֲדוֹן־כֹּל וְרַב חֶסֶד לְכָל־קֹרְאָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","כִּי־כֹל אֲשֶׁר־יִקְרָא בְשֵׁם יְהוָֹה יִמָּלֵט׃ ");
INSERT INTO hebsg_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","אָכֵן אֵיךְ יִקְרְאוּ אֵלָיו אֲשֶׁר לֹא הֶאֱמִינוּ־בוֹ וְאֵיךְ יַאֲמִינוּ־בוֹ אֲשֶׁר לֹא שָׁמְעוּ עָלָיו וְאֵיךְ יִשְׁמְעוּ בְּאֵין מַגִּיד׃ ");
INSERT INTO hebsg_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","וְאֵיךְ יַגִּידוּ אִם־אֵין שֹׁלֵחַ אֹתָם כַּכָּתוּב מַה־נָּאווּ רַגְלֵי מְבַשֵׂר שָׁלוֹם מְבַשֵׂר טוֹב׃ ");
INSERT INTO hebsg_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","אַךְ לֹא־כֻלָּם שָׁמְעוּ אֶל־הַבְּשׂרָה כִּי יְשַׁעְיָהוּ אָמַר יְהוָֹה מִי הֶאֱמִין לִשְׁמֻעָתֵנוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","אֲשֶׁר לָזֹאת הָאֱמוּנָה בָאָה מִפִּי הַשְּׁמוּעָה וְהַשְּׁמוּעָה הִיא בִּדְבַר אֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","אַךְ אֲנִי אֹמֵר הֲכִי לֹא שָׁמָעוּ הֲלֹא בְּכָל־הָאָרֶץ יָצָא קוֹלָם וּבִקְצֵה תֵבֵל מִלֵּיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","וְעוֹד אֲנִי אֹמֵר הֲכִי לֹא יָדַע יִשְׂרָאֵל וּמִקֶּדֶם אָמַר משֶׁה אֲנִי אַקְנִיאֲכֶם בְּלֹא־עָם בְּגוֹי נָבָל אַכְעִיסְכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","וִישַׁעְיָה יָעֹז לֵאמֹר נִמְצֵאתִי לְלֹא בִקְשֻׁנִי נִגְלֵיתִי לְלוֹא שְׁאָלוּנִי׃ ");
INSERT INTO hebsg_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","וְעַל־יִשְׂרָאֵל הוּא אֹמֵר פֵּרַשְׂתִּי יָדַי כָּל־הַיּוֹם אֶל־עַם סוֹרֵר וּמֹרֶה׃ ");
INSERT INTO hebsg_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","וַאֲנִי אֹמֵר כַּיּוֹם הֲכִי הִשְׁלִיךְ אֱלֹהִים אֶת־עַמּוֹ מֵעַל־פָּנָיו חָלִילָה גַּם־אָנֹכִי יִשְׂרְאֵלִי אֲנִי מִזֶּרַע אַבְרָהָם לְמַטֵּה בִנְיָמִין׃ ");
INSERT INTO hebsg_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","לֹא־הִשְׁלִיךְ אֱלֹהִים מֵעַל־פָּנָיו אֶת־עַמּוֹ אֲשֶׁר יְדָעוֹ מִקֶּדֶם הֲלֹא יְדַעְתֶּם אֶת־אֲשֶׁר יֹאמַר הַכָּתוּב בְּאֵלִיָּהוּ בְּהִתְאוֹנְנוֹ עַל־יִשְׂרָאֵל לִפְנֵי אֱלֹהִים לֵאמֹר׃ ");
INSERT INTO hebsg_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","יְהוָֹה אֶת־נְבִיאֶיךָ הָרְגוּ וְאֶת־מִזְבְּחֹתֶיךָ הָרָסוּ וָאִוָּתֵר אֲנִי לְבַדִּי וַיְבַקְשׁוּ אֶת־נַפְשִׁי לְקַחְתָּה׃ ");
INSERT INTO hebsg_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","וּמַה יַּעֲנֶה אֹתוֹ דְּבַר אֱלֹהִים הִשְׁאַרְתִּי לִי שִׁבְעַת אֲלָפִים אִישׁ אֲשֶׁר לֹא־כָרְעוּ עַל־בִּרְכַּיִם לַבָּעַל׃ ");
INSERT INTO hebsg_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","וְכֵן גַּם־בַּיּוֹם הַזֶּה הִשְׁאִיר לוֹ שְׁאֵרִית כַּאֲשֶׁר בָּחַר בָּהֶם בְּחָסֶד׃ ");
INSERT INTO hebsg_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","וְאִם בְּחֶסֶד לֹא עָשָׂה זֹאת עוֹד בִּשְׂכַר מַעֲשֶׂה כִּי אִם־כֵּן הַחֶסֶד אֵינֶנּוּ עוֹד חָסֶד וְאִם־הָיְתָה מִתּוֹךְ הַמַּעֲשִׂים אֵינֶנוּ־עוֹד חֶסֶד כִּי אִם־כֵּן הַמַּעֲשֶׂה יֶחְדַּל לִהְיוֹת מַעֲשֶׂה׃ ");
INSERT INTO hebsg_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","וְעַתָּה מָה אֵפוֹא בְּנֵי יִשְׂרָאֵל לֹא הִשִּׂיגוּ אֶת־אֲשֶׁר בִּקְשׁוּ רַק הַנִּבְחָרִים הִשִּׂיגוּ וְהַנּוֹתָרִים הֻכּוּ בָּעִוָּרוֹן׃ ");
INSERT INTO hebsg_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","כַּכָּתוּב נָתַן לָהֶם יְהוָֹה רוּחַ תַּרְדֵּמָה עֵינַיִם לֹא לִרְאוֹת וְאָזְנַיִם לֹא לִשְׁמֹעַ עַד־הַיּוֹם הַזֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","וְדָוִד אֹמֵר יְהִי שֻׁלְחָנָם לְפַח וּלְרָשֶׁת וּלְמוֹקֵשׁ וּלְשִׁלּוּמִים לָהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","תֶּחֱשַׁכְנָה עֵינֵיהֶם מֵרְאוֹת וּמָתְנֵיהֶם תָּמִיד הַמְעֵד׃ ");
INSERT INTO hebsg_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","וַאֲנִי אֹמֵר כַּיּוֹם הֲכִי נוֹקְשׁוּ לְמַעַן יִפְּלוּ וְלֹא יוֹסִיפוּ קוּם חָלִילָה אַךְ בְּמַפַּלְתָּם יָצְאָה יְשׁוּעָה לַגּוֹיִים לְמַעַן הַקְנִיאָם׃ ");
INSERT INTO hebsg_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","אַךְ אִם־מַפַּלְתָּם הָיְתָה תְּשׁוּעַת הָעוֹלָם וְנִזְקָם לְחֵיל גּוֹיִם אַף כִּי קוּמָם וְהֵם מְלֵאִים׃ ");
INSERT INTO hebsg_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","וַאֲלֵיכֶם הַגּוֹיִם אֲנִי דֹבֵר אַחֲרֵי אֲשֶׁר שָׁלִיחַ לַגּוֹיִים אָנֹכִי אֶת־מִשְׁמַרְתִּי אֲכַבֵּדָה׃ ");
INSERT INTO hebsg_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","אוּלַי אַקְנִיא אֶת־בְּנֵי עַמִּי וּבְשָׂרִי וְהוֹשַׁעְתִּי לַאֲחָדִים מֵהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","כִּי אִם־מֵאֲשֶׁר נִדְּחוּ בָּאָה עֵת רָצוֹן לְישְׁבֵי תֵבֵל מָה־אֵפוֹא תִהְיֶה לָעֵת יִקָּבְצוּ הֲלֹא חַיִּים מִן־הַמֵּתִים׃ ");
INSERT INTO hebsg_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","וְאִם־רֵאשִׁית הָעֲרִסָה קֹדֶשׁ כֵּן גַּם־הָעֲרִיסָה וְאִם־שֹׁרֶשׁ הָעֵץ קֹדֶשׁ כֵּן גַּם־עֲנָפָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","וְכִי נִקְטְפוּ מִן־הָעֲנָפִים וְאַתָּה זֵית הַיַּעַר נִטַּעְתָּ בִמְקוֹמָם וַתִּתְעָרֶה בְּשֹׁרֶשׁ הַזַּיִת וּבְדִשְׁנוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","אַל־תִּתְנַשֵּׂא עַל־הָעֲנָפִים וְאִם־תִּתְנַשֵּׂא זְכֹר כִּי לֹא אַתָּה תִשָּׂא אֶת־הַשֹּׁרֶשׁ כִּי אִם־הַשֹּׁרֶשׁ יִשָּׂא אֹתָךְ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","וְהֵן תַּעֲנֶה הֲלֹא נִקְטְפוּ הָעֲנָפִים לְהַרְכִּיב אֹתִי עֲלֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","כֵּן דִּבַּרְתָּ הֵן נִקְטְפוּ בְחֹסֶר אֱמוּנָתָם וְאַתָּה נִצָּב בֶּאֱמוּנָתֶךָ אַל־יִגְבַּהּ לִבְּךָ כִּי אִם־יְרָא׃ ");
INSERT INTO hebsg_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","כִּי אִם־לֹא חָמַל אֱלֹהִים עַל־הָעֲנָפִים הָאֱזְרָחִים הֲלֹא גַּם־עָלֶיךָ לֹא־יַחְמֹל׃ ");
INSERT INTO hebsg_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","שׁוּר־נָא אֵפוֹא חֶסֶד אֱלֹהִים וּמִשְׁפָּטוֹ הַנּוֹרָא לָאֵלֶּה הַנּוֹקָשִׁים מִשְׁפָּט נוֹרָא וּלְךָ חֶסֶד אֱלֹהִים אִם־אָרְחוֹת חֶסֶד תִּשְׁמֹר וְאִם־אַיִן גַּם־אַתָּה תִּגָּדֵעַ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","וְגַם־הֵם אִם־לֹא יַחֲזִיקוּ בְחֹסֶר אֱמוּנָתָם יִטָּעוּ כִּי־יָכֹל אֱלֹהִים לָשׁוּב לָטַעַת אֹתָם׃ ");
INSERT INTO hebsg_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","כִּי אִם־אַתָּה נִקְטַפְתָּ מִזֵּית הַיַּעַר בְּאַדְמַת מוֹלַדְתּוֹ וְנִטַּעְתָּ בְמוֹ־זַיִת טוֹב אֲשֶׁר לֹא כְחֻקֶּךָ אַף־כִּי הָעֲנָפִים הָאֶזְרָחִים בְּמוֹ־זֵיתָם יִטָּעוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","כִּי אֵין־נַפְשִׁי לְכַסּוֹת מִכֶּם אַחַי אֶת־הַסּוֹד הַזֶּה פֶּן־תִּהְיוּ חֲכָמִים בְּעֵינֵיכֶם כִּי יִשְׂרָאֵל הֻכָּה בְּעִוָּרוֹן מִקָּצֶה אֶחָד עַד כִּי־יָבֹא מְלֹא הַגּוֹיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","וּבְכֵן כָּל־יִשְׂרָאֵל יִוָּשֵׁעַ כַּכָּתוּב וּבָא מִצִּיּוֹן גּוֹאֵל וְיָשִׁיב פֶּשַׁע מִיַּעֲקֹב׃ ");
INSERT INTO hebsg_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","וַאֲנִי זֹאת בְּרִיתִי אוֹתָם כִּי־אֶסְלַח לַעֲוֹנָם׃ ");
INSERT INTO hebsg_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","הֵן בִּדְבַר הַבְּשׂוֹרָה שְׂנוּאִים הֵם בִּגְלַלְכֶם אַךְ בִּדְבַר הַבְּחִירָה אֲהוּבִים הֵם בִּגְלַל הָאָבוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","כִּי לֹא־יִנָּחֵם אֱלֹהִים עַל־מַתְּנַת יָדוֹ וְעַל־קְרִיאַת פִּיהוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","כִּי כַּאֲשֶׁר גַּם־אַתֶּם לְפָנִים לֹא הֶאֱמַנְתֶּם בֵּאלֹהִים וְעַתָּה רֻחַמְתֶּם עֵקֶב חֹסֶר אֱמוּנָתָם׃ ");
INSERT INTO hebsg_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","כֵּן גַּם־הֵם לֹא הֶאֱמִינוּ עָתָּה לְמַעַן עֵקֶב רַחֲמֵיכֶם גַּם־הֵמָּה יְרֻחָמוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","כִּי־הִסְגִּיר אֱלֹהִים אֶת־כֻּלָּם לְלֹא־אֱמוּנָה לְמַעַן יְרַחֵם עַל־כֻּלָּמוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","מֶה־עָמֹק תְּהוֹם הַחָכְמָה וְהַדַּעַת לֵאלֹהִים מִי יַחְקֹר מִשְׁפָּטָיו וּדְרָכָיו מִי יִמְצָא׃ ");
INSERT INTO hebsg_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","כִּי מִי־תִכֵּן אֶת־רוּחַ יְהוָֹה וְאִישׁ עֲצָתוֹ יוֹדִיעֶנּוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","אוֹ מִי־הִקְדִּים לָתֵת אֵלָיו וִישֻׁלַּם לוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","כִּי הַכֹּל מִיָּדוֹ הַכֹּל בּוֹ וְהַכֹּל לוֹ הוּא אֲשֶׁר־לוֹ הַכָּבוֹד לְעוֹלָם וָעֶד אָמֵן׃ ");
INSERT INTO hebsg_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","וְעַתָּה אֲנִי מִתְחַנֵּן אֲלֵכֶם אַחַי בָּרַחֲמֵי אֱלֹהִים לְהַקְדִּישׁ אֶת־גְּוִיּוֹתֵיכֶם כְּקָרְבָּן חַי וְקָדוֹשׁ לְרָצוֹן לֵאלֹהִים כִּי־בְזֹאת תַּשְׂכִּילוּ לַעֲבֹד אֹתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","וְאַל־תִּהְיוּ דוֹמִים לִבְנֵי הָעוֹלָם הַזֶּה כִּי אִם־תְּנוּ לִבְּכֶם לְהִתְחַדֵּשׁ וְנֶהְפַּכְתֶּם לַעֲנָשִׁים אֲחֵרִים וְעֵינֵיכֶם לֵאלֹהִים לִבְחֹן מַה־הוּא רְצוֹנוֹ הַטּוֹב וְהַנָּעִים וְהַשָּׁלֵם׃ ");
INSERT INTO hebsg_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","כִּי עַל־פִּי רוּחַ הַחֵן הַנָּתוּן לִי אֶקְרָא לְאִישׁ אִישׁ מִכֶּם לְבִלְתִּי יַעֲרִיךְ אֶת־נַפְשׁוֹ יֶתֶר מֵאֲשֶׁר נָכוֹן לוֹ כִּי אִם־הַעֲרֵךְ וְהַצְנֵעַ לְפִי מִדַּת הָאֱמוּנָה אֲשֶׁר־מָדַד לוֹ אֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","כִּי כַּאֲשֶׁר יְצֻרִים רַבִּים לָנוּ בְּגוּף אֶחָד וְלֹא לְכָל־הַיְצֻרִים מִשְׁמֶרֶת אֶחָת׃ ");
INSERT INTO hebsg_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","כֵּן רַבִּים אֲנַחְנוּ לְגוּף אֶחָד בַּמָּשִׁיחַ וְאִישׁ אִישׁ מִמֶּנּוּ כִּיצוּר לַחֲבֵרוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","וְכֵן לָנוּ מַתָּנוֹת שֹׁנוֹת לְפִי רוּחַ הַחֵן הַנָּתוּן לָנוּ אִם־נְבוּאָה נִתְנַבֵּא לְפִי קַו אֱמוּנָתֵנוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","מִי הָעֹמֵד לְשָׁרֵת יְשָׁרֵת כְּאִישׁ חָיִל וְכֵן הַמּוֹרֶה יוֹרֶה כַּמִּשְׁפָּט׃ ");
INSERT INTO hebsg_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","הַמוֹכִיחַ יַשְׂכִּיל פִּיהוּ בְתוֹכַחְתּוֹ הַנֹּתֵן יִדְּבֶנּוּ לִבּוֹ בְּמַתְּנַת יָדוֹ הָעֹמֵד בְּרֹאשׁ הָעֵדָה יַעֲמֹד כְּאִישׁ חָרוּץ וְהַגֹּמֵל חֶסֶד יִגְמֹל בְּטוּב לֵב׃ ");
INSERT INTO hebsg_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","אַל־תְּהִי אַהֲבַתְכֶם בִּשְׂפַת חֲלָקוֹת שִׁנְאוּ אֶת־הָרָע וְדִבְקוּ בַּטּוֹב׃ ");
INSERT INTO hebsg_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","אֶהֱבוּ אִישׁ אֶת־אָחִיהוּ מִמְּקוֹר רַחֲמֵיכֶם וְכַבְּדוּ אִישׁ אֶת־חֲבֵרוֹ יוֹתֵר מִנַּפְשְׁכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","שִׁקְדוּ עַל־מַעֲשֵׂיכֶם וְאַל־תֵּעָצְלוּ הִתְאשְׁשׁוּ בָרוּחַ וְעִבְדוּ אֶת־יְהוָֹה׃ ");
INSERT INTO hebsg_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","שִׂמְחוּ בַתִּקְוָה הוֹחִילוּ בַצָּרָה חִזְקוּ וְאִמְצוּ בַתְּפִלָּה תָּמִיד׃ ");
INSERT INTO hebsg_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","הִתְחַבְּרוּ לְמַלֹּאת מַחֲסֹרֵי הַקְּדוֹשִׁים וְחוּשׁוּ לְהָבִיא אֹרְחִים לְבָתֵּיכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","בָּרְכוּ אֶת־רֹדְפֵכֶם בָּרְכוּ וְאַל־תְּקַלֵּלוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","שִׂמְחוּ עִם־הַשְּׂמֵחִים וּבְכוּ עִם־הַבֹּכִים׃ ");
INSERT INTO hebsg_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","שִׁיתוּ אֶת לִבְּכֶם לַחְשֹׁב אִישׁ אִישׁ כִּלְבַב אָחִיו אַל־תְּהַלְּכוּ בִגְדֹלוֹת מִכֶּם הִתְרוֹעֲעוּ עִם־עֲנָוִים וְאַל־תִּהְיוּ חֲכָמִים בְּעֵינֵיכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","אַל־תִּגְמְלוּ לְאִישׁ רָעָה תַּחַת רָעָה חוּשׁוּ לַעֲשׂוֹת אֶת־הַטּוֹב בְּעֵינֵי־כֹל׃ ");
INSERT INTO hebsg_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","וְאִם־יֵשׁ מָקוֹם כַּאֲשֶׁר יֶשׁ־לְאֵל יֶדְכֶם הַשְׁלִימוּ עִם־כָּל־אָדָם׃ ");
INSERT INTO hebsg_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","אַל־תִּתְנַקְּמוּ יְדִידִים כִּי אִם־תְּנוּ מָקוֹם לַחֲרוֹן־אָף כִּי כָתוּב לִי נָקָם אֲנִי אֲשַׁלֵם אָמַר יְהוָֹה׃ ");
INSERT INTO hebsg_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","וְאִם־רָעֵב שׂנַאֲךָ הַאֲכִילֵהוּ לֶחֶם וְאִם־צָמֵא הַשְׁקֵהוּ מָיִם כִּי גֶחָלִים אַתָּה חֹתֶה עַל־רֹאשׁוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","אַל־תִּכָּבֵשׁ לִפְנֵי הָרָע כִּי אִם־כְּבֹשׁ אֶת־הָרַע לְפָנֶיךָ בַּטּוֹב׃ ");
INSERT INTO hebsg_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","כָּל־נֶפֶשׁ תִּכָּנַע לִפְנֵי מֶמְשֶׁלֶת הָרָאשִׁים כִּי־אֵין מֶמְשָׁלָה זוּלָתִי הַנְּתוּנָה עַל־פִּי הָאֱלֹהִים וּמֵאִתּוֹ נִהְיוּ הַמֶּמְשָׁלוֹת אֲשֶׁר יֶשְׁנָן׃ ");
INSERT INTO hebsg_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","לָכֵן כָּל־הַמֹּרֵד בַּמֶּמְשָׁלָה הִמְרָה בִּפְקֻדַּת אֱלֹהִים וְהַמַּמְרִים יִשְׂאוּ עֲוֹנָם בְּרֹאשָׁם׃ ");
INSERT INTO hebsg_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","כִּי־הַשַּׁלִּיט אֵינֶנּוּ לִמְחִתָּה לְמַעֲשִׂים טוֹבִים כִּי אִם־לְרָעִים וְכִי־תֹאבֶה כִּי־מֶמְשַׁלְתּוֹ לֹא־תְהִי לְךָ לִמְחִתָּה עֲשֵׂה טוֹב וּתְהִלָּה תִשָּׂא מִלְּפָנָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","כִּי־מְשָׁרֵת אֱלֹהִים הוּא לְטוֹב לָךְ אֶפֶס אִם־אָוֶן פָּעַלְתָּ יְרָא כִּי לֹא־חִנָּם יִשָּׂא אֶת־חַרְבּוֹ וּמְשָׁרֵת אֱלֹהִים הוּא הַנִּשְׁפָּט בְּזַעַם אֶת־פֹּעֵל אָוֶן׃ ");
INSERT INTO hebsg_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","לָכֵן נָכוֹן לָכֶם לְהִכָּנַע לֹא מִפְּנֵי הַזַּעַם לְבַדּוֹ כִּי־אִם גַּם־מִפְּנֵי מוּסַר הַלֵּב׃ ");
INSERT INTO hebsg_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","אֲשֶׁר בַּעֲבוּר זֶה אַתֶּם מְשַׁלְּמִים גַּם אֶת־הַמָּס כִּי־מְשָׁרְתֵי אֱלֹהִים הֵם הַשֹּׁקְדִים עַל־הַדָּבָר הַזֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","הָבוּ לְכָל־אִישׁ אֶת־אֲשֶׁר לוֹ הַמַּס לַאֲשֶׁר־לוֹ הַמַּס הַמֶּכֶס לַאֲשֶׁר־לוֹ הַמֶּכֶס הַיִּרְאָה לַאֲשֶׁר־לוֹ הַיִּרְאָה וְהַכָּבוֹד לַאֲשֶׁר־לוֹ הַכָּבוֹד׃ ");
INSERT INTO hebsg_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","לֹא תָלִינוּ אִתְּכֶם כָּל־חוֹב בִּלְתִּי אַהֲבַת אָדָם לַחֲבֵרוֹ כִּי הָאֹהֵב אֶת־חֲבֵרוֹ קִיֵּם אֶת־הַתּוֹרָה׃ ");
INSERT INTO hebsg_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","כִּי־הִנֵּה לֹא תִנְאָף לֹא תִרְצָח לֹא תִגְנֹב לֹא תַעֲנֶה עֵד שֶׁקֶר לֹא תַחְמֹד עִם כָּל־מִצְוֹת אֲחֵרוֹת יָכִיל אֹתָן הַכָּתוּב וְאָהַבְתָּ לְרֵעֲךָ כָּמוֹךָ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","הָאַהֲבָה לֹא תַעֲשֶׂה רָע לָרֵעַ עַל־כֵּן הָאַהֲבָה הִיא קִיּוּם הַתּוֹרָה׃ ");
INSERT INTO hebsg_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","וְאַף אֶת־הַזְּמָן לֹא תְנַכֵּרוּ כִּי בָא הַמוֹעֵד לְהָקִיץ מִשֵּׁנָה כִּי יְשׁוּעָתֵנוּ קְרֹבָה לָנוּ עַתָּה מִיּוֹם אֲשֶׁר הֲחִלּנוּ לְהַאֲמִין׃ ");
INSERT INTO hebsg_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","הַלַּיְלָה חָלַף הָלַךְ לוֹ וְהַיּוֹם הִגִּיעַ נַעַזְבָה־נָּא אֶת־פָּעֳלֵי הַחֹשֶׁךְ וּכְלֵי נֶשֶׁק הָאוֹר נַחְגֹּרָה׃ ");
INSERT INTO hebsg_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","וּבְמֵישָׁרִים נִתְהַלֵּךְ כְּמוֹ־בַיּוֹם לֹא בְמִרְזַח סְרוּחִים וְשִׁכָּרוֹן לֹא־בְזִמָּה וַעֲגָבִים וְלֹא־בְזָדוֹן וְקִנְאָה׃ ");
INSERT INTO hebsg_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","אַךְ רוּחַ יֵשׁוּעַ הַמָּשִׁיחַ אֲדֹנֵינוּ תִּלְבַּשׁ אֶתְכֶם וְלֹא תְמַלְאוּ מִשְׁאֲלוֹתֵיכֶם לְפִי תַאֲוַת הַבָּשָׂר׃ ");
INSERT INTO hebsg_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","אִישׁ רְפֵה יָדַיִם בֶּאֱמוּנָה קַבְּלֻהוּ בְתוֹכְכֶם וְלֹא לְחִקְרֵי לֵב לִשְׂעִיפָּיו וְעֶשְׁתֹּנֹתָיו׃ ");
INSERT INTO hebsg_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","יֵשׁ מַאֲמִין כִּי כָּל־דָּבָר נָכוֹן לוֹ לֶאֱכֹל וּרְפֵה יָדַיִם זֶה יֹאכַל יָרֶק׃ ");
INSERT INTO hebsg_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","הָאֹכֵל כָּל־מַאֲכָל אַל־יָבוּז לַאֲשֶׁר אֵינֶנּוּ אֹכֵל וַאֲשֶׁר אֵינֶנּוּ אֹכֵל אַל־יִשְׁפֹּט אֶת־הָאֹכֵל כִּי־נָשָׂא פָנָיו אֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","מִי אַתָּה כִּי־תִשְׁפֹּט עֶבֶד לֹא־לָךְ הֵן לַאדֹנָיו הוּא כִּי יָקוּם וְכִי־יִפֹּל וְהוּא יָקוּם כִּי־רַב כֹּחַ יְהוָֹה לַהֲקִימוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","יֵשׁ מַבְדִּיל יוֹם מֵעַל יוֹם וְיֵשׁ אֲשֶׁר יוֹם כַּיּוֹם נֶחְשָׁב־לוֹ יְהִי־נָא כָּל־אִישׁ סָמוּךְ לִבּוֹ בְּדַעְתּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","הַמְכַבֵּד יָמִים לַיהוָֹה הוּא מְכַבְדָם וַאֲשֶׁר אֵינֶנוּ מְכַבֵּד יָמִים לְמַעַן יְהוָֹה אֵינֶנוּ מְכַבְדָם הָאֹכֵל אֹכֵל לְשֵׁם יְהוָֹה כִּי־יוֹדֶה לוֹ וַאֲשֶׁר אֵינֶנּוּ אֹכֵל לְשֵׁם אֱלֹהִים וִיהוֹדֶנּוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","כִּי אֵין־אִישׁ מֵאִתָּנוּ יִחְיֶה לְנַפְשׁוֹ וְאֵין־אִישׁ יָמוּת לְנַפְשׁוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","כִּי אִם־נִחְיֶה נִחְיֶה לַיהוָֹה וְכִי־נָמוּת נָמוּת לַיהוָֹה לָכֵן כִּי־נִחְיֶה וְכִי־נָמוּת לַיהוָֹה הִנֵּנוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","כִּי הֲלֹא בַּעֲבוּר זֹאת מֵת הַמָּשִׁיחַ וַיָּקָם וָחָי לְהִשְׂתָּרֵר כְּאָדוֹן עַל־הַמֵּתִים וְעַל־הַחַיִּים׃ ");
INSERT INTO hebsg_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","וְאַתָּה לָמָּה־זֶּה תִשְׁפֹּט אֶת־אָחִיךָ אוֹ מַדּוּעַ תָּבוּז אַתָּה לְאָחִיךָ וְכֻלָּנוּ לַמִשְׁפָּט נַעֲמֹד לִפְנֵי כִסֵּא דִּין אֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","כִּי כָתוּב חַי־אָנִי נְאֻם יְהוָֹה כִּי לִי תִּכְרַע כָּל־בֶּרֶךְ וְכָל־לָשׁוֹן תּוֹדֶה לֵאלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","עַל־כֵּן כָּל־אִישׁ וְאִישׁ לְנַפְשׁוֹ יָשִׁיב אֶת־אֱלֹהִים דָּבָר׃ ");
INSERT INTO hebsg_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","וְעַתָּה לֹא נִשְׁפֹּט עוֹד אִישׁ אֶת־אָחִיו כִּי אִם־נַחֲרֹץ מִשְׁפָּט לְבִלְתִּי תֵת אִישׁ לִפְנֵי אָחִיו מוֹקֵשׁ אוֹ מִכְשׁוֹל׃ ");
INSERT INTO hebsg_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","יָדַעְתִּי גַּם־יָדַעְתִּי בְּיֵשׁוּעַ אֲדֹנֵינוּ כִּי־אֵין דָּבָר טָמֵא מֵאֵלָיו וְרַק־טָמֵא הוּא לְמִי אֲשֶׁר יַחְשְׁבֶנּוּ לְטָמֵא׃ ");
INSERT INTO hebsg_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","וְאִם־יֵעָצֵב אָחִיךָ בְּמַאֲכָלְךָ אֵינְךָ הֹלֵךְ עוֹד בְּאֹרַח אַהֲבָה אַל־תַּשְׁחֵת בְּמַאֲכָלְךָ אֶת־אָחִיךָ אֲשֶׁר הַמָּשִׁיחַ מֵת בַּעֲדוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","וְאַל־תִּתֵּן יִשְׁרַת נַפְשְׁךָ לְגִדּוּפִים׃ ");
INSERT INTO hebsg_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","כִּי־מַלְכוּת אֱלֹהִים אֵינֶנָּה מַאֲכָל וּמִשְׁתֶּה כִּי אִם־צְדָקָה שָׁלוֹם וְחֶדְוָה בְּרוּחַ הַקֹּדֶשׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","וְהָעֹבֵד אֶת־הַמָּשִׁיחַ בָּאֵלֶּה רָצוּי הוּא לֵאלֹהִים וְנֶחְמָד בְּעֵינֵי אֲנָשִׁים׃ ");
INSERT INTO hebsg_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","עַל־כֵּן נִרְדְּפָה־נָּא דַרְכֵי שָׁלוֹם לְכוֹנֵן אִישׁ אֶת־רֵעֵהוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","אַל־תַּהֲרֹס פֹּעַל אֱלֹהִים עַל־דִּבְרַת מַאֲכָל כָּל־דָּבָר הוּא טָהוֹר וְרַק רַע הוּא לַאֲשֶׁר יֹאכְלֶנּוּ לְהִתְנַקֵּם בְּנַפְשׁוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","טוֹב לֹא־לֶאֱכֹל בָּשָׂר לֹא־לִשְׁתּוֹת יָיִן וְלֹא־לַעֲשׂוֹת דָּבָר אֲשֶׁר יִהְיֶה מִכְשׁוֹל לֵב לְאָחִיךָ אוֹ אֲשֶׁר יִוָּקֶשׁ־בּוֹ אוֹ יָדָיו תִּרְפֶּינָה׃ ");
INSERT INTO hebsg_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","יֶשׁ־לְךָ אֱמוּנָה תְּהִי־לְךָ לְבַדְּךָ לִפְנֵי הָאֱלֹהִים אַשְׁרֵי הָאִישׁ אֲשֶׁר לִבּוֹ לֹא יַרְשִׁיעֶנּוּ בַּאֲשֶׁר יִבְחַר־לוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","אַךְ אִם־יֹאכַל וְלִבּוֹ נִפְלַג עָלָיו וְנָשָׂא עֲוֹנוֹ יַעַן כִּי לֹא בֶאֱמוּנָה מַעֲשֵׂהוּ וְכֹל אֲשֶׁר נַעֲשָׂה בִּבְלִי אֱמוּנָה חֵטְא הוּא׃ ");
INSERT INTO hebsg_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","וַאֲנַחְנוּ גִבֹּרֵי כֹחַ עָלֵינוּ הַמִּצְוָה לָשֵׂאת רִפְיוֹן דַּלֵּי כֹחַ וְלֹא לָחוּשׁ לְחֵפֶץ נַפְשֵׁנוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","וְאִישׁ אִישׁ מֵאִתָּנוּ יָחוּשׁ לְחֵפֶץ רֵעֵהוּ לְטוֹב־לוֹ לְבַעֲבוּר יִבָּנֶה מִמֶּנוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","כִּי גַם־הַמָּשִׁיחַ לֹא חָשׁ לְנַפְשׁוֹ כִּי אִם־חָשׁ לַאֲשֶׁר כָּתוּב וְחֶרְפּוֹת חוֹרְפֶיךָ נָפְלוּ עָלָי׃ ");
INSERT INTO hebsg_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","וְכָל־אֲשֶׁר נִכְתַּב מִקֶּדֶם נִכְתַּב לְמוּסָר לָנוּ לְהַחֲזִיק בְּתִקְוָה בְּאֹרֶךְ אַפַּיִם וּבְתַנְחוּמוֹת הַכְּתוּבִים׃ ");
INSERT INTO hebsg_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","וְאֵל אֶרֶךְ אַפַּיִם אֲבִי הַתַּנְחוּמִים יִתֵּן לָכֶם לֵב אֶחָד לְאִישׁ כְּאָחִיו כְּיַד יֵשׁוּעַ הַמָּשִׁיחַ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","וּבְלֵב אֵחָד וּפֶה אֶחָד תְּכַבְּדוּ יַחְדָּו אֶת־אֱלֹהִים אֲבִי אֲדֹנֵינוּ יֵשׁוּעַ הַמָּשִׁיחַ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","עַל־כֵּן קַבְּלוּ נָא אִישׁ אֶת־רֵעֵהוּ כַּאֲשֶׁר גַּם־הַמָּשִׁיחַ קִבֵּל אֶתְכֶם לִכְבוֹד הָאֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","וַאֲנִי אֹמֵר כִּי יֵשׁוּעַ הַמָּשִׁיחַ הָיָה לִמְשָׁרֵת אֶת־הַנִּמּוֹלִים בַּעֲבוּר אֱמֶת אֱלֹהים לְהָקִים דְּבָרָיו אֶל־הָאָבוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","וְהַגּוֹיִם גַּם־הֵם יְכַבְּדוּ אֶת־הָאֱלֹהִים עַל־חַסְדּוֹ כַּכָּתוּב עַל־כֵּן אוֹדְךָ בַגּוֹיִם וּלְשִׁמְךָ אֲזַמֵּרָה׃ ");
INSERT INTO hebsg_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","וְעוֹד כָּתוּב הַרְנִינוּ גוֹיִם עַמּוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","וְעוֹד הַלְלוּ אֶת־יְהוָֹה כָּל־גּוֹיִם שַׁבְּחוּהוּ כָּל־הָאֻמִּים׃ ");
INSERT INTO hebsg_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","וִישַׁעְיָה יֹאמַר עוֹד וְהָיָה שֹׁרֶשׁ יִשַׁי וְהָעֹמֵד לִמְשֹׁל בָּעַמִּים אֵלָיו גּוֹיִם יְקַוּוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","וֵאלֹהֵי הַתִּקְוָה יְמַלֵּא אֶתְכֶם כָּל־שִׂמְחָה וְשָׁלוֹם בֶּאֱמוּנַתְכֶם לְהוֹסִיף חַיִל בְּתִקְוָה בְּעֹז רוּחַ הַקֹּדֶשׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","וְגַם־בָּכֶם אַחַי בָּטְחָה נַפְשִׁי מְאֹד כִּי־אַתֶּם מְלֵאִים חֶסֶד שְׁלֵמִים בְּכָל־דַּעַת וּנְכֹנִים לְהַזְהִיר אִישׁ אֶת־אָחִיו׃ ");
INSERT INTO hebsg_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","וַאֲנִי בְּיֶתֶר עֹז כָּתַבְתִּי אֲלֵיכֶם עַל־אֹדוֹת דְּבָרִים אֲחָדִים כְּמַזְכִּיר אֲנִי לִפְנֵיכֶם אַחֲרֵי אֲשֶׁר הִטָּה אֱלֹהִים אֵלַי חָסֶד׃ ");
INSERT INTO hebsg_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","וָאֶהְיֶה לִמְשָׁרֵת יֵשׁוּעַ הַמָּשִׁיחַ בֵּין הַגּוֹיִם וַאֲכַהֵן לִבְשׂוֹרַת הָאֱלֹהִים בַּעֲבוּר יַעֲלֶה קָרְבָּן הַגּוֹיִם לְרָצוֹן מְקֻדָּשׁ בְּרוּחַ הַקֹדֶשׁ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","וּבְכֵן יֶשׁ־לִי לְהִתְהַלֵּל בְּיֵשׁוּעַ הַמָּשִׁיחַ בַּחֲפָצִים אֲשֶׁר לֵאלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","כִּי לֹא־נִסִּיתִי לְדַבֵּר דָּבָר אֲשֶׁר לֹא בִצַּע הַמָּשִׁיחַ עַל־יָדִי לְהַטּוֹת אֵלָיו אֶת־לֵב הַגּוֹיִם בְּאִמְרֵי פִי וּבַעֲלִילוֹת יָדָי׃ ");
INSERT INTO hebsg_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","בִּגְבוּרַת הָאֹתוֹת וְהַמֹּפְתִים בְּעֹז רוּחַ אֱלֹהִים עַד אֲשֶׁר מָלְאָה הָאָרֶץ בְּשׂרַת הַמָּשִׁיחַ מִירוּשָׁלַיִם וּסְבִיבוֹתֶיהָ עַד אִלּוּרִיקוֹן׃ ");
INSERT INTO hebsg_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","וְכֵן שַׂמְתִּי מְגַמַּת פָּנַי לְבַשֵּׂר אַךְ בִּמְקֹמוֹת אֲשֶׁר שֵׁם הַמָּשִׁיחַ עוֹד לֹא נִקְרָא שָׁם לְבִלְתִּי אֶבְנֶה עַל־יְסוֹד אֲחֵרִים׃ ");
INSERT INTO hebsg_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","כִּי אִם־כַּכָּתוּב אֲשֶׁר לֹא־סֻפַּר לָהֶם רָאוּ וַאֲשֶׁר לֹא־שָׁמְעוּ הִתְבּוֹנָנוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","וַאֲשֶׁר לָזֹאת נֶעֱצַרְתִּי זְמַן רָב מִבּוֹא אֲלֵיכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","אֲבָל עַתָּה אַחֲרֵי אֲשֶׁר אֵין־לִי עוֹד מָקוֹם בַּגְּלִילוֹת הָאֵלֶּה וּתְשׁוּקָתִי גְדוֹלָה לָבוֹא אֲלֵיכֶם זֶה שָׁנִים רַבּוֹת׃ ");
INSERT INTO hebsg_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","אָבוֹא אֲלֵיכֶם בְּלֶכְתִּי לִסְפָרַד כִּי מְקַוֶּה אֲנִי לִרְאוֹתְכֶם בְּעָבְרִי לִשְׂבֹּעַ שְׂמָחוֹת אֶת־פְּנֵיכֶם לִמְעָט אַחַר תְּשַׁלְּחוּנִי לְדַרְכִּי׃ ");
INSERT INTO hebsg_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","אֶפֶס כַּיּוֹם הִנְנִי הֹלֵךְ יְרוּשָׁלָיְמָה לְהָבִיא שָׁם מִחְיָה לַקְּדוֹשִׁים׃ ");
INSERT INTO hebsg_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","כִּי־יָשָׁר הַדָּבָר בְּעֵינֵי הַמַּקְּדוֹנִים וְהָאֲכַיִּים לְהָרִים מַשְׂאַת נְדָבָה אֶל־אֶבְיוֹנֵי יְרוּשָׁלַיִם הַקְּדוֹשִׁים׃ ");
INSERT INTO hebsg_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","וְהַדָּבָר הַזֶּה יָשָׁר בְּעֵינֵיהֶם וְגַם־חוֹב הֵם מְשִׁיבִים לָהֶם כִּי אִם־הַגּוֹיִם נֹאחֲזוּ בְנַחֲלָתָם כַּחֲבֵרִים בְּחַיֵּי הָרוּחַ הֲלֹא גַּם־עֲלֵיהֶם לְהַחֲיֹתָם בְּחַיֵּי בְשָׂרִים׃ ");
INSERT INTO hebsg_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","וְכַאֲשֶׁר אֲכַלֶּה אֶת־הַדָּבָר וְהַפְּרִי הַזֶּה יִהְיֶה בְיָדָם אֶל־נָכוֹן אֶעְבְּרָה דֶּרֶךְ עֲלֵיכֶם לִסְפָרַד׃ ");
INSERT INTO hebsg_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","וּכְבֹאִי אֲלֵיכֶם יָדַעְתִּי כִּי־בִמְלֹא בִּרְכָתָה שֶׁל־בְּשׂוֹרַת־הַמָּשִׁיחַ אָבֹאָה׃ ");
INSERT INTO hebsg_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","וַאֲנִי מִתְחַנֵּן אֲלֵיכֶם אַחַי בְּיֵשׁוּעַ הַמָּשִׁיחַ אֲדֹנֵינוּ וּבְאַהֲבַתְכֶם הַנְּתוּנָה לָכֶם מֵרוּחַ הַקֹּדֶשׁ לְהִתְאַמֵּץ וּלְהִתְפַּלֵּל אִתִּי אֶל־אֱלֹהִים בְּעַד נַפְשִׁי׃ ");
INSERT INTO hebsg_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","כִּי יְמַלְּטֵנִי מִיַּד הַמַּמְרִים בְּאֶרֶץ יְהוּדָה וְיִתְּנֵנִי לִגְמֹר עֲבֹדָתִי לְרָצוֹן לַקְּדוֹשִׁים בִּירוּשָׁלָיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","וְלָבֹא אֲלֵיכֶם בְּלֵב שָׂמֵחַ בִּרְצוֹן אֱלֹהִים לְהִנָּפֵשׁ שָׁם עִמָּכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","וֵאלֹהֵי הַשָּׁלוֹם יִהְיֶה עִם־כֻּלְּכֶם אָמֵן׃ ");
INSERT INTO hebsg_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","וְהִנְנִי מַפְגִּיעַ בְּעַד אֲחֹתֵנוּ הַבָּאָה לִפְנֵיכֶם הִיא פוֹיבֶּה מְשָׁרַת אֶת־הָעֵדָה בְּקַנְכְּרָי׃ ");
INSERT INTO hebsg_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","אָנָּא קַבְּלוּהָ־נָּא בַּאֲדֹנֵינוּ כְּמִשְׁפָּט לְאַנְשֵׁי קֹדֶשׁ וְתִמְכוּהָ בְּכָל־דָּבָר אֲשֶׁר תֶּחְסַר עִמְּכֶם כִּי גַּם־הִיא תָמְכָה בְיָדִי וּבִידֵי רַבִּים זוּלָתִי׃ ");
INSERT INTO hebsg_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","שַׁאֲלוּ לִשְׁלוֹם פְּרִיסְקִלָּא וַעֲקִילָס חֲבֵרַי בַּעֲבֹדַת יֵשׁוּעַ הַמָּשִׁיחַ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","אֲשֶׁר נָתְנוּ צַוָּארָם בְּעַד נַפְשִׁי וְלֹא־אֲנִי לְבַדִּי מַכִּיר טוֹבָתָם כִּי אִם־גַּם כָּל־קְהִילּוֹת הַגּוֹיִם׃ ");
INSERT INTO hebsg_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","וְגַם אֶל־הָעֵדָה בְּבֵיתָם תִּשְׁאֲלוּ לְשָׁלוֹם שָׁאֲלוּ לִשְׁלוֹם אַפֵּינְטוֹס יְדִידִי הֲלֹא הוּא רֵאשִׁית פְּרִי אַסְיָא לַמָּשִׁיחַ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","שַׁאֲלוּ לִשְׁלוֹם מִרְיָם אֲשֶׁר עָמְלָה לָכֶם עָמָל רָב׃ ");
INSERT INTO hebsg_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","שַׁאֲלוּ לִשְׁלוֹם אַנְדְּרוֹנִיקוֹס וְיוּנְיָס קְרֹבָי אֲשֶׁר נֶאֶסְרוּ אִתִּי בַּמִּשְׁמָר וְגַם־יָצָא שִׁמְעָם בֵּין הַשְּׁלִיחִים וְהֵם דָּבְקוּ לְפָנַי בִּמְשִׁיחֵנוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","שַׁאֲלוּ לִשְׁלוֹם אַמְפְּלִיאָס יְדִידִי בַּאדֹנֵינוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","שַׁאֲלוּ לִשְׁלוֹם אוּרְבָנוֹס חֲבֵרֵנוּ בַּעֲבֹדַת הַמָּשִׁיחַ וְלִשְׁלוֹם סְטַכִּיס יְדִידִי׃ ");
INSERT INTO hebsg_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","שַׁאֲלוּ לִשְׁלוֹם אַפַּלִּיס הַנֶּאֱמָן בַּמָּשִׁיחַ שַׁאֲלוּ לִשְׁלוֹם בְּנֵי בֵית אֲרִיסְטוֹבְלוֹס׃ ");
INSERT INTO hebsg_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","שַׁאֲלוּ לִשְׁלוֹם הֹרוֹדִיּוֹן קְרֹבִי שַׁאֲלוּ לִשְׁלוֹם בְּנֵי בֵית נַרְקִיסוֹס הַדְּבֵקִים בַּאדֹנֵינוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","שַׁאֲלוּ לִשְׁלוֹם טְרוּפֵינָה וּטְרוּפָסָה הָעֹשׂוֹת מַעֲשֵׂיהֶן בַּאדֹנֵינוּ שַׁאֲלוּ לִשְׁלוֹם פַּרְסִיס הָאֲהוּבָה אֲשֶׁר הִרְבְּתָה פְעָלֶיהָ בַּאדֹנֵינוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","שַׁאֲלוּ לִשְׁלוֹם רוּפוֹס בְּחִיר אֲדֹנֵינוּ וְלִשְׁלוֹם אִמּוֹ כְּאֵם לִי׃ ");
INSERT INTO hebsg_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","שַׁאֲלוּ לִשְׁלוֹם אֲסוּנְקְרִיטוֹס פְּלֵיגוֹן הֶרְמָס פַּטְרוֹבָס וְהֶרְמִיס וְהָאַחִים אֲשֶׁר עִמָּהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","שַׁאֲלוּ לִשְׁלוֹם פִּילוֹלוֹגוֹס וְיוּלְיָא נִירְוַס וַאֲחוֹתוֹ וְאוֹלוּמְפָּס וְכָל־הַקְּדוֹשִׁים אֲשֶׁר אִתָּם׃ ");
INSERT INTO hebsg_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","שַׁאֲלוּ אִישׁ לְרֵעֵהוּ לְשָׁלוֹם בִּנְשִׁיקַת הַקֹּדֶשׁ כָּל־קְהִילּוֹת מְשִׁיחֵנוּ דֹּרְשׁוֹת לְשָׁלוֹם לָכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","וַאֲנִי מַזְהִיר אֶתְכֶם אַחַי הִשָּׁמְרוּ לָכֶם מִמְּשַׁלְּחֵי מְדָנִים וּמוֹקְשִׁים לַהֲפֹךְ אֶת־הַלֶּקַח אֲשֶׁר לְמַדְתֶּם סוּרוּ־נָא מֵעֲלֵיהֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","כִּי אֲנָשִׁים כָּאֵלֶּה לֹא יַעַבְדוּ אֶת־אֲדֹנֵינוּ יֵשׁוּעַ הַמָּשִׁיחַ כִּי אִם־אֶת־כְּרֵשָׂם וּבִשְׂפַת חֲלָקוֹת וַחֲלַקְלַקּוֹת יַדִּיחוּ אֶת־לִבּוֹת הַתְּמִימִים׃ ");
INSERT INTO hebsg_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","וְנוֹדַע לַכֹּל כִּי־יֵשׁ לָכֶם לֵב שֹׁמֵעַ וְעַל־כֵּן שָׂשׂ אֲנִי עֲלֵיכֶם אַךְ חָפַצְתִּי כִּי תִהְיוּ חֲכָמִים לַעֲשׂוֹת טוֹב וּתְמִימִים מֵעֲשׂוֹת רָעָה׃ ");
INSERT INTO hebsg_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","וֵאלֹהֵי הַשָּׁלוֹם יְדַכֵּא אֶת־הַשָּׂטָן כֹּה מַהֵר תַּחַת רַגְלֵיכֶם חֶסֶד יֵשׁוּעַ הַמָּשִׁיחַ אֲדֹנֵינוּ יִהְיֶה עִמָּכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","טִימוֹתִיּוֹס חֲבֵרִי וְלוּקְיוֹס וְיָסוֹן וְסוֹסְפַּטְרוֹס קְרוֹבַי דֹּרְשִׁים לִשְׁלוֹמְכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","וַאֲנִי טַרְטִיּוֹס סֹפֵר הָאִגֶּרֶת הַזֹּאת שֹׁאֵל לִשְׁלוֹמְכֶם בַּאדֹנֵינוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","גָּיּוֹס בַּעַל הַמָּלוֹן־לִי וּלְכָל־הָקָּהָל דֹּרֵשׁ לִשְׁלוֹמְכֶם אֲרַסְטוֹס סֹכֵן הָעִיר וּקְוַרְטוֹס אָחִינוּ שֹׁאֲלִים לִשְׁלוֹמְכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","חֶסֶד אֲדוֹנֵינוּ יֵשׁוּעַ הַמָּשִׁיחַ עִם־כֻּלְכֶם אָמֵן׃ ");
INSERT INTO hebsg_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","וְהוּא אֲשֶׁר הַכֹּחַ בְּיָדוֹ לְכוֹנֵן אֶתְכֶם כִּבְשׂרָתִי הִיא בְשׂרַת יֵשׁוּעַ הַמָּשִׁיחַ כְּפִי הִתְגַּלּוּת הַסּוֹד אֲשֶׁר הָיָה כָמֻס מִימֵי קֶדֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","וַאֲשֶׁר נִגְלָה כַיּוֹם עַל־פִּי כִתְבֵי הַנְבִיאִים בִּפְקֻדַּת אֱלֹהֵי עוֹלָם וְהֻגַּד לְכָל־הַגּוֹיִם לְהַטּוֹת אֶת־לִבָּם אֶל־אֱמוּנָתוֹ׃ ");
INSERT INTO hebsg_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","הוּא אֵל דֵּעוֹת לְבַדּוֹ וְלוֹ הַכָּבוֹד בְּיֵשׁוּעַ הַמָּשִׁיחַ לְעוֹלָם וָעֶד אָמֵן׃ ");
INSERT INTO hebsg_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","פּוֹלוֹס הַשָּׁלִיחַ אֲשֶׁר בָּחַר־בּוֹ יֵשׁוּעַ הַמָּשִׁיחַ בִּרְצוֹן אֱלֹהִים אֲנִי וְסוֹסְתְּנִיס אָחִינוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","אֶל־עֲדַת אֱלֹהִים בְּקֹרִנְתּוֹס הַבְּחִירִים וְהַקְּדשִׁים אֲשֶׁר בְּיֵשׁוּעַ הַמָּשִׁיחַ הִתְקַדָּשׁוּ עִם כָּל־הַקֹּרְאִים בְּכָל־מָקוֹם בְּשֵׁם יֵשׁוּעַ הַמָּשִׁיחַ הוּא אֲדֹנֵיהֶם וַאֲדֹנֵינוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","חֶסֶד וְשָׁלוֹם יִתֵּן לָכֶם אֱלֹהִים אָבִינוּ וַאֲדֹנֵינוּ יֵשׁוּעַ הַמָּשִׁיחַ׃ ");
INSERT INTO hebsg_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","אֲבָרֵךְ אֶת־אֱלֹהַי תָּמִיד עַל־חַסְדּוֹ אֲשֶׁר גָּמַל עֲלֵיכֶם בְּיֵשׁוּעַ הַמָּשִׁיחַ׃ ");
INSERT INTO hebsg_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","כִּי בוֹ מְצָאתֶם אוֹן לָכֶם בַּכֹּל בְּכָל־מַדָּע וְהַשְׂכֵּל׃ ");
INSERT INTO hebsg_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","כַּאֲשֶׁר עֵדוּת הַמָּשִׁיחַ נֶאֶמְנָה בָכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","עַד אֲשֶׁר־לֹא חֲסַרְתֶּם מְאוּמָה מִכָּל־מַתַּת־יָהּ וְעֵינֵיכֶם צֹפִיּוֹת לְהִגָּלוֹת נִגְלוֹת פְּנֵי אֲדֹנֵינוּ יֵשׁוּעַ הַמָּשִׁיחַ׃ ");
INSERT INTO hebsg_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","אֲשֶׁר גַּם־הוּא יְכוֹנֵן אֶתְכֶם עַד־הַקֵּץ לְבִלְתִּי יִמָּצֵא בָכֶם שֶׁמֶץ דָּבָר בְּיוֹם אֲדֹנֵינוּ יֵשׁוּעַ הַמָּשִׁיחַ׃ ");
INSERT INTO hebsg_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","כִּי נֶאֱמָן הוּא הָאֱלֹהִים אֲשֶׁר נִקְרֵאתֶם בּוֹ לְדָבְקָה בִּבְנוֹ יֵשׁוּעַ הַמָּשִׁיחַ אֲדֹנֵינוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","וַאֲנִי דֹרֵשׁ מִכֶּם אַחַי בְּשֵׁם אֲדֹנֵינוּ יֵשׁוּעַ הַמָּשִׁיחַ לְדַבֵּר כֻּלְּכֶם פֶּה אֶחָד וְאַל־תִּתְגֹּדְדוּ לִפְלַגּוֹת כִּי אִם־הִתְחַבְּרוּ יַחְדָּו בְּלֵב אֶחָד וּבְעֵצָה אֶחָת׃ ");
INSERT INTO hebsg_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","כִּי הֻגַּד־לִי אַחַי מִפִּי בְנֵי־בֵית כְּלוֹאָה כִּי־דִבְרֵי רִיבוֹת בְּשַׁעֲרֵיכֶם׃ ");
INSERT INTO hebsg_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","וְהִנֵּה זֶה דְבָרִי אִישׁ אִישׁ מִכֶּם אֹמֵר אֲנִי לְפוֹלוֹס אוֹ אֲנִי לְאַפּוֹלוֹס אוֹ אֲנִי לְכֵיפָא אוֹ אֲנִי לַמָּשִׁיחַ׃ ");
INSERT INTO hebsg_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","הֲכִי נֶחֱלַק הַמָּשִׁיחַ הֲנִצְלַב פּוֹלוֹס בַּעַדְכֶם אוֹ הֲנִטְבַּלְתֶּם בְּשֵׁם פּוֹלוֹס׃ ");
INSERT INTO hebsg_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","שׂוֹשׂ אָשִׂישׂ בֵּאלֹהִים כִּי לֹא־טָבַלְתִּי אִישׁ מִכֶּם זוּלָתִי קְרִסְפּוֹס וְגָיוֹס׃ ");
INSERT INTO hebsg_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","פֶּן־יֹאמְרוּ כִּי־נִטְבַּלְתֶּם בִּשְׁמִי׃ ");
INSERT INTO hebsg_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","אַךְ טָבַלְתִּי גַם אֶת־בְּנֵי־בֵית סְטְפָנוֹס וּמִלְּבַד אֵלֶּה אֵינֶנִּי יֹדֵעַ עוֹד אִם־טָבַלְתִּי אִישׁ אַחֵר׃ ");
INSERT INTO hebsg_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","כִּי לֹא שְׁלָחַנִי הַמָּשִׁיחַ לְטַבֵּל כִּי אִם־לְבַשֵּׂר וְלֹא־בְחָכְמַת שְׂפָתַיִם פֶּן־יִהְיֶה צְלַב הַמָּשִׁיחַ לְתֹהוּ׃ ");
INSERT INTO hebsg_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","כִּי־פִתְגָּם הַצְּלַב כִּפְתַיּוּת הוּא לָאֹבְדִים וְלָנוּ הַנּוֹשָׁעִים הוּא גְּבוּרַת אֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","כִּי־כָתוּב אֲאַבֵּד חָכְמַת חֲכָמִים וּבִינַת נְבוֹנִים אַסְתִּיר׃ ");
INSERT INTO hebsg_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","אַיֵּה חָכָם אַיֵּה סֹפֵר אַיֵּה שֹׁקֵל חִקְרֵי הָעוֹלָם הֲלֹא סִכֵּל אֱלֹהִים אֶת־חָכְמַת הָעוֹלָם הַזֶּה׃ ");
INSERT INTO hebsg_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","כִּי אַחֲרֵי אֲשֶׁר הָעוֹלָם בְּחָכְמָתוֹ לֹא יָדַע אֶת־הָאֱלֹהִים בָּאָה חָכְמַת אֱלֹהִים וּרְצוֹנוֹ בְּסִכְלוּת הַבְּשׂרָה לְהוֹשִׁיעַ אֶת־הַמַּאֲמִינִים׃ ");
INSERT INTO hebsg_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","כִּי הַיְּהוּדִים שֹׁאֲלִים אוֹת וְהַיְּוָנִים מְבַקְשִׁים חָכְמָה׃ ");
INSERT INTO hebsg_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","וַאֲנַחְנוּ מְבַשְּׂרִים בְּאָזְנֵיהֶם הַמָּשִׁיחַ הַנִּצְלָב לַיְּהוּדִים לְמִכְשׁוֹל וְלַיְּוָנִים לְסִכְלוּת׃ ");
INSERT INTO hebsg_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","אַךְ לִבְחִירִים גַּם־לִיהוּדִים גַּם־לִיְוָנִים מָשִׁיחַ גְּבוּרַת אֱלֹהִים וְחָכְמַת אֱלֹהִים׃ ");
INSERT INTO hebsg_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","כִּי סִכְלוּת אֱלֹהִים טוֹבָה מֵחָכְמַת אָדָם וְרִפְיוֹן יְדֵי אֱלֹהִים אֵיתָן מִכֹּחַ גָּבֶר׃ ");
INSERT INTO hebsg_v