﻿USE sofia;
DROP TABLE IF EXISTS sofia.heblb_vpl;
CREATE TABLE heblb_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES heblb_vpl WRITE;
INSERT INTO heblb_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","לפניכם ספר קורות חייו של ישוע המשיח, אשר מוצאו מיוחס לדוד המלך ולאברהם אבינו: ");
INSERT INTO heblb_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","אברהם היה אביו של יצחק; יצחק היה אביו של יעקב; יעקב היה אביהם של יהודה ואֶחָיו; ");
INSERT INTO heblb_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","יהודה היה אביהם של פרץ וזרח (אמם הייתה תמר); פרץ היה אביו של חצרון; חצרון היה אביו של רם; ");
INSERT INTO heblb_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","רם היה אביו של עמינדב; עמינדב היה אביו של נחשון; נחשון היה אביו של שלמון; ");
INSERT INTO heblb_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","שלמון היה אביו של בועז (אמו הייתה רחב); בועז היה אביו של עובד (אמו הייתה רות); עובד היה אביו של ישי; ");
INSERT INTO heblb_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ישי היה אביו של דוד המלך; דוד היה אביו של שלמה (אמו הייתה אלמנתו של אוריה החתי). ");
INSERT INTO heblb_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","שלמה היה אביו של רחבעם; רחבעם היה אביו של אביה; אביה היה אביו של אסא; ");
INSERT INTO heblb_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","אסא היה אביו של יהושפט; יהושפט היה אביו של יורם; יורם היה אביו של עוזיה; ");
INSERT INTO heblb_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","עוזיה היה אביו של יותם; יותם היה אביו של אחז; אחז היה אביו של חזקיה; ");
INSERT INTO heblb_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","חזקיה היה אביו של מנשה; מנשה היה אביו של אמון; אמון היה אביו של יאשיה; ");
INSERT INTO heblb_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","יאשיה היה אביהם של יכניה ואחיו (שנולדו בזמן גלות בבל). ");
INSERT INTO heblb_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","לאחר הגלות לבבל: יכניה היה אביו של שאלתיאל; שאלתיאל היה אביו של זרובבל; ");
INSERT INTO heblb_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","זרובבל היה אביו של אביהוד; אביהוד היה אביו של אליקים; אליקים היה אביו של עזור; ");
INSERT INTO heblb_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","עזור היה אביו של צדוק; צדוק היה אביו של יכין; יכין היה אביו של אליהוד; ");
INSERT INTO heblb_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","אליהוד היה אביו של אלעזר; אלעזר היה אביו של מתן; מתן היה אביו של יעקב; ");
INSERT INTO heblb_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","יעקב היה אביו של יוסף (שהיה בעלה של מרים, אמו של ישוע המשיח). ");
INSERT INTO heblb_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","אם כן, ארבעה־עשר דורות חלפו מאברהם אבינו ועד דוד המלך, ארבעה־עשר דורות מאז דוד המלך ועד גלות בבל וארבעה־עשר דורות מגלות בבל עד המשיח. ");
INSERT INTO heblb_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","זהו סיפור הולדתו של ישוע המשיח: אמו מרים הייתה מאורסת ליוסף, אולם עוד כשהייתה בתולה הרתה מרוח הקודש. ");
INSERT INTO heblb_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","יוסף ארוסה, שהיה איש ישר וערכי, החליט משום כך לבטל את האירוסין, אולם בחר לעשות זאת בסתר, כי לא רצה לבייש את מרים בציבור. ");
INSERT INTO heblb_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","לאחר שהחליט יוסף לגרש את מרים נגלה אליו בחלום מלאך ה׳ ואמר: ”יוסף בן־דוד, אל תהסס להתחתן עם מרים, כי התינוק שבבטנה נוצר מרוח הקודש! ");
INSERT INTO heblb_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","מרים תלד בן, ועליך לקרוא לו ’ישוע‘ (כלומר, מושיע), כי הוא יושיע את בני־עמו מחטאיהם.“ ");
INSERT INTO heblb_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","לידתו של ישוע קיימה את מה שאמר אלוהים באמצאות נביאיו: ");
INSERT INTO heblb_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","”הנה העלמה הרה ויולדת בן, וקראת שמו עמנו אל.“ ");
INSERT INTO heblb_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","כשיוסף התעורר, הוא עשה מה שציווה עליו המלאך והתחתן עם מרים. ");
INSERT INTO heblb_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","אולם מרים נשארה בתולה עד שנולד בנה, ויוסף קרא לו ”ישוע“. ");
INSERT INTO heblb_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","ישוע נולד בעיר בית־לחם שבאזור יהודה, בימי המלך הורדוס. זמן קצר לאחר לידתו, הופיעו בירושלים מספר חוזי־כוכבים שבאו מארץ רחוקה במזרח, ושאלו: ");
INSERT INTO heblb_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","”היכן התינוק שנועד להיות מלך היהודים? ראינו את כוכבו במזרח ובאנו להשתחוות לו.“ ");
INSERT INTO heblb_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","הורדוס נבהל מאוד משאלתם, וכמוהו נבהלו כל אנשי ירושלים. ");
INSERT INTO heblb_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","הוא כינס את מנהיגי היהודים ושאל אותם: ”האם אמרו לנו הנביאים היכן ייוולד המשיח?“ ");
INSERT INTO heblb_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","ענו לו: ”כן, בבית לחם. הרי מיכה הנביא אמר: ");
INSERT INTO heblb_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","’ואתה, בית־לחם בארץ יהודה, אינך צעיר באלופי יהודה, כי ממך יצא מושל אשר ירעה את־עמי ישראל‘. “ ");
INSERT INTO heblb_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","הורדוס הזמין את חוזי־הכוכבים לפגישה סודית, ושאל אותם מתי בדיוק ראו לראשונה את הכוכב. ");
INSERT INTO heblb_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","לאחר מכן אמר להם: ”לכו לבית־לחם וחפשו את הילד. כשתמצאו אותו, שובו אלי והודיעו לי זאת, כדי שאוכל גם אני ללכת להשתחוות לו.“ ");
INSERT INTO heblb_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","לאחר הפגישה עם המלך יצאו חוזי־הכוכבים לדרך, ולפתע הכוכב שראו במזרח הופיע לנגד עיניהם. הם הלכו בעקבות הכוכב עד שנעמד בדיוק מעל המקום שבו היה התינוק. ");
INSERT INTO heblb_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","הם שמחו מאוד. ");
INSERT INTO heblb_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","כשנכנסו חוזי־הכוכבים אל הבית שבו היה התינוק ומרים אמו, נפלו לפניו, השתחוו לו, ולאחר מכן פתחו את חבילותיהם ונתנו לו מתנות: זהב, לבונה ומור. ");
INSERT INTO heblb_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","בינתיים הזהיר אותם אלוהים בחלום שלא לחזור אל הורדוס, ומשום כך שבו חוזי־הכוכבים לארצם בדרך אחרת. ");
INSERT INTO heblb_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","לאחר שעזבו, נגלה מלאך ה׳ ליוסף בחלום ואמר: ”קום, ברח למצרים עם התינוק ועם אמו, והישאר שם עד שאומר לך לחזור, כי הורדוס רוצה להרוג את הילד.“ ");
INSERT INTO heblb_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","באותו לילה יצא יוסף עם מרים ועם הילד למצרים, ");
INSERT INTO heblb_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","ונשאר אתם שם עד מותו של הורדוס. כך התקיימה הנבואה: ”וממצרים קראתי לבני.“ ");
INSERT INTO heblb_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","כשהורדוס הבין שחוזי־הכוכבים התחמקו ממנו, הוא מאוד כעס. הוא שלח חיילים לבית־לחם וציווה עליהם להרוג כל ילד זכר עד גיל שנתיים (כי החוזים סיפרו לו שראו את הכוכב כשנתיים קודם לכן), בבית לחם עצמה ובכל כפרי הסביבה. ");
INSERT INTO heblb_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","מעשה אכזרי זה של הורדוס קיים את הנבואה של ירמיהו: ");
INSERT INTO heblb_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","”קול ברמה נשמע, נהי בכי תמרורים, רחל מבכה על בניה, מאנה להינחם על בניה כי איננו.“ ");
INSERT INTO heblb_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","לאחר מותו של הורדוס נגלה מלאך ה׳ בחלום ליוסף במצרים, ואמר לו: ");
INSERT INTO heblb_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","”קום, קח את התינוק ואת אמו לישראל, כי אלה שרצו להרוג את הילד כבר מתו.“ ");
INSERT INTO heblb_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","יוסף לקח את ישוע ואת מרים ויצא אתם בדרך לישראל. ");
INSERT INTO heblb_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","בהיותם בדרך שמעו שהמלך החדש אינו אלא ארכילאוס, בנו של הורדוס, ופחדו מאוד. בחלום נוסף יוסף הוזהר שלא להתיישב ביהודה, אז הם המשיכו לגליל ");
INSERT INTO heblb_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","והשתקעו בנצרת. זה קרה כדי לקיים את דברי הנביאים שכינו אותו ”נצרי“. ");
INSERT INTO heblb_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","בימים ההם, כשישוע והוריו גרו בנצרת, החל יוחנן המטביל להטיף במדבר יהודה. ");
INSERT INTO heblb_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","”חיזרו בתשובה!“ קרא יוחנן. ”שובו אל ה׳ כי מלכות השמים קרובה!“ ");
INSERT INTO heblb_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","ישעיהו הנביא ניבא על פעילותו של יוחנן כשאמר: ”קול קורא במדבר פנו דרך ה׳, ישרו מסילותיו.“ ");
INSERT INTO heblb_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","בגדיו היו עשויים שער גמלים והייתה לו חגורת עור; הוא נהג לאכול ארבה ודבש־בר. ");
INSERT INTO heblb_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","אנשים מירושלים, עמק־הירדן וכל אזור יהודה יצאו למדבר כדי לשמוע את דבריו, ");
INSERT INTO heblb_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ולאחר שהתוודו על חטאיהם, יוחנן הטביל אותם בנהר הירדן. ");
INSERT INTO heblb_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","אולם כשראה יוחנן שפרושים וצדוקים רבים באים להיטבל, הוא דחה אותם. ”בני נחשים אתם!“ אמר להם יוחנן. ”מי אמר לכם שתוכלו להימלט מהעונש שה׳ עתיד להביא עליכם? ");
INSERT INTO heblb_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","לפני שתיטבלו אתם חייבים להוכיח במעשים שבאמת התחרטתם על חטאיכם. ");
INSERT INTO heblb_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","אל תחשבו בלבכם: ’אלוהים לא יעניש אותנו כי אנחנו יהודים, בני אברהם‘. הרי אלוהים יכול לעשות מהאבנים האלה בנים לאברהם! ");
INSERT INTO heblb_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","”כבר עכשיו מוכן גרזן המשפט של אלוהים לכרות כל עץ חסר תועלת שאינו נושא פרי. עצים חסרי תועלת ייכרתו ויישרפו! ");
INSERT INTO heblb_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","”אני כרגע מטביל במים את אלה שבאמת מתחרטים על מעשיהם הרעים, אולם בקרוב יבוא אדם גדול ונעלה ממני שאני לא ראוי אפילו לשאת את נעליו, והוא יטביל אתכם ברוח הקודש ובאש. ");
INSERT INTO heblb_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","הוא יפריד בין המוץ לבין גרגירי החיטה – את המוץ ישרוף באש נצחית, ואילו את החיטה ישמור באסם.“ ");
INSERT INTO heblb_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","באותו זמן בא ישוע מן הגליל אל נהר הירדן, כדי להיטבל על־ידי יוחנן. ");
INSERT INTO heblb_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","יוחנן ניסה לשכנע אותו ואמר: ”אתה צריך להטביל אותי, ולא אני אותך!“ ");
INSERT INTO heblb_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","אולם ישוע עמד על דעתו ואמר: ”הטבל אותי, בבקשה. עלי לעשות את כל הדרוש.“ ויוחנן הטביל אותו. ");
INSERT INTO heblb_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","מיד לאחר הטבילה, כשישוע יצא מהמים, השמים נפתחו מעליו והוא ראה את רוח אלוהים יורדת עליו בדמות יונה. ");
INSERT INTO heblb_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","קול קרא מהשמים: ”זהו בני אהובי, ובו אני חפץ.“ ");
INSERT INTO heblb_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","לאחר מכן, הרוח הובילה את ישוע אל המדבר כדי שהשטן ינסה אותו שם. ");
INSERT INTO heblb_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","במשך ארבעים יום וארבעים לילה ישוע לא אכל מאומה, ולבסוף היה רעב מאוד. ");
INSERT INTO heblb_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","”אם אתה באמת בן־אלוהים,“ אמר לו השטן, ”צווה על האבנים האלה להפוך לכיכרות לחם!“ ");
INSERT INTO heblb_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","ישוע ענה לו: ”לא אצווה זאת, שהרי כתוב בתורה: ’לא על הלחם לבדו יחיה האדם, כי על כל מוצא פי ה׳‘. “ ");
INSERT INTO heblb_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","לאחר מכן הביא השטן את ישוע לירושלים, העלה אותו על גג בית־המקדש ואמר: ");
INSERT INTO heblb_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","”קפוץ למטה! הרי כתוב בתנ״ך: ’כי מלאכיו יצווה לך… ועל כפיים ישאונך, פן תיגוף באבן רגלך‘. “ ");
INSERT INTO heblb_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","השיב לו ישוע: ”אבל כתוב גם: ’לא תנסה את ה׳ אלוהיך‘. “ ");
INSERT INTO heblb_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","לאחר מכן השטן העלה את ישוע על הר מאוד גבוה, הראה לו את כל המדינות המפוארות בעולם ואמר: ");
INSERT INTO heblb_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","”אם רק תכרע ברך ותשתחווה לי, אתן לך את כל אלה!“ ");
INSERT INTO heblb_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","ישוע השיב: ”סור ממני, שטן! הרי כתוב: ’לה׳ אלוהיך תשתחווה ואותו לבדו תעבוד‘. “ ");
INSERT INTO heblb_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","השטן הרפה ממנו, ומלאכים באו לשרת את ישוע. ");
INSERT INTO heblb_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","כאשר שמע ישוע על זה שיוחנן המטביל נאסר, הוא עזב את ארץ יהודה וחזר לביתו – לנצרת שבגליל. ");
INSERT INTO heblb_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","אחר כך ישוע עבר לגור בכפר־נחום שעל שפת הכינרת, באזור שבטי זבולון ונפתלי. ");
INSERT INTO heblb_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","כך התקיימה נבואת ישעיהו: ");
INSERT INTO heblb_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","”ארצה זבולון וארצה נפתלי, דרך הים, עבר הירדן, גליל הגויים – ");
INSERT INTO heblb_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","העם ההלכים בחשך ראו אור גדול, ישבי בארץ צלמוות – אור נָגַהּ עליהם!“ ");
INSERT INTO heblb_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","מאותו יום והלאה ישוע התחיל להטיף: ”שובו בתשובה והאמינו בה׳, כי מלכות השמיים קרובה!“ ");
INSERT INTO heblb_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","יום אחד כשישוע הלך על חוף הכינרת, הוא ראה שני אחים: שמעון (הנקרא גם פטרוס) ו‎אַנְדְּרֵי. השניים ישבו בסירה ודגו בעזרת רשת, כי היו דייגים במקצועם. ");
INSERT INTO heblb_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","”בואו אחרי!“ קרא להם ישוע. ”אני אעשה אתכם לדייגי אדם!“ ");
INSERT INTO heblb_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","שני האחים עזבו מיד את הרשתות שלהם והלכו אחריו. ");
INSERT INTO heblb_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","לא הרחק משם ראה ישוע עוד שני אחים, יעקב ויוחנן, יושבים בסירה עם אביהם זבדי, ומתקנים את רשתותיהם הקרועות. ישוע קרא גם להם, ");
INSERT INTO heblb_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","והשניים הפסיקו מיד את עבודתם, עזבו את אביהם והלכו אחריו. ");
INSERT INTO heblb_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","ישוע הסתובב בכל הגליל ולימד בבתי־הכנסת; בכל מקום בישר את החדשות הטובות על מלכות השמיים וריפא כל מיני מחלות. ");
INSERT INTO heblb_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","השמועות על הניסים שחולל פשטו מעבר לגבולות הגליל, וחולים באו אליו להירפא אפילו מסוריה. הובאו אליו אנשים אחוזי־שדים, מטורפים ומשותקים, וישוע ריפא את כולם. ");
INSERT INTO heblb_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","לכל מקום שהלך, הלכו אחריו המונים: מהגליל, מחו״ל, מירושלים, מיהודה ואף מעבר הירדן. ");
INSERT INTO heblb_vpl VALUES ("MT5_1‏","070_5_1‏","MAT","5","1‏","2","יום אחד, כשהתאסף סביבו קהל גדול, עלה ישוע עם תלמידיו על מדרון הגבעה, התיישב שם והחל ללמד: ");
INSERT INTO heblb_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","”אשרי האנשים המודים בעניותם הרוחנית, כי להם שייכת מלכות השמים. ");
INSERT INTO heblb_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","אשרי הבוכים והמתאבלים, כי הם ינוחמו. ");
INSERT INTO heblb_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","אשרי הצנועים והענווים, כי העולם כולו שייך להם. ");
INSERT INTO heblb_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","אשרי השואפים בכל לבם לעשות את הטוב והישר, כי אלוהים ימלא את שאיפתם. ");
INSERT INTO heblb_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","אשרי האדיבים והרחמנים, כי אלוהים יגלה כלפיהם רחמים. ");
INSERT INTO heblb_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","אשרי האנשים שלבם טהור, כי הם יראו את אלוהים. ");
INSERT INTO heblb_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","אשרי האנשים הרודפים שלום, כי הם ייקראו ’בני־אלוהים‘. ");
INSERT INTO heblb_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","אשרי הסובלים והנרדפים בגלל עשותם את רצון ה׳, כי להם שייכת מלכות השמיים. ");
INSERT INTO heblb_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","”אם יקללו אתכם, יעלילו עליכם שקרים וירדפו אתכם בגלל אמונתכם בי, ");
INSERT INTO heblb_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","שמחו מאוד! כן, שמחו מאוד, כי שכר רב לכם בשמים, וזכרו שכך רדפו גם את הנביאים! ");
INSERT INTO heblb_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","”אתם מלח הארץ. מה יקרה לעולם אם תאבדו את המליחות שלכם? מלח תפל הוא חסר תועלת, ואינו ראוי אלא שיזרקו וירמסו אותו. ");
INSERT INTO heblb_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","”אתם אור העולם – בדומה לעיר הבנויה על הר, אשר כל אחד יכול לראות את אורותיה בלילה. ");
INSERT INTO heblb_vpl VALUES ("MT5_15‏","070_5_15‏","MAT","5","15‏","16","אל תסתירו את אורכם! הניחו לו להאיר לכולם! תנו לכל אדם לראות את התנהגותכם הטובה, ואז יודו כולם לאביכם שבשמים. ");
INSERT INTO heblb_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","”אל תחשבו שבאתי לבטל את תורת משה או את אזהרותיהם של הנביאים; באתי לקיים ולמלא אותן! ");
INSERT INTO heblb_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","אני אומר לכם בכל הכנות והרצינות: מצוות התורה תישארנה בתוקף עד שיתקיים הכול. ");
INSERT INTO heblb_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","מי שיעבור על המצווה הקטנה ביותר או שיעודד אחרים לעשות זאת, הוא יהיה קטן במלכות השמים. ואילו מי שילמד את תורת ה׳ ואף יקיים את מצוותיה, יהיה גדול במלכות השמים. ");
INSERT INTO heblb_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","”אולם אני מזהיר אתכם: אם לא תהיו טובים יותר מהפרושים והסופרים, לא תוכלו להיכנס למלכות השמיים. ");
INSERT INTO heblb_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","”תורת משה אומרת: ’לא תרצח‘, והרוצח יחויב לדין. ");
INSERT INTO heblb_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","אולם אני אומר לכם שאם אדם אף כועס על אחיו, עליו לעמוד לדין. גם מי שיקרא לחברו ’אידיוט!‘ עליו לעמוד לדין, ואם יקלל את חברו הריהו בסכנת גיהינום! ");
INSERT INTO heblb_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","לכן אם אתה עומד לפני המזבח בבית־המקדש ומביא קורבן לה׳, ולפתע אתה נזכר שלאחד מחבריך יש דבר מה נגדך, ");
INSERT INTO heblb_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","השאר את קורבנך לפני המזבח, מהר אל חברך ובקש את סליחתו. לאחר מכן חזור לבית־המקדש והקרב את הקרבן לה׳. ");
INSERT INTO heblb_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","התפייס מהר עם אויבך, אחרת יהיה מאוחר מדי והוא יסגירך לידי החוק, ואז ישליכו אותך לכלא – ");
INSERT INTO heblb_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","שם תישאר עד שתשלם את האגורה האחרונה! ");
INSERT INTO heblb_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","”תורת משה אומרת: ’לא תנאף‘. ");
INSERT INTO heblb_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","אולם אני אומר לכם: כל מי שמסתכל על אישה בתאווה, כאילו נאף אותה בלבו. ");
INSERT INTO heblb_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","משום כך, אם עינך גורמת לך לחשוק ולחמוד, עקור והשלך אותה. מוטב שתאבד חלק מגופך, מאשר שיושלך כל גופך לגיהינום. ");
INSERT INTO heblb_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","ואם ידך – ולו גם הימנית – גורמת לך לחטוא, קצץ והשלך אותה! מוטב כך, מאשר למצוא את עצמך בגיהינום. ");
INSERT INTO heblb_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","”תורת משה אומרת שאם איש רוצה לגרש את אשתו, עליו לתת לה ספר כריתות, וזה הכל. ");
INSERT INTO heblb_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","אולם אני אומר שאיש המגרש את אשתו מלבד במקרה שבגדה בו, גורם לכך שתנאף אם תינשא בשנית. גם מי שיתחתן איתה לאישה נחשב לנואף! ");
INSERT INTO heblb_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","”התורה אומרת שאם נשבעת, עליך לקיים את שבועתך. ");
INSERT INTO heblb_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","ואילו אני אומר: אל תישבע כלל! אל תאמר: ’אני נשבע בשמים‘, כי כסא ה׳ נמצא בשמים. ");
INSERT INTO heblb_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","אם אתה נשבע ’בארץ‘, אתה נשבע למעשה בהדום רגליו של אלוהים. כמו כן אל תישבע ’בירושלים‘, כי היא ’קרית מלך רב‘. ");
INSERT INTO heblb_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","גם אל תישבע על ראשך, כי אפילו שערה אחת אין ביכולתך לשנות ללבן או שחור. ");
INSERT INTO heblb_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","אמור פשוט: ’כן‘, או ’לא‘. יותר מזה מן הרע הוא. ");
INSERT INTO heblb_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","”התורה אומרת ’עין תחת עין, שן תחת שן‘. ");
INSERT INTO heblb_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","ואילו אני אומר לכם: אל תתקוממו נגד מי שעושה רע נגדכם. אם מישהו סוטר לך על הלחי, הושט לו גם את הלחי השנייה. ");
INSERT INTO heblb_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","אם דורשים ממך בבית המשפט לתת את חולצתך, תן להם גם את מעילך. ");
INSERT INTO heblb_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","אם חייל כופה עליך לשאת את תרמילו קילומטר אחד, שא אותו שני קילומטרים. ");
INSERT INTO heblb_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","תן למי שמבקש ממך, ואל תדחה את מי שרוצה ללוות ממך כסף. ");
INSERT INTO heblb_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","”שמעתם שנאמר: ’ואהבת לרעך, ושנאת את אויבך‘. ");
INSERT INTO heblb_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","אולם אני אומר: אהבו את אויביכם והתפללו בעד אלה שרודפים אתכם, ");
INSERT INTO heblb_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","כי כך תהיו בנים לאביכם שבשמים. שהרי אלוהים נותן את אור השמש גם לטובים וגם לרעים, ואף את הגשם הוא מוריד על צדיקים ועל רשעים כאחד. ");
INSERT INTO heblb_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","אם אתם אוהבים רק את אלה שאוהבים אתכם, מה מיוחד בכך? גם הפושעים נוהגים כך! ");
INSERT INTO heblb_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","ואם אתם חברים רק לחבריכם, במה שונים אתם מכל האחרים? הלא גם עובדי אלילים נוהגים כך! ");
INSERT INTO heblb_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","שאפו להיות שלמים כשם שאביכם שבשמים שלם.“ ");
INSERT INTO heblb_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","”היזהרו שלא תעשו את מעשיכם הטובים לפני כולם, כדי שכולם יראו ויכבדו אתכם, כי ככה אין לכם שכר מאביכם שבשמים. ");
INSERT INTO heblb_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","אם אתה נותן נדבה, אל תספר על כך לכולם, כפי שעושים הצבועים. הם אף תוקעים בשופר בבית־הכנסת לכבוד זה, כדי שכולם יעריצו את צדקנותם. אני אומר לכם: הם יקבלו את מה שמגיע להם. ");
INSERT INTO heblb_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","אם אתה נותן נדבה, עשה זאת בסתר – אל תספר לידך השמאלית מה שעושה ידך הימנית. ");
INSERT INTO heblb_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ואז אביכם שבשמים, הרואה במסתרים, יגמול לכם. ");
INSERT INTO heblb_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","”כשאתם מתפללים, אל תנהגו כמו הצבועים, המתפללים בפינות רחוב ובבית־הכנסת כדי שכולם יראו אותם. אני אומר לכם: שכרם אתם. ");
INSERT INTO heblb_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","כשאתם מתפללים, היכנסו לחדר לבד, נעלו את הדלת והתפללו בסתר אל אביכם. ואז אביכם שבשמים, הרואה את הנעשה במסתרים, ייתן לכם שכר בגלוי. ");
INSERT INTO heblb_vpl VALUES ("MT6_7‏","070_6_7‏","MAT","6","7‏","8","”אל תחזרו שוב ושוב על אותה תפילה, כפי שנוהגים עובדי האלילים. הם חושבים שיקבלו תשובה רק אם יחזרו על תפילתם פעמים רבות. זכרו: אביכם יודע מה שאתם צריכים לפני שאתם מבקשים זאת ממנו! ");
INSERT INTO heblb_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","לכן התפללו כך: ’אבינו שבשמים, יתקדש שמך. ");
INSERT INTO heblb_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","תבוא מלכותך, שרצונך ייעשה בארץ כמו בשמים. ");
INSERT INTO heblb_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","ספק לנו מדי יום את המזון הדרוש לנו. ");
INSERT INTO heblb_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","אנא סלח לנו על חטאינו, כשם שאנו סולחים לאלה שחטאו נגדנו. ");
INSERT INTO heblb_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","עזור לנו לעמוד נגד פיתויים וניסיונות, והצל אותנו מכל רע (כי שלך המלכות, הכוח והתפארת לעולמי עולמים. אמן‘). ");
INSERT INTO heblb_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","”אביכם שבשמים יסלח לכם אם תסלחו גם אתם לאלה שחוטאים נגדכם. ");
INSERT INTO heblb_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","אם לא תהיו מוכנים לסלוח להם, לא יסלח ה׳ גם לכם על חטאיכם. ");
INSERT INTO heblb_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","”כאשר אתם צמים, אל תפגינו זאת לפני כולם, כפי שעושים הצבועים. הם מנסים להראות עצובים ושהם בצום. הם יקבלו את מה שמגיע להם. ");
INSERT INTO heblb_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","אך אתם, כאשר אתם צמים, סדרו וטפחו את מראכם, ");
INSERT INTO heblb_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","כדי שאיש לא יחשוב שאתם רעבים – מלבד אביכם שבשמים הרואה במסתרים, והוא ייתן לכם את השכר המגיע לכם. ");
INSERT INTO heblb_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","”אל תצברו לכם רכוש בארץ, במקום שהוא עלול להחליד, להירקב או להיגנב. ");
INSERT INTO heblb_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","צברו את רכושכם בשמים, כי שם הוא בטוח מפני גנבה ולא יאבד את ערכו לעולם. ");
INSERT INTO heblb_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","במקום שבו נמצא אוצרכם שם נמצא גם לבכם ומחשבותיכם. ");
INSERT INTO heblb_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","”עין האדם היא אור גופו. אם עינך טהורה, תמיד יזרח אור השמש בתוך נפשך. ");
INSERT INTO heblb_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","אבל אם עינכם רעה, אזי תחשך כולך. מה רבה חשכה זאת! ");
INSERT INTO heblb_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","אינך יכול לעבוד שני אדונים; אתה תשנא את האחד ותאהב את האחר, או להיפך – תהיה נאמן לאחד ותזלזל באחר. אינך יכול לעבוד את האלוהים ואת הכסף! ");
INSERT INTO heblb_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","”משום כך אני אומר לכם שלא תדאגו לדברים חומרניים ויום־יומיים כמו מה לאכול ולשתות ומה ללבוש. הלא החיים חשובים מאוכל, והנפש חשובה מהלבוש. ");
INSERT INTO heblb_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","תחשבו על הציפורים למשל: אין הן דואגות למה שתאכלנה – הציפורים אינן זורעות, אינן קוצרות ואינן אוגרות מזון – כי אביכם שבשמים מאכיל אותן ודואג להן. והלא יקרים אתם לאלוהים הרבה יותר מהציפורים. ");
INSERT INTO heblb_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","חוץ מזה, מה תועיל דאגתכם? האם היא יכולה להוסיף עוד יום לחייכם, או עוד סנטימטר לקומתכם? ");
INSERT INTO heblb_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","”ומדוע אתם דואגים ללבוש? הביטו בפרחי הבר! אין הם דואגים למה שילבשו! ");
INSERT INTO heblb_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","ואילו שלמה המלך בכל תפארתו לא היה לבוש יותר יפה מהם! ");
INSERT INTO heblb_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","ואם אלוהים מלביש את פרחי השדה הצומחים היום ונובלים מחר, האם אינכם חושבים שילביש גם אתכם, חסרי אמונה שכמותכם? ");
INSERT INTO heblb_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","”לכן אל תדאגו לאוכל או ללבוש. ");
INSERT INTO heblb_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","בני־אדם שאינם מאמינים באלוהים דואגים יום־יום למה שיאכלו וישתו, אולם אביכם שבשמים יודע בדיוק מה אתם צריכים. ");
INSERT INTO heblb_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","בקשו לפני הכול את מלכותו של אלוהים וחיו ביושר, והוא ייתן לכם את כל מה שאתם צריכים. ");
INSERT INTO heblb_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","”אם כן אל תדאגו למחר; אלוהים ידאג למחר שלכם, ודיה לצרה בשעתה.“ ");
INSERT INTO heblb_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","”אל תשפטו אחרים, ולא ישפטו אתכם. ");
INSERT INTO heblb_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","כי יתייחסו אליכם לפי איך שאתם מתייחסים לאחרים. ישפטו אתכם במידה שאתם שופטים אחרים. ");
INSERT INTO heblb_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","כיצד יכול אתה לראות שביב־עץ קטן בעין חברך, ולא להבחין בקרש הגדול שבעינך? ");
INSERT INTO heblb_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","”איך אתה יכול לומר לחברך: ’תן לי לסלק את השביב מעינך‘ בזמן שבעינך יש קרש כזה גדול? הרי כלל לא תוכל לראות את השביב! ");
INSERT INTO heblb_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","צבוע שכמותך! סלק תחילה את הקרש מעינך, ורק לאחר מכן תוכל לסלק את שביב העץ מעין חברך! ");
INSERT INTO heblb_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","”אל תתנו דברים קדושים לאנשים מושחתים, אל תתנו פנינים לחזירים. הם ירמסו את הפנינים, ולאחר מכן יפנו לתקוף אתכם. ");
INSERT INTO heblb_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","”אם תבקשו – תקבלו; אם תחפשו – תמצאו; ואם תדפקו תיפתח לפניכם הדלת. ");
INSERT INTO heblb_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","כי כל המבקש מקבל, כל המחפש מוצא, ולפני כל דופק נפתחת הדלת. ");
INSERT INTO heblb_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","אם ילד מבקש מאביו פרוסת לחם, האם האב ייתן לו אבן במקום לחם? ");
INSERT INTO heblb_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","אם הילד מבקש דג, האם אתם חושבים שיקבל נחש? ");
INSERT INTO heblb_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","ואם אנשים רעים וחוטאים כמוכם נותנים לילדיכם מתנות טובות, האם לא ייתן אביכם שבשמים מתנות הרבה יותר טובות למבקשים ממנו? ");
INSERT INTO heblb_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","”עשו לאחרים את מה שהייתם רוצים שיעשו לכם – זאת תמצית התורה ודברי הנביאים. ");
INSERT INTO heblb_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","”הלכו דרך הפתח הצר, כי השביל המוביל לאבדון הוא רחב, ושער הכניסה רחב גם הוא. ");
INSERT INTO heblb_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","אולם שער החיים הוא קטן, השביל צר, ורק מעטים מוצאים אותו. ");
INSERT INTO heblb_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","”היזהרו לכם מהמורים המפיצים תורות שקר. הם מתחפשים לכבשים תמימים, בעוד שלמעשה הם זאבים רעים הרוצים לטרוף אתכם. ");
INSERT INTO heblb_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","תוכלו לזהות אותם על־פי התנהגותם, כשם שאפשר לזהות עץ על־פי פירותיו. הלא יודעים אתם להבחין בין גפן ענבים לבין ברקנים, בין תאנים לבין קוצים! ");
INSERT INTO heblb_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","עץ משובח נותן פרי משובח, ועץ רקוב נותן פרי רקוב. ");
INSERT INTO heblb_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","עץ טוב לא ייתן פרי רקוב, ועץ רקוב לא ייתן פרי טוב. ");
INSERT INTO heblb_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","משום כך יש לכרות ולשרוף כל עץ שאינו נותן פרי טוב. ");
INSERT INTO heblb_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","אכן, גם עצים וגם בני־אדם אפשר לזהות על־פי פירותיהם. ");
INSERT INTO heblb_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","”לא כל מי שמדבר כאיש דתי ואדוק הוא באמת מאמין. הם יכולים לקרוא לי: ’אדוני, אדוני‘, אבל אין זה מספיק כדי להכניסם לשמים. החשוב הוא אם הם שומעים לקול אבי שבשמים. ");
INSERT INTO heblb_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","ביום־הדין יאמרו לי אנשים רבים: ’אדון, אדון, הלא בשמך ניבאנו, ובשמך גירשנו שדים וחוללנו נסים רבים‘. ");
INSERT INTO heblb_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","אולם אני אענה: ’מעולם לא הכרתי אתכם. הסתלקו מכאן, פושעים שכמותכם!‘ ");
INSERT INTO heblb_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","”כל מי שמקשיב לדברי ומקיים אותם, דומה לאדם חכם הבונה את ביתו על סלע איתן. ");
INSERT INTO heblb_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","שכן גם אם ירד גשם שוטף ותתחולל סערה, לא ייפול הבית ולא יתמוטט, כי נבנה על הסלע. ");
INSERT INTO heblb_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","לעומתו, מי שמקשיב לדברי ואינו מקיים אותו דומה לאדם טיפש הבונה את ביתו על החול. ");
INSERT INTO heblb_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","שהרי בבוא שיטפון וסערה יתמוטט הבית וייהרס כליל.“ ");
INSERT INTO heblb_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","ההמונים נדהמו מאוד כששמעו את הדרשות של ישוע, ");
INSERT INTO heblb_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","כי הוא דיבר אליהם בסמכות רבה ולא כמו הסופרים. ");
INSERT INTO heblb_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","כשירד ישוע מהגבעה הלך אחריו קהל גדול. ");
INSERT INTO heblb_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","אדם חולה בצרעת בא לקראתו, נפל על ברכיו והתחנן: ”אדוני, אם רק תרצה, תוכל לרפא אותי.“ ");
INSERT INTO heblb_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","ישוע נגע באיש ואמר: ”ודאי שאני רוצה. הירפא!“ ומיד נעלמה הצרעת. ");
INSERT INTO heblb_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","”אל תספר על כך לאיש“, אמר לו ישוע. ”לך מיד אל הכהן והראה לו שנרפאת. אל תשכח לקחת איתך קורבן טהרה, כפי שציווה משה על בני־ישראל, כדי שכולם יראו שנרפאת!“ ");
INSERT INTO heblb_vpl VALUES ("MT8_5‏","070_8_5‏","MAT","8","5‏","6","כשהגיע ישוע לכפר־נחום, בא אליו קצין רומאי והתחנן לפניו שירפא את משרתו הצעיר, השוכב משותק על מיטתו וסובל כאבים נוראיים. ");
INSERT INTO heblb_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","”כן“, השיב ישוע. ”אבוא לרפא אותו.“ ");
INSERT INTO heblb_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","”אדוני“ אמר הקצין, ”אני לא ראוי שתבוא אל ביתי, וגם אין צורך בכך. רק צווה שמשרתי יירפא, והוא יירפא. ");
INSERT INTO heblb_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","כיצד אני יכול להיות בטוח בכך? הרי אני איש צבא ורגיל לקבל פקודות מהממונים עלי, ואף לתת פקודות לחיילים תחת פיקודי. אם אני אומר לחייל אחד: ’לך‘, הוא הולך. אם אני אומר לחייל אחר ’בוא‘, הוא בא. ואם אני אומר למשרתי: ’עשה עבודה זאת או אחרת‘, הוא עושה אותה.“ ");
INSERT INTO heblb_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","דברי הקצין הפליאו את ישוע. הוא פנה אל הקהל ואמר: ”בכל ישראל לא ראיתי אמונה גדולה כזאת! ");
INSERT INTO heblb_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","אני אומר לכם שגויים רבים, כמו הקצין הזה, יבואו מכל העולם וישבו במלכות השמים יחד עם אברהם, יצחק ויעקב. ");
INSERT INTO heblb_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","ורבים – שלמענם הוכנה המלכות – יגורשו לחושך, למקום של בכי וייסורים.“ ");
INSERT INTO heblb_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","לאחר מכן אמר ישוע לקצין הרומאי: ”לך עתה לביתך; הדבר שהאמנת בו נעשה!“ ובאותה שעה נרפא המשרת. ");
INSERT INTO heblb_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","כשבא ישוע לביתו של שמעון, ראה את חמותו של שמעון שוכבת במיטתה וקודחת מחום. ");
INSERT INTO heblb_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","ישוע נגע בידה, ומיד ירד החום. היא קמה ממיטתה והכינה להם אוכל. ");
INSERT INTO heblb_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","באותו ערב הובאו אל ישוע מספר אנשים אחוזי־שדים. במילה אחת מפיו של ישוע ברחו כל השדים, והחולים נרפאו. ");
INSERT INTO heblb_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","מעשה זה הגשים את נבואת ישעיהו: ”חלינו הוא נשא ומכאובינו סבלם.“ ");
INSERT INTO heblb_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","כשראה ישוע את הקהל הרב שהתאסף סביבו, הורה לתלמידיו להתכונן לעבור לצד השני של הכינרת. ");
INSERT INTO heblb_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","באותו זמן ניגש אליו איש דת אחד ואמר: ”רבי, לכל מקום שתלך, אלך אחריך!“ ");
INSERT INTO heblb_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","אולם ישוע ענה לו: ”השועלים מתגוררים במחילות האדמה, ולציפורים יש קנים. אולם לבן־האדם אין מקום להניח את ראשו.“ ");
INSERT INTO heblb_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","תלמיד אחר אמר לישוע: ”אדוני, הרשה לי קודם לקבור את אבי ואחר כך אלך אחריך.“ ");
INSERT INTO heblb_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","אולם ישוע ענה לו: ”לך אחרי עכשיו! והנח למתים (מבחינה רוחנית) לדאוג למתים שלהם.“ ");
INSERT INTO heblb_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","לאחר מכן נכנסו ישוע ותלמידיו לסירה והחלו לשוט אל הצד השני של הכינרת. ");
INSERT INTO heblb_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","לפתע התחוללה סערה נוראה, והגלים הגבוהים הציפו את הסירה. ואילו ישוע ישן. ");
INSERT INTO heblb_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","התלמידים ניגשו אל ישוע והעירו אותו בבהלה: ”אדוננו, הצל אותנו! אנחנו טובעים!“ ");
INSERT INTO heblb_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","אולם ישוע ענה: ”חסרי־אמונה שכמוכם! מדוע אתם פוחדים כל־כך?“ הוא קם ונזף ברוח, ופקד על הים להירגע. מיד פסקה הסערה; הרוח שקטה והים נרגע. ");
INSERT INTO heblb_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","התלמידים הנדהמים שאלו זה את זה: ”מיהו האיש הזה שאפילו הרוח והים נשמעים לו?“ ");
INSERT INTO heblb_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","בהגיעם אל ארץ הגדריים, באו לקראתם שני אנשים אחוזי־שדים. השניים התגוררו בבית־הקברות והיו מסוכנים כל כך, עד שאיש לא העז לעבור באזור ההוא. ");
INSERT INTO heblb_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","השניים צעקו אל ישוע: ”מה אתה רוצה מאתנו, בן־האלוהים? אסור לך עדיין לייסר אותנו!“ ");
INSERT INTO heblb_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","במרחק מה משם רעה עדר חזירים, ");
INSERT INTO heblb_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","והשדים ביקשו: ”אם אתה מגרש אותנו, שלח אותנו לפחות אל תוך החזירים האלה.“ ");
INSERT INTO heblb_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","ישוע הסכים, וציווה עליהם: ”הסתלקו!“ השדים יצאו מהאנשים ונכנסו בחזירים, ואלה דהרו מיד במדרון ההר ישר אל תוך הים, וטבעו. ");
INSERT INTO heblb_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","הרועים ברחו אל העיר הקרובה וסיפרו על מה שקרה, ");
INSERT INTO heblb_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","וכל אנשי העיר יצאו מיד לראות את ישוע, וביקשו ממנו לעזוב את האזור ולא להטריד אותם. ");
INSERT INTO heblb_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","ישוע חזר לסירה, חצה את האגם ושב לכפר־נחום עיר מגוריו. ");
INSERT INTO heblb_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","מספר אנשים הביאו אליו בחור משותק על אלונקה. כשראה ישוע את אמונתם, אמר לבחור: ”התעודד, בני, כי נסלחו לך חטאיך!“ ");
INSERT INTO heblb_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","”איש זה מגדף!“ אמרו בלבם מספר סופרים. (כי מי מלבד אלוהים יכול לסלוח על חטאים?) ");
INSERT INTO heblb_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","ישוע ידע את מחשבותיהם, ולכן שאל אותם: ”מדוע אתם חושבים מחשבות רעות? ");
INSERT INTO heblb_vpl VALUES ("MT9_5‏","070_9_5‏","MAT","9","5‏","6","לבן האדם, יש סמכות לסלוח על חטאים, אך מכיוון שכל אחד יכול לומר דברים סתם, אז אפגין לכם את סמכותי.“ הוא פנה אל הנער המשותק ואמר לו ”קום! קפל את האלונקה שלך ולך הביתה!“ ");
INSERT INTO heblb_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","הבחור קפץ על רגליו לנגד עיניהם, והלך לביתו. ");
INSERT INTO heblb_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","פחד אחז את הנוכחים, והם הודו לה׳ ושיבחו אותו על שנתן כוח כזה לבני־אדם. ");
INSERT INTO heblb_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","כשישוע הלך משם הוא ראה בבית־המכס את גובה המכס, מתתיהו. ”בוא והיה תלמיד שלי“, אמר לו ישוע. מתתיהו קם, עזב את הכול מאחוריו והלך אחרי ישוע. ");
INSERT INTO heblb_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","בערב כשאכלו ישוע ותלמידיו בביתו של מתתיהו, הצטרפו אליהם מוכסים וחוטאים אחרים. ");
INSERT INTO heblb_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","הפרושים כעסו מאוד ואמרו לתלמידיו: ”מדוע הרב שלכם אוכל בחברת החוטאים האלה?“ ");
INSERT INTO heblb_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","ישוע השיב להם: ”אנשים בריאים אינם זקוקים לרופא; אלא שהחולים זקוקים לרופא!“ השיב להם ישוע, ");
INSERT INTO heblb_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","והוסיף: ”עתה לכו ולימדו את משמעות הפסוק: ’כי חסד חפצתי ולא‎ זֶבַח‘. לא באתי לקרוא לצדיקים לחזור בתשובה, כי אם לחוטאים.“ ");
INSERT INTO heblb_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","יום אחד באו תלמידי יוחנן אל ישוע ושאלו: ”מדוע תלמידיך אינם צמים כמונו וכמו הפרושים?“ ");
INSERT INTO heblb_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","”האם יכולים ידידי החתן להתאבל ולצום בזמן שהוא נמצא אתם?“ השיב להם ישוע בשאלה. ”אולם יבוא יום שהחתן יילקח מהם, ואז הם יצומו.“ ");
INSERT INTO heblb_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","”מי תופר טלאי מבד חדש על בגד ישן? הרי הטלאי מהבגד החדש יינתק ויגדיל את החור בבגד! ");
INSERT INTO heblb_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","ומי ממלא יין חדש בחביות רקובות? הרי היין יבקע את החביות ויישפך החוצה! יין חדש יש לשמור בחביות חדשות. כך יישמרו היין והחביות.“ ");
INSERT INTO heblb_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","בשעה שישוע דיבר בא אליו הרב של בית־הכנסת המקומי והשתחווה לפניו. ”בתי הקטנה מתה ממש עכשיו,“ אמר הרב, ”אולם אתה תוכל להחיות אותה, אם רק תבוא ותיגע בה.“ ");
INSERT INTO heblb_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","ישוע קם והלך אחרי הרב, ותלמידיו הצטרפו אליו. ");
INSERT INTO heblb_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","בקרב הקהל שהלך אחריהם הייתה אישה שסבלה משטף דם מתמיד במשך שתים־עשרה שנה. היא עמדה מאחורי ישוע ונגעה בקצה מעילו, ");
INSERT INTO heblb_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","מפני שחשבה: ”אם רק אגע בבגדו, ארפא!“ ");
INSERT INTO heblb_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","ישוע פנה לאחור ואמר לאישה: ”התעודדי בתי, אמונתֵך ריפאה אותך.“ ובאותו רגע היא נרפאה. ");
INSERT INTO heblb_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","ישוע הגיע לבית הרב וראה את המתאבלים שבכו וקוננו קינות. ");
INSERT INTO heblb_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","”לכו מכאן כולכם!“ קרא ישוע. ”הילדה לא מתה; היא רק ישנה!“ אולם כולם צחקו לו. ");
INSERT INTO heblb_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","ברגע שיצאו האנשים נכנס ישוע לחדר הילדה, אחז בידה, והיא קפצה ממיטתה בריאה לגמרי. ");
INSERT INTO heblb_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","השמועה על הנס הנפלא הזה התפשטה בכל האזור. ");
INSERT INTO heblb_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","כשעזב ישוע את בית הרב, הלכו בעקבותיו שני עיוורים וצעקו: ”בן דוד, רחם עלינו!“ ");
INSERT INTO heblb_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","שני העיוורים נכנסו אל הבית שבו התארח ישוע, והוא שאל אותם: ”האם אתם מאמינים שאני יכול להשיב לכם את ראייתכם?“ ”כן, אדון,“ ענו השניים, ”אנחנו מאמינים.“ ");
INSERT INTO heblb_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","ישוע נגע בעיניהם ואמר: ”משום שהאמנתם, תירפאו.“ ");
INSERT INTO heblb_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","לפתע יכלו השניים לראות. ישוע הזהיר אותם שלא יספרו על כך לאיש, ");
INSERT INTO heblb_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","אולם השניים לא שמעו בקולו ופרסמו את דבר הנס בכל הארץ. ");
INSERT INTO heblb_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","כשעזב ישוע את המקום הוא פגש אדם אילם שהיה אחוז שד. ");
INSERT INTO heblb_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","ישוע גירש את השד, והאיש החל לדבר. ההמונים נדהמו וקראו: ”מעולם לא נראו דברים כאלה בישראל!“ ");
INSERT INTO heblb_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","אולם הפרושים אמרו: ”אין פלא שהוא יכול לגרש שדים, הרי הוא מקבל את כוחו משר השדים!“ ");
INSERT INTO heblb_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","ישוע עבר בכל הערים והכפרים שבאזור, כשהוא מלמד בבתי־הכנסת ומבשר את החדשות הטובות על מלכות השמים. בכל מקום שבו ישוע ביקר הוא ריפא את האנשים מכל מיני מחלות. ");
INSERT INTO heblb_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","הוא ריחם על כל האנשים שלא ידעו מה לעשות ולאן לפנות. הם היו כמו כבשים תועות בלי רועה. ");
INSERT INTO heblb_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","”הקציר כה רב אך הפועלים כה מעטים!“ אמר ישוע לתלמידיו. ");
INSERT INTO heblb_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","”התפללו ובקשו מהאחראי על הקציר שידריך ויכשיר לעבודה פועלים רבים יותר!“ ");
INSERT INTO heblb_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","ישוע קרא אליו את שנים־עשר תלמידיו ונתן להם כוח לגרש רוחות רעות ולרפא כל מיני מחלות. ");
INSERT INTO heblb_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","אלה שמותיהם של שנים־עשר התלמידים: שמעון (הנקרא גם פטרוס), ‎אַנְדְּרֵי (אחיו של שמעון), יעקב (בנו של זבדי), יוחנן (אחיו של יעקב), ");
INSERT INTO heblb_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","פיליפוס, בר־תלמי, תומא, מתתיהו (גובה המכס), יעקב (בן־חלפי), תדי, ");
INSERT INTO heblb_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","שמעון (מחבורת ”הקנאים“), ויהודה איש קריות (זה שהסגיר את ישוע). ");
INSERT INTO heblb_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","ישוע נתן להם את ההוראות הבאות: ”אל תלכו אל הגויים או אל השומרונים, ");
INSERT INTO heblb_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","כי אם אל הצאן התועה של עם ישראל בלבד. ");
INSERT INTO heblb_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","לכו וספרו להם שמלכות השמים קרובה. ");
INSERT INTO heblb_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","רפאו את החולים, הקימו את המתים לתחייה, רפאו את המצורעים וגרשו את השדים. אתם קיבלתם הכול חינם אין כסף, לכן אל תדרשו תמורה בעד שירותכם! ");
INSERT INTO heblb_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","”אל תיקחו איתכם זהב, כסף או נחושת. ");
INSERT INTO heblb_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","אל תיקחו תרמיל עם בגדים להחלפה, לא נעלים ואף לא מקל הליכה. האנשים שתעזרו להם ידאגו לכם ויטפלו בכם. ");
INSERT INTO heblb_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","בבואכם לעיר או לכפר, חפשו שם בן אדם טוב והישארו בביתו עד שיגיע הזמן ללכת לעיר אחרת. ");
INSERT INTO heblb_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","כשתכנסו אל הבית, קודם כל ברכו אותו בשלום. ");
INSERT INTO heblb_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","אם זהו ביתם של אנשים טובים, הברכה תתקיים; ואם אין אלה אנשים טובים, הברכה תשוב אליכם. ");
INSERT INTO heblb_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","בכל עיר או בית שבהם לא יקבלו אתכם, נערו את אבק המקום מעל רגליכם ולכו לדרככם. ");
INSERT INTO heblb_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","אני אומר לכם: אף לסדום ועמורה יהיה קל יותר ביום־הדין מאשר לערים אלה. ");
INSERT INTO heblb_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","”אני שולח אתכם כמו כבשים בין זאבים. לכן היו ערמומיים כנחשים ותמימים כיונים. ");
INSERT INTO heblb_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","אולם היזהרו! כי עלולים לאסור ולשפוט אתכם ולהלקות אתכם בשוטים בבתי־הכנסת. ");
INSERT INTO heblb_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","כן, יהיה עליכם להישפט לפני מלכים ומושלים בגללי, אולם זאת תהיה לכם הזדמנות לספר להם ולעולם כולו על אודותיי. ");
INSERT INTO heblb_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","”כשיאסרו אתכם, אל תדאגו למה שתגידו במשפט, כי אני אשים בפיכם את המילים הנכונות בזמן הנכון, ");
INSERT INTO heblb_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","וכך לא אתם תדברו, כי אם רוח אביכם שבשמים ידבר בפיכם. ");
INSERT INTO heblb_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","”אח יבגוד באחיו ויסגירו למוות; אבות ימסרו את בניהם למוות; ילדים יקומו נגד הוריהם וייגרמו למותם. ");
INSERT INTO heblb_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","כולם ישנאו אתכם משום שאתם שייכים לי, אולם כל מי שיחזיק מעמד עד הסוף – ייוושע! ");
INSERT INTO heblb_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","”אם רודפים אתכם ומציקים לכם בעיר אחת – ברחו לעיר אחרת. לא תספיקו לעבור בין כל הערים עד שבן־האדם יחזור. ");
INSERT INTO heblb_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","תלמיד איננו גדול ממורו, ועבד אינו מכובד מאדוניו. ");
INSERT INTO heblb_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","התלמיד משתתף בגורל מורו, ומה שיקרה לאדון יקרה גם לעבד. ואם לי, האדון, קראו ’בעל־זבוב‘ (אדון השדים), אין ספק שכך יקראו גם לכם. ");
INSERT INTO heblb_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","אולם אל תפחדו מאלה שמאיימים עליכם, כי יבוא הזמן שהאמת תצא לאור, וכולם יוכלו לראות את מזימות הסתר שלהם. ");
INSERT INTO heblb_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","”מה שאני אומר לכם בחושך, לכו והכריזו אותו באור היום. ומה שאני לוחש באוזניכם, השמיעו בקול מעל גגות הבתים. ");
INSERT INTO heblb_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","”אל תפחדו מאלה היכולים להרוג את גופכם בלבד, אולם אינם מסוגלים לפגוע בנפשכם! עליכם לפחוד רק מאלוהים היכול להשמיד גם את הגוף וגם את הנפש בגיהינום. ");
INSERT INTO heblb_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","אף ציפור דרור (הנמכרת בזול) לא תיפול על הארץ בלי שאביכם שבשמים ידע זאת. ");
INSERT INTO heblb_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","אלוהים יודע אף את מספר השערות שעל ראשכם! ");
INSERT INTO heblb_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","לכן אל תפחדו! אתם יקרים לאלוהים יותר מציפורים רבות. ");
INSERT INTO heblb_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","”כל המכיר בי לפני בני־אדם, גם אני אכיר בו לפני אבי שבשמים. ");
INSERT INTO heblb_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","אולם אם מישהו טוען שאינו מכיר אותי, גם אני לא אכיר בו לפני אבי שבשמים. ");
INSERT INTO heblb_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","”אל תחשבו שבאתי להשכין שלום בארץ! לא שלום, כי אם חרב. ");
INSERT INTO heblb_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","באתי להמריד בן באביו ובת באמה, ולגרום לכלה למרוד בחמותה. ");
INSERT INTO heblb_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","אויביו הגדולים של האדם יהיו דווקא בני־ביתו. ");
INSERT INTO heblb_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","אם אתה אוהב את אביך ואת אמך יותר ממני, אינך ראוי להיות תלמידי. ואם אתה אוהב את בנך או את בתך יותר ממני, אינך ראוי לי. ");
INSERT INTO heblb_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","אם אינך מוכן לשאת את צלבך וללכת אחרי, אינך ראוי לי. ");
INSERT INTO heblb_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","”מי שרוצה לשמור על חייו – יאבד אותם, ואם יהיה מוכן לוותר על חייו למעני – ימצא אותם. ");
INSERT INTO heblb_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","”מי שמקבל אתכם בשמחה – מקבל אותי. ומי שמקבל אותי – מקבל גם את האלוהים ששלח אותי. ");
INSERT INTO heblb_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","אם תקבלו בשמחה נביא, משום שהוא איש אלוהים – תקבלו אותו שכר בשמים שמקבל הנביא. ואם תקבלו אנשים טובים וצדיקים, משום שהם אוהבים את ה׳ – תקבלו אותו השכר שהם מקבלים. ");
INSERT INTO heblb_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","ואם בתור תלמידי תתנו לילד קטן כוס מים קרים, אני מבטיח לכם שתקבלו שכר משמעותי על כך.“ ");
INSERT INTO heblb_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","כשישוע סיים לתת הוראות לתלמידיו, הלך בעצמו להטיף בערים שלהם. ");
INSERT INTO heblb_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","יוחנן המטביל, שהיה אז בכלא, שמע על הנסים שחולל המשיח, ולכן שלח שניים מתלמידיו לשאול את ישוע: ");
INSERT INTO heblb_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","”האם אתה האיש שלו אנו מחכים? או האם עלינו להמשיך לחכות למישהו אחר?“ ");
INSERT INTO heblb_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","השיב להם ישוע: ”לכו וספרו ליוחנן את כל מה שראיתם ושמעתם כאן היום. ");
INSERT INTO heblb_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","ספרו לו שהעיוורים רואים, הפיסחים מהלכים, המצורעים מטוהרים, החרשים שומעים, המתים קמים לתחייה והעניים שומעים את בשורת מלכות האלוהים. ");
INSERT INTO heblb_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","מלבד זאת אמרו לו: ’אשרי האיש שעבורו אינני מהווה מכשול!‘ “ ");
INSERT INTO heblb_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","לאחר שהלכו התלמידים החל ישוע לדבר אל הקהל על יוחנן: ”למה ציפיתם כשהלכתם אל המדבר השומם לראות את יוחנן? עשב הנע ברוח? ");
INSERT INTO heblb_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","או אולי ציפיתם לפגוש אדם לבוש פאר, כמו נסיך בארמון? ");
INSERT INTO heblb_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","או האם ציפיתם לראות נביא אלוהים? אז נכון, והוא אף גדול מנביא! ");
INSERT INTO heblb_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","יוחנן הוא השליח שנועד ללכת לפני ולבשר את בואי, כפי שכתוב בתנ״ך: ’הנני שולח מלאכי לפניך ופנה דרכך לפניך.‘ ");
INSERT INTO heblb_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","”אומר לכם את האמת: מבין כל האנשים שנולדו אי־פעם, לא היה איש גדול כיוחנן המטביל. ובכל זאת, הוא נחשב לקטן לעומת כל אחד במלכות השמים. ");
INSERT INTO heblb_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","מאז יוחנן ועד היום, חייבים להיאבק למען מלכות השמיים! ");
INSERT INTO heblb_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","כל התורה והנביאים סיפרו על המשיח עד בואו של יוחנן. ");
INSERT INTO heblb_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","אם אתם מוכנים להאמין לדברי, יוחנן הוא שאליו כולם מחכים ומייחלים. ");
INSERT INTO heblb_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","מי שמסוגל לשמוע, שיקשיב! ");
INSERT INTO heblb_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","”מה אני יכול להגיד על הדור הזה? האנשים כאן דומים לילדים המשחקים עם חבריהם ואומרים: ");
INSERT INTO heblb_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","’שיחקנו אתכם ב”חתן וכלה“, אבל לא שמחתם. שיחקנו אתכם ב”לוויה“, אבל לא התאבלתם‘. ");
INSERT INTO heblb_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","יוחנן המטביל התנזר מיין וצם לעיתים קרובות, ואתם אומרים עליו ’שד בו‘. ");
INSERT INTO heblb_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","בן־האדם אוכל ושותה ואתם מתלוננים שהוא זולל וסובא ומתחבר עם אנשים מפוקפקים. האמת של אלוהים נגלית דרך חייהם וחוכמתם של צדיקים.“ ");
INSERT INTO heblb_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","לאחר מכן החל ישוע להוכיח את הערים שבהן חולל נסים רבים, כי התושבים לא חזרו בתשובה. ");
INSERT INTO heblb_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","”אוי לכן, כורזין ובית־צידה! אילו חוללתי בערים המושחתות צור וצידון את הנסים שחוללתי בקרבכן, אנשיהן מזמן היו חוזרים בתשובה ולובשים שק ואפר לאות חרטה. ");
INSERT INTO heblb_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","ובאמת, ביום־הדין תקבלנה צור וצידון עונש קל משלכן! ");
INSERT INTO heblb_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","וְאַתְּ, כפר־נחום, החושבת אַתְּ שישבחו וירוממו אותַך עד השמים? לגיהינום תורדי! אילו נעשו בסדום הנפלאות שחוללתי בך, הייתה סדום קיימת עד היום! ");
INSERT INTO heblb_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","ובאמת, ביום־הדין תקבל סדום עונש קל משלך!“ ");
INSERT INTO heblb_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","לאחר מכן התפלל ישוע את התפילה הבאה: ”אבי, אדון השמים והארץ, אני מודה לך על שהסתרת את האמת מפני אלה החושבים את עצמם לחכמים, ועל שגילית אותה לילדים קטנים. ");
INSERT INTO heblb_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","תודה לך אבי, על שבחרת לפעול דווקא כך. ");
INSERT INTO heblb_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","”הכול נמסר לי מאת אבי. איש אינו מכיר ממש את הבן – מלבד האב. ואיש אינו מכיר ממש את האב – מלבד הבן, והאנשים שהוא בוחר לגלות להם את האב.“ ");
INSERT INTO heblb_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","”אתם, העייפים והנושאים עול כבד: בואו אלי ואתן לכם מנוחה. ");
INSERT INTO heblb_vpl VALUES ("MT11_29‏","070_11_29‏","MAT","11","29‏","30","שאו את העול שלי ולימדו ממני, כי אני עניו וצנוע, ואצלי תמצאו מנוחה לנפשותיכם. כי עולי נעים ומשאי קל.“ ");
INSERT INTO heblb_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","לאחר מכן, בשבת אחת, עברו ישוע ותלמידיו דרך שדה תבואה. מאחר שהתלמידים היו רעבים הם קטפו שיבולים ואכלו את הגרעינים. ");
INSERT INTO heblb_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","פרושים אחדים ראו את הדבר ומחו לפני ישוע: ”תלמידיך עוברים על התורה! הם מחללים את השבת!“ ");
INSERT INTO heblb_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","אולם ישוע השיב להם: ”האם מעולם לא קראתם מה עשה דוד המלך כשהוא ואנשיו היו רעבים? ");
INSERT INTO heblb_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","דוד נכנס לאוהל מועד, ויחד עם אנשיו אכל את לחם הפנים שהיה מיועד לכוהנים בלבד. גם מעשה זה היה עבירה על התורה! ");
INSERT INTO heblb_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","והאם מעולם לא קראתם בתורה שמותר לכוהנים התורנים לעבוד בשבת בבית־המקדש? ");
INSERT INTO heblb_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","אני אומר לכם: יש כאן אחד שהוא גדול מן המקדש! ");
INSERT INTO heblb_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","אילו הבינותם את הפסוק: ’חסד חפצתי ולא‎ זֶבַח‘, לא הייתם מרשיעים חפים מפשע! ");
INSERT INTO heblb_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","כי בן האדם הוא אדון השבת.“ ");
INSERT INTO heblb_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","ישוע המשיך בדרכו ונכנס אל בית־הכנסת המקומי. ");
INSERT INTO heblb_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","באותה שעה היה בבית־הכנסת איש שידו משותקת. שאלו הפרושים את ישוע: ”האם מותר לרפא בשבת?“ (הם קיוו שישוע יאמר ”כן“, כדי שיוכלו להרשיע ולאסור אותו). ");
INSERT INTO heblb_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","אולם ישוע השיב להם: ”אילו הייתה לכם כבשה אחת בלבד, והיא הייתה נופלת בשבת לתוך הבאר, האם לא הייתם עובדים באותו יום וטורחים להציל אותה? ");
INSERT INTO heblb_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","וכמה יקר האדם מן הכבשה! כן, מותר לעשות טוב בשבת.“ ");
INSERT INTO heblb_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","ישוע פנה אל האיש ואמר: ”הושט את ידך.“ וכאשר זה הושיט את ידו היא נרפאה כליל ונראתה כמו היד השנייה. ");
INSERT INTO heblb_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","כשראו הפרושים את המעשה של ישוע, כינסו אספה כדי לתכנן את מאסרו והוצאתו להורג. ");
INSERT INTO heblb_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","אולם ישוע ידע את מזימתם, ולכן הלך משם. אנשים רבים הלכו בעקבותיו, וישוע ריפא את החולים שביניהם, ");
INSERT INTO heblb_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","אולם ישוע ציווה עליהם לשתוק ולא לגלות את זהותו. ");
INSERT INTO heblb_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","כך התקיימה נבואת ישעיהו: ");
INSERT INTO heblb_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","”הן עבדי, בחירי רצתה נפשי. נתתי רוחי עליו, משפט לגויים יוציא. ");
INSERT INTO heblb_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","לא יצעק ולא יישא ולא ישמיע בחוץ קולו; ");
INSERT INTO heblb_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","קנה רצוץ לא ישבור ופשתה כהה לא יכבנה עד יוציא לנצח משפט, ");
INSERT INTO heblb_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","ולשמו גוים ייחלו.“ ");
INSERT INTO heblb_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","לאחר מכן הובא אל ישוע אדם אחוז שד, שהיה עיוור ואילם. ישוע ריפא את האיש והשיב לו את ראייתו ואת כושר הדיבור. ");
INSERT INTO heblb_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","הקהל, שהופתע מאוד, קרא: ”אולי ישוע הוא המשיח בן־דוד!“ ");
INSERT INTO heblb_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","אולם כששמעו זאת הפרושים, אמרו: ”אין פלא שהוא יכול לגרש שדים; הרי הוא מקבל את כוחו מבעל־זבוב שר השדים!“ ");
INSERT INTO heblb_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","ישוע ידע את מחשבותיהם, ולכן ענה: ”ממלכה מפולגת בתוך עצמה תתפרק. בית מפולג או עיר מפולגת לא יחזיקו מעמד ויקרסו גם הם. ");
INSERT INTO heblb_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","אם השטן מגרש את השטן, הרי שהוא נלחם בעצמו והורס את ממלכתו. ");
INSERT INTO heblb_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","ואם, לפי טענתכם, אני מגרש את השדים בכוחו של בעל־זבוב – אז בכוחו של מי מגרשים בניכם את השדים? לכן הם יהיו לאמות מידה. ");
INSERT INTO heblb_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","אולם אם אני מגרש את השדים בכוחו של אלוהים וברוחו, אז עובדה שמלכות האלוהים הגיעה אליכם. ");
INSERT INTO heblb_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","איש אינו יכול לשדוד את מלכות השטן לפני שיכבול אותו תחילה. לאחר שיכבול את השטן, יוכל לשדוד את רכושו. ");
INSERT INTO heblb_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","מי שאינו אתי נגדי הוא, ומי שאינו אוסף אתי – מפזר. ");
INSERT INTO heblb_vpl VALUES ("MT12_31‏","070_12_31‏","MAT","12","31‏","32","”כל חטאיכם יכולים להיסלח, גם אם אתם מקללים אותי, רק חטא אחד לא ייסלח לכם לעולם: גידוף רוח הקודש.“ ");
INSERT INTO heblb_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","”את העץ מכירים על־פי הפרי שהוא נותן. עץ משובח נותן פרי טוב, ועץ רקוב נותן פרי רקוב. ");
INSERT INTO heblb_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","ילדי נחשים שכמוכם! כיצד יכולים אנשים רשעים כמוכם לומר דבר טוב? הרי אדם מדבר מתוך הממלא את לבו! ");
INSERT INTO heblb_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","אדם טוב מפיק מעשים טובים מהטוב שבלבו, בעוד שאדם רע מפיק מעשים רעים מהרוע שבלבו. ");
INSERT INTO heblb_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","ואני אומר לכם: ביום־הדין יהיה עליכם לתת דין וחשבון על כל מילה בטלה שיצאה מפיכם! ");
INSERT INTO heblb_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","הדברים שאתם אומרים כאן עכשיו יקבעו את גורלכם: או שהם יזכו אתכם, או שהם יחייבו אתכם בדין.“ ");
INSERT INTO heblb_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","יום אחד באו אל ישוע סופרים ופרושים אחדים וביקשו שיחולל לפניהם נס (כדי להוכיח שהוא המשיח). ");
INSERT INTO heblb_vpl VALUES ("MT12_39‏","070_12_39‏","MAT","12","39‏","40","אולם ישוע השיב: ”רק דור רע וכופר יכול לדרוש נסים נוספים! אבל האות היחיד שתקבלו יהיה אות יונה הנביא. כשם שיונה הנביא היה בבטנו של הדג שלושה ימים ושלושה לילות, כך גם בן־האדם יהיה בבטן האדמה שלושה ימים ושלושה לילות. ");
INSERT INTO heblb_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","ביום־הדין יקומו אנשי נינווה וירשיעו אתכם. כי לאחר שיונה דיבר אליהם, הם חזרו בתשובה, חדלו ממעשיהם הרעים ופנו לה׳, ואילו לפניכם עומד אדם גדול מיונה, ואתם מסרבים לשמוע לו. ");
INSERT INTO heblb_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","גם מלכת שבא תרשיע את העם הזה ביום־הדין. שהרי היא באה מארץ רחוקה כדי להקשיב לחכמת שלמה, ואילו לפניכם עומד אדם גדול משלמה.“ ");
INSERT INTO heblb_vpl VALUES ("MT12_43‏","070_12_43‏","MAT","12","43‏","45","”דור רשע זה דומה לאדם אחוז שד. כאשר יוצא השד מן האדם, הוא הולך למדבר לזמן מה ומחפש לו מנוחה. משאינו מוצא את המנוחה שחיפש, הוא אומר לעצמו: ’אשוב לאדם שמתוכו יצאתי‘. בשובו מוצא השד את לבו של אותו אדם מטואטא, מסודר ומטופח, ואז מוצא השד שבעה שדים אחרים ורעים ממנו, וכולם יחד נכנסים לתוך אותו אדם וחיים בו. וכך מצבו של אדם זה גרוע משהיה.“ ");
INSERT INTO heblb_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","בשעה שישוע דיבר בתוך בית מלא אנשים, עמדו אמו ואחיו בחוץ וביקשו לראות אותו. ");
INSERT INTO heblb_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","מישהו בא אל ישוע והודיע לו שאמו ואֶחָיו עומדים בחוץ ורוצים לדבר אתו. ");
INSERT INTO heblb_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","”מי היא אמי?“ קרא ישוע. ”מי הם אחי?“ ");
INSERT INTO heblb_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","הוא הצביע על תלמידיו והכריז: ”אלה הם אמי ואחי! ");
INSERT INTO heblb_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","כל מי שמציית לאבי שבשמים הוא אמי, אחי ואחותי!“ ");
INSERT INTO heblb_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","באותו יום, בשעה מאוחרת יותר, עזב ישוע את הבית וירד אל החוף. ");
INSERT INTO heblb_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","תוך זמן קצר התאסף שם קהל כה רב, עד שישוע נאלץ להיכנס לסירה, ואילו כל העם נשאר על החוף. ");
INSERT INTO heblb_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","ישוע הרבה ללמד את העם במשלים, והנה אחד מהם: ”איכר יצא לזרוע בשדה. ");
INSERT INTO heblb_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","כשפיזר את הזרעים נפלו אחדים מהם בצד הדרך, והציפורים באו ואכלו אותם. ");
INSERT INTO heblb_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","זרעים אחדים נפלו על אדמה סַלעִית, במקום שבו לא הייתה אדמה רבה. הנבטים צמחו במהירות באדמה הרדודה, ");
INSERT INTO heblb_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","אולם השמש הלוהטת צרבה אותם והם התייבשו ומתו, כי השורשים לא היו עמוקים. ");
INSERT INTO heblb_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","זרעים אחדים נפלו בין הקוצים, ואלה חנקו את הצמחים הרכים. ");
INSERT INTO heblb_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","אולם זרעים אחדים נפלו על אדמה טובה ופורייה, ונשאו פרי מבורך ורב פי שלושים, פי שישים ואפילו פי מאה. ");
INSERT INTO heblb_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","מי שמסוגל לשמוע, שיקשיב!“ ");
INSERT INTO heblb_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","תלמידיו של ישוע באו אליו ושאלו: ”מדוע אתה משתמש תמיד בדוגמאות קשות כל כך?“ ");
INSERT INTO heblb_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","הסביר להם ישוע: ”רק לכם מותר לדעת את סודות מלכות השמים; לאחרים לא ניתן לדעת אותם. ");
INSERT INTO heblb_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","כי מי שיש לו – יינתן לו עוד ויהיה לו שפע רב; ומי שאין – גם המעט שיש לו יילקח ממנו. ");
INSERT INTO heblb_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","אני מדבר אל בני אדם במשלים מכיוון שכאשר מראים להם משהו הם לא רואים, וכאשר אומרים להם משהו הם לא שומעים וגם לא מבינים. ");
INSERT INTO heblb_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","כך התקיימה נבואתו של ישעיהו: ’שמעו שמוע ואל תבינו, וראו ראו ואל תדעו. ");
INSERT INTO heblb_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","כי השמן לב העם הזה ואזניו הכבד ועיניו השע, פן יראה בעיניו ובאזניו ישמע, ולבבו יבין ושב ורפא לו‘. ");
INSERT INTO heblb_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","”אולם אשרי עיניכם כי הן רואות, ואשרי אוזניכם כי הן שומעות. ");
INSERT INTO heblb_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","הרבה נביאים וצדיקים השתוקקו לראות את מה שאתם רואים ולשמוע את מה שאתם שומעים, אך לא זכו. ");
INSERT INTO heblb_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","”זהו פירוש המשל: ");
INSERT INTO heblb_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","השביל הקשה שעליו נפלו חלק מהזרעים מסמל את לבו של האדם השומע את הבשורה, אך אינו מבין אותה; ואז בא השטן וחוטף את מה שנזרע בלבו. ");
INSERT INTO heblb_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","האדמה הסלעית מסמלת את לבו של האדם השומע את הבשורה ומקבל אותה בשמחה. ");
INSERT INTO heblb_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","אולם לאמונתו אין עומק, והזרעים אינם מכים שורשים עמוקים. משום כך, ברגע של קושי ומבחן נעלמת התלהבותו והוא נובל. ");
INSERT INTO heblb_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","האדמה המכוסה קוצים מסמלת את האדם ששמע את הבשורה, אולם דאגות החיים ורצונו להתעשר חונקים את דבר האלוהים, והוא הולך ומפחית בעבודת אלוהים. ");
INSERT INTO heblb_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","האדמה הטובה מסמלת את לבו של אדם המקשיב לבשורה, מבין אותה ומביא פרי רב, פי מאה, פי שישים ופי שלושים ממה שנזרע בלבם.“ ");
INSERT INTO heblb_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","ישוע סיפר להם משל נוסף: ”מלכות השמים דומה לאיכר שזרע בשדה שלו זרעים טובים. ");
INSERT INTO heblb_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","אולם לילה אחד, בזמן שהאיכר ישן, בא אויבו וזרע עשבי בר בין החיטה. ");
INSERT INTO heblb_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","כשהחלה החיטה לנבוט, נבטו גם עשבי הבר. ");
INSERT INTO heblb_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","”משרתיו של האיכר באו אליו ואמרו: ’אדוננו, השדה שבו זרעת זרעים משובחים מלא עשבים!‘ ");
INSERT INTO heblb_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","” ’אחד מאויבי עשה זאת‘, אמר האיכר. ” ’האם אתה רוצה שנעקור את העשבים השוטים?‘ שאלו המשרתים. ");
INSERT INTO heblb_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","” ’לא‘, השיב האיכר. ’אתם עלולים לעקור בטעות גם את החיטה. ");
INSERT INTO heblb_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","הניחו להם לגדול יחד עד הקציר, ואז אומר לקוצרים לאסוף תחילה את העשבים השוטים ולשרוף אותם, ולאחר מכן לאסוף את החיטה ולהכניסה לאסם‘. “ ");
INSERT INTO heblb_vpl VALUES ("MT13_31‏","070_13_31‏","MAT","13","31‏","32","ישוע סיפר להם עוד משל: ”מלכות השמים דומה לגרגר זעיר של צמח החרדל אשר נזרע בשדה. למרות שגרגר זה קטן ביותר, הוא גדל להיות אחד הצמחים הגדולים ביותר, והציפורים יכולות לבנות להן קן בין ענפיו.“ ");
INSERT INTO heblb_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","ישוע נתן להם דוגמה נוספת: ”אפשר להמשיל את מלכות השמים לאישה המתכוננת לאפות לחם. היא לוקחת את כמות הקמח הדרושה ושמה מעט שמרים, עד שהבצק כולו תופח.“ ");
INSERT INTO heblb_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","את כל אלה דיבר ישוע אל הקהל במשלים; ובלי משל לא דיבר אליהם. ");
INSERT INTO heblb_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","כך הוא קיים את הנבואה: ”אפתחה במשל פי, אביעה חידות מני־קדם“. ");
INSERT INTO heblb_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","לאחר מכן עזב ישוע את ההמון ונכנס הביתה. תלמידיו ביקשו ממנו שיסביר להם את משל העשבים בשדה החיטה. ");
INSERT INTO heblb_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","”בן־האדם הוא האיכר הזורע את הזרעים הטובים“, הסביר להם ישוע. ");
INSERT INTO heblb_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","”השדה מסמל את העולם, הזרעים מסמלים את בני מלכות האלוהים, והעשבים מסמלים את האנשים השייכים לשטן. ");
INSERT INTO heblb_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","האויב שזרע את עשבי־הבר בשדה החיטה הוא השטן, הקציר הוא סוף העולם והקוצרים הם המלאכים.“ ");
INSERT INTO heblb_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","”כשם שבמשל זה נאספו העשבים ונשרפו, כך יהיה גם בסוף העולם. ");
INSERT INTO heblb_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","בן־האדם ישלח את מלאכיו, והם ידרשו מתוך המלכות את כל עושי הרע ואת כל אלה שמכשילים את האחרים, ");
INSERT INTO heblb_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","וישליכו אותם לכבשן שישרוף אותם. שם הם יבכו ויחרקו שיניים ");
INSERT INTO heblb_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","ואילו הצדיקים יזרחו כשמש במלכות אביהם. מי שמסוגל לשמוע, שיקשיב! ");
INSERT INTO heblb_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","”מלכות השמים דומה לאוצר שאיש גילה בתוך שדה. בהתלהבותו הרבה מכר האיש את כל אשר היה לו, כדי שיוכל לקנות את השדה עם האוצר שמצא בו.“ ");
INSERT INTO heblb_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","”מלכות השמים דומה לפנינה נהדרת שמצא סוחר בעת שחיפש פנינים מובחרות. ");
INSERT INTO heblb_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","כשגילה הסוחר את הפנינה היקרה, שהייתה ממש ’מציאה‘, הלך ומכר את כל רכושו, כדי שיוכל לקנות אותה.“ ");
INSERT INTO heblb_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","”אפשר לתאר את מלכות השמים גם בסיפור על דייג שהשליך את רשתו לים, ונלכדו בה כל מיני דגים. ");
INSERT INTO heblb_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","כשנמלאה הרשת, הדייג הוציא אותה אל החוף והחל למיין את הדגים: את הטובים שם בסלים, ואת האחרים השליך. ");
INSERT INTO heblb_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","כך יהיה גם בסוף העולם: המלאכים יבואו ויפרידו בין הרשעים ובין הצדיקים. ");
INSERT INTO heblb_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","את הרשעים ישליכו המלאכים לאש – שם הם יבכו ויחרקו שיניים.“ ");
INSERT INTO heblb_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","”האם אתם מבינים?“ שאל אותם ישוע. ”כן,“ ענו התלמידים, ”אנחנו מבינים.“ ");
INSERT INTO heblb_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","וישוע הוסיף: ”תלמיד שלמד והבין את מלכות השמים דומה לאיש עשיר שמוציא מאוצרו דברים עתיקים וגם חדשים.“ ");
INSERT INTO heblb_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","כשסיים ישוע לספר להם את המשלים האלה, המשיך בדרכו. ");
INSERT INTO heblb_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","כשהגיע אל ביתו (בנצרת שבגליל) לימד את האנשים בבתי־הכנסת, והפליא את כולם בחכמתו ובניסים. ");
INSERT INTO heblb_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","”כיצד ייתכן הדבר?“ תמהו האנשים. ”הלא הוא בנו של הנגר, ואנחנו מכירים את מרים אמו ואת אחיו – יעקב, יוסף, שמעון ויהודה! ");
INSERT INTO heblb_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","גם את אחיותיו אנחנו מכירים – הרי כולן גרות כאן. כיצד הוא יכול להיות גדול כל כך?“ ");
INSERT INTO heblb_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","והם רגזו מאוד על ישוע. ”אין נביא בעירו!“ אמר להם ישוע. ”את הנביא מכבדים בכל מקום, מלבד בביתו ובקרב בני־עמו.“ ");
INSERT INTO heblb_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","ומאחר שלא האמינו בו הוא חולל שם נסים מעטים בלבד. ");
INSERT INTO heblb_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","כאשר שמע הורדוס (שר הרובע של המדינה) על ישוע, ");
INSERT INTO heblb_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","אמר לאנשיו: ”אין ספק שהאיש הזה הוא יוחנן המטביל! יוחנן קם לתחייה, ולכן הוא מסוגל לחולל את כל הנסים האלה.“ ");
INSERT INTO heblb_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","הורדוס אמר דברים אלה משום שזמן מה קודם לכן אסר את יוחנן וכבל אותו בכלא, על־פי דרישת אשתו הורודיה שהייתה בעבר אשת אחיו פיליפוס, ");
INSERT INTO heblb_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","משום שיוחנן אמר להורדוס שאסור לו להתחתן אתה. ");
INSERT INTO heblb_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","הורדוס רצה להרוג את יוחנן, אולם פחד ממהומות ומרידות, כי העם חשב את יוחנן לנביא. ");
INSERT INTO heblb_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","אולם במסיבת יום הולדתו של הורדוס רקדה לפניו בת הורודיה ריקוד שמצא־חן בעיניו מאוד, ");
INSERT INTO heblb_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","והוא הבטיח בשבועה לתת לה כל מה שתרצה. ");
INSERT INTO heblb_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","לפי דרישת אמה ביקשה הנערה שיביאו לפניה על מגש את ראשו של יוחנן המטביל. ");
INSERT INTO heblb_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","המלך הצטער, אולם לא רצה להפר את שבועתו, ולא רצה לאבד את יוקרתו בעיני אורחיו. משום כך נתן הורדוס את ההוראות הדרושות, ");
INSERT INTO heblb_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","וראשו של יוחנן נכרת בבית הסוהר ");
INSERT INTO heblb_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","והובא על מגש לבתה של הורודיה, אשר נתנה אותו לאמה. ");
INSERT INTO heblb_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","תלמידי יוחנן באו וביקשו את גופתו, ולאחר שקברו אותו הלכו לישוע וסיפרו לו מה שקרה. ");
INSERT INTO heblb_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","כששמע ישוע מה שקרה, הפליג לבדו בסירה למקום מבודד, אולם ההמונים גילו אותו, ולכן עזבו את כפריהם והלכו אחריו לאורך חוף הים. ");
INSERT INTO heblb_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","ישוע ירד מהסירה, וכשראה את האנשים הרבים שחיכו לו, ריחם עליהם וריפא את החולים שביניהם. ");
INSERT INTO heblb_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","לפנות ערב ניגשו אליו תלמידיו ואמרו: ”אמור לכל האנשים האלה שילכו לקנות אוכל בכפרים שבאזור, כי השעה מאוחרת ובמקום השומם הזה אין מה לאכול.“ ");
INSERT INTO heblb_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","אולם ישוע השיב להם: ”אין צורך. אתם תאכילו אותם.“ ");
INSERT INTO heblb_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","”מה?“ קראו התלמידים בתמיהה. ”יש לנו רק חמש ככרות לחם ושני דגים.“ ");
INSERT INTO heblb_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","”הביאו אותם לכאן“, הורה ישוע. ");
INSERT INTO heblb_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","הוא ציווה על האנשים לשבת על הדשא, לאחר מכן לקח את חמש ככרות הלחם ואת שני הדגים, הביט לשמים, ביקש מאלוהים שיברך את האוכל, פרס את הלחם ונתן לתלמידיו שיחלקו לעם. ");
INSERT INTO heblb_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","כולם אכלו עד ששבעו, וכשאספו לבסוף את הפירורים שנשארו, מילאו שנים־עשר סלים. ");
INSERT INTO heblb_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","באותו ערב היו שם כחמשת־אלפים גברים מלבד הנשים והילדים! ");
INSERT INTO heblb_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","לאחר מכן אמר ישוע לתלמידיו להיכנס לסירה ולחצות את הים, בעוד שהוא עצמו נשאר להיפרד מהקהל ולפזר אותם הביתה. ");
INSERT INTO heblb_vpl VALUES ("MT14_23‏","070_14_23‏","MAT","14","23‏","24","לאחר ששלח ישוע את האנשים עלה על גבעה להתפלל. עם רדת הלילה, כשהתלמידים היו בסירה וישוע היה לבדו על החוף, פרצה סערה עזה והתלמידים נאבקו נגד הרוח החזקה והגלים הגבוהים. ");
INSERT INTO heblb_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","בערך בשעה ארבע לפנות בוקר בא ישוע לקראתם, כשהוא פוסע על־פני המים. ");
INSERT INTO heblb_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","התלמידים המבוהלים צעקו מפחד, כי חשבו שהוא רוח רפאים. ");
INSERT INTO heblb_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","ישוע דיבר אליהם מיד והרגיע אותם: ”אל תפחדו, זה אני!“ ");
INSERT INTO heblb_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","”אדון, אם זה באמת אתה,“ קרא אליו שמעון פטרוס, ”צווה עלי ללכת לקראתך על־פני המים!“ ");
INSERT INTO heblb_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","”בסדר“, ענה ישוע. ”בוא!“ ופטרוס ירד מן הסירה והחל ללכת על־פני המים לקראת ישוע. ");
INSERT INTO heblb_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","אולם כשהביט פטרוס בגלים הגבוהים שסבבוהו נבהל והחל לטבוע. ”הצל אותי, אדון!“ צעק פטרוס. ");
INSERT INTO heblb_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","מיד הושיט ישוע את ידו וחילץ את פטרוס. ”חסר־אמונה אתה!“ הוכיח אותו ישוע. ”מדוע פקפקת?“ ");
INSERT INTO heblb_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","כשעלו ישוע ופטרוס לסירה פסקה הרוח. ");
INSERT INTO heblb_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","התלמידים האחרים ישבו שם המומים ונדהמים. ”אתה באמת בן האלוהים!“ קראו. ");
INSERT INTO heblb_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","הם המשיכו בדרכם ועגנו בחוף גניסרת. ");
INSERT INTO heblb_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","אנשי המקום הכירו אותו מיד, והפיצו את דבר בואו בכל האזור. תוך זמן קצר הובאו אליו חולים רבים כדי שירפא אותם. ");
INSERT INTO heblb_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","החולים ביקשו מישוע שירשה להם רק לגעת בכנף בגדו, וכל מי שנגע בו נרפא. ");
INSERT INTO heblb_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","יום אחד הגיעו מירושלים מספר פרושים וסופרים כדי לחקור את ישוע. ");
INSERT INTO heblb_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","”מדוע תלמידיך אינם מקיימים את המסורת היהודית העתיקה?“ דרשו לדעת. ”מדוע תלמידיך אינם נוטלים את ידיהם לפני האוכל?“ ");
INSERT INTO heblb_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","השיב להם ישוע: ”ומדוע עוברת המסורת שלכם על מצוותיו של אלוהים? ");
INSERT INTO heblb_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","למשל, כתוב בתורה: ’כבד את אביך ואת אמך… ומקלל אביו ואמו מות יומת!‘ ");
INSERT INTO heblb_vpl VALUES ("MT15_5‏","070_15_5‏","MAT","15","5‏","6","אולם אתם אומרים שמותר לאדם להתעלם מצרכי הוריו העניים, אם ייתן ’לעבודת האלוהים‘ את מה שיכול היה לתת להם. וכך אתם מפרים את מצוותו של אלוהים, כדי לקיים מסורת וחוקים שהומצאו על־ידי בני־אדם. ");
INSERT INTO heblb_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","צבועים שכמוכם! הנביא ישעיהו תיאר אתכם נכונה כשאמר: ");
INSERT INTO heblb_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","’ניגש העם הזה בפיו, ובשפתיו כבדוני ולבו רחק ממני; ");
INSERT INTO heblb_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","ותהי יראתם אותי מצות אנשים מלומדה‘. “ ");
INSERT INTO heblb_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","ישוע אסף סביבו את הקהל ואמר: ”הקשיבו לדבריי והשתדלו להבינם: ");
INSERT INTO heblb_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","מה שמטמא את האדם זה לא מה שנכנס לפה אלא מה שיוצא מהפה – זה מטמא את האדם!“ ");
INSERT INTO heblb_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","תלמידיו באו אליו ואמרו: ”בדבריך אלה העלבת את הפרושים!“ ");
INSERT INTO heblb_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","ישוע השיב להם: ”כל צמח שלא נשתל על־ידי אבי – ייעקר. ");
INSERT INTO heblb_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","התעלמו מהם; הפרושים אינם אלא מורי־דרך עיוורים המדריכים עיוורים אחרים, ובסופו של דבר יפלו כולם יחד לתוך בור!“ ");
INSERT INTO heblb_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","שמעון פטרוס ביקש מישוע שיסביר למה התכוון באמרו שאנשים מטמאים את עצמם ממה שיוצא מן הפה. ");
INSERT INTO heblb_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","”האם אינך מבין?“ שאל אותו ישוע. ");
INSERT INTO heblb_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","”האם אינך רואה שכל מה שאתה אוכל עובר דרך מערכת העיכול ויוצא שוב החוצה? ");
INSERT INTO heblb_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","אולם מילים רעות יוצאות מתוך לב רע ומטמאות את האומר אותן. ");
INSERT INTO heblb_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","כי מתוך הלב יוצאות מחשבות רעות, מעשי רצח, ניאוף, זנות, גניבה, שקר ורכילות. ");
INSERT INTO heblb_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","דברים אלה הם המטמאים את האדם. אכילה ללא נטילת ידיים אינה מטמאת את האדם.“ ");
INSERT INTO heblb_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","ישוע עזב את האזור ההוא והלך אל אזור צור וצידון. ");
INSERT INTO heblb_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","אישה כנענית שגרה שם באה אל ישוע והתחננה: ”אדוני, בן־דוד, רחם עלי! שד אחז בבתי והוא מענה אותה ללא הרף.“ ");
INSERT INTO heblb_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","אולם ישוע לא ענה לה – אף לא מילה אחת. תלמידיו ביקשו ממנו לגרש אותה: ”אמור לה ללכת מכאן, כי היא מציקה לנו כל היום בתחינותיה.“ ");
INSERT INTO heblb_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","”נשלחתי אל צאן האובדות של בית ישראל בלבד“, אמר ישוע לאישה. ");
INSERT INTO heblb_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","אולם האישה נפלה לרגליו ושוב ביקשה: ”אדוני, עזור לי!“ ");
INSERT INTO heblb_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","”אין זה צודק לקחת את לחמם של הילדים ולהשליכו לכלבים“, ענה לה ישוע. ");
INSERT INTO heblb_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","”נכון, אדוני,“ השיבה האישה, ”אבל גם לגורי הכלבים מותר לאכול את הפירורים שנופלים מעל שולחן אדוניהם.“ ");
INSERT INTO heblb_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","”אישה,“ אמר לה ישוע, ”יש בך אמונה רבה, ולכן תתמלא בקשתך.“ באותו רגע בתה נרפאה. ");
INSERT INTO heblb_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","ישוע חזר לכינרת, עלה על גבעה והתיישב שם. ");
INSERT INTO heblb_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","ההמונים הביאו אליו פיסחים, עיוורים, בעלי־מום, אילמים וחולים אחרים, הניחו אותם לפניו, והוא ריפא את כולם. ");
INSERT INTO heblb_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","כאשר העם ראה את האילמים מפטפטים בהתרגשות, קטועי האיברים מקבלים איברים חדשים, נכים קופצים ורוקדים והעיוורים מביטים סביבם, נדהמו ושבחו את אלוהי ישראל. ");
INSERT INTO heblb_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","לאחר מכן קרא ישוע לתלמידיו ואמר: ”אני מרחם על אנשים אלה; הם נמצאים אתי כאן שלושה ימים, ולא נשאר להם מה לאכול. אינני רוצה לשלוח אותם רעבים, כי הם עלולים להתעלף בדרך.“ ");
INSERT INTO heblb_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","”מאין נשיג במדבר הזה מספיק אוכל לכל ההמון?“ שאלו התלמידים. ");
INSERT INTO heblb_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","”כמה ככרות לחם יש לכם?“ שאל אותם ישוע. ”שבע,“ ענו, ”וכמה דגים קטנים.“ ");
INSERT INTO heblb_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","ישוע ציווה על העם לשבת על הארץ, ");
INSERT INTO heblb_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","לקח את שבע ככרות הלחם ואת הדגים, הודה לאלוהים עליהם, חילק אותם למנות ונתן לתלמידים, כדי שיגישו ליושבים. ");
INSERT INTO heblb_vpl VALUES ("MT15_37‏","070_15_37‏","MAT","15","37‏","38","אכלו לשובע (כארבעת־אלפים איש לא כולל נשים וילדים), כאשר אספו את השאריות הם מילאו שבעה סלים! ");
INSERT INTO heblb_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","לאחר מכן שלח ישוע את האנשים לביתם, והוא עצמו עלה לסירה ושט למגדל. ");
INSERT INTO heblb_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","יום אחד באו פרושים וצדוקים אל ישוע כדי לנסות אותו, וביקשו ממנו שיחולל למענם נס מהשמים. ");
INSERT INTO heblb_vpl VALUES ("MT16_2‏","070_16_2‏","MAT","16","2‏","3","אולם ישוע ענה להם: ”אתם יודעים היטב כיצד לפרש את סימני הטבע! אם, למשל, לפנות ערב השמים אדומים, אתם אומרים שלמחרת יהיה מזג אוויר נאה. ואם בבוקר השמים קודרים, אתם אומרים שמזג האוויר יהיה סוער, ואתם צודקים. אולם אינכם מבינים את משמעות העת שבה אנו חיים! ");
INSERT INTO heblb_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","דור רע וכופר זה מבקש לו אות כלשהו מהשמים, אבל האות היחיד שינתן לו הוא זה של יונה הנביא!“ וישוע הלך משם. ");
INSERT INTO heblb_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","בהגיעם אל הגדה השנייה של הכינרת גילו התלמידים כי שכחו לקחת איתם אוכל. ");
INSERT INTO heblb_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","”היזהרו מהשאור של הפרושים והצדוקים!“ הזהיר ישוע את תלמידיו. ");
INSERT INTO heblb_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","הם חשבו שהוא אמר זאת משום ששכחו לקחת איתם לחם. ");
INSERT INTO heblb_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","ישוע ידע את מחשבותיהם, ולכן אמר: ”חסרי־אמונה שכמוכם! מדוע אתם דואגים כל כך שאין לכם לחם? ");
INSERT INTO heblb_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","האם לעולם לא תבינו? האם אינכם זוכרים כלל את חמשת־אלפים האנשים שהאכלתי בחמש ככרות לחם, ואת הסלים המלאים בשאריות? ");
INSERT INTO heblb_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","האם שכחתם את ארבעת־אלפים האנשים שהאכלתי, ואת סלי השאריות שנשארו? ");
INSERT INTO heblb_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","כיצד יכולתם להעלות על דעתכם שדיברתי על מזון? אולם אני חוזר ואומר: היזהרו מהשאור של הפרושים והצדוקים!“ ");
INSERT INTO heblb_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","לבסוף הבינו התלמידים שבמילה ”שאור“ התכוון ישוע ללימודים של הפרושים והצדוקים. ");
INSERT INTO heblb_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","כשהגיע ישוע לקיסריה של פיליפוס, שאל את תלמידיו: ”מה אומרים עלי האנשים? מי הם חושבים שאני?“ ");
INSERT INTO heblb_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","”יש האומרים שאתה יוחנן המטביל, אחרים – שאתה אליהו, ואחדים אומרים שאתה ירמיהו או נביא אחר.“ ");
INSERT INTO heblb_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","”ומי אתם חושבים שאני?“ המשיך ישוע לשאול. ");
INSERT INTO heblb_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","”אתה המשיח בן אלוהים חיים!“ השיב שמעון פטרוס. ");
INSERT INTO heblb_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","”אשריך, שמעון בן־יונה,“ אמר לו ישוע, ”כי אבי שבשמים הוא זה שגילה לך את האמת הזאת, ולא בן אדם. ");
INSERT INTO heblb_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","כשמך כן אתה: פטרוס – סלע; על סלע זה אבנה את קהילתי, וכל כוחות שאול לא יגברו עליה. ");
INSERT INTO heblb_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","אני אתן לך את מפתחות מלכות השמים; כל מה שתסגור בארץ יהיה סגור בשמים, וכל מה שתפתח עלי אדמות יהיה פתוח בשמיים!“ ");
INSERT INTO heblb_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","לאחר מכן הזהיר ישוע את תלמידיו שלא יספרו לאיש כי הוא המשיח. ");
INSERT INTO heblb_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","מאותה עת ואילך החל ישוע לספר לתלמידיו שהוא עומד לעלות לירושלים, שיסבול שם מידי זקני העם והכוהנים הגדולים והסופרים, שייהרג, ושלאחר שלושה ימים יקום לתחייה מן המתים. ");
INSERT INTO heblb_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","פטרוס לקח את ישוע הצידה והוכיח אותו: ”אל תדבר כך! אסור שיקרה לך דבר כזה!“ ");
INSERT INTO heblb_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","”סור ממני, שטן שכמוך!“ אמר לו ישוע. ”אתה מכשול בדרכי; אתה מסתכל על הדברים מנקודת ראות אנושית, ולא מנקודת ראותו של אלוהים.“ ");
INSERT INTO heblb_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","ישוע פנה לתלמידיו ואמר: ”מי שרוצה ללכת בעקבותיי עליו להתכחש לעצמו, לשאת את צלבו וללכת אחרי. ");
INSERT INTO heblb_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","כי מי שמנסה להציל את חייו – יאבד אותם, ואילו מי שיוותר על חייו למעני – ימצא אותם. ");
INSERT INTO heblb_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","שהרי מה התועלת לאדם המרוויח את העולם כולו, אולם מפסיד חיי־נצח? האם יש משהו שאפשר להשוות לחיי נצח? ");
INSERT INTO heblb_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","”בן־האדם ישוב עם מלאכיו בתפארת אביו, וישפוט כל אדם לפי מעשיו. ");
INSERT INTO heblb_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","ואני אומר לכם שאחדים מכם, העומדים כאן עכשיו, לא ימותו לפני שיזכו לראות את בן־האדם בא במלכותו!“ ");
INSERT INTO heblb_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","כעבור שישה ימים לקח ישוע את פטרוס, את יעקב ואת אחיו יוחנן, ועלה איתם על פסגת הר גבוה. ");
INSERT INTO heblb_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","כשהביטו התלמידים בישוע, הוא השתנה לנגד עיניהם: פניו זרחו כשמש ובגדיו הלבינו והבריקו. ");
INSERT INTO heblb_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","לפתע הופיעו משה רבנו ואליהו הנביא ודיברו עם ישוע. ");
INSERT INTO heblb_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","”אדון, כמה טוב שאנחנו כאן!“ קרא פטרוס. ”אם אתה רוצה, אבנה כאן שלוש סוכות לכבוד – לך, למשה ולאליהו!“ ");
INSERT INTO heblb_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","בזמן שפטרוס דיבר, ענן כיסה את השלושה ויצא משם קול שאמר: ”זהו בני אהובי, שבו חפצתי. שמעו בקולו!“ ");
INSERT INTO heblb_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","כששמעו התלמידים את הקול, נפלו על־פניהם מבוהלים ונפחדים. ");
INSERT INTO heblb_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","ישוע ניגש אליהם ונגע בהם. ”קומו,“ אמר, ”אל תפחדו!“ ");
INSERT INTO heblb_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","כשהביטו התלמידים סביבם, ראו שישוע לבדו איתם. ");
INSERT INTO heblb_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","כאשר ירדו מההר ישוע ציווה עליהם שלא יספרו לאיש את מה שראו, עד לאחר שיקום מן המתים. ");
INSERT INTO heblb_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","”מדוע הסופרים אומרים שאליהו הנביא צריך לבוא תחילה (לפני המשיח)?“ שאלו התלמידים את ישוע. ");
INSERT INTO heblb_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","”הם צודקים“, ענה ישוע. ”אליהו באמת יבוא קודם וישליט סדר בכל. ");
INSERT INTO heblb_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","למעשה אליהו כבר בא, אולם אנשים רבים לא הכירו אותו ואף פגעו בו. גם בן־האדם יסבול מידיהם.“ ");
INSERT INTO heblb_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","אז הבינו התלמידים שישוע דיבר על יוחנן המטביל. ");
INSERT INTO heblb_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","כשהגיעו למרגלות ההר כבר ציפו להם אנשים רבים. איש אחד התקרב אל ישוע, כרע ברך לפניו והתחנן: ");
INSERT INTO heblb_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","”אדוני, רחם נא על בני. הוא חולה במחלת אפילפסיה וסובל מאוד. לעתים קרובות הוא נופל לתוך אש או מים. ");
INSERT INTO heblb_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","הבאתי את בני אל תלמידיך, אבל הם לא יכלו לרפא אותו.“ ");
INSERT INTO heblb_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","”מה עיקש וחסר־אמונה הדור הזה!“ קרא ישוע. ”עד מתי יהיה עלי לסבול אתכם? הביאו אלי את הילד!“ ");
INSERT INTO heblb_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","ישוע גער בשד שהיה בתוך הילד, והשד יצא ממנו. באותו רגע הילד נרפא. ");
INSERT INTO heblb_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","לאחר מכן, כשהתלמידים היו לבד עם ישוע, שאלו אותו: ”מדוע אנחנו לא יכולנו לגרש את השד?“ ");
INSERT INTO heblb_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","”בגלל חוסר אמונתכם“, השיב ישוע. ”אילו הייתה לכם אמונה אפילו כגרגר של חרדל, יכולתם לומר להר הזה: ’זוז!‘ והוא באמת היה זז, מכיוון שתוכלו לעשות כל דבר. ");
INSERT INTO heblb_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","אבל שד כזה יוצא רק לאחר צום ותפילה.“ ");
INSERT INTO heblb_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","יום אחד כשהיו בגליל אמר ישוע לתלמידיו: ”בן־האדם עומד להימסר לידי אנשים, ");
INSERT INTO heblb_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","והם יהרגו אותו; אולם לאחר שלושה ימים יקום לתחייה.“ דבריו אלה ציערו את התלמידים ואף הפחידו אותם. ");
INSERT INTO heblb_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","בבואם אל כפר־נחום ניגשו אל פטרוס גובי מס מחצית השקל של המקדש ושאלו אותו: ”האם אין הרב שלך משלם את המס?“ ");
INSERT INTO heblb_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","”ודאי שהוא משלם“, השיב פטרוס. לאחר מכן נכנס פטרוס אל הבית כדי לשוחח על כך עם ישוע, אולם עוד לפני שהספיק לפתוח את פיו שאל אותו ישוע: ”מה דעתך, פטרוס? ממי דורשים המלכים מס, מבני העם שלהם או מזרים?“ ");
INSERT INTO heblb_vpl VALUES ("MT17_26‏","070_17_26‏","MAT","17","26‏","27","”מהזרים, כמובן“, השיב פטרוס. ”אם כן, הבנים פטורים מכך.“ אמר ישוע. ”אולם היות שאיננו רוצים לפגוע באנשים האלה, לך אל הים והשלך חכה למים. פתח את פיו של הדג הראשון שתצוד, ותמצא בו מטבע. במטבע זה שלם את המס עבור שנינו.“ ");
INSERT INTO heblb_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","באותה שעה באו התלמידים אל ישוע ושאלו: ”מי מאיתנו יהיה הגדול ביותר במלכות השמים?“ ");
INSERT INTO heblb_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","ישוע קרא אליו ילד קטן והציג אותו לפניהם. ");
INSERT INTO heblb_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","לאחר מכן אמר: ”אם לא תחזרו בתשובה ותהיו כמו ילדים, לא תיכנסו למלכות השמים. ");
INSERT INTO heblb_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","לכן מי שיהיה עניו כמו הילד הזה, הוא הגדול ביותר במלכות השמים. ");
INSERT INTO heblb_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","וכל מי שמקבל ילד כזה בשמי, מקבל למעשה אותי. ");
INSERT INTO heblb_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","אבל אוי למי שיגרום לילד המאמין בי לאבד את אמונתו! לאדם כזה מוטב שיקשרו אבן כבדה לצווארו ויטביעו אותו בים! ");
INSERT INTO heblb_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","”אוי לעולם על כל הרוע שבו! הפיתוי לעשות את הרע הוא בלתי נמנע, אולם אוי לאדם שיגרום לפיתוי! ");
INSERT INTO heblb_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","לכן אם ידך או רגלך גורמת לך לחטוא, כרות אותה והשלך אותה ממך והלאה! מוטב שתיכנס למלכות השמים בעל מום, מאשר שתהיה באש עולם עם שתי ידיך או שתי רגליך. ");
INSERT INTO heblb_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","ואם עינך גורמת לך לחטוא, עקור אותה והשלך אותה. מוטב שתיכנס למלכות השמים עם עין אחת, מאשר שתהיה בגיהינום עם שתי עיניים ותראה את אש העולם! ");
INSERT INTO heblb_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","”אני מזהיר אתכם שלא לבוז לאחד מן הילדים האלה, כי אני אומר לכם שהמלאכים שלהם יכולים תמיד לגשת אל אבי. ");
INSERT INTO heblb_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","ואני, בן־האדם, באתי להושיע את האובדים. ");
INSERT INTO heblb_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","”אם יש לאדם מאה כבשים, ואחת מהן הולכת לאיבוד – מה יעשה אותו אדם? האם לא יעזוב את תשעים ותשע הכבשים לבדן, ויחזור אל ההרים כדי לחפש את האובדת? ");
INSERT INTO heblb_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","כשימצא אותה, האם לא ישמח על הכבשה שנמצאה יותר מאשר על התשעים ותשע שלא אבדו? ");
INSERT INTO heblb_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","כך גם אבי אינו רוצה שאף אחד מהקטנים האלה יאבד! ");
INSERT INTO heblb_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","”אם אחיך חטא לך, הוכח אותו לבד. אם הוא מקשיב לך ומודה באשמתו – רכשת לך אח. ");
INSERT INTO heblb_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","אם לא יקשיב, קח איתך עוד אח או שניים, וחיזרו אליו כששני העדים מאשרים את טענותיך. ");
INSERT INTO heblb_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","אם עדיין יסרב להקשיב, הבא את הבעיה לפני הקהילה. אם הקהילה תפסוק לטובתך, והוא בכל זאת יעמוד על דעתו ולא ייכנע, היא רשאית לגרשו משורותיה ולהחרים אותו. ");
INSERT INTO heblb_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","ואני אומר לכם: כל מה שתאסרו על הארץ יהיה אסור בשמים, וכל מה שתתירו על הארץ יהיה מותר בשמים. ");
INSERT INTO heblb_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","”אומר לכם עוד דבר: אם שניים מכם מסכימים ביניכם לבקש דבר מה, אבי שבשמים ייתן לכם את אשר תבקשו. ");
INSERT INTO heblb_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","כי בכל מקום שבו נפגשים שניים או שלושה אנשים המאמינים בי, אני שם בתוכם.“ ");
INSERT INTO heblb_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","לאחר מכן בא פטרוס אל ישוע ושאל: ”אדוני, כמה פעמים עלי לסלוח לאדם שחטא לי? שבע פעמים?“ ");
INSERT INTO heblb_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","”לא“, ענה ישוע, ”שבעים כפול שבע פעמים!“ ");
INSERT INTO heblb_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","”אפשר להמשיל את מלכות השמים למלך שהחליט לעדכן את ספרי החשבונות שלו. ");
INSERT INTO heblb_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","במהלך יישוב החשבונות הובא לפניו אדם שהיה חייב לו עשרת אלפים ככרי כסף. ");
INSERT INTO heblb_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","מכיוון שלא היה לאיש כסף לשלם, ציווה המלך למכור אותו, את אשתו, את ילדיו ואת כל רכושו תמורת החוב.“ ");
INSERT INTO heblb_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","”אולם האיש נפל לרגלי המלך, בכה והתחנן: ’אנא, אדוני, תן לי חסד ואשלם לך את כל החוב!‘ ");
INSERT INTO heblb_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","”המלך ריחם על האיש, שיחרר אותו וויתר לו על החוב. ");
INSERT INTO heblb_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","”אולם כשיצא האיש מלפני המלך, הלך אל אדם שהיה חייב לו אלף שקלים, תפס אותו ודרש ממנו לשלם מיד את חובו. ");
INSERT INTO heblb_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","החייב נפל על ברכיו והתחנן: ’אנא, עשה עמי חסד; חכה בסבלנות ואשלם לך הכל!‘ ");
INSERT INTO heblb_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","”אולם המלווה לא הסכים לחכות, וציווה לכלוא את החייב בבית־הסוהר עד שיגמור לשלם את חובו. ");
INSERT INTO heblb_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","”כשראו חבריו העבדים את הנעשה התעצבו מאוד והלכו אל המלך וסיפרו לו מה שקרה. ");
INSERT INTO heblb_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","המלך קרא אליו את האדם שעל חובו ויתר, ואמר: ’נבזה מרושע שכמוך! אני ויתרתי לך על חוב עצום רק משום שביקשת זאת ממני! ");
INSERT INTO heblb_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","האם לא היה עליך לרחם על חברך העבד, כשם שאני ריחמתי עליך?‘ ");
INSERT INTO heblb_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","”המלך הנרגז שלח את האיש לתא העינויים, עד שיגמור לשלם את חובו עד הפרוטה האחרונה. ");
INSERT INTO heblb_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","כך יעשה לכם אבי שבשמים אם תסרבו לסלוח לאחיכם בכל לבכם.“ ");
INSERT INTO heblb_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","כשסיים ישוע את דבריו, עזב את הגליל וחזר ליהודה דרך עבר הירדן. ");
INSERT INTO heblb_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","קהל גדול הלך בעקבותיו, והוא ריפא את החולים שביניהם. ");
INSERT INTO heblb_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","פרושים אחדים שבאו לנסותו שאלו: ”האם מותר לאיש להתגרש מאשתו על כל דבר?“ ");
INSERT INTO heblb_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","ישוע הגיב: ”האם אינכם קוראים את כתבי־הקודש? הלא כתוב שאלוהים ברא איש ואישה מבראשית, ");
INSERT INTO heblb_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ושעל האיש לעזוב את אביו ואמו, ולהתאחד עם אשתו. ");
INSERT INTO heblb_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","לפיכך הם כבר לא שניים אלא אחד! וכך אסור לאיש להפריד את מה שאלוהים איחד.“ ");
INSERT INTO heblb_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","”אם כך,“ המשיכו הפרושים, ”מדוע משה אמר שאיש יכול לכתוב לה ספר כריתות (מכתב גירושין), וזה כל מה שנדרש ממנו?“ ");
INSERT INTO heblb_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","ישוע הסביר: ”משה הרשה לכם להתגרש מנשותיכם רק משום שלקח בחשבון את האופי העקשני שלכם. אולם לא זאת הייתה כוונתו המקורית של אלוהים. ");
INSERT INTO heblb_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","אני אומר לכם: כל איש המגרש את אשתו, מלבד במקרה שבגדה בו, ונושא אחרת לאישה – הוא נואף!“ ");
INSERT INTO heblb_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","”אם כך הדבר,“ אמרו תלמידיו של ישוע, ”הרי מוטב לא להינשא כלל!“ ");
INSERT INTO heblb_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","”לא כל אחד יכול לקבל עמדה זאת“, אמר ישוע. ”רק אלה שה׳ עוזר להם בכך יכולים לקבל אותה. ");
INSERT INTO heblb_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","אחדים נולדים סריסים ואינם יכולים להינשא, אחרים מסורסים על־ידי אדם, ויש המסרבים להינשא למען מלכות השמים. מי שיכול – שיקבל זאת על עצמו.“ ");
INSERT INTO heblb_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","ילדים קטנים הובאו אל ישוע כדי שיניח את ידיו עליהם ויתפלל. אולם התלמידים גערו באמהות שהביאו את הילדים: ”אל תטרידו אותו!“ ");
INSERT INTO heblb_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","ישוע שמע ואמר: ”תנו לילדים לבוא אלי ואל תמנעו מהם, כי לכאלה שייכת מלכות השמים!“ ");
INSERT INTO heblb_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","לפני שהלך משם הוא הניח את ידיו על ראשי הילדים וברך אותם. ");
INSERT INTO heblb_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","יום אחד בא איש אל ישוע ושאל: ”רבי, אילו דברים טובים עלי לעשות כדי לזכות בחיי נצח?“ ");
INSERT INTO heblb_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","”מדוע אתה שואל אותי בנוגע לטוב? רק אלוהים טוב באמת!“ השיב לו ישוע. ”אולם בתשובה לשאלתך: אם תשמור את המצוות תזכה בחיי נצח.“ ");
INSERT INTO heblb_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","”איזה?“ שאל האיש. ”לא תרצח, לא תנאף, לא תגנוב, לא תענה עד שקר, ");
INSERT INTO heblb_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","כבד את אביך ואת אמך, ואהבת לרעך כמוך!“ השיב ישוע. ");
INSERT INTO heblb_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","”תמיד שמרתי את כל המצוות האלה. מה עוד עלי לעשות?“ ");
INSERT INTO heblb_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","”אם ברצונך להיות שלם,“ ענה ישוע, ”מכור את כל רכושך וחלק את הכסף לעניים, כדי שאוצרך יהיה בשמים, ולאחר מכן לך אחרי.“ ");
INSERT INTO heblb_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","לשמע דברים אלה התעצב האיש והלך לדרכו, כי היה עשיר מאוד. ");
INSERT INTO heblb_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","ישוע פנה לתלמידיו ואמר: ”לאדם עשיר קשה מאוד להיכנס למלכות השמים. ");
INSERT INTO heblb_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","דעו לכם שקל יותר לגמל לעבור דרך חור המחט, מאשר לאיש עשיר להיכנס למלכות האלוהים.“ ");
INSERT INTO heblb_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","הערה זאת הביכה את התלמידים. ”מי, אם כן, יוכל להיוושע?“ שאלו. ");
INSERT INTO heblb_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","ישוע הביט בהם ואמר: ”למעשה, אף אחד, אולם עם אלוהים הכול אפשרי!“ ");
INSERT INTO heblb_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","”אנחנו עזבנו הכול כדי ללכת אחריך“, אמר פטרוס. ”מה נקבל בתמורה?“ ");
INSERT INTO heblb_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","”כשבן־האדם יישב במלכות על כסא כבודו המפואר,“ השיב ישוע, ”אתם, תלמידי, תשבו על שנים־עשר כסאות ותשפטו את שנים־עשר שבטי ישראל. ");
INSERT INTO heblb_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","כל מי שוויתר למעני על ביתו, אחיו, אחיותיו, אביו, אמו, אשתו, ילדיו או רכושו – יקבל בתמורה פי מאה ויזכה בחיי נצח. ");
INSERT INTO heblb_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","אולם רבים מאלה שהם ראשונים עתה יהיו אז אחרונים, ואחדים מהאחרונים עתה יהיו אז ראשונים.“ ");
INSERT INTO heblb_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","”מלכות השמים דומה לאיכר שיצא השכם בבוקר לשכור פועלים לעבוד בכרמו“, המשיך ישוע. ");
INSERT INTO heblb_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","האיכר הבטיח לפועלים 100 שקלים תמורת יום עבודה, ושלח אותם אל הכרם. ");
INSERT INTO heblb_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","”כעבור שעתיים עבר האיכר ליד כיכר השוק וראה כמה אנשים ממתינים לעבודה. ");
INSERT INTO heblb_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","הוא שלח גם אותם אל הכרם, והבטיח לשלם להם שכר צודק בסוף היום. ");
INSERT INTO heblb_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","”בצהריים, וכן גם בשעה שלוש אחר־הצהריים, שלח האיכר פועלים נוספים אל הכרם. ");
INSERT INTO heblb_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","”בשעה חמש לפנות ערב שוב יצא העירה וראה גברים אחדים מסתובבים בחוסר מעש. ’מדוע התבטלתם כל היום?‘ שאל אותם. ");
INSERT INTO heblb_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","’משום שאיש לא שכר אותנו‘, השיבו. ” ’לכו גם אתם אל כרמי והצטרפו אל הפועלים האחרים‘, אמר להם האיכר. ");
INSERT INTO heblb_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","בערב ביקש האיכר ממנהל העבודה לשלם לפועלים את שכרם, החל באחרונים וכלה בראשונים. ");
INSERT INTO heblb_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","כל אחד מהפועלים שנשכרו בשעה חמש קיבל 100 שקלים. ");
INSERT INTO heblb_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","בהגיע תורם של הפועלים שנשכרו מוקדם יותר הם ציפו לקבל הרבה יותר, אולם גם הם קיבלו 100 שקלים כל אחד. ");
INSERT INTO heblb_vpl VALUES ("MT20_11‏","070_20_11‏","MAT","20","11‏","12","”הפועלים הראשונים כעסו: ’האנשים האלה עבדו שעה אחת בלבד, ואתה שילמת להם אותו שכר ששילמת לנו, למרות שאנחנו עבדנו כל היום בשמש הלוהטת!‘ ");
INSERT INTO heblb_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","” ’ידידי‘, ענה האיכר לאחד מהם, ’לא גרמתי לך שום עוול! האם לא הסכמנו מראש שתעבוד כל היום תמורת 100 שקלים? ");
INSERT INTO heblb_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","קח את הכסף ולך לשלום. ברצוני לשלם שכר שווה לכולם; ");
INSERT INTO heblb_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","האם לא מותר לי לעשות מה שאני רוצה עם הכסף שלי? האם אסור לי לתת את כספי למי שארצה? האם עליך להתרגז על טוב לבי?‘ ");
INSERT INTO heblb_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","כך האחרונים יהיו ראשונים, והראשונים – אחרונים.“ ");
INSERT INTO heblb_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","כשהיה ישוע בדרכו לירושלים, הוא אסף סביבו את שנים־עשר תלמידיו ");
INSERT INTO heblb_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","ודיבר איתם על הצפוי לו בירושלים: ”מישהו יסגיר אותי לידי ראשי הכוהנים ולסופרים. הם ידונו אותי למוות ");
INSERT INTO heblb_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","וימסרו אותי לידי הרומאים, אשר ילעגו לי ויצלבו אותי. אולם ביום השלישי אקום לתחייה.“ ");
INSERT INTO heblb_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","לאחר מכן הביאה אמם של יעקב ויוחנן בני זבדי את בניה לפני ישוע וביקשה טובה. ");
INSERT INTO heblb_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","”מה בקשתך?“ שאל ישוע. ”הבטח לי שבמלכותך ישבו שני בני אחד לימינך ואחד לשמאלך“, ביקשה האם. ");
INSERT INTO heblb_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","אולם ישוע אמר לה: ”את לא יודעת מה את מבקשת!“ הוא פנה אל יעקב ויוחנן ושאל אותם: ”האם תוכלו לשתות מהכוס שאני חייב לשתות?“ ”כן, בהחלט“, השיבו. ");
INSERT INTO heblb_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","”אתם באמת תשתו ממנה,“ אמר להם ישוע, ”ובכל זאת אין לי את הזכות לומר מי יישב לימיני ולשמאלי. מקומות אלה שמורים לאנשים שאבי בוחר בהם.“ ");
INSERT INTO heblb_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","כששמעו שאר התלמידים מה שביקשו יעקב ויוחנן, הם כעסו עליהם מאוד. ");
INSERT INTO heblb_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","לכן ישוע קיבץ סביבו את התלמידים ואמר: ”אתם הרי יודעים שמנהיגי הגויים רודים בנתיניהם, ומעניקים כוח וסמכות למי שהם רוצים. ");
INSERT INTO heblb_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","אבל אצלכם יהא המצב שונה; מי שרוצה להיות מנהיג ביניכם חייב להיות לכם למשרת, ");
INSERT INTO heblb_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ומי שרוצה לעמוד בראש חייב לשרת אתכם כעבד. ");
INSERT INTO heblb_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","עליכם לנהוג כמוני, כי אני, בן־האדם, לא באתי לכאן כדי שישרתו אותי, אלא כדי לשרת אחרים ולתת את חיי כופר בעד רבים.“ ");
INSERT INTO heblb_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","כשיצאו ישוע ותלמידיו מיריחו הלך אחריהם קהל גדול. ");
INSERT INTO heblb_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","שני עיוורים שישבו בצד הדרך שמעו כי ישוע עומד לעבור בדרך ההיא, ולכן החלו לצעוק: ”אדוננו, בן־דוד, אנא, רחם עלינו!“ ");
INSERT INTO heblb_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","ההמון גער בהם, אך העיוורים הגבירו את צעקותיהם: ”אדוננו, בן־דוד, אנא, רחם עלינו!“ ");
INSERT INTO heblb_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","כשהגיע ישוע למקום שבו ישבו העיוורים, עצר לרגע ושאל אותם: ”מה אתם רוצים שאעשה למענכם?“ ");
INSERT INTO heblb_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","”אדוננו, אנחנו רוצים לראות“, התחננו העיוורים. ");
INSERT INTO heblb_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","ישוע נמלא רחמים ונגע בעיניהם. מיד יכלו השניים לראות, והלכו אחרי ישוע. ");
INSERT INTO heblb_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","כשהתקרבו ישוע ותלמידיו לירושלים ועברו ליד בית־פגי, שעל הר הזיתים, שלח ישוע שניים מתלמידיו אל הכפר ואמר: ");
INSERT INTO heblb_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","”כשתיכנסו אל הכפר תראו אתון קשורה ולידה עיר. התירו אותם והביאו אלי. ");
INSERT INTO heblb_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","אם מישהו ישאל אתכם מה אתם עושים, אמרו פשוט: ’האדון זקוק להם‘. והוא יניח לכם מיד.“ ");
INSERT INTO heblb_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","דבר זה בא לקיים את הנבואה: ");
INSERT INTO heblb_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","”אמרו לבת ציון, הנה מלכך יבוא לך, עני ורוכב על חמור ועל עַיִר בן־אתנות.“ ");
INSERT INTO heblb_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","שני התלמידים הלכו אל הכפר ועשו כדברי ישוע. ");
INSERT INTO heblb_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","הם הביאו אליו את העיר ואת האתון, ריפדו את גבם במעיליהם והושיבו עליהם את ישוע. ");
INSERT INTO heblb_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","רבים מההמון השליכו את מעיליהם על הדרך לפני ישוע, ואחרים כרתו ענפים מהעצים ושטחו אותם לפניו. ");
INSERT INTO heblb_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","ההמונים החלו להידחק מלפניו ומאחוריו וקראו: ”הושע־נא לבן־דוד!“ ”ברוך הבא בשם ה׳!“ ”הושע־נא במרומים!“ ");
INSERT INTO heblb_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","כשנכנס ישוע לתוך ירושלים, העיר כולה התרגשה מאוד. ”מי האיש הזה?“ שאלו האנשים. ");
INSERT INTO heblb_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","וההמון השיב: ”זהו ישוע – הנביא מנצרת שבגליל!“ ");
INSERT INTO heblb_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","ישוע הלך לבית־המקדש, גירש את כל הסוחרים והקונים, הפך את השולחנות של מחליפי הכספים ואת הדוכנים של סוחרי היונים. ");
INSERT INTO heblb_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","”בכתבי־הקודש כתוב: ’ביתי בית־תפלה ייקרא‘, “ קרא ישוע, ”ואילו אתם הפכתם אותו למאורת גנבים!“ ");
INSERT INTO heblb_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","העיוורים ובעלי המום שהיו בבית־המקדש ניגשו אליו, והוא ריפא אותם שם. ");
INSERT INTO heblb_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","אולם כשראו ראשי הכוהנים והסופרים את הניסים והנפלאות שחולל ישוע, וכששמעו את הילדים הקטנים קוראים במקדש: ”הושע־נא לבן־דוד!“ הם התרגזו מאוד ושאלו אותו: ");
INSERT INTO heblb_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","”האם אתה שומע את מה שהילדים האלה אומרים?“ ”כן“, ענה ישוע. ”האם מעולם לא קראתם בכתבי־הקודש: ’מפי עוללים ויונקים יסדת עֹז‘!“ ");
INSERT INTO heblb_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","ישוע עזב אותם והלך לבית־עניה – שם נשאר ללון באותו לילה. ");
INSERT INTO heblb_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","כשחזר בבוקר לירושלים היה רעב. ");
INSERT INTO heblb_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","הוא ראה עץ תאנה בצד הדרך, אבל כשניגש לחפש תאנים מצא עלים בלבד. ”לעולם לא תישאי פרי!“ אמר ישוע לתאנה, ומיד התייבש העץ. ");
INSERT INTO heblb_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","התלמידים נדהמו ושאלו: ”כיצד יבשה התאנה לפתע?“ ");
INSERT INTO heblb_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","וישוע ענה: ”אני אומר לכם: אם באמת תאמינו ולא תטילו ספק, תוכלו גם אתם לעשות דברים כאלה ואף גדולים מאלה. אפילו תוכלו לומר להר הזה: ’זוז, הזרק לים!‘ והוא ישמע בקולכם. ");
INSERT INTO heblb_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","תוכלו לקבל כל דבר שתבקשו בתפילה – אם רק תאמינו.“ ");
INSERT INTO heblb_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","כשחזר ישוע לבית־המקדש ולימד את העם, באו אליו ראשי הכוהנים וזקני העם, ודרשו לדעת באיזו רשות הוא עושה את כל הדברים האלה. ");
INSERT INTO heblb_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","”אני אענה לשאלתכם אם אתם תענו לשאלתי“, השיב להם ישוע. ");
INSERT INTO heblb_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","”האם יוחנן המטביל נשלח על־ידי אלוהים או לא?“ הם התייעצו ביניהם: ”אם נאמר שאלוהים שלח את יוחנן, הוא ישאל אותנו מדוע לא האמנו בו. ");
INSERT INTO heblb_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","ואם נאמר שאלוהים לא שלח את יוחנן, העם יתנפל עלינו, כי כולם חושבים שיוחנן היה נביא.“ ");
INSERT INTO heblb_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","לבסוף השיבו: ”איננו יודעים.“ אמר להם ישוע: ”אם כך, גם אני לא אענה לשאלתכם. ");
INSERT INTO heblb_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","אולם מה דעתכם: לאב אחד היו שני בנים. ’בני, לך היום לעבוד בכרם‘, ביקש האב מבנו הבכור. ");
INSERT INTO heblb_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","’אינני רוצה‘, השיב הבן, אבל אחר כך שינה את דעתו והלך לעבוד בכרם. ");
INSERT INTO heblb_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","הלך האב אל הבן הצעיר וחזר על בקשתו. ’טוב, אבא אני אלך‘, השיב הבן הצעיר, אולם לא הלך לכרם. ");
INSERT INTO heblb_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","מי מהשניים שמע בקול אביו?“ ”הבן הבכור, כמובן“, השיבו. ”אני אומר לכם שהמוכסים והזונות יכנסו למלכות השמים לפניכם“, הסביר להם ישוע את המשל. ");
INSERT INTO heblb_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","”כי יוחנן המטביל אמר לכם לחזור בתשובה ולהאמין באלוהים, ואתם לא שבתם; בעוד שפושעים וזונות כן שבו בתשובה. גם לאחר שראיתם כיצד הם שבו, לא נהגתם כמוהם ולא האמנתם לדברי יוחנן. ");
INSERT INTO heblb_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","”הקשיבו עתה למשל הבא: בעל־אדמה נטע כרם, בנה גדר סביבו, הקים מגדל שמירה, הפקיד את הכרם בידי כורמים שכירים ונסע לארץ רחוקה. ");
INSERT INTO heblb_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","”בעת הבציר שלח בעל־הכרם אחדים מאנשיו אל הכורמים, כדי לאסוף את חלקו ביבול הענבים. ");
INSERT INTO heblb_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","”אולם הכורמים הכו את האחד, סקלו באבנים את השני והרגו את השלישי. ");
INSERT INTO heblb_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","”בעל־הכרם שלח קבוצה גדולה יותר של אנשים כדי לאסוף את היבול, אך גורלם היה כגורל קודמיהם. ");
INSERT INTO heblb_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","לבסוף שלח האיש את בנו, כי חשב שיכבדו אותו ויפחדו מפניו. ");
INSERT INTO heblb_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","”אולם כשראו הכורמים את הבן מרחוק, אמרו זה לזה: ’הנה בא יורש הכרם; הבה נהרוג אותו, וכך נזכה אנחנו בירושה!‘ ");
INSERT INTO heblb_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","הם גירשו את הבן מהכרם והרגו אותו. ");
INSERT INTO heblb_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","”כשישוב בעל־הכרם, מה לדעתכם יעשה לאותם כורמים?“ ");
INSERT INTO heblb_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","השיבו המנהיגים: ”הוא יוציא להורג את השכירים הרעים, וייתן את הכרם לפועלים נאמנים יותר, אשר יתנו לו בזמן את היבול המגיע לו.“ ");
INSERT INTO heblb_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","ישוע המשיך ואמר: ”האם מעולם לא קראתם בכתובים: ’אבן מאסו הבונים היתה לראש פינה, מאת ה׳ היתה זאת; היא נפלאת בעינינו‘? ");
INSERT INTO heblb_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","”אני מתכוון לומר שאלוהים ייקח מכם את המלכות, וייתן אותה לעם אשר ייתן לו את חלקו ביבול. ");
INSERT INTO heblb_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","מי שייפול על האבן הזאת יתנפץ לרסיסים, ומי שתיפול עליו האבן ישחק לאבק.“ ");
INSERT INTO heblb_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","כשהבינו ראשי הכוהנים והפרושים שישוע התכוון אליהם – כלומר, שהם היו הכורמים במשל – ");
INSERT INTO heblb_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","הם רצו לתפוס אותו, אבל פחדו לעשות דבר מפני ההמון אשר האמין כי ישוע הוא נביא. ");
INSERT INTO heblb_vpl VALUES ("MT22_1‏","070_22_1‏","MAT","22","1‏","2","ישוע סיפר להם משלים נוספים על מלכות השמים. ”אפשר להמשיל את מלכות השמים למלך שערך סעודת־חתונה גדולה לבנו. ");
INSERT INTO heblb_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","כאשר הייתה הסעודה מוכנה שלח המלך שליחים אל האורחים שהזמין, כדי להודיע להם שהגיע הזמן לבוא לסעודה, אך כולם סרבו לבוא. ");
INSERT INTO heblb_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","המלך שלח שליחים אחרים להודיע למוזמנים: ’הזדרזו! השורים והבקר המפוטם טבוחים והצלי כבר בתנור!‘ ");
INSERT INTO heblb_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","”אולם המוזמנים צחקו והלכו כל אחד לענייניו, אחד לשדה ואחר לשוק ");
INSERT INTO heblb_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","היו גם כאלה שתקפו את השליחים, הכו אותם, התעללו בהם ואפילו רצחו אחדים מהם. ");
INSERT INTO heblb_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","”המלך הזועם שלח גדודי צבא כדי להרוג את הרוצחים ולשרוף את עירם. ");
INSERT INTO heblb_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","הוא פנה אל משרתיו ואמר: ’משתה החתונה מוכן, אולם האורחים שהוזמנו לא היו ראויים לכבוד הזה. ");
INSERT INTO heblb_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","צאו אל הרחובות והזמינו את כל מי שתפגשו!‘ ");
INSERT INTO heblb_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","המשרתים עשו כדבריו והכניסו לאולם את כל מי שפגשו: אנשים טובים ורעים גם יחד, והאולם נמלא אורחים. ");
INSERT INTO heblb_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","”אולם כשנכנס המלך אל האולם כדי לראות את האורחים, גילה כי אחד מהם לא לבש בגדי חתונה הולמים. ");
INSERT INTO heblb_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","” ’ידידי‘, שאל המלך, ’כיצד נכנסת אל האולם ללא בגדי חתונה?‘ לַאורח לא הייתה תשובה. ");
INSERT INTO heblb_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","”אז אמר המלך למשרתיו: ’קשרו את ידיו ורגליו והשליכוהו החוצה לחושך, למקום שבו יש רק בכי וחריקת שיניים!‘ ");
INSERT INTO heblb_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","כי רבים הקרואים אך מעטים הנבחרים.“ ");
INSERT INTO heblb_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","שוב נועצו הפרושים ביניהם וחיפשו דרך להכשיל את ישוע בלשונו. ");
INSERT INTO heblb_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","הם החליטו לשלוח אליו כמה מאנשיהם, יחד עם אנשי הורדוס, כדי לשאול אותו שאלה. ”אדון,“ הם פתחו, ”אנחנו יודעים שאתה איש ישר, ושאתה מלמד את דבר אלוהים בלי להתחשב בתוצאות, בלי פחד ומשוא־פנים. ");
INSERT INTO heblb_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","אמור לנו בבקשה, האם עלינו לשלם מס לקיסר הרומאי או לא?“ ");
INSERT INTO heblb_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","ישוע הבין את מזימתם, ולכן ענה: ”צבועים שכמוכם! כך אתם מנסים אותי? ");
INSERT INTO heblb_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","בואו הנה; תנו לי מטבע.“ והם נתנו לו מטבע. ");
INSERT INTO heblb_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","”דמותו של מי חקוקה כאן?“ שאל אותם ישוע. ”ושל מי השם החקוק מתחת לדמות?“ ");
INSERT INTO heblb_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","”של הקיסר“, ענו. ”אם כך, תנו לקיסר את מה ששייך לו, ותנו לאלוהים את מה ששייך לאלוהים!“ ");
INSERT INTO heblb_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","תשובתו הפתיעה והביכה אותם, והם הסתלקו משם. ");
INSERT INTO heblb_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","באותו יום באו צדוקים אחדים (שאינם מאמינים בתחיית המתים) ושאלו: ");
INSERT INTO heblb_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","”רבי, משה אמר שאם אדם נשוי מת ואינו משאיר אחריו ילדים, חייב אחיו להתחתן עם האלמנה, כדי שתוכל ללדת בן שישא את שם המת. ");
INSERT INTO heblb_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","אנחנו מכירים משפחה אחת שהיו בה שבעה אחים. האח הבכור נשא אישה, וכעבור זמן קצר מת ולא השאיר אחריו בן. האלמנה נישאה לאח שני, ");
INSERT INTO heblb_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","אולם גם הוא נפטר ולא השאיר בן. כך נישאה האישה לאח השלישי, לרביעי וכן הלאה – עד שנישאה לכל אחד משבעת האחים. ");
INSERT INTO heblb_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","לבסוף מתה גם האישה. ");
INSERT INTO heblb_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","אם כן, למי תהיה שייכת האישה בתחיית המתים? הרי היא נישאה לכל שבעת האחים!“ ");
INSERT INTO heblb_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","השיב להם ישוע: ”טעותכם נובעת מבורותכם בכל הנוגע לכתבי־הקודש ולגבורתו של אלוהים.“ ");
INSERT INTO heblb_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","”כי בתחיית המתים לא יהיו עוד נשואים; כולם יהיו כמלאכים בשמים. ");
INSERT INTO heblb_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","באשר לשאלתכם – אם יקומו המתים לתחייה או לא – האם לא קראתם מה אמר לכם אלוהים בתורה? ");
INSERT INTO heblb_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","’אנוכי אלוהי אברהם, אלוהי יצחק ואלוהי יעקב!‘ והרי אלוהים הוא אלוהי החיים ולא אלוהי המתים!“ ");
INSERT INTO heblb_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","תשובותיו הרשימו את הקהל הנדהם, ");
INSERT INTO heblb_vpl VALUES ("MT22_34‏","070_22_34‏","MAT","22","34‏","35","אך לא את הפרושים. כששמעו כיצד השתיק ישוע את הצדוקים בתשובתו, העלו במוחם שאלה אחרת. אחד מהם, דיין במקצועו, קם ושאל: ");
INSERT INTO heblb_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","”רבי, מה היא המצווה החשובה ביותר בתורת משה?“ ");
INSERT INTO heblb_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","”ואהבת את ה׳ אלוהיך בכל לבבך, ובכל נפשך ובכל שכלך“, השיב ישוע. ");
INSERT INTO heblb_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","”זאת המצווה הראשונה והחשובה ביותר! ");
INSERT INTO heblb_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","והמצווה השנייה דומה לה: ’ואהבת לרעך כמוך‘. ");
INSERT INTO heblb_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","כל יתר המצוות וכל דברי הנביאים מבוססים על שתי מצוות אלה. אם באמת תקיים את שתי המצוות אלה, תקיים למעשה את התורה כולה.“ ");
INSERT INTO heblb_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","בעוד הפרושים נקהלים סביבו, שאל אותם ישוע שאלה: ");
INSERT INTO heblb_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","”מה בדבר המשיח? בנו של מי הוא?“ ”הוא בן־דוד“, השיבו הפרושים. ");
INSERT INTO heblb_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","”אם כך, מדוע קורא לו דוד בהשראת רוח הקודש ’אדון‘?“ המשיך ישוע לשאול. ");
INSERT INTO heblb_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","”הרי דוד אמר: ’נאם ה׳ לאדני, שב לימיני עד אשית אויביך הדם לרגליך‘. ");
INSERT INTO heblb_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","ואם דוד קורא לו ’אדון‘, כיצד הוא יכול להיות בנו?“ ");
INSERT INTO heblb_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","לא הייתה להם תשובה, ומאותו יום לא העז איש לשאול אותו שאלות מכשילות. ");
INSERT INTO heblb_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","ישוע פנה אל הקהל ואל תלמידיו ואמר: ");
INSERT INTO heblb_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","”הסופרים והפרושים יושבים על כסא משה. ");
INSERT INTO heblb_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","לכן טוב שתשמעו בקולם ותעשו את מה שהם אומרים, אבל בשום אופן אל תעשו את מה שהם עושים! כי הם עצמם אינם עושים את מה שהם דורשים מכם לעשות. ");
INSERT INTO heblb_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","הם מכבידים עליכם בדרישות שונות, בעוד שבעצמם לא מוכנים להרים אצבע. ");
INSERT INTO heblb_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","”הם עושים את כל מעשיהם בשביל שיראו אותם. הם מעמידים פני צדיקים, מניחים תפילין בציבור ומאריכים את הציציות שלהם. ");
INSERT INTO heblb_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","במסיבות הם אוהבים לשבת בראש השולחן, ובבית הכנסת – במקומות השמורים. ");
INSERT INTO heblb_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","הם אוהבים שנותנים להם כבוד ברחובות ושקוראים להם ’רבי‘. ");
INSERT INTO heblb_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","אל תרשו לאיש לקרוא לכם כך, כי ה׳ לבדו הוא רבכם, וכולכם שווים כאחים. ");
INSERT INTO heblb_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","כמו כן אל תפנו לאיש בתואר ’אבי‘, כי רק לאלוהים שבשמים עליכם לקרוא ’אבי‘. ");
INSERT INTO heblb_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","אל תרשו שיקראו לכם ’מורי ורבי‘, כי יש לכם מורה ורב אחד בלבד, והוא המשיח. ");
INSERT INTO heblb_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","”ככל שתרבו לשרת את הזולת בענווה, כך תגדלו בעצמכם. כדי להיות גדולים ביותר – היו עבדים! ");
INSERT INTO heblb_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","מי שמכבד את עצמו יושפל ומי שמשפיל את עצמו יכובד. ");
INSERT INTO heblb_vpl VALUES ("MT23_13‏","070_23_13‏","MAT","23","13‏","14","”אוי לכם, הפרושים והסופרים, צבועים אתם! לא די שאינכם נכנסים בעצמכם למלכות השמים, אתם גם מונעים מאחרים להיכנס! אתם מעמידים פני צדיקים ומתפללים באריכות באמצע הרחוב, וכל זאת בזמן שאתם מגרשים אלמנות מבתיהן. צבועים שכמוכם! ");
INSERT INTO heblb_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","כן, אוי לכם, צבועים! אתם נוסעים למרחקים כדי לגייר אדם אחד, ולאחר שהתגייר אתם הופכים אותו לבן־גיהינום עוד יותר מכם! ");
INSERT INTO heblb_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","”אוי לכם, מנהיגים עיוורים! הכלל שלכם הוא: ’אם נשבעת במקדש ה׳ מותר לך להפר את שבועתך, אולם אם נשבעת בזהב של בית־המקדש אסור לך להפר את שבועתך‘. ");
INSERT INTO heblb_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","עיוורים טיפשים! מה חשוב יותר, הזהב או המקדש שמקדש את הזהב? ");
INSERT INTO heblb_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","”כמו כן אתם אומרים: ’שבועה במזבח אינה מחייבת ומותר להפר אותה, אך שבועה בקורבן שעל המזבח – מחייבת‘. ");
INSERT INTO heblb_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","עיוורים! מה גדול וחשוב יותר, הקורבן שעל המזבח או המזבח עצמו המקדש את הקורבן? ");
INSERT INTO heblb_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","הרי אם אתם נשבעים ’במזבח‘, אתם נשבעים למעשה בו ובכל אשר עליו. ");
INSERT INTO heblb_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","כאשר אתם נשבעים ’במקדש‘, אתם נשבעים למעשה בו ובאלוהים השוכן בו. ");
INSERT INTO heblb_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","ואם אתם נשבעים ’בשמים‘, אתם נשבעים בכסא אלוהים ובאלוהים עצמו. ");
INSERT INTO heblb_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","”כן, אוי לכם פרושים וסופרים צבועים! אתם מקפידים על הלכות דקדקניות כמו לתת מעשר על עלי נענע בגינה, אולם אתם מתעלמים מהדברים החשובים באמת כמו צדק, רחמים ואמונה! אתם אמנם חייבים לתת מעשר, אולם אסור לכם להזניח את הדברים החשובים יותר. ");
INSERT INTO heblb_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","מנהיגים עיוורים! אתם מסננים את היתוש ובולעים את הגמל! ");
INSERT INTO heblb_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","”אוי לכם, סופרים ופרושים צבועים שכמוכם! אתם מקפידים כל־כך על צחצוח הכוס מבחוץ, אולם תוכה מצחין מריקבון! ");
INSERT INTO heblb_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","פרושים עיוורים, טהרו תחילה את פנים הכלי ואז כולו יהיה נקי! ");
INSERT INTO heblb_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","”אוי לכם, סופרים ופרושים! אתם דומים לקברים הנראים יפים ומפוארים מבחוץ, אך בתוכם הם מלאים עצמות מתים, ריקבון וטומאה. ");
INSERT INTO heblb_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","אתם משתדלים להיראות קדושים, אולם בפנים לבכם מלא צביעות וטומאה. ");
INSERT INTO heblb_vpl VALUES ("MT23_29‏","070_23_29‏","MAT","23","29‏","30","כן, אוי לכם פרושים, ואוי לכם סופרים – צבועים שכמוכם! אתם בונים מצבות לנביאים שאבותיכם הרגו, ומניחים פרחים על קברי אנשי־האלוהים שאבותיכם רצחו, ואתם אומרים: ’אנחנו, כמובן, לא היינו מעזים לנהוג כפי שנהגו אבותינו!‘ ");
INSERT INTO heblb_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","”בדבריכם אלה אתם מעידים על עצמכם שהנכם בני רשעים. ");
INSERT INTO heblb_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","אתם הולכים בעקבות אבותיכם וממלאים את מכסת עוונותיהם. ");
INSERT INTO heblb_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","נחשים בני נחשים! כיצד תימלטו מעונש הגיהינום? ");
INSERT INTO heblb_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","”אני שולח אליכם נביאים, חכמים וסופרים; אחדים מהם תהרגו בצליבה, ואחרים תלקו בשוטים בבתי הכנסת שלכם, ותרדפו אחריהם מעיר לעיר! ");
INSERT INTO heblb_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","וכך תישאו באשמת הריגתם של כל אנשי האלוהים – החל בהבל הצדיק וכלה בזכריה בן־ברכיה, שאותו רצחתם בבית־המקדש בין ההיכל למזבח. ");
INSERT INTO heblb_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","ובכן, כל זה יבוא על הדור הזה. ");
INSERT INTO heblb_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","”ירושלים, ירושלים, ההורגת את הנביאים ורוגמת באבנים את שליחי אלוהים! פעמים רבות חפצתי לאסוף את בנייך, כתרנגולת האוספת את אפרוחיה תחת כנפיה, אולם לא רציתם. ");
INSERT INTO heblb_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","ועתה אלוהים נוטש את ביתכם, ");
INSERT INTO heblb_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","ואני אומר לכם שמעתה ואילך לא תראו אותי יותר, עד אשר תאמרו: ’ברוך הבא בשם ה׳!‘ “ ");
INSERT INTO heblb_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","כשיצא ישוע מבית־המקדש, באו אליו תלמידיו להראות לו את מבני המקדש. ");
INSERT INTO heblb_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","אולם ישוע אמר להם: ”כל המבנים האלה ייהרסו ואף אבן לא תישאר במקומה.“ ");
INSERT INTO heblb_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","מאוחר יותר, כשישב ישוע על מדרון הר הזיתים, שאלו אותו התלמידים: ”מתי יקרה הדבר הזה? אילו מאורעות יסמנו את שובך ואת סוף העולם?“ ");
INSERT INTO heblb_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","”אל תניחו לאיש לרמות אתכם“, השיב להם ישוע, ");
INSERT INTO heblb_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","”כי אנשים רבים יבואו ויטענו כל אחד ’אני המשיח‘, ויטעו אנשים רבים. ");
INSERT INTO heblb_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","כאשר תשמעו על מהומות ומלחמות – אל תיבהלו. אמנם תפרוצנה מלחמות ותתחוללנה מהומות, אבל הקץ לא יבוא מיד. ");
INSERT INTO heblb_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","מדינות וממלכות תילחמנה זו בזו, ובמקומות רבים יהיו רעידות אדמה ורעב. ");
INSERT INTO heblb_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","אולם כל אלה יציינו רק את ראשית הצרות והסבל העתידים לבוא. ");
INSERT INTO heblb_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","”לאחר מכן יענו אתכם, יהרגו אתכם והעולם כולו ישנא אתכם, משום שאתם שייכים לי. ");
INSERT INTO heblb_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","רבים ישובו לחטוא, יבגדו זה בזה וישנאו איש את אחיו. ");
INSERT INTO heblb_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","נביאי שקר רבים יופיעו ויוליכו שולל אנשים רבים. ");
INSERT INTO heblb_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","החטא והרשע יתפשטו בכל מקום וידכאו את אהבתם של רבים. ");
INSERT INTO heblb_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","אולם אלה שיחזיקו מעמד עד הסוף יינצלו. ");
INSERT INTO heblb_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","”הבשורה הטובה על דבר המלכות תתפשט בעולם כולו – כך שכל האומות תשמענה אותה – ולבסוף יגיע הקץ. ");
INSERT INTO heblb_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","”לכן, כאשר תראו בבית־המקדש את חילול הקודש, שעליו דיבר דניאל הנביא (הקורא – שים לב!) ");
INSERT INTO heblb_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","על כל תושבי יהודה לברוח להרים. ");
INSERT INTO heblb_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","אלה שעל הגגות – שלא ייכנסו הביתה לארוז את חפציהם. ");
INSERT INTO heblb_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","אלה שבשדה – שלא יחזרו הביתה לקחת את בגדיהם. ");
INSERT INTO heblb_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","”אוי לנשים ההרות ולמניקות באותם ימים! ");
INSERT INTO heblb_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","התפללו שבריחתכם לא תהיה בחורף ולא בשבת. ");
INSERT INTO heblb_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","כי תהיה צרה שכמוה טרם הייתה בתולדות העולם, וכמוה לא תהיה עוד! ");
INSERT INTO heblb_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","”למעשה אם אלוהים לא יקצר את הימים הנוראים האלה, כולם יאבדו. אולם אלוהים יקצר ימים אלה למען עמו הנבחר. ");
INSERT INTO heblb_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","”אם מישהו יאמר לכם באותם ימים: ’ראיתי את המשיח במקום פלוני!‘ או ’המשיח נמצא בכפר הסמוך!‘ אל תאמינו לו. ");
INSERT INTO heblb_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","כי משיחי־שקר ונביאי־שקר יקומו ויחוללו נסים ונפלאות אשר יתעו את האנשים, ואם יוכלו, הם יתעו אפילו את הנבחרים. ");
INSERT INTO heblb_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","זיכרו, הזהרתי אתכם! ");
INSERT INTO heblb_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","”על כן, אם יאמרו לכם שהמשיח אי־שם במדבר – אל תטריחו את עצמכם ללכת ולראות, ואם יאמרו לכם שהמשיח מסתתר במקום כלשהו – אל תאמינו. ");
INSERT INTO heblb_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","כי כשם שהברק במזרח מאיר למערב, כך יהיה גם שובו של בן־האדם. ");
INSERT INTO heblb_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","במקום שבו נמצא הפגר, שם יתאספו הנשרים. ");
INSERT INTO heblb_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","”מיד לאחר הצרות של אותם ימים תחשך השמש, הירח ישחיר, הכוכבים יפלו מהשמים וכוחות השמים יתמוטטו. ");
INSERT INTO heblb_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","”לבסוף ייראה בשמים אות בן־האדם ואבל כבד ירד על העולם כולו. כל אומות העולם יראו את בן־האדם בא על ענני השמים, בגבורה ובכבוד רב. ");
INSERT INTO heblb_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","ואז הוא ישלח את מלאכיו בקול תרועת השופר, והם יאספו את בחיריו מכל קצוות תבל. ");
INSERT INTO heblb_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","”עץ התאנה ישמש לכם כדוגמה: כאשר הענפים מלבלבים והעלים ירוקים, אתם יודעים שהקיץ קרב. ");
INSERT INTO heblb_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","כאשר כל מה שסיפרתי לכם יתחיל להתרחש, דעו לכם שזה קרוב, שאני עומד בפתח. ");
INSERT INTO heblb_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","אני אומר לכם: כל הדברים האלה יתרחשו לפני שיחלוף הדור הזה. ");
INSERT INTO heblb_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","השמים והארץ יחלפו, אבל דברי לא יחלפו. ");
INSERT INTO heblb_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","”איש אינו יודע את היום והשעה של התרחשויות אלה; המלאכים בשמים אינם יודעים זאת, ואפילו אני עצמי איני יודע את המועד המדויק. רק אבי שבשמים יודע זאת. ");
INSERT INTO heblb_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","”כימי נוח כן יהיה באו של בן־האדם. ");
INSERT INTO heblb_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","בני־האדם חיו בשלווה; הם אכלו, שתו והתחתנו לפני שפתאום בא המבול. ");
INSERT INTO heblb_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","בני־האדם סרבו להאמין לשמע מה שעמד לקרות, עד שהמבול אכן בא והטביע את כולם. כך יהיה בואי. ");
INSERT INTO heblb_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","”באותה עת שני גברים יעבדו יחד בשדה – האחד יילקח והשני יישאר. ");
INSERT INTO heblb_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","שתי נשים יטחנו בָּרֵחָיִם – אחת תילקח והשנייה תישאר. ");
INSERT INTO heblb_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","”לכן היו מוכנים, כי אינכם יודעים באיזה יום יבוא אדונכם. ");
INSERT INTO heblb_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","”אילו ידעו את השעה, היו כולם מתכוננים לבואו, כשם שהיו מתכוננים לבואו של גנב אילו ידעו מתי יבוא. ");
INSERT INTO heblb_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","כך גם אתם היו מוכנים תמיד, כי בן־האדם יבוא בשעה בלתי צפויה. ");
INSERT INTO heblb_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","מי מכם משרת נבון ונאמן לאדונכם, שיפקח על משק ביתו ויקבל את שכרו בעתו? ");
INSERT INTO heblb_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","ברוך תהיה אם בשובי אמצא אותך ממלא את תפקידך בנאמנות. ");
INSERT INTO heblb_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","אנשים נאמנים כאלה אני אפקיד על כל רכושי. ");
INSERT INTO heblb_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","”אולם אם אתה רשע ותאמר לעצמך: ’אה, האדון לא ישוב כל כך מהר‘, – ");
INSERT INTO heblb_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ותתאכזר ליתר העבדים ותבלה את זמנך במסיבות, בזלילה ובשתייה – ");
INSERT INTO heblb_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","אדונך יופיע בשעה בלתי צפויה, ");
INSERT INTO heblb_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ואז הוא יכה אותך קשות ויקבע את מקומך עם הצבועים; שם יהיה בכי וחריקת שיניים.“ ");
INSERT INTO heblb_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","”אז תידמה מלכות השמים לסיפור על עשר עלמות, אשר לקחו את המנורות שלהן ויצאו לקבל את פני החתן. ");
INSERT INTO heblb_vpl VALUES ("MT25_2‏","070_25_2‏","MAT","25","2‏","4","אולם רק חמש מהן היו חכמות ומילאו את מנורותיהן מראש בשמן. חמש האחרות היו טיפשות ולא מילאו מראש את המנורות. ");
INSERT INTO heblb_vpl VALUES ("MT25_5‏","070_25_5‏","MAT","25","5‏","6","”מכיוון שהחתן איחר לבוא, שכבו העלמות לנוח. בחצות הלילה הן התעוררו לקול תרועה: ’החתן בא! צאנה לקבל את פניו!‘ ");
INSERT INTO heblb_vpl VALUES ("MT25_7‏","070_25_7‏","MAT","25","7‏","8","”כל הבחורות קמו מיד והיטיבו את המנורות. אלה שלא היה להן שמן ביקשו מעט מחברותיהן, כי מנורותיהן דעכו. ");
INSERT INTO heblb_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","”אולם הבחורות החכמות ענו: ’אם ניתן לכן מעט שמן לא יישאר לנו מספיק. לכו לחנות לקנות לעצמכן‘. ");
INSERT INTO heblb_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","”אך בזמן שהן הלכו לקנות שמן בא החתן, ואלה שהיו מוכנות נכנסו איתו אל החתונה והדלת ננעלה. ");
INSERT INTO heblb_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","”כשחזרו האחרות מאוחר יותר, הן עמדו בחוץ וקראו: ’אדוננו, אדוננו, פתח לנו את הדלת!‘ ");
INSERT INTO heblb_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","”אולם הוא השיב להן מבפנים: ’אינני מכיר אתכן!‘ ");
INSERT INTO heblb_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","”משום כך היו ערים ומוכנים, כי אינכם יודעים באיזה יום ובאיזו שעה אחזור.“ ");
INSERT INTO heblb_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","ישוע המשיך: ”אפשר לתאר את מלכות השמים בעזרת הסיפור על אדם שנסע לארץ רחוקה. לפני נסיעתו הוא קרא למשרתיו והפקיד בידם סכומי כסף, כדי שישקיעו אותם למענו בזמן העדרו. ");
INSERT INTO heblb_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","הוא נתן לאחד 50,000 שקלים, לשני – 20,000 שקלים ולשלישי – 10,000 שקלים. הוא חילק את הכסף בהתאם לכישרונו של כל אחד ויצא לדרכו. ");
INSERT INTO heblb_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","האיש שקיבל 50,000 שקלים החל מיד לקנות ולמכור, ותוך זמן קצר הרוויח עוד 50,000 שקלים. ");
INSERT INTO heblb_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","גם האיש שקיבל 20,000 שקלים ניגש מיד לעבודה והרוויח עוד 20,000 שקלים. ");
INSERT INTO heblb_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","אך האיש שקיבל 10,000 שקלים חפר בור באדמה והטמין בתוכו את הכסף. ");
INSERT INTO heblb_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","”לאחר זמן רב חזר האדון ממסעו, וביקש ממשרתיו לתת דין וחשבון על הכסף שהפקיד בידם. ");
INSERT INTO heblb_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","האיש שקיבל 50,000 שקלים החזיר לאדוניו 100,000 שקלים. ");
INSERT INTO heblb_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","האדון שיבח אותו על עבודתו הטובה ואמר: ’מאחר שהיית נאמן בסכום קטן, אתן לך עכשיו אחריות גדולה יותר. בוא והשתתף בשמחתי‘. ");
INSERT INTO heblb_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","”אחריו בא האיש שקיבל 20,000 שקלים והצהיר: ’אדוני, נתת לי 20,000 שקלים, ועכשיו אני מחזיר לך סכום כפול‘. ");
INSERT INTO heblb_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","” ’עבודה טובה‘, אמר לו האדון. ’אתה משרת טוב ונאמן. מאחר שהיית נאמן בסכום קטן, אתן לך עכשיו הרבה יותר!‘ ");
INSERT INTO heblb_vpl VALUES ("MT25_24‏","070_25_24‏","MAT","25","24‏","25","לאחר מכן בא האיש שקיבל 10,000 שקלים ואמר: ’אדוני, ידעתי שאתה איש קשה, שמצליח לקצור במקום שלא זרעת ולאסוף במקום שלא פיזרת. משום כך פחדתי והסתרתי את הכסף באדמה – והנה הוא!‘ ");
INSERT INTO heblb_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","”אך אדוניו השיב לו: ’רשע שכמוך, עבד עצלן! אם ידעת שאדרוש ממך את הרווח, ");
INSERT INTO heblb_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","מדוע לא הפקדת את הכסף בבנק? כך לפחות הייתי מקבל ריבית! ");
INSERT INTO heblb_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","קחו ממנו את הכסף, ותנו לאיש שיש לו כבר 100,000 ");
INSERT INTO heblb_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","כי האיש שמנצל היטב את מה שנותנים לו – יינתן לו עוד ויהיה לו שפע רב. ואילו אדם בלתי־אחראי – גם מעט האחריות שניתנה לו תילקח ממנו. ");
INSERT INTO heblb_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","קחו עתה את המשרת הזה, שאין בו כל תועלת, והשליכוהו החוצה לחושך, שם יש בכי וחריקת שיניים‘. ");
INSERT INTO heblb_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","”אולם כשאני, המשיח, אבוא בתפארתי עם כל המלאכים, אשב על כיסאי בכבוד רב. ");
INSERT INTO heblb_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","כל אומות העולם יתאספו לפני, ואני אפריד ביניהם כרועה המפריד בין הכבשים ובין העיזים. ");
INSERT INTO heblb_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","את הכבשים אעמיד לימיני ואת העיזים לשמאלי. ");
INSERT INTO heblb_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","”לאחר מכן אני, המלך, אומר לעומדים לימיני: ’בואו, ברוכי אבי, אל המלכות שהוכנה למענכם מאז היווסד העולם. ");
INSERT INTO heblb_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","כשהייתי רעב – האכלתם אותי. כשהייתי צמא – נתתם לי לשתות. כשהייתי אורח זר – הכנסתם אותי לביתכם. ");
INSERT INTO heblb_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","כשהייתי עירום – הלבשתם אותי. כשהייתי חולה או אסור בכלא – באתם לבקר אותי‘. ");
INSERT INTO heblb_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","”ואותם צדיקים יענו: ’אדוננו, מתי ראינו אותך רעב והאכלנו אותך, או צמא והשקינו אותך? ");
INSERT INTO heblb_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","או אורח זר ועזרנו לך? או עירום והלבשנו אותך? ");
INSERT INTO heblb_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","מתי ראינו אותך חולה או כלוא ובאנו לבקר אותך?‘ ");
INSERT INTO heblb_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","”ואני, המלך, אענה: ’כשעשיתם אחד מן הדברים האלה לאחד מאחי הצעירים – כאילו עשיתם אותו לי‘. ");
INSERT INTO heblb_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","לאחר מכן אפנה אל העומדים לשמאלי ואומר להם: ’הסתלקו מכאן, ארורים, אל האש הנצחית שהוכנה לשטן והשדים! ");
INSERT INTO heblb_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","כי כשהייתי רעב לא האכלתם אותי, וכשהייתי צמא לא נתתם לי דבר לשתות. ");
INSERT INTO heblb_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","הייתי אורח זר, אולם לא הזמנתם אותי לביתכם. הייתי עירום, ולא הלבשתם אותי. הייתי חולה וכלוא, וכלל לא באתם לבקר אותי!‘ ");
INSERT INTO heblb_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","”ואז הם יענו: ’אדון, מתי ראינו אותך רעב או צמא או זר או עירום או חולה או כלוא, ולא עזרנו לך?‘ ");
INSERT INTO heblb_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","”אז יענה להם: אמן, אומר אני לכם! ’כאשר סירבתם לעזור לאחד מן האחים הצעירים האלה סירבתם לעזור לי‘. ");
INSERT INTO heblb_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","”והם ילכו משם לייסורי נצח, ואילו הצדיקים – לחיי נצח.“ ");
INSERT INTO heblb_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","כשסיים ישוע ללמד את תלמידיו, אמר להם: ");
INSERT INTO heblb_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","”כידוע לכם חג הפסח מתחיל בעוד יומיים, וימסרו אותי למוות על הצלב.“ ");
INSERT INTO heblb_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","באותה שעה התכנסו ראשי הכוהנים והמנהיגים האחרים בביתו של קייפא הכוהן הגדול, ");
INSERT INTO heblb_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","כדי לחשוב איך לתפוס את ישוע בחשאי ולהרגו. ");
INSERT INTO heblb_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","”לא בזמן חגיגות הפסח,“ הסכימו ביניהם, ”פן תתחולל מהומה בעם.“ ");
INSERT INTO heblb_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","בזמן שישוע היה בבית־עניה, בביתו של שמעון המצורע, ");
INSERT INTO heblb_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ניגשה אליו אישה ובידה בקבוק בושם יקר מאוד, ושפכה את הבושם על ראשו בשעה שאכל. ");
INSERT INTO heblb_vpl VALUES ("MT26_8‏","070_26_8‏","MAT","26","8‏","9","התלמידים כעסו מאוד ואמרו: ”מדוע היא מבזבזת את הבושם היקר הזה? הלא יכולנו למכור אותו בכסף רב, ואת הכסף היינו נותנים לעניים!“ ");
INSERT INTO heblb_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","”מדוע אתם מציקים לה?“ שאל ישוע. ”הלא היא עשתה מעשה טוב. ");
INSERT INTO heblb_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","העניים נמצאים איתכם תמיד, ואילו אני לא אהיה איתכם תמיד. ");
INSERT INTO heblb_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","היא שפכה עלי את הבושם כדי להכין את גופי לקבורה. ");
INSERT INTO heblb_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","אני אומר לכם: בכל מקום שבו תוכרז הבשורה הזאת, תיזכר גם האישה הזאת, בזכות המעשה שעשתה.“ ");
INSERT INTO heblb_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","לאחר מכן הלך יהודה איש־קריות, שהיה אחד משנים־עשר התלמידים, אל ראשי הכוהנים ");
INSERT INTO heblb_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ושאל: ”מה תתנו לי אם אמסור לידיכם את ישוע?“ הם נתנו לו שלושים מטבעות כסף, ");
INSERT INTO heblb_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","ומאותה שעה חיפש יהודה הזדמנות למסור לידיהם את ישוע. ");
INSERT INTO heblb_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","בערב הפסח באו התלמידים אל ישוע ושאלו: ”היכן אתה רוצה שנכין את הסדר?“ ");
INSERT INTO heblb_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","”לכו העירה אל אדם פלוני,“ ענה ישוע, ”ואמרו לו: ’אדוננו אמר: שעתי הגיעה, והפעם אני ותלמידי נערוך את הסדר בביתך‘. “ ");
INSERT INTO heblb_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","התלמידים עשו כדבריו והכינו את הסדר. ");
INSERT INTO heblb_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","בערב ישב ישוע עם תלמידיו ליד השולחן, ");
INSERT INTO heblb_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","ובשעת הארוחה אמר להם: ”אחד מכם יבגוד בי ויסגיר אותי.“ ");
INSERT INTO heblb_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","התלמידים התעצבו מאוד ושאלו זה אחר זה: ”האם אתה מתכוון אלי?“ ");
INSERT INTO heblb_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","”אני מתכוון לאחד אשר טבל את המצה שלו בקערה יחד אתי. ");
INSERT INTO heblb_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","בן־האדם הולך למות כפי שכתוב שצריך לקרות, אולם אני אומר לכם: אוי לאיש שיסגיר אותו; מוטב שלא היה נולד בכלל!“ ");
INSERT INTO heblb_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","גם יהודה שאל את ישוע: ”רבי, האם אתה מתכוון אלי?“ וישוע השיב: ”כן.“ ");
INSERT INTO heblb_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","בעת הסעודה לקח ישוע את הלחם (מצה), ברך, פרס לפרוסות, הגיש לתלמידיו ואמר: ”קחו ואכלו; זהו גופי.“ ");
INSERT INTO heblb_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","אחר כך לקח כוס יין, ברך, הגיש לתלמידיו ואמר: ”שתו ממנה כולכם, ");
INSERT INTO heblb_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","כי זהו דמי החותם את הברית החדשה בין אלוהים לבין בני־האדם; זהו דמי הנשפך כדי לסלוח לחטאיהם של אנשים רבים. ");
INSERT INTO heblb_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","ובכן לא אשתה יותר יין עד היום שבו אשתה יין חדש איתכם במלכות אבי.“ ");
INSERT INTO heblb_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","כל הנוכחים שרו מזמורי תהלים, ולאחר מכן הלכו להר הזיתים. ");
INSERT INTO heblb_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","”הלילה כולכם תעזבו אותי,“ אמר ישוע לתלמידיו, ”והרי כתוב: ’אכה את הרעה ותפוצין הצאן‘. ");
INSERT INTO heblb_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","אולם לאחר שאקום לתחייה אלך לגליל ואפגוש אתכם שם.“ ");
INSERT INTO heblb_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","”אפילו אם כולם יעזבו אותך, אני לעולם לא אעזוב אותך!“ קרא פטרוס. ");
INSERT INTO heblb_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","אולם ישוע אמר לו: ”האמת היא שעוד הלילה, לפני שיקרא התרנגול את קריאת השחר, תתכחש לי שלוש פעמים!“ ");
INSERT INTO heblb_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","”לעולם לא אתכחש לך,“ התעקש פטרוס, ”אפילו אם יהיה עלי למות!“ ושאר התלמידים גם אמרו כך. ");
INSERT INTO heblb_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","הם הגיעו לחורשת עצי־זית הנקראת ”גת־שמנים“, ואמר לתלמידיו: ”חכו לי כאן עד שאחזור. אני הולך להתפלל.“ ");
INSERT INTO heblb_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","הוא לקח איתו את פטרוס ואת יעקב ויוחנן, בני זבדי, והתמלא עצב ומועקה. ");
INSERT INTO heblb_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","”אני מתייסר עד מוות!“ אמר להם ישוע. ”חכו כאן… הישארו לידי ערים…“ ");
INSERT INTO heblb_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","הוא התרחק מהם מעט, נפל על פניו והתפלל: ”אבי, אם זה אפשרי, הסר ממני את כוס הייסורים. אולם לא כרצוני כי אם רצונך ייעשה!“ ");
INSERT INTO heblb_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","לאחר מכן הוא חזר אל שלושת התלמידים ומצא אותם ישנים. ”פטרוס,“ קרא ישוע, ”האם לא יכולתם להישאר ערים איתי שעה אחת בלבד? ");
INSERT INTO heblb_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","עמדו על המשמר והתפללו שלא תבואו לידי ניסיון. אני יודע שהרוח אכן רוצה, אבל גופכם חלש כל־כך!“ ");
INSERT INTO heblb_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","ישוע עזב אותם שוב והתפלל: ”אבי, אם עלי לשתות את הכוס הזאת, אז שרצונך ייעשה!“ ");
INSERT INTO heblb_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","הוא חזר אל תלמידיו, וגם הפעם מצא אותם ישנים, כי עיניהם היו כבדות. ");
INSERT INTO heblb_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","הוא שוב עזב אותם וחזר על תפילתו בפעם השלישית. ");
INSERT INTO heblb_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","לאחר מכן הוא חזר אל תלמידיו ואמר: ”האם אתם עדיין ישנים? הגיעה השעה שבן־האדם יימסר לידי אנשים חוטאים. ");
INSERT INTO heblb_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","קומו, הבה נלך מכאן. הביטו, הנה מתקרב האיש שיסגיר אותי.“ ");
INSERT INTO heblb_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","לפני שהספיק ישוע לסיים את דבריו הגיע למקום יהודה, אחד משנים־עשר התלמידים, ואיתו המון שנשלח מטעם ראשי הכוהנים וזקני העם, חמוש בחרבות ובמקלות. ");
INSERT INTO heblb_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","יהודה אמר להם לתפוס את האיש שייתן לו נשיקה, ");
INSERT INTO heblb_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","ואז ניגש ישר אל ישוע ואמר: ”שלום, רבי!“ ונישק אותו. ");
INSERT INTO heblb_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","”ידידי,“ אמר לו ישוע, ”עשה את מה שבאת לעשות.“ באותו רגע תפסו אותו האחרים. ");
INSERT INTO heblb_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","אחד האנשים שהיו עם ישוע שלף חרב וקיצץ את אוזנו של עבד הכוהן הגדול. ");
INSERT INTO heblb_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","”עזוב את החרב שלך,“ אמר לו ישוע, ”מי שחי בחרב ימות בחרב. ");
INSERT INTO heblb_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","אתה לא מבין שאני יכול לבקש מאבי שייתן לי אלפי מלאכים להגן עלי, והוא היה שולח אותם מיד? ");
INSERT INTO heblb_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","אולם אילו הייתי עושה כך, כיצד הייתה מתקיימת הנבואה בכתובים המתארת את המתרחש עכשיו?“ ");
INSERT INTO heblb_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","ישוע פנה אל ההמון ואמר: ”האם אני פושע מסוכן? מדוע אתם באים לאסור אותי בחרבות ובמקלות? הלא לימדתי אתכם במקדש יום־יום ויכולתם לאסור אותי שם ללא קושי! ");
INSERT INTO heblb_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","אולם כל זה בא למלא את דברי הנביאים בכתבי הקודש.“ אז עזבו אותו התלמידים וברחו. ");
INSERT INTO heblb_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","ההמון לקח את ישוע אל ביתו של קייפא הכוהן הגדול – שם כבר המתינו לו הסופרים והזקנים. ");
INSERT INTO heblb_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","באותו זמן הלך פטרוס במרחק מה אחרי ההמון. הוא נכנס לחצר ביתו של הכוהן הגדול, ישב בין החיילים וחיכה לראות מה יקרה לישוע. ");
INSERT INTO heblb_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","ראשי הכוהנים וחברי הסנהדרין, שהתאספו שם, חיפשו עדי שקר שיעידו נגד ישוע, כדי שיוכלו להטיל עליו אשמה כלשהי ולדון אותו למוות. ");
INSERT INTO heblb_vpl VALUES ("MT26_60‏","070_26_60‏","MAT","26","60‏","61","אבל למרות שמצאו אנשים רבים שהסכימו לתת עדות שקר, דבריהם תמיד סתרו זה את זה. לבסוף באו שני אנשים שהצהירו: ”האיש הזה אמר שהוא יכול להרוס את בית־המקדש ולבנות אותו מחדש תוך שלושה ימים.“ ");
INSERT INTO heblb_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","הכוהן הגדול קם על רגליו ושאל: ”מה יש לך לומר להגנתך? מה יש לך לומר על כל ההאשמות נגדך?“ ");
INSERT INTO heblb_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","אך ישוע שתק. ”בשם אלוהים חיים,“ קרא הכוהן הגדול, ”אני דורש ממך שתאמר לנו אם אתה המשיח, בנו של הקדוש־ברוך־הוא!“ ");
INSERT INTO heblb_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","”אתה אמרת,“ אמר ישוע, ”אבל אני אומר שאתם תראו את בן־האדם יושב לימין האלוהים ובא עם ענני השמים.“ ");
INSERT INTO heblb_vpl VALUES ("MT26_65‏","070_26_65‏","MAT","26","65‏","66","הכוהן הגדול קרע את בגדיו וקרא בקול: ”מגדף! איננו זקוקים לעדים נוספים, כולכם שמעתם את דבריו! מה אתם פוסקים?“ ”מוות!“ הם צעקו. ”מוות! מוות!“ ");
INSERT INTO heblb_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","הם ירקו בפניו של ישוע, הכו אותו, סטרו לו על הלחי וקראו: ");
INSERT INTO heblb_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","”משיח שכמוך, התנבא לנו! מי הכה אותך הפעם?“ ");
INSERT INTO heblb_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","כשכל זה קרה, פטרוס ישב בחצר הבית. לפתע עברה לידו משרתת וקראה: ”גם אתה היית עם ישוע מהגליל!“ ");
INSERT INTO heblb_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","אולם פטרוס הכחיש את דבריה בקול: ”מה פתאום? אני בכלל לא יודע על מה את מדברת!“ ");
INSERT INTO heblb_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","מאוחר יותר נערה אחרת ראתה אותו ליד השער, ואמרה לאנשים סביבה: ”גם הוא היה עם ישוע מנצרת!“ ");
INSERT INTO heblb_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","פטרוס שוב הכחיש את הדבר: ”אני נשבע שאני אפילו לא מכיר את האיש הזה!“ ");
INSERT INTO heblb_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","כעבור זמן מה ניגשו אליו האנשים שעמדו שם ואמרו: ”אנחנו יודעים שאתה אחד מתלמידיו; המבטא הגלילי שלך מסגיר אותך!“ ");
INSERT INTO heblb_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","פטרוס החל לקלל ונשבע: ”אינני מכיר את האיש!“ באותו רגע קרא התרנגול, ");
INSERT INTO heblb_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","ופטרוס נזכר בדברי ישוע: ”לפני שיקרא התרנגול תתכחש לי שלוש פעמים.“ הוא יצא מהחצר ומירר בבכי. ");
INSERT INTO heblb_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","לפנות בוקר שוב התכנסו ראשי הכוהנים וזקני העם, כדי להתייעץ כיצד לשכנע את המושל הרומאי להוציא את ישוע להורג. ");
INSERT INTO heblb_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","הם כבלו אותו ושלחו אותו לפילטוס, המושל הרומאי. ");
INSERT INTO heblb_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","כאשר ראה יהודה הבוגד שישוע נידון למוות, התחרט על המעשה שעשה והחזיר את הכסף לראשי הכוהנים והזקנים. ");
INSERT INTO heblb_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","”חטאתי“, הכריז יהודה. ”בגדתי באדם חף מפשע.“ ”לא אכפת לנו“, השיבו. ”זאת הבעיה שלך.“ ");
INSERT INTO heblb_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","יהודה זרק את הכסף על הרצפה במקדש, והלך לתלות את עצמו. ");
INSERT INTO heblb_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","ראשי הכוהנים אספו את הכסף מהרצפה ואמרו: ”איננו יכולים להכניס את הכסף לאוצר, כי התורה אוסרת קבלת כסף דמים.“ ");
INSERT INTO heblb_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","הם התייעצו ביניהם, ולבסוף החליטו לקנות בכסף זה את שדה היוצר בירושלים, שהשתמשו בו לקבורת גויים. ");
INSERT INTO heblb_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","משום כך נקרא השדה ההוא עד היום הזה: ”שדה הדם“. ");
INSERT INTO heblb_vpl VALUES ("MT27_9‏","070_27_9‏","MAT","27","9‏","10","בזאת התקיימה נבואת זכריה: ”הם לקחו את שלושים שקלי הכסף – המחיר שבו העריכו אותו בני ישראל – וקנו שדה מאת הקדר, כפי שהדריך אותי ה׳.“ ");
INSERT INTO heblb_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","ישוע עמד לפני פילטוס, המושל הרומאי, וזה שאל אותו: ”האם אתה מלך היהודים?“ ”אתה אומר“, השיב ישוע. ");
INSERT INTO heblb_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","אולם כאשר ראשי הכוהנים והזקנים האשימו אותו, ישוע לא אמר דבר. ");
INSERT INTO heblb_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","”האם אינך שומע את מה שהם אומרים?“ שאל פילטוס. ");
INSERT INTO heblb_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","אך להפתעתו הרבה של המושל לא אמר ישוע דבר. ");
INSERT INTO heblb_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","כל שנה, לכבוד חג הפסח, נהג המושל לשחרר אסיר יהודי אחד לפי בחירת העם. ");
INSERT INTO heblb_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","באותה שנה היה בכלא אסיר ידוע לשמצה בשם ישוע בר־אבא. ");
INSERT INTO heblb_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","כאשר התאסף באותו בוקר המון רב לפני ביתו של פילטוס, הוא שאל: ”את מי אשחרר לכם, את ישוע בר־אבא, או את ישוע הנקרא משיח?“ ");
INSERT INTO heblb_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","כי פילטוס ידע היטב שמסרו את ישוע מתוך קנאה. ");
INSERT INTO heblb_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","באותו זמן, כשישב פילטוס על כסאו בבית־הדין, שלחה אליו אשתו הודעה: ”עזוב את האיש הטוב הזה לנפשו, כי בלילה האחרון חלמתי עליו חלום נורא.“ ");
INSERT INTO heblb_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","בינתיים הספיקו ראשי הכוהנים והזקנים לשכנע את ההמון לדרוש את שחרורו של בר־אבא, ואת הוצאתו להורג של ישוע. ");
INSERT INTO heblb_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","וכך כשחזר המושל ושאל: ”את מי מהשניים אשחרר לכם?“ צעק הקהל: ”את בר־אבא!“ ");
INSERT INTO heblb_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","”אם כך, מה אעשה עם ישוע הנקרא משיח?“ שאל פילטוס. ”צלוב אותו!“ הם צעקו. ");
INSERT INTO heblb_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","”מדוע? מה עשה?“ שאל פילטוס. הם לא ענו, ורק הגבירו את צעקותיהם: ”צלוב אותו!“ ");
INSERT INTO heblb_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","כשראה פילטוס שאין טעם להמשיך ושעלולה לפרוץ מהומה, דרש שיביאו אליו קערת מים. הוא רחץ את ידיו לעיני הקהל ואמר: ”הידיים שלי נקיות מדמו של האיש הצדיק הזה. האחריות מוטלת עליכם!“ ");
INSERT INTO heblb_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","וההמון השיב בצעקה: ”דמו עלינו ועל בנינו!“ ");
INSERT INTO heblb_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","אז שחרר להם פילטוס את בר־אבא, ולאחר שהלקה את ישוע בשוטים מסרו לידי החיילים הרומאים, כדי שיקחו אותו לצליבה. ");
INSERT INTO heblb_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","אולם לפני כן הם לקחו אותו אל ארמון המושל וקראו לכל חיילי המשמר. ");
INSERT INTO heblb_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","הם הפשיטוהו והלבישוהו גלימת ארגמן. ");
INSERT INTO heblb_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","לאחר מכן שזרו זר מקוצים ארוכים והניחו על ראשו ככתר, בידו הימנית שמו מקל כשרביט, כרעו ברך לפניו בלגלוג והתגרו בו בקריאות לעג: ”יחי מלך היהודים!“ ");
INSERT INTO heblb_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","הם ירקו בפניו, חטפו מידו את המקל והכוהו על ראשו. ");
INSERT INTO heblb_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","לאחר שסיימו החיילים להתלוצץ ולצחוק עליו, הפשיטו מעליו את הגלימה והלבישו אותו בבגדיו, והוציאו אותו החוצה לצליבה. ");
INSERT INTO heblb_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","בדרך למקום הצליבה הם פגשו את שמעון מקירניה ואילצו אותו לסחוב את הצלב של ישוע. ");
INSERT INTO heblb_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","הם המשיכו בדרכם עד שהגיעו למקום הנקרא ”גלגלתא“, או ”מקום הגולגולת“. ");
INSERT INTO heblb_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","החיילים נתנו לו יין מסומם, אולם לאחר שטעם ממנו סרב לשתות אותו. ");
INSERT INTO heblb_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","לאחר הצליבה הפילו החיילים גורל, כדי לחלק ביניהם את בגדיו של ישוע. ");
INSERT INTO heblb_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","ואז התיישבו והביטו בישוע על הצלב. ");
INSERT INTO heblb_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","מעל ראשו הם תלו שלט: ”זהו ישוע מלך היהודים.“ ");
INSERT INTO heblb_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","יחד עם ישוע נצלבו גם שני פושעים – אחד לימינו ואחד לשמאלו. ");
INSERT INTO heblb_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","העוברים ושבים קללו אותו, לעגו לו וקראו: ");
INSERT INTO heblb_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","”נו, אתה יכול להרוס את בית המקדש ולבנותו מחדש בשלושה ימים? אם אתה בן־אלוהים, מדוע אינך יורד מהצלב ומציל את עצמך?“ ");
INSERT INTO heblb_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","גם ראשי הכוהנים, הסופרים והזקנים חרפו אותו ולעגו לו: ");
INSERT INTO heblb_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","”הוא יכול להושיע את כולם חוץ מאשר את עצמו!“ צחקו. ”משיח שכמוהו!“ קראו. ”מלך ישראל, הבה נראה אותו יורד מהצלב, ואז נאמין בו! ");
INSERT INTO heblb_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","הרי בטח באלוהים, נראה אם אלוהים באמת יציל אותו. הרי אמר שהוא בן־אלוהים!“ ");
INSERT INTO heblb_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","גם הפושעים שנצלבו לידו העליבו אותו בצורה דומה. ");
INSERT INTO heblb_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","בשעה שתים־עשרה בצהריים כיסה חושך את כל הארץ למשך שלוש שעות. ");
INSERT INTO heblb_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","בשעה שלוש אחר־הצהריים זעק ישוע זעקת שבר: ”אלי, אלי, למה שבקתני?“ (כלומר: ”אלי, אלי, למה עזבתני?“) ");
INSERT INTO heblb_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","אחדים מהנוכחים חשבו שהוא קורא לאליהו הנביא. ");
INSERT INTO heblb_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","אחד מהם רץ והביא ספוג טבול בחומץ, שם אותו בקצה מקל והושיטו לישוע כדי שישתה. ");
INSERT INTO heblb_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","אך יתר האנשים אמרו: ”עזוב אותו. הבה נראה אם אליהו באמת יבוא להציל אותו!“ ");
INSERT INTO heblb_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","אז זעק ישוע שנית ונפח את נשמתו. ");
INSERT INTO heblb_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","באותו רגע הפרוכת שלפני קודש הקודשים בבית־המקדש נקרעה לשניים – מלמעלה עד למטה. האדמה רעדה, סלעים נבקעו, ");
INSERT INTO heblb_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","קברים נפתחו, וצדיקים רבים קמו לתחייה. ");
INSERT INTO heblb_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","לאחר תחייתו של ישוע, אלה עזבו את בית־הקברות, נכנסו לירושלים והופיעו לפני אנשים רבים. ");
INSERT INTO heblb_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","קצין רומאי והחיילים שהיו ליד הצלב, נבהלו מאוד מרעידת האדמה ומכל מה שקרה, וקראו: ”איש זה באמת היה בן־אלוהים!“ ");
INSERT INTO heblb_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","נשים רבות שבאו עם ישוע מהגליל, כדי לשרתו, עמדו מרחוק והתבוננו. ");
INSERT INTO heblb_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","ביניהן היו מרים המגדלית, מרים אמם של יעקב ויוסף, ואמם של יעקב ויוחנן (בני זבדי). ");
INSERT INTO heblb_vpl VALUES ("MT27_57‏","070_27_57‏","MAT","27","57‏","58","בערב ניגש אל פילטוס יוסף מן־הרמתיים, שהיה אדם עשיר ותלמיד של ישוע, וביקש את גופתו. פילטוס ציווה לשחרר את הגופה ולהעביר אותה ליוסף. ");
INSERT INTO heblb_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","יוסף לקח את הגופה, עטף אותה בסדין לבן, ");
INSERT INTO heblb_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","הניח אותה בתוך קבר חדש שחצב בשביל עצמו, סתם את הפתח באבן גדולה והלך לדרכו. ");
INSERT INTO heblb_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","מרים המגדלית ומרים השנייה ישבו במרחק והסתכלו. ");
INSERT INTO heblb_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","למחרת, בתום טקסי החג, באו ראשי הכוהנים והפרושים אל פילטוס ");
INSERT INTO heblb_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ואמרו: ”אדוננו, השקרן הזה אמר פעם שלאחר שלושה ימים ישוב ויקום לתחייה. ");
INSERT INTO heblb_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","משום כך אנחנו מבקשים ממך לחתום את הקבר עד לאחר היום השלישי, כדי שתלמידיו לא יגנבו את הגופה ויפיצו את השמועה שהוא קם מן המתים. אחרת תהיה התרמית גרועה מזו הראשונה.“ ");
INSERT INTO heblb_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","פילטוס אמר להם: ”יש לכם משמר שלכם, אתם יודעים איך לטפל בזה כמו שצריך“. ");
INSERT INTO heblb_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","וכך הם חתמו את הקבר והציבו שומרים. ");
INSERT INTO heblb_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","ביום ראשון השכם בבוקר, בעלות השחר, הלכו מרים המגדלית ומרים השנייה אל הקבר. ");
INSERT INTO heblb_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","לפתע התחוללה רעידת אדמה חזקה, ומלאך ירד מהשמים, הזיז את האבן שחסמה את הפתח וישב עליה. ");
INSERT INTO heblb_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","פניו האירו כברק, ובגדיו היו צחורים כשלג. ");
INSERT INTO heblb_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","כשראו השומרים את המלאך, הם התעלפו מרוב בהלה ונפלו על הארץ כמתים. ");
INSERT INTO heblb_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","”אל תפחדנה“, פנה המלאך אל הנשים. ”אני יודע שאתן מחפשות את ישוע שנצלב. ");
INSERT INTO heblb_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","אולם הוא אינו נמצא כאן. ישוע קם לתחייה בדיוק כפי שהבטיח. היכנסו, תראו את המקום שבו שכב. ");
INSERT INTO heblb_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","עכשיו לכו מהר אל תלמידיו ותאמרו להם שישוע קם מן המתים, והולך לפניכם לגליל. אתם תראו אותו שם. זהו, אמרתי לכם!“ ");
INSERT INTO heblb_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","הנשים רצו מן הקבר מבוהלות מאוד, אך מלאות שמחה, ומיהרו למצוא את התלמידים ולמסור להם את בשורת המלאך. ");
INSERT INTO heblb_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","בשעה שרצו נגלה אליהן ישוע. ”שלום לכן“, אמר, והן נפלו לרגליו והשתחוו לפניו. ");
INSERT INTO heblb_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","”אל תפחדו“, הרגיע אותן ישוע. ”לכו ואמרו לאחי ללכת מיד לגליל כדי לפגוש אותי שם.“ ");
INSERT INTO heblb_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","כשהיו הנשים בדרכן העירה, באו השומרים אל ראשי הכוהנים וסיפרו להם מה שקרה, ");
INSERT INTO heblb_vpl VALUES ("MT28_12‏","070_28_12‏","MAT","28","12‏","13","הזקנים התכנסו לאסיפת חרום והחליטו לשחד את השומרים, כדי שיספרו שגופת ישוע נגנבה בזמן שישנו. ");
INSERT INTO heblb_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","”אם יגיע הדבר הזה לאוזני המושל,“ הסבירו, ”נעמוד לצדכם ונפייס אותו.“ ");
INSERT INTO heblb_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","וכך קיבלו אנשי המשמר את השוחד ואמרו מה שנתבקשו לומר. גרסתם הופצה בין היהודים, אשר עד היום מאמינים בה. ");
INSERT INTO heblb_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","בינתיים הלכו אחד־עשר התלמידים אל הגליל, כדי לפגוש את ישוע על אותו הר שאמר להם מראש. ");
INSERT INTO heblb_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","כשראו אותו התלמידים הם השתחוו לפניו, למרות שחלקם הטילו ספק שאכן היה זה ישוע. ");
INSERT INTO heblb_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","”ניתנה לי כל סמכות בשמים ובארץ“, אמר להם ישוע. ");
INSERT INTO heblb_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","”משום כך לכו ועשו תלמידים בכל העולם. הטבילו אותם בשם האב, הבן ורוח הקודש, ");
INSERT INTO heblb_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ולמדו אותם לעשות את כל אשר ציוויתי אתכם. היו סמוכים ובטוחים שאהיה אתכם עד סוף העולם!“");
INSERT INTO heblb_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","כך מתחיל הסיפור על ישוע המשיח בן־האלוהים. ");
INSERT INTO heblb_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","בספרי הנביאים הודיע לנו אלוהים שהוא עומד לשלוח אלינו את בנו, אולם לפני כן ישלח שליח מיוחד אשר יכין את העולם לקראת בואו של בן־האלוהים. ");
INSERT INTO heblb_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","ישעיהו הנביא ניבא: ”קול קורא במדבר פנו דרך ה׳, ישרו מסילותיו.“ ");
INSERT INTO heblb_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","שליח זה היה יוחנן המטביל. יוחנן גר במדבר והכריז שכל אחד צריך להיטבל במים, לאות חרטה על מעשיו וכדי שאלוהים יסלח לו עליהם. ");
INSERT INTO heblb_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","אנשים רבים מירושלים ומכל אזור יהודה באו להקשיב לדברי יוחנן, ולאחר שהתוודו על מעשיהם הרעים הוא הטביל אותם בנהר הירדן. ");
INSERT INTO heblb_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","בגדיו היו עשויים שער גמלים והייתה לו חגורת עור; הוא נהג לאכול ארבה ודבש־בר. ");
INSERT INTO heblb_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","המסר של יוחנן היה זה: ”בקרוב יבוא אדם גדול ונעלה ממני; הוא כה נעלה עד כי איני ראוי אפילו להסיר את נעליו! ");
INSERT INTO heblb_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","אני הטבלתי אתכם במים, אולם הוא יטביל אתכם ברוח הקודש של אלוהים!“ ");
INSERT INTO heblb_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","יום אחד בא ישוע מנצרת שבגליל, ויוחנן הטביל אותו בנהר הירדן. ");
INSERT INTO heblb_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","כאשר יצא ישוע מהמים נפתחו השמים, ורוח אלוהים בדמות יונה ירדה ונחתה עליו, ");
INSERT INTO heblb_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","וקול מן השמים קרא: ”אתה בני אהובי, ובך אני חפץ.“ ");
INSERT INTO heblb_vpl VALUES ("MK1_12‏","071_1_12‏","MRK","1","12‏","13","רוח אלוהים נשא מיד את ישוע אל המדבר, שם הוא נשאר לבדו עם חיות המדבר ארבעים יום, והשטן ניגש לנסותו. לאחר מכן באו המלאכים לשרת אותו. ");
INSERT INTO heblb_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","זמן מה לאחר שאסר המלך הורדוס את יוחנן, בא ישוע אל הגליל כדי להכריז על בשורת אלוהים. ");
INSERT INTO heblb_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","”העת הגיעה!“ קרא ישוע. ”מלכות אלוהים קרבה, שובו מדרככם הרעה והאמינו לבשורה!“ ");
INSERT INTO heblb_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","יום אחד כשהתהלך ישוע על חוף הכינרת, ראה את האחים שמעון ו‎אַנְדְּרֵי דגים בעזרת רשתות. הם היו דייגים במקצועם. ");
INSERT INTO heblb_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","”בואו אחרי!“ קרא אליהם ישוע. ”אני אעשה אתכם לדייגי אדם!“ ");
INSERT INTO heblb_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","שני האחים עזבו מיד את הרשתות שלהם והלכו אחריו. ");
INSERT INTO heblb_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","לא הרחק משם ראה ישוע את יעקב ויוחנן בני־זבדי יושבים בסירת דיג ומתקנים את הרשתות. ");
INSERT INTO heblb_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","ישוע קרא להם, והשניים הצטרפו מיד אל החבורה, לאחר שהשאירו את זבדי אביהם בסירה עם מספר דייגים שכירים. ");
INSERT INTO heblb_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","ישוע ומלוויו הגיעו לכפר־נחום. בשבת בבוקר הלכו לבית־הכנסת, וישוע לימד את הקהל. ");
INSERT INTO heblb_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","היהודים בבית־הכנסת נדהמו מהדרשה שלו, מפני שדיבר אליהם בסמכות רבה ולא כמו הסופרים. ");
INSERT INTO heblb_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","בבית־הכנסת היה איש אחוז שד טמא, והלה צעק לפתע: ");
INSERT INTO heblb_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","”מדוע אתה מטריד אותנו, ישוע מנצרת, האם באת להשמיד את השדים? אני מכיר אותך; אתה בנו הקדוש של אלוהים!“ ");
INSERT INTO heblb_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","ישוע נזף בשד וציווה עליו: ”שתוק וצא החוצה!“ ");
INSERT INTO heblb_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","השד טלטל את האיש המסכן מצד אל צד ויצא ממנו בקול צעקה. ");
INSERT INTO heblb_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","כל הנוכחים השתוממו והחלו לשוחח זה עם זה על המקרה. ”האם זוהי תורה חדשה?“ שאלו בהתרגשות. ”ראו, גם השדים שומעים בקולו!“ ");
INSERT INTO heblb_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","עד מהרה התפשטו השמועות על מעשי ישוע והתפרסמו בכל אזור הגליל. ");
INSERT INTO heblb_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","ישוע ותלמידיו יצאו מבית־הכנסת והלכו לביתם של שמעון ו‎אַנְדְּרֵי. ");
INSERT INTO heblb_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","כאשר נכנסו אל הבית מצאו את חמותו של שמעון שוכבת שם חולה עם חום גבוה. התלמידים פנו מיד אל ישוע וביקשו את עזרתו. ");
INSERT INTO heblb_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","ישוע ניגש אל מיטת החולה, אחז בידה ועזר לה לשבת. החום נעלם מיד, היא קמה ממיטתה והכינה להם אוכל. ");
INSERT INTO heblb_vpl VALUES ("MK1_32‏","071_1_32‏","MRK","1","32‏","33","עם שקיעת השמש התמלאה חצר הבית בחולים ואנשים אחוזי שדים, אשר הובאו אל ישוע כדי שירפא אותם. ליד הבית התאספו כל אנשי העיירה מתוך סקרנות. ");
INSERT INTO heblb_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","ישוע ריפא אנשים רבים שהיו חולים במחלות שונות, וגירש שדים רבים (אולם הוא לא הרשה לשדים לדבר, משום שידעו מי הוא). ");
INSERT INTO heblb_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","למחרת בבוקר, עוד לפני זריחת השמש, קם ישוע והלך למקום שקט ומבודד כדי להתפלל. ");
INSERT INTO heblb_vpl VALUES ("MK1_36‏","071_1_36‏","MRK","1","36‏","37","שמעון והאחרים יצאו בעקבותיו, וכשמצאו אותו קראו: ”לאן אתה הולך? כולם מחפשים אותך!“ ");
INSERT INTO heblb_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","”איננו יכולים להישאר כל הזמן במקום אחד“, השיב ישוע. ”עלינו ללכת גם למקומות אחרים, כדי לספר לאנשים על מלכות אלוהים; הרי לשם כך באתי!“ ");
INSERT INTO heblb_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","ישוע עבר בכל רחבי הגליל, לימד בבתי־הכנסת וגירש שדים מהרבה אנשים. ");
INSERT INTO heblb_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","פעם בא אליו אדם חולה צרעת והתחנן לפניו שירפא אותו. ”אם רק תרצה, תוכל לרפא אותי“, אמר האיש. ");
INSERT INTO heblb_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","ישוע חש חמלה רבה, ועל כן נגע במצורע ואמר: ”ודאי שאני רוצה. הירפא!“ ");
INSERT INTO heblb_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","הצרעת נעלמה מיד, והאדם נרפא כליל! ");
INSERT INTO heblb_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","”לך מהר להיבדק אצל הכוהן“, אמר ישוע לאיש בתוקף. ");
INSERT INTO heblb_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","”אל תשכח לקחת איתך קורבן טהרה, כפי שציווה משה על בני־ישראל, כדי שכולם יראו שנרפאת. אל תעצור בדרך לדבר עם איש!“ ");
INSERT INTO heblb_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","אבל האיש לא שמע בקול ישוע, והלך והכריז לכולם שהוא בריא. הוא סיפר לכולם שישוע ריפא אותו ממחלת הצרעת, וכתוצאה מכך שוב לא יכול היה ישוע להיכנס לעיר בגלוי, כי אנשים רבים הלכו אחריו לכל מקום ולא נתנו לו מנוחה. על כן הוא החליט לשבת מחוץ לעיר, אך גם זה לא הועיל, כי תוך זמן קצר מצא אותו ההמון והקיף אותו מכל עבר. ");
INSERT INTO heblb_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","כעבור ימים אחדים חזר ישוע לכפר־נחום, ומיד נפוצו שמועות על בואו בכל העיר. ");
INSERT INTO heblb_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","הבית שבו התארח התמלא במהרה עד אפס מקום. אפילו החצר הייתה מלאה אנשים, עד שלא היה מקום לאף אדם נוסף, וישוע לימד אותם את כתבי־הקודש. ");
INSERT INTO heblb_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","בין הקהל בחצר היו ארבעה אנשים שנשאו אדם משותק על אלונקה. ");
INSERT INTO heblb_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","בגלל הקהל הרב הם לא יכלו להיכנס לתוך הבית ולדבר עם ישוע. לכן הם טיפסו על הגג, הזיזו רעפים אחדים ממקומם והורידו את האלונקה אל אמצע החדר, אל המקום שבו עמד ישוע. ");
INSERT INTO heblb_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","כשראה ישוע את אמונתם, פנה אל האיש המשותק ואמר: ”בני, נסלחו לך חטאיך!“ ");
INSERT INTO heblb_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","היו כמה מורי הלכה שנכחו במקום, ואלה אמרו בלבם: ");
INSERT INTO heblb_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","”מה הוא מגדף? למי הוא חושב את עצמו, לאלוהים? הרי רק אלוהים יכול לסלוח על חטאים!“ ");
INSERT INTO heblb_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","ישוע ידע את מחשבותיהם ולכן שאל: ”מדוע דברי מטרידים אתכם? ");
INSERT INTO heblb_vpl VALUES ("MK2_9‏","071_2_9‏","MRK","2","9‏","10","לי, המשיח, יש סמכות לסלוח חטאים עלי־אדמות. אני אוכיח לכם שאני לא רק מדבר, אלא גם עושה – מיד תראו כיצד אני מרפא את האיש הזה.“ ");
INSERT INTO heblb_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","הוא פנה אל האיש המשותק ופקד עליו: ”קום! קפל את האלונקה שלך ולך לביתך, כי נרפאת!“ ");
INSERT INTO heblb_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","האיש קפץ על רגליו, קיפל את האלונקה ופילס לו דרך בתוך הקהל הנדהם. כולם היללו את אלוהים מעומק לבם וקראו בפליאה: ”אף פעם לא ראינו דבר כזה!“ ");
INSERT INTO heblb_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","ישוע יצא שוב לחוף הים. אנשים רבים התאספו סביבו והוא לימד אותם. ");
INSERT INTO heblb_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","כאשר התהלך על החוף פגש את לוי, בנו של חלפי, יושב בבית־המכס. ”בוא אתי,“ הזמינו ישוע, ”בוא והיה תלמיד שלי.“ לוי עזב את בית־המכס והלך עם ישוע. ");
INSERT INTO heblb_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","באותו ערב הזמין לוי לארוחה בביתו את גובי־המכס מהעבודה ואנשים רגילים מהרחוב, כדי שתהיה להם הזדמנות לפגוש את ישוע ותלמידיו (אנשים רבים רצו לפגוש את ישוע פנים אל פנים ולדבר איתו). ");
INSERT INTO heblb_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","אחדים מהסופרים והפרושים ראו את ישוע אוכל בחברת אנשים בעלי שם רע. ”כיצד הוא יכול לאכול עם האנשים האלה?“ שאלו את תלמידיו. ");
INSERT INTO heblb_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","ישוע שמע את שאלתם והשיב: ”החולים זקוקים לרופא ולא הבריאים. לא באתי לקרוא לצדיקים לחזור בתשובה, כי אם לחוטאים.“ ");
INSERT INTO heblb_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","תלמידי יוחנן ותלמידי הפרושים נהגו לצום, כנהוג במסורת היהודית. יום אחד באו מספר אנשים אל ישוע ושאלו אותו מדוע תלמידיו אינם צמים כמו כולם. ");
INSERT INTO heblb_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","השיב להם ישוע: ”האם ייתכן שידידי החתן יסרבו לאכול במסיבת חתונתו? האם ייתכן שיתאבלו בזמן שהחתן נמצא אתם? ");
INSERT INTO heblb_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","אולם יבוא יום שהחתן יילקח מהם, ואז הם יצומו. ");
INSERT INTO heblb_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","למה הדבר הזה דומה? לאדם התופר טלאי מבד חדש על בגד ישן ובלה; מה יקרה? הטלאי מהבד החדש יינתק ויגדיל את החור בבגד. ");
INSERT INTO heblb_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","הדבר דומה גם לאדם הממלא יין חדש בתוך חביות רקובות. הרי היין יבקע את החביות ויישפך החוצה. יין חדש יש לשמור בחביות חדשות.“ ");
INSERT INTO heblb_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","באחת השבתות הלכו ישוע ותלמידיו דרך שדה תבואה, והתלמידים קטפו שיבולים ואכלו את הגרעינים. ");
INSERT INTO heblb_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","”ראה מה הם עושים!“ התנפלו הפרושים על ישוע. ”מדוע הם קוטפים שיבולים בשבת? הלא הם עוברים על חוקי התורה ומחללים את השבת!“ ");
INSERT INTO heblb_vpl VALUES ("MK2_25‏","071_2_25‏","MRK","2","25‏","26","”האם מעולם לא קראתם מה עשה דוד המלך?“ השיב להם ישוע. ”כאשר דוד המלך ואנשיו היו רעבים הם נכנסו לאוהל מועד – בימי אביתר הכוהן – ואכלו את לחם הפנים שהיה מיועד לכוהנים בלבד. הלא גם זה היה בניגוד לחוקי התורה. ");
INSERT INTO heblb_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","דעו לכם כי השבת ניתנה למען בני־האדם, ולא בני־האדם למען השבת. ");
INSERT INTO heblb_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","ובן האדם הוא אדון השבת.“ ");
INSERT INTO heblb_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","ישוע חזר לבית־הכנסת בכפר־נחום וראה שם איש שידו משותקת. ");
INSERT INTO heblb_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","מאחר שהיום היה שבת, רצו מתנגדיו של ישוע לראות אם ירפא את האיש. הם החליטו שאם ישוע ירפא את האיש, יאסרו אותו. ");
INSERT INTO heblb_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","ישוע אמר לבעל היד המשותקת: ”בוא ועמוד לפני כולם.“ ");
INSERT INTO heblb_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","לאחר מכן הוא פנה אל הזוממים נגדו ושאל: ”על־פי התורה האם עלינו לעשות בשבת מעשים טובים, או מעשים רעים? האם עלינו להציל נפשות בשבת, או לאבד אותן?“ לא הייתה תשובה בפיהם. ");
INSERT INTO heblb_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","ישוע הביט בהם בכעס וצער, בגלל לב האבן שלהם, ואז פקד על האיש החולה: ”הושט את ידך.“ האיש הושיט את ידו והיא נרפאה כליל. ");
INSERT INTO heblb_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","הפרושים מיהרו להתייעץ עם אנשי הורדוס כיצד להיפטר מישוע. ");
INSERT INTO heblb_vpl VALUES ("MK3_7‏","071_3_7‏","MRK","3","7‏","8","ישוע ותלמידיו עזבו את בית־הכנסת והלכו לשפת הים. הקהל הרב שהלך אחריהם בא כמעט מכל קצות הארץ: מהגליל, מיהודה, מירושלים, מאדום, מעבר הירדן ואפילו מאזור צור וצידון. כל האנשים האלה הלכו אחרי ישוע מפני ששמעו על הנסים והנפלאות שחולל, וכמובן שרצו לראות אותו במו עיניהם. ");
INSERT INTO heblb_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","ישוע ביקש מתלמידיו להכין לו סירה, כדי שאם ינסה הקהל להידחק אליו ויאלץ אותו להיכנס למים, יוכל לעלות על הסירה. ");
INSERT INTO heblb_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","באותו יום הוא ריפא חולים רבים מאוד, וכתוצאה מכך הלכו והתרבו החולים שנהרו אליו מכל עבר, וכל אחד ניסה לגעת בו כדי להירפא. ");
INSERT INTO heblb_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","כאשר נגעו אנשים אחוזי־שדים בישוע, הם נפלו לפניו וצעקו: ”אתה הוא בן־האלוהים!“ ");
INSERT INTO heblb_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","אולם ישוע ציווה עליהם לשתוק ולא לגלות את זהותו. ");
INSERT INTO heblb_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","ישוע עלה על אחד ההרים והזמין אליו אנשים מסוימים מבין הקהל. ");
INSERT INTO heblb_vpl VALUES ("MK3_14‏","071_3_14‏","MRK","3","14‏","15","הוא בחר שנים־עשר איש שיהיו מלוויו הקבועים ושילכו ללמד את העם, ונתן להם סמכות לרפא חולים ולגרש שדים. ");
INSERT INTO heblb_vpl VALUES ("MK3_16‏","071_3_16‏","MRK","3","16‏","19","אלה שמות השנים־עשר שישוע בחר: שמעון כֵּיפָא (שישוע כינה אותו ”פטרוס“), יעקב ויוחנן בני־זבדי (שישוע כינה ”בני־רעם“), ‎אַנְדְּרֵי, פיליפוס, בר־תלמי, מתי, תומא, יעקב בן־חלפי, תדי, שמעון (מחבורת הקנאים) ויהודה איש קריות (אשר מאוחר יותר הסגיר את ישוע). ");
INSERT INTO heblb_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","כאשר חזר ישוע לבית מארחיו, שוב המתין לו קהל שמילא את כל הבית, כך שישוע ותלמידיו לא יכלו להפסיק ולאכול. ");
INSERT INTO heblb_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","כשנודע לבני משפחתו על כך, הם באו לקחתו לביתם. ”הוא יצא מדעתו!“ קראו. ");
INSERT INTO heblb_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","מורי הלכה מירושלים באו לשם ואמרו: ”אתם יודעים מדוע הוא יכול לגרש שדים? מפני שבעל־זבול, שר השדים, שוכן בתוכו!“ ");
INSERT INTO heblb_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","ישוע קיבץ אותם סביבו ודיבר אליהם במשלים. ”כיצד יכול השטן לגרש את השטן?“ שאל. ");
INSERT INTO heblb_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","ממלכה מפולגת לא תחזיק מעמד ותתמוטט. ");
INSERT INTO heblb_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","משפחה שיש בה חילוקי דעות ופילוגים – תיהרס. ");
INSERT INTO heblb_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","אם השטן נלחם נגד עצמו, מה יוכל להשיג? ");
INSERT INTO heblb_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","איש אינו יכול לשדוד את מלכות השטן לפני שיכבול אותו תחילה. לאחר שיכבול את השטן, יוכל לשדוד את רכושו. ");
INSERT INTO heblb_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","”אני מזהיר אתכם,“ המשיך ישוע, ”כל החטאים וגידופים ייסלחו לבני האדם. ");
INSERT INTO heblb_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","רק חטא אחד לעולם לא ייסלח – גידוף רוח הקודש.“ ");
INSERT INTO heblb_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","ישוע מצא לנכון להזהיר אותם, שכן טענו שהוא חולל נסים בכוחו של השטן (במקום שיודו שהוא חולל נסים בכוחו של רוח הקודש). ");
INSERT INTO heblb_vpl VALUES ("MK3_31‏","071_3_31‏","MRK","3","31‏","32","בינתיים באו אמו ואחיו של ישוע אל הבית שבו לימד. הם שלחו מישהו לקרוא לישוע החוצה, כי רצו לדבר איתו. ”אמך ואחיך מחכים לך בחוץ; הם רוצים לדבר אתך“, אמר לו מישהו. ");
INSERT INTO heblb_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","”מי היא אמי?“ ”מי הם אחי?“ קרא ישוע. ");
INSERT INTO heblb_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","הוא הביט באנשים סביבו והכריז: ”הנה אמי ואחי! ");
INSERT INTO heblb_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","כל השומע בקול אלוהים הוא אחי, אחותי ואמי.“ ");
INSERT INTO heblb_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","פעם אחרת, כשלימד ישוע על החוף, התאסף סביבו קהל עצום; האנשים נדחפו ונדחקו עד כי לא היה לו מקום לעמוד. ישוע התיישב בסירה שהכינו לו תלמידיו, וכל האנשים נשארו על החוף. ");
INSERT INTO heblb_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","בדרך כלל הוא לימד את הקהל בסיפורים ובמשלים, והנה אחד מהם: ");
INSERT INTO heblb_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","”שימו לב! איכר אחד יצא לזרוע. כשפיזר את הזרעים בשדה ");
INSERT INTO heblb_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","נפלו חלקם על השביל בצד הדרך, והציפורים באו וניקרו אותם. ");
INSERT INTO heblb_vpl VALUES ("MK4_5‏","071_4_5‏","MRK","4","5‏","6","חלקם נפלו על אדמת סלעים ומיד הצמיחו נבטים יפים, אולם כעבור זמן קצר נבלו ומתו, מפני שלא יכלו להכות שורשים עמוקים. ");
INSERT INTO heblb_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","חלקם נפלו בין קוצים, ואלה חנקו את הצמחים הרכים. ");
INSERT INTO heblb_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","אולם חלק אחר מהזרעים נפל על אדמה טובה, ונשא פרי מבורך ורב פי שלושים, פי שישים ואפילו פי מאה. ");
INSERT INTO heblb_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","מי שמסוגל לשמוע, שיקשיב!“ ");
INSERT INTO heblb_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","כשנשאר ישוע לבדו עם השנים־עשר ושאר התלמידים, הם שאלו אותו: ”רבי, למה התכוונת במשל?“ ");
INSERT INTO heblb_vpl VALUES ("MK4_11‏","071_4_11‏","MRK","4","11‏","12","”לכם מותר לדעת את סוד מלכות האלוהים,“ ענה להם ישוע, ”אך אלה שמחוץ למלכות האלוהים שומעים רק משלים. למרות שהם רואים ושומעים, הם אינם מבינים ואינם מאמינים באלוהים, ועל כן אין להם סליחת חטאים. ");
INSERT INTO heblb_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","אבל אם אינכם מבינים את המשל הפשוט הזה, כיצד תבינו את שאר המשלים שאני עומד לספר? ");
INSERT INTO heblb_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","”האיכר במשל הוא כל אדם שמספר לאחרים את בשורת אלוהים, שכן הוא מנסה לזרוע בלבם את דבר־אלוהים. ");
INSERT INTO heblb_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","השביל בצד מסמל את לב האנשים השומעים את דבר אלוהים, אך מיד בא השטן ומנסה להשכיח מלבם את אשר שמעו. ");
INSERT INTO heblb_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","אדמת הסלעים מסמלת את לבם של אלה השומעים את הבשורה ומקבלים אותה בהתלהבות ובשמחה, ");
INSERT INTO heblb_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","אך אינם מעמיקים ואינם מתבססים באמונתם. לכן ברגע שצצים קשיים ראשונים הם אינם מחזיקים מעמד. ");
INSERT INTO heblb_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","”אדמת הקוצים מסמלת את לבם של אלה השומעים את דבר אלוהים ומאמינים בו, ");
INSERT INTO heblb_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","אולם תוך זמן קצר תענוגות העולם והרדיפה אחר עושר והצלחה תופסים את המקום החשוב בלבם, ודוחקים הצידה את דבר אלוהים. משום כך לא רואים שום פרי בחייהם. ");
INSERT INTO heblb_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","”ואילו האדמה הטובה מסמלת את לבם של אלה המאמינים באמת בדבר־אלוהים, והפרי המבורך בחייהם רב, פי שלושים, פי שישים ואפילו פי מאה ממה שנזרע בלבם.“ ");
INSERT INTO heblb_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","ישוע המשיך ואמר: ”כשאדם מדליק נר בחשכה, האם הוא מחביא את הנר הדולק מתחת למיטה, כדי שאיש לא יראה את האור? תפקיד הנר להאיר, ולכן שמים אותו במקום מרכזי – במקום שבו יביא תועלת רבה ביותר. ");
INSERT INTO heblb_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","”כל הנסתר עתה ייגלה בבוא העת. ");
INSERT INTO heblb_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","מי שאוזניים לו, שיקשיב! ");
INSERT INTO heblb_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","”קיימו באופן מעשי את מה שאתם שומעים. כפי שאתם מתנהגים עם אחרים כך יתנהגו איתכם. ");
INSERT INTO heblb_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","מי שיש לו – יינתן לו עוד; ומי שאין לו – גם המעט שבידו יילקח ממנו.“ ");
INSERT INTO heblb_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","ישוע סיפר להם משל נוסף על מלכות אלוהים: ”איכר אחד זרע זרעים בשדה שלו, ");
INSERT INTO heblb_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","ולאחר שסיים את הזריעה הלך לדרכו. כעבור זמן מה צמחו הזרעים וגדלו ללא עזרת האיכר; ");
INSERT INTO heblb_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","האדמה הצמיחה בעצמה את הזרעים. תחילה צמח עלה ראשון, אחריו הגבעול וראש השיבולת, ולבסוף הבשילו הגרגרים. ");
INSERT INTO heblb_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","אז בא האיכר וקצר את התבואה.“ ");
INSERT INTO heblb_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","”כיצד אוכל לתאר את מלכות אלוהים?“ שאל ישוע. ”למה אפשר לדמות את מלכות אלוהים? ");
INSERT INTO heblb_vpl VALUES ("MK4_31‏","071_4_31‏","MRK","4","31‏","32","מלכות אלוהים דומה לגרגר זעיר של צמח החרדל. אף כי גרגר זה זעיר ביותר, הוא גדל להיות אחד הצמחים הגדולים ביותר, בעל ענפים ארוכים וחסונים, וציפורים שונות יכולות לבנות בצילו קן ומחסה.“ ");
INSERT INTO heblb_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","ישוע סיפר להם משלים רבים על דבר־אלוהים, לפי יכולת הבנתם. ");
INSERT INTO heblb_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","למעשה הוא לימד את הציבור רק במשלים, וכאשר נשאר עם התלמידים לבדם נהג לבאר להם אותם. ");
INSERT INTO heblb_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","לפנות ערב אמר ישוע לתלמידיו: ”הבה נעבור לגדה השנייה של הכינרת.“ ");
INSERT INTO heblb_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","הם עזבו את הקהל מאחוריהם והתרחקו מהמקום בסירה שבה ישב ישוע, אך הסירות האחרות שטו בעקבותיהם. ");
INSERT INTO heblb_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","לפתע פרצה סערה גדולה; גלים חזקים וגבוהים הכו בסירה ומילאו אותה מים עד שכמעט טבעה. ");
INSERT INTO heblb_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","באותו זמן ישן ישוע בשלווה בתוך הסירה. התלמידים העירו אותו בבהלה ופחד: ”רבי, קום! אנחנו עומדים לטבוע, ולך לא אכפת?“ ");
INSERT INTO heblb_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","ישוע קם, נזף ברוח ופקד על הים להירגע. מיד שקטה הרוח והים נרגע. ");
INSERT INTO heblb_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","לאחר מכן הוא פנה אל תלמידיו ושאל בתמיהה: ”מדוע נבהלתם כל־כך? עדיין אינכם מאמינים בי?“ ");
INSERT INTO heblb_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","התלמידים נמלאו פחד ושאלו זה את זה: ”מיהו האיש הזה שאף הרוח והים נשמעים לו?“ ");
INSERT INTO heblb_vpl VALUES ("MK5_1‏","071_5_1‏","MRK","5","1‏","2","בהגיעם אל הגדה השנייה של הכינרת ירד ישוע מהסירה, והנה רץ לקראתו מכיוון בית־הקברות איש אחוז רוח רעה. ");
INSERT INTO heblb_vpl VALUES ("MK5_3‏","071_5_3‏","MRK","5","3‏","4","איש זה גר בבית־הקברות והיה בעל כוח פיזי אדיר. בכל פעם שאסרו אותו בכבלים ושרשרות הוא היה מנתק אותם בקלות ויוצא לחופשי. איש לא היה יכול להתגבר עליו. ");
INSERT INTO heblb_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","יומם ולילה נהג להסתובב כמשוגע בין הקברים ועל ההרים, צועק ופוצע את עצמו באבנים חדות. ");
INSERT INTO heblb_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","בראותו את ישוע מרחוק, רץ האיש לקראתו ונפל לרגליו. ");
INSERT INTO heblb_vpl VALUES ("MK5_7‏","071_5_7‏","MRK","5","7‏","8","ישוע פקד על השד שבתוך האיש: ”צא החוצה, שד!“ השד צעק צעקה מחרידה: ”מה אתה עומד לעשות לי, ישוע בן אל־עליון? למען אלוהים, אל תייסר אותי!“ ");
INSERT INTO heblb_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","”מה שמך?“ שאל ישוע. ”לגיון“, השיב השד. ”אינני לבדי; אנחנו כאן שדים רבים.“ ");
INSERT INTO heblb_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","השדים התחננו לפני ישוע שלא ישלח אותם למקום נידח. ");
INSERT INTO heblb_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","בקרבת המקום היה עדר גדול של חזירים שרעה במורד ההרים. ");
INSERT INTO heblb_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","”שלח אותנו לתוך החזירים האלה“, התחננו השדים. ");
INSERT INTO heblb_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","ישוע הסכים, והם יצאו מהאיש ונכנסו לתוך החזירים. כל החזירים (בערך אלפיים) דהרו בטירוף במורד ההר ישר לתוך הים וטבעו. ");
INSERT INTO heblb_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","רועי החזירים ברחו לערים ולכפרים שבסביבה, וסיפרו לכולם מה שקרה. כל האנשים רצו מיד אל המקום כדי לראות את המחזה במו עיניהם. ");
INSERT INTO heblb_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","עד מהרה התאספו אנשים רבים ליד ישוע, אולם כשראו את האיש יושב לרגלי ישוע לבוש היטב ושפוי בדעתו, נמלאו פחד. ");
INSERT INTO heblb_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","עדי ראייה סיפרו לבאים מה שהתרחש, ");
INSERT INTO heblb_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","והאנשים התחננו לפני ישוע שילך משם ויעזוב אותם לנפשם. ");
INSERT INTO heblb_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","כשחזר ישוע לסירה התחנן לפניו האיש שיצאו ממנו השדים שירשה לו להצטרף אליו. ");
INSERT INTO heblb_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","אולם ישוע לא הסכים לכך. ”לך הביתה למשפחתך ולחבריך“, אמר ישוע. ”ספר להם כיצד ריחם עליך אלוהים, ואיזה נס חולל בך.“ ");
INSERT INTO heblb_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","האיש הלך לבקר בעשר הערים הגדולות וסיפר לאנשים על הפלא הגדול שחולל ישוע, וכולם התפלאו מאוד. ");
INSERT INTO heblb_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","ישוע חצה בסירתו את הכינרת והגיע אל הגדה שממול, שם כבר חיכה לו קהל רב. ");
INSERT INTO heblb_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","אחד מראשי בית־הכנסת המקומי, יאיר שמו, נפל לפני ישוע ");
INSERT INTO heblb_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","והתחנן בפניו שירפא את בתו הקטנה. ”בתי גוססת“, קרא יאיר בייאוש. ”אנא, בוא לביתי ושים את ידיך עליה, כדי שתבריא ותחיה.“ ");
INSERT INTO heblb_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","ישוע הלך עם יאיר, והקהל הגדול הלך אחריהם, נדחף ונדחק סביב ישוע. ");
INSERT INTO heblb_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","בקרב הקהל הייתה אישה שסבלה משטף דם מתמיד במשך שתים־עשרה שנה. ");
INSERT INTO heblb_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","היא סבלה קשות מטיפולים של רופאים שונים, ולאחר שהוציאה את כל כספה, לא זו בלבד שמצבה לא השתפר, הוא אף החמיר! ");
INSERT INTO heblb_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","היא שמעה על המעשים שישוע עשה, ולכן הלכה אחריו ונגעה בבגדו. ");
INSERT INTO heblb_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","”אם רק אצליח לגעת בבגדיו אהיה בריאה“, חשבה לעצמה. ");
INSERT INTO heblb_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","ואכן, ברגע שנגעה בבגדו פסק שטף הדם, והאישה ידעה שנרפאה. ");
INSERT INTO heblb_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","באותו רגע הרגיש ישוע שיצא ממנו כוח ריפוי. הוא הסתובב לאחור ושאל: ”מי נגע בי?“ ");
INSERT INTO heblb_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","תלמידיו התפלאו על השאלה המשונה והשיבו: ”ראה כמה אנשים נדחפים אליך מכל צד, ואתה שואל מי נגע בך?“ ");
INSERT INTO heblb_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","אולם ישוע התעלם מהערתם והמשיך להסתכל סביבו, מחפש את מי שנגע בו. ");
INSERT INTO heblb_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","האישה, אשר ידעה כי נרפאה, התקרבה אליו, נפלה לרגליו בפחד ובחרדה וסיפרה לו את כל האמת. ");
INSERT INTO heblb_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","”בתי, אמונתך ריפאה אותך!“ אמר לה ישוע. ”היי בריאה ולכי לשלום.“ ");
INSERT INTO heblb_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","בזמן שישוע דיבר אל האישה, הגיעו למקום שליחים מביתו של יאיר והודיעו לאב: ”בתך מתה; אין צורך להטריח את המורה.“ ");
INSERT INTO heblb_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","אולם ישוע התעלם מכך ואמר ליאיר: ”אל תפחד; רק תאמין!“ ");
INSERT INTO heblb_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","ישוע עצר את הקהל ולא הרשה לאיש ללכת איתו, פרט לפטרוס, יעקב ויוחנן. ");
INSERT INTO heblb_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","בהגיעם לביתו של יאיר מצאו את כולם בוכים ומתאבלים על מות הילדה. ");
INSERT INTO heblb_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","ישוע נכנס פנימה ושאל את האנשים: ”מדוע אתם בוכים ומתרגשים? הילדה לא מתה; היא רק ישנה.“ ");
INSERT INTO heblb_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","כל הנוכחים לעגו לו, אולם הוא לא שם לב לכך וביקש מכולם לצאת משם. הוא לקח את ההורים ואת תלמידיו ונכנס איתם לחדרה של הילדה. ");
INSERT INTO heblb_vpl VALUES ("MK5_41‏","071_5_41‏","MRK","5","41‏","42","ישוע אחז בידה של הילדה וקרא: ”טליתא, קומי!“ (כלומר: ”קומי, ילדה!“) היא הייתה בת 12 והיא אכן קמה ממיטתה והתהלכה בבית. הוריה התפלאו מאוד, ");
INSERT INTO heblb_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","אך ישוע הזהיר אותם שלא יספרו לאף אחד מה שקרה, וביקש שיתנו לילדה משהו לאכול. ");
INSERT INTO heblb_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","זמן קצר לאחר מכן חזרו ישוע ותלמידיו לנצרת – עירו של ישוע. ");
INSERT INTO heblb_vpl VALUES ("MK6_2‏","071_6_2‏","MRK","6","2‏","3","בשבת הלך ישוע לבית הכנסת ולימד את הקהל. אנשים רבים התפלאו מאוד על חוכמתו ועל הניסים שחולל. אך הם ידעו שהוא אחד מהם ושהוא גר בסביבה וקראו: ”הוא אינו טוב מאתנו. הוא סך הכול נגר פשוט, בנה של מרים ואחיהם של יעקב, יוסף, יהודה ושמעון; ואחיותיו גרות כאן בינינו.“ הדבר גרם להם עלבון. ");
INSERT INTO heblb_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","”הנביא הוא מכובד רק בקרב אנשים זרים“, השיב להם ישוע. ”בני עירו, בני משפחתו וחבריו לעולם אינם מכבדים אותו.“ ");
INSERT INTO heblb_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","בגלל חוסר אמונתם לא יכול היה ישוע לעשות שם מעשי גבורה גדולים. הוא רק הניח את ידיו על מספר חולים וריפא אותם. ");
INSERT INTO heblb_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","חוסר אמונתם הדהים אותו מאוד. לאחר מכן עבר ישוע מכפר לכפר ולימד את האנשים. ");
INSERT INTO heblb_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","הוא קרא אליו את שנים־עשר התלמידים, נתן להם סמכות וכוח לגרש רוחות רעות ושדים, ושלח אותם בזוגות אל הכפרים והערים. ");
INSERT INTO heblb_vpl VALUES ("MK6_8‏","071_6_8‏","MRK","6","8‏","9","הוא אמר להם שלא ייקחו איתם דבר מלבד מקל הליכה; לא מזון, לא שמיכות, לא כסף ולא בגדים נוספים או זוג נעליים נוסף. ");
INSERT INTO heblb_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","”בכל כפר הישארו אצל מארח אחד בלבד; אל תעברו ממקום למקום“, הורה להם ישוע. ");
INSERT INTO heblb_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","”אם במקום כלשהו לא יקבלו אתכם ולא יקשיבו לכם, לכו משם. אך לפני שתלכו נקו את האבק מרגליכם, כדי שהאנשים יראו שמילאתם את חובתכם ועתה הנכם עוזבים אותם לגורלם.“ ");
INSERT INTO heblb_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","וכך יצאו השליחים לדרך. לכל מי שפגשו בדרך קראו לחזור בתשובה ולהפסיק לחטוא. ");
INSERT INTO heblb_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","הם גרשו שדים רבים, ריפאו הרבה חולים ומשחו אותם בשמן. ");
INSERT INTO heblb_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","גם המלך הורדוס שמע על אודות ישוע, משום שכולם דיברו על הניסים שחולל. המלך חשב את ישוע ליוחנן המטביל שקם לתחייה, ולכן אמר: ”איני מתפלא על כך שהוא יכול לעשות ניסים ונפלאות.“ ");
INSERT INTO heblb_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","אנשים אחרים חשבו את ישוע לאליהו הנביא שקם לתחייה; היו שטענו כי ישוע הוא נביא חדש בדומה לנביאים שחיו בעבר. ");
INSERT INTO heblb_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","”לא“, אמר המלך הורדוס בהחלטיות. ”אני בטוח שזהו יוחנן, האיש שאת ראשו כרתי. הוא קם לתחייה!“ ");
INSERT INTO heblb_vpl VALUES ("MK6_17‏","071_6_17‏","MRK","6","17‏","18","זמן מה קודם לכן שלח הורדוס חיילים לאסור את יוחנן, כי יוחנן אמר שאסור להורדוס להתחתן עם הורודיה – אשת אחיו פיליפוס. ");
INSERT INTO heblb_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","הורודיה שנאה את יוחנן בשל כך ורצתה במותו כנקמה, אולם לשם כך היה עליה לקבל את רשותו של הורדוס. ");
INSERT INTO heblb_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ואילו הורדוס כיבד את יוחנן ולא הרשה להורודיה לפגוע בו, כי ידע שיוחנן הוא אדם ישר וקדוש. הורדוס אהב מאוד להקשיב לדברי יוחנן אף כי גרמו לו מבוכה. ");
INSERT INTO heblb_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","ביום הולדתו של הורדוס הייתה להורודיה הזדמנות מצוינת להשיג את מבוקשה. המלך ערך מסיבה גדולה לכל האנשים החשובים, לקציני הצבא ולמושלי הגליל. ");
INSERT INTO heblb_vpl VALUES ("MK6_22‏","071_6_22‏","MRK","6","22‏","23","בתה של הורודיה נכנסה לאולם ושעשעה את האורחים בריקודים. הורדוס נהנה כל־כך מריקודיה עד שנשבע בפזיזות: ”חי נפשי, את יכולה לבקש ממני כל מה שתרצי ואני מבטיח שתקבלי זאת; עד חצי המלכות אתן לך!“ ");
INSERT INTO heblb_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","הבת יצאה מהאולם בהתרגשות ומיהרה להתייעץ עם אמה. הורודיה הורתה לה מיד: ”בקשי ממנו את ראשו של יוחנן המטביל!“ ");
INSERT INTO heblb_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","הבת מיהרה חזרה אל המלך וקראה: ”אני רוצה את ראשו של יוחנן המטביל על מגש ומיד!“ ");
INSERT INTO heblb_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","המלך נמלא צער רב, אך לא יכול היה להפר את שבועתו בנוכחות האורחים, ");
INSERT INTO heblb_vpl VALUES ("MK6_27‏","071_6_27‏","MRK","6","27‏","28","אז שלח את אחד משומרי ראשו אל הכלא, כדי לכרות את ראשו של יוחנן. השומר כרת את ראשו של יוחנן והביאו חזרה על מגש. הוא מסר את המגש לבת, וזו מסרה אותו לאמה. ");
INSERT INTO heblb_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","כאשר שמעו תלמידי יוחנן מה שקרה, באו לקחת את גופתו וקברו אותה לפי הדת. ");
INSERT INTO heblb_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","בינתיים חזרו השליחים ממסעם וסיפרו לישוע כל מה שעשו ולימדו. ");
INSERT INTO heblb_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","”הבה ניקח חופשה קצרה מן הקהל הרב הזה וננוח במקום שקט – הרחק מכול המולה“, הציע ישוע, כי אנשים כה רבים באו אליהם, כך שלא היה להם זמן לאכול. ");
INSERT INTO heblb_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","ישוע ותלמידיו הפליגו בסירה למקום שבו קיוו לנוח. ");
INSERT INTO heblb_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","אך אנשים רבים ראו אותם בעת שעזבו ורצו לפניהם לאורך החוף; הם כבר המתינו לישוע ותלמידיו במקום שבו עגנה הסירה. ");
INSERT INTO heblb_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","כאשר ירד ישוע מהסירה וראה את הקהל שחיכה לו על החוף, נמלא חמלה, כי הם נראו בעיניו כעדר ללא רועה. הוא לימד אותם דברים רבים שהיה עליהם לדעת. ");
INSERT INTO heblb_vpl VALUES ("MK6_35‏","071_6_35‏","MRK","6","35‏","36","עם רדת הערב באו התלמידים לישוע וביקשוהו: ”אמור לכל האנשים האלה שילכו לקנות מזון בכפרי הסביבה, כי השעה מאוחרת ובמקום השומם הזה אין דבר לאכול.“ ");
INSERT INTO heblb_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","”אתם בעצמכם תאכילו אותם.“ השיב ישוע. ”במה נאכיל אותם?“ שאלו התלמידים בתמיהה. ”נצטרך הון תועפות כדי לקנות אוכל לכל האנשים האלה!“ ");
INSERT INTO heblb_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","”לכו לראות כמה ככרות לחם יש לנו“, אמר ישוע. הם חזרו ואמרו: ”יש בידינו חמש ככרות לחם ושני דגים.“ ");
INSERT INTO heblb_vpl VALUES ("MK6_39‏","071_6_39‏","MRK","6","39‏","40","ישוע ביקש מהקהל לשבת על הדשא, ולשבת בשורות של חמישים או מאה איש. ");
INSERT INTO heblb_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","הוא לקח את חמש ככרות הלחם ואת שני הדגים, הביט לשמים, ביקש מאלוהים שיברך את האוכל. לאחר מכן פרס את הלחם ונתן לכל אחד מתלמידיו פרוסת לחם וחתיכת דג, כדי שיגישו לקהל. ");
INSERT INTO heblb_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","והאנשים אכלו עד ששבעו לחלוטין! ");
INSERT INTO heblb_vpl VALUES ("MK6_43‏","071_6_43‏","MRK","6","43‏","44","כחמשת־אלפים גברים (לא כולל נשים וילדים) השתתפו בארוחה, ולבסוף כשנאספו הפירורים והשאריות מהארץ הם מילאו שנים־עשר סלים. ");
INSERT INTO heblb_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","בתום הארוחה ביקש ישוע מתלמידיו לעלות לסירה ולשוט לבית־צידה, שם יפגוש אותם מאוחר יותר. ישוע עצמו נשאר להיפרד מהקהל ולשלח אותו הביתה. ");
INSERT INTO heblb_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","לאחר שעזבו כולם עלה ישוע על אחד ההרים להתפלל. ");
INSERT INTO heblb_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","בלילה, בזמן שהתלמידים היו בסירה באמצע הים וישוע היה על החוף, ");
INSERT INTO heblb_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","הוא ראה שתלמידיו בצרה – שהם חותרים בחוזקה ונאבקים עם הרוח והגלים. בערך בשעה שלוש בבוקר הלך אליהם ישוע כשהוא פוסע על־פני המים, ");
INSERT INTO heblb_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","אולם כשראו התלמידים אדם הולך על־פני המים, נבהלו מאוד וצרחו מפחד, כי חשבו שראו רוח רפאים. ");
INSERT INTO heblb_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","ישוע דיבר אליהם מיד והרגיע אותם: ”אל תפחדו; זה אני!“ ");
INSERT INTO heblb_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","הוא עלה לסירה והרוח פסקה. התלמידים ישבו שם נבוכים לגמרי ולא הבינו כיצד זה קרה, ");
INSERT INTO heblb_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","כי למרות הפלא של הערב הקודם הם עדיין לא הפנימו את מה שקרה. ");
INSERT INTO heblb_vpl VALUES ("MK6_53‏","071_6_53‏","MRK","6","53‏","54","ישוע ותלמידיו הגיעו לגינוסר, קשרו את הסירה ועלו לחוף. אנשי המקום הכירו מיד את ישוע, ");
INSERT INTO heblb_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ומיהרו לספר לכל אנשי הסביבה את דבר בואו. האנשים החלו להביא אליו חולים רבים על מיטות ואלונקות. ");
INSERT INTO heblb_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","הם נשאו את החולים לכל מקום שישוע הלך – לכפר, לעיר או לשדה – והתחננו לפניו שירשה להם לפחות לגעת בכנף בגדו; וכל מי שנגע בו נרפא. ");
INSERT INTO heblb_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","יום אחד באו אחדים מהפרושים והסופרים אל ישוע כדי לחקור את מעשיו. ");
INSERT INTO heblb_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","הם הבחינו בכך שכמה מתלמידיו של ישוע אינם נוטלים ידיים לפני הארוחה, כפי שנהוג במסורת היהודית. ");
INSERT INTO heblb_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(במסורת היהודית של אז, במיוחד אצל הפרושים, נהגו ליטול ידיים עד למרפק לפני כל ארוחה. ");
INSERT INTO heblb_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","גם בשובם מן השוק עליהם ליטול ידיים לפני שהם נוגעים באוכל. זוהי רק דוגמה אחת ממנהגים רבים שהם מקיימים מאות שנים. דוגמה נוספת היא הכשרת סירים, מחבתות וכלים.) ");
INSERT INTO heblb_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","הם שאלו את ישוע: ”מדוע התלמידים שלך אינם שומרים את מסורת אבותינו הדורשת נטילת ידיים לפני הארוחה?“ ");
INSERT INTO heblb_vpl VALUES ("MK7_6‏","071_7_6‏","MRK","7","6‏","7","”צבועים שכמוכם!“ ענה להם ישוע. ”הנביא ישעיהו תיאר אתכם נכונה כשאמר: ’ניגש העם הזה בפיו, ובשפתיו כבדוני, ולבו רחק ממני, ותהי יראתם אותי מצות אנשים מלומדה‘. ");
INSERT INTO heblb_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","”אתם מתעלמים ממצוותיו של אלוהים, ובמקומם אתם ממציאים מצוות ומנהגים למיניהם. ");
INSERT INTO heblb_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","ביטלתם את מצוות אלוהים כדי שתוכלו לקיים את המסורת שהמצאתם בעצמכם! ");
INSERT INTO heblb_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","קחו למשל את המצווה ’כבד את אביך ואת אמך‘. משה אמר שכל מקלל אביו ואמו מות יומת! ");
INSERT INTO heblb_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","ואילו אתם אומרים שמותר לאדם להתעלם מצרכי הוריו העניים, אם הוא מבטיח לתרום לעבודת אלוהים את אשר הוא חייב לתת להוריו. ");
INSERT INTO heblb_vpl VALUES ("MK7_12‏","071_7_12‏","MRK","7","12‏","13","כך אתם מפרים את מצוות אלוהים כדי לקיים את המסורת שהמצאתם אתם. זוהי רק דוגמה אחת מתוך רבות.“ ");
INSERT INTO heblb_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","ישוע אסף סביבו שנית את כל הקהל ואמר: ”הקשיבו אלי כולכם והשתדלו להבין: ");
INSERT INTO heblb_vpl VALUES ("MK7_15‏","071_7_15‏","MRK","7","15‏","16","לא מה שנכנס אל גופכם מטמא אתכם, אלא מה שיוצא מתוכו. כל מי שיש לו אוזניים שישמע!“ ");
INSERT INTO heblb_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","לאחר שעזבו את הקהל והגיעו הביתה, שאלו התלמידים את ישוע למה התכוון במשל שסיפר. ");
INSERT INTO heblb_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","”מה, גם אתם אינכם מבינים?“ שאל ישוע בתימהון. ”האם אינכם מבינים כי האוכל שאתם אוכלים אינו מטמא אתכם? ");
INSERT INTO heblb_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","הרי האוכל אינו בא במגע עם הלב; האוכל עובר דרך מערכת העיכול.“ ");
INSERT INTO heblb_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","ישוע הוסיף ואמר: ”המחשבות הן המטמאות את האדם. ");
INSERT INTO heblb_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","כי מקרב לב האדם יוצאות מחשבות רעות של ניאוף, גניבה, רצח, ");
INSERT INTO heblb_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","בגידה, רדיפת בצע, רשעות, רמאות, פריצות, קנאה, הוצאת־דיבה, גאווה, ניבול־פה וכדומה. ");
INSERT INTO heblb_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","כל הדברים הנתעבים האלה יוצאים מתוך לב האדם, והם המטמאים והמרחיקים אותנו מאלוהים.“ ");
INSERT INTO heblb_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","ישוע עזב את הגליל והלך לאזור צור וצידון. הוא ניסה להסתיר את דבר בואו, אך לא עלה בידו. כמו תמיד נפוצו השמועות על בואו במהירות. ");
INSERT INTO heblb_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","לאישה אחת הייתה בת אחוזת שד. כאשר שמעה האישה על בואו של ישוע באה אליו, נפלה לרגליו ");
INSERT INTO heblb_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","והתחננה לפניו שיגרש את השד מבתה (היא הייתה אישה יוונית שנולדה בפניקיה הסורית). ");
INSERT INTO heblb_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","”תחילה עלי לעזור לבני עמי – היהודים“, ענה לה ישוע. ”אין זה צודק לקחת את לחמם של הילדים ולהשליכו לכלבים.“ ");
INSERT INTO heblb_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","”נכון, אדוני“, ענתה האישה. ”אולם גם גורי הכלבים מקבלים תחת השולחן את השאריות והפירורים מצלחות הילדים.“ ");
INSERT INTO heblb_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","ישוע אמר לה: ”בגלל תשובתך בתך נרפאה; לכי לביתך ותראי שהשד יצא ממנה.“ ");
INSERT INTO heblb_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","האישה הלכה לביתה ומצאה את בתה הקטנה שוכבת רגועה על מיטתה לאחר שיצא ממנה השד. ");
INSERT INTO heblb_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","מצור הלך ישוע לצידון, ומשם חזר לים הכינרת דרך אזור עשר הערים. ");
INSERT INTO heblb_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","ההמון הביא אליו איש חרש ואילם, וכולם התחננו לפניו שישים את ידיו על האיש וירפא אותו. ");
INSERT INTO heblb_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","ישוע הרחיק את החרש־אילם מההמון, הכניס את אצבעותיו לאוזני האיש, לאחר מכן ירק על אצבעותיו ונגע בלשונו של האילם. ");
INSERT INTO heblb_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","ישוע נשא את עיניו לשמים, נאנח וקרא: ”אפתח“ (”היפתח!“). ");
INSERT INTO heblb_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","מיד נפתחו אוזני האיש והוא שמע. גם לשונו הותרה והוא היה מסוגל לדבר ולשמוע היטב. ");
INSERT INTO heblb_vpl VALUES ("MK7_36‏","071_7_36‏","MRK","7","36‏","37","ישוע ביקש מהנוכחים שלא להפיץ את הדבר. אולם ככל שהרבה להזהירם, כך הם הרבו לספר לאחרים, כי מעשיו הדהימו אותם כל כך. שוב ושוב קראו האנשים בהתרגשות: ”ראו איזה מעשים נפלאים ונהדרים; הוא אפילו מסוגל לרפא חרשים־אילמים!“ ");
INSERT INTO heblb_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","יום אחד כשהתאסף קהל גדול סביב ישוע, שוב לא היה להם מה לאכול. ישוע כינס את תלמידיו כדי לדון במצב. ");
INSERT INTO heblb_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","”אני מרחם על האנשים האלה“, אמר. ”הם נמצאים כאן כבר שלושה ימים, ונגמר להם האוכל. ");
INSERT INTO heblb_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","אם אשלח אותם הביתה רעבים, הם יתעלפו בדרך, מפני שחלקם באו ממקומות רחוקים.“ ");
INSERT INTO heblb_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","”מאין נמצא להם אוכל במקום השומם הזה?“ שאלו התלמידים בפליאה. ");
INSERT INTO heblb_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","”כמה ככרות לחם יש לכם?“ שאל אותם ישוע. ”שבע“, השיבו. ");
INSERT INTO heblb_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","ישוע ביקש מהקהל לשבת על הארץ. הוא לקח את שבע ככרות הלחם, הודה לאלוהים עליהן, פרס את הלחם לפרוסות ונתן לתלמידיו כדי שיגישו לקהל. ");
INSERT INTO heblb_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","הם מצאו גם כמה דגים קטנים. ישוע ברך עליהם וביקש מתלמידיו להגישם לקהל. ");
INSERT INTO heblb_vpl VALUES ("MK8_8‏","071_8_8‏","MRK","8","8‏","9","למרבה הפלא אכלו כולם עד ששבעו, ולאחר מכן שלח אותם ישוע הביתה. כארבעת־אלפים איש השתתפו בארוחה באותו יום, וכשאספו את השאריות והפירורים הם מילאו שבעה סלים גדולים! ");
INSERT INTO heblb_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","מיד לאחר מכן עלו ישוע ותלמידיו לסירה ושטו לאזור דלמנותא. ");
INSERT INTO heblb_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","הפרושים בדלמנותא שמעו על בואו, ובאו להתווכח איתו ולנסותו. הם אמרו לישוע: ”הראה לנו אות מהשמים, ואז נאמין בך.“ ");
INSERT INTO heblb_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","ישוע נאנח אנחה עמוקה והשיב: ”לא אחולל למענכם כל פלא ולא אראה לכם כל אות מהשמים. כמה הוכחות דרושות לכם כדי שתאמינו?“ ");
INSERT INTO heblb_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","ישוע עזב אותם, חזר לסירה ושט לגדה השנייה של הכינרת. ");
INSERT INTO heblb_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","התלמידים שכחו לקחת איתם מספיק אוכל, ונותרה להם בסירה רק כיכר לחם אחת. ");
INSERT INTO heblb_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","בהיותם בסירה הזהיר ישוע את תלמידיו בתקיפות: ”היזהרו מהשאור של המלך הורדוס ושל הפרושים!“ ");
INSERT INTO heblb_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","”למה הוא מתכוון?“ שאלו התלמידים זה את זה. לבסוף הגיעו למסקנה שהוא ודאי מדבר על כך ששכחו לקחת איתם מספיק לחם. ");
INSERT INTO heblb_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","ישוע הקשיב לשיחתם והגיב: ”אתם טועים לגמרי. איני מדבר כלל על הלחם שבסירה. האם קשה לכם כל־כך להבין זאת? ");
INSERT INTO heblb_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","למה אתם לא רואים, למה אתם לא שומעים? למה אתם לא קולטים דבר? ");
INSERT INTO heblb_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","”האם שכחתם את חמשת־אלפים האנשים שהאכלתי בחמש כיכרות לחם? אמרו לי, כמה לחם נותר לאחר הארוחה?“ ”שנים־עשר סלים מלאים“, ענו התלמידים. ");
INSERT INTO heblb_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","”וכאשר האכלתי את ארבעת־אלפים האנשים בשבע ככרות לחם, כמה נותר בסוף?“ ”שבעה סלים מלאים“, השיבו התלמידים. ");
INSERT INTO heblb_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","”ואתם עוד מעזים לחשוב שאני דואג משום שיש לנו רק כיכר לחם אחת?“ ");
INSERT INTO heblb_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","בהגיעם לבית־צידה הביאו אליו מספר אנשים אדם עיוור, והתחננו לפניו שיגע בו וישיב לו את ראייתו. ");
INSERT INTO heblb_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","ישוע אחז ביד העיוור והוציאו אל מחוץ לכפר, שם ירק בעיניו והניח עליהן את ידיו. ”האם אתה רואה עכשיו?“ שאל ישוע. ");
INSERT INTO heblb_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","האיש הביט סביבו והשיב: ”כן! אני רואה אנשים; אבל הם נראים מטושטשים – כמו עצים מהלכים!“ ");
INSERT INTO heblb_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","ישוע הניח שוב את ידיו על עיני האיש, והן נרפאו כליל. עתה יכול היה האיש לראות למרחוק בבירור. ");
INSERT INTO heblb_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","ישוע שלח אותו הביתה אל משפחתו ואמר: ”אל תלך לספר את הדבר לאנשי הכפר; לך ישר הביתה.“ ");
INSERT INTO heblb_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","ישוע ותלמידיו עזבו את הגליל והלכו לכפרי קיסריה של פיליפוס. בדרך שאל ישוע את תלמידיו: ”מה אומרים עלי אנשים? למי הם חושבים אותי?“ ");
INSERT INTO heblb_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","”יש אנשים שחושבים שאתה יוחנן המטביל,“ ענו התלמידים, ”ואחרים חושבים שאתה אליהו הנביא או נביא אחר.“ ");
INSERT INTO heblb_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","”ומי אתם חושבים שאני?“ המשיך ישוע לשאול. ”אתה המשיח!“ קרא פטרוס. ");
INSERT INTO heblb_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","אולם ישוע הזהיר אותם שלא יגלו זאת לאיש. ");
INSERT INTO heblb_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","רק מאז החל ישוע לספר להם על הייסורים המצפים לו, והוא עוד סיפר שראשי הכוהנים, הסופרים והזקנים יגרמו למותו, אך יקום לתחייה לאחר שלושה ימים. ");
INSERT INTO heblb_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","ישוע דיבר אתם בגלוי לב, אולם פטרוס לקח אותו הצידה והוכיח אותו: ”אל תדבר כך!“ ");
INSERT INTO heblb_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","ישוע הביט בפטרוס ואמר לו בחומרה: ”סור ממני, שטן שכמוך! אתה מסתכל על הדברים מנקודת ראות אנושית, ולא מנקודת ראותו של אלוהים.“ ");
INSERT INTO heblb_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","ישוע ביקש מתלמידיו להתקרב אליו ולהקשיב. ”מי שרוצה ללכת בעקבותיי עליו להתכחש לעצמו, לשאת את צלבו וללכת אחרי. ");
INSERT INTO heblb_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","מי שחפץ להציל את חייו – יאבד אותם, ואילו מי שיוותר על חייו למעני ולמען הבשורה – יציל אותם. ");
INSERT INTO heblb_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","”איזה רווח יש לאדם שיכול להשיג את כל העולם אבל מפסיד חיי־נצח? ");
INSERT INTO heblb_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","מה כבר יכול בן־אדם לתת בתמורה לחייו? ");
INSERT INTO heblb_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","דעו לכם, שכל מי שמתבייש בי ובדברי בדור החוטא וחסר האמונה הזה, הוא יהיה לבושה לבן־האדם כאשר יבוא בכבודו עם המלאכים הקדושים.“ ");
INSERT INTO heblb_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","ישוע המשיך לדבר אל תלמידיו: ”אני אומר לכם, שאחדים מכם העומדים כאן היום יזכו לחיות ולראות את מלכות אלוהים באה בגבורה!“ ");
INSERT INTO heblb_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","כעבור שישה ימים לקח ישוע את פטרוס, יעקב ויוחנן ועלה איתם על פסגת הר גבוה. רק ארבעתם היו שם. לפתע זרחו פניו של ישוע בזוהר נפלא; ");
INSERT INTO heblb_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","בגדיו הבריקו והלבינו עד מאוד. ");
INSERT INTO heblb_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","והנה הופיעו אליהו הנביא ומשה רבנו והחלו לדבר עם ישוע. ");
INSERT INTO heblb_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","”רבי, כמה טוב שאנחנו כאן!“ קרא פטרוס. ”אנחנו ניבנה כאן שלוש סוכות לכבוד – לך, למשה ולאליהו!“ ");
INSERT INTO heblb_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","פטרוס לא ידע מה לומר, כי התלמידים היו מבוהלים וחסרי מילים. ");
INSERT INTO heblb_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","בעודו מדבר סכך עליהם ענן, ומתוכו קרא קול: ”זהו בני האהוב, שמעו בקולו!“ ");
INSERT INTO heblb_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","התלמידים הביטו סביבם וגילו שאליהו ומשה נעלמו, וישוע לבדו נותר עמם. ");
INSERT INTO heblb_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","כאשר ירדו מההר ישוע ציווה עליהם שלא יספרו לאיש את מה שראו, עד לאחר שיקום מן המתים. ");
INSERT INTO heblb_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","השלושה לא גילו את הדבר לאיש, אולם שוחחו על כך בינם לבין עצמם, ולעיתים קרובות תהו למה התכוון ישוע כשאמר שיקום מן המתים. ");
INSERT INTO heblb_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","התלמידים שאלו את ישוע מדוע הסופרים אומרים שאליהו הנביא צריך לבוא תחילה (לפני המשיח). ");
INSERT INTO heblb_vpl VALUES ("MK9_12‏","071_9_12‏","MRK","9","12‏","13","ישוע השיב שאליהו באמת צריך לבוא קודם וישליט סדר בכל, ושלמעשה אליהו כבר בא ואותם האנשים נהגו בו באופן מחפיר – בדיוק כפי שניבאו הנביאים. ”למה אתם חושבים שהתכוונו הנביאים כשניבאו שהמשיח יסבול עינויים וחרפה?“ שאל. ");
INSERT INTO heblb_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","למרגלות ההר הם פגשו את תשעת התלמידים האחרים, מוקפים בקהל רב ומתווכחים עם כמה סופרים. ");
INSERT INTO heblb_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","הקהל הביט בישוע בכבוד ובהערצה, וכולם רצו לקבל את פניו. ");
INSERT INTO heblb_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","”על מה אתם מתווכחים?“ שאל ישוע. ");
INSERT INTO heblb_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","איש מהקהל השיב: ”רבי, הבאתי אליך את בני שתרפא אותו; נכנס בו שד המונע ממנו לדבר. ");
INSERT INTO heblb_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","בכל פעם שהשד תוקף את הילד הוא משליך אותו על הרצפה, והילד האומלל מזיל ריר מפיו, שיניו נוקשות וכוחותיו עוזבים אותו. ביקשתי מתלמידיך לגרש את השד, אך הם לא יכלו לעשות זאת.“ ");
INSERT INTO heblb_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","”הו, דור חסר־אמונה,“ אמר ישוע, ”עד מתי יהיה עלי לסבול אתכם? הביאו אלי את הילד.“ ");
INSERT INTO heblb_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","הם הביאו אליו את הילד, אך ברגע שראה השד את ישוע הוא תקף את הילד, הפיל אותו על הרצפה וריר נזל מפיו. ");
INSERT INTO heblb_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","”מתי החלו ההתקפות האלה?“ שאל ישוע. ”בהיותו ילד קטן“, השיב האב. ");
INSERT INTO heblb_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","”לעיתים קרובות מנסה השד לדחוף את הילד לתוך אש או לתוך מים, כדי להרוג אותו. אנא, רחם עלינו ועזור לנו, אם אתה יכול.“ ");
INSERT INTO heblb_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","”אם אני יכול?“ אמר ישוע. ”אם אתה מאמין, הכול אפשרי ובר ביצוע!“ ");
INSERT INTO heblb_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","”אני מאמין! אנא עזור לי וחזק את אמונתי!“ התחנן האב בבכי. ");
INSERT INTO heblb_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","כשראה ישוע שהקהל הולך ורב, נזף בשד ופקד: ”שד חרש ואילם, אני מצווה עליך לעזוב את הילד הזה ולא לשוב אליו לעולם!“ ");
INSERT INTO heblb_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","השד פרץ בצעקה מפחידה ושוב השליך את הילד על הרצפה ויצא ממנו. הוא נראה כגופה לכן עבר לחש בקהל: הילד מת. ");
INSERT INTO heblb_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","אולם ישוע אחז בידו ועזר לו לעמוד על רגליו, והילד הזדקף – בריא לגמרי. ");
INSERT INTO heblb_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","כאשר נשאר ישוע בבית עם תלמידיו לבדם, הם שאלו אותו: ”מדוע לא יכולנו אנחנו לגרש את השד?“ ");
INSERT INTO heblb_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","”זהו מקרה מיוחד שדורש תפילה וצום“, השיב ישוע. ");
INSERT INTO heblb_vpl VALUES ("MK9_30‏","071_9_30‏","MRK","9","30‏","31","הם עזבו את האזור ההוא ועברו דרך הגליל. ישוע לא סיפר לאיש על בואם, כי רצה לבלות זמן מה עם תלמידיו ולהכינם לקראת מה שעומד לקרות לו. ”בן־האדם עומד להימסר לידי אויביו“, פתח ישוע. ”הם יהרגו אותו, אולם לאחר שלושה ימים יקום לתחייה.“ ");
INSERT INTO heblb_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","התלמידים לא הבינו למה התכוון, אך חששו לשאול אותו. ");
INSERT INTO heblb_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","כשהגיעו לכפר־נחום ונכנסו לבית מארחיהם שאל ישוע את תלמידיו: ”על מה התווכחתם בדרך?“ ");
INSERT INTO heblb_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","הם התביישו לספר לו, משום שהתווכחו מי החשוב ביניהם. ");
INSERT INTO heblb_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","ישוע התיישב, קרא אליו את התלמידים ואמר: ”מי שרוצה להיות הראשון צריך להיות האחרון – עליו לשרת את כולם!“ ");
INSERT INTO heblb_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","ישוע קרא אליו ילד קטן והציג אותו לפניהם. הוא חיבק את הילד והכריז: ");
INSERT INTO heblb_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","”כל המקבל ילד קטן כזה בשמי – כאילו מקבל אותי; וכל המקבל אותי – מקבל את אבי אשר שלח אותי.“ ");
INSERT INTO heblb_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","יוחנן תלמידו פנה אליו ואמר: ”רבי, ראינו איש שמגרש שדים בשמך ואמרנו לו לחדול מכך, כי אין הוא שייך לקבוצתנו.“ ");
INSERT INTO heblb_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","”אל תמנעו ממנו,“ אמר להם ישוע, ”כי מי שעושה דברים כאלה בשמי לא ידבר עלי רעות. ");
INSERT INTO heblb_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","כל מי שאינו נגדנו הוא לצידנו. ");
INSERT INTO heblb_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","מי שייתן לכם אפילו כוס מים בלבד, משום שאתם שלי, אני מבטיח לכם שיקבל את שכרו. ");
INSERT INTO heblb_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","אבל אוי למי שיגרום לילד המאמין בי לאבד את אמונתו! לאדם כזה מוטב שיקשרו אבן כבדה לצווארו ויטביעו אותו בים. ");
INSERT INTO heblb_vpl VALUES ("MK9_43‏","071_9_43‏","MRK","9","43‏","44","”אם ידך גורמת לך לחטוא – קצץ אותה! מוטב לחיות עם יד אחת בלבד ולחיות חיי נצח, מאשר ללכת לגיהינום, אל האש שלא תכבה, עם שתי ידיים. ");
INSERT INTO heblb_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","אם רגלך גורמת לך לחטוא – כרות אותה! מוטב להיות קיטע ולחיות חיי נצח, מאשר להיות בעל שתי רגליים שמוליכות אותך לגיהינום. ");
INSERT INTO heblb_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","שם לא תמות התולעת (שתכרסם בהם), והאש לא תכבה לעולם. ");
INSERT INTO heblb_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","”אם עינך גורמת לך לחטוא – עקור אותה! מוטב להיכנס למלכות אלוהים עיוור למחצה, מאשר להישאר בעל שתי עיניים בגיהינום, ");
INSERT INTO heblb_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","מקום שבו התולעת לא תמות לעולם, והאש לא תכבה לעולם. ");
INSERT INTO heblb_vpl VALUES ("MK9_49‏","071_9_49‏","MRK","9","49‏","50","כל אדם יומלח באש. המלח הוא טוב, אך אם הוא מאבד את מליחותו הוא חסר תועלת; כיצד תוכלו להשיב לו את הטעם? על כן שימרו על המלח הנמצא בקרבכם וחיו בשלום איש עם רעהו.“ ");
INSERT INTO heblb_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","ישוע עזב את כפר־נחום והלך דרומה, לגבול יהודה ולאזור שממזרח לנהר הירדן. שוב התאסף סביבו קהל גדול, וישוע לימד אותם כמנהגו. ");
INSERT INTO heblb_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","פרושים אחדים שבאו לנסותו שאלו: ”האם מותר לאיש להתגרש מאשתו?“ ");
INSERT INTO heblb_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","”מה אמר משה רבנו בקשר לגירושין?“ שאל ישוע. ");
INSERT INTO heblb_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","”משה אמר שמותר להתגרש“, השיבו הפרושים. ”הוא אמר שבעל הרוצה לגרש את אשתו צריך לכתוב לה ספר כריתות (מכתב גירושין), וזה כל מה שנדרש ממנו.“ ");
INSERT INTO heblb_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","”האם אתם יודעים מדוע כתב לכם משה את המצוה הזאת?“ השיב ישוע. ”אני אגיד לכם למה: משה לקח בחשבון את האופי העקשני שלכם. ");
INSERT INTO heblb_vpl VALUES ("MK10_6‏","071_10_6‏","MRK","10","6‏","7","הרי מובן מאליו שאלוהים לא ברא איש ואישה כדי שייפרדו, אלא להיפך – אלוהים ברא איש ואישה כדי שיתאחדו לעולם בברית הנישואין. על כן יעזוב איש את אביו ואת אמו, ");
INSERT INTO heblb_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ודבק באשתו והיו לבשר אחד. ");
INSERT INTO heblb_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","וכך אסור לאיש להפריד את מה שאלוהים איחד.“ ");
INSERT INTO heblb_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","מאוחר יותר, כשנשאר ישוע בבית לבד עם התלמידים, שוב העלו את הנושא. ");
INSERT INTO heblb_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","ישוע הסביר להם: ”בעל המגרש את אשתו משום שברצונו להתחתן עם אישה אחרת, נחשב לנואף. ");
INSERT INTO heblb_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","ואישה המגרשת את בעלה ומתחתנת בשנית נחשבת גם היא לנואפת.“ ");
INSERT INTO heblb_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","פעם הביאו אליו מספר אמהות את ילדיהן, כדי שיברך אותם, אולם התלמידים גירשו את האמהות וביקשו מהן שלא להטריד את ישוע. ");
INSERT INTO heblb_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","כשראה ישוע מה עושים תלמידיו, זה לא מצא חן בעיניו. ”תנו לילדים לבוא אלי ואל תמנעו מהם, כי לכאלה שייכת מלכות האלוהים. ");
INSERT INTO heblb_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","אני אומר לכם: מי שלא מקבל את מלכות האלוהים כמו ילד, לא יוכל להיכנס אליה.“ ");
INSERT INTO heblb_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","ישוע חיבק את הילדים, הניח ידיו על ראשם וברך אותם. ");
INSERT INTO heblb_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","יום אחד כאשר ישוע יצא לאחד ממסעותיו, בא אליו אדם בריצה שנפל לרגליו ושאל: ”רבי הטוב, מה עלי לעשות כדי לזכות בחיי נצח?“ ");
INSERT INTO heblb_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","”מדוע אתה קורא לי טוב?“ שאל ישוע. ”רק אלוהים טוב. ");
INSERT INTO heblb_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","אך בתשובה לשאלתך, אתה הרי מכיר את המצוות: לא תרצח, לא תנאף, לא תגנוב, לא תענה ברעך עד שקר, לא תעשוק, כבד את אביך ואת אמך?“ ");
INSERT INTO heblb_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","”רבי,“ ענה האיש, ”תמיד שמרתי את כל המצוות האלה.“ ");
INSERT INTO heblb_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","ישוע הביט בו באהבה. ”עליך לעשות עוד דבר אחד: עליך למכור את רכושך ולתרום את הכסף לעניים – כדי שאוצרך יהיה בשמים – ולאחר מכן לך אחרי.“ ");
INSERT INTO heblb_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","האיש התעצב מאוד והלך לדרכו, כי היה עשיר מאוד. ");
INSERT INTO heblb_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","ישוע הסתכל ואז אמר לתלמידיו: ”לאיש עשיר קשה מאוד להיכנס למלכות האלוהים.“ ");
INSERT INTO heblb_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","דבריו של ישוע הדהימו את התלמידים, ולכן חזר ואמר: ”ילדים יקרים, מי שבוטח בכסף וברכוש קשה לו מאוד להיכנס למלכות האלוהים. ");
INSERT INTO heblb_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","קל יותר לגמל לעבור דרך חור המחט, מאשר לאיש עשיר להיכנס למלכות האלוהים.“ ");
INSERT INTO heblb_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","דבריו אך הגבירו את תמיהת התלמידים. הם שאלו זה את זה: ”מי, אם כן, יוכל להיוושע?“ ");
INSERT INTO heblb_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","ישוע הביט בהם ואמר: ”למעשה, לבני־האדם זה לא אפשרי, אולם לא לאלוהים: עם אלוהים הכול אפשרי!“ ");
INSERT INTO heblb_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","פטרוס החל למנות בקול רם את כל הדברים שהוא ושאר התלמידים עזבו למען ישוע. ”אנחנו ויתרנו על הכול כדי ללכת אחריך!“ אמר פטרוס. ");
INSERT INTO heblb_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","”אני מבטיח לכם,“ אמר ישוע, ”שכל מי שוויתר על בית, אחים, אחיות, אמא, אבא, ילדים או רכוש למעני ולמען הבשורה, ");
INSERT INTO heblb_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","יקבל ממני חזרה פי מאה ממה שלכאורה הפסיד: בתים, אחים, אחיות, אמהות, ילדים, אדמות – אך עם כל אלה גם רדיפות, ובעולם הבא יקבל חיי נצח. ");
INSERT INTO heblb_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","אולם רבים מאלה שהם ראשונים עתה יהיו אז אחרונים, ואחדים מהאחרונים עתה יהיו אז ראשונים.“ ");
INSERT INTO heblb_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","בדרך לירושלים הלך ישוע בראש, והתלמידים הלכו אחריו בחרדה. ישוע המשיך לספר להם מה יקרה לו. ");
INSERT INTO heblb_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","הוא דיבר איתם על הצפוי לו בירושלים: ”מישהו יסגיר אותי לידי ראשי הכוהנים ולסופרים. הם ידונו אותי למוות וימסרו אותי לידי הרומאים. ");
INSERT INTO heblb_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","הם יִרקו עלי, ילעגו לי, יצליפו בי בשוטים ויהרגו אותי. אבל לאחר שלושה ימים אקום לתחייה.“ ");
INSERT INTO heblb_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","יעקב ויוחנן בני זבדי לחשו באוזנו: ”רבי, אנחנו רוצים לבקש ממך טובה.“ ");
INSERT INTO heblb_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","”איזו טובה אתם רוצים?“ שאל ישוע. ");
INSERT INTO heblb_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","”כאשר תשב על כסא המלכות, אנו רוצים לשבת אחד לימינך ואחד לשמאלך.“ ");
INSERT INTO heblb_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","”אינכם יודעים מה אתם מבקשים!“ התפלא ישוע. ”האם תוכלו לשתות מהכוס שאני חייב לשתות? האם תוכלו להיטבל בטבילה שאני מוכרח להיטבל?“ ");
INSERT INTO heblb_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","”כן!“ השיבו. ”אתם באמת תשתו מכוסי ותיטבלו בטבילתי“, אמר ישוע. ");
INSERT INTO heblb_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","”אבל איני יכול להבטיח לכם לשבת לימיני ולשמאלי, מפני שמקומות אלה כבר שמורים!“ ");
INSERT INTO heblb_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","עד מהרה גילו שאר התלמידים את בקשתם של יעקב ויוחנן וכעסו עליהם מאוד. ");
INSERT INTO heblb_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","ישוע קיבץ סביבו את התלמידים ואמר: ”אתם הרי יודעים שאלה הנחשבים למנהיגי הגויים רודים בנתיניהם, ומעניקים כוח וסמכות למי שהם רוצים. ");
INSERT INTO heblb_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","אולם ביניכם אין הדבר כך; מי שרוצה להיות מנהיג ביניכם צריך להיות לכם למשרת. ");
INSERT INTO heblb_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","מי שרוצה לעמוד בראש צריך להיות המשרת של כולכם. ");
INSERT INTO heblb_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","אף אני, בן־האדם, לא באתי לכאן כדי שישרתו אותי, אלא כדי לשרת אחרים ולתת את חיי כופר בעד רבים.“ ");
INSERT INTO heblb_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","ישוע ותלמידיו באו ליריחו. בצאתם מהעיר הלך אחריהם קהל גדול. בצד הדרך ישב קבצן עיוור בשם ברטמי בן־טימי, ");
INSERT INTO heblb_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","ששמע שישוע מנצרת מתקרב. ברטמי החל לצעוק: ”ישוע בן דוד, רחם עלי!“ ");
INSERT INTO heblb_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","”שתוק!“ ציוו עליו מספר אנשים. אך העיוור לא שתק, אלא הגביר את קולו: ”בן דוד, רחם עלי!“ ");
INSERT INTO heblb_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","ישוע שמע את תחינותיו של העיוור ועמד מלכת. הוא ביקש לקרוא לעיוור. ”התעודד,“ אמרו לו, ”קום! הוא קורא לך.“ ");
INSERT INTO heblb_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","ברטמי השליך מעליו את שמיכותיו ובא לישוע. ");
INSERT INTO heblb_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","”מה אוכל לעשות למענך?“ שאל ישוע. ”רבי, אני רוצה לראות!“ בכה האיש. ");
INSERT INTO heblb_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","”כמובן“, השיב ישוע. ”אמונתך ריפאה אותך; לך לשלום.“ ואכן עיניו נרפאו והוא הלך בדרך אחרי ישוע. ");
INSERT INTO heblb_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","כאשר התקרבו לירושלים והגיעו לבית־פגי ובית־עניה, שעל הר הזיתים, פנה ישוע אל שניים מתלמידיו ואמר: ");
INSERT INTO heblb_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","”לכו אל הכפר ממול, ובכניסה תראו עַיִר קשור שאיש עדיין לא רכב עליו. התירו את העיר והביאו אותו אלי. ");
INSERT INTO heblb_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","אם מישהו ישאל אתכם מה אתם עושים, אמרו לו, ’האדון זקוק לעיר, אך הוא ישיב אותו בהקדם‘. “ ");
INSERT INTO heblb_vpl VALUES ("MK11_4‏","071_11_4‏","MRK","11","4‏","5","שני התלמידים נכנסו אל הכפר ומצאו את העיר עומד על השביל, קשור לשער אחד הבתים. בהתירם את העיר שאלו מספר אנשים שעמדו שם: ”מה אתם עושים? לאן אתם לוקחים את העיר?“ ");
INSERT INTO heblb_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","התלמידים השיבו שישוע ביקש מהם להביא לו את העיר, והאנשים לא התנגדו יותר. ");
INSERT INTO heblb_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","הם הביאו את העיר לישוע, וכל התלמידים הניחו את מעיליהם על גבו, כדי שישוע יוכל לשבת בנוח. ");
INSERT INTO heblb_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","רבים מן הקהל פרשו את מעיליהם על הדרך לפני ישוע, ואחרים כרתו ענפים והניחו אותם על הדרך. ");
INSERT INTO heblb_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","הקהל, שנמלא התלהבות, נדחף ונדחק אל ישוע מכל עבר וקרא: ”הושע־נא! ברוך הבא בשם ה׳! ");
INSERT INTO heblb_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","תבורך מלכות דוד הבאה עלינו! הושע־נא במרומים!“ ");
INSERT INTO heblb_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","כל הקהל הזה ליווה את ישוע אל תוך העיר. מאוחר יותר נכנס ישוע לבית־המקדש והביט סביבו בתשומת לב מרובה, אולם מאחר שהשעה הייתה מאוחרת הוא עזב את המקום והלך עם תלמידיו לבית־עניה. ");
INSERT INTO heblb_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","למחרת בבוקר, בעזבם את בית־עניה, היה ישוע רעב. ");
INSERT INTO heblb_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","הוא ראה מרחוק עץ תאנה עם עלים ירוקים ורעננים. ישוע התקרב אל העץ וחיפש תאנים, אולם לא מצא דבר מלבד עלים, כי טרם הגיעה העונה. ");
INSERT INTO heblb_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","ישוע קילל את התאנה ואמר: ”מהיום והלאה איש לא יאכל תאנים ממך!“ והתלמידים שמעו זאת. ");
INSERT INTO heblb_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","הם חזרו לירושלים וישוע הלך ישר לבית־המקדש. הוא החל לגרש משם את הסוחרים והקונים, הפך את השולחנות של מחליפי הכספים ואת הדוכנים של סוחרי היונים, ");
INSERT INTO heblb_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","ולא הרשה לאיש לשאת כלים וסחורה דרך המקדש. ");
INSERT INTO heblb_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","ישוע פנה אל הקהל הנדהם: ”כתוב בכתבי־הקודש: ’ביתי בית־תפלה ייקרא לכל העמים‘. אולם אתם הפכתם אותו למאורת גנבים!“ ");
INSERT INTO heblb_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","ראשי הכוהנים והסופרים שמעו על מה שישוע עשה, והחלו לתכנן כיצד להיפטר ממנו. למעשה הם פחדו ממנו, מפני שכל העם העריץ אותו ואהב את מה שלימד. ");
INSERT INTO heblb_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","באותו ערב יצאו ישוע ותלמידיו אל מחוץ לעיר. ");
INSERT INTO heblb_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","בבוקר שוב עברו ליד עץ התאנה, ונדהמו לראות שהעץ יבש לגמרי. ");
INSERT INTO heblb_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","פטרוס נזכר במה שישוע עשה יום קודם ואמר: ”ראה, רבי – העץ שקיללת התייבש לגמרי!“ ");
INSERT INTO heblb_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","”פשוט האמינו באלוהים“, אמר ישוע. ");
INSERT INTO heblb_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","”אילו באמת האמנתם בכוחו של אלוהים, יכולתם לצוות על ההר הזה לזוז ממקומו ולהיזרק לים. אם תאמינו ולא תטילו ספק יתקיים דברכם. ");
INSERT INTO heblb_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","דעו לכם, אתם יכולים להתפלל בעד כל דבר, ואם תאמינו שתקבלו את אשר ביקשתם, באמת תקבלו! ");
INSERT INTO heblb_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","אבל בשעה שאתם מתפללים עליכם לסלוח תמיד לכל מי שאתם שומרים לו טינה, כדי שאביכם שבשמים יסלח גם לכם על חטאיכם. ");
INSERT INTO heblb_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","אם לא תסלחו לאחרים – גם אביכם שבשמים לא יסלח לכם!“ ");
INSERT INTO heblb_vpl VALUES ("MK11_27‏","071_11_27‏","MRK","11","27‏","28","בינתיים ישוע ותלמידיו חזרו לירושלים, וישוע שב לבית־המקדש. אחדים מראשי הכוהנים הסופרים וזקנים באו אליו ושאלו בכעס: ”באיזו רשות אתה עושה את כל הדברים האלה?“ ");
INSERT INTO heblb_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","”אני אענה לשאלתכם בתנאי שאתם תענו לשאלתי“, השיב ישוע. ");
INSERT INTO heblb_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","”אמרו לי, האם נשלח יוחנן המטביל על־ידי אלוהים או על־ידי בני־אדם?“ ");
INSERT INTO heblb_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","הם התייעצו ביניהם: ”אם נאמר שאלוהים שלח אותו, ישוע ישאל אותנו מדוע לא האמנו בו. ");
INSERT INTO heblb_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","אולם אם נאמר שלא אלוהים שלח אותו, כל העם יתנפל עלינו, כי כולם חושבים שיוחנן היה נביא שנשלח על־ידי אלוהים.“ ");
INSERT INTO heblb_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","לבסוף השיבו: ”איננו יודעים.“ על כן השיב להם ישוע: ”אם כן, גם אני לא אענה לשאלתכם.“ ");
INSERT INTO heblb_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","ישוע סיפר לעם את המשל הבא: ”איש אחד נטע כרם ענבים ובנה גדר, יקב ומגדל שמירה. הוא השכיר את הכרם לכורמים ונסע לחוץ לארץ. ");
INSERT INTO heblb_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","בזמן הבציר שלח בעל־הכרם את אחד מאנשיו לאסוף את הרווח מיבול הענבים, ");
INSERT INTO heblb_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","אולם הכורמים התנפלו על השליח, הכו אותו ושלחו אותו חזרה אל בעל־הכרם בידיים ריקות. ");
INSERT INTO heblb_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","”בעל־הכרם שלח מישהו אחר אל הכורמים, אך גם אותו הכו ואף פצעו את ראשו. ");
INSERT INTO heblb_vpl VALUES ("MK12_5‏","071_12_5‏","MRK","12","5‏","6","השליח הבא נרצח וכל השליחים שבאו לאחר מכן לכרם הוכו או נרצחו. לבסוף נשאר לבעל־הכרם עוד שליח אחד – בנו היחיד. בלית ברירה הוא שלח את בנו, בתקווה שלפחות אליו יתייחסו הכורמים בכבוד. ");
INSERT INTO heblb_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","אבל כשראו הכורמים את הבן מרחוק, אמרו: ’הנה בא יורש הכרם; הבה נהרוג אותו, ואז יהיה הכרם שלנו!‘ ");
INSERT INTO heblb_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","הם תפסו את הבן, רצחו אותו והשליכו את גופתו מעבר לגדר. ");
INSERT INTO heblb_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","”מה לדעתכם יעשה בעל־הכרם כאשר ישמע את מה שקרה? מובן שיבוא בעצמו, יהרוג את כל הכורמים וישכיר את הכרם לאחרים. ");
INSERT INTO heblb_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","האם אינכם זוכרים שככה כתוב בתהלים? ’אבן מאסו הבונים היתה לראש פינה, ");
INSERT INTO heblb_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","מאת ה׳ היתה זאת; היא נפלאת בעינינו‘.“ ");
INSERT INTO heblb_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","ראשי הכוהנים, הזקנים והסופרים רצו לאסור אותו בו במקום, כי הבינו שבמשל זה הוא מתכוון אליהם – שהם הכורמים הרשעים. אולם הם פחדו לגעת בו בגלל ההמון הרב שהיה שם. על כן ויתרו לו והלכו לדרכם. ");
INSERT INTO heblb_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","אולם הם שלחו אליו כמה מאנשי הורדוס ופרושים, כדי שייכנסו איתו לשיחה וינסו לגרום לכך שיאמר משהו נגד החוק, על־מנת שתהיה להם עילה לאסור אותו. ");
INSERT INTO heblb_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","”רבי,“ פתחו המסתננים, ”אנחנו יודעים שאתה איש ישר ושאיש אינו יכול להשפיע עליך לשקר. אנחנו גם יודעים שאתה באמת מלמד את דבר אלוהים. אמור לנו, רבי, האם עלינו לשלם מס לקיסר הרומאי או לא?“ ");
INSERT INTO heblb_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","ישוע הבין את מזימתם ולכן ענה: ”תנו לי מטבע ואומר לכם.“ ");
INSERT INTO heblb_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","הם נתנו לו מטבע, והוא שאל: ”של מי הדמות החקוקה על המטבע? של מי השם החקוק כאן?“ ”של הקיסר!“ ענו כולם. ");
INSERT INTO heblb_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","”של הקיסר? אם כן תנו לו את מה ששייך לו, אך תנו לאלוהים את מה ששייך לאלוהים.“ הם נותרו פעורי פה וללא מילים. ");
INSERT INTO heblb_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","אחר כך באו צדוקים (שאינם מאמינים בתחיית המתים) ושאלו אותו: ");
INSERT INTO heblb_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","”רבי, משה רבנו לימד אותנו שאם אדם נשוי מת ואינו משאיר אחריו בן, חייב אחיו להתחתן עם האלמנה, כדי שתוכל ללדת בן שישא את שם המת. ");
INSERT INTO heblb_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","במשפחה אחת היו שבעה אחים; האח הבכור התחתן, וכעבור זמן קצר מת ולא השאיר אחריו בן. ");
INSERT INTO heblb_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","האח השני התחתן עם האלמנה, וגם הוא מת ולא השאיר בן. כך קרה גם עם האח השלישי. ");
INSERT INTO heblb_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","בקיצור, כל שבעת האחים התחתנו עם האישה האחת, כולם מתו ולא השאירו אחריהם בן. לבסוף מתה גם האישה.“ ");
INSERT INTO heblb_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","”רבי, למי תהיה שייכת האישה בתחיית המתים? הלא כל השבעה התחתנו אתה!“ ");
INSERT INTO heblb_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","השיב להם ישוע: ”טעותכם נובעת מבורותכם בכל הנוגע לכתבי־הקודש ולגבורתו של אלוהים. ");
INSERT INTO heblb_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","כי בתחיית המתים לא יהיו עוד נשואים; כולם יהיו כמלאכים בשמים. ");
INSERT INTO heblb_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","”ובנוגע לתחיית המתים – טועים אתם מאוד. האם מעולם לא קראתם בספר שמות על משה והסנה הבוער? אלוהים אמר למשה: ’אנוכי אלוהי אברהם, אלוהי יצחק ואלוהי יעקב‘. ");
INSERT INTO heblb_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","”אלוהים אמר למשה כי למרות שאנשים אלה מתו לפני מאות שנים, הם עדיין חיים. הרי אלוהים לא היה אומר: ’אנוכי האלוהים‘ של אנשים מתים!“ ");
INSERT INTO heblb_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","אחד המנהיגים היהודיים שעמד שם נוכח כי ישוע השיב כהלכה, ולכן שאל אותו: ”מהי המצווה החשובה ביותר?“ ");
INSERT INTO heblb_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","ישוע השיב: ” ’שמע ישראל, ה׳ אלוהינו, ה׳ אחד! ");
INSERT INTO heblb_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","ואהבת את ה׳ אלוהיך בכל לבבך ובכל נפשך ובכל מאודך‘. ");
INSERT INTO heblb_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","המצווה השנייה היא: ’ואהבת לרעך כמוך!‘ מצוות אלה הן החשובות ביותר!“ ");
INSERT INTO heblb_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","השואל המשיך: ”רבי, אתה צודק. באמת יש רק אלוהים אחד ואין אחר מלבדו. ");
INSERT INTO heblb_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","אני יודע שחשוב יותר לאהוב את אלוהים בכל לבי, הבנתי וכוחי, ולאהוב אנשים אחרים כמו את עצמי, מאשר להקריב כל מיני קרבנות בבית־המקדש.“ ");
INSERT INTO heblb_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","ישוע ראה שהאיש דיבר בחוכמה, ולכן אמר לו: ”אתה קרוב מאוד למלכות אלוהים!“ לאחר מכן לא העז איש לשאול אותו יותר שאלות. ");
INSERT INTO heblb_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","מאוחר יותר, כשלימד ישוע את האנשים בבית־המקדש, שאל אותם: ”מדוע טוענים הסופרים כי המשיח הוא בן־דוד? ");
INSERT INTO heblb_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","הרי דוד אמר בעצמו בהשראת רוח הקודש: ’נאום ה׳ לאדני, שב לימיני עד אשית אויביך הדום לרגליך‘. ");
INSERT INTO heblb_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","הלא דוד עצמו קרא לו ’אדון‘, אם כן כיצד הוא יכול להיות בנו?“ הקהל נהנה מאוד להקשיב לנימוקיו של ישוע ולמסקנותיו. ");
INSERT INTO heblb_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","ישוע המשיך ללמד את העם: ”היזהרו מהסופרים שאוהבים ללבוש גלימות ולהיראות לפני האנשים בשווקים, כדי שכולם ייתנו להם כבוד. ");
INSERT INTO heblb_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","הם אוהבים לשבת במושבי הנכבדים בבית־הכנסת ובסעודות וחגיגות. ");
INSERT INTO heblb_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","ללא בושה הם מגרשים אלמנות מבתיהן, וכדי לכסות על מעשיהם מעמידים פני קדושים תמימים ומתפללים בציבור תפילות ארוכות. משום כך יהיה עונשם חמור יותר.“ ");
INSERT INTO heblb_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","ישוע התיישב מול תיבת האוצר והתבונן באנשים שהביאו תרומות. עשירים רבים תרמו סכומי כסף גדולים. ");
INSERT INTO heblb_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","אחריהם הופיעה אלמנה ענייה שתרמה שתי פרוטות בשווי של שתי אגורות. ");
INSERT INTO heblb_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","ישוע קרא לתלמידיו ואמר: ”אתם רואים את האלמנה הזאת? היא תרמה יותר מכל העשירים האלה גם יחד! ");
INSERT INTO heblb_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","כי העשירים תרמו סכומים קטנים ביחס לרכוש הרב שיש להם, ואילו האלמנה הזאת נתנה את כל מה שהיה לה.“ ");
INSERT INTO heblb_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","כשיצא ישוע מבית־המקדש באותו יום, אחד מתלמידיו העיר: ”רבי, ראה אילו מבנים יפים ואיזו עבודת אבנים נפלאה!“ ");
INSERT INTO heblb_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","”הבט היטב,“ ענה לו ישוע, ”כי כול הבנינים הגדולים האלה ייהרסו; אף אבן לא תישאר במקומה.“ ");
INSERT INTO heblb_vpl VALUES ("MK13_3‏","071_13_3‏","MRK","13","3‏","4","ישוע ישב על הר הזיתים, מול בית־המקדש, ופטרוס, יעקב ויוחנן ואַנְדְּרֵי שנשארו איתו שאלו: ”מתי יקרה הדבר? האם נקבל אזהרה מראש?“ ");
INSERT INTO heblb_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","ישוע הסביר להם בהרחבה את העומד להתרחש: ”אל תתנו לאיש לרמות אתכם! ");
INSERT INTO heblb_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","אנשים רבים יבואו ויטענו: ’אני הוא המשיח‘, ויוליכו שולל אנשים רבים. ");
INSERT INTO heblb_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","במקומות שונים תפרוצנה מלחמות, אך אין זה עדיין הסוף. ");
INSERT INTO heblb_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","”מדינות וממלכות תילחמנה זו בזו, ובמקומות רבים יהיו רעידות אדמה ורעב. אלה יציינו רק את ראשית הצרות והסבל העתידים לבוא. ");
INSERT INTO heblb_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","אולם כשיתחילו דברים אלה להתרחש, היזהרו! כי צפויה לכם סכנה גדולה. אויביכם יגררו אתכם בכוח לבתי המשפט, יכו אתכם בבתי־הכנסת, ויאשימו אתכם לפני השלטונות על היותכם תלמידי. אולם זו תהיה לכם הזדמנות לספר להם על הבשורה. ");
INSERT INTO heblb_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","אך צריך שקודם הבשורה תוכרז לכל הגויים. ");
INSERT INTO heblb_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","כאשר יאסרו אתכם ויעמידו אתכם למשפט, אל תדאגו לעדותכם או להגנתכם מה להגיד, כי מה שיינתן לכם באותה שעה, את זה תגידו; כי לא אתם תדברו, אלא רוח הקודש ידבר בפיכם. ");
INSERT INTO heblb_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","”אח יבגוד באחיו ויסגירו למוות; אבות ימסרו את בניהם למוות; ");
INSERT INTO heblb_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","ילדים יקומו נגד הוריהם וייגרמו למותם. כולם ישנאו אתכם משום שאתם שייכים לי, אולם כל מי שיחזיק מעמד עד הסוף – ייוושע! ");
INSERT INTO heblb_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","”כאשר תראו את חילול הקודש בבית־המקדש שעליו דיבר דניאל, (הקורא – שים לב!) על כל תושבי יהודה לברוח להרים. ");
INSERT INTO heblb_vpl VALUES ("MK13_15‏","071_13_15‏","MRK","13","15‏","16","אם אתה נמצא על גג ביתך – אל תיכנס הביתה; אם אתה בשדה – אל תחזור הביתה לקחת מעיל או כסף, כי אין זמן. ");
INSERT INTO heblb_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","”אוי לנשים ההרות ולמניקות באותם ימים! ");
INSERT INTO heblb_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","התפללו שכל זה לא יקרה בחורף, ");
INSERT INTO heblb_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","כי תקופה זאת תהיה איומה ונוראה; דבר כזה לא קרה מאז בריאת העולם, וגם לא יקרה אחר כך. ");
INSERT INTO heblb_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","אם האדון לא יקצר את הימים הנוראים האלה – איש לא יינצל. אבל הוא אכן יקצר את הסבל למען עמו הנבחר. ");
INSERT INTO heblb_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","”אם מישהו יאמר לכם באותם ימים: ’ראיתי את המשיח במקום פלוני!‘ או ’המשיח נמצא בכפר הסמוך!‘ אל תאמינו לו, ");
INSERT INTO heblb_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","כי משיחי־שקר ונביאי־שקר יקומו ויחוללו נסים ונפלאות אשר יתעו את האנשים, ואם יוכלו, הם יתעו אפילו את הנבחרים. ");
INSERT INTO heblb_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","ראו הוזהרתם! ");
INSERT INTO heblb_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","”לאחר הצרות של אותם ימים תחשך השמש, הירח ישחיר, ");
INSERT INTO heblb_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","הכוכבים יפלו מהשמים וכוחות השמים יתמוטטו. ");
INSERT INTO heblb_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","”ואז יראו אנשי הארץ את בן־האדם בא בעננים, בגבורה רבה ובכבוד. ");
INSERT INTO heblb_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","ואז הוא ישלח את מלאכיו, ויאסף את בחיריו מכל קצוות תבל. ");
INSERT INTO heblb_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","עץ התאנה ישמש לכם כדוגמה: כאשר הענפים מלבלבים והעלים ירוקים, אתם יודעים שהקיץ קרב. ");
INSERT INTO heblb_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","כאשר כל מה שסיפרתי לכם יתחיל להתרחש, דעו לכם שזה קרוב, שאני עומד בפתח. ");
INSERT INTO heblb_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","”אני אומר לכם: כל הדברים האלה יתרחשו לפני שיחלוף הדור הזה. ");
INSERT INTO heblb_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","השמים והארץ יחלפו, אבל דברי לא יחלפו. ");
INSERT INTO heblb_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","”איש אינו יודע את היום והשעה של התרחשויות אלה; המלאכים בשמים אינם יודעים זאת, ואפילו אני עצמי איני יודע את המועד המדויק. רק אבי שבשמים יודע זאת. ");
INSERT INTO heblb_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","עמדו על המשמר והיו מוכנים, מפני שאינכם יודעים מתי כל זה יתרחש. ");
INSERT INTO heblb_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","”משל דומה לזה הוא של אדם היוצא למסע בחו״ל. הוא משאיר עבודה לשכיריו לתקופת העדרו, ומצווה על השוער לעמוד על המשמר לקראת שובו בכל רגע. ");
INSERT INTO heblb_vpl VALUES ("MK13_35‏","071_13_35‏","MRK","13","35‏","37","היו מוכנים! הלא אינכם יודעים מתי ישוב בעל הבית: בבוקר, בערב, מוקדם או מאוחר, פן יבוא וימצא אתכם ישנים. אני אומר שוב לכולכם: עמדו על המשמר!“ ");
INSERT INTO heblb_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","יומיים לפני חג הפסח עדיין חיפשו ראשי הכוהנים וכמה ממנהיגי היהודים הזדמנות מתאימה לאסור את ישוע ולהוציאו להורג. ");
INSERT INTO heblb_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","”איננו יכולים לעצור אותו בפסח,“ אמרו לעצמם, ”מפני שהעם יעורר מהומות.“ ");
INSERT INTO heblb_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","באותו זמן היה ישוע בבית־עניה, בביתו של שמעון המצורע. בשעת ארוחת הערב הופיעה אישה אחת עם פחית קטנה מלאה בשמן זך יקר מאוד. האישה הסירה את המכסה ויצקה את השמן על ראשו של ישוע. ");
INSERT INTO heblb_vpl VALUES ("MK14_4‏","071_14_4‏","MRK","14","4‏","5","אחדים מן המסובים התמרמרו בינם לבין עצמם על ”הבזבוז“, כלשונם. ”מדוע את מבזבזת את השמן היקר הזה?“ התלוננו. ”יכולת למכור אותו ברווח, ואת הכסף לתת לעניים.“ ");
INSERT INTO heblb_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","”הניחו לה!“ נחלץ ישוע להגנתה. ”מדוע אתם מציקים לה? הלא היא עשתה מעשה טוב. ");
INSERT INTO heblb_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","העניים הנזקקים לעזרה נמצאים אתכם תמיד, ואתם יכולים לעזור להם בכל זמן שתרצו בכך, ואילו אני לא אשאר אתכם עוד זמן רב. ");
INSERT INTO heblb_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","היא עשתה מה שיכלה; היא משחה את גופי בשמן לפני קבורתי. ");
INSERT INTO heblb_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","”אני אומר לכם: בכל מקום שבו תוכרז הבשורה, תיזכר גם האישה הזאת, בזכות המעשה שעשתה.“ ");
INSERT INTO heblb_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","לאחר מכן הלך יהודה איש־קריות, תלמידו של ישוע, אל ראשי הכוהנים כדי לתכנן את הסגרתו של ישוע. ");
INSERT INTO heblb_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","ראשי הכוהנים התלהבו ושמחו על כך שיהודה החליט להסגיר את ישוע, והבטיחו לתת לו כסף. ");
INSERT INTO heblb_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","ביום הראשון של חג הפסח, שבו הקריבו את זבח הפסח, שאלו התלמידים את ישוע היכן ברצונו לערוך את הסדר. ");
INSERT INTO heblb_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","ישוע שלח שניים מתלמידיו לירושלים, כדי לערוך את ההכנות הדרושות, ואמר: ”כשתלכו העירה יבוא לקראתכם אדם ובידו כד מים. לכו אחריו, ");
INSERT INTO heblb_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","היכנסו אל הבית שאליו ייכנס ואמרו לבעל הבית: ’רבנו שלח אותנו לראות את החדר שהכנת בשביל הסדר‘. ");
INSERT INTO heblb_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","הוא יוביל אתכם לחדר גדול שהכין למעננו בקומה השנייה, ושם תכינו את הסדר.“ ");
INSERT INTO heblb_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","כשהגיעו השניים העירה הכול התרחש בדיוק כפי שאמר להם ישוע, והם הכינו את הסדר. ");
INSERT INTO heblb_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","ישוע ושאר התלמידים הגיעו לשם בערב. ");
INSERT INTO heblb_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","כשישבו לאכול בשולחן פתח ישוע ואמר: ”אמת אני אומר לכם, אחד מכם היושב עכשיו בינינו ואוכל איתנו יבגוד בי ויסגיר אותי.“ ");
INSERT INTO heblb_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","התלמידים נמלאו צער רב, ושאלו: ”האם זה יהיה אני?“ ");
INSERT INTO heblb_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","”אחד מבין השנים־עשר שיטבול איתי את הלחם“, השיב ישוע. ");
INSERT INTO heblb_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","”בן־האדם הולך למות כפי שכתוב שצריך לקרות, אולם אני אומר לכם: אוי לו לאיש שיסגיר אותו; מוטב שלא היה נולד בכלל!“ ");
INSERT INTO heblb_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","בעת הסעודה הוא לקח לחם (מצה), ברך עליו ופרס אותו לפרוסות. הוא הגיש את הפרוסות לתלמידיו ואמר: ”קחו, זהו גופי.“ ");
INSERT INTO heblb_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","לאחר מכן לקח ישוע כוס יין, ברך, הגיש לתלמידיו וכולם שתו ממנה. ");
INSERT INTO heblb_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","”זהו דמי הנשפך למען רבים, דם הברית“, המשיך ישוע. ");
INSERT INTO heblb_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","”ואני אומר לכם שלא אשתה עוד יין עד היום שבו אשתה יין חדש במלכות האלוהים.“ ");
INSERT INTO heblb_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","כל הנוכחים שרו מזמורי תהלים, ולאחר מכן הלכו להר הזיתים. ");
INSERT INTO heblb_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","”כולכם תעזבו אותי,“ אמר ישוע לתלמידיו, ”והרי כתוב: ’אכה את הרעה ותפוצין הצאן‘. ");
INSERT INTO heblb_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","אולם לאחר שאקום לתחייה אלך לגליל ואפגוש אתכם שם.“ ");
INSERT INTO heblb_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","”יקרה מה שיקרה,“ קרא פטרוס, ”אני לעולם לא אעזוב אותך!“ ");
INSERT INTO heblb_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","”דע לך, פטרוס,“ אמר ישוע, ”עד מחר בבוקר, לפני שיקרא התרנגול, אתה תתכחש לי שלוש פעמים.“ ");
INSERT INTO heblb_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","”אני לעולם לא אתכחש לך, אפילו אם יהיה עלי למות יחד אתך!“ נשבע פטרוס, וכל האחרים גם אמרו כך. ");
INSERT INTO heblb_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","הם הגיעו לחורשת עצי־זית הנקראת ”גת־שמני“, וישוע אמר לתלמידיו: ”חכו לי כאן עד שאחזור. אני הולך להתפלל.“ ");
INSERT INTO heblb_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","הוא לקח איתו את פטרוס, יעקב ויוחנן, ולפתע נמלא חרדה ומועקה מפני העומד לבוא עליו. ");
INSERT INTO heblb_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","”אני מתייסר עד מוות!“ אמר להם ישוע. ”חכו כאן… הישארו ערים….“ ");
INSERT INTO heblb_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","הוא התרחק מהם מעט, כרע ברך על האדמה והתפלל שאלוהים יוותר לו על העומד לקרות לו, אם אכן אפשרי. ");
INSERT INTO heblb_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","”אבא,“ קרא ישוע, ”אתה כל יכול. אנא, הרחק ממני את כוס הייסורים. אולם לא כרצוני כי אם רצונך ייעשה!“ ");
INSERT INTO heblb_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","לאחר מכן הוא חזר אל שלושת התלמידים ומצא אותם ישנים. ”שמעון,“ קרא ישוע לפטרוס, ”אתה ישן? האם לא יכולת להישאר ער שעה אחת בלבד? ");
INSERT INTO heblb_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","עמדו על המשמר והתפללו שלא תבואו לידי ניסיון. אני יודע שהרוח אכן רוצה, אבל גופכם חלש כל־כך!“ ");
INSERT INTO heblb_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","ישוע הלך להתפלל שוב, וחזר על תחינתו לפני אלוהים. ");
INSERT INTO heblb_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","הוא חזר אל תלמידיו, וגם הפעם מצא אותם ישנים, כי עיניהם היו כבדות. הם לא ידעו כיצד לתרץ את הדבר. ");
INSERT INTO heblb_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","כשחזר אליהם ישוע בפעם השלישית הוא קרא: ”קומו! ישנתם מספיק? הגיעה השעה שבן־האדם יימסר לידי אנשים חוטאים. ");
INSERT INTO heblb_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","קומו, הבה נלך מכאן. הביטו, הנה מתקרב האיש שיסגיר אותי.“ ");
INSERT INTO heblb_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","לפני שהספיק ישוע לסיים את דבריו הגיע למקום יהודה, אחד משנים־עשר התלמידים, ואיתו המון שנשלח מטעם ראשי הכוהנים והסופרים והזקנים. כולם היו מצוידים בחרבות ובמקלות. ");
INSERT INTO heblb_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","יהודה תיאם איתם מראש ואמר: ”אני אגש לישוע ואנשק אותו, כדי שתדעו מיהו ותוכלו לתפוס אותו ולהוביל אותו בלוית משמר.“ ");
INSERT INTO heblb_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","יהודה ניגש אליו. ”רבי!“ קרא יהודה כשהוא מחבק ומנשק אותו. ");
INSERT INTO heblb_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","ואז תפסו את ישוע ואסרו אותו. ");
INSERT INTO heblb_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","פטרוס שלף מיד את חרבו והכה באחד מהם שהתברר להיות משרתו של הכהן הגדול, וקיצץ את אוזנו. ");
INSERT INTO heblb_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","”מדוע אתם מתנפלים עלי בחרבות ובמקלות?“ שאל ישוע. ”האם אני פושע מסוכן? ");
INSERT INTO heblb_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","מדוע לא אסרתם אותי בבית־המקדש? הרי לימדתי שם בכל יום ויכולתם לתפוס אותי ללא התנגדות. אבל מה שכתוב צריך להתקיים.“ ");
INSERT INTO heblb_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","בינתיים ברחו כל התלמידים. ");
INSERT INTO heblb_vpl VALUES ("MK14_51‏","071_14_51‏","MRK","14","51‏","52","נער אחד שהתלווה לישוע לבש סדין בלבד. כשניסו לתפוס אותו, הנער השאיר את הסדין בידם וברח מפניהם ערום. ");
INSERT INTO heblb_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","ישוע נלקח אל בית הכוהן הגדול, ועד מהרה התאספו שם כל ראשי הכוהנים, הזקנים והסופרים. ");
INSERT INTO heblb_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","פטרוס הלך אחריהם במרחק מה ונכנס לחצר הכוהן הגדול. הוא התיישב בין המשרתים והתחמם ליד המדורה. ");
INSERT INTO heblb_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","ראשי הכוהנים וחברי הסנהדרין ניסו למצוא סיבה מספקת כדי להוציא את ישוע להורג, אך מאמציהם היו לשווא. ");
INSERT INTO heblb_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","עדי שקר רבים התנדבו להעיד נגדו, אולם עדויותיהם סתרו זו את זו. ");
INSERT INTO heblb_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","לבסוף קמו עדי שקר נוספים שהעידו: ");
INSERT INTO heblb_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","”שמענו אותו אומר: ’אני אהרוס את המקדש הזה שנבנה בידי אדם, ותוך שלושה ימים אקים מקדש אחר שאינו מעשה ידי אדם!‘ “ ");
INSERT INTO heblb_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","אולם עדות זאת גם לא הייתה מספקת. ");
INSERT INTO heblb_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","הכהן הגדול עמד באמצע החדר ושאל את ישוע: ”מה יש לך לומר להגנתך? מה יש לך לומר על כל ההאשמות נגדך?“ ");
INSERT INTO heblb_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","ישוע לא פצה את פיו, והכהן הגדול המשיך לשאול אותו: ”האם אתה המשיח בן־האלוהים?“ ");
INSERT INTO heblb_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","”אני הוא,“ השיב ישוע, ”אתם עוד תראו את בן־האדם יושב לימין האלוהים, ובא בענני השמים.“ ");
INSERT INTO heblb_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","הכהן הגדול התרגז מאוד וקרע את בגדיו מעליו. ”למה אנו זקוקים עוד?“ שאל בכעס. ”איננו זקוקים להוכחות נוספות! ");
INSERT INTO heblb_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","שמעתם את הגידופים שלו. מהו פסק־דינכם?“ הם הצביעו פה אחד בעד הוצאתו להורג. ");
INSERT INTO heblb_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","לאחר השמעת פסק־הדין החל קהל הנוכחים לירוק על ישוע ולהתעלל בו. הם קשרו את עיניו והכו אותו בכל גופו. ”נחש מי הכה אותך, נביא שכמותך?“ לעגו לו. גם השומרים שלקחו אותו משם הכו אותו באגרופים. ");
INSERT INTO heblb_vpl VALUES ("MK14_66‏","071_14_66‏","MRK","14","66‏","67","כל אותו זמן היה פטרוס בחצר. אחת המשרתות בבית הכהן הגדול זיהתה את פטרוס שהתחמם ליד המדורה. היא הביטה בו בתשומת לב רבה והכריזה: ”אתה היית עם ישוע מנצרת!“ ");
INSERT INTO heblb_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","פטרוס הכחיש מיד את ההאשמה. ”אינני יודע כלל על מה את מדברת!“ אמר ועבר לקצה האחר של החצר. לפתע נשמעה קריאת התרנגול. ");
INSERT INTO heblb_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","המשרתת ראתה אותו עומד שם ולא הרפתה ממנו. ”הנה אחד התלמידים של ישוע!“ קראה בקול. ");
INSERT INTO heblb_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","פטרוס שוב הכחיש את דבריה. כעבור זמן מה קראו גם אלה שעמדו איתו ליד האש: ”הלא גם אתה אחד מהם? הרי יש לך מבטא גלילי!“ ");
INSERT INTO heblb_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","פטרוס החל לקלל ונשבע: ”אני בכלל לא מכיר את האיש שעליו אתם מדברים!“ ");
INSERT INTO heblb_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","באותו רגע קרא התרנגול בפעם השנייה. לפתע נזכר פטרוס בדברי ישוע: ”לפני שיקרא התרנגול פעמיים, תתכחש לי שלוש פעמים.“ והוא פרץ בבכי. ");
INSERT INTO heblb_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","השכם בבוקר נפגשו ראשי הכוהנים, הזקנים, הסופרים וכל חברי הסנהדרין כדי להתייעץ על הצעד הבא. הם החליטו לשלוח את ישוע בליווי משמר מזוין אל פילטוס, המושל הרומאי. ");
INSERT INTO heblb_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","”האם אתה מלך היהודים?“ שאל פילטוס. ”אתה אומר“, השיב ישוע. ");
INSERT INTO heblb_vpl VALUES ("MK15_3‏","071_15_3‏","MRK","15","3‏","4","ראשי הכוהנים האשימו אותו בפשעים רבים. ”מדוע אינך מגן על עצמך?“ שאל פילטוס בתמיהה. ”מה יש לך לומר?“ ");
INSERT INTO heblb_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","להפתעתו של פילטוס לא ענה ישוע דבר. ");
INSERT INTO heblb_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","כל שנה בחג הפסח נהג פילטוס להוציא לחופשי אסיר יהודי אחד, לפי בחירת העם. ");
INSERT INTO heblb_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","באותו זמן היה בכלא אסיר יהודי בשם בר־אבא, אשר הואשם ברצח (יחד עם אחרים) בעת אחת המרידות. ");
INSERT INTO heblb_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","בינתיים החל ההמון לבקש מפילטוס שישחרר אסיר אחד כמנהגו. ");
INSERT INTO heblb_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","”האם אתם רוצים שאוציא לחופשי את מלך היהודים?“ שאל פילטוס. ");
INSERT INTO heblb_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","הוא הציע לשחרר את ישוע, כי הבין שראשי הכוהנים אסרו אותו מתוך קנאה. ");
INSERT INTO heblb_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","אולם ראשי הכוהנים הסיתו את ההמון לדרוש את שחרורו של בר־אבא במקום שחרורו של ישוע. ");
INSERT INTO heblb_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","”אם אשחרר את בר־אבא, מה אעשה עם איש שאתם קוראים לו מלך היהודים?“ שאל פילטוס. ");
INSERT INTO heblb_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","”צלוב אותו!“ צעקו. ");
INSERT INTO heblb_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","”אבל מדוע?“ לא הבין פילטוס. ”מה עשה?“ הם לא ענו, ורק הגבירו את צעקותיהם: ”צלוב אותו!“ ");
INSERT INTO heblb_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","פילטוס רצה למנוע מהומות אז נכנע לדרישת ההמון. על כן שחרר את בר־אבא מבית־הסוהר וציווה להלקות את ישוע בשוטים. ");
INSERT INTO heblb_vpl VALUES ("MK15_16‏","071_15_16‏","MRK","15","16‏","17","לאחר מכן לקחו החיילים הרומאים את ישוע לחצר הארמון. הם קראו לכל חיילי המשמר, הלבישו את ישוע בגלימת ארגמן, הכינו לו זר מקוצים ארוכים ודוקרניים והניחו את הזר על ראשו. ");
INSERT INTO heblb_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","הם החלו ללעוג ולצחוק לו: ”יחי מלך היהודים!“ ");
INSERT INTO heblb_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","הם הכו אותו באכזריות, חבטו על ראשו במקלות, ירקו עליו, כרעו ברך לפניו והשתחוו לו בלעג. ");
INSERT INTO heblb_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","לאחר שסיימו החיילים להתלוצץ ולצחוק עליו, הפשיטו מעליו את הארגמן והלבישו אותו בבגדיו, והוציאו אותו החוצה לצליבה. ");
INSERT INTO heblb_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","החיילים פגשו בדרך את שמעון מקירניה (אביהם של אלכסנדר ורופוס), שחזר מהשדה, ואילצוהו לשאת את הצלב של ישוע למקום הצליבה. ");
INSERT INTO heblb_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","ישוע הובא למקום הנקרא ”גלגלתא“, כלומר ”מקום הגולגולת“. ");
INSERT INTO heblb_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","הם הגישו לו יין מסומם, אך הוא סרב לשתות. ");
INSERT INTO heblb_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","לאחר מכן הם צלבו אותו וערכו הגרלה על בגדיו. ");
INSERT INTO heblb_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","בשעה תשע בבוקר צלבו את ישוע. ");
INSERT INTO heblb_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","מעל ראשו היה תלוי שלט שאשמתו כתובה עליו: ”מלך היהודים“. ");
INSERT INTO heblb_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","באותו בוקר נצלבו איתו שני פושעים: אחד לימינו ואחד לשמאלו, ");
INSERT INTO heblb_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","וכך התקיים הפסוק: ”ואת פושעים נמנה.“ ");
INSERT INTO heblb_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","העוברים והשבים קללו אותו, לעגו לו וקראו: ”נו, אתה יכול להרוס את בית המקדש ולבנותו מחדש בשלושה ימים? ");
INSERT INTO heblb_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","אם אתה גיבור כזה, מדוע אינך מציל את עצמך ויורד מהצלב?“ ");
INSERT INTO heblb_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","גם ראשי הכוהנים והסופרים עמדו סביבו ולעגו לו. ”הוא יכול להושיע את כולם חוץ מאשר את עצמו!“ צחקו. ");
INSERT INTO heblb_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","”משיח שכמוהו!“ קראו. ”מלך ישראל, הבה נראה אותו יורד מהצלב, ואז נאמין למה שהוא אומר!“ גם שני הפושעים שנצלבו איתו קיללו אותו. ");
INSERT INTO heblb_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","בשעה שתים־עשרה בצהריים כיסה חושך את כל הארץ למשך שלוש שעות. ");
INSERT INTO heblb_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","בשעה שלוש אחר־הצהריים זעק ישוע זעקת שבר: ”אלי, אלי, למה שבקתני?“ (כלומר, ”אלי, אלי, למה עזבתני?“) ");
INSERT INTO heblb_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","אחדים מהאנשים שעמדו שם חשבו שהוא קורא לאליהו הנביא. ");
INSERT INTO heblb_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","איש אחד רץ והביא ספוג טבול בחומץ, שם אותו בקצה מוט ארוך והגיש אותו לישוע. ”הבה נראה אם אליהו באמת יבוא להוריד אותו!“ קרא האיש. ");
INSERT INTO heblb_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","באותו רגע זעק ישוע זעקת שבר נוספת ונפח את נשמתו. ");
INSERT INTO heblb_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","בבית־המקדש, הפרוכת התלויה לפני קודש הקודשים נקרעה לשניים מלמעלה למטה. ");
INSERT INTO heblb_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","קצין רומאי אחד, שעמד בין הצופים וראה כיצד נפח ישוע את נשמתו, קרא: ”האיש הזה באמת היה בן־אלוהים!“ ");
INSERT INTO heblb_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","גם נשים עמדו במרחק מה וחזו בצליבה; ביניהן היו מרים המגדלית, מרים (אמם של יעקב ויוסי) ושלומית. ");
INSERT INTO heblb_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","כל אלה האמינו בישוע ואף שרתו אותו בהיותו בגליל. היו שם עוד נשים רבות אשר הלכו אחריו לירושלים. ");
INSERT INTO heblb_vpl VALUES ("MK15_42‏","071_15_42‏","MRK","15","42‏","43","כל זה התרחש ביום שישי. עם רדת הערב, יהודי נכבד בשם יוסף מן הרמתיים ניגש לפילטוס וביקש את גופתו של ישוע. יוסף היה חבר בסנהדרין והאמין בביאת המשיח באותה עת. ");
INSERT INTO heblb_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","פילטוס לא האמין שישוע כבר מת, ולכן ביקש מאחד מקציניו שיוודא את הדבר. ");
INSERT INTO heblb_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","הקצין בדק ואישר שאכן ישוע כבר מת, ורק אז הרשה פילטוס ליוסף לקחת את הגופה. ");
INSERT INTO heblb_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","יוסף קנה סדין גדול, הוריד את גופת ישוע מהצלב, עטף אותה בסדין וקבר את ישוע בקבר חצוב בסלע. הוא סתם את פתח הקבר באבן גדולה. ");
INSERT INTO heblb_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","מרים המגדלית ומרים אמו של יוסי ראו את המקום שבו נקבר ישוע. ");
INSERT INTO heblb_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","במוצאי שבת הלכו מרים המגדלית, שלומית ומרים (אמו של יעקב) לקנות בשמים ומרקחות כדי למשוח את גופתו של ישוע. ");
INSERT INTO heblb_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","ביום ראשון השכם בבוקר הן הלכו לקבר, ");
INSERT INTO heblb_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","ובדרך שאלו את עצמן: ”מי יזיז לנו את האבן מפתח הקבר?“ ");
INSERT INTO heblb_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","אולם כשהגיעו אל הקבר גילו להפתעתן הרבה שמישהו הזיז את האבן הכבדה והקבר פתוח. ");
INSERT INTO heblb_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","הנשים נכנסו פנימה וראו בחור צעיר לבוש כולו לבן יושב בצד ימין. הנשים נחרדו. ");
INSERT INTO heblb_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","”אל תתפלאו כל כך“, אמר המלאך. ”האם אינכן מחפשות את ישוע מנצרת שנצלב? הוא איננו כאן, הוא קם לתחייה! הנה, כאן הייתה גופתו. ");
INSERT INTO heblb_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","לכו למסור את ההודעה הזאת לתלמידים, במיוחד לפטרוס: ” ’ישוע הולך לפניכם לגליל. אתם תראו אותו שם ממש כפי שאמר לכם לפני מותו‘.“ ");
INSERT INTO heblb_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","הנשים ברחו משם כל עוד רוחן בהן, מבוהלות ומפוחדות מכדי למסור את ההודעה. ");
INSERT INTO heblb_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","כאשר קם ישוע לתחייה ביום ראשון השכם בבוקר, פגש תחילה את מרים המגדלית שממנה גירש שבעה שדים. ");
INSERT INTO heblb_vpl VALUES ("MK16_10‏","071_16_10‏","MRK","16","10‏","11","מרים הלכה אל התלמידים ומצאה אותם מתאבלים ובוכים. ”ישוע חי!“ קראה בהתרגשות. ”ראיתי אותו“ אך איש לא האמין לה. ");
INSERT INTO heblb_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","לאחר מכן נגלה ישוע לשני תלמידים שהלכו בדרך מירושלים לכיוון השדות. השניים לא הכירו אותו בהתחלה, משום שהמראה שלו השתנה במידת מה. ");
INSERT INTO heblb_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","לבסוף, כאשר הבינו מי הוא, מיהרו לירושלים וסיפרו לאחרים, אך איש לא האמין להם. ");
INSERT INTO heblb_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","מאוחר יותר נגלה ישוע לאחד־עשר התלמידים בשעת הארוחה. הוא הוכיח אותם על חוסר אמונתם, ועל העקשנות שלהם לא להאמין לעדים שסיפרו כי ראו את ישוע קם לתחייה. ");
INSERT INTO heblb_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","לאחר מכן הוא ציווה עליהם: ”לכו אל כל העולם להכריז על הבשורה לכל אדם. ");
INSERT INTO heblb_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","מי שיאמין וייטבל ייוושע; מי שיסרב להאמין יואשם בעיני אלוהים. ");
INSERT INTO heblb_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","”למאמינים בשמי אתן סמכות לגרש שדים; הם ידברו בלשונות חדשות; ");
INSERT INTO heblb_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","הם אף יוכלו להחזיק נחשים בידיהם ולא יקרה להם דבר; הם יוכלו לסמוך את ידיהם על אנשים חולים ולרפא אותם.“ ");
INSERT INTO heblb_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","וכאשר סיים האדון ישוע לדבר אליהם, הוא נלקח לשמים לשבת לימין האלוהים. ");
INSERT INTO heblb_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","התלמידים הלכו לכל מקום והכריזו את הבשורה. האדון חיזק ועודד אותם, וחולל באמצעותם ניסים ונפלאות אשר אישרו וחיזקו את עדותם.");
INSERT INTO heblb_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","תאופילוס היקר, אנשים רבים כבר כתבו על הדברים שהתרחשו בינינו, ");
INSERT INTO heblb_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","על־פי סיפוריהם של תלמידי ישוע ושל עדי ראייה אחרים. ");
INSERT INTO heblb_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","גם אני חקרתי היטב את התרחשות הדברים מתחילתם, והחלטתי כי טוב שאכתוב לך אותם לפי סדר העניינים, ");
INSERT INTO heblb_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","כדי שיהיה לך מידע מדויק על הנושא שלמדת. ");
INSERT INTO heblb_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","בימי הורדוס מלך יהודה היה בארץ כהן בשם זכריה, אשר היה שייך למחלקת אביה – ממשרתי בית־המקדש. גם אשתו אלישבע הייתה ממשפחה כוהנית. ");
INSERT INTO heblb_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","זכריה ואלישבע היו אנשים צדיקים, אשר אהבו את ה׳ ושמרו את כל מצוותיו וחוקותיו. ");
INSERT INTO heblb_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","אולם לא היו להם ילדים, כי אלישבע הייתה עקרה, ושניהם כבר היו זקנים. ");
INSERT INTO heblb_vpl VALUES ("LK1_8‏","072_1_8‏","LUK","1","8‏","9","יום אחד, כאשר הייתה מחלקתו של זכריה בתורנות בבית־המקדש, נפל בגורלו להיכנס אל היכל ה׳ ולהקטיר קטורת. ");
INSERT INTO heblb_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","בינתיים עמד כל העם בחוץ והתפלל, כנהוג בעת הקטרת הקטורת. ");
INSERT INTO heblb_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","לפתע נראה מלאך ה׳ אל זכריה מימין למזבח הקטורת. ");
INSERT INTO heblb_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","זכריה נבהל ונמלא פחד. ");
INSERT INTO heblb_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","”אל תירא, זכריה“, הרגיע אותו המלאך. ”באתי לבשר לך שאלוהים שמע את תפילתך, ושאשתך אלישבע תלד לך בן! עליך לקרוא לו ’יוחנן‘. ");
INSERT INTO heblb_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","לידתו תביא לכם שמחה ואושר, ואנשים רבים ישמחו יחד אתכם, ");
INSERT INTO heblb_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","כי ה׳ הועיד אותו לגדולות. עליו להינזר מיין ומשקאות חריפים, והוא יימלא ברוח הקודש מעת לידתו. ");
INSERT INTO heblb_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","יוחנן ישיב רבים מעם ישראל אל ה׳ אלוהיהם. ");
INSERT INTO heblb_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","הוא ילך לפני ה׳ ברוחו ובגבורתו של אליהו הנביא, ישלים בין אבות לבנים, וישיב את המרדנים לדרך הצדקה והתבונה. אכן, הוא יכין את העם לבואו של האדון.“ ");
INSERT INTO heblb_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","”כיצד אדע שדבריך נכונים?“ שאל זכריה. ”הלא אדם זקן אני, וגם אשתי כבר זקנה.“ ");
INSERT INTO heblb_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","”אני המלאך גבריאל!“ השיב המלאך. ”אני עומד לפני אלוהים, והוא אשר שלח אותי לבשר לך את ההודעה הזאת. ");
INSERT INTO heblb_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","דע לך כי כל אשר אמרתי יתקיים בבוא הזמן, אולם מאחר שלא האמנת לדברי, לא תוכל להוציא מילה מפיך מרגע זה ועד שיתקיימו דברי!“ ");
INSERT INTO heblb_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","האנשים אשר התפללו בחוץ המתינו בינתיים לזכריה, ולא הבינו מדוע התעכב. ");
INSERT INTO heblb_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","לבסוף, כשיצא זכריה החוצה הוא לא יכול היה לדבר אל העם, אולם מסימני ידיים הבינו האנשים שראה חזיון. ");
INSERT INTO heblb_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","זכריה נשאר בבית־המקדש עד תום ימי התורנות של מחלקתו, ולאחר מכן שב לביתו. ");
INSERT INTO heblb_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","כעבור זמן קצר הרתה אלישבע אשתו והסתתרה מעיני הציבור כחמישה חודשים. ");
INSERT INTO heblb_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","”מה טוב הוא אלוהים!“ קראה אלישבע בשמחה רבה. ”ברחמיו הרבים הוא הסיר את חרפת עקרותי!“ ");
INSERT INTO heblb_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","בחודש השישי להריונה של אלישבע שלח אלוהים את המלאך גבריאל אל העיר נצרת שבגליל, ");
INSERT INTO heblb_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","אל נערה בתולה בשם מרים, ארוסתו של יוסף משושלת בית־דוד. ");
INSERT INTO heblb_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","גבריאל נגלה אל מרים ואמר לה: ”שלום לך, אשת חן, ה׳ עמך!“ ");
INSERT INTO heblb_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","מרים נבהלה לרגע; דברי המלאך הביכו אותה, והיא ניסתה לנחש בלבה למה הוא התכוון. ");
INSERT INTO heblb_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","”אל תפחדי, מרים,“ הרגיע אותה המלאך, ”כי מצאת חן בעיני אלוהים והוא החליט לברך אותך. ");
INSERT INTO heblb_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","בעוד זמן קצר תיכנסי להריון ותלדי בן. בשם ’ישוע‘ תקראי לו. ");
INSERT INTO heblb_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","הוא יהיה רם־מעלה וייקרא בן־אלוהים. ה׳ ייתן לו את כסא דוד אביו, ");
INSERT INTO heblb_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","והוא ימלוך על עם־ישראל לעולם ועד; מלכותו לא תסתיים לעולם.“ ");
INSERT INTO heblb_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","”כיצד אוכל ללדת?“ שאלה מרים בתמיהה. ”הרי אני בתולה!“ ");
INSERT INTO heblb_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","השיב לה המלאך: ”רוח הקודש תבוא אליך, וגבורת אלוהים תצל עליך. משום כך הבן הקדוש שייוולד ייקרא בן־אלוהים.“ ");
INSERT INTO heblb_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","המלאך המשיך: ”לפני שישה חודשים נכנסה קרובתך הזקנה אלישבע להריון – כן, זו ששכנותיה קראו לה ’העקרה‘ – וגם היא תלד בן! ");
INSERT INTO heblb_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","כי אין דבר בלתי אפשרי לאלוהים“. ");
INSERT INTO heblb_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","”הנני שפחתך, אדוני,“ אמרה מרים בענווה, ”ואני מוכנה לעשות את כל אשר יאמר לי. אמן שיתקיימו דבריך.“ לאחר מכן נעלם המלאך. ");
INSERT INTO heblb_vpl VALUES ("LK1_39‏","072_1_39‏","LUK","1","39‏","40","כעבור ימים אחדים מיהרה מרים אל הרי יהודה, אל ביתו של זכריה, ובהיכנסה אל הבית ברכה את אלישבע לשלום. ");
INSERT INTO heblb_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","לשמע ברכתה של מרים התנועע התינוק בבטנה של אלישבע, והיא נמלאה ברוח הקודש. ");
INSERT INTO heblb_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","”ברוכה את בנשים, מרים, וברוך תינוקך!“ פרצה אלישבע בקריאת שמחה. ");
INSERT INTO heblb_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","”מדוע זכיתי בכבוד הגדול שאם אדוני באה לבקר אותי? ");
INSERT INTO heblb_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","התינוק בבטני התנועע בשמחה לשמע קול ברכתך! ");
INSERT INTO heblb_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","אלוהים ברך אותך בצורה נפלאה כזאת משום שהאמנת כי יקיים את דבריו.“ ");
INSERT INTO heblb_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","השיבה מרים: ”ברכי נפשי את ה׳; ");
INSERT INTO heblb_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","אגיל ואשמח באלוהים מושיעי! ");
INSERT INTO heblb_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","כי עשה חסד עם שפחתו, ומעתה יברכוני כל הדורות. ");
INSERT INTO heblb_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","גדולות ונפלאות עשה עמי אל שדי, קדוש שמו. ");
INSERT INTO heblb_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","מדור לדור הוא מעניק את חסדו ורחמיו לכל היראים אותו. ");
INSERT INTO heblb_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","בזרוע נטויה עשה מעשי גבורה, הפר מזימות גאים ורשעים, ");
INSERT INTO heblb_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","והוריד שליטים מכיסאם. אולם את השפלים והנחותים הוא רומם! ");
INSERT INTO heblb_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","את העניים האכיל ואת העשירים הרעיב! ");
INSERT INTO heblb_vpl VALUES ("LK1_54‏","072_1_54‏","LUK","1","54‏","55","אלוהים תמך בעבדו ישראל, ולא שכח כי הבטיח לאבותינו – לאברהם ולזרעו – לרחם על ישראל לעולם ועד!“ ");
INSERT INTO heblb_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","מרים נשארה אצל אלישבע כשלושה חודשים, ולאחר מכן חזרה לביתה. ");
INSERT INTO heblb_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","בינתיים תמו ימי הריונה של אלישבע והיא ילדה בן. ");
INSERT INTO heblb_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","השמועה על החסד שעשה איתה ה׳ התפשטה עד מהרה בין שכניה וקרובי משפחתה, וכולם שמחו בשמחתה. ");
INSERT INTO heblb_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","ביום השמיני להולדת התינוק התכנסו השכנים והקרובים לטקס ברית־המילה. האורחים היו בטוחים שהתינוק ייקרא ”זכריה“ – על שם אביו, ");
INSERT INTO heblb_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","אולם אלישבע אמרה: ”לא, שם התינוק יוחנן!“ ");
INSERT INTO heblb_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","”יוחנן?“ התפלאו האורחים. ”אבל אין במשפחתך אף אחד בשם הזה“. ");
INSERT INTO heblb_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","הם פנו אל זכריה (שעדיין לא היה מסוגל לדבר), ושאלו אותו בתנועות ידיים וברמזים כיצד ייקרא התינוק. ");
INSERT INTO heblb_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","זכריה ביקש בתנועות ידיים שיביאו לו לוח, וכתב עליו: ”שם הילד יוחנן“. ");
INSERT INTO heblb_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","באותו רגע חזר אליו כושר הדיבור והוא החל לברך את אלוהים. ");
INSERT INTO heblb_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","כל השכונה נמלאה יראת כבוד, והדבר היה נושא לשיחה בכל הרי יהודה. ");
INSERT INTO heblb_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","כל השומעים התרשמו עמוקות ואמרו: ”מעניין למה נועד הילד הזה.“ כי היה ברור להם שאלוהים איתו. ");
INSERT INTO heblb_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","לאחר מכן נמלא זכריה אביו רוח הקודש וניבא את הנבואה הבאה: ");
INSERT INTO heblb_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","”ברוך ה׳ אלוהי ישראל, כי פנה אל עמו, הודיע ופדה אותו. ");
INSERT INTO heblb_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","ה׳ שלח לנו מושיע גיבור משושלת בית דוד עבדו – ");
INSERT INTO heblb_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","כפי שהבטיח לנו בפי נביאיו הקדושים עוד לפני זמן רב – ");
INSERT INTO heblb_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","כדי להצילנו מיד כל אויבינו ושונאינו. ");
INSERT INTO heblb_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","אלוהים יעשה חסד עם אבותינו ויזכור את בריתו ");
INSERT INTO heblb_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","ואת שבועתו לאברהם אבינו: ");
INSERT INTO heblb_vpl VALUES ("LK1_74‏","072_1_74‏","LUK","1","74‏","75","להצילנו מיד אויבינו, ולהעניק לנו את הזכות לשרתו כל ימי חיינו בקדושה, ובצדקה וללא פחד.“ ");
INSERT INTO heblb_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","”ואתה, ילדי הקטן, תיקרא נביא לאל עליון, כי תלך לפני האדון ותפנה לו את הדרך. ");
INSERT INTO heblb_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","אתה תלמד את בני־ישראל כיצד הם יכולים להיוושע על־ידי סליחת חטאיהם. ");
INSERT INTO heblb_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","בזכות אהבתו, רחמיו וטוב־לבו של אלוהים יזרח עלינו אור ממרום, ");
INSERT INTO heblb_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","כדי להאיר לשרויים במוות ובחשכה, וכדי להוביל את רגלינו אל דרך השלום.“ ");
INSERT INTO heblb_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","הילד גדל, התחזק והתחשל באופיו. הוא התגורר במדבר עד שהגיע המועד להתחיל את שליחותו אל עם־ישראל. ");
INSERT INTO heblb_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","באותה תקופה ציווה הקיסר הרומאי אוגוסטוס לפקוד את כל תושבי האימפריה הרומית. ");
INSERT INTO heblb_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","זה היה מפקד התושבים הראשון, והוא נערך בזמן שקוריניוס היה שליט סוריה. ");
INSERT INTO heblb_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","לצורך המפקד נדרש כל אדם לשוב אל עיר מולדתו. ");
INSERT INTO heblb_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","גם יוסף, תושב נצרת שבגליל, חזר אל עיר מולדתו – הוא הלך אל העיר בית לחם ביהודה, מאחר שהיה נצר למשפחת דוד המלך. ");
INSERT INTO heblb_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","אל יוסף נלוותה ארוסתו מרים שהייתה בהיריון. ");
INSERT INTO heblb_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","בהיותם בבית־לחם מרים החלה בצירי לידה, ");
INSERT INTO heblb_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","וילדה את בנה הבכור. היא עטפה את התינוק והשכיבה אותו באבוס, כי לא השיגו מקום לינה באכסניות שהיו מלאות עד אפס מקום לרגל המפקד. ");
INSERT INTO heblb_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","בקרבת מקום היו רועי־צאן אשר ישנו בשדה ושמרו על עדרם במשך הלילה. ");
INSERT INTO heblb_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","לפתע נגלה אליהם מלאך ה׳, והשדה נמלא זוהר כבוד ה׳. הרועים נבהלו מאוד, ");
INSERT INTO heblb_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","אולם המלאך הרגיע אותם ואמר: ”אל תפחדו! באתי לבשר לכם חדשות משמחות ביותר – לא לכם בלבד, כי אם לכל העם! ");
INSERT INTO heblb_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","בבית־לחם עיר דוד נולד לכם היום מושיע, הלא הוא המשיח האדון! ");
INSERT INTO heblb_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","כהוכחה לאמיתות דברי תמצאו תינוק עטוף שוכב באבוס.“ ");
INSERT INTO heblb_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","לפתע הצטרפו אל המלאך צבאות השמים, והם שרו שיר שבח ותהילה לאלוהים: ");
INSERT INTO heblb_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","”כבוד ותהילה לאלוהים במרומי השמים, ושלום על־פני האדמה לכל אוהביו העושים את רצונו!“ ");
INSERT INTO heblb_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","כאשר נעלמו המלאכים מעיני הרועים וחזרו לשמים, אמרו הרועים איש אל רעהו: ”הבא נמהר לבית־לחם כדי לראות את מה שגילה לנו אלוהים.“ ");
INSERT INTO heblb_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","הם מיהרו העירה ומצאו את מרים, את יוסף ואת התינוק שוכב באבוס. ");
INSERT INTO heblb_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","מיד סיפרו הרועים לכולם את אשר קרה להם בשדה, ואת דברי המלאך על אודות הילד הזה. ");
INSERT INTO heblb_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","כל השומעים תמהו מאוד על דברי הרועים, ");
INSERT INTO heblb_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","ובכל זאת מרים שמרה את הדברים בלבה והרהרה בהם לעתים קרובות. ");
INSERT INTO heblb_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","לאחר מכן חזרו הרועים אל השדה, כשהם מהללים ומשבחים את אלוהים על ביקור המלאך ועל שמצאו את התינוק כדבריו. ");
INSERT INTO heblb_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","כעבור שמונה ימים, בטקס ברית־המילה, ניתן לתינוק השם ”ישוע“ – השם שנתן לו המלאך עוד לפני הריונה של מרים. ");
INSERT INTO heblb_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","בתום ימי הטהרה של מרים הביאו היא ובעלה את הילד לירושלים, להעמידו לפני ה׳, ");
INSERT INTO heblb_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","כי כתוב בתורה שצריך להקדיש לה׳ את הבן הבכור של כל אם, ");
INSERT INTO heblb_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","ולהקריב קרבן כדרישת התורה: שני תורים או שתי יונים צעירות. ");
INSERT INTO heblb_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","בירושלים גר אדם בשם שמעון אשר היה צדיק וחסיד, מלא ברוח הקודש וחי בציפייה מתמדת לגאולת ישראל. ");
INSERT INTO heblb_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","רוח הקודש גילה לשמעון הצדיק שלא ימות לפני שיראה במו עיניו את משיח ה׳. ");
INSERT INTO heblb_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","באותו יום הדריך רוח הקודש את שמעון אל בית־המקדש, וכאשר הביאו מרים ויוסף את הילד לפני אלוהים, כמצוות התורה, ");
INSERT INTO heblb_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","הרים שמעון את הילד בזרועותיו, אימץ אותו אל לבו, ברך את אלוהים ואמר: ");
INSERT INTO heblb_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","”אלוהי, עתה אני יכול למות במנוחה, כי קיימת את אשר הבטחת לי; ");
INSERT INTO heblb_vpl VALUES ("LK2_30‏","072_2_30‏","LUK","2","30‏","31","במו עיני ראיתי את המשיח שנתת לעולם! ");
INSERT INTO heblb_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","הוא האור אשר יאיר את עיני העמים ויהיה תפארת עמך ישראל!“ ");
INSERT INTO heblb_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","יוסף ומרים תמהו על הנאמר אודות בנם. ");
INSERT INTO heblb_vpl VALUES ("LK2_34‏","072_2_34‏","LUK","2","34‏","35","שמעון ברך אותם ואחר כך אמר למרים: ”מרים, לבך יידקר בחרב הייסורים, כי ילדך זה נועד להכשיל רבים בישראל ולהושיע רבים. הוא יהיה נושא למריבה וחילוקי־דעות, כי יחשוף את מחשבותיהם האפלות של אנשים רבים.“ ");
INSERT INTO heblb_vpl VALUES ("LK2_36‏","072_2_36‏","LUK","2","36‏","37","בבית־המקדש הייתה גם נביאה זקנה בשם חנה בת־פנואל, משבט אשר. היא הייתה אלמנה כבת 84 שנים, אך נישואיה לבעלה נמשכו שבע שנים בלבד. חנה לא עזבה את המקדש לרגע; היא אהבה את אלוהים ושרתה אותו יומם ולילה בצום, בתפילה ובתחנונים. ");
INSERT INTO heblb_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","חנה שמעה את ברכתו של שמעון, והחלה לברך את שם אלוהים ולספר לאנשי ירושלים, שציפו לגאולת המשיח, כי סוף־סוף בא המשיח! ");
INSERT INTO heblb_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","לאחר שקיימו הוריו של ישוע את כל מצוות התורה הנוגעות לרך הנולד, חזרו לביתם – אל נצרת עירם אשר בגליל. ");
INSERT INTO heblb_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","הילד גדל התחזק, מלא חכמה, וחסד אלוהים היה עליו. ");
INSERT INTO heblb_vpl VALUES ("LK2_41‏","072_2_41‏","LUK","2","41‏","42","כשמלאו לישוע שתים־עשרה שנים עלו הוריו לירושלים – כמנהגם מדי שנה – כדי לחוג את חג הפסח. ");
INSERT INTO heblb_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","בתום החג החלו הוריו במסע חזרה הביתה, ואילו ישוע נשאר בירושלים ללא ידיעתם. ");
INSERT INTO heblb_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","הוריו לא דאגו לו ביום הראשון למסע, כי הניחו שהיה בחברת ידידים שבין אנשי השיירה. אולם בראותם שלא הופיע עד הערב, החלו לחפשו בין החברים והמכרים, ");
INSERT INTO heblb_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ומשלא מצאו אותו, חזרו לירושלים בתקווה למצאו שם. ");
INSERT INTO heblb_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","לאחר שלושה ימי חיפושים הם מצאו את ישוע בבית־המקדש. הוא ישב בין הרבנים, הקשיב לדבריהם ושאל אותם שאלות נבונות. ");
INSERT INTO heblb_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","כל שומעיו התפעלו בפקחותו, מהבנתו ומתשובותיו. ");
INSERT INTO heblb_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","הוריו הופתעו למצוא אותו שם, ואמו אמרה לו: ”בני, מדוע עוללת לנו זאת? אביך ואני דאגנו לך כל כך וחיפשנו אותך בכל מקום.“ ");
INSERT INTO heblb_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","”מדוע חיפשתם אותי?“ שאל ישוע בתמיהה. ”האם לא ידעתם שאהיה עסוק בענייני אבי?“ ");
INSERT INTO heblb_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","אולם הם לא הבינו למה התכוון. ");
INSERT INTO heblb_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","ישוע חזר עם הוריו לנצרת והיה נכנע למרותם. אמו שמרה בלבה את כל מה שהתרחש. ");
INSERT INTO heblb_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","ישוע הלך וגדל בקומה ובחוכמה, והיה אהוב על אלוהים ובני אדם. ");
INSERT INTO heblb_vpl VALUES ("LK3_1‏","072_3_1‏","LUK","3","1‏","2","בשנה החמש־עשרה למלכותו של הקיסר טיבריוס, דיבר ה׳ אל יוחנן בן־זכריה שהתגורר במדבר. (באותה שנה היה פונטיוס פילטוס מושל יהודה; הורדוס – מושל הגליל; פיליפוס אחיו – מושל מדינות יטור וטרכונה; לוסניס – מושל אבילין; חנן וקייפא היו הכוהנים הגדולים). ");
INSERT INTO heblb_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","יוחנן החל לבקר בכל הערים והכפרים באזור הירדן וקרא לאנשים להיטבל במים, כדי להראות שהם מתחרטים על מעשיהם הרעים ובוחרים להאמין באלוהים, על־מנת שיסלח לחטאיהם. ");
INSERT INTO heblb_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","יוחנן קיים את דברי ישעיהו הנביא: ”קול קורא במדבר פנו דרך ה׳, ישרו מסילותיו. ");
INSERT INTO heblb_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","כל גיא יינשא, וכל הר וגבעה ישפלו. והיה העקב למישור והרכסים לבקעה, ");
INSERT INTO heblb_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","וראו כל בשר את ישועת אלוהים.“ ");
INSERT INTO heblb_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","יוחנן היה אומר לאנשים הרבים שבאו להיטבל על־ידו: ”בני נחשים אתם! מי אמר לכם שתוכלו להימלט מהעונש שה׳ עתיד להביא עליכם? ");
INSERT INTO heblb_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","לפני שתיטבלו עליכם להוכיח במעשים שאתם באמת מתחרטים על מעשיכם הרעים. אל תחשבו בלבכם: ’אלוהים לא יעניש אותנו כי אנחנו יהודים, בני אברהם‘. הרי אלוהים יכול לעשות מהאבנים האלה בנים לאברהם! ");
INSERT INTO heblb_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","כבר עכשיו מוכן גרזן המשפט של אלוהים לכרות כל עץ חסר תועלת שאינו נושא פרי. עצים חסרי תועלת ייכרתו ויישרפו!“ ");
INSERT INTO heblb_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","לשמע דברי יוחנן נהג הקהל לשאול אותו: ”מה עלינו לעשות כדי להוכיח שאנו מתחרטים על מעשינו הרעים ומאמינים באלוהים?“ ");
INSERT INTO heblb_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","”מי שיש לו שתי חולצות,“ השיב יוחנן, ”שייתן אחת מהן למי שאין לו אף אחת. מי שיש לו מספיק אוכל – שייתן לרעב.“ ");
INSERT INTO heblb_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","גם גובי מכס, שהיו ידועים בשחיתותם, באו להיטבל ושאלו: ”רבי, כיצד נוכיח את כנות לבנו?“ ");
INSERT INTO heblb_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","”אל תגבו למעלה מהמס הקבוע בחוק“, השיב יוחנן. ");
INSERT INTO heblb_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","”ומה עלינו לעשות?“ שאלו מספר חיילים. ”אל תסחטו כספים באיומים ובאלימות,“ השיב יוחנן, ”אל תוציאו דיבה על איש, הסתפקו במשכורתכם.“ ");
INSERT INTO heblb_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","מאחר שכל העם ציפה וייחל לבואו של המשיח, תהה כל אחד בלבו אם יוחנן עצמו הוא המשיח. ");
INSERT INTO heblb_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","יוחנן העמידם על טעותם ואמר: ”אני מטביל אתכם במים, אולם בקרוב יבוא אדם גדול ונעלה ממני – הוא כל כך נעלה עד כי איני ראוי להתיר את שרוכי נעליו – והוא יטביל אתכם ברוח הקודש ובאש. ");
INSERT INTO heblb_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","הוא גם יפריד בין המוץ לבין גרגירי החיטה – את המוץ ישרוף באש נצחית, ואילו את החיטה ישמור באסם.“ ");
INSERT INTO heblb_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","יוחנן השתמש באזהרות רבות מסוג זה כדי להוכיח את העם ולהעביר להם את הבשורה. ");
INSERT INTO heblb_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","אולם כשהוכיח יוחנן את הורדוס (מושל הגליל) על מעשיו הרעים, ובמיוחד על נישואיו האסורים להורודיה – אשת אחיו פיליפוס – ");
INSERT INTO heblb_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","השליך הורדוס את יוחנן לבית־סוהר, וכך הוסיף על חטאיו. ");
INSERT INTO heblb_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","יום אחד, לאחר שנטבלו אנשים רבים, נטבל גם ישוע. כאשר התפלל נפתחו השמים ");
INSERT INTO heblb_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ורוח הקודש בדמות יונה ירדה ונחה עליו, ומן השמים קרא קול: ”אתה בני אהובי, מקור שמחתי.“ ");
INSERT INTO heblb_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","ישוע היה כבן שלושים שנה כשהחל בפעילותו בציבור. ישוע נחשב לבנו של יוסף. יוסף היה בנו של עלי; ");
INSERT INTO heblb_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","עלי היה בנו של מתת; מתת היה בנו של לוי; לוי היה בנו של מלכי; מלכי היה בנו יני; יני היה בנו של יוסף; יוסף היה בנו של מתתיה; ");
INSERT INTO heblb_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","מתתיה היה בנו של אמוץ; אמוץ היה בנו של נחום; נחום היה בנו של חסלי; חסלי היה בנו של נגי; ");
INSERT INTO heblb_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","נגי היה בנו של מחת; מחת היה בנו של מתתיה; מתתיה היה בנו של שמעי; שמעי היה בנו של יוסף; יוסף היה בנו של יודה; ");
INSERT INTO heblb_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","יודה היה בנו של יוחנן; יוחנן היה בנו של רישא; רישא היה בנו של זרובבל; זרובבל היה בנו של שאלתיאל; שאלתיאל היה בנו של נרי; ");
INSERT INTO heblb_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","נרי היה בנו של מלכי; מלכי היה בנו של אדי; אדי היה בנו של קוסם; קוסם היה בנו של אלמדם; אַלְמוֹדָם היה בנו של ער; ");
INSERT INTO heblb_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ער היה בנו של ישוע; ישוע היה בנו של אליעזר; אליעזר היה בנו של יורים; יורים היה בנו של מתת; מתת היה בנו של לוי; ");
INSERT INTO heblb_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","לוי היה בנו של שמעון; שמעון היה בנו של יהודה; יהודה היה בנו של יוסף; יוסף היה בנו של יונם; יונם היה בנו של אליקים; ");
INSERT INTO heblb_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","אליקים היה בנו של מַלְאָה; מַלְאָה היה בנו של מנא; מנא היה בנו של מתתה; מתתה היה בנו של נתן; נתן היה בנו של דוד; ");
INSERT INTO heblb_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","דוד היה בנו של ישי; ישי היה בנו של עובד; עובד היה בנו של בועז; בועז היה בנו של שלמון; שלמון היה בנו של נחשון; ");
INSERT INTO heblb_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","נחשון היה בנו של עמינדב; עמינדב היה בנו של ארני; ארם היה בנו של חצרון; חצרון היה בנו של פרץ; פרץ היה בנו של יהודה; ");
INSERT INTO heblb_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","יהודה היה בנו של יעקב; יעקב היה בנו של יצחק; יצחק היה בנו של אברהם; אברהם היה בנו של תרח; תרח היה בנו של נחור; ");
INSERT INTO heblb_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","נחור היה בנו של שרוג; שרוג היה בנו של רעו; רעו היה בנו של פלג; פלג היה בנו של עבר; עבר היה בנו של שלח; ");
INSERT INTO heblb_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","שלח היה בנו של קינן; קינן היה בנו של ארפכשד; ארפכשד היה בנו של שם; שם היה בנו של נוח; נוח היה בנו של לֶמֶךְ; ");
INSERT INTO heblb_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","לֶמֶךְ היה בנו של מתושלח; מתושלח היה בנו של חנוך; חנוך היה בנו של ירד; ירד היה בנו של מהללאל; מהללאל היה בנו של קינן; ");
INSERT INTO heblb_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","קינן היה בנו של אנוש; אנוש היה בנו של שת; שת היה בנו של אדם; אדם היה בנו של אלוהים. ");
INSERT INTO heblb_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","ישוע חזר מן הירדן מלא רוח הקודש, והרוח הובילה אותו אל המדבר – ");
INSERT INTO heblb_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","שם ניסה אותו השטן במשך ארבעים יום. במשך כל אותו זמן לא אכל ישוע דבר, ובתום ימי הניסיון היה רעב מאוד. ");
INSERT INTO heblb_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","”אם אתה באמת בן־אלוהים,“ אמר לו השטן, ”צווה על האבן הזאת להפוך ללחם!“ ");
INSERT INTO heblb_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","אולם ישוע השיב: ”כתוב: ’לא על הלחם לבדו יחיה האדם, (כי על כל מוצא פי ה)‘. “ ");
INSERT INTO heblb_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","לאחר מכן העלה השטן את ישוע, בחזיון רגעי הראה לו את כל המדינות המפוארות שבעולם ואמר: ");
INSERT INTO heblb_vpl VALUES ("LK4_6‏","072_4_6‏","LUK","4","6‏","7","”אני אתן לך את כל הממלכות המפוארות האלה ואת כבודן – כי לי נמסר השלטון ורשאי אני לתת אותו למי שארצה – אבל בתנאי אחד: עליך לכרוע ברך ולהשתחוות לפני.“ ");
INSERT INTO heblb_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","אולם ישוע השיב לו: ”אך כתוב: ’לה׳ אלוהיך תשתחווה, ואותו לבדו תעבוד‘. “ ");
INSERT INTO heblb_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","השטן לקח את ישוע לירושלים, העלהו על גג בית־המקדש ואמר: ”אם אתה באמת בן־אלוהים, קפוץ למטה! ");
INSERT INTO heblb_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","הרי כתוב בתנ״ך: ’כי מלאכיו יצווה לך לשמרך… ");
INSERT INTO heblb_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","על כפיים ישאונך פן תיגוף באבן רגלך‘. “ ");
INSERT INTO heblb_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","”אולם כתוב: ’לא תנסה את ה׳ אלוהיך‘, “ השיב לו ישוע. ");
INSERT INTO heblb_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","כאשר סיים השטן לנסות את ישוע עזב אותו לנפשו עד לעת מועד. ");
INSERT INTO heblb_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","לאחר מכן חזר ישוע לגליל כשהוא מלא בכוח רוח הקודש, ועד מהרה התפרסם בכל האזור. ");
INSERT INTO heblb_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","ישוע לימד את העם בבתי־הכנסת וכולם הללו ושיבחו אותו. ");
INSERT INTO heblb_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","ישוע בא אל נצרת – העיר שבה בילה את ילדותו – ובשבת הלך כמנהגו לבית־הכנסת. כשקם על רגליו כדי לקרוא את ההפטרה, ");
INSERT INTO heblb_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","הגישו לו את ספר ישעיהו. ישוע פתח את המגילה וקרא בקול: ");
INSERT INTO heblb_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","”רוח ה׳ עלי, יען משח ה׳ אותי לבשר ענוים; שלחני לחבש לנשברי לב, לקרוא לשבוים דרור ולאסורים – פְּקַח־קוֹחַ; ");
INSERT INTO heblb_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","לקרוא שנת רצון לה׳.“ ");
INSERT INTO heblb_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","ישוע גלל את המגילה, החזירה לחזן וישב במקומו. כל באי בית־הכנסת נעצו בו את עיניהם בציפייה, ");
INSERT INTO heblb_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","וישוע הוסיף: ”היום התקיימו דברי הפסוקים האלה בקרבכם!“ ");
INSERT INTO heblb_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","כולם הקשיבו לדבריו והתפלאו על דברי החן והחוכמה שיצאו מפיו. ”איך ייתכן הדבר?“ שאלו איש את רעהו. ”האין זה בנו של יוסף?“ ");
INSERT INTO heblb_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","ישוע ענה להם: ”ודאי תאמרו לי: ’רופא, רפא תחילה את עצמך!‘ או במילים אחרות: ’מדוע אינך מחולל כאן, בעיר מולדתך, את הניסים והנפלאות שחוללת בכפר־נחום?‘ ");
INSERT INTO heblb_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","אני אומר לכם: אין נביא בעירו! את הנביא מכבדים בכל מקום חוץ מאשר בביתו ובין בני־עמו. ");
INSERT INTO heblb_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","”בימי אליהו הנביא לא ירד גשם במשך שלוש וחצי שנים, והבצורת גרמה לרעב גדול בכל הארץ. למרות שהיו בישראל אלמנות רבות שרעבו ללחם, ");
INSERT INTO heblb_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","לא שלח אלוהים את אליהו אל אף אחת מהן! אלוהים שלח את אליהו רק אל אלמנה לא יהודיה בעיירה צרפת שבצידון. ");
INSERT INTO heblb_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","או קחו לדוגמה את אלישע; אף כי בימי אלישע הנביא היו מצורעים רבים בישראל, הוא לא ריפא איש מהם, אלא דווקא את נעמן הארמי.“ ");
INSERT INTO heblb_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","דברי ישוע עוררו את זעמם. ");
INSERT INTO heblb_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","הם קפצו מכיסאותיהם ודחפו אותו אל מחוץ לעיר, אל פסגת ההר שעליו נבנתה נצרת, במטרה להשליכו במדרון. ");
INSERT INTO heblb_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","אולם ישוע התחמק מהם והלך לדרכו. ");
INSERT INTO heblb_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","לאחר מכן הלך ישוע לכפר־נחום שבגליל, ומדי שבת לימד בבית־הכנסת. ");
INSERT INTO heblb_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","גם כאן נדהמו השומעים, כי ישוע דיבר בסמכות בלתי רגילה. ");
INSERT INTO heblb_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","פעם כשלימד ישוע בבית־הכנסת צעק לפתע איש אחד אחוז רוח שד טמא: ");
INSERT INTO heblb_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","”מדוע אתה מטריד אותנו, ישוע מנצרת, האם באת להשמיד את השדים? אני מכיר אותך; אתה בנו הקדוש של אלוהים!“ ");
INSERT INTO heblb_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","ישוע נזף בשד וציווה עליו: ”שתוק וצא החוצה!“ השד השליך את האיש על הרצפה לעיני כולם, ויצא ממנו בלי לפגוע בו שוב. ");
INSERT INTO heblb_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","כולם נדהמו ושאלו איש את רעהו במבוכה: ”מה המיוחד בדברי האיש הזה עד כי אפילו שדים מצייתים לו?“ ");
INSERT INTO heblb_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","עד מהרה התפרסם סיפור המעשה בכל האזור. ");
INSERT INTO heblb_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","לאחר שעזב ישוע את בית־הכנסת, הלך לביתו של שמעון וראה את חמותו של שמעון קודחת מחום. ”אנא, רפא אותה“, התחננו לפניו כולם. ");
INSERT INTO heblb_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","ישוע עמד ליד מיטתה וגער בקדחת. מיד ירד החום, והיא קמה ממיטתה והכינה להם אוכל. ");
INSERT INTO heblb_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","עם שקיעת השמש הביאו תושבי הסביבה אל ישוע חברים ובני משפחה שחלו במחלות שונות. ישוע הניח את ידיו עליהם וריפא אותם. ");
INSERT INTO heblb_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","ישוע גם גירש שדים מאנשים רבים, ובצאתם נהגו השדים לקרוא בקול: ”אתה הוא בן־האלוהים!“ אולם ישוע השתיק אותם, בגלל שהם ידעו שהוא המשיח. ");
INSERT INTO heblb_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","למחרת, השכם בבוקר, הלך ישוע למקום שומם כדי להתבודד. המוני העם חיפשו אותו בכל מקום, וכשמצאו אותו התחננו לפניו: ”אנא, אל תעזוב אותנו; הישאר איתנו בכפר־נחום.“ ");
INSERT INTO heblb_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","אולם ישוע השיב להם: ”עלי לבשר את דבר מלכות האלוהים גם בערים אחרות, כי זוהי מטרת שליחותי.“ ");
INSERT INTO heblb_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","וישוע המשיך ללמד בבתי־הכנסת השונים שבאזור יהודה. ");
INSERT INTO heblb_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","יום אחד עמד ישוע על חוף הכינרת ובישר את דבר האלוהים. מספר הנוכחים הלך וגדל, עד שהם נדחפו ונדחקו אליו מכל צד. ");
INSERT INTO heblb_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","ישוע הבחין בשתי סירות ריקות שעגנו ליד החוף. בעלי הסירות, שהיו דייגים במקצועם, רחצו באותו זמן את רשתותיהם. ");
INSERT INTO heblb_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","ישוע עלה על אחת הסירות, שהייתה של שמעון, וביקש ממנו להרחיק מעט את הסירה מהחוף, כדי שיוכל לשבת בתוכה ולדבר אל הקהל. ");
INSERT INTO heblb_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","לאחר שסיים ישוע לדבר אל הקהל, פנה אל שמעון ואמר: ”השט את הסירה אל מים עמוקים והשלך את הרשתות כדי לדוג.“ ");
INSERT INTO heblb_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","”רבי,“ השיב שמעון, ”בלילה האחרון עבדנו קשה מאוד ולא תפסנו כלום. אולם אם אתה אומר לנו להשליך את הרשתות, נעשה כדברך.“ ");
INSERT INTO heblb_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","הם השליכו את הרשתות לים, והפעם תפסו כל כך הרבה דגים עד שהרשתות היו כבדות מדי והחלו להיקרע! ");
INSERT INTO heblb_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","הם קראו לעזרתם את חבריהם שבסירה השנייה, ומילאו את שתי הסירות בדגים עד שכמעט טבעו! ");
INSERT INTO heblb_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","כשראה שמעון פטרוס את הפלא הגדול, נפל על ברכיו לרגלי ישוע ואמר: ”אדוני, עזוב אותי לנפשי, כי אני חוטא גדול מדי ואיני ראוי להיות במחיצתך.“ ");
INSERT INTO heblb_vpl VALUES ("LK5_9‏","072_5_9‏","LUK","5","9‏","10","שמעון אמר דברים אלה משום שהוא וכל הנוכחים איתו, כולל שותפיו יעקב ויוחנן בני־זַבְדִּי, היו בתדהמה גדולה לנוכח השלל הבלתי רגיל. ”אל תפחד.“ אמר ישוע לשמעון. ”מעתה ואילך תהיה דייג של בני אדם.“ ");
INSERT INTO heblb_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","לאחר שהשיטו את הסירות לחוף עזבו הכול והלכו אחרי ישוע. ");
INSERT INTO heblb_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","באחד הכפרים שבהם ביקר ישוע היה אדם נגוע בצרעת. בראותו את ישוע נפל האיש לרגליו והתחנן: ”אדוני, אם רק תרצה תוכל לרפא אותי.“ ");
INSERT INTO heblb_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","ישוע הושיט את ידו, נגע במצורע ואמר: ”ודאי שאני רוצה. הירפא!“ ומיד נעלמה הצרעת. ");
INSERT INTO heblb_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","”אל תספר את הדבר לאיש!“ ציווה עליו ישוע. ”לך מיד אל הכהן והראה לו שנרפאת. אל תשכח לקחת איתך קרבן – כפי שציווה משה על המטוהרים מצרעת – כדי שכולם יראו שנרפאת.“ ");
INSERT INTO heblb_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","בכל זאת התפשטו השמועות על גבורתו של ישוע במהירות רבה, ואנשים רבים באו להקשיב לדבריו ולהירפא ממחלותיהם. ");
INSERT INTO heblb_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","אף־על־פי־כן התחמק מהם ישוע לעיתים קרובות והלך למקומות מבודדים כדי להתפלל. ");
INSERT INTO heblb_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","יום אחד, כשלימד ישוע כמנהגו, התקבצו סביבו בין השאר גם פרושים וסופרים שבאו מכפרי הגליל, מיהודה ומירושלים, וה׳ העניק לו גבורה גדולה לרפא את החולים. ");
INSERT INTO heblb_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","כעבור זמן קצר הופיעו מספר אנשים שנשאו חולה משותק על אלונקה. הם רצו להביא את החולה לפני ישוע, ");
INSERT INTO heblb_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","אולם בשל הצפיפות הרבה לא הצליחו לפלס דרך אל תוך הבית. נושאי האלונקה לא נואשו; הם עלו על גג הבית, עקרו כמה רעפים ממקומם והורידו את האלונקה מהגג אל אמצע החדר – לרגלי ישוע. ");
INSERT INTO heblb_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","כשראה ישוע את אמונתם, אמר לאיש המשותק: ”ידידי, נסלחו לך חטאיך!“ ");
INSERT INTO heblb_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","”למי הוא חושב את עצמו?“ שאלו הפרושים והסופרים בלבם. ”הוא מחלל את שם האלוהים, רק אלוהים יכול לסלוח על חטאים!“ ");
INSERT INTO heblb_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","ישוע הבין את מחשבותיהם ולכן השיב להם: ”מדוע אתם חושבים שאני מחלל את שם אלוהים? ");
INSERT INTO heblb_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","מה לדעתכם קל יותר, לומר ’נסלחו לך חטאיך‘, או ’קום והתהלך‘? ");
INSERT INTO heblb_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","אני אוכיח לכם כי לבן־האדם יש בארץ סמכות מלאה לסלוח על חטאים!“ ישוע פנה אל האיש המשותק ופקד עליו: ”קום! קפל את האלונקה שלך ולך הביתה.“ ");
INSERT INTO heblb_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","מיד קפץ האיש על רגליו לנגד עיניהם, קיפל את האלונקה שלו והלך לביתו כשהוא מהלל את האלוהים. ");
INSERT INTO heblb_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","כל הנוכחים נדהמו. ”היום ראינו פלא גדול“, אמרו ביראה והללו את האלוהים. ");
INSERT INTO heblb_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","לאחר מכן יצא ישוע מהעיר ופגש בדרך גובה־מכס אחד, לוי שמו, יושב בשער בית־המכס. ”בוא והיה תלמיד שלי“, אמר לו ישוע. ");
INSERT INTO heblb_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","לוי קם על רגליו, עזב הכול מאחוריו והלך אחרי ישוע. ");
INSERT INTO heblb_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","ערב אחד הכין לוי ארוחה חגיגית לכבוד ישוע והזמין גובי־מכס מהעבודה, ידידים, שכנים וקרובים. ");
INSERT INTO heblb_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","אולם הדבר לא מצא־חן בעיני הסופרים והפרושים, אשר התלוננו באוזני תלמידיו של ישוע: ”איך הוא יכול לאכול ולשתות בחברת החוטאים האלה?“ ");
INSERT INTO heblb_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","”החולים הם הזקוקים לרופא, לא הבריאים!“ השיב להם ישוע. ");
INSERT INTO heblb_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","”לא באתי לקרוא לצדיקים לחזור בתשובה, כי אם לחוטאים.“ ");
INSERT INTO heblb_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","הם המשיכו להתלונן ואמרו: ”תלמידי יוחנן המטביל צמים לעיתים קרובות ומתפללים, וגם הפרושים נוהגים כך. מדוע אין תלמידיך צמים?“ ");
INSERT INTO heblb_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","”האם אנשים שמחים צמים?“ השיב ישוע. ”האם אורחים המוזמנים לחתונה צמים בחגיגת החתן? ");
INSERT INTO heblb_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","אולם יבוא יום שהחתן יילקח מהם ואז יצומו.“ ");
INSERT INTO heblb_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","ישוע סיפר להם את המשל הבא: ”איש אינו קורע חולצה חדשה כדי לתפור ממנה טלאי על חולצה ישנה. מי שעושה כך לא זו בלבד שהוא מקלקל את החולצה החדשה, אלא שגם אינו יכול ליהנות מהחולצה הישנה, כי הטלאי אינו מתאים. ");
INSERT INTO heblb_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","”איש אינו שם יין חדש בחביות ישנות ורקובות, מפני שהיין החדש יבקע את החביות, וכך היין יישפך והחביות תיהרסנה. ");
INSERT INTO heblb_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","יין חדש יש לשים בחביות חדשות. ");
INSERT INTO heblb_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","אדם הרגיל לשתות יין ישן אינו חפץ לשנות את מנהגו ולשתות יין חדש. ’היין הישן מוצא־חן בעיני‘, הוא יאמר, ולא ירצה אפילו לטעום מהיין החדש.“ ");
INSERT INTO heblb_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","באחת השבתות, כשעברו ישוע ותלמידיו בשדה, קטפו התלמידים שיבולים, הפרידו את המוץ ואכלו את הגרעינים. ");
INSERT INTO heblb_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","הדבר לא מצא־חן בעיני כמה פרושים אשר באו לישוע, ואלה קראו: ”מדוע תלמידיך קוטפים שיבולים בשבת? הלא הם מחללים את השבת!“ ");
INSERT INTO heblb_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","השיב להם ישוע: ”האם מעולם לא קראתם מה עשה דוד המלך כשהוא ואנשיו היו רעבים? ");
INSERT INTO heblb_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","דוד נכנס לאוהל מועד, לקח את לחם הפנים – שעל־פי התורה היה מיועד לכוהנים בלבד – ואכל אותו עם אנשיו.“ ");
INSERT INTO heblb_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","ישוע עוד הוסיף: ”בן האדם הוא אדון השבת.“ ");
INSERT INTO heblb_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","בשבת אחרת, כשלימד ישוע בבית־הכנסת, היה בקהל אדם שידו הימנית משותקת. ");
INSERT INTO heblb_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","הסופרים והפרושים רצו לראות אם ישוע ירפא את האיש בשבת, מפני שחיפשו סיבה להאשים אותו במשהו. ");
INSERT INTO heblb_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","ישוע ידע היטב את מחשבותיהם, ולכן אמר לבעל היד המשותקת: ”בוא ועמוד לפני כולם.“ האיש עשה כדבריו. ");
INSERT INTO heblb_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","ישוע פנה אל הסופרים והפרושים: ”יש לי שאלה אליכם: על־פי התורה, האם עלינו לעשות בשבת מעשים טובים, או מעשים רעים? האם עלינו להציל חיים בשבת, או להרסם?“ ");
INSERT INTO heblb_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","ישוע הביט בעיני הנוכחים ואחר כך אמר לאיש שידו משותקת: ”הושט את ידך.“ האיש הושיט את ידו והיא נרפאה כליל. ");
INSERT INTO heblb_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","מעשה זה של ישוע עורר את זעם אויביו, והם החלו להתייעץ ביניהם מה לעשות לו. ");
INSERT INTO heblb_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","זמן קצר לאחר מכן יצא ישוע אל ההרים להתפלל, ובילה את כל הלילה בתפילה לאלוהים. ");
INSERT INTO heblb_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","עם עלות השחר הוא קרא אליו את תלמידיו, ובחר מתוכם שנים־עשר איש שיהיו מלוויו הקבועים. יותר מאוחר ישוע מינה את אלה להיות שליחים. ");
INSERT INTO heblb_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","אלה שמותיהם: שמעון (ישוע קרא לו גם פטרוס), ‎אַנְדְּרֵי (אחיו של שמעון), יעקב, יוחנן, פיליפוס, בר־תלמי, ");
INSERT INTO heblb_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","מתתיהו, תומא, יעקב (בן־חלפי), שמעון (מכת הקנאים), ");
INSERT INTO heblb_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","יהודה (בן־יעקב), יהודה איש־קריות (אשר מאוחר יותר הסגיר את ישוע). ");
INSERT INTO heblb_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","ישוע ירד איתם מההר, וכשהגיעו למקום נרחב הוא עמד מלכת. קהל גדול כבר ציפה לו שם; ביניהם תלמידיו הרבים ואנשים רבים שבאו ממרחקים להקשיב לדבריו ולהירפא ממחלותיהם. הם באו בהמוניהם מירושלים, מיהודה ומאזור צור וצידון. ");
INSERT INTO heblb_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","גם אנשים שהיו אחוזים רוחות רעות נרפאו. ");
INSERT INTO heblb_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","כל אחד ואחד מהם השתוקק לגעת בישוע, כי יצא ממנו כוח מרפא שריפא את כולם. ");
INSERT INTO heblb_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","ישוע פנה אל תלמידיו ואמר: ”אשריכם העניים, כי מלכות האלוהים שייכת לכם. ");
INSERT INTO heblb_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","אשריכם הרעבים עתה, כי תשבעו. אשריכם הבוכים עתה, כי עוד תשמחו. ");
INSERT INTO heblb_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","אשריכם אם שונאים ומנדים אתכם, ואם מקללים אתכם בגלל אמונתכם בבן־האדם. ");
INSERT INTO heblb_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","”שמחו ורקדו, כי מצפה לכם שכר רב בשמים! ואל תשכחו שכך רדפו גם את הנביאים! ");
INSERT INTO heblb_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","אך אוי לעשירים, מפני שכבר קיבלתם את כל מה שמגיע לכם בעולם הזה. ");
INSERT INTO heblb_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","אוי לאלה שיש לכם את כל משאלות לבבכם, כי יבוא יום שבו לא יהיה לכם דבר! אוי לכם הצוחקים עתה, כי לא רחוק היום שבו תתאבלו ותבכו! ");
INSERT INTO heblb_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","אוי לכם המקבלים מחמאות ושבחים מכל בני־האדם, כי כך החניפו אבותיהם לנביאי השקר. ");
INSERT INTO heblb_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","”הקשיבו כולכם: אהבו את אויביכם, השיבו טובה לשונאיכם, ");
INSERT INTO heblb_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","ברכו את המקללים אתכם, והתפללו בעד אלה שלועגים לכם ומביישים אתכם. ");
INSERT INTO heblb_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","”אם מישהו יסטור לך על לחי אחת, הושט לו גם את הלחי השנייה. אם מישהו ייקח מעילך אל תמנע ממנו את חולצתך. ");
INSERT INTO heblb_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","תן מה שיש לך לכל המבקש, וכאשר לוקחים ממך דבר, אל תצטער ואל תדרוש אותו חזרה. ");
INSERT INTO heblb_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","עשו לאחרים את מה שהייתם רוצים שיעשו לכם. ");
INSERT INTO heblb_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","”אם אתם אוהבים רק את אלה שאוהבים אתכם, מה המיוחד בכך? גם הפושעים אוהבים את אלה שאוהבים אותם! ");
INSERT INTO heblb_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","ואם אתם עושים טובה רק לאלה שעושים לכם טובה – החושבים אתם שמגיע לכם פרס? גם הפושעים מחזירים טובה תחת טובה! ");
INSERT INTO heblb_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","אם אתם מלווים רק לאלה שיכולים להחזיר לכם, האם אתם עושים מעשה נעלה? גם הקמצנים והרשעים מלווים לאנשים כמותם תמורת שכר מלא. ");
INSERT INTO heblb_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","”עליכם לאהוב את אויביכם, לעשות מעשים טובים ולהלוות כספים בלי לצפות שיחזירו לכם. ואז שכרכם מאת אלוהים יהיה רב, וכך גם תוכיחו שאכן בניו אתם, שהרי אלוהים טוב גם לרשעים ולכפויי־טובה. ");
INSERT INTO heblb_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","”היו רחמנים כמו שאביכם שבשמים. ");
INSERT INTO heblb_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","אל תמתחו ביקורת על אחרים ואל תשפטו אותם, ואז לא ימתחו ביקורת עליכם ולא ישפטו אתכם. אל תאשימו איש, ואז לא יאשימו אתכם. סלחו לאחרים, ואז ייסלח גם לכם. ");
INSERT INTO heblb_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","”אם תתנו לאחרים תקבלו חזרה מידה יפה, גדושה ושופעת, כי במידה שאתם נותנים לאחרים יינתן לכם חזרה.“ ");
INSERT INTO heblb_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","ישוע סיפר להם את המשל הבא: ”היכול עיוור להדריך עיוור? הלא שניהם יפלו לתוך בור! ");
INSERT INTO heblb_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","התלמיד אינו יודע יותר ממורו, אולם אם ילמד בשקידה ובחריצות יוכל להגיע לרמת ידיעותיו של המורה. ");
INSERT INTO heblb_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","”כיצד יכול אתה לראות שביב־עץ קטן בעין חברך, ולא להבחין בקרש הגדול שבעינך? ");
INSERT INTO heblb_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","איך אתה יוכל לומר לו: ’אחי, הרשה לי לסלק את השביב מעינך‘, בזמן שאינך רואה את הקרש הגדול שבעינך? צבוע שכמותך! סלק תחילה את הקרש מעינך, ורק לאחר מכן תוכל לסלק את שביב העץ מעין חברך! ");
INSERT INTO heblb_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","”עץ משובח אינו נותן פרי רקוב, כשם שעץ רקוב אינו נותן פרי משובח. ");
INSERT INTO heblb_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","את העץ מכירים לפי הפרי שהוא נותן. הרי התאנים לעולם אינן צומחות על שיחי קוצים, וענבים לעולם אינם צומחים על חוחים. ");
INSERT INTO heblb_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","אדם טוב מפיק מעשים טובים מהטוב שבלבו, בעוד שאדם רע מפיק מעשים רעים מהרוע שבלבו, שהרי אדם מדבר מתוך הממלא את לבו. ");
INSERT INTO heblb_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","”מדוע אתם קוראים לי ’אדון, אדון‘, ואינכם עושים את מה שאני אומר לכם? ");
INSERT INTO heblb_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","כל מי שבא אלי ואינו רק מקשיב לדברי, כי אם גם מקיים אותם, ");
INSERT INTO heblb_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","דומה לאדם שבנה את ביתו על יסודות איתנים החצובים בסלע. כשבא שיטפון, הבית עומד איתן כי נבנה היטב. ");
INSERT INTO heblb_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","אולם מי שמקשיב לדברי ואינו מקיים אותם, דומה לאדם שבנה את ביתו על אדמת־חול ללא יסודות. כשבא שיטפון הבית נהרס כליל.“ ");
INSERT INTO heblb_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","לאחר שסיים לדבר באוזני העם בא ישוע לכפר־נחום. ");
INSERT INTO heblb_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","היה אז קצין רומאי, שמשרת אחד שאהב נטה למות. ");
INSERT INTO heblb_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","כאשר שמע הקצין על אודות ישוע, שלח אליו כמה מזקני היהודים כדי שיבקשו ממנו לבוא ולהציל את חיי המשרת. ");
INSERT INTO heblb_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","הזקנים באו אל ישוע והתחננו לפניו שייענה לבקשת הקצין. ”אנא, מלא את בקשתו“, התחננו הזקנים, ");
INSERT INTO heblb_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","”כי הוא אוהב את עמנו ואף בנה לנו בית־כנסת מכספו!“ ");
INSERT INTO heblb_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","ישוע הלך איתם אל בית הקצין, אולם לפני הגיעם אל הבית שלח הקצין אחדים מחבריו אל ישוע כדי לומר לו: ”אדוני, אל תטריח את עצמך! איני ראוי שתבוא אל ביתי, ");
INSERT INTO heblb_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","ומסיבה זאת גם לא העזתי לבוא אליך בעצמי. בבקשה ממך, רק צווה שמשרתי יבריא והוא יבריא. ");
INSERT INTO heblb_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","מנין לי הביטחון הזה? הרי אני רגיל לקבל פקודות מהממונים עלי, ואף לתת פקודות לחיילים תחת פקודי. אם אני אומר לחייל אחד: ’לך‘, הוא הולך. אם אני אומר לחייל אחר: ’בוא‘, הוא בא. אם אני אומר למשרתי: ’עשה עבודה זאת או אחרת‘, הוא עושה אותה. כך גם אם תצווה על המשרת שיבריא – הוא יבריא.“ ");
INSERT INTO heblb_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","דברי הקצין הפליאו את ישוע. הוא פנה אל הקהל שליווה אותו ואמר: ”בקרב כל עם ישראל לא ראיתי אדם בעל אמונה כזאת!“ ");
INSERT INTO heblb_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","כשחזרו חברי הקצין אל הבית ראו שהמשרת הבריא לחלוטין. ");
INSERT INTO heblb_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","זמן קצר לאחר מכן הלך ישוע עם תלמידיו אל העיירה נעים, וכרגיל הלך אחריו קהל גדול. ");
INSERT INTO heblb_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","כשהתקרב ישוע אל שער העיירה ראה תהלוכת־לוויה יוצאת מעיר. הייתה זאת הלוויה של בן יחיד לאם אלמנה, ובין האבלים היו רבים מתושבי המקום. ");
INSERT INTO heblb_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","מראה האלמנה עורר את רחמי האדון והוא אמר לה: ”אל תבכי.“ ");
INSERT INTO heblb_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","הוא ניגש ונגע באלונקה, ונושאיה עצרו. ”נער, קום לחיים!“ קרא ישוע. ");
INSERT INTO heblb_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","הנער קם והחל לדבר אל הסובבים אותו וישוע השיבו לאמו. ");
INSERT INTO heblb_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","הקהל, שנמלא פחד ורעדה, שיבח את האלוהים וקרא: ”נביא גדול קם בינינו! היום ראינו את יד אלוהים!“ ");
INSERT INTO heblb_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","השמועה על המעשה של ישוע התפשטה בכל יהודה והאזור סביב. ");
INSERT INTO heblb_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","גם תלמידי יוחנן המטביל שמעו על מעשי ישוע וסיפרו ליוחנן את כל אשר שמעו. ");
INSERT INTO heblb_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","יוחנן קרא אליו שניים מתלמידיו ושלח אותם אל ישוע כדי לשאול: ”האם אתה המשיח, או שעלינו לחכות למישהו אחר?“ ");
INSERT INTO heblb_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","שני התלמידים באו אל ישוע ואמרו: ”יוחנן המטביל שלח אותנו אליך כדי לשאול: האם לך אנחנו מצפים, או למישהו אחר?“ ");
INSERT INTO heblb_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","באותה עת ריפא ישוע אנשים רבים ממחלות, נגעים, רוחות רעות והשיב את הראייה לעיוורים רבים. ");
INSERT INTO heblb_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","”לכו וספרו ליוחנן את כל אשר ראיתם ושמעתם כאן היום“, ענה ישוע לשאלתם. ”ספרו לו שהעיוורים רואים, הפיסחים הולכים, המצורעים מטוהרים, החרשים שומעים, המתים קמים לתחייה והעניים שומעים את בשורת אלוהים. ");
INSERT INTO heblb_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","ועוד אמרו ליוחנן כי ברוך האיש שלא אהיה לו מכשול, אלא יאמין בי.“ ");
INSERT INTO heblb_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","לאחר שהלכו שני התלמידים דיבר ישוע אל הקהל על אודות יוחנן: ”מה הלכתם לראות במדבר? האם הלכתם להתבונן בעשב הנע ברוח? ");
INSERT INTO heblb_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","אמרו לי, מה ציפיתם לראות? אדם לבוש בגדים יפים? הרי מי שלובש בגדים מפוארים גר בארמונות פאר ולא במדבר. ");
INSERT INTO heblb_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","מה באמת הלכתם לראות, נביא? כן! נביא הלכתם לראות, ואני אומר לכם שהוא גדול אף מנביא. ");
INSERT INTO heblb_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","על האיש הזה כתוב בתנ״ך: ’הנני שולח מלאכי לפניך ופנה־דרכך לפניךָ‘. ");
INSERT INTO heblb_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","ובכן, לא נולד אדם גדול מיוחנן, ויחד עם זאת – הקטן במלכות האלוהים גדול ממנו!“ ");
INSERT INTO heblb_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","כל האנשים אשר שמעו את דברי יוחנן – אפילו גובי מכס – הצדיקו את דרישות אלוהים ונטבלו על־ידי יוחנן. ");
INSERT INTO heblb_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","אולם הפרושים וחכמי התורה דחו את תוכניתו של ה׳ למענם וסרבו להיטבל על־ידי יוחנן. ");
INSERT INTO heblb_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","”מה יכול אני להגיד על אנשים כאלה?“ שאל ישוע. ”למה הם דומים? ");
INSERT INTO heblb_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","הם דומים לילדים במגרש משחקים שמתלוננים באוזני חבריהם: ’ניגנו לכם בחליל אך לא רקדתם, קיננו לכם קינה, אך לא בכיתם‘.“ ");
INSERT INTO heblb_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","ישוע המשיך: ”יוחנן המטביל נהג לצום ולא שתה יין כל ימי חייו, ואתם קראתם לו ’משוגע‘. ");
INSERT INTO heblb_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","עכשיו בא בן־האדם שאוכל וגם שותה יין, ומה אתם אומרים? ’האיש הזה זללן, הוא שותה יין ומתחבר עם חוטאים וטיפוסים מפוקפקים! ");
INSERT INTO heblb_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","אנשים יכירו בצדקת ה׳ וחוכמתו כאשר יראו איך צדיקיו חיים‘.“ ");
INSERT INTO heblb_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","פרוש אחד הזמין את ישוע לארוחה בביתו. ישוע נענה להזמנה, בא לבית הפרוש וישב ליד השולחן. ");
INSERT INTO heblb_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","באותה עיר הייתה אישה חוטאת. משנודע לה כי ישוע מתארח בבית הפרוש, לקחה פח מלא מרקחת בשמים יקרים ובאה אל הבית. ");
INSERT INTO heblb_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","כשנכנסה אל הבית כרעה ברך לפני ישוע והרטיבה את רגליו בדמעותיה. בשערה הארוך היא ניגבה את רגליו, נישקה אותן ומרחה עליהן את הבשמים שהביאה. ");
INSERT INTO heblb_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","מארחו של ישוע ראה את המתרחש, ומכיוון שהכיר את האישה אמר בלבו: ”אילו ישוע היה באמת נביא אלוהים, הוא היה יודע עם איזו אישה יש לו עניין!“ ");
INSERT INTO heblb_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","ישוע ידע את מחשבות הפרוש ולכן אמר לו: ”שמעון, ברצוני לומר לך משהו.“ ”דבר, רבי“, השיב שמעון. ");
INSERT INTO heblb_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","ישוע סיפר לו את הסיפור הבא: ”אדם הילווה כסף לשני אנשים: חמש מאות שקלים לאחד, ו־חמשת־אלפים שקלים לשני. ");
INSERT INTO heblb_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","הואיל והשניים לא יכלו להחזיר את החוב, ריחם עליהם המלווה וויתר להם על החובות. מי לדעתך יאהב יותר את המלווה בעקבות מעשה נעלה זה?“ ");
INSERT INTO heblb_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","”אני מניח שבעל החוב הגדול יותר“, ענה שמעון. ”נכון מאוד“, הסכים ישוע. ");
INSERT INTO heblb_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","ואז הביט באישה ואמר לשמעון: ”הבט באישה זאת; כשנכנסתי לביתך לא הצעת לי קערת מים כדי לרחוץ את רגלי מהאבק, ואילו אישה זו רחצה את רגלי בדמעותיה וניגבה אותן בשערה. ");
INSERT INTO heblb_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","”גם לא נשקת לי כמקובל, ואילו היא לא חדלה לנשק את רגלי מהרגע שבאתי לכאן. ");
INSERT INTO heblb_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","אתה לא טרחת למשוח שמן על ראשי, ואילו היא משחה את רגלי בבשמים ובשמנים יקרים. ");
INSERT INTO heblb_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","אהבתה הרבה מוכיחה שנסלחו לה חטאים רבים. אדם שנסלח לו מעט אוהב מעט.“ ");
INSERT INTO heblb_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","ישוע פנה אל האישה ואמר: ”נסלחו לך חטאיך.“ ");
INSERT INTO heblb_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","האורחים האחרים שישבו איתו ליד השולחן אמרו בלבם: ”למי הוא חושב את עצמו שהוא סולח על חטאים?“ ");
INSERT INTO heblb_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","אולם ישוע המשיך ואמר לאישה: ”אמונתך הושיעה אותך. לכי לשלום.“ ");
INSERT INTO heblb_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","זמן קצר לאחר מכן עבר ישוע מעיר לעיר ומכפר לכפר, וסיפר לאנשים את בשורת מלכות האלוהים. אל ישוע נילוו שנים־עשר תלמידיו ");
INSERT INTO heblb_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","וקבוצת נשים, שאותן הוא ריפא ממחלות שונות או גירש מהן רוחות רעות. בין נשים אלה היו מרים המגדלית (שממנה גירש ישוע שבעה שדים), ");
INSERT INTO heblb_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","יוחנה, אשת כוזא (מי שניהל את עסקי המלך הורדוס), שושנה ורבות אחרות שתרמו מכספן לכלכלת ישוע ותלמידיו. ");
INSERT INTO heblb_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","יום אחד, כשנהרו אליו אנשים מערים רבות, סיפר להם ישוע את המשל הבא: ");
INSERT INTO heblb_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","”איכר אחד יצא לזרוע בשדה. בפזרו את הזרעים נפלו אחדים מהם בצד הדרך, והם נרמסו ונאכלו על־ידי הציפורים. ");
INSERT INTO heblb_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","חלקם נפלו על אדמת סלעים, ואלה צמחו יפה, אך כעבור זמן קצר התייבשו ומתו מחוסר לחות. ");
INSERT INTO heblb_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","חלקם נפלו בין הקוצים. זרעים אלה אמנם צמחו, אולם יחד איתם צמחו גם קוצים וחנקו אותם. ");
INSERT INTO heblb_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","חלק אחר מהזרעים נפלו על אדמה פורייה, ואלה צמחו ונשאו פרי רב, פי מאה ממה שנזרע.“ בסיימו את המשל אמר ישוע: ”מי שמסוגל לשמוע, שיקשיב!“ ");
INSERT INTO heblb_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","תלמידיו שאלו אותו למה התכוון, ");
INSERT INTO heblb_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","וישוע השיב: ”רק לכם מותר לדעת את סודות מלכות השמים, אולם האנשים הללו שומעים רק משלים אך אינם מבינים – בדיוק כפי שניבאו אבותינו הנביאים. ");
INSERT INTO heblb_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","”זהו פירוש המשל: הזרע הוא דבר־אלוהים. ");
INSERT INTO heblb_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","שולי הדרך מסמלים את לב האנשים השומעים את דבר האלוהים, אולם מיד בא השטן ומנסה להשכיח מלבם את דבר ה׳. כך הוא מונע בעדם מלהאמין באלוהים ולהיוושע. ");
INSERT INTO heblb_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","אדמת הסלעים מסמלת את לב האנשים הנהנים להקשיב לדבר־אלוהים, אולם אין הוא חודר לעומק לבם. הם יודעים שדבר ה׳ הוא אמת, ואפילו מאמינים לזמן קצר, אולם ברגע של קושי ומבחן הם מאבדים את אמונתם. ");
INSERT INTO heblb_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","אדמת הקוצים מסמלת את לב האנשים המקשיבים לדבר אלוהים ומאמינים בו, אולם כעבור זמן קצר נחנקת אמונתם על־ידי דאגות, תאוות־העולם ורדיפה אחר כסף ורכוש. משום כך לעולם אינם מגיעים לבגרות רוחנית. ");
INSERT INTO heblb_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","”לעומתם מסמלת האדמה הפורייה אנשים בעלי לב טוב וישר. אנשים אלה מקשיבים לדבר ה׳, דבקים בו ואף מביאים פרי רב. ");
INSERT INTO heblb_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","”כאשר אדם מדליק נר בחשכה, האם הוא מכסה את הנר או מחביא אותו מתחת למיטה? הוא ישים אותו במקום מרכזי, המקום שבו יאיר לבאי הבית בצורה הטובה ביותר. ");
INSERT INTO heblb_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","כל מה שמוסתר עתה יתגלה ויצא לאור בבוא הזמן. ");
INSERT INTO heblb_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","לכן שימו לב כיצד אתם מקשיבים. מי שיש לו – יינתן לו עוד. ומי שאין לו – גם מה שהוא חושב שיש לו יילקח ממנו.“ ");
INSERT INTO heblb_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","אז באו אמו ואחיו של ישוע לבקרו, אולם בגלל הקהל הרב לא יכלו להיכנס אל הבית שבו לימד. ");
INSERT INTO heblb_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","מישהו הודיע לישוע כי אמו ואחיו מחכים לו בחוץ ורוצים לראותו, ");
INSERT INTO heblb_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","אולם ישוע אמר: ”אמי וְאֶחָי הם כל אלה המקשיבים לדברי אלוהים ומקיימים אותם!“ ");
INSERT INTO heblb_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","יום אחד עלה ישוע עם תלמידיו לסירה והציע: ”הבה נשוט אל החוף ממול.“ ");
INSERT INTO heblb_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","הם החלו לשוט וישוע נרדם. לפתע התחוללה סערה חזקה. הרוח טלטלה את הסירה מצד אל צד, הגלים הגבוהים הציפו את הסירה במים, והתלמידים היו בסכנה גדולה. ");
INSERT INTO heblb_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","”רבי, קום!“ העירו אותו התלמידים בבהלה. ”אנחנו טובעים!“ ישוע גער ברוח ובים, ומיד פסקה הסערה והים נרגע. ");
INSERT INTO heblb_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","”היכן אמונתכם?“ שאל אותם ישוע. התלמידים הנדהמים והמפוחדים אמרו איש לרעהו: ”מיהו האיש הזה, שאפילו הרוח והים נשמעים לו?“ ");
INSERT INTO heblb_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","הם הגיעו אל הגדה השנייה של הכינרת, אל ארץ הגדריים. ");
INSERT INTO heblb_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","כשעלה ישוע לחוף, בא לקראתו אדם מקומי אשר זמן רב היה אחוז־שדים. האיש היה עירום לגמרי, חסר בית וישן בבית־הקברות. ");
INSERT INTO heblb_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","בראותו את ישוע נפל האיש לרגליו וצרח: ”מה אתה רוצה ממני, ישוע בן־אל־עליון? אני מתחנן לפניך, אל תייסר אותי!“ ");
INSERT INTO heblb_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","הוא אמר זאת משום שישוע כבר ציווה על השד לצאת ממנו. לעיתים קרובות השתלט השד על האיש האומלל, עד כי גם כשאסרו אותו בכבלים ובשרשרות היה מנתק אותם בקלות ובורח למדבר, בכוחו ובהשפעתו של השד. ");
INSERT INTO heblb_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","”מה שמך?“ שאל ישוע את השד. ”לגיון“, השיבו קולות רבים, כי היו בו למעשה שדים רבים. ");
INSERT INTO heblb_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","השדים התחננו לפני ישוע שלא ישלח אותם לתהום. ");
INSERT INTO heblb_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","במדרון ההר שבקרבת מקום רעה עדר חזירים, והשדים התחננו לפני ישוע שירשה להם להיכנס בחזירים. ישוע הסכים, ");
INSERT INTO heblb_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","והשדים יצאו מהאיש ונכנסו בחזירים. מיד החל העדר להשתולל, גלש במדרון התלול וטבע בים. ");
INSERT INTO heblb_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","משראו הרועים את המתרחש נמלטו בבהלה וסיפרו את הדבר בעיר ובכפרים. ");
INSERT INTO heblb_vpl VALUES ("LK8_35‏","072_8_35‏","LUK","8","35‏","36","עד מהרה נהרו לשם אנשים רבים כדי לראות את המתרחש במו עיניהם. הם ראו את האיש שהיה אחוז־שדים יושב לרגלי ישוע, לבוש היטב ושפוי בדעתו. עדי ראייה סיפרו לבאים כיצד ריפא ישוע את האיש, וכולם נמלאו פחד. ");
INSERT INTO heblb_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","כה רב היה פחדם, עד כי האנשים הרבים מארץ הגדריים התחננו לפני ישוע שיעזוב אותם לנפשם וילך משם. ישוע חזר לסירה ושב למקום ממנו בא. ");
INSERT INTO heblb_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","האיש שהיה אחוז־שדים התחנן לפניו שירשה לו להצטרף אליו, אולם ישוע סרב. ");
INSERT INTO heblb_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","”חזור לביתך,“ אמר לו ישוע, ”וספר לבני משפחתך את הפלא שאלוהים עשה למענך.“ האיש הלך וסיפר בכל העיר את הפלא שחולל ישוע למענו. ");
INSERT INTO heblb_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","בגדה השנייה של הכינרת קיבל אותו הקהל, שכבר המתין לישוע. ");
INSERT INTO heblb_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","אדם בשם יאיר, שהיה ראש בית־הכנסת המקומי, בא ונפל לרגלי ישוע. יאיר התחנן לפניו שיבוא איתו אל ביתו, ");
INSERT INTO heblb_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","כי בתו היחידה בת שתים־עשרה חלתה ועמדה למות. ישוע הלך עם יאיר כשהוא מפלס לו דרך בין הקהל הרב. ");
INSERT INTO heblb_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","בקרב הקהל הייתה אישה שסבלה משטף דם כרוני במשך שתים־עשרה שנה. היא הוציאה את כל כספה על רופאים שונים, אולם איש לא יכול היה לרפא אותה. ");
INSERT INTO heblb_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","האישה קרבה אל ישוע מאחור, וכשנגעה בכנף בגדו פסק מיד שטף הדם! ");
INSERT INTO heblb_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","”מי נגע בי?“ שאל ישוע. כל הסובבים אותו הכחישו שנגעו בו, ופטרוס אמר: ”רבי, כיצד אתה יכול לשאול מי נגע בך? ראה כמה רבים האנשים שנדחפים ונדחקים אליך מכל צד!“ ");
INSERT INTO heblb_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","אולם ישוע השיב: ”אני יודע שמישהו נגע בי בכוונת תחילה, כי הרגשתי שיצא ממני כוח מרפא.“ ");
INSERT INTO heblb_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","כאשר נוכחה האישה שישוע ידע, החלה לרעוד מפחד. היא נפלה לרגליו וסיפרה באוזני כולם מדוע נגעה בישוע. היא סיפרה שנרפאה כליל. ");
INSERT INTO heblb_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","”בתי,“ אמר לה ישוע, ”אמונתך ריפאה אותך, לכי לשלום.“ ");
INSERT INTO heblb_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","בזמן שישוע דיבר אל האישה, הגיע למקום שליח מביתו של יאיר והודיע לאב: ”בתך מתה; אין צורך להטריח את המורה.“ ");
INSERT INTO heblb_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","כאשר שמע ישוע את דברי השליח אמר אל האב: ”אל תפחד! בטח בי, ובתך תרפא.“ ");
INSERT INTO heblb_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","בהגיעם אל הבית הרשה ישוע רק להורים, לפטרוס, ליעקב וליוחנן להיכנס לחדר הילדה. ");
INSERT INTO heblb_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","הבית היה מלא אנשים שבאו להתאבל ולבכות על מותה, אולם ישוע אמר להם: ”אל תבכו; הילדה לא מתה, היא רק ישנה.“ ");
INSERT INTO heblb_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","אך האבלים לעגו לישוע, כי ידעו שהיא מתה. ");
INSERT INTO heblb_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","ישוע אחז ביד הילדה וקרא: ”קומי, ילדתי!“ ");
INSERT INTO heblb_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","באותו רגע רוחה שבה אליה והיא קמה על רגליה. ”תנו לה משהו לאכול!“ פקד ישוע. ");
INSERT INTO heblb_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","הוריה התפלאו מאוד, אולם ישוע ציווה עליהם לא לספר לאיש את אשר קרה. ");
INSERT INTO heblb_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","יום אחד קרא אליו ישוע את שנים־עשר תלמידיו, והעניק להם סמכות וכוח לגרש שדים ולרפא מחלות. ");
INSERT INTO heblb_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","לאחר מכן שלח אותם לספר לכולם על בוא מלכות האלוהים ולרפא את החולים. ");
INSERT INTO heblb_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","”אל תיקחו אתכם דבר“, הורה להם ישוע. ”אל תיקחו אתכם מקל הליכה, תרמיל, מזון, כסף ואף לא בגדים להחלפה. ");
INSERT INTO heblb_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","בכל עיר או כפר התארחו בבית אחד בלבד. ");
INSERT INTO heblb_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","”אם התושבים לא יקשיבו לדבריכם, צאו מאותה עיר ונערו את העפר מעל רגליכם, כסימן לכך שעשיתם את המוטל עליכם והזהרתם אותם.“ ");
INSERT INTO heblb_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","התלמידים יצאו לדרך, ובעברם מעיר לעיר ומכפר לכפר בישרו את דבר אלוהים וריפאו את החולים. ");
INSERT INTO heblb_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","כשהגיעו השמועות על כוחו ונפלאותיו של ישוע לאוזני המושל הורדוס, הוא נמלא מבוכה ודאגה, כי היו אנשים שאמרו: ”זהו יוחנן המטביל שקם לתחייה!“ ");
INSERT INTO heblb_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","או: ”האיש הזה הוא אליהו הנביא!“ היו שאמרו: ”זהו אחד הנביאים שקם לתחייה!“ ");
INSERT INTO heblb_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","”יוחנן?“ תמה הורדוס. ”הרי כרתי את ראשו, אז מיהו האיש שעליו אני שומע ניסים ונפלאות?“ והורדוס חיפש דרך לפגוש את ישוע. ");
INSERT INTO heblb_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","לאחר שחזרו השליחים ודיווחו לישוע על כל מעשיהם, הוא עזב את הקהל איתם והם הלכו יחד לבית־צידה כדי להיות לבדם. ");
INSERT INTO heblb_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","אבל ההמונים גילו לאן ישוע הלך והלכו בעקבותיו. ישוע קיבל אותם בחמימות ולימד אותם על מלכות האלוהים. הוא גם ריפא את החולים שביניהם. ");
INSERT INTO heblb_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","לפנות ערב ניגשו שנים־עשר התלמידים אל ישוע והאיצו בו לשלוח את הקהל אל הכפרים והמשקים שבסביבה כדי לקנות אוכל ולחפש מקום לינה, כי האזור שבו היו היה שומם לגמרי. ");
INSERT INTO heblb_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","”אתם תאכילו אותם!“ אמר ישוע לתלמידיו. אך התלמידים אמרו: ”יש לנו רק חמש ככרות לחם ושני דגים. האם אתה רוצה שנלך לקנות אוכל לכל ההמון הזה?“ ");
INSERT INTO heblb_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","כחמשת־אלפים גברים היו שם (לא כולל נשים וילדים). ”אמרו להם לשבת בשורות של חמישים איש“, הורה ישוע לתלמידיו. ");
INSERT INTO heblb_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","התלמידים עשו כדבריו והושיבו את הקהל. ");
INSERT INTO heblb_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","ישוע לקח את חמש ככרות הלחם ואת שני הדגים, הביט לשמים, וביקש מאלוהים שיברך את האוכל. לאחר מכן פרס את הלחם, חתך את הדגים והגיש לתלמידיו שיחלקו לעם. ");
INSERT INTO heblb_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","כולם אכלו עד ששבעו, וכאשר אספו את הפירורים שנשארו מילאו שנים־עשר סלים. ");
INSERT INTO heblb_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","יום אחד כשהתפלל ישוע לבדו ורק תלמידיו היו בחברתו, הוא שאל אותם: ”למי חושבים אותי האנשים?“ ");
INSERT INTO heblb_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","”ליוחנן המטביל“, השיבו התלמידים. ”אבל יש החושבים שאתה אליהו הנביא, ואחרים חושבים שאתה אחד מאבותינו הנביאים שקם לתחייה.“ ");
INSERT INTO heblb_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","”למי אתם חושבים אותי?“ המשיך ישוע לשאול. ”אתה משיח אלוהים!“ ענה פטרוס. ");
INSERT INTO heblb_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","ישוע ציווה עליהם לא לספר זאת לאיש. ");
INSERT INTO heblb_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","”על בן־האדם לסבול הרבה“, הוסיף ישוע. ”זקני היהודים, ראשי הכוהנים והסופרים ידחו אותו ואף יהרגו אותו, אולם כעבור שלושה ימים יקום לתחייה!“ ");
INSERT INTO heblb_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","לאחר מכן אמר ישוע לכולם: ”מי שרוצה ללכת בעקבותיי חייב להתכחש לעצמו, לוותר על נוחיותו ושאיפותיו, לשאת עמו את צלבו יום־יום ולבוא אחרי. ");
INSERT INTO heblb_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","כי מי שחפץ להציל את חייו – יאבד אותם, ואילו מי שיוותר על חייו למעני – יציל אותם. ");
INSERT INTO heblb_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","מה הרוויח אדם שהשיג את העולם כולו אבל הפסיד חיי־נצח? ");
INSERT INTO heblb_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","”דעו לכם, שכל מי שמתבייש בי ובדברי, הוא יהיה לבושה לבן־האדם כאשר יבוא בכבודו ובכבוד של אביו עם המלאכים הקדושים. ");
INSERT INTO heblb_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","אני אומר לכם את האמת: בין העומדים פה עתה יש כאלה שלא ימותו לפני שיראו את מלכות האלוהים!“ ");
INSERT INTO heblb_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","כעבור שמונה ימים לקח איתו ישוע את פטרוס, יוחנן ויעקב ועלה על אחד ההרים כדי להתפלל. ");
INSERT INTO heblb_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","בזמן שישוע התפלל, פניו השתנו ובגדיו הלבינו והבריקו. ");
INSERT INTO heblb_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","לפתע הופיעו משה רבנו ואליהו הנביא ודיברו איתו. ");
INSERT INTO heblb_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","הופעתם הייתה מרשימה ומהודרת, והם דיברו עם ישוע על מותו הקרוב בירושלים, שהיה צפוי לפי דבר ה׳. ");
INSERT INTO heblb_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","בינתיים שקעו פטרוס והאחרים בשינה עמוקה, וכשהתעוררו ראו את כבודו והדרו של ישוע ואת השנים שעמדו לידו. ");
INSERT INTO heblb_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","כשעמדו אליהו ומשה ללכת קרא פטרוס, בלי לדעת מה הוא אומר: ”רבי, כמה טוב שאנחנו כאן! מדוע לא נקים כאן שלוש סוכות לכבוד – לך, למשה ולאליהו?“ ");
INSERT INTO heblb_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","בעודו מדבר כיסה אותם ענן והם נמלאו פחד. ");
INSERT INTO heblb_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","ומן הענן קרא קול: ”זהו בני בחירי, שמעו בקולו.“ ");
INSERT INTO heblb_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","לאחר הקול נראה ישוע עומד לבדו. התלמידים לא סיפרו לאיש את אשר ראו אלא חיכו. ");
INSERT INTO heblb_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","כשירדו מן ההר למחרת, באו אנשים רבים לקראת ישוע, ");
INSERT INTO heblb_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","ואחד מהם קרא: ”רבי, אני מתחנן לפניך שתביט בבני היחיד. ");
INSERT INTO heblb_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","שד אוחז בו, הוא גורם לו לצרוח ללא סיבה, משליך אותו על הרצפה ומתיש את כוחו עד שריר נוזל מפיו. השד הזה מדכא את בני מאוד וכמעט שאינו מניח לו לנפשו. ");
INSERT INTO heblb_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","התחננתי לפני תלמידיך שיגרשו את השד, אבל הם לא יכלו לעשות זאת.“ ");
INSERT INTO heblb_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","”מה עיקש וחסר־אמונה הדור הזה!“ קרא ישוע. ”עד מתי יהיה עלי לסבול אתכם? הביאו אלי את הילד!“ ");
INSERT INTO heblb_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","לפני שהספיק הילד להגיע אל ישוע, השד הפיל אותו ארצה כאשר הוא מפרכס. אולם ישוע גירש ממנו את השד בגערה, ריפא אותו והשיבו לאביו. ");
INSERT INTO heblb_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","כשראו הנוכחים את הגילוי הזה של כוח אלוהים, נפלה עליהם יראה גדולה. בעוד הקהל מתפעל ומחליף רשמים על מעשיו הנפלאים, אמר ישוע לתלמידיו: ");
INSERT INTO heblb_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","”הקשיבו לדברי בתשומת לב: בן־האדם עומד להימסר לידי אנשים.“ ");
INSERT INTO heblb_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","אולם התלמידים לא הבינו למה התכוון; דבר־מה מנע מבעדם מלהבין והם חששו לשאול אותו למה התכוון. ");
INSERT INTO heblb_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","בין התלמידים התעורר ויכוח: מיהו החשוב והגדול ביניהם. ");
INSERT INTO heblb_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","ישוע ידע את מחשבותיהם ולכן קרא לילד קטן, העמידו לידו ");
INSERT INTO heblb_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ואמר לתלמידיו: ”מי שמקבל ילד קטן כזה, כאילו מקבל אותי; ומי שמקבל אותי, מקבל למעשה את אבי אשר שלח אותי. הקטן מביניכם – הצנוע והעניו ביותר – הוא הגדול ביניכם!“ ");
INSERT INTO heblb_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","יוחנן תלמידו פנה אליו ואמר: ”רבי, ראינו איש שמגרש שדים בשמך ואמרנו לו לחדול מכך, כי אין הוא שייך לקבוצתנו.“ ");
INSERT INTO heblb_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","”לא הייתם צריכים לומר לו זאת,“ השיב לו ישוע, ”כי מי שאינו נגדכם הוא בעדכם.“ ");
INSERT INTO heblb_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","בהתקרב המועד שבו יילקח לשמים, התכונן ישוע ללכת לירושלים. ");
INSERT INTO heblb_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","יום אחד הוא שלח לפניו שליחים, כדי שיכינו לו מקום לינה באחד מכפרי השומרונים. ");
INSERT INTO heblb_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","אולם השומרונים סרבו לתת להם מקום לינה, משום שפניהם של ישוע ותלמידיו היו מועדות לירושלים (לשומרונים היה ויכוח עם היהודים בנוגע לירושלים). ");
INSERT INTO heblb_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","כשהגיע הדבר לאוזני ישוע ותלמידיו, שאלו יעקב ויוחנן: ”אתה רוצה שנצווה כי תרד אש מהשמים ותשרוף אותם?“ ");
INSERT INTO heblb_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","אולם ישוע גער בהם, ");
INSERT INTO heblb_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","והחבורה המשיכה בדרכה אל כפר אחר. ");
INSERT INTO heblb_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","בדרך אמר מישהו לישוע: ”אדוני, לאן שתלך, אני אלך אחריך!“ ");
INSERT INTO heblb_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","אולם ישוע השיב לו: ”אל תשכח שאין לי מקום להניח את ראשי. השועלים מתגוררים במחילות האדמה ולציפורים יש קנים, אולם לבן־האדם אין מקום להניח בו את ראשו.“ ");
INSERT INTO heblb_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","בהזדמנות אחרת אמר ישוע לאיש מסוים: ”בוא אחרי והיה תלמיד שלי.“ האיש הסכים, אולם ביקש לקבור תחילה את אביו. ");
INSERT INTO heblb_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","”הנח למתים (מבחינה רוחנית) לקבור את המתים שלהם“, אמר לו ישוע. ”ואילו אתה לך להכריז על מלכות האלוהים.“ ");
INSERT INTO heblb_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","איש אחר אמר לישוע: ”אני אלך אחריך, אדוני, אך הרשה לי תחילה ללכת הביתה ולהיפרד מבני משפחתי.“ ");
INSERT INTO heblb_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","אבל ישוע השיב לו: ”השם את ידו על המחרשה ומביט אחריו לא יהיה כשיר למלכות האלוהים.“ ");
INSERT INTO heblb_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","לאחר מכן בחר האדון שבעים תלמידים נוספים, ושלח אותם לפניו בזוגות אל הערים והכפרים שבהם עמד לבקר. ");
INSERT INTO heblb_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","”מאחר שהקציר רב והפועלים מעטים,“ אמר להם ישוע, ”התחננו לאלוהים שישלח פועלים נוספים לעזור לכם בעבודתכם למענו. ");
INSERT INTO heblb_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","לכו עתה וזכרו שאני שולח אתכם כשלוח כבשים בין זאבים. ");
INSERT INTO heblb_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","אל תיקחו אתכם כסף, חפצים אישיים ואף לא זוג נעליים נוסף, ואל תעצרו בדרך לשוחח עם איש. ");
INSERT INTO heblb_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","”בכניסתכם לכל בית ברכו אותו תחילה לשלום. ");
INSERT INTO heblb_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","אם באותו בית גר אדם אוהב שלום, הברכה תתקיים, ואם אין אוהב שלום באותו בית – הברכה תשוב אליכם. ");
INSERT INTO heblb_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","”בבואכם אל כפר או עיר אל תעברו מבית מארח אחד לאחר, אלא התארחו בבית אחד בלבד, ואל תהססו לאכול ולשתות כל מה שמגישים לכם, כי הפועל ראוי לשכרו. ");
INSERT INTO heblb_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","”בכל עיר שבה מקבלים אתכם בשמחה איכלו את המוגש לפניכם, ");
INSERT INTO heblb_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","רפאו את החולים ואמרו להם: ’מלכות האלוהים קרובה אליכם‘. ");
INSERT INTO heblb_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","”בעיר שבה לא מקבלים אתכם צאו לרחובות וקראו: ");
INSERT INTO heblb_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","’כמחאה על התנהגותכם אנחנו מנערים את אבק עירכם שדבק ברגלינו, אולם דעו לכם שאכן קרובה מלכות האלוהים!‘ ");
INSERT INTO heblb_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","אני אומר לכם שאפילו לסדום המרושעת יהיה קל יותר ביום הדין מאשר לעיר הזאת. ");
INSERT INTO heblb_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","”אוי ואבוי לכן, כורזין ובית־צידה! אילו חוללתי בצור ובצידון את הנסים שחוללתי בקרבכן, מזמן היו שם כולם חוזרים בתשובה ולובשים שק ואפר לאות חרטה. ");
INSERT INTO heblb_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","כן, צור וצידון תקבלנה עונש קל משלכן ביום הדין! ");
INSERT INTO heblb_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","ואתם, אנשי כפר־נחום, החושבים אתם שירוממו אתכם לשמים? לגיהינום תרדו!“ ");
INSERT INTO heblb_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","ישוע המשיך לדבר אל התלמידים: ”מי ששומע לכם שומע לי; מי שמזלזל בכם מזלזל בי; ומי שמזלזל בי מזלזל באלוהים אשר שלח אותי.“ ");
INSERT INTO heblb_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","כעבור זמן־מה חזרו שבעים השליחים אל ישוע ודיווחו לו בשמחה: ”אדוננו, אפילו השדים נכנעים לנו כשאנו מצווים עליהם בשמך!“ ");
INSERT INTO heblb_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","”אכן,“ ענה ישוע, ”ראיתי את השטן נופל מן השמים כברק! ");
INSERT INTO heblb_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","באמת הענקתי לכם סמכות וכוח להתגבר על כל כוחות האויב, ולרמוס נחשים ועקרבים. דבר לא יוכל לפגוע בכם! ");
INSERT INTO heblb_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","אף־על־פי־כן עליכם לשמוח לא משום שאתם יכולים להתגבר על השדים, אלא משום ששמותיכם כתובים בשמים!“ ");
INSERT INTO heblb_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","לאחר מכן נמלא ישוע שמחת רוח הקודש וקרא: ”אבי, אדון השמים והארץ, אני מודה לך על שהסתרת דברים אלה מפני חכמים ומשכילים, וגילית אותם לאנשים פשוטים שבוטחים בך כמו ילדים. כן, תודה לך אבי, מפני שכך רצית. ");
INSERT INTO heblb_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","הכול נמסר לי מאבי; אף אחד אינו מכיר ממש את הבן, מלבד האב, ואף אחד אינו מכיר ממש את האב, מלבד הבן ואלה שהוא בוחר לגלות להם את האב.“ ");
INSERT INTO heblb_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","ישוע פנה אל תלמידיו ואמר להם בשקט: ”זכות גדולה נפלה בחלקכם, שיכולים אתם לראות את אשר ראיתם. ");
INSERT INTO heblb_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","נביאים ומלכים רבים השתוקקו לראות את מה שאתם רואים ולשמוע את מה שאתם שומעים, אך לא זכו.“ ");
INSERT INTO heblb_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","פעם רצה אחד מחכמי־התורה לנסות את ישוע. ”רבי,“ שאל החכם, ”מה עלי לעשות כדי לזכות בחיי נצח?“ ");
INSERT INTO heblb_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","”מה אומרת על כך התורה?“ השיב לו ישוע בשאלה. ");
INSERT INTO heblb_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","”התורה אומרת: ’ואהבת את ה׳ אלוהיך בכל לבבך, ובכל נפשך ובכל מאודך; ואהבת לרעך כמוך‘“, השיב החכם. ");
INSERT INTO heblb_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","”נכון מאוד“, אישר ישוע. ” ’אם תקיים מצוות אלה תזכה בחיי נצח‘.“ ");
INSERT INTO heblb_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","החכם רצה להצדיק את רגשותיו (מפני שלא אהב אנשים מסוימים), ולכן שאל: ”מיהו רעי?“ ");
INSERT INTO heblb_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","ישוע השיב במשל: ”יהודי אחד הלך בדרך מירושלים ליריחו והותקף על־ידי שודדים. הם הפשיטו את בגדיו מעליו, גזלו את כספו, הכו אותו באכזריות והשאירו אותו בצד הדרך פצוע קשות. ");
INSERT INTO heblb_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","במקרה עבר שם כהן אחד, אולם בראותו את הפצוע עבר לצדו השני של השביל. ");
INSERT INTO heblb_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","עבר במקום גם איש משבט לוי. הוא הביט בפצוע המוטל בצד הדרך, אולם המשיך בדרכו. ");
INSERT INTO heblb_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","הזדמן למקום שומרוני אחד, ובראותו את הפצוע נמלא רחמים. ");
INSERT INTO heblb_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","השומרוני ניגש אל הפצוע, משח את פצעיו וחבש אותם, לאחר מכן הרכיב אותו על חמורו והביאו לאכסניה, שם טיפל בו והאכיל אותו. ");
INSERT INTO heblb_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","למחרת, לפני שהמשיך בדרכו, שילם השומרוני סכום כסף לבעל האכסניה ואמר: ’דאג בבקשה לכל מחסורו של הפצוע, ואם לא יספיק הכסף – אשלם את החסר בשובי‘. ");
INSERT INTO heblb_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","”מי מהשלושה היה לדעתך רע טוב לאיש הפצוע?“ ");
INSERT INTO heblb_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","”האדם שריחם עליו“, השיב החכם. ”נכון“, הסכים איתו ישוע. ”לך ועשה כמוהו.“ ");
INSERT INTO heblb_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","ישוע ותלמידיו המשיכו בדרכם, וכשהגיעו לאחד הכפרים הזמינה אותם אישה בשם מרתא להתארח בביתה. ");
INSERT INTO heblb_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","אחותה מרים התיישבה על הארץ לרגלי ישוע והקשיבה לדבריו. ");
INSERT INTO heblb_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","מרתא חשה לחץ מהעבודה שבהכנת ארוחה גדולה לכולם, ומשום כך פרצה לחדר וקראה: ”נכון שאין זה הוגן שאחותי תשאיר לי את כל העבודה? אמור לה בבקשה שתבוא לעזור לי.“ ");
INSERT INTO heblb_vpl VALUES ("LK10_41‏","072_10_41‏","LUK","10","41‏","42","”מרתא, יקירתי,“ השיב לה האדון, ”את דואגת לכל כך הרבה דברים. עליך לדאוג לדבר אחד בלבד. מרים בחרה בדבר האחד הזה אשר לא יילקח ממנה.“ ");
INSERT INTO heblb_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","יום אחד התפלל ישוע במקום מסוים, וכשסיים ניגש אליו אחד מתלמידיו ואמר: ”אדון, למד אותנו להתפלל, כשם שיוחנן לימד את תלמידיו.“ ");
INSERT INTO heblb_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","”התפללו כך“, אמר להם ישוע: ”אבינו שבשמים, יתקדש שמך, תבוא מלכותך. ");
INSERT INTO heblb_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","ספק לנו יום־יום את המזון הדרוש לנו, ");
INSERT INTO heblb_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","סלח לנו על חטאינו, כשם שגם אנחנו סולחים לאלה שחטאו לנו, ועזור לנו לעמוד נגד פיתויים וניסיונות.“ ");
INSERT INTO heblb_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","ישוע הוסיף ואמר: ”נניח שאחד מכם הולך לבית חברו באמצע הלילה וקורא בקול: ’עשה לי טובה והלווה לי שלוש ככרות לחם. ");
INSERT INTO heblb_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","כי אחד מידידי בא לבקר אותי ואין לי אוכל בשבילו‘. ");
INSERT INTO heblb_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","ואילו החבר עונה ממיטתו: ’אל תטריד אותי באמצע הלילה. הדלת נעולה, ילדי ישנים וגם אני כבר במיטה בעצמי, מצטער שאיני יכול לעזור לך הפעם‘. ");
INSERT INTO heblb_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","”אני אומר לכם: אמנם הוא לא יפתח את הדלת בזכות ידידותם, אבל הוא יקום ויפתח את הדלת ויביא לו את מה שרצה כדי להימנע מהחרפה שלא נענה לבקשת חברו. ");
INSERT INTO heblb_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","כך גם בתפילה: אם תבקשו – תקבלו; אם תחפשו – תמצאו; ואם תדפקו תיפתח לפניכם הדלת. ");
INSERT INTO heblb_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","משום שכל המבקש מקבל; כל המחפש מוצא, ולפני כל דופק נפתחת הדלת. ");
INSERT INTO heblb_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","”אני פונה אל האבות שביניכם: כשהילד שלכם מבקש מכם פרוסת לחם, האם אתם נותנים לו אבן? או כאשר מבקש דג, האם אתם נותנים לו נחש? ");
INSERT INTO heblb_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","ואם הוא מבקש ביצה, האם אתם נותנים לו עקרב? ");
INSERT INTO heblb_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","ואם גם אנשים חוטאים כמוכם נותנים לילדיכם מה שטוב להם, האם אינכם מבינים כי אביכם שבשמים יעשה למענכם הרבה יותר, וייתן את רוח הקודש למי שמבקש ממנו?“ ");
INSERT INTO heblb_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","יום אחד גירש ישוע שד מאיש אילם, וכושר הדיבור שב אליו. הקהל התרגש והתלהב מהמאורע, ");
INSERT INTO heblb_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","אולם היו שאמרו: ”אין פלא שהוא יכול לגרש שדים, הרי הוא מקבל את כוחו מבעל־זבוב שר השדים!“ ");
INSERT INTO heblb_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","אחרים רצו לנסותו, ולכן ביקשו ממנו לחולל נס מהשמים על־מנת לשכנע אותם. ");
INSERT INTO heblb_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","ישוע ידע את מחשבותיהם ולכן אמר: ”ממלכה מפולגת לא תחזיק מעמד ותתמוטט. משפחה מפולגת בדעותיה תיהרס. ");
INSERT INTO heblb_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","לפיכך כיצד יכולים אתם לטעון שאני נלחם נגד השדים בשם שר השדים? אילו הייתה טענתכם נכונה, אזי כיצד יכלה ממלכת השטן להחזיק מעמד? ");
INSERT INTO heblb_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","מלבד זאת, אם אני מקבל את כוחי מבעל זבוב שר השדים, מה בנוגע לבניכם? הלא גם הם מגרשים שדים! האם אתם חושבים כי עובדה זאת מוכיחה שהם מקבלים את כוחם מהשטן? שאלו אותם אם אתם צודקים. ");
INSERT INTO heblb_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","אולם אם אני מגרש את השדים בכוח אלוהים, הדבר מוכיח כי הגיעה אליכם מלכות האלוהים. ");
INSERT INTO heblb_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","”כשאיש גיבור שומר על ארמונו, חמוש ומצויד בכלי הגנה, הארמון בטוח. ");
INSERT INTO heblb_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","אולם כשמישהו חזק ממנו מתקיף אותו ומתגבר עליו, הוא פורק מעליו את נשקו ולוקח את השלל מביתו. ");
INSERT INTO heblb_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","”מי שאינו בעדי הוא נגדי; ומי שאינו אוסף איתי – מפזר. ");
INSERT INTO heblb_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","כאשר שד מגורש מאדם, הוא הולך למדבר ומחפש לו מנוחה; מאחר שהשד אינו מוצא מנוחה, הוא חוזר אל האדם שממנו יצא, ");
INSERT INTO heblb_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","ומגלה כי מעונו לשעבר מטואטא ומהודר. ");
INSERT INTO heblb_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","על כן הולך השד ומביא איתו שבעה שדים רעים ממנו וכולם נכנסים באיש, וכך מצבו של האיש האומלל גרוע משהיה.“ ");
INSERT INTO heblb_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","בזמן שישוע דיבר קראה אישה אחת בקהל: ”יברך אלוהים את אמך – את הבטן שנשאה אותך ואת השדיים שהניקו אותך!“ ");
INSERT INTO heblb_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","”אך האמת היא,“ אמר ישוע, ”שאלוהים יברך את אלה אשר שומעים את דבר אלוהים ומצייתים!“ ");
INSERT INTO heblb_vpl VALUES ("LK11_29‏","072_11_29‏","LUK","11","29‏","32","קהל השומעים הלך וגדל וישוע המשיך: ”מה רעים אנשי הדור הזה! הם מבקשים אות מהשמים (כדי להשתכנע שאני דובר אמת), אולם האות היחיד שיינתן להם יהיה אות יונה הנביא. כשם שיונה היה לאות לאנשי נינווה, כך יהיה בן האדם לדור הזה. ביום הדין, כשיעמדו אנשי הדור הזה למשפט, תקום מלכת־שבא ותרשיע אותם, מפני שהיא באה מארץ רחוקה כדי להקשיב לחכמת שלמה, ואילו לפניכם עומד אדם גדול משלמה. ");
INSERT INTO heblb_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","”איש אינו מדליק נר על־מנת להסתירו. אדם שמדליק נר שם אותו במרכז החדר, שיאיר לכל המבקרים. ");
INSERT INTO heblb_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","”עין האדם היא אור גופו; כשעינך בריאה, כל גופך מלא אור, אולם כשעינך חולה, כל גופך שרוי בחשכה. ");
INSERT INTO heblb_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","לכן היזהר שאורך הפנימי לא יחשך. ");
INSERT INTO heblb_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","אם גופך מלא אור ואין בו פינות חשוכות יזרחו גם פניך, כאילו הן מוצפות אור חזק.“ ");
INSERT INTO heblb_vpl VALUES ("LK11_37‏","072_11_37‏","LUK","11","37‏","38","כשסיים ישוע לדבר, פרוש אחד הזמין אותו לאכול בביתו. בבואו אל הבית התיישב ישוע ליד השולחן מבלי ליטול ידיים לפני הארוחה כמקובל. התנהגותו הפליאה מאוד את הפרוש. ");
INSERT INTO heblb_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","לכן אמר לו ישוע: ”אתם, הפרושים, מטהרים רק מה שבחוץ בעוד שבתוככם אתם מסריחים מרוב מעשים רעים ורדיפת־בצע. ");
INSERT INTO heblb_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","כסילים שכמותכם! האם האלוהים אשר ברא את הצד החיצוני לא ברא גם את הצד הפנימי? ");
INSERT INTO heblb_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","אם תתנו צדקה לנזקקים מהלב, אז תטהרו את לבכם. ");
INSERT INTO heblb_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","”אוי לכם הפרושים! אתם אומנם מקפידים לשלם מעשר מכל הכנסה, ולו גם הקטנה ביותר, אבל אתם מזניחים לחלוטין את הצדק ואת אהבת האלוהים. ודאי שעליכם לשלם מעשר, אבל לא על חשבון חובותיכם האחרים! ");
INSERT INTO heblb_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","”אוי לכם הפרושים, כי אתם מחפשים כבוד אצל בני־אדם. אתם אוהבים לשבת במקומות הנכבדים בבית־הכנסת, ואתם גם אוהבים שישאלו לשלומכם בשווקים ויחלקו לכם כבוד. ");
INSERT INTO heblb_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","”אוי לכם הפרושים, כי אתם דומים לקברים נסתרים בשדה – אנשים רבים דורכים על השחיתות שלכם בלי שידעו על קיומה!“ ");
INSERT INTO heblb_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","אחד מחכמי־התורה הגיב על דברי ישוע: ”רבי, בדבריך אלו אתה מעליב גם אותנו.“ ");
INSERT INTO heblb_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","”נכון,“ השיב ישוע, ”אוי ואבוי גם לכם, חכמי־התורה, כי אתם כופים על בני־האדם דרישות ומצוות שאין הם יכולים לשאת, בעוד שאתם בעצמכם אינכם נוגעים במשאות ולא מרימים אצבע. ");
INSERT INTO heblb_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","אוי ואבוי לכם! אתם בונים מצבות לנביאים. אתם מתנהגים ממש כמו אבותיכם שהרגו את הנביאים. ");
INSERT INTO heblb_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","הם הרגו אותם ואתם בונים את קברותיהם, וכך שותפים למעשיהם. ");
INSERT INTO heblb_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","”אתם יודעים מהי חוכמת אלוהים לגביכם? ’אשלח אליכם נביאים ושליחים, אבל את חלקם תהרגו ואת האחרים תבריחו‘. ");
INSERT INTO heblb_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","משום כך אתם, אנשי הדור הזה, תהיו חייבים לתת את הדין על שפיכת דמם של כל עבדי האלוהים מבריאת־העולם – ");
INSERT INTO heblb_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","מרצח הבל ועד רצח זכריה שנהרג בחצר בית־המקדש. אני אומר לכם שאלוהים יטיל עליכם את האחריות למותם. ");
INSERT INTO heblb_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","”אוי ואבוי לכם, חכמי התורה, כי אתם לוקחים את מפתח הדעת מן האנשים. לא די שבעצמכם אינכם מאמינים באמת, אתם גם מונעים מאחרים את האפשרות להאמין בה.“ ");
INSERT INTO heblb_vpl VALUES ("LK11_53‏","072_11_53‏","LUK","11","53‏","54","הפרושים והסופרים רתחו מכעס ומאותו יום ואילך הפנו עליו שאלות קשות ומכשילות, בתקווה שייכשל בלשונו ויוכלו לאסור אותו. ");
INSERT INTO heblb_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","בינתיים הלך וגדל מספר הנוכחים עד שהגיע לאלפים רבים, ומרוב דוחק וצפיפות דרכו אחד על רגלי השני. ישוע פנה תחילה אל תלמידיו ואמר: ”היזהרו מצביעותם של הפרושים! הם מעמידים פני צדיקים תמימים בזמן שמעשיהם והתנהגותם מצביעים על היפוכו של דבר. אולם צביעות כזאת אי־אפשר להסתיר לנצח, ");
INSERT INTO heblb_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","כי בבוא העת כל מה שמוסתר עכשיו ייגלה, וכל מה שאינו ידוע ייוודע. ");
INSERT INTO heblb_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","לפיכך, כל מה שאמרתם בחשכה יישמע באור היום, וכל מה שלחשתם בין ארבעה קירות ייקרא בקולי קולות מעל גגות הבתים! ");
INSERT INTO heblb_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","”ידידים יקרים, אל תפחדו מאלה הרוצים להרוג אתכם, כי הם יכולים להמית אך ורק את הגוף, בעוד שבנפש אין הם מסוגלים לפגוע. ");
INSERT INTO heblb_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","היודעים אתם ממי עליכם לפחד? מאלוהים! כי הוא מסוגל להמית ואחר כך להשליך לגיהינום! ");
INSERT INTO heblb_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","”מה מחירן של חמש ציפורי דרור, שניים־שלושה שקלים? אף־על־פי־כן אלוהים אינו שוכח אף אחת מהן. ");
INSERT INTO heblb_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","אלוהים יודע אפילו את מספר השערות על ראשכם. לכן אל תפחדו; אתם יקרים לאלוהים יותר מציפורים רבות. ");
INSERT INTO heblb_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","”אני מבטיח לכם שכל המודה שהוא מאמין בי לפני בני־האדם, גם אני אכבד אותו ואודה בו לפני מלאכי אלוהים. ");
INSERT INTO heblb_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","אולם מי שמתכחש לי לפני בני־אדם, גם אני אתכחש לו לפני מלאכי אלוהים. ");
INSERT INTO heblb_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","ובכל זאת, מי שידבר נגד בן־האדם ייסלח לו, בעוד שאדם המדבר נגד רוח הקודש לא ייסלח לו לעולם. ");
INSERT INTO heblb_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","”כאשר יביאו אתכם למשפט בבתי־הכנסת או לפני שליטים וממשלות, אל תדאגו כיצד תגנו על עצמכם וכיצד תעידו, ");
INSERT INTO heblb_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","כי רוח הקודש יגיד לכם מה לומר בזמן המתאים.“ ");
INSERT INTO heblb_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","איש אחד מהקהל קרא אל ישוע: ”רבי, אמור בבקשה לאחי שייתן לי את חלקי בירושת אבינו.“ ");
INSERT INTO heblb_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","אולם ישוע השיב: ”מי מינה אותי להיות לכם שופט ובורר? ");
INSERT INTO heblb_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","היזהרו מכל חמדנות, כי חיי האדם והאושר אינם תלויים בעושרו ובנכסיו.“ ");
INSERT INTO heblb_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","ישוע סיפר להם את המשל הבא: ”לעשיר אחד היה שדה פורה שהניב יבול רב. ");
INSERT INTO heblb_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","אסמיו היו מלאים עד אפס מקום, והאיש לא ידע מה לעשות בתבואה הרבה שכבר לא יכול היה לאחסן. ");
INSERT INTO heblb_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","’אני יודע מה עלי לעשות!‘ קרא האיש. ’אהרוס את האסמים הקיימים ואבנה לעצמי אסמים גדולים יותר. כך אוכל לאחסן את התבואה הרבה שלי. ");
INSERT INTO heblb_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","אחר כך אומר לעצמי: יש לך מספיק כסף לשנים רבות. מעתה ואילך אל תעבוד קשה, כי אם אכול, שתה ותהנה‘. ");
INSERT INTO heblb_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","אבל אלוהים אמר לו: ’שוטה שכמוך! הלילה תמות, ומה תעשה עם כל מה שאגרת לעצמך?‘ ");
INSERT INTO heblb_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","כך יקרה לכל אדם האוגר לעצמו אוצר על־פני האדמה ולא בשמים.“ ");
INSERT INTO heblb_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","ישוע פנה אל תלמידיו ואמר: ”אל תדאגו למה שתאכלו או תלבשו, ");
INSERT INTO heblb_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","כי החיים חשובים הרבה יותר מהאוכל, והגוף חשוב הרבה יותר מהלבוש. ");
INSERT INTO heblb_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","קחו לדוגמה את העורבים – הם אינם זורעים, אינם קוצרים ואין להם מחסן לאגור את מזונם. אף־על־פי־כן לא חסר להם דבר כי אלוהים מאכיל אותם ודואג להם. ואתם הרי יקרים לאלוהים הרבה יותר מן העופות! ");
INSERT INTO heblb_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","מלבד זאת, מה תועיל דאגתכם? האם יכולה דאגתכם להוסיף עוד יום לחייכם או עוד סנטימטר לקומתכם? ");
INSERT INTO heblb_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","אם דאגתכם אינה מסוגלת לשנות דברים פעוטים כאלה, מה הטעם לדאוג לדברים גדולים יותר? ");
INSERT INTO heblb_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","”הביטו בשושנים – הן אינן טוות ואינן אורגות, ואף־על־פי־כן אפילו שלמה המלך בכל תפארתו לא היה לבוש יותר יפה מהן! ");
INSERT INTO heblb_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","ואם אלוהים מלביש את פרחי השדה הצומחים היום ונובלים מחר, האם אינכם חושבים שילביש גם אתכם, חסרי אמונה שכמותכם? ");
INSERT INTO heblb_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","אל תדאגו למה שתאכלו ותשתו ואל תדאגו שמא לא יספק לכם אלוהים את מה שאתם צריכים. ");
INSERT INTO heblb_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","בני־אדם שאינם מאמינים באלוהים דואגים יום־יום למה שיאכלו וישתו, אולם אביכם שבשמים יודע בדיוק מה אתם צריכים. ");
INSERT INTO heblb_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","דאגו לכל הקשור באלוהים ובמלכותו, והוא יספק לכם יום־יום את כל צרכיכם. ");
INSERT INTO heblb_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","”אל תפחד, עדר קטן, כי אביכם שבשמים משתוקק להעניק לכם את מלכותו. ");
INSERT INTO heblb_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","מכרו את רכושכם ותנו כסף לנזקקים. מעשה זה יגדיל את אוצרכם בשמים, ואוצר בשמים לעולם לא ייפגם. כן, אוצרכם לעולם לא ידלדל, גנב לא יוכל לגנבו ועש לא יכרסם בו. ");
INSERT INTO heblb_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","במקום שבו נמצא אוצרכם שם נמצא גם לבכם ומחשבותיכם. ");
INSERT INTO heblb_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","”היו מוכנים לכל מה שיקרה – כשאתם לבושים ובידכם נר דולק – ");
INSERT INTO heblb_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","כמשרתים המצפים לשובו של אדונם מהחתונה. כשיבוא אדונם וידפוק בדלת, יפתחו לו מיד. ");
INSERT INTO heblb_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","שמחה גדולה מצפה לאלה שיהיו מוכנים לשובו של האדון, כי הוא בעצמו יושיב אותם ליד השולחן וישרת אותם. ");
INSERT INTO heblb_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","אולי הוא יבוא בלילה, ואולי בבוקר השכם. אך בכל עת שיבוא תהיה שמחה גדולה לכל המשרתים שימצא אותם מוכנים לבואו. ");
INSERT INTO heblb_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","”אילו ידעו את השעה, היו כולם מתכוננים לבואו, כשם שהיו מתכוננים לבואו של גנב אילו ידעו מתי יבוא. ");
INSERT INTO heblb_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","גם אתם היו מוכנים תמיד, כי בן־האדם יבוא בשעה בלתי צפויה.“ ");
INSERT INTO heblb_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","”אדון,“ פתח פטרוס בשאלה, ”האם מכוון המשל הזה אלינו בלבד או אל כולם?“ ");
INSERT INTO heblb_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","”משל זה מכוון אל כל אדם נאמן ונבון, אשר אדוניו הפקיד בידו את האחריות להשגיח על עבדיו ולדאוג לכלכלתם“, השיב האדון. ");
INSERT INTO heblb_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","”ברוך תהיה אם בשובי אמצא אותך ממלא את תפקידך בנאמנות. ");
INSERT INTO heblb_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","אנשים נאמנים כאלה אני אפקיד על כל רכושי. ");
INSERT INTO heblb_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","”אולם אם אתה רשע ותאמר לעצמך: ’אה, האדון לא ישוב כל כך מהר‘, – ותתאכזר ליתר העבדים ותבלה את זמנך במסיבות, בזלילה ובשתייה – ");
INSERT INTO heblb_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","אדונך יופיע בשעה בלתי צפויה, ואז הוא יכה אותך קשות ויקבע את מקומך עם הבלתי־נאמנים. ");
INSERT INTO heblb_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","הוא גם ייענש בכל חומרת הדין, מאחר שידע את חובתו וסירב למלא אותה. ");
INSERT INTO heblb_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","”לעומת זאת, אדם שלא ידע את רצון אדוניו ועשה מעשה המחייב עונש, לא ייענש בכל חומרת הדין. מי שקיבל הרבה יידרש ממנו הרבה חזרה, כי אחריותו גדולה משל אחרים. ");
INSERT INTO heblb_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","”באתי להצית אש בעולם, ואני מייחל שמשימתי תושלם. ");
INSERT INTO heblb_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","טבילה נוראה מצפה לי, ועד שאעבור אותה אני שרוי במצוקה גדולה. ");
INSERT INTO heblb_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","אתם חושבים שבאתי להשכין שלום בארץ? טעות בידיכם; באתי לגרום למחלוקת, ");
INSERT INTO heblb_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","מעתה ואילך תתפלגנה משפחות; שלושה מבני המשפחה יהיו בעדי ושניים נגדי – או להיפך. ");
INSERT INTO heblb_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","אב יחלוק על בנו; בן יחלוק על אביו; אם תחלוק על בתה; בת תחלוק על אמה; החמה תחלוק על כלתה; והכלה תחלוק על חמותה.“ ");
INSERT INTO heblb_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","ישוע פנה אל ההמון ואמר: ”כשאתם רואים עננים עולים מן המערב אתם אומרים: ’עומד לרדת גשם‘. ואתם צודקים. ");
INSERT INTO heblb_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","כשנושבת רוח דרומית אתם אומרים: ’יהיה חמסין‘. ואתם צודקים. ");
INSERT INTO heblb_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","צבועים! אתם יודעים לפרש את סימני הטבע בשמים ובארץ, אבל אתם מסרבים להבין את משמעות העת שבה אנו חיים. ");
INSERT INTO heblb_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","מדוע אינכם מסוגלים להחליט בעצמכם מה נכון? ");
INSERT INTO heblb_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","כשאתה פוגש את יריבך בדרך לבית־המשפט, השתדל להשלים איתו וליישב את הסכסוך לפני שתגיעו לשופט, אחרת השופט עלול להשליך אותך לכלא. ");
INSERT INTO heblb_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","ואם כך יהיה, לא תצא מהכלא עד שתשלם את מלוא חובתך!“ ");
INSERT INTO heblb_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","אז באו אנשים לישוע וסיפרו לו שפילטוס רצח מספר יהודים מהגליל בעת שהקריבו זבחים בבית־המקדש. ");
INSERT INTO heblb_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","”האם אתם חושבים שהם נרצחו משום שהיו חוטאים גדולים יותר משאר אנשי הגליל?“ שאל ישוע. ");
INSERT INTO heblb_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","”ודאי שלא! אני אומר לכם שאם לא תחזרו בתשובה ותפנו לאלוהים יהיה סופכם כמו שלהם. ");
INSERT INTO heblb_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","”ומה בנוגע לשמונה־עשר האנשים שנהרגו כשהתמוטט עליהם המגדל בשילוח? האם הם היו החוטאים הגדולים ביותר בירושלים? ");
INSERT INTO heblb_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","ודאי שלא! אבל דעו לכם שאם לא תחזרו בתשובה יהיה סופכם כשלהם.“ ");
INSERT INTO heblb_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","ישוע סיפר להם את המשל הבא: ”אדם נטע בגנו עץ תאנה, אולם בכל פעם שבא לחפש תאנים ציפתה לו אכזבה כי העץ לא נשא כל פרי. ");
INSERT INTO heblb_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","לבסוף אמר לגנן: ’חיכיתי שלוש שנים ולא זכיתי אף בתאנה אחת! הבה נעקור את העץ וניטע אחר במקומו; חבל שיגזול חלקת אדמה יקרה‘. ");
INSERT INTO heblb_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","” ’חכה עוד שנה אחת, אדוני‘, ביקש הגנן. ’אני אקדיש לתאנה תשומת לב מיוחדת, אעדור סביבה ואזבל את האדמה. ");
INSERT INTO heblb_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","אם התאנה תשא פרי בשנה הבאה מה טוב, ואם לא – אעקור אותה‘. “ ");
INSERT INTO heblb_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","בשבת אחת כשלימד ישוע בבית־הכנסת, ");
INSERT INTO heblb_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","ראה אישה שהייתה בעלת־מום במשך שמונה־עשרה שנה. הגב שלה היה כפוף והיא לא יכלה להזדקף. ");
INSERT INTO heblb_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","ישוע קרא אליו את האישה ואמר לה: ”אישה, הרפאי ממחלתך!“ ");
INSERT INTO heblb_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","הוא נגע בה, והיא מיד הזדקפה והחלה להלל את אלוהים. ");
INSERT INTO heblb_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","ראש בית־הכנסת כעס מאוד על שישוע ריפא את האישה בשבת. ”שישה ימים בשבוע נועדו לעבודה!“ קרא בזעם אל הקהל. ”בואו להירפא בימי חול ולא בשבת!“ ");
INSERT INTO heblb_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","”צבוע שכמוך!“ הייתה תשובתו של האדון. ”אתם כולם, האם אינכם מתירים את הבהמות שלכם ומוליכים אותם אל השוקת בשבת לשתות מים? ");
INSERT INTO heblb_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","והאם אסור לי, רק משום ששבת היום, להתיר אישה זאת, יהודייה, מכבלי השטן שאסר אותה במשך שמונה־עשרה שנים?“ ");
INSERT INTO heblb_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","דבריו ביישו את מתנגדיו ואילו כל העם שמח על הנפלאות שחולל. ");
INSERT INTO heblb_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","ישוע חזר ולימד את העם על מלכות האלוהים: ”כיצד אוכל לתאר לכם את מלכות האלוהים, למה היא דומה? ");
INSERT INTO heblb_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","היא דומה לגרגר זעיר של צמח החרדל אשר נזרע בגינה. כעבור זמן מה גדל הגרגר הזעיר והופך לעץ, והציפורים בונות קן בין ענפיו.“ ");
INSERT INTO heblb_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","ועוד שאל: ”אל מה אדמה את מלכות האלהים? ");
INSERT INTO heblb_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","מלכות האלוהים דומה לשמרים בבצק – מעט השמרים מחמיצים את הבצק כולו.“ ");
INSERT INTO heblb_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","בדרכו לירושלים עבר ישוע מעיר לעיר ומכפר לכפר ולימד את האנשים. ");
INSERT INTO heblb_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","פעם שאל מישהו את ישוע: ”אדון, האם ייוושעו רק אנשים מעטים?“ ");
INSERT INTO heblb_vpl VALUES ("LK13_24‏","072_13_24‏","LUK","13","24‏","25","השיב לו ישוע: ”הואיל ושער הכניסה צר מאוד, עליכם להתאמץ מאוד כדי להיכנס דרכו. דעו לכם שאנשים רבים ירצו להיכנס דרך השער, אבל הם לא יוכלו; לאחר שבעל־הבית ינעל את השער יהיה מאוחר מדי. גם אם תעמדו בחוץ, תדפקו על השער ותתחננו: ’אדוננו, פתח לנו את הדלת!‘ הוא יענה לכם: ’אינני מכיר אתכם כלל, מאיפה אתם?‘ ");
INSERT INTO heblb_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","” ’אבל אכלנו ושתינו איתך ואף לימדת ברחוב שלנו‘, תגידו. ");
INSERT INTO heblb_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","והוא ישיב: ’אני אומר לכם שאני לא מכיר אתכם. הסתלקו מכאן, רשעים שכמותכם!‘ ");
INSERT INTO heblb_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","”אתם תהיו מחוץ למלכות האלוהים, במקום שיש בכי וחריקת שיניים, כשתראו את אברהם, יצחק, יעקב וכל הנביאים. ");
INSERT INTO heblb_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","מכל קצוות תבל יבואו אנשים אל מלכות האלוהים. ");
INSERT INTO heblb_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","דעו לכם כי יש כאלה שעתה נחשבים נחותים, אולם במלכות האלוהים הם יהיו גדולים. לעומתם יש כאלה שעתה הם אנשים חשובים וגדולים, אולם במלכות האלוהים יהיו קטנים ולא חשובים.“ ");
INSERT INTO heblb_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","באותה שעה באו פרושים אחדים אל ישוע והזהירו אותו: ”המלך הורדוס רוצה להרוג אותך! אם ברצונך לחיות, ברח מכאן!“ ");
INSERT INTO heblb_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","ישוע השיב להם: ”לכו ואמרו לשועל הזה שאמשיך לגרש שדים ולרפא את החולים היום ומחר, וביום השלישי אשלים את משימתי. ");
INSERT INTO heblb_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","כן, עלי להמשיך בדרכי היום, מחר ומחרתיים, כי לא ייתכן שנביא אלוהים ייהרג מחוץ לירושלים. ");
INSERT INTO heblb_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","”ירושלים, ירושלים, ההורגת את הנביאים ורוגמת באבנים את שליחי אלוהים! פעמים רבות חפצתי לאסוף את בנייך, כתרנגולת האוספת את אפרוחיה תחת כנפיה, אולם לא רצית. ");
INSERT INTO heblb_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","והנה אלוהים נוטש את ביתכם, ואני אומר לכם שלא תראו אותי שוב עד אשר תאמרו: ’ברוך הבא בשם ה׳!‘ “ ");
INSERT INTO heblb_vpl VALUES ("LK14_1‏","072_14_1‏","LUK","14","1‏","2","מנהיג פרושי אחד הזמין את ישוע לסעוד בביתו בשבת. האורחים האחרים שהיו בבית הפרוש הביטו בישוע בתשומת לב מרובה, כי רצו לראות אם ירפא איש חולה שהיה איתם. לאיש הייתה מחלה שמנפחת את הגוף בגלל עודף נוזלים. ");
INSERT INTO heblb_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","ישוע פנה אל הפרושים ואל חכמי־התורה ושאל: ”האם מותר לרפא חולה בשבת או אסור?“ ");
INSERT INTO heblb_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","משלא ענו לשאלתו אחז ישוע ביד החולה, ריפא אותו ושלח אותו לדרכו. ");
INSERT INTO heblb_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","לאחר מכן פנה ישוע אל הנוכחים ואמר: ”מי מכם אינו עובד בשבת? אם החמור או השור שלכם ייפול בשבת לתוך באר, לא תמהרו לחלץ אותו?“ ");
INSERT INTO heblb_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","גם הפעם לא השיבו לו. ");
INSERT INTO heblb_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","ישוע שם לב לכך שכל אחד מהאורחים בבית הפרוש השתדל לתפוס מקום ישיבה מכובד, ולכן אמר להם: ");
INSERT INTO heblb_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","”אם הוזמנת לחתונה, אל תשב בראש השולחן, שמא יבוא אורח חשוב ממך, ");
INSERT INTO heblb_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ואז יבוא המארח ויבקש ממך לפנות את מקומך לאורח הנכבד. בבושת פנים תאלץ לקום ולשבת בפינה, היכן שנותר כיסא פנוי. ");
INSERT INTO heblb_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","”נהג כך: בבואך לחתונה שב בפינה. כשיראה אותך המארח הוא יבוא ויאמר: ’ידידי היקר, מדוע אתה יושב בפינה? עליך לשבת במקום נכבד יותר!‘ וכך תכובד לעיני כל האורחים. ");
INSERT INTO heblb_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","כי מי שמכבד את עצמו יושפל ומי שמשפיל את עצמו יכובד.“ ");
INSERT INTO heblb_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","לאחר מכן פנה ישוע אל מארחו ואמר: ”כשאתה עורך סעודה אל תזמין את חבריך, אחיך, קרוביך או שכניך העשירים, כי יש להניח שהם יזמינו אותך לסעוד בביתם, וכך תקבל את גמולך המלא. ");
INSERT INTO heblb_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","הזמן במקומם את העניים, הצולעים, בעלי המום והעיוורים. ");
INSERT INTO heblb_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","אמנם אין באפשרותם להשיב לך כגמולך, אך בתחיית המתים אלוהים עצמו ישלם ויגמול לך ולכל עושה טוב.“ ");
INSERT INTO heblb_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","אחד מהמסובים, שהקשיב בתשומת לב לדברי ישוע, קרא: ”זכות גדולה היא להשתתף בסעודת מלכות האלוהים!“ ");
INSERT INTO heblb_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","ישוע ענה לו במשל: ”איש אחד ערך סעודה גדולה והזמין אורחים רבים. ");
INSERT INTO heblb_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","כאשר הושלמו ההכנות שלח את עבדו להודיע למוזמנים שהסעודה מוכנה. ");
INSERT INTO heblb_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","אך כל אחד מהמוזמנים מצא תירוץ וסיבה שלא לבוא. האחד אמר: ’אני באמת מצטער שאיני יכול לבוא, זה עתה קניתי חלקת אדמה ואני מוכרח ללכת לבדוק אותה‘. ");
INSERT INTO heblb_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","השני אמר: ’הבוקר קניתי חמישה צמדי שוורים, ואני מוכרח ללכת לראות איך הם עובדים, קבל בבקשה את התנצלותי‘. ");
INSERT INTO heblb_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","השלישי בדיוק נשא אישה, ולכן לא השתתף בסעודה. ");
INSERT INTO heblb_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","”העבד חזר אל אדוניו ומסר לו את דברי המוזמנים השונים. אדוניו התרגז מאוד וביקש מהעבד למהר אל הרחובות ואל הסמטאות ולהזמין את העניים, בעלי המום, העיוורים והפיסחים. ");
INSERT INTO heblb_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","העבד מילא את רצון אדוניו, אך עדיין היה מקום לאורחים נוספים. ");
INSERT INTO heblb_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","” ’לך אל הסמטאות, אל השבילים ואל מקומות־מחבוא‘, אמר בעל הבית לעבדו, ’והפצר בקבצנים ובנוודים לבוא לסעודה, כדי שהבית יתמלא עד אפס מקום. ");
INSERT INTO heblb_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","איש מהמוזמנים הראשונים לא יטעם מהסעודה שלי!‘ “ ");
INSERT INTO heblb_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","כשהלך אחריו קהל גדול, פנה ישוע לאחור ודיבר אל האנשים: ");
INSERT INTO heblb_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","”מי שרוצה ללכת בעקבותיי עליו לאהוב אותי יותר מאשר את אביו, אמו, אשתו, ילדיו, אחיו ואחיותיו – אפילו יותר מחייו – אחרת לא יוכל להיות תלמיד שלי. ");
INSERT INTO heblb_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","מי שאינו נושא את צלבו ואינו בא אחרי איננו יכול להיות תלמידי. ");
INSERT INTO heblb_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","עליכם לחשוב ולשקול היטב לפני שאתם מחליטים ללכת אחרי. אם ברצונך לבנות בית, האם לא תשב תחילה ותחשב את המחיר, כדי לראות אם יש באפשרותך להשלים את הבנייה? ");
INSERT INTO heblb_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","אם לא תחשב את המחיר תיווכח, לאחר שתניח את היסודות, שאין לך מספיק כסף ולא תוכל להשלים את הבניין. כל מי שיראה את המבנה הלא־גמור ילעג לך ויאמר: ");
INSERT INTO heblb_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","’האיש הזה התחיל לבנות בית, אבל הפסיק באמצע משום שלא היה מספיק כסף!‘ ");
INSERT INTO heblb_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","”או איזה מלך יאיים במלחמה נגד מלך אחר, לפני שיישב תחילה וישקול בכובד ראש אם צבאו המונה 10,000 חיילים, מסוגל להביס את 20,000 חיילי האויב? ");
INSERT INTO heblb_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","אם יגיע למסקנה שאין לו סיכוי לנצח הוא ישלח אל יריבו שליחים, לפני שיהיה מאוחר מדי, ויבקש לערוך משא ומתן לשלום. ");
INSERT INTO heblb_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","גם אתם צריכים לחשוב ולשקול היטב לפני שאתם מחליטים ללכת אחרי. מי שאינו מוכן לוותר על כל רכושו למעני לא יוכל להיות תלמידי. ");
INSERT INTO heblb_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","”מלח הוא דבר מועיל, אבל אם הוא מאבד את מליחותו, כיצד ניתן להשיב לו את טעמו? ");
INSERT INTO heblb_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","מלח חסר־טעם אינו מביא כל תועלת – אי־אפשר להשתמש בו אפילו כדשן. מי שמסוגל לשמוע שיקשיב.“ ");
INSERT INTO heblb_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","לעיתים קרובות התקבצו סביב ישוע פושעים למיניהם ופקידי מכס (שבזמנו היו ידועים לשמצה בגלל חוסר הגינות ושחיתות), על מנת להקשיב לדבריו. ");
INSERT INTO heblb_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","הדבר לא מצא־חן בעיני הסופרים והפרושים שהתלוננו: ”הביטו בישוע, הוא מתחבר עם הפושעים האלה ואף אוכל בחברתם!“ ");
INSERT INTO heblb_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","ישוע ענה להם במשל: ");
INSERT INTO heblb_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","”אילו היו לך מאה כבשים ואחת מהן הייתה הולכת לאיבוד, האם לא היית נוטש את תשעים־ותשע הכבשים, והולך לחפש את הכבשה האחת עד שתמצא אותה? ");
INSERT INTO heblb_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","וכשתמצא אותה, האם לא תשא אותה בשמחה על כתפיך, ");
INSERT INTO heblb_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ובהגיעך הביתה, האם לא תקרא לכל השכנים והחברים ותשתף אותם בשמחה שבמציאת הכבשה האובדת? ");
INSERT INTO heblb_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","”אני אומר לכם שכך יהיה גם בשמים: השמחה על חוטא אחד החוזר בתשובה תהיה גדולה הרבה יותר מאשר על תשעים ותשעה הצדיקים שאינם צריכים לחזור בתשובה.“ ");
INSERT INTO heblb_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","ישוע המשיך: ”אתן לכם דוגמה נוספת: נניח שלאישה אחת היו עשרה מטבעות כסף ומטבע אחד אבד לה. האם היא לא תדליק אור בכל הבית, תטאטא את הרצפה ותחפש בכל פינה עד שתמצא את המטבע? ");
INSERT INTO heblb_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","ולאחר שתמצא את המטבע, האם היא לא תרוץ לשכנותיה ולחברותיה, ותספר להן בשמחה שמצאה את המטבע? ");
INSERT INTO heblb_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","כך גם מלאכי אלוהים שמחים על חוטא אחד שחוזר בתשובה.“ ");
INSERT INTO heblb_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","ישוע סיפר להם משל אחר: ”לאיש אחד היו שני בנים. ");
INSERT INTO heblb_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","יום אחד בא אליו הבן הצעיר ואמר: ’אבא, אני רוצה שתתן לי עכשיו את חלקי בירושה המגיעה לי, במקום שאחכה עד מותך‘. האב הסכים וחילק את רכושו בין שני בניו. ");
INSERT INTO heblb_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","”לאחר זמן קצר ארז הבן הצעיר את חפציו ונסע לארץ רחוקה, שם בזבז את כל כספו בחיי הוללות. ");
INSERT INTO heblb_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","כאשר נותר חסר פרוטה התפשט רעב נורא באותה ארץ, והוא נהיה רעב ללחם. ");
INSERT INTO heblb_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","הוא הלך אל איכר מקומי ושידל אותו להעסיקו כרועה חזירים. ");
INSERT INTO heblb_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","הרעב היה חזק כל־כך, עד כי חשק חרובים שניתנו לחזירים, אולם הוא לא קיבל דבר. ");
INSERT INTO heblb_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","כשלבסוף עשה חשבון נפש ואמר לעצמו: ’בבית אבי לא רק שהפועלים אוכלים לשובע, הם אף משאירים אוכל בצלחת, ואילו אני כאן גווע ברעב! ");
INSERT INTO heblb_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","אשוב לבית אבי ואומר: ”אבא, חטאתי לאלוהים ולך, ");
INSERT INTO heblb_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","ואיני ראוי להיקרא בנך. אנא, קבל אותי לעבודה כאחד מפועליך“‘. ");
INSERT INTO heblb_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","”הבן קם וחזר לבית אביו. עוד לפני שהגיע אל הבית אביו זיהה אותו מרחוק ורץ לקראתו בהתרגשות רבה, חיבק ונישק אותו באהבה. ");
INSERT INTO heblb_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","” ’אבא‘, פתח הבן, ’חטאתי לאלוהים ולך, ואיני ראוי להיקרא בנך‘. ");
INSERT INTO heblb_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","”אולם האב קרא למשרתיו ואמר: ’הביאו מיד את הגלימה היקרה ביותר שיש לנו, טבעת יקרה ונעלים יקרות. ");
INSERT INTO heblb_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","לאחר מכן שחטו את העגל שפיטמנו; עלינו לחגוג את המאורע! ");
INSERT INTO heblb_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","כי בני היה מת ועתה קם לתחייה‘. וכך החלו בחגיגה. ");
INSERT INTO heblb_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","”באותה שעה עבד הבן הבכור בשדה. בשובו הביתה שמע את כל השירה והריקודים, ");
INSERT INTO heblb_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","ולכן שאל את אחד המשרתים: ’מה קורה כאן?‘ ");
INSERT INTO heblb_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","” ’אחיך חזר הביתה‘, הסביר לו המשרת, ’ואביך שחט לכבודו את העגל שפיטמנו. עתה הוא עורך חגיגה גדולה לרגל שובו הביתה בשלום‘. ");
INSERT INTO heblb_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","”הבן הבכור כעס מאוד וסרב להיכנס הביתה. אביו יצא אליו וניסה לדבר איתו, ");
INSERT INTO heblb_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","אבל הבן השיב: ’כל השנים האלה עבדתי קשה כל כך למענך ומעולם לא חטאתי נגדך, ומה נתת לי? לא נתת לי אף גדי אחד קטן כדי שאחגוג עם חברי. ");
INSERT INTO heblb_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","ואילו כשבנך זה, שבזבז את כל כספך על זונות, חוזר הביתה, אתה שוחט לכבודו את העגל המשובח ביותר שיש לנו!‘ ");
INSERT INTO heblb_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","” ’בני היקר‘, אמר האב, ’אתה ואני קרובים זה אל זה, וכל מה ששייך לי שייך לך. ");
INSERT INTO heblb_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","כיצד יכולים אנחנו שלא לשמוח היום? אחיך היה מת ועכשיו הוא קם לתחייה; אחיך הלך לאיבוד ועתה הוא נמצא!‘ “ ");
INSERT INTO heblb_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","ישוע סיפר לתלמידיו את המשל הבא: ”לעשיר אחד היה עובד שניהל את הונו. יום אחד הגיעו שמועות לאוזני העשיר שמנהל עסקיו בוגד בו ומבזבז את רכושו וכספו. ");
INSERT INTO heblb_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","”קרא אליו העשיר את המנהל ואמר: ’שמעתי שאתה מרמה אותי ומועל באמוני. הכן לי דו״ח על מצב העסקים, משום שאני עומד לפטר אותך‘. ");
INSERT INTO heblb_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","”מנהל העסקים חשב לעצמו: ’מה אעשה לאחר שמעבידי יפטר אותי? אין לי כוח לעבוד עבודה פיזית, ואילו לבקש נדבות זה לא בכבוד שלי. ");
INSERT INTO heblb_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","יש לי רעיון! אני יודע מה אעשה כדי שאנשים יאספו אותי אל בתיהם לאחר שיפטרו אותי‘. ");
INSERT INTO heblb_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","”הוא הזמין אליו כל אחד מהאנשים שהיו חייבים כסף לאדוניו. ’כמה אתה חייב לאדוני?‘ שאל את הראשון. ");
INSERT INTO heblb_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","’מאה חביות שמן‘, ענה בעל החוב. ’נכון. קח את שטר־החוב שלך, קרע אותו וכתוב שטר חדש על חמישים חביות בלבד!‘ ");
INSERT INTO heblb_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","” ’וכמה אתה חייב לאדוני?‘ שאל מנהל העסקים את בעל החוב הבא. ’מאה שקי חיטה‘, השיב האיש. אמר לו מנהל העסקים: ’קח את השטר הזה וכתוב במקומו שטר התחייבות על שמונים שקים בלבד‘. ");
INSERT INTO heblb_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","”האיש העשיר התפעל מעורמתו של המנהל שלו, שהרי בני העולם הזה יותר פיקחים מבני האור. ");
INSERT INTO heblb_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","מוסר ההשכל הוא זה: השתמשו במשאבים החומריים שלכם כדי לעזור לאחרים ולהשקיע במערכות יחסים. כי כאשר רכושכם בעולם הזה יאזל לכם, חבריכם יקבלו אתכם בשמחה לביתכם הנצחי. ");
INSERT INTO heblb_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","”מי שמרמה בדבר פעוט ירמה בדבר גדול. מי שמוכיח את יושרו ונאמנותו בדבר פעוט יהיה ישר ונאמן גם בדברים גדולים. ");
INSERT INTO heblb_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","ואם אי־אפשר לסמוך עליכם ולהפקיד בידיכם עושר הבא מן העולם הזה, מי יפקיד בידיכם את העושר האמיתי הבא מן השמים? ");
INSERT INTO heblb_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","ואם אי־אפשר לסמוך עליכם במה שנוגע לרכושם של אחרים, מי ייתן לכם רכוש משלכם? ");
INSERT INTO heblb_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","”אינך יכול לשרת שני אדונים; אתה תשנא את האחד ותאהב את האחר, או להיפך – תהיה נאמן לאחד ותזלזל באחר. אינך יכול לעבוד את האלוהים ואת הכסף!“ ");
INSERT INTO heblb_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","הפרושים אהבו מאוד את כספם ולכן לעגו לישוע. ");
INSERT INTO heblb_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","אולם ישוע אמר להם: ”בפני הציבור אתם מעמידים פני צדיקים תמימים, אבל אלוהים יודע היטב מה מתרחש בלבכם. העמדת הפנים שלכם רכשה לכם כבוד בעיני בני־אדם, אולם היא שנואה ומתועבת בעיני אלוהים. ");
INSERT INTO heblb_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","”התורה והנביאים התבשרו עד ימי יוחנן המטביל. מאז, בשורת מלכות האלוהים מוכרזת ואנשים מתאמצים להיכנס אליה. ");
INSERT INTO heblb_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","אולם נקל יותר שהשמים והארץ ייעלמו מאשר שפרט קטן בתורה יאבד מאמיתותו. ");
INSERT INTO heblb_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","”איש שמגרש את אשתו ומתחתן עם אחרת הוא נואף. גם מי שמתחתן עם גרושה הוא נואף.“ ");
INSERT INTO heblb_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","”פעם היה איש עשיר,“ סיפר ישוע, ”שהתלבש בצורה מפוארת ובילה את ימיו בעונג, בשחצנות ובבזבוז. ");
INSERT INTO heblb_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","בשער ביתו המפואר שכב קבצן אחד שהיה מכוסה כולו פצעים. ’אלעזר‘ קראו לו. ");
INSERT INTO heblb_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","הוא השתוקק להשביע את רעבונו מהפירורים שנפלו משולחנו של העשיר, והכלבים היו באים ומלקקים את פצעיו. ");
INSERT INTO heblb_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","יום אחד מת אלעזר הקבצן, והמלאכים נשאוהו אל חיק אברהם אבינו. כעבור זמן־מה מת גם העשיר, ");
INSERT INTO heblb_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","אולם הוא נלקח אל הגיהינום, שם התענה עינויים גדולים. כשהרים את ראשו בכאב, ראה מרחוק את אלעזר בחיקו של אברהם. ");
INSERT INTO heblb_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","” ’אברהם, אבי‘, קרא העשיר, ’אנא, רחם עלי. שלח אלי את אלעזר כדי שיטבול את אצבעו במים ויקרר את לשוני, כי אני מתענה באש הנוראה הזאת‘. ");
INSERT INTO heblb_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","”אולם אברהם ענה לו: ’בני, אל תשכח שנהנית בחייך מכל טוב, ואילו אלעזר סבל עוני וחולי. עכשיו התהפך הגלגל – אלעזר מנוחם ואילו אתה מתענה. ");
INSERT INTO heblb_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","מלבד זאת, תהום גדולה מפרידה בינינו. איש מאיתנו אינו יכול לעבור אליכם ואיש מכם אינו יכול לעבור אלינו‘. ");
INSERT INTO heblb_vpl VALUES ("LK16_27‏","072_16_27‏","LUK","16","27‏","28","” ’אם כך, אבי‘ התחנן העשיר, ’עשה לי טובה; שלח בבקשה את אלעזר אל בית אבי, כדי שיזהיר את חמשת אחי מפני המקום הנורא הזה‘. ");
INSERT INTO heblb_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","”אולם אברהם השיב לו: ’כתבי־הקודש הזהירו את אחיך פעמים רבות. אחיך יכולים לקרוא את דברי משה והנביאים בכל עת שירצו‘. ");
INSERT INTO heblb_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","” ’אני מכיר אותם היטב‘, אמר לו העשיר. ’הם לא יטרחו לקרוא את דברי הנביאים. אבל אם יבוא אליהם מישהו מן המתים הם יחזרו בתשובה‘. ");
INSERT INTO heblb_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","”אך אברהם השיב: ’אם הם לא הקשיבו למשה ולנביאים, הם לא יקשיבו גם למי שיקום מן המתים‘. “ ");
INSERT INTO heblb_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","”אין ספק שתיתקלו בפיתויים לחטוא ותועמדו בניסיון,“ אמר ישוע לתלמידיו, ”אבל אוי לאדם שדרכו אלה יבואו! ");
INSERT INTO heblb_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","לאדם כזה מוטב יהיה אם יקשרו אבן כבדה לצווארו ויטביעו אותו בים, מאשר שישא בעונש החמור המצפה למכשילים את המאמינים הצעירים. ");
INSERT INTO heblb_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","היזהרו לכם. ”אם חטא לך אחיך – הוכח אותו, ואם הוא מצטער ומבקש את סליחתך – סלח לו. ");
INSERT INTO heblb_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","גם אם הוא חטא לך שבע פעמים ביום אחד, אבל ביקש את סליחתך בכל פעם, עליך לסלוח לו.“ ");
INSERT INTO heblb_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","ביקשו השליחים מהאדון: ”הגדל את אמונתנו!“ ");
INSERT INTO heblb_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","”אפילו הייתה אמונתכם כגרגר צמח החרדל,“ השיב ישוע, ”הייתם אומרים לעץ הגדול הזה להיעקר ממקומו ולהתגלגל לים, והיה נשמע לכם! ");
INSERT INTO heblb_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","”נניח שיש לך עבד החורש בשדה או רועה את הצאן. בשובו הביתה מן השדה האם תאמר לו: ’שב, נח ואכול את ארוחת־הערב שלך?‘ ");
INSERT INTO heblb_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","ודאי שלא. הרי תאמר לו: ’הכן לי את ארוחתי, אחר כך חגור סינר והיה מוכן להגיש לי את מה שאבקש. לאחר שאגמור לאכול תוכל ללכת לאכול את ארוחתך‘. ");
INSERT INTO heblb_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","העבד אינו מצפה לתודה, מפני שעשה את המוטל עליו. ");
INSERT INTO heblb_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","”כך התנהגו גם אתם – אל תצפו לשבחים כשאתם מקיימים את מצוותי, כי אתם רק ממלאים את חובתכם.“ ");
INSERT INTO heblb_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","בדרכו לירושלים יצא ישוע מגבול הגליל ונכנס אל אזור השומרון. ");
INSERT INTO heblb_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","בבואו אל אחד הכפרים ראה עשרה מצורעים עומדים במרחק מה ");
INSERT INTO heblb_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","וקוראים בתחינה: ”ישוע רבנו, רחם עלינו!“ ");
INSERT INTO heblb_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","ישוע הביט בהם ואמר: ”לכו אל הכהן והראו לו שנרפאתם!“ בהיותם בדרך הם נרפאו. ");
INSERT INTO heblb_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","אחד הנרפאים חזר אל ישוע וקרא בשמחה ובצהלה: ”הללויה, אני בריא!“ ");
INSERT INTO heblb_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","האיש, שהיה שומרוני, נפל על פניו לרגלי ישוע והודה לו מעומק לבו על שריפא אותו. ");
INSERT INTO heblb_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","”האם לא ריפאתי עשרה אנשים?“ שאל ישוע. ”היכן תשעת האחרים? ");
INSERT INTO heblb_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","האם רק השומרוני הזה חזר כדי להודות לאלוהים?“ ");
INSERT INTO heblb_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","”קום ולך, אמונתך ריפאה אותך“, אמר ישוע לאיש. ");
INSERT INTO heblb_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","יום אחד שאלו הפרושים את ישוע: ”מתי תבוא מלכות האלוהים?“ ”מלכות האלוהים לא תבוא בצורה גלויה“, השיב ישוע. ");
INSERT INTO heblb_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","”לא תוכלו לומר: ’מלכות האלוהים כאן‘, או ’מלכות האלוהים שם‘. כי מלכות האלוהים היא בקרבכם.“ ");
INSERT INTO heblb_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","ישוע פנה אל תלמידיו ואמר: ”יבוא הזמן שתשתוקקו כל־כך שאחזור אליכם, ולו גם ליום אחד בלבד, אך משאלתכם לא תתמלא. ");
INSERT INTO heblb_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","”אם מישהו יאמר לכם: ’ראיתי את המשיח במקום פלוני!‘ אל תאמינו לו ואל תלכו לחפש אותי. ");
INSERT INTO heblb_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","כי כשיבוא בן־האדם באמת, תדעו זאת ללא כל ספק; בואו ייראה לעין כברק המאיר את השמים מקצה לקצה. ");
INSERT INTO heblb_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","אבל לפני כן עליו לסבול הרבה ולהידחות על־ידי הדור הזה. ");
INSERT INTO heblb_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","”בימי בן־האדם יתנהלו החיים כבימי נוח. ");
INSERT INTO heblb_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","בני־האדם אכלו, שתו והתחתנו – הכול התנהל כרגיל עד היום שבו נכנס נוח לתיבה, ואז בא המבול והשמיד את כולם. ");
INSERT INTO heblb_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","”גם בימיו של לוט היה המצב דומה: האנשים אכלו, שתו, קנו, מכרו, נטעו ובנו. ");
INSERT INTO heblb_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","אולם ביום שעזב לוט את סדום המטיר אלוהים אש וגפרית על העיר, והשמיד את כולם. ");
INSERT INTO heblb_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","כך יהיה המצב ביום שובי. ");
INSERT INTO heblb_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","”אם תהיה מחוץ לבית ביום ההוא – אל תחזור לארוז את חפציך; אם תהיה בשדה – אל תחזור העירה. ");
INSERT INTO heblb_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","זכרו מה קרה לאשת לוט! ");
INSERT INTO heblb_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","מי שמנסה להציל את חייו יאבד אותם; מי שיוותר על חייו יציל אותם. ");
INSERT INTO heblb_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","בלילה ההוא שני אנשים יישנו באותו חדר: האחד יילקח והשני יישאר. ");
INSERT INTO heblb_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","שתי נשים יטחנו יחד: האחת תילקח וחברתה תישאר. ");
INSERT INTO heblb_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","שני גברים יעבדו בשדה: האחד יילקח וחברו יישאר.“ ");
INSERT INTO heblb_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","”אדון, לאן הם יילקחו?“ שאלו התלמידים. ”במקום שבו נמצא הפגר, שם יתאספו הנשרים“, השיב ישוע. ");
INSERT INTO heblb_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","ישוע סיפר לתלמידיו משל, כדי להדגיש לפניהם את הצורך להתפלל תמיד ולא לוותר. ");
INSERT INTO heblb_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","”בעיר אחת היה שופט,“ פתח ישוע, ”אשר לא כיבד את אלוהים ולא ירא מפניו, ואף לא חיבב את העם. ");
INSERT INTO heblb_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","”באותה עיר גרה אישה אלמנה, אשר באה אל השופט לעיתים קרובות והתחננה לפניו שישפוט בצדק בינה לבין יריבה המתנכל לה. ");
INSERT INTO heblb_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","זמן מה התעלם השופט מבקשתה עד שנמאסה עליו, ואמר בלבו: ’אמנם איני ירא את אלוהים ואף איני מכבד את בני האדם, ");
INSERT INTO heblb_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","אולם מוטב שאצדיק את האישה הזאת במשפטה, שאם לא כן היא תמשיך להטריד אותי ולא תעזוב אותי במנוחה‘. “ ");
INSERT INTO heblb_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","האדון המשיך: ”שמעו מה שאומר השופט הרשע. אם אפילו שופט רשע זה נענה לתחינות האישה, ");
INSERT INTO heblb_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","האם אינכם חושבים שאלוהים ישפוט בצדק את בניו המתפללים אליו יומם ולילה? האם יתמהמה בעניינם? ");
INSERT INTO heblb_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","אלוהים יענה לתפילתם במהרה ויוציא את הצדק לאור. אולם כשבן־האדם יחזור, האם ימצא אמונה בארץ?“ ");
INSERT INTO heblb_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","ישוע סיפר משל נוסף. הפעם היה המשל מכוון אל הגאוותנים החושבים את עצמם לצדיקים גמורים ומזלזלים באחרים: ");
INSERT INTO heblb_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","”שני אנשים באו להתפלל בבית־המקדש. האחד היה פרוש גאה וצדיק בעיני עצמו, והשני היה גובה מכס רמאי. ");
INSERT INTO heblb_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","הפרוש הגאה התפלל כך: ’אני מודה לך אלוהים על שאיני חוטא ככל האחרים, ובמיוחד שאיני חוטא כמו גובה־המכס הזה העומד כאן במקדש. מעולם לא רימיתי, לא עשקתי ולא נאפתי. ");
INSERT INTO heblb_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","אני צם פעמיים בשבוע ונותן לך, אלוהים, מעשר מכל רווחי‘. ");
INSERT INTO heblb_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","”לעומתו המוכס הרמאי שעמד במרחק מה, לא העז להרים את עיניו כשהתפלל, אלא הכה על חזהו בחרטה וקרא: ’אלוהים, סלח לי. רחם על חוטא שכמוני‘. ");
INSERT INTO heblb_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","אני אומר לכם, גובה־המכס ההוא הלך לביתו נקי מחטא, ולא כן הפרוש! כי מי שמכבד את עצמו יושפל ומי שמשפיל את עצמו יכובד.“ ");
INSERT INTO heblb_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","יום אחד הביאו כמה אמהות את ילדיהן אל ישוע כדי שיברך אותם, אבל התלמידים לא הניחו להם לגשת אליו. ");
INSERT INTO heblb_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","ישוע קרא אליו את התלמידים ואמר: ”תנו לילדים לבוא אלי ואל תמנעו מהם, כי לכאלה שייכת מלכות האלוהים. ");
INSERT INTO heblb_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","אני אומר לכם: מי שלא מקבל את מלכות האלוהים כמו ילד, לא יוכל להיכנס אליה.“ ");
INSERT INTO heblb_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","איש מכובד אחד שאל את ישוע: ”רבי הטוב, מה עלי לעשות כדי לזכות בחיי נצח?“ ");
INSERT INTO heblb_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","”מדוע אתה קורא לי טוב?“ שאל ישוע. ”רק אלוהים טוב. ");
INSERT INTO heblb_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","אך בתשובה לשאלתך, הרי אתה מכיר את המצוות: לא תרצח, לא תנאף, לא תגנוב, לא תענה ברעך עד שקר, כבד את אביך ואת אמך.“ ");
INSERT INTO heblb_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","”את כל המצוות האלה אני שומר מילדותי“, השיב האיש. ");
INSERT INTO heblb_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","”עליך לעשות עוד דבר אחד“, אמר לו ישוע. ”מכור את כל מה שיש לך ותן את הכסף לעניים – כך תאגור לך אוצר בשמים. אחר כך בוא אחרי.“ ");
INSERT INTO heblb_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","כאשר שמע האיש את דברי ישוע הלך משם בצער רב, כי היה עשיר מאוד. ");
INSERT INTO heblb_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","ישוע ליווה בעיניו את האיש ואמר לתלמידיו: ”לאדם עשיר קשה מאוד להיכנס למלכות האלוהים. ");
INSERT INTO heblb_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","קל יותר לגמל לעבור דרך חור המחט מאשר לאיש עשיר להיכנס למלכות האלוהים.“ ");
INSERT INTO heblb_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","”אם כל־כך קשה להיכנס למלכות האלוהים, מי, אם כן, יוכל להיוושע?“ שאלו השומעים. ");
INSERT INTO heblb_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","השיב להם ישוע: ”אלוהים יכול לעשות את מה שבני־האדם אינם יכולים!“ ");
INSERT INTO heblb_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","”אנחנו עזבנו הכול והלכנו אחריך!“ אמר פטרוס לישוע. ");
INSERT INTO heblb_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","”כן,“ השיב ישוע, ”וכל מי שעזב את ביתו, אשתו, אחיו, הוריו או ילדיו למען מלכות האלוהים, ");
INSERT INTO heblb_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","יקבל בתמורה כפל כפליים בעולם הזה וחיי נצח בעולם הבא.“ ");
INSERT INTO heblb_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","ישוע קיבץ סביבו את שנים־עשר תלמידיו ואמר: ”כידוע לכם אנחנו הולכים עכשיו לירושלים. כשנגיע לשם יתקיים כל מה שהנביאים אמרו על בן־האדם. ");
INSERT INTO heblb_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","ימסרו אותו לידי הגויים אשר יתעללו בו, ילעגו לו, ירקו בפניו, ");
INSERT INTO heblb_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","יצליפו עליו בשוטים וימיתו אותו; אבל ביום השלישי יקום לתחייה.“ ");
INSERT INTO heblb_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","התלמידים לא הבינו את דבריו שהיו סתומים עבורם. ");
INSERT INTO heblb_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","בהתקרבם ליריחו ישב עיוור אחד בצד הדרך וקיבץ נדבות. ");
INSERT INTO heblb_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","קולות האנשים הרבים שעברו על פניו עוררו את סקרנותו, ולכן שאל: ”מה מתרחש כאן?“ ");
INSERT INTO heblb_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","”ישוע מנצרת עובר לפניך!“ השיבו לו. ");
INSERT INTO heblb_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","מששמע זאת העיוור החל לצעוק: ”ישוע בן־דוד, רחם עלי!“ ");
INSERT INTO heblb_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","האנשים שהלכו לפני ישוע גערו בעיוור וניסו להשתיקו, אך ללא הצלחה. צעקותיו הלכו וגברו: ”בן־דוד, רחם עלי!“ ");
INSERT INTO heblb_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","קריאותיו הנואשות של העיוור הגיעו לאוזניו של ישוע והוא עצר. ”הביאו אלי את האיש“, ציווה ישוע. כשהתקרב אליו העיוור שאל אותו ישוע: ");
INSERT INTO heblb_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","”מה אתה רוצה שאעשה למענך?“ ”אדוני, אני רוצה לראות!“ התחנן העיוור. ");
INSERT INTO heblb_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","”ראייתך ניתנה לך!“ השיב ישוע. ”אמונתך ריפאה אותך.“ ");
INSERT INTO heblb_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","מיד שבה אליו ראייתו והוא הלך אחרי ישוע, מהלל ומשבח את האלוהים. גם שאר האנשים שראו את הפלא הללו ושיבחו את האלוהים. ");
INSERT INTO heblb_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","ישוע הגיע ליריחו ועבר ברחובות העיר. ");
INSERT INTO heblb_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","אדם אחד בשם זכי, אשר היה מנהל בכיר ברשויות המכס, בעל השפעה וכמובן עשיר גדול, ");
INSERT INTO heblb_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","רצה לראות את פניו של ישוע. אבל זכי היה נמוך־קומה, והקהל הרב הסתיר ממנו את ישוע. ");
INSERT INTO heblb_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","זכי רץ לפני הקהל הרב וטיפס על עץ שיקמה בצד הדרך על מנת שיוכל להתבונן בישוע ללא הפרעה. ");
INSERT INTO heblb_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","כאשר עבר ישוע ליד העץ, הרים את עיניו והביט בזכי. ”זכי,“ קרא לו ישוע בשמו, ”רד מהר מהעץ, כי היום עלי להתארח בביתך.“ ");
INSERT INTO heblb_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","זכי מיהר לרדת מהעץ וקיבל את פניו של ישוע בשמחה ובששון. ");
INSERT INTO heblb_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","הדבר לא מצא־חן בעיני הקהל. ”ישוע עומד להתארח בביתו של חוטא ידוע!“ רטנו. ");
INSERT INTO heblb_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","אולם זכי עמד לפני האדון ואמר: ”אדוני, מהיום והלאה אתן את מחצית רכושי לעניים וכל מי שלקחתי ממנו כסף במרמה, אחזיר לו פי הארבע!“ ");
INSERT INTO heblb_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","”היום באה ישועה לבית הזה!“ קרא ישוע. ”כי זכי הוא בן־אברהם. ");
INSERT INTO heblb_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","ואכן בן־האדם בא לחפש ולהושיע את האובדים.“ ");
INSERT INTO heblb_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","כשהתקרבו לירושלים, ישוע סיפר לתלמידיו משל, כדי לתקן את הרושם המוטעה שהיה להם שמלכות האלוהים עומדת לבוא בכל רגע. ");
INSERT INTO heblb_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","”אציל אחד נקרא לארץ רחוקה כדי לקבל את כתר המלוכה על מחוז מגוריו. ");
INSERT INTO heblb_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","לפני צאתו לדרך קרא לעשרה ממשרתיו, נתן לכל אחד מהם מטבע זהב ואמר: ’השקיעו את הכסף וסחרו בו עד שאחזור‘. ");
INSERT INTO heblb_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","רבים מבני ארצו של המלך המיועד שנאו אותו, ואף שלחו בעקבותיו משלחת שהודיעה לו: ’איננו רוצים שתמלוך עלינו!‘ “ ");
INSERT INTO heblb_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","”מחאתם לא הועילה, והאציל הוכתר למלך. כשחזר המלך לביתו קרא אליו את עשרת המשרתים, ושאל אותם מה עשו בכסף שנתן להם וכמה הרוויחו. ");
INSERT INTO heblb_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","המשרת הראשון בא ואמר: ’אדוני, ממטבע הזהב שנתת לי הרווחתי עשרה מטבעות זהב‘. ");
INSERT INTO heblb_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","” ’יפה מאוד, משרתי הטוב!‘ שיבח אותו המלך. ’מאחר שהוכחת את נאמנותך במעט שהפקדתי בידך, אני ממנה אותך שליט על עשר ערים‘. ");
INSERT INTO heblb_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","”גם המשרת השני דיווח על רווח, פי חמישה ממה שקיבל. ");
INSERT INTO heblb_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","” ’אותך אני ממנה שליט על חמש ערים‘, אמר לו המלך. ");
INSERT INTO heblb_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","אחר כך בא המשרת השלישי ואמר: ’אדוני, הנה המטבע שנתת לי; שמרתי אותו במטפחת ולא נגעתי בו. ");
INSERT INTO heblb_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","כי פחדתי ממך, מפני שאתה איש קשה; אתה לוקח מה שלא שייך לך וקוצר את מה שלא זרעת‘. ");
INSERT INTO heblb_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","” ’רשע שכמוך!‘ קרא המלך בזעם. ’איש קשה אני? מיד אראה לך כמה קשה אני יכול להיות! אם ידעת שאני לוקח מה שלא שייך לי וקוצר את מה שלא זרעתי, ");
INSERT INTO heblb_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","מדוע לא הפקדת את הכסף בבנק? כך לפחות הייתי מקבל ריבית!‘ ");
INSERT INTO heblb_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","”המלך פנה אל העומדים סביבו ופקד: ’קחו ממנו את המטבע ותנו לאיש שהרוויח את הסכום הגדול ביותר!‘ ");
INSERT INTO heblb_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","” ’אבל, אדון‘, אמרו במחאה, ’יש לו מספיק!‘ ");
INSERT INTO heblb_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","’נכון‘, השיב המלך. ’אני אומר לכם, מי שיש לו – יינתן לו עוד; מי שאין לו – גם המעט שבידו יילקח ממנו. ");
INSERT INTO heblb_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","ובנוגע לאויבי אשר לא רצו שאמלוך עליהם – הביאו אותם הנה והוציאו אותם להורג לפני‘.“ ");
INSERT INTO heblb_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","ישוע סיים את דבריו והמשיך בדרכו לעלות לירושלים עם תלמידיו. ");
INSERT INTO heblb_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","בהתקרבם אל בית־פגי ובית־עניה שעל הר הזיתים, קרא אליו ישוע שנים מתלמידיו ואמר: ");
INSERT INTO heblb_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","”לכו אל הכפר ממול, ובכניסה תראו עיר קשור שאיש עדיין לא רכב עליו. התירו את העיר והביאו אותו אלי. ");
INSERT INTO heblb_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","אם מישהו ישאל אתכם מה אתם עושים, אמרו לו: ’האדון זקוק לעיר‘. “ ");
INSERT INTO heblb_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","שני התלמידים הלכו אל הכפר ומצאו את העיר ממש כפי שאמר להם ישוע. ");
INSERT INTO heblb_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","כשהתירו את העיר בא אליהם בעליו ושאל בתימהון: ”מדוע אתם מתירים את העיר שלי?“ ");
INSERT INTO heblb_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","”האדון זקוק לו“, השיבו התלמידים בפשטות. ");
INSERT INTO heblb_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","הם הביאו את העיר אל ישוע, ריפדו את גבו במעיליהם וישוע רכב עליו. ");
INSERT INTO heblb_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","אנשים רבים פרשו את מעיליהם וגלימותיהם על השביל לפניו. ");
INSERT INTO heblb_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","כשהתקרב ישוע לראש השביל היורד מהר הזיתים, החלה חבורת תלמידיו לשיר ולשבח את אלוהים בקולי קולות על כל הנסים והנפלאות שחולל ישוע. ");
INSERT INTO heblb_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","”ברוך הבא בשם ה׳!“ צהל ההמון. ”יחי המלך! שמחו השמים והארץ! שבח ותהילה לאלוהים במרומים!“ ");
INSERT INTO heblb_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","פרושים אחדים שהיו בקרב הקהל אמרו לישוע: ”רבי, נזוף בתלמידיך על הדברים שהם אומרים!“ ");
INSERT INTO heblb_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","אך הוא השיב להם: ”אם הם ישתקו האבנים האלה תזעקנה!“ ");
INSERT INTO heblb_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","כאשר התקרב ישוע לירושלים, הביט בה בעצב ובכה עליה. ");
INSERT INTO heblb_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","”הלוואי שידעת גם את כיצד לעשות שלום! אולם הדבר נסתר ממך“, אמר ישוע בצער ובדמעות. ");
INSERT INTO heblb_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","”יבוא היום שאויביך יקימו סוללות חול סביב חומותיך, יקיפו אותך ויצורו עליך מכל עבר. ");
INSERT INTO heblb_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","אויביך יהרסו כליל אותך ואת בניך; הם לא ישאירו אבן אחת במקומה, משום שדחית את הישועה שהציע לך ה׳.“ ");
INSERT INTO heblb_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","לאחר מכן הוא נכנס אל בית־המקדש והחל לגרש משם את הסוחרים ואת הקונים. ");
INSERT INTO heblb_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","”בכתבי־הקודש כתוב: ’ביתי בית־תפלה‘, “ קרא ישוע, ”אבל אתם הפכתם אותו למאורת גנבים!“ ");
INSERT INTO heblb_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","ישוע לימד יום־יום בבית־המקדש. הסופרים, ראשי הכוהנים והזקנים חיפשו דרך להיפטר ממנו, ");
INSERT INTO heblb_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","אך הם לא ידעו מה לעשות, מפני שכל העם אהב אותו והקשיב לדבריו בתשומת לב מרובה. ");
INSERT INTO heblb_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","באחד מאותם ימים, כשלימד ישוע את העם בבית־המקדש וסיפר לו את בשורת ה׳, ניגשו אליו הכוהנים, הסופרים והזקנים ושאלו: ");
INSERT INTO heblb_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","”באיזו רשות אתה עושה את כל הדברים האלה?“ ");
INSERT INTO heblb_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","”אענה לשאלתכם בתנאי שתענו לשאלתי“, השיב להם ישוע. ");
INSERT INTO heblb_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","”האם יוחנן המטביל נשלח על־ידי אלוהים או על־ידי בני־אדם?“ ");
INSERT INTO heblb_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","הם התייעצו ביניהם: ”אם נגיד שאלוהים שלח את יוחנן, ישוע ישאל אותנו מדוע לא האמנו בו. ");
INSERT INTO heblb_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","אבל אם נגיד שאלוהים לא שלח את יוחנן, העם יתנפל עלינו, כי כולם מאמינים שיוחנן היה נביא מאת אלוהים.“ ");
INSERT INTO heblb_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","לבסוף השיבו שאינם יודעים את התשובה. ");
INSERT INTO heblb_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","”אם כן, גם אני לא אשיב לשאלתכם“, אמר ישוע. ");
INSERT INTO heblb_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","ישוע פנה אל העם וסיפר להם את המשל הבא: ”איש אחד נטע כרם ענבים, השכיר אותו לכורמים זרים ונסע לארץ רחוקה לכמה שנים. ");
INSERT INTO heblb_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","בהגיע מועד הבציר שלח בעל הכרם אחד מאנשיו לאסוף את חלקו ביבול הענבים. אבל הכורמים הכו את השליח ושלחו אותו חזרה לאדוניו בידיים ריקות. ");
INSERT INTO heblb_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","בעל הכרם שלח שליח אחר, אולם גורלו היה כגורל קודמו; הכורמים הכו אותו, קיללו אותו ושלחוהו בידיים ריקות. ");
INSERT INTO heblb_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","בעל הכרם שלח אדם שלישי, אבל גם אותו הם פצעו וגירשו משם. ");
INSERT INTO heblb_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","” ’מה אעשה?‘ שאל את עצמו בעל הכרם. ’אולי אם אשלח את בני האהוב הם יפחדו מפניו ויכבדו אותו‘. ");
INSERT INTO heblb_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","אולם כשראו הכורמים את הבן אמרו: ’יש לנו כאן הזדמנות: הבן הזה יירש את הכרם לאחר מות אביו, אולם אם נהרוג אותו נזכה אנחנו בכרם!‘ ");
INSERT INTO heblb_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","והכורמים גירשו את הבן מהכרם והרגו אותו. ”מה לדעתכם יעשה בעל הכרם? ");
INSERT INTO heblb_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","אני אומר לכם, הוא יבוא בעצמו, יהרוג את הכורמים וישכיר את הכרם לאחרים.“ ”חס וחלילה שיעשו כך האנשים!“ קראו השומעים. ");
INSERT INTO heblb_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","ישוע נעץ בהם את מבטו ואמר: ”מה לדעתכם כוונת הפסוק בתהלים: ’אבן מאסו הבונים, הייתה לראש פינה‘?“ ");
INSERT INTO heblb_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","ישוע הוסיף: ”מי שייפול על האבן הזאת יתנפץ לרסיסים, ומי שתיפול עליו האבן ישחק לאבק.“ ");
INSERT INTO heblb_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","הסופרים וראשי הכוהנים הבינו שהם הכורמים הרשעים במשל ורצו לאסור את ישוע, אבל הם פחדו שמא העם יחולל מהומות. ");
INSERT INTO heblb_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","הסופרים וראשי הכוהנים ציפו להזדמנות מתאימה לאסור את ישוע ולמסור אותו לידי השלטונות. יום אחד שלחו אליו מרגלים בדמות אנשים תמימים, כדי שינסו להכשילו בלשונו. ");
INSERT INTO heblb_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","”רבי,“ פתחו מרגלים אלה, ”אנחנו יודעים שאתה איש ישר, ושאיש אינו יכול להשפיע עליך לשקר. אנחנו גם יודעים שאתה באמת מלמד את דבר־אלוהים. ");
INSERT INTO heblb_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","אמור לנו, האם עלינו לשלם מס לקיסר הרומאי או לא?“ ");
INSERT INTO heblb_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","ישוע הבין את מזימתם ולכן ענה: ");
INSERT INTO heblb_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","”תנו לי מטבע ואומר לכם. של מי הדמות החקוקה כאן? ושל מי השם החקוק מתחת לדמות?“ ”של הקיסר“, השיבו. ");
INSERT INTO heblb_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","”אם כן, תנו לקיסר את מה ששייך לו, ותנו לאלוהים את מה ששייך לאלוהים!“ ");
INSERT INTO heblb_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","ניסיונם להכשילו בלשונו לא הצליח. הם התפעלו כל־כך מתשובותיו עד שלא היו מילים בפיהם. ");
INSERT INTO heblb_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","חבורה של צדוקים (שאינם מאמינים בתחיית המתים) באה אל ישוע ושאלה: ");
INSERT INTO heblb_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","”רבי, משה רבנו לימד אותנו בתורה שאם אדם נשוי מת ואינו משאיר אחריו ילדים, חייב אחיו להתחתן עם האלמנה, כדי שתוכל ללדת בן שישא את שם המת. ");
INSERT INTO heblb_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","במשפחה אחת היו שבעה אחים. האח הבכור התחתן וכעבור זמן קצר מת ולא השאיר אחריו בן. ");
INSERT INTO heblb_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","האח השני התחתן עם האלמנה, וגם הוא מת ולא השאיר בן. ");
INSERT INTO heblb_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","כך היה גם עם האח השלישי. בקיצור, כל שבעת האחים התחתנו עם האישה האחת, כולם מתו ולא השאירו אחריהם ילדים. ");
INSERT INTO heblb_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","לבסוף מתה גם האישה. ");
INSERT INTO heblb_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","”רבי, למי תהיה שייכת האישה בתחיית המתים? הלא כל השבעה התחתנו אתה!“ ");
INSERT INTO heblb_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","”נשואין הם רק בשביל האנשים בעולם הזה“, השיב להם ישוע. ");
INSERT INTO heblb_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","”אלה שיזכו לקום מן המתים ולחיות לנצח בעולם הבא, לא יינשאו. ");
INSERT INTO heblb_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","בעולם הבא הם יהיו כמלאכים ושוב לא יכולים למות. הם גם בני־אלוהים, משום שקמו לתחייה. ");
INSERT INTO heblb_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","בנוגע לשאלתכם אם יקומו המתים לתחייה, משה רבנו אשרר בתורה את דבר תחיית המתים. כשתיאר משה כיצד נגלה אליו ה׳ בסנה הבוער, הוא קרא לה׳: ’אלוהי אברהם, אלוהי יצחק ואלוהי יעקב‘. ");
INSERT INTO heblb_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","זה כדי לומר שה׳ הוא אלוהי החיים ולא של המתים, כי בעיני אלוהים האנשים האלה חיים.“ ");
INSERT INTO heblb_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","”יפה ענית, רבי“, שיבחו אותו סופרים אחדים, ");
INSERT INTO heblb_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","ואיש לא העז לשאול אותו שאלות נוספות. ");
INSERT INTO heblb_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","שאל אותם ישוע שאלה: ”מדוע טוענים האנשים שהמשיח הוא בן־דוד? ");
INSERT INTO heblb_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","הלא דוד עצמו אומר בתהלים: ’נאם ה׳ לאדני, שב לימיני ");
INSERT INTO heblb_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","עד אשית אויביך הדם לרגליך‘. ");
INSERT INTO heblb_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","כיצד יכול המשיח להיות בנו של דוד וגם אדוניו?“ ");
INSERT INTO heblb_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","בעוד כל העם מקשיב לו פנה ישוע אל תלמידיו ואמר: ");
INSERT INTO heblb_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","”היזהרו מהסופרים שאוהבים ללבוש גלימות ולהיראות לפני האנשים בשווקים, כדי שכולם ייתנו להם כבוד. הם אוהבים לשבת במושבות הנכבדים בבית־הכנסת ובסעודות וחגיגות. ");
INSERT INTO heblb_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","הם מעמידים פני צדיקים תמימים, ומתפללים בציבור תפילות ארוכות כדי לעשות רושם, אבל באותה עת הם מרמים את האלמנות ומגרשים אותן מבתיהן. משום כך אלוהים ישפוט אותם בחומרה רבה מאוד.“ ");
INSERT INTO heblb_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","ישוע עמד בבית־המקדש והביט בעשירים שמביאים את תרומותיהם אל תיבת האוצר. ");
INSERT INTO heblb_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","בין התורמים הרבים הבחין גם באלמנה עניה שתרמה שתי פרוטות. ");
INSERT INTO heblb_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","”אומר לכם את האמת,“ העיר ישוע, ”האלמנה הענייה הזאת תרמה יותר מכל העשירים האלה גם יחד! ");
INSERT INTO heblb_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","כי העשירים תרמו סכומים קטנים ביחס לרכוש הרב שיש להם, ואילו האלמנה הזאת נתנה את כל מה שהיה לה.“ ");
INSERT INTO heblb_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","אחדים מתלמידיו העירו את תשומת לבו לעבודת האבנים המהודרת של בית־המקדש, ולחפצים היקרים שתרמו האנשים. ");
INSERT INTO heblb_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","”אתם יכולים להתפעל מהמראה בינתיים,“ אמר להם ישוע, ”אולם יבוא היום שהכול ייהרס; אף אבן לא תישאר במקומה.“ ");
INSERT INTO heblb_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","”רבי, מתי יקרה הדבר?“ שאלו התלמידים. ”האם נקבל אזהרה מראש?“ ");
INSERT INTO heblb_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","השיב ישוע: ”אל תניחו לאיש לרמות אתכם. אנשים רבים יבואו ויטענו כי הם המשיח, ויודיעו שהקץ קרוב. אבל אל תאמינו להם. ");
INSERT INTO heblb_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","כאשר תשמעו על מהומות ומלחמות, אל תיבהלו ואל תאבדו את עשתונותיכם. כי אמנם תפרוצנה מלחמות, אבל הקץ לא יבוא מיד. ");
INSERT INTO heblb_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","מדינות וממלכות תילחמנה זו בזו, ");
INSERT INTO heblb_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","בארצות רבות תתחוללנה רעידות אדמה אדירות ומגפות, ויהיה רעב גדול; בשמים ייראו מראות נוראים ואותות גדולים. ");
INSERT INTO heblb_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","”אולם לפני שיתרחשו כל הדברים האלה ירדפו אתכם, ישפטו אתכם בבתי־כנסת, ישליכו אתכם לכלא ויעמידו אתכם לפני מלכים ושליטים למען שמי. ");
INSERT INTO heblb_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","זאת תהיה הזדמנות עבורכם להעיד עלי. ");
INSERT INTO heblb_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","אל תדאגו כיצד תתגוננו בפני האשמותיהם, ");
INSERT INTO heblb_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","כי אשים בפיכם את המילים המתאימות, ואתן לכם חכמה שאויביכם לא יוכלו להתמודד איתה ולסתור אותה. ");
INSERT INTO heblb_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","גם האנשים הקרובים אליכם ביותר – הוריכם, אחיכם, חבריכם וקרובי משפחתכם – יבגדו בכם ויביאו למאסרכם, ויהיו ביניכם כאלה שימותו. ");
INSERT INTO heblb_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","כולם ישנאו אתכם משום שאתם שייכים לי, ");
INSERT INTO heblb_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","אולם אף שערה אחת לא תיפול מראשכם! ");
INSERT INTO heblb_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","בנאמנותכם ובעמידתכם האיתנה תושיעו את נפשותיכם. ");
INSERT INTO heblb_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","”כאשר תראו את ירושלים מוקפת אויבים דעו שחורבנה קרוב. ");
INSERT INTO heblb_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","אז תושבי יהודה יברחו אל ההרים; על תושבי ירושלים להשתדל לברוח מהעיר, ואוי לתושבי הסביבה שינסו להיכנס לירושלים! ");
INSERT INTO heblb_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","יהיו אלה ימי נקם אשר נועדו לקיים את נבואות התנ״ך. ");
INSERT INTO heblb_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","אוי לנשים ההרות ולמניקות באותם ימים, מפני שצרה גדולה תבוא על הארץ, ואלוהים ישפוך את זעמו על העם הזה. ");
INSERT INTO heblb_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","רבים ייהרגו בחרב האויב או יוגלו לכל קצוות תבל, וירושלים תיפול בידי גויים אשר ידכאו אותה עד שתסתיים תקופת שלטון הגויים במועד שקבע ה׳. ");
INSERT INTO heblb_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","”אותות מבשרי רעה יופיעו בשמש, בירח ובכוכבים, ואילו על פני האדמה – עמים שלמים יתייאשו ויפחדו מגעש הים והגלים הסוערים. ");
INSERT INTO heblb_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","אנשים יתעלפו מאימה ופחד מפני המאורעות שיבואו על העולם, משום שכוחות השמים יתמוטטו. ");
INSERT INTO heblb_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","ואז יראו אנשי הארץ את בן־האדם בא בענן, בגבורה ובכבוד רב. ");
INSERT INTO heblb_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","כאשר יתחילו כל הדברים האלה להתרחש, התעודדו והרימו את ראשכם, כי ישועתכם קרובה!“ ");
INSERT INTO heblb_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","אחר כך סיפר להם ישוע את המשל הבא: ”הביטו בעץ התאנה או בכל עץ אחר. ");
INSERT INTO heblb_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","כאשר העץ מלבלב יודעים אתם שקרב הקיץ בלי שיאמרו לכם זאת. ");
INSERT INTO heblb_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","כאשר כל מה שסיפרתי לכם יתחיל להתרחש, דעו לכם שמלכות האלוהים קרובה. ");
INSERT INTO heblb_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","”אני אומר לכם: כל הדברים האלה יתרחשו לפני שיחלוף הדור הזה. ");
INSERT INTO heblb_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","השמים והארץ יחלפו, אבל דברי לא יחלפו. ");
INSERT INTO heblb_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","”היזהרו לכם – אל תאבדו את הראש בשכרות, בבזבזנות, בתענוגות ובדאגות מחייה, פן יבוא עליכם היום ההוא במפתיע, כמלכודת. ");
INSERT INTO heblb_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","היום ההוא יבוא על כל יושבי תבל! ");
INSERT INTO heblb_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","משום כך שימרו תמיד על ערנותכם, והתפללו שאלוהים יעניק לכם כוח לצאת בשלום מכל העתיד להתרחש, ולהתייצב לפני בן־האדם.“ ");
INSERT INTO heblb_vpl VALUES ("LK21_37‏","072_21_37‏","LUK","21","37‏","38","יום־יום הלך ישוע ללמד בבית־המקדש, והעם היה מתאסף בהמונים משעות הבוקר המוקדמות כדי להקשיב לדבריו. בלילות נהג ישוע ללכת לישון על הר הזיתים. ");
INSERT INTO heblb_vpl VALUES ("LK22_1‏","072_22_1‏","LUK","22","1‏","2","בהתקרב חג הפסח חיפשו ראשי הכוהנים והסופרים דרך להיפטר מישוע בלי לעורר מהומות בעם – דבר שפחדו ממנו מאוד. ");
INSERT INTO heblb_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","אז נכנס השטן ביהודה איש קריות, שהיה אחד משנים־עשר תלמידי ישוע. ");
INSERT INTO heblb_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","יהודה הלך אל ראשי הכוהנים ואל מפקדי משמר בית־המקדש כדי להתייעץ איתם כיצד להסגיר את ישוע לידיהם. ");
INSERT INTO heblb_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","ראשי הכוהנים ומפקדי משמר בית־המקדש שמחו מאוד על העזרה שהציע להם יהודה, והבטיחו לו כסף. ");
INSERT INTO heblb_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","מאותה עת חיפש יהודה הזדמנות להסגיר את ישוע לידיהם, כשלא יהיה בחברת אנשים רבים. ");
INSERT INTO heblb_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","בהגיע חג הפסח, ביום שבו מקריבים זבח, ");
INSERT INTO heblb_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","שלח ישוע את פטרוס ויוחנן להכין את הסדר. ");
INSERT INTO heblb_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","”היכן אתה רוצה שנכין את הסעודה?“ שאלו את ישוע. ");
INSERT INTO heblb_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","”בכניסה לירושלים תפגשו אדם נושא כד מים“, השיב ישוע. ”לכו אחריו, היכנסו אל הבית שאליו יכנס ");
INSERT INTO heblb_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ואמרו לבעל הבית: ’רבנו ביקש שתראה לנו את חדר האורחים אשר הכנת לו ולתלמידיו בשביל הסדר‘. ");
INSERT INTO heblb_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","הוא יוביל אתכם אל הקומה השנייה ויראה לכם חדר גדול שהכין למעננו. שם תכינו את הסעודה.“ ");
INSERT INTO heblb_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","פטרוס ויוחנן הלכו העירה; הכול התרחש בדיוק כפי שאמר ישוע, והם הכינו את הסדר. ");
INSERT INTO heblb_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","מאוחר יותר הגיעו ישוע ושאר התלמידים, וכשהגיעה השעה התיישבו כולם סביב השולחן. ");
INSERT INTO heblb_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","”נכספתי לאכול עמכם את סעודת הפסח לפני שאתייסר“, פתח ישוע ואמר: ");
INSERT INTO heblb_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","”אני אומר לכם ששוב לא אוכל את סעודת הפסח, עד אשר תתקיים במלוא משמעותה במלכות האלוהים.“ ");
INSERT INTO heblb_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","לאחר מכן לקח ישוע כוס יין, ברך ואמר: ”קחו את היין ושתו ממנו כולכם. ");
INSERT INTO heblb_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","”דעו לכם ששוב לא אשתה יין עד אשר תבוא מלכות האלוהים.“ ");
INSERT INTO heblb_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","לאחר מכן הוא לקח כיכר לחם (מצה), הודה לאלוהים עליו, פרס את הלחם לפרוסות, נתן לתלמידיו ואמר: ”זהו גופי הניתן בעדכם. עשו זאת לזיכרוני.“ ");
INSERT INTO heblb_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","בתום הסעודה הגיש להם ישוע עוד כוס יין ואמר: ”כוס זאת מסמלת את הברית החדשה בין אלוהים לביניכם – ברית שנחתמה בדמי. ");
INSERT INTO heblb_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","אולם ליד השולחן יושב האיש שיסגיר אותי. ");
INSERT INTO heblb_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","בן־האדם הולך למות כפי שנגזר עליו, אולם אני אומר לכם: אוי לו לאיש שיסגיר אותו!“ ");
INSERT INTO heblb_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","התלמידים החלו לשאול זה את זה מי מהם עלול לעשות מעשה נורא שכזה. ");
INSERT INTO heblb_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","בין התלמידים התעורר ויכוח: מי מהם החשוב ביותר. ");
INSERT INTO heblb_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","אמר להם ישוע: ”בעולמנו רודים המלכים והשליטים בנתיניהם, ובכל זאת אלה נחשבים לדורשים בטוב נתיניהם. ");
INSERT INTO heblb_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","אולם אצלכם המצב שונה; מי שמרבה לשרת אתכם הוא יהיה הגדול מביניכם, והמנהיג יהיה משרת. ");
INSERT INTO heblb_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","ומי נחשב גדול, מי שיושב בשולחן או מי שמשרת את מי שבשולחן? כמובן שהיושב בשולחן. ואילו אני ביניכם כמשרת. ");
INSERT INTO heblb_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","”מאחר ששמרתם לי אמונים על־אף הצרות והקשיים, ");
INSERT INTO heblb_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","ומאחר שאבי הנחיל לי מלכות, הריני מעניק לכם בזאת את הזכות ");
INSERT INTO heblb_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","לאכול ולשתות על שולחני במלכותי, ולשבת על כסאות לשפוט את שנים־עשר שבטי ישראל.“ ");
INSERT INTO heblb_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","”שמעון, שמעון,“ המשיך האדון, ”השטן דורש את כולכם, לסנן אתכם כמו חיטה. ");
INSERT INTO heblb_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","אבל התפללתי בעדך שלא תאבד את אמונתך. לאחר שתחזור בתשובה חזק את אחיך.“ ");
INSERT INTO heblb_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","”אדוני,“ קרא שמעון פטרוס, ”אני מוכן ללכת איתך לבית־הסוהר ואף למות איתך!“ ");
INSERT INTO heblb_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","אולם ישוע ענה: ”פטרוס, אני אומר לך שעוד היום, לפני קריאת התרנגול, תתכחש לי שלוש פעמים ותאמר שאינך מכיר אותי כלל. ");
INSERT INTO heblb_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","”כאשר שלחתי אתכם לבשר את הבשורה בלי כסף, בלי תרמיל ובלי נעליים האם חסרתם משהו?“ המשיך ישוע. ”לא חסר לנו דבר“, השיבו. ");
INSERT INTO heblb_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","”אבל עכשיו,“ אמר להם ישוע, ”למי שיש כסף ותרמיל שייקח אותם איתו; ולמי שאין חרב – שימכור את מעילו ויקנה אחת. ");
INSERT INTO heblb_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","כי הגיע המועד שתתקיים הנבואה הכתובה עלי: ’הוא נימנה בין פושעים‘. כן, כל מה שכתבו עלי הנביאים יתקיים במלואו.“ ");
INSERT INTO heblb_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","”אדון,“ קראו התלמידים, ”יש לנו כאן שתי חרבות.“ ”אלה מספיקות לכם“, השיב ישוע. ");
INSERT INTO heblb_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","לאחר מכן יצא ישוע מהעיר והלך אל הר הזיתים, כמנהגו מדי יום, והתלמידים הלכו בעקבותיו. ");
INSERT INTO heblb_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","בהגיעו אל המקום אמר ישוע לתלמידיו: ”התפללו שלא תבואו לידי ניסיון.“ ");
INSERT INTO heblb_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","ישוע התרחק מתלמידיו מרחק־מה, כרע על ברכיו והתפלל: ");
INSERT INTO heblb_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","”אבי, אם יש ברצונך, אנא, הרחק ממני את כוס הייסורים. אולם אני רוצה שייעשה רצונך ולא רצוני!“ ");
INSERT INTO heblb_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","לאחר מכן נגלה אליו מלאך מן השמים וחיזק אותו. ");
INSERT INTO heblb_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","בגלל סבלו הרב הוא התפלל בדבקות רבה, וזיעתו נפלה על הארץ כטיפות דם גדולות. ");
INSERT INTO heblb_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","כאשר סיים ישוע את תפילתו וחזר אל תלמידיו, מצא אותם ישנים מרוב צער ועייפות. ");
INSERT INTO heblb_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","”מדוע אתם ישנים?“ שאל ישוע. ”קומו והתפללו שלא תבואו לידי ניסיון.“ ");
INSERT INTO heblb_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","בעודו מדבר התקרב אליו קהל גדול של אנשים ובראשם צעד יהודה, שהיה אחד מתלמידיו. יהודה קרב אל ישוע כדי לנשקו, ");
INSERT INTO heblb_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","אולם ישוע אמר לו: ”יהודה, האם בנשיקה אתה עומד להסגיר את בן־האדם?“ ");
INSERT INTO heblb_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","כשראו התלמידים את העומד להתרחש שאלו את ישוע: ”אדון, אתה רוצה שנכה אותם בחרבות שלנו?“ ");
INSERT INTO heblb_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","ואחד מהם קיצץ את אוזנו הימנית של עבד הכוהן הגדול. ");
INSERT INTO heblb_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","ישוע עצר בעדם ואמר: ”הניחו להם לעשות את שלהם.“ לאחר מכן נגע באוזנו של העבד וריפא אותה. ");
INSERT INTO heblb_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","ישוע פנה אל ראשי הכוהנים, מפקדי משמר בית־המקדש והזקנים שבאו לאסרו: ”מדוע אתם באים אלי בחרבות ובמקלות, האם אני גנב או שודד? ");
INSERT INTO heblb_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","מדוע לא אסרתם אותי בבית־המקדש? הרי הייתי שם כל יום. אבל זוהי שעתכם, ושעת שלטון החושך.“ ");
INSERT INTO heblb_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","הם אסרו את ישוע והובילוהו אל בית הכוהן הגדול. פטרוס הלך אחריהם במרחק־מה, ");
INSERT INTO heblb_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","אולם הצטרף אליהם כשהדליקו מדורה בחצר והתיישבו סביבה. ");
INSERT INTO heblb_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","משרתת אחת הבחינה בפטרוס לאור המדורה. היא נעצה בו מבט וקראה: ”האיש הזה היה עם ישוע!“ ");
INSERT INTO heblb_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","פטרוס הכחיש בתוקף את דבריה: ”אישה, איני מכיר אותו כלל!“ ");
INSERT INTO heblb_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","כעבור זמן קצר הבחין מישהו אחר בפטרוס. ”אתה ודאי אחד מהם!“ אמר. ”מה פתאום,“ הכחיש פטרוס, ”אינני אחד מהם!“ ");
INSERT INTO heblb_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","כעבור שעה בערך העיר אדם נוסף: ”אין לי ספק שהאיש הזה היה עם ישוע, כי שניהם מהגליל.“ ");
INSERT INTO heblb_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","פטרוס הכחיש שוב: ”בן־אדם, איני יודע על מה אתה מדבר!“ לפני שסיים פטרוס את דבריו נשמעה קריאת התרנגול. ");
INSERT INTO heblb_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","באותו רגע פנה ישוע והביט בעיניו של פטרוס. אז נזכר פטרוס בדברי האדון: ”לפני קריאת התרנגול תתכחש לי שלוש פעמים.“ ");
INSERT INTO heblb_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","הוא יצא מהחצר ומירר בבכי. ");
INSERT INTO heblb_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","החיילים שהופקדו על שמירת ישוע לעגו לו, הכו אותו והתעללו בו. ");
INSERT INTO heblb_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","הם קשרו את עיניו, הכו אותו באגרופים וקראו בלעג: ”נביא שכמוך, נחש מי הכה אותך?“ ");
INSERT INTO heblb_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","הם המשיכו לקלל ולהעליב אותו. ");
INSERT INTO heblb_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","למחרת בבוקר הובא ישוע לפני חברי הסנהדרין, ראשי הכוהנים, הסופרים וזקני העם. ");
INSERT INTO heblb_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","”האם אתה באמת המשיח?“ שאלו אותו. אך ישוע השיב: ”אם אגיד לכם, לא תאמינו לי, ");
INSERT INTO heblb_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ואם אשאל אתכם שאלות לא תשיבו לי. ");
INSERT INTO heblb_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","אולם עוד מעט בן־האדם ישב לימין גבורת האלוהים.“ ");
INSERT INTO heblb_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","”אם כך, בן־אלוהים אתה?“ ”אתם אמרתם שאני הוא“ השיב ישוע. ");
INSERT INTO heblb_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","”איננו זקוקים לעדויות נוספות!“ הם קראו. ”במו אוזנינו שמענו אותו אומר דברים אלה!“ ");
INSERT INTO heblb_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","ראשי הכוהנים, הסופרים, זקני העם וחברי הסנהדרין הוליכו את ישוע אל פילטוס, ");
INSERT INTO heblb_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","ומיד החלו להאשים אותו: ”האיש הזה מסית את העם לא לשלם מס לקיסר הרומאי, וטוען שהוא המשיח, כלומר מלך!“ ");
INSERT INTO heblb_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","”האם אתה מלך היהודים?“ שאל פילטוס את ישוע. ”אתה אומר“, ענה ישוע. ");
INSERT INTO heblb_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","פילטוס פנה אל ראשי הכוהנים ואל ההמון וקרא: ”מה אתם רוצים ממנו? הוא לא עבר על שום חוק!“ ");
INSERT INTO heblb_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","אולם הם התעקשו: ”אבל הוא מסית את העם בכל אזור יהודה נגד השלטון. הוא החל בכך בגליל, ועכשיו הוא בא לירושלים.“ ");
INSERT INTO heblb_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","”האם הוא תושב הגליל?“ שאל פילטוס. ");
INSERT INTO heblb_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","”כן“, השיבו לו. מאחר שהגליל היה במחוז שיפוטו של הורדוס, החליט פילטוס לשלוח את ישוע אליו. מלבד זאת, באותה העת היה הורדוס בירושלים. ");
INSERT INTO heblb_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","הורדוס שמח מאוד לראות את ישוע, מכיוון ששמע עליו ניסים ונפלאות, ומזה זמן רב השתוקק לפגוש אותו פנים אל פנים ולחזות בניסים שחולל. ");
INSERT INTO heblb_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","הורדוס שאל את ישוע שאלות רבות, אולם ישוע לא השיב דבר. ");
INSERT INTO heblb_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","בינתיים ראשי הכוהנים והסופרים הטיחו את האשמותיהם בישוע. ");
INSERT INTO heblb_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","גם הורדוס וחייליו בזו לישוע וצחקו לו; הם הלבישו אותו גלימת פאר ושלחוהו חזרה אל פילטוס. ");
INSERT INTO heblb_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","הורדוס ופילטוס, שהיו עד אז אויבים, הפכו באותו יום לידידים. ");
INSERT INTO heblb_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","פילטוס אסף את ראשי הכוהנים, ומנהיגים אחרים ואת העם, ");
INSERT INTO heblb_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","והודיע להם: ”הבאתם לפני את האיש הזה וטענתם שהוא מסית את העם למרוד בשלטון. חקרתי אותו היטב בנוכחותכם ולא מצאתי כל יסוד להאשמותיכם! ");
INSERT INTO heblb_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","גם הורדוס לא מצא כל אשמה בישוע, ולכן שלח אותו אלינו. האיש הזה לא עשה כל מעשה שדינו מוות! ");
INSERT INTO heblb_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","משום כך אלקה אותו בשוט ואשחרר אותו.“ ");
INSERT INTO heblb_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","מדי שנה בחג הפסח, נהג פילטוס לשחרר אסיר יהודי אחד. ");
INSERT INTO heblb_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","אך כולם צעקו פה אחד: ”קחו אותו מכאן! שחרר לנו את בר־אבא!“ ");
INSERT INTO heblb_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(בר־אבא היה במאסר באשמת רצח והסתה למרד בירושלים). ");
INSERT INTO heblb_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","פילטוס רצה לשחרר את ישוע, ולכן ניסה להתווכח עם הקהל. ");
INSERT INTO heblb_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","אבל הקהל התעקש: ”צלוב אותו! צלוב אותו!“ ");
INSERT INTO heblb_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","פילטוס שאל אותם פעם שלישית: ”מדוע? מה הוא עשה? לא מצאתי כל סיבה להוציאו להורג. אלקה אותו בשוט ואשחרר אותו.“ ");
INSERT INTO heblb_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","אבל הם המשיכו לצעוק ולהפציר בו לצלוב את ישוע, וצעקותיהם הכריעו את הנידון. ");
INSERT INTO heblb_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","פילטוס נכנע לדרישתם ודן את ישוע למוות. ");
INSERT INTO heblb_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","על־פי בקשתם שחרר את בר־אבא, שהיה אסור באשמת רצח ומרידה, ומסר לידיהם את ישוע כדי שיעשו בו כרצונם. ");
INSERT INTO heblb_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","בהוליכם את ישוע אל מקום הצליבה פגשו בדרך את שמעון הקוריני, שחזר מן השדה, ואילצוהו ללכת אחרי ישוע ולשאת את צלבו. ");
INSERT INTO heblb_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","בין הקהל הרב שהלך אחרי ישוע היו גם נשים רבות שספדו עליו. ");
INSERT INTO heblb_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","ישוע פנה אליהן ואמר: ”בנות ירושלים, אל תבכינה עלי, כי אם על עצמכן ועל ילדיכן, ");
INSERT INTO heblb_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","כי תבוא העת שבה נשים שאין להן ילדים תיחשבנה לבנות מזל. ");
INSERT INTO heblb_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","בעת ההיא יתחננו בני־האדם לפני ההרים שיפלו עליהם ויכסו אותם, ולפני הגבעות – שתקבורנה אותם. ");
INSERT INTO heblb_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","שהרי אם זהו גורלו של אדם חף מפשע, מה נורא יהיה גורלם של האשמים באמת!“ ");
INSERT INTO heblb_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","יחד עם ישוע הובלו למוות גם שני פושעים. ");
INSERT INTO heblb_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","בהגיעם אל המקום שנקרא ”מקום הגולגולת“ – הם צלבו את השלושה: את ישוע במרכז, ואת שני הפושעים לימינו ולשמאלו. ");
INSERT INTO heblb_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","”אבי, סלח להם,“ קרא ישוע, ”כי אינם יודעים מה הם עושים!“ בינתיים ערכו החיילים הגרלה וחילקו ביניהם את בגדי ישוע. ");
INSERT INTO heblb_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","ההמון עמד והביט במתרחש, ואילו מנהיגי העם לעגו לו וקראו: ”הוא ’הושיע‘ כל־כך הרבה אנשים? אם הוא באמת המשיח בחיר האלוהים, הבה נראה כיצד יושיע את עצמו!“ ");
INSERT INTO heblb_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","גם החיילים התלו בו; הם נתנו לו לשתות חומץ ");
INSERT INTO heblb_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","וקראו: ”אם אתה באמת מלך היהודים, הושע את עצמך!“ ");
INSERT INTO heblb_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","מעל ראשו של ישוע תלו שלט: ”זהו מלך היהודים“. ");
INSERT INTO heblb_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","אחד הפושעים שהיה תלוי לצידו של ישוע לעג לו ואמר: ”אם אתה באמת המשיח, מדוע אינך מציל את עצמך ואותנו לפני שיהיה מאוחר מדי?“ ");
INSERT INTO heblb_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","הפושע השני גער בחברו ואמר: ”האם גם במותך אינך ירא את האלוהים? ");
INSERT INTO heblb_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","אנחנו נענשים בעונש שמגיע לנו על מעשינו הרעים, אולם האדם הזה חף מפשע!“ ");
INSERT INTO heblb_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","הוא פנה אל ישוע ואמר: ”ישוע, זכור אותי כשתבוא אל מלכותך.“ ");
INSERT INTO heblb_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","”עוד היום אתה תהיה איתי בגן־עדן“, ענה לו ישוע. ");
INSERT INTO heblb_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","בשעה שתים־עשרה בצהריים כיסה חושך את כל הארץ למשך שלוש שעות. ");
INSERT INTO heblb_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","אור השמש חשך, והפרוכת התלויה לפני קודש הקודשים בבית־המקדש נקרעה לשניים. ");
INSERT INTO heblb_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","לאחר מכן קרא ישוע בקול גדול: ”אבי, אני מפקיד את רוחי בידך.“ ונפח את נשמתו. ");
INSERT INTO heblb_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","קצין רומאי אחד, אשר ראה את המתרחש, נמלא יראת אלוהים וקרא: ”האיש הזה באמת היה צדיק!“ ");
INSERT INTO heblb_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","משנוכחו האנשים שבאו לחזות בצליבה כי ישוע מת, הצטערו צער רב והלכו לבתיהם. ");
INSERT INTO heblb_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","כל חבריו וידידיו של ישוע, וביניהם הנשים שהלכו אחריו מהגליל, עמדו במרחק מה והביטו במתרחש. ");
INSERT INTO heblb_vpl VALUES ("LK23_50‏","072_23_50‏","LUK","23","50‏","51","בין ידידיו של ישוע היה גם אדם בשם יוסף מהעיירה היהודית רמתיים. יוסף היה איש טוב וישר והאמין בביאת המשיח. למרות שהיה חבר הסנהדרין לא הסכים עם החלטתם ופעולתם. ");
INSERT INTO heblb_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","יוסף הלך אל פילטוס וביקש ממנו את גופתו של ישוע. ");
INSERT INTO heblb_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","לאחר שהוריד את הגופה מן הצלב עטף אותה יוסף בסדין, וקבר אותה בקבר חדש חצוב בסלע, שטרם נקבר בו איש. ");
INSERT INTO heblb_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","כל זה התרחש ביום שישי בערב, לפני כניסת השבת. ");
INSERT INTO heblb_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","הנשים אשר באו עם ישוע מהגליל הלכו אחרי יוסף וראו היכן שקבר את הגופה. ");
INSERT INTO heblb_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","לאחר מכן הלכו והכינו מרקחת בשמים, אולם לא שבו מיד אל הקבר, כי בינתיים נכנסה השבת והן לא רצו לחלל אותה. ");
INSERT INTO heblb_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","ביום ראשון השכם בבוקר לקחו הנשים את המרקחת שהכינו והלכו אל הקבר. ");
INSERT INTO heblb_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","בהגיען אל המקום גילו כי האבן הגדולה שסתמה את פתח הקבר הוזזה ממקומה. ");
INSERT INTO heblb_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","הן נכנסו פנימה, אך לא מצאו את גופתו של האדון ישוע. ");
INSERT INTO heblb_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","הנשים היו במבוכה גדולה ולא הבינו מה קרה. לפתע נגלו אליהן שני אנשים לבושים גלימות מבריקות ונוצצות. ");
INSERT INTO heblb_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","בפחד רב השתחוו הנשים לפני השניים. ”מדוע אתן מחפשות את החי בין המתים?“ שאלו השניים. ");
INSERT INTO heblb_vpl VALUES ("LK24_6‏","072_24_6‏","LUK","24","6‏","7","”הוא אינו נמצא כאן, הוא קם לתחייה! זיכרו שעוד בהיותו בגליל סיפר לכן שעל בן־האדם להימסר לידי אנשים רשעים, שיצלבו אותו, אבל ביום השלישי יקום לתחייה!“ ");
INSERT INTO heblb_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","הנשים נזכרו בדברי ישוע ");
INSERT INTO heblb_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","ומיהרו לשוב העירה, כדי לספר את החדשות לאחד־עשר התלמידים ולכל השאר. ");
INSERT INTO heblb_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","(אלה הנשים שהלכו אל הקבר: מרים המגדלית, יוחנה, מרים אמו של יעקב ואחרות). ");
INSERT INTO heblb_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","אולם דברי הנשים נשמעו באוזניהם כסיפור דמיוני, והם לא האמינו להן. ");
INSERT INTO heblb_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","אך פטרוס קם ורץ אל הקבר. בהביטו פנימה ראה את התכריכים מונחים במקומם, אך הגופה לא הייתה שם. הוא לא הבין מה קרה ועזב את המקום. ");
INSERT INTO heblb_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","באותו יום הלכו שניים מתלמידיו של ישוע בדרך המובילה לעמאוס – כפר המרוחק כאחד עשר ק״מ מירושלים. ");
INSERT INTO heblb_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","בעודם משוחחים ביניהם על מות ישוע, ");
INSERT INTO heblb_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","הופיע לפתע ישוע עצמו ונלווה אליהם. ");
INSERT INTO heblb_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","אך השניים לא הכירוהו, כי עיניהם היו אחוזות. ");
INSERT INTO heblb_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","”על מה אתם משוחחים?“ שאל אותם ישוע. השניים נעצרו, וישוע ראה שפניהם הביעו צער וכאב. ");
INSERT INTO heblb_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","אחד מהשניים, קליופס שמו, השיב: ”אתה ודאי האדם היחיד בכל ירושלים שאינו יודע מה קרה בעיר בימים האחרונים.“ ");
INSERT INTO heblb_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","”מה קרה בעיר?“ שאל ישוע. ”אנחנו מתכוונים לישוע מנצרת“, הסבירו השניים. ”ישוע היה נביא שחולל נסים ונפלאות, ומורה חכם בעיני אלוהים ובעיני העם. ");
INSERT INTO heblb_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","אבל ראשי הכוהנים ורבים ממנהיגנו אסרו אותו ומסרוהו לידי הרומאים, כדי שיגזרו עליו דין מוות, ואלה צלבו אותו. ");
INSERT INTO heblb_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","ואילו אנחנו חשבנו וקיווינו שהוא המשיח העתיד לגאול את עם־ישראל. כל מה שסיפרנו לך קרה לפני שלושה ימים, ");
INSERT INTO heblb_vpl VALUES ("LK24_22‏","072_24_22‏","LUK","24","22‏","23","אך בזאת לא תם הסיפור! מספר נשים מקבוצתנו הלכו הבוקר אל הקבר, וכשחזרו היה בפיהן סיפור בלתי רגיל. הנשים סיפרו כי גופתו של ישוע נעלמה, וכי פגשו בקבר שני מלאכים שאמרו להן כי ישוע חי! ");
INSERT INTO heblb_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","כמה מאנשינו מיהרו אל הקבר כדי לבדוק את דברי הנשים, ונוכחו שהן צדקו; גופתו של ישוע באמת נעלמה.“ ");
INSERT INTO heblb_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","”כסילים!“ קרא ישוע. ”האם כל־כך קשה לכם להאמין לדברי הנביאים בכתבי־הקודש? ");
INSERT INTO heblb_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","האם לא ניבאו הנביאים באופן ברור שהמשיח יסבול את העינויים הנוראים האלה, לפני שיתגלה כבודו והדרו?“ ");
INSERT INTO heblb_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","לאחר מכן הוא ציטט להם פסוקים מן התנ״ך והסביר להם את כל מה שנאמר עליו בכתובים, החל מבראשית וכלה בדברי הנביאים. ");
INSERT INTO heblb_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","בינתיים התקרבו השלושה לעמאוס – הכפר שאליו היו מועדות פניהם. ישוע נראה כעומד להמשיך בדרכו, ");
INSERT INTO heblb_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","אולם השניים הפצירו בו ללון בביתם, כי הייתה שעת ערב, וישוע נענה להזמנתם. ");
INSERT INTO heblb_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","כשהתיישבו לאכול ברך ישוע על הלחם, פרס אותו והגישו להם. ");
INSERT INTO heblb_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","לפתע כאילו נפקחו עיניהם, והם הכירו את ישוע. באותו רגע הוא נעלם מעיניהם. ");
INSERT INTO heblb_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","השניים החלו לספר זה לזה כיצד התרגשו בשעה שישוע דיבר אליהם וביאר להם את הכתוב בתנ״ך. ");
INSERT INTO heblb_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","בלי לאבד זמן קמו השניים וחזרו לירושלים, שם מצאו את אחד־עשר התלמידים ואחרים מתלמידי ישוע אשר קיבלו את פניהם בקריאה: ");
INSERT INTO heblb_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","”האדון באמת קם לתחייה! הוא נגלה לפטרוס!“ ");
INSERT INTO heblb_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","השניים מעמאוס סיפרו כיצד נגלה ישוע גם אליהם כשהלכו בדרך, וכיצד הכירו אותו כשפרס את הלחם. ");
INSERT INTO heblb_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","בשעה שדיברו הופיע ישוע בחדר ואמר: ”שלום לכם!“ ");
INSERT INTO heblb_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","הופעתו הבהילה אותם, כי חשבו שרוח רפאים לפניהם! ");
INSERT INTO heblb_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","”מדוע נבהלתם?“ שאל ישוע. ”מדוע אינכם מאמינים שאני הוא העומד לפניכם? ");
INSERT INTO heblb_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","הביטו בידי! הביטו ברגלי! אתם יכולים לראות ללא ספק שאני הוא העומד לפניכם! געו בי והיווכחו שאינני רוח, שהרי לרוח אין בשר ועצמות כפי שיש לי!“ ");
INSERT INTO heblb_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","בשעה שדיבר הראה להם ישוע את נקבי המסמרים בידיו ואת הפצעים ברגליו. ");
INSERT INTO heblb_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","על אף שמחתם הרבה עדיין הטילו התלמידים ספק ולא האמינו. משום כך שאל אותם ישוע: ”האם יש לכם כאן משהו לאכול?“ ");
INSERT INTO heblb_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","הם הגישו לו חתיכת דג צלוי, ");
INSERT INTO heblb_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","וישוע אכל את הדג לנגד עיניהם. ");
INSERT INTO heblb_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","לאחר מכן אמר ישוע: ”האם אינכם זוכרים שעוד בהיותי אתכם סיפרתי לכם שכל מה שאמרו עלי משה, הנביאים ובתהלים חייב להתקיים?“ ");
INSERT INTO heblb_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","ישוע פתח את לבם כדי שסוף סוף יבינו את הכתובים, ");
INSERT INTO heblb_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","והוסיף: ”עוד לפני זמן רב נכתב שעל המשיח להתענות, למות ולקום לתחייה ביום השלישי. ");
INSERT INTO heblb_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","ועוד כתוב כי דבר אלוהים יצא אל כל העמים, החל מירושלים, וכי כל מי שיאמין בי ויחזור בתשובה יסלחו לו חטאיו. ");
INSERT INTO heblb_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","אתם עדים לקיום הנבואות האלה. ");
INSERT INTO heblb_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","עתה אני עומד לשלוח אליכם את אשר הבטיח אבי. הישארו כאן בירושלים עד שיבוא רוח הקודש וימלא אתכם בכוח ובגבורה מן השמים.“ ");
INSERT INTO heblb_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","לאחר מכן הוא הוביל אותם אל בית־עניה, שם נשא את ידיו אל השמים וברך אותם. ");
INSERT INTO heblb_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","תוך כדי ברכתו נפרד מהם ישוע ועלה השמיימה. ");
INSERT INTO heblb_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","התלמידים השתחוו לו וחזרו לירושלים מלאי שמחה, ");
INSERT INTO heblb_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","ואת כל זמנם בילו בבית־המקדש כשהם מהללים ומברכים את האלוהים.");
INSERT INTO heblb_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","בראשית היה הדבר, והדבר היה עם האלוהים, ואלוהים היה הדבר. ");
INSERT INTO heblb_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","הוא היה בראשית עם האלוהים. ");
INSERT INTO heblb_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","דרכו נברא הכל, אין דבר שלא נברא על־ידו. ");
INSERT INTO heblb_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","בו היו חיים, וחיים אלה היו האור לבני־האדם. ");
INSERT INTO heblb_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","האור מאיר בחושך, והחושך לא התגבר עליו. ");
INSERT INTO heblb_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","אלוהים שלח אדם בשם יוחנן ");
INSERT INTO heblb_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","להעיד על האור האמתי, כדי שכולם יאמינו בו. ");
INSERT INTO heblb_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","יוחנן עצמו לא היה האור; הוא רק נשלח להעיד על האור ");
INSERT INTO heblb_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","האמתי שבא לעולם כדי להאיר לכל בני־האדם. ");
INSERT INTO heblb_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","האור בא אל העולם שנברא על ידו, אך העולם לא הכיר אותו. ");
INSERT INTO heblb_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","הוא בא אל שלו, אך אלה לא קיבלו אותו. ");
INSERT INTO heblb_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","אבל לכל אלה שהאמינו בו הוא העניק את הזכות להיות בני־אלוהים. ");
INSERT INTO heblb_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","כל המאמינים בו נולדו מחדש – לא בלידה ביולוגית מגבר ואישה, ולא מרצון האדם, אלא מרצון האלוהים. ");
INSERT INTO heblb_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","הדבר נהיה בשר ושכן בתוכינו. אנחנו ראינו את כבודו, כבוד הבן היחיד מהאב, מלא חסד ואמת. ");
INSERT INTO heblb_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","יוחנן העיד עליו וקרא: ”הנה האדם שאליו התכוונתי, כשסיפרתי לכם שאחרי עומד לבוא אדם גדול ונעלה ממני, כי הוא היה לפני שהייתי אני.“ ");
INSERT INTO heblb_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","כולנו התברכנו בברכות רבות מעושרו ומחסדו. ");
INSERT INTO heblb_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","כי בעוד שמשה רבנו מסר לנו את התורה, ישוע המשיח העניק לנו חסד ואמת. ");
INSERT INTO heblb_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","איש לא ראה מעולם את האלוהים, מלבד בנו היחיד הנמצא בחיקו, והוא סיפר לנו על אביו. ");
INSERT INTO heblb_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","זוהי, אם כן, עדותו של יוחנן: כאשר שלחו אליו היהודים כוהנים ולווים מירושלים כדי לברר מי הוא, ");
INSERT INTO heblb_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","יוחנן הודה מיד: ”אינני המשיח!“ ");
INSERT INTO heblb_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","”אם כן, מי אתה?“ דרשו לדעת. ”האם אתה אליהו?“ ”לא“, השיב יוחנן. ”האם אתה הנביא?“ ”לא“ השיב להם. ");
INSERT INTO heblb_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","”מי אתה? מה יש לך לומר? ברצוננו לדעת מה להשיב לשולחינו.“ ");
INSERT INTO heblb_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","”אני הקול הקורא במדבר כנבואת ישעיהו: ’פנו דרך ה׳!‘ “ השיב יוחנן. ");
INSERT INTO heblb_vpl VALUES ("JN1_24‏","073_1_24‏","JHN","1","24‏","25","אנשים אלה, שנשלחו על־ידי הפרושים, המשיכו לשאול אותו: ”אם אינך המשיח, אינך אליהו ואינך הנביא, מדוע אתה מטביל את האנשים?“ ");
INSERT INTO heblb_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","”אני מטביל רק במים,“ השיב יוחנן, ”אולם דעו ביניכם עומד אדם שלא פגשתם מעולם. ");
INSERT INTO heblb_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","למרות שהוא בא אחרי הוא היה לפני, ואיני ראוי אפילו להתיר את שרוך נעליו.“ ");
INSERT INTO heblb_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","כל זה התרחש בכפר בית־עניה שעל חוף הירדן – במקום שבו נהג יוחנן להטביל. ");
INSERT INTO heblb_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","למחרת ראה יוחנן את ישוע בא לקראתו והכריז: ”הביטו! הנה שה האלוהים הנושא את חטאי העולם. ");
INSERT INTO heblb_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","אליו התכוונתי כשסיפרתי לכם שאחרי עומד לבוא אדם גדול ונעלה ממני, כי הוא היה לפני שהייתי אני. ");
INSERT INTO heblb_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","אני עצמי לא הכרתי אותו; אני באתי רק להטביל אנשים במים ולהצביע עליו לעם ישראל.“ ");
INSERT INTO heblb_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","יוחנן סיפר להם שהוא ראה את רוח הקודש יורדת בדמות יונה ונחה על ישוע. ");
INSERT INTO heblb_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","”לא הכרתי את ישוע לפני כן,“ חזר ואמר יוחנן, ”אולם כאשר אלוהים שלח אותי להטביל במים הוא אמר לי: ’בראותך את רוח הקודש יורדת ונחה על איש, דע כי אותו אתה מבקש – זהו האיש שיטביל ברוח הקודש‘. ");
INSERT INTO heblb_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","אני ראיתי את רוח הקודש יורדת ונחה על האיש הזה, ולכן אני מעיד שהוא בן האלוהים.“ ");
INSERT INTO heblb_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","למחרת שוב עמד יוחנן באותו מקום עם שניים מתלמידיו. ");
INSERT INTO heblb_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","בראותו את ישוע בא לקראתו הוא קרא: ”הנה שה האלוהים!“ ");
INSERT INTO heblb_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","כששמעו שני התלמידים את קריאתו של יוחנן, פנו ללכת בעקבות ישוע. ");
INSERT INTO heblb_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","ישוע הביט לאחור וראה שהשניים הולכים בעקבותיו. ”מה רצונכם?“ שאל אותם. ”רבי, היכן אתה גר?“ השיבו בשאלה. ");
INSERT INTO heblb_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","”בואו וראו“, ענה ישוע. השניים הלכו אחריו למקום מגוריו, ונשארו איתו משעה ארבע אחר־הצהריים עד הערב. ");
INSERT INTO heblb_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","‎אַנְדְּרֵי, אחיו של שמעון פטרוס, היה אחד משני התלמידים שהלכו אחריו. ");
INSERT INTO heblb_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","‎אַנְדְּרֵי הלך מיד לחפש את אחיו, וכשמצא אותו קרא בהתרגשות: ”מצאנו את המשיח!“ ");
INSERT INTO heblb_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","כשהביא ‎אַנְדְּרֵי את פטרוס אל ישוע, הביט ישוע בפטרוס לרגע ואמר: ”אתה אמנם שמעון בנו של יונה, אך מעתה ואילך תיקרא: פטרוס – ‎ כֵּיפָא!“ ");
INSERT INTO heblb_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","למחרת החליט ישוע ללכת לגליל. הוא פגש בדרך את פיליפוס ואמר לו: ”בוא אחרי.“ ");
INSERT INTO heblb_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","פיליפוס היה מבית־צידה, עירם של ‎אַנְדְּרֵי ופטרוס. ");
INSERT INTO heblb_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","פיליפוס הלך לחפש את נתנאל, וכשמצא אותו קרא: ”מצאנו את המשיח שעליו סיפרו משה רבנו והנביאים! שמו ישוע, בנו של יוסף מנצרת!“ ");
INSERT INTO heblb_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","”נצרת?“ קרא נתנאל בחוסר אמון. ”איזה דבר טוב יכול לצאת מנצרת?“ ”בוא וראה במו עיניך“, הפציר בו פיליפוס. ");
INSERT INTO heblb_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","כשראה ישוע את נתנאל בא לקראתו, קרא: ”הנה בא לקראתנו בן ישראל אמתי – אדם ישר אמתי שאין בו מרמה.“ ");
INSERT INTO heblb_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","”כיצד אתה יודע מי אני ומה אני?“ תמה נתנאל. ”ראיתי אותך יושב תחת עץ התאנה עוד לפני שפיליפוס מצא אותך“, ענה ישוע. ");
INSERT INTO heblb_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","”אדוני, אתה באמת בן־האלוהים, מלך ישראל!“ קרא נתנאל. ");
INSERT INTO heblb_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","”האם אתה מאמין בכך רק משום שאמרתי כי ראיתי אותך יושב תחת עץ התאנה?“ שאל ישוע. ”עוד תראה דברים גדולים מאלה! ");
INSERT INTO heblb_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","אפילו תראה את השמים נפתחים ומלאכי אלוהים עולים ויורדים על בן־האדם.“ ");
INSERT INTO heblb_vpl VALUES ("JN2_1‏","073_2_1‏","JHN","2","1‏","2","כעבור יומיים נערכה חתונה בכפר־קנה שבגליל, ובין האורחים היו ישוע, אמו ותלמידיו. ");
INSERT INTO heblb_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","כשראתה אמו של ישוע כי אזל היין, פנתה אל בנה ואמרה: ”אזל היין.“ ");
INSERT INTO heblb_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","אולם ישוע השיב: ”למה את אומרת לי את זה? עדיין לא הגיע זמני.“ ");
INSERT INTO heblb_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","למרות תשובה זאת אמרה אמו של ישוע למשרתים: ”עשו כל מה שיגיד לכם לעשות.“ ");
INSERT INTO heblb_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","ששה כדים גדולים מאבן עמדו שם; בכל כד אפשר להכיל מאה עד מאה־חמישים ליטר (אלה היו סוג הכדים שהיהודים השתמשו בהם למנהג הטהרה). ");
INSERT INTO heblb_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","”מלאו את הכדים במים“, ביקש ישוע, והמשרתים מלאו את הכדים עד הסוף. ");
INSERT INTO heblb_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","”הגישו מן המשקה לראש המסיבה“, המשיך ישוע, והם עשו כדבריו. ");
INSERT INTO heblb_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","ראש המסיבה לא ידע מאיפה היין, אבל המשרתים ידעו. כשטעם את המים שהפכו ליין, קרא לחתן ואמר: ");
INSERT INTO heblb_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","”זהו יין משובח מאוד! בדרך־כלל מגיש המארח תחילה את היין המשובח, ולאחר ששתו כולם לרוויה וכבר לא מסוגלים להבחין כל כך בטעם, הוא מגיש את היין הזול. אבל אתה שמרת את היין המשובח לסוף!“ ");
INSERT INTO heblb_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","הנס הזה בכפר־קנה היה הראשון שישוע חולל. הוא הביא את תלמידיו לידי אמונה בו. ");
INSERT INTO heblb_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","לאחר החתונה הלכו ישוע, אמו, אחיו ותלמידיו לכפר־נחום למספר ימים. ");
INSERT INTO heblb_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","חג הפסח התקרב, וישוע עלה לירושלים. ");
INSERT INTO heblb_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","הוא הלך לבית־המקדש ומצא שם סוחרי צאן, בקר ויונים (לצורך הקרבת הקרבנות) ומחליפי כספים. ");
INSERT INTO heblb_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","הוא לקח מספר חבלים, שזר אותם לשוט עבה וגירש משם את כל האנשים ואת הצאן והבקר; הוא פיזר לכל עבר את מטבעותיהם של החלפנים, והפך את שולחנותיהם. ");
INSERT INTO heblb_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","ישוע פנה אל סוחרי היונים וקרא: ”הוציאו מכאן את כל היונים, ואל תהפכו את בית אבי לשוק!“ ");
INSERT INTO heblb_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","תלמידיו נזכרו בנבואה מתהלים: ”כי קנאת ביתך אכלתני.“ ");
INSERT INTO heblb_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","”באיזו רשות אתה עושה את כל הדברים האלה? תן לנו אות או הוכחה כדי שנאמין לך.“ ");
INSERT INTO heblb_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","”הרסו את המקדש הזה,“ ענה ישוע, ”ואני אקים אותו מחדש תוך שלושה ימים!“ ");
INSERT INTO heblb_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","”מה?“ קראו בתמיהה. ”המקדש הזה ניבנה במשך ארבעים־ושש שנים, ואתה טוען שתוכל להקימו מחדש תוך שלושה ימים?“ ");
INSERT INTO heblb_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","ואולם באומרו ”מקדש“ הוא התכוון לגופו. ");
INSERT INTO heblb_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","לאחר שקם לתחייה נזכרו תלמידיו בדבריו והאמינו בכתוב ובדברי ישוע, כי ראו שהכול התקיים. ");
INSERT INTO heblb_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","כאשר היה ישוע בירושלים בחג הפסח, אנשים רבים האמינו שהוא המשיח, כי הם ראו את הנסים והנפלאות שחולל. ");
INSERT INTO heblb_vpl VALUES ("JN2_24‏","073_2_24‏","JHN","2","24‏","25","אך ישוע לא השתכנע שהם באמת מאמינים, משום שידע מה הפכפך אופיו של האדם. ");
INSERT INTO heblb_vpl VALUES ("JN3_1‏","073_3_1‏","JHN","3","1‏","2","באחד הלילות בא אל ישוע נקדימון – מנהיג יהודי מכת הפרושים. ”רבי,“ פתח נקדימון, ”אנחנו יודעים כי אלוהים שלח אותך ללמד אותנו, שהרי איש אינו מסוגל לחולל את כל הנסים האלה ללא עזרת האלוהים!“ ");
INSERT INTO heblb_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","”אני אומר לך את האמת,“ השיב לו ישוע, ”אדם שלא נולד מחדש אינו מסוגל לראות את מלכות האלוהים.“ ");
INSERT INTO heblb_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","”כיצד יכול אדם מבוגר להיוולד מחדש?“ תמה נקדימון. ”האם הוא יכול לשוב לבטן אמו ולהיוולד מחדש?“ ");
INSERT INTO heblb_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","”אני אומר לך את האמת,“ אמר ישוע, ”מי שלא נולד מהרוח ומהמים אינו יכול להיכנס למלכות האלוהים. ");
INSERT INTO heblb_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","בשר ודם מסוגל להוליד אך ורק בשר ודם ואילו רוח הקודש מעניק חיים חדשים מהשמים. ");
INSERT INTO heblb_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","לכן אל תתפלא על כך שאני אומר שעליכם להיוולד מחדש. ");
INSERT INTO heblb_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","הרוח נושבת לכיוונים שונים; אתה שומע את משב הרוח, אולם אינך יודע מאין היא נושבת ולאן היא נושבת. כך אי אפשר להסביר איך בדיוק נולדים מן הרוח.“ ");
INSERT INTO heblb_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","”כיצד ייתכן הדבר?“ שאל נקדימון. ");
INSERT INTO heblb_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","”אתה רב נכבד בישראל ואינך מבין את הדברים האלה?“ השיב ישוע. ");
INSERT INTO heblb_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","”אני מבטיח לך שאנחנו מדברים על מה שאנו יודעים, ומעידים על מה שראינו, אך למרות זאת אינכם מאמינים לנו. ");
INSERT INTO heblb_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","אם אינכם מאמינים לדברי בענייני העולם הזה, כיצד תאמינו לדברי בענייני השמים? ");
INSERT INTO heblb_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","איש לא עלה השמימה מלבד האחד אשר ירד מהשמים – בן־האדם. ");
INSERT INTO heblb_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","כשם שמשה הרים על נס את נחש הנחושת במדבר, כך צריך גם בן־האדם להיות נישא, ");
INSERT INTO heblb_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","כדי שכל המאמין בו יחיה לנצח. ");
INSERT INTO heblb_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","כי אלוהים אהב כל כך את העולם עד שהקריב את בנו היחיד, כדי שכל המאמין בו לא יאבד כי אם יחיה לנצח. ");
INSERT INTO heblb_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","שהרי אלוהים שלח את בנו להושיע את העולם ולא לשפוט אותו. ");
INSERT INTO heblb_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","כל המאמין בו לא יישפט, אך מי שאינו מאמין בו כבר נשפט! כי לא האמין בבנו היחיד של אלוהים. ");
INSERT INTO heblb_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","דינם מבוסס על העובדה שהאור מן השמים בא לעולם, אבל הם לא רצו בו; הם אהבו את החושך, כי מעשיהם רעים ומושחתים. ");
INSERT INTO heblb_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","הם שנאו את אור האלוהים והעדיפו להישאר בחשכה, כי לא רצו שמעשיהם הרעים יתגלו באור. ");
INSERT INTO heblb_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","לעומת זאת, כל מי שעושה את הטוב והישר יבוא לאור בשמחה, כדי להראות לכולם שכל מעשיו נעשו לפי רצון אלוהים.“ ");
INSERT INTO heblb_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","לאחר מכן עזבו ישוע ותלמידיו את ירושלים והלכו לאזור יהודה. הם נשארו שם זמן־מה, וישוע הטביל את המאמינים בו. ");
INSERT INTO heblb_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","באותה עת הטביל יוחנן אנשים בעינון, ליד שלם, כי היו שם הרבה מים. ");
INSERT INTO heblb_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","כל זה התרחש לפני מאסרו של יוחנן. ");
INSERT INTO heblb_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","אחדים מתלמידי יוחנן התווכחו עם פרוש אחד בעניין הטבילה של ישוע ושל יוחנן. ");
INSERT INTO heblb_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","תלמידים באו אל יוחנן ואמרו: ”רבי, האיש שפגשת בעבר־הירדן ואמרת שהוא המשיח, גם הוא מטביל, וכולם הולכים להיטבל על־ידו ולא על־ידך.“ ");
INSERT INTO heblb_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","השיב יוחנן: ”אבינו שבשמים מעניק לכל אחד תפקיד משלו. ");
INSERT INTO heblb_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","התפקיד שלי הוא להכין את הדרך לפני האיש הזה, כדי שכולם יוכלו לבוא אליו. אתם עצמכם עדים לכך שאמרתי כי אינני המשיח – נשלחתי רק לפנות לו את הדרך. ");
INSERT INTO heblb_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","הכלה הולכת אחרי החתן וחברו של החתן שמח בשמחתו; אני חברו של החתן ואני שמח בשמחתו. ");
INSERT INTO heblb_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","ככל שהוא גדל בחשיבותו כך אני הולך ונעשה חסר חשיבות. ");
INSERT INTO heblb_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","”הוא בא מהשמים והוא נעלה על הכל, ואילו אני באתי מהארץ והבנתי מוגבלת לענייני הארץ בלבד. ");
INSERT INTO heblb_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","הוא מספר את אשר ראה ושמע, אך רק מעטים מקשיבים לו ומאמינים לדבריו. ");
INSERT INTO heblb_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","כל המאמין לדבריו מאשר כי אלוהים הוא אמת. ");
INSERT INTO heblb_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","כי אדם זה – אשר נשלח על ידי אלוהים – נושא את דבר אלוהים, שהרי רוח אלוהים ממלא אותו ללא גבול. ");
INSERT INTO heblb_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","אלוהים האב אוהב את הבן ואף נתן לו את הכול! ");
INSERT INTO heblb_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","כל המאמין בבן יחיה לעולם, ואילו מי שאינו מאמין בבן לא יחיה חיי נצח, כי אם יקבל עונש נצחי מאלוהים!“ ");
INSERT INTO heblb_vpl VALUES ("JN4_1‏","073_4_1‏","JHN","4","1‏","2","הפרושים שמעו שישוע מושך אליו אנשים רבים, ושהטביל תלמידים רבים יותר משהטביל יוחנן (למעשה, תלמידי ישוע הם שהטבילו, ולא הוא עצמו). ");
INSERT INTO heblb_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","כשנודע הדבר לישוע, הוא עזב את אזור יהודה וחזר לגליל. ");
INSERT INTO heblb_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","לשם כך היה עליו לעבור דרך שומרון. ");
INSERT INTO heblb_vpl VALUES ("JN4_5‏","073_4_5‏","JHN","4","5‏","6","בשעת הצהריים הגיע ישוע לעיר השומרונית סוכר, השוכנת מול חלקת האדמה שנתן יעקב אבינו ליוסף בנו, ובה באר יעקב. ישוע עייף מהדרך הארוכה ומהחום הכבד, וישב לנוח ליד הבאר. ");
INSERT INTO heblb_vpl VALUES ("JN4_7‏","073_4_7‏","JHN","4","7‏","8","הוא ישב שם לבדו, כי תלמידיו הלכו העירה לקנות אוכל. עד מהרה הגיעה לבאר אישה שומרונית שרצתה לשאוב מים. ”אנא, תני לי לשתות“, ביקש ישוע. ");
INSERT INTO heblb_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","האישה תמהה על בקשתו הבלתי־רגילה וקראה: ”הרי יהודי אתה, ואילו אני שומרונית! אתה יודע שהיהודים אינם מתערבים עם השומרונים. כיצד אתה מבקש ממני לתת לך לשתות?“ ");
INSERT INTO heblb_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","”אילו ידעת מהי מתנתו של אלוהים ומי הוא האומר לך ’תני לי לשתות‘, היית מבקשת ממני מים חיים והייתי נותן לך אותם!“ השיב ישוע. ");
INSERT INTO heblb_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","”מאין לך מים חיים?“ תמהה האישה. ”הבאר הזאת עמוקה מאוד ואין לך דלי או חבל. ");
INSERT INTO heblb_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","מלבד זאת, האם גדול אתה מיעקב אבינו שנתן לנו את הבאר? יעקב עצמו, בני־ביתו וצאנו שתו מהמים האלה!“ ");
INSERT INTO heblb_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","”כל השותה מהמים האלה ישוב ויצמא, ");
INSERT INTO heblb_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","אולם מי שישתה מהמים שאני נותן, לא יצמא יותר לעולם! כי מים אלה יהיו בקרבו למעיין של מים חיים לחיי נצח.“ ");
INSERT INTO heblb_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","”באמת?“ קראה האישה בהתפעלות. ”אנא, תן לי מן המים האלה, כדי שלא אצמא יותר לעולם, ולא אצטרך ללכת את הדרך הארוכה הזאת לשאוב מים.“ ");
INSERT INTO heblb_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","”ברצון“, אמר ישוע. ”לכי קראי לבעלך, ושובו אלי שניכם.“ ");
INSERT INTO heblb_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","”אולם אין לי בעל“, השיבה האישה. ”נכון הדבר“, אמר ישוע. ");
INSERT INTO heblb_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","”כי חמישה בעלים היו לך, והגבר שאתו את חיה עכשיו אינו בעלך!“ ");
INSERT INTO heblb_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","”אדוני,“ קראה האישה בתימהון הולך וגובר, ”אני רואה שאתה נביא! ");
INSERT INTO heblb_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","אולי תוכל לומר לי מדוע אתם, היהודים, עומדים על כך שירושלים היא המקום היחיד לעבודת האלוהים, בעוד שאנחנו, השומרונים, טוענים שאבותינו עבדו אותו בהר גריזים הזה?“ ");
INSERT INTO heblb_vpl VALUES ("JN4_21‏","073_4_21‏","JHN","4","21‏","24","”האמיני לי,“ השיב ישוע, ”המקום אינו חשוב! יבוא יום שלא תשתחוו לאלוהים כאן ולא בירושלים. חשוב לעבוד את האלוהים באמת ובתמים – מכל הלב ובהשראת רוח הקודש, כי זהו מה שאלוהים רוצה מאתנו. אלוהים הוא רוח, והמשתחווה לו צריך להשתחוות בהשראת רוח הקודש. אולם אתם, השומרונים, משתחווים בחוסר דעת כאשר אנחנו, היהודים, משתחווים למה שאנחנו יודעים. כי הישועה באה דרך היהודים.“ ");
INSERT INTO heblb_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","”אני יודעת שהמשיח עומד לבוא, ושהוא יסביר לנו הכל“, אמרה האישה. ");
INSERT INTO heblb_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","”אני המדבר אליך, אני הוא!“ השיב ישוע. ");
INSERT INTO heblb_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","בינתיים חזרו תלמידיו של ישוע מהעיר, והתפלאו לראות אותו מדבר עם אישה, אך איש מהם לא העיר דבר ולא שאל שאלות. ");
INSERT INTO heblb_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","האישה השאירה את כדה ליד הבאר ומיהרה חזרה העירה. היא קראה לכולם בהתלהבות: ");
INSERT INTO heblb_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","”בואו לראות את האיש שסיפר לי את כל מה שעשיתי! אני חושבת שהוא המשיח!“ ");
INSERT INTO heblb_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","אנשים באו מהעיר אל הבאר כדי לראות אותו. ");
INSERT INTO heblb_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","לפני שהגיע אליהם ההמון האיצו התלמידים בישוע לאכול דבר מה. ");
INSERT INTO heblb_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","”יש לי מזון אחר שאינכם יודעים עליו“ השיב ישוע. ");
INSERT INTO heblb_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","”מי הביא לו אוכל?“ שאלו התלמידים איש את רעהו. ");
INSERT INTO heblb_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","”מאכלי הוא לעשות את רצון האלוהים אשר שלחני ולהשלים את עבודתו“, הסביר ישוע. ");
INSERT INTO heblb_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","”אתם באמת חושבים שמלאכת הקציר תחל רק בעוד ארבעה חודשים? הביטו סביבכם, הקמה כבר בשלה ומוכנה לקציר! ");
INSERT INTO heblb_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","הקוצרים יקבלו שכר טוב, והם יאספו קציר לחיי נצח כדי שגם הזורע וגם הקוצר ישמחו יחדיו. ");
INSERT INTO heblb_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","כך תתאמת האמרה: האחד זורע והשני קוצר. ");
INSERT INTO heblb_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","שלחתי אתכם לקצור את מה שלא זרעתם; אחרים עבדו וטרחו, ואתם קוצרים את פרי עמלם.“ ");
INSERT INTO heblb_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","שומרונים רבים מהעיר האמינו שישוע הוא המשיח, כי האישה אמרה: ”הוא סיפר לי את כל מה שעשיתי!“ ");
INSERT INTO heblb_vpl VALUES ("JN4_40‏","073_4_40‏","JHN","4","40‏","41","הקהל הרב ביקש מישוע להאריך את שהותו אצלם, והוא נשאר שם יומיים נוספים. בזמן הקצר הזה האמינו בו עוד אנשים רבים לאחר ששמעו את דבריו. ");
INSERT INTO heblb_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","”הוא באמת מושיע העולם!“ אמרו השומרונים לאישה. ”עתה אנחנו מאמינים בו מפני ששמענו אותו בעצמנו, ולא רק משום הדברים שאת סיפרת לנו.“ ");
INSERT INTO heblb_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","בתום שני ימי שהותו בשומרון הלך ישוע לגליל, ");
INSERT INTO heblb_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","למרות שאמר: ”הנביא זוכה לכבוד ולהערכה בכל מקום, מלבד בעיר מולדתו.“ ");
INSERT INTO heblb_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","ברם, אנשי הגליל התאספו בהמוניהם וקיבלו אותו בזרועות פתוחות, שכן היו בירושלים בחג הפסח וראו את הנפלאות שחולל. ");
INSERT INTO heblb_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","ישוע חזר לכפר־קנה שבגליל, היכן שחולל את נס היין. בכפר־נחום היה פקיד אחד בשירות־המלכותי, שבנו היה חולה מאוד. ");
INSERT INTO heblb_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","כששמע הפקיד שישוע עזב את יהודה ובא לגליל, הוא הלך לכפר־קנה לפגוש אותו, והתחנן לפניו שיבוא לרפא את בנו הגוסס. ");
INSERT INTO heblb_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","”אם לא תראו נסים ונפלאות לא תאמינו“, אמר ישוע. ");
INSERT INTO heblb_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","”אנא, אדוני, בוא מהר לפני שבני ימות“, התחנן הפקיד. ");
INSERT INTO heblb_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","”לך לביתך,“ הרגיע אותו ישוע. ”בנך חי ובריא!“ הפקיד האמין לדברי ישוע והלך לביתו. ");
INSERT INTO heblb_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","בדרך פגשו אותו משרתיו ובישרו לו שבנו הבריא. ");
INSERT INTO heblb_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","”באיזו שעה חל השינוי לטובה במצבו?“ שאל הפקיד. ”אתמול בשעה אחת בצהריים ירד חומו באופן פתאומי“, השיבו המשרתים. ");
INSERT INTO heblb_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","האב ידע כי בשעה זו בישר לו ישוע על החלמת בנו, והוא וכל בני־ביתו האמינו בישוע. ");
INSERT INTO heblb_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","זה היה הנס השני שחולל ישוע בגליל לאחר שובו מיהודה. ");
INSERT INTO heblb_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","כעבור זמן מה חזר ישוע לירושלים לרגל אחד החגים. ");
INSERT INTO heblb_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","ליד שער הצאן בירושלים הייתה ברכה שנקראת בעברית ”בית־חסדא“, וסביבה חמישה רציפים. ");
INSERT INTO heblb_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","על רציפים אלה שכבו חולים רבים, עיוורים, פיסחים, משותקים וכדומה (כשהם מחכים שהמים יסערו, ");
INSERT INTO heblb_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","כי מדי פעם ירד מלאך ה׳ אל הברכה והסעיר את המים, והחולה הראשון שנכנס אל המים לאחר מכן נרפא). ");
INSERT INTO heblb_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","בין החולים הרבים היה אדם שסבל ממחלתו במשך שלושים ושמונה שנים. ");
INSERT INTO heblb_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","ישוע הביט באיש ומיד ידע את משך מחלתו. ”אתה רוצה להירפא?“ שאל ישוע. ");
INSERT INTO heblb_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","”איני יכול!“ השיב האיש בייאוש. ”אין מי שיעזור לי להיכנס למים בעת הסערה, ובזמן שאני מנסה להיכנס לברכה בכוחות עצמי, מישהו זריז ממני מקדים אותי ונכנס למים לפני.“ ");
INSERT INTO heblb_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","”קום, קפל את האלונקה שלך והתהלך!“ פקד ישוע. ");
INSERT INTO heblb_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","האיש נרפא מיד, עמד על רגליו, קיפל את האלונקה והלך לדרכו. מאחר שהמעשה התרחש בשבת, ");
INSERT INTO heblb_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","לא מצא הדבר חן בעיני היהודים. ”אסור לך לשאת את האלונקה, כי שבת היום!“ קראו לעבר הנרפא. ");
INSERT INTO heblb_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","”האיש שריפא אותי פקד עלי לקפל את האלונקה וללכת“, ענה האיש. ");
INSERT INTO heblb_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","”מיהו האיש הזה?“ שאלו. ");
INSERT INTO heblb_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","אך הנרפא לא יכול היה להשיב להם, כי הוא בעצמו לא ידע מי הוא כי בינתיים נעלם ישוע בקהל הרב שהיה במקום. ");
INSERT INTO heblb_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","מאוחר יותר פגש ישוע את הנרפא בבית־המקדש ואמר לו: ”עתה, לאחר שהבראת, אל תמשיך לחטוא, פן יבוא עליך משהו יותר רע.“ ");
INSERT INTO heblb_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","האיש הלך מהר וסיפר ליהודים כי ישוע הוא זה שריפא אותו. ");
INSERT INTO heblb_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","ואז החלו מנהיגי היהודים לרדוף את ישוע, מפני שחילל את השבת. ");
INSERT INTO heblb_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","אבל ישוע אמר להם: ”אבי לא הפסיק לעבוד עד עתה, ואני נוהג כמוהו!“ ");
INSERT INTO heblb_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","דבריו עוררו עוד יותר את חמת מנהיגי היהודים, והם רצו להרגו לא רק על שום שחילל את השבת, אלא גם על שקרא לאלוהים ”אביו“, ובכך השווה את עצמו לאלוהים. ");
INSERT INTO heblb_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","”הבן אינו יכול לעשות דבר בעצמו,“ אמר ישוע, ”הוא עושה רק מה שראה את אביו עושה, ובאותה דרך. ");
INSERT INTO heblb_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","כי האב אוהב את בנו ומלמד אותו את כל מעשיו, ואפילו מלמדו לעשות מעשים גדולים יותר מריפוי האיש הזה. אתם יודעים מדוע? כדי שתתפלאו ותשתוממו! ");
INSERT INTO heblb_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","הבן אף יקים מהמתים את מי שירצה, ממש כפי שעושה האב. ");
INSERT INTO heblb_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","האב לא ישפוט איש – הוא נתן לבנו את סמכות המשפט, כדי שכולם יכבדו את הבן כפי שהם מכבדים את האב. ");
INSERT INTO heblb_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","מי שאינו מכבד את הבן אינו מכבד גם את האב אשר שלח אותו. ");
INSERT INTO heblb_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","”אני מבטיח לכם שכל השומע את דברי ומאמין באלוהים אשר שלח אותי, יחיה חיי נצח ולא יישפט על חטאיו לעולם, משום שהוא כבר עבר מהמוות לחיים. ");
INSERT INTO heblb_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","אני מבטיח לכם, יגיע הזמן, ולמעשה הוא כבר הגיע, שהמתים ישמעו את קולו של בן־האלוהים – וכל השומעים יחיו. ");
INSERT INTO heblb_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","כשם שלאב עצמו יש כוח המעניק חיים, כך גם לבן יש אותו כוח, שהוא מתנת האב. ");
INSERT INTO heblb_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","כבן־האדם יש לו זכות וסמכות לשפוט את חטאיהם של כל בני־האדם. ");
INSERT INTO heblb_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","אל תתפלאו על כך, כי יבוא הזמן שכל המתים ישמעו בקבריהם את קולו של בן האלוהים, ");
INSERT INTO heblb_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","והם יקומו מקבריהם – עושי הטוב לחיי נצח, ועושי הרע למשפט. ");
INSERT INTO heblb_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","”איני שופט איש לפני התייעצות עם אבי; אני שופט רק לפי מה שהוא אומר לי. משפטי ישר וצודק, כי איני מבקש את טובת עצמי, אלא את רצון אבי שבשמים אשר שלחני. ");
INSERT INTO heblb_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","”אם אני מעיד על עצמי, תאמרו שעדותי אינה מהימנה. ");
INSERT INTO heblb_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","אולם מישהו אחר מעיד עלי – יוחנן המטביל, ואני יודע שאפשר לסמוך על דבריו. ");
INSERT INTO heblb_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","אתם שלחתם את אנשיכם אל יוחנן כדי להקשיב לדבריו, ויוחנן אמר את האמת. ");
INSERT INTO heblb_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","אל תחשבו שאני זקוק לעדות בני־אדם; אני מספר לכם כל זאת רק כדי שתאמינו ותיוושעו. ");
INSERT INTO heblb_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","”יוחנן הפיץ אור כנר דולק כדי להאיר לכם את הדרך, ולזמן קצר אף שמחתם להתענג על האור הזה. ");
INSERT INTO heblb_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","ברם יש לי עדות גדולה יותר מעדותו של יוחנן: המעשים שאני עושה. אלוהים אבי הטיל עלי לעשות את המעשים האלה, והם מוכיחים שהוא שלח אותי. ");
INSERT INTO heblb_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","האב עצמו מעיד עלי, למרות שמעולם לא שמעתם את קולו, ואת מראהו לא ראיתם. ");
INSERT INTO heblb_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","אולם דברו אינו שוכן בכם כלל, כי אתם מסרבים להאמין שאני שליחו. ");
INSERT INTO heblb_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","”אתם דורשים בכתובים מתוך תקווה למצוא בהם חיי נצח, אך הכתובים מצביעים עלי! ");
INSERT INTO heblb_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","למרות זאת אינכם רוצים לבוא אלי כדי שאעניק לכם חיי נצח. ");
INSERT INTO heblb_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","”איני לוקח כבוד ושבחים מבני־אדם ואיני דואג לדעתכם עלי, ");
INSERT INTO heblb_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","אבל אני רוצה לומר לכם שאינכם אוהבים את אלוהים. ");
INSERT INTO heblb_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","אני באתי בשם אבי ולא קיבלתם אותי; אך אם יבוא מישהו אחר בשם עצמו, כן תקבלו אותו. ");
INSERT INTO heblb_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","אין פלא שאינכם מאמינים, שכן אתם מבקשים כבוד איש מרעהו, וכלל אינכם דואגים לכבוד שחולק אלוהים. ");
INSERT INTO heblb_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","”אל תחשבו שאטען עליכם לפני אבי. משה רבנו – שבו אתם מאמינים – הוא הטוען עליכם! ");
INSERT INTO heblb_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","אילו האמנתם למשה הייתם מאמינים גם לי, שהרי הוא כתב עלי. ");
INSERT INTO heblb_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","ואם אינכם מאמינים למה שכתב משה, איני מתפלא שאינכם מאמינים לדברי.“ ");
INSERT INTO heblb_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","כעבור זמן מה חצה ישוע את ים הכינרת (הנקרא גם ימת טבריה). ");
INSERT INTO heblb_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","אנשים רבים הלכו אחריו, כי ראו כיצד ריפא את החולים. ");
INSERT INTO heblb_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","ישוע ותלמידיו עלו על אחד ההרים והתיישבו על הארץ. ");
INSERT INTO heblb_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","היה זה זמן קצר לפני חג הפסח. ");
INSERT INTO heblb_vpl VALUES ("JN6_5‏","073_6_5‏","JHN","6","5‏","6","ישוע הביט סביבו וראה את ההמונים הבאים לקראתו. ”מאין נשיג להם לחם לאכול?“ ניסה ישוע את פיליפוס, כי למעשה ידע מה עמד לעשות. ");
INSERT INTO heblb_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","”גם אם נקנה לחם באלפיים שקלים, לא יספיק לכולם!“ השיב פיליפוס. ");
INSERT INTO heblb_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","‎אַנְדְּרֵי, אחיו של שמעון פטרוס, התערב ואמר: ");
INSERT INTO heblb_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","”יש כאן ילד שבידו חמש ככרות לחם ושני דגים, אבל מה יועיל הדבר לכל האלפים האלה?“ ");
INSERT INTO heblb_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","”אמרו לכולם לשבת על האדמה“, ביקש ישוע מהסובבים אותו. כחמשת־אלפים גברים (לא כולל נשים וילדים) היו שם, וכולם התיישבו על המדשאה. ");
INSERT INTO heblb_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","ישוע לקח את ככרות הלחם, הודה לאלוהים, הגיש אותן לתלמידיו, והתלמידים הגישו לכל האנשים. ישוע עשה את אותו הדבר עם הדגים, וכולם אכלו לשובע. ");
INSERT INTO heblb_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","”אספו בבקשה את הפירורים שנשארו,“ ביקש ישוע, ”כדי שדבר לא ייזרק.“ ");
INSERT INTO heblb_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","התלמידים אספו את הפירורים מחמש ככרות הלחם ומילאו בהם שנים־עשר סלים. ");
INSERT INTO heblb_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","כשראה ההמון את הנס הזה, קרא: ”זהו באמת הנביא שציפינו לו!“ ");
INSERT INTO heblb_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","ישוע ידע שהם היו מוכנים לאחוז בו בכוח ולהכתירו למלך, ומשום כך שוב נמלט לבדו אל אחד ההרים. ");
INSERT INTO heblb_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","בערב ירדו התלמידים לים ");
INSERT INTO heblb_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ונכנסו לסירה, כשפניהם מועדות לכפר־נחום. הלילה ירד, וישוע עדיין לא שב אליהם. ");
INSERT INTO heblb_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","בינתיים פרצה סערה בים, כי נשבה רוח חזקה. ");
INSERT INTO heblb_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","התלמידים חתרו במשוטיהם כחמישה קילומטרים, ולפתע ראו את ישוע פוסע לקראתם על־פני המים. פחד אחז אותם, ");
INSERT INTO heblb_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","אולם ישוע הרגיעם: ”זה אני, ישוע, אל תפחדו.“ ");
INSERT INTO heblb_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","הם אספו אותו אל הסירה ומיד הגיעו אל יעדם. ");
INSERT INTO heblb_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","למחרת התקהלו אנשים רבים במקום שישוע חולל את נס הלחם. הם המתינו לישוע, כי לא ראו אותו עוזב את המקום עם תלמידיו בסירה. ");
INSERT INTO heblb_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","בינתיים הגיעו אל המקום גם סירות אחרות מטבריה. ");
INSERT INTO heblb_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","כשנוכחו האנשים כי ישוע איננו שם, הם עלו לסירות והפליגו לכפר־נחום כדי לחפש אותו. ");
INSERT INTO heblb_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","הם מצאו אותו בכפר־נחום ושאלו בתמיהה: ”רבי, כיצד הגעת הנה?“ ");
INSERT INTO heblb_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","”האמת היא שאתם רוצים להיות בחברתי מפני שאכלתם לשובע, ולא מפני שאתם מאמינים בי ובאותותיי!“ השיב להם ישוע. ");
INSERT INTO heblb_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","”אל תעמלו בעד המזון אשר כלה ונגמר, כי אם הקדישו את זמנכם למזון החיים שאותו תקבלו מבן־האדם, כי לשם כך שלח אותי האלוהים אבי.“ ");
INSERT INTO heblb_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","”מה עלינו לעשות כדי למצוא־חן בעיני אלוהים?“ שאלו. ");
INSERT INTO heblb_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","”אלוהים רוצה שתאמינו במי שהוא שלח אליכם“, השיב ישוע. ");
INSERT INTO heblb_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","”אם ברצונך שנאמין כי אתה המשיח, עליך להראות לנו עוד נסים ונפלאות. ");
INSERT INTO heblb_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","אבותינו אכלו יום יום את המן במדבר כמו שכתוב: ’ודגן־שמים נתן להם‘.“ ");
INSERT INTO heblb_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","אולם ישוע הסביר: ”אני אומר לכם שלא משה נתן לכם את הלחם מהשמים, אלא אבי הוא שנותן לכם את הלחם האמתי מהשמים. ");
INSERT INTO heblb_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","הלחם האמתי הוא זה שנשלח מהשמים על־ידי אלוהים, והוא מעניק חיים לעולם.“ ");
INSERT INTO heblb_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","”אדון,“ קראו, ”תן לנו תמיד את הלחם הזה!“ ");
INSERT INTO heblb_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","”אני הוא לחם החיים“, אמר ישוע. ”כל הבא אלי לא ירעב לעולם. כל המאמין בי לא יצמא לעולם. ");
INSERT INTO heblb_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","אבל הבעיה היא שאינכם מאמינים גם לאחר שראיתם אותי. ");
INSERT INTO heblb_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","אולם אחדים יבואו אלי ויאמינו בי – אלה שאבי נתן לי – ואני מבטיח שלא אדחה איש, ");
INSERT INTO heblb_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","כי באתי לכאן מהשמים לעשות את רצונו של האלוהים אשר שלחני, ולא את רצוני. ");
INSERT INTO heblb_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","”האב אשר שלח אותי רוצה שלא אאבד איש מאלה שנתן לי, אלא שאקים את כולם לתחייה ביום האחרון. ");
INSERT INTO heblb_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","זהו רצונו: שכל הרואה אותי ומאמין בי יחיה חיי נצח, ואני אקימו לתחייה ביום האחרון.“ ");
INSERT INTO heblb_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","היהודים רגזו עליו משום שטען כי הוא הלחם היורד מן השמים. ");
INSERT INTO heblb_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","”אילו שטויות הוא מדבר?“ שאלו. ”הלא הוא ישוע בן־יוסף; אנחנו מכירים היטב את כל משפחתו! איך הוא מעז לטעון שהוא בא מהשמים?“ ");
INSERT INTO heblb_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","”אל תתרגזו על דברי אלה“, ביקש ישוע. ");
INSERT INTO heblb_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","”רק מי שאלוהים שולח יוכל לבוא אלי, ואני אקימו לתחייה ביום האחרון. ");
INSERT INTO heblb_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","הלא כתוב בספרי הנביאים: ’וכל בניך למודי ה׳‘. ואמנם, כל השומע לקול אלוהים ולומד את האמת על אודותיו, יבוא אלי. ");
INSERT INTO heblb_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","לא שמישהו ראה את האלוהים; אני לבדי ראיתי אותו, שהרי הוא שלח אותי. ");
INSERT INTO heblb_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","”אני אומר לכם באמת, כל המאמין בי יחיה חיי נצח. ");
INSERT INTO heblb_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","אני הוא לחם החיים. ");
INSERT INTO heblb_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","אבותיכם אכלו את המן במדבר ומתו. ");
INSERT INTO heblb_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","אולם מי שאוכל מלחם החיים, היורד מהשמים, יחיה חיי נצח ולא ימות. ");
INSERT INTO heblb_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","אנוכי לחם החיים היורד מהשמים; כל האוכל מהלחם הזה יחיה לנצח. אני נותן את בשרי כלחם כדי שהעולם יחיה.“ ");
INSERT INTO heblb_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","”איך הוא יכול לתת לנו לאכול את בשרו?“ החלו היהודים להתווכח ביניהם. ");
INSERT INTO heblb_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","”אני אומר לכם ברצינות,“ המשיך ישוע, ”אם לא תאכלו את בשר המשיח ולא תשתו את דמו, אין לכם חיים בקרבכם! ");
INSERT INTO heblb_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","אולם כל האוכל את בשרי ושותה את דמי חי חיי נצח, ואני אקימו לתחייה ביום האחרון. ");
INSERT INTO heblb_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","כי בשרי הוא מזון אמתי, ודמי הוא משקה אמתי. ");
INSERT INTO heblb_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","כל האוכל את בשרי ושותה את דמי חי בי, ואני חי בו. ");
INSERT INTO heblb_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","כל הניזון ממני חי בזכותי, כשם שאבי החי שלח אותי ואני חי בזכותו. ");
INSERT INTO heblb_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","אני הלחם האמתי היורד מהשמים – לא כמו המן שאכלו אבותינו במדבר ומתו. כל האוכל את הלחם הזה יחיה לנצח.“ ");
INSERT INTO heblb_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","ישוע לימד אותם דברים אלה בבית־הכנסת בכפר־נחום. ");
INSERT INTO heblb_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","אפילו תלמידיו אמרו: ”קשה לקבל את מה שהוא אומר. איך אפשר להאמין בזה?“ ");
INSERT INTO heblb_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","ישוע חש בלבו שתלמידיו התלוננו על דבריו. ”מה מטריד אתכם?“ שאל אותם. ");
INSERT INTO heblb_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","”מה תגידו אם תראו את בן־האדם עולה חזרה לשמים? ");
INSERT INTO heblb_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","רק רוח אלוהים מעניק חיים; בכוחו של האדם אין כל תועלת. הדברים שאמרתי לכם הם דברי רוח וחיים. ");
INSERT INTO heblb_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","אך בכל זאת יש ביניכם כאלה שאינם מאמינים.“ ישוע אמר זאת מפני שידע מראש מי לא יאמין בו ומי יסגיר אותו. ");
INSERT INTO heblb_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","”משום כך אמרתי לכם שאיש אינו יכול לבוא אלי אלא אם זה מעשה מידי אלוהים“, הסביר ישוע. ");
INSERT INTO heblb_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","באותו יום עזבו אותו תלמידים רבים. ");
INSERT INTO heblb_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","”האם גם אתם רוצים לעזוב אותי?“ שאל ישוע את שנים־עשר תלמידיו. ");
INSERT INTO heblb_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","”אדוני, לאן נלך ולמי?“ קרא שמעון פטרוס. ”רק לך יש דברים של חיי נצח, ");
INSERT INTO heblb_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","ואנחנו יודעים ומאמינים שאתה קדוש האלוהים!“ ");
INSERT INTO heblb_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","השיב להם ישוע: ”אני בחרתי בכם בעצמי – שנים־עשר במספר – ובכל זאת, אחד מכם הוא שטן.“ ");
INSERT INTO heblb_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","הוא התכוון ליהודה בן־שמעון איש־קריות, אחד משנים־עשר התלמידים, שעמד להסגירו. ");
INSERT INTO heblb_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","לאחר מכן חזר ישוע לגליל ועבר מכפר לכפר. הוא לא רצה לשוב ליהודה, כי מנהיגי היהודים שם רצו להרגו. ");
INSERT INTO heblb_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","בהתקרב חג הסוכות ");
INSERT INTO heblb_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","האיצו בו אחיו לעלות לירושלים לרגל החג. ”לך ליהודה, כדי שגם תלמידיך יראו את הנסים שאתה מחולל“, לעגו לו. ");
INSERT INTO heblb_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","”איך אתה רוצה להתפרסם בעודך מסתתר כאן? אם אתה מחולל ניסים ונפלאות, גלה את עצמך לעולם.“ ");
INSERT INTO heblb_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","גם אחיו לא האמינו בו. ");
INSERT INTO heblb_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","”עדיין לא הגיע הזמן שאלך, אולם אתם יכולים ללכת בכל זמן שתרצו“, השיב ישוע. ");
INSERT INTO heblb_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","”כי העולם אינו יכול לשנוא אתכם, אבל הוא שונא אותי, משום שאני מוכיח אותו במעשיו המושחתים. ");
INSERT INTO heblb_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","לכו אתם לחוג את החג בירושלים. איני הולך עתה, כי טרם הגיע זמני.“ ");
INSERT INTO heblb_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","וישוע נשאר בגליל. ");
INSERT INTO heblb_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","אולם לאחר שהלכו אחיו הלך גם ישוע לירושלים, אם כי בסתר, כדי שלא יכירו אותו. ");
INSERT INTO heblb_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","בינתיים חיפשוהו המנהיגים בין החוגגים וחקרו: ”היכן הוא?“ ");
INSERT INTO heblb_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","דעת הקהל הייתה חלוקה עליו; אחדים אמרו: ”הוא אדם נפלא!“ ואילו אחרים טענו: ”הוא רמאי!“ ");
INSERT INTO heblb_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","אך איש לא העז להשמיע את דעתו עליו ברבים, מפחד מנהיגי היהודים. ");
INSERT INTO heblb_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","בעיצומו של החג הלך ישוע לבית־המקדש ולימד את העם. ");
INSERT INTO heblb_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","”כיצד הוא יודע כל־כך הרבה?“ תמהו היהודים. ”הרי הוא לא למד אף פעם בבית מדרש!“ ");
INSERT INTO heblb_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","”איני מלמד אתכם את תורתי, כי אם את תורת האלוהים אשר שלחני“, השיב ישוע. ");
INSERT INTO heblb_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","”מי שרוצה לעשות את רצון האלוהים יודע אם אני מדבר בשם אלוהים או בשם עצמי. ");
INSERT INTO heblb_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","מי שמשמיע את דעתו האישית מצפה לשבחים ותהילה, אולם מי שרוצה בכבוד שולחו הוא אדם ישר ונאמן. ");
INSERT INTO heblb_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","משה נתן לכם את התורה אבל איש מביניכם אינו מקיים את התורה. מדוע אתם רוצים להרוג אותי על הפרת התורה?“ ");
INSERT INTO heblb_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","”היצאת מדעתך“, קרא הקהל. ”מי רוצה להרוג אותך?“ ");
INSERT INTO heblb_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","”אני עשיתי נס אחד בשבת וכולכם התפלאתם והשתוממתם על כך“, אמר ישוע. ");
INSERT INTO heblb_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","”אבל גם אתם עובדים בשבת! הרי אתם עושים ברית־מילה לפי מצוות משה, מצוה שניתנה לנו למעשה מהאבות וקדמה לתורת משה, גם בשבת. ");
INSERT INTO heblb_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","אם אתם מתירים קיום ברית־מילה בשבת, כדי לא להפר את התורה, מדוע אתם מתרגזים על שריפאתי מישהו בשבת? ");
INSERT INTO heblb_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","אל תשפטו רק לפי מה שאתם רואים בעיניכם, אלא בחנו ושפטו בצדק!“ ");
INSERT INTO heblb_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","אחדים מתושבי ירושלים שאלו: ”האם אין זה האיש שהם רוצים להרוג? ");
INSERT INTO heblb_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","הנה הוא מדבר בציבור ואיש אינו פוגע בו. אולי מנהיגינו הגיעו למסקנה שהוא באמת המשיח! ");
INSERT INTO heblb_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","אולם כיצד ייתכן הדבר? הרי אנחנו יודעים מאין בא, ואילו המשיח אמור לבוא מאי־שם, ממקום בלתי ידוע.“ ");
INSERT INTO heblb_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","”ודאי שיודעים אתם מי אני ומאין באתי,“ קרא ישוע בקול בבית־המקדש, ”אבל דעו לכם שלא באתי אליכם על דעת עצמי, אלא נשלחתי על־ידי האלוהים שאותו אינכם מכירים. ");
INSERT INTO heblb_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","אולם אני מכיר אותו, כי אני בא ממנו והוא שלח אותי.“ ");
INSERT INTO heblb_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","ההמון רצה לתפוס אותו, אך איש לא הרים עליו אצבע, כי טרם הגיע זמנו. ");
INSERT INTO heblb_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","אנשים רבים מן העם האמינו בישוע, ואמרו: ”לאילו ניסים מצפים אתם מהמשיח שאדם זה לא חולל?“ ");
INSERT INTO heblb_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","כאשר נוכחו הפרושים כי העם נוטה להאמין בישוע, הם שלחו יחד עם ראשי הכוהנים סוכנים לתפוס אותו. ");
INSERT INTO heblb_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","אולם ישוע אמר להם: ”אני אהיה אתכם עוד זמן־מה, ואחר כך אחזור לשולחי. ");
INSERT INTO heblb_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","תחפשו אותי ולא תמצאוני, כי לא תוכלו לבוא אל המקום שאהיה בו.“ ");
INSERT INTO heblb_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","היהודים נבוכו מדבריו. ”לאן הוא עומד ללכת?“ תמהו. ”אולי בכוונתו לעזוב את הארץ וללכת ללמד את היהודים בתפוצות או אף את הגויים! ");
INSERT INTO heblb_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","למה התכוון כשאמר כי נחפש אותו ולא נוכל למצוא אותו, ואף לא נוכל לבוא למקום הימצאו?“ ");
INSERT INTO heblb_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","ביום האחרון והגדול של החג עמד ישוע וקרא בקול: ”כל הצמא שיבוא אלי וישתה! ");
INSERT INTO heblb_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","כי כמו שכתוב, המאמין בי, יזרמו מקרבו נהרות מים חיים.“ ");
INSERT INTO heblb_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","ישוע התכוון לרוח הקודש שהמאמינים בשמו היו עתידים לקבל. עד לאותו זמן לא ניתן רוח הקודש, כי ישוע עדיין לא נתפאר ולא חזר לשמים. ");
INSERT INTO heblb_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","אנשים רבים בהמון קראו לאחר ששמעו את דבריו: ”הוא באמת הנביא!“ ");
INSERT INTO heblb_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","אחרים קראו: ”זהו המשיח!“ היו שלגלגו: ”האם המשיח יבוא מהגליל? ");
INSERT INTO heblb_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","הלא כתוב כי המשיח יהיה מזרע דוד וכי יבוא מבית לחם, עיר דוד.“ ");
INSERT INTO heblb_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","דעת הקהל עליו הייתה חלוקה. ");
INSERT INTO heblb_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","אחדים מהם רצו לתפסו, אך איש לא שלח בו יד. ");
INSERT INTO heblb_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","אנשי החוק שנשלחו לאסרו חזרו אל שולחיהם בידיים ריקות. ”היכן הוא? מדוע לא הבאתם אותו?“ שאלו הפרושים וראשי הכוהנים. ");
INSERT INTO heblb_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","”הוא דיבר דברים נפלאים כל־כך; מעולם לא שמענו דברים כאלה!“ השיבו. ");
INSERT INTO heblb_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","”גם אתם הלכתם שולל?“ כעסו הפרושים. ");
INSERT INTO heblb_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","”האם ראיתם מישהו בינינו, המנהיגים או הפרושים, אשר מאמין כי הוא המשיח? ");
INSERT INTO heblb_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","רק ההמון מקרב העם הזה מאמין בו, כי הם אינם יודעים את התורה. ארורים הם!“ ");
INSERT INTO heblb_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","נקדימון היה ביניהם; הוא זה שבא אל ישוע בלילה, וכששמע את דברי הפרושים אמר: ");
INSERT INTO heblb_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","”האם תורתנו מתירה לנו לשפוט אדם לפני ששמענו מה בפיו וידענו מה שהוא עושה?“ ");
INSERT INTO heblb_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","”גם אתה מהגליל?“ שאלו בלעג. ”דרוש בכתובים וראה שאף נביא אינו בא מהגליל!“ ");
INSERT INTO heblb_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","בזאת הם נפרדו והלכו איש לביתו. ");
INSERT INTO heblb_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","ישוע הלך להר הזיתים, ");
INSERT INTO heblb_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","אולם למחרת בבוקר חזר לבית־המקדש. עד מהרה התאספו סביבו אנשים רבים והוא החל ללמד אותם. ");
INSERT INTO heblb_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","בעודו מלמד הביאו אליו הסופרים והפרושים אישה שנתפסה במעשה ניאוף, והעמידו אותה לפני הקהל. ");
INSERT INTO heblb_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","”רבי, אישה זאת נתפסה במעשה ניאוף,“ אמרו, ");
INSERT INTO heblb_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","”ותורת משה מצווה עלינו לרגום באבנים נשים כאלה. מה דעתך?“ ");
INSERT INTO heblb_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","הם רצו לנסות את ישוע, שכן חיפשו סיבה להכשיל ולהרשיע אותו. אולם ישוע התכופף וצייר באצבעו על הקרקע. ");
INSERT INTO heblb_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","כשהאיצו בו הסופרים והפרושים להשיב לשאלתם, הזדקף ישוע ואמר: ”מי שלא חטא מעולם ישליך בה את האבן הראשונה!“ ");
INSERT INTO heblb_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","הוא התכופף שוב והמשיך לצייר באצבעו על הקרקע. ");
INSERT INTO heblb_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","כל השומעים נמלאו בושה, ובזה אחר זה עזבו את המקום, מזקן עד צעיר, וישוע נותר לבדו עם האישה. ");
INSERT INTO heblb_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","ישוע נשא את ראשו וראה שנותר לבדו עם האישה. ”היכן מאשימיך? האם הרשיע אותך מישהו?“ שאל אותה. ");
INSERT INTO heblb_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","”לא אדוני“, השיבה האישה. ”אם כן גם אני לא ארשיע אותך. לכי לשלום ואל תחטאי יותר.“ ");
INSERT INTO heblb_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","ישוע דיבר שוב אל העם: ”אני אור העולם. כל ההולך אחרי לא יתעה שוב בחשכה, אלא יקבל את אור החיים“. ");
INSERT INTO heblb_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","”אתה סתם מתפאר בעצמך ודבריך אינם מוכיחים דבר!“ קראו לעברו הפרושים. ");
INSERT INTO heblb_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","”אני אמנם מעיד על עצמי, אולם דברי נכונים, שכן אני יודע מאין באתי ולאן אני הולך. ");
INSERT INTO heblb_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","אתם שופטים אותי לפי קנה־המידה של העולם, ואילו אני איני שופט איש עתה. ");
INSERT INTO heblb_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","אם אני בכל זאת שופט, אני שופט בצדק, כי איני מחליט על דעת עצמי; אני מתייעץ עם אלוהים האב אשר שלח אותי. ");
INSERT INTO heblb_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","התורה אומרת כי על־פי שני עדים יקום דבר, לא כן? ");
INSERT INTO heblb_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","ובכן, אני עד אחד, ואבי אשר שלחני הוא העד השני.“ ");
INSERT INTO heblb_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","”היכן אביך?“ שאלו אותו. ”אינכם יודעים מיהו אבי, מפני שאינכם יודעים מי אני. לו היכרתם אותי הייתם מכירים גם את אבי.“ ");
INSERT INTO heblb_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","ישוע דיבר דברים אלה באגף האוצר בבית־המקדש, אולם איש לא אסר אותו, כי טרם הגיע המועד. ");
INSERT INTO heblb_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","”אני הולך מכאן“, המשיך ישוע. ”אתם תחפשו אותי ותמותו בחטאיכם. אינכם יכולים לבוא למקום שאליו אני הולך.“ ");
INSERT INTO heblb_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","”האם הוא עומד להתאבד?“ תמהו היהודים. ”למה הוא מתכוון באמרו: ’אינכם יכולים לבוא למקום שאליו אני הולך‘?“ ");
INSERT INTO heblb_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","ישוע הסביר להם: ”מקומי בשמים מעל, ואילו מקומכם בארץ למטה; אתם שייכים לעולם הזה, ואני איני מהעולם הזה. ");
INSERT INTO heblb_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","משום כך אמרתי לכם שתמותו בחטאיכם; אם לא תאמינו שאני הוא תמותו בחטאיכם.“ ");
INSERT INTO heblb_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","”מי אתה?“ שאלו. ”אני הוא זה שאמרתי לכם כל הזמן“, השיב ישוע. ");
INSERT INTO heblb_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","”יש לי הרבה דברים לומר עליכם, לשפוט ולהרשיע אתכם, אך איני עושה זאת. אני מוסר לכם אך ורק מה שנאמר לי על־ידי שולחי, שהוא האמת.“ ");
INSERT INTO heblb_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","והם עדיין לא הבינו שהוא התכוון לאלוהים. ");
INSERT INTO heblb_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","ישוע המשיך: ”כאשר תרימו את בן־האדם (על הצלב), תדעו ותבינו שאני הוא המשיח ושאיני עושה דבר על דעת עצמי, אלא אני מספר לכם מה שלימד אותי אבי. ");
INSERT INTO heblb_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","שולחי תמיד איתי; הוא לא נטש אותי, כי אני עושה תמיד את הטוב בעיניו.“ ");
INSERT INTO heblb_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","כשדיבר ישוע דברים אלה, יהודים רבים האמינו שהוא המשיח. ");
INSERT INTO heblb_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","על כן הוא אמר להם: ”אם תקיימו את דברי תהיו תלמידי באמת. ");
INSERT INTO heblb_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","אתם תדעו את האמת, והאמת תוציא אתכם לחופשי!“ ");
INSERT INTO heblb_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","”זרע אברהם אנחנו,“ קראו היהודים לעומתו, ”ומעולם לא היינו עבדים לאיש. כיצד, אם כן, אתה אומר שנהיה בני־חורין?“ ");
INSERT INTO heblb_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","”אני אומר לכם במלוא האמת,“ ענה ישוע, ”כל מי שחוטא הוא עבד לחטא, ");
INSERT INTO heblb_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","ולעבד אין כל זכויות, בעוד שלבן יש את כל הזכויות. ");
INSERT INTO heblb_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","לכן, אם הבן מוציא אתכם לחופשי, תהיו חופשיים באמת! ");
INSERT INTO heblb_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","אני יודע שזרע אברהם אתם, אולם יש ביניכם אחדים שרוצים להרוג אותי, מפני שאינם יכולים לסבול את דברי. ");
INSERT INTO heblb_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","אני מספר לכם את מה שראיתי אצל אבי, ואילו אתם עושים את מה שראיתם אצל אביכם.“ ");
INSERT INTO heblb_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","”אברהם הוא אבינו!“ השיבו היהודים. אולם ישוע השיב: ”אילו הייתם בני אברהם, הייתם נוהגים כמוהו. ");
INSERT INTO heblb_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","אולם עתה מבקשים אתם להרוג אותי על שסיפרתי לכם את האמת אשר שמעתי מאלוהים. אברהם מעולם לא היה עושה דבר כזה! ");
INSERT INTO heblb_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","ואילו אתם עושים את מעשי אביכם האמתי.“ ”אין אנו ממזרים! יש לנו אב אחד – האלוהים!“ טענו. ");
INSERT INTO heblb_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","אולם ישוע המשיך: ”אילו אלוהים היה באמת אביכם, אזי הייתם אוהבים אותי, שהרי באתי אליכם מאת האלוהים. לא באתי על דעת עצמי – אלוהים שלח אותי. ");
INSERT INTO heblb_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","האם אתם יודעים מדוע אינכם מבינים את דברי? מפני שאינכם מסוגלים להקשיב לי. ");
INSERT INTO heblb_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","השטן הוא אביכם, ואתם רוצים לעשות את חפצו! הוא היה רוצח ונשאר רוצח; הוא שונא את האמת, כי אין בו שמץ של אמת; כל דבריו הם שקר בכוונה תחילה, שהרי הוא מלך השקרים. ");
INSERT INTO heblb_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","אינכם מאמינים לי משום שאני אומר את האמת. ");
INSERT INTO heblb_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","האם יכול מישהו מכם להוכיח אותי על איזשהו עוון? ואם אני אומר את האמת, מדוע אינכם מאמינים לי? ");
INSERT INTO heblb_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","ילדי האלוהים מקשיבים בשמחה לקול אביהם, אולם אתם אינכם מקשיבים, כי אינכם ילדי האלוהים!“ ");
INSERT INTO heblb_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","”בצדק קראנו לך שומרוני!“ קראו בחזרה בחימה. ”שד נכנס בך!“ ");
INSERT INTO heblb_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","”לא נכנס בי שד“, ענה ישוע. ”אתם לועגים ובזים לי רק מפני שאני מכבד את אבי. ");
INSERT INTO heblb_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","איני מבקש כבוד לעצמי, אולם אלוהים אבי דורש זאת למעני, והוא ישפוט את מי שאינו מאמין בי. ");
INSERT INTO heblb_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","אני אומר לכם ברצינות ובכנות: מי שישמע בקולי לא ימות לעולם!“ ");
INSERT INTO heblb_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","”עכשיו אנחנו בטוחים שנכנס בך שד“, אמרו לו. ”אפילו אברהם והנביאים מתו, ואילו אתה טוען שכל השומע בקולך לא ימות לעולם? ");
INSERT INTO heblb_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","האם אתה גדול וחזק מאברהם אבינו או מהנביאים? למי אתה חושב את עצמך?“ ");
INSERT INTO heblb_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","”אם אני מכבד את עצמי, אין לכך כל ערך“, אמר ישוע. ”אולם אבי מכבד אותי – כן, האב אשר אתם קוראים לו אלוהיכם ");
INSERT INTO heblb_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","למרות אינכם מכירים אותו. אולם אני מכיר אותו, ואם אכחיש זאת אהיה לשקרן כמוכם. אני באמת מכיר אותו ושומע בקולו. ");
INSERT INTO heblb_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","אברהם אביכם שש לראות את יום בואי; הוא ראה אותו ושמח.“ ");
INSERT INTO heblb_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","”איך יכולת לראות את אברהם?“ שאלו היהודים בחוסר אמון. ”לא מלאו לך עדיין חמישים שנה אפילו!“ ");
INSERT INTO heblb_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","”אמן אומר אני לכם, עוד לפני שאברהם נולד, אני הוא!“ השיב ישוע. ");
INSERT INTO heblb_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","דבריו עוררו את חמתם, והם החלו להשליך עליו אבנים. אולם ישוע נעלם מעיניהם, עבר על פניהם ויצא מהמקדש. ");
INSERT INTO heblb_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","ישוע עבר בדרך וראה איש שהיה עיוור מלידה. ");
INSERT INTO heblb_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","”רבי,“ שאלו תלמידיו, ”מדוע נולד האיש עיוור, בגלל חטאיו שלו או של הוריו?“ ");
INSERT INTO heblb_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","”לא בגלל חטאיו ולא בגלל חטאי הוריו“, השיב ישוע. ”אדם זה נולד עיוור על־מנת שאלוהים יוכל לגלות בו את כוחו וגבורתו. ");
INSERT INTO heblb_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","עלינו למהר לעשות לאור היום את מה שהטיל עלינו שולחי, כי תוך זמן קצר יבוא הלילה, ואז לא יוכל איש לעשות דבר. ");
INSERT INTO heblb_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","כל עוד אני בעולם, אני אור העולם – אני מעניק לו את אורי.“ ");
INSERT INTO heblb_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","ישוע ירק על הארץ, עשה משחה מהרוק ומרח אותה על עיני העיוור. ");
INSERT INTO heblb_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","”לך לשטוף את עיניך בבריכת השילוח“, אמר לו ישוע. העיוור הלך לשטוף את עיניו ושב למקום בעיניים פקוחות ובריאות. ");
INSERT INTO heblb_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","שכנים ואנשים שהכירו אותו כקבצן עיוור שאלו זה את זה: ”האם זהו אותו קבצן עיוור?“ ");
INSERT INTO heblb_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","אחדים השיבו: ”כן.“ ואחדים אמרו: ”לא. לא ייתכן שזהו אותו אדם“, הרהרו בקול. ”אבל הוא באמת דומה לו כשתי טיפות מים!“ הקבצן בא לעזרתם וקרא ”אני האיש!“ ");
INSERT INTO heblb_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","”כיצד אתה יכול לראות? מה קרה לך?“ שאלו. ");
INSERT INTO heblb_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","והקבצן סיפר להם: ”אדם בשם ישוע מרח משחה על עיני, ואמר לי לשטוף אותן בבריכת השילוח. עשיתי כדבריו ואני יכול לראות!“ ");
INSERT INTO heblb_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","”היכן האיש הזה עכשיו?“ שאלו האנשים. ”איני יודע“, השיב הקבצן. ");
INSERT INTO heblb_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","ואז הם לקחו את הקבצן אל הפרושים ");
INSERT INTO heblb_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","(כל זה התרחש בשבת). ");
INSERT INTO heblb_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","”כיצד נפקחו עיניך?“ שאלו הפרושים. והקבצן סיפר להם כיצד ישוע מרח משחה על עיניו ושלחו לשטוף אותן בבריכת השילוח. ");
INSERT INTO heblb_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","אחדים מהפרושים החליטו: ”האיש הזה, ישוע, אינו יכול לבוא מן האלוהים, מאחר שאין הוא שומר את השבת.“ אחרים טענו: ”אבל כיצד יכול אדם חוטא לחולל ניסים כאלה?“ מחלוקת קשה התפתחה ביניהם. ");
INSERT INTO heblb_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","הפרושים פנו אל הקבצן ושאלו: ”מה דעתך על האיש שריפא אותך?“ ”אני חושב שהוא נביא שנשלח על־ידי אלוהים“, השיב הקבצן. ");
INSERT INTO heblb_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","מנהיגי היהודים לא האמינו שהקבצן היה באמת עיוור ושעתה נרפא, ומשום כך הלכו לברר את הדבר אצל הוריו. ");
INSERT INTO heblb_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","”האם זהו בנכם?“ שאלו. ”האם הוא באמת נולד עיוור? אם כן, כיצד הוא יכול לראות עתה?“ ");
INSERT INTO heblb_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","אולם ההורים השיבו: ”אנחנו יודעים כי זהו בננו וכי נולד עיוור, ");
INSERT INTO heblb_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","אך איננו יודעים כיצד הוא יכול לראות, או מי ריפא אותו. הוא אדם מבוגר ויכול לדבר בעד עצמו“, שאלו אותו. ");
INSERT INTO heblb_vpl VALUES ("JN9_22‏","073_9_22‏","JHN","9","22‏","23","ההורים ענו כך כי חששו ממנהיגי היהודים, אשר איימו לגרש מקהל ישראל את כל המודה שישוע הוא המשיח. ");
INSERT INTO heblb_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","שוב קראו היהודים לקבצן שהיה עיוור ואמרו: ”עליך להודות לאלוהים ולא לישוע, כי כולנו יודעים שהוא איש חוטא.“ ");
INSERT INTO heblb_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","”איני יודע אם הוא חוטא או לא,“ השיב הקבצן, ”אבל דבר אחד אני יודע: הייתי עיוור ועכשיו אני רואה!“ ");
INSERT INTO heblb_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","”מה הוא עשה? כיצד ריפא אותך?“ דרשו. ");
INSERT INTO heblb_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","”כבר סיפרתי לכם. האם לא שמעתם? מדוע אתם מבקשים שאספר לכם בשנית, האם גם אתם רוצים להיות תלמידיו?“ שאל הקבצן. ");
INSERT INTO heblb_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","הם קללו אותו ואמרו: ”אתה תלמידו! אנחנו תלמידיו של משה רבנו! ");
INSERT INTO heblb_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","אנחנו יודעים שאלוהים דיבר אל משה, אבל איננו יודעים דבר על האיש הזה.“ ");
INSERT INTO heblb_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","”מוזר מאוד שאינכם יודעים דבר על אודות האיש שריפא את עיני“, השיב הקבצן. ");
INSERT INTO heblb_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","”אנחנו יודעים כי אלוהים אינו שומע לקול הרשעים, אך הוא מקשיב ברצון לאלה שאוהבים אותו ושומעים בקולו. ");
INSERT INTO heblb_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","מאז בריאת העולם לא שמענו על אדם שריפא עיוורון מלידה. ");
INSERT INTO heblb_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","אילו אדם זה לא בא מאלוהים, הוא לא היה מסוגל לעשות מאומה!“ ");
INSERT INTO heblb_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","”ממזר שכמוך!“ קראו לעברו בזעם. ”אתה מתיימר ללמד אותנו?“ והם גרשוהו החוצה. ");
INSERT INTO heblb_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","כאשר שמע ישוע את הדבר, הוא פגש בקבצן ושאל אותו: ”האם אתה מאמין בבן האדם?“ ");
INSERT INTO heblb_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","”מיהו?“ שאל האיש. ”אני רוצה להאמין בו.“ ");
INSERT INTO heblb_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","”ראית אותו, והוא מדבר אליך כרגע“ השיב ישוע. ");
INSERT INTO heblb_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","”כן, אדוני,“ קרא האיש, ”אני מאמין!“ והוא השתחווה לישוע. ");
INSERT INTO heblb_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","”אני באתי לעולם לשם משפט – להעניק ראייה לעיוורים, ולהוכיח לאלה שחושבים את עצמם לפיקחים שהם למעשה עיוורים“, אמר ישוע. ");
INSERT INTO heblb_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","הפרושים שעמדו שם שאלו: ”האם אתה כולל אותנו בין העיוורים?“ ");
INSERT INTO heblb_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","”אילו הייתם עיוורים לא הייתם אשמים“, הסביר ישוע. ”אולם אתם טוענים שאתם רואים, ולכן אתם אשמים.“ ");
INSERT INTO heblb_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","”אני אומר לכם באמת,“ המשיך ישוע, ”מי שמסרב להיכנס למכלאת הצאן דרך השער, ובוחר להיכנס בדרך הצדדית, הוא גנב או שודד. ");
INSERT INTO heblb_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","האדם שנכנס דרך השער הוא רועה הצאן. ");
INSERT INTO heblb_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","השומר יפתח לו את השער, עדר הצאן ישמע ויכיר את קולו, והרועה יוביל את הצאן החוצה כשהוא נוקב בשם כל כבשה. ");
INSERT INTO heblb_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","הרועה הולך בראש והעדר נוהר אחריו, כי הוא מזהה את הרועה ומכיר את קולו. ");
INSERT INTO heblb_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","הצאן לא תלכנה אחרי אדם זר, אלא תברחנה מפניו, כי קולו אינו מוכר להן.“ ");
INSERT INTO heblb_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","אלה ששמעו משל זה מפי ישוע לא הבינו למה התכוון, ");
INSERT INTO heblb_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","ולכן ישוע הסביר להם: ”אמן אני אומר לכם: אני השער של מכלאת הצאן. ");
INSERT INTO heblb_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","כל אלה שבאו לפני היו גנבים ושודדים, אולם הצאן לא שמעו בקולם. ");
INSERT INTO heblb_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","כן, אנוכי השער. הנכנסים דרכי יוושעו וימצאו מרעה עשיר בבואם ובצאתם. ");
INSERT INTO heblb_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","הגנב בא לגנוב, להרוג ולהשמיד, ואילו אני באתי להעניק חיים בשפע. ");
INSERT INTO heblb_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","”אני הרועה הטוב, ורועה טוב מקריב את חייו למען צאנו. ");
INSERT INTO heblb_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","כאשר רועה שכיר יראה זאב מתקרב, הוא יברח ויעזוב את הצאן לאנחות, כי העדר אינו שייך לו, והזאב יחטוף ויפזר את הצאן. ");
INSERT INTO heblb_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","הרועה השכיר יברח, משום שאינו אלא שכיר ואין הוא דואג לצאן באמת. ");
INSERT INTO heblb_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","”אני הרועה הטוב; אני מכיר את צאני והן מכירות אותי, ");
INSERT INTO heblb_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","כשם שאבי מכיר אותי ואני מכיר את אבי; ואני מקריב את חיי למען הצאן. ");
INSERT INTO heblb_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","יש לי עדר נוסף שאינו מהמכלאה הזאת. עלי להנהיג גם אותו, והצאן שומעות בקולי; כך יהיה עדר אחד ורועה אחד. ");
INSERT INTO heblb_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","”אבי אוהב אותי משום שאני מקריב את חיי כדי שאקבל אותם חזרה. ");
INSERT INTO heblb_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","איש אינו יכול להרוג אותי ללא הסכמתי. אני מקריב את חיי מרצוני, מפני שיש לי זכות וכוח להקריב את חיי כשאני רוצה בכך, ואף זכות וכוח להשיבם לעצמי. אלוהים הוא המעניק לי זכות זאת.“ ");
INSERT INTO heblb_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","דבריו אלה שוב גרמו למחלוקת בין מנהיגי היהודים. ");
INSERT INTO heblb_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","חלקם אמר: ”או שהוא יצא מדעתו, או שנכנס בו שד! מדוע אתם מקשיבים לו?“ ");
INSERT INTO heblb_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","אחרים אמרו: ”הוא אינו נשמע כמי שנכנס בו שד. האם שד יכול לפקוח עיני עיוורים?“ ");
INSERT INTO heblb_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","בחג החנוכה, בחורף, ");
INSERT INTO heblb_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","התהלך ישוע בבית־המקדש באגף הנקרא ”אולם שלמה“. ");
INSERT INTO heblb_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","היהודים הקיפוהו מכל עבר ושאלו: ”עד מתי בכוונתך לסקרן אותנו? אם אתה הוא המשיח, מדוע אינך אומר זאת בפירוש?“ ");
INSERT INTO heblb_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","”כבר אמרתי לכם, אבל לא האמנתם לי“, השיב ישוע. ”המעשים שאני עושה בשם אבי מאשרים זאת. ");
INSERT INTO heblb_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","אולם אינכם מאמינים לי, כי אינכם שייכים לצאני. ");
INSERT INTO heblb_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","אני מכיר את צאני, צאני מכירות את קולי והן הולכות אחרי. ");
INSERT INTO heblb_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","אני מעניק להן חיי נצח והן לא תאבדנה. איש לא יחטוף אותן ממני, ");
INSERT INTO heblb_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","כי אבי נתן לי אותן, והוא חזק וגיבור מכולם. משום כך לא יוכל איש לחטוף אותן ממני. ");
INSERT INTO heblb_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","אבי ואני אחד אנחנו!“ ");
INSERT INTO heblb_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","שוב החלו מנהיגי היהודים להשליך עליו אבנים. ");
INSERT INTO heblb_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","”הראיתי לכם הרבה מעשים טובים בשם אבי, איזה מהם גרם לכך שתשליכו עלי אבנים?“ שאל ישוע. ");
INSERT INTO heblb_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","”איננו משליכים עליך אבנים בגלל המעשים הטובים שעשית, אלא בגלל שאתה מגדף את האלוהים; למרות שאתה אדם, אתה עושה את עצמך לאלוהים!“ ");
INSERT INTO heblb_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","”אך הכתובים שלכם אומרים: ’אלוהים אתם‘, והכוונה היא לבני־האדם“, השיב ישוע. ");
INSERT INTO heblb_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","”אם האנשים שאליהם מדברים הכתובים מכונים ’אלוהים‘, והכתוב הוא דבר אמת, ");
INSERT INTO heblb_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","מדוע קוראים אתם ’מגדף‘ למי שקדשו האב ונשלח לעולם הזה על־ידו, ושטוען כי הוא בן האלוהים? ");
INSERT INTO heblb_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","אם איני עושה מעשים כפי שעושה אבי, אל תאמינו לי. ");
INSERT INTO heblb_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","אולם אם אני אכן עושה את מעשי אבי, האמינו לפחות למעשים גם אם אינכם מאמינים לי, ואז תשוכנעו שאבי שוכן בי ואני בו.“ ");
INSERT INTO heblb_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","הם שוב רצו לתפוס את ישוע, אולם הוא התחמק מידיהם. ");
INSERT INTO heblb_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","ישוע חזר לעבר הירדן, למקום שבו הטביל יוחנן לראשונה. הוא נשאר שם זמן־מה, ");
INSERT INTO heblb_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","ואנשים רבים הלכו אחריו. ”יוחנן לא חולל נסים,“ אמרו זה לזה, ”אולם כל מה שאמר על האיש הזה היה אמת.“ ");
INSERT INTO heblb_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","אנשים רבים במקום ההוא האמינו כי ישוע באמת המשיח. ");
INSERT INTO heblb_vpl VALUES ("JN11_1‏","073_11_1‏","JHN","11","1‏","2","איש בשם אלעזר, שגר בבית־עניה עם מרים ואחותה מרתא, חלה. אחותו מרים היא זו שמשחה את ישוע במרקחת יקרה וניגבה את רגליו בשערותיה. ");
INSERT INTO heblb_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","מרתא ומרים שלחו הודעה לישוע: ”אדוני, ידידך הטוב חולה מאוד.“ ");
INSERT INTO heblb_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","כששמע ישוע את הדבר אמר: ”מחלה זאת לא תיגמר במוות, כי אם להביא כבוד לאלוהים. כי בן האלוהים יפואר באמצעות המחלה הזאת.“ ");
INSERT INTO heblb_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","ישוע אהב מאוד את מרתא, מרים ואלעזר. ");
INSERT INTO heblb_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","כאשר ישוע שמע שאלעזר חלה, התעכב יומיים ");
INSERT INTO heblb_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","ורק לאחר מכן אמר לתלמידיו: ”הבה נחזור ליהודה.“ ");
INSERT INTO heblb_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","”אולם, רבי,“ קראו התלמידים במחאה, ”לפני ימים ספורים בלבד ניסו מנהיגי היהודים להרוג אותך, ועכשיו אתה חוזר לאותו מקום?“ ");
INSERT INTO heblb_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","”בכל יום יש שתים־עשרה שעות אור, ובמשך השעות האלה יכול כל אחד ללכת בלי ליפול או להיכשל. ");
INSERT INTO heblb_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","מי שהולך בלילה ייכשל וימעד בגלל החשכה.“ ");
INSERT INTO heblb_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","ישוע המשיך: ”חברנו אלעזר ישן, אך אני הולך להעיר אותו.“ ");
INSERT INTO heblb_vpl VALUES ("JN11_12‏","073_11_12‏","JHN","11","12‏","13","ישוע התכוון לכך שאלעזר מת, אולם תלמידיו חשבו שאמר כי אלעזר ישן במנוחה, ולכן אמרו: ”אם אלעזר ישן שינה טובה הוא ודאי יבריא!“ ");
INSERT INTO heblb_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","”אלעזר מת“, אמר להם ישוע בפירוש. ");
INSERT INTO heblb_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","”אני שמח למענכם שלא הייתי שם, כדי שתלמדו להאמין. הבה נלך אליו.“ ");
INSERT INTO heblb_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","תומא (הנקרא בשם חיבה ”התאום“) אמר לחבריו התלמידים: ”בואו נלך גם אנחנו כדי שנמות איתו.“ ");
INSERT INTO heblb_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","בהגיעם לבית־עניה נאמר להם שאלעזר מת ושהוא קבור כבר ארבעה ימים. ");
INSERT INTO heblb_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","בית־עניה מרוחקת מירושלים רק כשלושה קילומטר, ");
INSERT INTO heblb_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ויהודים רבים באו מירושלים לנחם את מרתא ומרים באבלן. ");
INSERT INTO heblb_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","כאשר שמעה מרתא שישוע היה בדרכו אליהן, הלכה לפגוש אותו, ואילו מרים נשארה בבית. ");
INSERT INTO heblb_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","”אדוני,“ אמרה מרתא לישוע, ”אילו היית כאן, אחי לא היה מת. ");
INSERT INTO heblb_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","אך עדיין לא מאוחר מדי, כי אני יודעת שכל מה שתבקש מאלוהים הוא ייתן לך.“ ");
INSERT INTO heblb_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","”אחיך יקום לחיים“, הבטיח ישוע. ");
INSERT INTO heblb_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","”כן,“ אמרה מרתא, ”עם כל האחרים בתחיית המתים ביום האחרון.“ ");
INSERT INTO heblb_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","אולם ישוע אמר לה: ”אני הוא התחייה והחיים. כל המאמין בי יחיה אפילו אם ימות. ");
INSERT INTO heblb_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","כל המאמין בי יחיה לנצח ולא ימות לעולם! האם את מאמינה לי?“ ");
INSERT INTO heblb_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","”כן, אדוני,“ השיבה, ”אני מאמינה שאתה המשיח בן־האלוהים אשר לו חיכינו זמן רב.“ ");
INSERT INTO heblb_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","כשסיימה מרתא לדבר עזבה את ישוע וחזרה למרים. מרתא קראה למרים בסתר ואמרה: ”המורה נמצא כאן; הוא רוצה לדבר איתך.“ ");
INSERT INTO heblb_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","מרים יצאה אליו מיד. ");
INSERT INTO heblb_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","ישוע נשאר עדיין מחוץ לכפר, במקום שבו פגשה אותו מרתא. ");
INSERT INTO heblb_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","היהודים שבאו לנחם את האבלות ראו את מרים עוזבת את הבית בחיפזון. הם חשבו שהיא הולכת לבכות על קבר אחיה, ולכן הלכו בעקבותיה. ");
INSERT INTO heblb_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","כאשר הגיעה מרים למקום הימצאו של ישוע, נפלה לרגליו וקראה בבכי: ”אדוני, אילו היית כאן, אחי לא היה מת.“ ");
INSERT INTO heblb_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","בכייה ובכי האבלים נגע ללבו של ישוע, וגם הוא התרגש ונאנח. ");
INSERT INTO heblb_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","”היכן קברתם אותו?“ שאל. ”בוא וראה“, ענו האנשים. ");
INSERT INTO heblb_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","ישוע בכה. ");
INSERT INTO heblb_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","”הם היו חברים טובים מאוד“, אמרו היהודים זה לזה. ”ראו עד כמה אהב אותו!“ ");
INSERT INTO heblb_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","היו שאמרו: ”אם הוא ריפא את העיוור, האם לא היה יכול גם למנוע את מותו של אלעזר?“ ");
INSERT INTO heblb_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","ישוע שוב התרגש והלך אל קברו של אלעזר. הוא נקבר במערה שאבן גדולה חסמה את פיתחה. ");
INSERT INTO heblb_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","”הזיזו את האבן“, ביקש ישוע. אולם מרתא, אחות המת, אמרה: ”אבל אדוני, הגופה ודאי מצחינה; הרי הוא קבור כבר ארבעה ימים!“ ");
INSERT INTO heblb_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","”האם לא אמרתי לך שאם תאמיני תראי את גבורת האלוהים?“ שאל ישוע. ");
INSERT INTO heblb_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","האנשים הזיזו את האבן, וישוע נשא עיניו אל השמים וקרא: ”אבי, תודה לך על שאתה שומע אותי. ");
INSERT INTO heblb_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","אני יודע שאתה שומע אותי תמיד, אולם אמרתי זאת כדי שכל הנוכחים כאן יאמינו שאתה שלחת אותי.“ ");
INSERT INTO heblb_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","לאחר מכן הוא קרא בקול רם מאוד: ”אלעזר, צא החוצה!“ ");
INSERT INTO heblb_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","ואלעזר יצא החוצה עטוף עדיין בתכריכים. ”הסירו מעליו את התכריכים ותנו לו ללכת“, אמר ישוע. ");
INSERT INTO heblb_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","יהודים רבים מבין מנחמי מרים אשר חזו בנס האמינו בישוע. ");
INSERT INTO heblb_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","אולם היו שהלכו לפרושים וסיפרו להם את הדבר. ");
INSERT INTO heblb_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","הפרושים וראשי הכוהנים כינסו אסיפה כדי לדון במצב. ”איפה הוא ואיפה אנחנו?“ שאלו זה את זה במבוכה. ”האיש הזה באמת מחולל ניסים! ");
INSERT INTO heblb_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","אם לא נאסור אותו יאמין בו כל העם וילך אחריו, וזה יהיה סופנו, כי אז יבואו הרומאים ויסירו את בית המקדש ואת עמנו!“ ");
INSERT INTO heblb_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","קייפא, הכהן הגדול באותה שנה, אמר להם: ”אינכם מבינים דבר! ");
INSERT INTO heblb_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","האינכם מבינים כי מוטב שאדם אחד ימות בעד כל העם, מאשר שכל העם ימות בעד אדם אחד? למה לסכן את העם?“ ");
INSERT INTO heblb_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","קייפא לא אמר דברים אלה ביוזמתו, אלא בהשראת אלוהים, כי בהיותו הכהן הגדול של אותה שנה ניבא שישוע ימות בעד העם. ");
INSERT INTO heblb_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","ולא רק בעד העם, אלא גם כדי לקבץ ולאחד את כל בני־האלוהים באשר הם. ");
INSERT INTO heblb_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","מאותו יום ואילך תכננו מנהיגי היהודים להרוג את ישוע, ");
INSERT INTO heblb_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","ולכן הוא הפסיק להתהלך בגלוי באזור יהודה. הוא עזב את ירושלים והחליט ללכת לעיר אפרים שבגבול המדבר, שם נשאר עם תלמידיו. ");
INSERT INTO heblb_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","בהתקרב חג הפסח עלו לירושלים יהודים רבים מכל קצות הארץ, כדי להשתתף בטקס הטהרה שקדם לחג. ");
INSERT INTO heblb_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","הם רצו לראות את ישוע, ובעמדם בבית־המקדש שאלו איש את רעהו: ”מה דעתכם, האם יבוא לחג הפסח או לא?“ ");
INSERT INTO heblb_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","בינתיים הודיעו ראשי הכוהנים והפרושים בציבור, שכל הרואה את ישוע חייב לדווח להם על כך מיד, כדי שיוכלו לאסרו. ");
INSERT INTO heblb_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","ששה ימים לפני חג הפסח שב ישוע לבית־עניה, כפרו של אלעזר שהשיבו לחיים, ");
INSERT INTO heblb_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","ונערכה לכבודו ארוחת ערב חגיגית. אלעזר ישב עם ישוע בין האורחים, ואילו מרתא שרתה את האורחים. ");
INSERT INTO heblb_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","מרים לקחה מרקחת יקרה העשויה משמנים ובשמים ריחניים, משחה את רגליו של ישוע וניגבה אותן בשערותיה, ריח הניחוח מילא את כל הבית. ");
INSERT INTO heblb_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","אחד מתלמידיו אשר עמד להסגירו, יהודה איש קריות שמו, קרא: ");
INSERT INTO heblb_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","”המרקחת הזאת שווה הרבה כסף! היא הייתה יכולה למכור אותה ולחלק את הכסף לעניים.“ ");
INSERT INTO heblb_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","הוא לא דיבר מתוך דאגה לעניים, אלא מתוך דאגה לעצמו. יהודה היה הגזבר של קבוצת התלמידים, ולעתים קרובות משך מכספי הקבוצה לצרכיו הפרטיים. ");
INSERT INTO heblb_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","”הנח לה“, אמר ישוע. ”היא עשתה זאת כהכנה לקבורתי. ");
INSERT INTO heblb_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","העניים נמצאים אתכם תמיד, ואילו אני איני נמצא אתכם תמיד.“ ");
INSERT INTO heblb_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","יהודים רבים שמעו על ביקורו של ישוע, ועל כן באו לראות אותו ואת אלעזר שהקים לתחייה. ");
INSERT INTO heblb_vpl VALUES ("JN12_10‏","073_12_10‏","JHN","12","10‏","11","בינתיים החליטו ראשי הכוהנים להרוג גם את אלעזר, כי בגללו נהרו למקום יהודים רבים והאמינו שישוע הוא המשיח. ");
INSERT INTO heblb_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","למחרת התפשטה השמועה בכל העיר שישוע היה בדרכו לירושלים. אנשים רבים מבין החוגגים ");
INSERT INTO heblb_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","לקחו בידיהם כפות תמרים, הלכו לקראת ישוע וקראו: ”יחי המשיח! יחי מלך ישראל! ברוך הבא בשם ה׳ מלך ישראל!“ ");
INSERT INTO heblb_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","ישוע בא לקראתם רכוב על חמור, ובכך קיים את הנבואה: ");
INSERT INTO heblb_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","”אל תיראי, בת ציון, הנה מלכך יבוא לך רוכב על עיר בן אתונות.“ ");
INSERT INTO heblb_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","תחילה לא הבינו תלמידיו שישוע קיים למעשה את הנבואה הזאת, אולם לאחר שישוע נתפאר בכבוד הם נזכרו במעשיו השונים אשר קיימו נבואות רבות מכתבי־הקודש. ");
INSERT INTO heblb_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","אנשים רבים בקהל אשר ראו את ישוע מקים את אלעזר לחיים, ספרו על כך לאחרים. ");
INSERT INTO heblb_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","אנשים רבים יצאו לקראתו, כי שמעו על הפלא הגדול שחולל. ");
INSERT INTO heblb_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","אולם הפרושים היו אובדי עצות. ”רואים אתם, נוצחנו. כל העולם נמשך אחריו!“ קראו. ");
INSERT INTO heblb_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","בין העולים לירושלים בחג הייתה גם קבוצת יוונים. ");
INSERT INTO heblb_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","הם הלכו לפיליפוס מבית־צידה שבגליל וביקשו: ”אדוני, אנחנו רוצים לפגוש את ישוע.“ ");
INSERT INTO heblb_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","פיליפוס מסר את ההודעה ל‎אַנְדְּרֵי, והשניים הלכו להתייעץ עם ישוע. ");
INSERT INTO heblb_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","”הגיעה השעה שיפואר בן־האדם“, אמר להם ישוע. ");
INSERT INTO heblb_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","”אני אומר לכם ברצינות: גרגר חיטה שנטמן באדמה צריך למות לפני שיוכל לשאת פרי רב, אחרת יישאר סתם גרגר בודד. ");
INSERT INTO heblb_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","האוהב את חייו על־פני האדמה – יאבד אותם; והשונא את חייו על־פני האדמה יזכה בחיי נצח. ");
INSERT INTO heblb_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","”הרוצה להיות תלמידי צריך ללכת בעקבותי, כי המשרתים אותי חייבים להיות במקום שאני נמצא. אלוהים אבי יכבד את כל אלה שהולכים בעקבותי ומשרתים אותי. ");
INSERT INTO heblb_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","כעת נבהלה נפשי, אולם איני יכול לבקש מאבי שיצילני מגורלי, שהרי לשם כך באתי לעולם. ");
INSERT INTO heblb_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","אבי, פאר את שמך!“ לפתע נשמע קול מהשמים: ”כבר פארתי ואוסיף לפאר.“ ");
INSERT INTO heblb_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","כל הנוכחים שמעו את הקול, אולם חלקם חשב שהיה זה קול רעם, וחלקם אמר שמלאך דיבר עם ישוע. ");
INSERT INTO heblb_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","”הקול הזה היה למענכם ולא למעני“, אמר להם ישוע. ");
INSERT INTO heblb_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","”עכשיו הגיע מועד משפטו של העולם, ושר העולם הזה (השטן) יגורש. ");
INSERT INTO heblb_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","וכאשר אנשא מן הארץ אמשוך אלי את כולם.“ ");
INSERT INTO heblb_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","הוא אמר זאת כדי לרמוז להם כיצד ימות. ");
INSERT INTO heblb_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","”אולם אנחנו למדנו מהתורה שהמשיח יחיה לנצח ולא ימות לעולם, אם כן מדוע אתה אומר שבן־האדם צריך להנשא מן הארץ? מי בן־האדם הזה?“ שאלו אותו. ");
INSERT INTO heblb_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","”האור יישאר אתכם עוד זמן קצר בלבד“, אמר ישוע. ”על כן, תנצלו את העובדה הזאת והתהלכו באור כל עוד אתם יכולים, מפני שעם רדת החשכה לא תוכלו למצוא את דרככם. ");
INSERT INTO heblb_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","האמינו באור לפני שיהיה מאוחר מדי, כדי שגם אתם תהיו בני האור.“ לאחר שסיים את דבריו הלך לדרכו, והם לא ראו אותו. ");
INSERT INTO heblb_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","על־אף הניסים הרבים שחולל ישוע, אנשים רבים לא האמינו שהוא המשיח. ");
INSERT INTO heblb_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","הנביא ישעיהו חזה מצב זה כשאמר: ”ה׳, מי האמין לשמועתנו, וזרוע ה׳ על־מי נגלתה?“ ");
INSERT INTO heblb_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","לכן הם לא יכלו להאמין. ישעיהו אף ניבא: ");
INSERT INTO heblb_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","”אלוהים סנוור את עיניהם והקשיח את לבם. משום כך הם אינם יכולים לראות, להבין או לשוב אליו כדי שירפא אותם.“ ");
INSERT INTO heblb_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","הנביא ישעיהו אמר דברים אלה על ישוע מפני שראה בחזונו את תפארתו. ");
INSERT INTO heblb_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","מנהיגי יהודים רבים האמינו כי ישוע הוא המשיח, אך לא הודו בזאת בפני איש, כי פחדו שהפרושים יטילו עליהם חרם. ");
INSERT INTO heblb_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","לאנשים אלה היה חשוב יותר לזכות בכבוד מבני־אדם מאשר מאלוהים. ");
INSERT INTO heblb_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","”אם אתם מאמינים בי, אתם מאמינים למעשה באלוהים“, קרא ישוע. ");
INSERT INTO heblb_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","”שהרי כל הרואה אותי רואה למעשה את שולחי. ");
INSERT INTO heblb_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","באתי להאיר ולזרוח בעולם חשוך זה, כדי שכל המאמין בי לא יתעה יותר בחשכה. ");
INSERT INTO heblb_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","לא באתי לשפוט את העולם, כי אם להושיעו, ועל כן לא אשפוט את אלה השומעים את דברי ואינם מקיימים אותם. ");
INSERT INTO heblb_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","דברי האמת שדיברתי ישפטו ביום הדין את כל אלה שדחוני ולעגו לי. ");
INSERT INTO heblb_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","כי איני מדבר אליכם על דעת עצמי; אני מוסר לכם מה שציווה עלי אבי לומר לכם. ");
INSERT INTO heblb_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","אני מוסר לכם בדיוק מה שמסר לי אבי, כי אני יודע שמצוותו תביא לכם חיי נצח.“ ");
INSERT INTO heblb_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","לפני חג הפסח, ישוע ידע שהגיעה שעתו לעזוב את העולם ולשוב אל אביו. ישוע תמיד אהב מאוד את בחיריו בעולם הזה, ועתה עמד להוכיח להם כי אין גבול לאהבתו. ");
INSERT INTO heblb_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","לעט סעודת הערב השטן כבר המריץ את יהודה איש־קריות להסגיר את ישוע. ");
INSERT INTO heblb_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","ישוע ידע כי אביו נתן בידו את הכול, וכי הוא בא מאלוהים וישוב אל אלוהים. ");
INSERT INTO heblb_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","לכן הוא קם מהשולחן בארוחת הערב, הסיר את בגדיו וקשר למותניו מגבת. ");
INSERT INTO heblb_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","אחר כך לקח קערה, מילא אותה מים, החל לרחוץ את רגלי תלמידיו וניגב אותן במגבת הקשורה למתניו. ");
INSERT INTO heblb_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","כאשר הגיע תורו של שמעון פטרוס הוא קרא: ”אדוני, איך ייתכן שאתה תרחץ את רגלי?“ ");
INSERT INTO heblb_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","”כעת אינך מבין מדוע אני עושה זאת, אולם יבוא יום שתבין זאת“, השיב ישוע. ");
INSERT INTO heblb_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","”לא,“ מחה פטרוס, ”לעולם לא תרחץ את רגלי!“ ”אם לא ארחץ אותך, לא יהיה לך חלק בי“, השיב ישוע. ");
INSERT INTO heblb_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","”אם כך,“ קרא פטרוס, ”רחץ לא רק את רגלי, אלא גם את ידי וראשי.“ ");
INSERT INTO heblb_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","”מי שרחץ כבר את כל גופו צריך לרחוץ את רגליו בלבד כדי להיות נקי וטהור. עתה אתם נקיים, אבל לא כולכם.“ ");
INSERT INTO heblb_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","ישוע אמר דברים אלה מפני שידע מי עמד להסגירו. ");
INSERT INTO heblb_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","כשסיים ישוע לרחוץ את רגליהם לבש את בגדיו, התיישב ושאל: ”האם אתם מבינים מה עשיתי לכם? ");
INSERT INTO heblb_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","אתם קוראים לי ’מורה‘ ו’אדון‘, ואכן נוהגים אתם בצדק, כי זוהי האמת. ");
INSERT INTO heblb_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","לכן אם אני, האדון והמורה, רחצתי את רגליכם, גם אתם צריכים לרחוץ איש את רגלי רעהו. ");
INSERT INTO heblb_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","נתתי לכם דוגמה כדי שתנהגו כמוני. ");
INSERT INTO heblb_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","האמינו לי, העבד אינו חשוב מאדוניו, והשליח אינו חשוב משולחו. ");
INSERT INTO heblb_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","כאשר תבינו את משמעות הדברים האלה ותנהגו לפיהם, יהיה לכם טוב ותתברכו. ");
INSERT INTO heblb_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","”איני מתכוון לכולכם, כי אני יודע במי בחרתי. הכתובים מנבאים שאחד מאוכלי לחמי יבגוד בי. ");
INSERT INTO heblb_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","אני מספר לכם זאת עכשיו כדי שתאמינו לי כשכל זה יתרחש. ");
INSERT INTO heblb_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","”אמן אומר אני לכם: כל המקבל את מי שאני שולח מקבל למעשה אותי, וכל המקבל אותי מקבל למעשה את שולחי.“ ");
INSERT INTO heblb_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","בסיימו דברים אלה נאנח ישוע אנחה עמוקה ואמר: ”אכן, זוהי האמת – אחד מכם יבגוד בי.“ ");
INSERT INTO heblb_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","התלמידים הביטו איש ברעהו בתמיהה ובמבוכה, משום שלא ידעו למי התכוון. ");
INSERT INTO heblb_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","תלמידו החביב של ישוע היה סמוך לחיקו, ");
INSERT INTO heblb_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","ולכן רמז לו שמעון פטרוס לשאל אותו למי כוונתו. ");
INSERT INTO heblb_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","התלמיד הטה את ראשו וקרבו לראשו של ישוע. ”אדוני, למי כוונתך?“ שאל בלחישה. ");
INSERT INTO heblb_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","”למי שאגיש את פרוסתי הטבולה ברוטב“, השיב ישוע. הוא טבל את הפרוסה והגישה ליהודה בן שמעון איש־קריות. ");
INSERT INTO heblb_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","כאשר סיים יהודה לאכול את הלחם נכנס השטן ללבו. ”סיים את העניין במהירות“, אמר לו ישוע. ");
INSERT INTO heblb_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","איש מהנוכחים לא ידע למה ישוע התכוון. ");
INSERT INTO heblb_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","היו שחשבו כי ישוע ביקש ממנו לקנות את צרכי החג או לתת כסף לעניים, מפני שיהודה היה הגזבר. ");
INSERT INTO heblb_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","יהודה עזב מיד את המקום ויצא. היה אז לילה. ");
INSERT INTO heblb_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","לאחר שעזב יהודה את החדר אמר ישוע: ”הגיעה שעתי; עתה יתפאר בן־האדם, ואלוהים יפואר בו. ");
INSERT INTO heblb_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","אם אלוהים יפואר בי, הוא בעצמו יפאר אותי ואף יעשה זאת במהרה. ");
INSERT INTO heblb_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","ילדי היקרים, עוד מעט עלי ללכת מאתכם. לאחר שאלך לא תוכלו לבוא אלי גם אם תחפשו אותי, כפי שכבר אמרתי למנהיגי היהודים. ");
INSERT INTO heblb_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","”אני מפקיד בידיכם מצווה חדשה: אהבו איש את רעהו כשם שאני אוהב אתכם. ");
INSERT INTO heblb_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","אהבתכם החזקה איש לרעהו תוכיח לעולם שאתם תלמידי.“ ");
INSERT INTO heblb_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","”לאן אתה הולך, אדון?“ שאל שמעון פטרוס. ”אינך יכול לבוא איתי עכשיו, אולם עוד זמן מה תצטרף אלי גם אתה“, השיב ישוע. ");
INSERT INTO heblb_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","”אבל מדוע איני יכול ללכת איתך כעת?“ פטרוס לא הבין. ”אני מוכן אפילו למות למענך!“ ");
INSERT INTO heblb_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","”למות למעני?“ שאל ישוע. ”אני אומר לך שעד מחר בבוקר לפני קריאת התרנגול, תכחיש שלוש פעמים אפילו את העובדה שאתה מכיר אותי!“ ");
INSERT INTO heblb_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","”אל תתנו מקום לדאגה בלבבכם; האמינו באלוהים והאמינו בי. ");
INSERT INTO heblb_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","בבית אבי מעונות רבים, ואני הולך להכין לכם מקום. לולא היה הדבר נכון, לא הייתי מספר לכם זאת. ");
INSERT INTO heblb_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","לאחר שהכול יהיה מוכן אחזור ואקח אתכם אלי, כדי שתהיו תמיד במקום שבו אני נמצא. ");
INSERT INTO heblb_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","אתם יודעים לאן אני הולך וכיצד להגיע לשם.“ ");
INSERT INTO heblb_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","”לא, איננו יודעים לאן אתה הולך“, קרא תומא. ”כיצד אתה מצפה שנדע את הדרך?“ ");
INSERT INTO heblb_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","אולם ישוע ענה: ”אני עצמי הדרך, האמת והחיים. איש אינו יכול לבוא אל האב אלא באמצעותי. ");
INSERT INTO heblb_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","אילו ידעתם מי אני, הייתם יודעים גם מיהו אבי. מעתה ואילך אתם מכירים אותו וגם ראיתם אותו.“ ");
INSERT INTO heblb_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","”אדוני, הראה לנו את האב ונסתפק בכך“, ביקש פיליפוס. ");
INSERT INTO heblb_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","אולם ישוע השיב: ”פיליפוס, לאחר שהייתי אתכם במשך כל הזמן הזה, עדיין אינך יודע מי אני? מי שראה אותי ראה את אבי, אם כן מדוע מבקש אתה לראותו? ");
INSERT INTO heblb_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","האם אינך מאמין שאני חי באבי, ושאבי חי בי? אין אלה המילים שלי, כי אם של אבי השוכן בקרבי והפועל דרכי. ");
INSERT INTO heblb_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","”האמינו לי שאני חי באבי ואבי חי בי; האמינו לי לפחות בזכות הנסים והנפלאות שחוללתי. ");
INSERT INTO heblb_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","אני אומר לכם בכנות וברצינות: כל מי שמאמין בי יוכל לעשות את כל מה שאני עושה, ואף הרבה יותר מזה, כי אני הולך אל אבי. ");
INSERT INTO heblb_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","אעשה למענכם כל מה שתבקשו בשמי, כדי שהאב יכובד בבנו. ");
INSERT INTO heblb_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","אכן, אעשה את כל מה שתבקשו בשמי. ");
INSERT INTO heblb_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","”אם אתם אוהבים אותי, שמעו בקולי; ");
INSERT INTO heblb_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","ואני אבקש מאבי שיתן לכם יועץ אחר שלא יעזוב אתכם לעולם – ");
INSERT INTO heblb_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","את רוח הקודש והאמת. רוב האנשים בעולם אינם יכולים לקבל את רוח הקודש, מפני שאינם מכירים אותו ואינם מעונינים בו כלל. אולם אתם מכירים אותו, כי עתה הוא נמצא אתכם ובקרוב אף ישכון בקרבכם. ");
INSERT INTO heblb_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","לא אעזוב אתכם כיתומים; אני אחזור אליכם. ");
INSERT INTO heblb_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","בעוד זמן קצר העולם כבר לא יראה אותי, אך אתם תראו אותי, כי אני חי וגם אתם תחיו. ");
INSERT INTO heblb_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","ביום ההוא תדעו שאני שוכן באבי, אתם שוכנים בי ואני בכם. ");
INSERT INTO heblb_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","כל השומע בקולי אוהב אותי; על כן אבי ואני נאהב אותו, ואני אתוודע אליו.“ ");
INSERT INTO heblb_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","יהודה תלמידו (לא איש־קריות) פנה אליו: ”אדוני, מדוע רוצה אתה להתוודע אלינו בלבד, אל תלמידיך, ולא אל העולם כולו?“ ");
INSERT INTO heblb_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","”מפני שאגלה את עצמי רק למי שאוהב אותי ושומע בקולי“, השיב ישוע. ”גם אבי יאהב את מי שאוהב אותי, ואנחנו נשכון בתוכו. ");
INSERT INTO heblb_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","מי שאינו שומע בקולי אינו אוהב אותי. זכרו, אין אלה דברי, כי אם דברי אבי אשר שלחני. ");
INSERT INTO heblb_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","אני אומר לכם דברים אלה כל עוד אני נמצא אתכם. ");
INSERT INTO heblb_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","כאשר אבי ישלח בשמי את המנחם, את רוח הקודש, הוא ילמד אתכם דברים רבים ויזכיר לכם כל מה שאמרתי. ");
INSERT INTO heblb_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","”אני משאיר לכם שלווה ושלום. לא לפי מושגי העולם, אלא שלומי שלי. לכן אל תפחדו ואל תדאגו. ");
INSERT INTO heblb_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","זכרו את מה שאמרתי לכם: אני הולך עכשיו, אולם אשוב אליכם. אם אתם באמת אוהבים אותי, תשמחו לשמוע שאני חוזר אל אבי, כי הוא גדול ממני. ");
INSERT INTO heblb_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","אני מספר לכם את כל הדברים האלה לפני התרחשותם, כדי שתאמינו בי כאשר הם יתרחשו. ");
INSERT INTO heblb_vpl VALUES ("JN14_30‏","073_14_30‏","JHN","14","30‏","31","”לא נותר לי זמן רב לדבר אליכם, כי שר הרשע של העולם הזה מתקרב. הוא אינו יכול לגבור עלי, אך על העולם לדעת שאני אוהב את אבי; משום כך אני עושה כל מה שאבי מצווה עלי. הבה נלך מכאן.“ ");
INSERT INTO heblb_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","”אני הגפן האמתית ואבי הוא הכורם. ");
INSERT INTO heblb_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","הוא גוזם את כל הענפים שאינם נושאים פרי, ומטהר את הענפים שנושאים פרי, כדי שישאו יותר פרי. ");
INSERT INTO heblb_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","אתם כבר מטוהרים על־ידי הדברים שאמרתי לכם. ");
INSERT INTO heblb_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","עליכם לקשור את חייכם בחיי. אם לא תהיו חלק ממני, לא תוכלו לשאת פרי, כשם שענף גזום אינו מסוגל לשאת פרי מעצמו. ");
INSERT INTO heblb_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","”כן, אני הגפן ואתם הענפים. מי שמחובר אלי ואני אליו ישא פרי רב, כי בלעדי אינכם מסוגלים לעשות דבר. ");
INSERT INTO heblb_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","מי שיאנו מחובר אלי ייזרק החוצה כענף יבש וחסר־תועלת שנועד לשריפה. ");
INSERT INTO heblb_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","אולם אם תקשרו את חייכם בחיי ותשמרו את מצוותי, אתן לכם כל מה שתבקשו ממני, ");
INSERT INTO heblb_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","ואבי יכובד בעשותכם פרי ובהיותכם תלמידי. ");
INSERT INTO heblb_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","”אני אוהב אתכם כפי שאבי אוהב אותי; דבקו באהבתי! ");
INSERT INTO heblb_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","אם תשמרו את מצוותי תעמדו באהבתי, כשם שאני שומר את מצוות אבי ועומד באהבתו. ");
INSERT INTO heblb_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","אני מספר לכם דברים אלה כדי שתימלאו בשמחתי, וכדי ששמחתכם תהיה מושלמת. ");
INSERT INTO heblb_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","אני דורש מכם שתאהבו איש את רעהו כשם שאני אוהב אתכם. ");
INSERT INTO heblb_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","האהבה הגדולה ביותר היא זו של אדם שמקריב את נפשו בעד ידידיו; ");
INSERT INTO heblb_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","ואם תשמעו בקולי תהיו ידידי. ");
INSERT INTO heblb_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","לא אקרא לכם יותר ’עבדים‘, כי האדון אינו משתף את עבדיו בסודותיו; עתה הנכם ידידי ואנשי־סודי, כי סיפרתי לכם כל מה שאמר לי אבי. ");
INSERT INTO heblb_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","”לא אתם בחרתם בי, כי אם אני בחרתי בכם ושלחתי אתכם ללכת ולעשות פרי מבורך ואמתי, כדי שאבי יתן לכם כל מה שתבקשו ממנו בשמי. ");
INSERT INTO heblb_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","אני מצווה עליכם לאהוב איש את רעהו. ");
INSERT INTO heblb_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","העולם אמנם שונא אתכם, אולם דעו לכם שהוא שנא אותי לפני ששנא אתכם. ");
INSERT INTO heblb_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","אילו הייתם שייכים לעולם, היה העולם אוהב אתכם; אולם אינכם שייכים לעולם, כי אני בחרתי להוציא אתכם ממנו, ומשום כך הוא שונא אתכם. ");
INSERT INTO heblb_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","האם אתם זוכרים מה שאמרתי לכם? ’העבד אינו גדול מאדוניו‘, וכך הם רודפים אתכם משום שרדפו אותי; אילו הקשיבו לי, היו מקשיבים גם לכם. ");
INSERT INTO heblb_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","האנשים בעולם ירדפו אתכם משום שאתם שייכים לי, ומשום שהם לא מכירים את האלוהים אשר שלח אותי. ");
INSERT INTO heblb_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","”לולא דיברתי אליהם הם לא היו אשמים, אולם עתה אין להם כל תירוץ להמשיך בחטאיהם. ");
INSERT INTO heblb_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","כל השונא אותי שונא גם את אבי. ");
INSERT INTO heblb_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","לולא עשיתי לפניהם את כל הניסים והנפלאות הם גם לא היו אשמים; אולם הם ראו את הניסים והנפלאות, ובכל זאת הם שונאים אותי ואת אבי. ");
INSERT INTO heblb_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","כך מתקיימים הדברים בתורה שלהם שמתייחסים למשיח: ’שנאת חינם שנאוני‘. ");
INSERT INTO heblb_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","”אולם אני אשלח לכם את המנחם – את רוח הקודש שהוא מקור האמת. הוא יבוא אליכם מאת האב ללמד אתכם ולזהכיר לכם את כל מה שאמרתי לכם. ");
INSERT INTO heblb_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","גם עליכם מוטל לספר לכולם על אודותי, משום שהייתם איתי מלכתחילה.“ ");
INSERT INTO heblb_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","”סיפרתי לכם את כל הדברים האלה כדי שתדעו מה מצפה לכם ולא תופתעו או תיבהלו. ");
INSERT INTO heblb_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","יגרשו אתכם מבתי־הכנסת, ואף יגיע הזמן שהרוצחים אתכם יחשבו שהם עושים את רצון אלוהים! ");
INSERT INTO heblb_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","הם יעשו כל זאת מפני שאינם מכירים את אבי ואותי. ");
INSERT INTO heblb_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","אני מספר לכם את כל הדברים האלה כדי שבבוא העת תיזכרו שהזהרתי אתכם. לא סיפרתי לכם זאת מקודם, מפני שעדיין הייתי עמכם. ");
INSERT INTO heblb_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","”אולם עתה אני חוזר אל שולחי, ואיש מכם אינו מתעניין לדעת לאן אני הולך. ");
INSERT INTO heblb_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","דברי רק העציבו אתכם. ");
INSERT INTO heblb_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","האמת היא כי מוטב שאלך, אחרת לא יבוא המנחם. אם אלך הוא יבוא, מפני שאשלח אותו אליכם. ");
INSERT INTO heblb_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","”כאשר יבוא המנחם הוא ילמד את העולם מהי משמעות החטא, הצדק והמשפט. ");
INSERT INTO heblb_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","הוא יוציא לאור את חטא העולם, משום שלא האמינו בי. ");
INSERT INTO heblb_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","הוא יראה להם מהו הצדק האמתי, כי אני חוזר אל אבי ושוב לא תראו אותי. ");
INSERT INTO heblb_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","הוא ילמד אותם את משמעות המשפט, כי שליט העולם הזה (השטן) כבר נשפט ונדון. ");
INSERT INTO heblb_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","”הייתי רוצה לומר לכם עוד דברים רבים, אבל אינכם מסוגלים להבינם עדיין. ");
INSERT INTO heblb_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","כאשר יבוא אליכם רוח האמת הוא יוביל אתכם אל כל האמת, כי אין הוא מדבר על דעת עצמו; הוא יספר לכם את אשר שמע. הוא יספר לכם גם על העתיד. ");
INSERT INTO heblb_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","הוא יפאר אותי ויביא לי כבוד רב בהראותו לכם את תפארתי. ");
INSERT INTO heblb_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","כל תפארתו היא תפארתי, ומשום כך אמרתי לכם שהרוח יביא לי כבוד רב בהראותו לכם את תפארתי. ");
INSERT INTO heblb_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","בעוד זמן מה אלך ושוב לא תראו אותי, אך כעבור זמן מה תראו אותי בשנית, כי אני הולך אל אבי.“ ");
INSERT INTO heblb_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","אחדים מתלמידיו לא הבינו את דבריו. ”למה הוא מתכוון באמרו שבעוד זמן מה נראה אותו בשנית, כי הוא הולך אל אביו?“ שאלו איש את רעהו. ");
INSERT INTO heblb_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","”למה הוא מתכוון באמרו ’זמן מה‘?“ תמהו. ");
INSERT INTO heblb_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","ישוע ידע מה הטריד אותם ולכן שאל: ”האם אתם תוהים למה התכוונתי? ");
INSERT INTO heblb_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","אני אומר לכם באמת וברצינות: העולם ישמח ויגיל על מה שיקרה לי, ואילו אתם תבכו. אבל צערכם יהפוך לשמחה נפלאה, כאשר תראו אותי שנית. ");
INSERT INTO heblb_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","שמחה זו תדמה לשמחתה של יולדת השוכחת את חבלי הלידה לאחר הולדת תינוקה, כי היא נמלאת שמחה וגיל על כך שאדם נולד לעולם. ");
INSERT INTO heblb_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","עכשיו אתם עצובים, אולם אשוב לראותכם, ואז תשמחו מאוד ואיש לא יוכל להשבית את שמחתכם. ");
INSERT INTO heblb_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","ביום ההוא לא יהיה עליכם לבקש ממני דבר, כי תוכלו לבקש את הדבר מאבי, והוא ייתן לכם כל מה שתבקשו ממנו בשמי. ");
INSERT INTO heblb_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","עד עתה לא ביקשתם דבר בשמי; בקשו ותקבלו, כדי שתימלאו שמחה רבה. ");
INSERT INTO heblb_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","”דיברתי אליכם במשלים וחידות, אולם יבוא יום שאדבר אליכם על אבי בבירור ולא עוד בחידות ובמשלים. ");
INSERT INTO heblb_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","ביום ההוא תוכלו לבקש בשמי כל דבר, ולא אצטרך יותר לבקש מאבי שיתן לכם אותו. ");
INSERT INTO heblb_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","כי אבי אוהב אתכם משום שאתם אוהבים אותי ומאמינים שיצאתי ממנו. ");
INSERT INTO heblb_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","כן, יצאתי מאבי ובאתי לעולם. כעת אני עוזב את העולם וחוזר לאבי.“ ");
INSERT INTO heblb_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","”סוף סוף אתה מדבר דברים ברורים ולא בחידות ובמשלים“, קראו תלמידיו בהקלה. ");
INSERT INTO heblb_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","”עתה אנו יודעים שאתה יודע הכל, ואיננו צריכים לשאול אותך יותר שאלות. אנו מאמינים שבאת מאלוהים.“ ");
INSERT INTO heblb_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","”אתם מאמינים לי לבסוף?“ שאל ישוע. ");
INSERT INTO heblb_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","”אולם יגיע הזמן – למעשה הוא כבר הגיע – שכולכם תתפזרו איש לביתו ותעזבוני לבדי. אך לא אהיה לבדי כי אבי עמדי. ");
INSERT INTO heblb_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","אמרתי לכם את כל הדברים האלה כדי שלבכם ישקוט ולא תדאגו. כאן בעולם יהיו לכם קשיים וצרות, אולם חיזקו ואימצו, כי אני ניצחתי את העולם!“ ");
INSERT INTO heblb_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","בסיימו לדבר נשא ישוע את עיניו השמימה ואמר: ”אבי, הגיעה השעה; פאר את בנך כדי שבנך יפאר אותך. ");
INSERT INTO heblb_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","הרי נתת לו סמכות וכוח על כל בני־האדם, כדי שיעניק חיי עולם לכל מי שנתת לו. ");
INSERT INTO heblb_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","חיי עולם פירושם להכיר אותך, אלוהי האמת לבדו, ואת ישוע המשיח אשר שלחת. ");
INSERT INTO heblb_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","סיימתי את המשימה שהטלת עלי, וכך פארתי אותך על־פני הארץ. ");
INSERT INTO heblb_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","עתה, אבי, פאר אותי בכבוד שהיה לי איתך עוד לפני בריאת העולם. ");
INSERT INTO heblb_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","”סיפרתי על אודותיך לכל האנשים שנתת לי בעולם. למעשה הם היו שלך תמיד; אתה נתת לי אותם והם שמעו בקולך. ");
INSERT INTO heblb_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","עתה הם יודעים שכל מה שנתת לי ממך הוא, ");
INSERT INTO heblb_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","כי מסרתי להם את המצוות שמסרת לי. הם קיבלו אותן, והם יודעים בבטחון שבאתי לעולם מעמך ושאתה שלחת אותי. ");
INSERT INTO heblb_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","”איני מתפלל בעד העולם כולו, אלא בעד אלה שנתת לי, כי הם שייכים לך. ");
INSERT INTO heblb_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","אלה שהם שלי הם שלך, ושלך הם שלי, ולכן הם תפארתי. ");
INSERT INTO heblb_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","כעת אני עוזב את העולם ומשאיר אותם כאן. אבי הקדוש, אני בא אליך ומבקש ממך: שמור על כל אלה שנתת לי, כדי שיתאחדו ויהיו לאחד – כמונו. ");
INSERT INTO heblb_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","בהיותי כאן בעולם שמרתי על אלה שנתת לי אך אחד מהם לא אבד, מלבד בן־הגיהינום שבו נתקיימה הנבואה שבכתבי־הקודש. ");
INSERT INTO heblb_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","”עכשיו אני בא אליך. סיפרתי להם דברים רבים בהיותי עמם, כדי שיימלאו בשמחתי, ");
INSERT INTO heblb_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","ומסרתי להם את מצוותיך. העולם שונא אותם, כי אינם שייכים לו, כשם שאני איני שייך לעולם. ");
INSERT INTO heblb_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","אני לא מבקש ממך להוציא אותם מהעולם, אלא לשמרם מהרע. ");
INSERT INTO heblb_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","הם אינם שייכים לעולם הזה, כשם שאני איני שייך לעולם הזה. ");
INSERT INTO heblb_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","למד אותם את דבר האמת, כדי שיהיו קדושים וטהורים. ");
INSERT INTO heblb_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","כשם ששלחת אותי אל העולם כך גם אני שולח אותם אל העולם. ");
INSERT INTO heblb_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","אני מוסר את עצמי למענם, כדי שיגדלו באמת ובקדושה. ");
INSERT INTO heblb_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","”אינני מתפלל רק בעד אלה כאן, אלא גם בעד אלה שיאמינו בי בעתיד, לאחר שישמעו את עדויות המאמינים. ");
INSERT INTO heblb_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","אני מתפלל שהם יהיו מאוחדים כמונו; שהם יהיו בנו כשם שאתה בי ואני בך, כדי שהעולם יאמין שאתה שלחת אותי. ");
INSERT INTO heblb_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","”נתתי להם את הכבוד שנתת לי, כדי שיהיו מאוחדים כשם שאנחנו מאוחדים – ");
INSERT INTO heblb_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","אני בהם ואתה בי, כדי שאחדותם תהיה שלמה, וכדי שהעולם ידע שאתה שלחתני ושאתה אוהב אותם כמו שאתה אוהב אותי. ");
INSERT INTO heblb_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","אבי, אני רוצה שאלה אשר נתת לי יהיו במקום שבו אהיה, כדי שיוכלו לראות את התפארת והכבוד שהענקת לי על שום שאהבת אותי עוד לפני בריאת העולם. ");
INSERT INTO heblb_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","”הו, אבי הצדיק, העולם אינו מכיר אותך, אבל אני מכיר אותך, והתלמידים שנתת לי יודעים שאתה שלחתני. ");
INSERT INTO heblb_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","אני הודעתי להם את שמך, ואוסיף להודיע, כדי שהם יאהבו אותי כשם שאתה אוהב אותי וכדי שגם אני אהיה בהם.“ ");
INSERT INTO heblb_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","ישוע סיים את דבריו ועזב את המקום עם תלמידיו. הם חצו את נחל קדרון ונכנסו אל חורשת עצי־זית. ");
INSERT INTO heblb_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","יהודה, התלמיד שבגד בישוע, הכיר היטב את המקום, כי ישוע נפגש שם עם תלמידיו פעמים רבות. ");
INSERT INTO heblb_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","ראשי הכוהנים והפרושים העמידו לרשות יהודה קבוצה של חיילים ושוטרים מצוידים בלפידים ובכלי נשק, והם הלכו אל אותה החורשה. ");
INSERT INTO heblb_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","ישוע ידע היטב מה עומד לקרות לו. הוא צעד קדימה ושאל: ”את מי אתם מחפשים?“ ");
INSERT INTO heblb_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","”את ישוע מנצרת“, השיבו לו. ”אני הוא“, אמר ישוע. גם יהודה המסגיר אותו היה שם. ");
INSERT INTO heblb_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","לשמע מילים אלה הם נסוגו ונפלו על הארץ. ");
INSERT INTO heblb_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","ישוע חזר על שאלתו: ”את מי אתם מחפשים?“ ”את ישוע מנצרת“, השיבו בשנית. ");
INSERT INTO heblb_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","”אמרתי לכם, אני הוא“, אמר ישוע. ”אם אותי אתם מחפשים, עיזבו את החבורה הזאת והניחו להם ללכת.“ ");
INSERT INTO heblb_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","ישוע אמר זאת כדי לקיים את הנבואה שניבא: ”מכל אלה שנתת לי לא אבד אף אחד!“ ");
INSERT INTO heblb_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","לפתע שלף שמעון פטרוס את חרבו וקיצץ את אוזנו הימנית של מלכוס, עבד הכהן הגדול. ");
INSERT INTO heblb_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","”השב את החרב לנדן!“ פקד עליו ישוע. ”הרי עלי לשתות את הכוס שנתן לי אבי.“ ");
INSERT INTO heblb_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","החיילים, השוטרים ומפקדם תפסו את ישוע, קשרו את ידיו, ");
INSERT INTO heblb_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","הוליכו אותו תחילה אל חנן – חותנו של קייפא שהיה הכהן הגדול באותה שנה. ");
INSERT INTO heblb_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","היה זה אותו קייפא שיעץ ליהודים: ”מוטב שאדם אחד ימות בעד כל העם, מאשר שכל העם ימות בעד אדם אחד.“ ");
INSERT INTO heblb_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","שמעון פטרוס ותלמיד אחר הלכו במרחק מה אחרי ישוע. התלמיד האחר היה מוכר לכהן הגדול, ולכן הורשה להיכנס אל החצר יחד עם ישוע, ");
INSERT INTO heblb_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","ואילו פטרוס נאלץ להישאר מעבר לגדר. התלמיד האחר ניגש אל השוערת וביקש ממנה להכניס את פטרוס. ");
INSERT INTO heblb_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","”הלא גם אתה תלמידו של האיש הזה!“ קראה השוערת לעבר פטרוס. ”מה פתאום?“ הכחיש פטרוס. ");
INSERT INTO heblb_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","החיילים והמשרתים התחממו סביב לאש מדורה שהדליקו, כי היה קר. פטרוס הצטרף אליהם כדי להתחמם מעט. ");
INSERT INTO heblb_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","בתוך הבית החל הכהן הגדול לחקור את ישוע על תלמידיו ועל מה שלימד אותם. ");
INSERT INTO heblb_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","”כל מה שהיה לי לומר אמרתי בציבור, באוזני המנהיגים והעם. תמיד לימדתי בבתי־הכנסת או בבית־המקדש, וכולם יודעים מה שלימדתי“, השיב ישוע. ");
INSERT INTO heblb_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","”אל תשאל אותי, אלא את שומעי, הם יודעים את מה שאמרתי.“ ");
INSERT INTO heblb_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","אחד המשרתים שעמד שם הכה את ישוע על פניו. ”ככה אתה מתחצף לכהן הגדול?“ שאל בזעם. ");
INSERT INTO heblb_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","”אם אני משקר הוכח זאת.“ השיב ישוע. ”אולם אם אני אומר את האמת, מדוע אתה מכה אותי?“ ");
INSERT INTO heblb_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","חנן שלח את ישוע, אסור באזיקים, אל קייפא הכהן הגדול. ");
INSERT INTO heblb_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","בינתיים המשיך שמעון פטרוס להתחמם לאש המדורה, ושוב נשאל: ”הרי גם אתה אחד מתלמידיו של ישוע, לא כן?“ ”לא, מה פתאום?“ הכחיש פטרוס. ");
INSERT INTO heblb_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","אך אחד מעבדי הכהן הגדול, קרובו של מלכוס (זה שפטרוס קיצץ את אוזנו), קרא: ”אולם ראיתי אותך בחורשה יחד עם ישוע!“ ");
INSERT INTO heblb_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","פטרוס המשיך להכחיש את הדבר, ולפתע קרא התרנגול. ");
INSERT INTO heblb_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","בבוקר השכם הובילו את ישוע מביתו של קייפא לבית־הממשל. אך הם לא נכנסו פנימה מחשש חמץ – הם רצו להישאר כשרים לאכילת סעודת הפסח. ");
INSERT INTO heblb_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","על כן יצא אליהם פילטוס ושאל: ”במה אתם מאשימים את האיש?“ ");
INSERT INTO heblb_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","”אלמלא עשה דבר רע, לא היינו אוסרים אותו!“ השיבו. ");
INSERT INTO heblb_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","”אם כן, שפטו אותו בעצמכם לפי חוקי תורתכם“, אמר פילטוס. ”אבל החוק אינו מתיר לנו עונש מוות“, השיבו היהודים. ");
INSERT INTO heblb_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","בזאת מלאו את מה שישוע ניבא באשר לצורת מותו. ");
INSERT INTO heblb_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","פילטוס שב לבית־הממשל וקרא אליו את ישוע. ”האם אתה מלך היהודים?“ שאל. ");
INSERT INTO heblb_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","”האם אלה המילים שלך או של האחרים?“ השיב ישוע בשאלה. ");
INSERT INTO heblb_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","”האם אני יהודי?“ שאל פילטוס. ”בני־עמך וראשי הכוהנים הסגירו אותך. מה עשית?“ ");
INSERT INTO heblb_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","”אילו הייתה מלכותי מהעולם הזה, היו משרתי נלחמים לצדי ומונעים את מאסרי על־ידי ראשי היהודים. אולם בעת הזאת מלכותי אינה מהעולם הזה“, אמר ישוע. ");
INSERT INTO heblb_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","”אם כן, אתה בכל זאת מלך?“ תמה פילטוס. ”כן,“ השיב ישוע, ”משימתי היא להביא את האמת לעולם; לשם כך נולדתי ובאתי לעולם, וכל אוהבי האמת ישמעו לקולי.“ ");
INSERT INTO heblb_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","”מהי האמת?“ שאל פילטוס ויצא החוצה אל היהודים. ”האיש חף מפשע ולא עשה כל רע!“ קרא פילטוס. ");
INSERT INTO heblb_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","”בכל שנה בחג הפסח אני מוציא לחופשי אסיר אחד. אתם רוצים שאשחרר את מלך היהודים?“ ");
INSERT INTO heblb_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","”לא!“ קראו. ”אל תשחרר אותו; שחרר את בר־אבא!“ בר־אבא היה שותף למרד. ");
INSERT INTO heblb_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","אז לקח פילטוס את ישוע והלקה אותו בשוטים. ");
INSERT INTO heblb_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","החיילים שזרו זר קוצים, הניחוהו על ראשו והלבישו אותו גלימת ארגמן. ");
INSERT INTO heblb_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","”יחי מלך היהודים!“ קראו בלעג, והכו אותו באגרופיהם. ");
INSERT INTO heblb_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","פילטוס יצא אל הקהל ואמר: ”אני מוציא אליכם את ישוע כדי שתדעו שמצאתי אותו חף מפשע!“ ");
INSERT INTO heblb_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","ישוע יצא החוצה, ראשו עטור זר קוצים ולגופו גלימת ארגמן. ”הנה האיש!“ קרא פילטוס. ");
INSERT INTO heblb_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","כאשר ראו אותו ראשי הכוהנים והמשרתים, קראו: ”צלוב אותו! צלוב אותו!“ ”צלבו אותו בעצמכם,“ השיב להם פילטוס, ”כי אני לא מצאתי בו כל אשמה.“ ");
INSERT INTO heblb_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","”לפי תורתנו עליו למות,“ קראו היהודים, ”כיוון שקרא לעצמו בן־האלוהים.“ ");
INSERT INTO heblb_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","לשמע דברים אלה גבר פחדו של פילטוס. ");
INSERT INTO heblb_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","הוא החזיר את ישוע לבית־הממשל ושאל אותו: ”מאין אתה?“ אולם ישוע לא ענה דבר. ");
INSERT INTO heblb_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","”מדוע אינך עונה לי?“ שאל פילטוס. ”הרי אתה יודע כי יש בכוחי לצלוב אותך או לשחרר אותך!“ ");
INSERT INTO heblb_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","אבל ישוע השיב: ”לולא קיבלת רשות מלמעלה, לא היית יכול לעשות לי דבר. לכן אשמת המסגירים אותי גדולה מאשמתך.“ ");
INSERT INTO heblb_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","כששמע פילטוס דברים אלה ניסה לשחרר את ישוע, אולם היהודים התנגדו ואמרו: ”אם תשחרר אותו תגלה חוסר נאמנות לקיסר, מפני שכל העושה עצמו למלך מורד בקיסר!“ ");
INSERT INTO heblb_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","לשמע דברים אלה שוב הוציא פילטוס אליהם את ישוע, והוא עצמו התיישב על כסא המשפט, במקום שנקרא: ”רצפה“ או ”גבתא“. ");
INSERT INTO heblb_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","כל זה התרחש בערב פסח, בשעה שתים־עשרה בצהריים. ”הנה מלככם!“ קרא פילטוס לעבר היהודים. ”קח אותו מכאן! צלוב אותו!“ הם צעקו. ");
INSERT INTO heblb_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","”מה? לצלוב את מלככם?“ שאל פילטוס. ”רק הקיסר הוא מלכנו!“ קראו ראשי הכוהנים. ");
INSERT INTO heblb_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","פילטוס נכנע ומסר להם את ישוע כדי שיצלבו אותו. ");
INSERT INTO heblb_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","הם לקחו את ישוע, נתנו לו לשאת את צלבו, וכולם הלכו למקום הנקרא ”גולגותא“ (”מקום הגולגולת“). ");
INSERT INTO heblb_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","הם צלבו אותו שם יחד עם שני אנשים אחרים – האחד לימינו והשני לשמאלו. ");
INSERT INTO heblb_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","פילטוס כתב שלט בזו הלשון: ”ישוע מנצרת, מלך היהודים“ ותלה אותו על הצלב. ");
INSERT INTO heblb_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","יהודים רבים קראו את הכתוב על השלט, כי ישוע נצלב קרוב לעיר, והשלט נכתב בעברית, ביוונית וברומית. ");
INSERT INTO heblb_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","ראשי הוכהנים ביקשו מפילטוס לתקן את הכתוב: ”אל תכתוב ’מלך היהודים‘, אלא: ’הוא טוען שהוא מלך היהודים‘.“ ");
INSERT INTO heblb_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","”את מה שכתבתי כתבתי“, ענה פילטוס. ");
INSERT INTO heblb_vpl VALUES ("JN19_23‏","073_19_23‏","JHN","19","23‏","24","לאחר שצלבו החיילים את ישוע הם חילקו את בגדיו בין ארבעתם. ”מה נעשה בכותונת?“ שאלו איש את רעהו. הם לא רצו לקרוע אותה, משום שהייתה עשויה מאריג ללא תפרים. ”נערוך הגרלה ונראה מי יזכה בה“, החליטו. מעשה זה קיים את הנבואה מתהלים: ”יחלקו בגדי להם, ועל לבושי יפילו גורל.“ כך עשו החיילים. ");
INSERT INTO heblb_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","ליד הצלב עמדו אמו, דודתו, מרים אשת קלופס ומרים המגדלית. ");
INSERT INTO heblb_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","כשראה ישוע את אמו עומדת ליד תלמידו האהוב, אמר לה: ”אמא, זהו בנך.“ ");
INSERT INTO heblb_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","ואל תלמידו האהוב אמר: ”זוהי אמך.“ והתלמיד אסף אותה לביתו מאז ואילך. ");
INSERT INTO heblb_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","ישוע ידע שהכל הסתיים, וכדי למלא את הכתוב אמר: ”אני צמא.“ ");
INSERT INTO heblb_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","בקרבת מקום עמד כד מלא חומץ. הם טבלו ספוג בחומץ, תקעו את הספוג בקצה ענף אזוב והגישוהו לפיו. ");
INSERT INTO heblb_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","ישוע טעם מהחומץ וקרא: ”נשלם.“ הוא היטה ראשו הצידה ונפח נשמתו. ");
INSERT INTO heblb_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","הואיל והיה ערב שבת, לפני שבת של פסח, לא רצו מנהיגי היהודים להשאיר את הגופות על הצלבים למשך השבת. על כן ביקשו מפיליטוס לשבור את עצמות רגליהם של הנצלבים, כדי להחיש את מותם וכדי שאפשר יהיה להוריד את הגופות. ");
INSERT INTO heblb_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","החיילים באו ושברו את רגלי השניים שנצלבו לצדי ישוע. ");
INSERT INTO heblb_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","כשניגשו אל ישוע נוכחו שהוא כבר מת, ולכן לא שברו את עצמות רגליו. ");
INSERT INTO heblb_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","אחד החיילים דקר את צידו בחנית, ומיד יצאו דם ומים מגופו. ");
INSERT INTO heblb_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","זה שראה את כל זאת יודע שדבריו נכונים, והוא מספר לכם אותם כדי שתאמינו גם אתם. ");
INSERT INTO heblb_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","כך מלאו החיילים את הכתוב: ”ועצם לא תשברו בו.“ ");
INSERT INTO heblb_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","ובספר זכריה כתוב: ”והביטו אלי את אשר דקרו.“ ");
INSERT INTO heblb_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","לאחר מכן בא אל פילטוס יוסף הרמתי, שהיה תלמידו של ישוע אך שמר על כך בסוד מפחד מנהיגי היהודים, וביקש רשות לקחת את גופתו של ישוע; והרשות ניתנה. ");
INSERT INTO heblb_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","גם נקדימון בא לשם – אותו איש שבא אל ישוע בלילה – והביא איתו כשלושים קילוגרם של מרקחת יקרה העשויה מבשמים ושמנים. ");
INSERT INTO heblb_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","השניים לקחו את גופת ישוע ועטפוה בתכריכים עם בשמים, כמנהג הקבורה היהודית. ");
INSERT INTO heblb_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","קרוב למקום הצליבה היה גן ובו קבר חדש שאיש לא נקבר בו מעולם. ");
INSERT INTO heblb_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","הם קברו בו את ישוע מפני שהיה ערב שבת והקבר היה בקרבת מקום. ");
INSERT INTO heblb_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","השכם בבוקר יום ראשון, עוד לפני הנץ החמה, באה מרים המגדלית אל קברו של ישוע וראתה שהאבן הוסרה מפתח הקבר. ");
INSERT INTO heblb_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","היא רצה מיד אל שמעון פטרוס ואל התלמיד השני, זה שהיה אהוב על ישוע. היא קראה: ”הם לקחו את האדון מהקבר! איננו יודעים היכן שמו אותו!“ ");
INSERT INTO heblb_vpl VALUES ("JN20_3‏","073_20_3‏","JHN","20","3‏","4","פטרוס והתלמיד השני מיהרו יחד אל הקבר; התלמיד השני הקדים אותו והגיע ראשון. ");
INSERT INTO heblb_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","הוא הביט פנימה וראה את התכריכים מונחים במקומם, אולם לא נכנס לקבר. ");
INSERT INTO heblb_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","שמעון פטרוס בא אחריו ונכנס פנימה. גם הוא ראה את התכריכים. ");
INSERT INTO heblb_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","הבד שעטף את ראשו של ישוע היה מקופל ומונח בצד בניפרד מהתכריכים. ");
INSERT INTO heblb_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","ואז גם התלמיד האחר נכנס פנימה, ראה והאמין שישוע קם לתחייה. ");
INSERT INTO heblb_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","כי עד אז לא הבינו שהכתובים ניבאו כי הוא יקום לתחייה. ");
INSERT INTO heblb_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","שניהם הלכו הביתה, ");
INSERT INTO heblb_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","ובינתיים חזרה מרים אל הקבר, עמדה בחוץ ובכתה. היא העיפה מבט לתוך הקבר, ");
INSERT INTO heblb_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ולפתע נגלו אליה שני מלאכים לבושי לבן יושבים במקום שבו הייתה גופת ישוע: אחד למרגלותיו ושני למראשותיו. ");
INSERT INTO heblb_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","”מדוע את בוכה?“ שאלו המלאכים. ”כי הם לקחו את אדוני ואיני יודעת היכן הניחו אותו“, השיבה מרים. ");
INSERT INTO heblb_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","היא הרגישה שמישהו עומד מאחוריה. כשהביטה לאחור ראתה את ישוע, אולם היא לא הכירה אותו. ");
INSERT INTO heblb_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","”מדוע את בוכה? את מי את מחפשת?“ שאל אותה ישוע. מרים חשבה אותו לשומר הגן ולכן התחננה לפניו: ”אם אתה זה שלקח את אדוני, אנא, אמור לי היכן שמת אותו כדי שאוכל לקחתו.“ ");
INSERT INTO heblb_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","”מרים!“ קרא ישוע. היא פנתה להביט בו וקראה: ”רבי!“ ");
INSERT INTO heblb_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","”אל תגעי בי,“ הזהיר אותה ישוע, ”כי עדיין לא עליתי אל אבי. לכי אל האחים וספרי להם שאני עולה אל אבי ואביכם, אל אלוהי ואלוהיכם.“ ");
INSERT INTO heblb_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","מרים מיהרה אל התלמידים. ”ראיתי את האדון!“ קראה בהתלהבות, ומסרה להם את דבריו. ");
INSERT INTO heblb_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","באותו ערב התכנסו התלמידים מאחורי דלתות נעולות, מפחד מנהיגי היהודים. לפתע עמד ישוע ביניהם ואמר: ”שלום לכם!“ ");
INSERT INTO heblb_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","הוא הראה להם את נקבי המסמרים בידיו ואת צדו, והתלמידים שמחו מאוד לראות את אדונם. ");
INSERT INTO heblb_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","שוב דיבר אליהם ישוע: ”כשם שאבי שלח אותי, כך אני שולח אתכם.“ ");
INSERT INTO heblb_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","הוא נשף ואמר: ”קבלו את רוח הקודש. ");
INSERT INTO heblb_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","למי שתסלחו לחטאיו, הם ייסלחו לו, ולמי שלא תסלחו לחטאיו, הם לא ייסלחו לו.“ ");
INSERT INTO heblb_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","תומא התאום, אחד משנים־עשר התלמידים, נעדר מאותה אסיפה. ");
INSERT INTO heblb_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","כשסיפרו לו התלמידים שראו את האדון, תומא לא האמין. ”לא אאמין בכך עד שאראה את נקבי המסמרים שבידיו ואגע בהם ובצדו“, אמר. ");
INSERT INTO heblb_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","כעבור שמונה ימים שוב התכנסו התלמידים, והפעם היה תומא ביניהם. גם הפעם היו הדלתות נעולות. לפתע שוב עמד ישוע ביניהם וקרא: ”שלום לכם!“ ");
INSERT INTO heblb_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","ישוע פנה אל תומא ואמר: ”גע בידי ובצד גופי, ואל תהיה יותר חסר־אמונה, כי אם תאמין!“ ");
INSERT INTO heblb_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","”אדוני ואלוהי!“ קרא לו תומא. ");
INSERT INTO heblb_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","ישוע המשיך לדבר אליו: ”אתה מאמין משום שראית אותי, אולם ברוכים המאמינים על אף שאינם רואים.“ ");
INSERT INTO heblb_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","ישוע חולל עוד ניסים רבים לעיני תלמידיו אך הם לא נכתבו בספר זה. ");
INSERT INTO heblb_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","הניסים בספר זה נכתבו כדי שתאמינו כי הוא המשיח בן־האלוהים, וכדי שעל־ידי אמונתכם בו תחיו חיי נצח. ");
INSERT INTO heblb_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","כעבור זמן מה שוב נראה ישוע אל תלמידיו, הפעם ליד הכינרת, וכך התרחש הדבר: ");
INSERT INTO heblb_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","שמעון פטרוס, תומא התאום, נתנאל מכפר קנה שבגליל, בני זבדי, ועוד שניים אחרים היו ביחד. ");
INSERT INTO heblb_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","”אני הולך לדוג“, אמר שמעון פטרוס. ”גם אנחנו באים“, אמרו האחרים. הם עלו לסירה, אולם לא לכדו דבר במשך כל הלילה. ");
INSERT INTO heblb_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","עם זריחת החמה ראו מישהו על החוף, אך לא ידעו שישוע היה האיש. ");
INSERT INTO heblb_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","”בני, האם לכדתם משהו?“ שאל. ”לא!“ השיבו פה אחד. ");
INSERT INTO heblb_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","”אם תשליכו את הרשת לימין הסירה תלכדו דגים רבים“, אמר ישוע. הם עשו כדבריו, ודגים רבים כל־כך נלכדו ברשת, עד שלא היה להם כוח להעלות את הרשת חזרה לסירה. ");
INSERT INTO heblb_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","התלמיד שהיה אהוב על ישוע אמר לפטרוס: ”זהו האדון!“ כאשר שמע פטרוס את דבריו, לבש את חולצתו שהסיר קודם לכן, וקפץ למים. ");
INSERT INTO heblb_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","ואילו יתר התלמידים הפליגו לחוף שהיה במרחק מאה מטר בערך, ואיתם הרשת המלאה בדגים. ");
INSERT INTO heblb_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","כשעלו לחוף ראו מדורה שעליה נצלים דגים, ובצד היה לחם. ");
INSERT INTO heblb_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","”הביאו כמה מהדגים שלכדתם“, ביקש ישוע. ");
INSERT INTO heblb_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","שמעון פטרוס משך את הרשת ליבשה, וכאשר ספר את השלל הוא מנה 153 דגים גדולים. למרות מספרם ומשקלם לא נקרעה הרשת! ");
INSERT INTO heblb_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","”בואו, איכלו ארוחת בוקר“, הזמינם ישוע. איש מהם לא העז לשאול אותו אם הוא באמת האדון, כי כולם היו בטוחים בכך. ");
INSERT INTO heblb_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","ישוע הגיש להם את הלחם והדגים. ");
INSERT INTO heblb_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","זאת הייתה הפעם השלישית שבה נגלה אליהם ישוע לאחר שקם מהמתים. ");
INSERT INTO heblb_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","לאחר ארוחת הבוקר שאל ישוע את שמעון פטרוס: ”שמעון בן־יונה, האם אתה אוהב אותי יותר מכל אלה?“ ”כן,“ השיב פטרוס, ”אתה יודע שאני אוהב אותך.“ ”אם כן, רעה את טלאי“, אמר ישוע. ");
INSERT INTO heblb_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","ישוע שאל אותו שנית: ”שמעון בן־יונה, האם אתה באמת אוהב אותי?“ ”כן, אדוני, אתה יודע שאני אוהב אותך“, השיב פטרוס שנית. ”אם כן, נהג את צאני“, אמר ישוע. ");
INSERT INTO heblb_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","ישוע שאל פעם שלישית: ”שמעון בן־יונה, האם אתה באמת אוהב אותי?“ פטרוס נעצב משאלתו החוזרת של ישוע ואמר: ”אדוני, הכול אתה יודע. אתה יודע שאני אוהב אותך.“ ”אם כן, רעה את צאני“, חזר ישוע על בקשתו. ");
INSERT INTO heblb_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","”כשהיית צעיר יכולת לעשות כרצונך וללכת לאן שרצית. אולם כאשר תזדקן תושיט את ידיך – אנשים אחרים ילבישוך ויובילוך לאן שהם ירצו, ולא לאן שאתה תרצה.“ ");
INSERT INTO heblb_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","ישוע אמר לו דברים אלה כדי להכינו לקראת צורת מותו בעתיד, שבו יכבד את האלוהים. כאשר סיים ישוע לדבר, אמר לפטרוס: ”בוא אחרי.“ ");
INSERT INTO heblb_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","פטרוס הביט לאחור וראה שגם התלמיד האהוב על ישוע הולך אחריהם – אותו תלמיד שישב ליד ישוע בסעודה האחרונה ושאל מי מהם עמד להסגירו. ");
INSERT INTO heblb_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","”מה בקשר אליו, אדוני?“ שאל פטרוס. ");
INSERT INTO heblb_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","ישוע השיב: ”אם אני רוצה שהוא יישאר בחיים עד בואי, מה זה לך? בוא אתה אחרי.“ ");
INSERT INTO heblb_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","משום כך התפשטה השמועה בין האחים שהתלמיד הזה לא ימות. אבל למעשה ישוע כלל לא אמר זאת; הוא אמר: ”אם אני רוצה שהוא יישאר בחיים עד בואי, מה זה לך?“ ");
INSERT INTO heblb_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","זהו התלמיד שראה את כל ההתרחשויות האלה, העיד עליהן, וכתב אותן. כולנו יודעים שעדותו אמת. ");
INSERT INTO heblb_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","ישוע חולל עוד מעשים נפלאים רבים, אך העולם כולו צר מלהכיל את כל הספרים שהיה אפשר לכתוב עליהם.");
INSERT INTO heblb_vpl VALUES ("AC1_1‏","074_1_1‏","ACT","1","1‏","2","תאופילוס היקר, במכתבי הראשון סיפרתי לך על חייו, מעשיו ותורתו של ישוע המשיח, וכיצד עלה לשמים, לאחר שנתן לשליחיו הנבחרים הוראות נוספות בגבורת רוח הקודש. ");
INSERT INTO heblb_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","במשך ארבעים יום לאחר צליבתו נגלה ישוע אל השליחים פעמים אחדות, והוכיח להם בדרכים שונות שהוא אכן חי. בהזדמנויות אלה הוא גם שוחח איתם על מלכות האלוהים. ");
INSERT INTO heblb_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","באחת הפגישות האלה הורה ישוע לתלמידיו שלא יעזבו את ירושלים עד שיבוא עליהם רוח הקודש, כפי שהבטיח להם האב. ישוע שוחח איתם על כך פעמים רבות בעבר. ");
INSERT INTO heblb_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","”יוחנן הטביל אתכם במים,“ הזכיר להם ישוע, ”אולם בעוד ימים אחדים תיטבלו ברוח הקודש!“ ");
INSERT INTO heblb_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","כשנגלה אליהם ישוע בפעם אחרת, שאלו אותו: ”אדון, האם אתה עומד להשיב את המלכות לישראל?“ ");
INSERT INTO heblb_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","”האב הוא הקובע תאריכים אלה,“ ענה ישוע, ”ואינכם צריכים לדעת אותם. ");
INSERT INTO heblb_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","אולם כשרוח הקודש יצלח עליכם, תקבלו כוח וסמכות להיות עדים לי בירושלים, ביהודה ושומרון ועד קצה העולם.“ ");
INSERT INTO heblb_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","זמן קצר לאחר מכן עלה ישוע לשמים לעיני תלמידיו, ונעלם בתוך ענן. ");
INSERT INTO heblb_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","בעוד התלמידים מאמצים את עיניהם כדי לזכות במבט נוסף, עמדו ביניהם לפתע שני אנשים לבושים גלימות לבנות, ");
INSERT INTO heblb_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ואמרו: ”אנשי הגליל, מדוע אתם עומדים ומביטים לשמים? ישוע אמנם עלה לשמים, אך יום אחד הוא יחזור בדיוק כפי שהלך מכם!“ ");
INSERT INTO heblb_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","כשקרה הדבר הזה הם היו בהר־הזיתים, ועתה חזרו ברגל לירושלים (מרחק של פחות מקילומטר). ");
INSERT INTO heblb_vpl VALUES ("AC1_13‏","074_1_13‏","ACT","1","13‏","14","כשהגיעו העירה, הם התאספו לתפילה בחדר העלייה שבו גרו. באסיפה זאת נכחו האנשים הבאים: פטרוס, יוחנן ויעקב, ‎אַנְדְּרֵי, פיליפוס, תומא, בר־תלמי, מתתיהו, יעקב בן־חלפי, שמעון מהקנאים, יהודה בן־יעקב ואחיו של ישוע. היו שם גם נשים אחדות, וביניהן אמו של ישוע. ");
INSERT INTO heblb_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","אסיפת התפילה נמשכה ימים אחדים, ויום אחד, כשנכחו שם מאה ועשרים איש, קם שמעון פטרוס ואמר: ");
INSERT INTO heblb_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","”אחים, נבואות התנ״ך צריכות היו להתקיים בנוגע ליהודה, אשר בגד בישוע והוביל אליו את ההמון, שהרי רוח הקודש דיבר על כך לפני זמן רב בפי דוד המלך. ");
INSERT INTO heblb_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","יהודה היה אחד מאיתנו; הוא נבחר בדיוק כמונו להיות שליח. ");
INSERT INTO heblb_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","בכסף שקיבל תמורת הבגידה הוא קנה לעצמו שדה, ושם מצא את מותו – הוא נפל ארצה על פניו, בטנו נבקעה ומעיו נשפכו החוצה. ");
INSERT INTO heblb_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","הידיעה על מותו התפשטה במהירות בין כל תושבי ירושלים, והם מכנים את המקום ההוא בשפתם ’חקל דמא‘, שפירושו ’שדה־הדם‘. ");
INSERT INTO heblb_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","דוד המלך ניבא על כך בתהלים, ואמר שביתו יהיה שומם ושאיש לא יישב בו. ובמקום אחר אמר דוד שתפקידו (של יהודה) יינתן למישהו אחר. ");
INSERT INTO heblb_vpl VALUES ("AC1_21‏","074_1_21‏","ACT","1","21‏","22","”משום כך עלינו לבחור במישהו אחר, אשר ימלא את מקומו של יהודה, ויצטרף אלינו בעדותנו על תחייתו של ישוע אדוננו. הבה נבחר באדם שהיה איתנו מאז הימים הראשונים – מאז שישוע נטבל על־ידי יוחנן ועד שנלקח מאיתנו לשמים.“ ");
INSERT INTO heblb_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","הנאספים נקבו בשני שמות: יוסף יוסטוס (שנקרא גם ”בר־שבא“) ומתתיהו. ");
INSERT INTO heblb_vpl VALUES ("AC1_24‏","074_1_24‏","ACT","1","24‏","25","לאחר מכן התפללו כולם וביקשו שייבחר האדם הנכון. ”אלוהים,“ התפללו, ”אתה המכיר כל לב, הראה נא לנו במי מהשניים בחרת למלא את מקומו של יהודה הבוגד, שהלך למקום הראוי לו!“ ");
INSERT INTO heblb_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","הם הפילו גורל כדי לבחור בין שני המועמדים, ושמו של מתתיהו עלה בגורל. באותו יום הצטרף מתתיהו אל אחד־עשר השליחים. ");
INSERT INTO heblb_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","שבעה שבועות חלפו מאז מותו של ישוע ותחייתו מן המתים, ויום חג השבועות הגיע. כשהתאספו המאמינים יחד באותו יום, ");
INSERT INTO heblb_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","נשמע לפתע קול סערה גדולה מן השמים, והרעש מילא את הבית שבו ישבו. ");
INSERT INTO heblb_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","הנוכחים ראו מעין לשונות אש קטנות יורדות ונחות על ראשיהם, ");
INSERT INTO heblb_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","וכל אחד מהם נמלא ברוח הקודש והחל לדבר בשפה שלא הייתה מוכרת לו, כי רוח הקודש העניק להם יכולת זאת. ");
INSERT INTO heblb_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","הרבה יהודים אדוקים מארצות שונות עלו לירושלים לרגל החג, ");
INSERT INTO heblb_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","ובשמעם את רעש הסערה מעל הבית ההוא, מיהרו אל המקום כדי לראות מה קרה. לתדהמתם הרבה כל אחד שמע את התלמידים מדברים בשפה שלו. ");
INSERT INTO heblb_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","”כיצד ייתכן הדבר?“ שאלו עולי־הרגל. ”הלא כל האנשים האלה גרים בגליל! ");
INSERT INTO heblb_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","כיצד הם יכולים לדבר בשפות המדוברות בארצות מולדתנו? ");
INSERT INTO heblb_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","הרי אנחנו פרתיים, מדיים, עילמיים, אנשי ארם־נהריים, יהודה, קפודקיה, פונטוס, אסיה הקטנה; ");
INSERT INTO heblb_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","פריגיה, פמפוליה, מצרים; יש בינינו אנשים מהאזורים שליד קוריניה שבלוב, ומרומא; ");
INSERT INTO heblb_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","יהודים וגרים, כרתים וערבים – וכל אחד מאיתנו שומע בשפתו כיצד אנשים אלה מספרים על מעשיו של אלוהים ועל נפלאותיו!“ ");
INSERT INTO heblb_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","כולם עמדו שם נבוכים ומבולבלים. ”מה פירושו של הדבר?“ שאלו זה את זה. ");
INSERT INTO heblb_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","אולם בקרב הקהל היו גם כאלה שלעגו: ”הם סתם שיכורים!“ ");
INSERT INTO heblb_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","שמעון פטרוס צעד קדימה, יחד עם אחד־עשר השליחים, ופנה אל ההמון: ”תושבי ירושלים ואורחיה, הקשיבו היטב לדברי. ");
INSERT INTO heblb_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","אחדים מכם טוענים שאנשים אלה שיכורים, אבל דעו לכם שהם אינם שיכורים! בני־אדם אינם נוהגים להשתכר בשעה תשע בבוקר! ");
INSERT INTO heblb_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","מה שאתם רואים כאן הבוקר כבר נובא לפני שנים רבות בפי יואל הנביא, אשר אמר: ");
INSERT INTO heblb_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","’והיה אחרי כן (באחרית הימים), אמר אלוהים, אשפוך את רוחי על כל בשר. ונבאו בניכם ובנותיכם, זקניכם חלמות יחלמון, בחוריכם חזינות יראו. ");
INSERT INTO heblb_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","וגם על העבדים ועל השפחות בימים ההמה אשפוך את רוחי. ");
INSERT INTO heblb_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","ונתתי מופתים בשמים ובארץ – דם ואש ותימרות עשן. ");
INSERT INTO heblb_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","השמש יהפך לחשך, והירח – לדם, לפני בוא יום ה׳ הגדול והנורא. ");
INSERT INTO heblb_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","והיה כל אשר יקרא בשם ה׳ ימלט!‘ ");
INSERT INTO heblb_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","”אנשי ישראל, הקשיבו!“ המשיך פטרוס. ”אלוהים אישר בפומבי שישוע המשיח אכן שליח משמים, באמצעות הניסים והנפלאות שחולל על־ידו, ואתם יודעים זאת היטב, שהרי הניסים והנפלאות נעשו אצלכם. ");
INSERT INTO heblb_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","אולם אלוהים, שפעל לפי תוכניתו הערוכה מראש, הרשה לכם להסגיר את ישוע לידי הרומאים, כדי שיוקיעו אותו ויהרגוהו. ");
INSERT INTO heblb_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","ואז אלוהים שחרר אותו מייסורי המוות והחזירו לחיים, כי המוות לא יכול היה להחזיק בו! ");
INSERT INTO heblb_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","”דוד המלך דיבר על ישוע כשאמר: ’שויתי ה׳ לנגדי תמיד, כי מימיני בל אמוט. ");
INSERT INTO heblb_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","לכן שמח לבי ויגל כבודי, אף בשרי ישכן לבטח, ");
INSERT INTO heblb_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","כי לא תעזב נפשי לשאול; לא תתן חסידך לראות שחת. ");
INSERT INTO heblb_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","תודיעני ארחות חיים, שבע שמחות את פניך‘. ");
INSERT INTO heblb_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","”אחים יקרים, חשבו נא! הרי דוד לא התכוון לעצמו כשאמר את הדברים שציטטתי זה עתה, שהרי הוא מת ונקבר, וקברו נמצא בעירנו עד היום הזה. ");
INSERT INTO heblb_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","אולם דוד היה נביא, ועל כן ידע היטב שה׳ הבטיח, בשבועה נצחית, שאחד מצאצאיו יהיה המשיח ויישב על כסאו. ");
INSERT INTO heblb_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","דוד חזה את העתיד הרחוק וניבא את תחייתו של המשיח, באמרו שנפש המשיח לא תישאר בשאול, ושגופו לא יירקב. ");
INSERT INTO heblb_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","הוא דיבר על המשיח, וכולנו עדים לכך שישוע זה, שעליו אנו מדברים, באמת קם מן המתים. ");
INSERT INTO heblb_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","”עתה יושב ישוע בשמים לימין האלוהים, וכפי שהובטח העניק לו אלוהים את הסמכות לשלוח את רוח הקודש, אשר גרם לכל מה שאתם רואים ושומעים היום. ");
INSERT INTO heblb_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","”לא, דוד לא התייחס אל עצמו בדברים שאמר, שהרי הוא מעולם לא עלה לשמים. מלבד זאת, דוד הוסיף ואמר במקום אחר: ’נאם ה׳ לאדני, שב לימיני, ");
INSERT INTO heblb_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","עד אשית אויביך הדם לרגליך‘. ");
INSERT INTO heblb_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","”משום כך אני קורא אל בית ישראל: דעו לכם שאלוהים הפקיד את ישוע, אשר צלבתם, להיות האדון והמשיח!“ ");
INSERT INTO heblb_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","דבריו של פטרוס נגעו ללב השומעים, והם פנו אליו ואל השליחים האחרים בשאלה: ”אחים, מה עלינו לעשות?“ ");
INSERT INTO heblb_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","”עליכם לחזור בתשובה ולהיטבל בשם ישוע המשיח, כדי שייסלחו לכם חטאיכם“, השיב פטרוס. ”ואז תקבלו את מתנת רוח הקודש. ");
INSERT INTO heblb_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","כי ה׳ הבטיח לתת את רוח הקודש לכל מי שיקרא בשם ה׳ אלוהינו, וגם לבניו – לרחוקים ולקרובים.“ ");
INSERT INTO heblb_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","פטרוס המשיך לספר להם על ישוע, והפציר בכל מאזיניו לחזור בתשובה ולהינצל מהדור הסורר הזה. ");
INSERT INTO heblb_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","כשלושת אלפים איש האמינו באותו יום לדבריו של פטרוס ונטבלו במים. ");
INSERT INTO heblb_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","הם הצטרפו אל יתר המאמינים, והשתתפו בקביעות בשיעוריהם של השליחים, בבציעת הלחם (כמצוות ישוע לזיכרון מותו) ובאסיפות תפילה. ");
INSERT INTO heblb_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","הניסים והנפלאות הרבים שחוללו השליחים מלאו את כולם יראת־כבוד לאלוהים. ");
INSERT INTO heblb_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","כל המאמינים התמידו להתאסף יחד, וחילקו ביניהם את כל מה שהיה להם. ");
INSERT INTO heblb_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","הם מכרו את כל רכושם, והתחלקו בכספם עם הנצרכים. ");
INSERT INTO heblb_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","מדי יום הם השתחוו יחד בבית־המקדש, נפגשו בבתיהם בקבוצות, לשם התחברות, ואכלו יחד את ארוחותיהם בשמחה ובהכרת־תודה. ");
INSERT INTO heblb_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","הם הללו את אלוהים, והם מצאו־חן בעיני כל העם. מדי יום הוסיף להם ה׳ את אלה שנושעו. ");
INSERT INTO heblb_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","יום אחד, בשעה שלוש אחר־הצהריים, הלכו פטרוס ויוחנן לתפילת מנחה בבית־המקדש. ");
INSERT INTO heblb_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","כשהגיעו אל המקדש, ראו אדם שהיה פיסח מלידה, יושב ליד השער הנקרא ”המהודר“. הוא הובא לשם מדי יום כדי לקבץ נדבות. ");
INSERT INTO heblb_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","כאשר עברו פטרוס ויוחנן לידו, הוא ביקש נדבה גם מהם. ");
INSERT INTO heblb_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","השניים נעצו באיש מבט נוקב, ופטרוס אמר לו: ”הבט אלי!“ ");
INSERT INTO heblb_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","הפיסח הרים את עיניו בתקווה לקבל תרומה נדיבה. ");
INSERT INTO heblb_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","אך פטרוס אמר: ”כסף אין לי, אולם אתן לך את מה שיש לי; בשם ישוע המשיח מנצרת, התהלך!“ ");
INSERT INTO heblb_vpl VALUES ("AC3_7‏","074_3_7‏","ACT","3","7‏","8","פטרוס אחז בידו של הפיסח והעמידו על רגליו. באותו רגע נרפאו רגלי האיש וקרסוליו התחזקו, הוא קפץ על רגליו והחל ללכת! האיש הלך איתם לבית־המקדש, כשהוא משבח את האלוהים, מקפץ ומדלג בשמחה. ");
INSERT INTO heblb_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","באי בית־המקדש, שראוהו הולך ומדלג, ושמעוהו מהלל את ה׳, ");
INSERT INTO heblb_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","הכירו את הקבצן הפיסח שנהגו לראות בשער המקדש, והופתעו מאוד. ");
INSERT INTO heblb_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","כולם מיהרו לצאת לאולם שלמה כדי לראות את הפלא, ואילו הקבצן נצמד בחזקה אל פטרוס ויוחנן. ");
INSERT INTO heblb_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","פטרוס ניצל את ההזדמנות ופנה אל העם: ”אנשי ישראל, מדוע אתם מופתעים כל־כך? מדוע אתם מביטים בנו כאילו שבכוחנו ובקדושתנו אנו אפשרנו לאיש הזה ללכת? ");
INSERT INTO heblb_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","אלוהי אברהם, יצחק ויעקב – אלוהי אבותינו – הוא שהביא כבוד ותפארת לשם עבדו ישוע באמצעות הנס שחולל. כן, אני מתכוון לאותו ישוע שמסרתם לרומאים, ושדחיתם את הצעת פילטוס לשחררו. ");
INSERT INTO heblb_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","סירבתם לשחרר את הקדוש והצדיק הזה, ודרשתם שפיליטוס ישחרר במקומו רוצח! ");
INSERT INTO heblb_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","וכך הרגתם את שר החיים; אך אלוהים הקימו מן המתים. יוחנן ואני עדים לעובדה זאת, כי לאחר שהרגתם את ישוע ראינו אותו חי וקיים. ");
INSERT INTO heblb_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","”האמונה בשמו של ישוע היא שריפאה אדם זה שכולכם הכרתם כפיסח. האמונה בישוע – שניתנה לנו מאלוהים – היא שריפאה אותו כליל! ");
INSERT INTO heblb_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","”אחים יקרים, אני יודע שכל מה שעשיתם אתם ומנהיגיכם לישוע, עשיתם מתוך בורות וחוסר ידיעה. ");
INSERT INTO heblb_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","אולם כך קיים אלוהים את הנבואות האומרות שהמשיח חייב לסבול. ");
INSERT INTO heblb_vpl VALUES ("AC3_19‏","074_3_19‏","ACT","3","19‏","20","לכן חזרו בתשובה והאמינו באלוהים, כדי שיסלח לחטאיכם, ייתן לכם ימי שגשוג ורווחה, ויחזיר לכם את המשיח המיועד – ישוע המשיח. ");
INSERT INTO heblb_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","כי המשיח צריך להישאר בשמים, עד שתגיע העת להשלים את הכול, כפי שאמרו הנביאים לפני זמן רב. ");
INSERT INTO heblb_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","משה רבנו אמר: ’נביא מקרבכם – מאחיכם – כמוני, יקים לכם ה׳ אלוהיכם, אליו תשמעון‘; הקשיבו לדבריו בכובד ראש! ");
INSERT INTO heblb_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","כי מי שלא ישמע בקולו ייענש חמורות בידי ה׳! ");
INSERT INTO heblb_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","”גם שמואל וכל הנביאים שקמו אחריו דברו על מה שמתרחש היום. ");
INSERT INTO heblb_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","אתם הצאצאים של אותם הנביאים, וגם אתם כלולים באותה הברית שכרת ה׳ עם אבותיכם, שבה הבטיח לברך את העולם כולו באמצעות עם ישראל. הרי ה׳ הבטיח לאברהם אבינו: ’והתברכו בזרעך כל גויי הארץ‘. ");
INSERT INTO heblb_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","וכאשר הקים אלוהים את עבדו ישוע מן המתים, הוא שלח אותו קודם כל אליכם, בני ישראל, כדי לברך אתכם שתחזרו בתשובה.“ ");
INSERT INTO heblb_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","בשעה שפטרוס ויוחנן דברו אל העם, ניגשו אליהם בכעס הכוהנים, הקצין הממונה על משמר בית־המקדש וכן אחדים מהצדוקים, ");
INSERT INTO heblb_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","מכיוון שהשניים לימדו את העם שישוע המשיח קם לתחייה, וכך הוכיחו שאכן תהיה תחיית המתים. ");
INSERT INTO heblb_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","הם תפסו את פטרוס ויוחנן, ומאחר שכבר ירד הערב, הכניסו אותם לכלא עד יום המחרת. ");
INSERT INTO heblb_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","אולם רבים מאלה שהאזינו לפטרוס האמינו לדבריו, ומספר המאמינים במשיח הגיע ל־חמשת־אלפים איש. ");
INSERT INTO heblb_vpl VALUES ("AC4_5‏","074_4_5‏","ACT","4","5‏","6","למחרת התכנסו מנהיגי העם בירושלים, כדי לערוך ישיבה עם חנן הכוהן הגדול, קייפא, יוחנן, אלכסנדר ועוד רבים מקרובי משפחתו של הכהן הגדול. ");
INSERT INTO heblb_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","הם העמידו לפניהם את פטרוס ויוחנן, ושאלו אותם: ”באיזה כוח ובאיזו סמכות עשיתם זאת?“ ");
INSERT INTO heblb_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","פטרוס שנמלא רוח הקודש, השיב: ”מנהיגים וזקני־העם הנכבדים, ");
INSERT INTO heblb_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","אם אתם מתכוונים לטובה שעשינו לאיש הפיסח הזה, אשר קם על רגליו בריא ושלם, ");
INSERT INTO heblb_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","הרשו לי להצהיר בפניכם ולפני כל עם־ישראל: עשינו מה שעשינו בשמו ובכוחו של ישוע המשיח מנצרת. אתם אמנם צלבתם את ישוע, אולם אלוהים הקים אותו מן המתים! בשמו ובסמכותו עומד האיש הזה לפניכם בריא ושלם. ");
INSERT INTO heblb_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","ישוע המשיח הוא אבן הפינה אשר אתם, הבונים, מאסתם בה, ואשר הייתה לראש פינה. ");
INSERT INTO heblb_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","איש מלבדו אינו יכול להושיע! ואין עוד שם תחת השמים אשר בני־האדם יכולים לקרוא אליו כדי להיוושע!“ ");
INSERT INTO heblb_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","כשראו הדיינים את אומץ לבם של פטרוס ויוחנן, ונוכחו לדעת שהם אנשים פשוטים, לא משכילים ולא ”מקצועיים“, התפלאו מאוד. הם זיהו אותם, שבעבר היו יחד עם ישוע. ");
INSERT INTO heblb_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","והדיינים לא יכלו להכחיש את עובדת ריפויו של הפיסח לשעבר, כי הוא עמד מולם בריא ושלם. ");
INSERT INTO heblb_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","הדיינים, אובדי־עצות, ציוו על פטרוס ויוחנן לצאת מאולם המשפט, כדי שיוכלו להתייעץ ביניהם. ");
INSERT INTO heblb_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","”מה נעשה בהם?“ שאלו זה את זה. ”איננו יכולים להכחיש שהם חוללו נס גדול, שהרי כל תושבי ירושלים שמעו על כך. ");
INSERT INTO heblb_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","אך אולי נוכל למנוע בעדם להמשיך להפיץ את התעמולה שלהם. נזהיר אותם שאם יעזו להמשיך להטיף בשם ישוע, נעניש אותם בחומרה רבה!“ ");
INSERT INTO heblb_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","הם קראו לפטרוס ויוחנן לשוב לאולם, ודרשו מהם שלא לדבר שוב על ישוע לעולם. ");
INSERT INTO heblb_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","אולם פטרוס ויוחנן השיבו: ”החליטו אתם בעצמכם, האם אלוהים רוצה שנשמע לקולו או לקולכם? ");
INSERT INTO heblb_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","איננו יכולים להפסיק לספר על כל אשר ישוע עשה לנגד עינינו, או על הדברים ששמענו מפיו!“ ");
INSERT INTO heblb_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","חברי הסנהדרין הוסיפו לגעור בהם ולאיים עליהם, אך לבסוף שחררו אותם, כי לא ידעו כיצד להענישם בלי לעורר מהומה בעם. שכן כל העם הלל את אלוהים על שחולל את הנס הנפלא הזה ");
INSERT INTO heblb_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","וריפא את האדם שהיה פיסח במשך ארבעים שנה. ");
INSERT INTO heblb_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","מיד לאחר שחרורם מיהרו פטרוס ויוחנן אל אחיהם המאמינים וסיפרו להם את דברי הסנהדרין. ");
INSERT INTO heblb_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","כששמעו המאמינים את הדבר, התפללו אל אלוהים בלב אחד: ”אדוננו, בורא השמים, הארץ, הים וכל אשר בם – ");
INSERT INTO heblb_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","עוד לפני זמן רב דיברת באמצעות רוח הקודש, בפי דוד המלך שהוא עבדך ואבינו, ואמרת: ’למה רגשו גוים, ולאומים יהגו ריק? ");
INSERT INTO heblb_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","יתיצבו מלכי ארץ ורוזנים נוסדו יחד על ה׳ ועל משיחו‘. ");
INSERT INTO heblb_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","”דבריך אלה התקיימו בעיר הזאת! שהרי המלך הורדוס ופונטיוס פילטוס כרתו ברית עם העמים השונים ועם בני־ישראל, וכולם יחד קמו נגד עבדך הקדוש ישוע המשיח. ");
INSERT INTO heblb_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","אולם הם עשו אך ורק את מה שבחוכמתך הרבה החלטת שיעשו. ");
INSERT INTO heblb_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","ועתה, ה׳, שמע נא את איומיהם, ותן לעבדיך אומץ־לב לבשר את דברך. ");
INSERT INTO heblb_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","שלח נא את כוחך המרפא, והנח לנו לחולל נסים ונפלאות רבים בשמו של עבדך הקדוש ישוע המשיח.“ ");
INSERT INTO heblb_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","לאחר שסיימו להתפלל הזדעזע הבית שבו ישבו. כולם נמלאו ברוח הקודש ובישרו את דבר ה׳ באומץ ובביטחון. ");
INSERT INTO heblb_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","כל המאמינים היו מאוחדים בלב אחד ובדעה אחת, ואיש לא התייחס אל אשר בידו כאל רכושו הפרטי; הכול היה משותף לכולם. ");
INSERT INTO heblb_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","השליחים דיברו בכוח ובגבורה על תקומתו של האדון ישוע, ואלוהים ברך אותם בכל מעשיהם. ");
INSERT INTO heblb_vpl VALUES ("AC4_34‏","074_4_34‏","ACT","4","34‏","35","לא היה ביניהם אף עני אחד, כי בעלי השדות ובעלי הבתים מכרו את נכסיהם ונתנו את הכסף לשליחים, כדי שיחלקו לאחרים לפי הצורך. ");
INSERT INTO heblb_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","היה ביניהם, למשל, אדם בשם יוסף (זה שהשליחים קראו לו ”בר־נבא“ או ”בן־הנחמה“), משבט לוי, יליד קפריסין. ");
INSERT INTO heblb_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","גם הוא מכר את השדה שלו, ואת הכסף הביא לשליחים כדי שיחלקו לנזקקים. ");
INSERT INTO heblb_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","אולם היה ביניהם גם אדם אחר בשם חנניה. הוא ואשתו ‎שַׁפִּירָה החליטו למכור את חלקת אדמתם. ");
INSERT INTO heblb_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","בהסכמת אשתו החביא חנניה חלק מהכסף שקיבל תמורת האדמה, ואת יתרת הסכום הביא אל השליחים, בהצהירו שזה כל הסכום שקיבל תמורת האדמה. ");
INSERT INTO heblb_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","”חנניה,“ אמר לו פטרוס, ”מדוע הנחת לשטן להשתלט על לבך? כשטענת שזהו הסכום כולו, שיקרת לרוח הקודש! ");
INSERT INTO heblb_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","הרכוש היה שלך, והיית רשאי למכרו או להחזיק בו. גם לאחר שמכרת אותו היה מותר לך להחליט איזה חלק מהסכום לתת. כיצד יכולת לעשות דבר כזה? לא לנו שיקרת, כי אם לה׳!“ ");
INSERT INTO heblb_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","ברגע ששמע חנניה מילים אלה, צנח ארצה ומת. כל הנוכחים נבהלו מאוד. ");
INSERT INTO heblb_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","באו בחורים אחדים וכיסו אותו בסדין, הוציאוהו החוצה וקברו אותו. ");
INSERT INTO heblb_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","כשלוש שעות לאחר מכן באה לשם אשתו של חנניה, בלי שידעה דבר על מה שקרה. ");
INSERT INTO heblb_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","”אמרי לי,“ פנה אליה פטרוס, ”האם מכרתם את אדמתכם במחיר כזה וכזה?“ ”כן,“ ענתה שַׁפִּירָה, ”במחיר הזה מכרנו את האדמה.“ ");
INSERT INTO heblb_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","”כיצד יכולתם, את ובעלך, אפילו להעלות על דעתכם לנסות את רוח ה׳?“ קרא פטרוס. ”מאחורי הדלת הזאת עומדים הבחורים שקברו זה עתה את בעלך, ובעוד רגע הם יישאו גם אותך החוצה!“ ");
INSERT INTO heblb_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","באותו רגע נפלה גם שַׁפִּירָה על הרצפה ומתה. כשנכנסו הצעירים וראו שהיא מתה, נשאו אותה החוצה וקברו אותה לצד בעלה. ");
INSERT INTO heblb_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","אימה גדולה נפלה על כל הקהל ועל כל מי ששמע מה קרה. ");
INSERT INTO heblb_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","בינתיים המשיכו השליחים להתאסף בקביעות בבית־המקדש, באגף הנקרא ”אולם שלמה“, וחוללו נסים ונפלאות לעיני כל העם. ");
INSERT INTO heblb_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","המאמינים האחרים לא העזו להצטרף אל השליחים, אך כולם התייחסו אליהם ביראת כבוד. ");
INSERT INTO heblb_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","ומספר הגברים והנשים שהאמינו באדון ישוע הלך וגדל מיום ליום. ");
INSERT INTO heblb_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","החולים הוצאו לרחובות על מיטות ומזרונים, כדי שייפול עליהם צילו של פטרוס בשעה שיעבור שם. ");
INSERT INTO heblb_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","אנשים רבים מערי הסביבה נהרו לירושלים והביאו איתם חולים ואחוזי־שדים, וכולם נרפאו. ");
INSERT INTO heblb_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","הכהן הגדול וידידיו מבין הצדוקים הגיבו בזעם ובקנאה. ");
INSERT INTO heblb_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","הם תפסו את השליחים וכלאו אותם בבית־הסוהר העירוני. ");
INSERT INTO heblb_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","אולם באותו לילה בא מלאך ה׳, פתח את שערי הכלא, שלח אותם לחופשי ואמר להם: ");
INSERT INTO heblb_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","”שובו לבית־המקדש והמשיכו לבשר לעם את כל דברי החיים האלה!“ ");
INSERT INTO heblb_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","השליחים הגיעו לפנות־בוקר לבית־המקדש, ומיד החלו ללמד את העם. מאוחר יותר הגיעו למקדש הכהן הגדול ופמלייתו, ולאחר שכינסו את כל חברי הסנהדרין, שלחו לקרוא לשליחים שבכלא כדי להעמידם לדין. ");
INSERT INTO heblb_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","אולם כשהגיעו אנשי המשמר לכלא, לא מצאו שם את השליחים! הם חזרו אל המועצה ודיווחו: ");
INSERT INTO heblb_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","”שערי בית־הסוהר היו נעולים, והשומרים עמדו על משמרתם; אך כשפתחנו את השערים לא מצאנו איש בפנים!“ ");
INSERT INTO heblb_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","ראשי הכוהנים ומפקד משמר־המקדש נבהלו מאוד ותהו כיצד ייגמר העניין. ");
INSERT INTO heblb_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","כעבור זמן קצר בא מישהו והודיע: ”האנשים שאסרתם עומדים בבית־המקדש ומלמדים את העם!“ ");
INSERT INTO heblb_vpl VALUES ("AC5_26‏","074_5_26‏","ACT","5","26‏","27","מפקד משמר המקדש וסגניו הלכו ועצרו את השליחים, (אולם לא השתמשו בכוח הזרוע, כי פחדו שאם יפגעו בשליחים לרעה יסקול אותם ההמון באבנים) והביאו אותם לפני הסנהדרין. ");
INSERT INTO heblb_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","”האם לא אמרנו לכם שלא לדבר יותר לעולם על הישוע הזה?“ דרש הכהן הגדול. ”במקום לשמוע לקולנו הפצתם את תורתכם בכל ירושלים, ומלבד זאת אתם עוד מנסים להטיל עלינו את האשמה במותו!“ ");
INSERT INTO heblb_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","על כך ענו פטרוס והשליחים: ”עלינו לשמוע קודם כל לקול אלוהים, ורק לאחר מכן לקולם של בני־אדם! ");
INSERT INTO heblb_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","אלוהי אבותינו החזיר את ישוע לחיים, לאחר שהרגתם אותו בתלייה על הצלב. ");
INSERT INTO heblb_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","ואז, בגבורה גדולה, העלה אותו האלוהים למעלת שר ומושיע, כדי לתת לבני־ישראל הזדמנות לחזור בתשובה ולקבל סליחה על חטאיהם. ");
INSERT INTO heblb_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","אנחנו עדים לדברים אלה, וכן גם רוח הקודש שנתן ה׳ לכל מי ששומע בקולו.“ ");
INSERT INTO heblb_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","דברים אלה הרגיזו כל־כך את חברי הסנהדרין, עד שהחליטו להוציא את השליחים להורג. ");
INSERT INTO heblb_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","אולם פרוש אחד מחברי הסנהדרין, גמליאל שמו, קם על רגליו ודרש להוציא את השליחים מן האולם עד שיסיים לומר את דבריו (הוא היה בקיא בתורה ונכבד מאוד בעיני העם). ");
INSERT INTO heblb_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","לאחר מכן פנה אל חברי הסנהדרין ואמר: ”אנשי ישראל, עליכם לשקול היטב ובכובד ראש מה שאתם עומדים לעשות לאנשים האלה. ");
INSERT INTO heblb_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","אל תשכחו שלפני זמן־מה קם אותו ברנש תודס, והעמיד פנים שהוא איש חשוב. כ־400 איש הצטרפו אליו, אולם לאחר שנהרג התפזרו תלמידיו לכל עבר. ");
INSERT INTO heblb_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","”לאחר תודס, בזמן מפקד התושבים, קם יהודה הגלילי. הוא משך אחריו תלמידים רבים, אך גם הוא מת וכל תלמידיו נעלמו. ");
INSERT INTO heblb_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","”משום כך אני מציע שתעזבו את האנשים האלה לנפשם. אם התורה הזאת שהם מלמדים בדויה מלבם – היא תישכח במהרה. ");
INSERT INTO heblb_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","אך אם היא מאלוהים – לא תוכלו לעצור את האנשים האלה; אתם עלולים למצוא את עצמכם נלחמים נגד אלוהים!“ ");
INSERT INTO heblb_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","חברי הסנהדרין קיבלו את עצתו של רבן גמליאל. הם הכניסו את השליחים אל האולם, הלקו אותם בשוטים, ציוו עליהם שלא לדבר יותר לעולם בשם ישוע, ולבסוף שחררו אותם. ");
INSERT INTO heblb_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","השליחים יצאו מאולם בית הדין בלב שמח, משום שה׳ מצא אותם ראויים לסבול חרפה למען שם ישוע. ");
INSERT INTO heblb_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","ויום יום, בבית־המקדש ובבתים, המשיכו ללמד שישוע הוא המשיח. ");
INSERT INTO heblb_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","באותם הימים, כשמספר התלמידים הלך וגדל במהירות, החלו להישמע ביניהם תלונות ומריבות. היהודים שהגיעו מחו״ל ודיברו רק יוונית התלוננו שהאלמנות שלהם מופלות לרעה; בשעת חלוקת המזון היומית אין הן מקבלות אותה הכמות הניתנת לאלמנות מקרב המקומיים דוברי העברית. ");
INSERT INTO heblb_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","משום כך כנסו שנים־עשר השליחים את כל המאמינים לאסיפה כללית. ”עלינו להקדיש את זמננו לבישור דבר אלוהים, ולא לעסוק בבעיות חולין כמו חלוקת אוכל!“ אמרו השליחים. ");
INSERT INTO heblb_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","”אחים יקרים, הביטו סביבכם ובחרו שבעה אנשים נבונים, מלאים ברוח הקודש ובעלי שם טוב, והפקידו בידם את העניין הזה. ");
INSERT INTO heblb_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","וכך נוכל אנחנו להתרכז בתפילה, בהטפה ובהוראה.“ ");
INSERT INTO heblb_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","ההצעה נתקבלה על־ידי כל חברי הקהילה, והם בחרו באנשים הבאים: סטפנוס (שהיה מלא אמונה ורוח הקודש בצורה בולטת במיוחד), פיליפוס, פרוכורוס, ניקנור, טימון, פרמנס, ניקולס מאנטיוכיה (אשר היה גוי שהתגייר, ולאחר מכן האמין בישוע המשיח). ");
INSERT INTO heblb_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","שבעה אנשים אלה הוצגו בפני השליחים, וקיבלו את ברכתם בסמיכת ידיים ובתפילה. ");
INSERT INTO heblb_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","דבר האלוהים נשמע בחוגים הולכים וגדלים, ומספר התלמידים בירושלים גדל מאוד. גם כוהנים רבים האמינו בישוע המשיח. ");
INSERT INTO heblb_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","סטפנוס, שהיה כאמור מלא אמונה ורוח הקודש, חולל נסים ונפלאות בקרב העם. ");
INSERT INTO heblb_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","אולם יום אחד קמו מספר אנשים מקבוצת ”החופשיים“ והחלו להתווכח איתו. עד מהרה הצטרפו אליהם יהודים מקוריניה, מאלכסנדריה שבמצרים, מקיליקיה ומאסיה הקטנה, ");
INSERT INTO heblb_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","אך איש מהם לא יכול היה לגבור על החוכמה ועל הרוח שהיו בו. ");
INSERT INTO heblb_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","לכן הם שחדו כמה אנשים, כדי שיעידו נגד סטפנוס ויטענו ששמעו אותו מקלל את משה רבנו ואפילו את אלוהים. ");
INSERT INTO heblb_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","אשמת השקר הזאת עוררה את זעם ההמונים ואת כעסם של המנהיגים על סטפנוס. הם אסרו אותו והעמידוהו לדין לפני הסנהדרין. ");
INSERT INTO heblb_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","עדי השקר העידו נגד סטפנוס וטענו שאינו מפסיק לדבר נגד בית־המקדש ונגד התורה. ");
INSERT INTO heblb_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","”במו אוזנינו שמענו אותו אומר שאותו אדם, ישוע מנצרת, יהרוס את בית־המקדש וישנה את החוקים שמסר לנו משה!“ הצהירו עדי השקר. ");
INSERT INTO heblb_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","באותו רגע הביטו כל חברי הסנהדרין בסטפנוס וראו את פניו, ממש כפני מלאך אלוהים! ");
INSERT INTO heblb_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","”האם נכונות ההאשמות האלה?“ שאל הכהן הגדול את סטפנוס. ");
INSERT INTO heblb_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","”הקשיבו אלי, אנשים, אחים וזקנים נכבדים!“ השיב סטפנוס. ”אלוהי הכבוד נגלה אל אברהם אבינו בארם נהריים, לפני שיצא לחרן, ");
INSERT INTO heblb_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","ואמר לו לעזוב את ארץ מולדתו, להיפרד מבני משפחתו וללכת אל הארץ שה׳ ינחה אותו אליה. ");
INSERT INTO heblb_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","אברהם עזב את אור כשדים וגר בחרן עד מות אביו. לאחר מכן הביא אותו ה׳ לכאן, לארץ הזאת אשר אתם גרים בה עכשיו. ");
INSERT INTO heblb_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","אלוהים לא נתן לאברהם רכוש משלו – אפילו לא חלקת־אדמה קטנה; הוא רק הבטיח לו שבמרוצת הזמן תשתייך כל הארץ לאברהם ולצאצאיו, אך כי באותה עת לא היה לו עדיין ילד. ");
INSERT INTO heblb_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","כמו־כן אמר לו אלוהים שצאצאיו אלה יעזבו את ארצם ויגורו בארץ זרה, ושם יהיו עבדים במשך ארבע מאות שנה. ");
INSERT INTO heblb_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","אולם אלוהים הבטיח לאברהם שיעניש את הארץ אשר תשעבד אותם, ושלאחר מכן יצאו ויעבדו אותו כאן. ");
INSERT INTO heblb_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","”באותה עת נתן ה׳ לאברהם את מצוות המילה, כהוכחה לברית שכרת עם אברהם, וכאשר נולד בנו יצחק מל אותו אברהם ביום השמיני לחייו. כעבור זמן יצחק מל את יעקב, ויעקב את שנים־עשר האבות. ");
INSERT INTO heblb_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","”אותם אנשים שהיו לאבות האומה הישראלית קנאו ביוסף אחיהם, ומכרו אותו כעבד לישמעאלים שהיו בדרכם למצרים. אולם אלוהים היה עם יוסף ");
INSERT INTO heblb_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","והציל אותו מכל צרותיו. אלוהים העניק ליוסף חן רב וחכמה בלתי־רגילה, אשר מצאו־חן בעיני פרעה מלך מצרים, ומשום כך מינה אותו פרעה למושל על כל ארץ מצרים ולאחראי על כל ענייני הארמון. ");
INSERT INTO heblb_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","”כעבור זמן־מה שרר רעב כבד אשר גרם סבל רב במצרים ובכנען, ולאבותינו לא היה מה לאכול. ");
INSERT INTO heblb_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","כאשר שמע יעקב שיש עדיין אוכל במצרים, שלח לשם את בניו בפעם הראשונה כדי לקנות מה שיוכלו להשיג. ");
INSERT INTO heblb_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","בביקורם השני במצרים גילה להם יוסף את זהותו ואף הציג אותם לפני פרעה. ");
INSERT INTO heblb_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","יוסף שלח להביא מארץ כנען את יעקב אביו ואת כל בני־משפחתו, כולם יחד מנו שבעים וחמש איש, והזמין אותם לגור איתו במצרים. ");
INSERT INTO heblb_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","וכך ירד יעקב למצרים. לאחר שמתו יעקב ובניו, ");
INSERT INTO heblb_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","נלקחו גופותיהם לשכם ונקברו בקבר שקנה אברהם מיד בני־חמור. ");
INSERT INTO heblb_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","”כשקרב המועד שקבע אלוהים לשחרור בני־ישראל מעבדותם, כפי שהבטיח לאברהם אבינו, התרבה עם ישראל במצרים במהירות גדולה. ");
INSERT INTO heblb_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","ואז עלה לשלטון מלך אשר לא כיבד את זכרו של יוסף. ");
INSERT INTO heblb_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","מלך זה נהג בעמנו ברשעות ובאכזריות, וציווה על אבותינו להפקיר את ילדיהם למוות. ");
INSERT INTO heblb_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","באותה תקופה נולד משה, שהיה טוב בעיני אלוהים, והוריו הסתירוהו בביתם במשך שלושה חודשים. ");
INSERT INTO heblb_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","כשלא יכלו הוריו להסתיר אותו יותר נאלצו להוציאו מן הבית, מצאה אותו בת פרעה ואימצה אותו לה לבן. ");
INSERT INTO heblb_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","משה לומד בכל חכמת מצרים, גדל והיה לנואם מחונן ולאיש־מעשים דגול. ");
INSERT INTO heblb_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","”יום אחד עלה בדעתו של משה לבקר את אחיו בני־ישראל, והוא בן ארבעים. ");
INSERT INTO heblb_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","בעת ביקורו ראה איש מצרי מתאכזר אל ישראלי. משה ניגש אל המצרי והרג אותו. ");
INSERT INTO heblb_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","הוא קיווה שאחיו יבינו שאלוהים שלח אותו לעזור להם, אך הם לא הבינו זאת. ");
INSERT INTO heblb_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","”למחרת שוב ביקר משה את בני־עמו, והפעם ראה שני ישראלים רבים ביניהם. הוא ניסה להפריד ביניהם ואמר: ’הרי אחים אתם; מדוע אתם מתקוטטים?‘ ");
INSERT INTO heblb_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","”אולם האיש שהחל בקטטה דרש ממשה להסתלק ולא להתערב. ’מי מינה אותך למושל ושופט עלינו?‘ שאל. ");
INSERT INTO heblb_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","’האם אתה עומד להרוג אותי כשם שהרגת אתמול את המצרי?‘ “ ");
INSERT INTO heblb_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","לשמע דברים אלה ברח משה למדיין, ושם נולדו שני בניו. ");
INSERT INTO heblb_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","”כעבור ארבעים שנה נגלה אליו מלאך ה׳ במדבר הר־סיני מתוך הסנה הבוער. ");
INSERT INTO heblb_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","המראה הבלתי־רגיל הפליא את משה; הוא רץ אל הסנה כדי להביט בו מקרוב, ואז שמע את קול ה׳: ");
INSERT INTO heblb_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","’אנוכי אלוהי אבותיך – אלוהי אברהם, יצחק ויעקב!‘ משה רעד מפחד ולא העז להרים את עיניו. ");
INSERT INTO heblb_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","”לפני כן אמר אלוהים למשה: ’של נעליך מעל רגליך, כי המקום אשר אתה עומד עליו אדמת־קודש הוא‘. ");
INSERT INTO heblb_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","ואלוהים המשיך: ’ראה ראיתי את עוני עמי אשר במצרים, ואת צעקתם שמעתי… וארד להצילו… ועתה לכה ואשלחך אל פרעה והוצא את עמי בני־ישראל ממצרים‘. ");
INSERT INTO heblb_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","”המדובר באותו משה אשר בני־ישראל דחוהו זמן־מה קודם לכן כאשר מחו: ’מי מינה אותך למושל ושופט עלינו?‘ אותו משה נשלח אליהם עתה להיות להם למנהיג ולמושיע! ");
INSERT INTO heblb_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","בעזרת ניסים גדולים וכבירים הוציא משה את עמו מארץ מצרים, העבירם דרך ים סוף, ולאחר מכן נדד איתם במדבר ארבעים שנה. ");
INSERT INTO heblb_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","זהו אותו משה אשר אמר לבני־ישראל: ’נביא מקרבכם – מאחיכם – כמוני, יקים לכם אלוהים, אליו תשמעון‘. ");
INSERT INTO heblb_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","כשהתקהלו בני־ישראל במדבר, משה היה האיש שתיווך בינם לבין המלאך שנתן להם את תורת ה׳ – את דבר האלוהים החי – בהר סיני. ");
INSERT INTO heblb_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","”אולם אבותינו דחו את משה ורצו לשוב למצרים. ");
INSERT INTO heblb_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","’עשה לנו אלוהים אשר ילכו לפננו‘, ביקשו מאהרון, ’כי איננו יודעים מה קרה למשה אשר הוציא אותנו מארץ מצרים‘. ");
INSERT INTO heblb_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","וכך עשו להם בני ישראל עגל־זהב, הקריבו לו קורבנות, ושמחו באליל שיצרו במו ידיהם. ");
INSERT INTO heblb_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","”משום כך פנה להם ה׳ עורף והניח להם לסגוד לשמש, לירח ולכוכבים כמו לאלים! בספר עמוס שואל ה׳ את עם ישראל: ’הזבחים ומנחה הגשתם לי במדבר ארבעים שנה, בית ישראל? ");
INSERT INTO heblb_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","לא! התעניינותכם האמיתית הייתה באלילים שלכם: בסוכתו של מולך, בכוכבו של ריפן, ובכל הצלמים שעשיתם לכם. משום כך אגרש אתכם מכאן לארץ רחוקה – עד מעבר לבבל אגלה אתכם!‘. ");
INSERT INTO heblb_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","”במשך נדודיהם במדבר נשאו אותם אבותינו את משכן העדות, ובתוכו שמרו את לוחות־הברית. משכן זה נבנה בדיוק לפי הדגם שהראה אלוהים למשה. ");
INSERT INTO heblb_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","שנים רבות לאחר מכן, כשפקד יהושע על הקרבות נגד הגויים שישבו בכנען, הביאו האבות את המשכן הזה אל ארצם החדשה, ושם הוא נשאר עד ימי דוד המלך. ");
INSERT INTO heblb_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","”דוד, שמצא־חן בעיני אלוהים, ביקש את הזכות לבנות מקדש קבע לאלוהי יעקב. ");
INSERT INTO heblb_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","אולם רק בנו של דוד, שלמה, זכה לבנות את המקדש הזה. ");
INSERT INTO heblb_vpl VALUES ("AC7_48‏","074_7_48‏","ACT","7","48‏","49","ובכל זאת, אלוהים אינו שוכן במקדש מעשה ידי־אדם. ’השמים כסאי‘, אמר ה׳ בפי ישעיהו הנביא, ’והארץ – הדום רגלי. אי־זה בית אשר תבנו לי? ואי־זה מקום מנוחתי? ");
INSERT INTO heblb_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","(הלא) את כל אלה ידי עשתה!‘. ");
INSERT INTO heblb_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","הו עם קשה עורף ועובד אלילים! עד מתי תמשיכו להתנגד לרוח הקודש? אתם נוהגים בדיוק כמו אבותיכם – גם הם התנגדו לרוח הקודש. ");
INSERT INTO heblb_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","האם יכולים אתם לנקוב בשמו של נביא אחד שאבותיכם לא רדפו אותו? הם אפילו הרגו את אלה שניבאו את בואו של המשיח הצדיק – זה שבגדתם בו ורצחתם אותו! ");
INSERT INTO heblb_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","אכן, בכוונה תחילה הפרתם את תורת ה׳, אשר נמסרה לכם באמצעות המלאכים.“ ");
INSERT INTO heblb_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","כששמעו חברי הסנהדרין את האשמותיו של סטפנוס, נמלאו זעם וחרקו בשיניהם. ");
INSERT INTO heblb_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","אך סטפנוס, שהיה מלא רוח הקודש, נעץ מבטו בשמים, וראה את כבוד האלוהים ואת ישוע עומד לימין האלוהים. ");
INSERT INTO heblb_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","”הנני רואה את השמים נפתחים, ואת ישוע המשיח עומד לימין האלוהים!“ אמר להם סטפנוס. ");
INSERT INTO heblb_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","לשמע דברים אלה אטמו את אוזניהם, צרחו בכל כוחם והתנפלו עליו. ");
INSERT INTO heblb_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","הם גררו אותו אל מחוץ לעיר ורגמו אותו באבנים. מבצעי גזר־הדין פשטו את מעיליהם, והניחו אותם למשמרת לרגלי בחור אחד בשם שאול. ");
INSERT INTO heblb_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","בשעה שפגעו בו האבנים זו אחר זו התפלל סטפנוס: ”אדוני, ישוע, קבל נא את רוחי!“ ");
INSERT INTO heblb_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","ואז נפל על ברכיו וזעק: ”אדוני, סלח להם על החטא הזה!“ ובאותו רגע נפח את נשמתו. ");
INSERT INTO heblb_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","שאול עמד והסכים בהחלט להריגתו של סטפנוס. באותו יום החלה רדיפה גדולה נגד המאמינים בירושלים, וכולם – מלבד השליחים – ברחו ליהודה ושומרון. ");
INSERT INTO heblb_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","מספר אנשים יראי־אלוהים קברו את סטפנוס וספדו עליו בלב כואב. ");
INSERT INTO heblb_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","באותה עת התרוצץ שאול ממקום למקום בחוסר מנוחה והטריד את המאמינים, כשלפניו מטרה אחת: לחסל את הקהילה המשיחית. הוא אף פרץ לבתיהם של המאמינים, סחב משם גברים ונשים וכלא אותם בבית־הסוהר. ");
INSERT INTO heblb_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","באשר למאמינים שברחו מירושלים – הם הלכו ובישרו בכל מקום על אודות ישוע. ");
INSERT INTO heblb_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","פיליפוס, למשל, הגיע לשומרון וסיפר לתושבי האזור על המשיח. ");
INSERT INTO heblb_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","קהל גדול הקשיב לדבריו בתשומת לב והתפעל מהניסים שחולל. ");
INSERT INTO heblb_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","הרבה רוחות רעות גורשו ויצאו מאנשים בצעקות אימים, והרבה פיסחים ומשותקים נרפאו כליל. ");
INSERT INTO heblb_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","שמחה רבה הייתה בעיר. ");
INSERT INTO heblb_vpl VALUES ("AC8_9‏","074_8_9‏","ACT","8","9‏","11","באותה עיר היה אדם בשם שמעון, אשר עסק שנים רבות במעשי כשפים. הוא היה אדם גאה מאוד ובעל השפעה גדולה, בגלל הכשפים שעשה. השומרונים ממש העריצו אותו, והיו משוכנעים שהוא שליח אלוהים. ");
INSERT INTO heblb_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","אולם עתה הם האמינו לדבריו של פיליפוס: שישוע הוא המשיח, ושמלכות אלוהים קרבה; ונשים וגברים רבים נטבלו במים. ");
INSERT INTO heblb_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","גם שמעון המכשף האמין לדברי פיליפוס ונטבל במים. מיד לאחר מכן הלך שמעון בעקבות פיליפוס לכל אשר הלך, והשתומם מאוד למראה הניסים שחולל. ");
INSERT INTO heblb_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","כאשר שמעו השליחים בירושלים שאנשי שומרון האמינו בבשורת אלוהים, שלחו לשם את פטרוס ויוחנן. ");
INSERT INTO heblb_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","כשהגיעו השניים לשומרון החלו מיד להתפלל בעד המאמינים החדשים האלה, כדי שגם הם יקבלו את רוח הקודש. ");
INSERT INTO heblb_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","כי עד אז לא צלח רוח הקודש על איש מהם; הם רק נטבלו בשם ישוע. ");
INSERT INTO heblb_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","פטרוס ויוחנן סמכו את ידיהם על המאמינים החדשים, ואלה קיבלו את רוח הקודש. ");
INSERT INTO heblb_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","כשראה שמעון שרוח הקודש ניתן למאמינים באמצעות סמיכת הידיים של פטרוס ויוחנן, הציע להם כסף תמורת הכוח הזה. ");
INSERT INTO heblb_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","”תנו גם לי את הכוח הזה,“ ביקש, ”כדי שבני־אדם יוכלו לקבל את רוח הקודש כל פעם שאניח את ידי עליהם!“ ");
INSERT INTO heblb_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","אולם פטרוס ענה לו: ”כספך ילך יחד אתך לגיהינום! אתה חושב שאפשר לקנות בכסף את מתנת אלוהים? ");
INSERT INTO heblb_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","לא יהיה לך חלק בזה, משום שלבך אינו ישר לפני אלוהים. ");
INSERT INTO heblb_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","עליך לחזור בתשובה על החטא הנורא הזה ולהתפלל אל אלוהים. אולי הוא יסלח לך על מחשבותיך הרעות, ");
INSERT INTO heblb_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","מפני שאני רואה בתוך לבך קנאה, מרירות וחטא מרושע!“ ");
INSERT INTO heblb_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","”התפללו לאלוהים בעדי,“ התחנן שמעון, ”כדי שלא יבואו עלי הדברים הנוראים שאמרתם!“ ");
INSERT INTO heblb_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","לאחר שפטרוס ויוחנן בישרו את דבר ה׳ והעידו על המשיח בשומרון, חזרו לירושלים. בדרך הם ביקרו ברבים מכפרי השומרון ובישרו את דבר ה׳. ");
INSERT INTO heblb_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","ובאשר לפיליפוס – מלאך ה׳ נגלה אליו ואמר לו: ”קום ולך דרומה בדרך היורדת מירושלים לעזה.“ ");
INSERT INTO heblb_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","כשיצא פיליפוס לדרך בא לקראתו סריס כושי, אשר היה שר האוצר של קנדק מלכת כוש. הסריס עלה לירושלים כדי להשתחוות במקדש, ");
INSERT INTO heblb_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ועכשיו ישב במרכבתו בדרכו חזרה, וקרא בקול בספר ישעיהו. ");
INSERT INTO heblb_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","”גש אל המרכבה הזאת והישאר לידה“, הורה רוח הקודש לפיליפוס. ");
INSERT INTO heblb_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","פיליפוס רץ אל המרכבה ושמע את הסריס קורא בספר ישעיהו. ”האם אתה מבין את מה שאתה קורא?“ שאל פיליפוס. ");
INSERT INTO heblb_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","”ודאי שלא!“ ענה הסריס. ”כיצד אוכל להבין אם איש אינו מסביר לי?“ והוא ביקש מפיליפוס לעלות למרכבה ולשבת לידו. ");
INSERT INTO heblb_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","זה היה הקטע שהכושי קרא באותו זמן: ”כשה לטבח יובל וכרחל לפני גוזזיה נאלמה, ולא יפתח פיו. ");
INSERT INTO heblb_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","מעצר וממשפט לקח, ואת־דורו מי ישוחח? כי נגזר מארץ חיים.“ ");
INSERT INTO heblb_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","”על מי מדבר הנביא?“ שאל הסריס את פיליפוס. ”האם הוא מדבר על עצמו או על מישהו אחר?“ ");
INSERT INTO heblb_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","פיליפוס פתח בפסוק זה והחל לספר לו על אודות ישוע. ");
INSERT INTO heblb_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","הם המשיכו בדרכם והגיעו למקווה־מים קטן. ”ראה, הנה בריכת מים!“ קרא הסריס. ”מדוע שלא אטבל כאן?“ ");
INSERT INTO heblb_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","”אתה יכול להיטבל כאן,“ השיב פיליפוס, ”אם אתה מאמין בכל לבך!“ והכושי ענה: ”אני מאמין בכל לבי שישוע המשיח הוא בן האלוהים!“ ");
INSERT INTO heblb_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","הם עצרו את המרכבה, נכנסו לתוך המים, ופיליפוס הטביל את הסריס. ");
INSERT INTO heblb_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","כשיצאו שניהם מן המים נשאה משם רוח ה׳ את פיליפוס. הסריס לא ראה שוב את פיליפוס והוא המשיך בדרכו בלב שמח. ");
INSERT INTO heblb_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","בינתיים פיליפוס נראה באשדוד. הוא המשיך להטיף את הבשורה בכל עיר ובכל כפר, עד שהגיע לקיסריה. ");
INSERT INTO heblb_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","כל אותו זמן המשיך שאול לאיים על המאמינים המשיחיים באלימות וברצח. הוא הלך אל הכהן הגדול בירושלים ");
INSERT INTO heblb_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","וביקש ממנו מכתב אל בתי־הכנסת בדמשק. במכתב ביקש מבתי־הכנסת לשתף פעולה ברדיפת המאמינים המשיחיים שם, גברים ונשים כאחד, כדי ששאול יוכל לאסרם ולהביאם לירושלים. ");
INSERT INTO heblb_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","כשהתקרב שאול לדמשק במסגרת שליחותו, סנוורה אותו לפתע אלומת אור חזקה מן השמים. ");
INSERT INTO heblb_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","הוא נפל ארצה ושמע קול מדבר אליו: ”שאול, שאול, מדוע אתה רודף אותי?“ ");
INSERT INTO heblb_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","”מי אתה, אדוני?“ שאל שאול. ”אני ישוע שאותו אתה רודף!“ ענה הקול. ");
INSERT INTO heblb_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","”לך עכשיו העירה, וחכה להוראות נוספות!“ ");
INSERT INTO heblb_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","מלוויו של שאול עמדו נדהמים וחסרי־מילים, כי שמעו קול אך לא ראו איש. ");
INSERT INTO heblb_vpl VALUES ("AC9_8‏","074_9_8‏","ACT","9","8‏","9","כשקם שאול על רגליו גילה שהתעוור, ומלוויו היו צריכים להחזיק בידו ולהובילו לדמשק. עיוורונו נמשך שלושה ימים, וכל אותו זמן לא אכל ולא שתה. ");
INSERT INTO heblb_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","באותה עת גר בדמשק מאמין משיחי בשם חנניה. האדון נגלה אליו בחלום ואמר לו: ”חנניה!“ ”כן, אדוני!“ השיב חנניה. ");
INSERT INTO heblb_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","והאדון המשיך: ”לך לביתו של יהודה ברחוב ’הישר‘, ושאל שם על שאול מהעיר טרסוס. ברגע זה הוא מתפלל אלי, ");
INSERT INTO heblb_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ורואה בחזיון אדם בשם חנניה ניגש אליו וסומך עליו את ידיו, כדי שתשוב אליו ראייתו.“ ");
INSERT INTO heblb_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","”אבל, אדוני,“ קרא חנניה, ”שמעתי סיפורים רבים על הדברים הנוראים שעשה שאול זה למאמינים בך בירושלים! ");
INSERT INTO heblb_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","הוא בא לדמשק רק משום שקיבל רשות מראשי הכוהנים לאסור את כל המאמינים המשיחיים כאן!“ ");
INSERT INTO heblb_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","”לך ועשה מה שאמרתי לך,“ אמר האדון לחנניה, ”כי בחרתי בשאול להביא את בשורתי אל עמים רבים ומלכיהם ואל עם־ישראל. ");
INSERT INTO heblb_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","אני אראה לו כמה יהיה עליו לסבול למען שמי!“ ");
INSERT INTO heblb_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","חנניה הלך לביתו של יהודה, וכשמצא את שאול סמך עליו את ידיו ואמר: ”שאול אחי, האדון ישוע, אשר נראה אליך בדרך, שלח אותי אליך כדי שתימלא ברוח הקודש, וכדי שישוב אליך אור עיניך.“ ");
INSERT INTO heblb_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","”באותו רגע נפקחו עיניו של שאול, כאילו נפלו מהן קשקשים, וראייתו שבה אליו. הוא קם על רגליו ונטבל במים, ");
INSERT INTO heblb_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","ולאחר מכן אכל את ארוחתו הראשונה מזה שלושה ימים, וכוחו שב אליו. הוא נשאר עם המאמינים בדמשק ימים אחדים, ");
INSERT INTO heblb_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","ואחר כך החל לבקר בבתי־הכנסת השונים, וסיפר לכולם שישוע המשיח הוא באמת בן־האלוהים!“ ");
INSERT INTO heblb_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","כל מי ששמע את דברי שאול נדהם. ”האין זה אותו האיש שרדף באכזריות כה רבה את המאמינים המשיחיים בירושלים?“ שאלו. ”חשבנו שהוא בא לכאן כדי לאסור את המאמינים, ולהביאם כבולים בשרשרות אל ראשי הכוהנים!“ ");
INSERT INTO heblb_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","שאול הלך ונמלא כוח וגבורה, ויהודי דמשק לא יכלו להפריך את טענותיו והוכחותיו שישוע באמת המשיח. ");
INSERT INTO heblb_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","כעבור זמן־מה החליטו מנהיגי היהודים להרוג את שאול. ");
INSERT INTO heblb_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","אולם מישהו גילה לשאול את מזימתם, ואמר לו שהמנהיגים הציבו שומרים בשערי העיר, יומם ולילה, כדי לתפסו ולהרגו. ");
INSERT INTO heblb_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","לכן באותו לילה הבריחו אותו אחדים מהתלמידים אל מחוץ לעיר. הם הושיבו אותו בתוך סל גדול ושלשלוהו דרך פרצה אל מעבר לחומה. ");
INSERT INTO heblb_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","שאול הגיע לירושלים וניסה להיפגש עם המאמינים המשיחיים, אך כולם פחדו מפניו, כי חשבו שהוא מרמה אותם. ");
INSERT INTO heblb_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","בר־נבא בא לעזרתו של שאול ולקח אותו אל השליחים. הוא סיפר להם כיצד שאול ראה את האדון בדרך לדמשק, וכיצד שמע את דבריו. בר־נבא גם דיווח להם על הטפתו האמיצה והנלהבת של שאול בשם ישוע. ");
INSERT INTO heblb_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","לשמע דברים אלה קיבלו אותו השליחים לשורותיהם, ומאז היה שאול תמיד עם המאמינים, והטיף בשם האדון באומץ לב. ");
INSERT INTO heblb_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","שאול שוחח והתווכח גם עם היהודים דוברי היוונית, אולם הם זממו להרוג אותו. ");
INSERT INTO heblb_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","כשנודע לשאר האחים על הסכנה הנשקפת לו, לקחו אותו לקיסריה, ומשם שלחוהו לביתו שבטרסוס. ");
INSERT INTO heblb_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","בינתיים חדלו הרדיפות, וקהילות יהודה, הגליל והשומרון נהנו משקט ושלווה וגדלו בכוח ובמספר. רוח הקודש עודד את המאמינים, והם למדו להתהלך ביראת־ה׳. ");
INSERT INTO heblb_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","פטרוס נסע ממקום למקום כדי לבקר את הקהילות, ויום אחד בא לבקר את המאמינים בלוד. ");
INSERT INTO heblb_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","הוא פגש שם אדם משותק בשם אניאס, שהיה מרותק למיטתו כשמונה שנים. ");
INSERT INTO heblb_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","”אניאס,“ אמר לו פטרוס, ”ישוע המשיח ריפא אותך! קום וסדר את מיטתך!“ והוא נרפא מיד. ");
INSERT INTO heblb_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","כל תושבי לוד והשרון ראו את הנס והאמינו באדון. ");
INSERT INTO heblb_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","ביפו הייתה תלמידה אחת בשם צביה, שתמיד עשתה מעשי צדקה ועזרה בעיקר לעניים. ");
INSERT INTO heblb_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","באותם ימים חלתה צביה ומתה. ידידיה טיהרו את הגופה והניחו אותה בעליית־הגג. ");
INSERT INTO heblb_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","אולם כאשר נודע להם שפטרוס היה בקרבת המקום, מיהרו לשלוח שני אנשים ללוד, כדי לבקש ממנו שיבוא איתם ליפו. ");
INSERT INTO heblb_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","בלי להתמהמה הלך איתם פטרוס ליפו, וכשנכנס אל הבית הובילו אותו מיד אל החדר שבו שכבה צביה. החדר היה מלא אלמנות בוכיות, אשר הראו זו לזו חולצות ושמלות שצביה תפרה למענן. ");
INSERT INTO heblb_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","פטרוס ביקש מכולן לצאת מהחדר, ואז כרע על ברכיו והתפלל. לאחר מכן פנה אל הגופה וקרא: ”צביה, קומי!“ באותו רגע פקחה צביה את עיניה, ובראותה את פטרוס הזדקפה על מיטתה. ");
INSERT INTO heblb_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","הוא הושיט את ידו ועזר לה לעמוד על רגליה. אחר כך קרא פטרוס לכל האחים ולכל האלמנות והציג את צביה לפניהם. ");
INSERT INTO heblb_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","הידיעה המשמחת התפשטה במהירות בכל העיר, ואנשים רבים האמינו באדון. ");
INSERT INTO heblb_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","פטרוס נשאר ביפו זמן רב והתגורר אצל מעבד־עורות בשם שמעון. ");
INSERT INTO heblb_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","בקיסריה גר קצין רומאי בשם קורנליוס; הוא היה מפקד הגדוד האיטלקי שבמקום. ");
INSERT INTO heblb_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","קורנליוס וכל בני־משפחתו היו אנשים אדוקים ויראי־אלוהים. הוא היה איש תפילה, ונהג לחלק מתנות ותרומות ביד נדיבה. ");
INSERT INTO heblb_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","יום אחד, בשעה שלוש אחר־הצהריים, ראה קורנליוס לפתע מלאך ה׳ בחזיון. המלאך קרב אליו וקרא: ”קורנליוס!“ ");
INSERT INTO heblb_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","קורנליוס הביט בו בפחד ושאל: ”מה רצונך, אדוני?“ והמלאך השיב: ”אלוהים לא התעלם מתפילותיך ומנדיבות לבך! ");
INSERT INTO heblb_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","עליך לשלוח עתה מספר אנשים ליפו, כדי שימצאו את שמעון פטרוס ");
INSERT INTO heblb_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","אשר גר על חוף הים אצל שמעון מעבד־העורות, ויבקשו אותו לבוא אליך.“ ");
INSERT INTO heblb_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","ברגע שנעלם המלאך קרא קורנליוס לשניים ממשרתיו ולאחד משומרי ראשו, שהיה גם הוא איש ירא אלוהים, ");
INSERT INTO heblb_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","לאחר שסיפר להם את דבר החיזיון שלח אותם ליפו. ");
INSERT INTO heblb_vpl VALUES ("AC10_9‏","074_10_9‏","ACT","10","9‏","10","למחרת, בעוד השלושה מתקרבים אל העיר, עלה פטרוס על גג הבית כדי להתפלל. הייתה זאת שעת צהריים, ופטרוס, שהיה רעב, המתין לארוחתו. אולם עוד לפני שהייתה הארוחה מוכנה נפלה עליו תרדמה. ");
INSERT INTO heblb_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","הוא ראה את השמים נפתחים, ומתוכם ירד סדין גדול קשור בארבע קצותיו. ");
INSERT INTO heblb_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","בתוך הסדין היו כל מיני חיות טמאות, נחשים ועופות דורסים. ");
INSERT INTO heblb_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","”קום, פטרוס; שחט ואכול!“ קרא קול מן השמים. ");
INSERT INTO heblb_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","”חס וחלילה, אדוני!“, קרא פטרוס. ”מעולם לא אכלתי אוכל בלתי כשר או טמא!“ ");
INSERT INTO heblb_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","הקול דיבר אל פטרוס בשנית: ”אם אלוהים אומר שמשהו מסוים טהור, סימן שהוא טהור. אתה אל תקרא לו טמא!“ ");
INSERT INTO heblb_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","חזיון זה חזר ונשנה שלוש פעמים, ולאחר מכן הועלה הסדין חזרה לשמים. ");
INSERT INTO heblb_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","פטרוס היה נבוך ומבולבל. מה פשר החיזיון? מה עליו לעשות? בדיוק באותה שעה מצאו שליחיו של קורנליוס את ביתו של שמעון מעבד־העורות, ועמדו מאחורי השער. ");
INSERT INTO heblb_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","”האם כאן גר שמעון פטרוס?“ שאלו. ");
INSERT INTO heblb_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","בינתיים, בעוד פטרוס מהרהר בחזיון ובפשרו, אמר אליו רוח הקודש: ”שלושה אנשים באו הנה לפגוש אותך. ");
INSERT INTO heblb_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","רד למטה ולך אתם, כי אני שלחתי אותם.“ ");
INSERT INTO heblb_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","פטרוס ירד למטה, וכשראה את השלושה אמר: ”אני האיש אשר אתם מחפשים. מה רצונכם?“ ");
INSERT INTO heblb_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","”קורנליוס הקצין הרומאי שלח אותנו אליך“, השיבו השלושה. ”קורנליוס הוא איש ירא אלוהים, טוב־לב, נדיב ומכובד על ידי כל היהודים. מלאך ה׳ נגלה אליו בחזיון וציווה עליו להזמין אותך לביתו, כדי שתאמר לו מה עליו לעשות.“ ");
INSERT INTO heblb_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","פטרוס הזמין אותם להיכנס אל הבית וללון אצלו בלילה. למחרת היום הוא יצא אתם לדרך, ומאמינים אחרים מיפו הצטרפו אליו. ");
INSERT INTO heblb_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","כעבור יום הגיעה החבורה לקיסריה. קורנליוס שכבר ציפה לבואם, כינס בביתו את קרוביו וידידיו הטובים, כדי שגם הם יפגשו את פטרוס. ");
INSERT INTO heblb_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","כשנכנס פטרוס אל הבית נפל קורנליוס על ברכיו והשתחווה לו. ");
INSERT INTO heblb_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","”קום על רגליך“, אמר לו פטרוס. ”אני בן־אדם בדיוק כמוך!“ ");
INSERT INTO heblb_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","קורנליוס קם על רגליו ושוחח זמן־מה עם פטרוס. לאחר מכן נכנסו שניהם אל חדר האורחים – שם נתאספו רבים. ");
INSERT INTO heblb_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","פטרוס פנה אל הנוכחים ואמר: ”אתם יודעים שאסור ליהודי להיכנס לביתו של גוי. אולם אלוהים הראה לי בחזיון שאסור להתייחס אל שום אדם כאילו הוא טמא או נחות ממני. ");
INSERT INTO heblb_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","משום כך הסכמתי לבוא הנה מיד כשקראתם לי. אך האם מותר לי עתה לשאול מה אתם רוצים?“ ");
INSERT INTO heblb_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","”לפני ארבעה ימים,“ החל קורנליוס להסביר, ”התפללתי בביתי כרגיל, ובערך בשעה הזאת – בשעה שלוש – עמד לפני לפתע אדם לבוש גלימה זוהרת, ");
INSERT INTO heblb_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ואמר אלי: ’קורנליוס, אלוהים לא התעלם מתפילותיך ומנדיבות לבך! ");
INSERT INTO heblb_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","עליך לשלוח עתה מספר אנשים ליפו, כדי שימצאו את שמעון פטרוס, אשר גר על חוף הים אצל שמעון מעבד־העורות, ויבקשו אותו לבוא אליך‘. ");
INSERT INTO heblb_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","ובכן, מיד שלחתי לקרוא לך, ויפה מצדך שהזדרזת לבוא. הנה כולנו לפניך, מצפים לשמוע מפיך מה שציווה עליך אלוהים לומר לנו.“ ");
INSERT INTO heblb_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","פתח פטרוס ואמר: ”עתה אני רואה בבירור שאלוהים אינו נושא פנים, ");
INSERT INTO heblb_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","אלא כל אדם הירא את אלוהים ועושה מעשים טובים מוצא־חן בעיני אלוהים, בין אם הוא יהודי או גוי. ");
INSERT INTO heblb_vpl VALUES ("AC10_36‏","074_10_36‏","ACT","10","36‏","37","אני בטוח שכולכם שמעתם את הבשורה הטובה שבישר ה׳ לעם ישראל – שאפשר להתפייס עם אלוהים באמצעות ישוע המשיח, אשר הוא אדון כל הבריאה. מאז שהחל יוחנן להטביל את החוזרים בתשובה התפשטה הבשורה בכל הארץ – מהגליל ועד אזור יהודה. ");
INSERT INTO heblb_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","ודאי שמעתם שאלוהים משח את ישוע מנצרת ברוח הקודש ובגבורה, שהוא הסתובב בארץ ועזר לבני־אדם, ושריפא את כל אלה שהיו כבולים על־ידי השטן, משום שהאלוהים היה אתו. ");
INSERT INTO heblb_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","”אנחנו, השליחים, עדים לכל המעשים שעשה ישוע בכל ארץ ישראל, כולל ירושלים, עד אשר הומת על הצלב. ");
INSERT INTO heblb_vpl VALUES ("AC10_40‏","074_10_40‏","ACT","10","40‏","41","אולם שלושה ימים לאחר שנצלב החזירו אלוהים לחיים, והראה אותו לעיני אנשים מסוימים שבהם בחר מראש. אלוהים לא בחר את העדים האלה מבין הקהל הרחב, כי אם מבינינו. אנחנו אלה שאכלנו ושתינו איתו לאחר שקם מן המתים, ");
INSERT INTO heblb_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","והוא שלח אותנו לבשר את הבשורה הטובה הזאת בכל מקום, ולהעיד שאלוהים הסמיך את ישוע לשפוט את החיים ואת המתים. ");
INSERT INTO heblb_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","כל הנביאים כתבו עליו, ואמרו שכל המאמין בו ייסלחו לו כל חטאיו בזכותו.“ ");
INSERT INTO heblb_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","לפני שסיים פטרוס את דבריו צלח רוח הקודש על כל הנוכחים. ");
INSERT INTO heblb_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","היהודים המשיחיים, שבאו עם פטרוס מיפו, השתוממו לראות שמתנת רוח הקודש ניתנה גם לגויים. ");
INSERT INTO heblb_vpl VALUES ("AC10_46‏","074_10_46‏","ACT","10","46‏","47","אולם לא היה ספק בכך, כי הם שמעו אותם מדברים בשפות בלתי מובנות ומהללים את אלוהים. ”אנשים אלה קיבלו עתה את רוח הקודש ממש כמונו!“ קרא פטרוס. ”האם מישהו מתנגד לכך שאטביל אותם במים?“ ");
INSERT INTO heblb_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","וכך הוא הטביל אותם בשם ישוע המשיח. לאחר מכן ביקש ממנו קורנליוס להישאר אצלם ימים אחדים. ");
INSERT INTO heblb_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","עד מהרה נודע לשליחים ולשאר האחים ביהודה שגם הגויים נושעים על־ידי האמונה במשיח. ");
INSERT INTO heblb_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","כשחזר פטרוס לירושלים החלו היהודים המשיחיים למתוח עליו ביקורת. ");
INSERT INTO heblb_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","”אתה ביקרת בביתם של גויים, ואפילו אכלת איתם!“ טענו. ");
INSERT INTO heblb_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","ואז סיפר להם פטרוס את הסיפור כולו – מראשיתו ועד סופו: ");
INSERT INTO heblb_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","”יום אחד בשעה שהתפללתי ביפו ראיתי חזיון: סדין גדול, קשור בארבע קצותיו, הורד מן השמים. ");
INSERT INTO heblb_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","בתוך הסדין היו כל מיני חיות, זוחלים ועופות טרפים. ");
INSERT INTO heblb_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","לאחר מכן שמעתי קול מן השמים שקרא: ’קום, פטרוס, שחט ואכול!‘ “ ");
INSERT INTO heblb_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","” ’חס וחלילה, אדוני!‘ עניתי. ’מעולם לא אכלתי אוכל בלתי כשר או טמא!‘ ");
INSERT INTO heblb_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","”אולם אותו קול מן השמים חזר ואמר: ’אם אלוהים אומר שמשהו מסוים טהור, סימן שהוא טהור. אתה אל תקרא לו טמא!‘ ");
INSERT INTO heblb_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","”חזיון זה חזר ונשנה שלוש פעמים, ולאחר מכן הועלה הסדין לשמים. ");
INSERT INTO heblb_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","באותה שעה הגיעו אל הבית שבו התארחתי שלושה אנשים שנשלחו מקיסריה, ");
INSERT INTO heblb_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","ורוח הקודש אמר לי ללכת איתם ללא היסוס, למרות היותם גויים! ששת האחים האלה הצטרפו אלי, וכעבור יום הגענו לקיסריה – לביתו של האדם ששלח את השלושה. ");
INSERT INTO heblb_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","הוא סיפר לנו שמלאך ה׳ נגלה אליו וציווה עליו לשלוח אנשים ליפו, כדי למצוא את שמעון פטרוס. ");
INSERT INTO heblb_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","’הוא יאמר לך ולבני ביתך כיצד תוכל להיוושע!‘ אמר לו המלאך. ");
INSERT INTO heblb_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","”כשהתחלתי לבשר להם צלח רוח הקודש על הנאספים, בדיוק כפי שצלח עלינו בתחילה. ");
INSERT INTO heblb_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","ואז נזכרתי בדברי האדון: ’יוחנן הטביל אתכם במים, אולם עוד זמן־מה תיטבלו ברוח הקודש‘. ");
INSERT INTO heblb_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","ואם אלוהים נתן לגויים האלה אותה המתנה שנתן לנו, כשהאמנו באדון ישוע המשיח, מי אני שאתווכח אתו?“ ");
INSERT INTO heblb_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","דבריו של פטרוס השביעו את רצונם של היהודים המשיחיים, והם החלו להלל ולשבח את האלוהים. ”כן,“ אמרו, ”גם לגויים העניק אלוהים את הזכות לחזור בתשובה ולקבל חיי נצח!“ ");
INSERT INTO heblb_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","המאמינים אשר נמלטו מירושלים, בעת הרדיפה שהחלה לאחר מותו של סטפנוס, הגיעו בינתיים עד צור וצידון, קפריסין ואנטיוכיה. בכל מקום הם הכריזו על הבשורה, אבל רק ליהודים. ");
INSERT INTO heblb_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","אך מאמינים אחדים, שנסעו מקפריסין וקוריניה לאנטיוכיה, סיפרו גם לכמה יוונים על האדון ישוע. ");
INSERT INTO heblb_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","האדון ברך את מאמציהם, וגויים רבים האמינו באדון ישוע. ");
INSERT INTO heblb_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","כששמעו על כך חברי הקהילה בירושלים, שלחו את בר־נבא לאנטיוכיה כדי לעזור למאמינים החדשים. ");
INSERT INTO heblb_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","כשהגיע בר־נבא לאנטיוכיה וראה את מעשיו הנפלאים של ה׳, הוא נמלא שמחה רבה ועודד את המאמינים לדבוק באדון בכל מחיר. ");
INSERT INTO heblb_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","בר־נבא היה אדם טוב לב, מלא רוח הקודש ובעל אמונה חזקה. באותה עת נוספו אנשים רבים לקהל המאמינים. ");
INSERT INTO heblb_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","לאחר מכן נסע בר־נבא לטרסוס כדי לחפש את שאול, ");
INSERT INTO heblb_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","וכשמצא אותו, חזר עמו לאנטיוכיה. השניים נשארו באנטיוכיה שנה שלמה ולימדו את המאמינים החדשים והרבים (שם, באנטיוכיה, החלו לכנות את תלמידי ישוע המשיח בשם ”משיחיים“). ");
INSERT INTO heblb_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","באותה תקופה באו לאנטיוכיה נביאים אחדים מירושלים. ");
INSERT INTO heblb_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","אחד מהם, אגבוס שמו, קם באחת האספות וניבא, בהשראת רוח הקודש, שרעב כבד יבוא על כל האימפריה הרומאית (נבואתו התגשמה בתקופת שלטונו של קלודיוס). ");
INSERT INTO heblb_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","משום כך החליטו המאמינים באנטיוכיה לשלוח עזרה כספית לאחיהם ביהודה, כל אחד כפי יכולתו. ");
INSERT INTO heblb_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","לאחר שאספו את התרומות מסרו אותן לבר־נבא ולשאול, כדי שיביאו אותן לזקני הקהילה בירושלים. ");
INSERT INTO heblb_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","באותם הימים התנכל המלך הורדוס למאמינים אחדים, ");
INSERT INTO heblb_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","אף הוציא להורג את יעקב השליח, אחיו של יוחנן. ");
INSERT INTO heblb_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","כשראה הורדוס שהדבר מצא־חן בעיני מנהיגי היהודים, אסר את פטרוס באמצע חג הפסח. ");
INSERT INTO heblb_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","הורדוס התכוון להעמיד את פטרוס למשפט פומבי בתום החג, ועל כן השליך אותו בינתיים לכלא והפקיד עליו שישה־עשר שומרים. ");
INSERT INTO heblb_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","אולם הקהילה התפללה בעד פטרוס ללא הרף בעת מעצרו. ");
INSERT INTO heblb_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","בלילה שקדם למשפט הפומבי ישן פטרוס בין שני חיילים, כבול בשרשרת כפולה, והשומרים שמרו בזהירות על פתח הכלא. ");
INSERT INTO heblb_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","לפתע זרח אור בתוך התא, ומלאך ה׳ עמד לצידו של פטרוס. המלאך נגע בירכו של פטרוס והעירו משנתו. ”קום, מהר!“ קרא המלאך. באותו רגע נפלו השרשרות מעל־ידיו. ");
INSERT INTO heblb_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","”התלבש ונעל את נעליך“, הוסיף המלאך, ופטרוס עשה. ”עכשיו לבש את מעילך ובוא אחרי!“ פקד. ");
INSERT INTO heblb_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","פטרוס יצא מהתא בעקבות המלאך, אולם כל הזמן חשב שזהו רק חלום או חזיון; הוא לא יכול היה להאמין שכל זה קורה לו במציאות! ");
INSERT INTO heblb_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","הם חלפו על פני גוש התאים הראשון והשני, והגיעו אל שער הברזל הפונה לרחוב. השער נפתח לפניהם מעצמו, והם עברו דרכו. הם המשיכו ללכת עוד מרחק קצר, ולפתע נעלם המלאך. ");
INSERT INTO heblb_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","פטרוס הבין לבסוף את המתרחש. ”אין זה חלום!“ אמר לעצמו. ”אלוהים באמת שלח את מלאכו להציל אותי מיד הורדוס וממזימותיהם של היהודים!“ ");
INSERT INTO heblb_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","לאחר שעיכל את הדבר במוחו הלך אל ביתה של מרים, אמו של יוחנן מרקוס. שם התאספו מאמינים רבים לתפילה. ");
INSERT INTO heblb_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","פטרוס דפק על דלת הבית, ונערה בשם רודה ניגשה לראות מי זה. ");
INSERT INTO heblb_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","כשהכירה את קולו של פטרוס היא שמחה כל־כך, עד ששכחה לפתוח את הדלת. היא מיהרה להיכנס אל הבית וסיפרה לכולם שפטרוס עומד בחוץ. ");
INSERT INTO heblb_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","האחים לא האמינו לה. ”יצאת מדעתך!“ קראו. אולם מאחר שרודה עמדה על שלה, חשבו: ”אולי זהו המלאך של פטרוס. הם ודאי הרגו אותו.“ ");
INSERT INTO heblb_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","בינתיים המשיך פטרוס לדפוק על הדלת, וכשיצאו לבסוף האחים לפתוח את השער, הם הופתעו מאוד! ");
INSERT INTO heblb_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","פטרוס אמר להם לשתוק, וסיפר להם כיצד חילץ אותו האדון מבית־הכלא. ”ספרו זאת ליעקב ולאחים“, ביקש מהם, והלך לו למקום בטוח יותר. ");
INSERT INTO heblb_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","עם אור הבוקר שררה מבוכה גדולה בכלא: מה קרה לפטרוס? ");
INSERT INTO heblb_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","הורדוס שלח את אנשיו לחפש את פטרוס, אך הם לא מצאו אותו. משום כך ציווה הורדוס לאסור את שישה־עשר השומרים, להעמידם לדין ולהוציאם להורג. לאחר מכן עזב את העיר ועבר לגור בקיסריה. ");
INSERT INTO heblb_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","בהיותו בקיסריה הגיעה משלחת מהערים צור וצידון כדי לראותו. הורדוס לא היה ביחסים טובים עם תושבי הערים האלה, אולם חברי המשלחת התיידדו עם בלסטוס המזכיר של המחוז וביקשו שלום, כי מבחינה כלכלית הייתה ארצם תלויה במסחר עם ארצו של הורדוס. ");
INSERT INTO heblb_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","נקבע להם ראיון עם הורדוס, וביום המיועד הוא לבש את בגדי מלכותו, ישב על כסא מפואר ונאם לפניהם. ");
INSERT INTO heblb_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","בתום הנאום הריע לו הקהל בתשואות רמות וצעק: ”זהו קולו של אל, ולא של בן־תמותה!“ ");
INSERT INTO heblb_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","באותו רגע הכה מלאך ה׳ את הורדוס במחלה קשה; גופו נמלא תולעים שכרסמו אותו, וכעבור זמן קצר מת, משום שקיבל את סגידת האנשים במקום שיחלוק את הכבוד לאלוהים. ");
INSERT INTO heblb_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","בשורת הישועה של אלוהים התפשטה במהירות, ומאמינים רבים נוספו לקהילה. ");
INSERT INTO heblb_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","לאחר שסיימו בר־נבא ושאול את שליחותם בירושלים, לקחו איתם את יוחנן מרקוס ושבו לאנטיוכיה. ");
INSERT INTO heblb_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","אלה האנשים שנמנו עם המורים והנביאים בקהילת אנטיוכיה: בר־נבא, שמעון (המכונה ”כושי“), לוקיוס (מקוריניה), מנחם (אחיו החורג של הורדוס) ושאול (פולוס). ");
INSERT INTO heblb_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","יום אחד בשעה שהתפללו לאלוהים וצמו, אמר להם רוח הקודש: ”הקדישו לי את בר־נבא ואת שאול לביצוע משימה מיוחדת!“ ");
INSERT INTO heblb_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","הם הוסיפו להתפלל ולצום, ולאחר מכן סמכו את ידיהם על ראשיהם של שאול ובר־נבא, ברכו אותם ושלחו אותם לדרכם. ");
INSERT INTO heblb_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","בהדרכת רוח הקודש ירדו השניים לסלוקיא, ומשם הפליגו לקפריסין. ");
INSERT INTO heblb_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","הם עגנו בעיר סלמיס, ובישרו את דבר אלוהים בבתי־הכנסת (יוחנן מרקוס היה העוזר שלהם). ");
INSERT INTO heblb_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","לאחר מכן המשיכו לבשר בכל רחבי האי, עד שהגיעו לעיר פפוס. בעיר זאת פגשו יהודי אחד, בר־ישוע שמו, שהיה נביא שקר ועסק בכישוף. ");
INSERT INTO heblb_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","בר־ישוע היה ידיד למושל המקומי, סרגיוס פולוס. המושל, שהיה אדם נבון מאוד, הזמין את בר־נבא ופולוס לבקר אותו, משום שרצה לשמוע מפיהם את דבר האלוהים. ");
INSERT INTO heblb_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","אולם המכשף הזה, שנקרא ”אלימס“, לא רצה שהמושל יגיע לאמונה, ולכן התערב בשיחה ודרש מהמושל לא לשים לב לדבריהם של שאול ובר־נבא. ");
INSERT INTO heblb_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","אך שאול (הנקרא גם ”פולוס“), אשר היה מלא ברוח הקודש, הביט בנביא השקר וקרא: ");
INSERT INTO heblb_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","”בן בלייעל שכמוך! אתה מלא מרמה ופשע, ואויב מושבע של כל דבר טוב! האם לעולם לא תפסיק לסלף את דרכי האלוהים הישרים? ");
INSERT INTO heblb_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","עתה שים לב כיצד יעניש אותך אלוהים: תוכה בעיוורון זמני, ולא תראה את אור השמש.“ באותו רגע כיסה ערפל את עיניו, והוא החל לגשש סביבו ולחפש מישהו שיוביל אותו בידו. ");
INSERT INTO heblb_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","כשראה המושל את הנעשה, האמין באדון והשתומם על הכוח העצום של בשורת האלוהים. ");
INSERT INTO heblb_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","פולוס ומלוויו עזבו את פפוס, והפליגו בספינה לעיר פרגי שבמדינת פמפוליה. יוחנן מרקוס עזב אותם שם וחזר לירושלים, ");
INSERT INTO heblb_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","ואילו פולוס ובר־נבא המשיכו לאנטיוכיה אשר בפיסידיה. בשבת הלכו השניים לבית־הכנסת וישבו בין המתפללים. ");
INSERT INTO heblb_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","לאחר קריאת פרשת השבוע מן התורה, וההפטרה מהנביאים, שלחו אליהם ראשי בית־הכנסת הודעה: ”אחים, אם יש לכם דבר עידוד והדרכה בשבילנו, אתם מוזמנים לדבר!“ ");
INSERT INTO heblb_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","פולוס קם על רגליו, סימן לקהל שהוא עומד לדבר, ואמר: ”אנשי ישראל, וכל הבוטחים בה׳ והמכבדים אותו, הרשו לי לפתוח בסקירה היסטורית קצרה. ");
INSERT INTO heblb_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","אלוהי העם הזה – אלוהי ישראל – בחר באבותינו וברך אותם מאוד בתקופת שהותם במצרים. ביד חזקה ובזרוע נטויה הוא הוציא אותם מעבדות לחירות, ");
INSERT INTO heblb_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","וטיפל בהם במשך ארבעים שנות נדודיהם במדבר. ");
INSERT INTO heblb_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","לאחר שהשמיד שבעה עמים בארץ כנען, הוא נתן לעם ישראל את הארץ לנחלה. כל זה ארך כ־450 שנה. ");
INSERT INTO heblb_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","”לאחר מכן מינה עליהם אלוהים שופטים עד ימיו של שמואל הנביא. ");
INSERT INTO heblb_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","”בימיו של שמואל ביקש העם מלך, וה׳ נתן לו את שאול בן־קיש משבט בנימין, שמלך ארבעים שנה. ");
INSERT INTO heblb_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","אולם ה׳ הוריד אותו מכסא מלכותו, והמליך תחתיו את דוד המלך, זה שה׳ אמר עליו: ’דוד בן־ישי הוא איש כלבבי, והוא יעשה את רצוני‘. ");
INSERT INTO heblb_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","ומזרעו של דוד הקים ה׳ לישראל את המושיע המובטח, את ישוע המשיח! ");
INSERT INTO heblb_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","”עוד לפני בואו של ישוע קרא יוחנן לעם ישראל לשוב מחטאיו, לפנות אל ה׳ ולהיטבל במים. ");
INSERT INTO heblb_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","כשסיים יוחנן את תפקידו, שאל את העם: ’האם אתם חושבים שאני המשיח? לא, אינני המשיח! אבל הוא עומד לבוא, ואיני ראוי אף להתיר את שרוכי נעליו!‘ ");
INSERT INTO heblb_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","”אחי בני אברהם, ואחי הגויים היראים את האלוהים: ישועה זאת נועדה לכולנו! ");
INSERT INTO heblb_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","תושבי ירושלים ומנהיגיהם לא הכירו את המשיח, ולא הבינו את דברי הנביאים אשר נקראו מדי שבת בבית־הכנסת. אף־על־פי־כן, כשהרגו אותו הם קיימו למעשה את דברי הנביאים. ");
INSERT INTO heblb_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","למרות שלא הייתה להם כל סיבה מוצדקת להוציא את ישוע להורג, דרשו מפילטוס לצלוב אותו. ");
INSERT INTO heblb_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","לאחר שקיימו את כל הנבואות הקשורות במותו, בלי שידעו זאת, הורידו אותו מעל הצלב וקברוהו. ");
INSERT INTO heblb_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","”אולם אלוהים הקים את ישוע מן המתים, ");
INSERT INTO heblb_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","ובימים שלאחר מכן הוא נראה פעמים רבות לעיני האנשים שליוו אותו מן הגליל לירושלים. מאז ועד היום לא פסקו האנשים האלה להעיד על כך בפומבי. ");
INSERT INTO heblb_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","”בר־נבא ואני מבשרים לכם עתה את הבשורה הטובה הזאת: את אשר הבטיח אלוהים לאבותינו, ");
INSERT INTO heblb_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","הוא הגשים לנו, צאציהם, על ידי תקומת ישוע. לכך מתכוון המזמור השני בתהלים: ’בני אתה, אני היום ילדתיך‘. ");
INSERT INTO heblb_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","”אלוהים הבטיח להחזירו לחיים, כדי שלא ימות עוד לעולם. אלוהים ייתן לכם את הבטחותיו הנפלאים לדוד כמו שכתוב בישעיה. ");
INSERT INTO heblb_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","במזמור טז כתוב: ’לא תיתן חסידך לראות שחת‘. ");
INSERT INTO heblb_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","פסוק זה אינו מתייחס לדוד, שהרי לאחר שדוד שרת את בני דורו לפי רצון ה׳, הוא מת, נקבר וגופו נרקב. ");
INSERT INTO heblb_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","פסוק זה מתייחס למישהו אחר – למישהו שאלוהים החזירו לחיים ושגופו כלל לא ניזוק מריקבון המוות. ");
INSERT INTO heblb_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","”אחים, הקשיבו! באמצעות ישוע זה אתם יכולים לקבל סליחת חטאים. ");
INSERT INTO heblb_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","כל מי שמאמין ובוטח בו משתחרר מכל אשמה, ואלוהים מצדיק אותו. התורה מעולם לא יכלה לשחרר אתכם מחטא ולהצדיקכם בעיני אלוהים. ");
INSERT INTO heblb_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","היזהרו! אל תתנו לדברי הנביאים להתגשם בכם: ");
INSERT INTO heblb_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","’ראו בוגדים והביטו, והתמהו תמהו, כי פֹעַל פֹּעֵל בימיכם, לא תאמינו כי יסופר‘. ”כלומר, ראו והתפלאו, אתם הבזים לאמת! כי אלוהים עומד לעשות משהו בימיכם, אשר לא תאמינו בו כשיספרו לכם על כך.“ ");
INSERT INTO heblb_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","כשיצאו פולוס ובר־נבא מבית־הכנסת, הזמינו אותם האנשים לשוב ולדבר אליהם בשבת הבאה. ");
INSERT INTO heblb_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","בתום האסיפה בבית־הכנסת הלכו אחרי פולוס ובר־נבא הרבה יהודים וגויים יראי אלוהים. השניים שוחחו איתם ועודדו אותם לבטוח בחסדו של אלוהים. ");
INSERT INTO heblb_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","בשבת שלאחר מכן התקהלה כמעט כל העיר בבית־הכנסת, כדי לשמוע את דבר ה׳ מפי פולוס ובר־נבא. ");
INSERT INTO heblb_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","אולם כשראו מנהיגי היהודים את ההמון, נמלאו קנאה והכחישו את דבריו של פולוס בקללות ובגידופים. ");
INSERT INTO heblb_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","אך פולוס ובר־נבא דיברו באומץ והצהירו: ”הרגשנו שמחובתנו לבשר את דבר ה׳ קודם כל לכם – היהודים, אולם מכיוון שדחיתם אותו והוכחתם שאינכם ראויים לחיי נצח, נציע אותו לגויים! ");
INSERT INTO heblb_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","כי כך ציווה עלינו אלוהים: ’ונתתיך לאור גוים, להיות ישועתי עד קצה הארץ‘. “ ");
INSERT INTO heblb_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","הגויים שמחו מאוד לשמוע את בשורת ה׳ מפי פולוס, וכל מי שנבחר לחיי נצח האמין. ");
INSERT INTO heblb_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","וכך התפשט דבר ה׳ בכל הארץ. ");
INSERT INTO heblb_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","אולם מנהיגי היהודים קוממו את הנשים המכובדות ואצילות נגד פולוס ובר־נבא. הם עוררו את ההמון לרדוף את פולוס ובר־נבא ולגרשם מן העיר. ");
INSERT INTO heblb_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","השניים ניערו את אבק העיר מעל רגליהם והלכו לעיר איקניון, ");
INSERT INTO heblb_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","ותלמידיהם באנטיוכיה נמלאו שמחה ורוח הקודש. ");
INSERT INTO heblb_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","גם באיקניון הלכו פולוס ובר־נבא לבית־הכנסת. הם הטיפו את דבר ה׳ בעוצמה כה רבה, עד שיהודים וגויים רבים האמינו באדון. ");
INSERT INTO heblb_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","אולם היהודים שדחו את בשורת אלוהים הסעירו את רגשות הגויים, ועוררו בלבם אי־אמון בפולוס ובר־נבא. ");
INSERT INTO heblb_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","למרות זאת נשארו שם השניים זמן רב למדי, כשהם מבשרים את דבר ה׳ באומץ, ואלוהים אישר שאכן הם שליחיו על־ידי הניסים והנפלאות שחולל באמצעותם. ");
INSERT INTO heblb_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","תושבי העיר היו חלוקים בדעותיהם: חלקם תמכו במנהיגים היהודים, וחלקם – בפולוס ובר־נבא. ");
INSERT INTO heblb_vpl VALUES ("AC14_5‏","074_14_5‏","ACT","14","5‏","6","כאשר נודע לשני השליחים שהגויים, היהודים ומנהיגיהם תכננו להתנכל להם ולרגום אותם באבנים, מיהרו להימלט על נפשם. הם הגיעו לערי חבל לוקוניה: לוסטרה, דרבי וסביבותיהן, ");
INSERT INTO heblb_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","וגם שם בישרו את הבשורה. ");
INSERT INTO heblb_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","בלוסטרה הם ראו אדם שלא התהלך מעולם; רגליו היו משותקות מלידה. ");
INSERT INTO heblb_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","פולוס שם לב לכך שהנכה מקשיב לדבריו בדריכות ובעניין רב, וכאשר גילה שיש בו אמונה להירפא, ");
INSERT INTO heblb_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","קרא אליו: ”קום על רגליך!“ כהרף־עין קפץ האיש על רגליו והחל ללכת. ");
INSERT INTO heblb_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","כשראה קהל הנוכחים את הנס שפולוס חולל, החלו כולם לקרוא בלשון הליקאונית: ”אנשים אלה הם אלים בדמות בני־אדם!“ ");
INSERT INTO heblb_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","הם החליטו שבר־נבא הוא האל זאוס, ואילו פולוס, שהיה הדובר העיקרי – האל הרמס. ");
INSERT INTO heblb_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","הכהן של זאוס, שמקדשו היה בפרבר העיר, הביא זרי פרחים ושוורים, כדי להקריבם בשער העיר לעיני ההמונים. ");
INSERT INTO heblb_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","אולם כאשר הבינו פולוס ובר־נבא את מה שעומד להתרחש, קרעו את בגדיהם ורצו בתוך הקהל בצעקות: ");
INSERT INTO heblb_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","”אנשים, מה אתם עושים? אנחנו בני־אדם בדיוק כמוכם! באנו לבשר לכם את הבשורה, כדי שאתם תפסיקו לסגוד לאלילים, ובמקום זאת להשתחוות לאלוהים האחד האמיתי, אשר ברא את השמים, את הארץ, את הים ואת כל אשר בם. ");
INSERT INTO heblb_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","אמנם בימי קדם הרשה ה׳ לגויים לחיות כרצונם, ");
INSERT INTO heblb_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","אולם הוא תמיד העיד על עצמו במעשיו הטובים ובאהבתו אלינו: הוא שולח לנו, למשל, גשם ותבואות מבורכות; הוא מספק לנו אוכל וממלא את לבנו שמחה.“ ");
INSERT INTO heblb_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","על אף דבריהם אלה הצליחו השניים רק בקושי רב לשכנע את הקהל שלא להקריב להם קורבנות. ");
INSERT INTO heblb_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","ימים ספורים לאחר מכן הגיעו ללוסטרה יהודים אחדים מאנטיוכיה ומאיקניון, והפכו את קהל המעריצים להמון פרוע וצמא־דם, אשר רגם את פולוס באבנים. ההמונים חשבו שפולוס מת, ולכן גררו אותו אל מחוץ לעיר. ");
INSERT INTO heblb_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","אולם לאחר שהתקבצו המאמינים סביבו הוא התאושש, קם על רגליו וחזר העירה. למחרת יצאו פולוס ובר־נבא לדרבי. ");
INSERT INTO heblb_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","לאחר שבישרו שם את דבר ה׳ ועשו תלמידים רבים, חזרו השניים ללוסטרה, לאיקניון ולאנטיוכיה. ");
INSERT INTO heblb_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","בערים אלה הם חיזקו את המאמינים, ועודדו אותם לדבוק באמונתם למרות הצרות והרדיפות. ”רק דרך צרות רבות נוכל להיכנס למלכות האלוהים“, הזכירו להם. ");
INSERT INTO heblb_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","כמו כן מינו פולוס ובר־נבא זקני־קהילה בכל קהילה, ובצום ותפילה הפקידו אותם בידי האלוהים שבו בטחו. ");
INSERT INTO heblb_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","לאחר מכן המשיכו השניים במסעם חזרה, ועברו דרך פיסידיה ופמפוליה. ");
INSERT INTO heblb_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","הם הטיפו שוב בפרגי, והמשיכו לאטליה. ");
INSERT INTO heblb_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","לבסוף הפליגו בספינה לאנטיוכיה – העיר שממנה יצאו למסע, ואשר בה הופקדו בידי אלוהים לבצע את המלאכה שזה עתה סיימו. ");
INSERT INTO heblb_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","בהגיעם לאנטיוכיה כינסו את כל המאמינים, ומסרו להם דיווח מפורט על מסעם: כיצד ה׳ פעל באמצעותם, וכיצד פתח את שער האמונה גם לגויים. ");
INSERT INTO heblb_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","פולוס ובר־נבא נשארו עם המאמינים באנטיוכיה זמן ממושך. ");
INSERT INTO heblb_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","בזמן שבר־נבא ופולוס היו באנטיוכיה, הגיעו לשם מספר אנשים מיהודה, והחלו ללמד את המאמינים שאם לא יקפידו לקיים את ברית המילה כדת משה וישראל, לא יוכלו להיוושע. ");
INSERT INTO heblb_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","פולוס ובר־נבא התווכחו איתם על כך בלהט רב, ולכן החליטה הקהילה המקומית לשלוח אותם לירושלים, יחד עם אחדים מחברי הקהילה, כדי לדון בשאלה זאת עם השליחים והזקנים שם. ");
INSERT INTO heblb_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","הקהילה כולה ליוותה אותם אל מחוץ לעיר, והנציגים יצאו בדרכם לירושלים. הם התעכבו בדרך בערי החוף של לבנון ובשומרון, כדי לבקר את המאמינים, ולשמחת כולם סיפרו להם שגם הגויים חוזרים בתשובה. ");
INSERT INTO heblb_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","בהגיעם לירושלים קיבלו את פניהם חברי הקהילה, השליחים והזקנים, ופולוס ובר־נבא דיווחו להם כיצד ה׳ פעל באמצעותם. ");
INSERT INTO heblb_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","אולם מאמינים אחדים, שהשתייכו בעבר לכת הפרושים, קמו על רגליהם וטענו שכל המאמינים מבין הגויים חייבים לשמור את התורה ולקיים ברית מילה. ");
INSERT INTO heblb_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","לכן כינסו השליחים והזקנים אסיפה מיוחדת כדי לדון בבעיה זאת. ");
INSERT INTO heblb_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","לאחר דיון ארוך ומייגע קם שמעון על רגליו ופנה אל המאמינים: ”אחים, כולכם יודעים שעוד לפני זמן רב בחר בי אלוהים לבשר לגויים את הבשורה, כדי שגם הם יאמינו בו. ");
INSERT INTO heblb_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","אלוהים, המכיר והיודע את לב האדם, אישר שהוא מקבל גם את הגויים. כיצד הוא אישר זאת? בכך שנתן להם את רוח הקודש בדיוק כשם שנתן אותו לנו. ");
INSERT INTO heblb_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","אלוהים לא הבדיל בינינו לביניהם, משום שהוא טיהר את לבם, על־ידי האמונה, בדיוק כפי שטיהר את לבנו. ");
INSERT INTO heblb_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","האם אתם רוצים עתה לתקן את מעשיו של אלוהים? מדוע אתם מעמיסים על הגויים עול שאנחנו ואבותינו לא יכולנו לשאת? ");
INSERT INTO heblb_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","האם אינכם מאמינים שכולנו נושענו באותה הדרך – כלומר בחסדו של האדון ישוע?“ ");
INSERT INTO heblb_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","הויכוח פסק, וכל האחים הקשיבו בדומיה לדיווח של פולוס ובר־נבא על הנסים והנפלאות שחולל אלוהים באמצעותם בין הגויים. ");
INSERT INTO heblb_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","כשסיימו השניים את דיווחם נטל יעקב את רשות הדיבור. ”אחים,“ אמר, ”הקשיבו לדברי! ");
INSERT INTO heblb_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","שמעון פטרוס הסביר לכם זה עתה כיצד אלוהים גילה תחילה את דאגתו לגויים, וכיצד בחר מקרבם אנשים שיאמינו בו ושיפארו את שמו. ");
INSERT INTO heblb_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","עובדה זאת של ישועת הגויים עולה למעשה בקנה אחד עם דברי הנביאים. קחו למשל את נבואתו של עמוס: ");
INSERT INTO heblb_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","’ביום ההוא אקים את סכת דויד הנפלת, וגדרתי את פרציהן והריסותיו אקים, ובניתיה כימי עולם, ");
INSERT INTO heblb_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","למען ידרשו את־ה׳ שארית אדם וכל הגויים אשר נקרא שמי עליהם, נאום ה׳ עושה כל־אלה‘. ”כלומר, אלוהים הבטיח לחדש את ברית דוד המופרת, כדי שגם הגויים – אלה שבחר בהם – יוושעו! ");
INSERT INTO heblb_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","אלה דברי אלוהים אשר גילה אותם עוד לפני זמן רב. ");
INSERT INTO heblb_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","”על כן אני פוסק שאל לנו לדרוש מהגויים השבים אל ה׳ לקיים את חוקי התורה. ");
INSERT INTO heblb_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","הבה נסתפק בכך שנכתוב להם לא לאכול בשר שהוקרב לאלילים ולא בשר טרף של בעל חיים שנחנק, לא לאכול בשר עם דם, ולהתרחק מהזנות על כל צורותיה. ");
INSERT INTO heblb_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","כי עוד מימי קדם נקראה תורת משה מדי שבת בבתי־כנסת בכל עיר ועיר.“ ");
INSERT INTO heblb_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","השליחים, הזקנים וכל חברי הקהילה החליטו לשלוח משלחת לאנטיוכיה יחד עם פולוס ובר־נבא, כדי לדווח על החלטתם. הם בחרו בשניים ממנהיגי הקהילה, ביהודה (המכונה ”בר־שבא“) ובסילא, ");
INSERT INTO heblb_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","ושלחו בידם את המכתב הבא: ”מאת: השליחים, זקני הקהילה והאחים בירושלים. ”אל: אחינו המאמינים מן הגויים באנטיוכיה, בסוריה ובקיליקיה, שלום לכם! ");
INSERT INTO heblb_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","נודע לנו שמספר אנשים מקהילתנו בלבלו אתכם והטילו ספק בכם, אולם דעו לכם שלא אנחנו שלחנו אותם – הם באו אליכם על דעת עצמם. ");
INSERT INTO heblb_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","משום כך החלטנו פה־אחד לשלוח אליכם שני נציגים רשמיים שלנו, יחד עם אחינו האהובים פולוס ובר־נבא. ");
INSERT INTO heblb_vpl VALUES ("AC15_26‏","074_15_26‏","ACT","15","26‏","27","נציגים אלה, יהודה וסילא, אשר סיכנו את חייהם למען שם אדוננו ישוע המשיח, יאשרו לפניכם בעל־פה את החלטתנו. ");
INSERT INTO heblb_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","”רוח הקודש ואנחנו מצאנו לנכון שלא להכביד עליכם בחובות מיותרים של שמירת מצוות התורה, אלא רק לדרוש מכם ");
INSERT INTO heblb_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","שתימנעו מאכילת מזון שהוקרב לאלילים, מאכילת בשר של בעל־חיים שנחנק, מאכילת בשר עם דם, ושתתרחקו מן הזנות. טוב תעשו אם תשמרו דברים אלה. – שלום לכם.“ ");
INSERT INTO heblb_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","ארבעת הנציגים יצאו מיד לאנטיוכיה, כינסו שם אסיפה כללית של כל המשיחיים ונתנו להם את המכתב. ");
INSERT INTO heblb_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","דברי המכתב שמחו מאוד את כל הקהילה באנטיוכיה. ");
INSERT INTO heblb_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","יהודה וסילא, שהיו נביאים, דרשו באוזני הקהל דרשה ארוכה וחיזקו את אמונת האחים. ");
INSERT INTO heblb_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","הם נשארו שם ימים אחדים, ולאחר מכן חזרו לירושלים עם דרישות שלום אל האחים אשר שלחו אותם. ");
INSERT INTO heblb_vpl VALUES ("AC15_34‏","074_15_34‏","ACT","15","34‏","35","פולוס ובר־נבא נשארו באנטיוכיה, ועזרו למטיפים ולמורים המקומיים ללמד את דבר ה׳. ");
INSERT INTO heblb_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","כעבור ימים אחדים הציע פולוס לבר־נבא: ”הבה נשוב ונבקר את אחינו בכל הערים שבהן בישרנו את דבר ה׳, כדי שנראה כיצד מתקדמים המאמינים החדשים.“ ");
INSERT INTO heblb_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","בר־נבא הסכים, וביקש לצרף אליהם את יוחנן מרקוס. ");
INSERT INTO heblb_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","אך רעיון זה לא מצא־חן בעיני פולוס, כי יוחנן מרקוס זנח אותם לנפשם בעיר פמפוליה, ולא עזר להם לסיים את שליחותם. ");
INSERT INTO heblb_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","לאחר ויכוח חריף בנושא זה החליטו השניים להיפרד. בר־נבא לקח את מרקוס והפליג איתו לקפריסין, ");
INSERT INTO heblb_vpl VALUES ("AC15_40‏","074_15_40‏","ACT","15","40‏","41","ואילו פולוס בחר לקחת איתו את סילא. לאחר שקיבלו את ברכת האחים יצאו השניים בדרכם לסוריה וקילקיה, כדי לעודד את המאמינים שם. ");
INSERT INTO heblb_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","פולוס וסילא הלכו תחילה לדרבי ומשם ללוסטרה. בלוסטרה הם פגשו מאמין צעיר בשם טימותיוס. אמו הייתה יהודיה מאמינה, ואביו – יווני. ");
INSERT INTO heblb_vpl VALUES ("AC16_2‏","074_16_2‏","ACT","16","2‏","3","מאחר שלטימותיוס היה שם טוב בין האחים בלוסטרה ובאיקניון, ביקש ממנו פולוס להילוות אליהם במסעם. מתוך התחשבות ברגשות יהודי הסביבה החליט פולוס למול את טימותיוס לפני צאתם לדרך, כי כולם ידעו שאביו יווני. ");
INSERT INTO heblb_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","השלושה עברו מעיר לעיר ופרסמו את החלטת השליחים והזקנים בירושלים בנוגע למאמינים הגויים. ");
INSERT INTO heblb_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","והקהילה המשיחית גדלה והתפתחה מיום ליום באמונה ובמספר. ");
INSERT INTO heblb_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","לאחר מכן עברו פולוס ומלוויו דרך פריגיה וגלטיה, כי רוח הקודש אמר להם שלא להיכנס לאסיה הקטנה באותו מסע. ");
INSERT INTO heblb_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","הם עברו לאורך גבולות מיסיה, והתכוננו ללכת צפונה – לביתיניה, אך רוח ישוע אמר להם שלא. ");
INSERT INTO heblb_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","לכן במקום ללכת לביתיניה הם עברו דרך מיסיה, והלכו לעיר טרואס. ");
INSERT INTO heblb_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","באותו לילה נראה לפולוס חזיון: הוא ראה בחלומו איש ממקדוניה (שביוון) מתחנן לפניו: ”אנא, בוא אלינו למקדוניה ועזור לנו!“ ");
INSERT INTO heblb_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","מיד לאחר חלומו של פולוס עמדנו לצאת למקדוניה, כי הגענו למסקנה שה׳ שולח אותנו לשם כדי לבשר את הבשורה. ");
INSERT INTO heblb_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","עלינו על ספינה בטרואס והפלגנו לסמותרקיה, ולמחרת נסענו לנפוליס. ");
INSERT INTO heblb_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","משם הגענו לפיליפי, שהייתה המושבה הרומאית הקרובה ביותר לגבול המקדוני, ונשארנו שם ימים אחדים. ");
INSERT INTO heblb_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","בשבת יצאנו מחוץ לעיר והלכנו אל שפת הנהר, שם נהגה קבוצה אחת להתאסף לתפילה. התיישבנו שם ולימדנו את הנשים שנכחו במקום. ");
INSERT INTO heblb_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","אחת מהן הייתה לידיה מהעיר תיאטירה, שהייתה סוחרת בבדי ארגמן. לידיה הייתה אישה יראת אלוהים, ועתה, כשהקשיבה לדבריו של פולוס, פתח אלוהים את לבה והיא האמינה לכל מה שאמר. ");
INSERT INTO heblb_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","היא נטבלה יחד עם כל בני־ביתה, וביקשה מאיתנו להתארח אצלה. ”אם אתם חושבים שאני באמת מאמינה באדון,“ אמרה, ”בואו והתארחו בביתי.“ היא הפצירה בנו עד שהסכמנו. ");
INSERT INTO heblb_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","יום אחד, כשבאנו למקום התפילה שעל שפת הנהר, פגשנו שפחה צעירה אחוזת־רוח ניחוש, שניבאה עתידות והרוויחה הרבה כסף לאדוניה. ");
INSERT INTO heblb_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","היא רדפה אחרינו וצרחה: ”אנשים אלה הם עבדי ה׳; הם באו לספר לכם דרך ישועה!“ ");
INSERT INTO heblb_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","למורת רוחו של פולוס נמשך הדבר יום אחר יום, עד שלבסוף פנה אל השד שבתוכה וקרא: ”בשם ישוע המשיח אני מצווה עליך לצאת ממנה!“ והשד יצא מתוכה באותו רגע. ");
INSERT INTO heblb_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","כשראו בעליה שאבדה תקוותם להרוויח כסף קל ומהיר, תפסו את פולוס וסילא וגררו אותם אל השופטים אשר בכיכר השוק. ");
INSERT INTO heblb_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","”היהודים האלה משחיתים את העיר שלנו!“ צרחו. ");
INSERT INTO heblb_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","”הם מלמדים את האזרחים לעשות דברים המנוגדים לחוק הרומאי!“ ");
INSERT INTO heblb_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","לשמע דברים אלה התנפל ההמון על פולוס וסילא, והשופטים ציוו להפשיטם ולהלקותם בשוטים. ");
INSERT INTO heblb_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","לאחר שהצליפו על גבם ללא רחמים, השליכו את השניים לכלא, והסוהר נצטווה לשמור עליהם כעל בבת־עינו (שאם לא כן יומת). ");
INSERT INTO heblb_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","מאחר שהסוהר קיבל את הפקודה, השליך את השניים לצינוק ושם את רגליהם בסד. ");
INSERT INTO heblb_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","בחצות הלילה התפללו פולוס וסילא ושרו לכבוד ה׳, וכל האסירים הקשיבו להם. ");
INSERT INTO heblb_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","לפתע התחוללה רעידת אדמה חזקה שזעזעה את יסודות בית־הכלא. כל הדלתות נפתחו לרווחה, ואזיקיהם של כל האסירים ניתקו! ");
INSERT INTO heblb_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","כשהתעורר הסוהר משנתו ומצא את כל דלתות הכלא פתוחות, היה בטוח שכל האסירים נמלטו, ולכן שלף מהר את חרבו כדי להתאבד. ");
INSERT INTO heblb_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","אך פולוס צעק לעברו: ”אל תהרוג את עצמך! כולנו כאן!“ ");
INSERT INTO heblb_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","בפחד וברעדה חיפש הסוהר נרות, רץ אל הצינוק ונפל לפני פולוס וסילא. ");
INSERT INTO heblb_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","הוא הוציא אותם החוצה ושאל בתחינה: ”רבותי, מה עלי לעשות כדי להיוושע?“ ");
INSERT INTO heblb_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","”עליך להאמין באדון ישוע,“ השיבו השניים, ”ואז תיוושע – אתה וכל בני־ביתך בזכות האמונה!“ ");
INSERT INTO heblb_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","והם סיפרו לסוהר ולכל בני־ביתו את בשורת אלוהים. ");
INSERT INTO heblb_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","באותה הזדמנות רחץ הסוהר את פצעיהם, ואחר כך נטבל עם כל בני ביתו. ");
INSERT INTO heblb_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","לאחר מכן העלה אותם האיש לביתו וערך לפניהם סעודה גדולה. מה רבה הייתה שמחתו ושמחת כל בני־ביתו על שכולם האמינו עתה בה׳. ");
INSERT INTO heblb_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","למחרת בבוקר שלחו השופטים שוטרים אל הסוהר, ובפיהם הפקודה: ”שחרר את שני האסירים ותן להם ללכת!“ ");
INSERT INTO heblb_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","הסוהר מיהר אל פולוס ואמר: ”השופטים ציוו עלי לשחרר אתכם; אתם חופשיים ללכת לדרככם!“ ");
INSERT INTO heblb_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","”בשום פנים ואופן לא!“ השיב פולוס בהחלטיות. ”למרות שאנחנו אזרחים רומאים ולא היינו אשמים בכל פשע, הכו אותנו בשוטים לעיני כל העם! לא די בכך שהכו אותנו בשוטים והשליכו אותנו לכלא ללא משפט, הם רוצים עתה לשלח אותנו מכאן בחשאי? שיבואו הנה בעצמם וישחררו אותנו!“ ");
INSERT INTO heblb_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","השוטרים מסרו לשופטים את דבריו של פולוס, וכשנודע להם שפולוס וסילא היו אזרחים רומאים, חששו לחייהם. ");
INSERT INTO heblb_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","משום כך הזדרזו השופטים ללכת בעצמם לבית־הכלא, והתחננו לפני השניים שיואילו בטובם לעזוב את העיר. ");
INSERT INTO heblb_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","פולוס וסילא יצאו מן הכלא וחזרו לביתה של לידיה. לאחר שעודדו את המאמינים שפגשו שם, הלכו השניים לדרכם. ");
INSERT INTO heblb_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","פולוס וסילא עברו במסעם דרך ערי אמפיפוליס ואפולוניה, והגיעו לתסלוניקי – עיר שהיה בה בית־כנסת יהודי. ");
INSERT INTO heblb_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","פולוס הלך כמנהגו לבית־הכנסת, ובמשך שלוש שבתות רצופות הסביר לנוכחים את הכתובים. ");
INSERT INTO heblb_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","הוא הסביר להם את הנבואות בדבר סבלו של המשיח ותקומתו לחיים, והוכיח להם שישוע הוא המשיח. ");
INSERT INTO heblb_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","חלק מהמאזינים שוכנעו והאמינו; ביניהם היו הרבה יוונים יראי־אלוהים והרבה נשים אצילות. ");
INSERT INTO heblb_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","אולם מנהיגי היהודים נמלאו קנאה, ולכן הסיתו פושעים ובטלנים מן השוק לעורר מהומה בעיר. הם פרצו לביתו של יסון, במטרה לתפוס את פולוס וסילא ולהביאם לפני מועצת העיר. ");
INSERT INTO heblb_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","מאחר שלא מצאו את השניים בתוך הבית, הם גררו החוצה את יסון ומאמינים אחרים והביאו אותם לפני המועצה. ”פולוס וסילא גורמים לצרות ובעיות בכל העולם, ועכשיו הם רוצים להפוך גם את עירנו!“ צרחו. ");
INSERT INTO heblb_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","”ויסון זה הכניס אותם אל ביתו. הם בוגדים! הם טוענים שיש להם מלך אחר, ישוע, במקום הקיסר!“ ");
INSERT INTO heblb_vpl VALUES ("AC17_8‏","074_17_8‏","ACT","17","8‏","9","האשמות אלה הסעירו את רוחם של אנשי־העיר ושל השופטים, ואלה שחררו אותם רק לאחר ששילמו דמי־ערבות. ");
INSERT INTO heblb_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","באותו לילה הבריחו המאמינים את פולוס וסילא לברואה, והשניים שוב הלכו לבית־הכנסת כדי להטיף. ");
INSERT INTO heblb_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","אנשי ברואה היו רחבי אופקים יותר מאנשי תסלוניקי והקשיבו לבשורה בשמחה. יום־יום הם למדו בעצמם את כתבי־הקודש, כדי לראות אם דבריהם של פולוס וסילא הם דברי אמת. ");
INSERT INTO heblb_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","כתוצאה מכך האמינו רבים מהם, ביניהם נשים רמות מעלה וגברים רבים. ");
INSERT INTO heblb_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","אולם כששמעו היהודים בתסלוניקי שפולוס מטיף את דבר ה׳ בברואה, מיהרו גם הם לשם כדי להסעיר את הרוחות. ");
INSERT INTO heblb_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","המאמינים פעלו ללא דיחוי ושלחו את פולוס לחוף הים, בעוד שסילא וטימותיוס נשארו בעיר. ");
INSERT INTO heblb_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","מלוויו של פולוס הלכו איתו עד אתונה, ומשם חזרו לברואה. לפני שנפרדו ממנו מלוויו ביקש מהם פולוס שיודיעו לסילא ולטימותיוס למהר לבוא אליו. ");
INSERT INTO heblb_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","בזמן שפולוס חיכה להם באתונה, הוא נמלא צער למראה האלילים הרבים שמילאו את העיר. ");
INSERT INTO heblb_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","הוא הלך לבית־הכנסת והתווכח על כך עם היהודים ועם הגויים שהתגיירו. הוא מצא לנכון להתווכח גם עם העוברים ושבים בכיכר השוק. ");
INSERT INTO heblb_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","בין האנשים הרבים שאיתם התווכח היו גם פילוסופים אפיקורסים וסטואיים. כששמעו את דבריו של פולוס על תקומתו של ישוע מן המתים, הגיבו: ”הוא סתם פטפטן!“ או, ”הוא עושה תעמולה לדת חדשה כלשהי!“ ");
INSERT INTO heblb_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","הם לקחו את פולוס לגבעת המשפט (שנקראה ביוונית ”אריופגוס“) ואמרו לו: ”ספר לנו עוד קצת על הדת החדשה הזאת. ");
INSERT INTO heblb_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","אתה מספר דברים מוזרים, והיינו רוצים לדעת מה פירושם.“ ");
INSERT INTO heblb_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","כאן עלי להסביר שאנשי אתונה, כולל הזרים שהיו שם, אהבו לבלות את זמנם בשיחה על רעיונות חדשים למיניהם. ");
INSERT INTO heblb_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","פולוס עמד לפניהם בגבעת המשפט ואמר: ”אנשי אתונה, אני רואה שאתם אנשים אדוקים מאוד! ");
INSERT INTO heblb_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","כשעברתי היום בחוצות עירכם ראיתי מזבחות רבים, ועל אחד מהם היה כתוב: ’לאל הבלתי־נודע‘. השתחוויתם לו בלי לדעת מי הוא, ועתה ברצוני לספר לכם עליו. ");
INSERT INTO heblb_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","”הוא האל אשר ברא את העולם ואת כל אשר בו, והיות שהוא אדון השמים והארץ, אין הוא שוכן במקדש מעשה ידי־אדם. ");
INSERT INTO heblb_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","כמו־כן אין ידי אדם יכולות לשרתו ולספק לו את צרכיו, משום שאין הוא זקוק לדבר! הוא עצמו נותן חיים ונשמה לכל דבר, וממלא כל מחסור שהוא. ");
INSERT INTO heblb_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","מאדם אחד הוא ברא את כל בני־האדם בעולם, ולאחר מכן פיזר את העמים על פני כדור הארץ. הוא החליט מראש מי מהם יקום, מי ייפול ומתי, ואף קבע להם את גבולותיהם. ");
INSERT INTO heblb_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","”בכל המעשים האלה הייתה לו מטרה אחת: שכל העמים יחפשו את אלוהים ויגששו אחריו עד שימצאו אותו – למרות שאין הוא רחוק מאף אחד מאיתנו! ");
INSERT INTO heblb_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","אחד המשוררים שלכם ביטא זאת בשירו: ’כי בו אנחנו חיים ונעים וקיימים. וגם אנחנו צאצאיו‘. ");
INSERT INTO heblb_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","”ואם נכון הדבר, אזי אסור לנו לחשוב על אלוהים כאילו הוא מן פסל או אליל עשוי זהב, כסף או אבן! ");
INSERT INTO heblb_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","אלוהים התעלם בעבר מבורותם של בני־האדם בנושא זה, אולם עתה הוא מצווה על כולם לחזור בתשובה ולעבוד אותו בלבד. ");
INSERT INTO heblb_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","כי אלוהים קבע יום מסוים שבו ישפוט בצדק את העולם כולו על־ידי האיש שבו בחר. אלוהים אישר את הדבר לעיני כולם כשהקים איש זה מן המתים.“ ");
INSERT INTO heblb_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","כאשר שמעו שפולוס מדבר על תחייתו של איש מת, החלו אחדים מהם לצחוק וללעוג, ואילו אחרים אמרו: ”אנחנו רוצים לשמוע עוד על כך!“ ");
INSERT INTO heblb_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","בכך נסתיימה שיחתו של פולוס איתם, ");
INSERT INTO heblb_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","אולם רק מעטים האמינו לדבריו והצטרפו אליו. ביניהם היו דיוניסיוס – חבר מועצת העיר, אישה אחת בשם דמריס ואחרים. ");
INSERT INTO heblb_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","לאחר מכן עזב פולוס את אתונה ובא לקורינתוס. ");
INSERT INTO heblb_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","שם הוא התוודע אל יהודי יליד פונטוס, בשם עקילס, אשר הגיע לא־מזמן מאיטליה יחד עם אשתו פריסקילה. עקילס ופריסקילה נמלטו למעשה מאיטליה, משום שהקיסר קלודיוס ציווה לגרש את כל היהודים מרומא. ");
INSERT INTO heblb_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","מאחר שהזוג עסק במקצועו של פולוס – אריגת יריעות אוהלים – החליט פולוס לגור בביתם ולעבוד יחד איתם. ");
INSERT INTO heblb_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","כל שבת ביקר פולוס בבית־הכנסת וניסה לשכנע בדבריו גם את היהודים וגם את היוונים. ");
INSERT INTO heblb_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","לאחר שהגיעו סילא וטימותיוס ממקדוניה, הקדיש פולוס את כל זמנו להטפה ולהוכחת משיחותו של ישוע ליהודים. ");
INSERT INTO heblb_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","אולם כשהתנגדו היהודים לפולוס וגידפו את ישוע, ניער פולוס את האבק מבגדיו ואמר: ”דמכם בראשכם! עשיתי את המוטל עלי, ומצפוני נקי. מעתה ואילך אלך לגויים!“ ");
INSERT INTO heblb_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","הוא יצא מבית־הכנסת ועבר לגור בביתו של טיטוס יוסטוס, איש ירא־אלוהים שגר בקרבת מקום. ");
INSERT INTO heblb_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","אולם קריספוס – ראש בית־הכנסת – וכל בני ביתו האמינו באדון. גם קורינתיים רבים שהקשיבו לפולוס האמינו לדבריו ונטבלו במים. ");
INSERT INTO heblb_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","לילה אחד דיבר האדון ישוע אל פולוס בחזיון ואמר: ”אל תפחד! המשך לבשר ואל תחדל, ");
INSERT INTO heblb_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","כי אני איתך! איש לא יפגע בך לרעה, כי אנשים רבים בעיר הזאת שייכים לי.“ ");
INSERT INTO heblb_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","וכך נשאר פולוס באותה עיר כשנה וחצי ולימד את דבר אלוהים. ");
INSERT INTO heblb_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","אולם כשנתמנה גליון למושל אכיה, ארגנו היהודים הפגנת מחאה נגד פולוס, והעמידוהו לדין לפני המושל. ");
INSERT INTO heblb_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","”האיש הזה מסית את בני־האדם לעבוד את אלוהים בדרך המנוגדת לחוק הרומאי!“ האשימו אותו. ");
INSERT INTO heblb_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","אולם עוד לפני שהספיק פולוס לפתוח את פיו ולהגן על עצמו, פנה גליון אל מאשימיו ואמר: ”הקשיבו, יהודים: אילו הבאתם לפני מקרה פשע, הייתי חייב להקשיב לכם, ");
INSERT INTO heblb_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","אולם כיוון שזוהי שאלה של הגדרות מילוליות, של שמות, מושגים ומונחים בנושא הדת שלכם, טפלו בכך אתם בעצמכם. אינני מעוניין לדון בעניין!“ ");
INSERT INTO heblb_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","והוא גירש אותם מאולם המשפט. ");
INSERT INTO heblb_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","הם הלכו ותפסו את סוסתניס, שנבחר לא־מזמן לראש בית־הכנסת, הכו אותו ועשו בו שפטים לפני כסא המשפט, אך לגליון לא היה אכפת. ");
INSERT INTO heblb_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","פולוס נשאר בקורינתוס עוד זמן־מה, ולאחר מכן נפרד לשלום מן המאמינים והפליג לסוריה יחד עם פריסקילה ועקילס. בקנכרי גילח פולוס את שער ראשו, משום שנדר נדר מסוים. ");
INSERT INTO heblb_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","כשהגענו לנמל אפסוס, הוא הלך לבית־הכנסת כדי לשוחח עם היהודים. ");
INSERT INTO heblb_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","הם ביקשו ממנו להישאר אצלם עוד ימים אחדים, אך פולוס השיב שאין לו זמן לכך. ");
INSERT INTO heblb_vpl VALUES ("AC18_21‏","074_18_21‏","ACT","18","21‏","22","”אני מוכרח להגיע לירושלים לפני החג“, אמר להם. ”אולם אם ירצה השם, אשוב לבקר אתכם.“ פולוס הפליג לדרכו והגיע לקיסריה. הוא הלך לבקר את הקהילה, ולאחר מכן המשיך לאנטיוכיה. ");
INSERT INTO heblb_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","לאחר ששהה זמן־מה באנטיוכיה, המשיך בדרכו ועבר באזור גלטיה ובפריגיה. בכל מקום ביקר אצל המאמינים, עודד אותם ועזר להם להתחזק באמונתם. ");
INSERT INTO heblb_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","באותם ימים הגיע לאפסוס יהודי יליד אלכסנדריה, אפולוס שמו, אשר היה מטיף ומורה מוכשר ובקיא בתנ״ך. ");
INSERT INTO heblb_vpl VALUES ("AC18_25‏","074_18_25‏","ACT","18","25‏","26","הוא היה מלומד בדרך האדון, ולימד היטב על־אודות ישוע, אבל ידע על טבילת יוחנן בלבד. בהתלהבות רבה ובאומץ לב הטיף אפולוס בבית הכנסת: פריסקילה ועקילס שמעו את דרשתו המרשימה והזמינו אותו לביתם והסבירו לו את דרך אלוהים ביתר דיוק. ");
INSERT INTO heblb_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","אפולוס החליט לנסוע ליוון, והאחים עודדו אותו לעשות כן. הם כתבו מכתב למאמינים ביוון וביקשו מהם לקבלו בחמימות. לאחר שהגיע ליוון השתמש בו אלוהים לחיזוק הקהילה המקומית, ");
INSERT INTO heblb_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","מפני שהצליח לסתור את טענות היהודים בוויכוחים פומביים, והוכיח לכולם, מתוך הכתוב בתנ״ך, שישוע הוא המשיח. ");
INSERT INTO heblb_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","בזמן שאפולוס היה בקורינתוס עבר פולוס בכל רחבי אסיה הקטנה, וכשהגיע לאפסוס פגש תלמידים אחדים. ");
INSERT INTO heblb_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","”האם קיבלתם את רוח הקודש כשהאמנתם?“ שאל אותם. ”לא“, ענו. ”למה אתה מתכוון? מהו רוח הקודש?“ ");
INSERT INTO heblb_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","”אם כן, באיזו טבילה נטבלתם?“ שאל פולוס. ”על עיקרי האמונה שלימד יוחנן המטביל“, השיבו התלמידים. ");
INSERT INTO heblb_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","”טבילתו של יוחנן באה רק להוכיח את הרצון לשוב מן החטא ולהאמין באלוהים,“ הסביר להם פולוס, ”ומי שנטבל חייב להאמין בישוע המשיח, שעל בואו ניבא יוחנן.“ ");
INSERT INTO heblb_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","לשמע דברים אלה מיהרו התלמידים להיטבל בשם האדון ישוע המשיח. ");
INSERT INTO heblb_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","כשסמך פולוס את ידיו עליהם, צלח עליהם רוח הקודש והם החלו להתנבא ולדבר בשפות בלתי־מובנות. ");
INSERT INTO heblb_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","שנים־עשר איש נכחו באותו מעמד. ");
INSERT INTO heblb_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","במשך שלושת החודשים הבאים הלך פולוס מדי שבת לבית־הכנסת, הטיף באומץ לב על אמונתו, ושכנע אנשים רבים להאמין בישוע המשיח. ");
INSERT INTO heblb_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","אולם היו אנשים שדחו את בשורתו ודיברו בפומבי נגד ישוע. משום כך עזב פולוס את המקום וסרב לשוב ולדבר אליהם. הוא הוציא מתוכם את המאמינים המשיחיים, ולימד אותם מדי יום בבית־המדרש ”טורנוס“. ");
INSERT INTO heblb_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","הדבר נמשך כשנתיים, עד שכל אדם באסיה הקטנה – יהודי וגוי – שמע את בשורת ה׳. ");
INSERT INTO heblb_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","מה נפלאים היו הניסים שחולל אלוהים באמצעות פולוס! ");
INSERT INTO heblb_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","כאשר הונחו ממחטותיו או חולצותיו על החולים, נעלמו מיד המחלות, והרוחות הרעות עזבו אותם. ");
INSERT INTO heblb_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","מספר נוודים יהודים, אשר נדדו ממקום למקום וגירשו שדים ורוחות רעות, החליטו לנסות לגרש את השדים והרוחות בשם האדון ישוע. הם החליטו להשתמש בלחש הבא: ”בשם אותו ישוע שעליו מבשר פולוס, אני מצווה עליך לצאת!“ ");
INSERT INTO heblb_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","בין המלחשים האלה היו שבעת בניו של סקווה, שהיה אחד מראשי הכוהנים. ");
INSERT INTO heblb_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","אולם כשניסו להשתמש בלחש זה כדי לגרש שד מאדם אחד, השיב להם השד: ”אני מכיר את ישוע ואני מכיר את פולוס, אבל מי אתם?“ ");
INSERT INTO heblb_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","השד התנפל על שניים מהם והכה אותם נמרצות, עד שברחו מן הבית ההוא עירומים ופצועים. ");
INSERT INTO heblb_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","סיפור המעשה התפשט במהירות רבה בין היהודים והגויים בכל אפסוס. פחד גדול שרר בעיר, ושם ישוע המשיח זכה לכבוד ולהערצה. ");
INSERT INTO heblb_vpl VALUES ("AC19_18‏","074_19_18‏","ACT","19","18‏","19","מאמינים רבים שעסקו לפנים במעשי כישוף למיניהם התוודו על מעשיהם בפומבי. הם הביאו את ספרי הכישופים ואת הקמעות שלהם, ושרפו אותם באש לעיני כולם (מישהו העריך את שווי הספרים האלה בכ־100,000 שקלים). ");
INSERT INTO heblb_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","מעשה זה של המאמינים הוכיח שדבר ה׳ חדר עמוק ללב האנשים באזור כולו. ");
INSERT INTO heblb_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","לאחר מאורעות אלה החליט פולוס לחצות את יוון בדרכו לירושלים. ”אחרי כן,“ אמר, ”עלי ללכת לרומא.“ ");
INSERT INTO heblb_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","הוא שלח לפניו ליוון את שני עוזריו, טימותיוס ואריסטוס, והוא עצמו נשאר בינתיים באסיה הקטנה. ");
INSERT INTO heblb_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","באותו זמן התפתחה באפסוס מהומה גדולה הקשורה במאמינים המשיחיים. ");
INSERT INTO heblb_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","המהומה החלה בגלל צורף בשם דמטריוס, אשר היה בעל מפעל לייצור דגמי כסף של מקדש האלילה היוונית ארטמיס. הוא העסיק פועלים רבים ושילם להם משכורת גבוהה. ");
INSERT INTO heblb_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","דמטריוס כינס את פועליו ופועלים אחרים שעסקו באותו מקצוע, ופנה אליהם: ”רבותי, מלאכה זאת היא כל פרנסתנו. ");
INSERT INTO heblb_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","אתם רואים ושומעים בעצמכם מה עושה פולוס זה. הוא הצליח לפתות אנשים רבים להאמין שאלילים מעשה ידי־אדם אינם אלוהים כלל, וכתוצאה מכך יורד היקף המכירות שלנו! הוא פיתה את האנשים לא רק באפסוס, כי אם בכל הארץ! ");
INSERT INTO heblb_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","אינני מדבר אך ורק על הצד העסקי של העניין, על אבדן הכנסתנו וקיפוח פרנסתנו; חשבו לרגע על הסכנה שבאבדן יוקרתה של האלה הגדולה ארטמיס! תוך זמן קצר לא יהיה כל ערך למקדשה של ארטמיס, אשר שמה יצא לתהילה לא רק בארצנו, אלא בעולם כולו!“ ");
INSERT INTO heblb_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","דברים אלה עוררו את זעמם של הפועלים, והם החלו לצרוח: ”גדולה היא ארטמיס של האפסים!“ ");
INSERT INTO heblb_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","עד מהרה הייתה מהומה ברחבי העיר. ההמונים תפסו את גיוס ואריסטרכוס ממקדוניה, שהיו מלוויו של פולוס, וגררו אותם אל האמפיתיאטרון כדי להעמידם לדין. ");
INSERT INTO heblb_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","פולוס רצה ללכת ולדבר אל ההמון, אולם התלמידים לא הניחו לו. ");
INSERT INTO heblb_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","אפילו מספר קצינים רומאים מהאזור, שהיו אוהדיו של פולוס, הזהירו אותו; הם הודיעו לו שלא יסכן את חייו ושלא יעז ללכת לאמפיתיאטרון. ");
INSERT INTO heblb_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","בתוך האמפיתיאטרון הייתה מהומה; זה צועק דבר אחד, וזה צועק דבר אחר; איש לא שמע את דברי רעהו. למעשה רוב האנשים לא ידעו כלל מדוע התאספו שם! ");
INSERT INTO heblb_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","אחדים הגיעו למסקנה שאלכסנדר היה אשם בכל, מפני שהיהודים דחפו אותו קדימה. אלכסנדר הניף את ידו וביקש שקט, כדי שיוכל לדבר. ");
INSERT INTO heblb_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","אולם משנוכח הקהל לדעת שהוא יהודי, החלו כולם לצעוק: ”גדולה היא ארטמיס של האפסים! גדולה היא ארטמיס של האפסים!“ צעקותיהם נמשכו שעתיים שלמות. ");
INSERT INTO heblb_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","בסופו של דבר הצליח מזכיר העיר להשתיק את ההמון הזועם. ”אנשי אפסוס,“ פתח ואמר, ”הרי כל אחד יודע שאפסוס היא המרכז הדתי של פולחן האלה הגדולה ארטמיס, אשר הפסל שלה ירד אלינו מהשמים. ");
INSERT INTO heblb_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","הואיל ואיש אינו חולק על עובדה זאת, עליכם להירגע ולא לנהוג בפזיזות ובקלות ראש! ");
INSERT INTO heblb_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","אתם הבאתם הנה אנשים אשר לא שדדו דבר ממקדשה של ארטמיס, ואף לא חיללו את כבודה. ");
INSERT INTO heblb_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","אם לדמטריוס ולפועליו יש טענות נגדם, שיתבעו אותם לדין! הרי בתי־הדין שלנו פתוחים לקהל בשעות הרגילות, והשופטים יכולים לדון בעניין ללא דיחוי. ");
INSERT INTO heblb_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","אם יש לכם תלונות בעניינים אחרים, עליכם לנהוג לפי המקובל ולהביא אותן לפני מועצת העיר. ");
INSERT INTO heblb_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","כולנו נמצאים עתה בסכנה, כי הממשל הרומאי עלול לדרוש מאיתנו דין וחשבון על ההתפרעות הזאת, שאין לה שום הצדקה. ואם הממשל ידרוש הסבר, לא יהיה לנו מה לומר!“ ");
INSERT INTO heblb_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","כשסיים לדבר, שלח את ההמונים לבתיהם. ");
INSERT INTO heblb_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","לאחר ששככה הסערה אסף פולוס את התלמידים, ובדברי עידוד נפרד מהם לשלום ויצא בדרכו למקדוניה. ");
INSERT INTO heblb_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","בכל הערים שבהן עבר הוא לימד את המאמינים את דבר ה׳, ולבסוף הגיע ליוון. ");
INSERT INTO heblb_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","כעבור שלושה חודשים התכונן פולוס ללכת לסוריה, אולם משנודע לו שהיהודים תכננו להתנקש בחייו, החליט לסטות מדרכו ולנסוע קודם צפונה, למקדוניה. ");
INSERT INTO heblb_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","מספר אנשים ליוו את פולוס עד אסיה הקטנה: סופטרוס בן־פורוס מברואה; ארסטרכוס וסקונדוס מתסלוניקי; גיוס מדרבי; טימותיוס; וטוכיקוס וטרופימוס אשר חזרו לבתיהם באסיה הקטנה. ");
INSERT INTO heblb_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","כל אלה הלכו לפנינו וחיכו לנו בטרואס. ");
INSERT INTO heblb_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","בתום חג הפסח עלינו על ספינה בפיליפי, שבצפון יוון, וכעבור חמישה ימים הגענו לטרואס, שם נשארנו שבוע ימים. ");
INSERT INTO heblb_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","במוצאי שבת התאספנו יחד לבצוע לחם, ופולוס, שעמד לצאת לדרכו למחרת בבוקר, דרש דרשה שנמשכה עד חצות. ");
INSERT INTO heblb_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","חדר־העלייה שבו התאספנו היה מואר בנרות רבים. ");
INSERT INTO heblb_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","כל אותו זמן ישב אבטוכוס הצעיר על אדן החלון, ומכיוון שפולוס האריך בדבריו, נפלה עליו תרדמה. לפתע איבד אבטוכוס את שיווי משקלו ונפל ארצה מן הקומה השלישית ומת בו במקום. ");
INSERT INTO heblb_vpl VALUES ("AC20_10‏","074_20_10‏","ACT","20","10‏","12","פולוס רץ למטה ולקח את הבחור בזרועותיו. ”אל תדאגו,“ הרגיע אותם, ”יש בו רוח חיים והוא יהיה בסדר!“ ואכן הכרתו שבה אליו. שמחה גדולה מילאה את כל הקהילה. כולם חזרו לעליית־הגג. פולוס אכל ולאחר מכן פתח בדרשה נוספת שנמשכה עד אור הבוקר, ואז ניפרד מהם לשלום. ");
INSERT INTO heblb_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","פולוס המשיך ברגל לאסוס, ואילו אנחנו הגענו לשם לפניו בספינה. ");
INSERT INTO heblb_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","כאשר הצטרף אלינו באסוס, הפלגנו יחד למיטוליני. ");
INSERT INTO heblb_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","למחרת הפלגנו דרך כיוס, ביום השלישי עגנו בסמוס (בלילה ישנו בטרוגוליון), וביום הרביעי הגענו למיליטוס. ");
INSERT INTO heblb_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","פולוס סרב להתעכב הפעם באפסוס, כי רצה להגיע לירושלים לקראת חג השבועות, אם יעלה הדבר בידו. ");
INSERT INTO heblb_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","אולם בהגיענו למיליטוס שלח פולוס הודעה לזקני הקהילה באפסוס, וביקש מהם לבוא לפגוש אותו שם. ");
INSERT INTO heblb_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","כשהגיעו, אמר להם: ”אתם יודעים היטב שמהיום הראשון שדרכתי על אדמת אסיה ועד היום הזה, ");
INSERT INTO heblb_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","עשיתי את עבודת האדון בענווה – ואפילו בדמעות – למרות הצרות שגרמו לי נוכלים מבין היהודים. ");
INSERT INTO heblb_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","ובכל זאת, מעולם לא פחדתי לומר לכם את האמת; לימדתי אתכם והטפתי לכם בציבור ובבתים פרטיים. ");
INSERT INTO heblb_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","בישרתי לכם בשורה אחת ליהודים ולגויים גם יחד, שעליהם להפסיק לחטוא, לחזור בתשובה, ולפנות לאלוהים באמצעות האמונה בישוע המשיח אדוננו. ");
INSERT INTO heblb_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","”עתה אני הולך לירושלים, כי עלי לציית לרוח הקודש המדריך אותי, אולם איני יודע מה מצפה לי שם. ");
INSERT INTO heblb_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","אני יודע רק דבר אחד: שבכל עיר רוח הקודש מזהיר אותי מפני העינויים והמאסר המצפים לי. ");
INSERT INTO heblb_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","אולם לחיי אין כל ערך אם לא אבצע את המשימה שהטיל עלי ישוע אדוננו: לספר לכולם על אהבת אלוהים ועל חסדו. ");
INSERT INTO heblb_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","”אני בטוח שאף אחד מכם – אשר שמעתם מפי את דבר ה׳ – לא ישוב לראותי, ");
INSERT INTO heblb_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","ומשום כך עלי לומר לכם: מצפוני נקי בנוגע לכל אחד ואחד מכם! ");
INSERT INTO heblb_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","כי מעולם לא היססתי לבשר לכם את דבר האלוהים. ");
INSERT INTO heblb_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","”השגיחו על עצמכם ועל הצאן שרוח הקודש הטיל עליכם את האחריות עליה – אשר הן קהילת אלוהים שקנה במחיר דמו. ");
INSERT INTO heblb_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","אני יודע היטב שלאחר לכתי מכאן יופיעו ביניכם מורי שקר, אשר יהיו כזאבים אכזריים ולא יחוסו על העדר. ");
INSERT INTO heblb_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","אפילו אחדים מכם יסלפו את האמת כדי למשוך אחריהם תלמידים. ");
INSERT INTO heblb_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","לכן היזהרו! זכרו שבמשך שלוש שנים לא חדלתי להשגיח עליכם יומם ולילה, ואף שפכתי דמעות רבות בגללכם. ");
INSERT INTO heblb_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","”עתה אני מפקיד אתכם בידי אלוהים ודברו הנפלא, אשר בכוחו לבנות את אמונתכם ולתת לכם את הנחלה השמורה לבניו. ");
INSERT INTO heblb_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","”מעולם לא השתוקקתי לכסף או לבגדים יקרים. ");
INSERT INTO heblb_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","כולכם יודעים שבמו ידי עבדתי ופרנסתי את עצמי ואת בני־לוויתי. ");
INSERT INTO heblb_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","אתם גם יודעים שתמיד שימשתי לכם דוגמה בהגישי עזרה לעניים, משום שזכרתי את דברי אדוננו ישוע המשיח: מוטב לתת מאשר לקבל!“ ");
INSERT INTO heblb_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","כשסיים פולוס את דבריו, כרע על ברכיו והתפלל איתם. ");
INSERT INTO heblb_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","כולם בכו בעת שחיבקו אותו ונשקו לו נשיקת פרידה. ");
INSERT INTO heblb_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","יותר מכל הם הצטערו על שאמר להם שלא ישובו לראותו. לאחר מכן ליוו אותו כולם אל האונייה. ");
INSERT INTO heblb_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","לאחר שנפרדנו מזקני קהילת אפסוס, הפלגנו ישר לקוס. למחרת הגענו לרודוס, ומשם – לפטרה. ");
INSERT INTO heblb_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","בפטרה עלינו על אונייה שהפליגה לפניקיה שבסוריה. ");
INSERT INTO heblb_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","ראינו את האי קפריסין לשמאלנו, והמשכנו לנמל צור – שם נפרק מטען הספינה. ");
INSERT INTO heblb_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","ירדנו לחוף וחיפשנו את המאמינים המקומיים. כשמצאנו אותם, נשארנו איתם שבוע ימים. המאמינים האלה שמעו מרוח הקודש שפולוס יסבול בירושלים ועל כן הם הזהירו אותו שלא יעלה לשם. ");
INSERT INTO heblb_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","כשהגיע זמננו לקיצו עזבנו את צור והמשכנו בדרכנו. כל חברי הקהילה ליוו אותנו לספינה, כולל הנשים והילדים, וכאשר הגענו לחוף התפללנו. ");
INSERT INTO heblb_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","לאחר פרידה נרגשת עלינו לספינה, והם חזרו לבתיהם. ");
INSERT INTO heblb_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","התחנה הבאה שלנו, לאחר שעזבנו את צור, הייתה עכו. גם שם שאלנו לשלום האחים, אולם התעכבנו אצלם יום אחד בלבד. ");
INSERT INTO heblb_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","משם נסענו לקיסריה, והלכנו לביתו של פיליפוס המבשר, שהיה אחד משבעת השמשים הראשונים. ");
INSERT INTO heblb_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","היו לו ארבע בנות רווקות שהיו נביאות. ");
INSERT INTO heblb_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","לאחר ששהינו שם מספר ימים בא לבקר אותנו אח אחד מיהודה, אגבוס שמו, שגם הוא היה נביא. ");
INSERT INTO heblb_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","אגבוס לקח את חגורתו של פולוס, כפת בה את ידיו ורגליו ואמר: ”רוח הקודש אומר: ככה יאסרו יהודי ירושלים את בעל החגורה הזאת, ויסגירו אותו לידי הרומאים!“ ");
INSERT INTO heblb_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","לשמע דברים אלה ביקשנו כולנו מפולוס – גם חברי הקהילה המקומית וגם מלוויו – שלא יעלה לירושלים. ");
INSERT INTO heblb_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","אולם פולוס השיב: ”לשם מה הבכי הזה? אתם ממש שוברים את לבי! הרי אני מוכן לא רק להיאסר בירושלים, אלא אף למות על קידוש שמו של האדון ישוע המשיח!“ ");
INSERT INTO heblb_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","בראותנו שאי־אפשר לשכנע אותו, הפסקנו להפציר בו ואמרנו: ”ייעשה רצון ה׳.“ ");
INSERT INTO heblb_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","כעבור זמן קצר ארזנו את חפצינו ועלינו לירושלים. ");
INSERT INTO heblb_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","מאמינים אחדים מקיסריה ליוו אותנו בדרכנו, וכשהגענו לירושלים התארחנו בביתו של מנסון, יליד קפריסין ומאמין ותיק. ");
INSERT INTO heblb_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","כל המאמינים בעיר קיבלו את פנינו בחמימות ובלבביות רבה. ");
INSERT INTO heblb_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","למחרת הלכנו עם פולוס לבקר את יעקב; וכל זקני הקהילה היו שם. ");
INSERT INTO heblb_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","לאחר חילופי ברכות סיפר להם פולוס על המעשים הנפלאים שעשה אלוהים באמצעותו בין הגויים. ");
INSERT INTO heblb_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","הם הודו לאלוהים, ולאחר מכן אמרו: ”אחינו היקר, אתה יודע שגם אלפי יהודים האמינו במשיח, וכולם קנאים לתורה. ");
INSERT INTO heblb_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","היהודים המשיחיים כאן בירושלים שמעו שאתה מתנגד לתורת־משה ולמנהגי ישראל, ושאתה אוסר על המאמינים למול את בניהם. ");
INSERT INTO heblb_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","מה לעשות? הרי עוד מעט ישמעו כולם שאתה נמצא בעיר. ");
INSERT INTO heblb_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","”יש לנו הצעה: יש בינינו ארבעה אנשים שעומדים לפני סיום תקופת נדר הנזירות שלהם. ");
INSERT INTO heblb_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","לך איתם לבית־המקדש, קיים את טקס ההיטהרות, ושלם בעד התגלחות שלהם. כך יידעו כולם שלא זו בלבד שאינך מתנגד למנהגי היהודים, אתה עצמך מקיים את התורה, ודעתך כדעתם בעניין הזה. ");
INSERT INTO heblb_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","”באשר למאמינים המשיחיים מבין הגויים – אנו דורשים מהם לקיים את המנהגים שעליהם כתבנו להם: לא לאכול מזון שהוקרב לאלילים, לא לאכול בשר טרף, לא לאכול בשר עם דם ולהימנע מזנות.“ ");
INSERT INTO heblb_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","פולוס הסכים להצעתם, ולמחרת הלך עם הארבעה לבית המקדש כדי לקיים את הטקס ולקבוע את תאריך הקרבת קרבן עבור כל אחד מהם, בתום שבעת ימי הטהרה. ");
INSERT INTO heblb_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","אולם עוד לפני שחלפו שבעת הימים הבחינו בו במקדש מספר יהודים מאסיה, והסיתו נגדו את ההמון. הם תפסו בו וצרחו: ");
INSERT INTO heblb_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","”אנשי ישראל! עזרו לנו! זהו האיש המסית את כולם נגד עמנו! הוא מצווה על כולם להפר את התורה! הוא גם מדבר נגד בית־המקדש הזה, ומטמא אותו בגויים שהוא מביא לתוכו!“ ");
INSERT INTO heblb_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","הם אמרו דברים אלה משום שבאותו יום ראו את פולוס בחברת טרופימוס, גוי מאפסוס, והניחו שפולוס הביאו אל המקדש. ");
INSERT INTO heblb_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","האשמות אלה הציתו את האווירה בעיר, ועד מהרה פרצה מהומה. הם סחבו את פולוס אל מחוץ למקדש, ומיד ננעלו הדלתות מאחוריו. ");
INSERT INTO heblb_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","בעוד ההמון מנסה להרוג את פולוס, נודע דבר המהומה למפקד החטיבה הרומאית בירושלים, ");
INSERT INTO heblb_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","והוא ציווה מיד על חייליו וקציניו לרוץ אל ההמון. כשראו התוקפים את החיילים הרומאים, הם הרפו מפולוס. ");
INSERT INTO heblb_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","המפקד עצר את פולוס וציווה לכבול אותו בשרשרת כפולה. לאחר מכן שאל את ההמון מי הוא ומה עשה. ");
INSERT INTO heblb_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","אחדים צעקו דבר אחד, ואחרים צרחו דבר אחר. כשראה המפקד שאינו יכול להבין דבר בגלל הרעש, ציווה להביא את פולוס אל המצודה. ");
INSERT INTO heblb_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","כשהגיעו החיילים והאסיר אל המדרגות, נעשה ההמון אלים כל־כך, עד שהחיילים נאלצו לשאת את פולוס על כתפיהם כדי להגן עליו. ");
INSERT INTO heblb_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","ואילו ההמון נהר בעקבותיהם וצרח: ”הרגו אותו!“ ");
INSERT INTO heblb_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","לפני שהוכנס פולוס אל המצודה הוא פנה אל המפקד ושאל: ”האם מותר לי לומר לך כמה מילים?“ ”אתה מדבר יוונית?“ שאל המפקד. ");
INSERT INTO heblb_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","”האם אינך המצרי שארגן לא מזמן מרד ומשך אחריו למדבר ארבעת־אלפים רוצחים?“ ");
INSERT INTO heblb_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","”לא,“ ענה פולוס, ”אני יהודי מהעיר הגדולה טרסוס שבקיליקיה. אני רוצה לבקש את רשותך לדבר אל האנשים האלה.“ ");
INSERT INTO heblb_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","המפקד נתן לו רשות לעשות כן, ופולוס נעמד על המדרגות ורמז לאנשים לשתוק. כשהשתררה דממה מוחלטת הוא פנה אליהם בעברית ואמר: ");
INSERT INTO heblb_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","”אחי ואבותיי, הקשיבו נא לדברי ההגנה שלי.“ ");
INSERT INTO heblb_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","כששמעו שהוא מדבר עברית נפלה דממה כבדה עוד יותר. ");
INSERT INTO heblb_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","פולוס המשיך: ”אני יהודי, יליד טרסוס שבקיליקיה, אולם חונכתי כאן בירושלים, בבית־מדרשו של רבן גמליאל, והוא שלימד אותי לשמור בקפידה את כל חוקי התורה ומצוותיה. הייתי קנאי לה׳ בכל מעשי, ממש כשם שאתם קנאים לו היום. ");
INSERT INTO heblb_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","בזמנו רדפתי את המשיחיים עד מוות, כבלתי גברים ונשים והשלכתי אותם לכלא. ");
INSERT INTO heblb_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","הכהן הגדול וכל אחד מחברי הסנהדרין יוכלו להעיד על כך, משום שביקשתי מהם מכתבים אל ראשי הקהילה היהודית בדמשק. מכתבים אלה העניקו לי את הסמכות לכבול כל משיחי שאמצא, ולהביאו לירושלים כדי שייענש. ");
INSERT INTO heblb_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","”יום אחד בשעת הצהריים, כשהייתי בדרכי לדמשק, האיר עלי לפתע אור חזק מן השמים. ");
INSERT INTO heblb_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","נפלתי על הארץ ושמעתי קול: ’שאול, שאול, מדוע אתה רודף אותי?‘ ");
INSERT INTO heblb_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","” ’מי אתה, אדוני?‘ שאלתי.“ ”והקול ענה: ’אני ישוע מנצרת שאותו אתה רודף!‘ ");
INSERT INTO heblb_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","האנשים שהיו איתי ראו את האור, אך לא הבינו את הנאמר. ");
INSERT INTO heblb_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","” ’מה עלי לעשות, אדוני?‘ שאלתי. ”והאדון ענה: ’קום ולך לדמשק, ושם ייאמר לך מה צפוי לך בעתיד‘. ");
INSERT INTO heblb_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","”האור החזק סנוור אותי עד עיוורון, והיה צורך להוביל אותי בידי לדמשק. ");
INSERT INTO heblb_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","”בדמשק בא אלי אדם צדיק וירא־אלוהים, חנניה שמו, אשר קיים את מצוות התורה והיה מקובל על כל היהודים. ");
INSERT INTO heblb_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","חנניה עמד לצדי ואמר: ’שאול אחי, פקח את עיניך!‘ ומיד נפקחו עיני ויכולתי לראות כמקודם. ");
INSERT INTO heblb_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","”לאחר מכן הוא אמר לי: ’אלוהי אבותינו בחר בך לדעת את רצונו, לראות את המשיח הצדיק ולשמוע את קולו. ");
INSERT INTO heblb_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","עליך לשאת את בשורת אלוהים לכל מקום, ולספר לכולם מה ששמעת וראית. ");
INSERT INTO heblb_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","למה אתה מחכה עכשיו? לך להיטבל במים והתרחץ מחטאיך, בקראך בשם האדון!‘ ");
INSERT INTO heblb_vpl VALUES ("AC22_17‏","074_22_17‏","ACT","22","17‏","18","”יום אחד, לאחר שחזרתי לירושלים, דיבר אלי ה׳ בחזיון בשעה שהתפללתי בבית־המקדש. ’הזדרז וצא מירושלים‘, הוא אמר אלי, ’כי תושבי העיר לא יאמינו למה שתספר להם עלי‘. ");
INSERT INTO heblb_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","” ’אבל אדון‘, מחיתי, ’הם יודעים היטב שהלכתי לבית־הכנסת והכיתי את המאמינים בך, ואף השלכתי אותם לכלא. ");
INSERT INTO heblb_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","וכשהרגו את עבדך סטפנוס, עמדתי שם בהסכמה לנעשה והשגחתי על מעיליהם של רוצחיו!‘ ");
INSERT INTO heblb_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","”אולם אלוהים אמר לי: ’עזוב את ירושלים, כי אני שולח אותך הרחק אל הגויים!‘ “ ");
INSERT INTO heblb_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","הקהל הקשיב בתשומת לב עד שאמר פולוס את המשפט האחרון, ואז צעקו כולם פה־אחד: ”סלקו אותו מכאן! הרגו אותו! הוא אינו ראוי לחיות!“ ");
INSERT INTO heblb_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","הם צרחו, השליכו את מעיליהם וזרקו עפר כלפי מעלה. ");
INSERT INTO heblb_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","המפקד ציווה על חייליו להכניס את פולוס לתוך המצודה ולהלקותו ברצועות, כדי לאלצו להתוודות על פשעו. המפקד רצה לדעת מדוע היה הקהל נרגש ופרוע כל־כך. ");
INSERT INTO heblb_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","בשעה שהחיילים כבלו את פולוס כדי להלקותו, הוא פנה אל הקצין שעמד לצדו ושאל: ”האם מותר להלקות אזרח רומאי לפני שהעמדת אותו לדין?“ ");
INSERT INTO heblb_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","הקצין ניגש אל מפקד החטיבה וקרא: ”מה אתה עושה? האיש הזה אזרח רומאי!“ ");
INSERT INTO heblb_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","המפקד בא אל פולוס ושאל: ”האם אתה באמת אזרח רומאי?“ ”כן, בהחלט.“ ");
INSERT INTO heblb_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","”גם אני והאזרחות הזאת עלתה לי הרבה כסף!“ ”אבל אני אזרח רומאי מלידה!“ אמר פולוס. ");
INSERT INTO heblb_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","החיילים שעמדו להלקות את פולוס הרפו ממנו ברגע ששמעו שהוא אזרח רומאי, והמפקד נמלא פחד על־שום שציווה לאסרו ולהלקותו. ");
INSERT INTO heblb_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","למחרת בבוקר שחרר אותו המפקד מכבליו וציווה על ראשי הכוהנים לכנס ישיבת סנהדרין. הוא הביא לפניהם את פולוס כדי לנסות לברר מה הייתה הסיבה לכל המהומה הזאת. ");
INSERT INTO heblb_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","פולוס נעץ את מבטו בחברי הסנהדרין ואמר: ”אחים, תמיד חייתי לפני אלוהים במצפון נקי.“ ");
INSERT INTO heblb_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","באותו רגע ציווה חנניה הכהן על האנשים שעמדו ליד פולוס לסטור לו על פיו. ");
INSERT INTO heblb_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","”יסטור לך אלוהים, קיר מסויד שכמוך!“ קרא פולוס. ”איזה מן שופט אתה? כיצד אתה יכול לשבת כאן ולשפוט אותי על־פי התורה, כשבאותו זמן אתה עצמך עובר על התורה, ומצווה להכות אותי?!“ ");
INSERT INTO heblb_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","האנשים שעמדו קרוב לפולוס אמרו לו: ”אתה מעליב את הכהן הגדול!“ ");
INSERT INTO heblb_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","”אחי, אני מצטער“, התנצל פולוס. ”לא ידעתי שזהו הכהן הגדול. הרי כתוב בתורה שאסור להעליב נשיא או שליט.“ ");
INSERT INTO heblb_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","פתאום צץ רעיון במוחו של פולוס: הלא מחצית חברי הסנהדרין היו פרושים, ומחציתם – צדוקים. הוא קם על רגליו וקרא בקול: ”אחי, אני פרוש בן פרוש, ועכשיו אתם שופטים אותי על־שום שאני מאמין בתחיית המתים!“ ");
INSERT INTO heblb_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","דבריו אלה פילגו מיד את הסנהדרין לשניים, ועתה הייתה המחלוקת בין הפרושים ובין הצדוקים. ");
INSERT INTO heblb_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","כי הפרושים האמינו בתחיית המתים ובקיומם של מלאכים ורוחות, ואילו הצדוקים כפרו בכל אלה. ");
INSERT INTO heblb_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","ההמולה הלכה וגברה, וסופרים אחדים – שהיו פרושים בעצמם – קמו ודיברו בזכותו של פולוס. ”לא מצאנו כל אשמה באיש הזה!“ צעקו. ”אולי הקול שדיבר אליו בדרך לדמשק היה רוח או מלאך!“ ");
INSERT INTO heblb_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","המתיחות גברה והוויכוח התלהט; הנוכחים החלו למשוך את פולוס – זה לכאן וזה לכאן. מפקד החטיבה פחד שיקרעו את פולוס לגזרים, ולכן ציווה על חייליו לקחת אותו משם בכוח הזרוע ולהחזירו למצודה. ");
INSERT INTO heblb_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","באותו לילה עמד האדון לצדו של פולוס ואמר לו: ”חזק ואמץ, פולוס! כשם שהעדת עלי בפני תושבי ירושלים, כך תצטרך להעיד עלי גם בפני תושבי רומא!“ ");
INSERT INTO heblb_vpl VALUES ("AC23_12‏","074_23_12‏","ACT","23","12‏","13","לפנות בוקר התקבצו יחד למעלה מארבעים יהודים, ונדרו נדר שלא יאכלו ולא ישתו עד שיהרגו את פולוס. ");
INSERT INTO heblb_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","הם הלכו אל ראשי הכוהנים ואל הזקנים וסיפרו להם על כך. ");
INSERT INTO heblb_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","”בקשו ממפקד החטיבה להחזיר את פולוס לבית־הדין“, אמרו. ”העמידו פנים כאילו שאתם רוצים לשאול אותו עוד כמה שאלות, ואנחנו כבר נהרוג אותו בדרך.“ ");
INSERT INTO heblb_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","אולם בן־אחותו של פולוס גילה במקרה את מזימתם, ומיהר אל המצודה כדי לדווח לפולוס על כך. ");
INSERT INTO heblb_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","פולוס קרא לאחד הקצינים ואמר: ”קח את הנער הזה אל המפקד; יש לו משהו חשוב לספר לו.“ ");
INSERT INTO heblb_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","הקצין לקח את הנער, הביאו אל המפקד והסביר: ”פולוס האסיר קרא לי וביקש ממני להביא אליך את הנער הזה, כי יש לו משהו לומר לך.“ ");
INSERT INTO heblb_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","המפקד אחז בידו של הנער, הובילוהו הצידה ושאל: ”מה אתה רוצה לומר לי?“ ");
INSERT INTO heblb_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","”מחר מתכוננים היהודים לבקש ממך להחזיר את פולוס לסנהדרין,“ סיפר הנער, ”ביומרה שהם מעוניינים לשאול אותו שאלות נוספות. ");
INSERT INTO heblb_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","אולם אל תשמע בקולם! כי למעלה מארבעים איש אורבים לו בדרך, מוכנים להתנפל עליו ולהרוג אותו. הם נדרו נדר שלא יאכלו ולא ישתו עד שפולוס ימות. עתה הם מחכים שתענה בחיוב לבקשתם.“ ");
INSERT INTO heblb_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","”אל תאמר לאיש שסיפרת לי דברים אלה.“ הזהירו המפקד, ושלחו לדרכו. ");
INSERT INTO heblb_vpl VALUES ("AC23_23‏","074_23_23‏","ACT","23","23‏","24","לאחר מכן קרא המפקד לשני קצינים ופקד עליהם: ”הכינו מאתיים חיילים לצאת לקיסריה הערב בשעה תשע! קחו אתכם מאתיים קשתים, ועוד שבעים פרשים חמושים. תנו לפולוס סוס רכיבה, והביאו אותו בשלום אל פליקס המושל.“ ");
INSERT INTO heblb_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","הוא שלח בידם את המכתב הבא אל פליקס: ");
INSERT INTO heblb_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","”מאת: קלודיוס לוסיאס. ”אל: הוד מעלתו המושל פליקס. ”שלום וברכה! ");
INSERT INTO heblb_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","”אדם זה נתפס על־ידי היהודים, והם כמעט הרגו אותו. אולם משנודע לי שהוא אזרח רומאי, שלחתי מיד חיילים להצילו מידם. ");
INSERT INTO heblb_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","הבאתי אותו למשפט לפני בית־המשפט העליון של היהודים, כדי לדעת מה עשה. ");
INSERT INTO heblb_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","עד מהרה נוכחתי לדעת שהאשמותיהם מתייחסות רק לאמונה היהודית, ולא למעשה פלילי שדינו מאסר או מוות, ");
INSERT INTO heblb_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","אך כשנודע לי שיהודים רוצים להרוג אותו, החלטתי לשלחו אליך ולומר למאשימיו להביא את טענותיהם לפניך.“ ");
INSERT INTO heblb_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","החיילים מילאו את הפקודה ולקחו את פולוס בלילה למבצר אנטיפטרוס. ");
INSERT INTO heblb_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","למחרת בבוקר חזרו החיילים למצודה בירושלים, והשאירו את פולוס עם הפרשים כדי שייקחו אותו לקיסריה. ");
INSERT INTO heblb_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","בהגיעם לקיסריה הביאו את פולוס לפני המושל, ומסרו לו את המכתב. ");
INSERT INTO heblb_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","פליקס קרא את המכתב ושאל את פולוס למוצאו. ”אני מקיליקיה“, ענה פולוס. ");
INSERT INTO heblb_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","”אשמע את המקרה שלך במלואו כאשר יגיעו לכאן גם מאשימיך“, אמר לו המושל, וציווה לשמור עליו בכלא שבארמון המלך הורדוס. ");
INSERT INTO heblb_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","כעבור חמישה ימים הגיע חנניה הכהן הגדול לקיסריה, ואיתו אחדים מזקני היהודים ועורך־דין בשם טרטולוס. הם באו אל המושל והגישו את תלונתם נגד פולוס. ");
INSERT INTO heblb_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","כשהכניסו את פולוס אל החדר פתח טרטולוס בנאום התביעה: ”הוד מעלתך, המושל! הנהגתך הנבונה הביאה לנו, היהודים, שלום ושלווה, והפחיתה במידה ניכרת את ההפליה נגדנו. ");
INSERT INTO heblb_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","על כל אלה אנחנו מודים לך מאוד. ");
INSERT INTO heblb_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","איני רוצה לשעמם אותך ולבזבז את זמנך, אולם אני מתחנן לפניך שתואיל להקשיב לתלונתי נגד האיש הזה, ואני מבטיח לקצר בדברי. ");
INSERT INTO heblb_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","איש זה הוא מנהיג התנועה המשיחית; הוא מעורר מהומות, משלהב יצרים ומסית את היהודים בעולם כולו למרוד בקיסר. ");
INSERT INTO heblb_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","מלבד זאת הוא ניסה לחלל את בית־המקדש בשעה שאסרנו אותו. ”רצינו לתת לו את העונש המגיע לו, ");
INSERT INTO heblb_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","אבל לוסיאס המפקד בא וחטף אותו מידנו בכוח הזרוע, ");
INSERT INTO heblb_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","ודרש שפולוס יישפט על פי החוק הרומאי. אם תחקור אותו, תיווכח שדיברתי אמת.“ ");
INSERT INTO heblb_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","כל היהודים שנכחו שם אישרו את דברי טרטולוס. ");
INSERT INTO heblb_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","עתה הגיע תורו של פולוס לדבר. המושל רמז לו לקום על רגליו ולשאת את דברו. ”ידוע לי, אדוני, שאתה שופט בענייני היהודים כבר שנים רבות,“ פתח פולוס, ”ועל כן אני שמח להגן על עצמי לפניך. ");
INSERT INTO heblb_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","לא יקשה עליך לוודא שלא עברו למעלה משנים־עשר יום מאז שעליתי לירושלים, כדי להשתחוות לה׳ בבית־המקדש. ");
INSERT INTO heblb_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","כמו־כן תוכל לוודא בנקל שמעולם לא עוררתי מהומות בבתי־הכנסת ולא ברחובות העיר. ");
INSERT INTO heblb_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","איש מן האנשים האלה לא יוכל להוכיח אף אחת מההאשמות הרבות שהם טופלים עלי. ");
INSERT INTO heblb_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","”אולם אני מודה בדבר אחד: אני מאמין בדרך הישועה, שהם מתייחסים אליה כאל כת או תנועה, ובדרך זאת אני עובד את אלוהי אבותינו; אני מאמין באמונה שלמה בכל מה שכתוב בספרי התורה והנביאים. ");
INSERT INTO heblb_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","כמו כן אני מאמין, בדיוק כמו אנשים אלה, שתהיה תחיית המתים – לצדיקים ולרשעים. ");
INSERT INTO heblb_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","משום כך אני משתדל בכל כוחי לשמור על מצפון נקי לפני אלוהים ולפני בני אדם. ");
INSERT INTO heblb_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","”לאחר היעדרות של שנים אחדות חזרתי לירושלים, כדי להביא סכום כסף לעזרת היהודים המשיחיים וכדי להקריב קרבן לאלוהים. ");
INSERT INTO heblb_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","מאשימי ראו אותי במקדש בשעה שהקרבתי מנחה לה׳. ראשי היה מגולח, לפי דרישת התורה, ובאותה שעה לא היה קהל סביבי ולא הייתה כל מהומה. ");
INSERT INTO heblb_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","אולם היו שם יהודים אחדים מאסיה, ואם יש להם טענות נגדי, מדוע אין הם נמצאים כאן עתה? ");
INSERT INTO heblb_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","שאל־נא את האנשים העומדים כאן עתה איזה חטא מצא בי הסנהדרין שלהם, ");
INSERT INTO heblb_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","מלבד משפט אחד שצעקתי לעברם: ’אני עומד לפני המועצה הזאת כדי להגן על עצמי, משום שאני מאמין בתחיית המתים!‘ “ ");
INSERT INTO heblb_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","בנקודה זאת, פליקס, אשר ידע היטב את לימודי ישוע, סגר את התביעות ואמר: ”חכו עד שיגיע לוסיאס, מפקד הכוח, ורק אז אחליט במשפט.“ ");
INSERT INTO heblb_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","הוא ציווה לכלוא את פולוס בבית־הסוהר, אולם ציווה על הסוהרים להקל עליו את מאסרו, להתייחס אליו בעדינות ובאדיבות, ולהרשות לידידיו לבקר אותו, לטפל בו ולהביא לו מתנות. ");
INSERT INTO heblb_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","כעבור ימים אחדים בא פליקס עם אשתו היהודייה דרוסילה ושלח לקרוא לפולוס. פליקס ואשתו הקשיבו לפולוס בתשומת לב בשעה שסיפר להם על האמונה במשיח. ");
INSERT INTO heblb_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","הוא שוחח איתם על צדקה, על כיבוש היצר ועל הדין העתיד לבוא. פליקס, שנמלא פחד נורא, אמר לפולוס: ”לך עכשיו, בבקשה. אקרא לך שוב בהזדמנות אחרת.“ ");
INSERT INTO heblb_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","בסתר לבו הוא קיווה שפולוס יציע לו שוחד, ועל כן קרא לו מדי פעם לשיחה. ");
INSERT INTO heblb_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","כך חלפו שנתיים ימים, ואז מונה פורקיוס פסטוס למושל במקומו של פליקס. אולם פליקס רצה למצוא־חן בעיני היהודים, ולכן השאיר את פולוס בבית־הסוהר. ");
INSERT INTO heblb_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","שלושה ימים לאחר שנכנס פסטוס לתפקידו, עזב את קיסריה ועלה לירושלים. ");
INSERT INTO heblb_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","ראשי הכוהנים ומנהיגי העם ניגשו אל פסטוס וסיפרו לו את טענותיהם נגד פולוס. ");
INSERT INTO heblb_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","הם ביקשו ממנו להעלות את פולוס מקיסריה לירושלים ללא דיחוי (כי זממו לארוב לו בדרך ולרצוח אותו). ");
INSERT INTO heblb_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","אולם פסטוס השיב להם: ”פולוס נמצא עתה בקיסריה, וגם אני עומד לשוב לשם בקרוב. ");
INSERT INTO heblb_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","אני מציע שתבחרו מספר אנשים בעלי סמכות שילכו איתי לקיסריה, ואם פולוס חטא יוכלו אנשיכם לתבוע אותו למשפט.“ ");
INSERT INTO heblb_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","כעבור שמונה או עשרה ימים חזר המושל לקיסריה, ולמחרת ערך את משפטו של פולוס. ");
INSERT INTO heblb_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","כשהגיע פולוס לאולם בית־הדין, הקיפו אותו היהודים שבאו מירושלים והטיחו בו האשמות חמורות, אך הם לא יכלו להוכיח אף אחת מהן. ");
INSERT INTO heblb_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","פולוס כפר בכל ההאשמות. ”אינני אשם“, אמר. ”לא עברתי על חוקי התורה, לא חיללתי את בית־המקדש ולא מרדתי בקיסר!“ ");
INSERT INTO heblb_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","אולם פסטוס, שרצה מאוד למצוא־חן בעיני היהודים, פנה אליו ושאל: ”האם אתה מוכן לעלות לירושלים ולהישפט שם לפני?“ ");
INSERT INTO heblb_vpl VALUES ("AC25_10‏","074_25_10‏","ACT","25","10‏","11","”לא!“, השיב פולוס. ”בשום אופן לא. אני עומד בתוקף על זכותי לעמוד לדין לפני כס הקיסר! אתה יודע היטב שאיני אשם. אם ביצעתי פשע שדינו מוות – איני מבקש רחמים או חנינה. אולם אם אני חף מפשע – לאף אחד אין רשות להסגיר אותי לידי אנשים אלה כדי שירצחו אותי. ברצוני לערער לפני הקיסר!“ ");
INSERT INTO heblb_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","פסטוס התייעץ עם יועציו, ואחר כך אמר: ”אתה רוצה לערער לפני הקיסר? יהיה כרצונך!“ ");
INSERT INTO heblb_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","כעבור ימים אחדים באו המלך אגריפס וברניקה לבקר את פסטוס. ");
INSERT INTO heblb_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","ביקורם נמשך ימים אחדים, ופסטוס שוחח עם המלך על המקרה של פולוס. ”יש כאן אסיר אחד,“ פתח פסטוס, ”שפליקס השאירו בכלא. ");
INSERT INTO heblb_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","כשהייתי בירושלים סיפרו לי ראשי הכוהנים וזקני היהודים את גרסתם, ודרשו ממני להוציאו להורג. ");
INSERT INTO heblb_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","כמובן שמיהרתי להבהיר להם שהחוק הרומאי אינו מרשיע אדם לפני שמעמידים אותו לדין, ולפני שניתנה לו האפשרות לעמוד מול מאשימיו ולהגן על עצמו. ");
INSERT INTO heblb_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","”כשבאו לכאן מאשימיו כינסתי מיד את חברי בית־הדין, ושלחתי להביא את פולוס. ");
INSERT INTO heblb_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","אולם ההאשמות שהעלו נגדו כלל לא דמו לחשדות שהיו לי לגביו. ");
INSERT INTO heblb_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","המחלוקת ביניהם הייתה בנושא הדת היהודית, ועל אדם בשם ישוע אשר מת, ואילו פולוס מתעקש לטעון שהוא חי. ");
INSERT INTO heblb_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","לא ידעתי כיצד להחליט במקרה שכזה, ולכן שאלתי אותו אם יהיה מוכן להישפט על כך בירושלים. ");
INSERT INTO heblb_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","פולוס סרב, ודרש לערער לפני הקיסר אוגוסטוס! משום כך פקדתי להחזירו לכלא, עד שאוכל לקבוע לו ראיון אצל הקיסר.“ ");
INSERT INTO heblb_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","”הייתי רוצה לשמוע את האיש הזה במו אוזני“, אמר אגריפס. ”בסדר“, ענה פסטוס. ”מחר תשמע אותו.“ ");
INSERT INTO heblb_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","למחרת נכנסו המלך אגריפס וברניקה לאולם בית־הדין ברוב פאר והדר, ובליווי משמר קציני־צבא ואצילי העיר. פסטוס ציווה להכניס את פולוס לתוך האולם, ");
INSERT INTO heblb_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","ולאחר מכן פנה אל הנוכחים ואמר: ”המלך אגריפס, וכל הנאספים כאן: זהו האיש אשר היהודים בקיסריה ובירושלים רוצים במותו. ");
INSERT INTO heblb_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","לפי דעתי הוא לא עבר כל עברה שדינה מוות, אולם מאחר שדרש לערער לפני הקיסר, החלטתי לשלוח אותו לרומא. ");
INSERT INTO heblb_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","אבל מה אכתוב לקיסר? הרי אין נגדו שום טענה מבוססת! על כן הבאתי אותו לפני כולכם, ובמיוחד לפניך, המלך אגריפס, כדי שתחקור אותו ותאמר לי מה לכתוב. ");
INSERT INTO heblb_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","כי הרי אין זה הגיוני לשלוח אסיר אל הקיסר בלא אשמה כלשהי.“ ");
INSERT INTO heblb_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","”יש לך רשות לספר את גרסתך“, אמר אגריפס לפולוס. בתנועות ידיים החל פולוס להגן על עצמו לפני בית־הדין. ");
INSERT INTO heblb_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","”בר־מזל אני, כבוד המלך אגריפס, על שניתנה לי הזכות להשמיע באוזניך את תשובותיי להאשמותיהם של היהודים, ");
INSERT INTO heblb_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","כי אני יודע שאתה בקיא בחוקינו ובמנהגינו. אני מבקש ממך, אנא, הקשב לי בסבלנות. ");
INSERT INTO heblb_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","”כל היהודים יודעים שמאז ימי נעורי בטרסוס, ומאוחר יותר בירושלים, קיבלתי חינוך יהודי מסורתי, ותמיד חייתי על־פי הדרך שבה חונכתי. ");
INSERT INTO heblb_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","לו היו מוכנים להודות בכך, היו מאשרים שבשאלת קיום התורה והמסורת הייתי תמיד בין הפרושים המחמירים ביותר. ");
INSERT INTO heblb_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","אולם הסיבה האמיתית להאשמותיהם שונה לחלוטין; הם מתנכלים לי רק משום שאני מצפה להתגשמות הבטחת ה׳ לאבותינו. ");
INSERT INTO heblb_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","שנים־עשר שבטי ישראל מתפללים יומם ולילה שה׳ יגשים את אותה הבטחה שלה אני מצפה. אדוני המלך, בגלל צפייה זאת הם מאשימים אותי! ");
INSERT INTO heblb_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","אך האם זה פשע להאמין בתחיית המתים? האם אינכם מאמינים שאלוהים יכול להקים בני אדם לתחייה? ");
INSERT INTO heblb_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","”גם אני חשבתי בעבר שחובתי להציק ולהזיק למאמינים בישוע מנצרת. ");
INSERT INTO heblb_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","אסרתי רבים מהקדושים בירושלים, ואף קיבלתי מראשי הכוהנים רשות בכתב לעשות זאת. וכאשר נידונו הקדושים למוות, נתתי את הסכמתי המלאה. ");
INSERT INTO heblb_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","פעמים רבות עברתי מבית־כנסת אחד לשני, ותחת עינויים אילצתי את המאמינים המשיחיים לגדף את המשיח. למעשה התנגדתי להם בחריפות שכזאת, עד שרדפתי אותם גם בחוץ לארץ. ");
INSERT INTO heblb_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","”יום אחד יצאתי לדמשק, בסמכותם של הכוהנים ועם ברכתם, כדי לאסור את המאמינים המשיחיים. ");
INSERT INTO heblb_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","בצהרי היום, אדוני המלך, זרח לפתע אור בהיר יותר מזוהר השמש והציף אותי ואת מלווי. ");
INSERT INTO heblb_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","כולנו נפלנו ארצה, ואני שמעתי קול מדבר אלי: ’שאול, שאול, מדוע אתה רודף אותי? קשה לך לבעוט בדרבנות!‘ ");
INSERT INTO heblb_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","” ’מי אתה, אדוני?‘ שאלתי. ”והקול ענה: ’אני ישוע שאותו אתה רודף! ");
INSERT INTO heblb_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","עתה קום על רגליך, כי נגליתי אליך כדי למנותך להיות לי למשרת ועד. עליך לספר לעולם כולו את אשר ראית היום ואת אשר אראה לך בעתיד. ");
INSERT INTO heblb_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","אני אגן עליך מפני בני עמך ומפני הגויים. כן, אשלח אותך אל הגויים, ");
INSERT INTO heblb_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","כדי שתפקח את עיניהם לראות את מצבם האמיתי, כך שיחזרו בתשובה ויחיו באור האלוהים, ולא בחשכת השטן. לשם מה? כדי שאלוהים יסלח לחטאיהם, וייתן להם נחלה יחד עם שאר בני־האדם שטוהרו מחטאיהם והוקדשו לי באמונה‘. ");
INSERT INTO heblb_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","”וכך, המלך אגריפס, לא התמרדתי נגד החיזיון הזה מן השמים. ");
INSERT INTO heblb_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","תחילה בישרתי את הדבר לאנשי דמשק, לאחר מכן בירושלים ובכל יהודה, ואחר כך גם לגויים. קראתי לכל בני־האדם לזנוח את חטאיהם, לשוב אל אלוהים ולהוכיח את חרטת לבם במעשים טובים. ");
INSERT INTO heblb_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","מסיבה זאת עצרו אותי היהודים בבית־המקדש וניסו להרוג אותי. ");
INSERT INTO heblb_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","אולם ה׳ הגן עלי, והיום אני עדיין חי ויכול לספר עובדות אלה לכולם – לקטנים ולגדולים. אני מלמד אך ורק את דבריהם של משה רבנו ושל הנביאים: ");
INSERT INTO heblb_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","שהמשיח יסבול ושיהיה הראשון אשר יקום מן המתים, כדי להביא אור ליהודים ולגויים כאחד.“ ");
INSERT INTO heblb_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","לפתע התפרץ פסטוס וקרא: ”פולוס, יצאת מדעתך! לימודיך הממושכים בלבלו את דעתך.“ ");
INSERT INTO heblb_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","”לא יצאתי מדעתי, פסטוס הנכבד“, השיב פולוס. ”אני מדבר דברי אמת מפוכחים. ");
INSERT INTO heblb_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","המלך אגריפס יודע היטב את כל הדברים האלה. אני מעז לדבר בכנות, כי אני בטוח שהמלך מכיר ויודע את כל המאורעות האלה; הרי הם לא התרחשו בסתר! ");
INSERT INTO heblb_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","המלך אגריפס, האם אתה מאמין לדברי הנביאים? אני יודע שכן…“ ");
INSERT INTO heblb_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","אך אגריפס שיסע את דבריו של פולוס: ”כמעט שכנעת אותי להאמין שישוע הוא המשיח!“ ");
INSERT INTO heblb_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","ופולוס השיב: ”אני מקווה ומתפלל לאלוהים שבמוקדם או במאוחר אתה וכל הנוכחים כאן תהיו כמוני… אך בלי האזיקים, כמובן!“ ");
INSERT INTO heblb_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","המלך, המושל, ברניקה וכל האחרים קמו ");
INSERT INTO heblb_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","ויצאו מהאולם. כששבו ודנו בעניינו של פולוס מאוחר יותר, החליטו: ”איש זה אינו אשם בשום פשע שדינו מאסר או מוות.“ ");
INSERT INTO heblb_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","”אלמלא דרש לערער לפני הקיסר,“ אמר אגריפס לפסטוס, ”אפשר היה לשחרר אותו.“ ");
INSERT INTO heblb_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","כאשר הוחלט שעלינו להפליג לרומא, נמסרו פולוס ועוד מספר אסירים להשגחתו של קצין בשם יוליוס, שהשתייך לגדוד הקיסר. ");
INSERT INTO heblb_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","עלינו על אונייה אדרמיטית שעמדה להפליג למספר נמלים לאורך חוף אסיה. ברצוני לציין שגם אריסטרכוס המקדוני מתסלוניקי היה איתנו. ");
INSERT INTO heblb_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","כשהגענו למחרת לצידון גילה יוליוס נדיבות־לב כלפי פולוס, והרשה לו לרדת לחוף ולבקר את ידידיו, כדי שיספקו לו את צרכיו. ");
INSERT INTO heblb_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","כשהפלגנו מצידון נשבה לנגדנו רוח חזקה, אשר אילצה אותנו לסטות מדרכנו ולהפליג צפונית לקפריסין, בין האי ובין היבשה. ");
INSERT INTO heblb_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","עברנו לאורך חופי קיליקיה ופמפוליה, והגענו למורא שבלוקיה. ");
INSERT INTO heblb_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","יוליוס הקצין מצא שם ספינה מצרית מאלכסנדריה, שפניה מועדות לאיטליה, והעלה אותנו על סיפונה. ");
INSERT INTO heblb_vpl VALUES ("AC27_7‏","074_27_7‏","ACT","27","7‏","8","לאחר ימים אחדים של טלטולים והפלגה איטית ומייגעת בים הסוער התקרבנו לקנידוס, אולם הרוחות החזקות אילצו אותנו להמשיך לכרתים ולחלוף על־פני הר סלמוני. בקושי רב נאבקנו נגד הרוחות העזות, והתקדמנו באיטיות רבה לאורך החוף הדרומי, עד שהגענו לנמל הבטוח קלילמנס שליד העיר לסיה. ");
INSERT INTO heblb_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","בינתיים איבדנו זמן רב, ומכיוון שהגיע הסתיו היה מזג אוויר סוער, והפלגות ארוכות היו בחזקת סכנה ליורדי הים. פולוס שוחח על כך עם קברניטי הספינה. ");
INSERT INTO heblb_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","”רבותי,“ פתח פולוס, ”אני רואה שאם נמשיך עתה בדרכנו, צפויה לנו סכנה גדולה ונאבד לא רק את המטען ואת האונייה, אלא גם את חיינו!“ ");
INSERT INTO heblb_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","אולם קציני המשמר העדיפו לקבל את עצתם של רב־החובל ושל בעל האונייה על פני עצתו של פולוס. ");
INSERT INTO heblb_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","מאחר שנמל קלילמנס היה חשוף לרוחות ולא התאים לעגינה בימי החורף, הציע צוות האונייה להמשיך לחוף פניקס, כדי לבלות שם את החורף. פניקס היה נמל טוב באי כרתים, אשר פנה לדרום־מערב ולצפון־מערב בלבד. ");
INSERT INTO heblb_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","באותה שעה החלה לנשוב רוח דרומית קלה, ומזג האוויר נראה מתאים בהחלט להפלגה. על כן הם הרימו עוגן והפליגו לאורך החוף. ");
INSERT INTO heblb_vpl VALUES ("AC27_14‏","074_27_14‏","ACT","27","14‏","15","אולם כעבור זמן קצר השתנה לפתע מזג האוויר ופרצה סופה עזה (סופת אירוקלידון – רוח צפונית־מזרחית), שטלטלה את האונייה וסחפה אותה ללב הים. תחילה ניסו המלחים לחתור לחוף, אבל מאחר שכל מאמציהם עלו בתוהו, ויתרו על הרעיון והניחו לספינה להיסחף ברוח. ");
INSERT INTO heblb_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","בסופו של דבר נסחפנו אל אי קטן בשם קודה, ושם, לאחר עמל רב, עלה בידנו להעלות על הסיפון את סירת־ההצלה שנגררה מאחורינו. ");
INSERT INTO heblb_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","לאחר מכן קשרנו חבלים סביב הספינה כדי לחזק את דופנותיה. המלחים פחדו שמא תסחוף אותם הרוח אל החולות הטובעניים של חופי אפריקה, ולכן הנמיכו את המפרשים העליונים והניחו לרוח לסחוף את הספינה. ");
INSERT INTO heblb_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","למחרת הלכו הגלים והתחזקו, והצוות החל להשליך את המטען אל הים. ");
INSERT INTO heblb_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","ביום השלישי השליכו המלחים מהסיפון את כל הציוד של האונייה וכל חפץ שנמצא בה. ");
INSERT INTO heblb_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","סופה נוראה זאת השתוללה ימים רבים ללא מעצור, וכל אותו זמן לא ראינו את השמש, הירח או הכוכבים, עד אשר אפסה כל תקווה להינצל. ");
INSERT INTO heblb_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","איש מאיתנו לא אכל דבר מזה זמן רב, עד שלבסוף כינס פולוס את הצוות ואמר: ”רבותי, אילו שמעתם בקולי ולא עזבתם את החוף הנוח בכרתים, הייתם חוסכים לכם אבדן ציוד ונזקים חמורים אחרים. ");
INSERT INTO heblb_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","אך התעודדו! האונייה אמנם תטבע, אולם איש מכם לא יאבד את חייו. ");
INSERT INTO heblb_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","”בלילה אמש נגלה אלי מלאכו של האלוהים, אשר אותו אני עובד ולו אני שייך, ");
INSERT INTO heblb_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","ואמר: ’אל תירא, פולוס; אתה תזכה לעמוד למשפט לפני הקיסר! נוסף על כך, אלוהים נענה לבקשתך ויציל את חייהם של כל הנוסעים איתך בספינה‘. ");
INSERT INTO heblb_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","התעודדו, אפוא כולכם, כי אני בוטח באלוהים ואין לי ספק שיקיים את דבריו! ");
INSERT INTO heblb_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","אולם ספינתנו תתנפץ אל אחד האיים.“ ");
INSERT INTO heblb_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","בחצות הלילה הארבעה־עשר לסערה, לאחר טלטולים מייגעים בים האדריאטי, גילו המלחים יבשה באופק. ");
INSERT INTO heblb_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","הם הורידו אנך וגילו שעומק המים תחתם היה כ־36 מטר. כעבור זמן קצר שבו והורידו את האנך, והפעם היה עומק המים 27 מטר בלבד. ");
INSERT INTO heblb_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","הם ידעו שעד מהרה נגיע לחוף, ומכיוון שחששו שמא תתנפץ הספינה לסלעים, השליכו ארבעה עוגנים מירכתי הספינה וציפו בקוצר רוח לאור היום. ");
INSERT INTO heblb_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","מלחים אחדים ניסו לברוח מהספינה; הם הורידו את סירת ההצלה אל המים, והעמידו פנים כאילו יש בדעתם להוריד עוגנים גם מהחרטום. ");
INSERT INTO heblb_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","אולם פולוס הזהיר את החיילים ואת הקצין האחראי: ”אם המלחים האלה לא יישארו על הסיפון תמותו כולכם.“ ");
INSERT INTO heblb_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","משום כך ניתקו החיילים את חבלי הסירה והניחו לה להיסחף בים. ");
INSERT INTO heblb_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","בטרם עלה השחר ביקש פולוס מכולם לאכול. ”במשך השבועיים האחרונים לא טעמתם דבר.“ אמר להם. ");
INSERT INTO heblb_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","”אנא, אכלו משהו כי עליכם להתחזק. אני מבטיח לכם שלא תיפול שערה אחת מראשכם ארצה!“ ");
INSERT INTO heblb_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","פולוס לקח פרוסת לחם יבשה, הודה לה׳ לפני כולם, שבר חתיכה מהלחם היבש ואכל אותה. ");
INSERT INTO heblb_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","לפתע חשו כולם בטוב, וגם החלו לאכול. ");
INSERT INTO heblb_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","כולנו יחד מנינו 276 איש. ");
INSERT INTO heblb_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","לאחר שאכלו כולם לשובע הוסיף הצוות להקל על משקל האונייה, והשליך אל הים גם את שקי החיטה. ");
INSERT INTO heblb_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","כשהאיר היום הם הבחינו במפרץ ובחוף, אך לא הצליחו לזהות את המקום. הם תהו אם יעלה בידם לנווט את הספינה בין הסלעים ולהשיטה אל החוף. ");
INSERT INTO heblb_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","הם החליטו לנסות. לאחר שניתקו את העוגנים והשאירו אותם בים, התירו את כבלי ההגה, הרימו את המפרש הקדמי והפליגו לחוף. ");
INSERT INTO heblb_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","אולם הספינה עלתה על שרטון ונתקעה במקומה. החרטום הלך ושקע, והירכתיים, שהיו חשופים לנחשולים, החלו להתפרק. ");
INSERT INTO heblb_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","החיילים הציעו לקצין המשמר להרוג את האסירים, כדי שאיש מהם לא יוכל לשחות אל החוף ולהימלט. ");
INSERT INTO heblb_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","אולם יוליוס רצה להציל את פולוס, ולכן לא קיבל את הצעתם. ”מי שיודע לשחות – שישחה אל החוף!“ פקד יוליוס. ");
INSERT INTO heblb_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","”מי שאינו יודע לשחות – שיאחז בקרשים ובשברי האונייה ויחתור אל היבשה!“ וכך הגענו כולנו אל החוף בשלום. ");
INSERT INTO heblb_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","עד מהרה גילינו שאנו על האי מלטה. ");
INSERT INTO heblb_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","תושבי המקום נהגו בנו בטוב־לב ראוי לציון, והבעירו מדורה כדי לחמם אותנו בקור העז ובגשם הסוחף. ");
INSERT INTO heblb_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","פולוס קושש ענפים וזרדים יבשים, והשליך אותם אל תוך המדורה. לפתע זינק על זרועו נחש ארסי שביקש מפלט מהחום. ");
INSERT INTO heblb_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","כשראו אנשי האי את הנחש התלוי על זרועו, אמרו זה לזה: ”הוא בטח רוצח! הוא אמנם ניצל מן הים, אולם הצדק לא יניח לו לחיות!“ ");
INSERT INTO heblb_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","אך פולוס ניער את הנחש אל תוך האש, והוא עצמו כלל לא נפגע. ");
INSERT INTO heblb_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","האנשים הביטו בו בדריכות וציפו לראות את גופו מתנפח או נופל מת. אולם לאחר שחיכו זמן רב ולא קרה דבר, שינו את דעתם והחליטו שפולוס הוא ודאי אל! ");
INSERT INTO heblb_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","אחוזתו של פובליוס, מושל האי, הייתה בקרבת החוף. הוא הזמין אותנו לביתו ואירח אותנו שלושה ימים. ");
INSERT INTO heblb_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","באותה עת היה אביו של פובליוס חולה מאוד – הייתה לו דיזנטריה והוא קדח מחום. פולוס הלך לחדרו של החולה, התפלל בעדו, סמך את ידיו עליו, והאיש נרפא. ");
INSERT INTO heblb_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","לאחר מכן באו שאר חולי האי אל פולוס, וגם הם נרפאו. ");
INSERT INTO heblb_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","התושבים היו אסירי תודה והציפו אותנו במתנות הוקרה. כאשר הגיע מועד הפלגתנו, הם מילאו את האונייה באוכל ובציוד. ");
INSERT INTO heblb_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","שלושה חודשים לאחר שעלתה ספינתנו על שירטון עלינו על אונייה אחרת והמשכנו בדרכנו. הפעם הפלגנו באונייה ”התאומים“, שבאה מאלכסנדריה ועגנה באי מלטה במשך החורף. ");
INSERT INTO heblb_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","תחנתנו הראשונה הייתה סירקוז, שם נשארנו שלושה ימים. ");
INSERT INTO heblb_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","מסירקוז הפלגנו לרגיום. כעבור יום החלה לנשוב רוח דרומית, וביום השני הגענו לפוטיולי. ");
INSERT INTO heblb_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","בפוטיולי פגשנו לבסוף מאמינים. הם הפצירו בנו להישאר איתם שבוע ימים, ומשם הפלגנו לרומא. ");
INSERT INTO heblb_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","כאשר שמעו האחים ברומא על דבר בואנו, נסעו מרחק רב מחוץ לעירם כדי לקבל את פנינו. חלקם חיכו לנו בכיכר אפיוס (כשישים ושמונה ק״מ מרומא), וחלקם הצטרפו אלינו ב”שלושת הפונדקים“ (כ־חמישים וחמישה ק״מ מרומא). כשפולוס ראה אותם הוא התעודד מאוד והודה לה׳. ");
INSERT INTO heblb_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","בהגיעם לרומא הורשה פולוס לגור בכל מקום שרצה, אם כי תמיד נלווה אליו חייל. ");
INSERT INTO heblb_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","כעבור שלושה ימים כינס פולוס את מנהיגי היהודים המקומיים, ואמר להם: ”היהודים בירושלים אסרו אותי ומסרו אותי לידי הממשל הרומאי, למרות שלא פגעתי באיש ולא עברתי על חוקי אבותינו. ");
INSERT INTO heblb_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","הרומאים ערכו לי משפט ורצו לשחרר אותי, מכיוון שלא מצאו כל סיבה לדון אותי למוות, כפי שדרשו היהודים. ");
INSERT INTO heblb_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","אולם מאחר שהיהודים מחו נגד ההחלטה, מצאתי לנחוץ לערער לפני הקיסר, למרות שלא רציתי לתבוע את עמי. ");
INSERT INTO heblb_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","ביקשתי מכם לבוא הנה היום כדי שנכיר זה את זה, וכדי שאוכל לומר לכם שאני אסור באזיקים אלה רק משום שאני מאמין שהמשיח כבר בא!“ ");
INSERT INTO heblb_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","”לא שמענו עליך שום דבר רע.“ ענו מנהיגי היהודים. ”לא קיבלנו מכתבים מיהודה, ולא שמענו דיווחים מפי הבאים לכאן מירושלים. ");
INSERT INTO heblb_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","אולם אנחנו רוצים לשמוע במה אתה מאמין, כי הדבר היחיד שאנו יודעים על המשיחיים האלה הוא שבכל מקום מתנגדים לכת הזאת.“ ");
INSERT INTO heblb_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","הם קבעו מועד לפגישתם הבאה, ובאותו יום התאסף קהל רב ליד ביתו של פולוס. הוא סיפר להם על מלכות האלוהים, ולימד אותם על אודות ישוע מתוך כתבי־הקודש – מהתורה ומהנביאים. הוא החל ללמד אותם בבוקר, ולא הפסיק עד הערב. ");
INSERT INTO heblb_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","אחדים האמינו לדבריו, ואחרים לא האמינו. ");
INSERT INTO heblb_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","לאחר שהתווכחו בינם לבין עצמם, הם עזבו את המקום כשדבריו של פולוס מהדהדים באוזניהם: ”רוח הקודש צדק כששם דברים אלה בפי ישעיהו הנביא: ");
INSERT INTO heblb_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","’לך ואמרת לעם הזה: שמעו שמוע ואל תבינו, וראו ראו ואל תדעו; ");
INSERT INTO heblb_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","השמן לב העם הזה ואזניו הכבד ועיניו השע, פן יראה בעיניו ובאזניו ישמע, ולבבו יבין ושב ורפא לו‘. ");
INSERT INTO heblb_vpl VALUES ("AC28_28‏","074_28_28‏","ACT","28","28‏","29","משום כך אני רוצה שתדעו כי ישועה זאת מוצעת גם לגויים, והם ישמעו.“ ");
INSERT INTO heblb_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","במשך השנתיים הבאות התגורר פולוס בבית ששכר לעצמו, וקיבל בברכה את כל מי שבא לבקרו. ");
INSERT INTO heblb_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","הוא בישר באומץ את דבר מלכות האלוהים, לימד על אודות האדון ישוע המשיח, ואיש לא ניסה להפריע לו.");
INSERT INTO heblb_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","מאת פולוס, עבדו של ישוע המשיח, אשר נקרא להיות שליח והוקדש להפצת בשורת אלוהים. ");
INSERT INTO heblb_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","אלוהים הבטיח לנו בשורה זאת לפני זמן רב באמצעות נביאיו בכתבי־הקודש. ");
INSERT INTO heblb_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","היא מספרת לנו על אודות בנו, ישוע המשיח אדוננו, אשר בא לעולם בדמות אדם משושלת דוד המלך, ");
INSERT INTO heblb_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","ואשר קם מן המתים על ידי רוח הקודש והוכח להיות בן האלוהים. הוא ישוע המשיח האדון. ");
INSERT INTO heblb_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","באמצעות המשיח העניק לנו אלוהים, חוטאים שכמונו, את טובו וחסדו, ועתה הוא שולח אותנו לספר לכל האנשים בעולם את המעשים הנפלאים שעשה ה׳ למענם, כדי שגם הם יאמינו בו ויצייתו לו. ");
INSERT INTO heblb_vpl VALUES ("RM1_6‏","075_1_6‏","ROM","1","6‏","7","ידידים יקרים ברומא, גם אתם נמנים עם אלה שאלוהים אוהב; ישוע המשיח קרא גם לכם להשתייך לאלוהים ולהקדיש לו את חייכם. יברך אתכם האלוהים אבינו וישוע המשיח אדוננו בחסד ובשלום. ");
INSERT INTO heblb_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","ראשית כל ברצוני לומר לכם כי השמועה על אמונתכם הנפלאה באלוהים מתפשטת בכל העולם, ועל־ידי ישוע המשיח אני מודה לאלוהים על כולכם. ");
INSERT INTO heblb_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","אלוהים יודע שיומם ולילה אני מתפלל בעדכם ומזכיר אתכם לפני האלוהים, אשר אותו אני עובד בכל כוחי בזמן שאני מבשר את הבשורה על אודות בנו. ");
INSERT INTO heblb_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","בתפילותיי אני מתחנן לאלוהים שיאפשר לי לבוא אליכם סוף־סוף, ");
INSERT INTO heblb_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","כי אני משתוקק מאוד לראותכם ולהעניק לכם מתנה רוחנית כדי לחזק אתכם. ");
INSERT INTO heblb_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","כלומר, אני משתוקק להיות בחברתכם, כדי שאמונתכם תעודד אותי ואמונתי תעודד אתכם. ");
INSERT INTO heblb_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","אחים יקרים, דעו לכם כי פעמים רבות תכננתי לבוא אליכם, כדי שגם בקרבכם אוכל לעשות פרי, כשם שעשיתי בקרב עמים אחרים, אולם עד כה תוכנית זאת לא יצאה לפועל. ");
INSERT INTO heblb_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","אני חש מעין חובה לבשר את דבר האלוהים לכל העולם – לאנשי תרבות ולחסרי תרבות; למשכילים ולחסרי השכלה – ללא הפליה. ");
INSERT INTO heblb_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","משום כך, אנשי רומא, אני רוצה לספר את הבשורה גם לכם. ");
INSERT INTO heblb_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","איני מתבייש בבשורת האלוהים! בכוחה להושיע את כל המאמינים בה – קודם כל את היהודי, ואחר כך גם את מי שאינו יהודי. ");
INSERT INTO heblb_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","כי הבשורה מגלה כיצד מצדיק אלוהים את בני־האדם: על־ידי אמונה בלבד, כפי שכתוב: ”צדיק באמונתו יחיה“. כלומר, הצדיק ייוושע ויחיה על־ידי אמונתו באלוהים. ");
INSERT INTO heblb_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","מאידך, אלוהים שפך את זעמו וכעסו על כל הרשעים העוצרים ומסתירים את האמת במעשי הרשע שלהם. ");
INSERT INTO heblb_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","מדוע שפך עליהם אלוהים את זעמו? מפני שהם יודעים היטב את האמת! אלוהים עצמו גילה להם את כל מה שעליהם לדעת. ");
INSERT INTO heblb_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","מבריאת העולם חזו בני־האדם בשמים, בארץ ובכל בריאת ה׳; הם ידעו על קיומו ועל גבורתו הנצחית. משום כך, (כשיעמדו לפני אלוהים ביום הדין), לא יוכלו לתרץ את התנהגותם. ");
INSERT INTO heblb_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","כי למרות שידעו והכירו את האלוהים, לא כיבדוהו בכבוד המגיע לו, וגם לא הודו לו על כל מה שעשה למענם. לעומת זאת הם העסיקו את מוחם בדברי שטות והבל, עד כי מוחם שקע בבלבול ובטמטום. ");
INSERT INTO heblb_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","מאחורי חכמתם המדומה מסתתרת טיפשות! ");
INSERT INTO heblb_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","במקום שיכבדו וישרתו את האלוהים החי והקיים, הם עשו לעצמם אלילים מעץ ומאבן, בדמות בני־אדם, עופות, חיות ורמשים. ");
INSERT INTO heblb_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","על כן מסר אותם אלוהים למעשי הטומאה שלהם; הוא הניח להם להמשיך במעשי התועבה והזנות ולחלל איש את גוף חברו. ");
INSERT INTO heblb_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","בכוונה תחילה הם העדיפו להאמין בשקרים במקום באמת אלוהים; הם התפללו לבריאה, אך לא צייתו לאלוהים המבורך אשר ברא את הכול. ");
INSERT INTO heblb_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","משום כך מסר אותם אלוהים לתאוותיהם, עד כי אף נשותיהם סטו מיחסי־מין נורמאליים וקיימו יחסים בלתי־נורמאליים עם בנות מינן. ");
INSERT INTO heblb_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","גם הגברים סטו מהיחסים הנורמאליים והטבעיים וקיימו יחסים בלתי טבעיים עם גברים אחרים. כתוצאה מכך הם נענשו בתוך עצמם בעונש המגיע להם. ");
INSERT INTO heblb_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","כאשר לא מצאו לנכון להכיר באלוהים, הוא הניח להם להשתעבד לכל מעשי התועבה שהעלו בדעתם. ");
INSERT INTO heblb_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","חייהם מלאו בכל מיני מעשי זנות, רשע, בצע, שנאה, קנאה, רצח, מריבה, מרמה ומרירות. הם נהיו רכלנים ");
INSERT INTO heblb_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","ומלשינים, שונאי אלוהים, חוצפנים וגאוותנים, יוזמי רשע ומורדים בהוריהם. ");
INSERT INTO heblb_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","הם מתנהגים בטיפשות, בחוסר אמונה, ברשעות ובאכזריות, ומלאי שנאה וטינה. ");
INSERT INTO heblb_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","הרשעים האלה ידעו היטב כי אלוהים יעניש עונש מוות את כל הנוהגים כך, אולם לא זו בלבד שלא היטיבו את דרכם, הם גם מעודדים את כל מי שעושה כמוהם! ");
INSERT INTO heblb_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","אולי תאמר: ”אילו הם אנשים רשעים!“ אך דע לך שאינך טוב מהם! באמירתך כי הם רשעים וכי יש להענישם, אתה שופט למעשה את עצמך, שכן אתה עושה בדיוק אותם מעשים. ");
INSERT INTO heblb_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","ואנחנו יודעים שאלוהים מעניש בצדק את העושים מעשי תועבה כאלה. ");
INSERT INTO heblb_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","הסבור אתה שבעשותך מעשי תועבה כמוהם, אלוהים ישפוט וירשיע את האחרים ויניח לך? ");
INSERT INTO heblb_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","האם אתה לא רואה עד כמה אלוהים טוב, אורך רוח וסבלני איתך? האם אתה לא רואה שהטוב הזה מיועד להסב אותך מהחטא? ");
INSERT INTO heblb_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","דע לך כי בעקשנותך ובסירובך להפסיק לחטוא ולחזור בתשובה, אתה צובר לך עונש נורא ליום־הדין – היום שבו ישפוט אלוהים בצדק את העולם כולו. ");
INSERT INTO heblb_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","ביום זה ישלם אלוהים לכל איש את המגיע לו לפי מעשיו: ");
INSERT INTO heblb_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","אלה המשתדלים לעשות מעשים טובים, המצייתים לאלוהים והשואפים לכבוד והדר שלא מן העולם הזה, יזכו בחיי נצח. ");
INSERT INTO heblb_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","ואילו הרשעים אשר מורדים בה׳ ואינם מצייתים לו, יקבלו עונש נורא. ");
INSERT INTO heblb_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","צער וסבל יבואו על כל העושים מעשי חטא ועוול: על היהודי בראשונה, וגם על ה”גוי“. ");
INSERT INTO heblb_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","לעומת זאת, כל אלה שיצייתו לאלוהים ויעשו מעשים טובים יזכו לכבוד, להדר ולשלום מאת האלוהים – היהודי בראשונה, וגם הגוי. ");
INSERT INTO heblb_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","כי אלוהים אינו מפלה בין בני־האדם. ");
INSERT INTO heblb_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","אלוהים יעניש את כל החוטאים! אלה שחטאו בלי שהכירו את התורה ייענשו גם בלי להתחשב בתורה; אלה שהכירו את התורה וחטאו, יישפטו וייענשו על־פי התורה. ");
INSERT INTO heblb_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","שהרי אלוהים אינו מצדיק את אלה שמכירים את התורה, כי אם את אלה שמקיימים אותה הלכה למעשה. ");
INSERT INTO heblb_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","כאשר הגויים, שאין להם את התורה, מקיימים את עיקר חוקיה מתוך חוש טבעי, הרי שחוש זה הוא תורתם ולפיו הם יישפטו. ");
INSERT INTO heblb_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","התנהגותם מוכיחה שדרישות התורה כתובות למעשה על לבם; מצפונם אומר להם מה מותר ומה אסור, ומחשבותיהם מצדיקות או מאשימות אותם. ");
INSERT INTO heblb_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","הם יישפטו ביום־הדין – היום שבו ישפוט אלוהים, באמצעות המשיח, את הצד הנסתר בחייו של כל אדם. זהו חלק מתוכניתו של ה׳ שאותה אני מבשר. ");
INSERT INTO heblb_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","אתם, היהודים, מתגאים שאתם ידידיו הנבחרים של אלוהים; אתם חושבים שהואיל ונתן לכם את תורתו, הכול כשורה ביניכם לבינו. ");
INSERT INTO heblb_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","אתם יודעים מהו רצונו של אלוהים; אתם יודעים להבחין בין טוב לרע, שכן למדתם את תורתו עוד לפני זמן רב. ");
INSERT INTO heblb_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","אתם משוכנעים שהנכם מוכשרים וראויים ללמד את אלה שאינם יודעים את הדרך לה׳, ולשמש כלפידי אור המדריכים אל ה׳ את אלה שתעו בחשכה. ");
INSERT INTO heblb_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","אתם משוכנעים שהנכם מוכשרים ללמד את הבורים, את התמימים ואת הילדים, שכן אתם מכירים את תורת ה׳. ");
INSERT INTO heblb_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","אבל אתם המוכנים תמיד ללמד את האחרים – מדוע אינכם מלמדים את עצמכם? אתם מצווים על אחרים לא לגנוב – האם אתם בעצמכם נקיי כפיים? ");
INSERT INTO heblb_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","אתם מצווים על אחרים לא לנאוף – האם אינכם נואפים בעצמכם? אתם מתנגדים לעבודת האלילים – האם אינכם גוזלים את כלי הקדושה שלהם? ");
INSERT INTO heblb_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","אתם גאים בעובדת ידיעתכם את תורת אלוהים, אך באי־קיימכם את מצוותיו אתם מבזים למעשה את אלוהים. ");
INSERT INTO heblb_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","אין פלא שכתבי־הקודש אומרים: ”בגללכם שם אלהים מחולל בגוים“! ");
INSERT INTO heblb_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","לברית־המילה יש ערך ומשמעות רק אם אתה שומר את מצוות ה׳. אם אינך שומר את מצוות ה׳, אינך טוב מהגויים. ");
INSERT INTO heblb_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","ואם גוי, שלא נימול, ישמור את מצוות ה׳, האם לא יעניק לו אלוהים את הזכויות שהתכוון להעניק ליהודים? ");
INSERT INTO heblb_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","למעשה, הגוי המקיים את התורה הוא שישפוט אותך, היהודי, למרות שנמולת ושניתנה לך תורת ה׳ שאותה הפרת. ");
INSERT INTO heblb_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","הרי אינך יהודי אמיתי רק משום שנולדת להורים יהודים, או משום שנמולת. ");
INSERT INTO heblb_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","יהודי אמיתי הוא זה שאוהב את ה׳. כי אלוהים אינו מעוניין באלה שכל יהדותם מסתכמת בקיום ברית־המילה בלבד, כי אם באלה שלבם וחייהם השתנו, ולאלה הוא יעניק כבוד ושבח לא בעיני בני אדם, כי אם בעיני אלוהים. ");
INSERT INTO heblb_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","אם כן, מהו יתרונו של היהודי? ומה יתרונה של המילה? ");
INSERT INTO heblb_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","יש יתרון רב בכל דרך. ראשית כל, אלוהים הפקיד את דברו הכתוב בידי היהודים. ");
INSERT INTO heblb_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","אמנם חלק מהם לא האמין, אך האם אתם חושבים כי משום שהיהודים הפרו את הבטחתם לאלוהים, יפר אלוהים את הבטחותיו להם? ");
INSERT INTO heblb_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","חלילה! גם אם כל בני האדם משקרים, אלוהים נאמן ודובר אמת! הרי כתוב בתהלים שדברי אלוהים הם דברי אמת, ומשפטו תמיד משפט צדק. ");
INSERT INTO heblb_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","אך אם הרשעות שלנו מבליטה ומדגישה את טובו של ה׳, האם נאמר שאלוהים גורם לנו עוול בהענישו אותנו? (יש אנשים החושבים כך!) ");
INSERT INTO heblb_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","חלילה! אם אלוהים יתעלם מחטא, כיצד יוכל לשפוט את העולם? ");
INSERT INTO heblb_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","אנו כאילו אומרים, שאם על־ידי השקרים שלנו יוצאת אמת אלוהים לאור וגדל כבודו, מדוע עלינו להישפט כחוטאים? ");
INSERT INTO heblb_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","אם־כך, מדוע שלא נרבה לעשות מעשים רעים כדי שתצא מהם טובה? (שונאינו העלילו עלינו שכך אמרנו!) אמרו אתם, האין זה צודק להרשיע ולהעניש את אלה האומרים זאת? ");
INSERT INTO heblb_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","אם כן, האם היהודים טובים מהגויים? כלל לא. כבר הוכחנו שכל בני־האדם חוטאים – יהודים וגויים ללא הבדל. ");
INSERT INTO heblb_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","כפי שכתוב בתהלים ”אין עושה טוב, אין גם אחד. אין אף צדיק! ");
INSERT INTO heblb_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","אין משכיל, אין דורש את אלוהים; ");
INSERT INTO heblb_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","הכול סר יחדיו נאלחו. אין עושה טוב, אין גם אחד. ");
INSERT INTO heblb_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","גרונם כקבר פתוח, פיהם מלוכלך ומלא שקר ולשונם נוטפת ארס. ");
INSERT INTO heblb_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","כן, הם מנבלים את פיהם, ");
INSERT INTO heblb_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","צמאי דם וחמי מזג. ");
INSERT INTO heblb_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","לכל מקום שהם הולכים הם מותירים אחריהם סבל וצער. ");
INSERT INTO heblb_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","הם מעולם לא התנסו בתחושת השלום והשלווה שאלוהים לבדו מעניק. ");
INSERT INTO heblb_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","אין הם מקדישים לאלוהים כל מחשבה, ולא אכפת להם מה הוא חושב עליהם.“ ");
INSERT INTO heblb_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","אנחנו יודעים כי דברי התורה מכוונים אל אלה הכפופים לה – היהודים – ואלוהים ישפוט ויעניש אותם, שכן עליהם לשמור את מצוותיו ולא להתנהג בצורה כזאת. לאיש מהם אין תירוץ! למעשה, העולם כולו עומד אשם לפני אלוהים. ");
INSERT INTO heblb_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","שהרי איש לא יצדק לפני אלוהים בזכות קיום התורה, מכיוון שחוקי התורה מצביעים על חטאינו ומראים לנו שאנו חוטאים. ");
INSERT INTO heblb_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","עתה נתגלה האופן שבו מצדיק ה׳ את האדם ללא התורה, אם כי התורה והנביאים כבר העידו על כך. ");
INSERT INTO heblb_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","צידוק זה ניתן לכל המאמינים בישוע המשיח, ללא הפליה. ");
INSERT INTO heblb_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","כי כל בני־האדם חטאו, וכולם חסרי כבוד אלוהים. ");
INSERT INTO heblb_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","בכל זאת, אלוהים הצדיק אותנו בחסדו חינם, על־ידי קורבנו של ישוע המשיח שהוקרב למעננו. ");
INSERT INTO heblb_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","אלוהים שלח את המשיח לשאת את העונש על חטאינו, כדי שעל־ידי אמונה בדמו, הוא יהיה כפרתנו – כלומר, יכפר על חטאינו. וכל זאת כדי להראות לנו את צדקתו, לאחר שברחמיו הרבים מחק את חטאי העבר. ");
INSERT INTO heblb_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","במעשה זה רצה אלוהים לגלות לנו את צדקתו – את סליחתו לחוטאים – ולהוכיח כי הוא עצמו צדיק, וכי הוא מצדיק את כל המאמין בישוע המשיח בנו. ");
INSERT INTO heblb_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","ובכן, האם יש למישהו סיבה להתגאות? ודאי שלא. מדוע? משום שאלוהים זיכה והצדיק אותנו בזכות קרבנו של המשיח ואמונתנו בו, ולא בזכות מעשינו הטובים. ");
INSERT INTO heblb_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","לפיכך אנו מסיקים שאדם נצדק לפני אלוהים על־ידי אמונתו בישוע המשיח בן־האלוהים, ולא על־ידי הישגיו בקיום מצוות התורה. ");
INSERT INTO heblb_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","החושבים אתם שאלוהים הוא אלוהי היהודים בלבד, ורק אותם הוא מושיע? ודאי שלא! אלוהים הוא גם אלוהי הגויים. ");
INSERT INTO heblb_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","ומכיוון שאלוהי היהודים הוא גם אלוהי הגויים, הוא מצדיק את כולנו על־ידי האמונה. ");
INSERT INTO heblb_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","האם בהדגישנו את חשיבות האמונה מבטלים אנו את התורה? חס וחלילה! למעשה אנחנו מקיימים אותה – דבר האפשרי רק על־ידי אמונה במשיח. ");
INSERT INTO heblb_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","אם כך, מה נאמר על אברהם אבינו, מה הוא השיג? ");
INSERT INTO heblb_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","אילו נצדק אברהם בזכות מעשיו הטובים, אזי הייתה לו סיבה להתפאר, אך לא לפני אלוהים! ");
INSERT INTO heblb_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","כי הכתובים אומרים לנו: שאברהם האמין באלוהים, ומשום כך אלוהים ”יחשבה לו צדקה.“ ");
INSERT INTO heblb_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","שכרו של העובד אינו תלוי בחסדו של המעביד; זהו חוב המגיע לו. ");
INSERT INTO heblb_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","החסד הוא כשהאדם אינו מסתמך על מעשיו לישועה, כי אם מאמין באלוהים אשר מצדיק את החוטאים וסולח להם, ואמונתו תיחשב לו לצדקה. ");
INSERT INTO heblb_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","גם דוד המלך דיבר על אושרו של האדם אשר אלוהים מצדיקו ללא תלות במעשיו: ");
INSERT INTO heblb_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","”אשרי נשוי פשע כסוי חטאה; ");
INSERT INTO heblb_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","אשרי אדם לא יחשוב ה׳ לו עוון.“ ");
INSERT INTO heblb_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","האם ברכה זאת מיועדת אך ורק לנימולים, או גם לגויים? זכרו כי אברהם התברך בזכות אמונתו באלוהים. ");
INSERT INTO heblb_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","מתי ברך אלוהים את אברהם וחשב את אמונתו לצדקה, לפני שנימול, או לאחר מכן? התשובה היא: לפני שאברהם נימול! ");
INSERT INTO heblb_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","אברהם נימול רק לאחר שאלוהים הבטיח לברכו בזכות אמונתו. ברית־המילה היוותה אות וחותם שלאברהם הייתה אמונה, ושאלוהים הצדיקו וסלח לחטאיו עוד לפני טקס המילה. וכל זאת כדי שאברהם יוכל להיות אביהם הרוחני של כל אלה שיאמינו באלוהים וייוושעו מבלי שיקיימו את חוקי התורה. אנו רואים, אם כן, כי אלוהים מצדיק וסולח חטאים גם לאלה שאינם מקיימים חוקי התורה – בתנאי שהם מאמינים בו. ");
INSERT INTO heblb_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","אברהם הוא אביהם הרוחני גם של היהודים הנימולים, אשר יהדותם אינה מסתכמת במילה בלבד, אלא אשר הולכים בעקבות האמונה שהייתה לאברהם אבינו לפני שנימול. ");
INSERT INTO heblb_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","ה׳ הבטיח לאברהם ולזרעו לרשת את הארץ – לא בזכות קיום התורה (שהרי בימי אברהם טרם ניתנה התורה), אלא בזכות בטחונו ואמונתו בה׳. ");
INSERT INTO heblb_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","אילו רק מקיימי התורה היו היורשים, אזי אין כל ערך לאמונה, והבטחת אלוהים בטלה ומבוטלת. ");
INSERT INTO heblb_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","כי הפרת התורה מביאה בעקבותיה זעם ועונש, ואילו כשאין תורה, אי־אפשר להפר אותה! ");
INSERT INTO heblb_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","משום כך ברכותיו של אלוהים ניתנות לנו במתנה על־ידי אמונה. ברוב חסדו מעניק אלוהים את ברכותיו והבטחותיו לכל צאצאי אברהם – לאלה החיים לפי התורה, ולאלה המאמינים באלוהים כאברהם, שהוא האב הרוחני של כולנו. ");
INSERT INTO heblb_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","זוהי כוונת הכתוב בהבטחת אלוהים לאברהם: ”כי אב המון גוים נתתיך.“ אלוהים קיים את הבטחתו זאת, מפני שאברהם האמין באלוהים המחייה את המתים, והמדבר על העתיד להתרחש בלשון עבר. ");
INSERT INTO heblb_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","כשהבטיח אלוהים לאברהם שייתן לו בן, ולבן שלו יהיו צאצאים רבים אשר יהוו עם גדול, האמין אברהם לה׳ למרות שהבטחה כזאת נראתה לו בלתי־אפשרית. ");
INSERT INTO heblb_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","אמונתו באלוהים לא נחלשה על־אף העובדה ששרה אשתו הייתה כבת תשעים שנה וזקנה מכדי להרות, וגם אברהם עצמו היה זקן מאוד – כבן מאה שנה. ");
INSERT INTO heblb_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","אברהם לא הטיל ספק בהבטחת אלוהים, אלא להיפך – אמונתו ובטחונו באלוהים גדלו והתחזקו, והוא כיבד את אלוהים והלל את שמו. ");
INSERT INTO heblb_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","אברהם ידע בביטחון גמור שאלוהים יכול לקיים את אשר הבטיח, ");
INSERT INTO heblb_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","ובזכות אמונתו אלוהים הצדיק אותו בעיניו. ");
INSERT INTO heblb_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","ה׳ הצדיק את אברהם – כלומר, ניקה וזיכה אותו מכל חטא – לא רק למען אברהם, ");
INSERT INTO heblb_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","אלא גם למעננו! כן, ה׳ יצדיק גם אותנו, כפי שהצדיק את אברהם, כאשר נאמין באלוהים אשר הקים לתחייה את ישוע המשיח אדוננו – ");
INSERT INTO heblb_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","הלא הוא המשיח שהוקרב למוות בגלל מעשינו הרעים, ואשר קם לתחייה מן המתים כדי להצדיקנו ולטהרנו בעיני ה׳. ");
INSERT INTO heblb_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","לכן עתה, לאחר שנסלחו לנו חטאינו והוצדקנו על־ידי האמונה, אנחנו נמצאים בשלום עם אלוהים, בזכות קורבנו של ישוע המשיח אדוננו. ");
INSERT INTO heblb_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","עקב אמונתנו העניק לנו המשיח את כל הזכויות הנפלאות שיש לנו עתה, ואנו שמחים בתקווה שניקח חלק בכבוד אלוהים. ");
INSERT INTO heblb_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","אם באים עלינו קשיים וצרות, אנו יכולים לשמוח ולהודות לאלוהים, כי אנו יודעים שהם מפתחים ומחזקים את סבלנותנו, ");
INSERT INTO heblb_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","הסבלנות מפתחת ומחזקת את אופיינו, ואופי חזק מביא לאמונה יציבה ולתקווה בישועה הנצחית. ");
INSERT INTO heblb_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","תקווה זאת לעולם לא תבייש ולא תאכזב אותנו, שכן אנו יודעים מה רבה אהבת אלוהים אלינו, ואנו מרגישים באהבתו שממלאת אותנו. רוח הקודש הוא שיצק בנו אהבה זאת. ");
INSERT INTO heblb_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","בהיותנו עדיין חלשים וחסרי תושייה, בא המשיח בזמן המתאים ומת בעדנו – הרשעים. ");
INSERT INTO heblb_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","הרי איננו יכולים לצפות מאיש למות אף בעד אדם ישר וצדיק, אולם הבה נאמר שקיימת אפשרות כזאת. ");
INSERT INTO heblb_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","והנה הוכיח אלוהים את אהבתו הגדולה אלינו בשלחו את בנו – את ישוע המשיח – למות בעדנו, כאשר היינו עדיין חוטאים ורשעים. ");
INSERT INTO heblb_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","אם אלוהים עשה כל זאת למעננו עוד בהיותנו חוטאים, עתה, משהוצדקנו בעיניו בזכות דם המשיח שנשפך, אין לנו כל סיבה לפחד מזעמו של אלוהים. ");
INSERT INTO heblb_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","שכן אם בזמן שהיינו אויביו סלח אלוהים לחטאינו וריצה אותנו אליו על־ידי מות בנו, אנו בטוחים כי עתה, הוא גם יושיע אותנו מחטאינו בזכות תקומתו לחיים. ");
INSERT INTO heblb_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","עתה אנו שמחים על היחסים החדשים שבינינו לבין אלוהים – יחסים המקרבים אותנו אליו – וכל זאת בזכות קורבנו של ישוע המשיח בעד חטאינו. ");
INSERT INTO heblb_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","כאשר האדם הראשון הפר את הציווי של ה׳, פגע חטאו בכל המין האנושי – חטאו זרע מוות בכל העולם ובני־האדם מתו, כי כולם חטאו. ");
INSERT INTO heblb_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","אמנם החטא כבר היה בעולם זמן רב לפני מתן־התורה, אך איש לא יכול להיחשב חוטא לתורה אם טרם ניתנה התורה. ");
INSERT INTO heblb_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","אף־על־פי־כן, המוות, שהוא תוצאת החטא, שלט בבני־האדם מאדם ועד משה – גם באלה שלא חטאו בדיוק אותו חטא של אדם. אדם מסמל את ניגודו של בן־האדם העתיד לבוא. ");
INSERT INTO heblb_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","מאידך, מתנת האלוהים שניתנה לנו באמצעות המשיח שונה בתכלית ממה שהנחיל לנו האדם הראשון. בעוד שחטאו של אדם הביא מוות לאנושות, הביא בן־האדם ישוע המשיח לאנושות סליחת חטאים ברחמי אלוהים. ");
INSERT INTO heblb_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","חטאו האחד של אדם הביא עונש מוות על רבים, ואילו המשיח מזכה אותנו מחטאינו ומעניק לנו חיים חדשים – וכל זאת בחסד. ");
INSERT INTO heblb_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","אם על־ידי חטאו של אדם אחד ויחיד השתלט המוות על כל בני־האדם, אנו בטוחים כי אלה הזוכים בחסדו הרב של אלוהים ובסליחת חטאיהם, יחיו וימלכו בזכות אדם אחד – ישוע המשיח. ");
INSERT INTO heblb_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","לכן, כשם שחטאו של האדם הראשון הביא עונש על כל בני־האדם, כך מזכה צדקתו של המשיח את כל בני־האדם בעיני אלוהים, והם זוכים בחיי נצח. ");
INSERT INTO heblb_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","כשם שעל־ידי סרבנות ואי־ציות של אדם אחד נמצאים בני־האדם במעמד של חוטאים, כך על־ידי ציות לאלוהים הביא המשיח אנשים רבים למעמד של צדיקים וחפים־מפשע בעיני אלוהים. ");
INSERT INTO heblb_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","מדוע ניתנה התורה? כדי שבני־האדם יראו שאין הם מסוגלים לציית לכל חוקי אלוהים. אולם ככל שאנו רגישים יותר לחטאינו, כך אנו מעריכים יותר את גודל החסד והרחמים של אלוהים. ");
INSERT INTO heblb_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","לפנים שלט החטא על כל בני־האדם וגרם למותם, אולם עתה שולטים חסדו וצדקתו של אלוהים, והם מעניקים לנו חיי נצח על־ידי ישוע המשיח אדוננו. ");
INSERT INTO heblb_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","אם כן, האם נמשיך לחטוא כדי שאלוהים יגלה כלפינו יותר חסד ורחמים? ");
INSERT INTO heblb_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","חס וחלילה! כיצד נוכל להמשיך לחטוא? הרי מתנו לגבי החטא! ");
INSERT INTO heblb_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","או שמא אינכם יודעים כי כאשר אנו נטבלים (במים) כביטוי לאמונתנו במשיח, אנו משתתפים סמלית במותו? ");
INSERT INTO heblb_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","האופי הישן והחוטא שלנו מת ונקבר עם המשיח בטבילה, וכשם שהמשיח קם לתחייה מן המתים, בגבורת אלוהים, כך גם אנחנו קמנו לחיים חדשים לגמרי. ");
INSERT INTO heblb_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","שהרי אם השתתפנו במותו, נשתתף גם בתחייתו. ");
INSERT INTO heblb_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","ואל נשכח כי תשוקותינו הרעות והישנות נצלבו והומתו עם המשיח, כדי שגופנו שוב לא ישמש מכשיר ביד החטא, וכדי ששוב לא נהיה משועבדים לחטא. ");
INSERT INTO heblb_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","כי אדם מת הוא חופשי ומשוחרר משליטת החטא. ");
INSERT INTO heblb_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","מאחר שהאדם הישן שבתוכנו מת עם המשיח, אנו יודעים שגם נקום לתחייה עמו וניקח חלק בחייו החדשים. ");
INSERT INTO heblb_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","אנחנו בטוחים כי לאחר שהמשיח קם לתחייה מן המתים, הוא שוב לא ימות לעולם; למוות כבר אין שליטה עליו! ");
INSERT INTO heblb_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","המשיח מת לגבי החטא פעם אחת ולתמיד, ואילו עתה הוא חי לנצח למען אלוהים. ");
INSERT INTO heblb_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","כך צריכים גם אנחנו לחשוב את עצמנו מתים לגבי החטא, וחיים על־ידי המשיח למען אלוהים. ");
INSERT INTO heblb_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","אם כן, שוב אל תניחו לחטא לשלוט בגופכם החלש; אל תיכנעו לפיתוייו של החטא ולתשוקותיו. ");
INSERT INTO heblb_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","אל תניחו לאף איבר בגופכם לשמש כלי רשע ביד החטא, אלא מסרו את כל כולכם לאלוהים, כי קמתם לתחייה מן המתים, ואלוהים רוצה להשתמש בגופכם למטרותיו הנעלות. ");
INSERT INTO heblb_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","החטא שוב לא ישלוט בכם, מכיוון שאינכם כפופים לתורה, ואתם חופשיים ונהנים מטובו וחסדו של אלוהים. ");
INSERT INTO heblb_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","האם נמשיך לחטוא משום שאיננו כפופים לתורה, אלא נמצאים תחת חסדו של אלוהים? חס וחלילה! ");
INSERT INTO heblb_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","האם אינכם יודעים שאתם רשאים לבחור את אדונכם? אתם יכולים לבחור להשתעבד לחטא הגורר אחריו מוות, או להשתעבד למשמעת ולציות המזכים ומצדיקים אתכם בעיני אלוהים. למי שתמסרו את עצמכם הוא יהיה אדונכם ואתם תהיו עבדיו. ");
INSERT INTO heblb_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","אבל תודה לאל על כך שלמרות שפעם בחרתם להיות עבדים לחטא, עכשיו אתם שומעים בכל לבכם למה שאלוהים מלמד אתכם. ");
INSERT INTO heblb_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","לאחר שהשתחררתם מהשעבוד לאדונכם הקודם – החטא, השתעבדתם לאדונכם החדש – הצדקה. ");
INSERT INTO heblb_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","אני משתמש בדימוי של עבד ואדון, משום שכך קל יותר להבין. כשם שבעבר העמדתם את גופכם לרשות החטא והטומאה, כך העמידו עתה את גופכם לשירות הצדקה והמעשים הטובים. ");
INSERT INTO heblb_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","כשהייתם עבדים לחטא לא הקדשתם מחשבה רבה לעשיית מעשים טובים, ");
INSERT INTO heblb_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","ומה היו התוצאות? מחרידות! כן, התוצאות היו נוראות כל־כך, עד כי עכשיו אתם מתביישים אף לחשוב על מה שנהגתם לעשות, כי כל המעשים האלה גוררים מוות. ");
INSERT INTO heblb_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","לעומת זאת עתה, בהיותכם משועבדים לאלוהים ומשוחררים מכוח החטא, התוצאה היא קדושה שאחריתה חיי נצח. ");
INSERT INTO heblb_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","כי לחטא יש שכר – מוות. ואילו אלוהים מעניק למאמינים בו ולמשרתים אותה מתנה: חיי נצח בישוע המשיח אדוננו! ");
INSERT INTO heblb_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","אחי, אלה מכם המכירים את התורה יודעים כי לאחר שאדם מת, התורה אינה שולטת בו יותר. ");
INSERT INTO heblb_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","למשל: כאשר אישה נישאת לאיש, התורה קושרת אותה אל בעלה כל ימי חייו, אך אם הבעל מת, האישה אינה קשורה אליו יותר ");
INSERT INTO heblb_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","ומותר לה להינשא שנית. אם היא תינשא שנית כל זמן שבעלה חי, היא תיחשב לנואפת. ");
INSERT INTO heblb_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","באופן דומה, אחי, מותו של המשיח על הצלב המית אתכם לגבי טענות התורה, ואתם חופשיים להשתייך לאחר – למשיח שקם לתחייה מן המתים – כדי שנעשה פרי לאלוהים. ");
INSERT INTO heblb_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","כאשר היינו עדיין משועבדים לטבע הישן והחוטא שלנו, עוררה בנו התורה את תשוקותינו ותאוותינו, ועשינו את אשר ציווה עלינו אלוהים לא לעשות. כך הצמיחו מעשינו הרעים פרי הגורם למוות. ");
INSERT INTO heblb_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","אולם עתה, לאחר שמתנו לגבי כל מה שכבל ושיעבד אותנו, אנו משוחררים מהתורה, כדי שנוכל לשרת את אלוהים בדרך חדשה: בדרך של רוח הקודש, ולא בדרך הישנה לפי הכתוב. ");
INSERT INTO heblb_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","האם אני מנסה לומר שתורת אלוהים היא חטא? חס וחלילה! התורה עצמה אינה בגדר חטא, אבל היא גילתה לי את חטאי. לדוגמה: לעולם לא הייתי מודה בחטא החמדה והתאווה שבלבי אלמלא אמרה התורה: ”לא תחמוד!“ ");
INSERT INTO heblb_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","החטא ניצל את הדיבר ”לא תחמוד“ כדי להזכיר לי שתשוקות אלה אסורות, ובכך הוא למעשה עורר וגירה תשוקות ודחפים אסורים שהיו כלואים בתוכי. רק במקום שבו אין תורה ואין חוקים, אין חטא. ");
INSERT INTO heblb_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","פעם כלל לא הייתה בי תודעת החטא. אולם כשנפקחו עיני והתחלתי להבין את מצוות ה׳, החל החטא לפעול בי ולפתות אותי להפר את מצוות ה׳, והתורה דנה אותי למוות. ");
INSERT INTO heblb_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","כך הדיבר שניתן כדי ללמדני את דרך החיים, גרם לי מוות. ");
INSERT INTO heblb_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","כי החטא, שניצל לרעה את הדיבר, רימה והמית אותי. ");
INSERT INTO heblb_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","אף־על־פי־כן אין ספק שהתורה עצמה היא קדושה, וכן גם הדיברות. ");
INSERT INTO heblb_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","אולם כיצד יכולה התורה להיות קדושה? האם לא התורה הקדושה היא שהמיתה אותי? ודאי שלא! החטא ניצל לרעה את הטוב כדי להביא למותי. מכאן יכולים אתם לראות עד כמה ערמומי ומסוכן הוא החטא, שכן הוא מנצל את התורה הטובה והקדושה של אלוהים למטרותיו הנאלחות. ");
INSERT INTO heblb_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","אם כן, התורה עצמה טובה – הבעיה היא בי, משום שאני מכור לחטא השולט בי. ");
INSERT INTO heblb_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","אינני מבין את התנהגותי: אני באמת רוצה לעשות את הטוב, אך איני יכול. לעומת זאת אני עושה את מה שאיני רוצה לעשות – אני עושה את מה שאני שונא! ");
INSERT INTO heblb_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","אני יודע היטב שאני עושה את הרע, וייסורי המצפון שלי מוכיחים שאני מסכים למעשה עם התורה שהפרתי. ");
INSERT INTO heblb_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","ברם איני יכול לעשות דבר, כי לא אני עושה את הרע, אלא החטא שבתוכי; החטא חזק ממני, והוא שגורם לי לעשות את כל המעשים הרעים האלה. ");
INSERT INTO heblb_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","מניסיוני אני יודע שבי, בבשרי, אין שום דבר טוב. לעתים קרובות אני נוכח כי יש לי רצון לעשות את הטוב, אך חסר לי הכוח לעשותו. ");
INSERT INTO heblb_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","כלומר, איני עושה את הטוב שאני מתכוון לעשות, ולעומת זאת אני מוצא את עצמי עושה את הרע שאינני רוצה לעשות! ");
INSERT INTO heblb_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","ואם אני עושה את מה שבעצם אינני רוצה לעשות, הרי ברור שלא אני עושה זאת, כי אם החטא השוכן והשולט בי. ");
INSERT INTO heblb_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","כתוצאה מכך אני מוצא בי חוקיות משונה: כאשר אני רוצה לעשות את הטוב, הרע משתלט עלי. ");
INSERT INTO heblb_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","בלבי אני חפץ לעשות את תורת ה׳, ");
INSERT INTO heblb_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","אך בגופי אני מרגיש חוק אחר הלוחם בחוק השכל וההיגיון, וכך הוא עושה אותי אסיר ועבד של החטא השוכן עדיין בגופי. ");
INSERT INTO heblb_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","מסכן שכמוני, מי יושיע אותי מהשעבוד לגוף הזה שדינו מוות? ");
INSERT INTO heblb_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","תודה לאל, האלוהים כבר הושיע אותי על־ידי ישוע המשיח אדוננו! אם כן, הטבע החוטא שלי משועבד לחטא, אולם בשכלי אני עבד לתורת האלוהים. ");
INSERT INTO heblb_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","המשתייכים לישוע המשיח לא יורשעו בדין! ");
INSERT INTO heblb_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","כי כוח רוח־החיים, אשר בישוע המשיח, שיחרר אותנו מהגלגל החוזר של חטא ומוות הבא בעקבות החטא. ");
INSERT INTO heblb_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","התורה מעולם לא יכלה להצדיק ולהושיע איש, בגלל האופי החלש של המין האנושי. משום כך שלח אלוהים את בנו בדמות אדם בעל גוף אנושי כשלנו – מלבד החטא שבנו – ושלל מהחטא את השליטה על המאמינים במשיח, וזאת בזכות קורבנו. ");
INSERT INTO heblb_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","על כן אנו יכולים עתה לקיים את דרישות התורה – בתנאי שנחיה על־פי הדרכת רוח הקודש, ולא על־פי הדרכת הטבע הישן והחוטא שלנו. ");
INSERT INTO heblb_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","אדם הנשלט על־ידי הטבע החוטא שלו חי למען עצמו ולמען סיפוק תאוותיו, בעוד שאדם הנשלט על־ידי רוח הקודש חי למען אלוהים, ועושה את הטוב בעיני אלוהים. ");
INSERT INTO heblb_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","הליכה בדרך רוח הקודש מביאה חיים ושלום, בעוד שכניעה לטבע החוטא שלנו מביאה מוות, ");
INSERT INTO heblb_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","שהרי הטבע החוטא שלנו שונא את אלוהים. טבע זה שלנו מעולם לא ציית לאלוהים, וגם לא יציית לו בעתיד. ");
INSERT INTO heblb_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","כל הנשלטים על־ידי אופיים החוטא אינם יכולים למצוא־חן בעיני אלוהים. ");
INSERT INTO heblb_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","אולם אתם אינכם נשלטים על־ידי הטבע החוטא שלכם, אלא על ידי רוח הקודש, אם אכן הוא שוכן בקרבכם, כי מי שרוח הקודש אינו שוכן בו איננו שייך למשיח. ");
INSERT INTO heblb_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","אך אם המשיח בקרבכם, אמנם גופכם מת בגלל החטא, אך הרוח הוא חיים לכם כי הוצדקתם. ");
INSERT INTO heblb_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","ואם שוכן בכם רוחו של האלוהים אשר הקים את ישוע מן המתים, אלוהים יקים לתחייה גם את גופכם בן־התמותה, על־ידי רוח הקודש השוכן בכם. ");
INSERT INTO heblb_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","לפיכך, אחים יקרים, איננו חייבים דבר לטבע החוטא שלנו ולדרישותיו. ");
INSERT INTO heblb_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","שכן אם ניכנע לו ונמשיך במעשינו הרעים – נמות. אבל אם בעזרת רוח הקודש נחסל ונמית את פעולות הטבע החוטא שלנו – נחיה. ");
INSERT INTO heblb_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","כי כל מי שמודרך על־ידי רוח הקודש של אלוהים הם בנים לאלוהים. ");
INSERT INTO heblb_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","אלוהים לא העניק לנו רוח אשר ישוב לשעבד אותנו לפחד, כי אם רוח המאמץ אותנו לו לבנים, והמאפשר לנו לקרוא לאלוהים: אבא, אבינו. ");
INSERT INTO heblb_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","רוח הקודש שהעניק לנו אלוהים מעיד בלבנו ומאשר שאנו באמת בני־אלוהים. ");
INSERT INTO heblb_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","ואם אנחנו בני־אלוהים, הרי שאנו גם יורשיו, כלומר, אנחנו יורשים יחד עם המשיח את נחלתו של אלוהים. ברם על־מנת לקחת חלק בכבודו עלינו לסבול למענו. ");
INSERT INTO heblb_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","אך אין להשוות כלל את סבלנו עתה לעומת הכבוד שייתן לנו אלוהים בבוא הזמן. ");
INSERT INTO heblb_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","שהרי כל הבריאה מצפה בכיסופים להתגלות הבנים לאלוהים. ");
INSERT INTO heblb_vpl VALUES ("RM8_20‏","075_8_20‏","ROM","8","20‏","21","כי באותו יום תשוחרר הבריאה מהשעבוד לכיליון ולמוות – שלהם נכנעה לא מרצונה, אלא מרצון אלוהים – על־מנת שתוכל לקחת חלק בחירות הנפלאה של בני האלוהים. ");
INSERT INTO heblb_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","אנחנו יודעים שכל הבריאה נאנחת וגונחת מכאב, כאילו בצירי לידה. ");
INSERT INTO heblb_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","לא רק הבריאה נאנחת, אלא גם אנחנו, המאמינים, אשר טעמנו מהאושר הנצחי שהכין אלוהים לאוהביו. כן, אנו נאנחים בציפייה לשחרור מכאב וסבל. אנו גם מצפים ליום שבו יתממש אימוצנו כבנים, ואלוהים יעניק לנו גוף חדש. ");
INSERT INTO heblb_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","בתקווה הזאת נושענו, והבה נזכור שתקווה פירושה ציפייה לדבר שעדיין לא ראינו; הרי איננו מצפים למה שאנו רואים או למה שכבר נמצא בידינו. ");
INSERT INTO heblb_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","אולם אם אנו מצפים לדבר שאיננו יכולים לראותו, אנו לומדים להמתין לו בסבלנות. ");
INSERT INTO heblb_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","גם רוח הקודש עוזר לנו בחולשותינו היום־יומיות ובתפילותינו, שכן איננו יודעים כיצד להתפלל כהלכה, ואיננו יודעים בעד מי ובעד מה להתפלל. אולם רוח הקודש מתפלל בעדנו ובשמנו בתחינות ואנחות עמוקות ממילים. ");
INSERT INTO heblb_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","האלוהים אשר יודע את המתרחש בלבנו, יודע גם מה מביע הרוח בתחינותיו בעדנו, כי הרוח מתפלל בעדנו לפי רצון האלוהים. ");
INSERT INTO heblb_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","אנו יודעים שאם נאהב את אלוהים ונתאים את עצמנו לתוכניותיו, כל מה שיקרה לנו יפעל לטובתנו. ");
INSERT INTO heblb_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","שהרי עוד מבראשית החליט אלוהים שכל המאמין בו – והוא ידע היטב מי יאמין בו – ידמה לבנו, כדי שבנו יהיה הבכור בין אחים רבים. ");
INSERT INTO heblb_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","הוא בחר בנו עוד לפני זמן רב, ובבוא העת הוא קרא לנו אליו, סלח לחטאינו, הצדיק אותנו והעניק לנו מכבודו. ");
INSERT INTO heblb_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","מה נאמר, אם כן, על הדברים הנפלאים האלה? אם אלוהים לצדנו איש לא יוכל להיות נגדנו! ");
INSERT INTO heblb_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","אם אלוהים לא חס אף על בנו היחיד, והקריב אותו למען כולנו, האם אתם מטילים ספק בכך שייתן לנו הכול יחד איתו? ");
INSERT INTO heblb_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","מי יעז להאשים את בני־האלוהים? הרי אלוהים עצמו הכריז שאנו חפים מפשע וצדיקים בעיניו. ");
INSERT INTO heblb_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","מי, אם כן, ירשיע אותנו? אף אחד – הרי המשיח מת בעדנו וקם לתחייה למעננו, ועתה הוא יושב לימין האלוהים ומפגיע בעדינו לפניו. ");
INSERT INTO heblb_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","מה מסוגל להרחיק אותנו מאהבת האלוהים, האם צרות? קשיים? רדיפות? רעב? סכנות? מלחמות? ");
INSERT INTO heblb_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","לא ולא! הכתובים אומרים שלמען אלוהים עלינו להיות מוכנים למות בכל עת – כמו שכתוב: ”כי עליך הורגנו כל היום, נחשבנו כצאן טבחה.“ ");
INSERT INTO heblb_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","אף־על־פי־כן הניצחון הוא שלנו על־ידי ישוע המשיח, אשר אהב אותנו כל־כך עד שהקריב את עצמו בעדנו. ");
INSERT INTO heblb_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","אני משוכנע שלא המוות ולא החיים, אף לא מלאכים ושדים, לא בהווה ולא בעתיד ולא שום כוחות, ");
INSERT INTO heblb_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","לא מקום המצאנו – במרומים או במעמקי הים – דבר לא יוכל להפריד אותנו מאהבת האלוהים, שנגלתה לנו כאשר ישוע המשיח אדוננו הקריב את עצמו למעננו. ");
INSERT INTO heblb_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","אני אומר את האמת במשיח ומצפוני ברוח הקודש מאשר שדברי נכונים: ");
INSERT INTO heblb_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","אני עצוב כל־כך ומדוכא. ");
INSERT INTO heblb_vpl VALUES ("RM9_3‏","075_9_3‏","ROM","9","3‏","4","הלוואי שיכולתי אני להיות מוחרם ומנודה מהמשיח, למען אחי בני־ישראל. אלוהים בחר בהם לעמו, הוא עצמו שכן ביניהם, הוא העניק להם את לוחות־הברית ואת התורה המדריכה אותם בחיי היום־יום, הוא אפשר להם לעבדו ולשרתו ונתן להם את הבטחותיו. ");
INSERT INTO heblb_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","היהודים הם זרע האבות – אברהם, יצחק ויעקב, ומהם בא המשיח (בדמותו האנושית) השולט בכל ומעל לכל. יבורך שמו לעולמים. ");
INSERT INTO heblb_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","האם לא קיים אלוהים את הבטחותיו ליהודים? ודאי שקיים. עלינו לזכור שלא כל מי שמבני ישראל הוא באמת ישראל. ");
INSERT INTO heblb_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","עובדת היותם צאצאי אברהם אינה אומרת שהם בני אברהם, כי הכתובים אומרים שהבטחת ה׳ מתייחסת רק לצאצאיו של יצחק בנו, אם־כי לאברהם היו עוד בנים. ");
INSERT INTO heblb_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","כלומר, לא כל צאצאיו הטבעיים של אברהם הם בני־אלוהים, אלא אלה שנולדו לפי הבטחת אלוהים. ");
INSERT INTO heblb_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","מה הייתה ההבטחה? ”למועד אשוב אליך כעת חיה ולשרה בן.“ ");
INSERT INTO heblb_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","שנים לאחר מכן, כאשר הרתה רבקה לבעלה יצחק וציפתה להולדת יעקב ועשו, ");
INSERT INTO heblb_vpl VALUES ("RM9_11‏","075_9_11‏","ROM","9","11‏","12","אמר אלוהים לרבקה כי עשו, הבן הבכור, ישרת את אחיו הצעיר יעקב. הבטחת אלוהים ניתנה עוד לפני הולדת הילדים, ועוד לפני שהספיקו לעשות טוב או רע. מדוע? על־מנת להראות שאלוהים אינו פועל בהתאם למעשינו והישגינו, אלא בהתאם לבחירתו ולרצונו, ");
INSERT INTO heblb_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","ככתוב: ”ואוהַב את יעקב ואת עשו שנאתי“. ");
INSERT INTO heblb_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","האם נאמר שאלוהים נוהג באי־צדק? חס וחלילה! ");
INSERT INTO heblb_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","הרי אלוהים אמר למשה: ”חנתי את אשר אחן, ורחמתי את אשר ארחם“. כלומר, אלוהים הוא המחליט את מי לחון ועל מי לרחם. ");
INSERT INTO heblb_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","אם כן, בחירת אלוהים אינה תלויה ברצונם של בני־האדם או במעשיהם, אלא באלוהים בלבד הקובע ומחליט על מי לרחם. ");
INSERT INTO heblb_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","קחו לדוגמה את פרעה מלך מצרים. אלוהים נתן לפרעה את ממלכת מצרים, כדי להפגין באמצעותו את כוחו וגבורתו שלו (של אלוהים), וכדי לפרסם את שמו ותפארתו בין כל העמים. ");
INSERT INTO heblb_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","אם כן, אלוהים הוא המחליט על מי לרחם, ואת לבו של מי להקשיח. ");
INSERT INTO heblb_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","אם תשאל: מדוע מעניש אלוהים את הסרבנים על שלא שמעו בקולו? האם לא עשו מה שאלוהים רצה שיעשו? ");
INSERT INTO heblb_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","תשובתי היא זאת: מי אתה, השואל, שתתווכח או שתבקר את ה׳? האם שואל הכלי את יוצרו: מדוע יצרת אותי כך ולא אחרת? ");
INSERT INTO heblb_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","כאשר אדם יוצר כד חומר, האין הוא רשאי ליצור מאותו גוש חומר כד אחד מרשים ביופיו, וכד שני ככלי אשפה? ");
INSERT INTO heblb_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","והאם אין לאלוהים הרשות לשפוך את זעמו, ולהראות את סמכותו לכלים המיועדים לכיליון, לאחר שהתייחס אליהם בסבלנות זמן רב מאוד? ");
INSERT INTO heblb_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","וזאת כדי שיוכל להראות לנו, שנועדנו מלפנים לחנינה, את עושרו וכבודו. ");
INSERT INTO heblb_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","אנחנו, המאמינים, הם אלה אשר בחר – מקרב היהודים וגם מבין הגויים. ");
INSERT INTO heblb_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","האם זוכרים אתם את נבואתו של הושע? בנבואה זו אומר אלוהים שימצא לעצמו בנים אחרים, ויאהב אותם למרות שלא אהב אותם לפני־כן. ");
INSERT INTO heblb_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","אלה אשר נאמר עליהם לפנים: ”לא עמי“, יהיו עתה בני אלוהים חיים. ");
INSERT INTO heblb_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","ישעיהו הנביא ניבא על ישראל, ואמר שאף כי עם ישראל ימנה אנשים רבים כחול אשר על שפת הים, רק מעטים יאמינו בה׳ וייוושעו. ");
INSERT INTO heblb_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","כי מנוי וגמור עם אלוהים להוציא לפועל את משפטו על הארץ, אולם בשל רחמיו הוא יקצר את תקופת הסבל. ");
INSERT INTO heblb_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","במקום אחר אומר ישעיהו שאלמלא ריחם עלינו אלוהים והותיר לנו שריד, היה גורלנו כגורל סדום ועמורה. ");
INSERT INTO heblb_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","מה המסקנה? אלוהים אפשר לגויים לקבל סליחת חטאים על־ידי אמונה, למרות שלא דרשו אותו, ");
INSERT INTO heblb_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","ואילו היהודים, שהשתדלו כל־כך להשיג צדקה על־ידי שמירת מצוותיו, לא זכו לכך. ");
INSERT INTO heblb_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","מדוע לא זכו? משום שניסו להשיג זאת תוך עשיית מעשים, במקום מתוך האמונה. הם נתקלו באבן נגף ונכשלו. ");
INSERT INTO heblb_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","אלוהים הזהיר את היהודים מפני אבן הנגף הזאת, ואמר שרבים מהם ייכשלו וימעדו, אך אלה שיאמינו (במשיח) לא יבושו לעולם. ");
INSERT INTO heblb_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","אחים יקרים, משאלת לבי ותפילתי העמוקה ביותר היא שהיהודים ייוושעו. ");
INSERT INTO heblb_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","אני יודע שהם מסורים לאלוהים על פי דרכם, אך מסירות זאת אינה מבוססת על הבנה נכונה של הכתובים. ");
INSERT INTO heblb_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","היהודים אינם מבינים שישוע המשיח הקריב את עצמו, כדי לסלוח לחטאיהם ולהצדיקם בעיני אלוהים. הם מנסים ליצור צדקה משלהם וכך לא נכנעים לצדקת ה׳. ");
INSERT INTO heblb_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","שכן המשיח הוא תכלית התורה, והוא מצדיק את כל המאמין בו. ");
INSERT INTO heblb_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","משה כתב על צדקה וישועה מתוך קיום התורה, ואמר שאדם המקיים את כל מצוות התורה בלי יוצא מן הכלל, ייוושע ויחיה (”אשר יעשה אתם האדם וחי בהם“). ");
INSERT INTO heblb_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","ואילו ישועה הנובעת מאמונה אומרת: ”אל תאמר בלבבך מי יעלה השמימה?“ זאת, כדי להוריד את המשיח לארץ. ");
INSERT INTO heblb_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","או ”מי ירד לתהום?“ זאת, כדי להשיב את המשיח לחיים. ");
INSERT INTO heblb_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","הישועה שאנו מבשרים נובעת מאמונה בישוע המשיח, והיא בהישג־ידו של כל אחד מאיתנו; למעשה היא בפינו ובלבנו. ");
INSERT INTO heblb_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","שכן אם תודה בפיך לפני בני־האדם שישוע הוא אדונך, ותאמין בלבך שאלוהים הקימו לתחייה מן המתים, תיוושע. ");
INSERT INTO heblb_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","משום שאמונת הלב מצדיקה אותנו לפני אלוהים, ומתוך אמונה שבלב אנחנו מודים בפינו וניוושע. ");
INSERT INTO heblb_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","וכתבי־הקודש אומרים לנו שכל המאמין במשיח לא יבוש. ");
INSERT INTO heblb_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","”כל המאמין“ פירושו: יהודים וגויים ללא הבדל, כי לכולנו אדון אחד המעניק מעושרו לכל המבקש ממנו. ");
INSERT INTO heblb_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","שכן ”כל אשר יקרא בשם ה׳ ימלט“! ");
INSERT INTO heblb_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","אך כיצד הם יקראו בשם ה׳ ויבקשו ממנו להושיעם, אם אינם מאמינים בו כלל? וכיצד יאמינו בו אם מעולם לא שמעו עליו? וכיצד ישמעו עליו אם איש אינו מספר להם? ");
INSERT INTO heblb_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","וכיצד יספר להם מישהו אם לא נשלח אליהם? לכך מתכוון הכתוב: ”מה נאוו רגלי מבשרי טוב“. ");
INSERT INTO heblb_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","אולם לא כל מי ששמע את בשורת אלוהים האמין בה, כפי שאמר ישעיהו: ”מי האמין לשמועתנו?“ ");
INSERT INTO heblb_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","בכל זאת, האמונה מתעוררת על־ידי שמיעת הבשורה, והבשורה היא דבר המשיח. ");
INSERT INTO heblb_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","אולם מה בנוגע ליהודים, האם לא שמעו את דבר ה׳? כן, הם שמעו, שהרי ”בכל־הארץ יצא קולם, ובקצה תבל מליהם“. ");
INSERT INTO heblb_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","ואם עם־ישראל שמע, האם לא הבין? עם־ישראל אכן הבין, כי משה אמר להם: ”אני אקניאם בלא עם, בגוי נבל אכעיסם“. כלומר, ה׳ יעורר את קנאת בני־ישראל על ידי הגויים. ");
INSERT INTO heblb_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","ישעיהו הנביא הוסיף על כך ואמר, כי אלה שלא חיפשו את אלוהים ולא דרשו אותו, הם שימצאו אותו. ");
INSERT INTO heblb_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","ואילו על עם־ישראל הוא אומר: ”פרשתי ידי כל היום אל עם סורר ומורה“. ");
INSERT INTO heblb_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","מתעוררת השאלה: האם זנח אלוהים את עמו? חס וחלילה! הרי אני עצמי יהודי, מזרעו של אברהם אבינו ומשבט בנימין. ");
INSERT INTO heblb_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","לא, אלוהים לא הפקיר את עמו, שבו בחר עוד מבראשית. האם אינכם זוכרים מה אומרים הכתובים על אליהו הנביא? אליהו זעק אל אלוהים והתלונן על עם־ישראל: ");
INSERT INTO heblb_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","”את מזבחתיך הרסו ואת נביאיך הרגו בחרב, ואיותר אני לבדי ויבקשו את נפשי לקחתה“. ");
INSERT INTO heblb_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","ומה ענה לו אלוהים? ”השארתי בישראל שבעת אלפים אשר לא כרעו (ברכיים) לבעל.“ ");
INSERT INTO heblb_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","גם היום לא כל היהודים פנו עורף לאלוהים; יש ביניהם כאלה שנושעו – לפי בחירתו וחסדו של אלוהים. ");
INSERT INTO heblb_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","ואם הם נבחרו בזכות חסדו של אלוהים, משמע שלא נבחרו בזכות מעשיהם הטובים. אילו נבחרו בזכות מעשיהם הטובים לא היה זה חסד, כי חסד זה מתנה ולא גמול לעבודה. ");
INSERT INTO heblb_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","מה המסקנה? רוב היהודים לא השיגו את הצדקה אשר ביקשו, רק מעטים השיגו – אלה שבחר אלוהים – ואילו האחרים נעשו עיוורים לאמת. ");
INSERT INTO heblb_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","כפי שכתוב בישעיהו: ה׳ הרדים את עם ישראל, ועל כן הם הביטו אך לא ראו, שמעו אך לא הבינו. ");
INSERT INTO heblb_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","ודוד אמר בתהלים שהשפע והאוכל שלהם יטמנו להם פח, ויביאו אותם למחשבה שהכול כשורה בינם לבין אלוהים. ");
INSERT INTO heblb_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","עיניהם תחשכנה והם יכרעו תחת מעמסה כבדה. ");
INSERT INTO heblb_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","האם פירוש הדבר שאלוהים הפקיר את עמו והתכחש אליו? ודאי שלא! מאחר שהיהודים חטאו העניק אלוהים לגויים ישועה ורצון להיוושע, כדי לעורר את קנאת היהודים ואת רצונם להיוושע. ");
INSERT INTO heblb_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","ואם חטאם של היהודים הביא עושר שכזה לעולם, תארו לעצמכם איזו ברכה יביאו היהודים לעולם כאשר יחזרו בתשובה ויאמינו במשיח! ");
INSERT INTO heblb_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","עתה אני מדבר אליכם, הגויים: כידוע לכם מינה אותי אלוהים לבשר לכם את בשורתו, ואני מבצע את המוטל עלי על הצד הטוב ביותר. ");
INSERT INTO heblb_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","אולי כך אוכל לעורר את קנאתם של היהודים, בני־עמי, ואחדים מהם ייוושעו. ");
INSERT INTO heblb_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","אם המרידות שלהם באלוהים הביאה לעולם סליחת חטאים, תארו לעצמכם מה תהיה תוצאת חזרתם בתשובה – ממש תחיית המתים! ");
INSERT INTO heblb_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","אם החלה המוקדשת לה׳ קודש היא, כך כל העיסה, ואם שורש העץ קודש לה׳ – כך גם הגזע והענפים. ");
INSERT INTO heblb_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","אם חלק מהענפים – חלק מהיהודים – נכרתו, ובמקומם אתה, ענף זית בר, הורכבת על העץ, חוברת לשורשיו ונהנית ממזונו העשיר, ");
INSERT INTO heblb_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","אל תתפאר, ואל תזלזל בענפים שנכרתו! אם תחוש גאווה, הזכר לעצמך כי יש לך חשיבות כלשהי רק משום שאלוהים הרכיב אותך על העץ, לפי תוכניתו. מלבד זאת, לא אתה נושא את העץ – אתה אינך אלא ענף; השורש הוא הנושא אותך ואת העץ! ");
INSERT INTO heblb_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","אם תאמר: ”אבל הענפים ההם נכרתו כדי שלי – הגוי – יהיה מקום בעץ, ומשום כך אני חשוב.“ ");
INSERT INTO heblb_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","זכור, היהודים נכרתו משום שלא האמינו, ואתה הורכבת רק משום שהאמנת. אל תתגאה בעצמך, אלא הישמר לך, והתייחס אל אלוהים בכבוד וביראה. ");
INSERT INTO heblb_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","כי אם אלוהים לא חס על הענפים הטבעיים, הוא לא יחוס גם עליך. ");
INSERT INTO heblb_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","שימו לב, אלוהים הוא טוב לב, ויחד עם זאת קפדן ומחמיר. הוא מחמיר עם אלה שאינם מצייתים לו, אולם הוא ייטיב אתכם, אם תמשיכו לאהוב אותו ולבטוח בו. אם לא תאהבו אותו ולא תבטחו בו, הוא יכרות גם אתכם. ");
INSERT INTO heblb_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","דעו לכם שאם היהודים יאמינו, אלוהים ירכיבם חזרה על העץ. אל תחשבו שהדבר למעלה מכוחו! ");
INSERT INTO heblb_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","אם אלוהים היה מוכן לקחת אתכם, הגויים, שהייתם רחוקים ממנו כל־כך והייתם ענפי זית בר, ולהרכיבכם על עץ הזית שלו שהוא ממין משובח, האם אינכם חושבים שישמח יותר להרכיב חזרה על העץ את היהודים, אשר היו הענפים הטבעיים? ");
INSERT INTO heblb_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","אחי היקרים, איני רוצה להעלים מכם את האמת, פן תתגאו בעצמכם. נכון שיהודים רבים אינם מאמינים בבשורת אלוהים, אך מצב זה יימשך רק עד שכל הגויים, אשר נבחרו על־ידי אלוהים, יאמינו בו. ");
INSERT INTO heblb_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","ואז כל עם־ישראל ייוושע, ככתוב: ”ובא מציון גואל וישיב פשע מיעקב.“ ");
INSERT INTO heblb_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","אלוהים אף אמר שיכרות ברית עם ישראל ויסלח לחטאיהם. ");
INSERT INTO heblb_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","יהודים רבים הם עתה אויבי הבשורה; הם שונאים אותה. אולם כל זה היה לתועלת שלכם, כי בגלל יחסם זה העניק לכם אלוהים את אוצרותיו. אבל עלינו לזכור שהיהודים הם עדיין עמו הנבחר של אלוהים, בזכות הבטחותיו לאברהם, יצחק ויעקב. ");
INSERT INTO heblb_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","שהרי אלוהים לעולם אינו מתחרט על דבריו, ולעולם אינו דורש חזרה את מתנותיו. ");
INSERT INTO heblb_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","פעם גם אתם מרדתם באלוהים, אך הוא ריחם עליכם. ");
INSERT INTO heblb_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","עתה היהודים הם המורדים והסרבנים, ברם יום אחד הם יחזרו בתשובה, ואלוהים ירחם גם עליהם כפי שריחם עליכם. ");
INSERT INTO heblb_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","כי אלוהים הסגיר לידי החטא את כל בני־האדם, כדי שיוכל לרחם על כולם. ");
INSERT INTO heblb_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","מה נפלא הוא אלוהינו! מה עמוקה ועשירה חכמתו! מה עשירה דעתו! דרכיו ומשפטיו הם למעלה מכושר הבנתנו ותפיסתנו. ");
INSERT INTO heblb_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","מי מאיתנו יודע את מחשבותיו? מי חכם דיו כדי לייעץ לו? ");
INSERT INTO heblb_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","או מי העניק לו מעולם מתנה המזכה אותו בגמול? ");
INSERT INTO heblb_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","הרי הכול בא מאלוהים לבדו. הכול נברא על־ידו ולכבודו. לאלוהים הכבוד לעולם. – אמן. ");
INSERT INTO heblb_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","אחים יקרים, אני מתחנן לפניכם שתמסרו את עצמכם לאלוהים כקורבן חי וקדוש, כפי שרצוי לאלוהים. לאור כל מה שעשה אלוהים למענכם, האם זאת בקשה מופרזת? ");
INSERT INTO heblb_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","אל תחקו את העולם בהתנהגותכם ובמעשיכם, אלא הניחו לאלוהים לפעול בכם ולשנות אתכם ואת דרך מחשבתכם, כדי שתלמדו להבחין מהו רצון אלוהים, ותדעו מה טוב, מושלם ורצוי בעיניו. ");
INSERT INTO heblb_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","כשליחו של אלוהים אני מזהיר כל אחד מכם: אל תפריזו בהערכתכם העצמית, אלא היו צנועים והעריכו את עצמכם לפי מידת האמונה שהעניק לכם אלוהים. ");
INSERT INTO heblb_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","כשם שגופנו האחד הוא בעל איברים רבים, ולכל איבר תפקיד משלו, ");
INSERT INTO heblb_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","כך אנחנו, המאמינים הרבים, הננו גוף המשיח. לכל אחד מאיתנו תפקיד משלו, אך אנו שייכים זה לזה וזקוקים איש לאחיו. ");
INSERT INTO heblb_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","אלוהים העניק לכל אחד מאתנו מתנות וכישרונות לפי רצונו. אם הוא העניק לך את מתנת הנבואה, נבא בכל הזדמנות, לפי מידת אמונתך. ");
INSERT INTO heblb_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","אם אלוהים העניק לך רצון מיוחד לשרת את הזולת, עשה זאת בלב שלם. אם אתה מורה, למד כמיטב ידיעתך. ");
INSERT INTO heblb_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","אם קיבלת את מתנת העידוד, פעל מתוך דאגה אמיתית. אם אלוהים העניק לך כסף, עזור לאחרים ביד רחבה. אם נבחרת למנהיג, מלא את תפקידך ברצינות ובאחריות. אם אתה עושה מעשה טוב, עשה אותו מתוך שמחה אמיתית. ");
INSERT INTO heblb_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","אל תעמידו פנים שאתם אוהבים אנשים אחרים, אלא אהבו אותם באמת ובכנות. שנאו כל דבר רע ועודדו כל מעשה טוב. ");
INSERT INTO heblb_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","אהבו איש את רעהו אהבה אמיתית – כאהבת אחים – והקדימו לכבד איש את רעהו. ");
INSERT INTO heblb_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","שרתו את האדון בחריצות ובהתלהבות, ולעולם אל תתעצלו בעבודתכם. ");
INSERT INTO heblb_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","שמחו על כל מה שאלוהים מתכנן למענכם. אם באה עליכם צרה, שאו אותה בסבלנות והתמידו בתפילה. ");
INSERT INTO heblb_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","אם אחיכם המאמינים זקוקים לעזרה, עזרו להם ברצון ובשמחה. היו מכניסי אורחים. ");
INSERT INTO heblb_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","אם מישהו רודף אתכם בשל אמונתכם במשיח, אל תקללו אותו, אלא התפללו שאלוהים יברך אותו! ");
INSERT INTO heblb_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","השתתפו בשמחתם של החוגגים ובצערם של האבלים. ");
INSERT INTO heblb_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","חיו בשלום זה עם זה. אל תתגאו ואל תימלאו חשיבות עצמית. אל תנסו למצוא־חן בעיני אנשים חשובים ואל תהיו חכמים בעיניכם. ");
INSERT INTO heblb_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","לעולם אל תשלמו רעה תחת רעה. עשו את הטוב בעיני כולם, ואל תתנו להם סיבה למתוח עליכם ביקורת. ");
INSERT INTO heblb_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","עד כמה שהדבר תלוי בכם, חיו בשלום עם כל אחד. ");
INSERT INTO heblb_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","ידידי, אל תיקחו את החוק לידיכם, ואל תנקמו באחרים; השאירו תפקיד זה לאלוהים, כי הוא הבטיח שיעניש את הראויים לעונש. ");
INSERT INTO heblb_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","במקום לנקום באויבך, האכל אותו אם הוא רעב, ואם הוא צמא – הגש לו משקה. כי ככה כאילו ”גחלים אתה חותה על ראשו.“ ");
INSERT INTO heblb_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","אל תניח לרע להשתלט עליך, אלא השתלט אתה על הרע במעשיך הטובים. ");
INSERT INTO heblb_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","על כל אדם לציית לשלטונות, כי אין שלטון שלא בזכות הסכמת אלוהים, והשלטונות הקיימים נקבעו על־ידי אלוהים. ");
INSERT INTO heblb_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","לכן, המסרבים לציית לשלטונות ולחוקיהם, ממרים למעשה את פי האלוהים, והוא יענישם. ");
INSERT INTO heblb_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","אזרח טוב וישר אינו פוחד מהמשטרה והחוק; אדם שאינו ישר פוחד מהם. לכן, אם אינך רוצה לחשוש מהשלטונות, שמור על החוק, והשלטונות ישבחו אותך. ");
INSERT INTO heblb_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","איש החוק נשלח על־ידי אלוהים כדי לעזור לך, אבל אם אתה עובר על החוק יש לך ממה לחשוש, כי הם המחזיקים בחרב ויש להם זכות להשליט סדר ולהעניש. לשם כך שלח אותו אלוהים. ");
INSERT INTO heblb_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","אם כן, עלינו לשמור את החוק לא רק כדי שלא ניענש, אלא גם לשמור על מצפון נקי. ");
INSERT INTO heblb_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","מאותה סיבה עלינו גם לשלם מסים, כי עובדי הממשלה והרשויות, שמונו על־ידי אלוהים, צריכים לקבל את משכורתם, כדי שיוכלו להמשיך לשמור על הסדר הציבורי. ");
INSERT INTO heblb_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","תנו לכל אחד את המגיע לו: מס לשלטונות המס, מכס לשלטונות המכס. צייתו לממונים עליכם וכבדו את הראויים לכבוד. ");
INSERT INTO heblb_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","אל תהיו חייבים דבר לאיש – מלבד אהבה, שכן אדם האוהב את הזולת מקיים את תורת אלוהים. ");
INSERT INTO heblb_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","שהרי אם אתה אוהב את חברך כמוך, לא תרצה לפגוע בו! לא תפתה את אשתו לבגוד בו, לא תרצח אותו, לא תגנוב ממנו, לא תעיד נגדו עדות שקר, לא תקנא בו ולא תעשה כל דבר אחר שנאסר עלינו בעשרת הדיברות. כי כל הדיברות כלולים במצווה אחת: ”ואהבת לרעך כמוך.“ ");
INSERT INTO heblb_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","עלינו לאהוב איש את רעהו, כי האהבה אינה פוגעת באיש, ובכך היא מקיימת את התורה כולה. ");
INSERT INTO heblb_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","מדוע אני מדגיש את עניין התנהגותכם? כידוע לכם אנו חיים בזמן מכריע ועלינו להתעורר, שכן ישועת אלוהים וביאת המשיח קרובים אלינו עתה יותר מאשר ביום שבו האמנו לראשונה במשיח. ");
INSERT INTO heblb_vpl VALUES ("RM13_12‏","075_13_12‏","ROM","13","12‏","13","הלילה חלף ויום שובו של המשיח קרב. על כן הפסיקו את מעשי הרשע הנעשים בחשכת הלילה, ועשו מעשים טובים וטהורים כפי שהחיים באור היום צריכים לעשות. עלינו לחיות בצניעות ולא להפקיר את עצמנו לתאוות בשרנו: לא להשתכר, לא לזנות, לא לריב ולא לקנא, ");
INSERT INTO heblb_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","במקום זאת, לבשו את נוכחות האדון ישוע המשיח, ואל תתנו לעצמכם לחשוב על דרכים להשביע את התאוות הרעות שלכם. ");
INSERT INTO heblb_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","קבלו את האדם שאמונתו חלשה משלכם בשמחה וחמימות, ואל תמתחו ביקורת על דעותיו והשקפותיו. ");
INSERT INTO heblb_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","זה מאמין שמותר לו לאכול כל דבר, ואילו זה שאמונתו חלשה הוא צמחוני. ");
INSERT INTO heblb_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","מי שאוכל בשר אינו צריך לבוז למי שאינו אוכל אותו, ומי שאינו אוכל אינו צריך לבוז למי שאוכל, כי אלוהים אוהב את כולנו במידה שווה! ");
INSERT INTO heblb_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","מי אתה שתמתח ביקורת על משרתו של אלוהים? המאמין המשיחי הוא משרתו של אלוהים, ורק לו הוא חייב דין וחשבון. הנח לאלוהים לומר למאמין אם הוא נוהג כשורה או לא, ואם יש צורך, אלוהים בהחלט יכול לתקן את דרכו. ");
INSERT INTO heblb_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","יש אדם המכבד יום מסוים יותר מימים אחרים, ויש המכבד את כל הימים במידה שווה. כל אדם צריך להיות משוכנע במה שהוא מאמין. ");
INSERT INTO heblb_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","כשם שאדם המעדיף לקדש לה׳ יום מסוים עושה זאת לכבוד האדון, כך גם האוכל אוכל לכבוד ה׳, כי הוא מודה לאלוהים. מי שאינו אוכל – לכבוד ה׳ אינו אוכל, וגם הוא מודה לאלוהים. ");
INSERT INTO heblb_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","אין אנו אדונים לעצמנו, ואיננו חיים לעצמנו או מתים לפי בחירתנו. ");
INSERT INTO heblb_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","אם אנו חיים – אנו חיים לאדון, ואם אנו מתים – אנו מתים לאדון; בחיינו ובמותנו אנו שייכים לאדון. ");
INSERT INTO heblb_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","ישוע המשיח מת וקם לתחייה כדי שיהיה אדון על החיים ועל המוות. ");
INSERT INTO heblb_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","אין לך זכות לשפוט את מעשי אחיך או לבוז לו. זכור, יום אחד כולנו עתידים להישפט לפני אלוהים – לא לפי קנה־המידה שלנו, אלא לפני קנה־המידה שלו. ");
INSERT INTO heblb_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","כפי שכתוב: ”בי נשבעתי … כי לי תכרע כל ברך ותשבע כל לשון“. ");
INSERT INTO heblb_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","כל אחד מאיתנו ימסור דין וחשבון על מעשיו לאלוהים בלבד. ");
INSERT INTO heblb_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","לכן הבה נחדל למתוח ביקורת איש על אחיו. לעומת זאת, נבקר את עצמנו ונדאג שלא נכשיל את אחינו במעשינו. ");
INSERT INTO heblb_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","אני משוכנע באמונה, שדבר אינו טמא בפני עצמו; הוא טמא רק למי שחושב אותו לטמא. ");
INSERT INTO heblb_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","אם אחיך נפגע מהעובדה שאתה אוכל בשר, ואילו אתה ממשיך בשלך, הרי שאינך מתייחס אליו באהבה. אל תניח לדבר־מאכל לפגוע במאמין המשיחי שגם בעדו מת המשיח. ");
INSERT INTO heblb_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","אל תניח לדבר הנראה כשר בעיניך להיראות כחטא בעיני אחרים. ");
INSERT INTO heblb_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","אחרי־הכול לנו, המשיחיים, אכילה ושתייה אינם הדברים החשובים ביותר בחיינו. החשוב יותר הוא לעשות מעשים טובים, לרדוף שלום ולשמוח בהשראת רוח הקודש. ");
INSERT INTO heblb_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","אם נשרת את האדון בדרך זאת, שירותנו ימצא־חן בעיני אלוהים ובעיני בני־אדם. ");
INSERT INTO heblb_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","ובאותה דרך הבה נשאף לאחדות ולשלום בקהילה, ונשתדל לבנות איש את רעהו. ");
INSERT INTO heblb_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","אל תהרוס את עבודת אלוהים בגלל דבר־מאכל. זכור, מותר לך לאכול כל דבר, כי הכול טהור, אך אם אכילתך עלולה לפגוע באחיך, אזי אסור לך לאכול! ");
INSERT INTO heblb_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","מוטב לא לאכול בשר, לא לשתות יין ולא לעשות דבר שעלול לפגוע באחיך. ");
INSERT INTO heblb_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","אתה אמנם יודע שמותר לך לאכול כל דבר, כי אלוהים נתן לך רשות, אך שמור זאת בינך לבין אלוהים ואל תתגאה בכך לפני אחרים, כי הם עלולים להיפגע. אשרי האיש העושה את הדבר הנכון במצפון נקי. ");
INSERT INTO heblb_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","אם אתה חושב שמעשה מסוים אסור, אל תעשהו, כי לגביך הוא אסור. אם אתה בכל זאת עושה אותו, הרי שחטאת, כי לא נהגת באמונה, וכל מה שנעשה ללא אמונה הוא חטא! ");
INSERT INTO heblb_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","אנחנו החזקים יותר באמונה צריכים לעזור למאמינים החלשים מאיתנו, להתייחס אליהם בסבלנות ולעודד אותם. אל נהיה אנוכיים ואל נבקש רק את טובת עצמנו. ");
INSERT INTO heblb_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","עלינו לבקש את טובת הזולת ולבנות איש את אחיו. ");
INSERT INTO heblb_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","גם המשיח לא ביקש את טובת עצמו; אנו קוראים על כך בתהלים: ”חרפות חורפיך נפלו עלי“. כלומר, הגידופים של מחרפי אלוהים נפלו עליו. ");
INSERT INTO heblb_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","כל אשר נכתב בכתבי־הקודש לפני זמן רב, נכתב כדי ללמדנו סבלנות, לעודד ולנחם אותנו בתקווה אשר נמצאת בהבטחות הכתובים. ");
INSERT INTO heblb_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","והאלוהים אשר מעניק סבלנות ועידוד יעזור לכם לחיות יחד בהתאמה שלמה – כרצונו של ישוע המשיח, ");
INSERT INTO heblb_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","כדי שכולנו פה אחד נברך ונכבד את האלוהים אבי אדוננו ישוע המשיח. ");
INSERT INTO heblb_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","על כן קבלו איש את אחיו לקהילתכם בברכה ובחמימות, כמו שהמשיח קיבל אתכם, והתנהגות כזאת תביא כבוד לאלוהים. ");
INSERT INTO heblb_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","זכרו, ישוע המשיח בא לעולם בתור משרת היהודים, כדי להראות לעולם כולו שאלוהים מקיים את הבטחותיו לאבותינו. ");
INSERT INTO heblb_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","המשיח בא לעולם גם כדי שהגויים ייוושעו ויפארו את אלוהים על־שום רחמיו עליהם. זוהי כוונת הכתוב: ”על כן אודך בגויים ה׳ ולשמך אזמרה“. ");
INSERT INTO heblb_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","ועוד כתוב: ”הרנינו, גויים, עם עמו“. ");
INSERT INTO heblb_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","ובתהלים: ”הללו את ה׳ כל גויים, שבחוהו כל האומים“. ");
INSERT INTO heblb_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","וישעיהו הנביא אמר: ”והיה ביום ההוא שורש ישי אשר עומד לנס עמים, אליו גוים ידרשו“. ");
INSERT INTO heblb_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","מי ייתן שאלוהי התקווה ימלא אתכם שמחה, שלום ושלווה באמונתכם, כדי שבכוח רוח הקודש הופעתכם ודרך חייכם יקרינו תקווה. ");
INSERT INTO heblb_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","אחים יקרים, אני בטוח שאתם חיים כיאה למאמינים משיחיים. אני יודע שאתם נבונים, מלאי אהבה ומשגיחים איש על רעהו כדי שלא לסטות מהדרך הנכונה. ");
INSERT INTO heblb_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","בכל זאת, כדי לרענן את זיכרונכם, כתבתי לכם בהדגשה ובהעזה בנוגע לדברים מסוימים, משום החסד שהעניק לי אלוהים – ");
INSERT INTO heblb_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","להיות שליחו של ישוע המשיח לגויים. בתוקף כהונתי כשליחו של המשיח עלי לבשר לגויים את בשורת האלוהים, ועל־ידי כך להציגם לפניו כמנחה רצויה ומקודשת ברוח הקודש. ");
INSERT INTO heblb_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","על כן, הודות לישוע המשיח אני יכול להתגאות מעט בשירותי למען אלוהים. ");
INSERT INTO heblb_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","איני מעז לדבר בגאווה על דבר מלבד מה שהמשיח עשה דרכי, שהביא את הגויים לאלוהים על ידי המסר שלי ופועלי בקרבם, ");
INSERT INTO heblb_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","בניסים ובנפלאות שאלוהים חולל באמצעותי בגבורת רוח הקודש. בדרך זאת הפצתי את בשורת המשיח מירושלים ועד לאילוריקון. ");
INSERT INTO heblb_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","השתדלתי להפיץ את בשורת המשיח במקומות שעדיין לא שמעו עליו; לא רציתי לבשר במקום ששליח אחר כבר הקים קהילה, שכן לא רציתי לבנות על יסודותיו של אדם אחר. ");
INSERT INTO heblb_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","נהגתי כדברי ישעיהו הנביא שאמר: ”אשר לא סופר להם ראו, ואשר לא שמעו התבוננו“. ");
INSERT INTO heblb_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","מסיבה זאת נמנע ממני פעמים רבות לבקר אתכם. ");
INSERT INTO heblb_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","עתה סיימתי לבסוף את עבודתי כאן, ולאחר ציפייה של שנים ארוכות אני יכול לבקר אתכם. ");
INSERT INTO heblb_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","אני מקווה לבקרכם בדרכי לספרד, ולאחר שאיהנה מהתחברות איתכם תוכלו לשלחני לדרכי. ");
INSERT INTO heblb_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","עתה מועדות פני לירושלים, כדי להביא מתנה כספית ליהודים המשיחיים הנמצאים שם. ");
INSERT INTO heblb_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","המתנה היא תרומתם של המאמינים המשיחיים במקדוניה ובאכיא, אשר החליטו לעזור למאמינים העניים בירושלים. ");
INSERT INTO heblb_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","הם עצמם החליטו לתרום למען היהודים המשיחיים בירושלים. למעשה הם מרגישים חובה נעימה לעזור להם. מדוע? מפני שקהילת ירושלים הייתה זאת שהפיצה לראשונה את בשורת המשיח בין הגויים. כתוצאה מכך התברכו הגויים בכל הברכות הרוחניות, והמעט שבידם לעשות הוא להגיש עזרה חומרית למאמינים בירושלים, כאשר אלה זקוקים לה. ");
INSERT INTO heblb_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","לאחר שאסיים את שליחותי ואמסור להם את התרומה, אבוא לבקר אתכם בדרכי לספרד. ");
INSERT INTO heblb_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","אני משוכנע שבבואי אליכם אביא עמי את ברכתו המלאה של המשיח. ");
INSERT INTO heblb_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","אחי היקרים, אני מתחנן לפניכם בשם אדוננו ישוע המשיח, ולמען האהבה שהעניק לנו רוח הקודש: אנא, התפללו הרבה לאלוהים בעדי ובעד עבודתי. ");
INSERT INTO heblb_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","התפללו שלא אפול בידי הלא־מאמינים בירושלים, ושהמאמינים בירושלים יקבלו בשמחה את התרומה שאני מביא להם. ");
INSERT INTO heblb_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","ואז, ברצון אלוהים, אוכל לבוא אליכם בלב שמח וארענן את נפשי בחברתכם. ");
INSERT INTO heblb_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","האלוהים המעניק שלום יהיה עם כולכם. – אמן. ");
INSERT INTO heblb_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","ברצוני להמליץ לפניכם על אחותנו היקרה פובי, העובדת בשירות הקהילה בקנכרי. ");
INSERT INTO heblb_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","היא עומדת לבקר אתכם בקרוב, ואני מבקש מכם שתקבלוה בחמימות ותעזרו לה בכל צרכיה, כי היא עזרה למאמינים רבים ולי ביניהם. ");
INSERT INTO heblb_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","מסרו דרישת שלום לפריסקלה ועקילס – חברי בעבודת המשיח, ");
INSERT INTO heblb_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","שסיכנו את חייהם למעני. לא רק אני אסיר תודה להם, אלא כל קהילות הגויים. ");
INSERT INTO heblb_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","שאלו גם לשלום חברי הקהילה הנפגשים בביתם. דרישת שלום לאפינטוס היקר, שהיה המאמין המשיחי הראשון באסיה. ");
INSERT INTO heblb_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","דרישת שלום למרים שעשתה למענכם רבות, ");
INSERT INTO heblb_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","ולקרובי משפחתי, אנדרוניקוס ויוניס, שהיו אסורים איתי בבית־הכלא. השניים מכובדים מאוד בין השליחים, ולמעשה האמינו במשיח לפני. ");
INSERT INTO heblb_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","דרישת שלום לאמפליאס – ידידי ואחי היקר באמונה, ");
INSERT INTO heblb_vpl VALUES ("RM16_9‏","075_16_9‏","ROM","16","9‏","10","לאסטכיס החביב, ולאורבנוס, חברנו הנאמן לאדון, ולבני־משפחתו של אריסטובולוס. ");
INSERT INTO heblb_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","שאלו לשלום קרובי – הורודיון, ולשלום המאמינים שבין בני ביתו של נרקיסוס. ");
INSERT INTO heblb_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","דרישת שלום לטרופינה ולטרופסה, העובדות בשירות האדון, ולפרסיס היקרה אשר עמלה רבות למען האדון. ");
INSERT INTO heblb_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","דרישת שלום לרופוס, אשר נבחר על־ידי האדון, ולאמו שהייתה לי כאם. ");
INSERT INTO heblb_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","שאלו לשלום אסונקריטוס, פליגון, הרמס, פטרובס, הרמיס והאחרים הנמצאים אתם. ");
INSERT INTO heblb_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","שאלו לשלום פילולוגוס, יוליא, נירוס ואחותו, אולימפס וכל המאמינים אשר איתם. ");
INSERT INTO heblb_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","דרישת שלום לכם מכל קהילות המאמינים כאן. ברכו איש את רעהו בנשיקה קדושה. ");
INSERT INTO heblb_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","לסיום מכתבי ברצוני להזהירכם: התרחקו מהאנשים הגורמים לפילוגים ולמחלוקות; הם מנסים לפתות ולהכשיל אתכם, כדי להרחיקכם מדבר ה׳ שאותו למדתם. ");
INSERT INTO heblb_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","אנשים אלה אינם משרתים את אדוננו ישוע המשיח, כי אם את עצמם. בלשון חנופה ובדברי חלקות הם מתעים את הכסילים והתמימים. ");
INSERT INTO heblb_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","נאמנותכם לאדוננו ידועה בכל מקום, ועובדה זאת משמחת אותי מאוד. אני רוצה שתמיד תבדילו בין טוב לרע, ושתתרחקו מכל דבר רע. ");
INSERT INTO heblb_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","ואלוהי השלום יכניע לרגליכם במהרה את השטן. ברכת ישוע המשיח אדוננו עליכם. ");
INSERT INTO heblb_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","חברי טימותיוס וקרובי משפחתי: לוקיוס, יסון וסוסיפטרוס שולחים לכם דרישת שלום. ");
INSERT INTO heblb_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","גם אני, טרטיוס, הכותב מכתב זה בשם פולוס, מוסר לכם דרישת שלום. ");
INSERT INTO heblb_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","גיוס – מארחי ומארח הקהילה שנפגשת בביתו, שואל לשלומכם, וכן ארסטוס גזבר־העיר וקורטוס. ");
INSERT INTO heblb_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","שלום לכולכם. ברכת ישוע המשיח אדוננו על כולכם. – אמן. ");
INSERT INTO heblb_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","אני מפקיד אתכם בידי האלוהים אשר יכול לחזק את אמונתכם, כפי שמבטיחה הבשורה וכפי שכבר אמרתי לכם. זאת תוכניתו של ה׳ לישועת הגויים, תוכנית שנשמרה בסוד מבריאת העולם. ");
INSERT INTO heblb_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","אולם עתה, כדברי הנביאים ולפי מצוות ה׳, מתפרסמת בשורה זו בכל מקום, ואנשים מכל העולם מאמינים במשיח ומצייתים לו. ");
INSERT INTO heblb_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","לאלוהינו החכם האחד כל הכבוד לעולמי עולמים, על־ידי ישוע המשיח אדוננו. – אמן.");
INSERT INTO heblb_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","מאת פולוס, שנבחר על־ידי אלוהים להיות שליחו של ישוע המשיח, ומאת סוסתניס אחינו. ");
INSERT INTO heblb_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","אל המאמינים המשיחיים בקורינתוס, שנקראו על־ידי אלוהים להיות לו לעם בזכות ישוע המשיח, ואל כל המאמינים המשיחיים באשר הם; אל כל מי שמאמין באמת ובתמים בישוע המשיח אדוננו. ");
INSERT INTO heblb_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","אלוהינו ואדוננו יברך אתכם בכל ברכותיו ויעניק לכם שלום, שלווה ומנוחה. ");
INSERT INTO heblb_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","אינני חדל להודות לאלוהים על כל המתנות הנפלאות שהעניק לכם משום שאתם שייכים לו; ");
INSERT INTO heblb_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","הוא העשיר את חייכם בתוכן ובכל דבר טוב, עזר לכם בכול אומר, ואף העניק לכם הבנה מלאה של האמת. ");
INSERT INTO heblb_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","אמרתי לכם מראש שהמשיח יעשה כל זאת למענכם, ואתם רואים שהוא באמת עשה! ");
INSERT INTO heblb_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","כעת לא חסר לכם דבר; קיבלתם את כל הברכות, המתנות הרוחניות ואת הכוח למלא את רצונו. ברכות אלה ניתנו לכם למשך הזמן שאתם מצפים לשובו של ישוע המשיח אדוננו. ");
INSERT INTO heblb_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","המשיח יתמיד לעזור לכם להיות טהורים ונקיים מחטא ביום שובו, ");
INSERT INTO heblb_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","שכן אלוהים מקיים תמיד את הבטחותיו, והרי הוא עצמו קרא לכם להתחבר עם בנו ישוע המשיח. ");
INSERT INTO heblb_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","אחים יקרים, אני מתחנן לפניכם בשם ישוע המשיח אדוננו: הפסיקו את המריבות והוויכוחים! עליכם לחיות באהבה ובשלום כדי שלא יהיו פילוגים בקהילה. אני מבקש מכם, אנא, ותרו איש לרעהו, היו בעלי דעה אחת ומטרה אחת. ");
INSERT INTO heblb_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","בני ביתה של כלואה סיפרו לי על המריבות והוויכוחים שלכם. ");
INSERT INTO heblb_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","זה אומר: ”אני בעד פולוס!“ וזה אומר: ”אני בעד אפולוס!“ או ”אני בעד ‎ כֵּיפָא (פטרוס)!“ ויש הטוענים כי הם בלבד תלמידיו האמיתיים של ישוע המשיח. ");
INSERT INTO heblb_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","וכך אתם מחלקים את המשיח לחלקים רבים. אך האם אני, פולוס, נצלבתי בעד חטאיכם? או האם מישהו מכם נטבל בשמי? ");
INSERT INTO heblb_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","אני מודה לאלוהים שלא הטבלתי איש מכם, מלבד קריספוס וגיוס, ");
INSERT INTO heblb_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","כך שעכשיו איש אינו יכול לטעון שניסיתי להקים קהילה חדשה – ”קהילת פולוס“. ");
INSERT INTO heblb_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","שכחתי להוסיף שהטבלתי גם את בני משפחתו של סטפנוס. איני זוכר שהטבלתי עוד מישהו. ");
INSERT INTO heblb_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","שכן המשיח לא שלח אותי להטביל, כי אם לבשר את דבר־אלוהים. אבל אפילו ההטפה שלי אינה נשמעת מחוכמת ביותר, מפני שאיני משתמש במילים מסובכות ויפות, ואף לא ברעיונות נשגבים ומסובכים, מחשש שאחליש ואקהה את הכוח העצום שבבשורה הפשוטה של צלב המשיח. ");
INSERT INTO heblb_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","אני יודע היטב שהלא־מאמינים חושבים את מותו של ישוע על הצלב לשטות; אולם אנחנו, המאמינים שנושענו, יודעים שזוהי גבורת אלוהים. ");
INSERT INTO heblb_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","כי אלוהים אמר: ”אאבד חכמת חכמים ובינת נבונים אסתיר“. ");
INSERT INTO heblb_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","אלוהים העמיד באור מגוחך את המלומדים, החוקרים, המדענים ומנהיגי העולם, והוכיח שאין כל ערך לחכמתם. ");
INSERT INTO heblb_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","כי אלוהים, בחכמתו הרבה, מנע בעד העולם מלהיוושע באמצעות גאוניות אנושית, ואז בא והושיע את כל מי שהאמין בבשורתו, שהעולם כינה ”מטופשת“. ");
INSERT INTO heblb_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","הבשורה נשמעת מטופשת ליהודים, כי הם דורשים אות מהשמים כהוכחה לאמיתות תוכנה, ואילו היוונים מאמינים רק במה שתואם את הפילוסופיה שלהם – במה שנראה מחוכם. ");
INSERT INTO heblb_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","על כן כאשר אנחנו מבשרים שישוע המשיח מת כדי להושיע את כולם, היהודים נעלבים, ואילו הגויים מבטלים את הבשורה בנפנוף. ");
INSERT INTO heblb_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","אולם אלוהים פקח את עיניהם של בחיריו מבין היהודים והגויים, כדי שיראו כי המשיח הוא התגלמות כוח הישועה של אלוהים; המשיח עצמו הוא מרכז תוכניתו הנפלאה של אלוהים להושיע אותנו. ");
INSERT INTO heblb_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","תוכניתו ”מטופשת“ זו של אלוהים מחוכמת בהרבה מהתוכנית הגאונית ביותר של בני־האדם, ואלוהים ב”חולשתו“ – מות ישוע על הצלב – חזק הרבה יותר מכל אדם. ");
INSERT INTO heblb_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","בוודאי שמתם לב, אחים יקרים, שרק מעטים מכם בעלי משרות חשובות ועמדות־מפתח, בעלי כוח השפעה או בעלי ממון. ");
INSERT INTO heblb_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","כי אלוהים בחר במתכוון ברעיונות שהעולם חושב למטופשים וחסרי־ערך, כדי לבייש את חכמי העולם. ");
INSERT INTO heblb_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","הוא בחר בתוכנית שנראתה חסרת כל ערך בעיני העולם, והשתמש בה להשפיל עד עפר את האנשים החכמים ביותר, ");
INSERT INTO heblb_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","כדי שאף אחד לא יתפאר לפני ה׳. ");
INSERT INTO heblb_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","שכן אלוהים לבדו נתן לנו את החיים דרך ישוע המשיח. המשיח הוא שהציג לפנינו את תוכנית ה׳ לישועתנו, הוא שעשה אותנו רצויים לה׳, הוא שקרב אותנו לאלוהים, טיהר וקידש אותנו, והקריב את עצמו למוות כדי להעניק לנו את ישועתנו. ");
INSERT INTO heblb_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","משום כך עלינו לנהוג לפי הכתוב: ”המתהלל יתהלל בה׳!“ ");
INSERT INTO heblb_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","אחים יקרים, כאשר באתי לספר לכם בפעם הראשונה את בשורת אלוהים, לא השתמשתי במילים יפות ונשגבות, ולא העליתי רעיון גאוני כלשהו, ");
INSERT INTO heblb_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","שכן החלטתי לספר לכם רק על אודות ישוע המשיח ומותו על הצלב. ");
INSERT INTO heblb_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","באתי אליכם בחולשה, בפחד וברעדה, ");
INSERT INTO heblb_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","ודברי היו ברורים למדי. לא ניסיתי לפתות אתכם בלשון חלקה, אבל רוח הקודש חיזק את דברי והוכיח לכל השומעים שאכן אלה הם דברי אלוהים. ");
INSERT INTO heblb_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","עשיתי זאת משום שלא רציתי שאמונתכם תהיה מבוססת על חכמת בני־אדם, אלא על כוחו של אלוהים. ");
INSERT INTO heblb_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","אך בהימצאי בין המבוגרים יותר באמונה, אני משתמש במילים בעלות משמעות עמוקה יותר – במילות חוכמה, לא חכמת העולם הזה, ולא חכמה המקובלת אצל גדולי העולם הזה שדינם נגזר לאבדון. ");
INSERT INTO heblb_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","אלה הן מילות חכמה הניתנות על־ידי אלוהים, והמספרות על תוכניתו הנפלאה של אלוהים להביאנו למרומי השמים. עד לפני זמן־מה הייתה תוכניתו זאת בגדר סוד, אף כי תוכננה למעננו ונועדה לנו עוד לפני בריאת העולם. ");
INSERT INTO heblb_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","אבל ”חכמי העולם“ לא הבינו זאת, כי אילו הבינו, לא היו צולבים את אדון הכבוד. ");
INSERT INTO heblb_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","לכך התכוון הפסוק בישעיהו: ”עין לא ראתה, ואוזן לא שמעה, ולא עלה על לב אדם את אשר הכין האלוהים לאוהביו“. ");
INSERT INTO heblb_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","אבל אנחנו יודעים מה הם הדברים הנפלאים האלה, כי אלוהים שלח את רוחו לגלות לנו, והרוח חוקר, מברר הכול ומגלה לנו את סודותיו הכמוסים והנפלאים של אלוהים. ");
INSERT INTO heblb_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","איש אינו יודע מה חושב אדם אחר, מלבד רוח האדם שבו עצמו; ואיש אינו יכול לדעת מה חושב אלוהים, מלבד רוח הקודש. ");
INSERT INTO heblb_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","ואלוהים לא נתן לנו את רוח העולם, כי אם את רוחו שלו – את רוח הקודש, כדי שיגלה לנו מהן המתנות הנפלאות שהעניק לנו ה׳ ברוב חסדו, ובאילו ברכות ברך אותנו. ");
INSERT INTO heblb_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","איננו מספרים לכם על כך במילים שלנו, אלא במילים של רוח הקודש, כלומר, אנו משתמשים במילים מרוח הקודש כדי להסביר דברים רוחניים. ");
INSERT INTO heblb_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","אולם מי שאינו מאמין במשיח, אינו מסוגל להבין את דברי רוח הקודש, והם נשמעים לו מטופשים למדי, כי רק מי ששוכן בו רוח ה׳ מסוגל להבין דברים רוחניים. ");
INSERT INTO heblb_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","ואילו האדם הרוחני – זה שרוח הקודש שוכן בו – בוחן וחוקר כל דבר, בעוד שהוא עצמו אינו נבחן ואינו נידון על־ידי איש. הוא יכול להבין את המשמעות של כל דבר, אולם איש אינו יכול לאמוד ולשפוט אותו. ");
INSERT INTO heblb_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","ודאי תשאלו: איך יכול המאמין להבין הכול, הרי אין הוא מסוגל לקרוא את מחשבותיו של אלוהים או לשוחח איתו על כך? התשובה היא: אנחנו, המאמינים, יודעים את מחשבותיו של אלוהים, מפני שרוח המשיח שוכן בנו. ");
INSERT INTO heblb_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","אחים יקרים, צר לי מאוד שלא יכולתי לפנות אליכם כאל מאמינים מבוגרים המלאים ברוח הקודש, אלא רק כאל תינוקות באמונה, שאינם הולכים אחרי האדון ישוע אלא אחרי תשוקותיהם. ");
INSERT INTO heblb_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","נתתי לכם חלב, כי לא יכולתם ללעוס ולעכל מזון מוצק. אני עדיין צריך להשקות אתכם חלב, ");
INSERT INTO heblb_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","כי עודכם תינוקות רכים באמונה, שנשלטים על־ידי תשוקותיכם ולא על־ידי אלוהים. הקנאה, המריבות והפילוגים מוכיחים שטרם התבגרתם, ושאתם עדיין תינוקות קטנים ועקשנים. למעשה אינכם מתנהגים כלל כנהוג למאמינים משיחיים. ");
INSERT INTO heblb_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","מה פתאום אתם מתווכחים על השאלה: מי חשוב יותר, אפולוס או אני? הרי אתם מפלגים את הקהילה, והתנהגותכם מוכיחה שכלל לא גדלתם באמונתכם. ");
INSERT INTO heblb_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","מה הוויכוח עלי ועל אפולוס? מי אנחנו? אנחנו בסך הכול משרתי אלוהים; לכל אחד מאיתנו מעלות וחסרונות משלו, ואנו הבאנו לכם את דבר המשיח. ");
INSERT INTO heblb_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","תפקידי היה לזרוע בלבכם את דבר־אלוהים, ותפקידו של אפולוס היה להשקות ולטפח. אך אלוהים לבדו הצמיח את אשר נזרע בלבכם. ");
INSERT INTO heblb_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","תפקידו של הזורע או של המשקה אינו החשוב ביותר; תפקידו של אלוהים הוא החשוב ביותר, כי הוא מצמיח ומגדל. ");
INSERT INTO heblb_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","אף כי אפולוס ואני עובדים יחד למען אותה מטרה, כל אחד מאיתנו בנפרד יקבל מאלוהים את הגמול על עמלו הקשה. ");
INSERT INTO heblb_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","אנחנו רק כלים ומכשירים ביד אלוהים. אתם שדה אלוהים ולא שדנו; אתם בניין אלוהים ולא בנייננו. ");
INSERT INTO heblb_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","ברוב חסדו לימד אותי אלוהים את מלאכת הבנייה. אני הנחתי את היסוד, ואפולוס בנה עליו. על כל אחד להיזהר מאוד איך ובמה הוא בונה על היסוד. ");
INSERT INTO heblb_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","איש אינו יכול להניח יסוד אחר מלבד זה שאנו הנחנו – ישוע המשיח! ");
INSERT INTO heblb_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","כל אחד יכול לבנות על היסוד בחומרים שונים: זהב, כסף, אבנים יקרות, ויש הבוחרים לבנות בעץ, בחציר ואפילו בקש! ");
INSERT INTO heblb_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","ביום־הדין עבודתו של כל בונה תיבחן באש, והמבחן יגלה באיזה חומר השתמש הבונה, ואיזה מאמץ השקיע בבנייה. ");
INSERT INTO heblb_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","כל מי שבנה בחומר חזק, יציב ועמיד בפני אש, יקבל את שכרו. ");
INSERT INTO heblb_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","אבל אם הבית שבנה יישרף באש, אובדנו תהיה גדולה, והוא עצמו יינצל בקושי, כמו אוד המוצל משריפה. ");
INSERT INTO heblb_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","האם אינכם מבינים שכולכם יחד מהווים את ביתו של אלוהים, ומשום כך רוח הקודש השוכן בכם שוכן למעשה בבית אלוהים? ");
INSERT INTO heblb_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","אלוהים יעניש את כל מי שמלכלך ומטמא את ביתו, כי בית אלוהים הוא טהור וקדוש, ואתם בית אלוהים! ");
INSERT INTO heblb_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","אל תשלו את עצמכם. החושב את עצמו לחכם ופיקח במושגי העולם הזה, מוטב שיודה כי הוא בעצם טיפש, כדי שיוכל לדרוש את חכמת אלוהים ולהחכים באמת. ");
INSERT INTO heblb_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","שכן חכמת העולם הזה מטופשת בעיני ה׳, ככתוב בספר איוב: ”אלוהים לכד את החכמים בערמם.“ ");
INSERT INTO heblb_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","ובספר תהלים כתוב: ”ה׳ יודע מחשבות חכמים, כי המה הבל“. ");
INSERT INTO heblb_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","על כן אל תתפארו במעשי אדם, כי אלוהים נתן לכם את הכול. ");
INSERT INTO heblb_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","הוא נתן לכם את פולוס, אפולוס ו‎כֵּיפָא כדי שיעזרו לכם. הוא העמיד לרשותכם ולשירותכם את העולם כולו, אפילו את החיים ואת המוות! הוא נתן לכם את כל ההווה וכל העתיד – הכול שייך לכם, ");
INSERT INTO heblb_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","אתם שייכים למשיח והמשיח שייך לאלוהים. ");
INSERT INTO heblb_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","הייתי רוצה שתתייחסו אל אפולוס ואלי כאל משרתי המשיח שהופקדו בידם סודות ה׳. ");
INSERT INTO heblb_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","ומשרת נאמן ניכר בנכונותו לבצע את כל דברי אדוניו. ");
INSERT INTO heblb_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","לא אכפת לי אם אתם חושבים אותי למשרת טוב או לא; בנושא זה איני סומך אפילו על כושר השיפוט של עצמי. ");
INSERT INTO heblb_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","מצפוני אמנם נקי ושקט, אך עובדה זאת אינה הוכחה מספקת. רק אלוהים יכול לבחון אותי ולשפוט. ");
INSERT INTO heblb_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","לכן אל תמהרו להסיק מסקנות אם אדם זה או אחר הוא משרת טוב או לא; חכו לשובו של אדוננו. בבואו של האדון ישוע הוא יחשוף את האופי האמיתי של כל אחד מאתנו, וכולם ידעו מה הניע אותנו לשרת את האדון. באותו מעמד יעניק אלוהים שבחים לכל אחד לפי עבודתו. ");
INSERT INTO heblb_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","נתתי לכם כדוגמה את אפולוס ואותי, מפני שרציתי להדגיש את כוונתי: אל תפלו בין המאמינים! אל תתנשאו אחד על השני בשם שליח מסוים. ");
INSERT INTO heblb_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","מדוע אתם מתגאים כל־כך? האם יש בידכם דבר־מה שלא ניתן לכם על־ידי אלוהים? ואם כל מה שיש לכם בא מאלוהים, מדוע אתם מתנהגים כאנשים חשובים, כאילו כל מה שיש לכם הוא הישג פרטי ובלעדי שלכם? ");
INSERT INTO heblb_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","אתם חושבים שכבר קיבלתם את כל המזון הרוחני הדרוש לכם. אתם מרוצים ממצבכם הרוחני; הכתרתם את עצמכם למלכים בשעה שהיינו רחוקים מכם. הלוואי שבאמת הייתם מלכים בעיני ה׳, כי אז יכולנו למלוך יחד. ");
INSERT INTO heblb_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","לעתים קרובות אני חושב שאלוהים העמיד אותנו, השליחים, בסוף השורה; אנו מוצגים לראווה לפני העולם ולפני המלאכים כאסירים שנידונו למוות. ");
INSERT INTO heblb_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","אתם טוענים כי האמונה עשתה אותנו לטיפשים, ואילו אתם חכמים גדולים! אנחנו חלשים ואילו אתם חזקים מאוד! אנחנו נקלים ואתם מכובדים. ");
INSERT INTO heblb_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","דעו לכם שעד לרגע זה אנו רעבים, צמאים, ללא בגדים חמים, ללא בית משלנו ונזרקים ממקום למקום. ");
INSERT INTO heblb_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","הרווחנו את לחמנו בעמל־כפיים, ברכנו את מי שקילל אותנו, התייחסנו בסבלנות לאלה שפגעו בנו, ");
INSERT INTO heblb_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","דיברנו בשקט כשחרפו אותנו והעלילו עלינו עלילות. למרות הכול, עד לרגע זה מתייחסים אלינו כולם כאל טינופת ואשפה. ");
INSERT INTO heblb_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","איני כותב זאת כדי לבייש אתכם, אלא כדי להזהירכם ולייעץ לכם כילדים אהובים. ");
INSERT INTO heblb_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","אנשים רבים מסוגלים ללמד אתכם את דבר אלוהים, אך זכרו שאני לבדי דואג לכם כאב, שהרי אני הדרכתי אתכם אל המשיח בספרי לכם את הבשורה. ");
INSERT INTO heblb_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","משום כך אני מבקש מכם, אנא, קחו דוגמה ממני. ");
INSERT INTO heblb_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","אני שולח אליכם את טימותיוס כדי שיעזור לכם לעשות זאת. גם אותו הדרכתי אל האדון; הוא בני האהוב והנאמן באמונה, והוא יזכיר לכם מה שאני מלמד בכל הקהילות בהן אני מבקר. ");
INSERT INTO heblb_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","אני יודע כי יש ביניכם כאלה החושבים בטעות שאני פוחד לבוא ולדבר אתכם פנים אל פנים, ומחשבה זאת מכניסה בהם גאווה. ");
INSERT INTO heblb_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","אבל אל תדאגו; אם ירצה ה׳ אבוא אליכם בקרוב, ואז איווכח לדעת אם הגאוותנים האלה הם סתם דברנים גדולים, או אם הם באמת מלאים בכוח אלוהים. ");
INSERT INTO heblb_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","מלכות אלוהים אינה מבוססת על דיבורים, כי אם על מעשים בגבורת אלוהים. ");
INSERT INTO heblb_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","ומה אתם מעדיפים, שאבוא אליכם עם שוט או באהבה וביד רכה? ");
INSERT INTO heblb_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","כולם מדברים על המעשים הנוראים המתרחשים אצלכם. שמעתי שאחד האנשים בקהילתכם מקיים יחסי־מין עם אשת אביו! אפילו הגויים אינם עושים מעשים מכוערים כאלה! ");
INSERT INTO heblb_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","ואתם עוד מתגאים, במקום שתתאבלו מרוב צער ובושה ותסלקו אדם זה מקהילתכם. ");
INSERT INTO heblb_vpl VALUES ("C15_3‏","076_5_3‏","1CO","5","3‏","4","למרות שאני נמצא הרחק מכם הקדשתי לעניין מחשבה רבה, ובשם ישוע המשיח אדוננו כבר החלטתי מה לעשות, כאילו אני עצמי הייתי ביניכם. כנסו את חברי הקהילה – האדון יחזק אתכם ואף אני אהיה אתכם ברוחי ובמחשבתי – ");
INSERT INTO heblb_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","וסלקו חוטא זה מקרבכם. הפקירו אותו בידי השטן כדי שייענש, ונקווה שנפשו תינצל ביום שובו של ישוע המשיח אדוננו. ");
INSERT INTO heblb_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","איך אתם מעזים להתפאר ב”טוהר“ שלכם, בשעה שמתרחשים אצלכם מעשים נוראים כאלה? האם אינכם מבינים שאם אתם מניחים לאדם אחד להמשיך בחטאו, תוך זמן קצר הוא ידביק את כולכם? כי מעט שאור מחמיץ את העיסה כולה! ");
INSERT INTO heblb_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","בערו את החמץ! סלקו את החוטא הרשע משורותיכם כדי שתוכלו להישאר כשרים וטהורים. שה הפסח, המשיח, הוקרב למעננו, ");
INSERT INTO heblb_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","ולכן הבה נחוג את החג – לא בשאור הרשע והעוולה, אלא במצות הטוהר והאמת. ");
INSERT INTO heblb_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","במכתבי הקודם ביקשתי מכם שלא להתחבר עם הרשעים והחוטאים. ");
INSERT INTO heblb_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","לא התכוונתי ללא־מאמינים, המנהלים חיים בלתי־מוסריים, מרמים, גונבים ועובדים את האלילים, שהרי אינכם יכולים לחיות בעולם הזה בלי לבוא איתם במגע. ");
INSERT INTO heblb_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","התכוונתי לכך שלא תתחברו עם אף אדם שטוען שהוא מאמין משיחי, בעוד שהוא מנהל חיים בלתי־מוסריים, או שהוא נוכל, רמאי, עובד אלילים, שתיין או מגדף. אפילו אל תשבו לאכול עם אדם כזה. ");
INSERT INTO heblb_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","אין מתפקידנו לשפוט את הלא־מאמינים, אבל חובתנו לשפוט ולנהוג בחומרה בחברי הקהילה שחוטאים כך. ");
INSERT INTO heblb_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","אלוהים ישפוט את הלא־מאמינים, ואילו אתם – בערו את הרע מקרבכם. ");
INSERT INTO heblb_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","כיצד אתם מביאים את מריבותיכם לבית־המשפט ומבקשים מן הלא־מאמינים לשפוט ביניכם? מדוע אינכם מבקשים מן המאמינים להוציא את הצדק לאור? ");
INSERT INTO heblb_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","הרי אתם יודעים כי יבוא יום שאנחנו, המאמינים, נשפוט את העולם ונשלוט בו, אם כן מדוע אינכם מסוגלים לפתור בעצמכם בעיות קטנות כאלה? ");
INSERT INTO heblb_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","האם אינכם יודעים שנשפוט אפילו את המלאכים בשמים? לכן מן הראוי שתוכלו לפחות לפתור את בעיותיכם אתם בעולם הזה. ");
INSERT INTO heblb_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","מדוע אתם מחפשים את הצדק אצל הלא־מאמינים? ");
INSERT INTO heblb_vpl VALUES ("C16_5‏","076_6_5‏","1CO","6","5‏","6","התביישו לכם! האין ביניכם אדם נבון המסוגל ליישב את הבעיות האלה, לפני שמאמין אחד יתבע את אחיו לדין לפני לא מאמינים? ");
INSERT INTO heblb_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","התנהגות כזאת היא בושה וחרפה! מדוע שלא תניחו לעצמכם להיות הנעלבים, המרומים או הנפגעים? ");
INSERT INTO heblb_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","במקום לנהוג כך, אתם בעצמכם פוגעים, מעליבים ומרמים את הזולת, ואפילו את אחיכם המאמינים. ");
INSERT INTO heblb_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","האם אינכם יודעים כי לאנשים כאלה אין חלק במלכות האלוהים? אל תשלו את עצמכם ואל תעמידו פנים שאינכם יודעים זאת. כל מי שחי חיים לא־מוסריים, עובד אלילים, נואף ומקיים יחסי־מין עם בני מינו, לא ייקח חלק במלכות האלוהים. ");
INSERT INTO heblb_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","גם לגנבים, רודפי בצע, שתיינים, גדפנים, שודדים וגזלנים אין חלק במלכות האלוהים. ");
INSERT INTO heblb_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","בעבר הלא רחוק היו אחדים מכם בין אלה, אולם אלוהים ניקה אתכם מחטאיכם, סלח לכם וקידש אתכם בזכות ישוע המשיח וברוח הקודש. ");
INSERT INTO heblb_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","אתם אומרים: ”מותר לעשות הכול“, אבל לא כל דבר טוב בשבילכם. למרות ”שמותר לי לעשות הכול“, אסור לי להשתעבד לשום דבר. ");
INSERT INTO heblb_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","קחו למשל את עניין האכילה: אלוהים נתן לנו תאבון לאכול ומערכת־עיכול לעכל את המזון, אולם אין זאת אומרת שעלינו לאכול מעל הדרוש לנו. אל תשתעבדו לאכילה, כי יבוא יום שאלוהים ייקח גם את העניין הזה. אין שום הצדקה לזנות ולניאוף! לא לשם כך נברא גופנו; גופנו נברא למען המשיח, והוא רוצה למלא אותו ברוחו. ");
INSERT INTO heblb_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","אלוהים יקים אותנו מן המתים בכוחו העצום, כמו שהקים את אדוננו ישוע המשיח. ");
INSERT INTO heblb_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","האם אינכם מבינים שגופיכם הם איברי המשיח? האם יכול אני להיות חלק מגוף המשיח, ובאותו זמן לקיים יחסים עם זונה? חס וחלילה! ");
INSERT INTO heblb_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","כאשר אדם שוכב עם זונה הוא נעשה חלק ממנה, והיא נעשית חלק ממנו, שהרי ה׳ אמר לנו בכתבי־הקודש שלגביו מתאחדים השניים לבשר אחד, ");
INSERT INTO heblb_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","בעוד שאדם המקדיש את עצמו לאדון, נעשה אחד איתו. ");
INSERT INTO heblb_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","מסיבה זאת אני מבקש בכל לשון של בקשה: רחקו מן הזנות! אף חטא אינו פוגע בעצם גוף החוטא, מלבד חטא הזנות. ");
INSERT INTO heblb_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","האם לא למדתם עדיין שגופכם הוא מקום משכן רוח הקודש שנתן לכם ה׳? גופכם אינו שייך לכם יותר. ");
INSERT INTO heblb_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","מפני שאלוהים קנה אתכם במחיר יקר. על כן כבדו את אלוהים בכל איבר מגופכם השייך לו. ");
INSERT INTO heblb_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","ביקשתם ממני להגיב לרעיון: מוטב לאיש להימנע מיחסים עם אשתו. ");
INSERT INTO heblb_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","אך משום הזנות והתאווה הרובצות בסביבה, כדאי לאיש ולאישה לקיים יחסים ביחד. ");
INSERT INTO heblb_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","על הבעל לתת לאשתו את כל הזכויות המגיעות לה כאישה נשואה, ועל האישה לתת אותן זכויות לבעלה. ");
INSERT INTO heblb_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","כי לאישה נשואה אין כבר זכות בלעדית על גופה – גם לבעלה יש זכות על גופה, ואף לבעל כבר אין זכות בלעדית על גופו, כי גופו שייך גם לאשתו. ");
INSERT INTO heblb_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","לכן אל תמנעו את עצמכם זה מזו, אלא אם שניכם החלטתם להימנע מקיום יחסי־מין למשך זמן מוגבל, כדי שתוכלו להקדיש את עצמכם לתפילה. במקרה כזה, מיד עם תום הזמן המוגבל עליכם לשוב ולקיים יחסים כמו מקודם, כדי שהשטן לא יוכל לפתות אתכם על־ידי תשוקתכם שלא באה על סיפוקה. ");
INSERT INTO heblb_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","אני אומר זאת בדרך של רשות, ולא בדרך של פקודה. ");
INSERT INTO heblb_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","מצדי, הלוואי שכולם יכולתם לחיות ללא נשואים, כמוני. אולם אנו שונים מאוד איש מרעהו. לאחד נותן אלוהים אישה במתנה, ולשני הוא נותן במתנה את היכולת להישאר רווק(ה) ומאושר(ת). ");
INSERT INTO heblb_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","אני פונה אל הרווקים ואל האלמנות: אם אתם יכולים, מוטב שלא תינשאו, כמוני. ");
INSERT INTO heblb_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","אבל אם אינכם יכולים לשלוט ביצריכם – הינשאו! כי מוטב להינשא מאשר לסבול מתשוקה מינית שאינה באה על סיפוקה. ");
INSERT INTO heblb_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","על הנשואים אני מצווה בשם ישוע המשיח ובפקודתו: אסור לאישה לעזוב את בעלה. ");
INSERT INTO heblb_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","אם היא מעדיפה להיפרד מבעלה אסור לה להינשא לאחר, אבל מותר לה לחזור לבעלה הראשון. גם לבעל אסור לגרש את אשתו. ");
INSERT INTO heblb_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","ברצוני להוסיף כמה הצעות משלי. אין אלה מצוות ישירות מהאדון, אך הן נראות צודקות בעיני: אם מאמין משיחי כבר נשוי לאישה שאינה מאמינה, וברצונה להמשיך לחיות איתו, אסור לו לעזוב את אשתו או לגרשה. ");
INSERT INTO heblb_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","אם מאמינה משיחית נשואה לבעל שאינו מאמין, וברצונו להמשיך לחיות איתה, אסור לה לעזוב אותו. ");
INSERT INTO heblb_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","כי האישה המאמינה מביאה קדושה לנישואין, והבעל המאמין מביא איתו קדושה לנישואין. אחרת, ילדיכם לא היו קדושים, אך כעת הם קדושים. ");
INSERT INTO heblb_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","אולם אם הבעל או האישה שאינם מאמינים רוצים להיפרד – מותר לכם להיפרד מהם. במקרה כזה, בן הזוג המאמין אינו צריך לדרוש מהשני להישאר, כי אלוהים רוצה שילדיו יחיו בשלום. ");
INSERT INTO heblb_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","אחרי הכול, מנין לכן לדעת אם בעליכן יבואו לידי אמונה או לא? ואותו הדבר אמור לגבי הבעלים המאמינים ונשותיהם. ");
INSERT INTO heblb_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","החשוב הוא שכל אחד ישמח בחלקו ויהיה מרוצה במצב שאלוהים בחר עבורו – נשוי או לא נשוי. זוהי מצוותי לכל הקהילות. ");
INSERT INTO heblb_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","מי שנימול לפני בואו לאמונה לא צריך להתחרט על כך; מי שלא נימול לפני בואו לאמונה, לא צריך לעשות עכשיו ברית־מילה. ");
INSERT INTO heblb_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","כי המילה אינה חשובה. החשוב הוא לשמור את מצוות האלוהים. ");
INSERT INTO heblb_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","בדרך כלל על כל אחד להישאר באותו מעמד שבו היה כשבא לידי האמונה. ");
INSERT INTO heblb_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","האם אתה עבד? אל תתלונן. אך אם יש לך הזדמנות לצאת לחופשי – אל תחמיץ אותה! ");
INSERT INTO heblb_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","אם אתה עבד והאדון קורא לך, אל תשכח שהמשיח שיחרר אותך מהשעבוד לחטא; אם האדון קורא לך ואתה בן־חורין, אל תשכח שהמשיח שיחרר אותך משעבוד לחטא; אם האדון קורא לך ואתה בן־חורין, אל תשכח שמעתה הינך עבד המשיח. ");
INSERT INTO heblb_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","אתם שייכים למשיח, כי הוא קנה אתכם במחיר יקר, ומשום כך אל תשתעבדו לבני־אדם. ");
INSERT INTO heblb_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","כן, אחים יקרים, לא משנה באיזה מצב הייתם או באיזו משרה עבדתם, כאשר האדון קורא לכם; הישארו במקומכם, כי עכשיו האדון אתכם לחזקכם ולעזור לכם. ");
INSERT INTO heblb_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","בתשובה לשאלתכם השנייה, האם מותר לבתולות להינשא? אין לי הוראה מיוחדת מהאדון. אך מאחר שהעניק לי מתבונתו והוא סומך עלי, אשמח לחוות את דעתי. ");
INSERT INTO heblb_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","בשל הבעיות והצרות הבאות עלינו אני חושב כי מוטב לא להינשא. ");
INSERT INTO heblb_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","מובן שהנשואים אינם צריכים להתגרש מסיבה זו, אך מי שטרם נישא – שלא ימהר עכשיו. ");
INSERT INTO heblb_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","אם הגברים רוצים בכל זאת להינשא עכשיו, מותר להם; ואם הבחורות רוצות להינשא עתה – אין זה חטא! העניין הוא שהנשואים גורמים לבעיות נוספות, ואישית, הייתי רוצה למנוע מכם כעת בעיות אלה. ");
INSERT INTO heblb_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","עלינו לזכור תמיד שזמננו עלי אדמות קצר מאוד. לכן על הגברים הנשואים להיות חופשיים למען האדון, כאילו שאינם נשואים כלל. ");
INSERT INTO heblb_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","אסור שאושר, נכסים או צער ימנעו בעד איש מלשרת את האדון. ");
INSERT INTO heblb_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","על העוסקים בענייני העולם להיזהר שלא לשקוע בו עמוק מדי, כי צורת הדברים בעולם משתנה במהירות. ");
INSERT INTO heblb_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","ברצוני שתהיו חופשיים מדאגה בכל מעשיכם. הרווק יכול לבלות את חייו בעבודת האדון ובמאמץ למצוא־חן בעיניו, ");
INSERT INTO heblb_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","בעוד שגבר נשוי דואג תחילה למלא את חובתו לאשתו, ואין הוא יכול להקדיש את עצמו לאדון כראוי; תשומת לבו מחולקת. ");
INSERT INTO heblb_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","גם לאישה הנשואה יש את אותן הבעיות. הרווקה משתדלת למצוא־חן בעיני האדון בכל מעשיה, ושומרת על טוהר גופה ורוחה; ואילו האישה הנשואה טרודה בבעיות משק הבית, ועליה לשרת את בעלה ולהשתדל למצוא־חן בעיניו. ");
INSERT INTO heblb_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","איני מנסה למנוע בעדכם מלהינשא; אני מנסה לעזור לכם. הייתי רוצה שתבחרו בדרך הטובה והיעילה ביותר לשרת את האדון. ");
INSERT INTO heblb_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","אם מישהו אינו יכול להתגבר על תשוקתו והוא מרגיש צורך להינשא, מותר לו – אין זה חטא. ");
INSERT INTO heblb_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","אך מי שיש לו כוח לא להינשא ומחליט שאין לו צורך בנשואים, החליט החלטה נבונה מאוד. ");
INSERT INTO heblb_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","מסקנה: טוב להינשא, אך טוב יותר לא להינשא. ");
INSERT INTO heblb_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","האישה קשורה לבעלה כל עוד הוא חי; אם בעלה נפטר היא רשאית להינשא שנית – אבל רק למאמין משיחי! ");
INSERT INTO heblb_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","אך לדעתי היא תהיה מאושרת יותר אם לא תינשא בשנית, וחושבני שאין זו דעתי בלבד, אלא גם רצון רוח הקודש השוכן בי. ");
INSERT INTO heblb_vpl VALUES ("C18_1","076_8_1","1CO","8","1","1","שאלתכם הבאה הייתה בנוגע לאכילת מזון שהוקרב לאלילים. כל אחד מכם חושב שהוא לבדו יודע את התשובה לבעיה זו, אך דעו לכם שחשיבות עצמית רק מוסיפה לנו גאווה, ואילו כדי לבנות את הקהילה אנו זקוקים לאהבה ולא לגאווה. ");
INSERT INTO heblb_vpl VALUES ("C18_2","076_8_2","1CO","8","2","2","אדם שחושב שהוא יודע את כל התשובות רק מוכיח את בורותו. ");
INSERT INTO heblb_vpl VALUES ("C18_3","076_8_3","1CO","8","3","3","ואילו אדם האוהב את אלוהים באמת, מוכן תמיד לשמוע בקולו ולהקשיב לדבריו, ובכך ניכר בו חותם אלוהים. ");
INSERT INTO heblb_vpl VALUES ("C18_4","076_8_4","1CO","8","4","4","באשר לעצם השאלה אם מותר לנו לאכול מזון שהוקרב לאלילים, כולנו יודעים שאליל אינו אל אמיתי, וכי יש רק אל אחד ויחיד. ");
INSERT INTO heblb_vpl VALUES ("C18_5","076_8_5","1CO","8","5","5","יש אנשים המאמינים בקיומם של אלים רבים בשמים ובארץ. ");
INSERT INTO heblb_vpl VALUES ("C18_6","076_8_6","1CO","8","6","6","אבל אנחנו יודעים שיש רק אל אחד – הלא הוא אבינו שבשמים, אשר ברא את הכול ובחר בנו להיות ילדיו; ויש רק אדון אחד – הלא הוא ישוע המשיח, אשר עשה את הכול ואף העניק לנו את חיינו. ");
INSERT INTO heblb_vpl VALUES ("C18_7","076_8_7","1CO","8","7","7","מאמינים רבים עדיין אינם מבינים זאת. הם תמיד חשבו את האלילים ליצורים חיים, ומשום כך חשבו כי המזון שהוקרב לאלילים הוקרב לאל חי ואמיתי. מסיבה זאת מציק להם מצפונם בשעה שהם אוכלים מזון זה. ");
INSERT INTO heblb_vpl VALUES ("C18_8","076_8_8","1CO","8","8","8","לאלוהים אין זה משנה אם אנו אוכלים מזון שהוקרב לאלילים או לא; אכילתו אינה מוסיפה לנו ואינה גורעת מאיתנו. ");
INSERT INTO heblb_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","אך היזהרו שהרשות שיש לכם לאכול לא תהיה מכשול למאמין אחר שמצפונו חלש משלכם. ");
INSERT INTO heblb_vpl VALUES ("C18_10","076_8_10","1CO","8","10","10","כי אח החושב שאסור לאכול מזון כזה עלול לראותך סועד בבית־אלילים, וגם הוא יאזור אומץ ויאכל מזון זה, אך מצפונו יציק לו. ");
INSERT INTO heblb_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","וכך, מאחר שאתה יודע כי מותר לך לאכול מזון זה, תגרום נזק רוחני רב לאח בעל מצפון חלש, (שאינו יודע כי מותר לו לאכול) ואל תשכח שהמשיח מת גם בעדו. ");
INSERT INTO heblb_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","לפיכך, אם אתה מעודד את אחיך לעשות מעשה הנחשב בעיניו לחטא, אתה חוטא נגד ישוע המשיח. ");
INSERT INTO heblb_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","על כן אם אכילת מזון שהוקרב לאלילים נחשבת לחטא בעיני אחי, לא אוכל מזון זה כל חיי, כי איני רוצה להכשילו. ");
INSERT INTO heblb_vpl VALUES ("C19_1","076_9_1","1CO","9","1","1","האם אינני אדם חופשי? האם אינני שליח האדון? האם לא ראיתי את האדון ישוע במו עיני? האם לא אני הבאתי אתכם לאמונה במשיח? ");
INSERT INTO heblb_vpl VALUES ("C19_2","076_9_2","1CO","9","2","2","אולי לא נשלחתי אל אנשים אחרים, אך ללא ספק נשלחתי אליכם, שהרי באתם לאמונה במשיח באמצעותי. ");
INSERT INTO heblb_vpl VALUES ("C19_3","076_9_3","1CO","9","3","3","זוהי תשובתי למטילים בי ספק. ");
INSERT INTO heblb_vpl VALUES ("C19_4","076_9_4","1CO","9","4","4","האם אין לי בכלל זכויות? האם איני רשאי להתארח בבתיכם כמו השליחים האחרים? ");
INSERT INTO heblb_vpl VALUES ("C19_5","076_9_5","1CO","9","5","5","האם אין לנו זכות לשאת אישה מאמינה, כמו השליחים האחרים ואחי האדון וגם ‎כֵּיפָא? ");
INSERT INTO heblb_vpl VALUES ("C19_6","076_9_6","1CO","9","6","6","האם רק בר־נבא ואני מוכרחים להמשיך לעבוד לפרנסתנו, בעוד שאתם תומכים בכסף בשליחים האחרים? ");
INSERT INTO heblb_vpl VALUES ("C19_7","076_9_7","1CO","9","7","7","איזה חייל משלם מכיסו את הוצאותיו בתפקיד? או האם שמעתם פעם על כורם שאינו רשאי לטעום מהענבים שגידל? איזה רועה אינו רשאי לשתות מעט מחלב העדר שעליו הוא שומר? ");
INSERT INTO heblb_vpl VALUES ("C19_8","076_9_8","1CO","9","8","8","אינני מצטט לכם כללים שהומצאו על־ידי בני־אדם; אני מצטט לכם את דבר ה׳! ");
INSERT INTO heblb_vpl VALUES ("C19_9","076_9_9","1CO","9","9","9","הרי כתוב בתורת משה: ”לא תחסם שור בדישו“. הסבורים אתם שה׳ חשב רק על השור כשציווה זאת? ");
INSERT INTO heblb_vpl VALUES ("C19_10","076_9_10","1CO","9","10","10","האם לא חשב אלוהים גם עלינו? ברור שכן! אלוהים רצה ללמדנו שהמאמינים שעובדים למען האדון ללא משכורת, צריכים לקבל תמיכה כלכלית מאלה המנצלים את שירותיהם. גם לחורש וגם לקוצר מגיע שכר מהיבול. ");
INSERT INTO heblb_vpl VALUES ("C19_11","076_9_11","1CO","9","11","11","אנחנו זרענו בלבכם זרע רוחני. האם אנו מגזימים בבקשנו בתמורה מעט מזון ובגדים? ");
INSERT INTO heblb_vpl VALUES ("C19_12","076_9_12","1CO","9","12","12","אתם מספקים מזון ובגדים לשליחים האחרים המלמדים אתכם, ואתם נוהגים כהלכה, אך האין זכותנו גדולה משלהם? למרות זאת מעולם לא ניצלנו זכות זאת, אלא סיפקנו בעצמנו את כל צרכינו ללא עזרתכם. מעולם לא דרשנו תמורה, מחשש שבגלל דרישה זאת תפסיקו את התעניינותכם בבשורת המשיח שהבאנו לכם. ");
INSERT INTO heblb_vpl VALUES ("C19_13","076_9_13","1CO","9","13","13","האם אינכם יודעים שאלוהים נתן רשות לעובדי בית־המקדש לקחת לעצמם מה שהם צריכים מבין המנחות שהוקרבו לאלוהים? גם משרתי המזבח מקבלים חלק מהמזון המוקרב לה׳. ");
INSERT INTO heblb_vpl VALUES ("C19_14","076_9_14","1CO","9","14","14","באותה דרך ציווה אלוהים שמטיפי הבשורה יקבלו תמיכה מהשומעים. ");
INSERT INTO heblb_vpl VALUES ("C19_15","076_9_15","1CO","9","15","15","ובכל זאת, מעולם לא ביקשתי מכם אגורה אחת! וגם עכשיו איני מנסה לרמוז לכם במכתבי שברצוני לקבל מהיום והלאה את המגיע לי. למעשה אני מעדיף לגווע ברעב, מאשר לאבד את הסיפוק וההנאה שיש לי מכך שאני מלמד אתכם חינם, ללא כל תשלום או תמורה. ");
INSERT INTO heblb_vpl VALUES ("C19_16","076_9_16","1CO","9","16","16","אין לי סיבה להתפאר בהטפת הבשורה, שכן זוהי חובתי ואוי לי אם לא אבשר אותה. ");
INSERT INTO heblb_vpl VALUES ("C19_17","076_9_17","1CO","9","17","17","אילו הייתי מתנדב מרצוני לשרת את האדון, אולי היה האדון מעניק לי שכר מיוחד. אך מצבי שונה: אלוהים עצמו בחר בי והפקיד בידי את הבשורה, ומשום כך אין לי ברירה. ");
INSERT INTO heblb_vpl VALUES ("C19_18","076_9_18","1CO","9","18","18","מהו שכרי בנסיבות אלה? שכרי הוא השמחה והסיפוק שאני מקבל מהפצת הבשורה בחינם, ללא כל גמול ומבלי לדרוש משהו בחזרה. ");
INSERT INTO heblb_vpl VALUES ("C19_19","076_9_19","1CO","9","19","19","למצב כזה יש יתרון חשוב מאוד: איני חייב דבר לאיש, כי איש אינו משלם לי שכר. ובכל זאת בחרתי מרצוני החופשי להיות עבד לכולם, כדי שאוכל להביא את בני־האדם לאמונה במשיח. ");
INSERT INTO heblb_vpl VALUES ("C19_20","076_9_20","1CO","9","20","20","עם היהודים אני מתנהג כיהודי, כדי שאוכל לרכוש את אמונם ולספר להם על אודות המשיח. אינני מתווכח עם הגרים ששומרים את חוקי התורה, למרות שאיני מסכים איתם, כי ברצוני לעזור להם. ");
INSERT INTO heblb_vpl VALUES ("C19_21","076_9_21","1CO","9","21","21","בהיותי בין הגויים אני משתף איתם פעולה, כל עוד איני עושה דבר שנוגד את אמונתי. כך אני רוחש את אמונם ויכול לעזור להם. ");
INSERT INTO heblb_vpl VALUES ("C19_22","076_9_22","1CO","9","22","22","בהיותי בין אלה שמצפונם מציק להם על כל דבר קטן, איני מתנהג כ”יודע הכול“ ואיני מזלזל בהם. משום כך הם מניחים לי לעזור להם. אתם רואים שאני משתדל למצוא מכנה־משותף עם כל אחד, כדי שאוכל לספר לו על המשיח, וכך יוכל להיוושע. ");
INSERT INTO heblb_vpl VALUES ("C19_23","076_9_23","1CO","9","23","23","מדוע אני טורח כל־כך? – כדי שבני־האדם ישמעו את הבשורה, וכדי שאני עצמי אתברך כאשר אראה אותם באים לאמונה במשיח. ");
INSERT INTO heblb_vpl VALUES ("C19_24","076_9_24","1CO","9","24","24","ידוע לכם שבכל מרוץ יש מתחרים רבים, אבל רק אחד מנצח וזוכה בפרס. רוצו גם אתם כך במטרה לזכות בפרס. ");
INSERT INTO heblb_vpl VALUES ("C19_25","076_9_25","1CO","9","25","25","אם ברצונכם לנצח בתחרות, עליכם להתכחש לעצמכם, ולשכוח את כל מה שעלול להפריע לכם במרוץ. ");
INSERT INTO heblb_vpl VALUES ("C19_26","076_9_26","1CO","9","26","26","לכן אני רץ ישר למטרה, ולכל צעד קדימה יש משמעות גדולה. אני נלחם כדי לנצח. אני מתייחס למרוץ ברצינות רבה ובכובד ראש. ");
INSERT INTO heblb_vpl VALUES ("C19_27","076_9_27","1CO","9","27","27","אני מקשיח על גופי ככל הספורטאים – אני מאמנו לעשות מה שהוא צריך ולא מה שהוא רוצה. אחרת אני חושש שמא, לאחר שהטפתי לאחרים, אני עצמי אפסל ולא אוכל להשתתף במרוץ. ");
INSERT INTO heblb_vpl VALUES ("C110_1","076_10_1","1CO","10","1","1","אחים יקרים, אל תשכחו מה קרה לעם ישראל במדבר לפני שנים רבות. אלוהים שלח לפניהם את הענן, אשר שימש להם מורה־דרך, וכולם חצו בשלום את ים־סוף. ");
INSERT INTO heblb_vpl VALUES ("C110_2","076_10_2","1CO","10","2","2","כל אחד מהם נטבל בים ובענן למשה מנהיגם. ");
INSERT INTO heblb_vpl VALUES ("C110_3","076_10_3","1CO","10","3","3","הם אכלו את האוכל שסיפק להם ה׳ בדרך על־טבעית, ");
INSERT INTO heblb_vpl VALUES ("C110_4","076_10_4","1CO","10","4","4","ושתו מהסלע הרוחני שליווה אותם בכל מסעם. סלע זה היה המשיח! ");
INSERT INTO heblb_vpl VALUES ("C110_5","076_10_5","1CO","10","5","5","למרות נפלאות אלה לא שמעו רבים מהם בקול אלוהים, ולכן הענישם והשמידם במדבר. ");
INSERT INTO heblb_vpl VALUES ("C110_6","076_10_6","1CO","10","6","6","מקרה זה משמש לנו לקח ואזהרה שאסור לנו לשאוף כמוהם למעשים רעים, ");
INSERT INTO heblb_vpl VALUES ("C110_7","076_10_7","1CO","10","7","7","ואף לא לעבוד את האלילים כמו אחדים מהם. הכתובים מספרים לנו שהאנשים אכלו, שתו ורקדו בשעה שהשתחוו לעגל הזהב. ");
INSERT INTO heblb_vpl VALUES ("C110_8","076_10_8","1CO","10","8","8","אנו יכולים ללמוד לקח נוסף: אחדים מהגברים בקרב העם קיימו יחסים עם נשים זרות, ומשום כך ה׳ הענישם והשמיד 23,000 מהם ביום אחד! ");
INSERT INTO heblb_vpl VALUES ("C110_9","076_10_9","1CO","10","9","9","אל תעמידו בניסיון את סבלנותו של אלוהים, כמו בני־ישראל, כי ה׳ שלח נחשים ארסיים שיהרגו בהם. ");
INSERT INTO heblb_vpl VALUES ("C110_10","076_10_10","1CO","10","10","10","אל תתלוננו, כמו בני־ישראל, כי זאת הסיבה ששלח את מלאכו להשמידם. ");
INSERT INTO heblb_vpl VALUES ("C110_11","076_10_11","1CO","10","11","11","כל הדברים האלה קרו להם כדי ללמד אותנו לקח – להזהירנו שלא נחזור על אותן טעויות. הכול נשמר בכתב כדי שנוכל לקרוא וללמוד מכך. ");
INSERT INTO heblb_vpl VALUES ("C110_12","076_10_12","1CO","10","12","12","לכן היזהרו! מי שחושב: ”לי זה לא יכול לקרות!“ – שלא ישכח את האזהרה הזאת, כי גם הוא עלול להיכשל. ");
INSERT INTO heblb_vpl VALUES ("C110_13","076_10_13","1CO","10","13","13","אין כל חדש בשאיפות הרעות שבלבכם; אנשים רבים התנסו בדיוק באותן בעיות זמן רב לפניכם. על כל פיתוי ניתן להתגבר, ואתם יכולים לסמוך על אלוהים שלא יעמיד בפניכם פיתוי שאינכם מסוגלים לעמוד בפניו, שכן הוא הבטיח לכם זאת, ואלוהים מקיים את הבטחותיו. הוא יראה לכם כיצד להיחלץ מכוח הפיתוי ולהחזיק מעמד. ");
INSERT INTO heblb_vpl VALUES ("C110_14","076_10_14","1CO","10","14","14","לכן, אחים יקרים, התרחקו מכל עבודת אלילים. ");
INSERT INTO heblb_vpl VALUES ("C110_15","076_10_15","1CO","10","15","15","אנשים נבונים אתם; שפטו בעצמכם אם אני צודק או לא: ");
INSERT INTO heblb_vpl VALUES ("C110_16","076_10_16","1CO","10","16","16","כאשר אנו מברכים על היין בסעודת־האדון, האם אין זאת אומרת שלכל השותים יש חלק בברכה שבדם המשיח? וכאשר אנו בוצעים את הלחם, האין זאת אומרת שכל הנוטל פרוסה לוקח חלק בברכות שבגוף המשיח? ");
INSERT INTO heblb_vpl VALUES ("C110_17","076_10_17","1CO","10","17","17","אנחנו, הרבים, מהווים גוף אחד, כי לכולנו יש חלק בלחם האחד שבצענו. ");
INSERT INTO heblb_vpl VALUES ("C110_18","076_10_18","1CO","10","18","18","גם היהודים הלוקחים חלק באכילת הקורבנות מתאחדים במעשה זה. ");
INSERT INTO heblb_vpl VALUES ("C110_19","076_10_19","1CO","10","19","19","איני מנסה לומר שעובדי האלילים מקריבים קורבנות לאלילים, ושלקורבנות יש ערך ממשי. ");
INSERT INTO heblb_vpl VALUES ("C110_20","076_10_20","1CO","10","20","20","אני מנסה לומר לכם שעובדי האלילים מקריבים את קורבנותיהם לשדים, ואיני רוצה שאיש מכם יתחבר עם השדים. ");
INSERT INTO heblb_vpl VALUES ("C110_21","076_10_21","1CO","10","21","21","אינכם יכולים להשתתף בסעודת האדון ובסעודת השטן גם יחד. ");
INSERT INTO heblb_vpl VALUES ("C110_22","076_10_22","1CO","10","22","22","מדוע אתם מנסים לעורר את זעמו של אלוהים? האם אתם חזקים ממנו? ");
INSERT INTO heblb_vpl VALUES ("C110_23","076_10_23","1CO","10","23","23","אתם אומרים ”מותר לעשות הכול“, אבל לא הכול טוב בשבילכם. אתם אומרים ”מותר לעשות הכול“, אך לא הכול מועיל. ");
INSERT INTO heblb_vpl VALUES ("C110_24","076_10_24","1CO","10","24","24","אל תחשבו רק על עצמכם; חשבו גם על אחרים ועל מה שטוב בשבילם. ");
INSERT INTO heblb_vpl VALUES ("C110_25","076_10_25","1CO","10","25","25","אזי מותר לכם לאכול כל בשר שנמכר לכם בשוק מבלי לעורר שאלות של מצפון. ");
INSERT INTO heblb_vpl VALUES ("C110_26","076_10_26","1CO","10","26","26","הלא האדמה וכל טובה שייכים לה׳, והכול נברא להנאתכם. ");
INSERT INTO heblb_vpl VALUES ("C110_27","076_10_27","1CO","10","27","27","אם אדם לא־מאמין מזמין אותך לארוחה, היענה להזמנה (אם אתה רוצה), אכול כל מה שמוגש לפניך ואל תשאל שאלות של מצפון. ");
INSERT INTO heblb_vpl VALUES ("C110_28","076_10_28","1CO","10","28","28","אבל אם מישהו יזהירך מראש שאוכל זה הוקרב לאלילים, אל תאכל אותו! למען האיש שהעיר את תשומת לבך ולמען מצפונו. ");
INSERT INTO heblb_vpl VALUES ("C110_29","076_10_29","1CO","10","29","29","במקרה כזה רגשותיו חשובים משלך. אל תאמר: ”מדוע עלי להתחשב ברגשותיהם של אחרים, ");
INSERT INTO heblb_vpl VALUES ("C110_30","076_10_30","1CO","10","30","30","בשעה שאני יכול להודות לאלוהים על המזון וליהנות ממנו? מדוע עלי להניח למישהו לקלקל את הנאתי רק משום שהוא חושב כי טעות בידי?“ ");
INSERT INTO heblb_vpl VALUES ("C110_31","076_10_31","1CO","10","31","31","מפני שכל מה שאתה עושה, שותה או אוכל צריך להיעשות למען כבוד אלוהים. ");
INSERT INTO heblb_vpl VALUES ("C110_32","076_10_32","1CO","10","32","32","לכן אל תהיה מכשול לאיש: ליהודי, לגוי או למאמין המשיחי. ");
INSERT INTO heblb_vpl VALUES ("C110_33","076_10_33","1CO","10","33","33","גם אני נוהג כך. אני משתדל לא לפגוע באיש, אלא לעשות מה שמוצא־חן בעיני אחרים ולא בעיני; איני מבקש את טובתי אלא את טובת אחרים, מתוך רצון שייוושעו. ");
INSERT INTO heblb_vpl VALUES ("C111_1","076_11_1","1CO","11","1","1","לכו בעקבותיי, כשם שאני הולך בעקבות המשיח. ");
INSERT INTO heblb_vpl VALUES ("C111_2","076_11_2","1CO","11","2","2","אחים יקרים, אני שמח כל־כך שאתם זוכרים ואף מקיימים את כל מה שלימדתי אתכם. ");
INSERT INTO heblb_vpl VALUES ("C111_3","076_11_3","1CO","11","3","3","ברצוני רק להזכירכם שכל איש מאמין נתון למרות המשיח, האישה נתונה למרות האיש, והמשיח נתון למרות אלוהים. ");
INSERT INTO heblb_vpl VALUES ("C111_4","076_11_4","1CO","11","4","4","לכן, אדם המסרב להסיר את כובעו בעת תפילה, לימוד או דרשה, מבזה את המשיח. ");
INSERT INTO heblb_vpl VALUES ("C111_5","076_11_5","1CO","11","5","5","אך אישה מבזה את ראשה אם היא מתפללת או מתנבאת בציבור בלי לכסות את ראשה, כי זה כמו שהיא מגלחת את שער ראשה. ");
INSERT INTO heblb_vpl VALUES ("C111_6","076_11_6","1CO","11","6","6","אישה המסרבת לכסות את ראשה צריכה לגלח את שערה, ואם היא מתביישת להיראות בציבור מגולחת, עליה לכסות את ראשה. ");
INSERT INTO heblb_vpl VALUES ("C111_7","076_11_7","1CO","11","7","7","הגבר אינו צריך לכסות את ראשו, כי האישה היא כבוד האיש, וכבוד האלוהים הוא האדם שנברא בצלמו. ");
INSERT INTO heblb_vpl VALUES ("C111_8","076_11_8","1CO","11","8","8","אל תשכחו שהאדם הראשון לא נברא מהאישה, אלא האישה הראשונה נבראה מהאדם. ");
INSERT INTO heblb_vpl VALUES ("C111_9","076_11_9","1CO","11","9","9","אדם לא נברא למען חוה, כי אם חוה נבראה למען אדם. ");
INSERT INTO heblb_vpl VALUES ("C111_10","076_11_10","1CO","11","10","10","לכן צריכה האישה לכסות את ראשה כסימן כניעתה לבעלה, ובגלל המלאכים. ");
INSERT INTO heblb_vpl VALUES ("C111_11","076_11_11","1CO","11","11","11","אנו יודעים שאלוהים ברא את הגבר והאישה זה למען זה, והם זקוקים איש לרעהו. ");
INSERT INTO heblb_vpl VALUES ("C111_12","076_11_12","1CO","11","12","12","האישה הראשונה נבראה אמנם מהאיש, אך מאותו יום ואילך נולדו כל הגברים מנשים. והגבר והאישה גם יחד נבראו על־ידי אלוהים. ");
INSERT INTO heblb_vpl VALUES ("C111_13","076_11_13","1CO","11","13","13","אמרו אתם, האם נאה לאישה להתפלל בציבור ללא כיסוי ראש? ");
INSERT INTO heblb_vpl VALUES ("C111_14‏","076_11_14‏","1CO","11","14‏","15","האין הגיונכם אומר שראש האישה צריך להיות מכוסה? הלא הנשים מתגאות בשיערן, בעוד שגבר בעל שיער ארוך נוטה להתבייש בו. ");
INSERT INTO heblb_vpl VALUES ("C111_16","076_11_16","1CO","11","16","16","אם מישהו מעוניין להתווכח בנושא זה, אני אומר שפשוט אין לנו נוהג אחר, וגם לא בקהילות אחרות. ");
INSERT INTO heblb_vpl VALUES ("C111_17","076_11_17","1CO","11","17","17","בהזדמנות זאת ברצוני להתייחס לשמועות המהלכות עליכם. שמעתי שכאשר אתם מתאספים יחד יש ביניכם חילוקי דעות ומריבות. ");
INSERT INTO heblb_vpl VALUES ("C111_18","076_11_18","1CO","11","18","18","אנשים רבים סיפרו לי על חילוקי הדעות ועל הוויכוחים שמתנהלים בעת האסיפות שלכם. אני בהחלט נוטה להאמין לחלק מהשמועות, ");
INSERT INTO heblb_vpl VALUES ("C111_19","076_11_19","1CO","11","19","19","כי צריכות להיות ביניכם דעות שונות, כדי שאלה מכם הדבקים באמת בכל מחיר יהיו מוכרים לציבור. ");
INSERT INTO heblb_vpl VALUES ("C111_20","076_11_20","1CO","11","20","20","כאשר אתם מתאספים יחד, אינכם אוכלים את סעודת־האדון כפי שציוונו המשיח, אלא אתם אוכלים את סעודתכם שלכם. ");
INSERT INTO heblb_vpl VALUES ("C111_21","076_11_21","1CO","11","21","21","סיפרו לי כי יש ביניכם כאלה שחוטפים וזוללים את כל האוכל המגיע לידיהם, בלי להשאיר לאחרים, וכך אחדים הולכים לביתם שבעים ושיכורים, ואילו אחרים הולכים לביתם רעבים וצמאים. ");
INSERT INTO heblb_vpl VALUES ("C111_22","076_11_22","1CO","11","22","22","מה קורה פה? האם אינכם יכולים לאכול ולשתות בבית, כדי לא לבייש את העניים שאין באפשרותם לקנות אוכל? מה אני יכול לומר על התנהגות כזאת? אני מקווה שאינכם מצפים ממני לטפיחה על השכם בזכות התנהגותכם ”הטובה“! ");
INSERT INTO heblb_vpl VALUES ("C111_23","076_11_23","1CO","11","23","23","אני חוזר ואומר לכם מה שציווה האדון עצמו בנוגע לסעודה שלו: בערב שבו הוסגר האדון על־ידי יהודה, הוא לקח לחם, ");
INSERT INTO heblb_vpl VALUES ("C111_24","076_11_24","1CO","11","24","24","הודה לאלוהים עליו, פרס את הלחם לפרוסות, הגיש לתלמידיו ואמר: ”זהו גופי הניתן בעדכם. עשו זאת לזיכרוני.“ ");
INSERT INTO heblb_vpl VALUES ("C111_25","076_11_25","1CO","11","25","25","לאחר הסעודה הוא לקח גם את כוס היין ואמר: ”כוס זאת מסמלת את הברית החדשה – ברית שנחתמה בדמי. עשו זאת לזיכרוני בכל פעם שתשתו.“ ");
INSERT INTO heblb_vpl VALUES ("C111_26","076_11_26","1CO","11","26","26","כי בכל פעם שאתם אוכלים את הלחם הזה ושותים מהכוס הזאת, אתם מזכירים את מותו למעננו. עשו זאת עד שובו אלינו. ");
INSERT INTO heblb_vpl VALUES ("C111_27","076_11_27","1CO","11","27","27","כל האוכל מהלחם הזה והשותה מכוס האדון ללא כבוד ויראה, יואשם בחטא נגד גוף המשיח ודמו. ");
INSERT INTO heblb_vpl VALUES ("C111_28","076_11_28","1CO","11","28","28","על כל אחד לבחון את עצמו לפני שיאכל מן הלחם וישתה מן היין, ");
INSERT INTO heblb_vpl VALUES ("C111_29","076_11_29","1CO","11","29","29","כי כל מי שאוכל מן הלחם ושותה מן היין ללא כבוד ויראה, ובלי לייחס חשיבות רבה למות המשיח, מקל בערכו של המשיח ומבזה את גופו, ומשום כך אלוהים ישפוט אותו. ");
INSERT INTO heblb_vpl VALUES ("C111_30","076_11_30","1CO","11","30","30","זאת למעשה הסיבה לכך שרבים מכם חלשים וחולים ויש אפילו שמתו. ");
INSERT INTO heblb_vpl VALUES ("C111_31","076_11_31","1CO","11","31","31","ברם אם תבחנו את עצמכם בזהירות לפני סעודת האדון, לא תישפטו ולא תיענשו. ");
INSERT INTO heblb_vpl VALUES ("C111_32","076_11_32","1CO","11","32","32","דעו לכם שאם ה׳ שופט ומעניש אותנו, הוא עושה זאת כדי שלא נישפט עם אנשי העולם. ");
INSERT INTO heblb_vpl VALUES ("C111_33","076_11_33","1CO","11","33","33","לפיכך, אחים יקרים, כשנפגשים אתם לסעודת האדון חכו איש לרעהו; ");
INSERT INTO heblb_vpl VALUES ("C111_34","076_11_34","1CO","11","34","34","מי שרעב, מוטב שיאכל בבית לפני בואו, כדי שלא יביא משפט על עצמו. את שאר הדברים שרציתי לומר אומר לכם פנים אל פנים, כשאבוא אליכם. ");
INSERT INTO heblb_vpl VALUES ("C112_1","076_12_1","1CO","12","1","1","אחים יקרים, כדי למנוע אי־הבנות, הייתי רוצה לכתוב לכם על המתנות והכישרונות המיוחדים שמעניק רוח הקודש לכל אחד מאיתנו. ");
INSERT INTO heblb_vpl VALUES ("C112_2","076_12_2","1CO","12","2","2","אתם זוכרים ודאי כי לפני שהאמנתם במשיח עברתם מאליל לאליל אולם אף אחד מהם לא היה מסוגל להוציא הגה מפיו. ");
INSERT INTO heblb_vpl VALUES ("C112_3","076_12_3","1CO","12","3","3","אילו עתה פוגשים אתם אנשים רבים שטוענים שהם מנבאים בשם ה׳. כיצד תוכלו לדעת אם הם נביאי שקר או נביאי אמת? ובכן, דעו לכם שאיש אינו יכול לדבר ברוח הקודש ולחרף את המשיח, ואיש אינו יכול לקרוא לישוע ”אדון“ (ובאמת להתכוון לכך) אלא בעזרת רוח הקודש. ");
INSERT INTO heblb_vpl VALUES ("C112_4","076_12_4","1CO","12","4","4","אותו רוח הקודש מעניק לכל אחד מאיתנו מתנות וכישרונות שונים ורבים. ");
INSERT INTO heblb_vpl VALUES ("C112_5","076_12_5","1CO","12","5","5","אך כל השירותים השונים והרבים נועדו לשרת אדון אחד – ישוע המשיח! ");
INSERT INTO heblb_vpl VALUES ("C112_6","076_12_6","1CO","12","6","6","פעולות שונות ורבות נעשות בנו ובאמצעותנו על־ידי אלוהינו היחיד. ");
INSERT INTO heblb_vpl VALUES ("C112_7","076_12_7","1CO","12","7","7","רוח הקודש מגלה את כוחו של ה׳ בכל אחד מאיתנו לתועלת הקהילה כולה: ");
INSERT INTO heblb_vpl VALUES ("C112_8","076_12_8","1CO","12","8","8","רוח הקודש מעניק לאחד כישרון לייעץ חכמה, ואותו רוח הקודש מעניק לאחר דבר דעת בהתגלות. ");
INSERT INTO heblb_vpl VALUES ("C112_9","076_12_9","1CO","12","9","9","לזה הוא מעניק אמונה חזקה במיוחד, ולזה – את המתנה לרפא חולים. ");
INSERT INTO heblb_vpl VALUES ("C112_10","076_12_10","1CO","12","10","10","יש שניתן להם הכוח לחולל נסים, ויש שניתנים להם הכישרון והמתנה לנבא. לאחרים הוא העניק את היכולת והכישרון להבדיל בין רוח שקר לרוח אמת. יש אנשים שמסוגלים לדבר בשפות זרות שלא למדו מעולם, ואחרים (שאף הם לא למדו שפות אלה) מסוגלים לפרש אותן. ");
INSERT INTO heblb_vpl VALUES ("C112_11","076_12_11","1CO","12","11","11","אותו רוח הקודש מעניק לנו את כל המתנות והכישרונות האלה לפי ראות עיניו. ");
INSERT INTO heblb_vpl VALUES ("C112_12","076_12_12","1CO","12","12","12","כשם שגופנו מורכב מאיברים רבים, כך מורכב גם ”גוף“ המשיח. ");
INSERT INTO heblb_vpl VALUES ("C112_13","076_12_13","1CO","12","13","13","כל אחד מאיתנו הוא חלק מגוף המשיח: יש בינינו יהודים, גויים, עבדים ובני־חורין, אולם רוח הקודש איחד את כולנו לגוף אחד; כולנו נטבלנו לגוף המשיח ברוח אחד – הלא הוא רוח הקודש ששוכן בכולנו. ");
INSERT INTO heblb_vpl VALUES ("C112_14","076_12_14","1CO","12","14","14","אכן, הגוף מורכב מאיברים רבים, ולא רק מאיבר אחד. ");
INSERT INTO heblb_vpl VALUES ("C112_15","076_12_15","1CO","12","15","15","נניח שהרגל תאמר: ”איני שייכת לגוף, כי אינני יד!“ האם היא באמת אינה שייכת לגוף? ");
INSERT INTO heblb_vpl VALUES ("C112_16","076_12_16","1CO","12","16","16","או אם האוזן תאמר: ”אינני שייכת לגוף, כי אני רק אוזן ולא עין!“ האם היא באמת אינה שייכת לגוף? ");
INSERT INTO heblb_vpl VALUES ("C112_17","076_12_17","1CO","12","17","17","אילו היה כל הגוף עין, כיצד יכולנו לשמוע? או אילו היה כל הגוף אוזן אחת גדולה, כיצד יכולנו להריח? ");
INSERT INTO heblb_vpl VALUES ("C112_18","076_12_18","1CO","12","18","18","אולם תודה לאל על שברא איברים רבים ושונים לגופנו, ועל שקבע כל איבר במקומו המתאים. ");
INSERT INTO heblb_vpl VALUES ("C112_19","076_12_19","1CO","12","19","19","תארו לעצמכם מה מצחיק היה מראנו אילו גופנו היה איבר אחד בלבד! ");
INSERT INTO heblb_vpl VALUES ("C112_20","076_12_20","1CO","12","20","20","מסיבה זו ברא אלוהים איברים רבים שמרכיבים גוף אחד. ");
INSERT INTO heblb_vpl VALUES ("C112_21","076_12_21","1CO","12","21","21","העין אינה יכולה לומר ליד: ”איני זקוקה לך,“ והראש אינו יכול לומר לרגליים: ”לכו לשלום, איני צריך אתכן יותר.“ ");
INSERT INTO heblb_vpl VALUES ("C112_22","076_12_22","1CO","12","22","22","איברי הגוף הנראים חלשים ופחותי ערך הם למעשה החשובים ביותר. ");
INSERT INTO heblb_vpl VALUES ("C112_23","076_12_23","1CO","12","23","23","אנו מייחסים יותר כבוד לאיברים שנראים חסרי חשיבות, ומסתירים מאחרים את האיברים שאינם צריכים להיראות, ");
INSERT INTO heblb_vpl VALUES ("C112_24","076_12_24","1CO","12","24","24","כי האיברים הגלויים לעין אינם דורשים אותה צניעות. אלוהים ברא את גופנו כך שנעניק יותר כבוד ותשומת לב לאיברים הנראים חסרי־חשיבות, ");
INSERT INTO heblb_vpl VALUES ("C112_25","076_12_25","1CO","12","25","25","כדי למנוע מריבות ומחלוקות בין האיברים, וכדי שכל אחד ידאג לשני במידה שווה. ");
INSERT INTO heblb_vpl VALUES ("C112_26","076_12_26","1CO","12","26","26","אם איבר אחד סובל, כל האיברים סובלים איתו; אם איבר אחד מכובד, כל האיברים האחרים שמחים איתו. ");
INSERT INTO heblb_vpl VALUES ("C112_27","076_12_27","1CO","12","27","27","אני מנסה לומר לכם שכל אחד מכם הוא איבר נפרד וחיוני, אבל כולכם יחד הינכם גוף המשיח. ");
INSERT INTO heblb_vpl VALUES ("C112_28","076_12_28","1CO","12","28","28","לפניכם רשימה של מספר איברים שנתן אלוהים לקהילה: – שליחים, – נביאים שמטיפים את דבר ה׳, – מורים, – עושי ניסים ונפלאות, – מרפאי חולים, – אנשים שעוזרים לזולת, – מנהיגים, – אנשים שמדברים בשפות שלא למדו מעולם. ");
INSERT INTO heblb_vpl VALUES ("C112_29","076_12_29","1CO","12","29","29","האם כולם שליחים? האם כולם מטיפים? כולם מורים? כולם מחוללים ניסים ונפלאות? ");
INSERT INTO heblb_vpl VALUES ("C112_30","076_12_30","1CO","12","30","30","האם כולם יכולים לרפא את החולים? האם אלוהים מעניק לכולנו את מתנת הדיבור בשפה שלא למדנו מעולם? האם כל אחד מאיתנו מסוגל לתרגם את דברי המדברים בשפות? ");
INSERT INTO heblb_vpl VALUES ("C112_31","076_12_31","1CO","12","31","31","השתדלו להשיג את המתנות המועילות ביותר. עתה ברצוני לספר לכם על דבר אחר העולה בערכו על כל המתנות האלה גם יחד. ");
INSERT INTO heblb_vpl VALUES ("C113_1","076_13_1","1CO","13","1","1","אילו ידעתי את כל השפות, אפילו את שפת מלאכי השמים, אך לא הייתה בי אהבה, הייתי מרעיש כמצלתיים. ");
INSERT INTO heblb_vpl VALUES ("C113_2","076_13_2","1CO","13","2","2","אילו ניתנה לי מתנת הנבואה ויכולתי לדעת את כל הסודות, אך לא הייתה בי אהבה, לא הועלתי מאומה. גם אם יעניק לי אלוהים אמונה רבה עד שאוכל לצוות על ההרים לזוז ממקומם, אולם אין בי אהבה, אין לי ערך רב ומוטב שאשתוק. ");
INSERT INTO heblb_vpl VALUES ("C113_3","076_13_3","1CO","13","3","3","אם אתן את כל רכושי לעניים, ואף אקריב את חיי למען המשיח והבשורה, אבל אין בי אהבה, אין כל ערך למעשי. ");
INSERT INTO heblb_vpl VALUES ("C113_4","076_13_4","1CO","13","4","4","האהבה טובת־לב וסבלנית מאוד, אינה קנאית ואינה גאוותנית. ");
INSERT INTO heblb_vpl VALUES ("C113_5","076_13_5","1CO","13","5","5","האהבה אינה גסה ואינה אנוכית, אינה נוחה לכעוס ואינה נוחה להיעלב. האהבה מוותרת. היא אינה שומרת טינה ולא חושבת רעה על אחרים. ");
INSERT INTO heblb_vpl VALUES ("C113_6","076_13_6","1CO","13","6","6","האהבה אינה שמחה באי־צדק, אלא שמחה בצאת האמת לאור. ");
INSERT INTO heblb_vpl VALUES ("C113_7","076_13_7","1CO","13","7","7","האהבה נושאת הכול, מאמינה בכול, מקווה לכול וסובלת הכול. ");
INSERT INTO heblb_vpl VALUES ("C113_8","076_13_8","1CO","13","8","8","יבוא יום שתילקחנה מאיתנו כל המתנות שהעניק לנו אלוהים, כולל נבואות ודיבור בשפות לא־ידועות, אולם האהבה תישאר לנצח! ");
INSERT INTO heblb_vpl VALUES ("C113_9","076_13_9","1CO","13","9","9","על אף כל המתנות והכישרונות אנו יודעים עתה מעט מאוד; אפילו הדוברים המוכשרים ביותר אינם יודעים הרבה. ");
INSERT INTO heblb_vpl VALUES ("C113_10","076_13_10","1CO","13","10","10","אך עם בוא המשיח תיעלמנה כל המתנות האלה, כי לא נזדקק להן יותר; המשיח ישלים בנו את כל הדרוש. ");
INSERT INTO heblb_vpl VALUES ("C113_11","076_13_11","1CO","13","11","11","בהיותי ילד התנהגתי וחשבתי כילד; כאשר הייתי לאיש השתנו מחשבותיי והתבגרו, ולכן הנחתי לענייני הילדות. ");
INSERT INTO heblb_vpl VALUES ("C113_12","076_13_12","1CO","13","12","12","מצבנו הנוכחי דומה: בשלב זה אנו יכולים לראות את אלוהים ולהבינו באופן מוגבל בלבד, כאילו שאנו מביטים מבעד לעדשה מטושטשת. אך יבוא יום שנראהו פנים אל פנים בכל הדרו. עתה אני יודע מעט מאוד ולא הכול ברור לי, אולם בבואו יתבהר הכול ויתברר, ואכיר אותו כשם שהוא מכיר אותי. ");
INSERT INTO heblb_vpl VALUES ("C113_13","076_13_13","1CO","13","13","13","לסיכום, שלושה דברים יישארו לעולם: אמונה, תקווה ואהבה, והחשובה מכל היא האהבה. ");
INSERT INTO heblb_vpl VALUES ("C114_1","076_14_1","1CO","14","1","1","טפחו את האהבה, אך השתדלו להשיג גם את שאר המתנות הרוחניות שמעניק רוח הקודש, ובמיוחד את מתנת הנבואה, שהיא היכולת והכישרון ללמד את דבר ה׳. ");
INSERT INTO heblb_vpl VALUES ("C114_2","076_14_2","1CO","14","2","2","אם קיבלת את מתנת הדיבור בשפה שלא למדת, אתה יכול לדבר רק אל אלוהים ולא אל חברי הקהילה, שאינם מסוגלים להבין שפה זאת. אתה אמנם תדבר בהשראת רוח הקודש, אך לאחרים יישמע הדבר כסודות. ");
INSERT INTO heblb_vpl VALUES ("C114_3","076_14_3","1CO","14","3","3","לעומת זאת, המנבא מדבר בשם אלוהים, וכך הוא עוזר לאחרים להתחזק באמונה, מעודד ומנחם אותם. ");
INSERT INTO heblb_vpl VALUES ("C114_4","076_14_4","1CO","14","4","4","אדם שמדבר ”בשפות“ עוזר לעצמו להתחזק באמונה, ואילו מי שמתנבא עוזר לכל הקהילה להיבנות. ");
INSERT INTO heblb_vpl VALUES ("C114_5","076_14_5","1CO","14","5","5","הלוואי שכולכם תדברו בשפות זרות, אבל יותר מזה, הלוואי שכולכם תנבאו. כי חשוב יותר להטיף את דבר אלוהים מאשר לדבר בשפות לא־ידועות, אלא אם תוכלו לתרגם את הנאמר כדי שכל השומעים יבינו. ");
INSERT INTO heblb_vpl VALUES ("C114_6","076_14_6","1CO","14","6","6","אחי היקרים, אם אני עצמי אבוא ואדבר אליכם בשפה שאינכם מבינים, מה אועיל לכם? לעומת זאת, אם אדבר אליכם בשפתכם ואספר לכם מה אמר לי אלוהים, מה אני יודע, אם אני אנבא, או אלמד מה כתוב בכתבי־הקודש – הרי שאעזור לכם להתחזק באמונה. ");
INSERT INTO heblb_vpl VALUES ("C114_7","076_14_7","1CO","14","7","7","אם איננו מדברים עברית פשוטה וברורה, איש לא יבין מה אנחנו רוצים. קחו למשל את החליל והכינור – אם אין הם משמיעים צלילים ברורים ומדויקים, איש לא יוכל לזהות את המנגינה המנוגנת. ");
INSERT INTO heblb_vpl VALUES ("C114_8","076_14_8","1CO","14","8","8","אם בעת מלחמה לא יתקע המחצצר את התרועה המוסכמת, כיצד יידעו החיילים שהם נקראים למלחמה? ");
INSERT INTO heblb_vpl VALUES ("C114_9","076_14_9","1CO","14","9","9","כך גם לגבי דיבור בשפות לא־ידועות: אם אתה מדבר אל מישהו בשפה שאינו מבין, כיצד יוכל לנחש מה אתה אומר? אתה כאילו מדבר אל הקיר! ");
INSERT INTO heblb_vpl VALUES ("C114_10","076_14_10","1CO","14","10","10","יש בעולם מאות שפות שונות, וכל אחת מהן טובה ושימושית … לאלה שמבינים אותן, ");
INSERT INTO heblb_vpl VALUES ("C114_11","076_14_11","1CO","14","11","11","אך לי אין כל תועלת בהן. לכן, אדם שיפנה אלי באחת השפות האלה יהיה לגבי זר לגמרי – אני לא אבין אותו, והוא לא יבין אותי. ");
INSERT INTO heblb_vpl VALUES ("C114_12","076_14_12","1CO","14","12","12","מאחר שאתם באמת שואפים למתנות הרוחניות, בקשו מרוח הקודש את המתנות המועילות ביותר לקהילה כולה. ");
INSERT INTO heblb_vpl VALUES ("C114_13","076_14_13","1CO","14","13","13","מי שמדבר בשפה לא־ידועה צריך להתפלל בעד היכולת לתרגם שפה זו, כדי שיוכל לשתף את האחרים ולהסביר להם מה אמר. ");
INSERT INTO heblb_vpl VALUES ("C114_14","076_14_14","1CO","14","14","14","הרי אם אני מתפלל בשפה שאיני מבין, רוחי אמנם מתפלל, אך איני יודע מה אני אומר. ");
INSERT INTO heblb_vpl VALUES ("C114_15","076_14_15","1CO","14","15","15","כיצד אני פותר את הבעיה? אני מדבר בשפה לא־ידועה וגם בשפתי הרגילה המוכרת לכולם; אני שר בשפה זרה וגם בשפתי הרגילה. ");
INSERT INTO heblb_vpl VALUES ("C114_16","076_14_16","1CO","14","16","16","אם אתם מהללים את אלוהים רק בשפה לא־ידועה, אלה שאינם מבינים אתכם לא יוכלו להלל את ה׳ ולהודות לו יחד אתכם. כיצד יוכלו להצטרף אליכם ולהלל את ה׳ בשעה שאינם יודעים מה אתם אומרים? ");
INSERT INTO heblb_vpl VALUES ("C114_17","076_14_17","1CO","14","17","17","אתם אמנם מהללים את ה׳, אולם הדבר אינו מועיל ואינו עוזר לאחרים. ");
INSERT INTO heblb_vpl VALUES ("C114_18","076_14_18","1CO","14","18","18","אני מודה לאלוהים על שאני מדבר ”בשפות“ יותר מכל אחד מכם. ");
INSERT INTO heblb_vpl VALUES ("C114_19","076_14_19","1CO","14","19","19","אך בציבור אני מעדיף לומר חמש מילים מובנות שיעזרו לכולם, מאשר עשרת־אלפים מילים בשפה שאינה מוכרת לאיש. ");
INSERT INTO heblb_vpl VALUES ("C114_20","076_14_20","1CO","14","20","20","אחי היקרים, אל תהיו ילדותיים במחשבותיכם והבנתכם. היו תמימים כילדים בכל הנוגע למעשים רעים, אולם בכל הקשור לעניינים רציניים כאלה, היו נבונים והתנהגו כמבוגרים. ");
INSERT INTO heblb_vpl VALUES ("C114_21","076_14_21","1CO","14","21","21","כתוב בכתבי־הקודש, שאלוהים ידבר אל העם הזה בשפות זרות, אבל גם אז לא יקשיב העם לה׳. ");
INSERT INTO heblb_vpl VALUES ("C114_22","076_14_22","1CO","14","22","22","מכאן אתם רואים שדיבור בשפה זרה ולא־ידועה אינו עוזר לאנשים להאמין. אך הנבואה עוזרת לאנשים להאמין. ");
INSERT INTO heblb_vpl VALUES ("C114_23","076_14_23","1CO","14","23","23","אם יבואו לקהילתכם אורחים או לא־מאמינים ויראו את כולכם מדברים בשפות זרות ולא מוכרות, מה יחשבו? הם יחשבו שיצאתם מדעתכם! ");
INSERT INTO heblb_vpl VALUES ("C114_24","076_14_24","1CO","14","24","24","בעוד שאם תטיפו את דבר ה׳, גם האורח וגם הלא־מאמין שיבקרו בקהילתכם ישמעו ויבינו. יתכן מאוד שדבר אלוהים יגע בלבם, יוכיח אותם בחטאם, ");
INSERT INTO heblb_vpl VALUES ("C114_25","076_14_25","1CO","14","25","25","ותוך כדי הקשבה לדבר ה׳ יתרכך לבם, והם יכרעו ברך לפני ה׳ ויודו כי אלוהים באמת נמצא בינינו. ");
INSERT INTO heblb_vpl VALUES ("C114_26","076_14_26","1CO","14","26","26","לסיכום: כשתתאספו יחד, אחד ישיר, שני ‎ יְלַמֵּד, שלישי יגלה חזון מיוחד מאלוהים, רביעי ידבר בשפה לא־ידועה, חמישי יפרש בקול רם את השפה הלא־ידועה, אולם זכרו: כל מה שנעשה צריך להועיל לכולם, לחזק ולבנות את כולם באדון. ");
INSERT INTO heblb_vpl VALUES ("C114_27","076_14_27","1CO","14","27","27","בכל אסיפה מותר רק לשניים או שלושה איש לדבר בשפות לא־ידועות; עליהם לדבר זה לאחר זה, ומישהו חייב לתרגם את דבריהם. ");
INSERT INTO heblb_vpl VALUES ("C114_28","076_14_28","1CO","14","28","28","אם אין בקהל מי שמסוגל לתרגם, אסור להם לדבר בקול רם; עליהם לדבר בלחש לעצמם ולאלוהים, ולא לציבור. ");
INSERT INTO heblb_vpl VALUES ("C114_29‏","076_14_29‏","1CO","14","29‏","30","שניים או שלושה נביאים ידברו – זה לאחר זה וכל האחרים יקשיבו. אולם אם בשעה שאחד מדבר אדם אחר מקבל חזון מאלוהים, על הראשון להפסיק ולהניח לשני לדבר. ");
INSERT INTO heblb_vpl VALUES ("C114_31","076_14_31","1CO","14","31","31","בדרך זאת כל מי שמקבל חזון או נבואה מה׳ יוכל לדבר – אחד־אחד – וכולם ילמדו, יתעודדו ויתחזקו. ");
INSERT INTO heblb_vpl VALUES ("C114_32","076_14_32","1CO","14","32","32","אל תשכחו כי האנשים שמביאים אליכם את דבר אלוהים מסוגלים לשלוט בעצמם ולחכות בסבלנות בתור! ");
INSERT INTO heblb_vpl VALUES ("C114_33","076_14_33","1CO","14","33","33","אלוהים אינו אלוהי מהומה אלא שלום. כנהוג בכל הקהילות, ");
INSERT INTO heblb_vpl VALUES ("C114_34","076_14_34","1CO","14","34","34","על הנשים לשתוק בעת אסיפות הקהילה; אסור להן להשתתף בשיחה, כי עליהן להיכנע לגברים, כפי שמלמדים אותנו הכתובים. ");
INSERT INTO heblb_vpl VALUES ("C114_35","076_14_35","1CO","14","35","35","אם יש להן שאלות, שתשאלנה את הבעלים בבית, כי לא נאה לאישה להביע את דעתה באסיפות הקהילה. ");
INSERT INTO heblb_vpl VALUES ("C114_36","076_14_36","1CO","14","36","36","האם אינכם מסכימים איתי? האם אתם חושבים שאתם בעצמכם המצאתם את הכתובים? או האם אתם לבדכם מבינים את הכתובים? ");
INSERT INTO heblb_vpl VALUES ("C114_37","076_14_37","1CO","14","37","37","אם מישהו חושב שהוא נביא או רוחני, אז שיכיר בכך שהדברים שאני כותב הם מצוות האדון. ");
INSERT INTO heblb_vpl VALUES ("C114_38","076_14_38","1CO","14","38","38","אך אם מישהו לא יכיר בכך, אז לא יוכר בו. ");
INSERT INTO heblb_vpl VALUES ("C114_39","076_14_39","1CO","14","39","39","אם כן, אחי היקרים, השתדלו להשיג את מתנת הנבואה, ואל תאסרו את הדיבור בשפות לא־ידועות. ");
INSERT INTO heblb_vpl VALUES ("C114_40","076_14_40","1CO","14","40","40","על כל פנים, כל מה שאתם עושים עשו תוך שמירה על הסדר והטעם הטוב. ");
INSERT INTO heblb_vpl VALUES ("C115_1","076_15_1","1CO","15","1","1","אחי, ברצוני להזכיר לכם את הבשורה שהבאתי לכם – אותה בשורה שקיבלתם בשמחה ושאתם עדיין מאמינים בה. ");
INSERT INTO heblb_vpl VALUES ("C115_2","076_15_2","1CO","15","2","2","בשורה זאת היא המושיעה אתכם, אם אתם עדיין מאמינים בה, אלא אם כן מעולם לא האמנתם בה באמת. ");
INSERT INTO heblb_vpl VALUES ("C115_3","076_15_3","1CO","15","3","3","סיפרתי לכם כל מה שסופר לי, ודברים אלה הם בעלי חשיבות ראשונה במעלה: שהמשיח מת בעד חטאינו, כפי שניבאו הכתובים, ");
INSERT INTO heblb_vpl VALUES ("C115_4","076_15_4","1CO","15","4","4","שהוא נקבר, ושלאחר שלושה ימים קם לתחייה כפי שחזו הנביאים. ");
INSERT INTO heblb_vpl VALUES ("C115_5","076_15_5","1CO","15","5","5","המשיח נראה ל‎כֵּיפָא, לאחר מכן נראה לשנים־עשר התלמידים. ");
INSERT INTO heblb_vpl VALUES ("C115_6","076_15_6","1CO","15","6","6","הוא נגלה גם ליותר מחמש־מאות מאמינים שהתאספו יחד. רובם עדיין חיים ויכולים להעיד על כך, ואחדים מהם כבר מתו. ");
INSERT INTO heblb_vpl VALUES ("C115_7","076_15_7","1CO","15","7","7","אחר כך נראה המשיח ליעקב אחיו ולכל השליחים. ");
INSERT INTO heblb_vpl VALUES ("C115_8","076_15_8","1CO","15","8","8","לאחר שנראה אל כל האחרים הוא נראה לבסוף גם אלי, כאל מי שלא נולד בזמנו. ");
INSERT INTO heblb_vpl VALUES ("C115_9","076_15_9","1CO","15","9","9","כי אני השליח הקטן מכולם בחשיבותו, ולמעשה איני ראוי כלל להיקרא ”שליח“, שכן לפני בואי לאמונה רדפתי את קהילת אלוהים והטרדתי אותה. ");
INSERT INTO heblb_vpl VALUES ("C115_10","076_15_10","1CO","15","10","10","אולם בזכות טוב־לבו וחסדו של אלוהים אני היום מה שאני. חסדו בהחלט לא היה לשווא, כי פעלתי יותר מכל השליחים האחרים – כלומר, לא אני פעלתי, אלא אלוהים הוא שפעל דרכי. ");
INSERT INTO heblb_vpl VALUES ("C115_11","076_15_11","1CO","15","11","11","בעצם לא חשוב מי פעל יותר, הם או אני; העיקר שבישרנו לכם את הבשורה ושאתם האמנתם. ");
INSERT INTO heblb_vpl VALUES ("C115_12","076_15_12","1CO","15","12","12","איני מבין אתכם! אם אתם מאמינים שהמשיח קם מן המתים, מדוע אינכם מאמינים בתחיית־המתים? ");
INSERT INTO heblb_vpl VALUES ("C115_13","076_15_13","1CO","15","13","13","אם אין תחייה למתים, הרי שגם המשיח לא קם לתחייה, כלומר, הוא עדיין מת! ");
INSERT INTO heblb_vpl VALUES ("C115_14","076_15_14","1CO","15","14","14","ואם המשיח עדיין מת, אין כל ערך למה שסיפרנו לכם, וביטחונכם בה׳ חסר יסוד ותקווה. ");
INSERT INTO heblb_vpl VALUES ("C115_15","076_15_15","1CO","15","15","15","מכאן גם משתמע שכולנו, השליחים, שקרנים. כי סיפרנו לכם שאלוהים הקים את ישוע מן המתים – דבר שאינו אפשרי אם המתים אינם יכולים לקום לתחייה. ");
INSERT INTO heblb_vpl VALUES ("C115_16","076_15_16","1CO","15","16","16","ואם המתים אינם יכולים לקום לתחייה אזי גם המשיח לא קם, והוא עדיין מת. ");
INSERT INTO heblb_vpl VALUES ("C115_17","076_15_17","1CO","15","17","17","אם המשיח עדיין מת, איזה ערך יש לאמונתכם שה׳ הושיע אתכם? אתם עדיין משועבדים לחטא וצפויים לעונש! ");
INSERT INTO heblb_vpl VALUES ("C115_18","076_15_18","1CO","15","18","18","במקרה כזה, כל המאמינים שכבר מתו הם בעצמם אבודים. ");
INSERT INTO heblb_vpl VALUES ("C115_19","076_15_19","1CO","15","19","19","ואם אנו מאמינים ומקוים במשיח רק בעולם הזה, אומללים אנו מכל אדם! ");
INSERT INTO heblb_vpl VALUES ("C115_20","076_15_20","1CO","15","20","20","אולם תודה לאל על כך שהמשיח אכן קם מן המתים! הוא היה הראשון מבין הרבים שיקומו לתחייה יום אחד. ");
INSERT INTO heblb_vpl VALUES ("C115_21","076_15_21","1CO","15","21","21","כשם שהמוות בא לעולם בעקבות חטאו של אדם אחד – האדם הראשון – כך באה גם תחיית המתים לעולם על־ידי אדם אחד – המשיח. ");
INSERT INTO heblb_vpl VALUES ("C115_22","076_15_22","1CO","15","22","22","כולנו עתידים למות בגלל השתייכותנו למין האנושי והחוטא של אדם, והעונש על החטא הוא מוות. אך השייכים למשיח יקומו לתחייה. ");
INSERT INTO heblb_vpl VALUES ("C115_23","076_15_23","1CO","15","23","23","כל אחד יקום בתורו: המשיח היה הראשון שקם לתחייה, וכאשר ישוב אלינו, יקומו גם כל המאמינים השייכים לו. ");
INSERT INTO heblb_vpl VALUES ("C115_24","076_15_24","1CO","15","24","24","לאחר מכן יבוא הקץ – לאחר שהמשיח יכרית ויכניע את כל האויבים, הכוחות והשלטונות, ויחזיר את המלכות לאלוהים אביו. ");
INSERT INTO heblb_vpl VALUES ("C115_25","076_15_25","1CO","15","25","25","כי המשיח ימלוך עד שיכניע לרגליו את כל אויביו, ");
INSERT INTO heblb_vpl VALUES ("C115_26","076_15_26","1CO","15","26","26","והאויב האחרון שיכניע יהיה המוות. ");
INSERT INTO heblb_vpl VALUES ("C115_27","076_15_27","1CO","15","27","27","אלוהים אביו העניק לו שלטון וסמכות על הכול, חוץ מאשר על אלוהים עצמו שהוא נותן הכוח. ");
INSERT INTO heblb_vpl VALUES ("C115_28","076_15_28","1CO","15","28","28","לאחר שינצח המשיח את כל אויביו הוא ייכנע לשלטון אביו, כדי שהאלוהים אשר העניק לו את הניצחון על הכול יישאר מעל לכול. ");
INSERT INTO heblb_vpl VALUES ("C115_29","076_15_29","1CO","15","29","29","אם המתים לא יקומו לתחייה, מה התועלת במעשה האנשים שנטבלים בשם המתים? איזה ערך יש למעשה כזה, אם אינכם מאמינים שיום אחד יקומו המתים לתחייה? ");
INSERT INTO heblb_vpl VALUES ("C115_30","076_15_30","1CO","15","30","30","מלבד זאת, למה לנו לסכן את חיינו כל הזמן? ");
INSERT INTO heblb_vpl VALUES ("C115_31","076_15_31","1CO","15","31","31","הלא יודעים אתם שאני מסכן את חיי בכל יום; זוהי עובדה ממש כמו העובדה שאני גאה מאוד בהתפתחותכם הרוחנית. ");
INSERT INTO heblb_vpl VALUES ("C115_32","076_15_32","1CO","15","32","32","לשם מה נלחמתי בחיות הפרא – באנשי אפסוס – האם רק למען תועלתי בעולם הזה? אם לא נקום לתחייה לאחר מותנו, מה יש לנו להפסיד? הבה ”נהנה מהחיים, נאכל ונשתה כי מחר נמות!“ ");
INSERT INTO heblb_vpl VALUES ("C115_33","076_15_33","1CO","15","33","33","התרחקו מאנשים שחיים כך. אם תקשיבו להם, תושפעו מהם ותנהגו כמוהם. ");
INSERT INTO heblb_vpl VALUES ("C115_34","076_15_34","1CO","15","34","34","חשבו בהגיון ובתבונה והפסיקו לחטוא. עליכם להתבייש על שיש ביניכם אנשים שאינם מאמינים באלוהים ואף פעם לא האמינו – הם רק מעמידים פנים! ");
INSERT INTO heblb_vpl VALUES ("C115_35","076_15_35","1CO","15","35","35","אם ישאל מישהו: ”כיצד יוכלו המתים לקום לתחייה? כיצד ייראו? איזה גוף יהיה להם?“ ");
INSERT INTO heblb_vpl VALUES ("C115_36","076_15_36","1CO","15","36","36","השאלה אמנם טיפשית, אך את התשובה תמצאו. כשאתה טומן זרע באדמה, הוא לא יצמח עד שלא תקברהו תחילה. ");
INSERT INTO heblb_vpl VALUES ("C115_37","076_15_37","1CO","15","37","37","הגבעול הירקרק שצומח מהזרע שונה בצורתו מהזרע שזרעת, כי הרי טמנת באדמה זרע קטנטן ויבש, ");
INSERT INTO heblb_vpl VALUES ("C115_38","076_15_38","1CO","15","38","38","ואלוהים העניק לו גוף חדש כפי בחירתו. לכל זרע יש גוף שונה. ");
INSERT INTO heblb_vpl VALUES ("C115_39","076_15_39","1CO","15","39","39","כשם שיש זרעים שונים וצמחים שונים, כך יש גם מינים שונים של בשר וגוף. בני־אדם, חיות, דגים וציפורים – לכל אחד יש בשר אחר וגוף אחר. ");
INSERT INTO heblb_vpl VALUES ("C115_40","076_15_40","1CO","15","40","40","למלאכים בשמים יש גוף השונה משלנו, וגם היופי וההדר שלהם הוא ממין אחר שאינו דומה לשלנו. ");
INSERT INTO heblb_vpl VALUES ("C115_41","076_15_41","1CO","15","41","41","היופי וההוד של השמש שונה מזה של הירח והכוכבים, ולכל כוכב יש יופי וזוהר משלו. ");
INSERT INTO heblb_vpl VALUES ("C115_42","076_15_42","1CO","15","42","42","כך גם גופנו, שהוא בר־מיתה, שונה מהגוף שנקבל לאחר תחיית המתים, כי גופנו החדש יהיה בן־אלמוות! ");
INSERT INTO heblb_vpl VALUES ("C115_43","076_15_43","1CO","15","43","43","עכשיו נוטה גופנו לחלות ולמות, אך כשנקום לתחייה הוא יהיה מלא כוח וגבורה. ");
INSERT INTO heblb_vpl VALUES ("C115_44","076_15_44","1CO","15","44","44","עד המוות גופנו הוא גוף אנושי – בשר ודם; אולם בתחיית המתים הוא יהיה גוף רוחני על־טבעי. ");
INSERT INTO heblb_vpl VALUES ("C115_45","076_15_45","1CO","15","45","45","כתבי־הקודש מספרים לנו: ”ויהי האדם הראשון לנפש חיה“. כלומר, לאדם חי, ואילו האדם האחרון (המשיח) – לרוח שמעניק חיים. ");
INSERT INTO heblb_vpl VALUES ("C115_46","076_15_46","1CO","15","46","46","מכאן אתם רואים שה׳ מעניק תחילה גוף פיזי, ולאחר מכן גוף רוחני. ");
INSERT INTO heblb_vpl VALUES ("C115_47","076_15_47","1CO","15","47","47","האדם הראשון נברא מעפר האדמה, ואילו המשיח בא מהשמים. ");
INSERT INTO heblb_vpl VALUES ("C115_48","076_15_48","1CO","15","48","48","לכל בני־האדם יש גוף בשר ודם שנברא מעפר, כמו לאדם הראשון; אולם לכל מי ששייך למשיח יהיה גוף על־טבעי כמו למשיח. ");
INSERT INTO heblb_vpl VALUES ("C115_49","076_15_49","1CO","15","49","49","כשם שלכל אחד מאיתנו יש גוף כמו לאדם הראשון, כך יום אחד יהיה לכולנו גוף כמו למשיח. ");
INSERT INTO heblb_vpl VALUES ("C115_50","076_15_50","1CO","15","50","50","אני רוצה לומר לכם, אחים יקרים, שבשר ודם לא יוכל לרשת את מלכות האלוהים, כי בר־חלוף אינו יכול לרשת את הנצח ולשלוט בו. ");
INSERT INTO heblb_vpl VALUES ("C115_51","076_15_51","1CO","15","51","51","ברצוני לגלות לכם סוד נפלא: לא כולנו נמות, אבל לכולנו יהיה גוף אחר. ");
INSERT INTO heblb_vpl VALUES ("C115_52","076_15_52","1CO","15","52","52","הכול יתרחש במהירות הבזק, כהרף עין! כאשר תישמע תקיעת השופר האחרון מן השמים, כל המאמינים שמתו יקומו לתחייה בגוף חדש שאינו בר־מיתה, ואלה מאיתנו שחיים עדיין יקבלו גוף חדש לגמרי. ");
INSERT INTO heblb_vpl VALUES ("C115_53","076_15_53","1CO","15","53","53","כי גוף הבשר שיש לנו עתה ישתנה ויהפוך לגוף רוחני ונצחי. ");
INSERT INTO heblb_vpl VALUES ("C115_54","076_15_54","1CO","15","54","54","כאשר כל זה יתרחש, יתקיים הכתוב: ”המוות נוצח!“ ");
INSERT INTO heblb_vpl VALUES ("C115_55‏","076_15_55‏","1CO","15","55‏","56","מוות, היכן ניצחונך? היכן עוקצך? החטא – העוקץ שגרם למוות – ייעלם, והתורה המצביעה על חטאינו שוב לא תשפוט אותנו. ");
INSERT INTO heblb_vpl VALUES ("C115_57","076_15_57","1CO","15","57","57","כל השבח והתהילה לאלוהים אבינו, על אשר עשה אותנו למנצחים על־ידי ישוע המשיח אדוננו. ");
INSERT INTO heblb_vpl VALUES ("C115_58","076_15_58","1CO","15","58","58","ובכן, אחים יקרים, הואיל והניצחון מובטח לנו, התחזקו, התעודדו ואל תתייאשו, כי יודעים אתם שכל עמלכם למען האדון אינו לשווא. ");
INSERT INTO heblb_vpl VALUES ("C116_1","076_16_1","1CO","16","1","1","באשר לכסף שאתם אוספים למען המאמינים שמקדישים את כל זמנם לשירות האדון, הייתי רוצה מאוד שתנהגו כפי שביקשתי מהקהילה בגלטיא. ");
INSERT INTO heblb_vpl VALUES ("C116_2","076_16_2","1CO","16","2","2","מדי שבת על כל איש להפריש תרומה מסוימת מהסכום שהרוויח באותו שבוע, כל אחד בהתאם למשכורתו. אל תחכו עד שאבוא אליכם, כדי שלא יהיה צורך לאסוף את הכסף בבואי. ");
INSERT INTO heblb_vpl VALUES ("C116_3","076_16_3","1CO","16","3","3","כשאבוא אליכם תבחרו שליחים נאמנים, ואני אשלח בידם את מתנתכם הנדיבה בצירוף מכתב לירושלים. ");
INSERT INTO heblb_vpl VALUES ("C116_4","076_16_4","1CO","16","4","4","אם אצטרך גם אני ללכת, נלך כולנו יחד. ");
INSERT INTO heblb_vpl VALUES ("C116_5","076_16_5","1CO","16","5","5","אבוא לבקר אתכם לאחר ביקורי הקצר במקדוניה. ");
INSERT INTO heblb_vpl VALUES ("C116_6","076_16_6","1CO","16","6","6","יתכן שאשאר אצלכם זמן מה, אולי אפילו למשך כל החורף. בתום ביקורי תוכלו ללוות אותי ליעד הבא במסעי. ");
INSERT INTO heblb_vpl VALUES ("C116_7","076_16_7","1CO","16","7","7","הפעם איני רוצה לערוך אצלכם ביקור חטוף בלבד ומיד להמשיך הלאה; אם ירצה השם, ברצוני להישאר איתכם זמן מה. ");
INSERT INTO heblb_vpl VALUES ("C116_8","076_16_8","1CO","16","8","8","אשאר בְּאֶפֶסוֹס עד חג השבועות, ");
INSERT INTO heblb_vpl VALUES ("C116_9","076_16_9","1CO","16","9","9","כי יש לי כאן הזדמנות טובה לבשר את הבשורה; הדלת פתוחה לרווחה והאפשרויות רבות, אך … גם האויבים רבים. ");
INSERT INTO heblb_vpl VALUES ("C116_10","076_16_10","1CO","16","10","10","אם טימותיוס יבוא אליכם, אנא, קבלוהו יפה ותנו לו להרגיש כמו בבית, שכן הוא עובד למען האדון, כמוני. ");
INSERT INTO heblb_vpl VALUES ("C116_11","076_16_11","1CO","16","11","11","אל תניחו לאיש לבוז לו (בגלל גילו הצעיר), כי אני רוצה שייהנה מביקורו אצלכם. שילחוהו בשלום, כי אני מצפה לשובו יחד עם האחים האחרים. ");
INSERT INTO heblb_vpl VALUES ("C116_12","076_16_12","1CO","16","12","12","התחננתי לפני אפולוס שיבוא לבקר אתכם יחד עם האחים האחרים, אך הוא חשב כי אין זה רצון האלוהים שיבקר אתכם דווקא עתה. הוא הבטיח לבקר אתכם בהזדמנות הקרובה. ");
INSERT INTO heblb_vpl VALUES ("C116_13","076_16_13","1CO","16","13","13","היזהרו מסכנות רוחניות, היו נאמנים לאדון, התעודדו והתחזקו, ");
INSERT INTO heblb_vpl VALUES ("C116_14","076_16_14","1CO","16","14","14","ועשו כל דבר באהבה. ");
INSERT INTO heblb_vpl VALUES ("C116_15","076_16_15","1CO","16","15","15","האם אתם זוכרים את סטפנוס ובני־משפחתו? הם היו המאמינים הראשונים בכל יוון, והקדישו את חייהם לעזור למאמינים המשיחיים באשר הם ולשרתם. ");
INSERT INTO heblb_vpl VALUES ("C116_16","076_16_16","1CO","16","16","16","לכן אני מבקש מכם לשמוע בקולם ולעזור להם כמיטב יכולתכם. עזרו גם לשאר המאמינים העובדים קשה כמוהם למען האדון, משום שהקדישו את חייהם לעבודה הנפלאה הזאת. ");
INSERT INTO heblb_vpl VALUES ("C116_17","076_16_17","1CO","16","17","17","אני ממש מאושר שסטפנוס, פורטונטוס ואכיקוס באו לבקר כאן, כי הם מילאו את מקומכם ועזרו לי בחסרונכם. ");
INSERT INTO heblb_vpl VALUES ("C116_18","076_16_18","1CO","16","18","18","הם שימחו ועודדו אותי בצורה נפלאה, ואני בטוח שגם אתכם הם עודדו. אני מקווה שאתם מעריכים את עבודתם של אנשים נפלאים אלה. ");
INSERT INTO heblb_vpl VALUES ("C116_19","076_16_19","1CO","16","19","19","הקהילות כאן באסיה שולחות לכם דרישת שלום. עקילס, פריסקילה והמאמינים המתאספים בביתם מוסרים לכם דרישת שלום חמה מכל הלב. ");
INSERT INTO heblb_vpl VALUES ("C116_20","076_16_20","1CO","16","20","20","כל החברים והידידים כאן ביקשו ממני למסור לכם דרישת שלום. כאשר אתם מתכנסים יחד, ברכו איש את רעהו לשלום בנשיקה קדושה. ");
INSERT INTO heblb_vpl VALUES ("C116_21","076_16_21","1CO","16","21","21","את המילים האחרונות במכתב זה אני כותב בכתב ידי: ");
INSERT INTO heblb_vpl VALUES ("C116_22","076_16_22","1CO","16","22","22","ארור מי שאינו אוהב את האדון! מָרַן אֲתָא – חזור במהרה, אדון ישוע! ");
INSERT INTO heblb_vpl VALUES ("C116_23","076_16_23","1CO","16","23","23","חסדו של ישוע ואהבתו ינוחו עליכם. ");
INSERT INTO heblb_vpl VALUES ("C116_24","076_16_24","1CO","16","24","24","אני שולח את אהבתי לכולכם, כי כולנו שייכים לישוע המשיח. – אמן.");
INSERT INTO heblb_vpl VALUES ("C21_1","077_1_1","2CO","1","1","1","מאת פולוס, שליח ישוע המשיח לפי רצון אלוהים, ומאת אחינו טימותיוס. אל המאמינים המשיחיים בקורינתוס וביוון כולה. ");
INSERT INTO heblb_vpl VALUES ("C21_2","077_1_2","2CO","1","2","2","מי ייתן שהאלוהים אבינו וישוע המשיח אדוננו יברך כל אחד מכם ויעניק לכם שלום. ");
INSERT INTO heblb_vpl VALUES ("C21_3","077_1_3","2CO","1","3","3","הבה נברך את האלוהים אבי המשיח אדוננו, שכן הוא מקור ואב הרחמים, שמנחם ומעודד אותנו בצרותינו. ");
INSERT INTO heblb_vpl VALUES ("C21_4","077_1_4","2CO","1","4","4","אלוהים מנחם אותנו בצרותינו, על־מנת שבאותו אופן נעזור גם אנחנו למתנסים בצרות שעברו עלינו. ");
INSERT INTO heblb_vpl VALUES ("C21_5","077_1_5","2CO","1","5","5","שכן ככל שאנו מרבים לסבול למען המשיח, כך הוא ירבה לעודדנו ולנחמנו. ");
INSERT INTO heblb_vpl VALUES ("C21_6","077_1_6","2CO","1","6","6","אם אנחנו סובלים, הרי שזה למען נחמתכם וישועתכם; אם אנחנו מנוחמים, הרי שזה למען נחמתכם: להראות לכם מניסיוננו כיצד ינחם אלוהים גם אתכם כשתתנסו בסבלנו. ");
INSERT INTO heblb_vpl VALUES ("C21_7","077_1_7","2CO","1","7","7","אין לנו ספק שאם עליכם לסבול כמונו, הרי שגם תנוחמו כמונו. ");
INSERT INTO heblb_vpl VALUES ("C21_8","077_1_8","2CO","1","8","8","אחים יקרים, ברצוננו להזכיר לכם את דבר הצרות שעברו עלינו באסיה. המשא והלחצים היו כבדים מנשוא, עד כי לא האמנו שנישאר בחיים. ");
INSERT INTO heblb_vpl VALUES ("C21_9","077_1_9","2CO","1","9","9","חשנו שנגזר עלינו דין מוות, אך הדבר נועד ללמדנו שאל לנו לבטוח בעצמנו, אלא רק באלוהים המחיה את המתים. ");
INSERT INTO heblb_vpl VALUES ("C21_10","077_1_10","2CO","1","10","10","אלוהים אכן הצילנו ממוות נורא, ואנו בטוחים שאף יוסיף להצילנו. ");
INSERT INTO heblb_vpl VALUES ("C21_11","077_1_11","2CO","1","11","11","אך על כולכם להתפלל בעדנו, כי ככל שירבו המתפללים למען ביטחוננו, כן ירבו המודים לאלוהים כשיענה לתפילותיכם. ");
INSERT INTO heblb_vpl VALUES ("C21_12","077_1_12","2CO","1","12","12","אנו גאים בעובדה שתמיד התנהגנו בתם ויושר, בוטחים באלוהים ולא בעצמנו. גם איתכם נהגנו כך! ");
INSERT INTO heblb_vpl VALUES ("C21_13‏","077_1_13‏","2CO","1","13‏","14","מכתבי היו כנים ולא כתבתי דבר בין השורות. ואם כי עדיין אינכם מכירים אותי היטב (אני מקווה שבקרוב תטיבו להכירני), אנא, השתדלו להתגאות בי, כשם שאני אתגאה בכם ביום שובו של ישוע אדוננו. ");
INSERT INTO heblb_vpl VALUES ("C21_15‏","077_1_15‏","2CO","1","15‏","16","הואיל ולא הטלתי ספק בביטחונכם והבנתכם, החלטתי לבקרכם בדרכי למקדוניה ובשובי משם, כדי שאהיה לכם לברכה כפולה וכדי שתשלחוני ליהודה. ");
INSERT INTO heblb_vpl VALUES ("C21_17","077_1_17","2CO","1","17","17","ודאי תשאלו מדוע שיניתי את דעתי; האם נהגתי בפזיזות? או האם נהגתי באנוכיות ואמרתי ”כן“ כשהתכוונתי ל”לא“? ");
INSERT INTO heblb_vpl VALUES ("C21_18","077_1_18","2CO","1","18","18","חס וחלילה! כשם שאלוהים מהימן כך לא נהגתי בקלות ראש. כשאני אומר ”כן“ אני מתכוון לכך. ");
INSERT INTO heblb_vpl VALUES ("C21_19","077_1_19","2CO","1","19","19","טימותיוס, סילוונוס ואני סיפרנו לכם על ישוע המשיח בן־האלוהים. המשיח תמיד מקיים את דבריו ולעולם אינו אומר ”כן“ בהתכוונו ל”לא“. ");
INSERT INTO heblb_vpl VALUES ("C21_20","077_1_20","2CO","1","20","20","הוא מקיים את כל הבטחות אלוהים, יהיה מספרן אשר יהיה. אנו סיפרנו לכולם מה נאמן הוא, וכך פארנו את שם אלוהים. ");
INSERT INTO heblb_vpl VALUES ("C21_21","077_1_21","2CO","1","21","21","אלוהים הוא אשר עשה אתכם ואותי למאמינים משיחיים נאמנים, והטיל עלינו את השליחות לבשר את הבשורה. ");
INSERT INTO heblb_vpl VALUES ("C21_22","077_1_22","2CO","1","22","22","הוא אף חתם אותנו בחותמו, והשכין בלבנו את רוח הקודש כערבות להשתייכותנו אליו. ");
INSERT INTO heblb_vpl VALUES ("C21_23","077_1_23","2CO","1","23","23","אלוהים עדי שלא באתי אליכם עד כה מפני שחסתי עליכם; לא רציתי לצער אתכם בתוכחה קשה. ");
INSERT INTO heblb_vpl VALUES ("C21_24","077_1_24","2CO","1","24","24","איני מנסה לשפוט אתכם בענייני האמונה, שהרי אמונתכם איתנה. ברצוני לעזור לשמחתכם; כן, ברצוני לשמח אתכם ולא לצער. ");
INSERT INTO heblb_vpl VALUES ("C22_1","077_2_1","2CO","2","1","1","החלטתי שלא אבוא יותר לצער אתכם, ");
INSERT INTO heblb_vpl VALUES ("C22_2","077_2_2","2CO","2","2","2","כי אם אני אגרום לכם צער, מי ישמח אותי? בטח שלא מישהו שהעצבתי. ");
INSERT INTO heblb_vpl VALUES ("C22_3","077_2_3","2CO","2","3","3","מסיבה זאת כתבתי לכם את המכתב ההוא – לא רציתי לבוא אליכם ולהתעצב בגלל אלה שצריכים לשמחני, ואני בטוח ששמחתי היא שמחת כולכם. ");
INSERT INTO heblb_vpl VALUES ("C22_4","077_2_4","2CO","2","4","4","מה שנאתי לכתוב לכם אותו מכתב! כתבתי אותו בכאב ובדמעות לא כדי להכאיב לכם, אלא כדי להראות לכם מה רבה אהבתי אליכם. ");
INSERT INTO heblb_vpl VALUES ("C22_5‏","077_2_5‏","2CO","2","5‏","6","זכרו כי האיש אשר גרם לכל הצרה הזאת ציער לא רק אותי, אלא את כולכם – לפחות במידת־מה, כדי שלא להגזים. איני רוצה להחמיר איתו למעלה מן הצורך, כי הוא כבר נענש דיו מהתוכחה של כולכם. ");
INSERT INTO heblb_vpl VALUES ("C22_7","077_2_7","2CO","2","7","7","כעת עליכם לסלוח לו ולנחם אותו, שאם לא כן הוא עלול להתמוטט מרוב צער. ");
INSERT INTO heblb_vpl VALUES ("C22_8","077_2_8","2CO","2","8","8","אנא, הוכיחו לו שאתם עדיין אוהבים אותו. ");
INSERT INTO heblb_vpl VALUES ("C22_9","077_2_9","2CO","2","9","9","כתבתי את מכתבי על־מנת לבחון את נכונותכם לציית בכל הדברים. ");
INSERT INTO heblb_vpl VALUES ("C22_10","077_2_10","2CO","2","10","10","אם אתם סולחים למישהו על איזה דבר, גם אני סולח לו. שהרי כאשר אני סולח, אם אכן עלי לסלוח למישהו, אני עושה זאת למענכם ובסמכות המשיח, ");
INSERT INTO heblb_vpl VALUES ("C22_11","077_2_11","2CO","2","11","11","כדי שהשטן לא יערים עלינו במזימותיו ותחבולותיו המוכרות לנו. ");
INSERT INTO heblb_vpl VALUES ("C22_12","077_2_12","2CO","2","12","12","בהגיעי לעיר טרואס נתן לי האדון הזדמנות נפלאה לבשר את בשורת המשיח, ");
INSERT INTO heblb_vpl VALUES ("C22_13","077_2_13","2CO","2","13","13","אך לא מצאתי מנוחה לנפשי, כי לא פגשתי כמתוכנן את טיטוס אחי. לפיכך נפרדתי מאנשי טרואס ויצאתי למקדוניה לחפש את טיטוס. ");
INSERT INTO heblb_vpl VALUES ("C22_14","077_2_14","2CO","2","14","14","השבח לאלוהים המוביל אותנו במסע הניצחון של המשיח, ומפיץ על־ידינו את בשורת המשיח כריח ניחוח בכל מקום. ");
INSERT INTO heblb_vpl VALUES ("C22_15","077_2_15","2CO","2","15","15","אנחנו כניחוח המשיח לאלוהים בקרב הנושעים ובקרב הלא־נושעים. ");
INSERT INTO heblb_vpl VALUES ("C22_16","077_2_16","2CO","2","16","16","ללא־נושעים אנו כריח מוות, ואילו לנושעים אנו כניחוח המעניק חיים. אך מי ראוי למשימה כזאת? ");
INSERT INTO heblb_vpl VALUES ("C22_17","077_2_17","2CO","2","17","17","רק אלה אשר הם ישרים, שליחי אלוהים, מדברים בגבורת המשיח ובהשגחת אלוהים. איננו כאותם רבים שסוחרים בדבר־אלוהים לשם רווח. ");
INSERT INTO heblb_vpl VALUES ("C23_1","077_3_1","2CO","3","1","1","האם עלינו לשוב ולשבח את עצמנו? האם עלינו לנהוג כמורי השקר ולהציג לפניכם מכתבי המלצה? אני חושב שאיננו זקוקים למכתב המלצה אליכם או מכם! ");
INSERT INTO heblb_vpl VALUES ("C23_2","077_3_2","2CO","3","2","2","אתם בעצמכם מכתב ההמלצה שלנו, שהרי כל הרואה את השינוי לטובה שחל בכם יודע מיד שעשינו בכם עבודה טובה. ");
INSERT INTO heblb_vpl VALUES ("C23_3","077_3_3","2CO","3","3","3","אתם מראים שהינכם מכתב מאת המשיח שנכתב על־ידינו. הוא לא נכתב בדיו, אלא ברוח אלוהים חיים; אין הוא כתוב על לוחות אבן, אלא על לבבות של בשר ודם. ");
INSERT INTO heblb_vpl VALUES ("C23_4","077_3_4","2CO","3","4","4","אנו מעזים לומר דברים אלה על עצמנו רק משום שאנו בוטחים באלוהים, באמצעות המשיח, שהוא אכן יעזור לנו לקיים את דברינו, ");
INSERT INTO heblb_vpl VALUES ("C23_5","077_3_5","2CO","3","5","5","ולא משום שאנו סומכים על כוחנו ויכולתנו. כוחנו והצלחתנו באים מאלוהים לבדו! ");
INSERT INTO heblb_vpl VALUES ("C23_6","077_3_6","2CO","3","6","6","הוא הכשיר אותנו לספר לאחרים על בריתו החדשה שנועדה להושיעם. איננו אומרים להם שאם לא יצייתו לתורת ה׳ ימותו; אנו מספרים להם על רוח הקודש שמעניק חיים. הניסיון להיוושע על־ידי שמירת מצוות התורה סופו מוות, ואילו רוח הקודש מעניק חיים. ");
INSERT INTO heblb_vpl VALUES ("C23_7","077_3_7","2CO","3","7","7","השיטה הישנה של חוקי התורה, אשר הביאה מוות, לוותה בהוד כה רב, עד כי בני־ישראל לא יכלו להביט בפניו של משה. שכן במסרו לעם את לוחות הברית זרחו פניו בכבוד ה׳, אם כי הזוהר כבר החל לחלוף. ");
INSERT INTO heblb_vpl VALUES ("C23_8","077_3_8","2CO","3","8","8","אם השיטה הישנה לוותה בהוד כה רב, האם לא נצפה להוד רב יותר כשרוח הקודש מעניק חיים? ");
INSERT INTO heblb_vpl VALUES ("C23_9","077_3_9","2CO","3","9","9","אם התוכנית שהביאה מוות לוותה בהוד כה רב, הרי התוכנית שמצדיקה את האדם בעיני אלוהים מלווה בהוד נעלה יותר. ");
INSERT INTO heblb_vpl VALUES ("C23_10","077_3_10","2CO","3","10","10","למעשה הזוהר שקרן מפני משה הוא כאין וכאפס לעומת הוד הברית החדשה. ");
INSERT INTO heblb_vpl VALUES ("C23_11","077_3_11","2CO","3","11","11","שכן אם השיטה הישנה שחלפה והתבטלה לוותה בהוד, השיטה החדשה והנצחית מלווה בהוד נעלה הרבה יותר. ");
INSERT INTO heblb_vpl VALUES ("C23_12","077_3_12","2CO","3","12","12","מאחר שאנו יודעים כי הוד חדש זה קיים לנצח, אנו יכולים לבשר את דבר ה׳ באומץ רב. ");
INSERT INTO heblb_vpl VALUES ("C23_13","077_3_13","2CO","3","13","13","איננו כמשה אשר הסתיר את פניו כדי שבני־ישראל לא יביטו בזוהר שחולף ומתבטל. ");
INSERT INTO heblb_vpl VALUES ("C23_14","077_3_14","2CO","3","14","14","אך לבם של בני־ישראל קהה, שכן עד היום בקראם את הכתובים נדמה שמסווה נתון על לבם, ואין ביכולתם להבין את משמעות הכתובים. מסווה זה יוסר רק כשיאמינו בה׳. ");
INSERT INTO heblb_vpl VALUES ("C23_15","077_3_15","2CO","3","15","15","אכן, אפילו היום בקראם את תורת משה, המסווה מונח על לבם. ");
INSERT INTO heblb_vpl VALUES ("C23_16","077_3_16","2CO","3","16","16","אך בשובם אל ה׳ יוסר המסווה. ");
INSERT INTO heblb_vpl VALUES ("C23_17","077_3_17","2CO","3","17","17","האדון הוא הרוח, והיכן שנמצא רוח האדון שם יש חירות. ");
INSERT INTO heblb_vpl VALUES ("C23_18","077_3_18","2CO","3","18","18","אך אנו, המאמינים המשיחיים, אין מסווה על פנינו; אנו הולכים ומשקפים את כבוד ה׳ כמראה, ורוח הקודש הפועל בנו הופך אותנו בהדרגה לצלמו. ");
INSERT INTO heblb_vpl VALUES ("C24_1","077_4_1","2CO","4","1","1","אלוהים בעצמו נתן לנו ברחמיו את העבודה הנפלאה של הפצת דברו, ולכן איננו מתייאשים. ");
INSERT INTO heblb_vpl VALUES ("C24_2","077_4_2","2CO","4","2","2","איננו מרמים איש, איננו משתמשים בתכסיסים ותחבולות כדי להביא אנשים לידי אמונה, ומעולם לא סילפנו את דבר אלוהים. שכן אנו בוחלים בכל הונאה. אנו עומדים לנוכח ה׳ ודוברים אמת, וכל המכיר אותנו יודה בכך. ");
INSERT INTO heblb_vpl VALUES ("C24_3","077_4_3","2CO","4","3","3","אם הבשורה שאנו מספרים נסתרת מאיש, היא נסתרת מאלה שפניהם מועדות לאבדון. ");
INSERT INTO heblb_vpl VALUES ("C24_4","077_4_4","2CO","4","4","4","השטן, שהוא שר העולם המרושע הזה, עיוור את עיניהם, כדי שלא יוכלו לראות את אור הבשורה שזורח עליהם, ושלא יבינו את הבשורה הנפלאה על כבוד המשיח שהוא צלם האלוהים. ");
INSERT INTO heblb_vpl VALUES ("C24_5","077_4_5","2CO","4","5","5","איננו מכריזים על עצמנו, אלא על ישוע המשיח כאדון, ועל עצמנו כעבדיכם בזכות המשיח. ");
INSERT INTO heblb_vpl VALUES ("C24_6","077_4_6","2CO","4","6","6","האלוהים אשר אמר: ”יהי אור מן החושך“, הציף את לבנו באור דעת כבוד אלוהים אשר בפניו של המשיח. ");
INSERT INTO heblb_vpl VALUES ("C24_7","077_4_7","2CO","4","7","7","אך אוצר זה – האור והגבורה שזורחים בנו – טמון בכלי חרס בר־חלוף, כלומר בגופנו. עובדה זאת מוכיחה שהגבורה בתוכנו היא מאת אלוהים ולא מעצמנו. ");
INSERT INTO heblb_vpl VALUES ("C24_8","077_4_8","2CO","4","8","8","הצרות לוחצות עלינו מכל עבר, אך לא נשברנו. אנו נבוכים, אך לא נואשנו. ");
INSERT INTO heblb_vpl VALUES ("C24_9","077_4_9","2CO","4","9","9","אנו נרדפים, אך אלוהים לא נטש אותנו. אנו מוכים, אך לא הושמדנו. ");
INSERT INTO heblb_vpl VALUES ("C24_10","077_4_10","2CO","4","10","10","מדי יום אנו מתנסים במידת־מה במות המשיח, על מנת שגבורת חיי המשיח תיגלה בגופנו. ");
INSERT INTO heblb_vpl VALUES ("C24_11","077_4_11","2CO","4","11","11","אכן, חיינו בסכנה מתמדת כי אנו משרתים את האדון, אך הדבר מאפשר לנו להפגין את גבורת ישוע בגופנו בר־התמותה. ");
INSERT INTO heblb_vpl VALUES ("C24_12","077_4_12","2CO","4","12","12","לפיכך, אנו עומדים בפני מוות, בגלל הטפת דבר אלוהים, על־מנת שתזכו בחיי נצח. ");
INSERT INTO heblb_vpl VALUES ("C24_13","077_4_13","2CO","4","13","13","כתבי־הקודש אומרים: ”האמנתי כי אדבר.“ באותה רוח אמונה גם אנחנו מאמינים ולכן מדברים. ");
INSERT INTO heblb_vpl VALUES ("C24_14","077_4_14","2CO","4","14","14","אנו יודעים כי האלוהים אשר הקים לתחייה את האדון ישוע, יקים לתחייה גם אותנו עם ישוע ויציגנו לפניו יחד אתכם. ");
INSERT INTO heblb_vpl VALUES ("C24_15","077_4_15","2CO","4","15","15","סבלנו הוא למענכם, וככל שירבו מקרבכם המאמינים במשיח, כן ירבו המודים לו על טובו לכבוד אלוהים. ");
INSERT INTO heblb_vpl VALUES ("C24_16","077_4_16","2CO","4","16","16","משום כך איננו מתייאשים. גופנו הפיזי אמנם הולך ובלה, אך כוחנו הפנימי שמקורו בה׳ הולך ומתחזק מדי יום. ");
INSERT INTO heblb_vpl VALUES ("C24_17","077_4_17","2CO","4","17","17","צרתנו הקלה של הרגע תביא לנו את ברכתו העשירה והנצחית של אלוהים. ");
INSERT INTO heblb_vpl VALUES ("C24_18","077_4_18","2CO","4","18","18","לפיכך איננו מתרכזים בדברים שאנו רואים עתה, כלומר בצרות הסובבות אותנו, אלא עינינו נשואות לשמחה המצפה לנו בשמים ושטרם ראינו אותה. הצרות תעלמנה בקרוב, אך השמחה שמצפה לנו תעמוד לעולם. ");
INSERT INTO heblb_vpl VALUES ("C25_1","077_5_1","2CO","5","1","1","אנו יודעים שכאשר משכננו הארצי ייהרס, כלומר כאשר נמות ונצא מגופנו הגשמי, יצפה לנו בשמים משכן נצחי מאת אלוהים, שאינו מעשה ידי אדם. ");
INSERT INTO heblb_vpl VALUES ("C25_2","077_5_2","2CO","5","2","2","מה עייפנו מגופנו הנוכחי! אנו נכספים ליום שבו נקבל גוף חדש מן השמים אשר נלבשהו כבגד, ");
INSERT INTO heblb_vpl VALUES ("C25_3","077_5_3","2CO","5","3","3","כדי שלא נהיה נשמות ללא גוף. ");
INSERT INTO heblb_vpl VALUES ("C25_4","077_5_4","2CO","5","4","4","כל עוד אנו בגופנו הגשמי, אנו נאנחים מתוך דיכאון ומועקה, אך איננו רוצים למות ולהיוותר ללא גוף. ברצוננו ללבוש את הגוף החדש, כך שהגוף בן התמותה יבלע על־ידי החיים. ");
INSERT INTO heblb_vpl VALUES ("C25_5","077_5_5","2CO","5","5","5","אלוהים הוא שהכין כל זאת למעננו, וכערבות לכך נתן לנו את רוח הקודש. ");
INSERT INTO heblb_vpl VALUES ("C25_6","077_5_6","2CO","5","6","6","עתה אנו מצפים בביטחון לגופנו הרוחני, כי אנו יודעים שכל עוד אנו שוכנים בגופנו הגשמי אנו רחוקים מן האדון. ");
INSERT INTO heblb_vpl VALUES ("C25_7","077_5_7","2CO","5","7","7","אנו יודעים שאלה דברי אמת מתוך אמונה, ולא ממראה עיניים. ");
INSERT INTO heblb_vpl VALUES ("C25_8","077_5_8","2CO","5","8","8","אנו כה בטוחים בדבר, עד כי אנו מעדיפים לצאת מן הגוף ולבוא הביתה אל האדון. ");
INSERT INTO heblb_vpl VALUES ("C25_9","077_5_9","2CO","5","9","9","משום כך אנו משתדלים למצוא־חן בעיניו בכל מעשינו, אם אנו בגופנו הגשמי ואם בשמים. ");
INSERT INTO heblb_vpl VALUES ("C25_10","077_5_10","2CO","5","10","10","כי כולנו עתידים לעמוד לפני המשיח ולהישפט על־ידו. כל אחד יקבל את המגיע לו על־פי מעשיו הטובים או הרעים בחייו הגשמיים. ");
INSERT INTO heblb_vpl VALUES ("C25_11","077_5_11","2CO","5","11","11","מתוך הכרת יראת ה׳ אנו משתדלים להביא אנשים לידי אמונה בו. מניעינו הטהורים בעניין זה גלויים לפני אלוהים, ואני מקווה שגם לפני מצפונכם! ");
INSERT INTO heblb_vpl VALUES ("C25_12","077_5_12","2CO","5","12","12","האם אנו שוב טופחים לעצמנו על השכם? לא! אני נותן לכם הזדמנות להתגאות בנו לפי אלה המתפארים בהופעתם החיצונית ובדרך הטפתם, במקום בטוהר לבם. אנחנו לפחות ישרים ומניעינו טהורים. ");
INSERT INTO heblb_vpl VALUES ("C25_13","077_5_13","2CO","5","13","13","האם יצאנו מדעתנו? אם כן, הרי זה כדי להביא כבוד לאלוהים. אך אם דעתנו שפויה, הרי זה למענכם. ");
INSERT INTO heblb_vpl VALUES ("C25_14","077_5_14","2CO","5","14","14","איננו עושים דבר למען עצמנו, שכן אהבת המשיח מכוונת עתה את מעשינו. הואיל ואנו מאמינים שהמשיח מת בעד כולנו, עלינו להאמין שמתנו לגבי החיים שנהגנו לחיות. ");
INSERT INTO heblb_vpl VALUES ("C25_15","077_5_15","2CO","5","15","15","הוא מת למען כולם כדי שכל החיים – אשר קיבלו ממנו חיי נצח – שוב לא יחיו למען עצמם, אלא למען המשיח אשר מת וקם לתחייה בעדם. ");
INSERT INTO heblb_vpl VALUES ("C25_16","077_5_16","2CO","5","16","16","לכן חדלו לשפוט את המאמינים על־פי חיצוניותם או על־פי דעתם של הלא־מאמינים. פעם שגיתי ושפטתי את המשיח על־פי קנה מידה אנושי, אך איני עושה זאת שוב. ");
INSERT INTO heblb_vpl VALUES ("C25_17","077_5_17","2CO","5","17","17","המאמין במשיח נעשה בריאה חדשה; שוב אין הוא אותו אדם כמקודם, שכן יש בו עתה חיים חדשים. ");
INSERT INTO heblb_vpl VALUES ("C25_18","077_5_18","2CO","5","18","18","כל הדברים החדשים האלה הינם מאת האלוהים אשר השיבנו לעצמו בזכות קורבנו של המשיח. אלוהים העניק לנו את הזכות לעודד אחרים לשוב אליו, ");
INSERT INTO heblb_vpl VALUES ("C25_19","077_5_19","2CO","5","19","19","ולבשר להם שהוא מקרב אליו את כל בני־האדם באמצעות המשיח, ושוב אין הוא זוכר להם את חטאיהם. זוהי הבשורה הנפלאה שמסר לנו לבשר לאחרים. ");
INSERT INTO heblb_vpl VALUES ("C25_20","077_5_20","2CO","5","20","20","לפיכך שגרירי המשיח אנחנו, ואלוהים מזהיר אתכם באמצעותנו. על כן אנו מתחננים לפניכם בשם המשיח: אנא, היענו לאהבתו והתרצו לאלוהים. ");
INSERT INTO heblb_vpl VALUES ("C25_21","077_5_21","2CO","5","21","21","למרות שהמשיח היה ללא חטא, אלוהים שם בו את חטאינו, ואחר כך שם בנו את צדקת אלוהים. ");
INSERT INTO heblb_vpl VALUES ("C26_1","077_6_1","2CO","6","1","1","כעוזרי אלוהים אנו מתחננים לפניכם לא להזניח את חסד אלוהים שקיבלתם; אל תבזבזו את טובו וחסדו של אלוהים! ");
INSERT INTO heblb_vpl VALUES ("C26_2","077_6_2","2CO","6","2","2","כי הוא אומר: ”בעת רצון עניתיך וביום ישועה עזרתיך“. עתה עת רצון והיום יום ישועה! ");
INSERT INTO heblb_vpl VALUES ("C26_3","077_6_3","2CO","6","3","3","אנו משתדלים לא להיות מכשול לאיש, כדי שלא יטילו דופי בעבודתנו. ");
INSERT INTO heblb_vpl VALUES ("C26_4","077_6_4","2CO","6","4","4","אדרבא, בכל מעשינו אנו משתדלים להראות שאנו משרתי אלוהים. בסבלנות רבה אנו נושאים סבל, צרות ומצוקות. ");
INSERT INTO heblb_vpl VALUES ("C26_5","077_6_5","2CO","6","5","5","הוכינו, הושלכנו לכלא, נמסרנו לידי המון זועם; עמלנו עד אפיסת כוחות, לא אכלנו ולא ישנו. ");
INSERT INTO heblb_vpl VALUES ("C26_6","077_6_6","2CO","6","6","6","הוכחנו שאנו משרתי אלוהים בחיינו הטהורים, בהבנתנו את הבשורה, בסבלנותנו, בנדיבות לבנו, באהבתנו הכנה, ברוח הקודש הממלא אותנו, ");
INSERT INTO heblb_vpl VALUES ("C26_7","077_6_7","2CO","6","7","7","בדבר האמת שבפינו ובגבורת אלוהים. אנו חמושים בנשק הצדקה להגנה ולהתקפה. ");
INSERT INTO heblb_vpl VALUES ("C26_8","077_6_8","2CO","6","8","8","אנו שומרים על נאמנותנו לאדון אם מכבדים אותנו ואם בזים לנו, אם מבקרים או משבחים אותנו. אנו כנים וישרים אך נחשבים לשקרנים. ");
INSERT INTO heblb_vpl VALUES ("C26_9","077_6_9","2CO","6","9","9","העולם מתעלם מאתנו, אך רבים מכירים אותנו; אנו קרובים למוות, ובכל זאת חיים. נפצענו אך לא מתנו. ");
INSERT INTO heblb_vpl VALUES ("C26_10","077_6_10","2CO","6","10","10","לבנו מלא צער, ובכל זאת אנו שמחים באדון. אנו אמנם עניים, אך מעשירים אנשים רבים במתנות רוחניות. אנו חסרי־כל אך נהנים מן הכול. ");
INSERT INTO heblb_vpl VALUES ("C26_11","077_6_11","2CO","6","11","11","הו, ידידי הקורינתיים, דיברתי אליכם בכנות ופתחתי לפניכם את לבי. ");
INSERT INTO heblb_vpl VALUES ("C26_12","077_6_12","2CO","6","12","12","לא סגרתי את לבי בפניכם; אתם סגרתם את לבכם בפני! ");
INSERT INTO heblb_vpl VALUES ("C26_13","077_6_13","2CO","6","13","13","אני פונה אליכם עתה כאל בני: אנא, פתחו לנו את לבכם והיענו לאהבתנו. ");
INSERT INTO heblb_vpl VALUES ("C26_14","077_6_14","2CO","6","14","14","אל תיכנסו לשותפות עם אלה שאינם אוהבים את האדון, שכן מה המשותף לאנשי אלוהים ולאנשי חטא? כיצד יכול האור לחיות עם החושך? ");
INSERT INTO heblb_vpl VALUES ("C26_15","077_6_15","2CO","6","15","15","איזו הסכמה יכולה להיות בין המשיח לבין השטן? כיצד יכול המאמין להיות שותף ללא־מאמין? ");
INSERT INTO heblb_vpl VALUES ("C26_16","077_6_16","2CO","6","16","16","איזה קשר יש להיכל אלוהים עם האלילים? הלא אתם היכל אלוהים, משכן אלוהים חיים, שכן הוא עצמו אמר: ”ונתתי משכני בתוככם … והתהלכתי בתוככם והייתי לכם לאלוהים ואתם תהיו לי לעם“. ");
INSERT INTO heblb_vpl VALUES ("C26_17","077_6_17","2CO","6","17","17","על כן אמר ה׳: ”צאו מתוכם והברו, נאום ה׳, וטמא אל תיגעו ואני אקבץ אתכם. ");
INSERT INTO heblb_vpl VALUES ("C26_18","077_6_18","2CO","6","18","18","והייתי לכם לאב ואתם תהיו לי לבנים ולבנות, נאום ה׳ צבאות.“ ");
INSERT INTO heblb_vpl VALUES ("C27_1","077_7_1","2CO","7","1","1","ידידים יקרים, הואיל ויש לנו הבטחות נפלאות כאלה, הבה נטהר את עצמנו מכל טומאה רוחנית וגופנית. הבה נחיה ביראת אלוהים ונקדיש לו את עצמנו. ");
INSERT INTO heblb_vpl VALUES ("C27_2","077_7_2","2CO","7","2","2","אנא, פתחו לנו את לבכם. הרי לא פגענו באיש, לא רימינו ולא ניצלנו איש מכם. ");
INSERT INTO heblb_vpl VALUES ("C27_3","077_7_3","2CO","7","3","3","איני אומר זאת כדי להרשיע אתכם, שהרי כבר אמרתי שאתם כה יקרים לי, עד כי אחיה ואמות עמכם. ");
INSERT INTO heblb_vpl VALUES ("C27_4","077_7_4","2CO","7","4","4","יש לי ביטחון רב בכם, ואני גאה בכם מאוד. עודדתם ושימחתם אותי למרות סבלי וצרותי. ");
INSERT INTO heblb_vpl VALUES ("C27_5","077_7_5","2CO","7","5","5","בהגיענו למקדוניה, לא מצאנו מנוחה לגופנו. הצרות הקיפונו מכל עבר: מריבות מבחוץ וחרדה מבפנים. ");
INSERT INTO heblb_vpl VALUES ("C27_6","077_7_6","2CO","7","6","6","אך אלוהים המעודד את הנדכאים ניחם אותנו בבואו של טיטוס. ");
INSERT INTO heblb_vpl VALUES ("C27_7","077_7_7","2CO","7","7","7","לא רק נוכחותו שימחה אותנו, אלא גם החדשות על שעזרתם לו ועודדתם אותו. הוא סיפר לנו על געגועיכם אלי, על השתתפותכם בסבלי, על נאמנותכם ואהבתכם אלי. חדשות אלה ממלאות אותי שמחה רבה. ");
INSERT INTO heblb_vpl VALUES ("C27_8","077_7_8","2CO","7","8","8","גם אם העצבתי אתכם במכתבי האחרון, איני מתחרט על כך. האמת היא שבתחילה הצטערתי מאוד, כי ידעתי שיכאיב לכם, אך הוא הכאיב לכם לזמן קצר בלבד. ");
INSERT INTO heblb_vpl VALUES ("C27_9","077_7_9","2CO","7","9","9","עתה אני שמח, לא בגלל שהכאיב לכם, אלא בגלל שהכאב הביא אתכם לידי תשובה. שכן נעצבתם ברצון אלוהים, ואנו לא גרמנו לכם כל נזק. ");
INSERT INTO heblb_vpl VALUES ("C27_10","077_7_10","2CO","7","10","10","עצב הבא עלינו ברצון אלוהים מביא אותנו לידי תשובה וישועה, ואיש אינו מתחרט על כך. לעומת זאת, עצב הבא על הלא־מאמינים אינו מביא לידי תשובה, אלא למוות. ");
INSERT INTO heblb_vpl VALUES ("C27_11","077_7_11","2CO","7","11","11","ראו מה עורר בכם העצב מאלוהים: נמלאתם חריצות וחפצתם להיפטר מהחטא שעליו כתבתי לכם. נבהלתם ממה שקרה והשתוקקתם שאבוא לעזרתכם. מיד נקטתם צעדים לפתור את הבעיה (והענשתם את החוטא). בכל מעשיכם הוכחתם שבעניין ההוא אין בכם דופי. ");
INSERT INTO heblb_vpl VALUES ("C27_12","077_7_12","2CO","7","12","12","לא כתבתי את המכתב למען האדם שחטא, ואף לא למען זה שנפגע מהחטא; כתבתי כדי שאלוהים יראה לכם באיזו מידה אתם אוהבים אותנו. ");
INSERT INTO heblb_vpl VALUES ("C27_13","077_7_13","2CO","7","13","13","מלבד נחמתנו מאהבתכם, שמחנו במיוחד בשמחתו של טיטוס, שכן קיבלתם אותו בחמימות וגרמתם לנו נחת רוח. ");
INSERT INTO heblb_vpl VALUES ("C27_14","077_7_14","2CO","7","14","14","התגאיתי בכם לפניו, ואני שמח שלא אכזבתם אותי. הלא תמיד דיברתי אליכם אמת, ואף הפעם התפארותי הוכחה כאמת. ");
INSERT INTO heblb_vpl VALUES ("C27_15","077_7_15","2CO","7","15","15","טיטוס אוהב אתכם יותר מתמיד בזכרו כיצד הקשבתם לו בדריכות, וקיבלתם אותו ביראה ובחרדה. ");
INSERT INTO heblb_vpl VALUES ("C27_16","077_7_16","2CO","7","16","16","מה שמח אני על ששוב אני יכול לסמוך עליכם ולבטוח בכם בכל דבר. ");
INSERT INTO heblb_vpl VALUES ("C28_1","077_8_1","2CO","8","1","1","ברצוני לספר לכם על החסד שהעניק אלוהים לקהילות במקדוניה. ");
INSERT INTO heblb_vpl VALUES ("C28_2","077_8_2","2CO","8","2","2","הם אמנם התנסו בסבל רב ובצרות, אך שמחתם הייתה כה גדולה עד כי הפגינו נדיבות ורוחב־לב למרות העוני שלהם. ");
INSERT INTO heblb_vpl VALUES ("C28_3","077_8_3","2CO","8","3","3","הם נתנו לא רק כפי יכולתם, אלא מעל ומעבר ליכולתם, ואני יכול להעיד שעשו זאת מרצון ולא מכורח. ");
INSERT INTO heblb_vpl VALUES ("C28_4","077_8_4","2CO","8","4","4","הם ממש התחננו לפנינו לקבל את מתנתם הכספית, כדי שישתתפו בשמחה שבעזרה למאמינים בירושלים. ");
INSERT INTO heblb_vpl VALUES ("C28_5","077_8_5","2CO","8","5","5","נדיבותם עלתה על ציפיותינו, שכן קודם הקדישו את עצמם לאדון ואחר כך לנו, לפי רצון אלוהים. ");
INSERT INTO heblb_vpl VALUES ("C28_6","077_8_6","2CO","8","6","6","הם כל־כך התלהבו מהדבר, עד שהאצנו בטיטוס, אשר עודד אתכם בתחילה לעזור למאמינים, לבקרכם ולעודד אתכם להשלים את חלקכם בשירות זה של גמילות חסדים. ");
INSERT INTO heblb_vpl VALUES ("C28_7","077_8_7","2CO","8","7","7","אתם הלא מצטיינים בתחומים רבים: באמונתכם הרבה, במספר המטיפים ביניכם, בדעת, בשקידה ובאהבתכם אלינו. עתה ברצוני שתצטיינו גם בנדיבותכם. ");
INSERT INTO heblb_vpl VALUES ("C28_8","077_8_8","2CO","8","8","8","איני מצווה עליכם לעשות זאת; ברצוני רק לבחון את כנות אהבתכם בהשוואה להתלהבותם של אחרים. ");
INSERT INTO heblb_vpl VALUES ("C28_9","077_8_9","2CO","8","9","9","הלא יודעים אתם את אהבתו וחסדו של ישוע אדוננו: למרות היותו עשיר הוא נעשה עני למענכם, כדי שתעשירו על־ידי עניותו. ");
INSERT INTO heblb_vpl VALUES ("C28_10","077_8_10","2CO","8","10","10","אני מציע שתשלימו את אשר התחלתם לעשות לפני שנה, שהרי הייתם לא רק הראשונים להציע את הרעיון, אלא גם הראשונים לעשות משהו בנידון. ");
INSERT INTO heblb_vpl VALUES ("C28_11","077_8_11","2CO","8","11","11","עתה השלימו את המלאכה באותה התלהבות שבה התחלתם, ותנו ככל שמשגת ידכם. ");
INSERT INTO heblb_vpl VALUES ("C28_12","077_8_12","2CO","8","12","12","אם אתם באמת מוכנים לתת, אין זה חשוב אם יש באפשרותכם לתת רק סכום קטן, שכן אלוהים אינו מצפה מכם לתת מה שאין לכם. ");
INSERT INTO heblb_vpl VALUES ("C28_13‏","077_8_13‏","2CO","8","13‏","14","איני מתכוון שמקבלי התרומות יחיו ברווחה על חשבונכם, אך עליכם להתחלק עמם. כעת יש לכם די והותר ובאפשרותכם לעזור להם; בעת הצורך הם יתחלקו עמכם. כך לכל אחד יהיה כפי צרכו. ");
INSERT INTO heblb_vpl VALUES ("C28_15","077_8_15","2CO","8","15","15","הזוכרים אתם מה אומרים על כך הכתובים? ”לא העדיף המרבה, והממעיט לא החסיר“. לכן עליכם להתחלק עם הנזקקים. ");
INSERT INTO heblb_vpl VALUES ("C28_16","077_8_16","2CO","8","16","16","אני מודה לאלוהים על ששם בלב טיטוס אותה התלהבות לעזור לכם כמונו. ");
INSERT INTO heblb_vpl VALUES ("C28_17","077_8_17","2CO","8","17","17","הוא שמח לקבל את הצעתי לבקרכם, אך אני בטוח שהיה בא לבקרכם גם אלמלא הצעתי, שכן הוא משתוקק לראותכם. ");
INSERT INTO heblb_vpl VALUES ("C28_18","077_8_18","2CO","8","18","18","אני שולח עם טיטוס אח שמוכר היטב בין כל הקהילות כמטיף מחונן של בשורת אלוהים. ");
INSERT INTO heblb_vpl VALUES ("C28_19","077_8_19","2CO","8","19","19","אח זה נבחר למעשה על־ידי הקהילות להתלוות אלי במסעי לירושלים, כדי להביא את המתנה למאמינים שם. הדבר יכבד את אלוהים ויוכיח את נכונותנו לעזור זה לזה. ");
INSERT INTO heblb_vpl VALUES ("C28_20","077_8_20","2CO","8","20","20","ברצוננו למנוע כל ביקורת על הדרך שבה אנו מטפלים בתרומה נדיבה זו. ");
INSERT INTO heblb_vpl VALUES ("C28_21","077_8_21","2CO","8","21","21","אלוהים יודע את יושר לבנו, אך ברצוני שגם אתם תדעו זאת. משום כך החלטנו לנסוע יחד. ");
INSERT INTO heblb_vpl VALUES ("C28_22","077_8_22","2CO","8","22","22","אני שולח אליכם אח נוסף אשר הוכיח את מסירותו פעמים רבות. עתה מסירותו והתלהבותו גדלו עוד יותר, שכן סיפרתי לו על נכונותכם לעזור בעניין התרומה. ");
INSERT INTO heblb_vpl VALUES ("C28_23","077_8_23","2CO","8","23","23","אם מישהו ישאל לזהותו של טיטוס, אמרו שהוא שותפי ועובד אתי למענכם. אתם גם יכולים לומר ששני האחים האחרים מייצגים את הקהילות כאן והם דוגמת מופת למאמינים במשיח. ");
INSERT INTO heblb_vpl VALUES ("C28_24","077_8_24","2CO","8","24","24","אנא, הוכיחו לאנשים אלה שאתם באמת אוהבים אותי, ושיש לי סיבה להתגאות בכם. ");
INSERT INTO heblb_vpl VALUES ("C29_1","077_9_1","2CO","9","1","1","איני צריך לכתוב לכם על העזרה הכספית למאמינים ביהודה, ");
INSERT INTO heblb_vpl VALUES ("C29_2","077_9_2","2CO","9","2","2","כי אני יודע שאתם מוכנים לעזור, ואף התגאיתי בכם לפני המאמינים במקדוניה. ”המאמינים ביוון היו מוכנים לשלוח תרומה כבר לפני שנה“, אמרתי להם. התלהבותכם עוררה רבים מהם להשתתף בתרומה. ");
INSERT INTO heblb_vpl VALUES ("C29_3","077_9_3","2CO","9","3","3","עתה אני שולח אחים אלה רק כדי לוודא שאתם באמת מוכנים ושכבר אספתם את כל התרומות, כפי שאמרתי להם. איני רוצה לגלות שהפעם התגאיתי בכם לשווא. ");
INSERT INTO heblb_vpl VALUES ("C29_4","077_9_4","2CO","9","4","4","אם יבואו אתי האנשים ממקדוניה וייווכחו שאינכם מוכנים, הרי אתבייש מאוד וגם אתם תתביישו. ");
INSERT INTO heblb_vpl VALUES ("C29_5","077_9_5","2CO","9","5","5","על כן ביקשתי מהאחים לבוא אליכם לפני, כדי לוודא שהתרומה אשר הבטחתם אכן מוכנה. ברצוני שתתרמו מתוך נדיבות ולא מתוך קמצנות. ");
INSERT INTO heblb_vpl VALUES ("C29_6","077_9_6","2CO","9","6","6","זכרו, אם תתנו מעט תקבלו מעט. איכר שזורע זרעים מעטים יקצור יבול דל, אך אם יזרע זרעים רבים יקצור יבול רב. ");
INSERT INTO heblb_vpl VALUES ("C29_7","077_9_7","2CO","9","7","7","כל אחד ייתן כאשר ידרבנו לבו; אל תאלצו איש לתת מעל רצונו, כי אלוהים אוהב את הנותנים בשמחה. ");
INSERT INTO heblb_vpl VALUES ("C29_8","077_9_8","2CO","9","8","8","אלוהים יכול לתת לכם מעל מה שאתם צריכים, כך שתמיד יהיה לכם די והותר לעצמכם, ואף תוכלו לתת לנזקקים בנדיבות ובשמחה. ");
INSERT INTO heblb_vpl VALUES ("C29_9","077_9_9","2CO","9","9","9","ככתוב: ”פזר נתן לאביונים, צדקתו עומדת לעד“. ");
INSERT INTO heblb_vpl VALUES ("C29_10","077_9_10","2CO","9","10","10","האלוהים שנותן לאיכר זרע לזרוע, ואחר כך יבול לאכול, ייתן לכם זרע בשפע ויברך את יבול מעשיכם הטובים. ");
INSERT INTO heblb_vpl VALUES ("C29_11","077_9_11","2CO","9","11","11","אכן, אלוהים ייתן לכם שפע כדי שתוכלו לתת לזולת בשפע, וכאשר נמסור את מתנותיכם לנזקקים הם יודו לאלוהים על עזרתכם הנדיבה. ");
INSERT INTO heblb_vpl VALUES ("C29_12","077_9_12","2CO","9","12","12","וכך שירותכם לא רק יספק את צרכי המאמינים, אלא גם יביאם לידי הודיה לה׳. ");
INSERT INTO heblb_vpl VALUES ("C29_13","077_9_13","2CO","9","13","13","הואיל ושירותכם זה עמד במבחן, יודו רבים לה׳ על עזרתכם הנדיבה, ועל שאתם מקיימים הלכה למעשה את בשורת המשיח שבה אתם מאמינים. ");
INSERT INTO heblb_vpl VALUES ("C29_14","077_9_14","2CO","9","14","14","יתרה מזאת, הם יתפללו בעדכם בחיבה רבה, בגלל החסד הנפלא שהעניק לכם אלוהים. ");
INSERT INTO heblb_vpl VALUES ("C29_15","077_9_15","2CO","9","15","15","הבה נודה לאלוהים על מתנתו העצומה מספר. ");
INSERT INTO heblb_vpl VALUES ("C210_1","077_10_1","2CO","10","1","1","אני, פולוס, מתחנן לפניכם בענווה, כפי שהמשיח היה מתחנן לפניכם. אחדים מכם טוענים: ”מכתביו של פולוס נועזים כל עוד הוא רחוק מאתנו, אך בבואו הנה יפחד להרים את קולו!“ ");
INSERT INTO heblb_vpl VALUES ("C210_2","077_10_2","2CO","10","2","2","אני מתחנן לפניכם שלא תאלצוני לנהוג בכם ביד קשה בבואי אליכם, כי אני בטוח שאוכל לנהוג בחומרה באלה שטוענים שמעשי ומניעי הינם של אדם רגיל. ");
INSERT INTO heblb_vpl VALUES ("C210_3","077_10_3","2CO","10","3","3","אני אמנם אדם רגיל וחלש, אך איני נלחם את מלחמותיי בדרך אנושית רגילה. ");
INSERT INTO heblb_vpl VALUES ("C210_4","077_10_4","2CO","10","4","4","איני נלחם בכלי מלחמה רגילים, אלא בכלי המלחמה של אלוהים, ובעזרתם אני הורס את מבצרי השטן. ");
INSERT INTO heblb_vpl VALUES ("C210_5","077_10_5","2CO","10","5","5","אכן, כלי מלחמה אלה יכולים למוטט תחבולות וכל דבר שמתנשא נגד דעת אלוהים. בעזרתם אני מכניע את אלה לציות למשיח. ");
INSERT INTO heblb_vpl VALUES ("C210_6","077_10_6","2CO","10","6","6","אני מוכן להעניש כל הפרת משמעת עד שתושלם המשמעת שלכם במשיח. ");
INSERT INTO heblb_vpl VALUES ("C210_7","077_10_7","2CO","10","7","7","הבעיה אתכם היא, שאתם מסתכלים רק בקנקן ולא במה שיש בו. אם מישהו בטוח בעצמו שהוא שייך למשיח, שלא ישכח שאני שייך למשיח בדיוק כמוהו! ");
INSERT INTO heblb_vpl VALUES ("C210_8","077_10_8","2CO","10","8","8","גם אם נראה שאני מתגאה מדי על הסמכות שנתן לי האדון, לבנותכם ולא לפגוע בכם, איני מתבייש. ");
INSERT INTO heblb_vpl VALUES ("C210_9","077_10_9","2CO","10","9","9","אני אומר זאת כדי שלא תחשבו שאני מאיים עליכם סתם במכתבי. ");
INSERT INTO heblb_vpl VALUES ("C210_10","077_10_10","2CO","10","10","10","”אל תשימו לב למכתביו של פולוס“, אומרים אחדים מכם. ”הוא אמנם נשמע מרשים ותקיף, אך בבואו אלינו אישית תראו שהוא חלש ודיבורו אינו משכנע.“ ");
INSERT INTO heblb_vpl VALUES ("C210_11","077_10_11","2CO","10","11","11","הפעם ביקורי האישי יהיה מרשים ותקיף כמכתבי. ");
INSERT INTO heblb_vpl VALUES ("C210_12","077_10_12","2CO","10","12","12","כמובן שאיני מעיז לכלול את עצמי עם אלה שמשבחים את עצמם, ואף לא להשוות את עצמי אליהם. מה טיפשים הם! הם משווים את עצמם לעצמם, ושופטים את עצמם על־פי קנה המידה שקבעו בעצמם. ");
INSERT INTO heblb_vpl VALUES ("C210_13","077_10_13","2CO","10","13","13","אנחנו לעומתם איננו מתפארים יתר על המידה; אנו מתפארים רק בתחום העבודה שהקצה לנו אלוהים, ואתם נכללים בתחום זה. ");
INSERT INTO heblb_vpl VALUES ("C210_14","077_10_14","2CO","10","14","14","איננו מפריזים בסמכותנו עליכם, שכן אנו הבאנו לכם ראשונים את בשורת המשיח. ");
INSERT INTO heblb_vpl VALUES ("C210_15","077_10_15","2CO","10","15","15","איננו מתפארים בדברים מעבר לתחומנו, ואף לא בעמלם של אחרים. אנו רק מקווים שאמונתכם תגדל ושעבודתנו ביניכם תגדל גם היא, אך רק בתחום שהוקצה לנו. ");
INSERT INTO heblb_vpl VALUES ("C210_16","077_10_16","2CO","10","16","16","לאחר מכן נוכל לבשר את הבשורה לערים הרחוקות מכם, היכן שאיש אינו מבשר את הבשורה, וכך לא נפלוש לתחומם של אחרים. ");
INSERT INTO heblb_vpl VALUES ("C210_17","077_10_17","2CO","10","17","17","הכתובים אומרים: ”המתהלל יתהלל בה׳!“ ");
INSERT INTO heblb_vpl VALUES ("C210_18","077_10_18","2CO","10","18","18","כי הלא אין ערך רב להתפארותו של אדם בעצמו, אך כאשר אלוהים משבח אדם יש לשבח ערך רב! ");
INSERT INTO heblb_vpl VALUES ("C211_1","077_11_1","2CO","11","1","1","אני מקווה שתתייחסו אלי בסבלנות גם אם אני מדבר בטיפשות. אנא, סלחו לי והניחו לי לומר את אשר על לבי. ");
INSERT INTO heblb_vpl VALUES ("C211_2","077_11_2","2CO","11","2","2","אני דואג לכם דאגה עמוקה כאלוהים עצמו; אתם כבתולה טהורה שהארשתי לאיש אחד, למשיח. ");
INSERT INTO heblb_vpl VALUES ("C211_3","077_11_3","2CO","11","3","3","אך אני חושש שמא תסטו יום אחד ממסירותכם הטהורה למשיח, כשם שחווה רומתה על־ידי הנחש בגן העדן. ");
INSERT INTO heblb_vpl VALUES ("C211_4","077_11_4","2CO","11","4","4","אתם מתנהגים כפתאים ומאמינים לכל מה שאומרים לכם, גם אם מישהו מכריז לכם על ישוע השונה מזה שהכרזנו, או על רוח ששונה מרוח הקודש שקיבלתם, או על דרך שונה לישועה. אכן, אתם מוכנים להאמין לכל דבר! ");
INSERT INTO heblb_vpl VALUES ("C211_5","077_11_5","2CO","11","5","5","סבורני שאיני נופל במאומה מ”שליחים“ מיוחדים אלה! ");
INSERT INTO heblb_vpl VALUES ("C211_6","077_11_6","2CO","11","6","6","אולי אינני נואם מעולה, אך אני יודע לפחות על מה אני מדבר, כפי שהוכחנו לכם פעמים רבות. ");
INSERT INTO heblb_vpl VALUES ("C211_7","077_11_7","2CO","11","7","7","האם חטאתי כשהשפלתי את עצמי (כדי לרומם אתכם!) ובישרתי לכם את בשורת האלוהים ללא תשלום? ");
INSERT INTO heblb_vpl VALUES ("C211_8","077_11_8","2CO","11","8","8","קהילות אחרות תמכו בי בעת שעבדתי למענכם. כן, לקחתי את כספם כדי לעזור לכם. ");
INSERT INTO heblb_vpl VALUES ("C211_9","077_11_9","2CO","11","9","9","בכל עת שהותי עמכם לא ביקשתי מכם פרוטה; האחים שבאו ממקדוניה סיפקו את כל צרכי. מעולם לא ביקשתי מכם דבר, וגם להבא לא אבקש. ");
INSERT INTO heblb_vpl VALUES ("C211_10","077_11_10","2CO","11","10","10","בשם אמת המשיח בי, אני מבטיח שאתגאה על כך בכל יוון! ");
INSERT INTO heblb_vpl VALUES ("C211_11","077_11_11","2CO","11","11","11","מדוע? האם משום שאיני אוהב אתכם? אלוהים יודע שאני אוהב אתכם! ");
INSERT INTO heblb_vpl VALUES ("C211_12","077_11_12","2CO","11","12","12","אעשה זאת כדי לסכור את פיהם של אלה שמתפארים וטוענים: ”אנחנו עושים את עבודת אלוהים בדיוק כמו פולוס וטימותיוס!“ ");
INSERT INTO heblb_vpl VALUES ("C211_13","077_11_13","2CO","11","13","13","אנשים אלה הינם שליחי־שקר, רמאים שמתחפשים לשליחי המשיח. ");
INSERT INTO heblb_vpl VALUES ("C211_14","077_11_14","2CO","11","14","14","אך איני מתפלא על כך! אם השטן עצמו יכול להתחפש למלאך אור, ");
INSERT INTO heblb_vpl VALUES ("C211_15","077_11_15","2CO","11","15","15","אין פלא שמשרתיו יכולים להתחפש למשרתי צדק. אך לבסוף הם יקבלו את העונש שמגיע להם על מעלליהם. ");
INSERT INTO heblb_vpl VALUES ("C211_16","077_11_16","2CO","11","16","16","אני חוזר ואומר, אל תחשבוני לשוטה, אך גם אם אתם חושבים אותי לשוטה, הקשיבו לי בכל זאת והניחו לי להתגאות כמוהם. ");
INSERT INTO heblb_vpl VALUES ("C211_17","077_11_17","2CO","11","17","17","גאווה זאת לא ניתנה לי מאת המשיח, שכן אני נוהג כשוטה. ");
INSERT INTO heblb_vpl VALUES ("C211_18","077_11_18","2CO","11","18","18","אך מאחר שרבים מתגאים על הישגיהם האנושיים, גם אני אתגאה כמוהם. ");
INSERT INTO heblb_vpl VALUES ("C211_19","077_11_19","2CO","11","19","19","אתם חושבים את עצמכם לחכמים גדולים, אך אתם מקשיבים ברצון לשוטים האלה. ");
INSERT INTO heblb_vpl VALUES ("C211_20","077_11_20","2CO","11","20","20","לא אכפת לכם אם הם משעבדים אתכם, מנצלים אתכם, מכשילים אתכם, סוטרים על פניכם או מתנשאים עליכם. ");
INSERT INTO heblb_vpl VALUES ("C211_21","077_11_21","2CO","11","21","21","אני מתבייש להודות שאיני חזק או נועז כמוהם. אך בכל מה שהם יכולים להתגאות, אני שוב מדבר כשוטה, גם אני יכול להתגאות! ");
INSERT INTO heblb_vpl VALUES ("C211_22","077_11_22","2CO","11","22","22","האם הם עברים? גם אני. האם הם ישראלים? גם אני. זרע אברהם? גם אני. ");
INSERT INTO heblb_vpl VALUES ("C211_23","077_11_23","2CO","11","23","23","האם הם משרתי המשיח? אולי אני מדבר כשוטה, אך אני משרת טוב מהם! עמלתי קשה מהם, הושלכתי לכלא פעמים רבות מהם, הוכיתי יותר, ועמדתי לפני המוות פעמים רבות יותר. ");
INSERT INTO heblb_vpl VALUES ("C211_24","077_11_24","2CO","11","24","24","חמש פעמים הלקוני היהודים שלושים־ותשע מלקות. ");
INSERT INTO heblb_vpl VALUES ("C211_25","077_11_25","2CO","11","25","25","שלוש פעמים הולקיתי בשוטים, פעם אחת נסקלתי באבנים, שלוש פעמים נטרפה ספינתי, ופעם נסחפתי עשרים־וארבע שעות בים הפתוח. ");
INSERT INTO heblb_vpl VALUES ("C211_26","077_11_26","2CO","11","26","26","במסעותיי הרבים והמעייפים ניצלתי מסכנת שיטפונות, מידי שודדים, מידי היהודים ומידי הגויים. הותקפתי על־ידי המון בערים שונות, ניצלתי ממוות במדבר, מטביעה בים ומאנשים שהתחזו כמאמינים משיחיים. ");
INSERT INTO heblb_vpl VALUES ("C211_27","077_11_27","2CO","11","27","27","עמלתי וטרחתי ולילות רבים לא עצמתי עין. פעמים רבות רעבתי וצמאתי; כן, הייתי ללא אוכל, לבוש או קורת־גג. ");
INSERT INTO heblb_vpl VALUES ("C211_28","077_11_28","2CO","11","28","28","מלבד כל אלה אני נושא עמי דאגה מתמדת לשלום הקהילות. ");
INSERT INTO heblb_vpl VALUES ("C211_29","077_11_29","2CO","11","29","29","כאשר מישהו שוגה, אני חש בצערו. כאשר מישהו חוטא, לבי כואב. ");
INSERT INTO heblb_vpl VALUES ("C211_30","077_11_30","2CO","11","30","30","אם עלי להתגאות, אני בוחר להתגאות בדברים שמראים את חולשתי. ");
INSERT INTO heblb_vpl VALUES ("C211_31","077_11_31","2CO","11","31","31","האלוהים ואבי המשיח אדוננו, יבורך שמו לעולמים, יודע שאני דובר אמת. ");
INSERT INTO heblb_vpl VALUES ("C211_32","077_11_32","2CO","11","32","32","בהיותי בדמשק, המושל מטעם המלך ארטס הפקיד שומרים על שערי העיר כדי לתפסני, ");
INSERT INTO heblb_vpl VALUES ("C211_33","077_11_33","2CO","11","33","33","אך הורדתי בסל דרך פתח בחומה ונמלטתי מידיו. ");
INSERT INTO heblb_vpl VALUES ("C212_1","077_12_1","2CO","12","1","1","התפארות זאת טיפשית כל־כך, אך הרשו לי להמשיך. ברצוני לספר לכם על חזיונות והתגלויות שהיו לי מאת האדון. ");
INSERT INTO heblb_vpl VALUES ("C212_2‏","077_12_2‏","2CO","12","2‏","3","אני מכיר מאמין אחד שנלקח לשמים לפני ארבע־עשרה שנים. אני יודע שהאיש הזה (אם בגוף ממש או שבנפרד מגופו רק האלוהים יודע). ");
INSERT INTO heblb_vpl VALUES ("C212_4","077_12_4","2CO","12","4","4","נלקח לשמים ושמע דברים כה מדהימים, עד כי לא ניתן לבטאם, ואסור לחזור עליהם. ");
INSERT INTO heblb_vpl VALUES ("C212_5","077_12_5","2CO","12","5","5","חוויה כזאת ראויה להתגאות בה, אך איני מתכוון לעשות כן. אתגאה רק בחולשותיי. ");
INSERT INTO heblb_vpl VALUES ("C212_6","077_12_6","2CO","12","6","6","לא חסר לי במה להתגאות, ואף לא אנהג כשוטה אם אתגאה, אך איני רוצה שאיש יחשבני ליותר ממה שראה במעשי ובדיבורי. ");
INSERT INTO heblb_vpl VALUES ("C212_7","077_12_7","2CO","12","7","7","על־מנת שלא אתמלא יהירות בגלל הדברים הנפלאים שראיתי, ניתנה לי קוץ בבשרי, שליח מאת השטן להטרידני ולעקוץ את גאוותי. ");
INSERT INTO heblb_vpl VALUES ("C212_8","077_12_8","2CO","12","8","8","שלוש פעמים התחננתי לאלוהים שייקח אותו ממני, ");
INSERT INTO heblb_vpl VALUES ("C212_9","077_12_9","2CO","12","9","9","ברם בכל פעם האדון אמר לי: ”לא. אך אני אתך, ואינך זקוק ליותר. גבורתי נשלמת בחולשתך.“ עתה אני שמח להתגאות בחולשתי; במקום שאפגין את כוחי ויכולתי, אני שמח להיות דוגמה חיה לגבורת המשיח. ");
INSERT INTO heblb_vpl VALUES ("C212_10","077_12_10","2CO","12","10","10","הואיל ואני יודע שחולשתי מפארת את המשיח, אני שמח ב”קוץ“ הזה שבבשרי, בעלבונות, בצרות, ברדיפות ובמצוקות. שכן בהיותי חלש, אז אני חזק – ככל שאני חלש יותר כך אני תלוי יותר במשיח. ");
INSERT INTO heblb_vpl VALUES ("C212_11","077_12_11","2CO","12","11","11","אני מתנהג כשוטה, אך אתם גרמתם לכך. אתם הייתם צריכים להתגאות בי, כי למרות שאני כאין וכאפס, איני נופל במאומה מהשליחים ”הנפלאים“. ");
INSERT INTO heblb_vpl VALUES ("C212_12","077_12_12","2CO","12","12","12","כבר הוכחתי לכם שאכן אלוהים עצמו שלחני אליכם, שהרי בסבלנות רבה חוללתי ביניכם נסים, נפלאות ואותות גבורה. ");
INSERT INTO heblb_vpl VALUES ("C212_13","077_12_13","2CO","12","13","13","מדוע אתם מרגישים נחותים מהקהילות האחרות? האם משום שלא הנחתי לכם לתמוך בי כספית? אנא, סלחו לי על העוול הנורא הזה! ");
INSERT INTO heblb_vpl VALUES ("C212_14","077_12_14","2CO","12","14","14","עתה אני בא לבקרכם בפעם השלישית, וגם הפעם לא יעלה לכם הדבר פרוטה. איני מעוניין בכספכם, אלא בכם! אחרי הכול, הילדים אינם צריכים לכלכל את הוריהם אלא להיפך, על ההורים לכלכל את ילדיהם. ");
INSERT INTO heblb_vpl VALUES ("C212_15","077_12_15","2CO","12","15","15","אני מוכן בשמחה לתת לכם את עצמי ואת כל אשר לי למען טובתכם הרוחנית, אם כי נראה שככל שאני אוהב אתכם יותר, אתם אוהבים אותי פחות. ");
INSERT INTO heblb_vpl VALUES ("C212_16","077_12_16","2CO","12","16","16","אחדים מכם אומרים: ”אמנם נראה שביקוריו לא עלו לנו דבר, אך הפולוס הזה איש ערמומי ואין ספק ששיחק בנו. הוא ודאי הרוויח מאתנו כסף איכשהו!“ ");
INSERT INTO heblb_vpl VALUES ("C212_17","077_12_17","2CO","12","17","17","אך כיצד? האם ניצל אתכם אחד מהאנשים אשר שלחתי אליכם? ");
INSERT INTO heblb_vpl VALUES ("C212_18","077_12_18","2CO","12","18","18","כשהאצתי בטיטוס לבקרכם ושלחתי עמו אח נוסף, האם הם רימו או ניצלו אתכם? ודאי שלא. הרי אנחנו פועלים מתוך אותם המניעים ומתנהגים באותה דרך. ");
INSERT INTO heblb_vpl VALUES ("C212_19","077_12_19","2CO","12","19","19","החושבים אתם שאנו מנסים להצטדק לפניכם? אם כן, אתם טועים! לנוכח אלוהים אני אומר לכם שהדברים נאמרו למענכם, ידידים יקרים, כדי לעזור לכם להיבנות באופן רוחני. ");
INSERT INTO heblb_vpl VALUES ("C212_20","077_12_20","2CO","12","20","20","אני חושש שמא בבואי אליכם לא ימצא־חן בעיני מה שאראה, והצעדים שאאלץ לנקוט לא ימצאו חן בעיניכם. אני חושש שמא אמצא בקרבכם מריבה, קנאה, רוגז אנוכיות, רכלנות, הוצאת־דיבה, יהירות ומבוכה. ");
INSERT INTO heblb_vpl VALUES ("C212_21","077_12_21","2CO","12","21","21","אכן, אני חושש שמא בשובי אליכם ישפילני אלוהים לפניכם, ואתאבל על רבים מכם אשר חטאו זה מכבר ולא חזרו בתשובה על מעשיהם הבלתי־מוסריים, על זנות וזימה. ");
INSERT INTO heblb_vpl VALUES ("C213_1","077_13_1","2CO","13","1","1","זוהי הפעם השלישית שאבוא אליכם. הכתובים אומרים שעל־פי שניים או שלושה עדים יקום כל דבר. ");
INSERT INTO heblb_vpl VALUES ("C213_2","077_13_2","2CO","13","2","2","כבר הזהרתי אתכם פעם אחת בביקורי הקודם, ועתה בהעדרי אני חוזר על האזהרה: בשובי אליכם הפעם לא אחוס על אלה שחטאו מקודם ועל כל הראויים לעונש. ");
INSERT INTO heblb_vpl VALUES ("C213_3","077_13_3","2CO","13","3","3","אוכיח לכם מעל כל ספק שהמשיח אכן מדבר באמצעותי. המשיח שבו אתם מאמינים אינו חלש לפניכם, אלא חזק בתוככם! ");
INSERT INTO heblb_vpl VALUES ("C213_4","077_13_4","2CO","13","4","4","המשיח אמנם נצלב בחולשה, אך עתה הוא חי בגבורת אלוהים. כך גם אנחנו חלשים, כשם שהמשיח היה חלש, אך אנו נחיה עמו למענכם בגבורת אלוהים. ");
INSERT INTO heblb_vpl VALUES ("C213_5","077_13_5","2CO","13","5","5","בחנו את עצמכם וראו אם אתם עומדים במבחן: האם אתם באמת מאמינים במשיח? האם אתם מרגישים בקרבכם את נוכחותו וגבורתו? או האם אמונתכם במשיח אינה אלא העמדת פנים? ");
INSERT INTO heblb_vpl VALUES ("C213_6","077_13_6","2CO","13","6","6","אני מקווה שאתם מסכימים אתי שעברתי מבחן זה בהצלחה. ");
INSERT INTO heblb_vpl VALUES ("C213_7","077_13_7","2CO","13","7","7","אני מתפלל לאלוהים שלא תעשו רע – לא כדי להוכיח את הצלחתנו, אלא כדי שתעשו את הטוב גם אם כלפי חוץ ייראה שנכשלנו. ");
INSERT INTO heblb_vpl VALUES ("C213_8","077_13_8","2CO","13","8","8","תפקידנו לעודד את הטוב בכל עת, ולא לקוות לרע. ");
INSERT INTO heblb_vpl VALUES ("C213_9","077_13_9","2CO","13","9","9","אנו תמיד מוכנים להיות חלשים, אם פרוש הדבר שאתם חזקים. משאלתנו ותפילתנו היא שתתבגרו באמונתכם. ");
INSERT INTO heblb_vpl VALUES ("C213_10","077_13_10","2CO","13","10","10","אני כותב לכם עתה מכתב זה בתקווה שלא אצטרך לנזוף בכם או להעניש אתכם בבואי, כי ברצוני להשתמש בסמכות שנתן לי האדון לחזק אתכם ולא להענישכם. ");
INSERT INTO heblb_vpl VALUES ("C213_11","077_13_11","2CO","13","11","11","אני מסיים מכתבי במילים הבאות: שמחו, התבגרו באמונתכם, שימו לב לדברים שאמרתי, חיו באהבה ובשלום. מי ייתן שאלוהי האהבה והשלום יהיה עמכם. ");
INSERT INTO heblb_vpl VALUES ("C213_12‏","077_13_12‏","2CO","13","12‏","13","ברכו איש את רעהו לשלום בנשיקה קדושה. כל המאמינים המשיחיים מוסרים לכם דרישת שלום. ");
INSERT INTO heblb_vpl VALUES ("C213_14","077_13_14","2CO","13","14","14","מי ייתן שחסד אדוננו ישוע המשיח, אהבת האלוהים וחברת רוח־הקודש יהיו עם כולכם.");
INSERT INTO heblb_vpl VALUES ("GL1_1‏","078_1_1‏","GAL","1","1‏","2","אל הקהילה בגלטיא. מאת פולוס השליח – שליחם לא של בני־אדם, כי אם של ישוע המשיח, ושל אלוהים האב אשר הקימו מן המתים – ומאת כל המאמינים המשיחיים הנמצאים אתי ברומא. ");
INSERT INTO heblb_vpl VALUES ("GL1_3","078_1_3","GAL","1","3","3","שלום וברכה לכם מאת האלוהים אבינו ומאת ישוע המשיח אדוננו. ");
INSERT INTO heblb_vpl VALUES ("GL1_4","078_1_4","GAL","1","4","4","אלוהים רצה שישוע המשיח ימות על הצלב בעד חטאינו, כדי להושיענו מהשעבוד לעולם הרע הזה שבו אנו חיים. ");
INSERT INTO heblb_vpl VALUES ("GL1_5","078_1_5","GAL","1","5","5","לאלוהים הכבוד, התודה והתהילה מעולם ועד עולם. – אמן. ");
INSERT INTO heblb_vpl VALUES ("GL1_6","078_1_6","GAL","1","6","6","אני מתפלא שאתם מתרחקים כל־כך מהר מאלוהים. ברוב אהבתו ורחמיו הוא נתן לכם במתנה חיי נצח, על־ידי ישוע המשיח, ואילו אתם כבר מצאתם ”בשורה“ אחרת, שכביכול תושיע אתכם. אולם דעו לכם שבשורה זאת לא תושיע אתכם, ");
INSERT INTO heblb_vpl VALUES ("GL1_7","078_1_7","GAL","1","7","7","שכן לא קיימת בשורה אחרת, מלבד זו שבישרנו לכם. אלה שהסיתו אתכם מהדרך הנכונה ללכת בדרכם, מרמים אתכם; הם מסלפים ומעוותים את האמת על אודות המשיח. ");
INSERT INTO heblb_vpl VALUES ("GL1_8","078_1_8","GAL","1","8","8","ארור כל מי שיספר לכם (כולל אני עצמי) על דרך לישועה השונה מהדרך שסיפרנו לכם. גם אם יבוא מלאך מן השמים ויספר לכם על דרך אחרת לעבוד את אלוהים – ארור הוא! ");
INSERT INTO heblb_vpl VALUES ("GL1_9","078_1_9","GAL","1","9","9","אני חוזר ואומר: ארור מי שיבשר לכם בשורה השונה מזו שהאמנתם בה. ");
INSERT INTO heblb_vpl VALUES ("GL1_10","078_1_10","GAL","1","10","10","אתם רואים שאיני משתדל למצוא־חן בעיניכם במחמאות ובדברי חנופה; אני משתדל למצוא־חן בעיני אלוהים בלבד. לו ניסיתי למצוא־חן בעיני בני־אדם, לא יכולתי להיות עבדו של ישוע המשיח. ");
INSERT INTO heblb_vpl VALUES ("GL1_11","078_1_11","GAL","1","11","11","אחים יקרים, אני מבטיח לכם כי הדרך אל אלוהים, שעליה סיפרתי לכם, איננה סיפור דמיוני ואף לא חלום שחלמתי. ");
INSERT INTO heblb_vpl VALUES ("GL1_12","078_1_12","GAL","1","12","12","ישוע המשיח עצמו מסר לי את הבשורה שבישרתי לכם, והוא לימד אותי מה לומר וכיצד לומר זאת; איש מלבדו לא לימד אותי. ");
INSERT INTO heblb_vpl VALUES ("GL1_13","078_1_13","GAL","1","13","13","האם אתם זוכרים כיצד התנהגתי בתקופה שהייתי בקרב היהודים? האם אתם זוכרים כיצד רדפתי את המאמינים במשיח, הצקתי להם ללא רחמים, וגם השתדלתי כמיטב יכולתי להיפטר מכולם? ");
INSERT INTO heblb_vpl VALUES ("GL1_14","078_1_14","GAL","1","14","14","בין בני־גילי הייתי אחד היהודים האדוקים ביותר בכל הארץ, והשתדלתי לקיים את כל המנהגים הישנים והמסורתיים של דת אבותיי. ");
INSERT INTO heblb_vpl VALUES ("GL1_15‏","078_1_15‏","GAL","1","15‏","16","אולם אז קרה דבר מה! שכן עוד לפני שנולדתי בחר בי אלוהים להיות אחד מילדיו המאמינים בישוע המשיח, כדי שאוכל ללכת אל הגויים ולספר להם את הבשורה אודות ישוע המשיח. כאשר כל זה התרחש, לא מיהרתי להיוועץ באיש. ");
INSERT INTO heblb_vpl VALUES ("GL1_17","078_1_17","GAL","1","17","17","לא הלכתי לירושלים כדי להיוועץ בשליחי האדון המנוסים ממני, אלא הלכתי למדבריות ערב, ולאחר מכן חזרתי לדמשק. ");
INSERT INTO heblb_vpl VALUES ("GL1_18","078_1_18","GAL","1","18","18","רק כעבור שלוש שנים עליתי לירושלים, כדי לבקר את פטרוס, ונשארתי אצלו חמישה־עשר יום. ");
INSERT INTO heblb_vpl VALUES ("GL1_19","078_1_19","GAL","1","19","19","מלבד פטרוס פגשתי עוד שליח אחד בלבד – יעקב, אחיו של ישוע אדוננו. ");
INSERT INTO heblb_vpl VALUES ("GL1_20","078_1_20","GAL","1","20","20","הקשיבו היטב לדברי. אלוהים עדי שאיני משקר ושכל דברי אמיתיים ונכונים! ");
INSERT INTO heblb_vpl VALUES ("GL1_21","078_1_21","GAL","1","21","21","לאחר הביקור בירושלים הלכתי לסוריה וקיליקיא. ");
INSERT INTO heblb_vpl VALUES ("GL1_22","078_1_22","GAL","1","22","22","כל אותו זמן לא ראו אותי עדיין המאמינים ביהודה. ");
INSERT INTO heblb_vpl VALUES ("GL1_23","078_1_23","GAL","1","23","23","כל מה שידעו היה, שהאויב הפך לאוהב, ושעתה הוא מטיף לאמונה אשר לפנים ניסה לחסל ולהשמיד. ");
INSERT INTO heblb_vpl VALUES ("GL1_24","078_1_24","GAL","1","24","24","וכולם היללו את אלוהים על הנס שחולל בחיי. ");
INSERT INTO heblb_vpl VALUES ("GL2_1","078_2_1","GAL","2","1","1","כעבור ארבע־עשרה שנים חזרתי לירושלים עם בר־נבא, וטיטוס הצטרף אלינו. ");
INSERT INTO heblb_vpl VALUES ("GL2_2","078_2_2","GAL","2","2","2","אלוהים ציווה עלי להתייעץ עם האחים בירושלים בנוגע לבשורה שבישרתי לגויים. נועצתי גם בזקני הקהילה, כדי שכולם יבינו את תוכן הבשורה שאני מספר לגויים. קיוויתי שזקני הקהילה יסכימו אתי, ");
INSERT INTO heblb_vpl VALUES ("GL2_3","078_2_3","GAL","2","3","3","והם אכן הסכימו; הם אף לא דרשו מטיטוס (שאינו יהודי) להימול. ");
INSERT INTO heblb_vpl VALUES ("GL2_4","078_2_4","GAL","2","4","4","שאלת ברית־המילה כלל לא הייתה עולה על הפרק אלמלא כמה אנשים, הקוראים לעצמם ”מאמינים“, שבאו לרגל בינינו. הם רצו לראות איזה חופש העניק לנו המשיח בנוגע לקיום מצוות התורה. אנשים אלה רצו לשעבד אותנו לחוקים שלהם. ");
INSERT INTO heblb_vpl VALUES ("GL2_5","078_2_5","GAL","2","5","5","אך לא הקשבנו לדבריהם, כי לא רצינו לבלבל אתכם. לא רצינו שתחשבו שאתם יכולים להושיע את עצמכם על־ידי קיום ברית־המילה, או על־ידי קיום מצוות התורה. ");
INSERT INTO heblb_vpl VALUES ("GL2_6","078_2_6","GAL","2","6","6","לנכבדי הקהילה לא היה מה להעיר או להוסיף על דברי. (אגב, כלל לא התרשמתי מהעובדה שהם היו נכבדי הקהילה, כי אני יודע שבעיני אלוהים כולנו שווים!) ");
INSERT INTO heblb_vpl VALUES ("GL2_7‏","078_2_7‏","GAL","2","7‏","9","כשראו פטרוס, יעקב ויוחנן, שנחשבו לעמודי התווך של הקהילה, כיצד ברך אלוהים את עדותי לגויים, כשם שברך את עדותו של פטרוס ליהודים – שכן אלוהים נתן לכל אחד מאיתנו מתנות שונות ותפקידים שונים – הם לחצו את ידי ואת ידו של בר־נבא, ועודדו אותנו להמשיך להעיד לגויים, בזמן שהם ממשיכים להעיד ליהודים. ");
INSERT INTO heblb_vpl VALUES ("GL2_10","078_2_10","GAL","2","10","10","הם רק הזכירו לנו לא לשכוח לעזור לעניים, אבל התזכורת הייתה מיותרת, שכן אני תמיד דואג לעניים. ");
INSERT INTO heblb_vpl VALUES ("GL2_11","078_2_11","GAL","2","11","11","אולם כש‎כֵּיפָא (פטרוס) בא לאנטיוכיה, הוכחתי אותו לפני כולם, משום שהתנגדתי בכל תוקף למעשיו ולהתנהגותו. ");
INSERT INTO heblb_vpl VALUES ("GL2_12","078_2_12","GAL","2","12","12","כש‎כֵּיפָא הגיע בראשונה לאנטיוכיה, הוא נהג לסעוד עם המאמינים המשיחיים הלא־יהודים (שלא נימולו, ולא שמרו את מצוות התורה). לאחר מכן הגיעו לאנטיוכיה מספר חברים יהודים של יעקב, ומאז הפסיק ‎כֵּיפָא לסעוד עם המאמינים הלא־יהודים. מדוע הפסיק לסעוד עמם? מפני שפחד מביקורתם של היהודים המקפידים על שמירת המצוות, אשר עמדו על דעתם כי ברית־המילה היא חלק בלתי־נפרד מהישועה. ");
INSERT INTO heblb_vpl VALUES ("GL2_13","078_2_13","GAL","2","13","13","שאר היהודים המשיחיים (ואפילו בר־נבא) הפכו גם הם לצבועים והלכו בעקבות ‎כֵּיפָא, למרות שידעו היטב כי הם שוגים ואינם נוהגים כהלכה. ");
INSERT INTO heblb_vpl VALUES ("GL2_14","078_2_14","GAL","2","14","14","כשראיתי מה קורה שם, וכשנוכחתי לדעת שאינם ישרים ואינם שומרים את דבר אלוהים, אמרתי ל‎כֵּיפָא לפני כולם: ”למרות שאתה יהודי מלידה, אינך שומר את חוקי התורה ומצוותיה. אם כן מדוע אתה מנסה לשכנע את הגויים האלה לקיים את מצוות התורה? ");
INSERT INTO heblb_vpl VALUES ("GL2_15","078_2_15","GAL","2","15","15","הלא אתה ואני יהודים מלידה, ולא סתם חוטאים מן הגויים. ");
INSERT INTO heblb_vpl VALUES ("GL2_16","078_2_16","GAL","2","16","16","ואנחנו, היהודים המשיחיים, יודעים היטב שאיננו יכולים להיחשב צדיקים בעיני אלוהים על־ידי קיום מצוות התורה, אלא רק על־ידי אמונה במשיח. לכן גם אנחנו בטחנו והאמנו בישוע המשיח, כדי שנהיה רצויים לאלוהים בזכות אמונתנו, ולא בזכות קיום המצוות. איש אינו יכול להיוושע על־ידי קיום מצוות התורה.“ ");
INSERT INTO heblb_vpl VALUES ("GL2_17","078_2_17","GAL","2","17","17","אם אנחנו מבקשים להיות מוצדקים על ידי המשיח אך כבר לא נשענים על תורת משה בעבור ישועה, הרי אנחנו כמו הגויים אשר נחשבים לחוטאים על ידי היהודים. אם כך, האם המשיח מעודד שנחטא? בודאי שלא! ");
INSERT INTO heblb_vpl VALUES ("GL2_18","078_2_18","GAL","2","18","18","דעו לכם כי פשע הוא לנסות לבנות מחדש את מה שעמלתי להרוס – את האמונה שאפשר להיוושע על־ידי קיום מצוות התורה. ");
INSERT INTO heblb_vpl VALUES ("GL2_19","078_2_19","GAL","2","19","19","מתוך קריאה בכתבי־הקודש למדתי שלא אוכל למצוא־חן בעיני אלוהים אם אשתדל, ללא הצלחה כמובן, לקיים את מצוות התורה. למדתי שאוכל למצוא־חן בעיני אלוהים רק על־ידי אמונה במשיח. ");
INSERT INTO heblb_vpl VALUES ("GL2_20","078_2_20","GAL","2","20","20","מָתִּי על הצלב עם המשיח; עתה איני חי יותר, כי אם המשיח חי בקרבי. והחיים האמיתיים שממלאים אותי הם תוצאה של אמונתי בבן־האלוהים, אשר אהב אותי והקריב את חייו למעני. ");
INSERT INTO heblb_vpl VALUES ("GL2_21","078_2_21","GAL","2","21","21","איני מזלזל במותו של המשיח, כי אילו יכולתי להיוושע על־ידי קיום מצוות התורה, היה מותו של המשיח מיותר לחלוטין. ");
INSERT INTO heblb_vpl VALUES ("GL3_1","078_3_1","GAL","3","1","1","אוי, גלטים טיפשים! מי הסיתכם נגד האמת? לאיזה כישוף נפלתם קורבן? פעם הבנתם את המשמעות המלאה של מות המשיח; צליבתו הייתה כל־כך ממשית בעיניכם – כאילו ראיתם אותו נצלב לפניכם. ");
INSERT INTO heblb_vpl VALUES ("GL3_2","078_3_2","GAL","3","2","2","ברצוני לשאול אתכם, האם אלוהים נתן לכם את רוח הקודש על־שום ששמרתם את מצוות התורה? ודאי שלא! אלוהים נתן לכם את רוח הקודש רק לאחר ששמעתם על המשיח והאמנתם שהוא בלבד מסוגל להושיע אתכם. ");
INSERT INTO heblb_vpl VALUES ("GL3_3","078_3_3","GAL","3","3","3","מה לכם, האם יצאתם מדעתכם? אם ראיתם כבר שקיום המצוות לא הועיל לכם במאומה ולא העניק לכם סיפוק רוחני, כיצד מעלים אתם על הדעת שקיום מצוות התורה יעזור לכם להיות מאמינים טובים יותר? ");
INSERT INTO heblb_vpl VALUES ("GL3_4","078_3_4","GAL","3","4","4","סבלתם כל־כך למען הבשורה, ועכשיו אתם משליכים את הכול מאחורי גבכם? קשה לי להאמין בכך! ");
INSERT INTO heblb_vpl VALUES ("GL3_5","078_3_5","GAL","3","5","5","אני חוזר ושואל אתכם: האם אלוהים נותן לכם את רוח הקודש ומחולל ביניכם ניסים ונפלאות, משום שאתם מקיימים את מצוות התורה? אלוהים משכין בלבכם את רוח הקודש ופועל בחייכם, רק משום שאתם מאמינים ובוטחים בישוע המשיח. ");
INSERT INTO heblb_vpl VALUES ("GL3_6","078_3_6","GAL","3","6","6","קחו לדוגמה את אברהם אבינו: אלוהים חשב את אברהם לצדיק, רק משום שאברהם האמין בהבטחותיו של ה׳. ");
INSERT INTO heblb_vpl VALUES ("GL3_7","078_3_7","GAL","3","7","7","מכאן יכולים אתם להבין מדוע כל מי שמאמין בה׳ ובוטח בו, הוא למעשה בנו של אברהם אבינו. ");
INSERT INTO heblb_vpl VALUES ("GL3_8","078_3_8","GAL","3","8","8","בכתבי־הקודש אנו קוראים על הציפייה ליום שבו יושיע אלוהים גם את הגויים, בזכות אמונתם. לפני זמן רב הבטיח אלוהים לאברהם לברך את כל מי שיאמין בו (באלוהים) כמו אברהם. ");
INSERT INTO heblb_vpl VALUES ("GL3_9","078_3_9","GAL","3","9","9","על כן לכל מי שמאמין במשיח יש חלק בברכת ה׳ לאברהם אבינו. ");
INSERT INTO heblb_vpl VALUES ("GL3_10","078_3_10","GAL","3","10","10","כל מי שסומך על ישועה בזכות התורה חשוף לקללת אלוהים, שהרי כתוב בכתבי־הקודש: ”ארור מי שלא מקיים את כל דברי התורה הזאת.“ ");
INSERT INTO heblb_vpl VALUES ("GL3_11","078_3_11","GAL","3","11","11","לפיכך אתם רואים שאיש אינו יכול למצוא־חן בעיני ה׳ בזכות קיום מצוות התורה, שכן ה׳ אמר כי הדרך היחידה למצוא־חן בעיניו היא דרך האמונה: ”וצדיק באמונתו יחיה.“ ");
INSERT INTO heblb_vpl VALUES ("GL3_12","078_3_12","GAL","3","12","12","רואים אתם, אם כן, מה שונה הישועה מתוך אמונה מהישועה הנובעת מקיום כל מצוות התורה. ");
INSERT INTO heblb_vpl VALUES ("GL3_13","078_3_13","GAL","3","13","13","המשיח שיחרר אותנו מהקללה הרובצת על אלה שאינם מקיימים את כל מצוות התורה, בלקחו על עצמו את הקללה במקומנו, שהרי כתוב בתורה: ”קללת אלוהים תלוי“ (על עץ, והרי ישוע שנצלב היה בעצם תלוי על עץ.) ");
INSERT INTO heblb_vpl VALUES ("GL3_14","078_3_14","GAL","3","14","14","ועתה יכול אלוהים לברך גם את הגויים באותה ברכה שהבטיח לאברהם אבינו, ויתקיים בנו הבטחת רוח הקודש. ");
INSERT INTO heblb_vpl VALUES ("GL3_15","078_3_15","GAL","3","15","15","אחים יקרים, גם היום כשמבטיח אדם הבטחה בכתב וחותם עליה, חובה עליו לקיים את הבטחתו, ואין הוא יכול לשנות את דעתו. ");
INSERT INTO heblb_vpl VALUES ("GL3_16","078_3_16","GAL","3","16","16","אלוהים הבטיח את הברכות לאברהם ולזרעו. שימו לב שלא כתוב ”לזרעיו“ – בלשון רבים, אלא בלשון יחיד, בן – זרע, הלא הוא ישוע המשיח. ");
INSERT INTO heblb_vpl VALUES ("GL3_17","078_3_17","GAL","3","17","17","אני מנסה לומר לכם שה׳ הבטיח בכתב להושיע את כל מי שמאמין בו, והבטחה זו אינה יכולה להשתנות או להתבטל לאחר ארבע־מאות ושלושים שנה, כשנתן ה׳ את התורה. ");
INSERT INTO heblb_vpl VALUES ("GL3_18","078_3_18","GAL","3","18","18","אברהם מצא־חן בעיני אלוהים, מפני שהאמין בה׳ ובהבטחותיו. אילו יכולנו למצוא־חן בעיני ה׳ על־ידי קיום מצוות התורה, הייתה דרכנו שונה לחלוטין מדרכו של אברהם. ");
INSERT INTO heblb_vpl VALUES ("GL3_19","078_3_19","GAL","3","19","19","שואלים אתם ודאי, מדוע נתן ה׳ את התורה? התורה ניתנה כתוספת, לאחר ההבטחה לאברהם, כדי להוכיח לבני־האדם שהם אשמים באי־קיום מצוותיה. אולם ה׳ נתן את חוקי התורה רק באופן זמני, עד בואו של ישוע המשיח – הבן – אשר לו ניתנה הבטחת ה׳. יתרה מזאת, כשנתן ה׳ את התורה, הוא נתן אותה בידי מלאכים למשה, ואילו משה נתן את התורה לעם. ");
INSERT INTO heblb_vpl VALUES ("GL3_20","078_3_20","GAL","3","20","20","אולם כשנתן ה׳ את ההבטחה לאברהם, אלוהים בעצמו דיבר עם אברהם, ללא מתווכים. ");
INSERT INTO heblb_vpl VALUES ("GL3_21‏","078_3_21‏","GAL","3","21‏","22","האם יש סתירה בין תורתו של ה׳ לבין הבטחותיו? ודאי שלא! אילו יכלה התורה להושיע אותנו, לא היה צריך אלוהים לתת לנו מוצא אחר מהשעבוד לחטא – שהרי כתבי־הקודש אומרים שכולנו עבדים לחטא. הדרך היחידה להשתחרר מהשעבוד לחטא, דרך הפתוחה לכל אחד, היא אמונה בישוע המשיח! ");
INSERT INTO heblb_vpl VALUES ("GL3_23","078_3_23","GAL","3","23","23","לפני בוא המשיח התורה חסתה עלינו עד היום שבו יכולנו להאמין במשיח. ");
INSERT INTO heblb_vpl VALUES ("GL3_24","078_3_24","GAL","3","24","24","במילים אחרות: התורה הדריכה אותנו והשגיחה עלינו, עד שבא ישוע המשיח לקרב אותנו לאלוהים בזכות אמונתנו. ");
INSERT INTO heblb_vpl VALUES ("GL3_25","078_3_25","GAL","3","25","25","אבל עכשיו, לאחר שכבר בא המשיח, שוב אין לנו צורך בהדרכת מצוות התורה. ");
INSERT INTO heblb_vpl VALUES ("GL3_26","078_3_26","GAL","3","26","26","כי עתה כולנו בני אלוהים בזכות אמונתנו בישוע המשיח, ");
INSERT INTO heblb_vpl VALUES ("GL3_27","078_3_27","GAL","3","27","27","ואלה מאיתנו שנטבלו כסמל לאחדות עם המשיח, כאילו עטופים במשיח. ");
INSERT INTO heblb_vpl VALUES ("GL3_28","078_3_28","GAL","3","28","28","בין המאמינים שוב אין הבדל בין יהודי לגוי, בין עבד לבן־חורין ואף לא בין גבר לאישה. בעיני אלוהים כולנו שווים. אלוהים אוהב את כולנו באותה מידה, וכולנו מאוחדים בישוע המשיח. ");
INSERT INTO heblb_vpl VALUES ("GL3_29","078_3_29","GAL","3","29","29","מאחר שאנו שייכים למשיח, אנו גם זרע אברהם, וכל הבטחותיו של ה׳ לאברהם ולזרעו שייכות גם לנו. ");
INSERT INTO heblb_vpl VALUES ("GL4_1","078_4_1","GAL","4","1","1","זכרו, גם אם אב עשיר מת ומוריש לבנו הקטן את כל רכושו, הילד הקטן דומה במעמדו לעבד. אין הוא יכול ליהנות מן הירושה עד שיגיע לגיל בגרות (או לגיל מסוים שקבע אביו למתן הירושה). ");
INSERT INTO heblb_vpl VALUES ("GL4_2","078_4_2","GAL","4","2","2","עד אז עליו לשמוע לקול המבוגרים האחראים לטיפולו ולחינוכו. ");
INSERT INTO heblb_vpl VALUES ("GL4_3","078_4_3","GAL","4","3","3","לפני בואו של ישוע המשיח היה מצבנו דומה. בעת היותנו חסרי בגרות, היינו משועבדים לדרכי העולם. ");
INSERT INTO heblb_vpl VALUES ("GL4_4","078_4_4","GAL","4","4","4","אך בהגיע הזמן המתאים שלח אלוהים את בנו, שנולד לאם יהודיה, ");
INSERT INTO heblb_vpl VALUES ("GL4_5","078_4_5","GAL","4","5","5","כדי לשחרר אותנו מהשעבוד לתורה, וכדי לאמץ אותנו לבניו. ");
INSERT INTO heblb_vpl VALUES ("GL4_6","078_4_6","GAL","4","6","6","היות שאנחנו בני־אלוהים, הוא השכין בלבנו את רוח בנו, ומשום כך יש לנו את הזכות לקרוא לו: אבא, אבינו. ");
INSERT INTO heblb_vpl VALUES ("GL4_7","078_4_7","GAL","4","7","7","מעתה ואילך אין אנו עבדים, אלא בני אלוהים ממש; ומאחר שאנחנו בני־אלוהים, כל מה ששייך לאלוהים אבינו שייך גם לנו. ");
INSERT INTO heblb_vpl VALUES ("GL4_8","078_4_8","GAL","4","8","8","אתם הגויים, לפני שהאמנתם באלוהים הייתם עבדים לכל מיני אלילים מגוחכים, שקראתם להם ”אלוהים“. ");
INSERT INTO heblb_vpl VALUES ("GL4_9","078_4_9","GAL","4","9","9","עתה, לאחר שמצאתם את אלוהים (או נכון יותר לומר: לאחר שאלוהים מצא אתכם), כיצד יכולים אתם לחזור ולהשתעבד לאמונה חלשה ורופפת, הגורסת שניתן להיוושע על־ידי קיום מצוות התורה? ");
INSERT INTO heblb_vpl VALUES ("GL4_10","078_4_10","GAL","4","10","10","אתם מנסים למצוא־חן בעיני אלוהים על־ידי שמירת חגים ומועדים! ");
INSERT INTO heblb_vpl VALUES ("GL4_11","078_4_11","GAL","4","11","11","אני חושש מאוד שכל עבודתי בכם הייתה לשווא. ");
INSERT INTO heblb_vpl VALUES ("GL4_12‏","078_4_12‏","GAL","4","12‏","13","אחים יקרים, מדוע אינכם מקשיבים לי? עכשיו אני חופשי ומשוחרר מכבלי מצוות התורה, ממש כמוכם. כשבאתי אליכם בפעם הראשונה, כדי לספר לכם את הבשורה, לא בזתם לי למרות שהייתי חולה. ");
INSERT INTO heblb_vpl VALUES ("GL4_14","078_4_14","GAL","4","14","14","מחלתי הייתה דוחה ומתועבת, אבל לא דחיתם אותי ולא הפניתם לי עורף. לקחתם אותי לביתכם וטיפלתם בי כאילו טיפלתם במלאך מן השמים או בישוע המשיח עצמו! ");
INSERT INTO heblb_vpl VALUES ("GL4_15","078_4_15","GAL","4","15","15","מה קרה לכם? פעם הייתה בכם רוח של אהבה, אחדות ושמחה; בימים ההם אהבתם אותי כל־כך, עד שהייתם מוכנים לנקר את עיניכם ולתת אותן לי, אילו היה צורך בכך. ");
INSERT INTO heblb_vpl VALUES ("GL4_16","078_4_16","GAL","4","16","16","האם הפכתי לאויבכם משום שאני אומר לכם את האמת? ");
INSERT INTO heblb_vpl VALUES ("GL4_17","078_4_17","GAL","4","17","17","האנשים האלה שמשתדלים מאוד למצוא־חן בעיניכם, אינם עושים זאת מתוך רצון בטובתכם, אלא מתוך רצון לסכסך ולהפריד ביניכם לביני, כדי שלא תקשיבו לי, אלא תקשיבו להם בלבד. ");
INSERT INTO heblb_vpl VALUES ("GL4_18","078_4_18","GAL","4","18","18","ודאי שאני רוצה שאנשים יתנהגו יפה כלפיכם, אך זאת רק בתנאי שמניעיהם טהורים ושאין הם מתנהגים כך רק כשאני נמצא אתכם! ");
INSERT INTO heblb_vpl VALUES ("GL4_19","078_4_19","GAL","4","19","19","ילדי, אתם כל־כך מכאיבים לי! אני סובל ייסורי ציפייה ליום שבו תתמסרו למשיח בכל לבכם, בדומה לאם הסובלת ייסורי לידה בציפייה להולדת בנה. ");
INSERT INTO heblb_vpl VALUES ("GL4_20","078_4_20","GAL","4","20","20","הלוואי שיכולתי להיות אצלכם עכשיו ולדבר אתכם פנים אל פנים, במקום לנסות להשפיע עליכם בכתב; פשוט איני יודע מה לעשות אתכם! ");
INSERT INTO heblb_vpl VALUES ("GL4_21","078_4_21","GAL","4","21","21","אני פונה אל כל אלה שחושבים שעליהם לשמור את מצוות התורה כדי להיוושע: היודעים אתם מה כתוב בתורה? ");
INSERT INTO heblb_vpl VALUES ("GL4_22","078_4_22","GAL","4","22","22","כתוב בתורה שלאברהם אבינו היו שני בנים: ישמעאל בן האישה המשרתת, ויצחק בן האישה החופשייה. ");
INSERT INTO heblb_vpl VALUES ("GL4_23","078_4_23","GAL","4","23","23","בן המשרתת נולד בלידה טבעית ובלי נסים ונפלאות; אולם בן האישה החופשייה נולד רק לאחר הבטחתו המיוחדת של אלוהים לאברהם. ");
INSERT INTO heblb_vpl VALUES ("GL4_24‏","078_4_24‏","GAL","4","24‏","25","סיפור אמיתי זה הוא משל: שתי הנשים הן שתי הבריתות שכרת ה׳ עם עמו. האחת היא ברית הר־סיני שבערב, שהביאה את האנשים לידי שעבוד לתורה – זוהי הגר שמסמלת את עיר־האם, ירושלים, שמשועבדת עדיין למצוות התורה ושמשמשת מרכז לפולחן דתי ");
INSERT INTO heblb_vpl VALUES ("GL4_26","078_4_26","GAL","4","26","26","ואילו שרה, האישה החופשייה, מסמלת את ירושלים החופשית שבשמים, שהיא עיר־האם והקודש שלנו, ואינה משועבדת למצוות התורה. ");
INSERT INTO heblb_vpl VALUES ("GL4_27","078_4_27","GAL","4","27","27","אליה התכוון הנביא ישעיהו כשניבא: ”רני עקרה לא ילדה, פצחי רנה וצהלי לא־חלה, כי רבים בני שוממה מבני בעולה“. ");
INSERT INTO heblb_vpl VALUES ("GL4_28","078_4_28","GAL","4","28","28","אחים יקרים, אנחנו – אתם ואני – הבנים שהבטיח ה׳ לירושלים החדשה, כשם שהבטיח את יצחק לאברהם ושרה. ");
INSERT INTO heblb_vpl VALUES ("GL4_29","078_4_29","GAL","4","29","29","ואנחנו, המאמינים שנולדנו מחדש על־ידי רוח הקודש, נרדפים על־ידי אלה שרוצים שנשמור את מצוות התורה, ממש כמו שיצחק – בן ההבטחה – נרדף על־ידי ישמעאל בן המשרתת. ");
INSERT INTO heblb_vpl VALUES ("GL4_30","078_4_30","GAL","4","30","30","אבל מה אומרים כתבי־הקודש? ”גרש את האמה ואת בנה, כי לא יירש בן־האמה עם בן־החפשיה“. ");
INSERT INTO heblb_vpl VALUES ("GL4_31","078_4_31","GAL","4","31","31","אחים יקרים, אין אנו בני האישה המשרתת ואיננו עבדים לתורה; אנחנו בני האישה החופשייה, ורצויים לאלוהים בזכות אמונתנו. ");
INSERT INTO heblb_vpl VALUES ("GL5_1","078_5_1","GAL","5","1","1","המשיח הוציאנו לחופשי! לכן אל תשובו להשתעבד למצוות התורה ולמסורת. ");
INSERT INTO heblb_vpl VALUES ("GL5_2","078_5_2","GAL","5","2","2","הקשיבו לדברי: אם אתם באמת חושבים שברית־המילה ושמירת המצוות יקרבו אתכם לאלוהים, אזי אין המשיח יכול להושיע אתכם. ");
INSERT INTO heblb_vpl VALUES ("GL5_3","078_5_3","GAL","5","3","3","אני חוזר ואומר: מי שמייחס חשיבות רבה לקיום ברית־המילה, חייב למלא את כל מצוות התורה, שאם לא־כן תבוא עליו קללה. ");
INSERT INTO heblb_vpl VALUES ("GL5_4","078_5_4","GAL","5","4","4","אם אתם באמת חושבים שתוכלו למצוא־חן בעיני אלוהים בזכות שמירת מצוות התורה, הרי שאין לכם כל צורך במשיח, ואינכם יכולים ליהנות מחסדו של אלוהים. ");
INSERT INTO heblb_vpl VALUES ("GL5_5","078_5_5","GAL","5","5","5","בעזרת רוח הקודש אנו מאמינים כי מותו של המשיח מטהר אותנו מחטאינו ומצדיק אותנו בעיני אלוהים. ");
INSERT INTO heblb_vpl VALUES ("GL5_6","078_5_6","GAL","5","6","6","אנו, המאמינים המשיחיים, יודעים כי המילה ושמירת המצוות הם סימנים חיצוניים בלבד שאינם מוכיחים דבר. ומה חשוב? אמונה שמוכיחה את עצמה על־ידי אהבה. ");
INSERT INTO heblb_vpl VALUES ("GL5_7","078_5_7","GAL","5","7","7","עד עתה התקדמתם יפה מאוד באמונתכם. מה קרה לכם לפתע? מי הסיתכם נגד דבר האמת? ");
INSERT INTO heblb_vpl VALUES ("GL5_8","078_5_8","GAL","5","8","8","ודאי שלא אלוהים הסיתכם לכך, שכן אלוהים עצמו העניק לכם חופש במשיח. ");
INSERT INTO heblb_vpl VALUES ("GL5_9","078_5_9","GAL","5","9","9","הרי הוראת כזב זו היא כמו מעט שאור שמחמיץ את כל הבצק. ");
INSERT INTO heblb_vpl VALUES ("GL5_10","078_5_10","GAL","5","10","10","אני בטוח שאלוהים ישכנע אתכם לשוב ולהאמין באמת, כמוני, ודעו לכם שאלוהים יעניש את האדם שבלבל והתעה אתכם, וגרם לכך שתטילו ספק בדבר אלוהים. ");
INSERT INTO heblb_vpl VALUES ("GL5_11","078_5_11","GAL","5","11","11","יש אשר חושבים כי אני עצמי טוען שהמילה וקיום המצוות הם חלק בלתי־נפרד מהישועה. אבל אני שואל אתכם, לו נכון היה הדבר, האם היו לי עדיין כל־כך הרבה אויבים ומתנגדים? הלא אם הייתי מטיף למילה ולקיום המצוות לא הייתי פוגע באיש, ואף אחד לא היה קם נגדי. אבל העובדה היא שאנשים רבים רודפים אותי ומציקים לי, משום שאני מטיף לישועה דרך אמונה במותו ובתחייתו של ישוע המשיח. ");
INSERT INTO heblb_vpl VALUES ("GL5_12","078_5_12","GAL","5","12","12","הלוואי שהיו מעקרים את האנשים שמנסים לסכסך ולהפריד בינינו בגלל ברית־המילה! ");
INSERT INTO heblb_vpl VALUES ("GL5_13","078_5_13","GAL","5","13","13","אחי היקרים, אל תשכחו שהמשיח הוציא אתכם לחופשי! אין זה חופש לעשות ככל העולה על רוחכם, כי אם חופש לאהוב ולעזור לזולת. ");
INSERT INTO heblb_vpl VALUES ("GL5_14","078_5_14","GAL","5","14","14","אפשר לסכם את התורה כולה במצווה אחת: ”ואהבת לרעך כמוך“. ");
INSERT INTO heblb_vpl VALUES ("GL5_15","078_5_15","GAL","5","15","15","אבל אם במקום לאהוב איש את רעהו אתם תמיד רבים, שונאים ומקנאים, אז תהרסו איש את אחיו. ");
INSERT INTO heblb_vpl VALUES ("GL5_16","078_5_16","GAL","5","16","16","אני מייעץ לכם לשמוע רק לקול רוח הקודש, והוא יראה לכם מה לעשות ולאן ללכת, ומובטח לכם ששוב לא תהיו משועבדים לבשר שלכם, הגורם לכם תמיד לעשות את הרע. ");
INSERT INTO heblb_vpl VALUES ("GL5_17","078_5_17","GAL","5","17","17","לכולנו יש נטייה טבעית לעשות את הרע, שהוא היפוכו הגמור של מה שרוח הקודש אומר לנו לעשות. וכאשר רוח הקודש פועל בנו ומביא אותנו לכך שנרצה לעשות את הטוב, הרי שזה היפוכן הגמור של נטיותינו הטבעיות. שני כוחות אלה, הבשר שלנו ורוח הקודש, נאבקים בתוכנו כשזה רוצה לנצח את זה, ואיננו יכולים לעשות כל מה שאנו רוצים. ");
INSERT INTO heblb_vpl VALUES ("GL5_18","078_5_18","GAL","5","18","18","כשרוח הקודש מדריך את מעשינו, הוא גם משחרר אותנו מהחובה לקיים את מצוות התורה. ");
INSERT INTO heblb_vpl VALUES ("GL5_19","078_5_19","GAL","5","19","19","אם תלכו אחרי הנטיות הטבעיות שלכם, אלה תהיינה התוצאות: זנות, טומאה, תאווה, ");
INSERT INTO heblb_vpl VALUES ("GL5_20","078_5_20","GAL","5","20","20","עבודת אלילים וכישוף, שנאה, פילוג, קנאה, כעס, אנוכיות, תלונות, מריבות, ");
INSERT INTO heblb_vpl VALUES ("GL5_21","078_5_21","GAL","5","21","21","חמדנות, שיכרות, הוללות וכדומה. אני חוזר ואומר לכם: מי שמנהל חיים כאלה לא יירש את מלכות האלוהים. ");
INSERT INTO heblb_vpl VALUES ("GL5_22","078_5_22","GAL","5","22","22","אולם אם נניח לרוח הקודש לשלוט בחיינו, זה יהיה הפרי: אהבה, שמחה, שלום ושלווה, סבלנות, נדיבות, טוב־לב, אמונה, ");
INSERT INTO heblb_vpl VALUES ("GL5_23","078_5_23","GAL","5","23","23","צניעות ושליטה עצמית, וכמובן שאין סתירה בין תכונות אלה לבין מצוות התורה. ");
INSERT INTO heblb_vpl VALUES ("GL5_24","078_5_24","GAL","5","24","24","המאמינים במשיח התכחשו לבשר שלהם; הם קברו אותו לרגלי צלב המשיח. ");
INSERT INTO heblb_vpl VALUES ("GL5_25","078_5_25","GAL","5","25","25","אם אנו חיים עתה בכוחו של רוח הקודש, הבה נציית לו בכל שטחי החיים. ");
INSERT INTO heblb_vpl VALUES ("GL5_26","078_5_26","GAL","5","26","26","ואז לא נצטרף לבקש כבוד והצלחה, הגורמים לקנאה ולרוגז. ");
INSERT INTO heblb_vpl VALUES ("GL6_1","078_6_1","GAL","6","1","1","אם ייכשל אחד מכם בעבירה כלשהי, אלה מביניכם החזקים יותר באמונה צריכים לעזור לו לשוב לדרך הנכונה, בעדינות ובענווה, ואל תשכחו שבפעם הבאה אתם בעצמכם עלולים להיות בצד הנכשלים. ");
INSERT INTO heblb_vpl VALUES ("GL6_2","078_6_2","GAL","6","2","2","השתתפו איש בבעיות רעהו, כפי שביקש מאיתנו המשיח. ");
INSERT INTO heblb_vpl VALUES ("GL6_3","078_6_3","GAL","6","3","3","מי שחושב שהדבר הוא למטה מכבודו אינו אלא גאוותן; מי שחושב את עצמו ל”מישהו“ הוא לא כלום. ");
INSERT INTO heblb_vpl VALUES ("GL6_4","078_6_4","GAL","6","4","4","כל אחד יעשה את שלו על הצד הטוב ביותר, כי אז יהיה לו סיפוק מעבודתו הטובה, ולא יצטרך להשוות את עצמו לאחרים. ");
INSERT INTO heblb_vpl VALUES ("GL6_5","078_6_5","GAL","6","5","5","כל אחד מאיתנו חייב לקחת אחריות על מעשיו. ");
INSERT INTO heblb_vpl VALUES ("GL6_6","078_6_6","GAL","6","6","6","אלה שלומדים את כתבי־הקודש צריכים לעזור למוריהם ולתמוך בהם כפי יכולתם. ");
INSERT INTO heblb_vpl VALUES ("GL6_7","078_6_7","GAL","6","7","7","אל תחשבו שאתם יכולים להתל באלוהים, שהרי הוא יודע בדיוק מי אתם ומה אתם. כל אחד קוצר את מה שהוא זרע. ");
INSERT INTO heblb_vpl VALUES ("GL6_8","078_6_8","GAL","6","8","8","מי שזרע זרעים של רוע ושחיתות יקצור בבוא הזמן מוות, הרס וכליון. אולם מי שזרע את הזרעים המשובחים של רוח הקודש יקצור בבוא הזמן חיי נצח – מתנת רוח הקודש. ");
INSERT INTO heblb_vpl VALUES ("GL6_9","078_6_9","GAL","6","9","9","הבה נמשיך לעשות את הטוב בלי להרפות, כי מובטח לנו שאם לא נתייאש נראה בבוא הזמן ברכה רבה בעבודתנו. ");
INSERT INTO heblb_vpl VALUES ("GL6_10","078_6_10","GAL","6","10","10","לכן עלינו להתנהג יפה תמיד עם כל אדם, ובמיוחד עם אחינו המאמינים. ");
INSERT INTO heblb_vpl VALUES ("GL6_11‏","078_6_11‏","GAL","6","11‏","12","לסיכום: האנשים שמנסים לשכנע אתכם לקיים ברית־מילה עושים זאת מסיבה אחת בלבד: הם יודעים היטב שאם יודו כי ישוע הוא המשיח, יהיה עליהם לסבול למענו. אבל אין הם רוצים לסבול ולאבד את הצלחתם החברתית. ");
INSERT INTO heblb_vpl VALUES ("GL6_13","078_6_13","GAL","6","13","13","אנשים אלה מקיימים את המילה, אך אינם שומרים בעצמם את חוקי התורה; הם רוצים שתקיימו את ברית־המילה רק כדי שיוכלו להתפאר בכוח־השפעתם ובעליונותם. ");
INSERT INTO heblb_vpl VALUES ("GL6_14","078_6_14","GAL","6","14","14","אני עצמי מתפאר אך ורק בצלב ישוע המשיח. הודות לצלב כבר אין לי עניין בשום דבר שקשור להנאות העולם הזה ולפיתוייו. וזה זמן רב כבר שלעולם הזה אין כל עניין בי. ");
INSERT INTO heblb_vpl VALUES ("GL6_15","078_6_15","GAL","6","15","15","עתה, כשאנו מאמינים בישוע המשיח, כלל לא חשוב אם עשינו ברית־מילה או לא. מה שחשוב הוא אם באמת אפשר לראות שאופיינו השתנה לטובה אם לא. ");
INSERT INTO heblb_vpl VALUES ("GL6_16","078_6_16","GAL","6","16","16","שלום ורחמים מאת אלוהים לכל השייכים לאלוהים והשומרים על העיקרון הזה. ");
INSERT INTO heblb_vpl VALUES ("GL6_17","078_6_17","GAL","6","17","17","אני מבקש מכם שמעתה ואילך לא תטרידו אותי בוויכוחים נוספים בנושא זה, שכן גופי מלא צלקות וחבורות, שגרמו לי אויבי המשיח, המשמשים לי סימנים של עבד ישוע המשיח. ");
INSERT INTO heblb_vpl VALUES ("GL6_18","078_6_18","GAL","6","18","18","אחים יקרים, יהי רצון שחסד ישוע המשיח יהיה עם כולכם. – אמן.");
INSERT INTO heblb_vpl VALUES ("EP1_1","079_1_1","EPH","1","1","1","מאת פולוס, שליחו של ישוע המשיח לפי רצון אלוהים. אל כל המאמינים המשיחיים, הנאמנים והקדושים, אשר נמצאים ‎ בְּאֶפֶסוֹס. ");
INSERT INTO heblb_vpl VALUES ("EP1_2","079_1_2","EPH","1","2","2","חסד ושלום לכם מאת האלוהים אבינו וישוע המשיח אדוננו. ");
INSERT INTO heblb_vpl VALUES ("EP1_3","079_1_3","EPH","1","3","3","אנחנו מברכים את האלוהים, אבי אדוננו ישוע המשיח, אשר ברך אותנו בכל ברכות השמים בזכות השתייכותנו למשיח. ");
INSERT INTO heblb_vpl VALUES ("EP1_4","079_1_4","EPH","1","4","4","עוד לפני שברא אלוהים את העולם הוא בחר אותנו בזכות המשיח, כדי לקדשנו ולהעמידנו לפניו ללא כל חטא או דופי. ");
INSERT INTO heblb_vpl VALUES ("EP1_5","079_1_5","EPH","1","5","5","באהבתו הרבה ומרצונו הטוב הוא אימץ אותנו לבניו על־ידי ישוע המשיח. ");
INSERT INTO heblb_vpl VALUES ("EP1_6","079_1_6","EPH","1","6","6","כל הכבוד, התהילה והשבח לאלוהינו על טוב־לבו וחסדו, ועל הברכות שברך אותנו בזכות השתייכותנו לבנו האהוב. ");
INSERT INTO heblb_vpl VALUES ("EP1_7","079_1_7","EPH","1","7","7","אלוהים הוא טוב ורחמן כל־כך, עד שגאל אותנו מחטאינו, במחיר דמו של המשיח, וסלח לנו על כל פשעינו. ");
INSERT INTO heblb_vpl VALUES ("EP1_8","079_1_8","EPH","1","8","8","וכל זאת הוא נתן לנו ברוחב־לב, בחכמה ובהבנה. ");
INSERT INTO heblb_vpl VALUES ("EP1_9","079_1_9","EPH","1","9","9","אלוהים גילה את מטרתו הסודית והנעלה בשליחת המשיח, תוכנית שבחר ברחמיו עוד לפני זמן רב. ");
INSERT INTO heblb_vpl VALUES ("EP1_10","079_1_10","EPH","1","10","10","וזוהי המטרה: בהגיע הזמן המיועד הוא יאסוף את כולנו מכל מקום, מהארץ ומהשמים. ");
INSERT INTO heblb_vpl VALUES ("EP1_11","079_1_11","EPH","1","11","11","לפי תוכניתו הנדיבה הכין לנו אלוהים נחלה במשיח. עוד מבראשית הוא בחר בנו להיות שלו, והכול מתרחש בדיוק כפי שהחליט מאז ומעולם. ");
INSERT INTO heblb_vpl VALUES ("EP1_12","079_1_12","EPH","1","12","12","אלוהים עשה זאת כדי שאנו, שהיינו המאמינים הראשונים במשיח, נשבח ונפאר את שמו, וניתן לו כבוד על שעשה למעננו את הדברים הנפלאים האלה. ");
INSERT INTO heblb_vpl VALUES ("EP1_13","079_1_13","EPH","1","13","13","גם אתם, ששמעתם את הבשורה אחרינו והאמנתם במשיח, נושעתם ונחתמתם כשייכים למשיח, באמצעות רוח הקודש אשר הובטח לכל המאמינים עוד לפני זמן רב. ");
INSERT INTO heblb_vpl VALUES ("EP1_14","079_1_14","EPH","1","14","14","נוכחותו של רוח הקודש בתוכנו היא הערובה שאלוהים באמת יעניק לנו כל מה שהבטיח, וחותם הרוח בנו פירושו שאלוהים קנה אותנו ויביאנו אליו. זוהי סיבה נוספת לנו לפאר ולשבח את אלוהינו. ");
INSERT INTO heblb_vpl VALUES ("EP1_15","079_1_15","EPH","1","15","15","משום כך, מאז ששמעתי על אמונתכם החזקה באדון ישוע, ועל אהבתכם למאמינים המשיחיים בכל מקום, ");
INSERT INTO heblb_vpl VALUES ("EP1_16‏","079_1_16‏","EPH","1","16‏","17","לא חדלתי להודות לאלוהים עבורכם. אני מתפלל בעדכם כל הזמן; אני מבקש מאלוהי אדוננו ישוע המשיח, מאבי הכבוד, שיעניק לכם רוח חכמה, כדי שתראו ותבינו מיהו המשיח ומה עשה למעננו. ");
INSERT INTO heblb_vpl VALUES ("EP1_18","079_1_18","EPH","1","18","18","אני מתפלל שאורו יציף את לבבכם ושעיניכם תיפקחנה, למען תוכלו לראות ולדעת מהי הקריאה שהועיד לכם, ומה עשירות ונפלאות הן הברכות שהבטיח למאמינים בו. ");
INSERT INTO heblb_vpl VALUES ("EP1_19‏","079_1_19‏","EPH","1","19‏","20","אני מתפלל שתבינו מה עצום הכוח שהעמיד אלוהים לרשות המאמינים בו; הוא העמיד לרשותנו את אותו הכוח העצום, אשר הקים את המשיח מן המתים והושיבו במקום הכבוד לימין האלוהים בשמים, ");
INSERT INTO heblb_vpl VALUES ("EP1_21","079_1_21","EPH","1","21","21","מעל לכל מלך, שליט או מנהיג. כן, כבודו גדול, מלא־הדר ורב־רושם יותר מזה של כל אחד אחר בעולם הזה או בעולם הבא. ");
INSERT INTO heblb_vpl VALUES ("EP1_22","079_1_22","EPH","1","22","22","אלוהים שם לרגליו את הכול, ומינה אותו לראש הקהילה, ");
INSERT INTO heblb_vpl VALUES ("EP1_23","079_1_23","EPH","1","23","23","אשר היא גופו ואשר מלאה במי שממלא את הכול. ");
INSERT INTO heblb_vpl VALUES ("EP2_1","079_2_1","EPH","2","1","1","פעם הייתם מתים באופן רוחני; הייתם תחת קללת האל בגלל מעשיכם הרעים. ");
INSERT INTO heblb_vpl VALUES ("EP2_2","079_2_2","EPH","2","2","2","חייתם לפי דרך־החיים של העולם הזה ושמעתם לקול השטן, שהוא השליט הרשע של הרוחות הרעות, והפועל עדיין בכל כוחו באנשים המורדים בה׳. ");
INSERT INTO heblb_vpl VALUES ("EP2_3","079_2_3","EPH","2","3","3","כולנו חיינו בעבר בצורה כזאת. אורח־חיינו ביטא את רוע לבנו וכניעתנו לתשוקותינו ותאוותינו. נולדנו בעלי טבע מושחת, והיינו תחת זעם אלוהים כשאר בני־האדם. ");
INSERT INTO heblb_vpl VALUES ("EP2_4","079_2_4","EPH","2","4","4","אבל אלוהים הוא אב מלא רחמים! הוא אהב אותנו כל־כך, ");
INSERT INTO heblb_vpl VALUES ("EP2_5","079_2_5","EPH","2","5","5","עד כי למרות שהיינו מתים (באופן רוחני) ואשמים בעיניו בגלל חטאינו, הוא החזיר אותנו לחיים כשהקים לתחייה את המשיח – זכרו שנושענו רק בזכות חסדו הרב – ");
INSERT INTO heblb_vpl VALUES ("EP2_6","079_2_6","EPH","2","6","6","והעלה אותנו מהקבר עם המשיח, כדי שנשב איתו במרומים. ");
INSERT INTO heblb_vpl VALUES ("EP2_7","079_2_7","EPH","2","7","7","כך הוא מראה לכל הדורות הבאים את רוחב־לבו, טובו וחסדו הנפלא, שביטא כלפינו בישוע המשיח. ");
INSERT INTO heblb_vpl VALUES ("EP2_8","079_2_8","EPH","2","8","8","נושעתם בזכות חסדו וטוב־לבו, על־ידי אמונתכם במשיח. כל זאת אינה שלכם; זוהי מתנתו של אלוהים, ואין היא תלויה בשום מעשה שעשיתם. ");
INSERT INTO heblb_vpl VALUES ("EP2_9","079_2_9","EPH","2","9","9","איננו יכולים להתפאר בישועה זאת, שכן איש מאיתנו לא הרוויח אותה! אלוהים נתן לנו את הישועה הזאת במתנה. ");
INSERT INTO heblb_vpl VALUES ("EP2_10","079_2_10","EPH","2","10","10","אלוהים עצמו עשה אותנו כפי שאנחנו עכשיו; הוא בחר בנו בישוע המשיח כדי שנעשה מעשים טובים, לפי תוכניתו מקדם. ");
INSERT INTO heblb_vpl VALUES ("EP2_11","079_2_11","EPH","2","11","11","אל תשכחו שנולדתם ”ערלים“, ואלה אשר נימולו בידי אדם הם כינו אתכם ”ערלים“. ");
INSERT INTO heblb_vpl VALUES ("EP2_12","079_2_12","EPH","2","12","12","באותה עת הייתם רחוקים מהמשיח, ונחותים מעם ישראל בחיר האלוהים; לא הייתה לכם כל זכות לבריתות ההבטחה, לא הייתה לכם תקווה ולא היה לכם אל. ");
INSERT INTO heblb_vpl VALUES ("EP2_13","079_2_13","EPH","2","13","13","אבל עכשיו אתם שייכים לישוע המשיח, ולמרות שפעם הייתם רחוקים מאלוהים, כעת אתם קרובים אליו בזכות דמו של המשיח שנשפך למענכם. ");
INSERT INTO heblb_vpl VALUES ("EP2_14","079_2_14","EPH","2","14","14","כי המשיח עצמו הוא שלומנו; הוא השכין שלום בינינו היהודים לביניכם הגויים, כשהרס את המחיצה בינינו ועשה משנינו אחד. ");
INSERT INTO heblb_vpl VALUES ("EP2_15","079_2_15","EPH","2","15","15","על־ידי מותו שם המשיח קץ לשנאה ולאיבה שהייתה בינינו – איבה שנבעה מכך שחוקי התורה היו לטובת היהודים ולא כללו את הגויים – כי המשיח מת כדי לבטל את שיטת חוקי התורה. ואז הוא לקח את שתי הקבוצות שהתנגדו זו לזו ועשה מהן גוף אחד. כך הוא מיזג אותנו יחדיו ויצר מאיתנו אדם אחד חדש, וכך עשה שלום. ");
INSERT INTO heblb_vpl VALUES ("EP2_16","079_2_16","EPH","2","16","16","כאיברים של גוף אחד, נעלמה האיבה שהייתה בינינו, כי המשיח שם קץ לאיבה המתמדת בינינו וריצה אותנו לאלוהים בהקריבו את עצמו על הצלב. ");
INSERT INTO heblb_vpl VALUES ("EP2_17","079_2_17","EPH","2","17","17","ואז הוא בישר את בשורת השלום לכם, הגויים, שהייתם רחוקים ממנו, ולנו, היהודים, שהיינו קרובים. ");
INSERT INTO heblb_vpl VALUES ("EP2_18","079_2_18","EPH","2","18","18","עתה באמצעותו ובזכותו יכולים כולנו, יהודים וגויים, לבוא אל אלוהים האב בעזרת רוח הקודש. ");
INSERT INTO heblb_vpl VALUES ("EP2_19","079_2_19","EPH","2","19","19","אם כן, עתה אינכם זרים ונחותים, אלא בני־משפחתו של אלוהים ואזרחים בממלכת אלוהים, יחד עם כל המאמינים האחרים. ");
INSERT INTO heblb_vpl VALUES ("EP2_20","079_2_20","EPH","2","20","20","אתם בנויים על היסודות שהניחו השליחים והנביאים, וישוע המשיח עצמו הוא אבן הפינה. ");
INSERT INTO heblb_vpl VALUES ("EP2_21","079_2_21","EPH","2","21","21","אנחנו, המאמינים, מחוברים אל המשיח ואיש אל רעהו בהתאמה, וכולנו מהווים היכל קודש לה׳. ");
INSERT INTO heblb_vpl VALUES ("EP2_22","079_2_22","EPH","2","22","22","גם אתם מחוברים אל המשיח ואיש אל רעהו, ומהווים משכן לרוח הקודש של אלוהים. ");
INSERT INTO heblb_vpl VALUES ("EP3_1","079_3_1","EPH","3","1","1","אני, פולוס, עבד ישוע המשיח, נמצא כאן בבית־הסוהר בגללכם. ");
INSERT INTO heblb_vpl VALUES ("EP3_2‏","079_3_2‏","EPH","3","2‏","3","אתם ודאי יודעים שאלוהים הטיל עלי את המשימה המיוחדת להראות לכם, הגויים, את חסדו, כפי שכבר ציינתי בקצרה באחד ממכתבי. אלוהים עצמו גילה לי את תוכניתו הסודית האומרת שגם הגויים כלולים בחסדו זה. ");
INSERT INTO heblb_vpl VALUES ("EP3_4","079_3_4","EPH","3","4","4","אני מספר לכם את כל זאת כדי שתבינו כיצד אני יודע את סוד המשיח. ");
INSERT INTO heblb_vpl VALUES ("EP3_5","079_3_5","EPH","3","5","5","בדורות הראשונים הסתיר אלוהים מעמו את הסוד הזה, אך עתה גילהו לשליחיו ונביאיו באמצעות רוח הקודש. ");
INSERT INTO heblb_vpl VALUES ("EP3_6","079_3_6","EPH","3","6","6","זהו הסוד: על־ידי הבשורה היהודים והגויים הם יורשים שווים של העושר המיועד לבני־האלוהים; הם חברים שווי־זכויות בקהילת האלוהים, ושותפים בהבטחותיו שניתנו על־ידי המשיח לכל המאמינים בו (במשיח). ");
INSERT INTO heblb_vpl VALUES ("EP3_7","079_3_7","EPH","3","7","7","אלוהים העניק לי את הזכות הנפלאה לספר לכולם על אודות תוכניתו זאת, ונתן לי את הכישרון והיכולת לעשות זאת כהלכה. ");
INSERT INTO heblb_vpl VALUES ("EP3_8","079_3_8","EPH","3","8","8","אכן, לי, הצעיר מכל המאמינים, העניק אלוהים את הזכות והחסד לבשר לגויים את הבשורה של עושר המשיח – עושר שהוא מעל ומעבר לכושר הבנתנו – ");
INSERT INTO heblb_vpl VALUES ("EP3_9","079_3_9","EPH","3","9","9","ולהסביר לכל האנשים שאלוהים הוא גם מושיעם של הגויים, כפי שבורא־הכול תכנן מבראשית. ");
INSERT INTO heblb_vpl VALUES ("EP3_10","079_3_10","EPH","3","10","10","מדוע? כדי שכל הכוחות, השרים והשליטים אשר בשמים יראו את חכמתו הנפלאה של אלוהים, וכל בני־משפחתו, יהודים וגויים, ייראו מאוחדים בקהילתו, ");
INSERT INTO heblb_vpl VALUES ("EP3_11","079_3_11","EPH","3","11","11","בדרך שבה תמיד תכנן זאת על־ידי ישוע המשיח אדוננו. ");
INSERT INTO heblb_vpl VALUES ("EP3_12","079_3_12","EPH","3","12","12","עתה אנו יכולים לבוא ישר אל נוכח האלוהים, ללא חשש ובטוחים שישמח לבואנו, בזכות אמונתנו בישוע המשיח. ");
INSERT INTO heblb_vpl VALUES ("EP3_13","079_3_13","EPH","3","13","13","לפיכך אל תדאגו על סבלי למענכם אלא התעודדו והתגאו בכך! ");
INSERT INTO heblb_vpl VALUES ("EP3_14","079_3_14","EPH","3","14","14","בחשבי על תוכנית נפלאה זאת אני כורע ברך לפני האלוהים, אבי אדוננו ישוע המשיח, ");
INSERT INTO heblb_vpl VALUES ("EP3_15","079_3_15","EPH","3","15","15","אשר על שמו נקראו כל המשפחות בארץ ובשמים, ");
INSERT INTO heblb_vpl VALUES ("EP3_16","079_3_16","EPH","3","16","16","ואני מתפלל שבאמצעות רוח הקודש הוא יעניק לכם כוח וגבורה פנימיים מתוך אוצרו הנהדר והאין־סופי. ");
INSERT INTO heblb_vpl VALUES ("EP3_17","079_3_17","EPH","3","17","17","אני מתפלל שהמשיח באמת ישכון בלבבכם על־ידי אמונתכם ושתתחזקו באהבה, ");
INSERT INTO heblb_vpl VALUES ("EP3_18","079_3_18","EPH","3","18","18","כדי שתוכלו לתפוש ולהבין, יחד עם שאר המאמינים, עד כמה עצומה, רבה, עמוקה וחובקת היא אהבת המשיח, ");
INSERT INTO heblb_vpl VALUES ("EP3_19","079_3_19","EPH","3","19","19","וכדי שתתנסו בעצמכם באהבה נפלאה זאת, שהיא מעל ומעבר להבנתנו. וכך תימלאו כולכם באלוהים עצמו. ");
INSERT INTO heblb_vpl VALUES ("EP3_20","079_3_20","EPH","3","20","20","אלוהים יכול להרבות את חסדו אלינו, ולפעול בנו מעל ומעבר למה שאנו מסוגלים לתאר או לבקש. ");
INSERT INTO heblb_vpl VALUES ("EP3_21","079_3_21","EPH","3","21","21","כל הכבוד והתהילה לאלוהים בקרב המאמינים ובישוע המשיח, לדור ודור עד עולם. ");
INSERT INTO heblb_vpl VALUES ("EP4_1","079_4_1","EPH","4","1","1","כאסיר האדון אני מתחנן לפניכם שתחיו ותתנהגו בדרך ההולמת את אלה שנבחרו להתברך בכל הברכות הנפלאות האלה. ");
INSERT INTO heblb_vpl VALUES ("EP4_2","079_4_2","EPH","4","2","2","היו ענווים ואדיבים; התייחסו בסבלנות זה אל זה, וסלחו איש לאחיו באהבה. ");
INSERT INTO heblb_vpl VALUES ("EP4_3","079_4_3","EPH","4","3","3","שאפו לשמור על אחדותכם ברוח הקודש, וחיו בשלום איש עם רעהו. ");
INSERT INTO heblb_vpl VALUES ("EP4_4","079_4_4","EPH","4","4","4","כולנו איברים של גוף אחד, לכולנו רוח אחד, וכולנו נבחרנו לאותו עתיד נפלא. ");
INSERT INTO heblb_vpl VALUES ("EP4_5","079_4_5","EPH","4","5","5","לכולנו אדון אחד, אמונה אחת וטבילה אחת. ");
INSERT INTO heblb_vpl VALUES ("EP4_6","079_4_6","EPH","4","6","6","לכולנו אל ואב אחד שהוא מעל לכל, נמצא בכל וחי בכל. ");
INSERT INTO heblb_vpl VALUES ("EP4_7","079_4_7","EPH","4","7","7","ובכל זאת, המשיח העניק לכל אחד מאיתנו מתנות וכישרונות שונים ומיוחדים, מתוך עושרו ולפי רצונו. ");
INSERT INTO heblb_vpl VALUES ("EP4_8","079_4_8","EPH","4","8","8","על כך אומרים הכתובים שכאשר עלה המשיח לשמים, לאחר תחייתו מהמתים, הוא שבה שבי ונתן מתנות לבני האדם. ");
INSERT INTO heblb_vpl VALUES ("EP4_9","079_4_9","EPH","4","9","9","שימו לב שכתוב ”עלה לשמים“! משמע שקודם לכן הוא ירד ממרומי השמים אל תחתיות הארץ. ");
INSERT INTO heblb_vpl VALUES ("EP4_10","079_4_10","EPH","4","10","10","זה שירד אלינו הוא זה שעלה השמימה כדי למלא באישיותו את הכול, מתחתיות הארץ עד למרומי השמים. ");
INSERT INTO heblb_vpl VALUES ("EP4_11","079_4_11","EPH","4","11","11","הוא העניק לבני־האדם מתנות שונות: לאחדים העניק את היכולת להיות שליחיו, לאלה העניק את היכולת להיות נביאים, ולאלה העניק כישרון מיוחד לבשר את הבשורה, או כושר מנהיגות והדרכה לפי דבר ה׳ וכישרון ללמד היטב. ");
INSERT INTO heblb_vpl VALUES ("EP4_12","079_4_12","EPH","4","12","12","לשם מה העניק לנו המשיח את המתנות והכישרונות הללו? כדי שבני־אלוהים יוכלו להיטיב לשרתו בשעה שהם בונים את הקהילה, שהיא גוף המשיח, ");
INSERT INTO heblb_vpl VALUES ("EP4_13","079_4_13","EPH","4","13","13","עד שנגיע כולנו כאחד לאמונה, בגרות והבנה של מושיענו בן האלוהים – עד שנתמלא כליל במשיח. ");
INSERT INTO heblb_vpl VALUES ("EP4_14","079_4_14","EPH","4","14","14","וכך מעתה ואילך לא נשנה את דעתנו בנוגע לאמונתנו; לא ניכשל ולא נרומה על־ידי רמאים ובדחנים, ");
INSERT INTO heblb_vpl VALUES ("EP4_15","079_4_15","EPH","4","15","15","אלא נאמר את האמת באהבה, ונגדל באמונתנו במשיח אשר הוא ראש־הקהילה. ");
INSERT INTO heblb_vpl VALUES ("EP4_16","079_4_16","EPH","4","16","16","בהנהגתו של המשיח מחוברים כל איברי הגוף זה לזה, וכל איבר עוזר למשנהו לבניית הגוף, לפי מידת הכוח שניתן לו, כך שכל הגוף צומח לבניין אחד מלא אהבה – בניין המשיח. ");
INSERT INTO heblb_vpl VALUES ("EP4_17","079_4_17","EPH","4","17","17","בשם האדון אני אומר לכם: אל תשובו לחיות כמו הלא מאמינים, כי הם הולכים אחרי טיפשות שיכלם. ");
INSERT INTO heblb_vpl VALUES ("EP4_18","079_4_18","EPH","4","18","18","בגלל טיפשותם הם בורים וחסרי־דעת בכל הנוגע לחיי אלוהים; הם אינם מבינים את דרכו של אלוהים, כי הם חיים בחשכה ובחטא. ");
INSERT INTO heblb_vpl VALUES ("EP4_19","079_4_19","EPH","4","19","19","הם איבדו כל רגש בושה, והפקירו את עצמם לתאוות בשרם ולכל מעשה זימה ומרמה. ");
INSERT INTO heblb_vpl VALUES ("EP4_20","079_4_20","EPH","4","20","20","אבל לא כך לימד אתכם המשיח! ");
INSERT INTO heblb_vpl VALUES ("EP4_21","079_4_21","EPH","4","21","21","אם באמת הקשבתם לקולו והבינותם את האמת שלימד אתכם, ");
INSERT INTO heblb_vpl VALUES ("EP4_22","079_4_22","EPH","4","22","22","אזי עליכם לסור מדרככם הישנה ומהרגליכם הקודמים, שהיו זימה, תאווה ורמייה, ");
INSERT INTO heblb_vpl VALUES ("EP4_23","079_4_23","EPH","4","23","23","ולחדש את מחשבותיכם וגישתכם לדברים שונים. ");
INSERT INTO heblb_vpl VALUES ("EP4_24","079_4_24","EPH","4","24","24","כן, עליכם להיות אנשים מחודשים בעלי תכונות שהעניק לכם אלוהים, קדושים וצדיקים. עטפו את עצמכם באופי חדש זה. ");
INSERT INTO heblb_vpl VALUES ("EP4_25","079_4_25","EPH","4","25","25","הפסיקו לשקר ודברו אמת, שכן אנו איברים איש לאחיו, ובשקרנו לאחינו אנו פוגעים למעשה בעצמנו! ");
INSERT INTO heblb_vpl VALUES ("EP4_26","079_4_26","EPH","4","26","26","אם אתם כועסים, אל תניחו לכעסכם להביא אתכם לידי חטא! אל תניחו לשמש לשקוע לפני שחלף כעסכם, ");
INSERT INTO heblb_vpl VALUES ("EP4_27","079_4_27","EPH","4","27","27","כי אחרת אתם פותחים פתח לשטן. ");
INSERT INTO heblb_vpl VALUES ("EP4_28","079_4_28","EPH","4","28","28","הגנב חייב להפסיק לגנוב! עליו להתחיל לעבוד עבודה ישרה, כדי שיוכל לעזור לנזקקים. ");
INSERT INTO heblb_vpl VALUES ("EP4_29","079_4_29","EPH","4","29","29","אל תנבלו את פיכם! דברו רק דברים יפים, טובים ומועילים לאנשים אחרים, דברים שיברכו את השומעים. ");
INSERT INTO heblb_vpl VALUES ("EP4_30","079_4_30","EPH","4","30","30","אל תצערו את רוח הקודש של אלוהים, שעל ידיו נחתמתם ליום הגאולה. ");
INSERT INTO heblb_vpl VALUES ("EP4_31","079_4_31","EPH","4","31","31","הפסיקו להתמרמר והסירו מעליכם כל כעס, רוגז, צעקות, קללות ורשעות. ");
INSERT INTO heblb_vpl VALUES ("EP4_32","079_4_32","EPH","4","32","32","היו טובים איש לרעהו, רחמנים וסלחנים, כשם שאלוהים סלח לכם בזכות השתייכותכם למשיח. ");
INSERT INTO heblb_vpl VALUES ("EP5_1","079_5_1","EPH","5","1","1","עליכם ללכת בעקבות אלוהים, כי אתם ילדיו והוא אוהב אתכם. ");
INSERT INTO heblb_vpl VALUES ("EP5_2","079_5_2","EPH","5","2","2","אהבו איש את רעהו, כשם שהמשיח אהב אותנו וביטא אהבה זאת בהקריבו את עצמו למעננו, כדי לסלוח על חטאינו, וקורבנו היה רצוי לאלוהים. ");
INSERT INTO heblb_vpl VALUES ("EP5_3","079_5_3","EPH","5","3","3","בכל הנוגע למעשי זנות למיניהם, מעשי טומאה ואהבת בצע – אפילו אל תזכירו אותם! נושאים אלה אינם הולמים שיחת מאמינים משיחיים. ");
INSERT INTO heblb_vpl VALUES ("EP5_4","079_5_4","EPH","5","4","4","הימנעו גם מניבול־פה, דברי שטות וליצנות – אין הם הולמים אתכם! לעומת זאת, הזכירו איש לרעהו את טוב־לבו של אלוהים והיו אסירי תודה. ");
INSERT INTO heblb_vpl VALUES ("EP5_5","079_5_5","EPH","5","5","5","דעו לכם כי הזונים ואוהבי הבצע, שאינם אלא עובדי אלילים, לעולם לא יירשו את מלכות האלוהים והמשיח, כי הם אוהבים את דברי העולם הזה יותר מאשר את אלוהים. ");
INSERT INTO heblb_vpl VALUES ("EP5_6","079_5_6","EPH","5","6","6","אל תניחו לאיש להתעות אתכם בנושא זה, כי בגלל חטאים כאלה ישפוך אלוהים את זעמו על מי שמורד בו. ");
INSERT INTO heblb_vpl VALUES ("EP5_7","079_5_7","EPH","5","7","7","אף אל תתחברו עם אנשים כאלה! ");
INSERT INTO heblb_vpl VALUES ("EP5_8","079_5_8","EPH","5","8","8","פעם חייתם בחשכה ובחטא, אך כעת אתם חיים באור אדוננו, והתנהגותכם צריכה להוכיח זאת. ");
INSERT INTO heblb_vpl VALUES ("EP5_9","079_5_9","EPH","5","9","9","שכן פרי הרוח והאור הוא כל דבר טוב, צודק ואמיתי. ");
INSERT INTO heblb_vpl VALUES ("EP5_10","079_5_10","EPH","5","10","10","השתדלו ללמוד מה רצוי בעיני אדוננו. ");
INSERT INTO heblb_vpl VALUES ("EP5_11","079_5_11","EPH","5","11","11","אל תשתתפו במעשים רעים למיניהם שאינם מביאים כל תועלת, אלא הוקיעו אותם! ");
INSERT INTO heblb_vpl VALUES ("EP5_12","079_5_12","EPH","5","12","12","בושה וחרפה היא מה שעושים הרשעים בסתר. ");
INSERT INTO heblb_vpl VALUES ("EP5_13","079_5_13","EPH","5","13","13","כשאתה חושף אותם לאור נראים חטאיהם בבירור, ובמקום שבו ניתן לראות בבירור יש אור. ");
INSERT INTO heblb_vpl VALUES ("EP5_14","079_5_14","EPH","5","14","14","על כן נֶאֱמַר: ”התעורר, אתה הישן, קום מן המתים והמשיח יאיר עליך!“ ");
INSERT INTO heblb_vpl VALUES ("EP5_15‏","079_5_15‏","EPH","5","15‏","16","לפיכך התנהגו בזהירות, שכן אלה הם ימים קשים. אל תהיו שוטים, אלא חכמים, ונצלו היטב כל הזדמנות לעשות מעשים טובים. ");
INSERT INTO heblb_vpl VALUES ("EP5_17","079_5_17","EPH","5","17","17","אל תתנהגו בחוסר מחשבה, אלא השתדלו להבין מה רוצה האדון שתעשו, ועשו זאת! ");
INSERT INTO heblb_vpl VALUES ("EP5_18","079_5_18","EPH","5","18","18","אל תרבו בשתיית יין, כי שתייה מרובה גורמת למעשים רעים. לעומת זאת, מלאו עצמכם ברוח הקודש והניחו לו לשלוט בכם. ");
INSERT INTO heblb_vpl VALUES ("EP5_19","079_5_19","EPH","5","19","19","בפגשכם זה את זה שוחחו על אודות האדון, צטטו מזמורי תהלים, שירו שירים רוחניים וזמרו לאלוהים בלבבכם. ");
INSERT INTO heblb_vpl VALUES ("EP5_20","079_5_20","EPH","5","20","20","הודו תמיד על כל דבר לאלוהים אבינו בשם ישוע המשיח אדוננו. ");
INSERT INTO heblb_vpl VALUES ("EP5_21","079_5_21","EPH","5","21","21","כבדו את המשיח על־ידי כניעתכם איש לרעהו. ");
INSERT INTO heblb_vpl VALUES ("EP5_22","079_5_22","EPH","5","22","22","נשים, עליכן להיכנע ולציית לבעליכן, כשם שאתן נכנעות ומצייתות למשיח. ");
INSERT INTO heblb_vpl VALUES ("EP5_23","079_5_23","EPH","5","23","23","כי הבעל הוא ראש האישה, כשם שהמשיח הוא ראש הקהילה, שהיא גופו ואשר למענה הקריב את חייו, כדי להושיעה ולדאוג לה. ");
INSERT INTO heblb_vpl VALUES ("EP5_24","079_5_24","EPH","5","24","24","אם כן, עליכן, הנשים, להיכנע ברצון לבעליכן בכל דבר, כשם שהקהילה נכנעת למשיח. ");
INSERT INTO heblb_vpl VALUES ("EP5_25","079_5_25","EPH","5","25","25","אתם, הבעלים, אהבו את נשותיכם באותה מידה שאהב המשיח את הקהילה, כשהקריב את חייו למענה ");
INSERT INTO heblb_vpl VALUES ("EP5_26","079_5_26","EPH","5","26","26","כדי לזכותה ולקדשה, לרחצה בדבר אלוהים, ");
INSERT INTO heblb_vpl VALUES ("EP5_27","079_5_27","EPH","5","27","27","למען יוכל להעמידה לפניו כקהילה יפה וקדושה, חסרת־דופי, כתם או פגם. ");
INSERT INTO heblb_vpl VALUES ("EP5_28","079_5_28","EPH","5","28","28","על הבעלים לאהוב את נשותיהם כמו את עצמם, כי הבעל ואשתו אחד הם. ");
INSERT INTO heblb_vpl VALUES ("EP5_29‏","079_5_29‏","EPH","5","29‏","30","הרי איש אינו שונא את גופו, אלא מזין אותו ודואג לו באהבה, כשם שהמשיח דואג לקהילתו, ואנו הרי איברי גופו, בשר מבשרו. ");
INSERT INTO heblb_vpl VALUES ("EP5_31","079_5_31","EPH","5","31","31","כפי שאומר הכתוב: ”על כן יעזוב איש את אביו ואת אמו, ודבק באשתו והיו לבשר אחד.“ ");
INSERT INTO heblb_vpl VALUES ("EP5_32","079_5_32","EPH","5","32","32","קשר הנשואים הוא דבר מופלא, אך יש בו הקבלה לקשר שבין המשיח והקהילה. ");
INSERT INTO heblb_vpl VALUES ("EP5_33","079_5_33","EPH","5","33","33","אם כן, אני חוזר ואומר: הבעל חייב לאהוב את אשתו כמו את עצמו, והאישה חייבת לכבד את בעלה ולציית לו. ");
INSERT INTO heblb_vpl VALUES ("EP6_1","079_6_1","EPH","6","1","1","ילדים, שמעו בקול הוריכם, כי כך נאה. ");
INSERT INTO heblb_vpl VALUES ("EP6_2","079_6_2","EPH","6","2","2","המצווה הראשונה בעשרת־הדיברות הנושאת הבטחה בצידה היא: ”כבד את אביך ואת אמך!“ ");
INSERT INTO heblb_vpl VALUES ("EP6_3","079_6_3","EPH","6","3","3","מהי ההבטחה? אם תכבד את אביך ואת אמך יאריכו ימיך ויהיה לך טוב בחיים. ");
INSERT INTO heblb_vpl VALUES ("EP6_4","079_6_4","EPH","6","4","4","הורים, אל תציקו לילדיכם! אל תרגיזו ואל תכעיסו אותם, אלא גדלו אותם לפי החינוך והמוסר של ישוע המשיח אדוננו. ");
INSERT INTO heblb_vpl VALUES ("EP6_5","079_6_5","EPH","6","5","5","עבדים, שמעו בקול אדוניכם; כבדו ושרתו אותם כמו את המשיח. ");
INSERT INTO heblb_vpl VALUES ("EP6_6‏","079_6_6‏","EPH","6","6‏","7","אל תנסו להרשים את אדוניכם בעבודתכם הקשה רק כשהם מביטים בכם! עבדו במסירות ובשמחה בכל עת, כאילו שאתם עובדים למען המשיח (ולא למען בני־אדם) ועושים את רצון אלוהים מכל לבכם. ");
INSERT INTO heblb_vpl VALUES ("EP6_8","079_6_8","EPH","6","8","8","זכרו, האדון יגמול לכם על כל מעשה טוב שאתם עושים, בין אם אתם עבדים ובין אם אתם בני־חורין. ");
INSERT INTO heblb_vpl VALUES ("EP6_9","079_6_9","EPH","6","9","9","אתם, האדונים, התנהגו כהלכה עם עבדיכם. אל תגערו בהם ואל תאיימו עליהם! זכרו, אתם בעצמכם עבדי המשיח; אדונכם הוא גם אדונם, ואין לפניו משוא־פנים. ");
INSERT INTO heblb_vpl VALUES ("EP6_10","079_6_10","EPH","6","10","10","לסיום, ברצוני להזכיר לכם שכוחכם צריך לנבוע מגבורת אלוהים שבכם. ");
INSERT INTO heblb_vpl VALUES ("EP6_11","079_6_11","EPH","6","11","11","הצטיידו בכלי הנשק שאלוהים מעמיד לרשותכם, כדי שתוכלו לעמוד נגד התקפות השטן ותחבולותיו. ");
INSERT INTO heblb_vpl VALUES ("EP6_12","079_6_12","EPH","6","12","12","כי איננו נלחמים נגד בשר ודם, אלא נגד שליטי העולם הבלתי־נראה; נגד אותם כוחות רשע השולטים בעולם הזה, ונגד רוחות רעות ומרושעות. ");
INSERT INTO heblb_vpl VALUES ("EP6_13","079_6_13","EPH","6","13","13","על כן אחזו בכלי הנשק שאלוהים מעניק לכם, כדי שתוכלו להדוף את התקפות האויב, ואף תוכלו לעמוד איתן לאחר המאבק. ");
INSERT INTO