﻿USE sofia;
DROP TABLE IF EXISTS sofia.heb_vpl;
CREATE TABLE heb_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES heb_vpl WRITE;
INSERT INTO heb_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","בראשית ברא אלהים את השמים ואת הארץ׃ ");
INSERT INTO heb_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","והארץ היתה תהו ובהו וחשך על פני תהום ורוח אלהים מרחפת על פני המים׃ ");
INSERT INTO heb_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","ויאמר אלהים יהי אור ויהי אור׃ ");
INSERT INTO heb_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","וירא אלהים את האור כי טוב ויבדל אלהים בין האור ובין החשך׃ ");
INSERT INTO heb_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","ויקרא אלהים לאור יום ולחשך קרא לילה ויהי ערב ויהי בקר יום אחד׃ ");
INSERT INTO heb_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","ויאמר אלהים יהי רקיע בתוך המים ויהי מבדיל בין מים למים׃ ");
INSERT INTO heb_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","ויעש אלהים את הרקיע ויבדל בין המים אשר מתחת לרקיע ובין המים אשר מעל לרקיע ויהי כן׃ ");
INSERT INTO heb_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","ויקרא אלהים לרקיע שמים ויהי ערב ויהי בקר יום שני׃ ");
INSERT INTO heb_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","ויאמר אלהים יקוו המים מתחת השמים אל מקום אחד ותראה היבשה ויהי כן׃ ");
INSERT INTO heb_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","ויקרא אלהים ליבשה ארץ ולמקוה המים קרא ימים וירא אלהים כי טוב׃ ");
INSERT INTO heb_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","ויאמר אלהים תדשא הארץ דשא עשב מזריע זרע עץ פרי עשה פרי למינו אשר זרעו בו על הארץ ויהי כן׃ ");
INSERT INTO heb_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","ותוצא הארץ דשא עשב מזריע זרע למינהו ועץ עשה פרי אשר זרעו בו למינהו וירא אלהים כי טוב׃ ");
INSERT INTO heb_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","ויהי ערב ויהי בקר יום שלישי׃ ");
INSERT INTO heb_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","ויאמר אלהים יהי מארת ברקיע השמים להבדיל בין היום ובין הלילה והיו לאתת ולמועדים ולימים ושנים׃ ");
INSERT INTO heb_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","והיו למאורת ברקיע השמים להאיר על הארץ ויהי כן׃ ");
INSERT INTO heb_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","ויעש אלהים את שני המארת הגדלים את המאור הגדל לממשלת היום ואת המאור הקטן לממשלת הלילה ואת הכוכבים׃ ");
INSERT INTO heb_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","ויתן אתם אלהים ברקיע השמים להאיר על הארץ׃ ");
INSERT INTO heb_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","ולמשל ביום ובלילה ולהבדיל בין האור ובין החשך וירא אלהים כי טוב׃ ");
INSERT INTO heb_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","ויהי ערב ויהי בקר יום רביעי׃ ");
INSERT INTO heb_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","ויאמר אלהים ישרצו המים שרץ נפש חיה ועוף יעופף על הארץ על פני רקיע השמים׃ ");
INSERT INTO heb_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","ויברא אלהים את התנינם הגדלים ואת כל נפש החיה הרמשת אשר שרצו המים למינהם ואת כל עוף כנף למינהו וירא אלהים כי טוב׃ ");
INSERT INTO heb_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","ויברך אתם אלהים לאמר פרו ורבו ומלאו את המים בימים והעוף ירב בארץ׃ ");
INSERT INTO heb_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","ויהי ערב ויהי בקר יום חמישי׃ ");
INSERT INTO heb_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","ויאמר אלהים תוצא הארץ נפש חיה למינה בהמה ורמש וחיתו ארץ למינה ויהי כן׃ ");
INSERT INTO heb_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","ויעש אלהים את חית הארץ למינה ואת הבהמה למינה ואת כל רמש האדמה למינהו וירא אלהים כי טוב׃ ");
INSERT INTO heb_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","ויאמר אלהים נעשה אדם בצלמנו כדמותנו וירדו בדגת הים ובעוף השמים ובבהמה ובכל הארץ ובכל הרמש הרמש על הארץ׃ ");
INSERT INTO heb_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","ויברא אלהים את האדם בצלמו בצלם אלהים ברא אתו זכר ונקבה ברא אתם׃ ");
INSERT INTO heb_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","ויברך אתם אלהים ויאמר להם אלהים פרו ורבו ומלאו את הארץ וכבשה ורדו בדגת הים ובעוף השמים ובכל חיה הרמשת על הארץ׃ ");
INSERT INTO heb_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","ויאמר אלהים הנה נתתי לכם את כל עשב זרע זרע אשר על פני כל הארץ ואת כל העץ אשר בו פרי עץ זרע זרע לכם יהיה לאכלה׃ ");
INSERT INTO heb_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","ולכל חית הארץ ולכל עוף השמים ולכל רומש על הארץ אשר בו נפש חיה את כל ירק עשב לאכלה ויהי כן׃ ");
INSERT INTO heb_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","וירא אלהים את כל אשר עשה והנה טוב מאד ויהי ערב ויהי בקר יום הששי׃ ");
INSERT INTO heb_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","ויכלו השמים והארץ וכל צבאם׃ ");
INSERT INTO heb_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","ויכל אלהים ביום השביעי מלאכתו אשר עשה וישבת ביום השביעי מכל מלאכתו אשר עשה׃ ");
INSERT INTO heb_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","ויברך אלהים את יום השביעי ויקדש אתו כי בו שבת מכל מלאכתו אשר ברא אלהים לעשות׃ ");
INSERT INTO heb_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","אלה תולדות השמים והארץ בהבראם ביום עשות יהוה אלהים ארץ ושמים׃ ");
INSERT INTO heb_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","וכל שיח השדה טרם יהיה בארץ וכל עשב השדה טרם יצמח כי לא המטיר יהוה אלהים על הארץ ואדם אין לעבד את האדמה׃ ");
INSERT INTO heb_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","ואד יעלה מן הארץ והשקה את כל פני האדמה׃ ");
INSERT INTO heb_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","וייצר יהוה אלהים את האדם עפר מן האדמה ויפח באפיו נשמת חיים ויהי האדם לנפש חיה׃ ");
INSERT INTO heb_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","ויטע יהוה אלהים גן בעדן מקדם וישם שם את האדם אשר יצר׃ ");
INSERT INTO heb_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","ויצמח יהוה אלהים מן האדמה כל עץ נחמד למראה וטוב למאכל ועץ החיים בתוך הגן ועץ הדעת טוב ורע׃ ");
INSERT INTO heb_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","ונהר יצא מעדן להשקות את הגן ומשם יפרד והיה לארבעה ראשים׃ ");
INSERT INTO heb_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","שם האחד פישון הוא הסבב את כל ארץ החוילה אשר שם הזהב׃ ");
INSERT INTO heb_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","וזהב הארץ ההוא טוב שם הבדלח ואבן השהם׃ ");
INSERT INTO heb_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","ושם הנהר השני גיחון הוא הסובב את כל ארץ כוש׃ ");
INSERT INTO heb_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","ושם הנהר השלישי חדקל הוא ההלך קדמת אשור והנהר הרביעי הוא פרת׃ ");
INSERT INTO heb_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","ויקח יהוה אלהים את האדם וינחהו בגן עדן לעבדה ולשמרה׃ ");
INSERT INTO heb_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","ויצו יהוה אלהים על האדם לאמר מכל עץ הגן אכל תאכל׃ ");
INSERT INTO heb_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","ומעץ הדעת טוב ורע לא תאכל ממנו כי ביום אכלך ממנו מות תמות׃ ");
INSERT INTO heb_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","ויאמר יהוה אלהים לא טוב היות האדם לבדו אעשה לו עזר כנגדו׃ ");
INSERT INTO heb_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","ויצר יהוה אלהים מן האדמה כל חית השדה ואת כל עוף השמים ויבא אל האדם לראות מה יקרא לו וכל אשר יקרא לו האדם נפש חיה הוא שמו׃ ");
INSERT INTO heb_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","ויקרא האדם שמות לכל הבהמה ולעוף השמים ולכל חית השדה ולאדם לא מצא עזר כנגדו׃ ");
INSERT INTO heb_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","ויפל יהוה אלהים תרדמה על האדם ויישן ויקח אחת מצלעתיו ויסגר בשר תחתנה׃ ");
INSERT INTO heb_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","ויבן יהוה אלהים את הצלע אשר לקח מן האדם לאשה ויבאה אל האדם׃ ");
INSERT INTO heb_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","ויאמר האדם זאת הפעם עצם מעצמי ובשר מבשרי לזאת יקרא אשה כי מאיש לקחה זאת׃ ");
INSERT INTO heb_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","על כן יעזב איש את אביו ואת אמו ודבק באשתו והיו לבשר אחד׃ ");
INSERT INTO heb_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","ויהיו שניהם ערומים האדם ואשתו ולא יתבששו׃ ");
INSERT INTO heb_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","והנחש היה ערום מכל חית השדה אשר עשה יהוה אלהים ויאמר אל האשה אף כי אמר אלהים לא תאכלו מכל עץ הגן׃ ");
INSERT INTO heb_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","ותאמר האשה אל הנחש מפרי עץ הגן נאכל׃ ");
INSERT INTO heb_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","ומפרי העץ אשר בתוך הגן אמר אלהים לא תאכלו ממנו ולא תגעו בו פן תמתון׃ ");
INSERT INTO heb_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","ויאמר הנחש אל האשה לא מות תמתון׃ ");
INSERT INTO heb_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","כי ידע אלהים כי ביום אכלכם ממנו ונפקחו עיניכם והייתם כאלהים ידעי טוב ורע׃ ");
INSERT INTO heb_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","ותרא האשה כי טוב העץ למאכל וכי תאוה הוא לעינים ונחמד העץ להשכיל ותקח מפריו ותאכל ותתן גם לאישה עמה ויאכל׃ ");
INSERT INTO heb_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","ותפקחנה עיני שניהם וידעו כי עירמם הם ויתפרו עלה תאנה ויעשו להם חגרת׃ ");
INSERT INTO heb_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","וישמעו את קול יהוה אלהים מתהלך בגן לרוח היום ויתחבא האדם ואשתו מפני יהוה אלהים בתוך עץ הגן׃ ");
INSERT INTO heb_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","ויקרא יהוה אלהים אל האדם ויאמר לו איכה׃ ");
INSERT INTO heb_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","ויאמר את קלך שמעתי בגן ואירא כי עירם אנכי ואחבא׃ ");
INSERT INTO heb_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","ויאמר מי הגיד לך כי עירם אתה המן העץ אשר צויתיך לבלתי אכל ממנו אכלת׃ ");
INSERT INTO heb_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","ויאמר האדם האשה אשר נתתה עמדי הוא נתנה לי מן העץ ואכל׃ ");
INSERT INTO heb_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","ויאמר יהוה אלהים לאשה מה זאת עשית ותאמר האשה הנחש השיאני ואכל׃ ");
INSERT INTO heb_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","ויאמר יהוה אלהים אל הנחש כי עשית זאת ארור אתה מכל הבהמה ומכל חית השדה על גחנך תלך ועפר תאכל כל ימי חייך׃ ");
INSERT INTO heb_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","ואיבה אשית בינך ובין האשה ובין זרעך ובין זרעה הוא ישופך ראש ואתה תשופנו עקב׃ ");
INSERT INTO heb_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","אל האשה אמר הרבה ארבה עצבונך והרנך בעצב תלדי בנים ואל אישך תשוקתך והוא ימשל בך׃ ");
INSERT INTO heb_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","ולאדם אמר כי שמעת לקול אשתך ותאכל מן העץ אשר צויתיך לאמר לא תאכל ממנו ארורה האדמה בעבורך בעצבון תאכלנה כל ימי חייך׃ ");
INSERT INTO heb_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","וקוץ ודרדר תצמיח לך ואכלת את עשב השדה׃ ");
INSERT INTO heb_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","בזעת אפיך תאכל לחם עד שובך אל האדמה כי ממנה לקחת כי עפר אתה ואל עפר תשוב׃ ");
INSERT INTO heb_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","ויקרא האדם שם אשתו חוה כי הוא היתה אם כל חי׃ ");
INSERT INTO heb_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","ויעש יהוה אלהים לאדם ולאשתו כתנות עור וילבשם׃ ");
INSERT INTO heb_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","ויאמר יהוה אלהים הן האדם היה כאחד ממנו לדעת טוב ורע ועתה פן ישלח ידו ולקח גם מעץ החיים ואכל וחי לעלם׃ ");
INSERT INTO heb_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","וישלחהו יהוה אלהים מגן עדן לעבד את האדמה אשר לקח משם׃ ");
INSERT INTO heb_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","ויגרש את האדם וישכן מקדם לגן עדן את הכרבים ואת להט החרב המתהפכת לשמר את דרך עץ החיים׃ ");
INSERT INTO heb_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","והאדם ידע את חוה אשתו ותהר ותלד את קין ותאמר קניתי איש את יהוה׃ ");
INSERT INTO heb_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","ותסף ללדת את אחיו את הבל ויהי הבל רעה צאן וקין היה עבד אדמה׃ ");
INSERT INTO heb_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","ויהי מקץ ימים ויבא קין מפרי האדמה מנחה ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","והבל הביא גם הוא מבכרות צאנו ומחלבהן וישע יהוה אל הבל ואל מנחתו׃ ");
INSERT INTO heb_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","ואל קין ואל מנחתו לא שעה ויחר לקין מאד ויפלו פניו׃ ");
INSERT INTO heb_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","ויאמר יהוה אל קין למה חרה לך ולמה נפלו פניך׃ ");
INSERT INTO heb_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","הלוא אם תיטיב שאת ואם לא תיטיב לפתח חטאת רבץ ואליך תשוקתו ואתה תמשל בו׃ ");
INSERT INTO heb_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","ויאמר קין אל הבל אחיו ויהי בהיותם בשדה ויקם קין אל הבל אחיו ויהרגהו׃ ");
INSERT INTO heb_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","ויאמר יהוה אל קין אי הבל אחיך ויאמר לא ידעתי השמר אחי אנכי׃ ");
INSERT INTO heb_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","ויאמר מה עשית קול דמי אחיך צעקים אלי מן האדמה׃ ");
INSERT INTO heb_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","ועתה ארור אתה מן האדמה אשר פצתה את פיה לקחת את דמי אחיך מידך׃ ");
INSERT INTO heb_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","כי תעבד את האדמה לא תסף תת כחה לך נע ונד תהיה בארץ׃ ");
INSERT INTO heb_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","ויאמר קין אל יהוה גדול עוני מנשא׃ ");
INSERT INTO heb_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","הן גרשת אתי היום מעל פני האדמה ומפניך אסתר והייתי נע ונד בארץ והיה כל מצאי יהרגני׃ ");
INSERT INTO heb_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","ויאמר לו יהוה לכן כל הרג קין שבעתים יקם וישם יהוה לקין אות לבלתי הכות אתו כל מצאו׃ ");
INSERT INTO heb_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","ויצא קין מלפני יהוה וישב בארץ נוד קדמת עדן׃ ");
INSERT INTO heb_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","וידע קין את אשתו ותהר ותלד את חנוך ויהי בנה עיר ויקרא שם העיר כשם בנו חנוך׃ ");
INSERT INTO heb_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","ויולד לחנוך את עירד ועירד ילד את מחויאל ומחייאל ילד את מתושאל ומתושאל ילד את למך׃ ");
INSERT INTO heb_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","ויקח לו למך שתי נשים שם האחת עדה ושם השנית צלה׃ ");
INSERT INTO heb_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","ותלד עדה את יבל הוא היה אבי ישב אהל ומקנה׃ ");
INSERT INTO heb_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","ושם אחיו יובל הוא היה אבי כל תפש כנור ועוגב׃ ");
INSERT INTO heb_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","וצלה גם הוא ילדה את תובל קין לטש כל חרש נחשת וברזל ואחות תובל קין נעמה׃ ");
INSERT INTO heb_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","ויאמר למך לנשיו עדה וצלה שמען קולי נשי למך האזנה אמרתי כי איש הרגתי לפצעי וילד לחברתי׃ ");
INSERT INTO heb_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","כי שבעתים יקם קין ולמך שבעים ושבעה׃ ");
INSERT INTO heb_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","וידע אדם עוד את אשתו ותלד בן ותקרא את שמו שת כי שת לי אלהים זרע אחר תחת הבל כי הרגו קין׃ ");
INSERT INTO heb_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","ולשת גם הוא ילד בן ויקרא את שמו אנוש אז הוחל לקרא בשם יהוה׃ ");
INSERT INTO heb_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","זה ספר תולדת אדם ביום ברא אלהים אדם בדמות אלהים עשה אתו׃ ");
INSERT INTO heb_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","זכר ונקבה בראם ויברך אתם ויקרא את שמם אדם ביום הבראם׃ ");
INSERT INTO heb_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","ויחי אדם שלשים ומאת שנה ויולד בדמותו כצלמו ויקרא את שמו שת׃ ");
INSERT INTO heb_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","ויהיו ימי אדם אחרי הולידו את שת שמנה מאת שנה ויולד בנים ובנות׃ ");
INSERT INTO heb_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","ויהיו כל ימי אדם אשר חי תשע מאות שנה ושלשים שנה וימת׃ ");
INSERT INTO heb_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","ויחי שת חמש שנים ומאת שנה ויולד את אנוש׃ ");
INSERT INTO heb_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","ויחי שת אחרי הולידו את אנוש שבע שנים ושמנה מאות שנה ויולד בנים ובנות׃ ");
INSERT INTO heb_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","ויהיו כל ימי שת שתים עשרה שנה ותשע מאות שנה וימת׃ ");
INSERT INTO heb_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","ויחי אנוש תשעים שנה ויולד את קינן׃ ");
INSERT INTO heb_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","ויחי אנוש אחרי הולידו את קינן חמש עשרה שנה ושמנה מאות שנה ויולד בנים ובנות׃ ");
INSERT INTO heb_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","ויהיו כל ימי אנוש חמש שנים ותשע מאות שנה וימת׃ ");
INSERT INTO heb_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","ויחי קינן שבעים שנה ויולד את מהללאל׃ ");
INSERT INTO heb_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","ויחי קינן אחרי הולידו את מהללאל ארבעים שנה ושמנה מאות שנה ויולד בנים ובנות׃ ");
INSERT INTO heb_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","ויהיו כל ימי קינן עשר שנים ותשע מאות שנה וימת׃ ");
INSERT INTO heb_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","ויחי מהללאל חמש שנים וששים שנה ויולד את ירד׃ ");
INSERT INTO heb_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","ויחי מהללאל אחרי הולידו את ירד שלשים שנה ושמנה מאות שנה ויולד בנים ובנות׃ ");
INSERT INTO heb_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","ויהיו כל ימי מהללאל חמש ותשעים שנה ושמנה מאות שנה וימת׃ ");
INSERT INTO heb_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","ויחי ירד שתים וששים שנה ומאת שנה ויולד את חנוך׃ ");
INSERT INTO heb_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","ויחי ירד אחרי הולידו את חנוך שמנה מאות שנה ויולד בנים ובנות׃ ");
INSERT INTO heb_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","ויהיו כל ימי ירד שתים וששים שנה ותשע מאות שנה וימת׃ ");
INSERT INTO heb_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","ויחי חנוך חמש וששים שנה ויולד את מתושלח׃ ");
INSERT INTO heb_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","ויתהלך חנוך את האלהים אחרי הולידו את מתושלח שלש מאות שנה ויולד בנים ובנות׃ ");
INSERT INTO heb_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","ויהי כל ימי חנוך חמש וששים שנה ושלש מאות שנה׃ ");
INSERT INTO heb_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","ויתהלך חנוך את האלהים ואיננו כי לקח אתו אלהים׃ ");
INSERT INTO heb_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","ויחי מתושלח שבע ושמנים שנה ומאת שנה ויולד את למך׃ ");
INSERT INTO heb_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","ויחי מתושלח אחרי הולידו את למך שתים ושמונים שנה ושבע מאות שנה ויולד בנים ובנות׃ ");
INSERT INTO heb_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","ויהיו כל ימי מתושלח תשע וששים שנה ותשע מאות שנה וימת׃ ");
INSERT INTO heb_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","ויחי למך שתים ושמנים שנה ומאת שנה ויולד בן׃ ");
INSERT INTO heb_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","ויקרא את שמו נח לאמר זה ינחמנו ממעשנו ומעצבון ידינו מן האדמה אשר אררה יהוה׃ ");
INSERT INTO heb_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","ויחי למך אחרי הולידו את נח חמש ותשעים שנה וחמש מאת שנה ויולד בנים ובנות׃ ");
INSERT INTO heb_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","ויהי כל ימי למך שבע ושבעים שנה ושבע מאות שנה וימת׃ ");
INSERT INTO heb_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","ויהי נח בן חמש מאות שנה ויולד נח את שם את חם ואת יפת׃ ");
INSERT INTO heb_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","ויהי כי החל האדם לרב על פני האדמה ובנות ילדו להם׃ ");
INSERT INTO heb_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","ויראו בני האלהים את בנות האדם כי טבת הנה ויקחו להם נשים מכל אשר בחרו׃ ");
INSERT INTO heb_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","ויאמר יהוה לא ידון רוחי באדם לעלם בשגם הוא בשר והיו ימיו מאה ועשרים שנה׃ ");
INSERT INTO heb_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","הנפלים היו בארץ בימים ההם וגם אחרי כן אשר יבאו בני האלהים אל בנות האדם וילדו להם המה הגברים אשר מעולם אנשי השם׃ ");
INSERT INTO heb_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","וירא יהוה כי רבה רעת האדם בארץ וכל יצר מחשבת לבו רק רע כל היום׃ ");
INSERT INTO heb_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","וינחם יהוה כי עשה את האדם בארץ ויתעצב אל לבו׃ ");
INSERT INTO heb_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","ויאמר יהוה אמחה את האדם אשר בראתי מעל פני האדמה מאדם עד בהמה עד רמש ועד עוף השמים כי נחמתי כי עשיתם׃ ");
INSERT INTO heb_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","ונח מצא חן בעיני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","אלה תולדת נח נח איש צדיק תמים היה בדרתיו את האלהים התהלך נח׃ ");
INSERT INTO heb_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","ויולד נח שלשה בנים את שם את חם ואת יפת׃ ");
INSERT INTO heb_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","ותשחת הארץ לפני האלהים ותמלא הארץ חמס׃ ");
INSERT INTO heb_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","וירא אלהים את הארץ והנה נשחתה כי השחית כל בשר את דרכו על הארץ׃ ");
INSERT INTO heb_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","ויאמר אלהים לנח קץ כל בשר בא לפני כי מלאה הארץ חמס מפניהם והנני משחיתם את הארץ׃ ");
INSERT INTO heb_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","עשה לך תבת עצי גפר קנים תעשה את התבה וכפרת אתה מבית ומחוץ בכפר׃ ");
INSERT INTO heb_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","וזה אשר תעשה אתה שלש מאות אמה ארך התבה חמשים אמה רחבה ושלשים אמה קומתה׃ ");
INSERT INTO heb_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","צהר תעשה לתבה ואל אמה תכלנה מלמעלה ופתח התבה בצדה תשים תחתים שנים ושלשים תעשה׃ ");
INSERT INTO heb_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","ואני הנני מביא את המבול מים על הארץ לשחת כל בשר אשר בו רוח חיים מתחת השמים כל אשר בארץ יגוע׃ ");
INSERT INTO heb_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","והקמתי את בריתי אתך ובאת אל התבה אתה ובניך ואשתך ונשי בניך אתך׃ ");
INSERT INTO heb_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","ומכל החי מכל בשר שנים מכל תביא אל התבה להחית אתך זכר ונקבה יהיו׃ ");
INSERT INTO heb_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","מהעוף למינהו ומן הבהמה למינה מכל רמש האדמה למינהו שנים מכל יבאו אליך להחיות׃ ");
INSERT INTO heb_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","ואתה קח לך מכל מאכל אשר יאכל ואספת אליך והיה לך ולהם לאכלה׃ ");
INSERT INTO heb_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","ויעש נח ככל אשר צוה אתו אלהים כן עשה׃ ");
INSERT INTO heb_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","ויאמר יהוה לנח בא אתה וכל ביתך אל התבה כי אתך ראיתי צדיק לפני בדור הזה׃ ");
INSERT INTO heb_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","מכל הבהמה הטהורה תקח לך שבעה שבעה איש ואשתו ומן הבהמה אשר לא טהרה הוא שנים איש ואשתו׃ ");
INSERT INTO heb_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","גם מעוף השמים שבעה שבעה זכר ונקבה לחיות זרע על פני כל הארץ׃ ");
INSERT INTO heb_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","כי לימים עוד שבעה אנכי ממטיר על הארץ ארבעים יום וארבעים לילה ומחיתי את כל היקום אשר עשיתי מעל פני האדמה׃ ");
INSERT INTO heb_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","ויעש נח ככל אשר צוהו יהוה׃ ");
INSERT INTO heb_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","ונח בן שש מאות שנה והמבול היה מים על הארץ׃ ");
INSERT INTO heb_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","ויבא נח ובניו ואשתו ונשי בניו אתו אל התבה מפני מי המבול׃ ");
INSERT INTO heb_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","מן הבהמה הטהורה ומן הבהמה אשר איננה טהרה ומן העוף וכל אשר רמש על האדמה׃ ");
INSERT INTO heb_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","שנים שנים באו אל נח אל התבה זכר ונקבה כאשר צוה אלהים את נח׃ ");
INSERT INTO heb_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","ויהי לשבעת הימים ומי המבול היו על הארץ׃ ");
INSERT INTO heb_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","בשנת שש מאות שנה לחיי נח בחדש השני בשבעה עשר יום לחדש ביום הזה נבקעו כל מעינת תהום רבה וארבת השמים נפתחו׃ ");
INSERT INTO heb_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","ויהי הגשם על הארץ ארבעים יום וארבעים לילה׃ ");
INSERT INTO heb_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","בעצם היום הזה בא נח ושם וחם ויפת בני נח ואשת נח ושלשת נשי בניו אתם אל התבה׃ ");
INSERT INTO heb_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","המה וכל החיה למינה וכל הבהמה למינה וכל הרמש הרמש על הארץ למינהו וכל העוף למינהו כל צפור כל כנף׃ ");
INSERT INTO heb_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","ויבאו אל נח אל התבה שנים שנים מכל הבשר אשר בו רוח חיים׃ ");
INSERT INTO heb_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","והבאים זכר ונקבה מכל בשר באו כאשר צוה אתו אלהים ויסגר יהוה בעדו׃ ");
INSERT INTO heb_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","ויהי המבול ארבעים יום על הארץ וירבו המים וישאו את התבה ותרם מעל הארץ׃ ");
INSERT INTO heb_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","ויגברו המים וירבו מאד על הארץ ותלך התבה על פני המים׃ ");
INSERT INTO heb_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","והמים גברו מאד מאד על הארץ ויכסו כל ההרים הגבהים אשר תחת כל השמים׃ ");
INSERT INTO heb_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","חמש עשרה אמה מלמעלה גברו המים ויכסו ההרים׃ ");
INSERT INTO heb_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","ויגוע כל בשר הרמש על הארץ בעוף ובבהמה ובחיה ובכל השרץ השרץ על הארץ וכל האדם׃ ");
INSERT INTO heb_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","כל אשר נשמת רוח חיים באפיו מכל אשר בחרבה מתו׃ ");
INSERT INTO heb_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","וימח את כל היקום אשר על פני האדמה מאדם עד בהמה עד רמש ועד עוף השמים וימחו מן הארץ וישאר אך נח ואשר אתו בתבה׃ ");
INSERT INTO heb_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","ויגברו המים על הארץ חמשים ומאת יום׃ ");
INSERT INTO heb_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","ויזכר אלהים את נח ואת כל החיה ואת כל הבהמה אשר אתו בתבה ויעבר אלהים רוח על הארץ וישכו המים׃ ");
INSERT INTO heb_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","ויסכרו מעינת תהום וארבת השמים ויכלא הגשם מן השמים׃ ");
INSERT INTO heb_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","וישבו המים מעל הארץ הלוך ושוב ויחסרו המים מקצה חמשים ומאת יום׃ ");
INSERT INTO heb_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","ותנח התבה בחדש השביעי בשבעה עשר יום לחדש על הרי אררט׃ ");
INSERT INTO heb_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","והמים היו הלוך וחסור עד החדש העשירי בעשירי באחד לחדש נראו ראשי ההרים׃ ");
INSERT INTO heb_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","ויהי מקץ ארבעים יום ויפתח נח את חלון התבה אשר עשה׃ ");
INSERT INTO heb_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","וישלח את הערב ויצא יצוא ושוב עד יבשת המים מעל הארץ׃ ");
INSERT INTO heb_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","וישלח את היונה מאתו לראות הקלו המים מעל פני האדמה׃ ");
INSERT INTO heb_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","ולא מצאה היונה מנוח לכף רגלה ותשב אליו אל התבה כי מים על פני כל הארץ וישלח ידו ויקחה ויבא אתה אליו אל התבה׃ ");
INSERT INTO heb_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","ויחל עוד שבעת ימים אחרים ויסף שלח את היונה מן התבה׃ ");
INSERT INTO heb_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","ותבא אליו היונה לעת ערב והנה עלה זית טרף בפיה וידע נח כי קלו המים מעל הארץ׃ ");
INSERT INTO heb_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","וייחל עוד שבעת ימים אחרים וישלח את היונה ולא יספה שוב אליו עוד׃ ");
INSERT INTO heb_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","ויהי באחת ושש מאות שנה בראשון באחד לחדש חרבו המים מעל הארץ ויסר נח את מכסה התבה וירא והנה חרבו פני האדמה׃ ");
INSERT INTO heb_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","ובחדש השני בשבעה ועשרים יום לחדש יבשה הארץ׃ ");
INSERT INTO heb_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","וידבר אלהים אל נח לאמר׃ ");
INSERT INTO heb_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","צא מן התבה אתה ואשתך ובניך ונשי בניך אתך׃ ");
INSERT INTO heb_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","כל החיה אשר אתך מכל בשר בעוף ובבהמה ובכל הרמש הרמש על הארץ הוצא אתך ושרצו בארץ ופרו ורבו על הארץ׃ ");
INSERT INTO heb_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","ויצא נח ובניו ואשתו ונשי בניו אתו׃ ");
INSERT INTO heb_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","כל החיה כל הרמש וכל העוף כל רומש על הארץ למשפחתיהם יצאו מן התבה׃ ");
INSERT INTO heb_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","ויבן נח מזבח ליהוה ויקח מכל הבהמה הטהורה ומכל העוף הטהר ויעל עלת במזבח׃ ");
INSERT INTO heb_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","וירח יהוה את ריח הניחח ויאמר יהוה אל לבו לא אסף לקלל עוד את האדמה בעבור האדם כי יצר לב האדם רע מנעריו ולא אסף עוד להכות את כל חי כאשר עשיתי׃ ");
INSERT INTO heb_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","עד כל ימי הארץ זרע וקציר וקר וחם וקיץ וחרף ויום ולילה לא ישבתו׃ ");
INSERT INTO heb_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","ויברך אלהים את נח ואת בניו ויאמר להם פרו ורבו ומלאו את הארץ׃ ");
INSERT INTO heb_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","ומוראכם וחתכם יהיה על כל חית הארץ ועל כל עוף השמים בכל אשר תרמש האדמה ובכל דגי הים בידכם נתנו׃ ");
INSERT INTO heb_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","כל רמש אשר הוא חי לכם יהיה לאכלה כירק עשב נתתי לכם את כל׃ ");
INSERT INTO heb_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","אך בשר בנפשו דמו לא תאכלו׃ ");
INSERT INTO heb_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","ואך את דמכם לנפשתיכם אדרש מיד כל חיה אדרשנו ומיד האדם מיד איש אחיו אדרש את נפש האדם׃ ");
INSERT INTO heb_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","שפך דם האדם באדם דמו ישפך כי בצלם אלהים עשה את האדם׃ ");
INSERT INTO heb_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","ואתם פרו ורבו שרצו בארץ ורבו בה׃ ");
INSERT INTO heb_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","ויאמר אלהים אל נח ואל בניו אתו לאמר׃ ");
INSERT INTO heb_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","ואני הנני מקים את בריתי אתכם ואת זרעכם אחריכם׃ ");
INSERT INTO heb_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","ואת כל נפש החיה אשר אתכם בעוף בבהמה ובכל חית הארץ אתכם מכל יצאי התבה לכל חית הארץ׃ ");
INSERT INTO heb_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","והקמתי את בריתי אתכם ולא יכרת כל בשר עוד ממי המבול ולא יהיה עוד מבול לשחת הארץ׃ ");
INSERT INTO heb_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","ויאמר אלהים זאת אות הברית אשר אני נתן ביני וביניכם ובין כל נפש חיה אשר אתכם לדרת עולם׃ ");
INSERT INTO heb_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","את קשתי נתתי בענן והיתה לאות ברית ביני ובין הארץ׃ ");
INSERT INTO heb_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","והיה בענני ענן על הארץ ונראתה הקשת בענן׃ ");
INSERT INTO heb_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","וזכרתי את בריתי אשר ביני וביניכם ובין כל נפש חיה בכל בשר ולא יהיה עוד המים למבול לשחת כל בשר׃ ");
INSERT INTO heb_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","והיתה הקשת בענן וראיתיה לזכר ברית עולם בין אלהים ובין כל נפש חיה בכל בשר אשר על הארץ׃ ");
INSERT INTO heb_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","ויאמר אלהים אל נח זאת אות הברית אשר הקמתי ביני ובין כל בשר אשר על הארץ׃ ");
INSERT INTO heb_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","ויהיו בני נח היצאים מן התבה שם וחם ויפת וחם הוא אבי כנען׃ ");
INSERT INTO heb_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","שלשה אלה בני נח ומאלה נפצה כל הארץ׃ ");
INSERT INTO heb_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","ויחל נח איש האדמה ויטע כרם׃ ");
INSERT INTO heb_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","וישת מן היין וישכר ויתגל בתוך אהלה׃ ");
INSERT INTO heb_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","וירא חם אבי כנען את ערות אביו ויגד לשני אחיו בחוץ׃ ");
INSERT INTO heb_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","ויקח שם ויפת את השמלה וישימו על שכם שניהם וילכו אחרנית ויכסו את ערות אביהם ופניהם אחרנית וערות אביהם לא ראו׃ ");
INSERT INTO heb_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","וייקץ נח מיינו וידע את אשר עשה לו בנו הקטן׃ ");
INSERT INTO heb_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","ויאמר ארור כנען עבד עבדים יהיה לאחיו׃ ");
INSERT INTO heb_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","ויאמר ברוך יהוה אלהי שם ויהי כנען עבד למו׃ ");
INSERT INTO heb_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","יפת אלהים ליפת וישכן באהלי שם ויהי כנען עבד למו׃ ");
INSERT INTO heb_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","ויחי נח אחר המבול שלש מאות שנה וחמשים שנה׃ ");
INSERT INTO heb_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","ויהיו כל ימי נח תשע מאות שנה וחמשים שנה וימת׃ ");
INSERT INTO heb_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","ואלה תולדת בני נח שם חם ויפת ויולדו להם בנים אחר המבול׃ ");
INSERT INTO heb_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","בני יפת גמר ומגוג ומדי ויון ותבל ומשך ותירס׃ ");
INSERT INTO heb_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","ובני גמר אשכנז וריפת ותגרמה׃ ");
INSERT INTO heb_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","ובני יון אלישה ותרשיש כתים ודדנים׃ ");
INSERT INTO heb_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","מאלה נפרדו איי הגוים בארצתם איש ללשנו למשפחתם בגויהם׃ ");
INSERT INTO heb_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","ובני חם כוש ומצרים ופוט וכנען׃ ");
INSERT INTO heb_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","ובני כוש סבא וחוילה וסבתה ורעמה וסבתכא ובני רעמה שבא ודדן׃ ");
INSERT INTO heb_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","וכוש ילד את נמרד הוא החל להיות גבר בארץ׃ ");
INSERT INTO heb_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","הוא היה גבר ציד לפני יהוה על כן יאמר כנמרד גבור ציד לפני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","ותהי ראשית ממלכתו בבל וארך ואכד וכלנה בארץ שנער׃ ");
INSERT INTO heb_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","מן הארץ ההוא יצא אשור ויבן את נינוה ואת רחבת עיר ואת כלח׃ ");
INSERT INTO heb_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","ואת רסן בין נינוה ובין כלח הוא העיר הגדלה׃ ");
INSERT INTO heb_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","ומצרים ילד את לודים ואת ענמים ואת להבים ואת נפתחים׃ ");
INSERT INTO heb_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","ואת פתרסים ואת כסלחים אשר יצאו משם פלשתים ואת כפתרים׃ ");
INSERT INTO heb_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","וכנען ילד את צידן בכרו ואת חת׃ ");
INSERT INTO heb_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","ואת היבוסי ואת האמרי ואת הגרגשי׃ ");
INSERT INTO heb_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","ואת החוי ואת הערקי ואת הסיני׃ ");
INSERT INTO heb_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","ואת הארודי ואת הצמרי ואת החמתי ואחר נפצו משפחות הכנעני׃ ");
INSERT INTO heb_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","ויהי גבול הכנעני מצידן באכה גררה עד עזה באכה סדמה ועמרה ואדמה וצבים עד לשע׃ ");
INSERT INTO heb_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","אלה בני חם למשפחתם ללשנתם בארצתם בגויהם׃ ");
INSERT INTO heb_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","ולשם ילד גם הוא אבי כל בני עבר אחי יפת הגדול׃ ");
INSERT INTO heb_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","בני שם עילם ואשור וארפכשד ולוד וארם׃ ");
INSERT INTO heb_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","ובני ארם עוץ וחול וגתר ומש׃ ");
INSERT INTO heb_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","וארפכשד ילד את שלח ושלח ילד את עבר׃ ");
INSERT INTO heb_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","ולעבר ילד שני בנים שם האחד פלג כי בימיו נפלגה הארץ ושם אחיו יקטן׃ ");
INSERT INTO heb_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","ויקטן ילד את אלמודד ואת שלף ואת חצרמות ואת ירח׃ ");
INSERT INTO heb_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","ואת הדורם ואת אוזל ואת דקלה׃ ");
INSERT INTO heb_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","ואת עובל ואת אבימאל ואת שבא׃ ");
INSERT INTO heb_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ואת אופר ואת חוילה ואת יובב כל אלה בני יקטן׃ ");
INSERT INTO heb_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","ויהי מושבם ממשא באכה ספרה הר הקדם׃ ");
INSERT INTO heb_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","אלה בני שם למשפחתם ללשנתם בארצתם לגויהם׃ ");
INSERT INTO heb_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","אלה משפחת בני נח לתולדתם בגויהם ומאלה נפרדו הגוים בארץ אחר המבול׃ ");
INSERT INTO heb_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","ויהי כל הארץ שפה אחת ודברים אחדים׃ ");
INSERT INTO heb_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","ויהי בנסעם מקדם וימצאו בקעה בארץ שנער וישבו שם׃ ");
INSERT INTO heb_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","ויאמרו איש אל רעהו הבה נלבנה לבנים ונשרפה לשרפה ותהי להם הלבנה לאבן והחמר היה להם לחמר׃ ");
INSERT INTO heb_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","ויאמרו הבה נבנה לנו עיר ומגדל וראשו בשמים ונעשה לנו שם פן נפוץ על פני כל הארץ׃ ");
INSERT INTO heb_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","וירד יהוה לראת את העיר ואת המגדל אשר בנו בני האדם׃ ");
INSERT INTO heb_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","ויאמר יהוה הן עם אחד ושפה אחת לכלם וזה החלם לעשות ועתה לא יבצר מהם כל אשר יזמו לעשות׃ ");
INSERT INTO heb_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","הבה נרדה ונבלה שם שפתם אשר לא ישמעו איש שפת רעהו׃ ");
INSERT INTO heb_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","ויפץ יהוה אתם משם על פני כל הארץ ויחדלו לבנת העיר׃ ");
INSERT INTO heb_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","על כן קרא שמה בבל כי שם בלל יהוה שפת כל הארץ ומשם הפיצם יהוה על פני כל הארץ׃ ");
INSERT INTO heb_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","אלה תולדת שם שם בן מאת שנה ויולד את ארפכשד שנתים אחר המבול׃ ");
INSERT INTO heb_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","ויחי שם אחרי הולידו את ארפכשד חמש מאות שנה ויולד בנים ובנות׃ ");
INSERT INTO heb_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","וארפכשד חי חמש ושלשים שנה ויולד את שלח׃ ");
INSERT INTO heb_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","ויחי ארפכשד אחרי הולידו את שלח שלש שנים וארבע מאות שנה ויולד בנים ובנות׃ ");
INSERT INTO heb_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","ושלח חי שלשים שנה ויולד את עבר׃ ");
INSERT INTO heb_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","ויחי שלח אחרי הולידו את עבר שלש שנים וארבע מאות שנה ויולד בנים ובנות׃ ");
INSERT INTO heb_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","ויחי עבר ארבע ושלשים שנה ויולד את פלג׃ ");
INSERT INTO heb_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","ויחי עבר אחרי הולידו את פלג שלשים שנה וארבע מאות שנה ויולד בנים ובנות׃ ");
INSERT INTO heb_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","ויחי פלג שלשים שנה ויולד את רעו׃ ");
INSERT INTO heb_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","ויחי פלג אחרי הולידו את רעו תשע שנים ומאתים שנה ויולד בנים ובנות׃ ");
INSERT INTO heb_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","ויחי רעו שתים ושלשים שנה ויולד את שרוג׃ ");
INSERT INTO heb_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","ויחי רעו אחרי הולידו את שרוג שבע שנים ומאתים שנה ויולד בנים ובנות׃ ");
INSERT INTO heb_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","ויחי שרוג שלשים שנה ויולד את נחור׃ ");
INSERT INTO heb_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","ויחי שרוג אחרי הולידו את נחור מאתים שנה ויולד בנים ובנות׃ ");
INSERT INTO heb_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","ויחי נחור תשע ועשרים שנה ויולד את תרח׃ ");
INSERT INTO heb_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","ויחי נחור אחרי הולידו את תרח תשע עשרה שנה ומאת שנה ויולד בנים ובנות׃ ");
INSERT INTO heb_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","ויחי תרח שבעים שנה ויולד את אברם את נחור ואת הרן׃ ");
INSERT INTO heb_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","ואלה תולדת תרח תרח הוליד את אברם את נחור ואת הרן והרן הוליד את לוט׃ ");
INSERT INTO heb_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","וימת הרן על פני תרח אביו בארץ מולדתו באור כשדים׃ ");
INSERT INTO heb_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","ויקח אברם ונחור להם נשים שם אשת אברם שרי ושם אשת נחור מלכה בת הרן אבי מלכה ואבי יסכה׃ ");
INSERT INTO heb_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","ותהי שרי עקרה אין לה ולד׃ ");
INSERT INTO heb_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","ויקח תרח את אברם בנו ואת לוט בן הרן בן בנו ואת שרי כלתו אשת אברם בנו ויצאו אתם מאור כשדים ללכת ארצה כנען ויבאו עד חרן וישבו שם׃ ");
INSERT INTO heb_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","ויהיו ימי תרח חמש שנים ומאתים שנה וימת תרח בחרן׃ ");
INSERT INTO heb_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","ויאמר יהוה אל אברם לך לך מארצך וממולדתך ומבית אביך אל הארץ אשר אראך׃ ");
INSERT INTO heb_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","ואעשך לגוי גדול ואברכך ואגדלה שמך והיה ברכה׃ ");
INSERT INTO heb_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","ואברכה מברכיך ומקללך אאר ונברכו בך כל משפחת האדמה׃ ");
INSERT INTO heb_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","וילך אברם כאשר דבר אליו יהוה וילך אתו לוט ואברם בן חמש שנים ושבעים שנה בצאתו מחרן׃ ");
INSERT INTO heb_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","ויקח אברם את שרי אשתו ואת לוט בן אחיו ואת כל רכושם אשר רכשו ואת הנפש אשר עשו בחרן ויצאו ללכת ארצה כנען ויבאו ארצה כנען׃ ");
INSERT INTO heb_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","ויעבר אברם בארץ עד מקום שכם עד אלון מורה והכנעני אז בארץ׃ ");
INSERT INTO heb_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","וירא יהוה אל אברם ויאמר לזרעך אתן את הארץ הזאת ויבן שם מזבח ליהוה הנראה אליו׃ ");
INSERT INTO heb_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","ויעתק משם ההרה מקדם לבית אל ויט אהלה בית אל מים והעי מקדם ויבן שם מזבח ליהוה ויקרא בשם יהוה׃ ");
INSERT INTO heb_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","ויסע אברם הלוך ונסוע הנגבה׃ ");
INSERT INTO heb_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","ויהי רעב בארץ וירד אברם מצרימה לגור שם כי כבד הרעב בארץ׃ ");
INSERT INTO heb_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","ויהי כאשר הקריב לבוא מצרימה ויאמר אל שרי אשתו הנה נא ידעתי כי אשה יפת מראה את׃ ");
INSERT INTO heb_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","והיה כי יראו אתך המצרים ואמרו אשתו זאת והרגו אתי ואתך יחיו׃ ");
INSERT INTO heb_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","אמרי נא אחתי את למען ייטב לי בעבורך וחיתה נפשי בגללך׃ ");
INSERT INTO heb_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","ויהי כבוא אברם מצרימה ויראו המצרים את האשה כי יפה הוא מאד׃ ");
INSERT INTO heb_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","ויראו אתה שרי פרעה ויהללו אתה אל פרעה ותקח האשה בית פרעה׃ ");
INSERT INTO heb_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","ולאברם היטיב בעבורה ויהי לו צאן ובקר וחמרים ועבדים ושפחת ואתנת וגמלים׃ ");
INSERT INTO heb_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","וינגע יהוה את פרעה נגעים גדלים ואת ביתו על דבר שרי אשת אברם׃ ");
INSERT INTO heb_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","ויקרא פרעה לאברם ויאמר מה זאת עשית לי למה לא הגדת לי כי אשתך הוא׃ ");
INSERT INTO heb_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","למה אמרת אחתי הוא ואקח אתה לי לאשה ועתה הנה אשתך קח ולך׃ ");
INSERT INTO heb_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","ויצו עליו פרעה אנשים וישלחו אתו ואת אשתו ואת כל אשר לו׃ ");
INSERT INTO heb_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","ויעל אברם ממצרים הוא ואשתו וכל אשר לו ולוט עמו הנגבה׃ ");
INSERT INTO heb_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","ואברם כבד מאד במקנה בכסף ובזהב׃ ");
INSERT INTO heb_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","וילך למסעיו מנגב ועד בית אל עד המקום אשר היה שם אהלה בתחלה בין בית אל ובין העי׃ ");
INSERT INTO heb_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","אל מקום המזבח אשר עשה שם בראשנה ויקרא שם אברם בשם יהוה׃ ");
INSERT INTO heb_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","וגם ללוט ההלך את אברם היה צאן ובקר ואהלים׃ ");
INSERT INTO heb_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","ולא נשא אתם הארץ לשבת יחדו כי היה רכושם רב ולא יכלו לשבת יחדו׃ ");
INSERT INTO heb_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","ויהי ריב בין רעי מקנה אברם ובין רעי מקנה לוט והכנעני והפרזי אז ישב בארץ׃ ");
INSERT INTO heb_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","ויאמר אברם אל לוט אל נא תהי מריבה ביני וביניך ובין רעי ובין רעיך כי אנשים אחים אנחנו׃ ");
INSERT INTO heb_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","הלא כל הארץ לפניך הפרד נא מעלי אם השמאל ואימנה ואם הימין ואשמאילה׃ ");
INSERT INTO heb_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","וישא לוט את עיניו וירא את כל ככר הירדן כי כלה משקה לפני שחת יהוה את סדם ואת עמרה כגן יהוה כארץ מצרים באכה צער׃ ");
INSERT INTO heb_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","ויבחר לו לוט את כל ככר הירדן ויסע לוט מקדם ויפרדו איש מעל אחיו׃ ");
INSERT INTO heb_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","אברם ישב בארץ כנען ולוט ישב בערי הככר ויאהל עד סדם׃ ");
INSERT INTO heb_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","ואנשי סדם רעים וחטאים ליהוה מאד׃ ");
INSERT INTO heb_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","ויהוה אמר אל אברם אחרי הפרד לוט מעמו שא נא עיניך וראה מן המקום אשר אתה שם צפנה ונגבה וקדמה וימה׃ ");
INSERT INTO heb_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","כי את כל הארץ אשר אתה ראה לך אתננה ולזרעך עד עולם׃ ");
INSERT INTO heb_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","ושמתי את זרעך כעפר הארץ אשר אם יוכל איש למנות את עפר הארץ גם זרעך ימנה׃ ");
INSERT INTO heb_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","קום התהלך בארץ לארכה ולרחבה כי לך אתננה׃ ");
INSERT INTO heb_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","ויאהל אברם ויבא וישב באלני ממרא אשר בחברון ויבן שם מזבח ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","ויהי בימי אמרפל מלך שנער אריוך מלך אלסר כדרלעמר מלך עילם ותדעל מלך גוים׃ ");
INSERT INTO heb_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","עשו מלחמה את ברע מלך סדם ואת ברשע מלך עמרה שנאב מלך אדמה ושמאבר מלך צביים ומלך בלע היא צער׃ ");
INSERT INTO heb_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","כל אלה חברו אל עמק השדים הוא ים המלח׃ ");
INSERT INTO heb_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","שתים עשרה שנה עבדו את כדרלעמר ושלש עשרה שנה מרדו׃ ");
INSERT INTO heb_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","ובארבע עשרה שנה בא כדרלעמר והמלכים אשר אתו ויכו את רפאים בעשתרת קרנים ואת הזוזים בהם ואת האימים בשוה קריתים׃ ");
INSERT INTO heb_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","ואת החרי בהררם שעיר עד איל פארן אשר על המדבר׃ ");
INSERT INTO heb_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","וישבו ויבאו אל עין משפט הוא קדש ויכו את כל שדה העמלקי וגם את האמרי הישב בחצצן תמר׃ ");
INSERT INTO heb_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","ויצא מלך סדם ומלך עמרה ומלך אדמה ומלך צביים ומלך בלע הוא צער ויערכו אתם מלחמה בעמק השדים׃ ");
INSERT INTO heb_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","את כדרלעמר מלך עילם ותדעל מלך גוים ואמרפל מלך שנער ואריוך מלך אלסר ארבעה מלכים את החמשה׃ ");
INSERT INTO heb_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","ועמק השדים בארת בארת חמר וינסו מלך סדם ועמרה ויפלו שמה והנשארים הרה נסו׃ ");
INSERT INTO heb_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","ויקחו את כל רכש סדם ועמרה ואת כל אכלם וילכו׃ ");
INSERT INTO heb_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","ויקחו את לוט ואת רכשו בן אחי אברם וילכו והוא ישב בסדם׃ ");
INSERT INTO heb_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","ויבא הפליט ויגד לאברם העברי והוא שכן באלני ממרא האמרי אחי אשכל ואחי ענר והם בעלי ברית אברם׃ ");
INSERT INTO heb_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","וישמע אברם כי נשבה אחיו וירק את חניכיו ילידי ביתו שמנה עשר ושלש מאות וירדף עד דן׃ ");
INSERT INTO heb_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","ויחלק עליהם לילה הוא ועבדיו ויכם וירדפם עד חובה אשר משמאל לדמשק׃ ");
INSERT INTO heb_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","וישב את כל הרכש וגם את לוט אחיו ורכשו השיב וגם את הנשים ואת העם׃ ");
INSERT INTO heb_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","ויצא מלך סדם לקראתו אחרי שובו מהכות את כדר לעמר ואת המלכים אשר אתו אל עמק שוה הוא עמק המלך׃ ");
INSERT INTO heb_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","ומלכי צדק מלך שלם הוציא לחם ויין והוא כהן לאל עליון׃ ");
INSERT INTO heb_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","ויברכהו ויאמר ברוך אברם לאל עליון קנה שמים וארץ׃ ");
INSERT INTO heb_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","וברוך אל עליון אשר מגן צריך בידך ויתן לו מעשר מכל׃ ");
INSERT INTO heb_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","ויאמר מלך סדם אל אברם תן לי הנפש והרכש קח לך׃ ");
INSERT INTO heb_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","ויאמר אברם אל מלך סדם הרימתי ידי אל יהוה אל עליון קנה שמים וארץ׃ ");
INSERT INTO heb_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","אם מחוט ועד שרוך נעל ואם אקח מכל אשר לך ולא תאמר אני העשרתי את אברם׃ ");
INSERT INTO heb_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","בלעדי רק אשר אכלו הנערים וחלק האנשים אשר הלכו אתי ענר אשכל וממרא הם יקחו חלקם׃ ");
INSERT INTO heb_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","אחר הדברים האלה היה דבר יהוה אל אברם במחזה לאמר אל תירא אברם אנכי מגן לך שכרך הרבה מאד׃ ");
INSERT INTO heb_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","ויאמר אברם אדני יהוה מה תתן לי ואנכי הולך ערירי ובן משק ביתי הוא דמשק אליעזר׃ ");
INSERT INTO heb_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","ויאמר אברם הן לי לא נתתה זרע והנה בן ביתי יורש אתי׃ ");
INSERT INTO heb_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","והנה דבר יהוה אליו לאמר לא יירשך זה כי אם אשר יצא ממעיך הוא יירשך׃ ");
INSERT INTO heb_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","ויוצא אתו החוצה ויאמר הבט נא השמימה וספר הכוכבים אם תוכל לספר אתם ויאמר לו כה יהיה זרעך׃ ");
INSERT INTO heb_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","והאמן ביהוה ויחשבה לו צדקה׃ ");
INSERT INTO heb_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","ויאמר אליו אני יהוה אשר הוצאתיך מאור כשדים לתת לך את הארץ הזאת לרשתה׃ ");
INSERT INTO heb_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","ויאמר אדני יהוה במה אדע כי אירשנה׃ ");
INSERT INTO heb_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","ויאמר אליו קחה לי עגלה משלשת ועז משלשת ואיל משלש ותר וגוזל׃ ");
INSERT INTO heb_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","ויקח לו את כל אלה ויבתר אתם בתוך ויתן איש בתרו לקראת רעהו ואת הצפר לא בתר׃ ");
INSERT INTO heb_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","וירד העיט על הפגרים וישב אתם אברם׃ ");
INSERT INTO heb_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","ויהי השמש לבוא ותרדמה נפלה על אברם והנה אימה חשכה גדלה נפלת עליו׃ ");
INSERT INTO heb_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","ויאמר לאברם ידע תדע כי גר יהיה זרעך בארץ לא להם ועבדום וענו אתם ארבע מאות שנה׃ ");
INSERT INTO heb_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","וגם את הגוי אשר יעבדו דן אנכי ואחרי כן יצאו ברכש גדול׃ ");
INSERT INTO heb_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","ואתה תבוא אל אבתיך בשלום תקבר בשיבה טובה׃ ");
INSERT INTO heb_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","ודור רביעי ישובו הנה כי לא שלם עון האמרי עד הנה׃ ");
INSERT INTO heb_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","ויהי השמש באה ועלטה היה והנה תנור עשן ולפיד אש אשר עבר בין הגזרים האלה׃ ");
INSERT INTO heb_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","ביום ההוא כרת יהוה את אברם ברית לאמר לזרעך נתתי את הארץ הזאת מנהר מצרים עד הנהר הגדל נהר פרת׃ ");
INSERT INTO heb_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","את הקיני ואת הקנזי ואת הקדמני׃ ");
INSERT INTO heb_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","ואת החתי ואת הפרזי ואת הרפאים׃ ");
INSERT INTO heb_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","ואת האמרי ואת הכנעני ואת הגרגשי ואת היבוסי׃ ");
INSERT INTO heb_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","ושרי אשת אברם לא ילדה לו ולה שפחה מצרית ושמה הגר׃ ");
INSERT INTO heb_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","ותאמר שרי אל אברם הנה נא עצרני יהוה מלדת בא נא אל שפחתי אולי אבנה ממנה וישמע אברם לקול שרי׃ ");
INSERT INTO heb_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","ותקח שרי אשת אברם את הגר המצרית שפחתה מקץ עשר שנים לשבת אברם בארץ כנען ותתן אתה לאברם אישה לו לאשה׃ ");
INSERT INTO heb_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","ויבא אל הגר ותהר ותרא כי הרתה ותקל גברתה בעיניה׃ ");
INSERT INTO heb_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","ותאמר שרי אל אברם חמסי עליך אנכי נתתי שפחתי בחיקך ותרא כי הרתה ואקל בעיניה ישפט יהוה ביני וביניך׃ ");
INSERT INTO heb_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","ויאמר אברם אל שרי הנה שפחתך בידך עשי לה הטוב בעיניך ותענה שרי ותברח מפניה׃ ");
INSERT INTO heb_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","וימצאה מלאך יהוה על עין המים במדבר על העין בדרך שור׃ ");
INSERT INTO heb_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","ויאמר הגר שפחת שרי אי מזה באת ואנה תלכי ותאמר מפני שרי גברתי אנכי ברחת׃ ");
INSERT INTO heb_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","ויאמר לה מלאך יהוה שובי אל גברתך והתעני תחת ידיה׃ ");
INSERT INTO heb_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","ויאמר לה מלאך יהוה הרבה ארבה את זרעך ולא יספר מרב׃ ");
INSERT INTO heb_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","ויאמר לה מלאך יהוה הנך הרה וילדת בן וקראת שמו ישמעאל כי שמע יהוה אל עניך׃ ");
INSERT INTO heb_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","והוא יהיה פרא אדם ידו בכל ויד כל בו ועל פני כל אחיו ישכן׃ ");
INSERT INTO heb_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","ותקרא שם יהוה הדבר אליה אתה אל ראי כי אמרה הגם הלם ראיתי אחרי ראי׃ ");
INSERT INTO heb_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","על כן קרא לבאר באר לחי ראי הנה בין קדש ובין ברד׃ ");
INSERT INTO heb_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","ותלד הגר לאברם בן ויקרא אברם שם בנו אשר ילדה הגר ישמעאל׃ ");
INSERT INTO heb_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","ואברם בן שמנים שנה ושש שנים בלדת הגר את ישמעאל לאברם׃ ");
INSERT INTO heb_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","ויהי אברם בן תשעים שנה ותשע שנים וירא יהוה אל אברם ויאמר אליו אני אל שדי התהלך לפני והיה תמים׃ ");
INSERT INTO heb_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","ואתנה בריתי ביני ובינך וארבה אותך במאד מאד׃ ");
INSERT INTO heb_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","ויפל אברם על פניו וידבר אתו אלהים לאמר׃ ");
INSERT INTO heb_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","אני הנה בריתי אתך והיית לאב המון גוים׃ ");
INSERT INTO heb_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","ולא יקרא עוד את שמך אברם והיה שמך אברהם כי אב המון גוים נתתיך׃ ");
INSERT INTO heb_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","והפרתי אתך במאד מאד ונתתיך לגוים ומלכים ממך יצאו׃ ");
INSERT INTO heb_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","והקמתי את בריתי ביני ובינך ובין זרעך אחריך לדרתם לברית עולם להיות לך לאלהים ולזרעך אחריך׃ ");
INSERT INTO heb_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","ונתתי לך ולזרעך אחריך את ארץ מגריך את כל ארץ כנען לאחזת עולם והייתי להם לאלהים׃ ");
INSERT INTO heb_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","ויאמר אלהים אל אברהם ואתה את בריתי תשמר אתה וזרעך אחריך לדרתם׃ ");
INSERT INTO heb_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","זאת בריתי אשר תשמרו ביני וביניכם ובין זרעך אחריך המול לכם כל זכר׃ ");
INSERT INTO heb_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","ונמלתם את בשר ערלתכם והיה לאות ברית ביני וביניכם׃ ");
INSERT INTO heb_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","ובן שמנת ימים ימול לכם כל זכר לדרתיכם יליד בית ומקנת כסף מכל בן נכר אשר לא מזרעך הוא׃ ");
INSERT INTO heb_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","המול ימול יליד ביתך ומקנת כספך והיתה בריתי בבשרכם לברית עולם׃ ");
INSERT INTO heb_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","וערל זכר אשר לא ימול את בשר ערלתו ונכרתה הנפש ההוא מעמיה את בריתי הפר׃ ");
INSERT INTO heb_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","ויאמר אלהים אל אברהם שרי אשתך לא תקרא את שמה שרי כי שרה שמה׃ ");
INSERT INTO heb_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","וברכתי אתה וגם נתתי ממנה לך בן וברכתיה והיתה לגוים מלכי עמים ממנה יהיו׃ ");
INSERT INTO heb_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","ויפל אברהם על פניו ויצחק ויאמר בלבו הלבן מאה שנה יולד ואם שרה הבת תשעים שנה תלד׃ ");
INSERT INTO heb_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","ויאמר אברהם אל האלהים לו ישמעאל יחיה לפניך׃ ");
INSERT INTO heb_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","ויאמר אלהים אבל שרה אשתך ילדת לך בן וקראת את שמו יצחק והקמתי את בריתי אתו לברית עולם לזרעו אחריו׃ ");
INSERT INTO heb_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","ולישמעאל שמעתיך הנה ברכתי אתו והפריתי אתו והרביתי אתו במאד מאד שנים עשר נשיאם יוליד ונתתיו לגוי גדול׃ ");
INSERT INTO heb_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","ואת בריתי אקים את יצחק אשר תלד לך שרה למועד הזה בשנה האחרת׃ ");
INSERT INTO heb_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","ויכל לדבר אתו ויעל אלהים מעל אברהם׃ ");
INSERT INTO heb_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","ויקח אברהם את ישמעאל בנו ואת כל ילידי ביתו ואת כל מקנת כספו כל זכר באנשי בית אברהם וימל את בשר ערלתם בעצם היום הזה כאשר דבר אתו אלהים׃ ");
INSERT INTO heb_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","ואברהם בן תשעים ותשע שנה בהמלו בשר ערלתו׃ ");
INSERT INTO heb_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","וישמעאל בנו בן שלש עשרה שנה בהמלו את בשר ערלתו׃ ");
INSERT INTO heb_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","בעצם היום הזה נמול אברהם וישמעאל בנו׃ ");
INSERT INTO heb_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","וכל אנשי ביתו יליד בית ומקנת כסף מאת בן נכר נמלו אתו׃ ");
INSERT INTO heb_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","וירא אליו יהוה באלני ממרא והוא ישב פתח האהל כחם היום׃ ");
INSERT INTO heb_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","וישא עיניו וירא והנה שלשה אנשים נצבים עליו וירא וירץ לקראתם מפתח האהל וישתחו ארצה׃ ");
INSERT INTO heb_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","ויאמר אדני אם נא מצאתי חן בעיניך אל נא תעבר מעל עבדך׃ ");
INSERT INTO heb_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","יקח נא מעט מים ורחצו רגליכם והשענו תחת העץ׃ ");
INSERT INTO heb_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","ואקחה פת לחם וסעדו לבכם אחר תעברו כי על כן עברתם על עבדכם ויאמרו כן תעשה כאשר דברת׃ ");
INSERT INTO heb_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","וימהר אברהם האהלה אל שרה ויאמר מהרי שלש סאים קמח סלת לושי ועשי עגות׃ ");
INSERT INTO heb_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","ואל הבקר רץ אברהם ויקח בן בקר רך וטוב ויתן אל הנער וימהר לעשות אתו׃ ");
INSERT INTO heb_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","ויקח חמאה וחלב ובן הבקר אשר עשה ויתן לפניהם והוא עמד עליהם תחת העץ ויאכלו׃ ");
INSERT INTO heb_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","ויאמרו אליו איה שרה אשתך ויאמר הנה באהל׃ ");
INSERT INTO heb_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","ויאמר שוב אשוב אליך כעת חיה והנה בן לשרה אשתך ושרה שמעת פתח האהל והוא אחריו׃ ");
INSERT INTO heb_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","ואברהם ושרה זקנים באים בימים חדל להיות לשרה ארח כנשים׃ ");
INSERT INTO heb_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","ותצחק שרה בקרבה לאמר אחרי בלתי היתה לי עדנה ואדני זקן׃ ");
INSERT INTO heb_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","ויאמר יהוה אל אברהם למה זה צחקה שרה לאמר האף אמנם אלד ואני זקנתי׃ ");
INSERT INTO heb_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","היפלא מיהוה דבר למועד אשוב אליך כעת חיה ולשרה בן׃ ");
INSERT INTO heb_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","ותכחש שרה לאמר לא צחקתי כי יראה ויאמר לא כי צחקת׃ ");
INSERT INTO heb_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","ויקמו משם האנשים וישקפו על פני סדם ואברהם הלך עמם לשלחם׃ ");
INSERT INTO heb_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","ויהוה אמר המכסה אני מאברהם אשר אני עשה׃ ");
INSERT INTO heb_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","ואברהם היו יהיה לגוי גדול ועצום ונברכו בו כל גויי הארץ׃ ");
INSERT INTO heb_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","כי ידעתיו למען אשר יצוה את בניו ואת ביתו אחריו ושמרו דרך יהוה לעשות צדקה ומשפט למען הביא יהוה על אברהם את אשר דבר עליו׃ ");
INSERT INTO heb_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","ויאמר יהוה זעקת סדם ועמרה כי רבה וחטאתם כי כבדה מאד׃ ");
INSERT INTO heb_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","ארדה נא ואראה הכצעקתה הבאה אלי עשו כלה ואם לא אדעה׃ ");
INSERT INTO heb_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","ויפנו משם האנשים וילכו סדמה ואברהם עודנו עמד לפני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","ויגש אברהם ויאמר האף תספה צדיק עם רשע׃ ");
INSERT INTO heb_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","אולי יש חמשים צדיקם בתוך העיר האף תספה ולא תשא למקום למען חמשים הצדיקם אשר בקרבה׃ ");
INSERT INTO heb_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","חללה לך מעשת כדבר הזה להמית צדיק עם רשע והיה כצדיק כרשע חללה לך השפט כל הארץ לא יעשה משפט׃ ");
INSERT INTO heb_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","ויאמר יהוה אם אמצא בסדם חמשים צדיקם בתוך העיר ונשאתי לכל המקום בעבורם׃ ");
INSERT INTO heb_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","ויען אברהם ויאמר הנה נא הואלתי לדבר אל אדני ואנכי עפר ואפר׃ ");
INSERT INTO heb_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","אולי יחסרון חמשים הצדיקם חמשה התשחית בחמשה את כל העיר ויאמר לא אשחית אם אמצא שם ארבעים וחמשה׃ ");
INSERT INTO heb_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","ויסף עוד לדבר אליו ויאמר אולי ימצאון שם ארבעים ויאמר לא אעשה בעבור הארבעים׃ ");
INSERT INTO heb_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","ויאמר אל נא יחר לאדני ואדברה אולי ימצאון שם שלשים ויאמר לא אעשה אם אמצא שם שלשים׃ ");
INSERT INTO heb_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","ויאמר הנה נא הואלתי לדבר אל אדני אולי ימצאון שם עשרים ויאמר לא אשחית בעבור העשרים׃ ");
INSERT INTO heb_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","ויאמר אל נא יחר לאדני ואדברה אך הפעם אולי ימצאון שם עשרה ויאמר לא אשחית בעבור העשרה׃ ");
INSERT INTO heb_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","וילך יהוה כאשר כלה לדבר אל אברהם ואברהם שב למקמו׃ ");
INSERT INTO heb_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","ויבאו שני המלאכים סדמה בערב ולוט ישב בשער סדם וירא לוט ויקם לקראתם וישתחו אפים ארצה׃ ");
INSERT INTO heb_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","ויאמר הנה נא אדני סורו נא אל בית עבדכם ולינו ורחצו רגליכם והשכמתם והלכתם לדרככם ויאמרו לא כי ברחוב נלין׃ ");
INSERT INTO heb_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","ויפצר בם מאד ויסרו אליו ויבאו אל ביתו ויעש להם משתה ומצות אפה ויאכלו׃ ");
INSERT INTO heb_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","טרם ישכבו ואנשי העיר אנשי סדם נסבו על הבית מנער ועד זקן כל העם מקצה׃ ");
INSERT INTO heb_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","ויקראו אל לוט ויאמרו לו איה האנשים אשר באו אליך הלילה הוציאם אלינו ונדעה אתם׃ ");
INSERT INTO heb_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","ויצא אלהם לוט הפתחה והדלת סגר אחריו׃ ");
INSERT INTO heb_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","ויאמר אל נא אחי תרעו׃ ");
INSERT INTO heb_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","הנה נא לי שתי בנות אשר לא ידעו איש אוציאה נא אתהן אליכם ועשו להן כטוב בעיניכם רק לאנשים האל אל תעשו דבר כי על כן באו בצל קרתי׃ ");
INSERT INTO heb_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","ויאמרו גש הלאה ויאמרו האחד בא לגור וישפט שפוט עתה נרע לך מהם ויפצרו באיש בלוט מאד ויגשו לשבר הדלת׃ ");
INSERT INTO heb_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","וישלחו האנשים את ידם ויביאו את לוט אליהם הביתה ואת הדלת סגרו׃ ");
INSERT INTO heb_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","ואת האנשים אשר פתח הבית הכו בסנורים מקטן ועד גדול וילאו למצא הפתח׃ ");
INSERT INTO heb_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","ויאמרו האנשים אל לוט עד מי לך פה חתן ובניך ובנתיך וכל אשר לך בעיר הוצא מן המקום׃ ");
INSERT INTO heb_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","כי משחתים אנחנו את המקום הזה כי גדלה צעקתם את פני יהוה וישלחנו יהוה לשחתה׃ ");
INSERT INTO heb_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","ויצא לוט וידבר אל חתניו לקחי בנתיו ויאמר קומו צאו מן המקום הזה כי משחית יהוה את העיר ויהי כמצחק בעיני חתניו׃ ");
INSERT INTO heb_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","וכמו השחר עלה ויאיצו המלאכים בלוט לאמר קום קח את אשתך ואת שתי בנתיך הנמצאת פן תספה בעון העיר׃ ");
INSERT INTO heb_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","ויתמהמה ויחזקו האנשים בידו וביד אשתו וביד שתי בנתיו בחמלת יהוה עליו ויצאהו וינחהו מחוץ לעיר׃ ");
INSERT INTO heb_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","ויהי כהוציאם אתם החוצה ויאמר המלט על נפשך אל תביט אחריך ואל תעמד בכל הככר ההרה המלט פן תספה׃ ");
INSERT INTO heb_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","ויאמר לוט אלהם אל נא אדני׃ ");
INSERT INTO heb_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","הנה נא מצא עבדך חן בעיניך ותגדל חסדך אשר עשית עמדי להחיות את נפשי ואנכי לא אוכל להמלט ההרה פן תדבקני הרעה ומתי׃ ");
INSERT INTO heb_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","הנה נא העיר הזאת קרבה לנוס שמה והיא מצער אמלטה נא שמה הלא מצער הוא ותחי נפשי׃ ");
INSERT INTO heb_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","ויאמר אליו הנה נשאתי פניך גם לדבר הזה לבלתי הפכי את העיר אשר דברת׃ ");
INSERT INTO heb_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","מהר המלט שמה כי לא אוכל לעשות דבר עד באך שמה על כן קרא שם העיר צוער׃ ");
INSERT INTO heb_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","השמש יצא על הארץ ולוט בא צערה׃ ");
INSERT INTO heb_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","ויהוה המטיר על סדם ועל עמרה גפרית ואש מאת יהוה מן השמים׃ ");
INSERT INTO heb_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","ויהפך את הערים האל ואת כל הככר ואת כל ישבי הערים וצמח האדמה׃ ");
INSERT INTO heb_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","ותבט אשתו מאחריו ותהי נציב מלח׃ ");
INSERT INTO heb_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","וישכם אברהם בבקר אל המקום אשר עמד שם את פני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","וישקף על פני סדם ועמרה ועל כל פני ארץ הככר וירא והנה עלה קיטר הארץ כקיטר הכבשן׃ ");
INSERT INTO heb_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","ויהי בשחת אלהים את ערי הככר ויזכר אלהים את אברהם וישלח את לוט מתוך ההפכה בהפך את הערים אשר ישב בהן לוט׃ ");
INSERT INTO heb_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","ויעל לוט מצוער וישב בהר ושתי בנתיו עמו כי ירא לשבת בצוער וישב במערה הוא ושתי בנתיו׃ ");
INSERT INTO heb_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","ותאמר הבכירה אל הצעירה אבינו זקן ואיש אין בארץ לבוא עלינו כדרך כל הארץ׃ ");
INSERT INTO heb_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","לכה נשקה את אבינו יין ונשכבה עמו ונחיה מאבינו זרע׃ ");
INSERT INTO heb_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","ותשקין את אביהן יין בלילה הוא ותבא הבכירה ותשכב את אביה ולא ידע בשכבה ובקומה׃ ");
INSERT INTO heb_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","ויהי ממחרת ותאמר הבכירה אל הצעירה הן שכבתי אמש את אבי נשקנו יין גם הלילה ובאי שכבי עמו ונחיה מאבינו זרע׃ ");
INSERT INTO heb_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","ותשקין גם בלילה ההוא את אביהן יין ותקם הצעירה ותשכב עמו ולא ידע בשכבה ובקמה׃ ");
INSERT INTO heb_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","ותהרין שתי בנות לוט מאביהן׃ ");
INSERT INTO heb_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","ותלד הבכירה בן ותקרא שמו מואב הוא אבי מואב עד היום׃ ");
INSERT INTO heb_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","והצעירה גם הוא ילדה בן ותקרא שמו בן עמי הוא אבי בני עמון עד היום׃ ");
INSERT INTO heb_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","ויסע משם אברהם ארצה הנגב וישב בין קדש ובין שור ויגר בגרר׃ ");
INSERT INTO heb_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","ויאמר אברהם אל שרה אשתו אחתי הוא וישלח אבימלך מלך גרר ויקח את שרה׃ ");
INSERT INTO heb_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","ויבא אלהים אל אבימלך בחלום הלילה ויאמר לו הנך מת על האשה אשר לקחת והוא בעלת בעל׃ ");
INSERT INTO heb_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","ואבימלך לא קרב אליה ויאמר אדני הגוי גם צדיק תהרג׃ ");
INSERT INTO heb_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","הלא הוא אמר לי אחתי הוא והיא גם הוא אמרה אחי הוא בתם לבבי ובנקין כפי עשיתי זאת׃ ");
INSERT INTO heb_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","ויאמר אליו האלהים בחלם גם אנכי ידעתי כי בתם לבבך עשית זאת ואחשך גם אנכי אותך מחטו לי על כן לא נתתיך לנגע אליה׃ ");
INSERT INTO heb_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","ועתה השב אשת האיש כי נביא הוא ויתפלל בעדך וחיה ואם אינך משיב דע כי מות תמות אתה וכל אשר לך׃ ");
INSERT INTO heb_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","וישכם אבימלך בבקר ויקרא לכל עבדיו וידבר את כל הדברים האלה באזניהם וייראו האנשים מאד׃ ");
INSERT INTO heb_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","ויקרא אבימלך לאברהם ויאמר לו מה עשית לנו ומה חטאתי לך כי הבאת עלי ועל ממלכתי חטאה גדלה מעשים אשר לא יעשו עשית עמדי׃ ");
INSERT INTO heb_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","ויאמר אבימלך אל אברהם מה ראית כי עשית את הדבר הזה׃ ");
INSERT INTO heb_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","ויאמר אברהם כי אמרתי רק אין יראת אלהים במקום הזה והרגוני על דבר אשתי׃ ");
INSERT INTO heb_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","וגם אמנה אחתי בת אבי הוא אך לא בת אמי ותהי לי לאשה׃ ");
INSERT INTO heb_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","ויהי כאשר התעו אתי אלהים מבית אבי ואמר לה זה חסדך אשר תעשי עמדי אל כל המקום אשר נבוא שמה אמרי לי אחי הוא׃ ");
INSERT INTO heb_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","ויקח אבימלך צאן ובקר ועבדים ושפחת ויתן לאברהם וישב לו את שרה אשתו׃ ");
INSERT INTO heb_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","ויאמר אבימלך הנה ארצי לפניך בטוב בעיניך שב׃ ");
INSERT INTO heb_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","ולשרה אמר הנה נתתי אלף כסף לאחיך הנה הוא לך כסות עינים לכל אשר אתך ואת כל ונכחת׃ ");
INSERT INTO heb_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","ויתפלל אברהם אל האלהים וירפא אלהים את אבימלך ואת אשתו ואמהתיו וילדו׃ ");
INSERT INTO heb_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","כי עצר עצר יהוה בעד כל רחם לבית אבימלך על דבר שרה אשת אברהם׃ ");
INSERT INTO heb_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","ויהוה פקד את שרה כאשר אמר ויעש יהוה לשרה כאשר דבר׃ ");
INSERT INTO heb_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","ותהר ותלד שרה לאברהם בן לזקניו למועד אשר דבר אתו אלהים׃ ");
INSERT INTO heb_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","ויקרא אברהם את שם בנו הנולד לו אשר ילדה לו שרה יצחק׃ ");
INSERT INTO heb_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","וימל אברהם את יצחק בנו בן שמנת ימים כאשר צוה אתו אלהים׃ ");
INSERT INTO heb_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","ואברהם בן מאת שנה בהולד לו את יצחק בנו׃ ");
INSERT INTO heb_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","ותאמר שרה צחק עשה לי אלהים כל השמע יצחק לי׃ ");
INSERT INTO heb_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","ותאמר מי מלל לאברהם היניקה בנים שרה כי ילדתי בן לזקניו׃ ");
INSERT INTO heb_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","ויגדל הילד ויגמל ויעש אברהם משתה גדול ביום הגמל את יצחק׃ ");
INSERT INTO heb_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","ותרא שרה את בן הגר המצרית אשר ילדה לאברהם מצחק׃ ");
INSERT INTO heb_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","ותאמר לאברהם גרש האמה הזאת ואת בנה כי לא יירש בן האמה הזאת עם בני עם יצחק׃ ");
INSERT INTO heb_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","וירע הדבר מאד בעיני אברהם על אודת בנו׃ ");
INSERT INTO heb_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","ויאמר אלהים אל אברהם אל ירע בעיניך על הנער ועל אמתך כל אשר תאמר אליך שרה שמע בקלה כי ביצחק יקרא לך זרע׃ ");
INSERT INTO heb_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","וגם את בן האמה לגוי אשימנו כי זרעך הוא׃ ");
INSERT INTO heb_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","וישכם אברהם בבקר ויקח לחם וחמת מים ויתן אל הגר שם על שכמה ואת הילד וישלחה ותלך ותתע במדבר באר שבע׃ ");
INSERT INTO heb_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","ויכלו המים מן החמת ותשלך את הילד תחת אחד השיחם׃ ");
INSERT INTO heb_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","ותלך ותשב לה מנגד הרחק כמטחוי קשת כי אמרה אל אראה במות הילד ותשב מנגד ותשא את קלה ותבך׃ ");
INSERT INTO heb_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","וישמע אלהים את קול הנער ויקרא מלאך אלהים אל הגר מן השמים ויאמר לה מה לך הגר אל תיראי כי שמע אלהים אל קול הנער באשר הוא שם׃ ");
INSERT INTO heb_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","קומי שאי את הנער והחזיקי את ידך בו כי לגוי גדול אשימנו׃ ");
INSERT INTO heb_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","ויפקח אלהים את עיניה ותרא באר מים ותלך ותמלא את החמת מים ותשק את הנער׃ ");
INSERT INTO heb_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","ויהי אלהים את הנער ויגדל וישב במדבר ויהי רבה קשת׃ ");
INSERT INTO heb_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","וישב במדבר פארן ותקח לו אמו אשה מארץ מצרים׃ ");
INSERT INTO heb_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","ויהי בעת ההוא ויאמר אבימלך ופיכל שר צבאו אל אברהם לאמר אלהים עמך בכל אשר אתה עשה׃ ");
INSERT INTO heb_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","ועתה השבעה לי באלהים הנה אם תשקר לי ולניני ולנכדי כחסד אשר עשיתי עמך תעשה עמדי ועם הארץ אשר גרתה בה׃ ");
INSERT INTO heb_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","ויאמר אברהם אנכי אשבע׃ ");
INSERT INTO heb_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","והוכח אברהם את אבימלך על אדות באר המים אשר גזלו עבדי אבימלך׃ ");
INSERT INTO heb_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","ויאמר אבימלך לא ידעתי מי עשה את הדבר הזה וגם אתה לא הגדת לי וגם אנכי לא שמעתי בלתי היום׃ ");
INSERT INTO heb_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","ויקח אברהם צאן ובקר ויתן לאבימלך ויכרתו שניהם ברית׃ ");
INSERT INTO heb_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","ויצב אברהם את שבע כבשת הצאן לבדהן׃ ");
INSERT INTO heb_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","ויאמר אבימלך אל אברהם מה הנה שבע כבשת האלה אשר הצבת לבדנה׃ ");
INSERT INTO heb_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","ויאמר כי את שבע כבשת תקח מידי בעבור תהיה לי לעדה כי חפרתי את הבאר הזאת׃ ");
INSERT INTO heb_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","על כן קרא למקום ההוא באר שבע כי שם נשבעו שניהם׃ ");
INSERT INTO heb_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","ויכרתו ברית בבאר שבע ויקם אבימלך ופיכל שר צבאו וישבו אל ארץ פלשתים׃ ");
INSERT INTO heb_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","ויטע אשל בבאר שבע ויקרא שם בשם יהוה אל עולם׃ ");
INSERT INTO heb_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","ויגר אברהם בארץ פלשתים ימים רבים׃ ");
INSERT INTO heb_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","ויהי אחר הדברים האלה והאלהים נסה את אברהם ויאמר אליו אברהם ויאמר הנני׃ ");
INSERT INTO heb_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","ויאמר קח נא את בנך את יחידך אשר אהבת את יצחק ולך לך אל ארץ המריה והעלהו שם לעלה על אחד ההרים אשר אמר אליך׃ ");
INSERT INTO heb_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","וישכם אברהם בבקר ויחבש את חמרו ויקח את שני נעריו אתו ואת יצחק בנו ויבקע עצי עלה ויקם וילך אל המקום אשר אמר לו האלהים׃ ");
INSERT INTO heb_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","ביום השלישי וישא אברהם את עיניו וירא את המקום מרחק׃ ");
INSERT INTO heb_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","ויאמר אברהם אל נעריו שבו לכם פה עם החמור ואני והנער נלכה עד כה ונשתחוה ונשובה אליכם׃ ");
INSERT INTO heb_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","ויקח אברהם את עצי העלה וישם על יצחק בנו ויקח בידו את האש ואת המאכלת וילכו שניהם יחדו׃ ");
INSERT INTO heb_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","ויאמר יצחק אל אברהם אביו ויאמר אבי ויאמר הנני בני ויאמר הנה האש והעצים ואיה השה לעלה׃ ");
INSERT INTO heb_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","ויאמר אברהם אלהים יראה לו השה לעלה בני וילכו שניהם יחדו׃ ");
INSERT INTO heb_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","ויבאו אל המקום אשר אמר לו האלהים ויבן שם אברהם את המזבח ויערך את העצים ויעקד את יצחק בנו וישם אתו על המזבח ממעל לעצים׃ ");
INSERT INTO heb_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","וישלח אברהם את ידו ויקח את המאכלת לשחט את בנו׃ ");
INSERT INTO heb_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","ויקרא אליו מלאך יהוה מן השמים ויאמר אברהם אברהם ויאמר הנני׃ ");
INSERT INTO heb_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","ויאמר אל תשלח ידך אל הנער ואל תעש לו מאומה כי עתה ידעתי כי ירא אלהים אתה ולא חשכת את בנך את יחידך ממני׃ ");
INSERT INTO heb_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","וישא אברהם את עיניו וירא והנה איל אחר נאחז בסבך בקרניו וילך אברהם ויקח את האיל ויעלהו לעלה תחת בנו׃ ");
INSERT INTO heb_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","ויקרא אברהם שם המקום ההוא יהוה יראה אשר יאמר היום בהר יהוה יראה׃ ");
INSERT INTO heb_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","ויקרא מלאך יהוה אל אברהם שנית מן השמים׃ ");
INSERT INTO heb_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","ויאמר בי נשבעתי נאם יהוה כי יען אשר עשית את הדבר הזה ולא חשכת את בנך את יחידך׃ ");
INSERT INTO heb_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","כי ברך אברכך והרבה ארבה את זרעך ככוכבי השמים וכחול אשר על שפת הים וירש זרעך את שער איביו׃ ");
INSERT INTO heb_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","והתברכו בזרעך כל גויי הארץ עקב אשר שמעת בקלי׃ ");
INSERT INTO heb_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","וישב אברהם אל נעריו ויקמו וילכו יחדו אל באר שבע וישב אברהם בבאר שבע׃ ");
INSERT INTO heb_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","ויהי אחרי הדברים האלה ויגד לאברהם לאמר הנה ילדה מלכה גם הוא בנים לנחור אחיך׃ ");
INSERT INTO heb_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","את עוץ בכרו ואת בוז אחיו ואת קמואל אבי ארם׃ ");
INSERT INTO heb_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","ואת כשד ואת חזו ואת פלדש ואת ידלף ואת בתואל׃ ");
INSERT INTO heb_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","ובתואל ילד את רבקה שמנה אלה ילדה מלכה לנחור אחי אברהם׃ ");
INSERT INTO heb_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","ופילגשו ושמה ראומה ותלד גם הוא את טבח ואת גחם ואת תחש ואת מעכה׃ ");
INSERT INTO heb_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","ויהיו חיי שרה מאה שנה ועשרים שנה ושבע שנים שני חיי שרה׃ ");
INSERT INTO heb_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","ותמת שרה בקרית ארבע הוא חברון בארץ כנען ויבא אברהם לספד לשרה ולבכתה׃ ");
INSERT INTO heb_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","ויקם אברהם מעל פני מתו וידבר אל בני חת לאמר׃ ");
INSERT INTO heb_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","גר ותושב אנכי עמכם תנו לי אחזת קבר עמכם ואקברה מתי מלפני׃ ");
INSERT INTO heb_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","ויענו בני חת את אברהם לאמר לו׃ ");
INSERT INTO heb_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","שמענו אדני נשיא אלהים אתה בתוכנו במבחר קברינו קבר את מתך איש ממנו את קברו לא יכלה ממך מקבר מתך׃ ");
INSERT INTO heb_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","ויקם אברהם וישתחו לעם הארץ לבני חת׃ ");
INSERT INTO heb_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","וידבר אתם לאמר אם יש את נפשכם לקבר את מתי מלפני שמעוני ופגעו לי בעפרון בן צחר׃ ");
INSERT INTO heb_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","ויתן לי את מערת המכפלה אשר לו אשר בקצה שדהו בכסף מלא יתננה לי בתוככם לאחזת קבר׃ ");
INSERT INTO heb_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","ועפרון ישב בתוך בני חת ויען עפרון החתי את אברהם באזני בני חת לכל באי שער עירו לאמר׃ ");
INSERT INTO heb_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","לא אדני שמעני השדה נתתי לך והמערה אשר בו לך נתתיה לעיני בני עמי נתתיה לך קבר מתך׃ ");
INSERT INTO heb_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","וישתחו אברהם לפני עם הארץ׃ ");
INSERT INTO heb_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","וידבר אל עפרון באזני עם הארץ לאמר אך אם אתה לו שמעני נתתי כסף השדה קח ממני ואקברה את מתי שמה׃ ");
INSERT INTO heb_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","ויען עפרון את אברהם לאמר לו׃ ");
INSERT INTO heb_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","אדני שמעני ארץ ארבע מאת שקל כסף ביני ובינך מה הוא ואת מתך קבר׃ ");
INSERT INTO heb_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","וישמע אברהם אל עפרון וישקל אברהם לעפרן את הכסף אשר דבר באזני בני חת ארבע מאות שקל כסף עבר לסחר׃ ");
INSERT INTO heb_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","ויקם שדה עפרון אשר במכפלה אשר לפני ממרא השדה והמערה אשר בו וכל העץ אשר בשדה אשר בכל גבלו סביב׃ ");
INSERT INTO heb_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","לאברהם למקנה לעיני בני חת בכל באי שער עירו׃ ");
INSERT INTO heb_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","ואחרי כן קבר אברהם את שרה אשתו אל מערת שדה המכפלה על פני ממרא הוא חברון בארץ כנען׃ ");
INSERT INTO heb_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","ויקם השדה והמערה אשר בו לאברהם לאחזת קבר מאת בני חת׃ ");
INSERT INTO heb_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","ואברהם זקן בא בימים ויהוה ברך את אברהם בכל׃ ");
INSERT INTO heb_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","ויאמר אברהם אל עבדו זקן ביתו המשל בכל אשר לו שים נא ידך תחת ירכי׃ ");
INSERT INTO heb_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","ואשביעך ביהוה אלהי השמים ואלהי הארץ אשר לא תקח אשה לבני מבנות הכנעני אשר אנכי יושב בקרבו׃ ");
INSERT INTO heb_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","כי אל ארצי ואל מולדתי תלך ולקחת אשה לבני ליצחק׃ ");
INSERT INTO heb_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","ויאמר אליו העבד אולי לא תאבה האשה ללכת אחרי אל הארץ הזאת ההשב אשיב את בנך אל הארץ אשר יצאת משם׃ ");
INSERT INTO heb_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","ויאמר אליו אברהם השמר לך פן תשיב את בני שמה׃ ");
INSERT INTO heb_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","יהוה אלהי השמים אשר לקחני מבית אבי ומארץ מולדתי ואשר דבר לי ואשר נשבע לי לאמר לזרעך אתן את הארץ הזאת הוא ישלח מלאכו לפניך ולקחת אשה לבני משם׃ ");
INSERT INTO heb_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","ואם לא תאבה האשה ללכת אחריך ונקית משבעתי זאת רק את בני לא תשב שמה׃ ");
INSERT INTO heb_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","וישם העבד את ידו תחת ירך אברהם אדניו וישבע לו על הדבר הזה׃ ");
INSERT INTO heb_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","ויקח העבד עשרה גמלים מגמלי אדניו וילך וכל טוב אדניו בידו ויקם וילך אל ארם נהרים אל עיר נחור׃ ");
INSERT INTO heb_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","ויברך הגמלים מחוץ לעיר אל באר המים לעת ערב לעת צאת השאבת׃ ");
INSERT INTO heb_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","ויאמר יהוה אלהי אדני אברהם הקרה נא לפני היום ועשה חסד עם אדני אברהם׃ ");
INSERT INTO heb_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","הנה אנכי נצב על עין המים ובנות אנשי העיר יצאת לשאב מים׃ ");
INSERT INTO heb_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","והיה הנער אשר אמר אליה הטי נא כדך ואשתה ואמרה שתה וגם גמליך אשקה אתה הכחת לעבדך ליצחק ובה אדע כי עשית חסד עם אדני׃ ");
INSERT INTO heb_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","ויהי הוא טרם כלה לדבר והנה רבקה יצאת אשר ילדה לבתואל בן מלכה אשת נחור אחי אברהם וכדה על שכמה׃ ");
INSERT INTO heb_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","והנער טבת מראה מאד בתולה ואיש לא ידעה ותרד העינה ותמלא כדה ותעל׃ ");
INSERT INTO heb_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","וירץ העבד לקראתה ויאמר הגמיאיני נא מעט מים מכדך׃ ");
INSERT INTO heb_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","ותאמר שתה אדני ותמהר ותרד כדה על ידה ותשקהו׃ ");
INSERT INTO heb_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","ותכל להשקתו ותאמר גם לגמליך אשאב עד אם כלו לשתת׃ ");
INSERT INTO heb_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","ותמהר ותער כדה אל השקת ותרץ עוד אל הבאר לשאב ותשאב לכל גמליו׃ ");
INSERT INTO heb_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","והאיש משתאה לה מחריש לדעת ההצליח יהוה דרכו אם לא׃ ");
INSERT INTO heb_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","ויהי כאשר כלו הגמלים לשתות ויקח האיש נזם זהב בקע משקלו ושני צמידים על ידיה עשרה זהב משקלם׃ ");
INSERT INTO heb_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","ויאמר בת מי את הגידי נא לי היש בית אביך מקום לנו ללין׃ ");
INSERT INTO heb_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","ותאמר אליו בת בתואל אנכי בן מלכה אשר ילדה לנחור׃ ");
INSERT INTO heb_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","ותאמר אליו גם תבן גם מספוא רב עמנו גם מקום ללון׃ ");
INSERT INTO heb_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","ויקד האיש וישתחו ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","ויאמר ברוך יהוה אלהי אדני אברהם אשר לא עזב חסדו ואמתו מעם אדני אנכי בדרך נחני יהוה בית אחי אדני׃ ");
INSERT INTO heb_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","ותרץ הנער ותגד לבית אמה כדברים האלה׃ ");
INSERT INTO heb_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","ולרבקה אח ושמו לבן וירץ לבן אל האיש החוצה אל העין׃ ");
INSERT INTO heb_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","ויהי כראת את הנזם ואת הצמדים על ידי אחתו וכשמעו את דברי רבקה אחתו לאמר כה דבר אלי האיש ויבא אל האיש והנה עמד על הגמלים על העין׃ ");
INSERT INTO heb_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","ויאמר בוא ברוך יהוה למה תעמד בחוץ ואנכי פניתי הבית ומקום לגמלים׃ ");
INSERT INTO heb_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","ויבא האיש הביתה ויפתח הגמלים ויתן תבן ומספוא לגמלים ומים לרחץ רגליו ורגלי האנשים אשר אתו׃ ");
INSERT INTO heb_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","ויישם לפניו לאכל ויאמר לא אכל עד אם דברתי דברי ויאמר דבר׃ ");
INSERT INTO heb_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","ויאמר עבד אברהם אנכי׃ ");
INSERT INTO heb_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","ויהוה ברך את אדני מאד ויגדל ויתן לו צאן ובקר וכסף וזהב ועבדם ושפחת וגמלים וחמרים׃ ");
INSERT INTO heb_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","ותלד שרה אשת אדני בן לאדני אחרי זקנתה ויתן לו את כל אשר לו׃ ");
INSERT INTO heb_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","וישבעני אדני לאמר לא תקח אשה לבני מבנות הכנעני אשר אנכי ישב בארצו׃ ");
INSERT INTO heb_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","אם לא אל בית אבי תלך ואל משפחתי ולקחת אשה לבני׃ ");
INSERT INTO heb_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","ואמר אל אדני אלי לא תלך האשה אחרי׃ ");
INSERT INTO heb_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","ויאמר אלי יהוה אשר התהלכתי לפניו ישלח מלאכו אתך והצליח דרכך ולקחת אשה לבני ממשפחתי ומבית אבי׃ ");
INSERT INTO heb_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","אז תנקה מאלתי כי תבוא אל משפחתי ואם לא יתנו לך והיית נקי מאלתי׃ ");
INSERT INTO heb_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","ואבא היום אל העין ואמר יהוה אלהי אדני אברהם אם ישך נא מצליח דרכי אשר אנכי הלך עליה׃ ");
INSERT INTO heb_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","הנה אנכי נצב על עין המים והיה העלמה היצאת לשאב ואמרתי אליה השקיני נא מעט מים מכדך׃ ");
INSERT INTO heb_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","ואמרה אלי גם אתה שתה וגם לגמליך אשאב הוא האשה אשר הכיח יהוה לבן אדני׃ ");
INSERT INTO heb_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","אני טרם אכלה לדבר אל לבי והנה רבקה יצאת וכדה על שכמה ותרד העינה ותשאב ואמר אליה השקיני נא׃ ");
INSERT INTO heb_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","ותמהר ותורד כדה מעליה ותאמר שתה וגם גמליך אשקה ואשת וגם הגמלים השקתה׃ ");
INSERT INTO heb_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","ואשאל אתה ואמר בת מי את ותאמר בת בתואל בן נחור אשר ילדה לו מלכה ואשם הנזם על אפה והצמידים על ידיה׃ ");
INSERT INTO heb_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","ואקד ואשתחוה ליהוה ואברך את יהוה אלהי אדני אברהם אשר הנחני בדרך אמת לקחת את בת אחי אדני לבנו׃ ");
INSERT INTO heb_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","ועתה אם ישכם עשים חסד ואמת את אדני הגידו לי ואם לא הגידו לי ואפנה על ימין או על שמאל׃ ");
INSERT INTO heb_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","ויען לבן ובתואל ויאמרו מיהוה יצא הדבר לא נוכל דבר אליך רע או טוב׃ ");
INSERT INTO heb_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","הנה רבקה לפניך קח ולך ותהי אשה לבן אדניך כאשר דבר יהוה׃ ");
INSERT INTO heb_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","ויהי כאשר שמע עבד אברהם את דבריהם וישתחו ארצה ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","ויוצא העבד כלי כסף וכלי זהב ובגדים ויתן לרבקה ומגדנת נתן לאחיה ולאמה׃ ");
INSERT INTO heb_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","ויאכלו וישתו הוא והאנשים אשר עמו וילינו ויקומו בבקר ויאמר שלחני לאדני׃ ");
INSERT INTO heb_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","ויאמר אחיה ואמה תשב הנער אתנו ימים או עשור אחר תלך׃ ");
INSERT INTO heb_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","ויאמר אלהם אל תאחרו אתי ויהוה הצליח דרכי שלחוני ואלכה לאדני׃ ");
INSERT INTO heb_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","ויאמרו נקרא לנער ונשאלה את פיה׃ ");
INSERT INTO heb_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","ויקראו לרבקה ויאמרו אליה התלכי עם האיש הזה ותאמר אלך׃ ");
INSERT INTO heb_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","וישלחו את רבקה אחתם ואת מנקתה ואת עבד אברהם ואת אנשיו׃ ");
INSERT INTO heb_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","ויברכו את רבקה ויאמרו לה אחתנו את היי לאלפי רבבה ויירש זרעך את שער שנאיו׃ ");
INSERT INTO heb_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","ותקם רבקה ונערתיה ותרכבנה על הגמלים ותלכנה אחרי האיש ויקח העבד את רבקה וילך׃ ");
INSERT INTO heb_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","ויצחק בא מבוא באר לחי ראי והוא יושב בארץ הנגב׃ ");
INSERT INTO heb_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","ויצא יצחק לשוח בשדה לפנות ערב וישא עיניו וירא והנה גמלים באים׃ ");
INSERT INTO heb_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","ותשא רבקה את עיניה ותרא את יצחק ותפל מעל הגמל׃ ");
INSERT INTO heb_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","ותאמר אל העבד מי האיש הלזה ההלך בשדה לקראתנו ויאמר העבד הוא אדני ותקח הצעיף ותתכס׃ ");
INSERT INTO heb_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","ויספר העבד ליצחק את כל הדברים אשר עשה׃ ");
INSERT INTO heb_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","ויבאה יצחק האהלה שרה אמו ויקח את רבקה ותהי לו לאשה ויאהבה וינחם יצחק אחרי אמו׃ ");
INSERT INTO heb_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","ויסף אברהם ויקח אשה ושמה קטורה׃ ");
INSERT INTO heb_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","ותלד לו את זמרן ואת יקשן ואת מדן ואת מדין ואת ישבק ואת שוח׃ ");
INSERT INTO heb_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","ויקשן ילד את שבא ואת דדן ובני דדן היו אשורם ולטושים ולאמים׃ ");
INSERT INTO heb_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","ובני מדין עיפה ועפר וחנך ואבידע ואלדעה כל אלה בני קטורה׃ ");
INSERT INTO heb_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","ויתן אברהם את כל אשר לו ליצחק׃ ");
INSERT INTO heb_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","ולבני הפילגשים אשר לאברהם נתן אברהם מתנת וישלחם מעל יצחק בנו בעודנו חי קדמה אל ארץ קדם׃ ");
INSERT INTO heb_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","ואלה ימי שני חיי אברהם אשר חי מאת שנה ושבעים שנה וחמש שנים׃ ");
INSERT INTO heb_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","ויגוע וימת אברהם בשיבה טובה זקן ושבע ויאסף אל עמיו׃ ");
INSERT INTO heb_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","ויקברו אתו יצחק וישמעאל בניו אל מערת המכפלה אל שדה עפרן בן צחר החתי אשר על פני ממרא׃ ");
INSERT INTO heb_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","השדה אשר קנה אברהם מאת בני חת שמה קבר אברהם ושרה אשתו׃ ");
INSERT INTO heb_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","ויהי אחרי מות אברהם ויברך אלהים את יצחק בנו וישב יצחק עם באר לחי ראי׃ ");
INSERT INTO heb_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","ואלה תלדת ישמעאל בן אברהם אשר ילדה הגר המצרית שפחת שרה לאברהם׃ ");
INSERT INTO heb_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","ואלה שמות בני ישמעאל בשמתם לתולדתם בכר ישמעאל נבית וקדר ואדבאל ומבשם׃ ");
INSERT INTO heb_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","ומשמע ודומה ומשא׃ ");
INSERT INTO heb_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","חדד ותימא יטור נפיש וקדמה׃ ");
INSERT INTO heb_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","אלה הם בני ישמעאל ואלה שמתם בחצריהם ובטירתם שנים עשר נשיאם לאמתם׃ ");
INSERT INTO heb_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","ואלה שני חיי ישמעאל מאת שנה ושלשים שנה ושבע שנים ויגוע וימת ויאסף אל עמיו׃ ");
INSERT INTO heb_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","וישכנו מחוילה עד שור אשר על פני מצרים באכה אשורה על פני כל אחיו נפל׃ ");
INSERT INTO heb_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","ואלה תולדת יצחק בן אברהם אברהם הוליד את יצחק׃ ");
INSERT INTO heb_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","ויהי יצחק בן ארבעים שנה בקחתו את רבקה בת בתואל הארמי מפדן ארם אחות לבן הארמי לו לאשה׃ ");
INSERT INTO heb_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","ויעתר יצחק ליהוה לנכח אשתו כי עקרה הוא ויעתר לו יהוה ותהר רבקה אשתו׃ ");
INSERT INTO heb_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","ויתרצצו הבנים בקרבה ותאמר אם כן למה זה אנכי ותלך לדרש את יהוה׃ ");
INSERT INTO heb_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","ויאמר יהוה לה שני גיים בבטנך ושני לאמים ממעיך יפרדו ולאם מלאם יאמץ ורב יעבד צעיר׃ ");
INSERT INTO heb_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","וימלאו ימיה ללדת והנה תומם בבטנה׃ ");
INSERT INTO heb_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","ויצא הראשון אדמוני כלו כאדרת שער ויקראו שמו עשו׃ ");
INSERT INTO heb_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","ואחרי כן יצא אחיו וידו אחזת בעקב עשו ויקרא שמו יעקב ויצחק בן ששים שנה בלדת אתם׃ ");
INSERT INTO heb_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","ויגדלו הנערים ויהי עשו איש ידע ציד איש שדה ויעקב איש תם ישב אהלים׃ ");
INSERT INTO heb_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","ויאהב יצחק את עשו כי ציד בפיו ורבקה אהבת את יעקב׃ ");
INSERT INTO heb_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","ויזד יעקב נזיד ויבא עשו מן השדה והוא עיף׃ ");
INSERT INTO heb_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","ויאמר עשו אל יעקב הלעיטני נא מן האדם האדם הזה כי עיף אנכי על כן קרא שמו אדום׃ ");
INSERT INTO heb_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","ויאמר יעקב מכרה כיום את בכרתך לי׃ ");
INSERT INTO heb_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","ויאמר עשו הנה אנכי הולך למות ולמה זה לי בכרה׃ ");
INSERT INTO heb_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","ויאמר יעקב השבעה לי כיום וישבע לו וימכר את בכרתו ליעקב׃ ");
INSERT INTO heb_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","ויעקב נתן לעשו לחם ונזיד עדשים ויאכל וישת ויקם וילך ויבז עשו את הבכרה׃ ");
INSERT INTO heb_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","ויהי רעב בארץ מלבד הרעב הראשון אשר היה בימי אברהם וילך יצחק אל אבימלך מלך פלשתים גררה׃ ");
INSERT INTO heb_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","וירא אליו יהוה ויאמר אל תרד מצרימה שכן בארץ אשר אמר אליך׃ ");
INSERT INTO heb_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","גור בארץ הזאת ואהיה עמך ואברכך כי לך ולזרעך אתן את כל הארצת האל והקמתי את השבעה אשר נשבעתי לאברהם אביך׃ ");
INSERT INTO heb_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","והרביתי את זרעך ככוכבי השמים ונתתי לזרעך את כל הארצת האל והתברכו בזרעך כל גויי הארץ׃ ");
INSERT INTO heb_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","עקב אשר שמע אברהם בקלי וישמר משמרתי מצותי חקותי ותורתי׃ ");
INSERT INTO heb_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","וישב יצחק בגרר׃ ");
INSERT INTO heb_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","וישאלו אנשי המקום לאשתו ויאמר אחתי הוא כי ירא לאמר אשתי פן יהרגני אנשי המקום על רבקה כי טובת מראה היא׃ ");
INSERT INTO heb_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","ויהי כי ארכו לו שם הימים וישקף אבימלך מלך פלשתים בעד החלון וירא והנה יצחק מצחק את רבקה אשתו׃ ");
INSERT INTO heb_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","ויקרא אבימלך ליצחק ויאמר אך הנה אשתך הוא ואיך אמרת אחתי הוא ויאמר אליו יצחק כי אמרתי פן אמות עליה׃ ");
INSERT INTO heb_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","ויאמר אבימלך מה זאת עשית לנו כמעט שכב אחד העם את אשתך והבאת עלינו אשם׃ ");
INSERT INTO heb_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","ויצו אבימלך את כל העם לאמר הנגע באיש הזה ובאשתו מות יומת׃ ");
INSERT INTO heb_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","ויזרע יצחק בארץ ההוא וימצא בשנה ההוא מאה שערים ויברכהו יהוה׃ ");
INSERT INTO heb_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","ויגדל האיש וילך הלוך וגדל עד כי גדל מאד׃ ");
INSERT INTO heb_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","ויהי לו מקנה צאן ומקנה בקר ועבדה רבה ויקנאו אתו פלשתים׃ ");
INSERT INTO heb_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","וכל הבארת אשר חפרו עבדי אביו בימי אברהם אביו סתמום פלשתים וימלאום עפר׃ ");
INSERT INTO heb_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","ויאמר אבימלך אל יצחק לך מעמנו כי עצמת ממנו מאד׃ ");
INSERT INTO heb_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","וילך משם יצחק ויחן בנחל גרר וישב שם׃ ");
INSERT INTO heb_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","וישב יצחק ויחפר את בארת המים אשר חפרו בימי אברהם אביו ויסתמום פלשתים אחרי מות אברהם ויקרא להן שמות כשמת אשר קרא להן אביו׃ ");
INSERT INTO heb_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","ויחפרו עבדי יצחק בנחל וימצאו שם באר מים חיים׃ ");
INSERT INTO heb_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","ויריבו רעי גרר עם רעי יצחק לאמר לנו המים ויקרא שם הבאר עשק כי התעשקו עמו׃ ");
INSERT INTO heb_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","ויחפרו באר אחרת ויריבו גם עליה ויקרא שמה שטנה׃ ");
INSERT INTO heb_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","ויעתק משם ויחפר באר אחרת ולא רבו עליה ויקרא שמה רחבות ויאמר כי עתה הרחיב יהוה לנו ופרינו בארץ׃ ");
INSERT INTO heb_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","ויעל משם באר שבע׃ ");
INSERT INTO heb_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","וירא אליו יהוה בלילה ההוא ויאמר אנכי אלהי אברהם אביך אל תירא כי אתך אנכי וברכתיך והרביתי את זרעך בעבור אברהם עבדי׃ ");
INSERT INTO heb_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","ויבן שם מזבח ויקרא בשם יהוה ויט שם אהלו ויכרו שם עבדי יצחק באר׃ ");
INSERT INTO heb_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","ואבימלך הלך אליו מגרר ואחזת מרעהו ופיכל שר צבאו׃ ");
INSERT INTO heb_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","ויאמר אלהם יצחק מדוע באתם אלי ואתם שנאתם אתי ותשלחוני מאתכם׃ ");
INSERT INTO heb_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","ויאמרו ראו ראינו כי היה יהוה עמך ונאמר תהי נא אלה בינותינו בינינו ובינך ונכרתה ברית עמך׃ ");
INSERT INTO heb_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","אם תעשה עמנו רעה כאשר לא נגענוך וכאשר עשינו עמך רק טוב ונשלחך בשלום אתה עתה ברוך יהוה׃ ");
INSERT INTO heb_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","ויעש להם משתה ויאכלו וישתו׃ ");
INSERT INTO heb_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","וישכימו בבקר וישבעו איש לאחיו וישלחם יצחק וילכו מאתו בשלום׃ ");
INSERT INTO heb_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","ויהי ביום ההוא ויבאו עבדי יצחק ויגדו לו על אדות הבאר אשר חפרו ויאמרו לו מצאנו מים׃ ");
INSERT INTO heb_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","ויקרא אתה שבעה על כן שם העיר באר שבע עד היום הזה׃ ");
INSERT INTO heb_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","ויהי עשו בן ארבעים שנה ויקח אשה את יהודית בת בארי החתי ואת בשמת בת אילן החתי׃ ");
INSERT INTO heb_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","ותהיין מרת רוח ליצחק ולרבקה׃ ");
INSERT INTO heb_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","ויהי כי זקן יצחק ותכהין עיניו מראת ויקרא את עשו בנו הגדל ויאמר אליו בני ויאמר אליו הנני׃ ");
INSERT INTO heb_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","ויאמר הנה נא זקנתי לא ידעתי יום מותי׃ ");
INSERT INTO heb_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","ועתה שא נא כליך תליך וקשתך וצא השדה וצודה לי צידה׃ ");
INSERT INTO heb_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","ועשה לי מטעמים כאשר אהבתי והביאה לי ואכלה בעבור תברכך נפשי בטרם אמות׃ ");
INSERT INTO heb_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","ורבקה שמעת בדבר יצחק אל עשו בנו וילך עשו השדה לצוד ציד להביא׃ ");
INSERT INTO heb_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","ורבקה אמרה אל יעקב בנה לאמר הנה שמעתי את אביך מדבר אל עשו אחיך לאמר׃ ");
INSERT INTO heb_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","הביאה לי ציד ועשה לי מטעמים ואכלה ואברככה לפני יהוה לפני מותי׃ ");
INSERT INTO heb_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","ועתה בני שמע בקלי לאשר אני מצוה אתך׃ ");
INSERT INTO heb_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","לך נא אל הצאן וקח לי משם שני גדיי עזים טבים ואעשה אתם מטעמים לאביך כאשר אהב׃ ");
INSERT INTO heb_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","והבאת לאביך ואכל בעבר אשר יברכך לפני מותו׃ ");
INSERT INTO heb_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","ויאמר יעקב אל רבקה אמו הן עשו אחי איש שער ואנכי איש חלק׃ ");
INSERT INTO heb_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","אולי ימשני אבי והייתי בעיניו כמתעתע והבאתי עלי קללה ולא ברכה׃ ");
INSERT INTO heb_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","ותאמר לו אמו עלי קללתך בני אך שמע בקלי ולך קח לי׃ ");
INSERT INTO heb_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","וילך ויקח ויבא לאמו ותעש אמו מטעמים כאשר אהב אביו׃ ");
INSERT INTO heb_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","ותקח רבקה את בגדי עשו בנה הגדל החמדת אשר אתה בבית ותלבש את יעקב בנה הקטן׃ ");
INSERT INTO heb_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","ואת ערת גדיי העזים הלבישה על ידיו ועל חלקת צואריו׃ ");
INSERT INTO heb_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","ותתן את המטעמים ואת הלחם אשר עשתה ביד יעקב בנה׃ ");
INSERT INTO heb_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","ויבא אל אביו ויאמר אבי ויאמר הנני מי אתה בני׃ ");
INSERT INTO heb_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","ויאמר יעקב אל אביו אנכי עשו בכרך עשיתי כאשר דברת אלי קום נא שבה ואכלה מצידי בעבור תברכני נפשך׃ ");
INSERT INTO heb_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","ויאמר יצחק אל בנו מה זה מהרת למצא בני ויאמר כי הקרה יהוה אלהיך לפני׃ ");
INSERT INTO heb_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","ויאמר יצחק אל יעקב גשה נא ואמשך בני האתה זה בני עשו אם לא׃ ");
INSERT INTO heb_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","ויגש יעקב אל יצחק אביו וימשהו ויאמר הקל קול יעקב והידים ידי עשו׃ ");
INSERT INTO heb_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","ולא הכירו כי היו ידיו כידי עשו אחיו שערת ויברכהו׃ ");
INSERT INTO heb_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","ויאמר אתה זה בני עשו ויאמר אני׃ ");
INSERT INTO heb_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","ויאמר הגשה לי ואכלה מציד בני למען תברכך נפשי ויגש לו ויאכל ויבא לו יין וישת׃ ");
INSERT INTO heb_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","ויאמר אליו יצחק אביו גשה נא ושקה לי בני׃ ");
INSERT INTO heb_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","ויגש וישק לו וירח את ריח בגדיו ויברכהו ויאמר ראה ריח בני כריח שדה אשר ברכו יהוה׃ ");
INSERT INTO heb_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","ויתן לך האלהים מטל השמים ומשמני הארץ ורב דגן ותירש׃ ");
INSERT INTO heb_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","יעבדוך עמים וישתחו לך לאמים הוה גביר לאחיך וישתחוו לך בני אמך ארריך ארור ומברכיך ברוך׃ ");
INSERT INTO heb_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","ויהי כאשר כלה יצחק לברך את יעקב ויהי אך יצא יצא יעקב מאת פני יצחק אביו ועשו אחיו בא מצידו׃ ");
INSERT INTO heb_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","ויעש גם הוא מטעמים ויבא לאביו ויאמר לאביו יקם אבי ויאכל מציד בנו בעבור תברכני נפשך׃ ");
INSERT INTO heb_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","ויאמר לו יצחק אביו מי אתה ויאמר אני בנך בכרך עשו׃ ");
INSERT INTO heb_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","ויחרד יצחק חרדה גדלה עד מאד ויאמר מי אפוא הוא הצד ציד ויבא לי ואכל מכל בטרם תבוא ואברכהו גם ברוך יהיה׃ ");
INSERT INTO heb_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","כשמע עשו את דברי אביו ויצעק צעקה גדלה ומרה עד מאד ויאמר לאביו ברכני גם אני אבי׃ ");
INSERT INTO heb_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","ויאמר בא אחיך במרמה ויקח ברכתך׃ ");
INSERT INTO heb_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","ויאמר הכי קרא שמו יעקב ויעקבני זה פעמים את בכרתי לקח והנה עתה לקח ברכתי ויאמר הלא אצלת לי ברכה׃ ");
INSERT INTO heb_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","ויען יצחק ויאמר לעשו הן גביר שמתיו לך ואת כל אחיו נתתי לו לעבדים ודגן ותירש סמכתיו ולכה אפוא מה אעשה בני׃ ");
INSERT INTO heb_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","ויאמר עשו אל אביו הברכה אחת הוא לך אבי ברכני גם אני אבי וישא עשו קלו ויבך׃ ");
INSERT INTO heb_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","ויען יצחק אביו ויאמר אליו הנה משמני הארץ יהיה מושבך ומטל השמים מעל׃ ");
INSERT INTO heb_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","ועל חרבך תחיה ואת אחיך תעבד והיה כאשר תריד ופרקת עלו מעל צוארך׃ ");
INSERT INTO heb_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","וישטם עשו את יעקב על הברכה אשר ברכו אביו ויאמר עשו בלבו יקרבו ימי אבל אבי ואהרגה את יעקב אחי׃ ");
INSERT INTO heb_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","ויגד לרבקה את דברי עשו בנה הגדל ותשלח ותקרא ליעקב בנה הקטן ותאמר אליו הנה עשו אחיך מתנחם לך להרגך׃ ");
INSERT INTO heb_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","ועתה בני שמע בקלי וקום ברח לך אל לבן אחי חרנה׃ ");
INSERT INTO heb_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","וישבת עמו ימים אחדים עד אשר תשוב חמת אחיך׃ ");
INSERT INTO heb_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","עד שוב אף אחיך ממך ושכח את אשר עשית לו ושלחתי ולקחתיך משם למה אשכל גם שניכם יום אחד׃ ");
INSERT INTO heb_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","ותאמר רבקה אל יצחק קצתי בחיי מפני בנות חת אם לקח יעקב אשה מבנות חת כאלה מבנות הארץ למה לי חיים׃ ");
INSERT INTO heb_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","ויקרא יצחק אל יעקב ויברך אתו ויצוהו ויאמר לו לא תקח אשה מבנות כנען׃ ");
INSERT INTO heb_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","קום לך פדנה ארם ביתה בתואל אבי אמך וקח לך משם אשה מבנות לבן אחי אמך׃ ");
INSERT INTO heb_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","ואל שדי יברך אתך ויפרך וירבך והיית לקהל עמים׃ ");
INSERT INTO heb_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","ויתן לך את ברכת אברהם לך ולזרעך אתך לרשתך את ארץ מגריך אשר נתן אלהים לאברהם׃ ");
INSERT INTO heb_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","וישלח יצחק את יעקב וילך פדנה ארם אל לבן בן בתואל הארמי אחי רבקה אם יעקב ועשו׃ ");
INSERT INTO heb_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","וירא עשו כי ברך יצחק את יעקב ושלח אתו פדנה ארם לקחת לו משם אשה בברכו אתו ויצו עליו לאמר לא תקח אשה מבנות כנען׃ ");
INSERT INTO heb_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","וישמע יעקב אל אביו ואל אמו וילך פדנה ארם׃ ");
INSERT INTO heb_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","וירא עשו כי רעות בנות כנען בעיני יצחק אביו׃ ");
INSERT INTO heb_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","וילך עשו אל ישמעאל ויקח את מחלת בת ישמעאל בן אברהם אחות נביות על נשיו לו לאשה׃ ");
INSERT INTO heb_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","ויצא יעקב מבאר שבע וילך חרנה׃ ");
INSERT INTO heb_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","ויפגע במקום וילן שם כי בא השמש ויקח מאבני המקום וישם מראשתיו וישכב במקום ההוא׃ ");
INSERT INTO heb_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","ויחלם והנה סלם מצב ארצה וראשו מגיע השמימה והנה מלאכי אלהים עלים וירדים בו׃ ");
INSERT INTO heb_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","והנה יהוה נצב עליו ויאמר אני יהוה אלהי אברהם אביך ואלהי יצחק הארץ אשר אתה שכב עליה לך אתננה ולזרעך׃ ");
INSERT INTO heb_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","והיה זרעך כעפר הארץ ופרצת ימה וקדמה וצפנה ונגבה ונברכו בך כל משפחת האדמה ובזרעך׃ ");
INSERT INTO heb_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","והנה אנכי עמך ושמרתיך בכל אשר תלך והשבתיך אל האדמה הזאת כי לא אעזבך עד אשר אם עשיתי את אשר דברתי לך׃ ");
INSERT INTO heb_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","וייקץ יעקב משנתו ויאמר אכן יש יהוה במקום הזה ואנכי לא ידעתי׃ ");
INSERT INTO heb_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","ויירא ויאמר מה נורא המקום הזה אין זה כי אם בית אלהים וזה שער השמים׃ ");
INSERT INTO heb_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","וישכם יעקב בבקר ויקח את האבן אשר שם מראשתיו וישם אתה מצבה ויצק שמן על ראשה׃ ");
INSERT INTO heb_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","ויקרא את שם המקום ההוא בית אל ואולם לוז שם העיר לראשנה׃ ");
INSERT INTO heb_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","וידר יעקב נדר לאמר אם יהיה אלהים עמדי ושמרני בדרך הזה אשר אנכי הולך ונתן לי לחם לאכל ובגד ללבש׃ ");
INSERT INTO heb_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ושבתי בשלום אל בית אבי והיה יהוה לי לאלהים׃ ");
INSERT INTO heb_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","והאבן הזאת אשר שמתי מצבה יהיה בית אלהים וכל אשר תתן לי עשר אעשרנו לך׃ ");
INSERT INTO heb_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","וישא יעקב רגליו וילך ארצה בני קדם׃ ");
INSERT INTO heb_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","וירא והנה באר בשדה והנה שם שלשה עדרי צאן רבצים עליה כי מן הבאר ההוא ישקו העדרים והאבן גדלה על פי הבאר׃ ");
INSERT INTO heb_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","ונאספו שמה כל העדרים וגללו את האבן מעל פי הבאר והשקו את הצאן והשיבו את האבן על פי הבאר למקמה׃ ");
INSERT INTO heb_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","ויאמר להם יעקב אחי מאין אתם ויאמרו מחרן אנחנו׃ ");
INSERT INTO heb_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","ויאמר להם הידעתם את לבן בן נחור ויאמרו ידענו׃ ");
INSERT INTO heb_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","ויאמר להם השלום לו ויאמרו שלום והנה רחל בתו באה עם הצאן׃ ");
INSERT INTO heb_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","ויאמר הן עוד היום גדול לא עת האסף המקנה השקו הצאן ולכו רעו׃ ");
INSERT INTO heb_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","ויאמרו לא נוכל עד אשר יאספו כל העדרים וגללו את האבן מעל פי הבאר והשקינו הצאן׃ ");
INSERT INTO heb_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","עודנו מדבר עמם ורחל באה עם הצאן אשר לאביה כי רעה הוא׃ ");
INSERT INTO heb_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","ויהי כאשר ראה יעקב את רחל בת לבן אחי אמו ואת צאן לבן אחי אמו ויגש יעקב ויגל את האבן מעל פי הבאר וישק את צאן לבן אחי אמו׃ ");
INSERT INTO heb_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","וישק יעקב לרחל וישא את קלו ויבך׃ ");
INSERT INTO heb_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","ויגד יעקב לרחל כי אחי אביה הוא וכי בן רבקה הוא ותרץ ותגד לאביה׃ ");
INSERT INTO heb_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","ויהי כשמע לבן את שמע יעקב בן אחתו וירץ לקראתו ויחבק לו וינשק לו ויביאהו אל ביתו ויספר ללבן את כל הדברים האלה׃ ");
INSERT INTO heb_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","ויאמר לו לבן אך עצמי ובשרי אתה וישב עמו חדש ימים׃ ");
INSERT INTO heb_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","ויאמר לבן ליעקב הכי אחי אתה ועבדתני חנם הגידה לי מה משכרתך׃ ");
INSERT INTO heb_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","וללבן שתי בנות שם הגדלה לאה ושם הקטנה רחל׃ ");
INSERT INTO heb_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","ועיני לאה רכות ורחל היתה יפת תאר ויפת מראה׃ ");
INSERT INTO heb_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","ויאהב יעקב את רחל ויאמר אעבדך שבע שנים ברחל בתך הקטנה׃ ");
INSERT INTO heb_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","ויאמר לבן טוב תתי אתה לך מתתי אתה לאיש אחר שבה עמדי׃ ");
INSERT INTO heb_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","ויעבד יעקב ברחל שבע שנים ויהיו בעיניו כימים אחדים באהבתו אתה׃ ");
INSERT INTO heb_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","ויאמר יעקב אל לבן הבה את אשתי כי מלאו ימי ואבואה אליה׃ ");
INSERT INTO heb_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","ויאסף לבן את כל אנשי המקום ויעש משתה׃ ");
INSERT INTO heb_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","ויהי בערב ויקח את לאה בתו ויבא אתה אליו ויבא אליה׃ ");
INSERT INTO heb_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","ויתן לבן לה את זלפה שפחתו ללאה בתו שפחה׃ ");
INSERT INTO heb_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","ויהי בבקר והנה הוא לאה ויאמר אל לבן מה זאת עשית לי הלא ברחל עבדתי עמך ולמה רמיתני׃ ");
INSERT INTO heb_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","ויאמר לבן לא יעשה כן במקומנו לתת הצעירה לפני הבכירה׃ ");
INSERT INTO heb_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","מלא שבע זאת ונתנה לך גם את זאת בעבדה אשר תעבד עמדי עוד שבע שנים אחרות׃ ");
INSERT INTO heb_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","ויעש יעקב כן וימלא שבע זאת ויתן לו את רחל בתו לו לאשה׃ ");
INSERT INTO heb_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","ויתן לבן לרחל בתו את בלהה שפחתו לה לשפחה׃ ");
INSERT INTO heb_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","ויבא גם אל רחל ויאהב גם את רחל מלאה ויעבד עמו עוד שבע שנים אחרות׃ ");
INSERT INTO heb_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","וירא יהוה כי שנואה לאה ויפתח את רחמה ורחל עקרה׃ ");
INSERT INTO heb_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","ותהר לאה ותלד בן ותקרא שמו ראובן כי אמרה כי ראה יהוה בעניי כי עתה יאהבני אישי׃ ");
INSERT INTO heb_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","ותהר עוד ותלד בן ותאמר כי שמע יהוה כי שנואה אנכי ויתן לי גם את זה ותקרא שמו שמעון׃ ");
INSERT INTO heb_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","ותהר עוד ותלד בן ותאמר עתה הפעם ילוה אישי אלי כי ילדתי לו שלשה בנים על כן קרא שמו לוי׃ ");
INSERT INTO heb_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","ותהר עוד ותלד בן ותאמר הפעם אודה את יהוה על כן קראה שמו יהודה ותעמד מלדת׃ ");
INSERT INTO heb_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","ותרא רחל כי לא ילדה ליעקב ותקנא רחל באחתה ותאמר אל יעקב הבה לי בנים ואם אין מתה אנכי׃ ");
INSERT INTO heb_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","ויחר אף יעקב ברחל ויאמר התחת אלהים אנכי אשר מנע ממך פרי בטן׃ ");
INSERT INTO heb_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","ותאמר הנה אמתי בלהה בא אליה ותלד על ברכי ואבנה גם אנכי ממנה׃ ");
INSERT INTO heb_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","ותתן לו את בלהה שפחתה לאשה ויבא אליה יעקב׃ ");
INSERT INTO heb_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","ותהר בלהה ותלד ליעקב בן׃ ");
INSERT INTO heb_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","ותאמר רחל דנני אלהים וגם שמע בקלי ויתן לי בן על כן קראה שמו דן׃ ");
INSERT INTO heb_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","ותהר עוד ותלד בלהה שפחת רחל בן שני ליעקב׃ ");
INSERT INTO heb_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","ותאמר רחל נפתולי אלהים נפתלתי עם אחתי גם יכלתי ותקרא שמו נפתלי׃ ");
INSERT INTO heb_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","ותרא לאה כי עמדה מלדת ותקח את זלפה שפחתה ותתן אתה ליעקב לאשה׃ ");
INSERT INTO heb_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","ותלד זלפה שפחת לאה ליעקב בן׃ ");
INSERT INTO heb_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","ותאמר לאה בגד ותקרא את שמו גד׃ ");
INSERT INTO heb_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","ותלד זלפה שפחת לאה בן שני ליעקב׃ ");
INSERT INTO heb_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","ותאמר לאה באשרי כי אשרוני בנות ותקרא את שמו אשר׃ ");
INSERT INTO heb_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","וילך ראובן בימי קציר חטים וימצא דודאים בשדה ויבא אתם אל לאה אמו ותאמר רחל אל לאה תני נא לי מדודאי בנך׃ ");
INSERT INTO heb_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","ותאמר לה המעט קחתך את אישי ולקחת גם את דודאי בני ותאמר רחל לכן ישכב עמך הלילה תחת דודאי בנך׃ ");
INSERT INTO heb_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","ויבא יעקב מן השדה בערב ותצא לאה לקראתו ותאמר אלי תבוא כי שכר שכרתיך בדודאי בני וישכב עמה בלילה הוא׃ ");
INSERT INTO heb_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","וישמע אלהים אל לאה ותהר ותלד ליעקב בן חמישי׃ ");
INSERT INTO heb_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","ותאמר לאה נתן אלהים שכרי אשר נתתי שפחתי לאישי ותקרא שמו יששכר׃ ");
INSERT INTO heb_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","ותהר עוד לאה ותלד בן ששי ליעקב׃ ");
INSERT INTO heb_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","ותאמר לאה זבדני אלהים אתי זבד טוב הפעם יזבלני אישי כי ילדתי לו ששה בנים ותקרא את שמו זבלון׃ ");
INSERT INTO heb_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","ואחר ילדה בת ותקרא את שמה דינה׃ ");
INSERT INTO heb_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","ויזכר אלהים את רחל וישמע אליה אלהים ויפתח את רחמה׃ ");
INSERT INTO heb_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","ותהר ותלד בן ותאמר אסף אלהים את חרפתי׃ ");
INSERT INTO heb_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","ותקרא את שמו יוסף לאמר יסף יהוה לי בן אחר׃ ");
INSERT INTO heb_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","ויהי כאשר ילדה רחל את יוסף ויאמר יעקב אל לבן שלחני ואלכה אל מקומי ולארצי׃ ");
INSERT INTO heb_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","תנה את נשי ואת ילדי אשר עבדתי אתך בהן ואלכה כי אתה ידעת את עבדתי אשר עבדתיך׃ ");
INSERT INTO heb_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","ויאמר אליו לבן אם נא מצאתי חן בעיניך נחשתי ויברכני יהוה בגללך׃ ");
INSERT INTO heb_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","ויאמר נקבה שכרך עלי ואתנה׃ ");
INSERT INTO heb_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","ויאמר אליו אתה ידעת את אשר עבדתיך ואת אשר היה מקנך אתי׃ ");
INSERT INTO heb_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","כי מעט אשר היה לך לפני ויפרץ לרב ויברך יהוה אתך לרגלי ועתה מתי אעשה גם אנכי לביתי׃ ");
INSERT INTO heb_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","ויאמר מה אתן לך ויאמר יעקב לא תתן לי מאומה אם תעשה לי הדבר הזה אשובה ארעה צאנך אשמר׃ ");
INSERT INTO heb_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","אעבר בכל צאנך היום הסר משם כל שה נקד וטלוא וכל שה חום בכשבים וטלוא ונקד בעזים והיה שכרי׃ ");
INSERT INTO heb_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","וענתה בי צדקתי ביום מחר כי תבוא על שכרי לפניך כל אשר איננו נקד וטלוא בעזים וחום בכשבים גנוב הוא אתי׃ ");
INSERT INTO heb_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","ויאמר לבן הן לו יהי כדברך׃ ");
INSERT INTO heb_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","ויסר ביום ההוא את התישים העקדים והטלאים ואת כל העזים הנקדות והטלאת כל אשר לבן בו וכל חום בכשבים ויתן ביד בניו׃ ");
INSERT INTO heb_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","וישם דרך שלשת ימים בינו ובין יעקב ויעקב רעה את צאן לבן הנותרת׃ ");
INSERT INTO heb_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","ויקח לו יעקב מקל לבנה לח ולוז וערמון ויפצל בהן פצלות לבנות מחשף הלבן אשר על המקלות׃ ");
INSERT INTO heb_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","ויצג את המקלות אשר פצל ברהטים בשקתות המים אשר תבאן הצאן לשתות לנכח הצאן ויחמנה בבאן לשתות׃ ");
INSERT INTO heb_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","ויחמו הצאן אל המקלות ותלדן הצאן עקדים נקדים וטלאים׃ ");
INSERT INTO heb_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","והכשבים הפריד יעקב ויתן פני הצאן אל עקד וכל חום בצאן לבן וישת לו עדרים לבדו ולא שתם על צאן לבן׃ ");
INSERT INTO heb_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","והיה בכל יחם הצאן המקשרות ושם יעקב את המקלות לעיני הצאן ברהטים ליחמנה במקלות׃ ");
INSERT INTO heb_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","ובהעטיף הצאן לא ישים והיה העטפים ללבן והקשרים ליעקב׃ ");
INSERT INTO heb_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","ויפרץ האיש מאד מאד ויהי לו צאן רבות ושפחות ועבדים וגמלים וחמרים׃ ");
INSERT INTO heb_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","וישמע את דברי בני לבן לאמר לקח יעקב את כל אשר לאבינו ומאשר לאבינו עשה את כל הכבד הזה׃ ");
INSERT INTO heb_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","וירא יעקב את פני לבן והנה איננו עמו כתמול שלשום׃ ");
INSERT INTO heb_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","ויאמר יהוה אל יעקב שוב אל ארץ אבותיך ולמולדתך ואהיה עמך׃ ");
INSERT INTO heb_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","וישלח יעקב ויקרא לרחל וללאה השדה אל צאנו׃ ");
INSERT INTO heb_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","ויאמר להן ראה אנכי את פני אביכן כי איננו אלי כתמל שלשם ואלהי אבי היה עמדי׃ ");
INSERT INTO heb_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","ואתנה ידעתן כי בכל כחי עבדתי את אביכן׃ ");
INSERT INTO heb_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","ואביכן התל בי והחלף את משכרתי עשרת מנים ולא נתנו אלהים להרע עמדי׃ ");
INSERT INTO heb_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","אם כה יאמר נקדים יהיה שכרך וילדו כל הצאן נקדים ואם כה יאמר עקדים יהיה שכרך וילדו כל הצאן עקדים׃ ");
INSERT INTO heb_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","ויצל אלהים את מקנה אביכם ויתן לי׃ ");
INSERT INTO heb_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","ויהי בעת יחם הצאן ואשא עיני וארא בחלום והנה העתדים העלים על הצאן עקדים נקדים וברדים׃ ");
INSERT INTO heb_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","ויאמר אלי מלאך האלהים בחלום יעקב ואמר הנני׃ ");
INSERT INTO heb_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","ויאמר שא נא עיניך וראה כל העתדים העלים על הצאן עקדים נקדים וברדים כי ראיתי את כל אשר לבן עשה לך׃ ");
INSERT INTO heb_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","אנכי האל בית אל אשר משחת שם מצבה אשר נדרת לי שם נדר עתה קום צא מן הארץ הזאת ושוב אל ארץ מולדתך׃ ");
INSERT INTO heb_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","ותען רחל ולאה ותאמרנה לו העוד לנו חלק ונחלה בבית אבינו׃ ");
INSERT INTO heb_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","הלוא נכריות נחשבנו לו כי מכרנו ויאכל גם אכול את כספנו׃ ");
INSERT INTO heb_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","כי כל העשר אשר הציל אלהים מאבינו לנו הוא ולבנינו ועתה כל אשר אמר אלהים אליך עשה׃ ");
INSERT INTO heb_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","ויקם יעקב וישא את בניו ואת נשיו על הגמלים׃ ");
INSERT INTO heb_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","וינהג את כל מקנהו ואת כל רכשו אשר רכש מקנה קנינו אשר רכש בפדן ארם לבוא אל יצחק אביו ארצה כנען׃ ");
INSERT INTO heb_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","ולבן הלך לגזז את צאנו ותגנב רחל את התרפים אשר לאביה׃ ");
INSERT INTO heb_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","ויגנב יעקב את לב לבן הארמי על בלי הגיד לו כי ברח הוא׃ ");
INSERT INTO heb_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","ויברח הוא וכל אשר לו ויקם ויעבר את הנהר וישם את פניו הר הגלעד׃ ");
INSERT INTO heb_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","ויגד ללבן ביום השלישי כי ברח יעקב׃ ");
INSERT INTO heb_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","ויקח את אחיו עמו וירדף אחריו דרך שבעת ימים וידבק אתו בהר הגלעד׃ ");
INSERT INTO heb_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","ויבא אלהים אל לבן הארמי בחלם הלילה ויאמר לו השמר לך פן תדבר עם יעקב מטוב עד רע׃ ");
INSERT INTO heb_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","וישג לבן את יעקב ויעקב תקע את אהלו בהר ולבן תקע את אחיו בהר הגלעד׃ ");
INSERT INTO heb_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","ויאמר לבן ליעקב מה עשית ותגנב את לבבי ותנהג את בנתי כשביות חרב׃ ");
INSERT INTO heb_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","למה נחבאת לברח ותגנב אתי ולא הגדת לי ואשלחך בשמחה ובשרים בתף ובכנור׃ ");
INSERT INTO heb_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","ולא נטשתני לנשק לבני ולבנתי עתה הסכלת עשו׃ ");
INSERT INTO heb_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","יש לאל ידי לעשות עמכם רע ואלהי אביכם אמש אמר אלי לאמר השמר לך מדבר עם יעקב מטוב עד רע׃ ");
INSERT INTO heb_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","ועתה הלך הלכת כי נכסף נכספתה לבית אביך למה גנבת את אלהי׃ ");
INSERT INTO heb_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","ויען יעקב ויאמר ללבן כי יראתי כי אמרתי פן תגזל את בנותיך מעמי׃ ");
INSERT INTO heb_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","עם אשר תמצא את אלהיך לא יחיה נגד אחינו הכר לך מה עמדי וקח לך ולא ידע יעקב כי רחל גנבתם׃ ");
INSERT INTO heb_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","ויבא לבן באהל יעקב ובאהל לאה ובאהל שתי האמהת ולא מצא ויצא מאהל לאה ויבא באהל רחל׃ ");
INSERT INTO heb_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","ורחל לקחה את התרפים ותשמם בכר הגמל ותשב עליהם וימשש לבן את כל האהל ולא מצא׃ ");
INSERT INTO heb_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","ותאמר אל אביה אל יחר בעיני אדני כי לוא אוכל לקום מפניך כי דרך נשים לי ויחפש ולא מצא את התרפים׃ ");
INSERT INTO heb_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","ויחר ליעקב וירב בלבן ויען יעקב ויאמר ללבן מה פשעי מה חטאתי כי דלקת אחרי׃ ");
INSERT INTO heb_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","כי מששת את כל כלי מה מצאת מכל כלי ביתך שים כה נגד אחי ואחיך ויוכיחו בין שנינו׃ ");
INSERT INTO heb_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","זה עשרים שנה אנכי עמך רחליך ועזיך לא שכלו ואילי צאנך לא אכלתי׃ ");
INSERT INTO heb_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","טרפה לא הבאתי אליך אנכי אחטנה מידי תבקשנה גנבתי יום וגנבתי לילה׃ ");
INSERT INTO heb_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","הייתי ביום אכלני חרב וקרח בלילה ותדד שנתי מעיני׃ ");
INSERT INTO heb_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","זה לי עשרים שנה בביתך עבדתיך ארבע עשרה שנה בשתי בנתיך ושש שנים בצאנך ותחלף את משכרתי עשרת מנים׃ ");
INSERT INTO heb_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","לולי אלהי אבי אלהי אברהם ופחד יצחק היה לי כי עתה ריקם שלחתני את עניי ואת יגיע כפי ראה אלהים ויוכח אמש׃ ");
INSERT INTO heb_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","ויען לבן ויאמר אל יעקב הבנות בנתי והבנים בני והצאן צאני וכל אשר אתה ראה לי הוא ולבנתי מה אעשה לאלה היום או לבניהן אשר ילדו׃ ");
INSERT INTO heb_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","ועתה לכה נכרתה ברית אני ואתה והיה לעד ביני ובינך׃ ");
INSERT INTO heb_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","ויקח יעקב אבן וירימה מצבה׃ ");
INSERT INTO heb_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","ויאמר יעקב לאחיו לקטו אבנים ויקחו אבנים ויעשו גל ויאכלו שם על הגל׃ ");
INSERT INTO heb_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","ויקרא לו לבן יגר שהדותא ויעקב קרא לו גלעד׃ ");
INSERT INTO heb_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","ויאמר לבן הגל הזה עד ביני ובינך היום על כן קרא שמו גלעד׃ ");
INSERT INTO heb_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","והמצפה אשר אמר יצף יהוה ביני ובינך כי נסתר איש מרעהו׃ ");
INSERT INTO heb_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","אם תענה את בנתי ואם תקח נשים על בנתי אין איש עמנו ראה אלהים עד ביני ובינך׃ ");
INSERT INTO heb_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","ויאמר לבן ליעקב הנה הגל הזה והנה המצבה אשר יריתי ביני ובינך׃ ");
INSERT INTO heb_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","עד הגל הזה ועדה המצבה אם אני לא אעבר אליך את הגל הזה ואם אתה לא תעבר אלי את הגל הזה ואת המצבה הזאת לרעה׃ ");
INSERT INTO heb_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","אלהי אברהם ואלהי נחור ישפטו בינינו אלהי אביהם וישבע יעקב בפחד אביו יצחק׃ ");
INSERT INTO heb_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","ויזבח יעקב זבח בהר ויקרא לאחיו לאכל לחם ויאכלו לחם וילינו בהר׃ ");
INSERT INTO heb_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","וישכם לבן בבקר וינשק לבניו ולבנותיו ויברך אתהם וילך וישב לבן למקמו׃ ");
INSERT INTO heb_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","ויעקב הלך לדרכו ויפגעו בו מלאכי אלהים׃ ");
INSERT INTO heb_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","ויאמר יעקב כאשר ראם מחנה אלהים זה ויקרא שם המקום ההוא מחנים׃ ");
INSERT INTO heb_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","וישלח יעקב מלאכים לפניו אל עשו אחיו ארצה שעיר שדה אדום׃ ");
INSERT INTO heb_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","ויצו אתם לאמר כה תאמרון לאדני לעשו כה אמר עבדך יעקב עם לבן גרתי ואחר עד עתה׃ ");
INSERT INTO heb_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","ויהי לי שור וחמור צאן ועבד ושפחה ואשלחה להגיד לאדני למצא חן בעיניך׃ ");
INSERT INTO heb_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","וישבו המלאכים אל יעקב לאמר באנו אל אחיך אל עשו וגם הלך לקראתך וארבע מאות איש עמו׃ ");
INSERT INTO heb_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","ויירא יעקב מאד ויצר לו ויחץ את העם אשר אתו ואת הצאן ואת הבקר והגמלים לשני מחנות׃ ");
INSERT INTO heb_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","ויאמר אם יבוא עשו אל המחנה האחת והכהו והיה המחנה הנשאר לפליטה׃ ");
INSERT INTO heb_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","ויאמר יעקב אלהי אבי אברהם ואלהי אבי יצחק יהוה האמר אלי שוב לארצך ולמולדתך ואיטיבה עמך׃ ");
INSERT INTO heb_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","קטנתי מכל החסדים ומכל האמת אשר עשית את עבדך כי במקלי עברתי את הירדן הזה ועתה הייתי לשני מחנות׃ ");
INSERT INTO heb_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","הצילני נא מיד אחי מיד עשו כי ירא אנכי אתו פן יבוא והכני אם על בנים׃ ");
INSERT INTO heb_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","ואתה אמרת היטב איטיב עמך ושמתי את זרעך כחול הים אשר לא יספר מרב׃ ");
INSERT INTO heb_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","וילן שם בלילה ההוא ויקח מן הבא בידו מנחה לעשו אחיו׃ ");
INSERT INTO heb_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","עזים מאתים ותישים עשרים רחלים מאתים ואילים עשרים׃ ");
INSERT INTO heb_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","גמלים מיניקות ובניהם שלשים פרות ארבעים ופרים עשרה אתנת עשרים ועירם עשרה׃ ");
INSERT INTO heb_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","ויתן ביד עבדיו עדר עדר לבדו ויאמר אל עבדיו עברו לפני ורוח תשימו בין עדר ובין עדר׃ ");
INSERT INTO heb_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","ויצו את הראשון לאמר כי יפגשך עשו אחי ושאלך לאמר למי אתה ואנה תלך ולמי אלה לפניך׃ ");
INSERT INTO heb_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","ואמרת לעבדך ליעקב מנחה הוא שלוחה לאדני לעשו והנה גם הוא אחרינו׃ ");
INSERT INTO heb_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","ויצו גם את השני גם את השלישי גם את כל ההלכים אחרי העדרים לאמר כדבר הזה תדברון אל עשו במצאכם אתו׃ ");
INSERT INTO heb_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","ואמרתם גם הנה עבדך יעקב אחרינו כי אמר אכפרה פניו במנחה ההלכת לפני ואחרי כן אראה פניו אולי ישא פני׃ ");
INSERT INTO heb_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","ותעבר המנחה על פניו והוא לן בלילה ההוא במחנה׃ ");
INSERT INTO heb_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","ויקם בלילה הוא ויקח את שתי נשיו ואת שתי שפחתיו ואת אחד עשר ילדיו ויעבר את מעבר יבק׃ ");
INSERT INTO heb_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","ויקחם ויעברם את הנחל ויעבר את אשר לו׃ ");
INSERT INTO heb_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","ויותר יעקב לבדו ויאבק איש עמו עד עלות השחר׃ ");
INSERT INTO heb_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","וירא כי לא יכל לו ויגע בכף ירכו ותקע כף ירך יעקב בהאבקו עמו׃ ");
INSERT INTO heb_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","ויאמר שלחני כי עלה השחר ויאמר לא אשלחך כי אם ברכתני׃ ");
INSERT INTO heb_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","ויאמר אליו מה שמך ויאמר יעקב׃ ");
INSERT INTO heb_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","ויאמר לא יעקב יאמר עוד שמך כי אם ישראל כי שרית עם אלהים ועם אנשים ותוכל׃ ");
INSERT INTO heb_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","וישאל יעקב ויאמר הגידה נא שמך ויאמר למה זה תשאל לשמי ויברך אתו שם׃ ");
INSERT INTO heb_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","ויקרא יעקב שם המקום פניאל כי ראיתי אלהים פנים אל פנים ותנצל נפשי׃ ");
INSERT INTO heb_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","ויזרח לו השמש כאשר עבר את פנואל והוא צלע על ירכו׃ ");
INSERT INTO heb_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","על כן לא יאכלו בני ישראל את גיד הנשה אשר על כף הירך עד היום הזה כי נגע בכף ירך יעקב בגיד הנשה׃ ");
INSERT INTO heb_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","וישא יעקב עיניו וירא והנה עשו בא ועמו ארבע מאות איש ויחץ את הילדים על לאה ועל רחל ועל שתי השפחות׃ ");
INSERT INTO heb_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","וישם את השפחות ואת ילדיהן ראשנה ואת לאה וילדיה אחרנים ואת רחל ואת יוסף אחרנים׃ ");
INSERT INTO heb_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","והוא עבר לפניהם וישתחו ארצה שבע פעמים עד גשתו עד אחיו׃ ");
INSERT INTO heb_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","וירץ עשו לקראתו ויחבקהו ויפל על צוארו וישקהו ויבכו׃ ");
INSERT INTO heb_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","וישא את עיניו וירא את הנשים ואת הילדים ויאמר מי אלה לך ויאמר הילדים אשר חנן אלהים את עבדך׃ ");
INSERT INTO heb_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","ותגשן השפחות הנה וילדיהן ותשתחוין׃ ");
INSERT INTO heb_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","ותגש גם לאה וילדיה וישתחוו ואחר נגש יוסף ורחל וישתחוו׃ ");
INSERT INTO heb_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","ויאמר מי לך כל המחנה הזה אשר פגשתי ויאמר למצא חן בעיני אדני׃ ");
INSERT INTO heb_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","ויאמר עשו יש לי רב אחי יהי לך אשר לך׃ ");
INSERT INTO heb_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","ויאמר יעקב אל נא אם נא מצאתי חן בעיניך ולקחת מנחתי מידי כי על כן ראיתי פניך כראת פני אלהים ותרצני׃ ");
INSERT INTO heb_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","קח נא את ברכתי אשר הבאת לך כי חנני אלהים וכי יש לי כל ויפצר בו ויקח׃ ");
INSERT INTO heb_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","ויאמר נסעה ונלכה ואלכה לנגדך׃ ");
INSERT INTO heb_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","ויאמר אליו אדני ידע כי הילדים רכים והצאן והבקר עלות עלי ודפקום יום אחד ומתו כל הצאן׃ ");
INSERT INTO heb_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","יעבר נא אדני לפני עבדו ואני אתנהלה לאטי לרגל המלאכה אשר לפני ולרגל הילדים עד אשר אבא אל אדני שעירה׃ ");
INSERT INTO heb_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","ויאמר עשו אציגה נא עמך מן העם אשר אתי ויאמר למה זה אמצא חן בעיני אדני׃ ");
INSERT INTO heb_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","וישב ביום ההוא עשו לדרכו שעירה׃ ");
INSERT INTO heb_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","ויעקב נסע סכתה ויבן לו בית ולמקנהו עשה סכת על כן קרא שם המקום סכות׃ ");
INSERT INTO heb_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","ויבא יעקב שלם עיר שכם אשר בארץ כנען בבאו מפדן ארם ויחן את פני העיר׃ ");
INSERT INTO heb_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","ויקן את חלקת השדה אשר נטה שם אהלו מיד בני חמור אבי שכם במאה קשיטה׃ ");
INSERT INTO heb_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","ויצב שם מזבח ויקרא לו אל אלהי ישראל׃ ");
INSERT INTO heb_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","ותצא דינה בת לאה אשר ילדה ליעקב לראות בבנות הארץ׃ ");
INSERT INTO heb_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","וירא אתה שכם בן חמור החוי נשיא הארץ ויקח אתה וישכב אתה ויענה׃ ");
INSERT INTO heb_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","ותדבק נפשו בדינה בת יעקב ויאהב את הנער וידבר על לב הנער׃ ");
INSERT INTO heb_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","ויאמר שכם אל חמור אביו לאמר קח לי את הילדה הזאת לאשה׃ ");
INSERT INTO heb_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","ויעקב שמע כי טמא את דינה בתו ובניו היו את מקנהו בשדה והחרש יעקב עד באם׃ ");
INSERT INTO heb_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","ויצא חמור אבי שכם אל יעקב לדבר אתו׃ ");
INSERT INTO heb_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","ובני יעקב באו מן השדה כשמעם ויתעצבו האנשים ויחר להם מאד כי נבלה עשה בישראל לשכב את בת יעקב וכן לא יעשה׃ ");
INSERT INTO heb_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","וידבר חמור אתם לאמר שכם בני חשקה נפשו בבתכם תנו נא אתה לו לאשה׃ ");
INSERT INTO heb_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","והתחתנו אתנו בנתיכם תתנו לנו ואת בנתינו תקחו לכם׃ ");
INSERT INTO heb_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","ואתנו תשבו והארץ תהיה לפניכם שבו וסחרוה והאחזו בה׃ ");
INSERT INTO heb_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","ויאמר שכם אל אביה ואל אחיה אמצא חן בעיניכם ואשר תאמרו אלי אתן׃ ");
INSERT INTO heb_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","הרבו עלי מאד מהר ומתן ואתנה כאשר תאמרו אלי ותנו לי את הנער לאשה׃ ");
INSERT INTO heb_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","ויענו בני יעקב את שכם ואת חמור אביו במרמה וידברו אשר טמא את דינה אחתם׃ ");
INSERT INTO heb_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","ויאמרו אליהם לא נוכל לעשות הדבר הזה לתת את אחתנו לאיש אשר לו ערלה כי חרפה הוא לנו׃ ");
INSERT INTO heb_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","אך בזאת נאות לכם אם תהיו כמנו להמל לכם כל זכר׃ ");
INSERT INTO heb_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","ונתנו את בנתינו לכם ואת בנתיכם נקח לנו וישבנו אתכם והיינו לעם אחד׃ ");
INSERT INTO heb_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","ואם לא תשמעו אלינו להמול ולקחנו את בתנו והלכנו׃ ");
INSERT INTO heb_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","וייטבו דבריהם בעיני חמור ובעיני שכם בן חמור׃ ");
INSERT INTO heb_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","ולא אחר הנער לעשות הדבר כי חפץ בבת יעקב והוא נכבד מכל בית אביו׃ ");
INSERT INTO heb_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","ויבא חמור ושכם בנו אל שער עירם וידברו אל אנשי עירם לאמר׃ ");
INSERT INTO heb_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","האנשים האלה שלמים הם אתנו וישבו בארץ ויסחרו אתה והארץ הנה רחבת ידים לפניהם את בנתם נקח לנו לנשים ואת בנתינו נתן להם׃ ");
INSERT INTO heb_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","אך בזאת יאתו לנו האנשים לשבת אתנו להיות לעם אחד בהמול לנו כל זכר כאשר הם נמלים׃ ");
INSERT INTO heb_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","מקנהם וקנינם וכל בהמתם הלוא לנו הם אך נאותה להם וישבו אתנו׃ ");
INSERT INTO heb_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","וישמעו אל חמור ואל שכם בנו כל יצאי שער עירו וימלו כל זכר כל יצאי שער עירו׃ ");
INSERT INTO heb_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","ויהי ביום השלישי בהיותם כאבים ויקחו שני בני יעקב שמעון ולוי אחי דינה איש חרבו ויבאו על העיר בטח ויהרגו כל זכר׃ ");
INSERT INTO heb_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","ואת חמור ואת שכם בנו הרגו לפי חרב ויקחו את דינה מבית שכם ויצאו׃ ");
INSERT INTO heb_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","בני יעקב באו על החללים ויבזו העיר אשר טמאו אחותם׃ ");
INSERT INTO heb_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","את צאנם ואת בקרם ואת חמריהם ואת אשר בעיר ואת אשר בשדה לקחו׃ ");
INSERT INTO heb_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","ואת כל חילם ואת כל טפם ואת נשיהם שבו ויבזו ואת כל אשר בבית׃ ");
INSERT INTO heb_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","ויאמר יעקב אל שמעון ואל לוי עכרתם אתי להבאישני בישב הארץ בכנעני ובפרזי ואני מתי מספר ונאספו עלי והכוני ונשמדתי אני וביתי׃ ");
INSERT INTO heb_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","ויאמרו הכזונה יעשה את אחותנו׃ ");
INSERT INTO heb_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","ויאמר אלהים אל יעקב קום עלה בית אל ושב שם ועשה שם מזבח לאל הנראה אליך בברחך מפני עשו אחיך׃ ");
INSERT INTO heb_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","ויאמר יעקב אל ביתו ואל כל אשר עמו הסרו את אלהי הנכר אשר בתככם והטהרו והחליפו שמלתיכם׃ ");
INSERT INTO heb_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","ונקומה ונעלה בית אל ואעשה שם מזבח לאל הענה אתי ביום צרתי ויהי עמדי בדרך אשר הלכתי׃ ");
INSERT INTO heb_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","ויתנו אל יעקב את כל אלהי הנכר אשר בידם ואת הנזמים אשר באזניהם ויטמן אתם יעקב תחת האלה אשר עם שכם׃ ");
INSERT INTO heb_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","ויסעו ויהי חתת אלהים על הערים אשר סביבתיהם ולא רדפו אחרי בני יעקב׃ ");
INSERT INTO heb_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","ויבא יעקב לוזה אשר בארץ כנען הוא בית אל הוא וכל העם אשר עמו׃ ");
INSERT INTO heb_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","ויבן שם מזבח ויקרא למקום אל בית אל כי שם נגלו אליו האלהים בברחו מפני אחיו׃ ");
INSERT INTO heb_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","ותמת דברה מינקת רבקה ותקבר מתחת לבית אל תחת האלון ויקרא שמו אלון בכות׃ ");
INSERT INTO heb_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","וירא אלהים אל יעקב עוד בבאו מפדן ארם ויברך אתו׃ ");
INSERT INTO heb_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","ויאמר לו אלהים שמך יעקב לא יקרא שמך עוד יעקב כי אם ישראל יהיה שמך ויקרא את שמו ישראל׃ ");
INSERT INTO heb_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","ויאמר לו אלהים אני אל שדי פרה ורבה גוי וקהל גוים יהיה ממך ומלכים מחלציך יצאו׃ ");
INSERT INTO heb_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","ואת הארץ אשר נתתי לאברהם וליצחק לך אתננה ולזרעך אחריך אתן את הארץ׃ ");
INSERT INTO heb_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","ויעל מעליו אלהים במקום אשר דבר אתו׃ ");
INSERT INTO heb_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","ויצב יעקב מצבה במקום אשר דבר אתו מצבת אבן ויסך עליה נסך ויצק עליה שמן׃ ");
INSERT INTO heb_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","ויקרא יעקב את שם המקום אשר דבר אתו שם אלהים בית אל׃ ");
INSERT INTO heb_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","ויסעו מבית אל ויהי עוד כברת הארץ לבוא אפרתה ותלד רחל ותקש בלדתה׃ ");
INSERT INTO heb_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","ויהי בהקשתה בלדתה ותאמר לה המילדת אל תיראי כי גם זה לך בן׃ ");
INSERT INTO heb_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","ויהי בצאת נפשה כי מתה ותקרא שמו בן אוני ואביו קרא לו בנימין׃ ");
INSERT INTO heb_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","ותמת רחל ותקבר בדרך אפרתה הוא בית לחם׃ ");
INSERT INTO heb_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","ויצב יעקב מצבה על קברתה הוא מצבת קברת רחל עד היום׃ ");
INSERT INTO heb_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","ויסע ישראל ויט אהלה מהלאה למגדל עדר׃ ");
INSERT INTO heb_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","ויהי בשכן ישראל בארץ ההוא וילך ראובן וישכב את בלהה פילגש אביו וישמע ישראל ויהיו בני יעקב שנים עשר׃ ");
INSERT INTO heb_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","בני לאה בכור יעקב ראובן ושמעון ולוי ויהודה ויששכר וזבלון׃ ");
INSERT INTO heb_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","בני רחל יוסף ובנימן׃ ");
INSERT INTO heb_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","ובני בלהה שפחת רחל דן ונפתלי׃ ");
INSERT INTO heb_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","ובני זלפה שפחת לאה גד ואשר אלה בני יעקב אשר ילד לו בפדן ארם׃ ");
INSERT INTO heb_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","ויבא יעקב אל יצחק אביו ממרא קרית הארבע הוא חברון אשר גר שם אברהם ויצחק׃ ");
INSERT INTO heb_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","ויהיו ימי יצחק מאת שנה ושמנים שנה׃ ");
INSERT INTO heb_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","ויגוע יצחק וימת ויאסף אל עמיו זקן ושבע ימים ויקברו אתו עשו ויעקב בניו׃ ");
INSERT INTO heb_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","ואלה תלדות עשו הוא אדום׃ ");
INSERT INTO heb_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","עשו לקח את נשיו מבנות כנען את עדה בת אילון החתי ואת אהליבמה בת ענה בת צבעון החוי׃ ");
INSERT INTO heb_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","ואת בשמת בת ישמעאל אחות נביות׃ ");
INSERT INTO heb_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","ותלד עדה לעשו את אליפז ובשמת ילדה את רעואל׃ ");
INSERT INTO heb_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","ואהליבמה ילדה את יעיש ואת יעלם ואת קרח אלה בני עשו אשר ילדו לו בארץ כנען׃ ");
INSERT INTO heb_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","ויקח עשו את נשיו ואת בניו ואת בנתיו ואת כל נפשות ביתו ואת מקנהו ואת כל בהמתו ואת כל קנינו אשר רכש בארץ כנען וילך אל ארץ מפני יעקב אחיו׃ ");
INSERT INTO heb_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","כי היה רכושם רב משבת יחדו ולא יכלה ארץ מגוריהם לשאת אתם מפני מקניהם׃ ");
INSERT INTO heb_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","וישב עשו בהר שעיר עשו הוא אדום׃ ");
INSERT INTO heb_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","ואלה תלדות עשו אבי אדום בהר שעיר׃ ");
INSERT INTO heb_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","אלה שמות בני עשו אליפז בן עדה אשת עשו רעואל בן בשמת אשת עשו׃ ");
INSERT INTO heb_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","ויהיו בני אליפז תימן אומר צפו וגעתם וקנז׃ ");
INSERT INTO heb_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","ותמנע היתה פילגש לאליפז בן עשו ותלד לאליפז את עמלק אלה בני עדה אשת עשו׃ ");
INSERT INTO heb_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","ואלה בני רעואל נחת וזרח שמה ומזה אלה היו בני בשמת אשת עשו׃ ");
INSERT INTO heb_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","ואלה היו בני אהליבמה בת ענה בת צבעון אשת עשו ותלד לעשו את יעיש ואת יעלם ואת קרח׃ ");
INSERT INTO heb_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","אלה אלופי בני עשו בני אליפז בכור עשו אלוף תימן אלוף אומר אלוף צפו אלוף קנז׃ ");
INSERT INTO heb_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","אלוף קרח אלוף געתם אלוף עמלק אלה אלופי אליפז בארץ אדום אלה בני עדה׃ ");
INSERT INTO heb_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","ואלה בני רעואל בן עשו אלוף נחת אלוף זרח אלוף שמה אלוף מזה אלה אלופי רעואל בארץ אדום אלה בני בשמת אשת עשו׃ ");
INSERT INTO heb_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","ואלה בני אהליבמה אשת עשו אלוף יעוש אלוף יעלם אלוף קרח אלה אלופי אהליבמה בת ענה אשת עשו׃ ");
INSERT INTO heb_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","אלה בני עשו ואלה אלופיהם הוא אדום׃ ");
INSERT INTO heb_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","אלה בני שעיר החרי ישבי הארץ לוטן ושובל וצבעון וענה׃ ");
INSERT INTO heb_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","ודשון ואצר ודישן אלה אלופי החרי בני שעיר בארץ אדום׃ ");
INSERT INTO heb_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","ויהיו בני לוטן חרי והימם ואחות לוטן תמנע׃ ");
INSERT INTO heb_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","ואלה בני שובל עלון ומנחת ועיבל שפו ואונם׃ ");
INSERT INTO heb_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","ואלה בני צבעון ואיה וענה הוא ענה אשר מצא את הימם במדבר ברעתו את החמרים לצבעון אביו׃ ");
INSERT INTO heb_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","ואלה בני ענה דשן ואהליבמה בת ענה׃ ");
INSERT INTO heb_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","ואלה בני דישן חמדן ואשבן ויתרן וכרן׃ ");
INSERT INTO heb_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","אלה בני אצר בלהן וזעון ועקן׃ ");
INSERT INTO heb_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","אלה בני דישן עוץ וארן׃ ");
INSERT INTO heb_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","אלה אלופי החרי אלוף לוטן אלוף שובל אלוף צבעון אלוף ענה׃ ");
INSERT INTO heb_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","אלוף דשן אלוף אצר אלוף דישן אלה אלופי החרי לאלפיהם בארץ שעיר׃ ");
INSERT INTO heb_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","ואלה המלכים אשר מלכו בארץ אדום לפני מלך מלך לבני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","וימלך באדום בלע בן בעור ושם עירו דנהבה׃ ");
INSERT INTO heb_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","וימת בלע וימלך תחתיו יובב בן זרח מבצרה׃ ");
INSERT INTO heb_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","וימת יובב וימלך תחתיו חשם מארץ התימני׃ ");
INSERT INTO heb_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","וימת חשם וימלך תחתיו הדד בן בדד המכה את מדין בשדה מואב ושם עירו עוית׃ ");
INSERT INTO heb_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","וימת הדד וימלך תחתיו שמלה ממשרקה׃ ");
INSERT INTO heb_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","וימת שמלה וימלך תחתיו שאול מרחבות הנהר׃ ");
INSERT INTO heb_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","וימת שאול וימלך תחתיו בעל חנן בן עכבור׃ ");
INSERT INTO heb_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","וימת בעל חנן בן עכבור וימלך תחתיו הדר ושם עירו פעו ושם אשתו מהיטבאל בת מטרד בת מי זהב׃ ");
INSERT INTO heb_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","ואלה שמות אלופי עשו למשפחתם למקמתם בשמתם אלוף תמנע אלוף עלוה אלוף יתת׃ ");
INSERT INTO heb_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","אלוף אהליבמה אלוף אלה אלוף פינן׃ ");
INSERT INTO heb_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","אלוף קנז אלוף תימן אלוף מבצר׃ ");
INSERT INTO heb_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","אלוף מגדיאל אלוף עירם אלה אלופי אדום למשבתם בארץ אחזתם הוא עשו אבי אדום׃ ");
INSERT INTO heb_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","וישב יעקב בארץ מגורי אביו בארץ כנען׃ ");
INSERT INTO heb_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","אלה תלדות יעקב יוסף בן שבע עשרה שנה היה רעה את אחיו בצאן והוא נער את בני בלהה ואת בני זלפה נשי אביו ויבא יוסף את דבתם רעה אל אביהם׃ ");
INSERT INTO heb_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","וישראל אהב את יוסף מכל בניו כי בן זקנים הוא לו ועשה לו כתנת פסים׃ ");
INSERT INTO heb_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","ויראו אחיו כי אתו אהב אביהם מכל אחיו וישנאו אתו ולא יכלו דברו לשלם׃ ");
INSERT INTO heb_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","ויחלם יוסף חלום ויגד לאחיו ויוספו עוד שנא אתו׃ ");
INSERT INTO heb_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","ויאמר אליהם שמעו נא החלום הזה אשר חלמתי׃ ");
INSERT INTO heb_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","והנה אנחנו מאלמים אלמים בתוך השדה והנה קמה אלמתי וגם נצבה והנה תסבינה אלמתיכם ותשתחוין לאלמתי׃ ");
INSERT INTO heb_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","ויאמרו לו אחיו המלך תמלך עלינו אם משול תמשל בנו ויוספו עוד שנא אתו על חלמתיו ועל דבריו׃ ");
INSERT INTO heb_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","ויחלם עוד חלום אחר ויספר אתו לאחיו ויאמר הנה חלמתי חלום עוד והנה השמש והירח ואחד עשר כוכבים משתחוים לי׃ ");
INSERT INTO heb_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","ויספר אל אביו ואל אחיו ויגער בו אביו ויאמר לו מה החלום הזה אשר חלמת הבוא נבוא אני ואמך ואחיך להשתחות לך ארצה׃ ");
INSERT INTO heb_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","ויקנאו בו אחיו ואביו שמר את הדבר׃ ");
INSERT INTO heb_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","וילכו אחיו לרעות את צאן אביהם בשכם׃ ");
INSERT INTO heb_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","ויאמר ישראל אל יוסף הלוא אחיך רעים בשכם לכה ואשלחך אליהם ויאמר לו הנני׃ ");
INSERT INTO heb_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","ויאמר לו לך נא ראה את שלום אחיך ואת שלום הצאן והשבני דבר וישלחהו מעמק חברון ויבא שכמה׃ ");
INSERT INTO heb_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","וימצאהו איש והנה תעה בשדה וישאלהו האיש לאמר מה תבקש׃ ");
INSERT INTO heb_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","ויאמר את אחי אנכי מבקש הגידה נא לי איפה הם רעים׃ ");
INSERT INTO heb_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","ויאמר האיש נסעו מזה כי שמעתי אמרים נלכה דתינה וילך יוסף אחר אחיו וימצאם בדתן׃ ");
INSERT INTO heb_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","ויראו אתו מרחק ובטרם יקרב אליהם ויתנכלו אתו להמיתו׃ ");
INSERT INTO heb_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","ויאמרו איש אל אחיו הנה בעל החלמות הלזה בא׃ ");
INSERT INTO heb_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","ועתה לכו ונהרגהו ונשלכהו באחד הברות ואמרנו חיה רעה אכלתהו ונראה מה יהיו חלמתיו׃ ");
INSERT INTO heb_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","וישמע ראובן ויצלהו מידם ויאמר לא נכנו נפש׃ ");
INSERT INTO heb_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","ויאמר אלהם ראובן אל תשפכו דם השליכו אתו אל הבור הזה אשר במדבר ויד אל תשלחו בו למען הציל אתו מידם להשיבו אל אביו׃ ");
INSERT INTO heb_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","ויהי כאשר בא יוסף אל אחיו ויפשיטו את יוסף את כתנתו את כתנת הפסים אשר עליו׃ ");
INSERT INTO heb_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","ויקחהו וישלכו אתו הברה והבור רק אין בו מים׃ ");
INSERT INTO heb_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","וישבו לאכל לחם וישאו עיניהם ויראו והנה ארחת ישמעאלים באה מגלעד וגמליהם נשאים נכאת וצרי ולט הולכים להוריד מצרימה׃ ");
INSERT INTO heb_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","ויאמר יהודה אל אחיו מה בצע כי נהרג את אחינו וכסינו את דמו׃ ");
INSERT INTO heb_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","לכו ונמכרנו לישמעאלים וידנו אל תהי בו כי אחינו בשרנו הוא וישמעו אחיו׃ ");
INSERT INTO heb_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","ויעברו אנשים מדינים סחרים וימשכו ויעלו את יוסף מן הבור וימכרו את יוסף לישמעאלים בעשרים כסף ויביאו את יוסף מצרימה׃ ");
INSERT INTO heb_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","וישב ראובן אל הבור והנה אין יוסף בבור ויקרע את בגדיו׃ ");
INSERT INTO heb_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","וישב אל אחיו ויאמר הילד איננו ואני אנה אני בא׃ ");
INSERT INTO heb_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","ויקחו את כתנת יוסף וישחטו שעיר עזים ויטבלו את הכתנת בדם׃ ");
INSERT INTO heb_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","וישלחו את כתנת הפסים ויביאו אל אביהם ויאמרו זאת מצאנו הכר נא הכתנת בנך הוא אם לא׃ ");
INSERT INTO heb_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","ויכירה ויאמר כתנת בני חיה רעה אכלתהו טרף טרף יוסף׃ ");
INSERT INTO heb_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","ויקרע יעקב שמלתיו וישם שק במתניו ויתאבל על בנו ימים רבים׃ ");
INSERT INTO heb_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","ויקמו כל בניו וכל בנתיו לנחמו וימאן להתנחם ויאמר כי ארד אל בני אבל שאלה ויבך אתו אביו׃ ");
INSERT INTO heb_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","והמדנים מכרו אתו אל מצרים לפוטיפר סריס פרעה שר הטבחים׃ ");
INSERT INTO heb_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","ויהי בעת ההוא וירד יהודה מאת אחיו ויט עד איש עדלמי ושמו חירה׃ ");
INSERT INTO heb_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","וירא שם יהודה בת איש כנעני ושמו שוע ויקחה ויבא אליה׃ ");
INSERT INTO heb_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","ותהר ותלד בן ויקרא את שמו ער׃ ");
INSERT INTO heb_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","ותהר עוד ותלד בן ותקרא את שמו אונן׃ ");
INSERT INTO heb_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","ותסף עוד ותלד בן ותקרא את שמו שלה והיה בכזיב בלדתה אתו׃ ");
INSERT INTO heb_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","ויקח יהודה אשה לער בכורו ושמה תמר׃ ");
INSERT INTO heb_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","ויהי ער בכור יהודה רע בעיני יהוה וימתהו יהוה׃ ");
INSERT INTO heb_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","ויאמר יהודה לאונן בא אל אשת אחיך ויבם אתה והקם זרע לאחיך׃ ");
INSERT INTO heb_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","וידע אונן כי לא לו יהיה הזרע והיה אם בא אל אשת אחיו ושחת ארצה לבלתי נתן זרע לאחיו׃ ");
INSERT INTO heb_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","וירע בעיני יהוה אשר עשה וימת גם אתו׃ ");
INSERT INTO heb_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","ויאמר יהודה לתמר כלתו שבי אלמנה בית אביך עד יגדל שלה בני כי אמר פן ימות גם הוא כאחיו ותלך תמר ותשב בית אביה׃ ");
INSERT INTO heb_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","וירבו הימים ותמת בת שוע אשת יהודה וינחם יהודה ויעל על גזזי צאנו הוא וחירה רעהו העדלמי תמנתה׃ ");
INSERT INTO heb_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","ויגד לתמר לאמר הנה חמיך עלה תמנתה לגז צאנו׃ ");
INSERT INTO heb_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","ותסר בגדי אלמנותה מעליה ותכס בצעיף ותתעלף ותשב בפתח עינים אשר על דרך תמנתה כי ראתה כי גדל שלה והוא לא נתנה לו לאשה׃ ");
INSERT INTO heb_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","ויראה יהודה ויחשבה לזונה כי כסתה פניה׃ ");
INSERT INTO heb_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","ויט אליה אל הדרך ויאמר הבה נא אבוא אליך כי לא ידע כי כלתו הוא ותאמר מה תתן לי כי תבוא אלי׃ ");
INSERT INTO heb_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","ויאמר אנכי אשלח גדי עזים מן הצאן ותאמר אם תתן ערבון עד שלחך׃ ");
INSERT INTO heb_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","ויאמר מה הערבון אשר אתן לך ותאמר חתמך ופתילך ומטך אשר בידך ויתן לה ויבא אליה ותהר לו׃ ");
INSERT INTO heb_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","ותקם ותלך ותסר צעיפה מעליה ותלבש בגדי אלמנותה׃ ");
INSERT INTO heb_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","וישלח יהודה את גדי העזים ביד רעהו העדלמי לקחת הערבון מיד האשה ולא מצאה׃ ");
INSERT INTO heb_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","וישאל את אנשי מקמה לאמר איה הקדשה הוא בעינים על הדרך ויאמרו לא היתה בזה קדשה׃ ");
INSERT INTO heb_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","וישב אל יהודה ויאמר לא מצאתיה וגם אנשי המקום אמרו לא היתה בזה קדשה׃ ");
INSERT INTO heb_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","ויאמר יהודה תקח לה פן נהיה לבוז הנה שלחתי הגדי הזה ואתה לא מצאתה׃ ");
INSERT INTO heb_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","ויהי כמשלש חדשים ויגד ליהודה לאמר זנתה תמר כלתך וגם הנה הרה לזנונים ויאמר יהודה הוציאוה ותשרף׃ ");
INSERT INTO heb_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","הוא מוצאת והיא שלחה אל חמיה לאמר לאיש אשר אלה לו אנכי הרה ותאמר הכר נא למי החתמת והפתילים והמטה האלה׃ ");
INSERT INTO heb_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","ויכר יהודה ויאמר צדקה ממני כי על כן לא נתתיה לשלה בני ולא יסף עוד לדעתה׃ ");
INSERT INTO heb_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","ויהי בעת לדתה והנה תאומים בבטנה׃ ");
INSERT INTO heb_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","ויהי בלדתה ויתן יד ותקח המילדת ותקשר על ידו שני לאמר זה יצא ראשנה׃ ");
INSERT INTO heb_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","ויהי כמשיב ידו והנה יצא אחיו ותאמר מה פרצת עליך פרץ ויקרא שמו פרץ׃ ");
INSERT INTO heb_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","ואחר יצא אחיו אשר על ידו השני ויקרא שמו זרח׃ ");
INSERT INTO heb_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","ויוסף הורד מצרימה ויקנהו פוטיפר סריס פרעה שר הטבחים איש מצרי מיד הישמעאלים אשר הורדהו שמה׃ ");
INSERT INTO heb_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","ויהי יהוה את יוסף ויהי איש מצליח ויהי בבית אדניו המצרי׃ ");
INSERT INTO heb_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","וירא אדניו כי יהוה אתו וכל אשר הוא עשה יהוה מצליח בידו׃ ");
INSERT INTO heb_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","וימצא יוסף חן בעיניו וישרת אתו ויפקדהו על ביתו וכל יש לו נתן בידו׃ ");
INSERT INTO heb_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","ויהי מאז הפקיד אתו בביתו ועל כל אשר יש לו ויברך יהוה את בית המצרי בגלל יוסף ויהי ברכת יהוה בכל אשר יש לו בבית ובשדה׃ ");
INSERT INTO heb_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","ויעזב כל אשר לו ביד יוסף ולא ידע אתו מאומה כי אם הלחם אשר הוא אוכל ויהי יוסף יפה תאר ויפה מראה׃ ");
INSERT INTO heb_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","ויהי אחר הדברים האלה ותשא אשת אדניו את עיניה אל יוסף ותאמר שכבה עמי׃ ");
INSERT INTO heb_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","וימאן ויאמר אל אשת אדניו הן אדני לא ידע אתי מה בבית וכל אשר יש לו נתן בידי׃ ");
INSERT INTO heb_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","איננו גדול בבית הזה ממני ולא חשך ממני מאומה כי אם אותך באשר את אשתו ואיך אעשה הרעה הגדלה הזאת וחטאתי לאלהים׃ ");
INSERT INTO heb_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","ויהי כדברה אל יוסף יום יום ולא שמע אליה לשכב אצלה להיות עמה׃ ");
INSERT INTO heb_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","ויהי כהיום הזה ויבא הביתה לעשות מלאכתו ואין איש מאנשי הבית שם בבית׃ ");
INSERT INTO heb_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","ותתפשהו בבגדו לאמר שכבה עמי ויעזב בגדו בידה וינס ויצא החוצה׃ ");
INSERT INTO heb_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","ויהי כראותה כי עזב בגדו בידה וינס החוצה׃ ");
INSERT INTO heb_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","ותקרא לאנשי ביתה ותאמר להם לאמר ראו הביא לנו איש עברי לצחק בנו בא אלי לשכב עמי ואקרא בקול גדול׃ ");
INSERT INTO heb_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","ויהי כשמעו כי הרימתי קולי ואקרא ויעזב בגדו אצלי וינס ויצא החוצה׃ ");
INSERT INTO heb_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","ותנח בגדו אצלה עד בוא אדניו אל ביתו׃ ");
INSERT INTO heb_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","ותדבר אליו כדברים האלה לאמר בא אלי העבד העברי אשר הבאת לנו לצחק בי׃ ");
INSERT INTO heb_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","ויהי כהרימי קולי ואקרא ויעזב בגדו אצלי וינס החוצה׃ ");
INSERT INTO heb_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","ויהי כשמע אדניו את דברי אשתו אשר דברה אליו לאמר כדברים האלה עשה לי עבדך ויחר אפו׃ ");
INSERT INTO heb_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","ויקח אדני יוסף אתו ויתנהו אל בית הסהר מקום אשר אסורי המלך אסורים ויהי שם בבית הסהר׃ ");
INSERT INTO heb_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","ויהי יהוה את יוסף ויט אליו חסד ויתן חנו בעיני שר בית הסהר׃ ");
INSERT INTO heb_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","ויתן שר בית הסהר ביד יוסף את כל האסירם אשר בבית הסהר ואת כל אשר עשים שם הוא היה עשה׃ ");
INSERT INTO heb_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","אין שר בית הסהר ראה את כל מאומה בידו באשר יהוה אתו ואשר הוא עשה יהוה מצליח׃ ");
INSERT INTO heb_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","ויהי אחר הדברים האלה חטאו משקה מלך מצרים והאפה לאדניהם למלך מצרים׃ ");
INSERT INTO heb_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","ויקצף פרעה על שני סריסיו על שר המשקים ועל שר האופים׃ ");
INSERT INTO heb_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","ויתן אתם במשמר בית שר הטבחים אל בית הסהר מקום אשר יוסף אסור שם׃ ");
INSERT INTO heb_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","ויפקד שר הטבחים את יוסף אתם וישרת אתם ויהיו ימים במשמר׃ ");
INSERT INTO heb_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","ויחלמו חלום שניהם איש חלמו בלילה אחד איש כפתרון חלמו המשקה והאפה אשר למלך מצרים אשר אסורים בבית הסהר׃ ");
INSERT INTO heb_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","ויבא אליהם יוסף בבקר וירא אתם והנם זעפים׃ ");
INSERT INTO heb_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","וישאל את סריסי פרעה אשר אתו במשמר בית אדניו לאמר מדוע פניכם רעים היום׃ ");
INSERT INTO heb_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","ויאמרו אליו חלום חלמנו ופתר אין אתו ויאמר אלהם יוסף הלוא לאלהים פתרנים ספרו נא לי׃ ");
INSERT INTO heb_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","ויספר שר המשקים את חלמו ליוסף ויאמר לו בחלומי והנה גפן לפני׃ ");
INSERT INTO heb_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","ובגפן שלשה שריגם והיא כפרחת עלתה נצה הבשילו אשכלתיה ענבים׃ ");
INSERT INTO heb_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","וכוס פרעה בידי ואקח את הענבים ואשחט אתם אל כוס פרעה ואתן את הכוס על כף פרעה׃ ");
INSERT INTO heb_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","ויאמר לו יוסף זה פתרנו שלשת השרגים שלשת ימים הם׃ ");
INSERT INTO heb_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","בעוד שלשת ימים ישא פרעה את ראשך והשיבך על כנך ונתת כוס פרעה בידו כמשפט הראשון אשר היית משקהו׃ ");
INSERT INTO heb_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","כי אם זכרתני אתך כאשר ייטב לך ועשית נא עמדי חסד והזכרתני אל פרעה והוצאתני מן הבית הזה׃ ");
INSERT INTO heb_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","כי גנב גנבתי מארץ העברים וגם פה לא עשיתי מאומה כי שמו אתי בבור׃ ");
INSERT INTO heb_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","וירא שר האפים כי טוב פתר ויאמר אל יוסף אף אני בחלומי והנה שלשה סלי חרי על ראשי׃ ");
INSERT INTO heb_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","ובסל העליון מכל מאכל פרעה מעשה אפה והעוף אכל אתם מן הסל מעל ראשי׃ ");
INSERT INTO heb_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","ויען יוסף ויאמר זה פתרנו שלשת הסלים שלשת ימים הם׃ ");
INSERT INTO heb_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","בעוד שלשת ימים ישא פרעה את ראשך מעליך ותלה אותך על עץ ואכל העוף את בשרך מעליך׃ ");
INSERT INTO heb_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","ויהי ביום השלישי יום הלדת את פרעה ויעש משתה לכל עבדיו וישא את ראש שר המשקים ואת ראש שר האפים בתוך עבדיו׃ ");
INSERT INTO heb_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","וישב את שר המשקים על משקהו ויתן הכוס על כף פרעה׃ ");
INSERT INTO heb_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","ואת שר האפים תלה כאשר פתר להם יוסף׃ ");
INSERT INTO heb_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","ולא זכר שר המשקים את יוסף וישכחהו׃ ");
INSERT INTO heb_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","ויהי מקץ שנתים ימים ופרעה חלם והנה עמד על היאר׃ ");
INSERT INTO heb_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","והנה מן היאר עלת שבע פרות יפות מראה ובריאת בשר ותרעינה באחו׃ ");
INSERT INTO heb_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","והנה שבע פרות אחרות עלות אחריהן מן היאר רעות מראה ודקות בשר ותעמדנה אצל הפרות על שפת היאר׃ ");
INSERT INTO heb_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","ותאכלנה הפרות רעות המראה ודקת הבשר את שבע הפרות יפת המראה והבריאת וייקץ פרעה׃ ");
INSERT INTO heb_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","ויישן ויחלם שנית והנה שבע שבלים עלות בקנה אחד בריאות וטבות׃ ");
INSERT INTO heb_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","והנה שבע שבלים דקות ושדופת קדים צמחות אחריהן׃ ");
INSERT INTO heb_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","ותבלענה השבלים הדקות את שבע השבלים הבריאות והמלאות וייקץ פרעה והנה חלום׃ ");
INSERT INTO heb_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","ויהי בבקר ותפעם רוחו וישלח ויקרא את כל חרטמי מצרים ואת כל חכמיה ויספר פרעה להם את חלמו ואין פותר אותם לפרעה׃ ");
INSERT INTO heb_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","וידבר שר המשקים את פרעה לאמר את חטאי אני מזכיר היום׃ ");
INSERT INTO heb_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","פרעה קצף על עבדיו ויתן אתי במשמר בית שר הטבחים אתי ואת שר האפים׃ ");
INSERT INTO heb_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","ונחלמה חלום בלילה אחד אני והוא איש כפתרון חלמו חלמנו׃ ");
INSERT INTO heb_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","ושם אתנו נער עברי עבד לשר הטבחים ונספר לו ויפתר לנו את חלמתינו איש כחלמו פתר׃ ");
INSERT INTO heb_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","ויהי כאשר פתר לנו כן היה אתי השיב על כני ואתו תלה׃ ");
INSERT INTO heb_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","וישלח פרעה ויקרא את יוסף ויריצהו מן הבור ויגלח ויחלף שמלתיו ויבא אל פרעה׃ ");
INSERT INTO heb_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","ויאמר פרעה אל יוסף חלום חלמתי ופתר אין אתו ואני שמעתי עליך לאמר תשמע חלום לפתר אתו׃ ");
INSERT INTO heb_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","ויען יוסף את פרעה לאמר בלעדי אלהים יענה את שלום פרעה׃ ");
INSERT INTO heb_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","וידבר פרעה אל יוסף בחלמי הנני עמד על שפת היאר׃ ");
INSERT INTO heb_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","והנה מן היאר עלת שבע פרות בריאות בשר ויפת תאר ותרעינה באחו׃ ");
INSERT INTO heb_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","והנה שבע פרות אחרות עלות אחריהן דלות ורעות תאר מאד ורקות בשר לא ראיתי כהנה בכל ארץ מצרים לרע׃ ");
INSERT INTO heb_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","ותאכלנה הפרות הרקות והרעות את שבע הפרות הראשנות הבריאת׃ ");
INSERT INTO heb_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","ותבאנה אל קרבנה ולא נודע כי באו אל קרבנה ומראיהן רע כאשר בתחלה ואיקץ׃ ");
INSERT INTO heb_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","וארא בחלמי והנה שבע שבלים עלת בקנה אחד מלאת וטבות׃ ");
INSERT INTO heb_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","והנה שבע שבלים צנמות דקות שדפות קדים צמחות אחריהם׃ ");
INSERT INTO heb_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","ותבלען השבלים הדקת את שבע השבלים הטבות ואמר אל החרטמים ואין מגיד לי׃ ");
INSERT INTO heb_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","ויאמר יוסף אל פרעה חלום פרעה אחד הוא את אשר האלהים עשה הגיד לפרעה׃ ");
INSERT INTO heb_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","שבע פרת הטבת שבע שנים הנה ושבע השבלים הטבת שבע שנים הנה חלום אחד הוא׃ ");
INSERT INTO heb_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","ושבע הפרות הרקות והרעת העלת אחריהן שבע שנים הנה ושבע השבלים הרקות שדפות הקדים יהיו שבע שני רעב׃ ");
INSERT INTO heb_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","הוא הדבר אשר דברתי אל פרעה אשר האלהים עשה הראה את פרעה׃ ");
INSERT INTO heb_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","הנה שבע שנים באות שבע גדול בכל ארץ מצרים׃ ");
INSERT INTO heb_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","וקמו שבע שני רעב אחריהן ונשכח כל השבע בארץ מצרים וכלה הרעב את הארץ׃ ");
INSERT INTO heb_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","ולא יודע השבע בארץ מפני הרעב ההוא אחרי כן כי כבד הוא מאד׃ ");
INSERT INTO heb_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","ועל השנות החלום אל פרעה פעמים כי נכון הדבר מעם האלהים וממהר האלהים לעשתו׃ ");
INSERT INTO heb_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","ועתה ירא פרעה איש נבון וחכם וישיתהו על ארץ מצרים׃ ");
INSERT INTO heb_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","יעשה פרעה ויפקד פקדים על הארץ וחמש את ארץ מצרים בשבע שני השבע׃ ");
INSERT INTO heb_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","ויקבצו את כל אכל השנים הטבת הבאת האלה ויצברו בר תחת יד פרעה אכל בערים ושמרו׃ ");
INSERT INTO heb_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","והיה האכל לפקדון לארץ לשבע שני הרעב אשר תהיין בארץ מצרים ולא תכרת הארץ ברעב׃ ");
INSERT INTO heb_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","וייטב הדבר בעיני פרעה ובעיני כל עבדיו׃ ");
INSERT INTO heb_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","ויאמר פרעה אל עבדיו הנמצא כזה איש אשר רוח אלהים בו׃ ");
INSERT INTO heb_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","ויאמר פרעה אל יוסף אחרי הודיע אלהים אותך את כל זאת אין נבון וחכם כמוך׃ ");
INSERT INTO heb_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","אתה תהיה על ביתי ועל פיך ישק כל עמי רק הכסא אגדל ממך׃ ");
INSERT INTO heb_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","ויאמר פרעה אל יוסף ראה נתתי אתך על כל ארץ מצרים׃ ");
INSERT INTO heb_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","ויסר פרעה את טבעתו מעל ידו ויתן אתה על יד יוסף וילבש אתו בגדי שש וישם רבד הזהב על צוארו׃ ");
INSERT INTO heb_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","וירכב אתו במרכבת המשנה אשר לו ויקראו לפניו אברך ונתון אתו על כל ארץ מצרים׃ ");
INSERT INTO heb_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","ויאמר פרעה אל יוסף אני פרעה ובלעדיך לא ירים איש את ידו ואת רגלו בכל ארץ מצרים׃ ");
INSERT INTO heb_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","ויקרא פרעה שם יוסף צפנת פענח ויתן לו את אסנת בת פוטי פרע כהן אן לאשה ויצא יוסף על ארץ מצרים׃ ");
INSERT INTO heb_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","ויוסף בן שלשים שנה בעמדו לפני פרעה מלך מצרים ויצא יוסף מלפני פרעה ויעבר בכל ארץ מצרים׃ ");
INSERT INTO heb_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","ותעש הארץ בשבע שני השבע לקמצים׃ ");
INSERT INTO heb_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","ויקבץ את כל אכל שבע שנים אשר היו בארץ מצרים ויתן אכל בערים אכל שדה העיר אשר סביבתיה נתן בתוכה׃ ");
INSERT INTO heb_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","ויצבר יוסף בר כחול הים הרבה מאד עד כי חדל לספר כי אין מספר׃ ");
INSERT INTO heb_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","וליוסף ילד שני בנים בטרם תבוא שנת הרעב אשר ילדה לו אסנת בת פוטי פרע כהן און׃ ");
INSERT INTO heb_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","ויקרא יוסף את שם הבכור מנשה כי נשני אלהים את כל עמלי ואת כל בית אבי׃ ");
INSERT INTO heb_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","ואת שם השני קרא אפרים כי הפרני אלהים בארץ עניי׃ ");
INSERT INTO heb_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","ותכלינה שבע שני השבע אשר היה בארץ מצרים׃ ");
INSERT INTO heb_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","ותחלינה שבע שני הרעב לבוא כאשר אמר יוסף ויהי רעב בכל הארצות ובכל ארץ מצרים היה לחם׃ ");
INSERT INTO heb_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","ותרעב כל ארץ מצרים ויצעק העם אל פרעה ללחם ויאמר פרעה לכל מצרים לכו אל יוסף אשר יאמר לכם תעשו׃ ");
INSERT INTO heb_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","והרעב היה על כל פני הארץ ויפתח יוסף את כל אשר בהם וישבר למצרים ויחזק הרעב בארץ מצרים׃ ");
INSERT INTO heb_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","וכל הארץ באו מצרימה לשבר אל יוסף כי חזק הרעב בכל הארץ׃ ");
INSERT INTO heb_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","וירא יעקב כי יש שבר במצרים ויאמר יעקב לבניו למה תתראו׃ ");
INSERT INTO heb_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","ויאמר הנה שמעתי כי יש שבר במצרים רדו שמה ושברו לנו משם ונחיה ולא נמות׃ ");
INSERT INTO heb_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","וירדו אחי יוסף עשרה לשבר בר ממצרים׃ ");
INSERT INTO heb_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","ואת בנימין אחי יוסף לא שלח יעקב את אחיו כי אמר פן יקראנו אסון׃ ");
INSERT INTO heb_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","ויבאו בני ישראל לשבר בתוך הבאים כי היה הרעב בארץ כנען׃ ");
INSERT INTO heb_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","ויוסף הוא השליט על הארץ הוא המשביר לכל עם הארץ ויבאו אחי יוסף וישתחוו לו אפים ארצה׃ ");
INSERT INTO heb_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","וירא יוסף את אחיו ויכרם ויתנכר אליהם וידבר אתם קשות ויאמר אלהם מאין באתם ויאמרו מארץ כנען לשבר אכל׃ ");
INSERT INTO heb_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","ויכר יוסף את אחיו והם לא הכרהו׃ ");
INSERT INTO heb_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","ויזכר יוסף את החלמות אשר חלם להם ויאמר אלהם מרגלים אתם לראות את ערות הארץ באתם׃ ");
INSERT INTO heb_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","ויאמרו אליו לא אדני ועבדיך באו לשבר אכל׃ ");
INSERT INTO heb_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","כלנו בני איש אחד נחנו כנים אנחנו לא היו עבדיך מרגלים׃ ");
INSERT INTO heb_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","ויאמר אלהם לא כי ערות הארץ באתם לראות׃ ");
INSERT INTO heb_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","ויאמרו שנים עשר עבדיך אחים אנחנו בני איש אחד בארץ כנען והנה הקטן את אבינו היום והאחד איננו׃ ");
INSERT INTO heb_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","ויאמר אלהם יוסף הוא אשר דברתי אלכם לאמר מרגלים אתם׃ ");
INSERT INTO heb_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","בזאת תבחנו חי פרעה אם תצאו מזה כי אם בבוא אחיכם הקטן הנה׃ ");
INSERT INTO heb_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","שלחו מכם אחד ויקח את אחיכם ואתם האסרו ויבחנו דבריכם האמת אתכם ואם לא חי פרעה כי מרגלים אתם׃ ");
INSERT INTO heb_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","ויאסף אתם אל משמר שלשת ימים׃ ");
INSERT INTO heb_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","ויאמר אלהם יוסף ביום השלישי זאת עשו וחיו את האלהים אני ירא׃ ");
INSERT INTO heb_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","אם כנים אתם אחיכם אחד יאסר בבית משמרכם ואתם לכו הביאו שבר רעבון בתיכם׃ ");
INSERT INTO heb_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","ואת אחיכם הקטן תביאו אלי ויאמנו דבריכם ולא תמותו ויעשו כן׃ ");
INSERT INTO heb_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","ויאמרו איש אל אחיו אבל אשמים אנחנו על אחינו אשר ראינו צרת נפשו בהתחננו אלינו ולא שמענו על כן באה אלינו הצרה הזאת׃ ");
INSERT INTO heb_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","ויען ראובן אתם לאמר הלוא אמרתי אליכם לאמר אל תחטאו בילד ולא שמעתם וגם דמו הנה נדרש׃ ");
INSERT INTO heb_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","והם לא ידעו כי שמע יוסף כי המליץ בינתם׃ ");
INSERT INTO heb_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","ויסב מעליהם ויבך וישב אלהם וידבר אלהם ויקח מאתם את שמעון ויאסר אתו לעיניהם׃ ");
INSERT INTO heb_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","ויצו יוסף וימלאו את כליהם בר ולהשיב כספיהם איש אל שקו ולתת להם צדה לדרך ויעש להם כן׃ ");
INSERT INTO heb_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","וישאו את שברם על חמריהם וילכו משם׃ ");
INSERT INTO heb_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","ויפתח האחד את שקו לתת מספוא לחמרו במלון וירא את כספו והנה הוא בפי אמתחתו׃ ");
INSERT INTO heb_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","ויאמר אל אחיו הושב כספי וגם הנה באמתחתי ויצא לבם ויחרדו איש אל אחיו לאמר מה זאת עשה אלהים לנו׃ ");
INSERT INTO heb_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","ויבאו אל יעקב אביהם ארצה כנען ויגידו לו את כל הקרת אתם לאמר׃ ");
INSERT INTO heb_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","דבר האיש אדני הארץ אתנו קשות ויתן אתנו כמרגלים את הארץ׃ ");
INSERT INTO heb_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","ונאמר אליו כנים אנחנו לא היינו מרגלים׃ ");
INSERT INTO heb_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","שנים עשר אנחנו אחים בני אבינו האחד איננו והקטן היום את אבינו בארץ כנען׃ ");
INSERT INTO heb_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","ויאמר אלינו האיש אדני הארץ בזאת אדע כי כנים אתם אחיכם האחד הניחו אתי ואת רעבון בתיכם קחו ולכו׃ ");
INSERT INTO heb_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","והביאו את אחיכם הקטן אלי ואדעה כי לא מרגלים אתם כי כנים אתם את אחיכם אתן לכם ואת הארץ תסחרו׃ ");
INSERT INTO heb_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","ויהי הם מריקים שקיהם והנה איש צרור כספו בשקו ויראו את צררות כספיהם המה ואביהם וייראו׃ ");
INSERT INTO heb_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","ויאמר אלהם יעקב אביהם אתי שכלתם יוסף איננו ושמעון איננו ואת בנימן תקחו עלי היו כלנה׃ ");
INSERT INTO heb_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","ויאמר ראובן אל אביו לאמר את שני בני תמית אם לא אביאנו אליך תנה אתו על ידי ואני אשיבנו אליך׃ ");
INSERT INTO heb_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","ויאמר לא ירד בני עמכם כי אחיו מת והוא לבדו נשאר וקראהו אסון בדרך אשר תלכו בה והורדתם את שיבתי ביגון שאולה׃ ");
INSERT INTO heb_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","והרעב כבד בארץ׃ ");
INSERT INTO heb_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","ויהי כאשר כלו לאכל את השבר אשר הביאו ממצרים ויאמר אליהם אביהם שבו שברו לנו מעט אכל׃ ");
INSERT INTO heb_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","ויאמר אליו יהודה לאמר העד העד בנו האיש לאמר לא תראו פני בלתי אחיכם אתכם׃ ");
INSERT INTO heb_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","אם ישך משלח את אחינו אתנו נרדה ונשברה לך אכל׃ ");
INSERT INTO heb_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","ואם אינך משלח לא נרד כי האיש אמר אלינו לא תראו פני בלתי אחיכם אתכם׃ ");
INSERT INTO heb_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","ויאמר ישראל למה הרעתם לי להגיד לאיש העוד לכם אח׃ ");
INSERT INTO heb_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","ויאמרו שאול שאל האיש לנו ולמולדתנו לאמר העוד אביכם חי היש לכם אח ונגד לו על פי הדברים האלה הידוע נדע כי יאמר הורידו את אחיכם׃ ");
INSERT INTO heb_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","ויאמר יהודה אל ישראל אביו שלחה הנער אתי ונקומה ונלכה ונחיה ולא נמות גם אנחנו גם אתה גם טפנו׃ ");
INSERT INTO heb_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","אנכי אערבנו מידי תבקשנו אם לא הביאתיו אליך והצגתיו לפניך וחטאתי לך כל הימים׃ ");
INSERT INTO heb_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","כי לולא התמהמהנו כי עתה שבנו זה פעמים׃ ");
INSERT INTO heb_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","ויאמר אלהם ישראל אביהם אם כן אפוא זאת עשו קחו מזמרת הארץ בכליכם והורידו לאיש מנחה מעט צרי ומעט דבש נכאת ולט בטנים ושקדים׃ ");
INSERT INTO heb_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","וכסף משנה קחו בידכם ואת הכסף המושב בפי אמתחתיכם תשיבו בידכם אולי משגה הוא׃ ");
INSERT INTO heb_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","ואת אחיכם קחו וקומו שובו אל האיש׃ ");
INSERT INTO heb_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","ואל שדי יתן לכם רחמים לפני האיש ושלח לכם את אחיכם אחר ואת בנימין ואני כאשר שכלתי שכלתי׃ ");
INSERT INTO heb_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","ויקחו האנשים את המנחה הזאת ומשנה כסף לקחו בידם ואת בנימן ויקמו וירדו מצרים ויעמדו לפני יוסף׃ ");
INSERT INTO heb_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","וירא יוסף אתם את בנימין ויאמר לאשר על ביתו הבא את האנשים הביתה וטבח טבח והכן כי אתי יאכלו האנשים בצהרים׃ ");
INSERT INTO heb_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","ויעש האיש כאשר אמר יוסף ויבא האיש את האנשים ביתה יוסף׃ ");
INSERT INTO heb_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","וייראו האנשים כי הובאו בית יוסף ויאמרו על דבר הכסף השב באמתחתינו בתחלה אנחנו מובאים להתגלל עלינו ולהתנפל עלינו ולקחת אתנו לעבדים ואת חמרינו׃ ");
INSERT INTO heb_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","ויגשו אל האיש אשר על בית יוסף וידברו אליו פתח הבית׃ ");
INSERT INTO heb_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","ויאמרו בי אדני ירד ירדנו בתחלה לשבר אכל׃ ");
INSERT INTO heb_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","ויהי כי באנו אל המלון ונפתחה את אמתחתינו והנה כסף איש בפי אמתחתו כספנו במשקלו ונשב אתו בידנו׃ ");
INSERT INTO heb_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","וכסף אחר הורדנו בידנו לשבר אכל לא ידענו מי שם כספנו באמתחתינו׃ ");
INSERT INTO heb_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","ויאמר שלום לכם אל תיראו אלהיכם ואלהי אביכם נתן לכם מטמון באמתחתיכם כספכם בא אלי ויוצא אלהם את שמעון׃ ");
INSERT INTO heb_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","ויבא האיש את האנשים ביתה יוסף ויתן מים וירחצו רגליהם ויתן מספוא לחמריהם׃ ");
INSERT INTO heb_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","ויכינו את המנחה עד בוא יוסף בצהרים כי שמעו כי שם יאכלו לחם׃ ");
INSERT INTO heb_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","ויבא יוסף הביתה ויביאו לו את המנחה אשר בידם הביתה וישתחוו לו ארצה׃ ");
INSERT INTO heb_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","וישאל להם לשלום ויאמר השלום אביכם הזקן אשר אמרתם העודנו חי׃ ");
INSERT INTO heb_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","ויאמרו שלום לעבדך לאבינו עודנו חי ויקדו וישתחו׃ ");
INSERT INTO heb_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","וישא עיניו וירא את בנימין אחיו בן אמו ויאמר הזה אחיכם הקטן אשר אמרתם אלי ויאמר אלהים יחנך בני׃ ");
INSERT INTO heb_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","וימהר יוסף כי נכמרו רחמיו אל אחיו ויבקש לבכות ויבא החדרה ויבך שמה׃ ");
INSERT INTO heb_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","וירחץ פניו ויצא ויתאפק ויאמר שימו לחם׃ ");
INSERT INTO heb_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","וישימו לו לבדו ולהם לבדם ולמצרים האכלים אתו לבדם כי לא יוכלון המצרים לאכל את העברים לחם כי תועבה הוא למצרים׃ ");
INSERT INTO heb_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","וישבו לפניו הבכר כבכרתו והצעיר כצערתו ויתמהו האנשים איש אל רעהו׃ ");
INSERT INTO heb_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","וישא משאת מאת פניו אלהם ותרב משאת בנימן ממשאת כלם חמש ידות וישתו וישכרו עמו׃ ");
INSERT INTO heb_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","ויצו את אשר על ביתו לאמר מלא את אמתחת האנשים אכל כאשר יוכלון שאת ושים כסף איש בפי אמתחתו׃ ");
INSERT INTO heb_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","ואת גביעי גביע הכסף תשים בפי אמתחת הקטן ואת כסף שברו ויעש כדבר יוסף אשר דבר׃ ");
INSERT INTO heb_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","הבקר אור והאנשים שלחו המה וחמריהם׃ ");
INSERT INTO heb_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","הם יצאו את העיר לא הרחיקו ויוסף אמר לאשר על ביתו קום רדף אחרי האנשים והשגתם ואמרת אלהם למה שלמתם רעה תחת טובה׃ ");
INSERT INTO heb_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","הלוא זה אשר ישתה אדני בו והוא נחש ינחש בו הרעתם אשר עשיתם׃ ");
INSERT INTO heb_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","וישגם וידבר אלהם את הדברים האלה׃ ");
INSERT INTO heb_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","ויאמרו אליו למה ידבר אדני כדברים האלה חלילה לעבדיך מעשות כדבר הזה׃ ");
INSERT INTO heb_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","הן כסף אשר מצאנו בפי אמתחתינו השיבנו אליך מארץ כנען ואיך נגנב מבית אדניך כסף או זהב׃ ");
INSERT INTO heb_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","אשר ימצא אתו מעבדיך ומת וגם אנחנו נהיה לאדני לעבדים׃ ");
INSERT INTO heb_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","ויאמר גם עתה כדבריכם כן הוא אשר ימצא אתו יהיה לי עבד ואתם תהיו נקים׃ ");
INSERT INTO heb_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","וימהרו ויורדו איש את אמתחתו ארצה ויפתחו איש אמתחתו׃ ");
INSERT INTO heb_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","ויחפש בגדול החל ובקטן כלה וימצא הגביע באמתחת בנימן׃ ");
INSERT INTO heb_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","ויקרעו שמלתם ויעמס איש על חמרו וישבו העירה׃ ");
INSERT INTO heb_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","ויבא יהודה ואחיו ביתה יוסף והוא עודנו שם ויפלו לפניו ארצה׃ ");
INSERT INTO heb_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","ויאמר להם יוסף מה המעשה הזה אשר עשיתם הלוא ידעתם כי נחש ינחש איש אשר כמני׃ ");
INSERT INTO heb_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","ויאמר יהודה מה נאמר לאדני מה נדבר ומה נצטדק האלהים מצא את עון עבדיך הננו עבדים לאדני גם אנחנו גם אשר נמצא הגביע בידו׃ ");
INSERT INTO heb_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","ויאמר חלילה לי מעשות זאת האיש אשר נמצא הגביע בידו הוא יהיה לי עבד ואתם עלו לשלום אל אביכם׃ ");
INSERT INTO heb_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","ויגש אליו יהודה ויאמר בי אדני ידבר נא עבדך דבר באזני אדני ואל יחר אפך בעבדך כי כמוך כפרעה׃ ");
INSERT INTO heb_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","אדני שאל את עבדיו לאמר היש לכם אב או אח׃ ");
INSERT INTO heb_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","ונאמר אל אדני יש לנו אב זקן וילד זקנים קטן ואחיו מת ויותר הוא לבדו לאמו ואביו אהבו׃ ");
INSERT INTO heb_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","ותאמר אל עבדיך הורדהו אלי ואשימה עיני עליו׃ ");
INSERT INTO heb_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","ונאמר אל אדני לא יוכל הנער לעזב את אביו ועזב את אביו ומת׃ ");
INSERT INTO heb_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","ותאמר אל עבדיך אם לא ירד אחיכם הקטן אתכם לא תספון לראות פני׃ ");
INSERT INTO heb_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","ויהי כי עלינו אל עבדך אבי ונגד לו את דברי אדני׃ ");
INSERT INTO heb_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","ויאמר אבינו שבו שברו לנו מעט אכל׃ ");
INSERT INTO heb_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","ונאמר לא נוכל לרדת אם יש אחינו הקטן אתנו וירדנו כי לא נוכל לראות פני האיש ואחינו הקטן איננו אתנו׃ ");
INSERT INTO heb_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","ויאמר עבדך אבי אלינו אתם ידעתם כי שנים ילדה לי אשתי׃ ");
INSERT INTO heb_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","ויצא האחד מאתי ואמר אך טרף טרף ולא ראיתיו עד הנה׃ ");
INSERT INTO heb_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","ולקחתם גם את זה מעם פני וקרהו אסון והורדתם את שיבתי ברעה שאלה׃ ");
INSERT INTO heb_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","ועתה כבאי אל עבדך אבי והנער איננו אתנו ונפשו קשורה בנפשו׃ ");
INSERT INTO heb_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","והיה כראותו כי אין הנער ומת והורידו עבדיך את שיבת עבדך אבינו ביגון שאלה׃ ");
INSERT INTO heb_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","כי עבדך ערב את הנער מעם אבי לאמר אם לא אביאנו אליך וחטאתי לאבי כל הימים׃ ");
INSERT INTO heb_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","ועתה ישב נא עבדך תחת הנער עבד לאדני והנער יעל עם אחיו׃ ");
INSERT INTO heb_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","כי איך אעלה אל אבי והנער איננו אתי פן אראה ברע אשר ימצא את אבי׃ ");
INSERT INTO heb_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","ולא יכל יוסף להתאפק לכל הנצבים עליו ויקרא הוציאו כל איש מעלי ולא עמד איש אתו בהתודע יוסף אל אחיו׃ ");
INSERT INTO heb_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","ויתן את קלו בבכי וישמעו מצרים וישמע בית פרעה׃ ");
INSERT INTO heb_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","ויאמר יוסף אל אחיו אני יוסף העוד אבי חי ולא יכלו אחיו לענות אתו כי נבהלו מפניו׃ ");
INSERT INTO heb_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","ויאמר יוסף אל אחיו גשו נא אלי ויגשו ויאמר אני יוסף אחיכם אשר מכרתם אתי מצרימה׃ ");
INSERT INTO heb_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","ועתה אל תעצבו ואל יחר בעיניכם כי מכרתם אתי הנה כי למחיה שלחני אלהים לפניכם׃ ");
INSERT INTO heb_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","כי זה שנתים הרעב בקרב הארץ ועוד חמש שנים אשר אין חריש וקציר׃ ");
INSERT INTO heb_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","וישלחני אלהים לפניכם לשום לכם שארית בארץ ולהחיות לכם לפליטה גדלה׃ ");
INSERT INTO heb_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","ועתה לא אתם שלחתם אתי הנה כי האלהים וישימני לאב לפרעה ולאדון לכל ביתו ומשל בכל ארץ מצרים׃ ");
INSERT INTO heb_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","מהרו ועלו אל אבי ואמרתם אליו כה אמר בנך יוסף שמני אלהים לאדון לכל מצרים רדה אלי אל תעמד׃ ");
INSERT INTO heb_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","וישבת בארץ גשן והיית קרוב אלי אתה ובניך ובני בניך וצאנך ובקרך וכל אשר לך׃ ");
INSERT INTO heb_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","וכלכלתי אתך שם כי עוד חמש שנים רעב פן תורש אתה וביתך וכל אשר לך׃ ");
INSERT INTO heb_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","והנה עיניכם ראות ועיני אחי בנימין כי פי המדבר אליכם׃ ");
INSERT INTO heb_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","והגדתם לאבי את כל כבודי במצרים ואת כל אשר ראיתם ומהרתם והורדתם את אבי הנה׃ ");
INSERT INTO heb_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","ויפל על צוארי בנימן אחיו ויבך ובנימן בכה על צואריו׃ ");
INSERT INTO heb_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","וינשק לכל אחיו ויבך עליהם ואחרי כן דברו אחיו אתו׃ ");
INSERT INTO heb_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","והקל נשמע בית פרעה לאמר באו אחי יוסף וייטב בעיני פרעה ובעיני עבדיו׃ ");
INSERT INTO heb_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","ויאמר פרעה אל יוסף אמר אל אחיך זאת עשו טענו את בעירכם ולכו באו ארצה כנען׃ ");
INSERT INTO heb_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","וקחו את אביכם ואת בתיכם ובאו אלי ואתנה לכם את טוב ארץ מצרים ואכלו את חלב הארץ׃ ");
INSERT INTO heb_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","ואתה צויתה זאת עשו קחו לכם מארץ מצרים עגלות לטפכם ולנשיכם ונשאתם את אביכם ובאתם׃ ");
INSERT INTO heb_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","ועינכם אל תחס על כליכם כי טוב כל ארץ מצרים לכם הוא׃ ");
INSERT INTO heb_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","ויעשו כן בני ישראל ויתן להם יוסף עגלות על פי פרעה ויתן להם צדה לדרך׃ ");
INSERT INTO heb_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","לכלם נתן לאיש חלפות שמלת ולבנימן נתן שלש מאות כסף וחמש חלפת שמלת׃ ");
INSERT INTO heb_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","ולאביו שלח כזאת עשרה חמרים נשאים מטוב מצרים ועשר אתנת נשאת בר ולחם ומזון לאביו לדרך׃ ");
INSERT INTO heb_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","וישלח את אחיו וילכו ויאמר אלהם אל תרגזו בדרך׃ ");
INSERT INTO heb_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","ויעלו ממצרים ויבאו ארץ כנען אל יעקב אביהם׃ ");
INSERT INTO heb_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","ויגדו לו לאמר עוד יוסף חי וכי הוא משל בכל ארץ מצרים ויפג לבו כי לא האמין להם׃ ");
INSERT INTO heb_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","וידברו אליו את כל דברי יוסף אשר דבר אלהם וירא את העגלות אשר שלח יוסף לשאת אתו ותחי רוח יעקב אביהם׃ ");
INSERT INTO heb_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","ויאמר ישראל רב עוד יוסף בני חי אלכה ואראנו בטרם אמות׃ ");
INSERT INTO heb_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","ויסע ישראל וכל אשר לו ויבא בארה שבע ויזבח זבחים לאלהי אביו יצחק׃ ");
INSERT INTO heb_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","ויאמר אלהים לישראל במראת הלילה ויאמר יעקב יעקב ויאמר הנני׃ ");
INSERT INTO heb_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","ויאמר אנכי האל אלהי אביך אל תירא מרדה מצרימה כי לגוי גדול אשימך שם׃ ");
INSERT INTO heb_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","אנכי ארד עמך מצרימה ואנכי אעלך גם עלה ויוסף ישית ידו על עיניך׃ ");
INSERT INTO heb_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","ויקם יעקב מבאר שבע וישאו בני ישראל את יעקב אביהם ואת טפם ואת נשיהם בעגלות אשר שלח פרעה לשאת אתו׃ ");
INSERT INTO heb_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","ויקחו את מקניהם ואת רכושם אשר רכשו בארץ כנען ויבאו מצרימה יעקב וכל זרעו אתו׃ ");
INSERT INTO heb_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","בניו ובני בניו אתו בנתיו ובנות בניו וכל זרעו הביא אתו מצרימה׃ ");
INSERT INTO heb_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","ואלה שמות בני ישראל הבאים מצרימה יעקב ובניו בכר יעקב ראובן׃ ");
INSERT INTO heb_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","ובני ראובן חנוך ופלוא וחצרון וכרמי׃ ");
INSERT INTO heb_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","ובני שמעון ימואל וימין ואהד ויכין וצחר ושאול בן הכנענית׃ ");
INSERT INTO heb_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","ובני לוי גרשון קהת ומררי׃ ");
INSERT INTO heb_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","ובני יהודה ער ואונן ושלה ופרץ וזרח וימת ער ואונן בארץ כנען ויהיו בני פרץ חצרון וחמול׃ ");
INSERT INTO heb_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","ובני יששכר תולע ופוה ויוב ושמרון׃ ");
INSERT INTO heb_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","ובני זבולן סרד ואלון ויחלאל׃ ");
INSERT INTO heb_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","אלה בני לאה אשר ילדה ליעקב בפדן ארם ואת דינה בתו כל נפש בניו ובנותיו שלשים ושלש׃ ");
INSERT INTO heb_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","ובני גד צפיון וחגי שוני ואצבן ערי וארודי ואראלי׃ ");
INSERT INTO heb_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","ובני אשר ימנה וישוה וישוי ובריעה ושרח אחתם ובני בריעה חבר ומלכיאל׃ ");
INSERT INTO heb_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","אלה בני זלפה אשר נתן לבן ללאה בתו ותלד את אלה ליעקב שש עשרה נפש׃ ");
INSERT INTO heb_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","בני רחל אשת יעקב יוסף ובנימן׃ ");
INSERT INTO heb_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","ויולד ליוסף בארץ מצרים אשר ילדה לו אסנת בת פוטי פרע כהן אן את מנשה ואת אפרים׃ ");
INSERT INTO heb_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","ובני בנימן בלע ובכר ואשבל גרא ונעמן אחי וראש מפים וחפים וארד׃ ");
INSERT INTO heb_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","אלה בני רחל אשר ילד ליעקב כל נפש ארבעה עשר׃ ");
INSERT INTO heb_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","ובני דן חשים׃ ");
INSERT INTO heb_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","ובני נפתלי יחצאל וגוני ויצר ושלם׃ ");
INSERT INTO heb_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","אלה בני בלהה אשר נתן לבן לרחל בתו ותלד את אלה ליעקב כל נפש שבעה׃ ");
INSERT INTO heb_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","כל הנפש הבאה ליעקב מצרימה יצאי ירכו מלבד נשי בני יעקב כל נפש ששים ושש׃ ");
INSERT INTO heb_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","ובני יוסף אשר ילד לו במצרים נפש שנים כל הנפש לבית יעקב הבאה מצרימה שבעים׃ ");
INSERT INTO heb_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","ואת יהודה שלח לפניו אל יוסף להורת לפניו גשנה ויבאו ארצה גשן׃ ");
INSERT INTO heb_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","ויאסר יוסף מרכבתו ויעל לקראת ישראל אביו גשנה וירא אליו ויפל על צואריו ויבך על צואריו עוד׃ ");
INSERT INTO heb_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","ויאמר ישראל אל יוסף אמותה הפעם אחרי ראותי את פניך כי עודך חי׃ ");
INSERT INTO heb_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","ויאמר יוסף אל אחיו ואל בית אביו אעלה ואגידה לפרעה ואמרה אליו אחי ובית אבי אשר בארץ כנען באו אלי׃ ");
INSERT INTO heb_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","והאנשים רעי צאן כי אנשי מקנה היו וצאנם ובקרם וכל אשר להם הביאו׃ ");
INSERT INTO heb_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","והיה כי יקרא לכם פרעה ואמר מה מעשיכם׃ ");
INSERT INTO heb_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","ואמרתם אנשי מקנה היו עבדיך מנעורינו ועד עתה גם אנחנו גם אבתינו בעבור תשבו בארץ גשן כי תועבת מצרים כל רעה צאן׃ ");
INSERT INTO heb_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","ויבא יוסף ויגד לפרעה ויאמר אבי ואחי וצאנם ובקרם וכל אשר להם באו מארץ כנען והנם בארץ גשן׃ ");
INSERT INTO heb_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","ומקצה אחיו לקח חמשה אנשים ויצגם לפני פרעה׃ ");
INSERT INTO heb_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","ויאמר פרעה אל אחיו מה מעשיכם ויאמרו אל פרעה רעה צאן עבדיך גם אנחנו גם אבותינו׃ ");
INSERT INTO heb_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","ויאמרו אל פרעה לגור בארץ באנו כי אין מרעה לצאן אשר לעבדיך כי כבד הרעב בארץ כנען ועתה ישבו נא עבדיך בארץ גשן׃ ");
INSERT INTO heb_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","ויאמר פרעה אל יוסף לאמר אביך ואחיך באו אליך׃ ");
INSERT INTO heb_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","ארץ מצרים לפניך הוא במיטב הארץ הושב את אביך ואת אחיך ישבו בארץ גשן ואם ידעת ויש בם אנשי חיל ושמתם שרי מקנה על אשר לי׃ ");
INSERT INTO heb_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","ויבא יוסף את יעקב אביו ויעמדהו לפני פרעה ויברך יעקב את פרעה׃ ");
INSERT INTO heb_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","ויאמר פרעה אל יעקב כמה ימי שני חייך׃ ");
INSERT INTO heb_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","ויאמר יעקב אל פרעה ימי שני מגורי שלשים ומאת שנה מעט ורעים היו ימי שני חיי ולא השיגו את ימי שני חיי אבתי בימי מגוריהם׃ ");
INSERT INTO heb_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","ויברך יעקב את פרעה ויצא מלפני פרעה׃ ");
INSERT INTO heb_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","ויושב יוסף את אביו ואת אחיו ויתן להם אחזה בארץ מצרים במיטב הארץ בארץ רעמסס כאשר צוה פרעה׃ ");
INSERT INTO heb_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","ויכלכל יוסף את אביו ואת אחיו ואת כל בית אביו לחם לפי הטף׃ ");
INSERT INTO heb_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","ולחם אין בכל הארץ כי כבד הרעב מאד ותלה ארץ מצרים וארץ כנען מפני הרעב׃ ");
INSERT INTO heb_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","וילקט יוסף את כל הכסף הנמצא בארץ מצרים ובארץ כנען בשבר אשר הם שברים ויבא יוסף את הכסף ביתה פרעה׃ ");
INSERT INTO heb_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","ויתם הכסף מארץ מצרים ומארץ כנען ויבאו כל מצרים אל יוסף לאמר הבה לנו לחם ולמה נמות נגדך כי אפס כסף׃ ");
INSERT INTO heb_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","ויאמר יוסף הבו מקניכם ואתנה לכם במקניכם אם אפס כסף׃ ");
INSERT INTO heb_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","ויביאו את מקניהם אל יוסף ויתן להם יוסף לחם בסוסים ובמקנה הצאן ובמקנה הבקר ובחמרים וינהלם בלחם בכל מקנהם בשנה ההוא׃ ");
INSERT INTO heb_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","ותתם השנה ההוא ויבאו אליו בשנה השנית ויאמרו לו לא נכחד מאדני כי אם תם הכסף ומקנה הבהמה אל אדני לא נשאר לפני אדני בלתי אם גויתנו ואדמתנו׃ ");
INSERT INTO heb_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","למה נמות לעיניך גם אנחנו גם אדמתנו קנה אתנו ואת אדמתנו בלחם ונהיה אנחנו ואדמתנו עבדים לפרעה ותן זרע ונחיה ולא נמות והאדמה לא תשם׃ ");
INSERT INTO heb_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","ויקן יוסף את כל אדמת מצרים לפרעה כי מכרו מצרים איש שדהו כי חזק עלהם הרעב ותהי הארץ לפרעה׃ ");
INSERT INTO heb_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","ואת העם העביר אתו לערים מקצה גבול מצרים ועד קצהו׃ ");
INSERT INTO heb_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","רק אדמת הכהנים לא קנה כי חק לכהנים מאת פרעה ואכלו את חקם אשר נתן להם פרעה על כן לא מכרו את אדמתם׃ ");
INSERT INTO heb_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","ויאמר יוסף אל העם הן קניתי אתכם היום ואת אדמתכם לפרעה הא לכם זרע וזרעתם את האדמה׃ ");
INSERT INTO heb_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","והיה בתבואת ונתתם חמישית לפרעה וארבע הידת יהיה לכם לזרע השדה ולאכלכם ולאשר בבתיכם ולאכל לטפכם׃ ");
INSERT INTO heb_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","ויאמרו החיתנו נמצא חן בעיני אדני והיינו עבדים לפרעה׃ ");
INSERT INTO heb_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","וישם אתה יוסף לחק עד היום הזה על אדמת מצרים לפרעה לחמש רק אדמת הכהנים לבדם לא היתה לפרעה׃ ");
INSERT INTO heb_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","וישב ישראל בארץ מצרים בארץ גשן ויאחזו בה ויפרו וירבו מאד׃ ");
INSERT INTO heb_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","ויחי יעקב בארץ מצרים שבע עשרה שנה ויהי ימי יעקב שני חייו שבע שנים וארבעים ומאת שנה׃ ");
INSERT INTO heb_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","ויקרבו ימי ישראל למות ויקרא לבנו ליוסף ויאמר לו אם נא מצאתי חן בעיניך שים נא ידך תחת ירכי ועשית עמדי חסד ואמת אל נא תקברני במצרים׃ ");
INSERT INTO heb_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","ושכבתי עם אבתי ונשאתני ממצרים וקברתני בקברתם ויאמר אנכי אעשה כדברך׃ ");
INSERT INTO heb_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","ויאמר השבעה לי וישבע לו וישתחו ישראל על ראש המטה׃ ");
INSERT INTO heb_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","ויהי אחרי הדברים האלה ויאמר ליוסף הנה אביך חלה ויקח את שני בניו עמו את מנשה ואת אפרים׃ ");
INSERT INTO heb_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","ויגד ליעקב ויאמר הנה בנך יוסף בא אליך ויתחזק ישראל וישב על המטה׃ ");
INSERT INTO heb_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","ויאמר יעקב אל יוסף אל שדי נראה אלי בלוז בארץ כנען ויברך אתי׃ ");
INSERT INTO heb_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","ויאמר אלי הנני מפרך והרביתך ונתתיך לקהל עמים ונתתי את הארץ הזאת לזרעך אחריך אחזת עולם׃ ");
INSERT INTO heb_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","ועתה שני בניך הנולדים לך בארץ מצרים עד באי אליך מצרימה לי הם אפרים ומנשה כראובן ושמעון יהיו לי׃ ");
INSERT INTO heb_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","ומולדתך אשר הולדת אחריהם לך יהיו על שם אחיהם יקראו בנחלתם׃ ");
INSERT INTO heb_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","ואני בבאי מפדן מתה עלי רחל בארץ כנען בדרך בעוד כברת ארץ לבא אפרתה ואקברה שם בדרך אפרת הוא בית לחם׃ ");
INSERT INTO heb_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","וירא ישראל את בני יוסף ויאמר מי אלה׃ ");
INSERT INTO heb_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","ויאמר יוסף אל אביו בני הם אשר נתן לי אלהים בזה ויאמר קחם נא אלי ואברכם׃ ");
INSERT INTO heb_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","ועיני ישראל כבדו מזקן לא יוכל לראות ויגש אתם אליו וישק להם ויחבק להם׃ ");
INSERT INTO heb_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","ויאמר ישראל אל יוסף ראה פניך לא פללתי והנה הראה אתי אלהים גם את זרעך׃ ");
INSERT INTO heb_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","ויוצא יוסף אתם מעם ברכיו וישתחו לאפיו ארצה׃ ");
INSERT INTO heb_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","ויקח יוסף את שניהם את אפרים בימינו משמאל ישראל ואת מנשה בשמאלו מימין ישראל ויגש אליו׃ ");
INSERT INTO heb_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","וישלח ישראל את ימינו וישת על ראש אפרים והוא הצעיר ואת שמאלו על ראש מנשה שכל את ידיו כי מנשה הבכור׃ ");
INSERT INTO heb_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","ויברך את יוסף ויאמר האלהים אשר התהלכו אבתי לפניו אברהם ויצחק האלהים הרעה אתי מעודי עד היום הזה׃ ");
INSERT INTO heb_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","המלאך הגאל אתי מכל רע יברך את הנערים ויקרא בהם שמי ושם אבתי אברהם ויצחק וידגו לרב בקרב הארץ׃ ");
INSERT INTO heb_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","וירא יוסף כי ישית אביו יד ימינו על ראש אפרים וירע בעיניו ויתמך יד אביו להסיר אתה מעל ראש אפרים על ראש מנשה׃ ");
INSERT INTO heb_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","ויאמר יוסף אל אביו לא כן אבי כי זה הבכר שים ימינך על ראשו׃ ");
INSERT INTO heb_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","וימאן אביו ויאמר ידעתי בני ידעתי גם הוא יהיה לעם וגם הוא יגדל ואולם אחיו הקטן יגדל ממנו וזרעו יהיה מלא הגוים׃ ");
INSERT INTO heb_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","ויברכם ביום ההוא לאמור בך יברך ישראל לאמר ישמך אלהים כאפרים וכמנשה וישם את אפרים לפני מנשה׃ ");
INSERT INTO heb_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","ויאמר ישראל אל יוסף הנה אנכי מת והיה אלהים עמכם והשיב אתכם אל ארץ אבתיכם׃ ");
INSERT INTO heb_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","ואני נתתי לך שכם אחד על אחיך אשר לקחתי מיד האמרי בחרבי ובקשתי׃ ");
INSERT INTO heb_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","ויקרא יעקב אל בניו ויאמר האספו ואגידה לכם את אשר יקרא אתכם באחרית הימים׃ ");
INSERT INTO heb_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","הקבצו ושמעו בני יעקב ושמעו אל ישראל אביכם׃ ");
INSERT INTO heb_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","ראובן בכרי אתה כחי וראשית אוני יתר שאת ויתר עז׃ ");
INSERT INTO heb_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","פחז כמים אל תותר כי עלית משכבי אביך אז חללת יצועי עלה׃ ");
INSERT INTO heb_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","שמעון ולוי אחים כלי חמס מכרתיהם׃ ");
INSERT INTO heb_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","בסדם אל תבא נפשי בקהלם אל תחד כבדי כי באפם הרגו איש וברצנם עקרו שור׃ ");
INSERT INTO heb_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","ארור אפם כי עז ועברתם כי קשתה אחלקם ביעקב ואפיצם בישראל׃ ");
INSERT INTO heb_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","יהודה אתה יודוך אחיך ידך בערף איביך ישתחוו לך בני אביך׃ ");
INSERT INTO heb_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","גור אריה יהודה מטרף בני עלית כרע רבץ כאריה וכלביא מי יקימנו׃ ");
INSERT INTO heb_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","לא יסור שבט מיהודה ומחקק מבין רגליו עד כי יבא שילה ולו יקהת עמים׃ ");
INSERT INTO heb_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","אסרי לגפן עירה ולשרקה בני אתנו כבס ביין לבשו ובדם ענבים סותה׃ ");
INSERT INTO heb_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","חכלילי עינים מיין ולבן שנים מחלב׃ ");
INSERT INTO heb_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","זבולן לחוף ימים ישכן והוא לחוף אניות וירכתו על צידן׃ ");
INSERT INTO heb_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","יששכר חמר גרם רבץ בין המשפתים׃ ");
INSERT INTO heb_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","וירא מנחה כי טוב ואת הארץ כי נעמה ויט שכמו לסבל ויהי למס עבד׃ ");
INSERT INTO heb_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","דן ידין עמו כאחד שבטי ישראל׃ ");
INSERT INTO heb_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","יהי דן נחש עלי דרך שפיפן עלי ארח הנשך עקבי סוס ויפל רכבו אחור׃ ");
INSERT INTO heb_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","לישועתך קויתי יהוה׃ ");
INSERT INTO heb_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","גד גדוד יגודנו והוא יגד עקב׃ ");
INSERT INTO heb_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","מאשר שמנה לחמו והוא יתן מעדני מלך׃ ");
INSERT INTO heb_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","נפתלי אילה שלחה הנתן אמרי שפר׃ ");
INSERT INTO heb_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","בן פרת יוסף בן פרת עלי עין בנות צעדה עלי שור׃ ");
INSERT INTO heb_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","וימררהו ורבו וישטמהו בעלי חצים׃ ");
INSERT INTO heb_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","ותשב באיתן קשתו ויפזו זרעי ידיו מידי אביר יעקב משם רעה אבן ישראל׃ ");
INSERT INTO heb_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","מאל אביך ויעזרך ואת שדי ויברכך ברכת שמים מעל ברכת תהום רבצת תחת ברכת שדים ורחם׃ ");
INSERT INTO heb_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","ברכת אביך גברו על ברכת הורי עד תאות גבעת עולם תהיין לראש יוסף ולקדקד נזיר אחיו׃ ");
INSERT INTO heb_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","בנימין זאב יטרף בבקר יאכל עד ולערב יחלק שלל׃ ");
INSERT INTO heb_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","כל אלה שבטי ישראל שנים עשר וזאת אשר דבר להם אביהם ויברך אותם איש אשר כברכתו ברך אתם׃ ");
INSERT INTO heb_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","ויצו אותם ויאמר אלהם אני נאסף אל עמי קברו אתי אל אבתי אל המערה אשר בשדה עפרון החתי׃ ");
INSERT INTO heb_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","במערה אשר בשדה המכפלה אשר על פני ממרא בארץ כנען אשר קנה אברהם את השדה מאת עפרן החתי לאחזת קבר׃ ");
INSERT INTO heb_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","שמה קברו את אברהם ואת שרה אשתו שמה קברו את יצחק ואת רבקה אשתו ושמה קברתי את לאה׃ ");
INSERT INTO heb_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","מקנה השדה והמערה אשר בו מאת בני חת׃ ");
INSERT INTO heb_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","ויכל יעקב לצות את בניו ויאסף רגליו אל המטה ויגוע ויאסף אל עמיו׃ ");
INSERT INTO heb_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","ויפל יוסף על פני אביו ויבך עליו וישק לו׃ ");
INSERT INTO heb_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","ויצו יוסף את עבדיו את הרפאים לחנט את אביו ויחנטו הרפאים את ישראל׃ ");
INSERT INTO heb_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","וימלאו לו ארבעים יום כי כן ימלאו ימי החנטים ויבכו אתו מצרים שבעים יום׃ ");
INSERT INTO heb_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","ויעברו ימי בכיתו וידבר יוסף אל בית פרעה לאמר אם נא מצאתי חן בעיניכם דברו נא באזני פרעה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","אבי השביעני לאמר הנה אנכי מת בקברי אשר כריתי לי בארץ כנען שמה תקברני ועתה אעלה נא ואקברה את אבי ואשובה׃ ");
INSERT INTO heb_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","ויאמר פרעה עלה וקבר את אביך כאשר השביעך׃ ");
INSERT INTO heb_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","ויעל יוסף לקבר את אביו ויעלו אתו כל עבדי פרעה זקני ביתו וכל זקני ארץ מצרים׃ ");
INSERT INTO heb_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","וכל בית יוסף ואחיו ובית אביו רק טפם וצאנם ובקרם עזבו בארץ גשן׃ ");
INSERT INTO heb_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","ויעל עמו גם רכב גם פרשים ויהי המחנה כבד מאד׃ ");
INSERT INTO heb_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","ויבאו עד גרן האטד אשר בעבר הירדן ויספדו שם מספד גדול וכבד מאד ויעש לאביו אבל שבעת ימים׃ ");
INSERT INTO heb_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","וירא יושב הארץ הכנעני את האבל בגרן האטד ויאמרו אבל כבד זה למצרים על כן קרא שמה אבל מצרים אשר בעבר הירדן׃ ");
INSERT INTO heb_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","ויעשו בניו לו כן כאשר צום׃ ");
INSERT INTO heb_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","וישאו אתו בניו ארצה כנען ויקברו אתו במערת שדה המכפלה אשר קנה אברהם את השדה לאחזת קבר מאת עפרן החתי על פני ממרא׃ ");
INSERT INTO heb_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","וישב יוסף מצרימה הוא ואחיו וכל העלים אתו לקבר את אביו אחרי קברו את אביו׃ ");
INSERT INTO heb_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","ויראו אחי יוסף כי מת אביהם ויאמרו לו ישטמנו יוסף והשב ישיב לנו את כל הרעה אשר גמלנו אתו׃ ");
INSERT INTO heb_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","ויצוו אל יוסף לאמר אביך צוה לפני מותו לאמר׃ ");
INSERT INTO heb_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","כה תאמרו ליוסף אנא שא נא פשע אחיך וחטאתם כי רעה גמלוך ועתה שא נא לפשע עבדי אלהי אביך ויבך יוסף בדברם אליו׃ ");
INSERT INTO heb_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","וילכו גם אחיו ויפלו לפניו ויאמרו הננו לך לעבדים׃ ");
INSERT INTO heb_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","ויאמר אלהם יוסף אל תיראו כי התחת אלהים אני׃ ");
INSERT INTO heb_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","ואתם חשבתם עלי רעה אלהים חשבה לטבה למען עשה כיום הזה להחית עם רב׃ ");
INSERT INTO heb_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","ועתה אל תיראו אנכי אכלכל אתכם ואת טפכם וינחם אותם וידבר על לבם׃ ");
INSERT INTO heb_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","וישב יוסף במצרים הוא ובית אביו ויחי יוסף מאה ועשר שנים׃ ");
INSERT INTO heb_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","וירא יוסף לאפרים בני שלשים גם בני מכיר בן מנשה ילדו על ברכי יוסף׃ ");
INSERT INTO heb_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","ויאמר יוסף אל אחיו אנכי מת ואלהים פקד יפקד אתכם והעלה אתכם מן הארץ הזאת אל הארץ אשר נשבע לאברהם ליצחק וליעקב׃ ");
INSERT INTO heb_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","וישבע יוסף את בני ישראל לאמר פקד יפקד אלהים אתכם והעלתם את עצמתי מזה׃ ");
INSERT INTO heb_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","וימת יוסף בן מאה ועשר שנים ויחנטו אתו ויישם בארון במצרים׃ ");
INSERT INTO heb_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","ואלה שמות בני ישראל הבאים מצרימה את יעקב איש וביתו באו׃ ");
INSERT INTO heb_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","ראובן שמעון לוי ויהודה׃ ");
INSERT INTO heb_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","יששכר זבולן ובנימן׃ ");
INSERT INTO heb_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","דן ונפתלי גד ואשר׃ ");
INSERT INTO heb_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","ויהי כל נפש יצאי ירך יעקב שבעים נפש ויוסף היה במצרים׃ ");
INSERT INTO heb_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","וימת יוסף וכל אחיו וכל הדור ההוא׃ ");
INSERT INTO heb_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","ובני ישראל פרו וישרצו וירבו ויעצמו במאד מאד ותמלא הארץ אתם׃ ");
INSERT INTO heb_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","ויקם מלך חדש על מצרים אשר לא ידע את יוסף׃ ");
INSERT INTO heb_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","ויאמר אל עמו הנה עם בני ישראל רב ועצום ממנו׃ ");
INSERT INTO heb_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","הבה נתחכמה לו פן ירבה והיה כי תקראנה מלחמה ונוסף גם הוא על שנאינו ונלחם בנו ועלה מן הארץ׃ ");
INSERT INTO heb_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","וישימו עליו שרי מסים למען ענתו בסבלתם ויבן ערי מסכנות לפרעה את פתם ואת רעמסס׃ ");
INSERT INTO heb_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","וכאשר יענו אתו כן ירבה וכן יפרץ ויקצו מפני בני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","ויעבדו מצרים את בני ישראל בפרך׃ ");
INSERT INTO heb_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","וימררו את חייהם בעבדה קשה בחמר ובלבנים ובכל עבדה בשדה את כל עבדתם אשר עבדו בהם בפרך׃ ");
INSERT INTO heb_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","ויאמר מלך מצרים למילדת העברית אשר שם האחת שפרה ושם השנית פועה׃ ");
INSERT INTO heb_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","ויאמר בילדכן את העבריות וראיתן על האבנים אם בן הוא והמתן אתו ואם בת היא וחיה׃ ");
INSERT INTO heb_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","ותיראן המילדת את האלהים ולא עשו כאשר דבר אליהן מלך מצרים ותחיין את הילדים׃ ");
INSERT INTO heb_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","ויקרא מלך מצרים למילדת ויאמר להן מדוע עשיתן הדבר הזה ותחיין את הילדים׃ ");
INSERT INTO heb_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","ותאמרן המילדת אל פרעה כי לא כנשים המצרית העברית כי חיות הנה בטרם תבוא אלהן המילדת וילדו׃ ");
INSERT INTO heb_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","וייטב אלהים למילדת וירב העם ויעצמו מאד׃ ");
INSERT INTO heb_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","ויהי כי יראו המילדת את האלהים ויעש להם בתים׃ ");
INSERT INTO heb_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","ויצו פרעה לכל עמו לאמר כל הבן הילוד היארה תשליכהו וכל הבת תחיון׃ ");
INSERT INTO heb_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","וילך איש מבית לוי ויקח את בת לוי׃ ");
INSERT INTO heb_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","ותהר האשה ותלד בן ותרא אתו כי טוב הוא ותצפנהו שלשה ירחים׃ ");
INSERT INTO heb_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","ולא יכלה עוד הצפינו ותקח לו תבת גמא ותחמרה בחמר ובזפת ותשם בה את הילד ותשם בסוף על שפת היאר׃ ");
INSERT INTO heb_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","ותתצב אחתו מרחק לדעה מה יעשה לו׃ ");
INSERT INTO heb_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","ותרד בת פרעה לרחץ על היאר ונערתיה הלכת על יד היאר ותרא את התבה בתוך הסוף ותשלח את אמתה ותקחה׃ ");
INSERT INTO heb_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","ותפתח ותראהו את הילד והנה נער בכה ותחמל עליו ותאמר מילדי העברים זה׃ ");
INSERT INTO heb_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","ותאמר אחתו אל בת פרעה האלך וקראתי לך אשה מינקת מן העברית ותינק לך את הילד׃ ");
INSERT INTO heb_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","ותאמר לה בת פרעה לכי ותלך העלמה ותקרא את אם הילד׃ ");
INSERT INTO heb_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","ותאמר לה בת פרעה היליכי את הילד הזה והינקהו לי ואני אתן את שכרך ותקח האשה הילד ותניקהו׃ ");
INSERT INTO heb_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","ויגדל הילד ותבאהו לבת פרעה ויהי לה לבן ותקרא שמו משה ותאמר כי מן המים משיתהו׃ ");
INSERT INTO heb_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","ויהי בימים ההם ויגדל משה ויצא אל אחיו וירא בסבלתם וירא איש מצרי מכה איש עברי מאחיו׃ ");
INSERT INTO heb_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","ויפן כה וכה וירא כי אין איש ויך את המצרי ויטמנהו בחול׃ ");
INSERT INTO heb_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","ויצא ביום השני והנה שני אנשים עברים נצים ויאמר לרשע למה תכה רעך׃ ");
INSERT INTO heb_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","ויאמר מי שמך לאיש שר ושפט עלינו הלהרגני אתה אמר כאשר הרגת את המצרי ויירא משה ויאמר אכן נודע הדבר׃ ");
INSERT INTO heb_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","וישמע פרעה את הדבר הזה ויבקש להרג את משה ויברח משה מפני פרעה וישב בארץ מדין וישב על הבאר׃ ");
INSERT INTO heb_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","ולכהן מדין שבע בנות ותבאנה ותדלנה ותמלאנה את הרהטים להשקות צאן אביהן׃ ");
INSERT INTO heb_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","ויבאו הרעים ויגרשום ויקם משה ויושען וישק את צאנם׃ ");
INSERT INTO heb_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","ותבאנה אל רעואל אביהן ויאמר מדוע מהרתן בא היום׃ ");
INSERT INTO heb_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","ותאמרן איש מצרי הצילנו מיד הרעים וגם דלה דלה לנו וישק את הצאן׃ ");
INSERT INTO heb_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","ויאמר אל בנתיו ואיו למה זה עזבתן את האיש קראן לו ויאכל לחם׃ ");
INSERT INTO heb_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","ויואל משה לשבת את האיש ויתן את צפרה בתו למשה׃ ");
INSERT INTO heb_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","ותלד בן ויקרא את שמו גרשם כי אמר גר הייתי בארץ נכריה׃ ");
INSERT INTO heb_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","ויהי בימים הרבים ההם וימת מלך מצרים ויאנחו בני ישראל מן העבדה ויזעקו ותעל שועתם אל האלהים מן העבדה׃ ");
INSERT INTO heb_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","וישמע אלהים את נאקתם ויזכר אלהים את בריתו את אברהם את יצחק ואת יעקב׃ ");
INSERT INTO heb_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","וירא אלהים את בני ישראל וידע אלהים׃ ");
INSERT INTO heb_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","ומשה היה רעה את צאן יתרו חתנו כהן מדין וינהג את הצאן אחר המדבר ויבא אל הר האלהים חרבה׃ ");
INSERT INTO heb_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","וירא מלאך יהוה אליו בלבת אש מתוך הסנה וירא והנה הסנה בער באש והסנה איננו אכל׃ ");
INSERT INTO heb_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","ויאמר משה אסרה נא ואראה את המראה הגדל הזה מדוע לא יבער הסנה׃ ");
INSERT INTO heb_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","וירא יהוה כי סר לראות ויקרא אליו אלהים מתוך הסנה ויאמר משה משה ויאמר הנני׃ ");
INSERT INTO heb_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","ויאמר אל תקרב הלם של נעליך מעל רגליך כי המקום אשר אתה עומד עליו אדמת קדש הוא׃ ");
INSERT INTO heb_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","ויאמר אנכי אלהי אביך אלהי אברהם אלהי יצחק ואלהי יעקב ויסתר משה פניו כי ירא מהביט אל האלהים׃ ");
INSERT INTO heb_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","ויאמר יהוה ראה ראיתי את עני עמי אשר במצרים ואת צעקתם שמעתי מפני נגשיו כי ידעתי את מכאביו׃ ");
INSERT INTO heb_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","וארד להצילו מיד מצרים ולהעלתו מן הארץ ההוא אל ארץ טובה ורחבה אל ארץ זבת חלב ודבש אל מקום הכנעני והחתי והאמרי והפרזי והחוי והיבוסי׃ ");
INSERT INTO heb_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","ועתה הנה צעקת בני ישראל באה אלי וגם ראיתי את הלחץ אשר מצרים לחצים אתם׃ ");
INSERT INTO heb_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","ועתה לכה ואשלחך אל פרעה והוצא את עמי בני ישראל ממצרים׃ ");
INSERT INTO heb_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","ויאמר משה אל האלהים מי אנכי כי אלך אל פרעה וכי אוציא את בני ישראל ממצרים׃ ");
INSERT INTO heb_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","ויאמר כי אהיה עמך וזה לך האות כי אנכי שלחתיך בהוציאך את העם ממצרים תעבדון את האלהים על ההר הזה׃ ");
INSERT INTO heb_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","ויאמר משה אל האלהים הנה אנכי בא אל בני ישראל ואמרתי להם אלהי אבותיכם שלחני אליכם ואמרו לי מה שמו מה אמר אלהם׃ ");
INSERT INTO heb_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","ויאמר אלהים אל משה אהיה אשר אהיה ויאמר כה תאמר לבני ישראל אהיה שלחני אליכם׃ ");
INSERT INTO heb_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","ויאמר עוד אלהים אל משה כה תאמר אל בני ישראל יהוה אלהי אבתיכם אלהי אברהם אלהי יצחק ואלהי יעקב שלחני אליכם זה שמי לעלם וזה זכרי לדר דר׃ ");
INSERT INTO heb_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","לך ואספת את זקני ישראל ואמרת אלהם יהוה אלהי אבתיכם נראה אלי אלהי אברהם יצחק ויעקב לאמר פקד פקדתי אתכם ואת העשוי לכם במצרים׃ ");
INSERT INTO heb_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","ואמר אעלה אתכם מעני מצרים אל ארץ הכנעני והחתי והאמרי והפרזי והחוי והיבוסי אל ארץ זבת חלב ודבש׃ ");
INSERT INTO heb_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","ושמעו לקלך ובאת אתה וזקני ישראל אל מלך מצרים ואמרתם אליו יהוה אלהי העבריים נקרה עלינו ועתה נלכה נא דרך שלשת ימים במדבר ונזבחה ליהוה אלהינו׃ ");
INSERT INTO heb_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","ואני ידעתי כי לא יתן אתכם מלך מצרים להלך ולא ביד חזקה׃ ");
INSERT INTO heb_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","ושלחתי את ידי והכיתי את מצרים בכל נפלאתי אשר אעשה בקרבו ואחרי כן ישלח אתכם׃ ");
INSERT INTO heb_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","ונתתי את חן העם הזה בעיני מצרים והיה כי תלכון לא תלכו ריקם׃ ");
INSERT INTO heb_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","ושאלה אשה משכנתה ומגרת ביתה כלי כסף וכלי זהב ושמלת ושמתם על בניכם ועל בנתיכם ונצלתם את מצרים׃ ");
INSERT INTO heb_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","ויען משה ויאמר והן לא יאמינו לי ולא ישמעו בקלי כי יאמרו לא נראה אליך יהוה׃ ");
INSERT INTO heb_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","ויאמר אליו יהוה מזה בידך ויאמר מטה׃ ");
INSERT INTO heb_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","ויאמר השליכהו ארצה וישליכהו ארצה ויהי לנחש וינס משה מפניו׃ ");
INSERT INTO heb_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","ויאמר יהוה אל משה שלח ידך ואחז בזנבו וישלח ידו ויחזק בו ויהי למטה בכפו׃ ");
INSERT INTO heb_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","למען יאמינו כי נראה אליך יהוה אלהי אבתם אלהי אברהם אלהי יצחק ואלהי יעקב׃ ");
INSERT INTO heb_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","ויאמר יהוה לו עוד הבא נא ידך בחיקך ויבא ידו בחיקו ויוצאה והנה ידו מצרעת כשלג׃ ");
INSERT INTO heb_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","ויאמר השב ידך אל חיקך וישב ידו אל חיקו ויוצאה מחיקו והנה שבה כבשרו׃ ");
INSERT INTO heb_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","והיה אם לא יאמינו לך ולא ישמעו לקל האת הראשון והאמינו לקל האת האחרון׃ ");
INSERT INTO heb_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","והיה אם לא יאמינו גם לשני האתות האלה ולא ישמעון לקלך ולקחת ממימי היאר ושפכת היבשה והיו המים אשר תקח מן היאר והיו לדם ביבשת׃ ");
INSERT INTO heb_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","ויאמר משה אל יהוה בי אדני לא איש דברים אנכי גם מתמול גם משלשם גם מאז דברך אל עבדך כי כבד פה וכבד לשון אנכי׃ ");
INSERT INTO heb_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","ויאמר יהוה אליו מי שם פה לאדם או מי ישום אלם או חרש או פקח או עור הלא אנכי יהוה׃ ");
INSERT INTO heb_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","ועתה לך ואנכי אהיה עם פיך והוריתיך אשר תדבר׃ ");
INSERT INTO heb_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","ויאמר בי אדני שלח נא ביד תשלח׃ ");
INSERT INTO heb_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","ויחר אף יהוה במשה ויאמר הלא אהרן אחיך הלוי ידעתי כי דבר ידבר הוא וגם הנה הוא יצא לקראתך וראך ושמח בלבו׃ ");
INSERT INTO heb_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","ודברת אליו ושמת את הדברים בפיו ואנכי אהיה עם פיך ועם פיהו והוריתי אתכם את אשר תעשון׃ ");
INSERT INTO heb_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","ודבר הוא לך אל העם והיה הוא יהיה לך לפה ואתה תהיה לו לאלהים׃ ");
INSERT INTO heb_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","ואת המטה הזה תקח בידך אשר תעשה בו את האתת׃ ");
INSERT INTO heb_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","וילך משה וישב אל יתר חתנו ויאמר לו אלכה נא ואשובה אל אחי אשר במצרים ואראה העודם חיים ויאמר יתרו למשה לך לשלום׃ ");
INSERT INTO heb_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","ויאמר יהוה אל משה במדין לך שב מצרים כי מתו כל האנשים המבקשים את נפשך׃ ");
INSERT INTO heb_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","ויקח משה את אשתו ואת בניו וירכבם על החמר וישב ארצה מצרים ויקח משה את מטה האלהים בידו׃ ");
INSERT INTO heb_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","ויאמר יהוה אל משה בלכתך לשוב מצרימה ראה כל המפתים אשר שמתי בידך ועשיתם לפני פרעה ואני אחזק את לבו ולא ישלח את העם׃ ");
INSERT INTO heb_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","ואמרת אל פרעה כה אמר יהוה בני בכרי ישראל׃ ");
INSERT INTO heb_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","ואמר אליך שלח את בני ויעבדני ותמאן לשלחו הנה אנכי הרג את בנך בכרך׃ ");
INSERT INTO heb_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","ויהי בדרך במלון ויפגשהו יהוה ויבקש המיתו׃ ");
INSERT INTO heb_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","ותקח צפרה צר ותכרת את ערלת בנה ותגע לרגליו ותאמר כי חתן דמים אתה לי׃ ");
INSERT INTO heb_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","וירף ממנו אז אמרה חתן דמים למולת׃ ");
INSERT INTO heb_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","ויאמר יהוה אל אהרן לך לקראת משה המדברה וילך ויפגשהו בהר האלהים וישק לו׃ ");
INSERT INTO heb_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","ויגד משה לאהרן את כל דברי יהוה אשר שלחו ואת כל האתת אשר צוהו׃ ");
INSERT INTO heb_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","וילך משה ואהרן ויאספו את כל זקני בני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","וידבר אהרן את כל הדברים אשר דבר יהוה אל משה ויעש האתת לעיני העם׃ ");
INSERT INTO heb_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","ויאמן העם וישמעו כי פקד יהוה את בני ישראל וכי ראה את ענים ויקדו וישתחוו׃ ");
INSERT INTO heb_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","ואחר באו משה ואהרן ויאמרו אל פרעה כה אמר יהוה אלהי ישראל שלח את עמי ויחגו לי במדבר׃ ");
INSERT INTO heb_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","ויאמר פרעה מי יהוה אשר אשמע בקלו לשלח את ישראל לא ידעתי את יהוה וגם את ישראל לא אשלח׃ ");
INSERT INTO heb_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","ויאמרו אלהי העברים נקרא עלינו נלכה נא דרך שלשת ימים במדבר ונזבחה ליהוה אלהינו פן יפגענו בדבר או בחרב׃ ");
INSERT INTO heb_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","ויאמר אלהם מלך מצרים למה משה ואהרן תפריעו את העם ממעשיו לכו לסבלתיכם׃ ");
INSERT INTO heb_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","ויאמר פרעה הן רבים עתה עם הארץ והשבתם אתם מסבלתם׃ ");
INSERT INTO heb_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","ויצו פרעה ביום ההוא את הנגשים בעם ואת שטריו לאמר׃ ");
INSERT INTO heb_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","לא תאספון לתת תבן לעם ללבן הלבנים כתמול שלשם הם ילכו וקששו להם תבן׃ ");
INSERT INTO heb_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","ואת מתכנת הלבנים אשר הם עשים תמול שלשם תשימו עליהם לא תגרעו ממנו כי נרפים הם על כן הם צעקים לאמר נלכה נזבחה לאלהינו׃ ");
INSERT INTO heb_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","תכבד העבדה על האנשים ויעשו בה ואל ישעו בדברי שקר׃ ");
INSERT INTO heb_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","ויצאו נגשי העם ושטריו ויאמרו אל העם לאמר כה אמר פרעה אינני נתן לכם תבן׃ ");
INSERT INTO heb_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","אתם לכו קחו לכם תבן מאשר תמצאו כי אין נגרע מעבדתכם דבר׃ ");
INSERT INTO heb_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","ויפץ העם בכל ארץ מצרים לקשש קש לתבן׃ ");
INSERT INTO heb_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","והנגשים אצים לאמר כלו מעשיכם דבר יום ביומו כאשר בהיות התבן׃ ");
INSERT INTO heb_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","ויכו שטרי בני ישראל אשר שמו עלהם נגשי פרעה לאמר מדוע לא כליתם חקכם ללבן כתמול שלשם גם תמול גם היום׃ ");
INSERT INTO heb_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","ויבאו שטרי בני ישראל ויצעקו אל פרעה לאמר למה תעשה כה לעבדיך׃ ");
INSERT INTO heb_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","תבן אין נתן לעבדיך ולבנים אמרים לנו עשו והנה עבדיך מכים וחטאת עמך׃ ");
INSERT INTO heb_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","ויאמר נרפים אתם נרפים על כן אתם אמרים נלכה נזבחה ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","ועתה לכו עבדו ותבן לא ינתן לכם ותכן לבנים תתנו׃ ");
INSERT INTO heb_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","ויראו שטרי בני ישראל אתם ברע לאמר לא תגרעו מלבניכם דבר יום ביומו׃ ");
INSERT INTO heb_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","ויפגעו את משה ואת אהרן נצבים לקראתם בצאתם מאת פרעה׃ ");
INSERT INTO heb_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","ויאמרו אלהם ירא יהוה עליכם וישפט אשר הבאשתם את ריחנו בעיני פרעה ובעיני עבדיו לתת חרב בידם להרגנו׃ ");
INSERT INTO heb_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","וישב משה אל יהוה ויאמר אדני למה הרעתה לעם הזה למה זה שלחתני׃ ");
INSERT INTO heb_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","ומאז באתי אל פרעה לדבר בשמך הרע לעם הזה והצל לא הצלת את עמך׃ ");
INSERT INTO heb_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","ויאמר יהוה אל משה עתה תראה אשר אעשה לפרעה כי ביד חזקה ישלחם וביד חזקה יגרשם מארצו׃ ");
INSERT INTO heb_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","וידבר אלהים אל משה ויאמר אליו אני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","וארא אל אברהם אל יצחק ואל יעקב באל שדי ושמי יהוה לא נודעתי להם׃ ");
INSERT INTO heb_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","וגם הקמתי את בריתי אתם לתת להם את ארץ כנען את ארץ מגריהם אשר גרו בה׃ ");
INSERT INTO heb_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","וגם אני שמעתי את נאקת בני ישראל אשר מצרים מעבדים אתם ואזכר את בריתי׃ ");
INSERT INTO heb_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","לכן אמר לבני ישראל אני יהוה והוצאתי אתכם מתחת סבלת מצרים והצלתי אתכם מעבדתם וגאלתי אתכם בזרוע נטויה ובשפטים גדלים׃ ");
INSERT INTO heb_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","ולקחתי אתכם לי לעם והייתי לכם לאלהים וידעתם כי אני יהוה אלהיכם המוציא אתכם מתחת סבלות מצרים׃ ");
INSERT INTO heb_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","והבאתי אתכם אל הארץ אשר נשאתי את ידי לתת אתה לאברהם ליצחק וליעקב ונתתי אתה לכם מורשה אני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","וידבר משה כן אל בני ישראל ולא שמעו אל משה מקצר רוח ומעבדה קשה׃ ");
INSERT INTO heb_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","בא דבר אל פרעה מלך מצרים וישלח את בני ישראל מארצו׃ ");
INSERT INTO heb_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","וידבר משה לפני יהוה לאמר הן בני ישראל לא שמעו אלי ואיך ישמעני פרעה ואני ערל שפתים׃ ");
INSERT INTO heb_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","וידבר יהוה אל משה ואל אהרן ויצום אל בני ישראל ואל פרעה מלך מצרים להוציא את בני ישראל מארץ מצרים׃ ");
INSERT INTO heb_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","אלה ראשי בית אבתם בני ראובן בכר ישראל חנוך ופלוא חצרון וכרמי אלה משפחת ראובן׃ ");
INSERT INTO heb_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","ובני שמעון ימואל וימין ואהד ויכין וצחר ושאול בן הכנענית אלה משפחת שמעון׃ ");
INSERT INTO heb_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","ואלה שמות בני לוי לתלדתם גרשון וקהת ומררי ושני חיי לוי שבע ושלשים ומאת שנה׃ ");
INSERT INTO heb_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","בני גרשון לבני ושמעי למשפחתם׃ ");
INSERT INTO heb_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","ובני קהת עמרם ויצהר וחברון ועזיאל ושני חיי קהת שלש ושלשים ומאת שנה׃ ");
INSERT INTO heb_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","ובני מררי מחלי ומושי אלה משפחת הלוי לתלדתם׃ ");
INSERT INTO heb_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","ויקח עמרם את יוכבד דדתו לו לאשה ותלד לו את אהרן ואת משה ושני חיי עמרם שבע ושלשים ומאת שנה׃ ");
INSERT INTO heb_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","ובני יצהר קרח ונפג וזכרי׃ ");
INSERT INTO heb_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","ובני עזיאל מישאל ואלצפן וסתרי׃ ");
INSERT INTO heb_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","ויקח אהרן את אלישבע בת עמינדב אחות נחשון לו לאשה ותלד לו את נדב ואת אביהוא את אלעזר ואת איתמר׃ ");
INSERT INTO heb_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","ובני קרח אסיר ואלקנה ואביאסף אלה משפחת הקרחי׃ ");
INSERT INTO heb_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","ואלעזר בן אהרן לקח לו מבנות פוטיאל לו לאשה ותלד לו את פינחס אלה ראשי אבות הלוים למשפחתם׃ ");
INSERT INTO heb_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","הוא אהרן ומשה אשר אמר יהוה להם הוציאו את בני ישראל מארץ מצרים על צבאתם׃ ");
INSERT INTO heb_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","הם המדברים אל פרעה מלך מצרים להוציא את בני ישראל ממצרים הוא משה ואהרן׃ ");
INSERT INTO heb_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","ויהי ביום דבר יהוה אל משה בארץ מצרים׃ ");
INSERT INTO heb_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","וידבר יהוה אל משה לאמר אני יהוה דבר אל פרעה מלך מצרים את כל אשר אני דבר אליך׃ ");
INSERT INTO heb_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","ויאמר משה לפני יהוה הן אני ערל שפתים ואיך ישמע אלי פרעה׃ ");
INSERT INTO heb_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","ויאמר יהוה אל משה ראה נתתיך אלהים לפרעה ואהרן אחיך יהיה נביאך׃ ");
INSERT INTO heb_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","אתה תדבר את כל אשר אצוך ואהרן אחיך ידבר אל פרעה ושלח את בני ישראל מארצו׃ ");
INSERT INTO heb_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","ואני אקשה את לב פרעה והרביתי את אתתי ואת מופתי בארץ מצרים׃ ");
INSERT INTO heb_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","ולא ישמע אלכם פרעה ונתתי את ידי במצרים והוצאתי את צבאתי את עמי בני ישראל מארץ מצרים בשפטים גדלים׃ ");
INSERT INTO heb_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","וידעו מצרים כי אני יהוה בנטתי את ידי על מצרים והוצאתי את בני ישראל מתוכם׃ ");
INSERT INTO heb_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","ויעש משה ואהרן כאשר צוה יהוה אתם כן עשו׃ ");
INSERT INTO heb_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","ומשה בן שמנים שנה ואהרן בן שלש ושמנים שנה בדברם אל פרעה׃ ");
INSERT INTO heb_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","ויאמר יהוה אל משה ואל אהרן לאמר׃ ");
INSERT INTO heb_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","כי ידבר אלכם פרעה לאמר תנו לכם מופת ואמרת אל אהרן קח את מטך והשלך לפני פרעה יהי לתנין׃ ");
INSERT INTO heb_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","ויבא משה ואהרן אל פרעה ויעשו כן כאשר צוה יהוה וישלך אהרן את מטהו לפני פרעה ולפני עבדיו ויהי לתנין׃ ");
INSERT INTO heb_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","ויקרא גם פרעה לחכמים ולמכשפים ויעשו גם הם חרטמי מצרים בלהטיהם כן׃ ");
INSERT INTO heb_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","וישליכו איש מטהו ויהיו לתנינם ויבלע מטה אהרן את מטתם׃ ");
INSERT INTO heb_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","ויחזק לב פרעה ולא שמע אלהם כאשר דבר יהוה׃ ");
INSERT INTO heb_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","ויאמר יהוה אל משה כבד לב פרעה מאן לשלח העם׃ ");
INSERT INTO heb_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","לך אל פרעה בבקר הנה יצא המימה ונצבת לקראתו על שפת היאר והמטה אשר נהפך לנחש תקח בידך׃ ");
INSERT INTO heb_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","ואמרת אליו יהוה אלהי העברים שלחני אליך לאמר שלח את עמי ויעבדני במדבר והנה לא שמעת עד כה׃ ");
INSERT INTO heb_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","כה אמר יהוה בזאת תדע כי אני יהוה הנה אנכי מכה במטה אשר בידי על המים אשר ביאר ונהפכו לדם׃ ");
INSERT INTO heb_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","והדגה אשר ביאר תמות ובאש היאר ונלאו מצרים לשתות מים מן היאר׃ ");
INSERT INTO heb_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","ויאמר יהוה אל משה אמר אל אהרן קח מטך ונטה ידך על מימי מצרים על נהרתם על יאריהם ועל אגמיהם ועל כל מקוה מימיהם ויהיו דם והיה דם בכל ארץ מצרים ובעצים ובאבנים׃ ");
INSERT INTO heb_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","ויעשו כן משה ואהרן כאשר צוה יהוה וירם במטה ויך את המים אשר ביאר לעיני פרעה ולעיני עבדיו ויהפכו כל המים אשר ביאר לדם׃ ");
INSERT INTO heb_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","והדגה אשר ביאר מתה ויבאש היאר ולא יכלו מצרים לשתות מים מן היאר ויהי הדם בכל ארץ מצרים׃ ");
INSERT INTO heb_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","ויעשו כן חרטמי מצרים בלטיהם ויחזק לב פרעה ולא שמע אלהם כאשר דבר יהוה׃ ");
INSERT INTO heb_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","ויפן פרעה ויבא אל ביתו ולא שת לבו גם לזאת׃ ");
INSERT INTO heb_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","ויחפרו כל מצרים סביבת היאר מים לשתות כי לא יכלו לשתת ממימי היאר׃ ");
INSERT INTO heb_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","וימלא שבעת ימים אחרי הכות יהוה את היאר׃ ");
INSERT INTO heb_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","ויאמר יהוה אל משה בא אל פרעה ואמרת אליו כה אמר יהוה שלח את עמי ויעבדני׃ ");
INSERT INTO heb_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","ואם מאן אתה לשלח הנה אנכי נגף את כל גבולך בצפרדעים׃ ");
INSERT INTO heb_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","ושרץ היאר צפרדעים ועלו ובאו בביתך ובחדר משכבך ועל מטתך ובבית עבדיך ובעמך ובתנוריך ובמשארותיך׃ ");
INSERT INTO heb_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","ובכה ובעמך ובכל עבדיך יעלו הצפרדעים׃ ");
INSERT INTO heb_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","ויאמר יהוה אל משה אמר אל אהרן נטה את ידך במטך על הנהרת על היארים ועל האגמים והעל את הצפרדעים על ארץ מצרים׃ ");
INSERT INTO heb_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","ויט אהרן את ידו על מימי מצרים ותעל הצפרדע ותכס את ארץ מצרים׃ ");
INSERT INTO heb_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","ויעשו כן החרטמים בלטיהם ויעלו את הצפרדעים על ארץ מצרים׃ ");
INSERT INTO heb_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","ויקרא פרעה למשה ולאהרן ויאמר העתירו אל יהוה ויסר הצפרדעים ממני ומעמי ואשלחה את העם ויזבחו ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","ויאמר משה לפרעה התפאר עלי למתי אעתיר לך ולעבדיך ולעמך להכרית הצפרדעים ממך ומבתיך רק ביאר תשארנה׃ ");
INSERT INTO heb_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","ויאמר למחר ויאמר כדברך למען תדע כי אין כיהוה אלהינו׃ ");
INSERT INTO heb_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","וסרו הצפרדעים ממך ומבתיך ומעבדיך ומעמך רק ביאר תשארנה׃ ");
INSERT INTO heb_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","ויצא משה ואהרן מעם פרעה ויצעק משה אל יהוה על דבר הצפרדעים אשר שם לפרעה׃ ");
INSERT INTO heb_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","ויעש יהוה כדבר משה וימתו הצפרדעים מן הבתים מן החצרת ומן השדת׃ ");
INSERT INTO heb_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","ויצברו אתם חמרם חמרם ותבאש הארץ׃ ");
INSERT INTO heb_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","וירא פרעה כי היתה הרוחה והכבד את לבו ולא שמע אלהם כאשר דבר יהוה׃ ");
INSERT INTO heb_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","ויאמר יהוה אל משה אמר אל אהרן נטה את מטך והך את עפר הארץ והיה לכנם בכל ארץ מצרים׃ ");
INSERT INTO heb_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","ויעשו כן ויט אהרן את ידו במטהו ויך את עפר הארץ ותהי הכנם באדם ובבהמה כל עפר הארץ היה כנים בכל ארץ מצרים׃ ");
INSERT INTO heb_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","ויעשו כן החרטמים בלטיהם להוציא את הכנים ולא יכלו ותהי הכנם באדם ובבהמה׃ ");
INSERT INTO heb_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","ויאמרו החרטמים אל פרעה אצבע אלהים הוא ויחזק לב פרעה ולא שמע אלהם כאשר דבר יהוה׃ ");
INSERT INTO heb_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","ויאמר יהוה אל משה השכם בבקר והתיצב לפני פרעה הנה יוצא המימה ואמרת אליו כה אמר יהוה שלח עמי ויעבדני׃ ");
INSERT INTO heb_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","כי אם אינך משלח את עמי הנני משליח בך ובעבדיך ובעמך ובבתיך את הערב ומלאו בתי מצרים את הערב וגם האדמה אשר הם עליה׃ ");
INSERT INTO heb_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","והפליתי ביום ההוא את ארץ גשן אשר עמי עמד עליה לבלתי היות שם ערב למען תדע כי אני יהוה בקרב הארץ׃ ");
INSERT INTO heb_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","ושמתי פדת בין עמי ובין עמך למחר יהיה האת הזה׃ ");
INSERT INTO heb_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","ויעש יהוה כן ויבא ערב כבד ביתה פרעה ובית עבדיו ובכל ארץ מצרים תשחת הארץ מפני הערב׃ ");
INSERT INTO heb_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","ויקרא פרעה אל משה ולאהרן ויאמר לכו זבחו לאלהיכם בארץ׃ ");
INSERT INTO heb_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","ויאמר משה לא נכון לעשות כן כי תועבת מצרים נזבח ליהוה אלהינו הן נזבח את תועבת מצרים לעיניהם ולא יסקלנו׃ ");
INSERT INTO heb_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","דרך שלשת ימים נלך במדבר וזבחנו ליהוה אלהינו כאשר יאמר אלינו׃ ");
INSERT INTO heb_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","ויאמר פרעה אנכי אשלח אתכם וזבחתם ליהוה אלהיכם במדבר רק הרחק לא תרחיקו ללכת העתירו בעדי׃ ");
INSERT INTO heb_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","ויאמר משה הנה אנכי יוצא מעמך והעתרתי אל יהוה וסר הערב מפרעה מעבדיו ומעמו מחר רק אל יסף פרעה התל לבלתי שלח את העם לזבח ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","ויצא משה מעם פרעה ויעתר אל יהוה׃ ");
INSERT INTO heb_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","ויעש יהוה כדבר משה ויסר הערב מפרעה מעבדיו ומעמו לא נשאר אחד׃ ");
INSERT INTO heb_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","ויכבד פרעה את לבו גם בפעם הזאת ולא שלח את העם׃ ");
INSERT INTO heb_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","ויאמר יהוה אל משה בא אל פרעה ודברת אליו כה אמר יהוה אלהי העברים שלח את עמי ויעבדני׃ ");
INSERT INTO heb_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","כי אם מאן אתה לשלח ועודך מחזיק בם׃ ");
INSERT INTO heb_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","הנה יד יהוה הויה במקנך אשר בשדה בסוסים בחמרים בגמלים בבקר ובצאן דבר כבד מאד׃ ");
INSERT INTO heb_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","והפלה יהוה בין מקנה ישראל ובין מקנה מצרים ולא ימות מכל לבני ישראל דבר׃ ");
INSERT INTO heb_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","וישם יהוה מועד לאמר מחר יעשה יהוה הדבר הזה בארץ׃ ");
INSERT INTO heb_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","ויעש יהוה את הדבר הזה ממחרת וימת כל מקנה מצרים וממקנה בני ישראל לא מת אחד׃ ");
INSERT INTO heb_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","וישלח פרעה והנה לא מת ממקנה ישראל עד אחד ויכבד לב פרעה ולא שלח את העם׃ ");
INSERT INTO heb_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","ויאמר יהוה אל משה ואל אהרן קחו לכם מלא חפניכם פיח כבשן וזרקו משה השמימה לעיני פרעה׃ ");
INSERT INTO heb_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","והיה לאבק על כל ארץ מצרים והיה על האדם ועל הבהמה לשחין פרח אבעבעת בכל ארץ מצרים׃ ");
INSERT INTO heb_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","ויקחו את פיח הכבשן ויעמדו לפני פרעה ויזרק אתו משה השמימה ויהי שחין אבעבעת פרח באדם ובבהמה׃ ");
INSERT INTO heb_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","ולא יכלו החרטמים לעמד לפני משה מפני השחין כי היה השחין בחרטמם ובכל מצרים׃ ");
INSERT INTO heb_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","ויחזק יהוה את לב פרעה ולא שמע אלהם כאשר דבר יהוה אל משה׃ ");
INSERT INTO heb_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","ויאמר יהוה אל משה השכם בבקר והתיצב לפני פרעה ואמרת אליו כה אמר יהוה אלהי העברים שלח את עמי ויעבדני׃ ");
INSERT INTO heb_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","כי בפעם הזאת אני שלח את כל מגפתי אל לבך ובעבדיך ובעמך בעבור תדע כי אין כמני בכל הארץ׃ ");
INSERT INTO heb_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","כי עתה שלחתי את ידי ואך אותך ואת עמך בדבר ותכחד מן הארץ׃ ");
INSERT INTO heb_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","ואולם בעבור זאת העמדתיך בעבור הראתך את כחי ולמען ספר שמי בכל הארץ׃ ");
INSERT INTO heb_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","עודך מסתולל בעמי לבלתי שלחם׃ ");
INSERT INTO heb_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","הנני ממטיר כעת מחר ברד כבד מאד אשר לא היה כמהו במצרים למן היום הוסדה ועד עתה׃ ");
INSERT INTO heb_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","ועתה שלח העז את מקנך ואת כל אשר לך בשדה כל האדם והבהמה אשר ימצא בשדה ולא יאסף הביתה וירד עלהם הברד ומתו׃ ");
INSERT INTO heb_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","הירא את דבר יהוה מעבדי פרעה הניס את עבדיו ואת מקנהו אל הבתים׃ ");
INSERT INTO heb_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","ואשר לא שם לבו אל דבר יהוה ויעזב את עבדיו ואת מקנהו בשדה׃ ");
INSERT INTO heb_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","ויאמר יהוה אל משה נטה את ידך על השמים ויהי ברד בכל ארץ מצרים על האדם ועל הבהמה ועל כל עשב השדה בארץ מצרים׃ ");
INSERT INTO heb_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","ויט משה את מטהו על השמים ויהוה נתן קלת וברד ותהלך אש ארצה וימטר יהוה ברד על ארץ מצרים׃ ");
INSERT INTO heb_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","ויהי ברד ואש מתלקחת בתוך הברד כבד מאד אשר לא היה כמהו בכל ארץ מצרים מאז היתה לגוי׃ ");
INSERT INTO heb_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","ויך הברד בכל ארץ מצרים את כל אשר בשדה מאדם ועד בהמה ואת כל עשב השדה הכה הברד ואת כל עץ השדה שבר׃ ");
INSERT INTO heb_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","רק בארץ גשן אשר שם בני ישראל לא היה ברד׃ ");
INSERT INTO heb_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","וישלח פרעה ויקרא למשה ולאהרן ויאמר אלהם חטאתי הפעם יהוה הצדיק ואני ועמי הרשעים׃ ");
INSERT INTO heb_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","העתירו אל יהוה ורב מהית קלת אלהים וברד ואשלחה אתכם ולא תספון לעמד׃ ");
INSERT INTO heb_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","ויאמר אליו משה כצאתי את העיר אפרש את כפי אל יהוה הקלות יחדלון והברד לא יהיה עוד למען תדע כי ליהוה הארץ׃ ");
INSERT INTO heb_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","ואתה ועבדיך ידעתי כי טרם תיראון מפני יהוה אלהים׃ ");
INSERT INTO heb_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","והפשתה והשערה נכתה כי השערה אביב והפשתה גבעל׃ ");
INSERT INTO heb_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","והחטה והכסמת לא נכו כי אפילת הנה׃ ");
INSERT INTO heb_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","ויצא משה מעם פרעה את העיר ויפרש כפיו אל יהוה ויחדלו הקלות והברד ומטר לא נתך ארצה׃ ");
INSERT INTO heb_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","וירא פרעה כי חדל המטר והברד והקלת ויסף לחטא ויכבד לבו הוא ועבדיו׃ ");
INSERT INTO heb_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","ויחזק לב פרעה ולא שלח את בני ישראל כאשר דבר יהוה ביד משה׃ ");
INSERT INTO heb_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","ויאמר יהוה אל משה בא אל פרעה כי אני הכבדתי את לבו ואת לב עבדיו למען שתי אתתי אלה בקרבו׃ ");
INSERT INTO heb_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","ולמען תספר באזני בנך ובן בנך את אשר התעללתי במצרים ואת אתתי אשר שמתי בם וידעתם כי אני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","ויבא משה ואהרן אל פרעה ויאמרו אליו כה אמר יהוה אלהי העברים עד מתי מאנת לענת מפני שלח עמי ויעבדני׃ ");
INSERT INTO heb_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","כי אם מאן אתה לשלח את עמי הנני מביא מחר ארבה בגבלך׃ ");
INSERT INTO heb_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","וכסה את עין הארץ ולא יוכל לראת את הארץ ואכל את יתר הפלטה הנשארת לכם מן הברד ואכל את כל העץ הצמח לכם מן השדה׃ ");
INSERT INTO heb_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","ומלאו בתיך ובתי כל עבדיך ובתי כל מצרים אשר לא ראו אבתיך ואבות אבתיך מיום היותם על האדמה עד היום הזה ויפן ויצא מעם פרעה׃ ");
INSERT INTO heb_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","ויאמרו עבדי פרעה אליו עד מתי יהיה זה לנו למוקש שלח את האנשים ויעבדו את יהוה אלהיהם הטרם תדע כי אבדה מצרים׃ ");
INSERT INTO heb_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","ויושב את משה ואת אהרן אל פרעה ויאמר אלהם לכו עבדו את יהוה אלהיכם מי ומי ההלכים׃ ");
INSERT INTO heb_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","ויאמר משה בנערינו ובזקנינו נלך בבנינו ובבנותנו בצאננו ובבקרנו נלך כי חג יהוה לנו׃ ");
INSERT INTO heb_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","ויאמר אלהם יהי כן יהוה עמכם כאשר אשלח אתכם ואת טפכם ראו כי רעה נגד פניכם׃ ");
INSERT INTO heb_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","לא כן לכו נא הגברים ועבדו את יהוה כי אתה אתם מבקשים ויגרש אתם מאת פני פרעה׃ ");
INSERT INTO heb_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","ויאמר יהוה אל משה נטה ידך על ארץ מצרים בארבה ויעל על ארץ מצרים ויאכל את כל עשב הארץ את כל אשר השאיר הברד׃ ");
INSERT INTO heb_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","ויט משה את מטהו על ארץ מצרים ויהוה נהג רוח קדים בארץ כל היום ההוא וכל הלילה הבקר היה ורוח הקדים נשא את הארבה׃ ");
INSERT INTO heb_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","ויעל הארבה על כל ארץ מצרים וינח בכל גבול מצרים כבד מאד לפניו לא היה כן ארבה כמהו ואחריו לא יהיה כן׃ ");
INSERT INTO heb_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","ויכס את עין כל הארץ ותחשך הארץ ויאכל את כל עשב הארץ ואת כל פרי העץ אשר הותיר הברד ולא נותר כל ירק בעץ ובעשב השדה בכל ארץ מצרים׃ ");
INSERT INTO heb_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","וימהר פרעה לקרא למשה ולאהרן ויאמר חטאתי ליהוה אלהיכם ולכם׃ ");
INSERT INTO heb_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","ועתה שא נא חטאתי אך הפעם והעתירו ליהוה אלהיכם ויסר מעלי רק את המות הזה׃ ");
INSERT INTO heb_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","ויצא מעם פרעה ויעתר אל יהוה׃ ");
INSERT INTO heb_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","ויהפך יהוה רוח ים חזק מאד וישא את הארבה ויתקעהו ימה סוף לא נשאר ארבה אחד בכל גבול מצרים׃ ");
INSERT INTO heb_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","ויחזק יהוה את לב פרעה ולא שלח את בני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","ויאמר יהוה אל משה נטה ידך על השמים ויהי חשך על ארץ מצרים וימש חשך׃ ");
INSERT INTO heb_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","ויט משה את ידו על השמים ויהי חשך אפלה בכל ארץ מצרים שלשת ימים׃ ");
INSERT INTO heb_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","לא ראו איש את אחיו ולא קמו איש מתחתיו שלשת ימים ולכל בני ישראל היה אור במושבתם׃ ");
INSERT INTO heb_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","ויקרא פרעה אל משה ויאמר לכו עבדו את יהוה רק צאנכם ובקרכם יצג גם טפכם ילך עמכם׃ ");
INSERT INTO heb_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","ויאמר משה גם אתה תתן בידנו זבחים ועלות ועשינו ליהוה אלהינו׃ ");
INSERT INTO heb_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","וגם מקננו ילך עמנו לא תשאר פרסה כי ממנו נקח לעבד את יהוה אלהינו ואנחנו לא נדע מה נעבד את יהוה עד באנו שמה׃ ");
INSERT INTO heb_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","ויחזק יהוה את לב פרעה ולא אבה לשלחם׃ ");
INSERT INTO heb_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","ויאמר לו פרעה לך מעלי השמר לך אל תסף ראות פני כי ביום ראתך פני תמות׃ ");
INSERT INTO heb_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","ויאמר משה כן דברת לא אסף עוד ראות פניך׃ ");
INSERT INTO heb_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","ויאמר יהוה אל משה עוד נגע אחד אביא על פרעה ועל מצרים אחרי כן ישלח אתכם מזה כשלחו כלה גרש יגרש אתכם מזה׃ ");
INSERT INTO heb_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","דבר נא באזני העם וישאלו איש מאת רעהו ואשה מאת רעותה כלי כסף וכלי זהב׃ ");
INSERT INTO heb_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","ויתן יהוה את חן העם בעיני מצרים גם האיש משה גדול מאד בארץ מצרים בעיני עבדי פרעה ובעיני העם׃ ");
INSERT INTO heb_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","ויאמר משה כה אמר יהוה כחצת הלילה אני יוצא בתוך מצרים׃ ");
INSERT INTO heb_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","ומת כל בכור בארץ מצרים מבכור פרעה הישב על כסאו עד בכור השפחה אשר אחר הרחים וכל בכור בהמה׃ ");
INSERT INTO heb_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","והיתה צעקה גדלה בכל ארץ מצרים אשר כמהו לא נהיתה וכמהו לא תסף׃ ");
INSERT INTO heb_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","ולכל בני ישראל לא יחרץ כלב לשנו למאיש ועד בהמה למען תדעון אשר יפלה יהוה בין מצרים ובין ישראל׃ ");
INSERT INTO heb_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","וירדו כל עבדיך אלה אלי והשתחוו לי לאמר צא אתה וכל העם אשר ברגליך ואחרי כן אצא ויצא מעם פרעה בחרי אף׃ ");
INSERT INTO heb_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","ויאמר יהוה אל משה לא ישמע אליכם פרעה למען רבות מופתי בארץ מצרים׃ ");
INSERT INTO heb_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","ומשה ואהרן עשו את כל המפתים האלה לפני פרעה ויחזק יהוה את לב פרעה ולא שלח את בני ישראל מארצו׃ ");
INSERT INTO heb_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","ויאמר יהוה אל משה ואל אהרן בארץ מצרים לאמר׃ ");
INSERT INTO heb_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","החדש הזה לכם ראש חדשים ראשון הוא לכם לחדשי השנה׃ ");
INSERT INTO heb_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","דברו אל כל עדת ישראל לאמר בעשר לחדש הזה ויקחו להם איש שה לבית אבת שה לבית׃ ");
INSERT INTO heb_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","ואם ימעט הבית מהית משה ולקח הוא ושכנו הקרב אל ביתו במכסת נפשת איש לפי אכלו תכסו על השה׃ ");
INSERT INTO heb_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","שה תמים זכר בן שנה יהיה לכם מן הכבשים ומן העזים תקחו׃ ");
INSERT INTO heb_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","והיה לכם למשמרת עד ארבעה עשר יום לחדש הזה ושחטו אתו כל קהל עדת ישראל בין הערבים׃ ");
INSERT INTO heb_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","ולקחו מן הדם ונתנו על שתי המזוזת ועל המשקוף על הבתים אשר יאכלו אתו בהם׃ ");
INSERT INTO heb_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","ואכלו את הבשר בלילה הזה צלי אש ומצות על מררים יאכלהו׃ ");
INSERT INTO heb_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","אל תאכלו ממנו נא ובשל מבשל במים כי אם צלי אש ראשו על כרעיו ועל קרבו׃ ");
INSERT INTO heb_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","ולא תותירו ממנו עד בקר והנתר ממנו עד בקר באש תשרפו׃ ");
INSERT INTO heb_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","וככה תאכלו אתו מתניכם חגרים נעליכם ברגליכם ומקלכם בידכם ואכלתם אתו בחפזון פסח הוא ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","ועברתי בארץ מצרים בלילה הזה והכיתי כל בכור בארץ מצרים מאדם ועד בהמה ובכל אלהי מצרים אעשה שפטים אני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","והיה הדם לכם לאת על הבתים אשר אתם שם וראיתי את הדם ופסחתי עלכם ולא יהיה בכם נגף למשחית בהכתי בארץ מצרים׃ ");
INSERT INTO heb_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","והיה היום הזה לכם לזכרון וחגתם אתו חג ליהוה לדרתיכם חקת עולם תחגהו׃ ");
INSERT INTO heb_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","שבעת ימים מצות תאכלו אך ביום הראשון תשביתו שאר מבתיכם כי כל אכל חמץ ונכרתה הנפש ההוא מישראל מיום הראשן עד יום השבעי׃ ");
INSERT INTO heb_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","וביום הראשון מקרא קדש וביום השביעי מקרא קדש יהיה לכם כל מלאכה לא יעשה בהם אך אשר יאכל לכל נפש הוא לבדו יעשה לכם׃ ");
INSERT INTO heb_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","ושמרתם את המצות כי בעצם היום הזה הוצאתי את צבאותיכם מארץ מצרים ושמרתם את היום הזה לדרתיכם חקת עולם׃ ");
INSERT INTO heb_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","בראשן בארבעה עשר יום לחדש בערב תאכלו מצת עד יום האחד ועשרים לחדש בערב׃ ");
INSERT INTO heb_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","שבעת ימים שאר לא ימצא בבתיכם כי כל אכל מחמצת ונכרתה הנפש ההוא מעדת ישראל בגר ובאזרח הארץ׃ ");
INSERT INTO heb_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","כל מחמצת לא תאכלו בכל מושבתיכם תאכלו מצות׃ ");
INSERT INTO heb_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","ויקרא משה לכל זקני ישראל ויאמר אלהם משכו וקחו לכם צאן למשפחתיכם ושחטו הפסח׃ ");
INSERT INTO heb_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","ולקחתם אגדת אזוב וטבלתם בדם אשר בסף והגעתם אל המשקוף ואל שתי המזוזת מן הדם אשר בסף ואתם לא תצאו איש מפתח ביתו עד בקר׃ ");
INSERT INTO heb_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","ועבר יהוה לנגף את מצרים וראה את הדם על המשקוף ועל שתי המזוזת ופסח יהוה על הפתח ולא יתן המשחית לבא אל בתיכם לנגף׃ ");
INSERT INTO heb_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","ושמרתם את הדבר הזה לחק לך ולבניך עד עולם׃ ");
INSERT INTO heb_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","והיה כי תבאו אל הארץ אשר יתן יהוה לכם כאשר דבר ושמרתם את העבדה הזאת׃ ");
INSERT INTO heb_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","והיה כי יאמרו אליכם בניכם מה העבדה הזאת לכם׃ ");
INSERT INTO heb_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","ואמרתם זבח פסח הוא ליהוה אשר פסח על בתי בני ישראל במצרים בנגפו את מצרים ואת בתינו הציל ויקד העם וישתחוו׃ ");
INSERT INTO heb_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","וילכו ויעשו בני ישראל כאשר צוה יהוה את משה ואהרן כן עשו׃ ");
INSERT INTO heb_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","ויהי בחצי הלילה ויהוה הכה כל בכור בארץ מצרים מבכר פרעה הישב על כסאו עד בכור השבי אשר בבית הבור וכל בכור בהמה׃ ");
INSERT INTO heb_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","ויקם פרעה לילה הוא וכל עבדיו וכל מצרים ותהי צעקה גדלה במצרים כי אין בית אשר אין שם מת׃ ");
INSERT INTO heb_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","ויקרא למשה ולאהרן לילה ויאמר קומו צאו מתוך עמי גם אתם גם בני ישראל ולכו עבדו את יהוה כדברכם׃ ");
INSERT INTO heb_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","גם צאנכם גם בקרכם קחו כאשר דברתם ולכו וברכתם גם אתי׃ ");
INSERT INTO heb_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","ותחזק מצרים על העם למהר לשלחם מן הארץ כי אמרו כלנו מתים׃ ");
INSERT INTO heb_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","וישא העם את בצקו טרם יחמץ משארתם צררת בשמלתם על שכמם׃ ");
INSERT INTO heb_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","ובני ישראל עשו כדבר משה וישאלו ממצרים כלי כסף וכלי זהב ושמלת׃ ");
INSERT INTO heb_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","ויהוה נתן את חן העם בעיני מצרים וישאלום וינצלו את מצרים׃ ");
INSERT INTO heb_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","ויסעו בני ישראל מרעמסס סכתה כשש מאות אלף רגלי הגברים לבד מטף׃ ");
INSERT INTO heb_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","וגם ערב רב עלה אתם וצאן ובקר מקנה כבד מאד׃ ");
INSERT INTO heb_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","ויאפו את הבצק אשר הוציאו ממצרים עגת מצות כי לא חמץ כי גרשו ממצרים ולא יכלו להתמהמה וגם צדה לא עשו להם׃ ");
INSERT INTO heb_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","ומושב בני ישראל אשר ישבו במצרים שלשים שנה וארבע מאות שנה׃ ");
INSERT INTO heb_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","ויהי מקץ שלשים שנה וארבע מאות שנה ויהי בעצם היום הזה יצאו כל צבאות יהוה מארץ מצרים׃ ");
INSERT INTO heb_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","ליל שמרים הוא ליהוה להוציאם מארץ מצרים הוא הלילה הזה ליהוה שמרים לכל בני ישראל לדרתם׃ ");
INSERT INTO heb_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","ויאמר יהוה אל משה ואהרן זאת חקת הפסח כל בן נכר לא יאכל בו׃ ");
INSERT INTO heb_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","וכל עבד איש מקנת כסף ומלתה אתו אז יאכל בו׃ ");
INSERT INTO heb_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","תושב ושכיר לא יאכל בו׃ ");
INSERT INTO heb_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","בבית אחד יאכל לא תוציא מן הבית מן הבשר חוצה ועצם לא תשברו בו׃ ");
INSERT INTO heb_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","כל עדת ישראל יעשו אתו׃ ");
INSERT INTO heb_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","וכי יגור אתך גר ועשה פסח ליהוה המול לו כל זכר ואז יקרב לעשתו והיה כאזרח הארץ וכל ערל לא יאכל בו׃ ");
INSERT INTO heb_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","תורה אחת יהיה לאזרח ולגר הגר בתוככם׃ ");
INSERT INTO heb_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","ויעשו כל בני ישראל כאשר צוה יהוה את משה ואת אהרן כן עשו׃ ");
INSERT INTO heb_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","ויהי בעצם היום הזה הוציא יהוה את בני ישראל מארץ מצרים על צבאתם׃ ");
INSERT INTO heb_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","קדש לי כל בכור פטר כל רחם בבני ישראל באדם ובבהמה לי הוא׃ ");
INSERT INTO heb_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","ויאמר משה אל העם זכור את היום הזה אשר יצאתם ממצרים מבית עבדים כי בחזק יד הוציא יהוה אתכם מזה ולא יאכל חמץ׃ ");
INSERT INTO heb_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","היום אתם יצאים בחדש האביב׃ ");
INSERT INTO heb_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","והיה כי יביאך יהוה אל ארץ הכנעני והחתי והאמרי והחוי והיבוסי אשר נשבע לאבתיך לתת לך ארץ זבת חלב ודבש ועבדת את העבדה הזאת בחדש הזה׃ ");
INSERT INTO heb_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","שבעת ימים תאכל מצת וביום השביעי חג ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","מצות יאכל את שבעת הימים ולא יראה לך חמץ ולא יראה לך שאר בכל גבלך׃ ");
INSERT INTO heb_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","והגדת לבנך ביום ההוא לאמר בעבור זה עשה יהוה לי בצאתי ממצרים׃ ");
INSERT INTO heb_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","והיה לך לאות על ידך ולזכרון בין עיניך למען תהיה תורת יהוה בפיך כי ביד חזקה הוצאך יהוה ממצרים׃ ");
INSERT INTO heb_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","ושמרת את החקה הזאת למועדה מימים ימימה׃ ");
INSERT INTO heb_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","והיה כי יבאך יהוה אל ארץ הכנעני כאשר נשבע לך ולאבתיך ונתנה לך׃ ");
INSERT INTO heb_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","והעברת כל פטר רחם ליהוה וכל פטר שגר בהמה אשר יהיה לך הזכרים ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","וכל פטר חמר תפדה בשה ואם לא תפדה וערפתו וכל בכור אדם בבניך תפדה׃ ");
INSERT INTO heb_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","והיה כי ישאלך בנך מחר לאמר מה זאת ואמרת אליו בחזק יד הוציאנו יהוה ממצרים מבית עבדים׃ ");
INSERT INTO heb_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","ויהי כי הקשה פרעה לשלחנו ויהרג יהוה כל בכור בארץ מצרים מבכר אדם ועד בכור בהמה על כן אני זבח ליהוה כל פטר רחם הזכרים וכל בכור בני אפדה׃ ");
INSERT INTO heb_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","והיה לאות על ידכה ולטוטפת בין עיניך כי בחזק יד הוציאנו יהוה ממצרים׃ ");
INSERT INTO heb_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","ויהי בשלח פרעה את העם ולא נחם אלהים דרך ארץ פלשתים כי קרוב הוא כי אמר אלהים פן ינחם העם בראתם מלחמה ושבו מצרימה׃ ");
INSERT INTO heb_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","ויסב אלהים את העם דרך המדבר ים סוף וחמשים עלו בני ישראל מארץ מצרים׃ ");
INSERT INTO heb_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","ויקח משה את עצמות יוסף עמו כי השבע השביע את בני ישראל לאמר פקד יפקד אלהים אתכם והעליתם את עצמתי מזה אתכם׃ ");
INSERT INTO heb_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","ויסעו מסכת ויחנו באתם בקצה המדבר׃ ");
INSERT INTO heb_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","ויהוה הלך לפניהם יומם בעמוד ענן לנחתם הדרך ולילה בעמוד אש להאיר להם ללכת יומם ולילה׃ ");
INSERT INTO heb_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","לא ימיש עמוד הענן יומם ועמוד האש לילה לפני העם׃ ");
INSERT INTO heb_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","דבר אל בני ישראל וישבו ויחנו לפני פי החירת בין מגדל ובין הים לפני בעל צפן נכחו תחנו על הים׃ ");
INSERT INTO heb_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","ואמר פרעה לבני ישראל נבכים הם בארץ סגר עליהם המדבר׃ ");
INSERT INTO heb_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","וחזקתי את לב פרעה ורדף אחריהם ואכבדה בפרעה ובכל חילו וידעו מצרים כי אני יהוה ויעשו כן׃ ");
INSERT INTO heb_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","ויגד למלך מצרים כי ברח העם ויהפך לבב פרעה ועבדיו אל העם ויאמרו מה זאת עשינו כי שלחנו את ישראל מעבדנו׃ ");
INSERT INTO heb_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","ויאסר את רכבו ואת עמו לקח עמו׃ ");
INSERT INTO heb_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","ויקח שש מאות רכב בחור וכל רכב מצרים ושלשם על כלו׃ ");
INSERT INTO heb_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","ויחזק יהוה את לב פרעה מלך מצרים וירדף אחרי בני ישראל ובני ישראל יצאים ביד רמה׃ ");
INSERT INTO heb_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","וירדפו מצרים אחריהם וישיגו אותם חנים על הים כל סוס רכב פרעה ופרשיו וחילו על פי החירת לפני בעל צפן׃ ");
INSERT INTO heb_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","ופרעה הקריב וישאו בני ישראל את עיניהם והנה מצרים נסע אחריהם וייראו מאד ויצעקו בני ישראל אל יהוה׃ ");
INSERT INTO heb_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","ויאמרו אל משה המבלי אין קברים במצרים לקחתנו למות במדבר מה זאת עשית לנו להוציאנו ממצרים׃ ");
INSERT INTO heb_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","הלא זה הדבר אשר דברנו אליך במצרים לאמר חדל ממנו ונעבדה את מצרים כי טוב לנו עבד את מצרים ממתנו במדבר׃ ");
INSERT INTO heb_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","ויאמר משה אל העם אל תיראו התיצבו וראו את ישועת יהוה אשר יעשה לכם היום כי אשר ראיתם את מצרים היום לא תסיפו לראתם עוד עד עולם׃ ");
INSERT INTO heb_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","יהוה ילחם לכם ואתם תחרישון׃ ");
INSERT INTO heb_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","ויאמר יהוה אל משה מה תצעק אלי דבר אל בני ישראל ויסעו׃ ");
INSERT INTO heb_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","ואתה הרם את מטך ונטה את ידך על הים ובקעהו ויבאו בני ישראל בתוך הים ביבשה׃ ");
INSERT INTO heb_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","ואני הנני מחזק את לב מצרים ויבאו אחריהם ואכבדה בפרעה ובכל חילו ברכבו ובפרשיו׃ ");
INSERT INTO heb_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","וידעו מצרים כי אני יהוה בהכבדי בפרעה ברכבו ובפרשיו׃ ");
INSERT INTO heb_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","ויסע מלאך האלהים ההלך לפני מחנה ישראל וילך מאחריהם ויסע עמוד הענן מפניהם ויעמד מאחריהם׃ ");
INSERT INTO heb_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","ויבא בין מחנה מצרים ובין מחנה ישראל ויהי הענן והחשך ויאר את הלילה ולא קרב זה אל זה כל הלילה׃ ");
INSERT INTO heb_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","ויט משה את ידו על הים ויולך יהוה את הים ברוח קדים עזה כל הלילה וישם את הים לחרבה ויבקעו המים׃ ");
INSERT INTO heb_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","ויבאו בני ישראל בתוך הים ביבשה והמים להם חמה מימינם ומשמאלם׃ ");
INSERT INTO heb_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","וירדפו מצרים ויבאו אחריהם כל סוס פרעה רכבו ופרשיו אל תוך הים׃ ");
INSERT INTO heb_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","ויהי באשמרת הבקר וישקף יהוה אל מחנה מצרים בעמוד אש וענן ויהם את מחנה מצרים׃ ");
INSERT INTO heb_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","ויסר את אפן מרכבתיו וינהגהו בכבדת ויאמר מצרים אנוסה מפני ישראל כי יהוה נלחם להם במצרים׃ ");
INSERT INTO heb_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","ויאמר יהוה אל משה נטה את ידך על הים וישבו המים על מצרים על רכבו ועל פרשיו׃ ");
INSERT INTO heb_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","ויט משה את ידו על הים וישב הים לפנות בקר לאיתנו ומצרים נסים לקראתו וינער יהוה את מצרים בתוך הים׃ ");
INSERT INTO heb_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","וישבו המים ויכסו את הרכב ואת הפרשים לכל חיל פרעה הבאים אחריהם בים לא נשאר בהם עד אחד׃ ");
INSERT INTO heb_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","ובני ישראל הלכו ביבשה בתוך הים והמים להם חמה מימינם ומשמאלם׃ ");
INSERT INTO heb_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","ויושע יהוה ביום ההוא את ישראל מיד מצרים וירא ישראל את מצרים מת על שפת הים׃ ");
INSERT INTO heb_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","וירא ישראל את היד הגדלה אשר עשה יהוה במצרים וייראו העם את יהוה ויאמינו ביהוה ובמשה עבדו׃ ");
INSERT INTO heb_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","אז ישיר משה ובני ישראל את השירה הזאת ליהוה ויאמרו לאמר אשירה ליהוה כי גאה גאה סוס ורכבו רמה בים׃ ");
INSERT INTO heb_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","עזי וזמרת יה ויהי לי לישועה זה אלי ואנוהו אלהי אבי וארממנהו׃ ");
INSERT INTO heb_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","יהוה איש מלחמה יהוה שמו׃ ");
INSERT INTO heb_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","מרכבת פרעה וחילו ירה בים ומבחר שלשיו טבעו בים סוף׃ ");
INSERT INTO heb_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","תהמת יכסימו ירדו במצולת כמו אבן׃ ");
INSERT INTO heb_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","ימינך יהוה נאדרי בכח ימינך יהוה תרעץ אויב׃ ");
INSERT INTO heb_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","וברב גאונך תהרס קמיך תשלח חרנך יאכלמו כקש׃ ");
INSERT INTO heb_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","וברוח אפיך נערמו מים נצבו כמו נד נזלים קפאו תהמת בלב ים׃ ");
INSERT INTO heb_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","אמר אויב ארדף אשיג אחלק שלל תמלאמו נפשי אריק חרבי תורישמו ידי׃ ");
INSERT INTO heb_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","נשפת ברוחך כסמו ים צללו כעופרת במים אדירים׃ ");
INSERT INTO heb_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","מי כמכה באלם יהוה מי כמכה נאדר בקדש נורא תהלת עשה פלא׃ ");
INSERT INTO heb_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","נטית ימינך תבלעמו ארץ׃ ");
INSERT INTO heb_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","נחית בחסדך עם זו גאלת נהלת בעזך אל נוה קדשך׃ ");
INSERT INTO heb_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","שמעו עמים ירגזון חיל אחז ישבי פלשת׃ ");
INSERT INTO heb_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","אז נבהלו אלופי אדום אילי מואב יאחזמו רעד נמגו כל ישבי כנען׃ ");
INSERT INTO heb_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","תפל עליהם אימתה ופחד בגדל זרועך ידמו כאבן עד יעבר עמך יהוה עד יעבר עם זו קנית׃ ");
INSERT INTO heb_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","תבאמו ותטעמו בהר נחלתך מכון לשבתך פעלת יהוה מקדש אדני כוננו ידיך׃ ");
INSERT INTO heb_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","יהוה ימלך לעלם ועד׃ ");
INSERT INTO heb_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","כי בא סוס פרעה ברכבו ובפרשיו בים וישב יהוה עלהם את מי הים ובני ישראל הלכו ביבשה בתוך הים׃ ");
INSERT INTO heb_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","ותקח מרים הנביאה אחות אהרן את התף בידה ותצאן כל הנשים אחריה בתפים ובמחלת׃ ");
INSERT INTO heb_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","ותען להם מרים שירו ליהוה כי גאה גאה סוס ורכבו רמה בים׃ ");
INSERT INTO heb_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","ויסע משה את ישראל מים סוף ויצאו אל מדבר שור וילכו שלשת ימים במדבר ולא מצאו מים׃ ");
INSERT INTO heb_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","ויבאו מרתה ולא יכלו לשתת מים ממרה כי מרים הם על כן קרא שמה מרה׃ ");
INSERT INTO heb_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","וילנו העם על משה לאמר מה נשתה׃ ");
INSERT INTO heb_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","ויצעק אל יהוה ויורהו יהוה עץ וישלך אל המים וימתקו המים שם שם לו חק ומשפט ושם נסהו׃ ");
INSERT INTO heb_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","ויאמר אם שמוע תשמע לקול יהוה אלהיך והישר בעיניו תעשה והאזנת למצותיו ושמרת כל חקיו כל המחלה אשר שמתי במצרים לא אשים עליך כי אני יהוה רפאך׃ ");
INSERT INTO heb_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","ויבאו אילמה ושם שתים עשרה עינת מים ושבעים תמרים ויחנו שם על המים׃ ");
INSERT INTO heb_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","ויסעו מאילם ויבאו כל עדת בני ישראל אל מדבר סין אשר בין אילם ובין סיני בחמשה עשר יום לחדש השני לצאתם מארץ מצרים׃ ");
INSERT INTO heb_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","וילינו כל עדת בני ישראל על משה ועל אהרן במדבר׃ ");
INSERT INTO heb_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","ויאמרו אלהם בני ישראל מי יתן מותנו ביד יהוה בארץ מצרים בשבתנו על סיר הבשר באכלנו לחם לשבע כי הוצאתם אתנו אל המדבר הזה להמית את כל הקהל הזה ברעב׃ ");
INSERT INTO heb_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","ויאמר יהוה אל משה הנני ממטיר לכם לחם מן השמים ויצא העם ולקטו דבר יום ביומו למען אנסנו הילך בתורתי אם לא׃ ");
INSERT INTO heb_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","והיה ביום הששי והכינו את אשר יביאו והיה משנה על אשר ילקטו יום יום׃ ");
INSERT INTO heb_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","ויאמר משה ואהרן אל כל בני ישראל ערב וידעתם כי יהוה הוציא אתכם מארץ מצרים׃ ");
INSERT INTO heb_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","ובקר וראיתם את כבוד יהוה בשמעו את תלנתיכם על יהוה ונחנו מה כי תלונו עלינו׃ ");
INSERT INTO heb_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","ויאמר משה בתת יהוה לכם בערב בשר לאכל ולחם בבקר לשבע בשמע יהוה את תלנתיכם אשר אתם מלינם עליו ונחנו מה לא עלינו תלנתיכם כי על יהוה׃ ");
INSERT INTO heb_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","ויאמר משה אל אהרן אמר אל כל עדת בני ישראל קרבו לפני יהוה כי שמע את תלנתיכם׃ ");
INSERT INTO heb_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","ויהי כדבר אהרן אל כל עדת בני ישראל ויפנו אל המדבר והנה כבוד יהוה נראה בענן׃ ");
INSERT INTO heb_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","שמעתי את תלונת בני ישראל דבר אלהם לאמר בין הערבים תאכלו בשר ובבקר תשבעו לחם וידעתם כי אני יהוה אלהיכם׃ ");
INSERT INTO heb_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","ויהי בערב ותעל השלו ותכס את המחנה ובבקר היתה שכבת הטל סביב למחנה׃ ");
INSERT INTO heb_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","ותעל שכבת הטל והנה על פני המדבר דק מחספס דק ככפר על הארץ׃ ");
INSERT INTO heb_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","ויראו בני ישראל ויאמרו איש אל אחיו מן הוא כי לא ידעו מה הוא ויאמר משה אלהם הוא הלחם אשר נתן יהוה לכם לאכלה׃ ");
INSERT INTO heb_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","זה הדבר אשר צוה יהוה לקטו ממנו איש לפי אכלו עמר לגלגלת מספר נפשתיכם איש לאשר באהלו תקחו׃ ");
INSERT INTO heb_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","ויעשו כן בני ישראל וילקטו המרבה והממעיט׃ ");
INSERT INTO heb_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","וימדו בעמר ולא העדיף המרבה והממעיט לא החסיר איש לפי אכלו לקטו׃ ");
INSERT INTO heb_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","ויאמר משה אלהם איש אל יותר ממנו עד בקר׃ ");
INSERT INTO heb_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","ולא שמעו אל משה ויותרו אנשים ממנו עד בקר וירם תולעים ויבאש ויקצף עלהם משה׃ ");
INSERT INTO heb_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","וילקטו אתו בבקר בבקר איש כפי אכלו וחם השמש ונמס׃ ");
INSERT INTO heb_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","ויהי ביום הששי לקטו לחם משנה שני העמר לאחד ויבאו כל נשיאי העדה ויגידו למשה׃ ");
INSERT INTO heb_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","ויאמר אלהם הוא אשר דבר יהוה שבתון שבת קדש ליהוה מחר את אשר תאפו אפו ואת אשר תבשלו בשלו ואת כל העדף הניחו לכם למשמרת עד הבקר׃ ");
INSERT INTO heb_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","ויניחו אתו עד הבקר כאשר צוה משה ולא הבאיש ורמה לא היתה בו׃ ");
INSERT INTO heb_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","ויאמר משה אכלהו היום כי שבת היום ליהוה היום לא תמצאהו בשדה׃ ");
INSERT INTO heb_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","ששת ימים תלקטהו וביום השביעי שבת לא יהיה בו׃ ");
INSERT INTO heb_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","ויהי ביום השביעי יצאו מן העם ללקט ולא מצאו׃ ");
INSERT INTO heb_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","ויאמר יהוה אל משה עד אנה מאנתם לשמר מצותי ותורתי׃ ");
INSERT INTO heb_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","ראו כי יהוה נתן לכם השבת על כן הוא נתן לכם ביום הששי לחם יומים שבו איש תחתיו אל יצא איש ממקמו ביום השביעי׃ ");
INSERT INTO heb_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","וישבתו העם ביום השבעי׃ ");
INSERT INTO heb_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","ויקראו בית ישראל את שמו מן והוא כזרע גד לבן וטעמו כצפיחת בדבש׃ ");
INSERT INTO heb_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","ויאמר משה זה הדבר אשר צוה יהוה מלא העמר ממנו למשמרת לדרתיכם למען יראו את הלחם אשר האכלתי אתכם במדבר בהוציאי אתכם מארץ מצרים׃ ");
INSERT INTO heb_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","ויאמר משה אל אהרן קח צנצנת אחת ותן שמה מלא העמר מן והנח אתו לפני יהוה למשמרת לדרתיכם׃ ");
INSERT INTO heb_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","כאשר צוה יהוה אל משה ויניחהו אהרן לפני העדת למשמרת׃ ");
INSERT INTO heb_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","ובני ישראל אכלו את המן ארבעים שנה עד באם אל ארץ נושבת את המן אכלו עד באם אל קצה ארץ כנען׃ ");
INSERT INTO heb_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","והעמר עשרית האיפה הוא׃ ");
INSERT INTO heb_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","ויסעו כל עדת בני ישראל ממדבר סין למסעיהם על פי יהוה ויחנו ברפידים ואין מים לשתת העם׃ ");
INSERT INTO heb_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","וירב העם עם משה ויאמרו תנו לנו מים ונשתה ויאמר להם משה מה תריבון עמדי מה תנסון את יהוה׃ ");
INSERT INTO heb_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","ויצמא שם העם למים וילן העם על משה ויאמר למה זה העליתנו ממצרים להמית אתי ואת בני ואת מקני בצמא׃ ");
INSERT INTO heb_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","ויצעק משה אל יהוה לאמר מה אעשה לעם הזה עוד מעט וסקלני׃ ");
INSERT INTO heb_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","ויאמר יהוה אל משה עבר לפני העם וקח אתך מזקני ישראל ומטך אשר הכית בו את היאר קח בידך והלכת׃ ");
INSERT INTO heb_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","הנני עמד לפניך שם על הצור בחרב והכית בצור ויצאו ממנו מים ושתה העם ויעש כן משה לעיני זקני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","ויקרא שם המקום מסה ומריבה על ריב בני ישראל ועל נסתם את יהוה לאמר היש יהוה בקרבנו אם אין׃ ");
INSERT INTO heb_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","ויבא עמלק וילחם עם ישראל ברפידם׃ ");
INSERT INTO heb_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","ויאמר משה אל יהושע בחר לנו אנשים וצא הלחם בעמלק מחר אנכי נצב על ראש הגבעה ומטה האלהים בידי׃ ");
INSERT INTO heb_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","ויעש יהושע כאשר אמר לו משה להלחם בעמלק ומשה אהרן וחור עלו ראש הגבעה׃ ");
INSERT INTO heb_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","והיה כאשר ירים משה ידו וגבר ישראל וכאשר יניח ידו וגבר עמלק׃ ");
INSERT INTO heb_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","וידי משה כבדים ויקחו אבן וישימו תחתיו וישב עליה ואהרן וחור תמכו בידיו מזה אחד ומזה אחד ויהי ידיו אמונה עד בא השמש׃ ");
INSERT INTO heb_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","ויחלש יהושע את עמלק ואת עמו לפי חרב׃ ");
INSERT INTO heb_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","ויאמר יהוה אל משה כתב זאת זכרון בספר ושים באזני יהושע כי מחה אמחה את זכר עמלק מתחת השמים׃ ");
INSERT INTO heb_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","ויבן משה מזבח ויקרא שמו יהוה נסי׃ ");
INSERT INTO heb_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","ויאמר כי יד על כס יה מלחמה ליהוה בעמלק מדר דר׃ ");
INSERT INTO heb_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","וישמע יתרו כהן מדין חתן משה את כל אשר עשה אלהים למשה ולישראל עמו כי הוציא יהוה את ישראל ממצרים׃ ");
INSERT INTO heb_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","ויקח יתרו חתן משה את צפרה אשת משה אחר שלוחיה׃ ");
INSERT INTO heb_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","ואת שני בניה אשר שם האחד גרשם כי אמר גר הייתי בארץ נכריה׃ ");
INSERT INTO heb_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","ושם האחד אליעזר כי אלהי אבי בעזרי ויצלני מחרב פרעה׃ ");
INSERT INTO heb_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","ויבא יתרו חתן משה ובניו ואשתו אל משה אל המדבר אשר הוא חנה שם הר האלהים׃ ");
INSERT INTO heb_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","ויאמר אל משה אני חתנך יתרו בא אליך ואשתך ושני בניה עמה׃ ");
INSERT INTO heb_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","ויצא משה לקראת חתנו וישתחו וישק לו וישאלו איש לרעהו לשלום ויבאו האהלה׃ ");
INSERT INTO heb_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","ויספר משה לחתנו את כל אשר עשה יהוה לפרעה ולמצרים על אודת ישראל את כל התלאה אשר מצאתם בדרך ויצלם יהוה׃ ");
INSERT INTO heb_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","ויחד יתרו על כל הטובה אשר עשה יהוה לישראל אשר הצילו מיד מצרים׃ ");
INSERT INTO heb_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","ויאמר יתרו ברוך יהוה אשר הציל אתכם מיד מצרים ומיד פרעה אשר הציל את העם מתחת יד מצרים׃ ");
INSERT INTO heb_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","עתה ידעתי כי גדול יהוה מכל האלהים כי בדבר אשר זדו עליהם׃ ");
INSERT INTO heb_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","ויקח יתרו חתן משה עלה וזבחים לאלהים ויבא אהרן וכל זקני ישראל לאכל לחם עם חתן משה לפני האלהים׃ ");
INSERT INTO heb_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","ויהי ממחרת וישב משה לשפט את העם ויעמד העם על משה מן הבקר עד הערב׃ ");
INSERT INTO heb_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","וירא חתן משה את כל אשר הוא עשה לעם ויאמר מה הדבר הזה אשר אתה עשה לעם מדוע אתה יושב לבדך וכל העם נצב עליך מן בקר עד ערב׃ ");
INSERT INTO heb_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","ויאמר משה לחתנו כי יבא אלי העם לדרש אלהים׃ ");
INSERT INTO heb_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","כי יהיה להם דבר בא אלי ושפטתי בין איש ובין רעהו והודעתי את חקי האלהים ואת תורתיו׃ ");
INSERT INTO heb_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","ויאמר חתן משה אליו לא טוב הדבר אשר אתה עשה׃ ");
INSERT INTO heb_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","נבל תבל גם אתה גם העם הזה אשר עמך כי כבד ממך הדבר לא תוכל עשהו לבדך׃ ");
INSERT INTO heb_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","עתה שמע בקלי איעצך ויהי אלהים עמך היה אתה לעם מול האלהים והבאת אתה את הדברים אל האלהים׃ ");
INSERT INTO heb_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","והזהרתה אתהם את החקים ואת התורת והודעת להם את הדרך ילכו בה ואת המעשה אשר יעשון׃ ");
INSERT INTO heb_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","ואתה תחזה מכל העם אנשי חיל יראי אלהים אנשי אמת שנאי בצע ושמת עלהם שרי אלפים שרי מאות שרי חמשים ושרי עשרת׃ ");
INSERT INTO heb_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","ושפטו את העם בכל עת והיה כל הדבר הגדל יביאו אליך וכל הדבר הקטן ישפטו הם והקל מעליך ונשאו אתך׃ ");
INSERT INTO heb_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","אם את הדבר הזה תעשה וצוך אלהים ויכלת עמד וגם כל העם הזה על מקמו יבא בשלום׃ ");
INSERT INTO heb_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","וישמע משה לקול חתנו ויעש כל אשר אמר׃ ");
INSERT INTO heb_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","ויבחר משה אנשי חיל מכל ישראל ויתן אתם ראשים על העם שרי אלפים שרי מאות שרי חמשים ושרי עשרת׃ ");
INSERT INTO heb_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","ושפטו את העם בכל עת את הדבר הקשה יביאון אל משה וכל הדבר הקטן ישפוטו הם׃ ");
INSERT INTO heb_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","וישלח משה את חתנו וילך לו אל ארצו׃ ");
INSERT INTO heb_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","בחדש השלישי לצאת בני ישראל מארץ מצרים ביום הזה באו מדבר סיני׃ ");
INSERT INTO heb_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","ויסעו מרפידים ויבאו מדבר סיני ויחנו במדבר ויחן שם ישראל נגד ההר׃ ");
INSERT INTO heb_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","ומשה עלה אל האלהים ויקרא אליו יהוה מן ההר לאמר כה תאמר לבית יעקב ותגיד לבני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","אתם ראיתם אשר עשיתי למצרים ואשא אתכם על כנפי נשרים ואבא אתכם אלי׃ ");
INSERT INTO heb_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","ועתה אם שמוע תשמעו בקלי ושמרתם את בריתי והייתם לי סגלה מכל העמים כי לי כל הארץ׃ ");
INSERT INTO heb_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","ואתם תהיו לי ממלכת כהנים וגוי קדוש אלה הדברים אשר תדבר אל בני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","ויבא משה ויקרא לזקני העם וישם לפניהם את כל הדברים האלה אשר צוהו יהוה׃ ");
INSERT INTO heb_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","ויענו כל העם יחדו ויאמרו כל אשר דבר יהוה נעשה וישב משה את דברי העם אל יהוה׃ ");
INSERT INTO heb_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","ויאמר יהוה אל משה הנה אנכי בא אליך בעב הענן בעבור ישמע העם בדברי עמך וגם בך יאמינו לעולם ויגד משה את דברי העם אל יהוה׃ ");
INSERT INTO heb_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","ויאמר יהוה אל משה לך אל העם וקדשתם היום ומחר וכבסו שמלתם׃ ");
INSERT INTO heb_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","והיו נכנים ליום השלישי כי ביום השלישי ירד יהוה לעיני כל העם על הר סיני׃ ");
INSERT INTO heb_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","והגבלת את העם סביב לאמר השמרו לכם עלות בהר ונגע בקצהו כל הנגע בהר מות יומת׃ ");
INSERT INTO heb_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","לא תגע בו יד כי סקול יסקל או ירה יירה אם בהמה אם איש לא יחיה במשך היבל המה יעלו בהר׃ ");
INSERT INTO heb_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","וירד משה מן ההר אל העם ויקדש את העם ויכבסו שמלתם׃ ");
INSERT INTO heb_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","ויאמר אל העם היו נכנים לשלשת ימים אל תגשו אל אשה׃ ");
INSERT INTO heb_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","ויהי ביום השלישי בהית הבקר ויהי קלת וברקים וענן כבד על ההר וקל שפר חזק מאד ויחרד כל העם אשר במחנה׃ ");
INSERT INTO heb_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","ויוצא משה את העם לקראת האלהים מן המחנה ויתיצבו בתחתית ההר׃ ");
INSERT INTO heb_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","והר סיני עשן כלו מפני אשר ירד עליו יהוה באש ויעל עשנו כעשן הכבשן ויחרד כל ההר מאד׃ ");
INSERT INTO heb_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","ויהי קול השופר הולך וחזק מאד משה ידבר והאלהים יעננו בקול׃ ");
INSERT INTO heb_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","וירד יהוה על הר סיני אל ראש ההר ויקרא יהוה למשה אל ראש ההר ויעל משה׃ ");
INSERT INTO heb_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","ויאמר יהוה אל משה רד העד בעם פן יהרסו אל יהוה לראות ונפל ממנו רב׃ ");
INSERT INTO heb_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","וגם הכהנים הנגשים אל יהוה יתקדשו פן יפרץ בהם יהוה׃ ");
INSERT INTO heb_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","ויאמר משה אל יהוה לא יוכל העם לעלת אל הר סיני כי אתה העדתה בנו לאמר הגבל את ההר וקדשתו׃ ");
INSERT INTO heb_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","ויאמר אליו יהוה לך רד ועלית אתה ואהרן עמך והכהנים והעם אל יהרסו לעלת אל יהוה פן יפרץ בם׃ ");
INSERT INTO heb_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","וירד משה אל העם ויאמר אלהם׃ ");
INSERT INTO heb_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","וידבר אלהים את כל הדברים האלה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","אנכי יהוה אלהיך אשר הוצאתיך מארץ מצרים מבית עבדים׃ ");
INSERT INTO heb_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","לא יהיה לך אלהים אחרים על פני׃ ");
INSERT INTO heb_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","לא תעשה לך פסל וכל תמונה אשר בשמים ממעל ואשר בארץ מתחת ואשר במים מתחת לארץ׃ ");
INSERT INTO heb_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","לא תשתחוה להם ולא תעבדם כי אנכי יהוה אלהיך אל קנא פקד עון אבת על בנים על שלשים ועל רבעים לשנאי׃ ");
INSERT INTO heb_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","ועשה חסד לאלפים לאהבי ולשמרי מצותי׃ ");
INSERT INTO heb_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","לא תשא את שם יהוה אלהיך לשוא כי לא ינקה יהוה את אשר ישא את שמו לשוא׃ ");
INSERT INTO heb_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","זכור את יום השבת לקדשו׃ ");
INSERT INTO heb_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","ששת ימים תעבד ועשית כל מלאכתך׃ ");
INSERT INTO heb_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","ויום השביעי שבת ליהוה אלהיך לא תעשה כל מלאכה אתה ובנך ובתך עבדך ואמתך ובהמתך וגרך אשר בשעריך׃ ");
INSERT INTO heb_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","כי ששת ימים עשה יהוה את השמים ואת הארץ את הים ואת כל אשר בם וינח ביום השביעי על כן ברך יהוה את יום השבת ויקדשהו׃ ");
INSERT INTO heb_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","כבד את אביך ואת אמך למען יארכון ימיך על האדמה אשר יהוה אלהיך נתן לך׃ ");
INSERT INTO heb_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","לא תרצח׃ ");
INSERT INTO heb_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","לא תנאף׃ ");
INSERT INTO heb_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","לא תגנב׃ ");
INSERT INTO heb_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","לא תענה ברעך עד שקר׃ ");
INSERT INTO heb_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","לא תחמד בית רעך לא תחמד אשת רעך ועבדו ואמתו ושורו וחמרו וכל אשר לרעך׃ ");
INSERT INTO heb_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","וכל העם ראים את הקולת ואת הלפידם ואת קול השפר ואת ההר עשן וירא העם וינעו ויעמדו מרחק׃ ");
INSERT INTO heb_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","ויאמרו אל משה דבר אתה עמנו ונשמעה ואל ידבר עמנו אלהים פן נמות׃ ");
INSERT INTO heb_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","ויאמר משה אל העם אל תיראו כי לבעבור נסות אתכם בא האלהים ובעבור תהיה יראתו על פניכם לבלתי תחטאו׃ ");
INSERT INTO heb_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","ויעמד העם מרחק ומשה נגש אל הערפל אשר שם האלהים׃ ");
INSERT INTO heb_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","ויאמר יהוה אל משה כה תאמר אל בני ישראל אתם ראיתם כי מן השמים דברתי עמכם׃ ");
INSERT INTO heb_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","לא תעשון אתי אלהי כסף ואלהי זהב לא תעשו לכם׃ ");
INSERT INTO heb_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","מזבח אדמה תעשה לי וזבחת עליו את עלתיך ואת שלמיך את צאנך ואת בקרך בכל המקום אשר אזכיר את שמי אבוא אליך וברכתיך׃ ");
INSERT INTO heb_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","ואם מזבח אבנים תעשה לי לא תבנה אתהן גזית כי חרבך הנפת עליה ותחללה׃ ");
INSERT INTO heb_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","ולא תעלה במעלת על מזבחי אשר לא תגלה ערותך עליו׃ ");
INSERT INTO heb_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","ואלה המשפטים אשר תשים לפניהם׃ ");
INSERT INTO heb_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","כי תקנה עבד עברי שש שנים יעבד ובשבעת יצא לחפשי חנם׃ ");
INSERT INTO heb_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","אם בגפו יבא בגפו יצא אם בעל אשה הוא ויצאה אשתו עמו׃ ");
INSERT INTO heb_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","אם אדניו יתן לו אשה וילדה לו בנים או בנות האשה וילדיה תהיה לאדניה והוא יצא בגפו׃ ");
INSERT INTO heb_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","ואם אמר יאמר העבד אהבתי את אדני את אשתי ואת בני לא אצא חפשי׃ ");
INSERT INTO heb_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","והגישו אדניו אל האלהים והגישו אל הדלת או אל המזוזה ורצע אדניו את אזנו במרצע ועבדו לעלם׃ ");
INSERT INTO heb_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","וכי ימכר איש את בתו לאמה לא תצא כצאת העבדים׃ ");
INSERT INTO heb_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","אם רעה בעיני אדניה אשר לא יעדה והפדה לעם נכרי לא ימשל למכרה בבגדו בה׃ ");
INSERT INTO heb_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","ואם לבנו ייעדנה כמשפט הבנות יעשה לה׃ ");
INSERT INTO heb_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","אם אחרת יקח לו שארה כסותה וענתה לא יגרע׃ ");
INSERT INTO heb_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","ואם שלש אלה לא יעשה לה ויצאה חנם אין כסף׃ ");
INSERT INTO heb_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","מכה איש ומת מות יומת׃ ");
INSERT INTO heb_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","ואשר לא צדה והאלהים אנה לידו ושמתי לך מקום אשר ינוס שמה׃ ");
INSERT INTO heb_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","וכי יזד איש על רעהו להרגו בערמה מעם מזבחי תקחנו למות׃ ");
INSERT INTO heb_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","ומכה אביו ואמו מות יומת׃ ");
INSERT INTO heb_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","וגנב איש ומכרו ונמצא בידו מות יומת׃ ");
INSERT INTO heb_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","ומקלל אביו ואמו מות יומת׃ ");
INSERT INTO heb_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","וכי יריבן אנשים והכה איש את רעהו באבן או באגרף ולא ימות ונפל למשכב׃ ");
INSERT INTO heb_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","אם יקום והתהלך בחוץ על משענתו ונקה המכה רק שבתו יתן ורפא ירפא׃ ");
INSERT INTO heb_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","וכי יכה איש את עבדו או את אמתו בשבט ומת תחת ידו נקם ינקם׃ ");
INSERT INTO heb_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","אך אם יום או יומים יעמד לא יקם כי כספו הוא׃ ");
INSERT INTO heb_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","וכי ינצו אנשים ונגפו אשה הרה ויצאו ילדיה ולא יהיה אסון ענוש יענש כאשר ישית עליו בעל האשה ונתן בפללים׃ ");
INSERT INTO heb_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","ואם אסון יהיה ונתתה נפש תחת נפש׃ ");
INSERT INTO heb_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","עין תחת עין שן תחת שן יד תחת יד רגל תחת רגל׃ ");
INSERT INTO heb_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","כויה תחת כויה פצע תחת פצע חבורה תחת חבורה׃ ");
INSERT INTO heb_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","וכי יכה איש את עין עבדו או את עין אמתו ושחתה לחפשי ישלחנו תחת עינו׃ ");
INSERT INTO heb_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","ואם שן עבדו או שן אמתו יפיל לחפשי ישלחנו תחת שנו׃ ");
INSERT INTO heb_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","וכי יגח שור את איש או את אשה ומת סקול יסקל השור ולא יאכל את בשרו ובעל השור נקי׃ ");
INSERT INTO heb_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","ואם שור נגח הוא מתמל שלשם והועד בבעליו ולא ישמרנו והמית איש או אשה השור יסקל וגם בעליו יומת׃ ");
INSERT INTO heb_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","אם כפר יושת עליו ונתן פדין נפשו ככל אשר יושת עליו׃ ");
INSERT INTO heb_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","או בן יגח או בת יגח כמשפט הזה יעשה לו׃ ");
INSERT INTO heb_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","אם עבד יגח השור או אמה כסף שלשים שקלים יתן לאדניו והשור יסקל׃ ");
INSERT INTO heb_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","וכי יפתח איש בור או כי יכרה איש בר ולא יכסנו ונפל שמה שור או חמור׃ ");
INSERT INTO heb_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","בעל הבור ישלם כסף ישיב לבעליו והמת יהיה לו׃ ");
INSERT INTO heb_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","וכי יגף שור איש את שור רעהו ומת ומכרו את השור החי וחצו את כספו וגם את המת יחצון׃ ");
INSERT INTO heb_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","או נודע כי שור נגח הוא מתמול שלשם ולא ישמרנו בעליו שלם ישלם שור תחת השור והמת יהיה לו׃ ");
INSERT INTO heb_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","כי יגנב איש שור או שה וטבחו או מכרו חמשה בקר ישלם תחת השור וארבע צאן תחת השה׃ ");
INSERT INTO heb_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","אם במחתרת ימצא הגנב והכה ומת אין לו דמים׃ ");
INSERT INTO heb_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","אם זרחה השמש עליו דמים לו שלם ישלם אם אין לו ונמכר בגנבתו׃ ");
INSERT INTO heb_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","אם המצא תמצא בידו הגנבה משור עד חמור עד שה חיים שנים ישלם׃ ");
INSERT INTO heb_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","כי יבער איש שדה או כרם ושלח את בעירה ובער בשדה אחר מיטב שדהו ומיטב כרמו ישלם׃ ");
INSERT INTO heb_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","כי תצא אש ומצאה קצים ונאכל גדיש או הקמה או השדה שלם ישלם המבער את הבערה׃ ");
INSERT INTO heb_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","כי יתן איש אל רעהו כסף או כלים לשמר וגנב מבית האיש אם ימצא הגנב ישלם שנים׃ ");
INSERT INTO heb_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","אם לא ימצא הגנב ונקרב בעל הבית אל האלהים אם לא שלח ידו במלאכת רעהו׃ ");
INSERT INTO heb_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","על כל דבר פשע על שור על חמור על שה על שלמה על כל אבדה אשר יאמר כי הוא זה עד האלהים יבא דבר שניהם אשר ירשיען אלהים ישלם שנים לרעהו׃ ");
INSERT INTO heb_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","כי יתן איש אל רעהו חמור או שור או שה וכל בהמה לשמר ומת או נשבר או נשבה אין ראה׃ ");
INSERT INTO heb_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","שבעת יהוה תהיה בין שניהם אם לא שלח ידו במלאכת רעהו ולקח בעליו ולא ישלם׃ ");
INSERT INTO heb_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","ואם גנב יגנב מעמו ישלם לבעליו׃ ");
INSERT INTO heb_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","אם טרף יטרף יבאהו עד הטרפה לא ישלם׃ ");
INSERT INTO heb_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","וכי ישאל איש מעם רעהו ונשבר או מת בעליו אין עמו שלם ישלם׃ ");
INSERT INTO heb_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","אם בעליו עמו לא ישלם אם שכיר הוא בא בשכרו׃ ");
INSERT INTO heb_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","וכי יפתה איש בתולה אשר לא ארשה ושכב עמה מהר ימהרנה לו לאשה׃ ");
INSERT INTO heb_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","אם מאן ימאן אביה לתתה לו כסף ישקל כמהר הבתולת׃ ");
INSERT INTO heb_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","מכשפה לא תחיה׃ ");
INSERT INTO heb_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","כל שכב עם בהמה מות יומת׃ ");
INSERT INTO heb_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","זבח לאלהים יחרם בלתי ליהוה לבדו׃ ");
INSERT INTO heb_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","וגר לא תונה ולא תלחצנו כי גרים הייתם בארץ מצרים׃ ");
INSERT INTO heb_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","כל אלמנה ויתום לא תענון׃ ");
INSERT INTO heb_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","אם ענה תענה אתו כי אם צעק יצעק אלי שמע אשמע צעקתו׃ ");
INSERT INTO heb_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","וחרה אפי והרגתי אתכם בחרב והיו נשיכם אלמנות ובניכם יתמים׃ ");
INSERT INTO heb_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","אם כסף תלוה את עמי את העני עמך לא תהיה לו כנשה לא תשימון עליו נשך׃ ");
INSERT INTO heb_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","אם חבל תחבל שלמת רעך עד בא השמש תשיבנו לו׃ ");
INSERT INTO heb_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","כי הוא כסותה לבדה הוא שמלתו לערו במה ישכב והיה כי יצעק אלי ושמעתי כי חנון אני׃ ");
INSERT INTO heb_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","אלהים לא תקלל ונשיא בעמך לא תאר׃ ");
INSERT INTO heb_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","מלאתך ודמעך לא תאחר בכור בניך תתן לי׃ ");
INSERT INTO heb_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","כן תעשה לשרך לצאנך שבעת ימים יהיה עם אמו ביום השמיני תתנו לי׃ ");
INSERT INTO heb_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","ואנשי קדש תהיון לי ובשר בשדה טרפה לא תאכלו לכלב תשלכון אתו׃ ");
INSERT INTO heb_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","לא תשא שמע שוא אל תשת ידך עם רשע להית עד חמס׃ ");
INSERT INTO heb_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","לא תהיה אחרי רבים לרעת ולא תענה על רב לנטת אחרי רבים להטת׃ ");
INSERT INTO heb_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","ודל לא תהדר בריבו׃ ");
INSERT INTO heb_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","כי תפגע שור איבך או חמרו תעה השב תשיבנו לו׃ ");
INSERT INTO heb_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","כי תראה חמור שנאך רבץ תחת משאו וחדלת מעזב לו עזב תעזב עמו׃ ");
INSERT INTO heb_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","לא תטה משפט אבינך בריבו׃ ");
INSERT INTO heb_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","מדבר שקר תרחק ונקי וצדיק אל תהרג כי לא אצדיק רשע׃ ");
INSERT INTO heb_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","ושחד לא תקח כי השחד יעור פקחים ויסלף דברי צדיקים׃ ");
INSERT INTO heb_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","וגר לא תלחץ ואתם ידעתם את נפש הגר כי גרים הייתם בארץ מצרים׃ ");
INSERT INTO heb_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","ושש שנים תזרע את ארצך ואספת את תבואתה׃ ");
INSERT INTO heb_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","והשביעת תשמטנה ונטשתה ואכלו אביני עמך ויתרם תאכל חית השדה כן תעשה לכרמך לזיתך׃ ");
INSERT INTO heb_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","ששת ימים תעשה מעשיך וביום השביעי תשבת למען ינוח שורך וחמרך וינפש בן אמתך והגר׃ ");
INSERT INTO heb_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","ובכל אשר אמרתי אליכם תשמרו ושם אלהים אחרים לא תזכירו לא ישמע על פיך׃ ");
INSERT INTO heb_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","שלש רגלים תחג לי בשנה׃ ");
INSERT INTO heb_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","את חג המצות תשמר שבעת ימים תאכל מצות כאשר צויתך למועד חדש האביב כי בו יצאת ממצרים ולא יראו פני ריקם׃ ");
INSERT INTO heb_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","וחג הקציר בכורי מעשיך אשר תזרע בשדה וחג האסף בצאת השנה באספך את מעשיך מן השדה׃ ");
INSERT INTO heb_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","שלש פעמים בשנה יראה כל זכורך אל פני האדן יהוה׃ ");
INSERT INTO heb_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","לא תזבח על חמץ דם זבחי ולא ילין חלב חגי עד בקר׃ ");
INSERT INTO heb_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","ראשית בכורי אדמתך תביא בית יהוה אלהיך לא תבשל גדי בחלב אמו׃ ");
INSERT INTO heb_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","הנה אנכי שלח מלאך לפניך לשמרך בדרך ולהביאך אל המקום אשר הכנתי׃ ");
INSERT INTO heb_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","השמר מפניו ושמע בקלו אל תמר בו כי לא ישא לפשעכם כי שמי בקרבו׃ ");
INSERT INTO heb_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","כי אם שמע תשמע בקלו ועשית כל אשר אדבר ואיבתי את איביך וצרתי את צרריך׃ ");
INSERT INTO heb_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","כי ילך מלאכי לפניך והביאך אל האמרי והחתי והפרזי והכנעני החוי והיבוסי והכחדתיו׃ ");
INSERT INTO heb_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","לא תשתחוה לאלהיהם ולא תעבדם ולא תעשה כמעשיהם כי הרס תהרסם ושבר תשבר מצבתיהם׃ ");
INSERT INTO heb_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","ועבדתם את יהוה אלהיכם וברך את לחמך ואת מימיך והסרתי מחלה מקרבך׃ ");
INSERT INTO heb_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","לא תהיה משכלה ועקרה בארצך את מספר ימיך אמלא׃ ");
INSERT INTO heb_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","את אימתי אשלח לפניך והמתי את כל העם אשר תבא בהם ונתתי את כל איביך אליך ערף׃ ");
INSERT INTO heb_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","ושלחתי את הצרעה לפניך וגרשה את החוי את הכנעני ואת החתי מלפניך׃ ");
INSERT INTO heb_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","לא אגרשנו מפניך בשנה אחת פן תהיה הארץ שממה ורבה עליך חית השדה׃ ");
INSERT INTO heb_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","מעט מעט אגרשנו מפניך עד אשר תפרה ונחלת את הארץ׃ ");
INSERT INTO heb_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","ושתי את גבלך מים סוף ועד ים פלשתים וממדבר עד הנהר כי אתן בידכם את ישבי הארץ וגרשתמו מפניך׃ ");
INSERT INTO heb_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","לא תכרת להם ולאלהיהם ברית׃ ");
INSERT INTO heb_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","לא ישבו בארצך פן יחטיאו אתך לי כי תעבד את אלהיהם כי יהיה לך למוקש׃ ");
INSERT INTO heb_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","ואל משה אמר עלה אל יהוה אתה ואהרן נדב ואביהוא ושבעים מזקני ישראל והשתחויתם מרחק׃ ");
INSERT INTO heb_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","ונגש משה לבדו אל יהוה והם לא יגשו והעם לא יעלו עמו׃ ");
INSERT INTO heb_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","ויבא משה ויספר לעם את כל דברי יהוה ואת כל המשפטים ויען כל העם קול אחד ויאמרו כל הדברים אשר דבר יהוה נעשה׃ ");
INSERT INTO heb_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","ויכתב משה את כל דברי יהוה וישכם בבקר ויבן מזבח תחת ההר ושתים עשרה מצבה לשנים עשר שבטי ישראל׃ ");
INSERT INTO heb_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","וישלח את נערי בני ישראל ויעלו עלת ויזבחו זבחים שלמים ליהוה פרים׃ ");
INSERT INTO heb_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","ויקח משה חצי הדם וישם באגנת וחצי הדם זרק על המזבח׃ ");
INSERT INTO heb_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","ויקח ספר הברית ויקרא באזני העם ויאמרו כל אשר דבר יהוה נעשה ונשמע׃ ");
INSERT INTO heb_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","ויקח משה את הדם ויזרק על העם ויאמר הנה דם הברית אשר כרת יהוה עמכם על כל הדברים האלה׃ ");
INSERT INTO heb_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","ויעל משה ואהרן נדב ואביהוא ושבעים מזקני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","ויראו את אלהי ישראל ותחת רגליו כמעשה לבנת הספיר וכעצם השמים לטהר׃ ");
INSERT INTO heb_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","ואל אצילי בני ישראל לא שלח ידו ויחזו את האלהים ויאכלו וישתו׃ ");
INSERT INTO heb_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","ויאמר יהוה אל משה עלה אלי ההרה והיה שם ואתנה לך את לחת האבן והתורה והמצוה אשר כתבתי להורתם׃ ");
INSERT INTO heb_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","ויקם משה ויהושע משרתו ויעל משה אל הר האלהים׃ ");
INSERT INTO heb_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","ואל הזקנים אמר שבו לנו בזה עד אשר נשוב אליכם והנה אהרן וחור עמכם מי בעל דברים יגש אלהם׃ ");
INSERT INTO heb_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","ויעל משה אל ההר ויכס הענן את ההר׃ ");
INSERT INTO heb_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","וישכן כבוד יהוה על הר סיני ויכסהו הענן ששת ימים ויקרא אל משה ביום השביעי מתוך הענן׃ ");
INSERT INTO heb_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","ומראה כבוד יהוה כאש אכלת בראש ההר לעיני בני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","ויבא משה בתוך הענן ויעל אל ההר ויהי משה בהר ארבעים יום וארבעים לילה׃ ");
INSERT INTO heb_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","דבר אל בני ישראל ויקחו לי תרומה מאת כל איש אשר ידבנו לבו תקחו את תרומתי׃ ");
INSERT INTO heb_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","וזאת התרומה אשר תקחו מאתם זהב וכסף ונחשת׃ ");
INSERT INTO heb_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","ותכלת וארגמן ותולעת שני ושש ועזים׃ ");
INSERT INTO heb_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","וערת אילם מאדמים וערת תחשים ועצי שטים׃ ");
INSERT INTO heb_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","שמן למאר בשמים לשמן המשחה ולקטרת הסמים׃ ");
INSERT INTO heb_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","אבני שהם ואבני מלאים לאפד ולחשן׃ ");
INSERT INTO heb_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","ועשו לי מקדש ושכנתי בתוכם׃ ");
INSERT INTO heb_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","ככל אשר אני מראה אותך את תבנית המשכן ואת תבנית כל כליו וכן תעשו׃ ");
INSERT INTO heb_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","ועשו ארון עצי שטים אמתים וחצי ארכו ואמה וחצי רחבו ואמה וחצי קמתו׃ ");
INSERT INTO heb_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","וצפית אתו זהב טהור מבית ומחוץ תצפנו ועשית עליו זר זהב סביב׃ ");
INSERT INTO heb_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","ויצקת לו ארבע טבעת זהב ונתתה על ארבע פעמתיו ושתי טבעת על צלעו האחת ושתי טבעת על צלעו השנית׃ ");
INSERT INTO heb_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","ועשית בדי עצי שטים וצפית אתם זהב׃ ");
INSERT INTO heb_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","והבאת את הבדים בטבעת על צלעת הארן לשאת את הארן בהם׃ ");
INSERT INTO heb_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","בטבעת הארן יהיו הבדים לא יסרו ממנו׃ ");
INSERT INTO heb_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","ונתת אל הארן את העדת אשר אתן אליך׃ ");
INSERT INTO heb_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","ועשית כפרת זהב טהור אמתים וחצי ארכה ואמה וחצי רחבה׃ ");
INSERT INTO heb_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","ועשית שנים כרבים זהב מקשה תעשה אתם משני קצות הכפרת׃ ");
INSERT INTO heb_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","ועשה כרוב אחד מקצה מזה וכרוב אחד מקצה מזה מן הכפרת תעשו את הכרבים על שני קצותיו׃ ");
INSERT INTO heb_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","והיו הכרבים פרשי כנפים למעלה סככים בכנפיהם על הכפרת ופניהם איש אל אחיו אל הכפרת יהיו פני הכרבים׃ ");
INSERT INTO heb_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","ונתת את הכפרת על הארן מלמעלה ואל הארן תתן את העדת אשר אתן אליך׃ ");
INSERT INTO heb_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","ונועדתי לך שם ודברתי אתך מעל הכפרת מבין שני הכרבים אשר על ארן העדת את כל אשר אצוה אותך אל בני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","ועשית שלחן עצי שטים אמתים ארכו ואמה רחבו ואמה וחצי קמתו׃ ");
INSERT INTO heb_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","וצפית אתו זהב טהור ועשית לו זר זהב סביב׃ ");
INSERT INTO heb_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","ועשית לו מסגרת טפח סביב ועשית זר זהב למסגרתו סביב׃ ");
INSERT INTO heb_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","ועשית לו ארבע טבעת זהב ונתת את הטבעת על ארבע הפאת אשר לארבע רגליו׃ ");
INSERT INTO heb_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","לעמת המסגרת תהיין הטבעת לבתים לבדים לשאת את השלחן׃ ");
INSERT INTO heb_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","ועשית את הבדים עצי שטים וצפית אתם זהב ונשא בם את השלחן׃ ");
INSERT INTO heb_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","ועשית קערתיו וכפתיו וקשותיו ומנקיתיו אשר יסך בהן זהב טהור תעשה אתם׃ ");
INSERT INTO heb_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","ונתת על השלחן לחם פנים לפני תמיד׃ ");
INSERT INTO heb_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","ועשית מנרת זהב טהור מקשה תעשה המנורה ירכה וקנה גביעיה כפתריה ופרחיה ממנה יהיו׃ ");
INSERT INTO heb_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","וששה קנים יצאים מצדיה שלשה קני מנרה מצדה האחד ושלשה קני מנרה מצדה השני׃ ");
INSERT INTO heb_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","שלשה גבעים משקדים בקנה האחד כפתר ופרח ושלשה גבעים משקדים בקנה האחד כפתר ופרח כן לששת הקנים היצאים מן המנרה׃ ");
INSERT INTO heb_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","ובמנרה ארבעה גבעים משקדים כפתריה ופרחיה׃ ");
INSERT INTO heb_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","וכפתר תחת שני הקנים ממנה וכפתר תחת שני הקנים ממנה וכפתר תחת שני הקנים ממנה לששת הקנים היצאים מן המנרה׃ ");
INSERT INTO heb_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","כפתריהם וקנתם ממנה יהיו כלה מקשה אחת זהב טהור׃ ");
INSERT INTO heb_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","ועשית את נרתיה שבעה והעלה את נרתיה והאיר על עבר פניה׃ ");
INSERT INTO heb_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","ומלקחיה ומחתתיה זהב טהור׃ ");
INSERT INTO heb_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","ככר זהב טהור יעשה אתה את כל הכלים האלה׃ ");
INSERT INTO heb_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","וראה ועשה בתבניתם אשר אתה מראה בהר׃ ");
INSERT INTO heb_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","ואת המשכן תעשה עשר יריעת שש משזר ותכלת וארגמן ותלעת שני כרבים מעשה חשב תעשה אתם׃ ");
INSERT INTO heb_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","ארך היריעה האחת שמנה ועשרים באמה ורחב ארבע באמה היריעה האחת מדה אחת לכל היריעת׃ ");
INSERT INTO heb_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","חמש היריעת תהיין חברת אשה אל אחתה וחמש יריעת חברת אשה אל אחתה׃ ");
INSERT INTO heb_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","ועשית ללאת תכלת על שפת היריעה האחת מקצה בחברת וכן תעשה בשפת היריעה הקיצונה במחברת השנית׃ ");
INSERT INTO heb_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","חמשים ללאת תעשה ביריעה האחת וחמשים ללאת תעשה בקצה היריעה אשר במחברת השנית מקבילת הללאת אשה אל אחתה׃ ");
INSERT INTO heb_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","ועשית חמשים קרסי זהב וחברת את היריעת אשה אל אחתה בקרסים והיה המשכן אחד׃ ");
INSERT INTO heb_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","ועשית יריעת עזים לאהל על המשכן עשתי עשרה יריעת תעשה אתם׃ ");
INSERT INTO heb_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","ארך היריעה האחת שלשים באמה ורחב ארבע באמה היריעה האחת מדה אחת לעשתי עשרה יריעת׃ ");
INSERT INTO heb_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","וחברת את חמש היריעת לבד ואת שש היריעת לבד וכפלת את היריעה הששית אל מול פני האהל׃ ");
INSERT INTO heb_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","ועשית חמשים ללאת על שפת היריעה האחת הקיצנה בחברת וחמשים ללאת על שפת היריעה החברת השנית׃ ");
INSERT INTO heb_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","ועשית קרסי נחשת חמשים והבאת את הקרסים בללאת וחברת את האהל והיה אחד׃ ");
INSERT INTO heb_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","וסרח העדף ביריעת האהל חצי היריעה העדפת תסרח על אחרי המשכן׃ ");
INSERT INTO heb_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","והאמה מזה והאמה מזה בעדף בארך יריעת האהל יהיה סרוח על צדי המשכן מזה ומזה לכסתו׃ ");
INSERT INTO heb_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","ועשית מכסה לאהל ערת אילם מאדמים ומכסה ערת תחשים מלמעלה׃ ");
INSERT INTO heb_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","ועשית את הקרשים למשכן עצי שטים עמדים׃ ");
INSERT INTO heb_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","עשר אמות ארך הקרש ואמה וחצי האמה רחב הקרש האחד׃ ");
INSERT INTO heb_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","שתי ידות לקרש האחד משלבת אשה אל אחתה כן תעשה לכל קרשי המשכן׃ ");
INSERT INTO heb_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","ועשית את הקרשים למשכן עשרים קרש לפאת נגבה תימנה׃ ");
INSERT INTO heb_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","וארבעים אדני כסף תעשה תחת עשרים הקרש שני אדנים תחת הקרש האחד לשתי ידתיו ושני אדנים תחת הקרש האחד לשתי ידתיו׃ ");
INSERT INTO heb_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","ולצלע המשכן השנית לפאת צפון עשרים קרש׃ ");
INSERT INTO heb_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","וארבעים אדניהם כסף שני אדנים תחת הקרש האחד ושני אדנים תחת הקרש האחד׃ ");
INSERT INTO heb_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","ולירכתי המשכן ימה תעשה ששה קרשים׃ ");
INSERT INTO heb_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","ושני קרשים תעשה למקצעת המשכן בירכתים׃ ");
INSERT INTO heb_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","ויהיו תאמים מלמטה ויחדו יהיו תמים על ראשו אל הטבעת האחת כן יהיה לשניהם לשני המקצעת יהיו׃ ");
INSERT INTO heb_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","והיו שמנה קרשים ואדניהם כסף ששה עשר אדנים שני אדנים תחת הקרש האחד ושני אדנים תחת הקרש האחד׃ ");
INSERT INTO heb_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","ועשית בריחם עצי שטים חמשה לקרשי צלע המשכן האחד׃ ");
INSERT INTO heb_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","וחמשה בריחם לקרשי צלע המשכן השנית וחמשה בריחם לקרשי צלע המשכן לירכתים ימה׃ ");
INSERT INTO heb_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","והבריח התיכן בתוך הקרשים מברח מן הקצה אל הקצה׃ ");
INSERT INTO heb_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","ואת הקרשים תצפה זהב ואת טבעתיהם תעשה זהב בתים לבריחם וצפית את הבריחם זהב׃ ");
INSERT INTO heb_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","והקמת את המשכן כמשפטו אשר הראית בהר׃ ");
INSERT INTO heb_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","ועשית פרכת תכלת וארגמן ותולעת שני ושש משזר מעשה חשב יעשה אתה כרבים׃ ");
INSERT INTO heb_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","ונתתה אתה על ארבעה עמודי שטים מצפים זהב וויהם זהב על ארבעה אדני כסף׃ ");
INSERT INTO heb_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","ונתתה את הפרכת תחת הקרסים והבאת שמה מבית לפרכת את ארון העדות והבדילה הפרכת לכם בין הקדש ובין קדש הקדשים׃ ");
INSERT INTO heb_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","ונתת את הכפרת על ארון העדת בקדש הקדשים׃ ");
INSERT INTO heb_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","ושמת את השלחן מחוץ לפרכת ואת המנרה נכח השלחן על צלע המשכן תימנה והשלחן תתן על צלע צפון׃ ");
INSERT INTO heb_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","ועשית מסך לפתח האהל תכלת וארגמן ותולעת שני ושש משזר מעשה רקם׃ ");
INSERT INTO heb_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","ועשית למסך חמשה עמודי שטים וצפית אתם זהב וויהם זהב ויצקת להם חמשה אדני נחשת׃ ");
INSERT INTO heb_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","ועשית את המזבח עצי שטים חמש אמות ארך וחמש אמות רחב רבוע יהיה המזבח ושלש אמות קמתו׃ ");
INSERT INTO heb_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","ועשית קרנתיו על ארבע פנתיו ממנו תהיין קרנתיו וצפית אתו נחשת׃ ");
INSERT INTO heb_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","ועשית סירתיו לדשנו ויעיו ומזרקתיו ומזלגתיו ומחתתיו לכל כליו תעשה נחשת׃ ");
INSERT INTO heb_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","ועשית לו מכבר מעשה רשת נחשת ועשית על הרשת ארבע טבעת נחשת על ארבע קצותיו׃ ");
INSERT INTO heb_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","ונתתה אתה תחת כרכב המזבח מלמטה והיתה הרשת עד חצי המזבח׃ ");
INSERT INTO heb_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","ועשית בדים למזבח בדי עצי שטים וצפית אתם נחשת׃ ");
INSERT INTO heb_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","והובא את בדיו בטבעת והיו הבדים על שתי צלעת המזבח בשאת אתו׃ ");
INSERT INTO heb_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","נבוב לחת תעשה אתו כאשר הראה אתך בהר כן יעשו׃ ");
INSERT INTO heb_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","ועשית את חצר המשכן לפאת נגב תימנה קלעים לחצר שש משזר מאה באמה ארך לפאה האחת׃ ");
INSERT INTO heb_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","ועמדיו עשרים ואדניהם עשרים נחשת ווי העמדים וחשקיהם כסף׃ ");
INSERT INTO heb_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","וכן לפאת צפון בארך קלעים מאה ארך ועמדו עשרים ואדניהם עשרים נחשת ווי העמדים וחשקיהם כסף׃ ");
INSERT INTO heb_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","ורחב החצר לפאת ים קלעים חמשים אמה עמדיהם עשרה ואדניהם עשרה׃ ");
INSERT INTO heb_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","ורחב החצר לפאת קדמה מזרחה חמשים אמה׃ ");
INSERT INTO heb_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","וחמש עשרה אמה קלעים לכתף עמדיהם שלשה ואדניהם שלשה׃ ");
INSERT INTO heb_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","ולכתף השנית חמש עשרה קלעים עמדיהם שלשה ואדניהם שלשה׃ ");
INSERT INTO heb_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","ולשער החצר מסך עשרים אמה תכלת וארגמן ותולעת שני ושש משזר מעשה רקם עמדיהם ארבעה ואדניהם ארבעה׃ ");
INSERT INTO heb_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","כל עמודי החצר סביב מחשקים כסף וויהם כסף ואדניהם נחשת׃ ");
INSERT INTO heb_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","ארך החצר מאה באמה ורחב חמשים בחמשים וקמה חמש אמות שש משזר ואדניהם נחשת׃ ");
INSERT INTO heb_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","לכל כלי המשכן בכל עבדתו וכל יתדתיו וכל יתדת החצר נחשת׃ ");
INSERT INTO heb_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","ואתה תצוה את בני ישראל ויקחו אליך שמן זית זך כתית למאור להעלת נר תמיד׃ ");
INSERT INTO heb_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","באהל מועד מחוץ לפרכת אשר על העדת יערך אתו אהרן ובניו מערב עד בקר לפני יהוה חקת עולם לדרתם מאת בני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","ואתה הקרב אליך את אהרן אחיך ואת בניו אתו מתוך בני ישראל לכהנו לי אהרן נדב ואביהוא אלעזר ואיתמר בני אהרן׃ ");
INSERT INTO heb_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","ועשית בגדי קדש לאהרן אחיך לכבוד ולתפארת׃ ");
INSERT INTO heb_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","ואתה תדבר אל כל חכמי לב אשר מלאתיו רוח חכמה ועשו את בגדי אהרן לקדשו לכהנו לי׃ ");
INSERT INTO heb_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","ואלה הבגדים אשר יעשו חשן ואפוד ומעיל וכתנת תשבץ מצנפת ואבנט ועשו בגדי קדש לאהרן אחיך ולבניו לכהנו לי׃ ");
INSERT INTO heb_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","והם יקחו את הזהב ואת התכלת ואת הארגמן ואת תולעת השני ואת השש׃ ");
INSERT INTO heb_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","ועשו את האפד זהב תכלת וארגמן תולעת שני ושש משזר מעשה חשב׃ ");
INSERT INTO heb_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","שתי כתפת חברת יהיה לו אל שני קצותיו וחבר׃ ");
INSERT INTO heb_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","וחשב אפדתו אשר עליו כמעשהו ממנו יהיה זהב תכלת וארגמן ותולעת שני ושש משזר׃ ");
INSERT INTO heb_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","ולקחת את שתי אבני שהם ופתחת עליהם שמות בני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","ששה משמתם על האבן האחת ואת שמות הששה הנותרים על האבן השנית כתולדתם׃ ");
INSERT INTO heb_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","מעשה חרש אבן פתוחי חתם תפתח את שתי האבנים על שמת בני ישראל מסבת משבצות זהב תעשה אתם׃ ");
INSERT INTO heb_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","ושמת את שתי האבנים על כתפת האפד אבני זכרן לבני ישראל ונשא אהרן את שמותם לפני יהוה על שתי כתפיו לזכרן׃ ");
INSERT INTO heb_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","ועשית משבצת זהב׃ ");
INSERT INTO heb_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","ושתי שרשרת זהב טהור מגבלת תעשה אתם מעשה עבת ונתתה את שרשרת העבתת על המשבצת׃ ");
INSERT INTO heb_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","ועשית חשן משפט מעשה חשב כמעשה אפד תעשנו זהב תכלת וארגמן ותולעת שני ושש משזר תעשה אתו׃ ");
INSERT INTO heb_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","רבוע יהיה כפול זרת ארכו וזרת רחבו׃ ");
INSERT INTO heb_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","ומלאת בו מלאת אבן ארבעה טורים אבן טור אדם פטדה וברקת הטור האחד׃ ");
INSERT INTO heb_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","והטור השני נפך ספיר ויהלם׃ ");
INSERT INTO heb_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","והטור השלישי לשם שבו ואחלמה׃ ");
INSERT INTO heb_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","והטור הרביעי תרשיש ושהם וישפה משבצים זהב יהיו במלואתם׃ ");
INSERT INTO heb_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","והאבנים תהיין על שמת בני ישראל שתים עשרה על שמתם פתוחי חותם איש על שמו תהיין לשני עשר שבט׃ ");
INSERT INTO heb_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","ועשית על החשן שרשת גבלת מעשה עבת זהב טהור׃ ");
INSERT INTO heb_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","ועשית על החשן שתי טבעות זהב ונתת את שתי הטבעות על שני קצות החשן׃ ");
INSERT INTO heb_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","ונתתה את שתי עבתת הזהב על שתי הטבעת אל קצות החשן׃ ");
INSERT INTO heb_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","ואת שתי קצות שתי העבתת תתן על שתי המשבצות ונתתה על כתפות האפד אל מול פניו׃ ");
INSERT INTO heb_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","ועשית שתי טבעות זהב ושמת אתם על שני קצות החשן על שפתו אשר אל עבר האפד ביתה׃ ");
INSERT INTO heb_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","ועשית שתי טבעות זהב ונתתה אתם על שתי כתפות האפוד מלמטה ממול פניו לעמת מחברתו ממעל לחשב האפוד׃ ");
INSERT INTO heb_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","וירכסו את החשן מטבעתו אל טבעת האפד בפתיל תכלת להיות על חשב האפוד ולא יזח החשן מעל האפוד׃ ");
INSERT INTO heb_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","ונשא אהרן את שמות בני ישראל בחשן המשפט על לבו בבאו אל הקדש לזכרן לפני יהוה תמיד׃ ");
INSERT INTO heb_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","ונתת אל חשן המשפט את האורים ואת התמים והיו על לב אהרן בבאו לפני יהוה ונשא אהרן את משפט בני ישראל על לבו לפני יהוה תמיד׃ ");
INSERT INTO heb_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","ועשית את מעיל האפוד כליל תכלת׃ ");
INSERT INTO heb_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","והיה פי ראשו בתוכו שפה יהיה לפיו סביב מעשה ארג כפי תחרא יהיה לו לא יקרע׃ ");
INSERT INTO heb_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","ועשית על שוליו רמני תכלת וארגמן ותולעת שני על שוליו סביב ופעמני זהב בתוכם סביב׃ ");
INSERT INTO heb_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","פעמן זהב ורמון פעמן זהב ורמון על שולי המעיל סביב׃ ");
INSERT INTO heb_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","והיה על אהרן לשרת ונשמע קולו בבאו אל הקדש לפני יהוה ובצאתו ולא ימות׃ ");
INSERT INTO heb_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","ועשית ציץ זהב טהור ופתחת עליו פתוחי חתם קדש ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","ושמת אתו על פתיל תכלת והיה על המצנפת אל מול פני המצנפת יהיה׃ ");
INSERT INTO heb_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","והיה על מצח אהרן ונשא אהרן את עון הקדשים אשר יקדישו בני ישראל לכל מתנת קדשיהם והיה על מצחו תמיד לרצון להם לפני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","ושבצת הכתנת שש ועשית מצנפת שש ואבנט תעשה מעשה רקם׃ ");
INSERT INTO heb_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","ולבני אהרן תעשה כתנת ועשית להם אבנטים ומגבעות תעשה להם לכבוד ולתפארת׃ ");
INSERT INTO heb_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","והלבשת אתם את אהרן אחיך ואת בניו אתו ומשחת אתם ומלאת את ידם וקדשת אתם וכהנו לי׃ ");
INSERT INTO heb_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","ועשה להם מכנסי בד לכסות בשר ערוה ממתנים ועד ירכים יהיו׃ ");
INSERT INTO heb_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","והיו על אהרן ועל בניו בבאם אל אהל מועד או בגשתם אל המזבח לשרת בקדש ולא ישאו עון ומתו חקת עולם לו ולזרעו אחריו׃ ");
INSERT INTO heb_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","וזה הדבר אשר תעשה להם לקדש אתם לכהן לי לקח פר אחד בן בקר ואילם שנים תמימם׃ ");
INSERT INTO heb_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","ולחם מצות וחלת מצת בלולת בשמן ורקיקי מצות משחים בשמן סלת חטים תעשה אתם׃ ");
INSERT INTO heb_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","ונתת אותם על סל אחד והקרבת אתם בסל ואת הפר ואת שני האילם׃ ");
INSERT INTO heb_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","ואת אהרן ואת בניו תקריב אל פתח אהל מועד ורחצת אתם במים׃ ");
INSERT INTO heb_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","ולקחת את הבגדים והלבשת את אהרן את הכתנת ואת מעיל האפד ואת האפד ואת החשן ואפדת לו בחשב האפד׃ ");
INSERT INTO heb_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","ושמת המצנפת על ראשו ונתת את נזר הקדש על המצנפת׃ ");
INSERT INTO heb_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","ולקחת את שמן המשחה ויצקת על ראשו ומשחת אתו׃ ");
INSERT INTO heb_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","ואת בניו תקריב והלבשתם כתנת׃ ");
INSERT INTO heb_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","וחגרת אתם אבנט אהרן ובניו וחבשת להם מגבעת והיתה להם כהנה לחקת עולם ומלאת יד אהרן ויד בניו׃ ");
INSERT INTO heb_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","והקרבת את הפר לפני אהל מועד וסמך אהרן ובניו את ידיהם על ראש הפר׃ ");
INSERT INTO heb_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","ושחטת את הפר לפני יהוה פתח אהל מועד׃ ");
INSERT INTO heb_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","ולקחת מדם הפר ונתתה על קרנת המזבח באצבעך ואת כל הדם תשפך אל יסוד המזבח׃ ");
INSERT INTO heb_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","ולקחת את כל החלב המכסה את הקרב ואת היתרת על הכבד ואת שתי הכלית ואת החלב אשר עליהן והקטרת המזבחה׃ ");
INSERT INTO heb_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","ואת בשר הפר ואת ערו ואת פרשו תשרף באש מחוץ למחנה חטאת הוא׃ ");
INSERT INTO heb_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","ואת האיל האחד תקח וסמכו אהרן ובניו את ידיהם על ראש האיל׃ ");
INSERT INTO heb_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","ושחטת את האיל ולקחת את דמו וזרקת על המזבח סביב׃ ");
INSERT INTO heb_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","ואת האיל תנתח לנתחיו ורחצת קרבו וכרעיו ונתת על נתחיו ועל ראשו׃ ");
INSERT INTO heb_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","והקטרת את כל האיל המזבחה עלה הוא ליהוה ריח ניחוח אשה ליהוה הוא׃ ");
INSERT INTO heb_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","ולקחת את האיל השני וסמך אהרן ובניו את ידיהם על ראש האיל׃ ");
INSERT INTO heb_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","ושחטת את האיל ולקחת מדמו ונתתה על תנוך אזן אהרן ועל תנוך אזן בניו הימנית ועל בהן ידם הימנית ועל בהן רגלם הימנית וזרקת את הדם על המזבח סביב׃ ");
INSERT INTO heb_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","ולקחת מן הדם אשר על המזבח ומשמן המשחה והזית על אהרן ועל בגדיו ועל בניו ועל בגדי בניו אתו וקדש הוא ובגדיו ובניו ובגדי בניו אתו׃ ");
INSERT INTO heb_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","ולקחת מן האיל החלב והאליה ואת החלב המכסה את הקרב ואת יתרת הכבד ואת שתי הכלית ואת החלב אשר עליהן ואת שוק הימין כי איל מלאים הוא׃ ");
INSERT INTO heb_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","וככר לחם אחת וחלת לחם שמן אחת ורקיק אחד מסל המצות אשר לפני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","ושמת הכל על כפי אהרן ועל כפי בניו והנפת אתם תנופה לפני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","ולקחת אתם מידם והקטרת המזבחה על העלה לריח ניחוח לפני יהוה אשה הוא ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","ולקחת את החזה מאיל המלאים אשר לאהרן והנפת אתו תנופה לפני יהוה והיה לך למנה׃ ");
INSERT INTO heb_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","וקדשת את חזה התנופה ואת שוק התרומה אשר הונף ואשר הורם מאיל המלאים מאשר לאהרן ומאשר לבניו׃ ");
INSERT INTO heb_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","והיה לאהרן ולבניו לחק עולם מאת בני ישראל כי תרומה הוא ותרומה יהיה מאת בני ישראל מזבחי שלמיהם תרומתם ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","ובגדי הקדש אשר לאהרן יהיו לבניו אחריו למשחה בהם ולמלא בם את ידם׃ ");
INSERT INTO heb_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","שבעת ימים ילבשם הכהן תחתיו מבניו אשר יבא אל אהל מועד לשרת בקדש׃ ");
INSERT INTO heb_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","ואת איל המלאים תקח ובשלת את בשרו במקם קדש׃ ");
INSERT INTO heb_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","ואכל אהרן ובניו את בשר האיל ואת הלחם אשר בסל פתח אהל מועד׃ ");
INSERT INTO heb_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","ואכלו אתם אשר כפר בהם למלא את ידם לקדש אתם וזר לא יאכל כי קדש הם׃ ");
INSERT INTO heb_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","ואם יותר מבשר המלאים ומן הלחם עד הבקר ושרפת את הנותר באש לא יאכל כי קדש הוא׃ ");
INSERT INTO heb_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","ועשית לאהרן ולבניו ככה ככל אשר צויתי אתכה שבעת ימים תמלא ידם׃ ");
INSERT INTO heb_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","ופר חטאת תעשה ליום על הכפרים וחטאת על המזבח בכפרך עליו ומשחת אתו לקדשו׃ ");
INSERT INTO heb_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","שבעת ימים תכפר על המזבח וקדשת אתו והיה המזבח קדש קדשים כל הנגע במזבח יקדש׃ ");
INSERT INTO heb_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","וזה אשר תעשה על המזבח כבשים בני שנה שנים ליום תמיד׃ ");
INSERT INTO heb_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","את הכבש האחד תעשה בבקר ואת הכבש השני תעשה בין הערבים׃ ");
INSERT INTO heb_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","ועשרן סלת בלול בשמן כתית רבע ההין ונסך רבעית ההין יין לכבש האחד׃ ");
INSERT INTO heb_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","ואת הכבש השני תעשה בין הערבים כמנחת הבקר וכנסכה תעשה לה לריח ניחח אשה ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","עלת תמיד לדרתיכם פתח אהל מועד לפני יהוה אשר אועד לכם שמה לדבר אליך שם׃ ");
INSERT INTO heb_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","ונעדתי שמה לבני ישראל ונקדש בכבדי׃ ");
INSERT INTO heb_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","וקדשתי את אהל מועד ואת המזבח ואת אהרן ואת בניו אקדש לכהן לי׃ ");
INSERT INTO heb_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","ושכנתי בתוך בני ישראל והייתי להם לאלהים׃ ");
INSERT INTO heb_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","וידעו כי אני יהוה אלהיהם אשר הוצאתי אתם מארץ מצרים לשכני בתוכם אני יהוה אלהיהם׃ ");
INSERT INTO heb_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","ועשית מזבח מקטר קטרת עצי שטים תעשה אתו׃ ");
INSERT INTO heb_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","אמה ארכו ואמה רחבו רבוע יהיה ואמתים קמתו ממנו קרנתיו׃ ");
INSERT INTO heb_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","וצפית אתו זהב טהור את גגו ואת קירתיו סביב ואת קרנתיו ועשית לו זר זהב סביב׃ ");
INSERT INTO heb_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","ושתי טבעת זהב תעשה לו מתחת לזרו על שתי צלעתיו תעשה על שני צדיו והיה לבתים לבדים לשאת אתו בהמה׃ ");
INSERT INTO heb_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","ועשית את הבדים עצי שטים וצפית אתם זהב׃ ");
INSERT INTO heb_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","ונתתה אתו לפני הפרכת אשר על ארן העדת לפני הכפרת אשר על העדת אשר אועד לך שמה׃ ");
INSERT INTO heb_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","והקטיר עליו אהרן קטרת סמים בבקר בבקר בהיטיבו את הנרת יקטירנה׃ ");
INSERT INTO heb_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","ובהעלת אהרן את הנרת בין הערבים יקטירנה קטרת תמיד לפני יהוה לדרתיכם׃ ");
INSERT INTO heb_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","לא תעלו עליו קטרת זרה ועלה ומנחה ונסך לא תסכו עליו׃ ");
INSERT INTO heb_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","וכפר אהרן על קרנתיו אחת בשנה מדם חטאת הכפרים אחת בשנה יכפר עליו לדרתיכם קדש קדשים הוא ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","כי תשא את ראש בני ישראל לפקדיהם ונתנו איש כפר נפשו ליהוה בפקד אתם ולא יהיה בהם נגף בפקד אתם׃ ");
INSERT INTO heb_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","זה יתנו כל העבר על הפקדים מחצית השקל בשקל הקדש עשרים גרה השקל מחצית השקל תרומה ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","כל העבר על הפקדים מבן עשרים שנה ומעלה יתן תרומת יהוה׃ ");
INSERT INTO heb_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","העשיר לא ירבה והדל לא ימעיט ממחצית השקל לתת את תרומת יהוה לכפר על נפשתיכם׃ ");
INSERT INTO heb_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","ולקחת את כסף הכפרים מאת בני ישראל ונתת אתו על עבדת אהל מועד והיה לבני ישראל לזכרון לפני יהוה לכפר על נפשתיכם׃ ");
INSERT INTO heb_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","ועשית כיור נחשת וכנו נחשת לרחצה ונתת אתו בין אהל מועד ובין המזבח ונתת שמה מים׃ ");
INSERT INTO heb_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","ורחצו אהרן ובניו ממנו את ידיהם ואת רגליהם׃ ");
INSERT INTO heb_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","בבאם אל אהל מועד ירחצו מים ולא ימתו או בגשתם אל המזבח לשרת להקטיר אשה ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","ורחצו ידיהם ורגליהם ולא ימתו והיתה להם חק עולם לו ולזרעו לדרתם׃ ");
INSERT INTO heb_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","ואתה קח לך בשמים ראש מר דרור חמש מאות וקנמן בשם מחציתו חמשים ומאתים וקנה בשם חמשים ומאתים׃ ");
INSERT INTO heb_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","וקדה חמש מאות בשקל הקדש ושמן זית הין׃ ");
INSERT INTO heb_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","ועשית אתו שמן משחת קדש רקח מרקחת מעשה רקח שמן משחת קדש יהיה׃ ");
INSERT INTO heb_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","ומשחת בו את אהל מועד ואת ארון העדת׃ ");
INSERT INTO heb_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","ואת השלחן ואת כל כליו ואת המנרה ואת כליה ואת מזבח הקטרת׃ ");
INSERT INTO heb_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","ואת מזבח העלה ואת כל כליו ואת הכיר ואת כנו׃ ");
INSERT INTO heb_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","וקדשת אתם והיו קדש קדשים כל הנגע בהם יקדש׃ ");
INSERT INTO heb_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","ואת אהרן ואת בניו תמשח וקדשת אתם לכהן לי׃ ");
INSERT INTO heb_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","ואל בני ישראל תדבר לאמר שמן משחת קדש יהיה זה לי לדרתיכם׃ ");
INSERT INTO heb_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","על בשר אדם לא ייסך ובמתכנתו לא תעשו כמהו קדש הוא קדש יהיה לכם׃ ");
INSERT INTO heb_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","איש אשר ירקח כמהו ואשר יתן ממנו על זר ונכרת מעמיו׃ ");
INSERT INTO heb_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","ויאמר יהוה אל משה קח לך סמים נטף ושחלת וחלבנה סמים ולבנה זכה בד בבד יהיה׃ ");
INSERT INTO heb_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","ועשית אתה קטרת רקח מעשה רוקח ממלח טהור קדש׃ ");
INSERT INTO heb_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","ושחקת ממנה הדק ונתתה ממנה לפני העדת באהל מועד אשר אועד לך שמה קדש קדשים תהיה לכם׃ ");
INSERT INTO heb_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","והקטרת אשר תעשה במתכנתה לא תעשו לכם קדש תהיה לך ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","איש אשר יעשה כמוה להריח בה ונכרת מעמיו׃ ");
INSERT INTO heb_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","ראה קראתי בשם בצלאל בן אורי בן חור למטה יהודה׃ ");
INSERT INTO heb_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","ואמלא אתו רוח אלהים בחכמה ובתבונה ובדעת ובכל מלאכה׃ ");
INSERT INTO heb_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","לחשב מחשבת לעשות בזהב ובכסף ובנחשת׃ ");
INSERT INTO heb_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","ובחרשת אבן למלאת ובחרשת עץ לעשות בכל מלאכה׃ ");
INSERT INTO heb_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","ואני הנה נתתי אתו את אהליאב בן אחיסמך למטה דן ובלב כל חכם לב נתתי חכמה ועשו את כל אשר צויתך׃ ");
INSERT INTO heb_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","את אהל מועד ואת הארן לעדת ואת הכפרת אשר עליו ואת כל כלי האהל׃ ");
INSERT INTO heb_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","ואת השלחן ואת כליו ואת המנרה הטהרה ואת כל כליה ואת מזבח הקטרת׃ ");
INSERT INTO heb_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","ואת מזבח העלה ואת כל כליו ואת הכיור ואת כנו׃ ");
INSERT INTO heb_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","ואת בגדי השרד ואת בגדי הקדש לאהרן הכהן ואת בגדי בניו לכהן׃ ");
INSERT INTO heb_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","ואת שמן המשחה ואת קטרת הסמים לקדש ככל אשר צויתך יעשו׃ ");
INSERT INTO heb_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","ויאמר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","ואתה דבר אל בני ישראל לאמר אך את שבתתי תשמרו כי אות הוא ביני וביניכם לדרתיכם לדעת כי אני יהוה מקדשכם׃ ");
INSERT INTO heb_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","ושמרתם את השבת כי קדש הוא לכם מחלליה מות יומת כי כל העשה בה מלאכה ונכרתה הנפש ההוא מקרב עמיה׃ ");
INSERT INTO heb_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","ששת ימים יעשה מלאכה וביום השביעי שבת שבתון קדש ליהוה כל העשה מלאכה ביום השבת מות יומת׃ ");
INSERT INTO heb_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","ושמרו בני ישראל את השבת לעשות את השבת לדרתם ברית עולם׃ ");
INSERT INTO heb_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","ביני ובין בני ישראל אות הוא לעלם כי ששת ימים עשה יהוה את השמים ואת הארץ וביום השביעי שבת וינפש׃ ");
INSERT INTO heb_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","ויתן אל משה ככלתו לדבר אתו בהר סיני שני לחת העדת לחת אבן כתבים באצבע אלהים׃ ");
INSERT INTO heb_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","וירא העם כי בשש משה לרדת מן ההר ויקהל העם על אהרן ויאמרו אליו קום עשה לנו אלהים אשר ילכו לפנינו כי זה משה האיש אשר העלנו מארץ מצרים לא ידענו מה היה לו׃ ");
INSERT INTO heb_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","ויאמר אלהם אהרן פרקו נזמי הזהב אשר באזני נשיכם בניכם ובנתיכם והביאו אלי׃ ");
INSERT INTO heb_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","ויתפרקו כל העם את נזמי הזהב אשר באזניהם ויביאו אל אהרן׃ ");
INSERT INTO heb_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","ויקח מידם ויצר אתו בחרט ויעשהו עגל מסכה ויאמרו אלה אלהיך ישראל אשר העלוך מארץ מצרים׃ ");
INSERT INTO heb_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","וירא אהרן ויבן מזבח לפניו ויקרא אהרן ויאמר חג ליהוה מחר׃ ");
INSERT INTO heb_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","וישכימו ממחרת ויעלו עלת ויגשו שלמים וישב העם לאכל ושתו ויקמו לצחק׃ ");
INSERT INTO heb_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","וידבר יהוה אל משה לך רד כי שחת עמך אשר העלית מארץ מצרים׃ ");
INSERT INTO heb_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","סרו מהר מן הדרך אשר צויתם עשו להם עגל מסכה וישתחוו לו ויזבחו לו ויאמרו אלה אלהיך ישראל אשר העלוך מארץ מצרים׃ ");
INSERT INTO heb_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","ויאמר יהוה אל משה ראיתי את העם הזה והנה עם קשה ערף הוא׃ ");
INSERT INTO heb_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","ועתה הניחה לי ויחר אפי בהם ואכלם ואעשה אותך לגוי גדול׃ ");
INSERT INTO heb_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","ויחל משה את פני יהוה אלהיו ויאמר למה יהוה יחרה אפך בעמך אשר הוצאת מארץ מצרים בכח גדול וביד חזקה׃ ");
INSERT INTO heb_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","למה יאמרו מצרים לאמר ברעה הוציאם להרג אתם בהרים ולכלתם מעל פני האדמה שוב מחרון אפך והנחם על הרעה לעמך׃ ");
INSERT INTO heb_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","זכר לאברהם ליצחק ולישראל עבדיך אשר נשבעת להם בך ותדבר אלהם ארבה את זרעכם ככוכבי השמים וכל הארץ הזאת אשר אמרתי אתן לזרעכם ונחלו לעלם׃ ");
INSERT INTO heb_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","וינחם יהוה על הרעה אשר דבר לעשות לעמו׃ ");
INSERT INTO heb_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","ויפן וירד משה מן ההר ושני לחת העדת בידו לחת כתבים משני עבריהם מזה ומזה הם כתבים׃ ");
INSERT INTO heb_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","והלחת מעשה אלהים המה והמכתב מכתב אלהים הוא חרות על הלחת׃ ");
INSERT INTO heb_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","וישמע יהושע את קול העם ברעה ויאמר אל משה קול מלחמה במחנה׃ ");
INSERT INTO heb_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","ויאמר אין קול ענות גבורה ואין קול ענות חלושה קול ענות אנכי שמע׃ ");
INSERT INTO heb_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","ויהי כאשר קרב אל המחנה וירא את העגל ומחלת ויחר אף משה וישלך מידו את הלחת וישבר אתם תחת ההר׃ ");
INSERT INTO heb_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","ויקח את העגל אשר עשו וישרף באש ויטחן עד אשר דק ויזר על פני המים וישק את בני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","ויאמר משה אל אהרן מה עשה לך העם הזה כי הבאת עליו חטאה גדלה׃ ");
INSERT INTO heb_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","ויאמר אהרן אל יחר אף אדני אתה ידעת את העם כי ברע הוא׃ ");
INSERT INTO heb_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","ויאמרו לי עשה לנו אלהים אשר ילכו לפנינו כי זה משה האיש אשר העלנו מארץ מצרים לא ידענו מה היה לו׃ ");
INSERT INTO heb_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","ואמר להם למי זהב התפרקו ויתנו לי ואשלכהו באש ויצא העגל הזה׃ ");
INSERT INTO heb_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","וירא משה את העם כי פרע הוא כי פרעה אהרן לשמצה בקמיהם׃ ");
INSERT INTO heb_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","ויעמד משה בשער המחנה ויאמר מי ליהוה אלי ויאספו אליו כל בני לוי׃ ");
INSERT INTO heb_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","ויאמר להם כה אמר יהוה אלהי ישראל שימו איש חרבו על ירכו עברו ושובו משער לשער במחנה והרגו איש את אחיו ואיש את רעהו ואיש את קרבו׃ ");
INSERT INTO heb_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","ויעשו בני לוי כדבר משה ויפל מן העם ביום ההוא כשלשת אלפי איש׃ ");
INSERT INTO heb_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","ויאמר משה מלאו ידכם היום ליהוה כי איש בבנו ובאחיו ולתת עליכם היום ברכה׃ ");
INSERT INTO heb_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","ויהי ממחרת ויאמר משה אל העם אתם חטאתם חטאה גדלה ועתה אעלה אל יהוה אולי אכפרה בעד חטאתכם׃ ");
INSERT INTO heb_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","וישב משה אל יהוה ויאמר אנא חטא העם הזה חטאה גדלה ויעשו להם אלהי זהב׃ ");
INSERT INTO heb_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","ועתה אם תשא חטאתם ואם אין מחני נא מספרך אשר כתבת׃ ");
INSERT INTO heb_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","ויאמר יהוה אל משה מי אשר חטא לי אמחנו מספרי׃ ");
INSERT INTO heb_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","ועתה לך נחה את העם אל אשר דברתי לך הנה מלאכי ילך לפניך וביום פקדי ופקדתי עליהם חטאתם׃ ");
INSERT INTO heb_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","ויגף יהוה את העם על אשר עשו את העגל אשר עשה אהרן׃ ");
INSERT INTO heb_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","וידבר יהוה אל משה לך עלה מזה אתה והעם אשר העלית מארץ מצרים אל הארץ אשר נשבעתי לאברהם ליצחק וליעקב לאמר לזרעך אתננה׃ ");
INSERT INTO heb_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","ושלחתי לפניך מלאך וגרשתי את הכנעני האמרי והחתי והפרזי החוי והיבוסי׃ ");
INSERT INTO heb_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","אל ארץ זבת חלב ודבש כי לא אעלה בקרבך כי עם קשה ערף אתה פן אכלך בדרך׃ ");
INSERT INTO heb_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","וישמע העם את הדבר הרע הזה ויתאבלו ולא שתו איש עדיו עליו׃ ");
INSERT INTO heb_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","ויאמר יהוה אל משה אמר אל בני ישראל אתם עם קשה ערף רגע אחד אעלה בקרבך וכליתיך ועתה הורד עדיך מעליך ואדעה מה אעשה לך׃ ");
INSERT INTO heb_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","ויתנצלו בני ישראל את עדים מהר חורב׃ ");
INSERT INTO heb_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","ומשה יקח את האהל ונטה לו מחוץ למחנה הרחק מן המחנה וקרא לו אהל מועד והיה כל מבקש יהוה יצא אל אהל מועד אשר מחוץ למחנה׃ ");
INSERT INTO heb_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","והיה כצאת משה אל האהל יקומו כל העם ונצבו איש פתח אהלו והביטו אחרי משה עד באו האהלה׃ ");
INSERT INTO heb_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","והיה כבא משה האהלה ירד עמוד הענן ועמד פתח האהל ודבר עם משה׃ ");
INSERT INTO heb_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","וראה כל העם את עמוד הענן עמד פתח האהל וקם כל העם והשתחוו איש פתח אהלו׃ ");
INSERT INTO heb_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","ודבר יהוה אל משה פנים אל פנים כאשר ידבר איש אל רעהו ושב אל המחנה ומשרתו יהושע בן נון נער לא ימיש מתוך האהל׃ ");
INSERT INTO heb_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","ויאמר משה אל יהוה ראה אתה אמר אלי העל את העם הזה ואתה לא הודעתני את אשר תשלח עמי ואתה אמרת ידעתיך בשם וגם מצאת חן בעיני׃ ");
INSERT INTO heb_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","ועתה אם נא מצאתי חן בעיניך הודעני נא את דרכך ואדעך למען אמצא חן בעיניך וראה כי עמך הגוי הזה׃ ");
INSERT INTO heb_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","ויאמר פני ילכו והנחתי לך׃ ");
INSERT INTO heb_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","ויאמר אליו אם אין פניך הלכים אל תעלנו מזה׃ ");
INSERT INTO heb_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","ובמה יודע אפוא כי מצאתי חן בעיניך אני ועמך הלוא בלכתך עמנו ונפלינו אני ועמך מכל העם אשר על פני האדמה׃ ");
INSERT INTO heb_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","ויאמר יהוה אל משה גם את הדבר הזה אשר דברת אעשה כי מצאת חן בעיני ואדעך בשם׃ ");
INSERT INTO heb_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","ויאמר הראני נא את כבדך׃ ");
INSERT INTO heb_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","ויאמר אני אעביר כל טובי על פניך וקראתי בשם יהוה לפניך וחנתי את אשר אחן ורחמתי את אשר ארחם׃ ");
INSERT INTO heb_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","ויאמר לא תוכל לראת את פני כי לא יראני האדם וחי׃ ");
INSERT INTO heb_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","ויאמר יהוה הנה מקום אתי ונצבת על הצור׃ ");
INSERT INTO heb_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","והיה בעבר כבדי ושמתיך בנקרת הצור ושכתי כפי עליך עד עברי׃ ");
INSERT INTO heb_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","והסרתי את כפי וראית את אחרי ופני לא יראו׃ ");
INSERT INTO heb_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","ויאמר יהוה אל משה פסל לך שני לחת אבנים כראשנים וכתבתי על הלחת את הדברים אשר היו על הלחת הראשנים אשר שברת׃ ");
INSERT INTO heb_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","והיה נכון לבקר ועלית בבקר אל הר סיני ונצבת לי שם על ראש ההר׃ ");
INSERT INTO heb_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","ואיש לא יעלה עמך וגם איש אל ירא בכל ההר גם הצאן והבקר אל ירעו אל מול ההר ההוא׃ ");
INSERT INTO heb_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","ויפסל שני לחת אבנים כראשנים וישכם משה בבקר ויעל אל הר סיני כאשר צוה יהוה אתו ויקח בידו שני לחת אבנים׃ ");
INSERT INTO heb_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","וירד יהוה בענן ויתיצב עמו שם ויקרא בשם יהוה׃ ");
INSERT INTO heb_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","ויעבר יהוה על פניו ויקרא יהוה יהוה אל רחום וחנון ארך אפים ורב חסד ואמת׃ ");
INSERT INTO heb_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","נצר חסד לאלפים נשא עון ופשע וחטאה ונקה לא ינקה פקד עון אבות על בנים ועל בני בנים על שלשים ועל רבעים׃ ");
INSERT INTO heb_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","וימהר משה ויקד ארצה וישתחו׃ ");
INSERT INTO heb_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","ויאמר אם נא מצאתי חן בעיניך אדני ילך נא אדני בקרבנו כי עם קשה ערף הוא וסלחת לעוננו ולחטאתנו ונחלתנו׃ ");
INSERT INTO heb_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","ויאמר הנה אנכי כרת ברית נגד כל עמך אעשה נפלאת אשר לא נבראו בכל הארץ ובכל הגוים וראה כל העם אשר אתה בקרבו את מעשה יהוה כי נורא הוא אשר אני עשה עמך׃ ");
INSERT INTO heb_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","שמר לך את אשר אנכי מצוך היום הנני גרש מפניך את האמרי והכנעני והחתי והפרזי והחוי והיבוסי׃ ");
INSERT INTO heb_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","השמר לך פן תכרת ברית ליושב הארץ אשר אתה בא עליה פן יהיה למוקש בקרבך׃ ");
INSERT INTO heb_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","כי את מזבחתם תתצון ואת מצבתם תשברון ואת אשריו תכרתון׃ ");
INSERT INTO heb_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","כי לא תשתחוה לאל אחר כי יהוה קנא שמו אל קנא הוא׃ ");
INSERT INTO heb_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","פן תכרת ברית ליושב הארץ וזנו אחרי אלהיהם וזבחו לאלהיהם וקרא לך ואכלת מזבחו׃ ");
INSERT INTO heb_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","ולקחת מבנתיו לבניך וזנו בנתיו אחרי אלהיהן והזנו את בניך אחרי אלהיהן׃ ");
INSERT INTO heb_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","אלהי מסכה לא תעשה לך׃ ");
INSERT INTO heb_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","את חג המצות תשמר שבעת ימים תאכל מצות אשר צויתך למועד חדש האביב כי בחדש האביב יצאת ממצרים׃ ");
INSERT INTO heb_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","כל פטר רחם לי וכל מקנך תזכר פטר שור ושה׃ ");
INSERT INTO heb_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","ופטר חמור תפדה בשה ואם לא תפדה וערפתו כל בכור בניך תפדה ולא יראו פני ריקם׃ ");
INSERT INTO heb_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","ששת ימים תעבד וביום השביעי תשבת בחריש ובקציר תשבת׃ ");
INSERT INTO heb_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","וחג שבעת תעשה לך בכורי קציר חטים וחג האסיף תקופת השנה׃ ");
INSERT INTO heb_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","שלש פעמים בשנה יראה כל זכורך את פני האדן יהוה אלהי ישראל׃ ");
INSERT INTO heb_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","כי אוריש גוים מפניך והרחבתי את גבולך ולא יחמד איש את ארצך בעלתך לראות את פני יהוה אלהיך שלש פעמים בשנה׃ ");
INSERT INTO heb_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","לא תשחט על חמץ דם זבחי ולא ילין לבקר זבח חג הפסח׃ ");
INSERT INTO heb_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","ראשית בכורי אדמתך תביא בית יהוה אלהיך לא תבשל גדי בחלב אמו׃ ");
INSERT INTO heb_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","ויאמר יהוה אל משה כתב לך את הדברים האלה כי על פי הדברים האלה כרתי אתך ברית ואת ישראל׃ ");
INSERT INTO heb_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","ויהי שם עם יהוה ארבעים יום וארבעים לילה לחם לא אכל ומים לא שתה ויכתב על הלחת את דברי הברית עשרת הדברים׃ ");
INSERT INTO heb_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","ויהי ברדת משה מהר סיני ושני לחת העדת ביד משה ברדתו מן ההר ומשה לא ידע כי קרן עור פניו בדברו אתו׃ ");
INSERT INTO heb_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","וירא אהרן וכל בני ישראל את משה והנה קרן עור פניו וייראו מגשת אליו׃ ");
INSERT INTO heb_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","ויקרא אלהם משה וישבו אליו אהרן וכל הנשאים בעדה וידבר משה אלהם׃ ");
INSERT INTO heb_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","ואחרי כן נגשו כל בני ישראל ויצום את כל אשר דבר יהוה אתו בהר סיני׃ ");
INSERT INTO heb_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","ויכל משה מדבר אתם ויתן על פניו מסוה׃ ");
INSERT INTO heb_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","ובבא משה לפני יהוה לדבר אתו יסיר את המסוה עד צאתו ויצא ודבר אל בני ישראל את אשר יצוה׃ ");
INSERT INTO heb_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","וראו בני ישראל את פני משה כי קרן עור פני משה והשיב משה את המסוה על פניו עד באו לדבר אתו׃ ");
INSERT INTO heb_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","ויקהל משה את כל עדת בני ישראל ויאמר אלהם אלה הדברים אשר צוה יהוה לעשת אתם׃ ");
INSERT INTO heb_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","ששת ימים תעשה מלאכה וביום השביעי יהיה לכם קדש שבת שבתון ליהוה כל העשה בו מלאכה יומת׃ ");
INSERT INTO heb_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","לא תבערו אש בכל משבתיכם ביום השבת׃ ");
INSERT INTO heb_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","ויאמר משה אל כל עדת בני ישראל לאמר זה הדבר אשר צוה יהוה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","קחו מאתכם תרומה ליהוה כל נדיב לבו יביאה את תרומת יהוה זהב וכסף ונחשת׃ ");
INSERT INTO heb_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","ותכלת וארגמן ותולעת שני ושש ועזים׃ ");
INSERT INTO heb_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","וערת אילם מאדמים וערת תחשים ועצי שטים׃ ");
INSERT INTO heb_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","ושמן למאור ובשמים לשמן המשחה ולקטרת הסמים׃ ");
INSERT INTO heb_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","ואבני שהם ואבני מלאים לאפוד ולחשן׃ ");
INSERT INTO heb_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","וכל חכם לב בכם יבאו ויעשו את כל אשר צוה יהוה׃ ");
INSERT INTO heb_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","את המשכן את אהלו ואת מכסהו את קרסיו ואת קרשיו את בריחו את עמדיו ואת אדניו׃ ");
INSERT INTO heb_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","את הארן ואת בדיו את הכפרת ואת פרכת המסך׃ ");
INSERT INTO heb_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","את השלחן ואת בדיו ואת כל כליו ואת לחם הפנים׃ ");
INSERT INTO heb_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","ואת מנרת המאור ואת כליה ואת נרתיה ואת שמן המאור׃ ");
INSERT INTO heb_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","ואת מזבח הקטרת ואת בדיו ואת שמן המשחה ואת קטרת הסמים ואת מסך הפתח לפתח המשכן׃ ");
INSERT INTO heb_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","את מזבח העלה ואת מכבר הנחשת אשר לו את בדיו ואת כל כליו את הכיר ואת כנו׃ ");
INSERT INTO heb_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","את קלעי החצר את עמדיו ואת אדניה ואת מסך שער החצר׃ ");
INSERT INTO heb_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","את יתדת המשכן ואת יתדת החצר ואת מיתריהם׃ ");
INSERT INTO heb_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","את בגדי השרד לשרת בקדש את בגדי הקדש לאהרן הכהן ואת בגדי בניו לכהן׃ ");
INSERT INTO heb_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","ויצאו כל עדת בני ישראל מלפני משה׃ ");
INSERT INTO heb_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","ויבאו כל איש אשר נשאו לבו וכל אשר נדבה רוחו אתו הביאו את תרומת יהוה למלאכת אהל מועד ולכל עבדתו ולבגדי הקדש׃ ");
INSERT INTO heb_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","ויבאו האנשים על הנשים כל נדיב לב הביאו חח ונזם וטבעת וכומז כל כלי זהב וכל איש אשר הניף תנופת זהב ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","וכל איש אשר נמצא אתו תכלת וארגמן ותולעת שני ושש ועזים וערת אילם מאדמים וערת תחשים הביאו׃ ");
INSERT INTO heb_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","כל מרים תרומת כסף ונחשת הביאו את תרומת יהוה וכל אשר נמצא אתו עצי שטים לכל מלאכת העבדה הביאו׃ ");
INSERT INTO heb_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","וכל אשה חכמת לב בידיה טוו ויביאו מטוה את התכלת ואת הארגמן את תולעת השני ואת השש׃ ");
INSERT INTO heb_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","וכל הנשים אשר נשא לבן אתנה בחכמה טוו את העזים׃ ");
INSERT INTO heb_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","והנשאם הביאו את אבני השהם ואת אבני המלאים לאפוד ולחשן׃ ");
INSERT INTO heb_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","ואת הבשם ואת השמן למאור ולשמן המשחה ולקטרת הסמים׃ ");
INSERT INTO heb_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","כל איש ואשה אשר נדב לבם אתם להביא לכל המלאכה אשר צוה יהוה לעשות ביד משה הביאו בני ישראל נדבה ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","ויאמר משה אל בני ישראל ראו קרא יהוה בשם בצלאל בן אורי בן חור למטה יהודה׃ ");
INSERT INTO heb_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","וימלא אתו רוח אלהים בחכמה בתבונה ובדעת ובכל מלאכה׃ ");
INSERT INTO heb_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","ולחשב מחשבת לעשת בזהב ובכסף ובנחשת׃ ");
INSERT INTO heb_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","ובחרשת אבן למלאת ובחרשת עץ לעשות בכל מלאכת מחשבת׃ ");
INSERT INTO heb_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","ולהורת נתן בלבו הוא ואהליאב בן אחיסמך למטה דן׃ ");
INSERT INTO heb_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","מלא אתם חכמת לב לעשות כל מלאכת חרש וחשב ורקם בתכלת ובארגמן בתולעת השני ובשש וארג עשי כל מלאכה וחשבי מחשבת׃ ");
INSERT INTO heb_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","ועשה בצלאל ואהליאב וכל איש חכם לב אשר נתן יהוה חכמה ותבונה בהמה לדעת לעשת את כל מלאכת עבדת הקדש לכל אשר צוה יהוה׃ ");
INSERT INTO heb_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","ויקרא משה אל בצלאל ואל אהליאב ואל כל איש חכם לב אשר נתן יהוה חכמה בלבו כל אשר נשאו לבו לקרבה אל המלאכה לעשת אתה׃ ");
INSERT INTO heb_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","ויקחו מלפני משה את כל התרומה אשר הביאו בני ישראל למלאכת עבדת הקדש לעשת אתה והם הביאו אליו עוד נדבה בבקר בבקר׃ ");
INSERT INTO heb_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","ויבאו כל החכמים העשים את כל מלאכת הקדש איש איש ממלאכתו אשר המה עשים׃ ");
INSERT INTO heb_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","ויאמרו אל משה לאמר מרבים העם להביא מדי העבדה למלאכה אשר צוה יהוה לעשת אתה׃ ");
INSERT INTO heb_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","ויצו משה ויעבירו קול במחנה לאמר איש ואשה אל יעשו עוד מלאכה לתרומת הקדש ויכלא העם מהביא׃ ");
INSERT INTO heb_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","והמלאכה היתה דים לכל המלאכה לעשות אתה והותר׃ ");
INSERT INTO heb_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","ויעשו כל חכם לב בעשי המלאכה את המשכן עשר יריעת שש משזר ותכלת וארגמן ותולעת שני כרבים מעשה חשב עשה אתם׃ ");
INSERT INTO heb_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","ארך היריעה האחת שמנה ועשרים באמה ורחב ארבע באמה היריעה האחת מדה אחת לכל היריעת׃ ");
INSERT INTO heb_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","ויחבר את חמש היריעת אחת אל אחת וחמש יריעת חבר אחת אל אחת׃ ");
INSERT INTO heb_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","ויעש ללאת תכלת על שפת היריעה האחת מקצה במחברת כן עשה בשפת היריעה הקיצונה במחברת השנית׃ ");
INSERT INTO heb_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","חמשים ללאת עשה ביריעה האחת וחמשים ללאת עשה בקצה היריעה אשר במחברת השנית מקבילת הללאת אחת אל אחת׃ ");
INSERT INTO heb_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","ויעש חמשים קרסי זהב ויחבר את הירעת אחת אל אחת בקרסים ויהי המשכן אחד׃ ");
INSERT INTO heb_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","ויעש יריעת עזים לאהל על המשכן עשתי עשרה יריעת עשה אתם׃ ");
INSERT INTO heb_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","ארך היריעה האחת שלשים באמה וארבע אמות רחב היריעה האחת מדה אחת לעשתי עשרה יריעת׃ ");
INSERT INTO heb_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","ויחבר את חמש היריעת לבד ואת שש היריעת לבד׃ ");
INSERT INTO heb_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","ויעש ללאת חמשים על שפת היריעה הקיצנה במחברת וחמשים ללאת עשה על שפת היריעה החברת השנית׃ ");
INSERT INTO heb_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","ויעש קרסי נחשת חמשים לחבר את האהל להית אחד׃ ");
INSERT INTO heb_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","ויעש מכסה לאהל ערת אלים מאדמים ומכסה ערת תחשים מלמעלה׃ ");
INSERT INTO heb_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","ויעש את הקרשים למשכן עצי שטים עמדים׃ ");
INSERT INTO heb_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","עשר אמת ארך הקרש ואמה וחצי האמה רחב הקרש האחד׃ ");
INSERT INTO heb_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","שתי ידת לקרש האחד משלבת אחת אל אחת כן עשה לכל קרשי המשכן׃ ");
INSERT INTO heb_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","ויעש את הקרשים למשכן עשרים קרשים לפאת נגב תימנה׃ ");
INSERT INTO heb_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","וארבעים אדני כסף עשה תחת עשרים הקרשים שני אדנים תחת הקרש האחד לשתי ידתיו ושני אדנים תחת הקרש האחד לשתי ידתיו׃ ");
INSERT INTO heb_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","ולצלע המשכן השנית לפאת צפון עשה עשרים קרשים׃ ");
INSERT INTO heb_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","וארבעים אדניהם כסף שני אדנים תחת הקרש האחד ושני אדנים תחת הקרש האחד׃ ");
INSERT INTO heb_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","ולירכתי המשכן ימה עשה ששה קרשים׃ ");
INSERT INTO heb_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","ושני קרשים עשה למקצעת המשכן בירכתים׃ ");
INSERT INTO heb_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","והיו תואמם מלמטה ויחדו יהיו תמים אל ראשו אל הטבעת האחת כן עשה לשניהם לשני המקצעת׃ ");
INSERT INTO heb_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","והיו שמנה קרשים ואדניהם כסף ששה עשר אדנים שני אדנים שני אדנים תחת הקרש האחד׃ ");
INSERT INTO heb_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","ויעש בריחי עצי שטים חמשה לקרשי צלע המשכן האחת׃ ");
INSERT INTO heb_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","וחמשה בריחם לקרשי צלע המשכן השנית וחמשה בריחם לקרשי המשכן לירכתים ימה׃ ");
INSERT INTO heb_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","ויעש את הבריח התיכן לברח בתוך הקרשים מן הקצה אל הקצה׃ ");
INSERT INTO heb_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","ואת הקרשים צפה זהב ואת טבעתם עשה זהב בתים לבריחם ויצף את הבריחם זהב׃ ");
INSERT INTO heb_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","ויעש את הפרכת תכלת וארגמן ותולעת שני ושש משזר מעשה חשב עשה אתה כרבים׃ ");
INSERT INTO heb_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","ויעש לה ארבעה עמודי שטים ויצפם זהב וויהם זהב ויצק להם ארבעה אדני כסף׃ ");
INSERT INTO heb_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","ויעש מסך לפתח האהל תכלת וארגמן ותולעת שני ושש משזר מעשה רקם׃ ");
INSERT INTO heb_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","ואת עמודיו חמשה ואת וויהם וצפה ראשיהם וחשקיהם זהב ואדניהם חמשה נחשת׃ ");
INSERT INTO heb_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","ויעש בצלאל את הארן עצי שטים אמתים וחצי ארכו ואמה וחצי רחבו ואמה וחצי קמתו׃ ");
INSERT INTO heb_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","ויצפהו זהב טהור מבית ומחוץ ויעש לו זר זהב סביב׃ ");
INSERT INTO heb_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","ויצק לו ארבע טבעת זהב על ארבע פעמתיו ושתי טבעת על צלעו האחת ושתי טבעות על צלעו השנית׃ ");
INSERT INTO heb_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","ויעש בדי עצי שטים ויצף אתם זהב׃ ");
INSERT INTO heb_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","ויבא את הבדים בטבעת על צלעת הארן לשאת את הארן׃ ");
INSERT INTO heb_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","ויעש כפרת זהב טהור אמתים וחצי ארכה ואמה וחצי רחבה׃ ");
INSERT INTO heb_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","ויעש שני כרבים זהב מקשה עשה אתם משני קצות הכפרת׃ ");
INSERT INTO heb_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","כרוב אחד מקצה מזה וכרוב אחד מקצה מזה מן הכפרת עשה את הכרבים משני קצוותו׃ ");
INSERT INTO heb_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","ויהיו הכרבים פרשי כנפים למעלה סככים בכנפיהם על הכפרת ופניהם איש אל אחיו אל הכפרת היו פני הכרבים׃ ");
INSERT INTO heb_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","ויעש את השלחן עצי שטים אמתים ארכו ואמה רחבו ואמה וחצי קמתו׃ ");
INSERT INTO heb_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","ויצף אתו זהב טהור ויעש לו זר זהב סביב׃ ");
INSERT INTO heb_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","ויעש לו מסגרת טפח סביב ויעש זר זהב למסגרתו סביב׃ ");
INSERT INTO heb_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","ויצק לו ארבע טבעת זהב ויתן את הטבעת על ארבע הפאת אשר לארבע רגליו׃ ");
INSERT INTO heb_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","לעמת המסגרת היו הטבעת בתים לבדים לשאת את השלחן׃ ");
INSERT INTO heb_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","ויעש את הבדים עצי שטים ויצף אתם זהב לשאת את השלחן׃ ");
INSERT INTO heb_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","ויעש את הכלים אשר על השלחן את קערתיו ואת כפתיו ואת מנקיתיו ואת הקשות אשר יסך בהן זהב טהור׃ ");
INSERT INTO heb_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","ויעש את המנרה זהב טהור מקשה עשה את המנרה ירכה וקנה גביעיה כפתריה ופרחיה ממנה היו׃ ");
INSERT INTO heb_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","וששה קנים יצאים מצדיה שלשה קני מנרה מצדה האחד ושלשה קני מנרה מצדה השני׃ ");
INSERT INTO heb_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","שלשה גבעים משקדים בקנה האחד כפתר ופרח ושלשה גבעים משקדים בקנה אחד כפתר ופרח כן לששת הקנים היצאים מן המנרה׃ ");
INSERT INTO heb_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","ובמנרה ארבעה גבעים משקדים כפתריה ופרחיה׃ ");
INSERT INTO heb_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","וכפתר תחת שני הקנים ממנה וכפתר תחת שני הקנים ממנה וכפתר תחת שני הקנים ממנה לששת הקנים היצאים ממנה׃ ");
INSERT INTO heb_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","כפתריהם וקנתם ממנה היו כלה מקשה אחת זהב טהור׃ ");
INSERT INTO heb_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","ויעש את נרתיה שבעה ומלקחיה ומחתתיה זהב טהור׃ ");
INSERT INTO heb_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","ככר זהב טהור עשה אתה ואת כל כליה׃ ");
INSERT INTO heb_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","ויעש את מזבח הקטרת עצי שטים אמה ארכו ואמה רחבו רבוע ואמתים קמתו ממנו היו קרנתיו׃ ");
INSERT INTO heb_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","ויצף אתו זהב טהור את גגו ואת קירתיו סביב ואת קרנתיו ויעש לו זר זהב סביב׃ ");
INSERT INTO heb_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","ושתי טבעת זהב עשה לו מתחת לזרו על שתי צלעתיו על שני צדיו לבתים לבדים לשאת אתו בהם׃ ");
INSERT INTO heb_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","ויעש את הבדים עצי שטים ויצף אתם זהב׃ ");
INSERT INTO heb_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","ויעש את שמן המשחה קדש ואת קטרת הסמים טהור מעשה רקח׃ ");
INSERT INTO heb_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","ויעש את מזבח העלה עצי שטים חמש אמות ארכו וחמש אמות רחבו רבוע ושלש אמות קמתו׃ ");
INSERT INTO heb_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","ויעש קרנתיו על ארבע פנתיו ממנו היו קרנתיו ויצף אתו נחשת׃ ");
INSERT INTO heb_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","ויעש את כל כלי המזבח את הסירת ואת היעים ואת המזרקת את המזלגת ואת המחתת כל כליו עשה נחשת׃ ");
INSERT INTO heb_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","ויעש למזבח מכבר מעשה רשת נחשת תחת כרכבו מלמטה עד חציו׃ ");
INSERT INTO heb_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","ויצק ארבע טבעת בארבע הקצות למכבר הנחשת בתים לבדים׃ ");
INSERT INTO heb_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","ויעש את הבדים עצי שטים ויצף אתם נחשת׃ ");
INSERT INTO heb_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","ויבא את הבדים בטבעת על צלעת המזבח לשאת אתו בהם נבוב לחת עשה אתו׃ ");
INSERT INTO heb_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","ויעש את הכיור נחשת ואת כנו נחשת במראת הצבאת אשר צבאו פתח אהל מועד׃ ");
INSERT INTO heb_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","ויעש את החצר לפאת נגב תימנה קלעי החצר שש משזר מאה באמה׃ ");
INSERT INTO heb_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","עמודיהם עשרים ואדניהם עשרים נחשת ווי העמדים וחשקיהם כסף׃ ");
INSERT INTO heb_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","ולפאת צפון מאה באמה עמודיהם עשרים ואדניהם עשרים נחשת ווי העמודים וחשקיהם כסף׃ ");
INSERT INTO heb_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","ולפאת ים קלעים חמשים באמה עמודיהם עשרה ואדניהם עשרה ווי העמדים וחשוקיהם כסף׃ ");
INSERT INTO heb_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","ולפאת קדמה מזרחה חמשים אמה׃ ");
INSERT INTO heb_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","קלעים חמש עשרה אמה אל הכתף עמודיהם שלשה ואדניהם שלשה׃ ");
INSERT INTO heb_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","ולכתף השנית מזה ומזה לשער החצר קלעים חמש עשרה אמה עמדיהם שלשה ואדניהם שלשה׃ ");
INSERT INTO heb_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","כל קלעי החצר סביב שש משזר׃ ");
INSERT INTO heb_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","והאדנים לעמדים נחשת ווי העמודים וחשוקיהם כסף וצפוי ראשיהם כסף והם מחשקים כסף כל עמדי החצר׃ ");
INSERT INTO heb_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","ומסך שער החצר מעשה רקם תכלת וארגמן ותולעת שני ושש משזר ועשרים אמה ארך וקומה ברחב חמש אמות לעמת קלעי החצר׃ ");
INSERT INTO heb_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","ועמדיהם ארבעה ואדניהם ארבעה נחשת וויהם כסף וצפוי ראשיהם וחשקיהם כסף׃ ");
INSERT INTO heb_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","וכל היתדת למשכן ולחצר סביב נחשת׃ ");
INSERT INTO heb_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","אלה פקודי המשכן משכן העדת אשר פקד על פי משה עבדת הלוים ביד איתמר בן אהרן הכהן׃ ");
INSERT INTO heb_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","ובצלאל בן אורי בן חור למטה יהודה עשה את כל אשר צוה יהוה את משה׃ ");
INSERT INTO heb_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","ואתו אהליאב בן אחיסמך למטה דן חרש וחשב ורקם בתכלת ובארגמן ובתולעת השני ובשש׃ ");
INSERT INTO heb_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","כל הזהב העשוי למלאכה בכל מלאכת הקדש ויהי זהב התנופה תשע ועשרים ככר ושבע מאות ושלשים שקל בשקל הקדש׃ ");
INSERT INTO heb_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","וכסף פקודי העדה מאת ככר ואלף ושבע מאות וחמשה ושבעים שקל בשקל הקדש׃ ");
INSERT INTO heb_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","בקע לגלגלת מחצית השקל בשקל הקדש לכל העבר על הפקדים מבן עשרים שנה ומעלה לשש מאות אלף ושלשת אלפים וחמש מאות וחמשים׃ ");
INSERT INTO heb_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","ויהי מאת ככר הכסף לצקת את אדני הקדש ואת אדני הפרכת מאת אדנים למאת הככר ככר לאדן׃ ");
INSERT INTO heb_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","ואת האלף ושבע המאות וחמשה ושבעים עשה ווים לעמודים וצפה ראשיהם וחשק אתם׃ ");
INSERT INTO heb_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","ונחשת התנופה שבעים ככר ואלפים וארבע מאות שקל׃ ");
INSERT INTO heb_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","ויעש בה את אדני פתח אהל מועד ואת מזבח הנחשת ואת מכבר הנחשת אשר לו ואת כל כלי המזבח׃ ");
INSERT INTO heb_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","ואת אדני החצר סביב ואת אדני שער החצר ואת כל יתדת המשכן ואת כל יתדת החצר סביב׃ ");
INSERT INTO heb_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","ומן התכלת והארגמן ותולעת השני עשו בגדי שרד לשרת בקדש ויעשו את בגדי הקדש אשר לאהרן כאשר צוה יהוה את משה׃ ");
INSERT INTO heb_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","ויעש את האפד זהב תכלת וארגמן ותולעת שני ושש משזר׃ ");
INSERT INTO heb_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","וירקעו את פחי הזהב וקצץ פתילם לעשות בתוך התכלת ובתוך הארגמן ובתוך תולעת השני ובתוך השש מעשה חשב׃ ");
INSERT INTO heb_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","כתפת עשו לו חברת על שני קצוותו חבר׃ ");
INSERT INTO heb_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","וחשב אפדתו אשר עליו ממנו הוא כמעשהו זהב תכלת וארגמן ותולעת שני ושש משזר כאשר צוה יהוה את משה׃ ");
INSERT INTO heb_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","ויעשו את אבני השהם מסבת משבצת זהב מפתחת פתוחי חותם על שמות בני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","וישם אתם על כתפת האפד אבני זכרון לבני ישראל כאשר צוה יהוה את משה׃ ");
INSERT INTO heb_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","ויעש את החשן מעשה חשב כמעשה אפד זהב תכלת וארגמן ותולעת שני ושש משזר׃ ");
INSERT INTO heb_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","רבוע היה כפול עשו את החשן זרת ארכו וזרת רחבו כפול׃ ");
INSERT INTO heb_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","וימלאו בו ארבעה טורי אבן טור אדם פטדה וברקת הטור האחד׃ ");
INSERT INTO heb_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","והטור השני נפך ספיר ויהלם׃ ");
INSERT INTO heb_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","והטור השלישי לשם שבו ואחלמה׃ ");
INSERT INTO heb_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","והטור הרביעי תרשיש שהם וישפה מוסבת משבצות זהב במלאתם׃ ");
INSERT INTO heb_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","והאבנים על שמת בני ישראל הנה שתים עשרה על שמתם פתוחי חתם איש על שמו לשנים עשר שבט׃ ");
INSERT INTO heb_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","ויעשו על החשן שרשרת גבלת מעשה עבת זהב טהור׃ ");
INSERT INTO heb_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","ויעשו שתי משבצת זהב ושתי טבעת זהב ויתנו את שתי הטבעת על שני קצות החשן׃ ");
INSERT INTO heb_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","ויתנו שתי העבתת הזהב על שתי הטבעת על קצות החשן׃ ");
INSERT INTO heb_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","ואת שתי קצות שתי העבתת נתנו על שתי המשבצת ויתנם על כתפת האפד אל מול פניו׃ ");
INSERT INTO heb_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","ויעשו שתי טבעת זהב וישימו על שני קצות החשן על שפתו אשר אל עבר האפד ביתה׃ ");
INSERT INTO heb_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","ויעשו שתי טבעת זהב ויתנם על שתי כתפת האפד מלמטה ממול פניו לעמת מחברתו ממעל לחשב האפד׃ ");
INSERT INTO heb_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","וירכסו את החשן מטבעתיו אל טבעת האפד בפתיל תכלת להית על חשב האפד ולא יזח החשן מעל האפד כאשר צוה יהוה את משה׃ ");
INSERT INTO heb_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","ויעש את מעיל האפד מעשה ארג כליל תכלת׃ ");
INSERT INTO heb_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","ופי המעיל בתוכו כפי תחרא שפה לפיו סביב לא יקרע׃ ");
INSERT INTO heb_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","ויעשו על שולי המעיל רמוני תכלת וארגמן ותולעת שני משזר׃ ");
INSERT INTO heb_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","ויעשו פעמני זהב טהור ויתנו את הפעמנים בתוך הרמנים על שולי המעיל סביב בתוך הרמנים׃ ");
INSERT INTO heb_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","פעמן ורמן פעמן ורמן על שולי המעיל סביב לשרת כאשר צוה יהוה את משה׃ ");
INSERT INTO heb_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","ויעשו את הכתנת שש מעשה ארג לאהרן ולבניו׃ ");
INSERT INTO heb_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","ואת המצנפת שש ואת פארי המגבעת שש ואת מכנסי הבד שש משזר׃ ");
INSERT INTO heb_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","ואת האבנט שש משזר ותכלת וארגמן ותולעת שני מעשה רקם כאשר צוה יהוה את משה׃ ");
INSERT INTO heb_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","ויעשו את ציץ נזר הקדש זהב טהור ויכתבו עליו מכתב פתוחי חותם קדש ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","ויתנו עליו פתיל תכלת לתת על המצנפת מלמעלה כאשר צוה יהוה את משה׃ ");
INSERT INTO heb_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","ותכל כל עבדת משכן אהל מועד ויעשו בני ישראל ככל אשר צוה יהוה את משה כן עשו׃ ");
INSERT INTO heb_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","ויביאו את המשכן אל משה את האהל ואת כל כליו קרסיו קרשיו בריחו ועמדיו ואדניו׃ ");
INSERT INTO heb_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","ואת מכסה עורת האילם המאדמים ואת מכסה ערת התחשים ואת פרכת המסך׃ ");
INSERT INTO heb_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","את ארן העדת ואת בדיו ואת הכפרת׃ ");
INSERT INTO heb_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","את השלחן את כל כליו ואת לחם הפנים׃ ");
INSERT INTO heb_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","את המנרה הטהרה את נרתיה נרת המערכה ואת כל כליה ואת שמן המאור׃ ");
INSERT INTO heb_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","ואת מזבח הזהב ואת שמן המשחה ואת קטרת הסמים ואת מסך פתח האהל׃ ");
INSERT INTO heb_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","את מזבח הנחשת ואת מכבר הנחשת אשר לו את בדיו ואת כל כליו את הכיר ואת כנו׃ ");
INSERT INTO heb_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","את קלעי החצר את עמדיה ואת אדניה ואת המסך לשער החצר את מיתריו ויתדתיה ואת כל כלי עבדת המשכן לאהל מועד׃ ");
INSERT INTO heb_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","את בגדי השרד לשרת בקדש את בגדי הקדש לאהרן הכהן ואת בגדי בניו לכהן׃ ");
INSERT INTO heb_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","ככל אשר צוה יהוה את משה כן עשו בני ישראל את כל העבדה׃ ");
INSERT INTO heb_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","וירא משה את כל המלאכה והנה עשו אתה כאשר צוה יהוה כן עשו ויברך אתם משה׃ ");
INSERT INTO heb_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","ביום החדש הראשון באחד לחדש תקים את משכן אהל מועד׃ ");
INSERT INTO heb_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","ושמת שם את ארון העדות וסכת על הארן את הפרכת׃ ");
INSERT INTO heb_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","והבאת את השלחן וערכת את ערכו והבאת את המנרה והעלית את נרתיה׃ ");
INSERT INTO heb_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","ונתתה את מזבח הזהב לקטרת לפני ארון העדת ושמת את מסך הפתח למשכן׃ ");
INSERT INTO heb_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","ונתתה את מזבח העלה לפני פתח משכן אהל מועד׃ ");
INSERT INTO heb_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","ונתת את הכיר בין אהל מועד ובין המזבח ונתת שם מים׃ ");
INSERT INTO heb_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","ושמת את החצר סביב ונתת את מסך שער החצר׃ ");
INSERT INTO heb_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","ולקחת את שמן המשחה ומשחת את המשכן ואת כל אשר בו וקדשת אתו ואת כל כליו והיה קדש׃ ");
INSERT INTO heb_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","ומשחת את מזבח העלה ואת כל כליו וקדשת את המזבח והיה המזבח קדש קדשים׃ ");
INSERT INTO heb_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","ומשחת את הכיר ואת כנו וקדשת אתו׃ ");
INSERT INTO heb_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","והקרבת את אהרן ואת בניו אל פתח אהל מועד ורחצת אתם במים׃ ");
INSERT INTO heb_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","והלבשת את אהרן את בגדי הקדש ומשחת אתו וקדשת אתו וכהן לי׃ ");
INSERT INTO heb_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","ואת בניו תקריב והלבשת אתם כתנת׃ ");
INSERT INTO heb_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","ומשחת אתם כאשר משחת את אביהם וכהנו לי והיתה להית להם משחתם לכהנת עולם לדרתם׃ ");
INSERT INTO heb_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","ויעש משה ככל אשר צוה יהוה אתו כן עשה׃ ");
INSERT INTO heb_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","ויהי בחדש הראשון בשנה השנית באחד לחדש הוקם המשכן׃ ");
INSERT INTO heb_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","ויקם משה את המשכן ויתן את אדניו וישם את קרשיו ויתן את בריחיו ויקם את עמודיו׃ ");
INSERT INTO heb_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","ויפרש את האהל על המשכן וישם את מכסה האהל עליו מלמעלה כאשר צוה יהוה את משה׃ ");
INSERT INTO heb_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","ויקח ויתן את העדת אל הארן וישם את הבדים על הארן ויתן את הכפרת על הארן מלמעלה׃ ");
INSERT INTO heb_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","ויבא את הארן אל המשכן וישם את פרכת המסך ויסך על ארון העדות כאשר צוה יהוה את משה׃ ");
INSERT INTO heb_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","ויתן את השלחן באהל מועד על ירך המשכן צפנה מחוץ לפרכת׃ ");
INSERT INTO heb_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","ויערך עליו ערך לחם לפני יהוה כאשר צוה יהוה את משה׃ ");
INSERT INTO heb_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","וישם את המנרה באהל מועד נכח השלחן על ירך המשכן נגבה׃ ");
INSERT INTO heb_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","ויעל הנרת לפני יהוה כאשר צוה יהוה את משה׃ ");
INSERT INTO heb_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","וישם את מזבח הזהב באהל מועד לפני הפרכת׃ ");
INSERT INTO heb_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","ויקטר עליו קטרת סמים כאשר צוה יהוה את משה׃ ");
INSERT INTO heb_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","וישם את מסך הפתח למשכן׃ ");
INSERT INTO heb_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","ואת מזבח העלה שם פתח משכן אהל מועד ויעל עליו את העלה ואת המנחה כאשר צוה יהוה את משה׃ ");
INSERT INTO heb_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","וישם את הכיר בין אהל מועד ובין המזבח ויתן שמה מים לרחצה׃ ");
INSERT INTO heb_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","ורחצו ממנו משה ואהרן ובניו את ידיהם ואת רגליהם׃ ");
INSERT INTO heb_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","בבאם אל אהל מועד ובקרבתם אל המזבח ירחצו כאשר צוה יהוה את משה׃ ");
INSERT INTO heb_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","ויקם את החצר סביב למשכן ולמזבח ויתן את מסך שער החצר ויכל משה את המלאכה׃ ");
INSERT INTO heb_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","ויכס הענן את אהל מועד וכבוד יהוה מלא את המשכן׃ ");
INSERT INTO heb_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","ולא יכל משה לבוא אל אהל מועד כי שכן עליו הענן וכבוד יהוה מלא את המשכן׃ ");
INSERT INTO heb_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","ובהעלות הענן מעל המשכן יסעו בני ישראל בכל מסעיהם׃ ");
INSERT INTO heb_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","ואם לא יעלה הענן ולא יסעו עד יום העלתו׃ ");
INSERT INTO heb_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","כי ענן יהוה על המשכן יומם ואש תהיה לילה בו לעיני כל בית ישראל בכל מסעיהם׃ ");
INSERT INTO heb_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","ויקרא אל משה וידבר יהוה אליו מאהל מועד לאמר׃ ");
INSERT INTO heb_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","דבר אל בני ישראל ואמרת אלהם אדם כי יקריב מכם קרבן ליהוה מן הבהמה מן הבקר ומן הצאן תקריבו את קרבנכם׃ ");
INSERT INTO heb_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","אם עלה קרבנו מן הבקר זכר תמים יקריבנו אל פתח אהל מועד יקריב אתו לרצנו לפני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","וסמך ידו על ראש העלה ונרצה לו לכפר עליו׃ ");
INSERT INTO heb_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","ושחט את בן הבקר לפני יהוה והקריבו בני אהרן הכהנים את הדם וזרקו את הדם על המזבח סביב אשר פתח אהל מועד׃ ");
INSERT INTO heb_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","והפשיט את העלה ונתח אתה לנתחיה׃ ");
INSERT INTO heb_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","ונתנו בני אהרן הכהן אש על המזבח וערכו עצים על האש׃ ");
INSERT INTO heb_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","וערכו בני אהרן הכהנים את הנתחים את הראש ואת הפדר על העצים אשר על האש אשר על המזבח׃ ");
INSERT INTO heb_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","וקרבו וכרעיו ירחץ במים והקטיר הכהן את הכל המזבחה עלה אשה ריח ניחוח ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","ואם מן הצאן קרבנו מן הכשבים או מן העזים לעלה זכר תמים יקריבנו׃ ");
INSERT INTO heb_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","ושחט אתו על ירך המזבח צפנה לפני יהוה וזרקו בני אהרן הכהנים את דמו על המזבח סביב׃ ");
INSERT INTO heb_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","ונתח אתו לנתחיו ואת ראשו ואת פדרו וערך הכהן אתם על העצים אשר על האש אשר על המזבח׃ ");
INSERT INTO heb_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","והקרב והכרעים ירחץ במים והקריב הכהן את הכל והקטיר המזבחה עלה הוא אשה ריח ניחח ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","ואם מן העוף עלה קרבנו ליהוה והקריב מן התרים או מן בני היונה את קרבנו׃ ");
INSERT INTO heb_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","והקריבו הכהן אל המזבח ומלק את ראשו והקטיר המזבחה ונמצה דמו על קיר המזבח׃ ");
INSERT INTO heb_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","והסיר את מראתו בנצתה והשליך אתה אצל המזבח קדמה אל מקום הדשן׃ ");
INSERT INTO heb_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","ושסע אתו בכנפיו לא יבדיל והקטיר אתו הכהן המזבחה על העצים אשר על האש עלה הוא אשה ריח ניחח ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","ונפש כי תקריב קרבן מנחה ליהוה סלת יהיה קרבנו ויצק עליה שמן ונתן עליה לבנה׃ ");
INSERT INTO heb_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","והביאה אל בני אהרן הכהנים וקמץ משם מלא קמצו מסלתה ומשמנה על כל לבנתה והקטיר הכהן את אזכרתה המזבחה אשה ריח ניחח ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","והנותרת מן המנחה לאהרן ולבניו קדש קדשים מאשי יהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","וכי תקרב קרבן מנחה מאפה תנור סלת חלות מצת בלולת בשמן ורקיקי מצות משחים בשמן׃ ");
INSERT INTO heb_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","ואם מנחה על המחבת קרבנך סלת בלולה בשמן מצה תהיה׃ ");
INSERT INTO heb_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","פתות אתה פתים ויצקת עליה שמן מנחה הוא׃ ");
INSERT INTO heb_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","ואם מנחת מרחשת קרבנך סלת בשמן תעשה׃ ");
INSERT INTO heb_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","והבאת את המנחה אשר יעשה מאלה ליהוה והקריבה אל הכהן והגישה אל המזבח׃ ");
INSERT INTO heb_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","והרים הכהן מן המנחה את אזכרתה והקטיר המזבחה אשה ריח ניחח ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","והנותרת מן המנחה לאהרן ולבניו קדש קדשים מאשי יהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","כל המנחה אשר תקריבו ליהוה לא תעשה חמץ כי כל שאר וכל דבש לא תקטירו ממנו אשה ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","קרבן ראשית תקריבו אתם ליהוה ואל המזבח לא יעלו לריח ניחח׃ ");
INSERT INTO heb_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","וכל קרבן מנחתך במלח תמלח ולא תשבית מלח ברית אלהיך מעל מנחתך על כל קרבנך תקריב מלח׃ ");
INSERT INTO heb_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","ואם תקריב מנחת בכורים ליהוה אביב קלוי באש גרש כרמל תקריב את מנחת בכוריך׃ ");
INSERT INTO heb_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","ונתת עליה שמן ושמת עליה לבנה מנחה הוא׃ ");
INSERT INTO heb_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","והקטיר הכהן את אזכרתה מגרשה ומשמנה על כל לבנתה אשה ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","ואם זבח שלמים קרבנו אם מן הבקר הוא מקריב אם זכר אם נקבה תמים יקריבנו לפני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","וסמך ידו על ראש קרבנו ושחטו פתח אהל מועד וזרקו בני אהרן הכהנים את הדם על המזבח סביב׃ ");
INSERT INTO heb_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","והקריב מזבח השלמים אשה ליהוה את החלב המכסה את הקרב ואת כל החלב אשר על הקרב׃ ");
INSERT INTO heb_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","ואת שתי הכלית ואת החלב אשר עלהן אשר על הכסלים ואת היתרת על הכבד על הכליות יסירנה׃ ");
INSERT INTO heb_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","והקטירו אתו בני אהרן המזבחה על העלה אשר על העצים אשר על האש אשה ריח ניחח ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","ואם מן הצאן קרבנו לזבח שלמים ליהוה זכר או נקבה תמים יקריבנו׃ ");
INSERT INTO heb_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","אם כשב הוא מקריב את קרבנו והקריב אתו לפני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","וסמך את ידו על ראש קרבנו ושחט אתו לפני אהל מועד וזרקו בני אהרן את דמו על המזבח סביב׃ ");
INSERT INTO heb_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","והקריב מזבח השלמים אשה ליהוה חלבו האליה תמימה לעמת העצה יסירנה ואת החלב המכסה את הקרב ואת כל החלב אשר על הקרב׃ ");
INSERT INTO heb_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","ואת שתי הכלית ואת החלב אשר עלהן אשר על הכסלים ואת היתרת על הכבד על הכלית יסירנה׃ ");
INSERT INTO heb_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","והקטירו הכהן המזבחה לחם אשה ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","ואם עז קרבנו והקריבו לפני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","וסמך את ידו על ראשו ושחט אתו לפני אהל מועד וזרקו בני אהרן את דמו על המזבח סביב׃ ");
INSERT INTO heb_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","והקריב ממנו קרבנו אשה ליהוה את החלב המכסה את הקרב ואת כל החלב אשר על הקרב׃ ");
INSERT INTO heb_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","ואת שתי הכלית ואת החלב אשר עלהן אשר על הכסלים ואת היתרת על הכבד על הכלית יסירנה׃ ");
INSERT INTO heb_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","והקטירם הכהן המזבחה לחם אשה לריח ניחח כל חלב ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","חקת עולם לדרתיכם בכל מושבתיכם כל חלב וכל דם לא תאכלו׃ ");
INSERT INTO heb_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","דבר אל בני ישראל לאמר נפש כי תחטא בשגגה מכל מצות יהוה אשר לא תעשינה ועשה מאחת מהנה׃ ");
INSERT INTO heb_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","אם הכהן המשיח יחטא לאשמת העם והקריב על חטאתו אשר חטא פר בן בקר תמים ליהוה לחטאת׃ ");
INSERT INTO heb_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","והביא את הפר אל פתח אהל מועד לפני יהוה וסמך את ידו על ראש הפר ושחט את הפר לפני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","ולקח הכהן המשיח מדם הפר והביא אתו אל אהל מועד׃ ");
INSERT INTO heb_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","וטבל הכהן את אצבעו בדם והזה מן הדם שבע פעמים לפני יהוה את פני פרכת הקדש׃ ");
INSERT INTO heb_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","ונתן הכהן מן הדם על קרנות מזבח קטרת הסמים לפני יהוה אשר באהל מועד ואת כל דם הפר ישפך אל יסוד מזבח העלה אשר פתח אהל מועד׃ ");
INSERT INTO heb_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","ואת כל חלב פר החטאת ירים ממנו את החלב המכסה על הקרב ואת כל החלב אשר על הקרב׃ ");
INSERT INTO heb_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","ואת שתי הכלית ואת החלב אשר עליהן אשר על הכסלים ואת היתרת על הכבד על הכליות יסירנה׃ ");
INSERT INTO heb_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","כאשר יורם משור זבח השלמים והקטירם הכהן על מזבח העלה׃ ");
INSERT INTO heb_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","ואת עור הפר ואת כל בשרו על ראשו ועל כרעיו וקרבו ופרשו׃ ");
INSERT INTO heb_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","והוציא את כל הפר אל מחוץ למחנה אל מקום טהור אל שפך הדשן ושרף אתו על עצים באש על שפך הדשן ישרף׃ ");
INSERT INTO heb_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","ואם כל עדת ישראל ישגו ונעלם דבר מעיני הקהל ועשו אחת מכל מצות יהוה אשר לא תעשינה ואשמו׃ ");
INSERT INTO heb_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","ונודעה החטאת אשר חטאו עליה והקריבו הקהל פר בן בקר לחטאת והביאו אתו לפני אהל מועד׃ ");
INSERT INTO heb_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","וסמכו זקני העדה את ידיהם על ראש הפר לפני יהוה ושחט את הפר לפני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","והביא הכהן המשיח מדם הפר אל אהל מועד׃ ");
INSERT INTO heb_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","וטבל הכהן אצבעו מן הדם והזה שבע פעמים לפני יהוה את פני הפרכת׃ ");
INSERT INTO heb_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","ומן הדם יתן על קרנת המזבח אשר לפני יהוה אשר באהל מועד ואת כל הדם ישפך אל יסוד מזבח העלה אשר פתח אהל מועד׃ ");
INSERT INTO heb_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","ואת כל חלבו ירים ממנו והקטיר המזבחה׃ ");
INSERT INTO heb_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","ועשה לפר כאשר עשה לפר החטאת כן יעשה לו וכפר עלהם הכהן ונסלח להם׃ ");
INSERT INTO heb_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","והוציא את הפר אל מחוץ למחנה ושרף אתו כאשר שרף את הפר הראשון חטאת הקהל הוא׃ ");
INSERT INTO heb_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","אשר נשיא יחטא ועשה אחת מכל מצות יהוה אלהיו אשר לא תעשינה בשגגה ואשם׃ ");
INSERT INTO heb_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","או הודע אליו חטאתו אשר חטא בה והביא את קרבנו שעיר עזים זכר תמים׃ ");
INSERT INTO heb_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","וסמך ידו על ראש השעיר ושחט אתו במקום אשר ישחט את העלה לפני יהוה חטאת הוא׃ ");
INSERT INTO heb_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","ולקח הכהן מדם החטאת באצבעו ונתן על קרנת מזבח העלה ואת דמו ישפך אל יסוד מזבח העלה׃ ");
INSERT INTO heb_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","ואת כל חלבו יקטיר המזבחה כחלב זבח השלמים וכפר עליו הכהן מחטאתו ונסלח לו׃ ");
INSERT INTO heb_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","ואם נפש אחת תחטא בשגגה מעם הארץ בעשתה אחת ממצות יהוה אשר לא תעשינה ואשם׃ ");
INSERT INTO heb_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","או הודע אליו חטאתו אשר חטא והביא קרבנו שעירת עזים תמימה נקבה על חטאתו אשר חטא׃ ");
INSERT INTO heb_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","וסמך את ידו על ראש החטאת ושחט את החטאת במקום העלה׃ ");
INSERT INTO heb_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","ולקח הכהן מדמה באצבעו ונתן על קרנת מזבח העלה ואת כל דמה ישפך אל יסוד המזבח׃ ");
INSERT INTO heb_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","ואת כל חלבה יסיר כאשר הוסר חלב מעל זבח השלמים והקטיר הכהן המזבחה לריח ניחח ליהוה וכפר עליו הכהן ונסלח לו׃ ");
INSERT INTO heb_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","ואם כבש יביא קרבנו לחטאת נקבה תמימה יביאנה׃ ");
INSERT INTO heb_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","וסמך את ידו על ראש החטאת ושחט אתה לחטאת במקום אשר ישחט את העלה׃ ");
INSERT INTO heb_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","ולקח הכהן מדם החטאת באצבעו ונתן על קרנת מזבח העלה ואת כל דמה ישפך אל יסוד המזבח׃ ");
INSERT INTO heb_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","ואת כל חלבה יסיר כאשר יוסר חלב הכשב מזבח השלמים והקטיר הכהן אתם המזבחה על אשי יהוה וכפר עליו הכהן על חטאתו אשר חטא ונסלח לו׃ ");
INSERT INTO heb_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","ונפש כי תחטא ושמעה קול אלה והוא עד או ראה או ידע אם לוא יגיד ונשא עונו׃ ");
INSERT INTO heb_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","או נפש אשר תגע בכל דבר טמא או בנבלת חיה טמאה או בנבלת בהמה טמאה או בנבלת שרץ טמא ונעלם ממנו והוא טמא ואשם׃ ");
INSERT INTO heb_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","או כי יגע בטמאת אדם לכל טמאתו אשר יטמא בה ונעלם ממנו והוא ידע ואשם׃ ");
INSERT INTO heb_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","או נפש כי תשבע לבטא בשפתים להרע או להיטיב לכל אשר יבטא האדם בשבעה ונעלם ממנו והוא ידע ואשם לאחת מאלה׃ ");
INSERT INTO heb_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","והיה כי יאשם לאחת מאלה והתודה אשר חטא עליה׃ ");
INSERT INTO heb_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","והביא את אשמו ליהוה על חטאתו אשר חטא נקבה מן הצאן כשבה או שעירת עזים לחטאת וכפר עליו הכהן מחטאתו׃ ");
INSERT INTO heb_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","ואם לא תגיע ידו די שה והביא את אשמו אשר חטא שתי תרים או שני בני יונה ליהוה אחד לחטאת ואחד לעלה׃ ");
INSERT INTO heb_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","והביא אתם אל הכהן והקריב את אשר לחטאת ראשונה ומלק את ראשו ממול ערפו ולא יבדיל׃ ");
INSERT INTO heb_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","והזה מדם החטאת על קיר המזבח והנשאר בדם ימצה אל יסוד המזבח חטאת הוא׃ ");
INSERT INTO heb_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","ואת השני יעשה עלה כמשפט וכפר עליו הכהן מחטאתו אשר חטא ונסלח לו׃ ");
INSERT INTO heb_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","ואם לא תשיג ידו לשתי תרים או לשני בני יונה והביא את קרבנו אשר חטא עשירת האפה סלת לחטאת לא ישים עליה שמן ולא יתן עליה לבנה כי חטאת היא׃ ");
INSERT INTO heb_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","והביאה אל הכהן וקמץ הכהן ממנה מלוא קמצו את אזכרתה והקטיר המזבחה על אשי יהוה חטאת הוא׃ ");
INSERT INTO heb_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","וכפר עליו הכהן על חטאתו אשר חטא מאחת מאלה ונסלח לו והיתה לכהן כמנחה׃ ");
INSERT INTO heb_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","נפש כי תמעל מעל וחטאה בשגגה מקדשי יהוה והביא את אשמו ליהוה איל תמים מן הצאן בערכך כסף שקלים בשקל הקדש לאשם׃ ");
INSERT INTO heb_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","ואת אשר חטא מן הקדש ישלם ואת חמישתו יוסף עליו ונתן אתו לכהן והכהן יכפר עליו באיל האשם ונסלח לו׃ ");
INSERT INTO heb_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","ואם נפש כי תחטא ועשתה אחת מכל מצות יהוה אשר לא תעשינה ולא ידע ואשם ונשא עונו׃ ");
INSERT INTO heb_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","והביא איל תמים מן הצאן בערכך לאשם אל הכהן וכפר עליו הכהן על שגגתו אשר שגג והוא לא ידע ונסלח לו׃ ");
INSERT INTO heb_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","אשם הוא אשם אשם ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","נפש כי תחטא ומעלה מעל ביהוה וכחש בעמיתו בפקדון או בתשומת יד או בגזל או עשק את עמיתו׃ ");
INSERT INTO heb_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","או מצא אבדה וכחש בה ונשבע על שקר על אחת מכל אשר יעשה האדם לחטא בהנה׃ ");
INSERT INTO heb_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","והיה כי יחטא ואשם והשיב את הגזלה אשר גזל או את העשק אשר עשק או את הפקדון אשר הפקד אתו או את האבדה אשר מצא׃ ");
INSERT INTO heb_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","או מכל אשר ישבע עליו לשקר ושלם אתו בראשו וחמשתיו יסף עליו לאשר הוא לו יתננו ביום אשמתו׃ ");
INSERT INTO heb_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","ואת אשמו יביא ליהוה איל תמים מן הצאן בערכך לאשם אל הכהן׃ ");
INSERT INTO heb_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","וכפר עליו הכהן לפני יהוה ונסלח לו על אחת מכל אשר יעשה לאשמה בה׃ ");
INSERT INTO heb_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","צו את אהרן ואת בניו לאמר זאת תורת העלה הוא העלה על מוקדה על המזבח כל הלילה עד הבקר ואש המזבח תוקד בו׃ ");
INSERT INTO heb_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","ולבש הכהן מדו בד ומכנסי בד ילבש על בשרו והרים את הדשן אשר תאכל האש את העלה על המזבח ושמו אצל המזבח׃ ");
INSERT INTO heb_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","ופשט את בגדיו ולבש בגדים אחרים והוציא את הדשן אל מחוץ למחנה אל מקום טהור׃ ");
INSERT INTO heb_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","והאש על המזבח תוקד בו לא תכבה ובער עליה הכהן עצים בבקר בבקר וערך עליה העלה והקטיר עליה חלבי השלמים׃ ");
INSERT INTO heb_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","אש תמיד תוקד על המזבח לא תכבה׃ ");
INSERT INTO heb_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","וזאת תורת המנחה הקרב אתה בני אהרן לפני יהוה אל פני המזבח׃ ");
INSERT INTO heb_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","והרים ממנו בקמצו מסלת המנחה ומשמנה ואת כל הלבנה אשר על המנחה והקטיר המזבח ריח ניחח אזכרתה ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","והנותרת ממנה יאכלו אהרן ובניו מצות תאכל במקום קדש בחצר אהל מועד יאכלוה׃ ");
INSERT INTO heb_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","לא תאפה חמץ חלקם נתתי אתה מאשי קדש קדשים הוא כחטאת וכאשם׃ ");
INSERT INTO heb_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","כל זכר בבני אהרן יאכלנה חק עולם לדרתיכם מאשי יהוה כל אשר יגע בהם יקדש׃ ");
INSERT INTO heb_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","זה קרבן אהרן ובניו אשר יקריבו ליהוה ביום המשח אתו עשירת האפה סלת מנחה תמיד מחציתה בבקר ומחציתה בערב׃ ");
INSERT INTO heb_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","על מחבת בשמן תעשה מרבכת תביאנה תפיני מנחת פתים תקריב ריח ניחח ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","והכהן המשיח תחתיו מבניו יעשה אתה חק עולם ליהוה כליל תקטר׃ ");
INSERT INTO heb_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","וכל מנחת כהן כליל תהיה לא תאכל׃ ");
INSERT INTO heb_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","דבר אל אהרן ואל בניו לאמר זאת תורת החטאת במקום אשר תשחט העלה תשחט החטאת לפני יהוה קדש קדשים הוא׃ ");
INSERT INTO heb_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","הכהן המחטא אתה יאכלנה במקום קדש תאכל בחצר אהל מועד׃ ");
INSERT INTO heb_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","כל אשר יגע בבשרה יקדש ואשר יזה מדמה על הבגד אשר יזה עליה תכבס במקום קדש׃ ");
INSERT INTO heb_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","וכלי חרש אשר תבשל בו ישבר ואם בכלי נחשת בשלה ומרק ושטף במים׃ ");
INSERT INTO heb_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","כל זכר בכהנים יאכל אתה קדש קדשים הוא׃ ");
INSERT INTO heb_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","וכל חטאת אשר יובא מדמה אל אהל מועד לכפר בקדש לא תאכל באש תשרף׃ ");
INSERT INTO heb_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","וזאת תורת האשם קדש קדשים הוא׃ ");
INSERT INTO heb_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","במקום אשר ישחטו את העלה ישחטו את האשם ואת דמו יזרק על המזבח סביב׃ ");
INSERT INTO heb_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","ואת כל חלבו יקריב ממנו את האליה ואת החלב המכסה את הקרב׃ ");
INSERT INTO heb_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","ואת שתי הכלית ואת החלב אשר עליהן אשר על הכסלים ואת היתרת על הכבד על הכלית יסירנה׃ ");
INSERT INTO heb_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","והקטיר אתם הכהן המזבחה אשה ליהוה אשם הוא׃ ");
INSERT INTO heb_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","כל זכר בכהנים יאכלנו במקום קדוש יאכל קדש קדשים הוא׃ ");
INSERT INTO heb_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","כחטאת כאשם תורה אחת להם הכהן אשר יכפר בו לו יהיה׃ ");
INSERT INTO heb_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","והכהן המקריב את עלת איש עור העלה אשר הקריב לכהן לו יהיה׃ ");
INSERT INTO heb_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","וכל מנחה אשר תאפה בתנור וכל נעשה במרחשת ועל מחבת לכהן המקריב אתה לו תהיה׃ ");
INSERT INTO heb_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","וכל מנחה בלולה בשמן וחרבה לכל בני אהרן תהיה איש כאחיו׃ ");
INSERT INTO heb_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","וזאת תורת זבח השלמים אשר יקריב ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","אם על תודה יקריבנו והקריב על זבח התודה חלות מצות בלולת בשמן ורקיקי מצות משחים בשמן וסלת מרבכת חלת בלולת בשמן׃ ");
INSERT INTO heb_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","על חלת לחם חמץ יקריב קרבנו על זבח תודת שלמיו׃ ");
INSERT INTO heb_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","והקריב ממנו אחד מכל קרבן תרומה ליהוה לכהן הזרק את דם השלמים לו יהיה׃ ");
INSERT INTO heb_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","ובשר זבח תודת שלמיו ביום קרבנו יאכל לא יניח ממנו עד בקר׃ ");
INSERT INTO heb_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","ואם נדר או נדבה זבח קרבנו ביום הקריבו את זבחו יאכל וממחרת והנותר ממנו יאכל׃ ");
INSERT INTO heb_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","והנותר מבשר הזבח ביום השלישי באש ישרף׃ ");
INSERT INTO heb_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","ואם האכל יאכל מבשר זבח שלמיו ביום השלישי לא ירצה המקריב אתו לא יחשב לו פגול יהיה והנפש האכלת ממנו עונה תשא׃ ");
INSERT INTO heb_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","והבשר אשר יגע בכל טמא לא יאכל באש ישרף והבשר כל טהור יאכל בשר׃ ");
INSERT INTO heb_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","והנפש אשר תאכל בשר מזבח השלמים אשר ליהוה וטמאתו עליו ונכרתה הנפש ההוא מעמיה׃ ");
INSERT INTO heb_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","ונפש כי תגע בכל טמא בטמאת אדם או בבהמה טמאה או בכל שקץ טמא ואכל מבשר זבח השלמים אשר ליהוה ונכרתה הנפש ההוא מעמיה׃ ");
INSERT INTO heb_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","דבר אל בני ישראל לאמר כל חלב שור וכשב ועז לא תאכלו׃ ");
INSERT INTO heb_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","וחלב נבלה וחלב טרפה יעשה לכל מלאכה ואכל לא תאכלהו׃ ");
INSERT INTO heb_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","כי כל אכל חלב מן הבהמה אשר יקריב ממנה אשה ליהוה ונכרתה הנפש האכלת מעמיה׃ ");
INSERT INTO heb_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","וכל דם לא תאכלו בכל מושבתיכם לעוף ולבהמה׃ ");
INSERT INTO heb_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","כל נפש אשר תאכל כל דם ונכרתה הנפש ההוא מעמיה׃ ");
INSERT INTO heb_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","דבר אל בני ישראל לאמר המקריב את זבח שלמיו ליהוה יביא את קרבנו ליהוה מזבח שלמיו׃ ");
INSERT INTO heb_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","ידיו תביאינה את אשי יהוה את החלב על החזה יביאנו את החזה להניף אתו תנופה לפני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","והקטיר הכהן את החלב המזבחה והיה החזה לאהרן ולבניו׃ ");
INSERT INTO heb_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","ואת שוק הימין תתנו תרומה לכהן מזבחי שלמיכם׃ ");
INSERT INTO heb_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","המקריב את דם השלמים ואת החלב מבני אהרן לו תהיה שוק הימין למנה׃ ");
INSERT INTO heb_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","כי את חזה התנופה ואת שוק התרומה לקחתי מאת בני ישראל מזבחי שלמיהם ואתן אתם לאהרן הכהן ולבניו לחק עולם מאת בני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","זאת משחת אהרן ומשחת בניו מאשי יהוה ביום הקריב אתם לכהן ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","אשר צוה יהוה לתת להם ביום משחו אתם מאת בני ישראל חקת עולם לדרתם׃ ");
INSERT INTO heb_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","זאת התורה לעלה למנחה ולחטאת ולאשם ולמלואים ולזבח השלמים׃ ");
INSERT INTO heb_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","אשר צוה יהוה את משה בהר סיני ביום צותו את בני ישראל להקריב את קרבניהם ליהוה במדבר סיני׃ ");
INSERT INTO heb_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","קח את אהרן ואת בניו אתו ואת הבגדים ואת שמן המשחה ואת פר החטאת ואת שני האילים ואת סל המצות׃ ");
INSERT INTO heb_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","ואת כל העדה הקהל אל פתח אהל מועד׃ ");
INSERT INTO heb_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","ויעש משה כאשר צוה יהוה אתו ותקהל העדה אל פתח אהל מועד׃ ");
INSERT INTO heb_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","ויאמר משה אל העדה זה הדבר אשר צוה יהוה לעשות׃ ");
INSERT INTO heb_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","ויקרב משה את אהרן ואת בניו וירחץ אתם במים׃ ");
INSERT INTO heb_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","ויתן עליו את הכתנת ויחגר אתו באבנט וילבש אתו את המעיל ויתן עליו את האפד ויחגר אתו בחשב האפד ויאפד לו בו׃ ");
INSERT INTO heb_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","וישם עליו את החשן ויתן אל החשן את האורים ואת התמים׃ ");
INSERT INTO heb_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","וישם את המצנפת על ראשו וישם על המצנפת אל מול פניו את ציץ הזהב נזר הקדש כאשר צוה יהוה את משה׃ ");
INSERT INTO heb_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","ויקח משה את שמן המשחה וימשח את המשכן ואת כל אשר בו ויקדש אתם׃ ");
INSERT INTO heb_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","ויז ממנו על המזבח שבע פעמים וימשח את המזבח ואת כל כליו ואת הכיר ואת כנו לקדשם׃ ");
INSERT INTO heb_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","ויצק משמן המשחה על ראש אהרן וימשח אתו לקדשו׃ ");
INSERT INTO heb_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","ויקרב משה את בני אהרן וילבשם כתנת ויחגר אתם אבנט ויחבש להם מגבעות כאשר צוה יהוה את משה׃ ");
INSERT INTO heb_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","ויגש את פר החטאת ויסמך אהרן ובניו את ידיהם על ראש פר החטאת׃ ");
INSERT INTO heb_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","וישחט ויקח משה את הדם ויתן על קרנות המזבח סביב באצבעו ויחטא את המזבח ואת הדם יצק אל יסוד המזבח ויקדשהו לכפר עליו׃ ");
INSERT INTO heb_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","ויקח את כל החלב אשר על הקרב ואת יתרת הכבד ואת שתי הכלית ואת חלבהן ויקטר משה המזבחה׃ ");
INSERT INTO heb_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","ואת הפר ואת ערו ואת בשרו ואת פרשו שרף באש מחוץ למחנה כאשר צוה יהוה את משה׃ ");
INSERT INTO heb_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","ויקרב את איל העלה ויסמכו אהרן ובניו את ידיהם על ראש האיל׃ ");
INSERT INTO heb_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","וישחט ויזרק משה את הדם על המזבח סביב׃ ");
INSERT INTO heb_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","ואת האיל נתח לנתחיו ויקטר משה את הראש ואת הנתחים ואת הפדר׃ ");
INSERT INTO heb_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","ואת הקרב ואת הכרעים רחץ במים ויקטר משה את כל האיל המזבחה עלה הוא לריח ניחח אשה הוא ליהוה כאשר צוה יהוה את משה׃ ");
INSERT INTO heb_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","ויקרב את האיל השני איל המלאים ויסמכו אהרן ובניו את ידיהם על ראש האיל׃ ");
INSERT INTO heb_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","וישחט ויקח משה מדמו ויתן על תנוך אזן אהרן הימנית ועל בהן ידו הימנית ועל בהן רגלו הימנית׃ ");
INSERT INTO heb_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","ויקרב את בני אהרן ויתן משה מן הדם על תנוך אזנם הימנית ועל בהן ידם הימנית ועל בהן רגלם הימנית ויזרק משה את הדם על המזבח סביב׃ ");
INSERT INTO heb_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","ויקח את החלב ואת האליה ואת כל החלב אשר על הקרב ואת יתרת הכבד ואת שתי הכלית ואת חלבהן ואת שוק הימין׃ ");
INSERT INTO heb_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","ומסל המצות אשר לפני יהוה לקח חלת מצה אחת וחלת לחם שמן אחת ורקיק אחד וישם על החלבים ועל שוק הימין׃ ");
INSERT INTO heb_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","ויתן את הכל על כפי אהרן ועל כפי בניו וינף אתם תנופה לפני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","ויקח משה אתם מעל כפיהם ויקטר המזבחה על העלה מלאים הם לריח ניחח אשה הוא ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","ויקח משה את החזה ויניפהו תנופה לפני יהוה מאיל המלאים למשה היה למנה כאשר צוה יהוה את משה׃ ");
INSERT INTO heb_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","ויקח משה משמן המשחה ומן הדם אשר על המזבח ויז על אהרן על בגדיו ועל בניו ועל בגדי בניו אתו ויקדש את אהרן את בגדיו ואת בניו ואת בגדי בניו אתו׃ ");
INSERT INTO heb_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","ויאמר משה אל אהרן ואל בניו בשלו את הבשר פתח אהל מועד ושם תאכלו אתו ואת הלחם אשר בסל המלאים כאשר צויתי לאמר אהרן ובניו יאכלהו׃ ");
INSERT INTO heb_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","והנותר בבשר ובלחם באש תשרפו׃ ");
INSERT INTO heb_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","ומפתח אהל מועד לא תצאו שבעת ימים עד יום מלאת ימי מלאיכם כי שבעת ימים ימלא את ידכם׃ ");
INSERT INTO heb_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","כאשר עשה ביום הזה צוה יהוה לעשת לכפר עליכם׃ ");
INSERT INTO heb_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","ופתח אהל מועד תשבו יומם ולילה שבעת ימים ושמרתם את משמרת יהוה ולא תמותו כי כן צויתי׃ ");
INSERT INTO heb_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","ויעש אהרן ובניו את כל הדברים אשר צוה יהוה ביד משה׃ ");
INSERT INTO heb_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","ויהי ביום השמיני קרא משה לאהרן ולבניו ולזקני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","ויאמר אל אהרן קח לך עגל בן בקר לחטאת ואיל לעלה תמימם והקרב לפני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","ואל בני ישראל תדבר לאמר קחו שעיר עזים לחטאת ועגל וכבש בני שנה תמימם לעלה׃ ");
INSERT INTO heb_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","ושור ואיל לשלמים לזבח לפני יהוה ומנחה בלולה בשמן כי היום יהוה נראה אליכם׃ ");
INSERT INTO heb_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","ויקחו את אשר צוה משה אל פני אהל מועד ויקרבו כל העדה ויעמדו לפני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","ויאמר משה זה הדבר אשר צוה יהוה תעשו וירא אליכם כבוד יהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","ויאמר משה אל אהרן קרב אל המזבח ועשה את חטאתך ואת עלתך וכפר בעדך ובעד העם ועשה את קרבן העם וכפר בעדם כאשר צוה יהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","ויקרב אהרן אל המזבח וישחט את עגל החטאת אשר לו׃ ");
INSERT INTO heb_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","ויקרבו בני אהרן את הדם אליו ויטבל אצבעו בדם ויתן על קרנות המזבח ואת הדם יצק אל יסוד המזבח׃ ");
INSERT INTO heb_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","ואת החלב ואת הכלית ואת היתרת מן הכבד מן החטאת הקטיר המזבחה כאשר צוה יהוה את משה׃ ");
INSERT INTO heb_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","ואת הבשר ואת העור שרף באש מחוץ למחנה׃ ");
INSERT INTO heb_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","וישחט את העלה וימצאו בני אהרן אליו את הדם ויזרקהו על המזבח סביב׃ ");
INSERT INTO heb_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","ואת העלה המציאו אליו לנתחיה ואת הראש ויקטר על המזבח׃ ");
INSERT INTO heb_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","וירחץ את הקרב ואת הכרעים ויקטר על העלה המזבחה׃ ");
INSERT INTO heb_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","ויקרב את קרבן העם ויקח את שעיר החטאת אשר לעם וישחטהו ויחטאהו כראשון׃ ");
INSERT INTO heb_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","ויקרב את העלה ויעשה כמשפט׃ ");
INSERT INTO heb_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","ויקרב את המנחה וימלא כפו ממנה ויקטר על המזבח מלבד עלת הבקר׃ ");
INSERT INTO heb_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","וישחט את השור ואת האיל זבח השלמים אשר לעם וימצאו בני אהרן את הדם אליו ויזרקהו על המזבח סביב׃ ");
INSERT INTO heb_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","ואת החלבים מן השור ומן האיל האליה והמכסה והכלית ויתרת הכבד׃ ");
INSERT INTO heb_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","וישימו את החלבים על החזות ויקטר החלבים המזבחה׃ ");
INSERT INTO heb_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","ואת החזות ואת שוק הימין הניף אהרן תנופה לפני יהוה כאשר צוה משה׃ ");
INSERT INTO heb_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","וישא אהרן את ידו אל העם ויברכם וירד מעשת החטאת והעלה והשלמים׃ ");
INSERT INTO heb_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","ויבא משה ואהרן אל אהל מועד ויצאו ויברכו את העם וירא כבוד יהוה אל כל העם׃ ");
INSERT INTO heb_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","ותצא אש מלפני יהוה ותאכל על המזבח את העלה ואת החלבים וירא כל העם וירנו ויפלו על פניהם׃ ");
INSERT INTO heb_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","ויקחו בני אהרן נדב ואביהוא איש מחתתו ויתנו בהן אש וישימו עליה קטרת ויקרבו לפני יהוה אש זרה אשר לא צוה אתם׃ ");
INSERT INTO heb_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","ותצא אש מלפני יהוה ותאכל אותם וימתו לפני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","ויאמר משה אל אהרן הוא אשר דבר יהוה לאמר בקרבי אקדש ועל פני כל העם אכבד וידם אהרן׃ ");
INSERT INTO heb_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","ויקרא משה אל מישאל ואל אלצפן בני עזיאל דד אהרן ויאמר אלהם קרבו שאו את אחיכם מאת פני הקדש אל מחוץ למחנה׃ ");
INSERT INTO heb_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","ויקרבו וישאם בכתנתם אל מחוץ למחנה כאשר דבר משה׃ ");
INSERT INTO heb_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","ויאמר משה אל אהרן ולאלעזר ולאיתמר בניו ראשיכם אל תפרעו ובגדיכם לא תפרמו ולא תמתו ועל כל העדה יקצף ואחיכם כל בית ישראל יבכו את השרפה אשר שרף יהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","ומפתח אהל מועד לא תצאו פן תמתו כי שמן משחת יהוה עליכם ויעשו כדבר משה׃ ");
INSERT INTO heb_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","וידבר יהוה אל אהרן לאמר׃ ");
INSERT INTO heb_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","יין ושכר אל תשת אתה ובניך אתך בבאכם אל אהל מועד ולא תמתו חקת עולם לדרתיכם׃ ");
INSERT INTO heb_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","ולהבדיל בין הקדש ובין החל ובין הטמא ובין הטהור׃ ");
INSERT INTO heb_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","ולהורת את בני ישראל את כל החקים אשר דבר יהוה אליהם ביד משה׃ ");
INSERT INTO heb_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","וידבר משה אל אהרן ואל אלעזר ואל איתמר בניו הנותרים קחו את המנחה הנותרת מאשי יהוה ואכלוה מצות אצל המזבח כי קדש קדשים הוא׃ ");
INSERT INTO heb_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","ואכלתם אתה במקום קדש כי חקך וחק בניך הוא מאשי יהוה כי כן צויתי׃ ");
INSERT INTO heb_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","ואת חזה התנופה ואת שוק התרומה תאכלו במקום טהור אתה ובניך ובנתיך אתך כי חקך וחק בניך נתנו מזבחי שלמי בני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","שוק התרומה וחזה התנופה על אשי החלבים יביאו להניף תנופה לפני יהוה והיה לך ולבניך אתך לחק עולם כאשר צוה יהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","ואת שעיר החטאת דרש דרש משה והנה שרף ויקצף על אלעזר ועל איתמר בני אהרן הנותרם לאמר׃ ");
INSERT INTO heb_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","מדוע לא אכלתם את החטאת במקום הקדש כי קדש קדשים הוא ואתה נתן לכם לשאת את עון העדה לכפר עליהם לפני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","הן לא הובא את דמה אל הקדש פנימה אכול תאכלו אתה בקדש כאשר צויתי׃ ");
INSERT INTO heb_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","וידבר אהרן אל משה הן היום הקריבו את חטאתם ואת עלתם לפני יהוה ותקראנה אתי כאלה ואכלתי חטאת היום הייטב בעיני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","וישמע משה וייטב בעיניו׃ ");
INSERT INTO heb_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","וידבר יהוה אל משה ואל אהרן לאמר אלהם׃ ");
INSERT INTO heb_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","דברו אל בני ישראל לאמר זאת החיה אשר תאכלו מכל הבהמה אשר על הארץ׃ ");
INSERT INTO heb_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","כל מפרסת פרסה ושסעת שסע פרסת מעלת גרה בבהמה אתה תאכלו׃ ");
INSERT INTO heb_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","אך את זה לא תאכלו ממעלי הגרה וממפריסי הפרסה את הגמל כי מעלה גרה הוא ופרסה איננו מפריס טמא הוא לכם׃ ");
INSERT INTO heb_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","ואת השפן כי מעלה גרה הוא ופרסה לא יפריס טמא הוא לכם׃ ");
INSERT INTO heb_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","ואת הארנבת כי מעלת גרה הוא ופרסה לא הפריסה טמאה הוא לכם׃ ");
INSERT INTO heb_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","ואת החזיר כי מפריס פרסה הוא ושסע שסע פרסה והוא גרה לא יגר טמא הוא לכם׃ ");
INSERT INTO heb_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","מבשרם לא תאכלו ובנבלתם לא תגעו טמאים הם לכם׃ ");
INSERT INTO heb_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","את זה תאכלו מכל אשר במים כל אשר לו סנפיר וקשקשת במים בימים ובנחלים אתם תאכלו׃ ");
INSERT INTO heb_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","וכל אשר אין לו סנפיר וקשקשת בימים ובנחלים מכל שרץ המים ומכל נפש החיה אשר במים שקץ הם לכם׃ ");
INSERT INTO heb_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","ושקץ יהיו לכם מבשרם לא תאכלו ואת נבלתם תשקצו׃ ");
INSERT INTO heb_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","כל אשר אין לו סנפיר וקשקשת במים שקץ הוא לכם׃ ");
INSERT INTO heb_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","ואת אלה תשקצו מן העוף לא יאכלו שקץ הם את הנשר ואת הפרס ואת העזניה׃ ");
INSERT INTO heb_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","ואת הדאה ואת האיה למינה׃ ");
INSERT INTO heb_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","את כל ערב למינו׃ ");
INSERT INTO heb_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","ואת בת היענה ואת התחמס ואת השחף ואת הנץ למינהו׃ ");
INSERT INTO heb_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","ואת הכוס ואת השלך ואת הינשוף׃ ");
INSERT INTO heb_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","ואת התנשמת ואת הקאת ואת הרחם׃ ");
INSERT INTO heb_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","ואת החסידה האנפה למינה ואת הדוכיפת ואת העטלף׃ ");
INSERT INTO heb_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","כל שרץ העוף ההלך על ארבע שקץ הוא לכם׃ ");
INSERT INTO heb_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","אך את זה תאכלו מכל שרץ העוף ההלך על ארבע אשר לא כרעים ממעל לרגליו לנתר בהן על הארץ׃ ");
INSERT INTO heb_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","את אלה מהם תאכלו את הארבה למינו ואת הסלעם למינהו ואת החרגל למינהו ואת החגב למינהו׃ ");
INSERT INTO heb_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","וכל שרץ העוף אשר לו ארבע רגלים שקץ הוא לכם׃ ");
INSERT INTO heb_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","ולאלה תטמאו כל הנגע בנבלתם יטמא עד הערב׃ ");
INSERT INTO heb_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","וכל הנשא מנבלתם יכבס בגדיו וטמא עד הערב׃ ");
INSERT INTO heb_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","לכל הבהמה אשר הוא מפרסת פרסה ושסע איננה שסעת וגרה איננה מעלה טמאים הם לכם כל הנגע בהם יטמא׃ ");
INSERT INTO heb_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","וכל הולך על כפיו בכל החיה ההלכת על ארבע טמאים הם לכם כל הנגע בנבלתם יטמא עד הערב׃ ");
INSERT INTO heb_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","והנשא את נבלתם יכבס בגדיו וטמא עד הערב טמאים המה לכם׃ ");
INSERT INTO heb_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","וזה לכם הטמא בשרץ השרץ על הארץ החלד והעכבר והצב למינהו׃ ");
INSERT INTO heb_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","והאנקה והכח והלטאה והחמט והתנשמת׃ ");
INSERT INTO heb_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","אלה הטמאים לכם בכל השרץ כל הנגע בהם במתם יטמא עד הערב׃ ");
INSERT INTO heb_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","וכל אשר יפל עליו מהם במתם יטמא מכל כלי עץ או בגד או עור או שק כל כלי אשר יעשה מלאכה בהם במים יובא וטמא עד הערב וטהר׃ ");
INSERT INTO heb_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","וכל כלי חרש אשר יפל מהם אל תוכו כל אשר בתוכו יטמא ואתו תשברו׃ ");
INSERT INTO heb_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","מכל האכל אשר יאכל אשר יבוא עליו מים יטמא וכל משקה אשר ישתה בכל כלי יטמא׃ ");
INSERT INTO heb_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","וכל אשר יפל מנבלתם עליו יטמא תנור וכירים יתץ טמאים הם וטמאים יהיו לכם׃ ");
INSERT INTO heb_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","אך מעין ובור מקוה מים יהיה טהור ונגע בנבלתם יטמא׃ ");
INSERT INTO heb_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","וכי יפל מנבלתם על כל זרע זרוע אשר יזרע טהור הוא׃ ");
INSERT INTO heb_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","וכי יתן מים על זרע ונפל מנבלתם עליו טמא הוא לכם׃ ");
INSERT INTO heb_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","וכי ימות מן הבהמה אשר היא לכם לאכלה הנגע בנבלתה יטמא עד הערב׃ ");
INSERT INTO heb_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","והאכל מנבלתה יכבס בגדיו וטמא עד הערב והנשא את נבלתה יכבס בגדיו וטמא עד הערב׃ ");
INSERT INTO heb_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","וכל השרץ השרץ על הארץ שקץ הוא לא יאכל׃ ");
INSERT INTO heb_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","כל הולך על גחון וכל הולך על ארבע עד כל מרבה רגלים לכל השרץ השרץ על הארץ לא תאכלום כי שקץ הם׃ ");
INSERT INTO heb_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","אל תשקצו את נפשתיכם בכל השרץ השרץ ולא תטמאו בהם ונטמתם בם׃ ");
INSERT INTO heb_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","כי אני יהוה אלהיכם והתקדשתם והייתם קדשים כי קדוש אני ולא תטמאו את נפשתיכם בכל השרץ הרמש על הארץ׃ ");
INSERT INTO heb_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","כי אני יהוה המעלה אתכם מארץ מצרים להית לכם לאלהים והייתם קדשים כי קדוש אני׃ ");
INSERT INTO heb_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","זאת תורת הבהמה והעוף וכל נפש החיה הרמשת במים ולכל נפש השרצת על הארץ׃ ");
INSERT INTO heb_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","להבדיל בין הטמא ובין הטהר ובין החיה הנאכלת ובין החיה אשר לא תאכל׃ ");
INSERT INTO heb_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","דבר אל בני ישראל לאמר אשה כי תזריע וילדה זכר וטמאה שבעת ימים כימי נדת דותה תטמא׃ ");
INSERT INTO heb_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","וביום השמיני ימול בשר ערלתו׃ ");
INSERT INTO heb_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","ושלשים יום ושלשת ימים תשב בדמי טהרה בכל קדש לא תגע ואל המקדש לא תבא עד מלאת ימי טהרה׃ ");
INSERT INTO heb_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","ואם נקבה תלד וטמאה שבעים כנדתה וששים יום וששת ימים תשב על דמי טהרה׃ ");
INSERT INTO heb_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","ובמלאת ימי טהרה לבן או לבת תביא כבש בן שנתו לעלה ובן יונה או תר לחטאת אל פתח אהל מועד אל הכהן׃ ");
INSERT INTO heb_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","והקריבו לפני יהוה וכפר עליה וטהרה ממקר דמיה זאת תורת הילדת לזכר או לנקבה׃ ");
INSERT INTO heb_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","ואם לא תמצא ידה די שה ולקחה שתי תרים או שני בני יונה אחד לעלה ואחד לחטאת וכפר עליה הכהן וטהרה׃ ");
INSERT INTO heb_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","וידבר יהוה אל משה ואל אהרן לאמר׃ ");
INSERT INTO heb_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","אדם כי יהיה בעור בשרו שאת או ספחת או בהרת והיה בעור בשרו לנגע צרעת והובא אל אהרן הכהן או אל אחד מבניו הכהנים׃ ");
INSERT INTO heb_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","וראה הכהן את הנגע בעור הבשר ושער בנגע הפך לבן ומראה הנגע עמק מעור בשרו נגע צרעת הוא וראהו הכהן וטמא אתו׃ ");
INSERT INTO heb_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","ואם בהרת לבנה הוא בעור בשרו ועמק אין מראה מן העור ושערה לא הפך לבן והסגיר הכהן את הנגע שבעת ימים׃ ");
INSERT INTO heb_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","וראהו הכהן ביום השביעי והנה הנגע עמד בעיניו לא פשה הנגע בעור והסגירו הכהן שבעת ימים שנית׃ ");
INSERT INTO heb_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","וראה הכהן אתו ביום השביעי שנית והנה כהה הנגע ולא פשה הנגע בעור וטהרו הכהן מספחת היא וכבס בגדיו וטהר׃ ");
INSERT INTO heb_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","ואם פשה תפשה המספחת בעור אחרי הראתו אל הכהן לטהרתו ונראה שנית אל הכהן׃ ");
INSERT INTO heb_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","וראה הכהן והנה פשתה המספחת בעור וטמאו הכהן צרעת הוא׃ ");
INSERT INTO heb_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","נגע צרעת כי תהיה באדם והובא אל הכהן׃ ");
INSERT INTO heb_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","וראה הכהן והנה שאת לבנה בעור והיא הפכה שער לבן ומחית בשר חי בשאת׃ ");
INSERT INTO heb_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","צרעת נושנת הוא בעור בשרו וטמאו הכהן לא יסגרנו כי טמא הוא׃ ");
INSERT INTO heb_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","ואם פרוח תפרח הצרעת בעור וכסתה הצרעת את כל עור הנגע מראשו ועד רגליו לכל מראה עיני הכהן׃ ");
INSERT INTO heb_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","וראה הכהן והנה כסתה הצרעת את כל בשרו וטהר את הנגע כלו הפך לבן טהור הוא׃ ");
INSERT INTO heb_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","וביום הראות בו בשר חי יטמא׃ ");
INSERT INTO heb_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","וראה הכהן את הבשר החי וטמאו הבשר החי טמא הוא צרעת הוא׃ ");
INSERT INTO heb_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","או כי ישוב הבשר החי ונהפך ללבן ובא אל הכהן׃ ");
INSERT INTO heb_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","וראהו הכהן והנה נהפך הנגע ללבן וטהר הכהן את הנגע טהור הוא׃ ");
INSERT INTO heb_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","ובשר כי יהיה בו בערו שחין ונרפא׃ ");
INSERT INTO heb_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","והיה במקום השחין שאת לבנה או בהרת לבנה אדמדמת ונראה אל הכהן׃ ");
INSERT INTO heb_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","וראה הכהן והנה מראה שפל מן העור ושערה הפך לבן וטמאו הכהן נגע צרעת היא בשחין פרחה׃ ");
INSERT INTO heb_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","ואם יראנה הכהן והנה אין בה שער לבן ושפלה איננה מן העור והיא כהה והסגירו הכהן שבעת ימים׃ ");
INSERT INTO heb_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","ואם פשה תפשה בעור וטמא הכהן אתו נגע הוא׃ ");
INSERT INTO heb_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","ואם תחתיה תעמד הבהרת לא פשתה צרבת השחין הוא וטהרו הכהן׃ ");
INSERT INTO heb_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","או בשר כי יהיה בערו מכות אש והיתה מחית המכוה בהרת לבנה אדמדמת או לבנה׃ ");
INSERT INTO heb_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","וראה אתה הכהן והנה נהפך שער לבן בבהרת ומראה עמק מן העור צרעת הוא במכוה פרחה וטמא אתו הכהן נגע צרעת הוא׃ ");
INSERT INTO heb_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","ואם יראנה הכהן והנה אין בבהרת שער לבן ושפלה איננה מן העור והוא כהה והסגירו הכהן שבעת ימים׃ ");
INSERT INTO heb_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","וראהו הכהן ביום השביעי אם פשה תפשה בעור וטמא הכהן אתו נגע צרעת הוא׃ ");
INSERT INTO heb_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","ואם תחתיה תעמד הבהרת לא פשתה בעור והוא כהה שאת המכוה הוא וטהרו הכהן כי צרבת המכוה הוא׃ ");
INSERT INTO heb_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","ואיש או אשה כי יהיה בו נגע בראש או בזקן׃ ");
INSERT INTO heb_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","וראה הכהן את הנגע והנה מראהו עמק מן העור ובו שער צהב דק וטמא אתו הכהן נתק הוא צרעת הראש או הזקן הוא׃ ");
INSERT INTO heb_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","וכי יראה הכהן את נגע הנתק והנה אין מראהו עמק מן העור ושער שחר אין בו והסגיר הכהן את נגע הנתק שבעת ימים׃ ");
INSERT INTO heb_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","וראה הכהן את הנגע ביום השביעי והנה לא פשה הנתק ולא היה בו שער צהב ומראה הנתק אין עמק מן העור׃ ");
INSERT INTO heb_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","והתגלח ואת הנתק לא יגלח והסגיר הכהן את הנתק שבעת ימים שנית׃ ");
INSERT INTO heb_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","וראה הכהן את הנתק ביום השביעי והנה לא פשה הנתק בעור ומראהו איננו עמק מן העור וטהר אתו הכהן וכבס בגדיו וטהר׃ ");
INSERT INTO heb_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","ואם פשה יפשה הנתק בעור אחרי טהרתו׃ ");
INSERT INTO heb_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","וראהו הכהן והנה פשה הנתק בעור לא יבקר הכהן לשער הצהב טמא הוא׃ ");
INSERT INTO heb_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","ואם בעיניו עמד הנתק ושער שחר צמח בו נרפא הנתק טהור הוא וטהרו הכהן׃ ");
INSERT INTO heb_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","ואיש או אשה כי יהיה בעור בשרם בהרת בהרת לבנת׃ ");
INSERT INTO heb_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","וראה הכהן והנה בעור בשרם בהרת כהות לבנת בהק הוא פרח בעור טהור הוא׃ ");
INSERT INTO heb_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","ואיש כי ימרט ראשו קרח הוא טהור הוא׃ ");
INSERT INTO heb_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","ואם מפאת פניו ימרט ראשו גבח הוא טהור הוא׃ ");
INSERT INTO heb_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","וכי יהיה בקרחת או בגבחת נגע לבן אדמדם צרעת פרחת הוא בקרחתו או בגבחתו׃ ");
INSERT INTO heb_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","וראה אתו הכהן והנה שאת הנגע לבנה אדמדמת בקרחתו או בגבחתו כמראה צרעת עור בשר׃ ");
INSERT INTO heb_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","איש צרוע הוא טמא הוא טמא יטמאנו הכהן בראשו נגעו׃ ");
INSERT INTO heb_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","והצרוע אשר בו הנגע בגדיו יהיו פרמים וראשו יהיה פרוע ועל שפם יעטה וטמא טמא יקרא׃ ");
INSERT INTO heb_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","כל ימי אשר הנגע בו יטמא טמא הוא בדד ישב מחוץ למחנה מושבו׃ ");
INSERT INTO heb_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","והבגד כי יהיה בו נגע צרעת בבגד צמר או בבגד פשתים׃ ");
INSERT INTO heb_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","או בשתי או בערב לפשתים ולצמר או בעור או בכל מלאכת עור׃ ");
INSERT INTO heb_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","והיה הנגע ירקרק או אדמדם בבגד או בעור או בשתי או בערב או בכל כלי עור נגע צרעת הוא והראה את הכהן׃ ");
INSERT INTO heb_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","וראה הכהן את הנגע והסגיר את הנגע שבעת ימים׃ ");
INSERT INTO heb_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","וראה את הנגע ביום השביעי כי פשה הנגע בבגד או בשתי או בערב או בעור לכל אשר יעשה העור למלאכה צרעת ממארת הנגע טמא הוא׃ ");
INSERT INTO heb_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","ושרף את הבגד או את השתי או את הערב בצמר או בפשתים או את כל כלי העור אשר יהיה בו הנגע כי צרעת ממארת הוא באש תשרף׃ ");
INSERT INTO heb_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","ואם יראה הכהן והנה לא פשה הנגע בבגד או בשתי או בערב או בכל כלי עור׃ ");
INSERT INTO heb_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","וצוה הכהן וכבסו את אשר בו הנגע והסגירו שבעת ימים שנית׃ ");
INSERT INTO heb_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","וראה הכהן אחרי הכבס את הנגע והנה לא הפך הנגע את עינו והנגע לא פשה טמא הוא באש תשרפנו פחתת הוא בקרחתו או בגבחתו׃ ");
INSERT INTO heb_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","ואם ראה הכהן והנה כהה הנגע אחרי הכבס אתו וקרע אתו מן הבגד או מן העור או מן השתי או מן הערב׃ ");
INSERT INTO heb_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","ואם תראה עוד בבגד או בשתי או בערב או בכל כלי עור פרחת הוא באש תשרפנו את אשר בו הנגע׃ ");
INSERT INTO heb_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","והבגד או השתי או הערב או כל כלי העור אשר תכבס וסר מהם הנגע וכבס שנית וטהר׃ ");
INSERT INTO heb_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","זאת תורת נגע צרעת בגד הצמר או הפשתים או השתי או הערב או כל כלי עור לטהרו או לטמאו׃ ");
INSERT INTO heb_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","זאת תהיה תורת המצרע ביום טהרתו והובא אל הכהן׃ ");
INSERT INTO heb_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","ויצא הכהן אל מחוץ למחנה וראה הכהן והנה נרפא נגע הצרעת מן הצרוע׃ ");
INSERT INTO heb_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","וצוה הכהן ולקח למטהר שתי צפרים חיות טהרות ועץ ארז ושני תולעת ואזב׃ ");
INSERT INTO heb_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","וצוה הכהן ושחט את הצפור האחת אל כלי חרש על מים חיים׃ ");
INSERT INTO heb_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","את הצפר החיה יקח אתה ואת עץ הארז ואת שני התולעת ואת האזב וטבל אותם ואת הצפר החיה בדם הצפר השחטה על המים החיים׃ ");
INSERT INTO heb_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","והזה על המטהר מן הצרעת שבע פעמים וטהרו ושלח את הצפר החיה על פני השדה׃ ");
INSERT INTO heb_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","וכבס המטהר את בגדיו וגלח את כל שערו ורחץ במים וטהר ואחר יבוא אל המחנה וישב מחוץ לאהלו שבעת ימים׃ ");
INSERT INTO heb_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","והיה ביום השביעי יגלח את כל שערו את ראשו ואת זקנו ואת גבת עיניו ואת כל שערו יגלח וכבס את בגדיו ורחץ את בשרו במים וטהר׃ ");
INSERT INTO heb_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","וביום השמיני יקח שני כבשים תמימים וכבשה אחת בת שנתה תמימה ושלשה עשרנים סלת מנחה בלולה בשמן ולג אחד שמן׃ ");
INSERT INTO heb_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","והעמיד הכהן המטהר את האיש המטהר ואתם לפני יהוה פתח אהל מועד׃ ");
INSERT INTO heb_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","ולקח הכהן את הכבש האחד והקריב אתו לאשם ואת לג השמן והניף אתם תנופה לפני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","ושחט את הכבש במקום אשר ישחט את החטאת ואת העלה במקום הקדש כי כחטאת האשם הוא לכהן קדש קדשים הוא׃ ");
INSERT INTO heb_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","ולקח הכהן מדם האשם ונתן הכהן על תנוך אזן המטהר הימנית ועל בהן ידו הימנית ועל בהן רגלו הימנית׃ ");
INSERT INTO heb_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","ולקח הכהן מלג השמן ויצק על כף הכהן השמאלית׃ ");
INSERT INTO heb_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","וטבל הכהן את אצבעו הימנית מן השמן אשר על כפו השמאלית והזה מן השמן באצבעו שבע פעמים לפני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","ומיתר השמן אשר על כפו יתן הכהן על תנוך אזן המטהר הימנית ועל בהן ידו הימנית ועל בהן רגלו הימנית על דם האשם׃ ");
INSERT INTO heb_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","והנותר בשמן אשר על כף הכהן יתן על ראש המטהר וכפר עליו הכהן לפני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","ועשה הכהן את החטאת וכפר על המטהר מטמאתו ואחר ישחט את העלה׃ ");
INSERT INTO heb_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","והעלה הכהן את העלה ואת המנחה המזבחה וכפר עליו הכהן וטהר׃ ");
INSERT INTO heb_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","ואם דל הוא ואין ידו משגת ולקח כבש אחד אשם לתנופה לכפר עליו ועשרון סלת אחד בלול בשמן למנחה ולג שמן׃ ");
INSERT INTO heb_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","ושתי תרים או שני בני יונה אשר תשיג ידו והיה אחד חטאת והאחד עלה׃ ");
INSERT INTO heb_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","והביא אתם ביום השמיני לטהרתו אל הכהן אל פתח אהל מועד לפני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","ולקח הכהן את כבש האשם ואת לג השמן והניף אתם הכהן תנופה לפני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","ושחט את כבש האשם ולקח הכהן מדם האשם ונתן על תנוך אזן המטהר הימנית ועל בהן ידו הימנית ועל בהן רגלו הימנית׃ ");
INSERT INTO heb_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","ומן השמן יצק הכהן על כף הכהן השמאלית׃ ");
INSERT INTO heb_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","והזה הכהן באצבעו הימנית מן השמן אשר על כפו השמאלית שבע פעמים לפני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","ונתן הכהן מן השמן אשר על כפו על תנוך אזן המטהר הימנית ועל בהן ידו הימנית ועל בהן רגלו הימנית על מקום דם האשם׃ ");
INSERT INTO heb_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","והנותר מן השמן אשר על כף הכהן יתן על ראש המטהר לכפר עליו לפני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","ועשה את האחד מן התרים או מן בני היונה מאשר תשיג ידו׃ ");
INSERT INTO heb_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","את אשר תשיג ידו את האחד חטאת ואת האחד עלה על המנחה וכפר הכהן על המטהר לפני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","זאת תורת אשר בו נגע צרעת אשר לא תשיג ידו בטהרתו׃ ");
INSERT INTO heb_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","וידבר יהוה אל משה ואל אהרן לאמר׃ ");
INSERT INTO heb_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","כי תבאו אל ארץ כנען אשר אני נתן לכם לאחזה ונתתי נגע צרעת בבית ארץ אחזתכם׃ ");
INSERT INTO heb_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","ובא אשר לו הבית והגיד לכהן לאמר כנגע נראה לי בבית׃ ");
INSERT INTO heb_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","וצוה הכהן ופנו את הבית בטרם יבא הכהן לראות את הנגע ולא יטמא כל אשר בבית ואחר כן יבא הכהן לראות את הבית׃ ");
INSERT INTO heb_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","וראה את הנגע והנה הנגע בקירת הבית שקערורת ירקרקת או אדמדמת ומראיהן שפל מן הקיר׃ ");
INSERT INTO heb_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","ויצא הכהן מן הבית אל פתח הבית והסגיר את הבית שבעת ימים׃ ");
INSERT INTO heb_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","ושב הכהן ביום השביעי וראה והנה פשה הנגע בקירת הבית׃ ");
INSERT INTO heb_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","וצוה הכהן וחלצו את האבנים אשר בהן הנגע והשליכו אתהן אל מחוץ לעיר אל מקום טמא׃ ");
INSERT INTO heb_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","ואת הבית יקצע מבית סביב ושפכו את העפר אשר הקצו אל מחוץ לעיר אל מקום טמא׃ ");
INSERT INTO heb_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","ולקחו אבנים אחרות והביאו אל תחת האבנים ועפר אחר יקח וטח את הבית׃ ");
INSERT INTO heb_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","ואם ישוב הנגע ופרח בבית אחר חלץ את האבנים ואחרי הקצות את הבית ואחרי הטוח׃ ");
INSERT INTO heb_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","ובא הכהן וראה והנה פשה הנגע בבית צרעת ממארת הוא בבית טמא הוא׃ ");
INSERT INTO heb_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","ונתץ את הבית את אבניו ואת עציו ואת כל עפר הבית והוציא אל מחוץ לעיר אל מקום טמא׃ ");
INSERT INTO heb_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","והבא אל הבית כל ימי הסגיר אתו יטמא עד הערב׃ ");
INSERT INTO heb_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","והשכב בבית יכבס את בגדיו והאכל בבית יכבס את בגדיו׃ ");
INSERT INTO heb_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","ואם בא יבא הכהן וראה והנה לא פשה הנגע בבית אחרי הטח את הבית וטהר הכהן את הבית כי נרפא הנגע׃ ");
INSERT INTO heb_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","ולקח לחטא את הבית שתי צפרים ועץ ארז ושני תולעת ואזב׃ ");
INSERT INTO heb_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","ושחט את הצפר האחת אל כלי חרש על מים חיים׃ ");
INSERT INTO heb_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","ולקח את עץ הארז ואת האזב ואת שני התולעת ואת הצפר החיה וטבל אתם בדם הצפר השחוטה ובמים החיים והזה אל הבית שבע פעמים׃ ");
INSERT INTO heb_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","וחטא את הבית בדם הצפור ובמים החיים ובצפר החיה ובעץ הארז ובאזב ובשני התולעת׃ ");
INSERT INTO heb_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","ושלח את הצפר החיה אל מחוץ לעיר אל פני השדה וכפר על הבית וטהר׃ ");
INSERT INTO heb_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","זאת התורה לכל נגע הצרעת ולנתק׃ ");
INSERT INTO heb_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","ולצרעת הבגד ולבית׃ ");
INSERT INTO heb_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","ולשאת ולספחת ולבהרת׃ ");
INSERT INTO heb_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","להורת ביום הטמא וביום הטהר זאת תורת הצרעת׃ ");
INSERT INTO heb_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","וידבר יהוה אל משה ואל אהרן לאמר׃ ");
INSERT INTO heb_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","דברו אל בני ישראל ואמרתם אלהם איש איש כי יהיה זב מבשרו זובו טמא הוא׃ ");
INSERT INTO heb_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","וזאת תהיה טמאתו בזובו רר בשרו את זובו או החתים בשרו מזובו טמאתו הוא׃ ");
INSERT INTO heb_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","כל המשכב אשר ישכב עליו הזב יטמא וכל הכלי אשר ישב עליו יטמא׃ ");
INSERT INTO heb_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","ואיש אשר יגע במשכבו יכבס בגדיו ורחץ במים וטמא עד הערב׃ ");
INSERT INTO heb_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","והישב על הכלי אשר ישב עליו הזב יכבס בגדיו ורחץ במים וטמא עד הערב׃ ");
INSERT INTO heb_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","והנגע בבשר הזב יכבס בגדיו ורחץ במים וטמא עד הערב׃ ");
INSERT INTO heb_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","וכי ירק הזב בטהור וכבס בגדיו ורחץ במים וטמא עד הערב׃ ");
INSERT INTO heb_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","וכל המרכב אשר ירכב עליו הזב יטמא׃ ");
INSERT INTO heb_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","וכל הנגע בכל אשר יהיה תחתיו יטמא עד הערב והנושא אותם יכבס בגדיו ורחץ במים וטמא עד הערב׃ ");
INSERT INTO heb_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","וכל אשר יגע בו הזב וידיו לא שטף במים וכבס בגדיו ורחץ במים וטמא עד הערב׃ ");
INSERT INTO heb_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","וכלי חרש אשר יגע בו הזב ישבר וכל כלי עץ ישטף במים׃ ");
INSERT INTO heb_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","וכי יטהר הזב מזובו וספר לו שבעת ימים לטהרתו וכבס בגדיו ורחץ בשרו במים חיים וטהר׃ ");
INSERT INTO heb_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","וביום השמיני יקח לו שתי תרים או שני בני יונה ובא לפני יהוה אל פתח אהל מועד ונתנם אל הכהן׃ ");
INSERT INTO heb_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","ועשה אתם הכהן אחד חטאת והאחד עלה וכפר עליו הכהן לפני יהוה מזובו׃ ");
INSERT INTO heb_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","ואיש כי תצא ממנו שכבת זרע ורחץ במים את כל בשרו וטמא עד הערב׃ ");
INSERT INTO heb_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","וכל בגד וכל עור אשר יהיה עליו שכבת זרע וכבס במים וטמא עד הערב׃ ");
INSERT INTO heb_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","ואשה אשר ישכב איש אתה שכבת זרע ורחצו במים וטמאו עד הערב׃ ");
INSERT INTO heb_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","ואשה כי תהיה זבה דם יהיה זבה בבשרה שבעת ימים תהיה בנדתה וכל הנגע בה יטמא עד הערב׃ ");
INSERT INTO heb_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","וכל אשר תשכב עליו בנדתה יטמא וכל אשר תשב עליו יטמא׃ ");
INSERT INTO heb_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","וכל הנגע במשכבה יכבס בגדיו ורחץ במים וטמא עד הערב׃ ");
INSERT INTO heb_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","וכל הנגע בכל כלי אשר תשב עליו יכבס בגדיו ורחץ במים וטמא עד הערב׃ ");
INSERT INTO heb_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","ואם על המשכב הוא או על הכלי אשר הוא ישבת עליו בנגעו בו יטמא עד הערב׃ ");
INSERT INTO heb_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","ואם שכב ישכב איש אתה ותהי נדתה עליו וטמא שבעת ימים וכל המשכב אשר ישכב עליו יטמא׃ ");
INSERT INTO heb_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","ואשה כי יזוב זוב דמה ימים רבים בלא עת נדתה או כי תזוב על נדתה כל ימי זוב טמאתה כימי נדתה תהיה טמאה הוא׃ ");
INSERT INTO heb_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","כל המשכב אשר תשכב עליו כל ימי זובה כמשכב נדתה יהיה לה וכל הכלי אשר תשב עליו טמא יהיה כטמאת נדתה׃ ");
INSERT INTO heb_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","וכל הנוגע בם יטמא וכבס בגדיו ורחץ במים וטמא עד הערב׃ ");
INSERT INTO heb_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","ואם טהרה מזובה וספרה לה שבעת ימים ואחר תטהר׃ ");
INSERT INTO heb_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","וביום השמיני תקח לה שתי תרים או שני בני יונה והביאה אותם אל הכהן אל פתח אהל מועד׃ ");
INSERT INTO heb_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","ועשה הכהן את האחד חטאת ואת האחד עלה וכפר עליה הכהן לפני יהוה מזוב טמאתה׃ ");
INSERT INTO heb_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","והזרתם את בני ישראל מטמאתם ולא ימתו בטמאתם בטמאם את משכני אשר בתוכם׃ ");
INSERT INTO heb_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","זאת תורת הזב ואשר תצא ממנו שכבת זרע לטמאה בה׃ ");
INSERT INTO heb_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","והדוה בנדתה והזב את זובו לזכר ולנקבה ולאיש אשר ישכב עם טמאה׃ ");
INSERT INTO heb_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","וידבר יהוה אל משה אחרי מות שני בני אהרן בקרבתם לפני יהוה וימתו׃ ");
INSERT INTO heb_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","ויאמר יהוה אל משה דבר אל אהרן אחיך ואל יבא בכל עת אל הקדש מבית לפרכת אל פני הכפרת אשר על הארן ולא ימות כי בענן אראה על הכפרת׃ ");
INSERT INTO heb_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","בזאת יבא אהרן אל הקדש בפר בן בקר לחטאת ואיל לעלה׃ ");
INSERT INTO heb_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","כתנת בד קדש ילבש ומכנסי בד יהיו על בשרו ובאבנט בד יחגר ובמצנפת בד יצנף בגדי קדש הם ורחץ במים את בשרו ולבשם׃ ");
INSERT INTO heb_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","ומאת עדת בני ישראל יקח שני שעירי עזים לחטאת ואיל אחד לעלה׃ ");
INSERT INTO heb_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","והקריב אהרן את פר החטאת אשר לו וכפר בעדו ובעד ביתו׃ ");
INSERT INTO heb_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","ולקח את שני השעירם והעמיד אתם לפני יהוה פתח אהל מועד׃ ");
INSERT INTO heb_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","ונתן אהרן על שני השעירם גורלות גורל אחד ליהוה וגורל אחד לעזאזל׃ ");
INSERT INTO heb_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","והקריב אהרן את השעיר אשר עלה עליו הגורל ליהוה ועשהו חטאת׃ ");
INSERT INTO heb_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","והשעיר אשר עלה עליו הגורל לעזאזל יעמד חי לפני יהוה לכפר עליו לשלח אתו לעזאזל המדברה׃ ");
INSERT INTO heb_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","והקריב אהרן את פר החטאת אשר לו וכפר בעדו ובעד ביתו ושחט את פר החטאת אשר לו׃ ");
INSERT INTO heb_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","ולקח מלא המחתה גחלי אש מעל המזבח מלפני יהוה ומלא חפניו קטרת סמים דקה והביא מבית לפרכת׃ ");
INSERT INTO heb_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","ונתן את הקטרת על האש לפני יהוה וכסה ענן הקטרת את הכפרת אשר על העדות ולא ימות׃ ");
INSERT INTO heb_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","ולקח מדם הפר והזה באצבעו על פני הכפרת קדמה ולפני הכפרת יזה שבע פעמים מן הדם באצבעו׃ ");
INSERT INTO heb_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","ושחט את שעיר החטאת אשר לעם והביא את דמו אל מבית לפרכת ועשה את דמו כאשר עשה לדם הפר והזה אתו על הכפרת ולפני הכפרת׃ ");
INSERT INTO heb_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","וכפר על הקדש מטמאת בני ישראל ומפשעיהם לכל חטאתם וכן יעשה לאהל מועד השכן אתם בתוך טמאתם׃ ");
INSERT INTO heb_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","וכל אדם לא יהיה באהל מועד בבאו לכפר בקדש עד צאתו וכפר בעדו ובעד ביתו ובעד כל קהל ישראל׃ ");
INSERT INTO heb_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","ויצא אל המזבח אשר לפני יהוה וכפר עליו ולקח מדם הפר ומדם השעיר ונתן על קרנות המזבח סביב׃ ");
INSERT INTO heb_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","והזה עליו מן הדם באצבעו שבע פעמים וטהרו וקדשו מטמאת בני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","וכלה מכפר את הקדש ואת אהל מועד ואת המזבח והקריב את השעיר החי׃ ");
INSERT INTO heb_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","וסמך אהרן את שתי ידו על ראש השעיר החי והתודה עליו את כל עונת בני ישראל ואת כל פשעיהם לכל חטאתם ונתן אתם על ראש השעיר ושלח ביד איש עתי המדברה׃ ");
INSERT INTO heb_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","ונשא השעיר עליו את כל עונתם אל ארץ גזרה ושלח את השעיר במדבר׃ ");
INSERT INTO heb_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","ובא אהרן אל אהל מועד ופשט את בגדי הבד אשר לבש בבאו אל הקדש והניחם שם׃ ");
INSERT INTO heb_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","ורחץ את בשרו במים במקום קדוש ולבש את בגדיו ויצא ועשה את עלתו ואת עלת העם וכפר בעדו ובעד העם׃ ");
INSERT INTO heb_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","ואת חלב החטאת יקטיר המזבחה׃ ");
INSERT INTO heb_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","והמשלח את השעיר לעזאזל יכבס בגדיו ורחץ את בשרו במים ואחרי כן יבוא אל המחנה׃ ");
INSERT INTO heb_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","ואת פר החטאת ואת שעיר החטאת אשר הובא את דמם לכפר בקדש יוציא אל מחוץ למחנה ושרפו באש את ערתם ואת בשרם ואת פרשם׃ ");
INSERT INTO heb_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","והשרף אתם יכבס בגדיו ורחץ את בשרו במים ואחרי כן יבוא אל המחנה׃ ");
INSERT INTO heb_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","והיתה לכם לחקת עולם בחדש השביעי בעשור לחדש תענו את נפשתיכם וכל מלאכה לא תעשו האזרח והגר הגר בתוככם׃ ");
INSERT INTO heb_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","כי ביום הזה יכפר עליכם לטהר אתכם מכל חטאתיכם לפני יהוה תטהרו׃ ");
INSERT INTO heb_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","שבת שבתון היא לכם ועניתם את נפשתיכם חקת עולם׃ ");
INSERT INTO heb_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","וכפר הכהן אשר ימשח אתו ואשר ימלא את ידו לכהן תחת אביו ולבש את בגדי הבד בגדי הקדש׃ ");
INSERT INTO heb_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","וכפר את מקדש הקדש ואת אהל מועד ואת המזבח יכפר ועל הכהנים ועל כל עם הקהל יכפר׃ ");
INSERT INTO heb_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","והיתה זאת לכם לחקת עולם לכפר על בני ישראל מכל חטאתם אחת בשנה ויעש כאשר צוה יהוה את משה׃ ");
INSERT INTO heb_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","דבר אל אהרן ואל בניו ואל כל בני ישראל ואמרת אליהם זה הדבר אשר צוה יהוה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","איש איש מבית ישראל אשר ישחט שור או כשב או עז במחנה או אשר ישחט מחוץ למחנה׃ ");
INSERT INTO heb_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","ואל פתח אהל מועד לא הביאו להקריב קרבן ליהוה לפני משכן יהוה דם יחשב לאיש ההוא דם שפך ונכרת האיש ההוא מקרב עמו׃ ");
INSERT INTO heb_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","למען אשר יביאו בני ישראל את זבחיהם אשר הם זבחים על פני השדה והביאם ליהוה אל פתח אהל מועד אל הכהן וזבחו זבחי שלמים ליהוה אותם׃ ");
INSERT INTO heb_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","וזרק הכהן את הדם על מזבח יהוה פתח אהל מועד והקטיר החלב לריח ניחח ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","ולא יזבחו עוד את זבחיהם לשעירם אשר הם זנים אחריהם חקת עולם תהיה זאת להם לדרתם׃ ");
INSERT INTO heb_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","ואלהם תאמר איש איש מבית ישראל ומן הגר אשר יגור בתוכם אשר יעלה עלה או זבח׃ ");
INSERT INTO heb_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","ואל פתח אהל מועד לא יביאנו לעשות אתו ליהוה ונכרת האיש ההוא מעמיו׃ ");
INSERT INTO heb_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","ואיש איש מבית ישראל ומן הגר הגר בתוכם אשר יאכל כל דם ונתתי פני בנפש האכלת את הדם והכרתי אתה מקרב עמה׃ ");
INSERT INTO heb_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","כי נפש הבשר בדם הוא ואני נתתיו לכם על המזבח לכפר על נפשתיכם כי הדם הוא בנפש יכפר׃ ");
INSERT INTO heb_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","על כן אמרתי לבני ישראל כל נפש מכם לא תאכל דם והגר הגר בתוככם לא יאכל דם׃ ");
INSERT INTO heb_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","ואיש איש מבני ישראל ומן הגר הגר בתוכם אשר יצוד ציד חיה או עוף אשר יאכל ושפך את דמו וכסהו בעפר׃ ");
INSERT INTO heb_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","כי נפש כל בשר דמו בנפשו הוא ואמר לבני ישראל דם כל בשר לא תאכלו כי נפש כל בשר דמו הוא כל אכליו יכרת׃ ");
INSERT INTO heb_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","וכל נפש אשר תאכל נבלה וטרפה באזרח ובגר וכבס בגדיו ורחץ במים וטמא עד הערב וטהר׃ ");
INSERT INTO heb_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","ואם לא יכבס ובשרו לא ירחץ ונשא עונו׃ ");
INSERT INTO heb_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","דבר אל בני ישראל ואמרת אלהם אני יהוה אלהיכם׃ ");
INSERT INTO heb_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","כמעשה ארץ מצרים אשר ישבתם בה לא תעשו וכמעשה ארץ כנען אשר אני מביא אתכם שמה לא תעשו ובחקתיהם לא תלכו׃ ");
INSERT INTO heb_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","את משפטי תעשו ואת חקתי תשמרו ללכת בהם אני יהוה אלהיכם׃ ");
INSERT INTO heb_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","ושמרתם את חקתי ואת משפטי אשר יעשה אתם האדם וחי בהם אני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","איש איש אל כל שאר בשרו לא תקרבו לגלות ערוה אני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","ערות אביך וערות אמך לא תגלה אמך הוא לא תגלה ערותה׃ ");
INSERT INTO heb_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","ערות אשת אביך לא תגלה ערות אביך הוא׃ ");
INSERT INTO heb_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","ערות אחותך בת אביך או בת אמך מולדת בית או מולדת חוץ לא תגלה ערותן׃ ");
INSERT INTO heb_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","ערות בת בנך או בת בתך לא תגלה ערותן כי ערותך הנה׃ ");
INSERT INTO heb_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","ערות בת אשת אביך מולדת אביך אחותך הוא לא תגלה ערותה׃ ");
INSERT INTO heb_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","ערות אחות אביך לא תגלה שאר אביך הוא׃ ");
INSERT INTO heb_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","ערות אחות אמך לא תגלה כי שאר אמך הוא׃ ");
INSERT INTO heb_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","ערות אחי אביך לא תגלה אל אשתו לא תקרב דדתך הוא׃ ");
INSERT INTO heb_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","ערות כלתך לא תגלה אשת בנך הוא לא תגלה ערותה׃ ");
INSERT INTO heb_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","ערות אשת אחיך לא תגלה ערות אחיך הוא׃ ");
INSERT INTO heb_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","ערות אשה ובתה לא תגלה את בת בנה ואת בת בתה לא תקח לגלות ערותה שארה הנה זמה הוא׃ ");
INSERT INTO heb_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","ואשה אל אחתה לא תקח לצרר לגלות ערותה עליה בחייה׃ ");
INSERT INTO heb_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","ואל אשה בנדת טמאתה לא תקרב לגלות ערותה׃ ");
INSERT INTO heb_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","ואל אשת עמיתך לא תתן שכבתך לזרע לטמאה בה׃ ");
INSERT INTO heb_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","ומזרעך לא תתן להעביר למלך ולא תחלל את שם אלהיך אני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","ואת זכר לא תשכב משכבי אשה תועבה הוא׃ ");
INSERT INTO heb_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","ובכל בהמה לא תתן שכבתך לטמאה בה ואשה לא תעמד לפני בהמה לרבעה תבל הוא׃ ");
INSERT INTO heb_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","אל תטמאו בכל אלה כי בכל אלה נטמאו הגוים אשר אני משלח מפניכם׃ ");
INSERT INTO heb_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","ותטמא הארץ ואפקד עונה עליה ותקא הארץ את ישביה׃ ");
INSERT INTO heb_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","ושמרתם אתם את חקתי ואת משפטי ולא תעשו מכל התועבת האלה האזרח והגר הגר בתוככם׃ ");
INSERT INTO heb_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","כי את כל התועבת האל עשו אנשי הארץ אשר לפניכם ותטמא הארץ׃ ");
INSERT INTO heb_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","ולא תקיא הארץ אתכם בטמאכם אתה כאשר קאה את הגוי אשר לפניכם׃ ");
INSERT INTO heb_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","כי כל אשר יעשה מכל התועבות האלה ונכרתו הנפשות העשת מקרב עמם׃ ");
INSERT INTO heb_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","ושמרתם את משמרתי לבלתי עשות מחקות התועבת אשר נעשו לפניכם ולא תטמאו בהם אני יהוה אלהיכם׃ ");
INSERT INTO heb_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","דבר אל כל עדת בני ישראל ואמרת אלהם קדשים תהיו כי קדוש אני יהוה אלהיכם׃ ");
INSERT INTO heb_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","איש אמו ואביו תיראו ואת שבתתי תשמרו אני יהוה אלהיכם׃ ");
INSERT INTO heb_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","אל תפנו אל האלילים ואלהי מסכה לא תעשו לכם אני יהוה אלהיכם׃ ");
INSERT INTO heb_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","וכי תזבחו זבח שלמים ליהוה לרצנכם תזבחהו׃ ");
INSERT INTO heb_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","ביום זבחכם יאכל וממחרת והנותר עד יום השלישי באש ישרף׃ ");
INSERT INTO heb_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","ואם האכל יאכל ביום השלישי פגול הוא לא ירצה׃ ");
INSERT INTO heb_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","ואכליו עונו ישא כי את קדש יהוה חלל ונכרתה הנפש ההוא מעמיה׃ ");
INSERT INTO heb_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","ובקצרכם את קציר ארצכם לא תכלה פאת שדך לקצר ולקט קצירך לא תלקט׃ ");
INSERT INTO heb_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","וכרמך לא תעולל ופרט כרמך לא תלקט לעני ולגר תעזב אתם אני יהוה אלהיכם׃ ");
INSERT INTO heb_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","לא תגנבו ולא תכחשו ולא תשקרו איש בעמיתו׃ ");
INSERT INTO heb_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","ולא תשבעו בשמי לשקר וחללת את שם אלהיך אני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","לא תעשק את רעך ולא תגזל לא תלין פעלת שכיר אתך עד בקר׃ ");
INSERT INTO heb_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","לא תקלל חרש ולפני עור לא תתן מכשל ויראת מאלהיך אני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","לא תעשו עול במשפט לא תשא פני דל ולא תהדר פני גדול בצדק תשפט עמיתך׃ ");
INSERT INTO heb_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","לא תלך רכיל בעמיך לא תעמד על דם רעך אני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","לא תשנא את אחיך בלבבך הוכח תוכיח את עמיתך ולא תשא עליו חטא׃ ");
INSERT INTO heb_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","לא תקם ולא תטר את בני עמך ואהבת לרעך כמוך אני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","את חקתי תשמרו בהמתך לא תרביע כלאים שדך לא תזרע כלאים ובגד כלאים שעטנז לא יעלה עליך׃ ");
INSERT INTO heb_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","ואיש כי ישכב את אשה שכבת זרע והוא שפחה נחרפת לאיש והפדה לא נפדתה או חפשה לא נתן לה בקרת תהיה לא יומתו כי לא חפשה׃ ");
INSERT INTO heb_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","והביא את אשמו ליהוה אל פתח אהל מועד איל אשם׃ ");
INSERT INTO heb_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","וכפר עליו הכהן באיל האשם לפני יהוה על חטאתו אשר חטא ונסלח לו מחטאתו אשר חטא׃ ");
INSERT INTO heb_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","וכי תבאו אל הארץ ונטעתם כל עץ מאכל וערלתם ערלתו את פריו שלש שנים יהיה לכם ערלים לא יאכל׃ ");
INSERT INTO heb_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","ובשנה הרביעת יהיה כל פריו קדש הלולים ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","ובשנה החמישת תאכלו את פריו להוסיף לכם תבואתו אני יהוה אלהיכם׃ ");
INSERT INTO heb_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","לא תאכלו על הדם לא תנחשו ולא תעוננו׃ ");
INSERT INTO heb_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","לא תקפו פאת ראשכם ולא תשחית את פאת זקנך׃ ");
INSERT INTO heb_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","ושרט לנפש לא תתנו בבשרכם וכתבת קעקע לא תתנו בכם אני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","אל תחלל את בתך להזנותה ולא תזנה הארץ ומלאה הארץ זמה׃ ");
INSERT INTO heb_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","את שבתתי תשמרו ומקדשי תיראו אני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","אל תפנו אל האבת ואל הידענים אל תבקשו לטמאה בהם אני יהוה אלהיכם׃ ");
INSERT INTO heb_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","מפני שיבה תקום והדרת פני זקן ויראת מאלהיך אני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","וכי יגור אתך גר בארצכם לא תונו אתו׃ ");
INSERT INTO heb_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","כאזרח מכם יהיה לכם הגר הגר אתכם ואהבת לו כמוך כי גרים הייתם בארץ מצרים אני יהוה אלהיכם׃ ");
INSERT INTO heb_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","לא תעשו עול במשפט במדה במשקל ובמשורה׃ ");
INSERT INTO heb_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","מאזני צדק אבני צדק איפת צדק והין צדק יהיה לכם אני יהוה אלהיכם אשר הוצאתי אתכם מארץ מצרים׃ ");
INSERT INTO heb_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","ושמרתם את כל חקתי ואת כל משפטי ועשיתם אתם אני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","ואל בני ישראל תאמר איש איש מבני ישראל ומן הגר הגר בישראל אשר יתן מזרעו למלך מות יומת עם הארץ ירגמהו באבן׃ ");
INSERT INTO heb_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","ואני אתן את פני באיש ההוא והכרתי אתו מקרב עמו כי מזרעו נתן למלך למען טמא את מקדשי ולחלל את שם קדשי׃ ");
INSERT INTO heb_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","ואם העלם יעלימו עם הארץ את עיניהם מן האיש ההוא בתתו מזרעו למלך לבלתי המית אתו׃ ");
INSERT INTO heb_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","ושמתי אני את פני באיש ההוא ובמשפחתו והכרתי אתו ואת כל הזנים אחריו לזנות אחרי המלך מקרב עמם׃ ");
INSERT INTO heb_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","והנפש אשר תפנה אל האבת ואל הידענים לזנות אחריהם ונתתי את פני בנפש ההוא והכרתי אתו מקרב עמו׃ ");
INSERT INTO heb_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","והתקדשתם והייתם קדשים כי אני יהוה אלהיכם׃ ");
INSERT INTO heb_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","ושמרתם את חקתי ועשיתם אתם אני יהוה מקדשכם׃ ");
INSERT INTO heb_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","כי איש איש אשר יקלל את אביו ואת אמו מות יומת אביו ואמו קלל דמיו בו׃ ");
INSERT INTO heb_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","ואיש אשר ינאף את אשת איש אשר ינאף את אשת רעהו מות יומת הנאף והנאפת׃ ");
INSERT INTO heb_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","ואיש אשר ישכב את אשת אביו ערות אביו גלה מות יומתו שניהם דמיהם בם׃ ");
INSERT INTO heb_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","ואיש אשר ישכב את כלתו מות יומתו שניהם תבל עשו דמיהם בם׃ ");
INSERT INTO heb_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","ואיש אשר ישכב את זכר משכבי אשה תועבה עשו שניהם מות יומתו דמיהם בם׃ ");
INSERT INTO heb_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","ואיש אשר יקח את אשה ואת אמה זמה הוא באש ישרפו אתו ואתהן ולא תהיה זמה בתוככם׃ ");
INSERT INTO heb_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","ואיש אשר יתן שכבתו בבהמה מות יומת ואת הבהמה תהרגו׃ ");
INSERT INTO heb_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","ואשה אשר תקרב אל כל בהמה לרבעה אתה והרגת את האשה ואת הבהמה מות יומתו דמיהם בם׃ ");
INSERT INTO heb_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","ואיש אשר יקח את אחתו בת אביו או בת אמו וראה את ערותה והיא תראה את ערותו חסד הוא ונכרתו לעיני בני עמם ערות אחתו גלה עונו ישא׃ ");
INSERT INTO heb_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","ואיש אשר ישכב את אשה דוה וגלה את ערותה את מקרה הערה והיא גלתה את מקור דמיה ונכרתו שניהם מקרב עמם׃ ");
INSERT INTO heb_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","וערות אחות אמך ואחות אביך לא תגלה כי את שארו הערה עונם ישאו׃ ");
INSERT INTO heb_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","ואיש אשר ישכב את דדתו ערות דדו גלה חטאם ישאו ערירים ימתו׃ ");
INSERT INTO heb_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","ואיש אשר יקח את אשת אחיו נדה הוא ערות אחיו גלה ערירים יהיו׃ ");
INSERT INTO heb_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","ושמרתם את כל חקתי ואת כל משפטי ועשיתם אתם ולא תקיא אתכם הארץ אשר אני מביא אתכם שמה לשבת בה׃ ");
INSERT INTO heb_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","ולא תלכו בחקת הגוי אשר אני משלח מפניכם כי את כל אלה עשו ואקץ בם׃ ");
INSERT INTO heb_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","ואמר לכם אתם תירשו את אדמתם ואני אתננה לכם לרשת אתה ארץ זבת חלב ודבש אני יהוה אלהיכם אשר הבדלתי אתכם מן העמים׃ ");
INSERT INTO heb_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","והבדלתם בין הבהמה הטהרה לטמאה ובין העוף הטמא לטהר ולא תשקצו את נפשתיכם בבהמה ובעוף ובכל אשר תרמש האדמה אשר הבדלתי לכם לטמא׃ ");
INSERT INTO heb_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","והייתם לי קדשים כי קדוש אני יהוה ואבדל אתכם מן העמים להיות לי׃ ");
INSERT INTO heb_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","ואיש או אשה כי יהיה בהם אוב או ידעני מות יומתו באבן ירגמו אתם דמיהם בם׃ ");
INSERT INTO heb_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","ויאמר יהוה אל משה אמר אל הכהנים בני אהרן ואמרת אלהם לנפש לא יטמא בעמיו׃ ");
INSERT INTO heb_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","כי אם לשארו הקרב אליו לאמו ולאביו ולבנו ולבתו ולאחיו׃ ");
INSERT INTO heb_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","ולאחתו הבתולה הקרובה אליו אשר לא היתה לאיש לה יטמא׃ ");
INSERT INTO heb_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","לא יטמא בעל בעמיו להחלו׃ ");
INSERT INTO heb_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","לא יקרחה קרחה בראשם ופאת זקנם לא יגלחו ובבשרם לא ישרטו שרטת׃ ");
INSERT INTO heb_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","קדשים יהיו לאלהיהם ולא יחללו שם אלהיהם כי את אשי יהוה לחם אלהיהם הם מקריבם והיו קדש׃ ");
INSERT INTO heb_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","אשה זנה וחללה לא יקחו ואשה גרושה מאישה לא יקחו כי קדש הוא לאלהיו׃ ");
INSERT INTO heb_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","וקדשתו כי את לחם אלהיך הוא מקריב קדש יהיה לך כי קדוש אני יהוה מקדשכם׃ ");
INSERT INTO heb_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","ובת איש כהן כי תחל לזנות את אביה היא מחללת באש תשרף׃ ");
INSERT INTO heb_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","והכהן הגדול מאחיו אשר יוצק על ראשו שמן המשחה ומלא את ידו ללבש את הבגדים את ראשו לא יפרע ובגדיו לא יפרם׃ ");
INSERT INTO heb_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","ועל כל נפשת מת לא יבא לאביו ולאמו לא יטמא׃ ");
INSERT INTO heb_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","ומן המקדש לא יצא ולא יחלל את מקדש אלהיו כי נזר שמן משחת אלהיו עליו אני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","והוא אשה בבתוליה יקח׃ ");
INSERT INTO heb_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","אלמנה וגרושה וחללה זנה את אלה לא יקח כי אם בתולה מעמיו יקח אשה׃ ");
INSERT INTO heb_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","ולא יחלל זרעו בעמיו כי אני יהוה מקדשו׃ ");
INSERT INTO heb_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","דבר אל אהרן לאמר איש מזרעך לדרתם אשר יהיה בו מום לא יקרב להקריב לחם אלהיו׃ ");
INSERT INTO heb_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","כי כל איש אשר בו מום לא יקרב איש עור או פסח או חרם או שרוע׃ ");
INSERT INTO heb_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","או איש אשר יהיה בו שבר רגל או שבר יד׃ ");
INSERT INTO heb_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","או גבן או דק או תבלל בעינו או גרב או ילפת או מרוח אשך׃ ");
INSERT INTO heb_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","כל איש אשר בו מום מזרע אהרן הכהן לא יגש להקריב את אשי יהוה מום בו את לחם אלהיו לא יגש להקריב׃ ");
INSERT INTO heb_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","לחם אלהיו מקדשי הקדשים ומן הקדשים יאכל׃ ");
INSERT INTO heb_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","אך אל הפרכת לא יבא ואל המזבח לא יגש כי מום בו ולא יחלל את מקדשי כי אני יהוה מקדשם׃ ");
INSERT INTO heb_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","וידבר משה אל אהרן ואל בניו ואל כל בני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","דבר אל אהרן ואל בניו וינזרו מקדשי בני ישראל ולא יחללו את שם קדשי אשר הם מקדשים לי אני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","אמר אלהם לדרתיכם כל איש אשר יקרב מכל זרעכם אל הקדשים אשר יקדישו בני ישראל ליהוה וטמאתו עליו ונכרתה הנפש ההוא מלפני אני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","איש איש מזרע אהרן והוא צרוע או זב בקדשים לא יאכל עד אשר יטהר והנגע בכל טמא נפש או איש אשר תצא ממנו שכבת זרע׃ ");
INSERT INTO heb_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","או איש אשר יגע בכל שרץ אשר יטמא לו או באדם אשר יטמא לו לכל טמאתו׃ ");
INSERT INTO heb_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","נפש אשר תגע בו וטמאה עד הערב ולא יאכל מן הקדשים כי אם רחץ בשרו במים׃ ");
INSERT INTO heb_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","ובא השמש וטהר ואחר יאכל מן הקדשים כי לחמו הוא׃ ");
INSERT INTO heb_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","נבלה וטרפה לא יאכל לטמאה בה אני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","ושמרו את משמרתי ולא ישאו עליו חטא ומתו בו כי יחללהו אני יהוה מקדשם׃ ");
INSERT INTO heb_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","וכל זר לא יאכל קדש תושב כהן ושכיר לא יאכל קדש׃ ");
INSERT INTO heb_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","וכהן כי יקנה נפש קנין כספו הוא יאכל בו ויליד ביתו הם יאכלו בלחמו׃ ");
INSERT INTO heb_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","ובת כהן כי תהיה לאיש זר הוא בתרומת הקדשים לא תאכל׃ ");
INSERT INTO heb_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","ובת כהן כי תהיה אלמנה וגרושה וזרע אין לה ושבה אל בית אביה כנעוריה מלחם אביה תאכל וכל זר לא יאכל בו׃ ");
INSERT INTO heb_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","ואיש כי יאכל קדש בשגגה ויסף חמשיתו עליו ונתן לכהן את הקדש׃ ");
INSERT INTO heb_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","ולא יחללו את קדשי בני ישראל את אשר ירימו ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","והשיאו אותם עון אשמה באכלם את קדשיהם כי אני יהוה מקדשם׃ ");
INSERT INTO heb_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","דבר אל אהרן ואל בניו ואל כל בני ישראל ואמרת אלהם איש איש מבית ישראל ומן הגר בישראל אשר יקריב קרבנו לכל נדריהם ולכל נדבותם אשר יקריבו ליהוה לעלה׃ ");
INSERT INTO heb_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","לרצנכם תמים זכר בבקר בכשבים ובעזים׃ ");
INSERT INTO heb_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","כל אשר בו מום לא תקריבו כי לא לרצון יהיה לכם׃ ");
INSERT INTO heb_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","ואיש כי יקריב זבח שלמים ליהוה לפלא נדר או לנדבה בבקר או בצאן תמים יהיה לרצון כל מום לא יהיה בו׃ ");
INSERT INTO heb_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","עורת או שבור או חרוץ או יבלת או גרב או ילפת לא תקריבו אלה ליהוה ואשה לא תתנו מהם על המזבח ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","ושור ושה שרוע וקלוט נדבה תעשה אתו ולנדר לא ירצה׃ ");
INSERT INTO heb_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","ומעוך וכתות ונתוק וכרות לא תקריבו ליהוה ובארצכם לא תעשו׃ ");
INSERT INTO heb_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","ומיד בן נכר לא תקריבו את לחם אלהיכם מכל אלה כי משחתם בהם מום בם לא ירצו לכם׃ ");
INSERT INTO heb_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","שור או כשב או עז כי יולד והיה שבעת ימים תחת אמו ומיום השמיני והלאה ירצה לקרבן אשה ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","ושור או שה אתו ואת בנו לא תשחטו ביום אחד׃ ");
INSERT INTO heb_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","וכי תזבחו זבח תודה ליהוה לרצנכם תזבחו׃ ");
INSERT INTO heb_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","ביום ההוא יאכל לא תותירו ממנו עד בקר אני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","ושמרתם מצותי ועשיתם אתם אני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","ולא תחללו את שם קדשי ונקדשתי בתוך בני ישראל אני יהוה מקדשכם׃ ");
INSERT INTO heb_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","המוציא אתכם מארץ מצרים להיות לכם לאלהים אני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","דבר אל בני ישראל ואמרת אלהם מועדי יהוה אשר תקראו אתם מקראי קדש אלה הם מועדי׃ ");
INSERT INTO heb_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","ששת ימים תעשה מלאכה וביום השביעי שבת שבתון מקרא קדש כל מלאכה לא תעשו שבת הוא ליהוה בכל מושבתיכם׃ ");
INSERT INTO heb_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","אלה מועדי יהוה מקראי קדש אשר תקראו אתם במועדם׃ ");
INSERT INTO heb_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","בחדש הראשון בארבעה עשר לחדש בין הערבים פסח ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","ובחמשה עשר יום לחדש הזה חג המצות ליהוה שבעת ימים מצות תאכלו׃ ");
INSERT INTO heb_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","ביום הראשון מקרא קדש יהיה לכם כל מלאכת עבדה לא תעשו׃ ");
INSERT INTO heb_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","והקרבתם אשה ליהוה שבעת ימים ביום השביעי מקרא קדש כל מלאכת עבדה לא תעשו׃ ");
INSERT INTO heb_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","דבר אל בני ישראל ואמרת אלהם כי תבאו אל הארץ אשר אני נתן לכם וקצרתם את קצירה והבאתם את עמר ראשית קצירכם אל הכהן׃ ");
INSERT INTO heb_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","והניף את העמר לפני יהוה לרצנכם ממחרת השבת יניפנו הכהן׃ ");
INSERT INTO heb_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","ועשיתם ביום הניפכם את העמר כבש תמים בן שנתו לעלה ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","ומנחתו שני עשרנים סלת בלולה בשמן אשה ליהוה ריח ניחח ונסכה יין רביעת ההין׃ ");
INSERT INTO heb_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","ולחם וקלי וכרמל לא תאכלו עד עצם היום הזה עד הביאכם את קרבן אלהיכם חקת עולם לדרתיכם בכל משבתיכם׃ ");
INSERT INTO heb_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","וספרתם לכם ממחרת השבת מיום הביאכם את עמר התנופה שבע שבתות תמימת תהיינה׃ ");
INSERT INTO heb_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","עד ממחרת השבת השביעת תספרו חמשים יום והקרבתם מנחה חדשה ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","ממושבתיכם תביאו לחם תנופה שתים שני עשרנים סלת תהיינה חמץ תאפינה בכורים ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","והקרבתם על הלחם שבעת כבשים תמימם בני שנה ופר בן בקר אחד ואילם שנים יהיו עלה ליהוה ומנחתם ונסכיהם אשה ריח ניחח ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","ועשיתם שעיר עזים אחד לחטאת ושני כבשים בני שנה לזבח שלמים׃ ");
INSERT INTO heb_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","והניף הכהן אתם על לחם הבכורים תנופה לפני יהוה על שני כבשים קדש יהיו ליהוה לכהן׃ ");
INSERT INTO heb_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","וקראתם בעצם היום הזה מקרא קדש יהיה לכם כל מלאכת עבדה לא תעשו חקת עולם בכל מושבתיכם לדרתיכם׃ ");
INSERT INTO heb_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","ובקצרכם את קציר ארצכם לא תכלה פאת שדך בקצרך ולקט קצירך לא תלקט לעני ולגר תעזב אתם אני יהוה אלהיכם׃ ");
INSERT INTO heb_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","דבר אל בני ישראל לאמר בחדש השביעי באחד לחדש יהיה לכם שבתון זכרון תרועה מקרא קדש׃ ");
INSERT INTO heb_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","כל מלאכת עבדה לא תעשו והקרבתם אשה ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","אך בעשור לחדש השביעי הזה יום הכפרים הוא מקרא קדש יהיה לכם ועניתם את נפשתיכם והקרבתם אשה ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","וכל מלאכה לא תעשו בעצם היום הזה כי יום כפרים הוא לכפר עליכם לפני יהוה אלהיכם׃ ");
INSERT INTO heb_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","כי כל הנפש אשר לא תענה בעצם היום הזה ונכרתה מעמיה׃ ");
INSERT INTO heb_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","וכל הנפש אשר תעשה כל מלאכה בעצם היום הזה והאבדתי את הנפש ההוא מקרב עמה׃ ");
INSERT INTO heb_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","כל מלאכה לא תעשו חקת עולם לדרתיכם בכל משבתיכם׃ ");
INSERT INTO heb_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","שבת שבתון הוא לכם ועניתם את נפשתיכם בתשעה לחדש בערב מערב עד ערב תשבתו שבתכם׃ ");
INSERT INTO heb_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","דבר אל בני ישראל לאמר בחמשה עשר יום לחדש השביעי הזה חג הסכות שבעת ימים ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","ביום הראשון מקרא קדש כל מלאכת עבדה לא תעשו׃ ");
INSERT INTO heb_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","שבעת ימים תקריבו אשה ליהוה ביום השמיני מקרא קדש יהיה לכם והקרבתם אשה ליהוה עצרת הוא כל מלאכת עבדה לא תעשו׃ ");
INSERT INTO heb_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","אלה מועדי יהוה אשר תקראו אתם מקראי קדש להקריב אשה ליהוה עלה ומנחה זבח ונסכים דבר יום ביומו׃ ");
INSERT INTO heb_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","מלבד שבתת יהוה ומלבד מתנותיכם ומלבד כל נדריכם ומלבד כל נדבותיכם אשר תתנו ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","אך בחמשה עשר יום לחדש השביעי באספכם את תבואת הארץ תחגו את חג יהוה שבעת ימים ביום הראשון שבתון וביום השמיני שבתון׃ ");
INSERT INTO heb_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","ולקחתם לכם ביום הראשון פרי עץ הדר כפת תמרים וענף עץ עבת וערבי נחל ושמחתם לפני יהוה אלהיכם שבעת ימים׃ ");
INSERT INTO heb_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","וחגתם אתו חג ליהוה שבעת ימים בשנה חקת עולם לדרתיכם בחדש השביעי תחגו אתו׃ ");
INSERT INTO heb_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","בסכת תשבו שבעת ימים כל האזרח בישראל ישבו בסכת׃ ");
INSERT INTO heb_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","למען ידעו דרתיכם כי בסכות הושבתי את בני ישראל בהוציאי אותם מארץ מצרים אני יהוה אלהיכם׃ ");
INSERT INTO heb_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","וידבר משה את מעדי יהוה אל בני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","צו את בני ישראל ויקחו אליך שמן זית זך כתית למאור להעלת נר תמיד׃ ");
INSERT INTO heb_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","מחוץ לפרכת העדת באהל מועד יערך אתו אהרן מערב עד בקר לפני יהוה תמיד חקת עולם לדרתיכם׃ ");
INSERT INTO heb_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","על המנרה הטהרה יערך את הנרות לפני יהוה תמיד׃ ");
INSERT INTO heb_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","ולקחת סלת ואפית אתה שתים עשרה חלות שני עשרנים יהיה החלה האחת׃ ");
INSERT INTO heb_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","ושמת אותם שתים מערכות שש המערכת על השלחן הטהר לפני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","ונתת על המערכת לבנה זכה והיתה ללחם לאזכרה אשה ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","ביום השבת ביום השבת יערכנו לפני יהוה תמיד מאת בני ישראל ברית עולם׃ ");
INSERT INTO heb_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","והיתה לאהרן ולבניו ואכלהו במקום קדש כי קדש קדשים הוא לו מאשי יהוה חק עולם׃ ");
INSERT INTO heb_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","ויצא בן אשה ישראלית והוא בן איש מצרי בתוך בני ישראל וינצו במחנה בן הישראלית ואיש הישראלי׃ ");
INSERT INTO heb_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","ויקב בן האשה הישראלית את השם ויקלל ויביאו אתו אל משה ושם אמו שלמית בת דברי למטה דן׃ ");
INSERT INTO heb_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","ויניחהו במשמר לפרש להם על פי יהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","הוצא את המקלל אל מחוץ למחנה וסמכו כל השמעים את ידיהם על ראשו ורגמו אתו כל העדה׃ ");
INSERT INTO heb_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","ואל בני ישראל תדבר לאמר איש איש כי יקלל אלהיו ונשא חטאו׃ ");
INSERT INTO heb_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","ונקב שם יהוה מות יומת רגום ירגמו בו כל העדה כגר כאזרח בנקבו שם יומת׃ ");
INSERT INTO heb_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","ואיש כי יכה כל נפש אדם מות יומת׃ ");
INSERT INTO heb_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","ומכה נפש בהמה ישלמנה נפש תחת נפש׃ ");
INSERT INTO heb_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","ואיש כי יתן מום בעמיתו כאשר עשה כן יעשה לו׃ ");
INSERT INTO heb_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","שבר תחת שבר עין תחת עין שן תחת שן כאשר יתן מום באדם כן ינתן בו׃ ");
INSERT INTO heb_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","ומכה בהמה ישלמנה ומכה אדם יומת׃ ");
INSERT INTO heb_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","משפט אחד יהיה לכם כגר כאזרח יהיה כי אני יהוה אלהיכם׃ ");
INSERT INTO heb_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","וידבר משה אל בני ישראל ויוציאו את המקלל אל מחוץ למחנה וירגמו אתו אבן ובני ישראל עשו כאשר צוה יהוה את משה׃ ");
INSERT INTO heb_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","וידבר יהוה אל משה בהר סיני לאמר׃ ");
INSERT INTO heb_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","דבר אל בני ישראל ואמרת אלהם כי תבאו אל הארץ אשר אני נתן לכם ושבתה הארץ שבת ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","שש שנים תזרע שדך ושש שנים תזמר כרמך ואספת את תבואתה׃ ");
INSERT INTO heb_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","ובשנה השביעת שבת שבתון יהיה לארץ שבת ליהוה שדך לא תזרע וכרמך לא תזמר׃ ");
INSERT INTO heb_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","את ספיח קצירך לא תקצור ואת ענבי נזירך לא תבצר שנת שבתון יהיה לארץ׃ ");
INSERT INTO heb_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","והיתה שבת הארץ לכם לאכלה לך ולעבדך ולאמתך ולשכירך ולתושבך הגרים עמך׃ ");
INSERT INTO heb_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","ולבהמתך ולחיה אשר בארצך תהיה כל תבואתה לאכל׃ ");
INSERT INTO heb_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","וספרת לך שבע שבתת שנים שבע שנים שבע פעמים והיו לך ימי שבע שבתת השנים תשע וארבעים שנה׃ ");
INSERT INTO heb_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","והעברת שופר תרועה בחדש השבעי בעשור לחדש ביום הכפרים תעבירו שופר בכל ארצכם׃ ");
INSERT INTO heb_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","וקדשתם את שנת החמשים שנה וקראתם דרור בארץ לכל ישביה יובל הוא תהיה לכם ושבתם איש אל אחזתו ואיש אל משפחתו תשבו׃ ");
INSERT INTO heb_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","יובל הוא שנת החמשים שנה תהיה לכם לא תזרעו ולא תקצרו את ספיחיה ולא תבצרו את נזריה׃ ");
INSERT INTO heb_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","כי יובל הוא קדש תהיה לכם מן השדה תאכלו את תבואתה׃ ");
INSERT INTO heb_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","בשנת היובל הזאת תשבו איש אל אחזתו׃ ");
INSERT INTO heb_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","וכי תמכרו ממכר לעמיתך או קנה מיד עמיתך אל תונו איש את אחיו׃ ");
INSERT INTO heb_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","במספר שנים אחר היובל תקנה מאת עמיתך במספר שני תבואת ימכר לך׃ ");
INSERT INTO heb_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","לפי רב השנים תרבה מקנתו ולפי מעט השנים תמעיט מקנתו כי מספר תבואת הוא מכר לך׃ ");
INSERT INTO heb_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","ולא תונו איש את עמיתו ויראת מאלהיך כי אני יהוה אלהיכם׃ ");
INSERT INTO heb_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","ועשיתם את חקתי ואת משפטי תשמרו ועשיתם אתם וישבתם על הארץ לבטח׃ ");
INSERT INTO heb_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","ונתנה הארץ פריה ואכלתם לשבע וישבתם לבטח עליה׃ ");
INSERT INTO heb_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","וכי תאמרו מה נאכל בשנה השביעת הן לא נזרע ולא נאסף את תבואתנו׃ ");
INSERT INTO heb_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","וצויתי את ברכתי לכם בשנה הששית ועשת את התבואה לשלש השנים׃ ");
INSERT INTO heb_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","וזרעתם את השנה השמינת ואכלתם מן התבואה ישן עד השנה התשיעת עד בוא תבואתה תאכלו ישן׃ ");
INSERT INTO heb_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","והארץ לא תמכר לצמתת כי לי הארץ כי גרים ותושבים אתם עמדי׃ ");
INSERT INTO heb_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","ובכל ארץ אחזתכם גאלה תתנו לארץ׃ ");
INSERT INTO heb_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","כי ימוך אחיך ומכר מאחזתו ובא גאלו הקרב אליו וגאל את ממכר אחיו׃ ");
INSERT INTO heb_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","ואיש כי לא יהיה לו גאל והשיגה ידו ומצא כדי גאלתו׃ ");
INSERT INTO heb_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","וחשב את שני ממכרו והשיב את העדף לאיש אשר מכר לו ושב לאחזתו׃ ");
INSERT INTO heb_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","ואם לא מצאה ידו די השיב לו והיה ממכרו ביד הקנה אתו עד שנת היובל ויצא ביבל ושב לאחזתו׃ ");
INSERT INTO heb_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","ואיש כי ימכר בית מושב עיר חומה והיתה גאלתו עד תם שנת ממכרו ימים תהיה גאלתו׃ ");
INSERT INTO heb_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","ואם לא יגאל עד מלאת לו שנה תמימה וקם הבית אשר בעיר אשר לא חמה לצמיתת לקנה אתו לדרתיו לא יצא ביבל׃ ");
INSERT INTO heb_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","ובתי החצרים אשר אין להם חמה סביב על שדה הארץ יחשב גאלה תהיה לו וביבל יצא׃ ");
INSERT INTO heb_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","וערי הלוים בתי ערי אחזתם גאלת עולם תהיה ללוים׃ ");
INSERT INTO heb_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","ואשר יגאל מן הלוים ויצא ממכר בית ועיר אחזתו ביבל כי בתי ערי הלוים הוא אחזתם בתוך בני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","ושדה מגרש עריהם לא ימכר כי אחזת עולם הוא להם׃ ");
INSERT INTO heb_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","וכי ימוך אחיך ומטה ידו עמך והחזקת בו גר ותושב וחי עמך׃ ");
INSERT INTO heb_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","אל תקח מאתו נשך ותרבית ויראת מאלהיך וחי אחיך עמך׃ ");
INSERT INTO heb_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","את כספך לא תתן לו בנשך ובמרבית לא תתן אכלך׃ ");
INSERT INTO heb_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","אני יהוה אלהיכם אשר הוצאתי אתכם מארץ מצרים לתת לכם את ארץ כנען להיות לכם לאלהים׃ ");
INSERT INTO heb_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","וכי ימוך אחיך עמך ונמכר לך לא תעבד בו עבדת עבד׃ ");
INSERT INTO heb_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","כשכיר כתושב יהיה עמך עד שנת היבל יעבד עמך׃ ");
INSERT INTO heb_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","ויצא מעמך הוא ובניו עמו ושב אל משפחתו ואל אחזת אבתיו ישוב׃ ");
INSERT INTO heb_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","כי עבדי הם אשר הוצאתי אתם מארץ מצרים לא ימכרו ממכרת עבד׃ ");
INSERT INTO heb_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","לא תרדה בו בפרך ויראת מאלהיך׃ ");
INSERT INTO heb_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","ועבדך ואמתך אשר יהיו לך מאת הגוים אשר סביבתיכם מהם תקנו עבד ואמה׃ ");
INSERT INTO heb_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","וגם מבני התושבים הגרים עמכם מהם תקנו וממשפחתם אשר עמכם אשר הולידו בארצכם והיו לכם לאחזה׃ ");
INSERT INTO heb_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","והתנחלתם אתם לבניכם אחריכם לרשת אחזה לעלם בהם תעבדו ובאחיכם בני ישראל איש באחיו לא תרדה בו בפרך׃ ");
INSERT INTO heb_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","וכי תשיג יד גר ותושב עמך ומך אחיך עמו ונמכר לגר תושב עמך או לעקר משפחת גר׃ ");
INSERT INTO heb_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","אחרי נמכר גאלה תהיה לו אחד מאחיו יגאלנו׃ ");
INSERT INTO heb_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","או דדו או בן דדו יגאלנו או משאר בשרו ממשפחתו יגאלנו או השיגה ידו ונגאל׃ ");
INSERT INTO heb_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","וחשב עם קנהו משנת המכרו לו עד שנת היבל והיה כסף ממכרו במספר שנים כימי שכיר יהיה עמו׃ ");
INSERT INTO heb_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","אם עוד רבות בשנים לפיהן ישיב גאלתו מכסף מקנתו׃ ");
INSERT INTO heb_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","ואם מעט נשאר בשנים עד שנת היבל וחשב לו כפי שניו ישיב את גאלתו׃ ");
INSERT INTO heb_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","כשכיר שנה בשנה יהיה עמו לא ירדנו בפרך לעיניך׃ ");
INSERT INTO heb_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","ואם לא יגאל באלה ויצא בשנת היבל הוא ובניו עמו׃ ");
INSERT INTO heb_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","כי לי בני ישראל עבדים עבדי הם אשר הוצאתי אותם מארץ מצרים אני יהוה אלהיכם׃ ");
INSERT INTO heb_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","לא תעשו לכם אלילם ופסל ומצבה לא תקימו לכם ואבן משכית לא תתנו בארצכם להשתחות עליה כי אני יהוה אלהיכם׃ ");
INSERT INTO heb_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","את שבתתי תשמרו ומקדשי תיראו אני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","אם בחקתי תלכו ואת מצותי תשמרו ועשיתם אתם׃ ");
INSERT INTO heb_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","ונתתי גשמיכם בעתם ונתנה הארץ יבולה ועץ השדה יתן פריו׃ ");
INSERT INTO heb_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","והשיג לכם דיש את בציר ובציר ישיג את זרע ואכלתם לחמכם לשבע וישבתם לבטח בארצכם׃ ");
INSERT INTO heb_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","ונתתי שלום בארץ ושכבתם ואין מחריד והשבתי חיה רעה מן הארץ וחרב לא תעבר בארצכם׃ ");
INSERT INTO heb_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","ורדפתם את איביכם ונפלו לפניכם לחרב׃ ");
INSERT INTO heb_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","ורדפו מכם חמשה מאה ומאה מכם רבבה ירדפו ונפלו איביכם לפניכם לחרב׃ ");
INSERT INTO heb_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","ופניתי אליכם והפריתי אתכם והרביתי אתכם והקימתי את בריתי אתכם׃ ");
INSERT INTO heb_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","ואכלתם ישן נושן וישן מפני חדש תוציאו׃ ");
INSERT INTO heb_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","ונתתי משכני בתוככם ולא תגעל נפשי אתכם׃ ");
INSERT INTO heb_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","והתהלכתי בתוככם והייתי לכם לאלהים ואתם תהיו לי לעם׃ ");
INSERT INTO heb_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","אני יהוה אלהיכם אשר הוצאתי אתכם מארץ מצרים מהית להם עבדים ואשבר מטת עלכם ואולך אתכם קוממיות׃ ");
INSERT INTO heb_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","ואם לא תשמעו לי ולא תעשו את כל המצות האלה׃ ");
INSERT INTO heb_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","ואם בחקתי תמאסו ואם את משפטי תגעל נפשכם לבלתי עשות את כל מצותי להפרכם את בריתי׃ ");
INSERT INTO heb_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","אף אני אעשה זאת לכם והפקדתי עליכם בהלה את השחפת ואת הקדחת מכלות עינים ומדיבת נפש וזרעתם לריק זרעכם ואכלהו איביכם׃ ");
INSERT INTO heb_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","ונתתי פני בכם ונגפתם לפני איביכם ורדו בכם שנאיכם ונסתם ואין רדף אתכם׃ ");
INSERT INTO heb_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","ואם עד אלה לא תשמעו לי ויספתי ליסרה אתכם שבע על חטאתיכם׃ ");
INSERT INTO heb_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","ושברתי את גאון עזכם ונתתי את שמיכם כברזל ואת ארצכם כנחשה׃ ");
INSERT INTO heb_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","ותם לריק כחכם ולא תתן ארצכם את יבולה ועץ הארץ לא יתן פריו׃ ");
INSERT INTO heb_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","ואם תלכו עמי קרי ולא תאבו לשמע לי ויספתי עליכם מכה שבע כחטאתיכם׃ ");
INSERT INTO heb_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","והשלחתי בכם את חית השדה ושכלה אתכם והכריתה את בהמתכם והמעיטה אתכם ונשמו דרכיכם׃ ");
INSERT INTO heb_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","ואם באלה לא תוסרו לי והלכתם עמי קרי׃ ");
INSERT INTO heb_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","והלכתי אף אני עמכם בקרי והכיתי אתכם גם אני שבע על חטאתיכם׃ ");
INSERT INTO heb_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","והבאתי עליכם חרב נקמת נקם ברית ונאספתם אל עריכם ושלחתי דבר בתוככם ונתתם ביד אויב׃ ");
INSERT INTO heb_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","בשברי לכם מטה לחם ואפו עשר נשים לחמכם בתנור אחד והשיבו לחמכם במשקל ואכלתם ולא תשבעו׃ ");
INSERT INTO heb_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","ואם בזאת לא תשמעו לי והלכתם עמי בקרי׃ ");
INSERT INTO heb_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","והלכתי עמכם בחמת קרי ויסרתי אתכם אף אני שבע על חטאתיכם׃ ");
INSERT INTO heb_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","ואכלתם בשר בניכם ובשר בנתיכם תאכלו׃ ");
INSERT INTO heb_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","והשמדתי את במתיכם והכרתי את חמניכם ונתתי את פגריכם על פגרי גלוליכם וגעלה נפשי אתכם׃ ");
INSERT INTO heb_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","ונתתי את עריכם חרבה והשמותי את מקדשיכם ולא אריח בריח ניחחכם׃ ");
INSERT INTO heb_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","והשמתי אני את הארץ ושממו עליה איביכם הישבים בה׃ ");
INSERT INTO heb_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","ואתכם אזרה בגוים והריקתי אחריכם חרב והיתה ארצכם שממה ועריכם יהיו חרבה׃ ");
INSERT INTO heb_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","אז תרצה הארץ את שבתתיה כל ימי השמה ואתם בארץ איביכם אז תשבת הארץ והרצת את שבתתיה׃ ");
INSERT INTO heb_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","כל ימי השמה תשבת את אשר לא שבתה בשבתתיכם בשבתכם עליה׃ ");
INSERT INTO heb_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","והנשארים בכם והבאתי מרך בלבבם בארצת איביהם ורדף אתם קול עלה נדף ונסו מנסת חרב ונפלו ואין רדף׃ ");
INSERT INTO heb_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","וכשלו איש באחיו כמפני חרב ורדף אין ולא תהיה לכם תקומה לפני איביכם׃ ");
INSERT INTO heb_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","ואבדתם בגוים ואכלה אתכם ארץ איביכם׃ ");
INSERT INTO heb_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","והנשארים בכם ימקו בעונם בארצת איביכם ואף בעונת אבתם אתם ימקו׃ ");
INSERT INTO heb_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","והתודו את עונם ואת עון אבתם במעלם אשר מעלו בי ואף אשר הלכו עמי בקרי׃ ");
INSERT INTO heb_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","אף אני אלך עמם בקרי והבאתי אתם בארץ איביהם או אז יכנע לבבם הערל ואז ירצו את עונם׃ ");
INSERT INTO heb_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","וזכרתי את בריתי יעקוב ואף את בריתי יצחק ואף את בריתי אברהם אזכר והארץ אזכר׃ ");
INSERT INTO heb_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","והארץ תעזב מהם ותרץ את שבתתיה בהשמה מהם והם ירצו את עונם יען וביען במשפטי מאסו ואת חקתי געלה נפשם׃ ");
INSERT INTO heb_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","ואף גם זאת בהיותם בארץ איביהם לא מאסתים ולא געלתים לכלתם להפר בריתי אתם כי אני יהוה אלהיהם׃ ");
INSERT INTO heb_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","וזכרתי להם ברית ראשנים אשר הוצאתי אתם מארץ מצרים לעיני הגוים להית להם לאלהים אני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","אלה החקים והמשפטים והתורת אשר נתן יהוה בינו ובין בני ישראל בהר סיני ביד משה׃ ");
INSERT INTO heb_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","דבר אל בני ישראל ואמרת אלהם איש כי יפלא נדר בערכך נפשת ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","והיה ערכך הזכר מבן עשרים שנה ועד בן ששים שנה והיה ערכך חמשים שקל כסף בשקל הקדש׃ ");
INSERT INTO heb_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","ואם נקבה הוא והיה ערכך שלשים שקל׃ ");
INSERT INTO heb_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","ואם מבן חמש שנים ועד בן עשרים שנה והיה ערכך הזכר עשרים שקלים ולנקבה עשרת שקלים׃ ");
INSERT INTO heb_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","ואם מבן חדש ועד בן חמש שנים והיה ערכך הזכר חמשה שקלים כסף ולנקבה ערכך שלשת שקלים כסף׃ ");
INSERT INTO heb_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","ואם מבן ששים שנה ומעלה אם זכר והיה ערכך חמשה עשר שקל ולנקבה עשרה שקלים׃ ");
INSERT INTO heb_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","ואם מך הוא מערכך והעמידו לפני הכהן והעריך אתו הכהן על פי אשר תשיג יד הנדר יעריכנו הכהן׃ ");
INSERT INTO heb_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","ואם בהמה אשר יקריבו ממנה קרבן ליהוה כל אשר יתן ממנו ליהוה יהיה קדש׃ ");
INSERT INTO heb_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","לא יחליפנו ולא ימיר אתו טוב ברע או רע בטוב ואם המר ימיר בהמה בבהמה והיה הוא ותמורתו יהיה קדש׃ ");
INSERT INTO heb_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","ואם כל בהמה טמאה אשר לא יקריבו ממנה קרבן ליהוה והעמיד את הבהמה לפני הכהן׃ ");
INSERT INTO heb_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","והעריך הכהן אתה בין טוב ובין רע כערכך הכהן כן יהיה׃ ");
INSERT INTO heb_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","ואם גאל יגאלנה ויסף חמישתו על ערכך׃ ");
INSERT INTO heb_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","ואיש כי יקדש את ביתו קדש ליהוה והעריכו הכהן בין טוב ובין רע כאשר יעריך אתו הכהן כן יקום׃ ");
INSERT INTO heb_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","ואם המקדיש יגאל את ביתו ויסף חמישית כסף ערכך עליו והיה לו׃ ");
INSERT INTO heb_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","ואם משדה אחזתו יקדיש איש ליהוה והיה ערכך לפי זרעו זרע חמר שערים בחמשים שקל כסף׃ ");
INSERT INTO heb_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","אם משנת היבל יקדיש שדהו כערכך יקום׃ ");
INSERT INTO heb_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","ואם אחר היבל יקדיש שדהו וחשב לו הכהן את הכסף על פי השנים הנותרת עד שנת היבל ונגרע מערכך׃ ");
INSERT INTO heb_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","ואם גאל יגאל את השדה המקדיש אתו ויסף חמשית כסף ערכך עליו וקם לו׃ ");
INSERT INTO heb_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","ואם לא יגאל את השדה ואם מכר את השדה לאיש אחר לא יגאל עוד׃ ");
INSERT INTO heb_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","והיה השדה בצאתו ביבל קדש ליהוה כשדה החרם לכהן תהיה אחזתו׃ ");
INSERT INTO heb_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","ואם את שדה מקנתו אשר לא משדה אחזתו יקדיש ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","וחשב לו הכהן את מכסת הערכך עד שנת היבל ונתן את הערכך ביום ההוא קדש ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","בשנת היובל ישוב השדה לאשר קנהו מאתו לאשר לו אחזת הארץ׃ ");
INSERT INTO heb_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","וכל ערכך יהיה בשקל הקדש עשרים גרה יהיה השקל׃ ");
INSERT INTO heb_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","אך בכור אשר יבכר ליהוה בבהמה לא יקדיש איש אתו אם שור אם שה ליהוה הוא׃ ");
INSERT INTO heb_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","ואם בבהמה הטמאה ופדה בערכך ויסף חמשתו עליו ואם לא יגאל ונמכר בערכך׃ ");
INSERT INTO heb_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","אך כל חרם אשר יחרם איש ליהוה מכל אשר לו מאדם ובהמה ומשדה אחזתו לא ימכר ולא יגאל כל חרם קדש קדשים הוא ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","כל חרם אשר יחרם מן האדם לא יפדה מות יומת׃ ");
INSERT INTO heb_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","וכל מעשר הארץ מזרע הארץ מפרי העץ ליהוה הוא קדש ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","ואם גאל יגאל איש ממעשרו חמשיתו יסף עליו׃ ");
INSERT INTO heb_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","וכל מעשר בקר וצאן כל אשר יעבר תחת השבט העשירי יהיה קדש ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","לא יבקר בין טוב לרע ולא ימירנו ואם המר ימירנו והיה הוא ותמורתו יהיה קדש לא יגאל׃ ");
INSERT INTO heb_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","אלה המצות אשר צוה יהוה את משה אל בני ישראל בהר סיני׃ ");
INSERT INTO heb_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","וידבר יהוה אל משה במדבר סיני באהל מועד באחד לחדש השני בשנה השנית לצאתם מארץ מצרים לאמר׃ ");
INSERT INTO heb_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","שאו את ראש כל עדת בני ישראל למשפחתם לבית אבתם במספר שמות כל זכר לגלגלתם׃ ");
INSERT INTO heb_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","מבן עשרים שנה ומעלה כל יצא צבא בישראל תפקדו אתם לצבאתם אתה ואהרן׃ ");
INSERT INTO heb_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","ואתכם יהיו איש איש למטה איש ראש לבית אבתיו הוא׃ ");
INSERT INTO heb_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","ואלה שמות האנשים אשר יעמדו אתכם לראובן אליצור בן שדיאור׃ ");
INSERT INTO heb_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","לשמעון שלמיאל בן צורישדי׃ ");
INSERT INTO heb_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","ליהודה נחשון בן עמינדב׃ ");
INSERT INTO heb_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","ליששכר נתנאל בן צוער׃ ");
INSERT INTO heb_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","לזבולן אליאב בן חלן׃ ");
INSERT INTO heb_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","לבני יוסף לאפרים אלישמע בן עמיהוד למנשה גמליאל בן פדהצור׃ ");
INSERT INTO heb_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","לבנימן אבידן בן גדעני׃ ");
INSERT INTO heb_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","לדן אחיעזר בן עמישדי׃ ");
INSERT INTO heb_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","לאשר פגעיאל בן עכרן׃ ");
INSERT INTO heb_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","לגד אליסף בן דעואל׃ ");
INSERT INTO heb_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","לנפתלי אחירע בן עינן׃ ");
INSERT INTO heb_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","אלה קריאי העדה נשיאי מטות אבותם ראשי אלפי ישראל הם׃ ");
INSERT INTO heb_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","ויקח משה ואהרן את האנשים האלה אשר נקבו בשמות׃ ");
INSERT INTO heb_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","ואת כל העדה הקהילו באחד לחדש השני ויתילדו על משפחתם לבית אבתם במספר שמות מבן עשרים שנה ומעלה לגלגלתם׃ ");
INSERT INTO heb_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","כאשר צוה יהוה את משה ויפקדם במדבר סיני׃ ");
INSERT INTO heb_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","ויהיו בני ראובן בכר ישראל תולדתם למשפחתם לבית אבתם במספר שמות לגלגלתם כל זכר מבן עשרים שנה ומעלה כל יצא צבא׃ ");
INSERT INTO heb_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","פקדיהם למטה ראובן ששה וארבעים אלף וחמש מאות׃ ");
INSERT INTO heb_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","לבני שמעון תולדתם למשפחתם לבית אבתם פקדיו במספר שמות לגלגלתם כל זכר מבן עשרים שנה ומעלה כל יצא צבא׃ ");
INSERT INTO heb_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","פקדיהם למטה שמעון תשעה וחמשים אלף ושלש מאות׃ ");
INSERT INTO heb_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","לבני גד תולדתם למשפחתם לבית אבתם במספר שמות מבן עשרים שנה ומעלה כל יצא צבא׃ ");
INSERT INTO heb_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","פקדיהם למטה גד חמשה וארבעים אלף ושש מאות וחמשים׃ ");
INSERT INTO heb_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","לבני יהודה תולדתם למשפחתם לבית אבתם במספר שמת מבן עשרים שנה ומעלה כל יצא צבא׃ ");
INSERT INTO heb_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","פקדיהם למטה יהודה ארבעה ושבעים אלף ושש מאות׃ ");
INSERT INTO heb_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","לבני יששכר תולדתם למשפחתם לבית אבתם במספר שמת מבן עשרים שנה ומעלה כל יצא צבא׃ ");
INSERT INTO heb_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","פקדיהם למטה יששכר ארבעה וחמשים אלף וארבע מאות׃ ");
INSERT INTO heb_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","לבני זבולן תולדתם למשפחתם לבית אבתם במספר שמת מבן עשרים שנה ומעלה כל יצא צבא׃ ");
INSERT INTO heb_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","פקדיהם למטה זבולן שבעה וחמשים אלף וארבע מאות׃ ");
INSERT INTO heb_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","לבני יוסף לבני אפרים תולדתם למשפחתם לבית אבתם במספר שמת מבן עשרים שנה ומעלה כל יצא צבא׃ ");
INSERT INTO heb_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","פקדיהם למטה אפרים ארבעים אלף וחמש מאות׃ ");
INSERT INTO heb_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","לבני מנשה תולדתם למשפחתם לבית אבתם במספר שמות מבן עשרים שנה ומעלה כל יצא צבא׃ ");
INSERT INTO heb_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","פקדיהם למטה מנשה שנים ושלשים אלף ומאתים׃ ");
INSERT INTO heb_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","לבני בנימן תולדתם למשפחתם לבית אבתם במספר שמת מבן עשרים שנה ומעלה כל יצא צבא׃ ");
INSERT INTO heb_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","פקדיהם למטה בנימן חמשה ושלשים אלף וארבע מאות׃ ");
INSERT INTO heb_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","לבני דן תולדתם למשפחתם לבית אבתם במספר שמת מבן עשרים שנה ומעלה כל יצא צבא׃ ");
INSERT INTO heb_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","פקדיהם למטה דן שנים וששים אלף ושבע מאות׃ ");
INSERT INTO heb_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","לבני אשר תולדתם למשפחתם לבית אבתם במספר שמת מבן עשרים שנה ומעלה כל יצא צבא׃ ");
INSERT INTO heb_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","פקדיהם למטה אשר אחד וארבעים אלף וחמש מאות׃ ");
INSERT INTO heb_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","בני נפתלי תולדתם למשפחתם לבית אבתם במספר שמת מבן עשרים שנה ומעלה כל יצא צבא׃ ");
INSERT INTO heb_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","פקדיהם למטה נפתלי שלשה וחמשים אלף וארבע מאות׃ ");
INSERT INTO heb_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","אלה הפקדים אשר פקד משה ואהרן ונשיאי ישראל שנים עשר איש איש אחד לבית אבתיו היו׃ ");
INSERT INTO heb_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","ויהיו כל פקודי בני ישראל לבית אבתם מבן עשרים שנה ומעלה כל יצא צבא בישראל׃ ");
INSERT INTO heb_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","ויהיו כל הפקדים שש מאות אלף ושלשת אלפים וחמש מאות וחמשים׃ ");
INSERT INTO heb_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","והלוים למטה אבתם לא התפקדו בתוכם׃ ");
INSERT INTO heb_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","אך את מטה לוי לא תפקד ואת ראשם לא תשא בתוך בני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","ואתה הפקד את הלוים על משכן העדת ועל כל כליו ועל כל אשר לו המה ישאו את המשכן ואת כל כליו והם ישרתהו וסביב למשכן יחנו׃ ");
INSERT INTO heb_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","ובנסע המשכן יורידו אתו הלוים ובחנת המשכן יקימו אתו הלוים והזר הקרב יומת׃ ");
INSERT INTO heb_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","וחנו בני ישראל איש על מחנהו ואיש על דגלו לצבאתם׃ ");
INSERT INTO heb_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","והלוים יחנו סביב למשכן העדת ולא יהיה קצף על עדת בני ישראל ושמרו הלוים את משמרת משכן העדות׃ ");
INSERT INTO heb_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","ויעשו בני ישראל ככל אשר צוה יהוה את משה כן עשו׃ ");
INSERT INTO heb_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","וידבר יהוה אל משה ואל אהרן לאמר׃ ");
INSERT INTO heb_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","איש על דגלו באתת לבית אבתם יחנו בני ישראל מנגד סביב לאהל מועד יחנו׃ ");
INSERT INTO heb_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","והחנים קדמה מזרחה דגל מחנה יהודה לצבאתם ונשיא לבני יהודה נחשון בן עמינדב׃ ");
INSERT INTO heb_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","וצבאו ופקדיהם ארבעה ושבעים אלף ושש מאות׃ ");
INSERT INTO heb_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","והחנים עליו מטה יששכר ונשיא לבני יששכר נתנאל בן צוער׃ ");
INSERT INTO heb_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","וצבאו ופקדיו ארבעה וחמשים אלף וארבע מאות׃ ");
INSERT INTO heb_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","מטה זבולן ונשיא לבני זבולן אליאב בן חלן׃ ");
INSERT INTO heb_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","וצבאו ופקדיו שבעה וחמשים אלף וארבע מאות׃ ");
INSERT INTO heb_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","כל הפקדים למחנה יהודה מאת אלף ושמנים אלף וששת אלפים וארבע מאות לצבאתם ראשנה יסעו׃ ");
INSERT INTO heb_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","דגל מחנה ראובן תימנה לצבאתם ונשיא לבני ראובן אליצור בן שדיאור׃ ");
INSERT INTO heb_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","וצבאו ופקדיו ששה וארבעים אלף וחמש מאות׃ ");
INSERT INTO heb_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","והחונם עליו מטה שמעון ונשיא לבני שמעון שלמיאל בן צורי שדי׃ ");
INSERT INTO heb_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","וצבאו ופקדיהם תשעה וחמשים אלף ושלש מאות׃ ");
INSERT INTO heb_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","ומטה גד ונשיא לבני גד אליסף בן דעואל׃ ");
INSERT INTO heb_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","וצבאו ופקדיהם חמשה וארבעים אלף ושש מאות וחמשים׃ ");
INSERT INTO heb_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","כל הפקדים למחנה ראובן מאת אלף ואחד וחמשים אלף וארבע מאות וחמשים לצבאתם ושנים יסעו׃ ");
INSERT INTO heb_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","ונסע אהל מועד מחנה הלוים בתוך המחנת כאשר יחנו כן יסעו איש על ידו לדגליהם׃ ");
INSERT INTO heb_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","דגל מחנה אפרים לצבאתם ימה ונשיא לבני אפרים אלישמע בן עמיהוד׃ ");
INSERT INTO heb_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","וצבאו ופקדיהם ארבעים אלף וחמש מאות׃ ");
INSERT INTO heb_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","ועליו מטה מנשה ונשיא לבני מנשה גמליאל בן פדהצור׃ ");
INSERT INTO heb_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","וצבאו ופקדיהם שנים ושלשים אלף ומאתים׃ ");
INSERT INTO heb_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","ומטה בנימן ונשיא לבני בנימן אבידן בן גדעני׃ ");
INSERT INTO heb_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","וצבאו ופקדיהם חמשה ושלשים אלף וארבע מאות׃ ");
INSERT INTO heb_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","כל הפקדים למחנה אפרים מאת אלף ושמנת אלפים ומאה לצבאתם ושלשים יסעו׃ ");
INSERT INTO heb_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","דגל מחנה דן צפנה לצבאתם ונשיא לבני דן אחיעזר בן עמישדי׃ ");
INSERT INTO heb_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","וצבאו ופקדיהם שנים וששים אלף ושבע מאות׃ ");
INSERT INTO heb_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","והחנים עליו מטה אשר ונשיא לבני אשר פגעיאל בן עכרן׃ ");
INSERT INTO heb_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","וצבאו ופקדיהם אחד וארבעים אלף וחמש מאות׃ ");
INSERT INTO heb_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","ומטה נפתלי ונשיא לבני נפתלי אחירע בן עינן׃ ");
INSERT INTO heb_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","וצבאו ופקדיהם שלשה וחמשים אלף וארבע מאות׃ ");
INSERT INTO heb_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","כל הפקדים למחנה דן מאת אלף ושבעה וחמשים אלף ושש מאות לאחרנה יסעו לדגליהם׃ ");
INSERT INTO heb_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","אלה פקודי בני ישראל לבית אבתם כל פקודי המחנת לצבאתם שש מאות אלף ושלשת אלפים וחמש מאות וחמשים׃ ");
INSERT INTO heb_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","והלוים לא התפקדו בתוך בני ישראל כאשר צוה יהוה את משה׃ ");
INSERT INTO heb_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","ויעשו בני ישראל ככל אשר צוה יהוה את משה כן חנו לדגליהם וכן נסעו איש למשפחתיו על בית אבתיו׃ ");
INSERT INTO heb_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","ואלה תולדת אהרן ומשה ביום דבר יהוה את משה בהר סיני׃ ");
INSERT INTO heb_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","ואלה שמות בני אהרן הבכור נדב ואביהוא אלעזר ואיתמר׃ ");
INSERT INTO heb_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","אלה שמות בני אהרן הכהנים המשחים אשר מלא ידם לכהן׃ ");
INSERT INTO heb_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","וימת נדב ואביהוא לפני יהוה בהקרבם אש זרה לפני יהוה במדבר סיני ובנים לא היו להם ויכהן אלעזר ואיתמר על פני אהרן אביהם׃ ");
INSERT INTO heb_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","הקרב את מטה לוי והעמדת אתו לפני אהרן הכהן ושרתו אתו׃ ");
INSERT INTO heb_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","ושמרו את משמרתו ואת משמרת כל העדה לפני אהל מועד לעבד את עבדת המשכן׃ ");
INSERT INTO heb_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","ושמרו את כל כלי אהל מועד ואת משמרת בני ישראל לעבד את עבדת המשכן׃ ");
INSERT INTO heb_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","ונתתה את הלוים לאהרן ולבניו נתונם נתונם המה לו מאת בני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","ואת אהרן ואת בניו תפקד ושמרו את כהנתם והזר הקרב יומת׃ ");
INSERT INTO heb_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","ואני הנה לקחתי את הלוים מתוך בני ישראל תחת כל בכור פטר רחם מבני ישראל והיו לי הלוים׃ ");
INSERT INTO heb_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","כי לי כל בכור ביום הכתי כל בכור בארץ מצרים הקדשתי לי כל בכור בישראל מאדם עד בהמה לי יהיו אני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","וידבר יהוה אל משה במדבר סיני לאמר׃ ");
INSERT INTO heb_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","פקד את בני לוי לבית אבתם למשפחתם כל זכר מבן חדש ומעלה תפקדם׃ ");
INSERT INTO heb_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","ויפקד אתם משה על פי יהוה כאשר צוה׃ ");
INSERT INTO heb_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","ויהיו אלה בני לוי בשמתם גרשון וקהת ומררי׃ ");
INSERT INTO heb_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","ואלה שמות בני גרשון למשפחתם לבני ושמעי׃ ");
INSERT INTO heb_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","ובני קהת למשפחתם עמרם ויצהר חברון ועזיאל׃ ");
INSERT INTO heb_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","ובני מררי למשפחתם מחלי ומושי אלה הם משפחת הלוי לבית אבתם׃ ");
INSERT INTO heb_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","לגרשון משפחת הלבני ומשפחת השמעי אלה הם משפחת הגרשני׃ ");
INSERT INTO heb_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","פקדיהם במספר כל זכר מבן חדש ומעלה פקדיהם שבעת אלפים וחמש מאות׃ ");
INSERT INTO heb_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","משפחת הגרשני אחרי המשכן יחנו ימה׃ ");
INSERT INTO heb_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","ונשיא בית אב לגרשני אליסף בן לאל׃ ");
INSERT INTO heb_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","ומשמרת בני גרשון באהל מועד המשכן והאהל מכסהו ומסך פתח אהל מועד׃ ");
INSERT INTO heb_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","וקלעי החצר ואת מסך פתח החצר אשר על המשכן ועל המזבח סביב ואת מיתריו לכל עבדתו׃ ");
INSERT INTO heb_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","ולקהת משפחת העמרמי ומשפחת היצהרי ומשפחת החברני ומשפחת העזיאלי אלה הם משפחת הקהתי׃ ");
INSERT INTO heb_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","במספר כל זכר מבן חדש ומעלה שמנת אלפים ושש מאות שמרי משמרת הקדש׃ ");
INSERT INTO heb_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","משפחת בני קהת יחנו על ירך המשכן תימנה׃ ");
INSERT INTO heb_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","ונשיא בית אב למשפחת הקהתי אליצפן בן עזיאל׃ ");
INSERT INTO heb_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","ומשמרתם הארן והשלחן והמנרה והמזבחת וכלי הקדש אשר ישרתו בהם והמסך וכל עבדתו׃ ");
INSERT INTO heb_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","ונשיא נשיאי הלוי אלעזר בן אהרן הכהן פקדת שמרי משמרת הקדש׃ ");
INSERT INTO heb_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","למררי משפחת המחלי ומשפחת המושי אלה הם משפחת מררי׃ ");
INSERT INTO heb_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","ופקדיהם במספר כל זכר מבן חדש ומעלה ששת אלפים ומאתים׃ ");
INSERT INTO heb_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","ונשיא בית אב למשפחת מררי צוריאל בן אביחיל על ירך המשכן יחנו צפנה׃ ");
INSERT INTO heb_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","ופקדת משמרת בני מררי קרשי המשכן ובריחיו ועמדיו ואדניו וכל כליו וכל עבדתו׃ ");
INSERT INTO heb_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","ועמדי החצר סביב ואדניהם ויתדתם ומיתריהם׃ ");
INSERT INTO heb_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","והחנים לפני המשכן קדמה לפני אהל מועד מזרחה משה ואהרן ובניו שמרים משמרת המקדש למשמרת בני ישראל והזר הקרב יומת׃ ");
INSERT INTO heb_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","כל פקודי הלוים אשר פקד משה ואהרן על פי יהוה למשפחתם כל זכר מבן חדש ומעלה שנים ועשרים אלף׃ ");
INSERT INTO heb_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","ויאמר יהוה אל משה פקד כל בכר זכר לבני ישראל מבן חדש ומעלה ושא את מספר שמתם׃ ");
INSERT INTO heb_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","ולקחת את הלוים לי אני יהוה תחת כל בכר בבני ישראל ואת בהמת הלוים תחת כל בכור בבהמת בני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","ויפקד משה כאשר צוה יהוה אתו את כל בכר בבני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","ויהי כל בכור זכר במספר שמות מבן חדש ומעלה לפקדיהם שנים ועשרים אלף שלשה ושבעים ומאתים׃ ");
INSERT INTO heb_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","קח את הלוים תחת כל בכור בבני ישראל ואת בהמת הלוים תחת בהמתם והיו לי הלוים אני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","ואת פדויי השלשה והשבעים והמאתים העדפים על הלוים מבכור בני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","ולקחת חמשת חמשת שקלים לגלגלת בשקל הקדש תקח עשרים גרה השקל׃ ");
INSERT INTO heb_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","ונתתה הכסף לאהרן ולבניו פדויי העדפים בהם׃ ");
INSERT INTO heb_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","ויקח משה את כסף הפדיום מאת העדפים על פדויי הלוים׃ ");
INSERT INTO heb_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","מאת בכור בני ישראל לקח את הכסף חמשה וששים ושלש מאות ואלף בשקל הקדש׃ ");
INSERT INTO heb_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","ויתן משה את כסף הפדים לאהרן ולבניו על פי יהוה כאשר צוה יהוה את משה׃ ");
INSERT INTO heb_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","וידבר יהוה אל משה ואל אהרן לאמר׃ ");
INSERT INTO heb_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","נשא את ראש בני קהת מתוך בני לוי למשפחתם לבית אבתם׃ ");
INSERT INTO heb_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","מבן שלשים שנה ומעלה ועד בן חמשים שנה כל בא לצבא לעשות מלאכה באהל מועד׃ ");
INSERT INTO heb_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","זאת עבדת בני קהת באהל מועד קדש הקדשים׃ ");
INSERT INTO heb_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","ובא אהרן ובניו בנסע המחנה והורדו את פרכת המסך וכסו בה את ארן העדת׃ ");
INSERT INTO heb_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","ונתנו עליו כסוי עור תחש ופרשו בגד כליל תכלת מלמעלה ושמו בדיו׃ ");
INSERT INTO heb_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","ועל שלחן הפנים יפרשו בגד תכלת ונתנו עליו את הקערת ואת הכפת ואת המנקית ואת קשות הנסך ולחם התמיד עליו יהיה׃ ");
INSERT INTO heb_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","ופרשו עליהם בגד תולעת שני וכסו אתו במכסה עור תחש ושמו את בדיו׃ ");
INSERT INTO heb_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","ולקחו בגד תכלת וכסו את מנרת המאור ואת נרתיה ואת מלקחיה ואת מחתתיה ואת כל כלי שמנה אשר ישרתו לה בהם׃ ");
INSERT INTO heb_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","ונתנו אתה ואת כל כליה אל מכסה עור תחש ונתנו על המוט׃ ");
INSERT INTO heb_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","ועל מזבח הזהב יפרשו בגד תכלת וכסו אתו במכסה עור תחש ושמו את בדיו׃ ");
INSERT INTO heb_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","ולקחו את כל כלי השרת אשר ישרתו בם בקדש ונתנו אל בגד תכלת וכסו אותם במכסה עור תחש ונתנו על המוט׃ ");
INSERT INTO heb_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","ודשנו את המזבח ופרשו עליו בגד ארגמן׃ ");
INSERT INTO heb_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","ונתנו עליו את כל כליו אשר ישרתו עליו בהם את המחתת את המזלגת ואת היעים ואת המזרקת כל כלי המזבח ופרשו עליו כסוי עור תחש ושמו בדיו׃ ");
INSERT INTO heb_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","וכלה אהרן ובניו לכסת את הקדש ואת כל כלי הקדש בנסע המחנה ואחרי כן יבאו בני קהת לשאת ולא יגעו אל הקדש ומתו אלה משא בני קהת באהל מועד׃ ");
INSERT INTO heb_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","ופקדת אלעזר בן אהרן הכהן שמן המאור וקטרת הסמים ומנחת התמיד ושמן המשחה פקדת כל המשכן וכל אשר בו בקדש ובכליו׃ ");
INSERT INTO heb_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","וידבר יהוה אל משה ואל אהרן לאמר׃ ");
INSERT INTO heb_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","אל תכריתו את שבט משפחת הקהתי מתוך הלוים׃ ");
INSERT INTO heb_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","וזאת עשו להם וחיו ולא ימתו בגשתם את קדש הקדשים אהרן ובניו יבאו ושמו אותם איש איש על עבדתו ואל משאו׃ ");
INSERT INTO heb_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","ולא יבאו לראות כבלע את הקדש ומתו׃ ");
INSERT INTO heb_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","נשא את ראש בני גרשון גם הם לבית אבתם למשפחתם׃ ");
INSERT INTO heb_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","מבן שלשים שנה ומעלה עד בן חמשים שנה תפקד אותם כל הבא לצבא צבא לעבד עבדה באהל מועד׃ ");
INSERT INTO heb_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","זאת עבדת משפחת הגרשני לעבד ולמשא׃ ");
INSERT INTO heb_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","ונשאו את יריעת המשכן ואת אהל מועד מכסהו ומכסה התחש אשר עליו מלמעלה ואת מסך פתח אהל מועד׃ ");
INSERT INTO heb_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","ואת קלעי החצר ואת מסך פתח שער החצר אשר על המשכן ועל המזבח סביב ואת מיתריהם ואת כל כלי עבדתם ואת כל אשר יעשה להם ועבדו׃ ");
INSERT INTO heb_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","על פי אהרן ובניו תהיה כל עבדת בני הגרשני לכל משאם ולכל עבדתם ופקדתם עלהם במשמרת את כל משאם׃ ");
INSERT INTO heb_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","זאת עבדת משפחת בני הגרשני באהל מועד ומשמרתם ביד איתמר בן אהרן הכהן׃ ");
INSERT INTO heb_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","בני מררי למשפחתם לבית אבתם תפקד אתם׃ ");
INSERT INTO heb_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","מבן שלשים שנה ומעלה ועד בן חמשים שנה תפקדם כל הבא לצבא לעבד את עבדת אהל מועד׃ ");
INSERT INTO heb_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","וזאת משמרת משאם לכל עבדתם באהל מועד קרשי המשכן ובריחיו ועמודיו ואדניו׃ ");
INSERT INTO heb_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","ועמודי החצר סביב ואדניהם ויתדתם ומיתריהם לכל כליהם ולכל עבדתם ובשמת תפקדו את כלי משמרת משאם׃ ");
INSERT INTO heb_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","זאת עבדת משפחת בני מררי לכל עבדתם באהל מועד ביד איתמר בן אהרן הכהן׃ ");
INSERT INTO heb_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","ויפקד משה ואהרן ונשיאי העדה את בני הקהתי למשפחתם ולבית אבתם׃ ");
INSERT INTO heb_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","מבן שלשים שנה ומעלה ועד בן חמשים שנה כל הבא לצבא לעבדה באהל מועד׃ ");
INSERT INTO heb_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","ויהיו פקדיהם למשפחתם אלפים שבע מאות וחמשים׃ ");
INSERT INTO heb_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","אלה פקודי משפחת הקהתי כל העבד באהל מועד אשר פקד משה ואהרן על פי יהוה ביד משה׃ ");
INSERT INTO heb_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","ופקודי בני גרשון למשפחותם ולבית אבתם׃ ");
INSERT INTO heb_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","מבן שלשים שנה ומעלה ועד בן חמשים שנה כל הבא לצבא לעבדה באהל מועד׃ ");
INSERT INTO heb_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","ויהיו פקדיהם למשפחתם לבית אבתם אלפים ושש מאות ושלשים׃ ");
INSERT INTO heb_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","אלה פקודי משפחת בני גרשון כל העבד באהל מועד אשר פקד משה ואהרן על פי יהוה׃ ");
INSERT INTO heb_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","ופקודי משפחת בני מררי למשפחתם לבית אבתם׃ ");
INSERT INTO heb_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","מבן שלשים שנה ומעלה ועד בן חמשים שנה כל הבא לצבא לעבדה באהל מועד׃ ");
INSERT INTO heb_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","ויהיו פקדיהם למשפחתם שלשת אלפים ומאתים׃ ");
INSERT INTO heb_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","אלה פקודי משפחת בני מררי אשר פקד משה ואהרן על פי יהוה ביד משה׃ ");
INSERT INTO heb_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","כל הפקדים אשר פקד משה ואהרן ונשיאי ישראל את הלוים למשפחתם ולבית אבתם׃ ");
INSERT INTO heb_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","מבן שלשים שנה ומעלה ועד בן חמשים שנה כל הבא לעבד עבדת עבדה ועבדת משא באהל מועד׃ ");
INSERT INTO heb_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","ויהיו פקדיהם שמנת אלפים וחמש מאות ושמנים׃ ");
INSERT INTO heb_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","על פי יהוה פקד אותם ביד משה איש איש על עבדתו ועל משאו ופקדיו אשר צוה יהוה את משה׃ ");
INSERT INTO heb_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","צו את בני ישראל וישלחו מן המחנה כל צרוע וכל זב וכל טמא לנפש׃ ");
INSERT INTO heb_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","מזכר עד נקבה תשלחו אל מחוץ למחנה תשלחום ולא יטמאו את מחניהם אשר אני שכן בתוכם׃ ");
INSERT INTO heb_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","ויעשו כן בני ישראל וישלחו אותם אל מחוץ למחנה כאשר דבר יהוה אל משה כן עשו בני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","דבר אל בני ישראל איש או אשה כי יעשו מכל חטאת האדם למעל מעל ביהוה ואשמה הנפש ההוא׃ ");
INSERT INTO heb_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","והתודו את חטאתם אשר עשו והשיב את אשמו בראשו וחמישתו יסף עליו ונתן לאשר אשם לו׃ ");
INSERT INTO heb_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","ואם אין לאיש גאל להשיב האשם אליו האשם המושב ליהוה לכהן מלבד איל הכפרים אשר יכפר בו עליו׃ ");
INSERT INTO heb_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","וכל תרומה לכל קדשי בני ישראל אשר יקריבו לכהן לו יהיה׃ ");
INSERT INTO heb_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","ואיש את קדשיו לו יהיו איש אשר יתן לכהן לו יהיה׃ ");
INSERT INTO heb_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","דבר אל בני ישראל ואמרת אלהם איש איש כי תשטה אשתו ומעלה בו מעל׃ ");
INSERT INTO heb_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","ושכב איש אתה שכבת זרע ונעלם מעיני אישה ונסתרה והיא נטמאה ועד אין בה והוא לא נתפשה׃ ");
INSERT INTO heb_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","ועבר עליו רוח קנאה וקנא את אשתו והוא נטמאה או עבר עליו רוח קנאה וקנא את אשתו והיא לא נטמאה׃ ");
INSERT INTO heb_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","והביא האיש את אשתו אל הכהן והביא את קרבנה עליה עשירת האיפה קמח שערים לא יצק עליו שמן ולא יתן עליו לבנה כי מנחת קנאת הוא מנחת זכרון מזכרת עון׃ ");
INSERT INTO heb_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","והקריב אתה הכהן והעמדה לפני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","ולקח הכהן מים קדשים בכלי חרש ומן העפר אשר יהיה בקרקע המשכן יקח הכהן ונתן אל המים׃ ");
INSERT INTO heb_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","והעמיד הכהן את האשה לפני יהוה ופרע את ראש האשה ונתן על כפיה את מנחת הזכרון מנחת קנאת הוא וביד הכהן יהיו מי המרים המאררים׃ ");
INSERT INTO heb_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","והשביע אתה הכהן ואמר אל האשה אם לא שכב איש אתך ואם לא שטית טמאה תחת אישך הנקי ממי המרים המאררים האלה׃ ");
INSERT INTO heb_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","ואת כי שטית תחת אישך וכי נטמאת ויתן איש בך את שכבתו מבלעדי אישך׃ ");
INSERT INTO heb_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","והשביע הכהן את האשה בשבעת האלה ואמר הכהן לאשה יתן יהוה אותך לאלה ולשבעה בתוך עמך בתת יהוה את ירכך נפלת ואת בטנך צבה׃ ");
INSERT INTO heb_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","ובאו המים המאררים האלה במעיך לצבות בטן ולנפל ירך ואמרה האשה אמן אמן׃ ");
INSERT INTO heb_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","וכתב את האלת האלה הכהן בספר ומחה אל מי המרים׃ ");
INSERT INTO heb_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","והשקה את האשה את מי המרים המאררים ובאו בה המים המאררים למרים׃ ");
INSERT INTO heb_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","ולקח הכהן מיד האשה את מנחת הקנאת והניף את המנחה לפני יהוה והקריב אתה אל המזבח׃ ");
INSERT INTO heb_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","וקמץ הכהן מן המנחה את אזכרתה והקטיר המזבחה ואחר ישקה את האשה את המים׃ ");
INSERT INTO heb_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","והשקה את המים והיתה אם נטמאה ותמעל מעל באישה ובאו בה המים המאררים למרים וצבתה בטנה ונפלה ירכה והיתה האשה לאלה בקרב עמה׃ ");
INSERT INTO heb_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","ואם לא נטמאה האשה וטהרה הוא ונקתה ונזרעה זרע׃ ");
INSERT INTO heb_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","זאת תורת הקנאת אשר תשטה אשה תחת אישה ונטמאה׃ ");
INSERT INTO heb_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","או איש אשר תעבר עליו רוח קנאה וקנא את אשתו והעמיד את האשה לפני יהוה ועשה לה הכהן את כל התורה הזאת׃ ");
INSERT INTO heb_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","ונקה האיש מעון והאשה ההוא תשא את עונה׃ ");
INSERT INTO heb_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","דבר אל בני ישראל ואמרת אלהם איש או אשה כי יפלא לנדר נדר נזיר להזיר ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","מיין ושכר יזיר חמץ יין וחמץ שכר לא ישתה וכל משרת ענבים לא ישתה וענבים לחים ויבשים לא יאכל׃ ");
INSERT INTO heb_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","כל ימי נזרו מכל אשר יעשה מגפן היין מחרצנים ועד זג לא יאכל׃ ");
INSERT INTO heb_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","כל ימי נדר נזרו תער לא יעבר על ראשו עד מלאת הימם אשר יזיר ליהוה קדש יהיה גדל פרע שער ראשו׃ ");
INSERT INTO heb_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","כל ימי הזירו ליהוה על נפש מת לא יבא׃ ");
INSERT INTO heb_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","לאביו ולאמו לאחיו ולאחתו לא יטמא להם במתם כי נזר אלהיו על ראשו׃ ");
INSERT INTO heb_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","כל ימי נזרו קדש הוא ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","וכי ימות מת עליו בפתע פתאם וטמא ראש נזרו וגלח ראשו ביום טהרתו ביום השביעי יגלחנו׃ ");
INSERT INTO heb_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","וביום השמיני יבא שתי תרים או שני בני יונה אל הכהן אל פתח אהל מועד׃ ");
INSERT INTO heb_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","ועשה הכהן אחד לחטאת ואחד לעלה וכפר עליו מאשר חטא על הנפש וקדש את ראשו ביום ההוא׃ ");
INSERT INTO heb_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","והזיר ליהוה את ימי נזרו והביא כבש בן שנתו לאשם והימים הראשנים יפלו כי טמא נזרו׃ ");
INSERT INTO heb_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","וזאת תורת הנזיר ביום מלאת ימי נזרו יביא אתו אל פתח אהל מועד׃ ");
INSERT INTO heb_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","והקריב את קרבנו ליהוה כבש בן שנתו תמים אחד לעלה וכבשה אחת בת שנתה תמימה לחטאת ואיל אחד תמים לשלמים׃ ");
INSERT INTO heb_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","וסל מצות סלת חלת בלולת בשמן ורקיקי מצות משחים בשמן ומנחתם ונסכיהם׃ ");
INSERT INTO heb_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","והקריב הכהן לפני יהוה ועשה את חטאתו ואת עלתו׃ ");
INSERT INTO heb_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","ואת האיל יעשה זבח שלמים ליהוה על סל המצות ועשה הכהן את מנחתו ואת נסכו׃ ");
INSERT INTO heb_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","וגלח הנזיר פתח אהל מועד את ראש נזרו ולקח את שער ראש נזרו ונתן על האש אשר תחת זבח השלמים׃ ");
INSERT INTO heb_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","ולקח הכהן את הזרע בשלה מן האיל וחלת מצה אחת מן הסל ורקיק מצה אחד ונתן על כפי הנזיר אחר התגלחו את נזרו׃ ");
INSERT INTO heb_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","והניף אותם הכהן תנופה לפני יהוה קדש הוא לכהן על חזה התנופה ועל שוק התרומה ואחר ישתה הנזיר יין׃ ");
INSERT INTO heb_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","זאת תורת הנזיר אשר ידר קרבנו ליהוה על נזרו מלבד אשר תשיג ידו כפי נדרו אשר ידר כן יעשה על תורת נזרו׃ ");
INSERT INTO heb_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","דבר אל אהרן ואל בניו לאמר כה תברכו את בני ישראל אמור להם׃ ");
INSERT INTO heb_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","יברכך יהוה וישמרך׃ ");
INSERT INTO heb_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","יאר יהוה פניו אליך ויחנך׃ ");
INSERT INTO heb_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","ישא יהוה פניו אליך וישם לך שלום׃ ");
INSERT INTO heb_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","ושמו את שמי על בני ישראל ואני אברכם׃ ");
INSERT INTO heb_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","ויהי ביום כלות משה להקים את המשכן וימשח אתו ויקדש אתו ואת כל כליו ואת המזבח ואת כל כליו וימשחם ויקדש אתם׃ ");
INSERT INTO heb_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","ויקריבו נשיאי ישראל ראשי בית אבתם הם נשיאי המטת הם העמדים על הפקדים׃ ");
INSERT INTO heb_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","ויביאו את קרבנם לפני יהוה שש עגלת צב ושני עשר בקר עגלה על שני הנשאים ושור לאחד ויקריבו אותם לפני המשכן׃ ");
INSERT INTO heb_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","ויאמר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","קח מאתם והיו לעבד את עבדת אהל מועד ונתתה אותם אל הלוים איש כפי עבדתו׃ ");
INSERT INTO heb_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","ויקח משה את העגלת ואת הבקר ויתן אותם אל הלוים׃ ");
INSERT INTO heb_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","את שתי העגלת ואת ארבעת הבקר נתן לבני גרשון כפי עבדתם׃ ");
INSERT INTO heb_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","ואת ארבע העגלת ואת שמנת הבקר נתן לבני מררי כפי עבדתם ביד איתמר בן אהרן הכהן׃ ");
INSERT INTO heb_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","ולבני קהת לא נתן כי עבדת הקדש עלהם בכתף ישאו׃ ");
INSERT INTO heb_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","ויקריבו הנשאים את חנכת המזבח ביום המשח אתו ויקריבו הנשיאם את קרבנם לפני המזבח׃ ");
INSERT INTO heb_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","ויאמר יהוה אל משה נשיא אחד ליום נשיא אחד ליום יקריבו את קרבנם לחנכת המזבח׃ ");
INSERT INTO heb_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","ויהי המקריב ביום הראשון את קרבנו נחשון בן עמינדב למטה יהודה׃ ");
INSERT INTO heb_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","וקרבנו קערת כסף אחת שלשים ומאה משקלה מזרק אחד כסף שבעים שקל בשקל הקדש שניהם מלאים סלת בלולה בשמן למנחה׃ ");
INSERT INTO heb_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","כף אחת עשרה זהב מלאה קטרת׃ ");
INSERT INTO heb_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","פר אחד בן בקר איל אחד כבש אחד בן שנתו לעלה׃ ");
INSERT INTO heb_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","שעיר עזים אחד לחטאת׃ ");
INSERT INTO heb_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","ולזבח השלמים בקר שנים אילם חמשה עתודים חמשה כבשים בני שנה חמשה זה קרבן נחשון בן עמינדב׃ ");
INSERT INTO heb_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","ביום השני הקריב נתנאל בן צוער נשיא יששכר׃ ");
INSERT INTO heb_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","הקרב את קרבנו קערת כסף אחת שלשים ומאה משקלה מזרק אחד כסף שבעים שקל בשקל הקדש שניהם מלאים סלת בלולה בשמן למנחה׃ ");
INSERT INTO heb_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","כף אחת עשרה זהב מלאה קטרת׃ ");
INSERT INTO heb_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","פר אחד בן בקר איל אחד כבש אחד בן שנתו לעלה׃ ");
INSERT INTO heb_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","שעיר עזים אחד לחטאת׃ ");
INSERT INTO heb_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","ולזבח השלמים בקר שנים אילם חמשה עתודים חמשה כבשים בני שנה חמשה זה קרבן נתנאל בן צוער׃ ");
INSERT INTO heb_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","ביום השלישי נשיא לבני זבולן אליאב בן חלן׃ ");
INSERT INTO heb_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","קרבנו קערת כסף אחת שלשים ומאה משקלה מזרק אחד כסף שבעים שקל בשקל הקדש שניהם מלאים סלת בלולה בשמן למנחה׃ ");
INSERT INTO heb_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","כף אחת עשרה זהב מלאה קטרת׃ ");
INSERT INTO heb_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","פר אחד בן בקר איל אחד כבש אחד בן שנתו לעלה׃ ");
INSERT INTO heb_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","שעיר עזים אחד לחטאת׃ ");
INSERT INTO heb_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","ולזבח השלמים בקר שנים אילם חמשה עתדים חמשה כבשים בני שנה חמשה זה קרבן אליאב בן חלן׃ ");
INSERT INTO heb_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","ביום הרביעי נשיא לבני ראובן אליצור בן שדיאור׃ ");
INSERT INTO heb_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","קרבנו קערת כסף אחת שלשים ומאה משקלה מזרק אחד כסף שבעים שקל בשקל הקדש שניהם מלאים סלת בלולה בשמן למנחה׃ ");
INSERT INTO heb_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","כף אחת עשרה זהב מלאה קטרת׃ ");
INSERT INTO heb_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","פר אחד בן בקר איל אחד כבש אחד בן שנתו לעלה׃ ");
INSERT INTO heb_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","שעיר עזים אחד לחטאת׃ ");
INSERT INTO heb_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","ולזבח השלמים בקר שנים אילם חמשה עתדים חמשה כבשים בני שנה חמשה זה קרבן אליצור בן שדיאור׃ ");
INSERT INTO heb_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","ביום החמישי נשיא לבני שמעון שלמיאל בן צורישדי׃ ");
INSERT INTO heb_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","קרבנו קערת כסף אחת שלשים ומאה משקלה מזרק אחד כסף שבעים שקל בשקל הקדש שניהם מלאים סלת בלולה בשמן למנחה׃ ");
INSERT INTO heb_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","כף אחת עשרה זהב מלאה קטרת׃ ");
INSERT INTO heb_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","פר אחד בן בקר איל אחד כבש אחד בן שנתו לעלה׃ ");
INSERT INTO heb_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","שעיר עזים אחד לחטאת׃ ");
INSERT INTO heb_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","ולזבח השלמים בקר שנים אילם חמשה עתדים חמשה כבשים בני שנה חמשה זה קרבן שלמיאל בן צורישדי׃ ");
INSERT INTO heb_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","ביום הששי נשיא לבני גד אליסף בן דעואל׃ ");
INSERT INTO heb_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","קרבנו קערת כסף אחת שלשים ומאה משקלה מזרק אחד כסף שבעים שקל בשקל הקדש שניהם מלאים סלת בלולה בשמן למנחה׃ ");
INSERT INTO heb_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","כף אחת עשרה זהב מלאה קטרת׃ ");
INSERT INTO heb_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","פר אחד בן בקר איל אחד כבש אחד בן שנתו לעלה׃ ");
INSERT INTO heb_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","שעיר עזים אחד לחטאת׃ ");
INSERT INTO heb_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","ולזבח השלמים בקר שנים אילם חמשה עתדים חמשה כבשים בני שנה חמשה זה קרבן אליסף בן דעואל׃ ");
INSERT INTO heb_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","ביום השביעי נשיא לבני אפרים אלישמע בן עמיהוד׃ ");
INSERT INTO heb_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","קרבנו קערת כסף אחת שלשים ומאה משקלה מזרק אחד כסף שבעים שקל בשקל הקדש שניהם מלאים סלת בלולה בשמן למנחה׃ ");
INSERT INTO heb_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","כף אחת עשרה זהב מלאה קטרת׃ ");
INSERT INTO heb_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","פר אחד בן בקר איל אחד כבש אחד בן שנתו לעלה׃ ");
INSERT INTO heb_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","שעיר עזים אחד לחטאת׃ ");
INSERT INTO heb_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","ולזבח השלמים בקר שנים אילם חמשה עתדים חמשה כבשים בני שנה חמשה זה קרבן אלישמע בן עמיהוד׃ ");
INSERT INTO heb_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","ביום השמיני נשיא לבני מנשה גמליאל בן פדהצור׃ ");
INSERT INTO heb_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","קרבנו קערת כסף אחת שלשים ומאה משקלה מזרק אחד כסף שבעים שקל בשקל הקדש שניהם מלאים סלת בלולה בשמן למנחה׃ ");
INSERT INTO heb_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","כף אחת עשרה זהב מלאה קטרת׃ ");
INSERT INTO heb_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","פר אחד בן בקר איל אחד כבש אחד בן שנתו לעלה׃ ");
INSERT INTO heb_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","שעיר עזים אחד לחטאת׃ ");
INSERT INTO heb_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","ולזבח השלמים בקר שנים אילם חמשה עתדים חמשה כבשים בני שנה חמשה זה קרבן גמליאל בן פדהצור׃ ");
INSERT INTO heb_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","ביום התשיעי נשיא לבני בנימן אבידן בן גדעני׃ ");
INSERT INTO heb_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","קרבנו קערת כסף אחת שלשים ומאה משקלה מזרק אחד כסף שבעים שקל בשקל הקדש שניהם מלאים סלת בלולה בשמן למנחה׃ ");
INSERT INTO heb_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","כף אחת עשרה זהב מלאה קטרת׃ ");
INSERT INTO heb_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","פר אחד בן בקר איל אחד כבש אחד בן שנתו לעלה׃ ");
INSERT INTO heb_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","שעיר עזים אחד לחטאת׃ ");
INSERT INTO heb_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","ולזבח השלמים בקר שנים אילם חמשה עתדים חמשה כבשים בני שנה חמשה זה קרבן אבידן בן גדעני׃ ");
INSERT INTO heb_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","ביום העשירי נשיא לבני דן אחיעזר בן עמישדי׃ ");
INSERT INTO heb_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","קרבנו קערת כסף אחת שלשים ומאה משקלה מזרק אחד כסף שבעים שקל בשקל הקדש שניהם מלאים סלת בלולה בשמן למנחה׃ ");
INSERT INTO heb_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","כף אחת עשרה זהב מלאה קטרת׃ ");
INSERT INTO heb_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","פר אחד בן בקר איל אחד כבש אחד בן שנתו לעלה׃ ");
INSERT INTO heb_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","שעיר עזים אחד לחטאת׃ ");
INSERT INTO heb_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","ולזבח השלמים בקר שנים אילם חמשה עתדים חמשה כבשים בני שנה חמשה זה קרבן אחיעזר בן עמישדי׃ ");
INSERT INTO heb_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","ביום עשתי עשר יום נשיא לבני אשר פגעיאל בן עכרן׃ ");
INSERT INTO heb_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","קרבנו קערת כסף אחת שלשים ומאה משקלה מזרק אחד כסף שבעים שקל בשקל הקדש שניהם מלאים סלת בלולה בשמן למנחה׃ ");
INSERT INTO heb_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","כף אחת עשרה זהב מלאה קטרת׃ ");
INSERT INTO heb_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","פר אחד בן בקר איל אחד כבש אחד בן שנתו לעלה׃ ");
INSERT INTO heb_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","שעיר עזים אחד לחטאת׃ ");
INSERT INTO heb_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","ולזבח השלמים בקר שנים אילם חמשה עתדים חמשה כבשים בני שנה חמשה זה קרבן פגעיאל בן עכרן׃ ");
INSERT INTO heb_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","ביום שנים עשר יום נשיא לבני נפתלי אחירע בן עינן׃ ");
INSERT INTO heb_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","קרבנו קערת כסף אחת שלשים ומאה משקלה מזרק אחד כסף שבעים שקל בשקל הקדש שניהם מלאים סלת בלולה בשמן למנחה׃ ");
INSERT INTO heb_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","כף אחת עשרה זהב מלאה קטרת׃ ");
INSERT INTO heb_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","פר אחד בן בקר איל אחד כבש אחד בן שנתו לעלה׃ ");
INSERT INTO heb_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","שעיר עזים אחד לחטאת׃ ");
INSERT INTO heb_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","ולזבח השלמים בקר שנים אילם חמשה עתדים חמשה כבשים בני שנה חמשה זה קרבן אחירע בן עינן׃ ");
INSERT INTO heb_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","זאת חנכת המזבח ביום המשח אתו מאת נשיאי ישראל קערת כסף שתים עשרה מזרקי כסף שנים עשר כפות זהב שתים עשרה׃ ");
INSERT INTO heb_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","שלשים ומאה הקערה האחת כסף ושבעים המזרק האחד כל כסף הכלים אלפים וארבע מאות בשקל הקדש׃ ");
INSERT INTO heb_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","כפות זהב שתים עשרה מלאת קטרת עשרה עשרה הכף בשקל הקדש כל זהב הכפות עשרים ומאה׃ ");
INSERT INTO heb_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","כל הבקר לעלה שנים עשר פרים אילם שנים עשר כבשים בני שנה שנים עשר ומנחתם ושעירי עזים שנים עשר לחטאת׃ ");
INSERT INTO heb_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","וכל בקר זבח השלמים עשרים וארבעה פרים אילם ששים עתדים ששים כבשים בני שנה ששים זאת חנכת המזבח אחרי המשח אתו׃ ");
INSERT INTO heb_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","ובבא משה אל אהל מועד לדבר אתו וישמע את הקול מדבר אליו מעל הכפרת אשר על ארן העדת מבין שני הכרבים וידבר אליו׃ ");
INSERT INTO heb_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","דבר אל אהרן ואמרת אליו בהעלתך את הנרת אל מול פני המנורה יאירו שבעת הנרות׃ ");
INSERT INTO heb_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","ויעש כן אהרן אל מול פני המנורה העלה נרתיה כאשר צוה יהוה את משה׃ ");
INSERT INTO heb_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","וזה מעשה המנרה מקשה זהב עד ירכה עד פרחה מקשה הוא כמראה אשר הראה יהוה את משה כן עשה את המנרה׃ ");
INSERT INTO heb_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","קח את הלוים מתוך בני ישראל וטהרת אתם׃ ");
INSERT INTO heb_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","וכה תעשה להם לטהרם הזה עליהם מי חטאת והעבירו תער על כל בשרם וכבסו בגדיהם והטהרו׃ ");
INSERT INTO heb_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","ולקחו פר בן בקר ומנחתו סלת בלולה בשמן ופר שני בן בקר תקח לחטאת׃ ");
INSERT INTO heb_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","והקרבת את הלוים לפני אהל מועד והקהלת את כל עדת בני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","והקרבת את הלוים לפני יהוה וסמכו בני ישראל את ידיהם על הלוים׃ ");
INSERT INTO heb_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","והניף אהרן את הלוים תנופה לפני יהוה מאת בני ישראל והיו לעבד את עבדת יהוה׃ ");
INSERT INTO heb_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","והלוים יסמכו את ידיהם על ראש הפרים ועשה את האחד חטאת ואת האחד עלה ליהוה לכפר על הלוים׃ ");
INSERT INTO heb_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","והעמדת את הלוים לפני אהרן ולפני בניו והנפת אתם תנופה ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","והבדלת את הלוים מתוך בני ישראל והיו לי הלוים׃ ");
INSERT INTO heb_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","ואחרי כן יבאו הלוים לעבד את אהל מועד וטהרת אתם והנפת אתם תנופה׃ ");
INSERT INTO heb_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","כי נתנים נתנים המה לי מתוך בני ישראל תחת פטרת כל רחם בכור כל מבני ישראל לקחתי אתם לי׃ ");
INSERT INTO heb_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","כי לי כל בכור בבני ישראל באדם ובבהמה ביום הכתי כל בכור בארץ מצרים הקדשתי אתם לי׃ ");
INSERT INTO heb_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","ואקח את הלוים תחת כל בכור בבני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","ואתנה את הלוים נתנים לאהרן ולבניו מתוך בני ישראל לעבד את עבדת בני ישראל באהל מועד ולכפר על בני ישראל ולא יהיה בבני ישראל נגף בגשת בני ישראל אל הקדש׃ ");
INSERT INTO heb_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","ויעש משה ואהרן וכל עדת בני ישראל ללוים ככל אשר צוה יהוה את משה ללוים כן עשו להם בני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","ויתחטאו הלוים ויכבסו בגדיהם וינף אהרן אתם תנופה לפני יהוה ויכפר עליהם אהרן לטהרם׃ ");
INSERT INTO heb_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","ואחרי כן באו הלוים לעבד את עבדתם באהל מועד לפני אהרן ולפני בניו כאשר צוה יהוה את משה על הלוים כן עשו להם׃ ");
INSERT INTO heb_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","זאת אשר ללוים מבן חמש ועשרים שנה ומעלה יבוא לצבא צבא בעבדת אהל מועד׃ ");
INSERT INTO heb_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","ומבן חמשים שנה ישוב מצבא העבדה ולא יעבד עוד׃ ");
INSERT INTO heb_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","ושרת את אחיו באהל מועד לשמר משמרת ועבדה לא יעבד ככה תעשה ללוים במשמרתם׃ ");
INSERT INTO heb_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","וידבר יהוה אל משה במדבר סיני בשנה השנית לצאתם מארץ מצרים בחדש הראשון לאמר׃ ");
INSERT INTO heb_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","ויעשו בני ישראל את הפסח במועדו׃ ");
INSERT INTO heb_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","בארבעה עשר יום בחדש הזה בין הערבים תעשו אתו במועדו ככל חקתיו וככל משפטיו תעשו אתו׃ ");
INSERT INTO heb_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","וידבר משה אל בני ישראל לעשת הפסח׃ ");
INSERT INTO heb_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","ויעשו את הפסח בראשון בארבעה עשר יום לחדש בין הערבים במדבר סיני ככל אשר צוה יהוה את משה כן עשו בני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","ויהי אנשים אשר היו טמאים לנפש אדם ולא יכלו לעשת הפסח ביום ההוא ויקרבו לפני משה ולפני אהרן ביום ההוא׃ ");
INSERT INTO heb_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","ויאמרו האנשים ההמה אליו אנחנו טמאים לנפש אדם למה נגרע לבלתי הקרב את קרבן יהוה במעדו בתוך בני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","ויאמר אלהם משה עמדו ואשמעה מה יצוה יהוה לכם׃ ");
INSERT INTO heb_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","דבר אל בני ישראל לאמר איש איש כי יהיה טמא לנפש או בדרך רחקה לכם או לדרתיכם ועשה פסח ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","בחדש השני בארבעה עשר יום בין הערבים יעשו אתו על מצות ומררים יאכלהו׃ ");
INSERT INTO heb_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","לא ישאירו ממנו עד בקר ועצם לא ישברו בו ככל חקת הפסח יעשו אתו׃ ");
INSERT INTO heb_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","והאיש אשר הוא טהור ובדרך לא היה וחדל לעשות הפסח ונכרתה הנפש ההוא מעמיה כי קרבן יהוה לא הקריב במעדו חטאו ישא האיש ההוא׃ ");
INSERT INTO heb_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","וכי יגור אתכם גר ועשה פסח ליהוה כחקת הפסח וכמשפטו כן יעשה חקה אחת יהיה לכם ולגר ולאזרח הארץ׃ ");
INSERT INTO heb_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","וביום הקים את המשכן כסה הענן את המשכן לאהל העדת ובערב יהיה על המשכן כמראה אש עד בקר׃ ");
INSERT INTO heb_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","כן יהיה תמיד הענן יכסנו ומראה אש לילה׃ ");
INSERT INTO heb_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","ולפי העלת הענן מעל האהל ואחרי כן יסעו בני ישראל ובמקום אשר ישכן שם הענן שם יחנו בני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","על פי יהוה יסעו בני ישראל ועל פי יהוה יחנו כל ימי אשר ישכן הענן על המשכן יחנו׃ ");
INSERT INTO heb_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","ובהאריך הענן על המשכן ימים רבים ושמרו בני ישראל את משמרת יהוה ולא יסעו׃ ");
INSERT INTO heb_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","ויש אשר יהיה הענן ימים מספר על המשכן על פי יהוה יחנו ועל פי יהוה יסעו׃ ");
INSERT INTO heb_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","ויש אשר יהיה הענן מערב עד בקר ונעלה הענן בבקר ונסעו או יומם ולילה ונעלה הענן ונסעו׃ ");
INSERT INTO heb_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","או ימים או חדש או ימים בהאריך הענן על המשכן לשכן עליו יחנו בני ישראל ולא יסעו ובהעלתו יסעו׃ ");
INSERT INTO heb_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","על פי יהוה יחנו ועל פי יהוה יסעו את משמרת יהוה שמרו על פי יהוה ביד משה׃ ");
INSERT INTO heb_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","עשה לך שתי חצוצרת כסף מקשה תעשה אתם והיו לך למקרא העדה ולמסע את המחנות׃ ");
INSERT INTO heb_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","ותקעו בהן ונועדו אליך כל העדה אל פתח אהל מועד׃ ");
INSERT INTO heb_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","ואם באחת יתקעו ונועדו אליך הנשיאים ראשי אלפי ישראל׃ ");
INSERT INTO heb_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","ותקעתם תרועה ונסעו המחנות החנים קדמה׃ ");
INSERT INTO heb_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","ותקעתם תרועה שנית ונסעו המחנות החנים תימנה תרועה יתקעו למסעיהם׃ ");
INSERT INTO heb_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","ובהקהיל את הקהל תתקעו ולא תריעו׃ ");
INSERT INTO heb_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","ובני אהרן הכהנים יתקעו בחצצרות והיו לכם לחקת עולם לדרתיכם׃ ");
INSERT INTO heb_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","וכי תבאו מלחמה בארצכם על הצר הצרר אתכם והרעתם בחצצרות ונזכרתם לפני יהוה אלהיכם ונושעתם מאיביכם׃ ");
INSERT INTO heb_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","וביום שמחתכם ובמועדיכם ובראשי חדשיכם ותקעתם בחצצרת על עלתיכם ועל זבחי שלמיכם והיו לכם לזכרון לפני אלהיכם אני יהוה אלהיכם׃ ");
INSERT INTO heb_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","ויהי בשנה השנית בחדש השני בעשרים בחדש נעלה הענן מעל משכן העדת׃ ");
INSERT INTO heb_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","ויסעו בני ישראל למסעיהם ממדבר סיני וישכן הענן במדבר פארן׃ ");
INSERT INTO heb_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","ויסעו בראשנה על פי יהוה ביד משה׃ ");
INSERT INTO heb_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","ויסע דגל מחנה בני יהודה בראשנה לצבאתם ועל צבאו נחשון בן עמינדב׃ ");
INSERT INTO heb_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","ועל צבא מטה בני יששכר נתנאל בן צוער׃ ");
INSERT INTO heb_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","ועל צבא מטה בני זבולן אליאב בן חלון׃ ");
INSERT INTO heb_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","והורד המשכן ונסעו בני גרשון ובני מררי נשאי המשכן׃ ");
INSERT INTO heb_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","ונסע דגל מחנה ראובן לצבאתם ועל צבאו אליצור בן שדיאור׃ ");
INSERT INTO heb_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","ועל צבא מטה בני שמעון שלמיאל בן צורי שדי׃ ");
INSERT INTO heb_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","ועל צבא מטה בני גד אליסף בן דעואל׃ ");
INSERT INTO heb_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","ונסעו הקהתים נשאי המקדש והקימו את המשכן עד באם׃ ");
INSERT INTO heb_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","ונסע דגל מחנה בני אפרים לצבאתם ועל צבאו אלישמע בן עמיהוד׃ ");
INSERT INTO heb_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","ועל צבא מטה בני מנשה גמליאל בן פדהצור׃ ");
INSERT INTO heb_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","ועל צבא מטה בני בנימן אבידן בן גדעוני׃ ");
INSERT INTO heb_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","ונסע דגל מחנה בני דן מאסף לכל המחנת לצבאתם ועל צבאו אחיעזר בן עמישדי׃ ");
INSERT INTO heb_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","ועל צבא מטה בני אשר פגעיאל בן עכרן׃ ");
INSERT INTO heb_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","ועל צבא מטה בני נפתלי אחירע בן עינן׃ ");
INSERT INTO heb_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","אלה מסעי בני ישראל לצבאתם ויסעו׃ ");
INSERT INTO heb_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","ויאמר משה לחבב בן רעואל המדיני חתן משה נסעים אנחנו אל המקום אשר אמר יהוה אתו אתן לכם לכה אתנו והטבנו לך כי יהוה דבר טוב על ישראל׃ ");
INSERT INTO heb_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","ויאמר אליו לא אלך כי אם אל ארצי ואל מולדתי אלך׃ ");
INSERT INTO heb_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","ויאמר אל נא תעזב אתנו כי על כן ידעת חנתנו במדבר והיית לנו לעינים׃ ");
INSERT INTO heb_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","והיה כי תלך עמנו והיה הטוב ההוא אשר ייטיב יהוה עמנו והטבנו לך׃ ");
INSERT INTO heb_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","ויסעו מהר יהוה דרך שלשת ימים וארון ברית יהוה נסע לפניהם דרך שלשת ימים לתור להם מנוחה׃ ");
INSERT INTO heb_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","וענן יהוה עליהם יומם בנסעם מן המחנה׃ ");
INSERT INTO heb_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","ויהי בנסע הארן ויאמר משה קומה יהוה ויפצו איביך וינסו משנאיך מפניך׃ ");
INSERT INTO heb_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","ובנחה יאמר שובה יהוה רבבות אלפי ישראל׃ ");
INSERT INTO heb_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","ויהי העם כמתאננים רע באזני יהוה וישמע יהוה ויחר אפו ותבער בם אש יהוה ותאכל בקצה המחנה׃ ");
INSERT INTO heb_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","ויצעק העם אל משה ויתפלל משה אל יהוה ותשקע האש׃ ");
INSERT INTO heb_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","ויקרא שם המקום ההוא תבערה כי בערה בם אש יהוה׃ ");
INSERT INTO heb_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","והאספסף אשר בקרבו התאוו תאוה וישבו ויבכו גם בני ישראל ויאמרו מי יאכלנו בשר׃ ");
INSERT INTO heb_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","זכרנו את הדגה אשר נאכל במצרים חנם את הקשאים ואת האבטחים ואת החציר ואת הבצלים ואת השומים׃ ");
INSERT INTO heb_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","ועתה נפשנו יבשה אין כל בלתי אל המן עינינו׃ ");
INSERT INTO heb_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","והמן כזרע גד הוא ועינו כעין הבדלח׃ ");
INSERT INTO heb_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","שטו העם ולקטו וטחנו ברחים או דכו במדכה ובשלו בפרור ועשו אתו עגות והיה טעמו כטעם לשד השמן׃ ");
INSERT INTO heb_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","וברדת הטל על המחנה לילה ירד המן עליו׃ ");
INSERT INTO heb_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","וישמע משה את העם בכה למשפחתיו איש לפתח אהלו ויחר אף יהוה מאד ובעיני משה רע׃ ");
INSERT INTO heb_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","ויאמר משה אל יהוה למה הרעת לעבדך ולמה לא מצתי חן בעיניך לשום את משא כל העם הזה עלי׃ ");
INSERT INTO heb_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","האנכי הריתי את כל העם הזה אם אנכי ילדתיהו כי תאמר אלי שאהו בחיקך כאשר ישא האמן את הינק על האדמה אשר נשבעת לאבתיו׃ ");
INSERT INTO heb_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","מאין לי בשר לתת לכל העם הזה כי יבכו עלי לאמר תנה לנו בשר ונאכלה׃ ");
INSERT INTO heb_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","לא אוכל אנכי לבדי לשאת את כל העם הזה כי כבד ממני׃ ");
INSERT INTO heb_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","ואם ככה את עשה לי הרגני נא הרג אם מצאתי חן בעיניך ואל אראה ברעתי׃ ");
INSERT INTO heb_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","ויאמר יהוה אל משה אספה לי שבעים איש מזקני ישראל אשר ידעת כי הם זקני העם ושטריו ולקחת אתם אל אהל מועד והתיצבו שם עמך׃ ");
INSERT INTO heb_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","וירדתי ודברתי עמך שם ואצלתי מן הרוח אשר עליך ושמתי עליהם ונשאו אתך במשא העם ולא תשא אתה לבדך׃ ");
INSERT INTO heb_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","ואל העם תאמר התקדשו למחר ואכלתם בשר כי בכיתם באזני יהוה לאמר מי יאכלנו בשר כי טוב לנו במצרים ונתן יהוה לכם בשר ואכלתם׃ ");
INSERT INTO heb_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","לא יום אחד תאכלון ולא יומים ולא חמשה ימים ולא עשרה ימים ולא עשרים יום׃ ");
INSERT INTO heb_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","עד חדש ימים עד אשר יצא מאפכם והיה לכם לזרא יען כי מאסתם את יהוה אשר בקרבכם ותבכו לפניו לאמר למה זה יצאנו ממצרים׃ ");
INSERT INTO heb_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","ויאמר משה שש מאות אלף רגלי העם אשר אנכי בקרבו ואתה אמרת בשר אתן להם ואכלו חדש ימים׃ ");
INSERT INTO heb_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","הצאן ובקר ישחט להם ומצא להם אם את כל דגי הים יאסף להם ומצא להם׃ ");
INSERT INTO heb_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","ויאמר יהוה אל משה היד יהוה תקצר עתה תראה היקרך דברי אם לא׃ ");
INSERT INTO heb_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","ויצא משה וידבר אל העם את דברי יהוה ויאסף שבעים איש מזקני העם ויעמד אתם סביבת האהל׃ ");
INSERT INTO heb_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","וירד יהוה בענן וידבר אליו ויאצל מן הרוח אשר עליו ויתן על שבעים איש הזקנים ויהי כנוח עליהם הרוח ויתנבאו ולא יספו׃ ");
INSERT INTO heb_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","וישארו שני אנשים במחנה שם האחד אלדד ושם השני מידד ותנח עליהם הרוח והמה בכתבים ולא יצאו האהלה ויתנבאו במחנה׃ ");
INSERT INTO heb_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","וירץ הנער ויגד למשה ויאמר אלדד ומידד מתנבאים במחנה׃ ");
INSERT INTO heb_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","ויען יהושע בן נון משרת משה מבחריו ויאמר אדני משה כלאם׃ ");
INSERT INTO heb_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","ויאמר לו משה המקנא אתה לי ומי יתן כל עם יהוה נביאים כי יתן יהוה את רוחו עליהם׃ ");
INSERT INTO heb_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","ויאסף משה אל המחנה הוא וזקני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","ורוח נסע מאת יהוה ויגז שלוים מן הים ויטש על המחנה כדרך יום כה וכדרך יום כה סביבות המחנה וכאמתים על פני הארץ׃ ");
INSERT INTO heb_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","ויקם העם כל היום ההוא וכל הלילה וכל יום המחרת ויאספו את השלו הממעיט אסף עשרה חמרים וישטחו להם שטוח סביבות המחנה׃ ");
INSERT INTO heb_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","הבשר עודנו בין שניהם טרם יכרת ואף יהוה חרה בעם ויך יהוה בעם מכה רבה מאד׃ ");
INSERT INTO heb_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","ויקרא את שם המקום ההוא קברות התאוה כי שם קברו את העם המתאוים׃ ");
INSERT INTO heb_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","מקברות התאוה נסעו העם חצרות ויהיו בחצרות׃ ");
INSERT INTO heb_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","ותדבר מרים ואהרן במשה על אדות האשה הכשית אשר לקח כי אשה כשית לקח׃ ");
INSERT INTO heb_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","ויאמרו הרק אך במשה דבר יהוה הלא גם בנו דבר וישמע יהוה׃ ");
INSERT INTO heb_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","והאיש משה ענו מאד מכל האדם אשר על פני האדמה׃ ");
INSERT INTO heb_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","ויאמר יהוה פתאם אל משה ואל אהרן ואל מרים צאו שלשתכם אל אהל מועד ויצאו שלשתם׃ ");
INSERT INTO heb_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","וירד יהוה בעמוד ענן ויעמד פתח האהל ויקרא אהרן ומרים ויצאו שניהם׃ ");
INSERT INTO heb_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","ויאמר שמעו נא דברי אם יהיה נביאכם יהוה במראה אליו אתודע בחלום אדבר בו׃ ");
INSERT INTO heb_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","לא כן עבדי משה בכל ביתי נאמן הוא׃ ");
INSERT INTO heb_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","פה אל פה אדבר בו ומראה ולא בחידת ותמנת יהוה יביט ומדוע לא יראתם לדבר בעבדי במשה׃ ");
INSERT INTO heb_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","ויחר אף יהוה בם וילך׃ ");
INSERT INTO heb_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","והענן סר מעל האהל והנה מרים מצרעת כשלג ויפן אהרן אל מרים והנה מצרעת׃ ");
INSERT INTO heb_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","ויאמר אהרן אל משה בי אדני אל נא תשת עלינו חטאת אשר נואלנו ואשר חטאנו׃ ");
INSERT INTO heb_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","אל נא תהי כמת אשר בצאתו מרחם אמו ויאכל חצי בשרו׃ ");
INSERT INTO heb_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","ויצעק משה אל יהוה לאמר אל נא רפא נא לה׃ ");
INSERT INTO heb_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","ויאמר יהוה אל משה ואביה ירק ירק בפניה הלא תכלם שבעת ימים תסגר שבעת ימים מחוץ למחנה ואחר תאסף׃ ");
INSERT INTO heb_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","ותסגר מרים מחוץ למחנה שבעת ימים והעם לא נסע עד האסף מרים׃ ");
INSERT INTO heb_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","ואחר נסעו העם מחצרות ויחנו במדבר פארן׃ ");
INSERT INTO heb_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","שלח לך אנשים ויתרו את ארץ כנען אשר אני נתן לבני ישראל איש אחד איש אחד למטה אבתיו תשלחו כל נשיא בהם׃ ");
INSERT INTO heb_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","וישלח אתם משה ממדבר פארן על פי יהוה כלם אנשים ראשי בני ישראל המה׃ ");
INSERT INTO heb_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","ואלה שמותם למטה ראובן שמוע בן זכור׃ ");
INSERT INTO heb_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","למטה שמעון שפט בן חורי׃ ");
INSERT INTO heb_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","למטה יהודה כלב בן יפנה׃ ");
INSERT INTO heb_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","למטה יששכר יגאל בן יוסף׃ ");
INSERT INTO heb_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","למטה אפרים הושע בן נון׃ ");
INSERT INTO heb_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","למטה בנימן פלטי בן רפוא׃ ");
INSERT INTO heb_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","למטה זבולן גדיאל בן סודי׃ ");
INSERT INTO heb_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","למטה יוסף למטה מנשה גדי בן סוסי׃ ");
INSERT INTO heb_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","למטה דן עמיאל בן גמלי׃ ");
INSERT INTO heb_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","למטה אשר סתור בן מיכאל׃ ");
INSERT INTO heb_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","למטה נפתלי נחבי בן ופסי׃ ");
INSERT INTO heb_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","למטה גד גאואל בן מכי׃ ");
INSERT INTO heb_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","אלה שמות האנשים אשר שלח משה לתור את הארץ ויקרא משה להושע בן נון יהושע׃ ");
INSERT INTO heb_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","וישלח אתם משה לתור את ארץ כנען ויאמר אלהם עלו זה בנגב ועליתם את ההר׃ ");
INSERT INTO heb_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","וראיתם את הארץ מה הוא ואת העם הישב עליה החזק הוא הרפה המעט הוא אם רב׃ ");
INSERT INTO heb_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","ומה הארץ אשר הוא ישב בה הטובה הוא אם רעה ומה הערים אשר הוא יושב בהנה הבמחנים אם במבצרים׃ ");
INSERT INTO heb_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","ומה הארץ השמנה הוא אם רזה היש בה עץ אם אין והתחזקתם ולקחתם מפרי הארץ והימים ימי בכורי ענבים׃ ");
INSERT INTO heb_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","ויעלו ויתרו את הארץ ממדבר צן עד רחב לבא חמת׃ ");
INSERT INTO heb_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","ויעלו בנגב ויבא עד חברון ושם אחימן ששי ותלמי ילידי הענק וחברון שבע שנים נבנתה לפני צען מצרים׃ ");
INSERT INTO heb_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","ויבאו עד נחל אשכל ויכרתו משם זמורה ואשכול ענבים אחד וישאהו במוט בשנים ומן הרמנים ומן התאנים׃ ");
INSERT INTO heb_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","למקום ההוא קרא נחל אשכול על אדות האשכול אשר כרתו משם בני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","וישבו מתור הארץ מקץ ארבעים יום׃ ");
INSERT INTO heb_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","וילכו ויבאו אל משה ואל אהרן ואל כל עדת בני ישראל אל מדבר פארן קדשה וישיבו אותם דבר ואת כל העדה ויראום את פרי הארץ׃ ");
INSERT INTO heb_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","ויספרו לו ויאמרו באנו אל הארץ אשר שלחתנו וגם זבת חלב ודבש הוא וזה פריה׃ ");
INSERT INTO heb_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","אפס כי עז העם הישב בארץ והערים בצרות גדלת מאד וגם ילדי הענק ראינו שם׃ ");
INSERT INTO heb_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","עמלק יושב בארץ הנגב והחתי והיבוסי והאמרי יושב בהר והכנעני ישב על הים ועל יד הירדן׃ ");
INSERT INTO heb_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","ויהס כלב את העם אל משה ויאמר עלה נעלה וירשנו אתה כי יכול נוכל לה׃ ");
INSERT INTO heb_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","והאנשים אשר עלו עמו אמרו לא נוכל לעלות אל העם כי חזק הוא ממנו׃ ");
INSERT INTO heb_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","ויוציאו דבת הארץ אשר תרו אתה אל בני ישראל לאמר הארץ אשר עברנו בה לתור אתה ארץ אכלת יושביה הוא וכל העם אשר ראינו בתוכה אנשי מדות׃ ");
INSERT INTO heb_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","ושם ראינו את הנפילים בני ענק מן הנפלים ונהי בעינינו כחגבים וכן היינו בעיניהם׃ ");
INSERT INTO heb_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","ותשא כל העדה ויתנו את קולם ויבכו העם בלילה ההוא׃ ");
INSERT INTO heb_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","וילנו על משה ועל אהרן כל בני ישראל ויאמרו אלהם כל העדה לו מתנו בארץ מצרים או במדבר הזה לו מתנו׃ ");
INSERT INTO heb_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","ולמה יהוה מביא אתנו אל הארץ הזאת לנפל בחרב נשינו וטפנו יהיו לבז הלוא טוב לנו שוב מצרימה׃ ");
INSERT INTO heb_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","ויאמרו איש אל אחיו נתנה ראש ונשובה מצרימה׃ ");
INSERT INTO heb_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","ויפל משה ואהרן על פניהם לפני כל קהל עדת בני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","ויהושע בן נון וכלב בן יפנה מן התרים את הארץ קרעו בגדיהם׃ ");
INSERT INTO heb_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","ויאמרו אל כל עדת בני ישראל לאמר הארץ אשר עברנו בה לתור אתה טובה הארץ מאד מאד׃ ");
INSERT INTO heb_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","אם חפץ בנו יהוה והביא אתנו אל הארץ הזאת ונתנה לנו ארץ אשר הוא זבת חלב ודבש׃ ");
INSERT INTO heb_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","אך ביהוה אל תמרדו ואתם אל תיראו את עם הארץ כי לחמנו הם סר צלם מעליהם ויהוה אתנו אל תיראם׃ ");
INSERT INTO heb_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","ויאמרו כל העדה לרגום אתם באבנים וכבוד יהוה נראה באהל מועד אל כל בני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","ויאמר יהוה אל משה עד אנה ינאצני העם הזה ועד אנה לא יאמינו בי בכל האתות אשר עשיתי בקרבו׃ ");
INSERT INTO heb_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","אכנו בדבר ואורשנו ואעשה אתך לגוי גדול ועצום ממנו׃ ");
INSERT INTO heb_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","ויאמר משה אל יהוה ושמעו מצרים כי העלית בכחך את העם הזה מקרבו׃ ");
INSERT INTO heb_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","ואמרו אל יושב הארץ הזאת שמעו כי אתה יהוה בקרב העם הזה אשר עין בעין נראה אתה יהוה ועננך עמד עלהם ובעמד ענן אתה הלך לפניהם יומם ובעמוד אש לילה׃ ");
INSERT INTO heb_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","והמתה את העם הזה כאיש אחד ואמרו הגוים אשר שמעו את שמעך לאמר׃ ");
INSERT INTO heb_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","מבלתי יכלת יהוה להביא את העם הזה אל הארץ אשר נשבע להם וישחטם במדבר׃ ");
INSERT INTO heb_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","ועתה יגדל נא כח אדני כאשר דברת לאמר׃ ");
INSERT INTO heb_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","יהוה ארך אפים ורב חסד נשא עון ופשע ונקה לא ינקה פקד עון אבות על בנים על שלשים ועל רבעים׃ ");
INSERT INTO heb_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","סלח נא לעון העם הזה כגדל חסדך וכאשר נשאתה לעם הזה ממצרים ועד הנה׃ ");
INSERT INTO heb_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","ויאמר יהוה סלחתי כדברך׃ ");
INSERT INTO heb_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","ואולם חי אני וימלא כבוד יהוה את כל הארץ׃ ");
INSERT INTO heb_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","כי כל האנשים הראים את כבדי ואת אתתי אשר עשיתי במצרים ובמדבר וינסו אתי זה עשר פעמים ולא שמעו בקולי׃ ");
INSERT INTO heb_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","אם יראו את הארץ אשר נשבעתי לאבתם וכל מנאצי לא יראוה׃ ");
INSERT INTO heb_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","ועבדי כלב עקב היתה רוח אחרת עמו וימלא אחרי והביאתיו אל הארץ אשר בא שמה וזרעו יורשנה׃ ");
INSERT INTO heb_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","והעמלקי והכנעני יושב בעמק מחר פנו וסעו לכם המדבר דרך ים סוף׃ ");
INSERT INTO heb_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","וידבר יהוה אל משה ואל אהרן לאמר׃ ");
INSERT INTO heb_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","עד מתי לעדה הרעה הזאת אשר המה מלינים עלי את תלנות בני ישראל אשר המה מלינים עלי שמעתי׃ ");
INSERT INTO heb_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","אמר אלהם חי אני נאם יהוה אם לא כאשר דברתם באזני כן אעשה לכם׃ ");
INSERT INTO heb_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","במדבר הזה יפלו פגריכם וכל פקדיכם לכל מספרכם מבן עשרים שנה ומעלה אשר הלינתם עלי׃ ");
INSERT INTO heb_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","אם אתם תבאו אל הארץ אשר נשאתי את ידי לשכן אתכם בה כי אם כלב בן יפנה ויהושע בן נון׃ ");
INSERT INTO heb_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","וטפכם אשר אמרתם לבז יהיה והביאתי אתם וידעו את הארץ אשר מאסתם בה׃ ");
INSERT INTO heb_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","ופגריכם אתם יפלו במדבר הזה׃ ");
INSERT INTO heb_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","ובניכם יהיו רעים במדבר ארבעים שנה ונשאו את זנותיכם עד תם פגריכם במדבר׃ ");
INSERT INTO heb_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","במספר הימים אשר תרתם את הארץ ארבעים יום יום לשנה יום לשנה תשאו את עונתיכם ארבעים שנה וידעתם את תנואתי׃ ");
INSERT INTO heb_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","אני יהוה דברתי אם לא זאת אעשה לכל העדה הרעה הזאת הנועדים עלי במדבר הזה יתמו ושם ימתו׃ ");
INSERT INTO heb_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","והאנשים אשר שלח משה לתור את הארץ וישבו וילונו עליו את כל העדה להוציא דבה על הארץ׃ ");
INSERT INTO heb_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","וימתו האנשים מוצאי דבת הארץ רעה במגפה לפני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","ויהושע בן נון וכלב בן יפנה חיו מן האנשים ההם ההלכים לתור את הארץ׃ ");
INSERT INTO heb_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","וידבר משה את הדברים האלה אל כל בני ישראל ויתאבלו העם מאד׃ ");
INSERT INTO heb_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","וישכמו בבקר ויעלו אל ראש ההר לאמר הננו ועלינו אל המקום אשר אמר יהוה כי חטאנו׃ ");
INSERT INTO heb_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","ויאמר משה למה זה אתם עברים את פי יהוה והוא לא תצלח׃ ");
INSERT INTO heb_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","אל תעלו כי אין יהוה בקרבכם ולא תנגפו לפני איביכם׃ ");
INSERT INTO heb_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","כי העמלקי והכנעני שם לפניכם ונפלתם בחרב כי על כן שבתם מאחרי יהוה ולא יהיה יהוה עמכם׃ ");
INSERT INTO heb_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","ויעפלו לעלות אל ראש ההר וארון ברית יהוה ומשה לא משו מקרב המחנה׃ ");
INSERT INTO heb_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","וירד העמלקי והכנעני הישב בהר ההוא ויכום ויכתום עד החרמה׃ ");
INSERT INTO heb_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","דבר אל בני ישראל ואמרת אלהם כי תבאו אל ארץ מושבתיכם אשר אני נתן לכם׃ ");
INSERT INTO heb_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","ועשיתם אשה ליהוה עלה או זבח לפלא נדר או בנדבה או במעדיכם לעשות ריח ניחח ליהוה מן הבקר או מן הצאן׃ ");
INSERT INTO heb_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","והקריב המקריב קרבנו ליהוה מנחה סלת עשרון בלול ברבעית ההין שמן׃ ");
INSERT INTO heb_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","ויין לנסך רביעית ההין תעשה על העלה או לזבח לכבש האחד׃ ");
INSERT INTO heb_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","או לאיל תעשה מנחה סלת שני עשרנים בלולה בשמן שלשית ההין׃ ");
INSERT INTO heb_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","ויין לנסך שלשית ההין תקריב ריח ניחח ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","וכי תעשה בן בקר עלה או זבח לפלא נדר או שלמים ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","והקריב על בן הבקר מנחה סלת שלשה עשרנים בלול בשמן חצי ההין׃ ");
INSERT INTO heb_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","ויין תקריב לנסך חצי ההין אשה ריח ניחח ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","ככה יעשה לשור האחד או לאיל האחד או לשה בכבשים או בעזים׃ ");
INSERT INTO heb_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","כמספר אשר תעשו ככה תעשו לאחד כמספרם׃ ");
INSERT INTO heb_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","כל האזרח יעשה ככה את אלה להקריב אשה ריח ניחח ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","וכי יגור אתכם גר או אשר בתוככם לדרתיכם ועשה אשה ריח ניחח ליהוה כאשר תעשו כן יעשה׃ ");
INSERT INTO heb_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","הקהל חקה אחת לכם ולגר הגר חקת עולם לדרתיכם ככם כגר יהיה לפני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","תורה אחת ומשפט אחד יהיה לכם ולגר הגר אתכם׃ ");
INSERT INTO heb_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","דבר אל בני ישראל ואמרת אלהם בבאכם אל הארץ אשר אני מביא אתכם שמה׃ ");
INSERT INTO heb_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","והיה באכלכם מלחם הארץ תרימו תרומה ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","ראשית ערסתכם חלה תרימו תרומה כתרומת גרן כן תרימו אתה׃ ");
INSERT INTO heb_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","מראשית ערסתיכם תתנו ליהוה תרומה לדרתיכם׃ ");
INSERT INTO heb_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","וכי תשגו ולא תעשו את כל המצות האלה אשר דבר יהוה אל משה׃ ");
INSERT INTO heb_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","את כל אשר צוה יהוה אליכם ביד משה מן היום אשר צוה יהוה והלאה לדרתיכם׃ ");
INSERT INTO heb_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","והיה אם מעיני העדה נעשתה לשגגה ועשו כל העדה פר בן בקר אחד לעלה לריח ניחח ליהוה ומנחתו ונסכו כמשפט ושעיר עזים אחד לחטת׃ ");
INSERT INTO heb_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","וכפר הכהן על כל עדת בני ישראל ונסלח להם כי שגגה הוא והם הביאו את קרבנם אשה ליהוה וחטאתם לפני יהוה על שגגתם׃ ");
INSERT INTO heb_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","ונסלח לכל עדת בני ישראל ולגר הגר בתוכם כי לכל העם בשגגה׃ ");
INSERT INTO heb_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","ואם נפש אחת תחטא בשגגה והקריבה עז בת שנתה לחטאת׃ ");
INSERT INTO heb_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","וכפר הכהן על הנפש השגגת בחטאה בשגגה לפני יהוה לכפר עליו ונסלח לו׃ ");
INSERT INTO heb_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","האזרח בבני ישראל ולגר הגר בתוכם תורה אחת יהיה לכם לעשה בשגגה׃ ");
INSERT INTO heb_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","והנפש אשר תעשה ביד רמה מן האזרח ומן הגר את יהוה הוא מגדף ונכרתה הנפש ההוא מקרב עמה׃ ");
INSERT INTO heb_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","כי דבר יהוה בזה ואת מצותו הפר הכרת תכרת הנפש ההוא עונה בה׃ ");
INSERT INTO heb_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","ויהיו בני ישראל במדבר וימצאו איש מקשש עצים ביום השבת׃ ");
INSERT INTO heb_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","ויקריבו אתו המצאים אתו מקשש עצים אל משה ואל אהרן ואל כל העדה׃ ");
INSERT INTO heb_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","ויניחו אתו במשמר כי לא פרש מה יעשה לו׃ ");
INSERT INTO heb_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","ויאמר יהוה אל משה מות יומת האיש רגום אתו באבנים כל העדה מחוץ למחנה׃ ");
INSERT INTO heb_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","ויציאו אתו כל העדה אל מחוץ למחנה וירגמו אתו באבנים וימת כאשר צוה יהוה את משה׃ ");
INSERT INTO heb_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","ויאמר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","דבר אל בני ישראל ואמרת אלהם ועשו להם ציצת על כנפי בגדיהם לדרתם ונתנו על ציצת הכנף פתיל תכלת׃ ");
INSERT INTO heb_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","והיה לכם לציצת וראיתם אתו וזכרתם את כל מצות יהוה ועשיתם אתם ולא תתרו אחרי לבבכם ואחרי עיניכם אשר אתם זנים אחריהם׃ ");
INSERT INTO heb_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","למען תזכרו ועשיתם את כל מצותי והייתם קדשים לאלהיכם׃ ");
INSERT INTO heb_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","אני יהוה אלהיכם אשר הוצאתי אתכם מארץ מצרים להיות לכם לאלהים אני יהוה אלהיכם׃ ");
INSERT INTO heb_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","ויקח קרח בן יצהר בן קהת בן לוי ודתן ואבירם בני אליאב ואון בן פלת בני ראובן׃ ");
INSERT INTO heb_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","ויקמו לפני משה ואנשים מבני ישראל חמשים ומאתים נשיאי עדה קראי מועד אנשי שם׃ ");
INSERT INTO heb_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","ויקהלו על משה ועל אהרן ויאמרו אלהם רב לכם כי כל העדה כלם קדשים ובתוכם יהוה ומדוע תתנשאו על קהל יהוה׃ ");
INSERT INTO heb_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","וישמע משה ויפל על פניו׃ ");
INSERT INTO heb_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","וידבר אל קרח ואל כל עדתו לאמר בקר וידע יהוה את אשר לו ואת הקדוש והקריב אליו ואת אשר יבחר בו יקריב אליו׃ ");
INSERT INTO heb_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","זאת עשו קחו לכם מחתות קרח וכל עדתו׃ ");
INSERT INTO heb_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","ותנו בהן אש ושימו עליהן קטרת לפני יהוה מחר והיה האיש אשר יבחר יהוה הוא הקדוש רב לכם בני לוי׃ ");
INSERT INTO heb_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","ויאמר משה אל קרח שמעו נא בני לוי׃ ");
INSERT INTO heb_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","המעט מכם כי הבדיל אלהי ישראל אתכם מעדת ישראל להקריב אתכם אליו לעבד את עבדת משכן יהוה ולעמד לפני העדה לשרתם׃ ");
INSERT INTO heb_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","ויקרב אתך ואת כל אחיך בני לוי אתך ובקשתם גם כהנה׃ ");
INSERT INTO heb_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","לכן אתה וכל עדתך הנעדים על יהוה ואהרן מה הוא כי תלונו עליו׃ ");
INSERT INTO heb_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","וישלח משה לקרא לדתן ולאבירם בני אליאב ויאמרו לא נעלה׃ ");
INSERT INTO heb_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","המעט כי העליתנו מארץ זבת חלב ודבש להמיתנו במדבר כי תשתרר עלינו גם השתרר׃ ");
INSERT INTO heb_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","אף לא אל ארץ זבת חלב ודבש הביאתנו ותתן לנו נחלת שדה וכרם העיני האנשים ההם תנקר לא נעלה׃ ");
INSERT INTO heb_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","ויחר למשה מאד ויאמר אל יהוה אל תפן אל מנחתם לא חמור אחד מהם נשאתי ולא הרעתי את אחד מהם׃ ");
INSERT INTO heb_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","ויאמר משה אל קרח אתה וכל עדתך היו לפני יהוה אתה והם ואהרן מחר׃ ");
INSERT INTO heb_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","וקחו איש מחתתו ונתתם עליהם קטרת והקרבתם לפני יהוה איש מחתתו חמשים ומאתים מחתת ואתה ואהרן איש מחתתו׃ ");
INSERT INTO heb_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","ויקחו איש מחתתו ויתנו עליהם אש וישימו עליהם קטרת ויעמדו פתח אהל מועד ומשה ואהרן׃ ");
INSERT INTO heb_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","ויקהל עליהם קרח את כל העדה אל פתח אהל מועד וירא כבוד יהוה אל כל העדה׃ ");
INSERT INTO heb_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","וידבר יהוה אל משה ואל אהרן לאמר׃ ");
INSERT INTO heb_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","הבדלו מתוך העדה הזאת ואכלה אתם כרגע׃ ");
INSERT INTO heb_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","ויפלו על פניהם ויאמרו אל אלהי הרוחת לכל בשר האיש אחד יחטא ועל כל העדה תקצף׃ ");
INSERT INTO heb_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","דבר אל העדה לאמר העלו מסביב למשכן קרח דתן ואבירם׃ ");
INSERT INTO heb_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","ויקם משה וילך אל דתן ואבירם וילכו אחריו זקני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","וידבר אל העדה לאמר סורו נא מעל אהלי האנשים הרשעים האלה ואל תגעו בכל אשר להם פן תספו בכל חטאתם׃ ");
INSERT INTO heb_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","ויעלו מעל משכן קרח דתן ואבירם מסביב ודתן ואבירם יצאו נצבים פתח אהליהם ונשיהם ובניהם וטפם׃ ");
INSERT INTO heb_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","ויאמר משה בזאת תדעון כי יהוה שלחני לעשות את כל המעשים האלה כי לא מלבי׃ ");
INSERT INTO heb_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","אם כמות כל האדם ימתון אלה ופקדת כל האדם יפקד עליהם לא יהוה שלחני׃ ");
INSERT INTO heb_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","ואם בריאה יברא יהוה ופצתה האדמה את פיה ובלעה אתם ואת כל אשר להם וירדו חיים שאלה וידעתם כי נאצו האנשים האלה את יהוה׃ ");
INSERT INTO heb_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","ויהי ככלתו לדבר את כל הדברים האלה ותבקע האדמה אשר תחתיהם׃ ");
INSERT INTO heb_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","ותפתח הארץ את פיה ותבלע אתם ואת בתיהם ואת כל האדם אשר לקרח ואת כל הרכוש׃ ");
INSERT INTO heb_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","וירדו הם וכל אשר להם חיים שאלה ותכס עליהם הארץ ויאבדו מתוך הקהל׃ ");
INSERT INTO heb_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","וכל ישראל אשר סביבתיהם נסו לקלם כי אמרו פן תבלענו הארץ׃ ");
INSERT INTO heb_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","ואש יצאה מאת יהוה ותאכל את החמשים ומאתים איש מקריבי הקטרת׃ ");
INSERT INTO heb_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","אמר אל אלעזר בן אהרן הכהן וירם את המחתת מבין השרפה ואת האש זרה הלאה כי קדשו׃ ");
INSERT INTO heb_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","את מחתות החטאים האלה בנפשתם ועשו אתם רקעי פחים צפוי למזבח כי הקריבם לפני יהוה ויקדשו ויהיו לאות לבני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","ויקח אלעזר הכהן את מחתות הנחשת אשר הקריבו השרפים וירקעום צפוי למזבח׃ ");
INSERT INTO heb_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","זכרון לבני ישראל למען אשר לא יקרב איש זר אשר לא מזרע אהרן הוא להקטיר קטרת לפני יהוה ולא יהיה כקרח וכעדתו כאשר דבר יהוה ביד משה לו׃ ");
INSERT INTO heb_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","וילנו כל עדת בני ישראל ממחרת על משה ועל אהרן לאמר אתם המתם את עם יהוה׃ ");
INSERT INTO heb_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","ויהי בהקהל העדה על משה ועל אהרן ויפנו אל אהל מועד והנה כסהו הענן וירא כבוד יהוה׃ ");
INSERT INTO heb_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","ויבא משה ואהרן אל פני אהל מועד׃ ");
INSERT INTO heb_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","הרמו מתוך העדה הזאת ואכלה אתם כרגע ויפלו על פניהם׃ ");
INSERT INTO heb_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","ויאמר משה אל אהרן קח את המחתה ותן עליה אש מעל המזבח ושים קטרת והולך מהרה אל העדה וכפר עליהם כי יצא הקצף מלפני יהוה החל הנגף׃ ");
INSERT INTO heb_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","ויקח אהרן כאשר דבר משה וירץ אל תוך הקהל והנה החל הנגף בעם ויתן את הקטרת ויכפר על העם׃ ");
INSERT INTO heb_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","ויעמד בין המתים ובין החיים ותעצר המגפה׃ ");
INSERT INTO heb_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","ויהיו המתים במגפה ארבעה עשר אלף ושבע מאות מלבד המתים על דבר קרח׃ ");
INSERT INTO heb_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","וישב אהרן אל משה אל פתח אהל מועד והמגפה נעצרה׃ ");
INSERT INTO heb_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","דבר אל בני ישראל וקח מאתם מטה מטה לבית אב מאת כל נשיאהם לבית אבתם שנים עשר מטות איש את שמו תכתב על מטהו׃ ");
INSERT INTO heb_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","ואת שם אהרן תכתב על מטה לוי כי מטה אחד לראש בית אבותם׃ ");
INSERT INTO heb_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","והנחתם באהל מועד לפני העדות אשר אועד לכם שמה׃ ");
INSERT INTO heb_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","והיה האיש אשר אבחר בו מטהו יפרח והשכתי מעלי את תלנות בני ישראל אשר הם מלינם עליכם׃ ");
INSERT INTO heb_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","וידבר משה אל בני ישראל ויתנו אליו כל נשיאיהם מטה לנשיא אחד מטה לנשיא אחד לבית אבתם שנים עשר מטות ומטה אהרן בתוך מטותם׃ ");
INSERT INTO heb_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","וינח משה את המטת לפני יהוה באהל העדת׃ ");
INSERT INTO heb_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","ויהי ממחרת ויבא משה אל אהל העדות והנה פרח מטה אהרן לבית לוי ויצא פרח ויצץ ציץ ויגמל שקדים׃ ");
INSERT INTO heb_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","ויצא משה את כל המטת מלפני יהוה אל כל בני ישראל ויראו ויקחו איש מטהו׃ ");
INSERT INTO heb_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","ויאמר יהוה אל משה השב את מטה אהרן לפני העדות למשמרת לאות לבני מרי ותכל תלונתם מעלי ולא ימתו׃ ");
INSERT INTO heb_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","ויעש משה כאשר צוה יהוה אתו כן עשה׃ ");
INSERT INTO heb_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","ויאמרו בני ישראל אל משה לאמר הן גוענו אבדנו כלנו אבדנו׃ ");
INSERT INTO heb_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","כל הקרב הקרב אל משכן יהוה ימות האם תמנו לגוע׃ ");
INSERT INTO heb_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","ויאמר יהוה אל אהרן אתה ובניך ובית אביך אתך תשאו את עון המקדש ואתה ובניך אתך תשאו את עון כהנתכם׃ ");
INSERT INTO heb_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","וגם את אחיך מטה לוי שבט אביך הקרב אתך וילוו עליך וישרתוך ואתה ובניך אתך לפני אהל העדת׃ ");
INSERT INTO heb_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","ושמרו משמרתך ומשמרת כל האהל אך אל כלי הקדש ואל המזבח לא יקרבו ולא ימתו גם הם גם אתם׃ ");
INSERT INTO heb_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","ונלוו עליך ושמרו את משמרת אהל מועד לכל עבדת האהל וזר לא יקרב אליכם׃ ");
INSERT INTO heb_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","ושמרתם את משמרת הקדש ואת משמרת המזבח ולא יהיה עוד קצף על בני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","ואני הנה לקחתי את אחיכם הלוים מתוך בני ישראל לכם מתנה נתנים ליהוה לעבד את עבדת אהל מועד׃ ");
INSERT INTO heb_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","ואתה ובניך אתך תשמרו את כהנתכם לכל דבר המזבח ולמבית לפרכת ועבדתם עבדת מתנה אתן את כהנתכם והזר הקרב יומת׃ ");
INSERT INTO heb_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","וידבר יהוה אל אהרן ואני הנה נתתי לך את משמרת תרומתי לכל קדשי בני ישראל לך נתתים למשחה ולבניך לחק עולם׃ ");
INSERT INTO heb_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","זה יהיה לך מקדש הקדשים מן האש כל קרבנם לכל מנחתם ולכל חטאתם ולכל אשמם אשר ישיבו לי קדש קדשים לך הוא ולבניך׃ ");
INSERT INTO heb_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","בקדש הקדשים תאכלנו כל זכר יאכל אתו קדש יהיה לך׃ ");
INSERT INTO heb_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","וזה לך תרומת מתנם לכל תנופת בני ישראל לך נתתים ולבניך ולבנתיך אתך לחק עולם כל טהור בביתך יאכל אתו׃ ");
INSERT INTO heb_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","כל חלב יצהר וכל חלב תירוש ודגן ראשיתם אשר יתנו ליהוה לך נתתים׃ ");
INSERT INTO heb_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","בכורי כל אשר בארצם אשר יביאו ליהוה לך יהיה כל טהור בביתך יאכלנו׃ ");
INSERT INTO heb_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","כל חרם בישראל לך יהיה׃ ");
INSERT INTO heb_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","כל פטר רחם לכל בשר אשר יקריבו ליהוה באדם ובבהמה יהיה לך אך פדה תפדה את בכור האדם ואת בכור הבהמה הטמאה תפדה׃ ");
INSERT INTO heb_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","ופדויו מבן חדש תפדה בערכך כסף חמשת שקלים בשקל הקדש עשרים גרה הוא׃ ");
INSERT INTO heb_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","אך בכור שור או בכור כשב או בכור עז לא תפדה קדש הם את דמם תזרק על המזבח ואת חלבם תקטיר אשה לריח ניחח ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","ובשרם יהיה לך כחזה התנופה וכשוק הימין לך יהיה׃ ");
INSERT INTO heb_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","כל תרומת הקדשים אשר ירימו בני ישראל ליהוה נתתי לך ולבניך ולבנתיך אתך לחק עולם ברית מלח עולם הוא לפני יהוה לך ולזרעך אתך׃ ");
INSERT INTO heb_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","ויאמר יהוה אל אהרן בארצם לא תנחל וחלק לא יהיה לך בתוכם אני חלקך ונחלתך בתוך בני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","ולבני לוי הנה נתתי כל מעשר בישראל לנחלה חלף עבדתם אשר הם עבדים את עבדת אהל מועד׃ ");
INSERT INTO heb_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","ולא יקרבו עוד בני ישראל אל אהל מועד לשאת חטא למות׃ ");
INSERT INTO heb_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","ועבד הלוי הוא את עבדת אהל מועד והם ישאו עונם חקת עולם לדרתיכם ובתוך בני ישראל לא ינחלו נחלה׃ ");
INSERT INTO heb_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","כי את מעשר בני ישראל אשר ירימו ליהוה תרומה נתתי ללוים לנחלה על כן אמרתי להם בתוך בני ישראל לא ינחלו נחלה׃ ");
INSERT INTO heb_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","ואל הלוים תדבר ואמרת אלהם כי תקחו מאת בני ישראל את המעשר אשר נתתי לכם מאתם בנחלתכם והרמתם ממנו תרומת יהוה מעשר מן המעשר׃ ");
INSERT INTO heb_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","ונחשב לכם תרומתכם כדגן מן הגרן וכמלאה מן היקב׃ ");
INSERT INTO heb_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","כן תרימו גם אתם תרומת יהוה מכל מעשרתיכם אשר תקחו מאת בני ישראל ונתתם ממנו את תרומת יהוה לאהרן הכהן׃ ");
INSERT INTO heb_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","מכל מתנתיכם תרימו את כל תרומת יהוה מכל חלבו את מקדשו ממנו׃ ");
INSERT INTO heb_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","ואמרת אלהם בהרימכם את חלבו ממנו ונחשב ללוים כתבואת גרן וכתבואת יקב׃ ");
INSERT INTO heb_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","ואכלתם אתו בכל מקום אתם וביתכם כי שכר הוא לכם חלף עבדתכם באהל מועד׃ ");
INSERT INTO heb_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","ולא תשאו עליו חטא בהרימכם את חלבו ממנו ואת קדשי בני ישראל לא תחללו ולא תמותו׃ ");
INSERT INTO heb_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","וידבר יהוה אל משה ואל אהרן לאמר׃ ");
INSERT INTO heb_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","זאת חקת התורה אשר צוה יהוה לאמר דבר אל בני ישראל ויקחו אליך פרה אדמה תמימה אשר אין בה מום אשר לא עלה עליה על׃ ");
INSERT INTO heb_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","ונתתם אתה אל אלעזר הכהן והוציא אתה אל מחוץ למחנה ושחט אתה לפניו׃ ");
INSERT INTO heb_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","ולקח אלעזר הכהן מדמה באצבעו והזה אל נכח פני אהל מועד מדמה שבע פעמים׃ ");
INSERT INTO heb_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","ושרף את הפרה לעיניו את ערה ואת בשרה ואת דמה על פרשה ישרף׃ ");
INSERT INTO heb_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","ולקח הכהן עץ ארז ואזוב ושני תולעת והשליך אל תוך שרפת הפרה׃ ");
INSERT INTO heb_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","וכבס בגדיו הכהן ורחץ בשרו במים ואחר יבוא אל המחנה וטמא הכהן עד הערב׃ ");
INSERT INTO heb_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","והשרף אתה יכבס בגדיו במים ורחץ בשרו במים וטמא עד הערב׃ ");
INSERT INTO heb_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","ואסף איש טהור את אפר הפרה והניח מחוץ למחנה במקום טהור והיתה לעדת בני ישראל למשמרת למי נדה חטאת הוא׃ ");
INSERT INTO heb_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","וכבס האסף את אפר הפרה את בגדיו וטמא עד הערב והיתה לבני ישראל ולגר הגר בתוכם לחקת עולם׃ ");
INSERT INTO heb_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","הנגע במת לכל נפש אדם וטמא שבעת ימים׃ ");
INSERT INTO heb_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","הוא יתחטא בו ביום השלישי וביום השביעי יטהר ואם לא יתחטא ביום השלישי וביום השביעי לא יטהר׃ ");
INSERT INTO heb_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","כל הנגע במת בנפש האדם אשר ימות ולא יתחטא את משכן יהוה טמא ונכרתה הנפש ההוא מישראל כי מי נדה לא זרק עליו טמא יהיה עוד טמאתו בו׃ ");
INSERT INTO heb_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","זאת התורה אדם כי ימות באהל כל הבא אל האהל וכל אשר באהל יטמא שבעת ימים׃ ");
INSERT INTO heb_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","וכל כלי פתוח אשר אין צמיד פתיל עליו טמא הוא׃ ");
INSERT INTO heb_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","וכל אשר יגע על פני השדה בחלל חרב או במת או בעצם אדם או בקבר יטמא שבעת ימים׃ ");
INSERT INTO heb_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","ולקחו לטמא מעפר שרפת החטאת ונתן עליו מים חיים אל כלי׃ ");
INSERT INTO heb_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","ולקח אזוב וטבל במים איש טהור והזה על האהל ועל כל הכלים ועל הנפשות אשר היו שם ועל הנגע בעצם או בחלל או במת או בקבר׃ ");
INSERT INTO heb_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","והזה הטהר על הטמא ביום השלישי וביום השביעי וחטאו ביום השביעי וכבס בגדיו ורחץ במים וטהר בערב׃ ");
INSERT INTO heb_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","ואיש אשר יטמא ולא יתחטא ונכרתה הנפש ההוא מתוך הקהל כי את מקדש יהוה טמא מי נדה לא זרק עליו טמא הוא׃ ");
INSERT INTO heb_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","והיתה להם לחקת עולם ומזה מי הנדה יכבס בגדיו והנגע במי הנדה יטמא עד הערב׃ ");
INSERT INTO heb_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","וכל אשר יגע בו הטמא יטמא והנפש הנגעת תטמא עד הערב׃ ");
INSERT INTO heb_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","ויבאו בני ישראל כל העדה מדבר צן בחדש הראשון וישב העם בקדש ותמת שם מרים ותקבר שם׃ ");
INSERT INTO heb_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","ולא היה מים לעדה ויקהלו על משה ועל אהרן׃ ");
INSERT INTO heb_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","וירב העם עם משה ויאמרו לאמר ולו גוענו בגוע אחינו לפני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","ולמה הבאתם את קהל יהוה אל המדבר הזה למות שם אנחנו ובעירנו׃ ");
INSERT INTO heb_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","ולמה העליתנו ממצרים להביא אתנו אל המקום הרע הזה לא מקום זרע ותאנה וגפן ורמון ומים אין לשתות׃ ");
INSERT INTO heb_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","ויבא משה ואהרן מפני הקהל אל פתח אהל מועד ויפלו על פניהם וירא כבוד יהוה אליהם׃ ");
INSERT INTO heb_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","קח את המטה והקהל את העדה אתה ואהרן אחיך ודברתם אל הסלע לעיניהם ונתן מימיו והוצאת להם מים מן הסלע והשקית את העדה ואת בעירם׃ ");
INSERT INTO heb_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","ויקח משה את המטה מלפני יהוה כאשר צוהו׃ ");
INSERT INTO heb_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","ויקהלו משה ואהרן את הקהל אל פני הסלע ויאמר להם שמעו נא המרים המן הסלע הזה נוציא לכם מים׃ ");
INSERT INTO heb_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","וירם משה את ידו ויך את הסלע במטהו פעמים ויצאו מים רבים ותשת העדה ובעירם׃ ");
INSERT INTO heb_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","ויאמר יהוה אל משה ואל אהרן יען לא האמנתם בי להקדישני לעיני בני ישראל לכן לא תביאו את הקהל הזה אל הארץ אשר נתתי להם׃ ");
INSERT INTO heb_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","המה מי מריבה אשר רבו בני ישראל את יהוה ויקדש בם׃ ");
INSERT INTO heb_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","וישלח משה מלאכים מקדש אל מלך אדום כה אמר אחיך ישראל אתה ידעת את כל התלאה אשר מצאתנו׃ ");
INSERT INTO heb_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","וירדו אבתינו מצרימה ונשב במצרים ימים רבים וירעו לנו מצרים ולאבתינו׃ ");
INSERT INTO heb_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","ונצעק אל יהוה וישמע קלנו וישלח מלאך ויצאנו ממצרים והנה אנחנו בקדש עיר קצה גבולך׃ ");
INSERT INTO heb_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","נעברה נא בארצך לא נעבר בשדה ובכרם ולא נשתה מי באר דרך המלך נלך לא נטה ימין ושמאול עד אשר נעבר גבולך׃ ");
INSERT INTO heb_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","ויאמר אליו אדום לא תעבר בי פן בחרב אצא לקראתך׃ ");
INSERT INTO heb_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","ויאמרו אליו בני ישראל במסלה נעלה ואם מימיך נשתה אני ומקני ונתתי מכרם רק אין דבר ברגלי אעברה׃ ");
INSERT INTO heb_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","ויאמר לא תעבר ויצא אדום לקראתו בעם כבד וביד חזקה׃ ");
INSERT INTO heb_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","וימאן אדום נתן את ישראל עבר בגבלו ויט ישראל מעליו׃ ");
INSERT INTO heb_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","ויסעו מקדש ויבאו בני ישראל כל העדה הר ההר׃ ");
INSERT INTO heb_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","ויאמר יהוה אל משה ואל אהרן בהר ההר על גבול ארץ אדום לאמר׃ ");
INSERT INTO heb_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","יאסף אהרן אל עמיו כי לא יבא אל הארץ אשר נתתי לבני ישראל על אשר מריתם את פי למי מריבה׃ ");
INSERT INTO heb_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","קח את אהרן ואת אלעזר בנו והעל אתם הר ההר׃ ");
INSERT INTO heb_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","והפשט את אהרן את בגדיו והלבשתם את אלעזר בנו ואהרן יאסף ומת שם׃ ");
INSERT INTO heb_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","ויעש משה כאשר צוה יהוה ויעלו אל הר ההר לעיני כל העדה׃ ");
INSERT INTO heb_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","ויפשט משה את אהרן את בגדיו וילבש אתם את אלעזר בנו וימת אהרן שם בראש ההר וירד משה ואלעזר מן ההר׃ ");
INSERT INTO heb_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","ויראו כל העדה כי גוע אהרן ויבכו את אהרן שלשים יום כל בית ישראל׃ ");
INSERT INTO heb_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","וישמע הכנעני מלך ערד ישב הנגב כי בא ישראל דרך האתרים וילחם בישראל וישב ממנו שבי׃ ");
INSERT INTO heb_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","וידר ישראל נדר ליהוה ויאמר אם נתן תתן את העם הזה בידי והחרמתי את עריהם׃ ");
INSERT INTO heb_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","וישמע יהוה בקול ישראל ויתן את הכנעני ויחרם אתהם ואת עריהם ויקרא שם המקום חרמה׃ ");
INSERT INTO heb_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","ויסעו מהר ההר דרך ים סוף לסבב את ארץ אדום ותקצר נפש העם בדרך׃ ");
INSERT INTO heb_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","וידבר העם באלהים ובמשה למה העליתנו ממצרים למות במדבר כי אין לחם ואין מים ונפשנו קצה בלחם הקלקל׃ ");
INSERT INTO heb_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","וישלח יהוה בעם את הנחשים השרפים וינשכו את העם וימת עם רב מישראל׃ ");
INSERT INTO heb_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","ויבא העם אל משה ויאמרו חטאנו כי דברנו ביהוה ובך התפלל אל יהוה ויסר מעלינו את הנחש ויתפלל משה בעד העם׃ ");
INSERT INTO heb_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","ויאמר יהוה אל משה עשה לך שרף ושים אתו על נס והיה כל הנשוך וראה אתו וחי׃ ");
INSERT INTO heb_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","ויעש משה נחש נחשת וישמהו על הנס והיה אם נשך הנחש את איש והביט אל נחש הנחשת וחי׃ ");
INSERT INTO heb_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","ויסעו בני ישראל ויחנו באבת׃ ");
INSERT INTO heb_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","ויסעו מאבת ויחנו בעיי העברים במדבר אשר על פני מואב ממזרח השמש׃ ");
INSERT INTO heb_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","משם נסעו ויחנו בנחל זרד׃ ");
INSERT INTO heb_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","משם נסעו ויחנו מעבר ארנון אשר במדבר היצא מגבול האמרי כי ארנון גבול מואב בין מואב ובין האמרי׃ ");
INSERT INTO heb_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","על כן יאמר בספר מלחמת יהוה את והב בסופה ואת הנחלים ארנון׃ ");
INSERT INTO heb_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","ואשד הנחלים אשר נטה לשבת ער ונשען לגבול מואב׃ ");
INSERT INTO heb_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","ומשם בארה הוא הבאר אשר אמר יהוה למשה אסף את העם ואתנה להם מים׃ ");
INSERT INTO heb_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","אז ישיר ישראל את השירה הזאת עלי באר ענו לה׃ ");
INSERT INTO heb_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","באר חפרוה שרים כרוה נדיבי העם במחקק במשענתם וממדבר מתנה׃ ");
INSERT INTO heb_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","וממתנה נחליאל ומנחליאל במות׃ ");
INSERT INTO heb_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","ומבמות הגיא אשר בשדה מואב ראש הפסגה ונשקפה על פני הישימן׃ ");
INSERT INTO heb_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","וישלח ישראל מלאכים אל סיחן מלך האמרי לאמר׃ ");
INSERT INTO heb_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","אעברה בארצך לא נטה בשדה ובכרם לא נשתה מי באר בדרך המלך נלך עד אשר נעבר גבלך׃ ");
INSERT INTO heb_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","ולא נתן סיחן את ישראל עבר בגבלו ויאסף סיחן את כל עמו ויצא לקראת ישראל המדברה ויבא יהצה וילחם בישראל׃ ");
INSERT INTO heb_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","ויכהו ישראל לפי חרב ויירש את ארצו מארנן עד יבק עד בני עמון כי עז גבול בני עמון׃ ");
INSERT INTO heb_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","ויקח ישראל את כל הערים האלה וישב ישראל בכל ערי האמרי בחשבון ובכל בנתיה׃ ");
INSERT INTO heb_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","כי חשבון עיר סיחן מלך האמרי הוא והוא נלחם במלך מואב הראשון ויקח את כל ארצו מידו עד ארנן׃ ");
INSERT INTO heb_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","על כן יאמרו המשלים באו חשבון תבנה ותכונן עיר סיחון׃ ");
INSERT INTO heb_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","כי אש יצאה מחשבון להבה מקרית סיחן אכלה ער מואב בעלי במות ארנן׃ ");
INSERT INTO heb_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","אוי לך מואב אבדת עם כמוש נתן בניו פליטם ובנתיו בשבית למלך אמרי סיחון׃ ");
INSERT INTO heb_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","ונירם אבד חשבון עד דיבון ונשים עד נפח אשר עד מידבא׃ ");
INSERT INTO heb_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","וישב ישראל בארץ האמרי׃ ");
INSERT INTO heb_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","וישלח משה לרגל את יעזר וילכדו בנתיה ויירש את האמרי אשר שם׃ ");
INSERT INTO heb_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","ויפנו ויעלו דרך הבשן ויצא עוג מלך הבשן לקראתם הוא וכל עמו למלחמה אדרעי׃ ");
INSERT INTO heb_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","ויאמר יהוה אל משה אל תירא אתו כי בידך נתתי אתו ואת כל עמו ואת ארצו ועשית לו כאשר עשית לסיחן מלך האמרי אשר יושב בחשבון׃ ");
INSERT INTO heb_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","ויכו אתו ואת בניו ואת כל עמו עד בלתי השאיר לו שריד ויירשו את ארצו׃ ");
INSERT INTO heb_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","ויסעו בני ישראל ויחנו בערבות מואב מעבר לירדן ירחו׃ ");
INSERT INTO heb_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","וירא בלק בן צפור את כל אשר עשה ישראל לאמרי׃ ");
INSERT INTO heb_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","ויגר מואב מפני העם מאד כי רב הוא ויקץ מואב מפני בני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","ויאמר מואב אל זקני מדין עתה ילחכו הקהל את כל סביבתינו כלחך השור את ירק השדה ובלק בן צפור מלך למואב בעת ההוא׃ ");
INSERT INTO heb_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","וישלח מלאכים אל בלעם בן בעור פתורה אשר על הנהר ארץ בני עמו לקרא לו לאמר הנה עם יצא ממצרים הנה כסה את עין הארץ והוא ישב ממלי׃ ");
INSERT INTO heb_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","ועתה לכה נא ארה לי את העם הזה כי עצום הוא ממני אולי אוכל נכה בו ואגרשנו מן הארץ כי ידעתי את אשר תברך מברך ואשר תאר יואר׃ ");
INSERT INTO heb_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","וילכו זקני מואב וזקני מדין וקסמים בידם ויבאו אל בלעם וידברו אליו דברי בלק׃ ");
INSERT INTO heb_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","ויאמר אליהם לינו פה הלילה והשבתי אתכם דבר כאשר ידבר יהוה אלי וישבו שרי מואב עם בלעם׃ ");
INSERT INTO heb_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","ויבא אלהים אל בלעם ויאמר מי האנשים האלה עמך׃ ");
INSERT INTO heb_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","ויאמר בלעם אל האלהים בלק בן צפר מלך מואב שלח אלי׃ ");
INSERT INTO heb_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","הנה העם היצא ממצרים ויכס את עין הארץ עתה לכה קבה לי אתו אולי אוכל להלחם בו וגרשתיו׃ ");
INSERT INTO heb_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","ויאמר אלהים אל בלעם לא תלך עמהם לא תאר את העם כי ברוך הוא׃ ");
INSERT INTO heb_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","ויקם בלעם בבקר ויאמר אל שרי בלק לכו אל ארצכם כי מאן יהוה לתתי להלך עמכם׃ ");
INSERT INTO heb_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","ויקומו שרי מואב ויבאו אל בלק ויאמרו מאן בלעם הלך עמנו׃ ");
INSERT INTO heb_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","ויסף עוד בלק שלח שרים רבים ונכבדים מאלה׃ ");
INSERT INTO heb_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","ויבאו אל בלעם ויאמרו לו כה אמר בלק בן צפור אל נא תמנע מהלך אלי׃ ");
INSERT INTO heb_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","כי כבד אכבדך מאד וכל אשר תאמר אלי אעשה ולכה נא קבה לי את העם הזה׃ ");
INSERT INTO heb_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","ויען בלעם ויאמר אל עבדי בלק אם יתן לי בלק מלא ביתו כסף וזהב לא אוכל לעבר את פי יהוה אלהי לעשות קטנה או גדולה׃ ");
INSERT INTO heb_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","ועתה שבו נא בזה גם אתם הלילה ואדעה מה יסף יהוה דבר עמי׃ ");
INSERT INTO heb_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","ויבא אלהים אל בלעם לילה ויאמר לו אם לקרא לך באו האנשים קום לך אתם ואך את הדבר אשר אדבר אליך אתו תעשה׃ ");
INSERT INTO heb_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","ויקם בלעם בבקר ויחבש את אתנו וילך עם שרי מואב׃ ");
INSERT INTO heb_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","ויחר אף אלהים כי הולך הוא ויתיצב מלאך יהוה בדרך לשטן לו והוא רכב על אתנו ושני נעריו עמו׃ ");
INSERT INTO heb_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","ותרא האתון את מלאך יהוה נצב בדרך וחרבו שלופה בידו ותט האתון מן הדרך ותלך בשדה ויך בלעם את האתון להטתה הדרך׃ ");
INSERT INTO heb_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","ויעמד מלאך יהוה במשעול הכרמים גדר מזה וגדר מזה׃ ");
INSERT INTO heb_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","ותרא האתון את מלאך יהוה ותלחץ אל הקיר ותלחץ את רגל בלעם אל הקיר ויסף להכתה׃ ");
INSERT INTO heb_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","ויוסף מלאך יהוה עבור ויעמד במקום צר אשר אין דרך לנטות ימין ושמאול׃ ");
INSERT INTO heb_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","ותרא האתון את מלאך יהוה ותרבץ תחת בלעם ויחר אף בלעם ויך את האתון במקל׃ ");
INSERT INTO heb_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","ויפתח יהוה את פי האתון ותאמר לבלעם מה עשיתי לך כי הכיתני זה שלש רגלים׃ ");
INSERT INTO heb_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","ויאמר בלעם לאתון כי התעללת בי לו יש חרב בידי כי עתה הרגתיך׃ ");
INSERT INTO heb_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","ותאמר האתון אל בלעם הלוא אנכי אתנך אשר רכבת עלי מעודך עד היום הזה ההסכן הסכנתי לעשות לך כה ויאמר לא׃ ");
INSERT INTO heb_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","ויגל יהוה את עיני בלעם וירא את מלאך יהוה נצב בדרך וחרבו שלפה בידו ויקד וישתחו לאפיו׃ ");
INSERT INTO heb_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","ויאמר אליו מלאך יהוה על מה הכית את אתנך זה שלוש רגלים הנה אנכי יצאתי לשטן כי ירט הדרך לנגדי׃ ");
INSERT INTO heb_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","ותראני האתון ותט לפני זה שלש רגלים אולי נטתה מפני כי עתה גם אתכה הרגתי ואותה החייתי׃ ");
INSERT INTO heb_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","ויאמר בלעם אל מלאך יהוה חטאתי כי לא ידעתי כי אתה נצב לקראתי בדרך ועתה אם רע בעיניך אשובה לי׃ ");
INSERT INTO heb_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","ויאמר מלאך יהוה אל בלעם לך עם האנשים ואפס את הדבר אשר אדבר אליך אתו תדבר וילך בלעם עם שרי בלק׃ ");
INSERT INTO heb_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","וישמע בלק כי בא בלעם ויצא לקראתו אל עיר מואב אשר על גבול ארנן אשר בקצה הגבול׃ ");
INSERT INTO heb_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","ויאמר בלק אל בלעם הלא שלח שלחתי אליך לקרא לך למה לא הלכת אלי האמנם לא אוכל כבדך׃ ");
INSERT INTO heb_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","ויאמר בלעם אל בלק הנה באתי אליך עתה היכול אוכל דבר מאומה הדבר אשר ישים אלהים בפי אתו אדבר׃ ");
INSERT INTO heb_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","וילך בלעם עם בלק ויבאו קרית חצות׃ ");
INSERT INTO heb_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","ויזבח בלק בקר וצאן וישלח לבלעם ולשרים אשר אתו׃ ");
INSERT INTO heb_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","ויהי בבקר ויקח בלק את בלעם ויעלהו במות בעל וירא משם קצה העם׃ ");
INSERT INTO heb_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","ויאמר בלעם אל בלק בנה לי בזה שבעה מזבחת והכן לי בזה שבעה פרים ושבעה אילים׃ ");
INSERT INTO heb_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","ויעש בלק כאשר דבר בלעם ויעל בלק ובלעם פר ואיל במזבח׃ ");
INSERT INTO heb_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","ויאמר בלעם לבלק התיצב על עלתך ואלכה אולי יקרה יהוה לקראתי ודבר מה יראני והגדתי לך וילך שפי׃ ");
INSERT INTO heb_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","ויקר אלהים אל בלעם ויאמר אליו את שבעת המזבחת ערכתי ואעל פר ואיל במזבח׃ ");
INSERT INTO heb_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","וישם יהוה דבר בפי בלעם ויאמר שוב אל בלק וכה תדבר׃ ");
INSERT INTO heb_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","וישב אליו והנה נצב על עלתו הוא וכל שרי מואב׃ ");
INSERT INTO heb_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","וישא משלו ויאמר מן ארם ינחני בלק מלך מואב מהררי קדם לכה ארה לי יעקב ולכה זעמה ישראל׃ ");
INSERT INTO heb_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","מה אקב לא קבה אל ומה אזעם לא זעם יהוה׃ ");
INSERT INTO heb_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","כי מראש צרים אראנו ומגבעות אשורנו הן עם לבדד ישכן ובגוים לא יתחשב׃ ");
INSERT INTO heb_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","מי מנה עפר יעקב ומספר את רבע ישראל תמת נפשי מות ישרים ותהי אחריתי כמהו׃ ");
INSERT INTO heb_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","ויאמר בלק אל בלעם מה עשית לי לקב איבי לקחתיך והנה ברכת ברך׃ ");
INSERT INTO heb_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","ויען ויאמר הלא את אשר ישים יהוה בפי אתו אשמר לדבר׃ ");
INSERT INTO heb_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","ויאמר אליו בלק לך נא אתי אל מקום אחר אשר תראנו משם אפס קצהו תראה וכלו לא תראה וקבנו לי משם׃ ");
INSERT INTO heb_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","ויקחהו שדה צפים אל ראש הפסגה ויבן שבעה מזבחת ויעל פר ואיל במזבח׃ ");
INSERT INTO heb_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","ויאמר אל בלק התיצב כה על עלתך ואנכי אקרה כה׃ ");
INSERT INTO heb_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","ויקר יהוה אל בלעם וישם דבר בפיו ויאמר שוב אל בלק וכה תדבר׃ ");
INSERT INTO heb_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","ויבא אליו והנו נצב על עלתו ושרי מואב אתו ויאמר לו בלק מה דבר יהוה׃ ");
INSERT INTO heb_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","וישא משלו ויאמר קום בלק ושמע האזינה עדי בנו צפר׃ ");
INSERT INTO heb_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","לא איש אל ויכזב ובן אדם ויתנחם ההוא אמר ולא יעשה ודבר ולא יקימנה׃ ");
INSERT INTO heb_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","הנה ברך לקחתי וברך ולא אשיבנה׃ ");
INSERT INTO heb_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","לא הביט און ביעקב ולא ראה עמל בישראל יהוה אלהיו עמו ותרועת מלך בו׃ ");
INSERT INTO heb_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","אל מוציאם ממצרים כתועפת ראם לו׃ ");
INSERT INTO heb_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","כי לא נחש ביעקב ולא קסם בישראל כעת יאמר ליעקב ולישראל מה פעל אל׃ ");
INSERT INTO heb_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","הן עם כלביא יקום וכארי יתנשא לא ישכב עד יאכל טרף ודם חללים ישתה׃ ");
INSERT INTO heb_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","ויאמר בלק אל בלעם גם קב לא תקבנו גם ברך לא תברכנו׃ ");
INSERT INTO heb_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","ויען בלעם ויאמר אל בלק הלא דברתי אליך לאמר כל אשר ידבר יהוה אתו אעשה׃ ");
INSERT INTO heb_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","ויאמר בלק אל בלעם לכה נא אקחך אל מקום אחר אולי יישר בעיני האלהים וקבתו לי משם׃ ");
INSERT INTO heb_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","ויקח בלק את בלעם ראש הפעור הנשקף על פני הישימן׃ ");
INSERT INTO heb_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","ויאמר בלעם אל בלק בנה לי בזה שבעה מזבחת והכן לי בזה שבעה פרים ושבעה אילים׃ ");
INSERT INTO heb_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","ויעש בלק כאשר אמר בלעם ויעל פר ואיל במזבח׃ ");
INSERT INTO heb_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","וירא בלעם כי טוב בעיני יהוה לברך את ישראל ולא הלך כפעם בפעם לקראת נחשים וישת אל המדבר פניו׃ ");
INSERT INTO heb_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","וישא בלעם את עיניו וירא את ישראל שכן לשבטיו ותהי עליו רוח אלהים׃ ");
INSERT INTO heb_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","וישא משלו ויאמר נאם בלעם בנו בער ונאם הגבר שתם העין׃ ");
INSERT INTO heb_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","נאם שמע אמרי אל אשר מחזה שדי יחזה נפל וגלוי עינים׃ ");
INSERT INTO heb_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","מה טבו אהליך יעקב משכנתיך ישראל׃ ");
INSERT INTO heb_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","כנחלים נטיו כגנת עלי נהר כאהלים נטע יהוה כארזים עלי מים׃ ");
INSERT INTO heb_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","יזל מים מדליו וזרעו במים רבים וירם מאגג מלכו ותנשא מלכתו׃ ");
INSERT INTO heb_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","אל מוציאו ממצרים כתועפת ראם לו יאכל גוים צריו ועצמתיהם יגרם וחציו ימחץ׃ ");
INSERT INTO heb_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","כרע שכב כארי וכלביא מי יקימנו מברכיך ברוך וארריך ארור׃ ");
INSERT INTO heb_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","ויחר אף בלק אל בלעם ויספק את כפיו ויאמר בלק אל בלעם לקב איבי קראתיך והנה ברכת ברך זה שלש פעמים׃ ");
INSERT INTO heb_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","ועתה ברח לך אל מקומך אמרתי כבד אכבדך והנה מנעך יהוה מכבוד׃ ");
INSERT INTO heb_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","ויאמר בלעם אל בלק הלא גם אל מלאכיך אשר שלחת אלי דברתי לאמר׃ ");
INSERT INTO heb_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","אם יתן לי בלק מלא ביתו כסף וזהב לא אוכל לעבר את פי יהוה לעשות טובה או רעה מלבי אשר ידבר יהוה אתו אדבר׃ ");
INSERT INTO heb_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","ועתה הנני הולך לעמי לכה איעצך אשר יעשה העם הזה לעמך באחרית הימים׃ ");
INSERT INTO heb_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","וישא משלו ויאמר נאם בלעם בנו בער ונאם הגבר שתם העין׃ ");
INSERT INTO heb_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","נאם שמע אמרי אל וידע דעת עליון מחזה שדי יחזה נפל וגלוי עינים׃ ");
INSERT INTO heb_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","אראנו ולא עתה אשורנו ולא קרוב דרך כוכב מיעקב וקם שבט מישראל ומחץ פאתי מואב וקרקר כל בני שת׃ ");
INSERT INTO heb_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","והיה אדום ירשה והיה ירשה שעיר איביו וישראל עשה חיל׃ ");
INSERT INTO heb_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","וירד מיעקב והאביד שריד מעיר׃ ");
INSERT INTO heb_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","וירא את עמלק וישא משלו ויאמר ראשית גוים עמלק ואחריתו עדי אבד׃ ");
INSERT INTO heb_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","וירא את הקיני וישא משלו ויאמר איתן מושבך ושים בסלע קנך׃ ");
INSERT INTO heb_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","כי אם יהיה לבער קין עד מה אשור תשבך׃ ");
INSERT INTO heb_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","וישא משלו ויאמר אוי מי יחיה משמו אל׃ ");
INSERT INTO heb_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","וצים מיד כתים וענו אשור וענו עבר וגם הוא עדי אבד׃ ");
INSERT INTO heb_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","ויקם בלעם וילך וישב למקמו וגם בלק הלך לדרכו׃ ");
INSERT INTO heb_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","וישב ישראל בשטים ויחל העם לזנות אל בנות מואב׃ ");
INSERT INTO heb_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","ותקראן לעם לזבחי אלהיהן ויאכל העם וישתחוו לאלהיהן׃ ");
INSERT INTO heb_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","ויצמד ישראל לבעל פעור ויחר אף יהוה בישראל׃ ");
INSERT INTO heb_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","ויאמר יהוה אל משה קח את כל ראשי העם והוקע אותם ליהוה נגד השמש וישב חרון אף יהוה מישראל׃ ");
INSERT INTO heb_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","ויאמר משה אל שפטי ישראל הרגו איש אנשיו הנצמדים לבעל פעור׃ ");
INSERT INTO heb_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","והנה איש מבני ישראל בא ויקרב אל אחיו את המדינית לעיני משה ולעיני כל עדת בני ישראל והמה בכים פתח אהל מועד׃ ");
INSERT INTO heb_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","וירא פינחס בן אלעזר בן אהרן הכהן ויקם מתוך העדה ויקח רמח בידו׃ ");
INSERT INTO heb_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","ויבא אחר איש ישראל אל הקבה וידקר את שניהם את איש ישראל ואת האשה אל קבתה ותעצר המגפה מעל בני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","ויהיו המתים במגפה ארבעה ועשרים אלף׃ ");
INSERT INTO heb_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","פינחס בן אלעזר בן אהרן הכהן השיב את חמתי מעל בני ישראל בקנאו את קנאתי בתוכם ולא כליתי את בני ישראל בקנאתי׃ ");
INSERT INTO heb_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","לכן אמר הנני נתן לו את בריתי שלום׃ ");
INSERT INTO heb_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","והיתה לו ולזרעו אחריו ברית כהנת עולם תחת אשר קנא לאלהיו ויכפר על בני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","ושם איש ישראל המכה אשר הכה את המדינית זמרי בן סלוא נשיא בית אב לשמעני׃ ");
INSERT INTO heb_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","ושם האשה המכה המדינית כזבי בת צור ראש אמות בית אב במדין הוא׃ ");
INSERT INTO heb_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","צרור את המדינים והכיתם אותם׃ ");
INSERT INTO heb_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","כי צררים הם לכם בנכליהם אשר נכלו לכם על דבר פעור ועל דבר כזבי בת נשיא מדין אחתם המכה ביום המגפה על דבר פעור׃ ");
INSERT INTO heb_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","ויהי אחרי המגפה ויאמר יהוה אל משה ואל אלעזר בן אהרן הכהן לאמר׃ ");
INSERT INTO heb_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","שאו את ראש כל עדת בני ישראל מבן עשרים שנה ומעלה לבית אבתם כל יצא צבא בישראל׃ ");
INSERT INTO heb_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","וידבר משה ואלעזר הכהן אתם בערבת מואב על ירדן ירחו לאמר׃ ");
INSERT INTO heb_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","מבן עשרים שנה ומעלה כאשר צוה יהוה את משה ובני ישראל היצאים מארץ מצרים׃ ");
INSERT INTO heb_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","ראובן בכור ישראל בני ראובן חנוך משפחת החנכי לפלוא משפחת הפלאי׃ ");
INSERT INTO heb_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","לחצרן משפחת החצרוני לכרמי משפחת הכרמי׃ ");
INSERT INTO heb_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","אלה משפחת הראובני ויהיו פקדיהם שלשה וארבעים אלף ושבע מאות ושלשים׃ ");
INSERT INTO heb_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","ובני פלוא אליאב׃ ");
INSERT INTO heb_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","ובני אליאב נמואל ודתן ואבירם הוא דתן ואבירם קרואי העדה אשר הצו על משה ועל אהרן בעדת קרח בהצתם על יהוה׃ ");
INSERT INTO heb_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","ותפתח הארץ את פיה ותבלע אתם ואת קרח במות העדה באכל האש את חמשים ומאתים איש ויהיו לנס׃ ");
INSERT INTO heb_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","ובני קרח לא מתו׃ ");
INSERT INTO heb_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","בני שמעון למשפחתם לנמואל משפחת הנמואלי לימין משפחת הימיני ליכין משפחת היכיני׃ ");
INSERT INTO heb_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","לזרח משפחת הזרחי לשאול משפחת השאולי׃ ");
INSERT INTO heb_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","אלה משפחת השמעני שנים ועשרים אלף ומאתים׃ ");
INSERT INTO heb_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","בני גד למשפחתם לצפון משפחת הצפוני לחגי משפחת החגי לשוני משפחת השוני׃ ");
INSERT INTO heb_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","לאזני משפחת האזני לערי משפחת הערי׃ ");
INSERT INTO heb_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","לארוד משפחת הארודי לאראלי משפחת האראלי׃ ");
INSERT INTO heb_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","אלה משפחת בני גד לפקדיהם ארבעים אלף וחמש מאות׃ ");
INSERT INTO heb_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","בני יהודה ער ואונן וימת ער ואונן בארץ כנען׃ ");
INSERT INTO heb_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","ויהיו בני יהודה למשפחתם לשלה משפחת השלני לפרץ משפחת הפרצי לזרח משפחת הזרחי׃ ");
INSERT INTO heb_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","ויהיו בני פרץ לחצרן משפחת החצרני לחמול משפחת החמולי׃ ");
INSERT INTO heb_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","אלה משפחת יהודה לפקדיהם ששה ושבעים אלף וחמש מאות׃ ");
INSERT INTO heb_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","בני יששכר למשפחתם תולע משפחת התולעי לפוה משפחת הפוני׃ ");
INSERT INTO heb_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","לישוב משפחת הישובי לשמרן משפחת השמרני׃ ");
INSERT INTO heb_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","אלה משפחת יששכר לפקדיהם ארבעה וששים אלף ושלש מאות׃ ");
INSERT INTO heb_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","בני זבולן למשפחתם לסרד משפחת הסרדי לאלון משפחת האלני ליחלאל משפחת היחלאלי׃ ");
INSERT INTO heb_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","אלה משפחת הזבולני לפקדיהם ששים אלף וחמש מאות׃ ");
INSERT INTO heb_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","בני יוסף למשפחתם מנשה ואפרים׃ ");
INSERT INTO heb_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","בני מנשה למכיר משפחת המכירי ומכיר הוליד את גלעד לגלעד משפחת הגלעדי׃ ");
INSERT INTO heb_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","אלה בני גלעד איעזר משפחת האיעזרי לחלק משפחת החלקי׃ ");
INSERT INTO heb_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","ואשריאל משפחת האשראלי ושכם משפחת השכמי׃ ");
INSERT INTO heb_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","ושמידע משפחת השמידעי וחפר משפחת החפרי׃ ");
INSERT INTO heb_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","וצלפחד בן חפר לא היו לו בנים כי אם בנות ושם בנות צלפחד מחלה ונעה חגלה מלכה ותרצה׃ ");
INSERT INTO heb_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","אלה משפחת מנשה ופקדיהם שנים וחמשים אלף ושבע מאות׃ ");
INSERT INTO heb_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","אלה בני אפרים למשפחתם לשותלח משפחת השתלחי לבכר משפחת הבכרי לתחן משפחת התחני׃ ");
INSERT INTO heb_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","ואלה בני שותלח לערן משפחת הערני׃ ");
INSERT INTO heb_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","אלה משפחת בני אפרים לפקדיהם שנים ושלשים אלף וחמש מאות אלה בני יוסף למשפחתם׃ ");
INSERT INTO heb_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","בני בנימן למשפחתם לבלע משפחת הבלעי לאשבל משפחת האשבלי לאחירם משפחת האחירמי׃ ");
INSERT INTO heb_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","לשפופם משפחת השופמי לחופם משפחת החופמי׃ ");
INSERT INTO heb_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","ויהיו בני בלע ארד ונעמן משפחת הארדי לנעמן משפחת הנעמי׃ ");
INSERT INTO heb_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","אלה בני בנימן למשפחתם ופקדיהם חמשה וארבעים אלף ושש מאות׃ ");
INSERT INTO heb_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","אלה בני דן למשפחתם לשוחם משפחת השוחמי אלה משפחת דן למשפחתם׃ ");
INSERT INTO heb_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","כל משפחת השוחמי לפקדיהם ארבעה וששים אלף וארבע מאות׃ ");
INSERT INTO heb_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","בני אשר למשפחתם לימנה משפחת הימנה לישוי משפחת הישוי לבריעה משפחת הבריעי׃ ");
INSERT INTO heb_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","לבני בריעה לחבר משפחת החברי למלכיאל משפחת המלכיאלי׃ ");
INSERT INTO heb_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","ושם בת אשר שרח׃ ");
INSERT INTO heb_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","אלה משפחת בני אשר לפקדיהם שלשה וחמשים אלף וארבע מאות׃ ");
INSERT INTO heb_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","בני נפתלי למשפחתם ליחצאל משפחת היחצאלי לגוני משפחת הגוני׃ ");
INSERT INTO heb_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","ליצר משפחת היצרי לשלם משפחת השלמי׃ ");
INSERT INTO heb_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","אלה משפחת נפתלי למשפחתם ופקדיהם חמשה וארבעים אלף וארבע מאות׃ ");
INSERT INTO heb_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","אלה פקודי בני ישראל שש מאות אלף ואלף שבע מאות ושלשים׃ ");
INSERT INTO heb_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","לאלה תחלק הארץ בנחלה במספר שמות׃ ");
INSERT INTO heb_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","לרב תרבה נחלתו ולמעט תמעיט נחלתו איש לפי פקדיו יתן נחלתו׃ ");
INSERT INTO heb_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","אך בגורל יחלק את הארץ לשמות מטות אבתם ינחלו׃ ");
INSERT INTO heb_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","על פי הגורל תחלק נחלתו בין רב למעט׃ ");
INSERT INTO heb_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","ואלה פקודי הלוי למשפחתם לגרשון משפחת הגרשני לקהת משפחת הקהתי למררי משפחת המררי׃ ");
INSERT INTO heb_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","אלה משפחת לוי משפחת הלבני משפחת החברני משפחת המחלי משפחת המושי משפחת הקרחי וקהת הולד את עמרם׃ ");
INSERT INTO heb_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","ושם אשת עמרם יוכבד בת לוי אשר ילדה אתה ללוי במצרים ותלד לעמרם את אהרן ואת משה ואת מרים אחתם׃ ");
INSERT INTO heb_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","ויולד לאהרן את נדב ואת אביהוא את אלעזר ואת איתמר׃ ");
INSERT INTO heb_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","וימת נדב ואביהוא בהקריבם אש זרה לפני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","ויהיו פקדיהם שלשה ועשרים אלף כל זכר מבן חדש ומעלה כי לא התפקדו בתוך בני ישראל כי לא נתן להם נחלה בתוך בני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","אלה פקודי משה ואלעזר הכהן אשר פקדו את בני ישראל בערבת מואב על ירדן ירחו׃ ");
INSERT INTO heb_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","ובאלה לא היה איש מפקודי משה ואהרן הכהן אשר פקדו את בני ישראל במדבר סיני׃ ");
INSERT INTO heb_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","כי אמר יהוה להם מות ימתו במדבר ולא נותר מהם איש כי אם כלב בן יפנה ויהושע בן נון׃ ");
INSERT INTO heb_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","ותקרבנה בנות צלפחד בן חפר בן גלעד בן מכיר בן מנשה למשפחת מנשה בן יוסף ואלה שמות בנתיו מחלה נעה וחגלה ומלכה ותרצה׃ ");
INSERT INTO heb_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","ותעמדנה לפני משה ולפני אלעזר הכהן ולפני הנשיאם וכל העדה פתח אהל מועד לאמר׃ ");
INSERT INTO heb_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","אבינו מת במדבר והוא לא היה בתוך העדה הנועדים על יהוה בעדת קרח כי בחטאו מת ובנים לא היו לו׃ ");
INSERT INTO heb_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","למה יגרע שם אבינו מתוך משפחתו כי אין לו בן תנה לנו אחזה בתוך אחי אבינו׃ ");
INSERT INTO heb_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","ויקרב משה את משפטן לפני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","ויאמר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","כן בנות צלפחד דברת נתן תתן להם אחזת נחלה בתוך אחי אביהם והעברת את נחלת אביהן להן׃ ");
INSERT INTO heb_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","ואל בני ישראל תדבר לאמר איש כי ימות ובן אין לו והעברתם את נחלתו לבתו׃ ");
INSERT INTO heb_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","ואם אין לו בת ונתתם את נחלתו לאחיו׃ ");
INSERT INTO heb_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","ואם אין לו אחים ונתתם את נחלתו לאחי אביו׃ ");
INSERT INTO heb_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","ואם אין אחים לאביו ונתתם את נחלתו לשארו הקרב אליו ממשפחתו וירש אתה והיתה לבני ישראל לחקת משפט כאשר צוה יהוה את משה׃ ");
INSERT INTO heb_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","ויאמר יהוה אל משה עלה אל הר העברים הזה וראה את הארץ אשר נתתי לבני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","וראיתה אתה ונאספת אל עמיך גם אתה כאשר נאסף אהרן אחיך׃ ");
INSERT INTO heb_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","כאשר מריתם פי במדבר צן במריבת העדה להקדישני במים לעיניהם הם מי מריבת קדש מדבר צן׃ ");
INSERT INTO heb_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","וידבר משה אל יהוה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","יפקד יהוה אלהי הרוחת לכל בשר איש על העדה׃ ");
INSERT INTO heb_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","אשר יצא לפניהם ואשר יבא לפניהם ואשר יוציאם ואשר יביאם ולא תהיה עדת יהוה כצאן אשר אין להם רעה׃ ");
INSERT INTO heb_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","ויאמר יהוה אל משה קח לך את יהושע בן נון איש אשר רוח בו וסמכת את ידך עליו׃ ");
INSERT INTO heb_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","והעמדת אתו לפני אלעזר הכהן ולפני כל העדה וצויתה אתו לעיניהם׃ ");
INSERT INTO heb_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","ונתתה מהודך עליו למען ישמעו כל עדת בני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","ולפני אלעזר הכהן יעמד ושאל לו במשפט האורים לפני יהוה על פיו יצאו ועל פיו יבאו הוא וכל בני ישראל אתו וכל העדה׃ ");
INSERT INTO heb_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","ויעש משה כאשר צוה יהוה אתו ויקח את יהושע ויעמדהו לפני אלעזר הכהן ולפני כל העדה׃ ");
INSERT INTO heb_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","ויסמך את ידיו עליו ויצוהו כאשר דבר יהוה ביד משה׃ ");
INSERT INTO heb_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","צו את בני ישראל ואמרת אלהם את קרבני לחמי לאשי ריח ניחחי תשמרו להקריב לי במועדו׃ ");
INSERT INTO heb_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","ואמרת להם זה האשה אשר תקריבו ליהוה כבשים בני שנה תמימם שנים ליום עלה תמיד׃ ");
INSERT INTO heb_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","את הכבש אחד תעשה בבקר ואת הכבש השני תעשה בין הערבים׃ ");
INSERT INTO heb_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","ועשירית האיפה סלת למנחה בלולה בשמן כתית רביעת ההין׃ ");
INSERT INTO heb_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","עלת תמיד העשיה בהר סיני לריח ניחח אשה ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","ונסכו רביעת ההין לכבש האחד בקדש הסך נסך שכר ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","ואת הכבש השני תעשה בין הערבים כמנחת הבקר וכנסכו תעשה אשה ריח ניחח ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","וביום השבת שני כבשים בני שנה תמימם ושני עשרנים סלת מנחה בלולה בשמן ונסכו׃ ");
INSERT INTO heb_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","עלת שבת בשבתו על עלת התמיד ונסכה׃ ");
INSERT INTO heb_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","ובראשי חדשיכם תקריבו עלה ליהוה פרים בני בקר שנים ואיל אחד כבשים בני שנה שבעה תמימם׃ ");
INSERT INTO heb_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","ושלשה עשרנים סלת מנחה בלולה בשמן לפר האחד ושני עשרנים סלת מנחה בלולה בשמן לאיל האחד׃ ");
INSERT INTO heb_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","ועשרן עשרון סלת מנחה בלולה בשמן לכבש האחד עלה ריח ניחח אשה ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","ונסכיהם חצי ההין יהיה לפר ושלישת ההין לאיל ורביעת ההין לכבש יין זאת עלת חדש בחדשו לחדשי השנה׃ ");
INSERT INTO heb_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","ושעיר עזים אחד לחטאת ליהוה על עלת התמיד יעשה ונסכו׃ ");
INSERT INTO heb_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","ובחדש הראשון בארבעה עשר יום לחדש פסח ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","ובחמשה עשר יום לחדש הזה חג שבעת ימים מצות יאכל׃ ");
INSERT INTO heb_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","ביום הראשון מקרא קדש כל מלאכת עבדה לא תעשו׃ ");
INSERT INTO heb_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","והקרבתם אשה עלה ליהוה פרים בני בקר שנים ואיל אחד ושבעה כבשים בני שנה תמימם יהיו לכם׃ ");
INSERT INTO heb_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","ומנחתם סלת בלולה בשמן שלשה עשרנים לפר ושני עשרנים לאיל תעשו׃ ");
INSERT INTO heb_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","עשרון עשרון תעשה לכבש האחד לשבעת הכבשים׃ ");
INSERT INTO heb_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","ושעיר חטאת אחד לכפר עליכם׃ ");
INSERT INTO heb_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","מלבד עלת הבקר אשר לעלת התמיד תעשו את אלה׃ ");
INSERT INTO heb_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","כאלה תעשו ליום שבעת ימים לחם אשה ריח ניחח ליהוה על עולת התמיד יעשה ונסכו׃ ");
INSERT INTO heb_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","וביום השביעי מקרא קדש יהיה לכם כל מלאכת עבדה לא תעשו׃ ");
INSERT INTO heb_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","וביום הבכורים בהקריבכם מנחה חדשה ליהוה בשבעתיכם מקרא קדש יהיה לכם כל מלאכת עבדה לא תעשו׃ ");
INSERT INTO heb_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","והקרבתם עולה לריח ניחח ליהוה פרים בני בקר שנים איל אחד שבעה כבשים בני שנה׃ ");
INSERT INTO heb_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","ומנחתם סלת בלולה בשמן שלשה עשרנים לפר האחד שני עשרנים לאיל האחד׃ ");
INSERT INTO heb_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","עשרון עשרון לכבש האחד לשבעת הכבשים׃ ");
INSERT INTO heb_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","שעיר עזים אחד לכפר עליכם׃ ");
INSERT INTO heb_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","מלבד עלת התמיד ומנחתו תעשו תמימם יהיו לכם ונסכיהם׃ ");
INSERT INTO heb_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","ובחדש השביעי באחד לחדש מקרא קדש יהיה לכם כל מלאכת עבדה לא תעשו יום תרועה יהיה לכם׃ ");
INSERT INTO heb_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","ועשיתם עלה לריח ניחח ליהוה פר בן בקר אחד איל אחד כבשים בני שנה שבעה תמימם׃ ");
INSERT INTO heb_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","ומנחתם סלת בלולה בשמן שלשה עשרנים לפר שני עשרנים לאיל׃ ");
INSERT INTO heb_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","ועשרון אחד לכבש האחד לשבעת הכבשים׃ ");
INSERT INTO heb_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","ושעיר עזים אחד חטאת לכפר עליכם׃ ");
INSERT INTO heb_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","מלבד עלת החדש ומנחתה ועלת התמיד ומנחתה ונסכיהם כמשפטם לריח ניחח אשה ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","ובעשור לחדש השביעי הזה מקרא קדש יהיה לכם ועניתם את נפשתיכם כל מלאכה לא תעשו׃ ");
INSERT INTO heb_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","והקרבתם עלה ליהוה ריח ניחח פר בן בקר אחד איל אחד כבשים בני שנה שבעה תמימם יהיו לכם׃ ");
INSERT INTO heb_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","ומנחתם סלת בלולה בשמן שלשה עשרנים לפר שני עשרנים לאיל האחד׃ ");
INSERT INTO heb_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","עשרון עשרון לכבש האחד לשבעת הכבשים׃ ");
INSERT INTO heb_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","שעיר עזים אחד חטאת מלבד חטאת הכפרים ועלת התמיד ומנחתה ונסכיהם׃ ");
INSERT INTO heb_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","ובחמשה עשר יום לחדש השביעי מקרא קדש יהיה לכם כל מלאכת עבדה לא תעשו וחגתם חג ליהוה שבעת ימים׃ ");
INSERT INTO heb_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","והקרבתם עלה אשה ריח ניחח ליהוה פרים בני בקר שלשה עשר אילם שנים כבשים בני שנה ארבעה עשר תמימם יהיו׃ ");
INSERT INTO heb_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","ומנחתם סלת בלולה בשמן שלשה עשרנים לפר האחד לשלשה עשר פרים שני עשרנים לאיל האחד לשני האילם׃ ");
INSERT INTO heb_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","ועשרון עשרון לכבש האחד לארבעה עשר כבשים׃ ");
INSERT INTO heb_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","ושעיר עזים אחד חטאת מלבד עלת התמיד מנחתה ונסכה׃ ");
INSERT INTO heb_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","וביום השני פרים בני בקר שנים עשר אילם שנים כבשים בני שנה ארבעה עשר תמימם׃ ");
INSERT INTO heb_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","ומנחתם ונסכיהם לפרים לאילם ולכבשים במספרם כמשפט׃ ");
INSERT INTO heb_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","ושעיר עזים אחד חטאת מלבד עלת התמיד ומנחתה ונסכיהם׃ ");
INSERT INTO heb_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","וביום השלישי פרים עשתי עשר אילם שנים כבשים בני שנה ארבעה עשר תמימם׃ ");
INSERT INTO heb_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","ומנחתם ונסכיהם לפרים לאילם ולכבשים במספרם כמשפט׃ ");
INSERT INTO heb_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","ושעיר חטאת אחד מלבד עלת התמיד ומנחתה ונסכה׃ ");
INSERT INTO heb_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","וביום הרביעי פרים עשרה אילם שנים כבשים בני שנה ארבעה עשר תמימם׃ ");
INSERT INTO heb_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","מנחתם ונסכיהם לפרים לאילם ולכבשים במספרם כמשפט׃ ");
INSERT INTO heb_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","ושעיר עזים אחד חטאת מלבד עלת התמיד מנחתה ונסכה׃ ");
INSERT INTO heb_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","וביום החמישי פרים תשעה אילם שנים כבשים בני שנה ארבעה עשר תמימם׃ ");
INSERT INTO heb_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","ומנחתם ונסכיהם לפרים לאילם ולכבשים במספרם כמשפט׃ ");
INSERT INTO heb_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","ושעיר חטאת אחד מלבד עלת התמיד ומנחתה ונסכה׃ ");
INSERT INTO heb_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","וביום הששי פרים שמנה אילם שנים כבשים בני שנה ארבעה עשר תמימם׃ ");
INSERT INTO heb_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","ומנחתם ונסכיהם לפרים לאילם ולכבשים במספרם כמשפט׃ ");
INSERT INTO heb_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","ושעיר חטאת אחד מלבד עלת התמיד מנחתה ונסכיה׃ ");
INSERT INTO heb_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","וביום השביעי פרים שבעה אילם שנים כבשים בני שנה ארבעה עשר תמימם׃ ");
INSERT INTO heb_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","ומנחתם ונסכהם לפרים לאילם ולכבשים במספרם כמשפטם׃ ");
INSERT INTO heb_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","ושעיר חטאת אחד מלבד עלת התמיד מנחתה ונסכה׃ ");
INSERT INTO heb_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","ביום השמיני עצרת תהיה לכם כל מלאכת עבדה לא תעשו׃ ");
INSERT INTO heb_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","והקרבתם עלה אשה ריח ניחח ליהוה פר אחד איל אחד כבשים בני שנה שבעה תמימם׃ ");
INSERT INTO heb_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","מנחתם ונסכיהם לפר לאיל ולכבשים במספרם כמשפט׃ ");
INSERT INTO heb_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","ושעיר חטאת אחד מלבד עלת התמיד ומנחתה ונסכה׃ ");
INSERT INTO heb_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","אלה תעשו ליהוה במועדיכם לבד מנדריכם ונדבתיכם לעלתיכם ולמנחתיכם ולנסכיכם ולשלמיכם׃ ");
INSERT INTO heb_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","ויאמר משה אל בני ישראל ככל אשר צוה יהוה את משה׃ ");
INSERT INTO heb_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","וידבר משה אל ראשי המטות לבני ישראל לאמר זה הדבר אשר צוה יהוה׃ ");
INSERT INTO heb_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","איש כי ידר נדר ליהוה או השבע שבעה לאסר אסר על נפשו לא יחל דברו ככל היצא מפיו יעשה׃ ");
INSERT INTO heb_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","ואשה כי תדר נדר ליהוה ואסרה אסר בבית אביה בנעריה׃ ");
INSERT INTO heb_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","ושמע אביה את נדרה ואסרה אשר אסרה על נפשה והחריש לה אביה וקמו כל נדריה וכל אסר אשר אסרה על נפשה יקום׃ ");
INSERT INTO heb_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","ואם הניא אביה אתה ביום שמעו כל נדריה ואסריה אשר אסרה על נפשה לא יקום ויהוה יסלח לה כי הניא אביה אתה׃ ");
INSERT INTO heb_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","ואם היו תהיה לאיש ונדריה עליה או מבטא שפתיה אשר אסרה על נפשה׃ ");
INSERT INTO heb_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","ושמע אישה ביום שמעו והחריש לה וקמו נדריה ואסרה אשר אסרה על נפשה יקמו׃ ");
INSERT INTO heb_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","ואם ביום שמע אישה יניא אותה והפר את נדרה אשר עליה ואת מבטא שפתיה אשר אסרה על נפשה ויהוה יסלח לה׃ ");
INSERT INTO heb_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","ונדר אלמנה וגרושה כל אשר אסרה על נפשה יקום עליה׃ ");
INSERT INTO heb_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","ואם בית אישה נדרה או אסרה אסר על נפשה בשבעה׃ ");
INSERT INTO heb_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","ושמע אישה והחרש לה לא הניא אתה וקמו כל נדריה וכל אסר אשר אסרה על נפשה יקום׃ ");
INSERT INTO heb_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","ואם הפר יפר אתם אישה ביום שמעו כל מוצא שפתיה לנדריה ולאסר נפשה לא יקום אישה הפרם ויהוה יסלח לה׃ ");
INSERT INTO heb_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","כל נדר וכל שבעת אסר לענת נפש אישה יקימנו ואישה יפרנו׃ ");
INSERT INTO heb_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","ואם החרש יחריש לה אישה מיום אל יום והקים את כל נדריה או את כל אסריה אשר עליה הקים אתם כי החרש לה ביום שמעו׃ ");
INSERT INTO heb_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","ואם הפר יפר אתם אחרי שמעו ונשא את עונה׃ ");
INSERT INTO heb_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","אלה החקים אשר צוה יהוה את משה בין איש לאשתו בין אב לבתו בנעריה בית אביה׃ ");
INSERT INTO heb_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","נקם נקמת בני ישראל מאת המדינים אחר תאסף אל עמיך׃ ");
INSERT INTO heb_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","וידבר משה אל העם לאמר החלצו מאתכם אנשים לצבא ויהיו על מדין לתת נקמת יהוה במדין׃ ");
INSERT INTO heb_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","אלף למטה אלף למטה לכל מטות ישראל תשלחו לצבא׃ ");
INSERT INTO heb_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","וימסרו מאלפי ישראל אלף למטה שנים עשר אלף חלוצי צבא׃ ");
INSERT INTO heb_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","וישלח אתם משה אלף למטה לצבא אתם ואת פינחס בן אלעזר הכהן לצבא וכלי הקדש וחצצרות התרועה בידו׃ ");
INSERT INTO heb_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","ויצבאו על מדין כאשר צוה יהוה את משה ויהרגו כל זכר׃ ");
INSERT INTO heb_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","ואת מלכי מדין הרגו על חלליהם את אוי ואת רקם ואת צור ואת חור ואת רבע חמשת מלכי מדין ואת בלעם בן בעור הרגו בחרב׃ ");
INSERT INTO heb_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","וישבו בני ישראל את נשי מדין ואת טפם ואת כל בהמתם ואת כל מקנהם ואת כל חילם בזזו׃ ");
INSERT INTO heb_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","ואת כל עריהם במושבתם ואת כל טירתם שרפו באש׃ ");
INSERT INTO heb_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","ויקחו את כל השלל ואת כל המלקוח באדם ובבהמה׃ ");
INSERT INTO heb_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","ויבאו אל משה ואל אלעזר הכהן ואל עדת בני ישראל את השבי ואת המלקוח ואת השלל אל המחנה אל ערבת מואב אשר על ירדן ירחו׃ ");
INSERT INTO heb_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","ויצאו משה ואלעזר הכהן וכל נשיאי העדה לקראתם אל מחוץ למחנה׃ ");
INSERT INTO heb_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","ויקצף משה על פקודי החיל שרי האלפים ושרי המאות הבאים מצבא המלחמה׃ ");
INSERT INTO heb_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","ויאמר אליהם משה החייתם כל נקבה׃ ");
INSERT INTO heb_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","הן הנה היו לבני ישראל בדבר בלעם למסר מעל ביהוה על דבר פעור ותהי המגפה בעדת יהוה׃ ");
INSERT INTO heb_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","ועתה הרגו כל זכר בטף וכל אשה ידעת איש למשכב זכר הרגו׃ ");
INSERT INTO heb_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","וכל הטף בנשים אשר לא ידעו משכב זכר החיו לכם׃ ");
INSERT INTO heb_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","ואתם חנו מחוץ למחנה שבעת ימים כל הרג נפש וכל נגע בחלל תתחטאו ביום השלישי וביום השביעי אתם ושביכם׃ ");
INSERT INTO heb_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","וכל בגד וכל כלי עור וכל מעשה עזים וכל כלי עץ תתחטאו׃ ");
INSERT INTO heb_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","ויאמר אלעזר הכהן אל אנשי הצבא הבאים למלחמה זאת חקת התורה אשר צוה יהוה את משה׃ ");
INSERT INTO heb_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","אך את הזהב ואת הכסף את הנחשת את הברזל את הבדיל ואת העפרת׃ ");
INSERT INTO heb_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","כל דבר אשר יבא באש תעבירו באש וטהר אך במי נדה יתחטא וכל אשר לא יבא באש תעבירו במים׃ ");
INSERT INTO heb_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","וכבסתם בגדיכם ביום השביעי וטהרתם ואחר תבאו אל המחנה׃ ");
INSERT INTO heb_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","ויאמר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","שא את ראש מלקוח השבי באדם ובבהמה אתה ואלעזר הכהן וראשי אבות העדה׃ ");
INSERT INTO heb_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","וחצית את המלקוח בין תפשי המלחמה היצאים לצבא ובין כל העדה׃ ");
INSERT INTO heb_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","והרמת מכס ליהוה מאת אנשי המלחמה היצאים לצבא אחד נפש מחמש המאות מן האדם ומן הבקר ומן החמרים ומן הצאן׃ ");
INSERT INTO heb_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","ממחציתם תקחו ונתתה לאלעזר הכהן תרומת יהוה׃ ");
INSERT INTO heb_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","וממחצת בני ישראל תקח אחד אחז מן החמשים מן האדם מן הבקר מן החמרים ומן הצאן מכל הבהמה ונתתה אתם ללוים שמרי משמרת משכן יהוה׃ ");
INSERT INTO heb_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","ויעש משה ואלעזר הכהן כאשר צוה יהוה את משה׃ ");
INSERT INTO heb_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","ויהי המלקוח יתר הבז אשר בזזו עם הצבא צאן שש מאות אלף ושבעים אלף וחמשת אלפים׃ ");
INSERT INTO heb_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","ובקר שנים ושבעים אלף׃ ");
INSERT INTO heb_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","וחמרים אחד וששים אלף׃ ");
INSERT INTO heb_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","ונפש אדם מן הנשים אשר לא ידעו משכב זכר כל נפש שנים ושלשים אלף׃ ");
INSERT INTO heb_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","ותהי המחצה חלק היצאים בצבא מספר הצאן שלש מאות אלף ושלשים אלף ושבעת אלפים וחמש מאות׃ ");
INSERT INTO heb_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","ויהי המכס ליהוה מן הצאן שש מאות חמש ושבעים׃ ");
INSERT INTO heb_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","והבקר ששה ושלשים אלף ומכסם ליהוה שנים ושבעים׃ ");
INSERT INTO heb_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","וחמרים שלשים אלף וחמש מאות ומכסם ליהוה אחד וששים׃ ");
INSERT INTO heb_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","ונפש אדם ששה עשר אלף ומכסם ליהוה שנים ושלשים נפש׃ ");
INSERT INTO heb_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","ויתן משה את מכס תרומת יהוה לאלעזר הכהן כאשר צוה יהוה את משה׃ ");
INSERT INTO heb_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","וממחצית בני ישראל אשר חצה משה מן האנשים הצבאים׃ ");
INSERT INTO heb_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","ותהי מחצת העדה מן הצאן שלש מאות אלף ושלשים אלף שבעת אלפים וחמש מאות׃ ");
INSERT INTO heb_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","ובקר ששה ושלשים אלף׃ ");
INSERT INTO heb_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","וחמרים שלשים אלף וחמש מאות׃ ");
INSERT INTO heb_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","ונפש אדם ששה עשר אלף׃ ");
INSERT INTO heb_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","ויקח משה ממחצת בני ישראל את האחז אחד מן החמשים מן האדם ומן הבהמה ויתן אתם ללוים שמרי משמרת משכן יהוה כאשר צוה יהוה את משה׃ ");
INSERT INTO heb_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","ויקרבו אל משה הפקדים אשר לאלפי הצבא שרי האלפים ושרי המאות׃ ");
INSERT INTO heb_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","ויאמרו אל משה עבדיך נשאו את ראש אנשי המלחמה אשר בידנו ולא נפקד ממנו איש׃ ");
INSERT INTO heb_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","ונקרב את קרבן יהוה איש אשר מצא כלי זהב אצעדה וצמיד טבעת עגיל וכומז לכפר על נפשתינו לפני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","ויקח משה ואלעזר הכהן את הזהב מאתם כל כלי מעשה׃ ");
INSERT INTO heb_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","ויהי כל זהב התרומה אשר הרימו ליהוה ששה עשר אלף שבע מאות וחמשים שקל מאת שרי האלפים ומאת שרי המאות׃ ");
INSERT INTO heb_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","אנשי הצבא בזזו איש לו׃ ");
INSERT INTO heb_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","ויקח משה ואלעזר הכהן את הזהב מאת שרי האלפים והמאות ויבאו אתו אל אהל מועד זכרון לבני ישראל לפני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","ומקנה רב היה לבני ראובן ולבני גד עצום מאד ויראו את ארץ יעזר ואת ארץ גלעד והנה המקום מקום מקנה׃ ");
INSERT INTO heb_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","ויבאו בני גד ובני ראובן ויאמרו אל משה ואל אלעזר הכהן ואל נשיאי העדה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","עטרות ודיבן ויעזר ונמרה וחשבון ואלעלה ושבם ונבו ובען׃ ");
INSERT INTO heb_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","הארץ אשר הכה יהוה לפני עדת ישראל ארץ מקנה הוא ולעבדיך מקנה׃ ");
INSERT INTO heb_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","ויאמרו אם מצאנו חן בעיניך יתן את הארץ הזאת לעבדיך לאחזה אל תעברנו את הירדן׃ ");
INSERT INTO heb_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","ויאמר משה לבני גד ולבני ראובן האחיכם יבאו למלחמה ואתם תשבו פה׃ ");
INSERT INTO heb_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","ולמה תנואון את לב בני ישראל מעבר אל הארץ אשר נתן להם יהוה׃ ");
INSERT INTO heb_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","כה עשו אבתיכם בשלחי אתם מקדש ברנע לראות את הארץ׃ ");
INSERT INTO heb_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","ויעלו עד נחל אשכול ויראו את הארץ ויניאו את לב בני ישראל לבלתי בא אל הארץ אשר נתן להם יהוה׃ ");
INSERT INTO heb_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","ויחר אף יהוה ביום ההוא וישבע לאמר׃ ");
INSERT INTO heb_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","אם יראו האנשים העלים ממצרים מבן עשרים שנה ומעלה את האדמה אשר נשבעתי לאברהם ליצחק וליעקב כי לא מלאו אחרי׃ ");
INSERT INTO heb_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","בלתי כלב בן יפנה הקנזי ויהושע בן נון כי מלאו אחרי יהוה׃ ");
INSERT INTO heb_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","ויחר אף יהוה בישראל וינעם במדבר ארבעים שנה עד תם כל הדור העשה הרע בעיני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","והנה קמתם תחת אבתיכם תרבות אנשים חטאים לספות עוד על חרון אף יהוה אל ישראל׃ ");
INSERT INTO heb_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","כי תשובן מאחריו ויסף עוד להניחו במדבר ושחתם לכל העם הזה׃ ");
INSERT INTO heb_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","ויגשו אליו ויאמרו גדרת צאן נבנה למקננו פה וערים לטפנו׃ ");
INSERT INTO heb_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","ואנחנו נחלץ חשים לפני בני ישראל עד אשר אם הביאנם אל מקומם וישב טפנו בערי המבצר מפני ישבי הארץ׃ ");
INSERT INTO heb_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","לא נשוב אל בתינו עד התנחל בני ישראל איש נחלתו׃ ");
INSERT INTO heb_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","כי לא ננחל אתם מעבר לירדן והלאה כי באה נחלתנו אלינו מעבר הירדן מזרחה׃ ");
INSERT INTO heb_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","ויאמר אליהם משה אם תעשון את הדבר הזה אם תחלצו לפני יהוה למלחמה׃ ");
INSERT INTO heb_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","ועבר לכם כל חלוץ את הירדן לפני יהוה עד הורישו את איביו מפניו׃ ");
INSERT INTO heb_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","ונכבשה הארץ לפני יהוה ואחר תשבו והייתם נקיים מיהוה ומישראל והיתה הארץ הזאת לכם לאחזה לפני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","ואם לא תעשון כן הנה חטאתם ליהוה ודעו חטאתכם אשר תמצא אתכם׃ ");
INSERT INTO heb_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","בנו לכם ערים לטפכם וגדרת לצנאכם והיצא מפיכם תעשו׃ ");
INSERT INTO heb_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","ויאמר בני גד ובני ראובן אל משה לאמר עבדיך יעשו כאשר אדני מצוה׃ ");
INSERT INTO heb_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","טפנו נשינו מקננו וכל בהמתנו יהיו שם בערי הגלעד׃ ");
INSERT INTO heb_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","ועבדיך יעברו כל חלוץ צבא לפני יהוה למלחמה כאשר אדני דבר׃ ");
INSERT INTO heb_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","ויצו להם משה את אלעזר הכהן ואת יהושע בן נון ואת ראשי אבות המטות לבני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","ויאמר משה אלהם אם יעברו בני גד ובני ראובן אתכם את הירדן כל חלוץ למלחמה לפני יהוה ונכבשה הארץ לפניכם ונתתם להם את ארץ הגלעד לאחזה׃ ");
INSERT INTO heb_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","ואם לא יעברו חלוצים אתכם ונאחזו בתככם בארץ כנען׃ ");
INSERT INTO heb_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","ויענו בני גד ובני ראובן לאמר את אשר דבר יהוה אל עבדיך כן נעשה׃ ");
INSERT INTO heb_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","נחנו נעבר חלוצים לפני יהוה ארץ כנען ואתנו אחזת נחלתנו מעבר לירדן׃ ");
INSERT INTO heb_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","ויתן להם משה לבני גד ולבני ראובן ולחצי שבט מנשה בן יוסף את ממלכת סיחן מלך האמרי ואת ממלכת עוג מלך הבשן הארץ לעריה בגבלת ערי הארץ סביב׃ ");
INSERT INTO heb_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","ויבנו בני גד את דיבן ואת עטרת ואת ערער׃ ");
INSERT INTO heb_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","ואת עטרת שופן ואת יעזר ויגבהה׃ ");
INSERT INTO heb_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","ואת בית נמרה ואת בית הרן ערי מבצר וגדרת צאן׃ ");
INSERT INTO heb_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","ובני ראובן בנו את חשבון ואת אלעלא ואת קריתים׃ ");
INSERT INTO heb_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","ואת נבו ואת בעל מעון מוסבת שם ואת שבמה ויקראו בשמת את שמות הערים אשר בנו׃ ");
INSERT INTO heb_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","וילכו בני מכיר בן מנשה גלעדה וילכדה ויורש את האמרי אשר בה׃ ");
INSERT INTO heb_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","ויתן משה את הגלעד למכיר בן מנשה וישב בה׃ ");
INSERT INTO heb_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","ויאיר בן מנשה הלך וילכד את חותיהם ויקרא אתהן חות יאיר׃ ");
INSERT INTO heb_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","ונבח הלך וילכד את קנת ואת בנתיה ויקרא לה נבח בשמו׃ ");
INSERT INTO heb_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","אלה מסעי בני ישראל אשר יצאו מארץ מצרים לצבאתם ביד משה ואהרן׃ ");
INSERT INTO heb_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","ויכתב משה את מוצאיהם למסעיהם על פי יהוה ואלה מסעיהם למוצאיהם׃ ");
INSERT INTO heb_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","ויסעו מרעמסס בחדש הראשון בחמשה עשר יום לחדש הראשון ממחרת הפסח יצאו בני ישראל ביד רמה לעיני כל מצרים׃ ");
INSERT INTO heb_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","ומצרים מקברים את אשר הכה יהוה בהם כל בכור ובאלהיהם עשה יהוה שפטים׃ ");
INSERT INTO heb_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","ויסעו בני ישראל מרעמסס ויחנו בסכת׃ ");
INSERT INTO heb_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","ויסעו מסכת ויחנו באתם אשר בקצה המדבר׃ ");
INSERT INTO heb_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","ויסעו מאתם וישב על פי החירת אשר על פני בעל צפון ויחנו לפני מגדל׃ ");
INSERT INTO heb_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","ויסעו מפני החירת ויעברו בתוך הים המדברה וילכו דרך שלשת ימים במדבר אתם ויחנו במרה׃ ");
INSERT INTO heb_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","ויסעו ממרה ויבאו אילמה ובאילם שתים עשרה עינת מים ושבעים תמרים ויחנו שם׃ ");
INSERT INTO heb_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","ויסעו מאילם ויחנו על ים סוף׃ ");
INSERT INTO heb_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","ויסעו מים סוף ויחנו במדבר סין׃ ");
INSERT INTO heb_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","ויסעו ממדבר סין ויחנו בדפקה׃ ");
INSERT INTO heb_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","ויסעו מדפקה ויחנו באלוש׃ ");
INSERT INTO heb_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","ויסעו מאלוש ויחנו ברפידם ולא היה שם מים לעם לשתות׃ ");
INSERT INTO heb_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","ויסעו מרפידם ויחנו במדבר סיני׃ ");
INSERT INTO heb_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","ויסעו ממדבר סיני ויחנו בקברת התאוה׃ ");
INSERT INTO heb_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","ויסעו מקברת התאוה ויחנו בחצרת׃ ");
INSERT INTO heb_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","ויסעו מחצרת ויחנו ברתמה׃ ");
INSERT INTO heb_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","ויסעו מרתמה ויחנו ברמן פרץ׃ ");
INSERT INTO heb_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","ויסעו מרמן פרץ ויחנו בלבנה׃ ");
INSERT INTO heb_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","ויסעו מלבנה ויחנו ברסה׃ ");
INSERT INTO heb_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","ויסעו מרסה ויחנו בקהלתה׃ ");
INSERT INTO heb_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","ויסעו מקהלתה ויחנו בהר שפר׃ ");
INSERT INTO heb_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","ויסעו מהר שפר ויחנו בחרדה׃ ");
INSERT INTO heb_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","ויסעו מחרדה ויחנו במקהלת׃ ");
INSERT INTO heb_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","ויסעו ממקהלת ויחנו בתחת׃ ");
INSERT INTO heb_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","ויסעו מתחת ויחנו בתרח׃ ");
INSERT INTO heb_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","ויסעו מתרח ויחנו במתקה׃ ");
INSERT INTO heb_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","ויסעו ממתקה ויחנו בחשמנה׃ ");
INSERT INTO heb_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","ויסעו מחשמנה ויחנו במסרות׃ ");
INSERT INTO heb_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","ויסעו ממסרות ויחנו בבני יעקן׃ ");
INSERT INTO heb_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","ויסעו מבני יעקן ויחנו בחר הגדגד׃ ");
INSERT INTO heb_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","ויסעו מחר הגדגד ויחנו ביטבתה׃ ");
INSERT INTO heb_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","ויסעו מיטבתה ויחנו בעברנה׃ ");
INSERT INTO heb_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","ויסעו מעברנה ויחנו בעציון גבר׃ ");
INSERT INTO heb_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","ויסעו מעציון גבר ויחנו במדבר צן הוא קדש׃ ");
INSERT INTO heb_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","ויסעו מקדש ויחנו בהר ההר בקצה ארץ אדום׃ ");
INSERT INTO heb_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","ויעל אהרן הכהן אל הר ההר על פי יהוה וימת שם בשנת הארבעים לצאת בני ישראל מארץ מצרים בחדש החמישי באחד לחדש׃ ");
INSERT INTO heb_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","ואהרן בן שלש ועשרים ומאת שנה במתו בהר ההר׃ ");
INSERT INTO heb_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","וישמע הכנעני מלך ערד והוא ישב בנגב בארץ כנען בבא בני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","ויסעו מהר ההר ויחנו בצלמנה׃ ");
INSERT INTO heb_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","ויסעו מצלמנה ויחנו בפונן׃ ");
INSERT INTO heb_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","ויסעו מפונן ויחנו באבת׃ ");
INSERT INTO heb_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","ויסעו מאבת ויחנו בעיי העברים בגבול מואב׃ ");
INSERT INTO heb_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","ויסעו מעיים ויחנו בדיבן גד׃ ");
INSERT INTO heb_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","ויסעו מדיבן גד ויחנו בעלמן דבלתימה׃ ");
INSERT INTO heb_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","ויסעו מעלמן דבלתימה ויחנו בהרי העברים לפני נבו׃ ");
INSERT INTO heb_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","ויסעו מהרי העברים ויחנו בערבת מואב על ירדן ירחו׃ ");
INSERT INTO heb_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","ויחנו על הירדן מבית הישמת עד אבל השטים בערבת מואב׃ ");
INSERT INTO heb_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","וידבר יהוה אל משה בערבת מואב על ירדן ירחו לאמר׃ ");
INSERT INTO heb_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","דבר אל בני ישראל ואמרת אלהם כי אתם עברים את הירדן אל ארץ כנען׃ ");
INSERT INTO heb_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","והורשתם את כל ישבי הארץ מפניכם ואבדתם את כל משכיתם ואת כל צלמי מסכתם תאבדו ואת כל במתם תשמידו׃ ");
INSERT INTO heb_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","והורשתם את הארץ וישבתם בה כי לכם נתתי את הארץ לרשת אתה׃ ");
INSERT INTO heb_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","והתנחלתם את הארץ בגורל למשפחתיכם לרב תרבו את נחלתו ולמעט תמעיט את נחלתו אל אשר יצא לו שמה הגורל לו יהיה למטות אבתיכם תתנחלו׃ ");
INSERT INTO heb_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","ואם לא תורישו את ישבי הארץ מפניכם והיה אשר תותירו מהם לשכים בעיניכם ולצנינם בצדיכם וצררו אתכם על הארץ אשר אתם ישבים בה׃ ");
INSERT INTO heb_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","והיה כאשר דמיתי לעשות להם אעשה לכם׃ ");
INSERT INTO heb_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","צו את בני ישראל ואמרת אלהם כי אתם באים אל הארץ כנען זאת הארץ אשר תפל לכם בנחלה ארץ כנען לגבלתיה׃ ");
INSERT INTO heb_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","והיה לכם פאת נגב ממדבר צן על ידי אדום והיה לכם גבול נגב מקצה ים המלח קדמה׃ ");
INSERT INTO heb_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","ונסב לכם הגבול מנגב למעלה עקרבים ועבר צנה והיה תוצאתיו מנגב לקדש ברנע ויצא חצר אדר ועבר עצמנה׃ ");
INSERT INTO heb_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","ונסב הגבול מעצמון נחלה מצרים והיו תוצאתיו הימה׃ ");
INSERT INTO heb_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","וגבול ים והיה לכם הים הגדול וגבול זה יהיה לכם גבול ים׃ ");
INSERT INTO heb_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","וזה יהיה לכם גבול צפון מן הים הגדל תתאו לכם הר ההר׃ ");
INSERT INTO heb_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","מהר ההר תתאו לבא חמת והיו תוצאת הגבל צדדה׃ ");
INSERT INTO heb_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","ויצא הגבל זפרנה והיו תוצאתיו חצר עינן זה יהיה לכם גבול צפון׃ ");
INSERT INTO heb_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","והתאויתם לכם לגבול קדמה מחצר עינן שפמה׃ ");
INSERT INTO heb_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","וירד הגבל משפם הרבלה מקדם לעין וירד הגבול ומחה על כתף ים כנרת קדמה׃ ");
INSERT INTO heb_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","וירד הגבול הירדנה והיו תוצאתיו ים המלח זאת תהיה לכם הארץ לגבלתיה סביב׃ ");
INSERT INTO heb_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","ויצו משה את בני ישראל לאמר זאת הארץ אשר תתנחלו אתה בגורל אשר צוה יהוה לתת לתשעת המטות וחצי המטה׃ ");
INSERT INTO heb_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","כי לקחו מטה בני הראובני לבית אבתם ומטה בני הגדי לבית אבתם וחצי מטה מנשה לקחו נחלתם׃ ");
INSERT INTO heb_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","שני המטות וחצי המטה לקחו נחלתם מעבר לירדן ירחו קדמה מזרחה׃ ");
INSERT INTO heb_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","אלה שמות האנשים אשר ינחלו לכם את הארץ אלעזר הכהן ויהושע בן נון׃ ");
INSERT INTO heb_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","ונשיא אחד נשיא אחד ממטה תקחו לנחל את הארץ׃ ");
INSERT INTO heb_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","ואלה שמות האנשים למטה יהודה כלב בן יפנה׃ ");
INSERT INTO heb_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","ולמטה בני שמעון שמואל בן עמיהוד׃ ");
INSERT INTO heb_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","למטה בנימן אלידד בן כסלון׃ ");
INSERT INTO heb_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","ולמטה בני דן נשיא בקי בן יגלי׃ ");
INSERT INTO heb_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","לבני יוסף למטה בני מנשה נשיא חניאל בן אפד׃ ");
INSERT INTO heb_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","ולמטה בני אפרים נשיא קמואל בן שפטן׃ ");
INSERT INTO heb_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","ולמטה בני זבולן נשיא אליצפן בן פרנך׃ ");
INSERT INTO heb_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","ולמטה בני יששכר נשיא פלטיאל בן עזן׃ ");
INSERT INTO heb_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","ולמטה בני אשר נשיא אחיהוד בן שלמי׃ ");
INSERT INTO heb_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","ולמטה בני נפתלי נשיא פדהאל בן עמיהוד׃ ");
INSERT INTO heb_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","אלה אשר צוה יהוה לנחל את בני ישראל בארץ כנען׃ ");
INSERT INTO heb_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","וידבר יהוה אל משה בערבת מואב על ירדן ירחו לאמר׃ ");
INSERT INTO heb_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","צו את בני ישראל ונתנו ללוים מנחלת אחזתם ערים לשבת ומגרש לערים סביבתיהם תתנו ללוים׃ ");
INSERT INTO heb_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","והיו הערים להם לשבת ומגרשיהם יהיו לבהמתם ולרכשם ולכל חיתם׃ ");
INSERT INTO heb_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","ומגרשי הערים אשר תתנו ללוים מקיר העיר וחוצה אלף אמה סביב׃ ");
INSERT INTO heb_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","ומדתם מחוץ לעיר את פאת קדמה אלפים באמה ואת פאת נגב אלפים באמה ואת פאת ים אלפים באמה ואת פאת צפון אלפים באמה והעיר בתוך זה יהיה להם מגרשי הערים׃ ");
INSERT INTO heb_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","ואת הערים אשר תתנו ללוים את שש ערי המקלט אשר תתנו לנס שמה הרצח ועליהם תתנו ארבעים ושתים עיר׃ ");
INSERT INTO heb_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","כל הערים אשר תתנו ללוים ארבעים ושמנה עיר אתהן ואת מגרשיהן׃ ");
INSERT INTO heb_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","והערים אשר תתנו מאחזת בני ישראל מאת הרב תרבו ומאת המעט תמעיטו איש כפי נחלתו אשר ינחלו יתן מעריו ללוים׃ ");
INSERT INTO heb_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","וידבר יהוה אל משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","דבר אל בני ישראל ואמרת אלהם כי אתם עברים את הירדן ארצה כנען׃ ");
INSERT INTO heb_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","והקריתם לכם ערים ערי מקלט תהיינה לכם ונס שמה רצח מכה נפש בשגגה׃ ");
INSERT INTO heb_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","והיו לכם הערים למקלט מגאל ולא ימות הרצח עד עמדו לפני העדה למשפט׃ ");
INSERT INTO heb_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","והערים אשר תתנו שש ערי מקלט תהיינה לכם׃ ");
INSERT INTO heb_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","את שלש הערים תתנו מעבר לירדן ואת שלש הערים תתנו בארץ כנען ערי מקלט תהיינה׃ ");
INSERT INTO heb_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","לבני ישראל ולגר ולתושב בתוכם תהיינה שש הערים האלה למקלט לנוס שמה כל מכה נפש בשגגה׃ ");
INSERT INTO heb_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","ואם בכלי ברזל הכהו וימת רצח הוא מות יומת הרצח׃ ");
INSERT INTO heb_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","ואם באבן יד אשר ימות בה הכהו וימת רצח הוא מות יומת הרצח׃ ");
INSERT INTO heb_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","או בכלי עץ יד אשר ימות בו הכהו וימת רצח הוא מות יומת הרצח׃ ");
INSERT INTO heb_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","גאל הדם הוא ימית את הרצח בפגעו בו הוא ימיתנו׃ ");
INSERT INTO heb_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","ואם בשנאה יהדפנו או השליך עליו בצדיה וימת׃ ");
INSERT INTO heb_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","או באיבה הכהו בידו וימת מות יומת המכה רצח הוא גאל הדם ימית את הרצח בפגעו בו׃ ");
INSERT INTO heb_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","ואם בפתע בלא איבה הדפו או השליך עליו כל כלי בלא צדיה׃ ");
INSERT INTO heb_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","או בכל אבן אשר ימות בה בלא ראות ויפל עליו וימת והוא לא אויב לו ולא מבקש רעתו׃ ");
INSERT INTO heb_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","ושפטו העדה בין המכה ובין גאל הדם על המשפטים האלה׃ ");
INSERT INTO heb_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","והצילו העדה את הרצח מיד גאל הדם והשיבו אתו העדה אל עיר מקלטו אשר נס שמה וישב בה עד מות הכהן הגדל אשר משח אתו בשמן הקדש׃ ");
INSERT INTO heb_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","ואם יצא יצא הרצח את גבול עיר מקלטו אשר ינוס שמה׃ ");
INSERT INTO heb_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","ומצא אתו גאל הדם מחוץ לגבול עיר מקלטו ורצח גאל הדם את הרצח אין לו דם׃ ");
INSERT INTO heb_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","כי בעיר מקלטו ישב עד מות הכהן הגדל ואחרי מות הכהן הגדל ישוב הרצח אל ארץ אחזתו׃ ");
INSERT INTO heb_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","והיו אלה לכם לחקת משפט לדרתיכם בכל מושבתיכם׃ ");
INSERT INTO heb_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","כל מכה נפש לפי עדים ירצח את הרצח ועד אחד לא יענה בנפש למות׃ ");
INSERT INTO heb_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","ולא תקחו כפר לנפש רצח אשר הוא רשע למות כי מות יומת׃ ");
INSERT INTO heb_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","ולא תקחו כפר לנוס אל עיר מקלטו לשוב לשבת בארץ עד מות הכהן׃ ");
INSERT INTO heb_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","ולא תחניפו את הארץ אשר אתם בה כי הדם הוא יחניף את הארץ ולארץ לא יכפר לדם אשר שפך בה כי אם בדם שפכו׃ ");
INSERT INTO heb_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","ולא תטמא את הארץ אשר אתם ישבים בה אשר אני שכן בתוכה כי אני יהוה שכן בתוך בני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","ויקרבו ראשי האבות למשפחת בני גלעד בן מכיר בן מנשה ממשפחת בני יוסף וידברו לפני משה ולפני הנשאים ראשי אבות לבני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","ויאמרו את אדני צוה יהוה לתת את הארץ בנחלה בגורל לבני ישראל ואדני צוה ביהוה לתת את נחלת צלפחד אחינו לבנתיו׃ ");
INSERT INTO heb_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","והיו לאחד מבני שבטי בני ישראל לנשים ונגרעה נחלתן מנחלת אבתינו ונוסף על נחלת המטה אשר תהיינה להם ומגרל נחלתנו יגרע׃ ");
INSERT INTO heb_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","ואם יהיה היבל לבני ישראל ונוספה נחלתן על נחלת המטה אשר תהיינה להם ומנחלת מטה אבתינו יגרע נחלתן׃ ");
INSERT INTO heb_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","ויצו משה את בני ישראל על פי יהוה לאמר כן מטה בני יוסף דברים׃ ");
INSERT INTO heb_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","זה הדבר אשר צוה יהוה לבנות צלפחד לאמר לטוב בעיניהם תהיינה לנשים אך למשפחת מטה אביהם תהיינה לנשים׃ ");
INSERT INTO heb_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","ולא תסב נחלה לבני ישראל ממטה אל מטה כי איש בנחלת מטה אבתיו ידבקו בני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","וכל בת ירשת נחלה ממטות בני ישראל לאחד ממשפחת מטה אביה תהיה לאשה למען יירשו בני ישראל איש נחלת אבתיו׃ ");
INSERT INTO heb_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","ולא תסב נחלה ממטה למטה אחר כי איש בנחלתו ידבקו מטות בני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","כאשר צוה יהוה את משה כן עשו בנות צלפחד׃ ");
INSERT INTO heb_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","ותהיינה מחלה תרצה וחגלה ומלכה ונעה בנות צלפחד לבני דדיהן לנשים׃ ");
INSERT INTO heb_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","ממשפחת בני מנשה בן יוסף היו לנשים ותהי נחלתן על מטה משפחת אביהן׃ ");
INSERT INTO heb_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","אלה המצות והמשפטים אשר צוה יהוה ביד משה אל בני ישראל בערבת מואב על ירדן ירחו׃ ");
INSERT INTO heb_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","אלה הדברים אשר דבר משה אל כל ישראל בעבר הירדן במדבר בערבה מול סוף בין פארן ובין תפל ולבן וחצרת ודי זהב׃ ");
INSERT INTO heb_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","אחד עשר יום מחרב דרך הר שעיר עד קדש ברנע׃ ");
INSERT INTO heb_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","ויהי בארבעים שנה בעשתי עשר חדש באחד לחדש דבר משה אל בני ישראל ככל אשר צוה יהוה אתו אלהם׃ ");
INSERT INTO heb_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","אחרי הכתו את סיחן מלך האמרי אשר יושב בחשבון ואת עוג מלך הבשן אשר יושב בעשתרת באדרעי׃ ");
INSERT INTO heb_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","בעבר הירדן בארץ מואב הואיל משה באר את התורה הזאת לאמר׃ ");
INSERT INTO heb_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","יהוה אלהינו דבר אלינו בחרב לאמר רב לכם שבת בהר הזה׃ ");
INSERT INTO heb_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","פנו וסעו לכם ובאו הר האמרי ואל כל שכניו בערבה בהר ובשפלה ובנגב ובחוף הים ארץ הכנעני והלבנון עד הנהר הגדל נהר פרת׃ ");
INSERT INTO heb_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","ראה נתתי לפניכם את הארץ באו ורשו את הארץ אשר נשבע יהוה לאבתיכם לאברהם ליצחק וליעקב לתת להם ולזרעם אחריהם׃ ");
INSERT INTO heb_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","ואמר אלכם בעת ההוא לאמר לא אוכל לבדי שאת אתכם׃ ");
INSERT INTO heb_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","יהוה אלהיכם הרבה אתכם והנכם היום ככוכבי השמים לרב׃ ");
INSERT INTO heb_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","יהוה אלהי אבותכם יסף עליכם ככם אלף פעמים ויברך אתכם כאשר דבר לכם׃ ");
INSERT INTO heb_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","איכה אשא לבדי טרחכם ומשאכם וריבכם׃ ");
INSERT INTO heb_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","הבו לכם אנשים חכמים ונבנים וידעים לשבטיכם ואשימם בראשיכם׃ ");
INSERT INTO heb_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","ותענו אתי ותאמרו טוב הדבר אשר דברת לעשות׃ ");
INSERT INTO heb_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","ואקח את ראשי שבטיכם אנשים חכמים וידעים ואתן אתם ראשים עליכם שרי אלפים ושרי מאות ושרי חמשים ושרי עשרת ושטרים לשבטיכם׃ ");
INSERT INTO heb_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","ואצוה את שפטיכם בעת ההוא לאמר שמע בין אחיכם ושפטתם צדק בין איש ובין אחיו ובין גרו׃ ");
INSERT INTO heb_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","לא תכירו פנים במשפט כקטן כגדל תשמעון לא תגורו מפני איש כי המשפט לאלהים הוא והדבר אשר יקשה מכם תקרבון אלי ושמעתיו׃ ");
INSERT INTO heb_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","ואצוה אתכם בעת ההוא את כל הדברים אשר תעשון׃ ");
INSERT INTO heb_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","ונסע מחרב ונלך את כל המדבר הגדול והנורא ההוא אשר ראיתם דרך הר האמרי כאשר צוה יהוה אלהינו אתנו ונבא עד קדש ברנע׃ ");
INSERT INTO heb_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","ואמר אלכם באתם עד הר האמרי אשר יהוה אלהינו נתן לנו׃ ");
INSERT INTO heb_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","ראה נתן יהוה אלהיך לפניך את הארץ עלה רש כאשר דבר יהוה אלהי אבתיך לך אל תירא ואל תחת׃ ");
INSERT INTO heb_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","ותקרבון אלי כלכם ותאמרו נשלחה אנשים לפנינו ויחפרו לנו את הארץ וישבו אתנו דבר את הדרך אשר נעלה בה ואת הערים אשר נבא אליהן׃ ");
INSERT INTO heb_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","וייטב בעיני הדבר ואקח מכם שנים עשר אנשים איש אחד לשבט׃ ");
INSERT INTO heb_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","ויפנו ויעלו ההרה ויבאו עד נחל אשכל וירגלו אתה׃ ");
INSERT INTO heb_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","ויקחו בידם מפרי הארץ ויורדו אלינו וישבו אתנו דבר ויאמרו טובה הארץ אשר יהוה אלהינו נתן לנו׃ ");
INSERT INTO heb_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","ולא אביתם לעלת ותמרו את פי יהוה אלהיכם׃ ");
INSERT INTO heb_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","ותרגנו באהליכם ותאמרו בשנאת יהוה אתנו הוציאנו מארץ מצרים לתת אתנו ביד האמרי להשמידנו׃ ");
INSERT INTO heb_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","אנה אנחנו עלים אחינו המסו את לבבנו לאמר עם גדול ורם ממנו ערים גדלת ובצורת בשמים וגם בני ענקים ראינו שם׃ ");
INSERT INTO heb_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","ואמר אלכם לא תערצון ולא תיראון מהם׃ ");
INSERT INTO heb_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","יהוה אלהיכם ההלך לפניכם הוא ילחם לכם ככל אשר עשה אתכם במצרים לעיניכם׃ ");
INSERT INTO heb_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","ובמדבר אשר ראית אשר נשאך יהוה אלהיך כאשר ישא איש את בנו בכל הדרך אשר הלכתם עד באכם עד המקום הזה׃ ");
INSERT INTO heb_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","ובדבר הזה אינכם מאמינם ביהוה אלהיכם׃ ");
INSERT INTO heb_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","ההלך לפניכם בדרך לתור לכם מקום לחנתכם באש לילה לראתכם בדרך אשר תלכו בה ובענן יומם׃ ");
INSERT INTO heb_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","וישמע יהוה את קול דבריכם ויקצף וישבע לאמר׃ ");
INSERT INTO heb_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","אם יראה איש באנשים האלה הדור הרע הזה את הארץ הטובה אשר נשבעתי לתת לאבתיכם׃ ");
INSERT INTO heb_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","זולתי כלב בן יפנה הוא יראנה ולו אתן את הארץ אשר דרך בה ולבניו יען אשר מלא אחרי יהוה׃ ");
INSERT INTO heb_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","גם בי התאנף יהוה בגללכם לאמר גם אתה לא תבא שם׃ ");
INSERT INTO heb_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","יהושע בן נון העמד לפניך הוא יבא שמה אתו חזק כי הוא ינחלנה את ישראל׃ ");
INSERT INTO heb_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","וטפכם אשר אמרתם לבז יהיה ובניכם אשר לא ידעו היום טוב ורע המה יבאו שמה ולהם אתננה והם יירשוה׃ ");
INSERT INTO heb_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","ואתם פנו לכם וסעו המדברה דרך ים סוף׃ ");
INSERT INTO heb_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","ותענו ותאמרו אלי חטאנו ליהוה אנחנו נעלה ונלחמנו ככל אשר צונו יהוה אלהינו ותחגרו איש את כלי מלחמתו ותהינו לעלת ההרה׃ ");
INSERT INTO heb_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","ויאמר יהוה אלי אמר להם לא תעלו ולא תלחמו כי אינני בקרבכם ולא תנגפו לפני איביכם׃ ");
INSERT INTO heb_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","ואדבר אליכם ולא שמעתם ותמרו את פי יהוה ותזדו ותעלו ההרה׃ ");
INSERT INTO heb_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","ויצא האמרי הישב בהר ההוא לקראתכם וירדפו אתכם כאשר תעשינה הדברים ויכתו אתכם בשעיר עד חרמה׃ ");
INSERT INTO heb_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","ותשבו ותבכו לפני יהוה ולא שמע יהוה בקלכם ולא האזין אליכם׃ ");
INSERT INTO heb_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","ותשבו בקדש ימים רבים כימים אשר ישבתם׃ ");
INSERT INTO heb_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","ונפן ונסע המדברה דרך ים סוף כאשר דבר יהוה אלי ונסב את הר שעיר ימים רבים׃ ");
INSERT INTO heb_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","ויאמר יהוה אלי לאמר׃ ");
INSERT INTO heb_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","רב לכם סב את ההר הזה פנו לכם צפנה׃ ");
INSERT INTO heb_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","ואת העם צו לאמר אתם עברים בגבול אחיכם בני עשו הישבים בשעיר וייראו מכם ונשמרתם מאד׃ ");
INSERT INTO heb_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","אל תתגרו בם כי לא אתן לכם מארצם עד מדרך כף רגל כי ירשה לעשו נתתי את הר שעיר׃ ");
INSERT INTO heb_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","אכל תשברו מאתם בכסף ואכלתם וגם מים תכרו מאתם בכסף ושתיתם׃ ");
INSERT INTO heb_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","כי יהוה אלהיך ברכך בכל מעשה ידך ידע לכתך את המדבר הגדל הזה זה ארבעים שנה יהוה אלהיך עמך לא חסרת דבר׃ ");
INSERT INTO heb_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","ונעבר מאת אחינו בני עשו הישבים בשעיר מדרך הערבה מאילת ומעצין גבר ונפן ונעבר דרך מדבר מואב׃ ");
INSERT INTO heb_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","ויאמר יהוה אלי אל תצר את מואב ואל תתגר בם מלחמה כי לא אתן לך מארצו ירשה כי לבני לוט נתתי את ער ירשה׃ ");
INSERT INTO heb_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","האמים לפנים ישבו בה עם גדול ורב ורם כענקים׃ ");
INSERT INTO heb_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","רפאים יחשבו אף הם כענקים והמאבים יקראו להם אמים׃ ");
INSERT INTO heb_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","ובשעיר ישבו החרים לפנים ובני עשו יירשום וישמידום מפניהם וישבו תחתם כאשר עשה ישראל לארץ ירשתו אשר נתן יהוה להם׃ ");
INSERT INTO heb_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","עתה קמו ועברו לכם את נחל זרד ונעבר את נחל זרד׃ ");
INSERT INTO heb_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","והימים אשר הלכנו מקדש ברנע עד אשר עברנו את נחל זרד שלשים ושמנה שנה עד תם כל הדור אנשי המלחמה מקרב המחנה כאשר נשבע יהוה להם׃ ");
INSERT INTO heb_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","וגם יד יהוה היתה בם להמם מקרב המחנה עד תמם׃ ");
INSERT INTO heb_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","ויהי כאשר תמו כל אנשי המלחמה למות מקרב העם׃ ");
INSERT INTO heb_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","וידבר יהוה אלי לאמר׃ ");
INSERT INTO heb_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","אתה עבר היום את גבול מואב את ער׃ ");
INSERT INTO heb_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","וקרבת מול בני עמון אל תצרם ואל תתגר בם כי לא אתן מארץ בני עמון לך ירשה כי לבני לוט נתתיה ירשה׃ ");
INSERT INTO heb_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","ארץ רפאים תחשב אף הוא רפאים ישבו בה לפנים והעמנים יקראו להם זמזמים׃ ");
INSERT INTO heb_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","עם גדול ורב ורם כענקים וישמידם יהוה מפניהם ויירשם וישבו תחתם׃ ");
INSERT INTO heb_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","כאשר עשה לבני עשו הישבים בשעיר אשר השמיד את החרי מפניהם ויירשם וישבו תחתם עד היום הזה׃ ");
INSERT INTO heb_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","והעוים הישבים בחצרים עד עזה כפתרים היצאים מכפתור השמידם וישבו תחתם׃ ");
INSERT INTO heb_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","קומו סעו ועברו את נחל ארנן ראה נתתי בידך את סיחן מלך חשבון האמרי ואת ארצו החל רש והתגר בו מלחמה׃ ");
INSERT INTO heb_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","היום הזה אחל תת פחדך ויראתך על פני העמים תחת כל השמים אשר ישמעון שמעך ורגזו וחלו מפניך׃ ");
INSERT INTO heb_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","ואשלח מלאכים ממדבר קדמות אל סיחון מלך חשבון דברי שלום לאמר׃ ");
INSERT INTO heb_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","אעברה בארצך בדרך בדרך אלך לא אסור ימין ושמאול׃ ");
INSERT INTO heb_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","אכל בכסף תשברני ואכלתי ומים בכסף תתן לי ושתיתי רק אעברה ברגלי׃ ");
INSERT INTO heb_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","כאשר עשו לי בני עשו הישבים בשעיר והמואבים הישבים בער עד אשר אעבר את הירדן אל הארץ אשר יהוה אלהינו נתן לנו׃ ");
INSERT INTO heb_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","ולא אבה סיחן מלך חשבון העברנו בו כי הקשה יהוה אלהיך את רוחו ואמץ את לבבו למען תתו בידך כיום הזה׃ ");
INSERT INTO heb_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","ויאמר יהוה אלי ראה החלתי תת לפניך את סיחן ואת ארצו החל רש לרשת את ארצו׃ ");
INSERT INTO heb_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","ויצא סיחן לקראתנו הוא וכל עמו למלחמה יהצה׃ ");
INSERT INTO heb_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","ויתנהו יהוה אלהינו לפנינו ונך אתו ואת בנו ואת כל עמו׃ ");
INSERT INTO heb_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","ונלכד את כל עריו בעת ההוא ונחרם את כל עיר מתם והנשים והטף לא השארנו שריד׃ ");
INSERT INTO heb_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","רק הבהמה בזזנו לנו ושלל הערים אשר לכדנו׃ ");
INSERT INTO heb_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","מערער אשר על שפת נחל ארנן והעיר אשר בנחל ועד הגלעד לא היתה קריה אשר שגבה ממנו את הכל נתן יהוה אלהינו לפנינו׃ ");
INSERT INTO heb_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","רק אל ארץ בני עמון לא קרבת כל יד נחל יבק וערי ההר וכל אשר צוה יהוה אלהינו׃ ");
INSERT INTO heb_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","ונפן ונעל דרך הבשן ויצא עוג מלך הבשן לקראתנו הוא וכל עמו למלחמה אדרעי׃ ");
INSERT INTO heb_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","ויאמר יהוה אלי אל תירא אתו כי בידך נתתי אתו ואת כל עמו ואת ארצו ועשית לו כאשר עשית לסיחן מלך האמרי אשר יושב בחשבון׃ ");
INSERT INTO heb_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","ויתן יהוה אלהינו בידנו גם את עוג מלך הבשן ואת כל עמו ונכהו עד בלתי השאיר לו שריד׃ ");
INSERT INTO heb_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","ונלכד את כל עריו בעת ההוא לא היתה קריה אשר לא לקחנו מאתם ששים עיר כל חבל ארגב ממלכת עוג בבשן׃ ");
INSERT INTO heb_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","כל אלה ערים בצרות חומה גבהה דלתים ובריח לבד מערי הפרזי הרבה מאד׃ ");
INSERT INTO heb_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","ונחרם אותם כאשר עשינו לסיחן מלך חשבון החרם כל עיר מתם הנשים והטף׃ ");
INSERT INTO heb_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","וכל הבהמה ושלל הערים בזונו לנו׃ ");
INSERT INTO heb_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","ונקח בעת ההוא את הארץ מיד שני מלכי האמרי אשר בעבר הירדן מנחל ארנן עד הר חרמון׃ ");
INSERT INTO heb_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","צידנים יקראו לחרמון שרין והאמרי יקראו לו שניר׃ ");
INSERT INTO heb_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","כל ערי המישר וכל הגלעד וכל הבשן עד סלכה ואדרעי ערי ממלכת עוג בבשן׃ ");
INSERT INTO heb_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","כי רק עוג מלך הבשן נשאר מיתר הרפאים הנה ערשו ערש ברזל הלה הוא ברבת בני עמון תשע אמות ארכה וארבע אמות רחבה באמת איש׃ ");
INSERT INTO heb_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","ואת הארץ הזאת ירשנו בעת ההוא מערער אשר על נחל ארנן וחצי הר הגלעד ועריו נתתי לראובני ולגדי׃ ");
INSERT INTO heb_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","ויתר הגלעד וכל הבשן ממלכת עוג נתתי לחצי שבט המנשה כל חבל הארגב לכל הבשן ההוא יקרא ארץ רפאים׃ ");
INSERT INTO heb_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","יאיר בן מנשה לקח את כל חבל ארגב עד גבול הגשורי והמעכתי ויקרא אתם על שמו את הבשן חות יאיר עד היום הזה׃ ");
INSERT INTO heb_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","ולמכיר נתתי את הגלעד׃ ");
INSERT INTO heb_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","ולראובני ולגדי נתתי מן הגלעד ועד נחל ארנן תוך הנחל וגבל ועד יבק הנחל גבול בני עמון׃ ");
INSERT INTO heb_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","והערבה והירדן וגבל מכנרת ועד ים הערבה ים המלח תחת אשדת הפסגה מזרחה׃ ");
INSERT INTO heb_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","ואצו אתכם בעת ההוא לאמר יהוה אלהיכם נתן לכם את הארץ הזאת לרשתה חלוצים תעברו לפני אחיכם בני ישראל כל בני חיל׃ ");
INSERT INTO heb_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","רק נשיכם וטפכם ומקנכם ידעתי כי מקנה רב לכם ישבו בעריכם אשר נתתי לכם׃ ");
INSERT INTO heb_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","עד אשר יניח יהוה לאחיכם ככם וירשו גם הם את הארץ אשר יהוה אלהיכם נתן להם בעבר הירדן ושבתם איש לירשתו אשר נתתי לכם׃ ");
INSERT INTO heb_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","ואת יהושוע צויתי בעת ההוא לאמר עיניך הראת את כל אשר עשה יהוה אלהיכם לשני המלכים האלה כן יעשה יהוה לכל הממלכות אשר אתה עבר שמה׃ ");
INSERT INTO heb_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","לא תיראום כי יהוה אלהיכם הוא הנלחם לכם׃ ");
INSERT INTO heb_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","ואתחנן אל יהוה בעת ההוא לאמר׃ ");
INSERT INTO heb_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","אדני יהוה אתה החלות להראות את עבדך את גדלך ואת ידך החזקה אשר מי אל בשמים ובארץ אשר יעשה כמעשיך וכגבורתך׃ ");
INSERT INTO heb_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","אעברה נא ואראה את הארץ הטובה אשר בעבר הירדן ההר הטוב הזה והלבנון׃ ");
INSERT INTO heb_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","ויתעבר יהוה בי למענכם ולא שמע אלי ויאמר יהוה אלי רב לך אל תוסף דבר אלי עוד בדבר הזה׃ ");
INSERT INTO heb_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","עלה ראש הפסגה ושא עיניך ימה וצפנה ותימנה ומזרחה וראה בעיניך כי לא תעבר את הירדן הזה׃ ");
INSERT INTO heb_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","וצו את יהושע וחזקהו ואמצהו כי הוא יעבר לפני העם הזה והוא ינחיל אותם את הארץ אשר תראה׃ ");
INSERT INTO heb_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","ונשב בגיא מול בית פעור׃ ");
INSERT INTO heb_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","ועתה ישראל שמע אל החקים ואל המשפטים אשר אנכי מלמד אתכם לעשות למען תחיו ובאתם וירשתם את הארץ אשר יהוה אלהי אבתיכם נתן לכם׃ ");
INSERT INTO heb_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","לא תספו על הדבר אשר אנכי מצוה אתכם ולא תגרעו ממנו לשמר את מצות יהוה אלהיכם אשר אנכי מצוה אתכם׃ ");
INSERT INTO heb_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","עיניכם הראת את אשר עשה יהוה בבעל פעור כי כל האיש אשר הלך אחרי בעל פעור השמידו יהוה אלהיך מקרבך׃ ");
INSERT INTO heb_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","ואתם הדבקים ביהוה אלהיכם חיים כלכם היום׃ ");
INSERT INTO heb_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","ראה למדתי אתכם חקים ומשפטים כאשר צוני יהוה אלהי לעשות כן בקרב הארץ אשר אתם באים שמה לרשתה׃ ");
INSERT INTO heb_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","ושמרתם ועשיתם כי הוא חכמתכם ובינתכם לעיני העמים אשר ישמעון את כל החקים האלה ואמרו רק עם חכם ונבון הגוי הגדול הזה׃ ");
INSERT INTO heb_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","כי מי גוי גדול אשר לו אלהים קרבים אליו כיהוה אלהינו בכל קראנו אליו׃ ");
INSERT INTO heb_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","ומי גוי גדול אשר לו חקים ומשפטים צדיקם ככל התורה הזאת אשר אנכי נתן לפניכם היום׃ ");
INSERT INTO heb_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","רק השמר לך ושמר נפשך מאד פן תשכח את הדברים אשר ראו עיניך ופן יסורו מלבבך כל ימי חייך והודעתם לבניך ולבני בניך׃ ");
INSERT INTO heb_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","יום אשר עמדת לפני יהוה אלהיך בחרב באמר יהוה אלי הקהל לי את העם ואשמעם את דברי אשר ילמדון ליראה אתי כל הימים אשר הם חיים על האדמה ואת בניהם ילמדון׃ ");
INSERT INTO heb_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","ותקרבון ותעמדון תחת ההר וההר בער באש עד לב השמים חשך ענן וערפל׃ ");
INSERT INTO heb_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","וידבר יהוה אליכם מתוך האש קול דברים אתם שמעים ותמונה אינכם ראים זולתי קול׃ ");
INSERT INTO heb_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","ויגד לכם את בריתו אשר צוה אתכם לעשות עשרת הדברים ויכתבם על שני לחות אבנים׃ ");
INSERT INTO heb_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","ואתי צוה יהוה בעת ההוא ללמד אתכם חקים ומשפטים לעשתכם אתם בארץ אשר אתם עברים שמה לרשתה׃ ");
INSERT INTO heb_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","ונשמרתם מאד לנפשתיכם כי לא ראיתם כל תמונה ביום דבר יהוה אליכם בחרב מתוך האש׃ ");
INSERT INTO heb_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","פן תשחתון ועשיתם לכם פסל תמונת כל סמל תבנית זכר או נקבה׃ ");
INSERT INTO heb_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","תבנית כל בהמה אשר בארץ תבנית כל צפור כנף אשר תעוף בשמים׃ ");
INSERT INTO heb_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","תבנית כל רמש באדמה תבנית כל דגה אשר במים מתחת לארץ׃ ");
INSERT INTO heb_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","ופן תשא עיניך השמימה וראית את השמש ואת הירח ואת הכוכבים כל צבא השמים ונדחת והשתחוית להם ועבדתם אשר חלק יהוה אלהיך אתם לכל העמים תחת כל השמים׃ ");
INSERT INTO heb_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","ואתכם לקח יהוה ויוצא אתכם מכור הברזל ממצרים להיות לו לעם נחלה כיום הזה׃ ");
INSERT INTO heb_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","ויהוה התאנף בי על דבריכם וישבע לבלתי עברי את הירדן ולבלתי בא אל הארץ הטובה אשר יהוה אלהיך נתן לך נחלה׃ ");
INSERT INTO heb_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","כי אנכי מת בארץ הזאת אינני עבר את הירדן ואתם עברים וירשתם את הארץ הטובה הזאת׃ ");
INSERT INTO heb_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","השמרו לכם פן תשכחו את ברית יהוה אלהיכם אשר כרת עמכם ועשיתם לכם פסל תמונת כל אשר צוך יהוה אלהיך׃ ");
INSERT INTO heb_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","כי יהוה אלהיך אש אכלה הוא אל קנא׃ ");
INSERT INTO heb_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","כי תוליד בנים ובני בנים ונושנתם בארץ והשחתם ועשיתם פסל תמונת כל ועשיתם הרע בעיני יהוה אלהיך להכעיסו׃ ");
INSERT INTO heb_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","העידתי בכם היום את השמים ואת הארץ כי אבד תאבדון מהר מעל הארץ אשר אתם עברים את הירדן שמה לרשתה לא תאריכן ימים עליה כי השמד תשמדון׃ ");
INSERT INTO heb_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","והפיץ יהוה אתכם בעמים ונשארתם מתי מספר בגוים אשר ינהג יהוה אתכם שמה׃ ");
INSERT INTO heb_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","ועבדתם שם אלהים מעשה ידי אדם עץ ואבן אשר לא יראון ולא ישמעון ולא יאכלון ולא יריחן׃ ");
INSERT INTO heb_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","ובקשתם משם את יהוה אלהיך ומצאת כי תדרשנו בכל לבבך ובכל נפשך׃ ");
INSERT INTO heb_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","בצר לך ומצאוך כל הדברים האלה באחרית הימים ושבת עד יהוה אלהיך ושמעת בקלו׃ ");
INSERT INTO heb_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","כי אל רחום יהוה אלהיך לא ירפך ולא ישחיתך ולא ישכח את ברית אבתיך אשר נשבע להם׃ ");
INSERT INTO heb_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","כי שאל נא לימים ראשנים אשר היו לפניך למן היום אשר ברא אלהים אדם על הארץ ולמקצה השמים ועד קצה השמים הנהיה כדבר הגדול הזה או הנשמע כמהו׃ ");
INSERT INTO heb_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","השמע עם קול אלהים מדבר מתוך האש כאשר שמעת אתה ויחי׃ ");
INSERT INTO heb_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","או הנסה אלהים לבוא לקחת לו גוי מקרב גוי במסת באתת ובמופתים ובמלחמה וביד חזקה ובזרוע נטויה ובמוראים גדלים ככל אשר עשה לכם יהוה אלהיכם במצרים לעיניך׃ ");
INSERT INTO heb_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","אתה הראת לדעת כי יהוה הוא האלהים אין עוד מלבדו׃ ");
INSERT INTO heb_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","מן השמים השמיעך את קלו ליסרך ועל הארץ הראך את אשו הגדולה ודבריו שמעת מתוך האש׃ ");
INSERT INTO heb_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","ותחת כי אהב את אבתיך ויבחר בזרעו אחריו ויוצאך בפניו בכחו הגדל ממצרים׃ ");
INSERT INTO heb_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","להוריש גוים גדלים ועצמים ממך מפניך להביאך לתת לך את ארצם נחלה כיום הזה׃ ");
INSERT INTO heb_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","וידעת היום והשבת אל לבבך כי יהוה הוא האלהים בשמים ממעל ועל הארץ מתחת אין עוד׃ ");
INSERT INTO heb_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","ושמרת את חקיו ואת מצותיו אשר אנכי מצוך היום אשר ייטב לך ולבניך אחריך ולמען תאריך ימים על האדמה אשר יהוה אלהיך נתן לך כל הימים׃ ");
INSERT INTO heb_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","אז יבדיל משה שלש ערים בעבר הירדן מזרחה שמש׃ ");
INSERT INTO heb_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","לנס שמה רוצח אשר ירצח את רעהו בבלי דעת והוא לא שנא לו מתמול שלשום ונס אל אחת מן הערים האל וחי׃ ");
INSERT INTO heb_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","את בצר במדבר בארץ המישר לראובני ואת ראמת בגלעד לגדי ואת גולן בבשן למנשי׃ ");
INSERT INTO heb_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","וזאת התורה אשר שם משה לפני בני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","אלה העדת והחקים והמשפטים אשר דבר משה אל בני ישראל בצאתם ממצרים׃ ");
INSERT INTO heb_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","בעבר הירדן בגיא מול בית פעור בארץ סיחן מלך האמרי אשר יושב בחשבון אשר הכה משה ובני ישראל בצאתם ממצרים׃ ");
INSERT INTO heb_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","ויירשו את ארצו ואת ארץ עוג מלך הבשן שני מלכי האמרי אשר בעבר הירדן מזרח שמש׃ ");
INSERT INTO heb_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","מערער אשר על שפת נחל ארנן ועד הר שיאן הוא חרמון׃ ");
INSERT INTO heb_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","וכל הערבה עבר הירדן מזרחה ועד ים הערבה תחת אשדת הפסגה׃ ");
INSERT INTO heb_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","ויקרא משה אל כל ישראל ויאמר אלהם שמע ישראל את החקים ואת המשפטים אשר אנכי דבר באזניכם היום ולמדתם אתם ושמרתם לעשתם׃ ");
INSERT INTO heb_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","יהוה אלהינו כרת עמנו ברית בחרב׃ ");
INSERT INTO heb_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","לא את אבתינו כרת יהוה את הברית הזאת כי אתנו אנחנו אלה פה היום כלנו חיים׃ ");
INSERT INTO heb_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","פנים בפנים דבר יהוה עמכם בהר מתוך האש׃ ");
INSERT INTO heb_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","אנכי עמד בין יהוה וביניכם בעת ההוא להגיד לכם את דבר יהוה כי יראתם מפני האש ולא עליתם בהר לאמר׃ ");
INSERT INTO heb_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","אנכי יהוה אלהיך אשר הוצאתיך מארץ מצרים מבית עבדים׃ ");
INSERT INTO heb_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","לא יהיה לך אלהים אחרים על פני׃ ");
INSERT INTO heb_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","לא תעשה לך פסל כל תמונה אשר בשמים ממעל ואשר בארץ מתחת ואשר במים מתחת לארץ׃ ");
INSERT INTO heb_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","לא תשתחוה להם ולא תעבדם כי אנכי יהוה אלהיך אל קנא פקד עון אבות על בנים ועל שלשים ועל רבעים לשנאי׃ ");
INSERT INTO heb_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","ועשה חסד לאלפים לאהבי ולשמרי מצותו׃ ");
INSERT INTO heb_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","לא תשא את שם יהוה אלהיך לשוא כי לא ינקה יהוה את אשר ישא את שמו לשוא׃ ");
INSERT INTO heb_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","שמור את יום השבת לקדשו כאשר צוך יהוה אלהיך׃ ");
INSERT INTO heb_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","ששת ימים תעבד ועשית כל מלאכתך׃ ");
INSERT INTO heb_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","ויום השביעי שבת ליהוה אלהיך לא תעשה כל מלאכה אתה ובנך ובתך ועבדך ואמתך ושורך וחמרך וכל בהמתך וגרך אשר בשעריך למען ינוח עבדך ואמתך כמוך׃ ");
INSERT INTO heb_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","וזכרת כי עבד היית בארץ מצרים ויצאך יהוה אלהיך משם ביד חזקה ובזרע נטויה על כן צוך יהוה אלהיך לעשות את יום השבת׃ ");
INSERT INTO heb_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","כבד את אביך ואת אמך כאשר צוך יהוה אלהיך למען יאריכן ימיך ולמען ייטב לך על האדמה אשר יהוה אלהיך נתן לך׃ ");
INSERT INTO heb_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","לא תרצח׃ ");
INSERT INTO heb_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","ולא תנאף׃ ");
INSERT INTO heb_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","ולא תגנב׃ ");
INSERT INTO heb_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","ולא תענה ברעך עד שוא׃ ");
INSERT INTO heb_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","ולא תחמד אשת רעך ולא תתאוה בית רעך שדהו ועבדו ואמתו שורו וחמרו וכל אשר לרעך׃ ");
INSERT INTO heb_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","את הדברים האלה דבר יהוה אל כל קהלכם בהר מתוך האש הענן והערפל קול גדול ולא יסף ויכתבם על שני לחת אבנים ויתנם אלי׃ ");
INSERT INTO heb_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","ויהי כשמעכם את הקול מתוך החשך וההר בער באש ותקרבון אלי כל ראשי שבטיכם וזקניכם׃ ");
INSERT INTO heb_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","ותאמרו הן הראנו יהוה אלהינו את כבדו ואת גדלו ואת קלו שמענו מתוך האש היום הזה ראינו כי ידבר אלהים את האדם וחי׃ ");
INSERT INTO heb_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","ועתה למה נמות כי תאכלנו האש הגדלה הזאת אם יספים אנחנו לשמע את קול יהוה אלהינו עוד ומתנו׃ ");
INSERT INTO heb_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","כי מי כל בשר אשר שמע קול אלהים חיים מדבר מתוך האש כמנו ויחי׃ ");
INSERT INTO heb_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","קרב אתה ושמע את כל אשר יאמר יהוה אלהינו ואת תדבר אלינו את כל אשר ידבר יהוה אלהינו אליך ושמענו ועשינו׃ ");
INSERT INTO heb_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","וישמע יהוה את קול דבריכם בדברכם אלי ויאמר יהוה אלי שמעתי את קול דברי העם הזה אשר דברו אליך היטיבו כל אשר דברו׃ ");
INSERT INTO heb_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","מי יתן והיה לבבם זה להם ליראה אתי ולשמר את כל מצותי כל הימים למען ייטב להם ולבניהם לעלם׃ ");
INSERT INTO heb_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","לך אמר להם שובו לכם לאהליכם׃ ");
INSERT INTO heb_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","ואתה פה עמד עמדי ואדברה אליך את כל המצוה והחקים והמשפטים אשר תלמדם ועשו בארץ אשר אנכי נתן להם לרשתה׃ ");
INSERT INTO heb_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","ושמרתם לעשות כאשר צוה יהוה אלהיכם אתכם לא תסרו ימין ושמאל׃ ");
INSERT INTO heb_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","בכל הדרך אשר צוה יהוה אלהיכם אתכם תלכו למען תחיון וטוב לכם והארכתם ימים בארץ אשר תירשון׃ ");
INSERT INTO heb_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","וזאת המצוה החקים והמשפטים אשר צוה יהוה אלהיכם ללמד אתכם לעשות בארץ אשר אתם עברים שמה לרשתה׃ ");
INSERT INTO heb_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","למען תירא את יהוה אלהיך לשמר את כל חקתיו ומצותיו אשר אנכי מצוך אתה ובנך ובן בנך כל ימי חייך ולמען יארכן ימיך׃ ");
INSERT INTO heb_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","ושמעת ישראל ושמרת לעשות אשר ייטב לך ואשר תרבון מאד כאשר דבר יהוה אלהי אבתיך לך ארץ זבת חלב ודבש׃ ");
INSERT INTO heb_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","שמע ישראל יהוה אלהינו יהוה אחד׃ ");
INSERT INTO heb_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","ואהבת את יהוה אלהיך בכל לבבך ובכל נפשך ובכל מאדך׃ ");
INSERT INTO heb_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","והיו הדברים האלה אשר אנכי מצוך היום על לבבך׃ ");
INSERT INTO heb_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","ושננתם לבניך ודברת בם בשבתך בביתך ובלכתך בדרך ובשכבך ובקומך׃ ");
INSERT INTO heb_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","וקשרתם לאות על ידך והיו לטטפת בין עיניך׃ ");
INSERT INTO heb_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","וכתבתם על מזוזת ביתך ובשעריך׃ ");
INSERT INTO heb_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","והיה כי יביאך יהוה אלהיך אל הארץ אשר נשבע לאבתיך לאברהם ליצחק וליעקב לתת לך ערים גדלת וטבת אשר לא בנית׃ ");
INSERT INTO heb_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","ובתים מלאים כל טוב אשר לא מלאת וברת חצובים אשר לא חצבת כרמים וזיתים אשר לא נטעת ואכלת ושבעת׃ ");
INSERT INTO heb_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","השמר לך פן תשכח את יהוה אשר הוציאך מארץ מצרים מבית עבדים׃ ");
INSERT INTO heb_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","את יהוה אלהיך תירא ואתו תעבד ובשמו תשבע׃ ");
INSERT INTO heb_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","לא תלכון אחרי אלהים אחרים מאלהי העמים אשר סביבותיכם׃ ");
INSERT INTO heb_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","כי אל קנא יהוה אלהיך בקרבך פן יחרה אף יהוה אלהיך בך והשמידך מעל פני האדמה׃ ");
INSERT INTO heb_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","לא תנסו את יהוה אלהיכם כאשר נסיתם במסה׃ ");
INSERT INTO heb_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","שמור תשמרון את מצות יהוה אלהיכם ועדתיו וחקיו אשר צוך׃ ");
INSERT INTO heb_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","ועשית הישר והטוב בעיני יהוה למען ייטב לך ובאת וירשת את הארץ הטבה אשר נשבע יהוה לאבתיך׃ ");
INSERT INTO heb_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","להדף את כל איביך מפניך כאשר דבר יהוה׃ ");
INSERT INTO heb_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","כי ישאלך בנך מחר לאמר מה העדת והחקים והמשפטים אשר צוה יהוה אלהינו אתכם׃ ");
INSERT INTO heb_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","ואמרת לבנך עבדים היינו לפרעה במצרים ויוציאנו יהוה ממצרים ביד חזקה׃ ");
INSERT INTO heb_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","ויתן יהוה אותת ומפתים גדלים ורעים במצרים בפרעה ובכל ביתו לעינינו׃ ");
INSERT INTO heb_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","ואותנו הוציא משם למען הביא אתנו לתת לנו את הארץ אשר נשבע לאבתינו׃ ");
INSERT INTO heb_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","ויצונו יהוה לעשות את כל החקים האלה ליראה את יהוה אלהינו לטוב לנו כל הימים לחיתנו כהיום הזה׃ ");
INSERT INTO heb_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","וצדקה תהיה לנו כי נשמר לעשות את כל המצוה הזאת לפני יהוה אלהינו כאשר צונו׃ ");
INSERT INTO heb_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","כי יביאך יהוה אלהיך אל הארץ אשר אתה בא שמה לרשתה ונשל גוים רבים מפניך החתי והגרגשי והאמרי והכנעני והפרזי והחוי והיבוסי שבעה גוים רבים ועצומים ממך׃ ");
INSERT INTO heb_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","ונתנם יהוה אלהיך לפניך והכיתם החרם תחרים אתם לא תכרת להם ברית ולא תחנם׃ ");
INSERT INTO heb_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","ולא תתחתן בם בתך לא תתן לבנו ובתו לא תקח לבנך׃ ");
INSERT INTO heb_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","כי יסיר את בנך מאחרי ועבדו אלהים אחרים וחרה אף יהוה בכם והשמידך מהר׃ ");
INSERT INTO heb_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","כי אם כה תעשו להם מזבחתיהם תתצו ומצבתם תשברו ואשירהם תגדעון ופסיליהם תשרפון באש׃ ");
INSERT INTO heb_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","כי עם קדוש אתה ליהוה אלהיך בך בחר יהוה אלהיך להיות לו לעם סגלה מכל העמים אשר על פני האדמה׃ ");
INSERT INTO heb_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","לא מרבכם מכל העמים חשק יהוה בכם ויבחר בכם כי אתם המעט מכל העמים׃ ");
INSERT INTO heb_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","כי מאהבת יהוה אתכם ומשמרו את השבעה אשר נשבע לאבתיכם הוציא יהוה אתכם ביד חזקה ויפדך מבית עבדים מיד פרעה מלך מצרים׃ ");
INSERT INTO heb_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","וידעת כי יהוה אלהיך הוא האלהים האל הנאמן שמר הברית והחסד לאהביו ולשמרי מצותו לאלף דור׃ ");
INSERT INTO heb_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","ומשלם לשנאיו אל פניו להאבידו לא יאחר לשנאו אל פניו ישלם לו׃ ");
INSERT INTO heb_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","ושמרת את המצוה ואת החקים ואת המשפטים אשר אנכי מצוך היום לעשותם׃ ");
INSERT INTO heb_vpl VALUES ("DT7_12","006_7_12","DEU","7","12","12","והיה עקב תשמעון את המשפטים האלה ושמרתם ועשיתם אתם ושמר יהוה אלהיך לך את הברית ואת החסד אשר נשבע לאבתיך׃ ");
INSERT INTO heb_vpl VALUES ("DT7_13","006_7_13","DEU","7","13","13","ואהבך וברכך והרבך וברך פרי בטנך ופרי אדמתך דגנך ותירשך ויצהרך שגר אלפיך ועשתרת צאנך על האדמה אשר נשבע לאבתיך לתת לך׃ ");
INSERT INTO heb_vpl VALUES ("DT7_14","006_7_14","DEU","7","14","14","ברוך תהיה מכל העמים לא יהיה בך עקר ועקרה ובבהמתך׃ ");
INSERT INTO heb_vpl VALUES ("DT7_15","006_7_15","DEU","7","15","15","והסיר יהוה ממך כל חלי וכל מדוי מצרים הרעים אשר ידעת לא ישימם בך ונתנם בכל שנאיך׃ ");
INSERT INTO heb_vpl VALUES ("DT7_16","006_7_16","DEU","7","16","16","ואכלת את כל העמים אשר יהוה אלהיך נתן לך לא תחס עינך עליהם ולא תעבד את אלהיהם כי מוקש הוא לך׃ ");
INSERT INTO heb_vpl VALUES ("DT7_17","006_7_17","DEU","7","17","17","כי תאמר בלבבך רבים הגוים האלה ממני איכה אוכל להורישם׃ ");
INSERT INTO heb_vpl VALUES ("DT7_18","006_7_18","DEU","7","18","18","לא תירא מהם זכר תזכר את אשר עשה יהוה אלהיך לפרעה ולכל מצרים׃ ");
INSERT INTO heb_vpl VALUES ("DT7_19","006_7_19","DEU","7","19","19","המסת הגדלת אשר ראו עיניך והאתת והמפתים והיד החזקה והזרע הנטויה אשר הוצאך יהוה אלהיך כן יעשה יהוה אלהיך לכל העמים אשר אתה ירא מפניהם׃ ");
INSERT INTO heb_vpl VALUES ("DT7_20","006_7_20","DEU","7","20","20","וגם את הצרעה ישלח יהוה אלהיך בם עד אבד הנשארים והנסתרים מפניך׃ ");
INSERT INTO heb_vpl VALUES ("DT7_21","006_7_21","DEU","7","21","21","לא תערץ מפניהם כי יהוה אלהיך בקרבך אל גדול ונורא׃ ");
INSERT INTO heb_vpl VALUES ("DT7_22","006_7_22","DEU","7","22","22","ונשל יהוה אלהיך את הגוים האל מפניך מעט מעט לא תוכל כלתם מהר פן תרבה עליך חית השדה׃ ");
INSERT INTO heb_vpl VALUES ("DT7_23","006_7_23","DEU","7","23","23","ונתנם יהוה אלהיך לפניך והמם מהומה גדלה עד השמדם׃ ");
INSERT INTO heb_vpl VALUES ("DT7_24","006_7_24","DEU","7","24","24","ונתן מלכיהם בידך והאבדת את שמם מתחת השמים לא יתיצב איש בפניך עד השמדך אתם׃ ");
INSERT INTO heb_vpl VALUES ("DT7_25","006_7_25","DEU","7","25","25","פסילי אלהיהם תשרפון באש לא תחמד כסף וזהב עליהם ולקחת לך פן תוקש בו כי תועבת יהוה אלהיך הוא׃ ");
INSERT INTO heb_vpl VALUES ("DT7_26","006_7_26","DEU","7","26","26","ולא תביא תועבה אל ביתך והיית חרם כמהו שקץ תשקצנו ותעב תתעבנו כי חרם הוא׃ ");
INSERT INTO heb_vpl VALUES ("DT8_1","006_8_1","DEU","8","1","1","כל המצוה אשר אנכי מצוך היום תשמרון לעשות למען תחיון ורביתם ובאתם וירשתם את הארץ אשר נשבע יהוה לאבתיכם׃ ");
INSERT INTO heb_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","וזכרת את כל הדרך אשר הליכך יהוה אלהיך זה ארבעים שנה במדבר למען ענתך לנסתך לדעת את אשר בלבבך התשמר מצותו אם לא׃ ");
INSERT INTO heb_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","ויענך וירעבך ויאכלך את המן אשר לא ידעת ולא ידעון אבתיך למען הודעך כי לא על הלחם לבדו יחיה האדם כי על כל מוצא פי יהוה יחיה האדם׃ ");
INSERT INTO heb_vpl VALUES ("DT8_4","006_8_4","DEU","8","4","4","שמלתך לא בלתה מעליך ורגלך לא בצקה זה ארבעים שנה׃ ");
INSERT INTO heb_vpl VALUES ("DT8_5","006_8_5","DEU","8","5","5","וידעת עם לבבך כי כאשר ייסר איש את בנו יהוה אלהיך מיסרך׃ ");
INSERT INTO heb_vpl VALUES ("DT8_6","006_8_6","DEU","8","6","6","ושמרת את מצות יהוה אלהיך ללכת בדרכיו וליראה אתו׃ ");
INSERT INTO heb_vpl VALUES ("DT8_7","006_8_7","DEU","8","7","7","כי יהוה אלהיך מביאך אל ארץ טובה ארץ נחלי מים עינת ותהמת יצאים בבקעה ובהר׃ ");
INSERT INTO heb_vpl VALUES ("DT8_8","006_8_8","DEU","8","8","8","ארץ חטה ושערה וגפן ותאנה ורמון ארץ זית שמן ודבש׃ ");
INSERT INTO heb_vpl VALUES ("DT8_9","006_8_9","DEU","8","9","9","ארץ אשר לא במסכנת תאכל בה לחם לא תחסר כל בה ארץ אשר אבניה ברזל ומהרריה תחצב נחשת׃ ");
INSERT INTO heb_vpl VALUES ("DT8_10","006_8_10","DEU","8","10","10","ואכלת ושבעת וברכת את יהוה אלהיך על הארץ הטבה אשר נתן לך׃ ");
INSERT INTO heb_vpl VALUES ("DT8_11","006_8_11","DEU","8","11","11","השמר לך פן תשכח את יהוה אלהיך לבלתי שמר מצותיו ומשפטיו וחקתיו אשר אנכי מצוך היום׃ ");
INSERT INTO heb_vpl VALUES ("DT8_12","006_8_12","DEU","8","12","12","פן תאכל ושבעת ובתים טובים תבנה וישבת׃ ");
INSERT INTO heb_vpl VALUES ("DT8_13","006_8_13","DEU","8","13","13","ובקרך וצאנך ירבין וכסף וזהב ירבה לך וכל אשר לך ירבה׃ ");
INSERT INTO heb_vpl VALUES ("DT8_14","006_8_14","DEU","8","14","14","ורם לבבך ושכחת את יהוה אלהיך המוציאך מארץ מצרים מבית עבדים׃ ");
INSERT INTO heb_vpl VALUES ("DT8_15","006_8_15","DEU","8","15","15","המוליכך במדבר הגדל והנורא נחש שרף ועקרב וצמאון אשר אין מים המוציא לך מים מצור החלמיש׃ ");
INSERT INTO heb_vpl VALUES ("DT8_16","006_8_16","DEU","8","16","16","המאכלך מן במדבר אשר לא ידעון אבתיך למען ענתך ולמען נסתך להיטבך באחריתך׃ ");
INSERT INTO heb_vpl VALUES ("DT8_17","006_8_17","DEU","8","17","17","ואמרת בלבבך כחי ועצם ידי עשה לי את החיל הזה׃ ");
INSERT INTO heb_vpl VALUES ("DT8_18","006_8_18","DEU","8","18","18","וזכרת את יהוה אלהיך כי הוא הנתן לך כח לעשות חיל למען הקים את בריתו אשר נשבע לאבתיך כיום הזה׃ ");
INSERT INTO heb_vpl VALUES ("DT8_19","006_8_19","DEU","8","19","19","והיה אם שכח תשכח את יהוה אלהיך והלכת אחרי אלהים אחרים ועבדתם והשתחוית להם העדתי בכם היום כי אבד תאבדון׃ ");
INSERT INTO heb_vpl VALUES ("DT8_20","006_8_20","DEU","8","20","20","כגוים אשר יהוה מאביד מפניכם כן תאבדון עקב לא תשמעון בקול יהוה אלהיכם׃ ");
INSERT INTO heb_vpl VALUES ("DT9_1","006_9_1","DEU","9","1","1","שמע ישראל אתה עבר היום את הירדן לבא לרשת גוים גדלים ועצמים ממך ערים גדלת ובצרת בשמים׃ ");
INSERT INTO heb_vpl VALUES ("DT9_2","006_9_2","DEU","9","2","2","עם גדול ורם בני ענקים אשר אתה ידעת ואתה שמעת מי יתיצב לפני בני ענק׃ ");
INSERT INTO heb_vpl VALUES ("DT9_3","006_9_3","DEU","9","3","3","וידעת היום כי יהוה אלהיך הוא העבר לפניך אש אכלה הוא ישמידם והוא יכניעם לפניך והורשתם והאבדתם מהר כאשר דבר יהוה לך׃ ");
INSERT INTO heb_vpl VALUES ("DT9_4","006_9_4","DEU","9","4","4","אל תאמר בלבבך בהדף יהוה אלהיך אתם מלפניך לאמר בצדקתי הביאני יהוה לרשת את הארץ הזאת וברשעת הגוים האלה יהוה מורישם מפניך׃ ");
INSERT INTO heb_vpl VALUES ("DT9_5","006_9_5","DEU","9","5","5","לא בצדקתך ובישר לבבך אתה בא לרשת את ארצם כי ברשעת הגוים האלה יהוה אלהיך מורישם מפניך ולמען הקים את הדבר אשר נשבע יהוה לאבתיך לאברהם ליצחק וליעקב׃ ");
INSERT INTO heb_vpl VALUES ("DT9_6","006_9_6","DEU","9","6","6","וידעת כי לא בצדקתך יהוה אלהיך נתן לך את הארץ הטובה הזאת לרשתה כי עם קשה ערף אתה׃ ");
INSERT INTO heb_vpl VALUES ("DT9_7","006_9_7","DEU","9","7","7","זכר אל תשכח את אשר הקצפת את יהוה אלהיך במדבר למן היום אשר יצאת מארץ מצרים עד באכם עד המקום הזה ממרים הייתם עם יהוה׃ ");
INSERT INTO heb_vpl VALUES ("DT9_8","006_9_8","DEU","9","8","8","ובחרב הקצפתם את יהוה ויתאנף יהוה בכם להשמיד אתכם׃ ");
INSERT INTO heb_vpl VALUES ("DT9_9","006_9_9","DEU","9","9","9","בעלתי ההרה לקחת לוחת האבנים לוחת הברית אשר כרת יהוה עמכם ואשב בהר ארבעים יום וארבעים לילה לחם לא אכלתי ומים לא שתיתי׃ ");
INSERT INTO heb_vpl VALUES ("DT9_10","006_9_10","DEU","9","10","10","ויתן יהוה אלי את שני לוחת האבנים כתבים באצבע אלהים ועליהם ככל הדברים אשר דבר יהוה עמכם בהר מתוך האש ביום הקהל׃ ");
INSERT INTO heb_vpl VALUES ("DT9_11","006_9_11","DEU","9","11","11","ויהי מקץ ארבעים יום וארבעים לילה נתן יהוה אלי את שני לחת האבנים לחות הברית׃ ");
INSERT INTO heb_vpl VALUES ("DT9_12","006_9_12","DEU","9","12","12","ויאמר יהוה אלי קום רד מהר מזה כי שחת עמך אשר הוצאת ממצרים סרו מהר מן הדרך אשר צויתם עשו להם מסכה׃ ");
INSERT INTO heb_vpl VALUES ("DT9_13","006_9_13","DEU","9","13","13","ויאמר יהוה אלי לאמר ראיתי את העם הזה והנה עם קשה ערף הוא׃ ");
INSERT INTO heb_vpl VALUES ("DT9_14","006_9_14","DEU","9","14","14","הרף ממני ואשמידם ואמחה את שמם מתחת השמים ואעשה אותך לגוי עצום ורב ממנו׃ ");
INSERT INTO heb_vpl VALUES ("DT9_15","006_9_15","DEU","9","15","15","ואפן וארד מן ההר וההר בער באש ושני לחת הברית על שתי ידי׃ ");
INSERT INTO heb_vpl VALUES ("DT9_16","006_9_16","DEU","9","16","16","וארא והנה חטאתם ליהוה אלהיכם עשיתם לכם עגל מסכה סרתם מהר מן הדרך אשר צוה יהוה אתכם׃ ");
INSERT INTO heb_vpl VALUES ("DT9_17","006_9_17","DEU","9","17","17","ואתפש בשני הלחת ואשלכם מעל שתי ידי ואשברם לעיניכם׃ ");
INSERT INTO heb_vpl VALUES ("DT9_18","006_9_18","DEU","9","18","18","ואתנפל לפני יהוה כראשנה ארבעים יום וארבעים לילה לחם לא אכלתי ומים לא שתיתי על כל חטאתכם אשר חטאתם לעשות הרע בעיני יהוה להכעיסו׃ ");
INSERT INTO heb_vpl VALUES ("DT9_19","006_9_19","DEU","9","19","19","כי יגרתי מפני האף והחמה אשר קצף יהוה עליכם להשמיד אתכם וישמע יהוה אלי גם בפעם ההוא׃ ");
INSERT INTO heb_vpl VALUES ("DT9_20","006_9_20","DEU","9","20","20","ובאהרן התאנף יהוה מאד להשמידו ואתפלל גם בעד אהרן בעת ההוא׃ ");
INSERT INTO heb_vpl VALUES ("DT9_21","006_9_21","DEU","9","21","21","ואת חטאתכם אשר עשיתם את העגל לקחתי ואשרף אתו באש ואכת אתו טחון היטב עד אשר דק לעפר ואשלך את עפרו אל הנחל הירד מן ההר׃ ");
INSERT INTO heb_vpl VALUES ("DT9_22","006_9_22","DEU","9","22","22","ובתבערה ובמסה ובקברת התאוה מקצפים הייתם את יהוה׃ ");
INSERT INTO heb_vpl VALUES ("DT9_23","006_9_23","DEU","9","23","23","ובשלח יהוה אתכם מקדש ברנע לאמר עלו ורשו את הארץ אשר נתתי לכם ותמרו את פי יהוה אלהיכם ולא האמנתם לו ולא שמעתם בקלו׃ ");
INSERT INTO heb_vpl VALUES ("DT9_24","006_9_24","DEU","9","24","24","ממרים הייתם עם יהוה מיום דעתי אתכם׃ ");
INSERT INTO heb_vpl VALUES ("DT9_25","006_9_25","DEU","9","25","25","ואתנפל לפני יהוה את ארבעים היום ואת ארבעים הלילה אשר התנפלתי כי אמר יהוה להשמיד אתכם׃ ");
INSERT INTO heb_vpl VALUES ("DT9_26","006_9_26","DEU","9","26","26","ואתפלל אל יהוה ואמר אדני יהוה אל תשחת עמך ונחלתך אשר פדית בגדלך אשר הוצאת ממצרים ביד חזקה׃ ");
INSERT INTO heb_vpl VALUES ("DT9_27","006_9_27","DEU","9","27","27","זכר לעבדיך לאברהם ליצחק וליעקב אל תפן אל קשי העם הזה ואל רשעו ואל חטאתו׃ ");
INSERT INTO heb_vpl VALUES ("DT9_28","006_9_28","DEU","9","28","28","פן יאמרו הארץ אשר הוצאתנו משם מבלי יכלת יהוה להביאם אל הארץ אשר דבר להם ומשנאתו אותם הוציאם להמתם במדבר׃ ");
INSERT INTO heb_vpl VALUES ("DT9_29","006_9_29","DEU","9","29","29","והם עמך ונחלתך אשר הוצאת בכחך הגדל ובזרעך הנטויה׃ ");
INSERT INTO heb_vpl VALUES ("DT10_1","006_10_1","DEU","10","1","1","בעת ההוא אמר יהוה אלי פסל לך שני לוחת אבנים כראשנים ועלה אלי ההרה ועשית לך ארון עץ׃ ");
INSERT INTO heb_vpl VALUES ("DT10_2","006_10_2","DEU","10","2","2","ואכתב על הלחת את הדברים אשר היו על הלחת הראשנים אשר שברת ושמתם בארון׃ ");
INSERT INTO heb_vpl VALUES ("DT10_3","006_10_3","DEU","10","3","3","ואעש ארון עצי שטים ואפסל שני לחת אבנים כראשנים ואעל ההרה ושני הלחת בידי׃ ");
INSERT INTO heb_vpl VALUES ("DT10_4","006_10_4","DEU","10","4","4","ויכתב על הלחת כמכתב הראשון את עשרת הדברים אשר דבר יהוה אליכם בהר מתוך האש ביום הקהל ויתנם יהוה אלי׃ ");
INSERT INTO heb_vpl VALUES ("DT10_5","006_10_5","DEU","10","5","5","ואפן וארד מן ההר ואשם את הלחת בארון אשר עשיתי ויהיו שם כאשר צוני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("DT10_6","006_10_6","DEU","10","6","6","ובני ישראל נסעו מבארת בני יעקן מוסרה שם מת אהרן ויקבר שם ויכהן אלעזר בנו תחתיו׃ ");
INSERT INTO heb_vpl VALUES ("DT10_7","006_10_7","DEU","10","7","7","משם נסעו הגדגדה ומן הגדגדה יטבתה ארץ נחלי מים׃ ");
INSERT INTO heb_vpl VALUES ("DT10_8","006_10_8","DEU","10","8","8","בעת ההוא הבדיל יהוה את שבט הלוי לשאת את ארון ברית יהוה לעמד לפני יהוה לשרתו ולברך בשמו עד היום הזה׃ ");
INSERT INTO heb_vpl VALUES ("DT10_9","006_10_9","DEU","10","9","9","על כן לא היה ללוי חלק ונחלה עם אחיו יהוה הוא נחלתו כאשר דבר יהוה אלהיך לו׃ ");
INSERT INTO heb_vpl VALUES ("DT10_10","006_10_10","DEU","10","10","10","ואנכי עמדתי בהר כימים הראשנים ארבעים יום וארבעים לילה וישמע יהוה אלי גם בפעם ההוא לא אבה יהוה השחיתך׃ ");
INSERT INTO heb_vpl VALUES ("DT10_11","006_10_11","DEU","10","11","11","ויאמר יהוה אלי קום לך למסע לפני העם ויבאו וירשו את הארץ אשר נשבעתי לאבתם לתת להם׃ ");
INSERT INTO heb_vpl VALUES ("DT10_12","006_10_12","DEU","10","12","12","ועתה ישראל מה יהוה אלהיך שאל מעמך כי אם ליראה את יהוה אלהיך ללכת בכל דרכיו ולאהבה אתו ולעבד את יהוה אלהיך בכל לבבך ובכל נפשך׃ ");
INSERT INTO heb_vpl VALUES ("DT10_13","006_10_13","DEU","10","13","13","לשמר את מצות יהוה ואת חקתיו אשר אנכי מצוך היום לטוב לך׃ ");
INSERT INTO heb_vpl VALUES ("DT10_14","006_10_14","DEU","10","14","14","הן ליהוה אלהיך השמים ושמי השמים הארץ וכל אשר בה׃ ");
INSERT INTO heb_vpl VALUES ("DT10_15","006_10_15","DEU","10","15","15","רק באבתיך חשק יהוה לאהבה אותם ויבחר בזרעם אחריהם בכם מכל העמים כיום הזה׃ ");
INSERT INTO heb_vpl VALUES ("DT10_16","006_10_16","DEU","10","16","16","ומלתם את ערלת לבבכם וערפכם לא תקשו עוד׃ ");
INSERT INTO heb_vpl VALUES ("DT10_17","006_10_17","DEU","10","17","17","כי יהוה אלהיכם הוא אלהי האלהים ואדני האדנים האל הגדל הגבר והנורא אשר לא ישא פנים ולא יקח שחד׃ ");
INSERT INTO heb_vpl VALUES ("DT10_18","006_10_18","DEU","10","18","18","עשה משפט יתום ואלמנה ואהב גר לתת לו לחם ושמלה׃ ");
INSERT INTO heb_vpl VALUES ("DT10_19","006_10_19","DEU","10","19","19","ואהבתם את הגר כי גרים הייתם בארץ מצרים׃ ");
INSERT INTO heb_vpl VALUES ("DT10_20","006_10_20","DEU","10","20","20","את יהוה אלהיך תירא אתו תעבד ובו תדבק ובשמו תשבע׃ ");
INSERT INTO heb_vpl VALUES ("DT10_21","006_10_21","DEU","10","21","21","הוא תהלתך והוא אלהיך אשר עשה אתך את הגדלת ואת הנוראת האלה אשר ראו עיניך׃ ");
INSERT INTO heb_vpl VALUES ("DT10_22","006_10_22","DEU","10","22","22","בשבעים נפש ירדו אבתיך מצרימה ועתה שמך יהוה אלהיך ככוכבי השמים לרב׃ ");
INSERT INTO heb_vpl VALUES ("DT11_1","006_11_1","DEU","11","1","1","ואהבת את יהוה אלהיך ושמרת משמרתו וחקתיו ומשפטיו ומצותיו כל הימים׃ ");
INSERT INTO heb_vpl VALUES ("DT11_2","006_11_2","DEU","11","2","2","וידעתם היום כי לא את בניכם אשר לא ידעו ואשר לא ראו את מוסר יהוה אלהיכם את גדלו את ידו החזקה וזרעו הנטויה׃ ");
INSERT INTO heb_vpl VALUES ("DT11_3","006_11_3","DEU","11","3","3","ואת אתתיו ואת מעשיו אשר עשה בתוך מצרים לפרעה מלך מצרים ולכל ארצו׃ ");
INSERT INTO heb_vpl VALUES ("DT11_4","006_11_4","DEU","11","4","4","ואשר עשה לחיל מצרים לסוסיו ולרכבו אשר הציף את מי ים סוף על פניהם ברדפם אחריכם ויאבדם יהוה עד היום הזה׃ ");
INSERT INTO heb_vpl VALUES ("DT11_5","006_11_5","DEU","11","5","5","ואשר עשה לכם במדבר עד באכם עד המקום הזה׃ ");
INSERT INTO heb_vpl VALUES ("DT11_6","006_11_6","DEU","11","6","6","ואשר עשה לדתן ולאבירם בני אליאב בן ראובן אשר פצתה הארץ את פיה ותבלעם ואת בתיהם ואת אהליהם ואת כל היקום אשר ברגליהם בקרב כל ישראל׃ ");
INSERT INTO heb_vpl VALUES ("DT11_7","006_11_7","DEU","11","7","7","כי עיניכם הראת את כל מעשה יהוה הגדל אשר עשה׃ ");
INSERT INTO heb_vpl VALUES ("DT11_8","006_11_8","DEU","11","8","8","ושמרתם את כל המצוה אשר אנכי מצוך היום למען תחזקו ובאתם וירשתם את הארץ אשר אתם עברים שמה לרשתה׃ ");
INSERT INTO heb_vpl VALUES ("DT11_9","006_11_9","DEU","11","9","9","ולמען תאריכו ימים על האדמה אשר נשבע יהוה לאבתיכם לתת להם ולזרעם ארץ זבת חלב ודבש׃ ");
INSERT INTO heb_vpl VALUES ("DT11_10","006_11_10","DEU","11","10","10","כי הארץ אשר אתה בא שמה לרשתה לא כארץ מצרים הוא אשר יצאתם משם אשר תזרע את זרעך והשקית ברגלך כגן הירק׃ ");
INSERT INTO heb_vpl VALUES ("DT11_11","006_11_11","DEU","11","11","11","והארץ אשר אתם עברים שמה לרשתה ארץ הרים ובקעת למטר השמים תשתה מים׃ ");
INSERT INTO heb_vpl VALUES ("DT11_12","006_11_12","DEU","11","12","12","ארץ אשר יהוה אלהיך דרש אתה תמיד עיני יהוה אלהיך בה מרשית השנה ועד אחרית שנה׃ ");
INSERT INTO heb_vpl VALUES ("DT11_13","006_11_13","DEU","11","13","13","והיה אם שמע תשמעו אל מצותי אשר אנכי מצוה אתכם היום לאהבה את יהוה אלהיכם ולעבדו בכל לבבכם ובכל נפשכם׃ ");
INSERT INTO heb_vpl VALUES ("DT11_14","006_11_14","DEU","11","14","14","ונתתי מטר ארצכם בעתו יורה ומלקוש ואספת דגנך ותירשך ויצהרך׃ ");
INSERT INTO heb_vpl VALUES ("DT11_15","006_11_15","DEU","11","15","15","ונתתי עשב בשדך לבהמתך ואכלת ושבעת׃ ");
INSERT INTO heb_vpl VALUES ("DT11_16","006_11_16","DEU","11","16","16","השמרו לכם פן יפתה לבבכם וסרתם ועבדתם אלהים אחרים והשתחויתם להם׃ ");
INSERT INTO heb_vpl VALUES ("DT11_17","006_11_17","DEU","11","17","17","וחרה אף יהוה בכם ועצר את השמים ולא יהיה מטר והאדמה לא תתן את יבולה ואבדתם מהרה מעל הארץ הטבה אשר יהוה נתן לכם׃ ");
INSERT INTO heb_vpl VALUES ("DT11_18","006_11_18","DEU","11","18","18","ושמתם את דברי אלה על לבבכם ועל נפשכם וקשרתם אתם לאות על ידכם והיו לטוטפת בין עיניכם׃ ");
INSERT INTO heb_vpl VALUES ("DT11_19","006_11_19","DEU","11","19","19","ולמדתם אתם את בניכם לדבר בם בשבתך בביתך ובלכתך בדרך ובשכבך ובקומך׃ ");
INSERT INTO heb_vpl VALUES ("DT11_20","006_11_20","DEU","11","20","20","וכתבתם על מזוזות ביתך ובשעריך׃ ");
INSERT INTO heb_vpl VALUES ("DT11_21","006_11_21","DEU","11","21","21","למען ירבו ימיכם וימי בניכם על האדמה אשר נשבע יהוה לאבתיכם לתת להם כימי השמים על הארץ׃ ");
INSERT INTO heb_vpl VALUES ("DT11_22","006_11_22","DEU","11","22","22","כי אם שמר תשמרון את כל המצוה הזאת אשר אנכי מצוה אתכם לעשתה לאהבה את יהוה אלהיכם ללכת בכל דרכיו ולדבקה בו׃ ");
INSERT INTO heb_vpl VALUES ("DT11_23","006_11_23","DEU","11","23","23","והוריש יהוה את כל הגוים האלה מלפניכם וירשתם גוים גדלים ועצמים מכם׃ ");
INSERT INTO heb_vpl VALUES ("DT11_24","006_11_24","DEU","11","24","24","כל המקום אשר תדרך כף רגלכם בו לכם יהיה מן המדבר והלבנון מן הנהר נהר פרת ועד הים האחרון יהיה גבלכם׃ ");
INSERT INTO heb_vpl VALUES ("DT11_25","006_11_25","DEU","11","25","25","לא יתיצב איש בפניכם פחדכם ומוראכם יתן יהוה אלהיכם על פני כל הארץ אשר תדרכו בה כאשר דבר לכם׃ ");
INSERT INTO heb_vpl VALUES ("DT11_26","006_11_26","DEU","11","26","26","ראה אנכי נתן לפניכם היום ברכה וקללה׃ ");
INSERT INTO heb_vpl VALUES ("DT11_27","006_11_27","DEU","11","27","27","את הברכה אשר תשמעו אל מצות יהוה אלהיכם אשר אנכי מצוה אתכם היום׃ ");
INSERT INTO heb_vpl VALUES ("DT11_28","006_11_28","DEU","11","28","28","והקללה אם לא תשמעו אל מצות יהוה אלהיכם וסרתם מן הדרך אשר אנכי מצוה אתכם היום ללכת אחרי אלהים אחרים אשר לא ידעתם׃ ");
INSERT INTO heb_vpl VALUES ("DT11_29","006_11_29","DEU","11","29","29","והיה כי יביאך יהוה אלהיך אל הארץ אשר אתה בא שמה לרשתה ונתתה את הברכה על הר גרזים ואת הקללה על הר עיבל׃ ");
INSERT INTO heb_vpl VALUES ("DT11_30","006_11_30","DEU","11","30","30","הלא המה בעבר הירדן אחרי דרך מבוא השמש בארץ הכנעני הישב בערבה מול הגלגל אצל אלוני מרה׃ ");
INSERT INTO heb_vpl VALUES ("DT11_31","006_11_31","DEU","11","31","31","כי אתם עברים את הירדן לבא לרשת את הארץ אשר יהוה אלהיכם נתן לכם וירשתם אתה וישבתם בה׃ ");
INSERT INTO heb_vpl VALUES ("DT11_32","006_11_32","DEU","11","32","32","ושמרתם לעשות את כל החקים ואת המשפטים אשר אנכי נתן לפניכם היום׃ ");
INSERT INTO heb_vpl VALUES ("DT12_1","006_12_1","DEU","12","1","1","אלה החקים והמשפטים אשר תשמרון לעשות בארץ אשר נתן יהוה אלהי אבתיך לך לרשתה כל הימים אשר אתם חיים על האדמה׃ ");
INSERT INTO heb_vpl VALUES ("DT12_2","006_12_2","DEU","12","2","2","אבד תאבדון את כל המקמות אשר עבדו שם הגוים אשר אתם ירשים אתם את אלהיהם על ההרים הרמים ועל הגבעות ותחת כל עץ רענן׃ ");
INSERT INTO heb_vpl VALUES ("DT12_3","006_12_3","DEU","12","3","3","ונתצתם את מזבחתם ושברתם את מצבתם ואשריהם תשרפון באש ופסילי אלהיהם תגדעון ואבדתם את שמם מן המקום ההוא׃ ");
INSERT INTO heb_vpl VALUES ("DT12_4","006_12_4","DEU","12","4","4","לא תעשון כן ליהוה אלהיכם׃ ");
INSERT INTO heb_vpl VALUES ("DT12_5","006_12_5","DEU","12","5","5","כי אם אל המקום אשר יבחר יהוה אלהיכם מכל שבטיכם לשום את שמו שם לשכנו תדרשו ובאת שמה׃ ");
INSERT INTO heb_vpl VALUES ("DT12_6","006_12_6","DEU","12","6","6","והבאתם שמה עלתיכם וזבחיכם ואת מעשרתיכם ואת תרומת ידכם ונדריכם ונדבתיכם ובכרת בקרכם וצאנכם׃ ");
INSERT INTO heb_vpl VALUES ("DT12_7","006_12_7","DEU","12","7","7","ואכלתם שם לפני יהוה אלהיכם ושמחתם בכל משלח ידכם אתם ובתיכם אשר ברכך יהוה אלהיך׃ ");
INSERT INTO heb_vpl VALUES ("DT12_8","006_12_8","DEU","12","8","8","לא תעשון ככל אשר אנחנו עשים פה היום איש כל הישר בעיניו׃ ");
INSERT INTO heb_vpl VALUES ("DT12_9","006_12_9","DEU","12","9","9","כי לא באתם עד עתה אל המנוחה ואל הנחלה אשר יהוה אלהיך נתן לך׃ ");
INSERT INTO heb_vpl VALUES ("DT12_10","006_12_10","DEU","12","10","10","ועברתם את הירדן וישבתם בארץ אשר יהוה אלהיכם מנחיל אתכם והניח לכם מכל איביכם מסביב וישבתם בטח׃ ");
INSERT INTO heb_vpl VALUES ("DT12_11","006_12_11","DEU","12","11","11","והיה המקום אשר יבחר יהוה אלהיכם בו לשכן שמו שם שמה תביאו את כל אשר אנכי מצוה אתכם עולתיכם וזבחיכם מעשרתיכם ותרמת ידכם וכל מבחר נדריכם אשר תדרו ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("DT12_12","006_12_12","DEU","12","12","12","ושמחתם לפני יהוה אלהיכם אתם ובניכם ובנתיכם ועבדיכם ואמהתיכם והלוי אשר בשעריכם כי אין לו חלק ונחלה אתכם׃ ");
INSERT INTO heb_vpl VALUES ("DT12_13","006_12_13","DEU","12","13","13","השמר לך פן תעלה עלתיך בכל מקום אשר תראה׃ ");
INSERT INTO heb_vpl VALUES ("DT12_14","006_12_14","DEU","12","14","14","כי אם במקום אשר יבחר יהוה באחד שבטיך שם תעלה עלתיך ושם תעשה כל אשר אנכי מצוך׃ ");
INSERT INTO heb_vpl VALUES ("DT12_15","006_12_15","DEU","12","15","15","רק בכל אות נפשך תזבח ואכלת בשר כברכת יהוה אלהיך אשר נתן לך בכל שעריך הטמא והטהור יאכלנו כצבי וכאיל׃ ");
INSERT INTO heb_vpl VALUES ("DT12_16","006_12_16","DEU","12","16","16","רק הדם לא תאכלו על הארץ תשפכנו כמים׃ ");
INSERT INTO heb_vpl VALUES ("DT12_17","006_12_17","DEU","12","17","17","לא תוכל לאכל בשעריך מעשר דגנך ותירשך ויצהרך ובכרת בקרך וצאנך וכל נדריך אשר תדר ונדבתיך ותרומת ידך׃ ");
INSERT INTO heb_vpl VALUES ("DT12_18","006_12_18","DEU","12","18","18","כי אם לפני יהוה אלהיך תאכלנו במקום אשר יבחר יהוה אלהיך בו אתה ובנך ובתך ועבדך ואמתך והלוי אשר בשעריך ושמחת לפני יהוה אלהיך בכל משלח ידך׃ ");
INSERT INTO heb_vpl VALUES ("DT12_19","006_12_19","DEU","12","19","19","השמר לך פן תעזב את הלוי כל ימיך על אדמתך׃ ");
INSERT INTO heb_vpl VALUES ("DT12_20","006_12_20","DEU","12","20","20","כי ירחיב יהוה אלהיך את גבולך כאשר דבר לך ואמרת אכלה בשר כי תאוה נפשך לאכל בשר בכל אות נפשך תאכל בשר׃ ");
INSERT INTO heb_vpl VALUES ("DT12_21","006_12_21","DEU","12","21","21","כי ירחק ממך המקום אשר יבחר יהוה אלהיך לשום שמו שם וזבחת מבקרך ומצאנך אשר נתן יהוה לך כאשר צויתך ואכלת בשעריך בכל אות נפשך׃ ");
INSERT INTO heb_vpl VALUES ("DT12_22","006_12_22","DEU","12","22","22","אך כאשר יאכל את הצבי ואת האיל כן תאכלנו הטמא והטהור יחדו יאכלנו׃ ");
INSERT INTO heb_vpl VALUES ("DT12_23","006_12_23","DEU","12","23","23","רק חזק לבלתי אכל הדם כי הדם הוא הנפש ולא תאכל הנפש עם הבשר׃ ");
INSERT INTO heb_vpl VALUES ("DT12_24","006_12_24","DEU","12","24","24","לא תאכלנו על הארץ תשפכנו כמים׃ ");
INSERT INTO heb_vpl VALUES ("DT12_25","006_12_25","DEU","12","25","25","לא תאכלנו למען ייטב לך ולבניך אחריך כי תעשה הישר בעיני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("DT12_26","006_12_26","DEU","12","26","26","רק קדשיך אשר יהיו לך ונדריך תשא ובאת אל המקום אשר יבחר יהוה׃ ");
INSERT INTO heb_vpl VALUES ("DT12_27","006_12_27","DEU","12","27","27","ועשית עלתיך הבשר והדם על מזבח יהוה אלהיך ודם זבחיך ישפך על מזבח יהוה אלהיך והבשר תאכל׃ ");
INSERT INTO heb_vpl VALUES ("DT12_28","006_12_28","DEU","12","28","28","שמר ושמעת את כל הדברים האלה אשר אנכי מצוך למען ייטב לך ולבניך אחריך עד עולם כי תעשה הטוב והישר בעיני יהוה אלהיך׃ ");
INSERT INTO heb_vpl VALUES ("DT12_29","006_12_29","DEU","12","29","29","כי יכרית יהוה אלהיך את הגוים אשר אתה בא שמה לרשת אותם מפניך וירשת אתם וישבת בארצם׃ ");
INSERT INTO heb_vpl VALUES ("DT12_30","006_12_30","DEU","12","30","30","השמר לך פן תנקש אחריהם אחרי השמדם מפניך ופן תדרש לאלהיהם לאמר איכה יעבדו הגוים האלה את אלהיהם ואעשה כן גם אני׃ ");
INSERT INTO heb_vpl VALUES ("DT12_31","006_12_31","DEU","12","31","31","לא תעשה כן ליהוה אלהיך כי כל תועבת יהוה אשר שנא עשו לאלהיהם כי גם את בניהם ואת בנתיהם ישרפו באש לאלהיהם׃ ");
INSERT INTO heb_vpl VALUES ("DT12_32","006_12_32","DEU","12","32","32","את כל הדבר אשר אנכי מצוה אתכם אתו תשמרו לעשות לא תסף עליו ולא תגרע ממנו׃ ");
INSERT INTO heb_vpl VALUES ("DT13_1","006_13_1","DEU","13","1","1","כי יקום בקרבך נביא או חלם חלום ונתן אליך אות או מופת׃ ");
INSERT INTO heb_vpl VALUES ("DT13_2","006_13_2","DEU","13","2","2","ובא האות והמופת אשר דבר אליך לאמר נלכה אחרי אלהים אחרים אשר לא ידעתם ונעבדם׃ ");
INSERT INTO heb_vpl VALUES ("DT13_3","006_13_3","DEU","13","3","3","לא תשמע אל דברי הנביא ההוא או אל חולם החלום ההוא כי מנסה יהוה אלהיכם אתכם לדעת הישכם אהבים את יהוה אלהיכם בכל לבבכם ובכל נפשכם׃ ");
INSERT INTO heb_vpl VALUES ("DT13_4","006_13_4","DEU","13","4","4","אחרי יהוה אלהיכם תלכו ואתו תיראו ואת מצותיו תשמרו ובקלו תשמעו ואתו תעבדו ובו תדבקון׃ ");
INSERT INTO heb_vpl VALUES ("DT13_5","006_13_5","DEU","13","5","5","והנביא ההוא או חלם החלום ההוא יומת כי דבר סרה על יהוה אלהיכם המוציא אתכם מארץ מצרים והפדך מבית עבדים להדיחך מן הדרך אשר צוך יהוה אלהיך ללכת בה ובערת הרע מקרבך׃ ");
INSERT INTO heb_vpl VALUES ("DT13_6","006_13_6","DEU","13","6","6","כי יסיתך אחיך בן אמך או בנך או בתך או אשת חיקך או רעך אשר כנפשך בסתר לאמר נלכה ונעבדה אלהים אחרים אשר לא ידעת אתה ואבתיך׃ ");
INSERT INTO heb_vpl VALUES ("DT13_7","006_13_7","DEU","13","7","7","מאלהי העמים אשר סביבתיכם הקרבים אליך או הרחקים ממך מקצה הארץ ועד קצה הארץ׃ ");
INSERT INTO heb_vpl VALUES ("DT13_8","006_13_8","DEU","13","8","8","לא תאבה לו ולא תשמע אליו ולא תחוס עינך עליו ולא תחמל ולא תכסה עליו׃ ");
INSERT INTO heb_vpl VALUES ("DT13_9","006_13_9","DEU","13","9","9","כי הרג תהרגנו ידך תהיה בו בראשונה להמיתו ויד כל העם באחרנה׃ ");
INSERT INTO heb_vpl VALUES ("DT13_10","006_13_10","DEU","13","10","10","וסקלתו באבנים ומת כי בקש להדיחך מעל יהוה אלהיך המוציאך מארץ מצרים מבית עבדים׃ ");
INSERT INTO heb_vpl VALUES ("DT13_11","006_13_11","DEU","13","11","11","וכל ישראל ישמעו ויראון ולא יוספו לעשות כדבר הרע הזה בקרבך׃ ");
INSERT INTO heb_vpl VALUES ("DT13_12","006_13_12","DEU","13","12","12","כי תשמע באחת עריך אשר יהוה אלהיך נתן לך לשבת שם לאמר׃ ");
INSERT INTO heb_vpl VALUES ("DT13_13","006_13_13","DEU","13","13","13","יצאו אנשים בני בליעל מקרבך וידיחו את ישבי עירם לאמר נלכה ונעבדה אלהים אחרים אשר לא ידעתם׃ ");
INSERT INTO heb_vpl VALUES ("DT13_14","006_13_14","DEU","13","14","14","ודרשת וחקרת ושאלת היטב והנה אמת נכון הדבר נעשתה התועבה הזאת בקרבך׃ ");
INSERT INTO heb_vpl VALUES ("DT13_15","006_13_15","DEU","13","15","15","הכה תכה את ישבי העיר ההוא לפי חרב החרם אתה ואת כל אשר בה ואת בהמתה לפי חרב׃ ");
INSERT INTO heb_vpl VALUES ("DT13_16","006_13_16","DEU","13","16","16","ואת כל שללה תקבץ אל תוך רחבה ושרפת באש את העיר ואת כל שללה כליל ליהוה אלהיך והיתה תל עולם לא תבנה עוד׃ ");
INSERT INTO heb_vpl VALUES ("DT13_17","006_13_17","DEU","13","17","17","ולא ידבק בידך מאומה מן החרם למען ישוב יהוה מחרון אפו ונתן לך רחמים ורחמך והרבך כאשר נשבע לאבתיך׃ ");
INSERT INTO heb_vpl VALUES ("DT13_18","006_13_18","DEU","13","18","18","כי תשמע בקול יהוה אלהיך לשמר את כל מצותיו אשר אנכי מצוך היום לעשות הישר בעיני יהוה אלהיך׃ ");
INSERT INTO heb_vpl VALUES ("DT14_1","006_14_1","DEU","14","1","1","בנים אתם ליהוה אלהיכם לא תתגדדו ולא תשימו קרחה בין עיניכם למת׃ ");
INSERT INTO heb_vpl VALUES ("DT14_2","006_14_2","DEU","14","2","2","כי עם קדוש אתה ליהוה אלהיך ובך בחר יהוה להיות לו לעם סגלה מכל העמים אשר על פני האדמה׃ ");
INSERT INTO heb_vpl VALUES ("DT14_3","006_14_3","DEU","14","3","3","לא תאכל כל תועבה׃ ");
INSERT INTO heb_vpl VALUES ("DT14_4","006_14_4","DEU","14","4","4","זאת הבהמה אשר תאכלו שור שה כשבים ושה עזים׃ ");
INSERT INTO heb_vpl VALUES ("DT14_5","006_14_5","DEU","14","5","5","איל וצבי ויחמור ואקו ודישן ותאו וזמר׃ ");
INSERT INTO heb_vpl VALUES ("DT14_6","006_14_6","DEU","14","6","6","וכל בהמה מפרסת פרסה ושסעת שסע שתי פרסות מעלת גרה בבהמה אתה תאכלו׃ ");
INSERT INTO heb_vpl VALUES ("DT14_7","006_14_7","DEU","14","7","7","אך את זה לא תאכלו ממעלי הגרה וממפריסי הפרסה השסועה את הגמל ואת הארנבת ואת השפן כי מעלה גרה המה ופרסה לא הפריסו טמאים הם לכם׃ ");
INSERT INTO heb_vpl VALUES ("DT14_8","006_14_8","DEU","14","8","8","ואת החזיר כי מפריס פרסה הוא ולא גרה טמא הוא לכם מבשרם לא תאכלו ובנבלתם לא תגעו׃ ");
INSERT INTO heb_vpl VALUES ("DT14_9","006_14_9","DEU","14","9","9","את זה תאכלו מכל אשר במים כל אשר לו סנפיר וקשקשת תאכלו׃ ");
INSERT INTO heb_vpl VALUES ("DT14_10","006_14_10","DEU","14","10","10","וכל אשר אין לו סנפיר וקשקשת לא תאכלו טמא הוא לכם׃ ");
INSERT INTO heb_vpl VALUES ("DT14_11","006_14_11","DEU","14","11","11","כל צפור טהרה תאכלו׃ ");
INSERT INTO heb_vpl VALUES ("DT14_12","006_14_12","DEU","14","12","12","וזה אשר לא תאכלו מהם הנשר והפרס והעזניה׃ ");
INSERT INTO heb_vpl VALUES ("DT14_13","006_14_13","DEU","14","13","13","והראה ואת האיה והדיה למינה׃ ");
INSERT INTO heb_vpl VALUES ("DT14_14","006_14_14","DEU","14","14","14","ואת כל ערב למינו׃ ");
INSERT INTO heb_vpl VALUES ("DT14_15","006_14_15","DEU","14","15","15","ואת בת היענה ואת התחמס ואת השחף ואת הנץ למינהו׃ ");
INSERT INTO heb_vpl VALUES ("DT14_16","006_14_16","DEU","14","16","16","את הכוס ואת הינשוף והתנשמת׃ ");
INSERT INTO heb_vpl VALUES ("DT14_17","006_14_17","DEU","14","17","17","והקאת ואת הרחמה ואת השלך׃ ");
INSERT INTO heb_vpl VALUES ("DT14_18","006_14_18","DEU","14","18","18","והחסידה והאנפה למינה והדוכיפת והעטלף׃ ");
INSERT INTO heb_vpl VALUES ("DT14_19","006_14_19","DEU","14","19","19","וכל שרץ העוף טמא הוא לכם לא יאכלו׃ ");
INSERT INTO heb_vpl VALUES ("DT14_20","006_14_20","DEU","14","20","20","כל עוף טהור תאכלו׃ ");
INSERT INTO heb_vpl VALUES ("DT14_21","006_14_21","DEU","14","21","21","לא תאכלו כל נבלה לגר אשר בשעריך תתננה ואכלה או מכר לנכרי כי עם קדוש אתה ליהוה אלהיך לא תבשל גדי בחלב אמו׃ ");
INSERT INTO heb_vpl VALUES ("DT14_22","006_14_22","DEU","14","22","22","עשר תעשר את כל תבואת זרעך היצא השדה שנה שנה׃ ");
INSERT INTO heb_vpl VALUES ("DT14_23","006_14_23","DEU","14","23","23","ואכלת לפני יהוה אלהיך במקום אשר יבחר לשכן שמו שם מעשר דגנך תירשך ויצהרך ובכרת בקרך וצאנך למען תלמד ליראה את יהוה אלהיך כל הימים׃ ");
INSERT INTO heb_vpl VALUES ("DT14_24","006_14_24","DEU","14","24","24","וכי ירבה ממך הדרך כי לא תוכל שאתו כי ירחק ממך המקום אשר יבחר יהוה אלהיך לשום שמו שם כי יברכך יהוה אלהיך׃ ");
INSERT INTO heb_vpl VALUES ("DT14_25","006_14_25","DEU","14","25","25","ונתתה בכסף וצרת הכסף בידך והלכת אל המקום אשר יבחר יהוה אלהיך בו׃ ");
INSERT INTO heb_vpl VALUES ("DT14_26","006_14_26","DEU","14","26","26","ונתתה הכסף בכל אשר תאוה נפשך בבקר ובצאן וביין ובשכר ובכל אשר תשאלך נפשך ואכלת שם לפני יהוה אלהיך ושמחת אתה וביתך׃ ");
INSERT INTO heb_vpl VALUES ("DT14_27","006_14_27","DEU","14","27","27","והלוי אשר בשעריך לא תעזבנו כי אין לו חלק ונחלה עמך׃ ");
INSERT INTO heb_vpl VALUES ("DT14_28","006_14_28","DEU","14","28","28","מקצה שלש שנים תוציא את כל מעשר תבואתך בשנה ההוא והנחת בשעריך׃ ");
INSERT INTO heb_vpl VALUES ("DT14_29","006_14_29","DEU","14","29","29","ובא הלוי כי אין לו חלק ונחלה עמך והגר והיתום והאלמנה אשר בשעריך ואכלו ושבעו למען יברכך יהוה אלהיך בכל מעשה ידך אשר תעשה׃ ");
INSERT INTO heb_vpl VALUES ("DT15_1","006_15_1","DEU","15","1","1","מקץ שבע שנים תעשה שמטה׃ ");
INSERT INTO heb_vpl VALUES ("DT15_2","006_15_2","DEU","15","2","2","וזה דבר השמטה שמוט כל בעל משה ידו אשר ישה ברעהו לא יגש את רעהו ואת אחיו כי קרא שמטה ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("DT15_3","006_15_3","DEU","15","3","3","את הנכרי תגש ואשר יהיה לך את אחיך תשמט ידך׃ ");
INSERT INTO heb_vpl VALUES ("DT15_4","006_15_4","DEU","15","4","4","אפס כי לא יהיה בך אביון כי ברך יברכך יהוה בארץ אשר יהוה אלהיך נתן לך נחלה לרשתה׃ ");
INSERT INTO heb_vpl VALUES ("DT15_5","006_15_5","DEU","15","5","5","רק אם שמוע תשמע בקול יהוה אלהיך לשמר לעשות את כל המצוה הזאת אשר אנכי מצוך היום׃ ");
INSERT INTO heb_vpl VALUES ("DT15_6","006_15_6","DEU","15","6","6","כי יהוה אלהיך ברכך כאשר דבר לך והעבטת גוים רבים ואתה לא תעבט ומשלת בגוים רבים ובך לא ימשלו׃ ");
INSERT INTO heb_vpl VALUES ("DT15_7","006_15_7","DEU","15","7","7","כי יהיה בך אביון מאחד אחיך באחד שעריך בארצך אשר יהוה אלהיך נתן לך לא תאמץ את לבבך ולא תקפץ את ידך מאחיך האביון׃ ");
INSERT INTO heb_vpl VALUES ("DT15_8","006_15_8","DEU","15","8","8","כי פתח תפתח את ידך לו והעבט תעביטנו די מחסרו אשר יחסר לו׃ ");
INSERT INTO heb_vpl VALUES ("DT15_9","006_15_9","DEU","15","9","9","השמר לך פן יהיה דבר עם לבבך בליעל לאמר קרבה שנת השבע שנת השמטה ורעה עינך באחיך האביון ולא תתן לו וקרא עליך אל יהוה והיה בך חטא׃ ");
INSERT INTO heb_vpl VALUES ("DT15_10","006_15_10","DEU","15","10","10","נתון תתן לו ולא ירע לבבך בתתך לו כי בגלל הדבר הזה יברכך יהוה אלהיך בכל מעשך ובכל משלח ידך׃ ");
INSERT INTO heb_vpl VALUES ("DT15_11","006_15_11","DEU","15","11","11","כי לא יחדל אביון מקרב הארץ על כן אנכי מצוך לאמר פתח תפתח את ידך לאחיך לעניך ולאבינך בארצך׃ ");
INSERT INTO heb_vpl VALUES ("DT15_12","006_15_12","DEU","15","12","12","כי ימכר לך אחיך העברי או העבריה ועבדך שש שנים ובשנה השביעת תשלחנו חפשי מעמך׃ ");
INSERT INTO heb_vpl VALUES ("DT15_13","006_15_13","DEU","15","13","13","וכי תשלחנו חפשי מעמך לא תשלחנו ריקם׃ ");
INSERT INTO heb_vpl VALUES ("DT15_14","006_15_14","DEU","15","14","14","העניק תעניק לו מצאנך ומגרנך ומיקבך אשר ברכך יהוה אלהיך תתן לו׃ ");
INSERT INTO heb_vpl VALUES ("DT15_15","006_15_15","DEU","15","15","15","וזכרת כי עבד היית בארץ מצרים ויפדך יהוה אלהיך על כן אנכי מצוך את הדבר הזה היום׃ ");
INSERT INTO heb_vpl VALUES ("DT15_16","006_15_16","DEU","15","16","16","והיה כי יאמר אליך לא אצא מעמך כי אהבך ואת ביתך כי טוב לו עמך׃ ");
INSERT INTO heb_vpl VALUES ("DT15_17","006_15_17","DEU","15","17","17","ולקחת את המרצע ונתתה באזנו ובדלת והיה לך עבד עולם ואף לאמתך תעשה כן׃ ");
INSERT INTO heb_vpl VALUES ("DT15_18","006_15_18","DEU","15","18","18","לא יקשה בעינך בשלחך אתו חפשי מעמך כי משנה שכר שכיר עבדך שש שנים וברכך יהוה אלהיך בכל אשר תעשה׃ ");
INSERT INTO heb_vpl VALUES ("DT15_19","006_15_19","DEU","15","19","19","כל הבכור אשר יולד בבקרך ובצאנך הזכר תקדיש ליהוה אלהיך לא תעבד בבכר שורך ולא תגז בכור צאנך׃ ");
INSERT INTO heb_vpl VALUES ("DT15_20","006_15_20","DEU","15","20","20","לפני יהוה אלהיך תאכלנו שנה בשנה במקום אשר יבחר יהוה אתה וביתך׃ ");
INSERT INTO heb_vpl VALUES ("DT15_21","006_15_21","DEU","15","21","21","וכי יהיה בו מום פסח או עור כל מום רע לא תזבחנו ליהוה אלהיך׃ ");
INSERT INTO heb_vpl VALUES ("DT15_22","006_15_22","DEU","15","22","22","בשעריך תאכלנו הטמא והטהור יחדו כצבי וכאיל׃ ");
INSERT INTO heb_vpl VALUES ("DT15_23","006_15_23","DEU","15","23","23","רק את דמו לא תאכל על הארץ תשפכנו כמים׃ ");
INSERT INTO heb_vpl VALUES ("DT16_1","006_16_1","DEU","16","1","1","שמור את חדש האביב ועשית פסח ליהוה אלהיך כי בחדש האביב הוציאך יהוה אלהיך ממצרים לילה׃ ");
INSERT INTO heb_vpl VALUES ("DT16_2","006_16_2","DEU","16","2","2","וזבחת פסח ליהוה אלהיך צאן ובקר במקום אשר יבחר יהוה לשכן שמו שם׃ ");
INSERT INTO heb_vpl VALUES ("DT16_3","006_16_3","DEU","16","3","3","לא תאכל עליו חמץ שבעת ימים תאכל עליו מצות לחם עני כי בחפזון יצאת מארץ מצרים למען תזכר את יום צאתך מארץ מצרים כל ימי חייך׃ ");
INSERT INTO heb_vpl VALUES ("DT16_4","006_16_4","DEU","16","4","4","ולא יראה לך שאר בכל גבלך שבעת ימים ולא ילין מן הבשר אשר תזבח בערב ביום הראשון לבקר׃ ");
INSERT INTO heb_vpl VALUES ("DT16_5","006_16_5","DEU","16","5","5","לא תוכל לזבח את הפסח באחד שעריך אשר יהוה אלהיך נתן לך׃ ");
INSERT INTO heb_vpl VALUES ("DT16_6","006_16_6","DEU","16","6","6","כי אם אל המקום אשר יבחר יהוה אלהיך לשכן שמו שם תזבח את הפסח בערב כבוא השמש מועד צאתך ממצרים׃ ");
INSERT INTO heb_vpl VALUES ("DT16_7","006_16_7","DEU","16","7","7","ובשלת ואכלת במקום אשר יבחר יהוה אלהיך בו ופנית בבקר והלכת לאהליך׃ ");
INSERT INTO heb_vpl VALUES ("DT16_8","006_16_8","DEU","16","8","8","ששת ימים תאכל מצות וביום השביעי עצרת ליהוה אלהיך לא תעשה מלאכה׃ ");
INSERT INTO heb_vpl VALUES ("DT16_9","006_16_9","DEU","16","9","9","שבעה שבעת תספר לך מהחל חרמש בקמה תחל לספר שבעה שבעות׃ ");
INSERT INTO heb_vpl VALUES ("DT16_10","006_16_10","DEU","16","10","10","ועשית חג שבעות ליהוה אלהיך מסת נדבת ידך אשר תתן כאשר יברכך יהוה אלהיך׃ ");
INSERT INTO heb_vpl VALUES ("DT16_11","006_16_11","DEU","16","11","11","ושמחת לפני יהוה אלהיך אתה ובנך ובתך ועבדך ואמתך והלוי אשר בשעריך והגר והיתום והאלמנה אשר בקרבך במקום אשר יבחר יהוה אלהיך לשכן שמו שם׃ ");
INSERT INTO heb_vpl VALUES ("DT16_12","006_16_12","DEU","16","12","12","וזכרת כי עבד היית במצרים ושמרת ועשית את החקים האלה׃ ");
INSERT INTO heb_vpl VALUES ("DT16_13","006_16_13","DEU","16","13","13","חג הסכת תעשה לך שבעת ימים באספך מגרנך ומיקבך׃ ");
INSERT INTO heb_vpl VALUES ("DT16_14","006_16_14","DEU","16","14","14","ושמחת בחגך אתה ובנך ובתך ועבדך ואמתך והלוי והגר והיתום והאלמנה אשר בשעריך׃ ");
INSERT INTO heb_vpl VALUES ("DT16_15","006_16_15","DEU","16","15","15","שבעת ימים תחג ליהוה אלהיך במקום אשר יבחר יהוה כי יברכך יהוה אלהיך בכל תבואתך ובכל מעשה ידיך והיית אך שמח׃ ");
INSERT INTO heb_vpl VALUES ("DT16_16","006_16_16","DEU","16","16","16","שלוש פעמים בשנה יראה כל זכורך את פני יהוה אלהיך במקום אשר יבחר בחג המצות ובחג השבעות ובחג הסכות ולא יראה את פני יהוה ריקם׃ ");
INSERT INTO heb_vpl VALUES ("DT16_17","006_16_17","DEU","16","17","17","איש כמתנת ידו כברכת יהוה אלהיך אשר נתן לך׃ ");
INSERT INTO heb_vpl VALUES ("DT16_18","006_16_18","DEU","16","18","18","שפטים ושטרים תתן לך בכל שעריך אשר יהוה אלהיך נתן לך לשבטיך ושפטו את העם משפט צדק׃ ");
INSERT INTO heb_vpl VALUES ("DT16_19","006_16_19","DEU","16","19","19","לא תטה משפט לא תכיר פנים ולא תקח שחד כי השחד יעור עיני חכמים ויסלף דברי צדיקם׃ ");
INSERT INTO heb_vpl VALUES ("DT16_20","006_16_20","DEU","16","20","20","צדק צדק תרדף למען תחיה וירשת את הארץ אשר יהוה אלהיך נתן לך׃ ");
INSERT INTO heb_vpl VALUES ("DT16_21","006_16_21","DEU","16","21","21","לא תטע לך אשרה כל עץ אצל מזבח יהוה אלהיך אשר תעשה לך׃ ");
INSERT INTO heb_vpl VALUES ("DT16_22","006_16_22","DEU","16","22","22","ולא תקים לך מצבה אשר שנא יהוה אלהיך׃ ");
INSERT INTO heb_vpl VALUES ("DT17_1","006_17_1","DEU","17","1","1","לא תזבח ליהוה אלהיך שור ושה אשר יהיה בו מום כל דבר רע כי תועבת יהוה אלהיך הוא׃ ");
INSERT INTO heb_vpl VALUES ("DT17_2","006_17_2","DEU","17","2","2","כי ימצא בקרבך באחד שעריך אשר יהוה אלהיך נתן לך איש או אשה אשר יעשה את הרע בעיני יהוה אלהיך לעבר בריתו׃ ");
INSERT INTO heb_vpl VALUES ("DT17_3","006_17_3","DEU","17","3","3","וילך ויעבד אלהים אחרים וישתחו להם ולשמש או לירח או לכל צבא השמים אשר לא צויתי׃ ");
INSERT INTO heb_vpl VALUES ("DT17_4","006_17_4","DEU","17","4","4","והגד לך ושמעת ודרשת היטב והנה אמת נכון הדבר נעשתה התועבה הזאת בישראל׃ ");
INSERT INTO heb_vpl VALUES ("DT17_5","006_17_5","DEU","17","5","5","והוצאת את האיש ההוא או את האשה ההוא אשר עשו את הדבר הרע הזה אל שעריך את האיש או את האשה וסקלתם באבנים ומתו׃ ");
INSERT INTO heb_vpl VALUES ("DT17_6","006_17_6","DEU","17","6","6","על פי שנים עדים או שלשה עדים יומת המת לא יומת על פי עד אחד׃ ");
INSERT INTO heb_vpl VALUES ("DT17_7","006_17_7","DEU","17","7","7","יד העדים תהיה בו בראשנה להמיתו ויד כל העם באחרנה ובערת הרע מקרבך׃ ");
INSERT INTO heb_vpl VALUES ("DT17_8","006_17_8","DEU","17","8","8","כי יפלא ממך דבר למשפט בין דם לדם בין דין לדין ובין נגע לנגע דברי ריבת בשעריך וקמת ועלית אל המקום אשר יבחר יהוה אלהיך בו׃ ");
INSERT INTO heb_vpl VALUES ("DT17_9","006_17_9","DEU","17","9","9","ובאת אל הכהנים הלוים ואל השפט אשר יהיה בימים ההם ודרשת והגידו לך את דבר המשפט׃ ");
INSERT INTO heb_vpl VALUES ("DT17_10","006_17_10","DEU","17","10","10","ועשית על פי הדבר אשר יגידו לך מן המקום ההוא אשר יבחר יהוה ושמרת לעשות ככל אשר יורוך׃ ");
INSERT INTO heb_vpl VALUES ("DT17_11","006_17_11","DEU","17","11","11","על פי התורה אשר יורוך ועל המשפט אשר יאמרו לך תעשה לא תסור מן הדבר אשר יגידו לך ימין ושמאל׃ ");
INSERT INTO heb_vpl VALUES ("DT17_12","006_17_12","DEU","17","12","12","והאיש אשר יעשה בזדון לבלתי שמע אל הכהן העמד לשרת שם את יהוה אלהיך או אל השפט ומת האיש ההוא ובערת הרע מישראל׃ ");
INSERT INTO heb_vpl VALUES ("DT17_13","006_17_13","DEU","17","13","13","וכל העם ישמעו ויראו ולא יזידון עוד׃ ");
INSERT INTO heb_vpl VALUES ("DT17_14","006_17_14","DEU","17","14","14","כי תבא אל הארץ אשר יהוה אלהיך נתן לך וירשתה וישבתה בה ואמרת אשימה עלי מלך ככל הגוים אשר סביבתי׃ ");
INSERT INTO heb_vpl VALUES ("DT17_15","006_17_15","DEU","17","15","15","שום תשים עליך מלך אשר יבחר יהוה אלהיך בו מקרב אחיך תשים עליך מלך לא תוכל לתת עליך איש נכרי אשר לא אחיך הוא׃ ");
INSERT INTO heb_vpl VALUES ("DT17_16","006_17_16","DEU","17","16","16","רק לא ירבה לו סוסים ולא ישיב את העם מצרימה למען הרבות סוס ויהוה אמר לכם לא תספון לשוב בדרך הזה עוד׃ ");
INSERT INTO heb_vpl VALUES ("DT17_17","006_17_17","DEU","17","17","17","ולא ירבה לו נשים ולא יסור לבבו וכסף וזהב לא ירבה לו מאד׃ ");
INSERT INTO heb_vpl VALUES ("DT17_18","006_17_18","DEU","17","18","18","והיה כשבתו על כסא ממלכתו וכתב לו את משנה התורה הזאת על ספר מלפני הכהנים הלוים׃ ");
INSERT INTO heb_vpl VALUES ("DT17_19","006_17_19","DEU","17","19","19","והיתה עמו וקרא בו כל ימי חייו למען ילמד ליראה את יהוה אלהיו לשמר את כל דברי התורה הזאת ואת החקים האלה לעשתם׃ ");
INSERT INTO heb_vpl VALUES ("DT17_20","006_17_20","DEU","17","20","20","לבלתי רום לבבו מאחיו ולבלתי סור מן המצוה ימין ושמאול למען יאריך ימים על ממלכתו הוא ובניו בקרב ישראל׃ ");
INSERT INTO heb_vpl VALUES ("DT18_1","006_18_1","DEU","18","1","1","לא יהיה לכהנים הלוים כל שבט לוי חלק ונחלה עם ישראל אשי יהוה ונחלתו יאכלון׃ ");
INSERT INTO heb_vpl VALUES ("DT18_2","006_18_2","DEU","18","2","2","ונחלה לא יהיה לו בקרב אחיו יהוה הוא נחלתו כאשר דבר לו׃ ");
INSERT INTO heb_vpl VALUES ("DT18_3","006_18_3","DEU","18","3","3","וזה יהיה משפט הכהנים מאת העם מאת זבחי הזבח אם שור אם שה ונתן לכהן הזרע והלחיים והקבה׃ ");
INSERT INTO heb_vpl VALUES ("DT18_4","006_18_4","DEU","18","4","4","ראשית דגנך תירשך ויצהרך וראשית גז צאנך תתן לו׃ ");
INSERT INTO heb_vpl VALUES ("DT18_5","006_18_5","DEU","18","5","5","כי בו בחר יהוה אלהיך מכל שבטיך לעמד לשרת בשם יהוה הוא ובניו כל הימים׃ ");
INSERT INTO heb_vpl VALUES ("DT18_6","006_18_6","DEU","18","6","6","וכי יבא הלוי מאחד שעריך מכל ישראל אשר הוא גר שם ובא בכל אות נפשו אל המקום אשר יבחר יהוה׃ ");
INSERT INTO heb_vpl VALUES ("DT18_7","006_18_7","DEU","18","7","7","ושרת בשם יהוה אלהיו ככל אחיו הלוים העמדים שם לפני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("DT18_8","006_18_8","DEU","18","8","8","חלק כחלק יאכלו לבד ממכריו על האבות׃ ");
INSERT INTO heb_vpl VALUES ("DT18_9","006_18_9","DEU","18","9","9","כי אתה בא אל הארץ אשר יהוה אלהיך נתן לך לא תלמד לעשות כתועבת הגוים ההם׃ ");
INSERT INTO heb_vpl VALUES ("DT18_10","006_18_10","DEU","18","10","10","לא ימצא בך מעביר בנו ובתו באש קסם קסמים מעונן ומנחש ומכשף׃ ");
INSERT INTO heb_vpl VALUES ("DT18_11","006_18_11","DEU","18","11","11","וחבר חבר ושאל אוב וידעני ודרש אל המתים׃ ");
INSERT INTO heb_vpl VALUES ("DT18_12","006_18_12","DEU","18","12","12","כי תועבת יהוה כל עשה אלה ובגלל התועבת האלה יהוה אלהיך מוריש אותם מפניך׃ ");
INSERT INTO heb_vpl VALUES ("DT18_13","006_18_13","DEU","18","13","13","תמים תהיה עם יהוה אלהיך׃ ");
INSERT INTO heb_vpl VALUES ("DT18_14","006_18_14","DEU","18","14","14","כי הגוים האלה אשר אתה יורש אותם אל מעננים ואל קסמים ישמעו ואתה לא כן נתן לך יהוה אלהיך׃ ");
INSERT INTO heb_vpl VALUES ("DT18_15","006_18_15","DEU","18","15","15","נביא מקרבך מאחיך כמני יקים לך יהוה אלהיך אליו תשמעון׃ ");
INSERT INTO heb_vpl VALUES ("DT18_16","006_18_16","DEU","18","16","16","ככל אשר שאלת מעם יהוה אלהיך בחרב ביום הקהל לאמר לא אסף לשמע את קול יהוה אלהי ואת האש הגדלה הזאת לא אראה עוד ולא אמות׃ ");
INSERT INTO heb_vpl VALUES ("DT18_17","006_18_17","DEU","18","17","17","ויאמר יהוה אלי היטיבו אשר דברו׃ ");
INSERT INTO heb_vpl VALUES ("DT18_18","006_18_18","DEU","18","18","18","נביא אקים להם מקרב אחיהם כמוך ונתתי דברי בפיו ודבר אליהם את כל אשר אצונו׃ ");
INSERT INTO heb_vpl VALUES ("DT18_19","006_18_19","DEU","18","19","19","והיה האיש אשר לא ישמע אל דברי אשר ידבר בשמי אנכי אדרש מעמו׃ ");
INSERT INTO heb_vpl VALUES ("DT18_20","006_18_20","DEU","18","20","20","אך הנביא אשר יזיד לדבר דבר בשמי את אשר לא צויתיו לדבר ואשר ידבר בשם אלהים אחרים ומת הנביא ההוא׃ ");
INSERT INTO heb_vpl VALUES ("DT18_21","006_18_21","DEU","18","21","21","וכי תאמר בלבבך איכה נדע את הדבר אשר לא דברו יהוה׃ ");
INSERT INTO heb_vpl VALUES ("DT18_22","006_18_22","DEU","18","22","22","אשר ידבר הנביא בשם יהוה ולא יהיה הדבר ולא יבוא הוא הדבר אשר לא דברו יהוה בזדון דברו הנביא לא תגור ממנו׃ ");
INSERT INTO heb_vpl VALUES ("DT19_1","006_19_1","DEU","19","1","1","כי יכרית יהוה אלהיך את הגוים אשר יהוה אלהיך נתן לך את ארצם וירשתם וישבת בעריהם ובבתיהם׃ ");
INSERT INTO heb_vpl VALUES ("DT19_2","006_19_2","DEU","19","2","2","שלוש ערים תבדיל לך בתוך ארצך אשר יהוה אלהיך נתן לך לרשתה׃ ");
INSERT INTO heb_vpl VALUES ("DT19_3","006_19_3","DEU","19","3","3","תכין לך הדרך ושלשת את גבול ארצך אשר ינחילך יהוה אלהיך והיה לנוס שמה כל רצח׃ ");
INSERT INTO heb_vpl VALUES ("DT19_4","006_19_4","DEU","19","4","4","וזה דבר הרצח אשר ינוס שמה וחי אשר יכה את רעהו בבלי דעת והוא לא שנא לו מתמל שלשם׃ ");
INSERT INTO heb_vpl VALUES ("DT19_5","006_19_5","DEU","19","5","5","ואשר יבא את רעהו ביער לחטב עצים ונדחה ידו בגרזן לכרת העץ ונשל הברזל מן העץ ומצא את רעהו ומת הוא ינוס אל אחת הערים האלה וחי׃ ");
INSERT INTO heb_vpl VALUES ("DT19_6","006_19_6","DEU","19","6","6","פן ירדף גאל הדם אחרי הרצח כי יחם לבבו והשיגו כי ירבה הדרך והכהו נפש ולו אין משפט מות כי לא שנא הוא לו מתמול שלשום׃ ");
INSERT INTO heb_vpl VALUES ("DT19_7","006_19_7","DEU","19","7","7","על כן אנכי מצוך לאמר שלש ערים תבדיל לך׃ ");
INSERT INTO heb_vpl VALUES ("DT19_8","006_19_8","DEU","19","8","8","ואם ירחיב יהוה אלהיך את גבלך כאשר נשבע לאבתיך ונתן לך את כל הארץ אשר דבר לתת לאבתיך׃ ");
INSERT INTO heb_vpl VALUES ("DT19_9","006_19_9","DEU","19","9","9","כי תשמר את כל המצוה הזאת לעשתה אשר אנכי מצוך היום לאהבה את יהוה אלהיך וללכת בדרכיו כל הימים ויספת לך עוד שלש ערים על השלש האלה׃ ");
INSERT INTO heb_vpl VALUES ("DT19_10","006_19_10","DEU","19","10","10","ולא ישפך דם נקי בקרב ארצך אשר יהוה אלהיך נתן לך נחלה והיה עליך דמים׃ ");
INSERT INTO heb_vpl VALUES ("DT19_11","006_19_11","DEU","19","11","11","וכי יהיה איש שנא לרעהו וארב לו וקם עליו והכהו נפש ומת ונס אל אחת הערים האל׃ ");
INSERT INTO heb_vpl VALUES ("DT19_12","006_19_12","DEU","19","12","12","ושלחו זקני עירו ולקחו אתו משם ונתנו אתו ביד גאל הדם ומת׃ ");
INSERT INTO heb_vpl VALUES ("DT19_13","006_19_13","DEU","19","13","13","לא תחוס עינך עליו ובערת דם הנקי מישראל וטוב לך׃ ");
INSERT INTO heb_vpl VALUES ("DT19_14","006_19_14","DEU","19","14","14","לא תסיג גבול רעך אשר גבלו ראשנים בנחלתך אשר תנחל בארץ אשר יהוה אלהיך נתן לך לרשתה׃ ");
INSERT INTO heb_vpl VALUES ("DT19_15","006_19_15","DEU","19","15","15","לא יקום עד אחד באיש לכל עון ולכל חטאת בכל חטא אשר יחטא על פי שני עדים או על פי שלשה עדים יקום דבר׃ ");
INSERT INTO heb_vpl VALUES ("DT19_16","006_19_16","DEU","19","16","16","כי יקום עד חמס באיש לענות בו סרה׃ ");
INSERT INTO heb_vpl VALUES ("DT19_17","006_19_17","DEU","19","17","17","ועמדו שני האנשים אשר להם הריב לפני יהוה לפני הכהנים והשפטים אשר יהיו בימים ההם׃ ");
INSERT INTO heb_vpl VALUES ("DT19_18","006_19_18","DEU","19","18","18","ודרשו השפטים היטב והנה עד שקר העד שקר ענה באחיו׃ ");
INSERT INTO heb_vpl VALUES ("DT19_19","006_19_19","DEU","19","19","19","ועשיתם לו כאשר זמם לעשות לאחיו ובערת הרע מקרבך׃ ");
INSERT INTO heb_vpl VALUES ("DT19_20","006_19_20","DEU","19","20","20","והנשארים ישמעו ויראו ולא יספו לעשות עוד כדבר הרע הזה בקרבך׃ ");
INSERT INTO heb_vpl VALUES ("DT19_21","006_19_21","DEU","19","21","21","ולא תחוס עינך נפש בנפש עין בעין שן בשן יד ביד רגל ברגל׃ ");
INSERT INTO heb_vpl VALUES ("DT20_1","006_20_1","DEU","20","1","1","כי תצא למלחמה על איביך וראית סוס ורכב עם רב ממך לא תירא מהם כי יהוה אלהיך עמך המעלך מארץ מצרים׃ ");
INSERT INTO heb_vpl VALUES ("DT20_2","006_20_2","DEU","20","2","2","והיה כקרבכם אל המלחמה ונגש הכהן ודבר אל העם׃ ");
INSERT INTO heb_vpl VALUES ("DT20_3","006_20_3","DEU","20","3","3","ואמר אלהם שמע ישראל אתם קרבים היום למלחמה על איביכם אל ירך לבבכם אל תיראו ואל תחפזו ואל תערצו מפניהם׃ ");
INSERT INTO heb_vpl VALUES ("DT20_4","006_20_4","DEU","20","4","4","כי יהוה אלהיכם ההלך עמכם להלחם לכם עם איביכם להושיע אתכם׃ ");
INSERT INTO heb_vpl VALUES ("DT20_5","006_20_5","DEU","20","5","5","ודברו השטרים אל העם לאמר מי האיש אשר בנה בית חדש ולא חנכו ילך וישב לביתו פן ימות במלחמה ואיש אחר יחנכנו׃ ");
INSERT INTO heb_vpl VALUES ("DT20_6","006_20_6","DEU","20","6","6","ומי האיש אשר נטע כרם ולא חללו ילך וישב לביתו פן ימות במלחמה ואיש אחר יחללנו׃ ");
INSERT INTO heb_vpl VALUES ("DT20_7","006_20_7","DEU","20","7","7","ומי האיש אשר ארש אשה ולא לקחה ילך וישב לביתו פן ימות במלחמה ואיש אחר יקחנה׃ ");
INSERT INTO heb_vpl VALUES ("DT20_8","006_20_8","DEU","20","8","8","ויספו השטרים לדבר אל העם ואמרו מי האיש הירא ורך הלבב ילך וישב לביתו ולא ימס את לבב אחיו כלבבו׃ ");
INSERT INTO heb_vpl VALUES ("DT20_9","006_20_9","DEU","20","9","9","והיה ככלת השטרים לדבר אל העם ופקדו שרי צבאות בראש העם׃ ");
INSERT INTO heb_vpl VALUES ("DT20_10","006_20_10","DEU","20","10","10","כי תקרב אל עיר להלחם עליה וקראת אליה לשלום׃ ");
INSERT INTO heb_vpl VALUES ("DT20_11","006_20_11","DEU","20","11","11","והיה אם שלום תענך ופתחה לך והיה כל העם הנמצא בה יהיו לך למס ועבדוך׃ ");
INSERT INTO heb_vpl VALUES ("DT20_12","006_20_12","DEU","20","12","12","ואם לא תשלים עמך ועשתה עמך מלחמה וצרת עליה׃ ");
INSERT INTO heb_vpl VALUES ("DT20_13","006_20_13","DEU","20","13","13","ונתנה יהוה אלהיך בידך והכית את כל זכורה לפי חרב׃ ");
INSERT INTO heb_vpl VALUES ("DT20_14","006_20_14","DEU","20","14","14","רק הנשים והטף והבהמה וכל אשר יהיה בעיר כל שללה תבז לך ואכלת את שלל איביך אשר נתן יהוה אלהיך לך׃ ");
INSERT INTO heb_vpl VALUES ("DT20_15","006_20_15","DEU","20","15","15","כן תעשה לכל הערים הרחקת ממך מאד אשר לא מערי הגוים האלה הנה׃ ");
INSERT INTO heb_vpl VALUES ("DT20_16","006_20_16","DEU","20","16","16","רק מערי העמים האלה אשר יהוה אלהיך נתן לך נחלה לא תחיה כל נשמה׃ ");
INSERT INTO heb_vpl VALUES ("DT20_17","006_20_17","DEU","20","17","17","כי החרם תחרימם החתי והאמרי הכנעני והפרזי החוי והיבוסי כאשר צוך יהוה אלהיך׃ ");
INSERT INTO heb_vpl VALUES ("DT20_18","006_20_18","DEU","20","18","18","למען אשר לא ילמדו אתכם לעשות ככל תועבתם אשר עשו לאלהיהם וחטאתם ליהוה אלהיכם׃ ");
INSERT INTO heb_vpl VALUES ("DT20_19","006_20_19","DEU","20","19","19","כי תצור אל עיר ימים רבים להלחם עליה לתפשה לא תשחית את עצה לנדח עליו גרזן כי ממנו תאכל ואתו לא תכרת כי האדם עץ השדה לבא מפניך במצור׃ ");
INSERT INTO heb_vpl VALUES ("DT20_20","006_20_20","DEU","20","20","20","רק עץ אשר תדע כי לא עץ מאכל הוא אתו תשחית וכרת ובנית מצור על העיר אשר הוא עשה עמך מלחמה עד רדתה׃ ");
INSERT INTO heb_vpl VALUES ("DT21_1","006_21_1","DEU","21","1","1","כי ימצא חלל באדמה אשר יהוה אלהיך נתן לך לרשתה נפל בשדה לא נודע מי הכהו׃ ");
INSERT INTO heb_vpl VALUES ("DT21_2","006_21_2","DEU","21","2","2","ויצאו זקניך ושפטיך ומדדו אל הערים אשר סביבת החלל׃ ");
INSERT INTO heb_vpl VALUES ("DT21_3","006_21_3","DEU","21","3","3","והיה העיר הקרבה אל החלל ולקחו זקני העיר ההוא עגלת בקר אשר לא עבד בה אשר לא משכה בעל׃ ");
INSERT INTO heb_vpl VALUES ("DT21_4","006_21_4","DEU","21","4","4","והורדו זקני העיר ההוא את העגלה אל נחל איתן אשר לא יעבד בו ולא יזרע וערפו שם את העגלה בנחל׃ ");
INSERT INTO heb_vpl VALUES ("DT21_5","006_21_5","DEU","21","5","5","ונגשו הכהנים בני לוי כי בם בחר יהוה אלהיך לשרתו ולברך בשם יהוה ועל פיהם יהיה כל ריב וכל נגע׃ ");
INSERT INTO heb_vpl VALUES ("DT21_6","006_21_6","DEU","21","6","6","וכל זקני העיר ההוא הקרבים אל החלל ירחצו את ידיהם על העגלה הערופה בנחל׃ ");
INSERT INTO heb_vpl VALUES ("DT21_7","006_21_7","DEU","21","7","7","וענו ואמרו ידינו לא שפכה את הדם הזה ועינינו לא ראו׃ ");
INSERT INTO heb_vpl VALUES ("DT21_8","006_21_8","DEU","21","8","8","כפר לעמך ישראל אשר פדית יהוה ואל תתן דם נקי בקרב עמך ישראל ונכפר להם הדם׃ ");
INSERT INTO heb_vpl VALUES ("DT21_9","006_21_9","DEU","21","9","9","ואתה תבער הדם הנקי מקרבך כי תעשה הישר בעיני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("DT21_10","006_21_10","DEU","21","10","10","כי תצא למלחמה על איביך ונתנו יהוה אלהיך בידך ושבית שביו׃ ");
INSERT INTO heb_vpl VALUES ("DT21_11","006_21_11","DEU","21","11","11","וראית בשביה אשת יפת תאר וחשקת בה ולקחת לך לאשה׃ ");
INSERT INTO heb_vpl VALUES ("DT21_12","006_21_12","DEU","21","12","12","והבאתה אל תוך ביתך וגלחה את ראשה ועשתה את צפרניה׃ ");
INSERT INTO heb_vpl VALUES ("DT21_13","006_21_13","DEU","21","13","13","והסירה את שמלת שביה מעליה וישבה בביתך ובכתה את אביה ואת אמה ירח ימים ואחר כן תבוא אליה ובעלתה והיתה לך לאשה׃ ");
INSERT INTO heb_vpl VALUES ("DT21_14","006_21_14","DEU","21","14","14","והיה אם לא חפצת בה ושלחתה לנפשה ומכר לא תמכרנה בכסף לא תתעמר בה תחת אשר עניתה׃ ");
INSERT INTO heb_vpl VALUES ("DT21_15","006_21_15","DEU","21","15","15","כי תהיין לאיש שתי נשים האחת אהובה והאחת שנואה וילדו לו בנים האהובה והשנואה והיה הבן הבכור לשניאה׃ ");
INSERT INTO heb_vpl VALUES ("DT21_16","006_21_16","DEU","21","16","16","והיה ביום הנחילו את בניו את אשר יהיה לו לא יוכל לבכר את בן האהובה על פני בן השנואה הבכר׃ ");
INSERT INTO heb_vpl VALUES ("DT21_17","006_21_17","DEU","21","17","17","כי את הבכר בן השנואה יכיר לתת לו פי שנים בכל אשר ימצא לו כי הוא ראשית אנו לו משפט הבכרה׃ ");
INSERT INTO heb_vpl VALUES ("DT21_18","006_21_18","DEU","21","18","18","כי יהיה לאיש בן סורר ומורה איננו שמע בקול אביו ובקול אמו ויסרו אתו ולא ישמע אליהם׃ ");
INSERT INTO heb_vpl VALUES ("DT21_19","006_21_19","DEU","21","19","19","ותפשו בו אביו ואמו והוציאו אתו אל זקני עירו ואל שער מקמו׃ ");
INSERT INTO heb_vpl VALUES ("DT21_20","006_21_20","DEU","21","20","20","ואמרו אל זקני עירו בננו זה סורר ומרה איננו שמע בקלנו זולל וסבא׃ ");
INSERT INTO heb_vpl VALUES ("DT21_21","006_21_21","DEU","21","21","21","ורגמהו כל אנשי עירו באבנים ומת ובערת הרע מקרבך וכל ישראל ישמעו ויראו׃ ");
INSERT INTO heb_vpl VALUES ("DT21_22","006_21_22","DEU","21","22","22","וכי יהיה באיש חטא משפט מות והומת ותלית אתו על עץ׃ ");
INSERT INTO heb_vpl VALUES ("DT21_23","006_21_23","DEU","21","23","23","לא תלין נבלתו על העץ כי קבור תקברנו ביום ההוא כי קללת אלהים תלוי ולא תטמא את אדמתך אשר יהוה אלהיך נתן לך נחלה׃ ");
INSERT INTO heb_vpl VALUES ("DT22_1","006_22_1","DEU","22","1","1","לא תראה את שור אחיך או את שיו נדחים והתעלמת מהם השב תשיבם לאחיך׃ ");
INSERT INTO heb_vpl VALUES ("DT22_2","006_22_2","DEU","22","2","2","ואם לא קרוב אחיך אליך ולא ידעתו ואספתו אל תוך ביתך והיה עמך עד דרש אחיך אתו והשבתו לו׃ ");
INSERT INTO heb_vpl VALUES ("DT22_3","006_22_3","DEU","22","3","3","וכן תעשה לחמרו וכן תעשה לשמלתו וכן תעשה לכל אבדת אחיך אשר תאבד ממנו ומצאתה לא תוכל להתעלם׃ ");
INSERT INTO heb_vpl VALUES ("DT22_4","006_22_4","DEU","22","4","4","לא תראה את חמור אחיך או שורו נפלים בדרך והתעלמת מהם הקם תקים עמו׃ ");
INSERT INTO heb_vpl VALUES ("DT22_5","006_22_5","DEU","22","5","5","לא יהיה כלי גבר על אשה ולא ילבש גבר שמלת אשה כי תועבת יהוה אלהיך כל עשה אלה׃ ");
INSERT INTO heb_vpl VALUES ("DT22_6","006_22_6","DEU","22","6","6","כי יקרא קן צפור לפניך בדרך בכל עץ או על הארץ אפרחים או ביצים והאם רבצת על האפרחים או על הביצים לא תקח האם על הבנים׃ ");
INSERT INTO heb_vpl VALUES ("DT22_7","006_22_7","DEU","22","7","7","שלח תשלח את האם ואת הבנים תקח לך למען ייטב לך והארכת ימים׃ ");
INSERT INTO heb_vpl VALUES ("DT22_8","006_22_8","DEU","22","8","8","כי תבנה בית חדש ועשית מעקה לגגך ולא תשים דמים בביתך כי יפל הנפל ממנו׃ ");
INSERT INTO heb_vpl VALUES ("DT22_9","006_22_9","DEU","22","9","9","לא תזרע כרמך כלאים פן תקדש המלאה הזרע אשר תזרע ותבואת הכרם׃ ");
INSERT INTO heb_vpl VALUES ("DT22_10","006_22_10","DEU","22","10","10","לא תחרש בשור ובחמר יחדו׃ ");
INSERT INTO heb_vpl VALUES ("DT22_11","006_22_11","DEU","22","11","11","לא תלבש שעטנז צמר ופשתים יחדו׃ ");
INSERT INTO heb_vpl VALUES ("DT22_12","006_22_12","DEU","22","12","12","גדלים תעשה לך על ארבע כנפות כסותך אשר תכסה בה׃ ");
INSERT INTO heb_vpl VALUES ("DT22_13","006_22_13","DEU","22","13","13","כי יקח איש אשה ובא אליה ושנאה׃ ");
INSERT INTO heb_vpl VALUES ("DT22_14","006_22_14","DEU","22","14","14","ושם לה עלילת דברים והוציא עליה שם רע ואמר את האשה הזאת לקחתי ואקרב אליה ולא מצאתי לה בתולים׃ ");
INSERT INTO heb_vpl VALUES ("DT22_15","006_22_15","DEU","22","15","15","ולקח אבי הנער ואמה והוציאו את בתולי הנער אל זקני העיר השערה׃ ");
INSERT INTO heb_vpl VALUES ("DT22_16","006_22_16","DEU","22","16","16","ואמר אבי הנער אל הזקנים את בתי נתתי לאיש הזה לאשה וישנאה׃ ");
INSERT INTO heb_vpl VALUES ("DT22_17","006_22_17","DEU","22","17","17","והנה הוא שם עלילת דברים לאמר לא מצאתי לבתך בתולים ואלה בתולי בתי ופרשו השמלה לפני זקני העיר׃ ");
INSERT INTO heb_vpl VALUES ("DT22_18","006_22_18","DEU","22","18","18","ולקחו זקני העיר ההוא את האיש ויסרו אתו׃ ");
INSERT INTO heb_vpl VALUES ("DT22_19","006_22_19","DEU","22","19","19","וענשו אתו מאה כסף ונתנו לאבי הנערה כי הוציא שם רע על בתולת ישראל ולו תהיה לאשה לא יוכל לשלחה כל ימיו׃ ");
INSERT INTO heb_vpl VALUES ("DT22_20","006_22_20","DEU","22","20","20","ואם אמת היה הדבר הזה לא נמצאו בתולים לנער׃ ");
INSERT INTO heb_vpl VALUES ("DT22_21","006_22_21","DEU","22","21","21","והוציאו את הנער אל פתח בית אביה וסקלוה אנשי עירה באבנים ומתה כי עשתה נבלה בישראל לזנות בית אביה ובערת הרע מקרבך׃ ");
INSERT INTO heb_vpl VALUES ("DT22_22","006_22_22","DEU","22","22","22","כי ימצא איש שכב עם אשה בעלת בעל ומתו גם שניהם האיש השכב עם האשה והאשה ובערת הרע מישראל׃ ");
INSERT INTO heb_vpl VALUES ("DT22_23","006_22_23","DEU","22","23","23","כי יהיה נער בתולה מארשה לאיש ומצאה איש בעיר ושכב עמה׃ ");
INSERT INTO heb_vpl VALUES ("DT22_24","006_22_24","DEU","22","24","24","והוצאתם את שניהם אל שער העיר ההוא וסקלתם אתם באבנים ומתו את הנער על דבר אשר לא צעקה בעיר ואת האיש על דבר אשר ענה את אשת רעהו ובערת הרע מקרבך׃ ");
INSERT INTO heb_vpl VALUES ("DT22_25","006_22_25","DEU","22","25","25","ואם בשדה ימצא האיש את הנער המארשה והחזיק בה האיש ושכב עמה ומת האיש אשר שכב עמה לבדו׃ ");
INSERT INTO heb_vpl VALUES ("DT22_26","006_22_26","DEU","22","26","26","ולנער לא תעשה דבר אין לנער חטא מות כי כאשר יקום איש על רעהו ורצחו נפש כן הדבר הזה׃ ");
INSERT INTO heb_vpl VALUES ("DT22_27","006_22_27","DEU","22","27","27","כי בשדה מצאה צעקה הנער המארשה ואין מושיע לה׃ ");
INSERT INTO heb_vpl VALUES ("DT22_28","006_22_28","DEU","22","28","28","כי ימצא איש נער בתולה אשר לא ארשה ותפשה ושכב עמה ונמצאו׃ ");
INSERT INTO heb_vpl VALUES ("DT22_29","006_22_29","DEU","22","29","29","ונתן האיש השכב עמה לאבי הנער חמשים כסף ולו תהיה לאשה תחת אשר ענה לא יוכל שלחה כל ימיו׃ ");
INSERT INTO heb_vpl VALUES ("DT22_30","006_22_30","DEU","22","30","30","לא יקח איש את אשת אביו ולא יגלה כנף אביו׃ ");
INSERT INTO heb_vpl VALUES ("DT23_1","006_23_1","DEU","23","1","1","לא יבא פצוע דכא וכרות שפכה בקהל יהוה׃ ");
INSERT INTO heb_vpl VALUES ("DT23_2","006_23_2","DEU","23","2","2","לא יבא ממזר בקהל יהוה גם דור עשירי לא יבא לו בקהל יהוה׃ ");
INSERT INTO heb_vpl VALUES ("DT23_3","006_23_3","DEU","23","3","3","לא יבא עמוני ומואבי בקהל יהוה גם דור עשירי לא יבא להם בקהל יהוה עד עולם׃ ");
INSERT INTO heb_vpl VALUES ("DT23_4","006_23_4","DEU","23","4","4","על דבר אשר לא קדמו אתכם בלחם ובמים בדרך בצאתכם ממצרים ואשר שכר עליך את בלעם בן בעור מפתור ארם נהרים לקללך׃ ");
INSERT INTO heb_vpl VALUES ("DT23_5","006_23_5","DEU","23","5","5","ולא אבה יהוה אלהיך לשמע אל בלעם ויהפך יהוה אלהיך לך את הקללה לברכה כי אהבך יהוה אלהיך׃ ");
INSERT INTO heb_vpl VALUES ("DT23_6","006_23_6","DEU","23","6","6","לא תדרש שלמם וטבתם כל ימיך לעולם׃ ");
INSERT INTO heb_vpl VALUES ("DT23_7","006_23_7","DEU","23","7","7","לא תתעב אדמי כי אחיך הוא לא תתעב מצרי כי גר היית בארצו׃ ");
INSERT INTO heb_vpl VALUES ("DT23_8","006_23_8","DEU","23","8","8","בנים אשר יולדו להם דור שלישי יבא להם בקהל יהוה׃ ");
INSERT INTO heb_vpl VALUES ("DT23_9","006_23_9","DEU","23","9","9","כי תצא מחנה על איביך ונשמרת מכל דבר רע׃ ");
INSERT INTO heb_vpl VALUES ("DT23_10","006_23_10","DEU","23","10","10","כי יהיה בך איש אשר לא יהיה טהור מקרה לילה ויצא אל מחוץ למחנה לא יבא אל תוך המחנה׃ ");
INSERT INTO heb_vpl VALUES ("DT23_11","006_23_11","DEU","23","11","11","והיה לפנות ערב ירחץ במים וכבא השמש יבא אל תוך המחנה׃ ");
INSERT INTO heb_vpl VALUES ("DT23_12","006_23_12","DEU","23","12","12","ויד תהיה לך מחוץ למחנה ויצאת שמה חוץ׃ ");
INSERT INTO heb_vpl VALUES ("DT23_13","006_23_13","DEU","23","13","13","ויתד תהיה לך על אזנך והיה בשבתך חוץ וחפרתה בה ושבת וכסית את צאתך׃ ");
INSERT INTO heb_vpl VALUES ("DT23_14","006_23_14","DEU","23","14","14","כי יהוה אלהיך מתהלך בקרב מחנך להצילך ולתת איביך לפניך והיה מחניך קדוש ולא יראה בך ערות דבר ושב מאחריך׃ ");
INSERT INTO heb_vpl VALUES ("DT23_15","006_23_15","DEU","23","15","15","לא תסגיר עבד אל אדניו אשר ינצל אליך מעם אדניו׃ ");
INSERT INTO heb_vpl VALUES ("DT23_16","006_23_16","DEU","23","16","16","עמך ישב בקרבך במקום אשר יבחר באחד שעריך בטוב לו לא תוננו׃ ");
INSERT INTO heb_vpl VALUES ("DT23_17","006_23_17","DEU","23","17","17","לא תהיה קדשה מבנות ישראל ולא יהיה קדש מבני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("DT23_18","006_23_18","DEU","23","18","18","לא תביא אתנן זונה ומחיר כלב בית יהוה אלהיך לכל נדר כי תועבת יהוה אלהיך גם שניהם׃ ");
INSERT INTO heb_vpl VALUES ("DT23_19","006_23_19","DEU","23","19","19","לא תשיך לאחיך נשך כסף נשך אכל נשך כל דבר אשר ישך׃ ");
INSERT INTO heb_vpl VALUES ("DT23_20","006_23_20","DEU","23","20","20","לנכרי תשיך ולאחיך לא תשיך למען יברכך יהוה אלהיך בכל משלח ידך על הארץ אשר אתה בא שמה לרשתה׃ ");
INSERT INTO heb_vpl VALUES ("DT23_21","006_23_21","DEU","23","21","21","כי תדר נדר ליהוה אלהיך לא תאחר לשלמו כי דרש ידרשנו יהוה אלהיך מעמך והיה בך חטא׃ ");
INSERT INTO heb_vpl VALUES ("DT23_22","006_23_22","DEU","23","22","22","וכי תחדל לנדר לא יהיה בך חטא׃ ");
INSERT INTO heb_vpl VALUES ("DT23_23","006_23_23","DEU","23","23","23","מוצא שפתיך תשמר ועשית כאשר נדרת ליהוה אלהיך נדבה אשר דברת בפיך׃ ");
INSERT INTO heb_vpl VALUES ("DT23_24","006_23_24","DEU","23","24","24","כי תבא בכרם רעך ואכלת ענבים כנפשך שבעך ואל כליך לא תתן׃ ");
INSERT INTO heb_vpl VALUES ("DT23_25","006_23_25","DEU","23","25","25","כי תבא בקמת רעך וקטפת מלילת בידך וחרמש לא תניף על קמת רעך׃ ");
INSERT INTO heb_vpl VALUES ("DT24_1","006_24_1","DEU","24","1","1","כי יקח איש אשה ובעלה והיה אם לא תמצא חן בעיניו כי מצא בה ערות דבר וכתב לה ספר כריתת ונתן בידה ושלחה מביתו׃ ");
INSERT INTO heb_vpl VALUES ("DT24_2","006_24_2","DEU","24","2","2","ויצאה מביתו והלכה והיתה לאיש אחר׃ ");
INSERT INTO heb_vpl VALUES ("DT24_3","006_24_3","DEU","24","3","3","ושנאה האיש האחרון וכתב לה ספר כריתת ונתן בידה ושלחה מביתו או כי ימות האיש האחרון אשר לקחה לו לאשה׃ ");
INSERT INTO heb_vpl VALUES ("DT24_4","006_24_4","DEU","24","4","4","לא יוכל בעלה הראשון אשר שלחה לשוב לקחתה להיות לו לאשה אחרי אשר הטמאה כי תועבה הוא לפני יהוה ולא תחטיא את הארץ אשר יהוה אלהיך נתן לך נחלה׃ ");
INSERT INTO heb_vpl VALUES ("DT24_5","006_24_5","DEU","24","5","5","כי יקח איש אשה חדשה לא יצא בצבא ולא יעבר עליו לכל דבר נקי יהיה לביתו שנה אחת ושמח את אשתו אשר לקח׃ ");
INSERT INTO heb_vpl VALUES ("DT24_6","006_24_6","DEU","24","6","6","לא יחבל רחים ורכב כי נפש הוא חבל׃ ");
INSERT INTO heb_vpl VALUES ("DT24_7","006_24_7","DEU","24","7","7","כי ימצא איש גנב נפש מאחיו מבני ישראל והתעמר בו ומכרו ומת הגנב ההוא ובערת הרע מקרבך׃ ");
INSERT INTO heb_vpl VALUES ("DT24_8","006_24_8","DEU","24","8","8","השמר בנגע הצרעת לשמר מאד ולעשות ככל אשר יורו אתכם הכהנים הלוים כאשר צויתם תשמרו לעשות׃ ");
INSERT INTO heb_vpl VALUES ("DT24_9","006_24_9","DEU","24","9","9","זכור את אשר עשה יהוה אלהיך למרים בדרך בצאתכם ממצרים׃ ");
INSERT INTO heb_vpl VALUES ("DT24_10","006_24_10","DEU","24","10","10","כי תשה ברעך משאת מאומה לא תבא אל ביתו לעבט עבטו׃ ");
INSERT INTO heb_vpl VALUES ("DT24_11","006_24_11","DEU","24","11","11","בחוץ תעמד והאיש אשר אתה נשה בו יוציא אליך את העבוט החוצה׃ ");
INSERT INTO heb_vpl VALUES ("DT24_12","006_24_12","DEU","24","12","12","ואם איש עני הוא לא תשכב בעבטו׃ ");
INSERT INTO heb_vpl VALUES ("DT24_13","006_24_13","DEU","24","13","13","השב תשיב לו את העבוט כבא השמש ושכב בשלמתו וברכך ולך תהיה צדקה לפני יהוה אלהיך׃ ");
INSERT INTO heb_vpl VALUES ("DT24_14","006_24_14","DEU","24","14","14","לא תעשק שכיר עני ואביון מאחיך או מגרך אשר בארצך בשעריך׃ ");
INSERT INTO heb_vpl VALUES ("DT24_15","006_24_15","DEU","24","15","15","ביומו תתן שכרו ולא תבוא עליו השמש כי עני הוא ואליו הוא נשא את נפשו ולא יקרא עליך אל יהוה והיה בך חטא׃ ");
INSERT INTO heb_vpl VALUES ("DT24_16","006_24_16","DEU","24","16","16","לא יומתו אבות על בנים ובנים לא יומתו על אבות איש בחטאו יומתו׃ ");
INSERT INTO heb_vpl VALUES ("DT24_17","006_24_17","DEU","24","17","17","לא תטה משפט גר יתום ולא תחבל בגד אלמנה׃ ");
INSERT INTO heb_vpl VALUES ("DT24_18","006_24_18","DEU","24","18","18","וזכרת כי עבד היית במצרים ויפדך יהוה אלהיך משם על כן אנכי מצוך לעשות את הדבר הזה׃ ");
INSERT INTO heb_vpl VALUES ("DT24_19","006_24_19","DEU","24","19","19","כי תקצר קצירך בשדך ושכחת עמר בשדה לא תשוב לקחתו לגר ליתום ולאלמנה יהיה למען יברכך יהוה אלהיך בכל מעשה ידיך׃ ");
INSERT INTO heb_vpl VALUES ("DT24_20","006_24_20","DEU","24","20","20","כי תחבט זיתך לא תפאר אחריך לגר ליתום ולאלמנה יהיה׃ ");
INSERT INTO heb_vpl VALUES ("DT24_21","006_24_21","DEU","24","21","21","כי תבצר כרמך לא תעולל אחריך לגר ליתום ולאלמנה יהיה׃ ");
INSERT INTO heb_vpl VALUES ("DT24_22","006_24_22","DEU","24","22","22","וזכרת כי עבד היית בארץ מצרים על כן אנכי מצוך לעשות את הדבר הזה׃ ");
INSERT INTO heb_vpl VALUES ("DT25_1","006_25_1","DEU","25","1","1","כי יהיה ריב בין אנשים ונגשו אל המשפט ושפטום והצדיקו את הצדיק והרשיעו את הרשע׃ ");
INSERT INTO heb_vpl VALUES ("DT25_2","006_25_2","DEU","25","2","2","והיה אם בן הכות הרשע והפילו השפט והכהו לפניו כדי רשעתו במספר׃ ");
INSERT INTO heb_vpl VALUES ("DT25_3","006_25_3","DEU","25","3","3","ארבעים יכנו לא יסיף פן יסיף להכתו על אלה מכה רבה ונקלה אחיך לעיניך׃ ");
INSERT INTO heb_vpl VALUES ("DT25_4","006_25_4","DEU","25","4","4","לא תחסם שור בדישו׃ ");
INSERT INTO heb_vpl VALUES ("DT25_5","006_25_5","DEU","25","5","5","כי ישבו אחים יחדו ומת אחד מהם ובן אין לו לא תהיה אשת המת החוצה לאיש זר יבמה יבא עליה ולקחה לו לאשה ויבמה׃ ");
INSERT INTO heb_vpl VALUES ("DT25_6","006_25_6","DEU","25","6","6","והיה הבכור אשר תלד יקום על שם אחיו המת ולא ימחה שמו מישראל׃ ");
INSERT INTO heb_vpl VALUES ("DT25_7","006_25_7","DEU","25","7","7","ואם לא יחפץ האיש לקחת את יבמתו ועלתה יבמתו השערה אל הזקנים ואמרה מאן יבמי להקים לאחיו שם בישראל לא אבה יבמי׃ ");
INSERT INTO heb_vpl VALUES ("DT25_8","006_25_8","DEU","25","8","8","וקראו לו זקני עירו ודברו אליו ועמד ואמר לא חפצתי לקחתה׃ ");
INSERT INTO heb_vpl VALUES ("DT25_9","006_25_9","DEU","25","9","9","ונגשה יבמתו אליו לעיני הזקנים וחלצה נעלו מעל רגלו וירקה בפניו וענתה ואמרה ככה יעשה לאיש אשר לא יבנה את בית אחיו׃ ");
INSERT INTO heb_vpl VALUES ("DT25_10","006_25_10","DEU","25","10","10","ונקרא שמו בישראל בית חלוץ הנעל׃ ");
INSERT INTO heb_vpl VALUES ("DT25_11","006_25_11","DEU","25","11","11","כי ינצו אנשים יחדו איש ואחיו וקרבה אשת האחד להציל את אישה מיד מכהו ושלחה ידה והחזיקה במבשיו׃ ");
INSERT INTO heb_vpl VALUES ("DT25_12","006_25_12","DEU","25","12","12","וקצתה את כפה לא תחוס עינך׃ ");
INSERT INTO heb_vpl VALUES ("DT25_13","006_25_13","DEU","25","13","13","לא יהיה לך בכיסך אבן ואבן גדולה וקטנה׃ ");
INSERT INTO heb_vpl VALUES ("DT25_14","006_25_14","DEU","25","14","14","לא יהיה לך בביתך איפה ואיפה גדולה וקטנה׃ ");
INSERT INTO heb_vpl VALUES ("DT25_15","006_25_15","DEU","25","15","15","אבן שלמה וצדק יהיה לך איפה שלמה וצדק יהיה לך למען יאריכו ימיך על האדמה אשר יהוה אלהיך נתן לך׃ ");
INSERT INTO heb_vpl VALUES ("DT25_16","006_25_16","DEU","25","16","16","כי תועבת יהוה אלהיך כל עשה אלה כל עשה עול׃ ");
INSERT INTO heb_vpl VALUES ("DT25_17","006_25_17","DEU","25","17","17","זכור את אשר עשה לך עמלק בדרך בצאתכם ממצרים׃ ");
INSERT INTO heb_vpl VALUES ("DT25_18","006_25_18","DEU","25","18","18","אשר קרך בדרך ויזנב בך כל הנחשלים אחריך ואתה עיף ויגע ולא ירא אלהים׃ ");
INSERT INTO heb_vpl VALUES ("DT25_19","006_25_19","DEU","25","19","19","והיה בהניח יהוה אלהיך לך מכל איביך מסביב בארץ אשר יהוה אלהיך נתן לך נחלה לרשתה תמחה את זכר עמלק מתחת השמים לא תשכח׃ ");
INSERT INTO heb_vpl VALUES ("DT26_1","006_26_1","DEU","26","1","1","והיה כי תבוא אל הארץ אשר יהוה אלהיך נתן לך נחלה וירשתה וישבת בה׃ ");
INSERT INTO heb_vpl VALUES ("DT26_2","006_26_2","DEU","26","2","2","ולקחת מראשית כל פרי האדמה אשר תביא מארצך אשר יהוה אלהיך נתן לך ושמת בטנא והלכת אל המקום אשר יבחר יהוה אלהיך לשכן שמו שם׃ ");
INSERT INTO heb_vpl VALUES ("DT26_3","006_26_3","DEU","26","3","3","ובאת אל הכהן אשר יהיה בימים ההם ואמרת אליו הגדתי היום ליהוה אלהיך כי באתי אל הארץ אשר נשבע יהוה לאבתינו לתת לנו׃ ");
INSERT INTO heb_vpl VALUES ("DT26_4","006_26_4","DEU","26","4","4","ולקח הכהן הטנא מידך והניחו לפני מזבח יהוה אלהיך׃ ");
INSERT INTO heb_vpl VALUES ("DT26_5","006_26_5","DEU","26","5","5","וענית ואמרת לפני יהוה אלהיך ארמי אבד אבי וירד מצרימה ויגר שם במתי מעט ויהי שם לגוי גדול עצום ורב׃ ");
INSERT INTO heb_vpl VALUES ("DT26_6","006_26_6","DEU","26","6","6","וירעו אתנו המצרים ויענונו ויתנו עלינו עבדה קשה׃ ");
INSERT INTO heb_vpl VALUES ("DT26_7","006_26_7","DEU","26","7","7","ונצעק אל יהוה אלהי אבתינו וישמע יהוה את קלנו וירא את ענינו ואת עמלנו ואת לחצנו׃ ");
INSERT INTO heb_vpl VALUES ("DT26_8","006_26_8","DEU","26","8","8","ויוצאנו יהוה ממצרים ביד חזקה ובזרע נטויה ובמרא גדל ובאתות ובמפתים׃ ");
INSERT INTO heb_vpl VALUES ("DT26_9","006_26_9","DEU","26","9","9","ויבאנו אל המקום הזה ויתן לנו את הארץ הזאת ארץ זבת חלב ודבש׃ ");
INSERT INTO heb_vpl VALUES ("DT26_10","006_26_10","DEU","26","10","10","ועתה הנה הבאתי את ראשית פרי האדמה אשר נתתה לי יהוה והנחתו לפני יהוה אלהיך והשתחוית לפני יהוה אלהיך׃ ");
INSERT INTO heb_vpl VALUES ("DT26_11","006_26_11","DEU","26","11","11","ושמחת בכל הטוב אשר נתן לך יהוה אלהיך ולביתך אתה והלוי והגר אשר בקרבך׃ ");
INSERT INTO heb_vpl VALUES ("DT26_12","006_26_12","DEU","26","12","12","כי תכלה לעשר את כל מעשר תבואתך בשנה השלישת שנת המעשר ונתתה ללוי לגר ליתום ולאלמנה ואכלו בשעריך ושבעו׃ ");
INSERT INTO heb_vpl VALUES ("DT26_13","006_26_13","DEU","26","13","13","ואמרת לפני יהוה אלהיך בערתי הקדש מן הבית וגם נתתיו ללוי ולגר ליתום ולאלמנה ככל מצותך אשר צויתני לא עברתי ממצותיך ולא שכחתי׃ ");
INSERT INTO heb_vpl VALUES ("DT26_14","006_26_14","DEU","26","14","14","לא אכלתי באני ממנו ולא בערתי ממנו בטמא ולא נתתי ממנו למת שמעתי בקול יהוה אלהי עשיתי ככל אשר צויתני׃ ");
INSERT INTO heb_vpl VALUES ("DT26_15","006_26_15","DEU","26","15","15","השקיפה ממעון קדשך מן השמים וברך את עמך את ישראל ואת האדמה אשר נתתה לנו כאשר נשבעת לאבתינו ארץ זבת חלב ודבש׃ ");
INSERT INTO heb_vpl VALUES ("DT26_16","006_26_16","DEU","26","16","16","היום הזה יהוה אלהיך מצוך לעשות את החקים האלה ואת המשפטים ושמרת ועשית אותם בכל לבבך ובכל נפשך׃ ");
INSERT INTO heb_vpl VALUES ("DT26_17","006_26_17","DEU","26","17","17","את יהוה האמרת היום להיות לך לאלהים וללכת בדרכיו ולשמר חקיו ומצותיו ומשפטיו ולשמע בקלו׃ ");
INSERT INTO heb_vpl VALUES ("DT26_18","006_26_18","DEU","26","18","18","ויהוה האמירך היום להיות לו לעם סגלה כאשר דבר לך ולשמר כל מצותיו׃ ");
INSERT INTO heb_vpl VALUES ("DT26_19","006_26_19","DEU","26","19","19","ולתתך עליון על כל הגוים אשר עשה לתהלה ולשם ולתפארת ולהיתך עם קדש ליהוה אלהיך כאשר דבר׃ ");
INSERT INTO heb_vpl VALUES ("DT27_1","006_27_1","DEU","27","1","1","ויצו משה וזקני ישראל את העם לאמר שמר את כל המצוה אשר אנכי מצוה אתכם היום׃ ");
INSERT INTO heb_vpl VALUES ("DT27_2","006_27_2","DEU","27","2","2","והיה ביום אשר תעברו את הירדן אל הארץ אשר יהוה אלהיך נתן לך והקמת לך אבנים גדלות ושדת אתם בשיד׃ ");
INSERT INTO heb_vpl VALUES ("DT27_3","006_27_3","DEU","27","3","3","וכתבת עליהן את כל דברי התורה הזאת בעברך למען אשר תבא אל הארץ אשר יהוה אלהיך נתן לך ארץ זבת חלב ודבש כאשר דבר יהוה אלהי אבתיך לך׃ ");
INSERT INTO heb_vpl VALUES ("DT27_4","006_27_4","DEU","27","4","4","והיה בעברכם את הירדן תקימו את האבנים האלה אשר אנכי מצוה אתכם היום בהר עיבל ושדת אותם בשיד׃ ");
INSERT INTO heb_vpl VALUES ("DT27_5","006_27_5","DEU","27","5","5","ובנית שם מזבח ליהוה אלהיך מזבח אבנים לא תניף עליהם ברזל׃ ");
INSERT INTO heb_vpl VALUES ("DT27_6","006_27_6","DEU","27","6","6","אבנים שלמות תבנה את מזבח יהוה אלהיך והעלית עליו עולת ליהוה אלהיך׃ ");
INSERT INTO heb_vpl VALUES ("DT27_7","006_27_7","DEU","27","7","7","וזבחת שלמים ואכלת שם ושמחת לפני יהוה אלהיך׃ ");
INSERT INTO heb_vpl VALUES ("DT27_8","006_27_8","DEU","27","8","8","וכתבת על האבנים את כל דברי התורה הזאת באר היטב׃ ");
INSERT INTO heb_vpl VALUES ("DT27_9","006_27_9","DEU","27","9","9","וידבר משה והכהנים הלוים אל כל ישראל לאמר הסכת ושמע ישראל היום הזה נהיית לעם ליהוה אלהיך׃ ");
INSERT INTO heb_vpl VALUES ("DT27_10","006_27_10","DEU","27","10","10","ושמעת בקול יהוה אלהיך ועשית את מצותו ואת חקיו אשר אנכי מצוך היום׃ ");
INSERT INTO heb_vpl VALUES ("DT27_11","006_27_11","DEU","27","11","11","ויצו משה את העם ביום ההוא לאמר׃ ");
INSERT INTO heb_vpl VALUES ("DT27_12","006_27_12","DEU","27","12","12","אלה יעמדו לברך את העם על הר גרזים בעברכם את הירדן שמעון ולוי ויהודה ויששכר ויוסף ובנימן׃ ");
INSERT INTO heb_vpl VALUES ("DT27_13","006_27_13","DEU","27","13","13","ואלה יעמדו על הקללה בהר עיבל ראובן גד ואשר וזבולן דן ונפתלי׃ ");
INSERT INTO heb_vpl VALUES ("DT27_14","006_27_14","DEU","27","14","14","וענו הלוים ואמרו אל כל איש ישראל קול רם׃ ");
INSERT INTO heb_vpl VALUES ("DT27_15","006_27_15","DEU","27","15","15","ארור האיש אשר יעשה פסל ומסכה תועבת יהוה מעשה ידי חרש ושם בסתר וענו כל העם ואמרו אמן׃ ");
INSERT INTO heb_vpl VALUES ("DT27_16","006_27_16","DEU","27","16","16","ארור מקלה אביו ואמו ואמר כל העם אמן׃ ");
INSERT INTO heb_vpl VALUES ("DT27_17","006_27_17","DEU","27","17","17","ארור מסיג גבול רעהו ואמר כל העם אמן׃ ");
INSERT INTO heb_vpl VALUES ("DT27_18","006_27_18","DEU","27","18","18","ארור משגה עור בדרך ואמר כל העם אמן׃ ");
INSERT INTO heb_vpl VALUES ("DT27_19","006_27_19","DEU","27","19","19","ארור מטה משפט גר יתום ואלמנה ואמר כל העם אמן׃ ");
INSERT INTO heb_vpl VALUES ("DT27_20","006_27_20","DEU","27","20","20","ארור שכב עם אשת אביו כי גלה כנף אביו ואמר כל העם אמן׃ ");
INSERT INTO heb_vpl VALUES ("DT27_21","006_27_21","DEU","27","21","21","ארור שכב עם כל בהמה ואמר כל העם אמן׃ ");
INSERT INTO heb_vpl VALUES ("DT27_22","006_27_22","DEU","27","22","22","ארור שכב עם אחתו בת אביו או בת אמו ואמר כל העם אמן׃ ");
INSERT INTO heb_vpl VALUES ("DT27_23","006_27_23","DEU","27","23","23","ארור שכב עם חתנתו ואמר כל העם אמן׃ ");
INSERT INTO heb_vpl VALUES ("DT27_24","006_27_24","DEU","27","24","24","ארור מכה רעהו בסתר ואמר כל העם אמן׃ ");
INSERT INTO heb_vpl VALUES ("DT27_25","006_27_25","DEU","27","25","25","ארור לקח שחד להכות נפש דם נקי ואמר כל העם אמן׃ ");
INSERT INTO heb_vpl VALUES ("DT27_26","006_27_26","DEU","27","26","26","ארור אשר לא יקים את דברי התורה הזאת לעשות אותם ואמר כל העם אמן׃ ");
INSERT INTO heb_vpl VALUES ("DT28_1","006_28_1","DEU","28","1","1","והיה אם שמוע תשמע בקול יהוה אלהיך לשמר לעשות את כל מצותיו אשר אנכי מצוך היום ונתנך יהוה אלהיך עליון על כל גויי הארץ׃ ");
INSERT INTO heb_vpl VALUES ("DT28_2","006_28_2","DEU","28","2","2","ובאו עליך כל הברכות האלה והשיגך כי תשמע בקול יהוה אלהיך׃ ");
INSERT INTO heb_vpl VALUES ("DT28_3","006_28_3","DEU","28","3","3","ברוך אתה בעיר וברוך אתה בשדה׃ ");
INSERT INTO heb_vpl VALUES ("DT28_4","006_28_4","DEU","28","4","4","ברוך פרי בטנך ופרי אדמתך ופרי בהמתך שגר אלפיך ועשתרות צאנך׃ ");
INSERT INTO heb_vpl VALUES ("DT28_5","006_28_5","DEU","28","5","5","ברוך טנאך ומשארתך׃ ");
INSERT INTO heb_vpl VALUES ("DT28_6","006_28_6","DEU","28","6","6","ברוך אתה בבאך וברוך אתה בצאתך׃ ");
INSERT INTO heb_vpl VALUES ("DT28_7","006_28_7","DEU","28","7","7","יתן יהוה את איביך הקמים עליך נגפים לפניך בדרך אחד יצאו אליך ובשבעה דרכים ינוסו לפניך׃ ");
INSERT INTO heb_vpl VALUES ("DT28_8","006_28_8","DEU","28","8","8","יצו יהוה אתך את הברכה באסמיך ובכל משלח ידך וברכך בארץ אשר יהוה אלהיך נתן לך׃ ");
INSERT INTO heb_vpl VALUES ("DT28_9","006_28_9","DEU","28","9","9","יקימך יהוה לו לעם קדוש כאשר נשבע לך כי תשמר את מצות יהוה אלהיך והלכת בדרכיו׃ ");
INSERT INTO heb_vpl VALUES ("DT28_10","006_28_10","DEU","28","10","10","וראו כל עמי הארץ כי שם יהוה נקרא עליך ויראו ממך׃ ");
INSERT INTO heb_vpl VALUES ("DT28_11","006_28_11","DEU","28","11","11","והותרך יהוה לטובה בפרי בטנך ובפרי בהמתך ובפרי אדמתך על האדמה אשר נשבע יהוה לאבתיך לתת לך׃ ");
INSERT INTO heb_vpl VALUES ("DT28_12","006_28_12","DEU","28","12","12","יפתח יהוה לך את אוצרו הטוב את השמים לתת מטר ארצך בעתו ולברך את כל מעשה ידך והלוית גוים רבים ואתה לא תלוה׃ ");
INSERT INTO heb_vpl VALUES ("DT28_13","006_28_13","DEU","28","13","13","ונתנך יהוה לראש ולא לזנב והיית רק למעלה ולא תהיה למטה כי תשמע אל מצות יהוה אלהיך אשר אנכי מצוך היום לשמר ולעשות׃ ");
INSERT INTO heb_vpl VALUES ("DT28_14","006_28_14","DEU","28","14","14","ולא תסור מכל הדברים אשר אנכי מצוה אתכם היום ימין ושמאול ללכת אחרי אלהים אחרים לעבדם׃ ");
INSERT INTO heb_vpl VALUES ("DT28_15","006_28_15","DEU","28","15","15","והיה אם לא תשמע בקול יהוה אלהיך לשמר לעשות את כל מצותיו וחקתיו אשר אנכי מצוך היום ובאו עליך כל הקללות האלה והשיגוך׃ ");
INSERT INTO heb_vpl VALUES ("DT28_16","006_28_16","DEU","28","16","16","ארור אתה בעיר וארור אתה בשדה׃ ");
INSERT INTO heb_vpl VALUES ("DT28_17","006_28_17","DEU","28","17","17","ארור טנאך ומשארתך׃ ");
INSERT INTO heb_vpl VALUES ("DT28_18","006_28_18","DEU","28","18","18","ארור פרי בטנך ופרי אדמתך שגר אלפיך ועשתרות צאנך׃ ");
INSERT INTO heb_vpl VALUES ("DT28_19","006_28_19","DEU","28","19","19","ארור אתה בבאך וארור אתה בצאתך׃ ");
INSERT INTO heb_vpl VALUES ("DT28_20","006_28_20","DEU","28","20","20","ישלח יהוה בך את המארה את המהומה ואת המגערת בכל משלח ידך אשר תעשה עד השמדך ועד אבדך מהר מפני רע מעלליך אשר עזבתני׃ ");
INSERT INTO heb_vpl VALUES ("DT28_21","006_28_21","DEU","28","21","21","ידבק יהוה בך את הדבר עד כלתו אתך מעל האדמה אשר אתה בא שמה לרשתה׃ ");
INSERT INTO heb_vpl VALUES ("DT28_22","006_28_22","DEU","28","22","22","יככה יהוה בשחפת ובקדחת ובדלקת ובחרחר ובחרב ובשדפון ובירקון ורדפוך עד אבדך׃ ");
INSERT INTO heb_vpl VALUES ("DT28_23","006_28_23","DEU","28","23","23","והיו שמיך אשר על ראשך נחשת והארץ אשר תחתיך ברזל׃ ");
INSERT INTO heb_vpl VALUES ("DT28_24","006_28_24","DEU","28","24","24","יתן יהוה את מטר ארצך אבק ועפר מן השמים ירד עליך עד השמדך׃ ");
INSERT INTO heb_vpl VALUES ("DT28_25","006_28_25","DEU","28","25","25","יתנך יהוה נגף לפני איביך בדרך אחד תצא אליו ובשבעה דרכים תנוס לפניו והיית לזעוה לכל ממלכות הארץ׃ ");
INSERT INTO heb_vpl VALUES ("DT28_26","006_28_26","DEU","28","26","26","והיתה נבלתך למאכל לכל עוף השמים ולבהמת הארץ ואין מחריד׃ ");
INSERT INTO heb_vpl VALUES ("DT28_27","006_28_27","DEU","28","27","27","יככה יהוה בשחין מצרים ובעפלים ובגרב ובחרס אשר לא תוכל להרפא׃ ");
INSERT INTO heb_vpl VALUES ("DT28_28","006_28_28","DEU","28","28","28","יככה יהוה בשגעון ובעורון ובתמהון לבב׃ ");
INSERT INTO heb_vpl VALUES ("DT28_29","006_28_29","DEU","28","29","29","והיית ממשש בצהרים כאשר ימשש העור באפלה ולא תצליח את דרכיך והיית אך עשוק וגזול כל הימים ואין מושיע׃ ");
INSERT INTO heb_vpl VALUES ("DT28_30","006_28_30","DEU","28","30","30","אשה תארש ואיש אחר ישגלנה בית תבנה ולא תשב בו כרם תטע ולא תחללנו׃ ");
INSERT INTO heb_vpl VALUES ("DT28_31","006_28_31","DEU","28","31","31","שורך טבוח לעיניך ולא תאכל ממנו חמרך גזול מלפניך ולא ישוב לך צאנך נתנות לאיביך ואין לך מושיע׃ ");
INSERT INTO heb_vpl VALUES ("DT28_32","006_28_32","DEU","28","32","32","בניך ובנתיך נתנים לעם אחר ועיניך ראות וכלות אליהם כל היום ואין לאל ידך׃ ");
INSERT INTO heb_vpl VALUES ("DT28_33","006_28_33","DEU","28","33","33","פרי אדמתך וכל יגיעך יאכל עם אשר לא ידעת והיית רק עשוק ורצוץ כל הימים׃ ");
INSERT INTO heb_vpl VALUES ("DT28_34","006_28_34","DEU","28","34","34","והיית משגע ממראה עיניך אשר תראה׃ ");
INSERT INTO heb_vpl VALUES ("DT28_35","006_28_35","DEU","28","35","35","יככה יהוה בשחין רע על הברכים ועל השקים אשר לא תוכל להרפא מכף רגלך ועד קדקדך׃ ");
INSERT INTO heb_vpl VALUES ("DT28_36","006_28_36","DEU","28","36","36","יולך יהוה אתך ואת מלכך אשר תקים עליך אל גוי אשר לא ידעת אתה ואבתיך ועבדת שם אלהים אחרים עץ ואבן׃ ");
INSERT INTO heb_vpl VALUES ("DT28_37","006_28_37","DEU","28","37","37","והיית לשמה למשל ולשנינה בכל העמים אשר ינהגך יהוה שמה׃ ");
INSERT INTO heb_vpl VALUES ("DT28_38","006_28_38","DEU","28","38","38","זרע רב תוציא השדה ומעט תאסף כי יחסלנו הארבה׃ ");
INSERT INTO heb_vpl VALUES ("DT28_39","006_28_39","DEU","28","39","39","כרמים תטע ועבדת ויין לא תשתה ולא תאגר כי תאכלנו התלעת׃ ");
INSERT INTO heb_vpl VALUES ("DT28_40","006_28_40","DEU","28","40","40","זיתים יהיו לך בכל גבולך ושמן לא תסוך כי ישל זיתך׃ ");
INSERT INTO heb_vpl VALUES ("DT28_41","006_28_41","DEU","28","41","41","בנים ובנות תוליד ולא יהיו לך כי ילכו בשבי׃ ");
INSERT INTO heb_vpl VALUES ("DT28_42","006_28_42","DEU","28","42","42","כל עצך ופרי אדמתך יירש הצלצל׃ ");
INSERT INTO heb_vpl VALUES ("DT28_43","006_28_43","DEU","28","43","43","הגר אשר בקרבך יעלה עליך מעלה מעלה ואתה תרד מטה מטה׃ ");
INSERT INTO heb_vpl VALUES ("DT28_44","006_28_44","DEU","28","44","44","הוא ילוך ואתה לא תלונו הוא יהיה לראש ואתה תהיה לזנב׃ ");
INSERT INTO heb_vpl VALUES ("DT28_45","006_28_45","DEU","28","45","45","ובאו עליך כל הקללות האלה ורדפוך והשיגוך עד השמדך כי לא שמעת בקול יהוה אלהיך לשמר מצותיו וחקתיו אשר צוך׃ ");
INSERT INTO heb_vpl VALUES ("DT28_46","006_28_46","DEU","28","46","46","והיו בך לאות ולמופת ובזרעך עד עולם׃ ");
INSERT INTO heb_vpl VALUES ("DT28_47","006_28_47","DEU","28","47","47","תחת אשר לא עבדת את יהוה אלהיך בשמחה ובטוב לבב מרב כל׃ ");
INSERT INTO heb_vpl VALUES ("DT28_48","006_28_48","DEU","28","48","48","ועבדת את איביך אשר ישלחנו יהוה בך ברעב ובצמא ובעירם ובחסר כל ונתן על ברזל על צוארך עד השמידו אתך׃ ");
INSERT INTO heb_vpl VALUES ("DT28_49","006_28_49","DEU","28","49","49","ישא יהוה עליך גוי מרחוק מקצה הארץ כאשר ידאה הנשר גוי אשר לא תשמע לשנו׃ ");
INSERT INTO heb_vpl VALUES ("DT28_50","006_28_50","DEU","28","50","50","גוי עז פנים אשר לא ישא פנים לזקן ונער לא יחן׃ ");
INSERT INTO heb_vpl VALUES ("DT28_51","006_28_51","DEU","28","51","51","ואכל פרי בהמתך ופרי אדמתך עד השמדך אשר לא ישאיר לך דגן תירוש ויצהר שגר אלפיך ועשתרת צאנך עד האבידו אתך׃ ");
INSERT INTO heb_vpl VALUES ("DT28_52","006_28_52","DEU","28","52","52","והצר לך בכל שעריך עד רדת חמתיך הגבהות והבצרות אשר אתה בטח בהן בכל ארצך והצר לך בכל שעריך בכל ארצך אשר נתן יהוה אלהיך לך׃ ");
INSERT INTO heb_vpl VALUES ("DT28_53","006_28_53","DEU","28","53","53","ואכלת פרי בטנך בשר בניך ובנתיך אשר נתן לך יהוה אלהיך במצור ובמצוק אשר יציק לך איבך׃ ");
INSERT INTO heb_vpl VALUES ("DT28_54","006_28_54","DEU","28","54","54","האיש הרך בך והענג מאד תרע עינו באחיו ובאשת חיקו וביתר בניו אשר יותיר׃ ");
INSERT INTO heb_vpl VALUES ("DT28_55","006_28_55","DEU","28","55","55","מתת לאחד מהם מבשר בניו אשר יאכל מבלי השאיר לו כל במצור ובמצוק אשר יציק לך איבך בכל שעריך׃ ");
INSERT INTO heb_vpl VALUES ("DT28_56","006_28_56","DEU","28","56","56","הרכה בך והענגה אשר לא נסתה כף רגלה הצג על הארץ מהתענג ומרך תרע עינה באיש חיקה ובבנה ובבתה׃ ");
INSERT INTO heb_vpl VALUES ("DT28_57","006_28_57","DEU","28","57","57","ובשליתה היוצת מבין רגליה ובבניה אשר תלד כי תאכלם בחסר כל בסתר במצור ובמצוק אשר יציק לך איבך בשעריך׃ ");
INSERT INTO heb_vpl VALUES ("DT28_58","006_28_58","DEU","28","58","58","אם לא תשמר לעשות את כל דברי התורה הזאת הכתובים בספר הזה ליראה את השם הנכבד והנורא הזה את יהוה אלהיך׃ ");
INSERT INTO heb_vpl VALUES ("DT28_59","006_28_59","DEU","28","59","59","והפלא יהוה את מכתך ואת מכות זרעך מכות גדלות ונאמנות וחלים רעים ונאמנים׃ ");
INSERT INTO heb_vpl VALUES ("DT28_60","006_28_60","DEU","28","60","60","והשיב בך את כל מדוה מצרים אשר יגרת מפניהם ודבקו בך׃ ");
INSERT INTO heb_vpl VALUES ("DT28_61","006_28_61","DEU","28","61","61","גם כל חלי וכל מכה אשר לא כתוב בספר התורה הזאת יעלם יהוה עליך עד השמדך׃ ");
INSERT INTO heb_vpl VALUES ("DT28_62","006_28_62","DEU","28","62","62","ונשארתם במתי מעט תחת אשר הייתם ככוכבי השמים לרב כי לא שמעת בקול יהוה אלהיך׃ ");
INSERT INTO heb_vpl VALUES ("DT28_63","006_28_63","DEU","28","63","63","והיה כאשר שש יהוה עליכם להיטיב אתכם ולהרבות אתכם כן ישיש יהוה עליכם להאביד אתכם ולהשמיד אתכם ונסחתם מעל האדמה אשר אתה בא שמה לרשתה׃ ");
INSERT INTO heb_vpl VALUES ("DT28_64","006_28_64","DEU","28","64","64","והפיצך יהוה בכל העמים מקצה הארץ ועד קצה הארץ ועבדת שם אלהים אחרים אשר לא ידעת אתה ואבתיך עץ ואבן׃ ");
INSERT INTO heb_vpl VALUES ("DT28_65","006_28_65","DEU","28","65","65","ובגוים ההם לא תרגיע ולא יהיה מנוח לכף רגלך ונתן יהוה לך שם לב רגז וכליון עינים ודאבון נפש׃ ");
INSERT INTO heb_vpl VALUES ("DT28_66","006_28_66","DEU","28","66","66","והיו חייך תלאים לך מנגד ופחדת לילה ויומם ולא תאמין בחייך׃ ");
INSERT INTO heb_vpl VALUES ("DT28_67","006_28_67","DEU","28","67","67","בבקר תאמר מי יתן ערב ובערב תאמר מי יתן בקר מפחד לבבך אשר תפחד וממראה עיניך אשר תראה׃ ");
INSERT INTO heb_vpl VALUES ("DT28_68","006_28_68","DEU","28","68","68","והשיבך יהוה מצרים באניות בדרך אשר אמרתי לך לא תסיף עוד לראתה והתמכרתם שם לאיביך לעבדים ולשפחות ואין קנה׃ ");
INSERT INTO heb_vpl VALUES ("DT29_1","006_29_1","DEU","29","1","1","אלה דברי הברית אשר צוה יהוה את משה לכרת את בני ישראל בארץ מואב מלבד הברית אשר כרת אתם בחרב׃ ");
INSERT INTO heb_vpl VALUES ("DT29_2","006_29_2","DEU","29","2","2","ויקרא משה אל כל ישראל ויאמר אלהם אתם ראיתם את כל אשר עשה יהוה לעיניכם בארץ מצרים לפרעה ולכל עבדיו ולכל ארצו׃ ");
INSERT INTO heb_vpl VALUES ("DT29_3","006_29_3","DEU","29","3","3","המסות הגדלת אשר ראו עיניך האתת והמפתים הגדלים ההם׃ ");
INSERT INTO heb_vpl VALUES ("DT29_4","006_29_4","DEU","29","4","4","ולא נתן יהוה לכם לב לדעת ועינים לראות ואזנים לשמע עד היום הזה׃ ");
INSERT INTO heb_vpl VALUES ("DT29_5","006_29_5","DEU","29","5","5","ואולך אתכם ארבעים שנה במדבר לא בלו שלמתיכם מעליכם ונעלך לא בלתה מעל רגלך׃ ");
INSERT INTO heb_vpl VALUES ("DT29_6","006_29_6","DEU","29","6","6","לחם לא אכלתם ויין ושכר לא שתיתם למען תדעו כי אני יהוה אלהיכם׃ ");
INSERT INTO heb_vpl VALUES ("DT29_7","006_29_7","DEU","29","7","7","ותבאו אל המקום הזה ויצא סיחן מלך חשבון ועוג מלך הבשן לקראתנו למלחמה ונכם׃ ");
INSERT INTO heb_vpl VALUES ("DT29_8","006_29_8","DEU","29","8","8","ונקח את ארצם ונתנה לנחלה לראובני ולגדי ולחצי שבט המנשי׃ ");
INSERT INTO heb_vpl VALUES ("DT29_9","006_29_9","DEU","29","9","9","ושמרתם את דברי הברית הזאת ועשיתם אתם למען תשכילו את כל אשר תעשון׃ ");
INSERT INTO heb_vpl VALUES ("DT29_10","006_29_10","DEU","29","10","10","אתם נצבים היום כלכם לפני יהוה אלהיכם ראשיכם שבטיכם זקניכם ושטריכם כל איש ישראל׃ ");
INSERT INTO heb_vpl VALUES ("DT29_11","006_29_11","DEU","29","11","11","טפכם נשיכם וגרך אשר בקרב מחניך מחטב עציך עד שאב מימיך׃ ");
INSERT INTO heb_vpl VALUES ("DT29_12","006_29_12","DEU","29","12","12","לעברך בברית יהוה אלהיך ובאלתו אשר יהוה אלהיך כרת עמך היום׃ ");
INSERT INTO heb_vpl VALUES ("DT29_13","006_29_13","DEU","29","13","13","למען הקים אתך היום לו לעם והוא יהיה לך לאלהים כאשר דבר לך וכאשר נשבע לאבתיך לאברהם ליצחק וליעקב׃ ");
INSERT INTO heb_vpl VALUES ("DT29_14","006_29_14","DEU","29","14","14","ולא אתכם לבדכם אנכי כרת את הברית הזאת ואת האלה הזאת׃ ");
INSERT INTO heb_vpl VALUES ("DT29_15","006_29_15","DEU","29","15","15","כי את אשר ישנו פה עמנו עמד היום לפני יהוה אלהינו ואת אשר איננו פה עמנו היום׃ ");
INSERT INTO heb_vpl VALUES ("DT29_16","006_29_16","DEU","29","16","16","כי אתם ידעתם את אשר ישבנו בארץ מצרים ואת אשר עברנו בקרב הגוים אשר עברתם׃ ");
INSERT INTO heb_vpl VALUES ("DT29_17","006_29_17","DEU","29","17","17","ותראו את שקוציהם ואת גלליהם עץ ואבן כסף וזהב אשר עמהם׃ ");
INSERT INTO heb_vpl VALUES ("DT29_18","006_29_18","DEU","29","18","18","פן יש בכם איש או אשה או משפחה או שבט אשר לבבו פנה היום מעם יהוה אלהינו ללכת לעבד את אלהי הגוים ההם פן יש בכם שרש פרה ראש ולענה׃ ");
INSERT INTO heb_vpl VALUES ("DT29_19","006_29_19","DEU","29","19","19","והיה בשמעו את דברי האלה הזאת והתברך בלבבו לאמר שלום יהיה לי כי בשררות לבי אלך למען ספות הרוה את הצמאה׃ ");
INSERT INTO heb_vpl VALUES ("DT29_20","006_29_20","DEU","29","20","20","לא יאבה יהוה סלח לו כי אז יעשן אף יהוה וקנאתו באיש ההוא ורבצה בו כל האלה הכתובה בספר הזה ומחה יהוה את שמו מתחת השמים׃ ");
INSERT INTO heb_vpl VALUES ("DT29_21","006_29_21","DEU","29","21","21","והבדילו יהוה לרעה מכל שבטי ישראל ככל אלות הברית הכתובה בספר התורה הזה׃ ");
INSERT INTO heb_vpl VALUES ("DT29_22","006_29_22","DEU","29","22","22","ואמר הדור האחרון בניכם אשר יקומו מאחריכם והנכרי אשר יבא מארץ רחוקה וראו את מכות הארץ ההוא ואת תחלאיה אשר חלה יהוה בה׃ ");
INSERT INTO heb_vpl VALUES ("DT29_23","006_29_23","DEU","29","23","23","גפרית ומלח שרפה כל ארצה לא תזרע ולא תצמח ולא יעלה בה כל עשב כמהפכת סדם ועמרה אדמה וצביים אשר הפך יהוה באפו ובחמתו׃ ");
INSERT INTO heb_vpl VALUES ("DT29_24","006_29_24","DEU","29","24","24","ואמרו כל הגוים על מה עשה יהוה ככה לארץ הזאת מה חרי האף הגדול הזה׃ ");
INSERT INTO heb_vpl VALUES ("DT29_25","006_29_25","DEU","29","25","25","ואמרו על אשר עזבו את ברית יהוה אלהי אבתם אשר כרת עמם בהוציאו אתם מארץ מצרים׃ ");
INSERT INTO heb_vpl VALUES ("DT29_26","006_29_26","DEU","29","26","26","וילכו ויעבדו אלהים אחרים וישתחוו להם אלהים אשר לא ידעום ולא חלק להם׃ ");
INSERT INTO heb_vpl VALUES ("DT29_27","006_29_27","DEU","29","27","27","ויחר אף יהוה בארץ ההוא להביא עליה את כל הקללה הכתובה בספר הזה׃ ");
INSERT INTO heb_vpl VALUES ("DT29_28","006_29_28","DEU","29","28","28","ויתשם יהוה מעל אדמתם באף ובחמה ובקצף גדול וישלכם אל ארץ אחרת כיום הזה׃ ");
INSERT INTO heb_vpl VALUES ("DT29_29","006_29_29","DEU","29","29","29","הנסתרת ליהוה אלהינו והנגלת לנו ולבנינו עד עולם לעשות את כל דברי התורה הזאת׃ ");
INSERT INTO heb_vpl VALUES ("DT30_1","006_30_1","DEU","30","1","1","והיה כי יבאו עליך כל הדברים האלה הברכה והקללה אשר נתתי לפניך והשבת אל לבבך בכל הגוים אשר הדיחך יהוה אלהיך שמה׃ ");
INSERT INTO heb_vpl VALUES ("DT30_2","006_30_2","DEU","30","2","2","ושבת עד יהוה אלהיך ושמעת בקלו ככל אשר אנכי מצוך היום אתה ובניך בכל לבבך ובכל נפשך׃ ");
INSERT INTO heb_vpl VALUES ("DT30_3","006_30_3","DEU","30","3","3","ושב יהוה אלהיך את שבותך ורחמך ושב וקבצך מכל העמים אשר הפיצך יהוה אלהיך שמה׃ ");
INSERT INTO heb_vpl VALUES ("DT30_4","006_30_4","DEU","30","4","4","אם יהיה נדחך בקצה השמים משם יקבצך יהוה אלהיך ומשם יקחך׃ ");
INSERT INTO heb_vpl VALUES ("DT30_5","006_30_5","DEU","30","5","5","והביאך יהוה אלהיך אל הארץ אשר ירשו אבתיך וירשתה והיטבך והרבך מאבתיך׃ ");
INSERT INTO heb_vpl VALUES ("DT30_6","006_30_6","DEU","30","6","6","ומל יהוה אלהיך את לבבך ואת לבב זרעך לאהבה את יהוה אלהיך בכל לבבך ובכל נפשך למען חייך׃ ");
INSERT INTO heb_vpl VALUES ("DT30_7","006_30_7","DEU","30","7","7","ונתן יהוה אלהיך את כל האלות האלה על איביך ועל שנאיך אשר רדפוך׃ ");
INSERT INTO heb_vpl VALUES ("DT30_8","006_30_8","DEU","30","8","8","ואתה תשוב ושמעת בקול יהוה ועשית את כל מצותיו אשר אנכי מצוך היום׃ ");
INSERT INTO heb_vpl VALUES ("DT30_9","006_30_9","DEU","30","9","9","והותירך יהוה אלהיך בכל מעשה ידך בפרי בטנך ובפרי בהמתך ובפרי אדמתך לטובה כי ישוב יהוה לשוש עליך לטוב כאשר שש על אבתיך׃ ");
INSERT INTO heb_vpl VALUES ("DT30_10","006_30_10","DEU","30","10","10","כי תשמע בקול יהוה אלהיך לשמר מצותיו וחקתיו הכתובה בספר התורה הזה כי תשוב אל יהוה אלהיך בכל לבבך ובכל נפשך׃ ");
INSERT INTO heb_vpl VALUES ("DT30_11","006_30_11","DEU","30","11","11","כי המצוה הזאת אשר אנכי מצוך היום לא נפלאת הוא ממך ולא רחקה הוא׃ ");
INSERT INTO heb_vpl VALUES ("DT30_12","006_30_12","DEU","30","12","12","לא בשמים הוא לאמר מי יעלה לנו השמימה ויקחה לנו וישמענו אתה ונעשנה׃ ");
INSERT INTO heb_vpl VALUES ("DT30_13","006_30_13","DEU","30","13","13","ולא מעבר לים הוא לאמר מי יעבר לנו אל עבר הים ויקחה לנו וישמענו אתה ונעשנה׃ ");
INSERT INTO heb_vpl VALUES ("DT30_14","006_30_14","DEU","30","14","14","כי קרוב אליך הדבר מאד בפיך ובלבבך לעשתו׃ ");
INSERT INTO heb_vpl VALUES ("DT30_15","006_30_15","DEU","30","15","15","ראה נתתי לפניך היום את החיים ואת הטוב ואת המות ואת הרע׃ ");
INSERT INTO heb_vpl VALUES ("DT30_16","006_30_16","DEU","30","16","16","אשר אנכי מצוך היום לאהבה את יהוה אלהיך ללכת בדרכיו ולשמר מצותיו וחקתיו ומשפטיו וחיית ורבית וברכך יהוה אלהיך בארץ אשר אתה בא שמה לרשתה׃ ");
INSERT INTO heb_vpl VALUES ("DT30_17","006_30_17","DEU","30","17","17","ואם יפנה לבבך ולא תשמע ונדחת והשתחוית לאלהים אחרים ועבדתם׃ ");
INSERT INTO heb_vpl VALUES ("DT30_18","006_30_18","DEU","30","18","18","הגדתי לכם היום כי אבד תאבדון לא תאריכן ימים על האדמה אשר אתה עבר את הירדן לבא שמה לרשתה׃ ");
INSERT INTO heb_vpl VALUES ("DT30_19","006_30_19","DEU","30","19","19","העידתי בכם היום את השמים ואת הארץ החיים והמות נתתי לפניך הברכה והקללה ובחרת בחיים למען תחיה אתה וזרעך׃ ");
INSERT INTO heb_vpl VALUES ("DT30_20","006_30_20","DEU","30","20","20","לאהבה את יהוה אלהיך לשמע בקלו ולדבקה בו כי הוא חייך וארך ימיך לשבת על האדמה אשר נשבע יהוה לאבתיך לאברהם ליצחק וליעקב לתת להם׃ ");
INSERT INTO heb_vpl VALUES ("DT31_1","006_31_1","DEU","31","1","1","וילך משה וידבר את הדברים האלה אל כל ישראל׃ ");
INSERT INTO heb_vpl VALUES ("DT31_2","006_31_2","DEU","31","2","2","ויאמר אלהם בן מאה ועשרים שנה אנכי היום לא אוכל עוד לצאת ולבוא ויהוה אמר אלי לא תעבר את הירדן הזה׃ ");
INSERT INTO heb_vpl VALUES ("DT31_3","006_31_3","DEU","31","3","3","יהוה אלהיך הוא עבר לפניך הוא ישמיד את הגוים האלה מלפניך וירשתם יהושע הוא עבר לפניך כאשר דבר יהוה׃ ");
INSERT INTO heb_vpl VALUES ("DT31_4","006_31_4","DEU","31","4","4","ועשה יהוה להם כאשר עשה לסיחון ולעוג מלכי האמרי ולארצם אשר השמיד אתם׃ ");
INSERT INTO heb_vpl VALUES ("DT31_5","006_31_5","DEU","31","5","5","ונתנם יהוה לפניכם ועשיתם להם ככל המצוה אשר צויתי אתכם׃ ");
INSERT INTO heb_vpl VALUES ("DT31_6","006_31_6","DEU","31","6","6","חזקו ואמצו אל תיראו ואל תערצו מפניהם כי יהוה אלהיך הוא ההלך עמך לא ירפך ולא יעזבך׃ ");
INSERT INTO heb_vpl VALUES ("DT31_7","006_31_7","DEU","31","7","7","ויקרא משה ליהושע ויאמר אליו לעיני כל ישראל חזק ואמץ כי אתה תבוא את העם הזה אל הארץ אשר נשבע יהוה לאבתם לתת להם ואתה תנחילנה אותם׃ ");
INSERT INTO heb_vpl VALUES ("DT31_8","006_31_8","DEU","31","8","8","ויהוה הוא ההלך לפניך הוא יהיה עמך לא ירפך ולא יעזבך לא תירא ולא תחת׃ ");
INSERT INTO heb_vpl VALUES ("DT31_9","006_31_9","DEU","31","9","9","ויכתב משה את התורה הזאת ויתנה אל הכהנים בני לוי הנשאים את ארון ברית יהוה ואל כל זקני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("DT31_10","006_31_10","DEU","31","10","10","ויצו משה אותם לאמר מקץ שבע שנים במעד שנת השמטה בחג הסכות׃ ");
INSERT INTO heb_vpl VALUES ("DT31_11","006_31_11","DEU","31","11","11","בבוא כל ישראל לראות את פני יהוה אלהיך במקום אשר יבחר תקרא את התורה הזאת נגד כל ישראל באזניהם׃ ");
INSERT INTO heb_vpl VALUES ("DT31_12","006_31_12","DEU","31","12","12","הקהל את העם האנשים והנשים והטף וגרך אשר בשעריך למען ישמעו ולמען ילמדו ויראו את יהוה אלהיכם ושמרו לעשות את כל דברי התורה הזאת׃ ");
INSERT INTO heb_vpl VALUES ("DT31_13","006_31_13","DEU","31","13","13","ובניהם אשר לא ידעו ישמעו ולמדו ליראה את יהוה אלהיכם כל הימים אשר אתם חיים על האדמה אשר אתם עברים את הירדן שמה לרשתה׃ ");
INSERT INTO heb_vpl VALUES ("DT31_14","006_31_14","DEU","31","14","14","ויאמר יהוה אל משה הן קרבו ימיך למות קרא את יהושע והתיצבו באהל מועד ואצונו וילך משה ויהושע ויתיצבו באהל מועד׃ ");
INSERT INTO heb_vpl VALUES ("DT31_15","006_31_15","DEU","31","15","15","וירא יהוה באהל בעמוד ענן ויעמד עמוד הענן על פתח האהל׃ ");
INSERT INTO heb_vpl VALUES ("DT31_16","006_31_16","DEU","31","16","16","ויאמר יהוה אל משה הנך שכב עם אבתיך וקם העם הזה וזנה אחרי אלהי נכר הארץ אשר הוא בא שמה בקרבו ועזבני והפר את בריתי אשר כרתי אתו׃ ");
INSERT INTO heb_vpl VALUES ("DT31_17","006_31_17","DEU","31","17","17","וחרה אפי בו ביום ההוא ועזבתים והסתרתי פני מהם והיה לאכל ומצאהו רעות רבות וצרות ואמר ביום ההוא הלא על כי אין אלהי בקרבי מצאוני הרעות האלה׃ ");
INSERT INTO heb_vpl VALUES ("DT31_18","006_31_18","DEU","31","18","18","ואנכי הסתר אסתיר פני ביום ההוא על כל הרעה אשר עשה כי פנה אל אלהים אחרים׃ ");
INSERT INTO heb_vpl VALUES ("DT31_19","006_31_19","DEU","31","19","19","ועתה כתבו לכם את השירה הזאת ולמדה את בני ישראל שימה בפיהם למען תהיה לי השירה הזאת לעד בבני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("DT31_20","006_31_20","DEU","31","20","20","כי אביאנו אל האדמה אשר נשבעתי לאבתיו זבת חלב ודבש ואכל ושבע ודשן ופנה אל אלהים אחרים ועבדום ונאצוני והפר את בריתי׃ ");
INSERT INTO heb_vpl VALUES ("DT31_21","006_31_21","DEU","31","21","21","והיה כי תמצאן אתו רעות רבות וצרות וענתה השירה הזאת לפניו לעד כי לא תשכח מפי זרעו כי ידעתי את יצרו אשר הוא עשה היום בטרם אביאנו אל הארץ אשר נשבעתי׃ ");
INSERT INTO heb_vpl VALUES ("DT31_22","006_31_22","DEU","31","22","22","ויכתב משה את השירה הזאת ביום ההוא וילמדה את בני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("DT31_23","006_31_23","DEU","31","23","23","ויצו את יהושע בן נון ויאמר חזק ואמץ כי אתה תביא את בני ישראל אל הארץ אשר נשבעתי להם ואנכי אהיה עמך׃ ");
INSERT INTO heb_vpl VALUES ("DT31_24","006_31_24","DEU","31","24","24","ויהי ככלות משה לכתב את דברי התורה הזאת על ספר עד תמם׃ ");
INSERT INTO heb_vpl VALUES ("DT31_25","006_31_25","DEU","31","25","25","ויצו משה את הלוים נשאי ארון ברית יהוה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("DT31_26","006_31_26","DEU","31","26","26","לקח את ספר התורה הזה ושמתם אתו מצד ארון ברית יהוה אלהיכם והיה שם בך לעד׃ ");
INSERT INTO heb_vpl VALUES ("DT31_27","006_31_27","DEU","31","27","27","כי אנכי ידעתי את מריך ואת ערפך הקשה הן בעודני חי עמכם היום ממרים היתם עם יהוה ואף כי אחרי מותי׃ ");
INSERT INTO heb_vpl VALUES ("DT31_28","006_31_28","DEU","31","28","28","הקהילו אלי את כל זקני שבטיכם ושטריכם ואדברה באזניהם את הדברים האלה ואעידה בם את השמים ואת הארץ׃ ");
INSERT INTO heb_vpl VALUES ("DT31_29","006_31_29","DEU","31","29","29","כי ידעתי אחרי מותי כי השחת תשחתון וסרתם מן הדרך אשר צויתי אתכם וקראת אתכם הרעה באחרית הימים כי תעשו את הרע בעיני יהוה להכעיסו במעשה ידיכם׃ ");
INSERT INTO heb_vpl VALUES ("DT31_30","006_31_30","DEU","31","30","30","וידבר משה באזני כל קהל ישראל את דברי השירה הזאת עד תמם׃ ");
INSERT INTO heb_vpl VALUES ("DT32_1","006_32_1","DEU","32","1","1","האזינו השמים ואדברה ותשמע הארץ אמרי פי׃ ");
INSERT INTO heb_vpl VALUES ("DT32_2","006_32_2","DEU","32","2","2","יערף כמטר לקחי תזל כטל אמרתי כשעירם עלי דשא וכרביבים עלי עשב׃ ");
INSERT INTO heb_vpl VALUES ("DT32_3","006_32_3","DEU","32","3","3","כי שם יהוה אקרא הבו גדל לאלהינו׃ ");
INSERT INTO heb_vpl VALUES ("DT32_4","006_32_4","DEU","32","4","4","הצור תמים פעלו כי כל דרכיו משפט אל אמונה ואין עול צדיק וישר הוא׃ ");
INSERT INTO heb_vpl VALUES ("DT32_5","006_32_5","DEU","32","5","5","שחת לו לא בניו מומם דור עקש ופתלתל׃ ");
INSERT INTO heb_vpl VALUES ("DT32_6","006_32_6","DEU","32","6","6","ה ליהוה תגמלו זאת עם נבל ולא חכם הלוא הוא אביך קנך הוא עשך ויכננך׃ ");
INSERT INTO heb_vpl VALUES ("DT32_7","006_32_7","DEU","32","7","7","זכר ימות עולם בינו שנות דור ודור שאל אביך ויגדך זקניך ויאמרו לך׃ ");
INSERT INTO heb_vpl VALUES ("DT32_8","006_32_8","DEU","32","8","8","בהנחל עליון גוים בהפרידו בני אדם יצב גבלת עמים למספר בני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("DT32_9","006_32_9","DEU","32","9","9","כי חלק יהוה עמו יעקב חבל נחלתו׃ ");
INSERT INTO heb_vpl VALUES ("DT32_10","006_32_10","DEU","32","10","10","ימצאהו בארץ מדבר ובתהו ילל ישמן יסבבנהו יבוננהו יצרנהו כאישון עינו׃ ");
INSERT INTO heb_vpl VALUES ("DT32_11","006_32_11","DEU","32","11","11","כנשר יעיר קנו על גוזליו ירחף יפרש כנפיו יקחהו ישאהו על אברתו׃ ");
INSERT INTO heb_vpl VALUES ("DT32_12","006_32_12","DEU","32","12","12","יהוה בדד ינחנו ואין עמו אל נכר׃ ");
INSERT INTO heb_vpl VALUES ("DT32_13","006_32_13","DEU","32","13","13","ירכבהו על במותי ארץ ויאכל תנובת שדי וינקהו דבש מסלע ושמן מחלמיש צור׃ ");
INSERT INTO heb_vpl VALUES ("DT32_14","006_32_14","DEU","32","14","14","חמאת בקר וחלב צאן עם חלב כרים ואילים בני בשן ועתודים עם חלב כליות חטה ודם ענב תשתה חמר׃ ");
INSERT INTO heb_vpl VALUES ("DT32_15","006_32_15","DEU","32","15","15","וישמן ישרון ויבעט שמנת עבית כשית ויטש אלוה עשהו וינבל צור ישעתו׃ ");
INSERT INTO heb_vpl VALUES ("DT32_16","006_32_16","DEU","32","16","16","יקנאהו בזרים בתועבת יכעיסהו׃ ");
INSERT INTO heb_vpl VALUES ("DT32_17","006_32_17","DEU","32","17","17","יזבחו לשדים לא אלה אלהים לא ידעום חדשים מקרב באו לא שערום אבתיכם׃ ");
INSERT INTO heb_vpl VALUES ("DT32_18","006_32_18","DEU","32","18","18","צור ילדך תשי ותשכח אל מחללך׃ ");
INSERT INTO heb_vpl VALUES ("DT32_19","006_32_19","DEU","32","19","19","וירא יהוה וינאץ מכעס בניו ובנתיו׃ ");
INSERT INTO heb_vpl VALUES ("DT32_20","006_32_20","DEU","32","20","20","ויאמר אסתירה פני מהם אראה מה אחריתם כי דור תהפכת המה בנים לא אמן בם׃ ");
INSERT INTO heb_vpl VALUES ("DT32_21","006_32_21","DEU","32","21","21","הם קנאוני בלא אל כעסוני בהבליהם ואני אקניאם בלא עם בגוי נבל אכעיסם׃ ");
INSERT INTO heb_vpl VALUES ("DT32_22","006_32_22","DEU","32","22","22","כי אש קדחה באפי ותיקד עד שאול תחתית ותאכל ארץ ויבלה ותלהט מוסדי הרים׃ ");
INSERT INTO heb_vpl VALUES ("DT32_23","006_32_23","DEU","32","23","23","אספה עלימו רעות חצי אכלה בם׃ ");
INSERT INTO heb_vpl VALUES ("DT32_24","006_32_24","DEU","32","24","24","מזי רעב ולחמי רשף וקטב מרירי ושן בהמות אשלח בם עם חמת זחלי עפר׃ ");
INSERT INTO heb_vpl VALUES ("DT32_25","006_32_25","DEU","32","25","25","מחוץ תשכל חרב ומחדרים אימה גם בחור גם בתולה יונק עם איש שיבה׃ ");
INSERT INTO heb_vpl VALUES ("DT32_26","006_32_26","DEU","32","26","26","אמרתי אפאיהם אשביתה מאנוש זכרם׃ ");
INSERT INTO heb_vpl VALUES ("DT32_27","006_32_27","DEU","32","27","27","לולי כעס אויב אגור פן ינכרו צרימו פן יאמרו ידינו רמה ולא יהוה פעל כל זאת׃ ");
INSERT INTO heb_vpl VALUES ("DT32_28","006_32_28","DEU","32","28","28","כי גוי אבד עצות המה ואין בהם תבונה׃ ");
INSERT INTO heb_vpl VALUES ("DT32_29","006_32_29","DEU","32","29","29","לו חכמו ישכילו זאת יבינו לאחריתם׃ ");
INSERT INTO heb_vpl VALUES ("DT32_30","006_32_30","DEU","32","30","30","איכה ירדף אחד אלף ושנים יניסו רבבה אם לא כי צורם מכרם ויהוה הסגירם׃ ");
INSERT INTO heb_vpl VALUES ("DT32_31","006_32_31","DEU","32","31","31","כי לא כצורנו צורם ואיבינו פלילים׃ ");
INSERT INTO heb_vpl VALUES ("DT32_32","006_32_32","DEU","32","32","32","כי מגפן סדם גפנם ומשדמת עמרה ענבמו ענבי רוש אשכלת מררת למו׃ ");
INSERT INTO heb_vpl VALUES ("DT32_33","006_32_33","DEU","32","33","33","חמת תנינם יינם וראש פתנים אכזר׃ ");
INSERT INTO heb_vpl VALUES ("DT32_34","006_32_34","DEU","32","34","34","הלא הוא כמס עמדי חתם באוצרתי׃ ");
INSERT INTO heb_vpl VALUES ("DT32_35","006_32_35","DEU","32","35","35","לי נקם ושלם לעת תמוט רגלם כי קרוב יום אידם וחש עתדת למו׃ ");
INSERT INTO heb_vpl VALUES ("DT32_36","006_32_36","DEU","32","36","36","כי ידין יהוה עמו ועל עבדיו יתנחם כי יראה כי אזלת יד ואפס עצור ועזוב׃ ");
INSERT INTO heb_vpl VALUES ("DT32_37","006_32_37","DEU","32","37","37","ואמר אי אלהימו צור חסיו בו׃ ");
INSERT INTO heb_vpl VALUES ("DT32_38","006_32_38","DEU","32","38","38","אשר חלב זבחימו יאכלו ישתו יין נסיכם יקומו ויעזרכם יהי עליכם סתרה׃ ");
INSERT INTO heb_vpl VALUES ("DT32_39","006_32_39","DEU","32","39","39","ראו עתה כי אני אני הוא ואין אלהים עמדי אני אמית ואחיה מחצתי ואני ארפא ואין מידי מציל׃ ");
INSERT INTO heb_vpl VALUES ("DT32_40","006_32_40","DEU","32","40","40","כי אשא אל שמים ידי ואמרתי חי אנכי לעלם׃ ");
INSERT INTO heb_vpl VALUES ("DT32_41","006_32_41","DEU","32","41","41","אם שנותי ברק חרבי ותאחז במשפט ידי אשיב נקם לצרי ולמשנאי אשלם׃ ");
INSERT INTO heb_vpl VALUES ("DT32_42","006_32_42","DEU","32","42","42","אשכיר חצי מדם וחרבי תאכל בשר מדם חלל ושביה מראש פרעות אויב׃ ");
INSERT INTO heb_vpl VALUES ("DT32_43","006_32_43","DEU","32","43","43","הרנינו גוים עמו כי דם עבדיו יקום ונקם ישיב לצריו וכפר אדמתו עמו׃ ");
INSERT INTO heb_vpl VALUES ("DT32_44","006_32_44","DEU","32","44","44","ויבא משה וידבר את כל דברי השירה הזאת באזני העם הוא והושע בן נון׃ ");
INSERT INTO heb_vpl VALUES ("DT32_45","006_32_45","DEU","32","45","45","ויכל משה לדבר את כל הדברים האלה אל כל ישראל׃ ");
INSERT INTO heb_vpl VALUES ("DT32_46","006_32_46","DEU","32","46","46","ויאמר אלהם שימו לבבכם לכל הדברים אשר אנכי מעיד בכם היום אשר תצום את בניכם לשמר לעשות את כל דברי התורה הזאת׃ ");
INSERT INTO heb_vpl VALUES ("DT32_47","006_32_47","DEU","32","47","47","כי לא דבר רק הוא מכם כי הוא חייכם ובדבר הזה תאריכו ימים על האדמה אשר אתם עברים את הירדן שמה לרשתה׃ ");
INSERT INTO heb_vpl VALUES ("DT32_48","006_32_48","DEU","32","48","48","וידבר יהוה אל משה בעצם היום הזה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("DT32_49","006_32_49","DEU","32","49","49","עלה אל הר העברים הזה הר נבו אשר בארץ מואב אשר על פני ירחו וראה את ארץ כנען אשר אני נתן לבני ישראל לאחזה׃ ");
INSERT INTO heb_vpl VALUES ("DT32_50","006_32_50","DEU","32","50","50","ומת בהר אשר אתה עלה שמה והאסף אל עמיך כאשר מת אהרן אחיך בהר ההר ויאסף אל עמיו׃ ");
INSERT INTO heb_vpl VALUES ("DT32_51","006_32_51","DEU","32","51","51","על אשר מעלתם בי בתוך בני ישראל במי מריבת קדש מדבר צן על אשר לא קדשתם אותי בתוך בני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("DT32_52","006_32_52","DEU","32","52","52","כי מנגד תראה את הארץ ושמה לא תבוא אל הארץ אשר אני נתן לבני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("DT33_1","006_33_1","DEU","33","1","1","וזאת הברכה אשר ברך משה איש האלהים את בני ישראל לפני מותו׃ ");
INSERT INTO heb_vpl VALUES ("DT33_2","006_33_2","DEU","33","2","2","ויאמר יהוה מסיני בא וזרח משעיר למו הופיע מהר פארן ואתה מרבבת קדש מימינו אש דת למו׃ ");
INSERT INTO heb_vpl VALUES ("DT33_3","006_33_3","DEU","33","3","3","אף חבב עמים כל קדשיו בידך והם תכו לרגלך ישא מדברתיך׃ ");
INSERT INTO heb_vpl VALUES ("DT33_4","006_33_4","DEU","33","4","4","תורה צוה לנו משה מורשה קהלת יעקב׃ ");
INSERT INTO heb_vpl VALUES ("DT33_5","006_33_5","DEU","33","5","5","ויהי בישרון מלך בהתאסף ראשי עם יחד שבטי ישראל׃ ");
INSERT INTO heb_vpl VALUES ("DT33_6","006_33_6","DEU","33","6","6","יחי ראובן ואל ימת ויהי מתיו מספר׃ ");
INSERT INTO heb_vpl VALUES ("DT33_7","006_33_7","DEU","33","7","7","וזאת ליהודה ויאמר שמע יהוה קול יהודה ואל עמו תביאנו ידיו רב לו ועזר מצריו תהיה׃ ");
INSERT INTO heb_vpl VALUES ("DT33_8","006_33_8","DEU","33","8","8","וללוי אמר תמיך ואוריך לאיש חסידך אשר נסיתו במסה תריבהו על מי מריבה׃ ");
INSERT INTO heb_vpl VALUES ("DT33_9","006_33_9","DEU","33","9","9","האמר לאביו ולאמו לא ראיתיו ואת אחיו לא הכיר ואת בנו לא ידע כי שמרו אמרתך ובריתך ינצרו׃ ");
INSERT INTO heb_vpl VALUES ("DT33_10","006_33_10","DEU","33","10","10","יורו משפטיך ליעקב ותורתך לישראל ישימו קטורה באפך וכליל על מזבחך׃ ");
INSERT INTO heb_vpl VALUES ("DT33_11","006_33_11","DEU","33","11","11","ברך יהוה חילו ופעל ידיו תרצה מחץ מתנים קמיו ומשנאיו מן יקומון׃ ");
INSERT INTO heb_vpl VALUES ("DT33_12","006_33_12","DEU","33","12","12","לבנימן אמר ידיד יהוה ישכן לבטח עליו חפף עליו כל היום ובין כתיפיו שכן׃ ");
INSERT INTO heb_vpl VALUES ("DT33_13","006_33_13","DEU","33","13","13","וליוסף אמר מברכת יהוה ארצו ממגד שמים מטל ומתהום רבצת תחת׃ ");
INSERT INTO heb_vpl VALUES ("DT33_14","006_33_14","DEU","33","14","14","וממגד תבואת שמש וממגד גרש ירחים׃ ");
INSERT INTO heb_vpl VALUES ("DT33_15","006_33_15","DEU","33","15","15","ומראש הררי קדם וממגד גבעות עולם׃ ");
INSERT INTO heb_vpl VALUES ("DT33_16","006_33_16","DEU","33","16","16","וממגד ארץ ומלאה ורצון שכני סנה תבואתה לראש יוסף ולקדקד נזיר אחיו׃ ");
INSERT INTO heb_vpl VALUES ("DT33_17","006_33_17","DEU","33","17","17","בכור שורו הדר לו וקרני ראם קרניו בהם עמים ינגח יחדו אפסי ארץ והם רבבות אפרים והם אלפי מנשה׃ ");
INSERT INTO heb_vpl VALUES ("DT33_18","006_33_18","DEU","33","18","18","ולזבולן אמר שמח זבולן בצאתך ויששכר באהליך׃ ");
INSERT INTO heb_vpl VALUES ("DT33_19","006_33_19","DEU","33","19","19","עמים הר יקראו שם יזבחו זבחי צדק כי שפע ימים יינקו ושפוני טמוני חול׃ ");
INSERT INTO heb_vpl VALUES ("DT33_20","006_33_20","DEU","33","20","20","ולגד אמר ברוך מרחיב גד כלביא שכן וטרף זרוע אף קדקד׃ ");
INSERT INTO heb_vpl VALUES ("DT33_21","006_33_21","DEU","33","21","21","וירא ראשית לו כי שם חלקת מחקק ספון ויתא ראשי עם צדקת יהוה עשה ומשפטיו עם ישראל׃ ");
INSERT INTO heb_vpl VALUES ("DT33_22","006_33_22","DEU","33","22","22","ולדן אמר דן גור אריה יזנק מן הבשן׃ ");
INSERT INTO heb_vpl VALUES ("DT33_23","006_33_23","DEU","33","23","23","ולנפתלי אמר נפתלי שבע רצון ומלא ברכת יהוה ים ודרום ירשה׃ ");
INSERT INTO heb_vpl VALUES ("DT33_24","006_33_24","DEU","33","24","24","ולאשר אמר ברוך מבנים אשר יהי רצוי אחיו וטבל בשמן רגלו׃ ");
INSERT INTO heb_vpl VALUES ("DT33_25","006_33_25","DEU","33","25","25","ברזל ונחשת מנעליך וכימיך דבאך׃ ");
INSERT INTO heb_vpl VALUES ("DT33_26","006_33_26","DEU","33","26","26","אין כאל ישרון רכב שמים בעזרך ובגאותו שחקים׃ ");
INSERT INTO heb_vpl VALUES ("DT33_27","006_33_27","DEU","33","27","27","מענה אלהי קדם ומתחת זרעת עולם ויגרש מפניך אויב ויאמר השמד׃ ");
INSERT INTO heb_vpl VALUES ("DT33_28","006_33_28","DEU","33","28","28","וישכן ישראל בטח בדד עין יעקב אל ארץ דגן ותירוש אף שמיו יערפו טל׃ ");
INSERT INTO heb_vpl VALUES ("DT33_29","006_33_29","DEU","33","29","29","אשריך ישראל מי כמוך עם נושע ביהוה מגן עזרך ואשר חרב גאותך ויכחשו איביך לך ואתה על במותימו תדרך׃ ");
INSERT INTO heb_vpl VALUES ("DT34_1","006_34_1","DEU","34","1","1","ויעל משה מערבת מואב אל הר נבו ראש הפסגה אשר על פני ירחו ויראהו יהוה את כל הארץ את הגלעד עד דן׃ ");
INSERT INTO heb_vpl VALUES ("DT34_2","006_34_2","DEU","34","2","2","ואת כל נפתלי ואת ארץ אפרים ומנשה ואת כל ארץ יהודה עד הים האחרון׃ ");
INSERT INTO heb_vpl VALUES ("DT34_3","006_34_3","DEU","34","3","3","ואת הנגב ואת הככר בקעת ירחו עיר התמרים עד צער׃ ");
INSERT INTO heb_vpl VALUES ("DT34_4","006_34_4","DEU","34","4","4","ויאמר יהוה אליו זאת הארץ אשר נשבעתי לאברהם ליצחק וליעקב לאמר לזרעך אתננה הראיתיך בעיניך ושמה לא תעבר׃ ");
INSERT INTO heb_vpl VALUES ("DT34_5","006_34_5","DEU","34","5","5","וימת שם משה עבד יהוה בארץ מואב על פי יהוה׃ ");
INSERT INTO heb_vpl VALUES ("DT34_6","006_34_6","DEU","34","6","6","ויקבר אתו בגי בארץ מואב מול בית פעור ולא ידע איש את קברתו עד היום הזה׃ ");
INSERT INTO heb_vpl VALUES ("DT34_7","006_34_7","DEU","34","7","7","ומשה בן מאה ועשרים שנה במתו לא כהתה עינו ולא נס לחה׃ ");
INSERT INTO heb_vpl VALUES ("DT34_8","006_34_8","DEU","34","8","8","ויבכו בני ישראל את משה בערבת מואב שלשים יום ויתמו ימי בכי אבל משה׃ ");
INSERT INTO heb_vpl VALUES ("DT34_9","006_34_9","DEU","34","9","9","ויהושע בן נון מלא רוח חכמה כי סמך משה את ידיו עליו וישמעו אליו בני ישראל ויעשו כאשר צוה יהוה את משה׃ ");
INSERT INTO heb_vpl VALUES ("DT34_10","006_34_10","DEU","34","10","10","ולא קם נביא עוד בישראל כמשה אשר ידעו יהוה פנים אל פנים׃ ");
INSERT INTO heb_vpl VALUES ("DT34_11","006_34_11","DEU","34","11","11","לכל האתות והמופתים אשר שלחו יהוה לעשות בארץ מצרים לפרעה ולכל עבדיו ולכל ארצו׃ ");
INSERT INTO heb_vpl VALUES ("DT34_12","006_34_12","DEU","34","12","12","ולכל היד החזקה ולכל המורא הגדול אשר עשה משה לעיני כל ישראל׃ ");
INSERT INTO heb_vpl VALUES ("JS1_1","007_1_1","JOS","1","1","1","ויהי אחרי מות משה עבד יהוה ויאמר יהוה אל יהושע בן נון משרת משה לאמר׃ ");
INSERT INTO heb_vpl VALUES ("JS1_2","007_1_2","JOS","1","2","2","משה עבדי מת ועתה קום עבר את הירדן הזה אתה וכל העם הזה אל הארץ אשר אנכי נתן להם לבני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("JS1_3","007_1_3","JOS","1","3","3","כל מקום אשר תדרך כף רגלכם בו לכם נתתיו כאשר דברתי אל משה׃ ");
INSERT INTO heb_vpl VALUES ("JS1_4","007_1_4","JOS","1","4","4","מהמדבר והלבנון הזה ועד הנהר הגדול נהר פרת כל ארץ החתים ועד הים הגדול מבוא השמש יהיה גבולכם׃ ");
INSERT INTO heb_vpl VALUES ("JS1_5","007_1_5","JOS","1","5","5","לא יתיצב איש לפניך כל ימי חייך כאשר הייתי עם משה אהיה עמך לא ארפך ולא אעזבך׃ ");
INSERT INTO heb_vpl VALUES ("JS1_6","007_1_6","JOS","1","6","6","חזק ואמץ כי אתה תנחיל את העם הזה את הארץ אשר נשבעתי לאבותם לתת להם׃ ");
INSERT INTO heb_vpl VALUES ("JS1_7","007_1_7","JOS","1","7","7","רק חזק ואמץ מאד לשמר לעשות ככל התורה אשר צוך משה עבדי אל תסור ממנו ימין ושמאול למען תשכיל בכל אשר תלך׃ ");
INSERT INTO heb_vpl VALUES ("JS1_8","007_1_8","JOS","1","8","8","לא ימוש ספר התורה הזה מפיך והגית בו יומם ולילה למען תשמר לעשות ככל הכתוב בו כי אז תצליח את דרכך ואז תשכיל׃ ");
INSERT INTO heb_vpl VALUES ("JS1_9","007_1_9","JOS","1","9","9","הלוא צויתיך חזק ואמץ אל תערץ ואל תחת כי עמך יהוה אלהיך בכל אשר תלך׃ ");
INSERT INTO heb_vpl VALUES ("JS1_10","007_1_10","JOS","1","10","10","ויצו יהושע את שטרי העם לאמר׃ ");
INSERT INTO heb_vpl VALUES ("JS1_11","007_1_11","JOS","1","11","11","עברו בקרב המחנה וצוו את העם לאמר הכינו לכם צידה כי בעוד שלשת ימים אתם עברים את הירדן הזה לבוא לרשת את הארץ אשר יהוה אלהיכם נתן לכם לרשתה׃ ");
INSERT INTO heb_vpl VALUES ("JS1_12","007_1_12","JOS","1","12","12","ולראובני ולגדי ולחצי שבט המנשה אמר יהושע לאמר׃ ");
INSERT INTO heb_vpl VALUES ("JS1_13","007_1_13","JOS","1","13","13","זכור את הדבר אשר צוה אתכם משה עבד יהוה לאמר יהוה אלהיכם מניח לכם ונתן לכם את הארץ הזאת׃ ");
INSERT INTO heb_vpl VALUES ("JS1_14","007_1_14","JOS","1","14","14","נשיכם טפכם ומקניכם ישבו בארץ אשר נתן לכם משה בעבר הירדן ואתם תעברו חמשים לפני אחיכם כל גבורי החיל ועזרתם אותם׃ ");
INSERT INTO heb_vpl VALUES ("JS1_15","007_1_15","JOS","1","15","15","עד אשר יניח יהוה לאחיכם ככם וירשו גם המה את הארץ אשר יהוה אלהיכם נתן להם ושבתם לארץ ירשתכם וירשתם אותה אשר נתן לכם משה עבד יהוה בעבר הירדן מזרח השמש׃ ");
INSERT INTO heb_vpl VALUES ("JS1_16","007_1_16","JOS","1","16","16","ויענו את יהושע לאמר כל אשר צויתנו נעשה ואל כל אשר תשלחנו נלך׃ ");
INSERT INTO heb_vpl VALUES ("JS1_17","007_1_17","JOS","1","17","17","ככל אשר שמענו אל משה כן נשמע אליך רק יהיה יהוה אלהיך עמך כאשר היה עם משה׃ ");
INSERT INTO heb_vpl VALUES ("JS1_18","007_1_18","JOS","1","18","18","כל איש אשר ימרה את פיך ולא ישמע את דבריך לכל אשר תצונו יומת רק חזק ואמץ׃ ");
INSERT INTO heb_vpl VALUES ("JS2_1","007_2_1","JOS","2","1","1","וישלח יהושע בן נון מן השטים שנים אנשים מרגלים חרש לאמר לכו ראו את הארץ ואת יריחו וילכו ויבאו בית אשה זונה ושמה רחב וישכבו שמה׃ ");
INSERT INTO heb_vpl VALUES ("JS2_2","007_2_2","JOS","2","2","2","ויאמר למלך יריחו לאמר הנה אנשים באו הנה הלילה מבני ישראל לחפר את הארץ׃ ");
INSERT INTO heb_vpl VALUES ("JS2_3","007_2_3","JOS","2","3","3","וישלח מלך יריחו אל רחב לאמר הוציאי האנשים הבאים אליך אשר באו לביתך כי לחפר את כל הארץ באו׃ ");
INSERT INTO heb_vpl VALUES ("JS2_4","007_2_4","JOS","2","4","4","ותקח האשה את שני האנשים ותצפנו ותאמר כן באו אלי האנשים ולא ידעתי מאין המה׃ ");
INSERT INTO heb_vpl VALUES ("JS2_5","007_2_5","JOS","2","5","5","ויהי השער לסגור בחשך והאנשים יצאו לא ידעתי אנה הלכו האנשים רדפו מהר אחריהם כי תשיגום׃ ");
INSERT INTO heb_vpl VALUES ("JS2_6","007_2_6","JOS","2","6","6","והיא העלתם הגגה ותטמנם בפשתי העץ הערכות לה על הגג׃ ");
INSERT INTO heb_vpl VALUES ("JS2_7","007_2_7","JOS","2","7","7","והאנשים רדפו אחריהם דרך הירדן על המעברות והשער סגרו אחרי כאשר יצאו הרדפים אחריהם׃ ");
INSERT INTO heb_vpl VALUES ("JS2_8","007_2_8","JOS","2","8","8","והמה טרם ישכבון והיא עלתה עליהם על הגג׃ ");
INSERT INTO heb_vpl VALUES ("JS2_9","007_2_9","JOS","2","9","9","ותאמר אל האנשים ידעתי כי נתן יהוה לכם את הארץ וכי נפלה אימתכם עלינו וכי נמגו כל ישבי הארץ מפניכם׃ ");
INSERT INTO heb_vpl VALUES ("JS2_10","007_2_10","JOS","2","10","10","כי שמענו את אשר הוביש יהוה את מי ים סוף מפניכם בצאתכם ממצרים ואשר עשיתם לשני מלכי האמרי אשר בעבר הירדן לסיחן ולעוג אשר החרמתם אותם׃ ");
INSERT INTO heb_vpl VALUES ("JS2_11","007_2_11","JOS","2","11","11","ונשמע וימס לבבנו ולא קמה עוד רוח באיש מפניכם כי יהוה אלהיכם הוא אלהים בשמים ממעל ועל הארץ מתחת׃ ");
INSERT INTO heb_vpl VALUES ("JS2_12","007_2_12","JOS","2","12","12","ועתה השבעו נא לי ביהוה כי עשיתי עמכם חסד ועשיתם גם אתם עם בית אבי חסד ונתתם לי אות אמת׃ ");
INSERT INTO heb_vpl VALUES ("JS2_13","007_2_13","JOS","2","13","13","והחיתם את אבי ואת אמי ואת אחי ואת אחותי ואת כל אשר להם והצלתם את נפשתינו ממות׃ ");
INSERT INTO heb_vpl VALUES ("JS2_14","007_2_14","JOS","2","14","14","ויאמרו לה האנשים נפשנו תחתיכם למות אם לא תגידו את דברנו זה והיה בתת יהוה לנו את הארץ ועשינו עמך חסד ואמת׃ ");
INSERT INTO heb_vpl VALUES ("JS2_15","007_2_15","JOS","2","15","15","ותורדם בחבל בעד החלון כי ביתה בקיר החומה ובחומה היא יושבת׃ ");
INSERT INTO heb_vpl VALUES ("JS2_16","007_2_16","JOS","2","16","16","ותאמר להם ההרה לכו פן יפגעו בכם הרדפים ונחבתם שמה שלשת ימים עד שוב הרדפים ואחר תלכו לדרככם׃ ");
INSERT INTO heb_vpl VALUES ("JS2_17","007_2_17","JOS","2","17","17","ויאמרו אליה האנשים נקים אנחנו משבעתך הזה אשר השבעתנו׃ ");
INSERT INTO heb_vpl VALUES ("JS2_18","007_2_18","JOS","2","18","18","הנה אנחנו באים בארץ את תקות חוט השני הזה תקשרי בחלון אשר הורדתנו בו ואת אביך ואת אמך ואת אחיך ואת כל בית אביך תאספי אליך הביתה׃ ");
INSERT INTO heb_vpl VALUES ("JS2_19","007_2_19","JOS","2","19","19","והיה כל אשר יצא מדלתי ביתך החוצה דמו בראשו ואנחנו נקים וכל אשר יהיה אתך בבית דמו בראשנו אם יד תהיה בו׃ ");
INSERT INTO heb_vpl VALUES ("JS2_20","007_2_20","JOS","2","20","20","ואם תגידי את דברנו זה והיינו נקים משבעתך אשר השבעתנו׃ ");
INSERT INTO heb_vpl VALUES ("JS2_21","007_2_21","JOS","2","21","21","ותאמר כדבריכם כן הוא ותשלחם וילכו ותקשר את תקות השני בחלון׃ ");
INSERT INTO heb_vpl VALUES ("JS2_22","007_2_22","JOS","2","22","22","וילכו ויבאו ההרה וישבו שם שלשת ימים עד שבו הרדפים ויבקשו הרדפים בכל הדרך ולא מצאו׃ ");
INSERT INTO heb_vpl VALUES ("JS2_23","007_2_23","JOS","2","23","23","וישבו שני האנשים וירדו מההר ויעברו ויבאו אל יהושע בן נון ויספרו לו את כל המצאות אותם׃ ");
INSERT INTO heb_vpl VALUES ("JS2_24","007_2_24","JOS","2","24","24","ויאמרו אל יהושע כי נתן יהוה בידנו את כל הארץ וגם נמגו כל ישבי הארץ מפנינו׃ ");
INSERT INTO heb_vpl VALUES ("JS3_1","007_3_1","JOS","3","1","1","וישכם יהושע בבקר ויסעו מהשטים ויבאו עד הירדן הוא וכל בני ישראל וילנו שם טרם יעברו׃ ");
INSERT INTO heb_vpl VALUES ("JS3_2","007_3_2","JOS","3","2","2","ויהי מקצה שלשת ימים ויעברו השטרים בקרב המחנה׃ ");
INSERT INTO heb_vpl VALUES ("JS3_3","007_3_3","JOS","3","3","3","ויצוו את העם לאמר כראותכם את ארון ברית יהוה אלהיכם והכהנים הלוים נשאים אתו ואתם תסעו ממקומכם והלכתם אחריו׃ ");
INSERT INTO heb_vpl VALUES ("JS3_4","007_3_4","JOS","3","4","4","אך רחוק יהיה ביניכם ובינו כאלפים אמה במדה אל תקרבו אליו למען אשר תדעו את הדרך אשר תלכו בה כי לא עברתם בדרך מתמול שלשום׃ ");
INSERT INTO heb_vpl VALUES ("JS3_5","007_3_5","JOS","3","5","5","ויאמר יהושע אל העם התקדשו כי מחר יעשה יהוה בקרבכם נפלאות׃ ");
INSERT INTO heb_vpl VALUES ("JS3_6","007_3_6","JOS","3","6","6","ויאמר יהושע אל הכהנים לאמר שאו את ארון הברית ועברו לפני העם וישאו את ארון הברית וילכו לפני העם׃ ");
INSERT INTO heb_vpl VALUES ("JS3_7","007_3_7","JOS","3","7","7","ויאמר יהוה אל יהושע היום הזה אחל גדלך בעיני כל ישראל אשר ידעון כי כאשר הייתי עם משה אהיה עמך׃ ");
INSERT INTO heb_vpl VALUES ("JS3_8","007_3_8","JOS","3","8","8","ואתה תצוה את הכהנים נשאי ארון הברית לאמר כבאכם עד קצה מי הירדן בירדן תעמדו׃ ");
INSERT INTO heb_vpl VALUES ("JS3_9","007_3_9","JOS","3","9","9","ויאמר יהושע אל בני ישראל גשו הנה ושמעו את דברי יהוה אלהיכם׃ ");
INSERT INTO heb_vpl VALUES ("JS3_10","007_3_10","JOS","3","10","10","ויאמר יהושע בזאת תדעון כי אל חי בקרבכם והורש יוריש מפניכם את הכנעני ואת החתי ואת החוי ואת הפרזי ואת הגרגשי והאמרי והיבוסי׃ ");
INSERT INTO heb_vpl VALUES ("JS3_11","007_3_11","JOS","3","11","11","הנה ארון הברית אדון כל הארץ עבר לפניכם בירדן׃ ");
INSERT INTO heb_vpl VALUES ("JS3_12","007_3_12","JOS","3","12","12","ועתה קחו לכם שני עשר איש משבטי ישראל איש אחד איש אחד לשבט׃ ");
INSERT INTO heb_vpl VALUES ("JS3_13","007_3_13","JOS","3","13","13","והיה כנוח כפות רגלי הכהנים נשאי ארון יהוה אדון כל הארץ במי הירדן מי הירדן יכרתון המים הירדים מלמעלה ויעמדו נד אחד׃ ");
INSERT INTO heb_vpl VALUES ("JS3_14","007_3_14","JOS","3","14","14","ויהי בנסע העם מאהליהם לעבר את הירדן והכהנים נשאי הארון הברית לפני העם׃ ");
INSERT INTO heb_vpl VALUES ("JS3_15","007_3_15","JOS","3","15","15","וכבוא נשאי הארון עד הירדן ורגלי הכהנים נשאי הארון נטבלו בקצה המים והירדן מלא על כל גדותיו כל ימי קציר׃ ");
INSERT INTO heb_vpl VALUES ("JS3_16","007_3_16","JOS","3","16","16","ויעמדו המים הירדים מלמעלה קמו נד אחד הרחק מאד באדם העיר אשר מצד צרתן והירדים על ים הערבה ים המלח תמו נכרתו והעם עברו נגד יריחו׃ ");
INSERT INTO heb_vpl VALUES ("JS3_17","007_3_17","JOS","3","17","17","ויעמדו הכהנים נשאי הארון ברית יהוה בחרבה בתוך הירדן הכן וכל ישראל עברים בחרבה עד אשר תמו כל הגוי לעבר את הירדן׃ ");
INSERT INTO heb_vpl VALUES ("JS4_1","007_4_1","JOS","4","1","1","ויהי כאשר תמו כל הגוי לעבור את הירדן ויאמר יהוה אל יהושע לאמר׃ ");
INSERT INTO heb_vpl VALUES ("JS4_2","007_4_2","JOS","4","2","2","קחו לכם מן העם שנים עשר אנשים איש אחד איש אחד משבט׃ ");
INSERT INTO heb_vpl VALUES ("JS4_3","007_4_3","JOS","4","3","3","וצוו אותם לאמר שאו לכם מזה מתוך הירדן ממצב רגלי הכהנים הכין שתים עשרה אבנים והעברתם אותם עמכם והנחתם אותם במלון אשר תלינו בו הלילה׃ ");
INSERT INTO heb_vpl VALUES ("JS4_4","007_4_4","JOS","4","4","4","ויקרא יהושע אל שנים העשר איש אשר הכין מבני ישראל איש אחד איש אחד משבט׃ ");
INSERT INTO heb_vpl VALUES ("JS4_5","007_4_5","JOS","4","5","5","ויאמר להם יהושע עברו לפני ארון יהוה אלהיכם אל תוך הירדן והרימו לכם איש אבן אחת על שכמו למספר שבטי בני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("JS4_6","007_4_6","JOS","4","6","6","למען תהיה זאת אות בקרבכם כי ישאלון בניכם מחר לאמר מה האבנים האלה לכם׃ ");
INSERT INTO heb_vpl VALUES ("JS4_7","007_4_7","JOS","4","7","7","ואמרתם להם אשר נכרתו מימי הירדן מפני ארון ברית יהוה בעברו בירדן נכרתו מי הירדן והיו האבנים האלה לזכרון לבני ישראל עד עולם׃ ");
INSERT INTO heb_vpl VALUES ("JS4_8","007_4_8","JOS","4","8","8","ויעשו כן בני ישראל כאשר צוה יהושע וישאו שתי עשרה אבנים מתוך הירדן כאשר דבר יהוה אל יהושע למספר שבטי בני ישראל ויעברום עמם אל המלון וינחום שם׃ ");
INSERT INTO heb_vpl VALUES ("JS4_9","007_4_9","JOS","4","9","9","ושתים עשרה אבנים הקים יהושע בתוך הירדן תחת מצב רגלי הכהנים נשאי ארון הברית ויהיו שם עד היום הזה׃ ");
INSERT INTO heb_vpl VALUES ("JS4_10","007_4_10","JOS","4","10","10","והכהנים נשאי הארון עמדים בתוך הירדן עד תם כל הדבר אשר צוה יהוה את יהושע לדבר אל העם ככל אשר צוה משה את יהושע וימהרו העם ויעברו׃ ");
INSERT INTO heb_vpl VALUES ("JS4_11","007_4_11","JOS","4","11","11","ויהי כאשר תם כל העם לעבור ויעבר ארון יהוה והכהנים לפני העם׃ ");
INSERT INTO heb_vpl VALUES ("JS4_12","007_4_12","JOS","4","12","12","ויעברו בני ראובן ובני גד וחצי שבט המנשה חמשים לפני בני ישראל כאשר דבר אליהם משה׃ ");
INSERT INTO heb_vpl VALUES ("JS4_13","007_4_13","JOS","4","13","13","כארבעים אלף חלוצי הצבא עברו לפני יהוה למלחמה אל ערבות יריחו׃ ");
INSERT INTO heb_vpl VALUES ("JS4_14","007_4_14","JOS","4","14","14","ביום ההוא גדל יהוה את יהושע בעיני כל ישראל ויראו אתו כאשר יראו את משה כל ימי חייו׃ ");
INSERT INTO heb_vpl VALUES ("JS4_15","007_4_15","JOS","4","15","15","ויאמר יהוה אל יהושע לאמר׃ ");
INSERT INTO heb_vpl VALUES ("JS4_16","007_4_16","JOS","4","16","16","צוה את הכהנים נשאי ארון העדות ויעלו מן הירדן׃ ");
INSERT INTO heb_vpl VALUES ("JS4_17","007_4_17","JOS","4","17","17","ויצו יהושע את הכהנים לאמר עלו מן הירדן׃ ");
INSERT INTO heb_vpl VALUES ("JS4_18","007_4_18","JOS","4","18","18","ויהי בעלות הכהנים נשאי ארון ברית יהוה מתוך הירדן נתקו כפות רגלי הכהנים אל החרבה וישבו מי הירדן למקומם וילכו כתמול שלשום על כל גדותיו׃ ");
INSERT INTO heb_vpl VALUES ("JS4_19","007_4_19","JOS","4","19","19","והעם עלו מן הירדן בעשור לחדש הראשון ויחנו בגלגל בקצה מזרח יריחו׃ ");
INSERT INTO heb_vpl VALUES ("JS4_20","007_4_20","JOS","4","20","20","ואת שתים עשרה האבנים האלה אשר לקחו מן הירדן הקים יהושע בגלגל׃ ");
INSERT INTO heb_vpl VALUES ("JS4_21","007_4_21","JOS","4","21","21","ויאמר אל בני ישראל לאמר אשר ישאלון בניכם מחר את אבותם לאמר מה האבנים האלה׃ ");
INSERT INTO heb_vpl VALUES ("JS4_22","007_4_22","JOS","4","22","22","והודעתם את בניכם לאמר ביבשה עבר ישראל את הירדן הזה׃ ");
INSERT INTO heb_vpl VALUES ("JS4_23","007_4_23","JOS","4","23","23","אשר הוביש יהוה אלהיכם את מי הירדן מפניכם עד עברכם כאשר עשה יהוה אלהיכם לים סוף אשר הוביש מפנינו עד עברנו׃ ");
INSERT INTO heb_vpl VALUES ("JS4_24","007_4_24","JOS","4","24","24","למען דעת כל עמי הארץ את יד יהוה כי חזקה היא למען יראתם את יהוה אלהיכם כל הימים׃ ");
INSERT INTO heb_vpl VALUES ("JS5_1","007_5_1","JOS","5","1","1","ויהי כשמע כל מלכי האמרי אשר בעבר הירדן ימה וכל מלכי הכנעני אשר על הים את אשר הוביש יהוה את מי הירדן מפני בני ישראל עד עברנו וימס לבבם ולא היה בם עוד רוח מפני בני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("JS5_2","007_5_2","JOS","5","2","2","בעת ההיא אמר יהוה אל יהושע עשה לך חרבות צרים ושוב מל את בני ישראל שנית׃ ");
INSERT INTO heb_vpl VALUES ("JS5_3","007_5_3","JOS","5","3","3","ויעש לו יהושע חרבות צרים וימל את בני ישראל אל גבעת הערלות׃ ");
INSERT INTO heb_vpl VALUES ("JS5_4","007_5_4","JOS","5","4","4","וזה הדבר אשר מל יהושע כל העם היצא ממצרים הזכרים כל אנשי המלחמה מתו במדבר בדרך בצאתם ממצרים׃ ");
INSERT INTO heb_vpl VALUES ("JS5_5","007_5_5","JOS","5","5","5","כי מלים היו כל העם היצאים וכל העם הילדים במדבר בדרך בצאתם ממצרים לא מלו׃ ");
INSERT INTO heb_vpl VALUES ("JS5_6","007_5_6","JOS","5","6","6","כי ארבעים שנה הלכו בני ישראל במדבר עד תם כל הגוי אנשי המלחמה היצאים ממצרים אשר לא שמעו בקול יהוה אשר נשבע יהוה להם לבלתי הראותם את הארץ אשר נשבע יהוה לאבותם לתת לנו ארץ זבת חלב ודבש׃ ");
INSERT INTO heb_vpl VALUES ("JS5_7","007_5_7","JOS","5","7","7","ואת בניהם הקים תחתם אתם מל יהושע כי ערלים היו כי לא מלו אותם בדרך׃ ");
INSERT INTO heb_vpl VALUES ("JS5_8","007_5_8","JOS","5","8","8","ויהי כאשר תמו כל הגוי להמול וישבו תחתם במחנה עד חיותם׃ ");
INSERT INTO heb_vpl VALUES ("JS5_9","007_5_9","JOS","5","9","9","ויאמר יהוה אל יהושע היום גלותי את חרפת מצרים מעליכם ויקרא שם המקום ההוא גלגל עד היום הזה׃ ");
INSERT INTO heb_vpl VALUES ("JS5_10","007_5_10","JOS","5","10","10","ויחנו בני ישראל בגלגל ויעשו את הפסח בארבעה עשר יום לחדש בערב בערבות יריחו׃ ");
INSERT INTO heb_vpl VALUES ("JS5_11","007_5_11","JOS","5","11","11","ויאכלו מעבור הארץ ממחרת הפסח מצות וקלוי בעצם היום הזה׃ ");
INSERT INTO heb_vpl VALUES ("JS5_12","007_5_12","JOS","5","12","12","וישבת המן ממחרת באכלם מעבור הארץ ולא היה עוד לבני ישראל מן ויאכלו מתבואת ארץ כנען בשנה ההיא׃ ");
INSERT INTO heb_vpl VALUES ("JS5_13","007_5_13","JOS","5","13","13","ויהי בהיות יהושע ביריחו וישא עיניו וירא והנה איש עמד לנגדו וחרבו שלופה בידו וילך יהושע אליו ויאמר לו הלנו אתה אם לצרינו׃ ");
INSERT INTO heb_vpl VALUES ("JS5_14","007_5_14","JOS","5","14","14","ויאמר לא כי אני שר צבא יהוה עתה באתי ויפל יהושע אל פניו ארצה וישתחו ויאמר לו מה אדני מדבר אל עבדו׃ ");
INSERT INTO heb_vpl VALUES ("JS5_15","007_5_15","JOS","5","15","15","ויאמר שר צבא יהוה אל יהושע של נעלך מעל רגלך כי המקום אשר אתה עמד עליו קדש הוא ויעש יהושע כן׃ ");
INSERT INTO heb_vpl VALUES ("JS6_1","007_6_1","JOS","6","1","1","ויריחו סגרת ומסגרת מפני בני ישראל אין יוצא ואין בא׃ ");
INSERT INTO heb_vpl VALUES ("JS6_2","007_6_2","JOS","6","2","2","ויאמר יהוה אל יהושע ראה נתתי בידך את יריחו ואת מלכה גבורי החיל׃ ");
INSERT INTO heb_vpl VALUES ("JS6_3","007_6_3","JOS","6","3","3","וסבתם את העיר כל אנשי המלחמה הקיף את העיר פעם אחת כה תעשה ששת ימים׃ ");
INSERT INTO heb_vpl VALUES ("JS6_4","007_6_4","JOS","6","4","4","ושבעה כהנים ישאו שבעה שופרות היובלים לפני הארון וביום השביעי תסבו את העיר שבע פעמים והכהנים יתקעו בשופרות׃ ");
INSERT INTO heb_vpl VALUES ("JS6_5","007_6_5","JOS","6","5","5","והיה במשך בקרן היובל בשמעכם את קול השופר יריעו כל העם תרועה גדולה ונפלה חומת העיר תחתיה ועלו העם איש נגדו׃ ");
INSERT INTO heb_vpl VALUES ("JS6_6","007_6_6","JOS","6","6","6","ויקרא יהושע בן נון אל הכהנים ויאמר אלהם שאו את ארון הברית ושבעה כהנים ישאו שבעה שופרות יובלים לפני ארון יהוה׃ ");
INSERT INTO heb_vpl VALUES ("JS6_7","007_6_7","JOS","6","7","7","ויאמרו אל העם עברו וסבו את העיר והחלוץ יעבר לפני ארון יהוה׃ ");
INSERT INTO heb_vpl VALUES ("JS6_8","007_6_8","JOS","6","8","8","ויהי כאמר יהושע אל העם ושבעה הכהנים נשאים שבעה שופרות היובלים לפני יהוה עברו ותקעו בשופרות וארון ברית יהוה הלך אחריהם׃ ");
INSERT INTO heb_vpl VALUES ("JS6_9","007_6_9","JOS","6","9","9","והחלוץ הלך לפני הכהנים תקעו השופרות והמאסף הלך אחרי הארון הלוך ותקוע בשופרות׃ ");
INSERT INTO heb_vpl VALUES ("JS6_10","007_6_10","JOS","6","10","10","ואת העם צוה יהושע לאמר לא תריעו ולא תשמיעו את קולכם ולא יצא מפיכם דבר עד יום אמרי אליכם הריעו והריעתם׃ ");
INSERT INTO heb_vpl VALUES ("JS6_11","007_6_11","JOS","6","11","11","ויסב ארון יהוה את העיר הקף פעם אחת ויבאו המחנה וילינו במחנה׃ ");
INSERT INTO heb_vpl VALUES ("JS6_12","007_6_12","JOS","6","12","12","וישכם יהושע בבקר וישאו הכהנים את ארון יהוה׃ ");
INSERT INTO heb_vpl VALUES ("JS6_13","007_6_13","JOS","6","13","13","ושבעה הכהנים נשאים שבעה שופרות היבלים לפני ארון יהוה הלכים הלוך ותקעו בשופרות והחלוץ הלך לפניהם והמאסף הלך אחרי ארון יהוה הולך ותקוע בשופרות׃ ");
INSERT INTO heb_vpl VALUES ("JS6_14","007_6_14","JOS","6","14","14","ויסבו את העיר ביום השני פעם אחת וישבו המחנה כה עשו ששת ימים׃ ");
INSERT INTO heb_vpl VALUES ("JS6_15","007_6_15","JOS","6","15","15","ויהי ביום השביעי וישכמו כעלות השחר ויסבו את העיר כמשפט הזה שבע פעמים רק ביום ההוא סבבו את העיר שבע פעמים׃ ");
INSERT INTO heb_vpl VALUES ("JS6_16","007_6_16","JOS","6","16","16","ויהי בפעם השביעית תקעו הכהנים בשופרות ויאמר יהושע אל העם הריעו כי נתן יהוה לכם את העיר׃ ");
INSERT INTO heb_vpl VALUES ("JS6_17","007_6_17","JOS","6","17","17","והיתה העיר חרם היא וכל אשר בה ליהוה רק רחב הזונה תחיה היא וכל אשר אתה בבית כי החבאתה את המלאכים אשר שלחנו׃ ");
INSERT INTO heb_vpl VALUES ("JS6_18","007_6_18","JOS","6","18","18","ורק אתם שמרו מן החרם פן תחרימו ולקחתם מן החרם ושמתם את מחנה ישראל לחרם ועכרתם אותו׃ ");
INSERT INTO heb_vpl VALUES ("JS6_19","007_6_19","JOS","6","19","19","וכל כסף וזהב וכלי נחשת וברזל קדש הוא ליהוה אוצר יהוה יבוא׃ ");
INSERT INTO heb_vpl VALUES ("JS6_20","007_6_20","JOS","6","20","20","וירע העם ויתקעו בשפרות ויהי כשמע העם את קול השופר ויריעו העם תרועה גדולה ותפל החומה תחתיה ויעל העם העירה איש נגדו וילכדו את העיר׃ ");
INSERT INTO heb_vpl VALUES ("JS6_21","007_6_21","JOS","6","21","21","ויחרימו את כל אשר בעיר מאיש ועד אשה מנער ועד זקן ועד שור ושה וחמור לפי חרב׃ ");
INSERT INTO heb_vpl VALUES ("JS6_22","007_6_22","JOS","6","22","22","ולשנים האנשים המרגלים את הארץ אמר יהושע באו בית האשה הזונה והוציאו משם את האשה ואת כל אשר לה כאשר נשבעתם לה׃ ");
INSERT INTO heb_vpl VALUES ("JS6_23","007_6_23","JOS","6","23","23","ויבאו הנערים המרגלים ויציאו את רחב ואת אביה ואת אמה ואת אחיה ואת כל אשר לה ואת כל משפחותיה הוציאו ויניחום מחוץ למחנה ישראל׃ ");
INSERT INTO heb_vpl VALUES ("JS6_24","007_6_24","JOS","6","24","24","והעיר שרפו באש וכל אשר בה רק הכסף והזהב וכלי הנחשת והברזל נתנו אוצר בית יהוה׃ ");
INSERT INTO heb_vpl VALUES ("JS6_25","007_6_25","JOS","6","25","25","ואת רחב הזונה ואת בית אביה ואת כל אשר לה החיה יהושע ותשב בקרב ישראל עד היום הזה כי החביאה את המלאכים אשר שלח יהושע לרגל את יריחו׃ ");
INSERT INTO heb_vpl VALUES ("JS6_26","007_6_26","JOS","6","26","26","וישבע יהושע בעת ההיא לאמר ארור האיש לפני יהוה אשר יקום ובנה את העיר הזאת את יריחו בבכרו ייסדנה ובצעירו יציב דלתיה׃ ");
INSERT INTO heb_vpl VALUES ("JS6_27","007_6_27","JOS","6","27","27","ויהי יהוה את יהושע ויהי שמעו בכל הארץ׃ ");
INSERT INTO heb_vpl VALUES ("JS7_1","007_7_1","JOS","7","1","1","וימעלו בני ישראל מעל בחרם ויקח עכן בן כרמי בן זבדי בן זרח למטה יהודה מן החרם ויחר אף יהוה בבני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("JS7_2","007_7_2","JOS","7","2","2","וישלח יהושע אנשים מיריחו העי אשר עם בית און מקדם לבית אל ויאמר אליהם לאמר עלו ורגלו את הארץ ויעלו האנשים וירגלו את העי׃ ");
INSERT INTO heb_vpl VALUES ("JS7_3","007_7_3","JOS","7","3","3","וישבו אל יהושע ויאמרו אליו אל יעל כל העם כאלפים איש או כשלשת אלפים איש יעלו ויכו את העי אל תיגע שמה את כל העם כי מעט המה׃ ");
INSERT INTO heb_vpl VALUES ("JS7_4","007_7_4","JOS","7","4","4","ויעלו מן העם שמה כשלשת אלפים איש וינסו לפני אנשי העי׃ ");
INSERT INTO heb_vpl VALUES ("JS7_5","007_7_5","JOS","7","5","5","ויכו מהם אנשי העי כשלשים וששה איש וירדפום לפני השער עד השברים ויכום במורד וימס לבב העם ויהי למים׃ ");
INSERT INTO heb_vpl VALUES ("JS7_6","007_7_6","JOS","7","6","6","ויקרע יהושע שמלתיו ויפל על פניו ארצה לפני ארון יהוה עד הערב הוא וזקני ישראל ויעלו עפר על ראשם׃ ");
INSERT INTO heb_vpl VALUES ("JS7_7","007_7_7","JOS","7","7","7","ויאמר יהושע אהה אדני יהוה למה העברת העביר את העם הזה את הירדן לתת אתנו ביד האמרי להאבידנו ולו הואלנו ונשב בעבר הירדן׃ ");
INSERT INTO heb_vpl VALUES ("JS7_8","007_7_8","JOS","7","8","8","בי אדני מה אמר אחרי אשר הפך ישראל ערף לפני איביו׃ ");
INSERT INTO heb_vpl VALUES ("JS7_9","007_7_9","JOS","7","9","9","וישמעו הכנעני וכל ישבי הארץ ונסבו עלינו והכריתו את שמנו מן הארץ ומה תעשה לשמך הגדול׃ ");
INSERT INTO heb_vpl VALUES ("JS7_10","007_7_10","JOS","7","10","10","ויאמר יהוה אל יהושע קם לך למה זה אתה נפל על פניך׃ ");
INSERT INTO heb_vpl VALUES ("JS7_11","007_7_11","JOS","7","11","11","חטא ישראל וגם עברו את בריתי אשר צויתי אותם וגם לקחו מן החרם וגם גנבו וגם כחשו וגם שמו בכליהם׃ ");
INSERT INTO heb_vpl VALUES ("JS7_12","007_7_12","JOS","7","12","12","ולא יכלו בני ישראל לקום לפני איביהם ערף יפנו לפני איביהם כי היו לחרם לא אוסיף להיות עמכם אם לא תשמידו החרם מקרבכם׃ ");
INSERT INTO heb_vpl VALUES ("JS7_13","007_7_13","JOS","7","13","13","קם קדש את העם ואמרת התקדשו למחר כי כה אמר יהוה אלהי ישראל חרם בקרבך ישראל לא תוכל לקום לפני איביך עד הסירכם החרם מקרבכם׃ ");
INSERT INTO heb_vpl VALUES ("JS7_14","007_7_14","JOS","7","14","14","ונקרבתם בבקר לשבטיכם והיה השבט אשר ילכדנו יהוה יקרב למשפחות והמשפחה אשר ילכדנה יהוה תקרב לבתים והבית אשר ילכדנו יהוה יקרב לגברים׃ ");
INSERT INTO heb_vpl VALUES ("JS7_15","007_7_15","JOS","7","15","15","והיה הנלכד בחרם ישרף באש אתו ואת כל אשר לו כי עבר את ברית יהוה וכי עשה נבלה בישראל׃ ");
INSERT INTO heb_vpl VALUES ("JS7_16","007_7_16","JOS","7","16","16","וישכם יהושע בבקר ויקרב את ישראל לשבטיו וילכד שבט יהודה׃ ");
INSERT INTO heb_vpl VALUES ("JS7_17","007_7_17","JOS","7","17","17","ויקרב את משפחת יהודה וילכד את משפחת הזרחי ויקרב את משפחת הזרחי לגברים וילכד זבדי׃ ");
INSERT INTO heb_vpl VALUES ("JS7_18","007_7_18","JOS","7","18","18","ויקרב את ביתו לגברים וילכד עכן בן כרמי בן זבדי בן זרח למטה יהודה׃ ");
INSERT INTO heb_vpl VALUES ("JS7_19","007_7_19","JOS","7","19","19","ויאמר יהושע אל עכן בני שים נא כבוד ליהוה אלהי ישראל ותן לו תודה והגד נא לי מה עשית אל תכחד ממני׃ ");
INSERT INTO heb_vpl VALUES ("JS7_20","007_7_20","JOS","7","20","20","ויען עכן את יהושע ויאמר אמנה אנכי חטאתי ליהוה אלהי ישראל וכזאת וכזאת עשיתי׃ ");
INSERT INTO heb_vpl VALUES ("JS7_21","007_7_21","JOS","7","21","21","ואראה בשלל אדרת שנער אחת טובה ומאתים שקלים כסף ולשון זהב אחד חמשים שקלים משקלו ואחמדם ואקחם והנם טמונים בארץ בתוך האהלי והכסף תחתיה׃ ");
INSERT INTO heb_vpl VALUES ("JS7_22","007_7_22","JOS","7","22","22","וישלח יהושע מלאכים וירצו האהלה והנה טמונה באהלו והכסף תחתיה׃ ");
INSERT INTO heb_vpl VALUES ("JS7_23","007_7_23","JOS","7","23","23","ויקחום מתוך האהל ויבאום אל יהושע ואל כל בני ישראל ויצקם לפני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("JS7_24","007_7_24","JOS","7","24","24","ויקח יהושע את עכן בן זרח ואת הכסף ואת האדרת ואת לשון הזהב ואת בניו ואת בנתיו ואת שורו ואת חמרו ואת צאנו ואת אהלו ואת כל אשר לו וכל ישראל עמו ויעלו אתם עמק עכור׃ ");
INSERT INTO heb_vpl VALUES ("JS7_25","007_7_25","JOS","7","25","25","ויאמר יהושע מה עכרתנו יעכרך יהוה ביום הזה וירגמו אתו כל ישראל אבן וישרפו אתם באש ויסקלו אתם באבנים׃ ");
INSERT INTO heb_vpl VALUES ("JS7_26","007_7_26","JOS","7","26","26","ויקימו עליו גל אבנים גדול עד היום הזה וישב יהוה מחרון אפו על כן קרא שם המקום ההוא עמק עכור עד היום הזה׃ ");
INSERT INTO heb_vpl VALUES ("JS8_1","007_8_1","JOS","8","1","1","ויאמר יהוה אל יהושע אל תירא ואל תחת קח עמך את כל עם המלחמה וקום עלה העי ראה נתתי בידך את מלך העי ואת עמו ואת עירו ואת ארצו׃ ");
INSERT INTO heb_vpl VALUES ("JS8_2","007_8_2","JOS","8","2","2","ועשית לעי ולמלכה כאשר עשית ליריחו ולמלכה רק שללה ובהמתה תבזו לכם שים לך ארב לעיר מאחריה׃ ");
INSERT INTO heb_vpl VALUES ("JS8_3","007_8_3","JOS","8","3","3","ויקם יהושע וכל עם המלחמה לעלות העי ויבחר יהושע שלשים אלף איש גבורי החיל וישלחם לילה׃ ");
INSERT INTO heb_vpl VALUES ("JS8_4","007_8_4","JOS","8","4","4","ויצו אתם לאמר ראו אתם ארבים לעיר מאחרי העיר אל תרחיקו מן העיר מאד והייתם כלכם נכנים׃ ");
INSERT INTO heb_vpl VALUES ("JS8_5","007_8_5","JOS","8","5","5","ואני וכל העם אשר אתי נקרב אל העיר והיה כי יצאו לקראתנו כאשר בראשנה ונסנו לפניהם׃ ");
INSERT INTO heb_vpl VALUES ("JS8_6","007_8_6","JOS","8","6","6","ויצאו אחרינו עד התיקנו אותם מן העיר כי יאמרו נסים לפנינו כאשר בראשנה ונסנו לפניהם׃ ");
INSERT INTO heb_vpl VALUES ("JS8_7","007_8_7","JOS","8","7","7","ואתם תקמו מהאורב והורשתם את העיר ונתנה יהוה אלהיכם בידכם׃ ");
INSERT INTO heb_vpl VALUES ("JS8_8","007_8_8","JOS","8","8","8","והיה כתפשכם את העיר תציתו את העיר באש כדבר יהוה תעשו ראו צויתי אתכם׃ ");
INSERT INTO heb_vpl VALUES ("JS8_9","007_8_9","JOS","8","9","9","וישלחם יהושע וילכו אל המארב וישבו בין בית אל ובין העי מים לעי וילן יהושע בלילה ההוא בתוך העם׃ ");
INSERT INTO heb_vpl VALUES ("JS8_10","007_8_10","JOS","8","10","10","וישכם יהושע בבקר ויפקד את העם ויעל הוא וזקני ישראל לפני העם העי׃ ");
INSERT INTO heb_vpl VALUES ("JS8_11","007_8_11","JOS","8","11","11","וכל העם המלחמה אשר אתו עלו ויגשו ויבאו נגד העיר ויחנו מצפון לעי והגי בינו ובין העי׃ ");
INSERT INTO heb_vpl VALUES ("JS8_12","007_8_12","JOS","8","12","12","ויקח כחמשת אלפים איש וישם אותם ארב בין בית אל ובין העי מים לעיר׃ ");
INSERT INTO heb_vpl VALUES ("JS8_13","007_8_13","JOS","8","13","13","וישימו העם את כל המחנה אשר מצפון לעיר ואת עקבו מים לעיר וילך יהושע בלילה ההוא בתוך העמק׃ ");
INSERT INTO heb_vpl VALUES ("JS8_14","007_8_14","JOS","8","14","14","ויהי כראות מלך העי וימהרו וישכימו ויצאו אנשי העיר לקראת ישראל למלחמה הוא וכל עמו למועד לפני הערבה והוא לא ידע כי ארב לו מאחרי העיר׃ ");
INSERT INTO heb_vpl VALUES ("JS8_15","007_8_15","JOS","8","15","15","וינגעו יהושע וכל ישראל לפניהם וינסו דרך המדבר׃ ");
INSERT INTO heb_vpl VALUES ("JS8_16","007_8_16","JOS","8","16","16","ויזעקו כל העם אשר בעיר לרדף אחריהם וירדפו אחרי יהושע וינתקו מן העיר׃ ");
INSERT INTO heb_vpl VALUES ("JS8_17","007_8_17","JOS","8","17","17","ולא נשאר איש בעי ובית אל אשר לא יצאו אחרי ישראל ויעזבו את העיר פתוחה וירדפו אחרי ישראל׃ ");
INSERT INTO heb_vpl VALUES ("JS8_18","007_8_18","JOS","8","18","18","ויאמר יהוה אל יהושע נטה בכידון אשר בידך אל העי כי בידך אתננה ויט יהושע בכידון אשר בידו אל העיר׃ ");
INSERT INTO heb_vpl VALUES ("JS8_19","007_8_19","JOS","8","19","19","והאורב קם מהרה ממקומו וירוצו כנטות ידו ויבאו העיר וילכדוה וימהרו ויציתו את העיר באש׃ ");
INSERT INTO heb_vpl VALUES ("JS8_20","007_8_20","JOS","8","20","20","ויפנו אנשי העי אחריהם ויראו והנה עלה עשן העיר השמימה ולא היה בהם ידים לנוס הנה והנה והעם הנס המדבר נהפך אל הרודף׃ ");
INSERT INTO heb_vpl VALUES ("JS8_21","007_8_21","JOS","8","21","21","ויהושע וכל ישראל ראו כי לכד הארב את העיר וכי עלה עשן העיר וישבו ויכו את אנשי העי׃ ");
INSERT INTO heb_vpl VALUES ("JS8_22","007_8_22","JOS","8","22","22","ואלה יצאו מן העיר לקראתם ויהיו לישראל בתוך אלה מזה ואלה מזה ויכו אותם עד בלתי השאיר לו שריד ופליט׃ ");
INSERT INTO heb_vpl VALUES ("JS8_23","007_8_23","JOS","8","23","23","ואת מלך העי תפשו חי ויקרבו אתו אל יהושע׃ ");
INSERT INTO heb_vpl VALUES ("JS8_24","007_8_24","JOS","8","24","24","ויהי ככלות ישראל להרג את כל ישבי העי בשדה במדבר אשר רדפום בו ויפלו כלם לפי חרב עד תמם וישבו כל ישראל העי ויכו אתה לפי חרב׃ ");
INSERT INTO heb_vpl VALUES ("JS8_25","007_8_25","JOS","8","25","25","ויהי כל הנפלים ביום ההוא מאיש ועד אשה שנים עשר אלף כל אנשי העי׃ ");
INSERT INTO heb_vpl VALUES ("JS8_26","007_8_26","JOS","8","26","26","ויהושע לא השיב ידו אשר נטה בכידון עד אשר החרים את כל ישבי העי׃ ");
INSERT INTO heb_vpl VALUES ("JS8_27","007_8_27","JOS","8","27","27","רק הבהמה ושלל העיר ההיא בזזו להם ישראל כדבר יהוה אשר צוה את יהושע׃ ");
INSERT INTO heb_vpl VALUES ("JS8_28","007_8_28","JOS","8","28","28","וישרף יהושע את העי וישימה תל עולם שממה עד היום הזה׃ ");
INSERT INTO heb_vpl VALUES ("JS8_29","007_8_29","JOS","8","29","29","ואת מלך העי תלה על העץ עד עת הערב וכבוא השמש צוה יהושע וירידו את נבלתו מן העץ וישליכו אותה אל פתח שער העיר ויקימו עליו גל אבנים גדול עד היום הזה׃ ");
INSERT INTO heb_vpl VALUES ("JS8_30","007_8_30","JOS","8","30","30","אז יבנה יהושע מזבח ליהוה אלהי ישראל בהר עיבל׃ ");
INSERT INTO heb_vpl VALUES ("JS8_31","007_8_31","JOS","8","31","31","כאשר צוה משה עבד יהוה את בני ישראל ככתוב בספר תורת משה מזבח אבנים שלמות אשר לא הניף עליהן ברזל ויעלו עליו עלות ליהוה ויזבחו שלמים׃ ");
INSERT INTO heb_vpl VALUES ("JS8_32","007_8_32","JOS","8","32","32","ויכתב שם על האבנים את משנה תורת משה אשר כתב לפני בני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("JS8_33","007_8_33","JOS","8","33","33","וכל ישראל וזקניו ושטרים ושפטיו עמדים מזה ומזה לארון נגד הכהנים הלוים נשאי ארון ברית יהוה כגר כאזרח חציו אל מול הר גרזים והחציו אל מול הר עיבל כאשר צוה משה עבד יהוה לברך את העם ישראל בראשנה׃ ");
INSERT INTO heb_vpl VALUES ("JS8_34","007_8_34","JOS","8","34","34","ואחרי כן קרא את כל דברי התורה הברכה והקללה ככל הכתוב בספר התורה׃ ");
INSERT INTO heb_vpl VALUES ("JS8_35","007_8_35","JOS","8","35","35","לא היה דבר מכל אשר צוה משה אשר לא קרא יהושע נגד כל קהל ישראל והנשים והטף והגר ההלך בקרבם׃ ");
INSERT INTO heb_vpl VALUES ("JS9_1","007_9_1","JOS","9","1","1","ויהי כשמע כל המלכים אשר בעבר הירדן בהר ובשפלה ובכל חוף הים הגדול אל מול הלבנון החתי והאמרי הכנעני הפרזי החוי והיבוסי׃ ");
INSERT INTO heb_vpl VALUES ("JS9_2","007_9_2","JOS","9","2","2","ויתקבצו יחדו להלחם עם יהושע ועם ישראל פה אחד׃ ");
INSERT INTO heb_vpl VALUES ("JS9_3","007_9_3","JOS","9","3","3","וישבי גבעון שמעו את אשר עשה יהושע ליריחו ולעי׃ ");
INSERT INTO heb_vpl VALUES ("JS9_4","007_9_4","JOS","9","4","4","ויעשו גם המה בערמה וילכו ויצטירו ויקחו שקים בלים לחמוריהם ונאדות יין בלים ומבקעים ומצררים׃ ");
INSERT INTO heb_vpl VALUES ("JS9_5","007_9_5","JOS","9","5","5","ונעלות בלות ומטלאות ברגליהם ושלמות בלות עליהם וכל לחם צידם יבש היה נקדים׃ ");
INSERT INTO heb_vpl VALUES ("JS9_6","007_9_6","JOS","9","6","6","וילכו אל יהושע אל המחנה הגלגל ויאמרו אליו ואל איש ישראל מארץ רחוקה באנו ועתה כרתו לנו ברית׃ ");
INSERT INTO heb_vpl VALUES ("JS9_7","007_9_7","JOS","9","7","7","ויאמרו איש ישראל אל החוי אולי בקרבי אתה יושב ואיך אכרות לך ברית׃ ");
INSERT INTO heb_vpl VALUES ("JS9_8","007_9_8","JOS","9","8","8","ויאמרו אל יהושע עבדיך אנחנו ויאמר אלהם יהושע מי אתם ומאין תבאו׃ ");
INSERT INTO heb_vpl VALUES ("JS9_9","007_9_9","JOS","9","9","9","ויאמרו אליו מארץ רחוקה מאד באו עבדיך לשם יהוה אלהיך כי שמענו שמעו ואת כל אשר עשה במצרים׃ ");
INSERT INTO heb_vpl VALUES ("JS9_10","007_9_10","JOS","9","10","10","ואת כל אשר עשה לשני מלכי האמרי אשר בעבר הירדן לסיחון מלך חשבון ולעוג מלך הבשן אשר בעשתרות׃ ");
INSERT INTO heb_vpl VALUES ("JS9_11","007_9_11","JOS","9","11","11","ויאמרו אלינו זקינינו וכל ישבי ארצנו לאמר קחו בידכם צידה לדרך ולכו לקראתם ואמרתם אליהם עבדיכם אנחנו ועתה כרתו לנו ברית׃ ");
INSERT INTO heb_vpl VALUES ("JS9_12","007_9_12","JOS","9","12","12","זה לחמנו חם הצטידנו אתו מבתינו ביום צאתנו ללכת אליכם ועתה הנה יבש והיה נקדים׃ ");
INSERT INTO heb_vpl VALUES ("JS9_13","007_9_13","JOS","9","13","13","ואלה נאדות היין אשר מלאנו חדשים והנה התבקעו ואלה שלמותינו ונעלינו בלו מרב הדרך מאד׃ ");
INSERT INTO heb_vpl VALUES ("JS9_14","007_9_14","JOS","9","14","14","ויקחו האנשים מצידם ואת פי יהוה לא שאלו׃ ");
INSERT INTO heb_vpl VALUES ("JS9_15","007_9_15","JOS","9","15","15","ויעש להם יהושע שלום ויכרת להם ברית לחיותם וישבעו להם נשיאי העדה׃ ");
INSERT INTO heb_vpl VALUES ("JS9_16","007_9_16","JOS","9","16","16","ויהי מקצה שלשת ימים אחרי אשר כרתו להם ברית וישמעו כי קרבים הם אליו ובקרבו הם ישבים׃ ");
INSERT INTO heb_vpl VALUES ("JS9_17","007_9_17","JOS","9","17","17","ויסעו בני ישראל ויבאו אל עריהם ביום השלישי ועריהם גבעון והכפירה ובארות וקרית יערים׃ ");
INSERT INTO heb_vpl VALUES ("JS9_18","007_9_18","JOS","9","18","18","ולא הכום בני ישראל כי נשבעו להם נשיאי העדה ביהוה אלהי ישראל וילנו כל העדה על הנשיאים׃ ");
INSERT INTO heb_vpl VALUES ("JS9_19","007_9_19","JOS","9","19","19","ויאמרו כל הנשיאים אל כל העדה אנחנו נשבענו להם ביהוה אלהי ישראל ועתה לא נוכל לנגע בהם׃ ");
INSERT INTO heb_vpl VALUES ("JS9_20","007_9_20","JOS","9","20","20","זאת נעשה להם והחיה אותם ולא יהיה עלינו קצף על השבועה אשר נשבענו להם׃ ");
INSERT INTO heb_vpl VALUES ("JS9_21","007_9_21","JOS","9","21","21","ויאמרו אליהם הנשיאים יחיו ויהיו חטבי עצים ושאבי מים לכל העדה כאשר דברו להם הנשיאים׃ ");
INSERT INTO heb_vpl VALUES ("JS9_22","007_9_22","JOS","9","22","22","ויקרא להם יהושע וידבר אליהם לאמר למה רמיתם אתנו לאמר רחוקים אנחנו מכם מאד ואתם בקרבנו ישבים׃ ");
INSERT INTO heb_vpl VALUES ("JS9_23","007_9_23","JOS","9","23","23","ועתה ארורים אתם ולא יכרת מכם עבד וחטבי עצים ושאבי מים לבית אלהי׃ ");
INSERT INTO heb_vpl VALUES ("JS9_24","007_9_24","JOS","9","24","24","ויענו את יהושע ויאמרו כי הגד הגד לעבדיך את אשר צוה יהוה אלהיך את משה עבדו לתת לכם את כל הארץ ולהשמיד את כל ישבי הארץ מפניכם ונירא מאד לנפשתינו מפניכם ונעשה את הדבר הזה׃ ");
INSERT INTO heb_vpl VALUES ("JS9_25","007_9_25","JOS","9","25","25","ועתה הננו בידך כטוב וכישר בעיניך לעשות לנו עשה׃ ");
INSERT INTO heb_vpl VALUES ("JS9_26","007_9_26","JOS","9","26","26","ויעש להם כן ויצל אותם מיד בני ישראל ולא הרגום׃ ");
INSERT INTO heb_vpl VALUES ("JS9_27","007_9_27","JOS","9","27","27","ויתנם יהושע ביום ההוא חטבי עצים ושאבי מים לעדה ולמזבח יהוה עד היום הזה אל המקום אשר יבחר׃ ");
INSERT INTO heb_vpl VALUES ("JS10_1","007_10_1","JOS","10","1","1","ויהי כשמע אדני צדק מלך ירושלם כי לכד יהושע את העי ויחרימה כאשר עשה ליריחו ולמלכה כן עשה לעי ולמלכה וכי השלימו ישבי גבעון את ישראל ויהיו בקרבם׃ ");
INSERT INTO heb_vpl VALUES ("JS10_2","007_10_2","JOS","10","2","2","וייראו מאד כי עיר גדולה גבעון כאחת ערי הממלכה וכי היא גדולה מן העי וכל אנשיה גברים׃ ");
INSERT INTO heb_vpl VALUES ("JS10_3","007_10_3","JOS","10","3","3","וישלח אדני צדק מלך ירושלם אל הוהם מלך חברון ואל פראם מלך ירמות ואל יפיע מלך לכיש ואל דביר מלך עגלון לאמר׃ ");
INSERT INTO heb_vpl VALUES ("JS10_4","007_10_4","JOS","10","4","4","עלו אלי ועזרני ונכה את גבעון כי השלימה את יהושע ואת בני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("JS10_5","007_10_5","JOS","10","5","5","ויאספו ויעלו חמשת מלכי האמרי מלך ירושלם מלך חברון מלך ירמות מלך לכיש מלך עגלון הם וכל מחניהם ויחנו על גבעון וילחמו עליה׃ ");
INSERT INTO heb_vpl VALUES ("JS10_6","007_10_6","JOS","10","6","6","וישלחו אנשי גבעון אל יהושע אל המחנה הגלגלה לאמר אל תרף ידיך מעבדיך עלה אלינו מהרה והושיעה לנו ועזרנו כי נקבצו אלינו כל מלכי האמרי ישבי ההר׃ ");
INSERT INTO heb_vpl VALUES ("JS10_7","007_10_7","JOS","10","7","7","ויעל יהושע מן הגלגל הוא וכל עם המלחמה עמו וכל גבורי החיל׃ ");
INSERT INTO heb_vpl VALUES ("JS10_8","007_10_8","JOS","10","8","8","ויאמר יהוה אל יהושע אל תירא מהם כי בידך נתתים לא יעמד איש מהם בפניך׃ ");
INSERT INTO heb_vpl VALUES ("JS10_9","007_10_9","JOS","10","9","9","ויבא אליהם יהושע פתאם כל הלילה עלה מן הגלגל׃ ");
INSERT INTO heb_vpl VALUES ("JS10_10","007_10_10","JOS","10","10","10","ויהמם יהוה לפני ישראל ויכם מכה גדולה בגבעון וירדפם דרך מעלה בית חורן ויכם עד עזקה ועד מקדה׃ ");
INSERT INTO heb_vpl VALUES ("JS10_11","007_10_11","JOS","10","11","11","ויהי בנסם מפני ישראל הם במורד בית חורן ויהוה השליך עליהם אבנים גדלות מן השמים עד עזקה וימתו רבים אשר מתו באבני הברד מאשר הרגו בני ישראל בחרב׃ ");
INSERT INTO heb_vpl VALUES ("JS10_12","007_10_12","JOS","10","12","12","אז ידבר יהושע ליהוה ביום תת יהוה את האמרי לפני בני ישראל ויאמר לעיני ישראל שמש בגבעון דום וירח בעמק אילון׃ ");
INSERT INTO heb_vpl VALUES ("JS10_13","007_10_13","JOS","10","13","13","וידם השמש וירח עמד עד יקם גוי איביו הלא היא כתובה על ספר הישר ויעמד השמש בחצי השמים ולא אץ לבוא כיום תמים׃ ");
INSERT INTO heb_vpl VALUES ("JS10_14","007_10_14","JOS","10","14","14","ולא היה כיום ההוא לפניו ואחריו לשמע יהוה בקול איש כי יהוה נלחם לישראל׃ ");
INSERT INTO heb_vpl VALUES ("JS10_15","007_10_15","JOS","10","15","15","וישב יהושע וכל ישראל עמו אל המחנה הגלגלה׃ ");
INSERT INTO heb_vpl VALUES ("JS10_16","007_10_16","JOS","10","16","16","וינסו חמשת המלכים האלה ויחבאו במערה במקדה׃ ");
INSERT INTO heb_vpl VALUES ("JS10_17","007_10_17","JOS","10","17","17","ויגד ליהושע לאמר נמצאו חמשת המלכים נחבאים במערה במקדה׃ ");
INSERT INTO heb_vpl VALUES ("JS10_18","007_10_18","JOS","10","18","18","ויאמר יהושע גלו אבנים גדלות אל פי המערה והפקידו עליה אנשים לשמרם׃ ");
INSERT INTO heb_vpl VALUES ("JS10_19","007_10_19","JOS","10","19","19","ואתם אל תעמדו רדפו אחרי איביכם וזנבתם אותם אל תתנום לבוא אל עריהם כי נתנם יהוה אלהיכם בידכם׃ ");
INSERT INTO heb_vpl VALUES ("JS10_20","007_10_20","JOS","10","20","20","ויהי ככלות יהושע ובני ישראל להכותם מכה גדולה מאד עד תמם והשרידים שרדו מהם ויבאו אל ערי המבצר׃ ");
INSERT INTO heb_vpl VALUES ("JS10_21","007_10_21","JOS","10","21","21","וישבו כל העם אל המחנה אל יהושע מקדה בשלום לא חרץ לבני ישראל לאיש את לשנו׃ ");
INSERT INTO heb_vpl VALUES ("JS10_22","007_10_22","JOS","10","22","22","ויאמר יהושע פתחו את פי המערה והוציאו אלי את חמשת המלכים האלה מן המערה׃ ");
INSERT INTO heb_vpl VALUES ("JS10_23","007_10_23","JOS","10","23","23","ויעשו כן ויציאו אליו את חמשת המלכים האלה מן המערה את מלך ירושלם את מלך חברון את מלך ירמות את מלך לכיש את מלך עגלון׃ ");
INSERT INTO heb_vpl VALUES ("JS10_24","007_10_24","JOS","10","24","24","ויהי כהוציאם את המלכים האלה אל יהושע ויקרא יהושע אל כל איש ישראל ויאמר אל קציני אנשי המלחמה ההלכוא אתו קרבו שימו את רגליכם על צוארי המלכים האלה ויקרבו וישימו את רגליהם על צואריהם׃ ");
INSERT INTO heb_vpl VALUES ("JS10_25","007_10_25","JOS","10","25","25","ויאמר אליהם יהושע אל תיראו ואל תחתו חזקו ואמצו כי ככה יעשה יהוה לכל איביכם אשר אתם נלחמים אותם׃ ");
INSERT INTO heb_vpl VALUES ("JS10_26","007_10_26","JOS","10","26","26","ויכם יהושע אחרי כן וימיתם ויתלם על חמשה עצים ויהיו תלוים על העצים עד הערב׃ ");
INSERT INTO heb_vpl VALUES ("JS10_27","007_10_27","JOS","10","27","27","ויהי לעת בוא השמש צוה יהושע וירידום מעל העצים וישלכם אל המערה אשר נחבאו שם וישמו אבנים גדלות על פי המערה עד עצם היום הזה׃ ");
INSERT INTO heb_vpl VALUES ("JS10_28","007_10_28","JOS","10","28","28","ואת מקדה לכד יהושע ביום ההוא ויכה לפי חרב ואת מלכה החרם אותם ואת כל הנפש אשר בה לא השאיר שריד ויעש למלך מקדה כאשר עשה למלך יריחו׃ ");
INSERT INTO heb_vpl VALUES ("JS10_29","007_10_29","JOS","10","29","29","ויעבר יהושע וכל ישראל עמו ממקדה לבנה וילחם עם לבנה׃ ");
INSERT INTO heb_vpl VALUES ("JS10_30","007_10_30","JOS","10","30","30","ויתן יהוה גם אותה ביד ישראל ואת מלכה ויכה לפי חרב ואת כל הנפש אשר בה לא השאיר בה שריד ויעש למלכה כאשר עשה למלך יריחו׃ ");
INSERT INTO heb_vpl VALUES ("JS10_31","007_10_31","JOS","10","31","31","ויעבר יהושע וכל ישראל עמו מלבנה לכישה ויחן עליה וילחם בה׃ ");
INSERT INTO heb_vpl VALUES ("JS10_32","007_10_32","JOS","10","32","32","ויתן יהוה את לכיש ביד ישראל וילכדה ביום השני ויכה לפי חרב ואת כל הנפש אשר בה ככל אשר עשה ללבנה׃ ");
INSERT INTO heb_vpl VALUES ("JS10_33","007_10_33","JOS","10","33","33","אז עלה הרם מלך גזר לעזר את לכיש ויכהו יהושע ואת עמו עד בלתי השאיר לו שריד׃ ");
INSERT INTO heb_vpl VALUES ("JS10_34","007_10_34","JOS","10","34","34","ויעבר יהושע וכל ישראל עמו מלכיש עגלנה ויחנו עליה וילחמו עליה׃ ");
INSERT INTO heb_vpl VALUES ("JS10_35","007_10_35","JOS","10","35","35","וילכדוה ביום ההוא ויכוה לפי חרב ואת כל הנפש אשר בה ביום ההוא החרים ככל אשר עשה ללכיש׃ ");
INSERT INTO heb_vpl VALUES ("JS10_36","007_10_36","JOS","10","36","36","ויעל יהושע וכל ישראל עמו מעגלונה חברונה וילחמו עליה׃ ");
INSERT INTO heb_vpl VALUES ("JS10_37","007_10_37","JOS","10","37","37","וילכדוה ויכוה לפי חרב ואת מלכה ואת כל עריה ואת כל הנפש אשר בה לא השאיר שריד ככל אשר עשה לעגלון ויחרם אותה ואת כל הנפש אשר בה׃ ");
INSERT INTO heb_vpl VALUES ("JS10_38","007_10_38","JOS","10","38","38","וישב יהושע וכל ישראל עמו דברה וילחם עליה׃ ");
INSERT INTO heb_vpl VALUES ("JS10_39","007_10_39","JOS","10","39","39","וילכדה ואת מלכה ואת כל עריה ויכום לפי חרב ויחרימו את כל נפש אשר בה לא השאיר שריד כאשר עשה לחברון כן עשה לדברה ולמלכה וכאשר עשה ללבנה ולמלכה׃ ");
INSERT INTO heb_vpl VALUES ("JS10_40","007_10_40","JOS","10","40","40","ויכה יהושע את כל הארץ ההר והנגב והשפלה והאשדות ואת כל מלכיהם לא השאיר שריד ואת כל הנשמה החרים כאשר צוה יהוה אלהי ישראל׃ ");
INSERT INTO heb_vpl VALUES ("JS10_41","007_10_41","JOS","10","41","41","ויכם יהושע מקדש ברנע ועד עזה ואת כל ארץ גשן ועד גבעון׃ ");
INSERT INTO heb_vpl VALUES ("JS10_42","007_10_42","JOS","10","42","42","ואת כל המלכים האלה ואת ארצם לכד יהושע פעם אחת כי יהוה אלהי ישראל נלחם לישראל׃ ");
INSERT INTO heb_vpl VALUES ("JS10_43","007_10_43","JOS","10","43","43","וישב יהושע וכל ישראל עמו אל המחנה הגלגלה׃ ");
INSERT INTO heb_vpl VALUES ("JS11_1","007_11_1","JOS","11","1","1","ויהי כשמע יבין מלך חצור וישלח אל יובב מלך מדון ואל מלך שמרון ואל מלך אכשף׃ ");
INSERT INTO heb_vpl VALUES ("JS11_2","007_11_2","JOS","11","2","2","ואל המלכים אשר מצפון בהר ובערבה נגב כנרות ובשפלה ובנפות דור מים׃ ");
INSERT INTO heb_vpl VALUES ("JS11_3","007_11_3","JOS","11","3","3","הכנעני ממזרח ומים והאמרי והחתי והפרזי והיבוסי בהר והחוי תחת חרמון בארץ המצפה׃ ");
INSERT INTO heb_vpl VALUES ("JS11_4","007_11_4","JOS","11","4","4","ויצאו הם וכל מחניהם עמם עם רב כחול אשר על שפת הים לרב וסוס ורכב רב מאד׃ ");
INSERT INTO heb_vpl VALUES ("JS11_5","007_11_5","JOS","11","5","5","ויועדו כל המלכים האלה ויבאו ויחנו יחדו אל מי מרום להלחם עם ישראל׃ ");
INSERT INTO heb_vpl VALUES ("JS11_6","007_11_6","JOS","11","6","6","ויאמר יהוה אל יהושע אל תירא מפניהם כי מחר כעת הזאת אנכי נתן את כלם חללים לפני ישראל את סוסיהם תעקר ואת מרכבתיהם תשרף באש׃ ");
INSERT INTO heb_vpl VALUES ("JS11_7","007_11_7","JOS","11","7","7","ויבא יהושע וכל עם המלחמה עמו עליהם על מי מרום פתאם ויפלו בהם׃ ");
INSERT INTO heb_vpl VALUES ("JS11_8","007_11_8","JOS","11","8","8","ויתנם יהוה ביד ישראל ויכום וירדפום עד צידון רבה ועד משרפות מים ועד בקעת מצפה מזרחה ויכם עד בלתי השאיר להם שריד׃ ");
INSERT INTO heb_vpl VALUES ("JS11_9","007_11_9","JOS","11","9","9","ויעש להם יהושע כאשר אמר לו יהוה את סוסיהם עקר ואת מרכבתיהם שרף באש׃ ");
INSERT INTO heb_vpl VALUES ("JS11_10","007_11_10","JOS","11","10","10","וישב יהושע בעת ההיא וילכד את חצור ואת מלכה הכה בחרב כי חצור לפנים היא ראש כל הממלכות האלה׃ ");
INSERT INTO heb_vpl VALUES ("JS11_11","007_11_11","JOS","11","11","11","ויכו את כל הנפש אשר בה לפי חרב החרם לא נותר כל נשמה ואת חצור שרף באש׃ ");
INSERT INTO heb_vpl VALUES ("JS11_12","007_11_12","JOS","11","12","12","ואת כל ערי המלכים האלה ואת כל מלכיהם לכד יהושע ויכם לפי חרב החרים אותם כאשר צוה משה עבד יהוה׃ ");
INSERT INTO heb_vpl VALUES ("JS11_13","007_11_13","JOS","11","13","13","רק כל הערים העמדות על תלם לא שרפם ישראל זולתי את חצור לבדה שרף יהושע׃ ");
INSERT INTO heb_vpl VALUES ("JS11_14","007_11_14","JOS","11","14","14","וכל שלל הערים האלה והבהמה בזזו להם בני ישראל רק את כל האדם הכו לפי חרב עד השמדם אותם לא השאירו כל נשמה׃ ");
INSERT INTO heb_vpl VALUES ("JS11_15","007_11_15","JOS","11","15","15","כאשר צוה יהוה את משה עבדו כן צוה משה את יהושע וכן עשה יהושע לא הסיר דבר מכל אשר צוה יהוה את משה׃ ");
INSERT INTO heb_vpl VALUES ("JS11_16","007_11_16","JOS","11","16","16","ויקח יהושע את כל הארץ הזאת ההר ואת כל הנגב ואת כל ארץ הגשן ואת השפלה ואת הערבה ואת הר ישראל ושפלתה׃ ");
INSERT INTO heb_vpl VALUES ("JS11_17","007_11_17","JOS","11","17","17","מן ההר החלק העולה שעיר ועד בעל גד בבקעת הלבנון תחת הר חרמון ואת כל מלכיהם לכד ויכם וימיתם׃ ");
INSERT INTO heb_vpl VALUES ("JS11_18","007_11_18","JOS","11","18","18","ימים רבים עשה יהושע את כל המלכים האלה מלחמה׃ ");
INSERT INTO heb_vpl VALUES ("JS11_19","007_11_19","JOS","11","19","19","לא היתה עיר אשר השלימה אל בני ישראל בלתי החוי ישבי גבעון את הכל לקחו במלחמה׃ ");
INSERT INTO heb_vpl VALUES ("JS11_20","007_11_20","JOS","11","20","20","כי מאת יהוה היתה לחזק את לבם לקראת המלחמה את ישראל למען החרימם לבלתי היות להם תחנה כי למען השמידם כאשר צוה יהוה את משה׃ ");
INSERT INTO heb_vpl VALUES ("JS11_21","007_11_21","JOS","11","21","21","ויבא יהושע בעת ההיא ויכרת את הענקים מן ההר מן חברון מן דבר מן ענב ומכל הר יהודה ומכל הר ישראל עם עריהם החרימם יהושע׃ ");
INSERT INTO heb_vpl VALUES ("JS11_22","007_11_22","JOS","11","22","22","לא נותר ענקים בארץ בני ישראל רק בעזה בגת ובאשדוד נשארו׃ ");
INSERT INTO heb_vpl VALUES ("JS11_23","007_11_23","JOS","11","23","23","ויקח יהושע את כל הארץ ככל אשר דבר יהוה אל משה ויתנה יהושע לנחלה לישראל כמחלקתם לשבטיהם והארץ שקטה ממלחמה׃ ");
INSERT INTO heb_vpl VALUES ("JS12_1","007_12_1","JOS","12","1","1","ואלה מלכי הארץ אשר הכו בני ישראל וירשו את ארצם בעבר הירדן מזרחה השמש מנחל ארנון עד הר חרמון וכל הערבה מזרחה׃ ");
INSERT INTO heb_vpl VALUES ("JS12_2","007_12_2","JOS","12","2","2","סיחון מלך האמרי היושב בחשבון משל מערוער אשר על שפת נחל ארנון ותוך הנחל וחצי הגלעד ועד יבק הנחל גבול בני עמון׃ ");
INSERT INTO heb_vpl VALUES ("JS12_3","007_12_3","JOS","12","3","3","והערבה עד ים כנרות מזרחה ועד ים הערבה ים המלח מזרחה דרך בית הישמות ומתימן תחת אשדות הפסגה׃ ");
INSERT INTO heb_vpl VALUES ("JS12_4","007_12_4","JOS","12","4","4","וגבול עוג מלך הבשן מיתר הרפאים היושב בעשתרות ובאדרעי׃ ");
INSERT INTO heb_vpl VALUES ("JS12_5","007_12_5","JOS","12","5","5","ומשל בהר חרמון ובסלכה ובכל הבשן עד גבול הגשורי והמעכתי וחצי הגלעד גבול סיחון מלך חשבון׃ ");
INSERT INTO heb_vpl VALUES ("JS12_6","007_12_6","JOS","12","6","6","משה עבד יהוה ובני ישראל הכום ויתנה משה עבד יהוה ירשה לראובני ולגדי ולחצי שבט המנשה׃ ");
INSERT INTO heb_vpl VALUES ("JS12_7","007_12_7","JOS","12","7","7","ואלה מלכי הארץ אשר הכה יהושע ובני ישראל בעבר הירדן ימה מבעל גד בבקעת הלבנון ועד ההר החלק העלה שעירה ויתנה יהושע לשבטי ישראל ירשה כמחלקתם׃ ");
INSERT INTO heb_vpl VALUES ("JS12_8","007_12_8","JOS","12","8","8","בהר ובשפלה ובערבה ובאשדות ובמדבר ובנגב החתי האמרי והכנעני הפרזי החוי והיבוסי׃ ");
INSERT INTO heb_vpl VALUES ("JS12_9","007_12_9","JOS","12","9","9","מלך יריחו אחד מלך העי אשר מצד בית אל אחד׃ ");
INSERT INTO heb_vpl VALUES ("JS12_10","007_12_10","JOS","12","10","10","מלך ירושלם אחד מלך חברון אחד׃ ");
INSERT INTO heb_vpl VALUES ("JS12_11","007_12_11","JOS","12","11","11","מלך ירמות אחד מלך לכיש אחד׃ ");
INSERT INTO heb_vpl VALUES ("JS12_12","007_12_12","JOS","12","12","12","מלך עגלון אחד מלך גזר אחד׃ ");
INSERT INTO heb_vpl VALUES ("JS12_13","007_12_13","JOS","12","13","13","מלך דבר אחד מלך גדר אחד׃ ");
INSERT INTO heb_vpl VALUES ("JS12_14","007_12_14","JOS","12","14","14","מלך חרמה אחד מלך ערד אחד׃ ");
INSERT INTO heb_vpl VALUES ("JS12_15","007_12_15","JOS","12","15","15","מלך לבנה אחד מלך עדלם אחד׃ ");
INSERT INTO heb_vpl VALUES ("JS12_16","007_12_16","JOS","12","16","16","מלך מקדה אחד מלך בית אל אחד׃ ");
INSERT INTO heb_vpl VALUES ("JS12_17","007_12_17","JOS","12","17","17","מלך תפוח אחד מלך חפר אחד׃ ");
INSERT INTO heb_vpl VALUES ("JS12_18","007_12_18","JOS","12","18","18","מלך אפק אחד מלך לשרון אחד׃ ");
INSERT INTO heb_vpl VALUES ("JS12_19","007_12_19","JOS","12","19","19","מלך מדון אחד מלך חצור אחד׃ ");
INSERT INTO heb_vpl VALUES ("JS12_20","007_12_20","JOS","12","20","20","מלך שמרון מראון אחד מלך אכשף אחד׃ ");
INSERT INTO heb_vpl VALUES ("JS12_21","007_12_21","JOS","12","21","21","מלך תענך אחד מלך מגדו אחד׃ ");
INSERT INTO heb_vpl VALUES ("JS12_22","007_12_22","JOS","12","22","22","מלך קדש אחד מלך יקנעם לכרמל אחד׃ ");
INSERT INTO heb_vpl VALUES ("JS12_23","007_12_23","JOS","12","23","23","מלך דור לנפת דור אחד מלך גוים לגלגל אחד׃ ");
INSERT INTO heb_vpl VALUES ("JS12_24","007_12_24","JOS","12","24","24","מלך תרצה אחד כל מלכים שלשים ואחד׃ ");
INSERT INTO heb_vpl VALUES ("JS13_1","007_13_1","JOS","13","1","1","ויהושע זקן בא בימים ויאמר יהוה אליו אתה זקנתה באת בימים והארץ נשארה הרבה מאד לרשתה׃ ");
INSERT INTO heb_vpl VALUES ("JS13_2","007_13_2","JOS","13","2","2","זאת הארץ הנשארת כל גלילות הפלשתים וכל הגשורי׃ ");
INSERT INTO heb_vpl VALUES ("JS13_3","007_13_3","JOS","13","3","3","מן השיחור אשר על פני מצרים ועד גבול עקרון צפונה לכנעני תחשב חמשת סרני פלשתים העזתי והאשדודי האשקלוני הגתי והעקרוני והעוים׃ ");
INSERT INTO heb_vpl VALUES ("JS13_4","007_13_4","JOS","13","4","4","מתימן כל ארץ הכנעני ומערה אשר לצידנים עד אפקה עד גבול האמרי׃ ");
INSERT INTO heb_vpl VALUES ("JS13_5","007_13_5","JOS","13","5","5","והארץ הגבלי וכל הלבנון מזרח השמש מבעל גד תחת הר חרמון עד לבוא חמת׃ ");
INSERT INTO heb_vpl VALUES ("JS13_6","007_13_6","JOS","13","6","6","כל ישבי ההר מן הלבנון עד משרפת מים כל צידנים אנכי אורישם מפני בני ישראל רק הפלה לישראל בנחלה כאשר צויתיך׃ ");
INSERT INTO heb_vpl VALUES ("JS13_7","007_13_7","JOS","13","7","7","ועתה חלק את הארץ הזאת בנחלה לתשעת השבטים וחצי השבט המנשה׃ ");
INSERT INTO heb_vpl VALUES ("JS13_8","007_13_8","JOS","13","8","8","עמו הראובני והגדי לקחו נחלתם אשר נתן להם משה בעבר הירדן מזרחה כאשר נתן להם משה עבד יהוה׃ ");
INSERT INTO heb_vpl VALUES ("JS13_9","007_13_9","JOS","13","9","9","מערוער אשר על שפת נחל ארנון והעיר אשר בתוך הנחל וכל המישר מידבא עד דיבון׃ ");
INSERT INTO heb_vpl VALUES ("JS13_10","007_13_10","JOS","13","10","10","וכל ערי סיחון מלך האמרי אשר מלך בחשבון עד גבול בני עמון׃ ");
INSERT INTO heb_vpl VALUES ("JS13_11","007_13_11","JOS","13","11","11","והגלעד וגבול הגשורי והמעכתי וכל הר חרמון וכל הבשן עד סלכה׃ ");
INSERT INTO heb_vpl VALUES ("JS13_12","007_13_12","JOS","13","12","12","כל ממלכות עוג בבשן אשר מלך בעשתרות ובאדרעי הוא נשאר מיתר הרפאים ויכם משה וירשם׃ ");
INSERT INTO heb_vpl VALUES ("JS13_13","007_13_13","JOS","13","13","13","ולא הורישו בני ישראל את הגשורי ואת המעכתי וישב גשור ומעכת בקרב ישראל עד היום הזה׃ ");
INSERT INTO heb_vpl VALUES ("JS13_14","007_13_14","JOS","13","14","14","רק לשבט הלוי לא נתן נחלה אשי יהוה אלהי ישראל הוא נחלתו כאשר דבר לו׃ ");
INSERT INTO heb_vpl VALUES ("JS13_15","007_13_15","JOS","13","15","15","ויתן משה למטה בני ראובן למשפחתם׃ ");
INSERT INTO heb_vpl VALUES ("JS13_16","007_13_16","JOS","13","16","16","ויהי להם הגבול מערוער אשר על שפת נחל ארנון והעיר אשר בתוך הנחל וכל המישר על מידבא׃ ");
INSERT INTO heb_vpl VALUES ("JS13_17","007_13_17","JOS","13","17","17","חשבון וכל עריה אשר במישר דיבון ובמות בעל ובית בעל מעון׃ ");
INSERT INTO heb_vpl VALUES ("JS13_18","007_13_18","JOS","13","18","18","ויהצה וקדמת ומפעת׃ ");
INSERT INTO heb_vpl VALUES ("JS13_19","007_13_19","JOS","13","19","19","וקריתים ושבמה וצרת השחר בהר העמק׃ ");
INSERT INTO heb_vpl VALUES ("JS13_20","007_13_20","JOS","13","20","20","ובית פעור ואשדות הפסגה ובית הישמות׃ ");
INSERT INTO heb_vpl VALUES ("JS13_21","007_13_21","JOS","13","21","21","וכל ערי המישר וכל ממלכות סיחון מלך האמרי אשר מלך בחשבון אשר הכה משה אתו ואת נשיאי מדין את אוי ואת רקם ואת צור ואת חור ואת רבע נסיכי סיחון ישבי הארץ׃ ");
INSERT INTO heb_vpl VALUES ("JS13_22","007_13_22","JOS","13","22","22","ואת בלעם בן בעור הקוסם הרגו בני ישראל בחרב אל חלליהם׃ ");
INSERT INTO heb_vpl VALUES ("JS13_23","007_13_23","JOS","13","23","23","ויהי גבול בני ראובן הירדן וגבול זאת נחלת בני ראובן למשפחתם הערים וחצריהן׃ ");
INSERT INTO heb_vpl VALUES ("JS13_24","007_13_24","JOS","13","24","24","ויתן משה למטה גד לבני גד למשפחתם׃ ");
INSERT INTO heb_vpl VALUES ("JS13_25","007_13_25","JOS","13","25","25","ויהי להם הגבול יעזר וכל ערי הגלעד וחצי ארץ בני עמון עד ערוער אשר על פני רבה׃ ");
INSERT INTO heb_vpl VALUES ("JS13_26","007_13_26","JOS","13","26","26","ומחשבון עד רמת המצפה ובטנים וממחנים עד גבול לדבר׃ ");
INSERT INTO heb_vpl VALUES ("JS13_27","007_13_27","JOS","13","27","27","ובעמק בית הרם ובית נמרה וסכות וצפון יתר ממלכות סיחון מלך חשבון הירדן וגבל עד קצה ים כנרת עבר הירדן מזרחה׃ ");
INSERT INTO heb_vpl VALUES ("JS13_28","007_13_28","JOS","13","28","28","זאת נחלת בני גד למשפחתם הערים וחצריהם׃ ");
INSERT INTO heb_vpl VALUES ("JS13_29","007_13_29","JOS","13","29","29","ויתן משה לחצי שבט מנשה ויהי לחצי מטה בני מנשה למשפחותם׃ ");
INSERT INTO heb_vpl VALUES ("JS13_30","007_13_30","JOS","13","30","30","ויהי גבולם ממחנים כל הבשן כל ממלכות עוג מלך הבשן וכל חות יאיר אשר בבשן ששים עיר׃ ");
INSERT INTO heb_vpl VALUES ("JS13_31","007_13_31","JOS","13","31","31","וחצי הגלעד ועשתרות ואדרעי ערי ממלכות עוג בבשן לבני מכיר בן מנשה לחצי בני מכיר למשפחותם׃ ");
INSERT INTO heb_vpl VALUES ("JS13_32","007_13_32","JOS","13","32","32","אלה אשר נחל משה בערבות מואב מעבר לירדן יריחו מזרחה׃ ");
INSERT INTO heb_vpl VALUES ("JS13_33","007_13_33","JOS","13","33","33","ולשבט הלוי לא נתן משה נחלה יהוה אלהי ישראל הוא נחלתם כאשר דבר להם׃ ");
INSERT INTO heb_vpl VALUES ("JS14_1","007_14_1","JOS","14","1","1","ואלה אשר נחלו בני ישראל בארץ כנען אשר נחלו אותם אלעזר הכהן ויהושע בן נון וראשי אבות המטות לבני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("JS14_2","007_14_2","JOS","14","2","2","בגורל נחלתם כאשר צוה יהוה ביד משה לתשעת המטות וחצי המטה׃ ");
INSERT INTO heb_vpl VALUES ("JS14_3","007_14_3","JOS","14","3","3","כי נתן משה נחלת שני המטות וחצי המטה מעבר לירדן וללוים לא נתן נחלה בתוכם׃ ");
INSERT INTO heb_vpl VALUES ("JS14_4","007_14_4","JOS","14","4","4","כי היו בני יוסף שני מטות מנשה ואפרים ולא נתנו חלק ללוים בארץ כי אם ערים לשבת ומגרשיהם למקניהם ולקנינם׃ ");
INSERT INTO heb_vpl VALUES ("JS14_5","007_14_5","JOS","14","5","5","כאשר צוה יהוה את משה כן עשו בני ישראל ויחלקו את הארץ׃ ");
INSERT INTO heb_vpl VALUES ("JS14_6","007_14_6","JOS","14","6","6","ויגשו בני יהודה אל יהושע בגלגל ויאמר אליו כלב בן יפנה הקנזי אתה ידעת את הדבר אשר דבר יהוה אל משה איש האלהים על אדותי ועל אדותיך בקדש ברנע׃ ");
INSERT INTO heb_vpl VALUES ("JS14_7","007_14_7","JOS","14","7","7","בן ארבעים שנה אנכי בשלח משה עבד יהוה אתי מקדש ברנע לרגל את הארץ ואשב אתו דבר כאשר עם לבבי׃ ");
INSERT INTO heb_vpl VALUES ("JS14_8","007_14_8","JOS","14","8","8","ואחי אשר עלו עמי המסיו את לב העם ואנכי מלאתי אחרי יהוה אלהי׃ ");
INSERT INTO heb_vpl VALUES ("JS14_9","007_14_9","JOS","14","9","9","וישבע משה ביום ההוא לאמר אם לא הארץ אשר דרכה רגלך בה לך תהיה לנחלה ולבניך עד עולם כי מלאת אחרי יהוה אלהי׃ ");
INSERT INTO heb_vpl VALUES ("JS14_10","007_14_10","JOS","14","10","10","ועתה הנה החיה יהוה אותי כאשר דבר זה ארבעים וחמש שנה מאז דבר יהוה את הדבר הזה אל משה אשר הלך ישראל במדבר ועתה הנה אנכי היום בן חמש ושמונים שנה׃ ");
INSERT INTO heb_vpl VALUES ("JS14_11","007_14_11","JOS","14","11","11","עודני היום חזק כאשר ביום שלח אותי משה ככחי אז וככחי עתה למלחמה ולצאת ולבוא׃ ");
INSERT INTO heb_vpl VALUES ("JS14_12","007_14_12","JOS","14","12","12","ועתה תנה לי את ההר הזה אשר דבר יהוה ביום ההוא כי אתה שמעת ביום ההוא כי ענקים שם וערים גדלות בצרות אולי יהוה אותי והורשתים כאשר דבר יהוה׃ ");
INSERT INTO heb_vpl VALUES ("JS14_13","007_14_13","JOS","14","13","13","ויברכהו יהושע ויתן את חברון לכלב בן יפנה לנחלה׃ ");
INSERT INTO heb_vpl VALUES ("JS14_14","007_14_14","JOS","14","14","14","על כן היתה חברון לכלב בן יפנה הקנזי לנחלה עד היום הזה יען אשר מלא אחרי יהוה אלהי ישראל׃ ");
INSERT INTO heb_vpl VALUES ("JS14_15","007_14_15","JOS","14","15","15","ושם חברון לפנים קרית ארבע האדם הגדול בענקים הוא והארץ שקטה ממלחמה׃ ");
INSERT INTO heb_vpl VALUES ("JS15_1","007_15_1","JOS","15","1","1","ויהי הגורל למטה בני יהודה למשפחתם אל גבול אדום מדבר צן נגבה מקצה תימן׃ ");
INSERT INTO heb_vpl VALUES ("JS15_2","007_15_2","JOS","15","2","2","ויהי להם גבול נגב מקצה ים המלח מן הלשן הפנה נגבה׃ ");
INSERT INTO heb_vpl VALUES ("JS15_3","007_15_3","JOS","15","3","3","ויצא אל מנגב למעלה עקרבים ועבר צנה ועלה מנגב לקדש ברנע ועבר חצרון ועלה אדרה ונסב הקרקעה׃ ");
INSERT INTO heb_vpl VALUES ("JS15_4","007_15_4","JOS","15","4","4","ועבר עצמונה ויצא נחל מצרים והיה תצאות הגבול ימה זה יהיה לכם גבול נגב׃ ");
INSERT INTO heb_vpl VALUES ("JS15_5","007_15_5","JOS","15","5","5","וגבול קדמה ים המלח עד קצה הירדן וגבול לפאת צפונה מלשון הים מקצה הירדן׃ ");
INSERT INTO heb_vpl VALUES ("JS15_6","007_15_6","JOS","15","6","6","ועלה הגבול בית חגלה ועבר מצפון לבית הערבה ועלה הגבול אבן בהן בן ראובן׃ ");
INSERT INTO heb_vpl VALUES ("JS15_7","007_15_7","JOS","15","7","7","ועלה הגבול דברה מעמק עכור וצפונה פנה אל הגלגל אשר נכח למעלה אדמים אשר מנגב לנחל ועבר הגבול אל מי עין שמש והיו תצאתיו אל עין רגל׃ ");
INSERT INTO heb_vpl VALUES ("JS15_8","007_15_8","JOS","15","8","8","ועלה הגבול גי בן הנם אל כתף היבוסי מנגב היא ירושלם ועלה הגבול אל ראש ההר אשר על פני גי הנם ימה אשר בקצה עמק רפאים צפנה׃ ");
INSERT INTO heb_vpl VALUES ("JS15_9","007_15_9","JOS","15","9","9","ותאר הגבול מראש ההר אל מעין מי נפתוח ויצא אל ערי הר עפרון ותאר הגבול בעלה היא קרית יערים׃ ");
INSERT INTO heb_vpl VALUES ("JS15_10","007_15_10","JOS","15","10","10","ונסב הגבול מבעלה ימה אל הר שעיר ועבר אל כתף הר יערים מצפונה היא כסלון וירד בית שמש ועבר תמנה׃ ");
INSERT INTO heb_vpl VALUES ("JS15_11","007_15_11","JOS","15","11","11","ויצא הגבול אל כתף עקרון צפונה ותאר הגבול שכרונה ועבר הר הבעלה ויצא יבנאל והיו תצאות הגבול ימה׃ ");
INSERT INTO heb_vpl VALUES ("JS15_12","007_15_12","JOS","15","12","12","וגבול ים הימה הגדול וגבול זה גבול בני יהודה סביב למשפחתם׃ ");
INSERT INTO heb_vpl VALUES ("JS15_13","007_15_13","JOS","15","13","13","ולכלב בן יפנה נתן חלק בתוך בני יהודה אל פי יהוה ליהושע את קרית ארבע אבי הענק היא חברון׃ ");
INSERT INTO heb_vpl VALUES ("JS15_14","007_15_14","JOS","15","14","14","וירש משם כלב את שלושה בני הענק את ששי ואת אחימן ואת תלמי ילידי הענק׃ ");
INSERT INTO heb_vpl VALUES ("JS15_15","007_15_15","JOS","15","15","15","ויעל משם אל ישבי דבר ושם דבר לפנים קרית ספר׃ ");
INSERT INTO heb_vpl VALUES ("JS15_16","007_15_16","JOS","15","16","16","ויאמר כלב אשר יכה את קרית ספר ולכדה ונתתי לו את עכסה בתי לאשה׃ ");
INSERT INTO heb_vpl VALUES ("JS15_17","007_15_17","JOS","15","17","17","וילכדה עתניאל בן קנז אחי כלב ויתן לו את עכסה בתו לאשה׃ ");
INSERT INTO heb_vpl VALUES ("JS15_18","007_15_18","JOS","15","18","18","ויהי בבואה ותסיתהו לשאול מאת אביה שדה ותצנח מעל החמור ויאמר לה כלב מה לך׃ ");
INSERT INTO heb_vpl VALUES ("JS15_19","007_15_19","JOS","15","19","19","ותאמר תנה לי ברכה כי ארץ הנגב נתתני ונתתה לי גלת מים ויתן לה את גלת עליות ואת גלת תחתיות׃ ");
INSERT INTO heb_vpl VALUES ("JS15_20","007_15_20","JOS","15","20","20","זאת נחלת מטה בני יהודה למשפחתם׃ ");
INSERT INTO heb_vpl VALUES ("JS15_21","007_15_21","JOS","15","21","21","ויהיו הערים מקצה למטה בני יהודה אל גבול אדום בנגבה קבצאל ועדר ויגור׃ ");
INSERT INTO heb_vpl VALUES ("JS15_22","007_15_22","JOS","15","22","22","וקינה ודימונה ועדעדה׃ ");
INSERT INTO heb_vpl VALUES ("JS15_23","007_15_23","JOS","15","23","23","וקדש וחצור ויתנן׃ ");
INSERT INTO heb_vpl VALUES ("JS15_24","007_15_24","JOS","15","24","24","זיף וטלם ובעלות׃ ");
INSERT INTO heb_vpl VALUES ("JS15_25","007_15_25","JOS","15","25","25","וחצור חדתה וקריות חצרון היא חצור׃ ");
INSERT INTO heb_vpl VALUES ("JS15_26","007_15_26","JOS","15","26","26","אמם ושמע ומולדה׃ ");
INSERT INTO heb_vpl VALUES ("JS15_27","007_15_27","JOS","15","27","27","וחצר גדה וחשמון ובית פלט׃ ");
INSERT INTO heb_vpl VALUES ("JS15_28","007_15_28","JOS","15","28","28","וחצר שועל ובאר שבע ובזיותיה׃ ");
INSERT INTO heb_vpl VALUES ("JS15_29","007_15_29","JOS","15","29","29","בעלה ועיים ועצם׃ ");
INSERT INTO heb_vpl VALUES ("JS15_30","007_15_30","JOS","15","30","30","ואלתולד וכסיל וחרמה׃ ");
INSERT INTO heb_vpl VALUES ("JS15_31","007_15_31","JOS","15","31","31","וצקלג ומדמנה וסנסנה׃ ");
INSERT INTO heb_vpl VALUES ("JS15_32","007_15_32","JOS","15","32","32","ולבאות ושלחים ועין ורמון כל ערים עשרים ותשע וחצריהן׃ ");
INSERT INTO heb_vpl VALUES ("JS15_33","007_15_33","JOS","15","33","33","בשפלה אשתאול וצרעה ואשנה׃ ");
INSERT INTO heb_vpl VALUES ("JS15_34","007_15_34","JOS","15","34","34","וזנוח ועין גנים תפוח והעינם׃ ");
INSERT INTO heb_vpl VALUES ("JS15_35","007_15_35","JOS","15","35","35","ירמות ועדלם שוכה ועזקה׃ ");
INSERT INTO heb_vpl VALUES ("JS15_36","007_15_36","JOS","15","36","36","ושערים ועדיתים והגדרה וגדרתים ערים ארבע עשרה וחצריהן׃ ");
INSERT INTO heb_vpl VALUES ("JS15_37","007_15_37","JOS","15","37","37","צנן וחדשה ומגדל גד׃ ");
INSERT INTO heb_vpl VALUES ("JS15_38","007_15_38","JOS","15","38","38","ודלען והמצפה ויקתאל׃ ");
INSERT INTO heb_vpl VALUES ("JS15_39","007_15_39","JOS","15","39","39","לכיש ובצקת ועגלון׃ ");
INSERT INTO heb_vpl VALUES ("JS15_40","007_15_40","JOS","15","40","40","וכבון ולחמס וכתליש׃ ");
INSERT INTO heb_vpl VALUES ("JS15_41","007_15_41","JOS","15","41","41","וגדרות בית דגון ונעמה ומקדה ערים שש עשרה וחצריהן׃ ");
INSERT INTO heb_vpl VALUES ("JS15_42","007_15_42","JOS","15","42","42","לבנה ועתר ועשן׃ ");
INSERT INTO heb_vpl VALUES ("JS15_43","007_15_43","JOS","15","43","43","ויפתח ואשנה ונציב׃ ");
INSERT INTO heb_vpl VALUES ("JS15_44","007_15_44","JOS","15","44","44","וקעילה ואכזיב ומראשה ערים תשע וחצריהן׃ ");
INSERT INTO heb_vpl VALUES ("JS15_45","007_15_45","JOS","15","45","45","עקרון ובנתיה וחצריה׃ ");
INSERT INTO heb_vpl VALUES ("JS15_46","007_15_46","JOS","15","46","46","מעקרון וימה כל אשר על יד אשדוד וחצריהן׃ ");
INSERT INTO heb_vpl VALUES ("JS15_47","007_15_47","JOS","15","47","47","אשדוד בנותיה וחצריה עזה בנותיה וחצריה עד נחל מצרים והים הגבול וגבול׃ ");
INSERT INTO heb_vpl VALUES ("JS15_48","007_15_48","JOS","15","48","48","ובהר שמיר ויתיר ושוכה׃ ");
INSERT INTO heb_vpl VALUES ("JS15_49","007_15_49","JOS","15","49","49","ודנה וקרית סנה היא דבר׃ ");
INSERT INTO heb_vpl VALUES ("JS15_50","007_15_50","JOS","15","50","50","וענב ואשתמה וענים׃ ");
INSERT INTO heb_vpl VALUES ("JS15_51","007_15_51","JOS","15","51","51","וגשן וחלן וגלה ערים אחת עשרה וחצריהן׃ ");
INSERT INTO heb_vpl VALUES ("JS15_52","007_15_52","JOS","15","52","52","ארב ורומה ואשען׃ ");
INSERT INTO heb_vpl VALUES ("JS15_53","007_15_53","JOS","15","53","53","וינים ובית תפוח ואפקה׃ ");
INSERT INTO heb_vpl VALUES ("JS15_54","007_15_54","JOS","15","54","54","וחמטה וקרית ארבע היא חברון וציער ערים תשע וחצריהן׃ ");
INSERT INTO heb_vpl VALUES ("JS15_55","007_15_55","JOS","15","55","55","מעון כרמל וזיף ויוטה׃ ");
INSERT INTO heb_vpl VALUES ("JS15_56","007_15_56","JOS","15","56","56","ויזרעאל ויקדעם וזנוח׃ ");
INSERT INTO heb_vpl VALUES ("JS15_57","007_15_57","JOS","15","57","57","הקין גבעה ותמנה ערים עשר וחצריהן׃ ");
INSERT INTO heb_vpl VALUES ("JS15_58","007_15_58","JOS","15","58","58","חלחול בית צור וגדור׃ ");
INSERT INTO heb_vpl VALUES ("JS15_59","007_15_59","JOS","15","59","59","ומערת ובית ענות ואלתקן ערים שש וחצריהן׃ ");
INSERT INTO heb_vpl VALUES ("JS15_60","007_15_60","JOS","15","60","60","קרית בעל היא קרית יערים והרבה ערים שתים וחצריהן׃ ");
INSERT INTO heb_vpl VALUES ("JS15_61","007_15_61","JOS","15","61","61","במדבר בית הערבה מדין וסככה׃ ");
INSERT INTO heb_vpl VALUES ("JS15_62","007_15_62","JOS","15","62","62","והנבשן ועיר המלח ועין גדי ערים שש וחצריהן׃ ");
INSERT INTO heb_vpl VALUES ("JS15_63","007_15_63","JOS","15","63","63","ואת היבוסי יושבי ירושלם לא יוכלו בני יהודה להורישם וישב היבוסי את בני יהודה בירושלם עד היום הזה׃ ");
INSERT INTO heb_vpl VALUES ("JS16_1","007_16_1","JOS","16","1","1","ויצא הגורל לבני יוסף מירדן יריחו למי יריחו מזרחה המדבר עלה מיריחו בהר בית אל׃ ");
INSERT INTO heb_vpl VALUES ("JS16_2","007_16_2","JOS","16","2","2","ויצא מבית אל לוזה ועבר אל גבול הארכי עטרות׃ ");
INSERT INTO heb_vpl VALUES ("JS16_3","007_16_3","JOS","16","3","3","וירד ימה אל גבול היפלטי עד גבול בית חורן תחתון ועד גזר והיו תצאתו ימה׃ ");
INSERT INTO heb_vpl VALUES ("JS16_4","007_16_4","JOS","16","4","4","וינחלו בני יוסף מנשה ואפרים׃ ");
INSERT INTO heb_vpl VALUES ("JS16_5","007_16_5","JOS","16","5","5","ויהי גבול בני אפרים למשפחתם ויהי גבול נחלתם מזרחה עטרות אדר עד בית חורן עליון׃ ");
INSERT INTO heb_vpl VALUES ("JS16_6","007_16_6","JOS","16","6","6","ויצא הגבול הימה המכמתת מצפון ונסב הגבול מזרחה תאנת שלה ועבר אותו ממזרח ינוחה׃ ");
INSERT INTO heb_vpl VALUES ("JS16_7","007_16_7","JOS","16","7","7","וירד מינוחה עטרות ונערתה ופגע ביריחו ויצא הירדן׃ ");
INSERT INTO heb_vpl VALUES ("JS16_8","007_16_8","JOS","16","8","8","מתפוח ילך הגבול ימה נחל קנה והיו תצאתיו הימה זאת נחלת מטה בני אפרים למשפחתם׃ ");
INSERT INTO heb_vpl VALUES ("JS16_9","007_16_9","JOS","16","9","9","והערים המבדלות לבני אפרים בתוך נחלת בני מנשה כל הערים וחצריהן׃ ");
INSERT INTO heb_vpl VALUES ("JS16_10","007_16_10","JOS","16","10","10","ולא הורישו את הכנעני היושב בגזר וישב הכנעני בקרב אפרים עד היום הזה ויהי למס עבד׃ ");
INSERT INTO heb_vpl VALUES ("JS17_1","007_17_1","JOS","17","1","1","ויהי הגורל למטה מנשה כי הוא בכור יוסף למכיר בכור מנשה אבי הגלעד כי הוא היה איש מלחמה ויהי לו הגלעד והבשן׃ ");
INSERT INTO heb_vpl VALUES ("JS17_2","007_17_2","JOS","17","2","2","ויהי לבני מנשה הנותרים למשפחתם לבני אביעזר ולבני חלק ולבני אשריאל ולבני שכם ולבני חפר ולבני שמידע אלה בני מנשה בן יוסף הזכרים למשפחתם׃ ");
INSERT INTO heb_vpl VALUES ("JS17_3","007_17_3","JOS","17","3","3","ולצלפחד בן חפר בן גלעד בן מכיר בן מנשה לא היו לו בנים כי אם בנות ואלה שמות בנתיו מחלה ונעה חגלה מלכה ותרצה׃ ");
INSERT INTO heb_vpl VALUES ("JS17_4","007_17_4","JOS","17","4","4","ותקרבנה לפני אלעזר הכהן ולפני יהושע בן נון ולפני הנשיאים לאמר יהוה צוה את משה לתת לנו נחלה בתוך אחינו ויתן להם אל פי יהוה נחלה בתוך אחי אביהן׃ ");
INSERT INTO heb_vpl VALUES ("JS17_5","007_17_5","JOS","17","5","5","ויפלו חבלי מנשה עשרה לבד מארץ הגלעד והבשן אשר מעבר לירדן׃ ");
INSERT INTO heb_vpl VALUES ("JS17_6","007_17_6","JOS","17","6","6","כי בנות מנשה נחלו נחלה בתוך בניו וארץ הגלעד היתה לבני מנשה הנותרים׃ ");
INSERT INTO heb_vpl VALUES ("JS17_7","007_17_7","JOS","17","7","7","ויהי גבול מנשה מאשר המכמתת אשר על פני שכם והלך הגבול אל הימין אל ישבי עין תפוח׃ ");
INSERT INTO heb_vpl VALUES ("JS17_8","007_17_8","JOS","17","8","8","למנשה היתה ארץ תפוח ותפוח אל גבול מנשה לבני אפרים׃ ");
INSERT INTO heb_vpl VALUES ("JS17_9","007_17_9","JOS","17","9","9","וירד הגבול נחל קנה נגבה לנחל ערים האלה לאפרים בתוך ערי מנשה וגבול מנשה מצפון לנחל ויהי תצאתיו הימה׃ ");
INSERT INTO heb_vpl VALUES ("JS17_10","007_17_10","JOS","17","10","10","נגבה לאפרים וצפונה למנשה ויהי הים גבולו ובאשר יפגעון מצפון וביששכר ממזרח׃ ");
INSERT INTO heb_vpl VALUES ("JS17_11","007_17_11","JOS","17","11","11","ויהי למנשה ביששכר ובאשר בית שאן ובנותיה ויבלעם ובנותיה ואת ישבי דאר ובנותיה וישבי עין דר ובנתיה וישבי תענך ובנתיה וישבי מגדו ובנותיה שלשת הנפת׃ ");
INSERT INTO heb_vpl VALUES ("JS17_12","007_17_12","JOS","17","12","12","ולא יכלו בני מנשה להוריש את הערים האלה ויואל הכנעני לשבת בארץ הזאת׃ ");
INSERT INTO heb_vpl VALUES ("JS17_13","007_17_13","JOS","17","13","13","ויהי כי חזקו בני ישראל ויתנו את הכנעני למס והורש לא הורישו׃ ");
INSERT INTO heb_vpl VALUES ("JS17_14","007_17_14","JOS","17","14","14","וידברו בני יוסף את יהושע לאמר מדוע נתתה לי נחלה גורל אחד וחבל אחד ואני עם רב עד אשר עד כה ברכני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("JS17_15","007_17_15","JOS","17","15","15","ויאמר אליהם יהושע אם עם רב אתה עלה לך היערה ובראת לך שם בארץ הפרזי והרפאים כי אץ לך הר אפרים׃ ");
INSERT INTO heb_vpl VALUES ("JS17_16","007_17_16","JOS","17","16","16","ויאמרו בני יוסף לא ימצא לנו ההר ורכב ברזל בכל הכנעני הישב בארץ העמק לאשר בבית שאן ובנותיה ולאשר בעמק יזרעאל׃ ");
INSERT INTO heb_vpl VALUES ("JS17_17","007_17_17","JOS","17","17","17","ויאמר יהושע אל בית יוסף לאפרים ולמנשה לאמר עם רב אתה וכח גדול לך לא יהיה לך גורל אחד׃ ");
INSERT INTO heb_vpl VALUES ("JS17_18","007_17_18","JOS","17","18","18","כי הר יהיה לך כי יער הוא ובראתו והיה לך תצאתיו כי תוריש את הכנעני כי רכב ברזל לו כי חזק הוא׃ ");
INSERT INTO heb_vpl VALUES ("JS18_1","007_18_1","JOS","18","1","1","ויקהלו כל עדת בני ישראל שלה וישכינו שם את אהל מועד והארץ נכבשה לפניהם׃ ");
INSERT INTO heb_vpl VALUES ("JS18_2","007_18_2","JOS","18","2","2","ויותרו בבני ישראל אשר לא חלקו את נחלתם שבעה שבטים׃ ");
INSERT INTO heb_vpl VALUES ("JS18_3","007_18_3","JOS","18","3","3","ויאמר יהושע אל בני ישראל עד אנה אתם מתרפים לבוא לרשת את הארץ אשר נתן לכם יהוה אלהי אבותיכם׃ ");
INSERT INTO heb_vpl VALUES ("JS18_4","007_18_4","JOS","18","4","4","הבו לכם שלשה אנשים לשבט ואשלחם ויקמו ויתהלכו בארץ ויכתבו אותה לפי נחלתם ויבאו אלי׃ ");
INSERT INTO heb_vpl VALUES ("JS18_5","007_18_5","JOS","18","5","5","והתחלקו אתה לשבעה חלקים יהודה יעמד על גבולו מנגב ובית יוסף יעמדו על גבולם מצפון׃ ");
INSERT INTO heb_vpl VALUES ("JS18_6","007_18_6","JOS","18","6","6","ואתם תכתבו את הארץ שבעה חלקים והבאתם אלי הנה ויריתי לכם גורל פה לפני יהוה אלהינו׃ ");
INSERT INTO heb_vpl VALUES ("JS18_7","007_18_7","JOS","18","7","7","כי אין חלק ללוים בקרבכם כי כהנת יהוה נחלתו וגד וראובן וחצי שבט המנשה לקחו נחלתם מעבר לירדן מזרחה אשר נתן להם משה עבד יהוה׃ ");
INSERT INTO heb_vpl VALUES ("JS18_8","007_18_8","JOS","18","8","8","ויקמו האנשים וילכו ויצו יהושע את ההלכים לכתב את הארץ לאמר לכו והתהלכו בארץ וכתבו אותה ושובו אלי ופה אשליך לכם גורל לפני יהוה בשלה׃ ");
INSERT INTO heb_vpl VALUES ("JS18_9","007_18_9","JOS","18","9","9","וילכו האנשים ויעברו בארץ ויכתבוה לערים לשבעה חלקים על ספר ויבאו אל יהושע אל המחנה שלה׃ ");
INSERT INTO heb_vpl VALUES ("JS18_10","007_18_10","JOS","18","10","10","וישלך להם יהושע גורל בשלה לפני יהוה ויחלק שם יהושע את הארץ לבני ישראל כמחלקתם׃ ");
INSERT INTO heb_vpl VALUES ("JS18_11","007_18_11","JOS","18","11","11","ויעל גורל מטה בני בנימן למשפחתם ויצא גבול גורלם בין בני יהודה ובין בני יוסף׃ ");
INSERT INTO heb_vpl VALUES ("JS18_12","007_18_12","JOS","18","12","12","ויהי להם הגבול לפאת צפונה מן הירדן ועלה הגבול אל כתף יריחו מצפון ועלה בהר ימה והיה תצאתיו מדברה בית און׃ ");
INSERT INTO heb_vpl VALUES ("JS18_13","007_18_13","JOS","18","13","13","ועבר משם הגבול לוזה אל כתף לוזה נגבה היא בית אל וירד הגבול עטרות אדר על ההר אשר מנגב לבית חרון תחתון׃ ");
INSERT INTO heb_vpl VALUES ("JS18_14","007_18_14","JOS","18","14","14","ותאר הגבול ונסב לפאת ים נגבה מן ההר אשר על פני בית חרון נגבה והיה תצאתיו אל קרית בעל היא קרית יערים עיר בני יהודה זאת פאת ים׃ ");
INSERT INTO heb_vpl VALUES ("JS18_15","007_18_15","JOS","18","15","15","ופאת נגבה מקצה קרית יערים ויצא הגבול ימה ויצא אל מעין מי נפתוח׃ ");
INSERT INTO heb_vpl VALUES ("JS18_16","007_18_16","JOS","18","16","16","וירד הגבול אל קצה ההר אשר על פני גי בן הנם אשר בעמק רפאים צפונה וירד גי הנם אל כתף היבוסי נגבה וירד עין רגל׃ ");
INSERT INTO heb_vpl VALUES ("JS18_17","007_18_17","JOS","18","17","17","ותאר מצפון ויצא עין שמש ויצא אל גלילות אשר נכח מעלה אדמים וירד אבן בהן בן ראובן׃ ");
INSERT INTO heb_vpl VALUES ("JS18_18","007_18_18","JOS","18","18","18","ועבר אל כתף מול הערבה צפונה וירד הערבתה׃ ");
INSERT INTO heb_vpl VALUES ("JS18_19","007_18_19","JOS","18","19","19","ועבר הגבול אל כתף בית חגלה צפונה והיה תצאותיו הגבול אל לשון ים המלח צפונה אל קצה הירדן נגבה זה גבול נגב׃ ");
INSERT INTO heb_vpl VALUES ("JS18_20","007_18_20","JOS","18","20","20","והירדן יגבל אתו לפאת קדמה זאת נחלת בני בנימן לגבולתיה סביב למשפחתם׃ ");
INSERT INTO heb_vpl VALUES ("JS18_21","007_18_21","JOS","18","21","21","והיו הערים למטה בני בנימן למשפחותיהם יריחו ובית חגלה ועמק קציץ׃ ");
INSERT INTO heb_vpl VALUES ("JS18_22","007_18_22","JOS","18","22","22","ובית הערבה וצמרים ובית אל׃ ");
INSERT INTO heb_vpl VALUES ("JS18_23","007_18_23","JOS","18","23","23","והעוים והפרה ועפרה׃ ");
INSERT INTO heb_vpl VALUES ("JS18_24","007_18_24","JOS","18","24","24","וכפר העמני והעפני וגבע ערים שתים עשרה וחצריהן׃ ");
INSERT INTO heb_vpl VALUES ("JS18_25","007_18_25","JOS","18","25","25","גבעון והרמה ובארות׃ ");
INSERT INTO heb_vpl VALUES ("JS18_26","007_18_26","JOS","18","26","26","והמצפה והכפירה והמצה׃ ");
INSERT INTO heb_vpl VALUES ("JS18_27","007_18_27","JOS","18","27","27","ורקם וירפאל ותראלה׃ ");
INSERT INTO heb_vpl VALUES ("JS18_28","007_18_28","JOS","18","28","28","וצלע האלף והיבוסי היא ירושלם גבעת קרית ערים ארבע עשרה וחצריהן זאת נחלת בני בנימן למשפחתם׃ ");
INSERT INTO heb_vpl VALUES ("JS19_1","007_19_1","JOS","19","1","1","ויצא הגורל השני לשמעון למטה בני שמעון למשפחותם ויהי נחלתם בתוך נחלת בני יהודה׃ ");
INSERT INTO heb_vpl VALUES ("JS19_2","007_19_2","JOS","19","2","2","ויהי להם בנחלתם באר שבע ושבע ומולדה׃ ");
INSERT INTO heb_vpl VALUES ("JS19_3","007_19_3","JOS","19","3","3","וחצר שועל ובלה ועצם׃ ");
INSERT INTO heb_vpl VALUES ("JS19_4","007_19_4","JOS","19","4","4","ואלתולד ובתול וחרמה׃ ");
INSERT INTO heb_vpl VALUES ("JS19_5","007_19_5","JOS","19","5","5","וצקלג ובית המרכבות וחצר סוסה׃ ");
INSERT INTO heb_vpl VALUES ("JS19_6","007_19_6","JOS","19","6","6","ובית לבאות ושרוחן ערים שלש עשרה וחצריהן׃ ");
INSERT INTO heb_vpl VALUES ("JS19_7","007_19_7","JOS","19","7","7","עין רמון ועתר ועשן ערים ארבע וחצריהן׃ ");
INSERT INTO heb_vpl VALUES ("JS19_8","007_19_8","JOS","19","8","8","וכל החצרים אשר סביבות הערים האלה עד בעלת באר ראמת נגב זאת נחלת מטה בני שמעון למשפחתם׃ ");
INSERT INTO heb_vpl VALUES ("JS19_9","007_19_9","JOS","19","9","9","מחבל בני יהודה נחלת בני שמעון כי היה חלק בני יהודה רב מהם וינחלו בני שמעון בתוך נחלתם׃ ");
INSERT INTO heb_vpl VALUES ("JS19_10","007_19_10","JOS","19","10","10","ויעל הגורל השלישי לבני זבולן למשפחתם ויהי גבול נחלתם עד שריד׃ ");
INSERT INTO heb_vpl VALUES ("JS19_11","007_19_11","JOS","19","11","11","ועלה גבולם לימה ומרעלה ופגע בדבשת ופגע אל הנחל אשר על פני יקנעם׃ ");
INSERT INTO heb_vpl VALUES ("JS19_12","007_19_12","JOS","19","12","12","ושב משריד קדמה מזרח השמש על גבול כסלת תבר ויצא אל הדברת ועלה יפיע׃ ");
INSERT INTO heb_vpl VALUES ("JS19_13","007_19_13","JOS","19","13","13","ומשם עבר קדמה מזרחה גתה חפר עתה קצין ויצא רמון המתאר הנעה׃ ");
INSERT INTO heb_vpl VALUES ("JS19_14","007_19_14","JOS","19","14","14","ונסב אתו הגבול מצפון חנתן והיו תצאתיו גי יפתח אל׃ ");
INSERT INTO heb_vpl VALUES ("JS19_15","007_19_15","JOS","19","15","15","וקטת ונהלל ושמרון וידאלה ובית לחם ערים שתים עשרה וחצריהן׃ ");
INSERT INTO heb_vpl VALUES ("JS19_16","007_19_16","JOS","19","16","16","זאת נחלת בני זבולן למשפחותם הערים האלה וחצריהן׃ ");
INSERT INTO heb_vpl VALUES ("JS19_17","007_19_17","JOS","19","17","17","ליששכר יצא הגורל הרביעי לבני יששכר למשפחותם׃ ");
INSERT INTO heb_vpl VALUES ("JS19_18","007_19_18","JOS","19","18","18","ויהי גבולם יזרעאלה והכסולת ושונם׃ ");
INSERT INTO heb_vpl VALUES ("JS19_19","007_19_19","JOS","19","19","19","וחפרים ושיאן ואנחרת׃ ");
INSERT INTO heb_vpl VALUES ("JS19_20","007_19_20","JOS","19","20","20","והרבית וקשיון ואבץ׃ ");
INSERT INTO heb_vpl VALUES ("JS19_21","007_19_21","JOS","19","21","21","ורמת ועין גנים ועין חדה ובית פצץ׃ ");
INSERT INTO heb_vpl VALUES ("JS19_22","007_19_22","JOS","19","22","22","ופגע הגבול בתבור ושחצומה ובית שמש והיו תצאות גבולם הירדן ערים שש עשרה וחצריהן׃ ");
INSERT INTO heb_vpl VALUES ("JS19_23","007_19_23","JOS","19","23","23","זאת נחלת מטה בני יששכר למשפחתם הערים וחצריהן׃ ");
INSERT INTO heb_vpl VALUES ("JS19_24","007_19_24","JOS","19","24","24","ויצא הגורל החמישי למטה בני אשר למשפחותם׃ ");
INSERT INTO heb_vpl VALUES ("JS19_25","007_19_25","JOS","19","25","25","ויהי גבולם חלקת וחלי ובטן ואכשף׃ ");
INSERT INTO heb_vpl VALUES ("JS19_26","007_19_26","JOS","19","26","26","ואלמלך ועמעד ומשאל ופגע בכרמל הימה ובשיחור לבנת׃ ");
INSERT INTO heb_vpl VALUES ("JS19_27","007_19_27","JOS","19","27","27","ושב מזרח השמש בית דגן ופגע בזבלון ובגי יפתח אל צפונה בית העמק ונעיאל ויצא אל כבול משמאל׃ ");
INSERT INTO heb_vpl VALUES ("JS19_28","007_19_28","JOS","19","28","28","ועברן ורחב וחמון וקנה עד צידון רבה׃ ");
INSERT INTO heb_vpl VALUES ("JS19_29","007_19_29","JOS","19","29","29","ושב הגבול הרמה ועד עיר מבצר צר ושב הגבול חסה ויהיו תצאתיו הימה מחבל אכזיבה׃ ");
INSERT INTO heb_vpl VALUES ("JS19_30","007_19_30","JOS","19","30","30","ועמה ואפק ורחב ערים עשרים ושתים וחצריהן׃ ");
INSERT INTO heb_vpl VALUES ("JS19_31","007_19_31","JOS","19","31","31","זאת נחלת מטה בני אשר למשפחתם הערים האלה וחצריהן׃ ");
INSERT INTO heb_vpl VALUES ("JS19_32","007_19_32","JOS","19","32","32","לבני נפתלי יצא הגורל הששי לבני נפתלי למשפחתם׃ ");
INSERT INTO heb_vpl VALUES ("JS19_33","007_19_33","JOS","19","33","33","ויהי גבולם מחלף מאלון בצעננים ואדמי הנקב ויבנאל עד לקום ויהי תצאתיו הירדן׃ ");
INSERT INTO heb_vpl VALUES ("JS19_34","007_19_34","JOS","19","34","34","ושב הגבול ימה אזנות תבור ויצא משם חוקקה ופגע בזבלון מנגב ובאשר פגע מים וביהודה הירדן מזרח השמש׃ ");
INSERT INTO heb_vpl VALUES ("JS19_35","007_19_35","JOS","19","35","35","וערי מבצר הצדים צר וחמת רקת וכנרת׃ ");
INSERT INTO heb_vpl VALUES ("JS19_36","007_19_36","JOS","19","36","36","ואדמה והרמה וחצור׃ ");
INSERT INTO heb_vpl VALUES ("JS19_37","007_19_37","JOS","19","37","37","וקדש ואדרעי ועין חצור׃ ");
INSERT INTO heb_vpl VALUES ("JS19_38","007_19_38","JOS","19","38","38","ויראון ומגדל אל חרם ובית ענת ובית שמש ערים תשע עשרה וחצריהן׃ ");
INSERT INTO heb_vpl VALUES ("JS19_39","007_19_39","JOS","19","39","39","זאת נחלת מטה בני נפתלי למשפחתם הערים וחצריהן׃ ");
INSERT INTO heb_vpl VALUES ("JS19_40","007_19_40","JOS","19","40","40","למטה בני דן למשפחתם יצא הגורל השביעי׃ ");
INSERT INTO heb_vpl VALUES ("JS19_41","007_19_41","JOS","19","41","41","ויהי גבול נחלתם צרעה ואשתאול ועיר שמש׃ ");
INSERT INTO heb_vpl VALUES ("JS19_42","007_19_42","JOS","19","42","42","ושעלבין ואילון ויתלה׃ ");
INSERT INTO heb_vpl VALUES ("JS19_43","007_19_43","JOS","19","43","43","ואילון ותמנתה ועקרון׃ ");
INSERT INTO heb_vpl VALUES ("JS19_44","007_19_44","JOS","19","44","44","ואלתקה וגבתון ובעלת׃ ");
INSERT INTO heb_vpl VALUES ("JS19_45","007_19_45","JOS","19","45","45","ויהד ובני ברק וגת רמון׃ ");
INSERT INTO heb_vpl VALUES ("JS19_46","007_19_46","JOS","19","46","46","ומי הירקון והרקון עם הגבול מול יפו׃ ");
INSERT INTO heb_vpl VALUES ("JS19_47","007_19_47","JOS","19","47","47","ויצא גבול בני דן מהם ויעלו בני דן וילחמו עם לשם וילכדו אותה ויכו אותה לפי חרב וירשו אותה וישבו בה ויקראו ללשם דן כשם דן אביהם׃ ");
INSERT INTO heb_vpl VALUES ("JS19_48","007_19_48","JOS","19","48","48","זאת נחלת מטה בני דן למשפחתם הערים האלה וחצריהן׃ ");
INSERT INTO heb_vpl VALUES ("JS19_49","007_19_49","JOS","19","49","49","ויכלו לנחל את הארץ לגבולתיה ויתנו בני ישראל נחלה ליהושע בן נון בתוכם׃ ");
INSERT INTO heb_vpl VALUES ("JS19_50","007_19_50","JOS","19","50","50","על פי יהוה נתנו לו את העיר אשר שאל את תמנת סרח בהר אפרים ויבנה את העיר וישב בה׃ ");
INSERT INTO heb_vpl VALUES ("JS19_51","007_19_51","JOS","19","51","51","אלה הנחלת אשר נחלו אלעזר הכהן ויהושע בן נון וראשי האבות למטות בני ישראל בגורל בשלה לפני יהוה פתח אהל מועד ויכלו מחלק את הארץ׃ ");
INSERT INTO heb_vpl VALUES ("JS20_1","007_20_1","JOS","20","1","1","וידבר יהוה אל יהושע לאמר׃ ");
INSERT INTO heb_vpl VALUES ("JS20_2","007_20_2","JOS","20","2","2","דבר אל בני ישראל לאמר תנו לכם את ערי המקלט אשר דברתי אליכם ביד משה׃ ");
INSERT INTO heb_vpl VALUES ("JS20_3","007_20_3","JOS","20","3","3","לנוס שמה רוצח מכה נפש בשגגה בבלי דעת והיו לכם למקלט מגאל הדם׃ ");
INSERT INTO heb_vpl VALUES ("JS20_4","007_20_4","JOS","20","4","4","ונס אל אחת מהערים האלה ועמד פתח שער העיר ודבר באזני זקני העיר ההיא את דבריו ואספו אתו העירה אליהם ונתנו לו מקום וישב עמם׃ ");
INSERT INTO heb_vpl VALUES ("JS20_5","007_20_5","JOS","20","5","5","וכי ירדף גאל הדם אחריו ולא יסגרו את הרצח בידו כי בבלי דעת הכה את רעהו ולא שנא הוא לו מתמול שלשום׃ ");
INSERT INTO heb_vpl VALUES ("JS20_6","007_20_6","JOS","20","6","6","וישב בעיר ההיא עד עמדו לפני העדה למשפט עד מות הכהן הגדול אשר יהיה בימים ההם אז ישוב הרוצח ובא אל עירו ואל ביתו אל העיר אשר נס משם׃ ");
INSERT INTO heb_vpl VALUES ("JS20_7","007_20_7","JOS","20","7","7","ויקדשו את קדש בגליל בהר נפתלי ואת שכם בהר אפרים ואת קרית ארבע היא חברון בהר יהודה׃ ");
INSERT INTO heb_vpl VALUES ("JS20_8","007_20_8","JOS","20","8","8","ומעבר לירדן יריחו מזרחה נתנו את בצר במדבר במישר ממטה ראובן ואת ראמת בגלעד ממטה גד ואת גלון בבשן ממטה מנשה׃ ");
INSERT INTO heb_vpl VALUES ("JS20_9","007_20_9","JOS","20","9","9","אלה היו ערי המועדה לכל בני ישראל ולגר הגר בתוכם לנוס שמה כל מכה נפש בשגגה ולא ימות ביד גאל הדם עד עמדו לפני העדה׃ ");
INSERT INTO heb_vpl VALUES ("JS21_1","007_21_1","JOS","21","1","1","ויגשו ראשי אבות הלוים אל אלעזר הכהן ואל יהושע בן נון ואל ראשי אבות המטות לבני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("JS21_2","007_21_2","JOS","21","2","2","וידברו אליהם בשלה בארץ כנען לאמר יהוה צוה ביד משה לתת לנו ערים לשבת ומגרשיהן לבהמתנו׃ ");
INSERT INTO heb_vpl VALUES ("JS21_3","007_21_3","JOS","21","3","3","ויתנו בני ישראל ללוים מנחלתם אל פי יהוה את הערים האלה ואת מגרשיהן׃ ");
INSERT INTO heb_vpl VALUES ("JS21_4","007_21_4","JOS","21","4","4","ויצא הגורל למשפחת הקהתי ויהי לבני אהרן הכהן מן הלוים ממטה יהודה וממטה השמעני וממטה בנימן בגורל ערים שלש עשרה׃ ");
INSERT INTO heb_vpl VALUES ("JS21_5","007_21_5","JOS","21","5","5","ולבני קהת הנותרים ממשפחת מטה אפרים וממטה דן ומחצי מטה מנשה בגורל ערים עשר׃ ");
INSERT INTO heb_vpl VALUES ("JS21_6","007_21_6","JOS","21","6","6","ולבני גרשון ממשפחות מטה יששכר וממטה אשר וממטה נפתלי ומחצי מטה מנשה בבשן בגורל ערים שלש עשרה׃ ");
INSERT INTO heb_vpl VALUES ("JS21_7","007_21_7","JOS","21","7","7","לבני מררי למשפחתם ממטה ראובן וממטה גד וממטה זבולן ערים שתים עשרה׃ ");
INSERT INTO heb_vpl VALUES ("JS21_8","007_21_8","JOS","21","8","8","ויתנו בני ישראל ללוים את הערים האלה ואת מגרשיהן כאשר צוה יהוה ביד משה בגורל׃ ");
INSERT INTO heb_vpl VALUES ("JS21_9","007_21_9","JOS","21","9","9","ויתנו ממטה בני יהודה וממטה בני שמעון את הערים האלה אשר יקרא אתהן בשם׃ ");
INSERT INTO heb_vpl VALUES ("JS21_10","007_21_10","JOS","21","10","10","ויהי לבני אהרן ממשפחות הקהתי מבני לוי כי להם היה הגורל ראישנה׃ ");
INSERT INTO heb_vpl VALUES ("JS21_11","007_21_11","JOS","21","11","11","ויתנו להם את קרית ארבע אבי הענוק היא חברון בהר יהודה ואת מגרשה סביבתיה׃ ");
INSERT INTO heb_vpl VALUES ("JS21_12","007_21_12","JOS","21","12","12","ואת שדה העיר ואת חצריה נתנו לכלב בן יפנה באחזתו׃ ");
INSERT INTO heb_vpl VALUES ("JS21_13","007_21_13","JOS","21","13","13","ולבני אהרן הכהן נתנו את עיר מקלט הרצח את חברון ואת מגרשה ואת לבנה ואת מגרשה׃ ");
INSERT INTO heb_vpl VALUES ("JS21_14","007_21_14","JOS","21","14","14","ואת יתר ואת מגרשה ואת אשתמע ואת מגרשה׃ ");
INSERT INTO heb_vpl VALUES ("JS21_15","007_21_15","JOS","21","15","15","ואת חלן ואת מגרשה ואת דבר ואת מגרשה׃ ");
INSERT INTO heb_vpl VALUES ("JS21_16","007_21_16","JOS","21","16","16","ואת עין ואת מגרשה ואת יטה ואת מגרשה את בית שמש ואת מגרשה ערים תשע מאת שני השבטים האלה׃ ");
INSERT INTO heb_vpl VALUES ("JS21_17","007_21_17","JOS","21","17","17","וממטה בנימן את גבעון ואת מגרשה את גבע ואת מגרשה׃ ");
INSERT INTO heb_vpl VALUES ("JS21_18","007_21_18","JOS","21","18","18","את ענתות ואת מגרשה ואת עלמון ואת מגרשה ערים ארבע׃ ");
INSERT INTO heb_vpl VALUES ("JS21_19","007_21_19","JOS","21","19","19","כל ערי בני אהרן הכהנים שלש עשרה ערים ומגרשיהן׃ ");
INSERT INTO heb_vpl VALUES ("JS21_20","007_21_20","JOS","21","20","20","ולמשפחות בני קהת הלוים הנותרים מבני קהת ויהי ערי גורלם ממטה אפרים׃ ");
INSERT INTO heb_vpl VALUES ("JS21_21","007_21_21","JOS","21","21","21","ויתנו להם את עיר מקלט הרצח את שכם ואת מגרשה בהר אפרים ואת גזר ואת מגרשה׃ ");
INSERT INTO heb_vpl VALUES ("JS21_22","007_21_22","JOS","21","22","22","ואת קבצים ואת מגרשה ואת בית חורן ואת מגרשה ערים ארבע׃ ");
INSERT INTO heb_vpl VALUES ("JS21_23","007_21_23","JOS","21","23","23","וממטה דן את אלתקא ואת מגרשה את גבתון ואת מגרשה׃ ");
INSERT INTO heb_vpl VALUES ("JS21_24","007_21_24","JOS","21","24","24","את אילון ואת מגרשה את גת רמון ואת מגרשה ערים ארבע׃ ");
INSERT INTO heb_vpl VALUES ("JS21_25","007_21_25","JOS","21","25","25","וממחצית מטה מנשה את תענך ואת מגרשה ואת גת רמון ואת מגרשה ערים שתים׃ ");
INSERT INTO heb_vpl VALUES ("JS21_26","007_21_26","JOS","21","26","26","כל ערים עשר ומגרשיהן למשפחות בני קהת הנותרים׃ ");
INSERT INTO heb_vpl VALUES ("JS21_27","007_21_27","JOS","21","27","27","ולבני גרשון ממשפחת הלוים מחצי מטה מנשה את עיר מקלט הרצח את גלון בבשן ואת מגרשה ואת בעשתרה ואת מגרשה ערים שתים׃ ");
INSERT INTO heb_vpl VALUES ("JS21_28","007_21_28","JOS","21","28","28","וממטה יששכר את קשיון ואת מגרשה את דברת ואת מגרשה׃ ");
INSERT INTO heb_vpl VALUES ("JS21_29","007_21_29","JOS","21","29","29","את ירמות ואת מגרשה את עין גנים ואת מגרשה ערים ארבע׃ ");
INSERT INTO heb_vpl VALUES ("JS21_30","007_21_30","JOS","21","30","30","וממטה אשר את משאל ואת מגרשה את עבדון ואת מגרשה׃ ");
INSERT INTO heb_vpl VALUES ("JS21_31","007_21_31","JOS","21","31","31","את חלקת ואת מגרשה ואת רחב ואת מגרשה ערים ארבע׃ ");
INSERT INTO heb_vpl VALUES ("JS21_32","007_21_32","JOS","21","32","32","וממטה נפתלי את עיר מקלט הרצח את קדש בגליל ואת מגרשה ואת חמת דאר ואת מגרשה ואת קרתן ואת מגרשה ערים שלש׃ ");
INSERT INTO heb_vpl VALUES ("JS21_33","007_21_33","JOS","21","33","33","כל ערי הגרשני למשפחתם שלש עשרה עיר ומגרשיהן׃ ");
INSERT INTO heb_vpl VALUES ("JS21_34","007_21_34","JOS","21","34","34","ולמשפחות בני מררי הלוים הנותרים מאת מטה זבולן את יקנעם ואת מגרשה את קרתה ואת מגרשה׃ ");
INSERT INTO heb_vpl VALUES ("JS21_35","007_21_35","JOS","21","35","35","את דמנה ואת מגרשה את נהלל ואת מגרשה ערים ארבע׃ ");
INSERT INTO heb_vpl VALUES ("JS21_36","007_21_36","JOS","21","36","36","וממטה ראובן את בצר ואת מגרשה ואת יהצה ואת מגרשה׃ ");
INSERT INTO heb_vpl VALUES ("JS21_37","007_21_37","JOS","21","37","37","את קדמות ואת מגרשה ואת מיפעת ואת מגרשה ערים ארבע׃ ");
INSERT INTO heb_vpl VALUES ("JS21_38","007_21_38","JOS","21","38","38","וממטה גד את עיר מקלט הרצח את רמת בגלעד ואת מגרשה ואת מחנים ואת מגרשה׃ ");
INSERT INTO heb_vpl VALUES ("JS21_39","007_21_39","JOS","21","39","39","את חשבון ואת מגרשה את יעזר ואת מגרשה כל ערים ארבע׃ ");
INSERT INTO heb_vpl VALUES ("JS21_40","007_21_40","JOS","21","40","40","כל הערים לבני מררי למשפחתם הנותרים ממשפחות הלוים ויהי גורלם ערים שתים עשרה׃ ");
INSERT INTO heb_vpl VALUES ("JS21_41","007_21_41","JOS","21","41","41","כל ערי הלוים בתוך אחזת בני ישראל ערים ארבעים ושמנה ומגרשיהן׃ ");
INSERT INTO heb_vpl VALUES ("JS21_42","007_21_42","JOS","21","42","42","תהיינה הערים האלה עיר עיר ומגרשיה סביבתיה כן לכל הערים האלה׃ ");
INSERT INTO heb_vpl VALUES ("JS21_43","007_21_43","JOS","21","43","43","ויתן יהוה לישראל את כל הארץ אשר נשבע לתת לאבותם וירשוה וישבו בה׃ ");
INSERT INTO heb_vpl VALUES ("JS21_44","007_21_44","JOS","21","44","44","וינח יהוה להם מסביב ככל אשר נשבע לאבותם ולא עמד איש בפניהם מכל איביהם את כל איביהם נתן יהוה בידם׃ ");
INSERT INTO heb_vpl VALUES ("JS21_45","007_21_45","JOS","21","45","45","לא נפל דבר מכל הדבר הטוב אשר דבר יהוה אל בית ישראל הכל בא׃ ");
INSERT INTO heb_vpl VALUES ("JS22_1","007_22_1","JOS","22","1","1","אז יקרא יהושע לראובני ולגדי ולחצי מטה מנשה׃ ");
INSERT INTO heb_vpl VALUES ("JS22_2","007_22_2","JOS","22","2","2","ויאמר אליהם אתם שמרתם את כל אשר צוה אתכם משה עבד יהוה ותשמעו בקולי לכל אשר צויתי אתכם׃ ");
INSERT INTO heb_vpl VALUES ("JS22_3","007_22_3","JOS","22","3","3","לא עזבתם את אחיכם זה ימים רבים עד היום הזה ושמרתם את משמרת מצות יהוה אלהיכם׃ ");
INSERT INTO heb_vpl VALUES ("JS22_4","007_22_4","JOS","22","4","4","ועתה הניח יהוה אלהיכם לאחיכם כאשר דבר להם ועתה פנו ולכו לכם לאהליכם אל ארץ אחזתכם אשר נתן לכם משה עבד יהוה בעבר הירדן׃ ");
INSERT INTO heb_vpl VALUES ("JS22_5","007_22_5","JOS","22","5","5","רק שמרו מאד לעשות את המצוה ואת התורה אשר צוה אתכם משה עבד יהוה לאהבה את יהוה אלהיכם וללכת בכל דרכיו ולשמר מצותיו ולדבקה בו ולעבדו בכל לבבכם ובכל נפשכם׃ ");
INSERT INTO heb_vpl VALUES ("JS22_6","007_22_6","JOS","22","6","6","ויברכם יהושע וישלחם וילכו אל אהליהם׃ ");
INSERT INTO heb_vpl VALUES ("JS22_7","007_22_7","JOS","22","7","7","ולחצי שבט המנשה נתן משה בבשן ולחציו נתן יהושע עם אחיהם מעבר הירדן ימה וגם כי שלחם יהושע אל אהליהם ויברכם׃ ");
INSERT INTO heb_vpl VALUES ("JS22_8","007_22_8","JOS","22","8","8","ויאמר אליהם לאמר בנכסים רבים שובו אל אהליכם ובמקנה רב מאד בכסף ובזהב ובנחשת ובברזל ובשלמות הרבה מאד חלקו שלל איביכם עם אחיכם׃ ");
INSERT INTO heb_vpl VALUES ("JS22_9","007_22_9","JOS","22","9","9","וישבו וילכו בני ראובן ובני גד וחצי שבט המנשה מאת בני ישראל משלה אשר בארץ כנען ללכת אל ארץ הגלעד אל ארץ אחזתם אשר נאחזו בה על פי יהוה ביד משה׃ ");
INSERT INTO heb_vpl VALUES ("JS22_10","007_22_10","JOS","22","10","10","ויבאו אל גלילות הירדן אשר בארץ כנען ויבנו בני ראובן ובני גד וחצי שבט המנשה שם מזבח על הירדן מזבח גדול למראה׃ ");
INSERT INTO heb_vpl VALUES ("JS22_11","007_22_11","JOS","22","11","11","וישמעו בני ישראל לאמר הנה בנו בני ראובן ובני גד וחצי שבט המנשה את המזבח אל מול ארץ כנען אל גלילות הירדן אל עבר בני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("JS22_12","007_22_12","JOS","22","12","12","וישמעו בני ישראל ויקהלו כל עדת בני ישראל שלה לעלות עליהם לצבא׃ ");
INSERT INTO heb_vpl VALUES ("JS22_13","007_22_13","JOS","22","13","13","וישלחו בני ישראל אל בני ראובן ואל בני גד ואל חצי שבט מנשה אל ארץ הגלעד את פינחס בן אלעזר הכהן׃ ");
INSERT INTO heb_vpl VALUES ("JS22_14","007_22_14","JOS","22","14","14","ועשרה נשאים עמו נשיא אחד נשיא אחד לבית אב לכל מטות ישראל ואיש ראש בית אבותם המה לאלפי ישראל׃ ");
INSERT INTO heb_vpl VALUES ("JS22_15","007_22_15","JOS","22","15","15","ויבאו אל בני ראובן ואל בני גד ואל חצי שבט מנשה אל ארץ הגלעד וידברו אתם לאמר׃ ");
INSERT INTO heb_vpl VALUES ("JS22_16","007_22_16","JOS","22","16","16","כה אמרו כל עדת יהוה מה המעל הזה אשר מעלתם באלהי ישראל לשוב היום מאחרי יהוה בבנותכם לכם מזבח למרדכם היום ביהוה׃ ");
INSERT INTO heb_vpl VALUES ("JS22_17","007_22_17","JOS","22","17","17","המעט לנו את עון פעור אשר לא הטהרנו ממנו עד היום הזה ויהי הנגף בעדת יהוה׃ ");
INSERT INTO heb_vpl VALUES ("JS22_18","007_22_18","JOS","22","18","18","ואתם תשבו היום מאחרי יהוה והיה אתם תמרדו היום ביהוה ומחר אל כל עדת ישראל יקצף׃ ");
INSERT INTO heb_vpl VALUES ("JS22_19","007_22_19","JOS","22","19","19","ואך אם טמאה ארץ אחזתכם עברו לכם אל ארץ אחזת יהוה אשר שכן שם משכן יהוה והאחזו בתוכנו וביהוה אל תמרדו ואתנו אל תמרדו בבנתכם לכם מזבח מבלעדי מזבח יהוה אלהינו׃ ");
INSERT INTO heb_vpl VALUES ("JS22_20","007_22_20","JOS","22","20","20","הלוא עכן בן זרח מעל מעל בחרם ועל כל עדת ישראל היה קצף והוא איש אחד לא גוע בעונו׃ ");
INSERT INTO heb_vpl VALUES ("JS22_21","007_22_21","JOS","22","21","21","ויענו בני ראובן ובני גד וחצי שבט המנשה וידברו את ראשי אלפי ישראל׃ ");
INSERT INTO heb_vpl VALUES ("JS22_22","007_22_22","JOS","22","22","22","אל אלהים יהוה אל אלהים יהוה הוא ידע וישראל הוא ידע אם במרד ואם במעל ביהוה אל תושיענו היום הזה׃ ");
INSERT INTO heb_vpl VALUES ("JS22_23","007_22_23","JOS","22","23","23","לבנות לנו מזבח לשוב מאחרי יהוה ואם להעלות עליו עולה ומנחה ואם לעשות עליו זבחי שלמים יהוה הוא יבקש׃ ");
INSERT INTO heb_vpl VALUES ("JS22_24","007_22_24","JOS","22","24","24","ואם לא מדאגה מדבר עשינו את זאת לאמר מחר יאמרו בניכם לבנינו לאמר מה לכם וליהוה אלהי ישראל׃ ");
INSERT INTO heb_vpl VALUES ("JS22_25","007_22_25","JOS","22","25","25","וגבול נתן יהוה ביננו וביניכם בני ראובן ובני גד את הירדן אין לכם חלק ביהוה והשביתו בניכם את בנינו לבלתי ירא את יהוה׃ ");
INSERT INTO heb_vpl VALUES ("JS22_26","007_22_26","JOS","22","26","26","ונאמר נעשה נא לנו לבנות את המזבח לא לעולה ולא לזבח׃ ");
INSERT INTO heb_vpl VALUES ("JS22_27","007_22_27","JOS","22","27","27","כי עד הוא בינינו וביניכם ובין דרותינו אחרינו לעבד את עבדת יהוה לפניו בעלותינו ובזבחינו ובשלמינו ולא יאמרו בניכם מחר לבנינו אין לכם חלק ביהוה׃ ");
INSERT INTO heb_vpl VALUES ("JS22_28","007_22_28","JOS","22","28","28","ונאמר והיה כי יאמרו אלינו ואל דרתינו מחר ואמרנו ראו את תבנית מזבח יהוה אשר עשו אבותינו לא לעולה ולא לזבח כי עד הוא בינינו וביניכם׃ ");
INSERT INTO heb_vpl VALUES ("JS22_29","007_22_29","JOS","22","29","29","חלילה לנו ממנו למרד ביהוה ולשוב היום מאחרי יהוה לבנות מזבח לעלה למנחה ולזבח מלבד מזבח יהוה אלהינו אשר לפני משכנו׃ ");
INSERT INTO heb_vpl VALUES ("JS22_30","007_22_30","JOS","22","30","30","וישמע פינחס הכהן ונשיאי העדה וראשי אלפי ישראל אשר אתו את הדברים אשר דברו בני ראובן ובני גד ובני מנשה וייטב בעיניהם׃ ");
INSERT INTO heb_vpl VALUES ("JS22_31","007_22_31","JOS","22","31","31","ויאמר פינחס בן אלעזר הכהן אל בני ראובן ואל בני גד ואל בני מנשה היום ידענו כי בתוכנו יהוה אשר לא מעלתם ביהוה המעל הזה אז הצלתם את בני ישראל מיד יהוה׃ ");
INSERT INTO heb_vpl VALUES ("JS22_32","007_22_32","JOS","22","32","32","וישב פינחס בן אלעזר הכהן והנשיאים מאת בני ראובן ומאת בני גד מארץ הגלעד אל ארץ כנען אל בני ישראל וישבו אותם דבר׃ ");
INSERT INTO heb_vpl VALUES ("JS22_33","007_22_33","JOS","22","33","33","וייטב הדבר בעיני בני ישראל ויברכו אלהים בני ישראל ולא אמרו לעלות עליהם לצבא לשחת את הארץ אשר בני ראובן ובני גד ישבים בה׃ ");
INSERT INTO heb_vpl VALUES ("JS22_34","007_22_34","JOS","22","34","34","ויקראו בני ראובן ובני גד למזבח כי עד הוא בינתינו כי יהוה האלהים׃ ");
INSERT INTO heb_vpl VALUES ("JS23_1","007_23_1","JOS","23","1","1","ויהי מימים רבים אחרי אשר הניח יהוה לישראל מכל איביהם מסביב ויהושע זקן בא בימים׃ ");
INSERT INTO heb_vpl VALUES ("JS23_2","007_23_2","JOS","23","2","2","ויקרא יהושע לכל ישראל לזקניו ולראשיו ולשפטיו ולשטריו ויאמר אלהם אני זקנתי באתי בימים׃ ");
INSERT INTO heb_vpl VALUES ("JS23_3","007_23_3","JOS","23","3","3","ואתם ראיתם את כל אשר עשה יהוה אלהיכם לכל הגוים האלה מפניכם כי יהוה אלהיכם הוא הנלחם לכם׃ ");
INSERT INTO heb_vpl VALUES ("JS23_4","007_23_4","JOS","23","4","4","ראו הפלתי לכם את הגוים הנשארים האלה בנחלה לשבטיכם מן הירדן וכל הגוים אשר הכרתי והים הגדול מבוא השמש׃ ");
INSERT INTO heb_vpl VALUES ("JS23_5","007_23_5","JOS","23","5","5","ויהוה אלהיכם הוא יהדפם מפניכם והוריש אתם מלפניכם וירשתם את ארצם כאשר דבר יהוה אלהיכם לכם׃ ");
INSERT INTO heb_vpl VALUES ("JS23_6","007_23_6","JOS","23","6","6","וחזקתם מאד לשמר ולעשות את כל הכתוב בספר תורת משה לבלתי סור ממנו ימין ושמאול׃ ");
INSERT INTO heb_vpl VALUES ("JS23_7","007_23_7","JOS","23","7","7","לבלתי בוא בגוים האלה הנשארים האלה אתכם ובשם אלהיהם לא תזכירו ולא תשביעו ולא תעבדום ולא תשתחוו להם׃ ");
INSERT INTO heb_vpl VALUES ("JS23_8","007_23_8","JOS","23","8","8","כי אם ביהוה אלהיכם תדבקו כאשר עשיתם עד היום הזה׃ ");
INSERT INTO heb_vpl VALUES ("JS23_9","007_23_9","JOS","23","9","9","ויורש יהוה מפניכם גוים גדלים ועצומים ואתם לא עמד איש בפניכם עד היום הזה׃ ");
INSERT INTO heb_vpl VALUES ("JS23_10","007_23_10","JOS","23","10","10","איש אחד מכם ירדף אלף כי יהוה אלהיכם הוא הנלחם לכם כאשר דבר לכם׃ ");
INSERT INTO heb_vpl VALUES ("JS23_11","007_23_11","JOS","23","11","11","ונשמרתם מאד לנפשתיכם לאהבה את יהוה אלהיכם׃ ");
INSERT INTO heb_vpl VALUES ("JS23_12","007_23_12","JOS","23","12","12","כי אם שוב תשובו ודבקתם ביתר הגוים האלה הנשארים האלה אתכם והתחתנתם בהם ובאתם בהם והם בכם׃ ");
INSERT INTO heb_vpl VALUES ("JS23_13","007_23_13","JOS","23","13","13","ידוע תדעו כי לא יוסיף יהוה אלהיכם להוריש את הגוים האלה מלפניכם והיו לכם לפח ולמוקש ולשטט בצדיכם ולצננים בעיניכם עד אבדכם מעל האדמה הטובה הזאת אשר נתן לכם יהוה אלהיכם׃ ");
INSERT INTO heb_vpl VALUES ("JS23_14","007_23_14","JOS","23","14","14","והנה אנכי הולך היום בדרך כל הארץ וידעתם בכל לבבכם ובכל נפשכם כי לא נפל דבר אחד מכל הדברים הטובים אשר דבר יהוה אלהיכם עליכם הכל באו לכם לא נפל ממנו דבר אחד׃ ");
INSERT INTO heb_vpl VALUES ("JS23_15","007_23_15","JOS","23","15","15","והיה כאשר בא עליכם כל הדבר הטוב אשר דבר יהוה אלהיכם אליכם כן יביא יהוה עליכם את כל הדבר הרע עד השמידו אותכם מעל האדמה הטובה הזאת אשר נתן לכם יהוה אלהיכם׃ ");
INSERT INTO heb_vpl VALUES ("JS23_16","007_23_16","JOS","23","16","16","בעברכם את ברית יהוה אלהיכם אשר צוה אתכם והלכתם ועבדתם אלהים אחרים והשתחויתם להם וחרה אף יהוה בכם ואבדתם מהרה מעל הארץ הטובה אשר נתן לכם׃ ");
INSERT INTO heb_vpl VALUES ("JS24_1","007_24_1","JOS","24","1","1","ויאסף יהושע את כל שבטי ישראל שכמה ויקרא לזקני ישראל ולראשיו ולשפטיו ולשטריו ויתיצבו לפני האלהים׃ ");
INSERT INTO heb_vpl VALUES ("JS24_2","007_24_2","JOS","24","2","2","ויאמר יהושע אל כל העם כה אמר יהוה אלהי ישראל בעבר הנהר ישבו אבותיכם מעולם תרח אבי אברהם ואבי נחור ויעבדו אלהים אחרים׃ ");
INSERT INTO heb_vpl VALUES ("JS24_3","007_24_3","JOS","24","3","3","ואקח את אביכם את אברהם מעבר הנהר ואולך אותו בכל ארץ כנען וארב את זרעו ואתן לו את יצחק׃ ");
INSERT INTO heb_vpl VALUES ("JS24_4","007_24_4","JOS","24","4","4","ואתן ליצחק את יעקב ואת עשו ואתן לעשו את הר שעיר לרשת אותו ויעקב ובניו ירדו מצרים׃ ");
INSERT INTO heb_vpl VALUES ("JS24_5","007_24_5","JOS","24","5","5","ואשלח את משה ואת אהרן ואגף את מצרים כאשר עשיתי בקרבו ואחר הוצאתי אתכם׃ ");
INSERT INTO heb_vpl VALUES ("JS24_6","007_24_6","JOS","24","6","6","ואוציא את אבותיכם ממצרים ותבאו הימה וירדפו מצרים אחרי אבותיכם ברכב ובפרשים ים סוף׃ ");
INSERT INTO heb_vpl VALUES ("JS24_7","007_24_7","JOS","24","7","7","ויצעקו אל יהוה וישם מאפל ביניכם ובין המצרים ויבא עליו את הים ויכסהו ותראינה עיניכם את אשר עשיתי במצרים ותשבו במדבר ימים רבים׃ ");
INSERT INTO heb_vpl VALUES ("JS24_8","007_24_8","JOS","24","8","8","ואביאה אתכם אל ארץ האמרי היושב בעבר הירדן וילחמו אתכם ואתן אותם בידכם ותירשו את ארצם ואשמידם מפניכם׃ ");
INSERT INTO heb_vpl VALUES ("JS24_9","007_24_9","JOS","24","9","9","ויקם בלק בן צפור מלך מואב וילחם בישראל וישלח ויקרא לבלעם בן בעור לקלל אתכם׃ ");
INSERT INTO heb_vpl VALUES ("JS24_10","007_24_10","JOS","24","10","10","ולא אביתי לשמע לבלעם ויברך ברוך אתכם ואצל אתכם מידו׃ ");
INSERT INTO heb_vpl VALUES ("JS24_11","007_24_11","JOS","24","11","11","ותעברו את הירדן ותבאו אל יריחו וילחמו בכם בעלי יריחו האמרי והפרזי והכנעני והחתי והגרגשי החוי והיבוסי ואתן אותם בידכם׃ ");
INSERT INTO heb_vpl VALUES ("JS24_12","007_24_12","JOS","24","12","12","ואשלח לפניכם את הצרעה ותגרש אותם מפניכם שני מלכי האמרי לא בחרבך ולא בקשתך׃ ");
INSERT INTO heb_vpl VALUES ("JS24_13","007_24_13","JOS","24","13","13","ואתן לכם ארץ אשר לא יגעת בה וערים אשר לא בניתם ותשבו בהם כרמים וזיתים אשר לא נטעתם אתם אכלים׃ ");
INSERT INTO heb_vpl VALUES ("JS24_14","007_24_14","JOS","24","14","14","ועתה יראו את יהוה ועבדו אתו בתמים ובאמת והסירו את אלהים אשר עבדו אבותיכם בעבר הנהר ובמצרים ועבדו את יהוה׃ ");
INSERT INTO heb_vpl VALUES ("JS24_15","007_24_15","JOS","24","15","15","ואם רע בעיניכם לעבד את יהוה בחרו לכם היום את מי תעבדון אם את אלהים אשר עבדו אבותיכם אשר בעבר הנהר ואם את אלהי האמרי אשר אתם ישבים בארצם ואנכי וביתי נעבד את יהוה׃ ");
INSERT INTO heb_vpl VALUES ("JS24_16","007_24_16","JOS","24","16","16","ויען העם ויאמר חלילה לנו מעזב את יהוה לעבד אלהים אחרים׃ ");
INSERT INTO heb_vpl VALUES ("JS24_17","007_24_17","JOS","24","17","17","כי יהוה אלהינו הוא המעלה אתנו ואת אבותינו מארץ מצרים מבית עבדים ואשר עשה לעינינו את האתות הגדלות האלה וישמרנו בכל הדרך אשר הלכנו בה ובכל העמים אשר עברנו בקרבם׃ ");
INSERT INTO heb_vpl VALUES ("JS24_18","007_24_18","JOS","24","18","18","ויגרש יהוה את כל העמים ואת האמרי ישב הארץ מפנינו גם אנחנו נעבד את יהוה כי הוא אלהינו׃ ");
INSERT INTO heb_vpl VALUES ("JS24_19","007_24_19","JOS","24","19","19","ויאמר יהושע אל העם לא תוכלו לעבד את יהוה כי אלהים קדשים הוא אל קנוא הוא לא ישא לפשעכם ולחטאותיכם׃ ");
INSERT INTO heb_vpl VALUES ("JS24_20","007_24_20","JOS","24","20","20","כי תעזבו את יהוה ועבדתם אלהי נכר ושב והרע לכם וכלה אתכם אחרי אשר היטיב לכם׃ ");
INSERT INTO heb_vpl VALUES ("JS24_21","007_24_21","JOS","24","21","21","ויאמר העם אל יהושע לא כי את יהוה נעבד׃ ");
INSERT INTO heb_vpl VALUES ("JS24_22","007_24_22","JOS","24","22","22","ויאמר יהושע אל העם עדים אתם בכם כי אתם בחרתם לכם את יהוה לעבד אותו ויאמרו עדים׃ ");
INSERT INTO heb_vpl VALUES ("JS24_23","007_24_23","JOS","24","23","23","ועתה הסירו את אלהי הנכר אשר בקרבכם והטו את לבבכם אל יהוה אלהי ישראל׃ ");
INSERT INTO heb_vpl VALUES ("JS24_24","007_24_24","JOS","24","24","24","ויאמרו העם אל יהושע את יהוה אלהינו נעבד ובקולו נשמע׃ ");
INSERT INTO heb_vpl VALUES ("JS24_25","007_24_25","JOS","24","25","25","ויכרת יהושע ברית לעם ביום ההוא וישם לו חק ומשפט בשכם׃ ");
INSERT INTO heb_vpl VALUES ("JS24_26","007_24_26","JOS","24","26","26","ויכתב יהושע את הדברים האלה בספר תורת אלהים ויקח אבן גדולה ויקימה שם תחת האלה אשר במקדש יהוה׃ ");
INSERT INTO heb_vpl VALUES ("JS24_27","007_24_27","JOS","24","27","27","ויאמר יהושע אל כל העם הנה האבן הזאת תהיה בנו לעדה כי היא שמעה את כל אמרי יהוה אשר דבר עמנו והיתה בכם לעדה פן תכחשון באלהיכם׃ ");
INSERT INTO heb_vpl VALUES ("JS24_28","007_24_28","JOS","24","28","28","וישלח יהושע את העם איש לנחלתו׃ ");
INSERT INTO heb_vpl VALUES ("JS24_29","007_24_29","JOS","24","29","29","ויהי אחרי הדברים האלה וימת יהושע בן נון עבד יהוה בן מאה ועשר שנים׃ ");
INSERT INTO heb_vpl VALUES ("JS24_30","007_24_30","JOS","24","30","30","ויקברו אתו בגבול נחלתו בתמנת סרח אשר בהר אפרים מצפון להר געש׃ ");
INSERT INTO heb_vpl VALUES ("JS24_31","007_24_31","JOS","24","31","31","ויעבד ישראל את יהוה כל ימי יהושע וכל ימי הזקנים אשר האריכו ימים אחרי יהושע ואשר ידעו את כל מעשה יהוה אשר עשה לישראל׃ ");
INSERT INTO heb_vpl VALUES ("JS24_32","007_24_32","JOS","24","32","32","ואת עצמות יוסף אשר העלו בני ישראל ממצרים קברו בשכם בחלקת השדה אשר קנה יעקב מאת בני חמור אבי שכם במאה קשיטה ויהיו לבני יוסף לנחלה׃ ");
INSERT INTO heb_vpl VALUES ("JS24_33","007_24_33","JOS","24","33","33","ואלעזר בן אהרן מת ויקברו אתו בגבעת פינחס בנו אשר נתן לו בהר אפרים׃ ");
INSERT INTO heb_vpl VALUES ("JG1_1","008_1_1","JDG","1","1","1","ויהי אחרי מות יהושע וישאלו בני ישראל ביהוה לאמר מי יעלה לנו אל הכנעני בתחלה להלחם בו׃ ");
INSERT INTO heb_vpl VALUES ("JG1_2","008_1_2","JDG","1","2","2","ויאמר יהוה יהודה יעלה הנה נתתי את הארץ בידו׃ ");
INSERT INTO heb_vpl VALUES ("JG1_3","008_1_3","JDG","1","3","3","ויאמר יהודה לשמעון אחיו עלה אתי בגורלי ונלחמה בכנעני והלכתי גם אני אתך בגורלך וילך אתו שמעון׃ ");
INSERT INTO heb_vpl VALUES ("JG1_4","008_1_4","JDG","1","4","4","ויעל יהודה ויתן יהוה את הכנעני והפרזי בידם ויכום בבזק עשרת אלפים איש׃ ");
INSERT INTO heb_vpl VALUES ("JG1_5","008_1_5","JDG","1","5","5","וימצאו את אדני בזק בבזק וילחמו בו ויכו את הכנעני ואת הפרזי׃ ");
INSERT INTO heb_vpl VALUES ("JG1_6","008_1_6","JDG","1","6","6","וינס אדני בזק וירדפו אחריו ויאחזו אתו ויקצצו את בהנות ידיו ורגליו׃ ");
INSERT INTO heb_vpl VALUES ("JG1_7","008_1_7","JDG","1","7","7","ויאמר אדני בזק שבעים מלכים בהנות ידיהם ורגליהם מקצצים היו מלקטים תחת שלחני כאשר עשיתי כן שלם לי אלהים ויביאהו ירושלם וימת שם׃ ");
INSERT INTO heb_vpl VALUES ("JG1_8","008_1_8","JDG","1","8","8","וילחמו בני יהודה בירושלם וילכדו אותה ויכוה לפי חרב ואת העיר שלחו באש׃ ");
INSERT INTO heb_vpl VALUES ("JG1_9","008_1_9","JDG","1","9","9","ואחר ירדו בני יהודה להלחם בכנעני יושב ההר והנגב והשפלה׃ ");
INSERT INTO heb_vpl VALUES ("JG1_10","008_1_10","JDG","1","10","10","וילך יהודה אל הכנעני היושב בחברון ושם חברון לפנים קרית ארבע ויכו את ששי ואת אחימן ואת תלמי׃ ");
INSERT INTO heb_vpl VALUES ("JG1_11","008_1_11","JDG","1","11","11","וילך משם אל יושבי דביר ושם דביר לפנים קרית ספר׃ ");
INSERT INTO heb_vpl VALUES ("JG1_12","008_1_12","JDG","1","12","12","ויאמר כלב אשר יכה את קרית ספר ולכדה ונתתי לו את עכסה בתי לאשה׃ ");
INSERT INTO heb_vpl VALUES ("JG1_13","008_1_13","JDG","1","13","13","וילכדה עתניאל בן קנז אחי כלב הקטן ממנו ויתן לו את עכסה בתו לאשה׃ ");
INSERT INTO heb_vpl VALUES ("JG1_14","008_1_14","JDG","1","14","14","ויהי בבואה ותסיתהו לשאול מאת אביה השדה ותצנח מעל החמור ויאמר לה כלב מה לך׃ ");
INSERT INTO heb_vpl VALUES ("JG1_15","008_1_15","JDG","1","15","15","ותאמר לו הבה לי ברכה כי ארץ הנגב נתתני ונתתה לי גלת מים ויתן לה כלב את גלת עלית ואת גלת תחתית׃ ");
INSERT INTO heb_vpl VALUES ("JG1_16","008_1_16","JDG","1","16","16","ובני קיני חתן משה עלו מעיר התמרים את בני יהודה מדבר יהודה אשר בנגב ערד וילך וישב את העם׃ ");
INSERT INTO heb_vpl VALUES ("JG1_17","008_1_17","JDG","1","17","17","וילך יהודה את שמעון אחיו ויכו את הכנעני יושב צפת ויחרימו אותה ויקרא את שם העיר חרמה׃ ");
INSERT INTO heb_vpl VALUES ("JG1_18","008_1_18","JDG","1","18","18","וילכד יהודה את עזה ואת גבולה ואת אשקלון ואת גבולה ואת עקרון ואת גבולה׃ ");
INSERT INTO heb_vpl VALUES ("JG1_19","008_1_19","JDG","1","19","19","ויהי יהוה את יהודה וירש את ההר כי לא להוריש את ישבי העמק כי רכב ברזל להם׃ ");
INSERT INTO heb_vpl VALUES ("JG1_20","008_1_20","JDG","1","20","20","ויתנו לכלב את חברון כאשר דבר משה ויורש משם את שלשה בני הענק׃ ");
INSERT INTO heb_vpl VALUES ("JG1_21","008_1_21","JDG","1","21","21","ואת היבוסי ישב ירושלם לא הורישו בני בנימן וישב היבוסי את בני בנימן בירושלם עד היום הזה׃ ");
INSERT INTO heb_vpl VALUES ("JG1_22","008_1_22","JDG","1","22","22","ויעלו בית יוסף גם הם בית אל ויהוה עמם׃ ");
INSERT INTO heb_vpl VALUES ("JG1_23","008_1_23","JDG","1","23","23","ויתירו בית יוסף בבית אל ושם העיר לפנים לוז׃ ");
INSERT INTO heb_vpl VALUES ("JG1_24","008_1_24","JDG","1","24","24","ויראו השמרים איש יוצא מן העיר ויאמרו לו הראנו נא את מבוא העיר ועשינו עמך חסד׃ ");
INSERT INTO heb_vpl VALUES ("JG1_25","008_1_25","JDG","1","25","25","ויראם את מבוא העיר ויכו את העיר לפי חרב ואת האיש ואת כל משפחתו שלחו׃ ");
INSERT INTO heb_vpl VALUES ("JG1_26","008_1_26","JDG","1","26","26","וילך האיש ארץ החתים ויבן עיר ויקרא שמה לוז הוא שמה עד היום הזה׃ ");
INSERT INTO heb_vpl VALUES ("JG1_27","008_1_27","JDG","1","27","27","ולא הוריש מנשה את בית שאן ואת בנותיה ואת תענך ואת בנתיה ואת ישב דור ואת בנותיה ואת יושבי יבלעם ואת בנתיה ואת יושבי מגדו ואת בנותיה ויואל הכנעני לשבת בארץ הזאת׃ ");
INSERT INTO heb_vpl VALUES ("JG1_28","008_1_28","JDG","1","28","28","ויהי כי חזק ישראל וישם את הכנעני למס והוריש לא הורישו׃ ");
INSERT INTO heb_vpl VALUES ("JG1_29","008_1_29","JDG","1","29","29","ואפרים לא הוריש את הכנעני היושב בגזר וישב הכנעני בקרבו בגזר׃ ");
INSERT INTO heb_vpl VALUES ("JG1_30","008_1_30","JDG","1","30","30","זבולן לא הוריש את יושבי קטרון ואת יושבי נהלל וישב הכנעני בקרבו ויהיו למס׃ ");
INSERT INTO heb_vpl VALUES ("JG1_31","008_1_31","JDG","1","31","31","אשר לא הוריש את ישבי עכו ואת יושבי צידון ואת אחלב ואת אכזיב ואת חלבה ואת אפיק ואת רחב׃ ");
INSERT INTO heb_vpl VALUES ("JG1_32","008_1_32","JDG","1","32","32","וישב האשרי בקרב הכנעני ישבי הארץ כי לא הורישו׃ ");
INSERT INTO heb_vpl VALUES ("JG1_33","008_1_33","JDG","1","33","33","נפתלי לא הוריש את ישבי בית שמש ואת ישבי בית ענת וישב בקרב הכנעני ישבי הארץ וישבי בית שמש ובית ענת היו להם למס׃ ");
INSERT INTO heb_vpl VALUES ("JG1_34","008_1_34","JDG","1","34","34","וילחצו האמרי את בני דן ההרה כי לא נתנו לרדת לעמק׃ ");
INSERT INTO heb_vpl VALUES ("JG1_35","008_1_35","JDG","1","35","35","ויואל האמרי לשבת בהר חרס באילון ובשעלבים ותכבד יד בית יוסף ויהיו למס׃ ");
INSERT INTO heb_vpl VALUES ("JG1_36","008_1_36","JDG","1","36","36","וגבול האמרי ממעלה עקרבים מהסלע ומעלה׃ ");
INSERT INTO heb_vpl VALUES ("JG2_1","008_2_1","JDG","2","1","1","ויעל מלאך יהוה מן הגלגל אל הבכים ויאמר אעלה אתכם ממצרים ואביא אתכם אל הארץ אשר נשבעתי לאבתיכם ואמר לא אפר בריתי אתכם לעולם׃ ");
INSERT INTO heb_vpl VALUES ("JG2_2","008_2_2","JDG","2","2","2","ואתם לא תכרתו ברית ליושבי הארץ הזאת מזבחותיהם תתצון ולא שמעתם בקלי מה זאת עשיתם׃ ");
INSERT INTO heb_vpl VALUES ("JG2_3","008_2_3","JDG","2","3","3","וגם אמרתי לא אגרש אותם מפניכם והיו לכם לצדים ואלהיהם יהיו לכם למוקש׃ ");
INSERT INTO heb_vpl VALUES ("JG2_4","008_2_4","JDG","2","4","4","ויהי כדבר מלאך יהוה את הדברים האלה אל כל בני ישראל וישאו העם את קולם ויבכו׃ ");
INSERT INTO heb_vpl VALUES ("JG2_5","008_2_5","JDG","2","5","5","ויקראו שם המקום ההוא בכים ויזבחו שם ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("JG2_6","008_2_6","JDG","2","6","6","וישלח יהושע את העם וילכו בני ישראל איש לנחלתו לרשת את הארץ׃ ");
INSERT INTO heb_vpl VALUES ("JG2_7","008_2_7","JDG","2","7","7","ויעבדו העם את יהוה כל ימי יהושע וכל ימי הזקנים אשר האריכו ימים אחרי יהושוע אשר ראו את כל מעשה יהוה הגדול אשר עשה לישראל׃ ");
INSERT INTO heb_vpl VALUES ("JG2_8","008_2_8","JDG","2","8","8","וימת יהושע בן נון עבד יהוה בן מאה ועשר שנים׃ ");
INSERT INTO heb_vpl VALUES ("JG2_9","008_2_9","JDG","2","9","9","ויקברו אותו בגבול נחלתו בתמנת חרס בהר אפרים מצפון להר געש׃ ");
INSERT INTO heb_vpl VALUES ("JG2_10","008_2_10","JDG","2","10","10","וגם כל הדור ההוא נאספו אל אבותיו ויקם דור אחר אחריהם אשר לא ידעו את יהוה וגם את המעשה אשר עשה לישראל׃ ");
INSERT INTO heb_vpl VALUES ("JG2_11","008_2_11","JDG","2","11","11","ויעשו בני ישראל את הרע בעיני יהוה ויעבדו את הבעלים׃ ");
INSERT INTO heb_vpl VALUES ("JG2_12","008_2_12","JDG","2","12","12","ויעזבו את יהוה אלהי אבותם המוציא אותם מארץ מצרים וילכו אחרי אלהים אחרים מאלהי העמים אשר סביבותיהם וישתחוו להם ויכעסו את יהוה׃ ");
INSERT INTO heb_vpl VALUES ("JG2_13","008_2_13","JDG","2","13","13","ויעזבו את יהוה ויעבדו לבעל ולעשתרות׃ ");
INSERT INTO heb_vpl VALUES ("JG2_14","008_2_14","JDG","2","14","14","ויחר אף יהוה בישראל ויתנם ביד שסים וישסו אותם וימכרם ביד אויביהם מסביב ולא יכלו עוד לעמד לפני אויביהם׃ ");
INSERT INTO heb_vpl VALUES ("JG2_15","008_2_15","JDG","2","15","15","בכל אשר יצאו יד יהוה היתה בם לרעה כאשר דבר יהוה וכאשר נשבע יהוה להם ויצר להם מאד׃ ");
INSERT INTO heb_vpl VALUES ("JG2_16","008_2_16","JDG","2","16","16","ויקם יהוה שפטים ויושיעום מיד שסיהם׃ ");
INSERT INTO heb_vpl VALUES ("JG2_17","008_2_17","JDG","2","17","17","וגם אל שפטיהם לא שמעו כי זנו אחרי אלהים אחרים וישתחוו להם סרו מהר מן הדרך אשר הלכו אבותם לשמע מצות יהוה לא עשו כן׃ ");
INSERT INTO heb_vpl VALUES ("JG2_18","008_2_18","JDG","2","18","18","וכי הקים יהוה להם שפטים והיה יהוה עם השפט והושיעם מיד איביהם כל ימי השופט כי ינחם יהוה מנאקתם מפני לחציהם ודחקיהם׃ ");
INSERT INTO heb_vpl VALUES ("JG2_19","008_2_19","JDG","2","19","19","והיה במות השופט ישבו והשחיתו מאבותם ללכת אחרי אלהים אחרים לעבדם ולהשתחות להם לא הפילו ממעלליהם ומדרכם הקשה׃ ");
INSERT INTO heb_vpl VALUES ("JG2_20","008_2_20","JDG","2","20","20","ויחר אף יהוה בישראל ויאמר יען אשר עברו הגוי הזה את בריתי אשר צויתי את אבותם ולא שמעו לקולי׃ ");
INSERT INTO heb_vpl VALUES ("JG2_21","008_2_21","JDG","2","21","21","גם אני לא אוסיף להוריש איש מפניהם מן הגוים אשר עזב יהושע וימת׃ ");
INSERT INTO heb_vpl VALUES ("JG2_22","008_2_22","JDG","2","22","22","למען נסות בם את ישראל השמרים הם את דרך יהוה ללכת בם כאשר שמרו אבותם אם לא׃ ");
INSERT INTO heb_vpl VALUES ("JG2_23","008_2_23","JDG","2","23","23","וינח יהוה את הגוים האלה לבלתי הורישם מהר ולא נתנם ביד יהושע׃ ");
INSERT INTO heb_vpl VALUES ("JG3_1","008_3_1","JDG","3","1","1","ואלה הגוים אשר הניח יהוה לנסות בם את ישראל את כל אשר לא ידעו את כל מלחמות כנען׃ ");
INSERT INTO heb_vpl VALUES ("JG3_2","008_3_2","JDG","3","2","2","רק למען דעת דרות בני ישראל ללמדם מלחמה רק אשר לפנים לא ידעום׃ ");
INSERT INTO heb_vpl VALUES ("JG3_3","008_3_3","JDG","3","3","3","חמשת סרני פלשתים וכל הכנעני והצידני והחוי ישב הר הלבנון מהר בעל חרמון עד לבוא חמת׃ ");
INSERT INTO heb_vpl VALUES ("JG3_4","008_3_4","JDG","3","4","4","ויהיו לנסות בם את ישראל לדעת הישמעו את מצות יהוה אשר צוה את אבותם ביד משה׃ ");
INSERT INTO heb_vpl VALUES ("JG3_5","008_3_5","JDG","3","5","5","ובני ישראל ישבו בקרב הכנעני החתי והאמרי והפרזי והחוי והיבוסי׃ ");
INSERT INTO heb_vpl VALUES ("JG3_6","008_3_6","JDG","3","6","6","ויקחו את בנותיהם להם לנשים ואת בנותיהם נתנו לבניהם ויעבדו את אלהיהם׃ ");
INSERT INTO heb_vpl VALUES ("JG3_7","008_3_7","JDG","3","7","7","ויעשו בני ישראל את הרע בעיני יהוה וישכחו את יהוה אלהיהם ויעבדו את הבעלים ואת האשרות׃ ");
INSERT INTO heb_vpl VALUES ("JG3_8","008_3_8","JDG","3","8","8","ויחר אף יהוה בישראל וימכרם ביד כושן רשעתים מלך ארם נהרים ויעבדו בני ישראל את כושן רשעתים שמנה שנים׃ ");
INSERT INTO heb_vpl VALUES ("JG3_9","008_3_9","JDG","3","9","9","ויזעקו בני ישראל אל יהוה ויקם יהוה מושיע לבני ישראל ויושיעם את עתניאל בן קנז אחי כלב הקטן ממנו׃ ");
INSERT INTO heb_vpl VALUES ("JG3_10","008_3_10","JDG","3","10","10","ותהי עליו רוח יהוה וישפט את ישראל ויצא למלחמה ויתן יהוה בידו את כושן רשעתים מלך ארם ותעז ידו על כושן רשעתים׃ ");
INSERT INTO heb_vpl VALUES ("JG3_11","008_3_11","JDG","3","11","11","ותשקט הארץ ארבעים שנה וימת עתניאל בן קנז׃ ");
INSERT INTO heb_vpl VALUES ("JG3_12","008_3_12","JDG","3","12","12","ויספו בני ישראל לעשות הרע בעיני יהוה ויחזק יהוה את עגלון מלך מואב על ישראל על כי עשו את הרע בעיני יהוה׃ ");
INSERT INTO heb_vpl VALUES ("JG3_13","008_3_13","JDG","3","13","13","ויאסף אליו את בני עמון ועמלק וילך ויך את ישראל ויירשו את עיר התמרים׃ ");
INSERT INTO heb_vpl VALUES ("JG3_14","008_3_14","JDG","3","14","14","ויעבדו בני ישראל את עגלון מלך מואב שמונה עשרה שנה׃ ");
INSERT INTO heb_vpl VALUES ("JG3_15","008_3_15","JDG","3","15","15","ויזעקו בני ישראל אל יהוה ויקם יהוה להם מושיע את אהוד בן גרא בן הימיני איש אטר יד ימינו וישלחו בני ישראל בידו מנחה לעגלון מלך מואב׃ ");
INSERT INTO heb_vpl VALUES ("JG3_16","008_3_16","JDG","3","16","16","ויעש לו אהוד חרב ולה שני פיות גמד ארכה ויחגר אותה מתחת למדיו על ירך ימינו׃ ");
INSERT INTO heb_vpl VALUES ("JG3_17","008_3_17","JDG","3","17","17","ויקרב את המנחה לעגלון מלך מואב ועגלון איש בריא מאד׃ ");
INSERT INTO heb_vpl VALUES ("JG3_18","008_3_18","JDG","3","18","18","ויהי כאשר כלה להקריב את המנחה וישלח את העם נשאי המנחה׃ ");
INSERT INTO heb_vpl VALUES ("JG3_19","008_3_19","JDG","3","19","19","והוא שב מן הפסילים אשר את הגלגל ויאמר דבר סתר לי אליך המלך ויאמר הס ויצאו מעליו כל העמדים עליו׃ ");
INSERT INTO heb_vpl VALUES ("JG3_20","008_3_20","JDG","3","20","20","ואהוד בא אליו והוא ישב בעלית המקרה אשר לו לבדו ויאמר אהוד דבר אלהים לי אליך ויקם מעל הכסא׃ ");
INSERT INTO heb_vpl VALUES ("JG3_21","008_3_21","JDG","3","21","21","וישלח אהוד את יד שמאלו ויקח את החרב מעל ירך ימינו ויתקעה בבטנו׃ ");
INSERT INTO heb_vpl VALUES ("JG3_22","008_3_22","JDG","3","22","22","ויבא גם הנצב אחר הלהב ויסגר החלב בעד הלהב כי לא שלף החרב מבטנו ויצא הפרשדנה׃ ");
INSERT INTO heb_vpl VALUES ("JG3_23","008_3_23","JDG","3","23","23","ויצא אהוד המסדרונה ויסגר דלתות העליה בעדו ונעל׃ ");
INSERT INTO heb_vpl VALUES ("JG3_24","008_3_24","JDG","3","24","24","והוא יצא ועבדיו באו ויראו והנה דלתות העליה נעלות ויאמרו אך מסיך הוא את רגליו בחדר המקרה׃ ");
INSERT INTO heb_vpl VALUES ("JG3_25","008_3_25","JDG","3","25","25","ויחילו עד בוש והנה איננו פתח דלתות העליה ויקחו את המפתח ויפתחו והנה אדניהם נפל ארצה מת׃ ");
INSERT INTO heb_vpl VALUES ("JG3_26","008_3_26","JDG","3","26","26","ואהוד נמלט עד התמהמהם והוא עבר את הפסילים וימלט השעירתה׃ ");
INSERT INTO heb_vpl VALUES ("JG3_27","008_3_27","JDG","3","27","27","ויהי בבואו ויתקע בשופר בהר אפרים וירדו עמו בני ישראל מן ההר והוא לפניהם׃ ");
INSERT INTO heb_vpl VALUES ("JG3_28","008_3_28","JDG","3","28","28","ויאמר אלהם רדפו אחרי כי נתן יהוה את איביכם את מואב בידכם וירדו אחריו וילכדו את מעברות הירדן למואב ולא נתנו איש לעבר׃ ");
INSERT INTO heb_vpl VALUES ("JG3_29","008_3_29","JDG","3","29","29","ויכו את מואב בעת ההיא כעשרת אלפים איש כל שמן וכל איש חיל ולא נמלט איש׃ ");
INSERT INTO heb_vpl VALUES ("JG3_30","008_3_30","JDG","3","30","30","ותכנע מואב ביום ההוא תחת יד ישראל ותשקט הארץ שמונים שנה׃ ");
INSERT INTO heb_vpl VALUES ("JG3_31","008_3_31","JDG","3","31","31","ואחריו היה שמגר בן ענת ויך את פלשתים שש מאות איש במלמד הבקר וישע גם הוא את ישראל׃ ");
INSERT INTO heb_vpl VALUES ("JG4_1","008_4_1","JDG","4","1","1","ויספו בני ישראל לעשות הרע בעיני יהוה ואהוד מת׃ ");
INSERT INTO heb_vpl VALUES ("JG4_2","008_4_2","JDG","4","2","2","וימכרם יהוה ביד יבין מלך כנען אשר מלך בחצור ושר צבאו סיסרא והוא יושב בחרשת הגוים׃ ");
INSERT INTO heb_vpl VALUES ("JG4_3","008_4_3","JDG","4","3","3","ויצעקו בני ישראל אל יהוה כי תשע מאות רכב ברזל לו והוא לחץ את בני ישראל בחזקה עשרים שנה׃ ");
INSERT INTO heb_vpl VALUES ("JG4_4","008_4_4","JDG","4","4","4","ודבורה אשה נביאה אשת לפידות היא שפטה את ישראל בעת ההיא׃ ");
INSERT INTO heb_vpl VALUES ("JG4_5","008_4_5","JDG","4","5","5","והיא יושבת תחת תמר דבורה בין הרמה ובין בית אל בהר אפרים ויעלו אליה בני ישראל למשפט׃ ");
INSERT INTO heb_vpl VALUES ("JG4_6","008_4_6","JDG","4","6","6","ותשלח ותקרא לברק בן אבינעם מקדש נפתלי ותאמר אליו הלא צוה יהוה אלהי ישראל לך ומשכת בהר תבור ולקחת עמך עשרת אלפים איש מבני נפתלי ומבני זבלון׃ ");
INSERT INTO heb_vpl VALUES ("JG4_7","008_4_7","JDG","4","7","7","ומשכתי אליך אל נחל קישון את סיסרא שר צבא יבין ואת רכבו ואת המונו ונתתיהו בידך׃ ");
INSERT INTO heb_vpl VALUES ("JG4_8","008_4_8","JDG","4","8","8","ויאמר אליה ברק אם תלכי עמי והלכתי ואם לא תלכי עמי לא אלך׃ ");
INSERT INTO heb_vpl VALUES ("JG4_9","008_4_9","JDG","4","9","9","ותאמר הלך אלך עמך אפס כי לא תהיה תפארתך על הדרך אשר אתה הולך כי ביד אשה ימכר יהוה את סיסרא ותקם דבורה ותלך עם ברק קדשה׃ ");
INSERT INTO heb_vpl VALUES ("JG4_10","008_4_10","JDG","4","10","10","ויזעק ברק את זבולן ואת נפתלי קדשה ויעל ברגליו עשרת אלפי איש ותעל עמו דבורה׃ ");
INSERT INTO heb_vpl VALUES ("JG4_11","008_4_11","JDG","4","11","11","וחבר הקיני נפרד מקין מבני חבב חתן משה ויט אהלו עד אלון בצענים אשר את קדש׃ ");
INSERT INTO heb_vpl VALUES ("JG4_12","008_4_12","JDG","4","12","12","ויגדו לסיסרא כי עלה ברק בן אבינעם הר תבור׃ ");
INSERT INTO heb_vpl VALUES ("JG4_13","008_4_13","JDG","4","13","13","ויזעק סיסרא את כל רכבו תשע מאות רכב ברזל ואת כל העם אשר אתו מחרשת הגוים אל נחל קישון׃ ");
INSERT INTO heb_vpl VALUES ("JG4_14","008_4_14","JDG","4","14","14","ותאמר דברה אל ברק קום כי זה היום אשר נתן יהוה את סיסרא בידך הלא יהוה יצא לפניך וירד ברק מהר תבור ועשרת אלפים איש אחריו׃ ");
INSERT INTO heb_vpl VALUES ("JG4_15","008_4_15","JDG","4","15","15","ויהם יהוה את סיסרא ואת כל הרכב ואת כל המחנה לפי חרב לפני ברק וירד סיסרא מעל המרכבה וינס ברגליו׃ ");
INSERT INTO heb_vpl VALUES ("JG4_16","008_4_16","JDG","4","16","16","וברק רדף אחרי הרכב ואחרי המחנה עד חרשת הגוים ויפל כל מחנה סיסרא לפי חרב לא נשאר עד אחד׃ ");
INSERT INTO heb_vpl VALUES ("JG4_17","008_4_17","JDG","4","17","17","וסיסרא נס ברגליו אל אהל יעל אשת חבר הקיני כי שלום בין יבין מלך חצור ובין בית חבר הקיני׃ ");
INSERT INTO heb_vpl VALUES ("JG4_18","008_4_18","JDG","4","18","18","ותצא יעל לקראת סיסרא ותאמר אליו סורה אדני סורה אלי אל תירא ויסר אליה האהלה ותכסהו בשמיכה׃ ");
INSERT INTO heb_vpl VALUES ("JG4_19","008_4_19","JDG","4","19","19","ויאמר אליה השקיני נא מעט מים כי צמאתי ותפתח את נאוד החלב ותשקהו ותכסהו׃ ");
INSERT INTO heb_vpl VALUES ("JG4_20","008_4_20","JDG","4","20","20","ויאמר אליה עמד פתח האהל והיה אם איש יבוא ושאלך ואמר היש פה איש ואמרת אין׃ ");
INSERT INTO heb_vpl VALUES ("JG4_21","008_4_21","JDG","4","21","21","ותקח יעל אשת חבר את יתד האהל ותשם את המקבת בידה ותבוא אליו בלאט ותתקע את היתד ברקתו ותצנח בארץ והוא נרדם ויעף וימת׃ ");
INSERT INTO heb_vpl VALUES ("JG4_22","008_4_22","JDG","4","22","22","והנה ברק רדף את סיסרא ותצא יעל לקראתו ותאמר לו לך ואראך את האיש אשר אתה מבקש ויבא אליה והנה סיסרא נפל מת והיתד ברקתו׃ ");
INSERT INTO heb_vpl VALUES ("JG4_23","008_4_23","JDG","4","23","23","ויכנע אלהים ביום ההוא את יבין מלך כנען לפני בני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("JG4_24","008_4_24","JDG","4","24","24","ותלך יד בני ישראל הלוך וקשה על יבין מלך כנען עד אשר הכריתו את יבין מלך כנען׃ ");
INSERT INTO heb_vpl VALUES ("JG5_1","008_5_1","JDG","5","1","1","ותשר דבורה וברק בן אבינעם ביום ההוא לאמר׃ ");
INSERT INTO heb_vpl VALUES ("JG5_2","008_5_2","JDG","5","2","2","בפרע פרעות בישראל בהתנדב עם ברכו יהוה׃ ");
INSERT INTO heb_vpl VALUES ("JG5_3","008_5_3","JDG","5","3","3","שמעו מלכים האזינו רזנים אנכי ליהוה אנכי אשירה אזמר ליהוה אלהי ישראל׃ ");
INSERT INTO heb_vpl VALUES ("JG5_4","008_5_4","JDG","5","4","4","יהוה בצאתך משעיר בצעדך משדה אדום ארץ רעשה גם שמים נטפו גם עבים נטפו מים׃ ");
INSERT INTO heb_vpl VALUES ("JG5_5","008_5_5","JDG","5","5","5","הרים נזלו מפני יהוה זה סיני מפני יהוה אלהי ישראל׃ ");
INSERT INTO heb_vpl VALUES ("JG5_6","008_5_6","JDG","5","6","6","בימי שמגר בן ענת בימי יעל חדלו ארחות והלכי נתיבות ילכו ארחות עקלקלות׃ ");
INSERT INTO heb_vpl VALUES ("JG5_7","008_5_7","JDG","5","7","7","חדלו פרזון בישראל חדלו עד שקמתי דבורה שקמתי אם בישראל׃ ");
INSERT INTO heb_vpl VALUES ("JG5_8","008_5_8","JDG","5","8","8","יבחר אלהים חדשים אז לחם שערים מגן אם יראה ורמח בארבעים אלף בישראל׃ ");
INSERT INTO heb_vpl VALUES ("JG5_9","008_5_9","JDG","5","9","9","לבי לחוקקי ישראל המתנדבים בעם ברכו יהוה׃ ");
INSERT INTO heb_vpl VALUES ("JG5_10","008_5_10","JDG","5","10","10","רכבי אתנות צחרות ישבי על מדין והלכי על דרך שיחו׃ ");
INSERT INTO heb_vpl VALUES ("JG5_11","008_5_11","JDG","5","11","11","מקול מחצצים בין משאבים שם יתנו צדקות יהוה צדקת פרזנו בישראל אז ירדו לשערים עם יהוה׃ ");
INSERT INTO heb_vpl VALUES ("JG5_12","008_5_12","JDG","5","12","12","עורי עורי דבורה עורי עורי דברי שיר קום ברק ושבה שביך בן אבינעם׃ ");
INSERT INTO heb_vpl VALUES ("JG5_13","008_5_13","JDG","5","13","13","אז ירד שריד לאדירים עם יהוה ירד לי בגבורים׃ ");
INSERT INTO heb_vpl VALUES ("JG5_14","008_5_14","JDG","5","14","14","מני אפרים שרשם בעמלק אחריך בנימין בעממיך מני מכיר ירדו מחקקים ומזבולן משכים בשבט ספר׃ ");
INSERT INTO heb_vpl VALUES ("JG5_15","008_5_15","JDG","5","15","15","ושרי ביששכר עם דברה ויששכר כן ברק בעמק שלח ברגליו בפלגות ראובן גדלים חקקי לב׃ ");
INSERT INTO heb_vpl VALUES ("JG5_16","008_5_16","JDG","5","16","16","למה ישבת בין המשפתים לשמע שרקות עדרים לפלגות ראובן גדולים חקרי לב׃ ");
INSERT INTO heb_vpl VALUES ("JG5_17","008_5_17","JDG","5","17","17","גלעד בעבר הירדן שכן ודן למה יגור אניות אשר ישב לחוף ימים ועל מפרציו ישכון׃ ");
INSERT INTO heb_vpl VALUES ("JG5_18","008_5_18","JDG","5","18","18","זבלון עם חרף נפשו למות ונפתלי על מרומי שדה׃ ");
INSERT INTO heb_vpl VALUES ("JG5_19","008_5_19","JDG","5","19","19","באו מלכים נלחמו אז נלחמו מלכי כנען בתענך על מי מגדו בצע כסף לא לקחו׃ ");
INSERT INTO heb_vpl VALUES ("JG5_20","008_5_20","JDG","5","20","20","מן שמים נלחמו הכוכבים ממסלותם נלחמו עם סיסרא׃ ");
INSERT INTO heb_vpl VALUES ("JG5_21","008_5_21","JDG","5","21","21","נחל קישון גרפם נחל קדומים נחל קישון תדרכי נפשי עז׃ ");
INSERT INTO heb_vpl VALUES ("JG5_22","008_5_22","JDG","5","22","22","אז הלמו עקבי סוס מדהרות דהרות אביריו׃ ");
INSERT INTO heb_vpl VALUES ("JG5_23","008_5_23","JDG","5","23","23","אורו מרוז אמר מלאך יהוה ארו ארור ישביה כי לא באו לעזרת יהוה לעזרת יהוה בגבורים׃ ");
INSERT INTO heb_vpl VALUES ("JG5_24","008_5_24","JDG","5","24","24","תברך מנשים יעל אשת חבר הקיני מנשים באהל תברך׃ ");
INSERT INTO heb_vpl VALUES ("JG5_25","008_5_25","JDG","5","25","25","מים שאל חלב נתנה בספל אדירים הקריבה חמאה׃ ");
INSERT INTO heb_vpl VALUES ("JG5_26","008_5_26","JDG","5","26","26","ידה ליתד תשלחנה וימינה להלמות עמלים והלמה סיסרא מחקה ראשו ומחצה וחלפה רקתו׃ ");
INSERT INTO heb_vpl VALUES ("JG5_27","008_5_27","JDG","5","27","27","בין רגליה כרע נפל שכב בין רגליה כרע נפל באשר כרע שם נפל שדוד׃ ");
INSERT INTO heb_vpl VALUES ("JG5_28","008_5_28","JDG","5","28","28","בעד החלון נשקפה ותיבב אם סיסרא בעד האשנב מדוע בשש רכבו לבוא מדוע אחרו פעמי מרכבותיו׃ ");
INSERT INTO heb_vpl VALUES ("JG5_29","008_5_29","JDG","5","29","29","חכמות שרותיה תענינה אף היא תשיב אמריה לה׃ ");
INSERT INTO heb_vpl VALUES ("JG5_30","008_5_30","JDG","5","30","30","הלא ימצאו יחלקו שלל רחם רחמתים לראש גבר שלל צבעים לסיסרא שלל צבעים רקמה צבע רקמתים לצוארי שלל׃ ");
INSERT INTO heb_vpl VALUES ("JG5_31","008_5_31","JDG","5","31","31","כן יאבדו כל אויביך יהוה ואהביו כצאת השמש בגברתו ותשקט הארץ ארבעים שנה׃ ");
INSERT INTO heb_vpl VALUES ("JG6_1","008_6_1","JDG","6","1","1","ויעשו בני ישראל הרע בעיני יהוה ויתנם יהוה ביד מדין שבע שנים׃ ");
INSERT INTO heb_vpl VALUES ("JG6_2","008_6_2","JDG","6","2","2","ותעז יד מדין על ישראל מפני מדין עשו להם בני ישראל את המנהרות אשר בהרים ואת המערות ואת המצדות׃ ");
INSERT INTO heb_vpl VALUES ("JG6_3","008_6_3","JDG","6","3","3","והיה אם זרע ישראל ועלה מדין ועמלק ובני קדם ועלו עליו׃ ");
INSERT INTO heb_vpl VALUES ("JG6_4","008_6_4","JDG","6","4","4","ויחנו עליהם וישחיתו את יבול הארץ עד בואך עזה ולא ישאירו מחיה בישראל ושה ושור וחמור׃ ");
INSERT INTO heb_vpl VALUES ("JG6_5","008_6_5","JDG","6","5","5","כי הם ומקניהם יעלו ואהליהם יבאו כדי ארבה לרב ולהם ולגמליהם אין מספר ויבאו בארץ לשחתה׃ ");
INSERT INTO heb_vpl VALUES ("JG6_6","008_6_6","JDG","6","6","6","וידל ישראל מאד מפני מדין ויזעקו בני ישראל אל יהוה׃ ");
INSERT INTO heb_vpl VALUES ("JG6_7","008_6_7","JDG","6","7","7","ויהי כי זעקו בני ישראל אל יהוה על אדות מדין׃ ");
INSERT INTO heb_vpl VALUES ("JG6_8","008_6_8","JDG","6","8","8","וישלח יהוה איש נביא אל בני ישראל ויאמר להם כה אמר יהוה אלהי ישראל אנכי העליתי אתכם ממצרים ואציא אתכם מבית עבדים׃ ");
INSERT INTO heb_vpl VALUES ("JG6_9","008_6_9","JDG","6","9","9","ואצל אתכם מיד מצרים ומיד כל לחציכם ואגרש אותם מפניכם ואתנה לכם את ארצם׃ ");
INSERT INTO heb_vpl VALUES ("JG6_10","008_6_10","JDG","6","10","10","ואמרה לכם אני יהוה אלהיכם לא תיראו את אלהי האמרי אשר אתם יושבים בארצם ולא שמעתם בקולי׃ ");
INSERT INTO heb_vpl VALUES ("JG6_11","008_6_11","JDG","6","11","11","ויבא מלאך יהוה וישב תחת האלה אשר בעפרה אשר ליואש אבי העזרי וגדעון בנו חבט חטים בגת להניס מפני מדין׃ ");
INSERT INTO heb_vpl VALUES ("JG6_12","008_6_12","JDG","6","12","12","וירא אליו מלאך יהוה ויאמר אליו יהוה עמך גבור החיל׃ ");
INSERT INTO heb_vpl VALUES ("JG6_13","008_6_13","JDG","6","13","13","ויאמר אליו גדעון בי אדני ויש יהוה עמנו ולמה מצאתנו כל זאת ואיה כל נפלאתיו אשר ספרו לנו אבותינו לאמר הלא ממצרים העלנו יהוה ועתה נטשנו יהוה ויתננו בכף מדין׃ ");
INSERT INTO heb_vpl VALUES ("JG6_14","008_6_14","JDG","6","14","14","ויפן אליו יהוה ויאמר לך בכחך זה והושעת את ישראל מכף מדין הלא שלחתיך׃ ");
INSERT INTO heb_vpl VALUES ("JG6_15","008_6_15","JDG","6","15","15","ויאמר אליו בי אדני במה אושיע את ישראל הנה אלפי הדל במנשה ואנכי הצעיר בבית אבי׃ ");
INSERT INTO heb_vpl VALUES ("JG6_16","008_6_16","JDG","6","16","16","ויאמר אליו יהוה כי אהיה עמך והכית את מדין כאיש אחד׃ ");
INSERT INTO heb_vpl VALUES ("JG6_17","008_6_17","JDG","6","17","17","ויאמר אליו אם נא מצאתי חן בעיניך ועשית לי אות שאתה מדבר עמי׃ ");
INSERT INTO heb_vpl VALUES ("JG6_18","008_6_18","JDG","6","18","18","אל נא תמש מזה עד באי אליך והצאתי את מנחתי והנחתי לפניך ויאמר אנכי אשב עד שובך׃ ");
INSERT INTO heb_vpl VALUES ("JG6_19","008_6_19","JDG","6","19","19","וגדעון בא ויעש גדי עזים ואיפת קמח מצות הבשר שם בסל והמרק שם בפרור ויוצא אליו אל תחת האלה ויגש׃ ");
INSERT INTO heb_vpl VALUES ("JG6_20","008_6_20","JDG","6","20","20","ויאמר אליו מלאך האלהים קח את הבשר ואת המצות והנח אל הסלע הלז ואת המרק שפוך ויעש כן׃ ");
INSERT INTO heb_vpl VALUES ("JG6_21","008_6_21","JDG","6","21","21","וישלח מלאך יהוה את קצה המשענת אשר בידו ויגע בבשר ובמצות ותעל האש מן הצור ותאכל את הבשר ואת המצות ומלאך יהוה הלך מעיניו׃ ");
INSERT INTO heb_vpl VALUES ("JG6_22","008_6_22","JDG","6","22","22","וירא גדעון כי מלאך יהוה הוא ויאמר גדעון אהה אדני יהוה כי על כן ראיתי מלאך יהוה פנים אל פנים׃ ");
INSERT INTO heb_vpl VALUES ("JG6_23","008_6_23","JDG","6","23","23","ויאמר לו יהוה שלום לך אל תירא לא תמות׃ ");
INSERT INTO heb_vpl VALUES ("JG6_24","008_6_24","JDG","6","24","24","ויבן שם גדעון מזבח ליהוה ויקרא לו יהוה שלום עד היום הזה עודנו בעפרת אבי העזרי׃ ");
INSERT INTO heb_vpl VALUES ("JG6_25","008_6_25","JDG","6","25","25","ויהי בלילה ההוא ויאמר לו יהוה קח את פר השור אשר לאביך ופר השני שבע שנים והרסת את מזבח הבעל אשר לאביך ואת האשרה אשר עליו תכרת׃ ");
INSERT INTO heb_vpl VALUES ("JG6_26","008_6_26","JDG","6","26","26","ובנית מזבח ליהוה אלהיך על ראש המעוז הזה במערכה ולקחת את הפר השני והעלית עולה בעצי האשרה אשר תכרת׃ ");
INSERT INTO heb_vpl VALUES ("JG6_27","008_6_27","JDG","6","27","27","ויקח גדעון עשרה אנשים מעבדיו ויעש כאשר דבר אליו יהוה ויהי כאשר ירא את בית אביו ואת אנשי העיר מעשות יומם ויעש לילה׃ ");
INSERT INTO heb_vpl VALUES ("JG6_28","008_6_28","JDG","6","28","28","וישכימו אנשי העיר בבקר והנה נתץ מזבח הבעל והאשרה אשר עליו כרתה ואת הפר השני העלה על המזבח הבנוי׃ ");
INSERT INTO heb_vpl VALUES ("JG6_29","008_6_29","JDG","6","29","29","ויאמרו איש אל רעהו מי עשה הדבר הזה וידרשו ויבקשו ויאמרו גדעון בן יואש עשה הדבר הזה׃ ");
INSERT INTO heb_vpl VALUES ("JG6_30","008_6_30","JDG","6","30","30","ויאמרו אנשי העיר אל יואש הוצא את בנך וימת כי נתץ את מזבח הבעל וכי כרת האשרה אשר עליו׃ ");
INSERT INTO heb_vpl VALUES ("JG6_31","008_6_31","JDG","6","31","31","ויאמר יואש לכל אשר עמדו עליו האתם תריבון לבעל אם אתם תושיעון אותו אשר יריב לו יומת עד הבקר אם אלהים הוא ירב לו כי נתץ את מזבחו׃ ");
INSERT INTO heb_vpl VALUES ("JG6_32","008_6_32","JDG","6","32","32","ויקרא לו ביום ההוא ירבעל לאמר ירב בו הבעל כי נתץ את מזבחו׃ ");
INSERT INTO heb_vpl VALUES ("JG6_33","008_6_33","JDG","6","33","33","וכל מדין ועמלק ובני קדם נאספו יחדו ויעברו ויחנו בעמק יזרעאל׃ ");
INSERT INTO heb_vpl VALUES ("JG6_34","008_6_34","JDG","6","34","34","ורוח יהוה לבשה את גדעון ויתקע בשופר ויזעק אביעזר אחריו׃ ");
INSERT INTO heb_vpl VALUES ("JG6_35","008_6_35","JDG","6","35","35","ומלאכים שלח בכל מנשה ויזעק גם הוא אחריו ומלאכים שלח באשר ובזבלון ובנפתלי ויעלו לקראתם׃ ");
INSERT INTO heb_vpl VALUES ("JG6_36","008_6_36","JDG","6","36","36","ויאמר גדעון אל האלהים אם ישך מושיע בידי את ישראל כאשר דברת׃ ");
INSERT INTO heb_vpl VALUES ("JG6_37","008_6_37","JDG","6","37","37","הנה אנכי מציג את גזת הצמר בגרן אם טל יהיה על הגזה לבדה ועל כל הארץ חרב וידעתי כי תושיע בידי את ישראל כאשר דברת׃ ");
INSERT INTO heb_vpl VALUES ("JG6_38","008_6_38","JDG","6","38","38","ויהי כן וישכם ממחרת ויזר את הגזה וימץ טל מן הגזה מלוא הספל מים׃ ");
INSERT INTO heb_vpl VALUES ("JG6_39","008_6_39","JDG","6","39","39","ויאמר גדעון אל האלהים אל יחר אפך בי ואדברה אך הפעם אנסה נא רק הפעם בגזה יהי נא חרב אל הגזה לבדה ועל כל הארץ יהיה טל׃ ");
INSERT INTO heb_vpl VALUES ("JG6_40","008_6_40","JDG","6","40","40","ויעש אלהים כן בלילה ההוא ויהי חרב אל הגזה לבדה ועל כל הארץ היה טל׃ ");
INSERT INTO heb_vpl VALUES ("JG7_1","008_7_1","JDG","7","1","1","וישכם ירבעל הוא גדעון וכל העם אשר אתו ויחנו על עין חרד ומחנה מדין היה לו מצפון מגבעת המורה בעמק׃ ");
INSERT INTO heb_vpl VALUES ("JG7_2","008_7_2","JDG","7","2","2","ויאמר יהוה אל גדעון רב העם אשר אתך מתתי את מדין בידם פן יתפאר עלי ישראל לאמר ידי הושיעה לי׃ ");
INSERT INTO heb_vpl VALUES ("JG7_3","008_7_3","JDG","7","3","3","ועתה קרא נא באזני העם לאמר מי ירא וחרד ישב ויצפר מהר הגלעד וישב מן העם עשרים ושנים אלף ועשרת אלפים נשארו׃ ");
INSERT INTO heb_vpl VALUES ("JG7_4","008_7_4","JDG","7","4","4","ויאמר יהוה אל גדעון עוד העם רב הורד אותם אל המים ואצרפנו לך שם והיה אשר אמר אליך זה ילך אתך הוא ילך אתך וכל אשר אמר אליך זה לא ילך עמך הוא לא ילך׃ ");
INSERT INTO heb_vpl VALUES ("JG7_5","008_7_5","JDG","7","5","5","ויורד את העם אל המים ויאמר יהוה אל גדעון כל אשר ילק בלשונו מן המים כאשר ילק הכלב תציג אותו לבד וכל אשר יכרע על ברכיו לשתות׃ ");
INSERT INTO heb_vpl VALUES ("JG7_6","008_7_6","JDG","7","6","6","ויהי מספר המלקקים בידם אל פיהם שלש מאות איש וכל יתר העם כרעו על ברכיהם לשתות מים׃ ");
INSERT INTO heb_vpl VALUES ("JG7_7","008_7_7","JDG","7","7","7","ויאמר יהוה אל גדעון בשלש מאות האיש המלקקים אושיע אתכם ונתתי את מדין בידך וכל העם ילכו איש למקמו׃ ");
INSERT INTO heb_vpl VALUES ("JG7_8","008_7_8","JDG","7","8","8","ויקחו את צדה העם בידם ואת שופרתיהם ואת כל איש ישראל שלח איש לאהליו ובשלש מאות האיש החזיק ומחנה מדין היה לו מתחת בעמק׃ ");
INSERT INTO heb_vpl VALUES ("JG7_9","008_7_9","JDG","7","9","9","ויהי בלילה ההוא ויאמר אליו יהוה קום רד במחנה כי נתתיו בידך׃ ");
INSERT INTO heb_vpl VALUES ("JG7_10","008_7_10","JDG","7","10","10","ואם ירא אתה לרדת רד אתה ופרה נערך אל המחנה׃ ");
INSERT INTO heb_vpl VALUES ("JG7_11","008_7_11","JDG","7","11","11","ושמעת מה ידברו ואחר תחזקנה ידיך וירדת במחנה וירד הוא ופרה נערו אל קצה החמשים אשר במחנה׃ ");
INSERT INTO heb_vpl VALUES ("JG7_12","008_7_12","JDG","7","12","12","ומדין ועמלק וכל בני קדם נפלים בעמק כארבה לרב ולגמליהם אין מספר כחול שעל שפת הים לרב׃ ");
INSERT INTO heb_vpl VALUES ("JG7_13","008_7_13","JDG","7","13","13","ויבא גדעון והנה איש מספר לרעהו חלום ויאמר הנה חלום חלמתי והנה צלול לחם שערים מתהפך במחנה מדין ויבא עד האהל ויכהו ויפל ויהפכהו למעלה ונפל האהל׃ ");
INSERT INTO heb_vpl VALUES ("JG7_14","008_7_14","JDG","7","14","14","ויען רעהו ויאמר אין זאת בלתי אם חרב גדעון בן יואש איש ישראל נתן האלהים בידו את מדין ואת כל המחנה׃ ");
INSERT INTO heb_vpl VALUES ("JG7_15","008_7_15","JDG","7","15","15","ויהי כשמע גדעון את מספר החלום ואת שברו וישתחו וישב אל מחנה ישראל ויאמר קומו כי נתן יהוה בידכם את מחנה מדין׃ ");
INSERT INTO heb_vpl VALUES ("JG7_16","008_7_16","JDG","7","16","16","ויחץ את שלש מאות האיש שלשה ראשים ויתן שופרות ביד כלם וכדים רקים ולפדים בתוך הכדים׃ ");
INSERT INTO heb_vpl VALUES ("JG7_17","008_7_17","JDG","7","17","17","ויאמר אליהם ממני תראו וכן תעשו והנה אנכי בא בקצה המחנה והיה כאשר אעשה כן תעשון׃ ");
INSERT INTO heb_vpl VALUES ("JG7_18","008_7_18","JDG","7","18","18","ותקעתי בשופר אנכי וכל אשר אתי ותקעתם בשופרות גם אתם סביבות כל המחנה ואמרתם ליהוה ולגדעון׃ ");
INSERT INTO heb_vpl VALUES ("JG7_19","008_7_19","JDG","7","19","19","ויבא גדעון ומאה איש אשר אתו בקצה המחנה ראש האשמרת התיכונה אך הקם הקימו את השמרים ויתקעו בשופרות ונפוץ הכדים אשר בידם׃ ");
INSERT INTO heb_vpl VALUES ("JG7_20","008_7_20","JDG","7","20","20","ויתקעו שלשת הראשים בשופרות וישברו הכדים ויחזיקו ביד שמאולם בלפדים וביד ימינם השופרות לתקוע ויקראו חרב ליהוה ולגדעון׃ ");
INSERT INTO heb_vpl VALUES ("JG7_21","008_7_21","JDG","7","21","21","ויעמדו איש תחתיו סביב למחנה וירץ כל המחנה ויריעו ויניסו׃ ");
INSERT INTO heb_vpl VALUES ("JG7_22","008_7_22","JDG","7","22","22","ויתקעו שלש מאות השופרות וישם יהוה את חרב איש ברעהו ובכל המחנה וינס המחנה עד בית השטה צררתה עד שפת אבל מחולה על טבת׃ ");
INSERT INTO heb_vpl VALUES ("JG7_23","008_7_23","JDG","7","23","23","ויצעק איש ישראל מנפתלי ומן אשר ומן כל מנשה וירדפו אחרי מדין׃ ");
INSERT INTO heb_vpl VALUES ("JG7_24","008_7_24","JDG","7","24","24","ומלאכים שלח גדעון בכל הר אפרים לאמר רדו לקראת מדין ולכדו להם את המים עד בית ברה ואת הירדן ויצעק כל איש אפרים וילכדו את המים עד בית ברה ואת הירדן׃ ");
INSERT INTO heb_vpl VALUES ("JG7_25","008_7_25","JDG","7","25","25","וילכדו שני שרי מדין את ערב ואת זאב ויהרגו את עורב בצור עורב ואת זאב הרגו ביקב זאב וירדפו אל מדין וראש ערב וזאב הביאו אל גדעון מעבר לירדן׃ ");
INSERT INTO heb_vpl VALUES ("JG8_1","008_8_1","JDG","8","1","1","ויאמרו אליו איש אפרים מה הדבר הזה עשית לנו לבלתי קראות לנו כי הלכת להלחם במדין ויריבון אתו בחזקה׃ ");
INSERT INTO heb_vpl VALUES ("JG8_2","008_8_2","JDG","8","2","2","ויאמר אליהם מה עשיתי עתה ככם הלוא טוב עללות אפרים מבציר אביעזר׃ ");
INSERT INTO heb_vpl VALUES ("JG8_3","008_8_3","JDG","8","3","3","בידכם נתן אלהים את שרי מדין את ערב ואת זאב ומה יכלתי עשות ככם אז רפתה רוחם מעליו בדברו הדבר הזה׃ ");
INSERT INTO heb_vpl VALUES ("JG8_4","008_8_4","JDG","8","4","4","ויבא גדעון הירדנה עבר הוא ושלש מאות האיש אשר אתו עיפים ורדפים׃ ");
INSERT INTO heb_vpl VALUES ("JG8_5","008_8_5","JDG","8","5","5","ויאמר לאנשי סכות תנו נא ככרות לחם לעם אשר ברגלי כי עיפים הם ואנכי רדף אחרי זבח וצלמנע מלכי מדין׃ ");
INSERT INTO heb_vpl VALUES ("JG8_6","008_8_6","JDG","8","6","6","ויאמר שרי סכות הכף זבח וצלמנע עתה בידך כי נתן לצבאך לחם׃ ");
INSERT INTO heb_vpl VALUES ("JG8_7","008_8_7","JDG","8","7","7","ויאמר גדעון לכן בתת יהוה את זבח ואת צלמנע בידי ודשתי את בשרכם את קוצי המדבר ואת הברקנים׃ ");
INSERT INTO heb_vpl VALUES ("JG8_8","008_8_8","JDG","8","8","8","ויעל משם פנואל וידבר אליהם כזאת ויענו אותו אנשי פנואל כאשר ענו אנשי סכות׃ ");
INSERT INTO heb_vpl VALUES ("JG8_9","008_8_9","JDG","8","9","9","ויאמר גם לאנשי פנואל לאמר בשובי בשלום אתץ את המגדל הזה׃ ");
INSERT INTO heb_vpl VALUES ("JG8_10","008_8_10","JDG","8","10","10","וזבח וצלמנע בקרקר ומחניהם עמם כחמשת עשר אלף כל הנותרים מכל מחנה בני קדם והנפלים מאה ועשרים אלף איש שלף חרב׃ ");
INSERT INTO heb_vpl VALUES ("JG8_11","008_8_11","JDG","8","11","11","ויעל גדעון דרך השכוני באהלים מקדם לנבח ויגבהה ויך את המחנה והמחנה היה בטח׃ ");
INSERT INTO heb_vpl VALUES ("JG8_12","008_8_12","JDG","8","12","12","וינוסו זבח וצלמנע וירדף אחריהם וילכד את שני מלכי מדין את זבח ואת צלמנע וכל המחנה החריד׃ ");
INSERT INTO heb_vpl VALUES ("JG8_13","008_8_13","JDG","8","13","13","וישב גדעון בן יואש מן המלחמה מלמעלה החרס׃ ");
INSERT INTO heb_vpl VALUES ("JG8_14","008_8_14","JDG","8","14","14","וילכד נער מאנשי סכות וישאלהו ויכתב אליו את שרי סכות ואת זקניה שבעים ושבעה איש׃ ");
INSERT INTO heb_vpl VALUES ("JG8_15","008_8_15","JDG","8","15","15","ויבא אל אנשי סכות ויאמר הנה זבח וצלמנע אשר חרפתם אותי לאמר הכף זבח וצלמנע עתה בידך כי נתן לאנשיך היעפים לחם׃ ");
INSERT INTO heb_vpl VALUES ("JG8_16","008_8_16","JDG","8","16","16","ויקח את זקני העיר ואת קוצי המדבר ואת הברקנים וידע בהם את אנשי סכות׃ ");
INSERT INTO heb_vpl VALUES ("JG8_17","008_8_17","JDG","8","17","17","ואת מגדל פנואל נתץ ויהרג את אנשי העיר׃ ");
INSERT INTO heb_vpl VALUES ("JG8_18","008_8_18","JDG","8","18","18","ויאמר אל זבח ואל צלמנע איפה האנשים אשר הרגתם בתבור ויאמרו כמוך כמוהם אחד כתאר בני המלך׃ ");
INSERT INTO heb_vpl VALUES ("JG8_19","008_8_19","JDG","8","19","19","ויאמר אחי בני אמי הם חי יהוה לו החיתם אותם לא הרגתי אתכם׃ ");
INSERT INTO heb_vpl VALUES ("JG8_20","008_8_20","JDG","8","20","20","ויאמר ליתר בכורו קום הרג אותם ולא שלף הנער חרבו כי ירא כי עודנו נער׃ ");
INSERT INTO heb_vpl VALUES ("JG8_21","008_8_21","JDG","8","21","21","ויאמר זבח וצלמנע קום אתה ופגע בנו כי כאיש גבורתו ויקם גדעון ויהרג את זבח ואת צלמנע ויקח את השהרנים אשר בצוארי גמליהם׃ ");
INSERT INTO heb_vpl VALUES ("JG8_22","008_8_22","JDG","8","22","22","ויאמרו איש ישראל אל גדעון משל בנו גם אתה גם בנך גם בן בנך כי הושעתנו מיד מדין׃ ");
INSERT INTO heb_vpl VALUES ("JG8_23","008_8_23","JDG","8","23","23","ויאמר אלהם גדעון לא אמשל אני בכם ולא ימשל בני בכם יהוה ימשל בכם׃ ");
INSERT INTO heb_vpl VALUES ("JG8_24","008_8_24","JDG","8","24","24","ויאמר אלהם גדעון אשאלה מכם שאלה ותנו לי איש נזם שללו כי נזמי זהב להם כי ישמעאלים הם׃ ");
INSERT INTO heb_vpl VALUES ("JG8_25","008_8_25","JDG","8","25","25","ויאמרו נתון נתן ויפרשו את השמלה וישליכו שמה איש נזם שללו׃ ");
INSERT INTO heb_vpl VALUES ("JG8_26","008_8_26","JDG","8","26","26","ויהי משקל נזמי הזהב אשר שאל אלף ושבע מאות זהב לבד מן השהרנים והנטפות ובגדי הארגמן שעל מלכי מדין ולבד מן הענקות אשר בצוארי גמליהם׃ ");
INSERT INTO heb_vpl VALUES ("JG8_27","008_8_27","JDG","8","27","27","ויעש אותו גדעון לאפוד ויצג אותו בעירו בעפרה ויזנו כל ישראל אחריו שם ויהי לגדעון ולביתו למוקש׃ ");
INSERT INTO heb_vpl VALUES ("JG8_28","008_8_28","JDG","8","28","28","ויכנע מדין לפני בני ישראל ולא יספו לשאת ראשם ותשקט הארץ ארבעים שנה בימי גדעון׃ ");
INSERT INTO heb_vpl VALUES ("JG8_29","008_8_29","JDG","8","29","29","וילך ירבעל בן יואש וישב בביתו׃ ");
INSERT INTO heb_vpl VALUES ("JG8_30","008_8_30","JDG","8","30","30","ולגדעון היו שבעים בנים יצאי ירכו כי נשים רבות היו לו׃ ");
INSERT INTO heb_vpl VALUES ("JG8_31","008_8_31","JDG","8","31","31","ופילגשו אשר בשכם ילדה לו גם היא בן וישם את שמו אבימלך׃ ");
INSERT INTO heb_vpl VALUES ("JG8_32","008_8_32","JDG","8","32","32","וימת גדעון בן יואש בשיבה טובה ויקבר בקבר יואש אביו בעפרה אבי העזרי׃ ");
INSERT INTO heb_vpl VALUES ("JG8_33","008_8_33","JDG","8","33","33","ויהי כאשר מת גדעון וישובו בני ישראל ויזנו אחרי הבעלים וישימו להם בעל ברית לאלהים׃ ");
INSERT INTO heb_vpl VALUES ("JG8_34","008_8_34","JDG","8","34","34","ולא זכרו בני ישראל את יהוה אלהיהם המציל אותם מיד כל איביהם מסביב׃ ");
INSERT INTO heb_vpl VALUES ("JG8_35","008_8_35","JDG","8","35","35","ולא עשו חסד עם בית ירבעל גדעון ככל הטובה אשר עשה עם ישראל׃ ");
INSERT INTO heb_vpl VALUES ("JG9_1","008_9_1","JDG","9","1","1","וילך אבימלך בן ירבעל שכמה אל אחי אמו וידבר אליהם ואל כל משפחת בית אבי אמו לאמר׃ ");
INSERT INTO heb_vpl VALUES ("JG9_2","008_9_2","JDG","9","2","2","דברו נא באזני כל בעלי שכם מה טוב לכם המשל בכם שבעים איש כל בני ירבעל אם משל בכם איש אחד וזכרתם כי עצמכם ובשרכם אני׃ ");
INSERT INTO heb_vpl VALUES ("JG9_3","008_9_3","JDG","9","3","3","וידברו אחי אמו עליו באזני כל בעלי שכם את כל הדברים האלה ויט לבם אחרי אבימלך כי אמרו אחינו הוא׃ ");
INSERT INTO heb_vpl VALUES ("JG9_4","008_9_4","JDG","9","4","4","ויתנו לו שבעים כסף מבית בעל ברית וישכר בהם אבימלך אנשים ריקים ופחזים וילכו אחריו׃ ");
INSERT INTO heb_vpl VALUES ("JG9_5","008_9_5","JDG","9","5","5","ויבא בית אביו עפרתה ויהרג את אחיו בני ירבעל שבעים איש על אבן אחת ויותר יותם בן ירבעל הקטן כי נחבא׃ ");
INSERT INTO heb_vpl VALUES ("JG9_6","008_9_6","JDG","9","6","6","ויאספו כל בעלי שכם וכל בית מלוא וילכו וימליכו את אבימלך למלך עם אלון מצב אשר בשכם׃ ");
INSERT INTO heb_vpl VALUES ("JG9_7","008_9_7","JDG","9","7","7","ויגדו ליותם וילך ויעמד בראש הר גרזים וישא קולו ויקרא ויאמר להם שמעו אלי בעלי שכם וישמע אליכם אלהים׃ ");
INSERT INTO heb_vpl VALUES ("JG9_8","008_9_8","JDG","9","8","8","הלוך הלכו העצים למשח עליהם מלך ויאמרו לזית מלוכה עלינו׃ ");
INSERT INTO heb_vpl VALUES ("JG9_9","008_9_9","JDG","9","9","9","ויאמר להם הזית החדלתי את דשני אשר בי יכבדו אלהים ואנשים והלכתי לנוע על העצים׃ ");
INSERT INTO heb_vpl VALUES ("JG9_10","008_9_10","JDG","9","10","10","ויאמרו העצים לתאנה לכי את מלכי עלינו׃ ");
INSERT INTO heb_vpl VALUES ("JG9_11","008_9_11","JDG","9","11","11","ותאמר להם התאנה החדלתי את מתקי ואת תנובתי הטובה והלכתי לנוע על העצים׃ ");
INSERT INTO heb_vpl VALUES ("JG9_12","008_9_12","JDG","9","12","12","ויאמרו העצים לגפן לכי את מלוכי עלינו׃ ");
INSERT INTO heb_vpl VALUES ("JG9_13","008_9_13","JDG","9","13","13","ותאמר להם הגפן החדלתי את תירושי המשמח אלהים ואנשים והלכתי לנוע על העצים׃ ");
INSERT INTO heb_vpl VALUES ("JG9_14","008_9_14","JDG","9","14","14","ויאמרו כל העצים אל האטד לך אתה מלך עלינו׃ ");
INSERT INTO heb_vpl VALUES ("JG9_15","008_9_15","JDG","9","15","15","ויאמר האטד אל העצים אם באמת אתם משחים אתי למלך עליכם באו חסו בצלי ואם אין תצא אש מן האטד ותאכל את ארזי הלבנון׃ ");
INSERT INTO heb_vpl VALUES ("JG9_16","008_9_16","JDG","9","16","16","ועתה אם באמת ובתמים עשיתם ותמליכו את אבימלך ואם טובה עשיתם עם ירבעל ועם ביתו ואם כגמול ידיו עשיתם לו׃ ");
INSERT INTO heb_vpl VALUES ("JG9_17","008_9_17","JDG","9","17","17","אשר נלחם אבי עליכם וישלך את נפשו מנגד ויצל אתכם מיד מדין׃ ");
INSERT INTO heb_vpl VALUES ("JG9_18","008_9_18","JDG","9","18","18","ואתם קמתם על בית אבי היום ותהרגו את בניו שבעים איש על אבן אחת ותמליכו את אבימלך בן אמתו על בעלי שכם כי אחיכם הוא׃ ");
INSERT INTO heb_vpl VALUES ("JG9_19","008_9_19","JDG","9","19","19","ואם באמת ובתמים עשיתם עם ירבעל ועם ביתו היום הזה שמחו באבימלך וישמח גם הוא בכם׃ ");
INSERT INTO heb_vpl VALUES ("JG9_20","008_9_20","JDG","9","20","20","ואם אין תצא אש מאבימלך ותאכל את בעלי שכם ואת בית מלוא ותצא אש מבעלי שכם ומבית מלוא ותאכל את אבימלך׃ ");
INSERT INTO heb_vpl VALUES ("JG9_21","008_9_21","JDG","9","21","21","וינס יותם ויברח וילך בארה וישב שם מפני אבימלך אחיו׃ ");
INSERT INTO heb_vpl VALUES ("JG9_22","008_9_22","JDG","9","22","22","וישר אבימלך על ישראל שלש שנים׃ ");
INSERT INTO heb_vpl VALUES ("JG9_23","008_9_23","JDG","9","23","23","וישלח אלהים רוח רעה בין אבימלך ובין בעלי שכם ויבגדו בעלי שכם באבימלך׃ ");
INSERT INTO heb_vpl VALUES ("JG9_24","008_9_24","JDG","9","24","24","לבוא חמס שבעים בני ירבעל ודמם לשום על אבימלך אחיהם אשר הרג אותם ועל בעלי שכם אשר חזקו את ידיו להרג את אחיו׃ ");
INSERT INTO heb_vpl VALUES ("JG9_25","008_9_25","JDG","9","25","25","וישימו לו בעלי שכם מארבים על ראשי ההרים ויגזלו את כל אשר יעבר עליהם בדרך ויגד לאבימלך׃ ");
INSERT INTO heb_vpl VALUES ("JG9_26","008_9_26","JDG","9","26","26","ויבא געל בן עבד ואחיו ויעברו בשכם ויבטחו בו בעלי שכם׃ ");
INSERT INTO heb_vpl VALUES ("JG9_27","008_9_27","JDG","9","27","27","ויצאו השדה ויבצרו את כרמיהם וידרכו ויעשו הלולים ויבאו בית אלהיהם ויאכלו וישתו ויקללו את אבימלך׃ ");
INSERT INTO heb_vpl VALUES ("JG9_28","008_9_28","JDG","9","28","28","ויאמר געל בן עבד מי אבימלך ומי שכם כי נעבדנו הלא בן ירבעל וזבל פקידו עבדו את אנשי חמור אבי שכם ומדוע נעבדנו אנחנו׃ ");
INSERT INTO heb_vpl VALUES ("JG9_29","008_9_29","JDG","9","29","29","ומי יתן את העם הזה בידי ואסירה את אבימלך ויאמר לאבימלך רבה צבאך וצאה׃ ");
INSERT INTO heb_vpl VALUES ("JG9_30","008_9_30","JDG","9","30","30","וישמע זבל שר העיר את דברי געל בן עבד ויחר אפו׃ ");
INSERT INTO heb_vpl VALUES ("JG9_31","008_9_31","JDG","9","31","31","וישלח מלאכים אל אבימלך בתרמה לאמר הנה געל בן עבד ואחיו באים שכמה והנם צרים את העיר עליך׃ ");
INSERT INTO heb_vpl VALUES ("JG9_32","008_9_32","JDG","9","32","32","ועתה קום לילה אתה והעם אשר אתך וארב בשדה׃ ");
INSERT INTO heb_vpl VALUES ("JG9_33","008_9_33","JDG","9","33","33","והיה בבקר כזרח השמש תשכים ופשטת על העיר והנה הוא והעם אשר אתו יצאים אליך ועשית לו כאשר תמצא ידך׃ ");
INSERT INTO heb_vpl VALUES ("JG9_34","008_9_34","JDG","9","34","34","ויקם אבימלך וכל העם אשר עמו לילה ויארבו על שכם ארבעה ראשים׃ ");
INSERT INTO heb_vpl VALUES ("JG9_35","008_9_35","JDG","9","35","35","ויצא געל בן עבד ויעמד פתח שער העיר ויקם אבימלך והעם אשר אתו מן המארב׃ ");
INSERT INTO heb_vpl VALUES ("JG9_36","008_9_36","JDG","9","36","36","וירא געל את העם ויאמר אל זבל הנה עם יורד מראשי ההרים ויאמר אליו זבל את צל ההרים אתה ראה כאנשים׃ ");
INSERT INTO heb_vpl VALUES ("JG9_37","008_9_37","JDG","9","37","37","ויסף עוד געל לדבר ויאמר הנה עם יורדים מעם טבור הארץ וראש אחד בא מדרך אלון מעוננים׃ ");
INSERT INTO heb_vpl VALUES ("JG9_38","008_9_38","JDG","9","38","38","ויאמר אליו זבל איה אפוא פיך אשר תאמר מי אבימלך כי נעבדנו הלא זה העם אשר מאסתה בו צא נא עתה והלחם בו׃ ");
INSERT INTO heb_vpl VALUES ("JG9_39","008_9_39","JDG","9","39","39","ויצא געל לפני בעלי שכם וילחם באבימלך׃ ");
INSERT INTO heb_vpl VALUES ("JG9_40","008_9_40","JDG","9","40","40","וירדפהו אבימלך וינס מפניו ויפלו חללים רבים עד פתח השער׃ ");
INSERT INTO heb_vpl VALUES ("JG9_41","008_9_41","JDG","9","41","41","וישב אבימלך בארומה ויגרש זבל את געל ואת אחיו משבת בשכם׃ ");
INSERT INTO heb_vpl VALUES ("JG9_42","008_9_42","JDG","9","42","42","ויהי ממחרת ויצא העם השדה ויגדו לאבימלך׃ ");
INSERT INTO heb_vpl VALUES ("JG9_43","008_9_43","JDG","9","43","43","ויקח את העם ויחצם לשלשה ראשים ויארב בשדה וירא והנה העם יצא מן העיר ויקם עליהם ויכם׃ ");
INSERT INTO heb_vpl VALUES ("JG9_44","008_9_44","JDG","9","44","44","ואבימלך והראשים אשר עמו פשטו ויעמדו פתח שער העיר ושני הראשים פשטו על כל אשר בשדה ויכום׃ ");
INSERT INTO heb_vpl VALUES ("JG9_45","008_9_45","JDG","9","45","45","ואבימלך נלחם בעיר כל היום ההוא וילכד את העיר ואת העם אשר בה הרג ויתץ את העיר ויזרעה מלח׃ ");
INSERT INTO heb_vpl VALUES ("JG9_46","008_9_46","JDG","9","46","46","וישמעו כל בעלי מגדל שכם ויבאו אל צריח בית אל ברית׃ ");
INSERT INTO heb_vpl VALUES ("JG9_47","008_9_47","JDG","9","47","47","ויגד לאבימלך כי התקבצו כל בעלי מגדל שכם׃ ");
INSERT INTO heb_vpl VALUES ("JG9_48","008_9_48","JDG","9","48","48","ויעל אבימלך הר צלמון הוא וכל העם אשר אתו ויקח אבימלך את הקרדמות בידו ויכרת שוכת עצים וישאה וישם על שכמו ויאמר אל העם אשר עמו מה ראיתם עשיתי מהרו עשו כמוני׃ ");
INSERT INTO heb_vpl VALUES ("JG9_49","008_9_49","JDG","9","49","49","ויכרתו גם כל העם איש שוכה וילכו אחרי אבימלך וישימו על הצריח ויציתו עליהם את הצריח באש וימתו גם כל אנשי מגדל שכם כאלף איש ואשה׃ ");
INSERT INTO heb_vpl VALUES ("JG9_50","008_9_50","JDG","9","50","50","וילך אבימלך אל תבץ ויחן בתבץ וילכדה׃ ");
INSERT INTO heb_vpl VALUES ("JG9_51","008_9_51","JDG","9","51","51","ומגדל עז היה בתוך העיר וינסו שמה כל האנשים והנשים וכל בעלי העיר ויסגרו בעדם ויעלו על גג המגדל׃ ");
INSERT INTO heb_vpl VALUES ("JG9_52","008_9_52","JDG","9","52","52","ויבא אבימלך עד המגדל וילחם בו ויגש עד פתח המגדל לשרפו באש׃ ");
INSERT INTO heb_vpl VALUES ("JG9_53","008_9_53","JDG","9","53","53","ותשלך אשה אחת פלח רכב על ראש אבימלך ותרץ את גלגלתו׃ ");
INSERT INTO heb_vpl VALUES ("JG9_54","008_9_54","JDG","9","54","54","ויקרא מהרה אל הנער נשא כליו ויאמר לו שלף חרבך ומותתני פן יאמרו לי אשה הרגתהו וידקרהו נערו וימת׃ ");
INSERT INTO heb_vpl VALUES ("JG9_55","008_9_55","JDG","9","55","55","ויראו איש ישראל כי מת אבימלך וילכו איש למקמו׃ ");
INSERT INTO heb_vpl VALUES ("JG9_56","008_9_56","JDG","9","56","56","וישב אלהים את רעת אבימלך אשר עשה לאביו להרג את שבעים אחיו׃ ");
INSERT INTO heb_vpl VALUES ("JG9_57","008_9_57","JDG","9","57","57","ואת כל רעת אנשי שכם השיב אלהים בראשם ותבא אליהם קללת יותם בן ירבעל׃ ");
INSERT INTO heb_vpl VALUES ("JG10_1","008_10_1","JDG","10","1","1","ויקם אחרי אבימלך להושיע את ישראל תולע בן פואה בן דודו איש יששכר והוא ישב בשמיר בהר אפרים׃ ");
INSERT INTO heb_vpl VALUES ("JG10_2","008_10_2","JDG","10","2","2","וישפט את ישראל עשרים ושלש שנה וימת ויקבר בשמיר׃ ");
INSERT INTO heb_vpl VALUES ("JG10_3","008_10_3","JDG","10","3","3","ויקם אחריו יאיר הגלעדי וישפט את ישראל עשרים ושתים שנה׃ ");
INSERT INTO heb_vpl VALUES ("JG10_4","008_10_4","JDG","10","4","4","ויהי לו שלשים בנים רכבים על שלשים עירים ושלשים עירים להם להם יקראו חות יאיר עד היום הזה אשר בארץ הגלעד׃ ");
INSERT INTO heb_vpl VALUES ("JG10_5","008_10_5","JDG","10","5","5","וימת יאיר ויקבר בקמון׃ ");
INSERT INTO heb_vpl VALUES ("JG10_6","008_10_6","JDG","10","6","6","ויספו בני ישראל לעשות הרע בעיני יהוה ויעבדו את הבעלים ואת העשתרות ואת אלהי ארם ואת אלהי צידון ואת אלהי מואב ואת אלהי בני עמון ואת אלהי פלשתים ויעזבו את יהוה ולא עבדוהו׃ ");
INSERT INTO heb_vpl VALUES ("JG10_7","008_10_7","JDG","10","7","7","ויחר אף יהוה בישראל וימכרם ביד פלשתים וביד בני עמון׃ ");
INSERT INTO heb_vpl VALUES ("JG10_8","008_10_8","JDG","10","8","8","וירעצו וירצצו את בני ישראל בשנה ההיא שמנה עשרה שנה את כל בני ישראל אשר בעבר הירדן בארץ האמרי אשר בגלעד׃ ");
INSERT INTO heb_vpl VALUES ("JG10_9","008_10_9","JDG","10","9","9","ויעברו בני עמון את הירדן להלחם גם ביהודה ובבנימין ובבית אפרים ותצר לישראל מאד׃ ");
INSERT INTO heb_vpl VALUES ("JG10_10","008_10_10","JDG","10","10","10","ויזעקו בני ישראל אל יהוה לאמר חטאנו לך וכי עזבנו את אלהינו ונעבד את הבעלים׃ ");
INSERT INTO heb_vpl VALUES ("JG10_11","008_10_11","JDG","10","11","11","ויאמר יהוה אל בני ישראל הלא ממצרים ומן האמרי ומן בני עמון ומן פלשתים׃ ");
INSERT INTO heb_vpl VALUES ("JG10_12","008_10_12","JDG","10","12","12","וצידונים ועמלק ומעון לחצו אתכם ותצעקו אלי ואושיעה אתכם מידם׃ ");
INSERT INTO heb_vpl VALUES ("JG10_13","008_10_13","JDG","10","13","13","ואתם עזבתם אותי ותעבדו אלהים אחרים לכן לא אוסיף להושיע אתכם׃ ");
INSERT INTO heb_vpl VALUES ("JG10_14","008_10_14","JDG","10","14","14","לכו וזעקו אל האלהים אשר בחרתם בם המה יושיעו לכם בעת צרתכם׃ ");
INSERT INTO heb_vpl VALUES ("JG10_15","008_10_15","JDG","10","15","15","ויאמרו בני ישראל אל יהוה חטאנו עשה אתה לנו ככל הטוב בעיניך אך הצילנו נא היום הזה׃ ");
INSERT INTO heb_vpl VALUES ("JG10_16","008_10_16","JDG","10","16","16","ויסירו את אלהי הנכר מקרבם ויעבדו את יהוה ותקצר נפשו בעמל ישראל׃ ");
INSERT INTO heb_vpl VALUES ("JG10_17","008_10_17","JDG","10","17","17","ויצעקו בני עמון ויחנו בגלעד ויאספו בני ישראל ויחנו במצפה׃ ");
INSERT INTO heb_vpl VALUES ("JG10_18","008_10_18","JDG","10","18","18","ויאמרו העם שרי גלעד איש אל רעהו מי האיש אשר יחל להלחם בבני עמון יהיה לראש לכל ישבי גלעד׃ ");
INSERT INTO heb_vpl VALUES ("JG11_1","008_11_1","JDG","11","1","1","ויפתח הגלעדי היה גבור חיל והוא בן אשה זונה ויולד גלעד את יפתח׃ ");
INSERT INTO heb_vpl VALUES ("JG11_2","008_11_2","JDG","11","2","2","ותלד אשת גלעד לו בנים ויגדלו בני האשה ויגרשו את יפתח ויאמרו לו לא תנחל בבית אבינו כי בן אשה אחרת אתה׃ ");
INSERT INTO heb_vpl VALUES ("JG11_3","008_11_3","JDG","11","3","3","ויברח יפתח מפני אחיו וישב בארץ טוב ויתלקטו אל יפתח אנשים ריקים ויצאו עמו׃ ");
INSERT INTO heb_vpl VALUES ("JG11_4","008_11_4","JDG","11","4","4","ויהי מימים וילחמו בני עמון עם ישראל׃ ");
INSERT INTO heb_vpl VALUES ("JG11_5","008_11_5","JDG","11","5","5","ויהי כאשר נלחמו בני עמון עם ישראל וילכו זקני גלעד לקחת את יפתח מארץ טוב׃ ");
INSERT INTO heb_vpl VALUES ("JG11_6","008_11_6","JDG","11","6","6","ויאמרו ליפתח לכה והייתה לנו לקצין ונלחמה בבני עמון׃ ");
INSERT INTO heb_vpl VALUES ("JG11_7","008_11_7","JDG","11","7","7","ויאמר יפתח לזקני גלעד הלא אתם שנאתם אותי ותגרשוני מבית אבי ומדוע באתם אלי עתה כאשר צר לכם׃ ");
INSERT INTO heb_vpl VALUES ("JG11_8","008_11_8","JDG","11","8","8","ויאמרו זקני גלעד אל יפתח לכן עתה שבנו אליך והלכת עמנו ונלחמת בבני עמון והיית לנו לראש לכל ישבי גלעד׃ ");
INSERT INTO heb_vpl VALUES ("JG11_9","008_11_9","JDG","11","9","9","ויאמר יפתח אל זקני גלעד אם משיבים אתם אותי להלחם בבני עמון ונתן יהוה אותם לפני אנכי אהיה לכם לראש׃ ");
INSERT INTO heb_vpl VALUES ("JG11_10","008_11_10","JDG","11","10","10","ויאמרו זקני גלעד אל יפתח יהוה יהיה שמע בינותינו אם לא כדברך כן נעשה׃ ");
INSERT INTO heb_vpl VALUES ("JG11_11","008_11_11","JDG","11","11","11","וילך יפתח עם זקני גלעד וישימו העם אותו עליהם לראש ולקצין וידבר יפתח את כל דבריו לפני יהוה במצפה׃ ");
INSERT INTO heb_vpl VALUES ("JG11_12","008_11_12","JDG","11","12","12","וישלח יפתח מלאכים אל מלך בני עמון לאמר מה לי ולך כי באת אלי להלחם בארצי׃ ");
INSERT INTO heb_vpl VALUES ("JG11_13","008_11_13","JDG","11","13","13","ויאמר מלך בני עמון אל מלאכי יפתח כי לקח ישראל את ארצי בעלותו ממצרים מארנון ועד היבק ועד הירדן ועתה השיבה אתהן בשלום׃ ");
INSERT INTO heb_vpl VALUES ("JG11_14","008_11_14","JDG","11","14","14","ויוסף עוד יפתח וישלח מלאכים אל מלך בני עמון׃ ");
INSERT INTO heb_vpl VALUES ("JG11_15","008_11_15","JDG","11","15","15","ויאמר לו כה אמר יפתח לא לקח ישראל את ארץ מואב ואת ארץ בני עמון׃ ");
INSERT INTO heb_vpl VALUES ("JG11_16","008_11_16","JDG","11","16","16","כי בעלותם ממצרים וילך ישראל במדבר עד ים סוף ויבא קדשה׃ ");
INSERT INTO heb_vpl VALUES ("JG11_17","008_11_17","JDG","11","17","17","וישלח ישראל מלאכים אל מלך אדום לאמר אעברה נא בארצך ולא שמע מלך אדום וגם אל מלך מואב שלח ולא אבה וישב ישראל בקדש׃ ");
INSERT INTO heb_vpl VALUES ("JG11_18","008_11_18","JDG","11","18","18","וילך במדבר ויסב את ארץ אדום ואת ארץ מואב ויבא ממזרח שמש לארץ מואב ויחנון בעבר ארנון ולא באו בגבול מואב כי ארנון גבול מואב׃ ");
INSERT INTO heb_vpl VALUES ("JG11_19","008_11_19","JDG","11","19","19","וישלח ישראל מלאכים אל סיחון מלך האמרי מלך חשבון ויאמר לו ישראל נעברה נא בארצך עד מקומי׃ ");
INSERT INTO heb_vpl VALUES ("JG11_20","008_11_20","JDG","11","20","20","ולא האמין סיחון את ישראל עבר בגבלו ויאסף סיחון את כל עמו ויחנו ביהצה וילחם עם ישראל׃ ");
INSERT INTO heb_vpl VALUES ("JG11_21","008_11_21","JDG","11","21","21","ויתן יהוה אלהי ישראל את סיחון ואת כל עמו ביד ישראל ויכום ויירש ישראל את כל ארץ האמרי יושב הארץ ההיא׃ ");
INSERT INTO heb_vpl VALUES ("JG11_22","008_11_22","JDG","11","22","22","ויירשו את כל גבול האמרי מארנון ועד היבק ומן המדבר ועד הירדן׃ ");
INSERT INTO heb_vpl VALUES ("JG11_23","008_11_23","JDG","11","23","23","ועתה יהוה אלהי ישראל הוריש את האמרי מפני עמו ישראל ואתה תירשנו׃ ");
INSERT INTO heb_vpl VALUES ("JG11_24","008_11_24","JDG","11","24","24","הלא את אשר יורישך כמוש אלהיך אותו תירש ואת כל אשר הוריש יהוה אלהינו מפנינו אותו נירש׃ ");
INSERT INTO heb_vpl VALUES ("JG11_25","008_11_25","JDG","11","25","25","ועתה הטוב טוב אתה מבלק בן צפור מלך מואב הרוב רב עם ישראל אם נלחם נלחם בם׃ ");
INSERT INTO heb_vpl VALUES ("JG11_26","008_11_26","JDG","11","26","26","בשבת ישראל בחשבון ובבנותיה ובערעור ובבנותיה ובכל הערים אשר על ידי ארנון שלש מאות שנה ומדוע לא הצלתם בעת ההיא׃ ");
INSERT INTO heb_vpl VALUES ("JG11_27","008_11_27","JDG","11","27","27","ואנכי לא חטאתי לך ואתה עשה אתי רעה להלחם בי ישפט יהוה השפט היום בין בני ישראל ובין בני עמון׃ ");
INSERT INTO heb_vpl VALUES ("JG11_28","008_11_28","JDG","11","28","28","ולא שמע מלך בני עמון אל דברי יפתח אשר שלח אליו׃ ");
INSERT INTO heb_vpl VALUES ("JG11_29","008_11_29","JDG","11","29","29","ותהי על יפתח רוח יהוה ויעבר את הגלעד ואת מנשה ויעבר את מצפה גלעד וממצפה גלעד עבר בני עמון׃ ");
INSERT INTO heb_vpl VALUES ("JG11_30","008_11_30","JDG","11","30","30","וידר יפתח נדר ליהוה ויאמר אם נתון תתן את בני עמון בידי׃ ");
INSERT INTO heb_vpl VALUES ("JG11_31","008_11_31","JDG","11","31","31","והיה היוצא אשר יצא מדלתי ביתי לקראתי בשובי בשלום מבני עמון והיה ליהוה והעליתהו עולה׃ ");
INSERT INTO heb_vpl VALUES ("JG11_32","008_11_32","JDG","11","32","32","ויעבר יפתח אל בני עמון להלחם בם ויתנם יהוה בידו׃ ");
INSERT INTO heb_vpl VALUES ("JG11_33","008_11_33","JDG","11","33","33","ויכם מערוער ועד בואך מנית עשרים עיר ועד אבל כרמים מכה גדולה מאד ויכנעו בני עמון מפני בני ישראל׃ ");
INSERT INTO heb_vpl VALUES ("JG11_34","008_11_34","JDG","11","34","34","ויבא יפתח המצפה אל ביתו והנה בתו יצאת לקראתו בתפים ובמחלות ורק היא יחידה אין לו ממנו בן או בת׃ ");
INSERT INTO heb_vpl VALUES ("JG11_35","008_11_35","JDG","11","35","35","ויהי כראותו אותה ויקרע את בגדיו ויאמר אהה בתי הכרע הכרעתני ואת היית בעכרי ואנכי פציתי פי אל יהוה ולא אוכל לשוב׃ ");
INSERT INTO heb_vpl VALUES ("JG11_36","008_11_36","JDG","11","36","36","ותאמר אליו אבי פציתה את פיך אל יהוה עשה לי כאשר יצא מפיך אחרי אשר עשה לך יהוה נקמות מאיביך מבני עמון׃ ");
INSERT INTO heb_vpl VALUES ("JG11_37","008_11_37","JDG","11","37","37","ותאמר אל אביה יעשה לי הדבר הזה הרפה ממני שנים חדשים ואלכה וירדתי על ההרים ואבכה על בתולי אנכי ורעיתי׃ ");
INSERT INTO heb_vpl VALUES ("JG11_38","008_11_38","JDG","11","38","38","ויאמר לכי וישלח אותה שני חדשים ותלך היא ורעותיה ותבך על בתוליה על ההרים׃ ");
INSERT INTO heb_vpl VALUES ("JG11_39","008_11_39","JDG","11","39","39","ויהי מקץ שנים חדשים ותשב אל אביה ויעש לה את נדרו אשר נדר והיא לא ידעה איש ותהי חק בישראל׃ ");
INSERT INTO heb_vpl VALUES ("JG11_40","008_11_40","JDG","11","40","40","מימים ימימה תלכנה בנות ישראל לתנות לבת יפתח הגלעדי ארבעת ימים בשנה׃ ");
INSERT INTO heb_vpl VALUES ("JG12_1","008_12_1","JDG","12","1","1","ויצעק איש אפרים ויעבר צפונה ויאמרו ליפתח מדוע עברת להלחם בבני עמון ולנו לא קראת ללכת עמך ביתך נשרף עליך באש׃ ");
INSERT INTO heb_vpl VALUES ("JG12_2","008_12_2","JDG","12","2","2","ויאמר יפתח אליהם איש ריב הייתי אני ועמי ובני עמון מאד ואזעק אתכם ולא הושעתם אותי מידם׃ ");
INSERT INTO heb_vpl VALUES ("JG12_3","008_12_3","JDG","12","3","3","ואראה כי אינך מושיע ואשימה נפשי בכפי ואעברה אל בני עמון ויתנם יהוה בידי ולמה עליתם אלי היום הזה להלחם בי׃ ");
INSERT INTO heb_vpl VALUES ("JG12_4","008_12_4","JDG","12","4","4","ויקבץ יפתח את כל אנשי גלעד וילחם את אפרים ויכו אנשי גלעד את אפרים כי אמרו פליטי אפרים אתם גלעד בתוך אפרים בתוך מנשה׃ ");
INSERT INTO heb_vpl VALUES ("JG12_5","008_12_5","JDG","12","5","5","וילכד גלעד את מעברות הירדן לאפרים והיה כי יאמרו פליטי אפרים אעברה ויאמרו לו אנשי גלעד האפרתי אתה ויאמר לא׃ ");
INSERT INTO heb_vpl VALUES ("JG12_6","008_12_6","JDG","12","6","6","ויאמרו לו אמר נא שבלת ויאמר סבלת ולא יכין לדבר כן ויאחזו אותו וישחטוהו אל מעברות הירדן ויפל בעת ההיא מאפרים ארבעים ושנים אלף׃ ");
INSERT INTO heb_vpl VALUES ("JG12_7","008_12_7","JDG","12","7","7","וישפט יפתח את ישראל שש שנים וימת יפתח הגלעדי ויקבר בערי גלעד׃ ");
INSERT INTO heb_vpl VALUES ("JG12_8","008_12_8","JDG","12","8","8","וישפט אחריו את ישראל אבצן מבית לחם׃ ");
INSERT INTO heb_vpl VALUES ("JG12_9","008_12_9","JDG","12","9","9","ויהי לו שלשים בנים ושלשים בנות שלח החוצה ושלשים בנות הביא לבניו מן החוץ וישפט את ישראל שבע שנים׃ ");
INSERT INTO heb_vpl VALUES ("JG12_10","008_12_10","JDG","12","10","10","וימת אבצן ויקבר בבית לחם׃ ");
INSERT INTO heb_vpl VALUES ("JG12_11","008_12_11","JDG","12","11","11","וישפט אחריו את ישראל אילון הזבולני וישפט את ישראל עשר שנים׃ ");
INSERT INTO heb_vpl VALUES ("JG12_12","008_12_12","JDG","12","12","12","וימת אילון הזבולני ויקבר באילון בארץ זבולן׃ ");
INSERT INTO heb_vpl VALUES ("JG12_13","008_12_13","JDG","12","13","13","וישפט אחריו את ישראל עבדון בן הלל הפרעתוני׃ ");
INSERT INTO heb_vpl VALUES ("JG12_14","008_12_14","JDG","12","14","14","ויהי לו ארבעים בנים ושלשים בני בנים רכבים על שבעים עירם וישפט את ישראל שמנה שנים׃ ");
INSERT INTO heb_vpl VALUES ("JG12_15","008_12_15","JDG","12","15","15","וימת עבדון בן הלל הפרעתוני ויקבר בפרעתון בארץ אפרים בהר העמלקי׃ ");
INSERT INTO heb_vpl VALUES ("JG13_1","008_13_1","JDG","13","1","1","ויספו בני ישראל לעשות הרע בעיני יהוה ויתנם יהוה ביד פלשתים ארבעים שנה׃ ");
INSERT INTO heb_vpl VALUES ("JG13_2","008_13_2","JDG","13","2","2","ויהי איש אחד מצרעה ממשפחת הדני ושמו מנוח ואשתו עקרה ולא ילדה׃ ");
INSERT INTO heb_vpl VALUES ("JG13_3","008_13_3","JDG","13","3","3","וירא מלאך יהוה אל האשה ויאמר אליה הנה נא את עקרה ולא ילדת והרית וילדת בן׃ ");
INSERT INTO heb_vpl VALUES ("JG13_4","008_13_4","JDG","13","4","4","ועתה השמרי נא ואל תשתי יין ושכר ואל תאכלי כל טמא׃ ");
INSERT INTO heb_vpl VALUES ("JG13_5","008_13_5","JDG","13","5","5","כי הנך הרה וילדת בן ומורה לא יעלה על ראשו כי נזיר אלהים יהיה הנער מן הבטן והוא יחל להושיע את ישראל מיד פלשתים׃ ");
INSERT INTO heb_vpl VALUES ("JG13_6","008_13_6","JDG","13","6","6","ותבא האשה ותאמר לאישה לאמר איש האלהים בא אלי ומראהו כמראה מלאך האלהים נורא מאד ולא שאלתיהו אי מזה הוא ואת שמו לא הגיד לי׃ ");
INSERT INTO heb_vpl VALUES ("JG13_7","008_13_7","JDG","13","7","7","ויאמר לי הנך הרה וילדת בן ועתה אל תשתי יין ושכר ואל תאכלי כל טמאה כי נזיר אלהים יהיה הנער מן הבטן עד יום מותו׃ ");
INSERT INTO heb_vpl VALUES ("JG13_8","008_13_8","JDG","13","8","8","ויעתר מנוח אל יהוה ויאמר בי אדוני איש האלהים אשר שלחת יבוא נא עוד אלינו ויורנו מה נעשה לנער היולד׃ ");
INSERT INTO heb_vpl VALUES ("JG13_9","008_13_9","JDG","13","9","9","וישמע האלהים בקול מנוח ויבא מלאך האלהים עוד אל האשה והיא יושבת בשדה ומנוח אישה אין עמה׃ ");
INSERT INTO heb_vpl VALUES ("JG13_10","008_13_10","JDG","13","10","10","ותמהר האשה ותרץ ותגד לאישה ותאמר אליו הנה נראה אלי האיש אשר בא ביום אלי׃ ");
INSERT INTO heb_vpl VALUES ("JG13_11","008_13_11","JDG","13","11","11","ויקם וילך מנוח אחרי אשתו ויבא אל האיש ויאמר לו האתה האיש אשר דברת אל האשה ויאמר אני׃ ");
INSERT INTO heb_vpl VALUES ("JG13_12","008_13_12","JDG","13","12","12","ויאמר מנוח עתה יבא דבריך מה יהיה משפט הנער ומעשהו׃ ");
INSERT INTO heb_vpl VALUES ("JG13_13","008_13_13","JDG","13","13","13","ויאמר מלאך יהוה אל מנוח מכל אשר אמרתי אל האשה תשמר׃ ");
INSERT INTO heb_vpl VALUES ("JG13_14","008_13_14","JDG","13","14","14","מכל אשר יצא מגפן היין לא תאכל ויין ושכר אל תשת וכל טמאה אל תאכל כל אשר צויתיה תשמר׃ ");
INSERT INTO heb_vpl VALUES ("JG13_15","008_13_15","JDG","13","15","15","ויאמר מנוח אל מלאך יהוה נעצרה נא אותך ונעשה לפניך גדי עזים׃ ");
INSERT INTO heb_vpl VALUES ("JG13_16","008_13_16","JDG","13","16","16","ויאמר מלאך יהוה אל מנוח אם תעצרני לא אכל בלחמך ואם תעשה עלה ליהוה תעלנה כי לא ידע מנוח כי מלאך יהוה הוא׃ ");
INSERT INTO heb_vpl VALUES ("JG13_17","008_13_17","JDG","13","17","17","ויאמר מנוח אל מלאך יהוה מי שמך כי יבא דבריך וכבדנוך׃ ");
INSERT INTO heb_vpl VALUES ("JG13_18","008_13_18","JDG","13","18","18","ויאמר לו מלאך יהוה למה זה תשאל לשמי והוא פלאי׃ ");
INSERT INTO heb_vpl VALUES ("JG13_19","008_13_19","JDG","13","19","19","ויקח מנוח את גדי העזים ואת המנחה ויעל על הצור ליהוה ומפלא לעשות ומנוח ואשתו ראים׃ ");
INSERT INTO heb_vpl VALUES ("JG13_20","008_13_20","JDG","13","20","20","ויהי בעלות הלהב מעל המזבח השמימה ויעל מלאך יהוה בלהב המזבח ומנוח ואשתו ראים ויפלו על פניהם ארצה׃ ");
INSERT INTO heb_vpl VALUES ("JG13_21","008_13_21","JDG","13","21","21","ולא יסף עוד מלאך יהוה להראה אל מנוח ואל אשתו אז ידע מנוח כי מלאך יהוה הוא׃ ");
INSERT INTO heb_vpl VALUES ("JG13_22","008_13_22","JDG","13","22","22","ויאמר מנוח אל אשתו מות נמות כי אלהים ראינו׃ ");
INSERT INTO heb_vpl VALUES ("JG13_23","008_13_23","JDG","13","23","23","ותאמר לו אשתו לו חפץ יהוה להמיתנו לא לקח מידנו עלה ומנחה ולא הראנו את כל אלה וכעת לא השמיענו כזאת׃ ");
INSERT INTO heb_vpl VALUES ("JG13_24","008_13_24","JDG","13","24","24","ותלד האשה בן ותקרא את שמו שמשון ויגדל הנער ויברכהו יהוה׃ ");
INSERT INTO heb_vpl VALUES ("JG13_25","008_13_25","JDG","13","25","25","ותחל רוח יהוה לפעמו במחנה דן בין צרעה ובין אשתאל׃ ");
INSERT INTO heb_vpl VALUES ("JG14_1","008_14_1","JDG","14","1","1","וירד שמשון תמנתה וירא אשה בתמנתה מבנות פלשתים׃ ");
INSERT INTO heb_vpl VALUES ("JG14_2","008_14_2","JDG","14","2","2","ויעל ויגד לאביו ולאמו ויאמר אשה ראיתי בתמנתה מבנות פלשתים ועתה קחו אותה לי לאשה׃ ");
INSERT INTO heb_vpl VALUES ("JG14_3","008_14_3","JDG","14","3","3","ויאמר לו אביו ואמו האין בבנות אחיך ובכל עמי אשה כי אתה הולך לקחת אשה מפלשתים הערלים ויאמר שמשון אל אביו אותה קח לי כי היא ישרה בעיני׃ ");
INSERT INTO heb_vpl VALUES ("JG14_4","008_14_4","JDG","14","4","4","ואביו ואמו לא ידעו כי מיהוה היא כי תאנה הוא מבקש מפלשתים ובעת ההיא פלשתים משלים בישראל׃ ");
INSERT INTO heb_vpl VALUES ("JG14_5","008_14_5","JDG","14","5","5","וירד שמשון ואביו ואמו תמנתה ויבאו עד כרמי תמנתה והנה כפיר אריות שאג לקראתו׃ ");
INSERT INTO heb_vpl VALUES ("JG14_6","008_14_6","JDG","14","6","6","ותצלח עליו רוח יהוה וישסעהו כשסע הגדי ומאומה אין בידו ולא הגיד לאביו ולאמו את אשר עשה׃ ");
INSERT INTO heb_vpl VALUES ("JG14_7","008_14_7","JDG","14","7","7","וירד וידבר לאשה ותישר בעיני שמשון׃ ");
INSERT INTO heb_vpl VALUES ("JG14_8","008_14_8","JDG","14","8","8","וישב מימים לקחתה ויסר לראות את מפלת האריה והנה עדת דבורים בגוית האריה ודבש׃ ");
INSERT INTO heb_vpl VALUES ("JG14_9","008_14_9","JDG","14","9","9","וירדהו אל כפיו וילך הלוך ואכל וילך אל אביו ואל אמו ויתן להם ויאכלו ולא הגיד להם כי מגוית האריה רדה הדבש׃ ");
INSERT INTO heb_vpl VALUES ("JG14_10","008_14_10","JDG","14","10","10","וירד אביהו אל האשה ויעש שם שמשון משתה כי כן יעשו הבחורים׃ ");
INSERT INTO heb_vpl VALUES ("JG14_11","008_14_11","JDG","14","11","11","ויהי כראותם אותו ויקחו שלשים מרעים ויהיו אתו׃ ");
INSERT INTO heb_vpl VALUES ("JG14_12","008_14_12","JDG","14","12","12","ויאמר להם שמשון אחודה נא לכם חידה אם הגד תגידו אותה לי שבעת ימי המשתה ומצאתם ונתתי לכם שלשים סדינים ושלשים חלפת בגדים׃ ");
INSERT INTO heb_vpl VALUES ("JG14_13","008_14_13","JDG","14","13","13","ואם לא תוכלו להגיד לי ונתתם אתם לי שלשים סדינים ושלשים חליפות בגדים ויאמרו לו חודה חידתך ונשמענה׃ ");
INSERT INTO heb_vpl VALUES ("JG14_14","008_14_14","JDG","14","14","14","ויאמר להם מהאכל יצא מאכל ומעז יצא מתוק ולא יכלו להגיד החידה שלשת ימים׃ ");
INSERT INTO heb_vpl VALUES ("JG14_15","008_14_15","JDG","14","15","15","ויהי ביום השביעי ויאמרו לאשת שמשון פתי את אישך ויגד לנו את החידה פן נשרף אותך ואת בית אביך באש הלירשנו קראתם לנו הלא׃ ");
INSERT INTO heb_vpl VALUES ("JG14_16","008_14_16","JDG","14","16","16","ותבך אשת שמשון עליו ותאמר רק שנאתני ולא אהבתני החידה חדת לבני עמי ולי לא הגדתה ויאמר לה הנה לאבי ולאמי לא הגדתי ולך אגיד׃ ");
INSERT INTO heb_vpl VALUES ("JG14_17","008_14_17","JDG","14","17","17","ותבך עליו שבעת הימים אשר היה להם המשתה ויהי ביום השביעי ויגד לה כי הציקתהו ותגד החידה לבני עמה׃ ");
INSERT INTO heb_vpl VALUES ("JG14_18","008_14_18","JDG","14","18","18","ויאמרו לו אנשי העיר ביום השביעי בטרם יבא החרסה מה מתוק מדבש ומה עז מארי ויאמר להם לולא חרשתם בעגלתי לא מצאתם חידתי׃ ");
INSERT INTO heb_vpl VALUES ("JG14_19","008_14_19","JDG","14","19","19","ותצלח עליו רוח יהוה וירד אשקלון ויך מהם שלשים איש ויקח את חליצותם ויתן החליפות למגידי החידה ויחר אפו ויעל בית אביהו׃ ");
INSERT INTO heb_vpl VALUES ("JG14_20","008_14_20","JDG","14","20","20","ותהי אשת שמשון למרעהו אשר רעה לו׃ ");
INSERT INTO heb_vpl VALUES ("JG15_1","008_15_1","JDG","15","1","1","ויהי מימים בימי קציר חטים ויפקד שמשון את אשתו בגדי עזים ויאמר אבאה אל אשתי החדרה ולא נתנו אביה לבוא׃ ");
INSERT INTO heb_vpl VALUES ("JG15_2","008_15_2","JDG","15","2","2","ויאמר אביה אמר אמרתי כי שנא שנאתה ואתננה למרעך הלא אחתה הקטנה טובה ממנה תהי נא לך תחתיה׃ ");
INSERT INTO heb_vpl VALUES ("JG15_3","008_15_3","JDG","15","3","3","ויאמר להם שמשון נקיתי הפעם מפלשתים כי עשה אני עמם רעה׃ ");
INSERT INTO heb_vpl VALUES ("JG15_4","008_15_4","JDG","15","4","4","וילך שמשון וילכד שלש מאות שועלים ויקח לפדים ויפן זנב אל זנב וישם לפיד אחד בין שני הזנבות בתוך׃ ");
INSERT INTO heb_vpl VALUES ("JG15_5","008_15_5","JDG","15","5","5","ויבער אש בלפידים וישלח בקמות פלשתים ויבער מגדיש ועד קמה ועד כרם זית׃ ");
INSERT INTO heb_vpl VALUES ("JG15_6","008_15_6","JDG","15","6","6","ויאמרו פלשתים מי עשה זאת ויאמרו שמשון חתן התמני כי לקח את אשתו ויתנה למרעהו ויעלו פלשתים וישרפו אותה ואת אביה באש׃ ");
INSERT INTO heb_vpl VALUES ("JG15_7","008_15_7","JDG","15","7","7","ויאמר להם שמשון אם תעשון כזאת כי אם נקמתי בכם ואחר אחדל׃ ");
INSERT INTO heb_vpl VALUES ("JG15_8","008_15_8","JDG","15","8","8","ויך אותם שוק על ירך מכה גדולה וירד וישב בסעיף סלע עיטם׃ ");
INSERT INTO heb_vpl VALUES ("JG15_9","008_15_9","JDG","15","9","9","ויעלו פלשתים ויחנו ביהודה וינטשו בלחי׃ ");
INSERT INTO heb_vpl VALUES ("JG15_10","008_15_10","JDG","15","10","10","ויאמרו איש יהודה למה עליתם עלינו ויאמרו לאסור את שמשון עלינו לעשות לו כאשר עשה לנו׃ ");
INSERT INTO heb_vpl VALUES ("JG15_11","008_15_11","JDG","15","11","11","וירדו שלשת אלפים איש מיהודה אל סעיף סלע עיטם ויאמרו לשמשון הלא ידעת כי משלים בנו פלשתים ומה זאת עשית לנו ויאמר להם כאשר עשו לי כן עשיתי להם׃ ");
INSERT INTO heb_vpl VALUES ("JG15_12","008_15_12","JDG","15","12","12","ויאמרו לו לאסרך ירדנו לתתך ביד פלשתים ויאמר להם שמשון השבעו לי פן תפגעון בי אתם׃ ");
INSERT INTO heb_vpl VALUES ("JG15_13","008_15_13","JDG","15","13","13","ויאמרו לו לאמר לא כי אסר נאסרך ונתנוך בידם והמת לא נמיתך ויאסרהו בשנים עבתים חדשים ויעלוהו מן הסלע׃ ");
INSERT INTO heb_vpl VALUES ("JG15_14","008_15_14","JDG","15","14","14","הוא בא עד לחי ופלשתים הריעו לקראתו ותצלח עליו רוח יהוה ותהיינה העבתים אשר על זרועותיו כפשתים אשר בערו באש וימסו אסוריו מעל ידיו׃ ");
INSERT INTO heb_vpl VALUES ("JG15_15","008_15_15","JDG","15","15","15","וימצא לחי חמור טריה וישלח ידו ויקחה ויך בה אלף איש׃ ");
INSERT INTO heb_vpl VALUES ("JG15_16","008_15_16","JDG","15","16","16","ויאמר שמשון בלחי החמור חמור חמרתים בלחי החמור הכיתי אלף איש׃ ");
INSERT INTO heb_vpl VALUES ("JG15_17","008_15_17","JDG","15","17","17","ויהי ככלתו לדבר וישלך הלחי מידו ויקרא למקום ההוא רמת לחי׃ ");
INSERT INTO heb_vpl VALUES ("JG15_18","008_15_18","JDG","15","18","18","ויצמא מאד ויקרא אל יהוה ויאמר אתה נתת ביד עבדך את התשועה הגדלה הזאת ועתה אמות בצמא ונפלתי ביד הערלים׃ ");
INSERT INTO heb_vpl VALUES ("JG15_19","008_15_19","JDG","15","19","19","ויבקע אלהים את המכתש אשר בלחי ויצאו ממנו מים וישת ותשב רוחו ויחי על כן קרא שמה עין הקורא אשר בלחי עד היום הזה׃ ");
INSERT INTO heb_vpl VALUES ("JG15_20","008_15_20","JDG","15","20","20","וישפט את ישראל בימי פלשתים עשרים שנה׃ ");
INSERT INTO heb_vpl VALUES ("JG16_1","008_16_1","JDG","16","1","1","וילך שמשון עזתה וירא שם אשה זונה ויבא אליה׃ ");
INSERT INTO heb_vpl VALUES ("JG16_2","008_16_2","JDG","16","2","2","לעזתים לאמר בא שמשון הנה ויסבו ויארבו לו כל הלילה בשער העיר ויתחרשו כל הלילה לאמר עד אור הבקר והרגנהו׃ ");
INSERT INTO heb_vpl VALUES ("JG16_3","008_16_3","JDG","16","3","3","וישכב שמשון עד חצי הלילה ויקם בחצי הלילה ויאחז בדלתות שער העיר ובשתי המזוזות ויסעם עם הבריח וישם על כתפיו ויעלם אל ראש ההר אשר על פני חברון׃ ");
INSERT INTO heb_vpl VALUES ("JG16_4","008_16_4","JDG","16","4","4","ויהי אחרי כן ויאהב אשה בנחל שרק ושמה דלילה׃ ");
INSERT INTO heb_vpl VALUES ("JG16_5","008_16_5","JDG","16","5","5","ויעלו אליה סרני פלשתים ויאמרו לה פתי אותו וראי במה כחו גדול ובמה נוכל לו ואסרנהו לענתו ואנחנו נתן לך איש אלף ומאה כסף׃ ");
INSERT INTO heb_vpl VALUES ("JG16_6","008_16_6","JDG","16","6","6","ותאמר דלילה אל שמשון הגידה נא לי במה כחך גדול ובמה תאסר לענותך׃ ");
INSERT INTO heb_vpl VALUES ("JG16_7","008_16_7","JDG","16","7","7","ויאמר אליה שמשון אם יאסרני בשבעה יתרים לחים אשר לא חרבו וחליתי והייתי כאחד האדם׃ ");
INSERT INTO heb_vpl VALUES ("JG16_8","008_16_8","JDG","16","8","8","ויעלו לה סרני פלשתים שבעה יתרים לחים אשר לא חרבו ותאסרהו בהם׃ ");
INSERT INTO heb_vpl VALUES ("JG16_9","008_16_9","JDG","16","9","9","והארב ישב לה בחדר ותאמר אליו פלשתים עליך שמשון וינתק את היתרים כאשר ינתק פתיל הנערת בהריחו אש ולא נודע כחו׃ ");
INSERT INTO heb_vpl VALUES ("JG16_10","008_16_10","JDG","16","10","10","ותאמר דלילה אל שמשון הנה התלת בי ותדבר אלי כזבים עתה הגידה נא לי במה תאסר׃ ");
INSERT INTO heb_vpl VALUES ("JG16_11","008_16_11","JDG","16","11","11","ויאמר אליה אם אסור יאסרוני בעבתים חדשים אשר לא נעשה בהם מלאכה וחליתי והייתי כאחד האדם׃ ");
INSERT INTO heb_vpl VALUES ("JG16_12","008_16_12","JDG","16","12","12","ותקח דלילה עבתים חדשים ותאסרהו בהם ותאמר אליו פלשתים עליך שמשון והארב ישב בחדר וינתקם מעל זרעתיו כחוט׃ ");
INSERT INTO heb_vpl VALUES ("JG16_13","008_16_13","JDG","16","13","13","ותאמר דלילה אל שמשון עד הנה התלת בי ותדבר אלי כזבים הגידה לי במה תאסר ויאמר אליה אם תארגי את שבע מחלפות ראשי עם המסכת׃ ");
INSERT INTO heb_vpl VALUES ("JG16_14","008_16_14","JDG","16","14","14","ותתקע ביתד ותאמר אליו פלשתים עליך שמשון וייקץ משנתו ויסע את היתד הארג ואת המסכת׃ ");
INSERT INTO heb_vpl VALUES ("JG16_15","008_16_15","JDG","16","15","15","ותאמר אליו איך תאמר אהבתיך ולבך אין אתי זה שלש פעמים התלת בי ולא הגדת לי במה כחך גדול׃ ");
INSERT INTO heb_vpl VALUES ("JG16_16","008_16_16","JDG","16","16","16","ויהי כי הציקה לו בדבריה כל הימים ותאלצהו ותקצר נפשו למות׃ ");
INSERT INTO heb_vpl VALUES ("JG16_17","008_16_17","JDG","16","17","17","ויגד לה את כל לבו ויאמר לה מורה לא עלה על ראשי כי נזיר אלהים אני מבטן אמי אם גלחתי וסר ממני כחי וחליתי והייתי ככל האדם׃ ");
INSERT INTO heb_vpl VALUES ("JG16_18","008_16_18","JDG","16","18","18","ותרא דלילה כי הגיד לה את כל לבו ותשלח ותקרא לסרני פלשתים לאמר עלו הפעם כי הגיד לה את כל לבו ועלו אליה סרני פלשתים ויעלו הכסף בידם׃ ");
INSERT INTO heb_vpl VALUES ("JG16_19","008_16_19","JDG","16","19","19","ותישנהו על ברכיה ותקרא לאיש ותגלח את שבע מחלפות ראשו ותחל לענותו ויסר כחו מעליו׃ ");
INSERT INTO heb_vpl VALUES ("JG16_20","008_16_20","JDG","16","20","20","ותאמר פלשתים עליך שמשון ויקץ משנתו ויאמר אצא כפעם בפעם ואנער והוא לא ידע כי יהוה סר מעליו׃ ");
INSERT INTO heb_vpl VALUES ("JG16_21","008_16_21","JDG","16","21","21","ויאחזוהו פלשתים וינקרו את עיניו ויורידו אותו עזתה ויאסרוהו בנחשתים ויהי טוחן בבית האסירים׃ ");
INSERT INTO heb_vpl VALUES ("JG16_22","008_16_22","JDG","16","22","22","ויחל שער ראשו לצמח כאשר גלח׃ ");
INSERT INTO heb_vpl VALUES ("JG16_23","008_16_23","JDG","16","23","23","וסרני פלשתים נאספו לזבח זבח גדול לדגון אלהיהם ולשמחה ויאמרו נתן אלהינו בידנו את שמשון אויבינו׃ ");
INSERT INTO heb_vpl VALUES ("JG16_24","008_16_24","JDG","16","24","24","ויראו אתו העם ויהללו את אלהיהם כי אמרו נתן אלהינו בידנו את אויבנו ואת מחריב ארצנו ואשר הרבה את חללינו׃ ");
INSERT INTO heb_vpl VALUES ("JG16_25","008_16_25","JDG","16","25","25","ויהי כי טוב לבם ויאמרו קראו לשמשון וישחק לנו ויקראו לשמשון מבית האסירים ויצחק לפניהם ויעמידו אותו בין העמודים׃ ");
INSERT INTO heb_vpl VALUES ("JG16_26","008_16_26","JDG","16","26","26","ויאמר שמשון אל הנער המחזיק בידו הניחה אותי והימשני את העמדים אשר הבית נכון עליהם ואשען עליהם׃ ");
INSERT INTO heb_vpl VALUES ("JG16_27","008_16_27","JDG","16","27","27","והבית מלא האנשים והנשים ושמה כל סרני פלשתים ועל הגג כשלשת אלפים איש ואשה הראים בשחוק שמשון׃ ");
INSERT INTO heb_vpl VALUES ("JG16_28","008_16_28","JDG","16","28","28","ויקרא שמשון אל יהוה ויאמר אדני יהוה זכרני נא וחזקני נא אך הפעם הזה האלהים ואנקמה נקם אחת משתי עיני מפלשתים׃ ");
INSERT INTO heb_vpl VALUES ("JG16_29","008_16_29","JDG","16","29","29","וילפת שמשון את שני עמודי התוך אשר הבית נכון עליהם ויסמך עליהם אחד בימינו ואחד בשמאלו׃ ");
INSERT INTO heb_vpl VALUES ("JG16_30","008_16_30","JDG","16","30","30","ויאמר שמשון תמות נפשי עם פלשתים ויט בכח ויפל הבית על הסרנים ועל כל העם אשר בו ויהיו המתים אשר המית במותו רבים מאשר המית בחייו׃ ");
INSERT INTO heb_vpl VALUES ("JG16_31","008_16_31","JDG","16","31","31","וירדו אחיו וכל בית אביהו וישאו אתו ויעלו ויקברו אותו בין צרעה ובין אשתאל בקבר מנוח אביו והוא שפט את ישראל עשרים שנה׃ ");
INSERT INTO heb_vpl VALUES ("JG17_1","008_17_1","JDG","17","1","1","ויהי איש מהר אפרים ושמו מיכיהו׃ ");
INSERT INTO heb_vpl VALUES ("JG17_2","008_17_2","JDG","17","2","2","ויאמר לאמו אלף ומאה הכסף אשר לקח לך ואתי אלית וגם אמרת באזני הנה הכסף אתי אני לקחתיו ותאמר אמו ברוך בני ליהוה׃ ");
INSERT INTO heb_vpl VALUES ("JG17_3","008_17_3","JDG","17","3","3","וישב את אלף ומאה הכסף לאמו ותאמר אמו הקדש הקדשתי את הכסף ליהוה מידי לבני לעשות פסל ומסכה ועתה אשיבנו לך׃ ");
INSERT INTO heb_vpl VALUES ("JG17_4","008_17_4","JDG","17","4","4","וישב את הכסף לאמו ותקח אמו מאתים כסף ותתנהו לצורף ויעשהו פסל ומסכה ויהי בבית מיכיהו׃ ");
INSERT INTO heb_vpl VALUES ("JG17_5","008_17_5","JDG","17","5","5","והאיש מיכה לו בית אלהים ויעש אפוד ותרפים וימלא את יד אחד מבניו ויהי לו לכהן׃ ");
INSERT INTO heb_vpl VALUES ("JG17_6","008_17_6","JDG","17","6","6","בימים ההם אין מלך בישראל איש הישר בעיניו יעשה׃ ");
INSERT INTO heb_vpl VALUES ("JG17_7","008_17_7","JDG","17","7","7","ויהי נער מבית לחם יהודה ממשפחת יהודה והוא לוי והוא גר שם׃ ");
INSERT INTO heb_vpl VALUES ("JG17_8","008_17_8","JDG","17","8","8","וילך האיש מהעיר מבית לחם יהודה לגור באשר ימצא ויבא הר אפרים עד בית מיכה לעשות דרכו׃ ");
INSERT INTO heb_vpl VALUES ("JG17_9","008_17_9","JDG","17","9","9","ויאמר לו מיכה מאין תבוא ויאמר אליו לוי אנכי מבית לחם יהודה ואנכי הלך לגור באשר אמצא׃ ");
INSERT INTO heb_vpl VALUES ("JG17_10","008_17_10","JDG","17","10","10","ויאמר לו מיכה שבה עמדי והיה לי לאב ולכהן ואנכי אתן לך עשרת כסף לימים וערך בגדים ומחיתך וילך הלוי׃ ");
INSERT INTO heb_vpl VALUES ("JG17_11","008_17_11","JDG","17","11","11","ויואל הלוי לשבת את האיש ויהי הנער לו כאחד מבניו׃ ");
INSERT INTO heb_vpl VALUES ("JG17_12","008_17_12","JDG","17","12","12","וימלא מיכה את יד הלוי ויהי לו הנער לכהן ויהי בבית מיכה׃ ");
INSERT INTO heb_vpl VALUES ("JG17_13","008_17_13","JDG","17","13","13","ויאמר מיכה עתה ידעתי כי ייטיב יהוה לי כי היה לי הלוי לכהן׃ ");
INSERT INTO heb_vpl VALUES ("JG18_1","008_18_1","JDG","18","1","1","בימים ההם אין מלך בישראל ובימים ההם שבט הדני מבקש לו נחלה לשבת כי לא נפלה לו עד היום ההוא בתוך שבטי ישראל בנחלה׃ ");
INSERT INTO heb_vpl VALUES ("JG18_2","008_18_2","JDG","18","2","2","וישלחו בני דן ממשפחתם חמשה אנשים מקצותם אנשים בני חיל מצרעה ומאשתאל לרגל את הארץ ולחקרה ויאמרו אלהם לכו חקרו את הארץ ויבאו הר אפרים עד בית מיכה וילינו שם׃ ");
INSERT INTO heb_vpl VALUES ("JG18_3","008_18_3","JDG","18","3","3","המה עם בית מיכה והמה הכירו את קול הנער הלוי ויסורו שם ויאמרו לו מי הביאך הלם ומה אתה עשה בזה ומה לך פה׃ ");
INSERT INTO heb_vpl VALUES ("JG18_4","008_18_4","JDG","18","4","4","ויאמר אלהם כזה וכזה עשה לי מיכה וישכרני ואהי לו לכהן׃ ");
INSERT INTO heb_vpl VALUES ("JG18_5","008_18_5","JDG","18","5","5","ויאמרו לו שאל נא באלהים ונדעה התצליח דרכנו אשר אנחנו הלכים עליה׃ ");
INSERT INTO heb_vpl VALUES ("JG18_6","008_18_6","JDG","18","6","6","ויאמר להם הכהן לכו לשלום נכח יהוה דרככם אשר תלכו בה׃ ");
INSERT INTO heb_vpl VALUES ("JG18_7","008_18_7","JDG","18","7","7","וילכו חמשת האנשים ויבאו לישה ויראו את העם אשר בקרבה יושבת לבטח כמשפט צדנים שקט ובטח ואין מכלים דבר בארץ יורש עצר ורחקים המה מצדנים ודבר אין להם עם אדם׃ ");
INSERT INTO heb_vpl VALUES ("JG18_8","008_18_8","JDG","18","8","8","ויבאו אל אחיהם צרעה ואשתאל ויאמרו להם אחיהם מה אתם׃ ");
INSERT INTO heb_vpl VALUES ("JG18_9","008_18_9","JDG","18","9","9","ויאמרו קומה ונעלה עליהם כי ראינו את הארץ והנה טובה מאד ואתם מחשים אל תעצלו ללכת לבא לרשת את הארץ׃ ");
INSERT INTO heb_vpl VALUES ("JG18_10","008_18_10","JDG","18","10","10","כבאכם תבאו אל עם בטח והארץ רחבת ידים כי נתנה אלהים בידכם מקום אשר אין שם מחסור כל דבר אשר בארץ׃ ");
INSERT INTO heb_vpl VALUES ("JG18_11","008_18_11","JDG","18","11","11","ויסעו משם ממשפחת הדני מצרעה ומאשתאל שש מאות איש חגור כלי מלחמה׃ ");
INSERT INTO heb_vpl VALUES ("JG18_12","008_18_12","JDG","18","12","12","ויעלו ויחנו בקרית יערים ביהודה על כן קראו למקום ההוא מחנה דן עד היום הזה הנה אחרי קרית יערים׃ ");
INSERT INTO heb_vpl VALUES ("JG18_13","008_18_13","JDG","18","13","13","ויעברו משם הר אפרים ויבאו עד בית מיכה׃ ");
INSERT INTO heb_vpl VALUES ("JG18_14","008_18_14","JDG","18","14","14","ויענו חמשת האנשים ההלכים לרגל את הארץ ליש ויאמרו אל אחיהם הידעתם כי יש בבתים האלה אפוד ותרפים ופסל ומסכה ועתה דעו מה תעשו׃ ");
INSERT INTO heb_vpl VALUES ("JG18_15","008_18_15","JDG","18","15","15","ויסורו שמה ויבאו 