﻿USE sofia;
DROP TABLE IF EXISTS sofia.hch_vpl;
CREATE TABLE hch_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES hch_vpl WRITE;
INSERT INTO hch_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Tsutɨapai Kakaɨyari muyuawi meta kwie kaniutawewieni. ");
INSERT INTO hch_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Kwie puyuxamuriekai meta pakumawekai, hapa 'ameukateewa yɨriya penukanakai. Kakaɨyari 'iyarieya haa heima pɨyeyeikakai. ");
INSERT INTO hch_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Hikɨ Kakaɨyari mɨpaɨ kaniutayɨni: «Hekɨariya ke'uneni». 'Ana hekɨariya kaniuneni. ");
INSERT INTO hch_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Kakaɨyari hekɨariya 'aixɨa katiniuxeiya, 'ana yɨriyatsata kanipata. ");
INSERT INTO hch_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Hekɨariya «tukari» katiniuterɨwa, yɨriyata «tɨkari». Hikɨ kaniukɨyɨre, ximerita kanayani, mexɨakame tukari kanayani. ");
INSERT INTO hch_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Kakaɨyari mɨpaɨ kaniutayɨni: «'Amakuyewa ke'uneni haa hixɨapa ke'ipata haa taheima mieme meta kwiepa mieme». ");
INSERT INTO hch_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Mɨpaɨ katiniuyɨni. Kakaɨyari 'amakuyewa kaniutawewieni, mipataxɨanikɨ haa, tahetɨa mɨtamakakɨ, taheimata muyemakakɨ. ");
INSERT INTO hch_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","'Amakuyewa, Kakaɨyari «muyuawi» katiniuterɨwa. Hikɨ kaniukuyɨre, ximerita kanayani, Hutarieka tukari kanayani. ");
INSERT INTO hch_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Hikɨ Kakaɨyari mɨpaɨ kaniutayɨni: «Haa muyuawitɨa mɨtama ke'uyukuxeɨrieni 'axeikɨa, 'uwakitɨ ke'ayani». Kemutayɨ mɨpaɨ pɨtiɨyɨ. ");
INSERT INTO hch_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Muwaki «kwie» Kakaɨyari katiniterɨwa, haa muyukuxeɨri «haramara» katiniterɨwa. 'Ixeiyatɨ Kakaɨyari «'Aixɨa pɨ'ane», kaniutayɨni. ");
INSERT INTO hch_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Hikɨta Kakaɨyari mɨpaɨ kaniutayɨni: «Ketiutineni kwiepa, ke'utineni tupiriyate yuhatsiyarite hexeiyatɨ, 'iteɨrite yutakari kehexeiyatɨkani meta yuhatsiyarite. Naitɨ xexuitɨ kemɨtiupitɨarie». Mɨpaɨ katiniuyɨni. ");
INSERT INTO hch_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","'Ana katiniutineni naitɨ, tupiriyate yuhatsiyari hexeiyatɨ, kɨyexi yu'ikwaxi yuhatsiyari hexeiyatɨ kanayani, naitɨ kemɨtiupitɨarie. Kakaɨyari mɨkɨ 'aixɨa katiniuxeiya. ");
INSERT INTO hch_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Hikɨ kaniukuyɨre, ximerita kanayani, hairieka tukari kanayani. ");
INSERT INTO hch_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Kakaɨyari mɨpaɨta kaniutayɨni: «Meke'utixuawere muyuawitsie hekɨariwiwamete, meke'ipata tukari tɨkari, mɨkɨ 'inɨari meke'akɨne taxarita, witarita, 'ahurakaku, xexerixa, tukari meta wiyari, 'inɨariyari meke'akɨne. ");
INSERT INTO hch_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Muyuawitsie meke'utimerɨkani, kwiepata memɨhekɨariwiekakɨ». Mɨpaɨ katiniuyɨni. ");
INSERT INTO hch_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Kakaɨyari hutame mamariwaweme hekɨariwiwamete kaniutiwewieni, xeime 'anekame tau tukarikɨ mieme, xeimeta yakɨ tixawatɨme metseri tɨkarikɨ mieme, meta xurawetsixi tɨkarikɨ miemete. ");
INSERT INTO hch_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Kakaɨyari hekɨariwiwamete muyuawitsie katiniwarukayatsa memɨhekɨariwiekakɨ kwiepa. ");
INSERT INTO hch_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Pɨwarutiwewi mɨme matsi waɨkawa memɨmamariwawenikɨ tukarikɨ tɨkarikɨ, hekɨariya memɨpatanikɨ. Hikɨ Kakaɨyari «'Aixɨa pɨ'ane», kaniutayɨni. ");
INSERT INTO hch_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Hikɨ kaniukɨyɨre, ximerita kanayani. Naurieka tukari kanayani. ");
INSERT INTO hch_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Mɨpaɨ kaniutayɨni Kakaɨyari: «Yumɨiretɨ haapa meketeye'uwani, meketeheɨwɨtɨkani wikixi kwie heima muyuawi kemɨyewa». ");
INSERT INTO hch_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Hikɨ Kakaɨyari katiniwarutiwewieni yunaime metemamariwaweme haramaratsie miemete, meta yunaime memɨte'ayeneniere 'etsimepepetɨ memɨkuyuatɨka memɨyuxiɨtɨa haata paitɨ, meta yunaime memɨte'awɨwawe, yuxexuime kemɨtiwarupitɨa. Hikɨ Kakaɨyari 'aixɨa katiniwaruxeiya. ");
INSERT INTO hch_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","'Aixɨa kaniwaruyurieni mɨpaɨ 'utaitɨ: «Xekeneyuxiɨtɨaka xekeneyumɨiriyani, xekenehɨneni haapa haramaratsie. Wikixi meta xekeneyɨmɨiriyani kwiepa». ");
INSERT INTO hch_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Hikɨ kaniukuyɨre, ximerita kanayani, 'auxɨwirieka tukari kanayani. ");
INSERT INTO hch_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Kakaɨyari mɨpaɨ kaniutayɨni: «Xekeneyɨmɨiriyani kwiepa yunaitɨ xemayeyuyurini, yunaitɨ memɨteyutewatsinɨa, yeutari meta, yuhukama memuku'uwa kwiepa, yunaime kememɨteheupaɨme». Mɨpaɨ pɨtiuyɨ. ");
INSERT INTO hch_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Kakaɨyari yunaime katiniwarunetɨani memɨteyutewatsinɨa, yeutari, yunaime yuhukama memɨteku'uwa, yunaime kemɨtiwarupitɨa. Kakaɨyari mɨpaɨ kaniutayɨni: «'Aixɨa pɨ'ane». ");
INSERT INTO hch_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Mɨpaɨta kaniutayɨni: «Tewi tepɨtawewieni tahepaɨ tiyuxexeiyame tahepaɨ tiyɨkɨhɨaweme. Pɨtiwata'aitɨani ketsɨte haramaratsie miemete, wikixi meta muyuawitsie miemete, yunaime memɨteyutewatsinɨa, yeutari, yunaime memɨka'ukɨniwawe yuhukama memuku'uwa kwiepa». ");
INSERT INTO hch_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Kakaɨyari tewi kaniutawewieni yuhepaɨ 'anekame, pitawewi 'inɨarieya mayanikɨ yuhepaɨ 'anekame. 'Uki meta 'uka pɨwarutiwewi. ");
INSERT INTO hch_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","'Aixɨa kaniwaruyurieni mɨpaɨ 'utaitɨ: «Xekeneyuxiɨtɨaka xekeneyɨmɨiriyani, kwiepa xekenehɨneni xeketene'aitani. Xepɨhɨritɨarieni ketsɨte haramaratsie miemete, wikixi yunaime muyuawitsie miemete, yunaime memɨka'ukɨniwawe yuhukama memuku'uwa kwiepa». ");
INSERT INTO hch_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Mɨpaɨta katiniwarutahɨawe: «Ne nepɨxeyetuiri kwiepa mieme 'iteɨrite, naime 'iteɨrite yuhatsiyari hexeiyakame, naime 'iteɨrite yutakari yuhatsiyari hexeiyakame. Mɨkɨ naitɨ xe'ikwai pɨrayani. ");
INSERT INTO hch_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Tupiriya nepɨxeyetuirieni, xe'ikwai mayanikɨ, yunaitɨ yeutari kwiepa memɨtexuawe, yunaitɨ wikixi muyuawitsie miemete yunaitɨ memeumaketɨka kwiepa». Kemutayɨ mɨpaɨ pɨtiuyɨ. ");
INSERT INTO hch_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Kakaɨyari naime katiniuxeiya tita mɨtiutiwewi. «'Aixɨa pɨ'ane», kaniutayɨni. Hikɨ kaniukuyɨre, ximerita kanayani, 'ataxewirieka tukari kanayani. ");
INSERT INTO hch_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Mɨpaɨ katiniutinɨrieni muyuawi, kwie meta naitɨ tita hetsiena mɨtixuawe. ");
INSERT INTO hch_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","'Atahutarieka tukaritsie, Kakaɨyari kaniuka'uxipieni, naime mɨtiutinɨkɨ yu'uximayatsika kemɨtiuyɨhɨawixɨ. ");
INSERT INTO hch_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Kakaɨyari 'aixɨa kaniyurieni 'atahutarieka tukari hetsiena mieme mɨpatsiekakɨ, 'ana muka'uxipikɨ, naime yu'uximayatsika tiutinɨka muyuawi meta kwie kemɨtiutawewi. ");
INSERT INTO hch_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Kepauka mɨtiutiwewiya muyuawi meta kwie, 'ikɨ pɨ'ɨxatsiyari. Kepauka Yawé Kakaɨyari muyuawi meta kwie mutiwewi, ");
INSERT INTO hch_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","'ana 'akuxi 'iteɨrite pɨtiumawekai pɨkatitinewekai tupiriyate. 'Ana 'akuxi wiyeri Yawé Kakaɨyari pɨkakuyuitɨwakai, 'ana 'akuxi 'apɨka'uyeikakai tewi mɨtita'uximayatakɨ. ");
INSERT INTO hch_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Matsi kwiepa kaniti'ekekaitɨni 'aɨxi. Mɨkɨ naime kwie puyuniyakai. ");
INSERT INTO hch_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Hikɨ Yawé Kakaɨyari tewi kaniutawewieni kwiekɨ. Tsurieyatsie 'ihɨtsieka tukari kanipitɨani mayenierenikɨ muta'iwenikɨ. 'Ana 'ayeyuritɨ tewi kanayani. ");
INSERT INTO hch_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Yawé Kakaɨyari haraweri kaniutawewieni 'Ereni mɨrakutewatsie, tau manatineika hepatsie. Tewi mutawewi muwa katiniuhɨritɨani. ");
INSERT INTO hch_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Yawé Kakaɨyari kanitinetɨani mɨtiwerekɨ naime xexuime 'iteɨrite witsitiuxuxuawereme 'aixɨa 'aneneme kwaiyari. Haraweri hixɨapa 'iteɨri tukari tiyupitɨwame kaniutinetɨani, xeimeta 'iteɨri putinetɨa mɨtimaikakɨ tita 'aixɨa mɨti'ane tita 'axamɨti'ane. ");
INSERT INTO hch_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","'Ereni payeneikakai hatuxame mariwetɨ pɨ'ipakai harawerita, manata nauka 'akiyarite puhapanekai pɨtihatuiyakai harawerita. ");
INSERT INTO hch_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Mexɨakame pɨtitewakai Pitsuni, naitsarie puyehanekai Kawira mɨrakutewatsie hakewa huru maxuawekaitsie. ");
INSERT INTO hch_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Huru 'aixɨa pɨ'ane 'iya kwieyaritsie mieme. Puxuaweta xetsina witsi'anetɨ, puxuaweta 'unitse teteyari mutuxa. ");
INSERT INTO hch_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Hutarieka mieme haa pɨtitewakai Kikuni mɨkɨ Kutsi kwieyaritsie 'aurie kananakuneka naitsarie. ");
INSERT INTO hch_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Hairieka mieme haa, Tikɨritsi pɨtitewakai mɨkɨ 'Atsiriya tserieta puyehane. Naurieka mieme 'Eupɨrate hatuxameyari pɨhɨkɨ. ");
INSERT INTO hch_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Merikɨtsɨ Yawé Kakaɨyari tewi kaniuhɨritɨani haraweri 'Ereni mɨti'uximayakakɨ, mɨti'ɨwiyanikɨ. ");
INSERT INTO hch_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Yawé Kakaɨyari kanihɨritɨani mɨpaɨ rehɨawetɨ: «Ketinekwaka naime 'ikwaxi harawerita mieme. ");
INSERT INTO hch_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Peru mɨkɨ 'iteɨri xeikɨa, tewi xɨka 'itikwani 'ikwaxiyari mɨkɨ tewi pɨretimani tita 'aixɨa mɨti'ane tita 'axamɨti'ane, mɨkɨ 'iteɨri 'ikwaxiyari pepɨkakwaka. Mexɨka pe'itikwani, 'ana pepɨmɨni». ");
INSERT INTO hch_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Hikɨta Yawé Kakaɨyari mɨpaɨ kaniutayɨni: «'Aixɨa pɨka'ane, 'uki yuxaɨta muyeikanikɨ. Peiyehɨwa yuteɨtame. Nepitawewirieni 'iparewiwame hetsiena mieme». ");
INSERT INTO hch_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Yawé Kakaɨyari katiniwarunetɨani 'ena kwiepa yunaime memɨte'awɨwawe meta yunaime yeutari, hikɨ Kakaɨyari 'uki hetsɨa kaniwa'atɨani muwatiterɨwakɨ yuxexuime. 'Uki kaniwarutiterɨwa yunaime kememɨteheupaɨme, hikɨ mɨpaɨ mepɨtematiwa. ");
INSERT INTO hch_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Mɨpaɨ 'ana tewi kaniwarutiterɨwa yunaime keyupaɨmetɨ memɨtexɨawe memɨteyutewatsinɨa, yunaime memɨte'awɨwawe, yunaime yeutari. Matsi mɨkɨ nixewitɨ tewi parewiwameya yemekɨ pɨka'atɨa. ");
INSERT INTO hch_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Hikɨ Yawé Kakaɨyari 'uki heukutɨaka, waɨkawa kutsukaku kaniwakuhana 'akieya, hutariekata waiyarieya kaneunani. ");
INSERT INTO hch_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Mɨkɨ 'uki 'akieyakɨ, Yawé Kakaɨyari 'uka kaniutawewieni, hikɨ 'uki kani'atɨirieni. ");
INSERT INTO hch_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","'Arani 'uka xeiyatɨ mɨpaɨ kaniutayɨni: «'Ikɨ hɨrixɨa waiyarieya newaiyaritsie pumieme, 'umeyarieyata ne'umeyaritsie pumieme. “'Uka” katinitewakamɨkɨ 'uki waiyarieyakɨ mutawewiyakɨ». ");
INSERT INTO hch_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Mɨpaɨ mɨtiuyɨkɨ, 'ayumieme 'uki kaniyupatamɨkɨ yupaapa yumaama wahetsɨa kaniyeyeimɨkɨ, yɨ'ɨya hamatɨa mekaniyutaxewirikuni meyunaki'erietɨ, xeiwaiyari mekanakɨnikuni. ");
INSERT INTO hch_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Hikɨ 'uki meta 'uka mepumamawekai mepɨkayutetewiyakai. ");
INSERT INTO hch_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Kuu, kwinimieme katinimaiwekaitɨni keyuri hipatɨ yeutari Yawé Kakaɨyari muwarutawewiekai, hikɨ 'uka mɨpaɨ pɨtiuta'iwawiyaxɨ: ―¿Kakaɨyari mɨpaɨ pɨkahainekai xɨari kename xeka'ikwaka naime 'ikwaxi harawerita mieme? ");
INSERT INTO hch_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","'Uka mɨpaɨ katinita'eiya: —Tepɨyɨwawe naime 'ikwaxi temɨtikwanikɨ. ");
INSERT INTO hch_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Mɨkɨ xeikɨa 'iteɨri 'ikwaxiyari haraweri hixɨapa muwe, tepɨkayɨwawe temitikwanikɨ Kakaɨyari pɨtarahɨawekai kename teka'ikwakakekai 'ikwaxi mɨkɨ 'iteɨritsiemieme, xɨka te'itikwani tepɨkwini. ");
INSERT INTO hch_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Kuu 'uka mɨpaɨ kaniutahɨawe: —Tixaɨ xepɨkakwini. ");
INSERT INTO hch_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Kakaɨyari katinimaika kepauka xemitikwani mɨkɨ 'ikwaxi, kwinimieme xetemaiwawetɨ xepakɨne, xepɨtemaika tita 'aixɨa mɨti'ane, tita 'axamɨti'ane, Kakaɨyari hepaɨ xepɨ'aneneni. ");
INSERT INTO hch_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Hikɨ 'uka mɨkɨ 'ikwaxi witsi'anekame kaniuxeiya kanitihiwe'erieni mitakwanikɨ, timaiwetɨ mayanikɨ. Hikɨ kaneka'inɨni kanitakwani. Kwitɨta yɨkɨna kaniumini mɨkɨta kanitakwani. ");
INSERT INTO hch_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","'Ana kwitɨ mekananutaneniere yuhutatɨ 'arike mɨpaɨ mepɨtehetima mepɨmamawekai, hikɨ piní xawarikɨ petsera mekaniyutiwewirieni memuyutetewiyakaikɨ. ");
INSERT INTO hch_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","'Uki yɨ'ɨya hamatɨa mekani'enieni Yawé Kakaɨyari harawerita 'uyeikame taikai 'ekatsie, hikɨ mekaniyuti'awieta memɨmamawekaikɨ 'iteɨritsata harawerita. ");
INSERT INTO hch_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Peru Yawé Kakaɨyari 'uki kaniutahɨawe mɨpaɨ 'utaitɨ: —¿Hakewa pepeyeika? ");
INSERT INTO hch_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","'Uki mɨpaɨ kaniutayɨni: —Nepɨmatsi'u'eni 'uwa pe'uyeikame nepɨmatsi'utimaka nemɨmawekaikɨ, 'ayumieme nepɨyuti'awietaxɨ. ");
INSERT INTO hch_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Hikɨ Kakaɨyari mɨpaɨ kaniutayɨni: —¿Kemɨ'ane mɨpaɨ matiutahɨawixɨ kename pemawekai? Mɨkɨ 'ikwaxi nemɨxemaiwe'erikatsitɨakai xekate'utikwai. ");
INSERT INTO hch_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","'Uki mɨpaɨ kaniutayɨni: —Mɨkɨ 'uka pemɨnetsi'uwitɨtɨa, pɨnetsi'umi nepitakwai. ");
INSERT INTO hch_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Hikɨ Yawé Kakaɨyari 'uka mɨpaɨ katiniuta'iwawiya: —'Uka 'aku kepetiuyuri. 'Uka mɨpaɨ kaniutayɨni: —Kuu pɨnetiu'irɨwiyaxɨ 'ayumieme 'ikwaxi neputakwai. ");
INSERT INTO hch_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Yawé Kakaɨyari 'ayumieme kuu mɨpaɨ katiniutahɨawe: «Kuu 'aku 'axapepɨtiuyuri, Yeuta kiekatari watsata pe'uyeikatɨ, 'axapekani'itɨariekamɨkɨ. 'Ayumieme 'ahukama pepukuyeikani, tumuanari pekwatɨ yuheyemekɨ. ");
INSERT INTO hch_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","'Ekɨ kuu 'ukamatɨa xepayuye'unieka, meta 'aniwema 'uka niwemama wahamatɨa, 'uka nu'aya xewitɨ pumatikwinitɨani 'amu'utsie, 'ekɨta pepɨtikwinitɨani keputsayatsie». ");
INSERT INTO hch_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Meta 'uka mɨpaɨ katiniutahɨawe: «Kukuiniya nepɨtimɨiriya kepauka pemɨtiniweyanitsie, matsi 'akɨna pepinaki'erieka, mɨkɨ mati'aitɨwame payani». ");
INSERT INTO hch_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","'Uki meta mɨpaɨ katiniutahɨawe: «'Uki 'aku 'Arani, 'ekɨtsɨ pepenu'eni 'a'ɨya, pepitakwai 'ikwaxi, mɨkɨ kɨyetsie mieme tsepa mɨpaɨ nematiutahɨawixɨ pemɨka'ikwakakɨ. 'Ayumieme kwie 'axakani'itɨariekamɨkɨ mɨpaɨ pemɨtiuyurikɨ, haweri mieme peti'uximayatɨ xeikɨa pepɨtikwaka kwiepa mieme, mexi 'ape'uyeikani. ");
INSERT INTO hch_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Kwie kanitinetɨamɨkɨ xuya 'ahetsiemieme, yeuta mɨtiutixuxuawereni 'a'ikwai payeikani. ");
INSERT INTO hch_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Tukarikɨ peti'uximayatɨ pekwaxiyatɨ 'a'ikwaite pekatinexeiyakamɨkɨ, mexi kwiepa pekanuaweni, hakewa pemetawewiya. Tumuanari pekanihɨkɨtɨni, hutarieka pekaninuamɨkɨ tumuanari pemayanikɨ». ");
INSERT INTO hch_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","'Uki yu'ɨya 'Ewa pɨtiuterɨwaxɨ, mɨkɨ yunaime nuiwarite wamaama mayanikekaikɨ. ");
INSERT INTO hch_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Yawé Kakaɨyari puwarutiwewiri nawi kamixayari 'Arani meta 'ɨyaya, mɨkɨkɨ puwarutikemaritɨa. ");
INSERT INTO hch_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Hikɨ Yawé mɨpaɨ kaniutayɨni: «Hikɨri 'uki meta 'uka tahepaɨ mekani'aneneni, metemaitɨ tita 'aixɨa mɨti'ane tita 'axamɨti'ane, xɨka me'itikwani 'ikwaxi tukari mɨtiyupitɨwa, mepɨyɨwaweni yuheyemekɨ me'ayeyuyuritɨ memuyuhayewanikɨ». ");
INSERT INTO hch_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","'Ayumieme Yawé Kakaɨyari kaniwaranuyeweiya teɨteri 'Ereni haraweriyarita, kaniwarupitɨani memɨte'uximayakakɨ kwiepa, 'Arani kwiekɨ mutawewiyakɨ. ");
INSERT INTO hch_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Waranuyeweiyaka, haraweri 'Ereni tau manatineika hepatsie Kakaɨyari teɨtametemama memayeneniere meta xeime 'ixipara takame naitsarie 'uyuaneme, huye mɨ'ɨwiyanikɨ kɨye tukari tiyupitɨwame hetsɨa meutayune. ");
INSERT INTO hch_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","'Arani yu'ɨya 'Ewa hamatɨa xeime nunutsi mekanayexeiya Kahini katiniterɨwa. Mɨpaɨ kaniutayɨni 'Ewa: «Yawé netsiparewiekaku nunutsi 'ukitɨme nepayexei». ");
INSERT INTO hch_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","'Ariketa hutarieka 'Aweri kanayexeiya, Kahini mutaya. 'Aweri muxatsi wahɨweme kanayani, meta Kahini kwiepa ti'uximayatame patɨa. ");
INSERT INTO hch_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Mɨixa tukari 'anuyeyaku Kahini Yawé katiniutimawirieni tita kwiepa mɨtiuka'e. ");
INSERT INTO hch_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","'Aweri kani'atɨanita Yawé hetsiemieme muxa 'aixɨa mɨ'ane matɨari mieme muwaiya mawari mayanikɨ, Yawé 'Aweri 'aixɨa katiniuxeiya meta mawarieya pinakixɨ, ");
INSERT INTO hch_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","peru Kahini mɨpaɨ pɨkatiuxei meta mawarieya pɨka'inakixɨ. 'Ayumieme Kahini kaniuyeha'ani, yu'uximatɨatɨ 'aniuyeikakaitɨni. ");
INSERT INTO hch_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Hikɨ Yawé mɨpaɨ katinitahɨawe: «¿Titayari kwinimieme petiha'a? ¿Titayari peti'uxiwa'a petitihɨximawe? ");
INSERT INTO hch_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Xɨka 'aixɨa petiyurienenike heitserie pekanatinierenikeyu. Xɨka 'aixɨa pekatiyurieneni, 'axamɨ'ane kamenihupieka metsiwiyake tiyukwa'ame hepaɨ. Peru 'ekɨ pekaniyɨweni peme'iwa». ");
INSERT INTO hch_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Hikɨ Kahini yumuta 'Aweri hamatɨa katiniutixata. Kepauka yeuta yuxaɨta memu'uwakai, Kahini yumuta kaniumieni. ");
INSERT INTO hch_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Hikɨ Yawé Kahini mɨpaɨ katiniuta'iwawiya: —¿Hakewari 'a'iwa 'Aweri? Kahini mɨpaɨ kaniutayɨni: —Nepɨkatimate. ¿Nekuta ne'iwa neti'ɨwiyame? ");
INSERT INTO hch_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Yawé mɨpaɨ katinitahɨawe: —Kepetiuyuri. 'A'iwa xuriyaya kwiepa kumatɨ kanahiwani ne kename 'aixɨa neketiuyurieni. ");
INSERT INTO hch_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","'Ayumieme 'axapepɨ'itɨarieka kwie hepaɨtsita, 'a'iwa xuriyaya muta'itsikɨ, 'ekɨ pemitayeuri. ");
INSERT INTO hch_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Kepauka kwiepa pemɨka'eni, pɨkatiutixuxuawereni, kwiepa pepuyeikani peyuku'unanetɨ. ");
INSERT INTO hch_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kahini Yawé mɨpaɨ katiniutahɨawe: —Kwinimiemeri pepɨnetikwinitɨa nepɨkayɨweri neminewieka. ");
INSERT INTO hch_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Hikɨ pepɨnetsi'ayewei, tawarita 'ahɨxie nepɨka'uyeikani. 'Ena kwiepa nepuyeikani neyuku'awietanetɨ yu'uname hepaɨ, xewitɨ xɨka netsihanukunake pɨnetsihemieni. ");
INSERT INTO hch_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Yawé mɨpaɨ katinita'eiya: —Mɨpaɨ pepɨkaranuyeyani. Kemɨ'ane Kahini mɨmieni, katinikwinitɨariemɨkɨ 'atahutamexɨa. Hikɨ Yawé Kahini kaniu'inɨaritɨani, kemɨ'ane menukunake mɨka'ikumemiwanikɨ. ");
INSERT INTO hch_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","'Ana Kahini Yawé kaniuku'eirieni, Nuri kwieyaritsie kaneyani, 'Ereni makuma tau manatineika hepatsie. ");
INSERT INTO hch_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kahini yu'ɨya hamatɨa xeime nunutsi kanayexeiya 'Enuki katiniterɨwa. Kahini kiekari kanikamaximekaitɨni, 'Enuki katiniterɨwa yuniwe hepaɨ. ");
INSERT INTO hch_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","'Enuki xeimeta yuniwe kanayexeiya 'Irari katiniterɨwa, mɨkɨ pupaapayatɨkai Mekuyaheri. Mɨkɨta pupaapayatɨkai Metutsaheri, Metutsaherita pupaapayatɨkai Rameki. ");
INSERT INTO hch_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Rameki yuhutame puwarutiwitɨ. Xewitɨ pɨtitewakai 'Ara meta Tsira. ");
INSERT INTO hch_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","'Ara Kawari titewakame kanayexeiya, mɨkɨ 'ixuriki kiiyari memukii meta wakaitsixi memɨwaxiɨtɨa watutsi kanayani. ");
INSERT INTO hch_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Kawari yumuta pexeiyakai Kuwari titewakame, mɨkɨ haripakɨ meta pirikɨxakɨ memɨteyuitɨawawe watutsi patɨa. ");
INSERT INTO hch_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Tsira meta Tuwari-Kahini kanayexeiya, tepɨa tsuname kanayani meta purunitsekɨ tiwewiwame meta tepɨakɨ. Tuwari-Kahini xeime yutaru 'ukatɨme kanexeiyakaitɨni Nuhama titewakame. ");
INSERT INTO hch_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Rameki mɨpaɨ katiniwarutahɨawe yu'ɨitama 'Ara meta Tsira: «Xekeneu'enana 'ukari Rameki 'ɨitamama. Xekeneu'eni neniuki. Xeime nepumi tewi netiukwinitɨaku, xeimetatsiere temaikɨ netsihetamieku. ");
INSERT INTO hch_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Xɨka kemɨ'ane Kahini mɨmieni 'atahutamexɨa tikwinitɨariemɨkɨ, matsi kemɨ'ane Rameki mɨmieni haika tewiyari heimana tamamata heimana 'atahutamexɨa katinikwinitɨariemɨkɨ». ");
INSERT INTO hch_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","'Arani hairiekata yɨ'ɨya matɨa xeime nunutsi mekanayexeiya, Tseti katiniterɨwa, mɨpaɨ 'utayɨka: «Kakaɨyari pɨtatsi'upitɨa xeimeta nunutsi temayexeiyakɨ, 'Aweri hetsiemieme, Kahini mimiekaikɨ». ");
INSERT INTO hch_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Tseti xeimeta yuniwe kanayexeiya 'Enuxi katiniterɨwa. Hikɨ mana mekanitsutɨani teɨteri Yawé mehahɨawetɨ kemɨtitewa. ");
INSERT INTO hch_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","'Ikɨ 'Arani nuiwarimama mekanihɨkɨtɨni. Kepauka Kakaɨyari tewi mutawewi, yuhepaɨ 'aneme putawewi. ");
INSERT INTO hch_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","'Uki 'uka puwarutiwewi, meta 'aixɨa kaniwaruyurieni. Kepauka muwarutiwewi «teɨteri». ");
INSERT INTO hch_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Kepauka 'Arani xeitsienituyari heimana xeitewiyari heimana tamamata wiyari mexeiyakai, xeimeta kaniutinuarieni yuhepaɨ 'anekame yuhepaɨ tiyuxexeiyame, Tseti katiniterɨwa. ");
INSERT INTO hch_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Tseti 'utinuiwaku, 'Arani kaniuyurieni 'atahaika tsienituyari wiyari, warayexeiyaka tawarita 'ukitsi meta 'ukari. ");
INSERT INTO hch_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","'Arani kaniumɨni 'atanauka tsienituyari heimana xeitewiyari heimana tamamata wiyari hexeiyatɨ. ");
INSERT INTO hch_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Tseti pexeiyakai xeitsienituyari heimana 'auxɨwime wiyari kepauka 'Enuxi mayexei. ");
INSERT INTO hch_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","'Utinuiwaku 'Enuxi, Tseti kaniuyurieni 'atahaika tsienituyari heimana 'atahuta wiyari, warayexeiyaka tawarita 'ukitsi meta 'ukari. ");
INSERT INTO hch_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Tseti kaniumɨni 'atanauka tsienituyari heimana tamamata heimana huta wiyari hexeiyatɨ. ");
INSERT INTO hch_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","'Enuxi pexeiyakai nauka tewiyari heimana tamamata wiyari kepauka Kainahani mayexei. ");
INSERT INTO hch_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Kainahani 'utinuiwaku, 'Enuxi kaniuyurieni 'atahaika tsienituyari heimana tamamata heimana 'auxɨwime wiyari, warayexeiyaka tawarita 'ukitsi 'ukari. ");
INSERT INTO hch_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","'Enuxi kaniumɨni 'atanauka tsienituyari heimana 'auxɨwime wiyari hexeiyatɨ. ");
INSERT INTO hch_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kainahani pexeiyakai haika tewiyari heimana tamamata wiyari kepauka Marareri mayexei. ");
INSERT INTO hch_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Marareri 'utinuiwaku, Kainahani kaniuyurieni 'atahaika tsienituyari heimana huta tewiyari wiyari, tawarita warayexeiyaka 'ukitsi 'ukari. ");
INSERT INTO hch_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Kainahani kaniumɨni 'atanauka tsienituyari heimana tamamata wiyari hexeiyatɨ. ");
INSERT INTO hch_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Marareri pexeiyakai haika tewiyari heimana 'auxɨwime wiyari kepauka Kareri mayexei. ");
INSERT INTO hch_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Kareri 'utinuiwaku, Marareri kaniuyurieni 'atahaika tsienituyari heimana xeitewiyari heimana tamamata wiyari, tawarita warayexeiyaka 'ukitsi 'ukari. ");
INSERT INTO hch_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Marareri kaniumɨni 'atahaika tsienituyari heimana nauka tewiyari heimana tamamata heimana 'auxɨwime (895) wiyari hexeiyatɨ. ");
INSERT INTO hch_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Kareri pexeiyakai xeitsienituyari heimana haika tewiyari heimana huta wiyari kepauka 'Enuki mayexei. ");
INSERT INTO hch_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","'Utinuiwaku 'Enuki, Kareri kaniutihuni 'atahaika tsienituyari wiyari, tawarita warayexeiyaka 'ukitsi 'ukari. ");
INSERT INTO hch_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Kareri kaniumɨni 'atanauka tsienituyari heimana haika tewiyari heimana huta (962) wiyari hexeiyatɨ. ");
INSERT INTO hch_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","'Enuki pexeiyakai haika tewiyari heimana 'auxɨwime wiyari kepauka Matutsareni mayexei. ");
INSERT INTO hch_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","'Utinuiwaku Matutsareni, 'Enuki Kakaɨyari hamatɨa 'aixɨa pɨtiuyeikakai haika tsienituyari wiyari, tawarita hipame pɨwarayexei 'ukitsi 'ukari. ");
INSERT INTO hch_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","'Enuki kaniuyurieni haika tsienituyari heimana haika tewiyari heimana 'auxɨwime wiyari, ");
INSERT INTO hch_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","'aixɨa mɨtiyurienekaikɨ Kakaɨyari hamatɨa, kaniutatɨmaiyarieni Kakaɨyari meiwitɨkɨ. ");
INSERT INTO hch_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Matutsareni pexeiyakai xeitsienituyari heimana nauka tewiyari heimana 'atahuta wiyari kepauka Rameki mayexei. ");
INSERT INTO hch_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","'Utinuiwaku Rameki, Matutsareni kaniuyurieni 'atahuta tsienituyari heimana nauka tewiyari heimana huta wiyari, tawarita warayexeiyaka 'ukitsi 'ukari. ");
INSERT INTO hch_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Matutsareni kaniumɨni, 'atanauka tsienituyari heimana haika tewiyari heimana 'atanauka (969) wiyari hexeiyatɨ. ");
INSERT INTO hch_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Rameki pexeiyakai xeitsienituyari heimana nauka tewiyari heimana huta wiyari kepauka Nuhexi mayexei. ");
INSERT INTO hch_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Rameki Nuhexi pɨtiterɨwaxɨ mɨpaɨ mutayɨkɨ: «'Ikɨ nunutsi pɨtatsika'uxipitɨani ketemɨte'uximaya tete'uka'eniwatɨ meta ketemɨte'uximaya kwiepa Yawé 'axa'iyurieku». ");
INSERT INTO hch_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Nuhexi 'utinuiwaku, Rameki kaniuyurieni 'auxɨwime tsienituyari heimana nauka tewiyari heimana tamamata heimana 'auxɨwime (595) wiyari, tawarita warayexeiyaka 'ukitsi 'ukari. ");
INSERT INTO hch_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Rameki kaniumɨni 'atahuta tsienituyari heimana haika tewiyari heimana tamamata heimana 'atahuta (777) wiyari hexeiyatɨ. ");
INSERT INTO hch_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Nuhexi peixeiyakai 'auxɨwime tsienituyari wiyari kepauka Tsemi, Kami, Kapeti, muwapaapatɨkai. ");
INSERT INTO hch_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Merikɨtsɨ kepauka teɨteri memutamɨirixɨ kwiepa meta 'ukari memɨwarayexei, ");
INSERT INTO hch_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Kakaɨyari niwemama mekaniwaruxeiya teɨteri waniwema witsimemɨte'ɨimarixitɨkai, hikɨ mekaniwarutiwitɨni kemɨ'ane memɨwarutihiwe'eri. ");
INSERT INTO hch_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Hikɨ Yawé mɨpaɨ kaniutayɨni: «'Ari ne'iyari tewi hetsie pɨkayekani, tewi mɨmɨwe xeikɨa kanihɨkɨtɨni, xeitsienituyari heimana xeitewiyari wiyari xeikɨa puyuruwani». ");
INSERT INTO hch_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Kepauka Kakaɨyari niwemama teɨteri waniwema memɨwarutiwitɨ, tɨɨri kwinimieme me'utɨtɨme mekaniwarayexeiya, kwinimieme mete'ayu'iwatɨ mekanakɨne meripaitɨ. Mana mɨtiyetɨa kwinimieme me'utɨtɨ mekaniutixuawere kwiepa. ");
INSERT INTO hch_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Hikɨ Yawé nieretɨ teɨteri ke'axa kwinimieme memɨteyuriekai, 'axamɨti'ane hetsie xeikɨa memɨyɨkɨhɨawekaikɨ, ");
INSERT INTO hch_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","kaniuta'iyarixieni titayari kwiepa tewi mɨtiutawewiekai, hikɨ 'iyarieyatsie neikwine. ");
INSERT INTO hch_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","'Ayumieme Yawé mɨpaɨ kaniutayɨni: «Tewi kwiepa nemitawewi nekanekumaweriyamɨkɨ, yaxeikɨata nekatiniyurimɨkɨ yeutari wahetsie, kuterixi meta memɨte'awɨwawe. ¿Titayari netiwarutawewi?» ");
INSERT INTO hch_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Matsi Yawé Nuhexi kanixeiyakaitɨni, kaninakekaitɨni ke'aixɨa mɨtiuyeikakai. ");
INSERT INTO hch_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","'Ikɨ Nuhexi kemuyɨ pɨ'ɨxatsiyari. Nuhexi 'aixɨa katiniuka'iyarikaitɨni, yakatinikamiekaitɨni yuteɨterima wahamatɨa. Kakaɨyari hetsiemieme 'aixɨa katiniuyeikakaitɨni. ");
INSERT INTO hch_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Yuniwema yuhaikame kaniwarayexeiya: Tsemi, Kami meta Kapeti. ");
INSERT INTO hch_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Kakaɨyari kaniuniere kwiepa 'axamɨti'ane kemɨtixuawekai, teɨteri kememɨteyunanaimakai. ");
INSERT INTO hch_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Kakaɨyari 'uniereka kwiepa kwinimiemeri matsi 'axamɨti'ane muxuawekaikɨ teɨteri wahetsie, ");
INSERT INTO hch_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Nuhexi mɨpaɨ katiniutahɨawe: «Teɨteri nekaniwatayuniyamɨkɨ, mɨkɨ meteyuriekaku kwiepa 'axamɨti'ane kwinimieme katinixuaweni. 'Ayumieme teɨteri nekaniwareuyehɨamɨkɨ meta kwie naime. ");
INSERT INTO hch_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Kɨye maye'utsiya kanuwayari keneutawewi 'apakame, 'uyewaɨkawame kenayeitɨa, kwetsɨka mɨyɨwikɨ kenewakuwiri taɨtana meta herie. ");
INSERT INTO hch_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Mɨpaɨ pakame: xeitsienituyari heimana huta tewiyari meturuyari 'ayetewime, xeitewiyari heimana haika meturuyari 'atayeukame, tamamata heimana nauka meturuyari heutitewame. ");
INSERT INTO hch_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Kii yuheima haikakɨa manawewiya hepaɨ mɨpaɨ paɨmeme hexeiyakame keneutawewi, meriumeturuyari heutitewame 'axawatɨkaime 'anakunekame yukanamiki hetɨa meta yu'etsata yu'itupari hexeiyakame. ");
INSERT INTO hch_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Ne haa waɨkawa nekananɨ'amɨkɨ kwiepa, yunaitɨ memɨtekwinikɨ kwiepa memɨte'u'uwa memɨte'ayeneniere. ");
INSERT INTO hch_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Peru 'ekɨ hamatɨa ne tɨratu tepexeiyani, kanuwa 'amɨtimariwetsie xekaneutahaxɨakuni 'ekɨ meta 'aniwema, 'a'ɨya meta 'amu'e'ema. ");
INSERT INTO hch_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Ketiniwareuta'ɨna kanuwa 'amɨtimariwetsie yuhuhutame yunaime kwiepa memɨte'u'uwa memɨte'ayeneniere, 'uki 'uka mame xeikɨa, yunaime memɨtexuawe. ");
INSERT INTO hch_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","'Ahamatɨa mekaneutahaxɨakuni yuhuhutatɨ memɨte'awɨwawe, tewaxi meta yeutari, kuterixi, memɨtawikwenikɨ. ");
INSERT INTO hch_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Meta waɨkawa 'ikwaite ketinekuwawa ketineuta'ɨna, 'ahetsiemieme meta tewaxi wahetsiemieme, xemɨtekwakakɨ». ");
INSERT INTO hch_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Hikɨ Nuhexi mɨpaɨ katiniuyurieni, Kakaɨyari kemɨtita'aitɨa. ");
INSERT INTO hch_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Hikɨ Yawé Nuhexi mɨpaɨ katiniutahɨawe: «'Ekɨ xeikɨa 'aixɨa pekatiniuka'iyarini 'ena pemuyeika, kanuwa 'amɨtimariwetsie keneutahaki 'atɨɨriyama xeyunaitɨ. ");
INSERT INTO hch_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Yunaime tewaxi mawariyari memɨnaki'eriwa, keniwareuta'ɨna me'atahutame 'ukitsi meta 'ukari, yeutari 'aixɨa memɨka'anene mawariyari yuxexuime 'ukitsi meta 'ukari. ");
INSERT INTO hch_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Memɨte'awɨwaweta yunaime me'atahutame, 'ukitsi meta 'ukari, memɨkaheuyewautsenikɨ 'ena kwiepa. ");
INSERT INTO hch_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Karikɨ 'atahutarieka tukari 'aye'ayu, wiyeri nekaniyuitɨamɨkɨ 'ena kwiepa mɨkawiyekɨ huta tewiyari tukari meta tɨkarikɨ, mɨpaɨ nekatiniwarakumaweriyamɨkɨ kwiepa memɨtama nemɨwarutawewi». ");
INSERT INTO hch_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Nuhexi naime yakatiniuyurieni Yawé kemɨtita'aitɨa. ");
INSERT INTO hch_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","'Ataxewime tsienituyari wiyari pexeiyakai Nuhexi, kepauka mɨtiutihauritɨxɨ. ");
INSERT INTO hch_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Hikɨ kaneutahani kanuwa 'amɨtimariwetsie niwemama yunaitɨ, 'ɨyaya meta mu'e'emama, meyutawikweitsitɨanike mɨtitihauritɨkekaikɨ. ");
INSERT INTO hch_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Yunaitɨ tewatsiekate memɨmawarɨwa meta memɨkamawarɨwa yeutari, memɨte'awɨwawe meta kuterixi, ");
INSERT INTO hch_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","mekaneutahaxɨani Nuhexi hamatɨa yuhuhutatɨ meheuyuti'iwatɨkaitɨ 'uki 'uka, Kakaɨyari kemɨra'aitakai. ");
INSERT INTO hch_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","'Atahutarieka tukari 'anukayaku, wiyeri kanitsutɨani kwiepa memɨtihaunitsie mieme. ");
INSERT INTO hch_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Kepauka Nuhexi 'ataxewime tsienituyari wiyari mexeiyakai, hutarieka metseriyaritsie tamamata heimana 'atahuta tukariyaritsie, 'ana haramaratsie haa patinexɨa, muyuawitsie pɨreuyepierixɨa mɨkawiyekɨ. ");
INSERT INTO hch_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Huta tewiyari tukari meta tɨkari kaniwiyekaitɨni kwiepa. ");
INSERT INTO hch_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Mɨkɨ tukaritsie Nuhexi kanuwatsie mekaneutahaxɨani, niwemama Tsemi, Kami meta Kapeti, Nuhexi 'ɨyaya meta mu'e'emama yuhaikatɨ. ");
INSERT INTO hch_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Wahamatɨa mekaneutahaxɨani yunaitɨ yeutari meta tewaxi, kuterixi metatsiere memɨte'awɨwawe. ");
INSERT INTO hch_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Mɨpaɨ mekateneutahaxɨani kanuwa 'amɨtimariwetsie Nuhexi hamatɨa yunaitɨ meheuyuti'iwatɨkaitɨ kwiepa memɨtexuawe, ");
INSERT INTO hch_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","yunaitɨ memɨtexuawe yɨkɨ mete'anenetɨ, mekaneutahaxɨani meheuyutinɨtɨ 'uki 'uka, Kakaɨyari Nuhexi kemɨra'aitɨwakai. Hikɨ Yawé 'ana katineunani kitenie kanuwatsie. ");
INSERT INTO hch_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Hikɨ karima kaniwiyekaitɨni huta tewiyari tukari. Kepauka haa muwayenexɨa kanuwa 'amɨtimariwe kananuyewiere kwie heima. ");
INSERT INTO hch_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Hikɨ matsi haa waɨkawa kanewayenetɨkateitɨni haa kanitimiekaitɨni, kanuwata kananuyewiekaitɨni hetsiena. ");
INSERT INTO hch_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Waɨkawa haa kanitiyani hɨri 'amanutitɨtɨ kwiepa meutitekai naime kaneuyunitɨaxɨani. ");
INSERT INTO hch_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Hɨri heima 'atahuta meturuyari kuxi haa kanitiyani. ");
INSERT INTO hch_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Mɨpaɨ mekateneuyehɨiyani kwiepa memɨte'u'uwakai: memɨte'awɨwawe, yeutari, tewaxi, kuterixi, metatsiere teɨteri. ");
INSERT INTO hch_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Yunaitɨ mekateniukwini kwiepa memɨte'u'uwakai, yunaitɨ memɨte'ayeyuyurikai. ");
INSERT INTO hch_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Kakaɨyari kwiepa katiniwarakuyeitɨani yunaime memɨte'u'uwakai, teɨteri meta tewaxi meta yeutari, kuterixi, meta memɨte'awɨwawe meteyunaime. Yunaitɨ mekatenakuyeituarieni kwiepa memu'uwakai. Nuhexi xeikɨa mekaniuyuhayewa meta kemɨ'ane hamatɨana memɨyetekai kanuwa 'amɨtimariwetsie. ");
INSERT INTO hch_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Xeitsienituyari heimana huta tewiyari heimana tamamata tukari kwie kaneuyunekaitɨni. ");
INSERT INTO hch_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Merikɨtsɨ Kakaɨyari Nuhexi kanaye'erieni meta yeutari, tewaxi hamatɨana memɨyetekai kanuwatsie. 'Eka kaniuyuitɨani, waɨkawa tɨrɨkaɨyetɨ kaniuku'eka, 'ana haa kanitsutɨani 'etsiwa kawaximetɨ. ");
INSERT INTO hch_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Haramara tetɨata haa matineikakai kaneunarixɨani, muyuawitsieta katineunarixɨani, wiyerita katiniuhayewa. ");
INSERT INTO hch_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Haa kanikawaximekaitɨni 'anɨari kwiepa. Xeitsienituyari heimana huta tewiyari heimana tamamata tukari heutineku, haa waɨkawa kanikawaximekaitɨni. ");
INSERT INTO hch_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","'Atahuta metseritsie tamamata heimana 'atahuta tukaritsie kanuwa kananutateni 'Ararati hɨriyaritsie. ");
INSERT INTO hch_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Haa tsietɨ kanikamiekaitɨni, tamamata metseritsie mexɨakame tukaritsie waɨkawa hɨri petihekɨarixɨa. ");
INSERT INTO hch_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Huta tewiyari tukari 'aye'aku, Nuhexi 'itupari 'etsimɨyewa kaneuyepieni kanuwa 'amɨtimariwe kanamikieyatsie mewewiekai, ");
INSERT INTO hch_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","hikɨ kwatsa kaniutatuani, mɨkɨ mana xeikɨa kaniuwietɨyeikakaitɨni, 'ikwewietɨ haa mɨkawanikɨ. ");
INSERT INTO hch_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Tawarita kukuru meutuxa kaniutatuani, timaimɨtɨ xɨka'akuri haa waɨkawa kawatɨyani. ");
INSERT INTO hch_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Kukuru kaninuani kanuwatsie memawekaikɨ hakewatsɨ heka'uxipieni haa 'akuxi kwie manukanakaikɨ. Nuhexi yumama kaneutatsera, 'enutuka mana kanuwatsie kaneitatuani. ");
INSERT INTO hch_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Tawarita 'atahuta tukari 'anukayaku, hutariekata kukuru kaniutatuani. ");
INSERT INTO hch_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Kɨyɨrirɨmekaku kukuru kaninuani, yuyekaraukɨ huriwa yɨrariyari 'atɨtɨ hekwame yurime. 'Anari Nuhexi mɨpaɨ katinetimani kename haa kawatɨyakai kwieri hahekɨakai. ");
INSERT INTO hch_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Tawarita 'atahuta tukari kanikakwewieni, hairiekari kukuru kanenɨ'ani, 'anari kukuru pɨkanua. ");
INSERT INTO hch_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","'Ataxewime tsienituyari heimana xewi wiyari pexeiyakai Nuhexi kepauka haa mukawa. Mexɨakame metseriyaritsie mexɨakame tukaritsie Nuhexi kanuwa 'amɨtimariwe kanamikieya kananutiyepieni meta kwie mɨwakini hepaɨ katinixeiyakaitɨni. ");
INSERT INTO hch_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Hutarieka metseritsie xeitewiyari heimana 'atahuta tukaritsie, kwieri waɨkawa kaniwakikaitɨni. ");
INSERT INTO hch_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","'Anari Kakaɨyari Nuhexi mɨpaɨ katiniutahɨawe: ");
INSERT INTO hch_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","«Kanuwatsie kenanayeye'ari 'atɨɨriyama, 'a'ɨya, 'amu'e'ema yunaitɨ. ");
INSERT INTO hch_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Yaxeikɨata keniwaranaye'ari 'ahamatɨa memɨteye'ɨnekai: memɨte'awɨwawe, tewaxi meta kuterixi. Mekeyumɨiriyani, mekeyuxiɨtɨaka, kwiepa mekehɨneni». ");
INSERT INTO hch_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Hikɨ kanuwatsie mekananayekɨne, Nuhexi meta niwemama, 'ɨyaya meta mu'e'emama. ");
INSERT INTO hch_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Mekatenanayekɨneta yunaitɨ: tewaxi, memɨte'awɨwawe, metatsiere yunaitɨ kuterixi, meta kwiepa memɨtexuawe yuxexuitɨ yɨkɨ memɨte'anene. ");
INSERT INTO hch_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Hikɨ Nuhexi mawari tenutsariyari kaniutawewieni Yawé hetsiemieme, mana katiniwarutitaiya tewaxi memɨmawarɨwa meta memɨte'awɨwawe memɨmawarɨwa. ");
INSERT INTO hch_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Kepauka Yawé 'ɨakariyari witsimu'ɨa mu'ukwixɨ mɨpaɨ katiniuyuhɨawe: «Tsepa teɨteri tɨɨriyari paitɨ 'axamemɨteyurie, tawarita kwie 'axanepɨkayurieni tewi ya'ane wiwiekaku. Metatsiere hatsuakuri nepɨkatiwakwini kwiepa memɨtexɨawe, hikɨ kenemɨtiuyuri. ");
INSERT INTO hch_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","»Mexi'akuxi kwie 'atsikayɨwe, pɨtiuka'etsitɨreni pɨtiuka'itsanatɨreni, Xexerixa payeikani meta pukuxɨxɨreni, witarita payeikani meta taxarita, pukuhekɨkɨareni meta pukuyɨyɨreni». ");
INSERT INTO hch_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Kakaɨyari Nuhexi 'aixɨa kaniuyurieni meta niwemama mɨpaɨ 'utaitɨ: «Xekeneyuxiɨtɨaka, xekeneyumɨiriyani kwiepa xekenehɨneni. ");
INSERT INTO hch_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Yunaitɨ kwiepa memɨtexuawe mepɨtexemakaxeni: memɨte'awɨwawe, yeutari, kuterixi, ketsɨte haramaratsie memɨteye'uwa. Yunaime xepɨtewata'aitɨani. ");
INSERT INTO hch_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Yunaitɨ memɨtekuyuatɨka memɨte'ayeneniere meta mɨtitsitsiɨrawi tupiriyate xe'ikwaite katinayeimɨkɨ. Ne naime 'ikɨ nekatinixeyetuirieka. ");
INSERT INTO hch_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Peru xeikɨa 'ayeniereme xepɨkakwa'ani, wai 'ayexureme nekanixatani xuriyatsie tukari muxuawekɨ. ");
INSERT INTO hch_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Yurikɨtsɨ xuriyakɨ nekatinixetawawiriemɨkɨ. Yunaime yeutari yunaime teɨteri kememuyuyurieka nekaniwaxeiyakamɨkɨ. ");
INSERT INTO hch_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","»Xɨka xewitɨ tewi xuriyaya 'utayeurieni, mɨkɨta xewitɨ tewi kanimiemɨkɨ, tewi mutawewiyakɨ Kakaɨyari hepaɨ 'anetɨ. ");
INSERT INTO hch_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","»Xeme matsi xekeneyumɨiriyani, xekeneyuxiɨtɨaka, kwiepa xekenehɨneni». ");
INSERT INTO hch_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Tawarita Kakaɨyari Nuhexi meta niwemama katiniwarutaxatɨani, mɨpaɨ katiniwarutahɨawe: ");
INSERT INTO hch_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","«Ne tɨratu nepɨwewieni xehetsie, xexiɨyarimata wahetsie, ");
INSERT INTO hch_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","meta yunaime xehamatɨa memɨte'u'uwa wahamatɨa, tatsɨari yunaitɨ kwiepa memɨtexuawe kanuwatsie memɨyetekai: memɨte'awɨwawe, tewaxi meta yeutari. ");
INSERT INTO hch_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","'Ikɨ netɨratu kanihɨkɨtɨni: Tawarita teɨteri mepɨkaheuyehɨiyani wiyerikɨ, tawariri pɨkatitihauritɨ yunaime mɨtiwareuyehɨpakɨ». ");
INSERT INTO hch_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Tawarita Kakaɨyari mɨpaɨ kaniutayɨni: «Tɨratu 'inɨariyari nepɨxexeitsitɨani yuheyemekɨ xehetsiemieme meta yunaime xehamatɨa memɨte'u'uwa memɨte'ayeneniere: ");
INSERT INTO hch_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Haiwitɨritsie nekuwiwi nekaniuyeteni, mɨkɨ kani'inɨaritɨkamɨkɨ kwie hamatɨa tɨratu kenemɨtiuwewi. ");
INSERT INTO hch_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Kepauka kwiepa haiwitɨri nemanunɨ'ani, hetsiena xɨka nekuwiwi 'uyehuni, ");
INSERT INTO hch_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","nepaye'erieni tɨratu kenemɨtiuwewi xehamatɨa meta yunaime kwiepa memɨtexuawe wahamatɨa. Hatsuakuri waɨkawa pɨkakawiye mɨtiwareuyehɨanikɨ memɨtekwiwawe. ");
INSERT INTO hch_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Kepauka nekuwiwi haiwitɨritsie manutahuni, ne ne'ixeiyame nepaye'erieni tɨratu kenemɨtiuwewi yuheyemekɨ xehamatɨa meta yunaime kwiepa memɨtexuawe wahamatɨa». ");
INSERT INTO hch_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Kakaɨyari katinanunɨni Nuhexi mɨpaɨ tikɨhɨawetɨ: «'Ikɨ kanihɨkɨtɨni tɨratu nemuwewi yunaime kwiepatari wahetsiemieme». ");
INSERT INTO hch_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Nuhexi niwemama kanuwatsie memanayekɨ mekanihɨkɨtɨkaitɨni: Tsemi, Kami meta Kapeti. Mɨkɨ Kami xeime payexei yuniwe Kanani titewakame. ");
INSERT INTO hch_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","'Ikɨ meyuhaikatɨ Nuhexi niwemama kiekari mepukama naitsarie kwiepa. ");
INSERT INTO hch_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Hikɨ Nuhexi kwiepa kaniuti'etɨyani, meta kaxie kaniuka'iteɨta. ");
INSERT INTO hch_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Heiwa kaxie winuyari kaniuti'ieni kaniutitaweni, mawetɨ katiniuhuni 'ixuriki kiiyarita paitɨ. ");
INSERT INTO hch_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Kami Kanani paapaya, yupaapa kaniuxeiya maweme, hikɨ mɨkɨ katiniwarekuxatɨani yu'iwama. ");
INSERT INTO hch_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Tsemi Kapeti hamatɨa mata 'ixurikiyari me'utihurieka yunaiparitsie meheitiyexɨaka, yukutama me'uhutɨ mekanenukanani yupaapa mɨmawekaikɨ. Mɨkɨ mepɨka'ixei maweme, xaɨtsiepɨta memeukunenierekaikɨ. ");
INSERT INTO hch_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Hikɨ kepauka Nuhexi mukatawaiparixɨ, pɨretima nu'aya hetsimɨyumate mixeiyakaikɨ. ");
INSERT INTO hch_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Mɨpaɨ kaniutayɨni: «Kanani 'axake'itɨarieka. 'Iwamama memɨyuhuta yemekɨ mepɨte'i'aitɨaka waɨriyarika». ");
INSERT INTO hch_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Mɨpaɨta kaniutayɨni: «'Aixɨa ketikɨhɨawarɨwani Yawé Tsemi Kakaɨyarieya. Kanani ke'ayani waɨriyarika ti'uximayatsiriwame. ");
INSERT INTO hch_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Kakaɨyari Kapeti kwieya 'ake'utayeuriya. Tsemi manukatsie Kapeti ke'ukani, Kanani tiwa'uximayatsiriwame ke'ayani». ");
INSERT INTO hch_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Kepauka memutihau waritana Nuhexi 'apuyeikakai 'akuxi haika tsienituyari heimana huta tewiyari heimana tamamata wiyari. ");
INSERT INTO hch_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","'Atanauka tsienituyari heimana huta tewiyari heimana tamamata (950) wiyari hexeiyatɨ kaniumɨni. ");
INSERT INTO hch_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","'Ikɨ mepɨhɨkɨ Tsemi, Kami meta Kapeti Nuhexi niwemama meta wanuiwarima, tiutihauritɨkuke memɨwarayexei. ");
INSERT INTO hch_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Kapeti tɨɨriyamama mɨpaɨ mepɨtetetewakai: Kumexi, Makuki, Marahi, Kawani, Tuwari, Metseki meta Tiratsi. ");
INSERT INTO hch_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Kumexi tɨɨriyamamata: 'Atsikenatsi, Xipati meta Tukaxima. ");
INSERT INTO hch_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Kawani tɨɨriyamamata: 'Eritsaha, Taritsi, Kitini meta Xuranini. ");
INSERT INTO hch_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Hipatɨ mɨkɨ haramara tetsita memɨtiyaxixɨ, yuxexuitɨ yunuiwarima mehexeiyatɨ mepakɨ yukwie meta yuniuki. ");
INSERT INTO hch_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Kami tɨɨriyamamata mɨpaɨ mepɨtetewakai: Kutsi, Mitsirahini, Puti meta Kanani. ");
INSERT INTO hch_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kutsi tɨɨriyamamata mepɨtetewakai: Tsewa, Kawira, Tsaweta, Xakama meta Tsaweteka. Xakama niwemama Tsawa meta Rerani mepɨhɨkɨ. ");
INSERT INTO hch_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kutsi Nimiruri paapaya pɨhɨkɨtɨkai, mutamariwaxɨ mexɨakame tewi kwinimieme titɨrɨkaɨyetɨ matɨakɨ 'ana, ");
INSERT INTO hch_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","mɨkɨ waɨkawa reutamiewetɨ meta heuyutamiewetɨ kamatɨ kanayani Yawé hɨxie. 'Ayumieme hipatɨ mɨpaɨ meputiyuane: «'Ikɨ tewi Nimiruri hepaɨ pɨreuyutamiewe Yawé hɨxie». ");
INSERT INTO hch_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Kiekarieya 'amɨtimamariwawekai mɨra'aitakaitsie kanihɨkɨtɨkaitɨni Waweri, 'Ereki, 'Akari, meta Karine, Tsinaxi kwieyaritsie. ");
INSERT INTO hch_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Mɨkɨ kwieyaritsie 'uyeikatɨ Nimiruri kaneyani 'Atsuxi paitɨ, manata kanitiwewieni Niniwe kiekariyari, Xekuwuti-'Ixi meta Kahara ");
INSERT INTO hch_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","meta Xetseni, kiekari mɨmariwe Niniwe meta Kahara wahixɨapa mɨyema. ");
INSERT INTO hch_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Mitsirahini, watutsi kanayani rureutsixi, 'anameutsixi, rehawitsixi, natuhitsixi, ");
INSERT INTO hch_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","paturutseutsixi, katsurukitsixi meta katuritsixi mɨkɨ piritsiteutsixi wanuiwarima memakɨ. ");
INSERT INTO hch_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanani nu'aya Tsiruni kanayani matɨarieya, hutarieka mieme Heti, ");
INSERT INTO hch_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","meta nuiwarimama kewutseutsixi mekanihɨkɨtɨkaitɨni metatsiere 'amuxeutsixi, keriketseutsixi, ");
INSERT INTO hch_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","heweutsixi, 'aratseutsixi, tsineutsixi, ");
INSERT INTO hch_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","'axiwareutsixi, tsemareutsixi metatsiere kamatitsixi. Hikɨta 'ikɨ nuiwarite kananeutsixi mekaneuyutaxɨriexɨani, ");
INSERT INTO hch_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","mɨkɨ wakwie kaniye'atɨyani Tsiruni tsutɨarietɨ Keraxi paitɨ 'u'atɨ meta Kahatsa paitɨ, Tsuruma hepatsieta, Kumuxa, 'Arimaha, meta Tsewuhini, metatsiere Ratsa paitɨ. ");
INSERT INTO hch_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","'Ikɨ Kami nuiwarimama mekanakɨne, yuxexuitɨ yuxiɨyarima mewarexeiyatɨ meta yuniuki, yukwie meta yunuiwarite. ");
INSERT INTO hch_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Tsemi, Kapeti matsikaya, 'Ewexi niwemama watutsi kanihɨkɨtɨkaitɨni, mɨkɨta tɨɨri kaniwarayexeiya. ");
INSERT INTO hch_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Tsemi niwemama mekanihɨkɨtɨkaitɨni: 'Erami, 'Atsuxi, 'Axipatsari, Ruri, meta 'Arami. ");
INSERT INTO hch_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","'Arami niwemamata mekanakɨne: 'Utsi, Huri, Ketexi, meta Mahatsi. ");
INSERT INTO hch_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","'Axipatsari Tseraki paapaya kanayani. Meta Tseraki 'Ewexi paapaya patɨa. ");
INSERT INTO hch_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","'Ewexi yuhutame yuniwema pɨwarayexei: matɨarieya Pereki pɨtitewakai, 'ana kwie mutixitekiekɨ, hutarieka miemeta pɨtitewakai Kutani. ");
INSERT INTO hch_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Kutani meta puwapaapatɨkai: 'Arimurari, Tserepi, Katsaxi-Maweti, Yeraki, ");
INSERT INTO hch_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Harurani, 'Utsari, Rikɨra. ");
INSERT INTO hch_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","'Uwari, 'Awimaheri, Tsawa, ");
INSERT INTO hch_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","'Upixi, Kawira meta Kuwawi. Yunaitɨ 'ikɨ Kutani niwemama mepakɨ, ");
INSERT INTO hch_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","mɨkɨ Metsa kwieyaritsie mepɨtitekai meta Tsepaxi paitɨ, tau manatineika hepatsie mɨhɨriyatsie. ");
INSERT INTO hch_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","'Ikɨ mepɨhɨkɨ Tsemi niwemama wanuiwarima meta yuniuki mehexeiyatɨkaitɨ yukwie meta yunuiwarite. ");
INSERT INTO hch_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","'Ikɨ mekanihɨkɨtɨni Nuhexi xiɨyarimama waniwema, kememɨteheukunuiwa, meta wakwie naitɨ. 'Ikɨ waxiɨyarima wahetsie mekanayenexɨani naitɨ kiekari mɨtama kwiepa, kepauka memutihau reutiyetana. ");
INSERT INTO hch_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Merikɨtsɨ mɨkɨ tukaritsie teɨteri xeiniukiyari xeikɨa mekanexeiyakaitɨni naitsarie kwiepa. ");
INSERT INTO hch_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Hikɨ mehekɨneka tau manatineika hepatsie, mekanitaxeiya hakuwerime Tsinaxi kwieyaritsie, mana mekanikuyaxe. ");
INSERT INTO hch_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","4","Hikɨ mɨpaɨ mekateniuxata: «Kiekari tepɨkamani xeime tuxiyu hexeiyakame muyuawitsie heuti'akame, xɨnariya tepɨtiwewieni tepititaiya. Mɨpaɨ teteyurieyu 'aixɨa tepɨtexeiyarieni, meta tepɨkataxɨriyaxɨani naitsarie kwiepa». 'Ana xɨnariya mekaniuyurieni tetexi mɨkaxuawekaikɨ, kwetsɨka mɨyɨwi mekaniuyurieni mana kwieta matineikakaikɨ tsepa haxu muxuawekai. ");
INSERT INTO hch_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Hikɨ Yawé kaniukateni kiekari mɨxeiyakɨ meta tuxiyu teɨteri memiwewietɨwekaikɨ, ");
INSERT INTO hch_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","mɨpaɨ kaniutayɨni: «Yunaitɨ mepɨxeikiekariyari meta xeiniukiyari xeikɨa mepexeiya, 'ayumieme mɨkɨ 'uximayatsika meputsutɨa, kememɨtexata yamepɨteyurieni. ");
INSERT INTO hch_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Matsi 'aixɨa pɨyɨni waniuki nepɨpataxɨani, memɨkayu'eniekakɨri yunaitɨ». ");
INSERT INTO hch_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Mɨpaɨ Yawé waruyurieku mekaneutayeixɨani naitsarie kwiepa, mekateniuhayewata me'iwewietɨwetɨ kiekari. ");
INSERT INTO hch_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","'Ayumieme mɨkɨ kiekari Waweri katiniuterɨwarieni, mana Yawé waniuki kaniupataxɨani teɨteri kwiepa memɨtama yunaime memɨkayu'eniekakɨ, manata yaxeikɨa naitsarie mɨwareutaxɨriexɨakɨ. ");
INSERT INTO hch_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","'Ikɨ Tsemi nuiwarimama wa'ɨxatsi kanihɨkɨtɨni: Kepauka teɨteri memutihau huta wiyari 'anuyemiekaku kepauka Tsemi xeitsienituyari mexeiyakai, 'ana nu'aya 'Axipatsari kaniutinuiwa. ");
INSERT INTO hch_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","'Axipatsari 'utinuiwaku Tsemi kaniutihuni 'akuxi 'auxɨwime tsienituyari wiyari, tawarita warayexeiyaka 'ukitsi 'ukari. ");
INSERT INTO hch_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Kepauka 'Axipatsari xeitewiyari heimana tamamata heimana 'auxɨwime wiyari mexeiyakai, niweya Tseraki kaniutinuiwa. ");
INSERT INTO hch_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Tseraki 'utinuiwaku, 'Axipatsari kaniutihuni 'akuxi nauka tsienituyari heimana haika wiyari, tawarita warayexeiyaka 'ukitsi 'ukari. ");
INSERT INTO hch_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Kepauka Tseraki xeitewiyari heimana tamamata wiyari mexeiyakai, niweya 'Ewexi kaniutinuiwa. ");
INSERT INTO hch_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","'Ewexi 'utinuiwaku Tseraki kaniutihuni 'akuxi nauka tsienituyari heimana haika wiyari, tawarita warayexeiyaka 'ukitsi 'ukari. ");
INSERT INTO hch_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Kepauka 'Ewexi xeitewiyari heimana tamamata heimana nauka wiyari mexeiyakai, niweya Pereki kaniutinuiwa. ");
INSERT INTO hch_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Pereki 'utinuiwaku 'Ewexi kaniutihuni 'akuxi nauka tsienituyari heimana xeitewiyari heimana tamamata wiyari, tawarita warayexeiyaka 'ukitsi 'ukari. ");
INSERT INTO hch_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Kepauka Pereki xeitewiyari heimana tamamata wiyari mexeiyakai, niweya Xehu kaniutinuiwa. ");
INSERT INTO hch_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Xehu 'utinuiwaku Pereki kaniutihuni 'akuxi huta tsienituyari heimana 'atanauka wiyari, tawarita warayexeiyaka 'ukitsi 'ukari. ");
INSERT INTO hch_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Kepauka Xehu xeitewiyari heimana tamamata heimana huta wiyari mexeiyakai, niweya Tseruki kaniutinuiwa. ");
INSERT INTO hch_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Tseruki 'utinuiwaku Xehu kaniutihuni 'akuxi huta tsienituyari heimana 'atahuta wiyari, tawarita warayexeiyaka 'ukitsi 'ukari. ");
INSERT INTO hch_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Kepauka Tseruki xeitewiyari heimana tamamata wiyari mexeiyakai, niweya Nakuxi kaniutinuiwa. ");
INSERT INTO hch_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Nakuxi 'utinuiwaku Tseruki kaniutihuni 'akuxi huta tsienituyari wiyari, tawarita warayexeiyaka 'ukitsi 'ukari. ");
INSERT INTO hch_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Kepauka Nakuxi xeitewiyari heimana 'atanauka wiyari mexeiyakai, niweya Teraki kaniutinuiwa. ");
INSERT INTO hch_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Teraki 'utinuiwaku Nakuxi kaniutihuni 'akuxi xeitsienituyari heimana tamamata heimana 'atanauka wiyari, tawarita warayexeiyaka 'ukitsi 'ukari. ");
INSERT INTO hch_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Kepauka Teraki haika tewiyari heimana tamamata wiyari mexeiyakai, mekaniutinunuiwakaitɨniri niwemama 'Apɨrami, Nakuxi, Karani. ");
INSERT INTO hch_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","'Ikɨ Teraki kemuyɨ 'ɨxatsieya kanihɨkɨtɨni, 'Apɨrami, Nakuxi meta Karani wapaapa. Karani Ruti pupaapayatɨkai, ");
INSERT INTO hch_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Karani kaniumɨni 'Uxi karireutsixi wakwieyaritsie, matinuiwaxɨtsie, paapaya Teraki 'ayeyurikaku 'akuxi. ");
INSERT INTO hch_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","'Apɨrami Tsarahi kaniutiwitɨni, meta Nakuxi Mirika kaniutiwitɨni Karani niweya, mɨkɨ tawarita xeime 'uka kanayexeiya 'Itsika titewakame. ");
INSERT INTO hch_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Perutsɨ Tsarahi pɨkaniwewekai, pɨkayɨwekai tɨɨri mɨwarayexeiya. ");
INSERT INTO hch_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Teraki kanayeyani 'Uxi karireutsixi wakwieyaritsie Kanani 'uta'eriwatɨ. Yuniwe 'Apɨrami 'awitɨtɨ meta yuteukari Ruti, meta yumu'e Tsarahi 'Apɨrami 'ɨyaya. Peru Karani kiekariyaritsie me'u'axɨaka mana mekanikuyaxe, ");
INSERT INTO hch_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","mana Teraki kaniumɨni huta tsienituyari heimana 'auxɨwime wiyari hexeiyatɨ. ");
INSERT INTO hch_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Merikɨtsɨ Yawé 'Apɨrami mɨpaɨ katiniutahɨawe: «Keneuku'eiri 'akwie, 'amarema meta 'apaapa kie, kenemie kemɨ'ane kwie nemɨmatsixeitsitɨanitsie. ");
INSERT INTO hch_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","»'Ekɨ 'ahetsie nuiwari mariweme nepɨnetɨani, 'aixɨa nepɨmatsiyurieni, 'aixɨa petikuxaxatsiwame nepɨmatsi'ayeitɨani, 'ahekɨ hipatɨta 'aixɨa mepɨ'itɨarieni. ");
INSERT INTO hch_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Ne 'aixɨa nepɨwayurieka kemɨ'ane 'aixɨa memɨmatexeiyani, meta 'axanepɨwayurieni kemɨ'ane 'axamemɨmatsiyurieni. 'Ekɨ 'akɨmana 'aixɨa mepɨ'itɨarieka yunaitɨ nuiwarite kwiepa memɨtama». ");
INSERT INTO hch_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Hikɨ 'Apɨrami kanayeyani, Yawé kemɨrehɨawekai, meta Ruti hamatɨana kaneyani. Kepauka mayetɨa 'Apɨrami Karani kiekariyaritsie haika tewiyari heimana tamamata heimana 'auxɨwime wiyari pexeiyakai. ");
INSERT INTO hch_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Kepauka metɨa 'Apɨrami Kanani paitɨ, yu'ɨya pewitɨ Tsarahi, meta yumatsu Ruti, yaxeikɨa yunaime te'i'uximayatsiriwamete Karani mɨwarutinanekai, meta tita memɨtehexeiyakai. Kepauka Kanani memuye'axɨa, ");
INSERT INTO hch_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","'Apɨrami mana 'uyeyaka Tsikeni mɨrakutewatsiepai kaninuani, xiu manuwe mɨrayutimawatɨre Mure mɨrakutewatsie. 'Ana mana kananeutsixi mepɨtitekai mɨkɨ kwieyaritsie. ");
INSERT INTO hch_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Mana Yawé 'Apɨrami mɨpaɨ katiniutahɨawe: «Ne 'ikɨ kwie 'anuiwarima nekaniwayetuiriemɨkɨ». Hikɨ mana 'Apɨrami tenutsari mawari wewiwame kaniutawewieni Yawé hetsiemieme, mana mitahɨawixɨkɨ. ");
INSERT INTO hch_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Mana mɨyetɨa kaneyani muhɨriyatsie Weteri 'aurie, mana nuaka kaniuyutaxamarutɨani, Weteri tau makayuyuipike katini'anekaitɨni 'Ahi kiekariyarita tau manatineika. Manatatsiere tenutsari timawame kaniutawewieni, Yawé mahɨawenikɨ. ");
INSERT INTO hch_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Manata mɨyetɨa 'Apɨrami 'axɨkai 'umietɨ 'uyerɨximetɨ Nekexi kwieyaritsie paitɨ kaniye'ani. ");
INSERT INTO hch_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Hikɨ 'ana haakaxa kanayani waɨkawa 'Apɨrami manukateitsie, 'ayumieme kaneyani 'Ekipitu paitɨ. ");
INSERT INTO hch_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Hikɨ kepauka 'Ekipitu meutahanikekai, mɨpaɨ yu'ɨya Tsarahi katiniutahɨawe: «Ne nepɨtimate 'ekɨ 'uka witsipepɨti'ɨimari. ");
INSERT INTO hch_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Nepɨtimate kepauka memɨmatsihexeiya 'ekipitutari mɨpaɨ mepetiyuani: “Ti'a'ɨya 'ikɨ”, 'anari mekanenemiekuni, 'ekɨta mekamanehayewakuni. ");
INSERT INTO hch_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Peru neuxei mɨpaɨ kenetayɨki ximɨxi kename ne'iwa pehɨkɨ, ne 'atsinemɨkaheku'itɨariwanikɨ 'ekɨ mɨpaɨ pehetayɨyu, nemɨkahekumemieriwanikɨ». ");
INSERT INTO hch_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Kepauka meta'a 'Apɨrami 'Ekipitu kwieyaritsie, 'ekipitutari Tsarahi witsimekateniuxeiya. ");
INSERT INTO hch_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Yaxeikɨata mekanixeiya, te'uximayatamete Parahuni hetsɨa miemete, hikɨ mekanekɨne meteheitaxatɨanike 'uka witsikemɨti'ɨimarikaikɨ. Hikɨ 'ayumieme kanewitɨkieni paratsiyu paitɨ. ");
INSERT INTO hch_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Tsarahi hetsiemieme 'Apɨrami 'aixɨa mekateniuxeiya. Katiniyetuiriyarieni muxatsi, wakaitsixi, puxuri, kameyutsixi meta te'uximayatamete 'ukitsi 'ukari. ");
INSERT INTO hch_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Perutsɨ Tsarahi hetsiemiemekɨ 'Apɨrami 'ɨyaya, Yawé Parahuni kaniu'uximatɨani meta yunaime tɨɨriyamama waɨkawa kwiniyakɨ. ");
INSERT INTO hch_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","'Ayumieme Parahuni pɨtiutanɨ'a, mɨwitɨkiemiekɨ 'Apɨrami, mɨpaɨ katinitahɨawe: «¿Titayari mɨya penetiuyuri? ¿Titayari mɨpaɨ pekanetiutahɨawixɨ kename 'ikɨ 'a'ɨyatɨkai? ");
INSERT INTO hch_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","¿Titayari kename 'a'iwa petiutayɨ? Ketakuta matsi ne'itiwitɨnike. Hikɨri 'a'ɨya kenawitɨtɨ keneumieni». ");
INSERT INTO hch_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Parahuni yuteɨterima kaniwaruta'aitɨani 'Apɨrami memayeweiyakɨ meta 'ɨyaya metatsiere tita mɨrexeiyakai. ");
INSERT INTO hch_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Merikɨtsɨ 'Apɨrami kanayeyani 'Ekipitutsie yu'ɨya hawitɨtɨ meta yumatsu Ruti yunaitɨ, yunaime metewara'arietɨ yutewama, Nekexi mɨrakutewatsie me'erietɨ. ");
INSERT INTO hch_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","'Apɨrami pɨxikutɨkai tewaxi pɨwarexeiyakai, pɨrata pexeiyakai meta huru. ");
INSERT INTO hch_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Kepaukata Nekexi kwieyaritsie mɨyetɨa, 'Apɨrami 'axɨkai kaneyani Weteri kanakunuani tatsɨari meripaitɨ matɨari manukateitsie Weteri meta 'Ahi wahixɨapa. ");
INSERT INTO hch_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Mana meripaitɨ mawari taiyame mutawewiekaitsie, mana 'Apɨrami Yawé kaniutahɨawe. ");
INSERT INTO hch_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Meta Ruti 'Apɨrami maweiyakai pukatewakai, muxatsi, wakaitsixi, meta waɨkawa 'ixuriki kiyari pexeiyakai. ");
INSERT INTO hch_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Peru hakewa memakutekai pɨkawareunanakekai yuhutatɨ mana memɨtitenikɨ, memɨyuwaɨkawakaikɨ watewama. ");
INSERT INTO hch_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","'Ayumieme mekaniuyutikwitɨkɨne 'Apɨrami memɨtehɨiriekai meta Ruti tehɨwemetemama wahamatɨa. Metatsiere mana mekanikiekaitɨni 'ana kananeutsixi meta peretseutsixi. ");
INSERT INTO hch_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Hikɨ 'Apɨrami mɨpaɨ Ruti katiniutahɨawe: «Pɨkaheuyewetse tame temɨtakwitɨweni, meta tateɨterima, hurawa temɨ'iwamarixikɨ. ");
INSERT INTO hch_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Mana pukuma kwie 'apɨyewa. Nepɨmatsiwawirie nexaɨtame pemɨnetsihayewakɨ. Xɨka 'ekɨ peheyani ta'utata neta tatserieta nepɨyemie, xɨka tatserieta peheyani neta ta'utata nepɨyemie». ");
INSERT INTO hch_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Ruti kananieretɨyani naitsarie, Kurutani 'utɨma muweritsie kaneuyeniere, naitɨ 'aixɨa katiniu'anekaitɨni Tsuhaxi paitɨ 'uyenieretɨ, 'aixɨa katiniuhaxiekaitɨni, Yawé harawerita hepaɨ meta 'Ekipitu kwieyaritsie hepaɨ. Mɨpaɨ katiniu'anekaitɨni mana Tsuruma meta Kumuxa kepauka Yawé mɨka'ika'unawekaitsie. ");
INSERT INTO hch_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Hikɨ Ruti kaninakire hetsiena mieme mayanikɨ naitɨ haa Kurutani 'utɨma muyeweritsie, 'ayumieme kaneyani tau manatineika hepatsie. Mɨpaɨ mekateneuyutaxɨriexɨani 'Apɨrami meta Ruti. ");
INSERT INTO hch_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","'Apɨrami Kanani kwieyaritsie kaniuyuhayewa, Ruti kaneyani mayeweritsie kiekari makumanetsie, Tsuruma 'aurie kaniutayerɨni. ");
INSERT INTO hch_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Teɨteri Tsuruma kiekatari 'axamekateniu'iyarikaitɨni, Yawé hepaɨtsita waɨkawa 'axamɨti'ane mekateniyuriekaitɨni. ");
INSERT INTO hch_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","'Arike Ruti 'Apɨrami 'uku'eirieku Yawé mɨpaɨ katinitahɨawe: «'Apɨrami 'aku, mana pemanuwetsie keneutanierixɨa, ta'utata, tatserieta, tayeta meta tatsutɨa. ");
INSERT INTO hch_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Mɨkɨ nepɨmatsiyetuirieni meta 'anuiwarima yuheyemekɨ pemixeiya kwie naime. ");
INSERT INTO hch_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Ne yumɨireme nepɨwarayeitɨani 'anuiwarima tumuanari hepaɨ. Xewitɨ xɨka tumuanari 'inɨataweni, kaniyɨwemɨkɨta 'anuiwarima mɨwati'inɨatakɨ. ");
INSERT INTO hch_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Kenemie kenayekexiya 'ikɨ kwie kemayetewi meta kematayewa, ne nekamaniyetuiriemɨkɨ». ");
INSERT INTO hch_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Hikɨ 'Apɨrami kaniuyupata kaneyani Hewuruni 'aurie paitɨ makuxiuya, Mamɨre 'iteɨrieya maku'u 'aurie. Manata mawari taiyame kaniutawewieni Yawé hetsiemieme. ");
INSERT INTO hch_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Hikɨ 'ana tukaritsie te'aitamete: 'Amɨxaperi Tsinaxi kiekame, 'Ariuki 'Eratsaxi kiekame, Keruxirahumexi 'Erami kiekame, Tirari Kuyetihimi kiekame, ");
INSERT INTO hch_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","mɨkɨ mekaniwarutakwini te'aitamete: Wera Tsuruma kiekame, Wiritsa Kumuxa kiekame, Tsinawi 'Arimaha kiekame, Tsemewexi Tsewuhini kiekame, meta ti'aitame Tsuhaxi kiekame. ");
INSERT INTO hch_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Mɨkɨ meyu'auxɨwitɨ me'uyutinɨka mepɨwarukuxeɨri yukuyaxima mayeweritsie Tsirini mɨrayetewatsie, metatsiere Haramara Mɨmɨki mɨtimatiwatsie. ");
INSERT INTO hch_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Ti'aitame Keruxirahumexi tamamata heimana huta wiyari katiniwa'aitɨakaitɨni, tamamata heimana haika wiyaritsieke mewaraye'unietɨ mekanakɨne. ");
INSERT INTO hch_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Xeiwiyari 'anuyeyaku, Keruxirahumexi meta hipatɨ te'aitamete memitinɨkai mekanayekɨne, mekaniwaruka'una xepahitsixi 'Atsitaruti-Karinahini kwieyaritsie meta mekaniwaruka'una tsutsitsixi Kami kwieyaritsie meta 'emitsixi Tsawe-Kiriyatahini kwieyaritsie, ");
INSERT INTO hch_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","yaxeikɨata hureutsixi Tsehixi hɨriyaritsie kiekatari, 'atsitapaitɨ Parani mekaniye'axɨani makumawe meuhuratsie. ");
INSERT INTO hch_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Me'akunuaxɨaka 'Enimitsipati paitɨ mekaniye'axɨani, tatsɨari Karetsi mɨtiyetewatsie, 'amarekitsixi wakwie naime mepɨwarunawairi, 'amuxeutsixi wakwietsie mekaniye'axɨani Katsetsuni-Tamaxi kwieyari mekaniwarunawairieni. ");
INSERT INTO hch_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Hikɨ Tsuruma te'aitamete, Kumuxa kiekame, 'Arimaha kiekame, Tsewuhini kiekame, meta Wera kiekame, tatsɨari Tsuhaxi manuyɨne, mekanayekɨne mayeweritsie Tsirini mɨtiuyetewatsie muwa mekaniwarutakwini, ");
INSERT INTO hch_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","te'aitamete, Keruxirahumexi 'Erami kiekame, Tirari Kuyehini kiekame, 'Amɨxaperi Tsinaxi kiekame, meta 'Ariuki 'Eratsaxi kiekame. Mekaniyunaukakaitɨni yu'auxɨwime mewaraye'unietɨ. ");
INSERT INTO hch_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Mayeweritsie Tsirini putsu puxuawekai waɨkawa kwetsɨka mɨyɨwi 'uyemanetɨ, kepauka memeuyuta'unaxɨa te'aitamete Tsuruma kiekame meta Kumuxa kiekame, muwa mekaneukaxɨrieni, hipatɨ xeikɨa mekaniuyɨwekaxɨani mekaniuyuta'una hɨritsie paitɨ. ");
INSERT INTO hch_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Mɨkɨ memɨte'ayu'iwaxɨ, Tsuruma meta Kumuxa timieme mekateniunawani naime tewaxi, meta wa'ikwaite, mɨpaɨ mete'uyurieka mekanekɨne. ");
INSERT INTO hch_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Ruti mana mukateikɨ Tsuruma kiekariyaritsie 'Apɨrami matsuya, mɨkɨta mekanehana meta yunaime tewamama. ");
INSERT INTO hch_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Perutsɨ xewitɨ 'uyuta'unaka, 'Apɨrami hepɨrayu tewiyari katinekuxatɨani kemɨtiuyɨ, Mamɨre 'amuxeu tewiyari xiuya makuma mukateikɨ. Mamɨre pɨ'iwayatɨkai 'Etsikuri meta 'Anexi, mɨkɨ 'Apɨrami matɨa mekaniyu'eniekaitɨni. ");
INSERT INTO hch_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Hikɨ kepauka 'Apɨrami 'amɨtiutaxatɨarie kename matsuya hehanie, kaniwaruta'inieni haika tsienituyari heimana tamamata heimana 'atahaika teɨteri me'u'ixiparame kiena memutinunuiwaxɨ xeikɨa, hikɨ mekaniwaranukuweiya Rani kwieyaritsie paitɨ. ");
INSERT INTO hch_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Yɨwikɨta 'Apɨrami yuteɨterima yunaitɨ mekaniwarutakwini mekaniwara'iwa, mekaniwaranukuweiya Huwa mɨtiyetewatsie paitɨ Ramatsiku yeta. ");
INSERT INTO hch_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Mɨpaɨ mekateniwarunawairieni tinaime, metatsiere yumatsu Ruti kaniutawikweitsitɨani meta tinaime piiniteya, hipame 'ukarawetsixi meta hipame teɨteri. ");
INSERT INTO hch_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Kepauka 'Apɨrami makunua ti'aitame Keruxirahumexi ha'iwaka meta hipame te'aitamete memeweiyakai, ti'aitame Tsuruma kiekame neikunake mayeweritsie Tsawe meta Ti'aitame mɨrayetewatsie. ");
INSERT INTO hch_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Meta Merikitsereki, ti'aitame Tsareme kiekariyaritsie meta mawari wewiwame Kakaɨyari 'Amutewi hetsiemieme, paa meta winu kanimini. ");
INSERT INTO hch_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Hikɨ Kakaɨyari kaniutawawirieni 'Apɨrami 'aixɨa muyurienikɨ, mɨpaɨ 'utaitɨ: «Kakaɨyari 'Amutewi, muyuawi mutawewi meta kwie, 'Apɨrami 'aixɨa keyurieka. ");
INSERT INTO hch_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Kakaɨyari 'Amutewi naimekɨmɨyɨwe pamɨpariyutsi nekanipitɨaka, mɨmatsi'uparewi memɨmatsi'aye'unie pemɨwara'iwakɨ». Hikɨ 'Apɨrami pɨtiyetuiri, tamamatatsie timieme xeime naime. ");
INSERT INTO hch_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Ti'aitame Tsuruma kiekame, mɨpaɨ 'Apɨrami katiniutahɨawe: —Neteɨterima keneneyetuiri, piinite ketinapitɨ. ");
INSERT INTO hch_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","'Apɨrami mɨpaɨ katinita'eiya: —Yawé hɨxie mɨpaɨ neputayɨ, Kakaɨyari 'Amutewi, muyuawi mutawewi meta kwie, ");
INSERT INTO hch_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","kename nitixaɨtɨ nekaranupini mɨti'apiini, hiru tɨma, nawi kakaitsie mieme tɨma. Mɨpaɨ hatsuaku pepɨkayɨwe mɨpaɨ pemɨtayɨni: “Ne 'Apɨrami xiku nepeyeitɨa”. ");
INSERT INTO hch_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Ne tixaɨtɨ nepɨkareuyehɨwa nehetsiemieme, hɨrixɨatsɨ neteɨterima memɨte'utikwai. Meta memɨnetsi'aweiya 'Anexi, 'Etsikuri meta Mamɨre, mɨkɨ hɨrixɨa mekete'utipini yuhetsiemieme. ");
INSERT INTO hch_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Hikɨ mɨpaɨri tiɨyɨku, Yawé 'Apɨrami kaniutahɨawe heinɨtsika hepaɨ tiyuxexeiyamekɨ: «'Apɨrami, pepɨkaheumaka. Ne 'ahetsie nunuwame nekanihɨkɨtɨni, kenemɨmatiyetuirieni waɨkawa katinayeimɨkɨ». ");
INSERT INTO hch_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Hikɨ 'Apɨrami mɨpaɨ katinita'eiya: —Yawé nekakaɨyari, ¿titayari 'imikieri penetiyetuirieni, ne nunutsi 'akuxi nepɨkahexeiya, tita nemɨrexeiya neti'uximayatsiriwame 'Eriyetsexi Ramatsiku kiekame tipiinieya katinayeimɨkɨ? ");
INSERT INTO hch_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Xeimetɨma nunutsi pemɨkanetsiyetuiriewekɨ, xewitɨ netsiparewiwame nepiinite katinanupimɨkɨ. ");
INSERT INTO hch_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Yawé mɨpaɨ katinitahɨawe: —Hawaikɨ mɨkɨ tewi 'apiinite mɨranupini pɨka'ayani, 'apiinite mɨranupini yurikɨ 'aniwe pɨyɨaneni. ");
INSERT INTO hch_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Hikɨ Yawé kanenuyewitɨni takwa paitɨ, mana mɨpaɨ katinitahɨawe: —Muyuawitsie keneutinieri, keniwaruti'inɨata xurawetsixi, xɨka peyɨweni pemɨwaruti'inɨata. Mɨpaɨ mekaniyupaɨmekakuni 'anuiwarima. ");
INSERT INTO hch_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","'Apɨrami Yawé yuri pɨtiuta'eriri, 'ayumieme Yawé mɨkɨ heitserie hexeiyame kanayeitɨani. ");
INSERT INTO hch_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Mɨpaɨta katinitahɨawe: —Ne Yawé nekanihɨkɨtɨni, nemɨmatsi'ayewitɨ 'Uxi karireutsixi wakwieyaritsie nemɨmatsiyetuirienikɨ 'ikɨ kwie. ");
INSERT INTO hch_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Perutsɨ 'Apɨrami mɨpaɨ katinita'iwawiya: —Yawé neti'aitɨwame, ¿kehepaɨ neretimani kename penetsiyetuirieni? ");
INSERT INTO hch_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Yawé mɨpaɨ katinita'eiya: —Kenene'atɨiri xeime wakaxi, xeimeta kapura, xeimeta tuuru muxa yunaitɨ haika wiyari mehɨtɨkaime, yaxeikɨata xeime haɨmɨ 'amɨnena xeimeta kukuru yakɨmɨnena. ");
INSERT INTO hch_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","'Apɨrami 'ikɨ naime katini'atɨirieni, hixɨata kaniwaxitexɨani, huhutatame 'anuyutaxeiyatɨkaime katiniuyatsa, peru pɨkawarutixite memawɨwawe. ");
INSERT INTO hch_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Hikɨ wirɨkɨxi mekani'axekaitɨni wahetsie memɨkwikwi'ikaikɨ, matsi 'Apɨrami kaniwatatuaxakaitɨni. ");
INSERT INTO hch_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Kepauka kɨyɨrirumekakɨ, 'Apɨrami kaniukumɨni, yapauka yɨriya kananukateni hetsiena, hikɨ kanimakaitɨni. ");
INSERT INTO hch_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Yawé mɨpaɨ 'Apɨrami katiniutahɨawe: —Mɨpaɨ ketinemaika 'anuiwarima xeime kwieyaritsie mepɨtiteni yapaɨmexɨa, mana mepɨteta'aitɨarieni, menanaimarietɨ, nauka tsienituyari wiyari. ");
INSERT INTO hch_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Peru neta yaxeikɨa nepɨwa'uximatɨani mɨkɨ teɨteri memɨtewata'uximayatsitɨani, 'ana mepayekɨne 'anuiwarima metixɨnarieme, waɨkawa mɨraye'atɨka mete'upitɨ. ");
INSERT INTO hch_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","'Ekɨta pekanikumawerimɨkɨ peka'uximatɨarietɨ, waɨkawa pe'ukiratsitɨtɨke pekanimɨmɨkɨ. ");
INSERT INTO hch_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Nauka nuiwariyari me'anuyeyayu, waxiɨyarima 'ena mekani'axɨakuni, hikɨ 'ena memɨtama 'amuxeutsixi 'axamekateniu'iyarini 'ana nekaniwarakumaweriyamɨkɨ. ");
INSERT INTO hch_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Kepauka tau makayunixɨ, kepauka mukuyɨrixɨ, kaniuhekɨare huxunu hepaɨ 'anetɨ kɨtsi watiwietɨ, meta tai mana puyewiekai, mɨkɨ tewaxi memɨxitekietɨka wahixɨata mekaniuyekɨkakaitɨni. ");
INSERT INTO hch_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Mɨkɨ tukaritsie Yawé 'Apɨrami hetsɨa tɨratu kaniuwewieni. Mɨpaɨ katinitahɨawe: —'Ikɨ kwie nepɨwayetuirieni 'anuiwarima, haa 'Ekipitu mieme manuyeka, meta 'amɨpa manuyekatsie paitɨ 'Eupɨrate mɨtitewatsie. ");
INSERT INTO hch_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Keni teɨteriyari wakwie nekanixatani, meta kenitsixi, karimuneutsixi, ");
INSERT INTO hch_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","hetitsixi, peretseutsixi, xepahitsixi, ");
INSERT INTO hch_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","'amuxeutsixi, kananeutsixi, keriketseutsixi meta kewutseutsixi wakwie. ");
INSERT INTO hch_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Merikɨtsɨ Tsarahi 'Apɨrami hamatɨa nunutsi mepɨkahexeiyakai. Tsarahi xeime pexeiyakai 'uka ti'uximayatame 'ekipitutanaka Hakari titewakame, ");
INSERT INTO hch_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","hikɨ Tsarahi mɨpaɨ katinitahɨawe yukɨna: —Yawé pɨkanetsipitɨawe nunutsi nemayexeiyakɨ. 'Ayumieme, keneukahu'i neti'uximayatsiriwame Hakari hamatɨa. Heiwatɨ mɨkɨ 'utiniweni neniwema memakɨnekɨ. 'Apɨrami yakatiniutanaki'erieni 'ɨyaya kemɨrehɨawekai. ");
INSERT INTO hch_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Hikɨ Tsarahi tiyu'uximayatsiriwame 'ekipitutanaka Hakari 'uwiyaka, 'Apɨrami kaniyetuirieni mɨ'ɨyayatɨnikɨ. Mɨpaɨ katiniuyɨni kepauka 'Apɨrami tamamata wiyari muyuriekai Kanani kwieyaritsie. ");
INSERT INTO hch_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","'Apɨrami Hakari hamatɨa kaniukahuni, mɨkɨ kaniutihukata. Kepauka Hakari mɨretima kename 'ayehukakai, kaniyuti'ɨretɨyani yukutsiyari Tsarahi hɨxie. ");
INSERT INTO hch_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Hikɨ Tsarahi 'Apɨrami mɨpaɨ katiniutahɨawe: —'Ekɨtsɨ ya'anekame pekaniwiwieka kenemɨtinanaimarie. Ne nepɨmatsiyetuiri ti'uximayatame 'a'ɨya mayanikɨ, hikɨri mayehuka mariweme kanayuyeitɨwani. Yawé yake'utayɨni kemɨ'ane heitserie mexeiya, xɨka 'ekɨ yatɨni ne. ");
INSERT INTO hch_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","'Apɨrami mɨpaɨ katinita'eiya: —'Ekɨ heitserie pepexeiya ti'uximayatame pemɨti'aitɨakakɨ, ketine'aitɨaka kemɨmatinake kehepaɨ 'aixɨa mɨ'ane. Hikɨ Tsarahi waɨkawa kaniti'uximatɨatɨyani, 'ana Hakari kaniuyuta'una makumawetsie paitɨ. ");
INSERT INTO hch_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Mana niuki tuayame Yawé hetsɨa mieme kanitaxeiya, haixa matinieretsie huye Tsuhuxi mieme manuyehanetsie ");
INSERT INTO hch_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","mɨpaɨ katinita'iwawiya: —Hakari, Tsarahi ti'uximayatsiriwame, ¿hakewa pepeyetɨa, hakewa pepeutɨa? Hakari mɨpaɨ kaniutayɨni: —Nepeyuta'unaxɨ nekutsiyari Tsarahi hetsɨa. ");
INSERT INTO hch_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Niuki tuayame mɨpaɨ katinitahɨawe: —Kenakunua hetsɨana, yaketinekamieni kemɨmare'aitɨa. ");
INSERT INTO hch_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Yaxeikɨata 'anuiwarima nepɨwatimɨiriya, xewitɨ pɨkayɨweni mɨwaruti'inɨata. ");
INSERT INTO hch_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","»Hikɨri pemayehuka xeime nunutsi 'uki pekanayexeiyamɨkɨ, 'Itsimaheri pekatiniterɨwamɨkɨ, Yawé mi'enikɨ 'ahiwerika. ");
INSERT INTO hch_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Tewi mɨkatiyu'aitɨarinɨa kanayeimɨkɨ, puxu tsimaruni hepaɨ. Yunaime kaniwatakwimɨkɨ, yunaitɨta mekanitamiekuni, yu'uximatɨatɨ puyeikani yu'iwama yunaime wahamatɨa». ");
INSERT INTO hch_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Yawé Hakari mɨtiutaxatɨakɨ mɨpaɨ pɨtiterɨwaxɨ «Kakaɨyari pemɨniere». Mɨpaɨ mutainekaikɨ: «Hikɨ nepixei kemɨ'ane mɨnetsixeiya». ");
INSERT INTO hch_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","'Ayumiemeta mɨpaɨ pɨtitewa putsu Karetsi Wereri wahixɨapa mɨtiniere «Kakaɨyari mayeyuri putsuya mɨnetsixeiya». ");
INSERT INTO hch_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Hakari xeime nunutsi kaniutiniweni 'Apɨrami niweyatɨme, 'Apɨrami mɨkɨ 'Itsimaheri katiniuterɨwa. ");
INSERT INTO hch_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","'Apɨrami nauka tewiyari heimana 'ataxewi wiyari kanexeiyakaitɨni kepauka 'Itsimaheri mutinuiwaxɨtsie. ");
INSERT INTO hch_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Kepauka 'Apɨrami nauka tewiyari heimana tamamata heimana 'atanauka wiyari mexeiyakai, Yawé mɨpaɨ katinitahɨawe: «Ne Kakaɨyari Naimekɨmɨtɨrɨkaɨye nekanihɨkɨtɨni, nehɨxie keneuyeikani 'aixɨa ketineyurienetɨ. ");
INSERT INTO hch_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Mɨpaɨ nepeye'atɨani 'ahetsɨa tɨratu meta yumɨireme nepɨwarayeitɨani 'anuiwarima». ");
INSERT INTO hch_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Hikɨ mɨpaɨ tiu'enaka 'Apɨrami, kwiepa kaniukahɨximakeni, Kakaɨyari 'akuxi kaniyeweiyakaitɨni tikuxatatɨ: ");
INSERT INTO hch_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","«'Ikɨ tɨratu 'ahamatɨa nekaniwewieka: 'Ekɨ yumɨireme nuiwarite wapaapa pekanayeimɨkɨ. ");
INSERT INTO hch_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Hikɨri 'Apɨrami pepɨkatitewaka, matsi pɨtari 'Apɨrahami pepɨtitewaka, mɨpaɨ nemɨmarahɨawekɨ kename yumɨireme nuiwarite wapaapa nematsi'ayeitɨani. ");
INSERT INTO hch_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Kwinimieme petixiɨweme nepɨmatsi'ayeitɨani 'ahetsie mepɨyekɨne te'aitamete meta nuiwarite. ");
INSERT INTO hch_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","'Ahetsiemieme 'ikɨ tɨratu nepɨwewie meta 'anuiwarite wahetsiemieme, 'ikɨ tɨratu yuheyemekɨ mieme payani, yunaime 'anuiwarima wahetsiemieme. Ne 'akakaɨyari nepɨhɨkɨtɨni, meta 'anuiwarima wakakaɨyari. ");
INSERT INTO hch_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","'Ekɨ meta 'anuiwarima nepɨxeyetuirieni naime Kanani kwieyari, yuheyemekɨ mɨxekwietɨnikɨ, hakewa hikɨ xeme'uwa teewatari wahepaɨ xe'anetɨ. Neta xekakaɨyari nepɨhɨkɨtɨni». ");
INSERT INTO hch_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Kakaɨyari 'Apɨrahami mɨpaɨ katiniutahɨawe: «Netɨratu xekenaye'atɨa, 'ekɨ meta yaxeikɨa 'anuiwarima yuheyemekɨ. ");
INSERT INTO hch_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","'Ikɨ kanihɨkɨtɨni tɨratu 'ahamatɨa nemiwewie meta 'anuiwarima wahamatɨa, meta yunaitɨ xemeye'atɨanikɨ: Yunaitɨ 'ukitsi xitekiya 'inɨariyari meke'uwewiyarieni. ");
INSERT INTO hch_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Yuwaiyaritsie xitekiya 'inɨariyari xepɨwewieni, mɨkɨ pɨ'inɨaritɨni tɨratu kenemɨtiwewie ne xehamatɨa. ");
INSERT INTO hch_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Hikɨ 'ena mɨtiyehane memɨtinunuiwa yunaitɨ xitekiya 'inɨariyari mekekuwewiyarɨwani 'atahaika tukaritsie, meta yunaitɨ tɨɨri 'akie memɨtinunuiwa, meta nanaiyakate teɨteri tsepa xenuiwarima wahetsiemieme mekahɨkɨ. ");
INSERT INTO hch_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Yunaitɨ xewitɨ pɨkayukuhayeikawani, 'akie memɨtinunuiwa meta kemɨ'ane pemɨwatinawe, xitekiya 'inɨariyari meke'uwewiyarieni. Mɨpaɨ pɨtiyuhayewa netɨratu xewaiyaritsie kayeiwetɨ, tɨratu yuheyemekɨ mɨhɨkɨkɨ. ");
INSERT INTO hch_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Merikɨte kemɨ'ane mɨka'inɨaritɨarieni, yuwaiyaritsie mɨka'uxitekieni, mɨkɨ pukumaweriyarieni xehetsɨa. Yamɨkatikatɨakɨ netɨratu kemaine». ");
INSERT INTO hch_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Mɨpaɨtatsiere Kakaɨyari 'Apɨrahami katiniutahɨawe: «Tsarahi 'a'ɨya, Tsarahi pepɨkatiuterɨwaniri, Tsara pɨta pɨtitewaka. ");
INSERT INTO hch_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Ne 'aixɨa nepiyurieni, nunutsi xeime nepɨxeyetuirieni. Waɨkawa 'aixɨa nepiyurieni, mɨkɨ yumɨireme nuiwarite wamaama payani, hetsiena mepɨyekɨne te'aitamete kiekaritsie memɨteta'aitaxɨani». ");
INSERT INTO hch_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Hikɨ 'Apɨrahami kaniutihɨximakeni kwiepa kaniutananeni mɨpaɨ tiku'eriwatɨ: «¿Kamɨtsɨ tiyɨwe 'uki nunutsi mayexeiya xeitsienituyari wiyari hexeiyatɨ, meta tiyɨwe mɨtiniweni Tsara nauka tewiyari heimana tamamata wiyari hexeiyatɨ?» ");
INSERT INTO hch_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","'Ayumieme 'Apɨrahami Kakaɨyari mɨpaɨ katiniutahɨawe: —'Itsimaheri 'aixɨa pe'iyuriekaku ke'uyeikani. ");
INSERT INTO hch_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Kakaɨyari mɨpaɨ katinita'eiya: —Tsara nepɨxata 'a'ɨya xeime nunutsi payexeiya 'aniwetɨme, 'Itsahaki pekatiniterɨwamɨkɨ. Mɨkɨ hamatɨa netɨratu payeyurini meta nuiwarimama wahetsɨa, tɨratu yuheyemekɨ mieme mɨhɨkɨkɨ. ");
INSERT INTO hch_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","'Itsimaheri hetsiemiemeta nepɨmatsi'enie. Ne 'aixɨa nepiyurieni, waɨkawa mɨiriweme nepayeitɨani, yuwaɨkawa nuiwarimama nepɨwarayeitɨani. Tamamata heimana huta te'aitamete wapaapa kanayeimɨkɨ. Hetsiena nuiwari mariweme nekaninetɨamɨkɨ. ");
INSERT INTO hch_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Matsi netɨratu 'aniwe 'Itsahaki hetsie kanayeyurikamɨkɨ, Tsara peyexeiya yurika 'epauka xeiwiyari 'anuyeyayu. ");
INSERT INTO hch_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Kepauka Kakaɨyari mɨtiutahayewaxɨ 'Apɨrahami hamatɨa tikuxatatɨ kaniukumawere hɨxiena. ");
INSERT INTO hch_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Mɨkɨ tukaritsie kwitɨwa 'Apɨrahami yuniwe 'Itsimaheri xitekiya 'inɨariyari kaniwewirieni, meta kiena memutinunuiwakai metatsiere muwarutinanekai, meta hipame 'ukitsi kiena memɨtitekai yunaime, Kakaɨyari kemɨre'aitɨwakai. ");
INSERT INTO hch_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Nauka tewiyari heimana tamamata heimana 'atanauka wiyari pexeiyakai, 'Apɨrahami kepauka xitekiya 'inɨariyari muwewiyarie, ");
INSERT INTO hch_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","nu'aya 'Itsimaheri tamamata heimana haika wiyari kanihɨkaitɨni. ");
INSERT INTO hch_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Meta 'Apɨrahami yuniwematɨ yunaitɨ xitekiya 'inɨariyari mekaniuwewiyarieni mɨkɨ tukaritsie ");
INSERT INTO hch_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","yunaitɨ meyunɨtɨ 'ukitsi wahetsɨa kiekatari, meta memutinunuiwaxɨ wahetsɨa, meta nanaiyakate teewatari waniwema. ");
INSERT INTO hch_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Merikɨtsɨ Yawé kaniuyuhekɨata 'Apɨrahami hetsɨa Mamɨre makuxiuyatsie, 'Apɨrahami 'ixuriki kiiyari hɨxie 'uxipiekaku tuka 'uxɨkakaku. ");
INSERT INTO hch_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Hikɨ 'Apɨrahami kepauka manukunierixɨ, yuhaikame 'ukitsi kaniwaruxeiya yateewa meti'ukame. Waruxeiyaka kaniutanautsa yuxamaru hɨxie tikeka watahɨaweke. Wahɨxie 'utihɨximakeka, ");
INSERT INTO hch_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","mɨpaɨ kaniutayɨni: —Neti'aitɨwame, xɨka yapera'eriwani, yemekɨ nepɨmatsiwawirie ne'aurie xeikɨa pemɨka'uyeyeikanikɨ. ");
INSERT INTO hch_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Haa nepɨta'aita kɨmana yu'ɨkate xemɨtihauxinikɨ, 'anake xepɨka'uxipieni 'ikɨ kɨye 'etɨpiwari hetɨa. ");
INSERT INTO hch_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Tixe'uximayatsiriwame manukatsie xemɨye'axɨakɨ, 'ikwai nekanita'aitamɨkɨ 'aixɨa xeteheu'erietɨ xemɨyehukɨ kexemɨtehu. Mɨkɨ mɨpaɨ mekaniutiyuani: —Kamɨtsɨ 'aixɨa pɨ'ane, mɨpaɨ ketineuyuri. ");
INSERT INTO hch_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","'Apɨrahami kaneyani yapauka Tsara 'ixuriki kiiyarita, hikɨ mɨpaɨ Tsara katiniutahɨawe: —Mexɨiwa 'aixɨa. Harina 'aixɨa mɨ'ane xeitewiyari kiruyari keneuhawiya, paa keneutiwewi. ");
INSERT INTO hch_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Meta 'Apɨrahami kaneyani 'unautsarɨmetɨ hakewa tewaxi memeyenakai, muwa xeime tsikeru kaniwayehana waiyakame waiyarieya mɨkatse'i, ti'uximayatame kaniyetuirieni, mɨkɨta mexɨima kanitawarɨka. ");
INSERT INTO hch_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Hikɨ katiniwarumini kunerekɨ retsikɨ meta tsikeru warɨkariyarikɨ. Kepauka memɨtekwakai 'Apɨrahami kɨyetɨa kaniuwekaitɨni wa'aurie. ");
INSERT INTO hch_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","—¿Hakewari 'a'ɨya, Tsara? 'Apɨrahami mɨpaɨ katiniwaruta'eiya: —Huma payeka 'ixuriki kiiyarita. ");
INSERT INTO hch_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Hikɨ xewitɨ mɨpaɨ katinitahɨawe: —Xeiwiyari 'anuyeyayu tawarita nepɨmatsiha'iwatamie, 'ana 'a'ɨya Tsara nunutsi kanexeiyakamɨkɨ. Tsara kanita'enakaitɨni yu'ixuriki kiiyari hɨxie, mɨyamɨtikuxatakai waritana yateewa pɨti'enakai. ");
INSERT INTO hch_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","'Apɨrahami Tsara hamatɨa mepɨ'ukirawetsixitɨkai, Tsara mɨtihukata pɨkayɨwekairi. ");
INSERT INTO hch_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","'Ayumieme, Tsara kaniutananeni mɨpaɨ tiku'eriwatɨ: «Pɨkayɨwe nemuyutemawieka mɨyamɨraniuwakɨ, neri 'ari nepɨkayɨwe, nekɨnatari pɨ'ukiratsi». ");
INSERT INTO hch_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Hikɨ Yawé mɨpaɨ 'Apɨrahami katiniutahɨawe: —¿Titayari Tsara tiutanawe? ¿Kamɨtsɨ yurikati'erie mɨtiniwenikɨ mɨyayumaitɨ? ");
INSERT INTO hch_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","¿Kamɨtsɨ Yawé hepaɨtsita tixaɨtɨ tixuawe katiyɨwetɨ? Yurika nekanayenemɨkɨ 'epauka, 'ana Tsara nunutsi kanexeiyakamɨkɨ. ");
INSERT INTO hch_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Tsara kaniutimani, katini'itaiya mɨpaɨ katinitahɨawe: —Nematsi nepɨka'utanawekai. Peru Yawé tawarita mɨpaɨ katinitahɨawe: —Huu, peputananai. ");
INSERT INTO hch_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Hikɨ mekananuku'uni 'iwatamete mekanekɨne Tsuruma hepatsie. 'Apɨrahami wahamatɨa kaneyani waretateutɨanike. ");
INSERT INTO hch_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Yawé mɨpaɨ katiniku'eriwakaitɨni: «¿Nekapɨtitaxatɨani 'aumɨ 'Apɨrahami kenemɨtiyurieni? ");
INSERT INTO hch_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","'Apɨrahami nuiwarieya mariwetɨ payani meta tɨrɨkaɨyetɨ, mɨkɨ kɨmana yunaitɨ nuiwarite kwiepa memɨtama 'aixɨa mepɨ'itɨarieni. ");
INSERT INTO hch_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Ne nepenayexei yuniwema muwata'ɨxatsitɨanikɨ meta watɨɨriyama, Yawé huyeya'utɨa memuhunikɨ, yamemɨteyuriekakɨri tita 'aixɨa mɨti'ane tita mɨtiheitserie. Hikɨ mɨpaɨ me'anekaku Yawé pɨraye'atɨani 'Apɨrahami kemɨtiutahɨawixɨ». ");
INSERT INTO hch_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Hikɨ 'ayumieme Yawé 'Apɨrahami mɨpaɨ katiniutahɨawe: —Nepɨka'inewieri hiwerika Tsuruma Kumuxa wahepaɨtsita mieme, waɨkawa 'axamepɨteyurie. ");
INSERT INTO hch_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","'Ayumieme nepɨnierimie, xɨka 'aku yuritɨni 'axamete'u'iyarini kememutiyuane memutitsuana, yatɨ pɨtikatixaɨ nekatinetimaimɨkɨ. ");
INSERT INTO hch_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Yuhutatɨ 'iwatamete xeikɨa mekanekɨne Tsuruma, 'Apɨrahami 'akuxi kaniuyuhayewa Yawé hamatɨa. ");
INSERT INTO hch_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Hikɨ 'Apɨrahami Yawé hɨxie hurawa kaniuyani mɨpaɨ katinitahɨawe: —¿Kamɨtsɨ yurikɨ petika'una heitseriemekɨ yamɨtikamie 'axamɨtiyuriene hamatɨa? ");
INSERT INTO hch_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Mɨkɨ kiekaritsie xɨka me'u'uwani huta tewiyari heimana tamamata heitseriemekɨ yamemɨtekahu. ¿Yunaime petiwaka'una, pekareiyehɨwirieni kiekari pewanaki'erietɨ heitserie memexeiya? ");
INSERT INTO hch_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Mɨpaɨ pemɨtiyurieneni matsi 'aixɨa pɨka'ane. Heitseriemekɨ yamɨtikamie xɨka 'umieni 'axamɨtiyuriene hamatɨa meta yaxeikɨa memɨte'anuyehuni yunaitɨ. Mɨpaɨ matsi hatsuaku pepɨkatiyurieneni. 'Ekɨ 'itsɨkame pekanihɨkɨtɨni 'ikɨ kwie naime hetsiemieme. ¿Tamɨ kemɨtiheitserie pekatiyurieni? ");
INSERT INTO hch_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Yawé mɨpaɨ katinita'eiya: —Xɨka huta tewiyari heimana tamamata heitserie yamemɨtekahu Tsuruma kiekariyaritsie newarukaxeiya, wahetsiemieme kiekari naime nekatineuyehɨwiriemɨkɨ. ");
INSERT INTO hch_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","'Apɨrahami mɨpaɨ katinitahɨawe: —Ne nepɨnemate kenetineuyehɨwirieka kwinimieme nematiku'iwawiyakɨ neti'aitɨwame, ne tumuanari naxi nepɨhɨkɨ. ");
INSERT INTO hch_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Peru xɨka meheuyewekake yu'auxɨwitɨ mema'atɨkɨnekɨ huta tewiyari heimana tamamata. ¿Petika'una naime kiekari yu'auxɨwitɨ memeuyewetsekɨ? Yawé mɨpaɨ katinita'eiya: —Xɨka huta tewiyari heimana yu'auxɨwime newaretaxeiya heitserie memexeiya nepɨka'ika'una. ");
INSERT INTO hch_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","'Apɨrahami tawarita mɨpaɨ kaniutayɨni: —Keri xɨka huta tewiyari xeikɨa pewaretaxeiya. Yawé mɨpaɨ katinita'eiya: —Heitserie memexeiya mɨkɨ huta tewiyari meyupaɨmemekɨ nepɨka'ika'una kiekari. ");
INSERT INTO hch_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","'Apɨrahami tawarita mɨpaɨ kaniutayɨni: —Pepɨkaha'aka neti'aitɨwame, matsi kenenepitɨaka nemɨtikuxatanikɨ. Keri xɨka xeitewiyari heimana tamamata xeikɨa pewaretaxeiya. Yawé mɨpaɨ katinita'eiya: —Nepihayewa xeitewiyari heimana tamamata wahetsiemiemekɨ. ");
INSERT INTO hch_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","'Apɨrahami tawarita mɨpaɨ kaniutayɨni: —Kenetineuyehɨwirieka mɨya nematikuxaxatɨwakɨ neti'aitɨwame, peru xɨka pewaretaxeiya xeikɨa xeitewiyari heitserie memexeiya. Yawé mɨpaɨ katinita'eiya: —Mɨkɨ xeitewiyarikɨ nepɨka'ika'una. ");
INSERT INTO hch_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Mɨkɨ tawarita mɨpaɨ katinitahɨawe: —Pepɨka'uyeha'arɨweni neti'aitɨwame, keneneupitɨa tawarita nemɨtaniunikɨ. Xɨkata tamamata pewaretaxeiya xeikɨa. Yawé 'imatɨrieka mɨpaɨ katinitahɨawe: —Mɨkɨ tamamata wahekɨ nepɨka'ika'una. ");
INSERT INTO hch_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Kepauka mɨtiutahayewaxɨ Yawé tikuxatatɨ kaneyani, 'Apɨrahami meta kanakunuani yukie 'ixuriki kiiyarita. ");
INSERT INTO hch_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Merikɨtsɨ kanikuyɨrirɨmekaitɨniri kepauka niuki tuayamete Tsuruma memɨye'axɨa. Ruti kiekari kitenie kanakateitɨni mɨranutakɨkatɨretsie. Kepauka mɨkɨ mɨwaruxei, kananukukeni watahɨaweke, wahɨxie kwiepa kaniukahɨximakeni. ");
INSERT INTO hch_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Mɨpaɨ katiniwarutahɨawe: —Neuxei 'iwatamete, nepɨxewawirie waɨkawa 'ikɨ tɨkaritsie nekiita xemuyuhayewanikɨ. Muwa yɨ'ɨkate xemetihauxini peyɨwe, 'uxa'akeri ximeri xekaniyehuni kexemɨtehu. Peru mɨkɨ mɨpaɨ mekaniutiyuani: —'Aixɨa pɨ'ane mɨyapemɨtarahɨawe, matsi tame kiekari hixɨapa teɨteri memayutixexeɨriwatsie tepetiheni. ");
INSERT INTO hch_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Peru Ruti katihayewakaku yukie wa'inietɨ mepekɨ 'utɨmana, kiitana mekaniu'axɨani. Ruti wa'ikwai muwa putiwarukawewiri 'aixɨa ti'anekame, paa mɨkakuxanariyarietɨka kaniutikwaxiya, mɨkɨ mekateniukwani. ");
INSERT INTO hch_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Hikɨ mekakakutsiwawekaku 'akuxi, kii 'aurie mekanaketɨkɨne teɨteri mana Tsuruma kiekariyaritsie kiekatari. Yunaitɨ teɨteri kiekatari mekaniyɨakaitɨni xewitɨ tɨma kayuhayewatɨ, temari 'ukirawetsixi yunaitɨ mekateniyɨakaitɨni. ");
INSERT INTO hch_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Ruti mekanewaye'inieni, mɨpaɨ mekatenitahɨawe: —¿Hakewari 'ukitsi memu'axɨa 'akie metihenike? Keniwarayenɨ'a. Tame wahamatɨa tepɨkahini. ");
INSERT INTO hch_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Hikɨ Ruti yukiita hewayeyaka, reunaka kitenie, ");
INSERT INTO hch_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","mɨpaɨ katiniwarutahɨawe: —Neuxei nehamikuma, mɨpaɨ xepɨkayɨaka. ");
INSERT INTO hch_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Ne yuhutame nepɨwarexeiya neniwema 'ukari 'ɨimarixi 'akuxi, nekaniwarayenɨ'amɨkɨ tsepa kexemɨwayuriku mɨkɨ, peru 'ikɨ 'ukitsi 'axaxepɨkawayurieka, mɨkɨ mekaniu'axɨani nekiita memayehenikɨ. ");
INSERT INTO hch_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Peru mɨkɨ mɨpaɨ mekatenita'eiya: —Mana keneukuye'a. 'Ikɨ 'ena pɨkakiekame, hikɨta tati'aitɨamɨkɨ. Hikɨtsɨari matsi 'ekɨ kwinimieme 'axatekamaniyuriekakuni 'ena mɨtiyehane pemɨkawatauniekɨ. Hikɨ Ruti mekaneukutaima hurawa kitenie mekaniuti'uni 'itupari meheu'unake. ");
INSERT INTO hch_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Peru memuyuhuta 'ukitsi yumamate mekaniutitsera, Ruti mekaneutahana kiitana meta mekateneunani kitenie. ");
INSERT INTO hch_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Hikɨ mɨkɨ, 'itupari memeu'unakai temari 'ukirawetsixi mekaheunenieretɨ mekanayeitɨarieni, kitenie hakewa mehɨkɨtɨkai mepɨka'itaxeiri. ");
INSERT INTO hch_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Hikɨ Ruti mɨpaɨ mekateneye'eritɨani: —¿Tawarita 'atɨɨriyama pekatiwarexeiya 'ena? Keniwaranuwitɨki xaɨtsie yunaime 'amunema, 'aniwema 'ukitsi meta 'ukari, yunaime kemɨ'ane memɨ'a'iwama, 'ikɨ kiekaritsie mepɨkayuhayewani, ");
INSERT INTO hch_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","hikɨ tame tekanika'unakuni. 'Axamɨti'ane hiwerika Yawé hetsɨa paitɨ kaniye'ani, 'ari 'iyarieyatsie katineuyeyani. 'Ayumieme tame pɨtatsiheyenɨ'a temika'unakɨ. ");
INSERT INTO hch_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Hikɨ Ruti kanayeyani wata'inienike yuniwema wakɨnama memakɨnekekai, kemɨ'ane memɨwatiwitɨnikekai. Mɨpaɨ katiniwarutahɨawe: —Mexɨima. Kiekaritsie xekenayekɨni, Yawé kanika'unarɨmeni. Matsi mɨkɨ yakɨ 'utaineme mepɨ'eriekai. ");
INSERT INTO hch_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","'Ari kuhekɨarirɨmekaku tawarita Ruti yaxeikɨa mekatenikɨhɨawekaitɨni niuki tuayamete. Karima mɨpaɨ mekaniutiyuani: —Keneyumexɨitɨatɨ. Keniwaranuwitɨki 'a'ɨya meta 'aniwema memuyuhuta, xemɨkakukukuwenikɨ kepauka kiekari mɨka'unarieni. ");
INSERT INTO hch_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Ruti kayumexɨitɨakaku, niuki tuayamete mamayatsie mekanikawɨre, 'ɨyaya meta niwemama memuyuhutakai, kiekaritsie mekaniwaranuyewitɨni, Yawé mɨwarutinenimayataxɨkɨ. ");
INSERT INTO hch_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Mewarayewitɨkari kiekaritsie, xewitɨ niuki tuayame mɨpaɨ kaniutayɨni: —Xekeneuyuta'una. Yu'utɨma xepɨka'anakuneniereni mayeweritsie xepɨkahewa'uweni. Hɨritsie paitɨ xekeneuyuta'una, nɨkahɨrixɨa xe'ukwini. ");
INSERT INTO hch_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Ruti mɨpaɨ kaniutayɨni: —Neuxeitsɨ hawaikɨ, waɨkawamekɨ nepɨmatsiwawirie, neti'aitɨwame. ");
INSERT INTO hch_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","'Ekɨtsɨ 'aixɨa pekanetiniuxeiya, ke'aixɨa nehetsiemieme pemɨtiuyuri pɨmariwe netukari pemutawikweitsitɨakɨ. Ne matsi nepɨkayɨwe nemɨneta'una hɨritsie paitɨ, nɨka netsi'anuku'axe kepauka mɨka'unarieni kiekari, tietɨtsɨ nemɨnemɨ. ");
INSERT INTO hch_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","'Ena kiekari yateewa pukuma 'etsiyeutɨ, mana nepɨneta'una. ¿Xekaneneupitɨa mana pɨta nemɨneta'unakɨ? Mɨkɨ kiekari 'etsikaniyeuka, mɨkɨtsie nekaniyuti'awietamɨkɨ. ");
INSERT INTO hch_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Hikɨ xewitɨ mɨkɨ mɨpaɨ katinitahɨawe: —Kepemɨnerawawiriwa yanepɨra'eriwa. Nepɨka'ika'una kiekari pemexaxata. ");
INSERT INTO hch_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Keneumienitsɨari xeiya, kene'ata'una mana paitɨ, peheta'ayuke yanepɨtiyurieni. 'Ayumieme mɨkɨ kiekari Tsuhaxi titewatɨ patɨa. ");
INSERT INTO hch_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Ruti Tsuhaxi peta'a tau haneximekaku. ");
INSERT INTO hch_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Hikɨ Yawé tai wiyeriyari kaneyenɨ'ani meta 'atsupɨre taiyari kaniukawiwieni muyuawitsie mieme Tsuruma meta Kumuxa wahetsie. ");
INSERT INTO hch_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Mɨpaɨ katiniwaruka'una mɨkɨ kiekarite meta yunaime mana kiekatari, naime mayeweritsie meta tita mana mɨtixuawekai. ");
INSERT INTO hch_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Peru Ruti 'ɨyaya yu'utɨma kananakuniere 'una teteyari kanayani. ");
INSERT INTO hch_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Hikɨ 'uxa'arieka ximeri paitɨ 'Apɨrahami kananukukeni, kaneyani hakewa Yawé hamatɨa mɨrekuxatakai. ");
INSERT INTO hch_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Kaneutaniere Tsuruma meta Kumuxa wahepatsie meta naitsarie mayeweritsie, hikɨ mana kɨtsi kaniuxeiya mana hatineikame, huxunuta wa'atɨ pɨratineika. ");
INSERT INTO hch_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Mɨpaɨ Kakaɨyari pɨtika'unaxɨ mɨkɨ kiekarite makuweritsie mukumanekai, peru 'Apɨrahami kemɨrehɨawekai paye'eri, Ruti mana putawikweitsitɨa kiekari ka'unarieximekaku mana mukateikɨ. ");
INSERT INTO hch_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Hikɨ Ruti marikakɨ Tsuhaxi kayuhayewamɨtɨ, kaneyani hɨritsie paitɨ yuniwema memuyuhuta warawitɨtɨ. Mana paitɨ terɨta kanayekateitɨni wahamatɨa. ");
INSERT INTO hch_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Merikɨtsɨ mɨixari muwa me'ayetetɨ, Ruti niweya 'amɨyumate yutaru mɨpaɨ katiniutahɨawe: —Tapaapa pɨ'ukiratsiri, meta naitsarie 'ena mɨtiuyehanetsie mepumawe 'ukitsi memɨtatsitiwitɨnikɨ, naitsarie teɨteri kememɨteyutiwitɨkɨ. ");
INSERT INTO hch_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Hikɨmɨ, tepititawaitɨani, 'anari hamatɨana tekanikahikuni, mɨpaɨ teyɨme tanuiwarima tepɨwarayexeiya. ");
INSERT INTO hch_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Hikɨ mɨkɨ tɨkaritsie yupaapa mekaniuti'itɨani, hikɨ kahayu'eriwakaku, 'ana niweya 'amɨyumate kaniukahuni hamatɨana. ");
INSERT INTO hch_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","'Uxa'arieka, 'amɨyumate mɨpaɨ yutaru katiniutahɨawe: —Neuxei, ne hikɨ tɨkaritsie nepaapa hamatɨa nepukahui. Yaxeikɨata hikɨ taikai tepiti'itɨani, 'ekɨta hamatɨana pepɨkahuni, mɨpaɨ teyɨme tanuiwarima tepɨwarayexeiya. ");
INSERT INTO hch_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Mɨkɨ tɨkaritsieta yupaapa mekaniuti'itɨani, mɨkɨ kahayu'eriwakaku, niweya yakɨmɨyumate hamatɨana kaniukahuni. ");
INSERT INTO hch_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Mɨpaɨ me'uyɨka yuhutatɨ Ruti niwemama mekaniutihukataxɨani yupapatsie miemekɨ. ");
INSERT INTO hch_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","'Amɨyumate xeime 'ukitɨme kaniutiniweni, Muhawi katiniterɨwa, muhawitsixi wapaapa matɨa. ");
INSERT INTO hch_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Taruyata yaxeikɨa, 'ukitɨme kaniutiniweni, Weni-'Ami katiniterɨwa, 'amunitsixi wapaapa matɨa. ");
INSERT INTO hch_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","'Apɨrahami mana mɨyetɨa kaneyani Nekexi mɨrakutewatsie 'erietɨ, Karetsi Tsuhuxi wahixɨapa kaniuyuhayewa Keraxi mɨrakutewatsie. ");
INSERT INTO hch_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","'Apɨrahami, Tsara mɨ'ɨyayatɨkai, kename 'iwayatɨkai kaniutainekaitɨni. 'Ayumieme mana 'Awimereki, Keraxi kwieyaritsie ti'aitame, katiniuta'aita mɨwitɨkiemiekɨ Tsara, neiwitɨni 'ɨyaya mayanikɨ. ");
INSERT INTO hch_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Hikɨ mɨkɨ tɨkaritsie, Kakaɨyari 'Awimereki kaniutahɨawe heinɨtsitana, mɨpaɨ katinitahɨawe: —Neuxei 'ekɨ pekanimɨmɨkɨ 'ukaratsi pemewitɨkɨ, mɨkɨ 'ukaratsi kaniwikieka. ");
INSERT INTO hch_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Hikɨ 'Awimereki 'ukaratsi hamatɨa mɨkakahuiwekaikɨ, mɨpaɨ katinitahɨawe: —Ti'aitame, pepɨkanetsikumemiwani, ne 'axanepɨkatiuyuri, ");
INSERT INTO hch_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","'Apɨrahami mɨpaɨ pɨnerahɨawekai kename 'iwayatɨkai, 'ukaratsi yaxeikɨata pɨnetiutahɨawixɨ, neri yurikɨ neti'erietɨ nepeiwitɨ, peru ne'ɨyaya ne'inawairienike nepɨkatiuyuri. ");
INSERT INTO hch_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Kakaɨyari mɨpaɨ katinita'eiya: —Mɨpaɨ nepɨtimate, yuri petiwa'eririetɨ pepeiwitɨ, 'ayumieme nepɨkamatsi'upitɨa pemikumayɨanikɨ, xurikime pemɨkatiwiwiwanikɨ nehetsɨa. ");
INSERT INTO hch_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Peru mɨkɨ 'ukaratsi keneyetua hikɨ, mɨkɨ kɨnaya niukame kanihɨkɨtɨni nehetsiemieme, kanenitawawiriemɨkɨ 'ahetsiemieme pemuyeikanikɨ 'akuxi, peru xɨka peka'iyetuani 'ekɨ yaxeikɨa 'akie kiekatari wahamatɨa pekanimɨmɨkɨ. ");
INSERT INTO hch_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","'Uxa'arieka ximeri 'Awimereki yuteɨterima warutahɨaweka, katiniwarutaxatɨani kemɨtiuheinɨkai. Mɨkɨ me'i'enieka waɨkawa mekaniutimamani. ");
INSERT INTO hch_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Hikɨ 'Awimereki, 'Apɨrahami katiniutanɨ'airieni mɨpaɨ katinitatieni: —Neuxei, kepetatsi'uyuri. ¿Kepaukakuta 'axanepɨmatsi'uyuri, titayari xurikime petatitiwiwiriwa nehetsie meta nemɨra'aita wahetsie? 'Axamemɨte'u'iyari kememɨkanetsi'uyuri 'ekɨ pɨta waɨkawa 'axapepɨnetsi'uyuri. ");
INSERT INTO hch_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","¿Kepetiku'eriwatɨ mɨyapeputayɨ? 'Awimereki mɨpaɨ titatieku, ");
INSERT INTO hch_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","hikɨ 'Apɨrahami mɨpaɨ katinita'eiya: —Ne mɨpaɨ nepɨtiku'eriwakai, xeme Kakaɨyari xeka'ayemakaxeme nepɨ'eriekai, xenetsimienike nepɨ'eriekai ne'ɨya hetsiemieme. ");
INSERT INTO hch_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Peru kaniyuritɨni mɨkɨ kanine'iwatɨni, nepaapa niweya kanihɨkɨtɨni, peru nemaama pɨkaniweya, 'ayumieme pɨyɨwekai ne'ɨya mayanikɨ. ");
INSERT INTO hch_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Kepauka mɨpaɨ mɨnetiuta'aitɨa Kakaɨyari, kename nepaapa nemaama newaku'eirienikekai, kename 'ateewa neyemiekai, ne ne'ɨya mɨpaɨ nepɨtiutahɨawixɨ: «Neuxei mɨpaɨ nepɨmatiwawirie: Tsepa hakewa temekɨ, kename ne 'amatsika nehɨkɨ peputaineni». ");
INSERT INTO hch_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Hikɨ 'Awimereki Tsara 'Apɨrahami kaniyetuirieni meta katinimini muxatsi, wakaitsixi, te'uximayatamete 'ukitsi meta 'ukarawetsixi. ");
INSERT INTO hch_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Meta 'Awimereki mɨpaɨ katinitahɨawe: —Neuxei, nekwie 'ena kanikumaka, hakewa mɨmatsihenakeni mana keneukani. ");
INSERT INTO hch_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Tsara meta mɨpaɨ katiniutahɨawe: —Neuxei, 'a'iwa nepu'ɨitɨa tamamata heimana xewi kiruyari heimana 'imeriyu pɨrata tepɨayari, mɨkɨ kani'ayumiemetɨni 'axapemɨkaramamatiwanikɨ, mɨpaɨ memɨtehetimanikɨ 'a'iwama kename 'ekɨ 'atsipekatiuyuri, mɨpaɨ xewitɨ 'atsipɨkametitamani. ");
INSERT INTO hch_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Hikɨ 'Apɨrahami Kakaɨyari kaniutawawirieni, kepauka muyutanenewi Kakaɨyari 'aixɨa kaniwaruyurieni 'Awimereki meta 'ɨyaya, metatsiere mɨtiwa'aitɨakai, memɨniwewawenikɨ hutarieka, ");
INSERT INTO hch_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Tsara mɨya mɨranuyetɨakɨ, 'Apɨrahami 'ɨyaya, Yawé 'Awimereki kie kiekatari 'ukarawetsixi mekaniwewaweme kaniwarayeitɨakaitɨni. ");
INSERT INTO hch_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Yawé kemainekai, Tsara 'aixɨa kaniuyurieni, katinaye'atɨani kemɨrehɨawekai. ");
INSERT INTO hch_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Tsara kaniutihukata 'Apɨrahami nu'ayatɨme kanayexeiya 'ukiratsitɨkaku. Kakaɨyari kepauka mainekai 'ana katiniunake. ");
INSERT INTO hch_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","'Apɨrahami yuniwe 'Itsahaki katiniuterɨwa, Tsara hamatɨa memeyexei. ");
INSERT INTO hch_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","'Apɨrahami xitekiya 'inɨariyari 'Itsahaki kaniuwewirieni 'atahaika tukari 'anukayaku, Kakaɨyari kemɨtita'aitɨa. ");
INSERT INTO hch_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Xeitsienituyari wiyari kanexeiyakaitɨni 'Apɨrahami kepauka 'Itsahaki mutinuiwaxɨ. ");
INSERT INTO hch_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Hikɨ Tsara mɨpaɨ kaniutayɨni: «Kakaɨyari nemutanawenikɨ yapɨnetiupitɨa, yaxeikɨata kemɨ'ane memɨtehetimani meputinaweni nehamatɨa. ");
INSERT INTO hch_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Matsi nixewitɨ 'Apɨrahami mɨpaɨ pɨkarehɨawekai kename ne tɨɨri newatitsitsitɨanikekai, matsi hikɨ nunutsi nepayexei nu'ayatɨme 'ukiratsitɨkaku». ");
INSERT INTO hch_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Nunutsi 'Itsahaki kaniutawere, tsitsieya mekaniku'eiritsitɨani. Mɨkɨ tukaritsie 'Apɨrahami 'ixɨarari kaniuwewieni yuniwe hetsiemieme. ");
INSERT INTO hch_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","'Ana Tsara mɨpaɨ katinetimani 'Itsahaki 'ekipitutanaka Hakari nu'aya 'Apɨrahami hamatɨa meyexeiyakai kaninanaimakaitɨni 'i'atsetɨ. ");
INSERT INTO hch_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Hikɨ 'ayumieme Tsara 'Apɨrahami mɨpaɨ katiniutahɨawe: —Kenanunɨ'a ti'a'uximayatsiriwame yuniwemakame, neniwe 'Itsahaki tita pemɨtiyetuirieni 'apiini, mɨkɨ mana heitserie pɨkahexeiyani ti'a'uximayatsiriwame nu'aya. ");
INSERT INTO hch_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Kepauka 'Apɨrahami mɨyamɨtiutahɨawarie, kaniuyukahiwerieni nu'aya mɨhɨkɨtɨkaikɨ Hakari hetsiemieme. ");
INSERT INTO hch_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Peru Kakaɨyari 'Apɨrahami mɨpaɨ katiniutahɨawe: «Pepɨka'a'iyaritɨaka nunutsikɨ meta maamaya ti'uximayatamekɨ. Tsara kemerahɨawe yaketineuyuri, 'anuiwarima 'Itsahaki hetsie pɨta mekaniyekɨnikuni. ");
INSERT INTO hch_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Meta ti'uximayatame nu'aya nuiwari mariweme nepayeitɨani, 'aniwe mɨhɨkɨkɨ». ");
INSERT INTO hch_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","'Uxa'arieka, ximeripaitɨ 'Apɨrahami nanukukeni, paa, nawi haa 'uyemakame Hakari naiparieyatsie nekawirieni. Hikɨta nu'aya kaniyetuirieni, meta kaniwarutateutɨani. Hakari kanayeyani, mekaniuhukaitɨni me'u'erietɨ makumawetsie Weritsewa mɨrakutewatsie. ");
INSERT INTO hch_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Kepauka yuhaa memayexɨ nawita mɨyemakai, Hakari yuniwe 'ɨtsitɨa 'itiyeka, ");
INSERT INTO hch_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","kaneyani yateewa mana 'ukaitɨ kaniutitsɨatɨyani maamaya, temaikɨ kaxeiyamɨtɨ kepauka mɨmɨnikekai. ");
INSERT INTO hch_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Hikɨ Kakaɨyari temaikɨ tsuarieya kaniu'enieni, Hakari kaniutahɨawe muyuawitsie paitɨ niuki tuayame Kakaɨyari hetsiemieme mɨpaɨ katinitahɨawe: «Hakari mɨpaɨ pepɨkayɨaneni. Pepɨkamaka, Kakaɨyari temaikɨ tsuarieya kaniu'enieni. ");
INSERT INTO hch_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Xeiya kenemie hetsɨana keneuwitɨximeni pepɨka'itatuayani, ne mɨkɨ nuiwarieya mariweme nekanayeitɨamɨkɨ». ");
INSERT INTO hch_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Hikɨ Kakaɨyari Hakari haixa kaniuxeitsitɨani. 'Anari yapauka 'utihanɨka nawi kɨxauriyaritsie temaikɨ kaniuharitɨani. ");
INSERT INTO hch_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Hikɨ Kakaɨyari temaikɨ hamatɨa kaniuyeikakaitɨni, mɨkɨ kaniwerekaitɨni makumawetsie kaniukateitɨni, tupi 'ɨrɨkɨ kwinimieme timɨiwetɨ kanayani. ");
INSERT INTO hch_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Parani mɨrakutewatsie kaniukateitɨni makumawetsie, maamaya 'ekipitutanaka kaniwitɨtɨani. ");
INSERT INTO hch_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","'Ana 'Awimereki 'Apɨrahami hetsɨa kaninuani, Pikuuri titewatɨ kaneteɨtakaitɨni kuyaximama wa'ukiyari, mɨpaɨ 'Apɨrahami katiniutahɨawe: —Mɨpaɨ tepɨtemate, Kakaɨyari waɨkawa pɨmatsiparewie naime kepemɨtiyuriene. ");
INSERT INTO hch_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","'Ayumieme, yakenetineutahɨawi Kakaɨyari hɨxie, hikɨ kwitɨwa, kename pekaneti'itaiyani meta neniwema yaxeikɨa nenuiwarima, yakeneutayɨki kename yaxeikɨa penetixeiyani kenemɨmatixeiya, meta yunaime teɨteri 'ikɨ kwieyaritsie kiekatari pemanuyeika 'ateewa kiekame hepaɨ. ");
INSERT INTO hch_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","'Apɨrahami mɨpaɨ kaniutayɨni: —Huu, yanepɨra'eriwa. ");
INSERT INTO hch_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Peru 'Apɨrahami 'Awimereki katiniutaxatɨani putsu hepaɨtsita, mɨkɨ teɨterimama meminawairiekaikɨ. ");
INSERT INTO hch_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","'Awimereki mɨpaɨ kaniutayɨni: —Nematsi mɨpaɨ nepɨkatimaikai, 'ekɨtsɨ mɨpaɨ penerahɨaweka, ne 'atsinepɨkatimate kemɨ'ane mɨyamɨtiuyuri. ");
INSERT INTO hch_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Hikɨ 'Apɨrahami wakaitsixi kaniwarutiwiya muxatsi meta, 'Awimereki kaniumini, mɨkɨ tukaritsie yuhutatɨ tɨratu mekaniuwewieni. ");
INSERT INTO hch_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Peru 'Apɨrahami 'atahutame muxatsi 'ukarawetsixi kaniwarayehapani yukuraruta, ");
INSERT INTO hch_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","'Awimereki 'Apɨrahami mɨpaɨ katiniuta'iwawiya: —¿Titayari petiwarayehapana mɨkɨ 'atahutame muxatsi? ");
INSERT INTO hch_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","'Apɨrahami mɨpaɨ katinita'eiya: —'Ikɨ 'atahuta muxatsi 'ukari keniwarutanaki'eri. Matsi mɨpaɨ mɨtimatsiɨkɨnikɨ kename ne putsu ne'utawewi. ");
INSERT INTO hch_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","'Ayumieme mana Weritsewa pɨtiuterɨwarie, mana tɨratu memuwewikɨ yuhutatɨ. ");
INSERT INTO hch_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Hikɨ tɨratu me'uwewiekari Weritsewa, 'Awimereki Pikuuri matɨa kuyaxi wa'ukiyari piritsiteutsixi yukwieyaritsie mekanakunuaxɨani. ");
INSERT INTO hch_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Hikɨ mana Weritsewa, 'Apɨrahami tamaritsiku titewakame kaniuka'eni, mɨkɨtɨa Yawé Kakaɨyari 'atsimɨkayɨwe kaniutahɨawekaitɨni. ");
INSERT INTO hch_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Mɨixa wiyari 'Apɨrahami kaniutihuni piritsiteutsixi wakwieyaritsie 'ukaitɨ. ");
INSERT INTO hch_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Merikɨtsɨ yapaɨmexɨa tukari 'anukayaku, Kakaɨyari 'Apɨrahami kaniuta'inɨata, mɨpaɨ katinitahɨawe: —'Apɨrahami 'aku. 'Apɨrahami mɨpaɨ katinita'eiya: —'Ena nepuyeika. ");
INSERT INTO hch_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Kakaɨyari mɨpaɨ katinita'aitɨani: —'Aniwe muyuxewi 'a'iyarikɨ peminakierie, kenawitɨtɨ kenemie Muriya kwieyaritsie paitɨ. Hikɨ mana keneutimawa mawari naitɨ mɨtaiyarɨwa hepaɨ, xeime hɨri nemɨmatsixeitsitɨanitsie. ");
INSERT INTO hch_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","'Uxa'arieka ximeri paitɨ kananukukeni 'Apɨrahami yupuxu kaniutixiratɨani mɨranu'ikatakɨ. Meta kɨye kaniutiwiteni mɨretimawarieni hetsiemieme, hikɨ meyuhutame te'uximayatamete meta yuniwe 'Itsahaki warawitɨtɨ kanayeyani hakewa Kakaɨyari mɨrehɨawekai. ");
INSERT INTO hch_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Hairieka tukaritsie me'uhutɨ, 'Apɨrahami hɨri 'ateewa kaniuxeiya hakewa Kakaɨyari mexatakai. ");
INSERT INTO hch_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Hikɨ 'Apɨrahami mɨwarawitɨkɨ te'uximayatamete yuhutame, mɨpaɨ katiniwarutahɨawe: —'Ena xekeneyuhayewa puxu hamatɨa. 'Akuxi temaikɨ meta ne tepuhuni, Kakaɨyari temetahɨawekɨ, kwitɨwata tepakunuaxɨani xehetsɨa. ");
INSERT INTO hch_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","'Apɨrahami kɨyexi 'uti'ɨka 'Itsahaki kaniutitɨtɨani, mɨkɨta tai kaniutikweni meta nawaxa kanakakeni. Hikɨ mekanekɨne yunaitɨ me'uhutɨ. ");
INSERT INTO hch_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","'Itsahaki 'Apɨrahami mɨpaɨ katiniutahɨawe: —Nepaapa. Paapaya mɨpaɨ katinita'eiya: —¿Tita neniwe? 'Itsahaki mɨpaɨ kaniutayɨni: —Neuxei, kɨyexi tema'ɨ, tai temakwe'e, peru ¿hakewa muxa temeitimawa? ");
INSERT INTO hch_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","'Apɨrahami mɨpaɨ katinita'eiya: —Neniwe. Kakaɨyari kaniyɨweni mɨkɨ muxa kaneyetuamɨkɨ. Hikɨ mekaniuhukaitɨni. ");
INSERT INTO hch_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Hikɨ kepauka memuye'axɨa Kakaɨyari hakewa mexatakai, mana 'Apɨrahami mawari taiyame kaniutawewieni meta kɨyexi 'aixɨa katiniunetɨani mana. Hikɨ yuniwe 'Itsahaki 'uwiyaka kanihɨani mawari taiyametsie kaneteni kɨyexi heima. ");
INSERT INTO hch_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Hikɨ 'Apɨrahami yunawaxa kaniwatihana yuniwe mienike mawari mayanikɨ, ");
INSERT INTO hch_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","peru Yawé niuki tuayameya 'anakwitɨ heimana kanetaniuni karima mɨpaɨ tikɨhɨawetɨ: —'Apɨrahami. 'Apɨrahami 'aku. Mɨkɨta mɨpaɨ katinita'eiya: —'Ena nepuyeika. ");
INSERT INTO hch_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Hikɨ niuki tuayame mɨpaɨ katinitahɨawe: —Keneuhayewa temaikɨ, pepɨkatikwinitɨaka. Nepɨretimari 'ekɨ Kakaɨyari pepayemakaxe, pepɨka'uyuta'ima 'aniwe penetsiyetuirienike muyuxewi. ");
INSERT INTO hch_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Hikɨ 'Apɨrahami kananieretɨyani, muxa kaniuxeiya yu'awatekɨ tsekame 'ɨtsitsie. Hikɨ 'Apɨrahami 'ixɨnaka kanitimawa taipa yuniwe hetsiemieme. ");
INSERT INTO hch_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","'Ayumieme 'Apɨrahami mana pɨtiuterɨwaxɨ: «Yawé pɨrayetuirieni tita mɨreuyehɨaka». 'Ayumieme teɨteri mɨpaɨ meputiyuane: «Hɨritsie Yawé pɨrayetuirieni». ");
INSERT INTO hch_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Yawé niuki tuayameya 'Apɨrahami kaniutahɨawe hutarieka taheima paitɨ, ");
INSERT INTO hch_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","mɨpaɨ katinitahɨawe: —'Ekɨ pepɨraye'atɨa kenemutayɨ, 'aniwe muyuxewi pepɨka'utikweri, 'ayumieme ne yurikɨ nekanaineni ―Yawé mɨpaɨ kanaineni—. ");
INSERT INTO hch_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","'Aixɨa nepɨmatsiyurieni waɨkawamekɨ, 'anuiwarima yɨmɨireme nepuwarayeitɨani xurawetsixi muyuawitsie memɨtama wahepaɨ meta xiekari haramara tetsita mɨtika hepaɨ. Meta 'anuiwarima mepɨte'ayu'iwani kemɨ'ane memɨwaraye'unie wakiekarite mepɨwanawairieni. ");
INSERT INTO hch_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Yemekɨ kenematiutahɨawixɨ yapemɨtikatɨakɨ, yunaitɨ nuiwarite kwiepa memɨtama 'aixɨa mepɨ'itɨarieka 'anuiwarima wahekɨ. ");
INSERT INTO hch_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","'Apɨrahami kanakunuani hakewa memeyuhayewakai te'i'uximayatsiriwametemama, hikɨ yunaitɨ mekanekɨne Weritsewa, hakewa 'Apɨrahami mekatei. ");
INSERT INTO hch_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Hikɨ kepauka, 'Apɨrahami katiniutamarieni kename 'iwaya Nakuxi yɨ'ɨya Mirika hamatɨa, tɨɨri mewarayexei. ");
INSERT INTO hch_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Matɨarieya 'Utsi titewatɨ kanayani, 'utɨmanata mekaniutinunuiwa Wutsi, Kemuheri matɨa. 'Ikɨ wa'utɨamieme 'Arami paapaya kanayani. ");
INSERT INTO hch_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Mɨkɨ wa'utɨata mekaniutinunuiwa Ketseri, Katsú, Piriratsi, Hirurapi, 'imatɨrieka Wetuheri, ");
INSERT INTO hch_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","mɨkɨ Xeweka paapaya patɨa. 'Ikɨ mepɨhɨkɨ 'atahaika tɨɨri Mirika Nakuxi hamatɨa memɨwarayexei, 'Apɨrahami 'iwaya. ");
INSERT INTO hch_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Nakuxi meta kaniwarayexeiya tɨɨri Xeuma titewakametsie, hutarieka yɨ'ɨyatsie. Mɨkɨ mepɨtetetewakai, Tewaki, Kakani, Takatsi, meta Mahaka. ");
INSERT INTO hch_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Tsara xeitsienituyari heimana xeitewiyari heimana 'atahuta wiyari kaniutihuni, ");
INSERT INTO hch_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","kaniumɨni Kiriati-'Ariwa mɨrakutewatsie, tatsɨari Hewuruni kiekariyaritsie Kanani kwieyaritsie. 'Apɨrahami puyuheiweriekai waɨkawa hetsiena mieme. ");
INSERT INTO hch_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Hikɨ 'Apɨrahami mana 'auriena 'anukukeka, kaneyani Heti nuiwarimama mɨpaɨ tiwaretahɨaweke: ");
INSERT INTO hch_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","—Neuxei, ne 'ena nepɨkakiekame, peru kwie terɨ xepɨnetsituirieni muwa ne'ɨya nemeutatenikɨ. ");
INSERT INTO hch_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Hikɨ hetitsixi mɨpaɨ 'Apɨrahami mekateniuta'eiya: ");
INSERT INTO hch_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","—Neuxei 'ekɨ ketaneu'eni, 'ekɨ mariweme mexɨakame pepɨhɨkɨ. Keneuka'awieta 'a'ɨya taterɨ 'aixɨa mɨ'aneneta tsepa kemɨ'ane terɨyarita. Xewitɨ yuterɨ pɨkametsitikweririeni 'a'ɨya muwa pemeutatenikɨ. ");
INSERT INTO hch_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Hikɨ 'Apɨrahami kananukukeni nakatutsita hetitsixi wahɨxie, ");
INSERT INTO hch_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","mɨpaɨ katiniwarutahɨawe: —Xɨka yurikɨ xenakeni ne'ɨya 'ena nemɨka'awietakɨ, xekeneneuparewi, 'Epuruni mɨpaɨ xeteneutahɨawi Tsukaxi nu'aya, ");
INSERT INTO hch_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","kenetsi'utuirieni terɨ Makipera mɨrakutewatsie muka, mɨkɨ kwieya maka'atɨkatsie. Mɨpaɨ xeketeneutahɨawi kenetsi'utuirieni yemekɨ kemɨraye'axe, mɨpaɨ ne 'ena mɨkite wateukume nehexeiyatɨ nepayani netɨɨriyama wahetsiemieme. ");
INSERT INTO hch_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Hikɨ 'Epuruni Heti tewiyari mana kaniukateitɨni yuteɨterima wahamatɨa, 'ayumieme 'Apɨrahami katiniutaxatɨani humapaitɨ 'eniɨriɨkɨmekɨ, hipatɨta memi'enienikɨ yaxeikɨata kiekari kitenie memuyekɨkakai: ");
INSERT INTO hch_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","—Hawaikɨ, neti'aitɨwame keneneu'eni, nematsi nepɨmatsimikwa mɨkɨ terɨ meta kwie naime. Ne'iwama mepɨ'enana kename nematsimikwa. Mana keneukateuki 'a'ɨya. ");
INSERT INTO hch_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Peru 'Apɨrahami tawarita nakatutsita yunaime wahɨxie mana kiekatari, ");
INSERT INTO hch_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","hikɨ yunaitɨ me'enanakaku 'Epuruni mɨpaɨ katiniutahɨawe: —Neuxei, keneneu'eni kwerietɨ. Ne tawarita yanepaine nemɨmatipitɨanikɨ kwie kemɨraye'axe. 'Ekɨ yaketineutanaki'eri, mɨpaɨke ne'ɨya mana nepɨka'awieta. ");
INSERT INTO hch_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Hikɨ 'Epuruni mɨpaɨ 'Apɨrahami katiniuta'eiya: ");
INSERT INTO hch_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","—Neti'aitɨwame, keneneu'eni. Kwie nauka tsienituyari pɨrata tuminiyarikɨ pɨraye'axe. Mɨpaɨ paɨmemekɨ 'atsitepɨkatiyuani. Hikɨ 'a'ɨya keneka'awieta. ");
INSERT INTO hch_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","'Apɨrahami 'Epuruni matɨa 'aixɨa mekateniuxata, hikɨ hetitsixi wahɨxie katinayukatuani kemɨtiheitserie: nauka tsienituyari pɨrata tuminiyarikɨ, tumini waɨkawa mɨti'axe hepaɨ katininaneni tetuayamete wahepaɨ. ");
INSERT INTO hch_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Mɨpaɨ 'Apɨrahami kwie katiniunaneni 'Epuruni tipiinieya, Makipera mɨrakutewa Mamɨre 'aurie tserietana. Mɨkɨ terɨ naime kɨyexite mɨreuti'ukai mɨkɨ kwieyaritsie 'Apɨrahami tipiinieya kanayani. ");
INSERT INTO hch_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","'Apɨrahami tipiinieya pɨratɨa yuheyemekɨ hetitsixi teɨteriyari wahɨxie meta kiekari kitenie memutakɨkakai. ");
INSERT INTO hch_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Hikɨ 'Apɨrahami yu'ɨya Tsara kaniukateuku terɨta kaneitateni, Makipera mɨrakutewatsie Mamɨre tserieta, yaxeikɨata Hewurunikɨ pumatiwa, Kanani kwieyaritsie katini'aneni. ");
INSERT INTO hch_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Mɨpaɨ tiuyɨku mɨkɨ kwie meta terɨ hetitsixi wapiini pɨkaratɨari, 'Apɨrahami tipiinieya pɨta kanayani mɨkite wateukume mayanikɨ yuheyemekɨ. ");
INSERT INTO hch_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Merikɨtsɨ 'Apɨrahami kani'ukiratsitɨkaitɨniri waɨkawa wiyari kanexeiyakaitɨni, Yawé Kakaɨyari kaniparewiekaitɨni naimekɨ. ");
INSERT INTO hch_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Hikɨ 'Apɨrahami 'ukiratsi meripaitɨ miparewi kaniuta'inieni, kiena naime mɨti'uximayatsiriekai tita mɨrexeiyakai, mɨpaɨ katinitahɨawe: —Neteuritɨa keneutame'i, ");
INSERT INTO hch_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Yawé hɨxie yurikɨ yakenetineutahɨawi, kemɨ'ane kwie meta muyuawi mutawewi, kename 'uka 'ena kiekame Kanani peka'iwitɨtɨani neniwe ");
INSERT INTO hch_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","'Itsahaki, matsi pekaniyemieni nemarema wahetsɨa, muwa neniwe 'ɨyaya mayani pekananuyewaumɨkɨ. ");
INSERT INTO hch_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Ti'uximayatame mɨpaɨ katinitahɨawe: —¿Perutsɨ xɨka 'uka ne'utɨma mamie kaheyuwaɨriyani 'ikɨ kwieyaritsie paitɨ? ¿Kamɨtsɨ neramie 'aniwe neranuwitɨni wakie paitɨ? ");
INSERT INTO hch_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","'Apɨrahami mɨpaɨ katinitahɨawe: —Hawaikɨ, neniwe pepɨkahewitɨkɨni muwa paitɨ, ");
INSERT INTO hch_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Yawé Kakaɨyari muyuawi mutawewi nekie pɨnetseheyewitɨ ne'iwama wahetsɨa, mɨpaɨ netihɨritɨatɨ: «'Anuiwarima nepɨwayetuirieni 'ikɨ kwie», mɨkɨ yuniuki tuayame kananunɨ'amɨkɨ 'ahamatɨa mɨmatsi'anuwitɨnikɨ, 'ekɨ pemeyɨwekaxɨanikɨ 'uka pemawitɨni neniwe 'Itsahaki hetsiemieme. ");
INSERT INTO hch_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Xɨka 'uka 'a'utɨa mamie kaheyuwaɨriyani, 'ekɨ pepɨxɨne kenemerahɨawe, peru neniwe pepɨkahewitɨkɨni muwa paitɨ. ");
INSERT INTO hch_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Hikɨ ti'uximayatame 'Apɨrahami teurieyatɨa kaneutameni, mɨpaɨ katinitahɨawe kename yurikɨ yatikayani kemɨtihɨritɨa. ");
INSERT INTO hch_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Hikɨ kameyutsixi kaniwarukuha'aritɨani tamamata meyupaɨmeme 'Apɨrahami tewamama, meta waɨkawa 'imikierite katiniukuha'aritɨani, kaneyani Nakuxi manukateitsie Metsuputamiya kwieyaritsie. ");
INSERT INTO hch_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Mana nuaka kiekari warita haputsu 'aurie yukameyutsixi kaniwarukatuani. Hikɨ kaniukutaikaire, kepauka 'ɨimarixi mematihanɨwetsie kanaye'ani. ");
INSERT INTO hch_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Hikɨ ti'uximayatame mɨpaɨ katiniuyutanenewieni: «Yawé, 'Apɨrahami neti'aitɨwame Kakaɨyarieya, waɨkawa nepɨmatsiwawirie hikɨ 'aixɨa nemɨtiyurienikɨ, 'Apɨrahami nekutsiyari kepemɨtinaki'erie yaketineuyuri. ");
INSERT INTO hch_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Ne 'ena nepuwe haa matineika newatakwewietɨ, 'ena kiekatari waniwema memayekɨnirɨme metihanɨnike. ");
INSERT INTO hch_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Keneupitɨa 'iya 'uka kemɨ'ane mɨpaɨ nemɨtitahɨawe: “Neuxei 'aye'ɨ kenanakahani 'etsiwa nemanuharenikɨ”, mɨkɨta mɨpaɨ kenetiuta'eiya: “Kenanutihareka, 'akameyutsixita nekaniwatiharitɨamɨkɨ”, mɨkɨ 'uka kehɨkɨtɨni pemenayexei 'Itsahaki hetsiemieme mati'uximayatsiriwame. 'Ana mɨpaɨ nepɨretimani kename yapetiuyuri pe'inaki'erie 'Apɨrahami neti'aitɨwame». ");
INSERT INTO hch_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Hikɨ yunenewietɨ karanunɨwekaku Xeweka kaniuxeiya, 'akanamiekaitɨni yuye'ɨ 'anakayetɨ. Xeweka Wetueri kaniniweyatɨkaitɨni, Wetuheri kaniwaniwetɨkaitɨni Mirika Nakuxi hamatɨa, Nakuxi 'Apɨrahami 'iwaya. ");
INSERT INTO hch_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Mɨkɨ 'uka witsipɨti'ɨimarikai, pɨkawikiekai, 'uki pɨkamaikai 'akuxi. Mɨkɨ haa matineika nuaka kaniutihanɨni. 'Ari pɨyemieximekai ");
INSERT INTO hch_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","hikɨ ti'uximayatame kaniutanautsa hepana, mɨpaɨ katinitahɨawe: —¿'Etsiwa 'ekɨ pekanetiuharitɨawe haa 'aye'ɨta miemekɨ? ");
INSERT INTO hch_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","'Uka mɨpaɨ katinita'eiya: —Kenanuhareka. Yuye'ɨ 'anakahanaka kanenutiharitɨani. ");
INSERT INTO hch_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Kepauka ti'uximayatame 'anuharekuri, Xeweka mɨpaɨ katinitahɨawe: —Nekaniwatihanɨimɨkɨta 'akameyutsixi wahetsiemieme memɨtiharenikɨ kememɨteuhariku. ");
INSERT INTO hch_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Hikɨ tewaxi mematiharewetsie 'ikatuaka, waɨkawamexɨa kanakunuani hanɨnetɨ memɨte'atiharewetsie 'ikatu'atɨ, yunaitɨ memɨtiharenikɨ kameyutsixi. ");
INSERT INTO hch_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","'Apɨrahami ti'uximayatsiriwame kanixeiyakaitɨni, mɨpaɨ tiku'eriwatɨ xɨka'aku Yawé tiyurienekaitɨni, 'aixɨa 'anemekɨ makunuanikɨ. ");
INSERT INTO hch_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Kepauka kameyutsixi memɨte'utahayewaxɨ meharetɨ, ti'uximayatame huru nakɨtsayari hewati'ɨka tsurieyatsie kaniyewirieni 'ataxewime kɨramuyari raheteme, meta huru matsɨwayari kaneimaniriexɨani hutame, xeitsienituyari kɨramuyari raheteme, ti'uximayatame mɨpaɨ katinita'iwawiya: ");
INSERT INTO hch_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","—Neuxei, ¿kemɨ'ane 'ekɨ pepɨraniwe, 'apaapa kie meyekani 'aumɨ reyɨwe? ");
INSERT INTO hch_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Mɨkɨ mɨpaɨ katinita'eiya: —Ne Wetuheri nepɨniweya, Mirika meta Nakuxi waniwe, ");
INSERT INTO hch_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","mana xemetiheni peyɨwe meta mɨaxa waɨkawa pexɨawe kameyutsixi wahetsiemieme. ");
INSERT INTO hch_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Hikɨ ti'uximayatame kaniutitunumakeni Yawé pamɨpariyutsi kaniupitɨani ");
INSERT INTO hch_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","mɨpaɨ 'utaitɨ: «'Aixɨa pepɨtiuka'iyari Yawé 'Apɨrahami neti'aitɨwame Kakaɨyarieya, pe'inaki'erietɨ pepɨkatihayewa meta 'aixɨa pepɨnetiuye'atɨa 'iwamama wahetsɨa». ");
INSERT INTO hch_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Xeweka kaneyani 'unautsarɨmetɨ yumaama hetsɨa, mana katinitaxatɨani kemɨreiyuriekai. ");
INSERT INTO hch_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Xeweka xeime yumatsika kanexeiyakaitɨni Rawani titewakame, mɨkɨ 'unautsarɨmetɨ kanayeyani ti'uximayatame heuwaumieka, haa matineika 'akuxi mɨkɨ kaniukateitɨni. ");
INSERT INTO hch_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Rawani yu'iwa nakɨtsa kaniuxeirieni meta matsɨwa metatsiere kani'enieni tikuxatakaku ti'uximayatame kemɨrehɨawekai. 'Ayumieme kanayeyani ti'uximayatame heuwaumieka, haputsu matiniere kanitaxeiya, yukameyutsixi wahamatɨa. ");
INSERT INTO hch_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Mɨpaɨ katinitahɨawe: —Kɨmɨ, 'ekɨ 'aixɨa pepɨ'itɨarie Yawé yametipitɨakaku. ¿Titayari 'ena peti'akuhayeikawani kiekari warita? Neri 'aixɨa nepɨrekuyuri kiita xemeyehenikɨ, meta 'akameyutsixi wahetsiemieme. ");
INSERT INTO hch_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Hikɨ ti'uximayatame kiepa kaniye'ani. Yapauka Rawani kameyutsixi kaniwaruti'ikapieni mɨaxa kaniwarutimini, meta haa kaniwaruhanitɨani ti'uximayatame meta mɨwarawitɨkɨkai yu'ɨkatetsie memauyuhauxixɨanikɨ. ");
INSERT INTO hch_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Kepauka memɨtekwanikekai 'Apɨrahami ti'uximayatameya mɨpaɨ kaniutayɨni: —Ne, nepɨkatikwani yanetayɨmeke titakɨ nemɨtikuyɨane. Hikɨ Rawani mɨpaɨ katinitahɨawe: —Yakeneutayɨkikuta. ");
INSERT INTO hch_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Ti'uximayatame mɨpaɨ katinitsutɨani: —Ne 'Apɨrahami ti'uximayatsiriwame nekanihɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Yawé waɨkawa 'aixɨa kaniyurieka kaniparewieka. Katinikupinirieka muxatsi, wakaitsixi, huru, pɨrata, te'uximayatamete 'ukitsi 'ukari, kameyutsixi, meta puxuri. ");
INSERT INTO hch_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Meta neti'aitɨwame 'ukiratsitɨtɨri yu'ɨya Tsara hamatɨa xeime nunutsi mekanayexeiya, neti'aitɨwame yuniwe naime katiniupitɨani. ");
INSERT INTO hch_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Hikɨ neti'aitɨwame mɨpaɨ pɨnerehɨritɨa: “Neniwe pepɨkakuwitɨtɨwani 'ena kiekame kananeutsixi waniwe, nemanukatsie. ");
INSERT INTO hch_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Matsi pɨta kenemie ne'iwama memanu'uwatsie, mana kenetiwawa 'uka neniwe 'ɨyaya mayanikɨ”. ");
INSERT INTO hch_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Ne mɨpaɨ nekatineitahɨawe neti'aitɨwame: “Neuxeitsɨ. ¿Peru xɨka 'uka kaheyuwaɨriyani ne 'utɨma mamie?” ");
INSERT INTO hch_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Hikɨ mɨpaɨ nerahɨawe: “Yawé nehamatɨa puyeika, mɨkɨ 'ahamatɨa yuniuki tuayame panunɨ'ani, 'aixɨa 'anemekɨ pemakunuanikɨ pemeikaxeiyakɨta 'uka neniwe hetsiemieme nepaapa tɨɨriyamama wahetsɨa. ");
INSERT INTO hch_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Xɨka ne'iwama mekaheitaunieni 'uka, mɨpaɨ 'ekɨri pepɨkaraye'atɨani kepemutayɨ neri waɨriyarika nepɨkamatsipitɨani”. ");
INSERT INTO hch_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","»Kepauka haa matineika nemunua mɨpaɨ neputayɨ: “Yawé 'Apɨrahami Kakaɨyarieya, xɨka mɨpaɨ matinakeni, waɨkawamekɨ nepɨmatsiwawirie 'aixɨa ketineuyuri 'aixɨa nemɨrakunuanikɨ. ");
INSERT INTO hch_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","'Ena nepuka, neta'ikwewatɨ haputsu matinieretsie. Xɨka xewitɨ 'ɨimari hayeyani kuhanɨnetɨ, mɨpaɨ nepɨtitahɨawe: ‘Neuxei, 'Etsiwa keneneuharitɨa 'aye'ɨta mieme’, ");
INSERT INTO hch_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","xɨka kemɨ'ane mɨpaɨ mɨtayɨni: ‘Kenanuhareka 'ekɨ, nekaniwatihanɨimɨkɨta kameyutsixi wahetsiemieme’, mɨkɨ kehɨkɨtɨni 'uka pemanayexei Yawé, neti'aitɨwame nu'aya hetsiemieme”. ");
INSERT INTO hch_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","»'Akuxi nekaranunɨwekaku neyunenewietɨ, Xeweka nekaniuxeiya mana 'amiekame yuye'ɨ 'anakayetɨ. Hikɨ kaniutihanɨni haputsuta, mɨpaɨ nekatineitahɨawe: “Neuxei, keneneuharitɨa”. ");
INSERT INTO hch_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Mɨkɨ yapauka yuye'ɨ 'anakahanaka mɨpaɨ kanetinetahɨawe: “Kenanutihareka 'ekɨ, meta 'akameyutsixi nekaniwatiharitɨamɨkɨ”. Mexi ne neheharekai mɨkɨta nekameyutsixi kaniwaretiharitɨani. ");
INSERT INTO hch_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Hikɨ nekaneita'iwawiya: “¿Kemɨ'ane pepɨraniwe?” Kepauka mɨkɨ mɨpaɨ mɨnereta'ei: “Wetuheri nepɨniweya, Nakuxi Mirika waniwe”, ne tsurieyatsie nekaneiyewirieni nakɨtsa meta matsɨwa hutame nekaneimini, ");
INSERT INTO hch_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","hikɨ nekanetitunumakeni Yawé pamɨpariyutsi nekanepitɨani, 'Apɨrahami Kakaɨyarieya, 'aixɨa mɨnetiuye'atɨa 'uka nemɨtaxeiyakɨ 'iwamama waniwetɨme neti'aitɨwame nu'aya hetsiemieme. ");
INSERT INTO hch_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Hikɨ, yaxekeneteneutahɨawi xɨka 'aixɨa xetekakɨnikuni xe'inaki'erietɨ neti'aitɨwame, metatsiere yaxeneteneutahɨawi xɨka katixaɨtɨni. Netari kenemɨyɨaneni». ");
INSERT INTO hch_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Hikɨ Rawani Wetuheri hamatɨa mɨpaɨ mekaniutiyuani: —Xɨari Yawé matsi mɨpaɨ paine, tame huu temaitɨkani tepɨkayɨwawe meta tixaɨ. ");
INSERT INTO hch_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Mana puka Xeweka kenanuwitɨki mati'aitɨwame nu'aya 'ɨyaya kanayeimɨkɨ, heitseriemekɨ Yawé kemaine. ");
INSERT INTO hch_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Hikɨ kepauka 'Apɨrahami ti'uximayatsiriwame mɨpaɨ mɨtiutahɨawarie, kaniukatunumakeni kananakatutsire Yawé hɨxie. ");
INSERT INTO hch_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Hikɨ katinewatipini hurukɨ mɨtiwewiyatɨka meta pɨratakɨ metatsiere 'ixurikite mɨraye'atɨka Xeweka katiniupitɨani. Yaxeikɨa matsikaya meta maamaya katiniwayetuirieni 'imikierite. ");
INSERT INTO hch_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","'Anari mɨkɨ meta mɨwarawitɨkɨkai mekateniukwani mekateniu'ieni, mana mekanikuheteitɨni wahetsɨa. 'Uxa'arieka ximeri kepauka memanuku'ui, 'Apɨrahami ti'uximayatsiriwame mɨpaɨ kaniutayɨni: —Nekanakunuamɨkɨtsɨari neti'aitɨwame hetsɨa. ");
INSERT INTO hch_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Peru Xeweka matsikaya meta maamaya mɨpaɨ mekaniutiyuani: —Tamamata tukari 'akuxi ke'ukunuani Xeweka, 'anake tsepa metɨa. ");
INSERT INTO hch_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Ti'uximayatame mɨpaɨ kaniutayɨni: —Neuxeitsɨ xepɨkanetsi'ukununuitɨwani, 'aixɨa 'anemekɨ nemakunuanikɨ Yawé yapɨtiuyuri, 'ayumieme xekeneneupitɨa nemɨyemiekɨ neti'aitɨwame kie. ");
INSERT INTO hch_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Hikɨ mɨkɨ mɨpaɨ mekaniutiyuani: —Xeweka tepɨta'iwawiya ketayɨni. ");
INSERT INTO hch_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Mɨkɨ me'ita'inieka mɨpaɨ mekatenita'iwawiya: —¿Petiyemie 'ikɨ 'utɨa? Xeweka mɨpaɨ katiniwaruta'eiya: —Huu. ");
INSERT INTO hch_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Hikɨ mekanipitɨani Xeweka mɨyemiekɨ, meta 'ukaratsi yamɨti'ɨwiyakai mitaweriyaxɨ 'Apɨrahami ti'uximayatsiriwame 'utɨa meta memeweiyakai. ");
INSERT INTO hch_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Hikɨ Kakaɨyari mekaniutawawirieni Xeweka hetsiemieme 'aixɨa miyurienikɨ mɨpaɨ me'utiyuatɨ: «Ta'iwa, tame mɨpaɨ tepɨteku'eriwa: Yuwaɨkawame wamaama peke'ayani. 'Anuiwarima kemɨ'ane memɨwaraye'unie meketewaruta'aitɨani wakiekaritetsie». ");
INSERT INTO hch_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Hikɨ Xeweka meta memɨte'ita'uximayatsirieni me'anutiyaxeka kameyutsixi wahetsie mekanekɨne 'Apɨrahami ti'uximayatsiriwame 'utɨa. Mɨpaɨ Xeweka katinewitɨkieni, 'ana kanayeyani. ");
INSERT INTO hch_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Hikɨ 'Itsahaki kaninuakaitɨni haputsu matinieretsie «'Amuyeika Mɨnetsixeiya» mɨtitewatsie, 'anatsɨ Nekexi mɨrakutewatsie kaniuyeikakaitɨni. ");
INSERT INTO hch_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Merikɨtsɨ taikai kanikuyani yeuta. Hikɨ yapauka kameyutsixi kaniwaruxeiya me'aye'axɨaximeme mematiteitsie. ");
INSERT INTO hch_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Yaxeikɨata Xeweka 'Itsahaki kaniuxeiya, 'ixeiyaka kananakayani kameyutsie ");
INSERT INTO hch_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","ti'uximayatame mɨpaɨ katiniuta'iwawiya: —¿Kemɨ'ane pɨyɨane mana yeuta matimie tahepa? Ti'uximayatame mɨpaɨ kaniutayɨni: —Neti'aitɨwame kaniyɨaneni. Hikɨ Xeweka kaneuyuku'eima yɨhɨxie 'ixurikikɨ. ");
INSERT INTO hch_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Hikɨ ti'uximayatame 'Itsahaki naime katiniutaxatɨani kemɨrakunua. ");
INSERT INTO hch_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Hikɨ 'Itsahaki Xeweka 'ixuriki kiiyarita kaneutawitɨni maamaya muyehupukaitsie Tsara, kanitiwitɨni waɨkawa 'inaki'erietɨ, 'ɨyaya kanayani. Mɨpaɨ 'Itsahaki yu'iyaritsie katiniuyɨnɨtɨani maamaya mumɨkaikɨri. ");
INSERT INTO hch_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Merikɨtsɨ 'Apɨrahami tawarita 'ukaratsi kaniutiwitɨni Tsetura titewakame. ");
INSERT INTO hch_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Mɨkɨ hamatɨa yuniwema kaniwarayexeiya: Tsimɨrani, Kutsani, Merani, Mariyani, 'Itsiwaki 'imatɨrieka Tsuhaki. ");
INSERT INTO hch_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Kutsani Tsawa paapaya kanayani meta Rerani. Rerani nuiwarimama mekanakɨne 'atsureutsixi, retutseutsixi, rehumeutsixi. ");
INSERT INTO hch_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Mariyani niwemama mekanakɨne, 'Epa, 'Epexi, Kanuki, 'Awiraha, 'imatɨrieka 'Eriraha. 'Ikɨ yunaitɨ Tsetura niwemama mekanihɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","'Apɨrahami yuniwe 'Itsahaki naime katiniyetuirieni tita mɨrexeiyakai. ");
INSERT INTO hch_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Meta 'Apɨrahami hipame yɨ'ɨitama waniwema tiwayetuirieka kaniwarenɨ'ani, mexi'akuxi 'a'uyeikakai, 'Itsahaki hamatɨa memɨkatitenikɨ, tau manatineika hepatsie kaniwarenɨ'ani. ");
INSERT INTO hch_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","'Apɨrahami kaniutihuni xeitsienituyari heimana haika tewiyari heimana tamamata heimana 'auxɨwi (175) wiyari. ");
INSERT INTO hch_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Mɨya paɨmexɨa 'utihuka 'Apɨrahami kaniumɨni waɨkawa 'ukiratsitɨtɨri, tutsimama memakuhe wahetsɨa kaneyani. ");
INSERT INTO hch_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Niwemama 'Itsahaki meta 'Itsimaheri meyunaitɨ mekanika'awieta terɨta Makipera mɨrakutewatsie Mamɨre 'aurie, 'Epuruni kwieyatsie, Heti tewiyari Tsukaxi nu'aya. ");
INSERT INTO hch_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","'Apɨrahami minanekai pɨhɨkɨtɨkai hetitsixi muwarunanairiekai, muwa mekaneitateni 'ɨyaya Tsara hamatɨa. ");
INSERT INTO hch_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Hikɨ 'Apɨrahami 'ukumawereku, Kakaɨyari 'Itsahaki 'aixɨa kaniuyurieni 'Apɨrahami nu'aya, putsu 'aurie kaniuyuhayewa «'Amuyeika Mɨnetsixeiya» mɨtitewa 'aurie. ");
INSERT INTO hch_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","'Ikɨ mekanihɨkɨtɨni 'Itsimaheri nuiwarimama, 'Apɨrahami nu'aya Hakari hetsie meyexei, 'ekipitutanaka Tsara parewiwameya. ");
INSERT INTO hch_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Mɨpaɨ mekatenitetewaka 'Itsimaheri niwemama: Newayuti, Tseraxi, 'Ariweheri, Miwitsani, ");
INSERT INTO hch_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mitsima, Rumaha, Matsa, ");
INSERT INTO hch_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Haraxi, Temaha, Ketuxi, Napitsi meta Tserema. ");
INSERT INTO hch_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","'Ikɨ mepɨhɨkɨ 'Itsimaheri niwemama, tamamata heimana huta nuiwarite mepakɨ kememɨtetetewa yaxeikɨa, yuxexuitɨ kwie mehexeiyatɨ mepakɨ me'ukutetɨkaitɨ. ");
INSERT INTO hch_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","'Itsimaheri xeitsienituyari heimana xeitewiyari heimana tamamata heimana 'atahuta (137) wiyari puyeikakai. Kaniumɨni tutsimama memakuhe wahetsɨa kaneyani. ");
INSERT INTO hch_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Nuiwarimama Kawira mekaniuyuhayewa meta Tsuhuxi, 'Ekipitu 'aurie mekatenitekaitɨni, huye 'Atsiriya haneme manuyehanetsie, mana mekaniuyuhayewa yu'iwama mewaraye'unietɨ. ");
INSERT INTO hch_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","'Ikɨ 'Itsahaki kemuyɨ pɨ'ɨxatsiyari, 'Apɨrahami nu'aya. ");
INSERT INTO hch_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","'Itsahaki huta tewiyari wiyari kanexeiyakaitɨni kepauka Xeweka mutiwitɨ, Wetuheri niweya, Rawani taruya. Wetuheri Rawani hamatɨa 'arameu teɨteriyari mepɨhɨkɨtɨkai Parani-'Arami mepɨkiekataritɨkai. ");
INSERT INTO hch_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Hikɨ Xeweka pɨkaniwewekai, 'ayumieme 'Itsahaki Yawé kaniutawawirieni hetsiena mieme, hikɨ Yawé kani'enieni nenewierieya, Xeweka kaniutihukata. ");
INSERT INTO hch_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Peru hukayahetsie paitɨ meyetetɨ yuhutatɨ tɨɨri mekaniyukwitɨwekaitɨni, mɨkɨ 'ayumieme mɨpaɨ kaniutayɨni: «Xɨka mɨpaɨ netiuka'eniwamɨkɨ, ¿titayari 'anetiuyeikani?» Hikɨ Yawé kaniutahɨawe kanita'iwawiya. ");
INSERT INTO hch_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Mɨkɨ mɨpaɨ katinita'eiya: «'Ahukatsie huta nuiwariyari mepɨyetei, huta nuiwariyari 'ahukatsie meyetetɨ mepayuye'unie. Xewitɨ tɨrɨkaɨyetɨ kanayeimɨkɨ xewitɨta hawaikɨ, 'amɨyumate yutaru katinita'uximayatsiriemɨkɨ». ");
INSERT INTO hch_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Hikɨ Xeweka kepauka maye'atɨarie matiniwenitsie, yuhutame kaniwarayexeiya tɨɨri. ");
INSERT INTO hch_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Matɨari mutinuiwaxɨ kɨpateya kanitataɨrawikaitɨni, naitɨ hauhuxatɨ. 'Etsahu mekateniterɨwa. ");
INSERT INTO hch_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","'Utɨmanata mutinuiwaxɨ yu'iwa 'Etsahu keputsayatsie 'awietɨ kaniutinuiwa. Mɨkɨ Kakuwu mekateniterɨwa. Kepauka mɨkɨ tɨɨri yuhutatɨ memutinunuiwaxɨ 'Itsahaki haika tewiyari wiyari kanexeiyakaitɨni. ");
INSERT INTO hch_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Tɨɨri mekaniutiwawere. 'Etsahu yeuta kaninakekaitɨni, yeutari kwinimieme tiwareutakwiwetɨ kanayani. Kakuwu meta kayuwatɨ muyeika kanayani, yukie mukani kaninakekaitɨni. ");
INSERT INTO hch_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","'Itsahaki matsi waɨkawa 'Etsahu kaninaki'eriekaitɨni, minakekaikɨ xɨ'erikaya mɨtikwaka, Xeweka matsi Kakuwu waɨkawa kaninaki'eriekaitɨni. ");
INSERT INTO hch_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Hikɨ Kakuwu pɨtiyuwewiriekai tikwanike, mana 'Etsahu kaninuani 'uxetɨ yeuta hanuyaka mɨpaɨ katinitahɨawe: ");
INSERT INTO hch_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","—Netineumikwa mɨkɨ 'itsari mɨxetakɨ, kwinimieme nepɨti'uxe. ('Ayumieme 'Etsahu 'Erumi pɨtiuterɨwarie). ");
INSERT INTO hch_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Kakuwu mɨpaɨ katinita'eiya: —Keneneutuiriekameri heitserie kepemɨrexeiya 'ekɨ meri pemɨmiemekɨ. ");
INSERT INTO hch_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","'Etsahu mɨpaɨ kaniutayɨni: —Haakakɨ nepɨmɨxime, tixaɨtɨkɨ pɨkatiyunaki'erie heitserie kenemɨrexeiya nemexɨakametɨtɨ. ");
INSERT INTO hch_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Kakuwu matsi tawarita mɨpaɨ katinitahɨawe: —Kamɨtsɨ keneneutuiri heitserie kepemɨrexeiya yanetineutahɨawi 'aheyemekɨ. 'Etsahu yurikɨ yakaniutayɨni, mɨkɨ mɨpaɨ katiniyetuirieni heitserie kemɨrexeiyakai mexɨakametɨtɨ. ");
INSERT INTO hch_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Kakuwu 'Etsahu katiniumini mume 'etsimɨpepe 'itsariyarikɨ meta paa kanimini. Hikɨ tiukwaka 'anutihareka kaneyani. Mɨpaɨ tiuyurieka tixaɨtɨ katiyunaki'erikame payeitɨa heitserie kemɨrexeiyakai mexɨakametɨtɨ. ");
INSERT INTO hch_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Mɨkɨ tukaritsie waɨkawa haakaxa kanayani mɨkɨ kwieyaritsie, meripaitɨ 'Apɨrahami muyeikakaitsie hepaɨ. 'Ayumieme 'Itsahaki kaneyani Keraxi, 'Awimereki manuyeikakai piritsiteutsixi tiwa'aitɨwame. ");
INSERT INTO hch_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Mana Yawé kaniyuhekɨata mɨpaɨ katinitahɨawe: «Pepɨkaheyeikani 'Ekipitu. Mɨkɨ kwieyaritsie keneuyuhayewa kemɨ'ane nemɨmatsi'uxeitsitɨatsie. ");
INSERT INTO hch_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Mana keneuyeikani yatewimekɨ. Ne'ahamatɨa nepuyeikani, 'aixɨa nepɨmatsiyurieka, karikɨ matsi 'ekɨ meta 'anuiwarima nepɨxeyetuirieni 'ikɨ naime kwie. Mɨpaɨ yurikɨ nepɨreye'atɨani 'apaapa 'Apɨrahami kenemɨrahɨawekai. ");
INSERT INTO hch_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Nepɨwatimɨiriya 'anuiwarima xurawetsixi wahepaɨ, 'ikɨ naime kwie nepɨxeyetuirieni, 'anuiwarima wahekɨ yunaitɨ nuiwarite kwiepa memɨtama 'aixɨa mepɨ'itɨarieka. ");
INSERT INTO hch_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","'Apɨrahami mɨnetsi'anu'enikɨ naime kenemɨti'aitɨakai, 'inɨari niukiyarikɨ, kenemɨrehɨawekai meta kenemɨti'ɨkitɨakai». ");
INSERT INTO hch_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Hikɨ 'Itsahaki Keraxi kaniuyuhayewa. ");
INSERT INTO hch_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Kepauka teɨteri mana kiekatari memiku'iwawiyakai 'ɨyaya hepaɨtsita, mɨkɨ kename 'iwaya kaniutainekaitɨni, Xeweka kwinimieme witsikatini'ɨimarikaitɨni, 'Itsahaki kaneumakaitɨni heitserie mɨtiwataxatɨanikɨ, mɨpaɨ pɨtiku'eriwakai me'imienike 'ɨyayakɨ pɨ'eriekai. ");
INSERT INTO hch_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Mɨixa tukari 'anukayakuke, 'Awimereki piritsiteutsixi tiwa'aitɨwame yukiita paitɨ 'ayekaitɨ kanitanierekaitɨni kiekaritsie, hikɨ 'Itsahaki kaniuxeiya yɨ'ɨya Xeweka 'ikamaɨwame. ");
INSERT INTO hch_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Hikɨ 'Awimereki 'Isahaki hekɨ katiniutanɨ'ani, mɨpaɨ katinitahɨawe: —¿Kamɨtsɨ mɨkɨ ti'a'ɨya? ¿Titayari kename 'a'iwa petiutayɨ? 'Itsahaki mɨpaɨ kaniutayɨni: —Ne nepɨxemakakai, xe'iwitɨkutɨ xenetsimienike nepɨ'eriekai. ");
INSERT INTO hch_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Peru 'Awimereki mɨpaɨ katinitahɨawe: —Mɨpaɨ pepɨkatatsiyurieneni 'ekɨ tame, tawarita xeitɨkari xɨka 'anukayanike, xewitɨ hamatɨana xɨka 'ukahunike, hikɨ 'ekɨ teyunaime 'axapepɨtatsiyurienikekai. ");
INSERT INTO hch_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Hikɨ 'Awimereki yunaime yuteɨterima mɨpaɨ katiniwarutahɨawe: —Kemɨ'ane 'ikɨ tewi 'axamɨmatɨaka yatɨni 'ɨyaya, kanimieriemɨkɨ. ");
INSERT INTO hch_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Mɨkɨ wiyaritsie 'Itsahaki kaniuka'eni mɨkɨ kwieyaritsie, 'aixɨa katiniuxuawere Yawé miparewiekaikɨ. ");
INSERT INTO hch_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Mɨpaɨ titsutɨaka 'Itsahaki waɨkawa rexeiyatɨ kanayani. ");
INSERT INTO hch_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Muxatsi waɨkawa pɨwarexeiyakai, wakaitsixi, meta teɨteri mɨtiwa'aitɨakai, piritsiteutsixi waɨkawa piiniteyakɨ mekaniniukimakaitɨni. ");
INSERT INTO hch_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Kepauka 'Itsahaki paapaya mayeyurikaitsie 'Apɨrahami, mɨkɨ teɨterimama putsu meputiwewiekai, peru 'ariketa piritsiteutsixi mepenuteukixɨa. ");
INSERT INTO hch_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Hikɨ 'Awimereki 'Itsahaki mɨpaɨ katiniutahɨawe: —Hikɨri 'ekɨ matsi waɨkawa pepɨrexeiya, pepɨtatsi'a'iwari, 'ayumieme keneumieni 'enari pepɨka'ukani. ");
INSERT INTO hch_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Hikɨ 'Itsahaki kaneyani mayeweritsie Keraxi mɨrayetewatsie, mana kaniuyuhayewa. ");
INSERT INTO hch_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Tawarita putsu kanewatiwiwiexɨani, paapaya 'Apɨrahami muyeikakaitsie mieme, piritsiteutsixi memeikanaxɨakai 'umɨkuri, 'Itsahaki yaxeikɨata katiniterɨwaxɨani paapaya kemɨtiterɨwaxɨakai. ");
INSERT INTO hch_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Hikɨ heiwa mieme 'Itsahaki hetsɨa te'uximayatamete putsu mekaniutawewieni mana mayeweritsie, hikɨ haixa mekaniutaxeiya. ");
INSERT INTO hch_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Peru manata Keraxi kiekatari mana memɨtetihɨwekai mekaniwarutitieni 'Itsahaki teɨterimama muxatsi wahɨwemete, mɨkɨ mɨpaɨ me'utiyuatɨ kename mɨkɨ pɨta wahetsiemiemetɨkai. 'Ayumieme 'Itsahaki Mɨrayukwine katiniterɨwa mɨkɨ putsu, kɨmana meyukwitɨwekaikɨ. ");
INSERT INTO hch_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Tawarita xaɨtsie 'Itsahaki teɨterimama putsu mekaniutawewieni, hutariekata mana mekaniuyutitieni, mɨkɨ putsu 'Itsahaki Temataye'unie katiniterɨwa. ");
INSERT INTO hch_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","'Itsahaki kaneyani 'aheteewakaku mana tawarita putsu kaniutawewieni, mɨkɨkɨ hɨrixɨa mepɨka'uyutikwi, 'ayumieme katiniterɨwa 'Amakuyewa, mɨpaɨ kaniutayɨni: «Hikɨ Yawé pɨtatsi'upitɨa 'ena temu'uwanikɨ». ");
INSERT INTO hch_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Mana mɨyetɨa Weritsewa kaneyani. ");
INSERT INTO hch_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","'Ana tɨkaritsie Yawé kaniuyuhekɨata mɨpaɨ katinitahɨawe: «Ne 'apaapa 'Apɨrahami Kakaɨyarieya nekanihɨkɨtɨni. Pepɨkamaka, ne 'ahamatɨa nepuyeika. 'Apɨrahami 'aixɨa mɨtiuyurikɨ, 'aixɨa nepɨmatsiyurieni nepɨwatimɨiriya 'anuiwarima». ");
INSERT INTO hch_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Hikɨ 'Itsahaki mawari taiyame kaniutawewieni, mana Yawé kaniutahɨawe. Mana kaniuyuhayewa, teɨterimamata mana putsu mekaniutawewieni. ");
INSERT INTO hch_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Hikɨ 'Awimereki kaninuani Keraxi paitɨ 'ayeneka, 'Itsahaki hamatɨa titaxatake, 'Akutsati kaneweiyakaitɨni tixaxatɨwameya meta Pikuuri kuyaximama wa'ukiyari. ");
INSERT INTO hch_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","'Itsahaki mɨpaɨ katinita'iwawiya: —Xeme xepɨkanetsinaki'erie, xepɨnetsi'ayewei, ¿titayarita 'uxete'ahu? ");
INSERT INTO hch_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Mɨkɨ mɨpaɨ mekatenita'eiya: —Mɨpaɨ tepɨtehetima Yawé 'ahamatɨa puyeika, mɨpaɨ tepɨteku'eriwakaku tɨratu tepɨwewienikeyu. Yurikɨ tepɨtahɨritɨanikeyu. Mɨpaɨ tɨratu tepuyurienikeyu: ");
INSERT INTO hch_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","'Ekɨ 'atsipepɨkatatsiyurienekɨ, tameta 'axatepɨkamatsiyuriekɨ, matsi pɨta 'aixɨa 'anemekɨ tepɨmatsixeiya, 'aixɨa 'anemekɨ tematsihetateutɨa. Hikɨ 'ekɨ Yawé 'aixɨa kameniyurieka. ");
INSERT INTO hch_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Hikɨ 'Itsahaki 'ixɨarari kaniwaruwewirieni, mekateniukwani mɨkɨ mekateniu'ieni. ");
INSERT INTO hch_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","'Uxa'arieka ximeri me'anuku'uka yunaitɨ me'uyu'enieka tɨratu mekaniuwewieni, hikɨ 'Itsahaki kaniwarutateutɨani, mɨkɨta mekanitahɨawe hamikutsixi mekanakɨne. ");
INSERT INTO hch_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Mɨkɨ tukaritsie 'Itsahaki teɨterimama mekaniu'axɨani mɨpaɨ me'utiyuatɨ xeime putsu hepaɨtsita: —Haa tekanetaxeiya tewati'ineka. ");
INSERT INTO hch_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","'Itsahaki kanitaterɨwa mɨkɨ haputsu, Tsewa katiniterɨwa, 'ayumieme hikɨ mana kiekari Weritsewa katinakutewaka. ");
INSERT INTO hch_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Kepauka 'Etsahu huta tewiyari wiyari mexeiyakai Yuhuri titewakame kaniutiwitɨni, Weherí niweya Heti tewiyari. Tawarita xeime tiutiwitɨ Watsemati titewakame, 'Eruni Heti tewiyari niweya. ");
INSERT INTO hch_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","'Ikɨ 'ukari yuhutatɨ 'Itsahaki meta Xeweka waɨkawa mekaniwaru'uximatɨani, mete'uka'eniwatɨ 'amepu'uwakai hipatɨ memɨhɨkɨtɨkaikɨ. ");
INSERT INTO hch_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Merikɨtsɨ 'Itsahaki kepauka 'ukiratsi matɨa kahaunieretɨ kanayani. Hikɨ kepauka 'Etsahu katiniutanɨ'airieni yuniwe matɨari mieme, mɨpaɨ katinitahɨawe: —Neniwe. 'Etsahu mɨpaɨ katinita'eiya: —Tita perayexeiya nepaapa. ");
INSERT INTO hch_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","'Itsahaki mɨpaɨ kaniutayɨni: ―Pepɨnetsixeiya nepu'ukiratsiri, kwitɨwa nepumɨwe. ");
INSERT INTO hch_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Hikɨ yeuta kenemie 'atupi meta 'a'ɨrɨ perapitɨ tixaɨtɨ ketinemi'a mɨtikwaiwa. ");
INSERT INTO hch_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Witsi'anekame kenenekawewiri mɨnetsinake hepaɨ, kenene'atɨiri nemikwanikɨ. Hikɨ 'ana Kakaɨyari nepɨtawawirieni 'aixɨa mɨmatsiyurienikɨ nekamɨwetɨkuxi. ");
INSERT INTO hch_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Hikɨ Xeweka kanita'enakaitɨni, 'Itsahaki yuniwe 'Etsahu kemɨtikɨhɨawekai, 'ayumieme 'amɨretɨa 'Etsahu yeuta reumiemieka yupaapa hetsiemieme, ");
INSERT INTO hch_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Xeweka yuniwe Kakuwu mɨpaɨ katiniutahɨawe: —Neuxei, 'apaapa nepe'eni 'Etsahu matɨa pɨrekuxatakai, mɨpaɨ pɨreikɨhɨawekai: ");
INSERT INTO hch_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","ketinemiemie kenenekawewiri tsiha'anekame nemikwanikɨ. Mɨpaɨtsiere pɨrehɨawe kename 'aixɨa 'iyurieni Yawé hɨxie mexi kamɨwe. ");
INSERT INTO hch_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Hikɨ keneneu'eni neniwe kenemɨmatitahɨawe, yaketinekaye'a. ");
INSERT INTO hch_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Kenemie tsipuri memuyename keniwarahapani yuhutame 'etsimemɨpepe 'aixɨa memɨ'anene nepikawewirieni 'apaapa 'itsari tsiha'anekame minake. ");
INSERT INTO hch_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","'Ekɨ pepenu'ɨirieni meikwanikɨ mɨpaɨ mɨkɨ Kakaɨyari petawawirieni 'aixɨa mɨmatsiheyurienikɨ kamɨwetɨ 'akuxi. ");
INSERT INTO hch_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Perutsɨ Kakuwu yumaama mɨpaɨ katiniutahɨawe: —Neuxeitsɨ, peru nematsika 'Etsahu kwinimieme pɨreuhuxa neta hawaikɨ. ");
INSERT INTO hch_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Xɨka nepaapa netsihemayɨani, pɨretimani kename neti'itaiyane, 'anari peitawawirieni 'axanemɨ'itɨariekakɨ, 'aixɨa nemɨ'itɨariekakɨ pɨkatixaɨ. ");
INSERT INTO hch_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Hikɨ maamaya mɨpaɨ katinitahɨawe: —Neuxei nepɨta nehetsie ketiunake mɨkɨ 'axamɨ'ane. 'Ekɨtɨ yaketineuyuri kenemɨmarahɨawe, kenemie kapuratsixi kenenehapaniriemie. ");
INSERT INTO hch_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Kakuwu tsipuri kaniwarekuhapani yumaama kani'atɨirieni, mɨkɨ 'itsari kanikawewirieni kemɨtinakekai 'Itsahaki. ");
INSERT INTO hch_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Hikɨ Xeweka 'Etsahu kamixaya kaniwayehurieni 'aixɨa mɨ'ane mi'utakai yukiita, mɨkɨ Kakuwu kananakatɨtɨani. ");
INSERT INTO hch_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Hikɨta kapuratsixi wanawiyarikɨ mamateya kaniuti'eima, meta kɨipitɨana hakewa mɨkaheuhuxakai, ");
INSERT INTO hch_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","hikɨ Xeweka Kakuwu yuniwe katiniyetuirieni 'itsari paa mame. ");
INSERT INTO hch_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Kakuwu yupaapa hetsɨa nuaka mɨpaɨ katinitahɨawe: —Nepaapa. 'Itsahaki mɨpaɨ katiniuta'iwauni: —¿Kemɨ'ane neniwe 'ekɨ peputaine? ");
INSERT INTO hch_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Kakuwu mɨpaɨ katinita'eiya: —Ne 'Etsahu neputaine, 'aniwe mexɨakame. 'Ari nepɨrekawewi kepemɨnerahɨawekai. Kenanukukeka ketineukwa'i tita nemɨremi, 'anari Kakaɨyari pepɨtawawirieni 'aixɨa mɨnetsiyurienikɨ. ");
INSERT INTO hch_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Hikɨ 'Itsahaki kanita'iwawiya: —¿Kwitɨwa kuta peremi, neniwe? Kakuwu mɨpaɨ katinita'eiya: —Yawé 'akakaɨyari pɨnetsiheparewi nemeitaxeiyakɨ kwitɨwa. ");
INSERT INTO hch_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Hutarieka 'Itsahaki mɨpaɨ katinitahɨawe: —'Ena 'aurawa kenayaka nemetsimayɨani mɨpaɨ nemɨretimanikɨ xɨka 'aku neniwe 'Etsahu peyɨaneni. ");
INSERT INTO hch_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Kakuwu 'aurawa kaniuyani paapaya 'imayɨaka mɨpaɨ kaniutayɨni: —Kakuwu hepaɨ pepɨtiuxaxata, peru mamate 'Etsahu pɨmamateya. ");
INSERT INTO hch_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Hikɨ paapaya pɨkaheitima, mamateya muhuxatɨkateikɨ 'Etsahu hepaɨ. Kepaukari Kakaɨyari mɨtawawirienikekai 'aixɨa miyurienikɨ, ");
INSERT INTO hch_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","tawarita kanita'iwawiya: —¿Yurikɨ 'aku neniwe 'Etsahu petiyɨane? Kakuwu mɨpaɨ katinita'eiya: —Yurikɨ ne nekaniyɨaneni. ");
INSERT INTO hch_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Hikɨ paapaya mɨpaɨ kaniutayɨni: —Netinatuiri neniwe nemɨtikwanikɨ tita pemɨremi, hikɨ Kakaɨyari nekanitawawiriemɨkɨ 'aixɨa mɨmatsiyurienikɨ. Kakuwu katinekatu'irieni paapaya mɨtikwanikɨ, meta kaxie winuyari kanikatu'irieni, 'Itsahaki katiniukwani meta kananu'ieni. ");
INSERT INTO hch_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Hikɨ paapaya mɨpaɨ katinitahɨawe: —'Aurawa kenaye'a neniwe, keneneu'itsi. ");
INSERT INTO hch_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Kakuwu 'aurawa kaniuyani kani'itseni. Kepauka 'Itsahaki mi'ɨkwixɨ kamixaya, hikɨ Kakaɨyari kaniutawawirieni 'aixɨa miyurienikɨ, mɨpaɨ 'utaitɨ: «Huu, 'ikɨ neniwe 'ɨtsita timieme hepaɨ pɨ'ɨa Yawé 'aixɨa miyuriekaikɨ. ");
INSERT INTO hch_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Kakaɨyari waɨkawa wiyeri kematsiheyenɨ'airiwani muyuawitsie mieme, waɨkawa pemɨtiukaxexeiyanikɨ 'ena kwiepa timieme tɨriku meta kaxie winuyari. ");
INSERT INTO hch_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Waɨkawa teɨteri 'ahetsɨa mekete'uta'uximayata, nuiwarite 'ahɨxie meke'utitunuma'uni. 'A'iwamatɨme peketiwaruta'aitɨani, 'amaama niwemama 'ahɨxie meke'utitunuma'uni. Kemɨ'ane 'axamɨmatsiyurieni mɨkɨta 'axapɨ'itɨarieka, meta kemɨ'ane 'aixɨa mɨmatixeiyani mɨkɨta 'aixɨa pɨ'itɨarieka». ");
INSERT INTO hch_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Hikɨ 'Itsahaki yuniwe hetsiemieme Kakaɨyari 'utawawirieku, Kakuwu 'amɨtiwayetɨa 'Etsahu kaninuani rekumieka. ");
INSERT INTO hch_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Mɨkɨta katiniukawewieni 'ikwaiya, yupaapa katine'ɨirieni, mɨpaɨ katinitahɨawe: —Nepaapa, kenanukukeka ketineukwa'i tita nemɨremi. Hikɨ Kakaɨyari keneutawawiri 'aixɨa mɨnetsiyurienikɨ. ");
INSERT INTO hch_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Hikɨ 'Itsahaki kanita'iwawiya. —¿Kemɨ'aneta 'ekɨ peputaine? 'Etsahu mɨpaɨ kaniutayɨni: —Ne 'Etsahu neputaine, 'aniwe 'anemɨyumate. ");
INSERT INTO hch_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","'Itsahaki kaniutimani 'uyɨyɨakatɨ mɨpaɨ kaniutayɨni: —¿Kamɨtsɨ kemɨ'ane pɨyɨanekai xikepaitɨ mɨnerekumi 'itsari mɨnetsi'atɨiri? 'Ekɨ 'akuxi pekanuawekaku, ne nekanikwani naime. Meta Kakaɨyari nekaniutawawirieni hetsiena mieme 'aixɨa nekaniyurieni, mɨkɨri 'aixɨa 'itɨarietɨ kanayeimɨkɨ. ");
INSERT INTO hch_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Kepauka 'Etsahu mu'enaxɨ paapaya kemainekai karima kaniutatsuani yuhiwerietɨ, mɨpaɨ yupaapa katiniutahɨawe ha'atɨ: —Ne waɨkawa nepɨmatsiwawirie, nepaapa 'aku, Kakaɨyari keneutawawiri nehetsiemieme neta 'aixɨa mɨnetsiyurienikɨ. ");
INSERT INTO hch_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Peru 'Itsahaki mɨpaɨ katinitahɨawe: —'Amuta kaneukuyeixɨani kanetiniu'itaiya, mɨkɨri naime katinepiini tita mɨti'ahetsiemiemetɨkai. ");
INSERT INTO hch_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","'Etsahu mɨpaɨ kaniutayɨni: —'Ayumieme xɨari Kakuwu xepɨte'iterɨwaxɨ, hikɨri hutarieka kaneniukwamana, matɨari meri kaneniunawairieni kenemɨtimexɨakame, hikɨta 'aixɨa kenemɨ'itɨarienikekai kaneniunawairieni. ¿Pekatiyɨwe Kakaɨyari pemɨtawawirieni 'aixɨa mɨnetsiyurienikɨta ne? ");
INSERT INTO hch_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","'Itsahaki mɨpaɨ katinita'eiya: —Neuxei ne, Kakaɨyari neputawawiri Kakuwu hetsiemieme mɨmati'aitɨakakɨ, nepitawawiri tsiere maremama yunaitɨ memɨte'ita'uximayatsirienikɨ, tɨriku waɨkawa mukaxexeiyanikɨ meta kaxie winuyari. ¿Hikɨ tita netiutawauni 'ahetsiemieme pɨtiumaweri, neniwe 'aku? ");
INSERT INTO hch_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Peru 'Etsahu pɨkatihayewakai: —¿Xeimieme xeikɨa petiyɨwekai Kakaɨyari pemɨtawawirieni 'aixɨa xewitɨ xeikɨa mɨ'itɨarienikɨ? Keneutawawiri Kakaɨyari neta 'aixɨa mɨnetsiyurienikɨ. Mɨpaɨ 'utayɨka tawarita kaniutatsuani karima. ");
INSERT INTO hch_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Hikɨ 'Itsahaki mɨpaɨ katinitahɨawe: «'Ekɨ kwiepa 'aixɨa mɨraku'anetsie pepɨka'uyeikani, wiyeri muyuawitsie makaneika makaxɨruwe pepɨka'uyeikani. ");
INSERT INTO hch_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","'A'ixiparakɨ pe'amienetɨ pepuyeikani, 'amuta pepɨti'uximayatsirieka. Peru kepauka petɨrɨkaɨyetɨ pemayani, pepɨyuxɨna kemɨmati'aitɨa». ");
INSERT INTO hch_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Mana mɨtiyetɨa, 'Etsahu Kakuwu kanihekakaitɨni paapaya Kakaɨyari mutawawirikɨ hetsiena mieme 'aixɨa miyuriekakɨ. 'Etsahu mɨpaɨ katiniku'eriwakaitɨni: «'Arikutari kwitɨwa pɨmɨni nepaapa mɨyuke, nemuta Kakuwu nepɨmieni». ");
INSERT INTO hch_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Hikɨ kepauka Xeweka mɨretima 'Etsahu kemɨtiku'eriwakai, Kakuwu kaniuta'inieni mɨpaɨ katinitahɨawe: —Neuxei, 'a'iwa 'Etsahu pɨmatsimiemɨkɨ pemɨtinawairikɨ. ");
INSERT INTO hch_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","'Ayumieme neniwe, keneneu'eni: Keneuyuta'una Karani paitɨ, ne'iwa kie Rawani, ");
INSERT INTO hch_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","mɨkɨ hetsɨa kenekani kepaukake 'amatsika mɨratɨmaiya ha'atɨ. ");
INSERT INTO hch_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Ratɨmaiyayu kepemɨtiuyuri, 'anake niuki nepanunɨ'ani pemamiekɨ. Yanepɨkara'eriwa tietɨtsɨ xeitukaritsie yunaitɨ xemɨneuyukwixɨa. ");
INSERT INTO hch_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Hikɨ Xeweka 'Itsahaki mɨpaɨ katiniutahɨawe: —Neri nepɨkayɨwe 'anemuyeikani 'ikɨ hetitsixi wahamatɨa 'Etsahu 'ɨitamama mepɨnetsihiweritɨa. Xɨkata Kakuwu Heti tewiyari 'utiwitɨni 'ena kiekame Kanani matsi 'aixɨa pɨyɨnikeyu xɨka ne'umɨnike. ");
INSERT INTO hch_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Hikɨ 'Itsahaki Kakuwu katiniutanɨ'airieni. 'Aixɨa kaniyurieni, meta mɨpaɨ katinita'aitɨani: —'Uka 'ena Kanani kiekame pepɨka'utiwitɨkɨni. ");
INSERT INTO hch_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Hikɨ kwitɨwa kenemie Parani-'Arami paitɨ, 'ateukari Wetuheri hetsɨa, xeime kenetiwitɨki 'atatatsi Rawani niweya. ");
INSERT INTO hch_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Kakaɨyari Naimekɨmɨtɨrɨkaɨye 'aixɨa kematsiyurieka waɨkawa peke'utaxiɨni, 'ahetsie memɨyekɨnekɨ nuiwarite yuwaɨkawatɨ. ");
INSERT INTO hch_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","'Ekɨta kematsiyetuirieni meta 'anuiwarima 'Apɨrahami 'aixɨa kemuyuriekai, 'ikɨ xepiini mayanikɨ hikɨ temanu'uwa teewanarixi wahepaɨ, 'Apɨrahami kemɨtiutahɨawarie 'ikɨ kwie hepaɨtsita. ");
INSERT INTO hch_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Mɨpaɨ titahɨaweka kaneinɨ'ani yuniwe 'Itsahaki Parani-'Arami kwieyaritsie Rawani hetsɨa, 'Etsahu meta Kakuwu wamaama Xeweka matsikaya hetsɨa, Rawani matɨa Xeweka Wetuheri pɨwapaapatɨkai 'arameu tewiyari kanihɨkɨtɨkaitɨni. ");
INSERT INTO hch_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","'Etsahu katinetimani kepauka 'Itsahaki Kakuwu 'aixɨa miyuriekai meta kename heinɨ'akai Parani-'Arami kwieyaritsie paitɨ mana metineɨkekɨ. Yaxeikɨata katinetimani kepauka paapaya 'aixɨa 'iyurieka, mɨpaɨ mɨtitahɨawixɨ kename 'uka mana Kanani kiekame katiwitɨkɨnikekai, ");
INSERT INTO hch_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","meta Kakuwu kepauka metɨa Parani-'Arami paapaya meta kememɨtehehɨawekai. ");
INSERT INTO hch_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","'Ana mɨpaɨ katinetimani 'Etsahu, kename paapaya 'ukarawetsixi Kanani kiekatari kawanaki'eriekai. ");
INSERT INTO hch_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","'Ayumieme tsepa mɨneɨkekai 'Etsahu kaneyani hakewa paitɨ tatatsieya mekatei 'Itsimaheri 'Apɨrahami nu'aya. Mana xeime kaniutiwitɨni nu'ayatɨme Makarati titewakame, Newayuti taruya kanihɨkɨtɨkaitɨni. ");
INSERT INTO hch_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Kakuwu kanayeyani Weritsewa, huye kananukuweiya Karani haneme. ");
INSERT INTO hch_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Kepauka tau makayunixɨ 'umiekaku mana kaniukateitɨni, tete kaniutituni kanikamu'urita, hikɨ 'ukahuka kaneukuni. ");
INSERT INTO hch_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Mana katiniuheinɨni, 'imɨmui 'ahatayeume kaniuxeiya kwiepa yuwetɨkaime muyuawitsie heutiyuneme, mɨkɨ 'ɨtɨma mekananutikɨkaitɨni niuki tuayamete Kakaɨyari hetsɨa miemete me'anutikɨkame me'anakakɨkame. ");
INSERT INTO hch_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Metatsiere Yawé kaniuxeiya 'auriena 'uweme, mɨpaɨ tikɨhɨaweme: «Ne Yawé nepɨhɨkɨ 'ateukari Kakaɨyarieya 'Apɨrahami meta 'apaapa 'Itsahaki. 'Ekɨ yaxeikɨa 'anuiwarima 'ikɨ kwie nepɨxeyetuirieni mana hikɨ pemanukatsie. ");
INSERT INTO hch_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Mɨkɨ yumɨiretɨ mepakɨne kwie tumuanariyari hepaɨ. 'Amepɨtayeure 'ayeta, 'atsutɨa, 'atserieta, 'a'utata meye'atɨkaitɨ meta yunaitɨ nuiwarite kwiepa memɨtama 'aixɨa mepɨ'itɨarieni 'ekɨ 'akɨmana meta 'anuiwarima». ");
INSERT INTO hch_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Ne 'ahamatɨa nepuyeikani. Nepɨmatsi'ɨwiyani tsepa hakewa pemeyeika, meta nepɨmatsi'akunuitɨani 'ikɨ kwieyaritsie. Nepɨkamatsiku'eirieni neraye'atɨameke kenemutayɨkai». ");
INSERT INTO hch_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Kepauka Kakuwu manutanierixɨ mɨpaɨ katiniu'erieni: «Yurikɨ Yawé 'ena puyeika, ne 'atsinepɨkatimaikai». ");
INSERT INTO hch_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Heumatɨri waɨkawa tawarita mɨpaɨ kaniutayɨni: «'Ena xɨari pakupatsie, 'ena xɨari pɨhɨkɨ Kakaɨyari kie, muyuawi kitenie pɨti'ane». ");
INSERT INTO hch_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","'Uxa'arieka ximeripaitɨ kananukukeni Kakuwu, tete kaniutituni mimu'uritakai 'a'uweme kanayeitɨani huriwa hatseitiyarikɨ kanika'ɨya patsiekame kanayeitɨani. ");
INSERT INTO hch_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","'Ana mana kiekari kanikumakaitɨni 'Arimetɨra maku'u titewatɨ, peru Kakuwu kanipata Weteri pɨta katiniterɨwa. ");
INSERT INTO hch_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Hikɨ mana Kakuwu mɨpaɨ kaniutayɨni: «Xɨka Kakaɨyari nehamatɨa 'uyeikani netsi'ɨwiyani hakewa nemeutɨa, xɨka neremikwani meta nereketɨaka, ");
INSERT INTO hch_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","xɨka ne'akunuani 'aixɨa nereu'erietɨ nepaapa hetsɨa, hikɨ 'ana Yawé nekakaɨyari kanayeimɨkɨ. ");
INSERT INTO hch_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","'Ikɨta tete 'anemitake Kakaɨyari kiiya kanayeimɨkɨ, naime tita Kakaɨyari mɨnetimini, nekaniyetuiriemɨkɨ tamamata hetsiemieme xeime». ");
INSERT INTO hch_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Merikɨtsɨ Kakuwu kaneyani, tau manatineika hepatsie kiekatari wakwieyaritsie kaniye'ani. ");
INSERT INTO hch_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Hikɨ mana 'uta'aka yeuta haputsu kaniuxeiya, 'auriena haika tewayari muxatsi mekani'uxipitɨariekaitɨni mana memɨtiharewekaikɨ. Mɨkɨ haputsu tete 'ayeukamekɨ kananukanakaitɨni. ");
INSERT INTO hch_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","'Ayumieme yunaitɨ tehɨwemete meyukuxeɨriemeke mekaniyexɨrakaitɨni, hikɨ yunaime mewatiharitɨame, tawarita yunaitɨ mekanenukanarɨmakaitɨni haputsu. ");
INSERT INTO hch_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Hikɨ Kakuwu kaniwaruta'iwawiya tehɨwemete: —¿Hakewa xepekiekatari xeme? Mɨkɨ mɨpaɨ mekatenita'eiya: —Karani tepɨkiekatari. ");
INSERT INTO hch_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Tawarita Kakuwu kaniuta'iwauni: —¿Kamɨtsɨ xeme Rawani xetemate, Nakuxi nu'aya? —Huu tepimate —mekatenita'eiya. ");
INSERT INTO hch_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Tawarita mɨpaɨ Kakuwu katiniwaruta'iwawiya: —¿'Aixɨa kapɨreu'erietɨtɨ? Mɨkɨta mɨpaɨ mekatenita'eiya: —'Aixɨa pɨreu'erie. Kamɨmatsi niweya huma kanamieni Xakeri muxatsi wara'arietɨ. ");
INSERT INTO hch_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Hikɨta Kakuwu mɨpaɨ katiniwarutahɨawe: —Matsi 'akuxi puximeri, yakɨpupauka 'akuxi muxatsi xemɨwareunaxɨanikɨ wakuraruta, 'aixɨa pɨyɨni yumuxatsima xekeniwarutiharitɨaka xeketenewamiyu. ");
INSERT INTO hch_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Mɨkɨ mɨpaɨ mekatenita'eiya: —Hawaikɨ tepɨkayɨwawe mɨpaɨ temɨte'uyurieni taxaɨtame, teyukwewiemeke tanaitɨ tehɨwemete tepenuku'ɨwe tete. 'Anake tepɨyɨwawe tamuxatsima temɨwarutiharitɨani. ");
INSERT INTO hch_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Wahamatɨa tikuxatakaku 'akuxi, Xakeri kaninuani muxatsi wara'arietɨ yupaapa tewamama, mɨkɨ kaniwahɨwemetɨkaitɨni. ");
INSERT INTO hch_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Hikɨ kepauka Kakuwu Xakeri muxei, yutatatsi Rawani niweya, mana 'uyaka haputsu kananutiyepieni, muxatsimama kaniwarutiharitɨani. ");
INSERT INTO hch_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","'Anata kwitɨwa Xakeri kaniu'itseni, meta kaniutatsuani, ");
INSERT INTO hch_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","mɨkɨ katinitaxatɨani kename me'iwamarixi Xeweka mɨnu'ayatɨkaikɨ. Hikɨ 'ayumieme Xakeri yapauka 'unautsarɨmetɨ kaneyani yupaapa hetsɨa reitaxatɨanike. ");
INSERT INTO hch_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Hikɨ Rawani yumatsu Kakuwu 'utamarieka kaneyani kaneikunake kanitatapa meta kani'itseni, yukie kanei'inieni. Hikɨ Kakuwu naime katinitaxatɨani naime kemɨreyɨ, ");
INSERT INTO hch_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Rawani mɨpaɨ katinitahɨawe: «'Ekɨtsɨ yuheyemekɨ ta'iwa pekanihɨkɨtɨni». Merikɨtsɨ Kakuwu xeimetseri kaniukateitɨni Rawani hetsɨa. ");
INSERT INTO hch_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Mɨpaɨ katinitahɨawe: —Tsepanetɨ hurawa pemɨne'iwa yakɨxeikɨa pepɨkati'uximayaka nehetsɨa. Yakenetineutahɨawi kepaɨmeme pepeu'iwamɨkɨ. ");
INSERT INTO hch_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Rawani yuhutame kaniwarexeiyakaitɨni yuniwema 'ukari, kurieya Reya pɨtitewakai, taruyata Xakeri. ");
INSERT INTO hch_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Reya hɨxiteya witsipɨ'anenekai, peru Xakeri witsipɨtiyuxexeiyakai naitɨ. ");
INSERT INTO hch_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Hikɨ Kakuwu Xakeri mɨhiwe'eriekaikɨ yutatatsi mɨpaɨ katiniutahɨawe: —'Atahuta wiyari nepɨti'uximayaka 'ahetsɨa, 'aniwe yakɨ mɨyumate Xakeri nemɨtiwitɨnikɨ. ");
INSERT INTO hch_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Rawani mɨpaɨ katinita'eiya: —'Aixɨa kaniyɨmɨkɨ nemɨmatsiwitɨtɨanikɨ 'ekɨ, xeime nemɨka'imate nemɨkakuwitɨtɨwanikɨ. Nehetsɨa keneuyuhayewa. ");
INSERT INTO hch_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Hikɨ Kakuwu 'atahuta wiyari katini'uximayakaitɨni Xakeri mɨtiwitɨnikɨ, hikɨ 'apɨkareuterixɨ tsepa mɨixa tukari manuyetɨa waɨkawa minaki'eriekaikɨ. ");
INSERT INTO hch_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Hikɨ Kakuwu mɨpaɨ Rawani katiniutahɨawe: —'Ari nepɨraye'atɨa kenemutayɨ. Keneneyetuiriri nemitiwitɨnikɨ. ");
INSERT INTO hch_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Rawani mana kiekatari yunaime kaniwaruta'inieni, 'ixɨarari mariweme kaniuwewieni. ");
INSERT INTO hch_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Peru kepauka mukɨyɨrixɨ, kurieya pɨta Kakuwu kaniyetuirieni Reya mɨtitewakai, 'ana Kakuwu hamatɨana kaniukahuni. ");
INSERT INTO hch_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Reya xeime ti'uximayatame pexeiyakai Tsiripa titewakame, 'ayumiemeta Rawani kanixatɨani miparewiekakɨ. ");
INSERT INTO hch_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Hikɨ 'uxa'arieka katinetimani Reya matɨa pɨta mukateikɨ, 'ayumieme Rawani mɨpaɨ katiniutahɨawe: —¿Titayari mɨyapenetiuyuri? ¿Netamɨ nekamatiuta'uximayatsiri Xakeri nemɨtiwitɨnikɨ? ¿Ketitayari penetiu'itai? ");
INSERT INTO hch_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Rawani mɨpaɨ katinita'eiya: —Tame tayeiyari mɨpaɨ pɨ'ane 'ikɨ kwieyaritsie, Kurieya meri pɨtiwikieni 'ariketa taruya. ");
INSERT INTO hch_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","'Ayumieme hikɨ kenaye'atɨa tsemana kemɨreuyewetse, tawarita 'uximayatsikakɨ 'atahuta wiyarikɨ tawarita xeime nepɨmatsiwitɨtɨani. ");
INSERT INTO hch_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Kakuwu mɨpaɨ katinikayani, kepauka tsemana maye'atɨa xeimetsie mieme kemɨreuyewetse, Rawani Xakeri kaniyetuirieni 'ɨyaya mayanikɨ. ");
INSERT INTO hch_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Xakeri xeimeta ti'uximayatame kanexeiyakaitɨni Wiriha titewakame, Rawani kaniyetuirieni miparewiekakɨ. ");
INSERT INTO hch_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Hikɨ Kakuwu kaniukahuni hamatɨana, waɨkawa matsi Xakeri kaninaki'eriekaitɨni Reya 'akuxi matsi 'etsiwa, tsepa 'akuxi 'atahuta wiyari tawarita Rawani mɨtiuta'uximayatsiri. ");
INSERT INTO hch_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Kepauka Yawé Reya muxei kanaki'eriwame, kanipitɨani tɨɨri mɨwarayexeiyakɨ, Xakeri 'akuxi pɨkaniwewekai. ");
INSERT INTO hch_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Hikɨ Reya kaniutihukata, xeime 'ukitɨme kaniutiniweni Xuweni katiniterɨwa, mɨpaɨ 'utayɨka: «Yawé pɨnetsi'uxei kenemɨtinehiweriekai, hikɨrixɨa nekɨna pɨnetsinaki'erieka». ");
INSERT INTO hch_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Hutarieka kaniutihukata xeimetsiere 'ukitɨme kanayexeiya, Tsimehuni katiniterɨwa, mɨpaɨ 'utayɨka: «Yawé pe'enaxɨ, kename nekanaki'eriwa, 'ayumieme xeimeta pɨnetsiheyenɨ'airi nunutsi 'ukitɨme». ");
INSERT INTO hch_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Hairiekata kaniutihukata xeime nunutsi 'ukitɨme kanayexeiya, Rewi katiniterɨwa, mɨpaɨ 'utayɨka: «Hikɨrixɨari nekɨna netsinaki'erietɨ payani, yuhaikameri tɨɨri hetsiena mieme nemɨwarayexeikɨ». ");
INSERT INTO hch_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Nauriekata kaniutihukata Reya, xeime 'ukitɨme kaniutiniweni, Kura katiniterɨwa, mɨpaɨ 'utayɨka: «Hikɨ Yawé nekanitanɨawamɨkɨ». Mɨpaɨ tiuniweka tawarita pɨka'utiniwexɨ. ");
INSERT INTO hch_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Kepauka Xakeri tɨɨri mɨkawarayexeiyawekai Kakuwu hetsiemieme, yukuri kani'uxiwe'erikaitɨni, hikɨ Kakuwu mɨpaɨ katiniutahɨawe: —Neta keneneupitɨa tɨɨri nemɨwaraxeiyakɨ, xɨka pekanetsi'upitɨani, nepɨmɨni. ");
INSERT INTO hch_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Hikɨ Kakuwu kaniuyeha'ani waɨkawa, mɨpaɨ katinitahɨawe: —¿Ne Kakaɨyari peneti'erie? Mɨkɨ kanihɨkɨtɨni pekaniweweme mɨmatsi'ayeitɨa. ");
INSERT INTO hch_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Xakeri mɨpaɨ katinitahɨawe: —Mana puka neti'uximayaitsiriwame Wiriha, hamatɨana keneukahu'i. Kepauka meyexeiya netunutetɨa pihɨani, neta 'ana nepɨwarexeiyani tɨɨri mɨkɨ tiyurieyu. ");
INSERT INTO hch_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Hikɨ Xakeri Kakuwu kaniyetuirieni tiyu'uximayatsiriwame Wiriha 'ɨyaya mayanikɨ, Kakuwu hamatɨana kaniukahuni. ");
INSERT INTO hch_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","'Ana Wiriha kaniutihukata, xeime nunutsi mekanayexeiya Kakuwu matɨa. ");
INSERT INTO hch_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Xakeri mɨpaɨ kaniutayɨni: «Kakaɨyari nehetsiemieme 'aixɨa katiniuyurieni. Kenemɨtiyuhiweriekai kaneniu'enieni, xeime nunutsi kaneneyenɨ'airieni». 'Ayumieme Xakeri Rani katiniterɨwa. ");
INSERT INTO hch_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Tawarita Wiriha Xakeri parewiwameya, hutarieka kaniutihukata mekaneyexeiya xeime tawarita nunutsi 'ukitɨme Kakuwu matɨa. ");
INSERT INTO hch_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Xakeri mɨpaɨ kaniutayɨni: «Mariwemekɨ nepɨnemiene nekuri hamatɨa, hikɨ peru nepɨrayu'iwa». 'Ayumieme Xakeri Nepɨtahari katiniterɨwa. ");
INSERT INTO hch_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Reya timaitɨri tawarita mɨkatiniwekekaikɨ, tiyu'uximayatsiriwame Tsiripa Kakuwu kaniyetuirieni 'ɨyaya mayanikɨ, ");
INSERT INTO hch_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","mɨkɨta xeime mekanayexeiya nunutsi Kakuwu matɨa. ");
INSERT INTO hch_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Hikɨ Reya mɨpaɨ kaniutayɨni: «Nehetsie pɨreuyɨwe». 'Ayumieme Kahari pɨtiterɨwaxɨ. ");
INSERT INTO hch_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Hutarieka Tsiripa, Reya ti'uximayatameya, Kakuwu matɨa xeime nunutsi 'ukitɨme mekanayexeiya. ");
INSERT INTO hch_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Reya mɨpaɨ kaniutayɨni: «Waɨkawa nepɨnetemawie. 'Ukarawetsixi mɨpaɨ mepɨnetekɨhɨaweni pepɨ'atemawie». 'Ayumieme mɨkɨ 'Atsexi katiniterɨwa. ");
INSERT INTO hch_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Merikɨtsɨ tɨriku mati'itsanarɨwa tukariyaritsie, Xuweni kaneyani mɨrati'uximayatsiwatsie, mana 'ikwaxi kanetaxeiya manirakura, yumaama Reya kanetɨkirieni. Hikɨ Xakeri mɨpaɨ Reya katiniutahɨawe: —Neuxei, mɨkɨ manirakura keneneumikwa 'etsiwa 'aniwe mɨmatsi'atɨiri. ");
INSERT INTO hch_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Peru Reya mɨpaɨ katinita'eiya: —'A'iyari 'aixɨa kati'ane nekɨna pemɨnetsi'unawairi, 'akuxita hikɨ manirakura penetinawairiemɨkɨ neniwe mi'atɨa. Mɨpaɨ katinita'eiya Xakeri: —Xɨka penetsi'umini manirakura 'aniwe mi'atɨa hikɨ tɨkarikɨ Kakuwu 'ahamatɨa pɨkahuni. ");
INSERT INTO hch_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Hikɨ kepauka Kakuwu munua taikai, Reya kaneikunake mɨpaɨ katinitahɨawe: —Hikɨ tɨkarikɨ nehamatɨa pekanikahuimɨkɨ, ne 'akɨmana nekatiniupata 'ikwaxi manirakurakɨ neniwe mi'atɨa. 'Ana tɨkarikɨ kaniukahuni Kakuwu Reya matɨa. ");
INSERT INTO hch_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Kakaɨyari Reya kaniu'enieni, mɨkɨ kaniutihukata 'auxɨwirieka nunutsi 'ukitɨme Kakuwu matɨa mekaneyexeiya. ");
INSERT INTO hch_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Reya mɨpaɨ kaniutayɨni: «Kakaɨyari kanetiniupitɨani ti'uximayatame nekɨna nemuwitɨtɨakɨ». 'Ayumieme 'Itsakaxi katiniterɨwa. ");
INSERT INTO hch_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Tawarita Reya kaniutihukata, 'ataxewirieka nunutsi 'ukitɨme mekanayexeiya Kakuwu matɨa. ");
INSERT INTO hch_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Reya mɨpaɨ kaniutayɨni: «Kakaɨyari 'aixɨa pɨnetsi'uyuri 'aixɨa ti'aneme pɨnetiumi, hikɨri nekɨna 'aixɨa pɨnetixeiyani, 'ataxewirieka nunutsi temayexeikɨ». 'Ayumieme Tsawuruni pɨtiterɨwaxɨ. ");
INSERT INTO hch_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","'Imatɨrieka Reya xeime 'ukatɨme kanayexeiya Rina katiniterɨwa. ");
INSERT INTO hch_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Meta Kakaɨyari Xakeri kanaye'erieni, nenewierieya kaniu'enieni kanipitɨani mɨtiniwenikɨ. ");
INSERT INTO hch_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Hikɨ mɨkɨ kaniutihukata xeime 'ukitɨme kanayexeiya. Mɨpaɨ kaniutayɨni: «'Axanemɨkaramamatiwanikɨ pɨneranuyeitɨiri Kakaɨyari». ");
INSERT INTO hch_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","'Ayumieme Kutse pɨtiterɨwaxɨ, mɨpaɨ 'utayɨka: «Xɨka tɨma tiyɨwenike Yawé netsi'upitɨanike xeime tawarita nemɨtiniwenikɨ». ");
INSERT INTO hch_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Hikɨ 'ari Xakeri Kutse 'ayexeiyaku, Kakuwu Rawani mɨpaɨ katiniutahɨawe: —Keneneupitɨa nemɨyemiekɨ nekiepaitɨ. ");
INSERT INTO hch_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Keneneyetuiriri ne'ɨitama kɨmana nemɨmatiuta'uximayatsiri meta neniwema, keneneupitɨa nemɨyemiekɨ. 'Ekɨ pepɨtimate kenemɨti'uximayakai 'ahetsiemieme. ");
INSERT INTO hch_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Rawani mɨpaɨ katinita'eiya: —Neuxeitsɨ, pepɨkaheyeikani. Ne mɨpaɨ nepɨretima Yawé 'aixɨa pɨnetsiyurie, 'ekɨ penetsiparewiekaku. ");
INSERT INTO hch_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Mɨpaɨtatsiere katinitahɨawe: —'Ekɨ yakeneutayɨki kepaɨmeme pemeu'iwamɨkɨ, ne mɨpaɨ nepɨmatipitɨani. ");
INSERT INTO hch_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Kakuwu mɨpaɨ katinita'eiya: —'Ekɨ pepɨtimate kehepaɨ nemɨti'uximayakai, neyuhɨtɨatɨ kenemɨtiwa'ɨwiyakai 'atewama. ");
INSERT INTO hch_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Kepauka nekanuawekaku pemɨrexeiyakai pɨkatimɨirekai, hikɨri waɨkawa mepɨte'utamɨirixɨ, ne netiyurienekaku Yawé 'aixɨa pɨmatsiyurie. Hikɨri ne xaɨtsie nepɨtita'uximayata netɨɨriyama wahetsiemieme. ");
INSERT INTO hch_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Rawani mɨpaɨ katinita'iwawiya: —¿Kepaɨmeme pepau'iwamɨkɨ? Kakuwu mɨpaɨ katinita'eiya: —Pepɨkanetikupitɨwani. Xɨka 'ekɨ yapetiutanaki'erieni kenemɨmatitahɨawe, nekaniwa'ɨwiyakamɨkɨ 'amuxatsima. ");
INSERT INTO hch_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Hikɨ ne kepauka yunaime 'amuxatsima memuyenatɨkatsie nemuyeyani, 'ekɨ pepɨwaranuyeteɨxɨ memeuyɨyɨwi, memeukutuxa, meta tsipuri memeukɨyɨyɨwi memeukutuxa. Mɨkɨ nemɨwa'iwani mekanihɨkɨtɨkakuni. ");
INSERT INTO hch_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Hikɨ kepauka 'uxa'a pemɨnierimie keyupaɨmeme nemɨwara'iwaxɨri ke'aixɨa nemɨtiuka'iyari pekatinetimaimɨkɨ: Xɨka xeime pehetaxeiya muxa yatɨni tsipu kaheukɨyɨyɨwime kaheukutuxame meta muxa kaheuyɨwime tatsɨari ne nematsi'unawatsirieku. ");
INSERT INTO hch_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Rawani mɨpaɨ kaniutayɨni: —'Aixɨa pɨyɨni, yanepɨra'eriwa kepemaine. ");
INSERT INTO hch_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Hikɨ kwitɨwa mɨkɨ tukaritsie kaniwaranuyeteɨxɨ tsipuri 'ukitsi 'ukari, memeukuyɨyɨwi, memeuririnawi, yunaime kemɨ'ane 'etsiwa memeukutuxa, metatsiere yunaime muxatsi memeuyɨyɨwi, mɨkɨ yunaime kaniwaruhɨritɨani yuniwema. ");
INSERT INTO hch_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","'Ana Rawani kaneyani haika tukari heteewakaku Kakuwu manukateitsie yeyaka. Peru Kakuwu yaxeikɨa kaniwa'ɨwiyakaitɨni memuyuhayewaxɨ Rawani tewamama. ");
INSERT INTO hch_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Kakuwu meta haramu kaniutiwiteni yuyurime meta 'arimerituru metatsiere karu kɨyeyari, mɨkɨ kanikaxixiexɨani 'ukatuxatɨ kanayani. ");
INSERT INTO hch_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Mɨkɨ kɨyexi mɨxixiyatɨka kaniuka'uitɨani muxatsi wahareweme matinenieretsie 'auriena memɨtiharewenikɨ. Kepauka muxatsi 'ukari meyuweiyanɨatɨ mematiharewetsie mekani'axekaitɨni, ");
INSERT INTO hch_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","'ukitsi mekaniwarutiweweiyakaitɨni 'ukari mana kɨyexi mɨxixiyatɨka hɨxie, mɨpaɨ 'ana mekaniwarayexexeiyakaitɨni meheuririnawime, meheukutuxame, meheukuyɨyɨwime. ");
INSERT INTO hch_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Hikɨ Kakuwu xaɨtsie kaniwakupatakaitɨni memeuririnawi wahetsɨa, memeuyɨyɨwi Rawani muxatsimama wahetsɨa. Mɨpaɨ tiuyurieka yutewama warexeiyatɨ kanayani Rawani tewamama wahepaɨ meka'aneneme. ");
INSERT INTO hch_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Matsi kepauka muxatsi 'ukari memɨ'axekai 'amemɨpapa, Kakuwu kanika'uitɨwakaitɨni kɨyexi, hɨxiena memuyutiweiyakɨ. ");
INSERT INTO hch_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Peru kepauka memɨ'axekai memɨwawaki, 'ana pɨka'ika'uitɨwakai kɨyexi. Mɨkɨ memɨwawaki Rawani hetsɨa miemete mepɨhɨkɨtɨkai, memɨwaiyatɨkata Kakuwu hetsɨa miemete. ");
INSERT INTO hch_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Mɨpaɨ 'ana Kakuwu waɨkawa rexeiyatɨ kanayani, yuwaɨkawame muxatsi, te'uximayatamete 'ukitsi 'ukari, puxuri meta kameyutsixi. ");
INSERT INTO hch_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Hikɨ Kakuwu mɨpaɨ katiniuyumarieni kename Rawani niwemama mɨpaɨ me'utiyuanekai: «Kakuwu naime katinepiini tapaapa tewamama, piiniteyakɨ waɨkawa rexeiyatɨ kanayuyeitɨani». ");
INSERT INTO hch_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Yaxeikɨata Kakuwu katinetimani Rawani 'aixɨari mɨkatixeiyakaikɨ meripaitɨ kemɨkatixeiyakai. ");
INSERT INTO hch_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Hikɨ Yawé Kakuwu mɨpaɨ katiniutahɨawe: «Kenakunua 'apaapa kwieyatsie, hakewa 'a'iwama meme'uwa, ne 'ahamatɨa nepuyeikani». ");
INSERT INTO hch_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Hikɨ Kakuwu katiniutanɨ'ani yu'ɨitama Xakeri meta Reya wahekɨ, muxatsi mɨwarahɨnetsie paitɨ, ");
INSERT INTO hch_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","mɨpaɨ katiniwarutahɨawe: —Mɨpaɨ nepɨtimate xepaapa 'aixɨa pɨkanetixeiyari meripaitɨ hepaɨ. Peru tsepa, nepaapa Kakaɨyarieya pɨnetsiparewie. ");
INSERT INTO hch_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Xeme xekatenimaika kenemɨtiuta'uximayataxɨ xepaapa Rawani hetsiemieme neyutatuatɨ yuheyemekɨ. ");
INSERT INTO hch_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Peru mɨkɨ matsi mɨixa pɨnetsi'ukwamanaxɨ, waɨkawa 'ikupatatɨ ne'iwarika. Peru Kakaɨyari pɨka'ipitɨa 'axamɨnetsiyurienikɨ. ");
INSERT INTO hch_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Kepauka mɨpaɨ mɨnetikɨhɨawekai: «Yunaitɨ tewaxi memeupipitu 'a'iwarika mepakɨne», 'ana 'ukari yunaitɨ mepɨwatiniweyakai meheupipitume xeikɨa. Kepaukata mɨpaɨ mɨnetikɨhɨawekai: «Yunaitɨ tewaxi memeuririnawi 'a'iwarika mepakɨne», 'ana 'ukari yunaitɨ mepɨwatiniweyakai meheuririnawime xeikɨa. ");
INSERT INTO hch_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Mɨpaɨ Kakaɨyari xepaapa tewamamata katiniunawairieni, nepɨta kanetiniupitɨani. ");
INSERT INTO hch_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","»Merikɨtsɨ kepauka tewaxi mematiniweiyatsie 'ana mɨpaɨ nekatiniuheinɨni. 'Ukitsi mekaniwaweiyatɨwekaitɨni 'ukari, memeuririnawi meta memeupipitu. ");
INSERT INTO hch_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Mɨkɨ heinɨtsikatsie meta niuki tuayame Kakaɨyari hetsɨa mieme, mɨpaɨ kanetiniutahɨawe: “Kakuwu”. 'Ana mɨpaɨ nekatinita'eiya: “'Ena nepuyeika”. ");
INSERT INTO hch_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Hikɨ mɨkɨ mɨpaɨ kanetiniutahɨawe: “Paratsɨ keneuyɨ'ɨwiya, tuurutsixi 'ukari memɨwaweiyatɨwe mekaneuririnawini meta mekaneupipitɨni. Ne nepɨtimate kemɨmatsi'uyuri Rawani. ");
INSERT INTO hch_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ne Kakaɨyari nekanihɨkɨtɨni Weteri nemunehekɨataxɨ, hakewa mawari pemewewi nehetsiemieme tetetsie, meta kepemainekai nehɨxie. 'Ayumieme kenanukukexi 'ikɨ kwieyaritsie, kenemie kemɨ'ane kwieyaritsie pemetinuiwaxɨ”». ");
INSERT INTO hch_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Xakeri Reya matɨa mɨpaɨ mekatenita'eiya: —Tixaɨtɨri tame pɨkatatikupinierie tapaapa tahetsie timieme. ");
INSERT INTO hch_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Matsi mɨkatatsimateni hepaɨ pɨtatixeiya. Pɨtatsi'utua, mɨkɨ naimeri pɨtiutixɨtɨa tita mɨrakapitɨarie tahetsiemieme. ");
INSERT INTO hch_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Kaniyuritɨni Kakaɨyari naime mɨtinawairi tapaapa mɨrexeiyakai tahetsiemieme katinihɨkɨtɨni meta tatɨɨriyama wahetsiemieme. 'Ayumieme yaketineuyuri Kakaɨyari kemɨmarahɨawe. ");
INSERT INTO hch_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Hikɨ Kakuwu kaniyukuha'aritɨani, yuniwema yu'ɨitama kaniwaranutiyatsa kameyutsixi wahetsie. ");
INSERT INTO hch_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Yunaime tiwara'arietɨ yutewama Parani-'Arami mɨtiukaxeiyakai, mekanekɨne Kanani me'erietɨ, 'ukiyarieya 'Itsahaki manukateitsie. ");
INSERT INTO hch_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Mexi Rawani yumuxatsima warexinekai, Xakeri yapauka heyaka kaniwarunawani kakaɨyariximama. ");
INSERT INTO hch_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Mɨpaɨ katinikwamana Kakuwu Rawani 'arameu tewiyari, kaniuyuta'una 'atsikatitahɨaweka. ");
INSERT INTO hch_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Kakuwu kaneyani yunaime tiwara'arietɨ tita mɨrexeiyakai. 'Epɨrata hatuxameyaritsie 'uyeyaka, muhɨriyatsie Karaha kanitiyune. ");
INSERT INTO hch_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Hairieka tukari 'anukayaku Rawani katiniutaxatɨarieni, kename Kakuwu 'uyuta'unakai. ");
INSERT INTO hch_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Hikɨ Rawani kaniwarukuxeɨrieni yu'iwamarixi, mɨkɨ mekaniwaranukuweiya 'atahuta tukari mekaniuhukaitɨni, mekaniwaranuku'axeke Karaha hɨriyaritsie paitɨ. ");
INSERT INTO hch_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Perutsɨ mɨkɨ tɨkaritsie Kakaɨyari Rawani 'arameu tewiyari katiniutaxatɨani kutsukaku mɨpaɨ katinitahɨawe: «'Amarima 'aixɨa Kakuwu pepɨka'utate'ani». ");
INSERT INTO hch_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Rawani Kakuwu kaniwaranuku'axe Karaha hɨriyaritsie mɨkɨ mana me'uxipiekaku. Metatsiere Rawani mana kaniyuhayewa yu'iwama warawitɨtɨ. ");
INSERT INTO hch_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Mɨpaɨ Kakuwu katiniutahɨawe: —¿Kepetiuyuri 'aku? Pekanetiniu'itaiya, neniwema pekaniwareyewitɨni pɨretsutsixi wahepaɨ. ");
INSERT INTO hch_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","¿Ketitayari pereyetɨa 'atsipekaneretahɨaweka? Ne 'aixɨa 'anemekɨ nekamenetateutɨanikekaitɨni neyutemawietɨ ne xawererutsixi nepɨwareta'inienikekai. ");
INSERT INTO hch_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Tsikere neniwema nemɨwareti'itsenikekai pepɨkanetsihepitɨa meta neteukarima. Pemɨka'uka'iyarini hepaɨ pepeyɨ. ");
INSERT INTO hch_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Ne nekaniyɨweni nemɨtixe'utikwinitɨani, peru 'ikɨ tɨkaritsie 'apaapa Kakaɨyarieya pɨneretaxatɨa mɨpaɨ pɨneretahɨawixɨ: “'Amarima 'aixɨa Kakuwu pepɨka'utate'ani”. ");
INSERT INTO hch_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Mɨpaɨ nepɨretima 'apaapa manuyeikatsie peyeimɨtɨ pepɨyɨane, ¿peru ketitayari petiwarenawa nekakaɨyarixi? ");
INSERT INTO hch_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Kakuwu mɨpaɨ katinita'eiya: —Ne yemekɨ waɨkawa ne petima, mɨpaɨ nepɨre'eri ne'ɨitama penetsihenawairienike nepe'eriekai. ");
INSERT INTO hch_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Keniwarutiwawa 'akakaɨyarixi, kemɨ'ane pemɨtaxeirieni mɨkɨ ke'ukumawere. Ta'iwama memunenierixɨ mekanakɨnikuni: Ketineutiwawa tita mɨti'apiini, ketinapitɨ. Perutsɨ Kakuwu 'atsipɨkatimaikai, Xakeri Rawani kakaɨyariximama mɨwarenawakai, ");
INSERT INTO hch_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Hikɨ Rawani Kakuwu xamaruyata meri kaniuti'iwauni, kwitɨwata Reya xamaruyata meta memɨyuhuta te'uximayatamete 'ukarawetsixi waxamaruta, nitixaɨtɨ pɨkatiukaxei. Kepauka Reya xamaruyata mɨwayetɨa, Xakeri xamaruyata kaneutahani. ");
INSERT INTO hch_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Hikɨ Xakeri kakaɨyarixi kaniwaruti'awieta kameyu xirayatɨa, mɨpaɨ tiuyurieka waheima kanayerɨni. Rawani naime kaniu'iwauxiwiya, mɨkɨ pɨkawarutaxei. ");
INSERT INTO hch_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Hikɨ Xakeri yupaapa mɨpaɨ katiniutahɨawe: —Neuxeitsɨ, nepɨtikuye, nepaapa, 'ukarawetsixi ketemɨyɨtɨka mɨpaɨ nepɨ'ane, nepɨkayɨwe 'anemutakeni pepɨkaha'aka. Rawani kakaɨyarixi kaniwarutiwauni, peru pɨkawarutaxei. ");
INSERT INTO hch_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Merikɨtsɨ Kakuwu kaniuyeha'ani, Rawani hepaɨtsita mɨpaɨ katinenutahɨawixɨani: —¿Kekuta yemekɨ netiuyuri, xurikime nekapeutiwiwiexɨa, titayari mɨya petatiyuriene? ");
INSERT INTO hch_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Nepiinite naime pemɨtiutixei, ¿tita petiukaxei mɨti'apiini? Xɨka tixaɨtɨ petiutaxeiya, ta'iwama wahɨxie ketinekupini, mɨkɨ yameke'utiyuani kemɨ'ane tame temɨtahuta heitserie pexeiya. ");
INSERT INTO hch_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Xeitewiyari wiyari 'ahetsɨa nepuyeikakai, 'amuxatsima 'atsipurima hatsuaku mepɨka'anuye'ikwitɨaxɨa, nitɨma xeime muxa nepɨka'utakwai 'akurarutamieme. ");
INSERT INTO hch_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Xeime hatsuaku nepɨka'atɨa 'ɨrawe 'itexierieya, nepɨta nepɨrayukatuayakai mɨkɨkɨ. Yaxeikɨata hekɨta tɨkarikɨ memɨnawarietɨwekai 'ekɨ mɨkɨkɨ pepɨnetsiwiyakai. ");
INSERT INTO hch_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Tukarikɨ xɨrikɨ nepɨtiuka'eniwakai, tɨkarikɨ xerikɨ neputimɨmɨwekaitɨma, yemekɨ nepɨkatikukutsukai. ");
INSERT INTO hch_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Xeitewiyari wiyari 'akie nepuyuri, tamamata heimana nauka wiyari nepɨti'uximayakai 'aniwema wahetsiemieme, 'ataxewime wiyari 'atewama nepuwahɨkai, peru 'ekɨ mɨixa pepipataxɨ kenemɨti'iwakai. ");
INSERT INTO hch_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Xɨka nepaapa Kakaɨyarieya 'Itsahaki meyemakaxe, meta 'Apɨrahami Kakaɨyarieya, xɨka kanetsiparewiekake, 'ekɨ nemaweme pekanenanunɨ'anikekaitɨni. Kakaɨyari pɨnetsi'uxei kenemɨtiuka'eniwakai neti'uximayatɨ, 'ayumieme takai tɨkarikɨ kename ne heitserie nehexeiya putayɨ. ");
INSERT INTO hch_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Rawani Kakuwu mɨpaɨ katiniuta'eiya: —'Ikɨ 'ukari mepɨneniwema, 'ikɨ temari mepɨneteukarima, muxatsitsiere mepɨnetewama, tita pemɨrexeiya nepiini pɨtihɨkɨ naitɨ. ¿Ketsukuta newaruyurieni 'ikɨ neniwema neteukarima? ");
INSERT INTO hch_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Matsi tɨratu tepɨwewieni 'ekɨ matɨa ne, mɨkɨ tɨratu teme'eriwanikɨ mɨpaɨ temɨtemaikakɨ. ");
INSERT INTO hch_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Hikɨ Kakuwu tete 'anukutuka 'akanitakeni 'inɨari hepaɨ, ");
INSERT INTO hch_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","mɨpaɨ katiniwarutahɨawe yu'iwama: —Tetexi xekeneukuxeɨri. Mɨkɨ mepititɨkixɨa, 'axeikɨa mepikuxeɨri, mana mepɨte'ukwai, tetexi makuxeɨrietsie. ");
INSERT INTO hch_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Mana Rawani Yekaxi-Tsaruta katiniuterɨwa meta Kakuwu Karaha katiniterɨwa. ");
INSERT INTO hch_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Rawani mɨpaɨ kaniutayɨni: —'Ikɨ tetexi 'ena mukuxeɨrie teme'eriwanikɨ pɨ'inɨaritɨni. 'Ayumieme mana Karaha pɨtiuterɨwarɨwakai, ");
INSERT INTO hch_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","metatsiere Mitsipa pɨtiuterɨwarɨwakai, Rawani mɨpaɨ mutayɨkɨ: —Yawé ketatsixeiyani kepauka tahamatɨa temɨka'u'uwanitsie tame teyuhutatɨ. ");
INSERT INTO hch_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Xɨka 'ekɨ neniwema 'axapewareyurieneni, xɨka hipame pɨta pewaretiwitɨni 'ukari, kena'eriwani Kakaɨyari yapɨretima, tsepa xewitɨ tawarita mɨkatatsixeiya. ");
INSERT INTO hch_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Rawani tetexi 'itɨiyatɨ mɨpaɨ kaniutayɨni: —Keneuxeiya tetexi mukuxeɨrie meta tete temikake. ");
INSERT INTO hch_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Mɨkɨ ya'ane mepɨmaika kename 'ekɨ meta ne 'ena teka'anuyekɨkani 'axatetatiyuriexɨanike. ");
INSERT INTO hch_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","'Apɨrahami Kakaɨyarieya meta Nakuxi Kakaɨyarieya ta'itsɨkame kehɨkɨtɨni. Hikɨ Kakuwu 'aixɨa kaniutayɨni Kakaɨyari hepaɨtsita paapaya 'Itsahaki mimakaxekai hetsie. ");
INSERT INTO hch_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Hikɨ mawari kaniuwewieni yemuri 'amanutitewatsie paitɨ, yu'iwama waruta'inieka yunaitɨ memɨtehekwanikɨ. Yunaitɨ mete'ukwakari, mana mekanitiheteitɨni. ");
INSERT INTO hch_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","'Uxa'arieka ximeripaitɨ Rawani 'anukukeka, yuteukarima kaniwaruti'itseni Yawé wawirietɨ 'aixɨa mɨwayuriekakɨ meta yuniwema, hikɨ nakunuani yukie. ");
INSERT INTO hch_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Merikɨtsɨ Kakuwu kanayeyani kemɨtimiekai, 'umiekaku mekanenukunake niuki tuayamete Kakaɨyari hetsɨa miemete. ");
INSERT INTO hch_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Kakuwu waruxeiyaka mɨpaɨ kaniutayɨni: «'Ena xɨari Kakaɨyari manuka pɨti'ane». 'Ayumieme mana Makanahini pɨtiuterɨwaxɨ. ");
INSERT INTO hch_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Hikɨ Kakuwu kaniwarenɨ'ani yuteɨterima 'Etsahu hetsɨa, Tsehixi kwieyaritsie paitɨ, 'Erumi mɨrakutewatsie. ");
INSERT INTO hch_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Mɨpaɨ katiniwarutahɨawe mɨpaɨ memɨteheitahɨawekɨ: «Neti'aitɨwame 'Etsahu, mati'uximayatsiriwame Kakuwu, pɨtatsiheyenɨ'a mɨpaɨ tematetaxatɨanikɨ mɨkɨ Rawani kie pekatei kemɨreuterixɨ, ");
INSERT INTO hch_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","hikɨ pɨwarexeiya wakaitsixi, puxuri, muxatsi, te'uximayatamete 'ukitsi 'ukari. Mɨpaɨ pɨreyenɨ'a, 'aixɨa 'anemekɨ pemitakwewiekakɨ». ");
INSERT INTO hch_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Kepauka teɨterimama memakunuaxɨa, Kakuwu mɨpaɨ mekateniutaxatɨani: «'A'iwa 'Etsahu tepɨtehetaxatɨa, 'upamie pɨmatsihanakimie nauka tsienituyari wara'inietɨ yuteɨterima». ");
INSERT INTO hch_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Kakuwu waɨkawa kanekamatɨyani yu'iyaritɨatɨ. 'Ayumieme yuteɨterima muwarawitɨkɨkai hixɨapa kaniwatsana, yaxeikɨata kaniwarukuxeɨrieni muxatsi, wakaitsixi, kameyutsixi, ");
INSERT INTO hch_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","mɨpaɨ tiu'erieka: «Xɨka 'Etsahu warutakwini hipame, hipatɨ xeikɨa mepɨyuta'una». ");
INSERT INTO hch_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Hikɨ Kakuwu 'ayumieme kaniuyutanenewieni: «Yawé neteukari 'Apɨrahami meta nepaapa 'Itsahaki wakakaɨyari pemɨhɨkɨ, mɨpaɨ pemɨnerahɨawekai nekehakunuanike nekie ne'iwama wahetsɨa, meta kename penetsiparewiekakekai: ");
INSERT INTO hch_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","ne xɨari mati'uximayatsiriwame heitserie nepɨkahexeiya 'aixɨa pemɨnetixeiyanikɨ pemɨnetsiparewiekaku. Kepauka Kurutani hatuxameyaritsie nemanatɨa tixaɨtɨ nepɨkarexeiyakai ne'itsɨ xeikɨa nepakwekai, peru hikɨ hutakɨa mepukutei neteɨterima. ");
INSERT INTO hch_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Kenenewikweitsitɨaka ne'iwa 'Etsahu netsi'umienikɨ nepeuma 'ukarawetsixi warukwini meta tɨɨri. ");
INSERT INTO hch_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","'Ekɨ mɨpaɨ pepɨnetiutahɨawixi kename penetsiparewiekakekai, kename nexiɨyarima yumuiretɨ mehakɨnekekai, xiekari haramara tetsita mɨtixeɨrie mɨkayu'inɨatsinɨa hepaɨ». ");
INSERT INTO hch_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Mɨkɨ tɨkaritsie Kakuwu mana puyuhayewaxɨ, kepaɨmeme mɨrexeiyakai katiniwaranuyeteɨxɨ yu'iwa 'Etsahu mɨtiminikɨ, ");
INSERT INTO hch_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","huta tsienituyari tsipuri 'ukari, xeitewiyari tsipuri tuurutsixi, huta tsienituyari muxatsi 'ukari meta xeitewiyari muxatsi 'ukitsi, ");
INSERT INTO hch_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","xeitewiyari heimana tamamata kameyutsixi 'ukari meniwetɨkaime, huta tewiyari wakaitsixi, tamamata tsikerutsixi xeiwiyari mehɨtɨkaime, xeitewiyari puxuri 'ukari meta tamamata puxuri 'ukitsi. ");
INSERT INTO hch_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Hikɨ kaniwaruhɨritɨani yuxexɨime te'uximayatamete mɨpaɨ katiniwarutahɨawe: «Xeme xekenanuyeyaxi xete'u'arietɨ perutsɨ yunaitɨ xeka'uhutɨ yaxe'ayuxeiyatɨ». ");
INSERT INTO hch_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Manuyehaitɨanikekai mɨpaɨ katiniuhɨritɨani: «Kepauka mɨmatsihanukunake ne'iwa 'Etsahu, xɨka matsiheta'iwawiya, kemɨ'ane hetsɨa pepɨmieme, hakewa pepeutɨa, kemɨ'ane mepɨtehatewama 'ikɨ pemɨwara'arie, ");
INSERT INTO hch_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","mɨpaɨ pepɨreita'eiya: “'Ikɨ 'imikieri 'ahetsie pɨtimieme neti'aitɨwame 'Etsahu, Kakuwu mati'uximayatsiriwame pɨmatsiheyenɨ'airi yutewama wahetsie waranuyeteɨxɨka, mɨkɨtatsiere ta'utɨma kanamieni”». ");
INSERT INTO hch_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Kakuwu yaxeikɨata katiniuhɨritɨani hutarieka mieme, meta hairieka mieme, yaxeikɨa yunaime katiniwarutahɨawe tewaxi memuwaru'ariekai. Mɨpaɨ katiniwarutahɨawe: «Kepauka 'Etsahu xemanukunake mɨpaɨ xekateneitahɨawikuni, ");
INSERT INTO hch_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","mɨpaɨtatsiere xekateneitahɨawikuni: “Mati'uximayatsiriwame Kakuwu ta'utɨma 'ukanamieni”». Mɨpaɨ pɨtiku'eriwakai Kakuwu: «'Imikierikɨ meri nekaninɨtɨamɨkɨ, 'ariketa ne kanenanukunakimɨkɨ heiwatɨ 'aixɨa netiutahɨawe». ");
INSERT INTO hch_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Hikɨ mɨpaɨ 'imikieri meri katinenɨ'ani, Kakuwu 'akuxi mana puyuhayewaxɨ mɨkɨ tɨkaritsie mematitekaitsie. ");
INSERT INTO hch_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Hikɨ mɨkɨ tɨkaritsie Kakuwu kaniuyukuha'aritɨani, yu'ɨitama meta memuyuhuta te'uximayatamete, meta tamamata heimana xewi wara'inietɨ yuniwema, haa 'etsimɨpetsie mekaniukɨne Kawuki mɨrayetewatsie. ");
INSERT INTO hch_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Hikɨ kepauka muwaranutua, yutewama yupiinite naime katinanutuanita, ");
INSERT INTO hch_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","hikɨ yuxaɨtame kaniuyuhayewa. 'Ana xewitɨ tewi kanitamieni kaniukatare 'imienekaku. ");
INSERT INTO hch_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Kepauka 'iya tewi mɨpaɨ mɨretima Kakuwu mɨkaha'iwakaikɨ, teurieya mɨtiwayewiyatsie kanitahutsuni, 'anari kaniwayexɨne 'uti'ɨtsaiwatɨ kanayani meyukwitɨwekaku. ");
INSERT INTO hch_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Hikɨ tewi mɨpaɨ katinitahɨawe: —Keneneutatua, 'ari pɨkahekɨarirɨme. Kakuwu mɨpaɨ katinitahɨawe: —Kepaukake 'aixɨa pemɨnetsiyurieni 'anake nepɨmatsitatuani. ");
INSERT INTO hch_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Tewi mɨpaɨ katinita'iwawiya: —¿Kepetitewa? —Kakuwu nepɨtitewa —katinita'eiya. ");
INSERT INTO hch_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Hikɨ tewi mɨpaɨ katinitahɨawe: —Kakuwu pepɨkatitewakari, 'Ixaheri pɨta, Kakaɨyari pemutamikɨ meta teɨteri, pemɨrayu'iwakɨ. ");
INSERT INTO hch_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Kakuwu mɨpaɨta katinita'iwawiya: —'Ekɨta, ¿kepetitewa? Tewi mɨpaɨ kaniutayɨni: —¿Titayarikuta penetiku'iwawiya kenemɨtitewa? Mana kwitɨwa 'aixɨa kaniyurieni. ");
INSERT INTO hch_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Hikɨ Kakuwu mana Penuheri katiniuterɨwa, mɨpaɨ 'utayɨka: «Kakaɨyari nierikaya nepuxei, 'ayɨwekatɨka nepayeyuri 'akuxi». ");
INSERT INTO hch_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Tau panatine Penuheri 'uyemiekaku Kakuwu. Mutiteurimɨrariekaikɨ 'uti'ɨtsaiwatɨ kaneyani. ");
INSERT INTO hch_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","'Ayumieme 'ixaheritsixi wai teuri mɨrawiyatsie mieme mepɨkakwa'a, Kakuwu mana mutahutsunariekɨ. ");
INSERT INTO hch_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Kepauka Kakuwu 'Etsahu muxei 'a'amiekame teɨteri nauka tsienituyari warawitɨkɨme, yu'ɨitama waniwema me'ayenaukame kaniwarayeitɨani Reya, Xakeri meta te'uximayatamete memuyuhuta. ");
INSERT INTO hch_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Mɨkɨ 'ukarawetsixi memuyuhuta te'uximayatamete kaniwaranuyeyatsa yuniwemakame, wa'utɨmata Reya yuniwemakame, 'imatɨrieka Xakeri yuniwe Kutse matɨa. ");
INSERT INTO hch_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Hikɨ Kakuwu meri nanuyeyerɨni, 'atahutamexɨa 'umietɨ kananakatutsitakaitɨni kwiepa paitɨ yu'iwa 'anukunakirɨmetɨ. ");
INSERT INTO hch_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Peru 'Etsahu kaniutanautsa 'enukunakeke, 'itapaka kani'itseni. Hikɨ yuhutatɨ mekaniutitsuani. ");
INSERT INTO hch_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Kepauka 'Etsahu 'ukarawetsixi mɨwaruxei meta tɨɨri, mɨpaɨ katiniuta'iwauni: —¿Kemɨ'aneta 'ikɨ mepɨyɨa, memɨmatsi'aweiya? Kakuwu mɨpaɨ katinita'eiya: —Mɨkɨ tɨɨri mepɨhɨkɨ Kakaɨyari ti'a'uximayatsiriwame meyenɨ'airi. ");
INSERT INTO hch_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Mɨkɨ yuhutatɨ te'uximayatamete 'ukarawetsixi 'amenakɨne yuniwema mewaruwitɨtɨ 'Etsahu hɨxie mekanakatutsitaxɨani. ");
INSERT INTO hch_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Kwitɨta Reya meta niwemama yaxeikɨata mekaniuyɨni, 'imatɨrieka Kutse Xakeri matɨa yaxeikɨata mekaniutihɨxima'uni. ");
INSERT INTO hch_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","'Etsahu mɨpaɨ katiniuta'iwauni: —¿Kepaɨtɨtɨri mɨkɨ tewaxi pemɨnetsihenɨ'airi? Kakuwu mɨpaɨ katinita'eiya: —Kɨmana 'aixɨa pemɨneranunakekɨ nepɨtiuyuri. ");
INSERT INTO hch_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","'Etsahu mɨpaɨ kaniutayɨni: —Neuxeitsɨ, nemuta, matsi neta waɨkawari nepɨrexeiya. Ketinapitɨ 'apiinite. ");
INSERT INTO hch_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Kakuwu mɨpaɨ kaniutayɨni: —Neuxeitsɨ hawaikɨ, xɨkari 'aixɨa 'anemekɨ penetsi'utahɨawe, ketineutanaki'eri tita nematimikwa. 'Aixɨa 'anemekɨri pekaneniutahɨawe, 'anierika nexeiyatɨ Kakaɨyari nemɨxeiyani hepaɨ nekatinimaika. ");
INSERT INTO hch_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Ketineutanaki'eri 'imikieri nemɨmati'atɨiri. Kakaɨyari 'aixɨa pɨtiuka'iyari nehetsiemieme, waɨkawa matsi nepɨrexeiya tita nemɨreuyehɨwa. Mɨya tikɨhɨawetɨ Kakuwu 'ameteneutere, 'imatɨrieka 'Etsahu yakatiniutanaki'erieni. ");
INSERT INTO hch_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","'Arikekeri 'Etsahu mɨpaɨ katinitahɨawe: —Kɨmɨtsɨari tekaniyehuni, ne nekamenanuteɨtamɨkɨ. ");
INSERT INTO hch_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Peru Kakuwu mɨpaɨ kaniutayɨni: —Neuxeitsɨ, nematsika meta neti'aitɨwame, tɨɨri mepɨka'ɨkɨniwawe meta muxatsi wakaitsixi meputiniwexɨa, nepɨwata'ɨwiya. Xɨka xeiya neware'arieni yunaitɨ xeitukaritsie mepɨkwini. ");
INSERT INTO hch_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","'Ayumieme peuyewetse pemanuyeyerɨni mati'uximayatsiriwame hɨxie, ne'anɨkai nepɨyemie netewama wahamatɨa meta tɨɨri, Tsehixi paitɨke tekaneyukaxeiyakuni. ");
INSERT INTO hch_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","'Etsahu mɨpaɨ kaniutayɨni: —'Aixɨa kani'aneni, peru neteɨterima nekaniwaku'eirimɨkɨ yayupaɨmeme memɨmatsi'anuteɨtakɨ. Kakuwu mɨpaɨ katinita'eiya: —Neuxeitsɨ pepɨka'a'iyaritɨaka, matsi 'aixɨa 'anemekɨri tepuyutahɨawixɨ, mɨkɨ matsi waɨkawa peuyewekai. ");
INSERT INTO hch_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Mɨkɨ tukaritsie kwitɨwa 'Etsahu kanakunuani Tsehixi paitɨ. ");
INSERT INTO hch_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Kakuwu, kaneyani Tsukuti 'erietɨ, mana kaniuyutakitɨani meta kuraru kaniutiwewieni yutewama wahetsiemieme. 'Ayumieme mana pɨtiuterɨwarie Tsukuti. ");
INSERT INTO hch_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Kepauka Kakuwu makunua Parani-'Arami, 'aixɨa 'anemekɨ meta 'aixɨa reu'erietɨ Tsikeni kiekariyaritsie kaninuani, Kanani kwieyaritsie, mɨkɨ hɨxie kaniutayerɨni. ");
INSERT INTO hch_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Hikɨ xeitsienituyari pɨrata tuminiyarikɨ kwie kaniunaneni, Kamuxi niwemama kaniwarunanairieni Tsikeni paapaya mana kaniyutaxamarutɨani. ");
INSERT INTO hch_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Metatsiere mana mawari taiyame kaniutawewieni, 'Eruhe-'Ixaheri katiniterɨwa. ");
INSERT INTO hch_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Merikɨtsɨ Rina Kakuwu niweya Reya hetsie meyexei, hipame 'ukarawetsixi kaniwareku'iwata mana kiekatari. ");
INSERT INTO hch_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Kepauka mixei Tsikeni, Kamuxi nu'aya, heweu tewiyari, mana mɨtiwa'aitɨakai, 'iwiyaka waɨriyarika 'ipitɨatɨ hamatɨana kaniukahuni kaninanaimani. ");
INSERT INTO hch_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Mɨya 'iyuriekaketa kanitihiwe'erieni 'aixɨa katinixeiyakaitɨni pitiwitɨnikekai. ");
INSERT INTO hch_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Hikɨ yupaapa mɨpaɨ katiniutahɨawe: «Mɨkɨ 'uka keneutawawa ne'ɨya mayanikɨ». ");
INSERT INTO hch_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Hikɨ Kakuwu mɨpaɨ katinetimani kename Tsikeni nu'aya Rina 'unanaimakai, 'atsipɨka'utayɨ niwemama yeuta meme'uwakaikɨ tewaxi metewarehɨtɨwetɨ, me'u'axɨakuke katiniwarutaxatɨani. ");
INSERT INTO hch_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Hikɨ Kamuxi Tsikeni paapaya, Kakuwu hetsɨa kaneyani hamatɨana titaxatake. ");
INSERT INTO hch_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Kepauka Kakuwu niwemama memu'axɨa mekateniutamarieni kemɨtiɨyɨkai, pɨkawarunakixɨ waɨkawa meha'atɨ mekaniuyuhayewa. Tsikeni waɨkawa 'axakatiniuyuriekaitɨni 'Ixaheri hepaɨtsita niweya munanaimakɨ, pɨkaheuyewekai matsi mɨpaɨ mɨtiyurienikɨ. ");
INSERT INTO hch_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Kamuxi peru mɨpaɨ katiniwarutahɨawe: —Neniwe Tsikeni xe'iwa 'uka kanihiwe'erieka. Neuxeikuta xekeneupitɨa memuyutiwitɨnikɨ. ");
INSERT INTO hch_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Tepɨtatimareta. Taniwema mepuyuwitɨtɨweni. ");
INSERT INTO hch_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Mɨpaɨ xepɨteyuhayewani xeme tahamatɨa, 'ikɨ kwie xehetsiemieme pɨhɨkɨtɨni 'ena xekeneu'uwani kemɨtixenake xete'uximayatɨ, meta kwie xekeneukukurarutɨiyaxɨa. ");
INSERT INTO hch_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Hikɨ Tsikeni mɨpaɨta katiniwarutahɨawe Rina 'iwamama meta paapaya: —Xɨka xeme xenetsi'utanaki'erieni, ne nepɨtixepitɨani tita xemɨnetetawawirieni. ");
INSERT INTO hch_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Xepɨyɨwawe tita xemɨnete'utawawirieni kɨmana, meta 'imikieri nemɨtixeminikɨ, peru yemekɨ xekeneneupitɨa 'uka ne nemɨtiwitɨnikɨ. ");
INSERT INTO hch_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Hikɨ wa'iwa Rina munanaimariekɨ, Kakuwu niwemama mekaniwaruta'eiya kwamanarikakɨ Tsikeni meta paapaya Kamuxi. ");
INSERT INTO hch_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Mɨpaɨ mekateniwarutahɨawe: —Tame tepɨkayɨwawe mɨpaɨ temɨte'uyurieni. Xɨka ta'iwa teyetuani xeime xitekiya 'inɨariyari kahexeiyame hetsɨa tepɨtatewiyatsitɨani tame. ");
INSERT INTO hch_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Ketemɨtexetahɨawe xɨka mɨpaɨ xe'uyɨni 'ana yatepɨtetanaki'erieni: yunaitɨ xeme 'ukitsi xitekiya 'inɨariyari xekeneuyuwewiri tahepaɨ xemɨ'anenenikɨ. ");
INSERT INTO hch_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","'Anake taniwema temɨwatawitɨtɨwani kaniyɨwemɨkɨ, xehamatɨa temɨtiteni xeikiekariyari temɨhɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Mexɨka yaxekate'utanaki'erieni xitekiya xeka'uyuwewirieni, ta'iwa te'awitɨtɨ tame tekaniyehuni. ");
INSERT INTO hch_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Kamuxi Tsikeni matɨa yameteniutanaki'erieni kememutiyua, ");
INSERT INTO hch_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Tsikeni kwitɨwa kaniuyu'inɨaritɨani Kakuwu nu'aya kwiniemieme mɨtinaki'eriekaikɨ. Tsikeni waɨkawa 'iwamama memei'eniekaikɨ, ");
INSERT INTO hch_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","paapaya Kamuxi kaneiteɨta kiekari kitenie paitɨ, mana mekateniutixata kiekatari wahamatɨa. Mɨpaɨ mekateniwarutahɨawe: ");
INSERT INTO hch_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","—'Ikɨ teɨteri 'aixɨa mepɨtekahu mepɨhamikutsixi. Xekeniwarupitɨa takwieyaritsie memu'uwanikɨ, mekete'uximayaka 'ena, 'apakuyewakuta wahetsiemieme. Meta tame tepɨyɨwaweni temɨwatiwitɨni waniwema, mɨkɨta taniwema. ");
INSERT INTO hch_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Mɨkɨ yamepɨteha'eriwa tahamatɨa memuyuhayewakɨ xeikiekariyari temakɨnekɨ, xɨka yatetekakɨne kememaitɨka: xɨka teyunaitɨ 'ukitsi xitekiya 'inɨariyari te'uyuwewirieni, mɨkɨ kememɨte'uhu. ");
INSERT INTO hch_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Hikɨmɨtɨka yatepɨtekakɨne, tahamatɨa memuyuhayewanikɨ. Mɨpaɨ wawakaitsixi naime tita memɨtehexeiya tapiini mepɨtehɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Yunaitɨ kiekari kitenie memuyuxeɨriekai, yameteniutanaki'erieni Kamuxi meta nu'aya Tsikeni kememaitɨkatei, 'ana yunaitɨ 'ukitsi mekaniu'inɨaritɨarieni xitekiyakɨ. ");
INSERT INTO hch_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Hairieka tukaritsie, 'ukitsi 'akuxi mete'ukakukuinekaku, yuhutatɨ Kakuwu niwemama Tsimehuni Rewi matɨa, Rina matsikamama, yu'ixipara me'u'ɨtɨ kiekaritsie mekanekɨne, 'ukitsi memuyeheitɨkateitsie mekayɨ'ɨwiyatɨ, yunaime mekaniwarukwini. ");
INSERT INTO hch_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Kamuxi meta nu'aya Tsikeni mekaniumieni, Rina Tsikeni kiita mewayehanaka mekanekɨne. ");
INSERT INTO hch_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Hikɨ hipatɨta Kakuwu niwemama mekaniu'axɨani, mɨkite watsata me'utakɨneka, kiekaritsie naime wapiini mekatene'arieni wa'iwa munanaimariekɨ. ");
INSERT INTO hch_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Yupiini mekatenayeitɨani wamuxatsima, wawakaitsixima, wapuxurima, naime tita kiekaritsie mɨtiyepikai meta tita memɨte'ekai. ");
INSERT INTO hch_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Naime mekatenepini tita memɨtehexeiyakai, meta waniwema wa'ɨitamata naime mekateniunawani kiita mɨrayepitɨkatei. ");
INSERT INTO hch_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Hikɨ Kakuwu mɨpaɨ katiniwarutahɨawe Tsimehuni Rewi mame: —Waɨkawa 'uximatɨarika xepɨnetsiheutiwiwiriexɨa. Hikɨ 'ena mɨtiyehane kananeutsixi, peretseutsixi, 'enakiekatari yunaitɨ, menetsi'aye'unietɨ mepakɨne. Xɨka mɨkɨ me'uyukuxeɨrieni menetsi'utamieni, mepɨnetsimieni netɨɨriyama yunaime mepɨwakwini, waɨkawa teɨteri nepɨkawarexeiya. ");
INSERT INTO hch_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Peru mɨkɨ mɨpaɨ mekatenita'eiya: —Kamɨtsɨ tete'ihayewakekai tsepa 'iya ta'iwa tuminikɨ muyumayɨinɨa hepaɨ mɨranuyemienikɨ. ");
INSERT INTO hch_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Merikɨtsɨ Kakaɨyari Kakuwu mɨpaɨ katiniutahɨawe: «Kenemie, Weteri kenekani. Mana mawari taiyame kenetawewi nehetsiemieme hakewa pemɨnetsihexei mana pe'uyemietɨ 'Etsahu hekɨ pe'uyu'unarɨmetɨ». ");
INSERT INTO hch_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Hikɨ Kakuwu mɨpaɨ katiniwarutaxatɨani yutɨɨriyama meta hamatɨana memu'uwakai: «Xekeniwaruhayewa hipame wakakaɨyarixi yuhetsɨa xemɨwarexeiya, xekeneuyu'iti, hipame pɨta yu'ixurikite xeketenanakatɨxɨa. ");
INSERT INTO hch_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Weteri paitɨ tekaniyehuni. Mana tenari mawari taiyame nekanetawewimɨkɨ Kakaɨyari hetsiemieme mɨnetsi'uparewi ne'uweiyariekaku, huyeta nehamatɨa mumie». ");
INSERT INTO hch_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Hikɨ Kakuwu mekateniyetuirieni yukakaɨyarixi memɨwarexeiyakai, yunakɨtsate yunakatesie memanuyewutɨakai, Kakuwu katiniukateuku xiu hetɨa Tsikeni hehurakaku muwekai. ");
INSERT INTO hch_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Kepauka memekɨ, nixewitɨ pɨkawaranukuwei Kakuwu tɨɨriyamama, waɨkawa memutimamakaikɨ kiekari mamanetɨkatsie. ");
INSERT INTO hch_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Mɨpaɨ tiɨyɨku Kakuwu 'Arimetɨra maku'u kaninuani, tatsɨari Weteri, meta memeweiyakai yunaitɨ, Kanani kwieyaritsie. ");
INSERT INTO hch_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Mana mawari taiyame kaniutawewieni, meta Weteri katiniuterɨwa, mana matsiɨkɨme mayuyeitɨakɨ Kakaɨyari kepauka 'Etsahu hekɨ muyu'unarɨmekai. ");
INSERT INTO hch_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Hikɨ 'ana Rewura kaniumɨni, Xeweka mɨ'ɨwiyakai, xiu manuwe hetɨa mekanikateuku Weteri 'aurie. 'Ayumieme Kakuwu mana 'Eruni-Wakuti katiniuterɨwa. ");
INSERT INTO hch_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Kepauka Kakuwu Parani-'Arami heyeyaka munua, hutarieka Kakaɨyari matsiɨkɨme kanayuyeitɨani 'aixɨa kaniyurieni, ");
INSERT INTO hch_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","mɨpaɨ tikɨhɨawetɨ: «Kakuwu pepɨtitewa, hikɨri mɨpaɨ pepɨkatitewaka. 'Ena mɨtiyehane 'Ixaheri pepɨtitewaka pɨta». Mɨpaɨ katiniterɨwa. ");
INSERT INTO hch_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Tawarita Kakaɨyari mɨpaɨ kaniutayɨni: «Ne Kakaɨyari Naimekɨmɨtɨrɨkaɨye nekanihɨkɨtɨni. Kenexiɨka kene'amɨiriyani. 'Ahetsie mepɨyekɨne yumɨiretɨ 'anuiwarima xeikɨa, manata te'aitamete mepɨtixuawere. ");
INSERT INTO hch_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","'Apɨrahami meta 'Itsahaki kwie nemɨwarumi 'ekɨ nepɨmatsiyetuirie meta 'anuiwarima». ");
INSERT INTO hch_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Hikɨ Kakaɨyari Kakuwu hamatɨa tiutaxataka kaneyani. ");
INSERT INTO hch_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Kakuwu mana tete kaniutakeni hakewa Kakaɨyari hamatɨa mɨretixa. Mɨkɨ tete kaxie winuyarikɨ kanika'ɨya meta huriwa hatseitiyari kanikawirieni, ");
INSERT INTO hch_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","hakewa Kakaɨyari Kakuwu metahɨawixɨ Weteri katiniuterɨwa. ");
INSERT INTO hch_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Hikɨ 'arike Weteri mekaniyekɨne. 'Epɨrata 'akuxi 'ahetewakaku Xakeri kaniutiniweni, waɨriyarika nunutsi kanayexeiya. ");
INSERT INTO hch_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Kwiyɨanekaku niwenetɨ, tiniweritsitɨwame mɨpaɨ katinitahɨawe: «Pepɨkamaka, tawarita xeime nunutsi 'uki pekanayexeiyarɨmeni». ");
INSERT INTO hch_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Perutsɨ mɨkɨ mɨximetɨ, 'imatɨrieka yuniwe Wenuní katiniuterɨwa, peru paapaya Wenikamini pɨta katiniterɨwa. ");
INSERT INTO hch_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Mɨpaɨ Xakeri katiniumɨni, 'Epɨrata huyeyari 'utɨa mekanikateuku, hikɨ Wereni mɨrakutewatsie. ");
INSERT INTO hch_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Memekateukixɨtsie Kakuwu 'inɨari kaniutakeni, hikɨ 'akuxi peyuhekɨa hakewa Xakeri mekateukie. ");
INSERT INTO hch_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","'Ixaheri yuhuyeta kaneyani hikɨ Mirari-'Eraxi manunieretsie kaniutayerɨni. ");
INSERT INTO hch_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Mɨkɨ kwieyaritsie mekutetɨ, Xuweni Wiriha hamatɨa kaniukahuni, yupaapa 'ɨyaya hamatɨa. Kepauka 'Ixaheri mɨretima waɨkawa kaniuyeha'ani. Kakuwu tamamata heimana yuhutame kaniwarutinuarieni: ");
INSERT INTO hch_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Reya niwemama mepɨhɨkɨ: Xuweni, Kakuwu matɨarieya matɨa, Tsimehuni, Rewi, Kura, 'Itsakaxi meta Tsawuruni. ");
INSERT INTO hch_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Xakeri niwemama mepɨhɨkɨ: Kutse meta Wenikamini. ");
INSERT INTO hch_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Wiriha niwemama mepɨhɨkɨ Xakeri parewiwameya: Rani meta Nepɨtahari. ");
INSERT INTO hch_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Tsiripa niwemama mepɨhɨkɨ Reya parewiwameya: Kahari meta 'Atsexi. 'Ikɨ mepɨhɨkɨ tɨɨri Kakuwu mɨwarayexei Parani-'Arami kwieyaritsiepai. ");
INSERT INTO hch_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Kakuwu yupaapa kie kanakunuani Mamɨre, Kiriati-'Ariwa 'aurie, Hewuruni mɨrakutewatsiere, 'Apɨrahami meripaitɨ manuyeikakai meta 'Itsahaki. ");
INSERT INTO hch_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","'Itsahaki xeitsienituyari heimana nauka tewiyari wiyari kanexeiyakaitɨni kepauka mumɨ. ");
INSERT INTO hch_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Waɨkawa 'ukiratsitɨtɨ kaniɨyɨni, niwemama 'Etsahu, Kakuwu 'ukiyarimama wahamatɨa mekanikateuku. ");
INSERT INTO hch_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Merikɨtsɨ 'ikɨ mepɨhɨkɨ 'Etsahu nuiwarimama, meta 'Erumi mɨtitewakaita. ");
INSERT INTO hch_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","'Etsahu, 'ukari Kanani kiekatari pɨwarutiwitɨ: 'Ara kaniutiwitɨni 'Eruni niweya Heti tewiyari, 'Ahuriwama kaniutiwitɨni 'Ahana niweya Tsiwehuni teukarieya heweu tewiyari, ");
INSERT INTO hch_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","meta Watsemati kaniutiwitɨni 'Itsimaheri niweya Newayuti taruya. ");
INSERT INTO hch_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","'Ikɨ mepɨniwemama 'Etsahu: 'Ara hamatɨa kaneyexeiya 'Eripaxi. Watsemati hamatɨa kaneyexeiya Xehueri. ");
INSERT INTO hch_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","'Ahuriwama matɨa mekaniwarayexeiya Kehutsi, Karani meta Kure. 'Ikɨ tɨɨri 'Etsahu muwarayexei mekanihɨkɨtɨni Kanani kwieyaritsie 'uyeikatɨ. ");
INSERT INTO hch_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Hikɨ 'arikeke 'Etsahu kaneyani yu'ɨitama yuniwema meta yunaime teɨteri memiparewiekai warawitɨtɨ, yutewama wara'arietɨ naime yupiinite Kanani kwieyaritsie mɨtiukaxeiyakai, xeime kwieyaritsie kaniuyupata Kakuwu hamatɨa mɨka'uyeikanikɨ. ");
INSERT INTO hch_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Yuhutatɨ waɨkawa mepɨtehexeiyakai yupiinite 'ayumieme mepɨkayɨwawekai 'axeikɨa memukuteni, 'ɨxa pumawekai watewama wahetsiemieme. ");
INSERT INTO hch_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Mɨpaɨ katininuani 'Etsahu, metatsiere 'Erumi mɨtitewakai, hɨritsie Tsehixi kwieyaritsie. ");
INSERT INTO hch_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","'Ikɨ mekanihɨkɨtɨni 'Etsahu nuiwarimama, 'erumitsixi wa'ukiyari, hɨritsie Tsehixi kwieyaritsie memɨtamarixɨ. ");
INSERT INTO hch_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Waniwema mɨpaɨ mekatenitetewakaitɨni: 'Eripaxi 'Ara nu'aya, 'Etsahu 'ɨyaya, Xehueri Watsemati nu'aya, 'Etsahu 'ɨyaya. ");
INSERT INTO hch_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","'Eripaxi niwemama mekanakɨne: Temani, 'Umaxi, Tsepuhu, Katani meta Kenatsi. ");
INSERT INTO hch_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","'Eripaxi yutuxeri Timina hamatɨa xeime kanayexeiya nunutsi 'Amareki katiniterɨwa. Mɨkɨ yunaitɨ 'Ara teukarimama mekanakɨne, 'Etsahu 'ɨyaya. ");
INSERT INTO hch_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Xehueri niwemama mekanakɨne: Nakati, Tsera, Tsama meta Mitsaha. 'Ikɨ Watsemati teukarimama mekanihɨkɨtɨni, 'Etsahu 'ɨyaya. ");
INSERT INTO hch_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Hipatɨta 'Etsahu niwemama 'Ahuriwama hetsiemieme, 'Ahana niweya Tsiwehuni teukarieya, mekanihɨkɨtɨni: Kehutsi, Karani meta Kure. ");
INSERT INTO hch_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","'Ikɨ memanuyetei mekanakɨne 'Etsahu nuiwarimama wahetsie: 'Eripaxi 'Etsahu matɨarieya nuiwarimama memanuyetei mepakɨ: Temani, 'Umaxi, Tsepuhu, Kenatsi, ");
INSERT INTO hch_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Kure, Katani meta 'Amareki. 'Ikɨ memanuyetei mekanakɨne 'Eripaxi nuiwarimama wahetsie 'Erumi kwieyaritsie, mɨkɨ yunaitɨ 'Ara teukarimama xeikɨa mepɨhɨkɨtɨkai. ");
INSERT INTO hch_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","'Etsahu nu'aya Xehueri niwemama, memanuyetei mekanakɨne Nakati, Tsera, Tsama meta Mitsaha. 'Ikɨ memanuyetei mekanakɨne Xehueri nuiwarimama wahetsie 'Erumi kwieyaritsie, yunaitɨ mɨkɨ Watsemati teukarimama mekanihɨkɨtɨkaitɨni, 'Etsahu 'ɨyaya mɨhɨkɨtɨkai. ");
INSERT INTO hch_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","'Ahuriwama niwemamata 'Ahana niweya, 'Etsahu 'ɨyaya, memanuyetei mekanakɨne Kehutsi, Karani meta Kure. ");
INSERT INTO hch_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","'Ikɨ 'Etsahu nuiwarimama mepakɨ, metatsiere 'Erumi mɨtitewakai, meta yuxexuitɨ nuiwarite wahetsie memanuyetekai. ");
INSERT INTO hch_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","'Ikɨ Tsehixi nuiwarimama mekanihɨkɨtɨni hureu tewiyari, mana memɨtamakai: Rutani, Tsuwari, Tsiwehuni, 'Ahana, ");
INSERT INTO hch_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Ritsuni, 'Etsexi meta Ritsani. 'Ikɨ Tsehixi nuiwarimama wahetsie memanuyetei mekanakɨne hureutsixi wahetsie 'Erumi kwieyaritsie. ");
INSERT INTO hch_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Rutani niwemama mekanakɨne: Huri, Humani matɨa. Rutani xeime yu'iwa 'uka kanexeiyakaitɨni Timina titewakame. ");
INSERT INTO hch_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Tsuwari niwemama mepɨhɨkɨ: 'Ariwani, Manakati, 'Ewari, Tsepuhu meta 'Unami. ");
INSERT INTO hch_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Tsiwehuni niwemama mepɨhɨkɨ: 'Ayaha meta 'Ahana. 'Ikɨ 'imatɨrieka mieme haa xɨkame mutaxei kanihɨkɨtɨni makumawetsie hetineikatɨkaime, yupaapa puxurimama wahɨnetɨ Tsiwehuni. ");
INSERT INTO hch_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","'Ahana niwemama mepɨhɨkɨ: Ritsuni meta 'Ahuriwama, 'Ahana niweya. ");
INSERT INTO hch_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Ritsuni niwemama mepɨhɨkɨ: Hemɨrani, 'Etsiwani, 'Itɨrani meta Kerani. ");
INSERT INTO hch_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","'Etsexi niwemama mepɨhɨkɨ: Wirani, Tsawani meta 'Akani. ");
INSERT INTO hch_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Ritsani niwemama mepɨhɨkɨ: 'Utsi meta 'Arahani. ");
INSERT INTO hch_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Hureutsixi wa'ukiyarima mepakɨ Rutani, Tsuwari, Tsiwehuni, 'Ahana, ");
INSERT INTO hch_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Ritsuni, 'Etsexi meta Ritsani. Mɨkɨ yuxexuitɨ yunuiwari hetsie memanuyetei mepakɨ Tsehixi kwieyaritsie. ");
INSERT INTO hch_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","'Ixaheritsixi te'aitamete mekawarexeiyakaku 'akuxi, 'ikɨ mepanuka'ui 'Erumi kwieyaritsie: ");
INSERT INTO hch_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Wera Wehuxi nu'aya 'Erumi katiniuta'aita. Kiekarieya Rinawa katinitewakaitɨni. ");
INSERT INTO hch_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Kepauka Wera mumɨ, hetsienamieme katiniuta'aita Kuwawi Tsera nu'aya, Wutsira meyeyakai. ");
INSERT INTO hch_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Kepauka Kuwawi mumɨ, hetsienamieme katiniuta'aita Kutsani Temani kiekame. ");
INSERT INTO hch_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Kepauka Kutsani mumɨ hetsienamieme katiniuta'aita Harari Werari nu'aya. Mɨkɨ mariyanitsixi mɨwara'iwaxɨ Muhawi kwieyaritsie. Kiekarieya 'Awiti pɨtitewakai. ");
INSERT INTO hch_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Kepauka mumɨ Harari, hetsienamieme katiniuta'aita Tsamɨra, Matsireka kiekariyaritsie kiekame. ");
INSERT INTO hch_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Kepauka mumɨ Tsamɨra, hetsienamieme katiniuta'aita Tsahuri, 'aki Xekuwuti manuyeka kiekame. ");
INSERT INTO hch_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Kepauka mumɨ Tsahuri, hetsienamieme katiniuta'aita Wahari-Kanani 'Akuwuxi nu'aya. ");
INSERT INTO hch_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Kepauka Wahari-Kanani mumɨ 'Akuwuxi nu'aya, hetsienamieme katiniuta'aita Hara. Kiekarieya katinitewakaitɨni Pahu. 'Ɨyaya katinitewakaitɨni Mehitaweri, Matereri kaninu'ayatɨni, Metsawi teukarieya. ");
INSERT INTO hch_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Mɨpaɨ mepɨtetetewakai me'anuyetetɨmemakɨ 'Etsahu nuiwarimama, yuxexuitɨ yutɨɨriyama mewarexeiyatɨ meta yukwie: Timina, 'Ariwa, Keteti, ");
INSERT INTO hch_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","'Ahuriwama, 'Eraha, Pinuni, ");
INSERT INTO hch_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenatsi, Temani, Miwitsaxi, ");
INSERT INTO hch_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Makirieri meta 'Irami. 'Ikɨ mepɨhɨkɨ memanuyeyaxixɨ 'Erumi kwieyaritsie, kememɨte'ukutetɨkatei. 'Ikɨ 'Etsahu 'erumitsixi wa'ukiyari kanihɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Merikɨtsɨ Kakuwu Kanani kwieyaritsie kaniukateitɨni, 'ukiyarimama memakutekaitsie, peru mana mepɨkakiekataritɨkai 'akuxi. ");
INSERT INTO hch_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","'Ikɨ pɨhɨkɨ 'ɨxatsi yuri maine, yaxeikɨata Kakuwu, tɨɨriyamama wahepaɨtsita kemɨtiuyɨ. Merikɨtsɨ kepauka Kutse tamamata heimana 'atahuta wiyari mɨhɨkai, yu'iwama kaniwaparewienekaitɨni, Wiriha Tsiripa watɨɨriyama, muxatsi wahɨiyarikɨ. Mɨkɨ Kutse yupaapa katinikuxaxatɨwakaitɨni 'iwamama 'axakememɨteyuriekai. ");
INSERT INTO hch_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","'Ixaheri matsi waɨkawa Kutse kaninaki'eriekaitɨni ke hipame 'iwamama, 'ukiratsitɨtɨ meyexeikɨ. 'Ayumieme kamixa 'atewime witsi'aneme pita'aitsiri. ");
INSERT INTO hch_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Hikɨ 'iwamama me'ixeiyatɨ paapaya kemɨtinaki'eriekai, matsi waɨkawa mekani'uxiwe'eriekaitɨni ni tɨma 'aixɨa mepɨkate'ikuhɨawekai. ");
INSERT INTO hch_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Merikɨtsɨ heiwa Kutse tiuheinɨka, yu'iwama katiniwarutaxatɨani. 'Ana matsi waɨkawa mekaniti'uxiwe'erietɨkɨne, ");
INSERT INTO hch_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","mɨpaɨ mɨtiwarutaxatɨakɨ: —Xekeneneu'eni nepɨtixetaxatɨani kenemɨreheinɨ. ");
INSERT INTO hch_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Hikɨ tɨriku tenehɨatɨwekaitɨni mɨrati'uximayatsiwatsie. Yapauka ne nemenahɨa 'akaniutakeni, xemeta xemenahɨaxɨa 'auriena 'u'axɨaka hɨxiena kaniukahɨxima'uni. ");
INSERT INTO hch_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","'Iwamama mekanita'eiya: —Mɨpaɨ xɨari pepɨtiku'eriwa, 'ekɨ petatita'aitɨanike pepɨ'a'erie petatsitanɨ'anike. Hikɨ matsi waɨkawa mekaniuyeha'ani heinɨtsika hepaɨtsita mɨtiwarutaxatɨakɨ. ");
INSERT INTO hch_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Merikɨtsɨ hutarieka katiniuheinɨni, tawarita katiniwarutaxatɨani. Mɨpaɨ katiniwarutahɨawe: —Tawarita mɨpaɨ nepɨreheinɨ. Tau, metseri, tamamata heimana xewi xurawetsixi nehɨxie mekaniukahɨxima'uni. ");
INSERT INTO hch_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Kepauka mɨpaɨ mɨtiwarutahɨawixɨ, paapaya mɨpaɨ katinitatieni: —¿Kehepaɨtɨtɨri 'ekɨ pepɨreheinɨ? ¿Kamɨtsɨ ne, 'amaama, 'a'iwama tanaitɨ 'ahɨxie tetekahɨxima'uni? ");
INSERT INTO hch_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","'Iwamama waɨkawa mepihekakai, paapaya matsi pɨta puyu'iyaritɨakai naime mɨkɨ hepaɨtsita. ");
INSERT INTO hch_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Merikɨtsɨ Kutse 'iwamama mekanekɨne, yupaapa muxatsimama metewareumiyuka Tsikeni paitɨ. ");
INSERT INTO hch_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Hikɨ 'Ixaheri Kutse mɨpaɨ katiniutahɨawe: —'A'iwama keniwaxeiyamie, muxatsi memɨwarahɨtɨwetsie Tsikeni paitɨ mepekutei. Kutse mɨpaɨ katinita'eiya: —'Aixɨa pɨ'ane. ");
INSERT INTO hch_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Tawarita katinitaxatɨani paapaya: —Naime pepɨnetitaxatɨani 'a'iwama kememɨteheu'erie, meta xɨka muxatsi mewarehɨtɨweni, mɨpaɨ nemɨretimanikɨ hekwamekɨ. Hikɨ kaneyani. Hewuruni 'uyeyaka Tsikeni neta'ani. ");
INSERT INTO hch_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Xewitɨ tewi kanenukunake yeuta 'uyeikakaku kawataxeiyawekaku. Mɨkɨ mɨpaɨ katinita'iwawiya: —¿Tita petiwaune? ");
INSERT INTO hch_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Kutse kanita'eiya: —Ne'iwama nepɨwawaune. ¿'Ekɨ pekatimate hakewa memɨtehehɨtɨwe? ");
INSERT INTO hch_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Mɨkɨ tewi mɨpaɨ katinitaxatɨani: —Takai 'atupaitɨ mepekɨ, nepɨwaru'eni mɨpaɨ mepɨtekuxatakai kename Rutani kiekariyaritsie meyehukai. Hikɨ Kutse waruwauximetɨ kaneyani, Rutani 'aurie kaniwarutaxeiya. ");
INSERT INTO hch_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Hikɨ 'iwamama mekanixeiya 'ateewa 'amiekaku kuxi. Mexi kata'awekai mekaniuyu'enieni kememɨte'imienikɨ. ");
INSERT INTO hch_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Mɨpaɨ meteniyukuxaxatɨwakaitɨni yuxexuitɨ: —Mana pamie mɨtiheinɨwe. ");
INSERT INTO hch_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Hikɨrixɨa tukarieya kanaye'ani. Tekanimiekuni xeime putsu muyewakita tekaneikahɨakuni, mɨpaɨ tekanetiyuakuni kename tiyukwa'ame 'itakwai. Mɨpaɨ tepɨtehetimani xɨka 'aku heinɨtsieya yuritɨni. ");
INSERT INTO hch_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Hikɨ kepauka Xuweni mɨwaru'eni yu'iwama, yu'iwatsie tanuanike memɨka'ikumemiwanikɨ, mɨpaɨ katiniwarutahɨawe: —Matsi tepɨka'ikumemiwani. ");
INSERT INTO hch_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Putsu muyewakita xeikɨa xekeneukahɨwa makumawetsie, xepɨka'ikumemiwani, xepɨkate'ikwinitɨaka. Xuweni mɨpaɨ pɨtiwarutahɨawixɨ 'arike Kutse watihanake 'iyetuanike paapaya hetsɨa. ");
INSERT INTO hch_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Kepauka Kutse yu'iwama wahetsɨa muta'a, mekaniwiya kamixaya witsimɨ'ane 'amɨmamatetɨtɨ mekaniutatsana. ");
INSERT INTO hch_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","'Anari meheihanaka putsu muyewakita mekaneikahɨani. ");
INSERT INTO hch_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Hikɨ mekateniukwani. Yareutewikaku mekaniwaruxeiya harerutsixi tenawemete 'itsimaheritsixi teɨteriyari, Karaha memayenexɨa. Kameyutsixi wahetsie mepɨte'a'ikatakai witsimu'ɨa waritsamu mixaxi meheituanike 'Ekipitu. ");
INSERT INTO hch_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Merikɨtsɨ Kura mɨpaɨ katiniwarutahɨawe yu'iwama: —¿Tita teteha'iwa xɨka ta'iwa te'umieni 'atsiteka'utiyuani? ");
INSERT INTO hch_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Matsi 'aixɨa katiyɨni 'itsimaheritsixi teɨteriyari xɨka tewarutuirieni muta'iwakɨ. 'Iwamama yamepɨte'utanaki'eri kemainekai, ");
INSERT INTO hch_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","'ayumieme kepauka wahetsɨa memu'axɨa harerutsixi mariyanitsixi, yu'iwa Kutse putsuta mekanewatihana 'itsimaheritsixi mekaniwarutuirieni xeitewiyari pɨrata tuminiyarikɨ. Mɨpaɨ tiunanaiyaka 'Ekipitu kanewitɨkieni Kutse. ");
INSERT INTO hch_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Hikɨ Xuweni nuaka putsu muyewakita, yu'iwa kaniwatihanakekaitɨni. Meukanierixɨ Kutse puyemawekai. Hikɨ yukamixa neukatsana, mɨpaɨ mɨtimatsiɨkɨnikɨ kename yuhiwerie waɨkawa. ");
INSERT INTO hch_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Hikɨ yu'iwama wahetsɨa kaneyani mɨpaɨ katiniwaretahɨawe: —Temaikɨ peuyemawe. Hikɨta, ¿keri nehaineni? ");
INSERT INTO hch_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Hikɨ Kutse kamixaya me'utihurieka, tsipu me'umieka mekanitaxurimani. ");
INSERT INTO hch_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Hikɨ hipame mekaniwarenɨ'ani kamixa me'ahuriekame yupaapa hetsɨa, mɨpaɨ memɨteheitahɨawekɨ: «'Ikɨ 'aniwe katikamixaya tekaneitaxeiya». ");
INSERT INTO hch_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Kepauka Kakuwu kamixa metima mɨpaɨ kaniutayɨni: «Mɨkɨ pɨhɨkɨ neniwe kamixaya. Kauka tiyukwa'ame neitakwai». ");
INSERT INTO hch_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Hikɨ Kakuwu hiwerikakɨ yukamixa kaneukatsana, mɨyuhiwerie hepaɨ katiniuyukemaritɨani, mɨixa pɨyuhiweriekai yuniwekɨ. ");
INSERT INTO hch_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Hikɨ yunaitɨ niwemama mekanikɨnɨtɨwakaitɨni peru mɨkɨ pɨkayɨnɨtɨarinɨakai mɨpaɨ 'utaitɨ: «Hawaikɨ, ne nepɨkahetɨmaiya hetsɨana neheta'ameke mɨkite watsata». Mɨpaɨ 'utaitɨ pɨkatihayewakai yuhiwerietɨ Kutse ha'eriwatɨ. ");
INSERT INTO hch_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Merikɨtsɨ harerutsixi mariyanitsixi Kutse mekaniutuani, 'Ekipitu paitɨ Putipaxi hetsɨa, Parahuni parewiwameya kaninaneni kuyaxi wa'ukiyari mɨtiwa'aitɨwametɨkai. ");
INSERT INTO hch_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Merikɨtsɨ Kura yu'iwama waruku'eirieka kaneyani xaɨtsie paitɨ. Xeime kie kaniutayerɨni Hiraxi titewakame hetsɨa, 'Arurani kiekame hetsɨa. ");
INSERT INTO hch_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Mana Kura 'uka kaniutiwitɨni Tsua titewakame niweya kananeu tewiyari. Kepauka hamatɨana mukahui ");
INSERT INTO hch_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","mɨkɨ kaniutihukata 'ukitɨme kaniutiniweni, 'Exi katiniterɨwa. ");
INSERT INTO hch_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","'Ariketa hutarieka kaniutihukata 'ukitɨmetsiere kaniutiniweni, 'Unani katiniterɨwa. ");
INSERT INTO hch_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Tawarita 'arike xeime nunutsi mekanayexeiya 'ukitɨme, Ketsiwi kiekariyaritsie mutinuiwaxɨ, Tseraxi katiniterɨwa. ");
INSERT INTO hch_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Hikɨ Kura 'uka kaniutawauni Tamaxi titewakame 'Exi, yuniwe 'amɨyumate hetsiemieme. ");
INSERT INTO hch_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Matsi Yawé pɨka'inakixɨ Kura nu'aya kemɨtiyurienekai, kaninawairieni tukarieya. ");
INSERT INTO hch_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Hikɨ Kura yuniwe 'Unani mɨpaɨ katiniutahɨawe: «'A'iwa wiuraya keneutiwitɨki, 'aitsika kemaine kwetsikatsiemieme kenaye'atɨa, mɨpaɨ 'amatsika niweya payeneni». ");
INSERT INTO hch_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Perutsɨ 'Unani pɨtimaikai nu'aya mɨtinuiwakekai nu'aya pɨka'ayanikekai. 'Ayumieme kepauka mikumaɨwakai puyu'ɨwiyakai 'ɨyaya mɨkatihukatanikɨ. Mɨpaɨ pɨtiyurienekai matsikaya nu'aya mɨkatinuiwakɨ. ");
INSERT INTO hch_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Hikɨ Yawé pɨka'inakixɨ mɨyamɨtiyurienekaikɨ, 'ayumieme yaxeikɨa kanimieni. ");
INSERT INTO hch_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Merikɨte Kura yumu'e mɨpaɨ pɨtiutahɨawixɨ: «'Apaapa kie pewiuratɨtɨ kene'ahayewani, kepaukake neniwe Tseraxi 'amuyutamani». Peru Kura mɨpaɨ pɨtiku'eriwakai Tseraxi mɨnike pɨ'eriekai, yumatsikama wahepaɨ. Hikɨ Tamaxi kaneyani yupaapa kie mekanikɨ. ");
INSERT INTO hch_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Hikɨ mɨixa tukari 'anuyeyaku Kura 'ɨyaya kaniumɨnita Tsua niweya. Hikɨ hiwerika hatɨmaiyaka, kaneyani Kura Timinati kiekariyaritsie yumuxatsi waretixinike. Hamikuya kaneiweiya Hiraxi mɨtitewa 'Arurani kiekame. ");
INSERT INTO hch_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Kepauka Tamaxi mɨretima kename mu'eya Timinati heyakai yumuxatsima wareuximieka, ");
INSERT INTO hch_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","wiura kamixayari kananutihɨna, yɨhɨxie kaneuyukunani kapa xewitɨ heitimanikɨ, kiekari 'Enahini manuyeniere mɨranuyekɨkatɨretsie kanayerɨni, Timinati huyeyari manuyehane kiekari mukumatsie. Mɨpaɨ kaniuyɨni, mɨpaɨ mɨtimaikaikɨ Tseraxi 'amuyumaikaikɨri memɨka'iwitɨtɨawekaiku kɨnaya mayanikɨ. ");
INSERT INTO hch_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Kepauka Kura heuyuku'eimame muxei, 'uka tuminikɨ muyumayɨinɨa kani'eriekaitɨni. ");
INSERT INTO hch_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Yumu'e ka'erietɨ hepana kaneyani, mɨpaɨ katinitahɨawe: —'Ahamatɨa nepɨkahuni pekati'awaɨriya. 'Uka mɨpaɨ katinita'iwawiya: —¿Tita penetipitɨani, xɨka ne'unewaɨriya? ");
INSERT INTO hch_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Kura mɨpaɨ katinita'eiya: —Xeime tsipu nunutsi nepɨmatsihanɨ'airieni nekuraruta mieme. 'Ukata mɨpaɨ katinitahɨawe: —'Aixɨa kani'aneni. Peru hikɨ mexixi tixaɨtɨ kenetineupitɨa yanemɨtimaikakɨ kename 'aku penetipitɨani. ");
INSERT INTO hch_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Kura mɨpaɨ katinita'iwawiya: —¿Ketitakuta pereuyehɨwa nemɨreukapine? Tamaxi mɨpaɨ katinita'eiya: —Kena 'atseyu wiwierimakame meta 'a'itsɨ pemakwe'e. Kura katiniyetuirieni, hamatɨana kaniukahuni, mɨkɨ kanitihukatɨani. ");
INSERT INTO hch_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Tamaxi kepauka manukuke kaneyani yapauka, yuhɨxie meuyukunakai kaneuyukuyepieni, wiura kamixayari kananakatɨni. ");
INSERT INTO hch_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","'Ariketa Kura tsipu kanenɨ'ani, yuhamiku 'Arurani kiekame kaniutanɨ'ani mɨrewayepinikɨ tita mɨreku'eiriekai, hikɨ hamikuya 'uka pɨkahetaxei. ");
INSERT INTO hch_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Merikɨte teɨteri mana kiekatari kaniwaruta'iwawiya: —¿Hakewari 'uka tuminikɨ muyumayɨinɨa 'Enahini kiekame huye tetsita mutiyeixakai? Mɨkɨ mɨpaɨ mekatenita'eiya: —'Ena 'ukaratsi muyumayɨinɨa mɨtiwawa yukakaɨyarixi wahetsiemieme matsi pumawe. ");
INSERT INTO hch_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Hamikuya kanakunuani hakewa Kura meyeikakai, mɨpaɨ katinitahɨawe: —Nepɨkaheitaxei. Teɨteri mana kiekatari mɨpaɨ mekanaitɨkani, kename mana 'umawe 'ukaratsi mɨpaɨ tiuka'iyaritɨ. ");
INSERT INTO hch_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Kura mɨpaɨ kaniutayɨni: —Tsepa mɨrepi nepiinite, ne nepɨkatiu'ita. Heitseriemekɨ pɨtihekɨa teɨteri 'axamemɨkahaitɨkanikɨ nehepaɨtsita: Ne nepeinɨ'airi tsipu, 'ekɨta pepɨkaheitaxei. ");
INSERT INTO hch_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Haika metseri 'anukayaku, Kura mɨpaɨ katiniutahɨawarieni: —'Amu'e Tamaxi tuminikɨ muyumayɨinɨa kanayuyeitɨani, mɨyayɨanetɨ kaniutihukata. Kura mɨpaɨ karima kaniutayɨni: —Xekenewayehani xekenetataiya. ");
INSERT INTO hch_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Hikɨ kepauka mɨwayehaniwakai yumu'e hetsɨa xeime kanenɨ'ani mɨpaɨ haineme: «'Ikɨ piinite kutsiyari pɨnetsi'utihukatɨa. Heiwatɨ peheitimani kemɨ'ane 'ikɨ tseyu yuwiwierimakame mukutsiyarieya meta 'ikɨ 'itsɨ». ");
INSERT INTO hch_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Kura retimaika mɨpaɨ kaniutayɨni: «Ne kenemɨtikamie, matsi mɨkɨ 'aixɨa katinikamieni, ne neniwe Tseraxi nemɨka'iwitɨtɨakɨ». Peru tawarita hamatɨana pɨka'ukahui. ");
INSERT INTO hch_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Kepauka maye'a mɨtiniwekɨ Tamaxi, yuhutame kaniwarayexeiya. ");
INSERT INTO hch_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Xewitɨ katinuiwawetɨ 'akuxi, mamaya meri kananeni, hikɨ 'ukaratsi tiniweritsitɨwame, wita xetame mamayatsie kaneitapirieni, mɨpaɨ kaniutayɨni: «'Ikɨ meri kaniutinuiwa». ");
INSERT INTO hch_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Hikɨ nunutsi yumama kaneutahana, xewitɨ pɨta meri kaniutinuiwa 'iwaya. Hikɨ 'ukaratsi tiniweritsitɨwame mɨpaɨ kaniutayɨni: «Kehepaɨ peretɨa». 'Ayumieme Paretsi mepɨte'iterɨwaxɨ. ");
INSERT INTO hch_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Mɨkɨ 'utɨaketa 'iwaya kaniutinuiwa, yumamatsie wita xetame meutapiekai, mɨkɨ Tsera mekateniterɨwa. ");
INSERT INTO hch_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Merikɨtsɨ kepauka mewitɨkie Kutse 'Ekipitu, 'Itsimaheri nuiwarimama mekanituani Putipaxi hetsɨa, xeime 'ekipitutanaka Parahuni parewiwameya kuyaxi wa'ukiyari hetsɨa. ");
INSERT INTO hch_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Hikɨ matsi Kutse 'aixɨa katini'uximayakaitɨni Yawé 'iparewiekaku. Kepauka 'ekipitutanaka ti'aitɨwameya hetsɨa mayekatei, ");
INSERT INTO hch_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","mɨkɨ mɨpaɨ pɨretima Yawé miparewiekaikɨ waɨkawa 'aixɨa mɨtiyurienenikɨ. ");
INSERT INTO hch_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Hikɨ Putipaxi Kutse 'aixɨa katiniumani 'aixɨa mɨtiuka'iyarikaikɨ, 'ayumieme katinihɨritɨani naime yupiinite meta kiena mɨti'aitanikɨ kanipitɨani. ");
INSERT INTO hch_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","'Ekipitutanaka kepauka Kutse mɨtiɨhɨritɨa yukie timieme, Yawé 'aixɨa katiniyuriekaitɨni 'ekipitutanaka Putipaxi tita mɨrexeiyakai hetsiemieme takwana timieme meta kiita. ");
INSERT INTO hch_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","'Ayumieme Putipaxi matsi Kutse naime katiniuhɨritɨani, tixaɨtɨkɨ pɨkatiyu'iyaritɨakai pɨtiutikwa'akai xeikɨa. Kutse matsi witsipɨtiyuxexeiyakai pɨtemaikɨtɨkai. ");
INSERT INTO hch_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Hikɨ 'arikeke ti'aitɨwameya 'ɨyaya kanitixeiyatɨyani 'ihiwe'erietɨ, mɨpaɨ katinitahɨawe: —Nehamatɨa keneukahu'i. ");
INSERT INTO hch_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Kutse kayuwaɨriyatɨ, mɨpaɨ katinitahɨawe: —Neuxei 'ukaratsi: neti'aitɨwame netsinaki'erietɨ pɨnetiuhɨritɨa, yupiinite yukie timieme naime mɨkareukweriwayuriekakɨ. ");
INSERT INTO hch_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","'Ikɨ kiita xewitɨ pumawe 'aixɨa tiuka'iyaritɨ mɨhɨritɨariekakɨ nehepaɨ. Neti'aitɨwame tixaɨtɨ pɨkanetikweririe. 'Ekɨ pemɨ'ɨyaya, xɨka nematsi'ukumayɨani, 'axanepɨtiyurieni Kakaɨyari hɨxie. ");
INSERT INTO hch_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Matsi mɨkɨ tukarikɨ nikuxeiyanekaitɨni yaxeikɨa tikɨhɨawetɨ. Peru Kutse kaniyuku'imawakaitɨni. ");
INSERT INTO hch_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Merikɨtsɨ xeime tukaritsie, kiita Kutse kaneutahani yukuha'aritɨanike kemɨtihɨritɨariekai, mexi me'uyemawekai te'uximayatamete hipatɨ. ");
INSERT INTO hch_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Hikɨ Putipaxi 'ɨyaya manayuku'eimatsie kanikawiere. Mɨpaɨ katinitahɨawe: «Nehamatɨarikɨ keneukahu'i». Perutsɨ Kutse manayuku'eimakai 'uku'eirieka takwa kananuyeyani. ");
INSERT INTO hch_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","'Ukaratsi 'ixuriki 'uxeiyaka Kutse miku'eiriekai, ");
INSERT INTO hch_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","kiita te'uximayatamete kaniwarutahiwieni, mɨpaɨ katiniwarutahɨawe: «Neuxei, nekɨna 'ikɨ hepɨrayu tewiyari mɨtatsi'atɨiri, mɨtatsinanaimanikɨ xeikɨa punua. Nekiita 'atahaka nehamatɨa puhuimɨkɨkai, peru ne karima neputahiwaxɨ. ");
INSERT INTO hch_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Kepauka ne'utahiwakaku mɨnetsi'u'eni kaniuyuta'una, yu'ixuriki 'uku'eirieka ne'aurie». ");
INSERT INTO hch_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Hikɨ 'ukaratsi Kutse 'ixurikieya kaniuti'uta, yukɨna mɨtitaxatɨanikɨ nuayuke. ");
INSERT INTO hch_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Kepauka kɨnaya munua, yaxeikɨa kaniutayɨni: «Hepɨrayu tewiyari pemɨ'atɨa nehamatɨa puhuimɨkɨkai. ");
INSERT INTO hch_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Peru ne kepauka karima nemutahiwaxɨ, kananuyenautsa yu'ixuriki 'uku'eirieka ne'aurie». ");
INSERT INTO hch_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Hikɨ Putipaxi yu'ɨya 'u'enieka, waɨkawa kaniuyeha'ani. ");
INSERT INTO hch_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","'Anari katiniuta'aita Kutse manutahɨiyanikɨ katsariyanata, Parahuni pɨretsutsiximama memanutaxɨriwatsie. Matsi tsepa manutahɨiyakai ");
INSERT INTO hch_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Yawé Kutse pɨka'uku'eiri 'aixɨa katiniparewiekaitɨni. Yakatiniuyurieni 'aixɨa mɨtixeiyakɨ katsariyanata mɨtihɨritɨarie, ");
INSERT INTO hch_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","hikɨ mɨkɨ Kutse kaniuhɨritɨani memanutaxɨriya muwaxeiyanikɨ meta mɨti'aitanikɨ muwa. ");
INSERT INTO hch_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Yawé Kutse miparewiekaikɨ kemɨtiyurienekai naitɨ 'aixɨa pɨtikuyɨnekai, katsariyana hɨritɨariekame pɨkareukweriwayuriekairi, Kutse mɨtiuhɨritɨakaikɨ naime. ");
INSERT INTO hch_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Merikɨtsɨ mɨixa tukari 'anukayaku, Parahuni tekɨxi memikuhanitɨwa winu 'uyemakame tiwa'aitɨwame, meta paa wewiwamete tiwa'aitɨwame, 'Ekipitu kwieyaritsie ti'aitame hetsiemieme memɨte'uximayakai 'axamekateniuyurieni. ");
INSERT INTO hch_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Hikɨ kaniuyeha'ani ti'aitame Parahuni, mɨkɨ yuhutame wahetsiemieme hetsɨana te'uximayatamete, tekɨxi hanamete wa'ukiyari, meta paa wewiwamete wa'ukiyari. ");
INSERT INTO hch_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","'Ayumieme kaniwarenɨ'ani kuyaxi wa'ukiyari hetsɨa katsariyana mexeiyakaikɨ, mɨkɨ katsariyana Kutse muwayewekaitsie pɨhɨkɨtɨkai. ");
INSERT INTO hch_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Muwa Kutse puhɨritɨariekai mɨwa'ɨwiyanikɨ, kuyaxi wa'ukiyari tawarita yuhutame pihɨritɨa. Mɨixa tukari me'aye'utɨ katsariyanata, ");
INSERT INTO hch_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","tɨkarikɨ mekateniuheinɨni, 'ikɨ yuhutatɨ te'uximayatamete, tekɨxi winu muyema 'uitɨwamete tiwa'aitɨwame, paa wewiwamete tiwa'aitɨwame, yuxexuitɨ mepɨte'uheinɨxɨa, yaxeikɨa ka'anuyɨtɨkaime. ");
INSERT INTO hch_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","'Ukatareku ximeri, kepauka Kutse mɨwarekuxei me'iyarixietɨkaime kaniwarutaxeiya. ");
INSERT INTO hch_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","'Ayumieme pɨwaruta'iwawiyaxɨ: —¿Titayari xetenututuixie? ");
INSERT INTO hch_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Mɨkɨ mɨpaɨ mekatenitahɨawe: —Tame hikɨ tepɨte'uheinɨxɨa, pumawe mɨtatsitahekɨatɨani. Kutse mɨpaɨ katiniwarutahɨawe: —Kakaɨyari kaniyɨweni mitahekɨata. Tsiparatsɨ xekeneneutaxatɨa kexemɨte'uheinɨ. ");
INSERT INTO hch_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Hikɨ tekɨxi 'uitɨwamete wa'ukiyari Kutse katiniutaxatɨani kemɨtiuheinɨkai, mɨpaɨ katinitsutɨani: —Mɨpaɨ nepɨtiuheinɨ, nehɨxie kaxie puwekai, ");
INSERT INTO hch_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","'anutahaikatɨ. Mɨkɨ kaxie kepauka mutayɨraxɨ kaniukaxutuni, yapauka 'ukayaxeka takari kaniutikwani. ");
INSERT INTO hch_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Ne, nemamatsie nepehanakai Parahuni ti'aitame tekɨxieya. Hikɨ kaxie takari ne'aka'inɨka tekɨxita nepeikapɨnaxɨ, mɨkɨ tekɨxi Parahuni mamayatsie nepeke. ");
INSERT INTO hch_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Kutse mɨpaɨ katinitahɨawe: —Kepemɨtiuheinɨ mɨpaɨ pɨtimatsiɨkɨ: Kaxie manuhaika, haika tukari pɨ'inɨariyari. ");
INSERT INTO hch_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Haika tukari 'anukayayu, Parahuni ti'aitame tawarita peiti'erieni kepemɨreyuri, hekwamekɨ matsihepitɨani pemɨtita'uximayatakɨ hetsɨana meripai hepaɨ. Hikɨ Parahuni ti'aitame tekɨxieya kaxie takari hayari muyema hekwamekɨ mamayatsie penekemɨkɨ, meripai pemɨtiyurienekai hepaɨ. ");
INSERT INTO hch_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Ne, nepɨmatsiwawirie waɨkawa pepɨkanetsihatɨtɨmaiyani, kepauka 'aixɨa mɨreyɨni kenemaine, Parahuni ti'aitame nehetsiemieme ketinetaxatɨa, 'uwa nemɨka'ayewenikɨ. ");
INSERT INTO hch_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Hepɨrayutsixi takwieyaritsie paitɨ waɨriyarika nepeyehanie 'ena nepɨ'atɨarie, tixaɨtɨ 'atsinekareyurieka 'uwa nepayewe. ");
INSERT INTO hch_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Paa wewiwamete wa'ukiyari 'u'enaka, 'iwaya 'aixɨa mɨti'ane hetsiemieme mɨtiutahekɨatɨariekɨ, mɨpaɨ Kutse katiniutahɨawe: —Neta mɨpaɨ nepɨtiuheinɨ. Nemu'utsie haika tsikɨiwitiyari paa nepanamanakai, ");
INSERT INTO hch_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","tsikɨiwiti mutinatɨtsie yutsata paa witsimɨ'anene pɨyemanekai, Parahuni ti'aitame hetsiemieme. Hikɨ maraikatsixi mepɨ'axekai me'itikwanike tsikɨiwititsie nemenamanakai. ");
INSERT INTO hch_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Kutse kanita'eiya: —Kepemɨtiuheinɨ mɨpaɨ pɨti'inɨariyari: Haika tsikɨiwitiyari pɨ'inɨariyari haika tukari. ");
INSERT INTO hch_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Haika tukari 'anukayayu, Parahuni ti'aitame pɨmatsita'aita, 'amu'u manutiwitekienikɨ, kɨyetsie pemɨkaxuiyanikɨ, 'ana maraikatsixi 'awaiyari mepɨtakwani. ");
INSERT INTO hch_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Hikɨ haika tukari 'anukayaku, Parahuni ti'aitame yutukari kaniuwewieni yuhetsɨamiemete wahetsiemieme. Hikɨ mɨkɨ yunaime wahɨxie katiniuta'aita memanutaxɨriyakai memɨwayehapanienikɨ, tekɨxi 'uitɨwamete tiwa'aitɨwame, paa wewiwamete tiwa'aitɨwame. ");
INSERT INTO hch_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Tekɨxi 'uitɨwamete tiwa'aitɨwame, hekwamekɨ kaniupitɨarieni mɨtita'uximayatakɨ hetsɨana, mɨpaɨ mɨkɨ katininuani Parahuni ti'aitame mamayatsie tekɨxieya mikuhanitɨwanikɨ meripai hepaɨ. ");
INSERT INTO hch_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Paa wewiwameta kaniuta'aita kɨyetsie mɨmierienikɨ, Kutse kemɨtiwaruhekɨatɨakai mɨpaɨ katiniuyɨni. ");
INSERT INTO hch_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","'Ana tekɨxi kaxie hayari muyema 'uitɨwamete tiwa'aitɨwame, Kutse kemɨrehɨawekai pɨkaheye'eri, yuheyemekɨ katinatɨmaiya. ");
INSERT INTO hch_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Merikɨtsɨ huta wiyari 'anukayaku, Parahuni mɨpaɨ katiniuheinɨni: Niru hatuxameyari tetsita kaniuwekaitɨni. ");
INSERT INTO hch_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Yapauka hapa mekanatinexɨani, 'atahuta meyupaɨmetɨ wakaitsixi mewaiyatɨkaitɨ, mekatenikwatɨwekaitɨni makutsiɨraɨyetsie. ");
INSERT INTO hch_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Hikɨ wa'utɨmata mekanatinexɨani, wahepaɨ meyupaɨmetɨ, mewawakitɨ 'axameteyuxexeiyatɨ, mana mekaniti'uni memɨwaiyatɨka wa'aurie Niru hatetsitayaritsie. ");
INSERT INTO hch_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Wakaitsixi memɨwawaki mekaniwarutikwani memɨwaiyatɨka. 'Anari Parahuni kananutaniere. ");
INSERT INTO hch_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Hutariekata kaneukuni. 'Ana tawarita pɨtiuheinɨ. Tɨriku xeikɨyeyaritsie 'uye'ukame puxei kɨkɨreme witsi'aneneme. ");
INSERT INTO hch_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","'Utɨmanata kanixeiya, hepaɨna paɨmeme wawakime 'eka mɨxɨkakɨ. ");
INSERT INTO hch_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","'Atahuta tɨriku mɨwawaki kanitikwani tɨriku mɨkɨkɨre witsimɨ'anene. 'Ana Parahuni kananutaniere, mɨpaɨ retimaika mɨheinɨtsikatɨkaikɨ. ");
INSERT INTO hch_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Nutuixietɨ yu'iyaritɨatɨ ximeri kananukukeni. Katiniwarutanɨ'airieni 'awie temaiwawemete 'ekipitutari. Katiniwarutaxatɨani kemɨtiuheinɨ, peru nixewitɨ pɨka'itahekɨatɨa heinɨtsikaya. ");
INSERT INTO hch_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Hikɨ tewi tekɨxi 'uitɨwamete mɨtiwa'aitɨa, mɨpaɨ Parahuni katiniutahɨawe: «Neuxei, nepaye'eri ke'axanemɨtiuyuri. ");
INSERT INTO hch_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Kepauka Parahuni muyeha'a teyu'uximayatsiriwamete wahekɨ, kuyaxi mɨtiwa'aitɨa katananutaxɨrieni ne meta paa wewiwame. ");
INSERT INTO hch_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Xeime tɨkaritsie taxexuitɨ tepɨte'uheinɨ, xexuitɨ peixeiyakai heinɨtsika kemɨti'ayumiemetɨkai. ");
INSERT INTO hch_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Hikɨ xewitɨ tahamatɨa payekatei, temaikɨtɨtɨ Hepɨrayu tewiyari kuyaxi mɨtiwa'aitɨa mɨparewiekai. Tepitaxatɨa ketemɨte'uheinɨ. Mɨkɨ pɨtatsi'utahekɨatɨa xexuime. ");
INSERT INTO hch_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Naitɨ yapɨraye'a mɨkɨ kemɨtatiutaxatɨa. Ne hutarieka nepuhɨritɨarie ne'uximayatsika, xewitɨta pumierie kɨyetsie». ");
INSERT INTO hch_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Hikɨ ti'aitame Kutse katiniutanɨ'airieni. 'Ana kwitɨ kaniwayexɨnarieni katsariyanata. Kwitɨ 'uyutikemaritɨaka, kaninuani Parahuni hɨxie. ");
INSERT INTO hch_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Ti'aitame mɨpaɨ katinitaxatɨani: —Ne nepɨtiuheinɨ, xewitɨ pɨka'ihekɨatawe. Peru xewitɨ pɨnetiutaxatɨa, kename 'ekɨ peyɨwe pemitahekɨata heinɨtsi. ");
INSERT INTO hch_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Hikɨ Kutse kanita'eiya: —Ne nepɨkahɨkɨ. Kakaɨyari kanihɨkɨtɨni mitahekɨata. ");
INSERT INTO hch_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Hikɨ ti'aitame Parahuni Kutse mɨpaɨ katiniutaxatɨani: —Neheinɨtsita, Niru hatuxameyari tetsita nepuwekai. ");
INSERT INTO hch_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Hikɨ yapauka hapa mekanatinexɨani, 'atahuta meyɨpaɨmetɨ wakaitsixi mewaiyatɨkaitɨ, witsime'anenetɨ 'ɨxapa mekatenikwatɨwekaitɨni. ");
INSERT INTO hch_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Yapaukata wa'utɨma mekanatinexɨani wahepaɨ meyupaɨmetɨ, mewawakitɨ 'axameteyuxexeiyatɨ. Hatsuaku kenemɨkatiwaxeiyawekai mɨpaɨ me'aneneme 'Ekipitutsie. ");
INSERT INTO hch_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Kwitɨwata 'atahuta wakaitsixi memɨwawaki, mekaniwarutikwani memɨwaiyatɨka. ");
INSERT INTO hch_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Tsepa memɨwarutikwakai, yaxeikɨa mepɨtewawakikai. 'Ana nepanutanierixɨ. ");
INSERT INTO hch_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","»Hutariekata nepɨtiuheinɨ, 'atahutame nepuxei tɨriku mɨayeyari kɨkɨreme witsi'aneneme, pɨwawerekai xeikɨyeyaritsie tiwiyatɨ. ");
INSERT INTO hch_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","'Utɨmanata nepixei, hepaɨna paɨmeme tɨriku wawakime 'eka mɨxɨkakɨ. ");
INSERT INTO hch_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Tɨriku mɨwawaki 'aixɨa mɨ'anene kaniutikwani. 'Ikɨ naime nepɨwarutaxatɨa 'awie temaiwawemete peru nixewitɨ pɨkanetsi'utahekɨatɨa». ");
INSERT INTO hch_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Hikɨ Kutse kanitahekɨatɨani naime kemɨtiuheinɨkai Parahuni. Mɨpaɨ kaniutayɨni: —Puyuxewitɨtɨ kepemɨtiuheinɨ. Kakaɨyari kanihɨkɨtɨni mɨmatiutahekɨatɨa kemɨtiyɨni. ");
INSERT INTO hch_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Mɨkɨ matsi 'atahuta wakaitsixi memɨwaiyatɨka, yaxeikɨa tɨriku mɨkɨkɨre, mɨkɨ 'atahuta wiyari pɨ'inɨariyari. Mɨkɨ puyuxewi heinɨtsika. ");
INSERT INTO hch_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Wakaitsixi 'atahuta memɨwawaki 'axamemɨ'anene, memɨwaiyatɨka wa'utɨa mematinexɨa, meta 'atahuta tɨriku 'etsimɨpepe mɨwawaki 'eka mɨxɨkakɨ, mɨkɨta pɨhɨkɨ 'atahuta wiyari. Mɨpaɨ paɨmexa haakaxa payani. ");
INSERT INTO hch_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","»Kenemɨmarahɨawe Parahuni, yurikɨ Kakaɨyari kemɨmatihekɨatɨa, pɨtihekɨata kemɨtiyurieni. ");
INSERT INTO hch_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","'Anari kanaye'amɨkɨ, 'atahuta wiyari waɨkawa mɨtitixuawere 'Ekipitu kwieyaritsie. ");
INSERT INTO hch_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Hepaɨna paɨmetɨ mahu, haakaxa payani, 'anari pɨkatitixuawere, mepɨtehatɨmaiyani waɨkawa kememɨtehexeiyakai meripaitɨ mɨkɨ kwieyaritsie. ");
INSERT INTO hch_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Yemekɨ waɨkawa haakaxa payani keyamɨkatiyɨwekai meripaitɨ. ");
INSERT INTO hch_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","'Ekɨ Parahuni hutame pemuheinɨ, Kakaɨyari puyumexɨitɨa kwitɨwa mɨpaɨ mɨtiyurienikɨ. ");
INSERT INTO hch_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","»'Ayumieme, hikɨ Parahuni xeime keneutiwawa waɨkawa yɨweme, timaiweme, pemihɨritɨanikɨ 'Ekipitu kwieyari hepaɨtsita. ");
INSERT INTO hch_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","'Ekɨ Parahuni mɨpaɨ ketineuyuri, keniwarutihɨawi nenieremete naitsarie 'Ekipitu, 'atahuta wiyari waɨkawa mɨtitixuawere 'itsanari 'auxɨwimexɨa tixeɨriekame, xeime xemɨti'utakɨ Parahuni hetsiemieme, naitsarie 'akwiepa. ");
INSERT INTO hch_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","'Ekɨ Parahuni peti'aitakaku, mɨkɨ nenieremete meke'ikuxeɨrieni 'ikwai 'aixɨa mɨtixuaweretsie mieme, meke'iti'uta naitsarie kiekaritetsie, 'ikwai xemexeiyanikɨ mɨtiumawenitsie. ");
INSERT INTO hch_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Mɨkɨ 'ikwai mɨti'utsieni 'Ekipitutsie mieme payani, 'atahuta wiyari mɨhaakaxatɨnitsie, mɨpaɨ teɨteri mɨkɨ kwieyaritsie haakakɨ mepɨkakwini». ");
INSERT INTO hch_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Hikɨ Parahuni 'iyarieya 'aixɨa kaniuyɨni Kutse kemɨtitahekɨatɨa, yaxeikɨata 'iparewiwametemama. ");
INSERT INTO hch_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Hikɨ Parahuni mɨpaɨ katiniwaruta'iwawiya memiparewiekai: —Kamɨtsɨ hakewa tepeikaxeiya xeime 'ikɨ hepaɨ 'anekame, Kakaɨyari 'iyarieya hexeiyame. ");
INSERT INTO hch_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Hikɨ ti'aitame Kutse mɨpaɨ katiniutahɨawe: —Mɨpaɨ nepɨretima Kakaɨyari pɨmatihekɨatɨa 'ikɨ naime, xewitɨ pumawe yɨwetɨ, timaiwetɨ, 'ahepaɨ. ");
INSERT INTO hch_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","'Ekɨ nepɨmatsihɨritɨani nemɨra'aitatsie, neteɨterima yamepɨtekakɨne 'ekɨ petiwa'aitɨakaku. Ne xeikɨa matsi nemɨmariwe nepɨhɨkɨtɨni, nemɨti'aitamekɨ. ");
INSERT INTO hch_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Hikɨ Parahuni mɨpaɨ Kutse katiniutaxatɨani: —Hikɨ ne nepumatsihɨritɨa 'Ekipitu kwieyari naime. ");
INSERT INTO hch_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","'Ana kwitɨwa Parahuni yuhanira 'anutihɨnaka Kutse 'itɨwameyatsie kanekamanirieni, katiniuta'aita memenakatɨtɨanikɨ kamixa witsimɨ'ane meta huru kukayari mepetitɨtɨa kɨipitɨana. ");
INSERT INTO hch_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Hikɨ yuparewiwame kaxetayatsie kanenutiyeni, teparewiwamete me'utihiwakaku ya'ane mewapitɨakaku yunaitɨ mekaniukatunuma'uwekaitɨni hɨxiena. Kanihɨritɨani 'Ekipitu kwieyaritsie naime. ");
INSERT INTO hch_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Hikɨ Parahuni mɨpaɨ katinitahɨawe: —Ne ti'aitame Parahuni nepɨhɨkɨ, peru xewitɨ 'Ekipitutsie yapɨkatiyurieni 'ekɨ yapekahainekaku. ");
INSERT INTO hch_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Hikɨ kanipata kemɨtitewakai, Tsapenati-Paneha katiniterɨwa. 'Uka kaniwitɨtɨani 'Atsenati titewakame, Putipera niweya mawari wewiwame 'Uni kiekame. Mɨpaɨ katinanukakeni Kutse 'Ekipitu ti'aitatɨ. ");
INSERT INTO hch_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Xeitewiyari heimana tamamata kanihɨkaitɨni Kutse kepauka mɨtiukatsutɨa ti'uximayatɨ ti'aitame tsiemieme. Kutse Parahuni hɨxie kaniutateuta, kaneyani 'Ekipitu kwieyaritsie, kanikuniere. ");
INSERT INTO hch_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Mɨkɨ 'atahuta wiyaritsie 'aixɨa mɨtiwiyekekaitsie, 'ana waɨkawa katiniutixuawere. ");
INSERT INTO hch_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Hikɨ Kutse katiniuti'uta naime tikwaiwamete, mɨkɨ 'atahuta wiyaritsie mieme katiniuti'uta kiekaritsie. ");
INSERT INTO hch_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Kutse tɨriku puti'utaxɨ xiekari muti'uta hepaɨ, pɨtiyuxexeiyakai mi'inɨatakai pɨtiuhayewaxɨ mɨkayu'inɨatsinɨakaikɨ. ");
INSERT INTO hch_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Mexɨakame ka'anuyeyeiwekaku haakaxa wiyari, Kutse tɨɨri yuhutame mepɨwarayexei 'Atsenati matɨa, Putipera mawari wewiwame niweya 'Uni kiekame. ");
INSERT INTO hch_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Yumatɨari Manatsexi katiniuterɨwa mɨpaɨ 'utayɨka: «Kakaɨyari pɨtiyuriene nemɨratɨmaiyakɨ naime 'uximatɨarikakɨ nekie hakewa nemetinuiwaxɨ». ");
INSERT INTO hch_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Hutarieka mieme 'Epɨrahini pɨtiterɨwaxɨ mɨpaɨ 'utayɨka: «Kakaɨyari pɨnetsi'upitɨa nemɨxiɨkakɨ, 'ikɨ kwieyaritsie hakewa nemɨreka'eniwakai». ");
INSERT INTO hch_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Hikɨ 'atahuta wiyari 'aixɨa mɨtiwiyekekaitsie kanaye'ani. ");
INSERT INTO hch_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Kutse kemutayɨkai haakaxa kaniuyutsutɨani 'atahuta wiyari, haakaxa kanayani naitsarie kwie mumanetɨkateitsie. 'Ekipitu kwieyaritsie xeikɨa puxuawekai, Kutse mɨtiuta'aitakaikɨ mɨtiti'utsienikɨ. ");
INSERT INTO hch_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Kepauka 'ekipitutari memuhaakakwi, teɨteri Parahuni hetsɨa mekaniye'axɨani 'ikwai mete'iwawirietɨ, hikɨ Parahuni mɨpaɨ katiniwarutahɨawe teɨteri 'ekipitutari: «Xekenehu Kutse hetsɨa yaxeketenekakɨni kemetayɨni». ");
INSERT INTO hch_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Kepauka yuwaɨkawatɨ memɨyehaakakwitɨwekai, Kutse katineuyepieni tɨriku mɨwa'utɨkaitsie watuirienike 'ekipitutari. ");
INSERT INTO hch_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Yaxeikɨata 'ateewa paitɨ meheyekɨkatɨ 'Ekipitu mekani'axekaitɨni, tɨriku mekunanetɨwetɨ Kutse hetsɨa, mɨhaakaxatɨkaikɨ kwinimieme naitsarie kwie kemɨyewa. ");
INSERT INTO hch_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Merikɨtsɨ Kakuwu kepauka mɨtiutamari, kename tɨriku hexɨawe 'Ekipitu, mɨpaɨ yuniwema katiniwarutahɨawe: «¿Ketitayari mana xetekutei, kwi xeyuxexeiyatɨ xeikɨa? ");
INSERT INTO hch_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Mɨpaɨ nekatinimarieka kename tɨriku hexɨawe. Mana xekenehu xekenenanaiyu tahetsimieme temɨkakwinikɨ hakakɨ». ");
INSERT INTO hch_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Tamamata meyupaɨmetɨ mekaniyukuha'aritɨani Kutse 'iwamama 'Ekipitu meteheunanaiyuka. ");
INSERT INTO hch_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Peru Kakuwu Wenikamini pɨka'upitɨa mɨyemiekɨ Kutse mutaya, mɨpaɨ tiku'eriwatɨ: Nɨkahɨrixɨa mɨwa hemierieni. ");
INSERT INTO hch_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Hikɨ 'Ixaheri tɨɨriyamama kepauka memeta'axɨa metetaxɨawienike, matsi naitsarie waɨkawa kanihaakaxatɨkaitɨni, Kanani kwieyaritsie. ");
INSERT INTO hch_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Kutse kuwexinaruri pɨhɨkɨtɨkai mɨkɨ kwieyaritsie. Tɨriku mepɨwatuiriekai, naitsarie kiekaritetsie teɨteri memɨ'axekai. Kepauka 'iwamama hetsɨana memu'axɨa, kwiepapai mekaniukahɨxima'uni. ");
INSERT INTO hch_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Kutse waruxeiyaka yu'iwama, kaniwaretimani. Perutsɨ mɨkawamateni hepaɨ katiniwarutahɨawe: —Xemetsɨ, ¿hakewa xepeyekɨ? Mɨkɨ mɨpaɨ mekatenita'eiya: —Tame Kanani kwieyaritsie tepeyekɨ tɨriku tepɨkunanetɨwe. ");
INSERT INTO hch_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Kutse pɨwaretimaikai, peru mɨkɨ 'iwamama mepɨka'imatekai. ");
INSERT INTO hch_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Merikɨ 'ana Kutse kanaye'erieni, kemɨtiuheinɨkai wahetsiemieme. 'Ayumieme mɨpaɨ katiniwarutahɨawe: —Xemetsɨ 'awie nenieremete xepɨyɨa xetatsihupietɨwetɨ. ");
INSERT INTO hch_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Mɨpaɨ mekatenita'eiya: —Hawaikɨ ti'aitame, matsiparewiwamete tepɨyɨa. Tɨriku tepɨkunanetɨwe xeikɨa. ");
INSERT INTO hch_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Tame tepɨxeinuiwari tapaapa puyuxewi, heitseriemekɨ yatepɨtekahu, tepɨka'awienenieremete. ");
INSERT INTO hch_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Kutse mɨpaɨ katiniwaruta'eiya: —Pɨkayuri, xeme kexemutiyuane. Xepɨkunieretɨwe xeikɨa kemɨtiu'ane. ");
INSERT INTO hch_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Perutsɨ mɨkɨ tawarita mɨpaɨ mekatenita'eiya: —Tame, mate'uximayatsiriwamete, tamamata heimana huta tepɨyupaɨmekai, tanaitɨ tapaapa puyuxewi Kanani kwieyaritsie kanekani. Tamuta peyuhayewaxɨ yupaapa hetsɨa, xewitɨri pɨka'uyeika. ");
INSERT INTO hch_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Merikɨtsɨ Kutse tawarita mɨpaɨ katiniwarutahɨawe: —Netsɨ kenemɨtixekɨhɨawe, 'awie nenieremete xekaniyɨaka. ");
INSERT INTO hch_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Kamɨtsɨ xɨka yuri xe'utiyuaneni: Ti'aitame kemaine yaxeikɨa tepɨxe'anutaxɨrieni 'ena, yu'iwa xe'atɨayuke xepanuyekɨne. ");
INSERT INTO hch_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Xeme, xewitɨ yu'iwa pɨwitɨmie, xekenanunɨ'a. Hipatɨta katsariyanata xepaye'uka. 'Anake mɨpaɨ tekatenetimaikuni xɨka 'aku yuri xe'utiyuaneni, mexɨka katixaɨtɨni, yurikɨ mɨpaɨ nekanaineni Parahuni hetsiemieme, hupamete xekaniyɨaka. ");
INSERT INTO hch_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Hikɨ Kutse kaniwaranutaxɨrieni katsariyanata haika tukari. ");
INSERT INTO hch_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Hikɨ hairieka tukaritsie mɨpaɨ katiniwarutahɨawe: —Ne tewi Kakaɨyari nemayemakaxe nepɨhɨkɨ, xemeta yaxeketeneuyuri kenemɨtixetahɨawe, xemɨyutawikweitsitɨanikɨ. ");
INSERT INTO hch_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Xɨkatsɨ xeme heitseriemekɨ yaxetekahuni, 'uwa xewitɨ xeikɨa kaniyuhayewamɨkɨ. Hipatɨta xekaniyehuni, tɨriku xekanituayuni xeniwema memɨtehekwakakɨ. ");
INSERT INTO hch_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Perutsɨ tsiere yumuta xekaneni'atɨiriekuni, neyuri nemɨtixeta'eririenikɨ xemɨkakwinikɨ 'ena. Mɨpaɨ mekaniutiyuani: —'Aixɨa pɨyɨni, mɨpaɨ tepɨteyurieni. ");
INSERT INTO hch_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","'Ana mɨpaɨ metenanuyutahɨawekaitɨni yunaitɨ: —Xɨari hikɨ tepɨte'uka'eniwa tamuta temɨte'ukwinitɨakɨ, tsepa mɨtatsiku'imaiyakai tepɨka'enu'eni, hikɨri xɨari 'ayumieme tekateniuka'eniwani. ");
INSERT INTO hch_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Hikɨ Xuweni mɨpaɨ katiniwarutahɨawe: —Ne 'ayumieme mɨpaɨ nepɨtixekɨhɨawekai, tepɨkate'ikwinitɨaka tepɨka'ikumemiwani, xepɨkanetsi'u'eni. Hikɨri xɨari 'ayumieme tekatenayukatuayani mumawekɨ. ");
INSERT INTO hch_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Kutse 'ekipitutari waniukikɨ mɨwakɨhɨawekaikɨ, 'iparewiwameya pɨwahekɨatɨakai waniukikɨ. Mɨkɨ mɨpaɨ mepɨkatemaikai wa'eniekame mepɨka'eriekai waniukikɨ. ");
INSERT INTO hch_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","'Anari Kutse 'anayeyaka yuxaɨta 'awie kaniutatsuani. Heyunɨtɨaka hutarieka nuaka, Tsimehuni kaniuta'aita, mɨhɨiyanikɨ yu'iwama wahɨxie. ");
INSERT INTO hch_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Hikɨ Kutse katiniuta'aita memuka'ikatɨarienikɨ tɨriku hɨpɨneme, yaxeikɨata watumini mukamanariexɨanikɨ wa'ikata, meta memuka'inɨatɨarienikɨ huyeta mieme. Mɨpaɨ mekateniuyurieni. ");
INSERT INTO hch_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Hikɨ yupuxuri mewaruti'ikatɨaka, mekanakunuaxɨani yu'utɨma. ");
INSERT INTO hch_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Perutsɨ hakewa memekuhenikekai taikai, xewitɨ mana yupuxu titiminike, yukuxitari kananukɨxɨna, muwa yutumini kaniutaxeiya. ");
INSERT INTO hch_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Hikɨ yu'iwama mɨpaɨ katiniwarutahɨawe: —Neuxei, kari netumini nepeukayetsiyarie. 'Uwa patika yaxeikɨa paɨmetɨ. Hikɨ 'iwamama waɨkawa mekaniutimamani. Mɨpaɨ mekaniutiyuanekaitɨni: —¿Kehepaɨtɨtɨri Kakaɨyari pɨtatsiyuriene? ");
INSERT INTO hch_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Kepauka memuta'axɨa Kanani kwieyaritsie, yupaapa Kakuwu mekateniutaxatɨani, naime kememɨte'anuyekɨ: ");
INSERT INTO hch_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","—Kuwexinaruri 'Ekipitu kwieyaritsie ti'aitame, waɨkawa pɨtatsiheku'iwawiyakai. Mɨpaɨ pɨtarekuhɨawekai: “'Awienenieremete xekateyɨa”. ");
INSERT INTO hch_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Tame mɨpaɨ tepɨteheitahɨawixɨ: “Tixaɨ tame heitseriemekɨ yatepɨtekahu tepɨka'awienenieremete. ");
INSERT INTO hch_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Tame tepɨxeinuiwari tapaapa puyuxewi. Tamamata heimana huta tepɨyupaɨmekai, xewitɨri pumawe, tamuta xeikɨa peyuhayewaxɨ Kanani kwieyaritsie”. ");
INSERT INTO hch_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","»Hikɨ tewi mana mɨti'aita mɨpaɨ katatinetahɨawe: «'Ikɨkɨ mɨpaɨ nekatinimaikamɨkɨ xɨka 'aku heitseriemekɨ yaxetekahuni, xewitɨ 'ena kaniyuhayewamɨkɨ, hipatɨ xeikɨa xekaniyehuni xeniwema memɨkaheyehaakakwitɨwenikɨ. ");
INSERT INTO hch_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Perutsɨ xekaneni'atɨiriekuni yumuta 'imatɨreme, yuri nemɨtixeta'eririenikɨ kename 'awie nenieremete xekayɨa. 'Anake xe'iwa nekanixeyetuiriemɨkɨ, yaxeikɨata heitseriemekɨ tepɨxemateni, 'ena xemu'uwanikɨ takwiepa kemɨtixenake». ");
INSERT INTO hch_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Hikɨ kepauka yukuxitari memanukuxɨnaxɨa, mekanitaxeiya purutsa watumini muyetei. Mɨkɨkɨ yunaitɨ mekaniutimamani. ");
INSERT INTO hch_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Hikɨ Kakuwu mɨpaɨ katiniwarutahɨawe: —Xemeri neniwema tixaɨtɨ xepɨkanetehayewieni. Kutse tahamatɨari 'apɨka'uyeika, Tsimehuni meta pumawe. Hikɨtari Wenikamini xepɨyewitɨxime. Waɨkawa xepɨnetsihiweritɨa xeikɨa. ");
INSERT INTO hch_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Perutsɨ Xuweni, yupaapa mɨpaɨ katiniutahɨawe: —Ne Wenikamini nepanuwitɨni nepɨyɨhɨritɨani nemi'atɨanikɨ. Mexɨka neka'i'atɨani, pepɨyɨwe neniwema yuhutame pemɨwarukwini. ");
INSERT INTO hch_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Kakuwu tawarita mɨpaɨ kaniutayɨni: —Neniwe pɨkayemie xe'utɨma. Kutseri pɨka'uyeika, mutaya xeikɨa puyuhayewane. Xɨka huyeta yɨkɨ reiyurieni, xemetsɨ pɨxehetsietɨni xɨka ne 'ukiratsi hiwerikakɨ ne'umɨni. ");
INSERT INTO hch_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Naitsarie Kanani kwieyaritsie matsi waɨkawa mepɨyehaakakwitɨwekai. ");
INSERT INTO hch_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Merikɨte kepauka tɨriku memuxɨ, memeikuxɨawiekai 'Ekipitu, mɨpaɨ katiniwarutahɨawe wapaapa: —Xekenehuta hutarieka tawarita xekenexɨawiyu tɨriku temeixeiyanikɨ ta'ikwai. ");
INSERT INTO hch_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Matsi Kura mɨpaɨ katinitahɨawe: —'Iya tewi heitseriemekɨ mɨpaɨ pɨtaretahɨawixɨ kename tawariri tekaheuhunikekai, ta'iwa xeikɨa Wenikamini te'awitɨtɨ teyɨwawekai. ");
INSERT INTO hch_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Xɨka 'ekɨ pe'itaunieka tamuta, tekatenixɨawiyuni. ");
INSERT INTO hch_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Ya pɨtikatixaɨ, titayari teteheuhuni. Mɨkɨ tewi heitserie mɨpaɨ painekai kename tekahauhunikekai, tamuta xɨka tekahawitɨkɨni. ");
INSERT INTO hch_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","'Ixaheri mɨpaɨ katiniwarutahɨawe: —¿Titayari mɨpaɨ xeteheitahɨawixɨ mɨkɨ tewi, kename yu'iwa xeime xehexeiya? 'Uximatɨarika waɨkawa xepɨnetsiwiwirie. ");
INSERT INTO hch_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Mɨkɨ mɨpaɨ mepɨte'ita'ei: —Mɨkɨ tewi pɨtatsiheku'iwawiyakai waɨkawa tahepaɨtsita: “¿Xepaapa 'akuxi reyeika? ¿Xemuta 'akuxi, xewitɨ reyeika?” 'Utaitɨ, ta'iwama tatɨɨriyama wahepaɨtsita. Tame tepɨkaheyɨwawekai yɨkɨ temetiyuanikekai. Ta'iwa tatsihetawawirienike tepɨkahe'eriekai. ");
INSERT INTO hch_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Yuhetsiemieme Kura yupaapa 'Ixaheri mɨpaɨ katiniutahɨawe: —Wenikamini keheyani tahamatɨa. Keneneuhɨritɨa, kwitɨwa tekaniyehuni temɨwikwekakɨ tame meta taniwema. ");
INSERT INTO hch_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Ne hetsiena mieme nekaninehɨritɨamɨkɨ. Xɨka nekamatsi'atɨirieni 'ena, ne hetsiena mieme nerapitɨ nekanayeimɨkɨ neheyemekɨ. ");
INSERT INTO hch_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Xɨka niuki tekaxɨatɨakake waɨkawa, 'ari hutakɨa tepakunuaxɨanike. ");
INSERT INTO hch_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Hikɨ 'Ixaheri wapaapa mɨpaɨ katiniwarutahɨawe: —Kamɨtsɨ mɨpaɨ xeketeneuyuri, yu'iwa xekenanuwitɨki. Takwiepa mɨtixuawe 'aixɨa mɨti'anene xeketeneuka'ikata yukuxitariteta. Xeketenanutɨkiri 'iya tewi, xekenemikwa waritsamu 'etsiwa, xiete, witsimu'ɨa, mixaxi, pitsitatsi, 'erimenitɨra nuetsi hepaɨ mɨ'anene. ");
INSERT INTO hch_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Tawarita pɨrata hepaɨna paɨmeme xekenanu'ɨiri. Mɨkɨ xepeiyetuirieni mamayatsie yukuxitariteta xemeitaxei, tietɨtsɨ mɨpaɨ kara'eriwatɨ muwa mɨneikamanaxɨ. ");
INSERT INTO hch_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Yumuta xekenanuwitɨki mɨkɨ tewi hetsɨa. ");
INSERT INTO hch_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Kakaɨyari Naimekɨmɨtɨrɨkaɨye mɨkɨ tewi 'aixɨa mɨtixexeiyanikɨ ke'upitɨani, Wenikamini xeime meta 'iwaya, meke'akunuaxɨani xehamatɨa. Xɨkari ne neniwema newareuyehɨamɨkɨ, ¿ketsɨari ne'uyɨni? Tsepari. ");
INSERT INTO hch_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","'Ixaheri niwemama mekatenetɨni 'imikierite, tawarita pɨrata hepaɨna paɨmeme, Wenikamini me'awitɨtɨ, meyumexɨitɨatɨ mekanekɨne 'Ekipitu. Me'uta'axɨaka Kutse hɨxie mekaniti'uni. ");
INSERT INTO hch_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Kepauka Kutse Wenikamini muxei yunaime wahamatɨa, yuparewiwame mɨpaɨ katiniutahɨawe: «Keniwaranuwitɨki 'ikɨ teɨteri nekie, kenemi'a tuuru muwaiya 'ikwai kenekawewi, tuka nehamatɨa mekatenekwaikuni». ");
INSERT INTO hch_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Ti'uximayatame katinaye'atɨani kemɨtiu'aitɨarie. Kaniwarewitɨni Kutse kie. ");
INSERT INTO hch_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Mɨkɨ metehetimaika Kutse kie memewitɨkiekaikɨ waɨkawa mekanimamakaitɨni. Mɨpaɨ mepɨte'u'eri: «'Ikɨ tewi pɨtatsi'atɨa yukie tapɨrata mɨkahe'ɨikɨ matɨari mieme. 'Ikɨ xɨari pɨtatsikwini 'uximayatsikakɨ waɨriyarika tati'aitɨatɨ meta tapuxurima». ");
INSERT INTO hch_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","'Ayumieme kiita meheutahaxɨanike 'ahurawa mekaniukɨne, Kutse kie ti'uximayatame mɨpaɨ mekateniutahɨawe: ");
INSERT INTO hch_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","—Neuxei ti'aitame, 'ekɨ pekatinimaika xeimiemeri tepeɨkɨkɨnixɨa, tɨriku tepekunanai. ");
INSERT INTO hch_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Kepauka mana temeta'axɨa hakewa temekuhenikekai tɨkarikɨ, hikɨ takuxitarite temanukɨxɨnaxɨa. Muwa kanatimanekaitɨni pɨrata, kepaɨmemekɨ temɨteyutuakai. Hikɨ tekane'ɨka mɨkɨ pɨrata. ");
INSERT INTO hch_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Hipameta pɨrata tekana'ɨka, tawarita tɨriku teminanenikɨ. 'Atsitepɨkatemate kemɨ'ane muwa meikamanaxɨ. ");
INSERT INTO hch_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Ti'uximayatame mɨhɨritɨarie mɨpaɨ katiniwarutahɨawe: —Xepɨkayu'iyaritɨaka, ne nekanenɨ'ɨni mɨkɨ pɨrata kɨmana xemɨte'uyutua. Xekakaɨyari xepaapa kakaɨyarieya muwa xɨari peikamanaxɨa mɨkɨ 'imikieri. Ti'uximayatame Tsimehuni kaniwa'atɨirieni, ");
INSERT INTO hch_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","'ana kaniwarewitɨni memeutahaxɨanikɨ Kutse kiita. Haa meta kaniwaruhanitɨani yuketate memɨtihauxinikɨ, wapuxurimata katiniwarutimini. ");
INSERT INTO hch_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Mɨkɨri mepɨtemaikai Kutse wahamatɨa mɨtikwanikekaikɨ tuka. Mekateniukuha'aritɨani 'imikieri kepauka munuanikekai. ");
INSERT INTO hch_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Kepauka Kutse munua yukie, mɨkɨ mekaniukahɨxima'uni hɨxiena. Mekaniyetuirieni 'imikieri memeiyetɨkiriekai meta mekanitawaɨritɨani. ");
INSERT INTO hch_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Kutse kaniwaruta'iwawiya kememɨteheu'eriekai. Mɨpaɨta katiniwaruta'iwawiya: —¿'Aixɨa reu'eriekai xepaapa, mɨkɨ 'ukiratsi xemɨnetsihaxaxatɨwakai? ¿Rayeyuri 'akuxi? ");
INSERT INTO hch_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Mɨkɨ mekatenita'eiya: —Mɨkɨtsɨ tapaapa payeyuri, 'aixɨa katineu'erieka. 'Ana hutarieka hɨxiena mekaniukahɨxima'uni. ");
INSERT INTO hch_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Kutse waranuxeiyatɨyaka, kepauka Wenikamini yu'iwa muxei paapaya warutsieya hetsiemieme, mɨpaɨ katiniwaruta'iwawiya: —¿'Ikɨ tihɨkɨ xe'iwa 'etsimɨyumate xemɨnetsihaxaxatɨwakai? Kakaɨyari kematsi'ɨwiyani neniwe —katinitahɨawe. ");
INSERT INTO hch_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Kutse kaneyukaheiwerietɨyani yumuta xeiyatɨ 'inaki'erietɨ. Yapauka kanewayeyani, mɨwayehuputsie heutahaka, kaniutatsuani. ");
INSERT INTO hch_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","'Uyunɨtɨaka 'anaka'ɨtaimaka, kaniwayeyani. Mɨpaɨ kaniutayɨni: «'Ikwai xekenakatuaxɨa». ");
INSERT INTO hch_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Kutse 'ikwaiya yuxaɨtame kanamaniyarieni, 'ekipitutari wa'ikwai yuxaɨtameta. Hepɨrayutsixi meta Kutse 'iwamama wa'ikwai yuxaɨta mepamaniyariexɨa, 'ekipitutari wahepaɨtsita 'axapɨ'anekai hipame wahamatɨa xɨka mete'ukwani. ");
INSERT INTO hch_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Kutse 'iwamama hɨxiena mekanayaxe, kememɨte'ununuiwaxɨ, kwimeniyuxexeiyakaitɨni mehɨxiyatɨ. ");
INSERT INTO hch_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Kepauka 'ikwai Kutse mamaniyarie mexayatsie, Wenikamini kanamaniyarieni 'auxɨwime xakɨyari Kutse mexayatsie miemetɨme, 'iwamamata xeixakɨyari xeikɨa mekanamaniyariexɨani yuxexuitɨ. Kaxie winuyari mekananu'ieni Kutse hamatɨa. ");
INSERT INTO hch_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Merikɨtsɨ 'ana kwitɨ Kutse tiyu'uximayatsiriwame katiniuta'aitɨani kiiya hepaɨtsita mɨhɨritɨariekai: «Kenetihɨniya 'ikɨ teɨteri wakuxitarite tɨrikukɨ. Yuxexuime wa'ikata wapɨrata keneukayatsa. ");
INSERT INTO hch_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Netekɨxi keneukaketsiri wamuta 'ikayata, pɨrata mame mɨtiuyutua». Ti'uximayatame naime katinaye'atɨani Kutse kemɨtita'aitɨakai. ");
INSERT INTO hch_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Hikɨ 'amɨtiukatarixɨ, Kutse kaniwarupitɨani memɨyehukɨ yupuxurima mewaru'arietɨ. ");
INSERT INTO hch_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Mehekɨneku yareutewikaku Kutse tiyu'uximayatsiriwame mɨpaɨ pɨtiutahɨawixɨ: «'Ikɨ teɨteri memekɨ, keniwaranukuweiya. Xɨka pewaranuku'axe mɨpaɨ ketiniwaretahɨawi: “¿Titayari 'axa'anemekɨ xenetehakapitɨa, titayari neti'aitɨwame tekɨxieya xetehenawa pɨrata tekɨxiyari? ");
INSERT INTO hch_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Kexemɨte'uyuri 'aixɨa pɨka'ane, mɨkɨ tekɨxi kanihɨkɨtɨni neti'aitɨwame kɨmana manuye'e, kɨmana mɨretimamate kemɨtiyɨni 'arike”». ");
INSERT INTO hch_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Kepauka ti'uximayatame mɨwaranuku'axixɨ yaxeikɨa katiniwarutahɨawe kemɨretahɨawarie. ");
INSERT INTO hch_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Mɨkɨ mɨpaɨ mekatenita'eiya: —¿Ketitayari 'ekɨ mɨya petatikɨhɨawe? Hatsuaku tame mɨpaɨ tepɨkateheyurieka. ");
INSERT INTO hch_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Perutsɨ tame tepeyekɨ takie Kanani kwieyaritsie, pɨrata teyetuanike temitaxei takuxitariteta. ¿Kehapaɨ matsi huru, pɨrata tete'unawani mati'aitɨwame kiita mieme? ");
INSERT INTO hch_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Mɨkɨ pɨrata tekɨxiyari, kemɨ'ane kuxitarieyata pemitaxeiya, ke'umierieni. Tameta teyunaitɨ te'a'uximayatsiriwamete tepakɨne. ");
INSERT INTO hch_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Ti'uximayatame mɨpaɨ katiniwarɨtahɨawe: —Kexemaitɨka 'aixɨa kani'aneni, mɨpaɨ nepɨtiyurieni. Perutsɨ kemɨ'ane tekɨxi muyekeka, mɨkɨ xeikɨa neti'uximayatsiriwame kanayeimɨkɨ, xeme yunaitɨ xepɨxɨxɨnini. ");
INSERT INTO hch_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Yapauka yunaitɨ mɨkɨ mekaniuti'ikapiexɨani, yukuxitarite mekananukuxɨnaxɨani. ");
INSERT INTO hch_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Hikɨ ti'uximayatame kanitiwauni yuxexuime wakuxitarita wamatsikatsie 'itsutɨaka. Kanitaxeiya tekɨxi wamuta Wenikamini kuxitarieyata. ");
INSERT INTO hch_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Kepauka memixei, Kutse 'iwamama yukamixa mekaneukatsanaxɨani hiwerikakɨ. Hikɨ mewaruti'ikatɨaka yupuxurima, mekaniukunuaxɨani yu'utɨma kiekaritsie. ");
INSERT INTO hch_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Kepauka Kura yu'iwama warawitɨtɨ memu'axɨa Kutse kie, yukiita payekatei 'akuxi. Hikɨ mekaniukahɨxima'uni kwiepa paitɨ hɨxiena, ");
INSERT INTO hch_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","hikɨ Kutse mɨpaɨ katiniwarutahɨawe: —¿Titayari mɨyaxenete'uyuri? ¿'Atsixekatemaikai kɨmana nemɨtimaiwe, kemɨtiyɨni 'arike? ");
INSERT INTO hch_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Kura mɨpaɨ katinita'eiya: —¿Ketsɨ'aku te'utiyuani? 'Ekɨ tati'aitɨwame pepɨhɨkɨ. Tepɨkayɨwawe temuyutahekɨata 'atsitemɨkate'uyurikɨ. Kakaɨyari kanikaxeiya tahetsie tita 'axatemɨte'uyuri, 'ena tekaniti'uka. Te'a'uximayatsiriwamete tepɨhɨmetɨni waɨriyarika, meta kemɨ'ane 'atekɨxi muyekekai. ");
INSERT INTO hch_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Kutse mɨpaɨ katinita'eiya: —Ne nepɨkayɨwe mɨpaɨ nemɨxe'uyurieni. Xewitɨ xeikɨa netsiparewiwame kanayeimɨkɨ, kemɨ'ane tekɨxi muyekekai. Hipatɨta xekaniyehuni xekayu'iyaritɨatɨ yupaapa hetsɨa. ");
INSERT INTO hch_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Kura 'ahurawa kaniuyani Kutse hɨxie, mɨpaɨ katinitahɨawe: —Pepɨkaha'aka neti'aitɨwame, 'awie nepɨmatitaxatɨanikeyu. 'Ekɨtsɨ ti'aitame pepɨmariwe yaxeikɨa Parahuni hepaɨtɨtɨ. ");
INSERT INTO hch_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","'Ekɨ pepɨtatsiku'iwawiyakai xɨka tapaapa tehexeiyani, yata'iwa xeime tehexeiyani. ");
INSERT INTO hch_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Tame tepɨmatsi'uta'ei, tapaapa 'ariri pɨ'ukiratsi. Yuniwema yuhutame pɨwarayexei, wamaama pɨyuxewikai. Xewitɨ kaniɨmɨni, xewitɨ xeikɨa kaneyeikani mutaya. Waɨkawa kaninaki'erieka tapaapa, 'ukiratsitɨtɨ meyexeikɨ. ");
INSERT INTO hch_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Merikɨte 'ekɨ pepɨtatsi'utawawiri temewitɨnikɨ pemeitimanikɨ. ");
INSERT INTO hch_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Tame mɨpaɨ teputiyua, temaikɨ pɨkaheyɨwe yupaapa meku'eirieni, yuxaɨtame xɨka heiku'eirieni hiwerikakɨ pemɨni. ");
INSERT INTO hch_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Peru 'ekɨ pepɨtarahɨawekai xɨka ta'iwa tekahawitɨnike tepɨkamatsixeiyanikekai. ");
INSERT INTO hch_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Kepauka takie temeta'axɨa tapaapa naime tepɨteheitaxatɨa kepemɨtatiutahɨawixɨ. ");
INSERT INTO hch_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","'Ariketa tapaapa mɨpaɨ katatinetahɨawe: “Xekenehu tawarita 'etsiwa tɨriku xekenenanaiyu”. ");
INSERT INTO hch_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Peru tame mɨpaɨ tepɨteheitahɨawixɨ: “Tepɨkayɨwawe temeixeiyakɨ mɨkɨ ti'aitame, xɨka ta'iwa tamuta kaheyani tahamatɨa”. ");
INSERT INTO hch_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Tapaapa mɨpaɨ pɨtaretahɨawixɨ: “Xeme xepɨtemate Xakeri matɨa yuhutame tepɨwarayexei. ");
INSERT INTO hch_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Xewitɨri nu'aya pukumawerixɨ nehetsɨa, mana mɨtiyetɨa 'anatɨtɨri nepɨka'ixeiyawe. Mɨpaɨ nepɨtiku'eriwa, xɨari yeutanaka peitakwai. ");
INSERT INTO hch_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Xɨkata 'ikɨ xehewitɨni, xɨka yɨkɨ reiyurieni, xemetsɨ pɨxehetsietɨni xɨka ne 'ukiratsi hiwerikakɨ ne'umɨni”. ");
INSERT INTO hch_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","»Xɨka nepaapa hetsɨa nehenuani, tamuta xɨka kahenuani tahamatɨa tapaapa matɨa xei'iyariyari memɨhɨkɨ, ");
INSERT INTO hch_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","tapaapa heitatɨmaiyame kanemɨmɨkɨ. Kamɨtsɨ tame tahetsie pɨrayani, xɨka tapaapa hemɨni hiwerikakɨ. ");
INSERT INTO hch_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Ne nepenehɨritɨa 'ikɨ temaikɨ tapaapa hɨxie. Mɨpaɨ nepɨreitahɨawixɨ: “Nepaapa, xɨka nekamatsi'atɨirieni 'aniwe, nehetsie kerahɨiyani 'atsita kepauka nemɨmɨni”. ");
INSERT INTO hch_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","'Ayumieme ne nepɨmatsiwawirie, 'ekɨ pemɨnetsipitɨanikɨ ne pɨta nemɨnehayewakɨ matsiparewiwame nemayani hetsienamieme. Mɨkɨ temaikɨ keneupitɨa mɨyemiekɨ yumatsikama wahamatɨa. ");
INSERT INTO hch_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Titayari nereumieni nepaapa hetsɨa xɨka temaikɨ nehamatɨa kaheyani, ne tixaɨ nepɨkaheixeiyamɨkɨ nepaapa yuhiweriekame». ");
INSERT INTO hch_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Merikɨtsɨ Kutse pɨkayɨwekairi mɨtinewienikɨ yuparewiwamete wahɨxie. Mɨpaɨ katiniwarutahɨawe: «Yunaitɨ xekenanuyekɨni 'uwa xemayetei». Nixewitɨ pɨka'uyuhayewaxɨ hamatɨana. Kepauka muyutahekɨataxɨ kename wa'iwa, ");
INSERT INTO hch_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","mɨkɨ 'ana pitsutɨa yuhiwerietɨ 'utatsuatɨ karima. 'Ekipitutari mepu'enana, yaxeikɨata Parahuni pɨtiutamari. ");
INSERT INTO hch_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Mɨpaɨ katiniwarutahɨawe yu'iwama: —Ne Kutse xe'iwa nekanihɨkɨtɨni. ¿Nepaapa 'akuxi rayeyuri? Mɨkɨ matsi mekaniutimamani mepɨkayɨwawekai memita'eiyakɨ. ");
INSERT INTO hch_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Mɨkɨ mɨpaɨ katiniwarutahɨawe: —'Ahurawa xekenakɨni. Mɨkɨ 'ahurawa mekaniukɨne. Hikɨ mɨpaɨ katiniwarutahɨawe: —Ne Kutse nekanihɨkɨtɨni, xe'iwa 'ekipitutari xemɨwarutuiri. ");
INSERT INTO hch_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Hikɨri yɨkɨ xepɨkateyɨkɨhɨaweni mɨya xemɨte'uyurikɨ. Kakaɨyari pɨta pɨtiuyuri, 'ena ne meri mɨnetsi'atɨa, para xemɨtawikwenikɨ. ");
INSERT INTO hch_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Huta wiyari panuyemie, 'ena mepɨte'uka'eniwa haakakɨ. Peru 'akuxi peuyewetse 'auxɨwime wiyari mepɨka'uka'etsani mepɨka'uka'itsanani. ");
INSERT INTO hch_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","'Ayumieme Kakaɨyari pɨnetsiheyenɨ'a meripaitɨ, xetukari mɨtawikweitsitɨarienikɨ Kakaɨyari mariwemekɨ tiyurienekaku, xetɨɨriyama meta memɨkaheuyewenikɨ 'ena kwiepa. ");
INSERT INTO hch_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Kakaɨyari pɨta pɨnetsiheyenɨ'a, xeme pɨkatixaɨ. Mɨkɨ 'ena pɨnetsi'upitɨa, yanemɨti'aitanikɨ Parahuni ti'aitame paratsiyuyata kemɨti'uximayatsieka, meta naitsarie 'Ekipitu kwieyaritsie. ");
INSERT INTO hch_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","'Ayumieme kwitɨ xekenakunuaxɨa yupaapa hetsɨa. Mɨpaɨ xeketenetaxatɨa: “'Aniwe Kutse mɨpaɨ paine: ‘Kakaɨyari pɨnetsi'upitɨa ti'aitame nemayanikɨ 'Ekipitu kwieyaritsie naitsarie. Kenamie kwitɨwa, pemɨnetsixeiyakɨ. ");
INSERT INTO hch_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Kutseheni mɨrakutewatsie xepɨkuteni, 'ekɨ 'aniwema 'amu'e'ema watewama xepiini naitɨ. Mana hurawa pepukani. ");
INSERT INTO hch_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","'Auxɨwime wiyari pɨhaakaxatɨni 'akuxi, peru ne 'ena nepɨxeparewieka 'ikwai xemexeiyanikɨ. Mexɨka mana xeheyuhayewani Kanani kwieyaritsie, naime xepɨteheuyehɨani yupiinite’”. ");
INSERT INTO hch_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Hikɨri xeme xepɨhɨme xemunenierixɨ kenemɨtixe'utahɨawixɨ hikɨ. Ne'iwata Wenikamini pɨnetsi'uxei, yapɨretima ne Kutse nemɨhɨkɨkɨ. ");
INSERT INTO hch_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Naime xeketenetaxatɨa nepaapa tita xemɨte'uxei, kenemɨtimariwe 'ena 'Ekipitu kwieyaritsie. Peru xekeneyukumexɨitɨa 'ena xemi'atɨanikɨ. ");
INSERT INTO hch_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Hikɨ Kutse yumuta Wenikamini kaniutapa, 'ana kaniutatsuani, 'iwayata yaxeikɨa. ");
INSERT INTO hch_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","'Ariketa yunaime pɨwaruti'itsi yu'iwama 'utatsuatɨ, 'anakeri mepitahɨawixɨ 'iwamama. ");
INSERT INTO hch_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Kepauka niuki mu'eni ti'aitame Parahuni, kename Kutse 'iwamama me'u'axɨa, 'ana kaniyutemawiekaitɨni, yaxeikɨata teɨterimama. ");
INSERT INTO hch_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Hikɨ Parahuni Kutse mɨpaɨ katiniutahɨawe: «Mɨpaɨ ketiniwarutahɨawi 'a'iwama: «Xekeniwaruti'ikatɨa yutewama, xekenakunuaxɨa Kanani kwieyaritsie. ");
INSERT INTO hch_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Yupaapa xekenawitɨki, yutɨɨriyama yunaime. Nehetsɨa xekenahu. Ne nepɨwaxatɨani kwie yemekɨ 'aixɨa mɨraku'ane 'ena 'Ekipitu kwieyaritsie, meta mepɨtekwaka tita yemekɨ 'aixɨa mɨti'anene yu'ikwaite mepɨtehexeiyani. ");
INSERT INTO hch_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Mɨpaɨta ketiniwarutahɨawi: Xekeniwaranuhapani kaxetate 'Ekipitutsie miemete para xemɨteha'ikatakɨ, yutɨɨriyama yu'ɨitama, meta yupaapa xematɨnikɨ. ");
INSERT INTO hch_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Xepɨkahe'iyarixieka, yupiinitekɨ tita xemɨteheku'eirieni. 'Ikɨ kwieyaritsie tita mɨtixɨawe 'aixɨa ti'anenetɨ, xepiinite katinayeimɨkɨ». ");
INSERT INTO hch_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Hikɨ mɨpaɨ mepɨte'uyuri, 'Ixaheri niwemama. Kutse kaxetate pɨwayetuiri, kemainekai Parahuni, 'ikwai pɨwarenɨ'airi huyeta mieme. ");
INSERT INTO hch_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Meta yuxexuime 'imikieri pɨwayetuiri 'ixurikite mɨhehekwa. Wenikamini pɨrata pɨyetuiri haika kiruyari raheteme, 'ixuriki meta 'auxɨwime kemariyari witsi'aneneme. ");
INSERT INTO hch_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Yaxeikɨata Kutse yupaapa pɨrenɨ'airi: tamamata 'ikayari puxuri wahetsie, tita matsi 'aixɨa mɨti'anenekai 'Ekipitu mɨtixuawe, puxuri 'ukari wahetsie tamamata 'ikayari tɨriku, meta tikwaiwame Kutse paapaya hetsiemieme huyeta mamietsiemieme. ");
INSERT INTO hch_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Merikɨ Kutse wateutɨatɨ, mɨpaɨ katiniwarutahɨawe yu'iwama, «Huyeta xepɨkaheyukwitɨweni». ");
INSERT INTO hch_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Hikɨ mɨkɨ 'iwamama mekanayekɨne 'Ekipitutsie. Kanani kwieyaritsie paitɨ mekaneta'axɨani hakewa wapaapa mekatei Kakuwu. ");
INSERT INTO hch_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Meheta'axɨaka mɨpaɨ mekatenitahɨawe: «Kutse 'apuyeika 'akuxi. Kuwexinaruri kanehɨkɨtɨni, naitsarie 'Ekipitu kwieyaritsie pɨre'aita». Kakuwu matsi pɨhɨxiyakai, yuri pɨkatiwa'eririekai, ");
INSERT INTO hch_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","perutsɨ mɨkɨ yameputiyuanekai, naime Kutse kemɨtiwaretahɨawixɨ. Hikɨ kepauka Kakuwu kaxetatsixi muwaruxei Kutse mɨwareyenɨ'a memenutɨnikɨ, 'anake puyukatemawi. ");
INSERT INTO hch_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Hikɨ mɨpaɨ kaniutayɨni: «'Aku yuri xeputiyuane. Neniwe Kutse payeniere. Nepɨyemie nepixeiyamie mexi nekamɨwe». ");
INSERT INTO hch_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Merikɨtsɨ 'Ixaheri kanayeyani, yupiinite naime ratɨtɨ, tita memɨtehexeiyakai. Kepauka Weritsewa meta'a, mawari kaniuwewieni, kemɨ'ane paapaya 'Itsahaki mɨkakaɨyarieyatɨkai. ");
INSERT INTO hch_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Mɨkɨ tɨkaritsie heinɨtsitana, Kakaɨyari 'Ixaheri mɨpaɨ katiniutaxatɨani: —Kakuwu. Kakuwu 'aku. —'Uwa nepayeka —tinita'eiya. ");
INSERT INTO hch_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Kakaɨyari mɨpaɨ katinitahɨawe: —Ne Kakaɨyari nepɨhɨkɨ, 'apaapa Kakaɨyarieya. Pepɨkaheumaka 'Ekipitu pemɨyemiekɨ. Matsi ne yumɨireme nepɨxe'ayeitɨani, mana xehekutekaku. ");
INSERT INTO hch_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Ne 'ahamatɨa nepuyeikani 'Ekipitu paitɨ. Yaxeikɨa nepɨmatsi'akunuitɨani hutarieka. Kepauka pemɨmɨximeni, Kutse pɨhɨkɨtɨni mɨmatsi'ɨwiyani, pemɨyu pɨmatsi'anuka'eima. ");
INSERT INTO hch_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Hikɨ Kakuwu kanayeyani Weritsewa mɨrakutewatsie, hikɨ 'Ixaheri niwemama mekaniyukuha'aritɨani, Kakuwu yupaapa mekananutiyeni, meta yuniwema yɨ'ɨitama mekaniwaranutiyatsa kaxetatetsie Parahuni ti'aitame mɨwareyenɨ'atsie. ");
INSERT INTO hch_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Meta mekateniware'arieni yutewama metatsiere tita memɨte'ukaxeiyakai Kanani kwieyaritsie. Mɨpaɨ Kakuwu meta nuiwarimama 'Ekipitu mekateniu'axɨani. ");
INSERT INTO hch_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Mɨkɨ yunaime kanewarewitɨni yutɨɨriyama 'ukitsi 'ukari, meta yuteukarima 'ukitsi 'ukari, yunaime yunuiwari. ");
INSERT INTO hch_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","'Ikɨ mepɨhɨme 'ixaheritsixi teɨteriyari kememɨtetetewakai, Kakuwu niwemama memeyekɨ 'Ekipitu paitɨ: Xuweni, Kakuwu matɨarieya pɨhɨkɨtɨkai. ");
INSERT INTO hch_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Xuweni niwemama mepɨtetetewakai: Kanuki, Paru, Ketsiruni meta Karimi. ");
INSERT INTO hch_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Niwemamata Tsimehuni mepɨtetetewakai: Kemueri, Kamini, 'Uhari, Kakini, Tsukaxi, meta Tsahuri, maamaya kananeu tewiyari pɨhɨkɨtɨkai. ");
INSERT INTO hch_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Rewi niwemama: Keritsuni, Kuhati, meta Merari. ");
INSERT INTO hch_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Kura niwemama: 'Exi, 'Unani, Tseraxi, Paretsi, Tsera. (Peru 'Exi matɨa 'Unani, mepekwikairi Kanani kwieyaritsie paitɨ). Paretsi niwemama: Ketsiruni meta Kamuri. ");
INSERT INTO hch_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","'Itsakaxi niwemama: Tura, Puwa, Kuwi, meta Tsimiruni. ");
INSERT INTO hch_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Tsawuruni niwemamata: Tsereri, 'Eruni, meta Yareri. ");
INSERT INTO hch_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","'Ikɨ mepɨhɨme Kakuwu Reya memɨwarayexei Parani-'Arami me'u'uwatɨ, meta waniwe Rina 'uka. Yunaitɨ mɨpaɨ mepɨyupaɨmekai, 'ukitsi 'ukari, xeitewiyari heimana tamamata heimana yuhaikatɨ. ");
INSERT INTO hch_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Kahari niwemama, Tsepuni, Kaki, 'Etsiwuni, Tsuni, 'Eri, 'Aruri, meta 'Areri. ");
INSERT INTO hch_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","'Atsexi niwemama: 'Imɨna, 'Itsiwa, 'Itsiwi, Weriya, 'iwaya 'ukatɨtɨ Tsera mɨtitewakai. Weriya niwemamata mepɨtetetewakai: Hewexi meta Marikiheri. ");
INSERT INTO hch_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Mɨkɨ mekanihɨkɨtɨni Tsiripa niwemama Kakuwu matɨa memɨwarayexei, mɨkɨ ti'uximayatame pɨhɨkɨtɨkai Rawani hetsiemieme, yuniwe Reya pɨyetɨiri hetsiena mieme mɨti'uximayakakɨ. Wanuiwari mepɨyupaɨmekai tamamata heimana 'ataxewi mekanihɨkɨtɨkaitɨni. ");
INSERT INTO hch_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Xakeri niwemama Kakuwu 'ɨyaya: Kutse meta Wenikamini. ");
INSERT INTO hch_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","'Ekipitu Kutse yuniwema pɨwarayexei, 'Atsenati matɨa Putipera nu'aya mawari wewiwame pɨhɨkɨtɨkai 'Uni mieme: Manatsexi, meta 'Epɨrahini. ");
INSERT INTO hch_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Wenikamini tɨɨriyamama: Wera, Wekexi, 'Atsiweri, Keraha, Nahamani, 'Ehi, Xutsi, Mupini, Kupini, meta 'Axi. ");
INSERT INTO hch_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","'Ikɨ mepɨhɨkɨkai Kakuwu nuiwarimama Xakeri matɨa memɨwarayexei, yunaitɨ tamamata heimana yunaukatɨ mepɨyupaɨmekai. ");
INSERT INTO hch_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Rani nu'aya pɨtitewakai: Kutsini. ");
INSERT INTO hch_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Nepɨtahari niwemama: Yatseri, Kuni, Ketsexi, meta Tsireni. ");
INSERT INTO hch_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Mɨkɨ mekanihɨkɨtɨkaitɨni Wiriha niwemama Kakuwu matɨa memɨwarayexei, mɨkɨ ti'uximayatame pɨhɨkɨtɨkai Rawani hetsiemieme, yuniwe Xakeri pɨyetɨiri hetsiena mieme mɨti'uximayakakɨ. Wanuiwari mepɨyupaɨmekai 'atahuta mekanihɨkɨtɨkaitɨni. ");
INSERT INTO hch_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Yunaitɨ Kakuwu tɨɨriyamama memu'axɨa 'Ekipitu, xeinuiwari mepɨhɨkɨtɨkai, haika tewiyari heimana 'ataxewi mepɨyupaɨmekai 'ukari meka'inɨaritɨ. ");
INSERT INTO hch_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Kutse meta yuhutame pɨwarexeiyakai yuniwema memutinunuiwakai 'Ekipitu kwieyaritsie. Mɨkɨ yunaitɨ haika tewiyari heimana tamamata mepɨyupaɨmekai Kakuwu nuiwarimama mana memu'axɨa. ");
INSERT INTO hch_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Kakuwu Kura kaniutanɨ'ani manuyehaitɨanikɨ Kutse mɨretaxatɨanikɨ, menunakekɨ Kutseheni paitɨ, kepauka mana memeta'axɨanikekai. Kepauka mana memu'axɨa, ");
INSERT INTO hch_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Kutse pɨtiuta'aitaxɨ mukuha'aritɨarienikɨ kaxetaya, 'anari mɨkɨ petɨa Kutseheni paitɨ mitahɨawekɨ yupaapa 'Ixaheri. Kepauka mixei 'anakayaka 'utanautsaka kanitapa, mana 'epɨreuterixɨ 'utatsuatɨ tapana heukunieretɨ. ");
INSERT INTO hch_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Hikɨ 'Ixaheri Kutse mɨpaɨ katiniutahɨawe: —Hikɨrixɨa nepɨmatsi'uxei nehɨxikɨ, neka'uximatɨarietɨri nepɨmɨni, 'akuxi 'apepuyeika pepayeniere. ");
INSERT INTO hch_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Mɨpaɨ Kutse yu'iwama katiniwarutahɨawe: —Tsiparatsɨ, Parahuni nepɨretaxatɨani kename xe'u'axɨari nehetsɨa ne'iwama, nepaapa niwemama Kanani kwieyaritsie memetitekai. ");
INSERT INTO hch_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Mɨpaɨ nepɨreitahɨawe kename tewaxi wahɨwemete xehɨkɨ, kename muxatsi wakaitsixi xetewa'atɨa, naime tita xemɨtehexeiyakai. ");
INSERT INTO hch_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","'Ayumieme kepauka Parahuni mɨxeta'iwawiya: “¿Ketitakɨ xete'uximayatamete?”, ");
INSERT INTO hch_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","mɨpaɨ xeketeneutahɨawi kename xeme xetehɨwemete yaxeikɨa yuteukarima wahepaɨ. Xɨka matsi mɨpaɨ xete'itahɨawe, mana xepɨyuhayewani Kutseheni mɨrakutewatsie. Mɨkɨ 'ekipitutari pɨkawanake 'ahurawa memɨtehɨrieka. ");
INSERT INTO hch_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Hikɨ Kutse katineikuxatɨani Parahuni ti'aitame. Mɨpaɨ katineitahɨawe: —Nepaapa ne'iwama mepu'axɨari, Kanani kwieyaritsie meheyekɨneka yutewama yunaime tita memɨtehexeiyakai meteha'arietɨ. Kutseheni mɨrakutewatsie mekanetiteni. ");
INSERT INTO hch_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Kutse kaniwarawitɨkɨkaitɨni yu'auxɨwime yu'iwama Parahuni xeitsitɨanike. ");
INSERT INTO hch_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Parahuni mɨpaɨ katiniwaruta'iwawiya: —¿Ketitakɨ xeme xete'uximayatamete? Mɨkɨ mɨpaɨ mekatenita'eiya: —Tame te'a'uximayatsiriwamete, muxatsi wahɨwemete tepɨhɨkɨ, yaxeikɨa meripaitɨ tateukarima kememɨte'uximayakai. ");
INSERT INTO hch_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Tame 'ena tepu'axɨa 'ikɨ kwieyaritsie, 'ɨxa memawekaikɨ Kanani kwieyaritsie, tatewama wehetsiemieme, waɨkawa pehaakaxari mɨkɨ kwieyaritsie. 'Ayumieme tepɨmatsiwawirie waɨkawamekɨ pemɨtatsipitɨanikɨ Kutseheni mɨrakutewatsie temɨtahayewakɨ. ");
INSERT INTO hch_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Hikɨ Parahuni Kutse mɨpaɨ katiniutahɨawe: —'Apaapa 'a'iwama mepu'axɨa 'ahamatɨa memu'uwanikɨ. ");
INSERT INTO hch_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","'Ekipitu kwieyari katini'ahetsiemiemetɨni. 'Aixɨa mɨraku'anetsie keniwarexatɨa mana memekutenikɨ Kutseheni mɨrakutewatsie. Meta xɨka hipame pewamaika 'aixɨa meteheutahɨiwaweme keniwarehɨritɨa netewama. ");
INSERT INTO hch_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Hikɨ Kutse yupaapa Kakuwu newitɨni, Parahuni kaniutahɨawitsitɨani. Kakuwu Parahuni 'aixɨa katiniutahɨawe, ");
INSERT INTO hch_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","'ana Parahuni mɨpaɨ katinita'iwawiya: —¿Kepaɨmeme wiyari pepexeiyari? ");
INSERT INTO hch_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Kakuwu mɨpaɨ katinita'eiya: —Xeitsienituyari heimana xeitewiyari heimana tamamata wiyari nepexeiya nekuyeikatɨ. Netukari pɨkwaniwe neka'anutinewetɨ, ne'ukiyarima netutsima kememɨteheuterixɨa. ");
INSERT INTO hch_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Hikɨ Kakuwu Parahuni kaniutateutɨani, tixaɨtɨ karayuyeitɨatɨ. ");
INSERT INTO hch_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Hikɨ Kutse yupaapa yu'iwama kaniwayetuirieni kwie 'Ekipitu kwieyari 'aixɨa mɨraku'anetsie, Parahuni kemutayɨkai Kutseheni mɨrakutewatsie, 'arikeke Xamɨtsexi mɨtiuterɨwarie. ");
INSERT INTO hch_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Kutse katiniwamikwakaitɨni yupaapa yu'iwama watɨɨriyama, yuxexuitɨ kememɨteheuyehɨakai. ");
INSERT INTO hch_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Merikɨtsɨ haaka kaniwekaitɨni 'Ekipitu, yaxeikɨa Kanani. 'Ikwai katiniumawekaitɨni naitsarie, teɨteri mekanikwiximekaitɨni. ");
INSERT INTO hch_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Naime pɨrata 'Ekipitu kiekatari meta Kanani kiekatari kɨmana yu'ikwai memunanekai, Kutse kaniwaye'ɨni Parahuni kiita neita'ɨna. ");
INSERT INTO hch_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Kepauka 'Ekipitu kiekatari meta Kanani kiekatari pɨratakɨ memu'ixɨa, Kutse hetsɨa mekaniu'axɨani mɨpaɨ me'utiyuatɨ: —'Ikwai ketaneumikwa. Tepɨkwixime haakakɨ 'ahɨxie, pɨratari tepɨkahexeiya. ");
INSERT INTO hch_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Kutse kaniwaruta'eiya: —Xɨka pɨrata xekahexeiyaniri, yutewama xekeniwarahapani, nepɨtixepatsirieni 'ikwaikɨ. ");
INSERT INTO hch_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Hikɨ 'ekipitutari yutewama Kutse mekaniyetuirieni, wakaitsixi, kawayutsixi, muxatsi, puxuri, tsipuri, Kutse tɨrikukɨ katiniwapatsiriekaitɨni mɨkɨ wiyaritsie. ");
INSERT INTO hch_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Hairieka wiyaritsie Kutse mɨpaɨ mekateniutahɨawe: —'Ekɨ pepɨti'aitame, temɨte'anukanaka pɨkayɨwe, pɨrata tepɨkahexeiyari, tatewama 'atewama mepɨhɨkɨri, tixaɨtɨri tepɨkatehexeiya. Tame xeikɨari meta kwie temexeiya. ");
INSERT INTO hch_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","'Ekɨ pepɨkatatsipitɨaka temɨkwinikɨ, takwie meta kapa reuyewenikɨ. Ketaneutinanai 'ekɨ takwie mame, petipatatɨ 'ikwaikɨ. Mɨpaɨ Parahuni te'uximayatametemama tepɨhɨkɨtɨni takwie teyunaitɨ. Mɨpaɨ teteyurieme 'ekɨ, 'imɨari pemɨtatsitɨkitɨani temayeyuyurinikɨ, 'akuxi takwie yuxaɨta mɨkayukuhayeikawanikɨ. ");
INSERT INTO hch_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Hikɨ mɨpaɨ tiuyɨku, Kutse 'Ekipitu kwieyari kaniunaneni naime Parahuni hetsiemieme, 'ekipitutari meyehaakakwitɨwetɨ memituirikɨ naime yukwie. Mɨpaɨ tiuyɨku, naitɨ 'Ekipitu kwieyari Parahuni tipiinieya katinayani. ");
INSERT INTO hch_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","'Ana yunaitɨ 'ekipitutari waɨriyarika te'uximayatamete mekanakɨne. ");
INSERT INTO hch_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Kutse mawari wewiwamete wakwie pɨka'unanai. Parahuni mɨtiwamikwakaikɨ, 'ayumieme yukwie mepɨka'utua. ");
INSERT INTO hch_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Hikɨ Kutse teɨteri mɨpaɨ katiniwarutahɨawe: —Hikɨtɨtɨ xeme meta xekwie, Parahuni hetsɨa xekanimiemetetɨni ne nemɨxe'utinanaikɨ. Kamɨ 'imɨari xekeneuka'etsa. ");
INSERT INTO hch_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Kepauka 'itsanaxa mayani, 'auxɨwimexɨa tixeɨriekame xepɨtiwewieni yaxeikɨa papaɨmeme, xeime Parahuni xekaniyetuiriekuni, xemerita naukame xemɨtekwakakɨ, meta xemɨka'enitsiemieme. ");
INSERT INTO hch_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Teɨteri mɨpaɨ mekaniutiyuani: —'Ekɨ pepɨtatsi'utawikweitsitɨa, waɨkawa pepɨtatsi'uparewi. Parahuni te'uximayatsiriwamete tepɨhɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Kutse mɨkɨ 'inɨari, 'aitsika kanayeitɨani naitsarie 'Ekipitu kwieyaritsie. Hikɨ 'akuxi kaneyuhekɨaka yapaɨmetɨ Parahuni tsiemieme kanayeikani. Perutsɨ mawari wewiwamete xeikɨa wakwie Parahuni tipiinieya pɨkaratɨa. ");
INSERT INTO hch_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Hikɨ 'ixaheritsixi 'Ekipitu mekanitiyaxe Kutseheni mɨrakutewatsie. Mana waɨkawa metehexeiyatɨ mekanakɨne, waɨkawa mekaniutamɨire. ");
INSERT INTO hch_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Kakuwu tamamata heimana 'atahuta wiyari 'Ekipitu kaniukateitɨni. Xeitsienituyari heimana huta tewiyari heimana 'atahuta wiyari kaniutihuni. ");
INSERT INTO hch_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Kepauka 'Ixaheri mɨximetɨ, Kutse katiniutanɨ'airieni. Mɨpaɨ katinitahɨawe: —Xɨka 'aheyemekɨ penetsinaki'erieka, neteuritɨa keneutame'i 'inɨari mayanikɨ kename yapemɨtikayani, yakenetineutahɨawi yuri pe'utaitɨ, pemɨkanetsikateukunikɨ 'Ekipitu. ");
INSERT INTO hch_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Kepauka nemɨmɨni, ne'ukiyarima wahetsɨa kenenetuamie, 'Ekipitu pepɨkanetsi'ukateukuni. Kutse mɨpaɨ katinita'eiya: —Kepemaine yanepɨtikayani. ");
INSERT INTO hch_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Paapaya tawarita kanita'iwawiya: —Xɨka yapetikayeimɨkɨ yakenetineutahɨawi heitseriemekɨ Kakaɨyari matsi'eniekaku. Kutse yatinitahɨawe. Hikɨ 'Ixaheri yu'utatsie kakaitɨ 'utihɨximakeka kaniyutanenewieni. ");
INSERT INTO hch_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Merikɨtsɨ 'arike Kutse katiniutamarieni kename paapaya rekuye. Hikɨ kaneyani yuniwema warawitɨtɨ Manatsexi 'Epɨrahini mame. ");
INSERT INTO hch_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Kepauka Kakuwu mɨretima, waɨriyarika kananukuyerɨni yu'utatsie. ");
INSERT INTO hch_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Kutse kaniutahɨawe mɨpaɨ 'utaitɨ: —Kakaɨyari Naimekɨmɨtɨrɨkaɨye kaneniutahɨawe Rutsi kiekaritsie, Kanani kwieyaritsie. 'Aixɨa kaneniuyurieni, ");
INSERT INTO hch_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","mɨpaɨ 'utaitɨ: «Ne yanepɨtiyurieni waɨkawa tɨɨri pemɨwarayexeiyakɨ, pemɨtamɨirekɨ, 'anuiwaritsie yuwaɨkawatɨ nuiwarite mepayenexɨani. 'Ikɨ kwie yuheyemekɨ puwakwietɨni». ");
INSERT INTO hch_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Merikɨte 'aniwema memuyuhuta 'Ekipitu pemɨwarayexei nekamatsitahɨawiwekaku 'akuxi, mepɨneniwematɨni. 'Epɨrahini Manatsexi yuheyeme mepɨneniwematɨni yaxeikɨa Xuweni meta Tsimehuni kememɨneteniwema. ");
INSERT INTO hch_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Mɨkɨ wa'utɨmake pemɨwarayexeiya mepɨ'aniwematɨni, kwie memɨyetuiriyarienitsie wamatsikama mɨkɨta mana mepɨwayetuirieni. ");
INSERT INTO hch_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Parani-'Arami ne'akunuaku, Xakeri 'amaama kanemɨni 'Epɨrata 'aurie, hikɨ Wereni mɨrakutewa, mɨkɨ huyeyari'utɨa tekaneikateuku, Kanani kwieyaritsie. ");
INSERT INTO hch_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Hikɨ 'Ixaheri Kutse niwemama waruxeiyaka, mɨpaɨ katiniuta'iwauni: —¿Mɨkɨ temari kemɨ'ane mepɨyɨa? ");
INSERT INTO hch_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Kutse yupaapa mɨpaɨ katiniutahɨawe: —Mɨkɨ neniwema mepɨhɨkɨ Kakaɨyari mɨnetsiheyenɨ'airi 'ena memutinunuiwaxɨ. Hikɨ 'Ixaheri yuniwe mɨpaɨ katiniutahɨawe: —'Enahurawa keniwati'uitɨa nemɨyutanenewienikɨ wahetsiemieme. ");
INSERT INTO hch_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","'Ixaheri matsi kani'ukiratsitɨkaitɨniri, pɨkahaunierekairi. 'Ayumieme Kutse 'ahurawa kaniwati'uitɨani yuniwema. Paapaya kaniwaruti'itseni kaniwarutitapa. ");
INSERT INTO hch_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Hikɨ Kutse mɨpaɨta katiniutahɨawe: —Neri tawarita nekamatsixeiyake nepɨne'eriekai. Matsi hikɨ Kakaɨyari pɨnetsi'upitɨa meta 'aniwemata nemɨwaxeiyakɨ. ");
INSERT INTO hch_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Hikɨ Kutse yuniwema kaniwaranukuhapani yupaapa hɨxie, mɨkɨta kaniutihɨximakeni. ");
INSERT INTO hch_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","'Anukukeka yuniwe 'Epɨrahini yutseriekɨ kaniuwiya, yu'utakɨta Manatsexi. Hikɨ yupaapa hɨxie kaniwati'uitɨani, 'Epɨrahini 'etsimutewikaikɨ, yuteukari 'Ixaheri 'utata mutikenikɨ, Manatsexi mɨmatsikayatɨkaikɨ yuteukari tserieta mutikenikɨ. ");
INSERT INTO hch_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Peru wateukari 'Ixaheri yutanenenewienike yumamate kaniupataxɨani, 'Epɨrahini hetsɨa yutseriekɨ heimana kaneutimeni tsepa 'etsimutewikai, Manatsexi hetsɨata yu'utata miemekɨ pɨtiunakixɨ tsepa mɨmatsikayatɨkai. ");
INSERT INTO hch_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Kanitsutɨani mɨpaɨ 'utaitɨ: «Kakaɨyari 'aku, 'Apɨrahami 'Itsahaki 'ahamatɨa kememɨte'u'uwakai, pemɨnetsi'ɨwiya kepaukapai nemutinuiwaxɨ, mana mɨtiyetɨa meta hikɨ. ");
INSERT INTO hch_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Niuki tuayame mɨnetsi'utawikweitsitɨa naime 'axamɨti'anetsie, 'aixɨa keniwayurieka 'ikɨ tɨɨri. 'Uxa'atɨni warie nepaxaxatsiwani, yaxeikɨata ne'ukiyarima 'Apɨrahami 'Itsahaki wahepaɨ. Xeke'utiwawere xeke'utaxiɨni 'ena kwiepa». ");
INSERT INTO hch_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Hikɨ Kutse pɨka'inakixɨ yupaapa xeiyatɨ, 'Epɨrahini mutayatsie meutimekaikɨ yutseriekɨ. Yupaapa mamaya 'uwiyaka, kanipata Manatsexi hetsie pɨta, ");
INSERT INTO hch_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","mɨpaɨ rehɨawetɨ: —Nepaapa, tixaɨ mɨpaɨ neniwe 'amɨyumate, Manatsexi pɨhɨkɨ. 'Atserieta miemekɨ mana pɨta keneutime'i. ");
INSERT INTO hch_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Perutsɨ paapaya yapɨkatiutanaki'eri. Mɨpaɨ katinitahɨawe yuniwe: —Ne nepɨtimate Manatsexi kiekarieya mariwetɨ kanayeimɨkɨ, matsi mutaya pɨta waɨkawa kanitaxiɨmɨkɨ, nuiwaritemama kiekari makate mekanakɨnikuni. ");
INSERT INTO hch_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Mɨkɨ tukaritsie Kakuwu 'aixɨa kaniwaruyurieni mɨpaɨ 'utaitɨ: «Kepauka nenuiwarima xeime hepaɨtsita 'aixɨa memutiyuaneni, mɨpaɨ mepɨtekɨhɨawarɨwani: “Kakaɨyari kematsi'ɨwiyani. Kemɨtiwa'ɨwiyakai 'Epɨrahini meta Manatsexi”». Mɨpaɨ 'utayɨka, 'Ixaheri 'Epɨrahini mexɨakame kanayeitɨani 'arike Manatsexi. ");
INSERT INTO hch_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Hikɨ 'imatɨrieka 'Ixaheri Kutse mɨpaɨ katiniutahɨawe: —Pehurari nemɨmɨnikɨ, perutsɨ Kakaɨyari xehamatɨa kaniuyeikamɨkɨ, kanixe'akunuitɨamɨkɨ xeteukarima wakwietsie. ");
INSERT INTO hch_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","'Ekɨ Kutse 'a'iwama wahetsiemieme heitserie pepexeiya waɨkawa, nepɨmatsixatɨa Tsikeni kwieyari, 'amuxeutsixi teɨteriyari nemɨwarunawairi newakwinetɨ. ");
INSERT INTO hch_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Merikɨtsɨ Kakuwu yuniwema kaniwarutakwewieni, mɨpaɨ katiniwarutahɨawe: «Xekeneuyukuxeɨri nepɨtixetaxatɨani kemɨtiyɨni xehetsie. ");
INSERT INTO hch_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","»Neniwema: 'Ahurawa xekenakɨni, xekeneneu'eni kenemɨtixetahɨawe. ");
INSERT INTO hch_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","»'Ekɨ meri Xuweni pemɨnematɨari, 'akɨmana meri pɨmatsiɨkɨkai kenemɨtitɨrɨkaɨyekai tɨɨri nemɨwarexeiyanikɨ. 'Ekɨ matsi heitserie pepexeiya, 'Ekɨ matsi pepɨtɨrɨkaɨye. ");
INSERT INTO hch_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Perutsɨ 'ekɨ mexɨakame pepɨkahɨkɨtɨniri: 'Axapemɨnetsi'uyurikɨ. Ne'ɨya matɨa pemukahuikɨ neti'uximayatsiriwame, 'ayumieme hamewari mɨkayunɨtɨarinɨa hepaɨ pepɨ'aneni. ");
INSERT INTO hch_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","»Tsimehuni matɨa Rewi yawixi memayu'eririya wahepaɨ mekani'aneneni, yu'ixiparakɨ mepɨteyumemiwa. ");
INSERT INTO hch_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Ne wahetsɨa nepɨkaheu'ixɨaramɨkɨ. Kapa 'axatiyuruwame hepaɨ netiuxeiyarienikɨ. Yuhaxɨakɨ teɨteri mepɨwarukwi, mewaikatɨwetɨ tuurutsixi mepɨwarutixite wa'ɨkatetsie. ");
INSERT INTO hch_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Wahaxɨa 'axake'itɨarieka kememɨteyumemiwa, yuhaxɨakɨ pɨwanake hiwerika memɨwapitɨakakɨ hipame. Ne nepɨwatanɨ'axɨani nekwiepa, nepɨwataxɨriexɨani 'Ixaheri kwieyaritsie. ");
INSERT INTO hch_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","»'Ekɨ Kura, 'a'iwama 'aixɨa meputiyuaneni 'ahetsiemieme. Memɨmatsi'aye'unie pepɨwara'iwani, 'ahɨxie mepɨtitunuma'uni 'a'iwamatɨtɨ. ");
INSERT INTO hch_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Neniwe Kura, maye temaikɨ hepaɨ pepɨ'ane, maxa muwiyarie mɨkwa'a hepaɨ. Maye 'amɨpa hepaɨ, pe'itakwaka pehakunuaka pemanuhuputsie pekaniyuhayewa. Maye 'uka hepaɨ, xewitɨ pɨkayɨwe mɨmatsi'uximatɨanikɨ. ");
INSERT INTO hch_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Kura xewitɨ pɨka'inawairieni ti'aitame 'itsɨya, nuiwarimama yuheyemekɨ mepɨteta'aita. Kepaukake munuani yurikɨ ti'aitame, 'aixɨa mɨtiuka'iyari meuyewetse hɨxiena yamemɨtekahunikɨ kwiepa memɨtama. ");
INSERT INTO hch_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Kura kaxie waɨkawa pexeiya. 'Ayumieme yupuxu pakuwiwa kaxie kɨyeyaritsie, meta puxu nunutsi pikwa'a kaxie xawariyari. Yu'ixurikite pɨti'ekwa kaxie winuyaritsie, yɨ'ɨkarite kaxie takari hayariyaritsie piti'ekwa. ");
INSERT INTO hch_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Kaxie winuyari waɨkawa pexeiya, 'ayumieme hɨxiteya pɨyɨyɨwi. Retsi kemɨtituxa, matsi waɨkawa putuxa tameteya. ");
INSERT INTO hch_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","»Tsawuruni haramara tetsita kiekame kanayeimɨkɨ, nawiyatsixi mɨwa'axe 'aixɨa mɨtiuye'ane kanayeimɨkɨ, Tsiruni paitɨ kwieya kaniye'atɨkaimɨkɨ. ");
INSERT INTO hch_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","»'Itsakaxi puxu hepaɨ pɨranuweri, peru naitsata heuti'ikatɨkaitɨ 'apuka. ");
INSERT INTO hch_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Kepauka mixei yukuraru 'aixɨa tiuye'anekame, kwiepa 'aixɨa raku'anekame mɨka'uxipienikɨ, puyuwaɨri 'ika matɨkɨnikɨ, ti'uximayatame payuyeitɨa. ");
INSERT INTO hch_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","»Rani 'itsɨkame hepaɨ pɨtiyurieni yuteɨterima wahetsiemieme 'Ixaheri nuiwaritemama watsata. ");
INSERT INTO hch_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Rani pɨtɨrɨkaɨyeni, kuu mɨtiyumemiwa hepaɨ huyeta mɨkaka, kepauka kawayu 'ɨkayatsie mɨtakeni, manaka yuwarima peukaweni. ");
INSERT INTO hch_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","»Yawé 'aku 'awikweitsitɨarika nepɨtakwewie. ");
INSERT INTO hch_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","»Kahari, tenawayamete memanitamiekuni, matsi mɨkɨ wawarita kanakuyeimɨkɨ kaniwakwimɨkɨ. ");
INSERT INTO hch_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","»'Ekɨta 'Atsexi, 'ikwai 'aixɨa ra'anekame pepɨtikwa'a, 'aixɨa ra'anekame petiukawewiwatɨ pepɨtiwamikwani kwiepa te'aitamete. ");
INSERT INTO hch_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","»Nepɨtahari, maxa 'uka yuxaɨta muyeikani hepaɨ pɨ'aneni, maxatsi tɨɨrixi witsimemɨ'anene yumaama wahepaɨ. ");
INSERT INTO hch_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","»Kutse, hatetsita 'iteɨritsiekame hepaɨ pɨ'ane, waɨkawa mɨyɨra, mamateya kurarutsie manutimake hepaɨ. ");
INSERT INTO hch_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Kuyaxi tupi memu'ɨ mekanitamɨni, mekaheinenimayatɨ me'ihekatɨ. ");
INSERT INTO hch_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Perutsɨ Kutse yutupi heitserie pakwe'e, mamateya pɨka'akatutuke. Pamɨpariyutsi Kakuwu kakaɨyarieya pemɨtɨrɨkaɨye, pemɨtatsi'ɨwiyame 'ixaheritsixi, tete mɨtse'i hepaɨ. ");
INSERT INTO hch_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Neuxei Kutse: Pamɨpariyutsi 'apaapa Kakaɨyarieya mɨmatsiparewie. Pamɨpariyutsi Kakaɨyari Naimekɨmɨtɨrɨkaɨye, 'aixɨa mɨmatsiyurie. Ke 'aixɨa mɨmatsiyurie taheima miemekɨ wiyerikɨta, matsipitɨatɨ meta 'emeukatewatsie miemekɨ haixakɨ, niwekate tɨɨri kememɨtewarayexexeiya kememɨtewatsitsitɨa. ");
INSERT INTO hch_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Matsi 'aixɨa pɨti'anene tita 'apaapa nehɨkɨtɨtɨ nematiyetuirie, hɨri ke 'aixɨa mɨtipitɨarie meripaitɨ mieme reutiyetana, matsi waɨkawa 'aixɨa peke'itɨarieka. Hikɨ 'aixɨa kenemɨmatsiyurie pɨ'ahetsiemieme Kutse, 'a'iwama watsata pepanayexeiyarie. ");
INSERT INTO hch_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","»Wenikamini, 'ɨrawe mayu'eriya hepaɨ pɨ'ane, ximeri tikwatɨ tita mɨtiumi, taikaita hipame pɨtiwamikwa tita mɨtiutatexi». ");
INSERT INTO hch_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Mɨpaɨ katiniwarutahɨawe 'Ixaheri yuniwema, tamamata heimana huta nuiwariyari, yuxexuime 'aixɨa kaniwaruyurieni, yuhetsie memeixeiyanikɨ. ");
INSERT INTO hch_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","'Imatɨrieka Kakuwu mɨpaɨ katiniwarutahɨawe yuniwema: «'Ariri nekanimɨximeni, kepauka nemɨmɨni. Nepaapama memuyehetsie xekeneneutateka, terɨta 'Epuruni Heti tewiyari mɨkwieyatɨkaitsie. ");
INSERT INTO hch_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Terɨ Makipera nekanixatani Mamɨre hɨxie mɨti'ane, Kanani kwieyaritsie 'Apɨrahami minanai, 'Epuruni Heti tewiyari kaniunanairieni, yunaitɨ tɨɨriyamama muwa memeutatuariwanikɨ. ");
INSERT INTO hch_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Muwa mekanayeheni 'Apɨrahami, 'ɨyaya Tsara, 'Itsahaki, 'ɨyaya Xeweka, muwa tsiere Reya neneutateni. ");
INSERT INTO hch_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Mɨkɨ kwie terɨ kaniunanaiyani, Heti teɨteriyari meri katiniwapiinitɨkaitɨni». ");
INSERT INTO hch_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Kepauka mɨtiutahayewaxɨ Kakuwu yuniwema tiwakuxaxatɨwatɨ, 'ukahuka 'imatɨrieka kaniuka'ietɨyani kaniumɨni. Kaneyani yu'ukiyarima wahetsɨa. ");
INSERT INTO hch_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Merikɨtsɨ Kutse yupaapa kaniutapa, 'utatsuatɨ kani'itseni. ");
INSERT INTO hch_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Hikɨ katiniwaruta'aitɨani Kutse teyu'uayemawamete, memita'uayemanikɨ waritsamu witsimu'ɨakɨ paapaya kaxarieya, hikɨ mɨpaɨ mekateniuyurieni. ");
INSERT INTO hch_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Mepeye'atɨa huta tewiyari tukari, mɨpaɨ mepɨtewaraye'atɨwakai memɨwati'uayemawanikɨ wakaxarite. 'Ekipitutari haika tewiyari heimana tamamata tukari mepɨyuhiweriekai. ");
INSERT INTO hch_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Hiwerika 'anuyeyaku, Kutse kaniwarutahɨawe Parahuni parewiwametemama, mɨpaɨ katiniwarutahɨawe: —Ximɨxi Parahuni mɨpaɨ xeketenetahɨawi, ");
INSERT INTO hch_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","kepauka nepaapa mɨmɨximekai, mɨpaɨ pɨnetiuhɨritɨa, kename nekeheiteukimienike 'ukiyarimama memɨwayehetsie, Kanani kwieyaritsie paitɨ. Mɨpaɨ xeketenetawawiri Parahuni, nemiteukimiekɨ, kenameta ne'akunuani. ");
INSERT INTO hch_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Parahuni mɨpaɨ katinita'eiya: ―Kenemie, 'apaapa keneuteukimie, kemɨmatiutahɨawixɨ. ");
INSERT INTO hch_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Merikɨtsɨ Kutse kaneyani yupaapa mekateukukɨ. Yunaitɨ mekanekɨne 'iwamama, watɨɨriyama, yaxeikɨa 'ekipitutari 'ukirawetsixi memiteɨtakai Parahuni, 'ekipitutari wa'ukiyarima yunaitɨ. ");
INSERT INTO hch_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Yunaitɨ Kutse kie kiekatari, meta 'iwamama, meta paapaya kie kiekatari. Mekanekɨne, yutɨɨriyama xeikɨa mepɨwareku'eiri Kutseheni kwieyaritsie, yumuxatsima meta yuwakaitsixi. ");
INSERT INTO hch_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Mepanutiyaxixɨa kaxetatetsie, kawayutsixi wahetsie me'utetɨta, waɨkawa 'ame'atayeutɨ mekaniuhukaitɨni. ");
INSERT INTO hch_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Mekaneta'axɨani hakewa Hatahari tɨriku matihenatsie, mana Kurutani hatuxameyaritsie pehurakai. Mana Kutse 'atahuta tukari pɨyuhiweriekai paapaya mumɨkɨ. ");
INSERT INTO hch_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Kepauka kananeutsixi memɨwaruxei meyuxeɨriekame Hatahari maka'etsatsie me'utitsuaname, mɨpaɨ mekaniutiyuani: «'Ekipitutari hiwerika mepɨwewie yemekɨ waɨkawa patsiekamekɨ». 'Ayumieme mana, Kurutani meuhuratsie, mekateniuterɨwa 'Aweri-Mitsirahini. ");
INSERT INTO hch_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Hikɨ mɨpaɨ mekateniuyurieni Kakuwu niwemama kemɨtiwarutahɨawekai meripaitɨ. ");
INSERT INTO hch_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Mekaneikweni Kanani paitɨ, mana mekaneitateni terɨta Makipera kwieyaritsie, Mamɨre hɨxie, hikɨ Hewuruni mɨrakutewatsie, 'Apɨrahami meripaitɨ minanekai mɨkɨ terɨ 'Epuruni Heti tewiyari 'ituirieku, 'Apɨrahami tɨɨriyamama wateukiya mayanikɨ. ");
INSERT INTO hch_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Hikɨ Kutse kanakunuani 'Ekipitupai yupaapa hekateukuka, yu'iwama wahamatɨa, meyunaitɨ memeiweiyakai wahamatɨa. ");
INSERT INTO hch_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Kakuwu 'ukumawereku, Kutse 'iwamama mɨpaɨ mekateniyukuhɨawekaitɨni: «Xɨari pɨha'a tahepaɨtsita. Xɨari puyukɨhɨani 'axaketemiyuri». ");
INSERT INTO hch_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","'Ayumieme mɨpaɨ mekatenitanɨ'airieni mɨpaɨ mete'itahɨaweke: «'Apaapa kamɨwetɨ 'akuxi mɨpaɨ pɨtatiuhɨritɨa: ");
INSERT INTO hch_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","“Mɨpaɨ Kutse xeketeneutahɨawi, kexereuyehɨwirieka 'axakexemiyuri 'iwamama”. 'Ayumieme kwerietɨxɨa ketatineuyehɨwirieka, tame 'apaapa Kakaɨyarieya te'uximayatametemama tepɨhɨkɨ». Kepauka Kutse 'ikɨ niuki mu'eni, kaniutatsuani. ");
INSERT INTO hch_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Hikɨ 'iwamama mekaniu'axɨani, mekaniutihɨxima'uni hɨxiena, mɨpaɨ mekatenitahɨawe: —'Ena pepɨtatsiti'uitɨa, waɨriyarika mate'uximayatsiriwamete tepɨhɨkɨ. ");
INSERT INTO hch_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Kutse mɨpaɨ katiniwarutahɨawe: —Xepɨkamamaka. Ne Kakaɨyari nemaneyeitɨwani nepɨkayɨwe. ");
INSERT INTO hch_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Yurikɨ xeme xepɨnetsi'unanaimakai, peru Kakaɨyari pipataxɨ 'aixɨa mɨti'anekɨ, yamɨtiyɨnikɨ hikɨ ketemɨteneniere: yɨmɨiretɨ teɨteri memɨkaheuyewenikɨ. ");
INSERT INTO hch_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","'Ayumieme, hikɨ xepɨkaheumamaka. Ne nepɨxeparewieka xeme meta xetɨɨriyama. Kutse mɨpaɨ katiniwarunɨtɨani, wanaki'erietɨ waɨkawa. ");
INSERT INTO hch_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Kutse meta paapaya tɨɨriyamama 'Ekipitu kwieyaritsie mekaniuyuhayewa. Kutse xeitsienituyari heimana tamamata wiyari kaniutihuni, ");
INSERT INTO hch_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","kaniwaruxeiya 'Epɨrahini niwemama meta yututsima. Metatsiere Makixi niwemama yuniwema kaniwarayeitɨani Manatsexi teukarimama. ");
INSERT INTO hch_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Hikɨ 'arikemɨkake, Kutse mɨpaɨ katiniwarutahɨawe yu'iwama: «'Etsiwa xeikɨari peuyewetse nemɨmɨnikɨ, peru Kakaɨyari kanixeparewiekamɨkɨ, kanixe'ayewitɨmɨkɨ 'ikɨ kwieyaritsie kanixe'anuwitɨmɨkɨ kwie 'Apɨrahami, 'Itsahaki meta Kakuwu mɨwaxatɨakaitsie». ");
INSERT INTO hch_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Hikɨ Kutse mɨpaɨ katiniwaruhɨritɨani yuniwema: «Kaniyuritɨni Kakaɨyari kanixeparewimɨkɨ. Kepauka mɨpaɨ mɨtiyɨni 'ana ne'umeyarite xekananutɨkuni». ");
INSERT INTO hch_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Kutse kaniumɨni xeitsienituyari heimana tamamata wiyari hexeiyatɨ, 'Ekipitu kwieyaritsie. Waiyarieya me'uta'uayemaka waritsamu witsimu'ɨakɨ, kakuni witsimɨ'anetsie mekanikateni. ");
INSERT INTO hch_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","'Ikɨ mekanihɨkɨtɨni 'Ixaheri niwemama, kepauka yuniwema mewaruwitɨtɨ memu'axɨa 'Ekipitu, Kakuwu yunaitɨ: ");
INSERT INTO hch_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Xuweni, Tsimehuni, Rewi, Kura, ");
INSERT INTO hch_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","'Itsakaxi, Tsawuruni, Wenikamini, ");
INSERT INTO hch_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Rani, Nepɨtahari, Kahari meta 'Atsexi. ");
INSERT INTO hch_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Yunaitɨ Kakuwu nuiwarimama mepɨhɨkɨtɨkai, haika tewiyari heimana tamamata. 'Ekipitu paitɨri Kutse pukatei. ");
INSERT INTO hch_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Hikɨ Kutse meta 'iwamama mekaniukwini meta mɨkɨ xiɨyarimama yunaitɨ. ");
INSERT INTO hch_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Peru matsi 'ixaheritsixi, waɨkawa tɨɨri mekaniwarayexeiyakaitɨni, yumɨiretɨ mekanakɨne metɨrɨkaɨyetɨ, mɨkɨ kwieyaritsie mekanakɨnɨximekaitɨni. Kiekari 'ayeutɨ kanayeiximekaitɨni. ");
INSERT INTO hch_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Hikɨ 'Ekipitu xewitɨ pɨta ti'aitame kananukakeni Kutse mɨkahetimaikai kemɨtiuyuri, ");
INSERT INTO hch_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","mɨpaɨ katiniwarutahɨawe yuteɨterima: «Xekeneyukweriwayurieka 'ixaheritsixi wahepaɨtsita, waɨkawa tɨrɨkariya mekanexeiyani, mekaniyɨmɨireniri mekatana'iwani. ");
INSERT INTO hch_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Hikɨ tekateniwata'aitɨakuni waɨkawamekɨ tetemaiwawetɨ, xɨka mɨpaɨ tekate'uyurieni matsi waɨkawa mepɨtamɨire, xɨka kuyaxa hayani, memɨtatsi'aye'unieta pɨta mekanakɨnikuni, metatsi'a'iwame mekaniyehuni 'ikɨ kwieyaritsie». ");
INSERT INTO hch_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Mɨpaɨ mekateniuyurieni 'ekipitutari, te'aitamete mekaniwarutihɨawe 'ixaheritsixi memɨtewata'aitɨanikɨ, 'uximayatsika mekaniwaruxatɨani waɨriyarika mewapitɨatɨ, Parahuni hetsiemieme kiekari 'ikwai mɨreuta'ɨnarɨwa Pituni mɨtitewa meta Xamɨtsexi. ");
INSERT INTO hch_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Peru matsi mɨyamewaruyurieku, matsi waɨkawa mekanixiɨkaitɨni mepɨtamɨirirɨmekai, hikɨ 'ekipitutsixi waɨkawa mekaniwarutimakani. ");
INSERT INTO hch_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","'Ayumieme kwinimieme mekateniwa'uximayatsitɨakaitɨni, kemɨkareuyewetse hepaɨ mekateniwa'aitɨakaitɨni. ");
INSERT INTO hch_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Watukari waɨkawa mekaninanaimakaitɨni, waɨriyarika metewa'aitɨatɨ, kwie memɨhawiyanikɨ, xɨnariya wewiyarikɨ, naime mɨrati'etsiwatsie, tita 'uximayatsika mɨraniere, naime 'uximayatsikatsie 'ixaheritsixi memɨteha'uximayakai 'ekipitutari mewarutate'atɨ mekateniwa'aitɨakaitɨni. ");
INSERT INTO hch_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Mana mekanititekaitɨni yuhutatɨ 'ukarawetsixi hepɨrayutsixi teɨteriyari teniweritsitɨwamete, Tsipura meta Puwa metetetewatɨ, ti'aitame 'Ekipitu kiekame mɨpaɨ katiniwaruta'aitɨani: ");
INSERT INTO hch_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","—Kepauka 'ukarawetsixi hepɨrayutsixi xemɨwaparewie niweriyakɨ, xeyu'ɨwiyatɨ tita mɨtitinuiwa: xɨka 'ukitɨni xewatakukuyatɨ, xɨka 'ukatɨni xekenehayewa 'ayeniereme. ");
INSERT INTO hch_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Peru 'ukarawetsixi teniweritsitɨwamete hepɨrayutsixi Kakaɨyari mekanayemakakaitɨni, 'ayumieme ti'aitame 'Ekipitu kiekame kemɨtiwarahɨawekai yamepɨkate'uyuri, 'ukitsi mekaniwaruhayewa me'ayeneniereme. ");
INSERT INTO hch_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Hikɨ 'Ekipitu kwieyaritsie ti'aitame, mɨkɨ 'ukarawetsixi teniweritsitɨwamete kaniwarutakwewieni, mɨpaɨ katiniwaruta'iwawiya: —¿Titayari mɨya xeteheyurie? ¿Titayari tɨɨri 'ukitsi xekatewatakukuya? ");
INSERT INTO hch_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Mɨkɨ mɨpaɨ mekaniutiyuani: —Neuxeitsɨ, 'ukari hepɨrayutsixi 'ukarawetsixi 'ekipitutari wahepaɨ mepɨka'anene, mɨkɨ waɨkawa mepɨtɨrɨkawi yuxaɨta mepɨtiniweya tame teka'aye'axɨaximekaku. ");
INSERT INTO hch_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Mɨpaɨ tiuyɨku, matsi 'ixaheritsixi waɨkawa mekaniyutamɨiriya. Meta Kakaɨyari mɨkɨ teniweritsitɨwamete 'aixɨa katiniwaruxeiya, ");
INSERT INTO hch_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Kakaɨyari memayemakakaikɨ, kaniwarupitɨani tɨɨri waɨkawa memɨwarayexeiyakɨ. ");
INSERT INTO hch_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Hikɨ Parahuni mɨpaɨ katiniwaruta'aitɨani yuteɨterima: —Yunaime tɨɨri 'ukitsi hepɨrayutsixi hapa xekeniwareukaxɨri memɨtinunuiwa. 'Ukari xekeniwarehayewa. ");
INSERT INTO hch_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Xewitɨ kaniuyeikakaitɨni Rewi nuiwarieya, kepauka mutineɨkixɨ mana tsiere mieme kanewitɨni. ");
INSERT INTO hch_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Mɨkɨ kaniutihukata nunutsi kanayexeiya, 'ixeiyaka kwinimieme mɨtitemaikɨkaikɨ, kaniti'awieta haika metseri. ");
INSERT INTO hch_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Kepaukari mɨkayɨwekai mi'awietanikɨ tsikɨiwiti kaniutawewieni, xɨrɨka kanitawirieni kwetsɨka mɨyɨwi nɨkame, mana nunutsi kanikateni hatetsita kaneikweni, hakatsata kanihɨani hapa mɨye'ukaitɨa, Niru hatetsitayaritsie. ");
INSERT INTO hch_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Hikɨ nunutsi kurieya yateewa kaniuyuhayewa, niereke kemɨranuyeyanikekai. ");
INSERT INTO hch_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Hikɨ mana kaniukateni 'uka Parahuni niweya ku'ɨwanetɨ, Niru hatuxameyaritsie. Te'i'uximayatsiriwamete hatetsita mekaniu'uwakaitɨni, yapauka Parahuni niweya tsikɨiwiti kaniuxeiya hakatsata kaniyewiekaitɨni, xeime ti'uximayatame kaniutanɨ'ani mituimiekɨ. ");
INSERT INTO hch_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Kepauka Parahuni niweya tsikɨiwiti manutiyepi nunutsi kaniuxeiya 'utatsuakame, kanitinenimayata mɨpaɨ kaniutayɨni: ―Hepɨrayu nunutsi pɨhɨkɨ. ");
INSERT INTO hch_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Hikɨ mɨkɨ nunutsi kurieya Parahuni niweya mɨpaɨ katiniutahɨawe: —Ya xeime 'ukaratsi nepɨti'inimie hepɨrayu tewiyari mitsitsitɨanikɨ, mitaweriyakɨ mɨkɨ nunutsi 'ahetsiemieme. ");
INSERT INTO hch_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Mɨkɨ mɨpaɨ katinita'eiya: —Kenemie kenewitɨmie. Kurieya kaneyani, peru nunutsi maamaya kani'atɨani. ");
INSERT INTO hch_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Parahuni niweya mɨpaɨ katinitahɨawe: —Kenanutu'i 'ikɨ nunutsi kenetsitsitɨaka keneneutaweriri, ne nepɨmatipitɨaka mɨpaɨ pemɨtiyurienikɨ. Mɨpaɨ tiɨyɨku mɨkɨ nunutsi maamaya kaneituni 'itsitsitɨatɨ kanitaweriya. ");
INSERT INTO hch_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","'Utawerekuri nunutsi, kaneiwitɨni Parahuni niweya hetsɨa, mɨkɨ kaniyutaniwetɨani, meta Muitsexi katiniterɨwa mɨpaɨ 'utaitɨ: «Ne hapa nepetitui». ");
INSERT INTO hch_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Kepauka Muitsexi 'amuyutama, yu'iwama kaniwarekuxeiya, kaniuniere kememɨte'uximatɨariekai. Xeime kaniuxeiya 'ekipitutanaka hepɨrayu tewiyari tiwayakaku. ");
INSERT INTO hch_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Hikɨ hanieretɨyaka nixewitɨ hawaikɨ mɨkareyeikakaikɨ mɨkɨ 'ekipitutanaka kaniumieni, kaniti'awieta xiekarita. ");
INSERT INTO hch_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","'Uxa'arieka hutarieka kanikuyani, hipameta kaniwaruxeiya meyukwitɨweme yu'iwamatɨ hepɨrayutsixi, mimainekai kaniuta'iwawiya: —¿Titayari 'a'iwa petimiene? ");
INSERT INTO hch_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Mɨkɨ kanita'eiya: —¿Kemɨ'anekuta 'ekɨ matsi'utahɨawixɨ 'itsɨkamekɨ tahetsie pemɨti'aitanikɨ? ¿Netsɨta penenemieni 'ekipitutanaka hepaɨ? Mɨyamɨtiutahɨawariekɨ Muitsexi waɨkawa kaniutimani mɨpaɨ katiniu'erieni: «Xɨari nepahekɨarixɨ kenemɨtiuyuri». ");
INSERT INTO hch_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Mɨyatiɨyɨku Parahuni katinetimani, Muitsexi kanimienikekaitɨni, peru Muitsexi kaniyuta'una Mariyani kwieyaritsie paitɨ kaneyani, putsu matiniere kaniuyuhayewa. ");
INSERT INTO hch_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Mawari wewiwame Mariyani kiekame 'atahuta meyupaɨmeme 'ukari kaniwarexeiyakaitɨni, mɨkɨ mekaniuyehanɨtɨkɨkakaitɨni muxatsi mematiharewe memɨtihɨniyakɨ, yupaapa muxatsimama mewatiharitɨanike. ");
INSERT INTO hch_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Peru muxatsi wahɨwemete 'ukitsi mana mekani'axekaitɨni mewataweiyake. Heiwa Muitsexi wahetsie kaniutanuani, 'ukitsi kaniwarutaweiya, 'ukari wamuxatsima kaniwarutiharitɨani. ");
INSERT INTO hch_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Kepauka 'ukari memakunuaxɨa yupaapa kie Xehueri, mɨkɨ mɨpaɨ katiniwaruta'iwawiya: —¿Titayari hikɨ kwitɨwa xete'u'axɨa? ");
INSERT INTO hch_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Mɨkɨ mɨpaɨ mekaniutiyuani: —Xewitɨ 'ekipitutanaka tahetsie kanetanuani, muxatsi wahɨwemete haa kememɨtekwerie, matsita haa watihanaka muxatsi kaniwaretiharitɨani. ");
INSERT INTO hch_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Mɨkɨta mɨpaɨ katiniwarutahɨawe: —¿Hakewari mɨkɨ 'uki? ¿Titayari yuxaɨta xeteheiku'eiri? Xekeneta'ini mɨtikwanikɨ. ");
INSERT INTO hch_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Muitsexi kaniuyuwaɨriya mɨkɨ hetsɨa mukanikɨ, mɨkɨ kaniwitɨtɨani yuniwe Tsepura. ");
INSERT INTO hch_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Mɨkɨ nunutsi xeime kanayexeiya, Muitsexi Keritsuni katiniterɨwa, mɨpaɨ tiu'erieka: «'Ateewapai nepɨkiekame xaɨtsie nepuyeika». ");
INSERT INTO hch_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Mɨixa wiyari 'anuyeyaku, ti'aitame 'Ekipitu kiekame kaniumɨni. 'Ixaheritsixi yaxeikɨa mekateniuka'eniwakaitɨni, waɨriyarika te'uximayatamete mehɨkɨtɨtɨ, mekaniutihiwakaitɨni parewiya meheuyehɨatɨ. Wahiwari Kakaɨyari kaniu'enieni mewaɨripiekaku. ");
INSERT INTO hch_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Hikɨ 'u'enaka kememɨte'uximatɨariekai kanaye'erieni tɨratu kememɨte'uwewi 'Apɨrahami, 'Itsahaki meta Kakuwu hamatɨa. ");
INSERT INTO hch_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Mɨpaɨ Kakaɨyari 'ixaheritsixi katiniwaraye'erieni, maye'akaikɨ yamemɨteyuriekakɨ. ");
INSERT INTO hch_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Merikɨtsɨ Muitsexi muxatsi kaniwahɨnekaitɨni yumune tewamama Keturu, mawari wewiwame mɨhɨkɨtɨkai Mariyani kiekame, muxatsi kaniware'arieni makumawetsie 'anutaɨyepaitɨ, Huré mɨrakutewatsie kaniye'ani, hɨri Kakaɨyari manuyeika. ");
INSERT INTO hch_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Mana 'uyeikakaku Yawé niuki tuayameya kaniuyuhekɨata taitsata 'ɨtsi takaku. Muitsexi mɨpaɨ katiniuniere 'ɨtsi kanitakaitɨni, peru pɨkayexɨximekai. ");
INSERT INTO hch_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","'Ayumieme mɨpaɨ katiniu'erieni: «Ketɨtɨri. Tsipara nemɨnierimie, titayari katiyetaixime 'ɨtsi». ");
INSERT INTO hch_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Kepauka Yawé Muitsexi muxei 'ahurawa 'a'amiekame nierimɨtɨ, kanitahɨawe 'ɨtsi hetsie yewetɨ: —Muitsexi, Muitsexi. Mɨkɨta kanita'eiya: —'Ena nepuwe. ");
INSERT INTO hch_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Kakaɨyari mɨpaɨ katinitahɨawe: —Tawarita 'enahurawa pepɨka'amieni, 'akakai kenanuyehɨnaxɨa, kwie mɨpatsie hetsie pekaniuweni. ");
INSERT INTO hch_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Ne 'apaapa nekanikakaɨyarieyatɨni, 'Apɨrahami, 'Itsahaki meta Kakuwu. Mɨpaɨ tiu'enaka Muitsexi, kaneuyuku'eima yɨhɨxie, 'utimaka Kakaɨyari 'uxeiyaka. ");
INSERT INTO hch_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Peru Yawé katinikuxatakaitɨni: —Yurikɨ nepɨniere kememɨte'uka'eniwa neteɨterima 'Ekipitu kwieyaritsie. Nepɨwa'enie kememɨte'uximatɨarie memɨtewa'aitɨa wahetsiemieme, nepɨtimate kememɨte'uka'eniwa. ");
INSERT INTO hch_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Hikɨ newaxɨnake nepɨyɨane 'ekipitutari wahetsɨa, newarayewitɨnike mɨkɨ kwieyaritsie nemɨwaranuwitɨnikɨ, xeime kwie 'aixɨa mɨ'anetsie 'amakuyewatsie, retsi maxuawetsie meta xiete, nekanixatani kananeutsixi wakwieyaritsie meta hetitsixi, 'amuxeutsixi, peretseutsixi, heweutsixi meta kewutseutsixi. ");
INSERT INTO hch_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","'Ixaheritsixi wahiwari nepu'eni, meta nepɨniere 'ekipitutari kehepaɨ memɨtewananaima. ");
INSERT INTO hch_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","'Ayumieme kene'akuha'aritɨa. Nekamananunɨ'amɨkɨ Parahuni hetsɨa, pemɨwarayewitɨnikɨ 'ixaheritsixi memɨneteɨterima 'Ekipitu kwieyaritsie. ");
INSERT INTO hch_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Peru Muitsexi Kakaɨyari mɨpaɨ katiniutahɨawe: —¿Ne tita netihɨkɨ Parahuni hɨxie nemɨtaniunikɨ meta 'ixaheritsixi nemɨwarayewitɨnikɨ? ");
INSERT INTO hch_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Kakaɨyari mɨpaɨ katinitahɨawe: —Ne 'ahamatɨa nepuyeikani. Meta ne'inɨari nepɨmatsiwewirieni kename ne nehɨkɨ nemɨmatsihanunɨ'ani: Kepauka pemɨwarayewitɨni neteɨterima 'Ekipitu kwieyaritsie, yunaitɨ xeme xenetsi'ayexeiyatɨ xepakɨne 'ikɨ hɨritsie. ");
INSERT INTO hch_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Muitsexi matsi mɨpaɨ kaniutayɨni: —Xɨka neheyani 'ixaheritsixi xɨka mɨpaɨ netiwaretahɨawe: “Xe'ukiyarima wakakaɨyari pɨnetsiheyenɨ'a xehetsɨa”. ¿Kenetiwaretahɨawe xɨka mɨpaɨ meneteheta'iwawiya: “¿Keri titewa?” ");
INSERT INTO hch_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Kakaɨyari Muitsexi mɨpaɨ katiniutahɨawe: —Ne nepɨhɨkɨ kemɨ'ane nemɨhɨkɨ. Mɨpaɨ pekatiniwarekɨhɨawemɨkɨ 'ixaheritsixi: “Ne nepɨhɨkɨ, pɨnetsiheyenɨ'a xehetsɨa”. ");
INSERT INTO hch_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Hikɨ Kakaɨyari Muitsexi mɨpaɨ katiniutahɨawe: —Mɨpaɨ ketiniwaretahɨawi 'ixaheritsixi: “Yawé xe'ukiyarima wakakaɨyari 'Apɨrahami, 'Itsahaki meta Kakuwu, pɨnetsiheyenɨ'a xehetsɨa. 'Ikɨ pɨhɨkɨ kenemɨtitewa yareuyuhanemekɨ, 'ikɨ pɨhɨkɨ kenemɨtitewa naitɨ nuiwarite manuyekɨne”. ");
INSERT INTO hch_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","'Ekɨ kenemie 'ukirawetsixi keniwarekuxeɨri 'ixaheritsixi, mɨpaɨ ketiniwaretahɨawi: “Yawé xe'ukiyarima wakakaɨyari 'Apɨrahami, 'Itsahaki, Kakuwu, peyuhekɨataxɨ nehɨxie mɨpaɨ pɨnerahɨawekai: ‘Ne nepɨxexeiya, nepɨniere kexemɨtenanaimarie mana 'Ekipitu kwieyaritsie. ");
INSERT INTO hch_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","'Ayumieme mɨpaɨ nepɨtiku'eriwa nepɨxe'ayewitɨni kexemɨte'uka'eniwatsie mana 'Ekipitu. Nemɨxe'anuwitɨnikɨ kananeutsixi wakwietsie, hetitsixi, 'amuxeutsixi, peretseutsixi, heweutsixi meta kewutseutsixi. Mɨkɨ kwietsie waɨkawa retsi kanexɨaweni meta xiete.’” ");
INSERT INTO hch_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","'Ukirawetsixi 'ixaheritsixi mepɨmatsi'anu'enieni, hikɨ mɨkɨ meta 'ekɨ ti'aitame hɨxie xepeti'uni mɨpaɨ xepetiyuani: “Yawé, hepɨrayutsixi takakaɨyari kanekuyeixɨani katatinekuxatɨani. Ketaneupitɨa temɨyehukɨ haika tukari te'uhutɨ mana Yawé takakaɨyari temɨteheitimawirienikɨ”. ");
INSERT INTO hch_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Nepɨtimate ti'aitame 'Ekipitu kiekame pɨkaxehepitɨani, waɨriyarika ne'ipitɨayuke xekanayekɨnikuni. ");
INSERT INTO hch_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","'Ayumieme netɨrɨkariya nepɨhekɨata, nepɨtiwakwinitɨani 'ekipitutari 'inɨari kenemɨtiwewieni mariwemekɨ watsata. Naitɨ mɨkɨ ranuyeyayu Parahuni pɨxepitɨani xemɨyehukɨ. ");
INSERT INTO hch_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Peru ne neteɨterima 'ekipitutari 'aixɨa memɨtewamanikɨ nepɨwayuitɨani, mɨpaɨ xeyumamawetɨ xemɨka 'ayekɨkanikɨ 'Ekipitu kwieyaritsie. ");
INSERT INTO hch_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Yunaitɨ 'ukarawetsixi 'ixaheritsixi mepɨtetawauxɨani wa'aurie memeutitei wahetsɨa ya tsepa ke'ane hetsɨa, 'urukɨ mɨtiwewiyatɨka meta pɨratakɨ, 'ixurikite yuniwema xemɨwaretiketɨanikɨ 'ukitsi 'ukari. Mɨpaɨ 'ekipitutari xekateniwanawairiekuni. ");
INSERT INTO hch_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Muitsexi tawarita kaniuta'iwauni: —¿Keneheyɨanenita xɨka yuri mekaneteheta'eririeni xɨka mekanetsihe'enieni? ¿Keneheyɨaneni xɨka mɨpaɨ menetehahɨaweni: “Yawé 'ahɨxie pɨkaheyuhekɨataxɨ”? ");
INSERT INTO hch_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Yawé mɨpaɨ katinita'iwawiya: —¿Tita perakwe'e? Muitsexi mɨpaɨ kaniutayɨni: —Kɨye 'itsɨyari nepakwe'e. ");
INSERT INTO hch_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Yawé mɨpaɨ katinitahɨawe: —Kwiepa mɨkawenikɨ keneutatua. Muitsexi kɨye 'itsɨyari kaniutatuani kwiepa mɨkawenikɨ, hikɨ mɨkɨ kɨye 'itsɨyari kuu kanayani. Muitsexi kanitanautsakekaitɨni 'imakatɨ, ");
INSERT INTO hch_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","peru Yawé kanita'aitɨani miwiyakɨ kwaxieyatsie. Kepauka Muitsexi kuu muwiyaxɨ kwaxieyatsie, mɨkɨ kɨye kanayani. ");
INSERT INTO hch_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","—'Ikɨ kanihɨkɨtɨni yuri memɨmateheta'eririeni kename ne Yawé xepaapama wakakaɨyari 'Apɨrahami, 'Itsahaki, Kakuwu ne'unehekɨataxɨ 'ahɨxie. ");
INSERT INTO hch_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Tawarita mɨpaɨ Yawé katinitahɨawe: —Hikɨta 'akamixatɨa keneukume'i. Muitsexi yukamixatɨa kaneukumeni, kepauka mewakuha mamaya nawiyari tikuyetɨ kanayani kaniutature 'ɨwi hepaɨ. ");
INSERT INTO hch_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Tawarita Kakaɨyari mɨpaɨ kaniutayɨni: —Tawarita 'akamixatɨa keneukume'i. Muitsexi tawarita yukamixatɨa kaneukumeni, kepauka mewakuha 'aixɨa kani'anekaitɨni naitɨ kemeu'anekai matɨari. ");
INSERT INTO hch_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Yawé mɨpaɨ kaniutayɨni: —Xɨka 'inɨari mexɨakame miemekɨ yuri mekate'uta'erieni, xɨari hutarieka miemekɨ. ");
INSERT INTO hch_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Peru xɨka 'ikɨ hutame 'inɨarikɨ yuri mekamete'uta'eririeni, haa keneuhanimie Niru mieme, kenetayeuri kwiepa, kepauka haa manutateni kwiepa xuriya kanayeimɨkɨ. ");
INSERT INTO hch_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Muitsexi mɨpaɨ kaniutayɨni: —Yawé, ne hatsuaku 'aixɨa nepɨkarekuxatani, 'ikɨ pɨkati'ane takai mɨtiuyukatsutɨa 'atu mɨtiuyukatsutɨa yahikɨ penetikuhɨawekaku, heitseriemekɨ waɨriyarika nepɨtiutaxaxata. ");
INSERT INTO hch_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Yawé mɨpaɨ kaniutayɨni: —Ne nepɨhɨkɨ 'ateni nemutawewi. Ne nepɨhɨkɨ Yawé mekaheu'enanakame mɨwarayeitɨwa, mekaniuwaweme, kemɨ'ane meheuneniereme mɨwarayeitɨwa yatɨni mekaheuneniereme. ");
INSERT INTO hch_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Kenemie, keneuyukuha'aritɨa ne nepɨmatsiparewieni pemɨtaniunikɨ nematitaxatɨani kepemutaineni. ");
INSERT INTO hch_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Hikɨ Muitsexi mɨpaɨ kaniutayɨni: —Yawé 'aku, waɨkawa nematsiwawirie xeime pɨta pemanunɨ'anikɨ. ");
INSERT INTO hch_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Hikɨ Yawé waɨkawa kaniuyeha'ani Muitsexi hetsiemieme, mɨpaɨ katinitahɨawe: —'Aixɨa kati'ane 'a'iwa 'Aruni rewi tewiyari. Ne nepɨtimate mɨkɨ 'aixɨa pɨtiuxaxata. Hikɨri kanayeyani metsikunakenetɨ, kepauka mɨmetsihexeiya 'iyarieya 'aixɨa kaneyɨmɨkɨ. ");
INSERT INTO hch_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","'Ekɨ pepɨreitaxatɨani naime kenematiutixatɨa, ne nepɨxeparewieni xemɨtiniunikɨ 'ekɨ, mɨkɨ matɨa, nepɨtixeta'ɨkitɨani kehepaɨ xemɨteyurieka. ");
INSERT INTO hch_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Mɨkɨ putaniukani teɨteri wahɨxie 'ahetsiemieme, 'ekɨtɨtɨ pemutaineni, 'ekɨta nehetsiemieme pepɨtikuxaxatɨwani ne nemɨtikuhɨaweni hepaɨ. ");
INSERT INTO hch_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Peru mɨkɨ pepɨkakutɨtɨmaiyani kɨye 'itsɨyari, 'ekɨ mɨkɨkɨ 'inɨari pepewewieni mamariwaweme. ");
INSERT INTO hch_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Muitsexi mana mɨyetɨa yumune Keturu hetsɨa kaninuani. Nuaka mɨpaɨ katinitahɨawe: —Ne nepɨyemie 'Ekipitu, ne'iwama memanu'uwa. Nepɨnierimie 'akuxi xɨka mehe'uwani. Keturu mɨpaɨ katinitahɨawe: —Kenemiekuta, 'aixɨa pekereuye'ani. ");
INSERT INTO hch_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Mariyani paitɨri Yawé Muitsexi mɨpaɨ katinahɨawekaitɨni: «Kenemie 'Ekipitu, yunaitɨri mekaniukwini memɨmatsimiekukai». ");
INSERT INTO hch_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Hikɨ Muitsexi kaniuyukuha'aritɨani yu'ɨya meta yuniwema waranutiyatsaka puxutsie 'Ekipitu kaneyani, yumamatsie Kakaɨyari 'itsɨya kanakwekaitɨni. ");
INSERT INTO hch_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Yawé Muitsexi mɨpaɨ katinahɨawekaitɨni mɨkatikuhayeikawanikɨ: «Kepauka 'Ekipitu pemunuani pepɨkatikuhayeikawani tita nematiuta'ɨkitɨa, Parahuni hɨxie 'inɨari pemɨwewienikɨ mamariwaweme. Neta 'iyarieya nepɨtseiriya neteɨterima mɨkawapitɨanikɨ. ");
INSERT INTO hch_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Hikɨ 'ekɨ mɨpaɨ pepɨreitahɨawe nehetsiemieme Parahuni: “'Ixaheri neniwe mexɨakame kanihɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Mɨpaɨ nepɨmarahɨawe keneupitɨa neniwe mɨnetsi'ayexeiyanikɨ, peru 'ekɨ pepɨka'itaunie mɨyemiekɨ. 'Ayumieme, 'aniwe mexɨakame tukarieya nekaninawairiemɨkɨ”». ");
INSERT INTO hch_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Huyeta, Yawé Muitsexi kananukunake, kutsukaku kanitaxeiya kanimienitɨma, ");
INSERT INTO hch_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","peru Tsepura tete nawaxayari 'utikweka yuniwe kaniuxiteni xieyameyatsie, hikɨ Muitsexi 'ɨkayatsie kaniuwirieni mɨpaɨ rehɨawetɨ: «Pɨkaheuyewetse nemɨ'iyɨrieka. 'Ayumieme yurikɨ 'ekɨ pepɨnekɨna 'ikɨ xuriya nemutayeurikɨ». ");
INSERT INTO hch_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Mɨyatiɨyɨku Yawé Muitsexi kaniuhayewa, peru Tsepura yɨkɨna mɨpaɨ pɨtiuterɨwakai, «pepɨnekɨna 'ikɨ xuriya nemutayeurikɨ» xitekiya 'inɨariyarikɨ. ");
INSERT INTO hch_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Yawé 'Aruni mɨpaɨ katiniutahɨawe: «Kenemie Muitsexi kenenakimie makumawetsie paitɨ». 'Aruni kaneyani Muitsexi netaxeiya hɨritsie paitɨ Kakaɨyari manuyeika, kani'itseni. ");
INSERT INTO hch_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Hikɨ Muitsexi 'Aruni katiniutaxatɨani naime Yawé kemɨrehɨawekai, naime 'inɨari mamariwaweme kemɨti'ɨkitɨakai. ");
INSERT INTO hch_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Hikɨ Muitsexi 'Aruni hamatɨa 'ixaheritsixi mekaniwarukuxeɨrieni. ");
INSERT INTO hch_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","'Aruni naime katiniwarutaxatɨakaitɨni Muitsexi Yawé kemɨrehɨawekai, yunaime wahɨxie 'inɨari kaniuwewieni, ");
INSERT INTO hch_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","mɨkɨkɨ teɨteri yuri mekateniuta'erieni. Mɨpaɨ mete'u'enanaka kename Yawé waxeiyakai kememɨte'uka'eniwakai waranuku'erienikekai, 'ixaheritsixi mekaniutihɨxima'uni meta Yawé mariweme mekanayeitɨani. ");
INSERT INTO hch_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Mɨpaɨ metewarutahɨaweka Muitsexi 'Aruni Parahuni hɨxie mekaniti'uni mɨpaɨ mekatenitahɨawe: —Mɨpaɨ paine Yawé 'ixaheritsixi takakaɨyari: “Keniwarupitɨa neteɨterima makumawetsie paitɨ memɨyehukɨ 'ixɨarari memɨwewienikɨ nehetsiemieme kemɨnetinake”. ");
INSERT INTO hch_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Parahuni mɨpaɨ kaniutayɨni: —¿Kemɨ'ane mɨkɨ Yawé pɨhɨkɨ, para ne nemenu'enienikɨ 'ixaheritsixi nemɨwapitɨanikɨ? Ne Yawé nepɨkamate, ne nepɨkawapitɨani 'ixaheritsixi memɨyehukɨ. ");
INSERT INTO hch_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Mɨkɨta mɨpaɨ mekaniutiyuani: —Hepɨrayutsixi wakakaɨyari 'upɨtatsihanakirɨme, 'ayumieme tame haika tukari tepuhuni makumawetsiepai, Yawé temɨtehetimawirienikɨ takakaɨyari. Xɨka mɨpaɨ tekate'uyurieni waɨkawa pɨtatiukwinitɨawe, tixaɨtɨ 'upɨranɨ'ani kwiniya yatɨni pɨtatsi'ukwiwe yu'ixiparakɨ. ");
INSERT INTO hch_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Ti'aitame 'Ekipitu kiekame mɨpaɨ kaniutayɨni: —Muitsexi, 'Aruni, teɨteri xepɨkawa'uximatɨaka memɨte'uximayakakɨ. Xekenakunuaxɨa xemɨteha'uximayatsie. ");
INSERT INTO hch_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Xekeneutimaixɨa mepɨyuwaɨkawa teɨteri 'ena 'Ekipitu, xemeta xekatewapitɨa memɨte'uximayaka. ");
INSERT INTO hch_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Mɨkɨ tukaritsie Parahuni mɨpaɨ katiniwaruta'aitɨani te'aitamete 'ekipitutari meta 'ixaheritsixi memɨtewa'aitɨa: ");
INSERT INTO hch_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","«Xɨnariya tata'ime memɨtiwewienikɨ 'ɨxa xepɨkawayetuiriwaniri, mɨkɨ mekeheiteɨxiyuni yɨkɨmana. ");
INSERT INTO hch_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Peru xeme yaxeikɨa paɨmeme xekeniwawawirieka xɨnariya, xepɨkahenukahɨpani memɨyɨ'ɨraraxie mekanihɨkɨtɨni, 'ayumieme mɨpaɨ mekanetenikɨhɨaweni: “Ketaneupitɨa takakaɨyari temɨtemawirieyukɨ”. ");
INSERT INTO hch_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Kwinimieme ti'uxiyakame xekeniwa'aitɨaka. Xeketeniwa'aitɨaka yamemɨte'uximayakakɨ. Mɨpaɨ 'itarika mepɨkahanu'enieni». ");
INSERT INTO hch_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Te'aitamete 'ekipitutari mekanayekɨne 'ixaheritsixi memɨtewata'aitɨanikɨ, meta teɨteri memɨtewa'aitɨa mɨpaɨ mekateniwarutahɨawe: «Parahuni mɨpaɨ kanaineni: “'Ɨxari xepɨkayetuiriyarieniri. ");
INSERT INTO hch_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Xemeri xekaniwauyuni tsepa hakewa xemeikaxeiya, perutsɨ yaxeikɨa paɨmeme xepɨtiwewiwani kexemɨte'aitɨarie”». ");
INSERT INTO hch_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Mɨpaɨ tiuyɨku 'ixaheritsixi mekaneutayeixɨani 'Ekipitu kwieyaritsie meteheuteɨxɨtɨkaitɨ mɨraku'etsitɨretsie, 'ɨxa memɨyetuiriyarɨwakaitsiemieme. ");
INSERT INTO hch_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Memɨtewa'aitɨa mekaniyeweiyakaitɨni mɨpaɨ metewakɨhɨawetɨ: «Xeketenaye'atɨwani kexemɨte'aitɨarie 'ɨxa xemɨyetuiriyaruwakai hepaɨ». ");
INSERT INTO hch_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Matsita memɨte'aita Parahuni hetsɨa miemete 'ixaheritsixi memanuyetei mekaniwatiwayakaitɨni mɨpaɨ metewaku'iwawiyatɨ: «¿Titayari takai meta hikɨ xekate'aye'atɨa kepapaɨmeme xemɨ'aitɨarie, meripai xemitiwewiwakai hepaɨ?» ");
INSERT INTO hch_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Memanuyetei 'ixaheritsixi mekanekɨne Parahuni hetsɨa, mɨpaɨ mekateneitahɨawe: —¿Titayari 'ekɨ mɨyapetiwayuriene te'a'uximayatamete? ");
INSERT INTO hch_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","'Ɨxari xemɨkatatsiyetuiriwa. Mɨyatɨtɨ yaxeikɨa papaɨmeme tetewawiyarie xɨnariya, 'etsimɨpaɨmeni hepaɨ tetetiweiwa. Ti'aitame 'ateɨterima 'aixɨa mepɨkateyurie. ");
INSERT INTO hch_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Parahuni mɨpaɨ kaniutayɨni: —Xemɨyɨ'ɨraraxie, xemɨyɨ'ɨraraxie xekanihɨmetɨni. 'Ayumieme mɨpaɨ xekaniutiyuaneni: “Ketaneupitɨa Yawé takakaɨyari temɨtemawirieyukɨ”. ");
INSERT INTO hch_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Hikɨ xekenehu xeketene'uximayaka. 'Ɨxa xepɨkayetuiriyarieniri, peru yaxeikɨa paɨmeme xepɨtiwewiwani xɨnariya. ");
INSERT INTO hch_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Te'uximayatamete memanuyetei 'ixaheritsixi mɨpaɨ mekatenetimani mexɨima katinaniuwakaitɨni, kepauka mɨpaɨ mɨtiutaniukie kename yaxeikɨa papaɨmeme meyetuayanikekai. ");
INSERT INTO hch_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Muitsexi hetsɨa meta 'Aruni hetsɨa me'u'axɨaka kitenie memuwakwewiekai, ");
INSERT INTO hch_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","mɨpaɨ mekateniwarutahɨawe: «Yawé kexeheutixeiyaxɨani kexehanutaxɨrieni. Xeme ya'ane xeheutiwiwiexɨaku 'axatepu'ɨatɨka Parahuni hɨxie yaxeikɨa memɨte'i'uximayatsirie wahɨxie, xeme xekateniuyurieni 'ixipara xemɨwarukweitɨa memɨtatsikwinikɨ». ");
INSERT INTO hch_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Muitsexi Yawé mɨpaɨ katiniutahɨawe: —Neuxei, Yawé, ¿titayari 'ikɨ kiekari 'axapetiyuriene? ¿Mɨpaɨ mɨti'anenikɨ penereyenɨ'a? ");
INSERT INTO hch_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Kepaukapai Parahuni hɨxie nemutaniu 'ahetsiemieme, tixaɨtɨ 'atsipɨkatiyuriwe matsi pɨta pɨwananaima 'ikɨ teɨteri memɨ'ateɨterima. 'Ekɨta 'atsipepɨkatiyuriwe pewaxɨnake. ");
INSERT INTO hch_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Yawé mɨpaɨ katinita'eiya: —Patsɨ pekaninierimɨkɨ kenemɨtiyurieni Parahuni hetsɨa. Netɨrɨkariya xeikɨa kanixepitɨamɨkɨ xemɨyehukɨ, netɨrɨkariyakɨ xeikɨa mɨkɨ kwieyaritsie xekanayeweiyariekuni. ");
INSERT INTO hch_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Hutarieka, Kakaɨyari Muitsexi hamatɨa katiniutaxata mɨpaɨ katinitahɨawe: «Ne Yawé nepɨhɨkɨ. ");
INSERT INTO hch_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Ne nepɨnehekɨataxɨ 'Apɨrahami, 'Itsahaki, meta Kakuwu wahɨxie, ne Kakaɨyari Naimekɨmɨtɨrɨkaɨye, peru kenemɨtitewa yemekɨ nepɨkawarutaxatɨa, Yawé nemɨtitewa. ");
INSERT INTO hch_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Metatsiere tɨratu tepuwewi kwie Kanani miemekɨ wahetsiemieme mayanikɨ, meripaitɨ memakutekaitsie 'ateewa kiekatari wahepaɨ me'anetɨ. ");
INSERT INTO hch_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Meta nepɨwa'enie 'ixaheritsixi kememɨte'uka'eniwa, 'ekipitutari waɨriyarika te'uximayatamete memɨwarayeitɨakɨ, nepaye'eri tɨratu kenemɨtiuwewi. ");
INSERT INTO hch_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","'Ayumieme kenemie mɨpaɨ ketiniwaretahɨawi 'ixaheritsixi: “Ne Yawé nepɨhɨkɨ, ne nepɨxexɨna 'ekipitutari kememɨtexe'uximatɨa, ne nepɨxexɨna kexemɨte'uximayatamete, ne nepɨxexɨna waɨkawa 'inɨari newewietɨ meta mamariwawemekɨ 'aixɨa nepɨtiyurieni. ");
INSERT INTO hch_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Ne, xeme nekiekari nepɨxe'ayeitɨani, neta xekakaɨyari. Mɨpaɨ 'ana mepɨtehetimani, kename ne Yawé nexekakaɨyari, nemɨxe'ɨxɨnaxɨ 'ekipitutari kememɨtexe'uximatɨakai. ");
INSERT INTO hch_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Nekanixe'anuwitɨmɨkɨ kwietsie mɨpaɨ kenemɨtinehɨritɨa 'Apɨrahami, 'Itsahaki, Kakuwu, nemɨwayetuirienikekai, ne Yawé, nepɨxeyetuirieni mɨkɨ kwie mana xemɨtitenikɨ”». ");
INSERT INTO hch_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Muitsexi, 'ikɨ naime tiniwarutaxatɨani 'ixaheritsixi peru memutiwaɨripiekaikɨri, mete'uka'eniwatɨ mete'aitɨarietɨ 'ayumieme mepɨka'i'eni. ");
INSERT INTO hch_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Hikɨ Yawé mɨpaɨ Muitsexi katiniutahɨawe: ");
INSERT INTO hch_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","—Kenemie Parahuni hɨxie ti'aitame 'Ekipitu kwieyaritsie. Mɨpaɨ ketinetahɨawi, kewarupitɨani memɨyehukɨ 'ixaheritsixi mɨkɨ kwieyaritsie. ");
INSERT INTO hch_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Peru Muitsexi Yawé mɨpaɨ katiniutahɨawe: —'Ixaheritsixi matsi mepɨkanetsiheu'enieri Parahuni kenetiu'enieni meta 'aixɨa nepɨkatiuxaxata. ");
INSERT INTO hch_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Hutarieka Yawé Muitsexi 'Aruni mame kaniwarutahɨawe, 'ixaheritsixi wahetsiemieme meta Parahuni ti'aitame hetsiemieme katiniwarutaxatɨani, mɨpaɨta katiniwaruta'aitɨani 'ixaheritsixi 'Ekipitu memɨwarayewitɨnikɨ. ");
INSERT INTO hch_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","'Ikɨ mepakɨ 'ixaheritsixi wa'ukiyarima: Xuweni niwemama 'Ixaheri matɨarieya: Kanuki, Paru, Ketsiruni meta Karimi. Mɨkɨ mepɨhɨkɨ Xuweni nuiwarimama. ");
INSERT INTO hch_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Tsimehuni niwemama: Kemueri, Kamini, 'Uhari, Kakini, Tsukaxi, meta Tsahuri maamaya kananeu tewiyari pɨhɨkɨtɨkai. Mɨkɨ mepɨhɨkɨ Tsimehuni nuiwarimama. ");
INSERT INTO hch_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Kememɨteheuku'uxa mɨkɨ nuiwari memaka'utɨarietsie, 'ikɨ Rewi niwemama mepɨhɨkɨ: Keritsuni, Kuhati meta Merari. Xeitsienituyari heimana xeitewiyari heimana tamamata heimana 'atahuta wiyari puyuri. ");
INSERT INTO hch_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Keritsuni niwemama wanuiwaritsie: Riwini meta Tsimi. ");
INSERT INTO hch_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Kuhati niwemama: 'Amirani, 'Itsaxi, Hewuruni meta 'Utsiheri. Xeitsienituyari heimana xeitewiyari heimana tamamata heimana haika wiyari puyuri. ");
INSERT INTO hch_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Merari niwemama: Makiri meta Mutsihí. 'Ikɨ Rewi nuiwarimama mepɨhɨkɨ kememɨteheku'uxa. ");
INSERT INTO hch_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","'Amirani, xeitsienituyari heimana xeitewiyari heimana tamamata heimana 'atahuta wiyari puyuri, yutetei kaniutiwitɨni Kukaweri titewakame, mɨkɨ yuhutame mekaniwarayexeiya tɨɨri: 'Aruni meta Muitsexi. ");
INSERT INTO hch_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","'Itsaxi niwemama: Kure, Nepeki meta Tsikɨri. ");
INSERT INTO hch_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","'Utsiheri niwemama: Mitsaheri, 'Eritsapani, meta Tsitiri. ");
INSERT INTO hch_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","'Aruni 'Eritsaweti kaniutiwitɨni, 'Aminarawi nu'aya Nahatsuni 'iwaya, mɨkɨ yunaukame mekaniwarayexeiya tɨɨri: Narawi, 'Awihu, 'Eriyatsaxi meta 'Itamaxi. ");
INSERT INTO hch_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Kure niwemama: 'Atsixi, 'Erikana meta 'Awiyatsahapi. Mɨkɨ Kure nuiwarimama mekanihɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","'Eriyatsaxi 'Aruni nu'aya xeime kaniutiwitɨni Putiheri niweya, xeime nunutsi mekanayexeiya Pinexi mekateniterɨwa. 'Ikɨ Rewi nuiwarimama wa'ukiyarima mepakɨ, kememɨteheku'uxa memaka'utɨarietsie. ");
INSERT INTO hch_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","'Aruni meta Muitsexi, mɨkɨ mepɨhɨkɨtɨkai Yawé mɨwanɨ'akai 'ixaheritsixi memɨwarayewitɨnikɨ 'Ekipitu kwieyaritsie yayupapaɨmeme. ");
INSERT INTO hch_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","'Ikɨ mepɨhɨkɨ Parahuni hɨxie memutiniu, ti'aitame 'Ekipitu kiekame hetsɨa, memɨwarayewitɨnikɨ 'ixaheritsixi 'Ekipitu kwieyaritsie. ");
INSERT INTO hch_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Kepauka Yawé Muitsexi hamatɨa mɨtiutaxa 'Ekipitu, ");
INSERT INTO hch_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","mɨpaɨ katinitahɨawe: —Ne Yawé nekanihɨkɨtɨni. Parahuni ti'aitame 'Ekipitu kiekame naime ketinetaxatɨa kenemɨmatitahɨawe. ");
INSERT INTO hch_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Peru Muitsexi Yawé mɨpaɨ katiniutahɨawe: —¿Neranu'enienikuta Parahuni, ne 'aixɨa nepɨkatiuxaxata? ");
INSERT INTO hch_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Yawé Muitsexi mɨpaɨ katiniutahɨawe: —Mɨpaɨ ketinemaika Kakaɨyari tewiyari pepayani Parahuni hɨxie. 'A'iwa 'Aruni 'aniukame payani. ");
INSERT INTO hch_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","'Ekɨ pɨ'ahɨritɨarika naime pemɨtikuxaxatɨwani kenematikuhɨaweni, 'a'iwata 'Aruni Parahuni pɨtawawirieni mɨwapitɨanikɨ memɨyehukɨ mɨkɨ kwieyaritsie. ");
INSERT INTO hch_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Ne Parahuni 'iyarieya nepɨtseiriya tsepa 'inɨari mamariwaweme nemutiwewi 'Ekipitu. ");
INSERT INTO hch_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Mɨkɨ pɨkaxe'enieni, hikɨ matsi ne naime netɨrɨkariya 'Ekipitu nepɨtiwewieni, mariwemekɨ netiyurienetɨ kemɨtiheitserie, nepɨwarayewitɨni kwinimieme memɨyupaɨme neteɨterima 'ixaheritsixi. ");
INSERT INTO hch_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Kepauka ne mariweme nemɨtiyurieni 'Ekipitu kwieyaritsie, kepauka ne 'ixaheritsixi nemɨwarayewitɨni, 'ana 'ekipitutari mɨpaɨ mepɨtehetimani kename ne Yawé nehɨkɨ. ");
INSERT INTO hch_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Muitsexi 'Aruni hamatɨa yamekatenikakɨne Yawé yemekɨ kemainekai. ");
INSERT INTO hch_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Kepauka Parahuni hɨxie memutiniu, Muitsexi nauka tewiyari wiyari kanexeiyakaitɨni, meta 'Aruni nauka tewiyari heimana haika wiyari kanexeiyakaitɨni. ");
INSERT INTO hch_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Yawé Muitsexi 'Aruni mame mɨpaɨ katiniwarutahɨawe: ");
INSERT INTO hch_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","«Kepauka Parahuni 'inɨari mɨxewawirieka, 'Aruni ketineutaxatɨa, kɨye 'itsɨyari ke'utikweni kwiepa ke'ikahɨani Parahuni hɨxie. Mɨpaɨ 'ana kɨye kuu kanayeimɨkɨ». ");
INSERT INTO hch_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Muitsexi 'Aruni hamatɨa Parahuni hetsɨa mekanekɨne, mekatenaye'atɨani Yawé kemɨtiwarahɨawekai. 'Aruni yu'itsɨ nehɨani kwiepa Parahuni hɨxie meta memɨte'i'uximayatsirie wahɨxie, mɨkɨ kɨye kuu kanayani. ");
INSERT INTO hch_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Peru Parahuni memɨtemaiwawe kaniwaruta'inienita meta memɨteyukewaiya, mɨkɨta 'awie memɨte'uyematekɨ mɨkɨ temaiwawemete yaxeikɨa mekateniuyurieni: ");
INSERT INTO hch_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Yuxexuitɨ yu'itsɨ mekanexɨriexɨani, yaxeikɨa naitɨ kɨyexi kuuterixiyari mekanakɨne. Matsi 'Aruni kɨyeya mɨkɨ wakɨyexi yunaime kaniwarutikwani. ");
INSERT INTO hch_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Mɨya tiuyɨku Yawé kemɨtiwarahɨawekai, Parahuni yu'iyari kaniutseiriya pɨkawaru'eni kememɨtekuxatakai. ");
INSERT INTO hch_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Yawé Muitsexi mɨpaɨ katiniutahɨawe: «Parahuni yu'iyari pɨtse'iriya pɨkayuwaɨri neteɨterima mɨwatatuanikɨ. ");
INSERT INTO hch_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Kenemie ximeri mɨ'ɨwamietsie kenekwewieka Niru hatetsitayaritsie, hikɨ pekananukukemɨkɨ pe'enukunakeke 'akɨye pe'akwetɨ kuu mayeika. ");
INSERT INTO hch_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Mana mɨpaɨ ketinetahɨawi: “Yawé hepɨrayutsixi wakakaɨyari pɨnetsiheyenɨ'a mɨpaɨ nematitahɨawekɨ: ‘Keniwarupitɨa neteɨterima memayekɨnekɨ, memɨnetsihayexeiyanikɨ humapaitɨ makumawetsiepai.’ Hikɨ pemɨka'awaɨriyakɨ, ");
INSERT INTO hch_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Yawé mɨpaɨ kanaineni: ‘Hikɨ pepɨretimani kename ne Yawé nehɨkɨ.’ 'Ikɨ kɨye nemekwe'ekɨ haa Niru mieme nekaniwamɨkɨ, hikɨ mɨkɨ haa naitɨ xuriya kanayeimɨkɨ. ");
INSERT INTO hch_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Tsapari yunaitɨ mekanikwikuni, haa 'axa'u'ɨatɨ kanayeimɨkɨ, 'ekipitutari mana mepɨkatihareni”». ");
INSERT INTO hch_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Yawé Muitsexi mɨpaɨta katiniutahɨawe: «'Aruni mɨpaɨ ketineutahɨawi, yu'itsɨ ke'utikweni hapa keheitatsera 'Ekipitu miemetsie, naitɨ 'akite, hamuyehapane, meta haa mukamarike mukumane xuriya mayanikɨ. Xuriya puxɨaweni naitɨ kemɨyewa 'Ekipitu kwieyaritsie, kɨyexi tsiepaitɨ, tetexi tsiepaitɨ naitɨ». ");
INSERT INTO hch_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Muitsexi 'Aruni hamatɨa Yawé mekananu'enieni kemɨtiwa'aitɨakai. Parahuni yaxeikɨata memɨte'i'uximayatsirie wahɨxie 'Aruni yɨkɨye teikɨ netsera haa Niru mieme kaniuwani. Hikɨ naitɨ haa mana mieme xuriya kanayani. ");
INSERT INTO hch_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Tsapari mekaniukwini Niru hetsie memɨye'uwakai, haa 'axakaniu'ɨakaitɨni 'ekipitutari mana memɨhareka mepɨkayɨwawekai. Naitsarie 'Ekipitu kwieyaritsie xuriya hayari kanixuawekaitɨni. ");
INSERT INTO hch_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Yaxeikɨata temaiwawemete 'awie memɨte'uyematekɨ mɨkɨ 'ekipitutari yaxeikɨa mekateniuyurieni, mɨpaɨ Parahuni yu'iyari kaniutseiriya kemainekai Yawé kemɨtiwarahɨawekai, 'Aruni pɨka'anu'eni meta Muitsexi. ");
INSERT INTO hch_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Wa'atɨtɨ tixaɨtɨ 'atsipɨkatiɨyɨ ta'aurie haweka yuparatsiyuta kaneyani. ");
INSERT INTO hch_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Hikɨ 'ekipitutari putsu mekaniutiwewietɨkɨne Niru hatetsitayaritsie, haa 'aixɨa mɨ'ane mehauwautɨkaitɨ, memɨkayɨwawekaikɨri hatɨa mieme memɨtiharenikɨ. ");
INSERT INTO hch_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","'Atahuta tukari panukatɨa kepauka Yawé Niru hayari muwa. ");
INSERT INTO hch_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Yawé Muitsexi mɨpaɨ katiniuta'aitɨani: «Kenemie Parahuni hetsɨa mɨpaɨ ketinetahɨawi, Yawé mɨpaɨ paine: “Keniwarupitɨa neteɨterima memɨyehukɨ memɨnetsi'ayexeiyanikɨ. ");
INSERT INTO hch_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Xɨka pekawarupitɨani temutsi nepɨwanetɨani naitsarie 'akwie kemɨyewa. ");
INSERT INTO hch_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Niru hatɨayari mukwakeni hepaɨ temutsi wahekɨ puyɨneni, 'aparatsiyuta mepeutahaxɨani, pemuyehuputsie paitɨ meta 'a'itaritsie, yaxeikɨata 'ahetsɨa te'uximayatamete wakiita paitɨ, 'ateɨterima wakiita, 'ahuxunuta meta titɨxɨmete. ");
INSERT INTO hch_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","'Ahetsie mepɨtimakixɨani, 'ateɨterima wahetsie meta 'ahetsɨa memɨte'uximaya”». ");
INSERT INTO hch_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Hikɨ Yawé Muitsexi mɨpaɨ katiniutahɨawe: «'Aruni mɨpaɨ ketineutahɨawi yu'itsɨ haa manuyehapane keheutatsera, 'aki manuyehapane, harakuna mayemanetsie, naitsarie 'Ekipitu kwieyaritsie temutsi memɨtixuawerekɨ». ");
INSERT INTO hch_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","'Aruni yu'itsɨ kaneutatsera haa 'ekipitu miemetetsie, temutsi mekaniutixuawere naitsarie. ");
INSERT INTO hch_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Hikɨ temaiwawemete 'awie kememɨte'uyemate yaxeikɨa mekateniuyurieni, mɨpaɨ mete'uyurieku temutsi mekaniutixuawere naitsarie 'Ekipitu. ");
INSERT INTO hch_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Hikɨ Parahuni, Muitsexi 'Aruni mame kaniwarutakwewieni. Mɨpaɨ katiniwarutahɨawe: —Yawé xekeneutawawiri temutsi mɨwataweiyakɨ nehetsie meta neteɨterima wahetsie, neta nepɨxepitɨani xemɨyehukɨ xemɨteheitimawirienikɨ. ");
INSERT INTO hch_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Muitsexi mɨpaɨ katinita'eiya: —Yanetineutahɨawi kepauka nepitawawirieni Yawé 'ahetsiemieme, 'ahetsɨa memɨte'uximaya meta 'ateɨterima wahetsiemieme. Temutsi Niru hatɨayaritsie mekaniyuhayewakuni xeikɨa, 'ahetsie meta 'akie mepɨkatixuawere. ");
INSERT INTO hch_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Parahuni mɨpaɨ katinita'eiya: —'Uxa'a kwitɨwa. Muitsexi mɨpaɨ kaniutayɨni: —Mɨpaɨ kaniyɨmɨkɨ, pekatinetimaimɨkɨ xewitɨ kakaɨyari kaniumaweni Yawé takakaɨyari hepaɨ 'anetɨ. ");
INSERT INTO hch_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Temutsi mekaniyehuni mekanikumawerikuni 'ahetsie 'akiita meta 'ahetsɨa memɨte'uximaya wahetsie metatsiere 'ateɨterima wahetsie, Niru hatɨayaritsie xeikɨa mekaniyuhayewakuni. ");
INSERT INTO hch_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Yapauka mewayekɨneka Muitsexi 'Aruni matɨa Parahuni hamatɨa metehetaxataka, Muitsexi Yawé kaniutawawirieni temutsi mɨwakumaweriyakɨ Parahuni hetsɨa mɨwareyenɨ'akai. ");
INSERT INTO hch_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Muitsexi Yawé kemɨtiutahɨawekai nenu'enieni, temutsi mekaniutayuani mekwi'itɨ, kiita, takwa meta yeuta. ");
INSERT INTO hch_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Teɨteri mekaniwakuxexeɨriwakaitɨni wa'ɨakariyari naitɨ 'Ekipitu kanakɨnɨkaitɨni. ");
INSERT INTO hch_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Hikɨ Parahuni 'aixɨa 'iyarieya kaniuyɨni, peru Yawé 'iyarieya kaniutseiriya, Yawé kemɨtiwarahɨawekai, Muitsexi 'Aruni mame pɨkawa'enimɨkɨkai. ");
INSERT INTO hch_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Yawé Muitsexi mɨpaɨ katiniutahɨawe 'Aruni mɨpaɨ mɨtitahɨawekɨ: «'A'itsɨ keneutatsera kwiepa ketineukawaxɨa, naitɨ 'Ekipitu kwieyaritsie kwauni xaipɨtsi memayexɨrienikɨ». ");
INSERT INTO hch_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Mɨpaɨ katiniuyurieni. Hikɨ 'Aruni yu'itsɨkɨ kwiepa katiniukawaxɨani, hikɨ kwaunitɨtɨ xaipɨtsi mekanayexɨrieni teɨteri mekaniwakukewekaitɨni meta tewaxi. Naitsarie 'Ekipitu kwieyaritsie kwauni xaipɨtsi mekanakɨne. ");
INSERT INTO hch_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Temaiwawemete 'awie memɨte'uyemate mɨpaɨtsiere mekateniyurienikekaitɨni mekaniuyutatexieni. Matsi xaipɨtsi teɨteri meta watewama mekaniwakukewekaitɨni. ");
INSERT INTO hch_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Mɨpaɨ mekaniutiyuani temaiwawemete Parahuni hɨxie: «Yemekɨ Kakaɨyari wahamatɨa puyeika». Peru yu'iyari kaniutseiriya pɨkawaru'eni, Yawé kemɨtiwarahɨawekai. ");
INSERT INTO hch_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Yawé Muitsexi mɨpaɨ katiniutahɨawe: «'Uxa'a ximeri pekananukukemɨkɨ, Parahuni 'utɨa pekaniyemieni, hata mɨkatenitsie mɨpaɨ pekatinitahɨawimɨkɨ: “Mɨpaɨ paine Yawé: ‘Neteɨterima keniwarupitɨa memɨyehukɨ memɨnetsi'ayexeiyanikɨ. ");
INSERT INTO hch_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Xɨka pekawarupitɨani, yɨmɨireme nakatarixi nepɨwaranunɨ'ani 'ahetsie, meta 'ahetsɨa memɨte'uximaya, 'ateɨterima wahetsie meta 'akie. Naitɨ 'ekipitutari wakiita meta kwiepa memanu'uwa mepɨtihɨne nakatarixi. ");
INSERT INTO hch_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Kepauka mɨpaɨ mɨtiyɨni, Kutseheni xeikɨa mepɨkatixuawere, mana neteɨterima memɨtiteikɨ, 'ana mɨpaɨ pepɨretimani ne Yawé, 'ikɨ kwieyaritsie nepuyeika. ");
INSERT INTO hch_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Yɨkɨmeteyuxexeiyame neteɨterima nepɨwarayeitɨani 'ateɨterima wahetsɨa, 'ikɨ 'inɨari mɨmariwe 'uxa'a paye'ani’”». ");
INSERT INTO hch_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Mɨpaɨ katiniuyurieni Yawé. Haiwitɨri 'a'ayetsutsuitɨ nakatexɨani Parahuni paratsiyuyatsie meta hetsɨana memɨte'uximaya wakii hetsie meta naitsarie 'Ekipitu, nakatarixi xeikɨa mekanihɨkɨakaitɨni. Nakatarixi wahekɨ 'Ekipitu kiekariyaritsie 'axakatinayeyɨni. ");
INSERT INTO hch_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Hikɨ Parahuni, Muitsexi 'Aruni mame kaniwarutakwewieni, mɨpaɨ katiniwarutahɨawe: —Xekenehu xeketeneutimawiri yukakaɨyari 'ena 'ikɨ kwieyaritsie. ");
INSERT INTO hch_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Muitsexi mɨpaɨ kaniutayɨni: —Mɨpaɨ 'aixɨa pɨkayɨni, tame temɨtetimawa Yawé hetsiemieme 'ekipitutari wahepaɨtsita puxurikime, xɨka wahɨxie tete'utimawa wahepaɨtsita mɨkareuyewetse hepaɨ xɨari mepɨtatsitituaxa. ");
INSERT INTO hch_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Tepɨyehukaku haika tukari te'uhutɨ makumawetsie paitɨ, mana temɨteheitimawirienikɨ Yawé takakaɨyari mɨpaɨ katatini'aitɨaka. ");
INSERT INTO hch_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Parahuni mɨpaɨ katinita'eiya: —Nepɨxepitɨani xemɨte'imawirieyukɨ Yawé yukakaɨyari humapaitɨ. Peru 'ateewapai xekahekɨkatɨ, meta xepeitawawirieni nehetsiemieme. ");
INSERT INTO hch_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Muitsexi Parahuni mɨpaɨ katiniutahɨawe: —Ne'anuyeyame 'uwa ne Yawé 'ahetsiemieme nepeitawawirieni, hikɨ 'uxa'a nakatarixi wahepaɨ memɨ'anene mepumaweni 'ahetsie, 'ahetsɨa memɨte'uximaya meta 'ateɨterima wahetsie. Perutsɨ pepɨkatatiku'itaiyani, pekatatsipitɨanike pekatiutaine temɨtemawayukɨ Yawé hetsiemieme. ");
INSERT INTO hch_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Muitsexi hewayeyaka Yawé nenewieri kaniupitɨani Parahuni hetsiemieme. ");
INSERT INTO hch_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Yawé kani'enieni Muitsexi Parahuni hetsiemieme kemɨtitawawiriekai, nakatarixi kaniwarukumaweriya Parahunitsie. Memɨte'uximaya, meta teɨterimama wahetsie nixewitɨ pɨkayuhayewaxɨ. ");
INSERT INTO hch_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Matsi Parahuni tawarita yu'iyari kaniutse'iriya, pɨkawarupitɨa memɨyehukɨ. ");
INSERT INTO hch_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Hikɨ Yawé Muitsexi kaniutanɨ'ani, Parahuni mɨpaɨ mɨtitaxatɨanikɨ: «Mɨpaɨ kanaineni Yawé hepɨrayutsixi teɨteriyari wakakaɨyari: “Keniwarupitɨa neteɨterima memayekɨnekɨ memɨnetsi'ayexeiyanikɨ”. ");
INSERT INTO hch_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Xɨka pekawarupitɨani memɨyehukɨ, xɨka 'akuxi pewarukununuitɨwani, ");
INSERT INTO hch_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","Yawé yɨtɨrɨkariyakɨ kwiniya pɨnetɨani 'atewama wahetsie, kawayutsixi, puxuri, kameyutsixi, wakaitsixi meta 'amuxatsi. ");
INSERT INTO hch_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Peru Yawé 'ixaheritsixi watewama meta 'ekipitutari watewama wahamatɨa yukɨmeteyuxexeiyame pɨwarayeitɨani, 'ayumieme 'ixaheritsixi watewama nixewitɨ pɨkamɨni». ");
INSERT INTO hch_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Hikɨ Yawé tukari kaniutipini, mɨpaɨ kaniutayɨni: «'Uxa'a, ne Yawé mɨpaɨ nekatiniyurimɨkɨ 'ikɨ kwieyaritsie». ");
INSERT INTO hch_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Mɨpaɨ katiniuyɨni, 'uxa'arieka mekaniukwini yunaitɨ 'ekipitutari watewama, peru 'ixaheritsixi watewama nixewitɨ pɨka'umɨ. ");
INSERT INTO hch_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Hikɨ Parahuni hipame kaniwarenɨ'ani, memɨwaxeiyayukɨ 'ixaheritsixi watewama, mɨkɨ mekaniwaretaxeiya yaxeikɨa meyupaɨmeme, nixewitɨ pɨkahemɨkikai. Peru hikɨ Parahuni yu'iyari kaniutseiriya pɨkawarupitɨa memɨyehukɨ. ");
INSERT INTO hch_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Merikɨtsɨ Yawé mɨpaɨ katiniwarutahɨawe Muitsexi 'Aruni mame: «Xekeniwayetuka naxi 'uxunuta mieme 'etsipeme, mɨkɨ Muitsexi teikɨ keheiwiwieni Parahuni hɨxie. ");
INSERT INTO hch_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Mɨkɨ naxi tumuanari miyɨanitɨ kanayeimɨkɨ, kanikawiwimɨkɨ naitsarie 'Ekipitu kwieyaritsie, mekaniti'etsatakuni, teɨteri meta watewama yunaitɨ». ");
INSERT INTO hch_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Muitsexi 'Aruni matɨa naxi mekanetuni 'uxunutamieme, Parahuni hɨxie meti'uka Muitsexi kaneiwiwieni 'ekatsie, 'anari mekaniuti'etsata, teɨteri yaxeikɨata watewama. ");
INSERT INTO hch_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Temaiwawemete mepɨkayɨwawekai Muitsexi hepaɨ memɨteyurienikɨ, mɨkɨtsɨ yunaitɨ meta mana kiekatari mekaneu'etsatɨkateitɨni. ");
INSERT INTO hch_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Peru Yawé Parahuni 'iyarieya kaniutseiriya, Yawé Muitsexi kemɨtiutahɨawekai, 'ayumieme Parahuni Muitsexi 'Aruni mame pɨkawa'enimɨkɨkai. ");
INSERT INTO hch_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Merikɨtsɨ Yawé Muitsexi tawarita kanitanɨ'ani, 'uxa'arieka ximeri kaneyani Parahuni mɨtitaxatɨanikɨ: «Yawé mɨpaɨ kanaineni hepɨrayutsixi wakakaɨyari: “Keniwarupitɨa neteɨterima memɨnetsi'ayexeiyanikɨ. ");
INSERT INTO hch_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Hikɨri 'imatɨrieka waɨkawa mariwemekɨ nepɨmatsi'anunɨ'airieni kwiniya 'ahetsiemieme, yaxeikɨata te'a'uximayatsiriwamete wahetsie, para mɨpaɨ pemɨretimanikɨ kename xewitɨ 'umawe 'ena kwiepa nehepaɨ tiyurienetɨ. ");
INSERT INTO hch_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Xɨka hikɨ kwitɨwa mɨpaɨ netiuyurieni 'ahetsie, 'ateɨterima wahetsieta kwiniya kwi mayakamekɨ yunaitɨ xekanikwikuni. ");
INSERT INTO hch_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Peru hikɨ nepɨmatsihayewa 'akuxi para pemɨretimanikɨ kenemɨtiyurieni, para nemukuxaxatsiwanikɨ naitsarie kwiepa. ");
INSERT INTO hch_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","'Ekɨ matsi yaxeikɨa pepɨtiyuriene, neteɨterima pekawapitɨatɨ mɨkɨ memayekɨnekɨ. ");
INSERT INTO hch_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","'Ayumieme 'uxa'a hikɨ hepaɨ 'upaukakaku, nekanenunɨ'amɨkɨ wiyeri teemakame mɨkatiyɨwekai hepaɨ hatsuaku 'Ekipitu mukamarixɨtsietɨtɨ. ");
INSERT INTO hch_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Mexɨima ketineuta'aita 'atewama kiitɨa memɨwareuta'arienikɨ ketipaɨmeme pemɨrexeiya yeuta, yaxeikɨata teɨteri, kemɨ'ane takwa muyeikani tee hetsiena kanikaxɨrimɨkɨ kanimiemɨkɨ”». ");
INSERT INTO hch_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Hipatɨ Parahuni te'uximayatsiriwamete mekaniutimamani Yawé niukieya me'u'enieka, meyumexɨitɨatɨ kiita mekaniwareuta'ɨna yuteɨterima meta yutewama, ");
INSERT INTO hch_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","hipatɨta mepɨkahenu'eni Yawé niukieya, mepɨwaruhayewaxɨ tehɨwemete yaxeikɨata yutewama. ");
INSERT INTO hch_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Merikɨtsɨ Yawé mɨpaɨ Muitsexi katiniutahɨawe: «'Amamate teikɨ keneutitseraxɨa, para naitsarie mɨkaxɨrienikɨ tee wiyeriyari 'Ekipitu kwieyaritsie, teɨteri wahetsie yaxeikɨata wawaxata meta watewama wahetsie». ");
INSERT INTO hch_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Muitsexi yu'itsɨ 'anukukweka muyuawitsie kaneititsera, Yawé yakatiniuyurieni tee mɨkaxɨrienikɨ naitsarie 'Ekipitu: tɨranari kaneyenɨ'ani, tee wiyerimatɨ mɨkaxɨrienikɨ meta merɨkariya. ");
INSERT INTO hch_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","'Anari kaniukawiye teematɨ, kanikaxɨrɨwekaitɨni taimatɨ. Naitsarie 'Ekipitu kwieyaritsie hatsuaku mɨkareyɨwekai hepaɨ katiniuyɨni. ");
INSERT INTO hch_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Mɨkɨ tee wiyeriyari naime katiniwareuyehɨani mɨkɨ kwieyaritsie, teɨteri meta yeutari, yaxeikɨata mɨti'etsiekai meta kɨyexite. ");
INSERT INTO hch_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Kutseheni mɨrakutewatsie xeikɨa tee wiyeriyari pɨka'ukaxɨri hakewa 'ixaheritsixi memetitekai. ");
INSERT INTO hch_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Merikɨtsɨ Parahuni katiniwarutanɨ'airieni, Muitsexi 'Aruni mame mɨpaɨ katiniwarutahɨawe: —Ne hikɨ nepɨretima 'axakenemɨtiyuriene. Yawé 'aixɨa pɨtatsiyuriene, tame pɨta 'axatepɨteyurie neteɨterima teyunaitɨ. ");
INSERT INTO hch_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Hawaikɨ tawariri nepɨkawakunuitɨani, nepɨwapitɨani memayekɨnekɨ, perutsɨ Yawé xekenetawawiri nehetsimieme, tɨranari meta tee wiyeriyari mɨkaxuawenikɨ. ");
INSERT INTO hch_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Mɨpaɨ kaniutayɨni Muitsexi: —Kepauka nemayeyani 'ikɨ kiekaritsie, Yawé nenewieri nepɨpitɨani, 'anari kayuwatɨ tɨranari kanitamarimɨkɨ meta tee wiyerimatɨ, mɨpaɨ pepɨretimani kename kwie Yawé tipiinieya. ");
INSERT INTO hch_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Matsi 'akuxi ne mɨpaɨ nepɨtimate, 'ekɨri meta te'uximayatamete, xepɨka'imakaxe Yawé Kakaɨyari 'akuxi. ");
INSERT INTO hch_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Rinu 'iteɨriyari meta tsewara naitɨ putitsanixɨ, 'ariri tsewara pɨtihariximekai, meta rinu 'iteɨriyari puxutukairi. ");
INSERT INTO hch_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Peru tɨriku xeikɨa pɨkaheuyewe, meta 'etsiperita tɨriku hepaɨ mɨ'anene, mɨkɨ pɨkamexɨa 'arike putixuxuawere. ");
INSERT INTO hch_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Merikɨte Muitsexi 'anuyeyaka Parahuni mɨtiwa'aitatsie, nenewieri Yawé kaniupitɨani, 'anari kwitɨwa kaneunuani tɨranari meta tee wiyerimatɨ, kwiepa naitsarie. ");
INSERT INTO hch_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Kepauka munierixɨ Parahuni kawiyekakuri tee meta tɨranari meta merɨkariya kayuwatɨ putamarixi. Mɨkɨ yaxeikɨata waɨkawa tiyurienetɨ patɨa, meta te'i'uximayatsiriwamete mepɨka'uyuwaɨri hepaɨna yu'iyaritsie. ");
INSERT INTO hch_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Yaxeikɨa puyɨ Yawé Muitsexi kemɨrehɨawekai, ti'aitame Parahuni yu'iyaritsie pɨtse'ikai pɨkawarupitɨa 'ixaheritsixi memayekɨnekɨ. ");
INSERT INTO hch_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Hikɨ Yawé Muitsexi mɨpaɨ katiniutahɨawe: «Kenemie Parahuni ketinetaxatɨa, netsɨ nepɨtiuyuri kayuwaɨriyame nemayeitɨa meta te'i'uximayatsiriwamete wa'iyari nemutseiriyaxɨa, yanemɨtiyurienikɨ wahɨxie 'inɨari mamariwawemekɨ. ");
INSERT INTO hch_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","'Ayumieme nepɨtiuyuri para pemɨtiwataxatɨanikɨ, 'aniwema 'ateukarima 'ekipitutari kenemɨtiwarukwinitɨa, 'inɨari kenemɨtiuwewi wahetsɨa. 'Ana mɨpaɨ mepɨtehetimani kename ne Yawé nehɨkɨ». ");
INSERT INTO hch_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Muitsexi 'Aruni hamatɨa Parahuni hɨxie mekaniti'uni mɨpaɨ mekatenitahɨawe: «Yawé mɨpaɨ kanaineni, hepɨrayutsixi wakakaɨyari: “¿Kepaukake pepɨkatunumakeni nehetɨa? Keniwarupitɨa memayekɨnekɨ neteɨterima, para memɨnetsi'ayexeiyanikɨ. ");
INSERT INTO hch_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Xɨka pekawarupitɨani memɨyehukɨ, 'uxa'a kwitɨwa 'utsikari mepɨtixuawere naitsarie 'akwietsie. ");
INSERT INTO hch_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Yuwaɨkawatɨ mepɨtixuawere kwie pɨkayuhekɨaka, mepɨtekuxɨxɨani 'etsiwa mutiyuhayewaxɨ tee 'uxɨrieku, tinaime mepɨtekakɨme kɨyexite. ");
INSERT INTO hch_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","'Akiita mekanitahɨnikuni, te'uximayatamete wahetsɨa meta yaxeikɨa 'ekipitutari yunaime wakiita. Waɨkawa pɨtiyɨni kememɨkatenieriwawekai xepaapama kepauka kiekari memukamatsie hikɨ 'ena matimietsie 'akuxi”». Mɨpaɨ 'utayɨka Muitsexi ta'aurie kanaweni, kaniwayeyani Parahuni mɨtiwa'aitatsie. ");
INSERT INTO hch_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Merikɨtsɨ Parahuni mɨtiwa'aitɨakai mɨpaɨ mekatenitahɨawe: —¿Kepaukake 'ikɨ pɨtihayewa tawiniyari hɨkɨtɨtɨ? Keniwarupitɨa memeuhunikɨ teɨterimama, para memeyexeiyanikɨ Yawé yukakaɨyari. 'Ekɨ xɨari 'atsipepɨkatimate mepɨte'uka'eniwa 'ekipitutari. ");
INSERT INTO hch_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Parahuni katiniwarutanɨ'airieni, Muitsexi 'Aruni mame, mɨpaɨ katiniwarutahɨawe: —Xekenehu Yawé nenewieri xekenepitɨayu yukakaɨyari. Kemɨ'ane xemɨyehu yaxekeneteneutahɨawi. ");
INSERT INTO hch_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Muitsexi mɨpaɨ kaniutayɨni: —Teyunaitɨ tekaniyehuni, temari meta 'ukirawetsixi tahetsɨamiemete yaxeikɨata mepɨtatsi'anuweiya 'ukitsi 'ukari taniwema, tatewamata muxatsi meta wakaitsixi, 'ixɨararitsɨ tekanewewikuni Yawé hetsiemieme. ");
INSERT INTO hch_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Parahuni mɨpaɨ kaniutayɨni: —Yawé xehamatɨa keheyeikani, xɨka nexe'upitɨani xemɨyehukɨ xe'ɨitama yunaime meta xeniwema. Puyuhekɨa heitseriemekɨ xepɨka'utiyuane. ");
INSERT INTO hch_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Kemɨtixenake mɨpaɨ pɨkatiyɨni. Xɨka xeniu Yawé xehetahɨawikuni 'ukitsi xeikɨa xekenehu. Muitsexi 'Aruni hamatɨa mekaniwayexɨriyani Parahuni mɨtiwa'aitatsie. ");
INSERT INTO hch_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Merikɨte Yawé mɨpaɨ Muitsexi katiniutahɨawe: «'Amamá keneutatsera naitsarie 'Ekipitu, memɨ'axɨanikɨ 'utsikari naitsarie kwiepa mɨtixuawe memɨtekakɨmekɨ meta naime tee wiyeriyari mɨtiuhayewaxɨ». ");
INSERT INTO hch_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Muitsexi yu'itsɨ kaniutatsera 'Ekipitu kwieyaritsie naime, Yawé mɨpaɨ katiniuyurieni mɨkɨ tukaritsie kaniu'ekakaitɨni meta tɨkarikɨ, mɨkɨ 'eka tau manatineikatsie patineikakai. Hutarieka mukatarixɨtsie 'eka kaniwa'atɨani 'utsikari, ");
INSERT INTO hch_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","naitsarie mekaniutixuawere mɨkɨ kwieyaritsie. Mekaniyumɨirekaitɨni hatsuaku mɨkareyuwekai hepaɨ, tawari mɨpaɨ pɨkatiyɨni. ");
INSERT INTO hch_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Mepɨyumɨirekai tekɨmemete, kwiepa pɨka'akuhekɨakai mɨkɨ tinaime mekateniukuxɨxɨani, 'iteɨrite meta 'ikwaxite naime muhayewakai tee wiyeriyari, naitsarie 'Ekipitutsie tupiriyate tixaɨ mepɨkate'uhayewaxɨ. ");
INSERT INTO hch_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Parahuni yumexɨitɨatɨ pɨtiwarutanɨ'airi Muitsexi 'Aruni mame, mɨpaɨ katiniwarutahɨawe: «'Axanepɨtiuyuri Yawé mɨxekakaɨyari hetsɨa, yaxeikɨata xehetsɨa. ");
INSERT INTO hch_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Ne nepɨxewawirie xemɨneteheuyehɨwiriekakɨ ke'axanemɨtiuyuri tawarita, meta Yawé yukakaɨyari xekenetawawiri tsikere ne nekie makumawenikɨ 'etsiwa». ");
INSERT INTO hch_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Hikɨ kepauka mɨwayetɨa Muitsexi Parahuni hɨxie, Yawé putawawiri Parahuni hetsiemieme. ");
INSERT INTO hch_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Hikɨ Yawé 'eka kaniupata, meta karima puku'ekaxɨ tau makayuyuipiketsie 'atineka pɨwareuta'enitsitɨa 'utsikari, Haramara Mɨxeta hetsie pɨwareutaxɨri. Hikɨ naitsarie 'Ekipitu kwieyaritsie mepukumawerixɨ 'utsikari. ");
INSERT INTO hch_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Peru yaxeikɨa Yawé Parahuni 'iyarieya putseiriyaxɨ, pɨkawarupitɨa memayekɨnekɨ 'ixaheritsixi teɨteriyari. ");
INSERT INTO hch_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Yawé Muitsexi mɨpaɨ katiniutahɨawe: «'Aheima keneme'i muyuawitsie, naitsarie mɨkɨyɨrekɨ waɨkawa yemekɨ yumayɨinɨatɨ». ");
INSERT INTO hch_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Muitsexi yumamatekɨ teikɨ kanemeni muyuawitsie, 'ana haika tukari kaniukuyɨre kwinimieme 'Ekipitu kwieyaritsie. ");
INSERT INTO hch_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Mɨkɨ tukaritsie 'ekipitutari mepɨkayuxeiyakai, hawaikɨ meuyani pɨkayɨwekai. Matsi 'ixaheritsixi wakiita hekɨariya puxuawekai. ");
INSERT INTO hch_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Hikɨ Parahuni Muitsexi katiniutanɨ'airieni, mɨpaɨ katinitahɨawe: —Xekeneuhuni Yawé xekenayexeiyani. Yuniwema xekeniwarawitɨtɨ, muxatsi meta wakaitsixi xekeniwaruku'eirieka. ");
INSERT INTO hch_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Muitsexi mɨpaɨ katinitahɨawe: —Kamɨtsɨ 'ekɨ mawari temewewienikɨ petatiyetuirieni, Yawé takakaɨyari mawari temewewirienikɨ, ");
INSERT INTO hch_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","matsi tatewama tahamatɨa mekaniyehuni. Hawaikɨ xeikarutsayaritɨma pɨkayuhayewa. Tame mawari temewewienikɨ Yawé takakaɨyari hetsiemieme peuyewetse tatewama wahetsie temɨwaranayehapani, peru 'atsitepɨkatemate kemɨ'ane temɨwayurieni muwapaike teheta'axɨame. ");
INSERT INTO hch_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Perutsɨ Yawé yaxeikɨa pɨtiuyuri Parahuni 'iyarieyatsie, mɨkɨ pɨkawarupitɨa memɨyehukɨ, ");
INSERT INTO hch_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","matsi karima Muitsexi mɨpaɨ pɨtiuhiwi: —Kenanuyeye'a. 'Amarima 'aixɨa tawarita 'uwa pepɨkahamieni nehetsɨa peye'anike. Kepauka tawarita nehetsɨa pemɨye'ani pekanimieriemɨkɨ. ");
INSERT INTO hch_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Muitsexi mɨpaɨ katinita'eiya: —'Aixɨa pekanaineni. Hatsuakuri 'ahetsɨa nepɨkahayeneni. ");
INSERT INTO hch_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Merikɨtsɨ Yawé Muitsexi mɨpaɨ katiniutahɨawe: «Tawarita nepenunɨ'airieni kwiniya Parahuni, yaxeikɨata 'ekipitutari wahetsiemieme, mɨpaɨ tiyɨyu pɨxepitɨani xemɨyehukɨ. Kepauka mɨpaɨ mɨtiyɨni, pɨxe'anuyeweiya yuheyemekɨ. ");
INSERT INTO hch_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Mɨpaɨ ketiniwaretahɨawi 'ateɨterima yunaime, mɨkɨ 'ukitsi meta 'ukari meketewaretawawirieni, xe'aurie memekutetɨka huru meta pɨrata». ");
INSERT INTO hch_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Yawé yakatiniuyurieni 'ekipitutari 'ixaheritsixi 'aixɨa memɨtewaxeiyakɨ, Muitsexi matsi naitsarie 'aixɨa pɨtimatiwakai, Parahuni te'uximayatametemama meta 'aixɨa mepɨte'ixeiyakai. ");
INSERT INTO hch_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Muitsexi mɨpaɨ katiniwarutahɨawe: «Yawé mɨpaɨ kanaineni: “Tɨkari hixɨapa 'Ekipitu naime nepayekexiya, ");
INSERT INTO hch_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","yunaitɨ tɨɨri mexɨakate 'ekipitutari mekanikwikuni: Parahuni matɨarieya hikɨ 'uwenitsie mayerɨni hetsie metsutɨtɨ murinatsie ti'uximayatame nu'ayatsie paitɨ me'u'atɨ, yaxeikɨata watewama mexɨakate memutinunuiwaxɨ. ");
INSERT INTO hch_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Naitsarie 'Ekipitu kwieyaritsie hiwerika putixuawere, kemɨkatiyɨwekai pɨtiyɨni. ");
INSERT INTO hch_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Peru 'ixaheritsixi wahetsɨa tsɨkɨ pɨkahetaha'ani. Mexɨakate teɨteri meta watewama tɨma mepɨkatekwini. 'Anari mɨpaɨ xepɨtehetimani Yawé yɨkɨmeteyuxexeiyame pɨwarayeitɨani 'ixaheritsixi 'ekipitutari wahamatɨa. ");
INSERT INTO hch_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Yunaitɨ mɨkɨ 'ahetsɨa te'uximayatamete mekanenanukuwaukuni, metitunuma'utɨ mɨpaɨ mepɨnetetatsuariwiya: ‘'Ari keneumieni, yunaime pewarawitɨtɨ keyupaɨmetɨ mematsi'aweiya.’ Kepauka mɨpaɨ mɨtiyɨni ne nekaniyemieni”». Hikɨ Mutsexi waɨkawa ha'atɨ kaniwayeyani Parahuni mɨtiwa'aitatsie, mɨpaɨ 'utaitɨ. ");
INSERT INTO hch_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Yawé Muitsexi mɨpaɨ katiniutahɨawekaitɨni kename Parahuni kahenu'enienikekai, meta kename mɨpaɨ matsi reuyewekai, Yawé mariweme mɨtiyurienikɨ 'Ekipitu waɨkawamexɨa. ");
INSERT INTO hch_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Muitsexi 'Aruni matɨa 'inɨari 'ikɨ mɨmamariwawe mepuwewi Parahuni hɨxie, peru Yawé 'iyarieya putseiriyaxɨ, mɨkɨ kwieyaritsie memayekɨne 'ixaheritsixi pɨkawarupitɨa. ");
INSERT INTO hch_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Merikɨtsɨ 'Ekipitu kwieyatrisie Yawé katiniwarutaxatɨani Muitsexi 'Aruni mame. Mɨpaɨ katiniwarutahɨawe: ");
INSERT INTO hch_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","«'Ikɨ metseriyari xehetsiemieme mauyewetse yemekɨ pɨhɨkɨtɨni, 'ikɨ mexɨakame metseriyaritsie xeiwiyari 'aye'axekaku. ");
INSERT INTO hch_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Yunaime 'ixaheritsixi wahamatɨa xeketenetixata, mɨpaɨ xeketeniwaretahɨawi 'ikɨ metseriyaritsie tamamata tukariyaritsie yunaitɨ xeinuiwari memukutetɨkatsie yuxexuime muxatsi mepɨwakwini. ");
INSERT INTO hch_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Xɨka xeme hipatɨ xekayumɨireni xeime muxa xemitaxɨnikɨ xekayɨwaweniri, pɨyɨweni matsi mɨwarumini 'ahurawa kiekatari yu'iwama, me'itaxɨweme teɨteri kememɨyupaɨmeni yuxexuitɨ mekeheitatuixɨani me'itixɨwaweme. ");
INSERT INTO hch_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Tewaxi xeiwiyari mepexeiyatɨkani, tsepa muxa ya tsipu 'aixɨa 'anekame. ");
INSERT INTO hch_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Mɨkɨ mepɨwa'ɨwiyani, tamamata heimana nauka tukari 'ikɨ metseriyaritsie, mɨkɨ tukaritsie mepɨwatimawa 'ixaheritsixi taikai kuyɨreyu. ");
INSERT INTO hch_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Meta xuriya xepɨkwewieni yapapaɨmeme, xemitiwirienikɨ kitenie kɨyeyaritsie meta manuyekatsie, kiita hakewa muxa xemetakwani. ");
INSERT INTO hch_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Mɨkɨ tɨkaritsie kwitɨwa xepitikwani wai warɨkarietɨkaime, tupiriya matsiwi meta paa mɨkakuxanariyarietɨka matɨa. ");
INSERT INTO hch_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Hawaikɨ yuime xepɨkakwaka meta 'etsariekame, matsi pɨta warɨkariekame tɨtsie, mu'uya naime 'ɨkateya mamateya meta kwinuriteya naime. ");
INSERT INTO hch_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Tixaɨtɨ xepɨkatekuhayeikawani. Xɨka xe'itatexieni, 'uxa'arieka xekanitataiyakuni. ");
INSERT INTO hch_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Mɨkɨ muxa mɨpaɨ xekatenikwaikuni: yukamixa xehanakatɨtɨkaitɨ hixɨapa xehayɨhɨatɨkaitɨ, yukakaitsie xe'u'utɨ, 'itsɨ xe'u'ɨtɨ meta mexɨima xekanitakwaikuni. 'Ikɨ Patsikwa Yawé hetsiemieme kanixatsiwani. ");
INSERT INTO hch_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","»Mɨkɨ tɨkariyaritsie 'Ekipitu kwieyaritsie nekaniye'amɨkɨ, yunaime tɨɨri mexɨakate nekaniwakwimɨkɨ, yaxeikɨata tewaxi meta nekaniwaranutaxɨrimɨkɨ kakaɨyarixi 'Ekipitu miemete, ne Yawé nekanihɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Xuriya kani'inɨaritɨkamɨkɨ kemɨ'ane kiita xemayetetɨkani, kepauka nemixeiya 'ateewa nepuyeyani. Hikɨ kepauka nemɨwakwini 'ekipitutari, nixewitɨ kwiniya xehetsie pɨkaye'ani mɨtiyumemiwa. ");
INSERT INTO hch_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","»'Ikɨ tukari 'aitsikayarikɨ xekena'eriwani yuheyemekɨ: 'Ikɨ 'ixɨarari kanihɨkɨtɨni Yawé hetsiemieme, 'uxa'atɨniwarie xeniwema mɨpaɨ meketeyurieka. ");
INSERT INTO hch_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","'Atahuta tukari paa mɨkakuxanariyarie xekanikwakakuni, xeme mexɨakame tukaritsie tikuxanariyame yukiita xekaniwayewiwikuni. Kemɨ'ane mitikwani heiwa mɨkɨ 'atahuta tukaritsie mɨkɨ 'ixaheritsixi watsata kananuyehɨiyamɨkɨ. ");
INSERT INTO hch_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Mexɨakame tukaritsie 'ixɨarari patsiekamekɨ xepuyukuxeɨrieni, meta tawari 'atahuta tukaritsie. Mɨkɨ tukaritsie tixaɨtɨkɨtɨma xepɨkate'uximayaka, xeikɨa pɨyɨweni yu'ikwai mɨtiukawewieni yuxexuitɨ ketipaɨmeme xemɨtekwa'a. Mɨkɨ xeikɨa xemɨtewewieka pɨyɨweni. ");
INSERT INTO hch_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","»Paa mɨkakuxanariyarietɨka 'ixɨarariyari xekaniwewiekuni, mɨkɨ tukaritsie nemɨxe'ayewitɨkɨ 'Ekipitu yaxeyupapaɨmeme. 'Inɨari niukiyari mɨpaɨ paineni, 'uxa'atɨniwarie xeniwema mɨpaɨ mepɨteyurieka mepetinenetɨwani mɨkɨ tukaritsie. ");
INSERT INTO hch_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Paa mepɨtikwani mɨkakuxanariyarietɨka tamamata heimana nauka tukariyaritsie mexɨakame metseriyaritsie taikai me'itsutɨame xeitewiyari heimana xewi taikaiyaritsie 'utiniereme, mɨkɨ metseritsie. ");
INSERT INTO hch_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","'Atahuta tukari xepɨkaheixeiyani tikuxanariyame yukie. Kemɨ'ane tikuxanariyamekɨ mɨtiukwani, tsepa 'ateewapai kiekame yatɨni 'ixaheri tewiyari mɨhɨkɨ, mɨkɨ 'ixaheritsixi wahamatɨa pɨkayuhayewani. ");
INSERT INTO hch_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Tixaɨtɨ tɨma xepɨkatekwaka tikuxanariyame mɨtinɨ'ɨ. Tsepa hakewa xeme'uwani, xepeitikwani paa kakuxanariyariekame». ");
INSERT INTO hch_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Hikɨ Muitsexi kaniwaruta'inieni yunaime 'ixaheritsixi wa'ukiyarima mɨpaɨ katiniwarutahɨawe: «Yapauka yukuraruta xekenehu muxatsi xekeniwaranuyehapani yutɨɨriyama wahetsiemieme, xekeniwarukuya Patsikwa 'ixɨarariyari xemɨwewienikɨ. ");
INSERT INTO hch_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Xeimanukuyarikɨ tupiriya xekeneutihawiyaka muxa xuriyayakɨ yukii kitenieyaritsie matiwetɨkatsie xekeneutiwiri meta manuyekatsie, 'ana xewitɨ pɨkahewayeyeikani 'uxa'ariekake ximeri. ");
INSERT INTO hch_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Kepauka Yawé, mana muyeyani kiekaritsie mɨwakwinikɨ 'ekipitutari. Mɨkɨ pixeiya kitenie xuriyakɨ ra'utɨkaime 'ana yateewa puyeyani, 'ana pɨka'ipitɨani yunɨ'ari mɨtiyumemiwa, muwa pɨkaheutahani mɨxekwinikɨ. ");
INSERT INTO hch_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","»Yaxeketenekakɨni 'ikɨ kenemɨtixekɨhɨawe. 'Ikɨ 'inɨari niukiyari yuheyemekɨ pɨhɨkɨtɨni xehetsiemieme meta xeniwema wahetsiemieme. ");
INSERT INTO hch_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Kepauka kwiepa xemeta'axɨani kwie Yawé mɨxexatɨatsie, xeme mɨpaɨ xepɨtehekahuni 'ikɨ yeiyaritsie. ");
INSERT INTO hch_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Kepauka memɨxeku'iwawiyani xeniwema: “¿Ketita ti'inɨariyari xeme xehetsiemieme 'ikɨ yeiyari?”, ");
INSERT INTO hch_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","mɨpaɨ xepɨtewata'eiya: “'Ikɨ mawari Patsikwa 'ixɨarariyari Yawé hetsiemieme pɨhɨkɨ, kepauka 'Ekipitu 'ixaheritsixi wakii 'aurie puyetɨa yateewa. Pɨwarukwi mɨkɨ 'ekipitutari, peru tame taniwema pɨwarutawikweitsitɨa”». Mɨpaɨ mete'u'enanaka 'ixaheritsixi Yawé hɨxie mekaniukahɨxima'uni, ");
INSERT INTO hch_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","hikɨ yamekatenikakɨne Yawé Muitsexi meta 'Aruni kemɨtiwarahɨawekai. ");
INSERT INTO hch_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Hikɨ tɨkari hixɨapa Yawé kaniwarukwini yunaime tɨɨri mexɨakate mana kiekatari, yunaitɨ yaxeikɨa katiniwaruyurieni meta Parahuni nu'aya meta pɨretsutsixi waniwema mexɨakate, meta tewaxi waniwema mexɨakate. ");
INSERT INTO hch_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Yunaitɨ 'Ekipitu kiekatari mepanuku'ui mɨkɨ tɨkaritsie, yaxeikɨa Parahuni meta te'i'uximayatsiriwamete, waɨkawa putixuawerixɨ hiwerika mɨkɨ kiekaritsie. Hawaikɨ pɨkahekumawekai 'ekipitutari wakiita naitsarie mepuxuawekai mekwikwi'itɨ. ");
INSERT INTO hch_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Hikɨ mɨkɨ tɨkaritsie kwitɨwa Parahuni pɨtiwarutanɨ'airi Muitsexi 'Aruni mame, mɨpaɨ pɨtiwarutahɨawixɨ: «Xekeneuhuni 'ateewapai. Xekenayekɨni nekiekaritsie xeme meta 'ixaheritsixi. Yawé xekenayexeiyani, xemɨnetekɨhɨawe hepaɨ. ");
INSERT INTO hch_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Xeketeniwara'arietɨ yumuxatsi meta yuwakaitsixi xemutiyuane hepaɨ, peru 'ariri xeiya xekeneuhuni, xɨka mɨpaɨ xe'uyɨni ne 'aixɨa nekani'itɨariemɨkɨ». ");
INSERT INTO hch_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","'Ekipitutari, mepɨwamexɨitɨakai 'ixaheritsixi mɨkɨ kwieyaritsie memayekɨnekɨ. Mɨpaɨ meputiyuanekai: «Xɨka mekahekɨne tame tekanikwikuni». ");
INSERT INTO hch_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Hikɨ 'ixaheritsixi, mepikuha'aritɨa yutɨxi 'akuxi kakuxanariyariekame, me'iti'eimaka yu'ixurikitekɨ, mekaneitɨni. ");
INSERT INTO hch_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Meta, 'ekipitutari mepɨte'utawawiyarie Muitsexi kemɨtiwaruta'aitɨakai 'ixaheritsixi, hurukɨ meta pɨratakɨ mɨtiwewiyatɨka meta 'ixurikite 'aixɨa mɨti'anene mekateniwarutawawirieni. ");
INSERT INTO hch_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Yawé 'ekipitutari yapɨtiwaru'iyaritɨa 'ixaheritsixi memɨwatinenimayatakɨ, mɨkɨ mepɨtewarumi ketita memɨte'utawau. Mɨpaɨ 'ixaheritsixi 'ekipitutari mepɨtewarunawairi tinaime. ");
INSERT INTO hch_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","'Ixaheritsixi Xamɨtsexi mekanayekɨne, Tsukuti hepa mekanekɨne. Meka'inɨaritɨ 'ukari meta tɨɨri, 'ataxewi tsienituyari miriyari (600.000) mekaniyupaɨmekaitɨni 'ukitsi yɨ'ɨkama memuhukai. ");
INSERT INTO hch_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Mɨkɨ meta wahamatɨa mekanayekɨne yuwaɨkawatɨ hipatɨ teɨteri meta yumɨiretɨ tewaxi, muxatsi meta wakaitsixi. ");
INSERT INTO hch_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","'Ekipitu tɨxi memeiyetɨkai mɨkɨkɨ paa mɨkakuxanariyarietɨka mekaniutiwewieni, mɨkɨ tɨxi 'akuxi pɨkatsinakai. Memayeweiyariekɨ 'Ekipitu, 'ayumieme tukari mepɨkahehɨi, yu'ikwai memekawewienikɨ. ");
INSERT INTO hch_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","'Ixaheritsixi teɨteriyari 'Ekipitu mepɨtitekai, nauka tsienituyari heimana xeitewiyari heimana tamamata wiyari. ");
INSERT INTO hch_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Merikɨte mɨpaɨ paɨmetɨ wiyari 'aye'aku Yawé kaniwarayewitɨni yuteɨterima 'Ekipitu. ");
INSERT INTO hch_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Mɨkɨ tɨkaritsie Yawé pɨkakutsukai 'ixaheritsixi wa'ɨwiyatɨ 'Ekipitu mɨwarayewitɨnikɨ. 'Ayumieme xemeta nuiwarite xepɨkakutsuni temanutihutsie mɨpaɨ xeketeneyurieka, mɨkɨ tɨkariyaritsie xehe'eriwatɨ meripaitɨ kemɨtiuyuri Yawé xehetsiemieme. ");
INSERT INTO hch_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Yawé mɨpaɨ katiniwarutahɨawe Muitsexi 'Aruni mame: «Mɨpaɨ xekatenikakɨnikuni Patsikwa 'ixɨarariyari hetsiemieme: »Nixewitɨ teewatanaka mana pɨkatikwaka. ");
INSERT INTO hch_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","»Mana memɨtekwaka mekaniyɨwaweni te'a'uximayatsiriwamete 'atuminikɨ pemɨwarutinanai, peru xɨka xitekiya 'inɨariyari pewaruwewirieni meripaitɨ. ");
INSERT INTO hch_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","»Nixewitɨ ti'uximayatame mɨtikwaka pɨkayɨwe yapaɨmexɨa mana muta'axe, meta ti'uximayatame tumini mɨ'iwane. ");
INSERT INTO hch_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","»Patsikwa 'ixɨarariyari kiita kanikwaiwani, meta pɨkayɨwe takwa wai 'etsipeme mɨwayetuni. Yaxeikɨata nixeime 'ume xepɨka'anumurani xemimawa 'umeyari. ");
INSERT INTO hch_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","»Yunaitɨ 'ixaheritsixi peuyewetse memiwewieni Patsikwa 'ixɨarariyari. ");
INSERT INTO hch_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","»Yunaitɨ teewanarixi xehamatɨa memutetɨka xɨka xewitɨ Patsikwa 'ixɨarariyari heuwewimɨkɨni Yawé hetsiemieme, kaniyɨweni meri yuniwema xitekiya 'inɨariyari mɨwawewirieni yunaime 'ukitsi, 'anake pɨyɨweni Patsikwa 'ixɨarariyaritsie mɨtiukwani xekwieyaritsie munuiwakametɨni hepaɨ. »Xɨka ka'inɨaritɨarieka xitekiyakɨ pɨkayɨwe mɨtikwaka. ");
INSERT INTO hch_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","»'Ikɨ 'inɨari niukiyari 'ena nuiwakate pɨwahetsiemiemetɨni meta teewanarixi xehamatɨa memɨtitei». ");
INSERT INTO hch_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Yunaitɨ 'ixaheritsixi yamepɨtekakɨ Yawé Muitsexi 'Aruni mame kemɨtiwarahɨawekai. ");
INSERT INTO hch_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Kwitɨwa mɨkɨ tukaritsie Yawé pɨwarayewitɨ 'ixaheritsixi 'Ekipitu kwieyaritsie, meyumɨireme. ");
INSERT INTO hch_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Merikɨtsɨ Yawé Muitsexi mɨpaɨ katiniutahɨawe: ");
INSERT INTO hch_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","«Mepatsiekame keniwarayeitɨa matɨari memutinunuiwaxɨ. Nehetsɨa mekanimiemetetɨni yunaitɨ mexɨakate 'ixaheritsixi meta xetewama matɨari 'ukitsi memɨtinunuiwa». ");
INSERT INTO hch_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Muitsexi mɨpaɨ katiniwarutahɨawe yunaime 'ixaheritsixi: «Xekena'eriwani 'ikɨ tukari kepauka xemayekɨ 'Ekipitu, hakewa xemɨtehe'uximayakai xekatehepitɨarietɨ meta hakewa Yawé mɨxehayewitɨ yutɨrɨkariyakɨ yatiyurienetɨ. Paa xepɨkakwaka kuxanariyariekame. ");
INSERT INTO hch_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Xeme hikɨ xekanayekɨnikuni, 'ikɨ weiya metseriyaritsie. ");
INSERT INTO hch_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Mɨkɨ metseriyaritsie meta xekaneiwewikuni 'ixɨarari, kepauka Yawé mɨxeheta'atɨani kwie xe'ukiyarima mɨwaruxatɨatsie kename wayetuirieni. Kanixatsiwani kananeutsixi wakwietsie, meta hetitsixi, 'amuxeutsixi, heweutsixi meta kewutseutsixi: kwiepa hakewa retsi waɨkawa meta xiete maxuawe. ");
INSERT INTO hch_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","'Atahuta tukari xekanitikwaikuni paa kakuxanariyarietɨkaime, 'atahutariekatsie tukari 'ixɨarari Yawé hetsiemieme xepɨwewieni. ");
INSERT INTO hch_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Xemanu'uwa pɨtiumaweni tixaɨtɨ tikuxanariyame tinɨtɨ. Hawaikɨ yemekɨ tikuxanariyame xepɨkahexeiyani. Xekanitikwaikuni paa kakuxaxanime mɨkɨ 'atahuta tukari. ");
INSERT INTO hch_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","»Mɨkɨ tukaritsie yuniwema mɨpaɨ xepɨtewatahɨawe: “'Ikɨ mɨya temɨteyurie Yawé hetsiemieme tekateniyurieka, kemɨtiuyuri tahetsiemieme 'Ekipitu kepauka temayekɨtsie”. ");
INSERT INTO hch_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","'Ikɨ pɨ'inɨaritɨni xehetsiemieme xemamatsie ya xekanata pɨxehaye'eritɨwani kename, Yawé niukieya xeteta payekani mɨkɨ 'Ekipitu mɨxe'ayewitɨ, waɨkawa yutɨrɨkariyakɨ tiyurienetɨ. ");
INSERT INTO hch_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Xeiwiyari 'anuyeyeikakaku, mɨkɨ tukaritsie 'ikɨ 'inɨari niukiyari xepaye'atɨwani. ");
INSERT INTO hch_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","»Kepauka Yawé mɨxeheutahatɨani kananeutsixi wakwietsie meta xɨka 'ari xeyetuirieni, kemɨtixe'utahɨawixɨ xeme meta xe'ukiyarima, ");
INSERT INTO hch_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","xekaniyetuiriekuni yunaime mexɨakate meta tewaxi waniwema matɨari miemete 'ukitsi, mɨkɨtsɨ Yawé hetsiemieme mekanihɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Puxu niweya mexɨakame mitawikweitsitɨani pɨyɨwe xeime muxakɨ, xɨkate ka'utawikweitsitɨarieni, yukɨipitɨa pɨwamurarieni. Xemeta yaxeikɨa yunaitɨ yuniwema mexɨakate meta yunuiwarima xemɨwatawikweitsitɨani peuyewetse. ");
INSERT INTO hch_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","»'Uxa'atɨni warie, kepauka memɨxeteta'iwawiya xeniwema: “¿'Ikɨta tita ti'inɨariyari?”, mɨpaɨ xepɨtewatahɨawe: “Yawé waɨkawa mariweme tiyurienetɨ pɨtatsi'ayewitɨ 'Ekipitu kwieyaritsie hakewa waɨriyarika temɨtehe'aitɨariekai. ");
INSERT INTO hch_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Kepauka Parahuni ti'aitame mɨkatatsihepitɨa temayekɨnekɨ, Yawé tɨɨri mexɨakate pɨwarekwi yunaime 'ekipitutari, yaxeikɨata watewama mexɨakate. 'Ayumieme Yawé tatewama mexɨakate 'ukitsi tepitimawiriwa, mɨpaɨ taniwema mexɨakate tepɨtewarutawikweitsitɨwa”. ");
INSERT INTO hch_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Mɨkɨ pɨ'inɨaritɨni xemamatsie yatɨni xekanata, Yawé mɨxe'ayewitɨ 'Ekipitu yutɨrɨkariyakɨ tiyurienetɨ». ");
INSERT INTO hch_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Kepauka Parahuni mɨwarupitɨa memɨyehukɨ 'ixaheritsixi, Kakaɨyari pɨkawarewitɨ piritsiteutsixi wakwietsie, mana matsi pehurakai, mɨpaɨ pɨtiu'eri: «Xɨka mehetakwi'iwa mepetimamani mepeyuti'iyaritɨani 'Ekipitu mepakunuaxɨani yu'utɨma». ");
INSERT INTO hch_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","'Ayumieme pɨwarewitɨ makumawetsie 'ateewapai watatunitsitɨanike, mekanekɨne Haramara Mɨxeta hepatsie. 'Ixaheritsixi mekanayekɨne 'Ekipitu memeuyukwiyuni hepaɨ meteheuku'utɨ. ");
INSERT INTO hch_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Muitsexi Kutse 'umeyariteya kane'ɨni, kemɨtiwaruhɨritɨakai 'ixaheritsixi teɨteriyari. Kutse mɨpaɨ kaniutayɨkaitɨni: «Mɨpaɨ xeketenemaika Kakaɨyari kanayenemɨkɨ xeparewienike. Kepauka mɨpaɨ mɨtiyɨni, ne'umete xekenanu'ɨi». ");
INSERT INTO hch_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","'Ixaheritsixi mekanayekɨne Tsukuti mɨrakutewatsie, 'Etami mekaniu'axɨani, makumawe mɨyetsutɨtsie. ");
INSERT INTO hch_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Tukarikɨ, Yawé kaniumiekatɨni wahɨxie haiwitɨritɨtɨ, 'a'uwetɨ waxeitsitɨatɨ huye kemɨreuyune, yɨwikɨtata pɨwahekɨariwiyakai tai 'a'uwetɨ panuyekatei xawatɨtɨ. 'Ayumieme mepɨyɨwawekai memuhunikɨ tukarikɨ meta tɨkarikɨ. ");
INSERT INTO hch_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Hatsuaku pɨkatiuhayewaxɨ hai 'amuyekatei teɨteri waruwitɨximetɨ tukarikɨ meta tai 'amuwekai yɨwikɨta waruwitɨximetɨ. ");
INSERT INTO hch_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Yawé Muitsexi mɨpaɨ katiniutahɨawe: ");
INSERT INTO hch_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","«'Ixaheritsixi mɨpaɨ ketiniwarutahɨawi meke'ukunuaxɨani Pi-'Akiruti hɨxie mekekuyaxe, Mikiruri meta haramara wahixɨapa. Haramara tetsita mekekuyaxe, Wahari-Tsepuni hɨxie. ");
INSERT INTO hch_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Parahuni mɨpaɨ pɨti'erieni: “'Ixaheritsixi mekaneuyexɨrieni mɨkɨ kwieyaritsie. Makumawe kaniwakunaka”. ");
INSERT INTO hch_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Ne, nepipitɨani 'iyarieya tse'ime Parahuni, mɨxe'anukuweiyakɨ. Peru ne mariweme nepaneyeitɨani Parahuni hɨxie meta kuyaximama wahɨxie. 'Ana 'ekipitutari mɨpaɨ mepɨtehetimani kename ne Yawé nehɨkɨ». Hikɨ mɨpaɨ mekaniuyɨni 'ixaheritsixi. ");
INSERT INTO hch_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Kepauka 'Ekipitu ti'aitame mɨretima, kename teɨteri mehekɨnekai, hikɨ mɨkɨ meta te'i'uximayatametemama mepuyupataxɨ, mɨpaɨ meputiyua 'ixaheritsixi wahetsiemieme: «Neuxei ketete'uyuri. ¿Titayari tetewarupitɨa 'ixaheritsixi memɨyehukɨ meta yu'uximayatsika memuku'eirienikɨ?» ");
INSERT INTO hch_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Merikɨte 'ana kwitɨwa Parahuni katiniuta'aita kaxetaya mukuha'aritsienikɨ meta kuyaximama memuyukuha'aritɨanikɨ, ");
INSERT INTO hch_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","kaniwaruta'inieni 'ataxewime tsienituyari kaxetate 'aixɨa mɨ'anene, meta hipame kaxetate 'Ekipitu mieme, xexuitɨ kaxetatetsie kuyaxi mekanati'utɨkateitɨni. ");
INSERT INTO hch_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Yawé Parahuni 'iyarieya kaniutseiriya 'Ekipitu ti'aitame, para 'ixaheritsixi mɨwaranukuweiyakɨ, mɨkɨ mekaniuhukaitɨni mete'ayu'iwake meyu'erietɨ. ");
INSERT INTO hch_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Yunaitɨ Parahuni kuyaximama mekaniwaranukuweiya, kawayutsixi wahetsie me'utetɨ, kaxetate kuyaxa miemete mewaruhapatɨ, hikɨ 'ixaheritsixi mekaniwaranuku'axe haramara tetsita paitɨ mekaniwarutaxeiya, hehurakaku Pi-'Akiruti meta Wahari-Tsepuni hɨxie. ");
INSERT INTO hch_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Parahuni kanaye'aximekaitɨni. Kepauka 'ixaheritsixi memɨyu'ɨwiyaxɨ 'ekipitutari mepɨwaruxei 'ari hura me'ahukame, hikɨ waɨkawa mekaniutimamani, Yawé mekaniutahɨawe. ");
INSERT INTO hch_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Hikɨ mɨpaɨ Muitsexi mekateniutatieni: —Kamɨtsɨ karexɨawekai 'Ekipitu kwie temekateukienikɨ, ¿titayari petareyewitɨ 'enapaitɨ makumawetsie temɨkwinikɨ? ¿Kehapaɨtɨtɨ pepɨtatsiyuriene? ");
INSERT INTO hch_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Yatepaitɨkatei 'Ekipitu paitɨ: “Ketaneuhayewa. Pɨtatsinake 'ekipitutari temɨtewa'uximayatsirieka”. Matsi 'aixɨa pɨ'anekai temɨteware'uximayatsiriekakɨ, 'ena temɨkakwinikɨ makumawetsie. ");
INSERT INTO hch_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Muitsexi mɨpaɨ kaniutayɨni: —Xepɨkaheumamaka. Xeme kayuwatɨ xeketeneteni, hikɨ kwitɨwa xemunenierixɨ xepɨhɨkɨtɨni, Yawé wikweitsitɨarika kemɨrexeiya xehetsiemieme. Hikɨ mɨkɨ 'ekipitutari xemɨwaxeiya hatsuakuri tawarita xepɨkawaxeiya. ");
INSERT INTO hch_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Xeme kayuwatɨ xekeneumaka, Yawé pɨta puyutamieni xehetsiemieme. ");
INSERT INTO hch_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Peru Yawé mɨpaɨ Muitsexi katiniutahɨawe: «¿Ketitayari ne penerahɨawe? 'Ixaheritsixi mɨpaɨ ketiniwarutahɨawi memayekɨnekɨ. ");
INSERT INTO hch_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","'Ekɨta 'a'itsɨ keneutatsera haramara heima, haa kananutayepierimɨkɨ mana memukɨnekɨ 'ixaheritsixi 'ayewakikaku. ");
INSERT INTO hch_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Ne 'ekipitutari wa'iyari nepɨtseiriya para memɨxe'anukuweiyakɨ. Ne mariweme nepɨtiyurieni. Parahuni kuyaximama, kaxetate meta teɨterimama memutei nepɨwareuyehɨani. ");
INSERT INTO hch_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Kepauka mɨpaɨ nemɨtiyurieni, 'ana 'ekipitutari mɨpaɨ mepɨtehetimani kename ne Yawé nehɨkɨ». ");
INSERT INTO hch_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Hikɨ niuki tuayame Kakaɨyari hetsɨa mieme 'ixaheritsixi wahɨxie mumiekai, ta'aurie kanaweni wa'utɨma pɨta kaniyuhayewa. Yaxeikɨata kaniuyɨni hai 'amuwekai wa'utɨma pɨta kaniutakeni, ");
INSERT INTO hch_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","'ekipitutari wahɨxie tai puke 'ixaheritsixi wahekɨariwiyatɨ. Mɨkɨ tɨkaritsie mɨkɨ hai hipame wahetsiemieme pɨyɨriyatɨkai hipame wahetsiemiemeta pɨhekɨariyatɨkai, 'ayumieme mɨpaɨ ti'anekaku mepɨkayɨwawekai memuyuxeiyanikɨ. ");
INSERT INTO hch_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Hikɨ Muitsexi yu'itsɨ kaneutatsera haramara heima, Yawé 'eka kaneyenɨ'ani mɨkɨ tɨkarikɨ tau manatineika mieme karima kaniu'ekakaitɨni 'anari haramara kananutayepiere, ya'atayeutɨ heutanetɨ kanayewani, kwie wakitɨ kanahekɨare. Haa haramara kananutayepiere, ");
INSERT INTO hch_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","'ixaheritsixi mana mekaniukɨne kwie wakimetsie me'uhutɨ. Haramara kaniti'ukaitɨni 'ixumeri hepaɨ watserieta meta wa'utata. ");
INSERT INTO hch_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Hikɨ 'ekipitutari mekaniwaranukuweiya. Yunaitɨ memutekai kawayutsixi wahetsie meta kaxetatetsie, yunaitɨ Parahuni hetsɨamiemete mekanekɨneta wa'utɨma. ");
INSERT INTO hch_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Merikɨte kepauka mɨkahekɨarirɨmekairi, Yawé kaniwaruxeiya kuyaxi 'ekipitutari, tai haikɨriyaritsie paitɨ meta haiwitɨritsie paitɨ, hikɨ 'ana mɨkɨ 'axapɨwaruyuri: ");
INSERT INTO hch_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","mɨpaɨ katiniuyurieni, wakaxetate pukahapawakai mɨpaɨ tiuyurieku 'uxi mepɨyɨakai mepɨka'ayekɨniwawekai. Hikɨ 'ayumieme mɨpaɨ 'ekipitutari mekateniutihiwatɨkɨne: «Tepɨwahayewa 'ixaheritsixi, Yawé puyumiene wahetsiemieme, pɨtatsikwine». ");
INSERT INTO hch_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Hikɨ Yawé mɨpaɨ Muitsexi katiniutahɨawe: «'Amamá keneutatsera haramara heima, para haa mɨwareuyehɨanikɨ 'ekipitutari meta wakaxetate metatsierie teɨteri memutei». ");
INSERT INTO hch_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Merikɨte Muitsexi yu'itsɨ kaneutatsera haa heima, 'ari katarirɨmekaku, hikɨ haramara 'aixɨa kaniuyɨni matɨari hepaɨ. 'Ekipitutari me'uyuta'unaku yu'utɨma haa puwaranukunakixɨ, mɨpaɨ Yawé pɨtiwareuyehɨa haramara tetɨata. ");
INSERT INTO hch_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Haramara heitserie 'anuyemareku, kaniwarukayunitɨani kaxetate meta teɨteri memutei Parahuni hetsɨa miemete, meta yunaitɨ kemɨ'ane 'ixaheritsixi memɨwaranukuweiyakai. Mɨkɨ nixewitɨ pɨka'utawikwei. ");
INSERT INTO hch_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Peru 'ixaheritsixi teɨteriyari mekananukɨne kwie wakimetsie haramaratsietɨtɨ, mɨkɨ wahetsiemieme haa 'ixumeriyari kanihɨkɨtɨkaitɨni watserieta meta wa'utata. ");
INSERT INTO hch_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Mɨkɨ tukaritsie Yawé mɨpaɨ katiniwaruwikweitsitɨani 'ixaheritsixi 'ekipitutari mewakwikukaku. 'Ixaheritsixi 'ekipitutari wakaxarite mekaniuxeiya haramara tetsitapaitɨ metiheikame. ");
INSERT INTO hch_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Mɨya mete'uneniereka 'ixaheritsixi, yutɨrɨkariyakɨ kemɨtiuyuri 'ekipitutari wahetsie, mɨkɨ mekaniutimamani Yawé yuri mekateniuta'eririeni, yaxeikɨata Muitsexi 'iparewiwameya. ");
INSERT INTO hch_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Hikɨ Muitsexi meta 'ixaheritsixi xeime kwikari mekaniutakwika Yawé hetsiemieme, mɨpaɨ kananuyɨneni: Yawé nepɨtanɨawa, mariwemekɨ mɨrayu'iwaxɨkɨ haramaratsie pɨwareukaxɨri kawayutsixi meta teɨteri memutekai. ");
INSERT INTO hch_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Yawé pɨnetɨrɨkariya meta pɨnekwikari, mɨkɨ pɨnetsiwikweitsitɨwame. Mɨkɨ pɨnekakaɨyari, nepinɨawani, mɨkɨ nepaapa Kakaɨyarieya pɨhɨkɨ, 'ayumieme 'aixɨa nepaineni hetsiena mieme. ");
INSERT INTO hch_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Yawé kuya meuyutamiewe kanihɨkɨtɨni, Yawé katinitewaka. ");
INSERT INTO hch_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Yawé haramaratsie kaniwareukaxɨrieni, Parahuni kaxetatemama meta kuyaximama. Te'uximayatamete 'ekipitutari 'aixɨa memɨtekahu paratsiyuta mekaniukayunixɨani Haramara Mɨxeta hetsie. ");
INSERT INTO hch_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Haramara 'amatiyewatsie mekaniukayunixɨani, meukatewatsiepaitɨ tetexi hepaɨ mekaniukayunixɨani. ");
INSERT INTO hch_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Yawé, 'atɨrɨkariya pepuhekɨataxɨ mariwemekɨ, Yawé, memɨtatsi'aye'uniekai pepɨwarutitsanaxɨa. ");
INSERT INTO hch_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Mariwemekɨ pepɨtiuyuri pepɨwaruka'unaxɨ 'aneneɨkixiwima, waɨkawamekɨ pepuyeha'a, xatsi hepaɨ xeikɨa mepɨte'utai. ");
INSERT INTO hch_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Xei 'iiyayarikɨ pepɨtiuyuri, haa manutayepierekɨ, hamewari kayuwatɨ pɨtiu'ui 'ixumeri hepaɨ pɨtiyuxexeiyakai, haa pɨkakuyuatɨkatei tetɨata paitɨ. ");
INSERT INTO hch_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Taneɨkixiwima mɨpaɨ meputiyuanekai: «Hikɨmɨ tepɨwaruweiyani, nepɨwaranuku'axe. Tinaime tepɨtewarenawairieni wapiini, waɨkawa temɨtehexeyanikɨ. Ta'ixipara tepɨwatihapaxɨani tamamakɨ tepɨwarekwini». ");
INSERT INTO hch_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Peru 'ekɨ xeimieme pewaruhɨtsieku haramara pɨwareukakwai, mepukayunixɨa tepɨa mahete hepaɨ. ");
INSERT INTO hch_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Yawé, xewitɨ pumawe kakaɨyarixi watsata 'ahepaɨ 'anetɨ. Xewitɨ pumawe 'ahepaɨ timariwetɨ meta 'ahepaɨ tipatsietɨ. 'Ekɨ, mariweme pemɨtiyuriwe, 'ekɨ yemekɨ pepɨtatsihɨxiyatsitɨa 'atɨrɨkariyakɨ. ");
INSERT INTO hch_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Kepauka 'ekɨ 'atserie pemutatseraxɨ, kwie pɨwareukakwai. ");
INSERT INTO hch_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Waɨkawamekɨ pewanaki'erietɨ pepɨwaruwitɨxime 'ateɨterima pemɨwarutawikweitsitɨa, 'atɨrɨkariyakɨ pepɨwaruwitɨxime 'akiekari makupatsie. ");
INSERT INTO hch_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Naitsarie kwiepa nuiwarite mepɨtimamani me'enaname, kepauka memɨtehetimani piritsiteutsixi mepetinututuixieni. ");
INSERT INTO hch_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","'Erumi kiekatari wa'ukiyarima waɨkawa mepɨtimamani, waɨkawa meputiyɨyɨakatɨkani 'itsɨkate Muhawi kiekatari. Meta Kanani kiekatari meputiweranaxɨa, ");
INSERT INTO hch_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","mɨkɨtsɨ wahetsie pɨtinakeni marika. Yawé, kepemɨtitɨrɨkaɨyekɨ, mekaniuwawetɨ mepakɨne tetexi wahepaɨ kepaukake 'ateɨterima memanuyekɨne, teɨteri 'ahetsiemieme pemɨwarutinanai. ");
INSERT INTO hch_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","'Ekɨ pepɨwareutawitɨni, pepɨwaka'iteɨta, 'iya hɨritsie kemɨ'ane 'ahetsɨamɨmieme, Yawé, 'ekɨ hakewa pemeyeika, hakewa 'ekɨ, Yawé, 'atuki pemeyutawewiri. ");
INSERT INTO hch_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Yawé katini'aitakamɨkɨ yuheyeme, tukarikɨ. ");
INSERT INTO hch_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Kepauka Parahuni kawayutsiximama meta kaxetamama teɨteri me'utetɨ haramaratsie memanukɨnekekai, Yawé yakatiniuyurieni haa waheima muyeurienikɨ. 'Ixaheritsixi mekayu'iyaritɨatɨ mepanukɨ kwie wakimetsie. ");
INSERT INTO hch_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Merikɨtsɨ Miriyami Kakaɨyari niukameya, 'Aruni taruya, kaitsawiwame kaniuti'ɨni, hipatɨta 'ukari mekaniweiyakaitɨni yukaitsakɨ mete'ukayuitɨwatɨ meta mete'ukaye'atɨ. ");
INSERT INTO hch_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Miriyami mɨpaɨ katiniukwikakaitɨni: Yawé xekenenɨawani, mɨkɨ mariwemekɨ mɨrayu'iwaxɨkɨ, kawayutsixi wahetsie memutei meta kawayutsixi haramaratsie pɨwareukaxɨri. ");
INSERT INTO hch_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Merikɨtsɨ Muitsexi kaniwaruta'aitɨani 'ixaheritsixi Haramara Mɨxeta hetsie memayekɨnekɨ meta makumawetsie memɨtayunekɨ Tsuhuxi kwieyaritsie. 'Ixaheritsixi mana mekaniuhukaitɨni haika tukari makumawetsie haa mekataxeiyawawetɨ. ");
INSERT INTO hch_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Hikɨ mekaniuta'axɨani Maraha mɨrakutewatsie, mana mɨpaɨ katinakutewakaitɨni mana haa hatsiwitɨ muxuawekaikɨ, mana mepɨkatenewiekairi meheuharikutɨ. ");
INSERT INTO hch_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Merikɨte mɨkɨ mekaniutiniukixietɨkɨne Muitsexi hepaɨtsita, mɨpaɨ mete'iku'iwawiyatɨ: «¿Ketita tetetihareni?» ");
INSERT INTO hch_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Muitsexi Yawé kaniutawawirieni, mɨkɨ pixeitsitɨa kɨye yatewime, mɨkɨ Muitsexi hapa kaneikahɨani, yapauka haa 'aixɨa ha'anetɨ kanayani. Mana Yawé kaniwaruta'inɨata, kaniwarupitɨani 'inɨari niukiyari kememɨtekahuni. ");
INSERT INTO hch_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Mɨpaɨ katiniwarutahɨawe: «Netsɨ Yawé xekakaɨyari nekanihɨkɨtɨni. Xɨka neniuki xe'enietɨ yaxetekahuni heitseriemekɨ, xɨka 'inɨari niukiyaritsie yaxetekahuni kemɨreuyewetse meta ne'aitsikatsie, ne hatsuaku kwiniya nepɨkahanɨ'ani xehetsie, 'ekipitutsie kenemɨtiuyuri. Netsɨ Yawé nekanihɨkɨtɨni, hatsuaku kwiniya xehetsie pɨkatinake». ");
INSERT INTO hch_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","'Arikeke 'ixaheritsixi mekaneta'axɨani, 'Erimi mɨrakutewatsie, hakewa tamamata heimana huta haixayari mexuawekai meta haika tewiyari heimana tamamata takɨ mati'u, mana mekaniyuhayewa, haa mayema 'aurie. ");
INSERT INTO hch_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Merikɨtsɨ yunaitɨ 'ixaheritsixi 'Erimi mekaniyekɨne, mekaneta'axɨani makumawetsie Tsini paitɨ, mɨkɨ 'Erimi meta Tsinahi wahixɨapa pɨti'anekai. 'Ikɨta pɨtiuyɨ xeimetseri 'anukamiekaku heimana tamamata heimana 'auxɨwi tukaritsie, 'inɨaritɨ kepauka memayekɨtsie 'Ekipitu. ");
INSERT INTO hch_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Mana makumawetsie me'u'uwatɨ, 'ixaheritsixi mekaniwarutiniukimani Muitsexi 'Aruni mame. ");
INSERT INTO hch_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Mɨpaɨ 'ixaheritsixi mekaniutiyuanekaitɨni: —Matsi 'aixɨa pɨ'anekai xɨka Yawé tatsihekwinike 'Ekipitu paitɨ. Mana 'aixɨa tepɨtehetikwa'akai wai 'itsarikɨ meta pakɨ yemekɨ tepetihuxarɨwekai. Xeme xepɨtatsiheyewitɨ, 'ena makumawetsie teyunaime xemɨtatsikwinikɨ haakakɨ. ");
INSERT INTO hch_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Hikɨ Yawé mɨpaɨ Muitsexi katiniutahɨawe: «Yanepɨtiyurieni mɨkawiyekɨ paa muyuawitsie mieme. 'Ixaheritsixi yunaitɨ meke'ikuteɨxɨni xeitukaritsie mieme yuxexuitɨ, nekaniwata'inɨatamɨkɨ xɨka 'aku yametekakɨnikuni yatɨ pɨtikatixaɨ. ");
INSERT INTO hch_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","'Ataxewirieka tukaritsie mepikuteɨxɨ huta tukaritsie mieme, mɨpaɨ memɨteha'aritsiekakɨ». ");
INSERT INTO hch_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Merikɨtsɨ Muitsexi 'Aruni matɨa 'ixaheritsixi mɨpaɨ mekateniwarutahɨawe: —'Ikɨ taikaiyaritsie xepɨtehetimani kename Yawé tiuyuri 'Ekipitu mɨxe'ayewitɨ, ");
INSERT INTO hch_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","meta 'uxa'a ximeri xepixeiya Yawé kemɨtimariwe. Mɨkɨri pɨtimate ke'axaxemutiyuane hetsiena mieme. Tame tixaɨ tepɨkatehɨkɨ ketitayari 'axaxetatekuhɨaweni. ");
INSERT INTO hch_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Muitsexi mɨpaɨ katiniwarutahɨawe: —'Ikɨ taikaiyaritsie Yawé wai kanixemimɨkɨ, paa xetikwame xekanitihuxaikuni kanixe'u'enieni hepaɨtsitana 'axakexemutiyua. Tame tixaɨtɨ tepɨkatehɨkɨ. Xeme ke'axaxemutiyuane tahetsiemieme xepɨka'utiyuane, Yawé hetsiemieme pɨta xekaniutiyuaneni. ");
INSERT INTO hch_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Hikɨ Muitsexi mɨpaɨ 'Aruni katiniutahɨawe: —'Ixaheritsixi yunaime mɨpaɨ ketiniwarutahɨawi, 'ahurawa meke'akɨne Yawé hetsɨa, mɨkɨ kaniwaru'enieni 'axakememutiyuanekai hetsiena mieme. ");
INSERT INTO hch_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Mexi'akuxi tikuxatakai 'Aruni, yunaime 'ixaheritsixi wahamatɨa mana, mekanixeiya makumawetsie haiwitɨritsie Yawé kemɨtimariwe. ");
INSERT INTO hch_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Yawé Muitsexi katiniutaxatɨani mɨpaɨ katinitahɨawe: ");
INSERT INTO hch_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","«Nekaniwaru'enieni 'ixaheritsixi kememɨteniukixie. Mɨpaɨ ketiniwarutahɨawi kakɨyɨriwekaku 'akuxi, wai xekanitikwaikuni, 'uxa'ata ximeri pakɨ xekanitihuxaikuni. 'Anari mɨpaɨ mekatenetimaikuni kename Yawé wakakaɨyari nehɨkɨ». ");
INSERT INTO hch_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Mɨkɨ kwitɨwa taikaiyaritsie mematitekaitsie meputixuawerixɨ xɨ'aurixi, meta 'uxa'arieka mematiteitsie naitsarie pakutuxakai 'ɨwi hepaɨ. ");
INSERT INTO hch_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Mɨkɨ 'ukumawereku makumawetsie puyuhayewaxɨ 'etsiwa witsi'anenetɨ, tee hepaɨ 'anenetɨ. ");
INSERT INTO hch_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","'Ixaheritsixi memɨkatemaikaikɨ ketitamɨtihɨkɨtɨkai, me'ixeiyatɨ mɨpaɨ mepɨteyuku'iwawiyakai: «¿Ketita tihɨkɨ 'ikɨ?» Muitsexi mɨpaɨ katiniwarutahɨawe: —Mɨkɨ paa kanihɨkɨtɨni Yawé mɨxemikwa xemitikwanikɨ. ");
INSERT INTO hch_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","'Ikɨ kanihɨkɨtɨni 'aitɨarika Yawé kemaine: “Xeme yuxexuitɨ xekeneukuteɨxi, kepaɨmeme xemeuyehɨwa para yunaime xetɨɨriyama wahetsiemieme, xete'inɨaritɨatɨ huta kakuniyari yuxexuime wahetsiemieme”. ");
INSERT INTO hch_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Mɨpaɨ mekateniuyurieni 'ixaheritsixi. Hipatɨ waɨkawa mekanikuteɨxɨ, hipatɨta 'etsiwa xeikɨa. ");
INSERT INTO hch_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Perutsɨ kepauka memiti'inɨataxɨ ti'inɨnɨatamekɨ, kemɨ'ane waɨkawa meikuteɨxixɨ pɨkayukuhayeikawakai, kemɨ'ane 'etsiwa mikuteɨxixɨ pɨkaheuyewekai, yuxexuitɨ mekanikuteɨxɨ yunakeme xeikɨa. ");
INSERT INTO hch_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Hikɨ Muitsexi mɨpaɨ katiniwarutahɨawe: —Xewitɨ pɨka'iti'uta 'uxa'arieka mieme mayanikɨ. ");
INSERT INTO hch_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Hipatɨ Muitsexi mepɨkahanu'eni, mekaniti'uta 'uxa'arieka mieme mayanikɨ, perutsɨ memiti'utaxɨ kaniutikwitsieni 'axa'u'ɨatɨkaitɨ kanayani. Hikɨ Muitsexi kaniuyeha'ani wahetsiemieme. ");
INSERT INTO hch_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Yunaitɨ mekanikuteɨxɨkaitɨni ximeri yuxexuitɨ kememɨteheiyehɨakai, mɨkɨtsɨ tau xɨriyarikɨ pɨtipaparikekai. ");
INSERT INTO hch_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Perutsɨ 'ataxewirieka tukaritsie mekanikuteɨxɨ hutakɨamieme kepaɨmeme memɨkema, tatsɨari nauka 'inɨariyari yuxexuitɨ, 'ayumieme mɨkɨ memanuyetei mepekɨ Muitsexi metehetaxatɨanike. ");
INSERT INTO hch_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Mɨpaɨ katiniwaruta'eiya: —Mɨpaɨ katina'aitani Yawé. 'Uxa'a xawatikɨ 'uxipiya tukari pɨhɨkɨ mɨpatsie Yawe hetsiemieme. 'Ayumieme xeketeneutiwarɨka yatɨni xeketeneuka'etsa hikɨ tita xemɨteheuyehɨwa. Tita mɨtiyuhayewa, xeketeneuti'uta 'uxa'arieka mieme mɨrayanikɨ. ");
INSERT INTO hch_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Mɨpaɨ mepɨte'uyuri 'ixaheritsixi kemɨtiwaruta'aitɨa Muitsexi, mepiti'utaxɨ 'uxa'arieka mieme muyuhayewaxɨ, mɨkɨ hawaikɨ pɨka'utipɨnixɨ meta pɨka'utikwitsi. ");
INSERT INTO hch_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Muitsexi mɨpaɨ katiniwarutahɨawe: —Hikɨ xawatikɨ xekeneutikwa'i, hikɨ 'uxipiya tukari kanihɨkɨtɨni Yawé hetsiemieme. Hikɨri xepɨkaheitaxeiya xemetiteɨxɨkaitsie. ");
INSERT INTO hch_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","'Ataxewime tukari xeikɨa xepikuteɨxɨni, 'atahutarieka tukaritsie, tixaɨtɨ xepɨkatehetaxeiya. ");
INSERT INTO hch_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Hipatɨ 'ixaheritsixi mekanekɨne meheiteɨxiyuka 'atahutarieka tukaritsie, peru tixaɨtɨ mepɨkatehetaxei, ");
INSERT INTO hch_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","hikɨ 'ayumieme Yawé Muitsexi mɨpaɨ katiniutahɨawe: «¿Kamɨtsɨ kepaukake menetsiheu'enietɨ mepakɨne, yameteyurietɨ naime 'aitɨarikatsie? ");
INSERT INTO hch_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Mɨpaɨ xeketemaika, ne Yawé, 'uxipiya tukari nenixe'upitɨani xawati tukaritsie. 'Ayumieme 'ataxewirieka tukaritsie paa nekanixeyetuiriwani huta tukari mieme. 'Atahutarieka tukaritsie xewitɨ tɨma pɨkahayeyeikani. Yunaitɨ 'axeikɨa meke'ukutetɨkani». ");
INSERT INTO hch_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Mɨpaɨ mekaniuyɨni 'ana 'ixaheritsixi mekaniuka'uxipieni 'atahutarieka tukaritsie. ");
INSERT INTO hch_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Mɨkɨ paa mepɨte'iterɨwaxɨ «manana». Kanituxakaitɨni, tsiranituru hatsiyari hepaɨ 'anenetɨ, meta pakakatei paa mɨxietematɨka hepaɨ. ");
INSERT INTO hch_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Muitsexi mɨpaɨ kaniutayɨni: —Yawé mɨpaɨ kanaineni: “Huta kakuniyari xekeneuti'uta manana payari, para xeniwema xemanutihutsie mieme, mɨkɨ memixeiyakɨ paa nemɨxe'umi makumawetsie, kepauka nemɨxe'ayewitɨ 'Ekipitu”. ");
INSERT INTO hch_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Mɨpaɨ Muitsexi 'Aruni katiniutahɨawe: —Keneukutu'i manana xarita keneukayetsa huta kakuniyari. Hikɨ Yawé hɨxie keneukuwi, para temiti'utakɨ tanuiwarima memeitimanikɨ. ");
INSERT INTO hch_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","'Aruni muwa kanikuwieni tɨratu kakuniyari hɨxie, para mu'utɨnikɨ Yawé Muitsexi kemɨtiutahɨawixɨ. ");
INSERT INTO hch_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","'Ixaheritsixi mɨkɨ mekanikwakaitɨni manana huta tewiyari wiyari, kepaukake memeta'axɨa Kanani kwieyaritsie paitɨ, mɨkɨ wakwie wakiekari patɨa. ");
INSERT INTO hch_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Huta kakuniyari 'inɨariyari «kumeri» mepɨte'iterɨwakai, meta «hepari» tamamata 'inɨariyari mepɨte'iterɨwakai. ");
INSERT INTO hch_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Yunaitɨ 'ixaheritsixi mekanayekɨne makumawetsie Tsini mɨrakutewatsie me'u'uxipiximetɨ, Yawé kemɨtiwanɨ'akai. Mekaniu'axɨani Xepirini mɨrakutewatsie, peru mana haa pumawekai wahetsiemieme, ");
INSERT INTO hch_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","hikɨ Muitsexi mekaniutiniukimani mɨpaɨ me'utiyuatɨ. Mɨpaɨ mekatenitawawirieni: —Haa ketaneyetuiri temɨtiharenikɨ. Muitsexi mɨpaɨ katiniwarutahɨawe yuhetsie nuatɨ: —¿Titayari xenete'anutate'a? ¿Ketitayari Yawé xeteniukima? ");
INSERT INTO hch_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Peru 'ixaheritsixi waɨkawa mepeuharikukai, Muitsexi hepaɨtsita mepɨniukixiekai. Mɨpaɨ mekatenikɨhɨawekaitɨni: —¿Ketitayari petarayewitɨ 'Ekipitu kwieyaritsie? Kauka xeikɨa petatsiheyewitɨ teyeharikwitɨwetɨ temɨkwinikɨ, taniwema meta tatewama. ");
INSERT INTO hch_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Hikɨ Muitsexi Yawé kaniutahɨawe, mɨpaɨ katinita'iwawiya: —¿Kenetiyurieni 'ikɨ teɨteri wahetsiemieme? Peuyewetse 'etsiwa xeikɨa memɨnetsimienikɨ tetexikɨ. ");
INSERT INTO hch_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Yawé mɨpaɨ katinita'aitɨani: —Keniwaranuwitɨki pe'anuyekaitɨ hipame 'ahamatɨa 'ixaheritsixi wa'ukiyarima, 'a'itsɨ kenakwetɨ kɨmana Niru hayari pemuwa. Kenemie, ");
INSERT INTO hch_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","ne nepɨmatsihetakwewieka tete manuka Huré mɨrakutewatsie paitɨ. Mana pepiwani tete xeimieme xeikɨa, mɨkɨtsie haa paneni yunaitɨ 'ixaheritsixi memɨtiharenikɨ. Muitsexi mɨpaɨ pɨtiuyuri, 'ixaheritsixi wa'ukiyarima wahɨxie. ");
INSERT INTO hch_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Metatsiere mana, Matsaha mekateniuterɨwa meta Meriwa, mɨkɨ panuyɨne 'ixaheritsixi mepuniukixi, Yawé hepaɨtsita meputiniukixi, mɨpaɨ mete'uhiwatɨ: «¿Yawé tiuyeika 'aku tahamatɨa, nutsu pɨkatixaɨ?» ");
INSERT INTO hch_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","'Amarekitsixi mekaniu'axɨani Xepirini mehanexɨaka, 'ixaheritsixi mekaniwarutakwini. ");
INSERT INTO hch_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Hikɨ Muitsexi Kutsuhexi mɨpaɨ katiniuta'aitɨani: «'Ekɨ keniwaranuyeteɨxi 'ukitsi hipame, xekenehu xekeniwakwiyu 'amarekitsixi. 'Uxa'a ne yemuritsie nepakakani Kakaɨyari 'itsɨya ne'akwetɨ». ");
INSERT INTO hch_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Kutsuhexi mɨpaɨ pɨtiuyuri Muitsexi kemɨtita'aitɨa, mekaniwarutakwini 'amarekitsixi. Muitsexi, 'Aruni meta Kuxi yemuritsie 'emanutitewatsie mekaneutiyune. ");
INSERT INTO hch_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Kepauka Muitsexi yumamate teikɨ metseratɨkani 'ixaheritsixi yuneukixiwima mepɨwara'iwakai, kepauka muti'uxikekai teikɨ hemetɨ 'ana mepɨtehayu'iwakai 'amarekitsixi. ");
INSERT INTO hch_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Kepauka Muitsexi mamateya muti'uxixɨa teikɨ hemetɨ, tete me'akurupaka hetɨana menitayeni hetsiena mayerɨnikɨ, hikɨ 'Aruni meta Kuxi matɨa mekanenukutuikaxɨani mamateyatsie mekaniparewieni, xewitɨ 'utatanatsie xewitɨta tserietana, mɨpaɨke Muitsexi pɨyɨwekai yumamate tukarikɨ teikɨ metseratɨkani kepaukake tau makayunixɨ. ");
INSERT INTO hch_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Mɨpaɨ Kutsuhexi pɨtiwara'iwaxɨ 'amarekitsixi 'ixiparakɨ. ");
INSERT INTO hch_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Merikɨtsɨ Yawé Muitsexi mɨpaɨ katiniutahɨawe: «Ketinaka'utɨa 'ikɨ nawi kwikwiekametsie, naime kemɨtiuyɨ, xewitɨ mɨkaratɨtɨmaiyanikɨ, meta Kutsuhexi mɨpaɨ ketimaika: Ne yunaime nepɨwareuyehɨani muyuawi hetɨa, mɨkɨ 'amarekitsixi meta waniwema». ");
INSERT INTO hch_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Mana Muitsexi mawari taiyame tenariyari kaniutawewieni, mɨpaɨta katiniterɨwa «Yawé nehetsie pununuwame». ");
INSERT INTO hch_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Mɨpaɨta kaniutayɨni: «Nepitikweni Yawé kuyaximama wapatera. Yawé yuheyemekɨ 'amareki paye'unieka». ");
INSERT INTO hch_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Kakaɨyari naime kemɨtiuyuri Muitsexi hetsiemieme meta Yawé yuteɨterima wahetsiemieme 'ixaheritsixi kemɨtiwarayewitɨ 'Ekipitu kwieyaritsie, Muitsexi munieya Keturu mawari wewiwame katiniutamarieni, Mariyani kwieyaritsie. ");
INSERT INTO hch_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Kepauka Muitsexi Tsepura yu'ɨya menɨ'a Keturu hetsɨa, mɨkɨ kiena me'u'axɨaku yuniwe mamayatsie kanawiere, ");
INSERT INTO hch_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","meta niwemama meyuhutatɨ. Mɨkɨ xewitɨ nunutsi pɨtitewakai Keritsuni, mɨpaɨ mutayɨkɨ Muitsexi: «Teewa kiekame nepɨhɨkɨ xeime kwieyaritsie ne'uyeikatɨ neka'imatemetsie». ");
INSERT INTO hch_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Xewitɨta 'Eriyetsexi pɨtitewakai. Muitsexi mɨpaɨ mutayɨkaikɨ: «Nepaapa Kakaɨyarieya pɨnetsi'uparewi, pɨnetsi'utawikweitsitɨa Parahuni netsimiemɨkɨkaku». ");
INSERT INTO hch_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Hikɨ Keturu kaneyani makumawetsie Muitsexi metahɨawekɨ 'ɨyaya 'awitɨtɨ meta niwemama, mɨkɨ mana penuakairi Kakaɨyari hɨrieya hetɨa. ");
INSERT INTO hch_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Keturu mɨpaɨ niuki katineinɨ'airiekaitɨniri: «Ne, 'amune Keturu, nekameneuxeiyamieni. 'A'ɨya meta 'aniwema meyuhutatɨ mepɨnetsihaweiya». ");
INSERT INTO hch_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Muitsexi kanayeyani henukunakeke yumune, hikɨ hɨxiena kaniutihɨximakeni meta kani'itseni. Hikɨ 'ari me'uyutapaka mekaneutahaxɨani 'ixuriki kiiyarita. ");
INSERT INTO hch_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Muwa Muitsexi naime katinitaxatɨani yumune, Yawé kemɨtiuyuri Parahuni 'Ekipitu kiekame hɨxie meta 'ixaheritsixi wahetsiemieme naime kwaniwemekɨ kememɨte'uhukai huyeta Yawé kemɨtiwaparewiekai. ");
INSERT INTO hch_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Keturu kaniyutemawiekaitɨni tiutamarieka Yawé 'aixɨa mɨtiuka'iyarikaikɨ 'Ixaheri hetsiemieme, meta 'ekipitutari watsata mɨwarayehapakɨ. ");
INSERT INTO hch_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Hikɨ mɨpaɨ kaniutayɨni: «'Aixɨa keraniuwani Yawé hetsiemieme, 'ekipitutari watsata mɨxehetawikweitsitɨa. 'Aixɨa keraniuwani kemɨ'ane 'ixaheritsixi mɨwaretawikweitsitɨa ti'aitame Parahuni tɨrɨkariyayatsie. ");
INSERT INTO hch_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Hikɨri nepɨtimate Yawé matsi pɨmariwe keyuri hipatɨ kakaɨyarixi, 'ixaheritsixi mepɨnanaimariekai 'ekipitutari mariwemete mepayuyeitɨakai». ");
INSERT INTO hch_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Mɨpaɨ 'utayɨka, Keturu mawari taiyariyari kaniuwewieni meta hipame mawari Kakaɨyari hetsiemieme, 'Aruni meta yunaitɨ 'ixaheritsixi wa'ukiyarima mekananukayaxe mekateniukwani Muitsexi munieya hamatɨa Kakaɨyari hɨxie. ");
INSERT INTO hch_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","'Uxa'arieka, Muitsexi 'akanayerɨni 'ixaheritsixi wa'enienike tita memɨtehayexeiyakai hamatɨana, 'itsɨkame kanihɨkɨtɨkaitɨni wahetsiemieme, 'ixaheritsixi hɨxiena mekaniti'uni ximeripaitɨ meta mana meti'ukaku tau kanakayune. ");
INSERT INTO hch_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Keturu kepauka yumune Muitsexi muxei kemɨtiyurienekai teɨteri wahamatɨa, mɨpaɨ katinitahɨawe: —Ketɨtɨ teɨteri pepɨwayuriene. ¿Ketitayari tukarikɨ meta tɨkarikɨ mana meteku'u, 'ekɨta 'axaɨta 'aperaka? ");
INSERT INTO hch_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Muitsexi mɨpaɨ katinita'eiya: —Teɨteri nehetsɨa mepɨ'axe Kakaɨyari memɨtahɨawekɨ. ");
INSERT INTO hch_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Kepauka memɨyu'uximatɨa mepɨ'axe nehetsɨa mepɨnetekuxaxatɨwa, naime nepɨwahekɨatɨa rayehutame kemɨti'ane. Meta, nepɨwakuxaxatɨwa kemaine 'inɨari niukiyari meta 'ɨkitɨarika Kakaɨyari hetsɨa mieme. ");
INSERT INTO hch_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Munieya mɨpaɨ katinitahɨawe: —'Aixɨa puka'ane mɨya pemɨyɨane, ");
INSERT INTO hch_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","peputi'uxike 'ekɨ meta teɨteri 'ahɨxie memɨti'u. 'Ikɨ 'uximayatsika kanikwaniweni, 'axaɨtame pepɨkayɨwe. ");
INSERT INTO hch_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Keneu'eni 'ɨxatsi kemɨ'ane nemɨmatsitaxatɨani, meta Kakaɨyari kematsiparewieka. 'Ekɨ pemanuyeka pepɨhɨkɨtɨni Kakaɨyari hetsiemieme, meta 'ekɨ pepɨtiwahekɨatɨwametɨni ke'aneme 'uximatɨarika memexeiyani. ");
INSERT INTO hch_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Kaneuyeweka mɨkɨ pemɨtiwati'ɨkitɨanikɨ 'inɨari niukiyaritsie meta 'ɨkitɨarika Kakaɨyari hetsiemieme, meta yapemɨtiwatahɨawekɨ kememɨte'u'uwani meta kememɨtehahɨawarɨwa memɨte'aye'atɨakakɨ. ");
INSERT INTO hch_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","'Ekɨ keniwaranayexeiya hipame 'ukitsi 'aixɨa memaitɨka Kakaɨyari hetsiemieme, yurikɨ yuri memɨte'erie Kakaɨyari memayemakaxe kwamanarika memɨkanaki'erie, xeime keneuhɨritɨa xeimiriyari wa'ukiyari mayanikɨ, xeimeta xeitsienituyari wa'ukiyari, xeimeta huta tewiyari heimana tamamata wa'ukiyari, xeimeta tamamata wa'ukiyari. ");
INSERT INTO hch_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Mɨkɨ mepɨyɨaka 'itsɨkate wahepaɨ yamemɨte'uximayaka, mɨkɨ mepɨte'uximayaka nenika mɨti'anenetsie, xewitɨri xɨka kwinimieme rayexeiyani 'uximatɨarikatsie 'ahetsɨa meke'i'atɨani. Mɨpaɨ 'a'uximayatsika pa'exanaxɨani, mɨkɨ memɨmatsiparewienikɨ. ");
INSERT INTO hch_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Xɨka mɨpaɨ petikamieni, Kakaɨyari kemɨmati'aitɨa, kwitɨwa 'aixɨa pɨtikuyɨneni meta teɨteri 'aixɨa 'anemekɨ meyutemamawietɨ mepekɨkani yukie. ");
INSERT INTO hch_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Muitsexi yumune kaniu'enieni kemɨtitahɨawixɨ. ");
INSERT INTO hch_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Niwaranuyexeiya hipame 'ixaheritsixi watsata meyɨwaweme, mɨkɨ memanuyetei kaniwarayeitɨani, xeime xeimiriyari wa'ukiyari kanayeitɨani, xeimeta xeitsienituyari wa'ukiyari, xeimeta huta tewiyari heimana tamamata wa'ukiyari, xeimeta tamamata wa'ukiyari. ");
INSERT INTO hch_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Mɨkɨ 'itsɨkate wahepaɨ mepɨteyuriekai yamete'uximayatɨ, mɨkɨ nenika mɨti'anenekɨ 'aixɨa mepɨte'akayuruwakai, peru waɨkawa mukwaniwetɨka Muitsexi hetsɨa mepɨwarenɨ'awakai. ");
INSERT INTO hch_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","'Imatɨrieka Muitsexi yumune hamatɨa mekaniyutateutɨaxɨani, mɨkɨta yukie kaneyani. ");
INSERT INTO hch_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","'Ixaheritsixi mekaniu'axɨani makumawe Tsinahi mɨrakutewatsie, haika metseri 'anukamiekaku 'Ekipitu kepauka memɨyekɨ. ");
INSERT INTO hch_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Kepauka Xepirini memɨyekɨ, mɨkɨ kwieyaritsie mepeutahaxɨa Tsinahi makumawetsie, mana mekanikuyaxe hɨri hɨxie, ");
INSERT INTO hch_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","mɨkɨ hɨritsie Muitsexi kanitiyune Kakaɨyari hamatɨa mɨretaxatakɨ. Mana Yawé, mɨpaɨ katinitahɨawe: «Mɨpaɨ ketiniwarutahɨawi Kakuwu tɨɨriyamama, yaxeikɨata 'Ixaheri nuiwarimama: ");
INSERT INTO hch_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","“Xeme xemunenierixɨ xepɨhɨkɨ kenemɨtiuyuri 'Ekipitu, meta nehetsɨa kenemɨtixe'atɨa werika 'anayatsie xe'atetɨ xemu'axɨani hepaɨ. ");
INSERT INTO hch_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Xɨka hikɨ xeme naimekɨ yaxetekakɨne, netɨratu xɨka xehaye'atɨani, neteɨterima xepɨhɨkɨtɨni yunaime nuiwarite kwiepa memɨtama wahɨxie. Tsepa naitɨ kwie nehetsɨa mɨmieme, ");
INSERT INTO hch_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","xeme nehetsiemieme mawari wewiwamete nehetsɨa miemete xepɨhɨkɨtɨni, meta nuiwari xemɨpatsie”. »Naime 'ikɨ 'ixaheritsixi ketiniwarutaxatɨa». ");
INSERT INTO hch_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Hikɨ Muitsexi 'ukateka kaniwarukuxeɨrieni wa'ukiyarima naime tiwataxatɨanike Yawé kemɨrehɨawekai, ");
INSERT INTO hch_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","meta mɨkɨ yunaitɨ mɨpaɨ mekaniutiyuani: «Yatepɨtekakɨne naimetsie Yawé kemɨtatita'aitɨani». Hikɨ Muitsexi kaneyani Yawé katinetaxatɨani kememutiyua teɨteri, ");
INSERT INTO hch_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","hikɨ Yawé mɨpaɨ katinitahɨawe: —Ne 'ahetsɨa nepɨnehekɨata haiwitɨritsie ka'anuyehekɨakametsie, nepɨmatsitahɨawe 'ixaheritsixi memɨnetsi'enienikɨ, yuri memɨmate'eririekakɨ yuheyemekɨ. Muitsexi Yawé yakatiniutahɨawe teɨteri kememaitɨkatei, ");
INSERT INTO hch_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","hikɨ Yawé mɨpaɨ katinitahɨawe: —Kenemie mepatsiekame keniwarayeitɨa 'ixaheritsixi hikɨ meta 'uxa'a. Mɨpaɨ ketiniwaretahɨawi mekeheyuti'ekwa, ");
INSERT INTO hch_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","hairieka tukaritsie mekeheha'aritsieka, 'ana mɨkɨ tukaritsie nepɨnehekɨata Tsinahi yemuriyaritsie nepɨkateni yunaitɨ teɨteri menetsixeiyakaku. ");
INSERT INTO hch_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","'Inɨari kuraruyari kenateka hɨri warie mana 'ixaheritsixi memɨka'utikɨkanikɨ. Mɨpaɨ ketiniwarutahɨawi xewitɨ pɨka'anɨtiyeikani hɨritsiepai meta yu'ɨka tapa miemekɨ mana pɨkaheutakekani, meta kemɨ'ane mimayɨani kanimɨmɨkɨ. ");
INSERT INTO hch_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Tsepa mɨtewi yatsepa tewatsiekame mɨyɨane, kanimɨmɨkɨ. Kemɨ'ane mimayɨani, kanimieriemɨkɨ tetexikɨ yatɨni 'ɨrɨtekɨ. Kepaukake kuxineta metayuani karima 'anake mepɨyɨwaweni. ");
INSERT INTO hch_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Hikɨ Muitsexi kaniukateni hɨritsie 'akaneka, mepatsiekame 'ixaheritsixi kaniwarayeitɨani, mɨkɨta mekaniyuti'ekwa. ");
INSERT INTO hch_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Mɨpaɨta Muitsexi katiniwarutahɨawe: «Xekeneyukuha'aritɨa hairieka tukaritsie miemekɨ, yu'ɨitama xepɨkawakumaɨwani». ");
INSERT INTO hch_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Hairieka tukaritsie ximeri tɨranari kaneyuani muyuawitsie meta merɨkariya, hikɨ mana hɨritsie panukate haiwitɨri ka'anuyehekɨakametsie. Meta kuxineta karima kanetayuani naitsarie 'ixaheritsixi memakutei putayuanekai. ");
INSERT INTO hch_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Hikɨ Muitsexi 'ixaheritsixi kaniwarayewitɨni Kakaɨyari memanunakekɨ, mɨkɨ Tsinahi yemuriyaritɨa mekaniti'uni. ");
INSERT INTO hch_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Hɨri pɨkahekɨakai kɨtsikɨ, Yawé mɨkɨtsie muyeikakaikɨ taitsie yewetɨ. Pɨwaɨkawakai kɨtsi hɨritsie metineikakai, teka hepaɨ pɨtiyuxexeiyakai, meta naitɨ hɨri karima putayuanekai, ");
INSERT INTO hch_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","meta kuxineta matsi karima peyuatɨyeikakai. Hikɨ Muitsexi kaniutaniuni, Kakaɨyari meta kanita'eiya tɨranarikɨ. ");
INSERT INTO hch_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Yawé kananukateni Tsinahi hɨriyaritsie 'amanutitewitsie paitɨ, mana Muitsexi kaniutahɨawe manutiyanikɨ. Kepauka Muitsexi hɨritsie mana mutine, ");
INSERT INTO hch_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Yawé mɨpaɨ katinitahɨawe: —Kenanukayaka 'ixaheritsixi keniwareta'imaiya kuraru 'inɨariyari manuyeka mepɨka'anayekɨkani menetsixeiyakutɨ, kapa yumɨiretɨ me'ukwinikɨ. ");
INSERT INTO hch_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Yaxeikɨata mawari wewiwamete hurawa xɨka me'ukɨne mekepatsieka, xɨka mɨpaɨ meka'aneneni, ne nekaniwakwimɨkɨ. ");
INSERT INTO hch_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Muitsexi Yawé mɨpaɨ katiniutahɨawe: —Teɨteri mepɨkayɨwawe memanutikɨnekɨ 'ikɨ hɨri Tsinahi hetsie paitɨ, 'ekɨtsɨ 'ari pekatanayehɨtɨani, mɨpaɨ pepɨnetiutahɨawixɨ: “Kuraru 'inɨariyari kenateka hɨriwarie, meta nehetsɨa mieme patsiekame kenayeitɨa”. ");
INSERT INTO hch_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Yawé mɨpaɨ katinita'eiya: —Keneukayaka 'Aruni keneta'ini 'ahamatɨa matiyanikɨ. Peru pɨkayɨweni mawari wewiwamete meta teɨteri mematikɨnekɨ 'enapaitɨ nehetsɨa, xɨka mɨpaɨ me'uyɨni, mekanikwikuni. ");
INSERT INTO hch_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Hikɨ Muitsexi 'uye'aka 'ixaheritsixi yaxeikɨata katiniwarutahɨawe. ");
INSERT INTO hch_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Kakaɨyari 'aitsika kaniwayetuirieni, 'inɨari niukiyari memetimanikɨ: ");
INSERT INTO hch_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","«Netsɨ Yawé nekanihɨkɨtɨni 'akakaɨyari. Ne nepɨmatsi'ayewitɨ 'Ekipitu, hakewa waɨkawa pemɨre'uximayakai pekarepitɨarietɨ. ");
INSERT INTO hch_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","»Hipame tawarita kakaɨyarixi pepɨkawarayexeiyani ne xeikɨa. ");
INSERT INTO hch_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","»Tixaɨtɨ pepɨkatiwewieka taheima mieme hepaɨ ti'anekame, kwiepa memɨtexuawe hepaɨ ti'anekame, meta hapa memɨteye'uwa hepaɨ ti'anekame meta kwie hetɨa memɨtexuawe. ");
INSERT INTO hch_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Mɨkɨ wahɨxie pepɨkatitunumakekani, pepɨkawarayexeiyani. Ne, Yawé 'akakaɨyari nemɨtiyukakwerie nekanihɨkɨtɨni. Kepauka wapaapama 'axamemɨte'u'iyari kepauka memɨnetsixani'erie, ne waniwema nepɨwa'uximatɨa, wateukarima, watutsima meta mɨkɨ waniwema. ");
INSERT INTO hch_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Matsi kepauka, memɨnetsinaki'erie, kepauka yamemɨtekahu ne'aitsikatsie, ne nenaki'eriya wahetsiemieme matsiɨkɨme nekanayeitɨwani xeimiriyari nuiwariyaritsie. ");
INSERT INTO hch_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","»Ne Yawé kenemɨtitewa yakɨ xeikɨa pepɨkanetsikuxatani, ne nepɨka'itinenimayata kemɨ'ane kanetsi'enietɨ mɨnetsi'utaterɨwani. ");
INSERT INTO hch_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","»Kena'eriwani xawati tukari, patsiekame xemeyexeiyanikɨ. ");
INSERT INTO hch_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","'Ataxewime tukari xeikɨa pepɨti'uximayaka, tsepa naimekɨ kepemɨti'uximayaka pɨyɨweni, ");
INSERT INTO hch_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","peru 'atahutarieka tukaritsie pepɨka'uxipieni pemeyexeiyanikɨ Yawé 'akakaɨyari. Mɨkɨ tukaritsie pepɨkati'uximayaka meta 'aniwema 'ukitsi 'ukari, meta te'a'uximayatsiriwamete 'ukari 'ukitsi meta 'atewama meta teewanarixi 'akiekaritsie memɨtitei. ");
INSERT INTO hch_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Kena'eriwani 'ataxewime tukari Yawé pɨtiutiwewi muyuawi, kwie, haramara, meta yunaime mana memɨteye'uwa, hikɨ 'atahutarieka kaniuka'uxipieni. 'Ayumieme Yawé mɨkɨ 'uxipiya tukari patsiekame kanayeitɨani. ");
INSERT INTO hch_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","»Keniwareu'enieka 'apaapa meta 'amaama, mɨpaɨ petiyurienetɨ 'apepɨreutere kwiepa Yawé 'akakaɨyari mɨmatsipitɨa. ");
INSERT INTO hch_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","»Pepɨkati'amemiwani. ");
INSERT INTO hch_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","»Xeime 'ɨyaya kɨnaya pepɨkakumaɨwani. ");
INSERT INTO hch_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","»Pepɨkatinawayani. ");
INSERT INTO hch_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","»Xeime 'a'iwatsie pepɨkatiuhɨpani 'itarikakɨ. ");
INSERT INTO hch_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","»'A'iwa kiiya pepɨkahiwe'erieka, meta 'ɨyaya, meta 'iparewiwameya 'uki 'uka, meta tuuruya, puxuya, naime tita mɨrexeiya pepɨkatihiwe'erieka». ");
INSERT INTO hch_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Hikɨ 'ixaheritsixi kepauka memi'eniekai tɨranari meta kepauka merɨkariya memɨxeiyakai meta kɨtsi hɨritsie matineikakaikɨ kwinimieme mekatenimamakaitɨni 'ateewa mekaniti'ukaitɨni. ");
INSERT INTO hch_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Hikɨ Muitsexi mɨpaɨ mekateniutahɨawe: —'Ekɨ ketatinekuxaxatɨwani, tepɨmatsi'enieka. Xɨka Kakaɨyari tatiutaxatɨani xɨari tepɨkwini. ");
INSERT INTO hch_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Muitsexi mɨpaɨ katiniwarutahɨawe: —Xepɨkamamaka, Kakaɨyari kaninuani xeta'inɨatake, xe'eyemakatɨ, 'axaxemɨkateyuriekakɨ. ");
INSERT INTO hch_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Hikɨ Muitsexi 'ahurawa kaniuyani haiwitɨri mɨka'anuyehekɨatsie Kakaɨyari hakewa mewekai, peru 'ixaheritsixi 'ateewa mekaniti'ukaitɨni. ");
INSERT INTO hch_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Yawé Muitsexi mɨpaɨ katinita'aitɨani: «'Ixaheritsixi mɨpaɨ ketiniwarutahɨawi: “Xeme xekatenimaika muyuawitsiepai nekanixe'utahɨawe. ");
INSERT INTO hch_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Xepɨkanetsi hiweritɨaka, kakaɨyarixi pɨratakɨ meta hurukɨ xepɨkawawewieka meta wahɨxie xepɨka'ukatunuma'uweni. ");
INSERT INTO hch_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Mɨrayutimawatɨre tenariyari xekeneneutawewiri kwiepa, mana mawari taiyariyari xemɨnetsi'utiwewiriwanikɨ meta mana kename 'aixɨa meteyuxeiyani hepaɨtsita, muxatsi meta tuurutsixi xewamawatɨ. Ne nepunuani hakewa xemɨnetsihahɨaweni, hikɨ 'aixɨa nepɨxeyurieni. ");
INSERT INTO hch_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Xɨka mawari wewiwame xenetsi'utawewirieni tetexikɨ, xepɨka'itiparekutɨwani tixaɨtɨkɨ tepɨakɨ, mɨkɨ tetexi kapatsiekame payeitɨwa. ");
INSERT INTO hch_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","'Imɨmɨi xepɨkaheukuwewiwani nemawari wewiwametsie, manutiyanitsie mɨka'anamamawerenikɨ”. ");
INSERT INTO hch_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","»'Ikɨ 'aitsika pekaniwayetuiriemɨkɨ: ");
INSERT INTO hch_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","»Xɨka xewitɨ hepɨrayu tewiyari 'unaneni waɨriyarika mɨti'uximayakakɨ, mɨkɨ 'ataxewime wiyari pɨtita'uximayatsirieni, matsi 'atahuta wiyaritsie pɨxɨne tixaɨtɨkɨ katiyutuame. ");
INSERT INTO hch_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","»Kepauka munanaiya waɨriyarika mɨti'uximayakakɨ xɨka yuxaɨta nuani, mɨpaɨta yuxaɨta kaniyemieni. »Xɨka nuani neɨketɨ, kaniyemienita 'ewitɨtɨ. ");
INSERT INTO hch_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","»Xɨka ti'aitɨwameya 'uka 'iwitɨtɨani, 'uka ti'aitɨwameya hetsɨa mɨmiemekɨ, xɨka tɨɨri mewarayexeiya, mɨkɨta ti'aitɨwameya hetsɨa mekaniyuhayewakuni tsepa memɨ'ukitsi ya'ukari. Hikɨ ti'uximayatame yuxaɨta kaniyemieni. ");
INSERT INTO hch_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","»Xɨka ti'uximayatame heitseriemekɨ mɨpaɨ 'utayɨni: “Tsepa ne nepɨkaxɨne, ne nepinaki'erie neti'aitɨwame, meta ne'ɨya metatsiere neniwema”, ");
INSERT INTO hch_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","'ana kutsiyarieya penuwitɨni 'itsɨkate wahetsɨa, muwa kitenie heutikerieme yunakatsie pe'inɨaritɨarieni. Mɨpaɨ 'itɨarieme yuheyeme yukutsiyari hetsɨa puyuhayewa. ");
INSERT INTO hch_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","»Xɨka xewitɨ yuniwe 'ukatɨme 'utuani ti'uximayatame mayanikɨ, mɨkɨ 'uka hatsuaku pɨkaxɨne ti'uximayatame 'uki hepaɨ. ");
INSERT INTO hch_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","»Xɨka kemɨ'ane minanai mɨkɨ 'uka ka'utiwitɨni, xeikɨa mɨka'inakekɨ, mɨkɨ pɨyɨweni marieya mɨrayukatuanikɨ hetsiena mieme. Mitixani'erikɨ mituanikɨ pɨkayɨweni teewapai kiekame hetsɨa, paapaya hamatɨa kememɨte'uxatakai mɨkaraye'atɨakɨ. ");
INSERT INTO hch_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","»Merikɨteta ti'aitɨwameya 'uka yuniwe pɨta xɨka 'uwitɨtɨani, kaneuyeweka yemekɨ yuniwe hepaɨ mɨtixeiyani. ");
INSERT INTO hch_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","»Xɨkata xeime pɨta 'ukaratsi 'utiwitɨni, pɨkayɨwe mɨtiwakweririeka yu'ɨitama, yaxeikɨata 'aixɨa ketiwaxeiyani, tiwamikwatɨ meta tiwaketɨatɨ meta yunaime wahamatɨa 'ukahuputɨ. ");
INSERT INTO hch_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","»Xɨka mɨkɨ haikamekɨ hetsiena mieme yakatikamiemi, pɨyɨwe 'ukaratsi meyani peru nitixaɨtɨkɨ hetsienamieme katiyutuiyatɨ. ");
INSERT INTO hch_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","»Kemɨ'ane xeime mɨtiukwinitɨani mimieni, mɨkɨta pɨmierieni. ");
INSERT INTO hch_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","»Xɨka mɨpaɨ kara'eriwatɨ tiuyurieni, Kakaɨyari pɨta yahainekaku tiɨyɨni, tiyumiekame pɨyɨwe muyuta'una hakewatsɨ ne nemetaxata. ");
INSERT INTO hch_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","»Xɨka 'imani mɨtiuyumi, mɨkɨ ke'umierieni tsepa muyu'awieta netukita mawari taiyametsie. ");
INSERT INTO hch_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","»Kemɨ'ane yupaapa meta yumaama mɨmieni, mɨkɨta ke'umierieni. ");
INSERT INTO hch_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","»Kemɨ'ane xeime tewi mɨnawani, meta xɨka 'ituani, xɨka hahekɨare 'akuxi ka'ituawetɨ, mɨkɨ ke'umierieni. ");
INSERT INTO hch_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","»Kemɨ'ane yupaapa yatɨni yumaama yuniukikɨ 'axa'aneme 'ipitɨani, mɨkɨ ke'umierieni. ");
INSERT INTO hch_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","»Xɨka meyukwitɨwetɨ yu'iwa xewitɨ tiukwinitɨani tetekɨ, yatɨni yumamakɨ, xɨka mɨkɨ 'utatsie kakaitɨ 'ayani kayuawetɨ, ");
INSERT INTO hch_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","mɨkɨ mɨtikwinitɨa katinayukatuamɨkɨ mu'uayemarienikɨ meta 'uximayatsiyakɨ kemɨreutere. Hikɨ kepaukake mɨtikuye kewetɨmayani yuxaɨta yatɨni 'itsɨ hakwetɨ, 'anake kanixɨnimɨkɨ, hetsiena pɨkarahɨiyani. ");
INSERT INTO hch_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","»Xɨka xewitɨ tiyu'uximayatame hekuwaxɨani kɨyekɨ 'ukitɨme yatɨni 'ukatɨme, xɨka mɨkɨ 'umɨni, kananutahɨiyamɨkɨ ti'aitɨwameya. ");
INSERT INTO hch_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Peru xɨka xeitukari huta tukari 'anukayayu ti'uximayatame 'aixɨa reka'erieni, mikuwaxɨa pɨka'anutahɨiyani hetsɨana mɨmiemetɨkaikɨ ti'uximayatame. ");
INSERT INTO hch_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","»Xɨka hipatɨ meyukwitɨwetɨ xeime hukame me'uwani, xɨka mɨkɨ ka'umɨni peru xɨka 'umɨni nunutsi 'anuyeweni, pɨrayukatuani kemɨ'ane mɨtiuyuri, kɨnaya kemɨtitawauni peru kemɨtiheitserie. ");
INSERT INTO hch_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","»Xɨka 'ukaratsi kwinimieme 'uyɨni, mɨpaɨ katinika'inɨarini: xɨka 'umɨni mɨkɨta ke'umierieni, ");
INSERT INTO hch_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","xɨka xeime hɨxieya watituni mɨkɨta hɨxieya kewatitɨiyani, xɨka tameya 'anaye'una mɨkɨta tameya ke'anaye'unarieni, xɨka mamaya wayemura mɨkɨta mamaya yaxeikɨa, yatɨni 'ɨkaya xɨka wayemura mɨkɨta 'ɨkaya kewayemurarieni, ");
INSERT INTO hch_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","xɨka 'itaiya mɨkɨta ke'utaiyarieni, xɨka 'iwani mɨkɨta ke'uweiyani, xɨka 'ixuritɨani mɨkɨta ke'uxuritɨarieni. ");
INSERT INTO hch_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","»Xɨka xewitɨ 'iyehutsuni hɨxitana tiyu'uximayatame 'ukitɨme yatɨni 'ukatɨme, xɨka hɨxieya 'uyetuni, 'aixɨa pɨ'ane xɨka heinɨ'ani, mɨkɨkɨ pɨxɨne. ");
INSERT INTO hch_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","»Xɨka xewitɨ tiyu'uximayatame tameya 'anaye'una 'uki yatɨni 'uka, mɨrekapitɨanikɨ keheinɨ'ani mɨkɨkɨ pɨxɨne. ");
INSERT INTO hch_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","»Xɨka tuuru xeime 'utsikɨpa, xɨka tewi 'ɨmɨni tsepa 'uki yatɨni 'uka, mɨkɨ tuuru ke'umierieni tetexikɨ ke'utituaxiexɨani, peru waiyarieya pɨkatikwaiwani. Hikɨ tewakame hetsie pɨkarahɨiwanita. ");
INSERT INTO hch_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","»Xɨka tuuru tiyutsikɨpani, ke'umierieni tetexikɨ tituaxiexɨame xɨka tewi 'umieni 'ukaratsi yatɨni 'uki. Kutsiyarieya xɨka 'imaikaitɨni kename tuuruya tiyutsikɨpa, mɨyatɨtɨ xɨka ka'ekuwieni, mɨkɨta kutsiyarieya ke'umierieni. ");
INSERT INTO hch_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","»Xɨka mumierietsie mieme ra'iwauriwani, kerayukatuani pɨta. ");
INSERT INTO hch_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","»Yaxeikɨata 'ikɨ 'aitsika pɨ'ane xɨka tuuru xeime nunutsi hetsikɨpa yatɨni 'uka nunutsi. ");
INSERT INTO hch_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","»Xɨka tuuru xeime 'utsikɨpa ti'uximayatame 'uki yatɨni 'ukatɨme, turu kutsiyarieya pɨtiyutuani xeitewiyari heimana tamamata pɨrata tuminiyarikɨ ti'uximayatame kutsiyarieya pɨrakapitɨani. Mɨkɨta tuuru ke'umierieni tetexikɨ. ");
INSERT INTO hch_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","»Xɨka xewitɨ putsu 'utawewieka 'inɨkatɨtɨ 'ewatitenime 'uhayewa xɨka ka'enuyenani, xɨka tuuru muwa heukaweni yatɨni puxu, ");
INSERT INTO hch_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","putsu kutsiyarieya pɨrayukatuani tewakame pɨrakapitɨani kemɨraye'aka, peru wakaxi mɨmɨki putsu kutsiyari pɨhetsiemiemetɨni. ");
INSERT INTO hch_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","»Xɨka xewitɨ tuuru xeime tuuru 'utsikɨpa, mutsikɨparie xɨka 'umɨni, mayeniere ke'utuiyani, yuhutatɨ wakutsiyarima mɨkɨ tuminiyari hixɨata meke'ɨni, meta mumierie waiyarieya hixɨata mekekɨne. ");
INSERT INTO hch_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","»Tuuru xɨka mɨpaɨ ti'iyamakaitɨni, xɨka kutsiyarieya 'imaikaitɨni kename tuuruya tiyutsikɨpakai peru mɨyatɨtɨ kahekuwieni, kutsiyarieya xeime pɨyetuani wakaxi, peru mɨmɨki hetsiena pɨmiemetɨni. ");
INSERT INTO hch_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","»Xɨka xewitɨ tuuru 'unawani yatɨni muxa, xɨka 'imieni yatɨni xɨka 'ituani, kutsiyarieya pɨyetuirieni yu'auxɨwime tewaxi tuuru munawakɨ, muxa hetsiemiemeta yunaukame muxatsi. ");
INSERT INTO hch_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","»Xɨka xewitɨ tinawanetɨ 'uxeiyarieni, xɨka 'umierieni, mɨkɨ hepaɨtsita 'atsipɨkatitaniukieni. ");
INSERT INTO hch_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","»Xɨka mɨkɨ tinawayame 'umierieni hekɨta, mɨkɨ mími hetsie pɨrahɨiyani. »Tinawayame peuyewetse mɨtiyutuanikɨ tita mɨrenawa. Xɨka ka'iyemanani mɨtiyutuanikɨ, kanituiyamɨkɨ ti'uximayatamekɨ mɨpaɨ mɨtiyutuanikɨ. ");
INSERT INTO hch_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","»Xɨka tewá hetaxeiyarieni 'akuxi hetsɨana 'ayenieretɨ, mɨkɨ piyetuani 'akuxi xeime tawarita heutinɨkame, tsepa tuuru yatɨni puxu yatɨni muxa. ");
INSERT INTO hch_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","»Xɨka xewitɨ yutewama tiwaminekaku xeime haraweritana meheutahaxɨani, mɨkɨ kawa'ɨwiyakaku xeime haraweritana mete'ukwani, tewakame pɨrayukatuani 'itsanari 'aixɨa mɨ'anenekɨ. ");
INSERT INTO hch_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","»Xɨka xewitɨ 'ɨxapa 'uta'ukwani, tɨriku xɨka hayetani yatɨni 'etsari mukuxeɨrietɨkari yatɨni hipame wa'etsaripa, kemɨ'ane mɨtiuyuri kepaɨmetɨ mɨtiutitai mɨkɨkɨ katinayukatɨamɨkɨ. ");
INSERT INTO hch_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","»Xɨka xewitɨ tumini xeime 'uhɨritɨani yu'iwa mi'ɨwiyanikɨ yatɨni tixaɨtɨ piinitɨarika, xɨka tinawayame tiunawani, mɨkɨ tinawayame pɨrayukatuani kepaɨ mɨtiunawa tawari hepaɨna paɨmeme, xɨkatsɨ 'uwiyarieni. ");
INSERT INTO hch_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","»Xɨka tinawayame 'uyuta'una, mɨkɨ mɨtihɨritɨariekai pɨyemie 'itsɨkame hetsɨa, naime mɨtitaxatɨanikɨ mɨkɨ 'atsimɨkatiuyurikɨ. ");
INSERT INTO hch_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","»Xɨka xewitɨ tixaɨtɨ tiuyukapiinitɨwani, meta xewitɨ mɨkɨtsiere, mɨkɨ meyuhutatɨ mepuhu 'itsɨkate wahetsɨa. Kemɨ'ane yakɨ mutaineni, mɨkɨ tawarita xeime pɨyetuani tita mɨtiuyukapiinitɨwakai, tuuru, puxu, muxa, kamixa tsepa tita mɨreuyehɨaka xɨka 'iwauka kename tipiinieyatɨkai. ");
INSERT INTO hch_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","»Xɨka xewitɨ yuhamiku puxu, tuuru, muxa 'uhɨritɨani yatsepa tita tewatsiekame, xɨka tewaya 'umɨni, tiutakwine, yatɨni xɨka 'unawarieni xewitɨ ka'uniere, ");
INSERT INTO hch_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","tewakame hamikuya Yawé hɨxie puyutaxata kename yutewa ka'ayeitɨa. Kutsiyarieya yuri ketita'eririeni, meta hamikuya pɨkatiyutuani. ");
INSERT INTO hch_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","»Xɨka hamikuya 'unieretɨtɨ munawarietsie, mɨpaɨ hɨrixɨa pɨrayukatuani. ");
INSERT INTO hch_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","»Xɨka tewatsiekame 'ɨrawe 'itakwani, hamikuya pɨkarayukatuani xɨka 'umeteya 'ixeiyatsitɨani. ");
INSERT INTO hch_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","»Xewitɨ xɨka yuhamiku tewa 'utaniɨwirieni, xɨka mɨkɨ rekwine yatɨni xɨka hemɨni, kutsiyarieya kanierekaku, kemɨ'ane mitaniɨ katinayukatuamɨkɨ. ");
INSERT INTO hch_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","»Xɨka kutsiyarieya nierekaku tiɨyɨni, mitaniɨ pɨkatiyutuani. »Xɨka tuminikɨ 'itaniɨkaitɨni mɨkɨkɨ xeikɨa pɨrayukatuani. ");
INSERT INTO hch_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","»Xewitɨ 'uki xɨka 'ɨimari 'utixɨatɨatɨyani 'uki kamaikame, xɨka hamatɨana 'ukahuni, wapaapama katiniwapitɨamɨkɨ kemɨraye'axe, meta kanitiwitɨmɨkɨ. ");
INSERT INTO hch_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","'Ɨimari paapaya xɨka ka'itaunieka menuwitɨnikɨ, 'uki pɨrayukatuani 'ɨimari mɨkamayɨiya kemɨraye'axe. ");
INSERT INTO hch_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","»'Uka 'ikewarikɨ mɨtiyɨ'ɨkitɨa pepɨwatakukuyani. ");
INSERT INTO hch_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","»Yunaitɨ teɨteri tewaxi memɨwakumaɨwa mɨkɨ meketakwikwiwani. ");
INSERT INTO hch_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","»Kemɨ'ane mawari xeimepɨta kakaɨyari mɨwewirieni, Yawé pɨta 'uwewirienikeme, mɨkɨ ke'umierieni. ");
INSERT INTO hch_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","»'Axapepɨkatikuhɨaweni waɨriyarika pepɨkati'aitɨaka 'ateewa kiekame, kena'eriwani 'ekɨ meta 'ateɨterima teewatari xepɨhɨkɨtɨkai 'Ekipitu kwieyaritsie. ");
INSERT INTO hch_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","»Pepɨkatiwa'aitɨaka kwinimieme wiuraxi meta nutuite, ");
INSERT INTO hch_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","xɨka 'ekɨ mɨpaɨ petiyurieneni meta 'ateɨterima, mɨkɨ parewiya xɨka menetsi'utawawirieni, yurikɨ ne nekanaineni nekaniwaranu'enimɨkɨ xɨka meha'aiwatɨkani: ");
INSERT INTO hch_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","waɨkawa nehaxɨakɨ nepɨxekwini xeme 'ixiparakɨ. Xe'ɨitama yuxaɨta mepuyuhayewa, xeniwema nutuite mepɨyuhayewa. ");
INSERT INTO hch_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","»Xɨka xewitɨ xeme, nehetsɨamieme hawerimɨ'ane tumini 'uniɨtɨani, teyuniniɨtɨwamete wahepaɨ xepɨkatewakɨhɨaweni meta 'anamakame xepɨkawawiyani. ");
INSERT INTO hch_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","»Xɨka xewitɨ yu'iwa 'ɨkarieya 'akahurieni, piyetuirieni taikai kakɨyɨriwekaku. ");
INSERT INTO hch_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Mɨkɨ yu'ɨkari xeime xeikɨa mexeiyakɨ tawarita pɨkaheixeiya xeime hetsiena mahuni. Xɨka netsi'utawawirieni parewiya, ne nepiparewieni kemaineni, ne Kakaɨyari nemɨtinekanenimaya nemɨhɨkɨkɨ. ");
INSERT INTO hch_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","»'Axapepɨka'utaineni Kakaɨyari hepaɨtsita, meta 'axapepɨkarenutahɨaweni teɨteri wahetsiemieme manuyeka. ");
INSERT INTO hch_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","»Pepɨkatihayewani peti'atɨwatɨ 'iku mawariyari meta winu mawariyari. »Xeniwema matɨari miemete nehetsɨa mekanimiemetetɨni. ");
INSERT INTO hch_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","»Meta tewaxi tuurutsixi meta muxatsi nehetsɨa mekanimiemetetɨni. 'Atahuta tukari yumaama matɨa puyeikani, 'atahairieka tukaritsie pepɨnetsiyetuirieni. ");
INSERT INTO hch_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","»Xeme neteɨterima xemɨpatsie xepɨhɨkɨtɨni. »Xepɨka'ikwa'ani wai 'ɨrawe 'ikwaixaya. Mɨkɨ tsɨikɨri xepɨwamikwani. ");
INSERT INTO hch_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","»'Itarikakɨ xepɨkatekuxatani. »'Axamɨtiuka'iyari pepɨkaparewieka, meta niukikɨ pepɨka'iparewieka 'itsɨkame hetsɨa. ");
INSERT INTO hch_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","»'Axamemɨte'u'iyari pepɨkawa'ɨkeni. »Tixanetsiekaku teɨteri yumɨiretɨ kememutiyuaneni mɨpaɨ pepɨka'utaineni. »Tita mɨtiheitserie pepɨka'uku'e'eiriwani, yumɨiretɨ 'axamemutiyuanekɨ xeikɨa. ");
INSERT INTO hch_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","»Pepɨkati'itaka xɨka haweri mɨ'ane tixanetani haweri mɨ'ane peparewimɨtɨ xeikɨa. ");
INSERT INTO hch_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","»Xɨka tuuru pehetaxeiya yatɨni puxu heuyewekame, keneyetua, tsepa mɨmatsi'aka'unie mɨtipiinieya. ");
INSERT INTO hch_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","»Puxu xɨka 'atiweximeni yu'ika kakematɨ, keneuparewi, tsepa mɨmatsi'aka'unie mɨtipiinieya. ");
INSERT INTO hch_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","»Tixaɨtɨ memɨkatehexeiya xɨka metexanetani, kemɨtiheitserie pepɨkatiuku'e'eiriwani wahetsiemieme. ");
INSERT INTO hch_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","»Xeime tewi pepɨkaxanetani 'itarikakɨ. »Pepɨkawatakukuyani teɨteri 'atsimemɨkateyurie yamemɨtekahu, ne kemɨ'ane hetsie mɨrahɨiwa 'atsikatiyuruwame nepɨkahayeitɨa. ");
INSERT INTO hch_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","»Tumini xɨka xewitɨ 'awie matsi'ɨitɨaka tixaɨtɨ kemɨkatiheitserie pemɨtiyurienikɨ, pepɨka'inaki'erieka, mɨpaɨ 'itsɨkate kemɨkatiheitserie mepɨteyuriwawe. ");
INSERT INTO hch_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","»Teewanarixi waɨriyarika xepɨkatewa'aitɨaka, xeme 'ari xepɨtemate yuhetsie: 'Ekipitu kwieyaritsie xeme teewanarixi xepɨhɨkɨtɨkai. ");
INSERT INTO hch_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","»'Ataxewime wiyari 'akwie pepuka'etsani pepuka'itsanani, ");
INSERT INTO hch_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","peru 'atahuta wiyaritsie pepɨka'ika'eni. Pepika'uxipitɨani, haweri memɨ'anene 'akie kiekatari mana memɨtetikwanikɨ meta yeutari memɨtetikwanikɨ tita memɨtehayewa teɨteri. »Yaxeikɨa pepɨtiyurieni kaxie haraweriyaritsie meta huriwu haraweriyaritsie. ");
INSERT INTO hch_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","»'Ataxewime tukari pepɨti'uximayaka, 'atahuta tukaritsie mepɨka'uxipieni 'atuurutsixi meta 'apuxuri, yunaitɨ te'uximayatamete mepɨka'uxipieni 'akie memutinunuiwaxɨ meta teewanarixi. ");
INSERT INTO hch_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","»Xeketenaye'atɨa naimekɨ kenemɨtixe'uta'aitɨa. »Hatsuaku hipame kakaɨyarixi xepɨkawarahɨaweni. Kememɨtetetewa hatsuaku xepɨkawaraxaxatani. ");
INSERT INTO hch_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","»Xeiwiyaritsie haikakɨa 'ixɨarari pepuwewiximeni nehetsiemieme. ");
INSERT INTO hch_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","»Paa mɨkakuxaxani 'ixɨarariyari xepiwewiximeni weiya metseriyaritsie, mɨkɨri mana pɨka'inɨarini. Xeme mɨkɨ metseriyaritsie xekanayekɨne 'Ekipitu. Kenemɨtixe'aitɨa, 'atahuta tukari xekanikwakakuni paa mɨkakuxanariyarietɨka. »'Aixɨa pɨka'ane xewitɨ nehɨxie mɨ'axeni tixaɨtɨ karapitɨ 'imikierite. ");
INSERT INTO hch_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","»'Itsanari 'ixɨarariyari pekaniwewimɨkɨ kepauka mexɨakame pemɨtikatɨni pemika'e. »Xepiwewienita 'ixɨarari naime kepauka xemɨteka'itsanatsie, mɨkɨ wiyari 'anayexɨximekaku. ");
INSERT INTO hch_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","»Yunaitɨ xeme yuxexuitɨ xeiwiyaritsie haikakɨa xepɨ'axeni, Yawé xekakaɨyari hetsɨa. ");
INSERT INTO hch_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","»Tikuxanariyame xuriya matɨa xepɨka'inɨitɨaka xemɨnetsitimawirieni. »Xepɨka'iti'utani wiya 'uxa'arieka mieme mayanikɨ 'ixɨararipa xemɨnetsixatɨa. ");
INSERT INTO hch_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","»Pepi'atɨani Yawé 'akakaɨyari tukita 'aixɨa mɨti'anene matɨari timieme mɨtitixuawere. »Tsipu nunutsi maamaya retsieyatsie xepɨka'i'etsani. ");
INSERT INTO hch_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","»Mɨpaɨ ketinemaika 'Ixaheri, ne nepenunɨ'ani 'ahɨxie niuki tuayame, mɨmatsihe'ɨwiyanikɨ huyeta, mɨmatsi'anuwitɨni hakewa 'ahetsiemieme nemɨrekuha'aritɨa. ");
INSERT INTO hch_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Keneu'enieka yaketinekamieni. 'Axapepɨkareyurieneni hɨxiena, nehetsiemieme kaniyɨaneni, pɨkamereuyehɨwirieni xɨka mɨpaɨ pereyurieni. ");
INSERT INTO hch_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Xɨka pehenu'enieni, xɨka yapetikayani naimekɨ kenemɨti'aita, memɨmatsi'aye'unie ne newaraye'unietɨ nepayani meta kemɨ'ane 'ahɨxie memu'uni wahɨxie nepukeni. ");
INSERT INTO hch_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Neniuki tuayame pɨmatsi'anuwitɨni, mɨkɨ nemɨwaka'una wakwieyaritsie pɨmatsi'atɨani: 'amuxeutsixi wakwietsie, hetitsixi, peretseutsixi, kananeutsixi, heweutsixi meta kewutseutsixi. ");
INSERT INTO hch_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","»Mɨkɨ wakakaɨyarixima wahɨxie pepɨkahetihɨximakiekani. Nenewieri pepɨkawarepitɨaka kememɨtehehu, pepɨkaware'ɨkirieka. Matsi pɨta xekeniwareti'uniri wakakaɨyarixi meta watetexi mɨpatsietɨka xekenetitara. ");
INSERT INTO hch_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","»Nenewieri kenepitɨaka Yawé 'akakaɨyari, mɨkɨ 'aixɨa piyurieni 'a'ikwai meta 'ahaa. »Ne naime kwiniya xehetsie nepɨkapitɨani. ");
INSERT INTO hch_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","»'Akwieyaritsie xewitɨ 'uka pɨka'anuye'iwetsieni meta xewitɨ kaniwewetɨ pɨkahayani. Ne tukari 'atewime nepɨxepitɨani. ");
INSERT INTO hch_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","»Kepauka pemunuani xeime kwieyaritsie, yanepɨtiyurieni memɨmatsitimakanikɨ, memeuyuyexɨrienikɨ meta memɨyuta'unakɨ. ");
INSERT INTO hch_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","»'Ahɨxie nepɨwaranɨ'ani mɨrakatsixi, memuyuta'unaxuanikɨ heweutsixi, kananeutsixi meta hetitsixi. ");
INSERT INTO hch_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Nepɨkawarayeweiya kwitɨwa xeiwiyaritsie kapa kwie yuxaɨta yuhayewayu me'uyutamɨiriya 'ɨrawetsixi, mexe'utikwani. ");
INSERT INTO hch_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Nepɨwaka'una 'anɨari, kepaukake yuniwema waɨkawa xemɨwarexeiyani kwie naime xemukunanikɨ. ");
INSERT INTO hch_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","»'Akwie 'anepɨtayeuriya, 'atsita Haramara Mɨxeta hetsie paitɨ meta haramara Meritexaniyu paitɨ, makumawetsiepai 'atsita 'Eupɨrate hatuxameyaritsie paitɨ. 'Ekɨ pepɨtiwata'aitɨani yunaime mana memɨkiekatari, pepɨwarayeweiya. ");
INSERT INTO hch_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","»Mɨkɨ teɨteri wahamatɨa tɨratu xepɨkawewieka, metatsiere wakakaɨyarixima wahamatɨa. ");
INSERT INTO hch_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","»Xɨka xewarupitɨani xekwiepa memu'uwanikɨ, mɨkɨ mepɨxewiniya wakakaɨyarixi xewarayexeiyatɨ xemakɨnekɨ, mɨpaɨ 'axaxepɨteyurieni nehetsɨa». ");
INSERT INTO hch_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Metatsiere Yawé Muitsexi mɨpaɨ katiniutahɨawe: «Hɨritsie kenatiye'a nehetsɨa, meta 'Aruni, Narawi, 'Awihu, metatsiere haika tewiyari heimana tamamata 'ukirawetsixi 'ixaheritsixi. Mɨkɨ mepɨkatunuma'uni yateewa, ");
INSERT INTO hch_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","peru 'ekɨ xeikɨa Muitsexi pepɨyɨwe 'ahurawa pemayani nehetsɨa. Yunaitɨ hipatɨ mepɨkayɨwawe 'ahurawa memakɨne meta memanatikɨne 'ahamatɨa». ");
INSERT INTO hch_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Muitsexi 'anukayaka meta katiniwarutaxatɨani teɨteri naime Yawé kemetayɨ, mɨkɨta mɨpaɨ mekaniutiyuani yunaitɨ: «Yatepɨteyurieni naime Yawé kemetayɨ». ");
INSERT INTO hch_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Hikɨ Muitsexi pɨraka'utɨa naime Yawé kemɨreitahɨawixɨ. 'Uxa'arieka ximeripaitɨ nanukukeni, tenari timawame kaniutawewieni hɨritɨa. Meta tamamata heimana huta 'Ixaheri nuiwarimama 'inɨariyari, tetexi tamamata heimana huta patsiekame kanayeitɨani. ");
INSERT INTO hch_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","'Ana hipame temari 'ixaheritsixi kaniwarenɨ'ani, Yawé hetsiemieme tsikerutsixi wamawari taiyariyari memɨwewiyukɨ meta kename 'aixɨa memɨteyuxeiyani mawariyari. ");
INSERT INTO hch_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Muitsexi hixɨapa 'akame tuuru xuriyaya tekɨxita kaniukatuaxɨani, xeime hixɨapa 'akamekɨ mɨrayutimawatɨre kaniuta'ɨya. ");
INSERT INTO hch_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Hikɨ 'arike tɨratu xapayari kaniutihurieni, kanekaterɨwa 'ixaheritsixi wahɨxie, mɨkɨ mɨpaɨ mekatenita'eiya: —Yawé naimekɨ kemutayɨ yatepɨtekakɨne. ");
INSERT INTO hch_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Muitsexi xuriya 'utihanaka, mɨkɨkɨ teɨteri kaniwaru'ɨya, mɨpaɨ 'utaitɨ: —'Ikɨ xuriya tɨratu 'inɨariyari kanihɨkɨtɨni, Yawé yapɨtiuyuri meta xeme yaxemutiyuakɨ. ");
INSERT INTO hch_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Muitsexi, 'Aruni, Narawi, 'Awihu, metatsiere haika tewiyari heimana tamamata 'ukirawetsixi 'ixaheritsixi mekananutikɨne hɨritsie, ");
INSERT INTO hch_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","hikɨ mekanixeiya 'Ixaheri Kakaɨyarieya. Hetɨana pukumakai tete witsimɨ'ane muyuawi mɨxawatɨ, witsiranuyehekɨatɨ muyuawi hepaɨ. ");
INSERT INTO hch_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","'Ukirawetsixi 'ixaheritsixi wa'ukiyarima me'ixeiyakatɨtɨ, mepɨka'ukwi, Kakaɨyari mɨkawarumayɨakɨ. ");
INSERT INTO hch_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Yawé Muitsexi mɨpaɨ katiniutahɨawe: «Kenatiye'a hɨritsie nehetsɨa, mana keneuyuhayewa. Nepɨmatsiyetuirieni 'inɨari niukiyari, tete wewerimetsie mɨye'uxa meta ne'aitsika nemaka'utɨa para mɨpaɨ xemɨte'u'uwanikɨ». ");
INSERT INTO hch_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Muitsexi Kakaɨyari hɨrieyatsie kaneyani yuparewiwame Kutsuhexi hamatɨa, ");
INSERT INTO hch_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","peru 'ukirawetsixi mɨpaɨ katiniwarutahɨawe: «'Ena xeketanetakwewieka kepaukake temɨ'axɨani. 'Aruni meta Kuxi matɨa mepuyuhayewa 'ena xehamatɨa, xɨka xewitɨ 'uximatɨarika hexeiyani mɨkɨ yaketiwarutahɨawe». ");
INSERT INTO hch_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Kepauka Muitsexi manutitɨa haiwitɨri hɨritsie kananukateni. ");
INSERT INTO hch_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Yawé tɨrɨkariyaya xawatɨtɨ kanakateni Tsinahi hɨriyaritsie, 'ataxewime tukari haiwitɨri hɨri panukanakai, 'atahutarieka tukaritsie haiwitɨritsata Yawé Muitsexi kaniutahɨawe. ");
INSERT INTO hch_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Me'ixeiyakaku 'ixaheritsixi Yawé tɨrɨkariyaya xawatɨtɨ hɨritsie tai mɨtiyutaiya hepaɨ pɨtiyuxexeiyakai. ");
INSERT INTO hch_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Muitsexi kaneutahani haitsata kananutiyani hɨritsie, mana pekatei huta tewiyari tukari meta huta tewiyari tɨkari. ");
INSERT INTO hch_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Merikɨtsɨ Yawé Muitsexi katiniutaxatɨani, mɨpaɨ rehɨawetɨ: ");
INSERT INTO hch_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","«'Ixaheritsixi mɨpaɨ ketiniwaruta'aitɨa mawari mekenetsi'atɨirieni. Kaneuyewekani memi'atɨanikɨ yunaitɨ kemɨ'ane mɨpaɨ mɨtiwakuyuitɨwani. ");
INSERT INTO hch_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Mawarite neminaki'erie pɨhɨkɨtɨni: huru tepɨayari, pɨrata, wurunitse, ");
INSERT INTO hch_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","muxa 'ixurikiyari mɨyɨtsikimaɨyekɨ mu'uarietɨka meta kwimɨxetakɨ metatsiere mɨxetakɨ, rinu 'ixurikiyari witsimɨ'anene, kapura huxarieya 'ɨkariyari, ");
INSERT INTO hch_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","muxa 'uki nawiyarieya xetamekɨ 'uarietɨkaime, nawi 'aixɨa mɨ'anene, 'akatsiya kɨyeyari, ");
INSERT INTO hch_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","huriwa hatseitiyari kɨxeme hetsiemieme, witsimɨtiu'ɨatɨka witsitiyu'ɨariyame hatseiti mɨtiyupata meta 'ɨkwa witsimu'ɨa, ");
INSERT INTO hch_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","'unitse teteyari, meta hipame tetexi witsimɨ'anene mawari wewiwame kamixaya 'etsimɨnena hetsie meuyaxe meta kuka mekatɨni hetsiemieme. ");
INSERT INTO hch_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Meta tuki xepɨnetsitawewirieni, xehamatɨa nemuyeikanikɨ. ");
INSERT INTO hch_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Tuki xemɨtawewieni naitɨ pɨtiyepika kenemɨmatixeitsitɨani mɨpaɨ ti'aneneme. ");
INSERT INTO hch_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","»Kakuni keneutawewi 'akatsiya kɨyeyarikɨ, xeimeturuyari heimana tamamata tsenitimeturuyari tewime, haika tewiyari heimana tamamata tsenitimeturuyari 'atayeume meta yaxeikɨata mɨpaɨ 'utewime. ");
INSERT INTO hch_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Huru kenewakuwiri taɨtana meta herie, meta hurukɨ kenatatenitɨa. ");
INSERT INTO hch_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Keneutiwewi naukame huru hanirayari 'ɨkateyatsie keneu'uitɨaxɨa, 'etsatana huhutatɨ kana'uixɨamɨkɨ. ");
INSERT INTO hch_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Kurumawime 'akatsiya kɨyeyari keneutiwewi, huru keneutiwiri. ");
INSERT INTO hch_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Kɨyexi mukurumawi haniratsie keneuye'uitɨaxɨa kakuni 'etsatana mukumanetsie, mukukweiyanenikɨ. ");
INSERT INTO hch_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Mɨpaɨ reheikame keneuhayewa pepɨkahenuyehapanani, ");
INSERT INTO hch_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","mana pepikamana 'inɨari niukiyari nemɨmatsiyetuirieni. ");
INSERT INTO hch_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","»Hurukɨ xeikɨa wewiyakame keneutawewi kanamikiyari Kakaɨyari ma'axeni, xeimeturuyari heimana tamamata tsenitimeturuyari tewime meta haika tewiyari heimana tamamata tsenitimeturuyari 'atayeume, ");
INSERT INTO hch_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Kakaɨyari teɨtamete yuhutame hurukɨ pepɨwatiwewieni, titsunamekɨ mewewiyatɨkaime, kanamikitsie Kakaɨyari ma'axeni 'etsimeuyeyeutsie mema'uni. ");
INSERT INTO hch_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","'Etsimeuyeyeutsie mepu'uni Kakaɨyari teɨtamete. Mewetɨkaime meyuxewime keniwarayeitɨa Kakaɨyari ma'axeni. ");
INSERT INTO hch_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","»Kakaɨyari teɨtamete Kakaɨyari ma'axe heimana mepuye'anatɨkani, kɨmana mepenukanaka. Mepanuyutaxeiyani Kakaɨyari ma'axe meheukanenieretɨ. ");
INSERT INTO hch_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","»Kanamiki kenanukamana kakunitsie, manata kenekamana 'inɨari niukiyari nemɨmatsiyetuirieni. ");
INSERT INTO hch_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Ne mana nepɨ'axeni Kakaɨyari teɨtamete wahixɨapa kakuni heima. Mana ne yanepɨmatikɨhɨaweni naime 'ɨkitɨarika pemɨwakuxaxatɨwanikɨ 'ixaheritsixi. ");
INSERT INTO hch_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","»'Akatsiya kɨyeyarikɨ mexa keneutawewi, nauka tewiyari heimana tamamata tsenitimeturuyari tewime meta huta tewiyari heimana 'auxɨwi 'atayeume meta haika tewiyari heimana tamamata 'aweme. ");
INSERT INTO hch_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Huru keneukawiri, hurukɨtsiere tenimeyaritsie kenata'utɨa. ");
INSERT INTO hch_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Xeitewiyari tsenitimeturuyari 'atayeume kenata'utɨa meta tenimeyari kenatawewi 'auriena hurukɨ. ");
INSERT INTO hch_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","»Naukame huru hanirayari keneutiwewi mexatsiemieme, xexuime keneu'uitɨaxɨa tsikurieyatsie, ma'ɨkatɨkatsie. ");
INSERT INTO hch_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Hanira, mexa tenimeyari 'aurie pukumaneni, mana kɨyexi muye'unikɨ mɨkɨtɨkienenikɨ. ");
INSERT INTO hch_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","»Mɨkɨ kɨyexi mukurumawi 'akatsiya kɨyexiyari pɨhɨkɨtɨni, huru wiriyarietɨkaitɨ. ");
INSERT INTO hch_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Xakɨrɨte, 'itɨte, hurukɨ xeikɨa pɨwewiyatɨkani meta tekɨxite, xarite 'amɨnene winu mawariyari tu'ame. ");
INSERT INTO hch_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Mexatsie paa yapepɨramanani, nehɨxie yamɨtixuawenikɨ. ");
INSERT INTO hch_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","»Kɨxeme 'uitɨwame hurukɨ keneutawewi, titsunamekɨ wewiyakame. Hetsiena maweni, 'ɨkayari, muwatixaxawa, tuturi yu'iwitsi hexeiyame, tuturiyari yuxewiriyatɨ xeikɨa payani. ");
INSERT INTO hch_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","'Ataxewime yumamate pexeiyani, tapa haikatɨ tapata haikatɨ. ");
INSERT INTO hch_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Xexuime mamateyaritsie haikakɨa puwatixaxawani 'arimetɨra tuturiyari hepaɨ tiyuxexeiyatɨ, tuturi yu'iwitsiyari hexeiyakame meta xawariyari. ");
INSERT INTO hch_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Kɨxeme 'uitɨwame peixeiyanita nauka tekɨxiyari 'arimetɨra tuturiyari hepaɨ 'aneneme, meta yuxawari hexeiyatɨkaime. ");
INSERT INTO hch_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Xexuitɨ mamateyari peixeiyani xexuime tekɨxi hixɨata, 'ɨkayari mɨrawiyatɨkatsie. ");
INSERT INTO hch_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Tekɨxite meta mamateyari puyuxewiriyani kɨxeme 'uitɨwame hamatɨa, huru xeikɨa pɨhɨkɨtɨni titsunamekɨ wewiyakame. ");
INSERT INTO hch_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","»Keneutiwewiri 'atahuta kɨxemeyari, muwa keneuka'uitɨa yuhɨxie heuyekɨxeme. ");
INSERT INTO hch_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Tepɨa hiru xikame kɨxeme hetsiemieme meta tɨɨ yayatsame, huru xeikɨa pɨhɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Mɨkɨ kɨxeme 'uitɨwame mɨtawewierekɨ meta tinaitɨ mɨreukapinire huru xeitewiyari heimana tamamata heimana haika kiruyari kaniyɨmɨkɨ. ");
INSERT INTO hch_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","»Kenematiuxeiyatsitɨa hɨritsie yemekɨ mɨpaɨ ti'aneneme ketineutiwewi. ");
INSERT INTO hch_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","»Tuki mɨpatsie keneutawewi tamamata rinu 'ixurikiyarikɨ 'ayeyeumekɨ, meta muxa hiruyari 'uariekame mɨyɨtsikimaɨye meta kwimɨxetakɨ metatsiere mɨxetakɨ, Kakaɨyari teɨtamete mehaxutɨkaime. ");
INSERT INTO hch_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Naitɨ rinu 'ixurikiyari yaxeikɨa pɨyeyeuka, tamamata heimana huta meturuyari heimana 'imeriyu pɨtɨni meta xeimeturuyari heimana nauka tewiyari tsenitimeturuyari patayeyeuka. ");
INSERT INTO hch_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","»Keneutawipa 'ixuriki 'auxɨwime, yuwiwiyame keneuyuri, hipameta 'auxɨwime yaxeikɨa keneuyuri. ");
INSERT INTO hch_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Matɨari pemitawipaxɨtsie 'imatɨrieka 'ixurikitsie, hakɨrɨi kenawɨtɨaxɨa muxa witayarikɨ mɨyɨtsikimaɨyekɨ, meta yaxeikɨa ketineuyuri hutarieka miemetsie. ");
INSERT INTO hch_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Matɨari pemitawipaxɨtsie kenawɨtɨa huta tewiyari heimana tamamata hakɨrɨi, yaxeikɨata paɨmeme hutarieka miemetsie, naitɨ yaxeikɨa papaɨmeme mexeiyatɨkanikɨ. ");
INSERT INTO hch_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Hikɨta huru kwatsituraiyari 'etsipepeme keneutiwewi, huta tewiyari heimana tamamata 'ixuriki 'amɨyeyeu muyuwiyakɨ, tuki hetsie yuxewiriyatɨ mayanikɨ. ");
INSERT INTO hch_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","»Tamamata heimana xewi tsipuri wahuxari 'ɨkariyari 'ayeyeume keneutiwewi, tuki manukanarekɨ 'ixuriki kiyari hepaɨ tiyuxexeiyatɨ. ");
INSERT INTO hch_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Yaxeikɨa pɨyeyeuka naitɨ, tamamata heimana haika meturuyari heimana 'imeriyu tɨtɨkame meta xeimeturuyari heimana nauka tewiyari tsenitimeturuyari 'atayeyeume. ");
INSERT INTO hch_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Keneutawipa 'auxɨwime 'ɨkariyari yuxewitɨ mayanikɨ, hipameta 'ataxewime yuxewiriyame, 'ataxewirieka mieme tuki hɨxie muwiere patitunire. ");
INSERT INTO hch_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","»Huta tewiyari heimana tamamata kenawɨtɨaxɨa hakɨrɨi matɨari pemitawipaxɨtsie 'imatɨrieka 'ɨkariyaritsie, tawarita hutarieka miemetsie yaxeikɨa paɨmeme. ");
INSERT INTO hch_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Hikɨta wurunitse kwatsitɨraiyari keneutiwewi 'etsipepeme huta tewiyari heimana tamamata, hakɨrɨi mawɨtɨkatsie keneuyehatɨaxɨa tuki mayanikɨ, yuxewiriyatɨ naitɨ kanayeimɨkɨ. ");
INSERT INTO hch_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Mɨkɨ 'ɨkari tamamata mɨhɨkɨ, xewitɨ mɨkɨ naitsata panukawereni 'anuyuhayewatɨ mɨkɨ tuki warita peukawiwieka. ");
INSERT INTO hch_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Mɨkɨ 'ixurikitsie panayuhayeikawani huta tewiyari heimana tamamata tsenitimeturuyari tapa kɨtsimeyaritsie meta tapatatsiere, mɨkɨkɨ tukita pɨreunare. ");
INSERT INTO hch_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","»Heimana manukawerire keneutawewi tuki hetsiemieme, muxatsi wanawiyari xetamekɨ mɨ'uarietɨkakɨ, mɨkɨ heima 'imatɨrieka manukawerire ketsɨ nawiyarieya 'aixɨa mɨ'ane keneuyuri. ");
INSERT INTO hch_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Tuki hetsiemiemeta 'akatsiya mexayari keneutixixi, ma'utɨyani. ");
INSERT INTO hch_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Xexuitɨ mexa nauka meturuyari heimana 'imeriyu pɨtɨni meta haika tewiyari heimana tamamata tsenitimeturuyari 'atayeyeutɨ, ");
INSERT INTO hch_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","meta mɨkɨ mexa xeitapa hutakɨa panumɨtsɨni, mexa heitserie mɨti'uwenikɨ yuhepaɨtsita. Naime mexa 'ematayeyeu tukitsie mieme mɨpaɨ pepɨtiwewieni. ");
INSERT INTO hch_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Xeitewiyari mexa pɨyɨni, 'ameuyewatsie tatsutɨa mɨyekatsie. ");
INSERT INTO hch_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","»Huta tewiyari keneutiwewita pɨrata tepɨayarikɨ mexa hetsiena ma'uni, xexuitɨ mexa huhutatame pexeiyatɨkani, huhutatametsie meuka'unikɨ. ");
INSERT INTO hch_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Tayeta muyekatsie 'ameuyewatsie miemeta keneutiwewi xeitewiyari mexa 'ematayeyeu tukitsie mieme. ");
INSERT INTO hch_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","Huta tewiyari pɨrata tepɨayari keneutiwewita mexa xexuitɨ mɨti'unitsie hetɨana pekaniti'uitɨamɨkɨ. ");
INSERT INTO hch_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","'Etsimeuyewatsieta 'ataxewime mexa keneu'uitɨa, tau makayuyuipike hepatsie, ");
INSERT INTO hch_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","tawarita xexuime keneuka'uitɨaxɨa mutatsikuritɨkatsie. ");
INSERT INTO hch_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Mɨkɨ mexa yu'aurie puti'uka, yuxexuitɨ mituikatɨka pexeiyani, wapaitɨ xeihanirayarikɨ puyutseiriyani. Hutakɨa yaxeikɨa ketineuyuri mutatsikuritɨkatsie, ");
INSERT INTO hch_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","'atahaika mexayari pɨyɨni meta tamamata heimana 'ataxewi mexatɨa mieme pɨrata tepɨayari, huhutatame xeimexayaritɨamieme. ");
INSERT INTO hch_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","»'Akatsiya kɨyeyari pepɨtixixieni manukuhini: meta 'auxɨwime mexate tuki 'etsata mieme, ");
INSERT INTO hch_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","'auxɨwime tapa mieme, 'auxɨwimeta 'etsimauyewatsie mieme tuki manutinieretsie. ");
INSERT INTO hch_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Kɨyexi ma'utɨka wahixɨapa mukuhuni mexate heutanetɨkaitɨ kaniyɨmɨkɨ. ");
INSERT INTO hch_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Mexa mɨpepetsawi huru keneutiwiri meta huru hanirayari keneutiwewi manukuhini mana mauye'uixɨanikɨ. Yaxeikɨa manukuhini huru keneutiwiri. ");
INSERT INTO hch_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Tuki keneutawewi kenematiuxeitsitɨa hɨritsie yemekɨ mɨpaɨ 'anekame. ");
INSERT INTO hch_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","»'Ixuriki 'ayeume keneutawewi meuwiere mɨyɨtsikimaɨyekɨ, kwimɨxetakɨ meta mɨxetakɨ meta rinu witsimɨ'anekɨ, Kakaɨyari teɨtametemama mehaxutɨkaime hetsiena. ");
INSERT INTO hch_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Keneuwi huru kwatsituraiyarikɨ, nauka 'akatsiya 'ikitsaraɨyaritsie huru muwiriyarietɨkatsie tiwiyakame. Naukame pɨrata tepɨayaritsie pepe'uitɨani. ");
INSERT INTO hch_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","'Ixuriki hixɨapa keneutawi kwaitsituraitekɨ, Muyepatsietsie meta Waɨkawa Muyepatsietsie mukunatɨkanikɨ, tɨratu kakuniyari 'ixuriki warita mayekanikɨ. ");
INSERT INTO hch_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Tɨratu kakuniyari kenanukanama kanamikiyarikɨ Kakaɨyari ma'axetsie, Waɨkawa Muyepatsietsie paitɨ, ");
INSERT INTO hch_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","'ixuriki meuwie hɨxietsie Waɨkawa Muyepatsietsie, tuki 'etsata tayeta muyekatsie mexa keneutiketsa. Kɨxeme 'uitɨwameta mexa hɨxie keneutiketsa tatsutɨa muyekatsie. ");
INSERT INTO hch_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","»'Ixuriki keneutawewi tuki kitenie mieme mɨyɨtsikimaɨyekɨ, kwimɨxetakɨ meta mɨxetakɨ rinu witsimɨ'anetsie tixukame. ");
INSERT INTO hch_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Mɨkɨ 'ixuriki hetsiemieme, 'auxɨwime 'akatsiya kɨyeyari 'ikitsaraɨyari keneutixixi meta huru keneutiwiri, huru kwatsituraiyari hexeiyatɨkaime, meta wurunitsekɨ keneutiwewiri 'auxɨwime hetsiena ma'uni. ");
INSERT INTO hch_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","»Mexa keneutawewi mawari wewiwame 'akatsiya kɨyeyarikɨ, 'utatsikuritɨkaime yaxeikɨa huta meturuyari heimana xeitewiyari heimana tamamata tsenitimeturuyari heutatetewame, meta xeimeturuyari heimana xeitewiyari heimana tamamata tsenitimeturuyari 'awekame. ");
INSERT INTO hch_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Naitsata naukakɨa muta'itsikinatɨkatsie kenawewiexɨa 'awateya, mexa matɨa yunaitɨ puyuxewiriyani, meta wurunitsekɨ keneukawiri mexa mawari taiyariyari wewiwame. ");
INSERT INTO hch_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Yaxeikɨata ketineutiwewi wurunitsekɨ naime tita mɨreuyewetse mawari matiwewiwa, naxi yetsame, 'itɨ 'amɨpa, tepɨa manuxɨte meta tɨɨ yayatsame. ");
INSERT INTO hch_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Meta 'ayexaxawame keneutawewiri wurunitsekɨ, naukakɨa muta'itsikinatɨkatsie hanira kenamanaxɨa. ");
INSERT INTO hch_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Mawari taiyariyari wewiwame hetɨa tenimeyari manuka'atɨkatsie kana'uimɨkɨ hanira, mexa hixɨapa kaniuyemarimɨkɨ. ");
INSERT INTO hch_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Hutame keneutiwewi kɨyexi kurumawime 'akatsiya kɨyeyarikɨ, mexa mawari wewiwametsiemieme meta wurunitse keneukawiri. ");
INSERT INTO hch_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Kɨyexi mɨkurumawi haniratsie peuyehaxɨani, 'a'anuyetɨtɨ mawari wewiwametsie, mɨkɨ kɨmana mukukweiyanenikɨ. ");
INSERT INTO hch_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Mawari wewiwame pemɨtawewieni 'uxawame pepɨyurieni, mexakɨ wewiyakame, kenematiuxeitsitɨa hɨritsie mɨpaɨ 'anekame. ");
INSERT INTO hch_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","»Takwa tuki hetsiemieme pepɨtawewieni. Tahetɨa muyekatsie huta tewiyari heimana 'auxɨwi meturuyari pexeiyani, meta rinu 'ixurikiyari 'aixɨa mɨ'anene hawɨtɨkaitɨ, ");
INSERT INTO hch_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","xeitewiyari kɨyexi mɨka'uni pexeiyani, xeitewiyari wurunitse tepɨayari kɨyexi hetsiena ma'uni. Kɨyexi pexeiyatɨkani kɨmana naitɨ muyuwiyaxɨani pɨrata tepɨayari meta hanira metatsiere pɨrata karawatuyari. ");
INSERT INTO hch_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Yaxeikɨata heutatewame tayetatsie huta tewiyari heimana 'auxɨwi meturuyari pexeiyani, 'ixuriki hawɨtɨkaime meta xeitewiyari kɨyexi mɨka'uni pɨyɨni meta yaxeikɨa paɨmeme hetsiena ma'uni wurunitse tepɨayari. Metatsiere kɨyexi hanira pexeiyatɨkani meta kɨmana muyuwiyaxɨani metatsiere kwatsiturai naitɨ pɨrata tepɨayari pɨtihɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","»'Etsimeuyewatsie tau makayuyuipike hepatsie, xeitewiyari heimana huta meturuyari heimana 'imeriyu peutatewani, 'ixuriki meuwɨre pexeiyani, tamamata kɨyexi mɨka'uixɨani meta hepaɨna paɨmetɨ hetsiena ma'uni wurunitse tepɨayari. ");
INSERT INTO hch_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Yaxeikɨata tau manatineika hepatsie, xeitewiyari heimana huta meturuyari heimana 'imeriyu pexeiyani. ");
INSERT INTO hch_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Mɨranutahakitɨretsie xeitapatsie 'atahuta meturuyari pexeiyani 'ixuriki meuwɨ, haikatɨ kɨyexi pɨyɨni muka'uni meta haikatɨ hetsiena ma'uni, ");
INSERT INTO hch_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","yaxeikɨata pɨti'aneni xeitapatsie. ");
INSERT INTO hch_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","»Kuraru kitenie 'ixuriki peuwiere 'atanauka meturuyari tewitɨ, pɨwewiyaka wita mɨyɨtsikimaɨyekɨ, kwimɨxetakɨ, mɨxetakɨ, rinu witsimɨ'ane hetsie raxuiyakame, meta naukame kɨyexi pexeiyani naukameta hetsiena ma'uni. ");
INSERT INTO hch_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Naitɨ kɨyexi takwa mukunama, hanira pexeiyatɨkani, meta pɨrata kwatsituraiyari, metatsiere wurunitse tepɨayari mituikaxɨani. ");
INSERT INTO hch_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Takwa huta tewiyari heimana 'auxɨwi meturuyari pɨtewini meta xeitewiyari heimana huta meturuyari heimana 'imeriyu patayeuka, rinu 'ixurikiyari 'aixɨa mɨ'anene hexeiyakame huta meturuyari heimana xeitewiyari heimana tamamata tsenitimeturuyari tɨtɨkame, meta mituikatɨka wurunitse pɨhɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Naitɨ manuyemɨtsɨ mɨkatsunirixɨani meta tita tukita mutiyukumauwa wurunitsekɨ pɨtiyɨni, metatsiere kurarutsiemieme mɨkatsunirixɨani. ");
INSERT INTO hch_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","»Mɨpaɨ ketiniwaruta'aitɨa 'ixaheritsixi huriwa hatseitiyari hɨkɨame memɨmatsi'atɨirienikɨ, kɨxeme yuheyemekɨ mɨtatɨkanikɨ. ");
INSERT INTO hch_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","'Aruni meta niwemama tɨkarikɨ yamekatenitaiyakakuni Yawé hɨxie 'ixuriki tukiyarita, 'ixuriki meuwie hɨxie tɨratu kakuniyari muyekatsie. 'Ikɨ 'aitsika 'ixaheritsixi mepaye'atɨaka, yuheyemekɨ wanuiwarima yunaitɨ. ");
INSERT INTO hch_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","»Merikɨte 'a'iwa 'Aruni keneuta'ini meta niwemama Narawi, 'Awihu, 'Eriyatsaxi meta 'Itamaxi. 'Ixaheritsixi watsata mɨkɨ mawari wewiwamete mepɨhɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","'A'iwa 'Aruni kamixateya ketineutiwewi mɨpatsietɨka mɨmariwenikɨ 'aixɨa mɨtixeiyariekakɨ. ");
INSERT INTO hch_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Ketinewarutaxatɨa temaiwawemete yanemɨtiwarupitɨa, 'Aruni kamixaya memɨtiwewienikɨ 'ixuriki mɨraye'atɨkakɨ, mɨpaɨ 'ana nemɨtipatakɨ nemawari wewiwame mayanikɨ. ");
INSERT INTO hch_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","»Kemarite pemɨtitiwewieni 'ikɨ pɨtihɨkɨ: kamixa 'etsimɨnena, kuka mekatɨni, kamixa 'emɨtewi, xeime kamixa 'atewime tixukame, hɨiyame meta xupureru. Mɨkɨ kamixate mɨtipatsietɨka 'Aruni pepɨtitiwewirieni meta niwemama nemawari wewiwamete memɨhɨkɨtɨnikɨ. ");
INSERT INTO hch_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Mɨkɨ pemɨtitiwewienikɨ huru pepuyurieni, meta 'ixuriki mɨyɨtsikimaɨye, kwimɨxeta meta mɨxeta metatsiere rinu 'ixurikiyari. ");
INSERT INTO hch_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","»Kamixa 'etsimɨnena pɨtaxuire hurukɨ, hiru mɨyɨtsikimaɨyekɨ, kwimɨxetakɨ, mɨxeta meta rinu 'aixɨa mɨ'anekɨ. ");
INSERT INTO hch_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Naiparieyatsie pawɨtɨkani ya'atayeyeutɨ, mɨkɨkɨ makuwiwierikenikɨ. ");
INSERT INTO hch_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Hɨiyame tixukametsiere, kamixa manuhɨayani, hurukɨ, 'ixuriki mɨyɨtsikimaɨye, kwimɨxeta, mɨxeta, meta rinu 'ixurikiyari 'aixɨa mɨ'ane mɨkɨ naitɨ puyuxewiriyani. ");
INSERT INTO hch_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","»'Unitse teteyari keneutitɨki hutame, mɨkɨtsie keniwara'utɨa 'Ixaheri niwemama tamamata heimana huta memɨyupaɨme ");
INSERT INTO hch_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","kememɨteheukunuiwa, xeime tetetsie me'ataxewime keniwareu'utɨa, meta me'ataxewime xeimetsie. ");
INSERT INTO hch_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Tetexi witsimɨ'anene mɨtixixiwa, katineu'utɨaxɨamɨkɨ tseyu kemɨtiwewiwa hepaɨ: hurutsie piwetsitɨaxɨani, ");
INSERT INTO hch_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","hikɨ kamixa 'etsimɨnena wiwierieyatsie kanekayatsaxɨamɨkɨ. Mɨpaɨ 'ana 'Aruni yunaiparitsie puwara'utɨatɨkani 'Ixaheri niwemama, Yawé mɨwara'eriwanikɨ. ");
INSERT INTO hch_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Keneutiwewita huru 'etsipepeme 'anuyexaxawame mana pemeiyatsaxɨanikɨ, ");
INSERT INTO hch_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","meta hutame huru kaunariyari keneutiwewi, huru meukateitsie mawɨrixɨanikɨ. ");
INSERT INTO hch_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","»Tawitsie mieme kuka heitserie mɨtikuxata, pepitawewieni tixukame hurukɨ, hiru mɨyɨtsikimaɨyekɨ, kwimɨxetakɨ, mɨxetakɨ rinu 'aixɨa mɨ'anekɨ, yaxeikɨa rewewiyakame kamixa 'etsimɨnena hepaɨ. ");
INSERT INTO hch_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","'Ayehutame pepɨyurieni yaxeikɨa heutatetewame, xeitewiyari tsenitimeturuyari 'ayetewime meta xeitewiyari tsenitimeturuyari 'atayeukame. ");
INSERT INTO hch_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Pepeiyatsaxɨani naukakɨa tetexi 'anukutetɨkaime witsimɨ'anene. Mexɨakame mukukatsie keneuyatsaxɨa xetamekɨ, taxaɨyemekɨ meta tsiɨraɨyemekɨ mutimerɨkatɨka, ");
INSERT INTO hch_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","hutariekata, yuawitɨ tsiɨraɨyemekɨ, yuawimekɨ mukutuxie meta tuxamekɨ mutimerɨka, ");
INSERT INTO hch_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","hairieka miemetsieta, merie xetatɨ taxaɨyemekɨ, tuxamekɨ kapemaɨyemekɨ meta mɨyɨtsikimaɨyekɨ, ");
INSERT INTO hch_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","naurieka mukukatsieta, taxaɨyetɨ, kwimɨyɨwi meta tsiɨraɨyemekɨ. Hurutsie hatetɨkaime pepeuyatsaxɨani. ");
INSERT INTO hch_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Tamamata heimana huta pɨpaɨmeni tetexi, xexuitɨ nuiwaritsie puwa'inɨaritɨni. Xexuime tetetsie 'Ixaheri niwemama tamamata heimana huta memɨyupaɨme mepa'utɨkani tseyu hepaɨ. ");
INSERT INTO hch_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","»Hurukɨ kuka wiwieriyari keneutiwewi ya'atayeyeume, mukutapierikeni 'awɨtɨkaime. ");
INSERT INTO hch_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Kukatsie hutame huru hanirayari kenamanaxɨa tapa mutatsikuritɨkatsie. ");
INSERT INTO hch_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Kenawɨtɨaxɨa huru kaunariyari kuka hanirayaritsie. ");
INSERT INTO hch_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Huru kaunariyari muhuta mayexaxawa kamixa 'etsimɨnena naiparieyatsie pepekuwiwitɨaxɨani makatɨrekɨ yɨhɨxie. ");
INSERT INTO hch_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","»Hutameta hanira keneutiwewi, kukatsie hetɨana paitɨ muta'itsikinatɨkatsie kenamanaxɨa kamixa 'etsimɨnenatsie mɨtinakenikɨ. ");
INSERT INTO hch_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Yaxeikɨata hutame huru hanirayari keneutiwewi, kamixa 'etsimɨnenatsie kenamanaxɨa naipari hetɨatsie hɨiyame manukuka heima keneuwipaxɨa. ");
INSERT INTO hch_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Hanira kuka hetsie mamane kamixa 'etsimɨnena hanirayari hamatɨa pɨhɨire 'ixuriki yuawimekɨ, hɨiyame puwatseiriyani kamixa kuka matɨa muyuwiyanikɨ. ");
INSERT INTO hch_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Mɨpaɨ 'Aruni kepauka Muyepatsietsie meutahani yutawitsie pekatɨkɨni, kuka 'aixɨa mɨti'ane mɨtikuxatanikɨ, 'Ixaheri niwemama kememɨtetetewa pɨwara'utɨaka, Yawé muwara'eriwanikɨ. ");
INSERT INTO hch_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Tawitsie mieme kuka heitserie mɨtikuxata, muwa pepeikayatsa 'urimi meta tumimi. Mɨpaɨ kepauka 'Aruni Yawé hɨxie meutahani peixeiyani yutawitsie 'ixaheritsixi wa'inɨari. ");
INSERT INTO hch_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","»'Ixuriki mɨyɨtsikimaɨye pepɨyurieni kamixa 'etsimɨtewi heima mieme, ");
INSERT INTO hch_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","hixɨapa hewatitenime mu'u rewatinakeme. Mewatitenitsie 'atatenime, kamixa 'etsimɨtewi kemɨrewewiya hepaɨ, mɨka'ukatsanikenikɨ. ");
INSERT INTO hch_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","'Ixuriki tenimeyaritsie putuni wita mɨyɨtsikimaɨyekɨ kwimɨxetakɨ, mɨxetakɨ wewiyatɨkaime, meta huru kapanayari 'anayewɨtɨkaime. ");
INSERT INTO hch_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Naime 'ixuriki tenimeyaritsie kapana meta wita putuniyari kenatawɨtɨa. ");
INSERT INTO hch_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Mɨkɨ 'ixuriki 'Aruni penakatɨkɨni kepauka mɨti'uximayaka, kapana mutitiraurɨkanikɨ kepauka Yawé hɨxie Muyepatsietsie mɨyeyeikani, mɨpaɨ mɨkɨ mɨkamɨnikɨ. ");
INSERT INTO hch_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","»Huru tepɨayari keneutawewi 'etsitsuikame 'etsiyeume, hetsiena ketina'utɨa tseyu hepaɨ re'ukame: “Mɨpatsie Yawé Hetsie Mieme”. ");
INSERT INTO hch_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Keneuwipa mukuretsitsie 'ixuriki yɨtsikimaɨyemekɨ, mɨkɨ hɨxiena tikunanakeme. ");
INSERT INTO hch_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Mɨkɨ tepɨa tseyuyari 'Aruni yukanata yakatinemakamɨkɨ, mɨkɨkɨ Yawé naime 'ixaheritsixi wamawari mɨnaki'eriekakɨ, mɨpaɨ 'Aruni 'axamɨti'ane yuhetsie pɨtikuhɨweni kepauka mawari memɨyetuayanitsie. ");
INSERT INTO hch_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","»Kamixa 'amɨtewi meta mukuretsi rinu 'ixurikiyari pepɨyurieni. Hɨiyame pɨ'itseni witsireukuwewiyatɨ. ");
INSERT INTO hch_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","'Aruni niwewema kamixa 'amɨtɨtɨ pekaniwatiwewiriemɨkɨ, kuxira meta mukuretsi, mɨkɨ naitɨ witsipɨti'aneneni 'aixɨa memɨtexeiyariekakɨ. ");
INSERT INTO hch_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Xɨkari pe'itikemaritɨani 'a'iwa 'Aruni meta niwemama, pepɨwakawirieni hatseiti pemɨwahɨritɨani heitserie memexeiyanikɨ mepatsietɨ mete'aitatɨ nemawari wewiwamete memɨhɨkɨtɨnikɨ. ");
INSERT INTO hch_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","»Metatsiere weruxi keniwarutiwewiri 'etɨtɨme wateurite mɨnakakɨ meta memayɨhɨayatsie 'atɨkaime. ");
INSERT INTO hch_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","'Aruni meta niwemama kepauka memeutahaxɨani tukita mɨkɨta mepuyewetɨkani, yatɨni kepauka 'aurawa memɨkɨne 'ɨkwa mawariyari matitaiyarɨwatsie meteta'uximayatake Muyepatsietsie, xɨka mɨpaɨ mekate'uyurieni mekanikwikuni. 'Ikɨ 'aitsika kanihɨkɨtɨni 'Aruni hetsiemieme meta nuiwarimama hetsiena memɨyekɨne. ");
INSERT INTO hch_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","»Pemɨwapatakɨ nemawari wewiwamete memakɨnekɨ nehetsiemieme, mɨpaɨ pekatiniyurimɨkɨ: Xeime tsikeru pekanimiemɨkɨ xeiwiyari hɨkame meta yuhutame muxatsi 'ukitsi 'aixɨa me'anenekame, ");
INSERT INTO hch_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","tɨriku mɨtɨxiyarikɨ paa pepɨtiwewieni meta tsuira tikuxanariyame kanɨkame pɨwiyamatɨkani xeikɨa, yaxeikɨata kɨxau tikuxanariyame kanɨkame pepɨtiwewieni wiyamatɨkaime. ");
INSERT INTO hch_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Tsikɨiwititsie paa kenekamana, tsuira meta kɨxau metatsiere meyuhutame muxatsi 'ukitsi keneneuxatɨa. ");
INSERT INTO hch_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Hikɨ pepɨwaranuwitɨni 'Aruni meta niwemama 'ixuriki tukiyari manuwe hɨxie, mana pepɨwa'ɨya. ");
INSERT INTO hch_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","'Aruni kemarite ketinanakatɨtɨa kamixa 'amɨtewi meta heriemieme kamixa 'etsimɨnena hɨxiena mieme yunɨkame kukayari meta kamixa tixukame. Kuka tawitsie mieme pɨtapierixɨani hɨiyametsie ");
INSERT INTO hch_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","mukuretsi mu'uyatsie kenanukuwiri meta tseyu hamakama mɨpatsie. ");
INSERT INTO hch_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Hatseiti mɨtiyupata keneukawiri mu'uyatsie. ");
INSERT INTO hch_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Hikɨta niwemama keniwarawitɨka kamixa 'amɨtɨtɨ keniwaranakatɨtɨa, ");
INSERT INTO hch_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","meta mukuretsi hetsiemieme, hikɨta 'Aruni meta niwemama wahɨiyamekɨ pepɨwaranahɨaxɨani. Mɨpaɨ pepɨtiwahɨritɨani, meta mawari wewiwamete mɨkɨ nuiwari wahetsiemieme 'aitsika pɨhɨkɨtɨni yuheyemekɨ. ");
INSERT INTO hch_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","»Tsikeru kene'atɨa tuki hɨxie mana 'Aruni meta niwemama mu'uyatsie yumamakɨ memeutimenikɨ, ");
INSERT INTO hch_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","mana Yawé hɨxie pepitimawa tsikeru. ");
INSERT INTO hch_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","'A'itɨwamekɨ xuriyatsie keneme'i mawari taiyame 'awayatsie keneuxurima, muyuhayewata xuriya mawari taiyame hetɨa pepitiyeurieni. ");
INSERT INTO hch_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Nema meta muume muhuta wiyayari mi'eimatɨka keneukaxiteki naime, keneutitaiya mawari taiyametsie, ");
INSERT INTO hch_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","peru tsikeru waiyari, nawiyari meta kwitaya pepititaiya 'ateewa xemakuteitsie, mɨkɨ mawari memɨ'itiyanikɨ pɨhɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","»Xeime muxa 'uki pepɨwahana 'Aruni meta niwemama mu'uyatsie memeutimenikɨ, ");
INSERT INTO hch_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","hikɨ pepitimawa, xuriyayakɨ mawari taiyame pepɨta'ɨya meta nauka 'etsatanayaritsie. ");
INSERT INTO hch_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Muxa keneutixitexɨa, kwinuri petihauxime meta 'ɨkateya, 'etsimɨpepetsie perapime meta muxa mu'uya, ");
INSERT INTO hch_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","muxa naime pekanitataiyamɨkɨ mawari taiyametsie. Mɨkɨ mawari taiyariyari, 'imikieri taipa warɨkariekame kanihɨkɨtɨni, witsimu'ɨa Yawé minake. ");
INSERT INTO hch_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","»Xeime muxa tawari kene'atɨa, 'Aruni meta niwemama mu'uyatsie memeutimenikɨ, ");
INSERT INTO hch_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","hikɨ muxa pekanimiemɨkɨ, 'Aruni nakaya heima 'etsiwa tserietana mieme pekanixurimamɨkɨ yaxeikɨata niwemama, meta wa'itɨwame 'amupapa watserieta miemetsie meta wa'ɨkatsie 'amupapayari watserieta miemetsie. 'Ariketa mawari taiyame xuriyakɨ pekanita'ɨyamɨkɨ meta nauka 'etsatanayaritsie, ");
INSERT INTO hch_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","meta 'etsiwa xuriyakɨ metatsiere 'etsiwa hatseiti mɨtiyupatakɨ, 'Aruni niwemama yunaime keniwaruti'ɨya wakemaritetsie. Mɨpaɨ 'Aruni meta niwemama mepatsietɨ mepakɨne meta wakemarite tipatsietɨ pɨrayani. ");
INSERT INTO hch_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","»'Ikɨ muxa mawari wewiwamete mɨwapatakɨ mɨ'ayumiemekɨ, kwaxieya keneuti'uta, kwinurite wiyayari, nema, muume muhuta, meta teuri tserietana mieme. ");
INSERT INTO hch_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Paa tsikɨiwititsie mɨyemane tikuxanariyame mɨkanɨitɨarie Yawé hɨxie mama, xeime paa pekananati'ɨimɨkɨ meta tsuira mɨwiyama xeimeta mɨkɨxauni, ");
INSERT INTO hch_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","naime 'Aruni meta niwemama ketiniwayetuiri teikɨ memeitserakɨ mawari Yawé hetsiemieme mɨhɨkɨkɨ. ");
INSERT INTO hch_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Mɨkɨ kwitɨwa mepɨmatsiyetuirieni 'ekɨ Yawé hɨxie pemititaiyakɨ mawari taiyametsie mawari taiyariyari witsimu'ɨa yɨnɨkame, 'ikɨ 'imikieri taipa warɨkariekame kanihɨkɨtɨni Yawé hetsiemieme. ");
INSERT INTO hch_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","'Ariketa muxa tawieyatsie mieme wai pekananatituimɨkɨ, mɨ'inɨariyarikɨ 'Aruni kemɨranayexeiyarie nemawari wewiwame mayanikɨ, hikɨ mawari Yawé hɨxie pekaniyuitɨwamɨkɨ, 'ikɨ kani'ayumiemetɨni mawari muyuitɨariwa mɨhɨkɨkɨ. Mɨkɨ muyuhayewa 'ahetsiemieme payani. ");
INSERT INTO hch_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","»Keneuti'uta tsikeru waiyarieya tawitsie mieme mawari muyuitɨariwa mayeitɨarie 'Aruni meta niwemama heitserie memɨpitɨarienikɨ, yaxeikɨata teuri mawari mayeitɨarie, mɨkɨ pɨwahetsiemieme. ");
INSERT INTO hch_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","'Ipaɨ tipaɨmetɨ xehetsiemieme pɨrayeikani kepauka 'ixaheritsixi 'aixɨa memɨteyuxeiya mawariyari memɨwewie Yawé hetsiemieme, mɨkɨ mepɨteyetuiriyarɨwani 'Aruni meta niwemama. ");
INSERT INTO hch_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","»'Aruni kemarieya mɨpatsie 'uxa'atɨniwarie nuiwarimama wahetsiemieme payani, heitserie memexeiyanikɨ mepatsietɨ mete'aitatɨ mawari wewiwamete memɨhɨkɨtɨnikɨ. ");
INSERT INTO hch_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Tsepa ke'anetɨ mawari wewiwame 'Aruni nuiwarieyatɨtɨ netukita munuani muyepatsietsie mɨtita'uximayatakɨ, mɨkɨ kamixate pɨranakatɨkɨni 'atahuta tukari. ");
INSERT INTO hch_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","»Mɨkɨ muxa kɨmana memupatsie, keneuka'etsa xaɨtsie muyepatsietsie. ");
INSERT INTO hch_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","'Ixuriki tukiyari manuwe mɨranutahakitɨretsie, 'Aruni meta niwemama muxa waiyarieya mepɨtikwani meta paa tsikɨiwititsie mɨyemane. ");
INSERT INTO hch_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Mɨkɨ 'imikierikɨ mepɨ'itiyaka, mɨkɨkɨ heitserie memexeiyanikɨ mete'aitatɨ meta mepɨpatsie, mɨkɨ xeikɨa mepɨyɨwaweni memitikwani, xewitɨ tawarita pɨkayɨwe, mawari mɨpatsie mɨhɨkɨkɨ. ");
INSERT INTO hch_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Xɨka 'uyuhayewa muxa waiyarieya meta paa, 'uxa'arieka keneutitaiya. Pɨkayɨweni mɨtikwaiyanikɨ, mɨkɨ mawari mɨpatsie mɨhɨkɨkɨ. ");
INSERT INTO hch_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","»Yaketineuyuri kenematiu'aitɨa 'Aruni hetsiemieme meta niwemama wahetsiemieme. 'Atahuta tukari pepuyurieni mɨkɨ hɨritɨarika pemɨwapitɨanikɨ. ");
INSERT INTO hch_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Xexuime tukaritsie tsikeru xeime peputimawani kɨmana xemɨ'itiyakakɨ. Pɨ'itiyaka mawari taiyame mawari hetsiena mieme pepɨwewieni, hatseiti mɨtiyupatakɨ pepi'ɨya. ");
INSERT INTO hch_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Mɨpaɨ pepɨtiyurieneni 'atahuta tukari. Mɨpaɨ mawari wewiwame meta tita mɨtiyuitɨani 'itiyatɨ payani. ");
INSERT INTO hch_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","»Xexuime tukaritsie pepɨwarutimawani yuhutame muxatsi xeiwiyari memɨhɨtɨka mawari taiyametsie. ");
INSERT INTO hch_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Ximeri kahekɨareyu xeime pekanitimawamɨkɨ, xeimeta taikai. ");
INSERT INTO hch_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Ximeri pemitimawa matɨa, huta kiruyari tɨriku mɨtɨxiyari pepɨtimawa meta huriwa hatseitiyari nɨkame, meta winu xeirituruyari. ");
INSERT INTO hch_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Xeime taikai pemɨtimawa muxa, mɨkɨ mawari taiyariyari payani, witsimu'ɨa Yawé minake meta tinɨkame ximeri timieme hepaɨ. ");
INSERT INTO hch_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","»Xenuiwarima memɨtinunuiwa yaxeikɨa Yawé hetsiemieme mawari taiyariyari mepuwewieka. Netuki 'ixurikiyari manuwe hɨxie xepɨteyurieka, ne 'ahamatɨa mana nemɨrataxatatsie, ");
INSERT INTO hch_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","yaxeikɨa 'ixaheritsixi wahamatɨa nemanetixexeɨriwatsie. Netɨrɨkariya witsimɨ'ane mana katinakupatamɨkɨ. ");
INSERT INTO hch_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","»Patsiekame nekanayeitɨamɨkɨ mɨkɨ tuki 'ixurikiyari meta mawari wewiwame, meta 'Aruni meta niwemama mepatsiekame nekaniwarayeitɨamɨkɨ memɨte'uximayakakɨ nehetsiemieme mawari wewiwametekɨ. ");
INSERT INTO hch_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","'Ixaheritsixi wahamatɨa nekaniuyeikamɨkɨ, wakakaɨyari nepɨhɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","'Ana mɨpaɨ mepɨtehetimani kename ne Yawé nehɨkɨ wakakaɨyari. 'Ekipitu nemɨwarayewitɨ wahamatɨa nemuyeikanikɨ. Ne Yawé xekakaɨyari nekanihɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","»'Ɨkwa taiyame witsimu'ɨa mexayari keneutawewi 'akatsiya kɨyeyarikɨ. ");
INSERT INTO hch_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Yaxeikɨa hatewatɨkaime, huta tewiyari heimana 'auxɨwi tsenitimeturuyari 'ayetewime meta yaxeikɨa mɨpaɨ 'atayeukame meta nauka tewiyari heimana tamamata tsenitimeturuyari 'aweme. 'Awateya naitɨ kaniyuxewiriyakamɨkɨ mɨkɨ mexa matɨa. ");
INSERT INTO hch_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Herie keneukawiri huru hɨkɨame metatsiere naitsarie 'etsatana meta 'awateya, tenimeyaritsie hurukɨ kenata'utɨa. ");
INSERT INTO hch_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Tenimeyari manukaniere hanira kenamanaxɨa naitsata 'etsatana mana kɨyexi meuye'unikɨ mɨkukweiyanenikɨ. ");
INSERT INTO hch_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Kɨyexi 'akatsiya kɨyeyari keneuyuri, huru keneutiwiri. ");
INSERT INTO hch_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","'Ɨkwa witsimu'ɨa mexayari 'ixuriki meuwie hɨxie keneutaketsa kakuni meukunama, kakuni kanamikieya hɨxie, ne mana nepɨmatsikɨhɨaweni. ");
INSERT INTO hch_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","»Mukatatarenitsie 'Aruni, kepauka kɨxeme 'aixɨa mukuyuruwanitsie, 'ɨkwa witsimu'ɨa yakatinikutaiyamɨkɨ 'ɨkwa witsimu'ɨa mexayaritsie, ");
INSERT INTO hch_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","meta taikai kepauka mikutaiyanitsie. Xenuiwarima memɨtixuawere 'ɨkwa witsimu'ɨa yamekateniutitaiyakuni Yawé hetsiemieme. ");
INSERT INTO hch_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Tawarita xeime 'ɨkwa yɨkɨ'aneme pepɨkataiyani mɨkɨ 'ɨkwa witsimu'ɨa mexayaritsie, meta mana mawari taiyariyari pepɨkakuwewiwani, meta hatsite mawarikayari meta mana winu pepɨkaheutitu'ani. ");
INSERT INTO hch_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Xeiwiyari 'anukayeikakaku 'Aruni 'itiya mawariyari pukuwewiwani memɨtinunuiwa wahetsiemieme memɨ'itiyanikɨ. Mawari taiyame 'awateya kanitixurimamɨkɨ 'axamɨtiuyuri mɨ'itiyanikɨ. Mɨkɨ mawari taiyame yuheyemekɨ patsietɨ kanayeimɨkɨ Yawé hetsiemieme». ");
INSERT INTO hch_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Yawé Muitsexi katiniutaxatɨani mɨpaɨ katinitahɨawe: ");
INSERT INTO hch_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","«Kepauka memaka'utɨarieni 'ixaheritsixi, yuxexuitɨ Yawé hetsɨa mekateniyutuakuni yutukaritsiemieme, memɨkatetikwikwinenikɨ kepauka memɨti'inɨatsieni. ");
INSERT INTO hch_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Yuxexuitɨ memaka'utsie mekateniyutuakuni Yawé hetsiemieme 'ataxewime kɨramuyari pɨrata, tuki kemɨti'inɨata hixɨapa 'akame. ");
INSERT INTO hch_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Yunaitɨ memaka'utsieni xeitewiyari wiyari memɨhɨtɨka mɨkɨ mawari mekaniyetuakuni Yawé hetsiemieme. ");
INSERT INTO hch_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Yutukari memɨtawikweitsitɨanikɨ, yunaitɨ yaxeikɨa paɨpaɨmeme mekaniyetuaxɨakuni, waɨkawa mɨrexeiya meta mɨkarexeiya. ");
INSERT INTO hch_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","'Ekɨ mɨkɨ pɨrata pekananɨ'ɨimɨkɨ 'ixaheritsixi memiyetuani, pekaniyetuamɨkɨ 'ixuriki tukiyari hetsiemieme mayanikɨ. Mɨpaɨ xɨka xete'uyurieni Yawé 'ixaheritsixi kɨmana memɨte'uyutua kanixeiyakamɨkɨ memɨkakwinikɨ». ");
INSERT INTO hch_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Yawé Muitsexi katiniutaxatɨani, mɨpaɨ katinitahɨawe: ");
INSERT INTO hch_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","«Katsu maimawame keneutawewi 'ayeume wurunitse tepɨayarikɨ, meta 'ɨkayari yaxeikɨa wurunitsekɨ wewiyakame, 'ixuriki tukiyari manuwe meta mawari taiyame wahixɨapa keneutaketsa. Haa kenakatu'a, ");
INSERT INTO hch_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","kɨmana 'Aruni meta niwemama mekaniukamaimawakuni meta yɨ'ɨkate mekanitihauxinakuni. ");
INSERT INTO hch_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Kepauka memeutahaxɨani tukita, yatɨni kepauka mɨratimawatɨre hepa memukɨne taiyarika mawariyari Yawé hetsiemieme mewewienike, mana meheuyuhauxinatɨ ");
INSERT INTO hch_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","yumamatetsie meta yɨ'ɨkatetsie memɨkakukuwenikɨ. 'Ikɨ 'aitsika hawaikɨ pɨkahau'axe 'Aruni hetsiemieme meta nuiwarimama wahetsie». ");
INSERT INTO hch_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Yawé Muitsexi katiniutaxatɨani, mɨpaɨ katinitahɨawe: ");
INSERT INTO hch_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","«Naime 'ikɨ ketineukuxeɨri witsimɨtiu'ɨatɨka 'aixɨa mɨti'anene: 'ataxewime kiruyari mixaxi mɨhaxiki, haika kiruyari witsimu'ɨa kanera, haika kiruyari 'uwá witsimu'ɨa, ");
INSERT INTO hch_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","'ataxewime kiruyari katsiya kararayari witsimu'ɨa, nauka rituruyari huriwa hatseitiyari, kemɨti'inɨarikai tukita 'ana. ");
INSERT INTO hch_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Mɨpaɨ tipaɨmemekɨ hatseiti pekanikawewimɨkɨ, witsimɨtiu'ɨatɨka tiwewiwame hepaɨ. Mɨkɨ hatseiti mɨpatsie kanayeimɨkɨ. ");
INSERT INTO hch_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Mɨkɨkɨ 'ixuriki tukiyari pekanikawirimɨkɨ meta tɨratu kakuniyari, ");
INSERT INTO hch_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","mexa meta naime mana mɨrapine, kɨxeme 'uitɨwame meta naime tita mɨreutinɨ'ɨ, 'ɨkwa witsimu'ɨa mexayari, ");
INSERT INTO hch_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","mawari taiyariyari wewiwame naime tita mɨreutinɨ'ɨ, meta maimawame yaxeikɨata 'ɨkaya hetsiena muyema. ");
INSERT INTO hch_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Mɨpaɨ petiyurieme mɨkɨ yemekɨ tipatsietɨ katinayeimɨkɨ, xɨka mɨkɨ piinite tiukumayuani patsietɨta kanayeimɨkɨ. ");
INSERT INTO hch_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","»'Aruni meta niwemama keniwarukawiri, mepatsiekame keniwarayeitɨa nemawari wewiwamete memɨhɨkɨtɨnikɨ. ");
INSERT INTO hch_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","'Ixaheritsixi mɨpaɨ pekatiniwatahɨawimɨkɨ: “'Ena mɨreutiyune, 'ikɨ nehatseiti mɨpatsie kanihɨkɨtɨkamɨkɨ. ");
INSERT INTO hch_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Hipameta teɨteri xepɨkawakawiriwani, meta hatseiti hepaɨna reukuwewiyakame xepɨkawewieka. Mɨkɨ hatseiti mɨpatsie kanihɨkɨtɨni, mɨpaɨ xeketenemaika. ");
INSERT INTO hch_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Kemɨ'ane xeme hepaɨna 'aneme witsimu'ɨa mɨkawewieni, xeime kemɨ'ane mɨkamawari wewiwame mɨkawirieni, mɨkɨ yukiekaritsie kanayeweiyariemɨkɨ”». ");
INSERT INTO hch_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Yawé Muitsexi mɨpaɨ katiniutahɨawe: «Yaxeikɨa tipapaɨmeme ketineukuxeɨri hipame kɨyexi tsuayari, meta 'amɨwaxi, kariwanu meta 'ɨkwa hɨkɨa, ");
INSERT INTO hch_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","mɨkɨ naime ketineunɨitɨa 'ɨkwa witsimuku'ɨare mayanikɨ, 'ɨkwa witsimu'ɨa wewiwamete wahepaɨ. 'Una kenanutiwiwi, 'ɨkwa hɨkɨa mɨpatsie mɨhɨkɨtɨnikɨ. ");
INSERT INTO hch_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Yapaɨmeme keneutɨxi tumuanime kenayeitɨa, 'ixuriki tukiyarita kakuni hɨxie kenamana, hakewa ne 'ahamatɨa nemɨretixaxatani. Mɨkɨ xehetsiemieme 'ɨkwa witsimu'ɨa yemekɨ pɨpatsieka, ");
INSERT INTO hch_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","tawarita hepaɨna reukuwewiyatɨ pɨkayuwewieneni, mɨkɨ Yawé hetsiemieme kanihɨkɨtɨni. Xeme mɨpaɨ xeketenemaika patsiekame xekenayeitɨaka. ");
INSERT INTO hch_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Kemɨ'ane mɨkɨ 'ɨkwa witsimu'ɨa mɨkawewieni 'i'ɨkwimɨtɨ, mɨkɨ yukiekaritsie kanayeweiyariemɨkɨ». ");
INSERT INTO hch_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Yawé Muitsexi katiniutaxatɨani mɨpaɨ katinitahɨawe: ");
INSERT INTO hch_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","«Mɨpaɨ ketinemaika Wetsareri nepanayexei, 'Urihi nu'aya meta Kuxi teukarieya, Kura xiɨyarieya, ");
INSERT INTO hch_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","nekanihɨniyani Kakaɨyari 'Iyarieyakɨ, mɨtimaiwenikɨ, mɨtimatenikɨ, kemɨtiuyurieni kaniyɨweni, ");
INSERT INTO hch_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","waɨkawa mɨtiwewiwenikɨ hurukɨ, pɨratakɨ meta wurunitsekɨ, ");
INSERT INTO hch_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","tetexi witsimɨ'anene mɨxitewenikɨ, meta meitayatsawenikɨ, kɨyexi haruruanime mɨtiwewiwanikɨ, naime mɨtitiwewiwanikɨ tita mɨtimate. ");
INSERT INTO hch_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","»Meta xeime 'iparewiwame nepanayexei 'Ahurihawi mɨtitewa 'Akitsamaki nu'aya, Rani xiɨyarieya, meta nepɨwarupitɨa memɨtematenikɨ yunaime tewewiwamete yemekɨ yamemɨteyurienikɨ kenemɨmatiuta'aitɨa: ");
INSERT INTO hch_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","tuki 'ixurikiyari, tɨratu kakuniyari, meta kanamikiyari, meta tukita naitɨ piinite mɨtiyukumayuani, ");
INSERT INTO hch_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","mexa meta xakɨrɨte meta kɨxeme 'uitɨwame hurukɨ wewiyakame, meta 'ɨkwa witsimu'ɨa mexayari, ");
INSERT INTO hch_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","meta mawari taiyariyari matiwewiwa meta ketipaɨmetɨ muwa mɨtiyukumaɨwa, yaxeikɨa maimawame meta 'ɨkaya, ");
INSERT INTO hch_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","kemarite mɨ'itsarietɨka, meta 'Aruni kamixateya mɨtipatsietɨka metatsiere niwemama wakemarite, ");
INSERT INTO hch_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","meta hatseiti memɨwakawiriwa meta 'ɨkwa witsimu'ɨa Muyepatsietsie mieme. »Naime mepɨtetiwewieni ne kenematiuta'aitɨa». ");
INSERT INTO hch_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Yawé Muitsexi mɨpaɨ katiniuta'aitɨani: ");
INSERT INTO hch_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","«Mɨpaɨ 'ixaheritsixi ketiniwarutahɨawi: “Xekena'eriwani xawati 'uxipiya tukaritsie. Nuiwarite memahu wahetsiemieme, xawati tukari 'inɨari pɨhɨkɨtɨni nehetsiemieme meta xehetsiemieme, mɨpaɨ xemɨtemaikakɨ ne Yawé nemenayexei mɨkɨ tukaritsie xemɨnetsihahɨawenikɨ. ");
INSERT INTO hch_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","»”Xawati tukariyari pɨpatsieka xehetsiemieme. Xekena'eriwani. »”Kemɨ'ane mɨkaha'eriwani ke'umierieni. »”Kemɨ'ane mɨti'uximayaka 'ana, tahamatɨa pɨka'uyeikani. ");
INSERT INTO hch_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","»”'Ataxewi tukari xepɨte'uximayaka, peru xawati 'uxipiya pɨhɨkɨtɨni pɨpatsieka Yawé hetsiemieme. »”Xewitɨ xɨka ti'uximayaka xawatikɨ ke'umierieni”. ");
INSERT INTO hch_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","»'Ixaheritsixi mekehe'eriwani xawati 'uxipiya tukari. Wanuiwarite wahetsiemieme tɨratu yuheyemekɨ kanayeimɨkɨ, ");
INSERT INTO hch_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","'inɨari yamɨreuyuhane pɨhɨkɨtɨni mɨkɨ meta ne. »Kaniyuritɨni, 'ataxewi tukari Yawé katiniutawewieni, muyuawi taheima mieme meta kwie, 'atahutarieka tukaritsie puka'uxipi». ");
INSERT INTO hch_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Kepauka mɨtiutahayewaxɨ tikuxatatɨ Tsinahi hɨriyaritsie Muitsexi matɨa, hutame tetexi pi'ɨitɨa 'inɨari niukiyari maye'uxa pɨhɨkɨtɨkai Kakaɨyari mɨraka'utɨa mana yumamakɨ. ");
INSERT INTO hch_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Merikɨtsɨ Muitsexi 'ekatineutewikaitɨni kanuawetɨ Tsinahi hɨriyaritsie heyeikatɨ, hikɨ 'Aruni hɨxie 'ixaheritsixi me'u'axɨaka mɨpaɨ mekatenitahɨawe: —Peuyewetse kakaɨyarixi pemɨtatsitiwewirieni memɨtatsi'uwitɨximenikɨ, Muitsexi 'Ekipitu mɨtatsi'ayewitɨ, 'atsitepɨkatemate kemeyɨ kemɨreyɨnixɨ. ");
INSERT INTO hch_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","'Aruni mɨpaɨ katiniwaruta'eiya: —Huru nakɨtsayari xekeniwarutawawiri yu'ɨitama, yuniwema 'ukitsi meta 'ukari, nehetsɨa xekene'atɨa. ");
INSERT INTO hch_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Yunaitɨ 'ixaheritsixi huru nakɨtsayari memexeiyakai, menenuyexɨnaxɨani 'Aruni mekaniyetuirieni, ");
INSERT INTO hch_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","huru hanutɨkɨka kanitikwaniya, 'ipɨnaka kakaɨyari kaniutawewieni, tsikeru hepaɨ 'aneme. Hikɨ yunaitɨ teɨteri mɨpaɨ mekaniutiyuani: «'Ixaheri, 'ikɨ 'akakaɨyari kanihɨkɨtɨni 'Ekipitu mɨmatsi'ayewitɨ». ");
INSERT INTO hch_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","'Aruni 'ixeiyatɨ tuuru, mawari taiyame kaniutawewieni tsikeru hɨxie, hikɨ mɨpaɨ kaniutayɨni: —'Uxa'a 'ixɨarari tekaniwewikuni Yawé hetsiemieme. ");
INSERT INTO hch_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","'Uxa'arieka ximeripaitɨ 'ixaheritsixi mekananuku'uni mekateni'atɨani mawari taiyariyari meta kename 'aixɨa memɨteyuxeiyanikɨ mawariyari. Hikɨ yunaitɨ mekananukayaxe mekateniukwani mekaniuti'ieni, kemɨtiwanake mekaniyɨakaitɨni. ");
INSERT INTO hch_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Merikɨtsɨ Yawé Muitsexi mɨpaɨ katiniutahɨawe: —Xeiya kenanukaye'a teɨteri 'Ekipitu pemɨwarayewitɨ 'axamepɨteyurie. ");
INSERT INTO hch_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Yapauka mepeuyexɨri huye mepuku'eiri, kenemɨtiwaruhɨritɨa, huru me'ukwaniyaka yukakaɨyari xeikɨa mepɨka'utawewi tsikeru hepaɨ 'anekame, matsi hɨxienata mepukatunuma'ui, mawari mepiwewiri, meta mɨpaɨ meputiyua: “'Ixaheri, 'ena 'akakaɨyari 'Ekipitu mɨmatsi'ayewitɨ”. ");
INSERT INTO hch_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Yawé tawarita Muitsexi mɨpaɨ katiniutahɨawe: —'Ari nepɨretima 'ikɨ teɨteri mepɨtsetse'i. ");
INSERT INTO hch_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","'Ekɨ wahetsie pepɨkanuaka. Nehaxɨa nepɨtatuani wahetsie, nepɨwakwini yunaime. Peru 'ahetsie nuiwari nepɨwatamɨiriya. ");
INSERT INTO hch_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Muitsexi Yawé yukakaɨyari kaninɨtɨamɨkɨkaitɨni mɨpaɨ katinitawawirieni: —Neuxei Yawé, ¿'ateɨterima wahepaɨtsita pepɨkaha'aka, pemɨwarayewitɨ 'Ekipitu 'atɨrɨkariyakɨ waɨkawa petiyurienetɨ? ");
INSERT INTO hch_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","¿Mɨpaɨ memɨka'utiyuanenikɨ 'ekipitutari, kari mɨkɨ pɨwarayewitɨ wakwimɨtɨ yeuta paitɨ, 'ena kwiepa memeuyewenikɨ? Pepɨkaha'aka ketineunewi. Keneuyɨnɨtɨa, 'ateɨterima wahetsiemieme 'axapepɨkatiyurieneni. ");
INSERT INTO hch_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Keniwara'eriwani kepemɨtiwarutahɨawixɨ, 'Apɨrahami, 'Itsahaki, 'Ixaheri meta. 'Ekɨ mɨpaɨ peputayɨ kename wanuiwari pewatamɨiriyakekai, kememɨteyuxexeiya xurawetsixi muyuawitsie, 'ekɨ pepɨwaruxatɨa kwie wanuiwari wahetsiemieme mayanikɨ yuheyemekɨ. ");
INSERT INTO hch_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Hikɨ Yawé kaniuhaxɨapieni, katiniuhayewa yuteɨterima kemɨwayurienikekai. ");
INSERT INTO hch_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Merikɨtsɨ Muitsexi kaninuani hɨritsie 'akaneka. Kepauka munua tetexi kana'ɨkaitɨni hutame wewerime, mɨkɨtsie 'inɨari niukiyari kana'utɨkateitɨni naitsata. ");
INSERT INTO hch_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Mɨkɨ tetexi meta mɨra'utɨkatei, Kakaɨyari wewiyaya kanihɨkɨtɨkaitɨni. ");
INSERT INTO hch_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Kutsuhexi kepauka teɨteri wahiwari mu'eni, Muitsexi mɨpaɨ katiniutahɨawe: —Tematiteitsie hiwari waɨkawa pexuawe pɨreyukwine. ");
INSERT INTO hch_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Peru Muitsexi mɨpaɨ katinitahɨawe: «Kepemɨti'ena memɨtehayu'iwarɨmekɨ mepɨkatehehiwa, meta meha'iwarietɨ mehetitsuatɨ mepɨkatehehiwa, matsi pɨta kwikari pekatiniu'enieni». ");
INSERT INTO hch_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Kepauka Muitsexi hɨritsie 'akaneka munua mematiteitsie meta kepauka tsikeru muxei meta teye'amete, kaniuyeha'ani waɨkawa, mɨkɨ tetexi ma'ɨkai kaneixɨrieni, kaniutitare 'etsipepetɨ kaneutaxɨriexɨani hɨritɨa. ");
INSERT INTO hch_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Hikɨ tsikeru memutawewiekai taipa kaneuhɨani, 'ariketa 'itataraka temɨxikiyari 'uhatuiyaka kaniwaruharitɨani 'ixaheritsixi teɨteriyari. ");
INSERT INTO hch_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Meta 'Aruni mɨpaɨ katiniutahɨawe: —¿Kememate'utahɨawixɨ 'ikɨ teteɨteri? ¿Ketitayari teɨteri petiwarupitɨa 'axamemɨteyurienikɨ? ");
INSERT INTO hch_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","'Aruni mɨpaɨ katinita'eiya: —Neuxei ne'iwa, pepɨkaha'aka, 'ekɨ pekatinimaika 'ikɨ teɨteri 'axamepɨte'u'iyari xeikɨa. ");
INSERT INTO hch_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Mɨkɨ mɨpaɨ mekaneteniutahɨawe: “Peuyewetse kakaɨyarixi pemɨtatsitiwewirieni memɨtatsi'uwitɨximenikɨ, Muitsexi 'Ekipitu mɨtatsi'ayewitɨ, 'atsitepɨkatemate kemeyɨ kemɨreyunixɨ”. ");
INSERT INTO hch_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Ne mɨpaɨ nepɨtiwarutahɨawixɨ, yunaitɨ kemɨ'ane huru xemexeiya xekeneukuxeɨri. Mɨkɨ mekaneni'atɨirieni, neta taipa nekaneixɨrieni, hikɨ mɨkɨ tsikeru hepaɨ 'anetɨ kanayani. ");
INSERT INTO hch_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Hikɨ Muitsexi 'ixaheritsixi teɨteriyari wamaitɨ ke'axamemɨteku'eriwakai pɨta, meta 'Aruni kemɨtiwarupitɨakai 'atsieriwamete memakɨnekɨ memɨwaraye'unie wahetsiemieme, ");
INSERT INTO hch_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","hikɨ memakutei kitenie 'utakeka mɨpaɨ kaniutayɨni: «Keyupaɨmetɨ xemɨyuwaɨriya Yawé hetsiemieme, nehetsɨa xekenakɨni». Yunaitɨ rewitsixi mekaniukɨne hetsɨana. ");
INSERT INTO hch_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Merikɨtsɨ Muitsexi mɨpaɨ katiniwarutahɨawe: «Yawé, 'Ixaheri Kakaɨyarieya, mɨpaɨ katina'aitani: “Yuxexuitɨ yukutsira xekeneukuha'aritɨaka xekeneukakɨni naitsarie 'ena xematiteitsie, kemɨ'ane xemanukunake xewatakukuyatɨ tsepa mɨxe'iwa, mɨxehamiku, tsepa xe'aurie kiekame”». ");
INSERT INTO hch_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Muitsexi kemɨtiwaruta'aitɨa mɨkɨ rewitsixi mɨpaɨ mekatenikakɨne, mɨkɨ tukaritsie haika miriyari 'ixaheritsixi mekaniwarukwini. ");
INSERT INTO hch_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Hikɨ Muitsexi mɨpaɨ kaniutayɨni: «Hikɨ xeme tɨrɨkariya xekaniupitɨarieni Yawé hetsiemieme, 'ikɨ tukaritsie 'aixɨa xekaniu'itɨarieni xeme, yu'iwama meta yuniwema xemɨwarukwi». ");
INSERT INTO hch_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","'Uxa'arieka tukaritsie, Muitsexi mɨpaɨ katiniwarutahɨawe 'ixaheritsixi teɨteriyari: «Xemetsɨ kwinimieme 'axaxekateniuyurieni. Peru hikɨ hɨritsie nekanimieni Yawé nemetahɨawekɨ, heiwatɨ xereuyehɨwirieni Kakaɨyari ke'axaxemɨte'uyuri». ");
INSERT INTO hch_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Hikɨ Muitsexi heyaka Yawé mɨpaɨ katinetahɨawe: —Waɨkawamekɨ 'axamepɨte'uyuri 'ikɨ teɨteri, huru kakaɨyarixiyari mewarutiwewieka. ");
INSERT INTO hch_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Peru, nepɨmatsiwawirie wahetsiemieme pemɨtiwareuyehɨwirienikɨ 'axakememɨte'uyuri. Peru xɨka 'ekɨ pekatiwareuyehɨwirieni, neta kenenakayeitɨa 'axapatsie pemɨraka'utuatsie. ");
INSERT INTO hch_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Yawé Muitsexi mɨpaɨ katiniuta'eiya: —Ne nekanekayeitɨamɨkɨ nexapatsie, kemɨ'ane xeikɨa 'axamɨtiuyuri. ");
INSERT INTO hch_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","'Ekɨ kenemie, keniwaranuwitɨki 'ikɨ teɨteri hakewa nematsihetaxatɨa. Niuki tuayame 'ahɨxie kaniumiemɨkɨ. Tukari kanaye'amɨkɨ kepauka nemɨwa'uximatɨani 'axamemɨte'uyurikɨ, 'ana mɨpaɨ pɨtiyɨni. ");
INSERT INTO hch_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Mɨpaɨ katiniɨyɨni, tsikeru 'Aruni mutawewikɨ, Yawé kwiniya kaniwareyenɨ'airieni teɨteri 'ixaheritsixi wahetsie. ");
INSERT INTO hch_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Merikɨtsɨ Yawé Muitsexi mɨpaɨ katiniutahɨawe: «Xekeneuhuni 'ekɨ meta teɨteri 'Ekipitu pemɨwareyewitɨ, mɨkɨ kwieyaritsie nemɨwaruhɨritɨa, 'Apɨrahami, 'Itsahaki, Kakuwu newaxatɨatɨ, yunuiwarima xemɨwayetuirienikɨ. ");
INSERT INTO hch_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Niuki tuayame nepanunɨ'ani 'ahɨxie 'anuyekaitɨ mumienikɨ, nepɨwataweiya mɨkɨ kananeutsixi, 'amuxeutsixi, hetitsixi, peretseutsixi, heweutsixi meta kewutseutsixi. ");
INSERT INTO hch_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Xekaniyehuni mɨkɨ kwieyaritsie mana waɨkawa kanexuaweni retsi meta xiete. Ne xehamatɨa nepɨkayemie, xɨka xehamatɨa neheyani, huyeta nekanixehekwiweni, xemɨkaheu'enanakɨ». ");
INSERT INTO hch_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Hikɨ 'ixaheritsixi mɨkɨ niuki me'u'enieka mekaniutitsuani mekaniyukahiwerieni waɨkawa, yukuka mepɨka'atitɨxɨa 'anatɨtɨ, ");
INSERT INTO hch_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Yawé mɨpaɨ Muitsexi mɨtiutahɨawekaikɨ: «Mɨpaɨ ketiniwaretahɨawi 'ixaheritsixi, teɨteri memɨkaheu'enana mepɨhɨkɨ. Xɨka 'etsiwa wahamatɨa neheyani, nekaniwarekwiweni. Mɨpaɨ ketiniwaretahɨawi yukuka meke'atixɨnaxɨani, 'arike yapɨtayɨni kexemiyurieni». ");
INSERT INTO hch_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","'Ayumieme, kepauka Huré 'ixaheritsixi memɨyekɨtsietɨtɨ yukukate mepɨkatehatitɨxɨa. ");
INSERT INTO hch_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Merikɨtsɨ Muitsexi 'ixuriki kiiyari kaniutawewieni mematiteitsie yateewa. «'Ixuriki kiiyari Yawé hamatɨa tixaxatame» katiniterɨwa. Kepauka xewitɨ Yawé hamatɨa mɨreuxatamɨkɨni, mɨkɨ payeyeikakai mematiteitsie mɨkɨ xamaru manuwe pɨye'ani. ");
INSERT INTO hch_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Kepauka Muitsexi xamaru hepa meyeikakai, yunaitɨ teɨteri yukitenie mekaniti'uwekaitɨni me'ixeiyake, kepaukake 'ixuriki kiiyarita meutahakekai mɨrewatixaxatatsie. ");
INSERT INTO hch_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Kepauka Muitsexi meutahani, hai 'amuwe nakatetekekaitɨni kitenie katineunarɨmakaitɨni, kepauka Yawé Muitsexi hamatɨa mɨtikuxatani. ");
INSERT INTO hch_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Kepauka 'ixaheritsixi haiwitɨri memɨxeiya xamaru tixaxatame kiiyari kitenie 'uweme, 'ana yunaitɨ mekaniukatunuma'uwekaitɨni yukitenie Yawé nenewieri me'ipitɨatɨ. ");
INSERT INTO hch_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Yawé pɨtiutixaxatakai Muitsexi hamatɨa yuhɨxie me'utinenieretɨ, xewitɨ yuhamiku hamatɨa mɨtikuxatani hepaɨ. Metetixatameri Muitsexi kanewayeyeikakaitɨni, 'iwamama memakuteitsie kani'axekaitɨni, perutsɨ temaikɨ Kutsuhexi 'iparewiwameya 'ixuriki kiiyari tixaxatame muwa pɨkawayeyeikakai pɨka'iku'e'eiriwakai. ");
INSERT INTO hch_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Muitsexi Yawé mɨpaɨ katiniutahɨawe: —'Ekɨ peyutemawietɨ pepɨnetikɨhɨawe kename newarayewitɨni 'ikɨ teɨteri, perutsɨ 'atsipepɨkanerahɨawe kemɨ'ane pepanunɨ'ani nehamatɨa. Mɨpaɨta peputaine kename ne 'ahamiku nehɨkɨ meta kename penetsiparewiwame. ");
INSERT INTO hch_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Xɨka yurikɨ mɨpaɨ 'aneni, yakenetineutahɨawi kenemɨtiyurieni. Mɨpaɨ 'ana nepɨretimani kename penetsiparewiwame. Mɨpaɨ ketinemaika kename 'ixaheritsixi me'ateɨterima. ");
INSERT INTO hch_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Yawé mɨpaɨ kaniutayɨni: —Ne 'ahamatɨa nepɨyemie meta nepɨmatsika'uxipitɨani. ");
INSERT INTO hch_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Muitsexi mɨpaɨ katinitahɨawe: —Xɨka teyunaime tahamatɨa pekayemieni, ¿titayari tsɨkamɨ petarenɨ'awani? ");
INSERT INTO hch_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Xɨka tahamatɨa pekaheyani, ¿'ateɨterima meta ne kemetehetimani, kename petatsiparewie? ¿Ketitakɨ tetepatsieka hipame teɨteri kwiepa memɨtama watsata? ");
INSERT INTO hch_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Yawé mɨpaɨ Muitsexi katiniutahɨawe: —'Aixɨa pɨ'ane mɨpaɨ nepɨtiyurieni kepemaine, 'ekɨ pepɨnetsiparewiwame meta pepɨnehamiku. ");
INSERT INTO hch_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Muitsexi tawarita mɨpaɨ katinitahɨawe: —Keneneuxeiyatsitɨa kepemɨtixawatɨ. ");
INSERT INTO hch_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Yawé mɨpaɨ katinita'eiya: —Ne 'aixɨa nepɨtiuka'iyari nepɨnewaɨriya nepɨmatsixeitsitɨani meta kenemɨtitewa pepeitimani. 'Aixɨa nepɨtiuka'iyari kemɨ'ane hamatɨa nemɨnewaɨriya, nepinenimaya kemɨ'ane nemeunenimayatamɨkɨ. ");
INSERT INTO hch_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Perutsɨ mɨpaɨ nepɨmatitahɨawe pepɨkanetsixeiya kenemɨraka'erie, xewitɨ pɨkayɨwe mɨnetsixeiya, xɨka netsi'uxeiya kaniumɨmɨkɨ. ");
INSERT INTO hch_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Yawé mɨpaɨ katinitahɨawe: —Yateewa tete pɨkaka wayexawatɨ mɨkɨta pepayekani. ");
INSERT INTO hch_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Kepauka 'a'aurie nemuyeyani waɨkawa nexawatɨtɨ, muwa terɨtɨa pe'ayekaime nemamakɨ nepɨmatsiheutinaka, kepaukake nemanuyeyani. ");
INSERT INTO hch_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","'Anake nepɨmatsiheukuyepieni pemɨnetsi'anaxeiyakɨ xeikɨa 'etsiwa, peru nehɨxie pepɨkanetsixeiya. ");
INSERT INTO hch_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Merikɨtsɨ Yawé Muitsexi mɨpaɨ katiniutahɨawe: «Hutame tetexi wewerime keneutixixi matɨari kemɨ'anenekai pemititaraxɨ. Mana nepɨraka'utɨani meripaitɨ kemɨre'ukai. ");
INSERT INTO hch_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Ximeripaitɨ pepɨ'akuha'aritɨani pemɨyemiekɨ hɨritsiepai Tsinahi, manutitewatsiepai mana nehɨxie kenenua. ");
INSERT INTO hch_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Xewitɨ 'ahamatɨa pɨkaheyeikani, yaxeikɨata hɨritsie mepɨka'u'uwani. Meta muxatsi mepɨkatewaremitɨweni meta wakaitsixi mɨkɨ hɨri hɨxie 'ahurawa». ");
INSERT INTO hch_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Hikɨ Muitsexi hutame tetexi 'utiwewieka 'etsitsutsuime meripaimieme kemɨ'anenekai hepaɨ, kwi ximeripaitɨ kaneyani hɨritsiepai Tsinahi, Yawé kemɨtitahɨawixɨ. ");
INSERT INTO hch_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Hikɨ Yawé haiwitɨritsie kananukateni Muitsexi 'aurie kaniyuhayewa. Kemɨtitewa katinitaxatɨani: ");
INSERT INTO hch_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","hɨxiena 'uyemietɨ mɨpaɨ kaniutayɨni: —Yawé, Yawé, Kakaɨyari 'aixɨa mɨtiuka'iyari, nepɨkayumexɨitɨa nemɨyeha'anikɨ, pɨmariwe nenaki'eriya, ne'iyarikɨ 'aixɨa nepɨtiuka'iyari, ");
INSERT INTO hch_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","nepɨtiuyukanaki'erie 'atsita xeimiriyari nuiwariyaritsiepai 'arike, nepɨyɨweta xeime nemɨreuyehɨwirienikɨ xɨka 'axatiuyurieni, xɨka kahau'enani, meta xɨka xurikime hexeiyani, peru nepɨkayɨwe nemihayewa kemɨ'ane mɨrapine nemɨkatikwinitɨanikɨ, matsi paapaya, nu'aya, teukarieya, meta tutsieya nuiwariyaya pɨwa'uximatɨwa. ");
INSERT INTO hch_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Hikɨ 'ana kwitɨwa Muitsexi kaniukahɨximakeni yutanenewienike, ");
INSERT INTO hch_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","mɨpaɨ katiniuyunenewieni: —Ti'aitame, xɨka yemekɨ penetsiparewiwametɨni tahamatɨa keneuyuhayewa. Nepɨtimate 'ikɨ teɨteri yu'iyaritsie mepɨtsetse'i, hikɨ ketatineuyehɨwiri 'axatemɨte'uyurikɨ, 'ahetsɨa miemete ketanayeitɨa. ");
INSERT INTO hch_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Yawé mɨpaɨ katinita'eiya: —Tsiparatsɨ tɨratu xeyunaime xehamatɨa nepɨwewieni, 'ixaheritsixi wahɨxie mariweme nepɨtiyurieni, hatsuaku hawaikɨ mɨkareyɨwe hepaɨ. Teɨteri mepɨneniere wahamatɨa pemuyeika 'ahetsie mariweme ne Yawé yanemɨtiyurieni. ");
INSERT INTO hch_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Xɨka xeme yaxetekahuni kenemɨtixe'utahɨawixɨ, xɨka yaxetekakɨne. Nepɨwataweiya 'ahɨxie 'amuxeutsixi, kananeutsixi, hetitsixi, peretseutsixi, heweutsixi meta kewutseutsixi. ");
INSERT INTO hch_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Xeme hakewa kwie nemɨxeyetuirieni mana tɨratu xepɨkawewietɨweni hipame teɨteri mana kiekatari wahamatɨa xematiyaxetsie, mexɨka mɨpaɨ xete'uyurieni xewiniyari ke'ayani xehetsiemieme. ");
INSERT INTO hch_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Hakewa mawari mematiwewiwatɨkatsie xekeneuti'unaxɨa, 'Atserá kakaɨyarixiyari xekeniwarutitara meta tetexi mɨpatsietɨka memɨwarayexeiya. ");
INSERT INTO hch_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Hipame kakaɨyarixi pepɨkawarayexeiyani, ne Yawé nekani'ɨtetsaka. Kakaɨyari mɨ'ɨtetsa katinitewaka. ");
INSERT INTO hch_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","»Tɨratu xepɨkawewieka mana kiekatari wahamatɨa, mɨkɨ 'axamekateniyurieka yukakaɨyarixi mewarayexeiyatɨ, kepauka memɨtetimawa yukakaɨyarixi wahetsiemieme, mɨkɨ mekanixeti'inietɨkɨnikuni yuhetsɨa. ");
INSERT INTO hch_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Xɨka xeniwema mewarutiwitɨni mɨkɨ 'ukari, kepauka mɨkɨ 'axamɨtiyurieni yukakaɨyarixi waruweiyatɨ, xeniwema mepɨta'inierieni wahepaɨ memɨyɨakakɨ. ");
INSERT INTO hch_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","»Tepɨa kakaɨyariyari pepɨka'awewirieka. ");
INSERT INTO hch_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","»Paa mɨkakuxanariyarie 'ixɨarariyari xekeneutiwewiwani, mɨkɨ xekeneutikwa'ani 'atahuta tukaritsie, kenematiuta'aitɨa. Mɨkɨ 'ixɨarari keneuwewiximeni weiya metseriyaritsie, mɨkɨ metseritsie 'Ekipitu xemayekɨkɨ. ");
INSERT INTO hch_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","»Tɨɨri mexɨakate memɨtinunuiwa nehetsɨa mepɨmiemetetɨni, wakaitsixi meta muxatsi wamexɨakate. ");
INSERT INTO hch_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Tɨɨri mexɨakate wahetsie pemɨtanuani pɨyɨweni. Puxu mexɨakame hetsie pepɨtanuani muxa mawariyarikɨ, xɨka mɨpaɨ pekatiuyurieni kɨipieya pekaniwakutaramɨkɨ. »Nixewitɨ nehetsɨa pɨkahamieni tixaɨtɨ karapitɨ. ");
INSERT INTO hch_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","»'Ataxewime tukaritsie xeikɨa pepɨti'uximayaka, 'atahutariekatsie pekani'uxipiekamɨkɨ. Tsepa xemukwietsanatɨwe tsepa xemɨ'itsanatɨwe, peuyewetse mɨkɨ tukaritsie yemekɨ xemɨkate'uximayaka. ");
INSERT INTO hch_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","»Tsemana 'ixɨarariyari xekeneutiwewiwani matɨari mɨtiutixuxuawere, meta 'itsanaxa 'ixɨarariyari xekeneutiwewiwani xeiwiyari 'anayexɨruwekaku. ");
INSERT INTO hch_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","»Yunaitɨ 'ukitsi meputa'axeni, haikakɨa xeiwiyaritsie nehɨxie, ne Yawé 'Ixaheri Kakaɨyarieya hetsɨa. ");
INSERT INTO hch_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Hikɨ 'ana nuiwarite 'ahɨxie nekaniwarayeweiyaxɨamɨkɨ, 'akwie nepɨ'ɨwiyani xewitɨ 'axapɨka'iyurieni. ");
INSERT INTO hch_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","»Kepauka tewa mawariyari xemɨnetsiwewirieni, xuriyayatsie tikuxanariyame xepɨka'enutinɨitɨwani. »Muxa Patsikwa 'ixɨararipa mieme pɨkayukuhayeikawani 'uxa'arieka mieme mayanikɨ. ");
INSERT INTO hch_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","»'Ikwaxi matɨari mieme 'aixɨa mɨ'anene Yawé kiita pepɨyetuani 'akakaɨyari hetsɨa. »Tsipu nunutsi maamaya retsieyatsie xepɨka'i'etsani». ");
INSERT INTO hch_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Yawé Muitsexi mɨpaɨ katiniutahɨawe: —'Ikɨ niukiyari kenaka'utɨa mɨkɨ tɨratu nepɨwewie 'ahetsiemieme meta 'ixaheritsixi wahetsiemieme. ");
INSERT INTO hch_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Hɨritsie Muitsexi puyuhayewaxɨ, Yawé hamatɨa, huta tewiyari tukari huta tewiyari tɨkari, katikwatɨ kaharetɨ. Mana tete wewerimetsie katinaka'utɨani tɨratu kememɨte'uwewi, tatsɨari tamamata 'aitsikayari. ");
INSERT INTO hch_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Hikɨ Muitsexi kepauka Tsinahi hɨriyaritsie makane hutame tetexi 'a'ɨtɨ 'inɨari niukiyari maye'utɨka. Yawé hamatɨa mɨtiutaxatakaikɨ kanayexawatɨkaitɨni peru mɨkɨ 'atsipɨkatimaikai. ");
INSERT INTO hch_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Kepauka 'Aruni meta 'ixaheritsixi Muitsexi memuxei 'ayexawatɨme, meputimama 'ahurawa mepɨkakɨnikukai. ");
INSERT INTO hch_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Matsi Muitsexi 'Aruni kaniuta'inieni meta memanuyetei, mɨkɨ hetsɨana mekaniu'axɨani memɨtetixatakɨ. ");
INSERT INTO hch_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","'Ixaheritsixi 'ahurawa mekaniukɨne, Muitsexi mɨpaɨ katiniwaruta'aitɨani memɨ'enananikɨ Yawé kemɨrehɨawekai Tsinahi hɨriyaritsie. ");
INSERT INTO hch_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Hikɨ kepauka mɨtiutahayewaxɨ Muitsexi tikuxatatɨ, yuhɨxie kaneuyukunani 'ixurikikɨ. ");
INSERT INTO hch_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Kepauka meutahakekai Yawé hamatɨa retixatake kaneuyukuyepiwakaitɨni mexi kawayeyeiweni. Wayeyame katiniwarutixaxatɨwakaitɨni 'ixaheritsixi Yawé kemɨtita'aitɨani kemɨtiwatahɨawe. ");
INSERT INTO hch_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","'Ixaheritsixi memixeiyakaikɨ 'ayexawatɨme, Muitsexi tawarita kaneuyuku'eimakaitɨni kepauka Yawé hamatɨa mɨtitixata. ");
INSERT INTO hch_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Merikɨtsɨ Muitsexi kaniwarukuxeɨrieni yunaime 'ixaheritsixi, mɨpaɨ katiniwarutahɨawe: «'Ikɨ Yawé kani'aitsikayatɨni mɨpaɨ temɨtekakɨnekɨ: ");
INSERT INTO hch_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","'Ataxewime tukari xeikɨa xekateni'uximayakakuni. 'Atahutarieka tukaritsie, xawatikɨ, mɨkɨ tukaritsie xepɨkate'uximayaka Yawé hetsiemieme kanipatsieka. Kemɨ'ane mɨti'uximayaka mɨkɨ tukaritsie kanimieriemɨkɨ. ");
INSERT INTO hch_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Xawatikɨ nixewitɨ pɨka'atinanaiyani yukie». ");
INSERT INTO hch_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Muitsexi mɨpaɨ katiniwarutahɨawe 'ixaheritsixi yunaime: «Yawé mɨpaɨ katatini'aitɨaka: ");
INSERT INTO hch_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Xekateniyetuakuni tita xemɨtehexeiya Yawé hetsɨa timieme mɨrayanikɨ huru, pɨrata, wurunitse, ");
INSERT INTO hch_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","muxa huxarieya 'uarietɨkaime mɨyɨtsikimaɨyekɨ, kwimɨxetakɨ meta mɨxetakɨ, rinu 'ixurikiyari 'aixɨa mɨ'ane, kapura huxarieya, ");
INSERT INTO hch_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","muxatsi 'amemɨpapa wanawiyari mɨxeta, ketsɨ 'amɨpa nawiyarieya, 'akatsiya kɨyeyari, ");
INSERT INTO hch_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","huriwa hatseitiyari kɨxemetamieme, witsimu'ɨatɨka hatseiti memɨwakawiriwa hetsiemieme meta 'ɨkwa witsimu'ɨa hetsiemieme, ");
INSERT INTO hch_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","'unitse teteyari meta hipame witsimɨ'anene kamixa 'etsimɨnena hetsiemieme mayanikɨ meta kuka mekatɨni hetsiemieme. ");
INSERT INTO hch_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","»Yunaitɨ naimekɨ memɨteheutawewiwawe mana memɨxuawe mekanahuni 'ena mɨkɨ mepɨyɨwaweni memɨtetiwewieni Yawé kemɨti'aita: ");
INSERT INTO hch_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","tuki, heimana manuka'eimire, meta 'ixuriki 'amɨyeyeu, yukwatsiturai hexeiyatɨkaime, mexa 'amatayeyeu, manuyehini, meta mɨka'uni meta hetsiena ma'uni, ");
INSERT INTO hch_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","kakuni meta kɨyexi manukuhini hexeiyame, kanamikieya, meta 'ixuriki kakuni meukunakakɨ, ");
INSERT INTO hch_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","mexatsie meta kɨyexi manukuhini hexeiyakame, mana mɨrapinire, paa mana mamare. ");
INSERT INTO hch_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","Kɨxeme 'uitɨwame mɨkɨxenikɨ meta tita mɨrakapine, kɨxemete, hatseitiyari, ");
INSERT INTO hch_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","'ɨkwa witsimu'ɨa mexayari kɨyexi hexeiyame manukuhini, hatseiti memɨkawiriyarɨwa, 'ɨkwa witsimu'ɨa, 'ixuriki kitenie meuwiere. ");
INSERT INTO hch_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","Tuurutsixi mematitaiyarɨwa mayexaxawa hexeiyakame wurunitsekɨ wewiyakame, kɨyexi manukuhini meta naitɨ mana mɨreuyewetse, maimawame wurunitsekɨ wewiyakame meta hetsiena muyemare hexeiyame. ");
INSERT INTO hch_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","Takwa 'ixuriki mawɨretɨyani, kɨyexi meuka'uixɨani, 'ixuriki takwa kitenietsiemieme, ");
INSERT INTO hch_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","xamaru makɨwɨrixɨani kɨyexi mukatsunirixɨani, meta kurarutsie mieme, meta kaunariyarite. ");
INSERT INTO hch_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","Mawari wewiwamete wakamixate 'atɨtɨme wipetɨkaime me'enakatɨtɨ memɨteta'uximayatakɨ tukita, kamixateta mɨpatsietɨka 'Aruni hetsiemieme meta niwemama wahetsiemieme». ");
INSERT INTO hch_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Hikɨ 'ixaheritsixi yunaitɨ meneutayeixɨani Muitsexi hɨxie, ");
INSERT INTO hch_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","hikɨ yuxexuitɨ kememɨte'uyuitɨarie meyuwaɨriyatɨ yamekateniuyurieni Yawé 'imikieri mekaniyetuirieni tuki 'ixurikiyari mɨtawewiyanikɨ, meta naime tita mɨtiyɨnikekai, meta kemarite mɨtiwewiyanikɨ mɨpatsietɨka. ");
INSERT INTO hch_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Yaxeikɨata, yunaitɨ kememɨte'uyuitɨarie meyuwaɨriyatɨ yu'iyaritsie, 'ukitsi 'ukari, hurute mekateniyetuani mawari mayanikɨ: tupunite, kuka, hanira, meta hipatɨ yɨkɨ mɨreukuwewiyatɨka hurukɨ mɨtiwewiyatɨka. Yunaitɨ mɨkɨ huru mawariyari mekaniyetuaxɨani Yawé hetsiemieme teikɨ hetserarietɨ muyuitɨariwa mayanikɨ, ");
INSERT INTO hch_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","yaxeikɨata tita memɨteheuxeiyakai mekatenepini: muxa huxarieya mɨyɨtsikimawi, kwimɨxeta meta mɨxeta, rinu 'ixurikiyari 'aixɨa mɨ'ane, kapura huxarieya, muxatsi wanawi mɨxeta mɨraye'atɨka meta ketsɨte 'amemɨpapa wanawiyari. ");
INSERT INTO hch_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Pɨrata memexeiyakai meta wurunitse Yawé mekaniyetuirieni wamawari mayanikɨ, yaxeikɨata 'akatsiya kɨyeyari memexeiyakai mekaniyetuani, mɨpaɨ mekateniyetuani 'etsiwa mɨtitiwewiyanikɨ. ");
INSERT INTO hch_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","'Ukari waɨkawa memɨtematekai mekateniyetuaxɨani, hiru mɨyɨtsikimawi, kwimɨxeta meta mɨxeta, mɨkɨ memeitikaunakai meta rinu 'ixurikiyari. ");
INSERT INTO hch_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Hipatɨta waɨkawa memɨtematekai, mɨkɨta mekaniuyuitɨarieni para memiyetuanikɨ, mɨkɨ tsipuri wahuxariyari kakaunime. ");
INSERT INTO hch_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Memanuyetei 'ixaheritsixi wa'ukiyarima 'unitse teteyari mekani'atɨani meta hipame tetexi witsimɨ'anene, para mawari wewiwame kamixayatsie mieme meta kukaya mɨtawewiyanikɨ mekatɨkɨnikɨ. ");
INSERT INTO hch_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Yaxeikɨata witsimu'ɨatɨka mekaniyetuani meta huriwa hatseitiyari mekanehapani kɨxeme hetsiemieme, meta memɨkawiriyarɨwani, yaxeikɨata 'ɨkwa witsimu'ɨa. ");
INSERT INTO hch_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Yunaitɨ 'ixaheritsixi kememɨtekuyuitɨariwakai mawari mekaniyetuani Yawé hetsiemieme 'ukitsi meta 'ukari, Yawé hetsiemieme mɨtita'uximayatsienikɨ, Muitsexi yatiwakɨhɨawekaku kememɨteyurienikekai. ");
INSERT INTO hch_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Muitsexi mɨpaɨ katiniwarutahɨawe 'ixaheritsixi: «Mɨpaɨ xeketenemaika Yawé Wetsareri kanenayexeiya 'Urihi nu'aya Kuxi teukarieya, Kura nuiwarieyatsie mieme, ");
INSERT INTO hch_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Kakaɨyari 'Iyarikɨ kanihɨniyani, mɨtimaiwenikɨ, mɨtimatenikɨ, kemɨtiuyurieni kaniyɨweni, ");
INSERT INTO hch_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","katiniwewiweni hurukɨ, pɨratakɨ meta wurunitsekɨ, ");
INSERT INTO hch_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","tetexi witsimɨ'anene kanixiteweni meta mitayatsakɨ, kɨyexi haruruanime kaniwewiweni, meta naime mɨtitiwewiwanikɨ tita mɨtimate. ");
INSERT INTO hch_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Mɨkɨ Kakaɨyari kanipitɨani meta 'Ahurihawi 'Akitsamaki nu'aya, Rani nuiwarieyatsie mieme, hipame memɨtewa'ɨkitɨawawenikɨ. ");
INSERT INTO hch_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Pɨwarupitɨa waɨkawa memɨtemaiwawenikɨ memɨtetiwewiwanikɨ tinaime, muxa huxarieyakɨ memɨteheutawewiwawenikɨ, mɨyɨtsikimaɨyekɨ, kwimɨxetakɨ, meta mɨxetakɨ, metatsiere rinu 'ixurikiyarikɨ. Mepɨteheutatsaiwawe yemekɨ mepɨtemate tsepa tita mɨtiutawewi. ");
INSERT INTO hch_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","»Hikɨ, Wetsareri meta 'Ahurihawi hamatɨa yametenikakɨnikuni tinaime 'uximayatsikatsie tuki hetsiemieme, yemekɨ Yawé kemɨtiuta'ai, yunaitɨ yaxeikɨa meteku'eriwatɨ kememɨtepitɨarie, meta kemɨ'ane Yawé metemaiweme meta meteheutawewiwaweme mɨwarupitɨa witsiti'anenekame memɨtetiwewiwanikɨ tukita timieme». ");
INSERT INTO hch_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Muitsexi kaniwarutahɨawe Wetsareri meta 'Ahurihawi, meta yunaime kemɨ'ane yaxeikɨa memɨtepitɨariekai, meta kemɨ'ane Yawé metemaiwaweme meta meteheutawewiwame mɨwarupitɨa, yuxexuitɨ kememɨte'uyuitɨarie meyuwaɨriyatɨ mekaniu'axɨani memɨteta'uximayatakɨ, ");
INSERT INTO hch_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","mɨkɨ katiniwayetuirieni mawari 'ixaheritsixi memɨteyetuakai tuki mɨtawewiyanikɨ. Peru 'ixaheritsixi mekatehayewakaku meteyetuayatɨ 'imikierite, ");
INSERT INTO hch_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","yunaitɨ memɨtewewiekai tuki hetsiemieme memɨtemate, mekateniuhayewa, ");
INSERT INTO hch_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","mɨpaɨ Muitsexi memɨtehɨawiyukɨ: «Teɨteri kwinimiemeri tipaɨmeme mepɨtekuxeɨrixime, 'ari mɨpaɨ tipaɨmeme xeikɨa, Yawé kemaine pɨtinake». ");
INSERT INTO hch_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Hikɨ Muitsexi mɨpaɨ katiniuta'aita memɨteyukaxatɨanikɨ naitsarie memakuteitsie: «'Ari 'imikieri xepɨkayetuayani tuki hetsiemieme, 'ukitsi meta 'ukari xepɨkatehe'uximayakari». 'Anake 'ixaheritsixi mekateniuhayewa meteyetuayatɨ, ");
INSERT INTO hch_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","memɨte'atɨakai pɨtiwaɨkawakai mɨkɨkɨri pɨtitinɨrekekai naitɨ 'uximayatsika. ");
INSERT INTO hch_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Yunaitɨ tewewiwamete xei'iyariyari mehexeiyaɨ tuki mekaniutawewieni, tamamata rinu 'ixurikiyarikɨ 'aixɨa mɨ'anenekɨ, muxa huxarieya mɨyɨtsikimaɨyekɨ 'uariekame, kwimɨxetakɨ, meta mɨxetakɨ, Kakaɨyari teɨtametemama mehaxutɨkaime. ");
INSERT INTO hch_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Naitɨ 'ixuriki yaxeikɨa patayeyeukai, tamamata heimana huta meturuyari heimana 'imeriyu tɨtɨme meta xeimeturuyari heimana nauka tewiyari tsenitimeturuyari patayeyeuka. ");
INSERT INTO hch_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","'auxɨwime 'ixuriki mekaniutawipa yuwiyakame, hipameta 'auxɨwime yaxeikɨa mekaniuyurieni. ");
INSERT INTO hch_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Mexɨakame mɨwipetsie 'ixuriki, hakɨrɨi mekanawɨtɨaxɨani muxa huxarieyakɨ mɨyɨtsikimawikɨ 'uariekame, yaxeikɨata mekateniuyurieni hutarieka miemetsie. ");
INSERT INTO hch_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Mexɨakame mɨwipetsie mekanawɨtɨani huta tewiyari heimana tamamata hakɨrɨi, hutarieka miemetsieta yaxeikɨa, naitɨ yaxeikɨa papaɨmeme pexeiyatɨkatei 'anuyutaxeiyatɨkaitɨ. ");
INSERT INTO hch_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","'Ariketa huru kwatsituraiyari mekaniutiwewieni huta tewiyari heimana tamamata 'ixuriki muyutawiyakɨ, tuki muyuxewiriyanikɨ. ");
INSERT INTO hch_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Tamamata heimana xewi tsipuri wahuxari 'ɨkariyari mekaniutiwewieni, tuki manukananikɨ 'ixuriki kiyari hepaɨ rekuweretɨ. ");
INSERT INTO hch_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Yaxeikɨa pɨyeyeukai naitɨ tamamata heimana xewi 'ixuriki mauwɨre, tamamata heimana haika meturuyari heimana 'imeriyu meta xeimeturuyari heimana nauka tewiyari tsenitimeturuyari 'atayeyeume. ");
INSERT INTO hch_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Hutame mekaniutiwipa 'ɨkari, xeime 'auxɨwime, xeimeta 'ataxewime. ");
INSERT INTO hch_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Huta tewiyari heimana tamamata mekaniutiwewieni hakɨrɨi matɨari memitawipaxɨtsie 'imatɨrieka 'ɨkari manunieretsie mekanewɨtɨaxɨani, meta hutarieka miemetsie yaxeikɨa paɨmeme. ");
INSERT INTO hch_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Wurunitse kwatsitɨraiyari mekaniutiwewieni huta tewiyari heimana tamamata, tuki yuxewiriyatɨ mayanikɨ. ");
INSERT INTO hch_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Nawi mekaniutawipa tukitsiemieme muxatsi wanawiyari xetamekɨ 'uarietɨkaime, mɨkɨ heimana manukawerire mekaniutawewieni ketsɨte wanawiyari 'aixɨa mɨ'anenekɨ. ");
INSERT INTO hch_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Tuki hetsiemieme 'akatsiya mexayari mekaniutixixieni pepetsawime, mekanika'uitɨani. ");
INSERT INTO hch_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Xexuitɨ mexa nauka meturuyari heimana 'imeriyu pɨtɨkai meta haika tewiyari heimana tamamata tsenitimeturuyari 'atayeyeutɨ, ");
INSERT INTO hch_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","hutakɨa 'ukakukunitɨkaime. Naime mɨkɨ mexate tuki hetsiemieme mɨpaɨ mekateniuwewieni: ");
INSERT INTO hch_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Xeitewiyari mexate putiwewi, 'ameuyewatsie tatsutɨa muyekatsie mieme, ");
INSERT INTO hch_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","huta tewiyari kaniuyɨni pɨrata tepɨayari mexa mutuikaxɨani, xexuime mexatɨa huhutatame, ");
INSERT INTO hch_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","tayeta miemeta xeitewiyari mexate 'ematayeyeu tuki hetsiemieme, ");
INSERT INTO hch_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","huta tewiyari pɨrata tepɨayari wahetɨa meutayaxe, mexa xexuime hetɨa huhutatatɨ, ");
INSERT INTO hch_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","'etsimeuyewatsieta 'ataxewitɨ mexate kaniuyɨni, tau makayuyuipike hepatsie, ");
INSERT INTO hch_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","mutatsikuritɨkatsie huhutatatɨ kaniuka'uni 'etsimeuyewatsie. ");
INSERT INTO hch_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Mɨkɨ mexate yu'aurie kaniuti'utɨkateitɨni 'axeikɨa 'ati'utɨ, wapaitɨ xeihanirayaritsie heuyehatɨkaitɨ. Yaxeikɨa puyɨxɨa naitsata 'etsikinatsie, ");
INSERT INTO hch_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","'atahaika mexate kaniuyɨni, meta tamamata heimana 'ataxewi mexatɨa mieme pɨrata tepɨayari, huhutatatɨ xexuime mexatɨa. ");
INSERT INTO hch_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","'Akatsiya kɨyeyari mekaniutixixieni manuyehini: 'auxɨwime mexate tuki 'etsata mieme, ");
INSERT INTO hch_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","'auxɨwimeta tapa mieme, 'auxɨwime mexate 'etsimauyewatsie tuki manutinieretsiemieme. ");
INSERT INTO hch_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Kɨyexi ma'utɨka wahixɨapa mukuhuni kɨye heutanetɨkaime mepuyuri. ");
INSERT INTO hch_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Mexate mɨti'utɨka huru mekanitiwirieni, meta huru hanirayari mekanawewiexɨani manukuhini mana meuyehaxɨanikɨ. Meta manukuhini hurukɨ mekanitiwirieni. ");
INSERT INTO hch_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","'Ixuriki mekaniutawewieni muxa huxarieya mɨyɨtsikimawikɨ, kwimɨxetakɨ meta mɨxetakɨ rinu 'aixɨa mɨ'anekɨ, Kakaɨyari teɨtametemama mehaxutɨkaime hetsiena. ");
INSERT INTO hch_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Naukame 'akatsiya kɨyeyari mɨka'uni mekaniutixixieni huru mekanitiwirieni, huru kwatsituraiyari mekana'uitɨaxɨani, naukame pɨrata tepɨayari mekaniutiwewieni kɨyexi mɨka'uni hetsiena ma'uni. ");
INSERT INTO hch_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","'Ixuriki mekaniutawewieni tuki kitenie mieme muxa huxarieya 'uarietɨkaime mɨyɨtsikimawikɨ, kwimɨxetakɨ meta mɨxetakɨ rinu 'aixɨa mɨ'anekɨ, 'itsariekame meta tixukame, ");
INSERT INTO hch_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","'auxɨwime kɨyexi mekaniutixixieni kwatsiturai hexeiyatɨkaime, meta wurunitse tepɨayari 'auxɨwime kɨyexi muka'uni 'amɨpapa hetɨamieme, meta huru herie mekanikawirieni. ");
INSERT INTO hch_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Wetsareri kakuni kaniutawewieni 'akatsiya kɨyeyarikɨ, xeimeturuyari heimana tamamata tsenitimeturuyari tewime, haika tewiyari heimana tamamata tsenitimeturuyari 'atayeume meta yaxeikɨata mɨpaɨ heutitewame. ");
INSERT INTO hch_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Huru taɨtana kanewakuwirieni meta herie, meta hurukɨ kanetatenitɨani. ");
INSERT INTO hch_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Naukame huru hanirayari kaniutiwewieni kakunitsie mieme, 'ɨkateyatsie ne'uitɨani, tapa 'etsatana hutatɨ na'uni tapata hutatɨ. ");
INSERT INTO hch_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Meta kurumawime 'akatsiya kɨyeyari kaniutiwewieni, huru kanitiwirieni, ");
INSERT INTO hch_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","haniratsie kaneiye'uitɨaxɨani kakuni 'etsata mukumanetsie, mukukweiyanenikɨ. ");
INSERT INTO hch_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Hurukɨ xeikɨa kanamikiyari kaniutawewieni Kakaɨyari ma'axe, xeimeturuyari heimana tamamata tsenitimeturuyari tewime meta haika tewiyari heimana tamamata tsenitimeturuyari 'atayeume. ");
INSERT INTO hch_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Kakaɨyari teɨtametemama pɨwarutiwewi hurukɨ, titsunamekɨ mewewiyatɨkaime, kanamiki Kakaɨyari ma'axe 'etsimeuyeyeutsie mema'unikɨ yuxexuitɨ. ");
INSERT INTO hch_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Xewitɨ 'etsimeuyewatsie kanakeni, xewitɨta tapa, Kakaɨyari teɨtametemama memɨyuhuta, meyuxewiriyame kaniwarayeitɨani Kakaɨyari ma'axeni mame. ");
INSERT INTO hch_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Kakaɨyari teɨtamete Kakaɨyari ma'axe heima mepuye'anatɨkatei, kɨmana mepenukanakai. Mepanuyutaxeiyakai Kakaɨyari ma'axe meheukanenieretɨ. ");
INSERT INTO hch_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Wetsareri mexa kaniutawewieni 'akatsiya kɨyeyarikɨ, nauka tewiyari heimana tamamata tsenitimeturuyari tewime meta huta tewiyari heimana 'auxɨwi tsenitimeturuyari 'atayeume, meta haika tewiyari heimana tamamata tsenitimeturuyari 'aweme. ");
INSERT INTO hch_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Huru kanikawirieni, hurukɨtsiere kaneta'utɨani. ");
INSERT INTO hch_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Metatsiere xeitewiyari tsenitimeturuyari 'atayeume kanatawewieni tenimeyari, mɨkɨta hurukɨ kaneta'utɨani. ");
INSERT INTO hch_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Naukame huru hanirayari kaniutiwewieni 'ɨkateyatsie kane'uitɨaxɨani, 'etsatana huhutatatɨ kana'uixɨani 'ɨkateya ma'utɨkatsie. ");
INSERT INTO hch_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Hanira, mexa tenimeyari hetɨa neimana, mana kɨyexi muye'unikɨ mukukweiyanenikɨ. ");
INSERT INTO hch_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Mɨkɨ 'akatsiya kɨyexiyari pɨhɨkɨtɨkai huru wiriyarietɨkaitɨ. ");
INSERT INTO hch_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Naime hurukɨ xeikɨa pɨtiutiwewi tita mana mɨrapinirekekai xakɨrɨte, 'itɨte, tekɨxite, ye'ɨrɨte 'amɨnene winu memutimawakai hetana. ");
INSERT INTO hch_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Wetsareri kɨxeme 'uitɨwame kaniutawewieni hurukɨ xeikɨa, titsunamekɨ wewiyakame. Hetsiena maweni meta 'ɨkayari, muwatixaxawa, tekɨxiyari meta tuturiyari naitɨ puyuxewiriyakai. ");
INSERT INTO hch_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Kɨxeme 'ataxewime yumamate pexeiyakai, tapa haikatɨ tapata haikatɨ. ");
INSERT INTO hch_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Xexuime mamateyaritsie haikakɨa hewatixaxawame 'arimetɨra tuturiyari hepaɨ tiyuxexeiyatɨkaime, tuturi yu'iwitsi hexeiyakame meta xawariyari. ");
INSERT INTO hch_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Kɨxeme 'uitɨwame peixeiyakaita naukame tekɨxiyari 'arimetɨra tuturiyari hepaɨ tiyuxexeiyame, yu'iwitsi meta yuxawari hexeiyame. ");
INSERT INTO hch_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Mexɨakame mamateya paritsiyari hetɨatsie peixeiyakai xeime yutekɨxi, hutarieka paritsiyari hetɨatsie peixeiyakai hutarieka tekɨxi, meta hairieka paritsiyari hetɨatsie peixeiyakai hairieka mieme tekɨxi. ");
INSERT INTO hch_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Tekɨxite meta mamateyari puyuxewiriyakai kɨxeme 'uitɨwame matɨa, hurukɨ xeikɨa titsunamekɨ wewiyakame. ");
INSERT INTO hch_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","'Atahuta kɨxeme hurukɨ xeikɨa kaniutiwewieni, meta kɨmana mɨtaire meta naxiyari makawiwieni. ");
INSERT INTO hch_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Mɨkɨ kɨxeme 'uitɨwame mɨtawewierekɨ meta tinaitɨ mɨreukapine xeitewiyari heimana tamamata heimana haika kiruyari huru kaniuyɨni. ");
INSERT INTO hch_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Wetsareri 'ɨkwa witsimu'ɨa taiyame mexayari kaniutawewieni 'akatsiya kɨyeyarikɨ. Yaxeikɨa huta tewiyari heimana 'auxɨwi tsenitimeturuyari tewime meta huta tewiyari heimana 'auxɨwi tsenitimeturuyari 'atayeume, meta nauka tewiyari heimana tamamata tsenitimeturuyari 'aweme. 'Awateya naitɨ kaniyuxewiriyakaitɨni mɨkɨ mexa matɨa. ");
INSERT INTO hch_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Herie kanikawirieni huru metatsiere naitsarie 'etsatana meta 'awateyatsie, hurukɨ xeikɨa tenimeyaritsie kanetawirieni. ");
INSERT INTO hch_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Tenimeyari manukaniere hanira kanamanaxɨani mana kɨyexi meuye'unikɨ mukukweiyanenikɨ. ");
INSERT INTO hch_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Kɨyexi 'akatsiya kɨyeyari kanihɨkɨtɨkaitɨni, huru wiriyarietɨkaitɨ. ");
INSERT INTO hch_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Wetsareri hatseiti mɨpatsie kaniukawewieni meta 'ɨkwa witsimu'ɨa, witsimɨtiu'ɨatɨka wewiwamete wahepaɨ katiniwewieni. ");
INSERT INTO hch_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Merikɨtsɨ Wetsareri 'akatsiya kɨyeyarikɨ mawari taiyariyari wewiwame kaniutawewieni. Yaxeikɨa kaneutatetewakaitɨni, huta meturuyari heimana xeitewiyari heimana tamamata tsenitimeturuyari tewime meta mɨpaɨ 'atayeume, meta xeimeturuyari heimana xeitewiyari heimana tamamata tsenitimeturuyari 'aweme. ");
INSERT INTO hch_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Naitsata 'awate kanawewiexɨani muta'itsikinatɨkatsie, mɨkɨ naitɨ puyuxewiriyakai mexa mawari taiyariyari wewiwame matɨa, meta wurunitsekɨ mexa kaniukawirieni naime herie. ");
INSERT INTO hch_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Katiniutiwewienita wurunitsekɨ tita mɨreuyewekai: naxi yetsame, 'itɨ 'amɨpa, tepɨa manuxɨte, tepɨa 'amɨpa manuxutetɨka, meta tɨɨ yayatsame. ");
INSERT INTO hch_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Mawari matitaiyarɨwa hetɨa mieme kaniutawewieni 'ayexaxawame wurunitsekɨ wewiyakame, tenimeyari hetɨa kaniyemani, kemawekai hixɨapa 'uyemakame. ");
INSERT INTO hch_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Wurunitse hanirayari naukame kaniutiwewieni, memanaxɨanikɨ naitsata mayexaxawa 'etsikinayaritsie, kɨyexi mana muye'unikɨ, ");
INSERT INTO hch_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","kɨyexi xexeurawime kaniutiwewieni 'akatsiya kɨyeyarikɨ, wurunitse kanitiwirieni herie ");
INSERT INTO hch_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","manuyexaxawatsie kaneiyehatɨaxɨani, naitsata heitituatɨkaitɨ kanayani mɨkɨkɨ mukukweiyanenikɨ. Mawari taiyame yutaɨta puxawakai mexakɨ pɨwewiyakai. ");
INSERT INTO hch_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","'Ukarawetsixi 'ixuriki tukiyari kitenie memɨte'uximayakai wurunitse xikɨriyari mekani'atɨirieni, mɨkɨkɨ kanitawewieni maimawame meta 'ɨkaya hetsiena muyemare. ");
INSERT INTO hch_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","'Ariketa takwa 'amakuyewa mekaniutawewieni. Tatsutɨa hepatsie huta tewiyari heimana 'auxɨwi meturuyari pɨtewikai, rinu 'ixurikiyari 'aixɨa mɨ'anene pawɨtɨkatei, ");
INSERT INTO hch_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","kɨyexi muka'utɨka xeitewiyari pexeiyakai, meta xeitewiyari wurunitse tepɨayari hetɨana mieme, pɨrata kwatsituraiyari hexeiyatɨkaime kɨyexi meta hanira. ");
INSERT INTO hch_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Tapata tayeta hepatsie huta tewiyari heimana 'auxɨwi meturuyari pɨtewikai, xeitewiyari muka'utɨka kɨyexi pexeiyakai, xeitewiyarita wurunitse tepɨayari hetɨana mieme, pɨrata kwatsituraiyari hexeiyatɨkaime kɨyexi meta hanira. ");
INSERT INTO hch_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","'Etsimeuyewatsie tau makayuyuipike hepatsie xeitewiyari heimana huta meturuyari heimana 'imeriyu patayeukai, meta 'ixuriki peuwɨkai meta tamamata kɨyexi muka'uixɨani meta tamamata hetsiena ma'utɨkatei, kɨyexi pɨrata kwatsituraiyari pexeiyatɨkatei. ");
INSERT INTO hch_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Tau manatineika hepatsieta, xeitewiyari heimana huta meturuyari heimana 'imeriyu patayeukai. ");
INSERT INTO hch_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Mɨranutakɨkatɨretsieta tapa 'ixuriki peuwɨkai 'atahuta meturuyari 'ayetɨtɨ, haikatɨ kɨyexi muka'utɨka, meta haikatɨ hetsiena ma'uni, ");
INSERT INTO hch_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","meta tapatsieta 'ixuriki peuwɨkai 'atahuta meturuyari 'ayetɨtɨ, haikatɨ kɨyexi muka'utɨka, meta haikatɨ hetsiena ma'uni. ");
INSERT INTO hch_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","'Ixuriki naitɨ maweretɨkatei takwa, mɨkɨ rinu 'ixurikiyari 'aixɨa mɨ'anene kanihɨkɨtɨkaitɨni. ");
INSERT INTO hch_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Kɨyexi mutuikatɨka wurunitsekɨ pɨwewiyatɨkatei, kwatsiturai meta hanira kɨyexi hetsie mawetɨkatei pɨratakɨ pɨwewiyatɨkatei, meta mu'uteyatsie pɨratakɨ kaniwiriyarietɨkateitɨni. Naitɨ kɨyexi mukawetɨkatei pɨrata hanirayari pexeiyatɨkatei. ");
INSERT INTO hch_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","'Ixuriki mɨranutakɨkatɨretsie meuwiekai mɨyɨtsikimaɨyekɨ pɨ'uariekai, kwimɨxetakɨ meta mɨxetakɨ, rinu 'ixurikiyari 'aixɨa mɨ'ane, witsireuku'itsetɨ. 'Atanauka meturuyari pɨtewikai meta huta meturuyari heimana xeitewiyari heimana tamamata tsenitimeturuyari 'atayeutɨ, mɨyatɨniketɨ mɨpaɨ heutitewatɨ, mɨkɨ 'ixuriki takwa mieme hepaɨ, ");
INSERT INTO hch_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","naukame pexeiyakai kɨyexi muka'uni meta naukame pexeiyakai wurunitse tepɨayari hetɨana mieme. Kwatsituraiyari meta hanirayari pɨratakɨ pɨwewiyatɨkatei, meta mu'uyatsie pɨrata pɨkawiriyarietɨkatei. ");
INSERT INTO hch_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Naitɨ mukatsunetɨkatei 'ixuriki manukawere makuwɨrekɨ, meta mana takwa kuraru makatsie mieme wurunitse tepɨayari pɨhɨkɨtɨkatei. ");
INSERT INTO hch_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","'Ikɨ katinihɨkɨtɨni ketipaɨmemekɨ mɨtiutiwewiya, para tuki muyepatsie tɨratutsie mieme mɨtawewiyanikɨ. Rewitsixi mɨpaɨ mekatenaka'utɨani, Muitsexi mɨpaɨ mɨtiwaru'aitɨakɨ meta 'Itamaxi 'Aruni mawari wewiwame nu'aya yatiwakɨhɨawekaku. ");
INSERT INTO hch_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Wetsareri, 'Urihi nu'aya Kuhuxi teukarieya, Kura nuiwarieyatsiemieme, Yawé Muitsexi kemɨtiuta'aitɨakai mɨpaɨ katiniuyurieni naime. ");
INSERT INTO hch_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Yaxeikɨata piparewiekai 'Ahurihawi, 'Akitsamaki nu'aya, Rani nuiwarieyatsie mieme, mɨkɨ naime pɨtitiwewiwakai, pɨtitiwipakai muxa huxarieya mɨ'uarietɨkakɨ mɨyɨtsikimawikɨ, kwimɨxetakɨ meta mɨxetakɨ, meta rinu 'ixurikiyarikɨ. ");
INSERT INTO hch_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Kepaɨmetɨ muyɨ huru mɨyetuiya, kepauka tuki mutawewiyatsie xeimiriyari kiruyari kaniuyɨni, kemɨti'inɨatakai 'ana tuki. ");
INSERT INTO hch_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Pɨrata kememɨteyetua yuxexuitɨ 'ixaheritsixi mekanaka'utsieni, haika miriyari heimana 'auxɨwime tsienituyari (3.500) kiruyari kanayani kemɨti'inɨatakai tuki 'ana. ");
INSERT INTO hch_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Yunaitɨ xeitewiyari wiyari memɨhɨtɨkatei mekanaka'utɨarieni, mɨkɨ yunaitɨ mepakɨ 'ataxewime tsienituyari heimana haika miriyari heimana 'auxɨwime tsienituyari heimana huta tewiyari heimana tamamata (603.550), mɨkɨ mɨpaɨ meyupaɨmetɨ mekaniyetuaxɨani yuxexuitɨ, 'ataxewime kɨramuyari pɨrata, tuki 'ana kemɨti'inɨatakai. ");
INSERT INTO hch_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Haika miriyari heimana haika tsienituyari kiruyari pɨrata kaniuyɨni, xeitsienituyari kɨyexi mukawetɨka hetɨa mieme mutiwewiya, mɨkɨ xexuitɨ pɨreuhapanakai xeitewiyari heimana tamamata heimana haika kiruyari. ");
INSERT INTO hch_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Pɨrata muyuhayewaxɨ putiwewiya kwatsiturai meta hanira kɨyexi muka'uni hetsiemieme, meta mu'uyatsie manutineniere mekaniutiwirieni. ");
INSERT INTO hch_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Naitɨ wurunitse kaniyetuiyani huta miriyari heimana haika tsienituyari heimana huta tewiyari kiruyari, ");
INSERT INTO hch_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","'ixuriki tukiyari kitenie kɨyexi hetsiena ma'uni kaniutiwewiyani, meta mawari taiyariyari wewiwame, mayexaxawa meta naitɨ tita mɨreuyehɨwa, ");
INSERT INTO hch_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","takwa kuraru makatsie kɨyexi hetsiena ma'uni kaniutiwewiyani meta mukatsunirixɨa tuki hetsiemieme meta kuraru makatsiemieme. ");
INSERT INTO hch_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Kemarite mɨti'itsetɨka tukita te'uximayatamete wahetsiemieme, kaniutiwewiyani muxa huxarieya mɨyɨtsikimaɨyekɨ, kwimɨxetakɨ meta mɨxetakɨ mu'uarietɨkakɨ. 'Aruni meta kemariteya kaniutiwewiyani mɨpatsietɨka hetsiena mieme, Yawé Muitsexi kemɨtiuta'aitɨakai. ");
INSERT INTO hch_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Wetsareri 'Aruni kamixaya 'etsimɨnena kaniutawewieni hurukɨ, muxa huxarieya 'uariekame mɨyɨtsikimaɨyekɨ, kwimɨxetakɨ meta mɨxetakɨ, metatsierie rinu 'ixurikiyari 'aixɨa mɨ'anekɨ. ");
INSERT INTO hch_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Huru mekaniutitsuna wewerime mekanayeitɨani, 'etsi'atayeyeume mekaniutixiteni kamixatsie kɨmana memɨtewipakɨ muxa huxarieya yunɨkame mɨyɨtsikimaɨyekɨ, kwimɨxetakɨ meta mɨxetakɨ meta rinukɨ. ");
INSERT INTO hch_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Naiparieyatsie mieme wiwieri meputiwewi kamixa hetsiemieme naitsata kanakayaxixɨani. ");
INSERT INTO hch_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Mɨkɨ hɨiyameya yaxeikɨa 'anemekɨ kaniwewiyakaitɨni, mɨkɨ naitɨ puyuxewiriyakai kamixa matɨa, hurukɨ kaniwewiyakaitɨni meta muxa huxarieya mɨyɨtsikimaɨyekɨ, kwimɨxetakɨ meta mɨxetakɨ, metatsiere rinu 'ixurikiyari 'aixɨa mɨ'anekɨ, mɨpaɨ katiniuyurieni Muitsexi Yawé kemɨtita'aitɨa. ");
INSERT INTO hch_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","'Unitse teteyari mekaneuyatsaxɨani huru hetsie, mɨkɨtsie meha'utɨkaime 'Ixaheri niwemama, tseyu kemɨtiwewiwa hepaɨ. ");
INSERT INTO hch_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Hikɨ kamixa 'etsimɨnena wiwierieyatsie mekanekayatsaxɨani, para 'Ixaheri tɨɨriyamama mema'eriwanikɨ, Yawé Muitsexi kemɨtita'aitɨa. ");
INSERT INTO hch_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Wetsareri kuka kaniutawewieni tawitsie mieme, pɨ'itsekai kamixa 'etsimɨnena hepaɨ, huru hiruyarikɨ xuiyakame, muxa huxarieya mɨyɨtsikimaɨyekɨ, kwimɨxetakɨ meta mɨxetakɨ metatsiere rinu 'ixurikiyari 'aixɨa mɨ'anekɨ pɨwewiyakai, ");
INSERT INTO hch_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","payehutakai, yaxeikɨa heutatetewatɨ, xeitewiyari tsenitimeturuyari heutatetewatɨ. ");
INSERT INTO hch_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Mana peuyatsarie tetexi witsimɨ'anene naukakɨa panukutetɨkatei. Matɨari miemetsie mana patekai tetexi witsi'anenetɨ xetamekɨ, taxaɨyemekɨ, meta tsiɨraɨyemekɨ 'utimerɨkatɨkaitɨ. ");
INSERT INTO hch_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Hutarieka manukukatsie, yuawitɨ tsiɨrauyemekɨ, yuawimekɨ mukutuxie meta tuxamekɨ mutimerɨka. ");
INSERT INTO hch_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Hairieka miemetsieta, merie xetatɨ taxaɨyetɨ, tuxamekɨ kapemaɨyemekɨ meta yɨtsikimaɨyetɨ. ");
INSERT INTO hch_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Naurieka mukukatsieta, taxaɨyetɨ, kwimɨyɨwi, meta tsiɨraɨyetɨ. Mɨkɨ hurutsie witsimɨ'anene pamanekai, ");
INSERT INTO hch_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","tamamata heimana huta teteyari pɨhɨkɨtɨkai, mɨkɨ xexuitɨ 'Ixaheri niwemama pɨwa'inɨaritɨkai, tamamata heimana huta nuiwarite mepa'utɨkatei tseyu hepaɨ. ");
INSERT INTO hch_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Hurukɨ kuka wiwieriyari kaniutiwewiyani, tsarietɨkaitɨ yatɨtɨ. ");
INSERT INTO hch_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Hutatɨ hanira hurukɨ kaniutiwewiyani meta witsi'anenetɨ hetsiena meumarixɨanikɨ, kuka mutatsikuritɨkatsie, ");
INSERT INTO hch_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","hikɨ mana kanewɨtɨaxɨani huru kaunariyari, haniratsie kaneuyehaxɨani kuka hetsie mamanetɨkatsie, ");
INSERT INTO hch_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","mɨkɨ huru kaunariyari hutame mayexaxawatsie kenewiyatsitɨaxɨa kamixa 'etsimɨnenatsie hɨxiena mɨkatɨre. ");
INSERT INTO hch_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Tawarita hutatɨ hanira hurukɨ kaniutiwewiyani, kanewɨtɨaxɨani kuka taɨta miemetsie kamixa 'etsimɨnena hetsie. ");
INSERT INTO hch_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Tawarita hutame hanira kaniutiwewieni hurukɨ, naiparie mukaneniere kanawɨtɨariexɨani kamixa mɨpatsie hɨiyameyari manakuka 'aurie. ");
INSERT INTO hch_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Muxa huxarieya witayarikɨ mɨyɨtsikimaɨyekɨ mɨkɨ hanira mekaniutiwiwitɨani, kamixa mɨpatsie hanirayari meta kuka hanirayari mekaniuhɨaxɨani, kuka hɨiyameyari manukuka muyuhayewanikɨ, mɨkakuyuanenikɨ kamixa mɨpatsietsie, Yawé Muitsexi kemɨtita'aitɨakai. ");
INSERT INTO hch_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Wetsareri 'ixuriki mɨyɨtsikimaɨyekɨ kamixa 'etsimɨnena mɨpatsie kaniutawewieni 'itsariekamekɨ, kamixa 'etsimɨnena heima mieme. ");
INSERT INTO hch_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Hixɨapa hewatitenime kaniuyurieni, mu'u rewatinakeme, muwatixawatsie 'atatenime mɨkayetsanikenikɨ. ");
INSERT INTO hch_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","'Ixuriki tenimeyaritsie petayatsaxɨ putuni, yɨtsikimawime, kwimɨxetakɨ, mɨxetakɨ, meta rinu 'ixurikiyarikɨ 'aixɨa mɨ'ane. ");
INSERT INTO hch_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Meta kapana 'etsipepeme hurukɨ xeikɨa wewiyatɨkaime, tenimeyaritsie kanatawɨre, putunite matawɨrixɨa tsata. ");
INSERT INTO hch_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Kapana 'etsimupepe meta putunite kanatawɨre 'anayeyaxiketɨ, mɨkɨ 'ixuriki tenimeyaritsie, ti'uximayatame menakatɨni hetsiemieme, Yawé Muitsexi kemɨrahɨawekai. ");
INSERT INTO hch_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","'Aruni hetsiemieme meta niwemama wahetsiemieme, kamixa kaniutiwewiyani 'amɨtɨtɨ rinukɨ 'itsarietɨkaitɨ. ");
INSERT INTO hch_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","Kamixa meta mukuretsi rinu 'ixurikiyari pepɨyurieni, hɨiyame 'itsarietɨ pɨyuwiyani naitɨ. ");
INSERT INTO hch_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Hɨiyame rinu 'ixurikiyari kanihɨkɨtɨkaitɨni 'aixɨa mɨ'anekɨ 'itsarietɨ mɨyɨtsikimaɨyekɨ, kwimɨxetakɨ meta mɨxetakɨ, Yawé Muitsexi kemɨtiuta'aitɨa. ");
INSERT INTO hch_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Huru tepɨayari mɨpatsie 'etsiyeume tseyu hepaɨ 'anekame kaniutawewieni, mana katineu'utsieni, «Mɨpatsie Yawé hetsiemieme». ");
INSERT INTO hch_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Hikɨ muxa witayarikɨ yɨtsikimaɨyemekɨ kaniuwiwitɨarieni mukuretsitsie makuwierekɨ, Yawé Muitsexi kemɨtiuta'aitɨa. ");
INSERT INTO hch_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Naitɨ tuki kaniunɨrieni, 'ixaheritsixi yamekateniwewieni Yawé kehepaɨ 'anekame Muitsexi muta'aitɨakai, ");
INSERT INTO hch_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Muitsexi kaniuxeitsitɨarieni tuki, heimana manuka'eimire, 'ixuriki 'amɨyeyeu meta muwa mɨtiyepine, kwatsiturai, mexate 'amatayeyeu, manukuhini, muka'uni meta hetsiena ma'uni, ");
INSERT INTO hch_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","muxatsi wanawiyari 'ɨkariyari mɨxeta, ketsɨte 'amemɨpapa wanawiyari 'ɨkariyari meta 'ixuriki kakuni meukunakai, ");
INSERT INTO hch_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","kakuni meta kɨyexi hetsiena manukuhe meta kanamikieya, ");
INSERT INTO hch_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","mexa mana rapitɨ tita mana mɨtimieme meta paa yamɨramane, ");
INSERT INTO hch_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","kɨxeme 'uitɨwame hurukɨ xeikɨa mɨwewiya meta kɨxeme manuye'u metatsiere tita mana mɨtimieme, meta hatseiti kɨxeme hetsiemieme. ");
INSERT INTO hch_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","Mawari taiyame hurukɨ xeikɨa mɨwewiya, 'ɨkwa witsimu'ɨa, hatseiti mu'utsie mieme mɨpatsie meta 'ixuriki tuki kitenie mieme, ");
INSERT INTO hch_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","mawari taiyariyari wewiwame wurunitsekɨ mɨwewiya meta mayexaxawa hexeiyame, kɨyexieya meta naitɨ tita mɨkɨ mɨreuyehɨwa, maimawame meta hetsiena muyema, ");
INSERT INTO hch_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","takwa kuraru makatsie mieme 'ixuriki mawɨtɨka, kɨyexi muka'utɨka meta hetsiena mawetɨka, 'ixuriki kuraru kitenie meuwie, kaunarite, kɨyexi mukatsutsune kuraru heima mɨranukawerire hetsiemieme, naitɨ tita mɨtiyɨnikekai tuki muyepatsie hetsiemieme 'ixuriki tukiyari, ");
INSERT INTO hch_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","meta kamixate mɨ'itsarietɨka tukita memɨteta'uximayata wahetsiemieme, meta mawari wewiwame 'Aruni kamixateya mɨpatsietɨka meta niwemama mawari wewiwamete wakamixate. ");
INSERT INTO hch_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","'Ixaheritsixi yamekateniutiwewieni Yawé kehepaɨ'anekame Muitsexi muta'aitɨakai. ");
INSERT INTO hch_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Muitsexi, katiniutixeiya tita mɨtiutiwewiyakai, tiuxeiyaka Yawé kehapaɨ ti'aneneme mɨtita'aitɨakai, 'aixɨa katinixeiya. ");
INSERT INTO hch_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Yawé Muitsexi mɨpaɨ katiniutahɨawe: ");
INSERT INTO hch_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","«Mexɨakame metseriyaritsie meta mexɨakame tukaritsie, tuki muyepatsie keneutawewi, 'ixuriki tukiyari. ");
INSERT INTO hch_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Muwa kiita kakuni tɨratuyari keneutateka, 'ixurikikɨ keneukunama. ");
INSERT INTO hch_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Meta mexa muwa keneutaketsa 'aixɨa ketineuketsa. Meta tukita keneutaketsa kɨxeme 'uitɨwame, kɨxeme keneutaiyaxɨa. ");
INSERT INTO hch_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","'Ɨkwa taiyame kakuni hɨxie keneutaketsa, meta 'ixuriki keneuwi tuki kitenietsie. ");
INSERT INTO hch_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","»Mawari taiyame tuki hɨxie keneutaketsa, 'ixuriki tukiyari hɨxie, ");
INSERT INTO hch_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","meta maimawame mana keneutaketsa, mawari taiyame meta 'ixuriki tukiyari wahixɨapa, haa meta kenakatu'a hetsiena. ");
INSERT INTO hch_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Kuraru kenateka waritanatsie, 'ixuriki meta keneuwi kuraru kitenietsie. ");
INSERT INTO hch_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","»Hatseiti mɨtiyupatakɨ ketineu'ɨya, tuki keneukawiri meta naime ketineti'ɨya ketita muwa mɨreyepine, para naitɨ tipatsietɨ mɨrayanikɨ piinite. ");
INSERT INTO hch_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Hatseiti keneuwirita mawari taiyame meta naime mana mɨtiyepine, tinaitɨ tipatsietɨ mɨrayanikɨ. ");
INSERT INTO hch_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Yaxeikɨata maimawame keneuyuri, patsiekame kenayeitɨa meta 'ɨkayari hetsiena muyemare. ");
INSERT INTO hch_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","»Hikɨ 'Aruni kenanuwitɨkita meta niwemama 'ixuriki tukiyari kitenie, mana meke'uti'ɨwa, ");
INSERT INTO hch_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","meta 'Aruni kamixate mɨpatsietɨkakɨ keneutikemaritɨa. Hatseiti keneukawiri mɨtiyupata, mɨtita'uximayatakɨ nemawari wewiwame mayanikɨ. ");
INSERT INTO hch_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Hikɨta niwemama kamixa 'amɨtɨtɨ keniwaranakatɨtɨa, ");
INSERT INTO hch_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","mɨkɨta keniwarukawiri hatseiti mɨtiyupatakɨ wapaapa hepaɨ, mɨkɨ memɨteta'uximayatakɨ nemawari wewiwametekɨ. Kememɨte'ukawiriyarie mɨkɨ pɨ'inɨaritɨni yuheyemekɨ wanuiwari 'umemahu nemawari wewiwamete mepɨhɨkɨtɨni». ");
INSERT INTO hch_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Muitsexi yapɨtiuyuri naime Yawé kemɨtita'aitɨa. ");
INSERT INTO hch_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Mɨpaɨ pauka tuki kaniunɨrieni mexɨakame metseritsie mexɨakame tukaritsie meta hutarieka wiyari 'aye'aku. ");
INSERT INTO hch_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Kepauka tuki Muitsexi mukatsutɨa, kɨyexi hetsiena ma'uni kaniuka'uitɨani, mexa 'amatayeyeu na'uitɨatɨyani meta manukuhini, tuki hɨxie kɨyexi kaniuka'uitɨani, ");
INSERT INTO hch_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","hikɨ 'ixuriki tukitsie kananukawera, heimana tawarita 'a'ayetsuime kananukawera nawi, Yawé kemɨtita'aitɨakai. ");
INSERT INTO hch_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Hikɨ Muitsexi, tɨratu maye'uxa xapayari 'utihurieka kakunitsie kanikayeni, meta kɨyexi kananuye'uitɨani, metatsiere kanamikieya kananukamani. ");
INSERT INTO hch_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Kakuni tukita kaneutateni, 'ixurikikɨta kaneikunani. Mɨkɨ mɨpaɨ katinikweriwayuriekaitɨni kakuni tɨratuyari, Yawé kemɨtita'aitɨakai. ");
INSERT INTO hch_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Muitsexi mexa 'ixuriki tukiyarita 'etsatanatsie kanitikeni tayeta hepatsie, 'ixuriki warita, ");
INSERT INTO hch_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Yawé hɨxieta paa kanamana pareku rekumaneme, Yawé kemɨtita'aitɨakai hepaɨ. ");
INSERT INTO hch_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Kɨxeme 'uitɨwameta tukita kaneutakeni, mexa hɨxie, tuki 'etsatatsie tatsutɨa muyekatsie, ");
INSERT INTO hch_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","'anari kɨxeme kaniutaiyaxɨani Yawé hɨxie, Yawé meripaitɨ kemɨtita'aitɨakai. ");
INSERT INTO hch_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Meta 'ixuriki tukiyarita mɨratimawatɨre hurukɨ xeikɨa mɨwewiya, 'upaitɨ 'ixuriki meuwie hɨxie kaniutakeni, ");
INSERT INTO hch_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","mɨkɨtsie 'ɨkwa witsimu'ɨa kaniutaiya, Yawé kemɨtita'aitɨakai. ");
INSERT INTO hch_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","'Ariketa yatiuyurieka 'ixuriki kaneuwieni tuki kitenie. ");
INSERT INTO hch_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Muitsexi meta mawari taiyame 'akaniutakeni 'ixuriki tukiyari kitenietsie, mana mɨkɨtsie mawarika kaniutitaiya meta hatsi mawariyari, Yawé kemɨtita'aitɨakai. ");
INSERT INTO hch_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Meta maimawame 'akaniutakeni, 'ixuriki tukiyarita meta mawari taiyame wahixɨapa kanitakeni, haa mɨkɨtsie kanikatuani maimawame, ");
INSERT INTO hch_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","hikɨ mana Muitsexi 'Aruni meta yunaitɨ niwemama yumamate yu'ɨkate mekaniutihauxini. ");
INSERT INTO hch_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Kepauka memeutahakekai 'ixuriki tukiyari kitenie yatɨni kepauka mawari taiyame hetsie 'ahurawa memɨkɨkakai mepɨtimaimawakai, Yawé kemɨtiwa'aitɨakai. ");
INSERT INTO hch_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","'Ariketa Muitsexi takwa kaniutawewieni tuki warie kematewatɨka meta mawari taiyame, meta kuraru kitenie 'ixuriki kaneuwieni. Muitsexi 'uximayatsika mɨpaɨ katiniutinɨni. ");
INSERT INTO hch_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Merikɨtsɨ 'ana kwitɨwa haiwitɨri 'ixuriki tukiyari kananukanani, tukita Yawé xawatɨriyaya kaniuyeyerɨni. ");
INSERT INTO hch_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Muitsexi pɨkayɨwekai 'ixuriki tukiyarita meutahani haiwitɨri menukanakaikɨ, meta Yawé xawatɨriyaya tukita mɨhɨnekaikɨ. ");
INSERT INTO hch_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Kepauka tuki hetsie haiwitɨri manuku'ekekai, 'ana 'ixaheritsixi mepuyukuha'aritɨwakai mepekɨkakai. ");
INSERT INTO hch_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Kepauka haiwitɨri mɨka'anuku'ekekai, mepɨkayɨwawekai memɨyekɨne yukiita kayuwatɨ mepɨtetekai. ");
INSERT INTO hch_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Kepauka 'ixaheritsixi memuhukai, Yawé haiwitɨrieya tuki heima kanakatetekekaitɨni tukarikɨ, tɨkarikɨta tai hepaɨ 'anetɨ payeikakai, yunaime 'ixaheritsixi wahɨxie. ");
INSERT INTO hch_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Yawé Muitsexi kaniuta'inieni, 'ixuriki tukiyarita 'ayekaitɨ. Mɨpaɨ katinitahɨawe, ");
INSERT INTO hch_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","yunaime 'ixaheritsixi mɨpaɨ mɨtiwatahɨawekɨ: «Kepauka xeme xewitɨ 'imikieri mawariyari mɨyetuani Yawé hetsiemieme, wakaxi yatɨni muxa pɨhɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","»Mawari taiyariyari xemɨwewienikɨ xɨka tewa hɨkɨtɨni mɨkɨ pu'ukitɨni 'aixɨa mɨ'ane pɨhɨkɨtɨni, 'ixuriki tukiyari kitenie hɨxie xekene'atɨa mawari taiyariyari mayanikɨ. Yawé muwa kanitanaki'erimɨkɨ. ");
INSERT INTO hch_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","'Ana tita mɨtitimawa hetsie yumamakɨ mu'uyatsie peutimeni, mɨtanaki'eriwakɨ hetsiena mieme meta mɨxɨnarieni mawariyari mayanikɨ. ");
INSERT INTO hch_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","'Anake Yawé hɨxie tsikeru mekaniwaxitekuni, mawari wewiwamete 'Aruni niwemama xuriya mekwewieme mawari taiyame 'aurie mepeyeurietɨkɨne, 'ixuriki tukiyari kitenie hɨxie muwetsie. ");
INSERT INTO hch_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Meta wakaxi mi'atɨa kanitakwipiemɨkɨ meta tinaime pɨtiwayewitexɨani. ");
INSERT INTO hch_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","'Aruni niwemama, mawari wewiwamete, mawari taiyametsie kɨyexikɨ mepakanaini, ");
INSERT INTO hch_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","hikɨ wai muwitekietɨka 'aixɨa mepɨteyatsa tai mɨta'a heima mawari taiyametsie, mu'u nɨkame meta wiyayari, ");
INSERT INTO hch_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","kwinurieya meta 'ɨkateya hakɨ pɨtitihauxinire, mɨkɨ mawari wewiwame mawari taiyametsie naime pɨtitaiya. Mɨkɨ mawari naitɨ taiyariyariekame kanihɨkɨtɨni, 'imikieri taipa kwaxiyariekame witsimu'ɨa Yawé minake. ");
INSERT INTO hch_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","»Xɨka xewitɨ mawari taiyariyari 'ixatɨani tuuru, yatɨni muxa 'uki, yatɨni tsipu 'uki pɨhɨkɨtɨni 'aixɨa mɨ'ane. ");
INSERT INTO hch_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Yawé hɨxie mekaniwaxitekuni mawari taiyame tayeta hepatsie, 'Aruni niwemama mawari wewiwamete xuriya mekwewieme mawari taiyame 'aurie mekaneyeurietɨkɨnikuni. ");
INSERT INTO hch_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Hikɨ puwayewitexɨani, hikɨ mawari wewiwame 'aixɨa katiniyatsamɨkɨ kɨyexi mɨtatɨkatsie heima mawari taiyametsie, mu'u nɨkame meta wiyayari. ");
INSERT INTO hch_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Yaxeikɨata kwinurieya meta 'ɨkateya hakɨ pɨtihauxinire, hikɨ mawari wewiwame naime tikuxeɨrieme mawari taiyametsie pɨtititaiya. Mɨkɨ mawari naitɨ taiyariekame kanihɨkɨtɨni, Yawé mawari mɨyetuiriyarɨwa taipa mieme witsimu'ɨa kanihɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","»Xɨka xewitɨ memɨte'awɨwawe Yawé yetuirieni mawari taiyariyari mayanikɨ, xeime kukuru yatɨni xeime haɨmɨ pixatɨani. ");
INSERT INTO hch_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Mawari wewiwame kukuru panutuni mawari taiyametsie mana mu'uya panutiteke, meta mawari taiyametsie pitataiya. Hikɨ xuriyaya mawari taiyame 'aurie kanayepɨnamɨkɨ, ");
INSERT INTO hch_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","yaxeikɨata 'inɨaya kanayehanimɨkɨ meta kwinurieya, mawari taiyame 'etsatana tau manatineika hepatsie naxi meukawiwiwatsie paitɨ kaneiwiwimɨkɨ. ");
INSERT INTO hch_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Hikɨ 'anateyatsie tiwietɨ tawieya kananutaxitemɨkɨ 'anateya kawayetsanatɨ. Hikɨ mawari wewiwame mawari taiyametsie kanitataiyamɨkɨ, tai heima. Mɨkɨ mawari naitɨ taiyariekame kanihɨkɨtɨni, Yawé mawari mɨyetuiriyarɨwa taipa mieme witsimu'ɨa. ");
INSERT INTO hch_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","»Xɨka xewitɨ tɨriku mawariyari Yawé hetsiemieme yetuamɨkɨ, mɨkɨ tɨriku mɨtɨxiyari 'aixɨa mɨ'ane pɨhɨkɨtɨni, hetsiena huriwa hatseitiyari peutituani meta 'ɨkwa witsimu'ɨa. ");
INSERT INTO hch_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Hikɨ 'Aruni niwemama mawari wewiwamete wahetsɨa kaniyetuamɨkɨ, mana xeimamayari panatituni harina witsimɨ'ane hatseiti mɨnɨ'ɨ meta 'ɨkwa witsimu'ɨa nɨkame, hikɨ mawari wewiwame 'imikieri ma'eriwa mawariyari mawari taiyametsie kanitataiyamɨkɨ. Mɨkɨ mawari Yawé mɨyetuiriyarɨwa taipa mieme witsimu'ɨa kanihɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Tɨriku mɨtɨxiyari mawariyari muyuhayewa, 'Aruni meta niwemama wahetsiemieme katinayeimɨkɨ. Mɨkɨ 'imikieri taipa warɨkariekame Yawé hetsɨa mɨyetuiya, 'ikɨ pɨhɨkɨ waɨkawa mɨpatsie. ");
INSERT INTO hch_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","»Kepauka xewitɨ tɨriku mɨtɨxiyari mawariyari mukwaxiyarie mɨyetuani huxunuta mieme, mɨkɨ paa 'aixɨa mɨ'anene pɨhɨkɨtɨni tikuxanariyame mɨkanɨ'ɨ, huriwa hatseitiyarikɨ xeɨkɨa pɨhawiyarieka meta paa huriwa hatseitiyari pɨwiriyarietɨkani. ");
INSERT INTO hch_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","»Xɨka tɨriku mɨtɨxiyari mawariyari xakɨtsie mukwaxiyarie xeyetuani, mɨkɨ 'imikieri tɨriku mɨtɨxiyari 'aixɨa mɨ'ane pɨhɨkɨtɨni tikuxanariyame kanɨkame, hatseitikɨ xeikɨa hawiyariekame. ");
INSERT INTO hch_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Yayeyeume xepɨtitaraxɨani meta hatseiti xepanutituani. Mɨkɨ tɨriku 'imikieri mawariyari mɨhɨkɨkɨ. ");
INSERT INTO hch_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","»Xɨka tɨriku mɨtɨxiyari mawariyari xarita kwaxiyariekame pe'ixatɨani, mɨkɨ 'imikieri harina mɨtɨxiyari 'aixɨa mɨ'ane pɨhɨkɨtɨni hatseitikɨ xeikɨa pɨhawiyarieka. ");
INSERT INTO hch_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Tɨriku 'imikieriyari mɨpaɨ reukuwewiyakame xepɨ'atɨani Yawé hetsɨa, hikɨ mawari wewiwame pepɨyetuirieni, mɨkɨ pɨyɨaneni mawari taiyametsie miyetuani. ");
INSERT INTO hch_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Mawari wewiwame mɨkɨ 'imikieri yapaɨmeme 'anatitume mawari ma'eriwa mɨhɨkɨtɨnikɨ, mawari taiyametsie pitataiya. Mɨkɨ 'imikieri Yawé mɨyetuiriyarɨwa taipa mieme witsimu'ɨa kanihɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Tɨriku mɨtɨxiyari mawariyari muyuhayewa, 'Aruni meta niwemama wahetsiemieme kanayeimɨkɨ. Mɨkɨ 'imikieri taipa warɨkariekame Yawé hetsɨa mɨyetuiya, mɨkɨ pɨhɨkɨ waɨkawa mɨpatsie. ");
INSERT INTO hch_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","»Xeme 'imikieri Yawé xemɨyetuirieni tikuxanariyame pɨkanɨka, xiete meta tikuxanariyame pɨkatitaiyarɨwani mɨkɨ 'imikieri Yawé mɨyetuiriyarie taipa mieme mɨhɨkɨkɨ. ");
INSERT INTO hch_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Xiete meta tikuxanariyame Yawé xepɨte'anutɨkirieni mawari matɨari mieme mayanikɨ, peru mɨkɨ mawari taiyametsie xepɨkatehapineni witsimu'ɨa hepaɨ. ");
INSERT INTO hch_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Naime 'imikieritetsie xemiyetuirieni pɨti'unamatɨkani, hatsuaku xekakaɨyari tɨratuyatsie 'una heuyewetɨ pɨkahayeikani. Naime mɨkɨ 'imikierite pɨti'unamatɨkani. ");
INSERT INTO hch_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","»Xɨka Yawé 'imikieri matɨari tɨriku mɨtikaxuawere xexatɨakuni, mɨkɨ tɨriku mɨhehekwa pɨhɨkɨtɨni, meta pɨtɨxieka yaxeikɨata xatɨtsie pɨxarikietɨkani. Mɨkɨ mexɨakame 'imikieriyari mɨhɨkɨkɨ. ");
INSERT INTO hch_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Mɨkɨ 'imikieritetsie huriwa hatseitiyari meta 'ɨkwa witsimu'ɨa pepanutituani. ");
INSERT INTO hch_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Mawari wewiwame tɨriku mɨhehekwa meta mɨtɨxiyari yapaɨmeme pɨtitaiya mawari ma'eriwa mɨhɨkɨtɨnikɨ, huriwa hatseitiyari meta 'ɨkwa witsimu'ɨa naime yɨnɨkame. Mɨkɨ 'imikieri taipa mieme Yawé muxatɨarie kanihɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","»Xɨka xewitɨ Yawé tuuru yetuirieni 'aixɨa memɨteyuxeiyanikɨ mawariyari, kanixatɨamɨkɨ 'aixɨa 'aneme tsepa mɨtituuru yatɨni tsepa mɨtiwakaxi. ");
INSERT INTO hch_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Kemɨ'ane 'imikieri mɨyetuani mɨkɨ wakaxi muwaxitekieni mu'uyatsie peutimeni, mɨranutahakitɨretsie 'ixuriki tukiyari manuwe hɨxie. Hikɨ 'Aruni niwemama mawari wewiwamete, xuriya mekwewieme mawari taiyame 'aurie mepeyeurietɨkɨne. ");
INSERT INTO hch_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Kemɨ'ane miyetuani Yawé hetsɨa, 'imikieri taipa kuaxiyariekame, 'ikɨ 'imikieri 'aixɨa memɨteyuxeiyanikɨ mawari pɨhɨkɨ: wiya meta kwinuri naime mɨ'eimatɨka piyetuirieni, ");
INSERT INTO hch_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","mumé muhuta wiyayari mi'eimatɨka, meta wiya katutsitɨana mieme, meta wiya nemaya heimana mɨkawere, mɨkɨ pɨrayehapanieni mumé muhuta yɨnɨkame. ");
INSERT INTO hch_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Hɨkɨ 'Aruni niwemama naime 'ikɨ mawari taiyametsie mekatenititaiyakuni, mawari taiyariyari heima matita'a muyekatsie. Mɨkɨ mawari Yawé mɨyetuiriyarɨwa taipa mieme witsimu'ɨa kanihɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","»Xɨka mawari 'aixɨa memɨteyuxeiyanikɨ mɨyetuani tuuru hɨkɨtɨni, kemɨ'ane miyetuani Yawé kaniyetuiriemɨkɨ 'aixɨa 'aneme, tsepa mɨtiwakaxi yatɨni mɨtituuru. ");
INSERT INTO hch_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Xɨka 'imikieri muxa hɨkɨtɨni, Yawé hɨxie xepiyetuani, ");
INSERT INTO hch_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","mu'uyatsie putimeni 'anake pimieni 'ixuriki tukiyari manuwe hɨxie. Hikɨ 'Aruni niwemama xuriyaya mawari taiyame 'aurie mepayeurietɨkɨne. ");
INSERT INTO hch_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Kemɨ'ane mɨtiyetuani Yawé hetsɨa 'imikieri taipa kwaxiyariekame, 'ikɨ mawaritsie mieme yamɨtipaɨme pɨtihɨkɨtɨni: wiya meta kwaxieya naimime, (tsutɨanapaitɨ kanexitemɨkɨ), wiya meta kwinuri naime mɨ'eimatɨka piyetuirieni, ");
INSERT INTO hch_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","mumé muhuta wiyayari mi'eimatɨka, meta wiya katutsitɨana mieme, meta wiya nemaya heimana mɨkawere, mɨkɨ pɨrayehapanieni mumé muhuta yɨnɨkame. ");
INSERT INTO hch_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Hikɨ mawari wewiwame mɨkɨ naime mawari taiyametsie katinititaiyamɨkɨ. Mɨkɨ 'ikwai kanihɨkɨtɨni, mawari taipa warɨkarietɨ Yawé hetsɨa mɨyetuiwa kanihɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","»Xɨka tsipu 'uka hɨkɨtɨni mawari 'imikieri mayanikɨ Yawé hɨxie piyetuani. ");
INSERT INTO hch_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","Mu'uyatsie putimeni, 'anake 'ixuriki tukiyari manuwe memanutakɨka hɨxie penutixiteni. Hikɨ 'Aruni niwemama xuriyaya mawari taiyame 'aurie mepayeurietɨkɨne. ");
INSERT INTO hch_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Kemɨ'ane mɨtiyetuani Yawé hetsɨa 'imikieri taiyariyari, mɨkɨ pɨtihɨkɨtɨni: wiya meta kwinuri naime mɨ'eimatɨka piyetuirieni, ");
INSERT INTO hch_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","mumé muhuta wiyayari mi'eimatɨka, meta wiya katutsitɨana mieme, meta wiya nemaya heimana mɨkawere, mɨkɨ pɨrayehapanieni mumé muhuta yɨnɨkame. ");
INSERT INTO hch_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Hikɨ mawari wewiwame naime mɨkɨ mawari taiyametsie katinititaiyamɨkɨ. Mɨkɨ 'imikieri taiyariyari Yawé minake witsimu'ɨa kanihɨkɨtɨni, mɨkɨ naitɨ wiya Yawé hetsɨa kanimiemetɨni. ");
INSERT INTO hch_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","»'Ikɨ kanihɨkɨtɨkamɨkɨ 'aitsika xexiɨyarima wahetsie mieme yamemɨtekahunikɨ, tsepa hakewa xemetiteni. Xuriya xepɨkakwa'ani meta wiya». ");
INSERT INTO hch_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Yawé Muitsexi mɨpaɨ katiniuta'aitɨani ");
INSERT INTO hch_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","'ixaheritsixi mɨpaɨ mɨtiwatahɨawekɨ: «Kepauka xewitɨ 'atsikatimaitɨ Yawé 'aitsikayatsie 'axamɨtiyurieni, tixaɨtɨkɨ kemɨkareuyewetse xɨka tiuyurieni, mɨkɨ 'ipaɨ pɨta katiniyurimɨkɨ: ");
INSERT INTO hch_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","»Xɨka xewitɨ mawari wewiwame Kakaɨyari menayexei 'axatiuyurieni, yunaitɨ teɨteri wahetsie katinahɨiyamɨkɨ, mɨkɨ mawari Yawé kaniwewiriemɨkɨ tsikeru 'aixɨa 'aneme kanitimawamɨkɨ mɨ'itiyanikɨ. ");
INSERT INTO hch_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Yawé hɨxie tsikeru kananuhanimɨkɨ, 'ixuriki tukiyari manuwe mɨrayutixexeɨritɨre pi'atɨani mɨranutakɨkatɨretsie, 'ana tsikeru mu'uyatsie 'utimetɨ Yawé hɨxie puwaxiteni. ");
INSERT INTO hch_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Mawari wewiwame manayexeiyarie tsikeru xuriyaya yapaɨmeme kwewieme 'ixuriki tukiyari manuweta paitɨ penuhana. ");
INSERT INTO hch_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Yu'itɨwamekɨ xuriyata peukameni, 'anari 'atahutamexɨa pei'ɨyaxɨani 'ixuriki meuwie hepatsie Yawé hɨxie. ");
INSERT INTO hch_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Hikɨ mawari wewiwame mawari taiyame 'awateya naukametsie xuriya panuwiriexɨani 'ɨkwa witsimu'ɨa Yawé hɨxie muwe, 'ixuriki tukiyarita mɨrewayutixexeɨritɨre. Hikɨ tsikeru xuriyaya muyuhayewa mawari taiyame 'ɨkateyatɨa pitiyeurieni, 'ixuriki tukiyari manuwe hɨxie mɨranutakɨkatɨretsie muwe. ");
INSERT INTO hch_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Hikɨ, tsikeru mumierie 'itiya mawariyari hetsiemieme, naime wiyaya kwinuriteya mɨ'eimatɨka mepɨtehayepini, ");
INSERT INTO hch_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","mumé muhuta wiyayari mi'eimatɨka, meta wiya katutsitɨana mieme, meta wiya nemaya heimana mɨkawere, mɨkɨ pɨrayehapanieni mumé muhuta yɨnɨkame. ");
INSERT INTO hch_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","Mɨpaɨ xekateniyurikuni tuuru hetsie 'aixɨa memɨteyuxeiyanikɨ mawariyari wiyaya kexemɨte'ayepine hepaɨ. Hikɨ mawari wewiwame naime mɨkɨ mawari taiyametsie katinititaiyamɨkɨ, ");
INSERT INTO hch_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","peru naitɨ mɨtiyuhayewa nawiyari, waiyari, mu'uya, 'ɨkateya, kwinurite meta kwitaya, ");
INSERT INTO hch_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","Mɨkɨ naitɨ mutiuyuhayewaxɨ tsikeru hetsie timieme, yateewa paitɨ xepenuyetuni maku'itiyarietsie, mɨkɨ naxi matiwiwiwatsie taipa mɨratitaiyarɨwatsie xepitiwiwieni naitɨ mɨtaxɨnikɨ. Naxi matiwiwiwatsie kanitaxɨmɨkɨ. ");
INSERT INTO hch_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","»Xɨka yunaitɨ 'ixaheritsixi 'atsimekatemaitɨ 'axamete'uyurieni, 'ana yunaitɨ memɨyukuxexeɨriwa wahetsie pɨrahɨiyaka Yawé 'aitsikaya kemɨra'imawa memɨka'anu'enikɨ. ");
INSERT INTO hch_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Xɨka kwitɨwa mɨkɨ yameteheyutimani kename 'atsimekatemaitɨ 'axamete'uyuri, 'ana tsikeru 'aixɨa mɨ'ane mekanitimawakuni memɨ'itiyanikɨ, 'ixuriki tukiyari manuwe hɨxie mekanenuhanikuni, ");
INSERT INTO hch_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","hikɨ kiekatari 'ukirawetsixi, mana tsikeru mu'uyatsie mekaniutimeikuni, 'ana mekaniwaxitekuni Yawé hɨxie. ");
INSERT INTO hch_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Hikɨ mawari wewiwame Kakaɨyari menayexei, tsikeru xuriyaya yapaɨmeme kwewieme 'ixuriki tukiyarita paitɨ penuhana, ");
INSERT INTO hch_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","yu'itɨwamekɨ xuriyata peukameni, 'anari 'atahutamexɨa pei'ɨyaxɨani 'ixuriki meuwie hepatsie Yawé hɨxie. ");
INSERT INTO hch_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","'Arikeketa mawari taiyame 'awateyatsie xuriya 'etsiwa panuwiriexɨani, 'ɨkwa witsimu'ɨa Yawé hɨxie muwe, 'ixuriki kiiyarita. Xuriya muyuhayewa mawari taiyame hetɨa kanitiyeurimɨkɨ, 'ixuriki kiiyari manuwe hɨxie mɨranutahakitɨretsie muwe. ");
INSERT INTO hch_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Yaxeikɨata mawari wewiwame naime wakaxi wiyayari payetuni, 'ana mawari taiyametsie pitataiya, ");
INSERT INTO hch_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Yaxeikɨa tsikeru hetsie mɨrayepine xepɨte'anatipini 'itiya mawariyari xemɨte'uwewi hepaɨ. Mɨpaɨ mawari wewiwame mɨkɨ memɨ'itiyanikɨ pɨtiwewieni wahetsiemieme, mɨkɨ mepɨteheuyehɨwiyarieni. ");
INSERT INTO hch_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Hikɨ tsikerutsie timieme mɨtiyuhayewaxɨ naime pɨranuyepini yateewa memakuteitsie taipa pihayewa mɨtixɨnikɨ, xewitɨ tsikeru kemɨrayepiniyarie hepaɨ. 'Ikɨ kanihɨkɨtɨni 'itiya mawariyari yunaitɨ memuyutixexeɨriwa wahetsiemieme. ");
INSERT INTO hch_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","»Xɨka xewitɨ kiekari mɨhɨritɨarie 'axatiuyurieni 'atsikatimaitɨ Yawé xekakaɨyari 'aitsikayatsie kemɨra'imawa, hetsiena pɨrahɨiyaka. ");
INSERT INTO hch_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","Kepauka yamɨreyutimani kename 'axatiuyuri, 'ana penuhana xeime tsipu 'ukitɨme 'aixɨa 'anekame mawari mayanikɨ. ");
INSERT INTO hch_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","'Ana mu'uyatsie 'utimeme Yawé hɨxie kaniwaxitemɨkɨ, hakewa memanutixitewa mawari taiyariyari mayanikɨ. Mɨkɨ memɨ'itiyani mawariyari pɨ'ayumieme. ");
INSERT INTO hch_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Hikɨ mawari wewiwame 'itiya mawariyari xuriyayatsie yu'itɨwame heuketsatɨ mawari taiyame 'awateyatsie penuwiriexɨani, kwitɨta xuriya muyuhayewaxɨ mawari taiyame 'ɨkateya hetɨa pitiyeurieni. ");
INSERT INTO hch_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Kwitɨta mawari taiyametsie naime tsipu wiyayari pɨtataiya, mawari memuyuxewinikɨ mawariyari mɨtiuwewiwa hepaɨ. Mɨpaɨ mawari wewiwame 'itiya pɨtiwewieni kiekari mɨhɨritɨarie 'axamɨtiuyurikɨ pɨreuyehɨwiyarieni. ");
INSERT INTO hch_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","»Xɨka tewi mana kiekametɨtɨ 'axatiuyurieni 'atsikatimaitɨ, Yawé 'aitsikaya kemɨra'imawakɨ, hetsiena pɨrahɨiwani. ");
INSERT INTO hch_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","Kepauka yamɨreyutimani kename 'axatiuyuri, kaneuyeweka miyetuani tsipu 'ukatɨme 'aixɨa mɨ'ane 'axamɨtiuyurikɨ kɨmana mɨreuyehiwiyarienikɨ. ");
INSERT INTO hch_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Hikɨ tsipu mu'uyatsie putimeni, kaniwaxitemɨkɨ hakewa memanutixitewa mawari taiyariyari mayanikɨ. ");
INSERT INTO hch_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Hikɨ mawari wewiwame xuriyatsie yu'itɨwame heuketsatɨ 'etsiwa mawari taiyame naitsata 'awateyatsie pawiriexɨani, hikɨ xuriya muyuhayewa mawari taiyame hetɨa pitiyeurieni. ");
INSERT INTO hch_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Hikɨ tsipu wiyayari naime mepayetuni 'aixɨa memɨteyuxeiyanikɨ mawariyari kememɨteheyetu'iriwa hepaɨ, hikɨ mawari wewiwame naime mawari taiyametsie kanitataiyamɨkɨ, witsimu'ɨa Yawé minake mɨhɨkɨ. Mɨpaɨ mawari wewiwame 'itiya hetsiena mieme pɨtiwewieni, mɨkɨ ke'axamɨtiuyurikɨ pɨreuyehɨwiyarieni. ");
INSERT INTO hch_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","»Xɨka tewi muxa yetuani mɨ'itiyani mawariyari mayanikɨ, mɨkɨ muxa 'uka 'aixɨa mɨ'ane pɨhɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Muxa mu'uyatsie 'utimetɨ kaniwaxitemɨkɨ 'itiya mawariyari mayanikɨ, hakewa memanutixitewa mawari taiyariyari mayanikɨ. ");
INSERT INTO hch_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Hikɨ mawari wewiwame 'itiyari mawariyari xuriyayatsie yu'itɨwame heuketsatɨ mawari taiyame 'awateyatsie panuwiriexɨani, kwitɨta xuriya muyuhayewaxɨ mawari taiyame 'ɨkateya hetɨa naime pɨtiyeurieni. ");
INSERT INTO hch_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Kwitɨta tsipu wiyayari naime mepayetuni, muxa wiyayari 'aixɨa memɨteyuxeiyanikɨ mawariyari memɨte'ayetu'iri hepaɨ, mawari wewiwame mawari taiyametsie pitataiya 'imikieri mawari taipa warɨkarietɨ Yawé hetsiemieme mɨyetuiya heima. Mɨpaɨ mawari wewiwame mɨkɨ tewi hetsiemieme 'itiya pɨtiwewieni, ke'axamɨtiuyuriekaikɨ pɨreuyehɨwiyarieni. ");
INSERT INTO hch_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","»Xɨka xewitɨ xeme 'anayexeiyarieni heitserie mɨtitaxatakɨ tita mɨtiuxei meta tita mutiu'eni hepaɨtsita, xɨka yuku'imawani katixatamɨtɨ pɨtika'eniexɨani 'axamɨtiuyurikɨ. ");
INSERT INTO hch_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","»Yaxeikɨa xewitɨ xɨka 'atsikatimaitɨ mɨtimɨki tiumayɨani, tewatsiekame yatɨni yeutanaka meta yutawima mukuyeika, mɨkɨ ka'itiyatɨ kanayuyeitɨamɨkɨ hetsiena katinahɨiyamɨkɨ tsepa 'atsimɨkaretima. ");
INSERT INTO hch_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","»Xɨka xewitɨ 'atsikatimaitɨ tewi mɨka'itiya 'umayɨani waiyarieyatsie, tsepatitakɨ mɨkɨ mɨkati'itiya, mɨkɨta ka'itiyatɨ payuyeitɨani. Xɨka 'arike mɨpaɨ retimani hetsiena pɨtiuhɨiwani. ");
INSERT INTO hch_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","»Xɨka xewitɨ 'atsikatimaitɨ 'uyutakeni 'ipaɨ tiyɨhɨritɨatɨ, mexɨa niuki wewietɨ 'aixɨa mɨtiyurienikɨ, yatɨni 'axamɨtiyurienikɨ, matsi xɨkaratɨmaiya, hetsiena katinahɨiyamɨkɨ kepauka mɨkɨ meye'erienitsie. ");
INSERT INTO hch_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","»Kemɨ'ane hetsiena mɨrahɨiwa 'ikɨ naime hepaɨtsita, kaneuyeweka muyutahekɨatakɨ ke'axamɨtiuyurikɨ, ");
INSERT INTO hch_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","meta peuyewetse Yawé mawari mɨwewirienikɨ hetsiena mɨtiuhɨiwa mawariyari xeime muxa 'ukatɨme yatɨni kapɨra 'axakemɨtiuyurikɨ. Mɨpaɨ mawari wewiwame 'itiya pɨtiwewieni 'axamɨtiuyurikɨ. ");
INSERT INTO hch_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","»Xɨka xewitɨ muxa mɨnanenikɨ ka'i'axeni, Yawé pɨta panutɨkirieni yuhutame weuraixi yatɨni haɨmɨxi mɨrayukatuani mawariyari ke'axamɨtiuyurikɨ. Xewitɨ mɨkɨ mɨ'itiyanikɨ mawariyari payani, xewitɨta mawari taiyariyari payani. ");
INSERT INTO hch_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Mawari wewiwame hetsɨa pɨwa'atɨani, mɨkɨ waurai meri pɨyetuiyani mɨ'itiyanikɨ mawariyari mayanikɨ. Hikɨ kɨipieya puwakuhirumina mu'uya ka'anutiteketɨ. ");
INSERT INTO hch_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Kwitɨwata 'itiya mawariyari xuriyayakɨ 'etsiwa xeitapatsie mawari taiyame peuta'ɨya, meta xuriya muyuhayewa mawari taiyame hetɨa pɨta'ipakieni. Mɨkɨ 'itiya mawariyari pɨhɨkɨ. ");
INSERT INTO hch_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","'Utɨmana miemeta mawari wewiwame kanitataiyamɨkɨ 'aitsika kemaine. Mɨpaɨ mawari wewiwame 'itiya pɨtiwewieni, 'ana ke'axamɨtiuyurikɨ pɨreuyehɨwiyarieni. ");
INSERT INTO hch_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","»Yatɨni matsi yuhutame weuraixi meta haɨmɨxi pɨkatiwa'axe, huta kiruyari tɨriku mɨtixiyari 'aixɨa mɨ'ane pɨta pɨ'atɨani 'itiya mawariyari mayanikɨ. Huriwa hatseitiyari pɨka'inɨituani meta 'ɨkwa witsimu'ɨa, mɨkɨ 'itiya mawariyari kanihɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Mawari wewiwame hetsɨa pi'atɨani, mɨkɨta yumamakɨ yapaɨmeme 'anatitume ma'eriwanikɨ mawariyari, 'ana mawari taiyametsie naime yɨnɨkame pɨtitaiya Yawé hɨxie. Mɨkɨ 'itiya mawariyari pɨhɨkɨ. ");
INSERT INTO hch_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Mɨpaɨ mawari wewiwame 'itiya pɨtiwewieni ke'axamɨtiuyuritsie mieme mɨpaɨ mɨkɨ pɨreuyehɨwiyarieni. Mawari muyuhayewa mawari wewiwame hetsiemieme payani, yaxeikɨa tɨriku hatsiyari mawariyari hepaɨ». ");
INSERT INTO hch_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Merikɨtsɨ Yawé Muitsexi mɨpaɨ katiniutahɨawe: ");
INSERT INTO hch_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","«Xɨka xewitɨ tewi 'atsikatimaitɨ 'axatiuyurieni Yawé tipiinieya mɨtipatsietɨka hepaɨtsita, kaneuyeweka muxa 'uki Yawé manuhanirienikɨ 'aixɨa 'aneme 'imikieri mɨrayukatuani mawariyari mayanikɨ. Pɨrata tukita keraye'akamekɨ memɨteyukutuaya hepaɨ, 'ikɨ mawari mɨrayukatuani mawariyari pɨhɨkɨ. ");
INSERT INTO hch_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Mɨyatiyurieme, mɨkɨ tewi pɨrayukatuani ke'axamɨtiuyurikɨ Kakaɨyari tipiinieya mɨtipatsietɨkatsie timiemekɨ, 'auxɨwimeyaritsie mieme xei'inɨariyari mawari wewiwame kaniyetuiriemɨkɨ. Mɨpaɨ mawari wewiwame 'itiya pɨtiwewieni tewi hetsiemieme muxa 'ukikɨ mɨrayukatuani mawariyari mayanikɨ, 'ana pɨreuyehɨwiyarieni ke'axamɨtiuyurikɨ. ");
INSERT INTO hch_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","»Xɨka xewitɨ 'atsikatimaitɨ 'axatiuyurieni Yawé 'aitsikaya kemɨkahainetsie, tsepa 'atsikatiuyurieme muyu'erie tiuka'eniwatɨ payani 'axamɨtiuyurikɨ. ");
INSERT INTO hch_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Mɨkɨ muxa 'uki 'aixɨa mɨ'ane panuhana mawari wewiwame hetsɨa, mɨkɨ mɨrayukatuani mawariyari kemɨtika'inɨari kaniyetuamɨkɨ. Mɨpaɨ mawari wewiwame 'itiya pɨtiwewieni hetsiena mieme mɨkɨ 'axakemɨtiuyurikɨ 'atsikatimaitɨ, 'ana mɨkɨ pɨreuyehɨwiyarieni. ");
INSERT INTO hch_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","'Ikɨ mɨrayukatuani mawariyari kanihɨkɨtɨni, kemɨ'ane yurikɨ hetsiena mɨtiuhɨiya 'axamɨtiuyurikɨ Yawé hepaɨtsita». ");
INSERT INTO hch_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Yawé Muitsexi mɨpaɨ katiniutahɨawe: ");
INSERT INTO hch_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","«Xɨka xewitɨ hetsie rahɨiyani 'axakatiniyurimɨkɨ Yawé hepaɨtsita, 'aixɨa katiɨ'ɨwiyaka kepauka hepaɨna tewi tixaɨtɨ tihɨritɨaku, yatɨni tinawatsirieni, yatɨni waɨriyarika tinawairieni tita mɨkɨ mɨtipiinieya, ");
INSERT INTO hch_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","yatɨni xɨka tixaɨtɨ retaxeiyame reuyehɨiyaku kename kaheixeiya 'utayɨni yakɨ'utaitɨ yɨhɨritɨani yamɨti'iyamatekɨ xeikɨa, ");
INSERT INTO hch_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","kemɨ'ane 'ikɨ mɨyapaɨmeme hepaɨtsita yuhepaɨ tewi mukwamanaxɨ mɨkɨ hetsiena pɨrahɨiyani. Mɨkɨ tewi piiniteya mɨtinawatsiri tihɨritɨaku katiniyetuiriemɨkɨ. Meta tita waɨriyarika mɨtinawairi, yatɨni tita reuyehɨiyaku mɨtiutaxei mɨka'itaxa, yatɨni tixaɨtɨ tiutaxeiyaka kename kaheixeiya 'utaitɨ, ");
INSERT INTO hch_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","yanutsu tsepa titakɨ yuhɨritɨatɨ tiu'itani. 'Ayumieme pɨtiyetuani heitseriemekɨ meta 'auxɨwimeyaritsie mieme xei'inɨariyari kaniyetuamɨkɨ tita mɨrexeiyani. Naime 'ikɨ kutsiyarieya katiniyetuiriemɨkɨ kepauka mɨrayukatuani mawariyari muwewienitsie. ");
INSERT INTO hch_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Yawé panuhanirieni muxa 'uki 'aixɨa mɨ'ane, mɨrayukatuani mawariyari kemɨtika'inɨari kaniyetuamɨkɨ. 'Ana mawari wewiwame pɨyetuirieni, ");
INSERT INTO hch_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","mɨkɨ 'itiya mɨwewienikɨ Yawé hɨxie tewi hetsiemieme, tsepa titakɨ hetsiena mɨrahɨiwa pɨreuyehɨwiyarieni». ");
INSERT INTO hch_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Yawé Muitsexi mɨpaɨ katiniutahɨawe ");
INSERT INTO hch_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","'Aruni meta niwemama mɨpaɨ mɨtiwatahɨawekɨ: «'Ikɨ 'inɨari niukiyari kanihɨkɨtɨni mawari taiyariyaritsie mieme: Mawari taiyariyari pɨtaka mawari taiyametsie tɨkarikɨ kepaukake mɨkataretsie. ");
INSERT INTO hch_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Mawari wewiwame rinu kamixayari panakatɨni meta weruxiyari yukamixa hetɨa, hikɨ mawari taiyariyari naxiyari kanikuxeɨrimɨkɨ, mawari taiyame 'aurie pitiyeni. ");
INSERT INTO hch_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Hɨkɨ kamixate mawari hetsiemieme mɨranakatɨkɨkai kananutihɨnaxɨamɨkɨ, hipameta kamixate ranakatɨme mematiteitsie naxi panuyetuni, hakewa maku'itiyarietsie penutuni. ");
INSERT INTO hch_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Mawari taiyametsie tai yapɨtitaka mepɨka'ikutɨtsani. Mawari wewiwame matsi kɨyexi panutixɨrɨwani ximeri meta mawari taiyame heima mawari taiyariyari 'aixɨa pɨtiteni heimana 'aixɨa memɨteyuxeiyanikɨ mawariyari wiyayari mɨtataiyakɨ. ");
INSERT INTO hch_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Tai mawari taiyametsie mieme hatsuaku tɨma pɨkahanukatɨtɨtseni, yuheyemekɨ yapɨtitaka. ");
INSERT INTO hch_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","»'Ikɨ 'inɨari niukiyari kanihɨkɨtɨni tɨriku mawariyaritsie mieme: 'Aruni niwemama Yawé hɨxie, mawari taiyametsie mekaniyetuiriekuni. ");
INSERT INTO hch_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Mawari wewiwame xeimamayari 'imikieri mawariyari panatituni tɨriku mɨtixiyari 'aixɨa mɨ'ane hatseiti nɨkame, meta 'ɨkwa witsimu'ɨa hatsi mawariyari heima maka. Naime 'ikɨ mawari taiyametsie xekanititaiyakuni, mawari ma'eriwa 'imikieri witsimu'ɨa Yawé minake mayanikɨ. ");
INSERT INTO hch_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","'Aruni meta niwemama 'imikieri mawariyari manayuhayewa mekanitikwaikuni, hakewa mekupatsietsie tikuxanariyame kanɨkame, 'ixuriki tukiyari manuwe takwayaritsie pɨyɨweni memitikwanikɨ. ");
INSERT INTO hch_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Tikuxanariyame kanɨtɨ puka'etsarɨwani, mɨkɨ kanihɨkɨtɨni mawari wewiwamete nemɨxeyetuirie nemawari xemɨnetsiwewirie taipa. 'Ikɨ pɨhɨkɨ waɨkawa mɨpatsie kepapaɨmetɨ wahetsɨa mumieme, mɨkɨ mɨ'itiyani meta mɨrayukatuani mawariyari pɨhɨkɨ. ");
INSERT INTO hch_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Yunaitɨ 'Aruni niwemamata 'ukitsi mepɨyɨwaweni memitikwanikɨ. Mɨkɨ 'aitsika kanihɨkɨtɨni yuheyemekɨ xetɨɨriyama wahetsiemieme, mawari taipa kemɨti'atɨariwa Yawé hetsiemieme. Tsepa ketita piinitetsie mawari mɨreutawerixɨ mɨkɨ patsietɨ payani». ");
INSERT INTO hch_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Yawé Muitsexi mɨpaɨ katiniutahɨawe: ");
INSERT INTO hch_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","«'Ikɨ kanihɨkɨtɨni 'Aruni meta niwemama Yawé hɨxie mawari memiyetuani kepauka mawari wewiwametekɨ memanayexeiyarienitsie. Huta kiruyari tɨriku mɨtɨxiyari 'aixɨa mɨ'ane wamawari pɨhɨkɨtɨni, ximeri hixɨata 'arɨkame taikaita hixɨata 'arɨkame. ");
INSERT INTO hch_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Katsuweratsie pikawewiwani hatseitikɨ pɨnariekame, 'imikieri 'etsipepekame penu'ɨni Yawé hɨxie witsimu'ɨa minake mayanikɨ. ");
INSERT INTO hch_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","'Aruni nu'aya pikuha'aritɨwani kemɨ'ane mawari wewiwamekɨ manayexeiyarieni. 'Ikɨ 'aitsika yuheyemekɨ Yawé hetsɨa kanimiemetɨni: Mɨkɨ mawari naitɨ kanititaiyarɨwamɨkɨ. ");
INSERT INTO hch_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Naitɨ tɨriku mawariyari mawari wewiwamete memiyetuani pɨkatikwaiwani, naitɨ pɨtitaiyarɨwani». ");
INSERT INTO hch_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Yawé Muitsexi mɨpaɨ katiniuta'aitɨani ");
INSERT INTO hch_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","'Aruni meta niwemama mɨpaɨ mɨtiwatahɨawekɨ: «'Ikɨ 'inɨari niukiyari kanihɨkɨtɨni kemɨtiu'itiyani mawariyari hepaɨtsita: Tita mɨtimawarie Yawé hɨxie kaniwaxitekiemɨkɨ. Hakewa memewaxitewa mawari taiyariyari mayanikɨ. 'Ikɨ kanihɨkɨtɨni mawari yemekɨ waɨkawa mɨpatsie. ");
INSERT INTO hch_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Mawari wewiwame kemɨ'ane 'itiya mawariyari mɨwewieni mɨkɨ kanitikwaimɨkɨ. Hakewa makupatsietsie, pɨyɨweni 'ixuriki tukiyari manuwe takwayaritsie mitikwanikɨ. ");
INSERT INTO hch_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Tsepa kemɨtitita xɨka wai mawaritsiemieme heutawere patsietɨ payani. Xɨka xuriya 'ixurikieyatsie hawere kaneuyeweka makupatsietsie mita'ekwakɨ. ");
INSERT INTO hch_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Yaxeikɨata, peuyewetse haxu xariyari mɨtatararienikɨ mɨkɨta mawari muka'etsariekɨ, mawari xɨka wurunitse xariyarita 'uka'etsarieni tepɨakɨ naime pɨwakukarauxieni meta hakɨ pɨwakuhauxini. ");
INSERT INTO hch_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Yunaitɨ 'ukitsi mawari wewiwamete wahamatɨa mekaniyɨwaweni mawari memɨtikwanikɨ. 'Ikɨ kanihɨkɨtɨni mawari yemekɨ waɨkawa mɨpatsie. ");
INSERT INTO hch_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Matsi 'itiya mawariyari mɨtikwayanikɨ pɨkayɨweni mɨkɨ xuriyaya tuki muyepatsieta me'ɨiwakɨ mɨxɨnarieni mawariyari muwewiyanikɨ, 'ayumieme mɨkɨ mawari taikɨ kanitixɨtsitɨariemɨkɨ. ");
INSERT INTO hch_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","»'Ikɨ 'inɨari niukiyari kanihɨkɨtɨni mɨrayukatuani mawariyari hepaɨtsita, mɨkɨ waɨkawa mɨpatsie kanihɨkɨtɨni: ");
INSERT INTO hch_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","'Ikɨ mawari Yawé hɨxie kaniwaxitekiemɨkɨ, hakewa memetikwikwiwatsie mawari taiyariyari mayanikɨ, meta xuriyaya mawari taiyame 'aurie pɨtiyeuriyani. ");
INSERT INTO hch_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Hikɨ naitɨ wiyayari pɨxatɨarieni: kwaxieya, wiyaya kwinurieya mɨ'eimatɨka, ");
INSERT INTO hch_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","mumé muhuta meta wiyayari mi'eimatɨka, meta wiya katutsitɨana mieme, meta wiya nemaya heimana mɨkawere, mɨkɨ pɨrayehapanieni mumé muhuta yɨnɨkame. ");
INSERT INTO hch_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Mawari wewiwame naime mɨkɨ mawari taiyametsie pɨtititaiya, mawari taipa warɨkarietɨ Yawé hetsɨa mɨyetuiwa kanihɨkɨtɨni. Mɨkɨ mɨrayukatuani mawariyari pɨhɨkɨ. ");
INSERT INTO hch_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Yunaitɨ 'ukitsi mawari wewiwamete wahamatɨa mekaniyɨwaweni mawari memɨtikwanikɨ. Pɨyɨweni makupatsietsie memitikwanikɨ. 'Ikɨ kanihɨkɨtɨni mawari yemekɨ waɨkawa mɨpatsie. ");
INSERT INTO hch_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","»'Ikɨ 'inɨari niukiyari yaxeikɨa paine, mɨ'itiyani mawariyari hepaɨtsita meta mɨrayukatuani mawariyari hepaɨtsita: Muxa mawari wewiwame hetsie pɨmiemetɨni mɨxɨnarieni mawariyari muwewikɨ. ");
INSERT INTO hch_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Yaxeikɨata nawiyarieya, mawari wewiwame hetsiemieme pɨhɨkɨtɨni mawari taiyariyari muwewikɨ. ");
INSERT INTO hch_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Yaxeikɨa naitɨ hatsite mawariyari huxunuta xarikietɨkaitɨ yatɨni xarita, meta katsuweratsie, mɨkɨ mawari wewiwame kemɨ'ane miyetuani hetsiemieme pɨtihɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Naitɨ tɨriku mawariyari, xarikiyari yatɨni hatseitikɨ mɨhawiyarie, 'Aruni niwemama wahetsiemieme payani, mepitikwani yunaitɨ yaxeikɨa papaɨmeme. ");
INSERT INTO hch_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","»'Ikɨ 'inɨari niukiyari kanihɨkɨtɨni 'aixɨa memɨteyuxeiya mawariyari Yawé mɨyetuiriyarɨwa: ");
INSERT INTO hch_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Xɨka pamɨpariyutsi xemipitɨanikɨ hɨkɨtɨni, pɨyɨwenita paa tikuxanariyame kanɨtɨ hatseitikɨ xeikɨa hawiyariekame, yatɨni paa kɨxauyari tikuxanariyame kanɨtɨ hatseiti nɨkame xeikɨa, yatɨni paa tɨriku mɨtɨxiyari 'aixɨa mɨ'ane hatseitikɨ xeikɨa hawiyariekame. ");
INSERT INTO hch_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","'Aixɨa memɨteyuxeiyanikɨ mawariyari meta pamɨpariyutsi xemipitɨakɨ, pɨyɨweni meta paa tikuxanariyame nɨkame xemiyetuirienikɨ. ");
INSERT INTO hch_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Xexuitɨ mawaritetsie mieme yapapaɨmetɨ Yawé 'imikierieya 'aixɨa mɨ'ane pɨrayani mɨkɨ mawari teikɨ petserarieni 'uyuitɨariwatɨ. Mɨkɨ mawari wewiwame hetsiemieme pɨrayani kemɨ'ane xuriya mɨtayeurieni 'aixɨa memɨteyuxeiyanikɨ mawariyari hetsiemieme. ");
INSERT INTO hch_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","'Ikɨ wai mawariyari pɨyɨweni mɨtikwaiyanikɨ xeikɨa kepauka mɨyetuiyani tukariyaritsie, xepɨka'ikuhayeikawani 'uxa'arieka mieme mayanikɨ. ");
INSERT INTO hch_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","»Xɨka mawari kepemutayɨ mawariyari hɨkɨtɨni, yatɨni kepemɨti'awaɨriya mawariyaritɨni, mɨkɨ wai mawariyari pɨtikwaiyani mɨkɨ tukaritsie, mexɨka yuhayewa pɨyɨweni 'uxa'arieka mitikwanikɨ. ");
INSERT INTO hch_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Peru naitɨ wai muyuhayewa hairieka tukaritsie mieme taipa kanititaiyariemɨkɨ. ");
INSERT INTO hch_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","»Xɨka xewitɨ wai 'utikwani 'aixɨa memɨteyuxeiyanikɨ mawariyaritsie mieme hairieka tukariyaritsie 'aye'ayu, mɨkɨri mawari pɨkatanaki'eriwa meta tixaɨtɨ katiyunaki'erietɨ payani, karikɨ wai kanipɨniniri. Kemɨ'ane mitikwani tiuka'eniwatɨ payani. ");
INSERT INTO hch_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","»Xɨka wai mawariyari tixaɨtɨ mɨkati'itiyatsie rautawere pɨkatikwaiyani, matsi pɨta taipa kanitataiyariemɨkɨ. Matsita xewitɨ wai mɨ'itiya, yunaitɨ teɨteri memɨ'itiyatɨka mepɨyɨwaweni memitikwani. ");
INSERT INTO hch_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","»Xɨka xewitɨ tewi ka'itiyatɨ 'aixɨa memɨteyuxeiya mawariyari waiyarieya 'utikwani Yawé hetsiemieme mɨyetuiya, mɨkɨ yuteɨterima watsata payeweiyarieni. ");
INSERT INTO hch_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","»Xɨka xewitɨ tewi ka'itiyakame 'umayɨani yatɨni yeuta mɨtiuyeika yatɨni tixaɨtɨ timɨkime yatɨni tixɨatɨ mɨtixani'eriwa, xɨka wai 'aixɨa memɨteyuxeiyanikɨ mawariyari Yawé muxatɨarie 'utikuani, mɨkɨ yuteɨterima watsata payeweiyarieni». ");
INSERT INTO hch_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Yawé Muitsexi mɨpaɨ katiniuta'aitɨani ");
INSERT INTO hch_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","'ixaheritsixi mɨpaɨ mɨtiwatahɨawekɨ: «Xeme tuuru, muxa meta tsipu wawiyayari xepɨkakwa'ani. ");
INSERT INTO hch_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Yeuta memɨte'u'uwa wawiyayari mɨkime yatɨni 'ɨrawe 'itexierieya, tixaɨtɨtsie timiemekɨ mɨrayani pɨyɨweni, peru xemitikwanikɨ pɨkayɨweni. ");
INSERT INTO hch_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Kemɨ'ane tewaxi Yawé hetsɨa memɨyetuiya mawari taipa warɨkariyari wawiyayari mɨtikwani, mɨkɨ payeweiyarieni yuteɨterima watsata. ");
INSERT INTO hch_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Tsepa xeme hakewa xemetiteni, tsepa wikixi meta tewaxi wawiyayari meta waxuriya xepɨkahekwa'ani. ");
INSERT INTO hch_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Kemɨ'ane tsepa tita xuriyaya mɨtitikwani, mɨkɨ payeweiyarieni yuteɨterima watsata». ");
INSERT INTO hch_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Yawé Muitsexi mɨpaɨ katiniuta'aitɨani ");
INSERT INTO hch_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","'ixaheritsixi mɨpaɨ mɨtiwatahɨawekɨ: «Kemɨ'ane Yawé 'aixɨa memɨteyuxeiyanikɨ mawariyari mɨwewirieni, mɨkɨ yapaɨmeme kaniyetuamɨkɨ Yawé hɨxie mawari hetsiena mieme mayanikɨ, ");
INSERT INTO hch_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","meta mawari taipa warɨkariekame xepɨyetuani. Taimɨxieya meta wiyayari yɨkɨmana piyetuirieni mawari 'imikieri taipa waɨrɨkariyari teikɨ kanetseramɨkɨ 'iyuitɨwatɨ Yawé hetsiemieme mayanikɨ. ");
INSERT INTO hch_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Mawari wewiwame mawari taiyametsie wiya pɨtataiya, peru taimɨxieya 'Aruni meta niwemama wahetsiemieme payani. ");
INSERT INTO hch_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Kepauka 'aixɨa memɨteyuxeiyanikɨ mawariyari xemɨwewieka, teuri tserietana mieme mawari wewiwame xepɨyetuirieni, mɨkɨ mawari 'imikieri teikɨ metserarɨwa kanihɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Mɨkɨ teuri tserietana mieme mawari wewiwame hetsɨa pɨmieme kemɨ'ane xuriya meta wiya mawariyari muwewieni. ");
INSERT INTO hch_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Mɨkɨ 'aixɨa memɨteyuxeiyanikɨ mawariyari 'ixaheritsixi memɨnetsixatɨa, ne taimɨxi meta teuri neputanaki'eri nemuxatɨarie, 'Aruni meta niwemama nemɨwayetuirienikɨ, mawari wewiwamete ne'imikieri 'aixɨa mɨ'ane mayanikɨ. 'Ikɨ kanihɨkɨtɨni 'aitsika yuheyemekɨ 'aixɨa mɨ'ane, 'Ixaheritsixi wahetsiemieme». ");
INSERT INTO hch_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Yawé muxatɨarie 'imikieri taipa warɨkarietɨ mɨyetuiwa, mɨkɨ 'imikieriyari mɨpatsie 'Aruni meta niwemama wahetsiemieme pɨhɨkɨ, kepauka memitsutɨa Muitsexi mɨwayetua Yawé hetsɨa, mawari wewiwamete memakɨnekɨ. ");
INSERT INTO hch_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Kepauka memanayexeiyarie, Yawé 'ixaheritsixi mɨpaɨ pɨtiwarɨhɨritɨa memɨwayetuiriwanikɨ yuheyemekɨ tita wahetsie mɨtinakenikekai. 'Ikɨ kanihɨkɨtɨni 'aitsika 'aixɨa mɨ'ane yuheyemekɨ xenuiwari wahetsiemieme. ");
INSERT INTO hch_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","'Ikɨ naitɨ 'aitsikate kanihɨkɨtɨni mawari taiyariyari hetsiemieme, tɨriku mawariyari, mɨ'itiyani mawariyari, meta mɨrayukatuani mawariyari, meta kememɨte'anayexeiyarie mawariyari, meta 'aixɨa memɨteyuxeiyanikɨ mawariyari. ");
INSERT INTO hch_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Yawé Muitsexi Tsinahi yemuriyaritsie katiniyetuirieni, kepauka 'ixaheritsixi mɨtiwaruta'aitɨa mawari memixatɨanikɨ makumawetsie. ");
INSERT INTO hch_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Hikɨ Yawé Muitsexi mɨpaɨ katiniutahɨawe: ");
INSERT INTO hch_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","«'Aruni meta niwemama keniwaranuwitɨki, meta wakemarite meta hatseiti mɨtiyupata memɨkawiriyarieni, meta tsikeru 'itiya mawariyari mayanikɨ, yuhutame muxatsi 'ukitsi meta tsikɨiwiti paa mɨkakuxanariyarietɨka mayemane, ");
INSERT INTO hch_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","yunaime keniwarukuxeɨri kiekatari 'ixuriki tukiyari manuwe kitenieyaritsie». ");
INSERT INTO hch_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Muitsexi yakatinikayani Yawé kemɨtita'aitɨa, kaniwarukuxeɨrieni yunaime kiekatari 'ixuriki tukiyari manuwe kitenieyaritsie. ");
INSERT INTO hch_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Muitsexi mana 'ipaɨ katiniwarutahɨawe: «'Ikɨ kanihɨkɨtɨni Yawé kemɨtati'aitɨa yatemɨteyurienikɨ». ");
INSERT INTO hch_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Hikɨ Muitsexi 'Aruni meta niwemama warutakwewieka 'ahurawa hakɨ puwarukahauxi. ");
INSERT INTO hch_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","'Ana 'Aruni kamixa tixukame panakatɨtɨa, hɨiyamekɨ kanenakɨhɨani meta kanenaku'eima herie kamixa 'amɨtewikɨ, yaxeikɨa kamixa 'etsimɨnena wiwieriyaritekɨ 'axɨa katinihɨaxɨani. ");
INSERT INTO hch_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Kwitɨta kuka tawitsie mieme kanekatɨtɨani, taɨtana tetexi 'urimi meta tumimi kaneukayatsa. ");
INSERT INTO hch_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","'Imatɨrieka 'ixuriki xupureruyari mu'uyatsie kanenutiketsirieni, hɨxiena huru tepɨayari kanenuyeketsirieni 'inɨari mɨhɨkɨtɨnikɨ kename patsie Yawé hetsiemieme, Yawé Muitsexi kemɨtiuta'aitɨa. ");
INSERT INTO hch_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Hikɨ Muitsexi hatseiti mɨtiyupata watihanaka, tuki kaniutawirieni meta tinaime muwa mɨrayepikai tipatsietɨ mɨrayanikɨ kakaɨyaritsie mieme. ");
INSERT INTO hch_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Mawari taiyametsie 'atahutamexɨa hatseitikɨ katiniɨ'ɨyaxɨani mɨtipatsiekakɨ, mɨkɨ haa mayema mawari taiyametsie meta kɨmana mɨwetɨka meta naime wapaitɨ mɨratipine. ");
INSERT INTO hch_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Hikɨ Muitsexi 'Aruni mu'uyatsie kaniukawirieni hatseiti mɨtiyupata manayexeiyarietsie mieme, kɨmana mɨpatsiekakɨ. ");
INSERT INTO hch_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Kuitɨwata Muitsexi 'Aruni niwemama 'ahurawa kaniwarutakwewieni, kamixa 'amɨtɨtɨkɨ, 'ana kaniwarutikemaritɨani wahɨiyamekɨ kaniwaranahɨaxɨani, meta mukuretsi kaniwarana'uitɨirieni mawari wewiwamete memɨhɨritɨarie memakɨnekɨ. Yaxeikɨa Yawé kemɨtita'aitɨakai. ");
INSERT INTO hch_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Hikɨ Muitsexi katiniuta'aita tsikeru mɨ'atɨarienikɨ 'itiya mawariyari mayanikɨ, 'Aruni meta niwemama yumamakɨ tsikeru mu'uyatsie mekaniutimeni. ");
INSERT INTO hch_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Hikɨ Muitsexi tsikeru kanewaxiteni, 'etsiwa xuriyatsie yu'itɨwame kakeka, mawari taiyame 'awateyatsie naitsata kanawiriexɨani mɨ'itiyanikɨ Kakaɨyaritsie mieme. Xuriya muyuhayewaxɨta mawari taiyame hetɨa putiyeuri, mɨpaɨ patsiekame pɨrayeitɨa hetsiena mieme meta memɨxɨnarienikɨ mawariyari. ");
INSERT INTO hch_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Hikɨ Muitsexi naime wiya kwinuri mɨ'eimatɨka kaneukuxiteni, wiya nemaya heimana mɨkawere meta mumé muhuta mɨ'eima mɨkɨ naime 'ukuxeɨrieka mawari taiyametsie kanititaiya. ");
INSERT INTO hch_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Mɨkɨ naitɨ tsikerutsie mɨtiuyuhayewaxɨ nawiyari, waiyari meta kwitaya, Muitsexi taipa kanititaiya yateewa memakuteitsie, Yawé kemɨtita'aitɨakai. ");
INSERT INTO hch_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Muitsexi pɨtiuta'ai muxa 'uki mɨ'atɨarienikɨ mawari taiyariyari mayanikɨ, hikɨ 'Aruni meta niwemama muxa 'uki mu'uyatsie mekaniutimeni. ");
INSERT INTO hch_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","'Ana Muitsexi kanewaxiteni, xuriya mawari taiyame 'aurie kaniutayeurieni. ");
INSERT INTO hch_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Hikɨ muxa 'uki kaniwayexitexɨani, yaxeikɨata mu'uya meta wiyayari meta 'etsipepeme mɨtiutixitekai naime katiniutitaiya. ");
INSERT INTO hch_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Kwinurieyata hakɨ kaniutihauxini meta 'ɨkateya, hikɨta mawari taiyametsie muxa 'uki naime kaniutataiya mawari taiyariyari mayanikɨ Yawé minake witsimu'ɨa, mawari taipa warɨkariekame Yawé hetsɨa mɨyetuiwa kanihɨkɨtɨni. 'Ikɨ 'imikieri taiyariyari, Yawé Muitsexi kemɨtiuta'aitɨakai. ");
INSERT INTO hch_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","'Ariketa Muitsexi tawari xeime muxa 'uki memɨ'atɨanikɨ katiniuta'aita, 'ikɨ kememɨte'anayexeiyarie mawariyari mayanikɨ, hikɨ 'Aruni meta niwemama muxa 'uki mu'uyatsie mekaniutimeni. ");
INSERT INTO hch_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Hikɨ Muitsexi kaniwaxiteni 'etsiwa xuriya 'anati'ɨka 'Aruni nakaya heima tserietana mieme 'etsiwa kaniuwirieni meta 'itɨwameya 'amɨpayaritsie tserietana mieme meta 'ɨkayatsie mieme 'amɨpayari tserietana mieme. ");
INSERT INTO hch_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Yaxeikɨata 'Aruni meta niwemama 'ahurawa memakɨnekɨ kaniwaruta'inieni. 'Anari wanaka heima kaniwarutixurimani watserieta meta wa'itɨwame 'amɨpayayaritsie watserieta mieme meta wa'ɨkatetsie 'amupapayari watserieta miemeyaritsie, hikɨ xuriya muyuhayewaxɨ mawari taiyame 'aurie kaniutayeurieni naitsata. ");
INSERT INTO hch_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Wiya meta kwaxieya naitɨ mana mɨrayepikai kwinurite mɨti'eimatɨka, meta wiya nemaya heimana mɨkawere, meta mumé muhuta wiyayari yunɨtɨ meta teuri tserietana mieme. ");
INSERT INTO hch_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Tsikɨiwiti Yawé hɨxie mamakaitsie paa tikuxanariyame mɨkanɨtɨka mayemane xeime mɨkakuxanariyarie hanati'ɨka, meta mɨkɨxauni meta xeime paa tsuirayari hatseitikɨ xeikɨa mɨhawiyarie, mɨkɨ naime wiya heima katinapini meta teuri tserietana mieme. ");
INSERT INTO hch_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","'Ikɨ tinaime Muitsexi 'Aruni meta niwemama katiniwayetuirieni, hikɨ 'Aruni mawari Yawé kaniuxatɨani hɨxiena teikɨ heititserietɨ 'iyuitɨwatɨ 'imikieri mawariyari minake. ");
INSERT INTO hch_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","'Ariketa Muitsexi kaniyetuiriyarieni, mɨkɨ mawari taiyametsie kanititaiya, mawari taiyariyari yɨnɨkame, kememɨte'anayexeiyarie mawariyari witsimu'ɨa mayanikɨ, meta 'imikieri taipa warɨkariekame Yawé mɨyetuiriyarie. ");
INSERT INTO hch_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Hikɨ mɨkɨ mawari yapaɨmeme wahetsie mumieme, taimɨxieya 'anukutuka Muitsexi Yawé hɨxie kaneititsera 'iyuitɨwatɨ, Yawé Muitsexi kemɨtita'aitɨakai. ");
INSERT INTO hch_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Hikɨ Muitsexi hatseiti mɨtiyupata memɨwakawiriwa 'etsiwa 'anahanɨka meta xuriya mawari taiyametsie mieme, 'Aruni meta niwemama kaniwaru'ɨyaxɨani meta wakemarite. Muitsexi mɨpaɨ metepatsiekame 'Aruni meta niwemama pɨwarayeitɨa metatsiere wakemarite. ");
INSERT INTO hch_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Hikɨ 'Aruni meta niwemama Muitsexi mɨpaɨ katiniwarutahɨawe: «Xemayutixexeɨriwa Kakaɨyari hamatɨa 'ixuriki kiyari manuwe xemeutahaketsie, mana wai xekeneuka'etsa meta xekeneukwa'i paa kememɨte'anayexeiyarie mawariyari nɨkame, mɨpaɨ kenemɨtixe'uta'aitɨa kepauka 'ipaɨ nemutayɨtsie: “'Aruni meta niwemama mepitikwani”. ");
INSERT INTO hch_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Naitɨ wai meta paa mɨtiuyuhayewaxɨ xepɨtitaiya. ");
INSERT INTO hch_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","'Ixuriki tukiyari kitenie xemayutixexeɨriwa mɨranutahakitɨretsie, mana 'atahuta tukari xekenekuteni, kepaukake xemanayexeiyarie maye'ani, 'atahuta tukari katineuterimɨkɨ. ");
INSERT INTO hch_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Yawé katiniuta'aita mɨxɨnarieni mawariyari muwewiyanikɨ xehetsiemieme, yaxeikɨa hikɨ hepaɨ. ");
INSERT INTO hch_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Merikɨte 'ixuriki tukiyari mɨranutahakitɨretsie mana xekanikutekuni 'atahuta tukari meta tɨkarikɨ, Yawé kemɨxetiuta'aitɨa xemeye'atɨakakɨ, xemɨkakukukuwenikɨ. Yawé mɨpaɨ kanetiniuta'aitɨani». ");
INSERT INTO hch_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Hikɨ Yawé Muitsexi kemɨtiuta'aitɨa, 'Aruni meta niwemama yamekatenikakɨne naimetsie. ");
INSERT INTO hch_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Merikɨte 'atahairieka tukaritsie, Muitsexi 'Aruni kaniutahɨawe meta niwemama, metatsiere 'ukirawetsixi 'ixaheritsixi wa'ukiyarima. ");
INSERT INTO hch_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Hikɨ 'Aruni mɨpaɨ katiniutahɨawe: «Tsikeru xeime kene'atɨa mɨ'itiyani mawariyari mayanikɨ, meta xeime muxa 'uki mawari taiyariyari mayanikɨ, mɨkɨ 'aixɨa mepɨ'aneneni Yawé pekanixatɨamɨkɨ. ");
INSERT INTO hch_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Kwitɨwata 'ixaheritsixi mɨpaɨ ketiniwarutahɨawi: “Xekene'atɨa xeime tsipu 'ukitɨme 'itiya mawariyari mayanikɨ, xeimeta tsikeru meta muxa mawari taiyariyari mayanikɨ, 'aixɨa me'anenekame xeiwiyari mehɨtɨkaime. ");
INSERT INTO hch_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Yaxeikɨatatsiere tuuru xeime xekene'atɨa xeimeta muxa 'uki Yawé temɨtimawirienikɨ 'aixɨa memɨteyuxeiyani mawariyari mayanikɨ, meta tɨriku mawariyari hatseitikɨ hawiyariekame. Yawé hikɨ kaniyuhekɨatamɨkɨ xehɨxie”». ");
INSERT INTO hch_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Hikɨ 'ixaheritsixi mekatenetɨni 'ixuriki tukiyari manuwetsie paitɨ Muitsexi kemɨtiwaruta'aitɨakai, yunaitɨ mana kiekatari mekaniu'axɨani Yawé hɨxie mekaniti'uni. ");
INSERT INTO hch_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Muitsexi mɨpaɨ katiniwarutahɨawe: «'Ikɨ kanihɨkɨtɨni ti'aitame mɨtixe'aitɨa yaxemɨteyuriekakɨ, Yawé witsi'anetɨ kemɨtimatsiɨkɨni xehɨxie». ");
INSERT INTO hch_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Hikɨta Muitsexi 'Aruni mɨpaɨ katiniutahɨawe: «Mawari taiyametsie 'ahurawa keneuye'a, 'itiya mawariyari meta mawari taiyariyari keneuwewi 'ahetsiemieme. Meta mɨxɨnarieni mawariyarita keneuwewi 'ahetsiemieme meta teɨteri wahetsiemieme. Mawari keneuxatɨa teɨteri wahetsiemieme meta mɨxɨnarieni keneuwewi wahetsiemieme, Yawé kemɨtiuta'aitaxɨ». ");
INSERT INTO hch_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Hikɨ 'Aruni mawari taiyametsie 'ahurawa 'uyaka, tsikeru kaniwaxiteni 'itiya mawariyari hetsiena mieme mayanikɨ. ");
INSERT INTO hch_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","'Aruni niwemamata xuriya mekanei'ɨirieni, mɨkɨ yu'itɨwame xuriya 'utawirieka mawari taiyame 'awateyatsie kaniuwiriexɨani, meta xuriya kaniutiyeurieni mawari taiyame hetɨa. ");
INSERT INTO hch_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Hikɨ wiyayari mawari taiyametsie kaniutitaiya, muhuta mumé meta wiya nemaya heimana mɨkawere mɨtimawarietsie mieme, mɨpaɨ Yawé Muitsexi mɨtiu'aitɨakaikɨ. ");
INSERT INTO hch_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Nawiyari meta waiyarieya memakuteitsie yateewa paitɨ kaniutitaiya. ");
INSERT INTO hch_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","'Ariketa 'Aruni mawari taiyariyari mayani kaniwaxiteni. Niwemama xuriya makanei'ɨirieni, mɨkɨ kanitayeurieni mawari taiyame waritana naitsarie. ");
INSERT INTO hch_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Yaxeikɨata tuurutsie mɨtiwayexitekiexɨa meta mu'uya yunɨkame mekateneitituirieni, 'ana mɨkɨ mawari taiyametsie katiniutitaiya. ");
INSERT INTO hch_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Kwinurite meta 'ɨkate kaniutihauxini, hikɨ naime mawari taiyametsie katiniutitaiya mawari taiyariyari yɨnɨkame. ");
INSERT INTO hch_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Hikɨ 'Aruni teɨteri wahetsiemieme mawari kaniyetuani, tatsɨari tsipu 'ukitɨme 'itiya mawariyari mayanikɨ. 'Iwiyaka kaniwaxiteni 'itiya mawariyari kanixatɨani, matɨari miemetsie hepaɨ. ");
INSERT INTO hch_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Hɨkɨ mɨkɨ tita mawari taiyariyari mɨrayanikekai kanixatɨani, kememɨte'u'aitɨariekai mɨpaɨ pɨtiuyuri. ");
INSERT INTO hch_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Yaxeikɨata tɨriku mawariyari kanixatɨani, meta xeimamayari 'anatituka mawari taiyametsie kanititaiya, yaxeikɨata mawari taiyariyari ximeri mieme yɨnɨkame. ");
INSERT INTO hch_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","'Ariketa tuuru kaniwaxiteni meta muxa 'uki 'aixɨa memɨteyuxeiyani mawariyari teɨteri yunaime wahetsiemieme mayanikɨ. 'Aruni niwemama xuriya mepei'ɨiri, mɨkɨ mawari taiyame 'aurie pitayeuri naitsarie. ");
INSERT INTO hch_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Hikɨ tuuru wiyayari 'utituka meta muxa 'uki, tatsɨari, kwaxieya meta wiyayari kwinuriteya mɨ'eimatɨka, meta mumé muhuta yaxeikɨa wiya nemaya heimana mɨkawere, ");
INSERT INTO hch_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","mɨkɨ tinaime watawitsie katinapixɨamɨkɨ, mawari taiyametsieketa mɨtititaiyakɨ. ");
INSERT INTO hch_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","'Aruni Yawé tawi meta teuri tserieta miemete tita memɨtemawarietsie timieme kanixatɨani hɨxiena kaneititsera 'iyuitɨwatɨ. Mawari teikɨ hetserarietɨ 'uyuitɨariwatɨ patɨa, Muitsexi kehepaɨ mɨtiuta'aitakai. ");
INSERT INTO hch_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Hikɨ 'Aruni teɨteri wahepa teikɨ yumamate kanetseraxɨani, 'ana teɨteri 'aixɨa kaniwaruyurieni. Hikɨ kepauka mɨtiutahayewaxɨ 'itiya mawariyari wewietɨ, meta mawari taiyariyari, meta 'aixɨa memɨteyuxeiyanikɨ mawariyari 'uwewieka, mawari taiyametsie kanewakayani. ");
INSERT INTO hch_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Muitsexi meta 'Aruni 'ixuriki tukiyarita mekaneutahaxɨani. Kepauka memuwayekɨtsie teɨteri 'aixɨa mekaniwaruyurieni, 'ana Yawé witsikemɨ'ane matsiɨkɨtɨ kanayuyeitɨani yunaime teɨteri wahɨxie. ");
INSERT INTO hch_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Hikɨ Yawé hetsɨa tai kanakaneni, 'ana mɨkɨ naime mawari taiyariyari meta wiyayari mawari taiyame heima mɨrapikai kaniutixɨtsitɨani. Mɨpaɨ mete'uneniereka, yunaitɨ teɨteri mekaniutihiwa meyutemamawietɨ, meta kwiepa mekaniukahɨxima'uni. ");
INSERT INTO hch_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Hikɨ Narawi meta 'Awihu 'Aruni niwemama, yuxexuitɨ yupɨtsiwiwame me'utihapaxɨaka, me'akanaixɨaka 'ɨkwa witsimu'ɨa me'akawiwiexɨaka, Yawé mekaniuxatɨani, matsi mɨkɨ tai kaheuyewekakaku mepixatɨa, mɨkɨ mɨkawaruta'aitɨakaikɨ. ");
INSERT INTO hch_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Hikɨ Yawé hetsɨa tai kanayeneni kaniwarutixɨtsitɨani, hɨxiena mekaniukwini. ");
INSERT INTO hch_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Muitsexi 'Aruni mɨpaɨ katiniutahɨawe: «'Ikɨ hepaɨtsita painekai Yawé kepauka mɨpaɨ mutayɨ: »“Kemɨ'ane nehetsɨa 'ahurawa memakɨka wahetsɨa, kenemɨtipatsiekɨ nematsiɨkɨme nepaneyeitɨaka, Meta yunaime teɨterima wahɨxie witsikenemɨ'anekɨ nepɨnehekɨata”». 'Ana 'Aruni kayuwatɨ pɨtiuke. ");
INSERT INTO hch_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Muitsexi Mitsaheri meta 'Eritsapani katiniwarutanɨ'airieni memɨwitɨkieyukɨ, 'Utsiheri niwemama 'Aruni tatatsieya, mɨpaɨ katiniwarutahɨawe: «Xekenakɨni 'ena 'ahurawa meta yu'iwama tukita xekeniwaranuye'ɨi. Tematiteitsie 'ateewa paitɨ xekeniwatuayu». ");
INSERT INTO hch_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Mɨkɨ 'ahurawa me'ɨkɨneka, wakamixatetsie metiwɨtɨkaitɨ memakutekaitsie 'ateewa mekaniwaranuye'ɨni, Muitsexi kemɨtiwaruta'aitɨakai. ");
INSERT INTO hch_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Hikɨ Muitsexi 'Aruni meta niwemama 'Eriyatsaxi meta 'Itamaxi mɨpaɨ katiniwarutahɨawe: «Xeme xekamu'utsikietɨkaitɨ xepɨka'u'uwani meta yukamixa xepɨkaheukatsanani. Mɨpaɨ xeme xepɨkakwini meta Yawé pɨkayeha'ani teɨteri yunaime wahetsiemieme. Xe'iwama 'ixaheritsixi hiwerika mekaniwewikuni Yawé tai mutaiyaxɨkɨ. ");
INSERT INTO hch_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Xemeri 'ixuriki tukiyarita xepɨkawayekɨkani kapa xe'ukwinikɨ, xemanayexeiyarie Yawé hatseiti mɨtiyupata mɨxe'ukawiri xehetsie mɨtiunakixɨkɨ peuyewetse xemeye'atɨanikɨ kexemɨte'u'aitɨarie». Muitsexi kemɨtiwarutahɨawixɨ mɨpaɨ mekateniuyurieni. ");
INSERT INTO hch_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Yawé 'Aruni mɨpaɨ katiniutahɨawe: ");
INSERT INTO hch_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","«'Ekɨ meta 'aniwema kaxie winuyari xepɨka'ieka 'ixuriki tukiyarita kepauka xemautahaxɨani kapa xe'ukwinikɨ. 'Ikɨ 'aitsika yuheyemekɨ kanihɨkɨtɨkamɨkɨ xexiɨyarima wahetsie mieme yamemɨtekahunikɨ. ");
INSERT INTO hch_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Memɨyɨwawenikɨta yamemɨtemaikakɨ ketita mɨtipatsie meta mɨkatipatsie, yaxeikɨa ketita mɨti'itiya meta mɨkati'itiya. ");
INSERT INTO hch_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Xepɨyɨwawenita 'ixaheritsixi xemɨtewata'ɨkitɨanikɨ naime 'aitsika Yawé mɨxeyetuirikɨ xemimaikakɨ Muitsexi ya'utainekaku». ");
INSERT INTO hch_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Muitsexi 'Aruni mɨpaɨ katiniutahɨawe meta niwemama 'Eriyatsaxi meta 'Itamaxi mɨkɨ niwemama memuyuhayewatɨwekai: «Tɨriku mawariyari muyuhayewaxɨ Yawé 'imikierieya xekeneukutɨkɨka xekeneutikwa'i tikuxanariyame kanɨitɨariekame, mawari taiyame 'aurie, mɨkɨ yemekɨ kanipatsieka Yawé hetsiemieme. ");
INSERT INTO hch_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Xekeneutikwa'i hakewa makupatsietsie, mɨpaɨ nemɨti'aitɨariekɨ. Mɨkɨ 'aitsika kanihɨkɨtɨni 'ahetsiemieme meta 'aniwema, mɨkɨ mawari taipa warɨkarietɨ yapaɨmeme Yawé muxatɨarie mɨhɨkɨkɨ. ");
INSERT INTO hch_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","»'Ekɨ meta 'aniwema 'ukitsi meta 'ukari xepɨyɨwaweta xemitikwanikɨ hakewa maku'itiyarietsie, taimɨxi tatsɨari mawari teiki hetserarietɨ 'uyuitɨariwatɨ mɨyetuiya meta teuri mɨkɨ mawari pɨhɨkɨ 'ahetsiemieme 'imikieri 'aixɨa mɨ'ane mayanikɨ, mɨkɨ tihutatɨ 'aixɨa memɨteyuxeiyanikɨ mawariyari kanihɨkɨtɨni 'ixaheritsixi wahetsiemieme, 'ekɨ meta 'aniwema xekaniyetuiriyarieni 'aitsika mɨhɨkɨtɨnikɨ. ");
INSERT INTO hch_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Mɨkɨ teuri meta taimɨxi pɨxatɨarieni wiya yunɨkame, Yawé memɨyetuirieni teikɨ hetserarietɨ 'uyuitɨariwatɨ mawariyari mɨhɨkɨkɨ. 'Ikɨ 'aitsika pɨhɨkɨtɨni yuheyemekɨ 'ahetsiemieme meta 'aniwema, Yawé kemɨtiu'aitakai hepaɨ». ");
INSERT INTO hch_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Hikɨ Muitsexi tsipu kaniuta'iwauni 'itiya mawariyari hepaɨtsita mutimawarie, matsi mɨkɨri taipa putataiyariekai. Kepauka yamɨretima kename mawari taiyametsie 'utataiyariekai, mɨkɨ 'Eriyatsaxi meta 'Itamaxi wahepaɨtsita kaniuyeha'ani, 'Aruni niwemama memɨyuhayewatɨwekai, 'ipaɨ katiniwaruta'iwawiya: ");
INSERT INTO hch_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","—¿Ketitayari tuki muyepatsieta xekate'itikwai 'itiya mawariyari? Mɨkɨ waɨkawa mɨpatsie kanihɨkɨtɨni, mɨkɨ mawari Yawé hɨxie xekaniyetuiriyarieni xemɨxɨnarieni mawariyari mayanikɨ yunaitɨ xehetsie mɨrahɨiwakɨ. ");
INSERT INTO hch_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Tsipu xuriyaya xɨka xekahei'ɨni hakewa makupatsietsie, 'ayumieme peuyewekai xeme muxa waiyarieya xemɨtakwanikɨ tuki muyepatsieta ne kenemɨtixe'u'aitɨa. ");
INSERT INTO hch_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Hikɨ 'Aruni Muitsexi mɨpaɨ katiniuta'eiya: —Neniwema hikɨ mepixatɨa 'itiya mawariyari meta yumawari taiyariyari Yawé hɨxie. Tsepa yumawari memɨyetua, matsi 'ikɨ mɨyamɨtiuyɨkɨ pɨnetiuka'enitsitɨa. Xɨari 'aixɨa pɨka'anenikeyu Yawé hetsiemieme xɨka ne mɨkɨ 'itiyari mawaritsie timieme netiutikwanike. ");
INSERT INTO hch_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Hikɨ Muitsexi 'u'enaka 'Aruni kemutayɨ 'iyarieya 'aixɨa kaniuyɨni. ");
INSERT INTO hch_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Yawé Muitsexi meta 'Aruni mɨpaɨ katiniwaruta'aitɨani ");
INSERT INTO hch_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","'ixaheritsixi mɨpaɨ memɨtewataxatɨanikɨ: «Yunaime yeutari kwiepa memɨtexɨawe, 'ikɨ mekanihɨkɨtɨni xepɨyɨwaweni xemɨwakwa'anikɨ: ");
INSERT INTO hch_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Wakarutsa manutahuhuta meta hutarieka memɨte'iyawa. ");
INSERT INTO hch_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Matsita mekanixɨaweni hipatɨ mete'iyawatɨ wakarutsa ka'anutahuhutatɨ. Xemɨkawakwa'ani 'ikɨ mepɨhɨkɨ: »Kameyu pɨti'iyawa matsi karutsaya pɨka'anutahuhuta, mɨkɨ pɨka'itiya xehetsiemieme. ");
INSERT INTO hch_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","»Tatsiu pɨti'iyawa matsi karutsaya pɨka'anutahuta, mɨkɨta pɨka'itiya xehetsiemieme. ");
INSERT INTO hch_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","»Yaxeikɨata tatsiu hepaɨ mɨ'ane mɨkɨta pɨti'iyawa matsi karutsaya pɨkahanutahuhuta, mɨkɨ xepɨkakwa'ani mɨka'itiyakɨ xehetsiemieme. ");
INSERT INTO hch_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","»Tuixu meta karutsaya panutahuhuta matsi pɨkati'iyawa, mɨkɨ pɨka'itiya xehetsiemieme. ");
INSERT INTO hch_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","»Waiyarieya xepɨkakwa'ani meta mekwikwi'ime xepɨkawakumaɨwani. Mɨkɨ xehetsiemieme mepɨka'itiya. ");
INSERT INTO hch_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","»Hapa memɨteye'uwa, haramaratetsie meta muyehapanetsie 'ikɨ mekanihɨkɨtɨni xeikɨa xeme xemɨwakwa'ani: Memeukakararayatɨka yuhauweme memexeiya naitsata. ");
INSERT INTO hch_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Yuhauweme meta yukararayari memɨkahexeiya, tsepa haramaratsie meta hatuxametsie memɨye'uwa, mɨkɨ xeme xepɨwaxani'erieka. ");
INSERT INTO hch_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Waiyarieya xepɨkakwa'ani mɨkime xepɨxani'erieka, mɨkɨ pɨka'itiya xehetsiemieme. ");
INSERT INTO hch_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Yunaitɨ hapa memɨteye'uwa yuhauweme memɨkahexeiya meta memɨkaheukararayatɨka mɨkɨ xepɨwaxani'erieka meta mepɨka'itiya xehetsiemieme. ");
INSERT INTO hch_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","»'Ikɨ mekanihɨkɨtɨni memɨte'awɨwawe xeme xemɨwaxani'erieka meta xemɨkawakwa'ani: Werika, 'umete mumura, kwixɨ meta maraika, ");
INSERT INTO hch_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","yunaitɨ hukurixi meta wahepaɨ memɨ'anene hipatɨ, ");
INSERT INTO hch_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","meta yunaime kwatsari xepɨkawakwa'ani, ");
INSERT INTO hch_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","meta 'aru 'amɨnena, nɨpe, meta yunaitɨ yɨkɨ memɨ'anene paturi wahepaɨ memɨ'anene, ");
INSERT INTO hch_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","mikɨri, kwaxu meutsinaɨye, patu, ");
INSERT INTO hch_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","tɨkaipu, patu hepaɨ mɨ'ane 'amanuyepa, wirɨkɨ. ");
INSERT INTO hch_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","Kwaxu 'amɨnena, meta yunaitɨ yɨkɨ memɨ'anene kwaxuri, tsurakai meta 'atsixi. ");
INSERT INTO hch_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","»Yunaitɨ memɨte'awɨwawe menauka 'ɨkatɨkaitɨ mɨkɨ xepɨwamaika memɨka'itiyakɨ, ");
INSERT INTO hch_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Hipatɨta memuxɨawe naukamekɨ meheu'uwatɨ meta me'awɨwawetɨ, mɨkɨ xemɨwatikwani xepɨyɨwawe, mɨkɨta wakarutsa peukakukuni meta mepɨyɨwawe memɨtitsunaxɨani, ");
INSERT INTO hch_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","meta yunaitɨ 'utsikari wahepaɨ memɨte'anene 'ɨtsita memeutsunatɨka meta xuxuitsi. ");
INSERT INTO hch_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Peru hipatɨ naukamekɨ memu'uwe meta mema'anatɨka, xeme xepɨkawakwa'ani mɨkɨ mepɨka'itiyatɨka. ");
INSERT INTO hch_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","»Xeme 'ikɨ wakɨmana xeka'itiyatɨ xepuyuhayewa: »Kemɨ'ane xeme mɨkɨ mekwikwi'ime mɨwamayɨani mɨkɨ ka'itiyatɨ puyuhayewa kepaukake mɨkɨyɨretsie. ");
INSERT INTO hch_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","»Kemɨ'ane mɨkime manukukweni, mɨkɨ kaneuyeweka yu'ixurikite mɨti'ekwa, mɨkɨ ka'itiyatɨ puyuhayewa kepaukake mɨkɨyɨretsie. ");
INSERT INTO hch_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","»Xemeri xepɨwaxeiyani yeutari memɨka'itiyatɨka meta yunaime kemɨ'ane mɨka'anutahuhuta wakarutsate meta mɨkareka'iyawame. Tsepa kemɨ'ane mimayɨani ka'itiyatɨ kanayeimɨkɨ. ");
INSERT INTO hch_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","»Meta memɨtexɨawe naukamekɨ me'u'uwetɨ memeu'uwa, mɨkɨta memɨka'itiya xepɨtewamaika yukɨtsimekɨ me'u'uwetɨ memɨteku'uwa, kemɨ'ane mɨkime mɨmayɨani ka'itiyatɨ kanayeimɨkɨ kepauka mɨkɨyɨretsieke, ");
INSERT INTO hch_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","yunaitɨ kemɨ'ane menukuhana kaneuyeweka yu'ixɨriki memɨti'ekwa, meta meka'itiyatɨ mepakɨne kepauka mɨkɨyuretsieke. Mɨkɨ yeutari xeme memɨka'itiya xepɨtewamaika. ");
INSERT INTO hch_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","»Yunaitɨ memɨtexɨawe yutawima memɨteku'uwa, mɨkɨ memɨka'itiyatɨka mepɨhɨkɨtɨni: kɨrupuxi, naikatsi meta katsaxi hipatɨ yukɨmemɨ'anene, ");
INSERT INTO hch_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","mataika, ketse, tekaxi, kuu 'iwipame, ");
INSERT INTO hch_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","'ikɨ mekanihɨkɨtɨni yeutari xeme meka'itiyakame xemɨwarayeitɨaka yutawima memɨteku'uwa watsata. Kemɨ'ane mɨkime mɨmayɨani mɨkɨ ka'itiyatɨ kaniyuhayewamɨkɨ kepauka mɨkɨyɨretsieke. ");
INSERT INTO hch_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","»Kepauka yeutanaka waiyarieya mɨkitɨ ka'itiyatɨ tixaɨtɨ kɨyetsie mɨtikaweni, yatɨni 'ixurikitsie, yatɨni nawitsie, yatɨni kamixa 'amayetsuye yamɨranakatɨkietsie, mɨkɨ ka'itiyatɨ kanayeimɨkɨ. Kaneuyeweka hakɨ mɨtahauxinirekɨ, meta ka'itiyatɨ kaniyuhayewamɨkɨ kepaukake mukɨyɨretsie. Hikɨ 'ana 'itiyatɨ kanayeimɨkɨ. ");
INSERT INTO hch_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","»Xɨka xewitɨ 'ikɨ yeutari waiyarieya mɨkitɨ haxu xariyarita heukaweni, mɨkɨ xari meta tita muwa mɨtiyepika kati'itiyatɨ kanayeimɨkɨ, kaneuyeweka xari mitatararienikɨ. ");
INSERT INTO hch_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Naitɨ 'ikwaitsie haa xarita mieme xɨka 'ukayeurieni ka'itiyatɨ kanayeimɨkɨ, yaxeikɨata tita mɨti'iwa mɨkɨ xariyarita timieme ka'itiyatɨ payani. ");
INSERT INTO hch_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Xɨka kaxari yapaɨmetɨ tixaɨtɨtsie tiukaweni mɨkɨ ka'itiyatɨ payani, kaneuyeweka mita'unakɨ huxunu meta huxiniyu hetsiena mukawekɨ. Mɨkɨ kaxari pɨka'itiya mɨpaɨ xepute'ixeiyani. ");
INSERT INTO hch_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Peru xeikɨa haixa muhanetsiemieme meta putsuta hakewa haa matihawa pɨ'itiyaka xeikɨa, matsi kemɨ'ane yeutanaka kaxarieya mɨkime mɨmayɨani tsepa kemɨtitita ka'itiyatɨ kaniyuhayewamɨkɨ. ");
INSERT INTO hch_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","»Xɨka xewitɨ mɨkɨ yeutari mɨkitɨ ra'imɨarita heukaweni, mɨkɨ hatsi 'itiyatɨ puyuhayewani. ");
INSERT INTO hch_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Peru xɨka 'imɨari hapa 'utihawiya, xɨka tixɨatɨ timɨkitɨ mana tikaweni, ka'itiyakame xekanayeitɨakakuni. ");
INSERT INTO hch_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","»Xɨka tewa mupitɨariekai mitakwanikekaikɨ hekuwiekaku 'umɨni, kemɨ'ane mɨkime mimayɨani, mɨkɨta ka'itiyatɨ puyuhayewa kepauka mɨkɨyɨretsieke. ");
INSERT INTO hch_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Kemɨ'ane mɨkɨ waiyaririeya mitakwani, mɨkɨ yukemari pɨti'ekwa ka'itiyatɨ puyuhayewa kepauka mɨkɨyɨretsieke. Kemɨ'ane menukweni mɨkɨta yu'ixurikite pɨti'ekwa ka'itiyatɨ pɨyuhayewa kepauka mɨkɨyɨretsieke. ");
INSERT INTO hch_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","»Yutawima memuyukuhapatɨwe xepɨkawakwa'ani, mɨkɨ xepɨwaxani'erieka. ");
INSERT INTO hch_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Xepɨkatewakwa'ani yutawima mukuyeika, yanɨtsɨtɨni yukɨtsimekɨ memu'uwe, yatɨni waɨkawa 'ɨkate memexeiyatɨka. Xeimetɨma xepɨkakwaka yutawima memɨteku'uwa mɨkɨ memɨka'itiyakɨ, ");
INSERT INTO hch_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","xepɨka'ipitɨaka mɨkɨkɨ xeka'itiyatɨ xemakɨnekɨ, mɨkɨ memɨka'itiyakɨ. ");
INSERT INTO hch_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Ne Yawé xekakaɨyari nepɨhɨkɨ, xekeneyupatani xepatsietɨ xekeneyuhayewani, ne nemupatsiekɨ. 'Ayumieme xeka'itiyatɨ xepɨkayuhayewani kwiepa yutawima memɨteku'uwa wahekɨ. ");
INSERT INTO hch_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Ne Yawé nekanihɨkɨtɨni, nemɨxe'ayewitɨ 'Ekipitu kwieyaritsie, xekakaɨyari nemayanikɨ. Xemeta xekenepatsieka ne nemɨpatsiekɨ. ");
INSERT INTO hch_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","»'Ikɨ 'inɨari niukiyari kanihɨkɨtɨni: memɨte'awɨwawe wahetsiemieme, yunaime meta hapa memɨteye'uwa, meta yunaime yutawima memɨteku'uwa, ");
INSERT INTO hch_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","mɨpaɨ xemɨyɨwawenikɨ xemɨwamatenikɨ kemɨ'ane mɨ'itiya meta mɨka'itiya, meta kemɨ'ane memɨtakwani meta kemɨ'ane memɨkatakwa'anikɨ». ");
INSERT INTO hch_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Yawé Muitsexi mɨpaɨ katiniuta'aitɨani ");
INSERT INTO hch_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","'ixaheritsixi mɨpaɨ mɨtiwatahɨawekɨ: «Kepauka 'uka mɨtihukata meta nunutsi 'ukitɨme mɨtiniweni 'atahutamexɨa tukari ka'itiyatɨ puyuhayewani, kepauka xuriya miku'axiya hepaɨ. ");
INSERT INTO hch_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","'Atahaika tukari 'aye'ayu 'uki nunutsi xitekiya 'inɨariyarikɨ pɨ'inɨaritɨarieni. ");
INSERT INTO hch_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Maamaya puyu'itieka xeitewiyari heimana tamamata heimana haika tukari yuxuriya muhanitsitɨakaikɨ. Tixaɨtɨ mɨtipatsie pɨkatikumaɨwani, meta tukita pɨkaheutahakeni, kepaukake 'itiya tukari maye'anitsieke. ");
INSERT INTO hch_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","»Xɨka 'ukatɨme 'utiniweni maamaya ka'itiyatɨ puyuhayewa huta tsemanayari, kepauka xuriya miku'axiyatsie hepaɨ, meta haika tewiyari heimana 'ataxewime tukari puyurieni yu'itietɨ xuriyaya mutaxɨrikɨ. ");
INSERT INTO hch_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","»Kepaukari maye'ani mɨ'itiyanikɨ tukariyari, tsepa nunutsi 'ukitɨme mutiniwexɨ yatɨni xɨka 'ukatɨme 'utiniweni, mɨkɨ xeime muxa panuhana xeiwiyari hɨkame mawari taiyariyari mayanikɨ, meta xeime haɨmɨ, xeimeta weurai 'itiyari mawariyari mayanikɨ, mawari wewiwame hetsɨa pɨranupini, 'ixuriki tukiyarita mɨranutahakitɨretsie, ");
INSERT INTO hch_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","mɨkɨ Yawé hɨxie kanixatɨamɨkɨ. Mawari wewiwame mɨxɨnarieni mawariyari mɨpaɨ pɨtiwewieni 'uka hetsiemieme, mɨkɨ pɨ'itiyani xuriyaya mutayeurikɨ. »'Ikɨ 'aitsika kanihɨtɨni 'ukaratsitsie mieme kepauka 'ukitɨme ya'ukatɨme mɨtiniwenitsie. ");
INSERT INTO hch_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Xɨka muxa mɨnanenikɨ ka'i'axeni, yuhutame weuraixi pɨwaranutɨkɨ yatɨni yuhutame haɨmɨxi, xewitɨ mawari taiyariyari payani xewitɨta 'itiya mawariyari. Mawari wewiwame mɨxɨnarieni mawariyari mɨpaɨ pɨtiwewieni 'uka hetsiemieme, mɨkɨ pɨ'itiyani». ");
INSERT INTO hch_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Yawé Muitsexi meta 'Aruni mɨpaɨ katiniwarutahɨawe: ");
INSERT INTO hch_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","«Xɨka xewitɨ xeme yunawiyaritsie heuhaka xetatɨ kumariketɨ yatɨni tuxatɨ heukumanetɨ 'anutiteketɨ haiya kwiniyayari 'ayanike, mɨkɨ 'Aruni mawari wewiwame mepɨ'atɨirieni, yatɨni mawari wewiwamete 'iparewiwamete. ");
INSERT INTO hch_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Mɨkɨ mawari wewiwame wahaiya pɨtixeiyaxɨani. Xɨka haiyatsie meuka'u huxariteya tuxani yatɨni maukumane waɨkawa heukukunini waiyarieyatsie, mɨkɨ haiya kwiniyayari pɨhɨkɨ. Mɨkɨ tewi kwiniyaya tixeiyaxɨame, 'anari mawari wewiwame pɨtitaxatɨani kename ka'itiyatɨ 'ayani. ");
INSERT INTO hch_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","»Tuxatɨ meukumane xɨka kaheukukunini waiyarieyatsie meta huxariteya katuxani, mawari wewiwame mɨtikuye yuxaɨtame pupata 'atahuta tukari, ");
INSERT INTO hch_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","'atahuta tukari 'aye'ayu hekwamekɨta pixeiya, xɨka yaxeikɨa reu'atɨkani kayemieni nawiyarieyatsie tawarita 'atahuta tukari puyurieni tikwikame. ");
INSERT INTO hch_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","'Atahuta tukari 'aye'atɨarieyu mawari wewiwame tawarita pixeiya hutarieka, xɨkari kwiniya kayemieni waiyarieyatsie yatɨni yeyuximeni, 'anari yapɨtayɨni mɨ'itiyakɨ. Mɨkɨ haiya xetatɨ mukumarike xeikɨa pɨhɨkɨtɨkai, 'anari tewi kani'itiyamɨkɨ mɨtikuye meta yu'ixuriki kaniti'ekwamɨkɨ. ");
INSERT INTO hch_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","»Xɨka yaxeikɨa heu'aneni haiyaya yemieni nawiyarieyatsie, mawari wewiwame 'ixeiyakutɨtɨ para mɨ'itiyanikɨ, tikwikame tawarita mawari wewiwame hetsɨa pumie mixeiyakɨ. ");
INSERT INTO hch_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Mawari wewiwame kanixeiyamɨkɨ mɨkɨ xɨka haiyaya yemieni waiyarieyatsie, mɨkɨ tewi mɨpaɨ pɨtitahɨawarieni haiya kwiniyayari mɨhɨkɨkɨ. ");
INSERT INTO hch_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","»Kepauka tewi haiya mexeiya yunawiyaritsie, mɨkɨ kaneuyeweka manuwitɨkienikɨ mawari wewiwame hɨxie, ");
INSERT INTO hch_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","tawarita pixeiya. Xɨka haiyaya meta huxariteya tuxani, meta meukuhatɨkatsie waiyarieya xɨka 'ayeniereni yuhekɨaka, ");
INSERT INTO hch_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","mɨkɨri haiya meripaitɨ mɨmieme pɨhɨkɨ. Mawari wewiwame mɨkɨ tewi pɨtahekɨata mɨka'itiya mayanikɨ. Matsi mɨkɨ tewi pɨkaheuyewetse hutarieka mɨpatsienikɨ yeuta, mɨmatsiɨkɨkɨri mɨka'itiyakɨ. ");
INSERT INTO hch_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","»Xɨka haiya yemietɨ tikwikame waiyarieyatsie heinɨka, hakewa xeikɨa mawari wewiwame mɨyɨwe mixeiyakɨ, ");
INSERT INTO hch_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","merikɨte mawari wewiwame pixeiya. Xɨkari naitɨ waiyarieyatsie 'inɨka, mɨkɨ yapɨtayɨni kenameri 'itiya. Mɨkɨ tewi pɨ'itiya naitɨri yuwaiyaritsie mutaturixɨkɨ. ");
INSERT INTO hch_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Mɨkɨtsɨ matsi ka'itiyatɨ kanayeimɨkɨ xɨka yapauka 'ukayaxe haiya 'amɨnene. ");
INSERT INTO hch_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Kepauka mawari wewiwame mita'ixɨarieni waiyarieyatsie mɨkɨ pitahekɨata kename ka'itiya. Waiyarieya mɨka'itiyakɨ, haiya kwiniyayari kanihɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Xɨka haiyaya 'amɨnene tuxatɨ 'ayani, mɨkɨ tewi mɨtikuye kaniyemieni mawari wewiwame hetsɨa. ");
INSERT INTO hch_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Mɨkɨ pixeiya xɨka haiya kayaxikeni tuxatɨ, mawari wewiwame mɨkɨ tewi pɨtahekɨata mɨ'itiya pɨhɨkɨtɨni, mɨpaɨ pɨ'aneni. ");
INSERT INTO hch_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","»Xɨka xewitɨ haiya heukayatsani yuwaiyaritsie 'anutitekeme yatɨni kwitɨwa 'anayeweni, ");
INSERT INTO hch_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","xɨka heimana heukateni haiya 'etsiwa tuxatɨ, haiya heukumanetɨ xetatɨ mɨkɨ mawari wewiwame hetsɨa puyutaxata. ");
INSERT INTO hch_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Mɨkɨ mixeiyakɨ. Xɨka haiyaya tetɨatapaitɨ yemieni waiyarieyatsie meta huxariteya 'utiture, mawari wewiwame pitahekɨata mɨka'itiyakɨ. Haiya kwiniyayari kanihɨkɨtɨni meukutekixɨakɨ 'axeikɨa heukatetɨ. ");
INSERT INTO hch_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Matsi kepauka mawari wewiwame tikwikame mɨta'ixɨarienitsie, xɨka huxariteya katitureme 'uxeiya meta haiyaya manutiteke tetɨata kaheuneikatɨ waiyarieyatsie heukateni, meta xɨka yeyuximeni, mɨkɨ 'ateewa pɨpatsieni yuxaɨtame 'atahuta tukari. ");
INSERT INTO hch_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Xɨkari haiyaya manutiteke yeyaxikeni waiyarieyatsie paitɨ tikwikame pɨtahekɨata mɨka'itiyakɨ, haiya kwiniyayari mɨhɨkɨkɨ. ");
INSERT INTO hch_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Xɨkari mɨkɨ haiyaya manutiteke kayeyaxikeni meta kakutureni, xɨka xeikɨa huyeriyari yuhekɨaka, tikwikame pɨtahekɨata kename 'itiya. ");
INSERT INTO hch_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","»Xɨka xewitɨ 'ukwaxe, hakewa metakwaxixɨtsie xɨka tuxatɨ yatɨni xetatɨ haneni, ");
INSERT INTO hch_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","mɨkɨ mawari wewiwame pixeiya, xɨka mamarixɨtsie huxariteya tuxani, xɨka waiyarieyatsie waɨkawa heukukunini, mɨkɨ haiya kwiniyayari kanihɨkɨtɨni haiya mukwaxixɨtsie mane. Mawari wewiwame tikwikame pɨtahekɨata mɨka'itiyakɨ, haiya kwiniyayari mɨhɨkɨkɨ. ");
INSERT INTO hch_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","»Matsi xɨka mawari wewiwame mukwaxixɨ xeiyayu xɨka 'ikaxeiya huxariteya katuxame meukumanetsie meta waɨkawa xɨka waiyarieyatsie paitɨ kaheukukunini, meta xɨka hanukanuaximeni, 'ana mɨkɨ tikwikame 'atahuta tukari yuxaɨtame putuiyamie yateewa paitɨ. ");
INSERT INTO hch_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","'Atahuta tukari 'aye'ayu mawari wewiwame tawarita pixeiya, xɨka naitsarie 'inɨka waiyarieyatsie mɨkɨ yapɨtayɨni kename ka'itiya, haiya kwiniyayari kanihɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Matsi mɨkɨ mukuture nawiyarieyatsie xɨka kayemieni, tatsɨari mɨkɨ mutataikɨ xeikɨa hatɨ. 'Ana mawari wewiwame yapɨtitahekɨata mɨ'itiyakɨ, mɨkɨ xeikɨa mutataikɨ 'inɨariyari mɨhɨkɨkɨ. ");
INSERT INTO hch_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","»Xɨka xewitɨ 'uki yatɨni 'ukaratsi haiya mu'uyatsie haneni yatɨni mɨxiyayatsie, ");
INSERT INTO hch_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","mawari wewiwame haiya kanixeiyamɨkɨ. Xɨka waiyarieyatsiepai waɨkawa heukukunini, meta kɨpaya tataxawini 'etsipepetɨ, mɨkɨ tikwikame pɨtahekɨata kename ka'itiya. Mɨkɨ haiya xetatɨ mukumarike kanihɨkɨtɨni haiya mu'utsie yatɨni 'ayekwaitsie mieme. ");
INSERT INTO hch_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Xɨka mawari wewiwame 'etsa xeiyayu, waɨkawa waiyarieyatsie kaheunetɨkani meta kɨpateya kayɨyɨwini, mɨkɨ mɨtikuye haiya xetatɨ mukumarike mexeiya 'ateewa paitɨ pupatsieni yuxaɨtame 'atahuta tukari. ");
INSERT INTO hch_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Hikɨ 'atahuta tukari 'aye'ayu mawari wewiwame tawarita tikwikame kanixeiyamɨkɨ, xɨka haiya xetatɨ mukumarike kayemieni meta kɨpateya katataxawini, meta waɨkawa kaheukukunini waiyarieyatsie. ");
INSERT INTO hch_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","Hikɨ 'anari tikwikame panuyuyexini, mahatsie 'ihayewatɨ, hikɨ mawari wewiwame tawari xaɨtsie pipata yuxaɨtame 'atahuta tukari. ");
INSERT INTO hch_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Tawarita 'atahuta tukari 'aye'ayu mawari wewiwame tikwikame kanixeiyamɨkɨ. Xɨkari haiya xetatɨ mukumarike 'anukanuaximeni waiyarieyatsie meta waɨkawa kaheukukunini, yapɨtitahekɨata kenameri 'itiya. Hikɨ tikwikame yu'ixurikite kaniti'ekwamɨkɨ 'anari 'itiyatɨ kanayeimɨkɨ. ");
INSERT INTO hch_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","»Xɨkari haiya xetatɨ mukumarikekɨ 'u'itiyakaitɨni hutariekata 'i'axiyani naitɨri waiyarieya nɨka, ");
INSERT INTO hch_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","mawari wewiwame pixeiya. Xɨka haiya xetatɨ mukumarike yemieni naitɨ waiyarieyatsie paitɨ, pɨkaheuyewetseri mawari wewiwame kɨpa mɨtataxawi mɨwaunenikɨ, mɨkɨ tikwikameri pɨka'itiya. ");
INSERT INTO hch_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Matsi xɨka mɨkɨ haiya xetatɨ mukumarike kayemieni metatsiere kɨpateya yɨyɨwitɨ kayɨyɨrani, tatsɨari mɨtikuyekai 'anayeweka. Pɨ'itiyari, mawari wewiwame mɨpaɨ katinitahekɨatamɨkɨ. ");
INSERT INTO hch_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","»Xɨka 'uki meta 'ukaratsi tuxatɨ kumariketɨ kuneikani waiyaritsie, ");
INSERT INTO hch_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","mɨkɨ mawari wewiwame pixeiya. Xɨka maukumane kutuxareni, mɨkɨ waiyarieyatsie manutinexɨa xeikɨa kanihɨkɨtɨni, mɨkɨ tewi pɨ'itiya. ");
INSERT INTO hch_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","»Xɨka xewitɨ yukatutsitɨa hahune, hametsetɨ yuhayewa, mɨkɨ pɨ'itiya. ");
INSERT INTO hch_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Mexɨka yukanatsie 'akahune kanametsetɨ yuhayewa yaxeikɨatatsiere mɨkɨ pɨ'itiya. ");
INSERT INTO hch_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Matsi xɨka yukatutsitɨa meta yukanatsie mametsetsie haiya xetatɨ haneni, mɨkɨ haiya mametsetsie mane pɨhɨkɨ. ");
INSERT INTO hch_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Mawari wewiwame pixeiya. Xɨka haiyaya xetani, yuwaiyaritsie meuhaka hepaɨ 'aneneni, ");
INSERT INTO hch_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","kamɨtsɨ mɨkɨ tewi haiya kwiniyayarikɨ pɨtikuye pɨka'itiya. Mawari wewiwame pitahekɨata kename ka'itiya yumu'utsie haiya mayetsakɨ. ");
INSERT INTO hch_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","»Xɨka xewitɨ tewi haiya hexeiyani, mɨkɨ tsanimekɨ pɨyukemaritɨaka, pɨkayukatsikeni yuhɨxie panuyuka'eimani. Pɨyemie 'utahiwatɨ mɨpaɨ 'utaitɨ: “Nepɨka'itiya, nepɨka'itiya”, ");
INSERT INTO hch_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","mɨkɨ kemɨreutere tikuyetɨ pɨka'itiyaka. Mɨkɨ mematiteitsie yuxaɨtame 'ateewa pukani. ");
INSERT INTO hch_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","»Kepauka kwiemuxa 'ixurikiyari yatɨni rinu 'ixurikiyaritsie waɨkawa mɨtimutuxaxɨani, ");
INSERT INTO hch_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","rinu 'ixurikiyari yatɨni tsepa muxa kamixayaritsie yatɨni nawitsie yatɨni mɨkɨ maye'itsetsie xɨka yuhekɨare, ");
INSERT INTO hch_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","xɨka 'etsiwa tsiuraɨyeni yatɨni xetani mɨkɨ mutuxariyari muwerixɨ kanihɨkɨtɨni, peuyewetse mawari wewiwame mɨxeitsitɨanikɨ, ");
INSERT INTO hch_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","mɨkɨ meukuwetɨka kanixeiyamɨkɨ meta 'atahuta tukari 'ateewa putuiyamie titatsie mɨtiwena. ");
INSERT INTO hch_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","'Atahuta tukari 'aye'ayu mawari wewiwame mawena kanixeiyamɨkɨ, xɨka mɨkɨ yemieni kamixatsie yatɨni maye'itsetsie, yatɨni nawitsie, tsepa kemɨtitita mɨkɨ mutuxariya mutiyuwiriwe kanihɨkɨtɨni. Mɨkɨ mɨya mɨ'ane pɨka'itiya. ");
INSERT INTO hch_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Mɨkɨ 'iwi yatɨni maye'itse, kwiemuxa, rinu tsepa kemɨtititatsie nawitsie mɨrawena, mɨkɨ mutuxariya 'axamɨ'ane mɨhɨkɨkɨ pɨtataiyarieni. ");
INSERT INTO hch_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","»Matsi kepauka mawari wewiwame 'iwi mɨxeiya mutuxariya kayemieme, meta maye'itsetsie meta mi'itatɨkateitsie, meta muxa 'itariyari meta rinu tsawanayari meta tsepa kemɨtitita nawiyari, ");
INSERT INTO hch_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","hikɨ mɨkɨ pɨtita'aita mahauxinarienikɨ mapɨnitsie, meta tawarita 'akuxi 'atahuta tukari pɨyekani. ");
INSERT INTO hch_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Xeimieme tahauxinarieyu meukupɨpɨnitsie mawari wewiwame pita'ixɨarieni. Xɨka yaxeikɨa 'aneni mukumarike kayupatani, mɨkɨ mɨpaɨ pɨtayɨni 'ixuriki ka'itiyatɨ puyuhayewa tsepa mɨka'eyewiriewe naime. Naitɨ 'ixuriki pɨtataiyarieni taɨtana meta herie. ");
INSERT INTO hch_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","»'Arike ti'ekwarieyu, mawari wewiwame mixeiyatsie xɨka 'ixeiya heukuwetɨkaime 'etsiwa, mɨkɨ 'ixuriki peukutsanaxɨani 'iwitsie meukuwetɨka, meta nawitsie, meta maye'itsetsie. ");
INSERT INTO hch_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Xɨka hekwamekɨ heukunexɨani kemaritsie yatɨni maye'itsetsie yatɨni tsepa kemɨtitita nawitsie, tatsɨari tawari hanutineka. Mɨyama'anetsie pataiyarieni, ");
INSERT INTO hch_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","peru naitɨ kemarite, maye'itsetsie meta nawitsie kepauka mɨta'ekwarienitsie meukuwetɨkateitsie xɨka hayeixɨani, tawarita pɨta'ekwarieni, 'ana mɨkɨ 'itiyatɨ payani». ");
INSERT INTO hch_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","'Ikɨ 'inɨari niukiyari kanihɨkɨtɨni mutuxariyatsie mieme kemaritsie muweriwe, kwiemuxatsie, rinutsie, maye'itsetsie, yatɨni tsepa tita nawitsie, yamɨtitahekɨatsieninikɨ kemuti'itiya yatɨni kemɨkati'itiya. ");
INSERT INTO hch_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Yawé Muitsexi mɨpaɨ katiniutahɨawe: ");
INSERT INTO hch_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","«'Ikɨ 'inɨari niukiyari kanihɨkɨtɨni tewi kemɨ'ane meu'etsa mɨ'itiyanikɨ, mɨkɨ mawari wewiwame hɨxie panuwitɨkieni, ");
INSERT INTO hch_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","mɨkɨ yateewa paitɨ mematiteitsie pixeiya. Xɨka mawari wewiwame ya'utayɨni kenameri tewi meu'etsakai 'aixɨa reu'erietɨ 'atɨa, ");
INSERT INTO hch_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","mɨkɨ tewi pɨtita'aitɨani mɨ'itiyanikɨ yuhutame wikixi me'ayeneniereme me'itiyatɨkaime mɨwa'atɨanikɨ, meta xeime 'etsi'atayeukame kariuxa kɨyeyari, meta xeime tuwaxa xetame, xeimeta hitsupu yaranukaime. ");
INSERT INTO hch_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Hikɨ mawari wewiwame pɨtita'aita wiki xewitɨ meri muwaxitekienikɨ, haa haixata mieme haxu xariyarita hɨnetɨ muyemata heima. ");
INSERT INTO hch_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Xeimeta wiki mayeniere kanitituimɨkɨ, kariuxa mexayari, tuwaxa mɨtaɨraɨye meta hitsupu xawariyari, mɨkɨ pitahawiya naime yunɨkame wiki muwaxitekie xuriyaya haa mɨnɨ'ɨ haixata miemekɨ. ");
INSERT INTO hch_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Mɨkɨkɨ 'atahutamexɨa pɨ'ɨya kemɨ'ane mɨtikuye mɨ'itiyanikɨ, 'anari 'itiyakame payeitɨani. Hikɨ wiki pɨtatuani mayeniere yeuta mɨyemiekɨ. ");
INSERT INTO hch_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","»Kemɨ'ane mɨyu'itie mɨkɨ yu'ixuriki pɨti'ekwa, yukɨpa naime pɨkaxini meta pɨti'ɨwa. Mɨpaɨke 'itiyatɨ payani. Mɨpaɨ tiyuriemeke pɨyɨweni memakuteitsie meutahanikɨ, matsi 'akuxi yukiita pɨkaheutahani, matsi 'akuxi 'atahuta tukari takwa paitɨ puhupuni. ");
INSERT INTO hch_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","'Atahutarieka tukaritsie naime puyukaxini, meta yumɨxiya naime pataxini meta yukarimuxi, yu'ixurikite pɨti'ekwa meta pɨti'ɨwa. 'Anake 'itiyatɨ payani. ");
INSERT INTO hch_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","»'Atahairieka tukaritsie 'aye'ayu, kemɨ'ane mɨ'itiyani mɨkɨ yuhutame muxatsi 'ukitsi pɨwa'atɨani xeimeta 'ukatɨme xeiwiyari hɨkame 'aixɨa me'anenekame, tɨriku mawariyari 'imikieriyari, 'ataxewime kiruyari kani'atɨamɨkɨ tɨriku mɨtɨxiyari 'aixɨa mɨ'ane hatseitikɨ pɨnariekame meta hatseiti xeiwatsuyari yunɨkame. ");
INSERT INTO hch_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Mawari wewiwame kemɨ'ane mɨ'itiyani muwewieni Yawé hɨxie piyetuani, 'ixuriki tukiyari kitenie, kemɨ'ane muyu'itieni meta mawarieya. ");
INSERT INTO hch_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","'Arike mawari wewiwame xeime muxa panuhana meta hatseiti yunɨkame, mawari pixatɨani mɨrayukatuani mawariyari mayanikɨ. 'Iyuitɨwatɨ Yawé hɨxie, mɨkɨ 'imikieri teikɨ heitseratɨ 'uyuitɨariwatɨ mɨhɨkɨkɨ. ");
INSERT INTO hch_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Manata hakewa makupatsietsie muxa puwaxiteni, hakewa tita mɨtimawarie mematikwikwiwatsie tatsɨari 'itiya mawariyari meta mawari taiyariyari matiwewiwatsie, mɨrayukatuani mawariyari meta 'itiya mawariyari, mawari wewiwame hetsie kanimiemetɨni. Mɨkɨ waɨkawa kanipatsieka. ");
INSERT INTO hch_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Hɨkɨ mawari wewiwame xuriya yapaɨmeme ti'ɨme mɨrayukatuani mawariyaritsie mieme, kemɨ'ane mɨ'itiyani nakaya heima tserietana mieme puwirieni, meta mamaya 'itɨwameteya 'amupayaritsie tserietana mieme, metatsiere 'ɨkaya 'amɨpayaritsie tserietana mieme. ");
INSERT INTO hch_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Mawari wewiwame hatseiti yapaɨmeme 'anatuame yumamá meuweweritsie yu'utatamiemetsie. ");
INSERT INTO hch_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Yu'itɨwame yutserieta mieme pɨtahawiya hatseitikɨ yumamá meuweweritsie yutserieta miemetsie menatuakaikɨ, hatseiti kani'ɨyamɨkɨ Yawé hɨxie 'atahutamexɨa. ");
INSERT INTO hch_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Meta hatseiti 'akuxi mawari wewiwame mamayatsie muyuhayewa, kemɨ'ane muyu'itieni 'etsiwa nakaya tserietanatsie pɨwirieni, meta mamaya 'itɨwameteya 'amupayaritsie tserietana mieme, metatsiere 'ɨkaya 'amɨpayaritsie tserietana mieme, xuriya mɨrayukatuani mawariyari heima. ");
INSERT INTO hch_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Hatseiti mawari wewiwame mamayatsie muyuhayewa kemɨ'ane muyu'iti mu'uyatsie peitituani. Mɨpaɨ pɨtiyurieni mɨkɨ mɨxɨnarienikɨ Yawé hɨxie. ");
INSERT INTO hch_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Hikɨ mawari wewiwame 'itiya mawariyari puwewieni, yatiyurienetɨ mɨxɨnarieni mawariyarikɨ kemɨ'ane mɨyu'itie tita mɨkati'itiyakɨ. Mɨpaɨ tiyurieme tita mɨtimawa puwaxiteni mawari taiyariyaritsie mieme, ");
INSERT INTO hch_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","mawari taiyametsie mawari taiyariyari pautiteni tɨriku mawariyari yɨnɨkame piyetuirieni. Mɨpaɨ mɨxɨnarieni mawariyari pɨtiwewieni hetsiena mieme, 'itiyatɨ kanayeimɨkɨ. ");
INSERT INTO hch_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","»Kemɨ'ane mɨ'itiyani xɨka tixaɨtɨ karexeiyani meta minanenikɨ tita mɨra'iwauriwa ka'i'axeni, mɨkɨ xeime muxa panuhana mawari mɨrayukatuani mawariyari mayanikɨ, mɨkɨ teikɨ petserarieni 'uyuitɨariwatɨ mɨkɨ mɨxɨnarienikɨ. Meta hatsite 'imikieriyari panutɨni, huta kiruyari tɨriku mɨtɨxiyari 'aixɨa mɨ'ane hatseitikɨ pɨnariekame meta hatseiti xeiwatsuyari, ");
INSERT INTO hch_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","yuhutame weuraixi yatɨni haɨmɨxi, kemɨtiyɨweni titakɨ mɨtiyutuani xewitɨ 'itiya mawariyari mayanikɨ xewitɨta mawari taiyariyari. ");
INSERT INTO hch_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","'Atahuta tukari 'aye'ayu, tukita pɨwaranuhapani, mawari wewiwame hɨxie, para Yawé hɨxie mɨ'itiyanikɨ. ");
INSERT INTO hch_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Mawari wewiwame muxa panuhana meta hatseiti nɨkame pixatɨani, Yawé hɨxie teikɨ heitseratɨ 'iyuitɨwatɨ pixatɨani, mɨkɨ 'imikieri teikɨ heitseratɨ 'uyuitɨariwatɨ mɨhɨkɨkɨ. ");
INSERT INTO hch_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","'Arike muxa pɨwaxiteni 'imikieri mɨrayukatuani mawariyari mɨhɨkɨ, 'etsiwa xuriya kwewieme nakaya tserietana miemetsie piwirieni, meta 'itɨwameya 'amupayaritsie, meta 'ɨkayatsie mieme 'amɨpayari tserietana mieme kemɨ'ane muyu'itieni hetsie, ");
INSERT INTO hch_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","mawari wewiwame hatseiti yumamá yu'utata meuweweritsie peutituani, ");
INSERT INTO hch_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","meta yu'itɨwame yutserieta miemekɨ 'atahutamexɨa pi'ɨya, Yawé hɨxie. ");
INSERT INTO hch_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Meta kemɨ'ane muyu'itieni mawari wewiwame hatseiti mamayatsie muyuhayawaxɨkɨ 'etsiwa piwirieni. Nakaya heima tserietana miemetsie meta 'itɨwameya 'amɨpayari tserietana miemetsie meta 'ɨkayatsie mieme 'amɨpayari tserietana mieme, hakewa xuriya mɨrayukatuani mawariyari meyutawiritsie. ");
INSERT INTO hch_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Hatseiti muyuhayewa mawari wewiwame mamayatsie kemɨ'ane muyu'itieni mu'uyatsie pɨkawirieni, Mɨpaɨ mɨkɨ mɨxɨnarieni mawariyari pɨtiwewieni Yawé hɨxie. ");
INSERT INTO hch_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Hikɨta wauraixi pɨwayetuani yatɨni haɨmɨxi, mɨkɨ kemɨtiyɨweni mɨtiyutuanikɨ, ");
INSERT INTO hch_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","xewitɨ 'itiya mawariyari payani, xewitɨta mawari taiyariyari, hatsite yunɨkame mɨtataiyarienikɨ. Mɨpaɨ mawari wewiwame mɨxɨnarieni mawariyari pɨtiwewieni hetsiena mieme, Yawé hɨxie kemɨ'ane mɨyu'itieni». ");
INSERT INTO hch_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","'Ikɨ 'inɨari niukiyari pɨwewiyarieni xɨka tewi yuwaiyaritsie heuhatɨ nuani, xɨka kaheixeiyani mɨtiyutuanikɨ 'imikieri 'aixɨa 'anekame kɨmana mɨ'itiyanikɨ. ");
INSERT INTO hch_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Hikɨ Yawé Muitsexi meta 'Aruni mɨpaɨ katiniwarutahɨawe: ");
INSERT INTO hch_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","«Xeme kepauka xemeutahaxɨanitsie Kanani kwieyaritsie, nemɨxeyetuirie xehetsiemieme mayanikɨ, ne hipame xekitetsie mutuxariya mɨtiyuwiriwe nepawetsitɨaxɨani, ");
INSERT INTO hch_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","kii kutsiyari mawari wewiwame mɨpaɨ pɨtitahɨawe: “Nekiita mutuxariya kanawetɨkani”. ");
INSERT INTO hch_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Hikɨ mawari wewiwame kaheutahawetɨ 'akuxi mɨreukuwetɨka xeiyake pɨwata'aitɨani yukiita memɨtewayepinikɨ, kapa yutiwirienikɨ tita muwa mɨrayepine. Mɨpaɨ tiyurieme mawari wewiwame peutahani mixeiyakɨ. ");
INSERT INTO hch_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Meukuwetɨka 'ixumeritsie 'etsiwa tsitsiɨrawitɨ, xetatɨri 'ixumeritsie heuyunixɨaximeni, ");
INSERT INTO hch_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","mawari wewiwame kiita pɨwayeyani, pureunani 'atahuta tukari xewitɨ muwa pɨkaheutahakeni. ");
INSERT INTO hch_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","'Atahutarieka tukarietsie punuani pixeiya. Xɨka 'akuxi 'ixumeritsie yemieni matsi waɨkawa, ");
INSERT INTO hch_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","pɨtita'aita tetexi mamutuxietɨka manayetɨkiexɨanikɨ meta kiekari manuniere yateewa mɨtixɨriyanikɨ hakewa mɨkahaku'itiyarietsie. ");
INSERT INTO hch_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Yaxeikɨata pɨtita'aita kii taɨta meta mukaherɨkarie kiekarie manuniere yateewa pɨtixɨriyani, hakewa mɨkahaku'itiyatsie. ");
INSERT INTO hch_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","'Ariketa tetexi memeukɨtɨkixɨatsie hehekwame mepɨkayatsa, 'anari 'aixɨa kii 'anetɨ payani mutahekwariyariekɨ haxu 'ukawiriyarieka. ");
INSERT INTO hch_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","»Xɨka 'arike tetexi mewakutɨkɨyu mɨreukuwetɨkatei meta kiitata 'aixɨa mewakuyurieyu, tawarita mutuxariya 'uhekɨare meta naitɨ kiita 'uwakuwere, ");
INSERT INTO hch_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","mawari wewiwame pɨmie mixeiyakɨ. Xɨka mutuxariya naitsarie kiita wakuneni, mɨkɨ mutuxariya mɨtiyuka'unawe pɨhɨkɨ. Mɨkɨri kii pɨka'itiya. ");
INSERT INTO hch_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Mɨkɨ kaneuyeweka titɨxieme mewiwiyanikɨ, hakewa mɨkahaku'itiyarietsie kiekari tetsitapai, meta 'ixumeriyari meta tetexi mexate naitɨ pexɨriyani. ");
INSERT INTO hch_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","»Xɨka xewitɨ kiita heutahani mexi 'akuxi reunameni, mɨkɨ ka'itiyatɨ puyuhayewa kepauka mɨkɨyɨretsieke, ");
INSERT INTO hch_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","meta kemɨ'ane muwa kiita meukuni yatɨni muwa mɨtikwani yu'ixɨrikite kaniti'ekwamɨkɨ. ");
INSERT INTO hch_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","»'Arike kii 'aixɨa 'itɨarieyu, mawari wewiwame mutuxariya pɨxeiya xɨka kayemieni, mɨkɨ kenameri 'itiya pɨtitahekɨatsieni, meukuwetɨkateiri meukuyunixɨakɨ. ");
INSERT INTO hch_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","»Mawari wewiwame kii mɨ'itienikɨ yuhutame wikixi kaniwaranutɨkimɨkɨ, kariuxa mexayari 'etsihatayeukame meta hitsupu xawariyari, yaxeikɨata tuwaxa mɨxeta. ");
INSERT INTO hch_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Xeime wiki pɨwaxiteni haxu xariyarita haa muyemata haixata mieme muwa xuriyaya kaneukatuamɨkɨ, ");
INSERT INTO hch_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","kariuxa kɨyeyari panukweni, meta hitsupu xawariyari meta tuwaxa mɨxeta, xeimeta wiki mayeniere, 'ikɨ naime mekatenitiwirikuni wiki muwaxitekie xuriyayakɨ meta haa haixata miemekɨ. ");
INSERT INTO hch_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Hikɨta mɨkɨkɨ kii 'atahutamexɨa pɨ'ɨya, pi'itieni wiki xuriyayakɨ meta haa haixata miemekɨ, wiki mayenierekɨ, kariuxa kɨyeyari, hitsupu xawariyari meta tuwaxa mɨxetakɨ. ");
INSERT INTO hch_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Hikɨ wiki pɨtatuani mayeniere yeuta paitɨ. Mɨpaɨ kii mɨxɨnarienikɨ mawariyari pɨtiwewieni, 'anari 'itiyatɨ puyuhayewa. ");
INSERT INTO hch_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","»'Ikɨ 'inɨari niukiyari pɨhɨkɨ mɨreuyehɨwiyarienikɨ, tsepa kemɨtitita haiya xetatɨ mukumarike waiyarieyatsie, ");
INSERT INTO hch_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","yatɨni mutuxariyakɨ, 'ixurikitetsie yatɨni kiita 'ixumeritsie heukuwetɨkani, ");
INSERT INTO hch_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","yatɨni xɨka 'utahani, yatɨni haiya, yatɨni tuxatɨ heukunexɨani, ");
INSERT INTO hch_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","mɨyɨwenikɨ mɨti'ɨkitanikɨ naitsarie kepauka tita mɨti'itiya yatɨni mɨkati'itiyakɨ. 'Ikɨ 'inɨari niukiyari kanihɨkɨtɨni kwiniya mɨtiyuwiriwe hetsiemieme». ");
INSERT INTO hch_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Yawé Muitsexi meta 'Aruni 'ipaɨ katiniwaruta'aitɨani, ");
INSERT INTO hch_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","'ixaheritsixi mɨpaɨ memɨtewatahɨawekɨ: «Xɨka xewitɨ 'ukitɨtɨ tiuhanitsitɨaka, tita mɨtiuhanitsitɨa mɨkɨ paka'itiya, ");
INSERT INTO hch_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","yaxeikɨata 'uki, xɨka tiwatiyeuriwani yatɨni hawaikɨ. »Mɨkɨ mɨtiuhanitsitɨakɨ kati'itiyakame pɨrayeitɨani 'ikɨ hetsie: ");
INSERT INTO hch_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","»Ka'itiyatɨ pɨrayani naitɨ mɨtiuhanitsitɨa hakewa mekahupunitsie, yaxeikɨatatsiere naitɨ titatsie mɨrayeixani. ");
INSERT INTO hch_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","»Kemɨ'ane 'itarieya meta mukahuputsie mɨtitimayɨani mɨkɨ yu'ixuriki kaniti'ekwamɨkɨ meta kaniti'ɨwamɨkɨ, mɨkɨ ka'itiyatɨ kaniyuhayewamɨkɨ kepauka mɨkɨyɨretsieke. ");
INSERT INTO hch_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","»Kemɨ'ane mana mayerɨni hakewa mɨtiuhanitsitɨa mayatsie, mɨkɨ yu'ixuriki kaniti'ekwamɨkɨ meta kaniti'ɨwamɨkɨ, ka'itiyatɨ kaniyuhayewamɨkɨ kepauka mɨkuyɨretsieke. ");
INSERT INTO hch_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","»Kemɨ'ane mɨtiuhanitsitɨa memɨmayɨani, mɨkɨta yaxeikɨa kaniyuti'ekwamɨkɨ meta hakɨ kaniti'ɨwamɨkɨ, 'ana ka'itiyatɨ kaniyuhayewamɨkɨ kepauka mɨkɨyɨretsieke. ");
INSERT INTO hch_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","»Xɨka mɨtikuye tiuhanitsitɨatɨ xeime mɨ'itiya 'u'aɨtsikawiya, mɨkɨ yu'ixurikite pɨti'ekwa meta pɨti'ɨwa, 'ana ka'itiyatɨ puyuhayewa kepauka mɨkuyɨretsieke. ");
INSERT INTO hch_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","»Mɨkɨ tewi mɨtikuye tiuhanitsitɨatɨ xɨka puxu xirayatsie 'anutiyerɨni, mɨkɨta ka'itiyatɨ kaniyuhayewamɨkɨ. ");
INSERT INTO hch_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","»Kemɨ'ane tsepa kemɨtitita mɨtimayɨani tikwikame mɨtiuhanitsitɨa hetɨa mɨrayepikai mɨti'itakai ka'itiyatɨ kaniyuhayewamɨkɨ kepauka mɨkɨyɨretsieke. Kemɨ'ane mɨkɨ piinite mɨranupini peuyewetse yu'ixurikite mɨti'ekwakɨ meta mɨti'ɨwakɨ, meta 'ana ka'itiyatɨ puyuhayewa kepauka mɨkɨyɨretsieke. ");
INSERT INTO hch_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","»Mɨtiuhanitsitɨa xɨka xeime 'umayɨani hakɨ kakamaimawetɨ, kemɨ'ane mumayɨiya mɨkɨ yu'ixuriki pɨti'ekwa meta puti'ɨwa 'ana ka'itiyatɨ puyuhayewa kepauka mɨkɨyɨretsieke. ");
INSERT INTO hch_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","»Xɨka mɨtiuhanitsitɨa haxukɨ mɨtiwewiya tiumayɨani, tita mɨtiumayɨiya kanitatarariemɨkɨ, meta kɨye mexayari xɨka 'umayɨani mɨkɨ hakɨ kanitahauxinariemɨkɨ. ");
INSERT INTO hch_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","»Xɨka tikwikame mihanitsitɨakai heunuani, 'atahutamexɨa tukari kanikwewimɨkɨ mɨkɨ mɨ'itiyanikɨ. 'Anari yu'ixurikite kaniti'ekwamɨkɨ meta kaniti'ɨwamɨkɨ haa haixata miemekɨ, 'anari 'itiyatɨ kanayeimɨkɨ. ");
INSERT INTO hch_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","'Atahairieka tukaritsie yuhutame wauraixi yatɨni yuhutame haɨmɨxi puwaranɨtɨkɨ, Yawé hɨxie kaniyuhekɨatamɨkɨ, 'ixuriki tukiyarita mɨreutahakitɨretsie. Muwa memawɨwawe kaniwayetuamɨkɨ mawari wewiwame hetsɨa, ");
INSERT INTO hch_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","mɨkɨri xeime pɨyetuani mɨ'itiyani mawariyari mayanikɨ, xeimeta mawari taiyariyari mayanikɨ. Mawari wewiwame mɨpaɨ pɨtiyurieni Yawé hɨxie, mɨtikuye mɨxɨnarienikɨ mawariyari mɨtiuhanitsitɨakaikɨ. ");
INSERT INTO hch_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","»Kepauka 'uki mɨtiwatituani, mɨkɨ peuyewetse yuwaiyaritsie naitɨ mɨti'ɨwa, 'ana ka'itiyatɨ pɨyuhayewa kepauka mɨkuyɨretsieke. ");
INSERT INTO hch_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Xɨka 'ixurikitsie 'ukatsune yatɨni waiyarieyatsie, mɨkɨ pahauxinarieni, 'ana ka'itiyatɨ puyuhayewa kepauka mɨkɨyɨretsieke. ");
INSERT INTO hch_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","»Kepauka 'uki 'uka hamatɨa memɨyukumayɨanitsie xɨka tiwatituani, mɨkɨ yuhutatɨ mepɨti'ɨwa 'ana meka'itiyatɨ 'akuxi mepuyuhayewa kepauka mɨkuyɨretsieke. ");
INSERT INTO hch_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","»Kepauka 'ukaratsi xuriya mita'axiyatsie maye'ani, 'atahuta tukari ka'itiyatɨ puyuhayewa. »Kemɨ'ane mikumayɨani mɨkɨ ka'itiyatɨ puyuhayewa kepauka mɨkuyɨretsieke. ");
INSERT INTO hch_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","»Tsepa ketititatsie mɨkɨ mɨrahuni xuriya 'i'axiyakaku 'akuxi ka'itiyatɨ puyuhayewa. »Tsepa ketititatsie mɨkɨ mɨrayeixani xuriya 'i'axiyakaku 'akuxi ka'itiyatɨ puyuhayewa. ");
INSERT INTO hch_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","»Mɨkɨ 'uka 'utaya kemɨ'ane mɨmayɨani yu'ixurikite pɨti'ekwa meta pɨti'ɨwa, 'ana ka'itiyatɨ puyuhayewa kepauka mɨkɨyɨretsieke. ");
INSERT INTO hch_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","»Kemɨ'ane mɨkɨ tita hetsie marakatei mɨtimayɨani, mɨkɨ yu'ixuriki kaniti'ekwamɨkɨ meta kaniti'uwamɨkɨ 'ana ka'itiyatɨ puyuhayewa kepauka mɨkɨyɨretsieke. ");
INSERT INTO hch_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","»Xɨka xewitɨ tiukumayɨani tixaɨtɨ 'utayatsie mɨrapikai yatɨni hakewa mɨkɨ mayatsie, mɨkɨ ka'itiyatɨ kaniyuhayewamɨkɨ kepauka mɨkuyɨretsieke. ");
INSERT INTO hch_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","»Xɨka xewitɨ 'uki mɨkɨ 'uka 'ukumayɨani, mɨkɨ kati'itiyakame mɨrexeiya hetsiena puyuhayewa, 'anari ka'itiyatɨ payani 'atahuta tukari. Yaxeikɨata tsepa mɨkɨ hakewa 'utatsie mekahuni ka'itiyatɨ puhuhayewa. ");
INSERT INTO hch_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","»Xɨka 'uka xuriya 'uhanitsitɨaka tukarieya ka'aye'awekaku meti'axiyatsie, xɨkari mɨixa tukari mɨpaɨ 'aneni, ka'itiyatɨ kaniyuhayewamɨkɨ 'atsita kemɨreutereke, xuriya meti'axiya hepaɨ. ");
INSERT INTO hch_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","»Ke'aneme 'utatsie mɨkahuni mexi 'akuxi kwiniyaya kaheunuaweni ka'itiyatɨ kaniyuhayewamɨkɨ, xuriya mi'axiyani hepaɨ. »Tsepa titatsie mɨrayerɨni mɨkɨ ka'itiyatɨ kaniyuhayewamɨkɨ, xuriya mi'axiyani hepaɨ. ");
INSERT INTO hch_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","»Kemɨ'ane mɨkɨ naime tipiinieya mɨtikumayɨani mɨkɨ ka'itiyatɨ payani. 'Ayumieme kaneuyeweka yu'ixurikite mɨti'ekwakɨ meta mɨti'ɨwakɨ, 'ana ka'itiyatɨ puyuhayewa kepauka mɨkɨyɨretsieke. ");
INSERT INTO hch_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","»Kepaukake mɨtiuhanitsitɨakai maunuani, mɨkɨ 'atahuta tukari pikwewieni mɨ'itiyanikɨ. ");
INSERT INTO hch_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","'Atahairieka tukaritsie yuhutame wauraixi yatɨni yuhutame haɨmɨxi, pɨwaranutɨkɨ 'ixuriki tukiyarita mɨranutahakitɨretsie, muwa mawari wewiwame pɨyetuirieni, ");
INSERT INTO hch_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","mɨkɨri xeime pɨyetuani 'itiya mawariyari mayanikɨ, xeimeta mawari taiyariyari mayanikɨ. Mawari wewiwame mɨpaɨ pɨtiyurieni Yawé hɨxie mɨtiuhanitsitɨakai mɨxɨnarienikɨ. ");
INSERT INTO hch_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","»Xeme mɨpaɨ xeteyurietɨ xekaniwapatakakuni 'ixaheritsixi meka'itiyatɨ memɨkayuhayewanikɨ. Mɨpaɨ xeteyurieyu mɨkɨ mepɨkakwini netuki muyepatsie wahixɨata muwe metsewiximayu. ");
INSERT INTO hch_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","»'Ikɨ 'inɨari niukiyari kemɨ'ane ka'itiyatɨ muyuhayewa kaniwewiyariemɨkɨ tiwatiyeurieme, ");
INSERT INTO hch_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","kemɨ'ane xuriya mita'axiya, tsepa 'uki meta tsepa 'ukaratsi xɨka tiuhanitsitɨaka, kemɨ'ane memuyukumayɨani, metatsiere kemɨ'ane 'ukaratsi ka'itiyakame mukumayɨani». ");
INSERT INTO hch_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Yawé Muitsexi mɨpaɨ katiniutahɨawe. 'Aruni niwemama yuhutatɨ me'ukwikuri, meheutahaxɨaka memukwi Yawé hɨxie 'atsimekatemaitɨ. ");
INSERT INTO hch_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Yawé Muitsexi mɨpaɨ katiniutahɨawe: «'A'iwa 'Aruni mɨpaɨ ketineutahɨawi hau'erietɨ pɨkaheutahakeni tsepakepauka, muwa muyepatsietsie 'ixuriki meuwɨtsie warita, tatsɨari Kakaɨyari ma'axetsie kakunitsie maka hɨxie, kapa 'umɨnikɨ kepauka haiwitɨritsie ne mana heimana nemunuanitsie. ");
INSERT INTO hch_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","»Matsi 'Aruni muyepatsieta kaneutahamɨkɨ tsikeru temaikɨ 'ahanatɨ 'itiya mawariyari mayani meta xeime muxa 'uki mawari taiyariyari mayanikɨ. ");
INSERT INTO hch_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Rinu kamixayari mɨ'itiya panakatɨni meta tetɨata mieme. Rinu kamixayaritsie heimana panayuhɨani kuxirakɨ meta rinu mukuretsiyari panakeni. 'Ikɨ kemari mɨpatsie kanihɨkɨtɨni, 'arike ti'ɨwame katinanakatɨmɨkɨ. ");
INSERT INTO hch_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","»'Ixaheritsixi wakiekaritsie, 'Aruni tsipuri 'ukitsi yuhutame pɨwarayehapani mɨxɨnarieni mawariyari memakɨnekɨ, meta xeime muxa 'uki mawari taiyariyari mayanikɨ. ");
INSERT INTO hch_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","'Arikekeri 'Aruni 'ixatɨame tsikeru 'itiya mawariyari yuhetsiemieme mɨxɨnarieni mawariyari mayanikɨ meta yuniwema wahetsiemieme, ");
INSERT INTO hch_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","yuhutame tsipuri 'ukitsi pɨwaranuhapani Yawé hɨxie pɨwa'atɨani, 'ixuriki tukiyari mɨranutahakitɨretsie. ");
INSERT INTO hch_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Hikɨ 'Aruni yuhutame tsipuri 'ukitsi wahetsie 'inɨari kanitawewimɨkɨ kemɨ'ane hetsie mɨtinakenikekai, xeime Yawé hetsiemieme mayanikɨ xeimeta yeuta makumawetsie mɨtatuanikɨ. ");
INSERT INTO hch_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Tsipu Yawé hetsie mɨtiunakixi 'Aruni pixatɨani 'itiya mawariyari mayanikɨ, ");
INSERT INTO hch_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","matsi Yawé hɨxie 'ayeniereme xeime kaniyetuamɨkɨ, mɨxɨnarieni mawariyari mayanikɨ, mɨkɨ tsipu 'uki mɨtatuani makumawetsie, Hatsatseri hetsɨa penunɨ'ani. ");
INSERT INTO hch_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","»'Aruni mana pixatɨani tsikeru temaikɨ 'itiya mawariyari yuhetsiemieme mayanikɨ, yapɨtiyurieni yuhetsiemieme mɨxɨnarieni mawariyari meta yuniwema wahetsiemieme. 'Anari tsikeru 'itiya mawariyari yuhetsiemieme kaniwaxitemɨkɨ, ");
INSERT INTO hch_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","hikɨ pɨtsiwiwame tɨɨ hɨneme kanitihanimɨkɨ mawari taiyametsie 'eyehaname Yawé hɨxie makatsie, huta tuiyari hɨpɨnetɨ 'ɨkwa witsimu'ɨa mɨmiyɨani yɨnɨkame, 'ixuriki meuwie warita paitɨ pɨranupini, ");
INSERT INTO hch_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","hɨkɨ mana Yawé hɨxie 'ɨkwa witsimu'ɨa taipa pauwiwieni, kɨtsiyari witsimu'ɨa Kakaɨyari ma'axetsie manukananikɨ kakuni hakewa tɨratu 'inɨariyari meyeka hetsie maka. Mɨpaɨ tikayame 'Aruni pɨkamɨni. ");
INSERT INTO hch_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Mɨpaɨta tiyurieme 'etsiwa tsikeru xuriyaya tihaname, 'etsatana tau manatineikatsie yu'itɨwamekɨ pi'ɨya Kakaɨyari ma'axe manukaname taɨta, hɨxienata 'atahutamexɨa pi'ɨya. ");
INSERT INTO hch_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","»Hikɨ 'anata kwitɨwa tsipu 'uki puwaxiteni 'itiya mawariyari mayani teɨteri memɨteheuyehɨwiyarienikɨ. Xuriyaya panɨ'ɨni 'ixuriki meuwie warita, mɨkɨkɨ yaxeikɨa pɨtiyurieni tsikeru xuriyayakɨ mɨtiuyuri hepaɨ, Kakaɨyari ma'axe pɨ'ɨya heimana meta hɨxienatsie. ");
INSERT INTO hch_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Mɨpaɨ pɨtiyurieni tuki mɨxɨnarienikɨ meta tita mɨkati'itiyakɨ 'ixaheritsixi teɨteriyari 'inɨari memutitsanaxɨakɨ, mɨpaɨ mepɨteheuyehɨwiyarieni tsepa titakɨ 'axamemɨte'uyuri. Yaxeikɨata katiniyurimɨkɨ 'ixuriki tukiyari hetsiemieme, wahixɨata muwe tita mɨkati'itiyakɨ wahetsiemieme. ");
INSERT INTO hch_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Xewitɨ 'ixuriki tukiyarita pɨka'ayekani kepauka 'Aruni meutahani mɨxɨnarieni mawariyari wewienike muwayepatsietsie kepauka mɨwayeyanike, mexixi mɨxɨnarieni mawariyari yuhetsiemieme wewiene meta yuniwema, yaxeikɨata yunaime 'Ixaheritsixi wahetsiemieme. ");
INSERT INTO hch_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","»'Aruni wayeyame kwitɨwa memɨxɨnarieni mawari puwewieni mawari taiyame Yawé hɨxie muwetsie. Tsikeru xuriyaya pɨti'ɨni meta tsipu 'uki xuriyaya, mawari taiyame xexuime 'awateya pɨtiwirieni, ");
INSERT INTO hch_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","yu'itɨwamekɨ mawari taiyame pɨtiwirieni 'atahutamexɨa xuriyakɨ. Mɨpaɨ mepatsietɨ mepakɨne me'itiyatɨ 'ixaheritsixi titakɨ memɨkate'itiyakai. ");
INSERT INTO hch_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","»Kepauka 'Aruni mɨtitahayewa memɨxɨnarieni mawariyari wewietɨ tukita muyepatsieta, 'ixuriki kiiyarita meta mawari taiyametsie, manata tsipu 'uki 'ayeniereme kaniyetuamɨkɨ, ");
INSERT INTO hch_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","hikɨ 'Aruni mu'uyatsie putimeni. 'Ixaheritsixi tita 'axamemɨte'uyurikɨ meta 'inɨari memutitsanaxɨakɨ pɨtitahekɨata, tsepa ketititakɨ 'axamɨtiuyurikɨ. Mɨkɨ tsipu naime pɨtititɨni, mepenunɨ'ani 'ɨtsita paitɨ makumawetsie tewi kemɨ'ane hetsiena mɨtiunakixɨ mɨpaɨ mɨtiyurienikɨ. ");
INSERT INTO hch_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Mɨkɨ tewi tsipu pɨtatuani makumawetsiepai, mɨkɨ naime 'axamɨti'ane pɨranutɨni teɨteri memɨkahakuteitsie paitɨ. ");
INSERT INTO hch_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","»Hikɨ 'Aruni 'Ixuriki tukiyarita heutahame, rinu kemariyari panutihɨna muyepatsietsie heutahanike menakatɨ, muwa piku'eirieni. ");
INSERT INTO hch_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Mɨkɨ muwa muyepatsietsie hakɨ kaniti'ɨwamɨkɨ meta tawari puyutikemaritɨani. 'Anaketa wayeyame pixatɨani mawari taiyariyari yuhetsiemieme meta teɨteri wahetsiemieme. Mɨxɨnarieni mawariyari mɨpaɨ katiniwewiemɨkɨ yuhetsiemieme meta teɨteri wahetsiemieme. ");
INSERT INTO hch_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Matsi 'itiya mawariyari wiyayari mawari taiyametsie pɨtitaiya. ");
INSERT INTO hch_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","»Kemɨ'ane mɨhɨritɨarie tsipu yeutapai makumawetsie metatuanikɨ, mɨkɨ yu'ixurikite puti'ekwa meta puti'ɨwa. Mɨpaɨ tiyuriemeke mematiteitsie kaninuamɨkɨ. ");
INSERT INTO hch_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","»Tsikeru temaikɨ 'itiya mawariyari mayeitɨarie meta tsipu 'uki 'itiya mawariyari mayeitɨarie, mɨkɨ xuriya me'ɨiya muyepatsietsie mɨxɨnarieni mawariyari mayanikɨ, mɨkɨ pɨwayetɨkieni teikwariepai, nawiyari waiyari kwitaya pɨtitaiyarieni. ");
INSERT INTO hch_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Kemɨ'ane mititaiya mɨkɨ yu'ixuriki pɨti'ekwa meta pɨti'ɨwa. Mɨpaɨ tiyurieme 'anake punuani mematiteitsie. ");
INSERT INTO hch_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","»'Ikɨ 'aitsika yuheyemekɨ 'aixɨa mɨ'ane xehetsiemieme payani yaxemɨtekahunikɨ, yunaime xehetsiemieme meta 'ateewa kiekatari: Tamamata tukaritsie 'atahutarieka metseritsie xepɨyuhakieni tixaɨtɨ 'uximayatsika xepɨkatehexeiyani. ");
INSERT INTO hch_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Mɨkɨ tukaritsie xemɨxɨnarieni mawariyari puyetuiyani xemɨ'itiyanikɨ, Yawé hɨxie xekani'itiyakuni naimekɨ ke'axaxemɨte'uyurikɨ. ");
INSERT INTO hch_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Xeme xehetsiemieme xeitukari pu'uxipiyatɨni 'ana xepɨyuhakieni. 'Ikɨ 'aitsika yuheyemekɨ 'aixɨa mɨ'ane kanihɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","»Mawari wewiwame kemɨ'ane manayexeiyarie meta yamɨtiuta'aitɨarie yupaapa 'utɨma mieme mayanikɨ mɨkɨ mɨxɨnarieni mawariyari puwewieni. Mɨkɨ rinu 'ixurikiyari mɨpatsie kananakatɨmɨkɨ, ");
INSERT INTO hch_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","mɨxɨnarieni mawariyari pɨwewieni Waɨkawa Muyepatsietsie mieme meta 'ixuriki Tukiyarita mieme meta mawari taiyame hetsiemieme. Yaxeikɨa meta pɨtiyurieni mawari wewiwamete wahetsiemieme meta kiekatari memɨyutixexeɨriwa wahetsiemieme memɨxɨnarienikɨ. ");
INSERT INTO hch_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","»'Ikɨ 'aitsika yuheyemekɨ 'aixɨa mɨ'ane kanihɨkɨtɨkamɨkɨ yatemɨtekahunikɨ: Xeiwiyari 'aye'axekaku xeimieme mɨxɨnarieni mawariyari xepukuwewiwani yunaitɨ 'ixaheritsixi wahetsiemieme naimekɨ yunaitɨ 'axamemɨteyuriekɨ». Mɨpaɨ katinaye'atɨarieni Yawé Muitsexi kemɨtiuta'aitɨakai. ");
INSERT INTO hch_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Yawé Muitsexi katiniuta'aitɨani, ");
INSERT INTO hch_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","'Aruni meta niwemama meta 'ixaheritsixi yunaime mɨpaɨ mɨtiwatahɨawekɨ: «'Ikɨ kanihɨkɨtɨni Yawé mɨtati'aitɨa: ");
INSERT INTO hch_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","»Kepauka xewitɨ 'ixaheri tewiyari wakaxi yatɨni muxa meta tsipu, mɨtimawa mematiteitsie yatɨni 'ateewa paitɨ. ");
INSERT INTO hch_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","Mɨkɨ hetsiena pɨrahɨiyani xuriya metayeurikɨ meta mɨkaheihakɨ 'ixuriki tukiyari mɨranutahakitɨretsie mumierienikɨ, muwa mixatɨanikɨ mawari Yawé hetsiemieme mayanikɨ tukieya hɨxie. 'Ayumieme mɨkɨ payeweiyarieni yuteɨterima watsata. ");
INSERT INTO hch_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","'Ikɨ 'aitsika kanihɨkɨtɨni 'ixaheritsixi Yawé memɨ'atɨiriwanikɨ mawari yeuta memɨtiwewiwa. Mawari wewiwame hetsɨa mepi'atɨwani 'ixuriki tukiyari mɨranutahakitɨretsie, Yawé memɨyetuirienikɨ 'aixɨa memɨteyuxeiyani mawariyari mayanikɨ. ");
INSERT INTO hch_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Mawari wewiwame xuriya pɨtayeurieni mawari taiyame Yawé tipiinieyatsie, 'ixuriki tukiyarita mɨranutahakitɨretsie, meta wiyayari kanititaiyamɨkɨ witsimu'ɨa Yawé minake mɨhɨkɨkɨ. ");
INSERT INTO hch_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Hatsuakuri mawari mepɨkawaxatɨani yukakaɨyarixi memɨwarexeiya, tsipuri 'ukitsi wahepaɨ me'aneneme memɨwarutiwewi. 'Ikɨ 'aitsika yuheyamekɨ 'aixɨa mɨ'ane kanihɨkɨtɨni mɨkɨ wahetsimieme meta watɨɨriyama. ");
INSERT INTO hch_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","»Kepauka xewitɨ 'Ixaheri tewiyari yatɨni 'ateewa kiekame xehamatɨa muka mawari taiyariyari mɨyetuani yatɨni mawari, ");
INSERT INTO hch_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","xɨka kaheihana 'ixuriki tukiyarita mɨranutahakitɨritsie Yawé mɨxatɨanikɨ, mɨkɨ payeweiyarieni yuteɨterima watsata. ");
INSERT INTO hch_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","»Kepauka xewitɨ 'ixaheritsixi yatɨni 'ateewa kiekame xehamatɨa muka xɨka naime tsepa tita mɨtixuriyaya tikwaka, ne nepɨyeha'ani hepaɨtsitana meta teɨterimama wahetsɨa nekaneyeweiyamɨkɨ. ");
INSERT INTO hch_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Yunaitɨ memɨte'ayeneniere xuriyakɨ mekanayeneniereni. Ne nekɨmana nepɨxeyetuirie mawari taiyametsie, xemɨxɨnarienikɨ yuxexuitɨ, mɨkɨ xuriyakɨ katiniyɨmɨkɨ xemɨxɨnarienikɨ. ");
INSERT INTO hch_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","'Ayumieme mɨpaɨ nepɨtixekɨhɨawe: Xewitɨ xeme xuriya pɨkakwa'ani, meta 'ateewa kiekame pɨka'itikwani xehetsɨa 'ukaitɨ. ");
INSERT INTO hch_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","»Xewitɨ 'ixaheritsixi yatɨni 'ateewa kiekame xehetsɨa 'ukaitɨ xɨka tixaɨtɨ remieni yeutanaka yatɨni weurai memitikwanikɨ memupitɨarie, mɨkɨ xuriyaya 'ayekuname kwiepa mɨtayeurieni penuteuku, ");
INSERT INTO hch_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","yunaitɨ memɨte'ayeneniere xuriyakɨ mekanayeneniereni. 'Ayumieme yanepɨtixekuhɨawe: Memɨtexɨawe waxuriya xepɨkakwa'ani, yunaitɨ memɨte'ayaneniere xuriyakɨ mekanayeneniereni, kemɨ'ane mitikwani mɨkɨ payeweiyarieni yuteɨterima watsata. ");
INSERT INTO hch_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","»Yunaitɨ 'ixaheritsixi yatɨni 'ateewa kiekame xɨka xewitɨ wai 'utikwani 'ɨrawe 'imieyu yanɨtsɨtɨni heititsanaxɨaku, mɨkɨ yu'ixuriki pɨti'ekwa meta hakɨ pɨti'ɨwa, ka'itiyatɨ puyuhayewa kepauka mɨkɨyɨretsieke 'anakeri 'itiyatɨ payani. ");
INSERT INTO hch_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Xɨkari yu'ixuriki ka'uti'ekwa meta xɨka ka'uti'ɨwa, mɨkɨ 'axamɨtiuyurikɨ tiuka'eniwatɨ payani». ");
INSERT INTO hch_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Yawé Muitsexi mɨpaɨ katiniuta'aitɨani, ");
INSERT INTO hch_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","'ixaheritsixi mɨpaɨ mɨtiwatahɨawekɨ: «Ne Yawé xekakaɨyari nekanihɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","'Ekipitutari yuyeiyari kememɨtehexeiyakai wahepaɨ xepɨkateyurieka, meripaitɨ xematitekaitsie, meta Kanani kiekatari wahepaɨ, ne hakewa hikɨ nemɨxehewitɨtsie. Wa'aitsika xepɨka'anukuweweiyani, ");
INSERT INTO hch_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","matsi ne'aitsikatsie yaxekateneyurikuni meta ne'inɨari niukiyaritsie yaxekatenekahukuni. Ne Yawé xekakaɨyari nekanihɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Ne'inɨari niukiyaritsie yaxeketenekahuni meta ne'aitsikatsie, kemɨ'ane memeye'atɨani mɨkɨ tukari mekanipitɨariekuni. Ne Yawé nekanihɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","»Nixewitɨ 'ahurawa yu'iwa hetsɨa pɨka'aye'axeni hamatɨana mɨkahunikɨ 'ikumayɨanike 'uka yatɨni 'uki. Netsɨ Yawé nekanihɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","»'Apaapa pepɨkatewiyatsitɨaka, 'amaama hamatɨa pepɨka'ukahupuni pe'ikumayɨanike. Mɨpaɨ pepɨkayɨaneni mɨkɨ kani'amaamatɨni. ");
INSERT INTO hch_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","»'Apaapa 'ɨyaya hamatɨa pepɨka'ukahupuni pe'ikumayɨanike, 'apaapa pepɨkatewiyatsitɨaka. ");
INSERT INTO hch_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","»'Ataru hamatɨa pepɨka'ukahupuni pe'ikumayɨanike, 'apaapa meta 'amaama memeyexei, 'axeikɨa xe'utinunuiwame yatsepa xaɨtsie metinuiwaxɨ. ");
INSERT INTO hch_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","»'Aniwe 'uki nu'aya 'uka hamatɨa pepɨka'ukahupuni pe'ikumayɨanike, meta 'aniwe 'uka nu'aya hamatɨa, 'ekɨ 'akɨmana pemɨ'ananaimaka hepaɨ kani'aneni. ");
INSERT INTO hch_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","»'Apaapa nu'aya yu'ɨyatsie meyexei hamatɨa pepɨka'ukahupuni pe'ikumayɨanike. Pepɨka'itewiyatsitɨaka mɨkɨ pɨ'a'iwa. ");
INSERT INTO hch_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","»'Apaapa taruya hamatɨa pepɨka'ukahupuni pe'ikumayɨanike, 'apaapa pepɨkatewiyatsitɨaka. ");
INSERT INTO hch_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","»'Amaama 'iwaya hamatɨa pepɨka'ukahupuni pe'ikumayɨanike, 'amaama pepɨkatewiyatsitɨaka. ");
INSERT INTO hch_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","»'Apaapa 'iwaya 'uki pepɨkatewiyatsitɨaka, 'ɨyaya hamatɨa pepɨka'ukahupuni pe'ikumayɨanike, karikɨ mɨkɨ kani'ateteitɨni. ");
INSERT INTO hch_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","»Yaxeikɨa 'amu'e hamatɨa pepɨka'ukahupuni pe'ikumayɨanike. 'Aniwe pepɨkatewiyatsitɨaka. ");
INSERT INTO hch_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","»'A'iwa 'ɨyaya hamatɨa pepɨka'ukahupuni pe'ikumayɨanike, 'akɨmana pekani'atewiyatsitɨakamɨkɨ. ");
INSERT INTO hch_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","»Yuhutame 'ukari wahamatɨa pepɨka'ukahupuni pemɨwakumayɨanikɨ maamaya meta niweya meta mama'ɨmama, tatsɨari niweya 'uki nu'aya, yatɨni nu'aya 'uka nu'aya. Mɨkɨ 'ahurawa mekani'iwamarixitɨni, 'ayumieme xɨka 'ikumayɨani waɨkawa 'axakatiniyurimɨkɨ. ");
INSERT INTO hch_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","»Pepɨka'itiwitɨkɨni 'akwe, meta hamatɨana pepɨka'ukahupuni pe'ikumayɨanike mexi 'akuxi 'a'ɨya 'ayeniere, kapa meyuyehekaxɨanikɨ. ");
INSERT INTO hch_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","»Xeime 'ukaratsi hamatɨa pepɨka'ukahupuni pe'ikumayɨanike, mexixi 'akuxi xuriya 'i'axiya. ");
INSERT INTO hch_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","»'Ahepaɨ tewi 'ɨyaya hamatɨa pepɨka'ukahupuni pe'ikumayɨanike, kapa mɨkɨkɨ peka'itiyatɨ pe'uyuhayewakɨ. ");
INSERT INTO hch_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","»Kemɨtitewakɨ 'akakaɨyari kapatsiekame pepɨka'ayeitɨaka, 'aniwe peyetuatɨ Muruki kakaɨyariyari hetsɨa, mawari mɨtataiyarieni mayanikɨ. Ne Yawé nekanihɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","»'Uki hamatɨa pepɨka'ukahupuni 'uka hamatɨa pemukahupuni hepaɨ. Mɨkɨri mɨxani'eriwa kanihɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","»Tewatsiekate memɨtexɨawe pepɨkawakumaɨwani. Mɨkɨkɨ peka'itiyatɨ pepɨkahayuyeitɨaka. »Meta yaxeikɨa tewatsiekame 'uka pɨkakumaɨwani. Mɨpaɨri yɨanetɨ 'axapɨ'itɨarieka. ");
INSERT INTO hch_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","»Mɨpaɨ xeteyurietɨ xeka'itiyatɨ xepɨkahayuyeitɨaka, mɨpaɨ mete'uyurieku nuiwarite hikɨ nekaniwarayeweiyamɨkɨ xeme nemɨxenaki'eriekɨ, ");
INSERT INTO hch_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","mɨkɨkɨ kwie yukɨmana 'axapuyuyuri. 'Ayumieme nepuwaru'uximatɨa 'axamemɨte'uyurikɨ, mɨkɨ kwie yuteɨterima kaniwaruhayani. ");
INSERT INTO hch_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Xeme yaxeketenekahuni ne'inɨari niukiyaritsie meta kenemɨti'aita. Tsepa xeme meta 'ateewa kiekatari xehamatɨa memɨtitei mɨkɨ mɨxani'eriwakɨ mɨpaɨ xepɨkateyurieka, ");
INSERT INTO hch_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","matsi mɨkɨ mɨyamɨti'ane yamekateniyuriekaitɨni 'ikɨ kwieyaritsie memɨtitekai xeme 'ena 'akuxi xeka'axɨawawekaku, kwie 'axa'anetɨ kanayani. ");
INSERT INTO hch_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Xɨkata xeme kwie ka'itiyakame xe'ayeitɨani, mɨkɨta pɨxehayani nuiwarite kemɨtiwaruhaya hepaɨ hetsiena memukutekai xeme 'akuxi 'ena xeka'axɨawawekaku. ");
INSERT INTO hch_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","»Kemɨ'ane 'ikɨ mɨtixani'eriwakɨ yamɨtiyurieni mɨkɨ kanayeweiyariemɨkɨ yuteɨterima watsata. ");
INSERT INTO hch_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Xeme yaxeketenekahuni kenemɨti'aita, xeketenehayewani tita mɨtixani'eriwakɨ yeiyari kememɨteyuriekai 'ena kwiepa xeme 'akuxi xeka'axɨawawekaku. Xeka'itiyatɨ xepɨkahayuyeitɨaka mɨkɨkɨ. Netsɨ Yawé xekakaɨyari nekanihɨkɨtɨni». ");
INSERT INTO hch_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Yawé Muitsexi katiniuta'aitɨani, ");
INSERT INTO hch_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","'ixaheritsixi memuyutixexeɨriwa mɨtiwataxatɨanikɨ 'ipaɨ mɨtiwatahɨawekɨ: «Xekenepatsieka, ne Yawé xekakaɨyari nemɨpatsiekɨ. ");
INSERT INTO hch_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","»Xeme yunaitɨ yumaamama meta yupaapama xeketeniwareuyehɨwirieka. 'Uxipiya tukari xekena'eriwani ne Yawé xekakaɨyari nekanihɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","»Kakaɨyarixi tixaɨtɨ memɨkatehɨkɨ wahetsɨa xepɨkahekɨkani, kakaɨyarixi tepɨakɨ memuwewiyatɨka xepɨkawawewieka. Ne Yawé xekakaɨyari nekanihɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","»Kepauka Yawé mawari 'aixɨa memɨteyuxeiyanikɨ mawariyari xemɨteyetuirieni, kemɨreuyewetsekɨ xeketeneuyuri mɨkɨ Yawé 'aixɨa 'anemekɨ mitanaki'erienikɨ. ");
INSERT INTO hch_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Xekeneutikwa'i kepauka xemiwewienitsie yatɨnita 'uxa'arieka. Hairieka tukaritsie mieme muyuhayewa xekanitataiyakuni. ");
INSERT INTO hch_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Xɨka xewitɨ hairieka tukaritsie 'itikwani, mɨkɨ mawari pɨkatanaki'eriwa, mɨxani'eriwa pɨhɨkɨtɨniri. ");
INSERT INTO hch_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Xɨka xewitɨ hairieka tukaritsie 'itikwani, katinika'eniexɨamɨkɨ 'axamɨtiuyurikɨ tita mɨtipatsie Yawé hetsiemieme kapatsiekame mayeitɨakɨ. Mɨkɨ yuteɨterima watsata payeweiyarieni. ");
INSERT INTO hch_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","»Kepauka 'itsanaxa maye'anitsie, naime xepɨkaka'itsanani yuwatsiyata timieme meta mɨayeyari naime xepɨkakapineni mana xekeneuhayewa. ");
INSERT INTO hch_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","»Tawari 'akuxi kaxie xatsimuyaritsie 'imatɨrieka mieme xepɨkawautɨweni takari meta mɨkaxɨrɨwe pepɨkakuteɨxɨni. Tixaɨtɨ memɨkatehexeiya keniwaruhayewi meta 'ateewa kiekatari. Ne Yawé xekakaɨyari nekanihɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","»Pepɨkatinawayani. »Xepɨkateyu'itaiyani. »'Ahepaɨ tewi pepɨkati'irɨwiyani. ");
INSERT INTO hch_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","»Yakɨ xeikɨa pepɨka'ahɨritɨaka kenemɨtitewakɨ, meta kenemɨtitewakɨ 'akakaɨyari kapatsiekame pepɨka'ayeitɨaka. Ne Yawé nekanihɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","»'Ahepaɨ tewi pepɨkananaimaka, meta waɨriyarika pepɨkatikunawairiwani tita mɨrexeiya. »Ti'uximayatame tuminieya pe'a'ɨtɨ 'uxa'ariekake pepɨka'iku'ɨitɨwani. ");
INSERT INTO hch_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","»Mɨkaheu'ena 'axapepɨkatikuhɨaweni, mɨkaheuniere hɨxie pepɨkatiuyetsani pemeikahɨanikɨ, matsi 'akakaɨyari kenayemakaka. Ne Yawé nekanihɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","»'Ekɨ heitseriemekɨ yaketinekuxatani, xeime xeikɨa pepɨkaparewimɨkɨni tixaɨtɨ memɨkatehexeiya meta xikutsixi wahetsie, matsi kemɨtiheitseriekɨ ketineyurieneni yunaime wahetsie. ");
INSERT INTO hch_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","»'Ateɨterima watsata 'axaniuki pepɨkawewieka, meta 'ahepaɨ tewi pe'itatɨ pepɨkahekɨatani. Ne Yawé nekanihɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","»'A'iwa 'a'iyaritsie pepɨka'uxiwe'erieka, matsi 'ahepaɨ tewi keneutati'a hahekɨakamekɨ kapa petiuka'eniexɨanikɨ mɨkɨ ke'axamɨtiuyurikɨ. ");
INSERT INTO hch_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","»'Ahepaɨ tewi pepɨkatikɨhɨwiriwani kemumatsi'uyurikɨ, meta haxɨa pepɨka'utani hetsiena mieme. 'Ahepaɨ tewi kenenaki'erieka 'ekɨ kepemɨti'anaki'erie hepaɨ. Ne Yawé nekanihɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","»Yaxeketenekahuni ne'aitsikatsie: »Tewaxi hipame yɨkɨ memɨ'anene wahamatɨa xepɨkawaweiyatsitɨatɨweni. »Yuwatsiyata huta 'imɨariyari yɨkɨ'anenekamekɨ xepɨka'etɨweni. »'Ixuriki hiru hutame yɨkɨ 'anenemekɨ wewiyakame xepɨka'anakatɨkɨni. ");
INSERT INTO hch_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","»Xɨka xewitɨ 'uki, 'uka waɨriyarika ti'uximayatame hamatɨa 'ukahuni xeime hamatɨa memuyutiwitɨnikekaikɨ yametekuxatakaku, matsi xɨka 'akuxi kareyukatuiyawekaitɨni kaxɨnariewekaitɨni, mɨkɨ yuhutatɨ yamepɨtepitɨarieni kemɨreuyewetse xeikɨa memɨteka'eniexɨanikɨ, matsi mepɨkakwi'iwa mɨkɨ 'uka mɨkatatuiyawekaikɨ 'akuxi. ");
INSERT INTO hch_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Mɨkɨ 'uki kaneuyeweka Yawé muxa 'uki mawariyari mɨyetuirienikɨ hetsiena mɨrahɨiyakɨ. 'Ixuriki tukiyarita mɨranutahakitɨretsie kanenuhanimɨkɨ, ");
INSERT INTO hch_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","muwa mawari wewiwame 'itiya mawariyari kaniwewimɨkɨ Yawé hɨxie 'axamɨti'ane hepaɨtsita, Mɨpaɨ mɨkɨ ke'axamɨtiuyurikɨ pɨreuyehɨwiyarieni. ");
INSERT INTO hch_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","»Kepauka xeme mɨkɨ kwieyaritsie xemɨ'axɨani xɨka kɨyexi 'ikwaxi mɨkwaiwa mukaxuawitɨwa xete'uka'iteɨrita, haika wiyari 'ikwaxiyari xepɨkatikwani matsi ka'itiyakame xekanayeitɨakakuni. ");
INSERT INTO hch_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Nauka wiyaritsieke naitɨ 'ikwaxi Yawé pɨxatɨarieni mawari mayanikɨ Yawé pamɨpariyutsi me'ipitɨatɨ, ");
INSERT INTO hch_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","'auxɨwirieka wiyarike 'ikwaxiyari xemɨtikwanikɨ xepɨyɨwaweni. Mɨpaɨ xeteyurieyu waɨkawa pɨtiukaxuxuawereni. Ne Yawé xekakaɨyari nekanihɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","»Tixaɨtɨ rayexureme xepɨkatekwaka. »Kakaɨyarixi memɨwaruta'iwawiya kemɨtiyɨnikɨ mɨpaɨ xepɨkateyurieka meta xemɨteyukewaiyanikɨ. ");
INSERT INTO hch_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","»'Akɨpa pepɨkahaxitɨyeikani xikɨraɨye manuyemarekɨ meta 'amɨxiya 'a'ayekwaitsiemieme kɨtsiena pepɨkahanuyexikani. ");
INSERT INTO hch_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","»'Awaiyaritsie pepɨka'atixitekeni mɨkite wahetsiemiemekɨ, meta pepɨkareu'utɨarieka 'anawiyaritsie. Ne Yawé nekanihɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","»Yuniwema waɨriyarika xepɨkawapitɨaka tuminikɨ memukumayɨiwanikɨ, kapa yunaitɨ teɨteri hipame kakaɨyarixi mewarayexeiyatɨ me'akɨnekɨ meta kwiepa 'axamɨti'anekɨ 'akunɨni. ");
INSERT INTO hch_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","»'Uxipiya tukari xekena'eriwani, netuki xekenayexeiyani. Ne Yawé nekanihɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","»Mɨkite wahamatɨa memɨtekuxata wahetsɨa xepɨkakɨnetɨweni, hipame 'iyarite memuwakɨhɨawe xepɨkawakuwautɨweni matsi xeka'itiyatɨ xepakɨne mɨkɨ wahekɨ. Ne Yawé xekakaɨyari nekanihɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","»'Amɨyumate pexeiyame keneutakexi. »'Ukirawetsixi 'aixɨa ketinewaxeiyani. »'Akakaɨyari kenayemakaxeni. Ne Yawé nekanihɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","»Xɨka xewitɨ 'ateewa kiekame kiekaritsie xematiteitsie nuame mana hetayerɨni, xepɨkahei'uximatɨaka. ");
INSERT INTO hch_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Matsi 'aixɨa xeketenexeiyani xewitɨ xehetsɨa mɨmiemetɨni hepaɨ. Xekenenaki'erika xeme kexemɨteyunaki'erie, mɨpaɨ xetemaitɨ xemeta kɨkamete 'Ekipitutsie xemɨhɨkɨtɨkaikɨ. Ne Yawé 'ixaheritsixi wakakaɨyari nekanihɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","»Ti'inɨnɨatame tiyukwamanamekɨ pepɨkati'inɨatani, kemautatewakɨ, meta kemɨrahete meta kepaɨmetɨ mɨrakanakekɨ. ");
INSERT INTO hch_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Mɨranuyewɨwɨtɨwa kenexeiyani kemɨrahete 'aixɨa reku'inɨaritɨkaime. Ne Yawé xekakaɨyari nekanihɨkɨtɨni, 'Ekipitu nemɨxe'ayewitɨ. ");
INSERT INTO hch_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","»Matsi naime ne'aitsikatsie yaxeketenekahuni. Yaxeketeneyurieka naime tita nemɨti'aita. Ne Yawé nekanihɨkɨtɨni». ");
INSERT INTO hch_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Yawé Muitsexi mɨpaɨ katiniuta'aitɨani ");
INSERT INTO hch_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","'ixaheritsixi mɨpaɨ mɨtiwatahɨawekɨ: «Yunaitɨ 'ixaheritsixi meta 'ateewa kiekatari 'Ixaheri kwieyaritsie memɨtiteni xɨka xewitɨ yuniwe mɨtataiyarienikɨ yetuani, Muruki kakaɨyariyari mawarieya mayanikɨ. Mɨkɨ kanimieriemɨkɨ. Kiekatari memɨyutixexeɨriwa mepimieni tetexikɨ me'itituaxatɨ. ");
INSERT INTO hch_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Ne mɨkɨ hepaɨtsita nepɨyeha'ani meta teɨterimama watsata nepeyeweiya, xeime yuniwe mɨyetuakɨ mɨtataiyarienikɨ Muruki kakaɨyariyari mawarieya mayanikɨ, ka'itiyakame mayeitɨakɨ netuki muyepatsieta meta kenemɨtitewakɨ nekapatsiekame mɨnetsi 'ayeitɨakɨ. ");
INSERT INTO hch_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","»Xɨka kiekatari memuyutixexeɨriwa 'atsimekate'uyurieni mɨkɨ tewi hepaɨtsita yuniwe xeime mɨyetuakɨ Muruki hetsɨa, meta xɨka meka'imieni, ");
INSERT INTO hch_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","ne mɨkɨ nepaye'unieka meta tɨɨriyamama, meta nepeyeweiya teɨterimama watsata meta yunaime teɨteri Muruki hamatɨana memukahini hepaɨ memɨyɨ me'eyexeiyatɨ. ");
INSERT INTO hch_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","»Yaxeikɨata tsiere nepɨwaraye'unieka kemɨ'ane mɨkite wahamatɨa memɨtekuxata meta hipame 'iyarite memɨwakɨhɨawe wahetsɨa memɨkɨnetɨwe wahepaɨtsita meta mewaranukuweiyame 'iyarite wahamatɨa memukahini hepaɨ mekaniyɨakakuni. Teɨterimama watsata nekaniwarayeweiyamɨkɨ. ");
INSERT INTO hch_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","»Nehetsɨa xekeyeyu'itieka, meta xekenepatsieka, netsɨ Yawé xekakaɨyari nekanihɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","»Yaxeketenekahuni ne'aitsikatsie xekenaye'atɨaka. Ne Yawé, nemɨxepata nekanihɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","»Xɨka xewitɨ yupaapa 'axatiutahɨawe meta yumaama, mɨkɨ ke'umierieni: yupaapa yumaama hepaɨtsita 'axamutayɨkɨ, mɨkɨ mɨmierienikɨ hetsiena pɨtinakeni. ");
INSERT INTO hch_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","»Xɨka xewitɨ yuhepaɨ tewi 'ɨyaya 'ukumayɨani, mɨkɨri yuhutatɨ mekanikwi'iwakuni 'uki meta 'uka. ");
INSERT INTO hch_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","»Xɨka xewitɨ yupaapa 'ɨyaya hamatɨa 'ukahuni, yupaapa kanitewiyatsitɨaka. 'Uki meta 'uka mepɨkwi'iwa, mɨyamemɨte'uyurikɨ wahetsie pɨtinakeni memɨkwi'iwakɨ. ");
INSERT INTO hch_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","»Xɨka xewitɨ yumu'e hamatɨa 'ukahuni, 'uki meta 'uka mekanikwi'iwakuni. Waɨkawamekɨ 'axamemɨte'uyurikɨ, mɨyamemɨte'uyurikɨ wahetsie pɨtinakeni memukwi'iwakɨ. ");
INSERT INTO hch_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","»Xɨka xewitɨ 'uki hamatɨa 'ukahuni, 'uka hamatɨa mukahuni hepaɨ, mɨkɨri mɨxani'eriwakɨ memɨte'uyuri yuhutatɨ mekanikwi'iwakuni, wahetsie pɨtinakeni memɨkwi'iwakɨ. ");
INSERT INTO hch_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","»Xɨka xewitɨ maamaya meta niweya mame warukumayɨani, mɨkɨri waɨkawa 'axamepɨte'uyuri. Mɨkɨ yuhaikatɨ mekanititaiyariekuni, tawarita xetsata 'ikɨ 'axamɨti'ane mɨkatixuawenikɨ. ");
INSERT INTO hch_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","»Xɨka xewitɨ 'ukitɨtɨ titewatsiekame 'ukumayɨani, mɨkɨ ke'umierieni meta yaxeikɨa tewatsiekame kanimieriemɨkɨ. ");
INSERT INTO hch_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","»Xɨka xewitɨ 'ukatɨtɨ tewatsiekame 'ikumayɨani, mɨkɨ yuhutatɨ mepɨkwi'iwa wahetsie pɨtinakeni memɨkwi'iwakɨ. ");
INSERT INTO hch_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","»Xɨka xewitɨ 'ahurawa yu'iwa 'ukumayɨani, mɨkɨri tewiyɨkɨmekɨ katiniyurimɨkɨ yuhutatɨ mɨirikɨa mekananuhapaniekuni. Yu'iwa kaniutewiyatsitɨani, mɨyamutiuyurikɨ katinika'eniexɨamɨkɨ ke'axamɨtiuyurikɨ. ");
INSERT INTO hch_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","»Xɨka xewitɨ xeime 'uka xuriya 'i'axiyakaku hamatɨa 'ukahuni 'ikumayɨani, mɨkɨ mɨtiuhanitsitɨa matsiɨkɨme kanayeitɨani, yaxeikɨata mɨkɨ 'uka kaniyuhekɨata yuxuriya muhanitsitɨakɨ. Mɨkɨ yuhutatɨ yuteɨterima watsata mepayeweiyarieni. ");
INSERT INTO hch_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","»'Atetei 'apaapa meta 'amaama 'iwaya hamatɨa pepɨka'ukahupuni, mɨkɨri 'ahurawa 'a'iwa pekanitewiyatsitɨaka, mɨkɨ yuhutatɨ mekatenika'eniexɨakuni ke'axamemɨte'uyurikɨ. ");
INSERT INTO hch_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","»Xɨka xewitɨ yutetei hamatɨa 'ukahuni, yutatatsi kanitewiyatsitɨaka, mɨkɨ yuhutatɨ mekatenika'eniexɨakuni ke'axamemɨte'uyurikɨ: nuiwari mekawaraxeiyame mekanikwikuni. ");
INSERT INTO hch_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","»Xɨka xewitɨ yumatsika 'ɨyaya waɨriyarika 'ipitɨatɨ 'ikumayɨani, mɨkɨri ka'itiyakame pɨrayeitɨa yumatsika hepaɨtsita: yu'iwa kaniutewiyatsitɨani mɨkɨri yuhutatɨ yunuiwarima mewarexeiyatɨ mepɨka'akɨne. ");
INSERT INTO hch_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","»Naime ne'aitsikate xekenaye'atɨaka meta ne'inɨari niukiyarite. Yaxeketenekahuni, kapa kwie nemɨxeyetuirieni mana xemetitenikɨ xe'uhayanikɨ. ");
INSERT INTO hch_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Mɨkɨ nuiwarite kememɨteyurie xewa'ɨketɨ xepɨka'u'uwani xeme nexenaki'erietɨ nemuwarayeweiya. Mɨkɨ naime mɨpaɨ mekateniuyurieni, ne mɨkɨ nekaniwarutixani'erieni. ");
INSERT INTO hch_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Matsi xeme nekatinixekɨhɨaweni: “Ne mɨkɨ kwie nuiwarite mematitekaitsie nepɨxeyetuirieni, kwie retsi meta xiete waɨkawa maxɨawetsie. Ne nekɨmana nepɨxeyetuirieni xehetsie mɨtinakenikɨ”. »Ne Yawé xekakaɨyari nekanihɨkɨtɨni, hipame nuiwaritetsie wahetsɨa yɨkɨ xe'aneneme nemɨxe'ayeitɨakɨ. ");
INSERT INTO hch_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","'Ayumieme, xemeta yukɨ me'aneneme xekeniwarayeitɨaka yeutari memɨtexɨawe memɨ'itiyatɨka meta memɨka'itiyatɨka, meta memɨte'awɨwawe watsata memɨ'itiyatɨka meta memɨka'itiyatɨka. Xemɨxani'eriwa xepɨka'ayuyeitɨaka mɨkɨ memɨtexuawe yeutari wahekɨ, memɨte'awɨwawe meta tsepa ketita yutawima mɨtikuyeikakɨ, ne memɨka'itiyakɨ mɨkɨ nepɨxe'u'inɨaritɨa. ");
INSERT INTO hch_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Xeme xekenepatsieka, ne Yawé nemɨpatsiekɨ, ne yukɨpɨta xe'aneneme nekaxenayeitɨani hipame nuiwarite watsata, nehetsɨa miemete xemɨhɨkɨtɨnikɨ. ");
INSERT INTO hch_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","»Xɨka xewitɨ 'uki yatɨni 'uka mɨkite wahamatɨa tikuxatani meta hipame 'iyarite muwakɨhɨawe, mɨkɨ kanimieriemɨkɨ. Tetexikɨ tituaxiexɨame kanimɨmɨkɨ, hetsiena mɨtinakekaikɨ mumierienikɨ». ");
INSERT INTO hch_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Yawé Muitsexi katiniuta'aitɨani mawari wewiwamete mɨpaɨ mɨtiwatahɨawekɨ, 'Aruni niwemama: «Xeka'itiyatɨ xepɨkahayuyeitɨaka mɨkite yukiekaritsie xewakumaɨwatɨ, ");
INSERT INTO hch_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","matsi mɨkɨ xeikɨa mepɨyɨwaweni 'iwaya 'aurawatanaka, maamaya, paapaya, nu'aya 'uki, niweya 'uka, xɨka xewitɨ 'umɨni 'ahurawa 'iwaya ");
INSERT INTO hch_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","yatɨni 'iwaya 'uka kawikietɨ hetsɨana muka. ");
INSERT INTO hch_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Mɨkɨ memanuyetei memɨhɨkɨkɨ yukiekaritsie, meka'itiyatɨ mepɨkahayuyeitɨaka meta mepɨkayutsewiximaka. ");
INSERT INTO hch_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","»Mawari wewiwamete yumu'utsie mepɨkayukaxikani, yumɨxiya kɨtsie yu'ayekwaitsie mieme mepɨkahataxikani meta yuwaiyaritsie mepɨkayutixitekeni. ");
INSERT INTO hch_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Kaneuyeweka memɨpatsiekakɨ yukakaɨyari hetsiemieme, meta mɨkɨ kemɨtitewa kapatsiekame mepɨkahayeitɨwani. Mɨkɨ mekanihɨkɨtɨni 'imikieri taipa warɨkariekame Yawé memɨteyetuiriwa, paa yukakaɨyari hetsiemieme hepaɨ mekani'aneneni. 'Ayumieme mekanipatsiekakuni. ");
INSERT INTO hch_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","»Xewitɨ tɨma mawari wewiwame xeime tuminikɨ mukumayɨiwa pɨkatiwitɨkɨni, yatɨni 'eiriwakame, meta xeime 'uka mayɨiyakame, yukakaɨyari hetsiemieme mɨpatsiekɨ. ");
INSERT INTO hch_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Patsiekame kenayeitɨaka, mɨkɨ 'akakaɨyari paa mɨyetuiriwakɨ. 'Ahetsiemieme kanipatsiekamɨkɨ, ne Yawé nemɨpatsiekɨ, xeme xepatsiekame nepɨxe'ayeitɨa. ");
INSERT INTO hch_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","»Mawari wewiwame niweyatɨtɨ tuminikɨ mukumayɨiwa xɨka 'ayuyeitɨani mɨkɨ yɨkɨmana kapatsietɨ payuyeitɨani yaxeikɨatatsiere yupaapa kapatsiekame kanayeitɨamɨkɨ. Kaneuyeweka 'ayenieretɨ mɨtataiyarienikɨ. ");
INSERT INTO hch_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","»Kemɨ'ane manayexeiyarieni yu'iwama watsata mawari wewiwamete tiwa'aitɨwame mayanikɨ, mu'uyatsie hatseiti mɨtiyupata mukawiriyarie, meta kemɨ'ane mawari wewiwamete wakemari manakatɨnikɨ mɨyetuiriyarie, 'aixɨa reyutsiketɨ puyeikani meta yukamixa pɨkaheukatsanani. ");
INSERT INTO hch_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","»Kaxari muyekatsie tɨma pɨkaheutahakeni. »Ka'itiyatɨ pɨkahayuyeitɨaka, yupaapakɨ meta yumaamakɨ. ");
INSERT INTO hch_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","»Tukita pɨkawayeyeikani kapa kapatsiekame yukakaɨyari tukieya 'ayeitɨanikɨ, mɨkɨ mɨpatsienikɨ hatseiti mɨtiyupata 'ukawiriyarieka manayexeiyariekɨ yukakaɨyaritsie mieme. Ne Yawé nekanihɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","»'Uka mɨtiwitɨni 'ɨyaya mayanikɨ pɨkamayɨiyaka. ");
INSERT INTO hch_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Meta wiura pɨkatiwitɨkɨni metatsiere 'eiriwakame, yaxeikɨata tuminikɨ mukumayɨiwa. Matsi memakuteitsie kiekame mɨkamayɨiya kanitiwitɨmɨkɨ, ");
INSERT INTO hch_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","kapa mekapatsiekame yunuiwari warayeitɨanikɨ yuteɨterima watsata. Ne Yawé nekanihɨkɨtɨni nemɨxepata». ");
INSERT INTO hch_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Yawé Muitsexi mɨpaɨ katiniuta'aitɨani ");
INSERT INTO hch_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","'Aruni mɨpaɨ mɨtitahɨawekɨ: «Xewitɨ 'anuiwaritsiemiemete xɨka yuwaiyaritsie 'aixɨa ka'aneni mɨkɨ pɨkayɨweni 'ahurawa muyanikɨ yukakaɨyari hetsɨa paa mawariyari mɨyetuanikɨ. ");
INSERT INTO hch_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Tikuyetɨ yuwaiyaritsie pɨkayɨweni 'ahurawa muyanikɨ mɨpaɨ 'anetɨ: kaheunieretɨ, 'uti'ɨtsaiwatɨ, yɨhɨxie kanɨrietɨ, meta waiyarieyatsie reuyewetɨkaikaku, ");
INSERT INTO hch_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","'ɨkateya meta mamateya 'akamumurikaku, ");
INSERT INTO hch_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","'anatutsitɨ meta 'etsi'utewitɨ, meta heunerɨitsietɨ yatɨni haiya xetatɨ mukumarike hexeiyatɨ, hɨxitana tiukuturekaku, yatɨni 'ataripiyatɨ. ");
INSERT INTO hch_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Mawari wewiwame 'Aruni nuiwarieya xɨka xewitɨ mɨkɨ kwiniya mɨpaɨ 'aneme hexeiyani pɨkayɨweni 'ahurawa muyanikɨ Yawé 'imikieri taipa warɨkariekame mɨwewirienikɨ. Meta pɨkayɨweni paa mawariyari yukakaɨyari mɨyetuirienikɨ. ");
INSERT INTO hch_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Kaniyuwemɨkɨ xeikɨa paa mawariyari meta 'ikwai mɨpatsie meta waɨkawa mɨpatsietɨka mɨtikwanikɨ, ");
INSERT INTO hch_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","mɨkɨ kwiniya mexeiyakɨ 'ixuriki meuwieta paitɨ pɨkaheutahani meta mawari taiyametsie 'ahurawa pɨka'uyani, kapa netuki kapatsiekame 'ayeitɨakakɨ. Ne Yawé nekanihɨkɨtɨni mawari wewiwamete nemɨwapata». ");
INSERT INTO hch_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Muitsexi 'ikɨ naime 'Aruni meta niwemama yaxeikɨata yunaime 'ixaheritsixi katiniwarutaxatɨani. ");
INSERT INTO hch_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Yawé Muitsexi mɨpaɨ katiniuta'aitɨani ");
INSERT INTO hch_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","'Aruni meta niwemama mɨpaɨ mɨtiwatahɨawekɨ: «'Aixɨa 'anemekɨ meketeyurieka waɨkawamekɨ me'eyexeiyatɨ 'ixaheritsixi mawari mɨpatsie memɨnetsiwewirie, kapa kenemɨtitewakɨ nekapatsiekame menetsi'ayeitɨanikɨ. Ne Yawé nekanihɨkɨtɨni». ");
INSERT INTO hch_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Yaxeikɨata mɨpaɨ katinita'aitɨani mɨpaɨ mɨtiwatahɨawekɨ: «Xɨka xewitɨ 'Aruni nuiwarieya ka'itiyatɨ mawari 'aurie 'ahurawa 'uyani 'ixaheritsixi Yawé memɨyetuiriwatsie, mɨkɨ nehɨxie payeweiyarieni. Ne Yawé nekanihɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","»Xɨka xewitɨ 'Aruni nuiwarieya tixaɨtɨ mɨtiyuwiriwekɨ yuwaiyaritsie tikuyeni, yatɨni tiuhanitsitɨaka mɨkɨ pɨtihayewa mawarite mɨtipatsietɨka tikwatɨ, kepauka muyu'itienitsieke. Xɨka xewitɨ tixaɨtɨ kati'itiyatɨ timɨkitɨ hetsiena reutawereyu tixaɨtɨ tiumayɨani yatɨni tiuhanitsitɨakame, ");
INSERT INTO hch_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","yatɨni yeuta memɨtexuawe, yatɨni tewi ka'itikayame, tsepa titakɨ memɨkate'itiyatɨka, ");
INSERT INTO hch_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","mɨkɨ ka'itiyatɨ kaniyuhayewamɨkɨ kepauka mɨkɨyɨretsieke. 'Ayumieme, mawari mɨpatsie pɨkatikwani. Hakɨ kaniti'ɨwamɨkɨ, ");
INSERT INTO hch_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","tau makayunetsieke 'itiyatɨ puyuhayewa. 'Anakeri kaniyɨwemɨkɨ mawari mɨpatsie mɨtikwanikɨ, mɨkɨ mɨ'ikwaiyakɨ. ");
INSERT INTO hch_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Tixaɨtɨ timɨkitɨ titaxeiyarieyu pɨkatikwaka yatɨni tiyukwa'ame 'itexierieya, kapa ka'itiyatɨ 'ayanikɨ. Ne Yawé nekanihɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","»Mawari wewiwamete yameketekahuni ne'aitsikatsie, mɨpaɨ 'axamepukateyurieni meta mepɨkakwini kapatsiekame nemawari me'ayeitɨame. Ne Yawé nekanihɨkɨtɨni, mawari wewiwamete nemɨwapata. ");
INSERT INTO hch_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","»Xewitɨtɨma mawari wewiwamete watɨɨriyama wahetsie kamiemetɨtɨ mawari mɨpatsie mɨtikwani pɨkayɨweni, meta xewitɨ mawari wewiwame kiita 'ayekaitɨ, metatsiere ti'uximayatsiriwame. ");
INSERT INTO hch_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Matsi xeikɨa waɨriyarika ti'uximayatame mawari wewiwame minanai pɨyɨweni mitikwanikɨ, metatsiere waɨriyarika ti'uximayatame kiena mutinuiwaxɨ. ");
INSERT INTO hch_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Xɨka mawari wewiwame niweya 'uka xeime mawari wewiwame kahɨkɨtɨme 'utiwitɨni, pɨkayɨweni mawari memɨyetuiriyarɨwa 'imikieri 'aixɨa mɨ'anene mɨtikwanikɨ. ");
INSERT INTO hch_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Matsi xɨka kɨnaya 'umɨni yatɨni 'uku'eiriwa nunutsi meka'ayexeiyawawetɨ, mɨkɨ punuani yupaapa hetsɨa yaxeikɨa muyuxewini hepaɨ, 'ana pɨyɨweni paapaya tita mɨtikwa'a mitikwanikɨ. Matsi kemɨ'ane mɨkanuiwarieya pɨkapitɨarie mitikwanikɨ. ");
INSERT INTO hch_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","»Xɨka xewitɨ 'atsikatimaitɨ mawari mɨpatsie 'utikwani, mɨkɨta mawari pɨyetuani 'auxɨwimeyaritsie mieme tawari xei'inɨariyari kaniyetuamɨkɨ. ");
INSERT INTO hch_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","»Mawari wewiwamete mawari mɨpatsie kapatsiekame mepɨka'ayeitɨaka 'ixaheritsixi Yawé memɨyetuiriwa, ");
INSERT INTO hch_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","'ayumieme xɨka memitikwanikɨ hipame mewarupitɨani yuhetsie 'axamɨti'ane mepɨte'ahɨani peuyeweka mɨrayukatuani mawariyari memɨyetuanikɨ. Ne Yawé nekanihɨkɨtɨni nemɨxepata». ");
INSERT INTO hch_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Yawé Muitsexi mɨpaɨ katiniuta'aitɨani ");
INSERT INTO hch_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","'Aruni mɨpaɨ mɨtiwatahɨawekɨ meta niwemama meta yunaime 'ixaheritsixi: «Xɨka xewitɨ xeme 'ixaheritsixi yatɨni 'ateewa kiekame 'Ixaheri kwieyaritsie 'ukaitɨ, Yawé mawari taiyariyari yetuirieni kemutayɨ raye'atɨanike yatɨni kemɨtiyuwaɨriya mawariyari, ");
INSERT INTO hch_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","mɨkɨ mɨtanaki'eriwakɨ tewa 'ukitɨme 'aixɨa 'aneme kaniyetuiriemɨkɨ, tuuru, muxa, yatɨni tsipu. ");
INSERT INTO hch_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Xeime tewa 'axa'aneme xepɨka'ixatɨaka, mɨpaɨ 'anekame xepɨkatanaki'eriyarieni. ");
INSERT INTO hch_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","»Xɨka xewitɨ, kemutayɨ mɨraye'atɨanikɨ yatɨni kemɨtiyuwaɨriya mawariyari Yawé yetuirieni tuuru yatɨni muxa 'aixɨa memɨteyuxeiya mawariyari mayanikɨ, mɨkɨ 'aixɨa pɨ'aneni mɨtanaki'eriwakɨ. ");
INSERT INTO hch_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Tewaxi yawe mepɨkayetuiriwani mawari taipa warɨkariekame mayanikɨ mekaheuneniereme, me'uti'ɨtsaiwame, me'ɨkamɨmɨrime, meheu'etsatɨkaime, meheunerɨitsietɨkaime, meta haiya xetatɨ kumarikeme wanawiyaritsie mehexeiyame. Mɨpaɨ me'anenekame mawari taiyametsie xepɨkawayetuayani. ");
INSERT INTO hch_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Kemɨtiyuwaɨriya mawariyari mayanikɨ xeikɨa xepɨyɨwaweni xemiyetuanikɨ xeime tuuru yatɨni muxa tsepa 'etsihawekame, peru kepemutayɨ pemɨraye'atɨanikɨ mɨpaɨ 'anetɨ mawari pɨkatanaki'eriwa. ");
INSERT INTO hch_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","»Yawé xeime xepɨkayetuiriwani memɨtexuawe 'ipuriteya tiukwinitɨarieyu, pɨratsietɨkaikaku, haxitekietɨkaime yatɨni hatsatsanime. Yukwietsie mɨpaɨ xepɨkateyurieka. ");
INSERT INTO hch_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","'Ateewa kiekatari xɨka mɨpaɨ me'aneneme mewayetuayani xepɨkawanaki'eririeka, 'iyetuanike xekakaɨyari 'ikwaiya mayanikɨ. Mɨkɨ 'axamemɨ'anenekɨ xepɨkatanaki'eriyarieni». ");
INSERT INTO hch_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Yawé Muitsexi mɨpaɨ katiniutahɨawe: ");
INSERT INTO hch_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","«Kepauka tsikeru mɨtinuiwa, yatɨni muxa yatɨni tsipu nunutsi, mɨkɨ pɨyuhayewa yumaama hamatɨa 'atahuta tukari. 'Atahaika tukari meutiyune Yawé pitanaki'erieni mawari taipa warɨkariekame mɨyetuiyani mayanikɨ. ");
INSERT INTO hch_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","»Xeitukariyaritsie mieme xeime wakaxi meta xeime muxa meyuniwematɨkaime xepɨkawaranutixitekeni. ");
INSERT INTO hch_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","»Kepauka Yawé xeime mawari xemɨyetuirieni pamɨpariyutsi xemipitɨakɨ, 'aixɨa 'anemekɨ xeketeneuyuri xemɨtanaki'eriyarienikɨ. ");
INSERT INTO hch_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Mɨkɨ tukaritsie xeikɨa xekanitikwaikuni, xepɨka'ikuhayeikawani 'uxa'arieka mieme mayanikɨ. Ne Yawé nekanihɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","»Yaxeketenekahuni ne'aitsikatsie mɨpaɨ xeketeneyurieka. Ne Yawé nepɨhɨkɨ. ");
INSERT INTO hch_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","»Kenemɨtitewakɨ nekapatsiekame xepɨkanetsi'ayeitɨwani matsi xekenenetimati nemɨpatsiekɨ 'ixaheritsixi watsata. Ne Yawé nekanihɨkɨtɨni nemɨxepata. ");
INSERT INTO hch_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Ne 'Ekipitu nekaxenayehapani xekakaɨyari nemayanikɨ. Ne Yawé nekanihɨkɨtɨni». ");
INSERT INTO hch_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Yawé Muitsexi katiniuta'aitɨani ");
INSERT INTO hch_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","'ixaheritsixi mɨpaɨ mɨtiwatahɨawekɨ: «'Ikɨ 'ixɨararite pɨhɨkɨ ne nemɨxe'utawewiri, xeme xemɨwakuxaxatɨwanikɨ patsiekamekɨ memuyukuxexeɨriwanikɨ nehetsiemieme. Ne Yawé 'ikɨ nemɨxe'utiwewirikɨ. ");
INSERT INTO hch_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","»'Ataxewime tukari xeikɨa xepɨte'uximayaka, matsi 'atahutarieka tukariyaritsie 'uxipiya tukari kanihɨkɨtɨkamɨkɨ, mɨkɨ tukaritsie 'ixɨarari patsiekamekɨ memuyukuxexeɨriwa nehetsiemieme pɨhɨkɨtɨni, 'ana tixaɨtɨkɨtɨma xepɨkate'uximayaka. Tsepa xeme hakewa xemetiteni, xawati kanipatsiekamɨkɨ Yawé hetsiemieme. ");
INSERT INTO hch_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","»'Ikɨ 'ixɨararite kanihɨkɨtsixitɨni Yawé mɨxe'utawewiri, patsiekamekɨ memuyukuxexeɨriwa hetsiemieme xeme xepikuxatani xexuitɨ tukari mɨka'inɨaritɨkatsie: ");
INSERT INTO hch_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","»Patsikwa Yawé hetsiemieme tamamata heimana naurieka tukayaritsie putsutɨ mexɨakame metseriyaritsie tau makayunetsieke. ");
INSERT INTO hch_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Tamamata heimana 'auxɨwirieka tukari 'aye'ayu mɨkɨ metseriyaritsie paa mɨkakuxanariyarietɨka 'ixɨarariyari kanitsutɨni Yawé hetsiemieme. 'Atahuta tukari paa mɨkakuxanariyarietɨka xepɨkwaka. ");
INSERT INTO hch_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Mexɨakame tukaritsie mepiwewieni 'ixɨarari patsiekamekɨ memuyukuxexeɨriwa hetsiena mieme, mɨkɨ tukaritsie tixaɨtɨkɨtɨma xepɨkate'uximayaka. ");
INSERT INTO hch_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","'Atahuta tukari Yawé 'imikieri taipa warɨkariekame xekaniwewiriekakuni, 'atahutarieka tukaritsie 'ixɨarari patsiekamekɨ memuyukuxexeɨriwa hetsiena mieme xekaniwewikuni, mɨkɨ tukaritsie tixaɨtɨkɨtɨma xepɨkate'uximayaka». ");
INSERT INTO hch_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Yawé Muitsexi mɨpaɨ katiniuta'aitɨani, ");
INSERT INTO hch_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","'ixaheritsixi mɨpaɨ mɨtiwatahɨawekɨ: «Kepauka xeme xemeutahaxɨani kwie nemɨxeyetuirienitsie, meta tɨriku xemɨka'itsanatsie, mawari wewiwame hetsɨa xeimanukuyari xekananukweikuni matɨari mɨtiharieni mika'itsanatsie mieme. ");
INSERT INTO hch_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Mawari wewiwame tɨriku 'anahɨakame 'imikieriyari teikɨ kanetseramɨkɨ 'iyuitɨwatɨ Yawé hɨxie mɨtanaki'eriyarienikɨ. Xawatikɨ 'anutiyayu 'uxa'arieka ximeri miyetuanikɨ. ");
INSERT INTO hch_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","'Ana kwitɨ mɨkɨ tukariyaritsie xeime muxa xekanitimawakuni xeiwiyari hɨkame, 'aixɨa 'aneme, mawari taiyariyari Yawé hetsiemieme mayanikɨ. ");
INSERT INTO hch_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Meta xepiyetuirieni nauka kiruyari tɨriku mɨtɨxiyari 'aixɨa mɨ'ane hatseiti wiriyariekame, tɨriku mawariyari mayanikɨ, 'imikieri taipa warɨkariekame witsimu'ɨa Yawé minake, meta xeirituruyari kaxie winuyari yetuame kanitiyeurimɨkɨ. ");
INSERT INTO hch_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Paa xepɨkatikwani meta 'uriyari xarikiyari meta mɨhehekwa kepauka mɨkɨ 'imikieri yukakaɨyari xemɨ'atɨirienitsieke. 'Ikɨ 'aitsika pɨhɨkɨtɨni yamemɨtekahunikɨ yunaitɨ 'anuiwaritsie miemete, tsepa hakewa memekuteni. ");
INSERT INTO hch_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","»Mɨkɨ xawati tukariyari 'aye'ayu 'uxa'arieka, tatsɨari kepauka tɨriku 'imikieri manukuyari xemɨ'atɨanitsie, 'atahuta tsemanayari 'aye'arɨkame xekani'inɨatakuni. ");
INSERT INTO hch_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Xewitɨta niuki pɨ'inɨarini, huta tewiyari heimana tamamata tukari xekani'inɨatakuni 'atahuta xawatiyaritsie 'uxa'arieka ximeriyari xe'inɨatatɨta, 'ana Yawé xekaniyetuiriekuni 'imɨari mɨhehekwa mawariyari. ");
INSERT INTO hch_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Paa yukie mieme Yawé xekani'atɨiriekuni, teikɨ hetserarietɨ 'uyuitɨariwatɨ mawariyari mayanikɨ matɨari mɨtiukaxuawerixɨ, paa hutame nauka kiruyari tɨriku mɨtɨxiyari 'aixɨa mɨ'anekɨ wewiyatɨkaime, tikuxanariyamekɨ kwaxiyariekame. ");
INSERT INTO hch_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Meta 'atahutame muxatsi 'ukitsi xepɨwayetuani paa nɨkame xeiwiyari mehɨtɨkaime 'aixɨa me'aneneme, xeime tsikeru meta yuhutame muxatsi 'ukitsi. Tɨriku mawariteyari meta kaxie winuyari mɨtiyeuriyani mawariyari yɨnɨkame, xeime mawari taiyariyari Yawé hetsiemieme, witsimu'ɨa Yawé minake. ");
INSERT INTO hch_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Hikɨ tsipu 'uki xekanitimawakuni 'axaxemɨte'uyuri mawariyari mayanikɨ, meta yuhutame muxatsi xeiwiyari mehɨtɨkaime kememɨteyuxewi mawariyari mayanikɨ. ");
INSERT INTO hch_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Mawari wewiwame muxatsi memuyuhuta teikɨ kaniwaretseramɨkɨ 'iyuitɨwatɨ, meta paa matɨari mieme heutinɨkame. Mɨkɨ mawari 'uyuitɨariwatɨ Yawé hɨxie mɨyetuiwakɨ, mawari mɨpatsie Yawé hetsiemieme meta mawari wewiwame hetsiemieme pɨrayani. ");
INSERT INTO hch_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","'Ana kwitɨ mɨkɨ tukaritsie, xeme xekaniyukuxeɨrikuni 'ixɨarari patsiekame Yawé hetsiemieme xewewienike, mɨkɨ tukaritsie tixaɨtɨkɨ xepɨkate'uximayaka. 'Ikɨ kanihɨkɨtɨkamɨkɨ 'aitsika yuheyemekɨ yamemɨteyuriekakɨ yunaitɨ 'anuiwarima, tsepa hakewa memetiteni. ");
INSERT INTO hch_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","»Kepauka 'itsanaxa tukari maye'ani, naime tetsitanapai xepɨka'itsanatɨweni meta muyukuhayeikawa naime xepɨkayeteɨxirɨmeni. Xekenekuhayeikawani tixaɨtɨ memɨkatehexeiya meta 'ateewa kiekatari wahetsiemieme mɨrayanikɨ. Ne Yawé xekakaɨyari nekanihɨkɨtɨni». ");
INSERT INTO hch_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Yawé Muitsexi katiniuta'aitɨani ");
INSERT INTO hch_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","'ixaheritsixi mɨpaɨ mɨtiwatahɨawekɨ: «Mexɨakame tukaritsie 'atahuta metseriyaritsie 'ana xeme 'uxipiya xepexeiyani, xeme xeme'eriwanikɨ mɨkɨ tukaritsie kuxineta pukayuaneni, 'ixɨarari patsiekamekɨ memuyukuxexeɨriwa Yawé hetsiemieme. ");
INSERT INTO hch_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Mɨkɨ tukaritsie tixaɨtɨkɨ xepɨkate'uximayaka, matsi pɨta Yawé 'imikieri taipa warɨkariekame xekateniyetuiriekakuni». ");
INSERT INTO hch_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Yawé Muitsexi mɨpaɨ katiniutahɨawe: ");
INSERT INTO hch_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","«Tamamata tukaritsie 'atahuta metseriyaritsie 'ana xemɨteheuyehɨwiyarɨwa tukariyari pɨhɨkɨtɨni. 'Ixɨarari patsiekamekɨ memuyukuxexeɨriwa Yawé hetsiemieme xekaniwewiekuni, meta xekaniyuhakiekuni meta 'imikieri taipa warɨkariekame xekaniyetuakuni. ");
INSERT INTO hch_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Mɨkɨ tukaritsie tixaɨtɨkɨ xepɨkate'uximayaka mɨreuyehɨwiyarieni tukariyari mɨhɨkɨkɨ, kepauka Yawé xekakaɨyari hɨxie 'itiya mawariyari mukuwewiwakɨ xehetsiemieme. ");
INSERT INTO hch_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Xɨka xewitɨ kayuhakieni mɨkɨ yuteɨterima watsata payeweiyarieni. ");
INSERT INTO hch_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Xɨka xewitɨ tiuta'uximayata mɨkɨ tukaritsie, ne nekɨmana kiekarieyatsie nekanenuyehɨamɨkɨ. ");
INSERT INTO hch_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","'Ayumieme, xeme tixaɨtɨkɨ xepɨkate'uximayaka. 'Ikɨ 'aitsika yuheyemekɨ kanihɨkɨtɨkamɨkɨ yaxemɨtekahunikɨ yunaime xenuiwaritsie kanimiemetɨni, tsepa hakewa xemetiteni. ");
INSERT INTO hch_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Mɨkɨ 'uxipiya tukari xehetsiemieme payani xemeyexeiyanikɨ, meta xekaniyuhakiekakuni. Mɨkɨ xawati 'atanauka tukariyari taikaiyaritsie xepitsutɨani mɨkɨ metseriyaritsie 'uxa'arieka taikaiyaritsie paitɨ». ");
INSERT INTO hch_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Yawé Muitsexi mɨpaɨ katiniuta'aitɨani ");
INSERT INTO hch_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","'ixaheritsixi mɨpaɨ mɨtiwatahɨawekɨ: «Tamamata heimana 'auxɨwirieka tukaritsie 'atahuta metseriyaritsie, xekanitsutɨakuni Xamaru 'ixɨarariyari Yawé hetsiemieme, mɨkɨ 'atahuta tukari xekaniyurikɨni. ");
INSERT INTO hch_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Mexɨakame tukaritsie 'ixɨarari patsiekamekɨ memuyukuxexeɨriwa Yawé hetsiemieme xekaniwewikuni. Mɨkɨ tukaritsie tixaɨtɨkɨ xepɨkate'uximayaka. ");
INSERT INTO hch_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","'Atahutamexɨa tukari Yawé 'imikieri taipa kwaxiyariekame xekaniyetuiriekakuni. 'Atahairieka tukari 'ixɨarari patsiekamekɨ memuyukuxexeɨriwa xekaniwewikuni Yawé hetsiemieme meta tawari mawari 'imikieri taipa warɨkariekame xekaniyetuiriekuni. 'Ixɨarari patsiekamekɨ memuyukuxexeɨriwa kanihɨkɨtɨni. Mɨkɨ tukaritsie tixaɨtɨkɨ xepɨkate'uximayaka. ");
INSERT INTO hch_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","»'Ikɨ 'ixɨararite kanihɨkɨtɨni Yawé mɨxe'utawewiri, xeme xemikuxatanikɨ patsiekamekɨ memuyukuxexeɨriwa Yawé hetsiemieme, xemiyetuirienikɨ mawari 'imikieri taipa warɨkariekame, mawari taiyariyari, tɨriku mawariyari, meta mawarite meta kaxie winuyari mɨtiyeuriwa mawariyari, kemɨreku'ukaikɨ maye'atɨarienikɨ xexuime tukaritsie. ");
INSERT INTO hch_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","'Ikɨ naitɨ 'ixɨararite xawati tukariyaritsie kanixeitaparitɨni Yawé tukari 'uxipiyayatsie ketemɨte'umikiwa, kepemɨti'ahɨritɨa mawariyari, yanutsu kepemɨti'awaɨriya mawariyari xeme xemiyetuirie. ");
INSERT INTO hch_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","»Tamamata heimana 'auxɨwirieka tukariyaritsie 'atahuta metseriyaritsie, kwiepa 'ikwaxite mɨtiutixuawerixɨ xetekuxeɨriemeri, 'atahutamexɨa tukari Yawé hetsiemieme xekaniwewikuni. Mexɨakame tukaritsie meta 'atahairieka tukariyaritsie 'uxipiya tukari kanihɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Mexɨakame tukariyaritsie, katinitipimɨkɨ 'iteɨrite 'aixɨa mɨ'anenetsie timieme, takɨ xawariyari, meta 'iteɨri xawariyari mɨ'etɨriwiwe, meta hapuri 'aki 'utɨa muxuawe, 'atahuta tukari xekaniyutemamawiekakuni Yawé xekakaɨyari hɨxie. ");
INSERT INTO hch_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Xeiwiyari 'aye'axekaku, 'atahutamexɨa tukari xekanitiwewiwakuni 'ikɨ 'ixɨarari Yawé hetsiemieme. 'Atahutarieka metseriyaritsie xekanitiwewiwakuni. 'Ikɨ 'aitsika kanihɨkɨtɨkamɨkɨ yuheyemekɨ mumieme 'aixɨa mɨ'ane nuiwarite 'umemahu wahetsiemieme. ");
INSERT INTO hch_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","'Atahuta tukari mekaniyuriekuni xamaru kiiyarita me'ayetetɨ. Yunaitɨ 'ixaheritsixi mana memutinunuiwaxɨ xamarutɨa mekanayetekuni, ");
INSERT INTO hch_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","wanuiwarite yamemɨtehetimanikɨ kename ne xamaru mɨpaɨ 'anenemeta newareutayatsaxɨ 'ixaheritsixi kepauka 'Ekipitu nemɨwarayewitɨtsie. Ne Yawé xekakaɨyari nekanihɨkɨtɨni». ");
INSERT INTO hch_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Mɨpaɨ Muitsexi 'ixaheritsixi katiniwarutahekɨatɨani Yawé 'ixɨararite kemɨtiutawewiekaikɨ. ");
INSERT INTO hch_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Yawé Muitsexi mɨpaɨ katiniutahɨawe: ");
INSERT INTO hch_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","«'Ixaheritsixi mɨpaɨ ketiniwaruta'aitɨa huriwa hatseitiyari hɨkɨamekɨ pɨnariekame memɨmatsi'atɨirienikɨ, tukita muyehekɨakakɨ. Mɨpaɨ kɨxeme yuheyemekɨ pɨtatɨkani. ");
INSERT INTO hch_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","'Aruni 'ixuriki tukiyarita kɨxemete kanikuha'aritamɨkɨ, 'ixuriki meuwie hɨxie Kakaɨyari tɨratuya mɨwayekatsie, tɨkarikɨ mɨtakakɨ Yawé hɨxie. 'Ikɨ 'aitsika yuheyemekɨ payani xenuiwarite 'umemahu wahetsiemieme. ");
INSERT INTO hch_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Kɨxemete, kɨxeme 'uitɨwameta hurukɨ mɨwewiyatɨkata 'uyewetɨkaitɨ yuheyemekɨ pɨtatɨkani Yawé hɨxie. ");
INSERT INTO hch_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","»Tɨriku mɨtɨxiyari 'aixɨa mɨ'ane kenewatituka keneutikwaxiya huxunuta tamamata heimana huta tsuirayari. Xexuitɨ mɨkɨ nauka kiruyari pɨraheteni. ");
INSERT INTO hch_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Yawé hɨxie kenamana mexa hurukɨ xeikɨa mɨwewiyatsie, hutakɨa 'ataxewime payari xexuimetsie 'anuyemanetɨkaime. ");
INSERT INTO hch_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Xexuime xurukuyaritsie 'ɨkwa witsimu'ɨa hɨkɨakame pepeutamanatɨyani. Mɨpaɨ paa ma'eriwa mawariyari Yawé muxatɨarie taipa warɨkariekame kanihɨkɨtɨkamɨkɨ. ");
INSERT INTO hch_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","'Ikɨ paa Yawé kaniyetuiriyarɨwamɨkɨ yuheyemekɨ xawatikɨ. 'Ikɨ kanihɨkɨtɨni 'aitsika 'aixɨa mɨ'ane 'ixaheritsixi kaniwahetsiemiemetɨni. ");
INSERT INTO hch_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Mɨkɨ paa 'Aruni hetsiemieme pɨhɨkɨ meta niwemama, mɨkɨ muyepatsietsie mepitikwani. Mawarika yamɨpaɨme waɨkawa mɨpatsie mɨhɨkɨkɨ Yawé muxatɨarie mawari taipa warɨkariekame. Mɨkɨ 'aitsika yuheyemekɨ 'aixɨa mɨ'ane kanihɨkɨtɨni yaxemɨtekahunikɨ». ");
INSERT INTO hch_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","'Ixaheritsixi watsata xewitɨ tewi puyeikakai maamaya 'Ixaheri tewiyari pɨhɨkɨtɨkai, paapayata 'ekipitutanaka tihɨkɨtɨkai. Hikɨ heiwa mɨkɨ tewi 'ixaheri tewiyari hamatɨa mematiteitsie 'imieri mekaniutsutɨani. ");
INSERT INTO hch_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Matsi 'ukaratsi 'ixaheri tewiyari nu'aya, 'axatayɨnike, Yawé 'utaterɨwatɨ hepaɨtsitana 'axakaniutayɨni, hikɨ Muitsexi hetsɨa mekaneihana. (Maamaya Tserumiti katinitewakaitɨni Riwɨri niweya, Rani nuiwarieyatɨtɨ). ");
INSERT INTO hch_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Hikɨ kananutahɨiyani kepaukake Yawé yamɨtiwatahɨawekekai kememiyurienikekaikɨ. ");
INSERT INTO hch_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Hikɨ Yawé Muitsexi mɨpaɨ katiniutahɨawe: ");
INSERT INTO hch_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","«'Axatiniukame xematiteitsie xekenayenɨ'a. Kemɨ'ane memi'eni mɨkɨ yumamakɨ mu'uyatsie mekeheutimeni meta memuyuxeɨrie yunaitɨ mekanitituaxixɨakuni. ");
INSERT INTO hch_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Mɨpaɨ 'ixaheritsixi ketiniwaretahɨawi: “Kemɨ'ane 'axamɨtayɨni yukakaɨyari hepaɨtsita, katinika'eniexɨmɨkɨ 'axakememɨtiuyurikɨ”. ");
INSERT INTO hch_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Yaxeikɨata, kemɨ'ane Yawé kemɨtitewakɨ mɨtaterɨwa yuhepaɨ tewi 'axatitahɨaweke kanimieriemɨkɨ. Memuyutixexeɨriwa yunaitɨ mekanitituaxixɨakuni. Tsepanetɨ 'ateewa mɨkiekame yatɨni mana munuiwame, xɨka Yawé 'utaterɨwa yuhepaɨ tewi hepaɨtsita 'axatayɨnike. Mɨkɨ kanimieriemɨkɨ. ");
INSERT INTO hch_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","»Kemɨ'ane xeime tewi mɨmieni, mɨkɨta kanimieriemɨkɨ. ");
INSERT INTO hch_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","»Xɨka xewitɨ xeime tewatsiekame 'umieni, xeime tewa kanikɨhɨamɨkɨ. ");
INSERT INTO hch_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","»Kemɨ'ane yuhepaɨ tewi mɨtikwinitɨani, yaxeikɨata mɨkɨ kanitikwinitɨariemɨkɨ titakɨ mɨtikwinitɨa: ");
INSERT INTO hch_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Xɨka xeime 'umeya 'akamura mɨkɨta 'umeya ke'akamuriyarieni, Xɨka xeime hɨxieya watituni mɨkɨta hɨxieya kewatituiyani, xɨka tameya 'anaye'una mɨkɨta tameya ke'anaye'uniyarieni, pɨtiuka'eniwani yuwaiyaritsie ketitakɨ mɨyamɨtiuyurikɨ. ");
INSERT INTO hch_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","»Kemɨ'ane tewatsiekame mumieni xeime kaniyetuamɨkɨ mimikɨ, matsi kemɨ'ane tewi mumieni mɨkɨta kanimieriemɨkɨ. ");
INSERT INTO hch_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Yuxewitɨ 'inɨari niukiyari katinita'aitamɨkɨ, 'ena nuiwakame meta 'ateewa kiekame wahetsie. Ne Yawé xekakaɨyari nekanihɨkɨtɨni». ");
INSERT INTO hch_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Muitsexi 'ikɨ naime 'ixaheritsixi katiniwarutaxatɨani, 'axatiniukame memakuteitsie mekanayenɨ'ani, mana mekaneitituaxixɨani. Yawé Muitsexi kemɨtiuta'aitɨakai 'ixaheritsixi mɨpaɨ mekateniuyurieni. ");
INSERT INTO hch_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Hikɨ Tsinahi yemuriyaritsie Yawé Muitsexi katiniuta'aitɨani, ");
INSERT INTO hch_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","'ixaheritsixi mɨpaɨ mɨtiwatahɨawekɨ: «Kepauka xeme xemeutahaxɨani kwie nemɨxeyetuirienitsie, mɨkɨ kwie kanika'uxipimɨkɨ xeiwiyari, Yawé hetsiemieme. ");
INSERT INTO hch_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","'Ataxewime wiyari xemaku'etsatsie xepɨka'eni, meta yukaxie xepanuwitexɨani 'ikwaxiyari xekanika'itsanakuni, ");
INSERT INTO hch_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","matsi 'atahuta wiyari 'aye'ayu, kwie xeiwiyari kanika'uxipimɨkɨ meta kaniyutemawiekamɨkɨ Yawé hetsiemieme. Xemaka'etsatsie xepɨkaka'eni meta yukaxie xepɨkahanuwitekeni, ");
INSERT INTO hch_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","yukɨmana watiyɨraxɨaka mɨtixuawerixɨ xepɨkaka'itsanani meta 'akaxie pemɨka'ika'e pepɨka'anuwitekeni. Kwie xeiwiyari 'aye'arɨkamekɨ kani'uxipiekamɨkɨ kaniyutemawiekamɨkɨ. ");
INSERT INTO hch_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Matsi, naime tita kwie mɨtitixuawitɨani mɨka'uxipieni wiyaritsie, xekanitikwaikuni matsi 'axaɨtame hawaikɨ yunaitɨ mekatenikwakakuni te'uximayatamete meta te'iwamete meta 'ateewa kiekatari xehetsɨa memɨtitei. ");
INSERT INTO hch_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","Meta 'atewama yunaitɨ mekatenikwakakuni meta yunaitɨ xekiekaritsie memɨtexuawe. Naitɨ kwiepa mɨtiutixuxuawereni, mɨkɨ wiyaritsie naitɨ katiniwa'ikwaitɨkamɨkɨ. ");
INSERT INTO hch_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","»'Atahutamexɨa 'atahutame wiyari pekani'inɨatamɨkɨ xawatikɨ, mɨkɨ huta tewiyari heimana 'atanauka wiyari kanayeimɨkɨ, ");
INSERT INTO hch_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","tamamata tukariyaritsie 'atahuta metseriyaritsie, tatsɨari memɨteheuyehɨwiyarɨwa tukariyaritsie, 'ana kanitahɨtsieriemɨkɨ kuxineta naitsarie kiekaritsie. ");
INSERT INTO hch_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Huta tewiyari heimana tamamata wiyari 'aye'ayu kanipatsiekamɨkɨ, 'ana mematixɨnarɨwatsie kanihɨkɨtɨkamɨkɨ yunaitɨ mana memɨtitei. Xehetsiemieme mematatuiwa wiyari maye'axe pɨhɨkɨtɨni, yuxexuitɨ mekanitayeixɨakuni yunuiwarite wahetsɨa meta yukwie mekaniyetuiriyariekuni. ");
INSERT INTO hch_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Huta tewiyari heimana tamamata wiyari 'aye'axekaku xeputatuiwani: mɨkɨ wiyaritsie xepɨka'uka'etsani meta xepɨka'uka'itsanani, yɨkɨmana mɨtitixɨawere meta kaxie pemɨka'ika'e pepɨka'anuwitekeni. ");
INSERT INTO hch_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Mɨkɨ wiyari mematatuiwa kanihɨkɨtɨni xehetsiemieme kanipatsiekamɨkɨ. Mɨraka'etsitɨretsie xeikɨa yɨkɨmana tita mɨtiutixuxuawere xekatenikwakakuni. ");
INSERT INTO hch_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","»Mematatuiwa wiyaritsie yuxexuitɨ yunuiwarite wahetsɨa mekanitayeixɨakuni. ");
INSERT INTO hch_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","»Xɨka xeme xewitɨ xeime tiutuirieni yupiini yatɨni xeime tiunanairieni tixaɨtɨ tipiinieya, yuxexuitɨ xepɨkayukwamanani. ");
INSERT INTO hch_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","'Ekɨ 'ahepaɨ tewi pekaninanairiemɨkɨ kepaɨmetɨ wiyari meuyewetse paɨmemekɨ mematatuiwa wiyari maye'anikɨ, mɨkɨta metsituirieni kepaɨmetɨ wiyari meuyewetse mɨka'itsanakɨ mɨpaɨ raye'arɨkamekɨ. ");
INSERT INTO hch_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Xɨka 'akuxi waɨkawa wiyari heuyeweka mematatuiwa maye'anikɨ, mɨkɨ waɨkawa pɨraye'aka, peru xɨka 'etsipaɨmetɨ wiyari heuyewekani, mɨkɨ 'etsiwa kanika'ɨrikamɨkɨ kemɨraye'akai kepaɨmexɨa pemɨka'itsanakɨ mɨkɨ mɨpaɨ kametinituiriemɨkɨ. ");
INSERT INTO hch_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Yuxexuitɨ xepɨkayukwamanani matsi yukakaɨyari xekenayemakaxeni. Ne Yawé xekakaɨyari nekanihɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","»Ne'aitsikatsie yaxeketenekahutɨ ne'inɨari niukiyari xekenaye'atɨaka, kwiepa 'aixɨa 'anemekɨ xekaniu'uwakuni. ");
INSERT INTO hch_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Kwie pɨtiutixɨawitɨwani, meta xeme xepɨkayehakakwitɨweni, mana 'aixɨa 'anemekɨ xekanititekuni. ");
INSERT INTO hch_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","»Xɨka xeyuku'iwawiyanike mɨpaɨ xe'utiyuatɨ: “¿Tita tetetikwani 'atahutarieka wiyaritsie, xɨka teka'uka'eni xɨka ta'iku teka'uka'itsana?”, ");
INSERT INTO hch_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","mɨpaɨ nepɨtixetahɨawe 'ataxewirieka wiyaritsie nepɨxehanɨ'airieni waɨkawa 'aixɨa xemɨ'itɨarienikɨ kwiepa pɨtitixɨawere haika wiyaritsie mieme. ");
INSERT INTO hch_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Kepauka xeme xemɨka'eni 'atahairieka wiyaritsie, 'ana 'akuxi yu'ikwai xekatenexeiyakakuni meripaitɨ mieme xemika'itsanaxɨ, meta 'akuxi 'aikɨ mieme xekwatɨ yurikatsie timieme xepɨka'itsana. ");
INSERT INTO hch_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","»Kwie yuheyemekɨ mukuma xepɨkatuaka, mɨkɨ kwie nepiini kanihɨkɨtɨni, xeme matsi ku'uwamete xekanihɨkɨtɨni xemɨniɨtɨarie xeikɨa mana xemɨtitenikɨ. ");
INSERT INTO hch_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","'Ayumieme, kwie xematiteitsie pɨyɨweni tawari kwie kemɨ'ane mutuiri minanairienikɨ. ");
INSERT INTO hch_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","»Xɨka xewitɨ 'ahurawa 'a'iwa tixaɨtɨ karexeiyatɨ 'ayani, xɨka yutɨɨriyama tiwahetsiemieme mɨrexeiya tituamɨkɨ, mɨkɨ 'iwaya 'ahurawa kaninanairiemɨkɨ para heitserie mexeiyanikɨ tita mɨtituirieni. ");
INSERT INTO hch_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Xɨka mɨkɨ 'uki xeime 'ahurawa yu'iwa kaheixeiyani para hetsienamieme mɨtiyutuanikɨ, matsi xɨka mɨkɨ yukɨmana waɨkawa rexeiyatɨ hayuyeitɨani para yukwie mɨnanenikɨ, ");
INSERT INTO hch_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","mɨkɨ kaniti'inɨatamɨkɨ kepaɨmexɨa wiyari manuyetɨa mituatsie meta kanixeɨrimɨkɨ kemɨraye'axe kemɨ'ane minanairi hetsiemieme. Mɨpaɨ tawari katininuamɨkɨ yukwietsie. ");
INSERT INTO hch_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Matsi xɨka mɨtiyutuanikɨ kara'atɨatɨyani, kwie minanairi hetsɨa puyuhayewa kepaukake mematatuiwa wiyari maye'anitsieke, kepaukake kemɨ'ane mitua hetsɨana manuani, 'anake hetsiena mieme meta tɨɨriyamama wapiini pɨrayani. ");
INSERT INTO hch_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","»Xɨka xewitɨ kii 'utuani kiekari mukurarutɨarietsie yeweme, xeiwiyari ka'aye'awekaku mutiyutuanikɨ heitserie kanexeiyakamɨkɨ, kepauka mituatsie tsutɨtɨ. Mɨpaɨ xeikɨa katineuterimɨkɨ para mɨtiyutuanikɨ. ");
INSERT INTO hch_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Xɨka kiikɨ katiyutuawekaku xeiwiyari 'aye'ani, mematatuiwa maye'anitsie pɨkayetuiriyarieni matsi kemɨ'ane minanai piinieya yuheyemekɨ kanayeimɨkɨ meta xiɨyarimama. ");
INSERT INTO hch_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","»Kiite kiekarite 'etsimɨyeyeutsie mɨti'utɨka kakurarutɨarietɨkaitɨ mɨkɨ kwie mɨyetuiwa hepaɨ pɨ'aneni, mɨrayukatuiyanikɨ pɨyɨweni memɨyetuiriyarienikɨ mematatuiwatsie. ");
INSERT INTO hch_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","»Rewitsixi heitserie mepexeiyani tsepa kepauka yukiite memɨtinanenikɨ hakewa memetiteitsie mɨti'u. ");
INSERT INTO hch_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Xɨka xewitɨ rewitɨtɨ xeime yukii 'utuirieni, kii mutua yukiekaritsie 'uweme mematatuiwa wiyaritsie kaniyetuiriyariemɨkɨ, mɨkɨ kiite rewitsixi wakiekaritsie mɨti'u watɨɨriyama wahetsie kanimiemetɨni 'ixaheritsixi watsata. ");
INSERT INTO hch_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Matsi mɨraka'etsitɨre wakiekari warita mamanetɨka pɨkatuiyani, mɨkɨ mɨtiwapiinikɨ xewitɨ mɨkayɨwe mɨwanawarienikɨ. ");
INSERT INTO hch_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","»Xɨka xewitɨ 'a'iwa tixaɨtɨ karexeiyatɨ hayani titakɨ mɨtiyuparewieka, keneuparewi 'ateewa kiekame yatɨni kuyeikame kepemɨtiparewieka hepaɨ: mɨpaɨ xetewaparewiekaku xehetsɨa mekanikutekuni. ");
INSERT INTO hch_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Hena'iwakamekɨ pepɨka'iwiyani kepauka tumini peminiutɨani yatɨni tikwaiwame, matsi 'akakaɨyari kenayemakaxeni, mɨpaɨ 'a'iwa xetsata pukani. ");
INSERT INTO hch_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Metatsiere tumini rana'iwamekɨ pepɨka'iniɨtuaka meta tita mɨtikwaiwa pemɨtikwetatɨa pepɨkarana'iwani. ");
INSERT INTO hch_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Ne Yawé xekakaɨyari nekanihɨkɨtɨni, 'Ekipitu kwieyaritsie nemɨxe'ayewitɨ, Kanani kwieyari nemɨxeyetuirienikɨ meta xekakaɨyari nemayanikɨ. ");
INSERT INTO hch_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","»Xɨka xewitɨ 'a'iwatɨtɨ tixaɨtɨ karexeiyatɨ hayani xɨka yutuamɨkɨni 'ahetsɨa, waɨriyarika ti'uximayatame hepaɨ pepɨkati'uximayatsitɨaka. ");
INSERT INTO hch_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","'Aixɨa ketinexeiyani ti'iwame yatɨni 'ateewa kiekame xetsata muka hepaɨ. 'Ahetsiemieme pɨti'uximayaka mematatuiwa wiyari maye'anitsieke. ");
INSERT INTO hch_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Hikɨ 'ana yuniwema wahamatɨa mɨyemiekɨ pepipitɨani, meta 'anake mepɨyɨwaweni yu'iwama wahetsɨa memɨyehukɨ meta watewarima kwie memuwaruku'eiriritsie mepɨ'axɨani. ");
INSERT INTO hch_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Yunaitɨ 'ixaheritsixi nete'uximayatsiriwamete mekanihɨtɨtɨni. Ne 'Ekipitu kwieyaritsie nekaniwarayewitɨni, 'ayumieme mepɨkatuiyani waɨriyarika te'uximayatamete wahepaɨ. ");
INSERT INTO hch_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Hahetemekɨ pepɨkatiwa'aitɨaka, matsi 'akakaɨyari kenayemakaxeni. ");
INSERT INTO hch_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","»Waɨriyarika texe'uximayatsiriwamete 'ukitsi meta 'ukarawetsixi nuiwarite xe'aurie mamanetɨkatsie mepɨkiekataritɨni, mana xepɨwatinaneni. ");
INSERT INTO hch_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Yaxeikɨatatsiere pepɨyɨweni waɨriyarika te'uximayatamete xekwietsie memutinunuiwaxɨ pemɨwatinanenikɨ, mɨkɨ 'ateewa kiekatari mepɨwaniwematɨni xetsata memɨtitei. Mɨkɨ xehetsie mekanimiemetetɨkakuni, ");
INSERT INTO hch_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","meta yutɨɨriyama xemɨwakuhayewienikɨ xepɨyɨwaweni xepiini mɨkɨ wahetsie mɨtinakenikɨ para yuheyemekɨ memɨtewa'uximayatsirieka kememɨteheutereke. Xeme matsi xeyu'iwamatɨ hahetemekɨ xepɨkateyu'aitɨaka. ");
INSERT INTO hch_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","»Xɨka xewitɨ 'ateewa kiekame yatɨni kuyeikame xetsata waɨkawa rexeiyatɨ hayani, matsi xɨka xewitɨ xe'iwa reuyehɨatɨ tixaɨtɨ karexeiyatɨ hayani meta 'uyutuani 'ateewa kiekame hetsɨa yatɨni watɨɨriyama wahetsɨa, ");
INSERT INTO hch_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","heitserie kemɨrexeiya pɨkaheiyehɨani mɨtiyutuiyanikɨ hetsiena mieme 'arikekeri 'uyutuayu. Pɨyɨweni tsepa 'iwaya xewitɨ mɨtiyutuanikɨ: ");
INSERT INTO hch_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","xewitɨ tatatsieya yatɨni 'iwaya tsepa kemɨpaikɨ 'iwayatɨtɨ xeikɨa. Xɨka matsi yukɨmana waɨkawa rexeiyatɨ hayuyeitɨani pɨtiyutuani yuhetsiemieme. ");
INSERT INTO hch_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Muyutua meta kutsiyarieya mepiti'inɨata tukari kepaɨmexɨa manuyetɨa, ke'aneme wiyariyaritsie muyutua mematatuiwa wiyaritsie maye'anitsieke. Mɨxɨnarienikɨ ti'uximayatame kepaɨmeme ma'iwaxɨ mɨyareutereka hepaɨ katineyukatuamɨkɨ. ");
INSERT INTO hch_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Xɨka 'akuxi waɨkawa wiyari heuyeweka, mɨxɨnarienikɨ pɨtiyutuani yapaɨmeme hanutimaname kepauka muyutuatsie miemekɨ mɨ'ɨitɨariekaikɨ. ");
INSERT INTO hch_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Xɨka 'etsipaɨmetɨ wiyari xeikɨa heuyeweka mematatuiwa wiyari maye'anikɨ, kaniti'inɨatamɨkɨ katiniyutuamɨkɨ mɨxɨnarienikɨ kepaɨmetɨ wiyari meuyewetse miemekɨ. ");
INSERT INTO hch_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Xeme xekanixeiyakakuni kutsiyarieya xeiwiyari memɨte'uta'uximayata wahepaɨ mɨtixeiyanikɨ, meta waɨkawa hahetemekɨ pɨkati'aitɨaka. ");
INSERT INTO hch_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","»Xɨka 'a'iwa hetsiemieme karayukatuiyani 'ikɨ kemɨraxaxatsiwakɨ, mɨkɨ meta niwemama mepɨxɨnarieni mematatuiwatsie wiyari 'aye'ayu. ");
INSERT INTO hch_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","»'Ixaheritsixi nete'uximayatsiriwamete mekanihɨkɨtɨni. Ne 'Ekipitu kwieyaritsie nekaniwarayewitɨni. Ne Yawé xekakaɨyari nekanihɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","»Kakaɨyarixi xepɨkawawewieka, meta tetexi patsietɨkaime meta tixaɨtɨmexi wa'ɨkiya xepɨkati'uitɨwani. Yukwiepa xepɨkawati'uitɨwani tetexikɨ metewewiyatɨkaime meta wahetɨa xepɨkatihɨxima'uweni. Ne Yawé xekakaɨyari nekanihɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","»Xekeneuka'uxipiweni xawati tukariyaritsie, netuki xekenayexeiyani. Ne Yawé nekanihɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","»Xɨka yaxete'u'uwani kenemɨtixe'u'aitɨa meta ne'aitsikatsie yaxetekahuni 'aixɨa 'anemekɨ, ");
INSERT INTO hch_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","ne wiyeri tukarieyatsie nepɨxehanɨ'airieni, kwie meta 'iteɨri 'ikwaxi pɨtitixɨaweriya, ");
INSERT INTO hch_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","tɨriku 'urietɨkaitɨ 'apɨreutere kepauka mɨtika'inɨiyanitsiekeri, mɨtika'inɨiyanita kepauka mɨtika'etsitɨtsiepai pɨreutere. Xepɨkayehakakwitɨweni mana kwiepa 'aixɨa 'anemekɨ xepu'uwani. ");
INSERT INTO hch_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","»Ne 'akwietsie 'aixɨa 'iyari nekaniwapitɨamɨkɨ, xeme 'aixɨa 'anemekɨ xekanitikukutsukuni xekaheumamatɨ. Kwiepa memɨtexɨawe memamariwawetɨ nekaniwapatamɨkɨ memɨteyukwa'a memɨteyukewe meta kuyaxa 'akwietsie pɨkaxɨaweni. ");
INSERT INTO hch_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Memɨxe'aye'unie xekaniwaranukuweiyakuni, xehɨxie mekanikaxɨrikuni 'ixiparatekɨ xewakwiyu. ");
INSERT INTO hch_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Xeme yu'auxɨwitɨ xeitsienituyari xekaniwaranukuweiyakuni, xemeta xeitsienituyari tamamata miriyari xekaniwaranukuweiyakuni, xehɨxie mekanikaxɨrikuni 'ixiparakɨ xewakwiyu. ");
INSERT INTO hch_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","»Ne nekanixexeitsitɨamɨkɨ 'aixɨa kenemɨtiuka'iyari. Ne xeyuxiɨtɨakame nepɨxe'ayeitɨani. Nekanixetimɨiriyamɨkɨ meta netɨratu xehetsɨa nekaniwewimɨkɨ. ");
INSERT INTO hch_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","'Akuxi 'aikɨpai mieme xemika'itsanaxɨ xekanikwakakuni kepauka meripai mieme xemɨwaye'ɨni para mɨhehekwa pɨta xemeuta'utakɨ. ");
INSERT INTO hch_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Xetsata nekii nekanitawewimɨkɨ muwa nemayekanikɨ, meta hatsuaku nepɨkaxetixani'erieni. ");
INSERT INTO hch_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Xehamatɨa nekaniumiemɨkɨ. Ne xekakaɨyari nepɨhɨkɨtɨni, xeme nekiekari xepɨhɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Ne Yawé xekakaɨyari nekanihɨkɨtɨni, 'Ekipitu kwieyaritsie nemɨxe'ayewitɨ waɨriyarika xete'uximayatɨ xemɨtehayewakɨ. Ne xeyuku kaunariyari nekananuteke xemenuyetekakaikɨ waɨkawa xete'aitɨarietɨ, meta heitserie xehanukuneniereme nepɨxe'ayeitɨa. ");
INSERT INTO hch_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","»Xɨka xeme kenemɨtixe'u'aitɨa mɨpaɨ xekatekakɨne 'ikɨ naime 'aitsikate hetsie, ");
INSERT INTO hch_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","xɨka ne'aitsika xe'uxieka meta ne'inɨari niukiyari xexani'erieka, meta yaxekate'uyurieni naime ne'aitsikatetsie, netɨratu xetitsanatɨ, ");
INSERT INTO hch_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","hikɨ ne nekɨmana nepɨxe'uximatɨani waɨkawa haxɨa kwiniya nekaxenanɨ'airiemɨkɨ, hɨiya mɨkɨ kanixetiweranariyamɨkɨ, xekaheuneniereme kanixe'ayeitɨamɨkɨ meta kanixekwimɨkɨ. Yakɨ xeikɨa yu'imɨari xekanika'ekuni, memɨxe'aye'unie pɨta memitikwanikɨ. ");
INSERT INTO hch_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Neri nepɨkaxeparewieni xehetsɨa nekaninepatamɨkɨ, memɨxe'uweiya mekaxena'iwakuni. Memɨxe'aye'unie mekaxetenita'aitɨakuni, xeme pɨta xekaniyuta'unaxɨakuni tsepa xewitɨ mɨkaxe'uweiya. ");
INSERT INTO hch_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","»Xɨkari 'ikɨ naitɨ ranuyeyayu 'akuxi xekanetsiheu'enieka, 'atahutamexɨa nekanixe'uximatɨamɨkɨ 'axakexemɨteyuriekɨ. ");
INSERT INTO hch_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Kexemɨteyuti'ɨre ne nekanika'unamɨkɨ meta xemɨkaheu'enanakɨ. Muyuawi tse'ime nepayeitɨani tepɨa hepaɨ, kwie wurunitse hepaɨ 'aneme nepayeitɨanita, ");
INSERT INTO hch_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","yakɨxeikɨa yutɨrɨkariya mepɨtixɨtɨani, tixaɨtɨ kwiepa pɨkatitixɨawere meta 'iteɨrite 'ikwaxi pɨkawatixɨawitɨirieni. ");
INSERT INTO hch_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","»Xɨka matsi 'akuxi menetsi'aye'unieka, meta mekanetsi'enieka, matsi tawari 'akuxi 'atahutamexɨa nepɨwa'uximatɨani ke'axamemɨte'uyurikɨ. ");
INSERT INTO hch_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","'Ɨrawetsixi teyukwa'amete yeutari xehetsɨa nepɨwaranɨnɨ'ani, xeniwema mepɨxetihapanirieni meta xetewama mepuwareuyehɨani. Mɨpaɨ mepɨteyurieni yakɨxeyupaɨmeme memɨxe'ayeitɨanikɨ meta xehuye yuxaɨtame muyuhayewakɨ. ");
INSERT INTO hch_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","»Tsepanetɨ 'ikɨ naitɨ mɨyamɨtiɨyɨ, xɨka matsi 'akuxi kenemɨtiwa'ɨkitɨa newa'uximatɨatɨ meka'i'enieni, matsi xɨka 'akuxi menetsi'aye'unietɨ meyewekani, ");
INSERT INTO hch_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","neta nexe'aye'unietɨ nepɨnehayewani. Ne nekɨmana nepɨxetikwinitɨani 'atahutamexɨa 'axaxemɨte'uyurikɨ. ");
INSERT INTO hch_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Ne nekaniwapitɨamɨkɨ memɨxe'aye'unie memɨxekwinikɨ 'ixiparatekɨ, netɨratu kemɨreku'uxakɨ yaxemɨkatekakɨkɨ. Kepauka yukiekaritsie xemɨyehu xeyuta'unake, ne nepɨxe'anunɨ'airieni kwiniya mɨmɨya, meta memɨxe'aye'unie wahetsɨa nepɨxeyetuani. ");
INSERT INTO hch_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Kepauka xe'ikwai naime nemɨtikumaweriyatsie tamamata 'ukari paa mepɨkwaxiyani xeihuxunuta xehetsiemieme. Meta mepuwatamini yapapaɨmeme, kepauka xemitikwani mɨkɨkɨ xepɨkatihuxani. ");
INSERT INTO hch_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","»Xɨka mɨyatɨtɨ mete'uka'eniwatɨ matsi 'akuxi mekanetsiheu'enieka, matsi xɨka 'akuxi menetsi'aye'unietɨ meyuhayewani, ");
INSERT INTO hch_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","kamɨtsɨ neta nepɨxe'aye'unieka. 'Atahutamexɨa nepɨxe'uximatɨani 'axaxemɨte'uyurikɨ, ");
INSERT INTO hch_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","meta yuniwema 'ukitsi 'ukari wawaiyari xekanitikwaikuni. ");
INSERT INTO hch_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Xetukite 'etsimɨpepe kakaɨyarixi xemɨtewaranutimawiriwa nepɨka'unaxɨani, meta mawari taiyame 'ɨkwa witsimu'ɨa xematitaiyatsie nepɨka'unaxɨani, meta xekaxarite 'aneme nepɨkeni xekakaɨyarixi memɨka'ayeneniere wa'ɨkiyari waheima, nehaxɨa xehetsɨa punuani. ");
INSERT INTO hch_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Xekiekarite nepakumaweriyari, watukite nepatixɨriexɨani. Xemawari witsimu'ɨatɨkatei mɨnetsinakekaikɨri nepɨkayukatemawieni. ");
INSERT INTO hch_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Yaxeikɨatatsiere kwiepa xematiteitsie hakumaweme nepayeitɨani, memɨxe'aye'unie mepɨhɨxiyani kepauka memɨ'axɨani mana memɨtiyaxekɨ. ");
INSERT INTO hch_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Hipame nuiwarite watsata nekanixetaxɨriexɨamɨkɨ: 'ixipara newatihaname nepɨwaranukuweiya wakwie yuxaɨtame nepɨhayewa, wakiekari nepɨka'unaxɨani. ");
INSERT INTO hch_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Hikɨ kwie pu'uxipieka naime tukariyaritsie kepaɨmexɨa wiyari yuxaɨtame muyuhayewa, mexixi xeme memɨxe'aye'unie wakwietsie xetiteni, mɨpaɨ kwie pɨtika'uxipieni xawatikɨ yutemawietɨ. ");
INSERT INTO hch_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Mexixi kwie 'akumawetɨ yuhayewa, mɨkɨ 'uxipiya kanexeiyakamɨkɨ kepauka xawatikɨ wiyari maye'axekaitsie kemɨkareixeiyakaikɨ kepauka mana xemɨtiyaxixɨtsie paitɨ. ");
INSERT INTO hch_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","»Keyupaɨmetɨ memuyukuhayewa, memɨwaraye'unie wakwietsie me'u'uwatɨ waɨkawa mekanimamakakuni, xatsi 'ekakɨ kuyuitɨariwakaku me'enietɨ mepuyuta'unani. Xewitɨ 'ixipara 'akwetɨ muwaruweiyani hepaɨ mekateniunanautsakuni, mekanekaxɨrikuni tsepanetɨ xewitɨ kawaruweiya. ");
INSERT INTO hch_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","'Ixipara memumakarɨme hepaɨ, yu'iwama wahetsie mekaniuyexɨruwekuni xewitɨ kawaruweiyakaku, mepɨkayɨwaweni yuneukixiwima memɨwatakwinikɨ. ");
INSERT INTO hch_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Hipame nuiwarite watsata xekaneuyewekuni, memɨxe'aye'unie wakwie kaxenitikwaimɨkɨ. ");
INSERT INTO hch_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Xeme hipatɨ xemɨyuhayewa memɨxe'aye'unie mematiteitsie xekanikaxɨrikuni, ke'axaxemɨte'uyurikɨ xepaapama xepanutinɨitɨiriyarieni. ");
INSERT INTO hch_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","»Matsi xɨka xe'itahekɨata 'axakexemɨte'uyurikɨ meta xepaapama 'axakememɨte'uyurikɨ, memɨnetsi'uku'eirikɨ, meta menetsi'aye'unietɨ memakɨkɨ, ");
INSERT INTO hch_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","mɨkɨkɨ waɨriyarika mepɨnetsi'upitɨa nemɨwaranɨnɨ'anikɨ memɨwaraye'unie wakwietsie, xɨka wa'iyari kemɨtiyumate tixaɨtɨ mekateheyeitɨatɨ meta meheyutimaixɨame 'axakememɨte'uyurikɨ, ");
INSERT INTO hch_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","hikɨ nepeye'erieni netɨratu kenemɨtiutawewi, Kakuwu, 'Itsahaki meta 'Apɨrahami wahamatɨa, yaxeikɨatatsiere kwie nepaye'erieni. ");
INSERT INTO hch_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Mɨkɨ kwie meku'eirieyu, kaniyutemawiekamɨkɨ xawati tukari maye'axenitsie mexixi mana katikuteitɨni. Matsi ke'axamemɨte'uyurikɨ yamekateneyutimaikuni, ne'aitsika memɨka'utanaki'erikɨ meta ne'inɨari niukiyari memuti'uxiwe'erikɨ. ");
INSERT INTO hch_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","»Mɨyatɨtɨ, tsepa memɨwaraye'unie wakwietsie memɨtiteni, ne nepɨkawarayexɨrieni meta nepɨkawatixani'erieni meta nepɨkawarakumaweriya, netɨratɨ wahetsɨa nepɨkatitsanaxɨani. Ne Yawé xekakaɨyari nekanihɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Matsi watutsima wahetsiemieme tɨratu kenemɨtiutawewi nekanaye'erimɨkɨ, kepauka hipame nuiwarite wahɨxie 'Ekipitu kwieyaritsie nemɨwarayewitɨ wakakaɨyari nemayanikɨ. Ne Yawé nekanihɨkɨtɨni». ");
INSERT INTO hch_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","'Ikɨ 'aitsikate kanihɨkɨtɨni yaxemɨtekahunikɨ ne'inɨari niukiyari kemaine, 'ikɨ 'aitsika kanixeyetuirieni Muitsexi Yawé yatitahɨaweku kaxeniutawewirieni, Tsinahi yemuriyaritsie mɨkɨ hamatɨa meta 'ixaheritsixi. ");
INSERT INTO hch_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Yawé Muitsexi mɨpaɨ katiniuta'aitɨani ");
INSERT INTO hch_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","'ixaheritsixi mɨpaɨ mɨtiwatahɨawekɨ: «Xɨka xewitɨ kemutayɨkɨ 'imikieriyari Yawé yetuiriemɨkɨ tewi kemɨraye'axekɨ, ");
INSERT INTO hch_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","yakatiniyutuamɨkɨ kepaɨmemekɨ mu'inɨaritsie: »'Ukitsi xeitewiyari wiyari memexeiyatɨkatsie tsutɨtɨ haika tewiyari wiyari memexeiyatɨkatsie meye'atɨkaitɨ, mɨkɨ pɨtiyutuiyaka huta tewiyari heimana tamamata pɨrata tuminiyari, tukita keraye'akamekɨ memɨteyukutuaya hepaɨ. ");
INSERT INTO hch_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","»'Ukarawetsixi wahekɨ xeitewiyari heimana tamamata pɨrata tuminiyarikɨ. ");
INSERT INTO hch_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","»'Ukitsita 'auxɨwime wiyari memexeiyatɨkatsie tsutɨtɨ xeitewiyari wiyari memexeiyatɨkatsie meye'atɨkaitɨ, xeitewiyari tuminiyarikɨ mekateniyutuakakuni, yaxeikɨata tamamata tuminiyarikɨ pɨtiyutuiyaka 'ukarawetsixi mɨpaɨ paɨmeme wiyari memexeiyatɨka wahetsiemieme. ");
INSERT INTO hch_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","»'Ukitsi tɨɨrixi xeimetseri memexeiyatɨkatsie tsutɨtɨ 'auxɨwime wiyari memexeiyatɨkatsie meye'atɨkaitɨ, 'auxɨwime 'inɨariyarikɨ pɨtiyutuiyaka, meta haika 'inɨariyarikɨ katiniyutuiyakamɨkɨ 'ukari tɨɨrixi wahetsiemieme mɨpaɨ paɨmeme wiyari memexeiyatɨka. ");
INSERT INTO hch_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","»'Ukitsi 'ukirawetsixi haika tewiyari wiyari memɨhɨtɨka mautiyune tamamata heimana 'auxɨwime 'inɨariyarikɨ pɨtiyutuiyaka, meta tamamata 'inɨariyarikɨ 'ukarawetsixi mɨpaɨ paɨmeme wiyari memexeiyatɨka wahetsiemieme. ");
INSERT INTO hch_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","»Matsi kemɨ'ane kemutayɨkɨ 'imikieriyari mɨyetuani xɨka ka'i'axeni mɨtiyutuanikɨ kemɨraye'axe, mɨkɨ kaniyemieni mawari wewiwame hetsɨa mɨkɨ kananukahɨwiyariemɨkɨ, pɨtiyutuani xeikɨa kepaɨ mɨ'axeni. ");
INSERT INTO hch_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","»Matsi xɨka Yawé mawari mɨyetuiriyarieni tewa hɨkɨtɨni, mɨkɨ patsietɨ kaniyuhayewamɨkɨ Yawé mɨyetuiriyariekɨ. ");
INSERT INTO hch_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Pɨkayɨweni mipatakɨ xeime 'aixɨa 'anemekɨ xeime 'axa'anemekɨ, meta 'axamɨ'anekɨ xeime 'aixɨa 'anemekɨ. Xɨka xe'ipata xeimekɨ, mɨkɨ yuhutatɨ mepatsietɨ mekaniyuhayewakuni. ");
INSERT INTO hch_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","»Matsi xɨka Yawé mawari mɨyetuiriyarieni tewa hɨkɨtɨni mɨka'itiya, mɨkɨ mawari wewiwame hetsɨa kananuhaniemɨkɨ, ");
INSERT INTO hch_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","mɨkɨ yapɨtayɨni kemɨraye'akani. Kemɨtika'inɨatsieni mawari wewiwame kemutiu'inɨaritaxɨ kanitanaki'eriwamɨkɨ, tsepa kemɨ'aneni. ");
INSERT INTO hch_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Xɨka kutsiyarieya tiyutuamɨkɨ hutarieka minanenikɨ yutewa, mɨkɨ katiniyutuamɨkɨ 'auxɨwimeyaritsie mieme tawari xei'inɨariyari kaniyetuamɨkɨ tuminiyari mawari wewiwame kemɨtika'inɨatsirieni. ");
INSERT INTO hch_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","»Xɨka xewitɨ yukii Yawé yetuirieni, mawari wewiwame yakanitayɨmɨkɨ kemɨraye'aka. Mawari wewiwame kemɨtayɨni yapɨtika'inɨaritɨkani, tsepa kemɨtitita. ");
INSERT INTO hch_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","»Yukii Yawé mɨyetuiri mipatakɨ xɨka yukiikɨ tiyutuamɨkɨni, mɨkɨ 'auxɨwimeyaritsie mieme xei'inɨariyari tawari kaniyetuamɨkɨ mawari wewiwame kemɨti'inɨaritɨatsie, mɨkɨ kii 'ana piinieya kanayeimɨkɨ. ");
INSERT INTO hch_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","»Xɨka xewitɨ yukwie yetuani Yawé hetsiemieme, yakatini'inɨaritɨariemɨkɨ kepaɨmetɨ 'imɨariyari mɨtinakeni mana hetsiena mɨka'etsienikɨ, huta tewiyari heimana tamamata tuminiyari katinaye'akamɨkɨ, huta tsienituyari heimana xeitewiyari rituruyari tsewara 'imɨariyari tinaketɨ mɨka'etsieni xexuimetsie. ");
INSERT INTO hch_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Xɨka yukwie yetuani mematatuiwa wiyariyaritsie 'aye'ayu, kemɨtika'inɨari mɨpaɨ pɨraye'aka. ");
INSERT INTO hch_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Matsi xɨka 'arike 'iyetuirieni mematatuiwa wiyari 'anutiyayu, mawari wewiwame yakatinika'inɨaritamɨkɨ kepaɨmetɨ wiyari meuyewekani tawari mematatuiwa wiyari maye'anikɨ, mɨpaɨ paɨmemekɨ kananukaxɨriyariemɨkɨ. ");
INSERT INTO hch_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","»Kemɨ'ane yukwie mɨyetua Yawé hetsiemieme, xɨka yemekɨ 'inanaimɨkɨ hutarieka, 'auxɨwimeyaritsie mieme xei'inɨariyari tawari kaniyetuamɨkɨ mawari wewiwame kepaɨmeme mitaxatɨatsie, 'ana mɨkɨ tipiinieya kanayeimɨkɨ. ");
INSERT INTO hch_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Matsi xɨkari ka'inaneni yatɨni xeime 'utuirieni pɨkayɨweniri tawari hetsiena mieme mayanikɨ. ");
INSERT INTO hch_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Kepauka mematatuiwatsie mɨkɨ kwie mɨyetuiyanikekaitsie, mɨkɨ patsietɨ puyuhayewa Yawé hetsiemieme, mɨkɨ mawari wewiwame hetsiemieme payani. ");
INSERT INTO hch_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","»Xɨka xewitɨ kwie 'unaneni 'ahurawa 'iwaya kakwieyatɨkaku, meta Yawé hetsiemieme mayanikɨ 'iyetuani, ");
INSERT INTO hch_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","mawari wewiwame 'iti'inɨatame yakanitayɨmɨkɨ yamɨraye'akakɨ kepaɨmetɨ meuyewetse mematatuiwa wiyari maye'anikɨ. 'Ana kwitɨ yukwie mɨyetua kemɨraye'akani katiniyutuamɨkɨ, mɨkɨ Yawé hetsiemieme kanipatsieka. ");
INSERT INTO hch_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Mematatuiwatsie wiyari, kwie meripaitɨ memɨkutsiyarimamatɨkai hekwamekɨta kutsiyarimama mepakɨne. ");
INSERT INTO hch_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","»Naitɨ pɨti'inɨatsieni pɨrata tukita keraye'akamekɨ memɨteyukutuaya, tamamata kɨramuyari xeituminiyari rahetetɨ. ");
INSERT INTO hch_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","»Matsi, xewitɨ tɨma pɨkayɨweni matɨari mieme yutewa mɨyetuanikɨ, yuwakaxi yatɨni yumuxa, matɨari miemetexi Yawé hetsɨa memumiemetekɨ. ");
INSERT INTO hch_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Xɨka tewatsiekate memɨka'itiya mehɨkɨtɨni, pɨyɨweni mɨnanaiyanikɨ mawari wewiwame kemɨtiu'inɨaritaxɨ mɨpaɨ paɨmeme yetuame, matsi tawari 'auxɨwimeyaritsie mieme xei'inɨariyari kaniyetuamɨkɨ. Xɨka ka'inaneni mawari wewiwame kemɨti'inɨarita mɨpaɨ katinituiyamɨkɨ. ");
INSERT INTO hch_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","»Xewitɨ tɨma pɨkayɨweni yupiinitɨkai mɨtituanikɨ meta minanenikɨ, tsepa mɨtitewi, tewaxi yatɨni maku'etsakaitsie, xɨka pe'iyetuani Yawé hetsiemieme mɨrayanikɨ yuheyemekɨ. Naitɨ Yawé mɨtiyetuiriyarɨwa waɨkawa kanipatsieka Yawé hetsiemieme. ");
INSERT INTO hch_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Xewitɨ tewi mɨyetuiya pɨkayɨweni mɨnanaiyanikɨ, matsi mɨkɨ kanimieriemɨkɨ. ");
INSERT INTO hch_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","»Tamamatatsie mieme xeime naitɨ kwiepa mɨtiutixuawerixɨ, tsepa tita memɨte'uka'e 'uriyari ya'ikwaxi kɨyetsiemieme, Yawé hetsɨa katinimiemetɨni, mɨkɨ katiniyetuiriyarieka. ");
INSERT INTO hch_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Xɨka xewitɨ tamamatatsie mieme xeime yetuame 'inanaimɨkɨni, kemɨraye'aka kaninanaimɨkɨ matsi tawarita 'auxɨwimeyaritsie mieme xei'inɨariyari kaniyetuamɨkɨ. ");
INSERT INTO hch_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Tamamatatsie mieme xeime wakaxi meta muxa, tamamatatsie xewitɨ 'inɨaritɨ mɨkɨ kanipatsieka Yawé hetsiemieme. ");
INSERT INTO hch_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Tewaxi wahɨweme yɨkɨ pɨkatiwaxeiyani 'aixɨa memɨ'anene meta 'axamemɨ'anene, meta xeimekɨ pɨka'ipatani. Matsi xɨka xeimekɨ 'ipata yuhutatɨ mepatsietɨ mekanakɨnikuni meta pɨkayɨweniri minanenikɨ». ");
INSERT INTO hch_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","'Ikɨ 'aitsikate kanihɨkɨtɨni Yawé Muitsexi mɨyetuiri 'ixaheritsixi wahetsiemieme, Tsinahi yemuriyaritsie. ");
INSERT INTO hch_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Merikɨtsɨ Yawé Muitsexi kaniutahɨawe, 'ixuriki tukiyari manuwe, Tsinahi mɨrakutewa makumawetsie, mexɨakame tukaritsie hutarieka metseriyaritsie, kepauka 'ixaheritsixi 'Ekipitu memayewitɨkie huta wiyari 'anuyemiekakuri. Mɨpaɨ katinitahɨawe: ");
INSERT INTO hch_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","«Yunaime keniwaraka'utɨa mana kiekatari, 'Ixaheri xiɨyarimama meta nuiwarimama yuxexuitɨ kememɨyɨpapaɨme, yunaime 'ukitsi kememɨtetetewa xewaraka'utɨwatɨ yuxexuime. ");
INSERT INTO hch_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","'Ekɨ, 'Aruni hamatɨa xekaniwaraka'utɨakuni 'ixaheritsixi waniwema yunaime 'ukitsi kuyakɨ 'aixɨa memɨ'anene, xeitewiyari wiyari memɨhɨtɨka. ");
INSERT INTO hch_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","'Ikɨ xemɨwati'inɨatakɨ xeime xekanita'inikuni wa'ukiyari mɨkɨ yuxexuime wanuiwaritsie mieme manuyeka. ");
INSERT INTO hch_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","»'Ikɨ mekanihɨkɨtɨni kemɨ'ane memɨxeparewieni: Xuweni xiɨyarimama hetsiemiemete, 'Eritsuxi Tserehuxi nu'aya, ");
INSERT INTO hch_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","Tsimehuni xiɨyarimama, Tserumieri Tsuritsarahi nu'aya, ");
INSERT INTO hch_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","Kura xiɨyarimama, Nahatsuni 'Aminarawi nu'aya, ");
INSERT INTO hch_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","'Itsakaxi xiɨyarimama, Natanaheri Tsuhaxi nu'aya, ");
INSERT INTO hch_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Tsawuruni xiɨyarimama, 'Eriyawi Heruni nu'aya, ");
INSERT INTO hch_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Kutse nu'aya xiɨyarimama hetsiemiemete: 'Eritsama 'Amihuri nu'aya, 'Epɨrahini xiɨyarimama hetsiemiemete meta Manatsexi xiɨyarimama Kamarieri Peratsuxi nu'aya, ");
INSERT INTO hch_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Wenikamini xiɨyarimama hetsiemiemete, 'Awirani Kerehuni nu'aya, ");
INSERT INTO hch_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Rani xiɨyarimama, 'Akihetsexi 'Amitsarahi nu'aya, ");
INSERT INTO hch_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","'Atsexi xiɨyarimama, Pakieri 'Ukɨrani nu'aya, ");
INSERT INTO hch_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","Kahari xiɨyarimama hetsiemiemete, 'Eriyatsati Rehuheri nu'aya, ");
INSERT INTO hch_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","Nepɨtahari xiɨyarimama hetsiemiemete, 'Akira 'Enahani nu'aya». ");
INSERT INTO hch_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","'Ikɨ mekanihɨkɨtɨni kiekatari memanuyeyaxe, memaka'utɨarie nuiwarite kememɨtehɨkɨ meta kuyaxi 'Ixaheritsixi tewa'aitɨwamete. ");
INSERT INTO hch_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Hikɨ Muitsexi, 'Aruni hamatɨa 'ukitsi mekaniwarukuxeɨrieni memɨwaraka'utɨanikɨ kememɨtetetewatɨka memanayexeiyarie wahetsie, ");
INSERT INTO hch_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","hutarieka metseriyaritsie 'itsutɨakaku yunaime kiekatari mekaniwarukuxeɨrieni. Yuxexuitɨ mekanaka'utsieni hakewa memeyenunuiwaxɨ kemɨ'ane memɨtehaxiɨyari. 'Ana mekanaka'utuarieni yunaitɨ 'ukitsi xeitewiyari wiyari memexeiyatɨka, ");
INSERT INTO hch_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Muitsexi yakatinikayani, Yawé kemɨtita'aitɨakai. 'Ikɨ Muitsexi kaniwaraka'utɨani Tsinahi 'uyeikatɨ makumawatsie. ");
INSERT INTO hch_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Xuweni xiɨyarimama, 'Ixaheri matɨarieya, mekanaka'utsieni kemɨ'ane memutehaniwema meta memɨtehaxiɨyarima, kehepaɨ memɨte'ununuiwaxɨ. Yunaitɨ 'ukitsi xeitewiyari wiyari memɨhɨtɨka mekanaka'utɨarieni kuyaxikɨ 'aixɨa memɨ'anenekai memɨyɨwawe. ");
INSERT INTO hch_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Xuweni xiɨyarimama huta tewiyari heimana 'ataxewi miriyari heimana 'auxɨwi tsienituyari (46.500) 'ukitsi mekanakɨne. ");
INSERT INTO hch_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Tsimehuni xiɨyarimamata mekanaka'utsieni kemɨ'ane memutehaniwema meta kemɨ'ane memɨtehaxiɨyarima, kehepaɨ memɨte'ununuiwaxɨ. Yunaitɨ 'ukitsi xeitewiyari wiyari memɨhɨtɨka mekanaka'utɨarieni kuyakɨ 'aixɨa memɨ'anene. ");
INSERT INTO hch_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Tsimehuni xiɨyarimama huta tewiyari heimana tamamata heimana 'atanauka miriyari heimana haika tsienituyari (59.300) 'ukitsi mekanakɨne. ");
INSERT INTO hch_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Kahari xiɨyarimama mekanaka'utsieni kemɨ'ane memɨtehaniwema meta memɨtehaxiɨyarima, kehepaɨ memɨte'ununuiwaxɨ. Yunaitɨ 'ukitsi xeitewiyari wiyari memɨhɨtɨka mekanaka'utsieni kuyaxikɨ 'aixɨa memɨ'anenekai. ");
INSERT INTO hch_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Kahari xiɨyarimama huta tewiyari heimana 'auxɨwi miriyari heimana 'ataxewime tsienituyari heimana huta tewiyari heimana tamamata (45.650) 'ukitsi mekanakɨne. ");
INSERT INTO hch_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Kura xiɨyarimama mekanaka'utsieni kemɨ'ane memɨtehaniwema meta memɨtehaxiɨyarima, kehepaɨ memɨte'ununuiwaxɨ. Yunaitɨ 'ukitsi xeitewiyari wiyari memɨhɨtɨkatei mekanaka'utsieni kuyakɨ 'aixɨa memɨ'anene. ");
INSERT INTO hch_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Kura xiɨyarimama haika tewiyari heimana tamamata heimana nauka miriyari heimana 'ataxewime tsienituyari (74.600) 'ukitsi mekanakɨne. ");
INSERT INTO hch_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","'Itsakaxi xiɨyarimama mekanaka'utsieni kemɨ'ane memɨtehaniwema meta kemɨ'ane memɨtehaxiɨyarima, kehepaɨ memɨte'ununuiwaxɨ. Yunaitɨ 'ukitsi xeitewiyari wiyari memɨhɨtɨkatei mekanaka'utsieni kuyakɨ 'aixɨa memɨ'anene. ");
INSERT INTO hch_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","'Itsakaxi xiɨyarimama huta tewiyari heimana tamamata heimana nauka miriyari heimana nauka tsienituyari (54.400) 'ukitsi mekanakɨne. ");
INSERT INTO hch_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Tsawuruni xiɨyarimama mekanaka'utsieni kemɨ'ane memɨtehaniwema meta kemɨ'ane memɨtehaxiɨyarima, kehepaɨ memɨte'ununuiwaxɨ. Yunaitɨ 'ukitsi xeitewiyari wiyari memɨhɨtɨka mekanaka'utsieni kuyakɨ 'aixɨa memɨ'anene. ");
INSERT INTO hch_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Tsawuruni xiɨyarimama huta tewiyari heimana tamamata heimana 'atahuta miriyari heimana nauka tsienituyari (57.400) 'ukitsi mekanakɨne. ");
INSERT INTO hch_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Kutse xiɨyarimama: 'Epɨrahini xiɨyarimama mekana'utsieni kemɨ'ane memutehaniwema meta kemɨ'ane memɨtehaxiɨyarima, kehepaɨ memɨte'ununuiwaxɨ. Yunaitɨ 'ukitsi xeitewiyari wiyari memɨhɨtɨkatei mekanaka'utsieni kuyakɨ 'aixɨa memɨ'anene. ");
INSERT INTO hch_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","'Epɨrahini xiɨyarimama huta tewiyari miriyari heimana 'auxɨwime tsienituyari (40.500) 'ukitsi mekanakɨne. ");
INSERT INTO hch_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Manatsexi xiɨyarimamata mekanaka'utsieni kemɨ'ane memɨtehaniwema meta memɨtehaxiɨyarima, kehepaɨ memɨte'ununuiwaxɨ. Yunaitɨ 'ukitsi xeitewiyari wiyari memɨhɨtɨkatei mekanaka'utsieni kuyakɨ 'aixɨa memɨ'anene. ");
INSERT INTO hch_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Manatsexi xiɨyarimama xeitewiyari heimana tamamata heimana huta miriyari heimana huta tsienituyari (32.200) 'ukitsi mekanakɨne. ");
INSERT INTO hch_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Wenikamini xiɨyarimama mekanaka'utsieni kemɨ'ane memɨtehaniwema meta memɨtehaxiɨyarima, kehepaɨ memɨte'ununuiwaxɨ. Yunaitɨ 'ukitsi xeitewiyari wiyari memɨhɨtɨkatei mekanaka'utsieni kuyakɨ 'aixɨa memɨ'anene. ");
INSERT INTO hch_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Wenikamini xiɨyarimama xeitewiyari heimana tamamata heimana 'auxɨwi miriyari heimana nauka tsienituyari (35.400) 'ukitsi mekanakɨne. ");
INSERT INTO hch_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Rani xiɨyarimama mekanaka'utsieni kemɨ'ane memɨtehaniwema meta memɨtehaxiɨyarima, kehepaɨ memɨte'ununuiwaxɨ. Yunaitɨ 'ukitsi xeitewiyari wiyari memɨhɨtɨka mekanaka'utsieni kuyakɨ 'aixɨa memɨ'anene. ");
INSERT INTO hch_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Rani xiɨyarimama haika tewiyari heimana huta miriyari heimana 'atahuta tsienituyari (62.700) 'ukitsi mekanakɨne. ");
INSERT INTO hch_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","'Atsexi xiɨyarimamata mekanaka'utsieni kemɨ'ane memɨtehaniwema meta memɨtehaxiɨyarima, kehepaɨ memɨte'ununuiwaxɨ. Yunaitɨ 'ukitsi xeitewiyari wiyari memɨhɨtɨkatei mekanaka'utsieni kuyakɨ 'aixɨa memɨ'anene memɨkamama. ");
INSERT INTO hch_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","'Atsexi xiɨyarimama huta tewiyari heimana xewi miriyari heimana 'auxɨwime tsienituyari (41.500) 'ukitsi mekanakɨne. ");
INSERT INTO hch_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Nepɨtahari xiɨyarimama mekanaka'utsieni kemɨ'ane memutehaniwema meta memɨtehaxiɨyarima, kehepaɨ memɨte'ununuiwaxɨa. Yunaitɨ 'ukitsi xeitewiyari wiyari memɨhɨtɨka mekanaka'utsieni kuyakɨ 'aixɨa memɨ'anene. ");
INSERT INTO hch_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Nepɨtahari xiɨyarimama huta tewiyari heimana tamamata heimana haika miriyari heimana nauka tsienituyari (53.400) 'ukitsi mekanakɨne. ");
INSERT INTO hch_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Merikɨte 'ipaɨ yupaɨmetɨ mekanakɨne kepauka Muitsexi 'Aruni hamatɨa memɨwaraka'utɨatsie, mewaparewiekaku 'Ixaheri xiɨyarimama tamamata heimana huta meyupaɨmetɨ, mɨkɨ yuxexuitɨ yunuiwari hetsiemieme mekaniyɨakaitɨni. ");
INSERT INTO hch_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Yunaitɨ 'ixaheritsixi xeitewiyari wiyari memɨhɨtɨkatei, kuyakɨ 'aixɨa memɨ'anene mekanaka'utsieni, kememɨyupaɨmekai nuiwarite. ");
INSERT INTO hch_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Yunaitɨ 'ixaheritsixi memaka'utsie, 'ataxewime tsienituyari heimana haika miriyari heimana 'auxɨwime tsienituyari heimana huta tewiyari heimana tamamata (603.550) meyupaɨmetɨ mekanakɨne. ");
INSERT INTO hch_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Rewitsixi teɨteriyari mepɨkahaka'utɨarie hipame wahamatɨa, ");
INSERT INTO hch_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","matsi Yawé Muitsexi mɨpaɨ mɨtiutahɨawekaikɨ: ");
INSERT INTO hch_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","«Rewi xiɨyarimama pepɨkawaraka'utɨani, 'Ixaheri niwemama wahamatɨa memɨkayutinɨnɨwenikɨ. ");
INSERT INTO hch_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","'Aixɨa kaniyɨmɨkɨ, 'ekɨ pemɨwahɨritɨanikɨ tɨratu tukita mayeka hepaɨtsita meta naime hepaɨtsita ketipaɨmetɨ muwa mɨtiyepine kemɨtiyukumaɨwa. Rewitsixi Kakaɨyari tukieya mepɨ'ɨwiyani naime muwa mɨtiyepine. Yaxeikɨa yuheyemekɨ muyepatsietsie mekatene'uximayakakuni 'ahurawa memakuteitsie meheitayeme. ");
INSERT INTO hch_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Kepauka tukieya xemanukwenitsie rewitsixi xeikɨa mekanitaxɨnakuni, kepauka memeitawewienitsie mɨkɨ xeikɨa mekaneyɨakakuni. Kemɨ'ane 'ahurawa mauyani tukieya manuka kamawari wewiwametɨtɨ kanemɨmɨkɨ. ");
INSERT INTO hch_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Yunaitɨ 'ixaheri teɨteriyari yateewa mekanikuyaxixɨakuni yuxexuitɨ me'ukutetɨkaitɨ yupatera mehexeiyatɨkaitɨ kememɨteyunuiwari. ");
INSERT INTO hch_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Hikɨ rewitsixi tɨratu tukita manuka 'aurie mekanikuyaxikuni, 'Ixaheri kwieyaritsie xemɨnuakakɨ kepauka Kakaɨyari ha'atɨ wahetsie munuani. Merikɨ rewitsixi xeikɨa mekanihɨkɨtɨkakuni tɨratu tukita hepaɨtsita tehɨwemete». ");
INSERT INTO hch_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Hikɨ naimekɨ 'ixaheritsixi yamekatenikakɨne Yawé Muitsexi kemɨtiuta'aitɨa. ");
INSERT INTO hch_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Merikɨtsɨ Yawé Muitsexi 'Aruni mame mɨpaɨ katiniwarutahɨawe: ");
INSERT INTO hch_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","«'Ixaheritsixi 'ixuriki tukiyari manuwe memayutixexeɨriwa 'aurie mekanayaxetɨkɨnikuni yupatera mehexeiyatɨ meta yu'inɨari, hepana meheutanenieretɨ, yuxexuitɨ kememɨyupapaɨme nuiwarite. ");
INSERT INTO hch_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","»Tau manatineika 'aurie, mana mekanitiyaxikuni kemɨ'ane Kura memaweiya, kememɨyupapaɨme. Nahatsuni wa'ukiyari kanihɨkɨtɨni 'Aminarawi nu'aya. ");
INSERT INTO hch_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Yunaitɨ haika tewiyari heimana tamamata heimana nauka miriyari heimana 'ataxewime tsienituyari (74.600) 'ukitsi mekaniyupaɨmeni. ");
INSERT INTO hch_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","»Kura memakutei wa'aurie 'Itsakaxi xiɨyarimama mekanitiyaxikuni. Natanaheri wa'ukiyari kanihɨkɨtɨni Tsuhaxi nu'aya. ");
INSERT INTO hch_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Yunaitɨ huta tewiyari heimana tamamata heimana nauka miriyari heimana nauka tsienituyari (54.400) 'ukitsi mekaniyupaɨmeni. ");
INSERT INTO hch_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","»Tapa pɨtata Tsawuruni xiɨyarimama mekanikuyaxikuni. 'Eriyáwi wa'ukiyari kanihɨkɨtɨni Heruni nu'aya. ");
INSERT INTO hch_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Yunaitɨ huta tewiyari heimana tamamata heimana 'atahuta miriyari heimana nauka tsienituyari (57.400) 'ukitsi mekaniyupaɨmeni. ");
INSERT INTO hch_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","»Yunaitɨ Kura xiɨyarimama mekaniyupaɨmeni, xeitsienituyari heimana nauka tewiyari heimana 'ataxewi miriyari heimana nauka tsienituyari (186.400), mɨkɨ mekananuyeyaxikuni. ");
INSERT INTO hch_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","»Tatsutɨata Xuweni memaweiya yunaitɨ kememuyupaɨme yupatera hetɨa mana mekanitiyaxikuni, 'ikɨ yameyupaɨmetɨ. 'Eritsuxi wa'ukiyari kanihɨkɨtɨni Tserehuxi nu'aya. ");
INSERT INTO hch_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Yunaitɨ kuyaximama huta tewiyari heimana 'ataxewi miriyari heimana 'auxɨwime tsienituyari (46.500) 'ukitsi mekaniyupaɨmeni. ");
INSERT INTO hch_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","»Xuweni wa'aurie Tsimehuni xiɨyarimama mekanitiyaxikuni. Tserumieri wa'ukiyari katinitewaka Tsuritsarahi nu'aya. ");
INSERT INTO hch_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Yunaitɨ huta tewiyari heimana tamamata heimana 'atanauka miriyari heimana haika tsienituyari (59.300) 'ukitsi mekaniyupaɨmeni. ");
INSERT INTO hch_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","»Wa'aurieta mekanitiyaxikuni Kahari xiɨyarimama. 'Eriyatsati wa'ukiyari kanihɨkɨtɨni Xehueri nu'aya. ");
INSERT INTO hch_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Yunaitɨ huta tewiyari heimana 'auxɨwi miriyari heimana 'ataxewi tsienituyari heimana huta tewiyari heimana tamamata (45.650) 'ukitsi mekaniyupaɨmeni. ");
INSERT INTO hch_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","»Yunaitɨ Xuweni xiɨyarimama memakutei, me'inɨaritɨ kememuyupaɨme wanuiwarite, xeitsienituyari heimana huta tewiyari heimana tamamata heimana xewi miriyari heimana nauka tsienituyari heimana huta tewiyari heimana tamamata (151.450) 'ukitsi memuyupaɨme, mɨkɨ hutariekatsie memɨyehu. ");
INSERT INTO hch_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","»Merikɨte 'ixuriki tukiyari me'akwetɨ rewitsixi mekaniyekɨkakaɨtɨni yunaime wahixɨapa memukutei. Yaxeikɨa mekateniyaxikuni kehepaɨ memɨteheukutekai yuxexuitɨ yuhuyeripa meta yupatera me'akwetɨ. ");
INSERT INTO hch_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","»Tau makayuyuipiketsie yupatera hetɨa mekanitiyaxikuni 'Epɨrahini xiɨyarimama, kehepaɨ memɨteheukununuiwa. 'Eritsama wa'ukiyari kanihɨkɨtɨni 'Amihuri nu'aya. ");
INSERT INTO hch_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Kuyaximama nauka tewiyari miriyari heimana 'auxɨwime tsienituyari (40.500) 'ukitsi memuyupaɨme. ");
INSERT INTO hch_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","»'Epɨrahini 'aurieta mekanitiyaxikuni Manatsexi xiɨyarimama. Kamarieri wa'ukiyari kanihɨkɨtɨni Peratsuxi nu'aya. ");
INSERT INTO hch_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Kuyaximama xeitewiyari heimana tamamata heimana huta miriyari heimana huta tsienituyari (32.200) 'ukitsi mekaniyupaɨmeni. ");
INSERT INTO hch_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","»Xaɨtsieta mekanitiyaxikuni Wenikamini xiɨyarimama. 'Awirani wa'ukiyari mɨhɨkɨ Kerehuni nu'aya. ");
INSERT INTO hch_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Yunaitɨ xeitewiyari heimana tamamata heimana 'auxɨwi miriyari heimama nauka tsienituyari (35.400) 'ukitsi mekaniyupaɨmeni. ");
INSERT INTO hch_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","»Yunaitɨ kuyakɨ memɨyɨwawe 'Epɨrahini 'aurie memukutei, yunaitɨ me'inɨaritɨ yameyupapaɨmetɨ, xeitsienituyari heimana 'atahaika miriyari heimana xeitsienituyari (108.100) 'ukitsi, mɨkɨ mekaniyehuni hairiekatsie. ");
INSERT INTO hch_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","»Tayeta mekanitiyaxikuni Rani xiɨyarimama, kememɨyupaɨme. 'Akihetsexi wa'ukiyari kanihɨkɨtɨni 'Amitsarahi nu'aya. ");
INSERT INTO hch_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Mekaniyupaɨmeni yunaitɨ haika tewiyari heimana huta miriyari heimana 'atahuta tsienituyari (62.700) 'ukitsi. ");
INSERT INTO hch_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","»Rani 'aurieta 'Atsexi xiɨyarimama mekanitiyaxikuni. Pakieri wa'ukiyari mɨhɨkɨ 'Ukɨrani nu'aya. ");
INSERT INTO hch_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Yunaitɨ huta tewiyari heimana xewi miriyari heimana 'auxɨwi tsienituyari (41.500) 'ukitsi memɨhɨkɨ. ");
INSERT INTO hch_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","»Wa'auriepaita mekanikuyaxikuni Nepɨtahari xiɨyarimama. Wa'ukiyari pɨhɨkɨ 'Akira 'Enahani nu'aya. ");
INSERT INTO hch_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Yunaitɨ mekaniyupaɨmeni huta tewiyari heimana tamamata heimana haika miriyari heimana nauka tsienituyari (53.400) 'ukitsi. ");
INSERT INTO hch_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","»Yunaitɨ memuta'inierie kuyaxi Rani 'aurie mekanikuyaxe, yunaitɨ xeitsienituyari heimana huta tewiyari heimana tamamata heimana 'atahuta miriyari heimana 'ataxewime tsienituyari (157.600) 'ukitsi mekaniyutipaɨmere, mɨkɨ wa'utɨmake mekanayekɨnikuni yupatera me'akwetɨ». ");
INSERT INTO hch_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Merikɨte 'ikɨ mekanihɨkɨtɨni 'ixaheritsixi waniwema memaka'utɨarie kuyaxikɨ memɨyɨwawe kememɨyupapaɨmekai. Yunaitɨ Kuyaxi memuta'inierie yuxexuitɨ 'ataxewi tsienituyari heimana haika miriyari heimana 'auxɨwi tsienituyari heimana huta tewiyari heimana tamamata (603.550) 'ukitsi mekaniyutipaɨmere. ");
INSERT INTO hch_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Peru Rewitsixi hipame 'ixaheritsixi wamahatɨa mepɨka'utinɨitɨarie, Yawé Muitsexi kemutiuta'aitɨakai yapɨtiuyɨ. ");
INSERT INTO hch_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Hikɨ 'ixaheritsixi Yawé Muitsexi mɨpaɨ kemɨtiutahɨawekai yamekatenikakɨne: kememɨyupapaɨmekai 'axeikɨa mekanikuyaxikekaitɨni yupatera mehexeiyatɨkaitɨ meta memayekɨkakaitsie kememɨte'ununuiwaxɨ mɨpaɨ mekatenayekɨkakaitɨni 'iwamarixi xeinuiwaritetsie miemete. ");
INSERT INTO hch_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Merikɨte 'Aruni niwemama mɨpaɨ mekatenaka'utɨarieni Muitsexi hamatɨa, kepauka Yawé Muitsexi hamatɨa mɨtiutixa Tsinahi hɨriyaritsie. ");
INSERT INTO hch_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Mɨpaɨ mekatenaka'utɨarieni kememɨtetetewakai 'Aruni niwemama: Narawi matɨarimieme, 'Awihu, 'Eriyatsaxi meta 'Itamaxi 'imatɨreme. ");
INSERT INTO hch_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Mɨkɨ 'Aruni tɨɨriyamama memanayexeiyarie memɨpatsie mekanihɨkɨtɨni, mawari wewiwamete te'uximayatamete memakɨnekɨ. ");
INSERT INTO hch_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Narawi 'Awihu matɨari mekaniukwini Yawé hɨxie, kepauka makumawetsie Tsinahi mɨrakutewa memu'uwakai, mawari taiyariyari mekaniwaruwewirieni yakɨxeikɨa mɨhɨkɨ. Matsi Narawi 'Awihu hamatɨa tɨɨri memɨkawarayexeikɨ, 'Eriyatsaxi 'Itamaxi hamatɨa xeikɨa mekanimawari wewiwametetɨkaitɨni yupaapa tukarieya hepaɨtsita, 'Aruni hetsiemieme. ");
INSERT INTO hch_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Yawé Muitsexi mɨpaɨ katiniutahaɨwe: ");
INSERT INTO hch_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","«Rewi xiɨyarimama keniwawitɨmie 'Aruni hɨxie keniwati'uitɨa. Rewitsixi mekaniparewikuni mɨra'uximayatsie. ");
INSERT INTO hch_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","'Aruni kemɨtiyurienekai yamekateniyuriekakuni hetsiena mieme meta yunaitɨ mana kiekatari, mewahɨritɨatɨ memɨte'uximayakakɨ mɨkɨ 'ixuriki tukiyarita. ");
INSERT INTO hch_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Naime muwa mɨtiyepine 'ixuriki tukiyarita mekateni'ɨwiyakakuni, muwa mete'uximayatɨ 'ixaheritsixi, yamemɨteyuriekakɨ memɨte'uximayakakɨ meyɨhɨritatɨ 'ixuriki tukiyarita. ");
INSERT INTO hch_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","'Aruni, rewitsixi pekaniwahɨritɨamɨkɨ mɨtiwata'aitɨanikɨ meta waniwema. Mɨkɨ xeikɨa mekanihɨkɨtɨkakuni nehetsiemieme memɨte'uximayaka 'ixaheritsixi watsata. ");
INSERT INTO hch_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","'Aruni niwemama mawari wewiwametekɨ xeikɨa mekaniwaranayexeiyakuni. Kemɨ'ane kamawari wewiwametɨtɨ 'ixuriki tukiyarita mɨye'ani mɨkɨ kanimieriemɨkɨ kareuyehɨwiyarietɨ». ");
INSERT INTO hch_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Yawé Muitsexi mɨpaɨ katiniutahɨawe: ");
INSERT INTO hch_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","«Ne 'Ixaheritsixi wanuiwaritsie rewitsixi nekaniwaranuyexeiya, matɨari nunuiwakate wahepaɨ. Rewitsixi nehetsɨa miemete mekanihɨkɨtɨni, ");
INSERT INTO hch_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","matsi matɨari nunuiwakate nehetsɨa miemete memɨhɨkɨkɨ. Kepauka 'Ekipitu matɨari nunuiwakate nemɨwarutayuniyaxɨtsie, 'ana nekaniwarupata nehetsɨa memɨmiemetetɨnikɨ matɨari nunuiwakate 'ixaheritsixi teɨteriyari, teɨteri meta tewaxi. 'Ayumieme hikɨ nehetsɨa mekanimiemetetɨni. Ne Yawé nekanihɨkɨtɨni». ");
INSERT INTO hch_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Merikɨtsɨ Yawé Muitsexi mɨpaɨ katiniutahɨawe Tsinahi makumawetsie paitɨ: ");
INSERT INTO hch_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","«Rewi xiɨyarimama meta nuiwarimama kememɨyupapaɨme keniwaraka'utɨa, yunaime 'ukitsi xeimetseri memexeiyatɨka mana meutiyune». ");
INSERT INTO hch_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Hikɨ Muitsexi kanitsutɨani waraka'utɨwatɨ, Yawé kemɨrehɨawekai yakatinikayani. ");
INSERT INTO hch_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Rewi niwemama mepɨhɨkɨ: Keritsuni, Kuhati meta Merari. ");
INSERT INTO hch_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Keritsuni nuiwarimama memakɨ: Riwini hamatɨa Tsimi. ");
INSERT INTO hch_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Kuhatitsixi memɨhɨkɨtɨkai: 'Amirani, 'Itsaxi, Hewuruni meta 'Utsiheri. ");
INSERT INTO hch_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Merari nuiwarimama: Makiri meta Mutsihí. 'Ikɨ mekanihɨkɨtɨni rewitsixi wanuiwarima, memaka'utsie kememɨte'ununuiwaxɨ. ");
INSERT INTO hch_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Keritsuni hetsie memɨyenunuiwakai Riwini mekanihɨkɨtɨni Tsimi hamatɨa. 'Ikɨ kerutsunitsixi memɨwaraweiyakai mekanihɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Yunaime 'ukitsi xeimetseri memexeiyatɨka mana meutiyune, 'atahuta miriyari heimana 'auxɨwi tsienituyari (7.500) 'ukitsi meyupaɨmetɨ mekanakɨne. ");
INSERT INTO hch_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Keritsuni nuiwarimama memɨhɨkɨ tau manukayuyuipike 'aurie mekanikutekaitɨni tuki manuwe hetɨa. ");
INSERT INTO hch_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Keritsuni nuiwarimama wa'ukiyari 'Eriyatsati kanihɨkɨtɨkaitɨni Raheri nu'aya. ");
INSERT INTO hch_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","'Ixurikite tukiyari hetsiemieme, Keritsuni nuiwarimama mekanihɨritɨariekaitɨni tuki manukanakaikɨ mɨreutahakitɨretsie, nawi manukawere 'ixurikite heima, ");
INSERT INTO hch_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","'ixuriki kuraruyari takwa maka meta 'ixuriki meuwu kuraru kiteniyaritsie meta mawari taiyame warita makatei, yaxeikɨata tinaime kɨmana mɨrakuwɨwɨre memɨtekumaɨwakai. ");
INSERT INTO hch_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Kuhati hetsie mepɨyekɨ 'Amirani nuiwarimama, 'Itsaxi nuiwarimama, Hewuruni nuiwarimama meta 'Utsiheri nuiwarimama. 'Ikɨ Kuhati nuiwarimama mepɨhɨkɨtɨkai, ");
INSERT INTO hch_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","memɨte'uximayakai tukita. Yunaime 'ukitsi xeimetseri memexeiyatɨka mana meutiyune, 'atahaika miriyari heimana 'ataxewi tsienituyari (8.600) mekaniyupaɨmekaitɨni 'ukitsi. ");
INSERT INTO hch_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Kuhati memaweiyakai tuki manuwe tserieta mekanititekaitɨni. ");
INSERT INTO hch_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Kuhatitsixi kememɨyupaɨmekai 'Eritsapani wa'ukiyari kanihɨkɨtɨkaitɨni 'Utsiheri nu'aya. ");
INSERT INTO hch_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Mɨkɨ mekanihɨritɨariekaitɨni tukita kakuni, mexa, kɨxeme, mawari taiyameta, tukita mɨrayepine xakɨrɨte, watsute, 'itɨte mɨkɨ mepɨtekumaɨwa meta 'ixuriki waɨkawa muyepatsieta meuwɨkai, yaxeikɨa naime tita mɨreuyewekai memɨte'uximayakakɨ. ");
INSERT INTO hch_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Rewitsixi wa'ukiyari yemekɨ 'Eriyatsaxi kanihɨkɨtɨkaitɨni 'Aruni nu'aya mawari wewiwame, mɨkɨ mɨhɨritɨariekaikɨ tuki muyepatsieta mɨtiwa'aitɨakakɨ mɨwa'ukiyaritɨkaikɨ. ");
INSERT INTO hch_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Merari hetsɨa miemete Makiri hamatɨa Mutsihí mekanihɨkɨtɨni. 'Ikɨ mekanihɨkɨtɨni Meraritsixi nuiwarimama. ");
INSERT INTO hch_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Yunaime 'ukitsi xeimetseri memexeiyatɨka mana meutiyune, 'ataxewime miriyari heimana huta tsienituyari (6.200) meyupaɨmetɨ mekanakɨne 'ukitsi. ");
INSERT INTO hch_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Meraritsixi wa'ukiyari Tsurieri kanihɨkɨtɨkaitɨni 'Awikahiri nu'aya. Merari nuiwarimama tuki manuwe 'utata mekanikutekaitɨni. ");
INSERT INTO hch_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Mɨkɨ mekanihɨritɨariekaitɨni memɨtetimɨwanikɨ, tatsɨari tukitsie mɨranuyehipite, mexa hetsiena ma'uni, meta muka'utɨka meta tinaitɨ muwa mɨtiyepine mɨtiyukumaɨwa. ");
INSERT INTO hch_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","Yaxeikɨa kɨyexi muka'utɨka mekani'ɨwiyakaitɨni meta tekɨapai maheitɨkatei naime makuwutɨkatei kaunariyari. ");
INSERT INTO hch_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Muitsexi 'Aruni hamatɨa meta waniwema yunaitɨ 'ixuriki tukiyari hɨxie mekanititekaitɨni, tatsɨari tau manatineika 'aurie, 'ixuriki tukiyari memɨhɨritɨariekaikɨ 'ixaheritsixi wahetsiemieme memɨwayetuayanikɨ. Peru kemɨ'ane kamawari wewiwametɨtɨ mana 'ahurawa mɨye'ani, mɨkɨ mekanitakwikwiwakaitɨni. ");
INSERT INTO hch_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Muitsexi 'Aruni hamatɨa rewitsixi mekaniwaruka'utɨani Yawé kemɨtiwaruta'aitɨakai tiwarutaxatɨaka. Yunaitɨ rewitsixi xeimetseri memexeiyatɨka huteikɨ mautiyune mekanaka'utsieni, kememɨyupapaɨmekai mekaniuti'ani xeitewiyari heimana huta miriyari (22.000) meyupaɨmetɨ mekanakɨne 'ukitsi. ");
INSERT INTO hch_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Merikɨtsɨ Yawé Muitsexi mɨpaɨ katiniutahɨawe: «Keniwaruka'utɨa yunaime 'ixaheritsixi matɨari miemete 'ukitsi xeimetseri memexeiyatɨka mana meutiyune kememɨtetetewa pewaraka'utɨwatɨ. ");
INSERT INTO hch_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Yunaitɨ rewitsixi nehetsiemieme mepakɨne 'ixaheritsixi matɨari miemete wahetsiemieme, metatsiere rewitsixi watewama, 'ixaheritsixi watewama matɨari miemete wahetsiemieme. Ne Yawé nekanihɨkɨtɨni». ");
INSERT INTO hch_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Muitsexi 'ixaheritsixi kaniwaruka'utɨani matɨari miemete, Yawé kemɨtita'aitɨakai. ");
INSERT INTO hch_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Yunaitɨ me'inɨaritɨ 'ukitsi xeimetseri memexeiyatɨka mana meutiyune, mexɨakate memaka'utsiwakai kememɨtetetewa xeitewiyari heimana huta miriyari heimana huta tsienituyari heimana haika tewiyari heimana tamamata heimana haika (22.273) mekaniuyutipaɨmere 'ukitsi. ");
INSERT INTO hch_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Hikɨ Yawé Muitsexi mɨpaɨ katiniutahɨawe: ");
INSERT INTO hch_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","«Yunaitɨ rewitsixi nehetsiemieme mepakɨne 'ixaheritsixi matɨari miemete wahetsiemieme, metatsiere rewitsixi watewama, 'ixaheritsixi watewama matɨari miemete wahetsiemieme. Rewitsixi nehetsiemieme mepakɨne. Ne Yawé nekanihɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","»Para pemɨwatawikweitsitɨanikɨ huta tsienituyari heimana haika tewiyari heimana tamamata heimana haika (273) mexɨakate 'ixaheritsixi, rewitsixi memɨkayuwaɨkawakɨ, ");
INSERT INTO hch_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","pekaniyetuamɨkɨ 'auxɨwime tumini pɨrata raheteme yuxexuime wahetsiemieme, tukita mieme tumini kemɨrahete, tamamata heimana xewi kɨramuyari pɨrahete. ");
INSERT INTO hch_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Mɨkɨ tumini yunaime pekaniwayetuiriemɨkɨ 'Aruni meta niwemama, 'ixaheritsixi kepemɨtiwarutawikweitsitɨa memuti'inɨatsietsie memɨyumɨirekaikɨ». ");
INSERT INTO hch_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Hikɨ Muitsexi mɨkɨ tumini kananu'ɨni 'ixaheritsixi wahetsiemieme, rewitsixi memɨkayuwaɨkawakaikɨ. ");
INSERT INTO hch_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Kaniuku'ɨni, xeimiriyari heimana haika tsienituyari heimana haika tewiyari heimana 'auxɨwi (1.365) tumini pɨratayari, kemɨti'inɨatakai tumini tukita mieme. ");
INSERT INTO hch_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Hikɨ kaniyetuani mɨkɨ tumini 'Aruni hetsɨa meta niwemama wahetsɨa, yemekɨ Yawé kemɨtita'aitɨa. ");
INSERT INTO hch_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Merikɨte Yawé Muitsexi 'Aruni mame mɨpaɨ katiniwarutahɨawe: ");
INSERT INTO hch_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","«Rewitsixi xekeniwaraka'utɨa, Kuhati nuiwarimama meta hetsiena memɨyekɨ. ");
INSERT INTO hch_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Yunaime xekeniwaraka'utɨa xeitewiyari heimana tamamata wiyari huteikɨ meheutiyuneme, huta tewiyari heimana tamamata wiyari me'uti'akame 'ukitsi 'aixɨa memɨ'anene 'ixuriki tukiyarita memɨte'uximayakakɨ. ");
INSERT INTO hch_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","»Kuhatitsixi tehɨwemete mekanihɨtɨkakuni 'ixuriki tukita mɨtiyepine kwinimieme mɨtimaiwetɨka hepaɨtsita piinitɨarika. ");
INSERT INTO hch_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Kepauka 'ixaheritsixi memayekɨnetsie, 'Aruni yuniwematɨ 'ixuriki tukita mekaneutahaxɨakuni mekaneixɨnakuni 'ixuriki meuwie memeikunanikɨ kakuni tɨratuyari maukunakakɨ. ");
INSERT INTO hch_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","'Ariketa ketsɨ 'amɨpa nawiyarieya mekaneikunakuni meta tuwaxakɨ mɨyɨtsikimaɨye, kɨyexita mekananukutuakuni kɨmana memikukwetɨwenikɨ. ");
INSERT INTO hch_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","»Yawé hɨxie mexa muwe 'ixuriki mɨyɨtsikimaɨye mekananakawerakuni, mana mekatenapikuni xakɨrɨte, pateyute yakɨmɨpepe, tekɨxite, ye'ɨrɨte 'amɨnene kaxie winuyari mɨtiyeuriwa mawariyari yunɨkame. Yaxeikɨata paa mana kanamakamɨkɨ yuheyemekɨ mɨmawarie. ");
INSERT INTO hch_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Naime 'ikɨ wahetsie xekanenukawerakuni 'ixuriki mɨxetakɨ. Yaxeikɨa mexa ketsɨ 'amɨpa nawiyarieya xekanenukanakuni meta kɨyexita mekananukutuakuni kɨmana memikukwetɨwenikɨ. ");
INSERT INTO hch_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","»Xeime 'ixuriki mɨyɨtsikimaɨyekɨ kɨxeme 'uitɨwame meta kɨxemete, titɨkɨme, naxi yetsame meta naime tita mɨtiyukumaɨwa hatseitikɨ xekatenanukanakuni. ");
INSERT INTO hch_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Hikɨ xekanenukanakunita kɨxeme 'uitɨwame meta naime mana timieme ketsɨ 'amɨpa nawiyarieya, kaxetatsie xekaneikayekuni. ");
INSERT INTO hch_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","»Meta 'ixuriki mɨyɨtsikimaɨye, mɨratimawatɨre hurukɨ xeikɨa mɨwewiya xekanenukaweriekuni metatsiere ketsɨ 'amɨpa nawiyarieyakɨ, kɨyexita xekananukutuakuni kɨmana mukukweiyanenikɨ. ");
INSERT INTO hch_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","»Xekanita'eimakuni 'ixuriki mɨyɨtsikimaɨyekɨ naime tita mɨtiyukumaɨwa 'ixuriki tukita, heimana ketsɨ 'amɨpa nawiyarieyakɨ xekanikanakuni meta kɨyexitsie xekaniyehɨakuni manɨtɨkienikɨ. ");
INSERT INTO hch_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","»Mɨtiwatitaiyarɨwatsie naxi xekanewayewiwikuni, 'ana 'ixurikikɨ kwimɨxetakɨ xenita'eimakuni. ");
INSERT INTO hch_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Hetsiena xekatenikapikuni naime tita mana mɨtiyukumaɨwakai, tɨ muiname, tepɨa manɨxɨte, 'itɨ 'amɨpa, tekɨxite ye'ɨrɨte 'amɨnene, meta naime tita mana mɨtiyukumaɨwa. Hikɨ heimana ketsɨ 'amɨpa nawiyarieyakɨ xekanenuka'eimakuni meta kɨyexi xekananuye'uitɨakuni para mɨkutɨkienenikɨ. ");
INSERT INTO hch_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","»Kepauka 'Aruni yuniwema wahamatɨa memɨtinɨni mete'anukanarɨmatɨ naime, hikɨ 'anake 'ixaheritsixi mekaniyehuni. 'Ana kuhatitsixi mekanenɨtɨkuni tuki, perutsɨ meka'ikumaɨwatɨ nɨkahɨrixie me'ukwinikɨ. Yaxeikɨata muwa 'ixuriki tukita mɨrayepine mekatenanutɨkuni. ");
INSERT INTO hch_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","»Hikɨ, 'Eriyatsaxi 'Aruni nu'aya, kanihɨritɨariekamɨkɨ hatseiti kɨxeme hetsiemieme 'ɨkwa witsimu'ɨa meta tɨriku mawariyari hetsiemieme meta hatseiti mɨtiyupata. Metatsiere 'ixuriki tukita ti'ɨwiyame kanihɨkɨtɨkamɨkɨ meta naitɨ muwa mɨtiyepine». ");
INSERT INTO hch_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Yawé Muitsexi 'Aruni mame mɨpaɨ katiniwarutahɨawe: ");
INSERT INTO hch_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","«Kuhati hetsie memɨyekɨ xekeniwa'ɨwiyani para Rewi nuiwarimama memɨkaheuyewautsenikɨ. ");
INSERT INTO hch_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Kepauka 'ahurawa memɨkɨkanitsie mɨtimaiwetɨka hetsie, memɨkakukukuwenikɨ mɨpaɨ xekateniyuriekakuni: 'Aruni yuniwema wahamatɨa mekaniwaranayexeiyakuni, yuxexuime kememɨteyurieka meta memɨte'anɨtɨnikɨ. ");
INSERT INTO hch_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Peru kuhatitsixi mepɨkatetixexeiyani piinite mɨtimaiwetɨka 'etsiwa tɨma, kapa me'ukwinikɨ». ");
INSERT INTO hch_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Merikɨte Yawé Muitsexi 'Aruni mame mɨpaɨ katiniwarutahɨawe: ");
INSERT INTO hch_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","«Xekeniwaraka'utɨata Keritsuni nuiwarimama, wanuiwarima yunaime xewa'inɨatatɨ kememɨyupapaɨme. ");
INSERT INTO hch_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Yunaime xekeniwaraka'utɨa xeitewiyari heimana tamamata wiyari huteikɨ meheutiyuneme, huta tewiyari heimana tamamata wiyari me'uti'akame 'ukitsi 'aixɨa memɨ'anene 'ixuriki tukiyarita memɨte'uximayakakɨ. ");
INSERT INTO hch_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","»Keritsuni nuiwarimama tetɨkɨmete mehɨritɨarietɨ mekateni'uximayakakuni. ");
INSERT INTO hch_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","'Ixuriki tukiyaritsie timieme xepɨte'anutɨni, memayutixexeɨriwa heima manukawerire, ketsɨ 'amɨpa nawiyarieya manukawerire heimana meta 'ixuriki mɨrewatixaxatsiwa memanutakɨkatsie meuwie. ");
INSERT INTO hch_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","'Ixuriki kuraruyari takwa maka meta 'ixuriki meuwɨ kuraru kitenieyaritsie mepɨte'anutɨni meta takwa mieme maka, yaxeikɨata tinaime muwa mɨtiyukumaɨwa kɨmana mɨrakuwɨwɨre memɨtekumaɨwakai. ");
INSERT INTO hch_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","'Ikɨ naitɨ 'uximayatsika memɨte'anɨtɨnikɨ mɨtiyukumaɨwa, yatɨni 'ixuriki tukita xɨka meteta'uximayatakuni, 'Aruni meta niwemama wahetsɨa xeikɨa xekaniyɨwawekuni. Mɨkɨ xeikɨa yamehaitɨkaikaku pɨyɨweni mɨranutɨkieni. ");
INSERT INTO hch_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Kepauka memɨte'uximayaka Keritsuni nuiwarimama 'ixuriki tukiyari memayutixexeɨriwatsie, 'Itamaxi 'Aruni nu'aya mawari wewiwame kaniwataxeiyakamɨkɨ. ");
INSERT INTO hch_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","»Xekeniwaraka'utɨa Merari xiuyarimama, wanuiwarima yunaime xewa'inɨatatɨ kememɨyupapaɨme. ");
INSERT INTO hch_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Yunaime keniwaraka'utɨa xeitewiyari heimana tamamata wiyari memexeiyatɨka huteikɨ meutiyune meta huta tewiyari heimana tamamata wiyari me'uti'akame, 'ukitsi memɨyɨwawe 'ixuriki tukiyarita memɨte'uximayakakɨ. ");
INSERT INTO hch_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Mɨkɨ mekanihɨritɨariekaitɨni memɨtetimɨwanikɨ, tatsɨari tukitsie mɨranuyehipite, mexa hetsiena ma'uni, meta muka'utɨka meta tinaime muwa mɨtiyepine mɨtiyukumaɨwa, ");
INSERT INTO hch_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","yaxeikɨata takwa warita ma'utɨyeika, muka'uwe, manukuhipite meta kɨmana mahɨaretɨyeika naime tita mɨtiyɨkɨmaɨwa waɨkawa mɨreuyewetse. 'Ekɨ yapetiwakɨhɨawekaku kehepaɨ memɨteyurieka yuxexuitɨ tita memɨte'anutɨxɨani. ");
INSERT INTO hch_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Merari nuiwarimama memɨte'uximayakatsie 'ixuriki tukita memayutixexeɨriwatsie, 'Itamaxi waxexeiyame pɨhɨkɨtɨni mawari wewiwame 'Aruni nu'aya». ");
INSERT INTO hch_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Muitsexi 'Aruni hamatɨa meta 'ukirawetsixi memanuyetei, Kuhati nuiwarimama mekaniwaruti'inɨata kememɨyupapaɨme. ");
INSERT INTO hch_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","Mekanaka'utsieni yunaitɨ xeitewiyari heimana tamamata wiyari meutiyune meta huta tewiyari heimana tamamata wiyari me'uti'atɨ, 'aixɨa memɨ'anene 'ixuriki tukiyarita memɨte'uximayakakɨ. ");
INSERT INTO hch_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","Yunaitɨ me'inɨaritɨ mɨkɨ nuiwari mekanakɨne huta miriyari heimana 'atahuta tsienituyari heimana huta tewiyari heimana tamamata (2.750) 'ukitsi. ");
INSERT INTO hch_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Mɨpaɨ meyupaɨmetɨ mekanakɨne Kuhati nuiwarimama memɨte'uximayakakɨ 'ixuriki tukita, memɨwaruti'inɨataxɨ Muitsexi meta 'Aruni, Yawé kemɨtiwaruta'aitɨakai. ");
INSERT INTO hch_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Mekanaka'utsieni Keritsuni maremama kememɨyupapaɨmekai nuiwari. ");
INSERT INTO hch_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","Mekanaka'utsieni yunaitɨ xeitewiyari heima tamamata wiyari meheutiyunetɨ meta huta tewiyari heimana tamamata wiyari me'uti'atɨ 'aixɨa memɨ'anene 'ixuriki tukiyarita memɨte'uximayakakɨ. ");
INSERT INTO hch_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","Yunaitɨ me'inɨaritɨ mɨkɨ nuiwari mekanakɨne huta miriyari heimana 'ataxewime tsienituyari heimana xeitewiyari heimana tamamata (2.630) 'ukitsi. ");
INSERT INTO hch_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Mɨpaɨ yupaɨmetɨ mekanakɨne Keritsuni maremama 'ixuriki tukita memɨteta'uximayata, Muitsexi kememɨtewaruti'inɨataxɨ 'Aruni hamatɨa, Yawé kemɨtiwaruta'aitɨa. ");
INSERT INTO hch_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Merari xiɨyarimama mekanaka'utsieni kememɨyupapaɨmekai nuiwarite. ");
INSERT INTO hch_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","Yunaitɨ mekanaka'utsieni 'ukitsi xeitewiyari heimana tamamata wiyari meutiyune meta huta tewiyari heimana tamamata wiyari me'uti'atɨ, 'aixɨa memɨ'anene 'ixuriki tukiyarita memɨte'uximayakakɨ. ");
INSERT INTO hch_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","Yunaitɨ me'inɨaritɨ mekanakɨne haika miriyari heimana huta tsienituyari (3.200) 'ukitsi. ");
INSERT INTO hch_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Mɨpaɨ meyupaɨmetɨ mekanakɨne memaka'utsie Merari nuiwarimama, Muitsexi meta 'Aruni kememɨtewaraka'utɨa, Yawé kemɨtiwaru'aitɨakai. ");
INSERT INTO hch_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Muitsexi meta 'Aruni hamatɨa, meta memanuyetei 'ixaheritsixi mekaniwaruti'inɨata rewitsixi kehepaɨ memɨte'ununuiwaxɨ kemɨ'ane memɨtehanuiwari. ");
INSERT INTO hch_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","Yunaitɨri me'inɨaritɨ 'ukitsi xeitewiyari heimana tamamata mehautiyunetɨ meta huta tewiyari heimana tamamata me'uti'atɨ 'aixɨa memɨ'anene 'ixuriki tukiyarita memɨte'uximayakakɨ meta memɨte'anutɨnikɨ, ");
INSERT INTO hch_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","mekanakɨne 'atahaika miriyari heimana 'auxɨwime tsienituyari heimana nauka (8.580) tewiyari. ");
INSERT INTO hch_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Yawé, Muitsexi kemɨtiutahɨawixɨ, yuxexuitɨ yamekateniuta'aitɨarieni kememɨteyuriekakekai meta tita memɨte'utitɨkɨnikekai. Mɨpaɨ mekatenaka'utsieni Yawé Muitsexi kemɨtiuta'aitɨakai. ");
INSERT INTO hch_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Hikɨ Yawé Muitsexi mɨpaɨ katiniutahɨawe: ");
INSERT INTO hch_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","«'Ixaheritsixi mɨpaɨ ketiniwaruta'aitɨa kemɨ'ane kati'itiyakame mɨtimayɨani haiya yunawiyaritsie memexeiyatɨka yuhetsɨa memɨwarayenɨ'anikɨ, yatɨni timɨkime mɨtiumayɨani, yatɨni mikumayɨa xeime pɨniya 'uhanitsitɨakame. ");
INSERT INTO hch_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Tsepanetɨ 'ukitsi meta memɨ'ukari, xemakuteitsie pekaniwarayenɨ'amɨkɨ, para memɨkaxewiriekakɨ mana xemakuteitsie xeme neteɨterima». ");
INSERT INTO hch_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Hikɨ mɨpaɨ mekateniuyurieni 'ixaheritsixi memakuteitsie mekaniwarayenɨ'ani, Yawé Muitsexi kemɨrehɨawekai ti'aitɨatɨ. ");
INSERT INTO hch_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Yawé Muitsexi mɨpaɨ katiniuta'aitɨani ");
INSERT INTO hch_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","'ixaheritsixi mɨpaɨ mɨtiwatahɨawekɨ: «Kemɨ'ane 'uki yatɨni 'uka, yu'iwa 'axamuyuri yatɨni mɨtinawatsiri, ne Yawé nehɨxie 'axakatiniuyurieni 'ayumieme yukɨmana katinayukatuamɨkɨ. ");
INSERT INTO hch_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Kaniyutahekɨatamɨkɨ ke'axamɨtiuyuri, meta katinekapitɨamɨkɨ kemɨ'ane 'axamuyuri 'auxɨwimexɨa 'anamanekame kaniyetuiriemɨkɨ. ");
INSERT INTO hch_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Peru xɨka mɨyamɨranuyetɨa 'iwamama me'umaweni, mɨtiyetuiyani Yawé hetsiemieme katinayeimɨkɨ mawari wewiwame katiniyetuiriyariemɨkɨ, muxa 'uki heutinɨkame mɨtimawarienikɨ 'axamɨtiuyurikɨ. ");
INSERT INTO hch_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Naitɨ mawari 'ixaheritsixi memiyetuaya mawari wewiwame hetsɨa mɨkɨ hetsiena mieme katinihɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Kemɨ'ane yɨkɨmana mɨtiupata mɨkɨ katinihetsienamiemeyaritɨni, peru mawari wewiwame tita mutiyetuiriyarɨwa katinipiinieyatɨni». ");
INSERT INTO hch_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Yawé Muitsexi mɨpaɨ katiniuta'aitɨani ");
INSERT INTO hch_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","'ixaheritsixi mɨpaɨ mɨtiwatahɨawekɨ: «'Inɨarikɨ tetekuxatatɨ, xewitɨ 'uka 'aixɨa tiwikietɨtɨ xaɨtsie kaneukuyune yɨkɨna 'aixɨa 'iyari kapawitɨkɨkai ");
INSERT INTO hch_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","xeime hamatɨa hunetɨ, 'inɨarikɨ tetekuxatatɨ kename kahahekɨa mɨyamɨyɨane, mɨkɨ 'awie mukahuikɨ, meta xewitɨ mɨkarakumatekɨ memɨka'uxeiyariekɨ mɨpaɨmeyɨatɨ. ");
INSERT INTO hch_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","Xɨka kɨnaya 'ɨtetsarikaya hetsiena ye'ani mɨpaɨ retimani kename 'ɨyaya mayɨiya, tsepa mɨka'ukumayɨiya, ");
INSERT INTO hch_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","hikɨ nenuwitɨmɨkɨ mawari wewiwame hetsɨa, harina tsewarayari huta kiruyari kanitimawamɨkɨ hetsienamieme. Mawarika hetsie hatseiti pɨkaheutitu'ani meta 'ɨkwa witsimu'ɨa, 'ɨtetsarika hetsiemieme mɨtiyɨanekɨ, hatsi mawarikayari 'axamɨti'ane mɨtihekɨarekɨ. ");
INSERT INTO hch_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","»Mawari wewiwame Yawé hɨxie 'ukaratsi kananuwitɨmɨkɨ, ");
INSERT INTO hch_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","haa mɨpatsie tekɨxita kaniukatuamɨkɨ, 'etsiwata kwie kaniukawiwimɨkɨ tukita mieme. ");
INSERT INTO hch_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Hikɨ Yawé hɨxie kanenuwitɨmɨkɨ, kɨpaya kanikuxɨnamɨkɨ, 'iyaritɨarika mawariyari katinipitɨamɨkɨ, mawari wewiwame mexi tekɨxi 'ahana 'axamɨ'ane matsiwi muyema. ");
INSERT INTO hch_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Hikɨ mawari wewiwame 'uka yurikɨ mɨpaɨ katinitahɨawimɨkɨ: “Xɨka 'akɨna matsi'awitɨkɨkaku xeime hamatɨa pekakahuiweni, xɨka 'axamɨ'ane peka'anukuweiyaweni, 'ikɨ haa matsiwi 'axamɨ'itɨarie 'atsipɨkamatsiyurieni. ");
INSERT INTO hch_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Peru xɨka 'akɨna pehexeiyatɨtɨ pe'iku'eirieni, 'axapekani'ayurieni 'akɨmana xeime pɨta hamatɨa 'uki pehuimɨtɨ ");
INSERT INTO hch_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","—'ena mawari wewiwame 'ukaratsi yurikɨ yakatinitahɨawimɨkɨ—, Yawé, 'ahetsie 'axamɨti'ane ke'ukawiwieni kemaine 'ahetsiemieme, pekaniweweme kematsi'ayeitɨani, 'aniweyame ke'utahani. ");
INSERT INTO hch_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Kepauka 'ikɨ haa pemanuhareni, 'ahuka ke'utahairiya, pekaniweweme kematsi'ayeitɨani”. 'Ukaratsi mɨpaɨ ke'utayɨni: “'Aixɨa pɨ'ane. Mɨpaɨ ketiɨyɨni kemɨtinake”. ");
INSERT INTO hch_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","»Mawari wewiwame 'ikɨ 'axamɨ'ane xapatsie kaneka'utɨamɨkɨ, haa matsiwi 'ukaratsi menuhareni 'aixɨa katiniyurimɨkɨ. ");
INSERT INTO hch_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Hikɨ 'ukaratsi haa matsiwi kana'itɨamɨkɨ hetsiena mɨkayunekɨ waɨkawa mɨtikwinitɨanikɨ. ");
INSERT INTO hch_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","»Mawari wewiwame mawarika katinanupimɨkɨ 'ɨtetsarika hetsiemieme. Katinitimawamɨkɨ Yawé hɨxie mawari matitaiyarɨwatsie, ");
INSERT INTO hch_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","xeimamayari kananatitɨkimɨkɨ hatsi mititaiyakɨ mawari taiyametsie Yawé me'eriwanikɨ. 'Anakeri 'ukaratsi haa kananu'itɨamɨkɨ. ");
INSERT INTO hch_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Kepauka mɨkɨ haa manuhareni 'axamɨ'itɨarie, xɨka yukɨna 'aixɨa 'iyari kahawitɨkɨkaitɨni, hukaya kanitahaimɨkɨ kaniwewetɨ kanayeimɨkɨ. Mɨpaɨ mɨkɨ katinikwinitɨariemɨkɨ hipame wahɨxie. ");
INSERT INTO hch_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Xɨkata hawaikɨ mɨpaɨ ka'utiyɨni, xɨka 'aixɨa tiuyeikakaitɨni, 'ana mɨkɨ 'atsipɨkayɨni, tiniweyatɨ kanayeimɨkɨ. ");
INSERT INTO hch_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","»'Ikɨ 'inɨari kanihɨkɨtɨni 'ɨtetsarika hetsiemieme, kepauka 'ukaratsi yukɨna mɨnanaimani, 'axakaniyuyurimɨkɨ yɨkɨmana xeime hamatɨa pɨta mɨkahuikɨ, ");
INSERT INTO hch_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","kepauka kɨnaya 'ɨtetsarika hexeiyatɨ mayani meta yu'ɨya mɨtixeɨmani. Mawari wewiwame 'ukaratsi Yawé hɨxie 'enuwitɨme 'ikɨ 'inɨari kaniwewiriemɨkɨ kemɨre'uxa. ");
INSERT INTO hch_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Kɨnaya tixaɨtɨ hetsiena pɨkarahɨiyani, 'ukaratsi hɨrixɨa tiuka'eniwatɨ kanayeimɨkɨ mɨya mɨtiuyurikɨ». ");
INSERT INTO hch_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Yawé Muitsexi katiniuta'aitɨani ");
INSERT INTO hch_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","'ixaheritsixi mɨpaɨ mɨtiwatahɨawekɨ: «Xɨka xewitɨ 'uki yatɨni 'ukaratsi natsareyukɨ yɨhɨritɨamɨkɨni, Yawé hɨxie yake'utayɨni, ");
INSERT INTO hch_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","mɨkɨ kaxie winuyari pɨkaye'eni matsiwi meta kwinimieme mɨratsiwi. Meta hipame winu, kaxie hayari, kaxie takariyari mɨpatsarutsietɨka pɨkakwa'ani. ");
INSERT INTO hch_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Mexi kexemɨte'uxa 'areutewini natsareyu hepaɨ, kaxie takariyari xepɨkakwa'ani meta kararayari hatsiyari nitɨma. ");
INSERT INTO hch_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","»Mexi 'areutewini Yawé hetsiemieme patsietɨ, tatsɨari natsareyu hepaɨ pɨtimatsiɨkɨni, yaxeikɨata pɨka'ikaxikani yukɨpa matsi kanihayewakamɨkɨ mɨtiwawerekɨ meta puyukweriwayurieka 'itiyatɨ. ");
INSERT INTO hch_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","»Kepauka mɨpaɨ 'anetɨ muyeikani Yawé hɨxie, mɨki manukatsie 'ahurawa pɨka'uyeikani, ");
INSERT INTO hch_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","tsepa paapaya, maamaya, mutaya, kurieya memukwi. Mɨkɨ wahekɨ ka'iyatɨ pɨkahayuyeitɨwani, matsi mɨpaɨ pɨkayɨaneni Yawé 'inɨarieya mexeiyakɨ yumu'utsie. ");
INSERT INTO hch_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Kepauka patsietɨ 'amuyeikani Yawé hetsiemieme, yu'itietɨ kaniuyeikamɨkɨ patsietɨ. ");
INSERT INTO hch_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","»Xɨka 'atsikara'eriwakaku xewitɨ 'auriena 'umɨni, yumu'utsie kemɨtipatsiekai mɨpaɨ ka'anetɨ kanayeimɨkɨ, 'atahuta tukari heutineyu, kepauka mɨ'itiyanitsie, 'ana naime yumu'utsie kaniyukaximɨkɨ. ");
INSERT INTO hch_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","'Atahaika tukari heutineyu yuhutame kukuruxi kaniwaranɨtɨkimɨkɨ yatɨni haɨmɨxi, mawari wewiwame kaniyetuiriemɨkɨ 'ixuriki tukiyari mɨranutahakitɨretsie muka memayutixexeɨriwatsie. ");
INSERT INTO hch_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Mɨkɨ xeime mawari wewiwame kanitimawamɨkɨ 'itiya mawariyari meta hipame mawari taiyariyari mɨhɨkɨtɨnikɨ. 'Ana mawari wewiwame natsareyu patsiekame kaneyeitɨamɨkɨ, 'ikɨ 'axamɨtiuyurikɨ mɨki 'umayɨaka. 'Ana mɨkɨ tukaritsie natsareyu pɨ'itiyani yumu'utsie, ");
INSERT INTO hch_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","'axakemɨtiyurienekai natsareyu Yawé hɨxie 'aixɨa pɨyɨyuriekai muxatsi warehapanatɨ xeiwiyari mehɨtɨkaime mawariwewietɨ mɨkɨkɨ mɨreuyehɨwiyariekakɨ. 'Ayumieme pɨkanaki'eriwani meripai mieme matsi puhayewariekairi 'aixɨa mɨka'uyuyurikɨ mana pɨtiuyu'a. ");
INSERT INTO hch_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","»'Ikɨ 'inɨari natsareyu hetsiemieme kanihɨkɨtɨni kepauka manutinetɨarieni patsietɨ. Nanuwitɨkiemɨkɨ tuki kitenieyaritsie, ");
INSERT INTO hch_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","mana katinitimawamɨkɨ kanitataiyamɨkɨ muxa Yawé hetsiemieme xeiwiyari hɨkame katikuyeme, meta xeime muxa 'ukitɨme 'itiya mawariyari mayanikɨ, meta 'aixɨa memɨteyuxeiyanikɨ mawariyari. ");
INSERT INTO hch_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","Meta kanitimawamɨkɨ xeitsikɨiwitiyari paa mɨkakuxanariyarietɨka, meta tɨriku mɨtɨxiyari 'aixɨa mɨ'ane pɨhɨkɨtɨni wiyamatɨkaitɨ, tsuiraxi kakuxanariyarietɨkaime wiyamatɨkaime xeikɨa meta hatsite mawariyari, metatsiere kaxie winuyari mɨtiyeuriwa yɨnɨkame. ");
INSERT INTO hch_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","»Hikɨ mawari wewiwame Yawé hɨxie kanitimawamɨkɨ, mawarika mɨreuyehɨwiyarienikɨ, mawarika taiyariyari natsareyu hetsiemieme. ");
INSERT INTO hch_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Muxa 'uki kanitimawamɨkɨ Yawé hetsiemieme 'aixɨa memɨteyuxeiyanikɨ mawariyari mayanikɨ, paa xeitsikɨiwitiyari hamatɨa. Meta hatsite kanitimawamɨkɨ metatsiere kaxie winuyari mɨtiyeuriwa yɨnɨkame. ");
INSERT INTO hch_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","»Hikɨ tuki kitenie memayutixexeɨriwatsie natsareyu kaniyukaximɨkɨ yumu'utsie. Yukɨpa mupatsietɨka, taipa kaneuwiwimɨkɨ 'aixɨa memɨteyuxeiyanikɨ mawariyari mataiyarietsie. ");
INSERT INTO hch_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","»'Ariri natsareyu yukaxiyu, mawari wewiwame paa kananatituimɨkɨ tsikɨiwititsie mɨkakuxanariyarie meta muxa 'uki naiparieya, mɨkɨ naime natsareyu katinipitɨamɨkɨ, ");
INSERT INTO hch_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","'anaketa naime Yawé hɨxie pekaniyuitɨwamɨkɨ mawarika hepaɨ. Naitɨ katinipatsieka mawari wewiwame hetsiemieme katinihɨkɨtɨni, naitɨ tawitsiemieme, teurite kɨmana mɨrayukatuiya. Mɨpaɨ tiyurieme naime natsareyu winu manu'ieni kaniyɨweni. ");
INSERT INTO hch_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","»'Ikɨ 'inɨari kani'ayumiemetɨni kemɨ'ane natsareyukɨ mɨyɨhɨritɨani. 'Ikɨ naime mawarika katiniwewimɨkɨ Yawé hetsiemieme natsareyu hetsiemieme meta kaniyɨweni tita mɨtiyetuani ketita mɨrexeiyani. 'Inɨari kemaine natsareyu hetsiemieme, xɨka natsareyu yuyeitɨamɨkɨni kaneye'atɨamɨkɨ kemaine». ");
INSERT INTO hch_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Yawé Muitsexi mɨpaɨ katiniuta'aitɨani: ");
INSERT INTO hch_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","«Mɨpaɨ ketiniwarutahɨawi 'Aruni meta niwemama, 'ixaheritsixi 'aixɨa memɨwayuriekakɨ 'ikɨ niukikɨ: ");
INSERT INTO hch_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","»“Yawé kematsi'ɨwiyani 'ahamatɨa ke'uyeikani, ");
INSERT INTO hch_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Yawé 'aixɨa kematixeiyani yunaki'eriya kematsipitɨaka, ");
INSERT INTO hch_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Yawé kematsiparewieka kayuwatɨ kematsipitɨaka”. ");
INSERT INTO hch_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","»Mɨpaɨ xeputiyuaneni kenemɨtitewa 'ixaheritsixi watsata, yurikɨ ne neheyemekɨ nemɨxe'ɨwiyanikɨ». ");
INSERT INTO hch_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Muitsexi kepauka tuki munɨ, 'aixɨa kaniyurieni naime katiniuti'ɨya hatseitikɨ muwa mɨtiyepine. Metatsiere mawari taiyame 'aixɨa kaniuyurieni meta naime muwa mɨrakapine. ");
INSERT INTO hch_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Hikɨ 'Ixaheri nuiwarimamatsie yuxexuime memanuyetei, memɨwaruka'utɨakai, kememɨteyɨwawe mekateniyetuani wanuiwarima yunaitɨ mɨkɨ 'imikierite. ");
INSERT INTO hch_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Tukita paitɨ mekatenetɨni Yawé hɨxie memɨteheyetuanikɨ. Yuhuhutakatɨ memanuyetei xeikaxetayaritsie mekatenetɨni, yuxexuitɨta tuurutsixi mekaniwayetuaxɨani, yunaitɨ 'ataxewi kaxetate 'anukanatɨkaitɨ meta tamamata heimana huta tuurutsixi mekanakɨne. ");
INSERT INTO hch_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Yawé Muitsexi mɨpaɨ katiniutahɨawe: ");
INSERT INTO hch_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","«'Ikɨ mawarite 'ahetsie katinimiemetɨni memɨmeteyetuiriwa 'ahetsie ketinehɨka, mɨtikumayɨiyanikɨ mɨtiwakumayɨiwatsie 'ixuriki tukiyari hetsiemieme. 'Ekɨ rewitsixi pekaniwayetuiriemɨkɨ, yuxexuitɨ kememɨte'uximaya 'uximayatsika hepaɨtsita». ");
INSERT INTO hch_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Hikɨ Muitsexi kaxetate meta tuurutsixi katiniyetuiriyarieni, mɨkɨta rewitsixi kaniwayetuirieni. ");
INSERT INTO hch_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Keritsuni nuiwarimama hutame kaxetate mekaniuhapatɨarieni meta yunaukame tuurutsixi, memɨtehauyehɨakaikɨ yu'uximayatsika hepaɨtsita. ");
INSERT INTO hch_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Meraritsixi yunaukame kaxetate mekaniuhapatɨarieni meta tuurutsixi 'atahaikame, mɨreuyewekaikɨ wa'uximayatsikatsie. 'Aruni mawari wewiwame nu'aya 'Itamaxi yunaime mɨkɨ katiniwa'aitɨakaitɨni. ");
INSERT INTO hch_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Kuhatitsixi tixaɨtɨ mepɨkateyetuiriyarie, mɨkɨ memɨhɨritɨariekaikɨ memɨteheutɨtɨkanikɨ yuwaritsie piinite naime mɨti'itiyatɨka. ");
INSERT INTO hch_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Kepauka mawari taiyame 'aixɨa mu'itɨarie, 'ixaheritsixi wa'ukiyarima mawari muwa mekaniyetuani, ");
INSERT INTO hch_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Yawé Muitsexi mɨpaɨ mɨtikɨhɨawekaikɨ: «Mawari memɨyetuayanikɨ mawari taiyame hetsiemieme, yuxexuitɨ wa'ukiyarima xexuime tukaritsie mekateniyuriekakuni». ");
INSERT INTO hch_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Mexɨakame tukaritsie mɨtitimawakɨ Nahatsuni kananayexeiyarieni 'Aminarawi nu'aya, Kura xiɨyarieya. ");
INSERT INTO hch_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","'Ikɨ hatsite 'imikieriyari, pɨrata xakɨyari 'amatikuni katiniyetuani meta xeime pɨrata pateyuyari, mɨkɨtsie tɨriku mɨtɨxiyari 'aixɨa mɨ'ane pɨhɨpɨnekai hatseitikɨ pɨnariekame. Kemɨti'inɨatakai tuki xakɨ 'amatikuni xeikiruyari heimana 'imeriyu katinahetekaitɨni meta pateyu 'atahaika tsienituyari kɨramuyari rahetetɨ. ");
INSERT INTO hch_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","Meta xeime pateyu yakɨmɨpe hurukɨ mɨwewiya kaniyetuani, xeitsienituyari heimana tamamata kɨramuyari katinahetekaitɨni, 'ɨkwa witsimu'ɨa hɨneme. ");
INSERT INTO hch_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","Mawari taiyariyari hetsiemieme, tsikeru xeiwiyari hɨkame kaniyetuani, xeime muxa 'uki meta xeime muxa xeiwiyari hɨkame. ");
INSERT INTO hch_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","Mɨreuyehɨwiyarienikɨ, xeime tsipu 'ukitɨme kaniyetuani mawari mayanikɨ. ");
INSERT INTO hch_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","'Aixɨa memɨteyuxeiyanikɨ mawariyari, yuhutame tuurutsixi kaniwayetuani, yu'aɨxɨwimeta muxatsi 'ukitsi, meyu'aɨxɨwime tsipuri 'ukitsi meta meyu'aɨxɨwime muxatsi xeiwiyari memɨhɨtɨka. Nahatsuni 'Aminarawi nu'aya 'ikɨ mawarikaya kanihɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Hutarieka tukaritsie Natanaheri Tsuhaxi nu'aya mawari mɨwewienikɨ kananayexeiyarieni, 'Itsakaxi xiɨyarieya wa'ukiyari. ");
INSERT INTO hch_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Hatsite mɨtitimawarienikɨ, katiniyetuani pɨrata xakɨ 'amatikuni meta pɨrata pateyuyari hɨpɨneme tɨriku mɨtɨxiyari 'aixɨa mɨ'ane pɨnarietɨ hatseitikɨ. Kemɨti'inɨatakai tuki, xakɨ 'amatikuni xeikiruyari heimana 'imeriyu katinahetekaitɨni, meta pateyu 'atahaika tsienituyari kɨramuyari katinahetekaitɨni. ");
INSERT INTO hch_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","Metatsiere xeime pateyu yakɨmɨpe hurukɨ mɨwewiya kaniyetuani xeitsienituyari heimana tamamata kɨramuyari raheteme, 'ɨkwa witsimu'ɨa hɨneme. ");
INSERT INTO hch_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","Mawari taiyariyari hetsiemieme, tsikeru xeime kaniyetuani, xeimeta muxa 'uki meta muxa xeiwiyari hɨkame. ");
INSERT INTO hch_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","'Itiya mawariyari hetsiemieme, xeime tsipu 'ukitɨme kaniyetuani. ");
INSERT INTO hch_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","'Aixɨa memɨteyuxeiyanikɨ mawariyari, yuhutame tuurutsixi kaniwayetuani, meta yu'aɨxɨwime muxatsi 'ukitsi kaniwayetuani, yu'auxɨwimeta tsipuri 'ukitsi meta yu'aɨxɨwime muxatsi xeiwiyari memɨhɨtɨka kaniwayetuani. 'Ikɨ Natanaheri mawarieya kanayani Tsuhaxi nu'aya. ");
INSERT INTO hch_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Hairieka tukaritsie 'Eriyáwi Heruni nu'aya kananayexeiyarieni mɨtitimawakɨ, Tsawuruni xiɨyarimama wa'ukiyari. ");
INSERT INTO hch_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Hatsite mɨtitimawakɨ, katiniyetuani pɨrata xakɨyari 'amatikuni meta xeime pɨrata pateyuyari, hɨneme tɨriku mɨtɨxiyari 'aixɨa mɨ'ane hatseitikɨ pɨnariekame. Kemɨti'inɨatakai tuki xakɨ 'amatikuni xeikiruyari heimana 'imeriyu katinahetekaitɨni, meta pateyu 'atahaika tsienituyari kɨramuyari katinahetekaitɨni. ");
INSERT INTO hch_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","Metatsiere xeime pateyu yakɨmɨpe hurukɨ mɨwewiya kaniyetuani, xeitsienituyari heimana tamamata kɨramuyari katinahetekaitɨni, 'ɨkwa witsimu'ɨa hɨneme. ");
INSERT INTO hch_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","Mawari taiyariyari hetsiemieme, xeime tsikeru kaniyetuani, xeimeta muxa 'ukitɨme meta xeime muxa xeiwiyari hɨkame. ");
INSERT INTO hch_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","'Itiya mawariyari hetsiemieme, xeime tsipu 'uki kaniyetuani. ");
INSERT INTO hch_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","'Aixɨa memɨteyuxeiyanikɨ mawariyari, yuhutame tuurutsixi kaniwayetuani, yu'aɨxɨwime muxatsi 'ukitsi, yu'auxɨwimeta tsipuri 'ukitsi meta meyu'auxɨwime muxatsi xeiwiyari mehɨtɨkaime kaniwayetuani. 'Ikɨ 'Eriyáwi mawarikaya kanihɨkɨtɨni Heruni nu'aya. ");
INSERT INTO hch_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Naurieka tukaritsie 'Eritsuxi kananayexeiyarieni mutitimawakɨ Tserehuxi nu'aya, Xuweni xiɨyarimama wa'ukiyari. ");
INSERT INTO hch_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Hatsite mawariyari, pɨrata xakɨyari 'amatikuni kaniyetuani meta xeime pɨrata pateyuyari, hɨpɨneme tɨriku mɨtɨxiyari hatseitikɨ pɨnariekame. Kemɨti'inɨatakai tuki, xakɨ 'amatikuni xeikiruyari heimana 'imeriyu katinahetekaitɨni, meta pateyu 'atahaika tsienituyari kɨramuyari katinahetekaitɨni. ");
INSERT INTO hch_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","Meta xeime pateyu yakɨmɨpe hurukɨ mɨwewiya kaniyetuani, xeitsienituyari heimana tamamata kɨramuyari raheteme, 'ɨkwa witsimu'ɨa hɨneme. ");
INSERT INTO hch_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","Mawari taiyariyari hetsiemieme, tsikeru xeime kaniyetuani, xeimeta muxa 'uki meta xeime muxa xeiwiyari hɨkame. ");
INSERT INTO hch_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","'Itiya mawariyari hetsiemieme, xeime tsipu 'ukitɨme kaniyetuani. ");
INSERT INTO hch_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","'Aixɨa memɨteyuxeiyanikɨ mawariyari hetsiemieme, yuhutame tuurutsixi kaniwayetuani, meta yu'aɨxɨwime muxatsi 'ukitsi meta yu'aɨxɨwime tsipuri 'ukitsi meta meyu'aɨxɨwime muxatsi xeiwiyari mehɨtɨkaime kaniwayetuani. 'Eritsuxi Tserehuxi nu'aya 'ikɨ mawarieya kanihɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","'Auxɨwirieka tukariyaritsie kananayexeiyarieni Tserumieri Tsuritsarahi nu'aya mɨtitimawakɨ, Tsimehuni xiɨyarimama wa'ukiyari. ");
INSERT INTO hch_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Hatsite mawariyari, xeime pɨrata xakɨyari 'amanukuyewa kaniyetuani meta xeime pɨrata pateyuyari, hɨpɨneme tɨriku mɨtɨxiyari hatseitikɨ pɨnariekame. Kemɨti'inɨatakai tuki, xakɨ 'amatikuni xeikiruyari heimana 'imeriyu katinahetekaitɨni, meta pateyu 'atahaika tsienituyari kɨramuyari katinahetekaitɨni. ");
INSERT INTO hch_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","Meta xeime pateyu yakɨmɨpe hurukɨ wewiyakame kaniyetuani, xeitsienituyari heimana tamamata kɨramuyari katinahetekaitɨni, 'ɨkwa witsimu'ɨa hɨneme. ");
INSERT INTO hch_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","Mawari taiyariyari hetsiemieme, tsikeru xeime kaniyetuani, xeime muxa 'uki meta xeime muxa xeiwiyari hɨkame. ");
INSERT INTO hch_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","'Itiya mawariyari hetsiemieme, xeime tsipu 'ukitɨme kaniyetuani. ");
INSERT INTO hch_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","'Aixɨa memɨteyuxeiyanikɨ mawariyari hetsiemieme, yuhutame tuurutsixi kaniwayetuani, yu'aɨxɨwimeta muxatsi 'ukitsi, meta yu'aɨxɨwime tsipuri 'ukitsi meta muxatsi meyu'aɨxɨwime xeiwiyari mehɨtɨkaime. 'Ikɨ kanihɨkɨtɨtɨni Tserumieri mawarikaya Tsuritsarahi nu'aya. ");
INSERT INTO hch_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","'Ataxewirieka tukaritsie kananayexeiyarieni 'Eriyatsati Rehuheri nu'aya mɨtitimawakɨ, Kahari xiɨyarimama wa'ukiyari. ");
INSERT INTO hch_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Hatsite mawariyarikɨ, pɨrata xakɨyari 'amanukuyewa meta xeime pɨrata pateyuyari kaniyetuani, hɨpɨneme tɨriku mɨtɨxiyari 'aixɨa mɨ'ane hatseitikɨ pɨnariekame katiniyetuani. Kemɨti'inɨatakai tuki, xakɨ 'amatikuni xeikiruyari heimana 'imeriyu katinahetekaitɨni, pateyuta 'atahaika tsienituyari kɨramuyari katinahetekaitɨni. ");
INSERT INTO hch_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","Meta xeime pateyu yakɨmɨpe hurukɨ wewiyakame kaniyetuani, xeitsienituyari heimana tamamata kɨramuyari raheteme, 'ɨkwa witsimu'ɨa hɨneme. ");
INSERT INTO hch_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","Mawari taiyariyari hetsiemieme, tsikeru xeime kaniyetuani, meta muxa 'uki meta xeime muxa xeiwiyari hɨkame kaniyetuani. ");
INSERT INTO hch_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","'Itiya mawariyari hetsiemieme, xeime tsipu 'ukitɨme kaniyetuani. ");
INSERT INTO hch_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","'Aixɨa memɨteyuxeiyanikɨ mawariyari hetsiemieme, yuhutame tuurutsixi, yu'aɨxɨwimeta muxatsi 'ukitsi, meta meyu'aɨxɨwime tsipuri 'ukitsi meta meyu'aɨxɨwime muxatsi xeiwiyari memɨhɨtɨka. 'Ikɨ kanihɨkɨtɨni 'Eriyatsati mawarikaya Rehuheri nu'aya. ");
INSERT INTO hch_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","'Atahutarieka tukaritsie kananayexeiyarieni 'Eritsama mɨtitimawakɨ 'Amihuri nu'aya, 'Epɨrahini nuiwarimama wa'ukiyari. ");
INSERT INTO hch_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Hatsite mawariyarikɨ, xeime pɨrata xakɨyari 'amakuni meta xeime pɨrata pateyuyari katiniyetuani, hɨpɨneme tɨriku mɨtɨxiyari 'aixɨa mɨ'ane hatseitikɨ pɨnarietɨ. Kemɨti'inɨatakai tuki, pateyu xeikiruyari heimana 'imeriyu katinahetekaitɨni, meta xakɨ 'amakuni 'atahaika tsienituyari kɨramuyari pɨrahetekai meta pateyu 'atahaika tsienituyari kɨramuyari raheteme. ");
INSERT INTO hch_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","Meta xeime pateyu yakɨmɨpe hurukɨ wewiyakame kaniyetuani, xeitsienituyari heimana tamamata kɨramuyari katinahetekaitɨni, 'ɨkwa witsimu'ɨa hɨneme. ");
INSERT INTO hch_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","Mawari taiyariyari hetsiemieme, tsikeru xeime kaniyetuani, xeime muxa 'uki meta xeime muxa xeiwiyari hɨkame kaniyetuani. ");
INSERT INTO hch_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","'Itiya mawariyari hetsiemieme, xeime tsipu 'uki kaniyetuani. ");
INSERT INTO hch_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","'Aixɨa memɨteyuxeiyanikɨ mawariyari hetsiemieme, yuhutame tuurutsixi, meta yu'aɨxɨwime muxatsi 'ukitsi, meyu'aɨxɨwime tsipuri 'ukitsi meta meyu'aɨxɨwime muxatsi xeiwiyari mehɨtɨkaime kaniwayetuani. 'Ikɨ kanihɨkɨtɨni 'Eritsama mawarikaya 'Amihuri nu'aya. ");
INSERT INTO hch_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","'Atahairieka tukaritsie kananayexeiyarieni Kamarieri mɨtitimawakɨ Peratsuxi nu'aya, Manatsexi nuiwarimama wa'ukiyari. ");
INSERT INTO hch_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Hatsite mawariyari, xeime pɨrata xakɨyari 'amakuni meta xeime pɨrata pateyuyari katiniyetuani, hɨpɨneme tɨriku mɨtɨxiyari 'aixɨa mɨ'ane hatseitikɨ pɨnariekame. Kemɨti'inɨatakai tuki, xakɨ 'amakuni xeikiruyari heimana 'imeriyu katinahetekaitɨni, pateyuta 'atahaika tsienituyari kɨramuyari katinahetekaitɨni. ");
INSERT INTO hch_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","Meta xeime pateyu yakɨmɨpe hurukɨ wewiyakame kaniyetuani, xeitsienituyari heimana tamamata kɨramuyari katinahetekaitɨni, 'ɨkwa witsimu'ɨa hɨneme. ");
INSERT INTO hch_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","Mawari taiyariyari hetsiemieme, tsikeru xeime, xeime muxa 'uki meta xeime muxa xeiwiyari hɨkame. ");
INSERT INTO hch_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","'Itiya mawariyari hetsiemieme, xeime tsipu 'uki kaniyetuani. ");
INSERT INTO hch_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","'Aixɨa memɨteyuxeiyanikɨ mawariyari hetsiemieme, yuhutame tuurutsixi kaniwayetuani, yu'aɨxɨwime muxatsi 'ukitsi, meyu'aɨxɨwimeta tsipuri 'ukitsi meta meyu'aɨxɨwime muxatsi xeiwiyari mehɨtɨkaime kaniwayetuani. 'Ikɨ kanihɨkɨtɨni Kamarieri mawarikaya Peratsuxi nu'aya. ");
INSERT INTO hch_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","'Atanaurieka tukarietsie kananayexeiyarieni 'Awirani mɨtitimawakɨ Kereuni nu'aya, Wenikamini nuiwarimama wa'ukiyari. ");
INSERT INTO hch_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Hatsite mawariyari, xeime pɨrata xakɨyari 'amakuni meta xeime pɨrata pateyuyari katiniyetuani, hɨpɨneme tɨriku mɨtɨxiyari 'aixɨa mɨ'ane hatseitikɨ pɨnariekame. Kemɨti'inɨatakai tuki, xakɨ 'amakuni xeikiruyari heimana 'imeriyu katinahetekaitɨni, meta pateyu 'atahaika tsienituyari kɨramuyari raheteme. ");
INSERT INTO hch_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","Meta xeime pateyu yakɨmɨpe hurukɨ wewiyakame kaniyetuani, xeitsienituyari heimana tamamata kɨramuyari raheteme, 'ɨkwa witsimu'ɨa hɨneme. ");
INSERT INTO hch_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","Mawari taiyariyari hetsiemieme, tsikeru xeime, xeime muxa 'uki xeimeta muxa xeiwiyari hɨkame kaniwayetuani. ");
INSERT INTO hch_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","'Itiya mawariyari hetsiemieme, xeime tsipu 'uki kaniyetuani. ");
INSERT INTO hch_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","'Aixɨa memɨteyuxeiyanikɨ mawariyari hetsiemieme, tuurutsixi yuhutame kaniwayetuani, yu'aɨxɨwime muxatsi 'ukitsi, meyu'aɨxɨwime tsipuri 'ukitsi meta meyu'aɨxɨwime muxatsi xeiwiyari mehɨtɨkaime kaniwayetuani. 'Ikɨ kanihɨkɨtɨni 'Awirani mawarikaya, Kereuni nu'aya. ");
INSERT INTO hch_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Tamamata tukaritsie kananayexeiyarieni 'Akihetsexi mɨtitimawakɨ 'Amitsarahi nu'aya, Rani nuiwarimama wa'ukiyari. ");
INSERT INTO hch_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Hatsite mawariyari, xeime pɨrata xakɨyari 'amatikuni meta xeime pɨrata pateyuyari, hɨpɨneme tɨriku mɨtɨxiyari 'aixɨa mɨ'ane hatseitikɨ pɨnariekame. Kemɨti'inɨatakai tuki, xakɨ 'amatikuni xeikiruyari heimana 'imeriyu raheteme, meta pateyu 'atahaika tsienituyari kɨramuyari raheteme. ");
INSERT INTO hch_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","Meta xeime pateyu yakɨmɨpe hurukɨ wewiyakame kaniyetuani, xeitsienituyari heimana tamamata kɨramuyari raheteme, 'ɨkwa witsimu'ɨa hɨneme. ");
INSERT INTO hch_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","Mawari taiyariyari hetsiemieme, xeime tsikeru, xeime muxa 'uki meta xeime muxa xeiwiyari hɨkame kaniwayetuani. ");
INSERT INTO hch_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","'Itiya mawariyari hetsiemieme, xeime tsipu 'uki kaniyetuani. ");
INSERT INTO hch_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","'Aixɨa memɨteyuxeiyanikɨ mawariyari hetsiemieme, yuhutame tuurutsixi, yu'aɨxɨwime muxatsi 'ukitsi, meyu'aɨxɨwimeta tsipuri 'ukitsi meta meyu'aɨxɨwime muxatsi xeiwiyari mehɨtɨkaime. 'Ikɨ kanihɨkɨtɨni 'Akihetsexi mawarikaya 'Amitsarahi nu'aya. ");
INSERT INTO hch_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Tamamata heimana xewi tukariyaritsie kananayexeiyarieni Pakieri mɨtitimawakɨ 'Ukɨrani nu'aya, 'Atsexi nuiwarimama wa'ukiyari. ");
INSERT INTO hch_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Hatsite mawariyari, xeime pɨrata xakɨyari 'amakuni meta xeime pɨrata pateyuyari katiniyetuani, hɨpɨneme tɨriku mɨtɨxiyari 'aixɨa mɨ'ane hatseitikɨ pɨnariekame. Tuki kemɨti'inɨatakai, xakɨ 'amakuni xeikiruyari heimana 'imeriyu katinahetekaitɨni, meta pateyu 'atahaika tsienituyari kɨramuyari raheteme. ");
INSERT INTO hch_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","Meta xeime pateyu yakɨmɨpe hurukɨ wewiyakame kaniyetuani, xeitsienituyari heimana tamamata kɨramuyari raheteme, 'ɨkwa witsimu'ɨa hɨneme. ");
INSERT INTO hch_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","Mawari taiyariyari hetsiemieme, tsikeru xeime, xeimeta muxa 'uki, meta xeime muxa xeiwiyari mehɨtɨkaime kaniwayetuani. ");
INSERT INTO hch_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","'Itiya mawariyari hetsiemieme xeime tsipu 'uki kaniyetuani. ");
INSERT INTO hch_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","'Aixɨa memɨteyuxeiyanikɨ mawariyari hetsiemieme, yuhutame tuurutsixi kaniwayetuani, yu'aɨxɨwime muxatsi 'ukitsi, meyu'aɨxɨwimeta tsipuri 'ukitsi meta meyu'aɨxɨwime muxatsi xeiwiyari memɨhɨtɨka. 'Ikɨ Pakieri 'Ukɨrani nu'aya mawarikaya kanihɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Tamamata heimana huta tukaritsie kananayexeiyarieni, 'Akira mɨtitimawakɨ 'Enahani nu'aya, Nepɨtahari nuiwarimama wa'ukiyari. ");
INSERT INTO hch_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Hatsite mawariyari, xeime pɨrata xakɨyari 'amakuni meta xeime pɨrata pateyuyari katiniyetuani, hɨpɨneme tɨriku mɨtɨxiyari 'aixɨa mɨ'ane hatseitikɨ pɨnariekame. Tuki kemɨti'inɨatakai, xakɨ 'amakuni xeikiruyari heimana 'imeriyu raheteme, meta pateyu 'atahaika tsienituyari kɨramuyari raheteme. ");
INSERT INTO hch_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","Meta xeime pateyu yakɨmɨpe hurukɨ wewiyakame kaniyetuani, xeitsienituyari heimana tamamata kɨramuyari raheteme, 'ɨkwa witsimu'ɨa hɨneme. ");
INSERT INTO hch_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","Mawari taiyariyari hetsiemieme, xeime tsikeru, xeimeta muxa 'ukitɨme meta xeime muxa xeiwiyari hɨkame kaniwayetuani. ");
INSERT INTO hch_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","'Itiya mawariyari hetsiemieme, xeime tsipu 'uki kaniyetuani. ");
INSERT INTO hch_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","'Aixɨa memɨteyuxeiyanikɨ mawariyari hetsiemieme, yuhutame tuurutsixi kaniwayetuani, yu'aɨxɨwimeta muxatsi 'ukitsi, meyu'aɨxɨwimeta tsipuri 'ukitsi meta meyu'aɨxɨwime muxatsi xeiwiyari mehɨtɨkaime. 'Ikɨ 'Akira 'Enahani nu'aya mawarikaya kanihɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Mawarika mɨtiyetuiya 'ixaheritsixi wa'ukiyarima memuwewi kepauka mawari taiyame 'aixɨa mu'itɨarie, 'ikɨ katiniyetuiyani: Tamamata heimana huta pɨrata xakɨyari 'amɨpapa, tamamata heimana huta pɨrata pateyuyari meta tamamata heimana huta pateyu yakɨmɨpepe hurukɨ mɨwewiyatɨka. ");
INSERT INTO hch_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Pɨrata xakɨyari 'amɨpapa xeikiruyari heimana 'imeriyu pɨrahetekai, meta pateyute 'atahaika tsienituyari kɨramuyari pɨrahetekai. Naitɨ pɨratakɨ mɨtiwewiyatɨka xeitewiyari heimana 'atahuta kiruyari katinahetekaitɨni, tuki kemɨti'inɨatakai. ");
INSERT INTO hch_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Tamamata heimana huta pateyute yakɨmɨpepe hurukɨ mɨwewiyatɨka, 'ɨkwa witsimu'ɨa hɨpɨneme xeitsienituyari heimana tamamata kɨramuyari katinahetekaitɨni, tuki kemɨti'inɨatakai. Naitɨ pateyute yakɨmɨpepe hurukɨ muwewiyatɨka xeikiruyari heimana nauka tsienituyari kɨramuyari katinahetekaitɨni. ");
INSERT INTO hch_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Tewaxi mawari taiyariyari hetsiemieme tamamata heimana huta tsikerutsixi, tamamata heimana huta muxatsi 'ukitsi, tamamata heimana huta muxatsi xeiwiyari memɨhɨtɨka, meta tamamata heimana huta tsipuri 'ukitsi mekanakɨne 'itiya mawariyari hetsiemieme, meta hatsite mawariyari. ");
INSERT INTO hch_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Tewaxi 'aixɨa memɨteyuxeiyanikɨ mawariyari hetsiemieme xeitewiyari heimana nauka tuurutsixi mepakɨ, meta haika tewiyari muxatsi 'ukitsi meta tsipuri 'ukitsi haika tewiyari, meta haika tewiyari muxatsi xeiwiyari memɨhɨtɨka. 'Ikɨ mawarika kanayani kepauka mawari taiyame 'aixɨa memuyuritsie. ");
INSERT INTO hch_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Muitsexi kepauka 'ixuriki tukiyarita meutaha, Yawé hamatɨa mɨtitaxatakɨ, mana tɨratu kakuniyari heima Kakaɨyari teɨtametemama memana'utsie kanitahɨawe. ");
INSERT INTO hch_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Yawé Muitsexi mɨpaɨ katiniutahɨawe: ");
INSERT INTO hch_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","«'Aruni mɨpaɨ ketineutahɨawi: “Kepauka 'atahutame kɨxemete tatɨkaime pemanu'uitɨani, mɨkɨ kɨxeme 'uitɨwame hɨxie kanihekɨariwiekamɨkɨ”». ");
INSERT INTO hch_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","'Aruni mɨpaɨ katiniuyurieni. Kɨxeme tatɨkaime 'atahutame kananu'uitɨani kɨxeme 'uitɨwame hɨxie maukakɨxenikɨ, Yawé Muitsexi kemɨtita'aitɨa. ");
INSERT INTO hch_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Kɨxeme 'uitɨwame tsutɨmeyaritɨa meta tuturiyari titsunamekɨ pɨwewiyakai naitɨ mɨkɨ huru xeikɨa pɨhɨkɨtɨkai, matsi Yawé Muitsexi mɨpaɨ mɨtiutahekɨatɨakɨ. ");
INSERT INTO hch_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Merikɨte Yawé Muitsexi mɨpaɨ katiniutahɨawe: ");
INSERT INTO hch_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","«Rewitsixi keniwaruta'inieka 'ixaheritsixi watsata, keniwaru'iti. ");
INSERT INTO hch_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Memɨ'itiyanikɨ, haa mɨ'itiyakɨ keniwaruhatuiya, mɨpaɨ ketiniwarutahɨawi naime memɨyukaxinikɨ meta yukamixate memɨteti'ekwakɨ. Mɨpaɨ 'aixɨa me'itɨarietɨ mekanakɨnikuni. ");
INSERT INTO hch_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Hikɨ xeime tsikeru meta tɨriku mɨtɨxiyari 'aixɨa mɨ'ane hatseitikɨ pɨnariekame xekateniyetuakuni mawari mayanikɨ. 'Ekɨta xeime 'ahetsiemieme pekaniyetuamɨkɨ 'itiya mawariyari mayanikɨ. ");
INSERT INTO hch_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Rewitsixi 'ixuriki tukiyari manuwetsie paitɨ pekaniwaranuwitɨmɨkɨ meta yunaime 'ixaheritsixi pekaniwakuxeɨrimɨkɨ. ");
INSERT INTO hch_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Yawé hɨxie rewitsixi pekaniwataxatamɨkɨ meta 'ixaheritsixi wahetsie mekaniutimeikuni. ");
INSERT INTO hch_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Hikɨ 'Aruni Yawé hɨxie rewitsixi kaniwayetuamɨkɨ, 'ixaheritsixi wahetsiemieme mawari teikɨ hetserarietɨ 'uyuitɨariwatɨ mayanikɨ. Mɨpaɨ me'itɨarieme Yawé hetsiemieme te'uximayatamete mekanakɨnikɨni. ");
INSERT INTO hch_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","»Rewitsixi yumamakɨ tsikerutsixi wahetsie mekaneutimeikuni, 'ekɨta pemɨwaxɨnakɨ wahetsiemieme xeime keneutimawa memɨ'itiyanikɨ, xeimeta Yawé hetsiemieme pekanitataiyamɨkɨ. ");
INSERT INTO hch_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Hikɨ rewitsixi 'Aruni hɨxie mekaniti'uikuni meta niwemama wahɨxie, Yawé hetsɨa pekaniwayetuamɨkɨ mawari teikɨ hetserarietɨ muyuitɨariwa mayanikɨ. ");
INSERT INTO hch_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Mɨpaɨ pekatiniwapatamɨkɨ 'ixaheritsixi watsata, rewitsixi nehetsiemiemete memakɨnekɨ. ");
INSERT INTO hch_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","»Hikɨ rewitsixi pewa'itieyu, mawari muyuitɨariwa hepaɨ, mɨkɨ tukita mekatenita'uximayatakuni. ");
INSERT INTO hch_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","'Ixaheritsixi watsata xewitɨ pumawe, mɨkɨ xeikɨa nehetsiemiemete mekanihɨkɨtɨkakuni, mɨkɨ xeikɨa nepɨwaranuyexei. Matɨarixi 'ixaheritsixi waniwema, nekaniwarupata nehetsiemieme. ");
INSERT INTO hch_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Nehetsiemiemete memɨhɨkɨkɨ matɨari nunuiwakate 'ixaheritsixi waniwema, tsepa tewi mɨtihɨkɨ yatɨni tewa mɨtihɨkɨ. Nehetsiemieme nekaniwarayeitɨani kepauka 'ekipitutari waniwema matɨari miemete nemɨtiwarukwinitɨatsie. ");
INSERT INTO hch_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Hikɨ rewitsixi nekaniwaranayexeiya 'ixaheritsixi waniwema matɨari miemete wahetsiemieme, ");
INSERT INTO hch_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","'Aruni meta niwemama, nekaniwayetuirieni 'imikieri hepaɨ. Rewitsixi pɨta mekateni'uximayakakuni 'ixuriki tukiyarita, 'ixaheritsixi wahetsiemieme memɨwaxɨnakɨ, memɨkatekwinitɨariekakɨ 'axame'itɨarietɨ tuki 'aurie meye'axetɨ». ");
INSERT INTO hch_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","'Aruni Muitsexi hamatɨa meta yunaitɨ 'Ixaheri kiekatari mɨpaɨ mekateniuyurieni. 'Ixaheritsixi mɨpaɨ naime mekateniuyurieni Yawé Muitsexi kemɨtiuta'aitɨakai rewitsixi wahetsiemieme, ");
INSERT INTO hch_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","mɨkɨ yu'ixurikite mekaniuti'ekwa mekaniuyu'itieni. 'Aruni kaniwayetuani Yawé hɨxie mawari 'aixɨa mɨ'ane hepaɨ, wahetsiemieme kaniutaniuni 'aixɨa memɨ'itɨarienikɨ. ");
INSERT INTO hch_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Mɨpaɨ me'uyɨkake rewitsixi tukita mekanekɨne memayutixexeɨriwatsie, muwa memɨteheta'uximayatakɨ 'Aruni meta niwemama meteware'aitɨakaku, hikɨ naitɨ kanaye'atɨarieni Yawé Muitsexi kemɨrahɨawekai rewitsixi wahetsiemieme. ");
INSERT INTO hch_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Yawé Muitsexi mɨpaɨ katiniutahɨawe: ");
INSERT INTO hch_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","«'Ikɨ 'inɨari rewitsixi wahetsiemieme kanihɨkɨtɨni: Tuki memɨyutixexeɨriwatsie memɨteta'uximayatakɨ mewaraka'utɨwatɨ xeitewiyari heimana 'auxɨwi wiyari memexeiyatɨka meta muwa memautiyune, ");
INSERT INTO hch_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","kepaukari huta tewiyari heimana tamamata wiyari maye'atɨarieni mekateniutahayeikawakuni, ");
INSERT INTO hch_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","'anari xeikɨa mekateniparewiekakuni tukita kememɨteyurieka wa'iwama, 'uximayatsikari mepɨkahɨritɨarieka. 'Ikɨ rewitsixi pɨwa'uximayatsikatɨni kememɨtehɨritɨarie». ");
INSERT INTO hch_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Yawé Muitsexi kaniutahɨawe makumawetsie metitekaku Tsinahi mɨrakutewatsie, mexɨakame metseriyaritsie hutarieka wiyari 'anuyemiekaku kepauka 'Ekipitu memayekɨtsie. Mɨpaɨ katinitahɨawe: ");
INSERT INTO hch_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","«'Ixaheritsixi Patsikwa 'ixɨarariyari mekaniuwewiximekuni kemɨ'ane tukaritsie yanepɨtayɨni. ");
INSERT INTO hch_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Taikai xekaniwewiximekuni tamamata heimana naurieka tukari 'umiekaku mexɨakame metseritsie, mana kanika'inɨarikamɨkɨ. Xekaniwewikuni 'inɨari niukiyari xemaye'atɨanikɨ». ");
INSERT INTO hch_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Muitsexi katiniuta'aita Patsikwa 'ixɨarariyari 'ixaheritsixi memɨwewienikɨ, ");
INSERT INTO hch_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","mɨkɨta mekaniwewieni Tsinahi mɨrakutewatsie makumawetsie, taikai tamamata heimana naurieka tukari 'umiekaku mexɨakame metseriyaritsie. Yawé Muitsexi kemɨtiuta'aitɨakai 'ixaheritsixi naimekɨ yamekateniuyurieni kemainekai. ");
INSERT INTO hch_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Peru matsi hipatɨ Patsikwa 'ixɨarariyari memɨwewieni mepɨka'upitɨarie, memɨka'itiyakaikɨ timɨkime memɨte'umayɨakaikɨ. Mɨkɨ tukaritsie Muitsexi meta 'Aruni wahetsɨa mekananukɨne, ");
INSERT INTO hch_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","mɨpaɨ mekateniwarutahɨawe: —Timɨkime tepɨtehemayɨa, 'ayumiemexɨari 'aixɨa tepɨka'anene. Hikɨ tepimaiku xɨka teyɨwaweni Yawé hetsiemieme temɨtetimawakɨ mɨkɨ tukaritsie hipame 'ixaheritsixi wahepaɨ. ");
INSERT INTO hch_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Muitsexi mɨpaɨ katiniwarutahɨawe: —Yaxeketeneutewini Yawé kemɨnetitahɨawe kemɨtiyurimɨkɨ xehetsiemieme. ");
INSERT INTO hch_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Hikɨ Yawé Muitsexi mɨpaɨ katiniutahɨawe ");
INSERT INTO hch_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","'ixaheritsixi mɨpaɨ mɨtiwatahɨawekɨ: «Kepauka xewitɨ xe'iwa 'aixɨa mɨka'aneni xeime timɨkime mɨremayɨa yatsepa xewitɨ yukwiepa mɨka'uyeika, mɨpaɨtsiere 'anetɨ miwewieni pɨyɨwe Patsikwa Yawé hetsiemieme. ");
INSERT INTO hch_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Hɨrixɨatsɨ xɨka mɨpaɨ 'aneni, kaniwewimɨkɨ taikai tamamata heimana naurieka tukariyaritsie hutarieka metseriyaritsie 'umiekaku. Muxa kanitakwaimɨkɨ paa mɨkakuxanariyarietɨkakɨ meta tupiriya matsiwi, ");
INSERT INTO hch_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","muxa waiyarieya 'uxa'arieka mieme mayanikɨ xepɨkakuhayeikawani meta 'umeyarieya xepɨka'anumurani. Kepauka Patsikwa 'ixɨarariyari mɨwewieni kehepaɨ mɨrayuwewiwa mɨpaɨ katiniyurimɨkɨ. ");
INSERT INTO hch_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","»Xɨka xewitɨ Patsikwa 'ixɨarariyari ka'uwewieni 'aixɨa 'anetɨtɨ meta 'ateewa kaheyeikatɨ, manuyeikatsie kanayeweiyariemɨkɨ Yawé mɨkatiutimawirikɨ mɨkɨ tukaritsie. 'Ana katinikwinitɨariemɨkɨ 'axamɨtiuyurikɨ. ");
INSERT INTO hch_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","»Xɨka 'ateewa kiekame xehamatɨa muka Patsikwa 'ixɨarariyari wewimɨkɨni Yawé hetsiemieme, kaniyɨweni 'inɨari kemaine mɨpaɨ 'anetɨ. Mɨkɨ Patsikwa 'inɨarieya kemaine yunaime wahetsiemieme pɨhɨkɨ, mana nunuiwakate meta 'ateewatari». ");
INSERT INTO hch_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Kepauka tuki 'ixurikiyari munɨrie Kakaɨyari tɨratuya muyeka, tukarikɨ tuki hai kanenukanakaitɨni, meta tɨkarikɨ tai hepaɨ 'anetɨ kanayani. ");
INSERT INTO hch_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Mɨpaɨ kaniuyɨnekaitɨni: Tukarikɨ hai tuki kananukanarɨmakaitɨni, tɨkarikɨta tai kanayeikakaitɨni. ");
INSERT INTO hch_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Kepauka hai manuku'ekekai tuki heima, 'ixaheritsixi 'ana mekanayekɨkakaitɨni, hakewata hai meyuhayewa manata mekanitiyaxikekaitɨni. ");
INSERT INTO hch_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Yawé kemɨtiwakɨhɨawekai 'ixaheritsixi mɨpaɨ mekateniyekɨkakaitɨni yatɨni mɨpaɨ mekatenikuyaxikekaitɨni, kemɨreuteterekai hai tuki heima 'uyekaitɨ mana mekaniyukuhayeikawakaitɨni. ");
INSERT INTO hch_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Tsepa mɨixa tukari tuki heima muyeya, 'ixaheritsixi Yawé mekaneu'eniekaitɨni kemɨtiwa'aitɨakai mepɨka'ayekɨkakai. ");
INSERT INTO hch_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Yaxeikɨata kepauka yakɨ mɨreuteterekai tuki heima: Kepauka Yawé mɨpaɨ mɨtiku'inɨaritakai, 'ixaheritsixi 'amenitiyaxikekaitɨni yatɨni mekanekɨkakaitɨni. ");
INSERT INTO hch_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Heiwa hai xeitɨkari xeikɨa kanikuyuruwakaitɨni, tsepa tɨkarikɨ tsepa tukarikɨ, kepauka meyeikakai 'ana 'ixaheritsixi mekananuku'uwekaitɨni. ");
INSERT INTO hch_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Tsepa huta tukari yatɨni xeimetseri yatɨni mɨixa tukari, 'ixaheritsixi mana mekaniyukuhayeikawakaitɨni mekapekɨkakai, kepaukata meyeikakai hai mekanekɨkakaitɨni 'utɨmana. ");
INSERT INTO hch_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Kepauka Yawé yamɨtiwaku'inɨaritɨwakai, 'ixaheritsixi mana mekanikuyaxikekaitɨni yatɨni mepekɨkakai. Yawé mɨpaɨ mekateneu'eniekaitɨni yaxeikɨata Muitsexi Yawé yatikɨhɨawekaku. ");
INSERT INTO hch_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Yawé Muitsexi mɨpaɨ katiniutahɨawe: ");
INSERT INTO hch_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","«Hutame kuxineta titsunamekɨ keneutiwewi pɨratakɨ wewiyatɨkaime, mana memukutei pemɨwakuxexeɨriwanitsie keneutahɨtsiwani meta kepauka memayekɨnetsie. ");
INSERT INTO hch_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Kepauka hutatɨ mɨtiyuani, yunaitɨ teɨteri 'ahamatɨa mekaniyukuxeɨrikuni 'ixuriki tukiyari mɨranutahakitɨretsie. ");
INSERT INTO hch_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Kepauka xewitɨ xeikɨa mɨtayuani, 'ahamatɨa mekaniyukuxeɨrikuni xeikɨa memanuyetei 'Ixaheri nuiwarimama. ");
INSERT INTO hch_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Kuxineta haikakɨa hetayuayu memɨyehutsiemieme, mekananuyeyaxikuni tau makayuyuipiketsie memɨtitei, ");
INSERT INTO hch_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","hutariekata tatsutɨa memɨtitei. 'Ana kanitayuamɨkɨ kuxineta memɨyehutsie 'amemayekɨnekɨ. ");
INSERT INTO hch_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Kepauka memɨyuxeɨrikuni mematiteitsie kuxineta kanitayuamɨkɨ yɨkɨ pɨta tiuyuatɨ. ");
INSERT INTO hch_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","»Kuxineta memɨtihɨtsieni mawari wewiwamete 'Aruni niwemama mekateniyurikuni. 'Ikɨ 'aitsika kanihɨkɨtɨkamɨkɨ xehetsiemieme meta xenuiwarima. ");
INSERT INTO hch_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","»Kepaukari yukwietsie xemeta'axɨani xemayekɨne xekaneyɨwawekuni xeheyutakwinike memɨxe'aye'unie wahetsɨa, mɨkɨ kuxineta kanitiyuamɨkɨ kepauka xemeyutakwini. Hikɨ 'ana xeme Yawé kanixehaye'erimɨkɨ kanixetawikweitsitɨamɨkɨ memɨxe'aye'unie watsata. ");
INSERT INTO hch_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","»Kepauka 'ixɨarari waɨkawa meuyewetse xemutiwewiwani, meta metseri mɨhekwa tukariyari 'anatsiere xekateniutihɨtsiwakuni mawari taiyariyari memewewienikɨ meta 'aixɨa memɨteyuxeiyani mawariyari hetsiemieme. 'Ana Kakaɨyari xeme pɨxehaye'erieni. Ne Yawé 'akakaɨyari nekanihɨkɨtɨni». ");
INSERT INTO hch_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Xeitewiyari tukari 'umiekaku hutarieka metseriyaritsie, hutarieka wiyaritsie, hai kananuku'ene tuki heima. ");
INSERT INTO hch_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Hikɨ 'ixaheritsixi Tsinahi mekaniyekɨne memakutekaitsie makumawetsie paitɨ mekaniu'axɨani, Parani mɨrakutewatsie hai hakewa meuyeya. ");
INSERT INTO hch_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Yawé Muitsexi kemɨtiuta'aitɨa, 'ana 'ixaheritsixi mekaniyekɨne matɨari. ");
INSERT INTO hch_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Matɨari memanuyeyaxixɨ Kura teɨterimama mekaniyɨakaitɨni yupatera me'akwetɨ. Kaniwara'iniekaitɨni Nahatsuni titewatɨ 'Aminarawi nu'aya. ");
INSERT INTO hch_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Natanaheri Tsuhaxi nu'aya kaniwara'iniekaitɨni 'Itsakaxi nuiwarimama. ");
INSERT INTO hch_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","'Eriyáwi Heruni nu'aya kaniwara'iniekaitɨni Tsawuruni nuiwarimama. ");
INSERT INTO hch_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Hikɨ tuki 'utaxɨnarieka, Keritsuni nuiwarimama meta meraritsixi mete'utɨtɨ mekanekɨne. ");
INSERT INTO hch_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Wa'utɨmata memayekɨ Xuweni teɨterimama mekaniyɨakaitɨni yupatera me'akwetɨ. Kaniwarawitɨkɨkaitɨni 'Eritsuxi Tserehuxi nu'aya. ");
INSERT INTO hch_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Tserumieri Tsuritsarahi nu'aya Tsimehuni nuiwarimama kaniwarawitɨkɨkaitɨni, ");
INSERT INTO hch_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","'Eriyatsati Rehuheri nu'aya Kahari nuiwarimama kaniwarawitɨkɨkaitɨni. ");
INSERT INTO hch_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Hikɨta mɨkɨ wa'utɨa mekanekɨne Kuhatitsixi mɨtipatsietɨka tetɨkɨmete. 'Ixuriki tukiyari kaniutawewierikekaitɨni mexi meka'uye'axɨawaweni hakewa memetiyaxe. ");
INSERT INTO hch_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Mɨkɨta wa'utɨma mekanekɨne 'Epɨrahini teɨterimama yupatera me'akwetɨ. Mɨkɨ 'Eritsama 'Amihuri nu'aya kaniwarawitɨkɨkaitɨni. ");
INSERT INTO hch_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Kamarieri Peratsuxi nu'aya Manatsexi nuiwarimama kaniwarawitɨkɨkaitɨni, ");
INSERT INTO hch_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","'Awirani Kereuni nu'aya Wenikamini nuiwarimama kaniwarawitɨkɨkaitɨni. ");
INSERT INTO hch_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","'Imatɨrieka yunaime wahɨwemete mekanayekɨne Rani teɨterimama yupatera me'akwetɨ. 'Akihetsexi 'Amitsarahi nu'aya kaniwarawitɨkɨkaitɨni. ");
INSERT INTO hch_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Pakieri 'Ukɨrani nu'aya, 'Atsexi nuiwarimama kaniwarawitɨkɨkaitɨni, ");
INSERT INTO hch_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","'Akira 'Enahani nu'aya, Nepɨtahari nuiwarimama kaniwarawitɨkɨkaitɨni. ");
INSERT INTO hch_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Mɨpaɨ mekateneuku'ukaitɨni 'ixaheritsixi kepauka memayekɨkakai. ");
INSERT INTO hch_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Hikɨ Muitsexi Huwawi Xehueri mariyani tewiyari nu'aya mɨpaɨ katiniutahɨawe: —Tame tepayekɨnirɨme Yawé kwie mɨtatsi'axatɨatsie. Hikɨmɨ tanaitɨ tekaniyehuni 'aixɨa temɨteheyuxeiyanikɨ, Yawé 'ixaheritsixi wahetsiemieme 'aixɨa mɨtiuka'iyarikɨ. ");
INSERT INTO hch_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Huwawi mɨpaɨ kaniutayɨni: —Ne hawaikɨ, ne nepɨkayemie, ne nekwiepa pɨta nekaniyemieni nemarema wahetsɨa. ");
INSERT INTO hch_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Muitsexi mɨpaɨ katinitahɨawe: —Neuxeitsɨ, pepɨkatatsi'uku'e'eiriwani, 'Ekɨ pepukumate makumawetsie hakewa temeka'uxipiweni. 'Ekɨ pemɨtatsi'anuwitɨni pepɨhɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Xɨka petatsi heweiya, tame tematsi heyetuirieni 'aixɨa mɨti'ane Yawé mɨtareyetuirieni. ");
INSERT INTO hch_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","'Ixaheritsixi mekanayekɨne Yawé hɨrieya manukatsie, haika tukari mekaniuhukaitɨni Yawé tɨratuya mayeka me'akwetɨ, wahɨxie kaniumiekaitɨni 'ikuwaunetɨ hakewa memeka'uxipienikekai. ");
INSERT INTO hch_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Kepauka memayekɨkakai, Yawé haiwitɨrieya waheima tukarikɨ puyeyeixakai. ");
INSERT INTO hch_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Kepauka kakuni manukukweiwakai, Muitsexi mɨpaɨ kaniutainekaitɨni: «Yawé, kenanukukexi. Mekeheutaxɨriexɨani memɨmatsi 'aye'unie, Mekeheuyuta'unaxɨani memɨmatsiheka». ");
INSERT INTO hch_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Kepaukata kakuni muwakekakai, Muitsexi mɨpaɨ kaniutainekaitɨni: «Yawé, kenenua, 'ateɨterima 'ixaheritsixi wahetsɨa memɨkayu'inɨatsinɨa memɨhɨkɨ». ");
INSERT INTO hch_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Tawera metitetɨ 'ixaheritsixi 'axamekaniutiyuanekaitɨni Yawé hepaɨtsita mete'uka'eniwatɨ. Mɨkɨ waru'enieka waɨkawa kaniuyeha'ani, taikɨ wawarita mematiteitsie katinaxɨtsitɨatɨyani. ");
INSERT INTO hch_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Hikɨ 'ixaheritsixi Muitsexi waɨkawa mekaniwawiriekaitɨni, kaniuyutanenewieni Yawé mɨtiwareuyehɨwirienikɨ, 'ana tai kaniutɨni. ");
INSERT INTO hch_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","'Ayumieme mana mɨya mɨtiɨyɨkɨ Tawera katiniuterɨwarieni, Yawé taikɨ mɨwarutitaiyaxɨkɨ. ");
INSERT INTO hch_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Hipatɨ teɨteri kɨkamete memaye'ukai waɨkawa meteheukwaikɨtɨ mekanakɨne. Hikɨ 'ixaheritsixi mekaniutitsuani meta mɨpaɨ me'utiyuatɨ: «Kemɨ'ane wai pɨtatsimini. ");
INSERT INTO hch_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Titayari tsapari 'Ekipitutsie temɨwaretikwa'akai tekateyutuatɨ tetewareku'eiri. Yaxeikɨata pepinu meta meruni temetikwa'akai metatsiere wexu, 'uyuri meta 'axuxi. ");
INSERT INTO hch_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Hikɨ neuxei tekananatiwawakini, manana xeikɨa tekanixeiyani». ");
INSERT INTO hch_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Manana tsiranituru hatsiyari hepaɨ katiniyuxexeiyakaitɨni, witsuanari mutimerɨka hepaɨ. ");
INSERT INTO hch_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","'Ixaheritsixi mekanikuteɨxɨkaitɨni tetexi hutamekɨ mekanititɨxɨkaitɨni, yatɨni mekanititsunakaitɨni xɨka me'ika'etsakuni meta paa kɨmana mekaniwewiekaitɨni. Paa mɨwiyamarie hepaɨ kana'anekaitɨni. ");
INSERT INTO hch_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Tɨkarikɨ kepauka haɨtsi mɨkaxɨrɨwekai memakuteitsie, manatsiere manana kanikaxɨrɨwekaitɨni. ");
INSERT INTO hch_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Hikɨ Muitsexi kaniu'ena 'ixaheritsixi meta watɨɨriyama kememɨte'utsuanakai, yuxexuitɨ yuxamaru kitenie, Yawé mekanihaxɨatɨakaitɨni. Hikɨ yu'uximatɨatɨ, ");
INSERT INTO hch_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Muitsexi Yawé kaniutahɨawe nenewierikɨ: —Xɨka ne neti'a'uximayatsiriwametɨni, ¿titayari peneti'uximatɨa? ¿titayari pekanetiparewie, teɨteri yunaitɨ nehetsie memɨte'uhɨpanikɨ penetihɨritɨa? ");
INSERT INTO hch_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","¿Netsɨ neniwema menehɨkɨ, neniwarutiniwexɨ, pemɨnetsi'aitɨakɨ kename newa'ɨwiyani, 'atɨɨriyama waweriyame hepaɨ, newarakatɨtɨ nemɨwareta'atɨanikɨ hakewa paitɨ kwie wa'ukiyarima pemɨwarexatɨatsie? ");
INSERT INTO hch_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","'Ikɨ yunaitɨ teɨteri wai mekaneniwawirieka me'utitsuatɨ. ¿Ne hakewa nepeikaxeiya? ");
INSERT INTO hch_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Ne nexaɨtame nepɨkayɨwe 'ikɨ teɨteri wahetsiemieme. Waɨkawa 'uximayatsika pɨhɨkɨ nehetsiemieme. ");
INSERT INTO hch_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Xɨka mɨpaɨ petiyurienemɨkɨ, ne nepɨmatsiwawirie netukari pemɨnetsi nawairienikɨ. Mɨpaɨ nepɨratɨmaiya hikɨ kenemɨtiuka'eniwa. ");
INSERT INTO hch_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Yawé Muitsexi mɨpaɨ katiniuta'eiya: —'Ukirawetsixi 'ixaheritsixi haika tewiyari heimana tamamata kenene'atɨiri, mɨpaɨ ketinemaika yuteɨterima memɨwakuyuitɨwa xeikɨa mekaniyɨakakɨni. 'Ixuriki tukiyari manuwe keniwaranuwitɨki, mana 'etsiwa 'ahamatɨa yameketeheutewini. ");
INSERT INTO hch_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Ne 'ahamatɨa nemɨtitaxatakɨ nekananukatemɨkɨ, mɨkɨ wahetsieta yanekatiniyurimɨkɨ 'iyari pemexeiya memexeiyanikɨ, memɨmatsiparewiekakɨ 'ikɨ teɨteri mɨmatsihɨritɨa wahekɨ. Mɨpaɨ 'ekɨ 'axaɨtame xeikɨa pemɨkayɨanenikɨ. ");
INSERT INTO hch_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","»Teɨteri xeikɨa mɨpaɨ pekatiniwatahɨawimɨkɨ: “Xekeneuyu'iti 'uxa'a miemekɨ, 'uxa'a wai xekanitikwaikuni. Xeme xekaniutitsuani Yawé hɨxie, mɨpaɨ xe'utiyuatɨ: ‘Wai ketatsi'umini. 'Ekipitutsie naime tepɨtehetikwa'akai.’ Mɨkɨta hikɨ wai kanixemimɨkɨ, xekanitikwaikuni. ");
INSERT INTO hch_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Xeitukari, nihuta tukari ni'aɨxɨwime tukari, tamamata tukari, meta nixeitewiyari tukari xepɨka'itikwa'ani, ");
INSERT INTO hch_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","matsi xeimetseri, kepaukake xetsurita makanexɨani, kepaukake xemitixani'erieni. Yawé xemu'uximatɨakɨ, xehamatɨa muyeika, xemutitsuakɨ mɨpaɨ xe'utiyuatɨ: ‘¿Titayari 'Ekipitutsie tetehayekɨ?’”» ");
INSERT INTO hch_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Muitsexi mɨpaɨta kaniutayɨni: —Ne kuyaxi 'ataxewime tsienituyari miriyari wahamatɨa nekaniuyeikani, ¿'ekɨta wai xeimetseritsie xeikɨa petiwamini peraine? ");
INSERT INTO hch_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Tsepanetɨ xeikuraruyari tsipuru mɨwarukwi'iri mepɨkatenake, tsepanetɨ haramaratsie tsapari memuye'uwa yunaime mɨwarukwi'iri yunaitɨ mepɨkatenake. ");
INSERT INTO hch_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Yawé Muitsexi mɨpaɨ katiniuta'eiya: —¿Kamɨtsɨ Yawé tɨrɨkariyaya reu'atɨka? Hikɨtsɨ pekaninierimɨkɨ, xɨka neniuki nehaye'atɨamɨkɨ yatɨ pɨtikatixaɨ. ");
INSERT INTO hch_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Hikɨ Muitsexi 'ixaheritsixi yakatiniwarutahɨawe Yawé kemɨtitahɨawekai. Mɨkɨ kaniwarukuxeɨrieni haika tewiyari heimana tamamata 'ukirawetsixi, wa'aurie kaniyuhayewa ta'ikwewatɨ 'ixuriki tukiyari 'aurie. ");
INSERT INTO hch_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Yawé haitsie 'uyekaitɨ Muitsexi hamatɨa katiniutaxata, meta haika tewiyari heimana tamamata 'ukirawetsixi 'iyari kaniwarupitɨani Muitsexi meixeiyakai. Kepauka 'iyari wahetsie mɨyuhayewaxɨ, metekuxatatɨwetɨ mekanakɨne. Tawarita mɨpaɨ pɨkatiɨyɨ. ");
INSERT INTO hch_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Yuhutatɨ 'ukirawetsixi yukie memuyuhayewakai. Xewitɨ 'Erirari titewatɨ, xewitɨta Merari. Tsepa memanayexeiyariekai tuki manuwe mepɨkahekɨ. Yatɨtɨ, 'iyari wahetsie pɨtiunakixɨ, mɨkɨta metekuxatatɨwetɨ mekanakɨne mematiteitsie. ");
INSERT INTO hch_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Hikɨ xewitɨ temaikɨtɨtɨ kaniutanautsa Muitsexi mɨkɨkɨ retaxatɨanike, mɨpaɨ kaniutayɨni: —'Erirari, Merari hamatɨa mekatenekuxatatɨweni temakuteitsie. ");
INSERT INTO hch_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Kutsuhexi Nuni nu'aya, ti'uximayatame manayexeiyarie Muitsexi parewiwameyakɨ temaikɨyari paitɨ, mɨpaɨ kaniutayɨni: —Muitsexi, neti'aitɨwame, keniwaruta'imaiya. ");
INSERT INTO hch_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Muitsexi mɨpaɨta kaniutayɨni: —¿Nekɨmana peti'ɨtetsa? Mɨpaɨ nepɨtiku'eriwakaku yunaitɨ 'ikɨ Yawé teɨterimama 'iyari mepexeiyanikeku memɨtekuxatanikɨ. ");
INSERT INTO hch_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Hikɨ Muitsexi meta 'ukirawetsixi mekaniu'axɨani mematitekaitsie. ");
INSERT INTO hch_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Yawé 'eka kaniuyuitɨani xɨ'aurixi haramaratsie miemete waratɨkɨme, mematiteitsie kaniwarukaxɨrieni. Memakuteitsie wa'aurie xɨ'aurixi mekanakunɨkaitɨni, xeitukari 'umietɨ ranuyenakeme me'atayeutɨ, xeimeturuyari metsuitɨ kwiepa. ");
INSERT INTO hch_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","'Ixaheritsixi mekaniwarukuteɨxɨ xɨ'aurixi mɨkɨ tukaritsie meta naime mɨkɨ tɨkaritsie meta 'uxa'arieka. Yunaitɨ tamamata 'ikayari mekaniukuxeɨrieni. Memakuteitsie takwa yateewa mekaniwarutiwatsiɨxa. ");
INSERT INTO hch_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Hikɨ kepauka memeitakwaixɨa yuteta meka'itikeiwawekaku 'akuxi, Yawé kaniuyeha'ani 'ixaheritsixi wahetsiemieme, 'ana yuwaɨkawatɨ mekaniukwini. ");
INSERT INTO hch_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","'Ayumieme mana mekateniuterɨwa Kiwuruti-Hatawa, mana memukateukiekɨ 'ikwaitsie xeikɨa memɨyukɨhɨawekaikɨ. ");
INSERT INTO hch_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Mana Kiwuruti-Hatawa memɨyekɨ 'ixaheritsixi, mekanekɨne pɨta Katseruti mana mekaniuyuhayewa. ");
INSERT INTO hch_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Muitsexi xeime 'uka 'ekipitutanaka kaniutiwitɨni, hikɨ Miriyami 'Aruni hamatɨa mekanitiniukimatɨkɨne mɨkɨkɨ. ");
INSERT INTO hch_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Mɨpaɨ mekaniutiyuanekaitɨni: «¿Kamɨtsɨ Yawé Muitsexi xeikɨa tikuhɨawe? ¿Tamɨ tameta katatikɨhɨawe?» Hikɨ Yawé kaniwaru'enieni. ");
INSERT INTO hch_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Matsi Muitsexi tixaɨtɨ karayuyeitɨatɨ 'amuyeika kanihɨkɨtɨkaitɨni, nixewitɨ tawarita hepaɨna 'anetɨ kwiepa pumawekai. ");
INSERT INTO hch_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Yapauka Yawé Muitsexi, 'Aruni meta Miriyami mɨpaɨ katiniwarutahɨawe: «Xekenehu 'ixuriki tukiyari manuwe xeme xeyuhaikatɨ». Mɨkɨ mekanekɨne. ");
INSERT INTO hch_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Hikɨ Yawé kanakateni hai 'a'uwekametsie, 'ixuriki tukiyari hɨxie kaniuyuhayewa. 'Aruni meta Miriyami mame kaniwaruta'inieni, kepauka yuhutatɨ memɨwakɨ, ");
INSERT INTO hch_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Yawé mɨpaɨ katiniwarutahɨawe: «Xekeneneu'eni kenemɨtixetahɨawe: »Kepauka Yawé niukameya xetsata 'amuyeika, ne nekanikɨhɨaweni heinɨtsika hepaɨ 'anemetsie meta nematsiɨkɨtɨ nekanayuyeitɨwani heinɨtsikatana. ");
INSERT INTO hch_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Peru 'ikɨ mɨpaɨ pɨka'ane Muitsexi neti'uximayatsiriwame hamatɨa, yunaitɨ nete'uximayatsiriwamete watsata mɨkɨ matsi yamɨtikamie kanihɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Ne nekatinikuxaxatɨwani hɨxiena ne'utinieretɨ, hekɨakamekɨ nekarenukanamirietɨ. Ne Yawé kenemɨ'ane kanenikuxexeiyani. ¿Ketitayari mɨya xete'utiyuane neti'uximayatsiriwame Muitsexi hepaɨtsita?» ");
INSERT INTO hch_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Yawé waɨkawa kaniuyeha'ani wahepaɨtsita hikɨ kaneyani. ");
INSERT INTO hch_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Yapauka hai 'anuku'eneku tuki heima, Miriyami nawiyarieya tuxatɨ kanayani 'ɨwi hepaɨ. Kepauka 'Aruni hepana mutɨa, kanixeiya yuwaiyaritsie kwiniya hexeiyakame. ");
INSERT INTO hch_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Hikɨ 'Aruni 'ana Muitsexi mɨpaɨ katiniutahɨawe: «Waɨkawa nepɨmatsiwawirie, neti'aitɨwame, ke'axatemɨte'uyuri pepɨkahe'eriwani 'atsitekatemaitɨ temutiyuakɨ. ");
INSERT INTO hch_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Miriyami yuwaiyaritsie kanepɨnini, nunutsi yumaama hetsie manuyemɨ nawiyarieya hepaɨ. Ximɨxi kwerietɨ mɨpaɨ pɨka'aneni ketineuyehɨwirieka». ");
INSERT INTO hch_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Muitsexi Yawé mɨpaɨ katiniutawawirieni: «Kakaɨyari, waɨkawa nepɨmatsiwawirie pemenayehɨanikɨ». ");
INSERT INTO hch_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Yawé Muitsexi kaniuta'eiya: «Xɨka paapaya hɨxienatsie 'ita'aɨtsikawiyake ¿katiyɨwe 'atahuta tukari muyuhiwerieka? Keheyani 'atahuta tukari kiepa pɨka'ukani, mɨkɨ tukari 'aye'ayuke kanipitɨariemɨkɨ». ");
INSERT INTO hch_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Mɨpaɨ Miriyami 'atahuta tukari yeuta kaniukateitɨni. 'Ixaheritsixi mepɨkahekɨ kepaukake mɨkɨ wahetsɨa munua. ");
INSERT INTO hch_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","'Anake 'ixaheritsixi mekanayekɨne Katseruti, Parani makumawetsie mekaniu'axɨani. ");
INSERT INTO hch_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Yawé Muitsexi mɨpaɨ katiniutahɨawe: ");
INSERT INTO hch_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","«Mɨpaɨ nepaine keniwaranunɨ'a hipame kwie memɨxeiyayukɨ 'ixaheritsixi nemɨwayetuirieni. Yuxexuime nuiwaritetsie memanuyetei mekaniwaranunɨ'akuni». ");
INSERT INTO hch_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Yawé kemainekai, Muitsexi kaniwarenɨ'ani Parani makumawetsie mekaniyekɨne. Yunaitɨ mɨkɨ 'ixaheritsixi memanuyetei mekanihɨkɨtɨkaitɨni. ");
INSERT INTO hch_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Mɨpaɨ mekatenitetewakaitɨni: Tsamuha, Tsakuxi nu'aya, Xuweni nuiwarimama wahetsiemieme, ");
INSERT INTO hch_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Tsapati, Huri nu'aya, Tsimehuni nuiwarimama, ");
INSERT INTO hch_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Karewi, Kepune nu'aya, Kura nuiwarimama, ");
INSERT INTO hch_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","'Ikari, Kutse nu'aya, 'Itsakaxi nuiwarimama memɨhɨkɨ, ");
INSERT INTO hch_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","'Utseyaxi, Nuni nu'aya, 'Epɨrahini nuiwarimama memɨhɨkɨ, ");
INSERT INTO hch_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Pariti, Xapuhu nu'aya, Wenikamini nuiwarimama, ");
INSERT INTO hch_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Kariheri, Tsuhuri nu'aya, Tsawuruni nuiwarimama wahetsiemieme, ");
INSERT INTO hch_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Kari, Tsutsi nu'aya, Manatsexi nuiwarimama (Kutse nu'aya xewitɨ mɨhɨkɨ), ");
INSERT INTO hch_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","'Amiheri, Kemari nu'aya, Rani nuiwarimama memɨhɨkɨ, ");
INSERT INTO hch_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Tsetuxi, Mikaheri nu'aya, 'Atsexi nuiwarimama wahetsiemieme, ");
INSERT INTO hch_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Nakiwi, Watsi nu'aya, Nepɨtahari nuiwarimama wahetsiemieme, ");
INSERT INTO hch_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Kehueri, Maki nu'aya, Kahari nuiwarimama wahetsiemieme. ");
INSERT INTO hch_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Mɨpaɨ mekatenitetewakaitɨni memanuyetei Muitsexi mɨwarenɨ'a kwie memɨxeiyayukɨ. ('Utseyaxi mɨtitewakai Nuni nu'aya, Muitsexi kanipata Kutsuhexi pɨta katiniterɨwa). ");
INSERT INTO hch_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Kepauka Muitsexi mɨwarenɨ'a Kanani kwieyari memɨxeiyayukɨ, mɨpaɨ katiniwarutahɨawe: «Nekexi xekaneutiyunikuni, hɨritsie paitɨ xekaniye'axɨakuni. ");
INSERT INTO hch_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Kwie naime xekenexeiya, xekeneyɨ'ɨwiya teɨteri kememe'anene, xɨka mehetɨrɨkawini yatɨ mepɨkatehetɨrɨkawi, xɨka meheyuwaɨkawani yatɨ 'etsi mepɨteheyupaɨme. ");
INSERT INTO hch_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Xekenexeiya kwie keme'ane, xɨka 'aixɨa he'aneni yatɨ 'axapɨre'ane, xɨka waki hekurarutsietɨkani yatɨ pɨtikatixaɨ. ");
INSERT INTO hch_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Kwie xekenexeiya xɨka 'aixɨa rexuaweriyani yatɨ hawaikɨ, xɨka kɨyexi hexuaweni yatɨ pɨremawe. Hikɨ xekenehu xekamamatɨ. Tixaɨtɨ 'ikwaxi xekateni'atuakuni muwa timieme». Mɨkɨ tukaritsie kaxie takari matɨari mieme matikwakwaxetsie mekaniyɨakaitɨni. ");
INSERT INTO hch_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Mekanekɨne tamamata heimama huta meyupaɨmetɨ 'ukitsi kwie meheuxeiyayuka, makumawetsie Tsini Xekuwi ye'atɨkaime, Rewu Kamati heuhurakaku. ");
INSERT INTO hch_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Nekexi mekaneutiyune, Hewuruni mekaniye'axɨani, 'Akimani, Tsetsahi meta Tarimahi memanu'uwakai 'Anaki nuiwarimama mematitekai. ('Epuruni kiekariyari meri kaniukamarieni 'ariketa 'atahuta wiyari 'anuyemiekaku Tsuhani kiekariyari kaniukamarieni 'Ekipitu mieme). ");
INSERT INTO hch_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Kepauka memu'axɨa mayeweritsie 'akitsie 'Etsikuri, xeixatsimuyari mekanaka'inɨni kaxie takari, yuhutatɨ meneitɨni kɨyetsie me'iyewietɨ. Metatsiere hipame 'ikwaxite kɨranaraxi meta xapa takariyari mekanaka'inɨni. ");
INSERT INTO hch_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","'Ikɨ kaxie takari memaka'inɨikɨ 'ixaheritsixi, mana mekateniuterɨwa 'Etsikuri mayeweri. ");
INSERT INTO hch_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Huta tewiyari tukari 'anukayaku mekaniu'axɨani tamamata heimana huta 'ukitsi kwie mehekuxeiyaka. ");
INSERT INTO hch_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Karetsi mekaniu'axɨani makumawetsie Parani Muitsexi manukatei, 'Aruni meta yunaitɨ 'ixaheritsixi, mekateniwarutaxatɨani kemɨre'anekai meta 'ikwaxite mekateniwaruxeitsitɨani mana mɨrexuawekai. ");
INSERT INTO hch_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Mɨpaɨ mekateniwaruxatɨani: —Hakewa pemɨtatsihetanɨ'a mɨkɨ kwieyaritsie tepanɨkɨ, puyuri mana waɨkawa pexuawe retsi meta xiete. 'Ena xeketeneuxeiya 'ikwaxi mana mɨrexuawe. ");
INSERT INTO hch_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Perutsɨ mana teɨteri memexuawe waɨkawa mepetɨrɨkawi, wakiekarite 'apɨremamariwawe, 'aixɨa rekukurarutsietɨkaitɨ. Matsita mana tekaniwarexeiya 'Anaki xiɨyarimama 'amemutɨtɨ. ");
INSERT INTO hch_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","'Amarekitsixi Nekexitsie mekaniu'uwani, hɨritsieta hetitsixi, kewutseutsixi meta 'amuxeutsixi hɨritsie mekane'uwani metatsiere kananeutsixi haramara tetsita mekaniu'uwani Kurutani tetsita. ");
INSERT INTO hch_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Karewi kaiwatɨ katiniwaruyatsa 'ixaheritsixi Muitsexi hɨxie, mɨpaɨ kaniutayɨni: —Hikɨmɨtɨka tekanihuni mɨkɨ kwie tema'iwakɨ. Ne mɨpaɨ nepɨtiku'eriwa tepɨyɨwawe. ");
INSERT INTO hch_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Hamatɨana memanɨkɨnekai mɨpaɨ mekaniutiyuani: —Tepɨkayɨwawe mɨkɨ teɨteri wahamatɨa temuyutakwini. Mɨkɨ mepɨtɨrɨkawi waɨkawa. Tame tepɨkatɨrɨkawi. ");
INSERT INTO hch_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Hikɨ 'itarikakɨ mekateniutixatatɨkɨne 'ixaheritsixi watsata kwie memekuxei hepaɨtsita. Mɨpaɨ mekaniutiyuanekaitɨni: —Kwie temekuxei yuteɨterima kaniwarekwaka, teɨteri mana meme'uwa 'amekaniutɨni. ");
INSERT INTO hch_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Matsi manata tekaniwarexeiya 'Anaki xiɨyarimama 'amemutɨtɨ. Temeyuku'inunɨatakai 'utsikari wahepaɨ tepepepekai, mɨpaɨ mɨkɨ mekatatenexeiyakaitɨni. ");
INSERT INTO hch_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Mɨkɨ tɨkaritsie 'ixaheritsixi mekaniutayuani me'utihiwatɨ meta me'utitsuatɨ. ");
INSERT INTO hch_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Meyu'uximatɨatɨ Muitsexi hetsiemieme meta 'Aruni, yunaitɨ mɨpaɨ mekaniutiyuanekaitɨni: «Matsi temɨnekwikaitɨni 'Ekipitu paitɨ. 'Ena 'aixɨa pɨyɨni makumawetsie xɨka te'ukwini. ");
INSERT INTO hch_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","¿Titayari Yawé 'ikɨ kwieyaritsie tareyewitɨ? ¿'Ixiparakɨtsɨ temɨkwi'iwakɨ, ta'ɨitama taniwema memɨwaranuwitɨnikɨ? ¿'Aixɨa kati'ane xɨka tehakunuaxɨani 'Ekipitu?» ");
INSERT INTO hch_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Mɨpaɨ mekateniyɨkɨhɨawekaitɨni hipatɨ: «Xeime manuyeyerɨni tepanuyexeiya mɨtatsi'anuwitɨnikɨ 'Ekipitu paitɨ». ");
INSERT INTO hch_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Hikɨ Muitsexi, 'Aruni hamatɨa kwiepa mekaniukaxɨrieni yɨhɨxima 'ixaheritsixi wahɨxie. ");
INSERT INTO hch_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Mana mekaniti'ukaitɨni Kutsuhexi Nuni nu'aya meta Karewi Kepune nu'aya yukamixa mekaneukatsanaxɨani hiwerika 'ɨnɨariyari mewewietɨ. Mɨkɨ memekɨkɨnixɨakai kepauka kwie memekuxeitsie, ");
INSERT INTO hch_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","hikɨ mɨpaɨ mekateniwarutahɨawe yunaime 'ixaheritsixi: —Kwie temekuxei matsi 'aixɨa kane'aneni temɨkateheyeneniere hepaɨ. ");
INSERT INTO hch_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Xɨka Yawé tatsiparewiekamɨkɨ mana kataniye'atɨamɨkɨ. Kataniyetuiriemɨkɨ kwie hakewa waɨkawa mexuawe retsi meta xiete. ");
INSERT INTO hch_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","'Ayumieme Yawé hɨxie 'axaxepɨkateyu'eniwani meta mana teɨteri memetama xepɨkawareumakaxeni. Tixaɨtɨri mepɨkatehɨkɨ, yuhetsie nunuwame mepɨkahexeiya, tame Yawé kataniparewimɨkɨ. 'Ayumieme xepɨkawareumakaka. ");
INSERT INTO hch_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Peru yunaitɨ 'ixaheritsixi mɨpaɨ memɨte'uxatakaikɨ memɨwatituaxakɨ, Yawé xawatɨriyaya tuki hɨxie kaniuyuhekɨata 'ixaheritsixi yunaime wahɨxie. ");
INSERT INTO hch_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Hikɨ Yawé Muitsexi mɨpaɨ katiniutahɨawe: —¿Kepaukake mepɨtehayewa 'axamenetekumamateketɨ 'ikɨ teɨteri? ¿Kepaukake yuri mepɨteta'erieni nehetsie, mamariwaweme tɨtɨtsɨ watsata nemɨtiyuriene? ");
INSERT INTO hch_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Kwiniya nekananunɨ'amɨkɨ wahetsiemieme mɨwakwinikɨ, 'ahetsie xeikɨa kiekari kanayenemɨkɨ mariwetɨ tɨrɨkaɨyetɨ keyamemutiyuane. ");
INSERT INTO hch_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Muitsexi Yawé mɨpaɨ katiniutahɨawe: —Kenaye'eri kepauka 'ekɨ 'atɨrɨkariyakɨ 'Ekipitu pemɨwarayewitɨ 'ikɨ teɨteri. Kepauka 'ekipitutari memɨtehetimani kepemɨtiuyuri, ");
INSERT INTO hch_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","mɨpaɨ mekateniwataxatɨakuni 'ikɨ kwieyaritsie kiekatari, mɨpaɨ memɨtemate kename 'ekɨ Yawé 'ahɨxie tematsixeiya, 'ahai 'ateɨterima waheima muyeyeixa, kename 'ekɨ pehɨkɨ pemɨwaruwituxime, tukarikɨ hai 'a'uwemekɨ, tɨkarikɨta taikɨ. ");
INSERT INTO hch_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Xɨka pewarukwini yunaime 'ikɨ teɨteri, yunaitɨ nuiwarite mumanetɨka memu'enana hepaɨtsita mɨpaɨ mekanitiyuakuni: ");
INSERT INTO hch_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","“Yawé pɨka'uyɨwekaxɨa 'ikɨ teɨteri mɨwaranuwitɨnikɨ hakewa kwie mɨwarexatɨakai, kaniwarutixɨtɨani makumawetsie wakwitɨ”. ");
INSERT INTO hch_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","»Neuxei hikɨ Yawé, 'atɨrɨkariya kenehekɨatani. 'Ekɨ mɨpaɨ pemainekɨ ");
INSERT INTO hch_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","Yawé kename pekahayu'eriya matsi waɨkawa peti'akanaki'erie meta xeniu pereuyehɨwirieni 'axamɨti'ane meta kemɨ'ane matsi'uku'eiri, peru matsi kemɨ'ane 'axamɨtiuyuri pepɨtikwinitɨani meta niwemamatsie, teukarimamatsie, tutsimamatsie, meta mɨkɨ waniwema wahetsiepaitɨ. ");
INSERT INTO hch_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Waɨkawa pemɨti'akanaki'eriekɨ nepɨmatsiwawirie pemɨtiwareuyehɨwirienikɨ 'ikɨ teɨteri 'axakememɨte'uyuri, 'Ekipitu memayekɨtsietɨtɨ kepemɨtiwareuyehɨwiriekai hikɨta yaxeikɨa». ");
INSERT INTO hch_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Yawé mɨpaɨ katinita'eiya: —Penetiwawirie nemɨtiwareuyehɨwirienikɨ, nekatiniwareuyehɨwiriemɨkɨ. ");
INSERT INTO hch_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Yurikɨ nehetsiemieme mɨpaɨ nekanaineni, meta nexawatɨriya kwiepa naitsarie mɨhɨnekɨ, ");
INSERT INTO hch_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","tsepanetɨ nexawatɨriya memuxei meta mamariwawemekɨ kenemɨtiuyuri 'Ekipitu meta makumawetsie, 'iya kemɨ'ane yuri memɨkaneteheta'eriri, mɨixamexɨa memɨnetsiheta'inɨataxɨ ");
INSERT INTO hch_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","pɨka'ixeiya kwie wa'ukiyarima yuri nehaitɨ nemɨwayetuirienikekai. Nixewitɨtɨma mɨnetsi'utaniukima pɨka'ixeiya. ");
INSERT INTO hch_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Neti'uximayatsiriwame Karewi, yɨkɨ'anekame 'iyari kanexeiyani, 'aixɨa katinikamieni, nekanixatɨamɨkɨ kwie ke'anekame mexei meta nuiwarimama wahetsiemieme kanayeimɨkɨ. ");
INSERT INTO hch_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","'Uxa'a Haramara Mɨxeta hepa xekenehu, 'amarekitsixi meta kananeutsixi mayeweritsie memekiekɨ. ");
INSERT INTO hch_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Yawé Muitsexi 'Aruni mame mɨpaɨ katiniwarutahɨawe: ");
INSERT INTO hch_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","—¿Kepaukake mepɨtehayewa 'ikɨ teɨteri 'axame'utiyuatɨ menetsiniukimatɨ? Nekaniwa'enieka kehepaɨ memɨteniukixie 'ixaheritsixi nehetsiemieme. ");
INSERT INTO hch_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Hikɨ mɨpaɨ ketiniwarutahɨawi nehetsiemieme: “Yurikɨ nehetsiemieme mɨpaɨ nepaine, ketita xemɨteheuyehɨwa yanekatiniyurimɨkɨ. ");
INSERT INTO hch_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Yunaitɨ xeme xekanikwikuni makumawetsie xekaxari 'ena puyuhayewa. Nixewitɨ memaka'utsie xeitewiyari wiyari mehexeiyatɨkaitɨ 'axamemutiyua nehetsiemieme, ");
INSERT INTO hch_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","kwie pɨkayetuiriyarieni nemɨxexatɨa. Mana xeikɨa mekaneutahaxɨakuni Karewi Kepune nu'aya meta Kutsuhexi Nuni nu'aya. ");
INSERT INTO hch_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Tɨɨri xeikɨa kwiepa mekaneutahaxɨakuni xeme mɨpaɨ xemutiyuakɨ kename kuyaxi mewaranuwitɨni wahetsiemieme memakɨnekɨ. Mɨkɨ mekaniyɨakakuni mɨkɨ kwietsie memu'uwani xeme xemitixani'eritsie. ");
INSERT INTO hch_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Xeme xe'umete 'ena makumawetsie kaniyuhayewamɨkɨ. ");
INSERT INTO hch_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Huta tewiyari wiyari xeniwema 'ena makumawetsie mekaniu'uwakuni. 'Ikɨ mekatenanutɨkuni kexemɨkateheu'enana, yunaitɨ xe'akuxɨyuke. ");
INSERT INTO hch_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Kwie xemekuxeitsie huta tewiyari tukari xepeyuri, hikɨta xeitukari pɨ'inɨarini xeiwiyari. Huta tewiyari wiyari xekaniyurikuni xete'uka'eniwatɨ 'axaxemɨte'uyurikɨ, mɨpaɨ xekatenetimaikuni kenemɨtixe'aye'unie”. ");
INSERT INTO hch_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Ne Yawé nekanihɨkɨtɨni, nekatinaye'atɨamɨkɨ kemɨre'uxa kenemutayɨ 'ikɨ teɨteri 'axamemɨte'u'iyari wahetsiemieme, mekaniyukuxeɨrieni menetsi'aye'unietɨ. 'Ena makumawetsie mekanikumawerikuni. 'Enatɨtɨ mekanikwikuni. ");
INSERT INTO hch_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","'Iya 'ukitsi Muitsexi mɨwarutanɨ'akai kwie memɨxeiyayukɨ mɨkɨ mekaniɨyɨni, mehakunuaxɨaka yɨkɨpɨta memɨte'uxa kename kwie 'axahe'anekai. Mɨpaɨ me'utiyuaku yunaitɨ teɨteri mekaniuyu'uximatɨani. ");
INSERT INTO hch_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","'Ayumieme 'ikɨ 'itarikakɨ niuki memutsutɨa kwie hepaɨtsita miemeyari, Yawé hɨxie mekaniukwini kwiniyakɨ. ");
INSERT INTO hch_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Yunaitɨ kwie memekuxeiyakai, Kutsuhexi xeikɨa kaniuyuhayewa Nuni nu'aya meta Karewi Kepune nu'aya. ");
INSERT INTO hch_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Kepauka Muitsexi mɨtiutahayewaxɨ mɨpaɨ tiwakɨhɨawetɨ yunaitɨ 'ixaheritsixi mekaniutitsuanakaitɨni karima meyuhiwerietɨ. ");
INSERT INTO hch_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","'Uxa'arieka ximeri paitɨ mekananutikɨne hɨritsie 'amanutitewatsie 'ixaheritsixi mɨpaɨ me'utiyuatɨ: —Tekanihuni kwie Yawé mɨtatsi haxatɨatsie, mɨpaɨ temɨtematekɨ kename 'axatete'uyuri. ");
INSERT INTO hch_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Peru Muitsexi mɨpaɨ katiniwarutahɨawe: —¿Titayari tawarita Yawé niukieya xekate'enieni? Hikɨ kexemɨteku'eriwa yapɨkatiyunake. ");
INSERT INTO hch_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Xɨka xeheukɨne xekana'iwariekuni, Yawé xehamatɨa mɨka'uyeikakɨri. ");
INSERT INTO hch_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","'Amarekitsixi meta kananeutsixi wahamatɨa xekaneyutakwikuni, mɨkɨ mekanixekwikuni 'ixiparakɨ. Xeme Yawé xemuku'eiri, mɨkɨ pɨkaxeparewieni. ");
INSERT INTO hch_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Mɨkɨ meka'enanatɨ matsi mekanekɨne mɨhɨriyatsie paitɨ, Muitsexi meta Yawé kakunieya tɨratu mayeka wahamatɨa mekahayekɨneku mematiteitsie. ");
INSERT INTO hch_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Hikɨ 'amarekitsixi meta kananeutsixi mana memɨkiekataritɨkai mekaniwarutakwini mekaniwara'iwa, mewaruweiyatɨ Kuxima mɨrayetewatsie paitɨ mekaniwaye'atɨani. ");
INSERT INTO hch_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Yawé Muitsexi mɨpaɨ katiniutahɨawe ");
INSERT INTO hch_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","'ixaheritsixi mɨpaɨ mɨtiwatahɨawekɨ: «Kepauka xemeutahaxɨani kwietsie hakewa nemɨxehexatɨa mana xemutitenikɨ, ");
INSERT INTO hch_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","xɨka xewitɨ Yawé reumawiriemɨkɨni, xeime wakaxi, xeime muxa, meta mawari taipa warɨkariekame, mawari taiyariyari meta mɨyɨhɨritɨani mawariyari, yatɨni kemɨtiyuwaɨriya mawariyari, yatɨni 'ixɨarari patsiekamekɨ memɨyukuxexeɨriwa. Mɨkɨ mawarika witsimu'ɨa Yawé minake, ");
INSERT INTO hch_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","kemɨ'ane yumawari mɨyetuani kanenayatsamɨkɨ hatsite mawariyari, huta kiruyari tɨriku mɨtɨxiyari 'aixɨa mɨ'ane hatseiti xeirituruyarikɨ pɨnariekame. ");
INSERT INTO hch_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Yawé xɨka muxa nunutsi 'utimawirieni mawari taiyariyari mayanikɨ, yaxeikɨata heutinɨkame xeirituruyari kaxie winuyari mɨtayeuriwa. ");
INSERT INTO hch_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","»Muxa 'uki xɨka hɨkɨtɨni, hamatɨana hatsite mawariyari kaniyetuamɨkɨ nauka kiruyari tɨriku mɨtɨxiyari 'aixɨa mɨ'ane, hatseiti xeirituruyari heimana 'imeriyukɨ pɨnariekame. ");
INSERT INTO hch_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","Mɨta'ɨyarienikɨ winu xeirituruyari heimana 'imeriyu. Mɨpaɨ 'anetɨ 'aixɨa 'u'ɨatɨ kanayeimɨkɨ Yawé hetsiemieme. ");
INSERT INTO hch_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","»Xɨka tsikeru xeime peyetuamɨkɨ mawari taiyariyari mayanikɨ, yatɨni kemɨtiyɨhɨritɨa meye'atɨanikɨ, yatɨni 'aixɨa memɨteyuxeiyanikɨ mawariyari Yawé hetsiemieme, ");
INSERT INTO hch_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","tsikeru hamatɨa pekanitimawamɨkɨ hatsite mawariyari, 'ataxewime kiruyari tɨriku mɨtɨxiyari 'aixɨa mɨ'ane huta rituruyari hatseitikɨ pɨnariekame. ");
INSERT INTO hch_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","Yaxeikɨata kaxie winuyari mɨtiyeuriwa huta rituruyari heutinɨkame. Taipa warɨkariekame mawariyari mayanikɨ, mɨkɨ mawarika witsimu'ɨa Yawé minake. ");
INSERT INTO hch_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Yuxexuitɨ wamawarikayari tsikeru, muxa 'uki, muxa temaikɨ, meta tsipu, yapɨtikuwewiwani kemɨre'inɨari. ");
INSERT INTO hch_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Mɨpaɨ pekatiniyurienemɨkɨ yuxexuime wahetsiemieme, tsepa kememɨyupaɨme tewaxi pemɨwayetua. ");
INSERT INTO hch_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","»Kemɨ'ane 'Ixaheri tewiyari mɨtitimawa taipa miemeyaritsie, Yawé 'aixɨa mɨti'ɨkwekɨ, 'ikɨ 'aitsika kehaye'atɨani. ");
INSERT INTO hch_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Yatɨni ku'uwamete xehamatɨa muka yaxeikɨa katiniyurimɨkɨ taipa mawariyari meta 'aixɨa mu'ɨa Yawé hetsiemieme wewimɨkɨni 'ikɨ 'aitsika kehaye'atɨani, ");
INSERT INTO hch_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","xekiekaritsie xewitɨ 'aitsika xeikɨa kaniuyeikamɨkɨ 'ahetsiemieme meta 'ateewa kiekame hetsie 'akiekaritsie muka. 'Ikɨ 'aitsika 'anuiwarima wahetsiemieme kanihɨkɨtɨni. 'Ekɨ meta 'ateewa kiekame yaxeikɨa xekani'aneneni Yawé hɨxie. ");
INSERT INTO hch_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","'Ayumieme mɨkɨ 'aitsika xeyunaime xehetsie katini'aitani 'ahetsie meta kuyeikame hetsie 'ahamatɨa muka». ");
INSERT INTO hch_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Yawé Muitsexi mɨpaɨ katiniutahɨawe ");
INSERT INTO hch_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","'ixaheritsixi mɨpaɨ mɨtiwatahɨawekɨ: «Kepauka kwietsie xemeutahaxɨani hakewa nemɨxehewitɨ, ");
INSERT INTO hch_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","mana mɨretixuxuawere xɨka xetehetikwani, Yawé hetsie timieme xekateneyetuakuni. ");
INSERT INTO hch_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Kepauka matɨari paa peme'imanitsie, mɨtiyetuiwatsie timieme pekaniyetuamɨkɨ, harina 'aixɨa mɨ'ane papayari. ");
INSERT INTO hch_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Yunaitɨ 'anuiwarima mekateniyetuayakuni yemekɨ Yawé hetsiemieme matɨari memɨte'imanitsie timieme. ");
INSERT INTO hch_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","»Mɨpaɨta pɨtiɨyɨwe mɨpaɨ xekateha'eriwatɨ 'axaxepɨte'uyuriwawe, 'inɨari niukiyaritsie Yawé miyetua Muitsexi hetsɨa, ");
INSERT INTO hch_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","naime 'inɨari Yawé mɨxeyetuirie Muitsexi hetsɨa, kepauka mɨpaɨ mutayɨ kename xenuiwari wahetsiemiemetɨni. ");
INSERT INTO hch_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","Xɨka 'axamete'uyurieni yunaitɨ kiekatari mɨpaɨ mekateha'eriwatɨ, hikɨ mɨkɨ xeime tsikeru xeiwiyari hɨkame mekanitataiyakuni witsi'u'ɨakame Yawé minake, kaxie winuyari mɨtayeuriwa heutinɨkame, hatsite mawariyari, xeime tsipu 'uki 'itiya mawariyari mayanikɨ, kemɨre'uxa. ");
INSERT INTO hch_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Hikɨ mawari wewiwame yunaime 'ixaheritsixi kaniwaxɨnamɨkɨ, mekateneuyehɨwiyariekuni memɨka'imakɨ, meta Yawé hetsiemieme mawarika taiyariyari memuwewikɨ meta 'itiya mawariyari memuwewikɨ meta 'axamemɨte'uyuri meka'imaitɨwetɨ. ");
INSERT INTO hch_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Yunaitɨ teɨteri 'ixaheritsixi mekateneuyehɨwiyariekuni, meta 'ateewa kiekatari, yunaitɨ 'axamemɨte'uyurikɨ meka'imaitɨwetɨ yuhetsie. ");
INSERT INTO hch_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","»Xɨka yuxaɨta 'axatiuyurieni ka'imainetɨ, xeime tsipu 'ukaratsi kaniyetuamɨkɨ xeiwiyari hɨkame 'itiya mawariyari mayanikɨ. ");
INSERT INTO hch_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Mawari wewiwame kanixɨnamɨkɨ Yawé hɨxie 'axamɨtiuyuri ka'imainetɨ. Mawari wewiwame yakatiniyurimɨkɨ, hikɨ tewi 'axamɨtiuyuri katineuyehɨwiyariemɨkɨ. ");
INSERT INTO hch_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","'Ikɨ yuxewitɨ xeikɨa 'inɨari yunaitɨ wahetsie kanimiemetɨni kemɨ'ane 'axamɨtiuyuri ka'imainetɨ, 'ixaheri tewiyari hetsiemieme meta 'ateewa kiekame wahamatɨa muka hetsiemieme. ");
INSERT INTO hch_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","»Peru kemɨ'ane 'axamɨtiuyuri mima, tsepa mana munuiwakame yatɨni 'ateewa mɨkiekame, Yawé hɨxie 'axakatiniuyurieni. Mɨkɨ yuteɨterima watsata payeweiyarieni. ");
INSERT INTO hch_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Yuhetsie kanihɨimɨkɨ Yawé niukieya mutananaimakɨ, 'inɨari niukiyaritsie yamɨkatikatɨakɨ». ");
INSERT INTO hch_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Heiwamieme 'uxipiya tukaritsie, 'ixaheritsixi me'uxipiekaku makumawetsie, xewitɨ 'ixaheri kaniuxeiyarieni kɨyexi naiwame 'ɨnetɨ. ");
INSERT INTO hch_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Hikɨ kemɨ'ane memixei meneiwitɨni Muitsexi meta 'Aruni wahetsɨa yunaime 'ixaheritsixi wahɨxie. ");
INSERT INTO hch_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Matɨari kananutahɨiyakatɨni xeikɨa, mɨkahahekɨakaikɨ kememiyurienikekai. ");
INSERT INTO hch_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Hikɨ Yawé Muitsexi mɨpaɨ katiniutahɨawe: «Mɨkɨ tewi ke'umierieni. Yunaitɨ 'ixaheritsixi mekeheitituaxixɨani 'ateewa paitɨ». ");
INSERT INTO hch_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Hikɨ 'ixaheritsixi mematiteitsie 'aheteewakaku mekaneihana, mekaneitituaxixɨani mekanimieni, Yawé Muitsexi kemɨrahɨawekai. ");
INSERT INTO hch_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Yawé Muitsexi mɨpaɨ katiniuta'aitɨani ");
INSERT INTO hch_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","'ixaheritsixi mɨpaɨ mɨtiwatahɨawekɨ: «Xeme xeyunaitɨ xenuiwarima yukamixa 'amɨtɨtɨtsie matawɨre xekanawipaxɨakuni hiru mɨyɨtsikimaɨyekɨ. ");
INSERT INTO hch_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Mɨkɨ matawɨ xekamixatetsie kanixeparewiemɨkɨ xemaye'eriwanikɨ, naime 'inɨari niukiyari Yawé hetsiemieme xemɨkayuwaɨriyanikɨ xe'iyari kemɨtixekuyuitɨwa meta xehɨxite ketita mɨreuhiwe'erie. ");
INSERT INTO hch_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Naime ne'aitsika xekanexeiyakakuni, xekaneye'atɨakakuni. Mɨpaɨ xe'anetɨ neteɨterima memɨpatsie xekanihɨkɨtɨkakuni ");
INSERT INTO hch_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Ne Yawé xekakaɨyari nekanihɨkɨtɨni, nemɨxe'ayewitɨ 'Ekipitu xekakaɨyari nemayanikɨ. Ne Yawé nepɨhɨkɨ». ");
INSERT INTO hch_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Merikɨte Kure 'Itsaxi munu'ayatɨkai, Kuhati mɨteukarieyatɨkai meta Rewi mɨtutsieyatɨkai. Meta xuwenitsixi Ratani meta 'Awirani 'Eriyáwi niwemama meta 'Uni Pereti niweya, ");
INSERT INTO hch_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","mɨkɨ Muitsexi hepaɨtsita mekateniutixatatɨkɨne mewaparewiekaku huta tsienituyari heimana huta tewiyari heimana tamamata 'ixaheritsixi. Yunaitɨ mɨkɨ mekani'uitɨariekaitɨni, memanuyetei 'ixaheritsixi memɨwaranuka'uitɨakai. ");
INSERT INTO hch_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Mekaniuyukuxeɨrieni Muitsexi meta 'Aruni wahepaɨtsita memeuniunikɨ, mɨpaɨ mekateniwarutahɨawe: —Xemeri yemekɨ mamariwawemete xepayuyeitɨa. Xɨka 'ikɨ kiekari patsieka meta kiekatari, ¿titayari xeme Yawé kiekarieya kutsiyarima xetehayuyeitɨwa? ");
INSERT INTO hch_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Kepauka Muitsexi mu'enaxɨ kememutiyuanekai, kaniukatunumakeni ");
INSERT INTO hch_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","mɨpaɨta Kure katiniutahɨawe meta yunaime: —'Uxa'a Yawé yapɨtayɨni kemɨ'ane hetsienamieme mɨpatsie. Mɨkɨ menayexei kanihɨkɨtɨni, mɨkɨ kanita'inimɨkɨ. ");
INSERT INTO hch_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Merikɨte Kure, mɨpaɨ xekateniyurikuni 'uxa'a 'ateɨterima yunaitɨ: 'ɨkwa taiyame xekaniti'ɨikuni, ");
INSERT INTO hch_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","tɨɨ xekanakayatsakuni 'ɨkwa witsimu'ɨa xekenakawiwiexɨa Yawé hɨxie. Kemɨ'ane manayexeiya mɨkɨ kanihɨkɨtɨkamɨkɨ. Xemetɨtɨ Rewi niwemama xepɨhɨkɨ kwinimieme memɨtehanutihu. ");
INSERT INTO hch_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Muitsexi Kure mɨpaɨ katiniutahɨawe: —Hikɨta xekeneneu'eni rewitsixi. ");
INSERT INTO hch_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","¿Kamɨtsɨ tixaɨtɨ xekatehayeitɨa Yawé mɨxe'anayexei 'ixaheritsixi watsata 'ahurawa 'auriena xemu'uwanikɨ, Yawé tukita xemɨte'uximayakakɨ, hipatɨ memɨka'ane wahepaɨ xemɨte'uximayakakɨ? ");
INSERT INTO hch_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Kakaɨyaritɨtɨ yu'aurie kanixeti'uitɨaka, 'ekɨ meta rewitsixi yunaitɨ, ¿hikɨta mawari wewiwamete xetekɨniku? ");
INSERT INTO hch_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","'Ekɨ, 'ateɨterima yunaitɨ xekaniuyukuxeɨrieni Yawé hepaɨtsita 'axaxe'utiyuatɨ, tixaɨtɨ 'Aruni pɨkatihɨkɨ xeminiukima. ");
INSERT INTO hch_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Muitsexi Ratani meta 'Awirani, 'Eriyáwi niwemama katiniwarutanɨ'airieni, peru mɨkɨ mɨpaɨ mekaniutiyuani: —Tame tepɨkahu. ");
INSERT INTO hch_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","¿Kamɨtsɨ tixaɨtɨ pekarayeitɨa pemɨtatsi'ayewitɨ hakewa retsi meta xiete waɨkawa mexuawe, pemɨtatsikwiximenikɨ 'ena makumawetsie ti'aitame pemayuyeitɨanikɨ tahetsie? ");
INSERT INTO hch_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Kaniyuritɨni 'ekɨ pepɨkatatsi 'atɨawe 'akuxi hakewa xeniu retsi meta xiete waɨkawa mexuawe meta kwiepa mɨraka'etsitɨre meta kaxie haraweriyari pepɨkatatsiyetuiriewe. Xɨari tekaheuneniereme pekatani'erieka para temɨmatsi'uweiyanikɨ. Tame matsi tepɨkayehu. ");
INSERT INTO hch_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Hikɨ Muitsexi waɨkawamekɨ ha'atɨ, Yawé mɨpaɨ katiniutahɨawe: —Wamawari pepɨkanaki'erieka tita memɨtehapini, ne xeime nixeime wapiinite nepɨkatiwanawairiewe meta watewama nepɨkatiwakwinitɨa. ");
INSERT INTO hch_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Muitsexi Kure mɨpaɨ katiniutahɨawe: —'Ekɨ meta 'ateɨterima meta 'Aruni 'uxa'a 'ena Yawé hɨxie xekaniti'uikuni. ");
INSERT INTO hch_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Yuxexuitɨ xeme Yawé hɨxie 'ahurawa xekaniɨkɨnikuni 'ɨkwa taiyametsie 'ɨkwa witsimu'ɨa hɨpɨneme xe'u'ɨtɨ, huta tsienituyari heimana huta tewiyari heimana tamamata 'ɨkwa taiyame xe'u'ɨtɨ 'ahurawa xekaniɨkɨnikuni. Meta 'ekɨ 'Aruni hamatɨa yuputsiwiwame xekananu'ɨikuni. ");
INSERT INTO hch_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Hikɨ yuxexuitɨ 'ɨkwa taiyame me'u'ɨtɨ 'ixuriki tukiyari hɨxie mekaniti'uni, Muitsexi meta 'Aruni wahamatɨa. ");
INSERT INTO hch_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Kepauka Kure yunaime yuteɨterima muwarukuxeɨri Muitsexi meta 'Aruni wahepaɨtsita 'axamemɨtiyuanekai 'ixuriki tukiyari hɨxie Yawé yuxawatɨriya kaniuhekɨata mɨkɨ wahɨxie. ");
INSERT INTO hch_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Hikɨ Yawé Muitsexi meta 'Aruni mɨpaɨ katiniwarutahɨawe: ");
INSERT INTO hch_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","―Xekeneutayeixɨa mɨkɨ teɨteri wahamatɨa xepɨkati'uka, ne nekaniwakwimɨkɨ hikɨ. ");
INSERT INTO hch_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Hikɨ Muitsexi 'Aruni hamatɨa kwiepa mekaniukahɨxima'uni, mɨpaɨ mekateniuhiwa: —Yawé, yunaime teɨteri wahetsiemieme pemɨkakaɨyari: xewitɨ xeikɨa tewi 'axapɨtiuyuri, ¿'ekɨta petiyeha'ani yunaime 'ikɨ wahetsiemieme? ");
INSERT INTO hch_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Hikɨ Yawé Muitsexi mɨpaɨ katiniutahɨawe: ");
INSERT INTO hch_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","—Yunaime 'ixaheritsixi mɨpaɨ ketiniwarutahɨawi Kure, Ratani meta 'Awirani waxamaru mati'u mepɨka'ukɨkani. ");
INSERT INTO hch_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Hikɨ Muitsexi meta 'ukirawetsixi 'ixaheritsixi wahetsiemiemete mekanekɨne hakewa memetitekai Ratani meta 'Awirani. ");
INSERT INTO hch_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Hikɨ Muitsexi 'ixaheritsixi mɨpaɨ katiniwarutahɨawe: —'Ikɨ 'axamemɨte'u'iyari waxamaru 'aurie xepɨka'u'uwani. Tixaɨtɨ wapiini xepɨkatekumaɨwani, xemeta kapa xete'ukwinitɨarienikɨ mɨkɨ 'axamemɨte'uyurikɨ. ");
INSERT INTO hch_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Hikɨ teɨteri mekaneutayeixɨani, Kure, Ratani meta 'Awirani waxamaru 'aurie. Ratani meta 'Awirahami 'amemɨtewayekɨ yuxamaru kitenie, mana mekaniti'ukaitɨni yu'ɨitama meta yuniwema mewarawitɨtɨ. ");
INSERT INTO hch_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Muitsexi tawarita mɨpaɨ kaniutayɨni: —Hikɨ xekatenetimaikuni xɨka Yawé netsinɨ'aka yatɨ kenemɨtinekɨhɨawe xeikɨa nepɨtiyuriene. ");
INSERT INTO hch_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Xɨka 'ikɨ teɨteri kwiniyakɨ me'ukwini, 'ana mɨpaɨ katinimatsiɨkɨni kename ne Yawé kanetsiheyenɨ'a. ");
INSERT INTO hch_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Xɨkata Yawé hekwamekɨ yɨkɨ tiuyurieni kwie 'anutayepieni, xɨka wareukakwani meta naime wapiinite, xɨka me'ayenenieretɨ meheukateukieni, hikɨ 'ana mɨpaɨ xekatenetimaikuni kename mɨkɨ Yawé tixaɨtɨ katihɨkɨtɨme me'ayeitɨa. ");
INSERT INTO hch_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Kepauka Muitsexi 'amɨtiutahayewaxɨ, kwie wahetɨa kaneukapene, ");
INSERT INTO hch_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","kaneukaxaware kaniwareukakwani, mɨkɨ meta watɨɨriyama, meta hipatɨ teɨteri Kure tipiinieya naitɨ. ");
INSERT INTO hch_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Me'ayenenieretɨ kwieta mekaneukayune, meta naitɨ tita memɨtehexeyakai, kwie waheimata nanunare. Mɨpaɨ mɨkɨ mekateniukumaweriyarieni 'ixaheritsixi watsata. ");
INSERT INTO hch_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Yunaitɨ 'ixaheritsixi mekaniyuta'unaxɨani mewa'enietɨ mɨpaɨ mete'uhiwatɨ: —Tepɨtinautsa, tameta kwie tatsi'anukakwani. ");
INSERT INTO hch_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Meta mɨkɨ 'ukitsi huta tsienituyari heimana huta tewiyari heimana tamamata 'ɨkwa taiyame memu'ɨkai Yawé taikɨ kaniwarukwini. ");
INSERT INTO hch_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Yawé Muitsexi mɨpaɨ katiniutahɨawe: ");
INSERT INTO hch_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","«'Eriyatsaxi mawari wewiwame mɨpaɨ ketineuta'aitɨa 'Aruni nu'aya, 'ɨkwa taiyamete mɨpatsietɨka mɨ'ɨimiekɨ, mana tɨɨxariyari muyuhayewaxɨ kehewiwieni 'ateewa paitɨ. ");
INSERT INTO hch_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","'Ɨkwa taiyamete keneuti'ɨi 'iya 'axameteyurietɨ memukwi tiwapiini, kɨmana mawari taiyame pekanikawiriemɨkɨ. Mɨkɨtsɨ kanipatsietɨkani, Yawé mɨyetuiriyariekɨ, mɨkɨ 'inɨari 'ixaheritsixi wahetsiemieme mɨhɨkɨtɨnikɨ». ");
INSERT INTO hch_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Hikɨ mawari wewiwame 'Eriyatsaxi mɨkɨ 'ɨkwa taiyamete kaniuku'ɨni, mɨkɨkɨ tepɨa weweritɨ mɨtiwewiyanikɨ katiniuta'aita mawari taiyame heima mɨkawerarienikɨ. ");
INSERT INTO hch_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","Mɨkɨ tepɨa muwa kaniuyuhayewa 'ixaheritsixi memimakaxenikɨ, xewitɨ 'Aruni kaxiɨyarieyatɨtɨ meta mɨpaɨ kati'aitɨarietɨ mɨpaɨ mɨkatiyurienenikɨ Yawé 'ɨkwa witsimu'ɨa mɨkatairiekakɨ, xɨka mɨpaɨ tiuyurieni Kure meta niwemama wahepaɨ mekatenikwikuni, mɨpaɨ katiniuyɨni Yawé Muitsexi kemɨtiuta'aitɨakai. ");
INSERT INTO hch_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","'Uxa'ariekata, yunaitɨ 'ixaheritsixi Muitsexi meta 'Aruni mekaniwarutiniukimatɨkɨne mɨpaɨ me'utiyuatɨ: —Xeme Yawé teɨterimama xekaniwarukwini. ");
INSERT INTO hch_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Teɨteri 'axamemutiyuanekaikɨ Muitsexi meta 'Aruni wahepaɨtsita mɨkɨ mekanekɨne 'ixuriki tukiyarita. Hikɨ yapauka hai tuki kananukanani, Yawé xawatɨriyaya kaniuyuhekɨare. ");
INSERT INTO hch_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Hikɨ Muitsexi 'Aruni hamatɨa mekanewa'uni tuki hɨxie, ");
INSERT INTO hch_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","Yawé Muitsexi mɨpaɨ katiniutahɨawe: ");
INSERT INTO hch_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","—'Ikɨ teɨteri pepɨkawanɨka, ne hikɨ nepɨwatixɨtsitɨani yunaime. Hikɨ mɨkɨ mekaniutihɨxima'uni kwiepa, ");
INSERT INTO hch_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","hikɨ Muitsexi 'Aruni mɨpaɨ katiniutahɨawe: —'A'ukwa taiyame keneuti'ɨka mana tɨɨ kenekayatsaka mawari taiyametsie mieme, muwa 'ɨkwa witsimu'ɨa mana kenekawiwi, kenemie mexɨima hakewa memeyuxeɨrie watsata, mana pemɨwarexɨnakɨ, Yawé haxɨaya kaninuani wahetsie meta 'iwaɨyɨ wahetsie katiniunake. ");
INSERT INTO hch_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","'Aruni yakatinikayani Muitsexi kemɨrehɨawekai, kaniutanautsa teɨteri wahixɨapa mɨtakenikɨ. 'Iwaɨyɨ wahetsie katiniunakekaitɨniri, hikɨ 'Aruni 'ɨkwa witsimu'ɨa kaniutaiya teɨteri kɨmana memɨxɨnarienikɨ. ");
INSERT INTO hch_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Mana memayeneniere meta memɨkwikwi'i watsata kaniutakeni, 'ana kwiniya katiniuhayewa. ");
INSERT INTO hch_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","'Ana tamamata heimana nauka miriyari heimana 'atahuta tsienituyari teɨteri mekaniukwini, meka'inɨaritɨ Kure hamatɨa memukwi. ");
INSERT INTO hch_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Hikɨ kememɨtekwi'ikai heunuaku, 'Aruni kaninuani tuki hɨxie hakewa Muitsexi mekatei. ");
INSERT INTO hch_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Yawé Muitsexi mɨpaɨ katiniutahɨawe: ");
INSERT INTO hch_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","«'Ixaheritsixi mɨpaɨ ketiniwarutahɨawi tamamata heimana huta 'itsɨ mepa'ɨni xeinuiwariyaritsie miemete xexuime. Wa'itsɨtsie mepa'utɨkani kemɨtitewaka nuiwari. ");
INSERT INTO hch_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Rewi 'itsɨyatsie 'Aruni pɨta pekaneu'utɨamɨkɨ, yuxexuitɨ memanuyetei yu'itsɨ mekanexeiyakakuni. ");
INSERT INTO hch_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Tɨratu kakuniyari manuka hɨxie keneuti'uitɨa hakewa xehamatɨa nemɨretixaxata. ");
INSERT INTO hch_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Kemɨ'ane 'itsɨya mɨtayɨra mɨkɨ nemenayexeiya kanayeimɨkɨ. Mɨpaɨ 'ixaheritsixi mekatenihayewakuni menetsi'uximatɨatɨ ke'axamemutiyuane xehepaɨtsita». ");
INSERT INTO hch_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Hikɨ Muitsexi 'ixaheritsixi mɨpaɨ katiniwarutahɨawe, memanuyetei tamamata heimana huta 'itsɨ mekaniyetuaxɨani, xexuime nuiwaritetsie miemete. 'Aruni 'itsɨya wahamatɨa kanayewekaitɨni. ");
INSERT INTO hch_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Muitsexi 'aixɨa katini'uitɨani tukita paitɨ Yawé hɨxie meta tɨratu kakuniyari muyeka hɨxie. ");
INSERT INTO hch_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","'Uxa'arieka ximeri Muitsexi heutahaku tɨratu kakuniyari muyeka, kepauka 'Aruni 'itsɨya muxei Rewi nuiwariyaritsiemieme kaniyɨrakaitɨni 'arimetɨra, 'etsipepetɨ heukatetɨ meta tuturiyari yutakariyari hexeiyatɨ. ");
INSERT INTO hch_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Hikɨ Yawé hɨxie naime 'itsɨte kanewaye'ɨni, 'ixaheritsixi wahɨxie kaniti'uitɨani, memixeiyakɨ kemɨtiuyɨkai, hikɨ yuxexuitɨ yu'itsɨ mekaniuti'ɨni memanuyetei. ");
INSERT INTO hch_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Yawé Muitsexi mɨpaɨ katiniutahɨawe: «Hutarieka 'Aruni 'itsɨya tɨratu kakuniyari hɨxie keneutiketsa, mana mekanixeiyakuni 'axamemutiyuane. Mɨpaɨ mekatenihayewakuni 'axame'utiyuatɨ nehetsiemieme meta 'ixaheritsixi memɨkakwi'inikɨ». ");
INSERT INTO hch_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Muitsexi yakatiniuyurieni Yawé kemɨtita'aitɨakai. ");
INSERT INTO hch_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Hikɨ 'ixaheritsixi Muitsexi mɨpaɨ mekateniutahɨawe: «Tame tekanitatɨmaiyariekuni, yemekɨ tekaneuyewekuni. Tekanikwikuni. ");
INSERT INTO hch_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Yunaitɨ kemɨ'ane Yawé tukieya manuwe memɨye'axe mekanitakukuweni, 'ayumieme tame teyunaitɨ tekanikwikuniri». ");
INSERT INTO hch_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Yawé 'Aruni mɨpaɨ katiniutahɨawe: «Yunaitɨ Rewi xiɨyarimama muwa mɨtipatsietɨka mɨrayepine 'aurie mepɨka'ukɨkani, 'ekɨ meta 'aniwema xehetsie xeikɨa katinahɨiyamɨkɨ, xeme xɨka 'axaxete'uyurieni kemɨkatixe'uximayatsika xemɨmawari wewiwametekɨ. ");
INSERT INTO hch_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Kepauka 'ekɨ meta 'aniwema xemɨte'uximayaka 'ixuriki tukiyarita kakuni tɨratuyari muyeka, xe'iwama Rewi nuiwarimama mekanixeparewiekakuni. ");
INSERT INTO hch_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Mɨkɨ mekameniparewiekakuni kepemɨtiyurieneni, mɨkɨ mekani'ɨwikakuni 'ixuriki tukiyari, 'ahurawa xeikɨa mepɨka'ukɨkani piinite mɨtipatsietɨka 'aurie meta mawari taiyametsie, xemɨkatakukuwenikɨ. ");
INSERT INTO hch_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Mɨkɨ 'aparewiwamete mekanihɨkɨtɨkakuni, tuki mekanixeiyakakuni meta naitɨ muwa kemɨtikumayɨiwa. Merikɨte kepauka xeme xemɨte'uximaya xewitɨ pɨkaxeparewieka mɨpaɨ mɨkaranayexeiyarie. ");
INSERT INTO hch_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","»Xeme xeikɨa xekatenikumaɨwakuni mɨtipatsietɨka meta mawari taiyame hetsie mɨrakapine, nehaxɨa tawarita 'ixaheritsixi nemɨkawakupitɨwanikɨ. ");
INSERT INTO hch_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Mɨpaɨ ketinemaika ne nekatiniuyurieni nemɨwaranayexei, 'ixaheritsixi watsata, 'a'iwama Rewitsixi nemɨmatsiyetuirienikɨ 'imikieri hepaɨ. Mɨkɨ Yawé hetsiemiemeteri mekanihɨkɨtɨni 'ixuriki tukiyarita memɨte'uximayakakɨ. ");
INSERT INTO hch_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","'Ekɨ xeikɨa meta 'aniwema nekanixepitɨaka xemɨmawari wewiwametetɨnikɨ, xemɨtekumaɨwanikɨ mawari taiyametsie timieme meta 'ixuriki meuwie warita timieme. Xeme nekanixepitɨaka xemɨmawari wewiwametetɨnikɨ, kemɨ'ane tawarita 'ahurawa mayani mɨtimaiwetɨkatsie mɨpaɨ katipitɨarietɨ kanimɨmɨkɨ». ");
INSERT INTO hch_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Yawé 'Aruni mɨpaɨ katiniutahɨawe: «Ne nekamatinihɨritɨaka naime mɨtimaiwetɨka 'ixaheritsixi memɨteyetuaya. 'Ekɨ meta 'aniwema nekatinixeyetuirieka xehetsiemieme 'aixɨa mɨti'ane, 'inɨari 'aitsikayari hepaɨ. ");
INSERT INTO hch_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","'Ahetsiemieme katinayeikamɨkɨ piinite kwinimieme mɨtimaiwetɨka mɨkatititaiyarɨwa. 'Ahetsiemieme katinihɨkɨtɨkamɨkɨ 'ixaheritsixi memitimawani hatsite hamatɨa, 'itiya mawariyari meta wahetsie mɨrahɨiwa mawariyari. 'Ikɨ naime memɨnete'atɨirieni waɨkawa mɨtipatsie katinihɨkɨtɨkamɨkɨ 'ahetsiemieme meta 'aniwema. ");
INSERT INTO hch_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Pekatinikwakamɨkɨ waɨkawa mɨtipatsietɨka, mɨpaɨ pekatinimaikamɨkɨ. Yunaitɨ 'ukitsi mekanitikwa'akuni. ");
INSERT INTO hch_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","»Metatsiere mɨtiyetuiwa 'ahetsiemieme katinayeimɨkɨ mawari teikɨ hetserarietɨ 'uyuitɨariwatɨ 'ixaheritsixi memɨteyetuaya. 'Ekɨ meta 'aniwema 'ukitsi 'ukari 'aitsika nekaniwayetuirieni yuheyemekɨ 'amɨtiteriwe. ");
INSERT INTO hch_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","»Matɨari timiemete memɨte'atɨwa Yawé hetsiemieme, nekamaniyetuirieka hatseiti 'aixɨa mɨ'ane, winu mɨhekwa meta hatsite. ");
INSERT INTO hch_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Mɨkɨ kwie matɨari mɨtiutixuaweriyatsiemieme mɨkɨ mekateni'atɨakuni, neta nekameniyetuiriemɨkɨ. Kemɨ'ane tewi mɨ'itiya mitikwani kaniyɨweni. ");
INSERT INTO hch_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","»Naitɨ 'ixaheritsixi Yawé naimekɨ memɨteyetuiriwa 'apiinite katinayeimɨkɨ. ");
INSERT INTO hch_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Yunaitɨ matɨari nuiwakate Yawé hetsiemieme memɨyetuiwa 'ahetsiemieme katinayeimɨkɨ, tsepa tewi yatɨni tewaxi. Peru pekanitawikweitsitɨamɨkɨ matɨari nuiwakame tewi yatɨni tewa 'axɨa mɨka'ane. ");
INSERT INTO hch_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Pekanitawikwetsitɨamɨkɨ kepauka matɨari mieme xeimetseri mexeiyani. Mɨtawikweitsitɨarienikɨ katinaye'akamɨkɨ 'aɨxɨwime pɨrata tuminiyari, kemɨti'inɨata tuki, tamamata heimana xewi kɨramuyari raheteme. ");
INSERT INTO hch_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","»Peru pepɨka'itawikweitsitɨani matɨari mieme tuuru, muxa nu'aya, tsipu nu'aya, mɨkɨ 'aixɨa memɨpatsiekɨ. Xuriyaya mawari taiyametsie pekanitayeurimɨkɨ, wiyarieya pekanitataiyamɨkɨ, 'aixɨa mu'ɨa Yawé hetsiemieme mayanikɨ. ");
INSERT INTO hch_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Waiyarieya 'ahetsiemieme kanayeimɨkɨ, yaxeikɨata tawieya mawariyari teikɨ hetserarietɨ muyuitɨariwa meta teurieya tserietana mieme. ");
INSERT INTO hch_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Ne Yawé nekametiniyetuirieka naime mɨtipatsietɨka 'ixaheritsixi memɨneteyetuirie. Katini'ahetsiemiemetɨni meta 'aniwema 'ukitsi 'ukari, 'aitsika hepaɨ. 'Ikɨ tɨratu 'aixɨa mɨ'ane kanihɨkɨtɨni, mutseyumarie nehɨxie 'unakɨ. Tɨratu nekaniwewieka 'ahamatɨa meta 'anuiwarima wahamatɨa». ");
INSERT INTO hch_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Yawé 'Aruni mɨpaɨ katiniutahɨawe: «'Ekɨ kwietsie tixaɨtɨ pepɨkatipitɨarieni, kwie pepɨkaxatɨarieni 'ixaheritsixi watsata, ne nemɨ'ahetsiemiemekɨ, ne tita pemɨtimikieni nekanihɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","»Rewitsixi nekaniwayetuirieka 'ixuriki tukiyarita memɨte'uximayakɨ, 'ixaheritsixi memɨteyetuaya tamamatatsie mieme xeime. ");
INSERT INTO hch_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","'Ixaheritsixi xɨka 'axamete'uyurieni 'ixuriki tukiyari hɨxie 'ahurawa me'ɨkɨneme mekanikwikuni. ");
INSERT INTO hch_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","'Ayumieme rewitsixi xeikɨa 'ixuriki tukiyarita te'uximayatamete mekanihɨkɨtɨkakuni 'ixaheritsixi wahetsiemieme. Hutarieka 'ikɨ 'aitsika kanihɨkɨtɨni 'umemahu wahetsiemieme: Rewitsixi tixaɨtɨ mekapɨteyetuiriyarieni, ");
INSERT INTO hch_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","ne nemɨtiwayetuirikɨ tamamatatsie mieme 'ixaheritsixi memɨteyetuaya Yawé hetsiemieme xeime. 'Ayumieme mɨpaɨ nekanaineni tixaɨtɨ memɨkateyetuiriyarienikɨ 'ixaheritsixi memɨteyetuiriyarienitsie». ");
INSERT INTO hch_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Yawé Muitsexi mɨpaɨ katiniuta'aitɨani ");
INSERT INTO hch_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","Mɨpaɨ mɨtiwatahɨawekɨ Rewitsixi: «Kepauka xemɨte'anupineni tamamatatsie mieme xeime 'ixaheritsixi memɨteyetuaya, manata xepɨte'anakapini tamamatatsie timieme xeime xemɨneteyetuirienikɨ. ");
INSERT INTO hch_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Xeme xemɨneteyetuirieni tɨriku meripaitɨ mieme hepaɨ nekatinimaimɨkɨ, yatɨni kaxie winuyari witsi'anetɨ mayeika. ");
INSERT INTO hch_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Mɨpaɨ xekateniyuriekakuni nehetsiemieme xekatenanakapinekuni, xemɨteyetuayanikɨ yuhetsiemieme, 'ixaheritsixi memiyetuaya tamamatatsie timieme, mɨkɨ 'Aruni mawari wewiwame xekateniyetuiriwakuni. ");
INSERT INTO hch_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Titakɨ xemɨte'anayexeiyarieni, nehetsiemieme xekateniti'utakuni xemiyetuayanikɨ. 'Aixɨa ti'aneneme tipatsiekame xekaneteniyetuiriwakuni. ");
INSERT INTO hch_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","»Kepauka 'aixɨa ti'aneme xemɨnetexatɨani, mɨkɨ mɨpaɨ pɨtimatsiɨkɨni winu hepaɨ yatɨni 'imɨari hepaɨ. ");
INSERT INTO hch_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Tita mɨtiyuhayewa, mɨkɨ xeme meta xeniwema yunaitɨ tsepa naitsarie xemitikwai pɨyɨweni. Mɨpaɨ xekatenipitɨariekakuni 'ixuriki tukiyari muyepatsieta xemɨte'uximayakɨ. ");
INSERT INTO hch_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Xenetsiyetuiriemeri tamamatatsie mɨranukapiwa, mɨtiyuhayewari pɨkatimaiweni tsepa xemɨtekwa'a. »Xepɨkatetsewiximaka mɨtipatsietɨka 'ixaheritsixi wamawari, xɨka mɨpaɨ xeteyurieka xekanikwikuni». ");
INSERT INTO hch_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Yawé Muitsexi, 'Aruni mame mɨpaɨ katiniwarutahɨawe: ");
INSERT INTO hch_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","«'Ikɨta 'aitɨarika 'inɨari niukiyaritsie kanimiemetɨni ne Yawé nemiyetua: 'Ixaheritsixi wakaxi mekani'atɨakuni heuxetame, 'aixɨa 'aneme katikuyeme, katakwietsanaweme xekaniyetuiriekuni. ");
INSERT INTO hch_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Mawari wewiwame 'Eriyatsaxi xekaniyetuiriekuni, mɨkɨ katinita'aitamɨkɨ mematitei takwayaritsie wakaxi manuyehanienikɨ, hɨxiena kananutixitekiemɨkɨ. ");
INSERT INTO hch_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Hikɨ mawari wewiwame xuriyatsie kameme, 'atahutamexɨa 'ixuriki tukiyaritsie katineu'ɨyamɨkɨ. ");
INSERT INTO hch_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Metatsiere wakaxi hɨxiena mɨtataiyarienikɨ katinita'aitamɨkɨ. Nawiyarieya meta waiyarieya, xuriyaya metatsiere kwitaya kanititaiyariemɨkɨ. ");
INSERT INTO hch_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Hikɨ mawari wewiwame kariuxa xawari kanitihurimɨkɨ meta 'itsupu xawari, metatsiere tuwaxa mɨxetakɨ, mɨkɨ taipa katineuwiwimɨkɨ hakewa wakaxi metaiyarie. ");
INSERT INTO hch_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","'Imatɨrieka mawari wewiwame yupiinite katiniti'ekwamɨkɨ meta kaniti'ɨwamɨkɨ. 'Anake kaninuamɨkɨ mematiteitsie, peru 'akuxi ka'itiyatɨ kaniyuhayewamɨkɨ kepaukake mɨkɨyɨretsie. ");
INSERT INTO hch_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Metatsiere kemɨ'ane wakaxi mutataiyaxɨ kaniyuti'ekwamɨkɨ kaniti'ɨwamɨkɨ, ka'itiyatɨ 'akuxi kaniyuhayewakamɨkɨ kepaukake mɨkɨyɨretsieke. ");
INSERT INTO hch_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","»Xewitɨ tewi 'itiyatɨ wakaxi naxiyari kanikutuimɨkɨ, 'ateewa paitɨ kanenutuimɨkɨ. Muwa kaneikayemɨkɨ naxi 'ixaheritsixi 'itiya mawariyari mematiwewiwatsie meta haa 'aixɨa mɨ'ane mekaninɨitɨakuni. ");
INSERT INTO hch_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Kemɨ'ane wakaxi naxiyari mukutuni, mɨkɨta kaniyuti'ekwamɨkɨ ka'itiyatɨ 'akuxi kaniyuhayewamɨkɨ kepauka mɨkɨyɨretsieke 'itiyatɨ kanayeimɨkɨ. 'Ikɨ 'aitsika yuheyemekɨ pɨhɨkɨtɨnɨ 'ixaheritsixi wahetsiemieme meta 'ateewatari wahamatɨa memɨtitei. ");
INSERT INTO hch_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","»Kemɨ'ane xeime tewi mɨkime mɨmayɨani, mɨkɨ ka'itiyatɨ kanayeimɨkɨ 'atahuta tukari. ");
INSERT INTO hch_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","'Aixɨa puyuyurieni, hairieka tukari 'anukamiekaku meta 'atahutarieka tukaritsie haa 'aixɨa mɨ'anekɨ kaniyu'itimɨkɨ, mɨpaɨ 'itiyatɨ kanayeimɨkɨ xɨka mɨpaɨ katiuyurieni pɨka'itiyani. ");
INSERT INTO hch_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","»Kemɨ'ane mɨki 'umayɨame 'aixɨa mɨkayuyurieni, Yawé tukieya kaninanaimaka. Mɨkɨ tewi kanikumaweriyariemɨkɨ 'ixaheritsixi watsata 'axa'anetɨ muyuhayewaxɨkɨ 'aixɨa mɨkayuyurikɨ haa 'aixɨa mɨtiyuyuruwakɨ. ");
INSERT INTO hch_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","»'Ikɨ 'aitsika kanihɨkɨtɨni kepauka kemɨ'ane 'ixuriki xamaruyaritɨa mɨmɨni: Yunaitɨ kemɨ'ane muwa memeutahaxɨani, yunaitɨ kemɨ'ane muwa memayeteni, 'axamekani'itɨariekakuni 'atahuta tukari. ");
INSERT INTO hch_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Xɨka xarite 'aixɨa kareukunatɨkani naitɨ mɨkɨtsiere ka'itiyatɨ kaniyuhayewamɨkɨ. ");
INSERT INTO hch_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","»Kemɨ'ane mɨki memayɨani yeuta 'uyeikatɨ 'umierieku, yatɨni yɨkɨmana 'umɨku, yatɨni 'umeyari 'umayɨani, yatɨni mɨki teukiya, 'atahuta tukari ka'itiyatɨ kanayeimɨkɨ. ");
INSERT INTO hch_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","»Xeime tewi 'aixɨa muyurienikɨ 'axamɨ'itɨarie, xarita naxi kaniukawiwiemɨkɨ 'itiya mawariyari hetsie, meta haa haixatamieme kaniukatuariemɨkɨ. ");
INSERT INTO hch_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","'Anatari xewitɨ 'aixɨa 'anetɨ 'itsupu kanitihawiyamɨkɨ, xamaruya kanita'ɨyamɨkɨ naime piiniteya meta hamatɨana memɨtitei. Metatsiere kanita'ɨyariemɨkɨ kemɨ'ane 'umete mekumayɨa, yatɨni mɨki teukiya, yatɨni xewitɨ hemierieku, yatɨni yɨkɨmana 'umɨku. ");
INSERT INTO hch_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Tewi mɨ'itiya kaniti'ɨyamɨkɨ hairieka tukaritsie meta 'atahutarieka tukaritsie. 'Atahutarieka tukaritsie tewi mɨka'itiya 'itiyakame kanayeitɨamɨkɨ, mɨkɨ kaniyuti'ekwamɨkɨ kaniti'ɨwamɨkɨ. Mɨpaɨ mɨkɨyɨretsie 'aixɨa 'anetɨ kanayeimɨkɨ. ");
INSERT INTO hch_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Xɨka tewi mɨka'itiya ka'uyu'itieni, kanakumaweriyariemɨkɨ 'ixaheritsixi watsata Yawé tukieya ka'itiyakame mayeitɨakɨ. Mɨkɨ tewi pɨka'itiyaka haa 'aixɨa mɨtiyuyuruwakɨ mɨka'uyu'itikɨ. ");
INSERT INTO hch_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","'Ikɨ 'aitsika yuheyemekɨ pɨhɨkɨtɨni 'ixaheritsixi wahetsiemieme. »Kemɨ'ane haa mɨmayɨani mɨkɨta kaniyuti'ekwamɨkɨ, kemɨ'aneta haa mumayuani 'aixɨa tiyuyuruwame mɨkɨta 'axakani'itɨariemɨkɨ kepaukake mɨkɨyɨre 'anake 'aixɨa kaniyɨmɨkɨ. ");
INSERT INTO hch_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Tewi mɨka'itiya tita mɨtimayɨani mɨkɨta kati'itiyatɨ katinayeimɨkɨ, kemɨ'aneta mɨkɨ mɨmayɨani ka'itiyatɨ kanayeimɨkɨ». ");
INSERT INTO hch_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Yunaitɨ 'ixaheritsixi makumawetsie Tsini mekaniu'axɨani mexɨakame metseriyaritsie, Karetsi rakutewakaku mekanitiyaxe. Mana Miriyami mamɨtsie meta mana kaniukateukieni. ");
INSERT INTO hch_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Mana haa waɨkawa mumawekaikɨ, 'ixaheritsixi mekaniutiniukixietɨkɨne Muitsexi hepaɨtsita meta 'Aruni, ");
INSERT INTO hch_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Muitsexi mɨpaɨ mekateniutatieni: «Yawé kuta ta'iwama wahamatɨa temekwinikɨ mɨtanepitɨakaitɨni. ");
INSERT INTO hch_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","¿Tamɨ tame Yawé tekateteɨterimama? ¿Titayari 'ena makumawetsie petareyewitɨ temɨkwinikɨ tatewama wahamatɨa? ");
INSERT INTO hch_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","¿Titayari 'Ekipitu petarayewitɨ 'ena 'axa'anekɨa petati'atɨa? 'Ena kaniumaweni 'imɨari, piní, kaxie, 'ikwaxi mayehatsiyatɨka, matsi 'akuxi haa tiumawe». ");
INSERT INTO hch_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Muitsexi meta 'Aruni mewaruhayewaka mekanekɨne 'ixuriki tukiyari hɨxie, mana mekaniutihɨxima'uni. Hikɨ Yawé xawatɨriyaya kaniyuhekɨata wahɨxie, ");
INSERT INTO hch_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Yawé Muitsexi mɨpaɨ katiniutahɨawe: ");
INSERT INTO hch_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","«'A'itsɨ keneutikwe'i teɨteri keniwarukuxeɨrieka. Mɨkɨ wahɨxie 'ekɨ meta 'Aruni, 'ai mɨpaɨ xekatenitahɨawikuni haa kehanetɨani. Mɨpaɨ xeteyurieyu haa kananemɨkɨ teɨteri meta tewaxi xekaniwatiharitɨakuni». ");
INSERT INTO hch_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Yawé kemainekai mɨpaɨ Muitsexi katiniuyurieni, 'itsɨ kaniutikweni Yawé hɨxie mutiwekai. ");
INSERT INTO hch_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Hikɨ Muitsexi, 'Aruni hamatɨa teɨteri mekaniwarukuxeɨrieni 'ai hɨxie, Muitsexi mɨpaɨ kaniutayɨni: «Xekeneu'enana, 'axaxemɨte'u'iyari. ¿Kamɨtsɨ teteyɨwawe 'ikɨ 'aitsie haa temanetɨani?» ");
INSERT INTO hch_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Mɨpaɨ 'utayɨka yu'itsɨkɨ 'ai hutakɨa kaniuwani, hikɨ haa kananeni waɨkawa, mana teɨteri meta watewama mekaniutihareni. ");
INSERT INTO hch_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Yawé, Muitsexi 'Aruni mame mɨpaɨ katiniwarutahɨawe: «Nehetsie yuri xemɨkate'eriekɨ, kenemɨtipatsie xemɨka'imatekɨ 'ixaheritsixi wahɨxie, xeme xepɨkahɨkɨtɨni xemɨwaranuwitɨni hakewa kwie nemɨxehexatɨa». ");
INSERT INTO hch_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Mɨkɨ haa mɨpaɨ katinimatiwani, haa manakaxɨrɨwe Meriwa, mana 'ixaheritsixi Yawé memutatikɨ, mana kemɨtipatsie muyuhekɨataxɨkɨ. ");
INSERT INTO hch_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Karetsi 'ukaitɨ Muitsexi kaniwarenɨ'ani texaxatamete ti'aitame 'Erumi kiekame hetsɨa, mɨpaɨ tiwarahɨawetɨ: «Mɨpaɨ 'a'iwa 'Ixaheri kanaineni: “'Ekɨ pepɨtimate kehepaɨ temɨte'uka'eniwa. ");
INSERT INTO hch_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Pepɨrakumate tatutsima 'Ekipitu memekɨ, hakewa mɨixa wiyari teme'uwakai, metatsiere pepɨtimate 'Ekipitu kiekatari kememɨtate'u'uximatɨakai tame meta tapaapama. ");
INSERT INTO hch_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Metatsiere pepɨtimate Yawé ketemɨte'utawawiri tatsi'u'enieka, yuniuki tuayame kataneyenɨ'airieni 'Ekipitu mɨtatsi'ayewitɨ. »”'Enari tekaniuhuni Karetsi, hakewa 'akwie meka'atɨka. ");
INSERT INTO hch_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Mɨpaɨ tematewawirie pemɨtatsipitɨanikɨ 'akwietsie temuyekɨnekɨ. Yurikɨ mɨpaɨ nepaine nixeime 'a'etsaripa mana tepɨkaheuyekɨne meta xeime putsuta tepɨkahetihareni. Huyeta xeikɨa tepɨyehu 'amatayewa 'utɨma, hawaikɨ tekaheukuyuyuipiketɨ kepaukake temanuyekɨne”». ");
INSERT INTO hch_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Hikɨ ti'aitame 'Erumi kiekame mɨpaɨ katineinɨ'airieni: «Hakewa nemɨre'aita 'etsiwatɨma mana xepɨka'uyekɨkani, xɨka mɨpaɨ xeheyɨni, ne nekanayeyeimɨkɨ nekuyaxima newarawitɨtɨ muwa tekanixehetaxeiyakuni». ");
INSERT INTO hch_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","'Ixaheritsixi tawarita mɨpaɨ mekaniutiyuani: «Huye 'amatayewa 'utɨma xeikɨa tepɨyehu, xɨka tatewama yatɨni tame hawaikɨ 'aputsuta tehetihareni tepɨte'ayukatuani. Tame tematsiwawirie xeikɨa mana temuyekɨnekɨ». ");
INSERT INTO hch_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","'Erumi kwieyaritsie ti'aitame haxɨama mɨpaɨ kaniutayɨni: «'Ena xeme xepɨka'uyekɨne». Hikɨ kanayeyani kuyaxi waɨkawa memɨyɨwawe warawɨtɨtɨ, ");
INSERT INTO hch_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","kawapitɨanike kwieyatsie memuyekɨnekɨ. Hikɨ 'ixaheritsixi xaɨtsie pɨta mekaneukanɨ'arieni yamekateha'eriwatɨ. ");
INSERT INTO hch_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Hikɨ yunaitɨ 'ixaheritsixi Karetsi mekanayekɨne Huxi hɨriyaritsie mekaniu'axɨani, ");
INSERT INTO hch_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","'Erumi kwieya mata'atɨkatsie. Mana Yawé Muitsexi meta 'Aruni mame mɨpaɨ katiniwarutahɨawe: ");
INSERT INTO hch_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","«'Aruni 'apɨka'uyeikani 'ena kwiepa 'ari kanimɨmɨkɨ, kwie hakewa 'ixaheritsixi nemɨwarexatɨa mana pɨkaheutahani, xeme xeyuhutatɨ xemɨkanetsi'anu'enikɨ kenemɨxerahɨawekai haa Meriwa maneikakaitsie. ");
INSERT INTO hch_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Hikɨ 'Aruni meta nu'aya 'Eriyatsaxi keniwaranuwitɨki Huxi hɨriyaritsie. ");
INSERT INTO hch_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Mana 'Aruni pekanetikemaripiemɨkɨ mawari wewiwame kamixateya mɨranakatɨkɨ, nu'aya 'Eriyatsaxi pekatinanakatɨtɨamɨkɨ, manari 'Aruni kanimɨmɨkɨ». ");
INSERT INTO hch_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Muitsexi yakatiniuyurieni Yawé kemɨrehɨawekai. Yunaime teɨteri wahɨxie, yuhaikatɨ Huxi hɨriyaritsie mekanitiyune. ");
INSERT INTO hch_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Hikɨ Muitsexi, 'Aruni mawari wewiwame kamixateyari kanenutihɨnirieni, 'Eriyatsaxi pɨta kananakatɨtɨani. Mana hɨritsie 'Aruni kaniɨmɨni. Hikɨ Muitsexi 'Eriyatsaxi hamatɨa hɨritsie mekananakakɨne. ");
INSERT INTO hch_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Kepauka yunaitɨ memɨtehetima kename 'Aruni hemɨkai, xeitewiyari heimana tamamata tukari mekanitsuariwiyatɨwekaitɨni. ");
INSERT INTO hch_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Kepauka kananeu tewiyari mɨti'aitametɨkai 'Arari kiekariyaritsie, Nekexi 'ukaitɨ, katinetimani kename 'ixaheritsixi Hatarimi huyeyari 'utɨa mehahu, kaniwarutakwini hipameta kaniwarutiwiya. ");
INSERT INTO hch_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Hikɨ 'ixaheritsixi mɨpaɨ mekaniutiyuani Yawé hetsiemieme: «Xɨka 'ekɨ teme'iwa yapehaineni mɨtatsi'aye'unie, naime wakiekari tekanika'unakuni». ");
INSERT INTO hch_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Yawé kaniwaru'enieni 'ixaheritsixi kememɨte'iwawiriekai, kaniwarupitɨani kananeutsixi memɨwara'iwakɨ, yunaime teɨteri mekaniwarukwini meta wakiekarite mekaniuka'una. 'Ayumieme mana Kuxima katiniuterɨwarieni. ");
INSERT INTO hch_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","'Ixaheritsixi mekanayekɨne Huxi hɨriyaritsie Haramara Mɨxeta hepatsie me'eerietɨ, 'Erumi kwieyari warita me'ahutɨ. Huyeta me'uhutɨ mepɨkate'unenewi ");
INSERT INTO hch_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","mekaniutiniukixietɨkɨne Kakaɨyari hepaɨtsita meta Muitsexi: —¿Titayari kuta 'Ekipitu xetatehayewitɨ makumawetsie temɨkwinikɨ? 'Ena 'ikwai haa kaniumaweni. 'Ariri ta'iyaritsie katineuyemieni 'ikɨ 'ikwai kwaiyarikɨ. ");
INSERT INTO hch_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","'Ayumieme Yawé kuuterixi memɨmɨya kaniwareyenɨ'airieni memɨwatikenikɨ, 'ana yumɨiretɨ 'ixaheritsixi mekaniukwini. ");
INSERT INTO hch_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","'Ixaheritsixi Muitsexi 'aurie me'ukɨneka mɨpaɨ mekatenitahɨawe: —Yawé hepaɨtsita te'uniukixieka 'axatepɨte'uyuri meta 'ahepaɨtsita. Yawé keneutawawiri kuuterixi mɨwakumaweriyakɨ. Muitsexi wahetsie 'utanuaku, ");
INSERT INTO hch_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Yawé mɨpaɨ katinitahɨawe: —Kuu 'ɨkiyari keneutawewieka, kɨyetsie 'ateewa keneuyeteka. Kemɨ'ane mekukeiwatɨ kwimemixeiya mekanitawikweikuni. ");
INSERT INTO hch_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Muitsexi kuu 'ɨkiyari purunitsekɨ 'utawewieka kɨyetsie 'ateewa kaniyeteni. Kemɨ'ane me'utikeiyaka kuu kwi memukuxexeiyakai meputawikweitsitɨariwakai. ");
INSERT INTO hch_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Hikɨ 'ixaheritsixi mekaniyekɨne 'Uwuti rakutewakaku mekanitiyaxe. ");
INSERT INTO hch_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Manata 'Uwuti memɨyekɨ 'Iye-'Awarini rakutewakaku mekanitiyaxe makumawetsie, Muhawi 'aurie tau makayuyuipike hepatsie. ");
INSERT INTO hch_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Manata memɨyekɨ mayeweritsie Tsereri mekanitiyaxe. ");
INSERT INTO hch_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Manata memɨyekɨ haa 'Axinuni 'anutaɨye mekanitiyaxe, makumawetsie 'amuxeutsixi wakwietsie muyehane. Haa 'Axinuni manuyehane kani'inɨaritɨni muhawitsixi wakwie meta 'amuxeutsixi kwieyari manuye'atɨkatsie. ");
INSERT INTO hch_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","'Ayumieme puyuterɨwanɨa Yawé kemɨtiyutami xapayaritsie: «Haramara Mɨxeta hepatsie, mayeweweritsie meta haa 'Axinuni. ");
INSERT INTO hch_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","Mayeweweri mukɨatsie 'akaniyeuka 'Axi meta Muhawi kwieyari manuye'atɨkatsie». ");
INSERT INTO hch_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Manata memɨyekɨ Wehexi paitɨ, putsu matinieretsie Yawé hakewa Muitsexi mɨpaɨ mɨtiutahɨawixɨ: «Yunaime teɨteri keniwarukuxeɨri ne nekaniwaharitɨamɨkɨ». ");
INSERT INTO hch_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","'Ana yameteyurietɨ 'ixaheritsixi mɨpaɨ mekateniukwika: «Haa kehewatineni. Putsu ke'utakwika. ");
INSERT INTO hch_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Mɨkɨ putsu, te'aitamete yu'itsɨkɨ mepɨwati'inixɨ mariwemekɨ memɨteyurie yu'itsɨkɨ memeiyepikɨ». Makumawetsie memɨyekɨ Matana mekanekɨne, ");
INSERT INTO hch_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","Manata memɨyekɨ Nakarieri mekaniu'axɨani, Nakarieri memɨyekɨ Wamuti mekaniu'axɨani, ");
INSERT INTO hch_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","Wamuti memɨyekɨ Muhawi kwieyaritsie mayeweri mekaniu'axɨani, Pitsikaha hɨriyari manukatsie, Ketsimuni mautahekɨatsie makumawe. ");
INSERT INTO hch_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","'Ixaheritsixi mekaniwarenɨ'ani texaxatamete Tsikuni hetsɨa, 'amuxeutsixi tiwa'aitɨwame, mɨpaɨ metehehɨawetɨ: ");
INSERT INTO hch_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","«Tepɨmatsiwawirie pemɨra'aitatsie temuyekɨnekɨ. Yurikɨ mɨpaɨ tepaitɨka hawaikɨ mɨra'etsietsie tepɨkaheuyekɨne meta putsuta tepɨkahetihareni. Huye 'amatayewa 'utɨa xeikɨa tepuyekɨne, kepaukake temanuyekɨne 'akwieyaritsie». ");
INSERT INTO hch_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Peru Tsikuni pɨkawarupitɨa hakewa mɨra'aita 'ixaheritsixi memuyekɨnekekai. Matsi pɨta yukuyaxima kaniwarukuxeɨrieni watakwinike makumawetsie. Kepauka Yahatsa mɨye'a mekaniwarutiwiya. ");
INSERT INTO hch_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Matsi 'ixaheritsixi mekaniwara'iwa wakwie mekaniwarunawairieni, haa 'Axinuni manuyekatsie ye'atɨkaime haa Kawuki manuye'axetsie ye'atɨkaime, 'amunitsixi wakwie mananiere, kwie 'aixɨa mɨrekukurarutɨiyarietsie paitɨ. ");
INSERT INTO hch_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","'Ixaheritsixi 'amuxeutsixi wakiekaritetsie mekaniye'axɨani, mana wakiekaritsie mekaniyukuhayeikawakaitɨni, metatsiere kiekari Hetsiwuni meta kiekarite 'auriena mamanetɨkateitsie. ");
INSERT INTO hch_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Kiekari Hetsiwuni, Tsikuni kiekarieya 'amɨyewa kanihɨkɨtɨkaitɨni, 'amuxeutsixi tiwa'aitɨwame, meripaitɨ ti'aitame Muhawi kiekame mutamiekai, kwieya minawairiekai haa 'Axinuni manuyekatsie paitɨ ye'atɨkaime. ");
INSERT INTO hch_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","'Ayumieme niuki wewiwamete mɨpaɨ mekaniutiyuaneni: «Ketsuwuni kiekariyaritsie xekenahu, Tsikuni kiekarieyatsie. 'Aixɨa xekeneuyuri. 'Aixɨa xekeneukuyuriexɨa. ");
INSERT INTO hch_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Hetsiwuni kiekariyaritsie tai kanatineni, Tsikuni kiekarieyatsie nerɨkwari kanatinexɨani. Muhawi kiekariteya naime kaniutixɨtsitɨani 'Axinuni hatɨayari hɨriyari manuye'atɨka. ");
INSERT INTO hch_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Muhawi 'ahetsiemieme xɨa'ui nepaine. Pekani'uniniri, Kemuxi kiekarieya. 'Akakaɨyari 'aniwema kaniwareutaweiyaxɨani 'aniwema 'ukari Tsikuni paitɨ mɨwaranuhapanikɨ, 'amuxeutsixi tiwa'aitɨwame wahetsɨa. ");
INSERT INTO hch_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","»Yunaime tekanixe'uka'una, Hetsiwuni ye'atɨkaime meta Riwuni paitɨ ye'akame. Yunaime Nupa paitɨ tekanixe'uxɨrietɨkɨne, tekanixe'uka'una Merewa paitɨ xeye'atɨkaime». ");
INSERT INTO hch_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Mɨpaɨ mekateniuyaxe 'ixaheritsixi 'amuxeutsixi wakwieyaritsie. ");
INSERT INTO hch_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Muitsexi katiniuta'aita kwie Katsexi memuxeiyayukɨ, 'ixaheritsixi kiekari mamanetɨka mekaniwarutakwini, 'amuxeutsixi mekaniwarutaweiya mana memɨkiekai. ");
INSERT INTO hch_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Me'akunuaxɨaka, Watsani huyeyari mekaniuwiya. Mana ti'aitame 'Uhuki, Watsani kiekame kaniwaranukunake yukuyaxima warawitɨtɨ watakwinike 'Erurehi mɨrakutewatsie. ");
INSERT INTO hch_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Hikɨ Yawé Muitsexi mɨpaɨ katiniutahɨawe: «Pepɨkawamakaka, 'Uhuki nekanixeyetuiriemɨkɨ kuyaximama, meta kwieya naime. Tsikuni kepemeyuri 'amuxeutsixi tiwa'aitɨwame Hetsiwuni kiekame mɨpaɨta pekatiniyurimɨkɨ». ");
INSERT INTO hch_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Mɨpaɨ mekatenimieni 'ixaheritsixi 'Uhuki ti'aitame meta niwemama, kuyaximama, nixeime mepɨka'uhayewaxɨ 'ayeniereme, mɨpaɨ kwie mekatena'iwa. ");
INSERT INTO hch_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","'Ixaheritsixi tawarita mekaniyekɨne, mayeweritsie Muhawi mekaniuyuhayewa, Kurutani 'anutaɨye, Keriku hɨxie. ");
INSERT INTO hch_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Kepauka Waraki Tsipuxi nu'aya mɨretima 'ixaheritsixi 'amuxeutsixi kememɨwaruyuriekai, ");
INSERT INTO hch_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","muhawitsixi 'ixaheritsixi mekaniwarutimakani. Kwinie yemekɨ mekatenimamakaitɨni kwinimieme memɨyupaɨmekaikɨ. ");
INSERT INTO hch_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Hikɨ muhawitsixi 'ukirawetsixi Mariyani kiekatari mɨpaɨ mekateniwarutahɨawe: «'Ikɨ mɨya memɨyupaɨme ta'aurie mɨrahane naime mekatenixɨkuni, wakaxi 'ɨxa kemɨrakumaweriya hepaɨ». 'Ana mana Waraki tsipuxi nu'aya katini'aitametɨkaitɨni Muhawi kwieyaritsie, ");
INSERT INTO hch_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","'ayumieme Warami katiniutanɨ'airieni Wehuxi nu'aya, Petuxi paitɨ mukatei, 'Eupɨrata hatetsitayaritsie, 'amawitsixi wakwieyaritsie. Waraki mɨpaɨ mekateneinɨ'airieni: «Hipatɨ teɨteri mepu'axɨa 'Ekipitu mehanexɨaka, hikɨ naime kwie mepukunama, hikɨta ne'aurie mekaniu'axɨani. ");
INSERT INTO hch_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Waɨkawa nemetsiwawirie pemamiekɨ 'ikɨ 'axapemɨwayurienikɨ nehetsiemieme, waɨkawa pemɨtɨrɨkaɨyekɨ. Mɨpaɨke newara'iwake nepɨne'erie 'ateewapai newaranunɨ'ame. Ne mɨpaɨ nepɨtimate kemɨ'ane 'aixɨa pemuyurieni 'aixɨa'itɨarietɨ payeika, kemɨ'aneta 'axapemuyurieni 'axa'itɨarietɨ payeika». ");
INSERT INTO hch_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Hikɨ 'ukirawetsixi Muhawi meta Mariyani kiekatari Warami mekatenekuxatɨani Waraki kemainekai, mekaniu'axɨani tumini me'a'ɨtɨ mete'ipitɨanike xɨka ya'utayɨnike 'ixaheritsixi 'axamɨwayurienikɨ. ");
INSERT INTO hch_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Warami kaniwaruta'inieni mana memɨtihenikɨ, mɨpaɨ tiwarahɨawetɨ kename 'uxa'ariekake tiwataxatɨanikekai Yawé kemɨtitahɨawekekai. Hikɨ 'itsɨkate mana mekanitiheteitɨni. ");
INSERT INTO hch_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Kakaɨyari Warami hetsɨa kaniuyuhekɨata mɨpaɨ katinitahɨawe: —¿Kemɨ'ane mepɨyɨa mɨkɨ teɨteri 'akie memɨtihe? ");
INSERT INTO hch_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Warami mɨpaɨ kaniutayɨni: —Texaxatamete mekaniyɨaka Waraki Tsipuxi nu'aya mɨwareyenɨ'a, ti'aitame Muhawi kwieyaritsie. Kaniwareyenɨ'ani memɨnetetaxatɨanikɨ: ");
INSERT INTO hch_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","“Teɨteri 'Ekipitu kiekatari kwie hikɨ 'ena naime mekanikunaka. Kenamieka 'axakeniwaruyuri nehetsiemieme. Mɨpaɨke xɨari nepɨyɨwe newakwinetɨ nemɨwarutaweiya nekwietsie”. ");
INSERT INTO hch_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Kakaɨyari Warami mɨpaɨ katiniutahɨawe: —Pepɨkayemie wahamatɨa meta pepɨkawakewaiyaneni 'ixaheritsixi, kiekari 'aixɨa memu'itɨarie mekanihɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","'Uxa'arieka Warami 'anukukeka 'itsɨkate mɨpaɨ katiniwarutahɨawe Waraki mɨwareyenɨ'a: «Xekenakunuaxɨa yukie, Yawé pɨka'inake xehamatɨa nemeumienikɨ». ");
INSERT INTO hch_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Memanuyetei muhawitsixi mekanakunuaxɨani hakewa Waraki mekatei, mɨpaɨ mekatenitahɨawe: «Warami pɨkaheyuwaɨri tahamatɨa mamiekɨ». ");
INSERT INTO hch_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Waraki tawarita kaniwarenɨ'ani 'itsɨkate matsi meyuwaɨkawame, waɨkawa memauka'u, ");
INSERT INTO hch_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","meheta'axɨaka mɨpaɨ Warami mekateniutahɨawe: —Waraki Tsipuxi nu'aya mɨpaɨ kanetaineni: “Yemekɨ tixaɨtɨkɨ pepɨkarekununuwani pemɨnetsi haxeiyamiekɨ, ");
INSERT INTO hch_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","ne nekamatinipitɨamɨkɨ waɨkawa perexeiyatɨ pemayanikɨ, tsepa tita pemɨnetiutawawiri ne yanekatinikayeimɨkɨ. Waɨkawa nekamaniwawirieka pemamiekɨ 'ikɨ teɨteri 'axapemɨwayurienikɨ nehetsiemieme”. ");
INSERT INTO hch_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Warami mɨpaɨ kaniutayɨni: —Tsepa Waraki yuparatsiyu mɨnetiyetuiri hurute meta pɨratate tihɨneme, ne 'atsinepɨkatiyurieni 'etsitipeme yatɨni timariweme, matsi Yawé nekakaɨyari kemɨti'aita yanepɨtiyurieneni. ");
INSERT INTO hch_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Xemeta hikɨ tɨkarikɨ 'ena xekenetiheni, ne Yawé 'akuxi nepɨta'iwawiya kemɨnetitahɨawe. ");
INSERT INTO hch_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Mɨkɨ tɨkarikɨ Kakaɨyari kaniyuhekɨata Warami hetsɨa: «Metsɨ 'ikɨ teɨteri mekameniku'inietɨweni, kenemietsɨ wahamatɨa, xeikɨatsɨ ne kenemerekɨhɨaweni yapekatinekamiemɨkɨ». ");
INSERT INTO hch_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","'Uxa'arieka ximeri Warami kananukukeni, yupuxu kaniutixiratɨani, hikɨ kaneyani 'itsɨkate muhawi kiekatari wahamatɨa. ");
INSERT INTO hch_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Hikɨ wahamatɨa 'umiekaku Kakaɨyari kaniuyeha'ani, huyetana kaniutakeni Yawé niuki tuayameya, ka'ipitɨanike mana muyeyanikɨ. Warami 'anakaitɨ kaniumiekaitɨni yupuxutsie meta hamatɨana yuhutatɨ mekaniuhukaitɨni 'iparewiwamete. ");
INSERT INTO hch_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Kepauka puxu Yawé niuki tuayameya muxei 'ixipara 'akwekame, huye kaniuku'eirieni xaɨtsie kaneukuyune. Hikɨ Warami kanikuwaxɨani huyeta mɨyemiekɨ. ");
INSERT INTO hch_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Yawé niuki tuayameya hetsimanuyewatsie kaniukeni, kaxie haraweriyari makumanetsie, mɨkɨ tetexikɨ kanikurarutɨariekaitɨni naitsarie. ");
INSERT INTO hch_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Kepauka puxu Yawé niuki tuayameya muxei, kwi hurawa tetsariyatsie kaniukuyani Warami yu'ɨkatsie katiniukwine. Hikɨ tawarita Warami kaniwani. ");
INSERT INTO hch_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Yawé niuki tuayameya kananuyeyerɨni xaɨtsie paitɨ kaniukeni kwi manuyewatsie, hakewa mɨkaheyɨwe xaɨtsie meukuyune. ");
INSERT INTO hch_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Kepauka puxu Yawé niuki tuayameya muxei, kaniukahuni Warami 'anakaiku. Hikɨ Warami kaniuyeha'ani kɨyekɨ yupuxu kaniukuwaxɨani. ");
INSERT INTO hch_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Hikɨ Yawé puxu kaniupitɨani mɨtaniunikɨ, hikɨ mɨkɨ mɨpaɨ Warami katiniutahɨawe: —¿Kekuta ne nematsi'uyuri, titayari haikakɨa penetiukuwaxɨa? ");
INSERT INTO hch_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Warami mɨpaɨ katinitahɨawe: —Penetsinanaimatɨ pepumie. Xɨka 'ixipara nehakwekake, nekameniumienikeri. ");
INSERT INTO hch_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Puxu Warami mɨpaɨ katiniutahɨawe: —¿Netsɨ 'apuxu nepɨhɨkɨ nehetsie pemɨkuyerɨne, hɨkɨa mɨreukayunetsie? ¿Kepauka mɨpaɨ nematsiheyuri? Warami mɨpaɨ kaniutayɨni: —Nekatixaɨtsietɨ. ");
INSERT INTO hch_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","'Ana Yawé yuniuki tuayame kaniuhekɨata 'ixipara hakwekame Warami mixeiyakɨ. Warami kwiepa paitɨ kaniutihɨximakeni. ");
INSERT INTO hch_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Yawé niuki tuayameya kanita'iwawiya: —¿Titayari haikakɨa 'apuxu petiukuwaxɨa? ¿Pekatimate ne nematsikunuitɨanike 'ena nemunuakɨ, nemixeiyakɨ kepemɨtimie 'aixɨa mɨka'anekɨ? ");
INSERT INTO hch_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Kepauka puxu mɨnetsihexei, haikakɨa hukaniuyune. Xɨka mɨkɨ mɨpaɨ kaheyɨnike, 'ekɨri pekanimɨkinike, mɨkɨta rayenierenike. ");
INSERT INTO hch_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Warami Yawé niuki tuayameya mɨpaɨ katiniutahɨawe: —'Axanepɨtiuyuri. Mɨpaɨ nepɨkaretima kename nehuye pe'anunarɨmakai. Kamɨtsɨ xɨka 'aixɨa kane'ane, nekanikunuamɨkɨ. ");
INSERT INTO hch_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Niuki tuayame Yawé hetsɨa mieme mɨpaɨ katinitahɨawe: —Kenemie wahamatɨa, keni'akweriwayurieka, ne kenemarekuhɨaweni mɨpaɨ xeikɨa pekanetainemɨkɨ. Hikɨ Warami kaneyani Waraki mɨwareyenɨ'a wa'ukiyarima wahamatɨa. ");
INSERT INTO hch_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Kepauka Waraki mɨretima kename Warami 'uhamiekai, kanayeyani 'enukunakeke xeime muhawi kiekariyaritsie kwie manu'axetsie haa manuyekatsie 'Axinuni. ");
INSERT INTO hch_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Waraki Warami mɨpaɨ katiniutahɨawe: —¿Tamɨ ne nekamatiutanɨ'airi? ¿Titayari nehetsɨa pekatinua? ¿Nekamarakapitɨaweme peti'erie? ");
INSERT INTO hch_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Warami mɨpaɨ Waraki katiniuta'eiya: —'Ari, 'ena nekaniuyeikani. Kepauka Kakaɨyari xeikɨa mɨpaɨ mɨnetikuhɨaweni yaneputaineni. ");
INSERT INTO hch_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Mana memɨyekɨ Warami meta Waraki mekanekɨne, Kiriati-Kutsuti hepatsie. ");
INSERT INTO hch_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Waraki wakaitsixi kaniwarutimawa meta muxatsi, mekaniwarutikwani Warami hamatɨa meta 'itsɨkate wahamatɨa memu'uwakai. ");
INSERT INTO hch_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","'Uxa'arieka Waraki Warami kanewitɨni Wamuti-Wahari hɨriyari 'amanutitewatsie, hakewa 'ixaheritsixi memetitekai 'etsiwa mɨwaxeiyakɨ. ");
INSERT INTO hch_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Warami, Waraki mɨpaɨ katiniutahɨawe: «'Atahutame mawarite taiyame keneutiwewi meta 'atahutame tsikerutsixi meta 'atahutame muxatsi 'ukitsi». ");
INSERT INTO hch_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Waraki yakatiniuyurieni Warami kemɨrehɨawekai, yunaitɨ mekanitimawa xeime tsikeru meta xeime muxa 'ukitɨme mawari taiyame xexuimetsie. ");
INSERT INTO hch_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Hikɨ Warami, Waraki mɨpaɨ katiniutahɨawe: «'Ena keneuyuhayewa, 'amawari taiyariyari 'aurie, 'akuxi ne Yawé nepeta'iwawiya kemaineni. Yareutewitɨta nekametinitaxatɨamɨkɨ kemɨneretahɨawe». Hikɨ yemuri metsekametsie kaneutimiekaitɨni. ");
INSERT INTO hch_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Kakaɨyari kanenukunake, Warami mɨpaɨ katiniutahɨawe: —'Atahutame mawari taiyame nekaniutiwewieni xexuimetsie xeime tsikeru xeime muxa 'uki nekaniutimawa. ");
INSERT INTO hch_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Hikɨ Yawé Warami katiniutaxatɨani, mɨpaɨ katinitahɨawe: —Kenakunua Waraki hetsɨa kenemɨtayɨni mɨpaɨ ketinetahɨawi. ");
INSERT INTO hch_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Warami kanakunuani Waraki kaniutaxeiya 'a'uweme yumawari taiyariyari 'aurie muhawitsixi tewa'aitɨwamete wahamatɨa. ");
INSERT INTO hch_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Warami mɨpaɨ katinikuxatakaitɨni: «'Arami paitɨ, tau manatineika hɨri hepatsie, Waraki kaneneyewitɨni, ti'aitame Muhawi kiekame hetsɨa. Mɨpaɨ kanetiniutahɨawe: “Kenamieka, Kakuwu 'axakeneuyuri nehetsiemieme. Kenamieka, 'Ixaheri 'axakeneuyuri”. ");
INSERT INTO hch_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","¿Titayari 'axanetiwayurieneni kemɨ'ane Kakaɨyari 'axamɨkawayurie? ¿Keneyɨme 'axanepɨwayurieni Yawé mɨpaɨ mɨkatiwara'eriya? ");
INSERT INTO hch_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","'Ai 'amanutitewitsie paitɨ nepuwataxeiya, hɨri 'ametitɨtɨtsie paitɨ nepɨwaxeiya: teɨteri memanayexeiyarie mepɨhɨkɨ, mepɨka'inɨatsie 'ena kwiepa miemete wahamatɨa. ");
INSERT INTO hch_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","¿Kemɨ'ane pɨyɨwe Kakuwu nuiwarimama mɨwaruti'inɨata, tumuanari hepaɨ memuyupaɨme, yatɨni tsikere yayupaɨmeme mɨwaruti'inɨata 'Ixaheri nuiwarimama? 'Aixɨa mɨtiuka'iyari hepaɨ ne'anetɨ neke'umɨni. Wahepaɨ netiyurienetɨ neke'ukumawere». ");
INSERT INTO hch_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Hikɨ Waraki, Warami mɨpaɨ katiniutahɨawe: —¿Kepenetsi'uyuri? Nekamani'atɨani 'axapemɨwayurienikɨ memɨnetsi'aye'unie wahetsiemieme, matsi pɨta 'aixɨa petiwayurie. ");
INSERT INTO hch_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Hikɨ Warami mɨpaɨ katinita'eiya: —¿Kamɨtsɨ nekatiyɨwe Yawé kemɨnerahɨawe mɨpaɨ nemutayɨni? ");
INSERT INTO hch_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Hikɨ Waraki mɨpaɨ katinitahɨawe: —Neuxei, hikɨmɨ xaɨtsie pɨta. Manata xeitapari xeikɨa pekaniwarexeiyamɨkɨ, yunaime hawaikɨ, mana hɨrixɨa 'axapekaniwareyurimɨkɨ. ");
INSERT INTO hch_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Hikɨ mekanekɨne Tsupini hɨriyaritsie Pitsikaha mɨtitewatsie. Mana mawari taiyame 'atahutame kaniutiwewieni, xexuimetsie xeime tsikeru xeime muxa 'uki mekaniutimawa. ");
INSERT INTO hch_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Mana Warami Waraki mɨpaɨ katiniutahɨawe: «'Ena keneuyuhayewa 'amawari taiyariyari 'aurie, 'akuxi ne Kakaɨyari hamatɨa nepɨretaxata». ");
INSERT INTO hch_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Yawé Warami 'anukunakeka yuniuki kaniyetuirieni mɨpaɨ katinitahɨawe: «Waraki hetsɨa kenakunua, kenemɨtayɨni mɨpaɨ ketinetahɨawi». ");
INSERT INTO hch_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Warami kaneyani hakewa Waraki mekatei, kanitaxeiya 'a'uwekame yumawari taiyariyari 'aurie meta muhawitsixi 'ukirawetsixi wahamatɨa. Waraki mɨpaɨ katinita'iwawiya: —¿Yawé kehetayɨ? ");
INSERT INTO hch_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Hikɨ Warami katiniutaxata: «Kenanukukexi, Waraki, keneu'ena, Tsipuxi nu'aya, keneneu'eni. ");
INSERT INTO hch_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Kakaɨyari mɨmɨwe pɨkahɨkɨ mɨkati'itawa meta mɨka'ikupata. Katinaye'atɨwani kemɨtayɨni yakatinikamieni. ");
INSERT INTO hch_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Mɨpaɨ kanetinahɨaweni 'aixɨa nemɨwayurienenikɨ, xɨka Kakaɨyari mɨpaɨ tinakeni, ketsɨkuta tawarita netiyurieneni. ");
INSERT INTO hch_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","»Kakaɨyari Kakuwu pɨkaxeiya 'axatiyurieneme 'Ixaheri pɨkatiuyukananaima. Yawé wakakaɨyari wahamatɨa puyeika, wahamatɨa ti'aitame puyuxata. ");
INSERT INTO hch_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Kakaɨyari 'Ekipitu kaniwarayewitɨni tuuru kemɨtitɨrɨkaɨye hepaɨ. ");
INSERT INTO hch_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Kakuwu hetsɨa 'ikewari pumawe, meta 'Ixaheri hetsɨa 'awie memɨte'uyemate mepɨkaxuawe. Kakuwu meta 'Ixaheri wahepaɨtsita mɨpaɨ katinitaniukiemɨkɨ: “Xeketeneuxeiya Kakaɨyari 'aixɨa kemɨtiuyuri”. ");
INSERT INTO hch_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","'Ikɨ teɨteri, xeimieme mekanixatani maye 'uka hepaɨ, mɨkɨ maye 'uki mɨtikuwaɨne hepaɨ. Pɨkaka'uxipieni tita mɨtikuweiyane 'i'axemeke mɨwakwini waxuriya ha'iemeke». ");
INSERT INTO hch_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Hikɨ Waraki, Warami mɨpaɨ katiniutahɨawe: —Xɨka 'axapekawayurimɨkɨ, kamɨtsɨ tsikere 'aixɨa pepɨkawayurieka. ");
INSERT INTO hch_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Warami mɨpaɨ kaniutayɨni: —¿Ne tamɨ mɨpaɨ nekamerahɨawekai, kename ne Yawé kemɨnetitahɨawekekai yanetiyurienikekai? ");
INSERT INTO hch_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Hikɨ Waraki, Warami mɨpaɨ katiniutahɨawe: —Hikɨmɨ neuxei, xaɨtsie pɨta nepɨmatsi'anuwitɨni. Heiwatɨ mana Kakaɨyari 'inakeni 'axapemɨwayurienikɨ. ");
INSERT INTO hch_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Hikɨ Warami kanewitɨni Pehuxi hɨriyaritsie paitɨ, makumawetsie Ketsimuni mahekɨatsie. ");
INSERT INTO hch_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Mana Warami mɨpaɨ katinitahɨawe: —'Ena keneneutiwewiri 'atahutame mawari taiyame meta keniwarukuha'aritɨa 'atahutame tsikerutsixi meta muxatsi 'ukitsi. ");
INSERT INTO hch_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Waraki yakatiniuyurieni Warami kemɨrehɨawekai, mana kaniwarutimawa 'atahutame tsikerutsixi meta muxatsi 'ukitsi. ");
INSERT INTO hch_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Hikɨ kepaukua Warami mɨpaɨ mɨretima Yawé minakekai 'Ixaheri 'aixɨa muyuriekakɨ, hikɨ pɨkawarukewaiyaxɨ, meripaitɨ hepaɨ, matsi tawarita makumawetsie kaneutaniere. ");
INSERT INTO hch_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Kepauka Warami meutanierixɨ 'ixaheritsixi kaniwaruxeiya kememɨteheunuiwari mɨpaɨ meteheukuteme, hikɨ Yawé 'iyarieya hetsiena kaninuani, ");
INSERT INTO hch_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","hikɨ mɨpaɨ kaniutayɨni: «Warami niukieya Wehuxi nu'aya, tewi niukieya 'aixɨa mɨti'ane mɨtixeiya. ");
INSERT INTO hch_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","Niukieya mɨ'enie Kakaɨyari kaniniukieyatɨni, Naimekɨmɨtɨrɨkaɨye mɨtixeiya, mukakukutsutsie hepaɨ mɨtikuxaxatɨariwa. ");
INSERT INTO hch_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","»Kakuwu, 'axamarute witsipɨ'anene. 'Ixaheri, witsipɨtiyuxexeiya pemanukatsie. ");
INSERT INTO hch_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","'Aki muyehapane hepaɨ pɨtiyuxexeiya manuyunanake, tuturi hatetsita mɨ'iteɨritsie hepaɨ pɨtiyuxexeiya, 'aruhe 'iteɨriyari Yawé mika'iteɨtaxɨ hepaɨ, kariuxa hatetsita mɨti'u hepaɨ pɨ'anene. ");
INSERT INTO hch_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Xariteya haa panakayeuriwe, 'imɨarieya puyutemawie haa waɨkawa mexeiyakɨ. Ti'aitame pɨmariwe 'Akaki reuyeta, mariwetɨ 'aitsikaya payuyeitɨwa. ");
INSERT INTO hch_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","»Kakaɨyari 'Ekipitu kaniwarayewitɨni tuuru tsimaruni mɨtitɨrɨkaɨye hepaɨ. 'Ixaheri nuiwarite memeye'unie kaniwatikwa'ani, wa'umete kanititarani, yu'ɨrɨkɨ kaniwatimɨmɨni. ");
INSERT INTO hch_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Maye 'uki hepaɨ kanakatutsitani, maye 'ukaratsi hepaɨ 'akaniuhupuni: ¿kemɨ'ane ka'ukamatɨ piyehaxɨatɨawe? 'Aixɨa meke'itɨarieka 'aixɨa memɨmatsiyurie. 'Axameke'itɨarieka 'axamemɨmatsiyurie». ");
INSERT INTO hch_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Hikɨ Waraki kaniuyeha'ani Warami hepaɨtsita, yumamatetsie heuyɨtɨminatɨ mɨpaɨ katinitahɨawe: —Nekametiniutanɨ'airieni 'axapemɨwayurienikɨ nemɨwaraye'unie, hikɨri hairieka matsi 'aixɨa petiwayurie pɨta. ");
INSERT INTO hch_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Tsepa hikɨ kenemie 'akie. Ne mɨpaɨ nepɨmarahɨawekai kename nematipitɨanikekai, peru mɨkɨ Yawé pɨkamatiutanaki'eriri. ");
INSERT INTO hch_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Warami mɨpaɨ katinitahɨawe: —Ne mɨpaɨ nepɨtiwarahɨawekai netsi'iniwamete pemɨwarenɨ'a: ");
INSERT INTO hch_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","“Tsepa Waraki yuparatsiyu hurukɨ meta pɨratakɨ hɨneme mɨnetiuxatɨa, ne 'aixɨa nepɨkatiuyuriwe meta 'axanepɨkatiuyuriwe, matsi Yawé nekakaɨyari xeikɨa 'aitsikaya kemaine mɨpaɨ nepɨ'aneni. Yawé xeikɨa kemɨneti'aitɨa mɨpaɨ nepɨtiyurieneni”. ");
INSERT INTO hch_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Hikɨ mexi neka'akunuawe nekie, nepɨmatitaxatɨani 'ikɨ kiekari 'ateɨterima kemɨwayurieni 'uxa'atɨni warie haye'ayu. ");
INSERT INTO hch_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Hikɨ Warami mɨpaɨ kaniutayɨni: «Warami niukieya Wehuxi nu'aya, tewi 'aixɨa mɨti'ane mɨtixeiya niukieya. ");
INSERT INTO hch_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","Niukieya mɨ'enie Kakaɨyari kaniniukieyatɨni. 'Amutewi kemɨtiku'eriwa mɨmate, Naimekɨmɨtɨrɨkaɨye mɨtixeiya, mukakukutsutsie hepaɨ mɨtikuxaxatɨariwa: ");
INSERT INTO hch_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","»Nekanixeiyani, peru hikɨ 'akuxi hawaikɨ, nekanixeiyani, peru 'ahurawa hawaikɨ. Kakuwu xuraweya kananatinemɨkɨ, xewitɨ ti'aitame 'Ixaheri hetsie kananukukemɨkɨ. Muhawi mu'uya kanitapɨnamɨkɨ meta Tseti niwemama wamu'ute. ");
INSERT INTO hch_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","'Erumi kana'iwariemɨkɨ, Tsehixi meye'unie, tipiinieya katinayeimɨkɨ, mexi 'Ixaheri yukuha'aritɨwani, mariwemekɨ mɨtiyurienikɨ. ");
INSERT INTO hch_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Kakuwu nuiwarieyatsie xewitɨ rayu'iwatɨ kanitinemɨkɨ, 'Ahixi kiekatari memuyuhayewaxɨ kaniwatayuniyamɨkɨ». ");
INSERT INTO hch_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Warami 'Amareki 'uxeiyaka mɨpaɨ kaniutayɨni: «'Amareki mexɨakame nuiwari kanihɨkɨtɨni, peru 'imatɨrieka naitɨ kanika'unariemɨkɨ». ");
INSERT INTO hch_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Hikɨ Warami kenitsixi waruxeiyaka mɨpaɨ kaniutayɨni: «Tsepa kuraru 'aixɨa 'aneme pemateka meta tsepa 'a'itua 'aitsie paitɨ makama, ");
INSERT INTO hch_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","'ekɨri Kahini, taipa pekaneyani, meta 'Atsiriya kamenanuhanimɨkɨ». ");
INSERT INTO hch_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Hikɨ Warami mɨpaɨ kaniutayɨni: «Xɨa'ui, ¿kemɨ'anetsɨ kuta pɨtawikweni kepauka Kakaɨyari mɨpaɨ mɨtiyurieni? ");
INSERT INTO hch_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Kanuwate 'amɨpapa kani'axɨakuni Tsipɨre manexɨani, 'Atsiriya meta 'Ewexi memɨtewakwinitɨanike, mɨkɨ yaxeikɨa mekanika'unariekuni». ");
INSERT INTO hch_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Mɨpaɨ titaxatɨaka Warami kaneyani yukwiepa paitɨ, yaxeikɨata Waraki yuhuyeta kaneyani. ");
INSERT INTO hch_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Kepauka 'ixaheritsixi Tsitini memɨtitekai, 'ukari muhawitsixi wahamatɨa mekaniutihitɨkɨne, ");
INSERT INTO hch_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","mɨkɨ mekaniwa'iniekaitɨni wakakaɨyarixi mawari memɨwawewiriekakɨ. 'Ixaheritsixi mɨkɨ kakaɨyarixi wahɨxie mekateniutikwa'akaitɨni meta wahɨxie mekaniutitunuma'uwekaitɨni. ");
INSERT INTO hch_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Wahari-Pehuxi mehayexeiyatɨ mekanayuyeitɨwakaitɨni. 'Ayumieme Yawé kaniuyeha'ani. ");
INSERT INTO hch_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Hikɨ Yawé Muitsexi mɨpaɨ katiniutahɨawe: «Yunaime 'ixaheritsixi wa'ukiyarima keniwarukawɨtɨa 'utukakaku, nemɨhaxɨapienikɨ 'ixaheritsixi nemɨkatiwakwinitɨanikɨ». ");
INSERT INTO hch_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Muitsexi mɨpaɨ katiniwarutahɨawe 'ixaheritsixi wa'itsɨkate: «Xekeniwarukuya kemɨ'ane Wahari-Pehuxi me'ayexeiyatɨ memakɨ». ");
INSERT INTO hch_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","'Ixaheritsixi me'utitsuanakaku 'ixuriki tukiyari mɨranutahakitɨretsie, 'ixaheri tewiyari xeime 'uka mariyani tewiyari kani'atɨani, Muitsexi nierekaku meta yunaitɨ teɨteri 'ixaheritsixi, yu'iwama kaniwarutahɨawitsitɨani. ");
INSERT INTO hch_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Hikɨ 'uniereka mawari wewiwame Pinexi 'Eriyatsaxi nu'aya 'Aruni teukarieya. Teɨteri waruku'eirieka pitsika 'amɨtewi 'akwetɨ kaneyani, ");
INSERT INTO hch_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","mɨkɨ tewi kananukuweiya, xamarutana kaneutahani kaniwarutimɨni 'uki 'ixaheri meta 'uka. Mɨpaɨ tiuyɨku 'ixaheritsixi kememɨtekwi'ikai katineuyunuani. ");
INSERT INTO hch_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","'Ana mɨkɨ kwiniyakɨ xeitewiyari heimana nauka miriyari (24.000) mekaniukwini. ");
INSERT INTO hch_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Yawé Muitsexi mɨpaɨ katiniutahɨawe: ");
INSERT INTO hch_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","«Pinexi, 'Eriyatsaxi nu'aya meta 'Aruni teukarieya, mɨkɨ katiniuyurieni nehaxɨa manukanuitɨa, ne newakwerietɨ kenemɨrehɨawekai mɨpaɨ katiniuyurieni. 'Ayumieme ne'ɨtetsarikakɨ 'ixaheritsixi nepɨkawaruka'unaxɨ. ");
INSERT INTO hch_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Pinexi mɨpaɨ ketineutahɨawi tɨratu temɨwewienikɨ ne nemikuhɨawenikɨ, ");
INSERT INTO hch_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","yukɨmana mɨkɨ meta nuiwarimama mawari wewiwamete yuheyemekɨ mepɨhɨkɨtɨni, nehetsie mutanuakɨ 'ɨtetsatɨ, meta 'ixaheritsixi wahetsie 'itiya mawariyari muwewikɨ». ");
INSERT INTO hch_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Tewi mumierie 'uka mariyani tewiyari hamatɨa, Tsimɨri katinitewakaitɨni Tsaru nu'aya, manuyeka kanihɨkɨtɨkaitɨni Tsimehuni xeime nuiwarieyatsie mieme. ");
INSERT INTO hch_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","'Uka mariyani tewiyari Kutsiwi katinitewakaitɨni, Tsuxi kaninu'ayatɨkaitɨni, manuyeka Mariyani xeime nuiwaritsie mieme. ");
INSERT INTO hch_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Yawé Muitsexi mɨpaɨ katiniutahɨawe: ");
INSERT INTO hch_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","«Mariyanitsixi xekeniwaretakuya keniwarekuya, ");
INSERT INTO hch_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","mɨkɨ memɨxe'utakwikɨ mexete'irɨwiyatɨ, Wahari-Pehuxi hetsɨa memɨxeye'atɨakɨ, kemuyɨ Kutsiwi manuyeka Mariyani niweya mumɨ, kepauka memɨkwi'ikaitsie Wahari Pehuxi hekɨ». ");
INSERT INTO hch_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Merikɨte 'ixaheritsixi mɨyamete'ukwiku reutiyetana, Yawé Muitsexi mɨpaɨ katiniutahɨawe meta mawari wewiwame 'Eriyatsaxi 'Aruni nu'aya: ");
INSERT INTO hch_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","«Xekeniwaruka'utɨa 'ixaheritsixi yunaime waniwema kemɨ'ane memɨwa'ukiyarima. Xekeniwaraka'utɨa xeitewiyari wiyari memɨhɨtɨka huteikɨ meutiyune, kuyakɨ 'aixɨa memɨ'anene 'ixaheritsixi wahetsiemiemekɨ». ");
INSERT INTO hch_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Muitsexi meta 'Eriyatsaxi hamatɨa, yunaime teɨteri wahamatɨa mekateniutaxata mayeweri Muhawi kwieyaritsie, haa Kurutani manuyeka 'aurie, Keriku hɨxie, mɨpaɨ mekateniwaruta'aitɨani ");
INSERT INTO hch_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","memɨwaraka'utɨanikɨ 'ukitsi xeitewiyari wiyari meutiyune memexeiyatɨka, Yawé Muitsexi kemɨrahɨawekai. 'Ixaheritsixi 'Ekipitu memɨyekɨ 'ikɨ mekanihɨkɨtɨkaitɨni: ");
INSERT INTO hch_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","6","Xuweni niwemama 'Ixaheri matɨarieya: 'Enuki, Paru, Ketsiruni meta Karimi, mɨkɨ wanuiwari mekanihɨkɨtɨni: 'enukitsixi, parutsixi, ketsirunitsixi meta Karimitsixi. ");
INSERT INTO hch_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Mɨkɨ mekanihɨkɨtɨni Xuweni nuiwarimama. Yunaitɨ mekanihɨkɨtɨkaitɨni huta tewiyari heimana haika miriyari, heimana 'atahuta tsienituyari, heimana xeitewiyari heimana tamamata (43.730) teɨteri. ");
INSERT INTO hch_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Paru nu'aya 'Eriyawi yuxewitɨ xeikɨa kanayani. ");
INSERT INTO hch_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","'Eriyawi niwemamata mekanakɨne: Nemuheri, Ratani meta 'Awirani, me'anayexeiyariekatɨtɨ teɨteri wahetsiemiemekɨ, Muitsexi meta 'Aruni mekaniutiniukimani kepauka Kure mɨwa'iniekai kepauka 'axamɨtiuyuri Yawé hɨxie. ");
INSERT INTO hch_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Kepauka kwie mɨwareukakwai Kure yunaime, meta kemɨ'ane memeweiyakai. Tai kaniwarutitaiya huta tsienituyari, heimana huta tewiyari heimana tamamata teɨteri, mɨpaɨ tawari memɨkayɨakakɨ katiniuyɨni. ");
INSERT INTO hch_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Matsi Kure niwemama mepɨka'ukwi. ");
INSERT INTO hch_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","13","Nemuheri nuiwarimama, Kamini, Tsera meta Tsahuri, Tsimehuni niwemama, Wanuiwari mekanihɨkɨtɨni: nemuheritsixi, kaminitsixi, tseratsixi meta tsahuritsixi. ");
INSERT INTO hch_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","'Ikɨ mekanihɨkɨtɨni Tsimehuni nuiwarimama. Yunaitɨ mekanakɨne xeitewiyari heimana huta miriyari heimana huta tsienituyari (22.200) teɨteri. ");
INSERT INTO hch_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","17","Tsepuni, Kaki, Tsuni, 'Utsini, 'Eri, 'Aruri meta 'Areri, 'ikɨ Kahari niwemama mekanihɨkɨtɨni, 'ikɨta wanuiwarima: tsepunitsixi, kawuhitsixi, tsunitsixi, 'utsinitsixi, 'eritsixi, 'aruritsixi meta 'areritsixi. ");
INSERT INTO hch_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","'Ikɨ Kahari nuiwarimama mekanihɨkɨtɨni. Yunaitɨ mekanakɨne huta tewiyari miriyari heimana 'auxɨwi tsienituyari (40.500) teɨteri. ");
INSERT INTO hch_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","20","'Exi meta 'Unani Kura mepɨniwemama, Kanani mɨkɨ mekaniukwini. Tseraxi, Paretsi meta Tseratsi wanuiwari mekanihɨkɨtɨni: tseraxitsixi, paretsixi meta tserahitsixi. ");
INSERT INTO hch_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Paretsi niwemama, Ketsiruni meta Kamuri, wanuiwari mekanihɨkɨtɨni ketsirunitsixi meta kamuritsixi. ");
INSERT INTO hch_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Mɨkɨ Kura mekaninuiwarieyatɨni. Yunaitɨ mekanakɨne haika tewiyari heimana tamamata heimana 'ataxewime miriyari heimana 'auxɨwi tsienituyari (76.500) teɨteri. ");
INSERT INTO hch_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","24","'Itsakaxi niwemama, Tura, Puwa, Yatsuwi meta Tsimiruni, wanuiwari mekanihɨkɨtɨni: turahitsixi, puwitsixi, yatsuwitsixi meta tsimirunitsixi. ");
INSERT INTO hch_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Mɨkɨ 'Itsakaxi nuiwarimama mekanihɨkɨtɨni. Yunaitɨ mekanakɨne haika tewiyari heimana nauka miriyari heimana haika tsienituyari (64.300) teɨteri. ");
INSERT INTO hch_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Tsawuruni niwemama, Tsereri, 'Eruni meta Yareri, wanuiwari mekanihɨkɨtɨni: tserenitsixi, 'erunitsixi meta yareritsixi. ");
INSERT INTO hch_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","'Ikɨ Tsawuruni nuiwarimama mekanihɨkɨtɨni. Yunaitɨ mekanakɨne haika tewiyari miriyari heimana 'auxɨwi tsienituyari (60.500) teɨteri. ");
INSERT INTO hch_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Kutse niwemama, Manatsexi meta 'Epɨrahini, wanuiwari mekanihɨkɨtɨni: ");
INSERT INTO hch_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Manatsexi niwemama, Makixi meta Karaha, Makixi nuiwarimama mekanihɨkɨtɨni, makiritsixi meta Karaha nuiwarimama. ");
INSERT INTO hch_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","32","Karaha niwemama, Ketsexi, Kere, 'Atsirieri, Tsikeni, Tsemira meta Hepexi, wanuiwari mekanihɨkɨtɨni: ketseritsixi, kerekitsixi, 'atsiriheritsixi, tsikenitsixi, tsemirahitsixi meta heperitsixi. ");
INSERT INTO hch_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Tserupekari Hepexi nu'aya 'ukitsi pɨkawarutinuari 'ukari xeikɨa, mekatenitetewakaitɨni, Makira, Nuha, Kukɨra, Mirika meta Tiritsa. ");
INSERT INTO hch_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","'Ikɨ Manatsexi wanuiwari mekanihɨkɨtɨni. Yunaitɨ mekanakɨne huta tewiyari heimana tamamata heimana huta miriyari heimana 'atahuta tsienituyari (52.700) teɨteri. ");
INSERT INTO hch_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","'Epɨrahini niwemama, Tsutera, Wekexi meta Takani, wanuiwari mekanakɨne, tsuterahitsixi, wekeritsixi meta takanitsixi. ");
INSERT INTO hch_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Tsutera nu'aya 'Erami, nuiwarieya mekanihɨkɨtɨni, 'eramitsixi. ");
INSERT INTO hch_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","'Ikɨ mekanihɨkɨtɨni 'Epɨrahini nuiwarimama. Yunaitɨ xeitewiyari heimana tamamata heimama huta miriyari heimana 'auxɨwi tsienituyari (32.500) teɨteri mekanakɨne. 'Ikɨ yunaitɨ nuiwarite Kutse hetsie mekaniyekɨne. ");
INSERT INTO hch_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","39","Wenikamini niwemama, Wera, 'Atsiweri, 'Akirani, Tsupani meta Kupani, mekaniwanuiwaritɨni: werahitsixi, 'atsiweritsixi, 'akiranitsixi, tsupanitsixi meta kupanitsixi. ");
INSERT INTO hch_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Wera niwemama 'Axi meta Nahamani, wanuiwari mepɨhɨkɨ 'aritsixi meta namanitsixi. ");
INSERT INTO hch_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","'Ikɨ Wenikamini wanuiwari mekanihɨkɨtɨni. Yunaitɨ mekanakɨne huta tewiyari heimana 'auxɨwi miriyari heimana 'ataxewime tsienituyari (45.600) teɨteri. ");
INSERT INTO hch_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Rani nu'aya Tsukani nuiwarieya tsukanitsixi mepɨhɨkɨ, mɨkɨ xeikɨa mekanihɨkɨtɨkaitɨni Rani nuiwarieya. ");
INSERT INTO hch_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Haika tewiyari heimana nauka miriyari heimana nauka tsienituyari (64.400) teɨteri mepɨhɨkɨtɨkai. ");
INSERT INTO hch_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","'Atsexi niwemama 'Imɨna, 'Itsiwi meta Weriya, wanuiwarima mepɨhɨkɨ: 'imɨnatsixi, 'itsiwitsixi meta weriahitsixi. ");
INSERT INTO hch_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Weriya niwemama Hewexi meta Marikiheri wanuiwari mepɨhɨkɨ: heweritsixi meta marikieritsixi. ");
INSERT INTO hch_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","'Atsexi xeimeta 'uka kanayexeiya Tsera titewakame. ");
INSERT INTO hch_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","'Ikɨ 'Atsexi wanuiwari mekanihɨkɨtɨni. Yunaitɨ mekanakɨne huta tewiyari heimana tamamata heimana haika miriyari heimana nauka tsienituyari (53.400) teɨteri. ");
INSERT INTO hch_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","49","Nepɨtahari niwemama Yatseri, Kuni, Ketsexi meta Tsireni, wanuiwari mekanihɨkɨtɨni: yatseritsixi, kunitsixi, ketsexitsixi meta tsirenitsixi. ");
INSERT INTO hch_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","'Ikɨ mekanihɨkɨtɨni Nepɨtahari nuiwarimama. Yunaitɨ mekanakɨne huta tewiyari heimana 'auxɨwime miriyari, heimana nauka tsienituyari (45.400) teɨteri. ");
INSERT INTO hch_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Yunaitɨ teɨteri 'ixaheritsixi 'ataxewime tsienituyari heimana xeimiriyari, heimana 'atahuta tsienituyari heimana xeitewiyari heimana tamamata (601.730) mekaniyupaɨmekaitɨni. ");
INSERT INTO hch_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Yawé Muitsexi mɨpaɨ katiniutahɨawe: ");
INSERT INTO hch_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","«Kwie keniwayetuiri 'inɨaritɨkaime 'ikɨ nuiwarite wahetsiemieme mɨhɨkɨtɨnikɨ. Keyupaɨmetɨ memaka'utɨarie mɨpaɨ meyupaɨmeme keniwaruxatɨa. ");
INSERT INTO hch_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Kemɨ'ane nuiwari memɨyumɨire 'ayeukame pekaniwayetuiriemɨkɨ, kemɨ'ane nuiwari 'etsimemɨyupaɨmeni, 'etsiyeukame pekaniwaxatɨamɨkɨ. Yuxexuitɨ nuiwari yamekatenimikiekuni keyupaɨmetɨ memaye'uka. ");
INSERT INTO hch_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Kwie 'inɨarikɨ mekanita'iwakuni nuiwari wa'ukiyarima kememɨtetetewakai. ");
INSERT INTO hch_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Mekaniyuta'iwakuni yunaitɨ nuiwarite wahetsie, 'etsimemɨyupaɨme meta 'amemɨyupapaɨme wahamatɨa». ");
INSERT INTO hch_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Rewitsixi Keritsuni, Kuhati meta Merari, wanuiwari mepɨhɨkɨtɨkai keritsunitsixi, kuhatitsixi meta meraritsixi. ");
INSERT INTO hch_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Rewitsixi wanuiwaritsie memɨyekɨ mepɨhɨkɨta: Riwinitsixi nuiwariyari, hewurunitsixi nuiwariyari, Makiri nuiwarimama, Muhutsi nuiwarimama meta Kure nuiwarimama. Kuhati 'ukiyarieya 'Amirani pɨhɨkɨtɨkai. ");
INSERT INTO hch_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","'Amirani 'ɨyaya Kukaweri pɨtitewakai 'ukiyarieya Rewi pɨhɨkɨtɨkai, 'Ekipitu putinuiwakai. Tɨɨri mepɨwarayexei 'Amirahami hamatɨa mekanihɨkɨtɨni 'Aruni, Muitsexi meta wa'iwa 'uka Miriyami. ");
INSERT INTO hch_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","'Aruni Narawi puwapaapatɨkai, 'Awihu, 'Eriyatsaxi meta 'Itamaxi. ");
INSERT INTO hch_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Narawi 'Awihu hamatɨa mekaniukwini Yawé hɨxie taipa 'axa'aneme memɨte'itimawirikɨ. ");
INSERT INTO hch_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Rewitsixi xeimetseri memexeiyatɨka mana meutiyune yunaitɨ xeitewiyari heimana haika miriyari (23.000) mekanakɨne. Hipatɨ 'ixaheritsixi wahamatɨa mepɨka'u'inɨatsie, wahepaɨ memɨkateyetuiriyarienikekaikɨ. ");
INSERT INTO hch_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","'Ikɨ mekanihɨkɨtɨni 'ixaheritsixi Muitsexi mɨwaruti'inɨataxɨ meta 'Eriyatsaxi hamatɨa, mayeweri Muhawi kwieyaritsie, haa Kurutani manuyehane 'aurie, Keriku hɨxie. ");
INSERT INTO hch_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Meripaitɨ makumawetsie Tsinahi Muitsexi 'Aruni hamatɨa memɨwaraka'utuakai, xewitɨ pɨka'ayemiekai hekwamekɨ memaka'utsietsie, ");
INSERT INTO hch_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Yawé mɨpaɨ mutayɨkaikɨ kename yunaitɨ mekwinikekai. Mekaniyuhayewaxeikɨa Karewi, Kepune nu'aya, meta Kutsuhexi Nuni nu'aya, tawarita xewitɨ pɨka'utawikwei. ");
INSERT INTO hch_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Makira, Nuha, Kukɨra, Mirika meta Tiritsa Manatsexi nuiwarimama hetsie menimiemetetɨkaitɨni Kutse nu'aya, 'ukari Tserupekari niwemama mekanihɨkɨtɨkaitɨni Hepexi nu'aya, Karaha nu'aya, Makixi nu'aya meta Manatsexi nu'aya. Hikɨ mɨkɨ meyu'auxɨwitɨ mekanekɨne ");
INSERT INTO hch_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","'ixuriki tukiyari manuwetsie, Muitsexi meta mawari wewiwame 'Eriyatsaxi wahamatɨa metetaxatake meta memanuyetei wahamatɨa. Hikɨ mɨpaɨ mekateniwarutahɨawe: ");
INSERT INTO hch_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","«Tapaapa kanemɨni 'ukitsi kawatinuariwetɨ, Kure mɨnɨkaikɨ pɨka'uyɨ Yawé hepaɨtsita mauniukakaikɨ. Kaniumɨni makumawetsie yukɨmana 'axakemɨtiyurienekaikɨ. ");
INSERT INTO hch_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","¿Kamɨtsɨ metehayeyeitɨarieni nuiwarimama tapaapa kemɨtitewa 'ukitsi mɨkawarutinuarikɨ? Tame tekaniniwemamatɨni. Ketaneyetuiri kwie tapaapa 'iwamama wahamatɨa». ");
INSERT INTO hch_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Muitsexi Yawé kaniuta'iwawiya kememɨtehehɨawekai, ");
INSERT INTO hch_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Yawé mɨpaɨ katinita'eiya: ");
INSERT INTO hch_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","«Kememaitɨka Tserupekari niwemama 'aixɨa kani'aneni, 'ayumieme keniwayetuiri wahetsiemieme wapaapa 'iwamama wahepaɨ. Wapaapa mɨhetsiemiemetɨkai mɨkɨ keniwaruxatɨa. ");
INSERT INTO hch_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","»Metatsiere 'ixaheritsixi mɨpaɨ ketiniwarutahɨawi: “Kepauka xewitɨ tewi mɨmɨni 'uki katinuariwetɨ, 'uka pɨta katinanupimɨkɨ. ");
INSERT INTO hch_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Xɨkata mɨkɨ 'uka ka'utinuarieni, 'iwamama pɨta mekatenanupikuni. ");
INSERT INTO hch_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Xɨka 'uki ka'uti'iwatakaitɨni, paapaya 'iwamama mekatenanupikuni. ");
INSERT INTO hch_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Xɨka paapaya kareka'iwaka, Xewitɨ 'ahurawa 'iwaya katinanupimɨkɨ hetsiena mieme mɨrayanikɨ. Mɨpaɨ 'ixaheritsixi mekatenikahukuni 'aitsika mɨheitserie kanihɨkɨtɨkamɨkɨ, ne Muitsexi kenemɨtiuta'aitɨa”». ");
INSERT INTO hch_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Yawé Muitsexi mɨpaɨ katiniutahɨawe: —'Awarini hɨriyaritsie paitɨ kenemie, mana keneuxeiya kwie 'ixaheritsixi nemɨwayetuirieni. ");
INSERT INTO hch_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Hikɨ 'ari pe'ixeiyame, pekanimɨmɨkɨ pekaniyemieni 'apaapama wahetsɨa 'a'iwa 'Aruni hepaɨ. ");
INSERT INTO hch_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","Makumawe Tsini mɨrakutewatsie, kepauka teɨteri 'axamemutiyuanekai, xeme xeyuhutatɨ xepɨkanetsi'anu'eni, kepauka haa tetetsie xemanetɨa, teɨteri wahɨxie mɨpaɨ xepɨkatehetima kenemɨtipatsie. Mɨkɨ haa Meriwa mɨtitewa Karetsi paitɨ katine'aneni, Tsini makumawetsie. ");
INSERT INTO hch_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Muitsexi Yawé mɨpaɨ katiniuta'eiya: ");
INSERT INTO hch_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","―Yawé, yunaime teɨteri wakakaɨyari, xeime keneutahɨawi manuyekanikɨ 'ikɨ teɨteri wahetsiemieme, ");
INSERT INTO hch_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","mɨwaruwitɨximenikɨ hakewa memetiyaxe, mɨwaranuwitɨnikɨ memuyukwiyutsie meta mɨwarakunuitɨanikɨ wakie. Mɨpaɨ Yawé 'ateɨterima muxatsi memɨka'ukutsiyari hepaɨ mepɨkateyuxexeiyani. ");
INSERT INTO hch_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Yawé Muitsexi mɨpaɨ katiniutahɨawe: —Kutsuhexi Nuni nu'aya xekenayeitɨa, mɨkɨ yu'iyarikɨ 'aixɨa katiniyɨkɨhɨaweni. Hetsiena keneutime'i, ");
INSERT INTO hch_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","mawari wewiwame 'Eriyatsaxi hɨxie kene'atɨa meta yunaime teɨteri wahɨxie. Hikɨ yunaime wahɨxie mɨti'aitanikɨ pekaniyetuiriemɨkɨ. ");
INSERT INTO hch_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Pekatinihɨritɨamɨkɨ 'ekɨ kepemɨti'aitakai, mɨpaɨ yunaitɨ 'ixaheritsixi memei'eniekakɨ. ");
INSERT INTO hch_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Hikɨ mawari wewiwame 'Eriyatsaxi hetsɨa kaniye'amɨkɨ, yamɨtayɨnikɨ 'inɨari wewietɨ 'urimi meta tumimi hekɨ Yawé kanitahɨawimɨkɨ. Kepauka Kutsuhexi mɨta'inieni memuyukwiyukɨ, yunaitɨ teɨteri mekaniyehuni hamatɨana, meta kepauka mɨta'inieni memakunuaxɨanikɨ, mɨkɨta mekanakununuwakuni. ");
INSERT INTO hch_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Muitsexi yakatiniuyurieni Yawé kemɨtita'aitɨa. Kutsuhexi 'uta'inieka mawari wewiwame 'Eriyatsaxi hɨxie kanei'inieni meta yunaime teɨteri wahɨxie. ");
INSERT INTO hch_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Hikɨ heimana kaneutimeni hɨritɨarika kaniyetuirieni, mɨpaɨ katiniuyurieni Yawé kemɨtita'aitɨakai. ");
INSERT INTO hch_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Yawé Muitsexi mɨpaɨ katiniutahɨawe: ");
INSERT INTO hch_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","«Mɨpaɨ ketiniwarutahɨawi 'ixaheritsixi memɨkatehatɨtɨmaiyanikɨ kemɨ'ane tukaritsie memɨnete'utimawiriwanikɨ. Mɨkɨ mawari taiyarikayari witsimu'ɨa mɨkɨ ne'ikwai kanihɨkɨtɨni. ");
INSERT INTO hch_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","»Mɨpaɨta ketiniwarutahɨawi 'ixaheritsixi, mawari taiyarika hetsiemieme, yamepɨnete'atɨiriwani xexuime tukaritsie mawari taiyariyari yareuyuhanemekɨ yuhutame muxatsi xeiwiyari mehɨtɨkaime 'aixɨa me'anenekame. ");
INSERT INTO hch_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Xeime ximeri pekanitimawamɨkɨ, xeimeta taikai, ");
INSERT INTO hch_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","meta wahamatɨa huta kiruyari tɨriku mɨtɨxiyari 'aixɨa mɨ'ane hatseitikɨ pɨnariekame pekanitimawamɨkɨ. ");
INSERT INTO hch_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","'Ikɨ mawari taiyariyari yamɨreuyuhane kanihɨkɨtɨni, kenemɨtixekɨhɨawekai Tsinahi hɨriyaritsie taiyarika mawarikayaritsie, witsimu'ɨa Yawé minake. ");
INSERT INTO hch_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Yuxexuime muxatsi wahetsie xeirituruyari kaxie winuyari mɨtiyeuriyani mawariyari heutinɨkame kaniyetuamɨkɨ, tukita Yawé minake hetsiemieme kanitiyeuriyamɨkɨ. ");
INSERT INTO hch_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Hutarieka mieme muxa taikai pekanitimawamɨkɨ, hatsite mawarikayari hamatɨa meta winu hatuiyariyari ximeri pemitimawaxɨ hepaɨ. Taiyarika mawarikayari kanihɨkɨtɨni, Yawé minake 'ɨakariyari. ");
INSERT INTO hch_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","»Xawatikɨ pekaniwarutim