﻿USE sofia;
DROP TABLE IF EXISTS sofia.hchNT_vpl;
CREATE TABLE hchNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES hchNT_vpl WRITE;
INSERT INTO hchNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","'Inüari canihücütüni 'icü. Nuivarite mecani'inüarini, Quesusi Cürisitu que mü'ane müxiüyarieyatücai. Raviri canitusieyatücaitüni, 'Apurahami meta. ");
INSERT INTO hchNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","'Apurahami 'Isahaqui cani'uquiyarieyatücaitüni. 'Isahaqui meta Cacuvu pü'uquiyarieyatücai. Cura pü'uquiyarieyatücai, 'ivamamata. ");
INSERT INTO hchNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Cura meta Parexi Sara püva'uquiyaritücai, Tamari vavarusitücacu. Parexi Hesirumi pü'uquiyarieyatücai. Hesirumi 'Arami pü'uquiyarieyatücai. ");
INSERT INTO hchNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","'Arami 'Aminaravi pü'uquiyarieyatücai. 'Aminaravi Nahasuni pü'uquiyarieyatücai. Nahasuni Sarumuni pü'uquiyarieyatücai. ");
INSERT INTO hchNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Sarumuni Puhuxi pü'uquiyarieyatücai, Xahavi varusieyatücacu. Puhuxi Huveri pü'uquiyarieyatücai, Xuti varusieyatücacu. Huveri Quisahi pü'uquiyarieyatücai. ");
INSERT INTO hchNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Quisahi Raviri pü'uquiyarieyatücai, que mü'ane cuiepa müti'aitametücai. Raviri Sarumuni pü'uquiyarieyatücai, heitivitüca que mü'ane Huriyaxi mü'üyayatücai. ");
INSERT INTO hchNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Sarumuni Xupuhami pü'uquiyarieyatücai. Xupuhami 'Aviyaxi pü'uquiyarieyatücai. 'Aviyaxi 'Asa pü'uquiyarieyatücai. ");
INSERT INTO hchNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","'Asa Cusapati pü'uquiyarieyatücai. Cusapati Curami pü'uquiyarieyatücai. Curami 'Usiyaxi pü'uquiyarieyatücai. ");
INSERT INTO hchNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","'Usiyaxi Cutami pü'uquiyarieyatücai. Cutami 'Acaxi pü'uquiyarieyatücai. 'Acaxi 'Esequiyaxi pü'uquiyarieyatücai. ");
INSERT INTO hchNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","'Esequiyaxi Manasexi pü'uquiyarieyatücai. Manasexi 'Amuni pü'uquiyarieyatücai. 'Amuni Cusiyaxi pü'uquiyarieyatücai. ");
INSERT INTO hchNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Cusiyaxi Quecuniyaxi pü'uquiyarieyatücai, 'ivamamata quepaucua vaüriyarica memevitüqui Vaviruniyasiepaitü. ");
INSERT INTO hchNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Mehevitüquieca Vaviruniya, Quecuniyaxi Saratieri pü'uquiyarieyatücai. Saratieri Suruvaveri pü'uquiyarieyatücai. ");
INSERT INTO hchNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Suruvaveri 'Aviyuri pü'uquiyarieyatücai. 'Aviyuri 'Eriyaquimi pü'uquiyarieyatücai. 'Eriyaquimi 'Asuru pü'uquiyarieyatücai. ");
INSERT INTO hchNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","'Asuru Saruqui pü'uquiyarieyatücai. Saruqui 'Aquimi pü'uquiyarieyatücai. 'Aquimi 'Eriyuri pü'uquiyarieyatücai. ");
INSERT INTO hchNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","'Eriyuri 'Erehasari pü'uquiyarieyatücai. 'Erehasari Matani pu'üquiyarieyatücai. Matani Cacuvu pü'uquiyarieyatücai. ");
INSERT INTO hchNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Cacuvu Cuse pü'uquiyarieyatücai. Cuse Mariya pücünayatücai. Mariyasie caniyenuiva Quesusi, Manayexeiyarie mütitevacai Cürisitutütü. ");
INSERT INTO hchNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Mücü 'Apurahamisie memüyecü nuivarite xiüyarimama tamamata heimana nauca xiüyariyari mecaniyupaümecaitüni Raviri 'amuyeicacaique. Tamamata heimana nauca xiüyariyari mepüyupaümecai Ravirisie memüyecü Vaviruniyapai memevitüquieque xiüyarimama. Tamamata heimana nauca xiüyariyari mepüyupaümecai Vaviruniyapai memevitüquie vaxiüyarima Cürisitu mutinuivaxüque. ");
INSERT INTO hchNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Mericüsü müpaü catiniuyüni quepaucua Quesusi Cürisitu mutinuivaxü. Mariya müvarusieyatücaimatü Cusematü mepüyutivitüniquecai, peru mecatineneüquivavetü cuxi, mücü nayehucacaitüni, 'Iyari Mütiyupata ya'ane 'ipitüacu. ");
INSERT INTO hchNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Cuse cünaya mayaniquecai, mücü heiseriemecü yacatinicamiecaitüni, peru pücayuvaüriyacai mixanetanicü. 'Ayumieme pi'eirimücücai 'avie. ");
INSERT INTO hchNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Mericüsü müpaü püreuyutimaixüa. Hicü Ti'aitamesüa mieme niuqui tuayame niuxeiya yuheinüsita müpaü 'utaineme, Cuse 'acu Raviri pemünu'aya. 'Axa pepücati'acühüaveni Mariya pemütivitünicü 'a'üya. 'Iyari Mütiyupata ya'ane 'ipitüacu, hesiena püyeya 'icü nunusi. ");
INSERT INTO hchNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","'Uquitüme pütiniveni. Mücü canivatavicueisitüamücü yuteüterima, tita 'axa memüteyurie canivanavairiemücü. 'Ayumieme pepitaterüva Quesusi, taniuquicü Tiyuvicueisitüvame maine. ");
INSERT INTO hchNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","'Icü naitü müpaü catiniuyüni, maye'anicü tita mütixatacai Ti'aitame, tixaxatame müpaü 'utainecacu, ");
INSERT INTO hchNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Camüsü 'üimari müyuxevi payehucani, 'Uqui pütiniveni. 'Emanuheri pütaterüvarieni. Mücü taniuquicü, Cacaüyari Tahesüa Muca paine. ");
INSERT INTO hchNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Mericüsü Cuse yatiuheinüca 'anutaniereca müpaü pütiuyuri que mütita'aitüa Ti'aitamesüa mieme niuqui tuayame. Canitivitüni yü'üya. ");
INSERT INTO hchNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Peru püca'icumaüvacai, 'ariqueque 'uqui 'utinivecuque. Pitaterüvaxü Quesusi. ");
INSERT INTO hchNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Mericüsü Quesusi Verenipai canetinuiva Cureya cuieyarisie, quepaucua Herurexi mana müti'aitametücai. 'Ana yucuiepa meheyecüneca temaivavemete tayeta mepayenexüa, tahixüapa mepu'axüa quiecarisie Querusareme müracuteva, ");
INSERT INTO hchNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","müpaü me'utiyuatü, Haqueri peca Huriyusixi teüteriyari tiva'aitüvame metinuivaxü. Tame xurave tepexei 'anatineximecacu, pü'inüarieya. Nenevieri te'ipitüanique tepu'axüa. ");
INSERT INTO hchNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Hicü ti'aitame Herurexi tiutamarieca niyuxamuriecaitüni, yunaitü Querusaremetarita hepaüna. ");
INSERT INTO hchNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Varucuxeürieca mara'acate memühüritüariecai, müme meta 'inüaricü memüte'üquitametetücai teüteri vasata miemete yunaime, nivaruta'ivaviya haque metinuivaquecai Cürisitu. ");
INSERT INTO hchNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Müpaü metenicühüaveni, Verenipai vaniu Cureya cuieyarisie. Tamüsü tixaxatame müpaü tiniu'utüani, ");
INSERT INTO hchNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Vereni quiecatari 'acu, Cureya cuieyarisie xemütitei, Que memütexexeiya, Te'aitamete Cura cuieyarisie miemete, Canimarivani xequiecari. Xesata quiecametütü Cananucuquemücü ti'aitametütü, Neteüterima va'üviyanique, 'Ixaherisixi teüteriyari. ");
INSERT INTO hchNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Hicü Herurexi temaivavemete nivaruta'inieni 'avie. Nivaruta'ivaviya heiseriemecü quepaucua masiücütü matüa xurave. ");
INSERT INTO hchNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Nivarenü'ani Verenipai müpaü 'utayüca, Mana xequenehu, heiseriemecü xequenetivava nunusi hepaüsita. Quepaucua xemeitaxeiya yaxequeneteneutahüavi, mana nemineneviyamiecü neta. ");
INSERT INTO hchNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Me'i'enieca ti'aitame menecüne. Camüsü xurave memexei 'anatineximecacu, mücü vahüxie neutamiecaitüni. Heta'aca haque müyecatei nunusi, heimana niyuhayeva. ");
INSERT INTO hchNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Me'ixeiyatü xurave cuini mieme meniyutemamaviecaitüni yemecü. ");
INSERT INTO hchNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Quita meheutahaxüaca nunusi meniuxeiya varusieya meta Mariya Me'utihüxima'uca nenevieri meneipitüani. Yupinite mana mete'ucupica, 'imiquieri metenimini huru, 'ücua visi mu'üa, mixaxi. ");
INSERT INTO hchNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Hicü yuheinüsita mete'utaxatüarieca quename Herurexisüa tavari mecaheuhuni, xeime huyeyari 'utüa meniucacüne yucuiepapai. ");
INSERT INTO hchNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Mericüsü mehecünecu müme, Cuse yuheinüsita canixeiya Ti'aitamesüa mieme niuqui tuayame. Müpaü niutayüni niuqui tuayame, Quenanucuquexi, quenivaranuvitüqui nunusi varusieyamame. 'Equipitupai xequeneyuta'una. Mana xequene'uvani, 'ariqueque nematitahüave xemahunicü. Herurexi canitivaumücü nunusi 'imienique. ");
INSERT INTO hchNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","'Anucuqueca Cuse, yüvicüta nivarevitüni nunusi varusieyata. 'Equipitupai menecüne. ");
INSERT INTO hchNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Mana mene'uvacaitüni mexi camüvecai Herurexi. Müpaü tinaye'ani que mainecai Ti'aitame, tixaxatame ya'utainecacu, Nenitahüave nenive, 'Equipitu cuieyarisie müvayeyanicü. ");
INSERT INTO hchNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Hicüsüari tiutamarieca Herurexi memicuamanaxücü temaivavemete, cui niuyeha'ani. Nivarenü'ani cuyaxi memüvarecuinicü türi yunaime haica viyari memücahücai cuxi, Vereni memütitecai naisarie 'auriena memütitecai, que memüte'itahüavixü temaivavemete tucari hepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","'Anari catinaye'ani tita mütixatacai Cacaüyari, tixaxatame Queremiyaxi müpaü 'utainecacu, ");
INSERT INTO hchNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Xevitü pe'enierie Xamasie 'Utasuatü yuheiverietü cuini mieme, Xaqueri 'utasuatü yunivema vacü Cayunütüarinüatü 'amemüca'u'uvacü. ");
INSERT INTO hchNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Mericüsü Herurexi 'umücu, Cuse yuheinüsita canixeiya Ti'aitamesüa mieme niuqui tuayame 'Equipitu cuieyarisie heyeicatü. ");
INSERT INTO hchNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Müpaü niutayüni, Quenanucuquexi, quenivaranuvitüqui nunusi varusieyata. Mana quenemie 'Ixaherisixi vacuieyarisie. Menecuiniri müme memivautüvecai nunusi memimiecucai. ");
INSERT INTO hchNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Hicüri 'anucuqueca nivarevitüni nunusi varusieyata. Mana caneta'ani 'Ixaheri cuieyarisie. ");
INSERT INTO hchNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Tiutamarieca quename 'Ariquerau ti'aitametücai Cureya cuieyarisie 'uquiyarieya que müti'aitacai Herurexi, peumacai mana munuanicü. Müpaü tiutahüavarieca yuheinüsita, Carereya cuieyarisie püta caneutiyune. ");
INSERT INTO hchNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Mana heta'aca quiecarisie nayerüni Nasareti müracutevasie. Müpaü catinaye'ani Ti'aitame que mutayü, texaxatamete yame'utiyuanecacu, quename Nasaretitanaca titevacaquecai. ");
INSERT INTO hchNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Mericüsü Cureya cuieyarisie caninuani Ti'üyame Vani macumavesie ticuxatatü ");
INSERT INTO hchNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","müpaü 'utaitü, Xequeteneuhayeva que xemüteyuriecai. Canayehuraniri, que mü'ane taheima müti'aita cuitü canisutüamücü 'ena ti'aitatü. ");
INSERT INTO hchNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","'Icü canihücütüni que mü'ane müxasivacai, quepaucua tixaxatame Quisariyaxi müpaü mutayü, Xevitü mahiva macumavesie 'uvetü Xequeneucuha'aritüa Ti'aitame huyeya haitü, Xexeuravime xequeneutivevi huyeya haitü. ");
INSERT INTO hchNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Mücü Vani cameyu huxariyari cananacatücücaitüni, navi hüyameyaricü rayühüacai. Tüpuxi nivacuacaitüni yeuta mieme xiete ti'iecai. ");
INSERT INTO hchNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","'Ana yunaitü Querusaremetari, yunaitü Cureya cuie quiecatari, yunaitü Curutani hatuxame tesita quiecatari meni'axecaitüni hesüana. ");
INSERT INTO hchNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Mücü nivaruca'üyacaitüni Curutani hatuxamesie, meyuhecüatacacu 'axa que memüteyuriecai. ");
INSERT INTO hchNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Hicü yumüireme vaxeiyatü Pareseusixi Saruseusixi hesüana memü'axecai 'üyarica hepaüsita, müpaü tinivarutahüave, Cari xeme terücaxi xepüva'ivama. Quepaicü pütixehecüatüa xemüyuta'unacü capa 'uxa'a varie xe'uyehecarienicü. ");
INSERT INTO hchNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Müme memüte'uhayevaxü que memüteyuriecai, vahepaü püta xequeteneyurieca, 'uximayasica que müreuyevese. ");
INSERT INTO hchNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Müpaü xepücateyücühüaveni quename xeyüvave müpaü xemutiyuanenicü yu'iyarisie, Tame tepünaqui'eriva ta'uquiyari temexeiyacü 'Apurahami xe'utiyuatü. Müpaü nepütixecühüave, Cacaüyari caniyüveni 'icü tetexi teüteri müvarayeitüanicü, 'Apurahami nivemama memacünecü. ");
INSERT INTO hchNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Hasa caniucuha'aritüarieni cüyexi maxüriyanicü. 'Ayumieme naitü cüye 'aixüa 'anenetü müca'utixuxuavere, mücü 'ari canaxüriyamücü, taipa caneuxüriyamücü. ");
INSERT INTO hchNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Neri necanixe'uca'üyani hacü, xemüte'uhayevaxücü que xemüteyuriecai. Que mü'ane ne'utüma 'umamie, mücü cui pütürücaüye, necatürücaüyecacu ne. 'Aixüa nepüca'ane nehesie mütinaquenicü ni nemiparevienicü. Mücü püta que mütixe'uca'üyani, 'Iyari Mütiyupata canixepitüamücü, canixe'itimücü tai que mütiyu'itiva. ");
INSERT INTO hchNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Cuxari 'itivame pacue'e, cuini mieme pütiveque yutüricu. Niti'utamücü yu'icuaxi caxetunisie, cuxariyari püta pütataiyani tai mücatüvesie. ");
INSERT INTO hchNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Mericüsü 'ana Quesusi caninuani Carereya cuieyarisie heyeyaca. Curutani hatuxamesie caninuani Vanisüa, 'iya mica'üyacü. ");
INSERT INTO hchNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Vani masi niyucu'imavacaitüni müpaü 'utaitü, Neuyeveca masi 'ecü püta pemünesica'üya ne. Queri titayari nehesüa petinua. ");
INSERT INTO hchNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Quesusi müpaü tinitahüave, Müpaü pütiyüni hicü. 'Aixüa cani'aneni yatemütecahunicü naime 'aisicasie, 'ipaü teteyurietü. Hicü Vani müpaü piyuri. ");
INSERT INTO hchNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","'Uca'üyarieca Quesusi, hapa nanatiyani cuitü cuiepa. Hicü muyuavi nanacatenire. Nixeiya Cacaüyari 'Iyarieya heimana 'acamiecacu cucurupaü 'anetü, hesiena yuhayevaque. ");
INSERT INTO hchNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Xevitüta müpaü netayüni taheima, 'Icü caninenivetüni münaqui'eriva. Mücücü necaninaqui'aca. ");
INSERT INTO hchNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Hicüsüari 'Iyari caneivitüni Quesusi macumavesiepai. Mana Cauyumarie ni'inüatamücücaitüni, siparasü xüca 'axa tiuyurieni, haitü. ");
INSERT INTO hchNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Huta teviyari tucari huta teviyari tücari 'uyuhaquieca, caneuhacamücücaitüni Quesusi. ");
INSERT INTO hchNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Hicü Cauyumarie nuaca 'ita'inüataque müpaü tinitahüave, Tamüsü, 'ecü Cacaüyari xüca penu'ayatüni, müpaü quetineutahüavi 'icü tetexi, pa mayuyeitüanicü. ");
INSERT INTO hchNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Mücü müpaü tinita'eiya, 'Utüarica müpaü paine, Tevi xüca pa cuaca xeicüa, Mücücü püca'ayeyurini. Cacaüyari que mutayü, Niuquieya naitü peuyeveseta Mayeyurinicü tevi. ");
INSERT INTO hchNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Hicü Cauyumarie Querusareme neivitüni Cacaüyari quiecarienapaitü. Vatuqui yecürita nenutivitüni. ");
INSERT INTO hchNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Müpaü tinitahüave, 'Ecü Cacaüyari xüca penu'ayatüni, vatipai queneucasuna. 'Utüarica müpaü paine, Yuhesüa miemete niuqui tuayamete Pütiva'aitüaca 'ahepaüsita. Yumamacü mepümasituicani Capa tetesie pe'uti'ücamürecü. ");
INSERT INTO hchNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Quesusi müpaü tinita'eiya, Müpaü paineta 'utüarica, Pepüca'i'isipaneni Ti'aitame mü'acacaüyari, haitü. ");
INSERT INTO hchNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Hicü tavari Cauyumarie neivitüni yemuri cui manutitevasie. Cuiepa memütama vacuie xexuime nixeiyasitüani visi mü'ane. ");
INSERT INTO hchNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Müpaü tinitahüave, Nepümasimini 'icü naime, xüca nenevieri penesi'upitüani pe'utitunumaqueme. ");
INSERT INTO hchNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Quesusi müpaü tinitahüave, Quenemie Cauyumarie. 'Utüarica müpaü paine, Nenevieri pecanipitüaca Ti'aitame Mü'acacaüyari hücüame. Mücü hücüa pecanayexeiyacamücü. ");
INSERT INTO hchNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Hicü Cauyumarie nicu'eirieni neyani, niuqui tuayamete me'u'axüaca menipareviecaitüni. ");
INSERT INTO hchNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Mericüsü tiutamarieca quename Vani heviyarie, Carereyapai neyani Quesusi. ");
INSERT INTO hchNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nasaretisie 'uyupataca, Caperünaume henuaca haracuna tesita maniere, mana nayerüni Savuruni Nepütari vacuieyari müracutevasie. ");
INSERT INTO hchNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Müpaü tinaye'ani tita mütixasivacai quepaucua tixaxatame Quisariyaxi müpaü mutayü, ");
INSERT INTO hchNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Savuruni cuieyari Nepütari cuieyari, Haracuna mananiere Curutani 'anutaüye meta, Carereya haque memetitei müme memücatateüterima, ");
INSERT INTO hchNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Teüteri yüvipa memütitecai Müme hecüariya meniuxeiya cui müxavatü. Müme 'etüripa memütitecai Haque memücuiximecai, Müme vahesie mieme Hecüarivivame cananatineni. ");
INSERT INTO hchNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Mericüsü 'ana Quesusi nisutüani ticuxatatü, müpaü 'utaitü, Xequeteneuhayeva que xemüteyuriecai. Canayehuraniri, que mü'ane taheima müti'aita cuitü canisutüamücü 'ena ti'aitatü. ");
INSERT INTO hchNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Hicüsüari haracuna tesita 'uyemietü Carereya cuieyarisie, nivaruxeiya yuhutame yu'ivamacame. Xevitü Simunitütü Pecuru catinitevacaitüni, 'ivaya meta 'Atürexi. Mana taxaya meneutavivivacaitüni haracunasie, memüquesüteveiyametetücaicü müme. ");
INSERT INTO hchNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Hicü müpaü tinivarutahüave, Cümü, nehesie xequeteneviyani. Teüteri xevacuxexeürivame necanixe'ayeitüamücü, quesüte xemütevaruxexeürivapaü hicü. ");
INSERT INTO hchNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Müme yapaucua yutaxaya me'ucu'eirieca hesiena meteniuviya. ");
INSERT INTO hchNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Mericüsü 'uma 'uyemietü hipame nivaruxeiya yuhutame yu'ivamacame, Cacuvu Vani, Severeu nivemama. Canuvasie meniyetecaitüni Severeumatü va'uquiyarimatü yuvipi memanesiquitüatü. Hicü nivaruta'inieni hesiena memüteviyanicü. ");
INSERT INTO hchNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Cuitü me'icu'eirieca canuva, yu'uquiyari me'ucu'eirieca, hesiena meteniuviya. ");
INSERT INTO hchNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Mericüsü naisarie Carereya cuieyarisie caniuyeicacaitüni, ti'üquitatü vatuquiteta, ticuxatatü niuqui 'aixüa manuyünecü, que müti'ane Cacaüyari ti'aitametücacu ticuxatatü, varanayexürüvatü teüteri naime cuiniyacü naime veranariyacü. ");
INSERT INTO hchNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Naisarie Siriya cuieyarisie tiniutamariva que mütiyurienecai. Meni'atüirivacaitüni yunaime 'axa memü'itüariecai, müireme cuiniya müvaviyacai, müiremecü memü'uximatüariecai, müme cacaüyarixi 'axa memü'anene memüvaviyacai, quierixiecate, huriecate. Nivaranayexürüvacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Cui yumüiretü meneiveiyacaitüni, Carereyasie Tamamata Quiecaritesie Querusaremesie Cureyasie Curutani 'anutaüyesie meheyecüneca. ");
INSERT INTO hchNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Mericüsü teüteri yumüireme vaxeiyatü, mana yemurisie neutiyune. Muva 'anacayacu teyü'üquitüvametemama 'auriena meniu'axüani. ");
INSERT INTO hchNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Mücü tinivaruti'üquitüani ya'utaitü, ");
INSERT INTO hchNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","'Aixüa mecani'itüarieca Müme vaüca memüteheuyehüva yu'iyarisie que memüteyumate. Que mü'ane taheima macave mecanexeiyacuni tiva'aitüvametüme. ");
INSERT INTO hchNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","'Aixüa mecani'itüarieca Müme memüyuheiverie. Mepünütüarieni. ");
INSERT INTO hchNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","'Aixüa mecani'itüarieca Müme memüca'ayu'eririya. Vahesie pütinaque cuie naitü. ");
INSERT INTO hchNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","'Aixüa mecani'itüarieca Müme memüyuvaüriya Heiseriemecü yamemütecahunicü Yaxeicüa tevipaü Meuhacamücüpaü meuharimücüpaü. Yamepütepitüarieni mepütihuxani. ");
INSERT INTO hchNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","'Aixüa mecani'itüarieca Müme memüteyucanenimaya. Mepütinenimayasieni. ");
INSERT INTO hchNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","'Aixüa mecani'itüarieca Müme memü'itiyatüca va'iyari müyuxevinicü. Mepixeiya Cacaüyari. ");
INSERT INTO hchNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","'Aixüa mecani'itüarieca Müme memüvanütüani teüteri, 'aixüa memüteyuxeiyanicü. Mepümasiücüni Cacaüyari nivemama que memütehüme. ");
INSERT INTO hchNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","'Aixüa mecani'itüarieca Müme memuveiyarie memüyuvaüriyacü heiseriemecü yamemütecahunicü. Que mü'ane taheima macave mecanexeiyacuni tiva'aitüvametüme. ");
INSERT INTO hchNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","'Aixüa xecani'itüarieca xeme Quepaucua memüxeta'uxive'erieni, quepaucua memüxe'uveiyani, quepaucua mete'itavatü 'axa memutiyuaneni xehepaüsita naimecü nehesie xemümiemetecü. ");
INSERT INTO hchNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Xequeneyutemamavieca 'ana xequenenaqui'aca müpaü xetemaitü, 'aixüa 'aneme xecanipitüariecuni vaüca taheima mieme. Müpaüta metenivaruveiyacaitüni texaxatamete xehetüa memü'axecai. ");
INSERT INTO hchNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Xeme cuiepa memütama va'una xecanihümetüni. 'Una xüca hamuritü 'ayanique, titacü ha'usivitü rayaniqueyu. 'Asipücayüve. Panuyevivivaniqueyu xeicüa, teüteri mepicaquesinaniqueyu. ");
INSERT INTO hchNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Xeme cuiepa memütama vahecüarivivamete xecanihümetüni. Yemuri heima quiecari pücayüve müti'aviesieni. ");
INSERT INTO hchNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Mücü meta, 'ititaiyame cüxeme, cacunicü püca'enucanani, masi vapaitü neitiyemücü. Nivahecüariyacamücü yunaime quita memayetei. ");
INSERT INTO hchNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Yaxeicüa xeme, hecüariya xehesüa mieme müpaü quetihecüaca teüteri vahüxie, memüxexeiyanicü 'aixüa que xemüteyurie, 'aixüa memutiyuanenicü xe'uquiyari taheima macave hepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Müpaü xepücatecu'erivani quename nenua ne'ica'unaque 'inüari niuquiyari, texaxatamete vaniuquiyari. Que nemütinua, ne'ica'unaque necapunua, ne'eye'atüanique püta necaninuani. ");
INSERT INTO hchNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","'Icü niuqui caniseüyeni que nemütixecühüave, mexi cataxüve muyuavi cuie, xei hüxiyari xei tuniyari pücatatümaiyarieni 'inüari niuquiyarisie mieme, naitü mexi ca'aye'ave. ");
INSERT INTO hchNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Que mü'ane mitixani'erieni 'icü 'aisica sepa 'imatüme, yativa'üquitüatü teüteri, mücüta 'imatüme pütaterüvarieni, que memütemariva müme memeixeiya que mü'ane taheima macave tiva'aitüvametüme. Perusü que mü'ane yamüticamie yamüti'üquita, mexüacame püta pütaterüvarieni. ");
INSERT INTO hchNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Müpaü nepütixecühüave, xeme xepüyuvaüriya heiseriemecü yaxemütecahunicü. Mümeta 'inüaricü memüte'üquitamete, Pareseusixi meta, müme yaxeicüa vaniu mepüteyuvaüriya. Mericüte, peuyevese xeme masi yemecü yaxemütecahunicü. Me xüca catixaütüni, tixaü xepücaheutahaxüani haque müra'aita que mü'ane taheima macave. ");
INSERT INTO hchNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Xepu'enana quename meripai miemetexi müpaü mete'utahüavarie, Pepücati'amemivani. Que mü'ane mütiyumemivani, 'isücame hesiena 'apürahüpani. ");
INSERT INTO hchNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ne masi müpaü nepütixecühüave, que mü'ane miheca yu'iva, 'isücame hesiena 'apürahüpani. Que mü'ane 'axa müticühüaveni yu'iva, mücüsie mepüte'uhüpani ta'uquiyarima. Que mü'ane müpaü mütitahüave, Cari pepüca'amate, mücü panutahüiyani xasi taiyariyarisie. ");
INSERT INTO hchNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","'Ayumieme xüca 'a'imiquieri pe'atüani mürayutimavatüre, mana xüca yapera'erivani quename 'a'iva tixaütücü 'aixüa camatixeiya, ");
INSERT INTO hchNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","mana mürayutimavatüre queneucu'eiri 'a'imiquieri. Quenemie meri, 'aixüa xeteyuxeiyatü xequenacüni yu'ivamatü. 'Ariqueque muva pe'ayeneme queneutimava. ");
INSERT INTO hchNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Cuitü quenehamicutani que mü'ane mümasixaneta mexi huyeta pe'uyeica hamatüana, capa masiyetuanicü 'isücamesüa masixanetame, 'isücame capa masiyetuanicü tupirisüa, capa pe'anutahüiyanicü. ");
INSERT INTO hchNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","'Icü niuqui caniseüyeni que nematicühüave, muva pepücavayeyani mexi pecati'atuave naimecü. ");
INSERT INTO hchNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Xepu'enana quename müpaü metecühüavarüvacai, Xeime 'üyaya cünaya pepücacumaüvani. ");
INSERT INTO hchNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ne masi müpaü nepütixecühüave, que mü'ane mixeiya 'uca 'ihive'erietü, mücü canicumaüvani yu'iyarisie. ");
INSERT INTO hchNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","'Ayumieme 'ahüxicü 'aserieta miemecü xüca 'axa petiyurieneni, mecuxi quenivatitu'i quenehüva. 'Aixüa caniyümücü masi tixaütü müreuyevenicü 'avaiyarisie mieme, capa pe'axevitü peheucahüiyanicü xasi taiyariyarisie. ");
INSERT INTO hchNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","'Amama 'aserieta mieme xüca 'axa 'ane matiumayüisitüvani, mecuxi quenavitequi quenehüva. 'Aixüa caniyümücü masi pemanupurunicü capa pe'axevitü peheucahüiyanicü xasi taiyariyarisie. ");
INSERT INTO hchNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Müpaüta mepüte'utahüavarie meripai miemetexi, Que mü'ane micu'eirie yü'üya, 'eiriya xapayari que'ihuritüani. ");
INSERT INTO hchNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ne masi müpaü nepütixecühüave, que mü'ane micü'eiri yü'üya, mücü xeime cünaya cumaüvame canayeitüani yü'üya me xüca 'uca 'icumayüirieni que mü'ane mücayücüna xeicüa. Que mü'ane mitivitüni 'uca mucu'eiriva, mücüta picumaüvani xeime 'üyaya. ");
INSERT INTO hchNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Mücü meta, xepu'enana quename meripai miemetexi müpaü metecühüavarüvacai, Pepüca'ahüritüani peti'itavatü, masi que pemüti'ahüritüa yapepüticamieni Ti'aitame masixeiyacacu. ");
INSERT INTO hchNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ne masi müpaü nepütixecühüave, yemecü xepücayühüritüaca. Taheima mieme muyuavi xexatatü xepücayühüritüaca Cacaüyari muva yu'uvenisie 'acaitü müti'aitacü. ");
INSERT INTO hchNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Cuie xexatatü xepücayühüritüaca cuie 'uvenieyatüa mieme quetayatüa mieme mühücücü. Querusareme xexatatü xepücayühüritüaca ti'aitame mütürücaüye quiecarieya mühücü. ");
INSERT INTO hchNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","'Amu'u pexatatü pepüca'ahüritüaca pemücayüvecü tuxame yüvime pemeyeitüanicü ni xei cüpayari. ");
INSERT INTO hchNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Xüca xeyuvaüriyani, hü xequeneutiyuaneni xeicüa, me xüca xecayuvaüriyani, tixaü xequeneutiyuaneni. Tavari xei niuquiyari panayuhayeva, que mü'ane 'axa mütiyuruvasüa canimiemetüni. ");
INSERT INTO hchNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Xepu'enana quename müpaü metecühüavarüvacai, Yühüxicü pürapica rahüxicü, yutamecü ratamecü. ");
INSERT INTO hchNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ne masi müpaü nepütixecühüave, müpaü xeteyurietü xepüca'inenaca que mü'ane 'axa müxeyurie. Masi que mü'ane 'a'aupucuesie mümasicuvaya 'aserieta, ta'aurie pe'aveme queneupitüa tapata. ");
INSERT INTO hchNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Que mü'ane masixanetatü mümasinavairiemücü 'acamixa, queneutauniri 'a'ücarita. ");
INSERT INTO hchNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Que mü'ane masiviya hesiena mieme tixaütü pemüranutünicü xei queyari, huta queyari queneumieni 'utüana. ");
INSERT INTO hchNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Que mü'ane tixaütü mümativaviri, queneupitüa, que mü'ane mümasiniüviriemücü pepüca'ixani'erieca. ");
INSERT INTO hchNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Xepu'enana quename müpaü metecühüavarüvacai, Pepinaqui'erieca 'auravatanaca, pepi'uxive'erieca que mü'ane mümasi'aye'unie. ");
INSERT INTO hchNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ne masi müpaü nepütixecühüave, xequenivanaqui'erieca müme memüxe'aye'unie, xequeneyunenevieca müme memüxe'uveiya vahesie mieme. ");
INSERT INTO hchNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Müpaü xeyüatü püyuritüni yu'uquiyari taheima macave nivemama xemühümecü. Mücü canenatinetüvani yutau 'axa memüteyurie vahesüa 'aixüa memüteyurie vahesüa. Viyeri panacanü'ava müme heiseriemecü yamemütecahu vahesie müme heiseriemecü yamemücatecahu vahesie yaxeicüa. ");
INSERT INTO hchNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Xüca xevanaqui'erieca müme memüxenaqui'erie, que xete'a'iva mücücü. Camü, 'asita müme cuviyexunusie mieme memüteyetuiriyari yaxeicüa mepüteyurie. ");
INSERT INTO hchNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Xüca yu'ivamarixi xevavaüritüaca hücüa, titasü xeteyurie hipatü yamemücateyurie. Camü, müme memücatateüterima yaxeicüa mepüteyurie. ");
INSERT INTO hchNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Xeme püta yemecü xequenaye'axüa, maye'avepaü xe'uquiyari taheima macave. ");
INSERT INTO hchNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Xequeneyucuerivayurieca capa xete'ayexeiyanicü teüteri vahüxie, müme memüxe'ixüariecacü xeicüa. Me xüca vahüxie xeicüa yaxeteyurieca, tixaütü xepücatepitüarieni, yu'uquiyarisüa taheima macavesüa. ");
INSERT INTO hchNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Quepaucua pemiparevie puvüre, cuxineta pepüca'aitani 'ahüxie mühüsieriecacü pemüxeiyarienicü, tuquipa caye 'utüa que memüteyurie müme yacü xeicüa memüteyurie, teüteri 'aixüa memutiyuanenicü vahepaüsita. 'Icü niuqui caniseüyeni que nemütixecühüave, 'ari meheixeiyatü mepacü tita memütepitüarieni. ");
INSERT INTO hchNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","'Ecü püta quepaucua pemiparevie, 'asipepücatayüni, sepa 'amama 'aserieta mieme 'asimücatimate que mütiyuriene 'a'utata mieme, ");
INSERT INTO hchNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","'avie pemiparevicü. 'Ana 'a'uquiyari 'ixeiyatü tita müti'aviesie pümatipitüani 'a'ivarica yunaime vahüxie. ");
INSERT INTO hchNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Quepaucua xemüyunenevie, müme yacü xeicüa memüyüa vahepaü xepücayüaca. Cui püvanaque tuquipa memüti'unicü 'isiquinasie memüti'unicü meyunenevietü teüteri memüvaxeiyanicü. 'Icü niuqui caniseüyeni que nemütixecühüave, 'ari meheixeiyatü mepacü tita memütepitüarieni. ");
INSERT INTO hchNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","'Ecü püta quepaucua pemü'anenevie 'aquita queneutahaca. Quitenie pereuname nenevieri quenepitüaca 'a'uquiyari mana muyeica muye'aviesie. 'A'uquiyari 'ixeiyatü tita müti'aviesie pümatipitüani 'a'ivarica yunaime vahüxie. ");
INSERT INTO hchNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Xeyunenevietü xepüca'imüiriyani niuqui hipame nuivarite vahepaü. Vaüca memutiniucacü, me'enieriecame mepüyu'erie. ");
INSERT INTO hchNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Vahepaü xe'anenetü xepüca'acüne. Cacaüyari müxe'uquiyari yapütimate tita xemüteheuyehüva, yaxecate'itavavirievavecacu cuxi. ");
INSERT INTO hchNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","'Ayumieme 'ipaü püta xequeteneyunenevieca xeme, Ta'uquiyari taheima pemacave, Pequereuyehüviyarieni que pemütipasie. ");
INSERT INTO hchNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","'Enata queneusutüa peti'aitatü, Yamequeteyurieca que mümatinaque Taheima que memüteyurie, cuiepata yaquetiuyüni. ");
INSERT INTO hchNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","'Icuai hicü mieme que temüteheuyehüva, Yaquetatineumicuani hicü. ");
INSERT INTO hchNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Quetatineuyehüvirieca 'axa temüte'uyuricü Tameta temütevareuyehüviricü müme 'axa memütasi'uyuri. ");
INSERT INTO hchNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Pepücatasipitüaca temüta'inüasienicü, Masi quetaneutavicueisitüa 'axa temüca'itüarienicü. 'Ecüsü 'aheyemecü pecatini'aitametüni Pecanitürücaüyeni Visi pecani'aneni 'aheyemecü. Müpaü xeicüa cani'aneni. ");
INSERT INTO hchNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Xüca xetevareuyehüvirieca teüteri 'axa memüteyurie, xe'uquiyari taheima macave püxereuyehüvirieca xemeta. ");
INSERT INTO hchNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Me xüca xecatevareuyehüvirieca teüteri, xe'uquiyari pücaxereuyehüvirieca xemeta 'axa xete'uyurieyu. ");
INSERT INTO hchNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Quepaucua xemüyuhaquiva müme yacü xeicüa memüteyurie vahepaü xepücayüaca. Müme yuheiveriecate vahepaü meteyuxexeiyame mepayuyeitüva yacü xeicüa, yuhaquivamete vahepaü memüteyuxexeiyanicü teüteri que memütevaxeiya. 'Icü niuqui caniseüyeni que nemütixecühüave, 'ari meheixeiyatü mepacü tita memütepitüarieni. ");
INSERT INTO hchNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","'Ecü püta quepaucua pemü'ahaquiva, quene'acaviri 'amu'usie, quenanacahütaima, ");
INSERT INTO hchNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","tiyuhaquivamepaü pemücati'axexeiyanicü, teüteri que mematexeiya. 'A'uquiyari mana muyeica muye'aviesie, mücü püta que matixeiya pepümasiücüni. 'A'uquiyari 'ixeiyatü tita müti'aviesie, mücü pümatipitüaca 'a'ivarica yunaime vahüxie. ");
INSERT INTO hchNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Xequeteneuhayeva cuiepa timieme xetixeürietü xeicüa. Cuiepa timieme pütiyusevixima ticümiyarietü tiyucuitamatü, tenavayamete qui vari mepeuhaque, mepinava. ");
INSERT INTO hchNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Taheima mieme masi xequetenexeürieca. Mücü pücatiyusevixima caticümiyarietü catiyucuitamatü, tenavayamete mepücaheutahaque mepüca'inava. ");
INSERT INTO hchNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Haque pemeitixeürie, manata 'a'iyari püyecani. ");
INSERT INTO hchNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Tahüxie canihücütüni tavaiyari cüxemeya. 'Ayumieme xüca 'ahüxi yuxevini que pemütixeiya 'apini, 'avaiyarisie naime pepühecüariviyarieca. ");
INSERT INTO hchNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Me xüca 'ahüxi 'axa 'aneni peti'acahive'eriecacu, 'avaiyarisie pecaniyüriyariecamücü. Mericüte, 'acüxeme xüca 'uyüre, yemecü pepüyüriyarieni. ");
INSERT INTO hchNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Tevi pücayüve 'axeicüa yuhutame vahesie tiviyatü müti'uximayaca yucusiyarima. Ni'uxive'eriecamücü xeime 'inaqui'erietü xeime, mesü xeimesie pütiviyani 'ixani'erietü xeime. Xepücayüvave 'axeicüa xemüte'uximayaca Cacaüyarisie xeteviyatü yupinisie xeteviyatü. ");
INSERT INTO hchNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","'Ayumieme müpaü nepütixecühüave, xequeteneuhayeva xeyu'iyaritüatü yutucari hepaüsita, tita tetecuani tita tete'ieni xecateyücühüavetü, yuvaiyari hepaüsita xepücayu'iyaritüaca tita tete'anacatüxüani xecateyücühüavetü. 'Icuai xeicüa que titucari, 'ixuriqui ravaiyari que tihücütüni. ");
INSERT INTO hchNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Xequenivaru'ixüari viquixi taheima miemete. Mepüca'uca'esa mepüca'uca'isana, caxetunisie mepücateti'uta. Sepanetü, xe'uquiyari taheima macave pütivamicua. Mericüte, xeme cuini mieme masi xepeuyevese ni que müme. ");
INSERT INTO hchNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Xeme quepaicü püyüve yu'iyaritüatü 'a'utevitü mayuyeitüani xüca 'esi'utevini, sepa xei sicuriyari. ");
INSERT INTO hchNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","'Ixuriqui hepaüsita titayaricutaxi xeteyu'iyaritüa. Xequeteneyü'üquitüaca xehe'erivatü texuxuri 'üsita mieme que mütiuyüraxüa. Capüti'uximaya capüvita. ");
INSERT INTO hchNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Siepüre müpaü nepütixecühüave, Sarumuni sepa naimecü marivetü mayuyeitüvacai visi pücatiyuquemaritüvacai texuxuripaü. ");
INSERT INTO hchNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Xüca müpaü 'aneni, xüca Cacaüyari müpaü tiquemaritüaca 'üxa 'üsita mieme hicü meuti'u 'uxa'a huxunuta meucahüiva, masi yemecü catixequemaritüaca xeme sepa haveri mieme xeicüa yuri xemüte'erie. ");
INSERT INTO hchNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","'Ayumieme xepücayu'iyaritüaca yaxe'utiyuatü, Queri tetecuaca, titari tete'ieca, titacü tetetaquemaritüaca, xe'utiyuatü. ");
INSERT INTO hchNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Müme memücatateüterima mepivautüve mücü naime. Xe'uquiyari taheima macave yapütimate xemeiyehüvacü 'icü naime. ");
INSERT INTO hchNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Xeme masi xequeneyuvaüriyani mücü tixe'aitüvame mühücütünicü, heiseriemecü yaxemütecahunicü. Müpaü xeteyurietü, xepütemiquienita mücü naime. ");
INSERT INTO hchNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","'Ayumieme xepücayu'iyaritüaca 'uxa'a miemecü. 'Uxa'a puxuaveni 'iyaritüarica yücümana. Tita 'axa müti'ane 'ari pütiunaquixü hicü miemecü xemüyu'iyaritüacacü. ");
INSERT INTO hchNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Hipame vahesie xepücate'uhüpani, xehesie capa rahüivanicü. ");
INSERT INTO hchNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Hipame vahesie que xemüte'uhüpa, yaxeicüa xeme xehesie pürahüivani. Que xemüteva'inüasirie hipame, yaxeicüa xepüte'inüasiyarieni. ");
INSERT INTO hchNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Titayari cui petixeiya xasi 'a'iva hüxita meutavivi, pecahe'erivatü queuruvi mana meutave 'ecü 'ahüxita. ");
INSERT INTO hchNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Que petitahüaveni 'a'iva, Tamüsü nepümasivaye'itirieni xasi 'ahüxita meutavivi, queuruvi heutavecacu cuxi 'ecü 'ahüxita. ");
INSERT INTO hchNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Yacü peputaine xeicüa. 'Ahüxita meri quenivayehüva queuruvi, 'arique 'aixüa peheunieretü pecanayeimücü pemivaye'itirienicü xasi 'a'iva hüxita meutavivi. ");
INSERT INTO hchNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Tita Cacaüyarisie mieme mütipasie xepücatevamicuani süicüri. Cuca cuini müraye'atüca xepüca'acaxürüvani tuixuri vahüxie, capa me'itiquesinanicü, capa ta'aurie me'axürieme mexe'utisanacü süicüri. ");
INSERT INTO hchNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Xecatehayevatü xüca xeteta'ivauni, yaxepütemiquieni. Xüca xetecuvautüveni xecatehayevatü, yaxepüte'itaxeiya. 'Itupari xüca xe'uyuitüani xecatehayevatü, xepüteheuyepiyarieni. ");
INSERT INTO hchNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Que mü'ane mita'ivau pitanaqui'erieni yu'ivaurica, que mü'ane mivaune pitaxeiyani, que mü'ane 'itupari mücuyuitüva püreuyepiyarüva. ");
INSERT INTO hchNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Xevitü xeme xüca nu'aya 'itavavirieni pa, tete que timini pa xatatü. ");
INSERT INTO hchNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Xüca quesü 'itavavirieni, cu que timini quesü xatatü. ");
INSERT INTO hchNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Xemesietü sepa 'axa xemü'anene, xüca 'aixüa 'anemecü xetevamicuani yutüriyama, masi vaücavamecü xe'uquiyari taheima macave 'aixüa 'aneme catinivamimücü müme yamemüte'itavavirieni. ");
INSERT INTO hchNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","'Ayumieme nai que mütixenaque teüteri memüxeyurienicü xeme, mücü canixe'inüaritücamücü, yaxeicüa xemüvayurienicü müme meri. Müpaü tiyurienetü canitaxeviriyamücü 'inüari niuquiyari texaxatamete vaniuquiyari naime. ");
INSERT INTO hchNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Quitenie 'esimayevasie xequeneutahaxüa. 'Epayeva quitenie, 'epatayeva huye meucayune haque memeuyexürüve. Mepüyumüire mana memeutahaque. ");
INSERT INTO hchNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","'Esipayeva quitenie, püyusaipüna huye tucarisiepai meutiyune. Hipatü xeicüa mepicaxexeiya. ");
INSERT INTO hchNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Xequeneyucuerivayurieca texaxatamete memüte'itava vahepaüsita. Xehesüa mepatahaque muxasi vahepaü meteyuxexeiyatü, masi tetüata mepü'üravesixi püta memütenavaya. ");
INSERT INTO hchNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Que memüte'utixuxuavere xepüvaretimani que memü'anene. Caxie que tica'inüiva xuyasie. Pini que tica'inüiva visexasie. ");
INSERT INTO hchNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Naitü cüye münararani 'aixüa pütiutixuxuavere. Naitü cüye mütixainirüme 'axa pütiutixuxuavere. ");
INSERT INTO hchNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Cüye münarani pücayüve 'axa mütiutixuxuavereni. Cüye mütixainirüme pücayüve 'aixüa mütiutixuxuavereni. ");
INSERT INTO hchNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Naitü cüye 'aixüa mücatiutixuxuavere canavitequiemücü, taipa caneuxüriyamücü. ");
INSERT INTO hchNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","'Ayumieme que memüte'utixuxuavereni xepüvaretimani que memü'anene. ");
INSERT INTO hchNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Müme müpaü memünetecühüave, Ti'aitame 'acu, Ti'aitame me'utiyuatü, yunaitü müme mepücaheutahaxüani haque müti'aita que mü'ane taheima macave. Müme xeicüa yamemütecahu que mütinaque ne'uquiyari taheima macave, müme mecaneutahaxüacuni. ");
INSERT INTO hchNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Mücü tucarisie yumüiretü müpaü mepünetetahüave, Ti'aitame 'acu, Ti'aitame, neuxei tame temasixatatü tetenicuxatacaitüni, temasixatatü cacaüyarixi 'axa memü'anene tepüvareutanü'axüa, temasixatatü marivemecü tepüteyuriecai. ");
INSERT INTO hchNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","'Anari ne müpaü nepütivatahüave, Hasuacu nepücaxematecai. Nehesüa xepücamiemete, xequeneutayeixüa. Cari yaxepüteyurie que mücatiheiserie. ");
INSERT INTO hchNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","'Ayumieme nepaine, que mü'ane mi'enie 'icü neniuqui que nemutayü, yamüticatüa, mücü tevi mütimaivepaü cani'aneni. Mücü niyutaquitüani tetesie. ");
INSERT INTO hchNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","'Ucaviyecu, hatuxame vayenecu, 'ucu'ecacu, mücü quisie 'uquexüacu 'eca, cacanativeni, tetesie mutaquicaicü simiyenituyari. ");
INSERT INTO hchNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Masi que mü'ane mi'enie 'icü neniuqui, yacaticamietü, mücü tevi 'asimücatimatepaü cani'aneni. Mücü niyutaquitüani xiecaripa. ");
INSERT INTO hchNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","'Ucaviyecu, hatuxame vayenecu, 'ucu'ecacu, mücü quisie 'uquexüacu, niucaveni. Carima niutayuani 'ativeximetü. ");
INSERT INTO hchNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Hicüsüari Quesusi quepaucua minü 'icü xasica, teüteri mecaniuhüxiyani 'üquisicayacü. ");
INSERT INTO hchNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Que mü'ane heiserie mexeiyapaü tiniva'üquitüacaitüni. Müme 'inüaricü memüteva'üquitüvacai vahepaü pücati'üquitacai Quesusi. ");
INSERT INTO hchNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Mericüsü quepaucua yemurisie macane, teüteri yumüiretü mecaniveiyacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Hicü tevi cuiniyacü müca'itiyacai hesüana nuaca nenevieri canipitüani ya'utaitü, Ti'aitame xüca pe'avaüriyani pepüyüve pemünesi'itienicü. ");
INSERT INTO hchNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Mücüri yumama 'utaseraca nimayüani ya'utaitü, Nepünevaüriya. Pecaniu'itiyaniri. Cuiniyaya yapaücua neunuani, 'itiyatü nayani. ");
INSERT INTO hchNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Hicü Quesusi müpaü tinitahüave, Neuxei, xeimetüme pepücaraxaxatüvani. Mara'acamesüa quenemie püta quene'ahecüata masixeiyacü. 'Imiquieri quenanutimava que mütiu'aitaxü Muisexi yapemütivatahecüatüanicü. ");
INSERT INTO hchNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Mericüsü Caperünaumesie heutahacu cuya hesüana caninuani xei sienituyari cuyaxi tiva'aitüvame. Mücü vaüriyarica nipitüani ");
INSERT INTO hchNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","müpaü 'utaitü, Ti'aitame 'acu, nenive muva nequita pacaca hurietü cui yüanetü cuiniyacü. ");
INSERT INTO hchNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Mücü rehüave, Ne netiyemie nemenayehüanicü. ");
INSERT INTO hchNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Cuya rehüave, Ti'aitame, 'aixüa nepüca'ane nequita pemeutahanicü. Niuqui xeicüa queneutayüqui. Mücücü panayehüiyani nenive. ");
INSERT INTO hchNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nesiere necatini'aitüarieca necuyatütü, cuyaxita nepütiva'aitüvame. Xüca müpaü netitahüave xeime, Quenemie ne'utaitü, mücü püyemie. Xeimeta müpaü xüca netiutahüave, Quenaye'a ne'utaitü, mücü canayeimücü. Xüca müpaü netitahüave nehesüa mieme ti'uximayatame, 'Ipaü quetineyurieneni, müpaü pütiyurieneni. ");
INSERT INTO hchNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Quesusi 'i'enieca nihüxiyacaitüni. Müpaü tinivarutahüave müme memiveiyacai, 'Icü niuqui caniseüyeni que nemütixecühüave, ni xeime 'Ixaherisixi vasata 'icüpaü 'aneme nepücahetaxeiyave yuri ti'eriecame. ");
INSERT INTO hchNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Müpaü nepütixecühüave, yumüiretü meni'axüacuni tau matineicasie miemete macayuyuipiquesie miemete. Mexa 'aurie mecanayaxicuni 'Apurahamimatü 'Isahaquimatü Cacuvumatü haque müre'aita que mü'ane taheima macave. ");
INSERT INTO hchNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Peru müme mana memeutahaxüaniquecai müpaü me'anenetü memutinuivaxücü, müme püta mecanayeveiyariexüacuni tacua, yüvipa yemecü memu'uvanicü. Mana meniutisuanacuni meniyutaquevecuni. ");
INSERT INTO hchNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Hicü Quesusi müpaü tinitahüave cuyaxi tiva'aitüvame, Quenemie. Yuri que pemütiuta'eri, yapeque'itüarieni. 'Anatütü nanayehüiyani nu'aya. ");
INSERT INTO hchNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Mericüsü Quesusi Pecuru quie nuaca, nixeiya varücaüya 'ucacaime hüiyacame. ");
INSERT INTO hchNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Mamayasie nimayüani. Hüiya nihayeva. 'Anucuqueca tinivarumini. ");
INSERT INTO hchNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Hicü 'ucutaicairecu mecani'atüirieni yumüireme teüteri, cacaüyarixi 'axa memü'anene memüvaviyacai. Cacaüyarixi nivaranuyenü'axüani niuquicü, yunaime püvaranayexüri memütecucuyecai. ");
INSERT INTO hchNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Müpaü tiuyuriecu, paye'a Cacaüyari que mutayü, tixaxatame Quisariyaxi ya'utainecacu, Mücütütü cataniunavairieni taveranariya, peitü tacuiniya. ");
INSERT INTO hchNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Mericüsü Quesusi vaxeiyatü teüteri que memüteyuxeüriecai 'auriena yumüiretü, tinivaruta'aitüani yuteüterima 'anutaüyepai memenuyevitünicü. ");
INSERT INTO hchNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Hicü xevitü 'inüaricü müti'üquitametücai hesüana nuaca, müpaü tinitahüave, Ti'üquitame 'acu, 'ahesie necatiniviyamücü. Haque pemeyemie, neta necaniyemieni 'a'utüma. ");
INSERT INTO hchNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Quesusi rehüave, Cauxaisi yuterü mepexeiya, viquixi taheima miemete yu'itua mepexeiyata, peru ne, Yuri Tevi que nemütiteva, haquevasü nepücarexeiya haque nemünetamuritaritüani. ");
INSERT INTO hchNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Xevitüta tiyü'üquitüvame müpaü tinitahüave, Ti'aitame, queneneupitüa merie nemüyemiecü, nemicateucucü ne'uquiyari 'umüyu. ");
INSERT INTO hchNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Quesusi rehüave, Nehesie quetineviyanisü. Müquite quenivaruhayeva, müme püta memüvacateucucü yuhesüa miemete müquite. ");
INSERT INTO hchNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Mericüsü canuvasie 'acayerüca neyani Quesusi, hesüana miemete teyü'üquitüvamete yunaitü me'acayaxeca 'üaritü mepecü. ");
INSERT INTO hchNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Hicü haracuna nenutivayacaitüni, Canuva pücahahecüacai hamevarisata. Quesusi masi canicusucaitüni. ");
INSERT INTO hchNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Hicü teyü'üquitüvamete 'auriena me'uyuxeürieca menenutahütüani müpaü me'utiyuatü, Ti'aitame quetaneutavicuesitüa tepeuyevexime. ");
INSERT INTO hchNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Mücü müpaü tinivarutahüave, Titayari xeteheumama. Cari haveri mieme xeicüa yuri xepüte'erie. Hicü 'anucuqueca nitatieni 'eca haracuna. Cui cayuvatü caniutamare. ");
INSERT INTO hchNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Teüteri menihüxiyacaitüni müpaü me'utiyuatü, Queri 'ane 'icü. Cari 'asita 'eca yapüticamie que maine, haracuna meta. ");
INSERT INTO hchNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Mericüsü 'anutaüyepai meheta'axüacu Catarenatari vacuiepapai yuhutatü menenucunaque teuquiyapa meheyecüneca, cacaüyarixi 'axa memü'anene memüvaviyacai. Cuini mieme metenayu'eririyacaitüni. Hipatü mepücayüvavecai mana memu'uvanicü mücü huyeta, müme vacümana. ");
INSERT INTO hchNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Mericüsü müpaü meteniuhiva, Que petasiyurieni 'ecü, Cacaüyari pemünu'aya. 'Uva petinua petasi'uximatüanique tucari ca'aye'avecacu cuxi. ");
INSERT INTO hchNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Mericüsü memanu'uvacaisie tevapai metenicuacaitüni tuixuri yumüiretü. ");
INSERT INTO hchNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Cacaüyarixi 'axa memü'anene menitavavirieni müpaü me'utiyuatü, Xüca petasi'anuyenü'axüani, mana püta quetananunü'a cuerietü tuixuri temüvaviyacü. ");
INSERT INTO hchNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Müpaü tinivarutahüave, Xequenehu manapaitü. Mana mehecüneca menivarutiviyaxüani tuixuri. Yunaitü tuixuri meniutinausa. 'Axa 'anecüa meneucanausaxüaximeni haracunapa. Hapa meniucuini. ");
INSERT INTO hchNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Hicü vahüvemete meniyuta'unaxüani. Quiecarisie meheta'axüaca metenicuxatacaitüni naime teüteri cacaüyarixi 'axa memü'anene memüvaviyacai vahepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Hicü quiecatari yunaitü mecanivayecüne meheinaquiyuca Quesusi. Me'ixeiyatü vaüriyarica menipitüacaitüni müyemiecü vacuiepa mücayuhayevanicü. ");
INSERT INTO hchNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Mericüsü canuvasie 'acayerüca 'anutaüyepai neyani. Yuquiecarisie ninuani. ");
INSERT INTO hchNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Hicü huriecame meni'atüirieni 'itarisie yecaime. Quesusi vaxeiyatü yuri que memüte'eriecai müpaü tinitahüave huriecame, 'A'iyari queneucayesa nenive. 'Ari pepüreuyehüviyari 'axa pemütiuyuricü. ");
INSERT INTO hchNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Hicü hipatü 'inüaricü memüte'üquitametetücai müpaü meteniyücühüavecaitüni yu'iyarisie, Cari 'icü pisevixima Cacaüyari 'axa 'utaitü. ");
INSERT INTO hchNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Quesusi va'iyaritüarica maitü, müpaü niutayüni, Titayariri 'axa xeteyu'iyaritüatüve yu'iyarisie. ");
INSERT INTO hchNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Tita masi caticuanive. Que ticuanive müpaü mütayünicü, pepüreuyehüviyari 'axa pemütiuyuricü 'utaitü. Caticuanive masi müpaü püta mütayünicü, quenanucuquexi quenecuyeicani 'utaitü. ");
INSERT INTO hchNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Para yaxemütemaicacü quename heiserie nehexeiya cuiepa nemütivareuyehüvirienicü 'axa memüte'uyuricü, Yuri Tevi nehücütütü, hicü müpaü tinitahüave huriecame, Quenanucuquexi, 'a'itari quenacuetü, 'aquie quenemie. ");
INSERT INTO hchNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Hicü 'anucuqueca yuquie neyani. ");
INSERT INTO hchNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Teüteri me'ixeiyaca menimamacaitüni. 'Aixüa meniutiyuanecaitüni Cacaüyari hepaüsita, heiserie müvarupitüacü teüteri müpaü memüteyurienicü. ");
INSERT INTO hchNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Hicü Quesusi 'uma 'uyemietü nixeiya tevi Mateu titevacame mana 'acaime memüte'ayutituayasie. Müpaü tinitahüave, Nehesie quetineviyani. 'Anucuqueca hesiena tiniuviya. ");
INSERT INTO hchNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Mericüsü Quesusi mana catinicuacaitüni quita. Yumüiretü cuviyexunusie mieme memüteyetuiriyari, 'axa teyuruvamete meta me'u'axüaca Quesusimatü teyü'üquitüvametemama vahamatü metenicuacaitüni 'axeicüa. ");
INSERT INTO hchNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Pareseusixi mevaruxeiyaca müme, müpaü metenivarutahüave teyü'üquitüvametemama, Titayaricutaxi müme cuviyexunusie mieme memüteyetuiriyari vahamatü 'axa teyuruvamete vahamatü ticua'a mücü tixe'üquitüvame. ");
INSERT INTO hchNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","'Iya varu'enieca müpaü niutayüni, 'Aixüa memüteheu'erie mepücaheiyehüva tiyu'uhayemavame. Müme memütecucuye püta mecaneiyehüaca. ");
INSERT INTO hchNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Peuyevese cuxi yaxemüteyü'üquitüanicü que maine mücü niuqui müpaü manuyüne, Nepünaqui'a xüca xeteyucanenimayaca, peru mavari xeicüa pücanesinaque, manuyüne. Ne que nemütinua, nepücanua nevata'inienique müme heiseriemecü yamemütecahu. Müme 'axa memüteyurie püta nevata'inienique nepunua, memütehayevanicü que memüteyuriecai. ");
INSERT INTO hchNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Hicüsüari Vani teyü'üquitüvametemama Quesusisüa meniu'axüani müpaü me'utiyuatü, Tame, Pareseusixi meta, titayari tete'utatihaquiva, 'ahesüa miemete teyü'üquitüvamete mecayutihaquivacacu. ");
INSERT INTO hchNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Quesusi müpaü tinivarutahüave, Neüquiyapa que meteyüvave 'ixüaramete memüyuheiveriecacü mexi neneüqueme vahamatü 'a'uca. Tucari canaye'amücü quepaucua neneüqueme mütihanieni vasata. 'Anari meniyuhaquicuni. ");
INSERT INTO hchNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Tevi 'ixuriqui mücayutatutuvecü püca'imanesiquitüani 'ixuriqui müye'i. Manesiquiyari müpaü mü'ane 'ixuriqui pütahana, sanimeyari masi 'axa 'anetü payeica. ");
INSERT INTO hchNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Yaxeicüa sixai müyeye'isie pücacatuariva caxie vinuyari mücuanacü. Me xüca müpaü tiuyurienique, sixai nitisaniqueniqueyu. Vinu nitayeuriveniqueyu, sixai neuyeveniqueyu. Masi sixai mühehecuasie pücatuariva caxie vinuyari mücuanacü. Mücücü naitü püyuhayevani. ");
INSERT INTO hchNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Müya tivacuxaxatüvacacu, teüteri va'uquiyari xevitü nuaca nenevieri canipitüani ya'utaitü, Nenive nemüni xique 'uca. Masi quenemie queneutime'i hesiena, nanutanierimücü. ");
INSERT INTO hchNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Quesusi 'anucuqueca neiveiya, teyü'üquitüvameteta 'üaritü. ");
INSERT INTO hchNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Hicü 'uca 'aura caniuyani müticuyecai, tamamata heimana huta viyari müyuriecai xuriyaya caheunuavecacu. Varitana 'uyemietü nimayüani 'ücarieya putuniyarisie. ");
INSERT INTO hchNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Yu'iyarisie müpaü tiniyücühüavecaitüni, Xüca ne'imayüani siqueresü 'ücarieya xeicüa, nepanayeveni. ");
INSERT INTO hchNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Quesusi ta'aurie 'aveca 'ixeiyaca müpaü niutayüni, 'A'iyari queneucayesa nenive. Yuri pemüti'eriecü pepanayehüiyari. 'Anatütü nanayeveni 'uca. ");
INSERT INTO hchNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Hicü Quesusi va'uquiyari quie henuaca, cürautavivamete varuxeiyaca teüteri meyuxamuriecame meta, ");
INSERT INTO hchNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","müpaü tinivarutahüave, Xequenanuyecüni. 'Üimari pücamüqui. Pucusu masi. Meninanaimacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Peru varanuyenü'axüacu teüteri, mana heutahacu, 'iviyacu mamayasie, nanucuqueni 'üimari. ");
INSERT INTO hchNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Müpaü pütiutamarivaxü mücü cuiepa naisarie. ");
INSERT INTO hchNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Mericüsü mana 'anuyeyacu, yuhutatü meniveiyacaitüni Quesusi memacücüpecai, meniutihivacaitüni müpaü me'utiyuatü, Raviri pemünu'aya, quetanenenimayaca. ");
INSERT INTO hchNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Quita heutahacu müme memacücüpecai 'aura menacüne. Quesusi müpaü tinivarutahüave, Yuri xete'erie quename müpaü neyüve. Müpaü mete'icühüave, Hü Ti'aitame. ");
INSERT INTO hchNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Hicü nivaramayüaxüani vahüxita müpaü 'utaitü, Yuri que xemüte'erie yaxeque'itüarieni. ");
INSERT INTO hchNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Meheunenieretü menacüne. Hicü Quesusi cuini mieme nivarupitüani yuhaxüama ya'utaitü, Neuxei, xevitü tüma pücaretimani. ");
INSERT INTO hchNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Müme masi mehecüneca metenicuxatacaitüni mücü cuiepa naisarie. ");
INSERT INTO hchNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Hicü mehecünecu müme hesüana caniu'atüarieni tevi münenuriecai cacaüyari 'axa mü'ane miviyacaicü. ");
INSERT INTO hchNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","'Enuyenü'acu cacaüyari 'axa mü'ane, nenurie niutaniuni. Teüteri menihüxiyacaitüni müpaü me'utiyuatü, Hasuacu müpaü 'anetü pücamarivacai haitüarie 'Ixaheri cuieyarisie. ");
INSERT INTO hchNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Perusü Pareseusixi müpaü meniutiyuanecaitüni, Cacaüyarixi 'axa memü'anene tiva'aitüvame miparevicü, 'ayumieme nivaranuyenü'axüani cacaüyarixi 'axa memü'anene. ");
INSERT INTO hchNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Mericüsü Quesusi naime quiecaritesie 'emacuyeyeusie 'esimüyeyeusie canicuyeicacaitüni ticu'üquitanetü vatuquiteta, ticuxatatü niuqui 'aixüa manuyünecü, que müti'ane Cacaüyari ti'aitametücacu ticuxatatü, varanayexürüvatü müme naime cuiniyacü naime veranariyacü memütecucuyecai. ");
INSERT INTO hchNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Teüteri yumüireme vaxeiyatü, nivarutinenimayata, memü'uximatüariecaicü mematixürüvecaicü, muxasi memücaheixeiya yühüveme vahepaü. ");
INSERT INTO hchNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Hicü müpaü tinivarutahüave yuhesüa miemete teyü'üquitüvamete, 'Isanari püvaücava, 'isanamete mepücayumüire. ");
INSERT INTO hchNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","'Ayumieme xequeneutavaviri 'isanari cusiyari, 'isanamete müvatanü'axüanicü yu'isanarita. ");
INSERT INTO hchNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Mericüsü teyü'üquitüvamete varuta'inieca yu'aurie tamamata heimana yuhutame hesüana memümiemetetücai, heiserie nivarupitüani cacaüyarixi memüca'itiyatüca vahepaüsita memüvaranuyenü'axüanicü, memüvaranayexürüvanicü müme naime cuiniyacü naime veranariyacü memütecucuyecai. ");
INSERT INTO hchNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Nü'arisixi tamamata heimana yuhutatü müpaü mecatenitetevaca. Simuni meri Pecuru mütitevacai, 'Atürexitari mü'ivayatücai, Cacuvu Vani meta mü'ivayatücai, Severeu memünivemamatücai, ");
INSERT INTO hchNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Piripe Parüturume meta, Tumaxi Mateu meta cuviyexunusie mieme mütiyetuiriyarüvacai, Cacuvu 'Aripeu münu'ayatücai Reveu meta Tareu mütitevacai, ");
INSERT INTO hchNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simuni mücananisitatücai Cura meta 'Isicariutitanaca 'arique miyetua Quesusi. ");
INSERT INTO hchNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Mericüsü 'ime Quesusi nivareutanü'axüani tamamata heimana yuhutame müpaü tivaruta'aitüaca, Müme memücatateüterima vahuyeta xepücaheuhuni. Samariyatari vaquiecarisie xepücaheutahaxüani. ");
INSERT INTO hchNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Masi muxasi memeuyexürüve vahesüa xequeneuhuni, 'Ixaherisixi teüteriyari vahesüa. ");
INSERT INTO hchNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Xe'uyehutü 'ipaü xequetenecuxatani, Canayehuraniri, cuitü que mü'ane taheima müti'aita 'enata pisutüani ti'aitatü, müpaü xe'utiyuatü. ");
INSERT INTO hchNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Xequenivaranayexürüvani tecuicuicate, xequenivaranutanieritüvani müquite, xequeniva'itieca müme cuiniyacü memüca'itiyatüca, xequenivaranuyenü'axüa cacaüyarixi 'axa memü'anene. 'Asixecatecuetatüarietü xepüte'umiquie, 'asixecateyucuetatüatü xequetenivamicuani. ");
INSERT INTO hchNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Xepücahenu'üveni ni huru ni pürata ni cuvüre tuminiyari yuvivurasie. ");
INSERT INTO hchNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Xerai xepüca'anuhuruvani huyeta mieme. Huta 'ücayari ya cacai xepüca'anu'üni. Mumuxi xepüca'anucueni. Ti'ivamesie pütinaque yu'icuai mümiquienicü yu'ivarica. ");
INSERT INTO hchNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Quiecarisie quepaucua xemeutahaxüani 'amacuyevasie ya 'esimüyevasie, xequenecuvava que mü'ane mana meca 'aixüa mütiuca'iyari. Hesüana xequeneyuhayevani 'asita quepaucua que xemüyehu. ");
INSERT INTO hchNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Quita xeheutahaxüaximetü vaürisica xequenepitüaca quiecame. ");
INSERT INTO hchNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Xüca quiecame 'aixüa tiuca'iyarini, xevaürisica queyuhayevani hesiena. Me xüca 'aixüa catiuca'iyarini, xevaürisica que'acunuani xehesie. ");
INSERT INTO hchNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Que mü'ane mücaxetanaqui'erieni, que mü'ane mücayuvaüriya xeniuqui mü'enienicü, quita xevayenexüaximetü, mücü quiecarisie xevayenexüaximetü, xequeneucasixüa tumuanari yu'ücasie, mana mücayuhayevacü. ");
INSERT INTO hchNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","'Icü niuqui caniseüyeni que nemütixecühüave, tucari 'aye'ayu quepaucua 'isücame müvatahüave, Surumatari Cumuxatari 'esiva cuanivemecü meni'itüariecuni, peru mana quiecatari püta cui cuanivemecü mecani'itüariecuni. ");
INSERT INTO hchNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Neri que nemütixeheutanü'axüa, muxasi vahepaü xecaniyüacacuni 'üravesixi vasata xe'u'uvatü. 'Ayumieme xequetenemaivaveni cuterixi vahepaü, xepüca'inüca tita 'axa müti'anene cucuruxi vahepaü. ");
INSERT INTO hchNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Xequeneyucuerivayurieca teüteri vahepaüsita. Müme mepüxeyetuani yu'uquiyarima vahesüa. Mepüxetavayani yutuquiteta. ");
INSERT INTO hchNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Cuvexunarurisixi te'aitamete vahüxie xecananuhapaniecuni nehesüa xemümiemetecü. Müpaü xe'itüarietüvetü xecanivatahecüasitüiyacuni müme hipameta memücatateüterima. ");
INSERT INTO hchNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Quepaucua memüxeyetuani, müpaü xepücateyu'iyaritüaca que xemutiyuaneni, quepaü xemütevacühüaveni. 'Anaque yaxecatenipitüariecuni que xemutiyuaneni. ");
INSERT INTO hchNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Xemesü xepücahümetüni que mü'ane yamütayüni 'ana, masi xe'uquiyari 'Iyarieya canihücütücamücü que mü'ane yamütayüni xecuyuitüatü. ");
INSERT INTO hchNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ra'iva pürayetuani mümierienicü. Ra'uquiyari niyetuamücü yunive. Türi meniyeha'acuni yu'uquiyarima vahepaüsita, metenita'aitacuni memücui'ivacü. ");
INSERT INTO hchNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Yunaitü mecanixe'uxive'eriecacuni nehesüa xemümiemetecü. Que mü'ane tiuca'enivatü 'amuyeicani heutipareyuque, mücü canitavicueisitüariemücü. ");
INSERT INTO hchNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Quepaucua memüxe'uveiyani xeime quiecariyarisie, 'uma püta xeimesiepaitü xequeneyuta'unaxüa. 'Icü niuqui caniseüyeni que nemütixecühüave, quiecarite 'Ixaheri cuieyarisie miemete xepüca'ayenüvaveni mexi necanuaveni, Yuri Tevi que nemütihücü. ");
INSERT INTO hchNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Tiyü'üquitüvame que tiyüve me'ivacü ti'üquitame ve'emetütü. Ti'uximayatame que tiyüve me'ivacü yucusiyari ve'emetütü. ");
INSERT INTO hchNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","'Aixüa caniyümücü xüca tiyü'üquitüvame ti'üquitamepaü 'anetü 'ayani xeicüa, xüca ti'uximayatame yucusiyaripaü 'anetü 'ayani xeicüa. Mericüte, qui cusiyari xüca Peheresepuri me'itaterüva masi vaüca yamepütevataterüva hesüana miemete quiecatari. ");
INSERT INTO hchNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Xepücavamacarüca. Naitü müranucaname, xeiyarietü catinayeimücü. Tita mütiu'aviesie, mücüta masiücütü payani. ");
INSERT INTO hchNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Que nemütixetahüave tahücüate tetecuxatatü yüvipa, yaxequetenecuxatani hecüta. Tita xemüte'enie yanetixecuxaxatüvacacu xenacata, vapai yunaime vahüxie xe'uti'utü yaxequeteneuhivani. ");
INSERT INTO hchNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Xepücavamacarüca müme memüyüvave vai memümieni xeicüa, mecayüvavetü memimieni ra'iyari. Masi xequenemacarüca que mü'ane müyüve mica'una ra'iyari ravaiyari naime xasi taiyariyarisie. ");
INSERT INTO hchNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Tamüsü 'üxaviquixi que memütetuiya, yuhutatü xei senitavuyari mecate'aye'atüca. Ni xevitü müme cuiepa pücacaveni, xe'uquiyari yacatimaicacu. ");
INSERT INTO hchNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Xeme xecüpa xemu'usie mieme xexuitü puti'inüasie que mütipaüme. ");
INSERT INTO hchNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","'Ayumieme xepücaheumamaca. Yumüiretü 'üxaviquixi que memüte'aye'atüca, masi vaüca xepüte'aye'atüca xeme. ");
INSERT INTO hchNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Que mü'ane müyuhecüata teüteri vahüxie quename nehesüa mieme 'utaitü, neta quename hesiena netiviya nepünehecüata ne'uquiyari hüxie taheima macave hüxie. ");
INSERT INTO hchNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Que mü'ane masi müyuhecüata teüteri vahüxie quename nehesüa camieme 'utaitü, neta quename hesiena necativiya nepünehecüatani ne'uquiyari hüxie taheima macave hüxie. ");
INSERT INTO hchNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Que nemütinua, müpaü xepücatecu'erivani quename cuiepa memütama 'aixüa meteyuxeiyame nemüvarayeitüanicü nenua. 'Aixüa meteyuxeiyame nemüvarayeitüanicü necapunua, cusiracü memüyutacucuyanicü püta necaninuani. ");
INSERT INTO hchNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Nepunua meta vahixüata nemüvatasanacü, tevi yu'uquiyari maye'uniecacü, 'uca yuvarusi maye'uniecacü, viquivame yumu'e maye'uniecacü. ");
INSERT INTO hchNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Müme memeye'unieca tevi, quiena quiecatari mecanihümetücacuni. ");
INSERT INTO hchNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Que mü'ane vaüca müvanaqui'erie yu'uquiyari yuvarusi 'esiva nesinaqui'erietü ne, 'aixüa püca'ane münesihexeiyanicü. Que mü'ane vaüca müvanaqui'erie yunive 'uqui 'uca 'esiva nesinaqui'erietü ne, mücüta 'aixüa püca'ane münesihexeiyanicü. ");
INSERT INTO hchNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Que mü'ane yeme mücayuvaüriya 'asita curuxisie mümierieni, sepa nehamatü muyeica nehesie tiviyatü, mücüta 'aixüa püca'ane münesihexeiyanicü. ");
INSERT INTO hchNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Que mü'ane yutucari mütaxeiya pitatümaiya. Que mü'anesü mitümaiya yutucari nehesüa mümiemecü, mücü heixeiyatü payani. ");
INSERT INTO hchNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Que mü'ane müxetanaqui'erie pünesitanaqui'erie neta. Que mü'ane münesitanaqui'erie canitanaqui'erienita 'iya münesiheyenü'a. ");
INSERT INTO hchNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Que mü'ane mitanaqui'erie tixaxatame, he'erivatü tixaxatame mühücücü xeicüa, mücü tixaxatamepaü pütipitüarieni. Que mü'ane mitanaqui'erie tevi heiseriemecü yamüticamie, he'erivatü yamüticamiecü xeicüa, mücüta tevi heiseriemecü yamüticamiepaü yapütipitüarieni. ");
INSERT INTO hchNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","'Ime sepa memücamamarivave, que mü'ane miharitüani müme xeime, sepa xei vasuyaricü haütümecü xeicüa miharitüa, he'erivatü tiyü'üquitüvame mühücücü, niuqui caniseüyeni que nemütixecühüave, yemecü yu'ivarica püpitüarieni. ");
INSERT INTO hchNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Mericüsü Quesusi quepaucua mütiutahayevaxü tiva'aitüatü yuhesüa miemete teyü'üquitüvamete tamamata heimana yuhutame, mana caneyeyani quiecaritesie müti'üquitanicü müticuxatanicü. ");
INSERT INTO hchNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Mericüsü Vani casariyanata 'ayecaitü tiniutamarieni Cürisitu que mütiyurienecai. Nivaretanü'ani yuhesüa miemete teyü'üquitüvamete. ");
INSERT INTO hchNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Vacümana Quesusi müpaü tiniutahüave, 'Ecü petihücü que mü'ane 'umamieniquecai, nusu xeime cuxi tepücuevieca. ");
INSERT INTO hchNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Quesusi müpaü tinivaruta'eiya, Xequeneuhuniri, xequetenetaxatüa Vani tita xemüte'u'eni tita xemüte'uxei hepaüsita, ");
INSERT INTO hchNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","memacücüpe que memüte'anutaneniere, huriecate que memüte'anucu'uve, müme memüca'itiyatücatei cuiniyacü mete'itiyatü que memüte'acüca, memünacatuxietücatei meheu'enanatü que memüte'acüca, müquite que memüte'anucu'uitüariva, puvüresixi que memütecuxaxatüariva niuqui 'aixüa manuyüne hepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Mücü meta, 'aixüa cani'itüarieca que mü'ane necümana müca'ucununuitüariva. ");
INSERT INTO hchNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Mericüsü mana me'uyehuximecacu, Quesusi canisutüani tivacuxaxatüvatü teüteri Vani hepaüsita müpaü 'utaitü, Titayari xetehecucünixüa macumavesie. Haca 'ecacü 'uyuaneme que xetehecu'ixüari. Tixaü xüari. ");
INSERT INTO hchNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Mesü tita xetehecu'ixüari. Xicu 'ixuriqui müyumeni manacatücü xetehecuxei. Tixaü xüari. Tamüsü müme müyumemeni memanacatücü masi te'aitamete vaquita mepayetei. ");
INSERT INTO hchNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Mesü titayari yemecü xetehecunenierixü. Tixaxatame xexeiyaque püta xecatehecücünixüa 'acu. Hü müpaü nepütixecühüave, tixaxatame xepuxei yemecü mütixaxatame hipatü yamemücatehüme. ");
INSERT INTO hchNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","'Icü canihücütüni 'utüarica mixatacai müpaü 'anuyütü, Camü, neniuqui tuayame. Necanenunü'amücü 'ahüxiepai Micuha'aritüanicü 'ahuye Pecanuavecacu cuxi. ");
INSERT INTO hchNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Niuqui caniseüyeni que nemütixecühüave, teüteri vanivema vasata ni xevitü püca'anucuqueve Vani Ti'üyamepaü ve'emetütü. Perusü que müti'ane mücü taheima macave ti'aitametücacu, sepa tevi mücave'eme, mücüsie tiviyatü masi yemecü püve'eme, Vani hepaüna cave'emetücacu. ");
INSERT INTO hchNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Vani Ti'üyame munuasie hicüque, tita temütehexeiya que mü'ane taheima macave tati'aitüvametücacu, mücü naitü püviyariexime tüma. Me'iviyacutü mepüyucuitüve memeixeiyanicü yuhesie mieme. ");
INSERT INTO hchNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Texaxatamete yunaitü, 'inüari niuquiyarita metenicuxatacaitüni 'arique que mütiyüniquecai Vani munuaque. ");
INSERT INTO hchNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Xüca xeyuvaüriyani xemitanaqui'erienicü 'icü niuqui, mücü Vani canihücütüni 'Eriyaxi 'umamieniquecai. ");
INSERT INTO hchNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Xaütü netü mu'enaxü. ");
INSERT INTO hchNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Titapaü mete'aneneme netivaxatani hicü miemete teüteri. Türi vahepaü mecani'aneneni quiecari hixüapa memütitei memüvahivi yu'ivama ");
INSERT INTO hchNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","yame'utiyuatü, Cari yacü xeicüa tepüxecürautaviya, Xepücateneitüve. Yacü xeicüa tepütahiveriecai xehesie mieme, Xepüca'utisuanacai. ");
INSERT INTO hchNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Vani caninuani caticua'atü caye'etü. Müme müpaü meputiyuane, Cari cacaüyari 'axa mü'ane pinü'ü. ");
INSERT INTO hchNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ne püta Yuri Tevi nehücütütü necaninuani neticua'atü necu'ienetü. Müme müpaü meputiyuane, 'E'e, mücü tevi 'icuaicü xeicüa püyüane, vinucü xeicüa püyüane, püvanaqui'erie müme cuviyexunusie mieme memüteyetuiriyari 'axa teyuruvamete yunaime. Sepanetü mücü, Cacaüyari timaivetü que mütiyuriene, mücücü yacatinimasiücüni heiserie que mürexeiya. ");
INSERT INTO hchNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Hicü nisutüani varutate'atü teüteri quiecaritesie memayetecai haque türücaüyemecü mütiyurienecai müiremecü, quiecatari memücatehayevacaicü que memüteyuriecai. ");
INSERT INTO hchNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Müpaü niutayüni, Xüa 'ui Curasini quiecatari, xüa 'ui Vesaira quiecatari. Tirusie Sirunisie xüca türücaüyemecü tiuyünique que mütiuyü xehesüa, vana quiecatari meripai mepütehayevaqueyu que memüteyuriecai, mepüyuheiveriecaqueyu maixa me'anacatütü heiverica 'inüariyari, naxi meyucavirivatü. ");
INSERT INTO hchNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Müpaü xeicüa nepütixecühüave, Tirutari Sirunitari vahesie mieme pücuaniveni quepaucua 'isücame müvatahüave, peru xeme xehesie mieme cuini mieme pücuaniveni masi. ");
INSERT INTO hchNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Xemeta Caperünaumetari, que xeteyutituicaniqueyu muyuavisiepai. Müquite vahesüa xepeucaxüriyani püta. Xüca Surumasie türücaüyemecü tiuyünique que mütiuyü xehesüa, mücü quiecari püraniereniqueyu cuxi hicü. ");
INSERT INTO hchNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Müpaü xeicüa nepütixecühüave, Suruma cuieyarisie quiecatari vahesie mieme pücuaniveni quepaucua 'isücame müvatahüave, peru xeme xehesie mieme cuini mieme pücuaniveni masi. ");
INSERT INTO hchNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Mericüsü 'ana Quesusi müpaü niutayüni, Ne'uquiyari taheima pemüti'aita cuiepa meta, pamüpariyusi nepümasipitüa 'ecü, pemütiuti'avietaxücü 'icü naime memücaheitimanicü müme memüteyü'üquitüavave memütemaivave, türi püta vahesie mieme masiücüme pemayeitüacü. ");
INSERT INTO hchNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Hü ne'uquiyari, pepü'avaüriyacai müpaü pemütiyurienenicü. ");
INSERT INTO hchNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Nai netiniyetuiriyarieni, ne'uquiyari yanetipitüacacu. Xevitü püca'imaive mücü nu'aya, 'uquiyarieya xeicüa pimate. Xevitü püca'imateta 'uquiyarieya. Nu'aya xeicüa pimate mücü, me xüca nu'aya yuvaüriyani masiücüme meyeitüani xeicüa, peitimani 'uquiyarieya. ");
INSERT INTO hchNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Nehesüa xequeneu'axüa xemüte'uximayatatüve xemu'ica yunaitü. Ne nepüxe'uxipitüaca. ");
INSERT INTO hchNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Neyucu xequenanuyetecani, xenesi'enietü xequeteneyü'üquitüaca. Ne nepüca'ane'eriya, nepücatinecatave'erie ne'iyarisie. 'Uxipiya xecanetaxeiyacuni yu'iyarisie. ");
INSERT INTO hchNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Neyucu 'aixüa pü'ane, ne'ica pa'exani. ");
INSERT INTO hchNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Mericüsü 'ana Quesusi türicu ma'iviyanecaisie niuyemiecaitüni 'uxipiya tucarisie, teyü'üquitüvametemamata yunaitü. Hicü mepeuhacacuicucai teyü'üquitüvamete. Menisutüani me'itihurucatü müayari, meteniuticuatücüne. ");
INSERT INTO hchNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Hicü Pareseusixi mevaxeiyatü müpaü metenitahüave Quesusi, Neuxei, 'ahesüa miemete teyü'üquitüvamete yamepüteyurie que mücatitauniva yamütiyurienenicü 'uxipiya tucarisie. ");
INSERT INTO hchNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Mücü müpaü tinivarutahüave, Cari xepüca'iterüvavave que mütiuyuri Raviri quepaucua meuhacamücücai, müme 'utümana memu'uvacaita quepaucua memeuhacacuicucai. ");
INSERT INTO hchNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Cacaüyari quita neutahani, pa Cacaüyari hüxie mamanecai niucuani. Heiserie pücahexeiyacai miticuanicü, mümeta 'utümana memu'uvacai heiserie mepücahexeiyacai memiticuanicü, mara'acate xeicüa heiserie mepexeiyacai. ");
INSERT INTO hchNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Mücü meta, xüari xepüca'iterüvavave que maine 'inüari niuquiyari, mara'acate que memüte'itisana 'uxipiya tucari 'inüariyari tuquipa me'u'uvatü 'uxipiya tucarisie, peru vahesie pücarahüiva mücücü. ");
INSERT INTO hchNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ne masi müpaü nepütixecühüave, 'ena catinixuaveni tita cui mütive'eme, tuqui 'amüpa cave'emetücacu hepaüna. ");
INSERT INTO hchNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","'Icü niuqui müpaü manuyüne, Nepünaqui'a xüca meteyucanenimayaca, peru mavari xeicüa pücanesinaque, manuyüne, xüca xemaivavenique xepücate'uhüpaniqueyu müme 'asimemücate'uyuri vahesie. ");
INSERT INTO hchNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Mericüte, Yuri Tevi nehücütütü, 'uxipiya tucari hepaüsitata necatini'aitani. ");
INSERT INTO hchNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Mericüsü mana heyeyaca vatuquipa nenuani. ");
INSERT INTO hchNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Hicü tevi mana nayecateitüni mümamavaquicai. Müme müpaü metenita'ivaviya Quesusi, Sipara, titauniva 'uxipiya tucarisie menayehüanicü ticuicame, mehaitücaitü memitaxanetacü. ");
INSERT INTO hchNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Mücüsü müpaü tinivarutahüave, Que mü'ane xeme xüca muxa hexeiyani, muxa xüca 'uxipiya tucarisie xavata heucaveni, cativiyani mivatihanacü. Xüari piviyani. ");
INSERT INTO hchNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Mericüte, tevi cuini mieme caraye'axe, muxa mücaraye'axepaü. 'Ayumieme nepaine, canitaunivani 'aixüa mütiyurienenicü 'uxipiya tucarisie. ");
INSERT INTO hchNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Hicü müpaü tinitahüave tevi, 'Amama queneutasera. 'Itaseracu, 'aixüa 'anetü nayani yuxevitü tapa miemepaü. ");
INSERT INTO hchNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Hicü Pareseusixi mevayecüneca meniuyu'enieni hepaüsitana, que memüte'imieniquecai. ");
INSERT INTO hchNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Quesusi müpaü retimaica xaüsie neyani. Yumüiretü meniveiyacaitüni. Yunaime nivaranayexürieni. ");
INSERT INTO hchNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Vaüriyarica nivarupitüani capa masiücüme meheyeitüanicü. ");
INSERT INTO hchNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Müpaü catinaye'ani Cacaüyari que mutayü, tixaxatame Quisariyaxi ya'utainecacu, ");
INSERT INTO hchNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Camü nesiparevivame Nepenayexei Nepinaqui'erie Mücücü nepünaqui'a ne'iyarisie. Nenipitüamücü ne'iyari. Hipame nuivarite tinivataxatüamücü Tita mütiheiserie hepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Mücü pücayumieneni Püca'utahivani. Xevitü püca'i'enieni Caye 'utüa 'utaniucame. ");
INSERT INTO hchNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Haca mutapünarie püca'anumura. Cüxeme vitayari sepa mücuauniya püca'icutüsani Mexi 'e'ivarüme naime Mücü yatipitüacacu Tita mütiheiserie. ");
INSERT INTO hchNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Müme memücatateüterima Yuri mepüte'erieca Que mü'ane mühücüsie. ");
INSERT INTO hchNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Hicüsüari hesüana caniu'atüarieni tevi cacaüyari 'axa mü'ane minücai macüpecai mücaniuvecai. Quesusi nenayehüani. Nenuriecame niuvetü nayani, heunieretü ratüa. ");
INSERT INTO hchNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Memüyumüirecai yunaitü menihüxiyacaitüni. Müpaü meniutiyuanecaitüni, Cari 'icü Raviri Nu'aya catihücü. ");
INSERT INTO hchNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Pareseusixi masi me'u'enanaca müpaü meniutiyuani, 'Icü xüca Peheresepuri cacaüyarixi 'axa memü'anene mütiva'aitüva ca'inücaque pücavaranuyenü'axüaveniqueyu cacaüyarixi. ");
INSERT INTO hchNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Peru Quesusi va'iyaritüarica maitü müpaü tinivarutahüave, Naime cuiepa xüca quiecatari yuhixüata meyusana, mana pacumavere. Naime quiecarisie, naime quita xüca quiecatari yuhixüata meyusana, quiecari 'epücareutevini. ");
INSERT INTO hchNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Xücari Cauyumarie 'anuyuyenü'ani yücümana, yuhixüata nisane. Que reutevini ti'aitametütü. ");
INSERT INTO hchNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Mücü meta, xüca Peheresepurisie xeniu netiviyatü nevaranuyenü'avani cacaüyarixi 'axa memü'anene, que mü'anesie meteviyatü metevarunuyenü'ava xeme xenivema. 'Ayumieme müme xehesie mepüte'ahüpani. ");
INSERT INTO hchNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Mesü Cacaüyari 'Iyarieya xüca hücütüni que mü'ane münesiparevie nevaranuyenü'avacacu cacaüyarixi 'axa memü'anene, cari Cacaüyari 'ari canisutüani ti'aitatü xehesüa. ");
INSERT INTO hchNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Mücü meta, quepaü tiyüve tevi mütürücaüye quita meutahaque mütinavanicü piniteya, me xüca ca'ihüani meri mücü mütürücaüye. 'Ihüame pütitinavani tita mütixuave quitana. ");
INSERT INTO hchNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Que mü'ane nehesie mücativiya, mücü pünesi'aye'unie. Que mü'ane nehamatü müca'icuxeürie, mücü pitaxürüva. ");
INSERT INTO hchNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","'Ayumieme müpaü nepütixecühüave, naime 'axa que memüteyurie 'axa que memutiyuane teüteri, mepüyüvave memüteheuyehüviyarienicü. Peru müme memisevixima 'Iyari 'axa me'utiyuatü, müme mepücateheuyehüviyarieni. ");
INSERT INTO hchNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Que mü'ane niuqui yamütayüni nehepaüsita, Yuri Tevi que nemütihücü, mücü püyüve müreuyehüviyarienicü, peru que mü'ane 'axa 'utaitü misevixima 'Iyari Mütiyupata, mücücü pücareuyehüviyarieni 'ena cuiepa, 'umamiesieta. ");
INSERT INTO hchNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Cüye xüca xemaica quename narani 'icuaxieyata 'aixüa caniyümücü. Me cüye xüca xemaica quename xainive, 'icuaxieyata xaxainitü canayeimücü. Cüye yu'icuaxicü pümasiücü. ");
INSERT INTO hchNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Cari xeme terücaxi xepüva'ivama, quepaü xeyüvave 'aixüa xemütecuxatanicü 'axa xete'u'iyaritü. Que müranayuhayeva ra'iyari tihünecacu, yacatinicuxatamücü yutetacü. ");
INSERT INTO hchNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Tevi 'aixüa mütiuca'iyari 'icuxeürieme tita 'aixüa müti'anene yuhesie, tita 'aixüa müti'anene canivayehanimücü. Tevi 'axa mütiuca'iyari 'icuxeürieme tita 'axa müti'anene yuhesie, tita 'axa müti'anene canivayehanimücü. ");
INSERT INTO hchNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Müpaü nepütixecühüave, naime niuqui yacü xeicüa memutiniuca teüteri, mücü hepaüsita mepütiniuni quepaucua 'isücame müvatahüave. ");
INSERT INTO hchNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Que pemutayücü, mücücü heiserie pecanipitüariecamücü, mesü que pemutayücü, mücücü pepanutahüiyani. ");
INSERT INTO hchNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Mericüsü 'ana hipatü 'inüaricü memüte'üquitametetücai, Pareseusixi meta hipatü müpaü metenitahüave, Ti'üquitame 'acu, 'inüari tepüxeiyaqueyu yapetatixeisitüacacu. ");
INSERT INTO hchNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Mücü müpaü tinivaruta'eiya, Hicü miemete teüteri 'axa xepüte'u'iyari, xepüvacumaüva hipame va'üitama. 'Ayumieme 'inüari xenivautüveni, peru 'inüari xepücapitüarieni. Cunasi 'inüari que müratüa tixaxatametütü, müpaü xeicüa xecatenipitüariecuni 'inüari. ");
INSERT INTO hchNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Cunasi quesü 'amüpasie que mütiyecatei haica tucari haica tücari, müpaürita yaxeicüa Yuri Tevi que nemütiteva, cuieta nepüyecani haica tucari haica tücari. ");
INSERT INTO hchNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ninivesie quiecatari 'amepüti'uni metetahecüataque hicü miemete teüteri vahepaüsita quepaucua 'isücame müvatahüave. Hicü miemete vahesie pürahüiyani 'ana, Ninivetari memüte'uhayevaxücü que memüteyuriecai, Cunasi tivarutaxatüacu. Camüsü, Cunasi que mücatitürücaüyecai, que mü'ane cui mütürücaüye püta 'ena puyeica. ");
INSERT INTO hchNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","'Uca taserie mecatei müti'aitametücai yucuiepa, mücü 'apütaqueni titahecüataque hicü miemete vahepaüsita. Vahesie pürahüiyani 'ana, mücü meyetüacü cuie manunierepaitü, mi'enienicü Sarumuni que mütimaivecai. Camüsü Sarumuni que mücatimaivecai, que mü'ane cui mütimaive püta 'ena puyeica. ");
INSERT INTO hchNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Xevitü cacaüyari müyusevixima 'ixüname tevi, macuvaquisie pücuyeicani 'uxipiya cuvaunetü, yutexienetü. ");
INSERT INTO hchNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","'Ana müpaü pütayüni, Nequie nepüyemie nemüvayetüasie. Nuame heutaniereme xüca 'ixeiya 'uyemaveme vaye'itiyacame 'aixüa tiuye'aneme, ");
INSERT INTO hchNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","'ana püyemie, hipame püvata'inieni cacaüyarixi 'atahutame masi cuini mieme 'axa memü'anene. Meheutahaxüame, muva me'ayetetü mepacüne yunaitü. 'Imatürieca mücü tevi masi yemecü 'axa 'itüarienetü payani, müca'itüarienecaipaü matüaripai. Müpaüta mecani'itüariecuni 'icü teüteri hicü miemete 'axa memüteyurie. ");
INSERT INTO hchNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Tivacuxaxatüvacacu cuxi teüteri yumüireme, varusieya 'ivamama tacua meniti'ucaitüni me'ihüavicutü. ");
INSERT INTO hchNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Xevitü müpaü tinitahüave, Neuxei, 'avarusi 'a'ivama tacua meniti'uca memasihüavicutü. ");
INSERT INTO hchNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Quesusi müpaü tinita'eiya niucame, Que hateri nevarusi ne'ivama. ");
INSERT INTO hchNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Yumama 'utaseratü yuhesüa miemete teyü'üquitüvamete vahepa, müpaü niutayüni, Camü nevarusi ne'ivama. ");
INSERT INTO hchNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Que mü'ane yamütiyuriene que mütinaque ne'uquiyari taheima macave, mücü canine'ivatüni caninevarusitüni. ");
INSERT INTO hchNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Mericüsü 'ana Quesusi quita hayeneca, haracuna tesita niutayerüni taniunique. ");
INSERT INTO hchNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Hicü teüteri yumüiretü meniuyucuxeürieni 'auriena. 'Ayumieme canuvasie püta nicayerüni, mana yecaitü tini'üquitacaitüni, teüteri xiecaripa meti'ucacu. ");
INSERT INTO hchNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Vaüca tinivaruti'üquitüani 'üxasi hepaüsita ticuxatatü, ya'utaitü, Mericüsü ti'ivivame neyani, ni'ivienecaitüni. ");
INSERT INTO hchNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Mericüsü 'imüari 'ivienecacu, hipatü huye tesita niucaxürieni. Viquixi me'ucaxürieca menicuteüxü. ");
INSERT INTO hchNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Hipatüta ayeparisie tiucaxüri vaüca müca'acucuieyasie. Cuitüva niutineni cuie 'emücasuicaicü. ");
INSERT INTO hchNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Tau hanecu maxürixü niucuini, niutivani mücahananayatücateicü. ");
INSERT INTO hchNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Hipatüta xuyasata mucaxüri, xuya tupiriyayari 'utiyüraca heimana puyetüa. ");
INSERT INTO hchNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Masi hipatüta cuie 'aixüa mü'anesie niucaxürieni. Putixuaverixü, hipatü xei sienituyari nayani, hipatü haica teviyari ratüa, hipatü xei teviyari heimana tamamata ratüa. ");
INSERT INTO hchNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Xaütü netü mu'enaxü. ");
INSERT INTO hchNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Mericüsü teyü'üquitüvamete 'aura me'acüneca müpaü metenita'ivaviya, Titayari 'üxasi hepaüsita peticuxatatü xeicüa petiva'üquitüa. ");
INSERT INTO hchNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Mücü müpaü tinivaruta'eiya, Xeme xecaniupitüarieni xemimaicacü tita müti'aviesiecai, xemütemaicacü que müti'ane ti'aitametücacu que mü'ane taheima macave. Müme püta müpaü mepücatepitüarie. ");
INSERT INTO hchNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Que mü'ane tixaütü mürexeiya tavari cuxi pütimiquieni, manayuhayevanicü. Que mü'ane mümave, sepa que mütitita mürexeiya, pütinavaiyarieni. ");
INSERT INTO hchNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","'Ayumieme 'üxasi hepaüsita neticuxatatü nepütiva'üquitüa, memücaheunenierecü sepa cui memütaneniere, memücaheu'enanacü sepa cui memüta'enana, 'asimemücatemaivavecü. ");
INSERT INTO hchNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Vahesie pütiunaquixü tita mütixatacai tixaxatame Quisariyaxi ya'utaitü, Cui xepüta'enanaca peru xepücatemaivaveni. Cui xepütaneniereni peru tixaütü xepücatexeiyani. ");
INSERT INTO hchNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","'Icü teüteri yu'iyarisie mepüyü'üraraxie, Yunacacü haveri mieme xeicüa mepeu'enana. Vahüxie pü'itutupe. Me xüca müpaü meca'anenique Yühüxicü mepeuneniereniqueyu Yunacacü mepeu'enanacaqueyu Yu'iyarisie mepütemaivaveniqueyu, Ta'aurie mepaxürieniqueyu, Nepüvaranayexürieniqueyu ne. ");
INSERT INTO hchNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Xeme masi 'aixüa xepu'itüarie xemeunenierecü yühüxicü, 'aixüa xepu'itüarie, xemeu'enanacü yunacacü ");
INSERT INTO hchNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Niuqui caniseüyeni que nemütixecühüave, yumüiretü texaxatamete, yumüiretü teüteri heiseriemecü yamemütecahucai, müme mepixeiyacucai tita xemütexeiya xeme, peru mepüca'ixei. Mepi'eniecucai tita xemüte'enie, peru mepüca'i'eni. ");
INSERT INTO hchNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Mericüte, xequeneu'enana 'üxasi hepaüsita, ti'ivivamesie que mütimasiücü 'üquisica. ");
INSERT INTO hchNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Que mü'ane mi'enie 'icü niuqui que müti'ane 'Iya ti'aitametücacu maine, peru 'asimücaretimaive, que mü'ane 'axa mütiyuruva nuame pinavairieni tita 'iyarieyasie mütiuca'iviya. Müpaü cani'itüarieca huye tesita muca'iviyapaü. ");
INSERT INTO hchNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","'Ayeparisie muca'iviya, mücü canihücütüni que mü'ane mi'enie niuqui, yutemavietü mitanaqui'erie xei mieme. ");
INSERT INTO hchNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Yücümana pücahananatave, 'apücareutere masi. 'Ayumieme quepaucua mü'uximatüarie, quepaucua muveiyarie 'icü niuqui hepaüsita, yapaucua niucunitüarivani. ");
INSERT INTO hchNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Mücü meta xuyasata muca'iviya, mücü canihücütüni que mü'ane mi'enie niuqui, peru püyu'iyaritüa tita cuiepa mütimieme ra'erivatü, pütiyu'irüviya tuminicü yutemavietü. 'Ayumieme niuqui panunamiyari cacaniutixuavere. ");
INSERT INTO hchNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","'Aixüa mü'anesie muca'iviya, mücü canihücütüni que mü'ane mi'enie niuqui, meitima. Mücü niutixuxuavereni, hipatü xei sienituyari pacü, hipatüta haica teviyari racü, hipatüta xei teviyari heimana tamamata racü. ");
INSERT INTO hchNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Mericüsü tavarita 'üquisica nivarumini 'üxasi hepaüsita ticuxatatü, müpaü 'utaitü, 'Ipaü catini'aneni, que mü'ane taheima macave ti'aitametücacu. Tevi 'imüari 'aixüa mü'anene puca'ivi yuvasiyata. ");
INSERT INTO hchNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Perusü mecusucacu xevitü mana caninuani 'eye'unietü. Hamürixa 'uca'ivieca türicusata, neyani. ");
INSERT INTO hchNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","'Utinecu sisiüravitü, tixuaverirümecacu, 'anari masiücütü nayani hamürixa. ");
INSERT INTO hchNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Hicü te'uximayatamete me'u'axüaca yucusiyarisüa, müpaü metenitahüave, Cusiyari 'acu. 'Imüari 'aixüa cati'anenecai pemica'ivi 'avasiyata. Haqueri pemieme hamürixa. ");
INSERT INTO hchNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Mücü müpaü pütivaruta'ei, Tevi münesi'aye'unie müpaü pütiuyuri. Te'uximayatamete müpaü metenitahüave, Mericüte, pecati'avaüriya temuhu, temicuxeürieni hamürixa. ");
INSERT INTO hchNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Mücü müpaü niutayüni, Tixaüsü, xücate xe'icuxeürieni hamürixa, 'axeicüa xepivatixünaxüani türicuta yünücame. ");
INSERT INTO hchNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Xequeneuhayeva 'axeicüa müvaverenicü 'isanaxaque. 'Isanari 'aye'ayu, 'ana müpaü nepütivatahüave 'isanamete, Hamürixa xequeneucuxeüri meri, xequenanahüaxüa xemititaiyacü. Türicu xequeneuti'uta necaxetunisie. ");
INSERT INTO hchNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Hicü tavari 'üxasi hepaüsita ticuxatatü 'üquisica nivarumini müpaü 'utaitü, 'Ipaü püti'ane ti'aitametücacu que mü'ane taheima macave. Musitasa 'imüariyaripaü cani'aneni tevi mica'epaü yuvasiyata. ");
INSERT INTO hchNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","'Imüarite pücaxuave hepaüna 'anenetü 'esipepetü, peru quepaucua mütineni, tupiriyate pücaxuave hepaüna 'anenetü 'epapatü. Cüye payeica 'epatü, taheima miemete viquixi mepüyüvave hesiena memü'axüani memüyuti'ituatüani. ");
INSERT INTO hchNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Tavarita tinivaruta'üquitüani 'üxasi hepaüsita ticuxatatü, müpaü 'utaitü, 'Ipaü püti'ane ti'aitametücacu que mü'ane taheima macave. Pa cuxanariyamepaü cani'aneni. 'Uca 'ivatituca nenutinüitüani pa mütüxiyarisie haica 'axuvayarisie, 'ariqueque niuticuxanare naitü. ");
INSERT INTO hchNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Müpaü naimecü Quesusi tinivacuxaxatüvacaitüni teüteri, 'üxasi hepaüsita ticuxatatü tivati'üquitüanique. 'Üxasi hepaüsita caticuxatatü, 'asipücativacühüavecai. ");
INSERT INTO hchNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Müpaü püraye'a, Cacaüyari que mutayü, tixaxatame ya'utainecacu, 'Üxasi hepaüsita neticuxatatü nepütaniuni. Nepütitaxata tita müti'aviesiecai Cuie munetüariepai hicüque. ");
INSERT INTO hchNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Mericüsü varenü'aca teüteri quita neutahani. Teyü'üquitüvamete 'auriena meniti'uni müpaü me'utiyuatü, Quetaneutahecüasitüiya mücü 'a'üquisica hamürixa hepaüsita peticuxatatü que pemüti'üquitacai vasiyata mieme. ");
INSERT INTO hchNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Mücü müpaü tinivaruta'eiya, Que mü'ane mica'ivi 'imüari 'aixüa mü'anene, Yuri Tevi que nemütihücü ne necanihücütüni. ");
INSERT INTO hchNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Vasiya cuie canihücütüni naitü. 'Imüari 'aixüa mü'anene, müme mecanihümetüni memeixeiya que mü'ane taheima macave tiva'aitüvametüme. ");
INSERT INTO hchNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Hamürixa, mücü 'axa mütiyuruvasüa miemete mecanihümetüni. Tevi meye'uniecai quiecame, hamürixa muca'ivi, mücü Cauyumarie canihücütüni. 'Isanari, mücü tucari canihücütüni quepaucua meutipare. 'Isanamete niuqui tuayamete metehüme. ");
INSERT INTO hchNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Hamürixa que mütiucuxeüriya que mütiutitaiyari taipa, müpaürita catiniyümücü quepaucua maye'ani. ");
INSERT INTO hchNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Yuri Tevi que nemütihücü, nepüvatanü'axüani nehesüa miemete niuqui tuayamete. Müme mepüvacuxeürieni teüteri memüteyucununuitüva, teüteri yamemüteyurie que mücatiheiserie, mevanücacu müme memünesihexeiya netiva'aitüvametücacu. ");
INSERT INTO hchNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Memücuxeüriyani, müme mepüvareucaxürieni huxunuta müvatitatavesie. Muva meputisuanani mepüyutaqueveni. ");
INSERT INTO hchNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Müme heiseriemecü yamemütecahu püta memamarivavetü mecanacünicuni 'ana haque va'uquiyari müra'aita, tau que mütimerücaüye. Xaütü netü mu'enaxü. ");
INSERT INTO hchNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Mericüsü 'ipaü catini'aneni que mü'ane taheima macave ti'aitametücacu. Vaücava tuminipaü cani'aneni mü'aviesiecaipaü cuieta. Tevi heitaxeiyaca tavari niti'avieta. Cui yutemavietü, mana neyani, catinetuani nai mürexeiyacai neinaneni mücü cuie. ");
INSERT INTO hchNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Tavarita 'ipaü catini'aneni que mü'ane taheima macave ti'aitametücacu. Tituayame picuvaunecai perüra visi mü'anene. ");
INSERT INTO hchNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Xeime perüra hetaxeiyaca cuinie müraye'axecai, mana neyani, tinetuani nai mürexeiyacai, mücü tuminiyaricü neinaneni perüra. ");
INSERT INTO hchNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Tavarita 'ipaü catini'aneni, que mü'ane taheima macave ti'aitametücacu. Vipipaü cani'aneni haramarasie meucahanivapaü. Mücücü ha tesita mepüvaratinetüa quesüte yücü me'aneneme yusata. ");
INSERT INTO hchNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Quepaucua memutahünixü, menenatihana haramara tesita. Mana metitetü 'aixüa memü'anene menivaranuyeteüxü, menivareucaxürieni quirivasie, 'axa memü'anene mepüvarexüri. ");
INSERT INTO hchNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Müpaürita catiniyümücü quepaucua meutipare. Niuqui tuayamete meneutayeixüani, menivaranuyeteüxicuni 'axa teyuruvamete memüvanü'ü müme heiseriemecü yamemütecahu, ");
INSERT INTO hchNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","mepüvareucaxürieni huxunuta müvatitatavesie. Muva meputisuanani mepüyutaqueveni. ");
INSERT INTO hchNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Hicüsüari müpaü tinivarutahüave, 'Icü xetehetima naime. Hü mete'icühüave. ");
INSERT INTO hchNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","'Iya müpaü tinivarutahüave, Mericüte, 'ayumieme nepaine, que mü'ane 'inüaricü müti'üquitame, quepaucua yamüretimanicü que müti'ane ti'aitametücacu que mü'ane taheima macave, mücü tevipaü caniyüaneni quicü mühüritüariepaü. Yayüanetü, yupinisata pütivayehapa tita xique mütimieme tita meripai mütimieme meta naime. ");
INSERT INTO hchNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Mericüsü Quesusi tiuhayevaca müpaü ti'üquitatü 'üxasi hepaüsita ticuxatatü, mana heyeyaca niuyupata. ");
INSERT INTO hchNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Yuquiecari nuaca tiniva'üquitüacaitüni vatuquita. Müme 'ayumieme menihüxiyacaitüni. Müpaü meniutiyuanecaitüni, 'Icü meixeiya, haque pemieme que mütimaive türücaüyemecü que mütiyuriene. ");
INSERT INTO hchNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","'Icü carüpiniteru catinu'aya. Varusieya Mariya catiteva, 'ivamama meta Cacuvu Cuse Simuni Cura mecateteteva. ");
INSERT INTO hchNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","'Ivamama 'ucari yunaitü 'uva mecatetitei tahesüa. Haquesüari pemieme 'icü naitü que mütiyuriene. ");
INSERT INTO hchNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Menitixeümani. Hicü Quesusi müpaü tinivarutahüave, Tixaxatame naisarie ve'eme cani'erivani. Yucuiepa xeicüa yuquita ve'eme püca'eriva. ");
INSERT INTO hchNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Mana vaüca pücatiuyuri türücaüyemecü, müme yuri memücate'eriecaicü. ");
INSERT INTO hchNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Mericüsü 'ana Herurexi canihüritüariecaitüni mücü cuiepa müti'aitanicü. Caniu'ena Quesusi hepaüsita que müraniuvacai. ");
INSERT INTO hchNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Müpaü tinivarutahüave memipareviecai, Cari Vani canihücütüni Ti'üyame. 'Umüca panucuque, 'ayumieme türücariya nicuyuitüvani. ");
INSERT INTO hchNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Mücü Herurexi yatiuta'aitacu meripai, niuviyarieni Vani, niuhüiyani, nanutahüiyani casariyanata, müpaü mütinaquecaicü Heruriya. ");
INSERT INTO hchNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Müpaü tiniuyüni, Vani caviyarievetü cuxi müpaü mütitahüavecaicü Herurexi, Pücatauniva pemevitücünicü, 'utaitü, Heruriya xatatü. Mücü Heruriya, Herurexi canicueyatücaitüni meri, ca'inavairievecacu cuxi yu'iva Piripe mütitevacai. ");
INSERT INTO hchNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herurexi pimiemücücai Vani, peru püvamacarücai teüteri, quename tixaxatametücai memütecu'erivacaicü. ");
INSERT INTO hchNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Mericüsü tucarisie quepaucua Herurexi mutinuivaxüsie, Heruriya nu'aya 'ucatütü tiniutineini vahüxie. Pinaquecai Herurexi. ");
INSERT INTO hchNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","'Ayumieme puyühüritüa, quename tita mütitavavirieniqueyu timiniquecai, 'utaitü. ");
INSERT INTO hchNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","'Iya varusieya yatitahüavecu müpaü tinitahüave, Vani Ti'üyame mu'uya queneneu'üitüa 'ena pateyusie yecaime. ");
INSERT INTO hchNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ti'aitame cui yuhiverietü müyühüritüacaicü teüteri hamatüana memütecuacai vahüxie, tiniuta'aita mütimiquienicü. ");
INSERT INTO hchNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Neinü'ani cuya tita'aitüaca Vani mu'uya manuxitenicü casariyanata. ");
INSERT INTO hchNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Mu'uya 'atüariecu pateyusie yecaitü, 'üimari 'umiquieca, pi'üitüa yuvarusi. ");
INSERT INTO hchNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Hicü Vani teyü'üquitüvametemama me'u'axüaca meneicueni caxarieya, meneicateucu. Meheyecüneca meteneitaxatüani Quesusi. ");
INSERT INTO hchNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Mericüsü Quesusi tiutamarieca, neyani canuvasie cayerüca macumavesiepaitü yuxaüta. Teüteri mete'utamarieca, yü'ücama menecüne quiecaritesie meheyecüneca hepaüsitana meheta'axüanique. ");
INSERT INTO hchNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Hicü 'anatiyeiximetü Quesusi, teüteri nivaruxeiya yumüireme. Vanenimayatü, nivaranayexürieni vahesüa miemete tecuicuicate. ");
INSERT INTO hchNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Hicü 'ucutaicairecu teyü'üquitüvamete 'auriena meniuyucuxeürieni müpaü me'utiyuatü, 'Ena canacumaveni, cananucayaniri memütecuaniquecaicü. Quenivareutanü'axüani teüteri, quiecaritesie memütayeixüanicü, 'icuai memüteyutinanairienicü. ");
INSERT INTO hchNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Quesusi masi müpaü tinivarutahüave, Pücaheuyevese memüyehucü. Xeme püta xequetenivarumicua. ");
INSERT INTO hchNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Müme müpaü metenita'eiya, Quete 'ena tixaütü tepücatehexeiya, 'auxüme payari huta quesüteyari xeicüa tepexeiya. ");
INSERT INTO hchNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Müpaü tinivarutahüave, 'Uva nehesüa xequenatua. ");
INSERT INTO hchNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Hicü tivaruta'aitüaca teüteri memücuyaxixüanicü 'üxapa, 'enu'üca 'auxüme payari huta quesüteyari meta, taheima heutiniereca niyutanenevieni. 'Ititaraca pa nivaru'üitüani teyü'üquitüvamete, müme menivaruta'üitüani teüteri. ");
INSERT INTO hchNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Yunaitü meniticuani meniutihuxani. Hicü menicuxeürieni tarimeyari manuyuhayevaxü, menitihüniya tamamata heimana huta quirivayari. ");
INSERT INTO hchNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","'Uquisi memüte'ucuai 'auxüme miriyari yacütütü mecaniyupaümecaitüni, 'ucari türi meta mepüca'inüaricai. ");
INSERT INTO hchNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Hicüsüari nivarutamexüitüani teyü'üquitüvamete, canuvasie memücayaxecü memenucuhaitüiyacü 'anutaüyepaitü, 'arique püvarenü'a teüteri. ");
INSERT INTO hchNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Varenü'aca, yemurisie neutiyune yuxaüta yutanenevienique. Hicü 'ucuyürecu mana necateitüni yuxaüta. ");
INSERT INTO hchNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Hicü canuvasie meyetetü ha hixüapa meneutahucaitüni. Cuie hetevacacu, hamevari picuyuitüvacai canuva, hepana mu'ecacaicü. ");
INSERT INTO hchNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Mericüsü 'esivatücacu tuxacüta, vahepa canamiecaitüni Quesusi haracuna heima 'umietü. ");
INSERT INTO hchNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Teyü'üquitüvamete me'ixeiyatü haracuna heima 'amiecame, meniyumuinacaitüni, müpaü meteniyücühüavecaitüni, Tietü 'iyari 'uyüximeni. Memamatü meniutihivacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Hicü Quesusi niutaniuni müpaü tivacühüavetü, Yu'iyari xequeneucayasa, ne nepühücü. Xepücamamaca. ");
INSERT INTO hchNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Hicü Pecuru müpaü tinita'eiya, Ti'aitame xüca 'ecü pehücütüni, quenetineuta'aitüa mana nemümiecü 'ahesüa, ha heima ne'umietü. ");
INSERT INTO hchNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","'Iya rehüave, Quenaye'a. Canuvasie 'anacayaca Pecuru, ha heima namiecaitüni. Mana hura ninuani Quesusi manuvecaisie. ");
INSERT INTO hchNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","'Ixeiyaca 'eca que mütiu'ecacai niutimani. Nicayunirümecaitüni. Niutahiva müpaü 'utaitü, Ti'aitame queneneutavicueisitüa. ");
INSERT INTO hchNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Hicü Quesusi yumama 'utaseraca niviya. Müpaü tinitahüave, 'E'e, cari 'ecü 'esiva xeicüa yuri pepüti'erie. Titayari peti'a'iyaritüacai. ");
INSERT INTO hchNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Canuvasie mecayaxirümecacu 'eca neunuani. ");
INSERT INTO hchNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Müme canuvasie memüyetecai nenevieri mecanipitüani müpaü me'utiyuatü, Xasunicü Cacaüyari pecaninu'ayatüni 'ecü. ");
INSERT INTO hchNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Hicü 'anutaüye mehecüneca, Quenesareti cuieyarisie meneta'axüani. ");
INSERT INTO hchNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Mana quiecatari menimaicaitüni me'ixeiyaca, niuqui meneutanü'axüani 'aura yunaime vahesüa. Meni'atüirivacaitüni tecuicuicate yunaime. ");
INSERT INTO hchNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Cuini mieme menivaviriecaitüni me'imayüanique siqueresü 'ixuriquieyasie. Müme memimayüa mepanayexürie yemecü. ");
INSERT INTO hchNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Mericüsü 'ana Quesusisüa meniu'axüani Pareseusixi, hipatüta 'inüaricü memüte'üquitametetücai, Querusareme memeyecü müpaü me'utiyuatü, ");
INSERT INTO hchNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Titayaricutaxi 'ahesüa miemete teyü'üquitüvamete mete'itisana yutusima vayeiyari. Cari mepüca'ucamaimava quepaucua memüte'uticua'a. ");
INSERT INTO hchNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Mücü masi müpaü tinivaruta'eiya, Titayaricutaxi xeme püta yaxecateyurie Cacaüyari que müti'aita, yuyeiyarisie xemüteviyanicü. ");
INSERT INTO hchNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Cacaüyari meripai müpaü niutayüni, Quetinivareuyehüvirieca 'a'uquiyari 'avarusi. Tavarita müpaü niutayüni, Que mü'ane 'axa mutaineni yu'uquiyari yuvarusi hepaüsita, que'umierieni xei mieme. ");
INSERT INTO hchNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Xeme püta müpaü xeniutiyuaneni, Que mü'ane xeniu müpaü müticühüave yu'uquiyari ya yuvarusi, Que nematiparevieniquecai, mücü 'imiquieri püta nepayeitüa, haitü, mücücü xeniu pücaheuyevese 'uxa'atüni varie mütivareuyehüvirienicü yu'uquiyari yuvarusi. ");
INSERT INTO hchNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Xepitürücariyapi tita Cacaüyari mütiutayü, yuyeiyarisie yaxemütecahunicü. ");
INSERT INTO hchNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Yacü xeicüa xeputiyuane. Quisariyaxi 'aixüa putayü ticuxatatü xehepaüsita, müpaü 'utaitü, ");
INSERT INTO hchNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","'Icü teüteri yutetacü xeicüa Quename meneteheuyehüvirie meputiyuane. Que memüte'u'iyari püta, teva mepu'uva. ");
INSERT INTO hchNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Yacü xeicüa menenayexeiyani Tita memüte'üquita, teüteri püta va'aisica mühücücü xeicüa. ");
INSERT INTO hchNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Mericüsü yu'aurie varutahüaveca teüteri, müpaü tinivarutahüave, Xequeneu'enana, xequetenemaivaveni. ");
INSERT INTO hchNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Tita tevi teta müreutahaque, mücücü pücaseviximarieni. Masi tita tetana müratineica, mücücü püta caniseviximariemücü tevi. ");
INSERT INTO hchNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Hicü teyü'üquitüvamete 'aura me'acüneca müpaü metenitahüave, Müpaü pecatimate, Pareseusixi mücü niuqui me'u'enieca meniuyeha'ani. ");
INSERT INTO hchNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Müpaü tinivaruta'eiya, Naitü 'iteüri ne'uquiyari taheima macave müca'ica'e püvatihuna. ");
INSERT INTO hchNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Xequenivahayevani. Me'acücüpetü mepüvarahapana hipame memacücüpe. 'Acüpetü xeime macüpe xüca 'ahanani, yuhutatü mevatixavasie meneucaxüriecuni. ");
INSERT INTO hchNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Hicü Pecuru müpaü tinitahüave, Quetaneutahecüasitüiya 'icü 'üquisica. ");
INSERT INTO hchNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","'Iya rehüave, Cari xemeta 'asixepücatemate. ");
INSERT INTO hchNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Tietüsü müpaü xecatemaica, naitü rateta müreutahaque huriepana nicayune, nihüani. ");
INSERT INTO hchNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Tita rateta müratineica 'iyarieyasie püta patineica. Mücütütü niseviximaca tevi. ");
INSERT INTO hchNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Va'iyarisie natineicani tita memüteyurie, 'axa meteyücühüavetü, meteyumemivatü, mevacumaüvatü hipame va'üitama vacünama, mevacumaüvatü que mü'ane mücayü'üya mücayücüna, metenavayatü, mete'itavatü quepaucua memütehecüata, 'axa me'utiyuatü hipame vahepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","'Icücü caniseviximarieca tevi. Peru müpaü que memütecua'a meca'ucamaimavatü, mücücü pücaseviximarieni tevi. ");
INSERT INTO hchNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Mericüsü mana heyeyaca Quesusi, Tiru Siruni cuieyarisie neyani. ");
INSERT INTO hchNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Hicü mana caninuani Canani quiecame 'uca mücü cuieyarisie heyeyaca. Niutahivacaitüni müpaü 'utaitü, Quenenenenimayaca Ti'aitame, Raviri pemünu'aya. Nenive 'uca cui püyüane, cacaüyari 'axa mü'ane pinü'ü. ");
INSERT INTO hchNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Quesusi püca'ita'ei. 'Aura me'acüneca teyü'üquitüvametemama, müpaü metenitahüave, Quenanunü'a. Tasicuveiyanetü putahiva xeicüa. ");
INSERT INTO hchNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Mücü müpaü niutayüni, Ne muxasi memeuyexürüve vahesüa xeicüa neneyenü'arieni 'Ixaheri quie quiecatari vahesüa. ");
INSERT INTO hchNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","'Uca 'aura 'ayaca niutihüximaqueni hetüana müpaü tivavirietü, Ti'aitame 'acu, queneneuparevi. ");
INSERT INTO hchNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Müpaü tinita'eiya, 'Aixüa capü'aneniqueyu xüca tevi türi vapa vanavairienique, sinurixi xüca vaminique. ");
INSERT INTO hchNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","'Uca rehüave, Xasunicü peputaine Ti'aitame, peru 'asita sinurixi mepiticua'a temüxiquiyari vacusiyarima vamexasie manacavivive. ");
INSERT INTO hchNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Hicü Quesusi müpaü tinita'eiya, 'Uca 'acu, cuini mieme yuri pepüti'erie. Que matinaque, yapeque'itüarieni. 'Anatütü cananayehüiyani nu'aya. ");
INSERT INTO hchNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Mericüsü mana heyeyaca Quesusi, haracuna tesita caninuani Carereya cuieyarisie. Yemurisie 'utiyaca mana nayerüni. ");
INSERT INTO hchNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Hicü hesüana meniu'axüani yumüiretü teüteri huriecate mevaravitütü, müme meta vamamate mütutunicai memacücüpecai memünenurietücatei hipameri yumüireme. Hetüana menivacutuacaitüni, 'iya nivaranayexürüvacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","'Ayumieme teüteri meniuhüxiyani mevaxeiyatü nenuriecate que memüteniuvavecai, huriecate que memüte'u'uvacai, memacücüpecai que memüteheunenierecai. 'Aixüa meniutiyuanecaitüni 'Ixaherisixi yucacaüyari hepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Hicü Quesusi yu'aurie varutahüaveca yuhesüa miemete teyü'üquitüvamete müpaü tinivarutahüave, Ne teüteri nenivanenimayaca. Haica tucari meniuyurieni hicü nehesüa. 'Icuai mepücahexeiya. Nepücanevaüriya meyehacacuitüveme nemüvarenü'anicü, capa metiveranaxüame mehecaxürieni huyeta. ");
INSERT INTO hchNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Hicü teyü'üquitüvamete müpaü metenitahüave, 'Uva macumavesie haque tepeicaxeiya pa yapaümeme temütevaminicü teüteri yayupaümeme. ");
INSERT INTO hchNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Quesusi müpaü tinivaruta'ivaviya, Quepaümeme xepexeiya pa. Müme müpaü meniutiyuane, 'Atahutame, quesüte meta yapaümeme 'esimepepeme. ");
INSERT INTO hchNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Tivaruta'aitüaca teüteri memücuyaxixüanicü cuiepa, pa cananucü'üni 'atahuta payari, quesüte meta. ");
INSERT INTO hchNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Pamüpariyusi 'ipitüaca Cacaüyari, nititara pa, tivaru'üitüa teyü'üquitüvamete, teyü'üquitüvameteta metevaruta'üitüa teüteri. ");
INSERT INTO hchNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Yunaitü mete'ucuaca meniutihuxani. Menicuxeürieni tarimeyari manuyuhayevaxü, 'atahuta quirivayari hüpüneme. ");
INSERT INTO hchNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Memüte'ucuai nauca miriyari mecaniyupaümecaitüni 'uquisi xeicüa, 'ucari türi meta mepüca'inüaricai. ");
INSERT INTO hchNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Hicü varutanü'axüaca teüteri canuvasie nicayerüni. Macarani cuieyarisie neyani. ");
INSERT INTO hchNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Mericüsü Pareseusixi Saruseusixi meniu'axüani. Me'i'inüatatüvetü, menitavavirieni 'inüari memüxeiyacü taheima mieme mupitüarie. ");
INSERT INTO hchNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","'Iya müpaü tinivarutahüave, Xeme taicai müpaü xeputiyuane, 'Uxa'a xüari sipüreu'aneni, camü haivitüri nixuxureni. ");
INSERT INTO hchNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ximerita hicü pücaviyerüme xeputiyuane, camü haivitüri nixuxureni 'aneusuica. Tamüsü xepimate que mütiyuxexeiya haivitüri. Cari xepücayüvave xemeitimanicü 'inüari hicü muxuave que mütiyuxexeiya. ");
INSERT INTO hchNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Hicü miemete teüteri 'axa mepüteyurie, mepüvacumaüva hipame va'üitama. Müya me'anenetü 'inüari mepücuvautüve memixeiyacü, peru 'inüari mepücapitüarieni, Cunasi 'inüari que müratüa, müpaü xeicüa mepütepitüarieni. Hicü varucu'eirieca neyani. ");
INSERT INTO hchNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Mericüsü teyü'üquitüvamete hamatüana menecüne 'anutaüyepai, peru metenatümaiya pa memanu'üniquecai. ");
INSERT INTO hchNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Hicü Quesusi müpaü tinivarutahüave, Yumarima 'aixüa, xequeneyü'üviyani tiyucuxanariyame hepaüsita Pareseusixi Saruseusixi vahesüa mümieme. ");
INSERT INTO hchNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Mücü müpaü meteniyutahüave, Pa temücaheye'üicü 'ayumieme müya canaineni. ");
INSERT INTO hchNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Quesusi retimaica que memüteyücühüavecai, müpaü niutayüni, Titayari niuqui xetexüatüa xeme, pa tepücahexeiya xeteyücühüavetü. 'Esiva cari yuri xepüte'erie. ");
INSERT INTO hchNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Cari 'asixepücatemate cuxi. Xepücahe'eriva 'auxüvime payari cümana yu'auxüvime miriyari mememiquie, quepaümeme quirivayari xemucuxeüri, ");
INSERT INTO hchNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","mesü 'atahuta payari cümana nauca miriyari mememiquie, quepaümeme quirivayiri xemucuxeüri. ");
INSERT INTO hchNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Titayari 'asixecatemate, quename pa necaxatatü müpaü netixe'utahüavixü, Xequeneyü'üviyani Pareseusixi Saruseusixi vahesüa mieme tiyucuxaniriyame hepaüsita, ne'utaitü. ");
INSERT INTO hchNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","'Anaque yamecatenetimani quename memüyü'üviyanicü tiyucuxanariyame hepaüsita cahainecai, masi Pareseusixi Saruseusixi va'üquisica hepaüsita memüyü'üviyanicü püta hainecai. ");
INSERT INTO hchNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Mericüsü Quesusi Sesareya Piripusie nuaca, nivacu'ivaviyacaitüni yuhesüa miemete teyü'üquitüvamete müpaü 'utaitü, Teüteri que me'utiyuane ne que nepüpaicü, Yuri Tevi que nemütihücü. ");
INSERT INTO hchNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Mümesü müpaü metenita'eiya, Hipatü quename vaniu Vani Ti'üyame pehücü, meputiyuane, hipatüta quename vaniu 'Eriyaxi pehücü, hipatüta quename Queremiyaxi, 'ecüsü texaxatamate xevitü pepühücü meputiyuane. ");
INSERT INTO hchNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Müpaü tinivarutahüave, Xemeta, que xe'utiyuane que nepüpaicü ne. ");
INSERT INTO hchNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simuni müpaü tinita'eiya Pecurutütü, Que mü'ane manayexeiyarie Cürisitutütü, 'ecü pecanihücütüni, Cacaüyari mayeniere pepünu'aya. ");
INSERT INTO hchNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Quesusi müpaü tinitahüaveni, 'Aixüa pepu'itüarie 'ecü Simuni Cunasi pemünu'aya. Tevi vai xuriya xeicüa hücütütü, yapücamatiu'üquitüa, masi ne'uquiyari taheima macave yamatiniu'üquitüani. ");
INSERT INTO hchNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nesü müpaü nepümaticühüave, 'ecü Pecuru pecanihücütüni, tete pemütiteva. 'Icü tetesie nepüvaruti'uitüani müme 'arique memüyutixexeürivani nehesüa miemete. Müme mepüca'a'ivarieni, sepa memücui'iva. ");
INSERT INTO hchNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Yavi nepümasi'üitüani cümana müxünarüva haque müre'aita que mü'ane taheima macave. Tita cuiepa pemücatitauni, müpaü pücatitauniyarieni taheimata. Tita cuiepa pemütitaunie, müpaü pütitauniyarieni taheimata. ");
INSERT INTO hchNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","'Ana nivaruhüritüani teyü'üquitüvamete 'asimemücatehehüavenicü xeime quename Cürisitutücai. ");
INSERT INTO hchNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Mericüsü 'ana Quesusi nisutüani tivahecüatüatü yuhesüa miemete teyü'üquitüvamete, müpaü 'utaitü, Neuyeveca Querusareme nemeutiyunecü haitü, vaüca nemüticuine ta'uquiyarima vahesüa mara'acate memühüritüarie vahesüa müme meta 'inüaricü memüte'üquitamete vahesüa haitü, nepemierieni, hairieca tucari nepanucuqueni haitü. ");
INSERT INTO hchNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Hicü Pecuru yateva heivitüca nisutüani 'icu'imaiyatü müpaü 'utaitü, Tixaü Ti'aitame. Müpaü pepüca'itüarieni. ");
INSERT INTO hchNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Quesusi cui 'enutaxeiyatü müpaü tinitahüave Pecuru, Xaüsie queneuye'a, Cauyumarie 'acu. Pepünesicunuitüamücü, Cacaüyaripaü pemücare'iyaricü, teüteri vahepaü püta pemüre'iyaricü. ");
INSERT INTO hchNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Hicü Quesusi müpaü tinivarutahüave yuhesüa miemete teyü'üquitüvamete, Tevi xüca yuvaüriyani nehamatü muyeicanicü, que'uyutatuani queyuvaüriyani sepa curuxisie mumierie, nehesie quetiviyani. ");
INSERT INTO hchNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Que mü'ane müyutavicueisitüamücü caniyutatümaiyamücü. Que mü'ane püta müyutatümaiya nehesie mieme, niyutavicueisitüamücü yemecü. ");
INSERT INTO hchNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Tevi nai cuiepa mütixuave xüca ti'ivanique, tita ra'ivaqueyu xüca yutatümaiyanique. Titacü tiyutuani tevi, yutucari mücanavaiyarienicü. ");
INSERT INTO hchNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Yuri Tevi que nemütihücü, necaninuamücü ne'uquiyaripaü nemarivetü neniuqui tuayamete vahamatü. 'Ana nepürapica, yuxexuitü que memüteyuriecai 'anaque 'amecatenapiniyariecuni. ");
INSERT INTO hchNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Niuqui caniseüyeni que nemütixecühüave, hipatü 'ena memu'uva mepücacuini mexi mecanesixeiyavave Yuri Tevi neye'acacu, neti'aitacacu. ");
INSERT INTO hchNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Mericüsü 'ataxeime tucari 'anucayacu, Quesusi canivarevitüni Pecuru, Cacuvu, 'ivaya meta Vani, yemuri 'emutevisie yühücüame. ");
INSERT INTO hchNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Hicü me'ixeiyacacu yücü 'anetü nayeitüarieni. Nayexavatüre taupaü. 'Ixuriquieya tuxatü ratüa hecüariyapaü. ");
INSERT INTO hchNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Hicü mevaxeiyacacu memasiücütü menacüne Muisexi 'Eriyaxi, hamatüana metenicuxatacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Hicü Pecuru müpaü tinitahüave Quesusi, Ti'aitame, 'aixüa cani'aneni, 'uva temu'uvacü tame. Xüari pümasinaque 'ena xamaru nemütivevieni haicame, 'ahesie mieme xeime, Muisexisie mieme xeime, 'Eriyaxisie mieme xeime. ");
INSERT INTO hchNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Taniucacacu cuxi, yapaucua haivitüri müxavatü nivareutinani. Haivitürisie xevitü niutaniuni müpaü 'utaitü, 'Icü caninenivetüni münaqui'eriva, mücücü neninaqui'aca. Xequene'enieca 'iya. ");
INSERT INTO hchNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Me'i'enieca teyü'üquitüvamete, meniutihüxima'uni cuini mieme memamatü. ");
INSERT INTO hchNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Quesusi 'aura 'ayaca, varutimayüaca müpaü niutayüni, Xequenanucu'uti xepücaheumamaca. ");
INSERT INTO hchNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Mehanenieretücüneca, Quesusi xeicüa mepuxei, xeime pücatixaü. ");
INSERT INTO hchNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Hicü yemurisie me'acanexüaximecacu, Quesusi müpaü tinivaruta'aitüani, Tita xemüte'uxei, xeme xepücatehaxaxatüvani xeime, mexi cuxi müquite vasata neca'anucuquetüarieve, Yuri Tevi que nemütihücü, 'ariqueque xeicüa. ");
INSERT INTO hchNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Hicü teyü'üquitüvamete müpaü metenitahüave, Mericüte müme 'inüaricü memüte'üquita, titayari müpaü mete'utiyuane quename heuyevese 'Eriyaxi meri munuanicü. ");
INSERT INTO hchNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Müpaü tinivaruta'eiya, Neuyeveca siepüre 'Eriyaxi meri munuanicü, 'aixüa miyurienicü naime. ");
INSERT INTO hchNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ne masi müpaü nepütixecühüave, 'Eriyaxi 'ari caninuani. Mepüca'imaicai me'ixeiyatü, masi que mütivanaquecai yamepiyurie. Yaxeicüata Yuri Tevi que nemütihücü, nepüticuine yamenesiyuriecacu hepaüna. ");
INSERT INTO hchNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","'Ana müpaü mepütehetima teyü'üquitüvamete, Vani Ti'üyame müxatacaicü. ");
INSERT INTO hchNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Mericüsü teüteri yumüiretü mana memu'uvacaisie meta'axüaximecacu, tevi 'aura caniuyani hesüana. 'Utitunumaqueca hüxiena ");
INSERT INTO hchNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","müpaü niutayüni, Ti'aitame 'acu, nenive quenenenimayaca. Püquierixie, cui püyüane. Heiva nativauseni taipa heivata hapa. ");
INSERT INTO hchNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Neniva'atüirieni 'ahesüa miemete teyü'üquitüvamete. Mepüyutatexi me'enayehüanique. ");
INSERT INTO hchNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Quesusi müpaü niutayüni, 'Acusü xeme hicü xemümiemete yuri xepücate'erie, yu'iyarisie xepüxamurie. Quepaümexa peuyevese xehamatü nemuyeicanicü, quepaümexa nepüxenevieca. Xequenavitüqui 'uva nehesüa. ");
INSERT INTO hchNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Hicü Quesusi 'itatiecu cacaüyari 'axa mü'ane minücai, pixünaxü. 'Anatütüri nanayehüiyani temaicü. ");
INSERT INTO hchNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Hicü teyü'üquitüvamete 'aura me'acüneca Quesusisüa yühücüate müpaü meniutiyuani, Titayari tete'itatexie tame te'eyenü'anique. ");
INSERT INTO hchNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Müpaü tinivarutahüave, 'Esiva xeicüa yuri xemüte'eriecü, 'ayumieme xepitatexie. Niuqui caniseüyeni que nemütixecühüave, musitasa 'imüariyaripaü 'esipemecü xeicüa xüca yuri xete'erieca, xüca müpaü xete'itahüave mücü yemuri mana muve, Queneu'apata 'uma püta, xe'utiyuatü, mücü niyupatamücü. Xeniquemacacuni naime. ");
INSERT INTO hchNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Peru yunenevietü yuhaquietü xeicüa caniyüveni meyenü'anicü müpaü mü'ane. ");
INSERT INTO hchNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Mericüsü quepaucua memuyucuxeüri Carereyasie, müpaü tinivarutahüave Quesusi, Yuri Tevi que nemütihücü, necaniyetuiyamücü teüteri vahesüa. ");
INSERT INTO hchNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Müme mecanenimiecuni. Hairieca tucarisie necananucuquemücü. Cui mepüyuhiveriecai müme. ");
INSERT INTO hchNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Mericüsü Caperünaume me'u'axüacu, müme tuqui 'amüpasie mieme tumini memücuxexeürivacai meniu'axüani Pecurusüa. Müpaü metenitahüave, 'Iya xeniu mütixe'üquitüa tuqui 'amüpasie mieme catiyutua. ");
INSERT INTO hchNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Hü, pütiyutua, rehüave. Hicü quita heutahacu 'asicatayüvecacu cuxi, Quesusi müpaü tinitahüave, Que peticu'eriva Simuni. Que hate mepücuetatüarie cuiepa memütama teva'aitüvamete vahesüa memüteyutuanicü 'amemüte'apicacü. Te'aitamete vanivema meteyutua, nusu hipatü mepüteyutua. ");
INSERT INTO hchNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pecuru, Xüari hipatü mepüteyutua 'utayücu, Quesusi müpaü tinitahüave, Mericüte, vanivema mepüxüxüni. ");
INSERT INTO hchNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Peru tepücavahaxüatüani. 'Ayumieme haracuna quenemie, mana queneucavivi cuaisü. Que 'anetü meri manuviere quesü, mücü quenanatihani. Pehenutatetapieme mana tumini pepetaxeiya 'auxüme 'inüariyari tuminiyari. Mücü quenivaye'üi quenivaruta'üitüa nehesie mieme 'ahesie miemeta. ");
INSERT INTO hchNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Mericüsü 'ana Quesusisüa meniu'axüani teyü'üquitüvamete müpaü me'utiyuatü, Mericüte, quepaicü masi cuini mieme püve'eme, taheima macave que mütivaxeiya müme mütiva'aitüa. ");
INSERT INTO hchNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Quesusi yu'aurie 'itahüaveca nunusi vahüxie nitaqueni. ");
INSERT INTO hchNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Müpaü niutayüni, Caniseüyeni que nemütixecühüave, ta'aurie xüca xeca'axürieni, türi vahepaü xe'anenetü xüca xeca'acüne yemecü xepücaheutahaxüani haque müre'aita que mü'ane taheima macave. ");
INSERT INTO hchNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Que mü'ane yuhepaüsita 'asica'utaitü mayuyeitüani 'icü nunusipaü, mücü canihücütüni que mü'ane masi cuini mieme müve'emetüni, taheima macave que mütivaxeiya müme mütiva'aitüa. ");
INSERT INTO hchNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Que mü'ane mitanaqui'erieni xeime nunusi 'icüpaü mü'ane nehesüa mümiemecü, mücü pünesitanaqui'erieni neta. ");
INSERT INTO hchNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Mesü 'ime mecavavemetetütü yuri memüte'erie nehesie, que mü'ane micunuitüa sepa xeime, 'aixüa caniyüniqueyu masi xüca mata mahete 'acatütüarienique cüipieyasie, xüca haramarasie heucahüiyanique meucatevasie. ");
INSERT INTO hchNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Xüa 'ui que me'itüarieni cuiepa memütama memüyucununuitüvacü. Neuyeveca teüteri memücunuitüarieni, peru xüa 'ui mücü tevi que mü'ane müvacunuitüani. ");
INSERT INTO hchNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Xüca 'amama masihecahüpani ya 'a'üca, quenavitequi quenehüva. 'Aixüa caniyümücü masi pemeutahanicü tucari maxuavesie pemamapurutü pe'ücapurutü, peru 'aixüa pücayüni huta mamayari huta quetayari pehexeiyatü xüca peheucahüiyani tai yuheyemecü müta'asie. ");
INSERT INTO hchNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Xüca 'ahüxi masihecahüpani, quenivayetu'i quenehüva. Masi 'aixüa caniyümücü tapa xeicüa peheunieretü pemeutahanicü tucari maxuavesie, peru 'aixüa pücayüni naisata peheunieretü xüca peheucahüiyani xasi taiyariyarisie. ");
INSERT INTO hchNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Yumarima 'aixüa xepücavatave'erieca 'ime memücavavemete, sepa xeime. Müpaü nepütixecühüave, müme vaniuqui tuayamete yuheyemecü 'amecaniu'uvani ne'uquiyari taheima macavesüa, mepicühüave. ");
INSERT INTO hchNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Yuri Tevi nehücütütü que nemütinua, nevatavicueisitüanique memeuyexürie, 'ayumieme necaninuani. ");
INSERT INTO hchNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Que xetecu'eriva. Tevi xüca xei sienituyari varexeiyani yumuxasi, xüca xevitü müme heuyeveni, hipame cativacu'eirieni hürisie nauca teviyari heimana tamamata heimana 'atanaucame, cativaumie meuyeve. ");
INSERT INTO hchNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Niuqui caniseüyeni que nemütixecühüave, xüca 'acu heitaxeiya, mücücü niyutemavieca cuini mieme, que mücatiyutemavie memücaheuyexüriecai vacü nauca teviyari heimana tamamata heimana 'atanaucame vacü. ");
INSERT INTO hchNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Müpaü yaxeicüa xe'uquiyari taheima macave pücayuvaüriya meuyevenicü sepa xevitü 'icü memücavavemete. ");
INSERT INTO hchNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","'A'iva xüca 'axa masi'uyurieni, mana quenemie yaquetineutahüavi yühücüate xeti'utü 'ecü 'iya. Xüca masi'u'enieni, 'a'ivatütü pühücütüni xeyunaqui'erietü. ");
INSERT INTO hchNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Me xüca camasi'u'enieni, xeime quenanuvitüqui ya yuhutame, tehecüatamate vaniuquicü naitü niuqui müseirecü, yuhutame ya yuhaicame vaniuquicü. ");
INSERT INTO hchNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Müme xüca cavaru'enieni, yaquetinivarutahüavi memüyutixexeüriva. Xücate cavaru'enieni memüyutixexeüriva, que mü'ane tanuivarisie mücamiemepaü quetineuxeiya, tiyucuamanamepaü. ");
INSERT INTO hchNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Caniseüyeni que nemütixecühüave, tita xemücatetaunie 'ena cuiepa, mücü pücatitauniyarieni taheimata, tita xemütetaunie 'ena cuiepa, mücüta pütitauniyarieni taheimata. ");
INSERT INTO hchNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Tavari caniseüyeni que nemütixecühüave, yuhutatü xeme xeyu'enietü xüca yaxeicüa xeteyumaica 'ena cuiepa tita xemütetavauni hepaüsita, sepa que mütitita, ne'uquiyari taheima macave müpaü catinixepitüamücü. ");
INSERT INTO hchNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Haque yuhutatü yuhaicatü memeyuxeürie menesitahüaveque, mana nepuyeicani vasata. ");
INSERT INTO hchNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Hicü Pecuru 'aura 'ayaca müpaü tinitahüave, Ti'aitame, quepaümexa nepüreiyehüvirieni ne'iva, 'axa nesiyurieyu. 'Atahutamexa va'atü. ");
INSERT INTO hchNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Quesusi müpaü tinitahüave, Ne 'atahutamexa nepücahaine, masi haica teviyari heimana tamamata heimana 'atahutamexa püta. ");
INSERT INTO hchNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","'Ayumieme nepaine, 'ipaü catini'aneni ti'aitametücacu que mü'ane taheima macave. Tevi yucuiepa müti'aitametücai müpaü pütiuta'ai, te'uximayatametemama 'amemüte'apicacü tita müreuyevecai. ");
INSERT INTO hchNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Mericüsü müpaü tisutüacu vavavirietü, xevitü hesüana pü'atüarie, meuyevecai xei miriyari miriyari 'inüariyari 'amürapicacü tumini. ");
INSERT INTO hchNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Mücaheixeiyacaicü cümana mütiyutuanicü, mücü ti'aitame müpaü pütiuta'ai mütuiyacacü tevi, 'üyayata türiyamamata piniteyata, mücü tuminiyaricü 'amürapiniyarienicü. ");
INSERT INTO hchNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Hicü hetüana niutihüximaqueni ti'uximayatame müpaü 'utaitü, Quenenecuevieca cuerietü, nai nepürapica. ");
INSERT INTO hchNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Hicü mücü ti'uximayatame cusiyarieya 'inenimayatü nixüna, reiyehüviri tita müreuyevecai. ");
INSERT INTO hchNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Mericüsü ti'uximayatame heyaca neitaxeiya yuhepaü 'aneme ti'uximayatame. Peuyevecai 'iya xei sienituyari 'inüariyari xeicüa mi'üitüanicü. Cüipitüana 'iviyaca müpaü tinitahüave, Queneneu'üitüa tita müreuyevese pemürapinecü. ");
INSERT INTO hchNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Hetüana niutihüximaqueni hepaüna 'anetü ti'uximayatame, müpaü 'utaitü, Quenenecuevieca cueritü, nai nepürapica. ");
INSERT INTO hchNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Mücü pücayuvaüriyacai, masi tiniuta'aita casariyanata manutahüiyanicü mexi carapivecai tita müreuyevecai. ");
INSERT INTO hchNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Mericüsü hepaüna me'anenetü te'uximayatamete hipatü me'ixeiyaca que mütiuyuri, cuini mieme meniyutihiverieni. Mehecüneca, que mütiuyü nai metenitaxatüani yucusiyari. ");
INSERT INTO hchNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Hicü cusiyarieya 'itahüaveca müpaü tinitahüave, Cari 'axa pepütiuca'iyari. Camü ne nemareuyehüviri tita müreuyevecai pemürapinecü naimecü, yapemutayücü. ");
INSERT INTO hchNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Caricuta müpaü careuyevecai 'ecütari peminenimayacacü 'iya 'ahepaü müti'uximayatame, yaxeicüa que nemümatiunenimayataxü ne. ");
INSERT INTO hchNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Cusiyari ha'atü yemecü niyetuani teyu'uximatüvamete vahesüa mexi carapivecai tita müreuyevecai naime. ");
INSERT INTO hchNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yaxeicüata ne'uquiyari taheima macave püxeyurieni xüca yuxexuitü 'aixüa 'iyaricü xecatevareuyehüvirivani yu'ivama. ");
INSERT INTO hchNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Mericüsü Quesusi 'inüca 'icü niuqui, Carereya cuieyarisie niuyupata, Cureya cuieyarisie neyani Curutani hatuxameyari 'anutaüye. ");
INSERT INTO hchNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Teüteri yumüiretü meniveiyacaitüni. Mana nivaranayexürüvacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Mericüsü Pareseusixi hesüana meniu'axüani me'ita'inüataque müpaü me'utiyuatü, Titauniva yü'üya mücu'eirienicü naimecü. ");
INSERT INTO hchNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Mücü müpaü tinivaruta'eiya, Müpaü xecate'iterüvavave, mücü matüaripai müvarunetüa, 'uquitüme 'ucatüme müvarutivevi. ");
INSERT INTO hchNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Müpaü niutayüni, 'Ayumieme 'uqui niyupatamücü, yu'uquiyari yuvarusi vahesüa niyeyeimücü, yü'üyasie tiniviyamücü püta. Memüyuhutacai xei vaiyari mecanacünicuni meyuxevitü, cananuyüneni. ");
INSERT INTO hchNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","'Ayumieme mecaniyuxevini, mepücayuhutari, xei vaiyari mehümetütü. 'Ayumieme Cacaüyari müvarutaxeviriyaxücü, tevi pücavataxüriexüani. ");
INSERT INTO hchNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Peru müme müpaü metenitahüave, Mericüte, xüca müpaü 'aneni, titayari Muisexi müpaü tiu'aitaxü xapa 'eiriya hepaüsita mihuritüanicü micu'eirienicü. ");
INSERT INTO hchNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Mücü müpaü tinivarutahüave, Muisexi yu'iyarisie xemü'itutupecü canixe'utaunieni xemüvacu'eirienicü yü'üitama. Peru matüaripaitü müpaü cacani'anecaitüni. ");
INSERT INTO hchNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ne masi müpaü nepütixetahüave, que mü'ane micu'eirieni yü'üya, mitivitüni xeime, mücü canicumaüvamücü que mü'ane mücayü'üya xeime cünaya mühücücü, me xüca 'uca mü'üyayatücai 'icumayüaveni xeime mücayücüna meri xeicüa, picu'eirieni. Que mü'ane meta mitivitüni mücu'eiriva, mücüta nicumaüvamücü xeime 'üyaya. ");
INSERT INTO hchNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Hicü teyü'üquitüvamete müpaü metenicühüaveni, Cari xüca müpaü 'aneni 'uqui 'ucamatü que mütivaiyacü, 'aixüa cani'aneniqueyu masi xüca caneüquenique. ");
INSERT INTO hchNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Mücü müpaü tinivarutahüave, 'Icü niuqui yunaime vahesie pücamieme. Müme müpaü memütepitüarie, müme vahesie xeicüa canimiemetüni. ");
INSERT INTO hchNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Hipatü mepücaneüquivave müpaü me'anenetü memutinuivaxücü. Hipatüta mepücaneüquivave müpaü me'aneneme teüteri memüvarayeitüacü. Hipatüta yücümana mepücaneüquivave, yamütiyünicü que müti'ane ti'aitametücacu que mü'ane taheima macave. Que mü'anesie mümieme 'icü, hesiena quetinaqueni. ");
INSERT INTO hchNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Mericüsü 'ana türi meni'atüarieni hesüana, vahesie 'utimeme müyutanenevienicü, peru teyü'üquitüvamete menivarutate'acaitüni. ");
INSERT INTO hchNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Hicü Quesusi müpaü tinivarutahüave, Xequenivapitüaca türi, xepücavanenaca nehesüa memü'axenicü. Müya memü'anene catiniva'aitüvametüni que mü'ane taheima macave. ");
INSERT INTO hchNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Hicü vahesie 'utimeca neyani. ");
INSERT INTO hchNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Hicü 'uqui hecuatü hesüana ninuani müpaü ticühüavetü, Ti'aitame 'acu, tita reuyevese 'aixüa nemütiyurienicü, tucari mücaxüve nemexeiyanicü. ");
INSERT INTO hchNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Müpaü tinita'eiya, Titayari peneticu'ivaviya tita 'aixüa müti'ane hepaüsita. Que mü'ane 'aixüa mü'ane yuxevitü 'apuyeica Cacaüyaritütü. 'Ayumieme xüca peheutahamücü tucari maxuavesie, yaquetinecamieni que müti'aita. ");
INSERT INTO hchNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Rehüave, Que mü'ane 'aisica 'acu. Quesusi rehüave, Müpaü manuyüne, pepücati'amemivani pepüca'icumaüva xeime 'üyaya, pepücatinavayani, peti'itavatü pepücatihecüatani, ");
INSERT INTO hchNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","quetinivareuyehüvirieca 'a'uquiyari 'avarusi, quenenaqui'erieca 'ahepaü tevi que pemüti'anaqui'erie manuyüne. ");
INSERT INTO hchNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Hicü 'uqui müpaü tinitahüave, 'Icü naimesie yanepüticamie temaicüyaripai. Tita cuxi reuyevese. ");
INSERT INTO hchNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Quesusi müpaü tinitahüave, Xüca pe'avaüriyani pemaye'anicü, quenemie, quetineutua 'apini, quetinivarumicua memümamave. Müpaü petiyurieme vaüca pepeucaqueni taheima. 'Ana pe'ayame nehesie quetineuviya. ");
INSERT INTO hchNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Hicü 'uqui 'icü niuqui 'u'enieca neyani yuhiverietü, vaüca mürexeiyacaicü. ");
INSERT INTO hchNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Hicü Quesusi müpaü tinivarutahüave yuhesüa miemete teyü'üquitüvamete, Niuqui caniseüyeni que nemütixecühüave, canicuaniveni xicu maye'anicü müti'aitüvametünicü que mü'ane taheima macave. ");
INSERT INTO hchNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Tavari müpaü nepütixecühüave, que müticuanive xicu maye'anicü Cacaüyari müti'aitüvametünicü, masi pücacuanive cameyu manuyehanicü 'ivipame hüxieyasie. ");
INSERT INTO hchNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Me'u'enanaca teyü'üquitüvamete yeme meniuhüxiyani. Müpaü meniutiyuanecaitüni, Xüca müpaü 'aneni, quepai püyüve mütavicueisitüarienicü. ");
INSERT INTO hchNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Hicü Quesusi vaxeiyatü müpaü tinivarutahüave, Teüteri mepücayüvave, peru Cacaüyari naimecü caniyüveni. ");
INSERT INTO hchNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Hicü Pecuru müpaü tinitahüave, Camüsü tame tepeicü'eiri naime 'ahesie tepüteviya. Mericüte, tita tetehexeiyani tame. ");
INSERT INTO hchNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Quesusi müpaü tinivarutahüave, Niuqui caniseüyeni que nemütixecühüave, xeme nehesie xemüteviya, quepaucua cuie mühecuasie temü'axüani, Yuri Tevi nehücütütü quepaucua ne'uvenisie nemayerüni neti'aitatü visi ne'anetü, 'ana xemeta 'isücate xecanacünicuni. Tamamata heimana huta 'uveniyarisie xe'ayaxeme xecateniva'aitüacacuni teüteri tamamata heimana yuhutame nuivarite 'Ixaherisie memüyecü. ");
INSERT INTO hchNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Que mü'ane micu'eiri yuqui yu'ivama 'uquisi 'ucari, yu'uquiyari yuvarusi yunivema yucuie, xüca varucu'eirieni nehesüa mümiemecü, mücü cuini mieme masi varexeiyatü canayeimücü, tucari mücaxüve hexeiyatü payani. ");
INSERT INTO hchNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Yumüiretü hicü miemete memümexüacate 'imatüremete mecanacünicuni, 'imatüremete mexüacate mete'acüne. ");
INSERT INTO hchNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","'Ipaü catini'aneni ti'aitametücacu que mü'ane taheima macave. Tevi quiecame ximeri meri neyani vata'inienique te'ivamete haraveritana memüteta'ivacü caxie hepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Müpaü tivarutahüavecu xei tucarisie mieme que mütiyutuacai, meniuyuvaüriya, nivarenü'ani yuharaverita. ");
INSERT INTO hchNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Hicü 'anatinecu heyaca nivaruxeiya hipame quiecari hixüapa memüti'ucai mecate'ivatüvetü. ");
INSERT INTO hchNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Müpaü tinivarutahüave, Xemeta haraverita xequenehu. Que mütiheiserie nepütixepitüani. Hicü menecüne. ");
INSERT INTO hchNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Mericüsü tavari heyaca tuca tavarita cüa caviecacu yaxeicüa pütiuyuri. ");
INSERT INTO hchNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Hicü 'acayunirümecacu neyani. Hipameta nivarecaxeiya mana meti'ucame. Müpaü tinivarutahüave, Titayari 'uva xeteti'u tucaricü xecate'ivatüvetü. ");
INSERT INTO hchNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Müme müpaü metenitahüave, Tevi pücatasita'inieve temüteta'ivacü. Müpaü tinivarutahüave, Xemeta haraverita xequenehu. Que mütiheiserie, yaxepütepitüarieni. ");
INSERT INTO hchNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Mericüsü 'ucutaicairecu haraveri cusiyari müpaü tinitahüave yuparevivame, Te'ivamete quenivaretahüavi, quenivare'üitüani va'ivarica xique miemetexi meri, 'ariqueque ximeri miemetexi. ");
INSERT INTO hchNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Hicü müme 'acayunirümecacu memutahüavarie me'u'axüaca xei tucarisie mieme meniuta'üitüarieni yuxexuitü. ");
INSERT INTO hchNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Müme matüari memutahüavarie me'u'axüaca, müpaü mepütecu'erivacai vaücava masi memü'üitüarieniquecaicü, peru mümeta yaxeicüa xei tucarisie mieme meniuta'üitüarieni yuxexuitü. ");
INSERT INTO hchNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Me'itanaqui'erieca yu'ivarica, menitiniuquimani haravericame ");
INSERT INTO hchNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","müpaü me'utiyuatü, Camü 'ime 'imatüriecaque memu'axüa xei hurayari mepuyuri xeicüa caricuta yaxeicüa pepütivarupitüa tahepaü, sepa tame temüte'ucacucuinecai tucaricü, sepa temücuaxiyatücatei xüripa tame. ");
INSERT INTO hchNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Mücü 'ita'eiyaca xeime müme müpaü niutayüni, Nehamicu 'axa nepücamasi'uyuri. Pecatiu'avaüri que nemainecai xei tucarisie mieme que memütinetuacai. ");
INSERT INTO hchNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Quenanu'üi 'atumini, quenemie. Nepünevaüriya nemi'üitüanicü 'icü 'imatüreme que nemümatiu'üitüa 'ecü. ");
INSERT INTO hchNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Catitauniva müpaü nemütiyurienicü nepinicü que mütinaque. Nusu 'axa pepünetiuxei 'ecü 'aixüa nemütiuca'iyaricü. ");
INSERT INTO hchNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Müpaü yaxeicüa müme hicü memü'imatüremete, 'ana mexüacate mecanacünicuni, mexüacate 'imatüremete mete'acüne. Yumüiretü meputa'inierie, peru hipatü xeicüa mepanayexeiyarie. ");
INSERT INTO hchNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Mericüsü Quesusi Querusareme quepaucua mumiecai, yateva nivarevitüni Tamamata Heimana Yuhutame yühücüame. Mana huyeta müpaü tinivarutahüave, ");
INSERT INTO hchNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Neuxei, Querusareme tepeutiyune hicü. Yuri Tevi que nemütihücü necaniyetuiyamücü mara'acate memühüritüarie vahesüa, müme 'inüaricü memüte'üquita vahesüa. Va'isücate menesita'ivaviyayu necanimieriemücü. ");
INSERT INTO hchNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","'Ana meneniyetuacuni müme memücatateüterima vahesüa nemünanaimarienicü nemücuveiyaxüanicü curuxisie nemümierienicü. Hairieca tucari 'aye'ayu necananucuquetüariemücü. ");
INSERT INTO hchNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Mericüsü hicü Severeu nivemama vavarusi hesüana ninuani yunivema varavitütü. Niutihüximaqueni hetüana tixaütü titavarienique. ");
INSERT INTO hchNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Mücü müpaü tinitahüave, Tita pereuyehüva. Rehüave, Müpaü queneutayüqui, 'icü nenivema yuhutatü memayaxecü xevitü 'aserieta xevitü 'a'utata quepaucua peti'aitatü pemayani. ");
INSERT INTO hchNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Quesusi müpaü tinivarutahüave, 'Asixepücatemate tita xemütecu'ivava. Nehepaü xete'ucacucuinetü xeteyüvave xemenu'ienicü tita nemüranu'ieni ne, nehepaü xeteyüvave xema'ivarienicü, tevi que müranucanamiepaü hacü quepaucua muca'üyarie. Tepüyüvave mete'icühüave. ");
INSERT INTO hchNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Müpaü tinivarutahüave, Yemecü nehepaü xepüte'ucacucuineni xe'i'ietü tita nemüranu'ieni, xeca'üyarietü nemüca'üyarienipaü. Peru heiserie nepücahexeiya nemüxepitüanicü ni neserieta xeniu ni ne'utata xemutiyaxecü. Masi müme xeicüa ne'uquiyari micuha'aritüa vahesie mieme, yamecatenipitüariecacuni müme püta. ");
INSERT INTO hchNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Hicü hipatü tamamata me'u'enanaca menivarutixeümani yuhutame yu'ivamacame. ");
INSERT INTO hchNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Hicü Quesusi yu'aurie varutahüaveca müpaü niutayüni, Xeme müpaü xepütemate, müme nuivarite vasata memüte'aitamete, müme meteniva'uxitüaca mete'aitatü. Vavemete heiserie mecanexeiyani vahepaüsita que memüteyurieni. ");
INSERT INTO hchNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Müpaü pücatiyüni xeme xesata. Que mü'ane xeme xesata ve'eme mayaniqueyu, mücü yunaime xeparevivame canayeimücü. ");
INSERT INTO hchNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Que mü'ane mexüacame mayaniqueyu xesata, yunaime xehesie mieme ti'uximayatü canayeimücü. ");
INSERT INTO hchNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Yaxeicüa Yuri Tevi nehücütütü que nemütinua, nemüpareviyanicü nepücanua, masi hipame nevaparevienique püta necaninuani, netucari nemüyetuanicü yumüireme vahesie mieme, nevaxünaque. ");
INSERT INTO hchNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Mericüsü Quericusie me'ayecünirümecacu, yumüiretü teüteri meniveiyacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Yuhutatü me'acücüpetü mana menicatecaitüni huye tesita. Hicü me'u'enanaca quename 'anuyeyaniquecai Quesusi, meniutihivani müpaü me'utiyuatü, Ti'aitame 'acu Raviri pemünu'aya, quetanenenimayaca. ");
INSERT INTO hchNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Teüteri menivarutitieni cayuvatü memütetenicü. Müme masi vaüca meniutihivatücüne müpaü me'utiyuatü, Ti'aitame 'acu, quetanenenimayaca, Raviri pemünu'aya. ");
INSERT INTO hchNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Hicü Quesusi mana 'utaqueca nivarutahüave. Müpaü niutayüni, Que tixenaque müpaü nemütiyurienicü xehesie mieme. ");
INSERT INTO hchNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Müpaü metenitahüave, Ti'aitame 'acu, tepanutanenierequeyu. ");
INSERT INTO hchNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Hicü Quesusi vanenimayatü nivaramayüaxüani vahüxita. Yapaucua menanutaneniere, menenucuveiya mümeta. ");
INSERT INTO hchNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Mericüsü Querusaremesie meni'axüaximecaitüni. Vetüpaquesie nuaca Huriva Mati'u yemuriyaritüa, Quesusi nivarenü'ani teyü'üquitüvamete yuhutame ");
INSERT INTO hchNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","müpaü tivarutahüaveca, Quiecari 'anutaüye mucumasie xequenehu. Cuitü xecanivaretaxeiyacuni puxu macuvie nu'ayamame. Xevaracuxüname xequenivarahapani nehesüa. ");
INSERT INTO hchNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Xevitü xüca xeta'ivaviya, müpaü xepüte'itahüave, Ti'aitame püvareuyehüva. Cuitü püvaranü'ani. ");
INSERT INTO hchNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Müpaü tiniuyüni maye'anicü que mutayü Cacaüyari, tixaxatame müpaü 'utainecacu, ");
INSERT INTO hchNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Müpaü quetinetahüavi Siyuni müracuteva quiecame, Neuxei, que mü'ane mümati'aitüa 'ahesüa canamieni Ca'ayu'eriyatü, puxusie 'acaitü Puxu nunusisie 'anutiyerüme. ");
INSERT INTO hchNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Hicü teyü'üquitüvamete mehecüneca, müpaü mete'uyurieca que mütivaru'aitüa Quesusi, ");
INSERT INTO hchNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","puxu meneyehana, nu'ayari. Yü'ücari me'anutiveracu puxusie, nanutiyerüni. ");
INSERT INTO hchNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Yumüiretü teüteri huyeta meni'itüaximecaitüni yü'ücari, hipatü cüye mamateya meheucuvitequetü meni'itüaximecaitüni huyeta. ");
INSERT INTO hchNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Teüteri yumüiretü memuhaitütüacai memu'imamatücai meniutihivacaitüni müpaü me'utiyuatü, 'Aixüa cani'aneni Raviri Nu'aya, 'aixüa queticuniuvani que mü'ane mamie Ti'aitamesüa miemetütü hepaüsita, 'aixüa cani'aneni que mü'ane taheima macave. ");
INSERT INTO hchNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Hicü Querusareme heutahacu yunaitü quiecatari menanucu'uni müpaü me'utiyuatü, Quesü püpaicü 'icü. ");
INSERT INTO hchNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Teüteri müpaü meniutiyuanecaitüni, 'Icü catinixaxatametüni Quesusitütü, Nasareti quiecame Carereya cuieyarisie. ");
INSERT INTO hchNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Mericüsü Quesusi Cacaüyari tuquieya 'amüpata neutahani curaruta. Nivaranuyeveiya yunaime memütetuacai memütenanecai mana curarutapai. Tumini patamete vamexate natixürieni, cucuruxi vatuayamete va'üpari ratixüri. ");
INSERT INTO hchNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Müpaü tinivarutahüave, 'Ipaü catine'uca, Nequi nenevieri quiyari canimarivacamücü, 'anuyütü, xemesü masi terü xecanayeitüani haque tenavayamete memeyu'avieta. ");
INSERT INTO hchNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Hicü tuqui curaruyarita 'uvecacu, memacücüpecai memühurietücatei hesüana meniu'axüani, nivaranayexürieni. ");
INSERT INTO hchNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Hicü mara'acate memühüritüariecai mümeta 'inüaricü memüte'üquitacai, me'ixeiyaca marivemecü que mütiyurienecai, mevaxeiyatü türi meta tuqui curaruyarita memutihivacai, 'Aixüa cani'aneni Raviri Nu'aya me'utiyuatü, müme meniuyeha'ani. ");
INSERT INTO hchNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Müpaü metenitahüave, Cari pecati'ena que memutiyuane 'icü. Quesusi müpaü tinivarutahüave, Hü. Cauca hasuacu xeca'iterüvavave 'icü, Türi memüsiseve vatetasie Niuqui 'aixüa mü'ane Nepüvayenetüani nehepaüsita, maine. ");
INSERT INTO hchNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Hicü varucu'eirieca, quiecarisie nivayeyani Vetaniyapai. Muva necateitüni. ");
INSERT INTO hchNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Mericüsü ximeri tavari quiecarisie yemieximetü neuhacamücücaitüni. ");
INSERT INTO hchNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Xapa cüyeyari 'uxeiyaca huye tesita 'uveme, hepana neyani. Tixaü pücatiutaxei hesiena, xavari xeicüa. Müpaü tinitahüave xapa, Tavari pepücatacaca. Yapaucua niutavani xapa. ");
INSERT INTO hchNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Me'ixeiyaca teyü'üquitüvamete menihüxiyacaitüni müpaü me'utiyuatü, 'E'e, quetü, yapaucua putava xapa. ");
INSERT INTO hchNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Quesusi müpaü tivacühüave, Caniseüyeni que nemütixecühüave, xüca yuri xete'erieca, xüca xe'iyari cayuhutani, que mütiuyü xapa hepaüsita, müpaü xepüteyurieca xemeta. Mücü meta, sepa müpaü xemüte'itahüave yemuri mana muve, Queneu'apata, haramarasie queneu'ahüva, xe'utiyuatü, müpaü pütiyüni. ");
INSERT INTO hchNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Sepa que mütitita, nai xemütetavauni xeyunenevietü, xüca yuri xete'erieca, xeheixeiyatü xepacüne. ");
INSERT INTO hchNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Mericüsü tuquipa heta'acu mara'acate memühüritüariecai teüteri va'uquiyarima yunaitü 'aura menacüne ti'üquitacacu. Müpaü meniutiyuane, Heiserie haque pemieme pemeixeiya 'ipaü pemütiyurienecü. Quepai 'icü heiserie masi'upitüa. ");
INSERT INTO hchNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Quesusi müpaü tivaruta'ei, Neta tixaütü nepütixeta'ivaviya. Xüca xenesita'eiya, neta yanepütixetahüave haque memieme heiserie nemexeiya yanemütiyurienecü. ");
INSERT INTO hchNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Tamüsü Vani quepaucua müti'üyanecai, haque pemiemetücai 'üyaricaya. Taheima macave pipitüa, teüteri nusu mepipitüa. Mümeri niuqui menixüatüacaitüni müpaü meteyücühüavetü yunaitü, Xüca tame müpaü te'utiyuaneni quename taheima macave 'ipitüa, mücü müpaü pütaticühüaveni, Mericüte, titayari yuri xecate'ita'eriri. ");
INSERT INTO hchNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Mesü xüca müpaü te'utiyuaneni quename teüteri me'ipitüa xeicüa, camü tepüvamacaxe teüteri. Yunaitü Vani tixaxatametüme mepü'erie. ");
INSERT INTO hchNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Hicü Quesusi müpaü meteniuta'eiya, 'Asitepücatemate. Mücüta müpaü tinivarutahüave, Mericüte, neta 'asinepücatixetahüave haque memieme heiserie nemexeiya yanemütiyurienecü. ");
INSERT INTO hchNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Perusü que xetecu'eriva. Tevi yunivema nivarexeiyacaitüni yuhutame. Xeimesüa nuaca müpaü tinitahüave, Nenive 'acu, hicü quetine'uximayatamie haraverita. ");
INSERT INTO hchNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","'Iya rehüave, Nepücanevaüriya. 'Ariquesietü yücü tiyutihüaveca neyani. ");
INSERT INTO hchNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Mericüsü 'arique 'ivayasüa nuaca yaxeicüa tinitahüave. 'Iya, 'Au ne'uquiyari 'utayüca, pücahetüa. ");
INSERT INTO hchNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Mericüte, que mü'ane mücü 'icü yapüticatüa 'uquiyarieya que mütinaquecai. Müpaü mete'icühüave, Matüari mitahüavixüsietü. Hicü Quesusi müpaü tinivarutahüave, Niuqui caniseüyeni que nemütixecühüave, 'asita müme memüteyetuiriyari cuviyexunu tuminieya, 'ucari meta tuminicü memüyuvitünüa mecanixe'anuhaitüiyacuni memaye'axüanicü Cacaüyari mütiva'aitüvametünicü, xeme pücatixaü. ");
INSERT INTO hchNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Vani xehesüa ninuani huye xexeisitüanique, tixecuxaxatüvatü heiseriemecü yaxemütecahunicü. Yuri xepücate'uta'eri hesiena, peru 'asita müme memüteyetuiriyari cuviyexunu tuminieya, 'ucari meta tuminicü memüyuvitünüa müme yuri meteniuta'eriecaxüani hesiena. Xeme masi xete'uxeiyaca que mütiuyü, ni 'ariqueque xepücatehayevacai que xemüteyuriecai, yuri xepücate'uta'eri hesiena. ");
INSERT INTO hchNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Xeimeta 'üxasi xequene'enieca xemüteyü'üquitüacacü. Quiecame haraveri niutavevieni. Caxie 'uca'uitüaca nicurarutüiya, caxie püname nivati'inieni, 'e'utevime niutavevieni neniereme, capa caxie 'ucacuaiyanicü. Te'üviyamete nivaruhüritüani vacuetatüatü, teva retüa. ");
INSERT INTO hchNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Mericüsü ticuaximecacu, yuhesüa miemete te'uximayatamete nivarenü'ani te'üviyamete vahesüa memenutünicü 'icuaxi cusiyarisie mütinaquequecaicü. ");
INSERT INTO hchNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Te'üviyamete masi mevarutiviyaca te'uximayatamete hesüana memeyecü, xeime meniucuvaxüani, xeime mete'umi, xeime mete'utituaxixü. ");
INSERT INTO hchNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Hicü hipame tavari nivareyenü'axüani te'uximayatamete yumüireme masi. Yaxeicüa mepüvaruyuri. ");
INSERT INTO hchNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","'Imatürieca vahesüa neinü'ani yunive müpaü 'utaitü, Xüari meteneiyehüviriecuni nenive. ");
INSERT INTO hchNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Hicü te'üviyamete nu'aya me'uxeiyaca müpaü meniutiyuanecaitüni, Camüsü 'icüsie 'ariqueta catininaquimücü cusiyari pinieya. Cümü tepimieni, tepiviya tita hesiena mütinaque 'arique. ");
INSERT INTO hchNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Me'iviyaca haraveri vari meneicahüani mepimi. ");
INSERT INTO hchNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Mericüte, quepaucua munuani haraveri cusiyari, que vayurieni te'üviyamete müme. ");
INSERT INTO hchNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Müpaü metenitahüave, 'Axa 'anemecü nivatixütüamücü 'axa memüte'uyuricü müme, hipame püta nivahüritüamücü te'üviyamete, 'icuaxiyari memiyetuirieni cusiyari quepaucua tucari maye'ani. ");
INSERT INTO hchNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Hicü Quesusi müpaü tinivarutahüave, Hasuacu xecate'ititerüvavave 'utüarica xapayarisie que maine, Mücü tete memutixani'eri qui vevivamete Mücü 'isiquina titutuicame nayani. Ti'aitame müpaü catiniuyurieni. Canimariveni que temüte'ixeiya, manuyüne. ");
INSERT INTO hchNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","'Ayumieme müpaü nepütixecühüave, xepücapitüarieni xeme xemeixeiyanicü Cacaüyari tixe'aitüvametüme. Hipatü püta 'icuaxiyari memütixuavitüani yamecatenipitüariecacuni xei nuivariyari. ");
INSERT INTO hchNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Xüca 'iya tetesie 'ucaveni pütimure. Xüca hesiena 'ucaveni tete, pitapüna. ");
INSERT INTO hchNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Hicü mara'acate memühüritüariecai Pareseusixi vahamatü me'i'enieca 'üxasieya, müpaü metenimaicaitüni müvaxatacaicü müme. ");
INSERT INTO hchNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Metenicuvautüvecaitüni que memüte'iviyacü, peru 'asimepücate'uyuri mevamacatü teüteri. Müme müpaü mepütecu'erivacai quename tixaxatame hücütücai Quesusi. ");
INSERT INTO hchNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Mericüsü Quesusi tavari 'üxasi hepaüsita ticuxatatü tinivaruta'üquitüani müpaü 'utaitü, 'Ipaü catini'aneni ti'aitametücacu que mü'ane taheima macave. ");
INSERT INTO hchNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Tevi yucuiepa müti'aitametücai neüquiya 'ixüarariyari niutavevieni yunivesie mieme. ");
INSERT INTO hchNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Yuhesüa miemete te'uximayatamete nivareutanü'axüani memüvatahüavecü müme meripai memuta'inierie neüquiyacü. Müme memuta'inierie mepücayünecai memacünecü. ");
INSERT INTO hchNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Tavari tivareutanü'axüa te'uximayatamete hipame müpaü tivarutahüaveca, Memuta'inierie müpaü xequetenivaretahüavi, Neuxei, ne'icuai 'apürapine, turusixi mete'ucui'ivaxü, vacaisixi meta memüvaiyatüca xemütecuanicü, nai pütiha'arisie. Xequenacüni neüquiyapa. ");
INSERT INTO hchNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Memuta'inierie me'itave'erietü masi meneutayeixüani xevitü yuvaxata, xevitüta yutienitapai. ");
INSERT INTO hchNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Hipatüta mevarutiviyaca te'uximayatametemama, 'axa mepüvaruyuri mepüvarucui. ");
INSERT INTO hchNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Hicü ti'aitame niuyeha'ani. Varenü'acu cuyaxi yuhesüa miemete menivarutixütüani müme teyumemivamete, vaquiecari mete'utataiyaxü. ");
INSERT INTO hchNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","'Ana müpaü tinivarutahüave yuhesüa miemete te'uximayatamete, Neüquiya pücuha'arisieri peru memuta'inierie 'aixüa mepücate'u'iyaricai. ");
INSERT INTO hchNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","'Ayumieme xequeneutayeixüa huye manuyehanesiepai. Yunaime xemüvaretaxeiya xequenivareta'ini neüquiyapa. ");
INSERT INTO hchNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Mericüsü te'uximayatamete huyeta meheutayeixüaca menivarucuxeürieni yunaime memüvaretaxei 'axa teyuruvamete 'aixüa teyuruvamete yunaime. 'Ixüaramete mecanihüpünecaitüni haque neüquiya meveviya. ");
INSERT INTO hchNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Mericüsü ti'aitame mana heutahaca vaxeiyaque 'ixüaramete, tevi niuxeiya mana 'acaime neüquiyapa mieme 'ixuriqui müca'anacatücücai. ");
INSERT INTO hchNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Müpaü tinitahüave, Nehamicu 'acu, quepaütütü 'uva pepataha neüquiyapa mieme 'ixuriqui peca'anacatütü. Mücü cayuvatü tinicateitüni. ");
INSERT INTO hchNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Hicü ti'aitame müpaü tinivarutahüave yuparevivamete, Xequenanahüa 'ücateyasie mamateyasie, xequenanuyehüva tacua yüvipa. Mana pütasuacani püyutaqueveni. ");
INSERT INTO hchNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yumüiretüsü meputa'inierie, peru hipatü xeicüa mepanayexeiyarie. ");
INSERT INTO hchNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Mericüsü Pareseusixi menecüne. Mepuyu'eni que memüte'iviyacü niuquieyasie. ");
INSERT INTO hchNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Hicü yuhesüa miemete teyü'üquitüvamete menivarenü'ani hesüana, hipame meta Herurexisie memüteviyacai, müpaü memüte'itahüavecü, Neuxei ti'üquitame tame müpaü tepütemate 'ecü yuri pemutainecü, Cacaüyari huyeya hepaüsita pemüti'üquitacü que mütivaiyacü, pemüca'acuerivayuriecü sepa xevitü que mütiyücühüave, yücü pemücativaxeiyacü teüteri. ");
INSERT INTO hchNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Hicümüsüari, yaquetatineutahüavi que pemüticu'eriva. Ti'aitame Sesaxi tumini que mütivava cuviyexunusie mieme, titauniva mütiyutuanicü, pücatauniva nusu. ");
INSERT INTO hchNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Quesusi timaitü 'axa que memiyuriecucai müpaü niutayüni, Cari yacü xeicüa xepüyüa. Titayaricutaxi xenete'inüatatüve. ");
INSERT INTO hchNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Tumini para xequeneneuxeisitüa xeime cümana mütiuyutua. Müme xei tuminiyari meni'üitüani. ");
INSERT INTO hchNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Hicü müpaü tinivarutahüave, Quepai ramu'u püra'uxa, quepai püra'utüarica 'icü. ");
INSERT INTO hchNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Mete'icühüave, Sesaxi. Hicü müpaü tinivarutahüave, Mericüte, tita Sesaxisüa mütimieme xequetenapinirieca Sesaxi, tita Cacaüyarisüa mütimieme, xequetenapinirieca Cacaüyari. ");
INSERT INTO hchNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Me'i'enieca meniuhüxiyani. Hicü me'icu'eirieca menecüne. ");
INSERT INTO hchNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Mericüsü mücü tucarisie Saruseusixi hesüana meniu'axüani. Müme müpaü pütivaniuquitücai quename meca'anutaneniere müquite. Hicü müpaü metenita'ivaviya, ");
INSERT INTO hchNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Ti'üquitame, Muisexi müpaü niutayüni, tevi xüca 'umüni türi cavarexeiyatü, 'ivaya nitivitümücü yucue, türi nivativevimücü 'ivaya mumüpaü memütetetevacacü. ");
INSERT INTO hchNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Mericüsü tahesüa 'amenititecaitüni yu'ivamatü 'atahutatü. Vamasi 'utineüqueca niumüni. Türi mücavarexeiyacaicü, yü'üya caniucu'eirieni mutaya mitivitünicü. ");
INSERT INTO hchNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Mutaya yaxeicüa tiniuyurieni, 'itivitüca niumüni, 'utümana mieme meta, 'atahutatü yunaitü. ");
INSERT INTO hchNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","'Imatüriecaque niumüni 'uca. ");
INSERT INTO hchNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Mericüte quepaucua xeniu memanucu'uni, 'atahutatü memitivitü, que mü'ane ra'üya pürayani. ");
INSERT INTO hchNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Quesusi müpaü tinivaruta'eiya, Xepuyuyari xemüca'imatecü 'utüarica xapayari que maine, 'asixemücatematecü Cacaüyari que mütitürücaüye. ");
INSERT INTO hchNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Quepaucua memanucu'uni mepücaneneüqueni mepücaviquieca, masi Cacaüyari niuquieya tuayamete vahepaü mepü'aneneni taheima. ");
INSERT INTO hchNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Müquite que memüte'anucu'uni que müre'uxa cauca hasuacu xeca'iterüvavave tita mütixe'utahüavixü Cacaüyari müpaü 'utaitü, ");
INSERT INTO hchNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Ne 'Apurahami 'Isahaqui Cacuvu necanivacacaüyaritüni, manuyüne. 'Ayumieme müquite pücavaxata, quename vacacaüyari haitü. Memayeyuyuri püta vacacaüyari caniyuxatani, sepa memucui. ");
INSERT INTO hchNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Me'u'enanaca teüteri, menihüxiyacaitüni 'üquisicayacü. ");
INSERT INTO hchNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Mericüsü Pareseusixi me'u'enanaca que mütivarunütüa Saruseusixi meniuyucuxeürieni 'axeicüa. ");
INSERT INTO hchNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Hicü xevitü müme 'inüari niuquiyari mümaicai nita'inüata müpaü ticu'ivaviyatü, ");
INSERT INTO hchNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Ti'üquitame 'acu, que mü'ane 'aitüarica masi peuyevese 'inüari niuquiyarisie mieme. ");
INSERT INTO hchNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","'Iya rehüave, Quenenaqui'erieca Ti'aitame mü'acacaüyari, nai que pemütiuca'iyari, nai que pemüti'amate, nai que pemüticu'eriva, manuyüne. ");
INSERT INTO hchNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","'Icü 'aitüarica masi yemecü caneuyeveca, cananuhaitüaca. ");
INSERT INTO hchNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","'Utümana mieme hepaüna cananuyüneni, 'Ahepaü tevi quenenaqui'erieca que pemüti'anaqui'erie, 'anuyütü. ");
INSERT INTO hchNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","'Icü niuqui hutatü canenucutuica 'inüari niuquiyari texaxatamete vaniuqui naime. ");
INSERT INTO hchNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Mericüsü Pareseusixi memuyucuxeürie Quesusi nivaruta'ivaviya ");
INSERT INTO hchNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","müpaü 'utaitü, Que xetecu'eriva Cürisitu hepaüsita. Que mü'ane püraxiüyari. Müpaü mete'itahüavixü, Raviri canixiüyarieyatüni. ");
INSERT INTO hchNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Müpaü tinivarutahüave, Mericüte, Cacaüyari 'Iyarieya 'icuyuitüvacacu, titayari Raviritütü Neti'aitüvame titaterüvaxü müpaü 'utaitü, ");
INSERT INTO hchNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Ti'aitame müpaü tinitahüave que mü'ane müneti'aitüa, Neserieta quenacani 'Ahetüapai mexi nevarahapani müme memümasi'aca'unie. ");
INSERT INTO hchNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Mericüte, xüca Cürisitu tita'aitüani Raviri, que timasiücü quename xiüyarieya. ");
INSERT INTO hchNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Xevitü pücayüvecai mita'eiyacü. Tavari ni xevitü pücayuvaüriyacai tixaütü mütita'ivaviyacü 'arique. ");
INSERT INTO hchNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Mericüsü Quesusi tinivacuxaxatüvacaitüni teüteri yuhesüa miemete teyü'üquitüvameteta ");
INSERT INTO hchNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","müpaü 'utaitü, Müme 'inüaricü memüte'üquita Pareseusixita Muisexi 'uvenieyasie me'atetü mepüte'üquita. ");
INSERT INTO hchNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","'Ayumieme nai que memütexecühüave yaxequeteneyurieca yaxequetenecahuni, peru que memüteyurie yaxepücateyurieca xeme. Mepütecuxata peru yamepücateyurie. ");
INSERT INTO hchNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","'Ica meniucuha'aritüani mahetete mücuanivetüca, teüteri vanaiparisie menivarutitütüvani, peru mepücayuvaüriya ni yu'itüvamecü memüvaparevienicü. ");
INSERT INTO hchNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Nai que memüteyurie, yamepüteyurie teüteri memüvaxeiyacü xeicüa. 'Epatayeyeu cuitaxiyari cümana niuqui xapayari manahüa quepaucua yuyeiyari memüvevie, 'apünene va'ücari putuniyari. ");
INSERT INTO hchNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Püvanaque quiecame 'aurie memayaxecü 'ixüararipa, teüteri vahüxie memayaxecü tuquita, ");
INSERT INTO hchNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","püvanaque vaürisica memüpitüarienicü quiecari hixüapa, teüteri Ti'üquitame me'utiyuatü memüvatahüavecü püvanaque. ");
INSERT INTO hchNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Xemesü Ti'üquitame xepücate'uterüvarüvani. Xevitiüxa catinixe'üquitüaca, xeme yunaitü xecaniyu'ivamaca. ");
INSERT INTO hchNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ne'uquiyari xepücatecühüavarüvani cuiepa, xevitiüxa müxe'uquiyaricü taheima macave. ");
INSERT INTO hchNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Te'üquitamete xepücate'uterüvarüvani, xevitiüxa tixe'üquitüvame mühücücü Cürisitutütü. ");
INSERT INTO hchNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Que mü'ane xeme masi mümariva, peuyevese mücü xeparevivame mayanicü. ");
INSERT INTO hchNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Que mü'ane tixaütü tihücütütü mayuyeitüva, mücü tixaü catihücütütü canayeitüariemücü masi. Que mü'ane tixaü catihücütütü mayuyeitüva, mücü masi tixautü tihücütütü canayeitüariemücü. ");
INSERT INTO hchNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Xüa 'ui xeme 'inüaricü xemüte'üquita, xemeta Pareseusixi, que xe'itüarieni yacü xeicüa xemüyüacü. Xepücavataunie teüteri memaye'axüanicü mütiva'aitüvametünicü que mü'ane taheima macave. Xeme xepücayuvaüriya müpaü xemüte'aye'axüanicü, müme meta memüyuvaüriya, xepüvanena. ");
INSERT INTO hchNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Xüa 'ui xeme 'inüaricü xemüte'üquita, xemeta Pareseusixi, que xe'itüarieni yacü xeicüa xemüyüacü. Xepütevarutixütüiri viyurasixi vapini, 'exeteheutevitü neneviericü, mücamasiücünicü que xemüteyurie. Xehesie masi yemecü tinahüivamücü. ");
INSERT INTO hchNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Xüa 'ui xeme 'inüaricü xemüte'üquita, xemeta Pareseusixi, que xe'itüarieni yacü xeicüa xemüyüacü. Naisarie haramarasie cuiepa xepücu'uva, xe'ivautüvetü xeime xenücame xemayeitüanicü. Quepaucua xemeitaxeiya, xecanipata, masi yemecü hesiena mütinaquenicü xasi taiyariyarisie meucahüiyanicü, xehesie 'axa mü'ane que mütinaque xeicüa pücatixaü. ");
INSERT INTO hchNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Xüa 'ui xeme xe'acücüpetü xemüvarahapana hipame, müpaü xe'utiyuatü, Que mü'ane tuqui 'amüpa xatatü müyühüritüa, yacü püyühüritüa. Me xüca yühüritüatü huru tepüayari xatani cümana müquemaritüarie tuqui, peuyevese yamüticamienicü que mutayü. ");
INSERT INTO hchNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Cari 'asixepücatemate, xepacücüpe. Que mü'ane masi yemecü peuyevese, huru nusu, tuqui nusu peuyevese tuqui huru müpatacü Cacaüyarisüa mieme mayanicü. ");
INSERT INTO hchNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Mücü meta, que mü'ane xeniu mürayutimavatüre xatatü müyühüritüa, yacü püyühüritüa. Me xeniu xüca mavari heimana mürapine xatatü yühüritüani, peuyevese yamüticamienicü que mutayü. ");
INSERT INTO hchNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Xepacücüpe. Que mü'ane masi yemecü peuyevese, mavari nusu, mürayutimavatüre nusu peuyevese, mücü mipatacü mavari Cacaüyarisüa mieme mayanicü. ");
INSERT INTO hchNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Que mü'ane mürayutimavatürecü xatatü müyühüritüa, mücü xatatü püyühüritüa, nai heimana mürapine xatatü püyühüritüata. ");
INSERT INTO hchNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Que mü'ane müyühüritüa tuqui 'amüpa xatatü, mücü xatatü püyühüritüa, que mü'ane tuquita mayeca xatatü püyühüritüata. ");
INSERT INTO hchNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Que mü'ane muyuavi xatatü müyühüritüa Cacaüyari 'uvenieya xatatü püyühüritüa, que mü'ane hesiena macave xatatü püyühüritüata. ");
INSERT INTO hchNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Xüa 'ui xeme 'inüaricü xemüte'üquita, xemeta Pareseusixi, que xe'itüarieni yacü xeicüa xemüayüacü. Tamamata taparisie mieme, xei tapari xepüyuvaüriya xemixatüanicü Cacaüyari, 'asita yerüvavuena texuxuri cuminu naime. Peru xepihayeva tita masi müreuyevese 'inüari niuquiyarisie mieme, heiseriemecü yaxemüteyuriecacü, xemüteyucanenimayacacü, yaxemütecahunicü que xemutiyuane. Müpaü püta püreuyevese müpaü mütiyurienenicü, siepüre catihayevatü xei tapari 'ixatüatü. ");
INSERT INTO hchNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Xe'acücüpetü xepüvarahapana hipame. Cari yu'isarisie xepenuyecase xecüi xemücahexünicü, peru xepexü cameyu 'amünena. ");
INSERT INTO hchNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Xüa 'ui xeme 'inüaricü xemüte'üquita, xemeta Pareseusixi, que xe'itüarieni yacü xeicüa xemüyüacü. Que mü'ane herie xeicüa müca'itiva tecüxi xacü, müpaü xepüyüa, peru yutaüta xepühüpüne xetenavacutü xeyutatuatü. ");
INSERT INTO hchNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Cari Pareseu pehücütütü pepacüpe. Taütana meri quenivacu'itiexüa tecüxi, herieta 'itiyatü mayanicütari. ");
INSERT INTO hchNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Xüa 'ui xeme 'inüaricü xemüte'üquita, xemeta Pareseusixi, que xe'itüarieni yacü xeicüa xemüyüacü. Müqui teucume meunaximapaü xecani'aneneni. Herie visi pütiyuxexeiya, peru pühüne müquite va'umeyari naitü müca'itiyatüca. ");
INSERT INTO hchNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Xemeta yaxeicüa herie xeicüa müme heiseriemecü yamemütecahu vahepaü xepüteyuxexeiya, teüteri que memütexexeiya, peru xepühüpüne yacü xeicüa xeyüatü, yaxecatecacünicutü. ");
INSERT INTO hchNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Xüa 'ui xeme 'inüaricü xemüte'üquita, xemeta Pareseusixi, que xe'itüarieni yacü xeicüa xemüyüacü. Texaxatamete vateucumete xepüvaveviri, müme heiseriemecü yamemütecahucai vateucumete visi xepüte'uquemaritüa. ");
INSERT INTO hchNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Müpaü xeputiyuane, Tame xüari xüca 'ate'u'uvanique quepaucua ta'uquiyarima 'amemu'uvacai, tamesüari tepücavapareviecaqueyu mütayeurienicü texaxatamete vaxuriya. ");
INSERT INTO hchNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Xemesietü xepüyuhecüata, müme texaxatamete memüvarucui que xemütevanivema. ");
INSERT INTO hchNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Xe'uquiyarima que memüte'isutüa mecuxi xequenaye'atüaca vahepaü. ");
INSERT INTO hchNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Cari cuterixi xepühüme, terücaxi xepüva'ivama. Quepaütücacu xepüyutavicueisitüani xemücaheucaxüriyanicü xasi taiyariyarisie, 'isücame xeta'ivaviyayu. ");
INSERT INTO hchNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","'Ayumieme xehesüa nepüvarenü'avani texaxatamete, temaivavemete, 'inüaricü te'üquitamete. Hipame müme xepüvacuini, curuxisie xepüvacavütüani, hipame müme xepüvativayani yutuquita, quiecarisie xepüvaranuyeveveiyani xeime quiecarisie. ");
INSERT INTO hchNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","'Ayumieme xehesie pürahüiyani yunaime heiseriemecü yamemütecahu vaxuriyacü cuiepa mütayeurivecü, Haveri heiseriemecü yamüticamiecai xuriyayacü meri, 'asita Sacariya Verequiyaxi nu'aya xuriyayacüque, xemimi tuquita caheta'avecacu, mürayutimavatüre heyeyacu. ");
INSERT INTO hchNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Niuqui caniseüyeni que nemütixecühüave, 'icü naitü pürahüiyani hicü miemete teüteri vahesie. ");
INSERT INTO hchNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Querusareme 'acu, Querusareme, 'ahesüa quiecatari mecanivatacucuyani texaxatamete, mecanivatituaxani Cacaüyari nü'arimama 'ahesüa memü'axe. Müixa nepünevaüriyacai nemüvacuxeürienicü 'atüriyama, vacana yunivema que mütivacuxexeüriva yu'anatüa. Mepücayuvaüri. ");
INSERT INTO hchNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Camüsü xequi 'uyemavetü pücu'eiriva. ");
INSERT INTO hchNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Müpaü nepütixetahüave, tavari xepücanesixeiya mexi tucari ca'aye'ave quepaucua müpaü xemutiyuaneni, 'Aixüa queticuniuvani que mü'ane Ti'aitamesüa miemetütü mamie hepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Mericüsü Quesusi tuqui 'amüpata vayeyaca neyani. Hesüana miemete teyü'üquitüvamete 'aura menacüne me'ixeisitüanique quite tuqui curaruyarita miemete. ");
INSERT INTO hchNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Mücü müpaü tinivacühüaveni, Xete'ixeiya 'icü naime. Niuqui caniseüyeni que nemütixecühüave, tete pücahayevarieni yuheima 'atetü. Naitü masi nica'unariemücü. ");
INSERT INTO hchNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Hicü mana 'ayerücu Huriva Mati'u yemuriyarisie teyü'üquitüvamete 'auriena menacüne yühücüate mecutecacu. Müpaü metenitahüave, Quetatineutaxatüa quepaucua müpaü pütiyüni que pemainecai. Tita ti'inüariyaritüni quepaucua pemunuani, quepaucua mütaparirümeni. ");
INSERT INTO hchNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Hicü Quesusi müpaü tivacühüave, Xequeneyucuerivayurieca capa xevitü tixe'u'irüviyacü. ");
INSERT INTO hchNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Yumüiretü mepü'axüani müpaü me'utiyuatü quename nehesüa memiemete, Neri Cürisitu nepühücü, me'utiyuatü. Mepüteva'irüviya yumüireme. ");
INSERT INTO hchNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Xepüva'enieni cuyaxi meyucuitüveme, cuya niuqui xepü'enieni. Yumarima xepücaxamurieca. Peuyevese müpaü mütiyünicü, peru 'acuxi naitü pücatapare mücücü. ");
INSERT INTO hchNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Nuivarite mecaniyeha'acuni mevacuicutü hipame nuivarite. Xexuime cuieyarisie quiecatari mepüyeha'ani, hipame cuieyarisie miemete mevacuicutü. Naisarie vaüca cuiniya canitixuaverimücü, haca canitavemücü cuie canitayuamücü. ");
INSERT INTO hchNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","'Icü naitü müpaü tiyüyu, mücücü cuiniya püsutüarieni xeicüa. ");
INSERT INTO hchNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","'Anari mecanixeyetuacuni xemü'uximatüariecacü. Mepüxecuinisü, yunaitü nuivarite mepüxe'uxive'erieca nehesüa xemümiemetecü. ");
INSERT INTO hchNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","'Ana yumüiretü mepücunuitüarieni, mepüyuyetuani mepüyuye'uxive'erieni. ");
INSERT INTO hchNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Yumüiretü texaxatamete mepanucu'uni mete'itavatü. Mepüteva'irüviya yumüireme. ");
INSERT INTO hchNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Cuini mieme memücayuvaüriyacü yamemütecahunicü, 'ayumieme yumüiretü mepütivaüripiximeni que memüteyucanaqui'erie. ");
INSERT INTO hchNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Que mü'ane tiuca'enivatü 'amuyeicani tapareyuque, mücü canitavicueisitüariemücü. ");
INSERT INTO hchNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","'Icü niuqui'aixüa manuyüne que müti'ane 'Iya ti'aitametücacü manuyüne, mücü catinicuxaxasivamücü naisarie memeutitei teüteri, memühecüasitüiyarienicü yunaitü nuivarite. 'Anaque nitaparimücü. ");
INSERT INTO hchNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","'Uxa'atüni xepixeiya mücü tevi müvaseviximani müracumaveriyani mana 'utiveme haque mevayepasie Cacaüyarisie mieme, Cacaüyari que mutayü Tanieri tixaxatame ya'utainecacu, titerüvame quetimaive tita mütixata. ");
INSERT INTO hchNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","'Anari müme Cureya cuieyarisie meme'uvani hürisiepai meque'uyuta'unaxüani. ");
INSERT INTO hchNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Que mü'ane caretasie müyeca 'uxipietü, yapaucua que'anacayani. Ni yuquita pücaheutahani yupini tivayepinique, püyuta'una püta. ");
INSERT INTO hchNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Que mü'ane yeuta meyeicani yu'utüma pücanuani yü'ücari tivayehurienique. ");
INSERT INTO hchNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Xüa 'ui müme memuhuca, müme memütesisitüani mücü tucari 'aye'ayu. ");
INSERT INTO hchNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Xequeneyunenevieca muhaütüsie müca'aye'anicü xemüyuta'unaxüanicü, mesü 'uxipiya tucarisie ca'aye'anicü. ");
INSERT INTO hchNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","'Ana cuini mieme 'uximatüarica canitixuaverimücü yamemücate'uximatüarievavepaü cuie munetüariepai hicüque, tavari que mücatitixuavere 'ariqueta. ");
INSERT INTO hchNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Mücü 'uximatüarica xüca 'esicareuteritüarienique, ni xevitü haquevasü pücatavicueniqueyu. Peru memanuyexeiyarie vacü, 'uximatüarica 'esipüreuteritüarieni. ");
INSERT INTO hchNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","'Anari xüca xevitü müpaü tixecühüaveni, Camü 'ena caniuyeicani Cürisitu, Camü mana, xüca haineni nusu, yuri xepücate'erieca. ");
INSERT INTO hchNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Mete'itavatü mepü'axüani Cürisitusixi meyuxatatü texaxatamete meyuxatatü. 'Inüari mepütivevieni mamarivaveme meteva'irüviyaque 'asita müme memanuyexeiyarie xüca meyüvavenique. ");
INSERT INTO hchNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Tamüsü müpaü catiyüvecacu cuxi, müpaü nepütixe'utahüavixü. ");
INSERT INTO hchNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","'Ayumieme xüca müpaü metexecühüaveni, Neuxei, macumavesie neyeicani, mana xepücaheuyeneicani. Xüca müpaü metexecühüaveni, Neuxei, quita peti'aviesie, yuri xepücate'erieca. ");
INSERT INTO hchNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Merücariya naisarie que mütimasiücü muyuavisie tahixüata 'umerücatü tasutüapai, müpaüta naisarie catinimasiücücamücü quepaucua munuani Yuri Tevi. ");
INSERT INTO hchNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Canimasiücüni caxari sepa haque meca, mana meniyucuxeüriecuni virücüxi. ");
INSERT INTO hchNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","'Ana cuitü 'uximatüarica heunuayu, tau niyürimücü, meseri pücahecüarivieni, xuravesixi mepücaxürieni muyuavisie miemete, müme türücariya memexeiya muyuavisie mepücuyuitüarieni. ");
INSERT INTO hchNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","'Ana masiücütü canayeimücü Yuri Tevi 'inüarieya taheima. 'Ana yunaitü nuivarite cuiepa memütama meniyutihiveriecuni, mecanixeiyacuni Yuri Tevi muyuavisie mieme haisata 'acamiecame, türücaüyetü cui xavatütü. ");
INSERT INTO hchNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Cuxineta hüsiyacacu püvatanü'axüani yutupirisixima, müme mepüvacuxeürieni müme müvaranuyexei, taserieta ta'utata tahixüata tasutüapai memu'uva, naisarie cuie manuniere muyuavitüa. ");
INSERT INTO hchNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Pinicü xequeteneyü'üquitüaca. Quepaucua xavari mücavivieni xüca yürani, xüca mamateya cuneicani, müpaü xepütemaica tasüari 'auracacutüca. ");
INSERT INTO hchNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Xemeta yaxeicüa quepaucua xemixeiya 'ipaü tiyüanecacu naitü, müpaü xequetenemaica quename hehura quitenie müta'aximenipaü. ");
INSERT INTO hchNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Niuqui caniseüyeni que nemütixecühüave, Hicü miemete mepücacuini mexi ca'aye'ave 'icü naitü. ");
INSERT INTO hchNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Muyuavi cuie pütixüni, peru neniuqui pücaxüni. ");
INSERT INTO hchNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Tevi 'asipücatimate quepaucua maye'ani mücü tucari. Taheima miemete tupirisixita 'asimepücatemate, Cacaüyari Nu'aya 'asipücatimate, 'uquiyarieya xeicüa pütimate. ");
INSERT INTO hchNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Que mütiuyü Nuhexi 'amuyeicacaisie, müpaüta catiniyümücü quepaucua Yuri Tevi munuani. ");
INSERT INTO hchNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","'Anapai memücatihauvecai cuxi, mepütecuatüvecai mepü'ietüvecai mepüneneüquecai mepüvatavitütüvacai. 'Ariqueque tucari naye'ani quepaucua Nuhexi meutaha canuvasie. ");
INSERT INTO hchNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","'Asimepücatemaicai, 'ariqueque xeicüa quepaucua ha mütitüa müvarehausitüa yunaime. Yaxeicüa catiniyümücü quepaucua Yuri Tevi munuani. ");
INSERT INTO hchNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","'Anari yuhutatü xüca me'u'uvani vaxata, xevitü panutivitüquieni xevitü pücu'eiriva. ");
INSERT INTO hchNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Yuhutatü xüca metüxüni yu'aurie, xevitü ranutivitüquieni xevitü ticu'eiriva. ");
INSERT INTO hchNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","'Ayumieme xequenayeneniereni 'asixemücatematecü que mü'ane tucarisie munuani xecusiyari. ");
INSERT INTO hchNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","'Ipaüsiere xequetenemaica, quiecame xüca müpaü timaicaque que mü'ane hurayarisie munuaniquecai tinavayame, payeniereniqueyu püca'ipitüaniqueyu meutahanicü quitana. ");
INSERT INTO hchNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","'Ayumieme xemeta xequeneha'arisieca. Quepaucua canuaximeme xemü'erieca, 'ana caninuamücü Yuri Tevi. ");
INSERT INTO hchNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Qui cusiyari que mü'ane pühüritüani yuquita miemete te'uximayatamete vacü, mütivaminicü quepaucua memeiyehüva. Que mü'ane yamüticamie, que mü'ane müyumate, mücü canihüritüariemücü. ");
INSERT INTO hchNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","'Aixüa pü'itüarieni 'iya ti'uximayatame xüca cusiyarieya nuame 'itaxeiya müpaü tiyurieneme. ");
INSERT INTO hchNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Niuqui caniseüyeni que nemütixecühüave, pütihüritüani yupini hepaüsita naime. ");
INSERT INTO hchNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Me xüca 'iya ti'uximayatame 'axa tiuca'iyaritü müpaü tiyücühüaveni yu'iyarisie, Necusiyari 'epüreutevi canuavetü, ");
INSERT INTO hchNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","xüca varutivatüyani yuhepaü te'uximayatamete, xüca ticucuaneni xüca cu'ieneni tarüvecarixi vahamatü, ");
INSERT INTO hchNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","mücü ti'uximayatame cusiyarieya caninuamücü quepaucua müca'icuevie yapaucua quepaucua 'asimücatimate ti'uximayatame. ");
INSERT INTO hchNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Hixüata piviteni mücü, müme yacü xeicüa memüyüa vahepaü pütipitüani. Manari putasuacani püyutaqueveni. ");
INSERT INTO hchNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Mericüsü 'ana 'ipaü catini'anemücü ti'aitametücacu que mü'ane taheima macave. Neüquiyapa, neneüqueme mücueviyasie 'üimarixi tamamata yücüxeme me'a'ütü menecüne me'inaqueque. ");
INSERT INTO hchNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Yu'auxüvitü müme 'asimepücatemaicai, yu'auxüvitü mepütemaivavecai. ");
INSERT INTO hchNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Müme 'asimemücatemaicai yücüxeme me'a'ütü haseitiyari mepücaheyeha. ");
INSERT INTO hchNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Memütemaivavecai haseiti mepahapacai puteyasie yemaneme yücüxeme me'a'ütü. ");
INSERT INTO hchNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Yunaitü mepeucusicucai neneüqueme 'ereutevicacu, meneucusu. ");
INSERT INTO hchNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Tücari hixüapa xevitü niutahiva, Neuxei neneüqueme mana pamie, xequenenaquiyu, 'utaitü. ");
INSERT INTO hchNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Hicü 'üimarixi yunaitü menenucu'uni, menicuha'aritüani yücüxeme. ");
INSERT INTO hchNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Müme 'asimemücatemaicai müpaü metenivarutahüave memütemaivavecai, 'Esiva xequetaneumicua yuhaseiti, tame tacüxeme mütüxüaximecü. ");
INSERT INTO hchNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Memütemaivavecai müpaü metenivaruta'eiya, Tietüsü catinaquimücü tahesie mieme xehesie miemeta. Mecuxi xequenehu tetuayamete vahesüa, xequenenanai yuhesie mieme. ");
INSERT INTO hchNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Hicü mexi meheinanetüvecai neneüqueme caninuani. Müme memucuha'arisie 'utümana meneutahaxüani 'ixüararipa. Quitenie neucunare. ");
INSERT INTO hchNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","'Arique mücaque memeicunanai mecaniu'axüani 'üimarixi müpaü me'utiyuatü, Ti'aitame 'acu, Ti'aitame, quetatineuyepiri. ");
INSERT INTO hchNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Mücü müpaü tivacühüave, Yuricü nepücaxemate. ");
INSERT INTO hchNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","'Ayumieme nepaine, xemeta xequenayeneniereni 'asixemücatematecü que mü'ane tucarisie que mü'ane hurayarisie munuani. ");
INSERT INTO hchNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Mücü meta, 'ipaü catini'anemücü, tevi teva müyemiecai que mütiuyuri. Yu'aurie nivarutahüave yuhesüa miemete te'uximayatamete. Yupini tinivayetuirieni. ");
INSERT INTO hchNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Xeime niu'üitüani 'auxüme quirivayari tumini, xeimeta huta quirivayari tiu'üitüa, xeimeta xei quirivayari tumini. Que memüteyüvavecai yuxexuitü, yapaümeme mepu'üitüarie. Hicü neyani. ");
INSERT INTO hchNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Que mü'ane 'auxüme quirivayari mu'üitüarie tumini, cuitü neyani, mücücü tinituacaitüni. Tavari 'auxüme quirivayari pana'ivaxü tumini. ");
INSERT INTO hchNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Yaxeicüa 'iya hutame mu'üitüarie tavari hutame rana'ivaxü. ");
INSERT INTO hchNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Peru 'iya xei quirivayari mu'üitüarie mana vayeyaca cuieta nivati'inieni titi'avietaxü yucusiyari tuminieya. ");
INSERT INTO hchNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Mericüsü te'uximayatamete vacusiyari 'epüreuterixü, 'ariqueque caninuani. Cuenita nivaruvevirieni. ");
INSERT INTO hchNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Que mü'ane 'auxüme quirivayari mu'üitüarie nuaca, ni'atüirieni tamamata quirivayari müpaü 'utaitü, Cusiyari 'ecü tumini 'auxüme quirivayari pepünesi'uyetuiri. Neuxei, mücücü tavari 'auxüme quirivayari nepana'ivaxü. ");
INSERT INTO hchNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Cusiyarieya müpaü tinitahüave, 'Aixüa puyü, ti'uximayatame pecanihücütüni 'aixüa pemütiuca'iyari yapemüticamie. 'Esivacütütü yapepüticamiecai, hicü vaüca nepümatihüritüani. 'Acusiyaripaü pe'atemavietü peque'ayani. ");
INSERT INTO hchNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Hicü 'iya huta quirivayari mu'üitüarie nuaca müpaü niutayüni, Cusiyari 'ecü tumini huta quirivayari pepünesi'uyetuiri. Neuxei mücücü tavari huta quirivayari nepana'ivaxü. ");
INSERT INTO hchNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Cusiyarieya müpaü tinitahüave, 'Aixüa puyü, ti'uximayatame 'aixüa pemütiuca'iyari yapemüticamie pecanihücütüni. 'Esivacütütü yapepüticamiecai, hicü vaüca nepümatihüritüani. 'Acusiyaripaü pe'atemavietü peque'ayani. ");
INSERT INTO hchNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Hicü 'iya xei quirivayari mutanaqui'erie müpaü niutayüni, Cusiyari nepümasimate 'ecü pema'a'eriyacü. Pepuca'isana haque pemücaheca'e, pepicuxexeüriva haque pemücaheicaxüri. ");
INSERT INTO hchNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Neri nematü neneyani netiti'avietaxü 'atumini cuieta. Camü 'apini. ");
INSERT INTO hchNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Hicü cusiyarieya müpaü tinitahüave, Cari ti'uximayatame 'axa pemütiuca'iyari pemü'a'üraxi pecanihücütüni. 'Ecüsietü pepünesimate que nemütiuca'isana haque nemücaheca'e, que nemüticuxexeüriva haque nemücaheicaxüri. ");
INSERT INTO hchNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","'Ayumieme peuyevecai 'ecü siqueresü netumini pemüyetuanicü tumini hüvemete vahesüa, ne nenuame nepini nemütitanaqui'erienicü yapaümeme 'ana'ivayu. ");
INSERT INTO hchNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Tamüsü xequenenavairi 'iya tuminieya, xequene'üitüa 'iya tamamata quirivayari mexeiya. ");
INSERT INTO hchNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Que mü'ane tixaütü mürexeiya tavari cuxi pütimiquieni, manayuhayevanicü. Que mü'ane tixaü mücarexeiya, sepa que mütitita mürexeiya, pütinavaiyarieni. ");
INSERT INTO hchNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","'Iya ti'uximayatame 'asimücatiuyuri xequenanuyehüva tacua yüvipa. Mana putasuacani pütiyutaqueveni. ");
INSERT INTO hchNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Mericüsü quepaucua munuani Yuri Tevi marivetü, yunaitü tupirisiximama me'iteütacacu Cacaüyarisie mieme memüpasie, 'ana marivetü payerüni yu'uvenisie. ");
INSERT INTO hchNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Yunaitü nuivarite menicuxeüriyacuni hüxiena. Nivapatamücü, muxasi vahüveme que mütivapata muxasi sipuri. ");
INSERT INTO hchNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Muxasi nivati'uitüamücü yuserieta sipuri yu'utata. ");
INSERT INTO hchNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","'Ana Ti'aitame müpaü pütivatahüave müme serietana memüti'uni, Xequenaye'axüari xeme. Ne'uquiyari 'aixüa paine xehepaüsita. Xeheixeiyatü xequenacüni tixe'aitüvametüme, xehesie mieme que mütiucuha'arisie quepaucua cuie munetüarie. ");
INSERT INTO hchNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ne neheuhacamücücacu xepünete'umi, neheuharimücücacu xepünesi'uharitüa, necuyeicametüme xepünesi'utanaqui'eri, ");
INSERT INTO hchNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","nemavecacu xepünesi'uquemaritüa, neticuyecacu xepünesi'üviyacai, ne'anutahüiyacu nehesüa xepü'axecai. ");
INSERT INTO hchNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","'Anari müme heiseriemecü yamemütecahu müpaü metenitahüavicuni, Ti'aitame quepaucua tepümasi'uxei peheuhacamücüme temate'umi, peheuharimücüme tepümasi'uharitüa. ");
INSERT INTO hchNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Quepaucuasü tepümasi'uxei pecuyeicame temasi'utanaqui'eri, pemaveme temate'utiquemaritüa. ");
INSERT INTO hchNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Quepaucua tepümasi'uxei peticuyeme pe'anutahüiyacu 'ahesüa tete'axecai. ");
INSERT INTO hchNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Hicü Ti'aitame müpaü tinivatahüavimücü, Niuqui caniseüyeni que nemütixecühüave, müpaü que xemüvaruyurie 'ime ne'ivama sepa memü'imatüremetetücai, müpaü xepünesi'uyuri ne. ");
INSERT INTO hchNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Hicü müpaü pütivacühüavenita müme 'utatana memüti'uni, Nehesüa xequeneutayeixüa xeme 'axa xemütecühüavarüva. Tai yuheyemecü müta'asie Cauyumariesie mieme tupirisiximama vahesie mieme mucuha'arisiesie xequenehu. ");
INSERT INTO hchNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Neri neheuhacamücücacu xepücanete'umi. Neheuharimücücacu xepücanesi'uharitüa. ");
INSERT INTO hchNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Necuyeicametüme xepücanesi'utanaqui'erie, nemavecacu xepücanesi'utiquemaritüa, neticuyecacu ne'anutahüiyacu xepücanesi'üviyacai. ");
INSERT INTO hchNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","'Anari müme müpaü metenitahüavicuni, Ti'aitame quepaucua tepümasi'uxei peheuhacamücüme peheuharimücüme pecuyeicame pemaveme peticuyeme pe'anutahüiyacu, temücatavaüriyacai temasiparevienicü. ");
INSERT INTO hchNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Hicü müpaü tinivatahüavimücü, Niuqui caniseüyeni que nemütixecühüave, müpaü que xemücavaruyuri 'ime ne'ivama sepa memü'imatüremetetücai, müpaü xepücanesi'uyuri ne. ");
INSERT INTO hchNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Mümesü mecaniyehuni yuheyemecü memü'uximatüariecacü, müme heiseriemecü yamemütecahu tucari mücaxüve memexeiyacü püta mecaniyehuni. ");
INSERT INTO hchNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Mericüsü Quesusi 'inüca 'icü niuqui naime, müpaü tinivarutahüave yuhesüa miemete teyü'üquitüvamete, ");
INSERT INTO hchNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Xeme müpaü xepütemate, huta tucari 'anucayayu, Pasicua 'ixüarari canatinemücü quepaucua teme'eriva, Cacaüyari que mütivaruhayevaxü tateüterima. 'Ana Yuri Tevi nehücütütü neniyetuiyamücü curuxisie nemümierienicü. ");
INSERT INTO hchNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Hicü 'ana mara'acate memühüritüariecai teüteri va'uquiyarima meniuyucuxeürieni mara'acame mühüritüariecaisüa Caipasi mütitevacaisüa. ");
INSERT INTO hchNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Meniuyu'enieni, me'icuamaname memiviyacü Quesusi, memimienicü. ");
INSERT INTO hchNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Müpaü meniutiyuanecaitüni, 'Ixüaramete vahüxie xeicüa tepüca'iviya, teüteri me'uyuxamurienicü. ");
INSERT INTO hchNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Mericüsü Quesusi mana niucateitüni Vetaniyasie Simunisüa cuiniyacü meripai müca'itiyacaisüa. ");
INSERT INTO hchNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Hicü 'uca mana ninuani tete puteyayari visi mü'ane 'ahanatü visi mu'üa 'aye'üneme cuini mieme müraye'axe. Neitituani Quesusi mu'uyasie ticuacacu. ");
INSERT INTO hchNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Hicü teyü'üquitüvamete me'ixeiyatü meniuyeha'ani müpaü me'utiyuatü, Titayaricutaxi yacü xeicüa reiyehüa. ");
INSERT INTO hchNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Püyüveniqueyu vaücavamecü mütuiyacacü, tuminiyari memümiquienicü memümamave. ");
INSERT INTO hchNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Quesusi müpaü retimaica, müpaü tinivarutahüave, Titayari xete'i'uximatüa 'uca. 'Aixüa tiniuyurieni nehesie mieme. ");
INSERT INTO hchNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","'Uxa'atüni varie 'amecaniu'uvacuni memümamave xehesüa, nesiere xehesüa 'anepüca'uyeicani 'uxa'atüni varie. ");
INSERT INTO hchNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","'Ipaü que müreititua visi mu'üa nehesie, nesicuha'aritüatü nemücateuquienicü müpaü pütiuyuri. ");
INSERT INTO hchNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Niuqui caniseüyeni que nemütixecühüave, sepanetü haque 'icü niuqui 'aixüa manuyüne hepaüsita mecuxaxasivani naisarie cuiepa, que mütiuyuri 'icü 'uca canitaxasiemücü ma'erivanicü. ");
INSERT INTO hchNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Mericüsü Cura Tamamata Heimana Yuhutame müxevitütücai 'Isicariutitanaca mütitevacai mana neyani mara'acate memühüritüariecai vahesüa. ");
INSERT INTO hchNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Müpaü tinivarutahüave, Tita xenete'üitüani nemüxeyetuirienicü. Müme yuhamatüa me'uyu'enieca xei teviyari heimana tamamata meni'üitüani pürata tuminiyari. ");
INSERT INTO hchNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","'Ana nisutüani ticuvaunetü quepaucua 'aixüa müyüniqueyu müvayetuirienicü. ");
INSERT INTO hchNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Mericüsü 'anatücacu Pa Mücacuxanariyari tucariyari, teyü'üquitüvamete Quesusi 'aurie meniuyucuxeürieni müpaü me'utiyuatü, Haque masihenaque 'aixüa temeiyurienicü, 'ecü 'ixüarari 'icuaiyari pemürecuanicü. ");
INSERT INTO hchNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Müpaü tivacühüave, Xeimesüa xequenehu quiecarisie. Müpaü xequetenetahüavi, Ti'üquitame müpaü paine, Netucari caneutihuraniri. 'Aquita Pasicua 'ixüarari nepütavevieniqueyu nehesüa miemete teyü'üquitüvamete vahamatü. ");
INSERT INTO hchNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Hicü Quesusi que mütivaruta'aitüa yamepüte'uyurie. 'Aixüa mepiyuri Pasicua 'ixüarari 'icuaiyari, para meme'erivanicü Cacaüyari que mütivaruhayevaxü vateüterima. ");
INSERT INTO hchNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Hicü 'ucutaicairecu mexa 'aurie nayerüni Tamamata Heimana Yuhutame vahamatü. ");
INSERT INTO hchNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Metecuacacu müpaü niutayüni, Niuqui caniseüyeni que nemütixecühüave, xevitü xeme pünesiyetuani. ");
INSERT INTO hchNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Cuini mieme meyuhiverietü yuxexuitü müpaü metenitihüavetücüne, Ne netihücü Ti'aitame. ");
INSERT INTO hchNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","'Iya müpaü tinivarutahüave, Xevitü canihücütüni nehamatü pa manati'üve xacüsie, 'iya caneniyetuamücü. ");
INSERT INTO hchNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Yuri Tevi que nemütiteva necaniyemieni nemümierienicü que müre'uxa nehepaüsita, peru xüa 'ui 'iya tevi que mü'ane münesiyetuani Yuri Tevi nehücütüme. Masi 'aixüa pü'aneniqueyu xüca ca'utinuivaque 'iya tevi. ");
INSERT INTO hchNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Hicü miyetuaniquecai Curatütü müpaü niutayüni, Ti'üquitame netihücü ne. Rehüave, 'Ecüsü müpaü pecaniutaineni. ");
INSERT INTO hchNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Hicü metecuacacu Quesusi pa nanucu'üni. 'Aixüa 'utayüca Cacaüyari hepaüsita pa hepaüsita, nititara tivarumi teyü'üquitüvamete. Müpaü niutayüni, Xequenanu'üi xequeneuticua'i. 'Icü caninevaiyaritüni. ");
INSERT INTO hchNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Hicü 'enucuhanaca tecüxi, pamüpariyusi 'ipitüaca Cacaüyari, nivaru'itüani müpaü 'utaitü, Yunaitü xequenanuti'iexüa 'icü. ");
INSERT INTO hchNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","'Icü caninexuriyatüni, türatu mühecua caniseiriyamücü. Yumüireme vahesie mieme nitayeuriemücü memüteheuyehüviyarienicü 'axa memüte'uyuricü. ");
INSERT INTO hchNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Müpaü nepütixecühüave, tavari havaicü nepüca'enu'ieni 'icü caxie hayari, mexi tucari ca'aye'ave quepaucua hecuamecü nemenu'ieni xehamatü haque ne'uquiyari müre'aita. ");
INSERT INTO hchNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Hicü cuicari Cacaüyari hepaüsita me'uticuicaca menecüne Huriva Mati'u. ");
INSERT INTO hchNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Hicü Quesusi müpaü tinivarutahüave, Xeme yunaitü xepücunuitüarieni 'icü tücarisie necümana. Müpaü püre'uxa, Nepimieni muxasi vahüveme, muxasi müva'üviyacai menitaxüriexüacuni. ");
INSERT INTO hchNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Nemierieme ne'anucuqueme nenixe'anucuhaitüiyamücü Carereyasiepaitü. ");
INSERT INTO hchNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Hicü Pecuru müpaü tinitahüave, Sepanetü yunaitü memucunuitüarie 'acümana, ne hasuacu nepücacunuani. ");
INSERT INTO hchNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Quesusi rehüave, Niuqui caniseüyeni que nematicühüave, 'icü tücarisie vacana 'uquiri catahivavecacu cuxi, 'ecü haicacüa pepü'acu'imavani, quename pecanesimate pe'utaitü. ");
INSERT INTO hchNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pecuru rehüave, Sepanetü meuyevese 'ahamatü nemumierieni, nepücanecu'imavani quename necamasimate ne'utaitü. Yunaitü teyü'üquitüvamete yaxeicüa meniutiyuanecaitüni. ");
INSERT INTO hchNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Mericüsü Quesusi Quetisemani mütiuyetevasie neta'ani vahamatü. Müpaü tinivarutahüave teyü'üquitüvamete, 'Uva xequenateni, ne mexicuxi 'uma nepünenenevimie. ");
INSERT INTO hchNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Hicü Pecurumame Severeu nivemama yuhutame nivarevitüni manapai, nisutüani yuhiverietü yu'iyaritüatü. ");
INSERT INTO hchNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Hicü müpaü tinivarutahüave, Ne'iyarisie cuini mieme neninehiverieca, mücücü nenimüximeni. 'Uva xequeneyuhayeva xequenetaneniereni nehamatü. ");
INSERT INTO hchNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","'Esiva 'uma 'uyaca niutihüximaqueni. Niyutanenevieni müpaü 'utaitü, Ne'uquiyari xüca tüma yüvenique müca'aye'anicü, 'icü hivericacü nemüca'itüarienicü cuerietü. Mesü que münetinaque ne pücatixaü, que matinaque 'ecü püta yaneque'itüarieni. ");
INSERT INTO hchNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Teyü'üquitüvamete memanatecaisie nuaca, nivaretaxeiya mecusume. Müpaü tinitahüave Pecuru, 'E'e xecateyüvavecai siqueresü xei hurayari xemütanenierenicü nehamatü. ");
INSERT INTO hchNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Xequenetaneniereni, xequeneyunenevieca capa 'axa xete'uyurienicü xe'uta'inüasieme. Xe'iyari caniyuvaüriyani, xevaiyari masi puverani. ");
INSERT INTO hchNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Hicü hutarieca heyaca niyutanenevieni müpaü 'utaitü, Ne'uquiyari, xüca cayüveni 'icü manuyeyanicü, xüca heuyeveca yanemü'itüarienicü, que mümatinaque yaquetiuyüni. ");
INSERT INTO hchNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Nuaca tavari nivaretaxeiya mecusume, memücusimarietücateicü. ");
INSERT INTO hchNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Varucu'eirieca tavari heyaca hairieca tiyutanenevi yaxeicüa 'utaitü. ");
INSERT INTO hchNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Hicü teyü'üquitüvamete memanatecaisie nuaca müpaü tinivarutahüave, Xetecusu cuxi xete'uxipie. Camü, canaye'aximeniri, Yuri Tevi que nemütihücü, nemüyetuiyanicü 'axa teyuruvamete vahesüa. ");
INSERT INTO hchNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Xequenanucu'uti tepüvanaquiyu. Que mü'ane münesiyetuani 'acanamieni. ");
INSERT INTO hchNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Mericüsü 'utaniucacacu cuxi Cura mana caninuani Tamamata Heimana Yuhutame müxevitütücai. Yuvaücavame teüteri yuhamame nivaravitücücaitüni 'ixiparate cüyexi mete'u'ücame, mara'acate memühüritüariecai teüteri va'uquiyarima mevareyenü'acu. ");
INSERT INTO hchNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","'Iya miyetuaniquecai 'inüari püvarupitüa mevayecünirümecacu, müpaü 'utaitü, Que mü'ane nemütavaüritüani ne'i'isetü, mücü canihücütüni. Xequeneuviya. ");
INSERT INTO hchNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Hicü Quesusisüa nuaca müpaü niutayüni, Que 'acu Ti'üquitame. Ni'iseni. ");
INSERT INTO hchNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Hicü Quesusi müpaü tinitahüave, Nehamicu, titacü pemütinua, yaquetineuyuri. Hicü 'auriena me'uyucuxeürieca, Quesusi meniuviya. ");
INSERT INTO hchNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Müme Quesusimatü memu'uvacai xevitü nivatihana yu'ixipara. 'Ivaca ti'uximayatame mara'acame mühüritüariecaisüa mieme, nacaya naviteni. ");
INSERT INTO hchNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Hicü Quesusi müpaü tinitahüave, Painatana queneuca'uta 'a'ixipara. Yunaitü 'ixiparasie memüteviya, 'ixiparacü mepüca'unarieni. ");
INSERT INTO hchNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Müpaü pecaticu'eriva nemüyüvecü nemitavavirienicü ne'uquiyari, mücü cuitü müvaranü'anicü yutupirisixima tamamata heimana huta vaxayari meyupaümeme. ");
INSERT INTO hchNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Peru xüca müpaü netiyurienique, quepaü raye'aniqueyu 'utüarica meuyevese 'ipaü mütiyüni manuyüne. ");
INSERT INTO hchNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Hicü 'ana Quesusi müpaü tinivarutahüave teüteri, Cari xepeyecü 'ixiparate cüyexi xe'u'ütü xenesiviyaque, que mütiviviyarüva tinavayame. Müixa tuquita nenayecateitüni tucaricü neti'üquitatü. 'Ana xepücanesihevi. ");
INSERT INTO hchNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Perusü 'ipaü naitü pütiuyü, maye'anicü texaxatamete que memutiyua 'utüarica xapayarisie. Hicü teyü'üquitüvamete yunaitü me'icu'eirieca meniyuta'unaxüani. ");
INSERT INTO hchNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Müme memiviya Quesusi mecani'atüirieni Caipasi. Mücü mara'acame mühüritüariecai canihücütücaitüni. Hesüana müme 'inüaricü memüte'üquitametetücai meniyucuxeürieni 'uquiravesixi vahamatü. ");
INSERT INTO hchNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pecuru niveiyacaitüni yateva mara'acame mühüritüariecai quitanapaitü. Mana heutahaca tupirisixi va'aurie nayerüni niereque que mü'itüarieniquecai. ");
INSERT INTO hchNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Hicü mara'acate memühüritüariecai vahamatü yunaitü 'isücate 'axeicüa menivavautüvecaitüni memunenierixü, Quesusi memütaxanetacü, vaniuquicü mümierienicü. ");
INSERT INTO hchNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Mepüyutexiecai sepa yumüiretü mete'itavatü memu'axüa metehecüatatü que memüte'unenierixü. 'Imatürieca yuhutatü me'anucu'uca, ");
INSERT INTO hchNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","müpaü meniutiyuani, 'Icü müpaü painecai, Ne necaniyüveni nemica'unacü Cacaüyari tuquieya, tavari hairieca tucari nerenuquitüani. ");
INSERT INTO hchNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Hicü mara'acame mühüritüariecai 'anucuqueca müpaü tinitahüave, Tixaü pecatitaniuni 'ahepaüsita, 'ipaü que memümatexaneta 'ime. ");
INSERT INTO hchNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Quesusi 'asipücahainecai. Hicü mara'acame mühüritüariecai müpaü tinitahüave, Nepümasihüritüa Cacaüyari mayeyuri masi'eniecacu yapemütaticühüavenicü xüca cürisitu pehücütüni Cacaüyari nu'aya. ");
INSERT INTO hchNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Quesusi cayucu'imavatü müpaü ticühüave, 'Ecü müpaü pecaniutaineni. Mücü meta, müpaü nepütixecühüave, Yemecü xecanenixeiyacuni Yuri Tevi que nemütihücü, mana ne'acaime Que Mü'ane Mütürücaüye serieta, haisata ne'acamiecame taheima. ");
INSERT INTO hchNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Hicü mara'acame mühüritüariecai yu'ixuriqui niutasana müpaü 'utaitü, Cari pisevixima Cacaüyari 'axa 'utaitü. Que cuxi tetevareuyehüva memunenierixü. Xemetütü hicüri xepi'eni que mütisevixima Cacaüyari 'axa 'utaitü. ");
INSERT INTO hchNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Que xetecu'eriva. Müme müpaü metenicühüaveni, Peuyevese mümierienicü. ");
INSERT INTO hchNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Hicü mericü meniti'aüsicamatücüne hüxitana, menitihusutücüne. Hipatü 'auritapana meneitivani ");
INSERT INTO hchNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","müpaü me'utiyuatü, Cari pepütixaxatame. Mericüte Cürisitu, quetaneutaxatüa que mü'ane pümasiheutiva. ");
INSERT INTO hchNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Mericüsü Pecuru tacua niucateitüni. Ti'uximayatame hesüana nuaca 'üimaritütü müpaü tinitahüave, 'E'e, 'ecütari Quesusimatü pepuyeicacai Carereya quiecamematü. ");
INSERT INTO hchNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","'Iya niyucu'imavacaitüni yunaime vahüxie müpaü 'utaitü, 'Asinepücatimate tita pemütixata. ");
INSERT INTO hchNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Mana heyacu quitenie xevitü nixeiya 'uca. Müpaü tinivarutahüave müme mana memüti'ucai, 'Icüri Quesusi Nasaretitanacamatü puyeicacai. ");
INSERT INTO hchNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Tavari niyuta'imani yühüritüatü müpaü 'utaitü, Cacaüyari nesi'eniecacu nepaine, nepüca'imate mücü tevi. ");
INSERT INTO hchNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Yareutevicacu vana memüti'ucai me'u'axüaca müpaü metenitahüave Pecuru, Yuricü 'ecü xevitü pecanihücütüni müme. 'Aniuquicü pepümasiücü que pemütiuniuca. ");
INSERT INTO hchNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Hicü 'axa tiniutiniutüyani, müpaü 'utaitü, Cacaüyari xüca 'axa nesiyurienique tüma xüca neti'itavani, yemecü nepaine, nepüca'imate mücü tevi. Yapaucua niutahiva vacana. ");
INSERT INTO hchNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Pecuru ne'erivacaitüni Quesusi niuquieya que mütitahüavixü, Vacana catahivavecacu cuxi, 'ecü haicacüa pepü'acu'imavani quename pecanesimate pe'utaitü. 'Anuyeyaca niutasuani cui yuhiverietü. ");
INSERT INTO hchNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Mericüsü ximeri yunaitü mara'acate memühüritüariecai teüteri va'uquiyarima vahamatü meniuyucuxeürieni meyu'enienique Quesusi hepaüsita, memimienicü. ");
INSERT INTO hchNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Meneihana hüacame, Piratu meniyetuirieni cuvexunaruri. ");
INSERT INTO hchNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Mericüsü Cura miyetua tiutamarieca quename 'isücate mete'uta'aitaxü mümierienicü, yücü tiniyücühüavecaitüni. Vatumini nivarecu'üitüani mara'acate memühüritüariecai 'uquiravesixi, xei teviyari heimana tamamata pürata tuminiyari, ");
INSERT INTO hchNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","müpaü 'utaitü, 'Axa nepütiuyuri nemiyetuacü tevi hesiena mücarahüiya, xuriyaya mütayeurienicü. Müme müpaü metenicühüavecaitüni, Sepasü tame, 'ecü püta pepü'acuerivayurieca. ");
INSERT INTO hchNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Tuquita heicaxürieca tumini nivayeyani. Heyaca niuyucavieni. ");
INSERT INTO hchNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Mara'acate memühüritüariecai meheiti'üca tumini müpaü meniutiyuanecaitüni, Pücatauniva temeicaxürienicü tuqui tuminiyari meucavesie, muyetuiyacü tevi xuriyaya mütayeurienicü. ");
INSERT INTO hchNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Me'uyu'enieca cuie mecaniunaneni mücü tuminicü xari vevivame cuieya, mana heu'uvacate teva miemete vateuquiyapa mayanicü. ");
INSERT INTO hchNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","'Ayumieme mücü cuie Xuriya Mataxüri catiniuyetevaca hicüque. ");
INSERT INTO hchNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","'Anari naye'ani tita Cacaüyari mütiutayü Queremiyaxi müpaü 'utainecacu tixaxatametütü, Menei'üni xei teviyari heimana tamamata pürata tuminiyari, que müraye'arücai 'iya, 'Ixaherisixi teüteriyari müpaü mete'eye'atüacu, ");
INSERT INTO hchNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","mepi'üitüa xari vevivame meminanairienicü cuie, Ti'aitame que münetiu'aitüa. ");
INSERT INTO hchNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Mericüsü Quesusi niutaquerieni cuvexunaruri hüxie. Mücü müpaü tinita'ivaviya, 'Ecü Huriyusixi teüteriyari tiva'aitüvame petihücü 'ecü. Quesusi cayucu'imavatü rehüave, 'Ecüsü müpaü pecaniutaineni. ");
INSERT INTO hchNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Mara'acate memühüritüariecai 'uquiravesixi me'ixanetacacu 'asipücatiuta'a. ");
INSERT INTO hchNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Hicü Piratu müpaü tinitahüave, Pecativa'enie que müreupaüme memaitüca 'ahepaüsita memunenierixü. ");
INSERT INTO hchNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","'Iya havaicü püca'ita'ei. 'Ayumieme cui ni'iyarixiecaitüni cuvexunaruri. ");
INSERT INTO hchNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Mericüsü xexuime 'ixüarapa cuvexunaruri niyuvaüriyacaitüni memanutaxürivacai xevitü müxünarienicü teüteri vahesie mieme, que mü'ane müvanaquecai. ");
INSERT INTO hchNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","'Ana 'anutahüiyacame mecanexeiyacaitüni mümarivacai Vaxavaxi mütitevacai. ");
INSERT INTO hchNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Me'uyucuxeüriecu Piratu müpaü tinivarutahüave, Que mü'ane püxenaque nemüxexünirieni, Vaxavaxiri, mesü Quesusiri Cürisitu müterüvarüva. ");
INSERT INTO hchNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Müpaü pütimaicai, me'ütesatü memiyetuacü. ");
INSERT INTO hchNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Hicü Piratu mana 'acaicu 'isücame 'uvenieyasie, 'üyaya niuqui neinü'airieni müpaü 'utaitü, Queneuhayeva mücü tevi heiseriemecü yamüticamie. Cümana vaüca nepütiucuinixü neheinüsita hicü yüvicüta. ");
INSERT INTO hchNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Mericüsü mara'acate memühüritüariecai 'uquiravesixita menivarutahüave teüteri memitavavirienicü Vaxavaxi, memüteta'aitacü Quesusi mümierienicü. ");
INSERT INTO hchNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Hicü müpaü tinivarutahüave cuvexunaruri, 'Ime yuhutame que mü'ane püxenaque nemüxexünirienicü. Müme müpaü mepaitücatei, Vaxavaxi queneuxüna. ");
INSERT INTO hchNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Piratu tivacühüave, Mericüte, queri ne'iyurieni Quesusi 'icü Cürisitu müterüvarüva. Yunaitü mete'icühüave, Curuxisie que'umierieni. ");
INSERT INTO hchNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","'Iya tivarahüave, Titayaricuta, queri tiuyuri 'axa tiuyuri. Müme cuini mieme meniutihivatücüne müpaü me'utiyuatü, Curuxisie que'umierieniricü. ");
INSERT INTO hchNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Piratu tiuxeiyaca que mütiyutexienecai, masi cuini mieme que memüteyuxamurietüvecai, ha niuta'aita, niucamaimani teüteri vahüxie müpaü 'utaitü, Ne nepü'itiya, nehesie pücarahüivani 'icü xuriyayacü, xeme püta xehesie pürahüiyani. ");
INSERT INTO hchNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Yunaitü teüteri müpaü metenitahüave, Xuriyayacü tahesie querahüivani, tatüriyama vahesieta. ");
INSERT INTO hchNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Hicü nivaruxünirieni Vaxavaxi. Tiuta'aitaca Quesusi mücuveiyaxüanicü, niyetuani curuxisie mümierienicü. ");
INSERT INTO hchNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Mericüsü cuvexunarurisüa miemete cuyaxi parasiyusie meheivitüca Quesusi cuyaxi vaquita, menivaruta'inieni cuyaxi mana memayetecai yunaime. ");
INSERT INTO hchNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Me'itiquemaripieca, cuya 'ücarieya mütaüraüye menenacuvirieni. ");
INSERT INTO hchNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Xuya mumayari me'utasaca mu'uyasie menenutimanirieni, haca 'isüyari menicueitüani serietana. Hüxiena metitunuma'utü meninanaimacaitüni müpaü me'utiyuatü, Que 'acu Huriyusixi tiva'aitüvame. ");
INSERT INTO hchNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Me'i'aüsicavieca, haca meninavairieni, cümana mu'uyasie menicuvayacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Me'inanaimaca meninavairieni 'ücari, menitiquemaritüani 'ixuriquieyacü. Mana meneihana curuxisie mümierienicü. ");
INSERT INTO hchNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Mericüsü mana me'uyehutü menitaxeiya Sirenetanaca Simuni titevacame. Mecaniviya menutüquirienicü curuxieya. ");
INSERT INTO hchNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Curucuta mütiuyetevasie meniu'axüani, taniuquicü Müqui Mu'uya Manuca mütiuyetevasie. ");
INSERT INTO hchNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Mana meni'itüani vinu masina siürica nücame meuyuyehüacacü. He'inüataca püca'i'imücücai. ");
INSERT INTO hchNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Curuxisie me'icavieca cuyaxi meniyuta'iva que memüteheitahuriexüaniquecaicü 'ixuriquieya. ");
INSERT INTO hchNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Mana mecatetü meni'üviyacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Mu'uya heima meneivera xapa, que mütiutaxanesie re'ucame, 'ICÜ QUESUSI CANIHÜCÜTÜNI HURIYUSIXI MÜTIVA'AITÜVAME, 'anuyüneme. ");
INSERT INTO hchNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Mericüsü 'auriena menivarutivütüani tenavayamete yuhutame curuxisie, serietana xeime 'utatana xeime. ");
INSERT INTO hchNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Hicü müme memanuyecücacai 'axa metenicühüavecaitüni yumu'u me'utisiquetü ");
INSERT INTO hchNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","müpaü me'utiyuatü, Cari 'ecü pepica'unaquecai tuqui, haica tucari 'anayeyayu pepenuquitüaniquecai. Parasü, queneu'atavicueisitüa xüca Cacaüyari penu'ayatüni. Curuxisie quenacaye'a. ");
INSERT INTO hchNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Müpaüta mara'acate memühüritüariecai mümeta 'inüaricü memüte'üquitametetücai 'uquiravesixi vahamatü me'inanaimatü yunaitü müpaü meniutiyuanecaitüni, ");
INSERT INTO hchNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Hipame niu nivatavicueisitüvacaitüni, pücayüve müyutavicueisitüanicü yücümana. Cari 'Ixaherisixi catatini'aitüvametüni niu. Mericüte, hicü que'acayani curuxisie, yuri temüteta'erienicü tame hesiena. ");
INSERT INTO hchNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Mücüsietü Cacaüyarisie yuri püti'eriecai, hicü xüca 'inaqui'erieca que'itavicueisitüani müpaü mainecaicü, Ne Cacaüyari necaninu'ayatüni. ");
INSERT INTO hchNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Tenavayameteta 'auriena curuxisie memuyevücai yaxeicüa 'axa metenicühüavecaitüni. ");
INSERT INTO hchNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Mericüsü tuca niucuyüre naisarie mana cuiepa cüa caviecacuque niucuhecüare. ");
INSERT INTO hchNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Hicü cüa caviecacu Quesusi carima niutahiva müpaü 'utaitü, Heri, Heri, rama savacütani, taniuquicü Necacaüyari necacaüyari titayari penetiucu'eiri manuyüne. ");
INSERT INTO hchNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Hipatü müme muva memüti'ucai me'u'enanaca müpaü meniutiyuani, 'Eriyaxi niutahüave. ");
INSERT INTO hchNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Xevitü müme 'unausarümetü neyani, ha'iseveme 'acuetü nitihüniya vinu masinacü. Hacasie 'iqueca neitiserieni menu'ienicü. ");
INSERT INTO hchNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Hipatü müpaü meniutiyuani, 'Acuxisü tepütaneniereni, siparasü 'Eriyaxi xüca 'uhamieni 'itavicueisitüanique. ");
INSERT INTO hchNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Quesusi tavari carima 'utahivaca niyetuani yu'iyari. ");
INSERT INTO hchNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Hicü 'ixuriqui 'emayesuicai meuvücai tuquita hixüata nisane heimana 'acayuaca. Cuie putayua, tetexi tiutitarixü. ");
INSERT INTO hchNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Teuquiya nanutiyepietücani, yumüiretü Cacaüyari teüterimama memeucusixüa mepanucu'uitüarie. ");
INSERT INTO hchNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Teuquiyapa meheyecüneca Cacaüyari quiecariena meneutahaxüani 'anucuquecu 'iya, yumüiretü mepüvaruxei. ");
INSERT INTO hchNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Hicü cuya mühüritüariecai hipatü hamatüana memi'üviyacai Quesusi quepaucua cuie memuxei 'uyuaneme memixei naitü que mütiuyü, cuini mieme menimamacaitüni müpaü me'utiyuatü, Yuricü 'icü Cacaüyari caninu'ayatücaitüni. ");
INSERT INTO hchNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Yumüiretüta 'ucari mana meniti'ucaitüni teva metanenieretü. Müme Quesusimatü meneyecüne Carereyasie mete'iminique. ");
INSERT INTO hchNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Mariya Mararatanaca xevitüta Mariya Cacuvu Cuse müvavarusitücai, Severeu nivemama vavarusi hipatüta mana meniti'ucaitüni. ");
INSERT INTO hchNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Mericüsü 'acayunirümecacu, tevi mana ninuani xicutütü 'Arimateya quiecametütü Cuse titevatü mütiyü'üquitüvametücai Quesusisüa mieme. ");
INSERT INTO hchNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Piratusüa nuaca nitavavirieni Quesusi caxarieya. Hicü Piratu müpaü pütiu'aitaxü müyetuiriyarienicü. ");
INSERT INTO hchNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Hicü Quesusi caxarieya necueni nita'eima rinu 'ixuriquiyaricü 'itiyacamecü. ");
INSERT INTO hchNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Yuteuquiyapa neitateni mühecuacaisie meripai mütiuta'aitacai müvaye'inierienicü 'aitüa. Tete 'amünena 'acacurupaca teuquiya heunaca, neyani. ");
INSERT INTO hchNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mana meniucateitüni Mariya Mararatanaca xevitü Mariyamatü teuquiya hüxie. ");
INSERT INTO hchNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Mericüsü 'uxa'arieca, Pienixi 'utaxücu, mara'acate memühüritüariecai Pareseusixi vahamatü meniuyucuxeürieni Piratusüa ");
INSERT INTO hchNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","müpaü me'utiyuatü, Ti'aitame tame tepe'eriva 'iya tiyu'irüviyame que mainecai 'ayeyuritü cuxi, Haica tucari 'aye'ayu nepanucuqueni 'utaitü. ");
INSERT INTO hchNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","'Ayumieme quetineuta'aita teuquiya mü'üviyarienicü hairieca tixüyuque, capa teyü'üquitüvamete yüvicüta me'axüame me'inavanicü, müpaü capa metevarutahüavecü teüteri, Müquite vasata panucuque. Xüca müpaü meteyurienique, 'imatürieca mieme 'irümari pe'ivaniqueyu meripai mieme. ");
INSERT INTO hchNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Piratu müpaü tinivacühüaveni, Xemesietü cuyaxi xequenivaranuvitüqui. Xequenehu xequene'üviyani que xemüteyüvave. ");
INSERT INTO hchNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Müme mehecüneca meni'üviyacaitüni teuquiya. Cuyaxi menivaruhüritüani, tetesie teuquiya meniu'inüaritüani yuseyucü. ");
INSERT INTO hchNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Mericüsü 'uxipiya tucari 'utaxücu semana mexüacame tucarisie yuimuana Mariya Mararatanaca xevitü Mariyamatü mana meniu'axüani me'ixeiyaque teuquiya. ");
INSERT INTO hchNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Hicü cuie carima niutayuani. Taheima nacaneni Ti'aitame tupirieya. Nuaca, heicurupaca tete, hesiena nayerüni. ");
INSERT INTO hchNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Merücariyapaü pütiyuxexeiyacai, 'ixuriquiteya pütuxacai 'üvipaü. ");
INSERT INTO hchNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Me'imacatü tehüvemete cuyaxi meputiyüyüacacai, müquite vahepaü me'anenetü menacüne. ");
INSERT INTO hchNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Hicü niuqui tuayame müpaü tinivarutahüave 'ucari, Xepücaheumamaca xeme. Ne müpaü nepütimate xemicuvautüve Quesusi curuxisie memierie. ");
INSERT INTO hchNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","'Uva pücayeca. Panucuquetüarie que mainecai. Xequenacüni xequeneu'ixüari haque matequi. ");
INSERT INTO hchNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Hicü cuitü xequenehu, müpaü xequetenivaretahüavi teyü'üquitüvametemama müquite vasata manucuquetüariecü, müxe'anuhaitüiyacü Carereyasiepai. Mana xecaneixeiyacuni. Camü yanepütixe'utahüavixüri. ");
INSERT INTO hchNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Cuitü teuquiyapa meheyecüneca memamatü cui meyutemamavietü meniutanausaxüani memütevataxatüanicü teyü'üquitüvametemama. ");
INSERT INTO hchNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Hicü mana me'uhucacu Quesusi nivaranucunaque müpaü 'utaitü, 'Aixüa 'acu. Müme hetüana me'utihüxima'uca menimayüani quetayasie, nenevieri menipitüani. ");
INSERT INTO hchNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Hicü müpaü tinivacühüaveni Quesusi, Xepücaheumamaca. Xequenehu, xequetenivaretaxatüa ne'ivama Carereyapai memüyehucü. Mana mepünesihexeiya. ");
INSERT INTO hchNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Mericüsü 'ucari me'uhucacu, cuyaxi hipatü quiecarisie menecüneta. Naitü que müreyü metenivarutaxatüani mara'acate memühüritüariecai. ");
INSERT INTO hchNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Hicü 'uquiravesixi vahamatü me'uyucuxeürieca me'uyu'enieca yunaitü, tumini vaüca menivaru'üitüani cuyaxi ");
INSERT INTO hchNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","müpaü me'utiyuatü, Xeme müpaü xequeneutiyuaneni, Teyü'üquitüvametemama meniu'axüani, mepinava mexi tecusucai. ");
INSERT INTO hchNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Xüca cuvexunaruri tiutamarieni, tame 'aixüa tepiyurieni xehesie mücarahüiyanicü. ");
INSERT INTO hchNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Müme tumini me'utanaqui'erieca yamepüteyuriecai que memüte'utahüavarie. Müpaü pürecuxaxasiva Huriyusixi vasata hicüque. ");
INSERT INTO hchNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Hicü teyü'üquitüvamete Tamamata Heimana Xevitü Carereya menecüne mücü yemurisiepai Quesusi que mütivarehüavecai memüyehucü. ");
INSERT INTO hchNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Me'ixeiyatü nenevieri mecanipitüacaitüni, hipatüsietü müme 'asimepücatemaicai xüca yuritücaitüni me xüca catixaütüni. ");
INSERT INTO hchNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Hicü Quesusi 'aura niuyani, tinivarutaxatüani müpaü 'utaitü, Naimecü heiserie nepexeiya taheima cuiepata. ");
INSERT INTO hchNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","'Ayumieme xequeneutayeixüa, teyü'üquitüvamete xequenivarayeitüa yunaime nuivarite, xevaca'üyatü ta'uquiyarisüa nu'ayasüa 'Iyari Mütiyupatasüa memümiemetetünicü, ");
INSERT INTO hchNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","xeteva'üquitüatü yamemütecahunicü nai que nemütixe'u'aitüa. Camüsü, nesietü tucaricü xehamatü nepuyeicani mexi cataparive. Müpaü xeicüa cani'aneni.");
INSERT INTO hchNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Niuqui 'aixüa manuyüne Quesusi Cürisitu Cacaüyari münu'aya hepaüsita, 'ipaü tiniusutüarieni. ");
INSERT INTO hchNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Quisariyaxi Cacaüyarisüa mieme mütixaxatametücai xapayasie, müpaü catine'uca, Camü, neniuqui tuayame necananunü'amücü meri. Mücü 'aixüa caniyuriemücü 'ahuye pecanuavecacu. ");
INSERT INTO hchNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Macumavesie xevitü nahivani, Xequeneha'aritüaca Ti'aitame huyeya, 'utaitü, Xequeneutixeurariya huyeteya, 'utaitü. ");
INSERT INTO hchNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Que müre'uxa, Vani macumavesie tine'üyanecaitüni, müpaü ticuxatatü, memütehayevacü 'axa memüteyuriecaicü, mücücü memüteheuyehüviyarienicü, 'arique memüca'üyarienicü. ");
INSERT INTO hchNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Yunaitü Cureya cuieyarisie quiecatari, yunaitü Querusareme quiecatarita, meneyecüne me'ixeiyacutü. Nivareca'üyacaitüni yunaime Curutani hatuxamesie, meyuhecüatacacu 'axa que memüte'uyuri. ");
INSERT INTO hchNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Mücü Vani cameyu huxariyari cananacatücücaitüni, navi hüyameyaricü nayühüacaitüni. Tüpuxi nivacuacaitüni, yeuta mieme xiete ni'iecaitüni. ");
INSERT INTO hchNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Que müticuxatacai, müpaü nainecaitüni, Xevitü 'ucanamieni ne'utüma. 'Iya yemecü canive'emetüni, ne pücatixaü. Ne 'aixüa nepüca'ane nehesie mütinaquenicü ni nemiparevienicü. ");
INSERT INTO hchNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nesüari necanixe'üyaneni hacü. Mücü canixeca'üyamücü 'Iyari Mütiyupatacü. ");
INSERT INTO hchNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Mericüsü, 'ana caninuani Quesusi, Nasareti heyeyaca Carereya cuieyarisie. Vani canica'üya Curutani hatuxamesie. ");
INSERT INTO hchNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Hicü Quesusi hapa 'anatiyeiximetü, muyuavi niuxeiya 'anacayepierümeme. Canixeiya 'Iyari 'acamieme para hesiena müyuhayevacü, cucurupaü 'anetü. ");
INSERT INTO hchNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Xevitüta niutaniuni taheima, müpaü 'utaitü, 'Ecü pecaninenivetüni, necamaninaqui'erieca. 'Acümana neninetemavieca. ");
INSERT INTO hchNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Hicü 'Iyari neinü'ani macumavesie. ");
INSERT INTO hchNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Mana niuyeicacaitüni huta teviyari tucari. Cauyumarie ni'inüatanecaitüni. Yeutari memüvaxuave niuyeicacaitüni Quesusi. Cacaüyari tupirisiximama menipareviecaitüni. ");
INSERT INTO hchNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Mericüsü, Vani 'anutahüiyacu, Quesusi caninuani Carereya cuieyarisie, niuqui cuxatatü 'aixüa manuyüne, que mütiyüni Cacaüyari ti'aitametücacu ticuxatatü, ");
INSERT INTO hchNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","ya'utaitü, Tucari canaye'aniri. Hicürixüa Cacaüyari cuitü canisutüamücü 'ena ti'aitatü. Xequeteneuhayeva que xemüteyuriecai, niuqui 'aixüa manuyünesie yuri xequeteneuta'eri. ");
INSERT INTO hchNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Mericüsü, haracuna tesita 'uyemietü Carereya cuieyarisie, canivaruxeiya Simuni 'Atüreximame yu'ivamacame. 'Emeneitavivivacaitüni vipi haracunasie, memüquesüteveiyametetücaicü müme. ");
INSERT INTO hchNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Hicü Quesusi müpaü tinivarutahüave, Cümü, nehesie xequeteneviyani. Teüteri xevacuxexeürivame nenixe'ayeitüamücü, quesüte xemütevaruxexeürivapaü hicü. ");
INSERT INTO hchNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Yapaucua yuvipi me'ucu'eirieca, hesiena meteniuviya. ");
INSERT INTO hchNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Hicü 'esiva 'umapai 'uyemietü nivaruxeiya Cacuvu Vanimame yu'ivamacame, Severeu nivemama. Müme canuvasie meniyetecaitüni yuvipi memanesiquitüatü. ");
INSERT INTO hchNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","'Iya nivaruta'inieni hesiena memüteviyanicü. Yuquemasi Severeu me'ucu'eirieca canuvasie yecaime, te'ivamete vahamame, Quesusisie meteniuviya. ");
INSERT INTO hchNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Mericüsü Caperünaume meneta'axüani. Hicü cuitüva 'uxipiya tucarisie, Huriyusixi vatuquita heutahaca, tini'üquitacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Menihüxiyacaitüni tita müti'üquitacai hepaüsita. Que mü'ane heiserie mexeiyapaü tinivaru'üquitüvacaitüni, que memücate'üquitacai müme 'inüaricü memüte'üquitametetücai. ");
INSERT INTO hchNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Mericüsü heutahacu, yapaucua tevi caneutahani vatuquita cacaüyari müca'itiya minücai. 'Iya niutahiva ");
INSERT INTO hchNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","müpaü 'utaitü, 'Ai, que petati'uximatüani, Quesusi Nasaretitanaca 'acu. Petasiheuyehüanique petinua. Ne nepümasimate que pemüpaicü. Que mü'ane Cacaüyarisie mieme mupasie, 'ecü pecanihücütüni, tinitahüave. ");
INSERT INTO hchNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Quesusi nita'imaiya, müpaü ticühüavetü, Cayuvatü 'aixüa, queneuxüna. ");
INSERT INTO hchNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Hicü mücü cacaüyari müca'itiya, tevi nütü, carima 'utahivatü, nixüna. ");
INSERT INTO hchNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Yunaitü meniuhüxiyani. 'Ayumieme niuqui meniutixüatüatücüne müpaü me'utiyuatü, Titari 'icü. Que titita 'icü 'üquisica mühecua. Camü heiserie hexeiyatü tiniva'aitüaca 'asita cacaüyarixi memüca'itiyatüca, müme meni'enieni. ");
INSERT INTO hchNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Hicü cuitüva naisarie Carereya cuieyarisie tiniutamariva que mütiuyuri. ");
INSERT INTO hchNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Mericüsü tuquita me'ayenexüaca, Simuni 'Atürexi vaquie menecüne, Vani Cacuvu yunaitü. ");
INSERT INTO hchNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simuni varücaüya mana niucateitüni hüiyatü. Cuitüva metenitaxatüani Quesusi que mü'anecai. ");
INSERT INTO hchNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Hicü 'aura 'ayaca, mamaya 'uviyaca, nenucuhana. Yapaucua cahüiyatü nayani 'uca, tinivarumini. ");
INSERT INTO hchNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Hicü taicai 'acayunecu, meni'atüirieni tecuicuicate yunaime, müme meta cacaüyarixi memüvaviyacai. ");
INSERT INTO hchNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Yunaitü quiecatari meniyucuxeürieni quitenie hüxie. ");
INSERT INTO hchNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yumüireme nivaranayexürieni cui memüyüacai müireme cuiniyacü. Cacaüyarixita nivarayenü'axüani yuvaücavame. Pücavapitüacai cacaüyarixi memütiniunicü, müme memimaicaicü. ");
INSERT INTO hchNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Hicü 'uxa'arieca ximeri meri 'acuxi yüvicüta nanucuqueni. Quita vayeyaca, neyani macumavesiepai. Mana niuyutanenevieni. ");
INSERT INTO hchNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Hicü Simuni, hipatüta hamatüana memu'uvacai menenucuyeique Quesusi. ");
INSERT INTO hchNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Me'itaxeiyaca müpaü metenitahüave, Yunaitü mepümasicuvautüve. ");
INSERT INTO hchNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Quesusi müpaü tinivarutahüave, Cümüsüari 'uma püta tepüyehu. Hipame quiecaritesie tepütayeixüani, nemütivaretaxatüanicü manarita. 'Ayumieme necaneyeyani. ");
INSERT INTO hchNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Hicü mana niuyeicacaitüni, ticuxatatü vatuquiteta naisarie Carereyasie, varayenü'avatü cacaüyarixi. ");
INSERT INTO hchNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Mericüsü xevitü cuiniyacü müca'itiyacai caninuani hesüana, cui 'ivavirietü. 'Utitunumaveca hüxiena, müpaü tinitahüave, Xüca pe'avaüriyani, 'ecü pecaniyüveni pemünesi'itieni. ");
INSERT INTO hchNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Quesusi 'inenimayatü yumama niutasera. Nimayüani müpaü ticühüavetü, Nesüari nepünevaüriya. Pecaniu'itiyaniri. ");
INSERT INTO hchNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Müpaü titahüavecu yapaucua peunua cuiniya. Tevi 'itiyatü nayani. ");
INSERT INTO hchNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Cuini mieme 'ihüritüatü, Quesusi neinü'ani cuitüva, ");
INSERT INTO hchNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","müpaü ticühüavetü, 'Amarima 'aixüa, xeimetüme pemücaraxaxatüvani havaicü. Mara'acamesüa quenemie püta. Quene'axeiyanüa. Pemanayevecü, quenanutimava que müre'aitaxü Muisexi yapemütivatahecüatüanicü. ");
INSERT INTO hchNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Mücü masi mana heyaca yatiniutixatatüyani vaücava. Naisarie tinicuxatacaitüni que mütiuyü. 'Ayumieme Quesusi pücayüvecai quiecarisie me'axeni yuhecüatatü, masi yeuta necateitüni macumavesie. Hesüana meni'axecaitüni naisarie quiecatari. ");
INSERT INTO hchNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Mericüsü yapaümexa tucari 'anucayacu, hutarieca caninuani Caperünaumesie. Catiniutamariva quename quita hayecatei. ");
INSERT INTO hchNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Yumüiretü cuitü meniyucuxeürieni. Memüyumüirecaicü, ni quitenie hüxie mepücatenaquecai. Mücü tinivacüxaxatüvacaitüni niuqui. ");
INSERT INTO hchNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Hicü hipatü huriecame meni'atüirieni, yunaucatü mehecuetü. ");
INSERT INTO hchNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Hura me'ecuenique meniyutatexieni teüteri memüyumüirecaicü. 'Ayumieme Quesusi manucatei qui heima püta mecaneitiyepieni. Me'ivati'ineca 'ixumari muva meneicatuani huriecame, 'itarisie 'acaime. ");
INSERT INTO hchNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Quesusi varuxeiyaca yuri que memüte'eriecai, müpaü tinitahüave huriecame, Nenive, pepüreuyehüviyarie 'axa pemütiuyuricü. ");
INSERT INTO hchNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Hicü hipatü 'inüaricü memüte'üquitametücai muva mecanayetecaitüni. Yu'iyarisie müpaü meteniyücühüavecaitüni, ");
INSERT INTO hchNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Titayaricuta müya ticühüave icü. Pisevixima Cacaüyari müpaü 'axa 'utaitü. Quepainetü püyüve müreiyehüvirieni tevi 'axa tiuyurieyu. Xevitiüxa xeicüa caniyüveni Cacaüyaritütü. ");
INSERT INTO hchNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Quesusi yu'iyarisie timaitü müya memüteyücühüavecaicü, müpaü tinivarutahüave, Titayari müya xeteyücühüave yu'iyarisie. ");
INSERT INTO hchNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Tita masi caticuanive. Que ticuanive müpaü mütitahüave muhurie, Pepüreuyehüviyarie 'axa pemütiuyuricü. Caticuanive masi müpaü mütitahüave, Quenanucuquexi, 'a'itari quenanucucue'i, quenecuyeicani. ");
INSERT INTO hchNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Paraque müpaü xemütehetimanicü Yuri Tevi netitevatü heiserie nemexeiyacü cuiepa, nemütivareuyehüvirienicü 'axa meteyurieyu, müpaü tinitahüave huriecame, ");
INSERT INTO hchNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","'Ecü nepümarahüave, quenanucuquexi, 'a'itari quenanucucue'i, 'aquie quenemie. ");
INSERT INTO hchNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Hicü nanucuqueni. Yu'itari 'anucucueca neyani yunaime vahüxie. 'Ayumieme yunaitü meniuhüxiyani. 'Aixüa meniutiyuanecaitüni Cacaüyari hepaüsita, müpaü me'utiyuatü, Hasuacu tepücanenierivave 'ipaü tiyüaneme. ");
INSERT INTO hchNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Mericüsü tavari haracuna tesita neyani Quesusi. Teüteri yunaitü hesüana meni'axecaitüni. Mücü tiniva'üquitüacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Hicü mana 'uyemietü nixeiya Revi 'Aripeu münu'ayatücai teüteri memüte'ayutituayasie 'acaime. Müpaü tinitahüave, Nehesie quetineviyani. Revi 'anucuqueca hesiena tiniuviya. ");
INSERT INTO hchNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Mericüsü ticuacacu Quesusi Revi quita, yuvaücavatü cuviyexunusie mieme memüteyetuiriyarie, hipatüta 'axa teyuruvamete metenicuacaitüni Quesusimatü teyü'üquitüvametemama vahamatü. Meniyumüirecaitüni memiveiyacai. ");
INSERT INTO hchNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Hicüsüari hipatü 'inüaricü memüte'üquitametetücai, müme Pareseusixi vahesie memüteviyacai, müme me'ixeiyaca ticuacame 'axa teyuruvamete vahamame müme cuviyexunusie mieme memüteyetuiriyari vahamame, müpaü metenivarutahüave teyü'üquitüvametemama, Neuxei, püticua'a püti'ie müme cuviyexunusie mieme memüteyetuiriyari vahamatü, 'axa teyuruvamete vahamatü. ");
INSERT INTO hchNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Quesusi varu'enieca müpaü tinivarutahüave, Müme 'aixüa memüteheu'erie tiyu'uhayemavame mepücaheuyehüva. Müme memütecucuye püta mepeiyehüva. Nesü que nemütinua, nepücanua nemüvata'inienicü müme heiseriemecü yamemütecahu. Müme 'axa memüteyurie püta nevata'inienique nepunua, memütehayevacü 'axa memüteyuriecaicü. ");
INSERT INTO hchNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Mericüsü Vani teyü'üquitüvametemama, Pareseusixi yunaitü 'icuai meniyuhaquiecaitüni heiva. Hipatü me'u'axüaca, müpaü metenita'ivaviya, Titayari Vani teyü'üquitüvametemama, teyü'üquitüvamete Pareseusixi vahesüa memümiemete titayari meteyuhaquie, 'ahesüa miemete teyü'üquitüvamete mecayuhaquiecacu. ");
INSERT INTO hchNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Quesusi müpaü tinivaruta'eiya, Que meteyüvave memüyuhaquieca neneüqueme cupaniyerumama, neneüqueme mexi vahamatü 'a'uca. Mexi neneüqueme vasata 'uca, mecapüyüvave memüyuhaquieca. ");
INSERT INTO hchNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Tucari naye'amücü quepaucua neneüqueme mütihanieni vasata. 'Ana meniyuhaquiecuni, 'iya tucari 'aye'ayu. ");
INSERT INTO hchNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Tevi 'ixuriqui mücayutatutuvecü püca'imanesiquitüani 'ixuriqui cui müye'i. Mesü xüca müpaü tiuyurienique, manesiqui hecuametütü müye'i pütahanaqueyu, sanimeyari masi 'axa 'anetü nayaniqueyu. ");
INSERT INTO hchNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Tevi sixai müye'isie püca'icatuani vinu mücuanacü, mesü xüca müpaü tiuyurienique, sixai nitasanequeyu, vinu neuyeveniqueyu sixaita. Vinu masi sixai hecuamesie canituarivani mücuanacü. ");
INSERT INTO hchNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Mericüsü 'uxipiya tucarisie 'esipa niuyeicacaitüni, teyü'üquitüvametemamata yunaitü. Müme menisutüani me'icahurucatü müayeyari, mana me'u'uvatü. ");
INSERT INTO hchNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Hicü Pareseusixi müpaü metenitahüave, Neuxei, titayaricuta müpaü meteyurie que mücatitauniva 'uxipiya tucarisie. ");
INSERT INTO hchNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Quesusi müpaü tinivarutahüave, Hasuacu xecate'ititerüvavave que mütiuyuri Raviri, heiyehüatü heuhacamütü, müme hamatüana memu'uvacaita meheuhacacuicucacu. ");
INSERT INTO hchNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","'Iya Cacaüyari quita neutahani quepaucua 'Aviyatari mühüritüariecai mara'acate vahepaüsita. Pa Cacaüyari hüxie mamanari niuticuani. Mara'acate xeicüa heiserie mepexeiya memiticuanicü mücü pa, hipatü heiserie mepücahexeiya. Müme hamatüana memu'uvacai tinivaruminita Raviri. ");
INSERT INTO hchNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Müpaüta tinivarutahüave Quesusi, 'Uxipiya tucari caniuti'usieni teüteri vahesie mieme. Teüteri que memüte'uveviya, 'uxipiya tucarisie mieme xeicüa mepüca'utiveviya. ");
INSERT INTO hchNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","'Ayumieme Yuri Tevi que nemütiteva, 'uxipiya tucari hepaüsitata necatini'aitani. ");
INSERT INTO hchNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Mericüsü tavari tuquita neutahani. Tevi mümamavaquicai muva nayecateitüni. ");
INSERT INTO hchNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Müme menihupiecaitüni, Capenayehüani 'uxipiya tucarisie meteyücühüavetü, me'ixanetacutü. ");
INSERT INTO hchNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Hicü Quesusi müpaü tinitahüave tevi mümamavaquicai, Quenanucuquexi, hixüapa queneutaquexi. ");
INSERT INTO hchNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Müpaü tinivaruta'ivaviya Quesusi, 'Uxipiya tucarisie tipitüarie 'aixüa mütiyurienicü, püpitüarie nusu 'axa mütiyurienicü. Tipitüarie mütiyutavicueisitüanicü, püpitüarie nusu mütiyumienicü. Mümesü cayuvatü meniumacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Hicü yuhaxüama varuxeiyaca, yuhiverietü memüsese'icaicü yu'iyarisie, müpaü tinitahüave tevi, 'Amama queneutasera. 'Iya nitasera, 'aixüa 'anetü nayani. ");
INSERT INTO hchNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Hicü Pareseusixi mevayecüneca, müme Herurexisie memüteviyacai vahamatü meniuyu'enieni hepaüsitana, que memüte'imieniquecai. ");
INSERT INTO hchNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Hicü Quesusi teyü'üquitüvametemama yunaitü haracunapai menecüne. Yumüiretü teüteri meniveiyacaitüni Carereyatari, Cureyatari, ");
INSERT INTO hchNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Querusaremetari, 'Irumeyatari, Curutani 'anutaüyetari, Tiru 'aurie Siruni 'aurie quiecatari. Yuvaücavatü me'u'enanaca nai que mütiyurienecai, hesüana mecaniu'axüani. ");
INSERT INTO hchNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Hicü nivaruta'aitüani teyü'üquitüvamete hura memehanacü canuva hesiena mieme, capa me'isaipünacü, memüyumüirecaicü teüteri. ");
INSERT INTO hchNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Yumüireme nivaranayexürüvacaitüni. 'Ayumieme yunaitü cuiniya memexeiyacai mesaipünetü hesüana meni'axecaitüni me'imayüanique. 'Ayumieme canuva niuta'aita. ");
INSERT INTO hchNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Cacaüyarixi memüca'itiyatüca me'ixeiyatü, hüxiena meniucaxürüvecaitüni, müpaü mete'uhivatü, 'Ecü Cacaüyari pecaninu'ayatüni. ");
INSERT INTO hchNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","'Iya heiseriemecü nivahüritüacaitüni memüca'ihecüatanicü que müpaicütücai. ");
INSERT INTO hchNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Hicü neutiyune hürisie. Müme müvaranuyexei nivaruta'inieni hesiena memüteviyanicü. Me'ayecüneca teüteri vasata, hesiena meteniuviya. ");
INSERT INTO hchNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Tamamata heimana yuhutame nivaranuyeteüxüa. 'Arique nivatanü'axüaniquecaitüni memütecuxatanicü, hamatüana memu'uvanicü, ");
INSERT INTO hchNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","heiserie nivapitüaniquecaitüni memüvaranayexürüvanicü tecuicuicate, memüvarayenü'axüanicüta cacaüyarixi 'axa memü'anene. ");
INSERT INTO hchNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Simuni püxevitütücai, Quesusi mitaterüvaxü Pecuru, ");
INSERT INTO hchNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","hipatüta, Cacuvu Severeu nu'aya, Vani Cacuvu 'ivaya, Quesusi mütivarutaterüvaxü Puhanerüquesi, taniuquicü Türarücamete paine, ");
INSERT INTO hchNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","'Atürexi, Piripe, Parüturume, Mateu, Tumaxi, Cacuvu 'Aripeu nu'aya, Tareu, Simuni mücananisitatücai, ");
INSERT INTO hchNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Cura 'Isicariutitanaca 'arique Quesusi müyetua. Hicü quita meneutahaxüani. ");
INSERT INTO hchNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Tavari yuvaücavatü teüteri me'u'axüacu müme mepüyutatexie metecuanique. ");
INSERT INTO hchNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Hicü maremama me'u'enanaca, meniu'axüani memenuhanacü. Müpaü meteniyücühüavecaitüni, 'Asipücatimate que mütiyuriene. ");
INSERT INTO hchNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Mücü meta, hipatü 'inüaricü memüte'üquitametetücai, Querusaremesie memeyecü, müpaü meniutiyuanecaitüni, Peheresepuri pinü'ü. Cacaüyarixi 'axa memü'anene va'uquiyarisie mütivayacü, 'ayumieme püvarayenü'a cacaüyarixi, meniutiyuanecaitünita. ");
INSERT INTO hchNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Hicüsüari yu'aurie varutacuevieca, 'üxasicü müpaü tinivaruta'üquitüani, Cauyumarie que tiyüve mayuyenü'anicü yücümana. ");
INSERT INTO hchNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Yaxeicüata, xeime cuieyarisie quiecatari xüca hixüata meyusana, xüca me'ayuca'unieca, mücü vacuviyexunu pücayüveni 'emüreutevinicü. ");
INSERT INTO hchNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Xeime quie miemete hixüata xüca meyusana, xüca me'ayuca'unieca, mepücayüvaveni 'ememüteheutevinicü. ");
INSERT INTO hchNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Cauyumarie xüca yuca'unarümenique, türücariyaya hixüata xüca yusanaque, 'emüreutevinicü pücayüveniqueyu. Pütaxüximeniqueyu püta. ");
INSERT INTO hchNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Tevi pücayüve meutahanicü mütürücaüye quita, piniteya mütinavanicü, me xüca ca'ihüanique mütürücaüye meri. 'Ihüame, pütinavani tita mütixuave quitana. ");
INSERT INTO hchNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","'Icü niuqui caniseüyeni que nemütixecühüave, naime 'axa memüteyurie teüteri, mepüyüvave memüteheuyehüviyarienicü, naime 'axa memutiyuane. ");
INSERT INTO hchNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Masi que mü'ane 'axa 'utaitü misevixima Cacaüyari 'Iyarieya Mütiyupata, mücü hasuacu pücareuyehüviyarieni mücücü. Hesiena masi catiniuhüivani, yuheyemecü 'emuvecü tita 'axa mütiuyuri. ");
INSERT INTO hchNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","'Ipaü niutayüni, müme müpaü memutiyuanecaicü, Cacaüyari müca'itiya ninüca. ");
INSERT INTO hchNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Hicü varusieya 'ivamama yunaitü mecaniu'axüani. Tacua meti'utü metenitanü'airieni yu'aurie me'icuevietü. ");
INSERT INTO hchNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Teüteri yumüiretü menayetecaitüni hamatüana. Müpaü metenitahüave, Neuxei, 'avarusi 'a'ivama mepümasiha'ivava tacuapaitü. ");
INSERT INTO hchNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Mücü müpaü tinivarutahüave, Quehateri nevarusi ne'ivama. ");
INSERT INTO hchNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Varanuxeiyatüyaca 'auriena mematecai, müpaü niutayüni, Camü nevarusi ne'ivama. ");
INSERT INTO hchNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Que mü'ane yamütiyuriene que mütinaque Cacaüyari, mücü canine'ivatüni caninevarusitüni. ");
INSERT INTO hchNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Mericüsü tavari haracuna tesita tiniuti'üquita. Hesüana meniyucuxeürieni yuvaücavatü teüteri. 'Ayumieme canuvasie nacayerüni hapa yecaimesie. Yunaitü teüteri cuiepa püta meniti'ucaitüni ha tesita. ");
INSERT INTO hchNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Mana vaüca tiniva'üquitüacaitüni 'üxasi hepaüsita. Hicü ti'üquitatü müpaü tinivarutahüave, ");
INSERT INTO hchNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Xequene'enanaca. Camüsü, 'ivivame neyani. ");
INSERT INTO hchNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Mericüsü 'imüari 'ivienecacu, hipatü huyeta niucaxürieni. Viquixi meniucaxürieni meniticuani. ");
INSERT INTO hchNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Hipatüta macutetexiyasie niucaxürieni, vaüca müca'acucuieyasie. Cuitüva niutineni, cuie 'emücasuicaicü. ");
INSERT INTO hchNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Hicü quepaucua tau mane nicuini, niutivani mücahananatücateicü. ");
INSERT INTO hchNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Hipatüta xuya 'imüariyarisata niucaxürieni. Xuya niutivere, heimana niuyecüne. 'Imüari cacaniutixuavere. ");
INSERT INTO hchNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Hipatüta cuie 'aixüa müracu'anesie niucaxürieni. 'Utinexüaca 'utivavereca, niutixuavere. Hipatü xei teviyari heimana tamamata nayani, hipatüta haica teviyari ratüa, hipatüta xei sienituyari ratüa. ");
INSERT INTO hchNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Müpaüta niutayüni, Xaütünetü mu'enaxü que'u'ena. ");
INSERT INTO hchNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Hicü yühücüate metitetü, müme 'auriena memütitecai, Tamamata Heimana Yuhutame vahamatü menita'ivaviya 'üxasi hepaüsita que müti'üquitacai. ");
INSERT INTO hchNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Müpaü tinivarutahüave Quesusi, Xeme xecaniupitüarieni tita mütiuti'aviesiecai, xemütemaicacü que müti'ane Cacaüyari ti'aitametücacu. Hipatü tacua memütitei püta, naimecü 'üxasi hepaüsita xeicüa mecaniupitüarieni 'utüarica manuyünepaü, para memüca'ixeiyacü, sepa yemecü memütanenierenique, para 'asimemücatehetimanicü, sepa yemecü memü'enanacaque, ");
INSERT INTO hchNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","capa ta'aurie me'axürienicü Cacaüyarisie meteviyaque, capa meteheuyehüviyarienicü. ");
INSERT INTO hchNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Hicü müpaü tinivacühüaveni, Cari xeme 'icü 'üxasi hepaüsita xepüca'u'enana. Quetütüri xete'enanani naime 'üxasi hepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","'Ivivame ni'ivieneni niuqui. ");
INSERT INTO hchNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Hipatü huyeta miemete mecanihümetüni haque niuqui muca'iviya. Quepaucua memi'enie, cuitüva Cauyumarie ni'axeni. Niuqui netücüni vahesüa muca'iviya. ");
INSERT INTO hchNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Hipatüta yaxeicüa 'imüari mecanihümetüni macutetexiyasie memuca'iviya. Quepaucua niuqui memü'enie, yapaucua menitanaqui'erieni meyutemamavietü. ");
INSERT INTO hchNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Yücümana mepücahananatüca, masi 'emepücateheutere. Quepaucua memü'uximatüarie quepaucua memutaveiyarie 'icü niuqui hepaüsita, yapaucua meniucunuitüarieni. ");
INSERT INTO hchNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Hipatüri 'imüari menihümetüni xuya 'imüariyarisata memuca'iviya. Müme niuqui meniu'enieni, ");
INSERT INTO hchNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","masi mepüyuhiveritüa tita hicü mütimieme meha'erivatü, tuminicü meyutemamavietü mepüteyu'irüviya, hipameta vaücavame menihive'erieca. Mücücü niuqui niupünariexüani naisata. Cacaniutixuavere. ");
INSERT INTO hchNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Hipatü 'imüari mecanihümetüni cuie 'aixüa müracu'anesie memuca'iviya. Niuqui mecaniu'enieni, meniuyuvaüriya me'inaqui'erietü, mecaniutixuxuavereni. Hipatü xei teviyari heimana tamamata menacüne, hipatüta haica teviyari menacüne, hipatüta xei sienituyari menacüne. ");
INSERT INTO hchNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Hicü müpaüta tinivacuxaxatüvacaitüni, Cüxeme que racueiya puticü manunamienicü, 'utatüa mutiquecanicü nusu. Vapai püta caraqueca. ");
INSERT INTO hchNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Tita müti'avie, masiücütü mayanicü xeicüa 'apuve. Tita müranucaname, mühecüasienicü xeicüa 'apuve. ");
INSERT INTO hchNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Xaütünetü mu'enaxü que'u'ena. ");
INSERT INTO hchNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Müpaüta tinivacuxaxatüvacaitüni, Xequeneyucuerivayurieca tita xemüte'enie hepaüsita. Que xemüteva'inüasirie hipame, yaxeicüa xepüte'inüasiyarieni. Hesiena payaxe, xeme xemü'enana xehesie mieme. ");
INSERT INTO hchNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Que mü'ane tixaütü mürexeiya, tavari cuxi pütimiquieni. Que mü'ane tixaütü mücarexeiya, sepa que mütitita müreixeiya pütinavaiyarieni. ");
INSERT INTO hchNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Müpaüta tinivacuxaxatüvacaitüni, 'Ipaü catini'aneni Cacaüyari ti'aitametücacu. Camü tevi 'imüari niuta'ivieni cuiepa. ");
INSERT INTO hchNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Niucahupuni nanucuquecani tucaricü tücaricü. 'Imüari niutineicani niutivavereni, mücü 'asicatimaicacu que mütineica que mütiuvavere. ");
INSERT INTO hchNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Cuie yuxaüta pitinenetüva cüsunuyari meri, 'arique müayeyari, 'arique tacari. ");
INSERT INTO hchNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ticuayu, 'ana türicu xicamete nivaranunü'amücü, 'isanari maye'acü. ");
INSERT INTO hchNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Hicü müpaü niutayüni, Que te'utiyuaneni, titapaü ti'aneni Cacaüyari ti'aitametücacu. Que mü'ane 'üxasi hepaüsita tepihecüatani. ");
INSERT INTO hchNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Musitasa 'imüariyaripaü cani'aneni. Cuiepa muca'iviva, xevitü 'imüari hepaüna 'anetü pücaxuave cuiepa 'esipepetü. ");
INSERT INTO hchNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","'Uca'iviyaca caniutineicani. Tupiriya mutineica, xevitü hepaüna 'anetü pücaxuave 'epapatü. Mamateya neucunexüani 'etütütü. Taheima miemete viquixi mecaniyüvaveni memüyuti'ituatüanicü hesiena 'etüriyarisie. ");
INSERT INTO hchNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Vaüca 'üxasi hepaüsita ticuxatatü 'iyapaü 'aneneme tinivacuxaxatüvacaitüni niuqui, que memüteyüvavecai memi'enienicü. ");
INSERT INTO hchNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","'Üxasi hepaüsita caticuxatatü pücativacuxaxatüvacai. Teyü'üquitüvamete xeicüa me'ayetetü yühücüate tinivarutahecüatüani naime. ");
INSERT INTO hchNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Hicü mücü tucarisie 'ucutaicairecu müpaü tinivarutahüave teyü'üquitüvamete, Hicümüsütari 'anutaüye tepanucüne. ");
INSERT INTO hchNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Müme mevarucu'eirieca teüteri mana memüti'ucai, meneivitüni ca'anatiyeivecacu canuvasie meyetetü. Hipatüta canuvate menecüne hamatüana. ");
INSERT INTO hchNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Hicü yapaucua niucu'eca vaücava. Hamevari neucayeurivecaitüni canuvasie. Nitihüniyarümecaitüni. ");
INSERT INTO hchNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Quesusi canuva cüsapa nacateitüni, muritarisie 'utimu'utü, cusutü. Menenutahütüani müpaü mete'icühüavetü, Ti'üquitame 'acu, pecareu'acuerivayurie temeuyeveximecü. ");
INSERT INTO hchNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Hicü 'anucuqueca nitatieni 'eca. Müpaü tinitahüave haracuna, Cayuvatü 'aixüa, quetineuhayeva. 'Eca neunuani, niucuharuanare yemecü. ");
INSERT INTO hchNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Müpaü tinivarutahüave teyü'üquitüvamete, Titayari xetemama. Quepaütütü yuri xecate'erie. ");
INSERT INTO hchNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Müme masi cuini mieme meniutimamani. Müpaü meteniyutahüave, Quepaicüri pühücü 'icü. 'Asita 'ecatütü haracunatütü meni'enieca que mütiva'aitüa. ");
INSERT INTO hchNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Mericüsü haracuna 'anutaüye meneta'axüani Cataratari vacuiepa. ");
INSERT INTO hchNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Canuvasie 'anatiyacu, yapaucua tevi cacaüyari müca'itiya minücai nenucunaque müquite vateuquiyapa 'ayeneca. ");
INSERT INTO hchNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Mücü tevi vateuquiyapa necateitüni. Teüteri menitexiecaitüni me'ihüanique tepüacü. ");
INSERT INTO hchNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Müixa nicuhüivacaitüni tepüacü yumamatesie yü'ücatesie, peru yumamacü tepüa nanutequecaitüni, yü'ücasie mieme nanuyequesinacaitüni. Xevitü hepaüna pücatürücaüyecai mimaxiutacü. ");
INSERT INTO hchNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Tucaricü tücaricü teuquiyapa nicuyeicacaitüni ya hürisie, cuhivanetü, tetecü yucuxitequetü. ");
INSERT INTO hchNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Hicü Quesusi 'uxeiyaca teva 'uyeicame, hepana niutanausa. Hüxiena niutitunumaqueni ");
INSERT INTO hchNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","carima 'utahivatü, müpaü 'utaitü, Que peneti'uximatüani, Quesusi 'acu Cacaüyari yunaime vaheima macave pemünu'aya. Nepümasivaviri yanetihüritüatü Cacaüyari, penücahürixüa 'axa nesi'uyurieni. Müpaü niutayüni ");
INSERT INTO hchNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Quesusi müpaü mütitahüavixücü, 'Ecü cacaüyari pemüca'itiya, queneuxüna. ");
INSERT INTO hchNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Hicü müpaü tinita'ivaviya, Que petiteva. Mücü müpaü tinitahüave, Cuyaxi Xei Vaxayari netinitevaca, temütamüirecü. ");
INSERT INTO hchNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Vaücava vaüriyarica neyevaviriecaitüni Quesusi mücavaranuyenü'anicü mücü cuiepa. ");
INSERT INTO hchNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Mericüsü yemuritüa tuixuri metenicuacaitüni yuvaücavatü. ");
INSERT INTO hchNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Cacaüyarixi vaüriyarica meneyevaviriecaitüni yamete'icühüavetü, Tuixuri vahesüa quetananunü'a temüvanünicü müme. ");
INSERT INTO hchNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Hicü Quesusi nivarupitüani. Cacaüyarixi memüca'itiyatüca me'ixünaca tevi menivarutiviya tuixuri, 'esivatücacu huta miriyari meyupaümeme. Tuixuri yapaucua meniutanausa 'aita meneucayune. Hapa meneuxürieni, meniucuini haracunasie. ");
INSERT INTO hchNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Hicü tuixuri vahüvemete meniyuta'una. Yametenicuxatacaitüni quiecari 'amüyevasie 'esimüyeyeusie. Teüteri menecüne mecunieretüvetü que mütiuyü. ");
INSERT INTO hchNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Quesusisüa me'u'axüaca menixeiya tevi cacaüyarixi meminücai, Xei Vaxayari memiviyacai. Menixeiya mana 'acaime, heuquemarimacame, 'aixüa re'iyarime. Meniutimamani. ");
INSERT INTO hchNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Hicü müme memunenierixü metenivacuxaxatüvacaitüni que mu'itüarie tevi, que mütiuyü tuixuri vahepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Teüteri menisutüani vaüriyarica me'ipitüatü vacuiepa müyemiecü. ");
INSERT INTO hchNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Hicü canuvasie cayerüximecacu Quesusi, 'iya tevi cacaüyarixi meminücai vaüriyarica canipitüani hamatüana muyeicanicü. ");
INSERT INTO hchNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Quesusiri püca'ipitüa. Müpaü püta tinitahüave, 'Aquie quenemie 'amarema vahesüa. Yaquetinivaretaxatüa vaüca que mütiuyuri Ti'aitame 'ahesie mieme, que matiunenimayataxü. ");
INSERT INTO hchNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Mücü neyani. Tamamata Quiecarite müracutevasie nisutüani ticuxatatü vaüca que mütiuyuri Quesusi hesiena mieme. Yunaitü menihüxiyacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Mericüsü hutarieca 'anutaüye 'anuyacu canuvasie, yuvaücavatü teüteri meniyucuxeürieni 'auriena haracuna tesita 'uvecacu. ");
INSERT INTO hchNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Mericüsü tuqui va'ü xevitü, Cairu titevatü, mana caninuani. Quesusi 'uxeiyaca niutihüximaqueni hüxiena. ");
INSERT INTO hchNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Vaüriyarica canipitüani müpaü 'utaitü, Nenive pemüxime 'ucatütü. Quenemayüamie manayevenicü, 'ayenieretü mayanicü. ");
INSERT INTO hchNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Quesusi 'utümana neyani. Mericüsü meniveiyacaitüni teüteri yumüiretü me'isaipünatü. ");
INSERT INTO hchNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Hicü 'uca 'aniuyeicacaitüni vasata tamamata heimana huta viyari müyuriecai ticuyetü xuriya 'uhanisitüatü. ");
INSERT INTO hchNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Vaüca tini'uxitüariecaitüni yumüireme teyu'uhayemavamete vahesüa 'axetü. Tita mürexeiyacai nai tiniutixütüani tiyutuatü. Yutatexieca, cui niyüanecaitüni masi. ");
INSERT INTO hchNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","'U'enaca que müticuxaxasivacai Quesusi hepaüsita, 'utümana 'umietü teüteri vasata, Quesusi 'ixuriquieya niumayüani, ");
INSERT INTO hchNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","müpaü tiyücühüavetü, 'Ixuriquieya xüca ne'umayüani xeicüa, nenanayevemücü. ");
INSERT INTO hchNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Mericüsü yapaucua xuriya peunua maneicacai. Yuvaiyarisie müpaü tiniuyumani mücü cuiniya meunuacü. ");
INSERT INTO hchNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Hicü Quesusi yu'iyarisie retimaica yütürücariyacü mi'axixücü xeime, yapaucua ta'aurie 'aveca teüteri vasata müpaü niutayüni, Quepai ne'ixuriqui pumayüa. ");
INSERT INTO hchNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Teyü'üquitüvametemama müpaü metenitahüave, Cari pevaxeiyatü teüteri naisata memasisaipünacacu, müya peraine, quepai pünesi'umayüa peraine. ");
INSERT INTO hchNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","'Iya nanieretüyani, que mü'ane miyuri xeiyaque. ");
INSERT INTO hchNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","'Uca 'uyüyüacatü maricacü, timaitü que mütiuyü yuhesie, hüxiena ninuani. Mana 'utihüximaqueca, naime tiniutahecüata que mütiuyü, que mütivaiyacü. ");
INSERT INTO hchNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Hicü müpaü tinitahüave, Nenive, yuri pemütiuta'ericü pepanayeve. 'A'iyarisie peca'uximatüarietü quenemie, 'aixüa pereu'erietü 'uxa'atüni varie yapecatiucacucuinetü. ");
INSERT INTO hchNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Hicü müpaü 'utainecacu cuxi, va'üsüa miemete meniu'axüani müpaü mete'icühüavetü, 'Aniveri pemü. Titayari peti'uximatüa cuxi ti'üquitame. ");
INSERT INTO hchNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Quesusi varu'enieca müpaü mete'icühüaveme, müpaü tinitahüave va'ü, Pepücaheumaca, yuri quetine'erieca xeicüa. ");
INSERT INTO hchNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Hicü teüteri pücavarupitüa memenuveiyacü. Pecuru Cacuvu yu'ivamacame Vanimame xeicüa nivarupitüani. ");
INSERT INTO hchNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Hicü va'ü quie heta'aca meyuxamurietüveme nivaruxeiya me'utisuaname me'utihivame yumüireme. ");
INSERT INTO hchNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Muva heutahaca müpaü tinivarutahüave, Titayari xeteyuxamurie xete'utisuana. Nunusi pücamüqui. Pucusu xeicüa. ");
INSERT INTO hchNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Müme mecaninanaimacaitüni. Hicü yunaime varayenü'aca, nunusi muyecasie nivareutavitüni cuesieya varusieya mümeta hamatüana memu'uvacai. ");
INSERT INTO hchNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Hicü mamayasie tiviereca, müpaü tinitahüave yuniuquicü, Tarita cumi, taniuquicü, 'Üimari 'acu, quenanucuquexi nematinahüaveni. ");
INSERT INTO hchNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Yapaucua nanucuqueni nunusi, niuyeicacaitüni. Tamamata heimana huta viyari nexeiyacaitüni. Cuitüva meniuhüxiyani yemecü. ");
INSERT INTO hchNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Quesusi heiseriemecü yatinivarutahüave xevitü tüma mücaretimanicü que mütiuyü. Müpaüta tinivarutahüave, memüte'iminicü. ");
INSERT INTO hchNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Mericüsü mana neyani, yuquiecari ninuani. Teyü'üquitüvamete meniveiyacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Hicü 'uxipiya tucari 'aye'acu, tuquita nisutüani ti'üquitatü. Müme memi'eniecai meyumüiretü menihüxiyacaitüni müpaü me'utiyuatü, 'Icü meixeiya, haque pemieme. 'Icü que tiupitüarie mütimaivenicü. Que tiupitüarie 'inüari mütürücavi mütiyurienecü. ");
INSERT INTO hchNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","'Icü caticaripiniteru, Mariya münu'aya. Cacuvu Cuse Cura Simuni va'iva catihücü. 'Uva tahesüa mecatetitei 'ivamama 'ucari. Hicü menitixani'erieni. ");
INSERT INTO hchNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Quesusi müpaü tinivarutahüave, Tixaxatame ve'eme cani'erivani naisarie, masi yuquiecarisie xeicüa yumarema vasata yuquita ve'eme püca'eriva. ");
INSERT INTO hchNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Mana pücayüvecai xeime 'inüari mütürücaüye mütiyurienicü. Hipame tecuicuicate xeicüa yuxexuime vahesie 'utimeca nivaranayexürieni. ");
INSERT INTO hchNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Yuri memücate'eriecaicü, ni'iyarixiecaitüni. Hicü quiecarite 'esimüyeyeusie tini'üquitanecaitüni. ");
INSERT INTO hchNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Mericüsü Tamamata Heimana Yuhutame varutacuevieca yu'aurie, nivareutanü'axüani yuhutatame. Heiserie nivarupitüani cacaüyarixi memüca'itiyatüca vahepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Müpaü tinivaruta'aitüani, tixaütü memücate'upiximenicü huyeta, mumuxi xeicüa, 'inüa pücatixaü, cüsiurita pücatixaü, tumini vivurasie yemaneme pücatixaü, ");
INSERT INTO hchNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","memeu'uixüanicü cacai xeicüa, peru huta camixayari memüca'anacatütücanicü tinivaruta'aitüani. ");
INSERT INTO hchNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Müpaüta tinivarutahüave, Haque xeme'axüani quita, muva xequeneyuhayevani 'asita quepaucua xemüyehuque. ");
INSERT INTO hchNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Quiecarisie quiecatari xüca mecaxetanaqui'erieni, xüca mecayuvaüriyani memüxe'enienicü, mana xequenanuyecüni, tumuanari xequeneucasixüa yucacaisie, müpaü xeteyurietü xemütetahecüatanicü vahesie que mürahüiva. 'Icü niuqui caniseüyeni que nemütixecühüave, Surumatari Cumuxatari cuini mieme mepücatatacuritüarieni müme vahepaü quepaucua 'isücame müvatacuevieni, mücü quiecarisie quiecatari que memütetatacuritüarieni. ");
INSERT INTO hchNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Hicüsüari teyü'üquitüvamete meneutayeixüani, müpaü metecuxatatü, teüteri memütehayevacü 'axa memüteyuriecü. ");
INSERT INTO hchNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Yuvaücavame cacaüyarixi menivarayenü'axüani. Tecuicuicateta yuvaücavame haseiti mevarucavirivatü menivaranayexürüvacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Hicü Herurexi müti'aitametücai mana cuiepa niu'ena que mütiuyü. Naisarie tiniutamariva que mü'ane mühücütücai Quesusi. Müpaü meniutiyuanecaitüni, Ti'üyame Vani caniyüaneni. Nanucuquetüarieni 'umüca, 'ayumieme mücü türücariya nicuyuitüvani. ");
INSERT INTO hchNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Hipatüta müpaü meniutiyuanecatüni, 'Eriyaxi canihücütüni, hipatüta, tixaxatame caniyüaneni meripai miemetexi texaxatamete vahepaü 'anetü. ");
INSERT INTO hchNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Herurexi masi 'u'enaca müpaü niutayüni, Süricü Vani canihücütüni nemi'aitaxü mu'uya manutivitequienicü. Mücü nanucuquetüarieni, rainecai. ");
INSERT INTO hchNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Mücü Herurexi meripai nivarutanü'ani memiviyacü Vani. Casariyanata nenutahüani, müpaü mütinaquecaicü Heruriya. Müpaü tiniuyüni Herurexi mitivitücü yu'iva 'üyaya, Heruriya mütitevacai, Herurexi 'ivaya Piripe titevacacu. ");
INSERT INTO hchNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Vani caviyarievetü cuxi müpaü tinicühüavecaitüni Herurexi, Pepücapitüarie pemevitücünicü 'a'iva 'üyaya. ");
INSERT INTO hchNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Heruriya ni'uxive'eriecaitüni. Niyutexienecaitüni 'imiemütü Vani. ");
INSERT INTO hchNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herurexi nimacarücaitüni Vani, 'imaitü tevi mühücütücaicü heiseriemecü yamüticamiecaicü, mupasiecaicü Cacaüyarisie mieme. Ni'üviyacaitüni. 'I'enietü 'asipücatimaicai que mütiyuriemücücai. Siepüre ninaquecaitüni mi'enienicü. ");
INSERT INTO hchNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Mericüsü tucari naye'ani Heruriya Vani ma'ivacü, quepaucua Herurexi 'ixüarari mutavevi matinuivaxü yutucarisie. Te'aitamete, cuyaxi teva'aitüvamete, Carereyatari va'uquiyarima nivaruta'inieni. ");
INSERT INTO hchNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Heruriya nu'aya 'uca vatahaca, tiutineica, nivanaquecaitüni Herurexi mümeta hamatüana memütecuacai yunaitü. Cuiepa ti'aitame müpaü tinitahüave 'üimari, Tita mümatinaque queneneutavaviri, nemümasiminicü. ");
INSERT INTO hchNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Niyühüritüani yarehüavetü, Tita pemünetitavavirieni nepümasimini, sepa cuiepa nemüti'aita hixüata 'arücame pemünetiutavaviri. ");
INSERT INTO hchNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Hicü mana neyani 'üimari. Müpaü tinitahüave yuvarusi, Tita netitavavirieni. Mücü müpaü tinita'eiya, Vani Ti'üyame mu'uya quenetavavirie. ");
INSERT INTO hchNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Mexüiva heutahaca cuiepa ti'aitamesüa, nitavavirieni müpaü 'utaitü, 'Ipaü canetininaqueni ne, hicü cuitü pemünesimini Vani Ti'üyame mu'uya, pateyusie yecaime. ");
INSERT INTO hchNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Cuiepa ti'aitame cui niyuhiveriecaitüni. Muyühüritüacü, teüteri hamatüana memütecuacai vacü, 'ayumieme pücayuvaüriyacai mita'imaiyacü. ");
INSERT INTO hchNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Cuiepa ti'aitame cuya niutanü'ani cuitü, 'ita'aitüaca Vani mu'uya mütuimiecü. ");
INSERT INTO hchNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Mücü heyaca, mu'uya nanutiviteni casariyanata. Pateyusie yecaime ni'atüani. 'Üimari niyetuirieni, 'üimarita yuvarusi niyetuirieni. ");
INSERT INTO hchNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Hicü mete'utamarieca, Vani teyü'üquitüvametemama menecüne, caxarieya menecueni. Teuquiyapa meneiteni. ");
INSERT INTO hchNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Mericüsü nü'arisixi Quesusisüa meniyucuxeürieni, que memüte'uyuri que memüte'üquitacai mete'itaxatüanique. ");
INSERT INTO hchNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","'Iya müpaü tinivarutahüave, Cümüsü taxaüta tepuhu macumavesie, xequene'uxipieca 'esiva. Hipatü yuvaücavatü meni'axecaitüni menecücacaitüni, 'ayumieme tucari mepücahücai ni memütecuanicü müme. ");
INSERT INTO hchNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Hicü canuvasie menecüne macumavesiepai yühücüate. ");
INSERT INTO hchNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Yuvaücavatü menivaruxeiya memecü, menimaicaitüni Quesusi. Naime quiecarisie quiecatari yuvaücavatü yü'ücama menecüne me'unausaxüaximetü. Me'uhaitütüatü meneta'axüani müme meri. ");
INSERT INTO hchNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Hicü 'anatiyeiximetü Quesusi, teüteri nivaruxeiya yumüireme. Nivarutinenimayata, muxasi yühüveme memücahexeiya vahepaü memü'anenecaicü. Mana nisutüani tiva'üquitüatü müiremecü. ");
INSERT INTO hchNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Hicüsüari ya'atevacacu tau, teyü'üquitüvametemama hesüana meniyucuxeürieni müpaü me'utiyuatü, 'Ena canacumaveni, yacanatevani tau. ");
INSERT INTO hchNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Quenivareutanü'axüa 'aurava memütayeixüanicü quiecarite 'esimüyeyeusie 'emüyeyeusie, memüteyutinanairienicü 'icuai. ");
INSERT INTO hchNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Mücü masi müpaü tinivaruta'eiya, Xeme püta xequetenivarumicua. Müme müpaü metenitahüave, Tame tete'inanaiyu pa huta sienituyarisie 'arücame, tetevamini. ");
INSERT INTO hchNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Mücü müpaü tinivarutahüave, Quepaümeme xepexeiya pa. Xequeneuxeiya. Yametetimaica, 'Auxüme payari, huta quesüteyarita, metenitahüave. ");
INSERT INTO hchNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Hicü nivaruta'aitüani yunaime, memücuyaxixüanicü 'üxa macuyürasie yayupapaümetü. ");
INSERT INTO hchNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Mana menicuyaxixüani, xei sienituyari ya huta teviyari heimana tamamata yameyupapaümetü. ");
INSERT INTO hchNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Hicü 'auxüme payari 'anu'üca, huta quesüteyari meta, yuheima heutiniereca, pamüpariyusi 'ipitüaca Cacaüyari, pa niutitara. Nivaru'üitüani teyü'üquitüvamete memüvaminicü. Huta quesüteyari niutimura yunaime vahesie mieme. ");
INSERT INTO hchNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Yunaitü mete'ucuaca meniutihuxani. ");
INSERT INTO hchNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Hicü menicuxeürieni pa yuhayevameyari tamamata heimana huta quirivayari hüpüneme, quesüteyarita 'üarime yuhayevame. ");
INSERT INTO hchNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Müme memüte'ucuai 'uquisi xeicüa 'auxüme miriyari mecaniyupaümecaitüni. ");
INSERT INTO hchNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Hicü nivarutamexüitüani teyü'üquitüvamete memacayaxecü canuvasie, memenuyehaitüiyacü Vesairapai haracuna 'anutaüye, mexi varateutüvacai teüteri. ");
INSERT INTO hchNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Vareutanü'axüaca, hürisie neutiyune yutanenevienique. ");
INSERT INTO hchNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Hicü 'ucutaicairecu, canuva haracuna hixüapa niuyemiecaitüni. Quesusi cuiepa püta niuyeicacaitüni yuxaütame. ");
INSERT INTO hchNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Mana me'uximatüariecame nivaruxeiya me'ivequeme, vahepa maye'ecacaicü. Hicü 'esivatücacu tuxacüta, Quesusi vahepa canamiecaitüni haracuna heima 'umietü. Niuyeyaniquecaitüni. ");
INSERT INTO hchNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Müme me'ixeiyaca haracuna heima 'umiecame, müqui me'erietü, meniutihiva. ");
INSERT INTO hchNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Yunaitü menixeiya, meniyumuinacaitüni. Mücü cuitü nivarutahüave. Müpaü niutayüni, Yu'iyari xequeneucayasa, ne nepüyüane. Xepücaheumamaca. ");
INSERT INTO hchNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Hicü vahesüa ye'acu, canuvasie 'acayerücu, 'eca neunuani. Müme cuini mieme menihüxiyacaitüni meni'iyarixiecaitüni. ");
INSERT INTO hchNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Pa hepaüsita que mütiuyü 'asimepücatehetimaivavecai, masi yu'iyarisie meniupupurucaitüni. ");
INSERT INTO hchNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Hicü 'anutaüye me'anucüneca Quenesareti cuieyarisie meneta'axüani. Mana menecuvieni canuva. ");
INSERT INTO hchNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Canuvasie me'anaticünecu, yapaucua meneitimani quiecatari. ");
INSERT INTO hchNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Naisarie miemete vahesüa meniutanausaxüani. Menisutüani tecuicuicate meva'atüvatü 'itarisie me'aheime haque meme'enana quename mana nua. ");
INSERT INTO hchNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Naisarie que müticuyeicacai, quiecarite 'esimüyeyeusie, 'emüyeyeusie, yeuta, tecuicuicate menicutuarivacaitüni quiecari hixüapa, vaüriyarica me'ipitüatü 'ixuriquieya xeicüa memümayüanicü. Yunaitü memicumaüvacai menanayexürüvecaitüni. ");
INSERT INTO hchNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Mericüsü 'auriena meniyucuxeürieni Pareseusixi, hipatüta 'inüaricü memüte'üquitametetücai Querusareme memeyecü. ");
INSERT INTO hchNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Menivaruxeiya teyü'üquitüvametemama hipame metecuacame vamama ca'itiyacacu mecamaimatücaitü Huriyusixi vayeiyari que müti'ane. Meniniuquixiecaitüni müme. ");
INSERT INTO hchNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Pareseusixi, hipatüta Huriyusixi teüteriyari yunaitü, xüca cuini mieme meca'utimaimani, tixaü mepücatecuaca, yutusima vayeiyarisie yametecahutü. ");
INSERT INTO hchNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Quiecari hixüapa me'ayecücatü xüca mecayuvenani hacü, mepücatecuaca. Vaücava cuxi müireme yeiyari canixuaveni yamemütecahu, tecüxite xarite casute que memüte'itie. ");
INSERT INTO hchNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Hicü Pareseusixi te'üquitameteta müpaü metenita'ivaviya, Titayari yutusima vayeiyarisie yamecatecahu 'ahesüa miemete teyü'üquitüvamete. Mesü vamama ca'itiyacacu mepütecua'a. ");
INSERT INTO hchNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Mücü müpaü tinivaruta'eiya, Cari Quisariyaxi 'aixüa painecai meripai, xexatatü xeme, 'aixüa yuhesie 'axa mü'ane xemü'avietacü. Müpaü catina'uca, 'Icü teüteri yutetacü ve'eme mepünesixata, Que memüte'u'iyari püta teva mepu'uva. ");
INSERT INTO hchNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Xüanacüa xeicüa menenayexeiyani Tita memüte'üquita, teüteri va'aisica mühücücü xeicüa. ");
INSERT INTO hchNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Tita müti'aitacai Cacaüyari xete'uhayevaca, teüteri vayeiyarisie xeteniviyani, tecüxite harevemete que xemütehauxina, tavari hepaüna müireme que xemüteyurie. ");
INSERT INTO hchNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Müpaüta tinivarutahüave, Visi xepüteyurie xeme, xe'ihayevaca tita Cacaüyari müti'aitacai yaxemütecahunicü yuyeiyarisie. ");
INSERT INTO hchNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Muisexi müpaü naineni, Quetinivareuyehüvirieca 'a'uquiyari 'avarusi. Tavari müpaü canaineni, Que mü'ane 'axa mutaineni yu'uquiyari yuvarusi hepaüsita, que'umierieni xei mieme. ");
INSERT INTO hchNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Xemesü püta müpaü xeniutiyuaneni, Tevi xüca müpaü ticühüaveni yu'uquiyari yuvarusi, nepini naime cümana pemüpareviyaniqueyu, mücü Curuvani canihücütüni, taniuquicü, nepimini Cacaüyari, que maine, ");
INSERT INTO hchNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","mücücü xepüca'ipitüaca 'uxa'atüni varie 'asimütiyurienenicü yu'uquiyari yuvarusi vahesie mieme. ");
INSERT INTO hchNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Xecaneyeitüani tita Cacaüyari mütiutayü, yaxetecahutü yuyeiyarisie, que xemütevaretuiri yunivema. Vaücavamecü xepüteyurie 'icüpaü. ");
INSERT INTO hchNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Tavari yu'aurie varutacuevieca teüteri, müpaü tinivarutahüave, Xequenene'enieca yunaitü, xequetenemaivaveni. ");
INSERT INTO hchNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Tevi 'aurie tixaütü pücatixuave hesiena heutahame müyüveni ca'itiyacame meyeitüanicü. Tita taütana müratineica, mücü püta canihücütüni tita ca'itiyacame müreyeitüva tevi. ");
INSERT INTO hchNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Xaütü netü mu'enaxü que'u'ena. ");
INSERT INTO hchNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Hicü teüteri varucu'eiriecu, quita heutahacu, teyü'üquitüvametemama menita'ivaviya 'üxasi hepaüsita que müti'üquitacai. ");
INSERT INTO hchNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Mücü müpaü tinivarutahüave, Cari xemeta 'asixepücatemaivave vahepaü. Xeme müpaü xecatehetimaive, naitü tevi 'aurie mütixuave hesiena heutahame pücayüveni ca'itiyacame meyeitüanicü ");
INSERT INTO hchNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","'iyarieyasie mücaheutahaquecü. Huriepana püta neutahaqueni, nihüani. Müpaü 'utaitü, naime 'icuai 'itiyacame nixatacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Tita tevi taüta müratineica, mücü püta canihücütüni tita ca'itiyacame meyeitüa. ");
INSERT INTO hchNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Teüteri va'iyarisie catinimiemetüni 'axa que memüteyücühüave, que memütevacumaüva que mü'ane mücayü'üya mücayücüna, ");
INSERT INTO hchNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","que memütenavaya, que memüteyumemiva, que memüte'icumaüva xeime 'üyaya, que memüte'ihive'erie tita mücativapini, 'axa que memüte'u'iyari, que memüte'irüma, que memüteyucahive'erie merucuyatüvetü, que memüteyucuasiri, que memüteyusevixima 'axa me'utiyuatü, que memüteyucatave'erie yacü xeicüa que memüteyücühüave. ");
INSERT INTO hchNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Mücü naitü 'axa que memüteyurie, vataüta catinimiemetüni. Mücü ca'itiyacame caneyeitüvani tevi. ");
INSERT INTO hchNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Hicü mana heyaca, Tiru cuieyarisie ninuani, Siruni cuieyarisie. Quita heta'acu, püca'inaquecai Quesusi xevitü mütimariecacü, peru pücayüvecai mana müyuhayevacü camarivatü. ");
INSERT INTO hchNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Mericüsü, 'uca niu'ena hepaüsitana. Cacaüyari müca'itiya ninücaitüni 'iya nu'aya 'ucatüme. 'Uca cuitü hesüana nuaca, hüxiena niutihüximaqueni. ");
INSERT INTO hchNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Cüriyecusixi vaniuqui caniniuquieyatücaitüni, Sirupenisiyasie ninuivametücaitüni. Vaüriyarica nipitüacaitüni meyenü'anicü cacaüyari 'axa mü'ane, mixünacü niveya. ");
INSERT INTO hchNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Quesusi müpaü tinitahüave, Neuyeveca meri türi memütihuxanicü. 'Aixüa püca'ane türi vapa müvanavairienicü, sinurixi müvaminicü. ");
INSERT INTO hchNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Mücü müpaü tinita'eiya, Xasunicü peputaine 'uqui, peru 'asita sinurixi mepiticua'a türi vapa mexatüa mücavivive temüxiquiyari. ");
INSERT INTO hchNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Quesusi müpaü tinitahüave, 'Aixüa pemutayücü, quenemie. Camü cacaüyari 'axa mü'ane 'ari nixüna 'anive. ");
INSERT INTO hchNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Hicü yuquie heta'aca canitaxeiya yunive 'utasie cacaime, cacaüyari 'axa mü'ane 'ixünacu. ");
INSERT INTO hchNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Hicü Tiru cuieyarisie heyeyaca Siruni cuieyarisie niuyeyune. Tamamata Quiecarite müracutevasie 'uyeyaca, Carereya haracunayarisie neta'ani. ");
INSERT INTO hchNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Mana meni'atüirieni tevi mücaheu'enacai münenuriecai. Vaüriyarica menipitüani hesiena mutimenicü. ");
INSERT INTO hchNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yateva heivitüca hücüame teüteri memüca'anu'uva, nacatana neica'uitüani yu'itüvame. 'Uta'aüsicavieca nimayüani nenieya. ");
INSERT INTO hchNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Yuheima heutiniereca na'aivani Quesusi. Yuniuquicü müpaü tinitahüave tevi, Hepata, taniuquicü quevatiyepietücani paine. ");
INSERT INTO hchNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Yapaucua nacateya nivatiyepierixüani nenieya niuxünarieni, heiseriemecü 'utaniutü nayani. ");
INSERT INTO hchNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Hicüsüari nivaruhüritüani xeime memücatehecuxaxatüvanicü, peru que mütivaruhüritüa, müme masi yemecü metenicuxatacaitüni naisarie. ");
INSERT INTO hchNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Vaücavamecü menihüxiyacaitüni teüteri yame'utiyuatü, Naime 'aixüa catiniuyurieni. Müme memücaheu'enanacai meheu'enanacame nivarayeitüvani, müme memücaniuvavecai meniuvaveme nivarayeitüvani. ");
INSERT INTO hchNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Mericüsü 'anapaitütü tavari yumüiretü teüteri meyucuxeüriecu, 'icuai mecahexeiyacacu, teyü'üquitüvamete nivarutacuevieni yu'aurie. Müpaü tinivarutahüave, ");
INSERT INTO hchNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Ne teüteri nepüvanenimaya. Haica tucari mepuyuri nehamatü. 'Icuai mepücahexeiya. ");
INSERT INTO hchNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Meyehacacuitüveme xüca nevareutanü'axüani vaquie, huyeta mepe'amüxüani, hipatü tevapai mecaniquiecataritüni. ");
INSERT INTO hchNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Teyü'üquitüvametemama müpaü metenita'eiya, Haque mieme peyüve pa mütivaruminicü 'ime 'ena macumavesie. ");
INSERT INTO hchNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Mücü müpaü tinivaruta'ivaviya, Quepaümeme xepexeiya pa. 'Atahutame, meniutiyuani. ");
INSERT INTO hchNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Hicü nivaruta'aitüani teüteri cuiepa memücuyaxecü. 'Atahuta payari 'uti'üca, pamüpariyusi 'ipitüaca Cacaüyari, nititara. Teyü'üquitüvamete nivaru'üitüani memüvaminicü. Müme mecanivarumini teüteri. ");
INSERT INTO hchNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Yapaümeme quesüte menivarexeiyacaitünita 'esimemüpepe. Pamüpariyusi 'ipitüaca Cacaüyari, tiniuta'aita quesüte memümiquienicüta. ");
INSERT INTO hchNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Mete'ucuaca meniutihuxani. Yuhayevameyari tarimeyari meniucuxeürieni teyü'üquitüvamete, 'atahuta quirivayari nayani. ");
INSERT INTO hchNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","'Esivatücacu nauca miriyari mecaniyupaümecaitüni teüteri. Hicü nivareutanü'axüani. ");
INSERT INTO hchNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Teyü'üquitüvamete vahamatü yunaitü canuvasie menacayaxe, Rarümanuta müracutevasie menecüne. ");
INSERT INTO hchNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Hicü Pareseusixi meniu'axüani. Menisutüani niuqui mexüatüatü hamatüana, me'ivavirietü 'inüari memüxeiyacü muyuavisie mieme mupitüarie, memi'inüatanicü. ");
INSERT INTO hchNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Mücü yu'iyarisie ha'aivatü müpaü niutayüni, Titayari 'inüari metevava hicü miemetexi. Niuqui caniseüyeni que nemütixecühüave, yemecü 'inüari mepücapitüarieni hicü miemetexi. ");
INSERT INTO hchNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Varucu'eirieca hutarieca nacayerüni canuvasie, 'anutaüyepai neyani. ");
INSERT INTO hchNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Mericüsü teyü'üquitüvamete metenatümaiya pa mema'üniquecai. Xeime hücüa mepexeiyacai pa canuvasie. ");
INSERT INTO hchNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Hicü müpaü tinivaruta'imaiya, Yumarima 'aixüa xequeneyucuerivayurieca tiyucuxanariyame hepaüsita Pareseusixi vahesüa mümieme, Herurexisüa mümieme. ");
INSERT INTO hchNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Müme müpaü meteniyutahüave, Pa temücaheye'üicü müya naineni. ");
INSERT INTO hchNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Quesusi tiutimaica que memüteyücühüavecai müpaü tinivarutahüave, Titayari niuqui xetexüatüa pa xemücahexeiyacü. Xecate'enana, xecatemaivave cuxi. Xe'iyari cuxi tisese'i. ");
INSERT INTO hchNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Xe'uhüxitü xecateheuneniere, xe'unacatü xecateheu'enana, tixaü xecateha'eriva. ");
INSERT INTO hchNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","'Auxüme payari ne'utitaracu 'auxüme miriyari vahesie mieme, quepaüme quirivayari hüpüneme xepucuxeürie muyuhayevaxü. Müme müpaü meniutiyuani, Tamamata heimana hutame. ");
INSERT INTO hchNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Mücü tivarahüave, 'Atahuta payari nauca miriyari vahesie mieme ne'utitaracu, quepaüme quirivayari xepucuxeürie muyuhayevaxü. Müme meniutiyuani, 'Atahutame. ");
INSERT INTO hchNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Müpaü tinivarutahüave, Queri xecatemaivave cuxi. ");
INSERT INTO hchNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Hicü mecaneta'axüani Vesairapai. Teüteri meni'atüirieni 'uqui macüpecai, vaüriyarica me'ipitüatü mimayüanicü. ");
INSERT INTO hchNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Hicü macüpecai mamayasie tiviereca, quiecari tesitapai neihana. He'aüsicamaxüaca hüxitana, hesiena 'utimeca, müpaü tinita'ivaviya, Tixaü pecatixeiya. ");
INSERT INTO hchNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Hicü 'anutaniereca müpaü niutayüni, Teüteri cüyexi nepüvaxeiya yaxeicüa me'aneneme, peru teüteri meneu'uvani. ");
INSERT INTO hchNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Hicü hutarieca hüxitana niutimeni. Tevi nanutaniere, heunieretü nayani. Naime tiniuxeiya que mütivayacü. ");
INSERT INTO hchNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Hicü Quesusi nitanü'ani quiena müpaü titahüaveca, Quiecarisie pepücaheumieni, xeime pepücaraxaxatüvani. ");
INSERT INTO hchNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Hicü Quesusi teyü'üquitüvamete vahamatü yunaitü menecüne. Quiecarite 'esimüyeyeusie meniu'uvacaitüni Sesareya Piripu 'aurie. Mana huyeta me'uyehutü, müpaü tinivaruta'ivaviya teyü'üquitüvamete, Teüteri que me'utiyuane que nemüpaicü ne. ");
INSERT INTO hchNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Mümeri müpaü metenita'eiya, Hipatü müpaü meniutiyuane, Vani Ti'üyame pemühücücü, hipatüta 'Eriyaxi pemühücücü, hipatüta texaxatamete pemüxevitü. ");
INSERT INTO hchNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Hicü müpaü tinivaruta'ivaviya, Xemete que xe'utiyuane que nepüpaicü. Pecuru müpaü tinita'eiya, Que mü'ane heiserie mupitüarie Cürisitutütü, 'ecü pecanihücütüni. ");
INSERT INTO hchNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Hicü nivaruhüritüani 'asimemücatehehüavenicü xeime hepaüsitana. ");
INSERT INTO hchNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Hicüsüari nisutüani tiva'üquitüatü, müpaü 'utaitü, Neuyeveca cuxi ne Yuri Tevi que nemütiteva vaüca nemüticuinecü. Ta'uquiyarima, mara'acate memühüritüarie, mümeta 'inüaricü memüte'üquitamete mecanenitixani'eriecuni. Necanimieriemücü, necananutanierimücü hairieca tucarisie. ");
INSERT INTO hchNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","'Icü niuquieya canihecüacaitüni que mutayü. Hicü Pecuru yateva heivitüca nisutüani 'icu'imaiyatü. ");
INSERT INTO hchNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Quesusi ta'aurie 'aveca, hipame varuxeiyaca teyü'üquitüvamete, nicu'imaiyani Pecuru müpaü 'utaitü, Xaüsie queneuye'a Cauyumarie Nehüxie pepüca'uveni. 'Ecü Cacaüyaripaü pepücare'iyari, teüteri vahepaü xeicüa pepüre'iyari. ");
INSERT INTO hchNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Hicü yu'aurie varutacuevieca teüteri, teyü'üquitüvamete vahamame müpaü tinivarutahüave, Tevi xüca yuvaüriyani nehamatü muyeicanicü, queyuxani'erieca, queyuvaüriyani sepa curuxisie mümierieni, nehesie quetiviyani. ");
INSERT INTO hchNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Que mü'ane müyutavicueisitüamücü caniyutatümaiymücü. Que mü'ane müyutatümaiya nehesie mieme, niuqui 'aixüa manuyünesie mieme, mücü niyutavicueisitüamücü yemecü. ");
INSERT INTO hchNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Tevi nai cuiepa mütixuave xüca ra'ivanique, tita ra'ivaqueyu xüca yutatümaiyanique. ");
INSERT INTO hchNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Tevi titacü tiyutuani yutucari mücanavaiyarienicü. ");
INSERT INTO hchNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Hicü miemetexi hipame va'üitama memüvacumaüva 'axa memüteyuruva vasata 'uyeicatü, que mü'ane münesiteviya miteviya neniuqui, neta Yuri Tevi que nemütiteva necaniteviyacamücü 'iya quepaucua nemunuani ne'uquiyaripaü nemarivetü, netupirisixima memüpasie Cacaüyarisie mieme vahamatü. ");
INSERT INTO hchNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Hicü müpaü tinivarutahüave, Niuqui caniseüyeni que nemütixecühüave, hipatü 'uva memu'uva mepücacuini mexi mecanenierivave que mütiyüni quepaucua Cacaüyari munuani türücaüyemecü ti'aitatü. 'Arique mücaque mecanicuicuni. ");
INSERT INTO hchNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Hicü 'ataxeime tucari 'anucayacu Quesusi nivarevitüni Pecuru Cacuvu Vani yemuri 'amanutitevisie yuhücüame. Mana yücü 'anetü nayeitüarieni vahüxie. ");
INSERT INTO hchNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Quemarieya xavatütü nayani, cui tuxatü 'üvipaü. Cuiepa mütama turiyame müya 'aneneme pücayüve mitiyeitüani. ");
INSERT INTO hchNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Mana 'Eriyaxi Muiseximatü memasiücütü menacüne, Quesusimatü metenicuxatacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Hicü Pecuru müpaü tinitahüave Quesusi, Ti'üquitame 'acu, 'aixüa cani'aneni 'uva temu'uvacü. Camüsü xamaru tepütivevieni haicame, 'ahesie mieme xeime, Muisexisie mieme xeime, 'Eriyaxisie mieme xeime. ");
INSERT INTO hchNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pecuru 'asipücatimaicai que mütayüniquecai, teyü'üquitüvamete cui memeumamacaicü. 'Ayumieme müpaü putayü. ");
INSERT INTO hchNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Hicü haivitüri nuaca nivaru'etüriviya. Xevitü niutaniuni haivitürisie ya'utaitü, 'Icü caninenivetüni neninaqui'erieca, xequene'enieca. ");
INSERT INTO hchNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Yapaucua mehanieretücüneca naisarie, xeime mepüca'uxei yu'aurie 'uveme, Quesusi xeicüa meniuxeiya. ");
INSERT INTO hchNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Hicü yemurisie me'acanexüaximecacu, Quesusi nivaruta'aitüani 'asimemücatehehüavenicü xeime tita memüte'uxei, mexi Yuri Tevi müquite vasata ca'anucuquevecai cuxi, 'ariqueque xeicüa. ");
INSERT INTO hchNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Que mainecai yamecatenicahucaitüni, peru yusata niuqui menixüatüacaitüni tita mütixatacai, manucuqueni müquite vasata que mainecai. ");
INSERT INTO hchNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Hicü müpaü metenita'ivaviya, Müme 'inüaricü memüte'üquitamete, titayari müpaü mete'utiyuane quename heuyevese 'Eriyaxi meri munuani. ");
INSERT INTO hchNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Mücü müpaü tinivaruta'eiya, Neuyeveca 'Eriyaxi meri munuani 'aixüa miyurieni naime. Masi que re'uxa Yuri Tevi hepaüsita, que müreuyevese vaüca müticuinecü müxani'erivanicü. ");
INSERT INTO hchNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Masi ne müpaü netinixecühüaveni, 'Eriyaxi caninuaniri. Yamepiyuri que mütivanaquecai, müpaü que müre'uxa hepaüsitana. ");
INSERT INTO hchNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Hicü mevaranucu'axirümecacu hipame teyü'üquitüvamete, yumüireme teüteri menivaruxeiya teyü'üquitüvamete va'aurie, mümeta 'inüaricü memüte'üquitametetücai menivaruxeiya niuqui mexüatüacame vahamame. ");
INSERT INTO hchNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Hicü teüteri me'ixeiyaca Quesusi, meniuhüxiyani, hepana meniutanausaxüani menitavaüritüani. ");
INSERT INTO hchNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Mücü müpaü tinivaruta'ivaviya müme 'inüaricü memüte'üquitametetücai, Titacü niuqui xetexüatüa vahamatü. ");
INSERT INTO hchNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Tevi xevitü müpaü tinita'eiya, Neuxei ti'üquitame, nenive 'uquitüme nepümasi'atüiri, cacaüyari 'axa mü'ane minü'ücü ca'itaunietü mütaniunicü. ");
INSERT INTO hchNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Sepa haque meita'axiya peiyehüpa, cuaimuxari püvayeneica, yutametecü pütiutaqueve putanaranare. Ne nenivarutavavirieni teyü'üquitüvamete 'ahesüa miemete memenayehüanicü, peru mepüyutatexie. ");
INSERT INTO hchNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Mücü müpaü tinivaruta'eiya, Cari hicü miemete yuri xepücate'erie. Quepaümexa peuyevese xehamatü nemucani. Quepaümexa nepüxenevieca. Xequenavitüqui. ");
INSERT INTO hchNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Hicüsüari meni'atüirieni. Mücü cacaüyari 'ixeiyaca Quesusi, yapaucua nitanüni temaicü. Cuiepa 'ucaveca 'iya, nicurupenecaitüni, cuaimuxari 'anativietü. ");
INSERT INTO hchNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Quesusi müpaü tinita'ivaviya quemasieya, Quepaümexa pi'axiya. Mücü müpaü niutayüni, Nunusiyaripai. ");
INSERT INTO hchNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Müixa taipa hapa neihüpani 'imienique. 'Ecü xüca peyüveni 'asipemütiyurieni, quetanenenimayaca quetaneparevieca. ");
INSERT INTO hchNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Quesusi müpaü tinitahüave, Titasü peraine, xüca neyüveni pemaine. Que mü'ane yuri müti'erie naimecü püyüve. ");
INSERT INTO hchNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Hicü temaicü quemasieya müpaü tiniuhiva, Yuri nepüti'erie 'acu, queneneuparevi yuri xüca necati'erieca. ");
INSERT INTO hchNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Quesusi yumüireme varuxeiyaca me'anausaxüaximeme hepana meyucuxeürienique, nitatieni cacaüyari 'axa mü'ane müpaü ticühüavetü, Neuxei 'ecü cacaüyari pemüca'itaunie mütaniunicü mü'enanicü, ne nematini'aitüaca pemixünacü, tavari pemüca'iviyanicü. ");
INSERT INTO hchNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","'Iya cacaüyari 'utahivaca 'itacasetü carima, nixüna. Müquipaü 'anetü nayani temaicü. 'Ayumieme 'esivatücacu yunaitü müpaü meniutiyuani, Caniumüniri. ");
INSERT INTO hchNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Perusü Quesusi temaicü mamaya 'uviyaca nenucuhana. 'Iya nanucuqueni. ");
INSERT INTO hchNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Hicü quita heutahacu, teyü'üquitüvametemama müpaü menita'ivaviya yuhücüate me'ayetetü, Titayari tetetatatexie tame temayenü'anicü. ");
INSERT INTO hchNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Mücü müpaü tinivarutahüave, Yunenevietü yuhaquietü xeicüa caniyüveni meyenü'anicü 'ipaü 'aneneme. ");
INSERT INTO hchNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Hicü mana menecüne. Carereya cuieyarisie meniuyecüne. Püca'inaquecai xevitü mütitamarienicü. ");
INSERT INTO hchNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Teyü'üquitüvamete tiniva'üquitüacaitüni. Müpaü tinivarutahüave, Ne Yuri Tevi nehücütütü nepüyetuiya teüteri vamamasie. Menenimiecuni. Nemierieme, hairieca tucari 'anucayayu nenanucuquemücü. ");
INSERT INTO hchNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Müme 'icü niuqui mepücahetimaivavecai. Menimamacaitüni me'ita'ivaviyaque. ");
INSERT INTO hchNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Mericüsü Caperünaume meneta'axüani. Quita meheutahaxüacu müpaü tinivaruta'ivaviya, Titacü niuqui xetexüatüacai huyeta. ");
INSERT INTO hchNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Müme cayuvatü xeicüa meniumacaitüni, niuqui memüxüatüacaicü huyeta que mü'ane müme masi müve'emetücaicü. ");
INSERT INTO hchNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Hicü 'ayerüca, Tamamata Heimana Yuhutame varutacuevieca yu'aurie, müpaü tinivacühüaveni, Xevitü xüca ve'eme 'ayeimücüni, neuyeveca yunaime vaparevivame mayuyeitüanicü 'imatüreme mayuyeitüanicü. ");
INSERT INTO hchNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Hicü nunusi 'ahanaca vahixüapa nitaqueni. 'Itituca müpaü tinivarutahüave, ");
INSERT INTO hchNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Que mü'ane xeime mütanaqui'erieni 'ipaü me'aneneme türi nehesüa mümiemecü, mücü canenitanaqui'erimücü ne. Que mü'ane münesitanaqui'erieni ne xeicüa pücanesitanaqui'erieni, masi que mü'ane münesiheyenü'a canitanaqui'erimücüta. ");
INSERT INTO hchNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Vani müpaü tinitahüave, Ti'üquitame, xeime tahesie mücativiya tecaniuxeiya varayenü'avame cacaüyarixi 'axa memü'anene, 'ahesüa niu miemetütü. Mücü tahesie mücativiyacü, 'ayumieme tepinena. ");
INSERT INTO hchNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Quesusi müpaü niutayüni, Xepüca'inenaca. Tevi xüca türücaüyemecü 'inüari tiyurieneni, müpaü 'utaitü quename nehesüa mieme, quetiyüveni cuitüva nehepaüsita 'axa mutaineni. ");
INSERT INTO hchNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Que mü'ane mücatasi'aye'uni, tahesie catiniviyani. ");
INSERT INTO hchNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Que mü'ane xei tecüxiyari müxeharitüani Cürisitusüa miemete xemühümecü, yemecü peixeiyani tita müra'ivaxü. ");
INSERT INTO hchNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Que mü'ane mitiquetamüra xeime 'icü türi yuri memüte'erie, masi 'aixüa püyüniqueyu mata mahete xüca 'ecatütüanique cüipieyasie, haramarasie xüca heucahüiyanique meripai. ");
INSERT INTO hchNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","'Amama xüca masihecahüpani, quenavitequi. Masi 'aixüa püyüniqueyu pemamapurutü xüca peheutahanique tucari maxuavesie, hutame pe'ucamamatü xasi taiyariyarisie pemücaheutahanicü mücatüvesie. ");
INSERT INTO hchNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Mana cuisi müvacüme pücamüni tai pücatüveni. ");
INSERT INTO hchNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","'A'üca xüca masihecahüpani, quenavitequi. Masi 'aixüa püyüniqueyu xüca pe'ücapurutü peheutahanique tucari maxuavesie, hutame pe'uca'ücatü xasi taiyariyarisie pemücauhüiyanicü mücatüvesie. ");
INSERT INTO hchNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Mana cuisi müvacüme pücamüni tai pücatüveni. ");
INSERT INTO hchNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","'Ahüxi xüca masihecahüpani, quenivatitu'i. Masi 'aixüa püyüniqueyu xüca peheutahanique haque Cacaüyari müra'aita tapa pe'acüpetü, xasi taiyariyarisie pemücauhüiyanicü hutame pe'ucahüxitü. ");
INSERT INTO hchNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Mana cuisi müvacüme pücamüni, tai pücatüveni. ");
INSERT INTO hchNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Yunaitü meni'itiyacuni taicü, naitü mavari que müti'itiva 'unacü. ");
INSERT INTO hchNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","'Una 'aixüa cani'aneni, peru xüca hamuritü 'ayanique, titacü ha'usivime xeteheyeitüaniqueyu 'una. 'Una xequenexeiyani yuhesie 'aixüa xeteyuxexeiyatü. ");
INSERT INTO hchNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Mericüsü mana heyeyaca, Cureya cuieyarisie 'uyeyaca, Curutani hatuxame 'anutaüye ninuani. Mana tavari teüteri hesüana meniyuxeüriecaitüni. Que mütiyurienecai, tavari tiniva'üquitüacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Hicü Pareseusixi meniu'axüani, müpaü mete'icu'ivaviyatü me'i'inüatatüvetü, Titauniva 'uqui yü'üya mücu'eirienicü me'utiyuatü. ");
INSERT INTO hchNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Mücü müpaü tinivaruta'eiya, Que tixe'u'aitüa Muisexi. ");
INSERT INTO hchNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Müme müpaü metenitahüave, Muisexi nipitüani tevi xapa mütavevienicü 'eiriya hepaüsita, 'arique micu'eirienicü. ");
INSERT INTO hchNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Quesusi müpaü tinivaruta'eiya, Xe'iyari müsese'icü 'ayumieme 'icü 'aitüarica tinixe'uta'utüirieni. ");
INSERT INTO hchNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Peru matüaripai naitü mütiunetüariepai, Cacaüyari nivarutivevieni 'uquitüme 'ucatüme. ");
INSERT INTO hchNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","'Ayumieme 'uqui niyupatamücü, yuquemasi yuvarusi vahesüa niyeyeimücü, yu'üyasie tiniviyamücü. ");
INSERT INTO hchNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Memüyuhutacai xei vaiyari mecanacünicuni meyuxevitü, cananuyüneni. 'Ayumieme mecaniyuxevini, mepücayuhutari. ");
INSERT INTO hchNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Mericüsü Cacaüyari que mütivaruxeviriyaxü, tevi pücavataxüriexüani. ");
INSERT INTO hchNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Hicü quita me'ayetetü, teyü'üquitüvamete tavari menita'ivaviya mücü hepaüsita que mutayü. ");
INSERT INTO hchNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Quesusi müpaü tinivarutahüave, Que mü'ane 'icu'eirieme yü'üya, xeime püta mütivitüni, mücü nicumaüvani que mü'ane mücayü'üya. ");
INSERT INTO hchNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","'Ucata xüca 'icu'eirieni yücüna, xeime püta xüca 'uticünata, mücü nicumaüvani que mü'ane mücayücüna. ");
INSERT INTO hchNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Hicü hesüana mecaniva'atüvacaitüni türi vahesie mutimenicü, peru teyü'üquitüvamete menivarutate'acaitüni. ");
INSERT INTO hchNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Quesusi varuxeiyaca teyü'üquitüvamete que memüteyuriecai niuyeha'ani. Müpaü tinivarutahüave, Xequenivapitüaca türi nehesüa memü'axenicü. Xepücavanenasitüiyani. Cacaüyari müya me'aneneme catiniva'aitüvametüni. ");
INSERT INTO hchNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Niuqui caniseüyeni que nemütixecühüave, que mü'ane nunusipaü mücayuvaüriya Cacaüyari mütita'aitüanicü yapücatipitüarieni. ");
INSERT INTO hchNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Hicü yumamasie varutitücütü yacaniutainecaitüni para 'aixüa memü'itüarienicü vaheima 'utimeca. ");
INSERT INTO hchNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Mericüsü Quesusi niyemieximecaitüni. Hicü tevi 'unausarümetü hesüana ninuani. Hüxiena niutitunumaqueni müpaü ticu'ivaviyatü, Ti'üquitame 'aixüa pemütiuca'iyari 'acu, tita reuyevese nemütiyurienicü tucari mücaxüve nehesie mütinaquenicü. ");
INSERT INTO hchNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Quesusi müpaü tinita'eiya, Titayari 'aixüa netiuca'iyarime penetixata. Tevi 'aixüa mütiuca'iyari 'apüca'uyeica, Cacaüyari yuxevitü 'aixüa pütiuca'iyari püta. ");
INSERT INTO hchNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","'Ecüsü 'aitüarica pepümate, pepücati'amieni, xeime 'üyaya cünaya pepücacumaüvani, pepücatinavayani, xeimesie pepücarahüpani peti'itavatü, pepücati'acuamanani, 'aquemasi 'avarusi quetinivareuyehüvirieca, que manuyüne. ");
INSERT INTO hchNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","'Iya müpaü tinitahüave, Ti'üquitame, 'icü naimesie yanepüticamie temaicüyaripai. ");
INSERT INTO hchNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Quesusi 'ixeiyatü ninaqui'eriecaitüni. Müpaü tinitahüave, Xevitiüxa xeicüa peuyevese yapemütiyurieni. Quenemie, tita pemürexeiya quetinetua, tuminiyari quenivarumicua puvüresixi. Mücücü muyuavisie vaüca pepeucaqueni. Pevare'üitüame quenaye'a, nehesie quetiniviyani, sepa curuxisie pemumierienique. ");
INSERT INTO hchNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","'Icü niuquicü panutixünetüya. Yuhiverietü caneyani vaüca mürexeiyacaicü. ");
INSERT INTO hchNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Hicü Quesusi yu'aurie hanieretüyaca müpaü tinivarutahüave teyü'üquitüvamete, Canicuaniveni xicusixi memaye'axüanicü Cacaüyari mütiva'aitüvametünicü. ");
INSERT INTO hchNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Teyü'üquitüvamete menihüxiyacaitüni niuquieyacü. Quesusi hutarieca müpaü tinivarutahüave teyü'üquitüvamete, Nenivema, canicuaniveni müme yuri memüte'erie tuminisie memaye'axüanicü Cacaüyari mütiva'aitüvametünicü. ");
INSERT INTO hchNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Sepa mücacuanivenique cameyu manuyehani 'ivipame hüxieyasie, peru siepüre yeme pücuanive xicu maye'anicü Cacaüyari müti'aitüvametünicü. ");
INSERT INTO hchNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Müme masi vaüca menihüxiyacaitüni. Müpaü meteniyücühüavecaitüni, Mericüte, xüca müpaü 'aneni, quepai püyüve mütavicueisitüarienicü. ");
INSERT INTO hchNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Hicü Quesusi vaxeiyatü müpaü niutayüni, Teüteri mepücayüvave memüyutavicueisitüanicü, masi Cacaüyari caniyüveni müvatavicueisitüanicü. Cacaüyari naimecü caniyüveni. ");
INSERT INTO hchNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Hicüsüari Pecuru nisutüani müpaü ticühüavetü, Camüsü tame naime tete'ucu'eirieca 'ahesie tepüteviya. ");
INSERT INTO hchNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Quesusi müpaü niutayüni, Niuqui caniseüyeni que nemütixecühüave, que mü'ane micu'eirie yuqui yu'ivama yuvarusima yuquemasima yü'üitama yunivema yucuie, xüca varucu'eirieni necümana, niuqui 'aixüa manuyünesie mieme, ");
INSERT INTO hchNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","xei sienituyari masi varexeiyatü canayeimücü hicü quite, 'ivamarixi, yuvarusima, yunivema, cuie. 'Uximatüarietü varexeiyatü canayeimücü. Tucari 'umamiesie 'aye'ame, tucari mücaxüve hexeiyatü canayeimücü. ");
INSERT INTO hchNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Peru yuvaücavatü hicü memüve'emete, 'imatüremete mecanacünicuni, 'imatüremete ve'emete mecanacünicunita. ");
INSERT INTO hchNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Mericüsü huyeta meniuhucaitüni Querusareme meutiyune 'utüa, Quesusi nanuhaitüacaitüni. Teyü'üquitüvamete menihüxiyacaitüni. Hipatü memiveiyacai menimamacaitüni. Hicü tavari yateva canivarevitüni Tamamata Heimana Yuhutame. Nisutüani tivacuxaxatüvatü que mü'itüarieniquecai, ");
INSERT INTO hchNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","müpaü 'utaitü, Neuxei, Querusareme teneta'axüacuni. Ne Yuri Tevi que nemütiteva necaniyetuiyamücü mara'acate memühüritüarie vahesüa, müme 'inüaricü memüte'üquitamete vahesüa. Va'isücate menesitahüaveyu, necanimieriemücü, menesiyetuayu teüteri memücahuriyusixi vahesüa. ");
INSERT INTO hchNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Müme mecanenitananaimacuni, yuhaxüama nehesie meniuta'aüsicaviecuni menenicuvaxüacuni, mecanenimiecuni. Peru hairieca tucari 'aye'ayu, necananucuquemücü. ");
INSERT INTO hchNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Hicü Severeu nivemama Cacuvu Vani yuhutatü 'aura me'acüneca, müpaü metenitahüave, Ti'üquitame, pütasinaque tahesie mieme yapemütiyurienicü, que temümatetavavirieni. ");
INSERT INTO hchNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Mücü müpaü tinivaruta'eiya, Que tixenaque yanemütiyurienicü xehesie mieme. ");
INSERT INTO hchNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Müpaü metenita'eiya, Quetaneupitüa 'atemutiyaxecü xevitü 'aserieta xevitüta 'a'utata, quepaucua visi pe'anetü pemayani. ");
INSERT INTO hchNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Hicü Quesusi müpaü tinivarutahüave, 'Asixepücatemate tita xemütecu'ivava. Nehepaü xete'ucacucuinetü xeteyüvave xemenu'ienicü tita nemüranu'ieni ne, nehepaü xeteyüvave xema'ivarienicü tevi que müranucanamiepaü hacü quepaucua muca'üyarie. ");
INSERT INTO hchNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Müme müpaü meniutiyuani, Tecaniyüvaveni. Quesusi müpaü tinivarutahüave, Yemecü tita nemüranu'ieni xecananu'iecuni, nemüca'üyarienipaü xecanica'üyariecuni. ");
INSERT INTO hchNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Peru heiserie nepücahexeiya nemüxepitüanicü ni neserieta ni ne'utata 'axemutiyaxecü. Masi müme vahesie mieme mucuha'arisie xeicüa, müme yametenipitüariecuni. ");
INSERT INTO hchNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Hipatü Tamamata me'u'enanaca que memutiyuanecai, menisutüani mevaxeümatü Cacuvu Vani. ");
INSERT INTO hchNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Quesusi yu'aurie varutacuevieca yunaime, müpaü tinivarutahüave, Xeme müpaü xepütemate, müme nuivarite vasata memümariva mete'aitametetütü meteniva'uxitüaca mete'aitatü. Vavemete heiserie mecanexeiyani vahepaüsita que memüteyurieni. ");
INSERT INTO hchNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Müpaü pücatiyüni xeme xesata. Que mü'ane ve'eme mayaniqueyu xesata, yunaime xeparevivame canayeimücü. ");
INSERT INTO hchNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Que mü'ane mexüacame mayaniqueyu xesata yunaime xehesie mieme vaüriyarica ti'uximayatü canayeimücü. ");
INSERT INTO hchNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Yuri Tevi que nemütiteva, que nemütinua, nemüpareviyanicü nepücanua, masi nevaparevienique püta necaninuani, netucari nemütatuanicü yumüireme vahesie mieme, nevaxünaque. ");
INSERT INTO hchNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Mericüsü Quericu meneta'axüani. Mana meheyehuximecacu 'iya Quesusi, teyü'üquitüvametemama yunaitü, yumüiretü teüteri vahamatü, tevi macüpecai mana niucateitüni huye tesita tivautü, Varütimeyu titevatü, Timeyu nu'ayatütü. ");
INSERT INTO hchNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","'Icü 'u'enaca quename Quesusi Nasaretitanaca 'uyüximecai, nisutüani müpaü tiuhivatü, Quesusi 'acu Raviri pemünu'aya, quenenenenimayaca cuerietü. ");
INSERT INTO hchNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Yumüiretü menitate'acaitüni cayuvatü müticanicü. Mücüsü masi carima müpaü tiniuhivacaitüni, Raviri nu'aya 'acu, quenenenenimayaca cuerietü. ");
INSERT INTO hchNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Quesusi mana 'utaqueca, müpaü niutayüni, 'Aura xequenehüaviyu. Müme mehecüneca 'aura menitahüave macüpecai, müpaü me'utiyuatü, 'A'iyari queneucayesa quenanucuquexi, 'aura pümasitahüave. ");
INSERT INTO hchNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Mücü yü'ücari hevivieca, 'anucuqueca, Quesusisüa neyani. ");
INSERT INTO hchNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Quesusi müpaü tinitahüave, Que matinaque nemümasiyurienicü. Macüpecai müpaü niutayüni, Ti'üquitame nepayeniereniqueyu. ");
INSERT INTO hchNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Quesusi müpaü tinitahüave, Quenemie, yuri pemütiuta'ericü pepanayeve. Yapaucua nanutaniere, huyeta neiveiya Quesusi. ");
INSERT INTO hchNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Mericüsüari Querusaremesie me'axüaximecacu Vetüpaquesie Vetaniyasie, yemuritüa me'u'axüacu Huriva Macu'u müracutevasie, yuhutame nivarutanü'ani teyü'üquitüvamete. ");
INSERT INTO hchNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Müpaü tinivarutahüave, Quiecari 'anutaüye mucumasie xequenehu. Mana xe'anutahaxüaximetü puxu nunusi xecanetaxeiyacuni hacuviecame, tevi hesiena müca'anutiyerüve cuxi. Xequenacuxüna xequenahani. ");
INSERT INTO hchNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Xevitü xüca müpaü tixecu'ivaviyani, Titayari müya xeteyurie 'utaitü xeme müpaü xequenetiyua, Ti'aitame neiyehüaca, cuitüva canenü'amücü. ");
INSERT INTO hchNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Mericüsü mehecüneca caye 'utüa meneitaxeiya puxu nunusi 'acuviecame quitenie 'aurie. Menecuxüna. ");
INSERT INTO hchNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Teüteri mana memüti'ucai hipatü müpaü metenivaruta'ivaviya, Que xeteyurie puxu nunusi xe'acuxünatü. ");
INSERT INTO hchNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Hicü yametenivarutahüave que mütivarutahüavixü Quesusi, teüteri yametenivarupitüani. ");
INSERT INTO hchNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Puxu meneyehana Quesusisüa. Hicü yü'ücari me'enutiveriecu, hesiena nanutiyerüni. ");
INSERT INTO hchNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Yumüiretü me'ivaüritüatü yü'ücari meni'itüaximecaitüni huyeta. Hipatüta cüye xavari me'uhapatü meniyetuaximecaitüni. ");
INSERT INTO hchNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Memuhaitütüacai, memu'imamatücai müpaü meteniuhivacaitüni, Quetaneutavicueisitüa 'aixüa, 'aixüa queticuxaxasivani 'iya hepaüsita, que mü'ane Ti'aitamesüa miemetütü 'amamie hepaüsita, ");
INSERT INTO hchNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","que mü'ane Ti'aitametütü maye'ani tatevari Raviri müti'aitacaipaü, mücü hepaüsita. 'Aixüa cani'aneni que mü'ane taheima macave. ");
INSERT INTO hchNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Mericüsü Quesusi Querusaremesie neutahani, tuqui 'amüpata neutahani. Hanieretüyaca naisarie nivayeyani 'acayunirümecacu. Tamamata Heimana Yuhutame vahamatü yunaitü menecüne Vetaniyapai. ");
INSERT INTO hchNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Mericüsü 'uxa'arieca Vetaniya meheyecüneca Quesusi neuhacamücücaitüni. ");
INSERT INTO hchNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Xapa 'uxeiyaca tevapai xavacame, hepana neyani 'ixeiyaque, siparasü xüca tixaü ticaxeiyaqueyu hesiena. Mana nuaca tixaütü cacatiniucaxeiya, xavari xeicüa, maxuxuavere müca'aye'avecaicü. ");
INSERT INTO hchNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Quesusi hicü müpaü tinitahüave xapa, Hasuacu xevitü tüma 'a'icuaxi pücaticuani. Meni'enieni teyü'üquitüvametemama. ");
INSERT INTO hchNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Hicü Querusareme meneta'axüani. Quesusi tuqui 'amüpa curaruyarita heutahaca, nisutüani varanuyeveveiyatü müme tuqui curaruyarita memütetuacai memütenanecai. Tumini patamete vamexate natixürieni, cucuruxi vatuayamete va'üparite natixürieni. ");
INSERT INTO hchNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Pücavapitüacai tixaü mete'apitü memanuyecücanicü tuquita. ");
INSERT INTO hchNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Mana tini'üquitacaitüni müpaü tivacühüavetü, 'Ipaüri care'uxa, Nequie nenevieri quiyari canimarivacamücü yunaime nuivarite vahesie mieme. Xemesü püta terü xecanayeitüaca haque tenavayamete memüyu'avieta. ");
INSERT INTO hchNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Hicü mara'acate memühüritüariecai, müme 'inüaricü memüte'üquitametetücai vahamatü yunaitü meni'enieni, menimacarücaitüni, teüteri yunaitü memühüxiyacaicü tita müti'üquitacai hepaüsita. 'Ayumieme mara'acate metenicuvautüvecaitüni que memüte'imienique. ");
INSERT INTO hchNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Hicü 'ucutaicairecu quiecarisie nivayeyani. ");
INSERT INTO hchNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Mericüsü ximeri 'ame'uyehuximetü, xapa meniuxeiya vaquime naitü nanayaripaitü. ");
INSERT INTO hchNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pecuru heye'erieca que mütiuyü müpaü tinitahüave Quesusi, Neuxei Ti'üquitame, 'iya xapa pemaxaxatacai 'axa mü'itüarienicü, mücü caniutavaniri. ");
INSERT INTO hchNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Quesusi müpaü tinivacühüaveni, Cacaüyarisie yuri xequetene'erieca. ");
INSERT INTO hchNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Niuqui caniseüyeni que nemütixecühüave, que mü'ane müpaü mütitahüave 'icü yemuri, 'Ena quene'apata, haramarasie queneu'ahüva 'utaitü, xüca yu'iyarisie cayuxamurieca, masi xüca yuri ti'erieca quename müpaü tiyüni que maine, müpaü catiniyümücü hesiena mieme. ");
INSERT INTO hchNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","'Ayumieme nepütixecühüave, naime xemütetavauni xeyunenevietü, yuri xequetene'erieca quename xe'itanaqui'eri. Müpaü yuri xete'eriecacu, yacatiniyümücü xehesie mieme. ");
INSERT INTO hchNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Quepaucua xemüyunenevie, xüca xeimesie xetehüacuni xequeteneuyehüvirieca, mütixeheuyehüvirienicüta xeme xe'uquiyari muyuavisie macave, ta'aurie que xemüte'axürüve. ");
INSERT INTO hchNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Me xüca xecatevareuyehüvirieni teüteri, xe'uquiyari muyuavisie macave pücatixeheuyehüvirieni xeme ta'aurie que xemüte'axürüve. ");
INSERT INTO hchNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Mericüsü tavari meneta'axüani Querusaremesie. Tuqui curaruyarita yeyeicacacu, mara'acate memühüritüariecai, mümeta 'inüaricü memüte'üquitametetücai, 'uquiravesixi vahamatü yunaitü 'aura meniu'axüani. ");
INSERT INTO hchNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Müpaü metenita'ivaviya, Haque pemieme heiserie pemexeiya 'ipaü pemütiyurienecü. Quepaicü heiserie masipitüa 'ipaü pemütiyurienecü. ");
INSERT INTO hchNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Hicü Quesusi müpaü tinivaruta'eiya, Neta nepüxeta'ivaviya xeimecü xeicüa. Xüca xenesita'eiya, neta nepütixetahüave haque memieme heiserie nemexeiya 'ipaü nemütiyurienecü. ");
INSERT INTO hchNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Vani quepaucua müti'üyanecai, taheima timiemetücai 'üyarica, teüteri vahesüa pümiemetücai nusu. Xequeneneuta'eiya. ");
INSERT INTO hchNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Hicü müme niuqui menixüatüacaitüni müpaü me'utiyuatü, Xüca tame müpaü te'utiyuani quename taheima miemetücai, mücü müpaü nitayümücü, Titayari yuri xecate'i'erri. ");
INSERT INTO hchNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Masi xüca müpaü te'utiyuani quename teüteri vahesüa miemetücai, quesü yüni. Müpaü meteniyücühüavecaitüni memüvamacarücaicü teüteri. Müme yunaitü müpaü meniutiyuanecaitüni Vani hepaüsita, quename yuricü tixaxatametücai. ");
INSERT INTO hchNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","'Ayumieme müpaü metenita'eiya Quesusi, 'Asitepücatemate. Quesusita müpaü tinivaruta'eiya, Mericüte, neta 'asinepücatixetahüave haque memieme heiserie nemexeiya 'ipaü nemütiyurienecü. ");
INSERT INTO hchNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Hicüsüari nisutüani tivacuxaxatüvatü, 'üxasi hepaüsita ti'üquitatü. Müpaü niutayüni, Tevi haraveri caniutavevieni. Caxie 'uca'uitüaca, 'utatesaca, vati'ineca caxie püname, 'e'utevime 'utavevieca neniereme capa caxie 'ucacuaiyanicü, te'üviyamete nivaruhüritüani vacuetatüatü, tevapai caneyani. ");
INSERT INTO hchNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Hicü tucari 'aye'acu muticuacuaxesie, ti'uximayatame niutanü'ani te'üviyamete vahesüa, haraverita mieme 'icuaxi yapaümeme mütanaqui'erienicü cusiyarisie mieme. ");
INSERT INTO hchNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Müme masi me'iviyaca, me'icuvaxüaca, yacü xeicüa maveme meneinü'ani. ");
INSERT INTO hchNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Hutariecata xeime niutanü'ani ti'uximayatame vahesüa. Mücü menituaxa mu'uyasie, meninanaimacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Xeimeta 'utanü'acu, menimieni. Yuvaücavame cuxi nivanü'acaitüni. Hipame menivarutivani, hipame menivarucuini. ");
INSERT INTO hchNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Xeime cuxi canexeiyacaitüni yunivetüme münaqui'eriecai. 'Imatürieca nitanü'ani vahesüa, müpaü tiyücühüavetü, Meteneiyehüviriecuni nenive. ");
INSERT INTO hchNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Te'üviyamete masi müpaü meteniyücühüavecaitüni, Camüsü, 'icüsie catininaquimücü cusiyari piniteya. Cümü tepimieni, tahesie püta mütinaquenicü. ");
INSERT INTO hchNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Hicü me'iviyaca menimieni, haraveri varie meneicahüani. ");
INSERT INTO hchNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Mericüte, que tiyurieni haraveri cusiyari. Caninuamücü, te'üviyamete nivatixütüamücü, hipame nivahüritüamücü püta yuharaveri. ");
INSERT INTO hchNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Cari ni 'icü 'utüarica xecatetiterüvavave, Mücü tete memutaxani'eri qui vevivamete, Mücü 'isiquina titutuicame nayani. ");
INSERT INTO hchNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ti'aitame müpaü catiniuyurieni, Canimariveni que temüte'ixeiya. ");
INSERT INTO hchNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Müpaü mepütemaicai müvaxatacaicü 'üxasi hepaüsita ti'üquitatü. 'Ayumieme metenicuvautüvecaitüni que memüte'iviyacü, peru menivamacarücaitüni teüteri. Hicü meheicu'eirieca menecüne. ");
INSERT INTO hchNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Hicüsüari hesüana menivarutanü'ani Pareseusixi hipame, mümeta Herurexisie memüteviyacai hipame, niuquieyasie memiviyacü. ");
INSERT INTO hchNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Mana me'u'axüaca müpaü metenitahüave, Neuxei ti'üquitame, tame tepümasimate 'ecü yuri pemutainecü, pemüca'acuerivayuriecü sepa xevitü que mütiyücühüave, yücü pemücativaxeiyacü teüteri, masi Cacaüyari huyeya hepaüsita pepüti'üquita que mütivaiyacü. Tamüsü, titauniva mütiyutuanicü Sesaxi cuviyexunuyasüa mieme, pücatauniva nusu. ");
INSERT INTO hchNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Tepi'üitüani, tepüca'i'üitüani nusu. Mücü yatimaitü yuhesie 'axa mü'ane que memüte'avietacai, müpaü tinivarutahüave, Titayari xenete'inüatatüve. Tuminiyari xequena'üi nemixeiyacü xeime. ");
INSERT INTO hchNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Müme meni'atüirieni xeime. Müpaü tinivarutahüave, Quepai ramu'u püra'uxa, quepai püra'utüarica 'icü. Sesaxi mu'uya canihücütüni, 'utüaricayata, metenita'eiya. ");
INSERT INTO hchNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Quesusi müpaü tinivarutahüave, Tita Sesaxisüa mütimieme, Sesaxi xequetenapinirieca. Tita Cacaüyarisüa mütimieme, Cacaüyari xequetenapinirieca. Meniuhüxiyani que mutayü. ");
INSERT INTO hchNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Hicü hesüana meniu'axüani Saruseusixi. Müme yameniutiyuanecaitüni quename müquite meca'anutaneniereni. ");
INSERT INTO hchNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Hicü müpaü metenita'ivaviya, Neuxei ti'üquitame, Muisexi 'ipaü catiniu'utüani tahesie mieme, tevi xüca masicaya 'umüni, xüca cueya 'uyuhayeva türi cavarexeiyatü, mücü tevi canitivitümücü yucue, türi nivativevimücü masicaya nivemama memütaterüvarienicü. ");
INSERT INTO hchNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Mericüsü 'atahutatü 'amenititecaitüni 'ivamarixi. Vamasi 'uca niutivitüni, niumüni türi cavaruhayevaca. ");
INSERT INTO hchNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Mutaya nitivitünita, mücüta tiumü türi cavaruhayevaca. 'Iyata mutaya yunaitüta yaxeicüa menitivitüni. ");
INSERT INTO hchNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","'Atahutatü yunaitü 'ivamarixi türi mepücavaruhayevaxü. Yunaitü me'ucuicu, 'ucata tiumü. ");
INSERT INTO hchNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Mericüte, quepaucua xeniu memanucu'uni, 'atahutatü memitivitü quepai ra'üya pürayani. ");
INSERT INTO hchNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Hicü Quesusi müpaü tinivaruta'eiya, Camü, 'ayumieme xecaniyuyarieca, 'utüaricayari xemücamatecü, que mütitürücaüye Cacaüyari 'asixemücatematecü. ");
INSERT INTO hchNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Quepaucua müquite memanucu'uni, mepücaneneüqueni mepücaviquieca. Cacaüyari tupirisiximama taheima miemete vahepaü mecaniyüacacuni püta. ");
INSERT INTO hchNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Müquite vahepaüsita que müre'uxa que memüte'anucu'uni, cari xecate'ititerüvavave Muisexi xapayasie haque tupiriya mexata, Cacaüyari que mütitahüavixü, 'Apurahami, 'Isahaqui, Cacuvu necanivacacaüyaritüni ne, cananuyüneni. ");
INSERT INTO hchNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","'Ayumieme müquite pücavaxata quename vacacaüyari haitü. Memayeyuyuri püta vacacaüyari caniyuxatani, sepa memucui. Cuini mieme xepüyuyari. ");
INSERT INTO hchNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Hicü xevitü 'inüaricü müti'üquitametücai 'aura 'ayaca, varu'enieca niuqui mexüatüacame, tinimaicaitüni 'aixüa mütivata'eiyacü, müpaü tinita'ivaviya Quesusi, Que mü'ane 'aitüarica masi püve'eme naime 'aitüaricasie mieme. ");
INSERT INTO hchNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Quesusi müpaü tinita'eiya, 'Ipaü cananuyüneni 'aitüarica müve'eme, Xequeneu'enana 'Ixaherisixi. Ti'aitame mütacacaüyari, 'iya Ti'aitame caniyuxevini. ");
INSERT INTO hchNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Peninaqui'eriecamücü Ti'aitame mü'acacaüyari naime que pemüre'iyaricü, naime que pemüti'amatecü, naime que pemüticu'erivacü, naime 'atürücariyacü. 'Icü 'aitüarica masi canive'emetüni. ");
INSERT INTO hchNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","'Esivatücacu hepaüna müve'emecü 'ipaü cananuyüneni, Peninaqui'eriecamücü 'ahepaü tevi que pemüti'anaqui'eriepaü. Xevitü 'aitüarica pücaxuave masi ve'emetütü, 'icü hutatü xeicüa. ");
INSERT INTO hchNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Hicü 'iya ti'üquitame müpaü tinitahüave, 'Aixüa pü'ane ti'üquitame. Yuri pecaniutaineni, Cacaüyari caniyuxevini, xevitiüxa 'apüca'uyeica hepaüna 'anetü, que pemaine. ");
INSERT INTO hchNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Xüca tevi 'inaqui'erieca naime que müre'iyaricü, naime que mütimaivecü naime yutürücariyacü, xüca yuhepaü tevi naqui'erieca que mütiyunaqui'eriepaü, yemecü 'aixüa caniyümücü, que mücatiyüni naitü mavari mütaiya mücui'iva. ");
INSERT INTO hchNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Hicü Quesusi 'i'enieca timaivemepaü que mütita'ei müpaü tinitahüave, Teva pepüca'uyeica pemaye'anicü, Cacaüyari mati'aitüvametütü mayanicü. Hipatü tavari mepücayuvaüriyacai tixaütü memüte'ita'ivaviyacü. ");
INSERT INTO hchNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Quesusi müpaü niutayüni tuquita ti'üquitatü, Titayari müpaü mete'utiyuane müme 'inüaricü memüte'üquitamete, quename vaniu Cürisitu Raviri xiüyarieya hücütüni. ");
INSERT INTO hchNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Mücü Raviritütü müpaü niutayüni 'Iyari Mütiyupata 'icuyuitüvacacu, Ti'aitame müpaü tinitahüave que mü'ane müneti'aitüva, Neserieta quenacani 'Aquetatüa mexi nevarahapani müme memümasi'aca'unie. ");
INSERT INTO hchNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Tamüsü Raviri Neti'aitüvame tinitaterüva. Mericüte, xüca Cürisitu tita'aitüani Raviri, que timasiücüni quename xiüyarieyatüni. Teüteri meyutemamavietü meni'eniecaitüni yuvaücavatü. ");
INSERT INTO hchNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ti'üquitatü müpaü tinivarutahüave, Xequeneyucuerivayurieca müme 'inüaricü memüte'üquitamete vahepaüsita, müme müvanaque memeu'uvanicü 'etütüme me'anacatütü, quiecari hixüapa vaürisica memüpitüarienicü, ");
INSERT INTO hchNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","teüteri vahüxie memayaxecü tuquita, quiecame 'aurie memayaxecü 'ixüararipa, müme vahepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Viyurasixi vapini mepütevarutixütüiri, 'emeteheutevitü neneviericü mücamasiücünicü que memüteyurie. Vahesie masi yemecü tinahüivani. ");
INSERT INTO hchNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Hicü tumini macaxürüva cacuniyari hüxie niutayerüni Quesusi. Teüteri nivaxeiyacaitüni tumini me'acaxürüvame cacunisie. Xicusixi yumüiretü vaüca meneicaxürüvacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Mericüsü xevitü viyura caninuani tuminicü mavetü, hutame neucaxürieni xei senitavuyari müraye'atüca 'axeicüa. ");
INSERT INTO hchNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Hicü yu'aurie varutacuevieca teyü'üquitüvamete, müpaü tinivarutahüave Quesusi, Niuqui caniseüyeni que nemütixecühüave, 'icü viyura tumini mavetü cacunisie neicaxürieni vaücava, müme yunaitü memeicaxürüva 'esiva xeicüa meneicaxürieni. ");
INSERT INTO hchNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Yunaitü müme meneicaxürieni tita müranuyuhayeva, peru 'iya yuhaveri mieme neucaxürieni, naime cümana mütiyumicuacai. ");
INSERT INTO hchNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Hicü tuquita 'ayenecacu, teyü'üquitüvametemama xevitü müpaü tinitahüave, Neuxei, ti'üquitame, tetexi que timamarivave quite. ");
INSERT INTO hchNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Quesusi müpaü tinitahüave, 'Icü qui petixeiya 'amüpapa. Tete pücahayevarieni yuheima 'atetü. Naitü canica'unariemücü. ");
INSERT INTO hchNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Hicü Huriva Macu'u yemurisie 'ucaicu tuqui 'amüpa hüxie, Pecuru Cacuvu Vani 'Atürexi yühücüate müpaü metenita'ivaviya, ");
INSERT INTO hchNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Quetatineutaxatüa quepaucua müpaü pütiyüni que pemaine. Tita ti'inüariyaritüni quepaucua maye'aximeni 'icü naitü. ");
INSERT INTO hchNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Quesusi nisutüani müpaü tivacuxaxatüvatü, Yumarima 'aixüa, xevitü catixe'u'irüviya. ");
INSERT INTO hchNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Yumüiretü mecani'axüacuni müpaü me'utiyuatü quename nehesüa memiemete, Ne Cürisitu necanihücütüni, me'utiyuatü. Yumüireme menivacuamanacuni. ");
INSERT INTO hchNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Xeme quepaucua xemüva'enieni cuyaxi meyucuitüveme, quepaucua xemi'enieni cuya niuqui, xepücayuxamurieca. Neuyeveca müpaü mütiyünicü, peru 'acuxi naitü pücatapare mücücü. ");
INSERT INTO hchNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Nuivarite mecaniyeha'acuni mevacuicutü hipame nuivarite, xexuime cuiesie quiecatari mecaniyeha'acuni hipame cuiesie miemete mevacuicutü. Naisarie cuie canitayuamücü, haca canitavemücü. Peru que mütiyüni, mücücü canisutüariemücü xeicüa cuiniya. ");
INSERT INTO hchNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Xemesü xequeneyucuerivayurieca. Mecanixeyetuacuni 'isücate vahesüa. Tuquiteta xecanitiveiyacuni. Cuvexunarurisixi te'aitamete vahüxie xecaniti'ivaviyariecuni nehesüa xemümiemetecü, xemüvahecüatüacacü que xemüte'unenierixü. ");
INSERT INTO hchNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Neuyeveca 'icü niuqui 'aixüa manuyüne memütaxatüarienicü yunaitü nuivarite meri. ");
INSERT INTO hchNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Quepaucua memüxetiviya memüxe'anuhapani 'isücate vahüxie, xeta'icuevatü xepücayu'iyaritüaca que xemutiyuaneni. Masi que xemütepitüarieni 'ana, müpaü xeputiyuaneni. Xeme xepücahüme que mü'ane yamütayüni, 'Iyari Mütiyupata püta canihücütüni que mü'ane yamütayüni. ");
INSERT INTO hchNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ra'iva pürayetuani mümierienicü, quemasieya yunive niyetuamücü, türi meniyeha'acuni yu'uquiyarima vahepaüsita, metenita'aitacuni memücui'ivanicü. ");
INSERT INTO hchNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Yunaitü menixe'uxive'eriecacuni nehesüa xemümiemetecü. Que mü'ane tiuca'enivatü 'amuyeicani quepaucua mümünique, mücü nitavicueisitüariemücü. ");
INSERT INTO hchNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Xeme 'uxa'atüni xenixeiyacuni mücü tevi müvaseviximani müracumaveriyani mana 'utiveme haque 'aixüa müca'ane mutivenicü, que mainecai tixaxatame Tanieri. Titerüvame quetimaiveni tita mütixata. 'Ana hürisie mequeyuta'una müme Cureya cuieyarisie meme'uvani. ");
INSERT INTO hchNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Que mü'ane caxetunisie macaca 'uxipietü, mücü 'anacayame yuquita pücaheutahani yupini tivayepinique. ");
INSERT INTO hchNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Que mü'ane yeuta meyeicani, yu'utüma pücanuani yu'ücari tivayehurienique. ");
INSERT INTO hchNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Xüa 'ui müme memuhuca müme memütesisitüa 'ana. ");
INSERT INTO hchNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Xequeneyunenevieca müpaü catiuyünicü muhaütüsie. ");
INSERT INTO hchNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","'Iya tucarisie 'uximatüarica canitixuaverimücü cuini mieme, matüaripai quepaucua Cacaüyari nai mütiunetüa hicüque que mücatixuavecai, tavari que mücatixuavenita. ");
INSERT INTO hchNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ti'aitame xüca 'esicareiteritüanique 'uximatüarica, ni xevitü tevi pücatavicueniqueyu. Mesü müme müvaranuyexei vacü 'esipüreiteritüa. ");
INSERT INTO hchNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","'Anari xevitü xüca müpaü tixecühüaveni, Camü, 'ena caniuyeicani Cürisitu, Camü mana, xüca haineni nusu, yuri xepücate'i'eririeca que mü'ane müya mutaineni. ");
INSERT INTO hchNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Yacü Cürisitusixi, yacü texaxatamete mecani'axüacuni. 'Inüari mecanitiveviecuni mamarivaveme mevacuamanaque 'asita müme memanuyexeiyarie xüca meyüvavenique. ");
INSERT INTO hchNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Xemesü xequeneuyü'üviya. Nai nepütixe'utaxatüa yacatiyüvecacu cuxi. ");
INSERT INTO hchNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","'Ana 'iya 'uximatüarica heunuayu, tau caniyürimücü, mesa cacanihecüarivimücü, ");
INSERT INTO hchNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","xuravesixi mecanicaxüricuni muyuavisie miemete, müme türücariya memexeiya muyuavisie mecaniyuitüariecuni. ");
INSERT INTO hchNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","'Ana Yuri Tevi que nemütiteva mecanenixeiyacuni haisata ne'acamiecame, cui netürücaüyetü, nexavatütü. ");
INSERT INTO hchNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","'Anarita netupirisixima nenivatanü'axüamücü, müme nemüvaranuyexei nenivacuxeürimücü, taserieta ta'utata tahixüata tasutüapa memeu'uva, naisarie cuie manuniere muyuavitüa. ");
INSERT INTO hchNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Narüca xeha'erivatü müpaü xequetenemaica, quepaucua xavari mücavivieni xücari yürani, xüca mamateya cuneicani, tasüari 'auracacutüca. ");
INSERT INTO hchNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Xemeta yaxeicüa, quepaucua xemixeiya 'ipaü tiyüaneme, yaxequetenemaica quename hehurari, quitenie müta'aximenipaü. ");
INSERT INTO hchNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Niuqui caniseüyeni que nemütixecühüave, hicü miemetexi mepücatixüni, mexi 'icü naitü ca'aye'ave. ");
INSERT INTO hchNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Cuie muyuavi naitü canitixümücü, peru ne neniuqui pücaxüni. ");
INSERT INTO hchNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Tevi 'asipücatimate quepaucua maye'ani 'iya tucari, taheima miemete tupirisixita 'asimepücatemate, neta 'asinepücatimate Cacaüyari Nu'aya nehücütütü. Ne'uquiyari xeicüa catinimaica. ");
INSERT INTO hchNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Yumarima, xequenayeneniereni xequeneyunenevieca, 'asixemücatematecü quepaucua maye'ani. ");
INSERT INTO hchNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Müpaü cani'aneni que mütiuyü, tevi tevapai metüa, yuqui mucu'eiri. Te'uximayatamete nivaruhüritüani yuxexuime, vamayüitaricü vahüritüatü. Quiteni tihüveme tiuta'aitüani mayenierenicü. ");
INSERT INTO hchNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Xemeta 'ayumieme xequenayeneniereni, 'asixemücatematecü quepaucua munuani qui cusiyari, ya taicai ya tücari hixüapa, ya vacana tahivayu, ya yuimuana. ");
INSERT INTO hchNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Xequenayeneniereni capa xecusume xe'utaxeiyacü yapaucua nuame. ");
INSERT INTO hchNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Que nemütixecühüave xeme, yunaime netinivacühüaveni vahesie mütinaquecü, xequenayeneniereni. ");
INSERT INTO hchNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Mericüsü huta tucari neuyevecaitüni 'ixüarari maye'anicü quepaucua mema'erivacai Cacaüyari que mütivaruhayevaxü vateüterima, quepaucua pa cacuxaxanime memücuacai. Mara'acate memühüritüariecai müme 'inüaricü memüte'üquitametetücai vahamatü metenicuvautüvecaitüni que memüte'iviyacü me'icuamanatü, que memüte'imienicü. ");
INSERT INTO hchNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Müpaü meteniyücühüavecaitüni, Mecuxi 'ixüaramete vahüxie 'asitemücateyurieni, teüteri capa meyutaxamurienicü. ");
INSERT INTO hchNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Mericüsü Vetaniyasie 'uyeicatü tiniucuani Simunisüa que mü'ane cuiniyacü müca'itiyacaisüa. Hicü 'uca mana caninuani tete visi mü'ane puteyayari 'ahanatü, visi mu'üa 'aye'üneme narüru titevacame canücame cui müraye'arücai. Puteya cüipieya 'anumuraca, Quesusi mu'uyasie neitiyeurieni visi mu'üa. ");
INSERT INTO hchNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Hipatü meha'atü müpaü meteniyücühüavecaitüni, Titayaricuta yacü xeicüa reiyehüa 'icü visi mu'üa. ");
INSERT INTO hchNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Püyüveniqueyu mituanicü 'icü visi mu'üa haica sienituyari 'inüariyaricü heimana yapaümemecü, tuminiyari memümiquienicü puvüresixi. Menitiecucaitüni 'uca. ");
INSERT INTO hchNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Peru Quesusi müpaü niutayüni, Xequeneuhayeva, titayari xete'i'uximatüa. 'Aixüa catiniuyurieni nehesie mieme. ");
INSERT INTO hchNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","'Uxa'atüni varie 'amecaniu'uvacuni puvüresixi xehesüa. Quepaucua xemüyuvaüriya xecaniyüvaveni 'aixüa xemüvayurienicü, nesiere xehesüa 'anepüca'uyeicani 'uxa'atüni varie. ");
INSERT INTO hchNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","'Icü que mütiyüvecai, müpaü catiniuyurieni. Ne'ayeyuricacu cuxi, caneniucavirieni nemücateuquienicü. ");
INSERT INTO hchNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Niuqui caniseüyeni que nemütixecühüave, sepanetü haque mecuxaxasivani 'icü niuqui 'aixüa manuyüne hepaüsita naisarie cuiepa, 'icü 'uca que mütiuyuri canita'üxasisiemücü ma'erivanicü. ");
INSERT INTO hchNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Hicü Cura 'Isicariutitanaca, Tamamata Heimana Yuhutame müxevitütücai, caneyani mara'acate memühüritüariecai vahesüa 'iyetuanique. ");
INSERT INTO hchNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Müme me'i'enieca meniyutemamaviecaitüni. Müpaü metenitahüave tumini memi'üitüaniquecaicü. Mücü tinicuvaunecaitüni quepaucua 'aixüa mütiyüniquecai miyetuanicü. ");
INSERT INTO hchNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Mericüsü Pa Mücacuxaxani 'ixüarariyari sutüariecacu, quepaucua memüvacuicai muxasi türixi meteha'erivatü Cacaüyari que mütivaruhayevaxü vateüterima, teyü'üquitüvametemama müpaü metenitahüave, Haque masihenaque temuhucü 'aixüa temeiyurienicü, 'ixüarari 'icuaiyari pemürecuanicü. ");
INSERT INTO hchNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Hicü yuhutame teyü'üquitüvamete nivarutanü'ani müpaü tivarutahüaveca, Quiecarisie xequenehu. 'Uqui mana püxe'anucunaque ye'ü 'ahanatü hecuhanüca. Mücü xequenanuveiya. ");
INSERT INTO hchNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Haque meuhani, müpaü xequetenetahüavi quiecame, Ti'üquitame müpaü paine, Hipatüte haqueva qui müme nemütiva'üquitüa nehamatü 'ixüarari 'icuaiyari temücuanicü. ");
INSERT INTO hchNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Mücü qui taüta xe'utivitüme püxexeisitüani hipame qui 'emüyeva naitü 'ureyepicame 'aixüa tiha'aritüariecame. Muva 'aixüa xequeteneyuri tahesie mieme. ");
INSERT INTO hchNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Hicü mana menecüne teyü'üquitüvamete. Quiecarisie meneta'axüani. Que mütivarutahüavixü meteniutaxeiya. Muva 'ixüarari 'icuaiyari 'aixüa meteniuyurieni para memüteha'erivanicü Cacaüyari que mütivaruhayevaxü vateüterima. ");
INSERT INTO hchNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Mericüsü 'ucutaicairecu, Quesusi, Tamamata Heimana Yuhutame vahamatü yunaitü mecaniu'axüani. ");
INSERT INTO hchNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","'Ame'atecacu metecuacacu, Quesusi müpaü niutayüni, Niuqui caniseüyeni que nemütixecühüave, xevitü xeme nehamatü müticua'a pünesiyetuani. ");
INSERT INTO hchNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Hicü meniyuhiverietücateitüni. Müpaü metenita'ivaviya yuxexuitü, Ne netihücü. ");
INSERT INTO hchNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Mücü müpaü tinivaruta'eiya, Xeme Tamamata Heimana Yuhutatü, xevitü canihücütüni que mü'ane pa manati'üve nehamatü 'icü xacüsie. ");
INSERT INTO hchNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Yuri Tevi que nemütiteva, nepüyemie nemümierienicü que müre'uxa nehepaüsita, perusü xüa 'ui que mü'ane münesiyetuani Yuri Tevi nehücütüme. 'Aixüa cani'aneniqueyu masi xüca ca'utinuivaque 'iya. ");
INSERT INTO hchNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Hicü metecuacacu, Quesusi pa 'anucü'üca 'aixüa 'utayüca Cacaüyari hepaüsita pa hepaüsita, 'ititaraca pa, nivarumini, müpaü 'utaitü, Xequenanu'üi, 'icü caninevaiyaritüni. ");
INSERT INTO hchNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Tecüxi 'anucuhanaca pamüpariyusi 'ipitüaca Cacaüyari nivaru'itüani. Yunaitü menenuti'iexüani mücüsie. ");
INSERT INTO hchNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Müpaü tinivarutahüave, 'Icü caninexuriyatüni, türatu mühecua caniseiriyamücü. Yumüireme vahesie mieme nitiyeuriyamücü. ");
INSERT INTO hchNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Niuqui caniseüyeni que nemütixecühüave, tavari caxie hayari nepüca'anu'ieni mexi ca'aye'ave quepaucua hecuamecü nemenu'ieni haque Cacaüyari müra'aita. ");
INSERT INTO hchNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Hicü cuicari Cacaüyari hepaüsita me'utacuicaca, menecüne Huriva Macu'u yemurisie. ");
INSERT INTO hchNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Quesusi müpaü tinivarutahüave, Xeme yunaitü hicü tücaricü xenicunuitüariecuni necümana, que müre'uxa, Muxasi vahüveme necanimiemücü, muxasi menitaxüriexüacuni. ");
INSERT INTO hchNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Nesü nemierieme ne'anutaniereme necanixe'anucuhaitüiyamücü Carereyasiepai. ");
INSERT INTO hchNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Hicü Pecuru müpaü tinitahüave, Ne sepanetü yunaitü memücunuitüarienique, nepücacunuani ne. ");
INSERT INTO hchNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Quesusi müpaü tinitahüave, Niuqui caniseüyeni que nematicühüave, hicü yüvicüta vacana hutacüa catahivavecacu cuxi, 'ecü haicacüa pepü'acu'imavani, quename pecanesimate pe'utaitü. ");
INSERT INTO hchNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Mücü cuini mieme masi müpaü putayü, Sepanetü 'ahamatü nemumierienique, yanepücatinecu'imavani. Yunaitü yaxeicüa meniutiyuanecaitüni. ");
INSERT INTO hchNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Hicü Quetisemani müracutevasie menecüne. Müpaü tinivarutahüave teyü'üquitüvamete, 'Uva xequenateni mexi nenenenevie. ");
INSERT INTO hchNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Pecuru, Vani, Cacuvu nivarevitüni yateva. Mana cuini mieme 'uta'aivatü yuhiverietü nayani. ");
INSERT INTO hchNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Müpaü tinivarutahüave, Ne'iyarisie cuini mieme neninehiverieca, mücücü nemüximetü tüma. 'Uva xequeneyuhayeva xequenetaneniereni. ");
INSERT INTO hchNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Hicü 'esiva yateva niuyani. 'Utihüximaqueca cuiepa, niyutanenevieni xüca tüma xüa tiyüvenique müca'aye'aniqueyu que mütiyüniquecai. ");
INSERT INTO hchNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Müpaü niutayüni, Ne'uquiyari 'acu, naimecü pepüyüve 'ecü. 'Icü tecüxi quenanuhani cuerietü hivericacü yanemüca'itüarienicü, mesü que münetinaque ne pücatixaü, 'ecüsü que mümatinaque püta quetiuyüni. ");
INSERT INTO hchNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Hicü muva ninuani, nivarutaxeiya mecusume. Müpaü tinitahüave Pecuru, Simuni 'acu, peticusu. Pecatiyüvecai pemütanierenicü xei hurayari. ");
INSERT INTO hchNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Xequenetaneniereni, xequeneyunenevieca capa 'axa xete'uyurienicü xe'uta'inüasieme. Xe'iyari püyuvaüriya, xevaiyari püta puverarani. ");
INSERT INTO hchNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Hicü hutarieca heyaca niyutanenevieni yaxeicüa 'utaitü. ");
INSERT INTO hchNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Hutarieca muva nuaca nivarutaxeiya tavari mecusume memücusimarietücateicü. 'Asimepücatematecai que memüte'ita'eiyaquecai. ");
INSERT INTO hchNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Hicü hairieca muva nuaca müpaü tinivarutahüave, Hicürixüa xequenecusuni xequene'uxipieca. 'Ariri cümütücari, canaye'ani. Camüsü, Yuri Tevi nehücütütü, 'axa teyuruvamete vamamasie nepüyetuiyani. ");
INSERT INTO hchNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Xequenanucu'uti, tepüvanaquiyu. Neuxei, que mü'ane münesiyetuani 'acanamieni. ");
INSERT INTO hchNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Mericüsü yapaucua müpaü tivacühüavecacu cuxi, Cura caninuani, Tamamata Heimana Yuhutame müxevitütücai. Yuvaücavame teüteri yuhamame nivaravitücücaitüni cusirate cüyexi mete'u'ücame. Mara'acate memühüritüariecai, mümeta 'inüaricü memüte'üquitametetücai 'uquiravesixita menivareyenü'ani. ");
INSERT INTO hchNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Mericüsü que mü'ane miyetuaniquecai 'inüari nivarupitüani teüteri mevayecünirümecacu ya'utaitü, Que mü'ane memütavaüritüani ne'i'isetü, mücü canihücütüni. Xequeneuviya 'iya, xequenanuhani 'aixüa xe'ihütü. ");
INSERT INTO hchNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Hicü Cura nuaca, 'aura niuyani cuitü. 'Aixüa 'acu Ti'üquitame titahüaveca, ni'iseni. ");
INSERT INTO hchNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Hicü müme meniviya. ");
INSERT INTO hchNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Müme 'aura memüti'ucai, xevitü yucusira vatihanaca, nivani ti'uximayatame mara'acame mühüritüariecaisüa mümiemetücai. Nacaya naviteni. ");
INSERT INTO hchNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Quesusi müpaü tinivarutahüave, Xeme cari xepeyecü cusirate cüyexi xe'u'ütü xenesiviyaque, tinavayamepaü que mütiviviyarüva. ");
INSERT INTO hchNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Müixa xesata neniuyeicacaitüni tucaricü tuquita neti'üquitatü, xepücanesihevi. Peru que'aye'ani 'utüarica que maine. ");
INSERT INTO hchNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Hicü yunaitü me'icu'eirieca meniyuta'unaxüani. ");
INSERT INTO hchNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Xevitü temaicü niveiyacaitüni rinu savanayaricü yu'eimatü mümavecaicü. Meniviya temaicü, ");
INSERT INTO hchNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","peru mücü yusavana 'ucu'eirieca niyuta'una mavetü. ");
INSERT INTO hchNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Hicü mara'acame mühüritüariecaisüa meneihana Quesusi. Mana meniyucuxeürieni mara'acate memühüritüariecai 'uquiravesixi, müme 'inüaricü memüte'üquitametetücai yunaitü. ");
INSERT INTO hchNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pecuru tevapai niveiyacaitüni, mara'acame mühüritüariecai qui 'aurie ninuani. Tacua tupirisixi vahamatü niutivecaitüni tai 'aurie cüxetü. ");
INSERT INTO hchNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Hicü mara'acate memühüritüariecai yunaitü 'isücate menivavautüvecaitüni tehecüatamete, memixanetacü Quesusi, vaniuquicü memimienicü. Haquevasü mepücavarutaxei. ");
INSERT INTO hchNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Yumüiretü mete'itavatü menihecüatacaitüni que vaniu memüte'unenierixü peru vaniuqui pücayuxevicai. ");
INSERT INTO hchNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Hipatü me'anucu'uca menitahecüata mete'itavatü que memüte'unenierixü vaniu, müpaü me'utiyuatü, ");
INSERT INTO hchNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Tame teni'enieni 'ipaü haineme, 'Icü tuqui mamacü muveviya nenita'unamücü, haica tucari 'anucayayu xeimeta nenitavevimücü mamacü caveviyacame. ");
INSERT INTO hchNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ni müpaü que memütehecüatacai, vaniuqui pücataxevirivecai. ");
INSERT INTO hchNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Mericüsü mara'acame mühüritüariecai vahixüapa 'utaqueca, Quesusi niuta'ivaviya müpaü 'utaitü, 'Asipecatita'ani. Que tita 'icü memütehecüata 'ahepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Mücü masi cayuvatü mana niuvecaitüni, tixaü püca'uta'a. Mara'acame hutarieca müpaü tinita'ivaviya, 'Ecü peticürisitu. Que mü'ane 'aixüa müticuxaxasiva, 'ecü petinu'aya. ");
INSERT INTO hchNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Quesusi müpaü tinita'eiya, Ne necanihücütüni. Yuri Tevi que nemütiteva, xeme xecanenixeiyacuni, Que Mü'ane Mütürücaüye serieta ne'acaime. Ne'acamieme taheima mieme haisata xecanenixeiyacuni. ");
INSERT INTO hchNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Hicü mara'acame yu'ixuriqui 'utisanaxüaca müpaü niutayüni, Que cuxi tetevareuyehüva tehecüatamete. ");
INSERT INTO hchNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Xeme xecani'enieni que mütisevixima Cacaüyari 'axa 'utaitü. Que xeteyücühüave. Müme yunaitü müpaü meniutiyuanecaitüni quename müpaü reuyevecai mümierienicü. ");
INSERT INTO hchNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Hipatü menisutüani hesiena me'uti'aüsicavivatü me'inanaimatü. Meheitinaca hüxiena, menitihusutücüne müpaü mete'icühüavetü, Quetinehecüatani quepai müyüane. Tupirisixita me'iviyaca menicusunacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Mericüsüari Pecuru vatipai 'uvecacu qui 'aurie tacua, 'uca caninuani müti'uximayatametücai mara'acame mühüritüariecaisüa mieme. ");
INSERT INTO hchNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pecuru 'uxeiyaca cüxecame, heutaniereca, müpaü niutayüni, 'Ecüta 'iya Nasaretitanacamatü pecaniuyeicacaitüni Quesusimatü. ");
INSERT INTO hchNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Mücü niyucu'imavacaitüni, müpaü 'utaitü, Ne havaicü nepüca'imate, 'asinepücatimate que pemaine. Müpaü 'utayüca quitenie nanuyeyani. Vacana niutahiva. ");
INSERT INTO hchNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Hicü 'iya 'uca hutarieca 'ixeiyaca nisutüani müpaü tivacühüavetü müme mana memüti'ucai, 'Icü xevitü canihücütüni müme. ");
INSERT INTO hchNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Mücü tavari niyucu'imavacaitüni. Yareutevitüta müme mana memüti'ucai tavari müpaü metenitahüave Pecuru, Yuricü 'ecü xevitü müme pecanihücütüni. Camüsü Carereya pecaniquiecametüni, vahepaü pemütiuniucacü. ");
INSERT INTO hchNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Hicü nisutüani müpaü 'utaitü, Cacaüyari 'axa xüca nesiyurienique tüma xüca neti'itavani, yemecü nepaine, tixaü 'icü tevi nepücamate xemixata. ");
INSERT INTO hchNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Cuitüva hutarieca vacana niutahiva. Pecuru Quesusi niuquieya na'erivani que mütitahüavixü, Vacana hutarieca catahivavecacu cuxi, 'ecü haicacüa pecani'acu'imavamücü quename pecanesimate pe'utaitü. 'Icü nai ra'erivatü niutasuani. ");
INSERT INTO hchNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Hicüsüari 'ucatarecu cuitü mara'acate memühüritüariecai, 'uquiravesixi, mümeta 'inüaricü memüte'üquitametetücai, hipatüta 'isücate yunaitü meyucuxeürieca meyu'enieca, Quesusi menehana hüacame, Piratu meniyetuirieni. ");
INSERT INTO hchNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Piratu müpaü tinita'ivaviya, 'Ecü Huriyusixi teüteriyari tiva'aitüvame petihücü. Mücü cayucu'imavatü müpaü tinita'eiya, 'Ecüsü müpaü pecanaineni. ");
INSERT INTO hchNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Mara'acate memühüritüariecai menixanetacaitüni vaücava. ");
INSERT INTO hchNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Tavari müpaü tinita'ivaviya Piratu, Tixaü pecatita'ani. Camü que müreupaüme memümasixaneta. ");
INSERT INTO hchNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Quesusi tavari tixaü cacaniuta'ani. 'Ayumieme Piratu niuhüxiyani. ");
INSERT INTO hchNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Mericüsü xexuime visie mücü 'ixüararipa vahesie mieme nenayexünacaitüni 'anutahüivacame, que mü'ane memivaviriecai. ");
INSERT INTO hchNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Xevitü nanutahüivacaitüni 'ana Vaxavaxi titevatü. 'Iya cuviyexunu 'unamete vahamatü nanutahüivacaitüni. Müme cuviyexunusixi mevaca'unarümetü meteniyucuini. ");
INSERT INTO hchNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Hicü yumüiretü teüteri me'u'axüaca menitavavirieni, yamütiyurienicü yaxeicüa que mütiyurienecai xexuime visie vahesie mieme. ");
INSERT INTO hchNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Piratu müpaü tinivarutahüave, Xeme tixenaque nemüxe'anayexünirienicü Huriyusixi tixe'aitüvame. ");
INSERT INTO hchNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Mücü müpaü catinimaicaitüni memiyetuacü me'ütesatü mara'acate memühüritüariecai. ");
INSERT INTO hchNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Mara'acate memühüritüariecai menivarucuyuitüani teüteri memitavaunicü Vaxavaxi püta manayexünarienicü. ");
INSERT INTO hchNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Piratu müpaü tinivarutahüave tavari, Mericüte, queri ne'iyurieni 'icü Huriyusixi tixe'aitüvame que xemüte'iterüva. ");
INSERT INTO hchNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Müme me'ita'eiyatü müpaü meteniuhiva, Curuxisie quenemi'a. ");
INSERT INTO hchNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Piratu müpaü tinivarutahüave, Titayaricuta, tita 'axa tiuyuri. Müme masi cuini mieme meniutihivacaitüni, Curuxisie quenemi'a, me'utiyuatü. ");
INSERT INTO hchNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Hicü Piratu vanaqui'aritüamütü teüteri, Vaxavaxi nivaranayexünirieni. Tiuta'aitaca Quesusi mücuveiyaxüanicü niyetuani curuxisie mücaviyanicü. ");
INSERT INTO hchNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Hicü cuyaxi xaüsie meneivitüni mana quita parasiyu 'amüpata, parasiyu Püreturiu mütiuyetevasie. Yunaime cuyaxi mana memayetecai menivaruta'inieni. ");
INSERT INTO hchNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","'Ixuriqui mütaüraüye menenacatütüani, xuya mumayari me'utasaca menenutimanirieni. ");
INSERT INTO hchNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Menisutüani me'ivaüritüatü müpaü me'utiyuatü, Que 'acu tüma Huriyusixi tiva'aitüvame. ");
INSERT INTO hchNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Hacacü menitivaxüani mu'uyasie. Menicu'aüsicamavacaitüni. Me'utitunuma'uca yacü nenevieri menipitüacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Me'inanaimaca 'ixuriqui mütaüraüye menenutihünirieni, 'ixuriquieya menenacatütüani. Mericüsü meneivitüni curuxisie me'imienique. ");
INSERT INTO hchNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Cuyeicame me'uviyaca mecanita'aitüani curuxieya menucue'irienicü. Cuyeicame Simuni Sirenetanaca catinitevacaitüni, Herecanituru Xupu niva'uquiyaritücaitüni. Xaüsie heyeyaca, quiecarisie ni'aximecaitüni. ");
INSERT INTO hchNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Mericüsü Curucutapai meneivitüni Quesusi, taniuquicü Müqui Mu'uya Manuca mütiuyetevasie. ");
INSERT INTO hchNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Hicü vinu masivi nücame menenu'itüaniquecaitüni meuyuyehüacacü, peru Quesusi püca'enu'i. ");
INSERT INTO hchNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Mericüsü curuxisie menicavieni. 'Ixuriquiteya meniyutahuritüani, meyu'ivatüvetü memütetimanicü tita memüte'anuhurieniquecai yuxexuitü. ");
INSERT INTO hchNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Mericüsü 'utaxürecu curuxisie menicavieni. ");
INSERT INTO hchNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Que mütiuxanesie yatiniu'utüarieni, Huriyusixi Tiva'aitüvame 'anuyütü. ");
INSERT INTO hchNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Tenavayamete menivarutivütüani yuhutame curuxitesie hamatüana serietana xeime 'utatanata xeime. ");
INSERT INTO hchNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","'Ana naye'ani 'utüaricayari müpaü müre'uxa, Müme memitisana 'inüari niuquiyari, xevitü cani'erivacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Müme menanuyecücacai meninanaimacaitüni, yumu'u me'utisiquetü, müpaü me'utiyuatü, 'E'e, cari 'ecü tuqui pepüta'unaquecai, haica tucari 'anuyeyayu pepenuvevieniquecai. ");
INSERT INTO hchNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Parasü, queneu'atavicueisitüa, curuxisie pe'acayeicatü. ");
INSERT INTO hchNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Yaxeicüata mara'acate memühüritüariecai müme 'inüaricü memüte'üquitametetücai vahamatü meninanaimacaitüni müpaü meteyücühüavetü, Nivarutavicueisitüani hipame, pücayüve müyutavicueisitüanicü yücümana. ");
INSERT INTO hchNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Cürisitutütü, 'Ixaherisixi niu mütati'aitüvame, curuxisie que'acayani, temixeiyacü, yuri temüteta'eriexüanicü. Müme 'auriena memutivütüarie curuxisie mümeta 'axa meniutiyuanecaitüni hepaüsitana. ");
INSERT INTO hchNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Mericüsü tuca 'ayacu, naisarie niucüyüre, cüa caviecacuque niucuhecüare. ");
INSERT INTO hchNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","'Anari Quesusi carima müpaü tiniuhiva vaniuquicü, 'Eruhi, 'Eruhi, rama savacütani, taniuquicü necacaüyari, necacaüyari titayari penetiucu'eiri, maine. ");
INSERT INTO hchNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Hipatü mana memüti'ucai me'i'enieca müpaü meniutiyuani, Neuxei, 'Eriyaxi niutahüave. ");
INSERT INTO hchNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Xevitü 'unausarümetü neyani, ha'iseveme niutahüniya vinu masinacü. Hacasie 'iqueca neitiserieni müpaü 'utaitü, 'Acuxisü tecanitaneniericuni, xüca 'uhamieni 'Eriyaxi 'ecaxünaque. ");
INSERT INTO hchNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Hicü Quesusi carima 'utahivaca, yu'iyari niyetuani. ");
INSERT INTO hchNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Hicü 'ixuriqui meuviecai tuquita hixüata nisane heimana 'acayuaca. ");
INSERT INTO hchNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Xei sienituyari cuyaxi tiva'aitüvame Quesusi hüxie muvecai, 'ixeiyaca yu'iyari que mütiyetua müpaü niutayüni, 'Icü yuricü Cacaüyari caninu'ayatücaitüni. ");
INSERT INTO hchNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Mericüsü 'ucari meninenierecaitüni yateva meti'utü, Mariya Mararatanaca, Mariya Cacuvu 'Esimutevi Cuse müvavarusitücai, Sarumeri, hipatüta mana meniti'ucaitüni. ");
INSERT INTO hchNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Müme meniveiyacaitüni quepaucua Carereyasie muyeicacai, metenimicuacaitüni. Hipatüta yuvaücavatü 'ucari 'utümana memu'axüa Querusaremesie mana meniti'ucaitüni. ");
INSERT INTO hchNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Mericüsü 'acayunirümecacu, tucari memüyucuha'aritüvacaisie, 'uxa'arieca 'uxipiya tucari maye'aniquecaicü, ");
INSERT INTO hchNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Cuse 'Arimateyatanaca caninuani. 'Iya 'isücate canixevitütücaitüni 'aixüa mümarivacai, müta'icuevacai Cacaüyari ti'aitametütü mayanicü. Yu'iyari heucayeca Piratusüa ninuani, Quesusi caxarieya nitavavirieni. ");
INSERT INTO hchNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Piratu niuhüxiyani 'ari mumücü. Xei sienituyari cuyaxi tiva'aitüvame niutacuevieni yu'aurie. Nuacu, Piratu nita'ivaviya que müreutevicai Quesusi hemüquitü. ");
INSERT INTO hchNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Cuyaxi tiva'aitüvame yatitahüavecu Piratu, quename hemü, caxari niyetuirieni Cuse. ");
INSERT INTO hchNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Mücü rinu savanayari hecunaneca, 'ecacueca caxari, savanacü nita'eima, teuquiyapa neitateni 'aita müvaye'inieriecaisie. Neicurupa tete quiteniesie, neicunani. ");
INSERT INTO hchNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mariya Mararatanaca, Mariya Cuse müvarusieyatücaimatü menixeiya haque meutatequie. ");
INSERT INTO hchNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Mericüsü 'uxipiya tucari 'utixücu, Mariya Mararatanacari, Mariya Cacuvu müvarusieyatücaimatü, Sarumematü, 'uhaye visi mu'üa menecunaneni, memüyehucü meheitavirienique caxari. ");
INSERT INTO hchNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ximeri cuitü 'atinecu tau semana mexüacame tucarisie, teuquiyapa meneta'axüani. ");
INSERT INTO hchNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Müpaü meteniyucu'ivaviyacaitüni, Quepai tete pütasiheuhüvirieni teuquiya quitenie meuca. ");
INSERT INTO hchNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Mana me'utaneniereca mecanixeiya tete heuhüiyacame, 'amünecai. ");
INSERT INTO hchNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Hicü teuquiyapa meneutahaxüani. Vaserieta 'acaime temaicü meniuxeiya, mutuxa 'amütevi 'anacatücüme. Meniutimamani. ");
INSERT INTO hchNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Mücü müpaü tinivarutahüave, Xepücamamaca. Quesusi xepücuvautüve Nasaretitanaca curuxisie mucaviya. Cananucuquetüarieniri, 'uva pücayeca. Neuxei 'uva meniteni. ");
INSERT INTO hchNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Hicüri xequenehu. Müpaü xequetenivaretahüavi teyü'üquitüvametemama Pecurumame, quename niu xe'anuyehaitüiyaxü, Carereyapai hetüa, quename mana xeheixeiya, que mütixe'utahüavixü. ");
INSERT INTO hchNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Hicü teuquiyapa mevayecüneca meniyuta'una. Me'utiyüyüacatü me'umamatü menacüne. Xeime tüma 'asimepücate'utahüavixü memümamacaicü. ");
INSERT INTO hchNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Hicü semana mexüacame tucarisie 'anutaniereca Quesusi ximeri, masiücütü nayuyeitüani meri Mariya Mararatanaca 'ixeiyacacu. Que mü'ane meripai memiviyacai cacaüyarixi 'axa memü'anene 'atahutatü, Quesusi müvarayenü'a, mücü Mariya canihücütücaitüni mixei. ");
INSERT INTO hchNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Mücü heyaca, yatinivarutaxatüani müme hamatüana memu'uvacai, meyuhiveriecacu me'utisuanacacu. ");
INSERT INTO hchNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Müme me'u'enanaca quename 'ayeyuricai, quename mücü 'ixei, yuri mepücate'uta'eri. ");
INSERT INTO hchNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","'Arique masiücütü nayuyeitüani yücü 'anetü, yuhutatü müme yeutapai memuhucai me'ixeiyacacu. ");
INSERT INTO hchNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Müme yu'utüma menecüne, hipame teyü'üquitüvamete yametenivaretahüave que mütiuyü. Mümeta 'acuxi yuri mepücatevaruta'eriri. ");
INSERT INTO hchNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","'Imatüriecata masiücütü nayuyeitüani Tamamata Heimana Xevitü teyü'üquitüvamete me'ixeiyacacu metecuacacu. Nivarutatieni yuri memücate'eriecaicü, yu'iyarisie memüsese'icaicü, yuri memücatevaruta'eriricü müme memixei 'anucuquecu. ");
INSERT INTO hchNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Hicü müpaü tinivarutahüave, Naisarie cuiepa xequeneutayeixüa. Niuqui 'aixüa manuyüne xequetenivacuxaxatüvani yunaime queyupaümetü memunetüarie. ");
INSERT INTO hchNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Que mü'ane yuri mütita'erieni müca'üyarieni, mücü nitavicueisitüariemücü. Que mü'ane yuri mücati'erie, 'isücame ninenamücü hesiena mürahüivacü. ");
INSERT INTO hchNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","'Ipaü 'anenetü 'inüarite canitixuaverimücü haque meme'uva müme yuri memüte'erie. Nehesüa memümiemetecü menivarayenü'axüacuni cacaüyarixi 'axa memü'anene. Menitiniucuni niuqui mühehecuacü. ");
INSERT INTO hchNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Cuterixi xüca mevaranucu'üni, mümüiya xüca me'anu'ieni, tixaü 'asipücavayurieni. Tecuicuicate vahesie xüca me'utimeni müme mepanayexürieni. ");
INSERT INTO hchNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Mericüsü Ti'aitame Quesusi müpaü tivarutahüaveca, taheima nanutivitüquieni, Cacaüyari serieta nayerüni. ");
INSERT INTO hchNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Naisarie meneutayeixüani müme metecuxatatü, Ti'aitame vapareviecacu vaüca tiyurienecacu vaniuqui seiriyacacu 'inüari que mütivapitüacai. Müpaü xeicüa cani'aneni.");
INSERT INTO hchNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Yumüiretü meniuyuvaüriya memüteti'utüanicü naime hepaüsita tasata que mütiuyü. ");
INSERT INTO hchNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Müme sutüapai memunenierixü, tupirisixi memacü niuqui 'aixüa manuyüne metecuxatatü, müme metateniyetuirieni mücü niuqui. ");
INSERT INTO hchNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Neta nai que mütiuyü matüaripai hicüque heiseriemecü netinicuvaunecaitüni. 'Ayumieme nemareuyehüvirietü, Teuquiru 'acu, nepünevaüriya xexuime naime nemaraca'utüirienicü ");
INSERT INTO hchNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","yapemütimaicacü 'icü niuqui pemu'eni hepaüsita que mütise'i. ");
INSERT INTO hchNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Mericüsü quepaucua Herurexi müti'aitametücai Cureya cuieyarisie, mara'acame 'aniuyeicacaitüni Huriyusixi teüteriyari vamara'acate xevitü hücütütü, Sacariya titevatü, 'Aviyaxi teüterimama metenitetevacaitüni mara'acate vahamatü müti'uximayacai. Yü'üya canexeiyacaitüni 'Erisaveti titevacame, mara'acame nu'ayatüme. ");
INSERT INTO hchNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Yü'üitatü heiseriemecü yameteniyuriecaitüni Cacaüyari hüxie. Yametenicahucaitüni Ti'aitame que müti'aitacai naime, vahesie carahüivacacu. ");
INSERT INTO hchNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Nunusi mepücahexeiyacai 'Erisaveti mücayüvecaicü. Mecani'uquiravesixitücaitüniri. ");
INSERT INTO hchNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Mericüsü Sacariya mara'acametütü tini'uximayacaitüni Cacaüyari hüxie quepaucua 'Aviyaxi teüterimama vahesie mütiunaquixü. ");
INSERT INTO hchNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Mara'acate que mütivayeiyaritücai, hesiena tiniunaque heiva Ti'aitame tuquitana meutahanicü, müticüsinaiyanicü. ");
INSERT INTO hchNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Quepaucua maye'a mütitacüsinaiyacü, yunaitü teüteri tacua meniyuneneviecaitüni. ");
INSERT INTO hchNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Hicü nixeiya niuqui tuayame Ti'aitamesüa mieme mana 'utiveme müracüsinaiyasie serieta. ");
INSERT INTO hchNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sacariya 'ixeiyatü niuyuitüarieni yu'iyarisie, niutimani. ");
INSERT INTO hchNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Hicü niuqui tuayame müpaü tinitahüave, Pepücaheumaca, Sacariya 'acu. 'A'ivaurica pü'enierie. 'A'üya 'Erisaveti xenive canitinuivitüamücü. Vani petiniterüvamücü. Peni'atemaviecamücü vaüca, 'A'iyari cuini mieme ninaqui'acamücü ");
INSERT INTO hchNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Yumüiretü mecaniyutemamaviecacuni Quepaucua mütinuiva. ");
INSERT INTO hchNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Canimarivemücü Cacaüyari hüxie. Caxie vinuyari, Xeime vinuta pücaye'eni. 'Iyari Mütiyupata Caniviyamücü püta tinuivayu. ");
INSERT INTO hchNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","'Ixaherisixi teüteriyari yumüireme Ta'aurie canivaraxüriemücü, Ti'aitame memayexeiyanicü Yucacaüyaritüme. ");
INSERT INTO hchNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Canenucuhaitüiyamücü Ti'aitame 'Eriyaxipaü tiuca'iyaritü, Türücariyaya hexeiyatü. Va'uquiyarima ta'aurie nivaraxüriemücü, Yütüriyama memüvara'erivanicü, Müme yuri memücate'erie Ta'aurie nivaraxüriemücü, Müme heiseriemecü yamemütecahu vahepaü memüteyücühüavenicü. Nivacuha'aritüamücü teüteri, Ti'aitame memücueviecacü. ");
INSERT INTO hchNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Hicü Sacariya müpaü tinicühüaveni niuqui tuayame, Que 'aneme 'inüariyaricü yanepütimaica. Necani'uquirasitüni, ne'üyata tucarieya ranutitüa. ");
INSERT INTO hchNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Hicü niuqui tuayame müpaü tinicühüaveni, Ne Cüravieri necanihücütüni. Cacaüyari hüxie neniuveni. Yanemümatitahüavecü necaneyenü'arieni, nematitaxatüanicü 'icü niuqui 'aixüa manuyüne. ");
INSERT INTO hchNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Hicü camü, cayuvatü pepütiyerüni, pecaniuvetü pecanayeimücü mexi ca'aye'aveni, 'ecü yuri pemücatiuta'ericü neniuquisie. Peru neniuqui canaye'amücü quepaucua tucari maye'ani. ");
INSERT INTO hchNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Mericüsü teüteri menicueviecaitüni Sacariya. Meni'iyarixiecaitüni 'emüreutevicaicü tuquita. ");
INSERT INTO hchNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Hicü vayeyaca niyutatexieni varahüavetü. Müme yametenetimani quename tixaütü tiuxei tuquita. 'Iya yumamacü nivacu'inüaritüvacaitüni. 'Aniucateitüni caniuvetü. ");
INSERT INTO hchNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Hicü heutiparecu 'uximayasicaya, yuquie caneyani. ");
INSERT INTO hchNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Hicü 'ana 'üyaya 'ayehucatü nayani 'Erisaveti. Niyu'avietacaitüni 'auxüme meseri müpaü 'utaitü, ");
INSERT INTO hchNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Camü, 'ipaü tiniuyurieni Ti'aitame, yuvaüriyatü 'aixüa münesiyurienicü, teüteri memücanesinanaimacacü. ");
INSERT INTO hchNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Mericüsü 'ataxevirieca meserisie Cacaüyari nitanü'ani yuniuqui tuayame Cüravieri, Carereya cuieyarisie quiecarisie Nasareti müracutevasie. ");
INSERT INTO hchNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","'Üimari mücaxuriquicaisüa nitanü'ani Mariya mütitevacaisüa. Nitiviquieximecaitüni, 'uqui Cuse titevatü nitivitüniquecaitüni. Cuse Raviri caninunuiyarieyatücaitüni. ");
INSERT INTO hchNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Hicü Mariyasüa heutahaca niuqui tuayame, müpaü niutayüni, 'Aixüa 'acu. Ti'aitame 'aixüa catiniuca'iyarini 'ahesie mieme, 'ahamatü puyeica. ");
INSERT INTO hchNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mücü yu'iyarisie niuyuitüarieni, yatinicu'erivacaitüni titayari müpaü mütivaüritüa. ");
INSERT INTO hchNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Niuqui tuayame müpaü tinitahüave, Pepücaheumaca, Mariya 'acu. Cacaüyari 'aixüa pütiuca'iyari 'ahesie mieme. ");
INSERT INTO hchNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Hicüri pe'ayehucatü pecanayeimücü, pecanitinivemücü. Quesusi pecatiniterüvamücü. ");
INSERT INTO hchNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Canimarivemücü, Que mü'ane taheima macave nu'aya canimarivacamücü. Ravirisie caniyeyeimücü, Ti'aitame Cacaüyaritütü canipitüamücü Raviri 'uvenieyasie mayerünicü Que müti'aitacai 'iya. ");
INSERT INTO hchNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","'Ixaherisixi teüteriyari Catinivata'aitüamücü yuheyemecü. Que müti'aita Pücatipare hasuacu. ");
INSERT INTO hchNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Hicü Mariya müpaü tinitahüave niuqui tuayame, Mericüte, quepaütütü 'ipaü pütiyüni. 'Uqui nepücamate. ");
INSERT INTO hchNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Niuqui tuayame müpaü tinitahüave, 'Iyari Mütiyupata 'ahesie caninuamücü. Que mü'ane taheima macave Yutürücariyacü camani'etüriviyamücü. 'Ayumieme nunusi mütinuiva canipasiemücü Cacaüyarisie mieme, Müpaü catinimarivacamücü Cacaüyari nu'ayatütü. ");
INSERT INTO hchNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Camü, 'a'iva yateva 'Erisaveti 'ayehucatü nayani 'ucarasitütü. 'Ataxeime meseri niyurieca 'iya caniveveme memüxatacai. ");
INSERT INTO hchNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Cacaüyari pücayutatexieni, naimecü püyüveni püta. ");
INSERT INTO hchNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mariya müpaü tinitahüave, Mericüte, ne Ti'aitame necatini'uximayatameyatüni. Que pemaine yaquetiuyüni. Hicü niuqui tuayame caneyani. ");
INSERT INTO hchNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Hicüsüari yucuha'aritüaca caneyani Mariya. Yumexüitüatü quiecarisie neta'ani hüri mananiere Cureya cuieyarisie. ");
INSERT INTO hchNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Sacariya quita heutahaca, nitavaüritüani 'Erisaveti. ");
INSERT INTO hchNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Mericüsü 'Erisaveti quepaucua mi'eni Mariya 'ivaüritüacacu, nunusi neucuyuaxüani huriepana. Hicü 'Iyari Mütiyupata niviya 'Erisaveti. ");
INSERT INTO hchNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Müpaü niutayüni carima, Vaüca 'aixüa pepu'itüarie, hipatü 'ucari temüca'itüariepaü. 'Aixüa cani'itüariemücü que mü'ane pemütinuivitüani. ");
INSERT INTO hchNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nehesie que tinaque neti'aitüvame varusieya münesi'ivatamiecü. ");
INSERT INTO hchNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Camü, 'avaürisica ne'u'eniecu, nunusi yutemavietü neucuyuaxüani nehuriepa. ");
INSERT INTO hchNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","'Aixüa pecani'itüariemücü yuri pemütiuta'ericü quename 'aye'ani naitü que pemütiutahüavarie, Ti'aitame que mümaretahüavixü. ");
INSERT INTO hchNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Hicü Mariya müpaü niutayüni, Ne'iyari müpaü paine, Ti'aitame canitürücaüyeni. ");
INSERT INTO hchNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ne'iyari niyutemavieca nehe'erivatü Cacaüyari münesi'utavicueisitüacü. ");
INSERT INTO hchNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Caneniuxeiya ti'uximayatame que nemütihücü hesiena mieme, Sepa tixaü nemücatihücü. Camü, 'uxa'a varie yunaitü nuivarite 'Aixüa ne'itüariecame mecaneni'eriecacuni. ");
INSERT INTO hchNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Que mü'ane mütürücaüye Marivemecü caneniuyurieni. Mücü Pasiecame canixasivani. ");
INSERT INTO hchNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Canivanenimayaca yunaime memüteheiyehüvirie, Vanivemata nivanenimayaca. ");
INSERT INTO hchNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Yücümana que mütiyuriene Canimasiücüni que mütitürücaüye. Nivareutaveiyaxüani müme memüteyucatave'erie Yu'iyarisie que memütecu'eriva, ");
INSERT INTO hchNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Cuiepa te'aitamete nivarunavairieni Tita memüte'aita, Müme tixaü memücatehüme püta Nivaruhüritüani vaüca. ");
INSERT INTO hchNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Memeuhacacuicucai nivarutihüniya 'aixüa mü'anecü. Memeuca'ucai nivareutanü'axüani memamaveme. ");
INSERT INTO hchNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Nisutüani tasiparevietü 'Ixaherisixi teüteriyari Hesüana mieme temüte'uximayatamete, He'erivatü que mütivarutahüavixü ta'uquiyarima. Caninenimayaca 'Apurahami yuheyemecü, Cataninenimayaca tame hesiena temüyecü. ");
INSERT INTO hchNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mericüsü Mariya 'Erisavetisüa niucateitüni 'esivatücacu haica meseri. 'Arique yuquie neyani. ");
INSERT INTO hchNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Mericüsü tucari naye'ani 'Erisaveti mütinivenicü. 'Uquitüme niutiniveni. ");
INSERT INTO hchNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Hicü 'auravatari maremama yunaitü mete'utamarieca Ti'aitame vaüca que mütitanenimayataxü, hamatüana mecaniyutemamaviecaitüni. ");
INSERT INTO hchNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Hicü 'atahairieca tucarisie mecaniu'axüani me'i'inüaritüanique nu'esi Huriyusixi vaxitequiyacü. Sacariya mecateniterüvaquecaitüni 'uquiyarieyapaü. ");
INSERT INTO hchNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","'Ana varusieya müpaü niutayüni, Tixaüsietü. Vani catinitevacamücü püta. ");
INSERT INTO hchNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Müme müpaü metenitahüave, Haquevasü 'amare pumave müpaü titevatü. ");
INSERT INTO hchNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Yumamacü menitahüave quemasieya, que mütinaque mütiterüvarienicü. ");
INSERT INTO hchNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Xapa 'uta'ivauca, müpaü 'utaineme canaca'utüani, Vani catinitevacamücü püta. Yunaitü meniuhüxiyani. ");
INSERT INTO hchNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Hicü yapaucua nenieya niuxünarieni. Niutaniuni 'aixüa 'utaitü Cacaüyari hepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","'Auravatari yunaitü mecanimamacaitüni. Naisarie Cureya hüriyarisie que mütiuyü catinicuxaxasivacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Yunaitü memü'enanacai meniyu'iyaritüacaitüni müpaü meteyücühüavetü, Que 'anetü payani 'icü nunusi. Mücü meta, Ti'aitame yütürücariyacü nipareviecaitüni. ");
INSERT INTO hchNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","'Ana Cacaüyari 'Iyarieya Mütiyupata caniviyani nunusi 'uquiyarieya. Sacariya niutaniuni Cacaüyarisie mieme müpaü 'utaitü, ");
INSERT INTO hchNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","'Aixüa queticühüavarüvani Ti'aitame, Que mü'ane 'Ixaherisixi mütacacaüyari. Nisutüani yuteüterima va'üviyatü, 'Aixüa 'iyurienetü memüxünarienicü. ");
INSERT INTO hchNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Que mü'ane mütürücaüye niuquerieni, mütasitavicueisitüanicü, Raviri quie mieme, Raviri müti'uximayacaicü Cacaüyarisie mieme ");
INSERT INTO hchNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Meripaitü que mainecai que mütiyurieniquecai. Yametenicuxatacaitüni texaxatametemama Memupasie hesiena mieme, Memutiniucacaicü hesiena mieme. Müpaü meniutiyuanecaitüni ");
INSERT INTO hchNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Mütasi'utavicueisitüaniquecaicü Müme memütasi'aye'uni memücatasi'a'ivacü, Müme memütasi'uxive'erie memücatasi'a'ivacü. ");
INSERT INTO hchNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Müpaüta meniutiyuanecaitüni Müvanenimayataquecaicü ta'uquiyarima He'erivatü türatu mutavevi yücümana, ");
INSERT INTO hchNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Que mütiuyuhüritüa yaticühüavetü ta'uquiyari 'Apurahami Quename tasipitüaniquecai ");
INSERT INTO hchNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","tecamamatü Temütavicueisitüarienicü Müme memütasi'aye'uni memücatasi'a'ivacü, Temeyexeiyanicü 'iya que mütinaque, ");
INSERT INTO hchNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Hesiena mieme tepasietü, Heiseriemecü yatetecahutü, Hüxiena te'u'uvatü mexi te'ayeneniere. ");
INSERT INTO hchNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","'Ecü meta nunusi 'acu, Que mü'ane taheima macavesüa mieme tixaxatame Pecatiniuterüvarüvamücü. Ti'aitame pepanucuhaitüiya Huyeya 'aixüa pemüyurienicü. ");
INSERT INTO hchNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Teüterimama petinivatahecüatüamücü Que mütivatavicueisitüani pehaitü, Que mütivareuyehüvirieni müme 'axa memüte'uyuri pehaitü. ");
INSERT INTO hchNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Müpaü catiniyuriemücü Tacacaüyari mütiyucanenimayacü. 'Ayumieme que mü'ane taheima mümieme caninuamücü. ");
INSERT INTO hchNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Nivahecüariviyamücü müme yüvipa memütitei, Müme meta mecui'ivarümetü memüyüriyarie Nivahecüariviyamücü. Ta'ücate cataniseiriyamücü, Temeu'uvanicü haque 'aixüa temütetaxeiyanicü Cacaüyarimatü. ");
INSERT INTO hchNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Mericüsü nunusi caniverecaitüni. 'Iyarieya türücaüyetü nayani. Macumavesie neyeicacaitüni mexi tucarieya ca'aye'avecai cuxi masiücütü mayanicü 'Ixaherisixi vahüxie. ");
INSERT INTO hchNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Mericüsü 'ana 'aisica neutanü'ariexüani Sesaxi 'Acusitusüa mieme, müpaü 'utaitü, yunaitü cuiepa memütama memayucayasacü. ");
INSERT INTO hchNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Mücü 'inüari matüaripai mieme puyü quepaucua Sireniyu mehüritüariecai Siriya cuieyarisie. ");
INSERT INTO hchNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Yunaitü mecaneutayeixüani memayucayasacü yuxexuitü yuquiecarisie. ");
INSERT INTO hchNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Hicü Cuse Carereya cuieyarisie Nasareti müracutevasie neyeyani. Cureya cuieyarisie ninuani Raviri quiecariena Vereni müracutevasie. Raviri quie canimiemetücaitüni, Raviri nunuiyarieya canihücütücaitüni. ");
INSERT INTO hchNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Macayerienicü neyeyani Mariya 'avitütü mücü mayehucacaicü. 'Üyaya nayaniquecaitüni. ");
INSERT INTO hchNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Mana mexi me'u'uvacai, tucarieya naye'ani mütinivenicü. ");
INSERT INTO hchNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Hicü yumatüari niutiniveni. Tuvaxatecü nicu'eima, vacaisixi vacanuvasie nicateni mücaxuavecaicü vahesie mieme memüva'axüaniquecaisie. ");
INSERT INTO hchNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Mericüsü 'ana muxasi vahüvemete mana meniu'uvacaitüni. Yeuta menivahütüvecaitüni yumuxasi yüvicüta. ");
INSERT INTO hchNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Hicü vahüxie niutaqueni niuqui tuayame Ti'aitamesüa mieme. Va'aurie nacuxavatücaitüni Ti'aitame hecüariyayacü. Vaüca menimamacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Hicü niuqui tuayame müpaü tinivarutahüave, Xepücamamaca. Hicü nenixetaxatüamücü niuqui 'aixüa manuyüne. Vaüca canixuavecamücü temavierica yunaime teüteri vahesie mieme. ");
INSERT INTO hchNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","'Icü tücarisie tiyuvicueisitüvame canetinuiva xehesie mieme. Raviri quiecariena tineyüni. Que mü'ane heiserie mupitüarie Cürisitutütü canihücütüni, Ti'aitame canihücütüni. ");
INSERT INTO hchNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","'Icü 'inüaricü xecaneitimaicuni. Nunusi xecanexeiyacuni tuvaxatecü 'eimeme, vacaisixi vacunuvasie heyecaime. ");
INSERT INTO hchNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Hicü yapaucua niuqui tuayame 'aurie meniuti'uni muyuavisie miemete yumüiretü, 'aixüa me'utiyuatü Cacaüyari hepaüsita, müpaü me'utiyuatü, ");
INSERT INTO hchNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Taheima visi catinicühüavarüvani Cacaüyari. Cuiepa 'aixüa mecatenixeiyariecuni teüteri Müme vacümana münaqui'a. ");
INSERT INTO hchNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Mericüsü niuqui tuayamete muyuavisie meheutiyunixüacu, müpaü meteniyühüavecaitüni muxasi vahüvemete, Hicümüsüari tepüyehu Verenipaitü. Tepi'ixüariyu que mainecai, Ti'aitame que mütatiutahüavixü. ");
INSERT INTO hchNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Meyumexüitüatü menecüne. Mevaruta'ivauca Mariyamame menivarutaxeiya Cuse, nunusi meta vacaisixi vacanuvasie yecaime. ");
INSERT INTO hchNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Mevaruxeiyaca metenicuxatacaitüni que memüte'utahüavarie nunusi hepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Yunaitü memü'enanacai menihüxiyacaitüni que memütevarutahüavixücü muxasi vahüvemete. ");
INSERT INTO hchNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Masi Mariya ni'üviyacaitüni yu'iyarisie 'icü naime, yu'iyaritüatü hepaüsitana. ");
INSERT INTO hchNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Hicü menecüne muxasi vahüvemete 'aixüa metecuxatatü Cacaüyari hepaüsita nai que memüte'uxeicü nai que memüte'u'enicü. Naitü catiniuyüni que memüte'utahüavarie. ");
INSERT INTO hchNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Mericüsü 'atahairieca tucari meni'inüaritüani Huriyusixi teüteriyari vaxitequiyacü. 'Ana Quesusi tiniuterüvarieni, niuqui tuayame que mütiterüvaxü yuvarusisie ca'ayecaicu cuxi. ");
INSERT INTO hchNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Mericüsü Muisexi 'inüaricü catini'aitacaitüni nivecame hepaüsita. Tucari 'aye'acu memüyu'itienicü, Querusareme menecüne nunusi meheyetuanique Ti'aitamesüa. ");
INSERT INTO hchNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Müpaü catine'uca 'inüari xapayarisie, Ti'aitame meripaitü que mainecai, Yunaitü 'uquisi matüarixi memütinunuiva, müme mecanipasiecacuni Ti'aitamesie mieme. ");
INSERT INTO hchNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Menecüne memütemavanicü Ti'aitame que mainecai, xüa 'inüari xapayarisie que müre'ucai, Cucuruxi xei parisi, mesü veuraixi türixi yuhutame mecanivaremavacacuni, 'utaitü. ");
INSERT INTO hchNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Hicü tevi Querusareme necateitüni Simiyuni titevatü. 'Iya heiseriemecü yaticamietü Cacaüyari nayexeiyacaitüni. Nicueviecaitüni 'Ixaherisixi teüteriyari vanütüvame. 'Iyari Mütiyupatacü nihünecaitüni. ");
INSERT INTO hchNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Müpaü tiniupitüarieni, 'Iyari Mütiyupata que mütitahüavixü, quename cuitü camüniquecai. 'Ixeiyame que mü'ane Ti'aitame micayeniquecai Cürisitutüme xeicüa, 'anarique canimüniquecaitüni. ");
INSERT INTO hchNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Hicü 'Iyari 'inücu, Huriyusixi vatuquipa ninuani. 'Arique Quesusi 'uquiyarimama meneutahaxüani yame'iyurienique nunusi, Huriyusixi que mütivayeiyari, 'inüari niuquiyarisie que müre'uxa. ");
INSERT INTO hchNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","'Ana Simiyuni nenutuni. 'Aixüa niutayüni Cacaüyari hepaüsita, müpaü 'utaitü, ");
INSERT INTO hchNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Hicürixüa necusiyari 'acu, Pepeye'atüa 'aniuqui. Pepünesi'uxünaxü Ne'iyarisie neca'uximatüariecacu. 'Ahesie mieme nepüti'uximaya. ");
INSERT INTO hchNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Hicürixüa necümana nepütiuxei Que pemütivavicueisitüani teüteri. ");
INSERT INTO hchNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Nepixei tita pemütiha'aritüa Yunaime teüteri vahüxie. ");
INSERT INTO hchNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Canivahecüariviyamücü hipame nuivarite, Visi te'aneneme catanayeitüamücü 'Ateüterima 'Ixaherisixi ");
INSERT INTO hchNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Hicü 'uquiyarieya varusieya meniyu'iyaritüacaitüni müpaü mainecaicü hepaüsitana. ");
INSERT INTO hchNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","'Aixüa xepü'itüarieca, niutayünita Simiyuni. Müpaü Mariya tiniutahüave nunusi varusieya, Camü 'icü nunusi Yumüiretü 'Ixaherisixi Mematixürienicü, Yumüiretüta Memanucu'unicü Cani'ayumiemetüni. 'Inüari caniyümücü, Caniniuquimariecamücü. ");
INSERT INTO hchNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","'Ecüta 'a'iyarisie Pecanisequiemücü hivericacü, Cumu 'ixipara que mütiyuseve. Mücü que mütiyurieneni, Yumüiretü memasiücütü mecanacünicuni Que memüteyücühüave yu'iyarisie. ");
INSERT INTO hchNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Xevitüta 'acaniuyeicacaitüni 'ucarasitütü, Hana titevatü. Mücü Cacaüyari niuquieya canicuxatacaitüni. Panuheri caninu'ayatücaitüni, 'Aseri nunuivarieyatütü. Caniseüyecaitüni, nauca teviyari heimana nauca viyari canihücaitüni. 'Utiviquieca 'atahuta viyari piteütacai yücüna, ");
INSERT INTO hchNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","'umücu yuxaüta 'eniucateitüni. Tuqui curaruyarita pücavayeyeicacai masi yuhaquetü yunenevietü pü'ayumiemetücai tucaricü tücaricü. ");
INSERT INTO hchNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Hicü 'aura 'uyaca pamüpariyusi nipitüani Cacaüyari. Quesusi hepaüsita tinivacuxaxatüvacaitüni Querusaremetari memüta'icuevacai memütaxünarienicü yunaitü. ");
INSERT INTO hchNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Hicü meheye'atüaca naime que müre'uxa 'inüari xapayarisie, Ti'aitame que mainecai meripaitü, Carereyasie menecüne. Yuquiecari meneta'axüani Nasareti müracutevasie. ");
INSERT INTO hchNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Mericüsü nunusi niverecaitüni türücaüyetü timaivetü nayeiximecaitüni, Cacaüyari 'aixüa pütiuca'iyaricai hesiena mieme. ");
INSERT INTO hchNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Mericüsü xexuime visie 'uquiyarimama Querusareme meneta'axecaitüni 'ixüararipa quepaucua meme'erivacai, Cacaüyari que mütivaruhayevaxü vateüterima. ");
INSERT INTO hchNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Hicü quepaucua tamamata heimana huta viyari mühücai, mana meneutiyunixüani, teüteri que mütivayeiyaritücai 'ixüararipa. ");
INSERT INTO hchNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Hicü heutiparecu, yu'utüma mehahuximecacu, Quesusi Querusareme neyuhayeva, 'asimecatemaicacu 'uquiyarimama. ");
INSERT INTO hchNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Teüteri vasata 'uyeicame me'erietü, xei tucari meniu'uvacaitüni. 'Ana yu'ivama yumarema vahesüa menitivautücüne. ");
INSERT INTO hchNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Meca'itaxeiyavavetü, Querusareme menacunuaxüani me'icuvautüvetü. ");
INSERT INTO hchNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Hicü hairieca tucari meneitaxeiya tuqui curaruyarita 'ayecaime, te'üquitamete vahixüapa 'ucaime. Niva'eniecaitüni nivacu'ivaviyacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Yunaitü memi'eniecai menihüxiyacaitüni timaitü que mütivacu'eiyacai. ");
INSERT INTO hchNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Hicü 'uquiyarimama me'ixeiyatü meni'iyarixiecaitüni. Varusieya müpaü tinitahüave, Nenive, titayari müya petatiuyuri. Tepümasicuvautüve tetahiverietü 'a'uquiyarimatü. ");
INSERT INTO hchNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Müpaü tinivarutahüave, 'E'e, cari xepünesicuvautüvecai. Tamü, 'asixecatemaicai, meuyevesecü ne'uquiyari quiya hepaüsita nemü'ayumiemetünicü. ");
INSERT INTO hchNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Müme 'asimepücateheitima niuquieyasie que mainecai. ");
INSERT INTO hchNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Hicü vahamatü neyani, Nasareti meneta'axüani. Que memaitücatei yacatinicamiecaitüni. Varusieya yu'iyarisie ni'üviyacaitüni 'icü naime. ");
INSERT INTO hchNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Quesusi timaivetü canayeiximecaitüni, caniverecaitüni. Cacaüyari, teüterita masi vaüca simetenixeiyacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Mericüsü 'ana Tiveriyu Sesaxi tamamata heimana 'auxüme viyari niuyurieni ti'aitatü, Punisiyu Piratu niucayerieni 'isücametütü Cureya cuieyarisie, Herurexi nihüritüariecaitüni Carereya cuieyarisie müti'aitanicü, Piripe Herurexi mü'ivayatücai catini'aitacaitüni 'Itureya cuieyarisie Türacuniti cuieyarisie, Risaniyaxi catini'aitacaitüni 'Aviriniyasie, ");
INSERT INTO hchNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","'Anasi Caipasi mecanihüritüariecaitüni mara'acate. 'Ana Cacaüyari yuniuqui nipitüani Vani Sacariya nu'aya, macumavesie 'uyeicame. ");
INSERT INTO hchNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Naisarie Curutani hatuxameyari tesie niuyeicacaitüni müpaü tivacuxaxatüvatü, memütehayevacü que memüteyuriecai para Cacaüyari mütivareuyehüvirienicü 'axa que memüte'uyuri, mücücü memüca'üyarienicü. ");
INSERT INTO hchNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Yacatiniyurienecaitüni que müre'uxa Quisariyaxi xapayasie, Cacaüyari niuquieyacü que müticuxatacai, Xevitü mahiva macumavesie 'uvetü, Xequeneucuha'aritüa Ti'aitame huyeya, haitü, Xexeuravime xequeneutivevi huyeya, haitü. ");
INSERT INTO hchNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Naitü 'aqui cananuparecutüariexüamücü, Naitü yemuri 'emutütü 'esimutütü 'acuveritü canayeitüariemücü Tita mütitutune xexeuravitü nayeimücü Tita müracutetexiya 'acuharuanitü canayeimücü ");
INSERT INTO hchNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Yunaitü teüteri mepixeiya que mütiyuvicueisitüva Cacaüyari. ");
INSERT INTO hchNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Vani müpaü tinivacuxaxatüvacaitüni teüteri memü'axecai müvaca'üyacü, Cari xeme terücaxi xepüva'ivama. Quepaicü pütixehecüatüa xemüyuta'unacü capa 'uxa'a varie xehecariecacü. ");
INSERT INTO hchNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Müme memüte'uhayevaxü que memüteyuriecai, vahepaü püta xequeteneyurieca, que müreuyevese. Xepüca'isutüaca yu'iyarisie müpaü xeteyücühüavetü, Tepünaqui'eriva ta'uquiyari temexeiyacü 'Apurahami. Müpaü nepütixecühüave, Cacaüyari caniyüveni 'icü tetexi teüteri müvarayeitüani 'Apurahami nivemama. ");
INSERT INTO hchNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","'Ari hasa caniucuha'aritüarieni cüyexi maxürienicü. 'Ayumieme naitü cüye 'aixüa 'anenetü müca'utixuxuavere canaxüriyamücü, taipa caneuxüriyamücü. ");
INSERT INTO hchNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Teüteri müpaü metenicu'ivaviyacaitüni, Mericüte, quesü teteyurieca tame. ");
INSERT INTO hchNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","'Iya müpaü tinivacühüavecaitüni, Que mü'ane huta camixayari mexeiya, que'imini que mü'ane mücaheixeiya. Que mü'ane 'icuai mexeiya yaxeicüa quetiyurieneni. ");
INSERT INTO hchNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Memüteyetuiriyari cuviyexunusie mieme meni'axecaitüni, memüca'üyarienicü. Müpaü metenicühüavecaitüni, Ti'üquitame 'acu, que teteyurieca tame. ");
INSERT INTO hchNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","'Iya müpaü tinivacühüavecaitüni, Que xemüte'u'aitüarie, heimana mieme xepücatevauca. ");
INSERT INTO hchNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Cuyaxita müpaü metenicu'ivaviyacaitüni, Quesü teteyurieca tame. 'Iya müpaü tinivacühüavecaitüni, Xepücatenavayani, 'itaricacü xepücavataviviyani. Xequenenaqui'aca yu'ivaricacü. ");
INSERT INTO hchNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Mericüsü 'ana teüteri menita'icuevacaitüni yu'iyarisie meyu'iyaritüatü yunaitü Vani hepaüsita, xüca mücü Cürisitu hücütüni me xüca catixaütüni, me'utiyuatü. ");
INSERT INTO hchNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Peru Vani müpaü tinivarutahüave yunaime, Neri hacü nepüxe'uca'üya. 'Ucanamieni que mü'ane cui mütürücaüye, necatürücaüyecacu ne. 'Aixüa nepüca'ane nehesie mütinaquenicü nemipareviecacü ni nemenacuvenirienicü cacaiya cuitaxiyari. Mücü püta que mütixe'uca'üyani, 'Iyari Mütiyupata canixepitüamücü, canixe'itimücü tai que mütiyu'itiva. ");
INSERT INTO hchNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Cuxari 'itivame pacue'e, cuini mieme pütiveque yutüricu. Niti'utamücü yu'icuaxi caxetunisie, cuxariyari püta pütataiyani tai mücatüvesie. ");
INSERT INTO hchNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Masi vaüca nivatuicacaitüni teüteri, niuqui 'aixüa manuyüne nivacuxaxatüvacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Hicü Herurexi mücü cuieya nihüritüariecaitüni müti'aitanicü. Yu'iva niu'üyapieni, Heruriya titevacame niutivitüni. Vaücava catiniyurienecaitüni Herurexi 'axa tiyurienetü. 'Ayumieme Vani nitate'acaitüni. ");
INSERT INTO hchNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Hicü Herurexi nayuye'atüani 'axa que mütiyurienecai, Vani manutahüacü casariyanata. ");
INSERT INTO hchNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Mericüsü quepaucua yunaitü teüteri memuca'üyarie, Quesusita caniuca'üyarieni. Mexi yuneneviecai, taheima nanacatenire. ");
INSERT INTO hchNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","'Iyari Mütiyupata heimana nacaneni, que mütiyuxexeiyacai cucurupaü 'anetü. Xevitü taheima müpaü netayüni, 'Ecü pecaninenivetüni pemünaqui'eriva. 'Acümana necaninaqui'aca. ");
INSERT INTO hchNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Mericüsü Quesusi xei teviyari heimana tamamata viyari yacütütü nihücaitüni quepaucua misutüa müpaü tiyurienetü. Cuse caninu'ayatücaitüni, que memütecu'erivacai. 'Iya 'Erie caninu'ayatücaitüni, ");
INSERT INTO hchNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","'iyata Matati caninu'ayatücaitüni, 'iyata Revi caninu'ayatücaitüni, 'iyata Merüqui caninu'ayatücaitüni, 'iyata Cana caninu'ayatücaitüni, 'iyata Cuse caninu'ayatücaitüni, ");
INSERT INTO hchNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","'iyata Matatiyaxi caninu'ayatücaitüni, 'iyata 'Amuni caninu'ayatücaitüni, 'iyata Nahumi caninu'ayatücaitüni, 'iyata 'Esürie caninu'ayatücaitüni, ");
INSERT INTO hchNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","'iyata Nacahi caninu'ayatücaitüni, 'iyata Mahati caninu'ayatücaitüni, 'iyata Matatiyaxi caninu'ayatücaitüni, 'iyata Semei caninu'ayatücaitüni, 'iyata Cuse caninu'ayatücaitüni, 'iyata Cura caninu'ayatücaitüni, ");
INSERT INTO hchNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","'iyata Cuhana caninu'ayatücaitüni, 'iyata Xesa caninu'ayatücaitüni, 'iyata Suruvaveri caninu'ayatücaitüni, 'iyata Saratieri caninu'ayatücaitüni, ");
INSERT INTO hchNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","'iyata Nerie caninu'ayatücaitüni, 'iyata Merüqui caninu'ayatücaitüni, 'iyata 'Arie caninu'ayatücaitüni, 'iyata Cusami caninu'ayatücaitüni, 'iyata 'Erimurami caninu'ayatücaitüni, 'iyata 'Eri caninu'ayatücaitüni, ");
INSERT INTO hchNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","'iyata Cusue caninu'ayatücaitüni, 'iyata 'Eriyeseri caninu'ayatücaitüni, 'iyata Curimi caninu'ayatücaitüni, 'iyata Matati caninu'ayatücaitüni, ");
INSERT INTO hchNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","'iyata Revi caninu'ayatücaitüni, 'iyata Simiyuni caninu'ayatücaitüni, 'iyata Cura caninu'ayatücaitüni, 'iyata Cuse caninu'ayatücaitüni, 'iyata Cunani caninu'ayatücaitüni, 'iyata 'Eriyaquimi caninu'ayatücaitüni, ");
INSERT INTO hchNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","'iyata Mereya caninu'ayatücaitüni, 'iyata Mainani caninu'ayatücaitüni, 'iyata Matata caninu'ayatücaitüni, 'iyata Natani caninu'ayatücaitüni, ");
INSERT INTO hchNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","'iyata Raviri caninu'ayatücaitüni, 'iyata Quisahi caninu'ayatücaitüni, 'iyata Huveri caninu'ayatücaitüni, 'iyata Puhuxi caninu'ayatücaitüni, 'iyata Sarumuni caninu'ayatücaitüni, 'iyata Nahasuni caninu'ayatücaitüni, ");
INSERT INTO hchNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","'iyata 'Aminaravi caninu'ayatücaitüni, 'iyata 'Arami caninu'ayatücaitüni, 'iyata Hesirumi caninu'ayatücaitüni, 'iyata Parexi caninu'ayatücaitüni, ");
INSERT INTO hchNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","'iyata Cura caninu'ayatücaitüni, 'iyata Cacuvu caninu'ayatücaitüni, 'iyata 'Isahaqui caninu'ayatücaitüni, 'iyata 'Apurahami caninu'ayatücaitüni, 'iyata Tare caninu'ayatücaitüni, 'iyata Nacuri caninu'ayatücaitüni, ");
INSERT INTO hchNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","'iyata Seruqui caninu'ayatücaitüni, 'iyata Racau caninu'ayatücaitüni, 'iyata Perequi caninu'ayatücaitüni, 'iyata Heveri caninu'ayatücaitüni, ");
INSERT INTO hchNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","'iyata Sara caninu'ayatücaitüni, 'iyata Cainani caninu'ayatücaitüni, 'iyata 'Arüpasari caninu'ayatücaitüni, 'iyata Semi caninu'ayatücaitüni, 'iyata Nuhexi caninu'ayatücaitüni, 'iyata Ramequi caninu'ayatücaitüni, ");
INSERT INTO hchNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","'iyata Matusareni caninu'ayatücaitüni, 'iyata 'Enuqui caninu'ayatücaitüni, 'iyata Careri caninu'ayatücaitüni, 'iyata Maharareri caninu'ayatücaitüni, ");
INSERT INTO hchNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","'iyata Cainani caninu'ayatücaitüni, 'iyata 'Enuxi caninu'ayatücaitüni, 'iyata Seti caninu'ayatücaitüni, 'iyata 'Arani caninu'ayatücaitüni, 'iyata Cacaüyari caninu'ayatücaitüniri. ");
INSERT INTO hchNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Mericüsü, Quesusi 'Iyari Mütiyupatacü hünetü mana neyeyani Curutani hatuxameyarisie. 'Iyari Mütiyupata nivitüximecaitüni macumavesie 'uyeicacacu ");
INSERT INTO hchNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","huta teviyari tucari. Cauyumarie ni'inüatanecaitüni, siparasü xüca 'axa tiuyurienique tüma, 'utaitü. Tixaü caticuaivetü yapaümexa tucari, cuini mieme catineuhacamücücaitüni. ");
INSERT INTO hchNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Hicü Cauyumarie müpaü tinitahüave, Tamüsü, 'ecü xüca Cacaüyari penu'ayatüni, 'icü tete müpaü quetineutahüavi, pa payuyeitüani. ");
INSERT INTO hchNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Quesusi müpaü tinita'eiya, 'Utüarica müpaü paine, Tevi xüca pa cuaca xeicüa, mücücü püca'ayeyurini. Cacaüyari que mutayü, niuquieya naitü peuyeveseta. ");
INSERT INTO hchNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Hicü Cauyumarie vapai heivitüca, cuiepa memütama vacuie nai nixeisitüani xei nieriyaricü. ");
INSERT INTO hchNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Cauyumarie müpaü tinitahüave, Heiserie nepümasipitüaca 'icü naime hepaüsita, yunaitü visi memümatecühüavenicü nepümasipitüaca. 'Icü nai necaniyetuiriyarieni, heiserie nepexeiya nemiminicü que mü'ane münesinaque. ");
INSERT INTO hchNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","'Ecü 'ayumieme nenevieri xüca penesi'upitüani, 'icü naitü 'apini pürayani. ");
INSERT INTO hchNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Hicü Quesusi müpaü tinitahüave, Quenemie Cauyumarie. 'Utüarica müpaü paine, Nenevieri pepipitüani Ti'aitame 'acacaüyari, Mücü hücüame pepayexeiyani. ");
INSERT INTO hchNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Hicü Cauyumarie neivitüni Querusareme. Vatuqui yecürita nenutivitüni. Müpaü tinitahüave, 'Ecü Cacaüyari xüca penu'ayatüni, vatipai queneucasuna. ");
INSERT INTO hchNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","'Utüarica müpaü paine, Yuhesüa miemete Niuqui tuayamete Pütiva'aitüaca 'Ahepaüsita, Memümasi'üviyacü. ");
INSERT INTO hchNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Müpaü paineta 'utüarica, Yumamacü mepümasituicani, Capa tetesie pe'uti'ücamürecü. ");
INSERT INTO hchNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Quesusi müpaü tinitahüave, Müpaü paineta, Pepüca'i'isipaneni Ti'aitame mü'acacaüyari. ");
INSERT INTO hchNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Hicü Cauyumarie naimecü 'ita'inüataca neyani 'ariqueta 'ita'inüataque. ");
INSERT INTO hchNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Mericüsü Quesusi yu'utüma neyeyani Carereyapaitü, 'Iyari 'itürücariyacacu. Naisarie caniutamariva hepaüsitana. ");
INSERT INTO hchNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Tinicu'üquitanecaitüni vatuquiteta. Yunaitü 'aixüa metenicuxatacaitüni hepaüsitana. ");
INSERT INTO hchNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Hicü Nasaretita ninuani mataverixüsie. Yuyeiyari cu'erivatü, tuquita neutahani 'uxipiya tucarisie. Nanucuqueni tititerüvaque. ");
INSERT INTO hchNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Hicü xapa niuhuritüarieni Cacaüyari niuquieya maye'uxa, Quisariyaxi que müraca'utüa. 'Itaveraca nitaxeiya niuqui haque müpaü maine, ");
INSERT INTO hchNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Ti'aitame 'Iyarieya caneniuviya Caneniuhüritüani Niuqui 'aixüa manuyüne Nemüvacuxaxatüvanicü Memümamave. Caneneyenü'ani Nemüvaranayexürienicü Müme memüyuhiverie Yu'iyarisie, Yanemütivatahüavecü Müme memanutaxüriya, Quename me'utixünarie. Yanemütivatahüavecüta Müme memacücüpe, Quename me'anutaneniere, Nemüvaxünacü Müme memüviyarietüca, ");
INSERT INTO hchNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Nemüticuxatanicü, Tucari 'aye'a Ti'aitame müyuvaüriya Vahesie mieme, ne'utaitü. ");
INSERT INTO hchNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Hicü 'itacuicuieca xapa, 'iyetuirieca tiyuparevivame, mana nayerüni ti'üquitame 'uvenieyasie. Yunaitü tuquita memayetecai cui menixeiyacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Hicü nisutüani müpaü tivacuxaxatüvatü, 'Icü tucarisie naye'ani 'icü 'utüarica que maine, xe'i'eniecacu xeme. ");
INSERT INTO hchNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Yunaitü metenihecüatacaitüni me'i'enieca. Menihüxiyacaitüni niuqui visi manuyüne tetana mayeneicacaicü. Müpaü meniutiyuanecaitüni, Camüsü, 'icü Cuse catinu'aya. ");
INSERT INTO hchNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","'Ana müpaü tinivacühüaveni, Xüari 'icü niuquiyaricü xepünetecühüave, Tiyu'uhayemavame 'acu, sipasü 'acümana quena'anayehüva. Que temüte'u'enana Caperünaume que müreyü, 'enata 'aquiecarisie yaxeicüa quetineyurieneni, xepünetecühüaveni va'atü. ");
INSERT INTO hchNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Müpaü niutayüni, Niuqui caniseüyeni que nemütixecühüave, tixaxatame pücanaqui'eriva yuquiecarisie. ");
INSERT INTO hchNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Yuri nepaine, 'Ixaheri cuieyarisie yumüiretü viyurasixi meniu'uvacaitüni quepaucua 'Eriyaxi 'amuyeicacai, quepaucua muyuavisie müreunami haica viyari heimana 'ataxeime meseri, quepaucua haca mutave naisarie cuiepa. ");
INSERT INTO hchNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Müme vahesüa püca'utanü'arie 'Eriyaxi ni xeimesüa, Siruni cuieyarisie püta niutanü'arieni Sarepüta müracutevasie viyurasüa. ");
INSERT INTO hchNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Mücü meta, yumüiretü 'ameniu'uvacaitüni 'Ixaheri cuieyarisie cuiniyacü meca'itiyatücaitü quepaucua 'Eriseu 'amuyeicacai tixaxatametütü. Ni xevitü tüma püca'u'itiya mana quiecatari, Siriyatanaca püta caniu'itiyani Nahamani titevatü. ");
INSERT INTO hchNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Hicü me'i'enieca que müticuxatacai, meniuyeha'ani yunaitü tuquita memayetecai. ");
INSERT INTO hchNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Me'anucu'uca, vaquiecari yemurisie manierecü quiecari yeta 'ai heima meneihana mana meheicahüanique. ");
INSERT INTO hchNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","'Iya vahixüata heutayuneca caneyani. ");
INSERT INTO hchNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Mericüsü quiecarisie ninuani Caperünaume müracutevasie Carereya cuieyarisie. Mana 'uxipiya tucarisie tiniva'üquitüacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Müme menihüxiyacaitüni 'üquisicayacü, heiserie hexeiyatü mütaniucacaicü. ");
INSERT INTO hchNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Hicü tuquita nayecateitüni tevi cacaüyari müca'itiya 'iviyacacu. ");
INSERT INTO hchNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Carima niutahiva müpaü 'utaitü, 'Ai, que petati'uximatüa Quesusi Nasaretitanaca. Petasica'unaque cari pepunua. Ne nepümasimate que pemüpaicü. Cari 'ecü pepühücü Cacaüyarisie mieme pemupasie. ");
INSERT INTO hchNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Hicü Quesusi nitatieni müpaü 'utaitü, Hicü cayuvatü, queneuxüna. 'Iya cacaüyari 'ita'uimüraca tevi vahixüapa, nixüna caticuinitüaca. ");
INSERT INTO hchNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Yunaitü meniutimamani. Meteyucuxaxatüvatü müpaü meniutiyuanecaitüni, Que 'aneme niuqui pexeiya. Heiserie hexeiyatü nivarutate'ani cacaüyarixi memüca'itiyatüca türücariya hexeiyatü, menivatixünani. ");
INSERT INTO hchNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Naisarie quiecari 'aurie canicuxaxasivacaitüni, Quesusi que mütiyurienecai. ");
INSERT INTO hchNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Mericüsü tuquita vayeyaca Simuni quie ninuani. Hicü hüiya yeme niviyacaitüni Simuni varücaüya. Menitavavirieni miparevienicü. ");
INSERT INTO hchNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","'Auriena 'utaqueca, nitatieni hüiya. Hicü hüiya nihayeva. Yapaucua 'anucuqueca nivarutiparevietüyani. ");
INSERT INTO hchNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Hicü tau 'acayunecu, yunaitü memüvarexeiyacai tecuicuicate müireme cuiniyacü memütecucuyecai hesüana mecaniva'atüani. Yuxexuime vahesie 'utimeca nivaranayexürieni. ");
INSERT INTO hchNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Cacaüyarixi 'axa memü'anene canivaruta'aitüani memüvatixünacü yumüireme memütevacuinitüacai. Müme meniutihivacaitüni müpaü me'utiyuatü, 'Ecü Cacaüyari pecaninu'ayatüni. Quesusi varutate'aca cacaüyarixi, pücavapitüacai memütiniunicü memimaicaicü quename Cürisitu hücütücai heiserie mupitüarie. ");
INSERT INTO hchNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Hicü 'ucatarecu neyani macumavesie. Teüteri yumüiretü menicuvautüvecaitüni. Me'itaxeiyaca vaüriyarica menipitüacaitüni mücavacu'eirienicü. ");
INSERT INTO hchNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Mücü masi müpaü tinivarutahüave, Neuyeveca hipame quiecaritesie niuqui 'aixüa manuyüne nemücuxatanicü, que mütiyüni Cacaüyari ti'aitacacu, peuyevese nemüticuxatanicü. 'Ayumieme nepeyenü'arie. ");
INSERT INTO hchNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Cureya cuieyarisie tuquiteta catinicuxatanecaitüni. ");
INSERT INTO hchNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Mericüsü Quesusi Quenesareti haracunayari tesita niuvecaitüni ticuxatatü. Yumüiretü menisaipünacaitüni, me'i'eniecutü Cacaüyari niuquieya. ");
INSERT INTO hchNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Hicü canuva niuxeiya hutame ha tesita 'aheicame quesüteveiyamete vacanuva. Quesüteveiyamete me'anaticüneca yuvipi meni'ecuacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Hicü xeimesie cayerüca Simuni canuvayasie, nitavavirieni haracunasie 'esiva meutahanicü. Canuvasie yecaitü tiniva'üquitüacaitüni teüteri. ");
INSERT INTO hchNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Hicü yuxasica 'unüca, müpaü tinitahüave Simuni, 'Emeucatevasie queneuyeye'a, 'avipi mana queneucavivi quesüte pemüvaratixürienicü. ");
INSERT INTO hchNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Hicü Simuni müpaü tinitahüave, Ti'üquitame 'acu, tücacüta nai tepayequexi, tepüte'uta'uxitüa yacü xeicüa, tixaü tepücate'umi. Masi müya pemainecü, neneicaviviemücü vipi. ");
INSERT INTO hchNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Yamete'uyurieca menivaratixürieni quesüte cuini mieme meyupaümeme. Vipi nitasanirümecaitüni. ");
INSERT INTO hchNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Hicü yucupaniyeruma xeime canuvasie memüyetecai yumamacü menivarumaviya memacünecü memüvaparevienicü. Meniu'axüani, yucanuvate meniutihüniyaxüani hutame. 'Esivatücacu meniucayunixüani. ");
INSERT INTO hchNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Hicü nai tiuxeiyaca Simuni, Pecuru mütitevacai, niutitunumaqueni Quesusi hüxie müpaü 'utaitü, Ti'aitame, queneneuhayeva. Ne 'axa nepütiyuriene. ");
INSERT INTO hchNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Niutimani 'iya, yunaitü hamatüana memu'uvacai meniutimamani müya yupaümeme memüvaratixüricü quesüte. ");
INSERT INTO hchNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Yaxeicüata Severeu nivemama meniutimamani Cacuvu Vani Simunimatü memüte'uximayacai. Hicü Quesusi müpaü tinitahüave Simuni, Pepücamaca. Hicüsü 'uxa'atünita teüteri püta pecanivacuxeürimücü. ");
INSERT INTO hchNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Hicü canuva me'anatihapaca cuiepa, naime meteniucu'eirieni Quesusisie meteviyaque. ");
INSERT INTO hchNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Mericüsü xeime quiecarisie niuyeicacaitüni Quesusi. Ticuicame mana niucateitüni müca'itiyacai naitü heupünitü. Hicü Quesusi 'uxeiyaca, niutihüximaqueni, müpaü titavavirienique, Ti'aitame xüca pe'avaüriyani, pepüyüve pemünesi'itienicü. ");
INSERT INTO hchNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","'Iya yumama 'utaseraca nimayüani müpaü 'utaitü, Nepünevaüriya, pequeheu'itiyani. Yapaucua cuiniya nihayeva. ");
INSERT INTO hchNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Hicü Quesusi müpaü tinita'aitüani 'asimücatitahüavecü xeime. Müpaü tinitahüave, Quenemie mara'acame masixeiyacü. Pemu'itiyacü quetineutimava cumu Muisexi que mütiu'aitaxü pemütivatahecüatüanicü. ");
INSERT INTO hchNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Perusü masi cuini mieme catinicuxaxasivacaitüni hepaüsitana. Teüteri yumüiretü meniyutixexeürivacaitüni memi'enienicü memanayexürüvenicü cuiniya que memütehexeiyacai. ");
INSERT INTO hchNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Quesusi masi macumavesie neyeicacaitüni yutanenevienique. ");
INSERT INTO hchNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Mericüsü xeime tucarisie tini'üquitacaitüni. Mana menayetecaitüni Huriyusixi teüteriyari yuyeiyaricü memüpasiecai Pareseusixi memüteyuterüvacai, hipatüta Huriyusixi va'inüaricü memüte'üquitametetücai. Naime quiecaritesie Carereya cuieyarisie Cureya cuieyarisie meneyecüne Querusaremesieta. Cacaüyari türücariyaya canixuavecaitüni Quesusi müvaranayexürüvanicü. ");
INSERT INTO hchNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Hicü teüteri meniu'axüani me'ehanatü huriecame 'itarisie yecaime. Quesusi müvacateisie meni'atüaniquecaitüni hüxiena me'itenique. ");
INSERT INTO hchNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Meniyutatexieni meheutahaxüanique teüteri memüyumüirecaicü, 'ayumieme qui heima meneutimamaque. Racüriyuyari mevati'unaca, Quesusi hüxie meneicatuani tevi 'itari naime teüteri vahixüapapai. ");
INSERT INTO hchNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Hicü varuxeiyaca yuri que memüte'eriecai, müpaü niutayüni, 'Axa que pemütiuyuri pecatineuyehüviyarieni. ");
INSERT INTO hchNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Hicü Pareseusixi, müme meta 'inüaricü memüte'üquitametetücai, müme menisutüani müpaü meteyücühüavetü, Que püpaicü 'icü 'axa mutaine Cacaüyari hepaüsita. Quepaicü püyüve mütivareuyehüvirienicü 'axa mete'uyurieyu, Cacaüyari xeicüa püyüve. ");
INSERT INTO hchNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Quesusi retimaica que memüteyücühüavecai müpaü tinivarutahüave, Titayarisü müya xeteyücühüave yu'iyarisie. ");
INSERT INTO hchNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Tita masi caticuanive. Que ticuanive müpaü mütayünicü, 'Axa que pemütiuyuri pepüreuyehüviyarie, caticuanive masi müpaü mütayünicü, Quenanucuquexi quenecuyeicani. ");
INSERT INTO hchNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Peuyevese müpaü xemütemaicacü, Yuri Tevi que nemütiteva, heiserie nemexeiyacü cuiepa nemütivareuyehüvirienicü müme 'axa memüte'uyuri, 'ana müpaü tinitahüave huriecame, 'Ecü 'acu nemarahüave, quenanucuquexi, 'a'itari quenanucue'i, 'aquie quenemie. ");
INSERT INTO hchNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Yapaucua nanucuqueni vahüxie, titasie müracatei neicueni, yuquie neyani 'aixüa 'utaitü Cacaüyari hepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Hicü yunaitü menihüxiyacaitüni. 'Aixüa meniutiyuanecaitüni Cacaüyari hepaüsita. Cuini mieme metenimamacaitüni müpaü me'utiyuatü, Mamarivaveme tepuxei hicü. ");
INSERT INTO hchNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Mericüsü neyani. Tevi cuviyexunusie mieme mütiyetuiriyari niuxeiya Revi titevacame memüte'ayutituaya 'acaime. Müpaü tinitahüave, Nehesie quetiniviyani. ");
INSERT INTO hchNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Nai tiucu'eirieca, 'anucuqueca, hesiena tiniuviya. ");
INSERT INTO hchNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","'Ana Revi 'icuai niuvevieni yuquita Quesusisie mieme. Yumüiretü memüteyetuiriyari cuviyexunusie mieme, hipatüta teüteri metenicuacaitüni hamatüana. ");
INSERT INTO hchNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Hicü Pareseusixi, mümeta 'inüaricü memüte'üquitametetücai Pareseusixi vahesie memüteviyacai, müme meniniuquixiecaitüni müpaü metevacühüavetü hesüana miemete teyü'üquitüvamete, Titayaricutaxi müme cuviyexunusie mieme memüteyetuiriyari vahamatü 'axa teyuruvamete vahamatü xetecua'a xete'ie. ");
INSERT INTO hchNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Hicü Quesusi müpaü tinivarutahüave, Müme 'aixüa memüteheu'erie mepücaheiyehüva tiyu'uhayemavame, müme memütecucuye püta mecaneiyehüaca. ");
INSERT INTO hchNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ne que nemütinua, nepücanua nemüvata'inienicü müme heiseriemecü yamemütecahu. Müme 'axa memüteyurie püta nevata'inienique necaninuani, memütehayevacü 'axa que memüteyuriecai. ");
INSERT INTO hchNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Mericüsü müpaü metenitahüave, Vanisüa miemetexi teyü'üquitüvamete müixa mepüyuhaqui mepeyevaviri Cacaüyari. Pareseusixi vahesüa miemetexita yaxeicüa mepüteyurie. 'Ahesüa miemetexi masi titacutaxi metecua'a mete'ie. ");
INSERT INTO hchNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Hicü Quesusi müpaü tinivarutahüave, Que tiyüve müvahaquisitüani 'ixüaramete neüquiyapa mexi neneüqueme vasata 'uyeica. ");
INSERT INTO hchNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Tucari paye'ani quepaucua vasata manuhanieni neneüqueme. 'Anaque mepüyuhaquieni. ");
INSERT INTO hchNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Hicü 'üxasi hepaüsita ticuxatatü tinivaruti'üquitüatüyani müpaü 'utaitü, Tevi capitasana 'ixuriqui hecuame, mimanesiquitüanicü ye'ime. Me xüca müpaü tiuyurienique, hecuame pütasanequeyu, mühecuamatü müye'i 'axa pütiyuxexeiyaniqueyu. ");
INSERT INTO hchNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Mücü meta, caxie vinuyari pücacatuariva sixai müyeye'isie mücuanacü. Me xüca müpaü tiuyurienique cuanatü pitasanaqueyu sixai, pütayeuriniqueyu, sixaita peuyeveniqueyu. ");
INSERT INTO hchNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Masi caxie vinuyari sixai mühehecuasie püta canituarivani mücuanacü. ");
INSERT INTO hchNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Tevi meripai mieme 'aniecu 'anuti'ieme, cuaname pücaheu'imücüni. Müpaü paineni, Meripai mieme 'aixüa cana'aneni. ");
INSERT INTO hchNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Mericüsü 'uxipiya tucarisie mana türicu ma'iviyasie niuyemiecaitüni. Teyü'üquitüvamete müayari menivatihunatücüne. Yumamasie me'itüminatü menicuacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Hicü Pareseusixi hipatü müpaü meniutiyuane, Titayari müpaü xeteyurie que mücatitauniva yamütiyurienenicü 'uxipiya tucarisie. ");
INSERT INTO hchNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Quesusi müpaü tinivarutahüave, Cari hasuacu xepüca'ititerüvavave que mütiuyuri Raviri quepaucua meuhacamücücai, müme 'utümana memeu'uvacaita quepaucua memeuhacacuicucai. ");
INSERT INTO hchNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Cacaüyari quita caneutahani. Pa muva Cacaüyari hüxie mamanecai 'anaca'üca, nitacuani, nivaruminita müme 'utümana memeu'uvacai. Heiserie pücahexeiyacai miticuanicü, mara'acate xeicüa heiserie mepexeiyacai. ");
INSERT INTO hchNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Müpaüta tinivarutahüave, Heiserie necanexeiyani 'uxipiya tucari hepaüsitata Yuri Tevi nehücütütü. ");
INSERT INTO hchNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Mericüsü tavari 'uxipiya tucarisie tuquita heutahaca tini'üquitacaitüni. Tevi muva nayecateitüni mümamavaquicai yuserieta. ");
INSERT INTO hchNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Müme 'inüaricü memüte'üquitametetücai, Pareseusixita menihupiecaitüni, siparasü xüca 'uxipiya tucarisie 'enayehüanique tüma, me'utiyuatü, mücücü memitaxanetacü. ");
INSERT INTO hchNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Timaitü que memüteyücühüavecai, müpaü tinitahüave tevi mümamavaquicai, Quenanucuquexi, tahixüata queneutaquexi. 'Anucuqueca mana niutaqueni. ");
INSERT INTO hchNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Hicü Quesusi müpaü tinivarutahüave, 'Ipaü nepütixecu'ivaviya. 'Uxipiya tucarisie titaunivani para 'aixüa mütiyurienenicü, nusu 'axa mütiyurienenicü püta pütaunivani. Titaunivani para tevi mütavicueisitüanicü, nusu mica'unacü püta pütaunivani. ");
INSERT INTO hchNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Yunaime varanuxeiyatüyaca, müpaü tinitahüave tevi, 'Amama queneutasera. Müpaü tiuyuriecu mamaya 'aixüa 'anetü nayani. ");
INSERT INTO hchNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Müme cuini mieme meteniuyeha'ani. Menisutüani metecuxatatü queri memiyurieniquecai Quesusi. ");
INSERT INTO hchNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Mericüsü 'ana hürisie neutiyune yutanenevienique. Xei tücari nenevieri nipitüacaitüni yucacaüyari. ");
INSERT INTO hchNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Hicü 'ucatarecu, yu'aurie nivarutahüave yuhesüa miemete teyü'üquitüvamete. Vasata nivaranuyeteüxü tamamata heimana yuhutame. Nü'arisixi tinivaruterüva müme ");
INSERT INTO hchNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simuni 'arique Pecuru mütiterüvaxü, 'Atürexi Simuni 'ivaya, Cacuvu, Vani, Piripe, Parüturume, ");
INSERT INTO hchNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateu, Tumaxi, Cacuvu 'Aripeu nu'aya, Simuni serutisita mütitevacai, ");
INSERT INTO hchNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Cura Cacuvu nu'aya, Cura 'Isicariutitanaca 'ariqueque miyetua. ");
INSERT INTO hchNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Hicü vahamatü 'anacayaca, macuveresie niutaqueni. Yumüiretü hesüana miemete teyü'üquitüvamete, cuini mieme yumüiretü teüterita naisarie Cureyasie Querusaremesie memeyecü, hipatü racusita memeyecü Tiru 'aurie Siruni 'aurie, mana meniu'axüani memi'enienicü, memanayexüriyanicü cuiniya que memütehexeiyacai. ");
INSERT INTO hchNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Müme cacaüyarixi 'axa memü'anene memüvanücai mepanayexüriya. ");
INSERT INTO hchNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Teüteri yunaitü menimayüacucaitüni türücariya müvayeneicacaicü hesiena varanayexürüvatü yunaime. ");
INSERT INTO hchNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Mericüsü yuhesüa miemete teyü'üquitüvamete vaxeiyatü müpaü niutayüni, 'Aixüa xecani'itüarieca xeme xemümamave Cacaüyari xecanexeiyani tixe'aitüvametüme. ");
INSERT INTO hchNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","'Aixüa xecani'itüarieca xeme hicü xemeuhacacuicu. Xecanitihuxacuni. 'Aixüa xecani'itüarieca xeme hicü xemutisuana. Xecaniutinavecuni. ");
INSERT INTO hchNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","'Aixüa xecani'itüarieca quepaucua teüteri memüxe'uxive'erie, quepaucua memücaxenaqui'erie yuhesüa, quepaucua 'axa memutiyuane xehepaüsita, quepaucua memüxexani'erie 'axa xemü'anene me'utiyuatü, Yuri Tevisie xemüteviyacü. ");
INSERT INTO hchNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Xequeneyutemamavieca vaüca 'iya tucarisie, xequeteneuye'ani. Vaüca taheima mieme xecana'ivacuni. Va'uquiyarima yaxeicüa mepüvaruyuri texaxatamete Cacaüyari niuquieya memücuxatacai. ");
INSERT INTO hchNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Masi xüa 'ui, xeme xemüxicusixi. 'Ariri yunaqui'eriya xecanaye'atüani. ");
INSERT INTO hchNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Xüa 'ui xeme hicü xemühuxa. Xepeuhacacuicuni. Xüa 'ui xeme hicü xemutinave. Xepüyuhiverieca xeputisuanani. ");
INSERT INTO hchNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Xüa 'ui xeme quepaucua yunaitü teüteri visi memutiyuane xehepaüsita. Va'uquiyarima yaxeicüa mepüvaruyuri texaxatamete memüte'itavacai. ");
INSERT INTO hchNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Masi müpaü nepütixecühüave xeme xemü'enana, xequenivanaqui'erieca müme memüxe'aye'unie. 'Aixüa xequenivayurieca müme memüxe'uxive'erie. ");
INSERT INTO hchNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Müme 'axa memutiyuane xehepaüsita, vahepaüsita 'aixüa xequeneutiyuaneni xeme. Xequeneyunenevieca müme memüxesevixima vahesie mieme. ");
INSERT INTO hchNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Que mü'ane 'a'aurita mümasiheutivani, ta'aurie quenaniere tapata mümasiheutivanicü. Que mü'ane mümasinavairieni 'a'ücari, pepüca'inenaca 'acamixata mümasinavairienicü. ");
INSERT INTO hchNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Que mü'ane tixaütü mümatiutavaviri, quetineupitüa, que mü'ane 'apini mümatinavairieni, pepüca'iviyani. ");
INSERT INTO hchNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Que tixenaque, teüteri müya memüxeyurie xeme. Que mütixenaque xeme, mücü canixe'inüaritücamücü, müya xemüvayurienicü hipame meri. ");
INSERT INTO hchNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Xücate xevanaqui'erieca müme memüxenaqui'erie, titacü 'aixüa xetecuxaxasivani. 'Axa teyuruvamete mecanivanaqui'erieca müme memüvanaqui'erie. ");
INSERT INTO hchNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Xücatari 'aixüa xevayurieca müme 'aixüa memüxeyurie, titacü 'aixüa xetecuxaxasivani. 'Axa teyuruvamete yaxeicüa mepüteyurie. ");
INSERT INTO hchNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Xücatari xetevaruniütüani müme mete'apicame xemü'erie, titacü 'aixüa xetecuxaxasivani. 'Axa teyuruvamete mepüyuniütüva tavari memüte'apiniyariecacü. ");
INSERT INTO hchNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Masisü xequenivanaqui'erieca müme memüxe'aye'unie, 'aixüa xequeteneyurieca, xequeneyuniütüaca 'asixecateyu'iyaritüatü. Müpaü xeteyurietü cuini mieme xecatena'ivacuni, que mü'ane taheima macave nivemama xecanihümetücacuni. Mücü 'aixüa pütiuca'iyari müme pamüpariyusi memücateyupitüva vahesie mieme, müme 'axa memüteyurie vahesie miemeta. ");
INSERT INTO hchNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Xequeteneyucanenimayaca, xe'uquiyari que mütiyucanenimaya. ");
INSERT INTO hchNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Hipame vahesie xüca xecate'ahüpani, xehesietari pücarahüivani. Xüca xecateyuxanetani xemetari xepücaxanesieca. Xüca xecavaranutaxürüvani, xemetari xepüca'anutaxüriyani. Xüca xetevareuyehüvirieca, xemetari xepüteheuyehüviyarieni. ");
INSERT INTO hchNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Xüca xevamicuani, xemetari xepümiquieni. 'Aixüa ti'inüasiecame 'anucapünariecame 'anutacasiecame 'anacaxürüveme xepümiquieni. Que xemüte'u'inüata, müpaüta xepüte'inüasiyarieni. ");
INSERT INTO hchNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Mericüsü 'icü 'üxasi hepaüsita ticuxatatü tinivaruta'üquitüani müpaü 'utaitü, Macüpe que tiyüve menuhana xeime macüpe. Yuhutatü mecateheucaxürieni mevatixavasie. ");
INSERT INTO hchNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Que tiyüve ti'üquitame ma'iva müti'üquitüarie. 'Aye'atüarieme, que mü'ane müti'üquitüapaü timaivetü canayeimücü. ");
INSERT INTO hchNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Titayari petixeiya xasi 'a'iva hüxita meutavivi, pecahe'erivatü queuruvi 'ahüxita meutave. ");
INSERT INTO hchNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Quepaütütü petiyüve müpaü pemütitahüavecü 'a'iva, Neuxei ne'iva, nepivaye'itieni xasi 'ahüxita meutavivi, pe'utaitü, peca'ixeiyatü queuruvi 'ahüxita meutave. Yacüsü peputaine xeicüa. Quenivaye'itie merie mücü queuruvi 'ahüxita meutave, 'ana 'aixüa 'anemecü peheunieretü pecanayeimücü pemivaye'itirienicü xasi 'a'iva hüxita meutavivi. ");
INSERT INTO hchNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Cüyeyari pücanarani, xüca 'icuaxiyari cüxaisietücani. Mücü meta, cüyeyari pücacüxaisie xüca 'icuaxiyari 'aixüa 'aneneni. ");
INSERT INTO hchNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Xexuitü cüye yu'icuaxicü canimasiücüni. Xuya püca'inüive narüca. Tupiriya müxuyatücasie püca'itixexeüriva caxie. ");
INSERT INTO hchNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Tevi 'iti'utame tita 'aixüa müti'anene yu'iyarisie, nivayehanimücü tita 'aixüa müti'anene. Tevi 'axa mütiyuriene püta 'iti'utame tita 'axa müti'anene, nivayehanimücü tita 'axa müti'anene. Que müranayuhayeva ra'iyari tihünecacu, müpaü tinicuxatamücü yutetacü. ");
INSERT INTO hchNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Titayaricutaxi Ti'aitame, Ti'aitame 'acu xenetecühüave, 'asixecateyurietü que nemütixecühüave. ");
INSERT INTO hchNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Yunaitü nehesüa memü'axe, neniuqui memü'enie yametecahutü, que memü'anene nepütixetaxatüani. ");
INSERT INTO hchNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Tevi qui mutavevipaü mecani'aneneni. Heucatevame vati'ineca, tetesiepai neitivevieni simiyenituyari. 'Ana ha nivayeneni, quisie niuquexüani, peru niuyutatexieni 'ivatayuitüanique. 'Aixüa 'anemecü müveviyacaicü pücavatayua. ");
INSERT INTO hchNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Perusü que mü'ane münesi'enie yacaticamietü, mücü xeime tevi qui mutavevipaü cani'aneni. Cuiepa 'acaime niutavevieni xeicüa, simiyenituyari püca'utavevi. 'Ana hesiena niuquexüani ha, xei mieme necaina. Carima niucaveni qui. ");
INSERT INTO hchNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Hicü 'inüca 'icü niuqui naime teüteri me'i'eniecu, Caperünaume neyani. ");
INSERT INTO hchNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Mericüsü cuya 'aniuyeicacaitüni xei sienituyari cuyaxi müvaravitücücai, ti'uximayatame nexeiyacaitüni minaqui'eriecai. 'Iya tinecuyecaitüni canemüximecaitüni. ");
INSERT INTO hchNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Hicü cuya, 'u'enaca Quesusi hepaüsita, nivarenü'ani Huriyusixi teüteriyari va'uquiyarima memeita'inienicü 'umamiecü menayehüanicü ti'uximayatame. ");
INSERT INTO hchNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Müme Quesusisüa me'u'axüaca cuini mieme mecateni'iniecaitüni müpaü me'utiyuatü, 'Aixüa caniyümücü pemeiparevienicü, hesiena catininaqueni. ");
INSERT INTO hchNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Cataninaqui'erieca tanaime tame, tuqui cataniutavevirieni yücümana. ");
INSERT INTO hchNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Hicü Quesusi va'utüma neyani. Yateva 'umiecacu, cuya yuhamicuma nivarutanü'ani yamemüte'itahüavecü, Ti'aitame pepücati'a'uxitüaca. Ne 'aixüa nepüca'ane 'ecü pematahanicü nequita. ");
INSERT INTO hchNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","'Ayumieme 'ahesüa nepücahetüa, 'aixüa neca'aneme ne'erietü 'ahesüa nemümiecü. 'Ecü müpaü xeicüa quenetayüqui, panayehüiyani ti'uximayatame. ");
INSERT INTO hchNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nesü necatini'aitüarieca necuyatütü cuyaxita nepütiva'aitüvame. Xüca müpaü netitahüave xeime, Quenemie, mücü püyemieni, xeimeta xüca müpaü netitahüave, Quenaye'a, mücü canayeimücü, xüca müpaü netitahüave nehesüa mieme ti'uximayatame, 'Ipaü quetineyurieneni, müpaü pütiyurieneni. ");
INSERT INTO hchNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Hicü Quesusi 'i'enieca niuquieya, niuhüxiyani. Ta'aurie 'aveca müpaü tinivarutahüave teüteri memeveiyacai, Müpaü nepütixecühüave, ni 'Ixaherisixi vasata 'icüpaü 'aneme nepücahetaxeiyave yuri ti'eriecame. ");
INSERT INTO hchNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Hicü müme memeyenü'arie yu'utüma mehecüneca, quitana me'u'axüaca, meneitaxeiya ti'uximayatame 'aixüa reu'eriecame. ");
INSERT INTO hchNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Mericüsü 'arique neyani quiecari Naini müracutevasiepaitü. Hesüana miemete teyü'üquitüvamete meniteütacaitüni, hipatüta teüteri yumüiretü. ");
INSERT INTO hchNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Quiecari quitenie heutahaximecacu, müqui nivayecueiyani. Müqui varusieya hücüame nexeiyacaitüni 'iya yunivetüme, cünaya meripai 'umücu. Quiecatari yumüiretü meniteütacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Hicü Ti'aitame 'ixeiyatü nitinenimayata. Müpaü tinitahüave, Pepüca'utasuacani. ");
INSERT INTO hchNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Mana 'uyacu, 'imayüacu müqui cacunieya, müqui cuecuevemete meniti'uni. 'Iya müpaü niutayüni, Temaicü 'acu, quenanucuquexi nepaine. ");
INSERT INTO hchNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Tevi mümüquicai nanucuyerüni niutiniutüyani. Quesusi niyetuani varusieyasüa. ");
INSERT INTO hchNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Hicü yunaitü meniutimamani. 'Aixüa meniutiyuanecaitüni Cacaüyari hepaüsita müpaü me'utiyuatü, Tixaxatame mütürücaüye tasata caninuani. Cacaüyari canisutüani tasi'üviyatü yuteüterima. ");
INSERT INTO hchNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Hicü que mütiuyuri canicuxaxasivacaitüni naisarie Cureya cuieyarisie 'aurienata. ");
INSERT INTO hchNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Mericüsü Vanisüa miemete teyü'üquitüvamete metenitaxatüani Vani nai que mütiuyü hepaüsita. 'Ana Vani yu'aurie varutahüaveca yuhutame yuhesüa miemete teyü'üquitüvamete, ");
INSERT INTO hchNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ti'aitamesüa nivarenü'ani müpaü memutiyuanenicü, 'Ecü petihücü 'upemamiecai xeniu, nusu xeime püta tepücuevieca. ");
INSERT INTO hchNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Hesüana me'u'axüaca müme, müpaü metenitahüave, Vani Ti'üyame 'ahesüa cataneyenü'ani müpaü 'utaitü, 'Ecü petihücü 'upemamiecai xeniu, nusu xeime püta tepücuevieca. ");
INSERT INTO hchNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","'Anatütü Quesusi yumüireme nivaranayexürieni, müme cacaüyarixi 'axa me'aneneme memüvarexeiyacai, hipame meta müireme cuiniyacü memü'uximatüariecai. Memacücüpecai yumüireme nivarupitüani memanutanenierenicü. ");
INSERT INTO hchNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Hicü müpaü tinivarutahüave niuqui tuayamete, Xequeneuhuni, xequenetaxatüa Vani tita xemüte'uxei tita xemüte'u'eni hepaüsita mieme, memacücüpe que memüte'anutaneniere, huriecate que memüte'anucu'uve, müme memüca'itiyatücatei cuiniyacü memeucupüpünicai müme que memüte'u'itiya, memücaheu'enanacai hicü que memüteheu'enana, müquite que memüte'anucu'uitüariva, memümamave niuqui 'aixüa manuyünecü que memütecuxaxatüariva. ");
INSERT INTO hchNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Mücü meta, 'aixüa cani'itüarieca que mü'ane müca'ucunuitüarieve necümana. ");
INSERT INTO hchNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Hicü Vanisüa miemete niuqui tuayamete mehecünecu, nisutüani Vani hepaüsita tivacuxaxatüvatü teüteri, müpaü 'utaitü, Tita xetehecu'ixüari macumavesie. Haca 'ecapa mücuyuitüarieximecai xepuxei va'atü. Tixaü xüari. ");
INSERT INTO hchNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Peru tita xetehecu'ixüari. Tevi 'ixuriqui müyumeni manacatücücai xepuxei va'atü. Tixaüsü, müme visi mü'anene memanacatücü xicusixi vahepaü memüyüa, müme te'aitamete vaquita mepayetei püta. ");
INSERT INTO hchNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Titasüari xetehecu'ixüari. Tixaxatame xepuxei va'atü. Hü, müpaü nepütixecühüave, tixaxatame xepuxei, texaxatamete que mü'ane masi cuini mieme mütiyüve, que mü'ane müvara'iva hipame texaxatamete xepuxei. ");
INSERT INTO hchNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","'Icü canihücütüni 'utüarica mixata müpaü 'utaitü, Camü neniuqui tuayame. Nepenunü'ani 'ahüxiepai. Micuha'aritüanicü 'ahuye Pecanuavecacu cuxi. ");
INSERT INTO hchNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","'Ipaü nepütixecühüave, Müme 'ucari vahesie memütinunuiva ni xevitü pücave'eme Vanipaü. Perusü que mü'ane masi yemecü mücave'eme müme Cacaüyari mütiva'aitüa vasata, mücü pe'iva Vani ve'emetütü. ");
INSERT INTO hchNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","'Ipaü nepaine, teüteri, mümeta cuviyexunusie mieme memüteyetuiriyari yunaitü Vani me'u'enieca metenihecüatacaitüni Cacaüyari hepaüsita heiserie que mürexeiya, quepaucua memuca'üyarie Vanisüa. ");
INSERT INTO hchNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Peru Pareseusixi, hipatüta 'inüari niuquiyari memümate, mücü menitixani'erieni Cacaüyari que mütiyurieniquecai vahesie mieme. Vanisüa mepüca'uca'üyarie. ");
INSERT INTO hchNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","'Ayumieme nepaine, hicü miemete titapaü mete'anenemete netivaxata. ");
INSERT INTO hchNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Türi vahepaü mecani'aneneni quiecari hixüapa memütitei me'uyutihivivatü müpaü me'utiyuatü, Cari yacü xeicüa tepüxecürautaviriecai, Xepücaneitüvecai. Tepütahiveriecai xehesie mieme, Xepüca'utisuanacai. ");
INSERT INTO hchNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Vani Ti'üyame caninuani pa cacua'atü caxie vinuyari caye'etü, xeme 'ayumieme müpaü xeputiyuane, Cacaüyari 'axa mü'ane pinü'ü. ");
INSERT INTO hchNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ne Yuri Tevi nehücütütü necaninuani neticua'atü necu'ienetü, xeme 'ayumieme müpaü xeputiyuane, 'E'e, 'iya tevi 'icuaicü xeicüa püyüane, vinucü xeicüa püyüane, püvanaqui'erie müme cuviyexunusie mieme memüteyetuiriyari 'axa teyuruvamete yunaime. ");
INSERT INTO hchNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Perusü yunaitü yuricü memütemaivave que memüteyurie canimasiücüni heiserie que mürexeiya Cacaüyari timaivetü. ");
INSERT INTO hchNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Mericüsü Pareseusixi xevitü nita'inieni hesüana müticuanicü. Pareseu quita heutahaca mana nayerüni. ");
INSERT INTO hchNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Hicü 'uca mana mequiecametücai 'axa mütiyuruvametücai, tiutamarieca Pareseu quita mayecateicü Quesusi, caninuani tete puteyayari 'ahanatü visi mu'üacü hüneme. ");
INSERT INTO hchNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Quetateya 'aurie niutaqueni 'utasuatü. 'Ucaiya nicaxürüvecaitüni quetateyasie, yücüpacü nitivasiüxa. Niti'iseni quetateyasie, visi mu'üa nitivirieni. ");
INSERT INTO hchNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Hicü 'iya Pareseu mita'ini müpaü tiniyücühüavecaitüni yu'iyarisie, Cari 'icü xüca yuricü tixaxatametünique, pimaicaqueyu 'icü 'uca micumayüaxime, que mütiyuriene pütimaicaqueyu, 'axa tiyuruvame que mütihücü. ");
INSERT INTO hchNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Hicü Quesusi müpaü tinitahüave, Simuni 'acu, 'esiva nepümasitahüavequeyu. 'Iya tita'ei, 'Au, Ti'üquitame. ");
INSERT INTO hchNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Müpaü niutayüni, Mericüsü heiva neuyevecaitüni yuhutatü memüte'ipitüanicü xeime, meripai que mütivaruniütüa. Xevitü 'auxüme sienituyari 'inüariyari ni'üitüaniquecaitüni, xevitüta huta teviyari heimana tamamata 'inüariyari ni'üitüaniquecaitüni. ");
INSERT INTO hchNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Tixaü memücatehexeiyacaicü memüte'ipitüanicü, 'iya tinivareuyehüvirieni yuhutame. Mericüte, que mü'ane müme masi pinaqui'erie tevi mütivareuyehüviri. ");
INSERT INTO hchNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simuni müpaü tinita'eiya, Xüari que mü'ane masi vaücavamecü müreuyehüviyari, mücü masi vaüca ninaqui'eriecamücü. Quesusi müpaü rehüave, Heiseriemecü pepüti'acühüave. ");
INSERT INTO hchNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Hicü ta'aurie 'aveca, 'uca 'uxeiyaca, müpaü tinitahüave Simuni, Queneuxeiya 'icü 'uca. Ne 'ahesüa nenuacu 'aquita, 'ecü ha pepücanesi'uhanitüa nequetate nemütihauxinicü. 'Iya püta yu'ucaicü nitihaviyatüyani nequetate, yücüpacü nitivasiüxa. ");
INSERT INTO hchNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","'Ecü penesitapatü pepücanesi'utavaüritüa. 'Iya püta ne'atahacu hicüque pücatihayevave nesicu'isevetü nequetatesie. ");
INSERT INTO hchNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","'Ecü pepücanesi'ucaviri nemu'usie. 'Iya püta visi mu'üa pünesi'utiviri nequetatesie. ");
INSERT INTO hchNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","'Ayumieme nepümaticühüave, vaüca que mütiyucanaqui'erie canimasiücüni que müreuyehüviyarie 'axa tiuyurieca vaücava. Que mü'ane 'esiva xeicüa müreuyehüviyari, mücü 'esiva xeicüa tiniyucanaqui'erieca. ");
INSERT INTO hchNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Hicü müpaü tinitahüave 'uca, 'Axa que pemütiuyuri pepüreuyehüviyarieri. ");
INSERT INTO hchNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Hicü hipatü 'auriena mematecai müpaü meteniyutihüavetücüne yu'iyarisie, Que püpaicü 'icü mütivareuyehüviri 'axa que memüte'uyuri. ");
INSERT INTO hchNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Masi 'iya müpaü tinitahüave, Yuri pemütiuta'ericü peputavicueisitüarie. 'A'iyarisie peca'uximatüarietü quenemie. ");
INSERT INTO hchNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Mericüsü 'arique canicuyeicacaitüni quiecari 'emüyeyeusie 'esimüyeyeusie. Nicuxatacaitüni niuqui 'aixüa manuyüne, tivacuxaxatüvatü que müti'ane Cacaüyari ti'aitametücacu. Tamamata heimana yuhutatü hamatüana meniu'uvacaitüni, ");
INSERT INTO hchNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","hipatüta 'ucari memanayexüriya cacaüyarixi 'axa memüteyurie mevarunücu, metecucuyecu. Xevitü müme Mariya Mararatanaca catinitevacaitüni, meripai muxünarie cacaüyarixi 'axa memü'anene me'inücacu 'atahutatü, ");
INSERT INTO hchNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","xevitüta Vana catinitevacaitüni Susa mü'üyayatücai, mücü Susa mühüritüariecai Herurexi mütimicuanicü, xevitüta Susana, hipatüta yumüiretü. Menivapareviecaitüni müme yupinitecü. ");
INSERT INTO hchNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Mericüsü yumüiretü teüteri hesüana meniyuxeüriecaitüni, müireme quiecaritesie meheyecüneca. Hicü 'üxasi hepaüsita ticuxatatü tinivaruti'üquitüatüyani müpaü 'utaitü, ");
INSERT INTO hchNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Ti'ivivame neyani 'imüari ca'ivienique. Mericüsü 'imüari 'ivienecacu, hipatü huye tesita niucaxürieni niutiquesinire. Viquixi taheima memu'uva menicucuani. ");
INSERT INTO hchNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Hipatüta niucaxürieni 'ayeparisie. 'Utineca niutivani müca'acuhavirecaicü. ");
INSERT INTO hchNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Hipatüta niucaxürieni xuyasata. Hamatüana 'utinexüaca xuya, nenucanani. ");
INSERT INTO hchNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Hipatüta niucaxürieni 'aixüa müracu'anesie. 'Utineca niutixuavere xei sienituyari payeixüa. Müpaü 'utayüca carima müpaü niutayüni, Xaütü netü mu'enaxü que'u'ena. ");
INSERT INTO hchNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Hicü hesüana miemete teyü'üquitüvamete menicu'ivaviyacaitüni queri haine mücü 'üxasi. ");
INSERT INTO hchNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Müpaü niutayüni, Xeme xecanipitüarieca xemimaicacü tita mütiuti'aviesiecai, xemütemaicacü que müti'ane Cacaüyari ti'aitametücacu. Hipatü püta 'üxasicü xeicüa mecanipitüarieca, para meheunenieretü memüca'ixeiyacü, meheu'enanatü memüca'i'enienicü. ");
INSERT INTO hchNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","'Üxasicü 'ipaü catinimasiücüni. 'Imüari, Cacaüyari niuquieya canihücütüni. ");
INSERT INTO hchNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Huye tesita miemete, müme mecanihümetüni memü'enana, peru cuitü cani'axeni Cauyumarie, va'iyarisie ninavani niuqui capa me'utavicueisitüarienicü yuri mete'uta'eriecaxüame. ");
INSERT INTO hchNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","'Ayeparisie miemete, müme mecanihümetüni memitanaqui'erie niuqui meyutemamavietü me'u'enanaca, peru müme mepücahananatüca. Yareutevitü yuri meteni'erieca, peru quepaucua memüta'inüasieni mecanicunuitüariecuni. ");
INSERT INTO hchNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Xuyasata mucaxüri, müme mecanihümetüni memü'enana, peru 'iyaritüaricacü tuminicü hicü mieme tucari naqui'eriyayacü meyüatü mecananucanaca mepüca'aye'axüani. ");
INSERT INTO hchNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","'Aixüa müracu'anesie miemete, müme mecanihümetüni niuquisie memüteviya 'aixüa 'iyaricü meyuvaüriyatü me'u'enanaca. Müme meniutixuxuavereni mete'uca'enivatü. ");
INSERT INTO hchNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Cüxeme 'utaiyame püca'iti'avieta, xarita pücaheicayeni, 'utatüa pücaheitayeni, masi vapaitü neitiyemücü, müme mematahaxüaxime hecüariyaya memüxeiyacü. ");
INSERT INTO hchNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Naitü mütiuti'aviesie masiücütü nayeimücü, naitü müranucanami nitamarivamücü, masiücütü nayeitüariemücü. ");
INSERT INTO hchNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","'Ayumieme xequeneyucuerivayurieca que xemüte'enana. Que mü'ane tixaütü mürexeiya canimiquieca. Que mü'ane tixaü mücarexeiya, tita rexeiyame mütiyu'erie catininavaiyariemücü. ");
INSERT INTO hchNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Mericüsü varusieya 'ivamama meniu'axüani hesüana. Meniyutatexieni me'itahüaveque, teüteri yuvaücavatü memayetecaicü. ");
INSERT INTO hchNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Hicü müpaü tiniutahüavarieni, 'Avarusi 'a'ivama tacua meniti'uni memasixeiyacutü. ");
INSERT INTO hchNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Mücü müpaü tinivacühüaveni, 'Ime Cacaüyari niuquieya memü'enie yamemütecahu, 'ime mecanihümetüni nevarusi ne'ivama. ");
INSERT INTO hchNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Mericüsü heiva canuvasie nicayerüni, hesüana miemete teyü'üquitüvamete vahamatü. Müpaü tinivarutahüave, Haracuna 'anutaüye tepanucüne. Mana menecüne. ");
INSERT INTO hchNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Hapa me'uhucacu 'iya neucuni. Hicü 'eca cüsituiyari muva carima nacaneni, haracunasie niuquexüani. Canuva tahünirümecacu mepucuerivayüa. ");
INSERT INTO hchNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Hicü menenutahütüani müpaü me'utiyuatü, Ti'üquitame, Ti'üquitame, tepeuyevexime. Quesusi 'anucuqueca nitatieni 'eca hamevari meta. Neunuani, cayuvatü niutamare. ");
INSERT INTO hchNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Hicü müpaü tinivarutahüave, Queri yuri xete'erie. Meheumamatü meniuhüxiyacaitüni müpaü meteyücühüavetü, Quesü püpaicü 'icü. Ni'aitüaca hamevari ha, yapüticamie que maine. ");
INSERT INTO hchNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Hicü Catarenasixi vacuieyarisie meneta'axüani canuvasie meyetetü, Carereya 'anutaüyesie. ");
INSERT INTO hchNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Heucaqueximecacu cuiepa, tevi nenucunaque mana müquiecametücai, cacaüyarixi 'axa memü'anene meminücai müixa. 'Ayumieme mücü 'ixuriquite püca'anacatücücai, quita püca'ayecatei, masi teuquiyasata niuyeicacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Quesusi 'uxeiyaca, 'utahivaca nativeni hetüana müpaü tiuhivatü, Que peneti'uximatüa Quesusi, Cacaüyari taheima macave pemünu'aya. Nepümasivaviri cuerietü, penücahürixüa nesi'uximatüaca. ");
INSERT INTO hchNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Müpaü niutayüni mücü, Quesusi tita'aitüacu cacaüyari müca'itiya, mixünacü tevi. Müixa viyari niviyacaitüni cacaüyari 'axa mü'ane. Tevi nanutahüivacaitüni tepüacü 'acuvietü yumamasie yü'ücasie. 'Ititequetü tepüa carenayari nivayeyeicaitüni macumavesiepaitü cacaüyari 'axa mü'ane 'inücacu. ");
INSERT INTO hchNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Mericüsü Quesusi müpaü tinita'ivaviya, Que petiteva 'ecü. 'Iya yumüiretü cacaüyarixi meminücaicü müpaü niutayüni, Xei Vaxayari netinitevaca. ");
INSERT INTO hchNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Mümeri cuerietü vaücavamecü menivaviriecaitüni Quesusi mücavatanü'anicü meucatevasie memüyehucü. ");
INSERT INTO hchNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Mericüsü mana hura yumüiretü tuixuri metenicuatüvecaitüni yemuritüa. Menitavavirieni cacaüyarixi müpaü mütivapitüanicü memüvativiyacü tuixuri. Yacatinivarupitüani. ");
INSERT INTO hchNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Hicü cacaüyarixi 'axa memü'anene me'ixünaca tevi, menivarutiviya tuixuri. Hicü tuixuri yunaitü meniutinausa. 'Axa 'anecüa meneucanausaxüaximecaitüni, haracunapa meneuxürieni. ");
INSERT INTO hchNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Hicü tuixuri vahüvemete me'uneniereca que mütiuyü meniyuta'unaxüani. Quiecarisie metenicuxatacaitüni quiecari 'aurie meta. ");
INSERT INTO hchNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Mana meneyecüne me'ixeiyaque que mütiuyü. Quesusisüa me'u'axüaca tevi meniutaxeiya cacaüyarixi memixünaxü. 'Aixüa reuquemaritü Quesusitüa nacateitüni heuyumarietü. Meniutimamani. ");
INSERT INTO hchNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Hicü memunenierixü metenivarutaxatüani que mütiutavicueisitüarie tevi cacaüyarixi meminücai. ");
INSERT INTO hchNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Hicü yunaitü Catarenasixi vacuie memütamacai meyumüiretü menitavavirieni vahesüa müyemiecü. Cuini mieme mecatenimamacaitüni. Quesusi canuvasie cayerüca caneyani yu'utüma. ");
INSERT INTO hchNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Hicü 'iya tevi cacaüyarixi memixünaxü nitavavirieni hamatüana mücuyeicanicü. Masi Quesusi neiyenü'ani müpaü 'utaitü, ");
INSERT INTO hchNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","'Aquie quenemie. Mana quetinivaretaxatüa nai Cacaüyari que masi'uyuri. Neyani naisarie quiecarisie ticuxatatü que mütitavicueisitüa Quesusi. ");
INSERT INTO hchNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Mericüsü Quesusi 'anutaüye heta'acu, yumüiretü teüteri menitavaüritüani me'icuevietü. ");
INSERT INTO hchNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Hicü tevi mana caninuani Cairu titevatü. 'Iya tuqui va'üya canihücütücaitüni. Quesusitüa 'ativeca vaüriyarica nitavavirieni quitana müyemiecü. ");
INSERT INTO hchNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Xeücüame neixeiyacaitüni yunive 'ucatüme, tamamata heimana huta viyari yacütütü hücame. Nemüximecaitüni. Mericüsü muva 'uyemiecacu yumüiretü teüteri menisaipünacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Hicü 'uca mana niuyeicacaitüni. Tamamata heimana huta viyari niyuriecaitüni, xuriyaya cacaneunuavecaitüni. Teyu'uhayemavamete vahesüa yupini tiniutixütüacaitüni naime, ni xevitü pücayüvecai menayehüanicü. ");
INSERT INTO hchNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Hicü Quesusi varita 'uyemietü 'ücarieya niumayüani. Yapaucua neunuani xuriyaya mi'axiyacai. ");
INSERT INTO hchNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Hicü Quesusi müpaü niutayüni, Quepaicü pünesi'umayüa. Yunaitü meyucu'imavacacu, müpaü niutayüni Pecuru, Ti'üquitame, yunaitü teüteri 'a'aurie mepüyucuxeüri mepümasisaipüna, quepai pünesi'umayüa, peraine. ");
INSERT INTO hchNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Quesusi müpaü niutayüni, Xevitü pünesi'umayüa. Türücariya nehesie vayeneicacacu yanepütimaicai. ");
INSERT INTO hchNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Hicü 'uca yatimaitü 'avie mücayüanecaicü, 'utayüyüacatü ninuani. Hetüana 'ativeca yunaime teüteri vahürüpa nitaxatüani que mütimayüa, yapaucua que müranayehüiya. ");
INSERT INTO hchNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Quesusi müpaü tinitahüave, Nenive yuri pemütiuta'ericü pecaniutavicueisitüarieni. 'A'iyarisie peca'uximatüarietü quenemie. ");
INSERT INTO hchNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Mericüsü müpaü 'utainecacu cuxi, xevitü va'ü quie meyetüa mana caninuani müpaü titahüaveque va'ü, 'Ari 'anive canemüni yemecü. Ti'üquitame pepücati'uxitüaca. ");
INSERT INTO hchNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Hicü Quesusi 'u'enaca müpaü tinitahüave, Pepücaheumaca. Yuri quetineuta'eri xeicüa, nitavicueisitüariemücü. ");
INSERT INTO hchNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Hicü Quesusi heutahaca quita, hipame pücavarupitüa hamatüana memeutahaxüanicü müvayecateisie, Pecuru Vani Cacuvu xeicüa nunusi 'uquiyarieya varusieya xeicüa nivarupitüani. ");
INSERT INTO hchNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Yunaitü meniutisuanacaitüni mene'erivacaitüni meyuhiverietü. Quesusi müpaü niutayüni, Xepüca'utisuanani. Pücamüqui, pucusu masi. ");
INSERT INTO hchNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Müme meninanaimacaitüni metemaitü yeme mümüquicaicü. ");
INSERT INTO hchNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Hicü mamaya 'uviyaca müpaü tinitahüave, Nunusi 'acu, quenanucuquexi. ");
INSERT INTO hchNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Hicü 'iyarieya ninuani. Yapaucua nanucuqueni. Quesusi müpaü tiniuta'aita mütimiquienicü. ");
INSERT INTO hchNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Hicü 'uquiyarimama meniuhüxiyani. 'Iya müpaü tinivarutahüave, Ni xeime tüma xepücatehaxaxatüvani que mütiuyü hepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Mericüsü varucuxeürieca tamamata heimana yuhutame, türücariya nivarupitüani heiserie memexeiyanicü cacaüyarixi 'axa memü'anene yunaime vahepaüsita, cuiniya hepaüsitata memüvaranayexürüvanicü. ");
INSERT INTO hchNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Nivareutanü'axüani memütecuxatanicü que müti'ane Cacaüyari ti'aitametücacu, memüvaranayexürüvanicü teüteri. ");
INSERT INTO hchNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Müpaü tinivarutahüave, Tixaü xepücatehetücüni huyeta mieme, mumuxi xerai 'inüa tumini, huta camixayari xepüca'anacatücüni meta. ");
INSERT INTO hchNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Haqueva quita xemetanaqui'erivani muva xequeneyuhayevani 'asita quepaucua xemüyehuque. ");
INSERT INTO hchNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Haque xemücahetanaqui'eriva, quiecarisie yaxequeteneuhuni, 'inüaricü yucacaisie mieme tumuanari xequeneucasixüa, müpaü xeteyurietü xemütehecüatanicü vahesie que mürahüivanicü. ");
INSERT INTO hchNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Müme meheutayeixüaca quiecaritesie menicu'uvacaitüni metecuxatatü mevaranayexürivatü tecuicuicate naisarie. ");
INSERT INTO hchNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Hicü Herurexi mühüritüariecai mücü cuiepa müti'aitanicü, mücü tiniutamarieni que mütiyurienecai Quesusi naime. 'Asipücatimaicai que mütiyurieniquecai hipatü müpaü memaitücateicü quename vaniu Vani müquite vasata 'anucuquetüarie, ");
INSERT INTO hchNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","hipatüta quename 'Eriyaxi masiücütü 'atüa, hipatüta quename xevitü 'anucuque meripai miemete texaxatamete. ");
INSERT INTO hchNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Perusü Herurexi müpaü canainecaitüni, Vani mu'uya nanutivitequieni yanetiuta'aitacu ne. Peru que püpaicü 'icü hepaüsitana müya 'anuyüneme nemü'enie. Nixeiyamücücaitüni Quesusi. ");
INSERT INTO hchNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Mericüsü nü'arisixi me'u'axüaca, nai Quesusi meteniutaxatüani que memüte'uyuri. Mücüri varavitütü neyani yühücüame quiecari Vesaira müracuteva 'aurie macumavesie. ");
INSERT INTO hchNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Teüteri yamete'utamarieca meniveiyacaitüni. Varutanaqui'erieca tinivacuxaxatüvacaitüni que müti'ane Cacaüyari ti'aitametücacu. Müme müpaü memüteheuyehüacai nivaranayexürieni. ");
INSERT INTO hchNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Mericüsü tau nacayunirümecaitüni. Hicü tamamata heimana yuhutatü hesüana meyucuxeürieca müpaü metenitahüave, Teüteri quenivareutanü'axüa 'aurava memüyehucü quiecarite 'emüyeyeu 'esimüyeyeusie memüyehenicü 'icuai memecaxeiyacü. 'Ena macumavesie teniu'uvani. ");
INSERT INTO hchNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","'Iya müpaü tinivarutahüave, Xeme püta xequetenivarumicua. Müpaü meniutiyuane, Vaüca 'icuai tepücahexeiya, 'auxüme payari huta quesüteyari xeicüa. Me xüca 'icuai tenanaiyuni 'ime teüteri yunaime vahesie mieme. ");
INSERT INTO hchNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","'Uquisi 'auxüme miriyari yacütütü mecaniyupaümecaitüni. Hicü müpaü tinivarutahüave yuhesüa miemete teyü'üquitüvamete, Yaxequetenivarutahüavi memücuyaxixüanicü huta teviyari heimana tamamata yacütütü meyupapaümetü. ");
INSERT INTO hchNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Müme müpaü mepüte'uyuri, yunaime mepüvareucuyasaxüa. ");
INSERT INTO hchNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Hicü 'enu'üca nitaneneviya 'auxüme payari huta quesüteyari meta, taheima heutiniereca. 'Ititaratü nivata'üitüvacaitüni teyü'üquitüvamete memüvamicuanicü teüteri. ");
INSERT INTO hchNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Yunaitü meniticuani meniutihuxani. Tarimeyari niucuxeüriyani manuyuhayevaxü, tamamata heimana huta quirivayari paümetü nayani. ");
INSERT INTO hchNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Mericüsü Quesusi niyuneneviecaitüni yuxaüta, teyü'üquitüvamete mana me'u'uvacacu. Müpaü tinivaruta'ivaviya, Teüteri que metecuxata que mü'ane nepühücü ne. ");
INSERT INTO hchNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Müme müpaü metenita'eiya, Hipatü müpaü meniutiyuaneni, quename Vani Ti'üyame pehücü, hipatüta quename 'Eriyaxi pehücü, hipatüta quename petixaxatame, meripai miemete texaxatamete quename pehücü pemanucuque. ");
INSERT INTO hchNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Hicü müpaü tinivacühüaveni, Xemete que xe'utiyuane que nepüpaicü. Pecuru müpaü tinita'eiya, Que mü'ane Cacaüyari heiserie mipitüa Cürisitutüme, 'ecü pecanihücütüni. ");
INSERT INTO hchNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Quesusi cuinie tinivaruhüritüani, müpaü tiva'aitüatü 'asimemücatehehüavenicü xeime 'icü hepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Müpaü niutayüni, Yuri Tevi que nemütiteva, neuyeveca cuxi vaüca nemüticuinecü. Ta'uquiyarima, mara'acate memühüritüarie, mümeta 'inüaricü memüte'üquitamete yunaitü mecanenitixani'ericuni, necanimieriemücü, hairieca tucarisie necananucuquetüariemücü. ");
INSERT INTO hchNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Müpaüta tinivacuxaxatüvacaitüni yunaime, Tevi xüca yuvaüriyani nehamatü muyeicanicü, queyutatuaca, queyuvaüriyani tucaricü sepa curuxisie mumierie, nehesie quetiviyani. ");
INSERT INTO hchNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Que mü'ane müyutavicueisitüamücü caniyutatümaiyamücü. Que mü'ane müyutatümaiya necümana, mücü niyutavicueisitüamücü yemecü. ");
INSERT INTO hchNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Tevi nai cuiepa mütixuave xüca ra'ivaque, tita ra'ivaqueyu xüca heuyuyehüanique xüca yutatümaiyanique. Tixaü pücara'ivaqueyu. ");
INSERT INTO hchNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Que mü'ane münesiteviya miteviya neniuqui, neta Yuri Tevi que nemütiteva nepiteviyani 'iya quepaucua nemunuani nemarivetü, ne'uquiyaripaü visi ne'anetü, netupirisixima memüpasie Cacaüyarisie mieme vahamatüa. ");
INSERT INTO hchNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Xasunicü nepütixecühüave, hipatü 'uva memu'uva mepücacuini mexi mecanenierivave que müti'ane Cacaüyari ti'aitametücacu. 'Ariqueque mecanicuicuni. ");
INSERT INTO hchNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Mericüsü 'inüca 'icü niuqui, 'atahaica tucari yacütütü 'anucayacu, yemurisie neutiyune yutanenevienique, Pecuru Vani Cacuvu varavitütü. ");
INSERT INTO hchNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Hicü yuneneviecacu niericaya yücü tiyuxexeiyatü nayani, 'ixuriquiteya tuxatü xavavatütü nayani. ");
INSERT INTO hchNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Hicü 'uquisi yuhutatü hamatüana meteniutixatatücüne. Müme Muisexi 'Eriyaxi mecanihümetücaitüni, ");
INSERT INTO hchNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","visi meteyuxexeiyatü Quesusipaü metenicuxatacaitüni que mütiyemiecai, que müraye'aniquecai Querusaremesie. ");
INSERT INTO hchNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Mericüsü Pecuru hipatü hamatüana memu'uvacai yunaitü mecanicusucaitüni. Cuini mieme mecateneucusicucaitüni. Me'anutaneniereca menixeiya visi 'aneme, 'uquisi menivaruxeiya yuhutame 'auriena meti'ucame. ");
INSERT INTO hchNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Müme meyehuximecacu Quesusisüa, Pecuru müpaü tinitahüave, Ti'üquitame 'aixüa cani'aneni 'uva temu'uvacü. Hicümü haica xamaruyari tepütivevieni, 'ahesie mieme xeime, Muisexisie mieme xeime, 'Eriyaxisie mieme xeime. Müpaü niutayüni 'asicatimaitü que mainecai. ");
INSERT INTO hchNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Yaticuxatacacu haivitüri nanutateni nivareutinani. Vareutinaximecacu meniutimamani. ");
INSERT INTO hchNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Hicü haivitürisata xevitü müpaü niutayüni, 'Icü caninenivetüni, yemecü nemenuyexei. Xequene'enieca. ");
INSERT INTO hchNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","'Utaniucu, Quesusi yuxaüta niuyuhayeva. Müme cayuvatü meniutamare. 'Ana xeime mepücatehaxaxatüvacai tita memüte'uxei hepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Mericüsü 'uxa'arieca yemurisie me'acahucacu yumüiretü menivaranucunaque teüteri. ");
INSERT INTO hchNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Hicü 'uqui teüteri vasata 'uvetü müpaü tiniuhiva. Ti'üquitame 'acu, nenive queneuxeiya cuerietü xüa. Xei hücüa necanexeiyani. ");
INSERT INTO hchNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Cacaüyari 'axa mü'ane picuviviya. Yapaucua picunünüve 'utahivacacu cuaimuxari vayeneicacacu. Haveri mieme picuhayeicava 'esivatücacu 'imieximetü xeicüa. ");
INSERT INTO hchNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nevarutavaviriecu 'ahesüa miemete teyü'üquitüvamete memenunü'anicü mecaniuyutatexieni. ");
INSERT INTO hchNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Hicü Quesusi müpaü niutayüni, Cari hicü miemete yuri xepücate'erie, yu'iyarisie xepüyuxamurie. Quepaümexa peuyevese xehamatü nemuyeicani, quepaümexa nepüxenevieca. 'Ena quenatu'i 'anive. ");
INSERT INTO hchNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","'Amieximecacu cacaüyari 'axa mü'ane nenucahüani 'ixamurietü. Hicü Quesusi cacaüyari müca'itiya 'utatiecu nanayeveni nunusi, 'uquiyarieya niyetuirieni. ");
INSERT INTO hchNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Yunaitü meni'iyarixiecaitüni Cacaüyari müya mütitürücaüyecaicü. Hicü yunaitü mehüxiyacacu nai que mütiyurienecaicü, müpaü tinivarutahüave yuhesüa miemete teyü'üquitüvamete, ");
INSERT INTO hchNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Xeme 'icü niuqui yu'iyarisie xequeneucayesa. Yuri Tevi netitevatü neniyetuiyamücü teüteri vamamasie. ");
INSERT INTO hchNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Müme mepücaheitimaivavecai 'icü niuqui. Vahesie mieme ni'aviecaitüni, ya'ayumieme yamepücatehetimaivavecai. Memamatü mepücayuvaüriyacai memita'ivaviyaquecai 'icü niuqui hepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Mericüsü niuqui meniutixüatüatücüne, que mü'ane müme masi ve'emetütü mayaniquecai. ");
INSERT INTO hchNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Quesusi timaitü que memüteyücühüavecai yu'iyarisie, nunusi yu'aurie niutaqueni. ");
INSERT INTO hchNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Müpaü tinivarutahüave, 'Icü nunusi matetü quename nehesüa mieme, mücü 'ayumiemeyaricü xüca 'itanaqui'erieni, neta canenitanaqui'erimücü. Que mü'ane münesitanaqui'erieni ne, 'iyata canitanaqui'erimücü münesiheyenü'a. Que mü'ane yunaime xesata masi vaüca tixaü mücatihücü, mücü canive'emetüni. ");
INSERT INTO hchNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Hicü Vani müpaü tinitahüave, Ti'üquitame, xeime tepuxei 'ahesüa niu miemetütü mütiva'aitüacai cacaüyarixi 'axa memü'anene memüvaxünacü teüteri. Peru tenitanenani 'ahesie mücativiyacü tahepaü. ");
INSERT INTO hchNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Quesusi müpaü tinicühüaveni, Xepüca'inenaca. Xüca catasi'aye'unieca cataniparevieca. ");
INSERT INTO hchNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Mericüsü tucari 'aye'aximecacu manutivitüquienicü, 'ana neutiyune Querusareme cayucunuitüanüatü. ");
INSERT INTO hchNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Niuqui tuayamete nivaranucuhaisitüiya. Müme mana me'uyehutü Samariyatari vaquiecarisie meniu'axüani tixaütü memütecuha'aritüanicü hesiena mieme. ");
INSERT INTO hchNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Quiecatari mepücaheitanaqui'erie yemecü Querusareme müyemiecaicü. ");
INSERT INTO hchNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Teyü'üquitüvamete Cacuvu Vanimatü mete'utamarieca müpaü metenitahüave, Ti'aitame, camatinaque temutiniucanicü 'Eriyaxi que mütiuyuri, tai taheima macanenicü müvatitaiyacü müme. ");
INSERT INTO hchNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Peru Quesusi ta'aurie 'aveca nivarutatieni müpaü 'utaitü, Cari xeme 'asixepücatemate que mü'ane 'iyarisie xemüteviya. ");
INSERT INTO hchNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Yuri Tevi netitevatü, que nemütinua, teüteri va'iyari neheuyexürienique nepücanua, masi nevatavicueisitüanique püta necaninuani. Hicü xeime quiecarisie püta menecüne. ");
INSERT INTO hchNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Mericüsü huyeta me'uyehucacu, xevitü müpaü tinitahüave, Ti'aitame, 'ahesie necatiniviyamücü. Haque pememie, neta necanimieni. ");
INSERT INTO hchNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Hicü Quesusi müpaü tinitahüave, Cauxaisi yuterü mecanexeiyani, viquixi taheima miemete yu'itua metehexeiyata, perusü ne Yuri Tevi netitevatü tixaü nepücarexeiya haque nemünetamuritaritüani. ");
INSERT INTO hchNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Hicü xeimeta müpaü tiniutahüave, Nehesie quetineviyani. 'Iya müpaü tinitahüave, Queneneupitüa merie nemüyemiecü, ne'uquiyari nemücateucucü hemüyuque. ");
INSERT INTO hchNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Müpaü tinita'eiya, Müquite quenivaruhayeva müme püta memüvacateucucü yuhesüa miemete müquite. 'Ecü pütasü quenemie, quetinecuxatani que müti'ane Cacaüyari ti'aitametücacu. ");
INSERT INTO hchNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Hicü xevitüta müpaü tinitahüave, 'Ahesie necatiniviyamücü Ti'aitame. Queneneupitüa xeicüa ne'ivama nemüvatateutüanicü merie. ");
INSERT INTO hchNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Quesusi müpaü tinitahüave, 'Icumayüame hararu, xüca yu'utüma 'utaniereni, 'aixüa pücayüni. Cacaüyari yacü xeicüa canexeiyamücü ti'aitüvametüme. ");
INSERT INTO hchNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Mericüsü 'arique Ti'aitame hipameta varuhüritüaca haica teviyari heimana tamamata meyupaümeme, yuhutatame nivareutanü'axüani memanucuhaitütüanicü naime quiecarisie naime quiepa haque mücü meta'aniquecai. ");
INSERT INTO hchNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Müpaü tinivarutahüave, 'Isanari püvaücava, 'isanamete mepücayumüire. 'Ayumieme xequeneutavaviri 'isanari cusiyari, 'isanamete müvatanü'anicü yu'isanarita. ");
INSERT INTO hchNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Xequeneuhuniri. Camü que nemütixetanü'axüani, muxasi türixi vahepaü xecaniyüacacuni 'üravesixi vasata xe'u'uvatü. ");
INSERT INTO hchNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Xepücaheitücüni vipura xerai cacai. Huyeta xeime xepücavaüritüaca. ");
INSERT INTO hchNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Haque xeme'axüani quita, müpaü meri xequeneutiyuaneni, 'Uva quiecatari 'aixüa xequetexeiyarieca. ");
INSERT INTO hchNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Xüca mana 'ayecani que mü'ane müyuvaüriya 'aixüa mütixeiyarienicü, hesiena tinaquetü canayeimücü xevaürisica. Me xüca müpaü 'anetü ca'ayecani, xevaürisica caninuamücü xehesie. ");
INSERT INTO hchNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Manatütü mücü quita xequeneyuhayevani xetecuatü xete'ietü tita memütexemicuani. Ti'ivamesie catininaqueni 'ivaricaya. Xepücayupatatüveni hipame vaquita. ");
INSERT INTO hchNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Haque quiecarisie xeme'axüani, haque memüxetanaqui'erieni, xequetenecuaca tita xemütemiquieca. ");
INSERT INTO hchNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Xequenivaranayexüri tecuicuicate mana miemete. Müpaü xequetenivacuxaxatüvani, Hicürixüa naye'aniri, Cacaüyari canisutüani 'ena ti'aitatü. ");
INSERT INTO hchNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Haque quiecarisie memücaxetanaqui'erieni xehe'axüayu, vacaye 'utüa xe'uyehutü müpaü xequeneutiyua, ");
INSERT INTO hchNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","'Asita tumuanari xequiecarisie mieme mütasicuiema tacacaisie, tepiticase texehecüatüatü. Sepanetü xemücatasi'utanaqui'eri, ipaü xequetenemaica, tucari maye'acü Cacaüyari misutüacü ti'aitatü. ");
INSERT INTO hchNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","'Ipaü nepütixecühüave, tucariyari 'aye'ayu cuanivemecü mecani'itüariecuni vana quiecatari Suruma quiecatari cacuanivemecü me'itüariecacu masi. ");
INSERT INTO hchNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Xüa 'ui xeme Curasini quiecatari, xüa 'ui Vesaira quiecatari. Türücaüyemecü xüca tiuyünique Tirusie Sirunisie que mütiuyü xehesüa, meripai mepütehayevaqueyu que memüteyuriecai, mepüyuhiveriecaqueyu maixa me'anacatütücaitü hiverica 'inüariyari, naxi meyucavirivatü. ");
INSERT INTO hchNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Masi Tiru quiecatari Siruni quiecatari cacuanivemecü masi mecani'itüariecuni quepaucua 'isücame müvata'ivaviya, xeme püta cui cuanivemecü xe'itüariecacu. ");
INSERT INTO hchNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Xemeta Caperünaumetari, que xeteyutituicaqueyu muyuavisiepai. Müquite vahesüa püta xecaneucaxüriyacuni. ");
INSERT INTO hchNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Que mü'ane müxe'enie pünesi'enie. Que mü'ane müxexani'eri pünesixani'eri. Que mü'ane münesixani'eri pixani'eri que mü'ane münesiheyenü'a. ");
INSERT INTO hchNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Mericüsü haica teviyari heimana tamamata hutarieca meniu'axüani meyutemamavietü, müpaü me'utiyuatü, Ti'aitame 'acu, 'asita cacaüyarixi 'axa memü'anene yamepütecahu que temüteva'aitüa 'ahesüa temümiemetecü. ");
INSERT INTO hchNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Müpaü tinivacühüaveni, Nesü necanixeiya Cauyumarie muyuavisie 'anacahüiyacu merücariyapaü. ");
INSERT INTO hchNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Tamüsü heiserie nenixe'upitüani cuterixi terücaxi xemüvatiquesinacü, 'iya mütasi'aye'unie türücariyaya naime xema'ivacü heiserie necanixe'upitüani. Tixaü 'axa pücatixeyurieni. ");
INSERT INTO hchNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Mücücü xepücayutemamavieca, cacaüyarixi yamemütecahucü que xemüteva'aitüa xeicüa. Xequeneyutemamavieca masi xemacayasariecü taheima. ");
INSERT INTO hchNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Mericüsü 'ana niyutemaviecaitüni 'Iyari Mütiyupata yatipitüacacu. Müpaü niutayüni, Ne'uquiyari pemüti'aita taheima cuiepa meta, pamüpariyusi nepümasipitüa 'icü pemütiuti'avietaxücü, müme memüteyü'üquitüavave müme memütemaivave memücaheitimanicü, türi püta vahesie mieme masihücüme pemayeitüacü. Hü ne'uquiyari, 'aixüa 'ane pepü'eriecai müpaü pemütiyurienecaicü. ");
INSERT INTO hchNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Nai netiniyetuiriyarieni ne'uquiyari yanetipitüacacu. Xevitü 'asipücatimate que müpaicü nu'aya, 'uquiyarieya xeicüa müpaü catinimaica. Xevitü 'asipücatimate que müpaicü 'uquiyarieya, nu'aya xeicüa müpaü catinimaica, me nu'aya xüca yuvaüriyani mixeisitüanicü xeime, mücüta müpaü catinimaica. ");
INSERT INTO hchNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Hicü ta'aurie 'aveca müpaü tinivarutahüave teyü'üquitüvamete yühücüate metitecacu, Müme memunenierixü que xemüte'unenierixü xeme, 'aixüa mecani'itüarieca müme. ");
INSERT INTO hchNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Müpaü nepütixecühüave, yumüiretü texaxatamete te'aitamete meta mepixeiyacucai tita xemüte'uxei xeme, peru mepüca'ixei. Mepi'eniecucai tita xemüte'u'eni, peru mepüca'i'eni. ");
INSERT INTO hchNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Mericüsü xevitü 'inüaricü müti'üquitametücai nanucuqueni 'i'isipanique. Müpaü niutayüni, Ti'üquitame, tita reuyevese müpaü nemütiyurienicü, tucari mücaxüve nehesie mütinaquenicü. ");
INSERT INTO hchNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","'Iya müpaü rehüave, 'Inüari niuquiyarisie que re'uxa. Que peticuterüva. ");
INSERT INTO hchNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Mücü müpaü tinicühüaveni, Müpaü cananuyüneni, Peninaqui'eriecamücü Ti'aitame mü'acacaüyari naime que pemüre'iyaricü naime que pemüti'amatecü, naime 'atürücariyacü, naime que pemüticu'erivacü. Mücü meta, pecaninaqui'eriecamücü 'ahepaü tevi que pemüti'anaqui'erie. ");
INSERT INTO hchNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Quesusi müpaü tinita'eiya, Heiseriemecü peputa'a. Müpaü xüca petiyurieneni, pecanayeyuricamücü. ");
INSERT INTO hchNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Peru mücü heiseriemecü yaticamiecatü yuhecüatamütü müpaü tinicühüaveni Quesusi, Mericüte, que püpaicü nehepaü tevi. ");
INSERT INTO hchNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Hicü 'ita'eiyaca, Quesusi müpaü niutayüni, Heiva tevi Querusareme heyeyaca Quericu neucamiecaitüni. Mericüsü tenavayamete menenucunaque. Me'itiquemaripieca me'icuvaxüaca menecüne müximeme me'ucu'eirieca. ");
INSERT INTO hchNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Mericüsü 'asicatimaitü que mütiuyü mana neucamiecaitüni mara'acame mücü huyeta. 'Ixeiyaca mana niuyeyani yateva. ");
INSERT INTO hchNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Yaxeicüatari Revi nuivarieyasie mieme xevitü tuquita mütiparevivametücai muva 'uyemietü yateva niuyeyani. ");
INSERT INTO hchNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Perusü xevitiüxa Samariyatanacatütü mana 'uyemietü hesüana caninuani. 'Ixeiyaca nitinenimayata. ");
INSERT INTO hchNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","'Aura 'uyaca 'ixuriqui neiverieni xuriya maneicacaisie, haseiticü vinucü 'i'uhayemaca. 'Enuti'icataca yupuxusie mesunipai cani'atüani. Mana ni'üviyacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Hicü 'uxa'arieca xei teviyari 'inüariyari vati'üca ni'üitüani mesuni cusiyari müpaü ticühüavetü, Quene'üviyani. Hesiena mieme xüca tixautü petinanaimücü, xüca 'acuxi heuyeveca, nepütinetuani quepaucua nemayeneni. ");
INSERT INTO hchNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Hicü Quesusi müpaü tinitahüave xevitü mi'isipanecai, Mericüte que peticu'eriva. 'Ime yuhaicatü que mü'ane yuhepaü tevipaü pixei, tenavayamete me'enucunaquecu mücü tevi. ");
INSERT INTO hchNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","'Iya müpaü rehüave, Que mü'ane mitinenimayataxü, mücü pühücütücai. Hicü Quesusi müpaü tinitahüave, 'Ecütari quenemie, hepaüna quetineyurieneni. ");
INSERT INTO hchNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Mericüsü mana meniu'uvacaitüni. Hicü Quesusi xeime quiecarisie neutahani. 'Uca Marita titevatü nita'inieni yuquita. ");
INSERT INTO hchNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Yu'iva 'ucatüme pexeiyacai Mariya titevacame. Mücü Quesusitüa 'acaitü ni'eniecaitüni niuquieya. ");
INSERT INTO hchNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Mericüsü Marita püyuxamuriecai vaüca ticumaüvatü mütivaminicü. Mana 'utaqueca müpaü niutayüni, Ti'aitame, yapecara'eriva ne'iva nexaüta münesi'ucu'eiricü nemütixeminicü. Yaquetineutahüavi pünesiparevieni. ");
INSERT INTO hchNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Quesusi müpaü tinicühüaveni, Neuxei Marita, vaücavacü pepü'a'iyaritüa pepü'amuina. ");
INSERT INTO hchNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","'Esiva peuyevese xeicüa, xevitü xeicüa. Mariya canenuyexeiya tita masi 'aixüa müti'ane. Pücanavaiyarieni. ");
INSERT INTO hchNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Mericüsü heiva 'aniucateitüni yunenevietü. Yunenevieri 'unücu, hesüana miemete teyü'üquitüvamete xevitü müpaü tinitahüave, Ti'aitame, quetatine'üquitüaca temütaneneviecacü, Vani que mütivaru'üquitüa yuhesüa miemete teyü'üquitüvamete. ");
INSERT INTO hchNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Mücü müpaü tinivacühüaveni, Quepaucua xemüyunenevie 'ipaü xequeneutiyua, Ta'uquiyari taheima pemacave, Quememateheuyehüvirieca que pemütipasie. 'Enata queneusutüa pe'ti'aitatü. Cuiepa yamequeteyurieca que matinaque, Taheima que memüteyurie. ");
INSERT INTO hchNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","'Icuai tucaricü que temüteheiyehüva, Tucaricü yaquetatinemicuani. ");
INSERT INTO hchNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","'Axa que temüte'uyuri quetatineuyehüvirieca, Tameta tetevareuyehüviriecacu Müme 'axa memütasiyurie yunaitü. Pepücatasipitüaca temü'inüasienicü, Masi quetaneutavicueisitüa 'Axa temüca'itüarienicü. ");
INSERT INTO hchNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Müpaüta tinivarutahüave, Xüca xevitü xeme yuhamicu hexeiyani, mücü xüca hesüana nuani tücari hixüapa müpaü rehüavetü, Nehamicu 'acu, haica payari queneneuniütüa. ");
INSERT INTO hchNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Tamüsü xevitü nehamicu nehesüa caninuani cuyeicame, tixaü necarexeiyacacu nemütimini. ");
INSERT INTO hchNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Quita mayeca müpaü que 'utayüni, Quetineuhayeva. Quitenie püreuname, netüriyama tanaitü tepuhe. Nepücayüve nemanucuqueni nemümasiniütüani. ");
INSERT INTO hchNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Müpaü nepütixecühüave, canihamicuyatüni, peru mücü 'ayumiemeyaricü xeicüa püca'anucuqueni püca'iniütüani. Siqueresü 'iya munua mücayutiteviyacü püta quiecame panucuqueni piniütüani tita müreuyehüva. ");
INSERT INTO hchNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Müpaü nepütixecühüave ne, xüca xe'ita'ivauni xecatehayevatü xecanimiquiecuni. Xüca xe'icuvauni xepitaxeiya. 'Itupari xüca xe'uyuitüani xepüteheuyepiyarieni. ");
INSERT INTO hchNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Yunaitü memita'ivau mepitanaqui'erie yu'ivaurica, yunaitü memicuvautüve mepitaxeiya yunaitü, 'itupari memücuyuitüva mepüteheuyepiyarüva. ");
INSERT INTO hchNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Que mü'ane xeme yunive mexeiya, xüca nu'aya pa 'itavavirieni, que 'imini tete pa xatatü. Me xüca quesü 'itavavirieni, que 'imini cu quesü xatatü. ");
INSERT INTO hchNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Me xüca 'itavavirieni tavari, que 'imini terüca. ");
INSERT INTO hchNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Xeme 'axa xemüte'u'iyari xüca 'aixüa 'anemecü xetevamicuani yütüriyama, xe'uquiyari taheima macave masi yemecü 'Iyari Mütiyupata taheima mümieme canivamimücü müme memitavaviri. ");
INSERT INTO hchNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Mericüsü nitahüave cacaüyari 'axa mü'ane mixünacü tevi. 'Iya cacaüyari 'iviyacacu tevi pünenuriecai. Hicü cacaüyari 'ixünacu, tevi tiniutixatatüyani münenuriecai. Teüteri menihüxiyacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Peru hipatü müme müpaü meniutiyuanecaitüni, Cacaüyarixi 'axa memü'anene va'uquiyarisie mütiviyacü Peheresepurisie, 'ayumieme nivaranuyenü'avani cacaüyarixi 'axa memü'anene. ");
INSERT INTO hchNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Hipatüta me'i'isipatü 'inüari menitavavirieni taheima mieme. ");
INSERT INTO hchNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Mücü va'iyaritüarica maitü müpaü tinivarutahüave, Naime cuiepa, xüca quiecatari hixüata meyusana, mana pacumavere. Xeime quie quiecatari xüca hixüata meyusana menita'unicuni. ");
INSERT INTO hchNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Cauyumarie xüca hixüata yusana, que reuterive ti'aitametütü. Xemesü xeputiyuane quename Peheresepurisie netiviyatü nevaranuyenü'ava cacaüyarixi 'axa memü'anene. ");
INSERT INTO hchNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ne mericü xüca Peheresepurisie netiviyatü nevaranuyenü'avani cacaüyarixi 'axa memü'anene, xenivema que mü'ane rahesie meteviyatü mepüvaranuyenü'ava. Müme 'ayumieme xehesie mecatenahüpacuni. ");
INSERT INTO hchNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Mesü xüca Cacaüyari türücariyayacü püta nevaranuyenü'avani cacaüyarixi 'axa memü'anene, xehesüa canisutüani Cacaüyari ti'aitatü. ");
INSERT INTO hchNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Tevi mütürücaüye cuya tepüaya ma'ü mexi 'i'üviya quie, cayuvatü puma piniteya. ");
INSERT INTO hchNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Que mü'ane masi yemecü mütürücaüye nuame 'e'ivame, pinavairieni cuya tepüaya hesiena yuri müti'eriecai, yucupaniyeruma püvamini tepüateya. ");
INSERT INTO hchNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Que mü'ane nehesie mücativiya pünesi'aye'uni. Que mü'ane nehamatü müca'icuxexeüriva pitaxürüva. ");
INSERT INTO hchNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Cacaüyari 'axa mü'ane 'ixüname tevi, macuvaquisie puyeicani 'uxipiya cuvaunetü. Yutexienetü müpaü paineni, Nepüyemie nequita nemüvayetüasie. ");
INSERT INTO hchNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Nuame pitaxeiya vaye'itiyacame 'aixüa tiuye'aneme. ");
INSERT INTO hchNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","'Ana püyemie püvata'inieni hipame cacaüyarixi masi cuini mieme 'axa memü'anene 'atahutame. Meheutahaxüame, muva me'ayetetü mepacüne. 'Imatürieca mücü tevi masi yemecü 'axa 'itüarietü payani, que müca'itüariecai matüaripai. ");
INSERT INTO hchNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Mericüsü müpaü ticuxatacacu, 'uca teüteri vasata muyeicacai niutahiva müpaü 'utaitü, 'Aixüa que 'itüariecaitüni que mü'anesie pemüyecatei que mü'ane mümasisisitüacai. ");
INSERT INTO hchNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Mücü müpaü niutayüni, Masisü püta, 'aixüa que me'itüarieca müme Cacaüyari niuquieya memü'enie yamemütecahu. ");
INSERT INTO hchNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Hicü teüteri meyucuxeürieximecacu müpaü tiniutixatatüyani, Hicü miemete teüteri 'axa teyuruvamete mecanihümetüni. Menicuvautüveni 'inüari, peru 'inüari mepücapitüarieni. Cunasi 'inüarieya xeicüa mecanipitüariecuni. ");
INSERT INTO hchNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Cunasi 'inüari que müratüa Ninivetari vahesie mieme, neta Yuri Tevi que nemütiteva 'inüari necanayeimücü hicü miemete teüteri vahesie mieme. ");
INSERT INTO hchNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","'Uca taserieta müti'aitametücai cuiepa cananucuquemücü titahecüataque hicü miemete teüteri vahepaüsita quepaucua 'isücame müvata'ivaviya, vahesie pürahüivani mücü meyetüacü cuie manunieresie mi'enienicü Sarumuni que mütimaivecai. Tamüsü que mü'ane mütimaive Sarumuni que mücatimaivecaipaü 'uva puyeica. ");
INSERT INTO hchNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ninivesie quiecatari mepanucu'uni metetahecüataque hicü miemete vahepaüsita. Vahesie pürahüivani, Ninivetari memüte'uhayevaxücü que memüteyuriecai Cunasi tivarutaxatüacu. Tamüsü que mü'ane mütürücaüye Cunasi mücatitürücaüyecaipaü 'uva puyeica. ");
INSERT INTO hchNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Cüxeme 'utaiyame püca'iti'avieta, cacunicü püca'enucanani. Vapai püta pecayeni, teüteri me'atahaxüaximetü memixeiyacü hecüariyaya. ");
INSERT INTO hchNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Mericüte, tahüxie tavaiyari cüxemeya canihücütüni. Xüca 'ahüxi 'aixüa reu'erieca, 'aixüa 'iyaricü xüca peti'amicuani, pecanihecüariviyarieca 'avaiyarisie naime. Me xüca 'axa 'aneni 'ahüxi, pecati'amimütü 'avaiyarisie pecaniyüriyarieca. ");
INSERT INTO hchNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","'Ayumieme quene'acuerivayurieca, 'ahesüa mieme cüxeme capa 'uyürecü. ");
INSERT INTO hchNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Xüca 'avaiyarisie pehecüariviyarieca naimesie, tixaü catiyürivecacu, naitü canihecüacamücü, cüxeme que matihecüariviya xavatütü. ");
INSERT INTO hchNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Mericüsü tiuhayevacu, Pareseutütü nita'inieni hesüana müticuanicü. Muva heutahaca mana nayerüni. ");
INSERT INTO hchNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Pareseu 'ixeiyaca niuhüxiyani müca'ucamaimacü meri caticuaivetü cuxi. ");
INSERT INTO hchNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Hicü Ti'aitame müpaü tinitahüave, Hicümüsüari xeme Pareseusixi tecüxi xacü herie xepüca'itiva, peru yutaüta xepühüpüne xetenavacutü 'axa xeteyurietü. ");
INSERT INTO hchNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","'Asixepücatemate. Que mü'ane mitavevi herie taütanata catitavevi. ");
INSERT INTO hchNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Masi taütana miemecü xequeteneyumicuani xeteyucanenimayatü, mücücü naitü 'itiyatü nayeimücü xehesie mieme. ");
INSERT INTO hchNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Perusü xüa 'ui xeme Pareseusixi. Tamamata taparisie mieme, xei tapari xepüyuvaüriya xemixatüanicü Cacaüyari yerüvavuena xura naime tupiriyasie mieme peru xepücayuvaüriya heiseriemecü yaxemütecahunicü, xepücayuvaüriya xeminaqui'eriecacü Cacaüyari. Müpaü püta püreuyevese müpaü xemüteyuriecacü, siepüre xecatehayevatü xei tapari xe'ixatüatü. ");
INSERT INTO hchNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Xüa 'ui xeme Pareseusixi. Püxenaque yunaime vahüxie xemayeyaxecü tuquita, xemüvaüritüariecacü quiecari hixüapa. ");
INSERT INTO hchNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Xüa 'ui xeme. Teuquiya müca'aviesiepaü xecani'aneneni. Teüteri teuquiya mecaniquesinani 'asimecatemaitü. ");
INSERT INTO hchNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Mericüsü xevitü 'inüaricü müti'üquitametücai müpaü tinitahüave, Ti'üquitame, müya pe'utaitü pepütasiniuquima tameta. ");
INSERT INTO hchNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","'Iya müpaü tinicühüaveni, Xüa 'ui xemetari 'inüaricü xemüte'üquita. Teüteri xepüvaruti'icatüva 'icate mücuanivecü. Va'icate xemücumaüvani ni yu'itüvamecü xepücayuvaüriya xevaparevienique. ");
INSERT INTO hchNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Xüa 'ui xeme. Texaxatamete vateuquiya 'inüariyari xecanivevieca, xe'uquiyarima mevarucuicu. ");
INSERT INTO hchNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","'Ayumieme xepüyuhecüata, xe'iyari yacani'aneneni xe'uquiyarima que memüte'uyuri. Müme mepüvarucui, xeme va'inüari xepüvevi. ");
INSERT INTO hchNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Cacaüyari timaivetü 'ayumieme müpaü niutayüni, Texaxatamete nepüvatanü'airiexüani nü'arisixi meta. Hipame müme mepüvacuini mepüvaruveiyani. ");
INSERT INTO hchNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","'Ayumieme hicü miemete teüteri vahesie catinahüivamücü yunaime texaxatamete vaxuriyacü cuie munetüariesie hicüque mütayeurivecü, ");
INSERT INTO hchNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Haveri xuriyayacü meri 'asita Sacariya xuriyayacüque mumierie mürayutimavatüre heyeyaca tuquita caheta'avetü. Hü, yanepütixecühüave, hicü miemete teüteri vahesie catinahüivamücü. ");
INSERT INTO hchNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Xüa 'ui xeme 'inüaricü xemüte'üquitamete. Xepinava quitenie yaviyari cümana teüteri metemaivavemete memacünequecai. Xemetütü xepüca'aye'axüavave, xepüvanena hipame memaye'axüaniquecai. ");
INSERT INTO hchNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Mericüsü vayeyacu müme 'inüaricü memüte'üquitametetücai Pareseusixi yunaitü menitixeümatücüne cuini mieme. Meniti'ivaviyatücüne müticuxatanicü vaücava hepaüsita ");
INSERT INTO hchNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","me'ihupietü memiviniyanicü niuquieyacü. ");
INSERT INTO hchNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Mericüsü 'ana teüteri vaüca miriyari meyupaümetü meyucuxeüriecu yuquetasie me'a'uvecacu, nisutüani müpaü tivacuxaxatüvatü yuhesüa miemete teyü'üquitüvamete, Xequeneyucuerivayurieca masi Pareseusixi vahesüa mieme tiyucuxanariyame hepaüsita, yacü xeicüa que memüteyurie 'avie, xemeta capa xe'useviximarienicü. ");
INSERT INTO hchNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Peru naitü müranucuname xeiyarietü nayeimücü, naitü mütiuti'aviesie masiücütü canayeimücü. ");
INSERT INTO hchNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","'Ayumieme müpaü nepaine, nai que xemütecuxata yüvipa, hecüaripa cani'enieriecamücü. Cayuvatü xemutiyuane quita, qui heima meti'utü yamecateniuhivacuni. ");
INSERT INTO hchNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Müpaü nepütixecühüave xeme necupaniyeruma, xepücavamacarüca müme memüyüvave tavaiyari memümieni xeicüa peru 'arique memücayüvave 'asimemüteyurieni masi vaüca. ");
INSERT INTO hchNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Nepütixetaxatüani que mü'ane xemümacarüca. Xequenemacarüca que mü'ane 'imieme tevi heiserie mexeiya meicahüanicüta xasi taiyariyarisie. Hü, müpaü nepütixecühüave, 'iya xequenemacarüca. ");
INSERT INTO hchNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Tamüsü 'üxaviquixi que memütetuiya yu'auxüvitü huta senitavuyari mecate'aye'axe. Peru ni xevitü müme pücatümaiyarie Cacaüyari hüxie. ");
INSERT INTO hchNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Mücü meta, xecüpa xemu'usie mieme naitü püti'inüasieve. Xepücaheumamaca. Yumüiretü 'üxaviquixi que memüte'aye'atüca, xeme masi vaüca xepüte'aye'atüca. ");
INSERT INTO hchNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Müpaü nepütixecühüave, yunaitü memüyuhecüata teüteri vahüxie quename nehesüa memiemete, neta Yuri Tevi que nemütiteva necaninehecüatamücü quename vahesie netiviya Cacaüyarisüa miemete niuqui tuayamete vahüxie. ");
INSERT INTO hchNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Que mü'ane müyucu'imava teüteri vahüxie quename nehesie camieme 'utaitü, mücüta pücamarivani Cacaüyarisüa miemete niuqui tuayamete vahüxie. ");
INSERT INTO hchNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Yunaitü memüniuquixi Yuri Tevi hepaüsita, mecaniyüvaveni memüteheuyehüviyarienicü. Perusü que mü'ane 'axa mütayüni 'Iyari Mütiyupata hepaüsita, mücü pücayüveni müreuyehüviyarienicü. ");
INSERT INTO hchNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Quepaucua xemanuhapanieni tuquipa miemete vahüxie te'aitamete heiserie memexeiya vahüxie, xepücayu'iyaritüaca quepaü xemütetiniuni yuhesie mieme, que xemutiyuane. ");
INSERT INTO hchNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","'Anatütü 'Iyari Mütiyupata müpaü pütixe'üquitüaca que müreuyevese müpaü xemutiyuanenicü. ");
INSERT INTO hchNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Hicü teüteri vasata 'uvetü xevitü müpaü tinitahüave, Ti'üquitame, yaquetineutahüavi ne'iva münesi'üitüanicü tita nehesie mütinaque taquemasi tita mütatiucu'eiriri. ");
INSERT INTO hchNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Quesusi müpaü tinitahüave, Neuxei, que mü'ane xe'isücame pünesi'ayeitüa xepini nemütisananicü. ");
INSERT INTO hchNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Hicü müpaü tinivarutahüave, Xequeneyucuerivayurieca naimecü, xequeneyü'üviyani capa xeteyucahive'eriecacü 'axa müti'anecü. Piniteya ranuyuhayevacacu pücatucari. ");
INSERT INTO hchNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Hicü 'üxasi hepaüsita ticuxatatü tinivaruti'üquitüatüyani müpaü 'utaitü, Tevi müxicutücai cuie nexeiyacaitüni cuini mieme mütiutixuxuavitüvacai. ");
INSERT INTO hchNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Hicü müpaü tiniyücühüavecaitüni yu'iyarisie, Quesü netiyurieni. Tixaü nepücarexeiya haque nemeiti'uta netüricu. ");
INSERT INTO hchNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Hicü müpaü niutayüni, Tamüsü 'ipaü nepütiyurieni. Nepica'una necaxetunite, 'epapame masi nepütivevieni. Mana nepeiti'uta netüricu nepinite. ");
INSERT INTO hchNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","'Anari ne'iyarisie müpaü nepütinecühüaveni, Ne'iyari 'acu, vaüca pinite pecatiniuti'uta müixa viyarisie mieme. Quene'uxipieca quetinecuaca quetine'ieca pe'atemavietü. ");
INSERT INTO hchNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Perusü Cacaüyari müpaü tinitahüave, Cari 'asipepücatimate. Hicü tücacüta 'a'iyari pepütavaviyarieni. Tita pemütiuti'utaxü, que mü'ane piniteya pürayani 'ana. ");
INSERT INTO hchNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yaxeicüa cani'aneni que mü'ane yuhesie mieme müyuti'usiri vaüca, peru mücaxicu Cacaüyari que mütixeiya. ");
INSERT INTO hchNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Hicü müpaü tinivarutahüave yuhesüa miemete teyü'üquitüvamete, 'Ayumieme müpaü nepütixecühüave, xepücayu'iyaritüaca yutucari hepaüsita que xemütecuani, yuvaiyari hepaüsita que xemüteyutiquemaritüani. ");
INSERT INTO hchNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","'Icuai xeicüa pücatucari, 'ixuriqui xeicüa pücaravaiyari. ");
INSERT INTO hchNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Xequenivara'erivani cuasari. Mepüca'uca'e mepüca'isana. Caxetuni 'iqui mepücahexeiya. Cacaüyaritütü catinivamicuani. Viquixi que memüte'aye'axe, xeme cuini mieme masi xecate'aye'axe. ");
INSERT INTO hchNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Que mü'ane xeme yu'iyaritüatü püyüve 'e'utevitü mayuyeitüani xüca 'esi'utevini. ");
INSERT INTO hchNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Mericü 'esiva xeicüa xüca xecayüvaveni, titayari xeteyu'iyaritüa naimecü. ");
INSERT INTO hchNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Tuturi xequena'erivani, que mücativita que mücatisa'a. Peru 'ipaü nepütixecühüave, Sarumuni cuini mieme visi que mü'anecai, visi pücaranacatücücai vahepaü ni xeimepaü 'icü tuturi. ");
INSERT INTO hchNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Mericü xüca Cacaüyari müpaü tiquemaritüaca 'üxa 'üsita mieme hicü muxuave 'uxa'a huxunuta meucaxüriyani, masi yemecü catixequemaritüaca xeme. Cari 'esiva xeicüa yuri xepüte'erie. ");
INSERT INTO hchNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Tita xemütecua'acü xepüca'ayumiemetetüni, tita xemüte'iecü meta, xepücamuinarieca. ");
INSERT INTO hchNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Teüteri naisarie cuiepa miemete 'ipaü 'aneneme nai mepücuvautüve. Xeme xe'uquiyari masi müpaü pütimate xemeiyehüvacü 'icü. ");
INSERT INTO hchNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Xemesü xequeneyuvaüriyani Cacaüyari tixe'aitüvame mühücütünicü. Müpaü xeteyurietü, 'icü nai xepümiquienitari. ");
INSERT INTO hchNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Nemuxasima sepa xemücayumüire, xepücaheumamaca. Xe'uquiyari caniyuvaüriyani mütixepitüanicü tita mürexeiya ti'aitametütü. ");
INSERT INTO hchNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Xequetenetuaca yupinite, xeteyuparevietü xequeteneyumicuani. Xequenanuhuri tumini maname mücaye'irive. Taheima xequeneuti'uta tita mücatixüve, haque tinavayame 'aura mücaheyeica haque cuisi mücareticuitamava. ");
INSERT INTO hchNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Haqueva xemeiti'uta, manata miemecü xe'iyari yacani'anemücü. ");
INSERT INTO hchNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Xequeneyuha'aritüaca xe'ayühüatücaitü xecüxeme tacacu. ");
INSERT INTO hchNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Xemeta teüteri vahepaü xequeneyüaca yucusiyari memücuevie. 'Asimecatemaitü quepaucua neüquiya 'ixüararipa mayeyani, mecanicuevieca cuitüva memüteheuyepienicü nuayu 'itupari heyuitüayu. ");
INSERT INTO hchNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","'Aixüa mecani'itüariecacuni müme te'uximayatamete xüca vacusiyari nuame varetaxeiya me'ayeneniereme. Yuricü nepütixecühüave, panuyühüani, mexa 'aurie püvacuyasaxüani, mana 'uyeicatü pütivamini. ");
INSERT INTO hchNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Sepa tücari hixüapa sepa yuimuana munua, müya meteyuriecacu xüca varetaxeiya, 'aixüa mecani'itüariecacuni müme. ");
INSERT INTO hchNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","'Ipaüsü xequetenemaica, xüca quiecame müpaü timaicaque quepaucua tinavayame munuaniquecai, püca'ipitüaniqueyu meutahanicü quitana. ");
INSERT INTO hchNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Xemeta xequeneha'arisieca. Quepaucua necanuaximeme xemünesi'erieca, Yuri Tevi que nemütiteva, 'ana necaninuamücü. ");
INSERT INTO hchNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Hicü Pecuru müpaü niutayüni, Ti'aitame, 'icü 'üxasi hepaüsita peti'üquitatü tame petatixata, nusu pepüvaxata yunaime. ");
INSERT INTO hchNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ti'aitame müpaü rehüave, Qui cusiyari que mü'ane pühüritüani yuquie quiecatari vacü, tucari 'aye'ayu müvati'inüasirienicü va'icuai. Que mü'ane yamüticamie, que mü'ane mütiyumate, mücü canihüritüariecamücü. ");
INSERT INTO hchNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Mücü ti'uximayatame 'aixüa cani'itüariecamücü xüca cusiyarieya nuame 'itaxeiya müpaü tiyurieneme. ");
INSERT INTO hchNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Yuricü nepütixecühüave, yupini nai hepaüsita pütihüritüani. ");
INSERT INTO hchNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Me xüca mücü ti'uximayatame müpaü tiyücühüaveni yu'iyarisie, Necusiyari 'epüreutevi canuavetü, xüca varutivatüyani te'uximayatamete 'uquisi 'ucari, xüca ticucuaneni xüca cu'ieneni xüca taveneni, ");
INSERT INTO hchNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","mücü ti'uximayatame cusiyarieya caninuamücü quepaucua müca'icuevie, yapaucua quepaucua 'asimücatimate ti'uximayatame. Hixüata piviteni, pipitüani yamemücatecahu vahepaü. ");
INSERT INTO hchNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Mücü ti'uximayatame yamütimaicai que mütinaquecai cusiyarieya, peru mücayucuha'aritüa 'asimücatiuyuri que mütinaquecai, mücü cuini mieme canicuveiyaxüamücü. ");
INSERT INTO hchNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Que mü'ane püta 'asicatimaitü yamütiuyuri para mücuveiyaxüanicü, 'ayüveca xeicüa pücuveiyaxüani. Que mü'ane vaüca mütiumiquie, mücü vaüca pütitavaviyarieni. Que mü'ane vaüca mühüritüarie, vaüca masi pütitavaviyarieni. ");
INSERT INTO hchNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Ne necaninuani tai nemeucahüanicü cuiepa. Xücate 'utinaisienique tüma. ");
INSERT INTO hchNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Peuyevese nema'ivarienicü nemümierienicü, tevi que müranucanamiepaü hacü quepaucua muca'üyarie. Haveri mieme nepütiuca'eniva mexi ca'aye'ave. ");
INSERT INTO hchNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Que xetecu'eriva nemunuacü nevapitüanique cuiepa memütama 'aixüa memüteyuxeiyanicü. Tixaüsietü, 'ipaü nepütixecühüave, hixüata nemüvasanacü püta nepunua. ");
INSERT INTO hchNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Hicü 'uxa'atüni yu'auxüvitü xei quiyarita miemete hixüata mepüyusanani yuhaicatü yuhutame mevaraye'unietü, yuhutatü yuhaicame mevaraye'unietü. ");
INSERT INTO hchNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Hixüata mepüyusanani 'uquiyarieya 'eye'uniecacu yunive, nu'aya 'eye'uniecacu yu'uquiyari, varusieya 'eye'uniecacu yunive 'uca, nu'aya 'eye'uniecacu yuvarusi, yumu'e'ema me'ayuye'uniecacu. ");
INSERT INTO hchNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Hicü müpaü tinivarutahüave teüteri, Quepaucua xemixeiya haivitüri 'e'a'enirümeme tau macayuyuipiquesie, cuitü xeputiyuane quename caviyerüme. Müpaü pütiyünitütü. ");
INSERT INTO hchNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Quepaucua taserieta mu'eca, müpaü xeputiyuane quename 'uxüca. Müpaü pütiyüni. ");
INSERT INTO hchNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Xeme yacü xeicüa xecaniyüaca, xepi'inüata cuie que mütiyuxexeiya muyuavi meta. Titayari xecate'i'inüata 'icü tucarisie mieme. ");
INSERT INTO hchNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Titayarita yücümana xecateheitimaivave tita mütiheiserie. ");
INSERT INTO hchNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Quepaucua 'isücamesüa pemanuhanieni, huyeta xe'uhutü queneunütüa 'axanetame masixünacü, capa 'isücame hüxie masihe'atüanicü, 'isücame capa masiyetuanicü tupirisüa, tupiri capa masi'anutahüanicü casariyanata. ");
INSERT INTO hchNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Müpaü nepümaticühüave, muva pepücavayeyeicani mexi pecati'atuave naimecü. ");
INSERT INTO hchNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Mericüsü hipatü 'ana me'u'axüaca metenitaxatüani Carereyatari vahepaüsita, Piratu mütiuta'aitaxü memücui'ivacü mexi metemavatüvecai. ");
INSERT INTO hchNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","'Iya müpaü tinivacühüaveni, Que xetecu'eriva. Müya memüte'ucuinixücü que metemasiücü, quename mümetütü masi yemecü 'axa meteyuriecai, hipatü Carereyatari yunaitü 'axa que memücate'uyuri. ");
INSERT INTO hchNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Pücatixaü. Masi müpaü nepütixecühüave, xüca xecate'uhayeva que xemüteyurie xeme, vahepaü xecanicui'ivacuni yunaitü. ");
INSERT INTO hchNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Müme meta tamamata heimana 'atahaicatü memüyupaümecai vahesie mucave mücü tuxi Siruhesie müvarucui, que xetecu'eriva müme vahepaüsita. Que metemasiücü quename masi cuini mieme vahesie rahüivacai, hipatü teüteri Querusareme memütama yunaime vahesie que mücarahüivacai. ");
INSERT INTO hchNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Pücatixaü. Masi müpaü nepütixecühüave, xüca xecate'uhayeva que xemüteyurie, yaxeicüa xecanicui'ivacuni yunaitü. ");
INSERT INTO hchNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Mericüsü 'icü 'üxasi hepaüsita ticuxatatü tini'üquitacaitüni. Tevi 'aniucateitüni cüye muca'iteüritaxü yuharaverita. Mana ni'axecaitüni 'icuaxi cuvaunetü cüyesie mieme. Cacanitaxexeiyacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Hicü haraverita mühüritüariecai müpaü tiniutahüave, Camüsü haica viyari nepeucuyeixüa 'icuaxi necuvaunetü 'icü cüyesie mieme. Nepüca'itaxeiyave. Quenahüva, titayari cuie tisevixima xeicüa. ");
INSERT INTO hchNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Peru tihüveme müpaü tinicühüaveni, Cusiyari 'icü visie queneuhayeva xeicüa, mexi hetüana nehecuieviyatüyani mexi havunu nehavivietüyani. ");
INSERT INTO hchNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Xüca 'utixuavere 'aixüa püyüni. Me xüca catixaütüni, tepehüani que pemaine. ");
INSERT INTO hchNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Mericüsü 'uxipiya tucarisie tini'üquitacaitüni heiva xeime tuquita. ");
INSERT INTO hchNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","'Uca mana nayecateitüni cacaüyari 'axa mü'ane miviyacai tamamata heimana 'atahaica viyari 'iveranariyatü. Nanacatusicaitüni, pücayüvecai müyutaseiriyacü naime. ");
INSERT INTO hchNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Hicü Quesusi 'ixeiyaca yu'aurie 'itahüaveca müpaü tinitahüave, 'Uca pepuxünarie que pemütiveranicai. ");
INSERT INTO hchNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Hesiena 'utimecu yapaucua niutaseire. 'Aixüa nainecaitüni Cacaüyari hepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Hicü tuqui va'üya ha'atü Quesusi menayehüacü 'uxipiya tucarisie, müpaü tinivarutahüave teüteri, 'Ataxevitü tucari puxuave quepaucua meuyevese yamüti'uximayacacü. Mücü tucarisie 'ayumieme xequene'axeni xequenanayexürivani, peru 'uxipiya tucarisie pücatixaüsietü. ");
INSERT INTO hchNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Hicü Ti'aitame müpaü tinita'eiya, Cari xeme yacü xeicüa xepüyüa. Yuxexuitü xeme 'uxipiya tucariyarisie xecatevaxüna yupuixisixi yupuxuri haque memacuvü, xecatevarehapana xecatevaharitüva. ");
INSERT INTO hchNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","'Icü 'uca 'Apurahami caninu'ayatüni, peru Cauyumarie necuviecaitüni tamamata heimana 'atahaica viyari. Careuyevese 'uxipiya tucarisie müxünarienicü 'acuvietü. ");
INSERT INTO hchNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Müpaü 'utayücu meniuyutiteteviya yunaitü memeye'uniecai, hipatü teüteri yunaitü meyutemamaviecacu nai que mütiyurienecaicü marivemecü. ");
INSERT INTO hchNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Hicü müpaü niutayüni, Queri ti'ane Cacaüyari ti'aitametücacu. Que 'aneme 'üquisicayari nexatatü nepihecüatani. ");
INSERT INTO hchNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Musitasa 'imüariyaripaü cani'aneni. Tevi 'enutücüca yuharaverita neicaxürieni. 'Utavereca cüye nayani. Viquixi taheima miemete meniyuti'ituatüvacaitüni mamateyasie. ");
INSERT INTO hchNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Hicü tavari müpaü niutayüni, Que müti'ane Cacaüyari ti'aitametücacu, que 'aneme 'üquisicayaricü nepihecüatani. ");
INSERT INTO hchNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Pa cuxanariyamepaü cani'aneni. 'Uca 'enu'üca nitimuina pa mütüxiyarisie haica 'axuvayarisie, 'ariqueque naitü niuticuxanare. ");
INSERT INTO hchNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Hicü quiecarite 'emacuyeyeusie 'esimüyeyeusie caniuyeicacaitüni ti'üquitatü, Querusareme 'uyemietü. ");
INSERT INTO hchNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Mericüsü xevitü müpaü tinita'ivaviya, Ti'aitame, hipatü xeicüa metetavicueisitüariexime. 'Iya müpaü tinivarutahüave, ");
INSERT INTO hchNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Xequeneyumexüitüaca xemeutahaxüanicü quitenie 'esimayevasie. Müpaü nepütixecühüave, 'arique yumüiretü meneutahaxüacucacuni peru meniyutatexicuni. ");
INSERT INTO hchNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Quiecame 'anucuqueme quepaucua müreunani quitenie, 'ana xeme tacua xeniyuhayevacuni 'itupari xeyuitüatüvetü müpaü xe'utiyuatü, Ti'aitame 'acu, quetatineuyepiri. Peru mücü müpaü tinixetahüavimücü, Ne nepücaxemate haque xememiemete. ");
INSERT INTO hchNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","'Ana xenisutüacuni müpaü xe'utiyuatü, Tame 'ahesüa tepütecuacai tepüte'iecai, 'ecüta tacaye 'utüa pepüti'üquitacai. ");
INSERT INTO hchNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","'Ana müpaü tinixetahüavimücü, Nepücaxemate haque xememiemete. Nehesüa xepücamiemete, xequeneutayeixüa. Cari yunaitü yaxepüteyurie que mücatiheiserie. ");
INSERT INTO hchNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Mana xeniutisuanacuni xecaniyutaquevecuni, quepaucua xemüvaxeiya 'Apurahami 'Isahaqui Cacuvu texaxatamete yunaime mana me'u'uvame haque Cacaüyari müre'aita, xeme püta xe'anuyexüriyayu. ");
INSERT INTO hchNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Tau matineicasie miemete macayuyuipiquesie miemete mecani'axüacuni, taserieta miemete ta'utata miemete mete'axüani meta. Mexa 'aurie menayaxicuni haque Cacaüyari müre'aita. ");
INSERT INTO hchNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Camüsü, hicü miemete 'imatüremete, hipatü müme 'ana mexüacate mecanacünicuni, hicü miemete mexüacate meta, hipatü müme 'imatüremete mecanacünicuni. ");
INSERT INTO hchNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Mericüsü 'ana Pareseusixi hipatü hesüana meniu'axüani müpaü mete'icühüavetü, 'Uma quenemie, Herurexi pümasimiemücü. ");
INSERT INTO hchNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","'Iya müpaü tinivarutahüave, Müpaü xequetenehüaviyu nesimariutame, Neuxei, ne hicü 'uxa'a nepüvaranuyenü'avani cacaüyarixi 'axa memü'anene memüvatixünacü teüteri, nepüvaranayexürieni tecuicuicate. 'Ayeimana nepaye'atüarienitütü. ");
INSERT INTO hchNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Mücü xeicüa, neuyeveca hicü'uxa'a nemücuyeicanicü varie meta. Vaüriyarica peuyevese yunaitü texaxatamete memücui'ivacü Querusareme, xaüsie pücatixaü. ");
INSERT INTO hchNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Querusareme, Querusareme, 'ahesie quiecatari mecanivacuica texaxatamete, mecanivatituaxani müme 'ahesüa memeyenü'ariva. Müixa que nemütivacuxeürimücücai 'anivema, vacana yupixüxüisi que mütivacuxexeürivapaü yu'anatüa. Mepücayuvaüriyacai. ");
INSERT INTO hchNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Camü xequi pücu'eiriva 'uyemavetü. 'Ipaü nepütixetahüave, tavari xepücanesixeiya mexi tucari ca'aye'ave quepaucua müpaü xemutiyuaneni, 'Aixüa que ticühüavarüvani que mü'ane Ti'aitamesüa miemetütü munua. ");
INSERT INTO hchNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Mericüsü Quesusi xeimesüa ninuani 'uxipiya tucarisie ticuanique. Mita'ini teüteri va'uquiyarima canixevitütücaitüni Pareseutütü. Müme menihupiecaitüni. ");
INSERT INTO hchNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Hicü tevi meuhatücatei hüxiena nacateitüni. ");
INSERT INTO hchNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Quesusi müpaü tinivaruta'ivaviya müme 'inüaricü memüte'üquitametetücai Pareseusixi meta, Catitauniva 'uxipiya tucarisie menayehüanicü tevi, pücatauniva nusu. ");
INSERT INTO hchNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Müme cayuvatü meniumacaitüni. Hicü ticuicame 'umayüaca nenayehüani neinü'ani. ");
INSERT INTO hchNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Hicü müpaü tinivacühüaveni, Xevitü xeme xüca puxuya heucaveni müvatixavasie, ya puixieya xüca heucaveni, cuitü cativatihana 'uxipiya tucarisie. ");
INSERT INTO hchNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Mepücayüvavecai tixaü memutiyuanenicü 'icü hepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Hicü varuxeiyaca que memütehenuyexeiyacai haque masi 'aixüa mü'anenecai memayaxecü, 'üxasi hepaüsita ticuxatatü tinivaruti'üquitüatüyani müme memuta'inierie. Müpaü tinivarutahüave, ");
INSERT INTO hchNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Quepaucua tevi müxeta'inieni neüquiya 'ixüararipa, haque masi 'aixüa mü'ane, mana xepüca'ayaxiqueni. Cauca xeime masi ve'eme 'uta'inie, 'ecü 'esiva peve'emetücacu xeicüa. ");
INSERT INTO hchNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","'Ahesüa nuame que mü'ane müxe'uta'ini müpaü pümaticühüaveni, Queneupitüa 'icü püta 'ena mayerünicü. 'Ana 'ecü pe'ateviyatü 'imatüreme 'üparieyasie pe'acaitü pepayani. ");
INSERT INTO hchNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Masi quepaucua pemüta'inierieni, mana quenayexi 'imatüreme 'üparisie. Quepaucua munuani que mü'ane mümasi'uta'ini, müpaü pümatitahüave, Nehamicu, 'uma püta quenayexi 'aurava 'ura. 'Ana visi püraniuvani 'ahepaüsita yunaime 'ahamatü memuta'inierie vahüxie. ");
INSERT INTO hchNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Yunaitü tixaütü metehümetüme memayuyeitüva, tixaü mecatehümetütü mecanayeitüariecuni, peru que mü'ane tixaü catihücütüme mayuyeitüva, mücü tixaütü tihücütütü canayeitüariemücü. ");
INSERT INTO hchNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Hicü müpaü tinitahüave que mü'ane mita'ini, Quepaucua 'icuai pemüvevieca ya tuca ya taicai, pepücava'inieca 'ahamicuma 'a'ivama 'amarema 'auravatari memeuca'u xeicüa, tavari capa müme memasi'uta'inienicü, capa perapiniyariecacü. ");
INSERT INTO hchNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Masi quepaucua 'icuai pemüvevieca, queniva'inieca müme memümamave memümamavavaqui memühurietüca memacücüpe püta. ");
INSERT INTO hchNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Müme tixaü mepücatehexeiya cümana tavari memümate'apiniriecacü. Müpaü petiyurienetü 'aixüa pecani'itüariecamücü, tavari pepürapiniyarieca quepaucua memanucu'uni müme heiseriemecü yamemütecahu. ");
INSERT INTO hchNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Hicü memuta'inierie xevitü, 'icü 'u'enieca, müpaü tinitahüave, 'Aixüa cani'itüarieca que mü'ane mürecuani haque Cacaüyari müre'aita. ");
INSERT INTO hchNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Peru Quesusi müpaü tinicühüaveni, Xevitü tevi 'icuai niuvevieni mariveme. Yumüireme nivaruta'inieni. ");
INSERT INTO hchNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Hicü tucari 'aye'acu memütecuanicü, neinü'ani yuhesüa mieme ti'uximayatame müpaü tivatahüaveque memuta'inierie, Xequenacüni, hicürixüa pücuha'arisie. ");
INSERT INTO hchNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Hicü yuxexuitü yunaitü meniuyuti'imatücüne. Xevitü meri müpaü tinitahüave, Cuie nepenanai, peuyevese nemixeiyamiecü. Nepücayüve nemümiecü, quenereuyehüviri. ");
INSERT INTO hchNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Xevitüta müpaü titahüavixü, Puixisixi nepüvarenanai 'auxüme yutayari. Nevareta'inüataque nepümie. Nepücayüve nemümiecü, quenereuyehüviri. ");
INSERT INTO hchNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Xevitüta müpaü titahüavixü, 'Uca nepuvitütüarie, 'ayumieme nepücayüve nemümiecü. ");
INSERT INTO hchNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Hicü ti'uximayatame nuaca müpaü tinitahüave yucusiyari. Hicü quiecame 'uyeha'aca müpaü tinitahüave yuhesüa mieme ti'uximayatame, Cuitü quiecarisie quenemie caye 'utüa huyeta. Memümamave memümamavavaqui memacücüpe memühurietüca quenivaravitüqui 'uva. ");
INSERT INTO hchNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","'Arique müpaü niutayüni ti'uximayatame, Cusiyari, que pemütiuta'aitaxü yanepütiuyuri. Mepücahüpüne cuxi. ");
INSERT INTO hchNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Hicü cusiyarieya müpaü tinicühüaveni yuhesüa mieme ti'uximayatame, Huyeta quenemie tesariya que mütiucumane, vaüriyarica quenivarepitüa memahucü nequita memütahünecü. ");
INSERT INTO hchNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","'Ipaü nepütixecühüave, müme memuta'inierie, ni xevitü müme pücahe'inüata ne'icuai. ");
INSERT INTO hchNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Mericüsü yumüiretü teüteri 'utümana meniuhucaitüni. Ta'aurie 'aveca müpaü tinivarutahüave, ");
INSERT INTO hchNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Xüca nehesüa nuani, xüca cava'uxive'erieca yu'uquiyari yuvarusi yü'üya yütüriyama yu'ivama, xücate ca'i'uxive'erieca yutucari meta, pücayüve nehesüa mieme tiyü'üquitüvame mayuyeitüvanicü. ");
INSERT INTO hchNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Que mü'ane mücayuvaüriya curuxisie mümierieni, que mü'ane nehamatü müca'uyeica, mücü pücayüve nehesüa mieme tiyü'üquitüvame mayuyeitüanicü. ");
INSERT INTO hchNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Xevitü xeme xüca tuxi tavevimücüni, mana carayerüni merie titi'inüataque que müraye'aca, xüca heixeiyani cümana minüni, me xüca catixaütüni. ");
INSERT INTO hchNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Simiyenituyari tavevieyu, yutatexieyu minünicü 'aixüa pücayüni, yunaitü mecanitinanaimatücüne memüneniere ");
INSERT INTO hchNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","müpaü me'utiyuatü, 'Icü tevi qui caniusutüani, püyutatexie püca'inü. ");
INSERT INTO hchNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Xeime cuiepa ti'aitame xüca yemieximeni xeime ti'aitamematü memüyutacuinicü, mana meri carayerüni, müpaü tiyücühüavetü tamamata miriyari varavitütü xüca 'acu yüveni menucunaquecü 'iya xei teviyari miriyari varavitütü hepana mamie. ");
INSERT INTO hchNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Me xüca catixaütüni, teva heyeicacacu cuxi neüquixivieya, nü'arisixi penunü'airieni, pitavavirieni 'aixüa memüteyuxeiyanicü. ");
INSERT INTO hchNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Yaxeicüatari yunaitü xeme xüca yupinite nai xecate'ucu'eirieni, xepücayüvave nehesüa miemete teyü'üquitüvamete xemayuyeitüvanicü. ");
INSERT INTO hchNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","'Una 'aixüa cani'aneni. Xücate 'una hamuritü 'ayanique, titacü ra'usiürequeyu 'unatütü. ");
INSERT INTO hchNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Aixüa cacani'aneniqueyu cuiepa meviviyanicü ni xasipa. Nanuyehüiyamücü xeicüa. Xaütü netü mu'enaxü que'u'ena. ");
INSERT INTO hchNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Mericüsü müme cuviyexunusie mieme memüteyetuiriyari 'axa teyuruvamete meta hesüana meni'axecaitüni yunaitü me'i'enienique que müticuxatacaicü. ");
INSERT INTO hchNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Hicü Pareseusixi, müme 'inüaricü memüte'üquitametetücai meta, meniniuquixiecaitüni müpaü me'utiyuatü, 'Icü 'axa teyuruvamete canivanaqui'erieca, vahamatü tinecuaca. ");
INSERT INTO hchNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Hicü 'icü 'üxasi hepaüsita ticuxatatü tinivaruta'üquitüani müpaü 'utaitü, ");
INSERT INTO hchNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Xevitü xeme xüca xei sienituyari varexeiyani yumuxasi, xevitü xüca heuyeveni, mana 'üxapa cativacu'eirieni hipame nauca teviyari heimana tamamata heimana 'atanaucame, cativaumie meuyeve, 'itaxeiyameque xeicüa pütihayeva. ");
INSERT INTO hchNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Yuteva hetaxeiyame, yunaiparie heicuyeme niyemieni yutemavietü. ");
INSERT INTO hchNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Yuquie nuame nivacuxeürimücü yumarema 'auravatari yunaime müpaü tivacühüavetü, Xemeta xequeneyutemamavieca nehepaü, nemeitaxeicü nemuxa meuyevecai. ");
INSERT INTO hchNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Müpaü nepütixecühüave, hepaüna meyüatü, cuini mieme mecaniyutemamavieca taheima quepaucua xevitü mütihayeva 'axa tiyurienetü. Nauca teviyari heimana tamamata heimana 'atanaucatü heiseriemecü yamemütecahu tixaü memücateheuyehüva memütehayevacü 'axa meteyurietü, müme vahepaüsita 'esiva xeicüa mepüyutemavie. ");
INSERT INTO hchNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","'Uca xüca tamamata tuminiyari hexeiyani pürata tuminiyari, xei tuminiyari xüca heuyehüani, catitaiya cüxeme, caracu'itieni yuquita, 'aixüa 'anemecü caticuvauni. 'Itaxeiyameque pütihayeva. ");
INSERT INTO hchNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","'Itaxeiyame nivacuxeürimücü yumarema 'auravatari yunaime müpaü 'utaitü, Xemeta xequeneyutemamavieca nehepaü, netumini nemutaxeicü nemeiyehüacai. ");
INSERT INTO hchNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Müpaü nepütixecühüave, yaxeicüa Cacaüyarisüa miemete niuqui tuayamete temavierica mecanexeiyani, quepaucua xevitü mütihayeva 'axa tiyurienetü. ");
INSERT INTO hchNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Müpaü niutayünita, Tevi yuhutame nivarexeiyacaitüni yunivema. ");
INSERT INTO hchNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Hicü mutaya müpaü tinitahüave yu'uquiyari, Ne'uquiyari, 'apinisie mieme mücü quenetineyetuiri nehesie mieme mayanicü quepaümetü nehesie mütinaque 'apinitücai. ");
INSERT INTO hchNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","'Ana yupini tinivayetuirieni yuhutame yunivema. Hicü yapaümexa 'anucayacu mutaya nai tiucuxeürieca teva caneyani xeime cuieyarisie. Yupini catineuyehüani mana yacü xeicüa. ");
INSERT INTO hchNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Mericüsü nai tiutixütüacu, haca niutaveni cuini mieme mücü cuieyarisie. Reuyehüatü nayani. ");
INSERT INTO hchNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Hicü mana quiecamesüa nuaca hesiena tiniuviya. Mücü neinü'ani tuixuri mütivaremicuanicü cuiepana. ");
INSERT INTO hchNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Huxaimütü nihive'eriecaitüni tita memütecuacai tuixuri vapinuripaü 'aneneme, peru ni xevitü pücatimi. ");
INSERT INTO hchNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Mericüsü 'uca'iyaritü nayani. Müpaü niutayüni, Ne'uquiyarisüa miemete te'ivamete pa mepexeiya 'anuyuhayevacame, ne masi 'uva nepümüxime hacacü. ");
INSERT INTO hchNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nepüyemie mecuxi ne'uquiyarisüa. Müpaü nepüreitahüave, Ne'uquiyari, 'axa nepütiuyuri. Taheima macave yamücahainesie, 'ecüta yapemücahainesie nepütiuyuri. ");
INSERT INTO hchNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","'Aixüa nepücatiuca'iyari, heiserie nepücahexeiya para hutarieca 'anive nemayanicü. 'Ahesüa miemete te'ivamete vahepaü xeicüa quenetinepitüaca nemünehayevacü. ");
INSERT INTO hchNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Hicü yucuha'aritüaca yu'uquiyarisüa neyani. 'Eteva cuxi 'amiecacu 'uquiyarieya nixeiya, nitinenimayata. 'Utanausaca 'enucunaqueca 'enacaviyatücaitü ni'iseni. ");
INSERT INTO hchNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Hicü nu'aya müpaü tinitahüave, Ne'uquiyari, 'axa nepütiuyuri. Taheima macave yamücahainesie, 'ecüta yapemücahainesie nepütiuyuri. 'Aixüa nepücatiuca'iyari, heiserie nepücahexeiya para hutarieca 'anive nemayanicü. ");
INSERT INTO hchNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","'Uquiyarieya masi müpaü tinivarutahüave te'uximayatamete, Xeiya 'aixüa, 'ixuriqui masi 'aixüa mü'ane herie mieme xequenayehuri xequenanacatütüa, hanira xequeneucamaniri mamayasie, cacai meta 'ücayasie. ");
INSERT INTO hchNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Xequenehaniyu siqueru müvaiya 'aixüa mü'ane, xequeneumi'a. Tetecuatü tepütatemamavieca. ");
INSERT INTO hchNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","'Icü nenive 'umüme nene'eriecaitüni peru nanutaniere, neuyevecaitüni peru niutaxeiyarieni. 'Ana meyutemamavietü menacüne yunaitü. ");
INSERT INTO hchNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Mericüsü masicaya xaüsie neyeicacaitüni. 'Amietü, qui 'aurie 'uyeicatü, niva'eniecaitüni xavererusixi vainarurisixi. ");
INSERT INTO hchNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Yu'aurie 'itahüaveca ti'uximayatame xeime, nita'ivaviya que reyüane. ");
INSERT INTO hchNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Mücü müpaü tinicühüaveni, 'A'iva caninuani. 'A'uquiyari canimieni siqueru müvaiya 'aixüa mü'ane mitanaqui'ericü 'aixüa reu'eriecame. ");
INSERT INTO hchNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Hicü masicaya niuyeha'ani, pücayuvaüriyacai meutahanicü. 'Uquiyarieya vayeyaca nicunütüvacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Müpaü tinitahüave yu'uquiyari, Neuxei, müixa viyari netini'uximayacaitüni 'ahesüa, hicü cuxi netini'uximayaca. Ne hasuacu nepücamasicu'imaiyacai, yanepüticamiecai. Peru ne hasuacu capüra nunusi pepücanesimive, nemarema vahamatü nemünetemaviecacü. ");
INSERT INTO hchNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Hicüri 'icü 'anive ninuani 'atumini nai hetixütüaca 'ucaravesixi vahesie. Cari siqueru müvaiya pepumi hesiena mieme. ");
INSERT INTO hchNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Hicü 'uquiyarieya müpaü tinitahüave, Nenive, 'aheyemecü nehesüa peniucani. Nepini naitü catini'apinitüni. ");
INSERT INTO hchNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Neuyevecaitüni temütatemamaviecacü. Camüsü 'icü 'a'iva 'umüme neni'eriecaitüni, peruri panutanierixü punua. Meuyevecai niutaxeiyarieni. ");
INSERT INTO hchNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Müpaüta tinivarutahüave teyü'üquitüvamete, Tevi müxicutücai caneixeiyacaitüni ti'uximayatame mühüritüariecai quiyacü. Müpaü tiniutahüavarieni quename ti'uximayatame pini reuyehüaximecai. ");
INSERT INTO hchNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Hicü yu'aurie 'itahüaveca müpaü tinitahüave, Titayari niuqui neti'enie 'ahepaüsita. 'Inüari queneneutaveviri 'ahüritüaricacü. Nepücamasipitüani tavari pemühüritüariecacü. ");
INSERT INTO hchNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Hicü yu'iyarisie müpaü tiniyücühüavecaitüni ti'uximayatame, Que netiyurieneni. Necusiyari nehüritüarica pünesinavairieni. Nepücatürücaüye para nemüti'ivanenicü ne'inetü, nepüneteviya 'icuevaricü. ");
INSERT INTO hchNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Hicürixüa nepüretima que nemütiyurieneni quepaucua nemüpasieni quepaucua nemücatihüritüarieca para hipame vaquita nemünaqui'erivanicü. ");
INSERT INTO hchNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Hicü yuxexexuime varahüavixüaca müme memüte'apicaquecai cusiyarieyasüa, müpaü tinitahüave meri munua, Quepaümetü peuyevese para pemürapicacü necusiyarisüa. ");
INSERT INTO hchNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","'Iya müpaü tinitahüave, Xei sienituyari tamüpuyari haseiti. Müpaü tinicühüaveni, 'I, 'axapa quenanuhuri quepaümemecü pema'acaye. Cuitü mana quenayexi, xeime püta quenaca'utüa huta teviyari heimana tamamata maine. ");
INSERT INTO hchNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Müpaüta tinitahüave xeime, 'Ecüsü quepaümetü peuyevese pemürapicacü. 'Iya rehüave, Xei sienituyari necayari türicu. Müpaü tinicühüaveni, 'I, 'axapa quenanuhuri quepaümemecü pemü'acaye maine. Xeime püta quenaca'utüa nauca teviyari maine. ");
INSERT INTO hchNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Hicü cusiyarieya 'aixüa nainecaitüni ti'uximayatame hepaüsita sepa heiseriemecü mücayüanecai, timaitü müyüanecaicü. Hicü miemete masi metemaitü mecaniyüaca yuteüterima vahepaüsita, hecüaripa miemete yamecayüacacu vahepaü. ");
INSERT INTO hchNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Neta müpaü netinixe'utahüave xeme, teüteri yupinicü yamecateniyurieca que mücatiheiserie. Peru xeme yupinicü hipame xequenivatemavieritüaca. Müpaü xeteyurietü, quepaucua pini müreutipare, xemeta xecanitanaqui'erivacuni haque qui mücahexüvesie. ");
INSERT INTO hchNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Que mü'ane yamüticamie 'esitipaümeme tihüritüarietü, mücü yacatinicamiemücü xüca vaücava hüritüarieca. Que mü'ane heiseriemecü yamücaticamie 'esitipaümeme tihüritüarietü, mücüta yapücaticamieni xüca vaücava tihüritüarieca. ");
INSERT INTO hchNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Hipatü pinicü yamecateniyurieca que mücatiheiserie. Xeme xüca yaxecatecahuni müpaü 'aneme pini hepaüsita xetehüritüarietü, quepaicü pütixehüritüani tita yuricü mütipini hepaüsita, yaxetecahume 'erietü. Haquevasü. ");
INSERT INTO hchNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Xüca yaxecatecahuni xeime piniteya hepaüsita xetehüritüarietü, que mü'ane tita mütixepini pütixemini. Haquevasü. ");
INSERT INTO hchNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ti'uximayatame pücayüve yuhutame vahesie mieme müti'uximayacacü yucusiyarima. Xeime cani'uxive'eriecamücü xeime püta naqui'erietü, ya xeimesie tiniviyamücü xeime püta xani'erietü. Xepücayüvave xemüte'uximayacacü Cacaüyarisie mieme yupinisie mieme 'axeicüa. ");
INSERT INTO hchNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Mericüsü Pareseusixi 'icü nai meteniu'enieni. Müme tumini memühive'eriecaicü menitave'eriecaitüni. ");
INSERT INTO hchNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Hicü Quesusi müpaü tinivarutahüave, Xeme yuri xecateniva'eritüaca teüteri quename heiserie xeyüa xe'utiyuatü, peru Cacaüyari pimate xe'iyari. Tita teüteri mamarivaveme memütexeiya, mücü pütixani'eriva, Cacaüyari que mütixeiya. ");
INSERT INTO hchNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","'Inüari niuquiyari, texaxatamete vaniuqui mecani'eniecaitüni teüteri Vani canuavecacu cuxi. Nuacuque hicüque niuqui 'aixüa manuyüne püta canicuxaxasivani, que müti'ane Cacaüyari ti'aitametücacu, yunaitü cuini mieme mecaniyuvaüriyani hesiena memüteviyanicü. ");
INSERT INTO hchNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Masi pücacuaniveniqueyu muyuavi cuie meutiparecü, peru cuini mieme pücuaniveniqueyu xei 'utüaricayari xei hüxiyari müca'aye'anicü 'inüari niuquiyari que maine. ");
INSERT INTO hchNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Que mü'ane 'icu'eirieme yü'üya, xeime püta mütivitüni, mücü xeime püta canicumaüvani xeime cünaya hücütütü. Que mü'ane mitivitüni 'uca mucu'eiriva, mücüta nicumaüvani xeime 'üyaya. ");
INSERT INTO hchNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Mericüsü tevi 'aniuyeicacaitüni xicutütü. Tataüravime nanacatücücaitüni, rinu 'ixuriquiyari meta. Tucaricü visi tinicuacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Xevitü mavetü Rasaru titevatü mana ni'atüarivacaitüni xicu quitenie. Caneu'esacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Nihuxaimücücaitüni, ticuaimütü tita müranacavivivecai xicu mexayasie. 'Asita süicüri me'acüneca menisenacaitüni 'esaya. ");
INSERT INTO hchNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Mericüsü mümave niumüni. Cacaüyarisüa miemete niuqui tuayamete menenutivitüni 'Apurahami 'aurie. Hicütari xicu tiumü tiucateuquie. ");
INSERT INTO hchNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Müquite vasata 'ucaitü neutiniere 'uximatüarietü. Tevapai nixeiya 'Apurahami, Rasaruta tiuxei 'auriena 'uticaime. ");
INSERT INTO hchNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Müpaü: tiniuhiva, Ne'uquiyari 'Apurahami, quenenenenimayaca, Rasaru quenanü'a hapa meiquenicü yu'itüvame cüsie münesixeriyacü nenenisie, cui nemüyüanecü 'ena taipa. ");
INSERT INTO hchNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Hicü 'Apurahami müpaü niutayüni, Nenive, quena'erivani 'aixüa 'aneneme pehexeiyatü pematüacü quepaucua pemayeyuricai, Rasaruta yaxeicüa 'axa 'aneneme hexeiyatü matüacü. Mücü 'uva niunütüarieni hicü, 'ecü püta pepü'uximatüarie. ");
INSERT INTO hchNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Mücü meta, xeme tame tahixüata 'aqui 'emeucateva puseiriyarie, para müme memücayüvavenicü sepa memanucünicu xehesüapaitü, para vanata tahesüapaitü memüca'anacünecü. ");
INSERT INTO hchNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Hicü müpaü tinitahüave 'iya, Ne'uquiyari, nepümasivaviri Rasaru pemanunü'anicü nequemasisüa. ");
INSERT INTO hchNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Yu'auxüvime nepüvarexeiya ne'ivama. Tinivahecüatüacamücü müme, capa 'uva me'u'axüanicü mürayuti'uximatüatüre mümetari. ");
INSERT INTO hchNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Hicü 'Apurahami müpaü tinicühüaveni, Muisexi xapaya mecanexeiyani, texaxatamete vaxapa. Mequeva'enieca müme que memutiyuane. ");
INSERT INTO hchNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","'Iya re'eiya, Tixaü ne'uquiyari 'Apurahami. Masi xüca xevitü müquite vasata mieme vahesüa nuani, mepütehayeva que memüteyurie. ");
INSERT INTO hchNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Mücü müpaü tinicühüaveni, Xüca mecava'enieca Muisexi texaxatamete, sepa xevitü manucuquenique müquite vasata, mepücayuvaüriyaniqueyu. ");
INSERT INTO hchNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Müpaüta tinivarutahüave yuhesüa miemete teyü'üquitüvamete, Peuyevese teüteri memücunuitüarienicü, peru xüa 'ui que mü'ane müvacunuitüani. ");
INSERT INTO hchNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Hesiena mieme masi 'aixüa püyüniqueyu xüca mata 'acatütüarienique cüipitüana, xüca haramarasie heucahüiyanique, capa 'icunuitüanicü ni xeime 'ime sepa vaüca memücamariva. ");
INSERT INTO hchNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Xequeneyü'üviyani xeme. Xüca 'a'iva 'axa masi'uyurieni, queneunütüa. Xüca tihayevamücüni que mütiyurienecai, quetineuyehüviri. ");
INSERT INTO hchNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Sepa xei tucarisie müixa 'axa masi'uyurienique 'atahutamexa, tavari xüca 'atahutamexata 'ucunuanique 'ahesüa, Nepütihayeva que nemütiuyuri, utaitü, quetineuyehüviri 'ecü. ");
INSERT INTO hchNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Hicü nü'arisixi müpaü metenitahüave Ti'aitame, Quetanepitüaca masi vaüca yuri temüte'eriecacü. ");
INSERT INTO hchNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ti'aitame müpaü niutayüni, Xüca musitasa 'imüariyaripaü 'esipemecü yuri xete'eriecaque, müpaü xepüte'itahüavequeyu xapa mana muve, Quenivatixünarieni, haramarasie queneuca'iteüsie. Yapüticamieniqueyu que xemutiyuane. ");
INSERT INTO hchNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Xevitü xeme xüca ti'uximayatame hexeiyani mucuiesanane ya muxasi müvahüne, xüca nuani ti'uximayatame retahayevame, müpaü quetitahüave, Quenaye'a xeiya, quetinecuaca. ");
INSERT INTO hchNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Pücatixaü, müpaü masi cusiyari catitahüave, 'Aixüa quetineuyuri para nemüticuanicü ne, quene'atiquemaritüa quena'ahüa quenetineumicua mexi neticua'a mexi neti'ie. 'Arique mücaque pepüticuani pepüti'ieni 'ecütari. ");
INSERT INTO hchNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Pamüpariyusi que 'ipitüani ti'uximayatame yatiyurienecacu que mütiu'aitüarie. Tixaü xüari. ");
INSERT INTO hchNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Xemetari yaxeicüa, quepaucua yaxemüteyurieca nai que xemüte'u'aitüarie, müpaü xequeneutiyuaneni, Te'uximayatamete tecanihümetüni xeicüa, tixaütü tahesie pücatinaque. Que müreuyevecai xeicüa tepüte'uyuri. ");
INSERT INTO hchNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Mericüsü Querusareme 'uyemietü Samariya cuieyari Carereya cuieyari mayunaquecaisie niuyemiecaitüni. ");
INSERT INTO hchNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Xeime quiecarisie ta'aximecacu tamamata 'uquisi menenucunaque cuiniyacü memüca'itiyatücatei. Teva meti'utü ");
INSERT INTO hchNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","meniutihivacaitüni müpaü me'utiyuatü, Quesusi 'acu, Ti'üquitame 'acu, quetanenenimayaca. ");
INSERT INTO hchNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Varuxeiyaca müpaü tinivarutahüave, Xequenehu mara'acate memüxexeiyacü. Hicü me'uyehutü me'itiyatücaitü mecanacüne. ");
INSERT INTO hchNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Hicü xevitü müme 'uniereca que müranayehüiya, pucunua 'aixüa 'utaitü Cacaüyari hepaüsita, carima 'utaniutü. ");
INSERT INTO hchNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Niutihüximaqueni Quesusitüa pamüpariyusi 'ipitüatü. Mücü Samariya caniquiecametücaitüni. ");
INSERT INTO hchNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Hicü Quesusi müpaü niutayüni, Tamamata mecate'u'itiya. 'Atanaucatü que meteheuyunixü. ");
INSERT INTO hchNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Hipatü mecatexuave memüyuvaüriya memucunuaxüanicü para 'aixüa memutiyuanenicü Cacaüyari hepaüsita, 'icü xaüsie quiecame xeicüa punua. ");
INSERT INTO hchNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Hicü müpaü tinitahüave, Quenanucuquexi quenemie. Yuri pemütiuta'ericü, 'ayumieme peputavicueisitüarie. ");
INSERT INTO hchNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Mericüsü Pareseusixi menicu'ivaviyacaitüni quepaucua maye'aniquecai tucari para Cacaüyari misutüanicü ti'aitatü. Müpaü tinivarutahüave, Tanieretü xeicüa 'asipücaretimani quepaucua misutüani ti'aitatü Cacaüyari. ");
INSERT INTO hchNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Pücayüveni müpaü mütayüni, Camü 'ena, camü 'uma. Que müti'ane Cacaüyari ti'aitametücacu, 'ari xesata canisutüani ti'aitatü. ");
INSERT INTO hchNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Hicü müpaü tinivarutahüave teyü'üquitüvamete, Tucari canaye'amücü quepaucua müpaü xemutiyuaneni, Xüca tüma 'aye'anique Yuri Tevi tucarieya siquere xevitü, peru xepüca'ixeiya mücü tucari. ");
INSERT INTO hchNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Müpaü mepütexetahüave, Camü 'uma peyeica, camü 'ena. Xepücatayeixüani, xepücavaranuveiya. ");
INSERT INTO hchNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Merücariya naisarie que mütihecüarivie muyuavi 'umerücatü taserieta ta'utatapaitü, yaxeicüa neta müpaü nepütimasiücüre naisarie netucari 'aye'ayu Yuri Tevi que nemütiteva. ");
INSERT INTO hchNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Perusü neuyeveca meri vaüca nemüticuinecü, memünesitixani'erienicü hicü miemete teüteri neuyevecata. ");
INSERT INTO hchNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Que mütiuyü quepaucua Nuhexi 'amuyeicacai, yaxeicüa catiniyümücü quepaucua netucari maye'ani. ");
INSERT INTO hchNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","'Ana mepütecuatüvecai mepü'ietüvecai mepüneneüquecai mepüvatavitütüvacai. 'Ariqueque tucari naye'ani quepaucua Nuhexi canuvasie meutaha. 'Ana ha tiyaca nivaruca'una yunaime meniutihauni. ");
INSERT INTO hchNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Müpaürita que mütiuyü quepaucua Ruti 'amuyeicacai yapütiyüni. 'Ana mepütecuatüvecai mepü'ietüvecai mepütenanecai mepütetuacai mepuca'esacai mepüquitüvecai. ");
INSERT INTO hchNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Tucari 'aye'acu quepaucua Ruti meyetüa Surumasie, 'ana tai niucaviye 'asupüre nütü, nivareuyehüani yunaime. ");
INSERT INTO hchNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Müpaü catiniyümücü mücü tucarisie quepaucua nemasiücütü nemayani, Yuri Tevi que nemütiteva. ");
INSERT INTO hchNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","'Iya tucarisie que mü'ane caxetunisie macaca 'uxipietü, piniteya quita tiyepicacu, mücü 'anacayame pücativayepini. Yaxeicüata que mü'ane yuvaxata meyeica yu'utüma pücanuani. ");
INSERT INTO hchNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Xequena'erivani Ruti 'üyaya que mu'itüarie. ");
INSERT INTO hchNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Que mü'ane müyutavicueisitüamücü niyutatümaiyamücü. Que mü'ane müyutatümaiya, mücü niyutavicueisitüamücü yemecü. ");
INSERT INTO hchNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Yanepütixecühüave, 'iya tücarisie yuhutatü mepücahini xei 'utayarisie. Xevitü nanutivitüquiemücü, xevitü pücu'eiriva. ");
INSERT INTO hchNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Yuhutatü mepütüxüni 'axeicüa. Xevitü panutivitüquieni xevitü pücu'eiriva. ");
INSERT INTO hchNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Yuhutatü vaxata mepe'uvani. Xevitü panutivitüquieni, xevitü pücu'eiriva. ");
INSERT INTO hchNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Müpaü metenicühüaveni, Ti'aitame haque müpaü püreyüni. Müpaü tinivacühüaveni, Haque caxari meca, mana virücüxi mepüyucuxeürieni. ");
INSERT INTO hchNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Mericüsü 'icü 'üxasi hepaüsita ticuxatatü müpaü tinivaruta'üquitüani quename heuyevese yuheyemecü müyuneneviecacü, cavaüripietü. ");
INSERT INTO hchNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Müpaü niutayüni, 'Isücame xeime quiecarisie necateitüni. Cacaüyari pücamacarücai 'iya, pücava'eniecai teüteri. ");
INSERT INTO hchNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Mericüsü 'uca cünaya mumü mana necateitüni mücü quiecarisie. 'Isücamesüa ni'axecaitüni müpaü 'utaitü, Heiserie queneneupitüa münesi'aye'unie yamücatiyurienenicü. ");
INSERT INTO hchNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Müixa pücayuvaüriyacai 'isücame. Peru 'arique müpaü tiniyücühüavecaitüni, Sepa nemüca'imacarüca Cacaüyari, sepa nemücava'enie teüteri, ");
INSERT INTO hchNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","'icü 'ucarasi cünaya mumü canetini'uxitüaca. Mecuxi heiserie necanipitüamücü, capa 'uta'axetü nesi'utaxütüanicü. ");
INSERT INTO hchNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Mericüsü Ti'aitame müpaü niutayüni, Xecani'enieni niuquieya que mutayü mücü 'isücame heiseriemecü yamücatiyurienecai. ");
INSERT INTO hchNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Cacaüyari masi heiserie cativapitüani müme müvaranuyexei tucaricü tücaricü memitihivie. Que reutevini vaparevietü. ");
INSERT INTO hchNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Yanepütixecühüave, cuitü heiserie canivapitüamücü. Masicutatü, quepaucua nemunuani Yuri Tevi nehücütütü, yuri mete'eriecame netivataxeiya cuiepa 'acu. ");
INSERT INTO hchNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","'Ipaüta tini'üquitacaitüni 'üxasi hepaüsita ticuxatatü, hipatü yuhesie yuri memüte'eriecaicü quename heiseriemecü yametecahucai, mevaxani'erietü hipame. Müme müpaü tinivarutahüave, ");
INSERT INTO hchNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Teüteri tuquipa meneutiyunixüani meyutanenevienique yuhutatü. Xevitüri Pareseu pühücütücai, xevitüta tevi cuviyexunusie mieme mütiyetuiriyari pühücütücai. ");
INSERT INTO hchNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Mericüsü Pareseu mana 'utaqueca nenevieri niyupitüacaitüni müpaü 'utaitü, Cacaüyari, pamüpariyusi nemanipitüaca hipame teüteri vahepaü nemüca'anecü ne. Müme mepütenavaya, heiseriemecü yamepücatecahu, hipame va'üitama mepüvacumaüva, mesü 'icü tivavamepaü mepü'anene. ");
INSERT INTO hchNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ne masi hutacüa nepünehaquiva xexuime semanasie, ne'ivarica naime xei tapari nepütinetua tuquita mieme, tamamata taparisie mieme. ");
INSERT INTO hchNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Hicü tivavame yateva 'uvetü pücayuvaüriyacai siquere yuheima meutinierecü. Masi yutavisie yucusunatü hivericacü müpaü niutayüni, Cacaüyari 'acu, quene'avaüriya 'aixüa pemünetixeiyacü, 'axa netiyuruvametüme. ");
INSERT INTO hchNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Müpaü nepütixecühüave, mücü masi yuquie neucayune heiserie hexeiyatü, Pareseu pücatixaü. Yunaitü tixaütü metehümetüme memayuyeitüva, tixaü mecatehümetütü mecanayeitüariecuni, peru que mü'ane tixaü catihücütüme mayuyeitüva, mücü tixaü tihücütütü canayeitüariemücü. ");
INSERT INTO hchNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Mericüsü 'asita türi mecaniva'atüvacaitüni hesüana vahesie mutimenicü. Teyü'üquitüvamete mevaruxeiyaca menivarutate'acaitüni. ");
INSERT INTO hchNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Hicü Quesusi yu'aurie nivarutahüave türi müpaü 'utaitü, Xequenivapitüaca türi nehesüa memü'axenicü. Xepücavanenaca. Cacaüyari müya me'aneneme catiniva'aitüvametüni. ");
INSERT INTO hchNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Niuqui caniseüyeni que nemütixecühüave, nunusi 'aixüa 'iyaricü que mütiyuvaüriya, que mü'ane hepaüna mücayuvaüriya Cacaüyari müti'aitüacacü, mücü pücatipitüarieni meixeiyanicü müti'aitüacacü. ");
INSERT INTO hchNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Mericüsü te'aitamete xevitü müpaü tinita'ivaviya, Ti'üquitame 'aixüa pemütiuca'iyari, que netiyurieyu nehesie pütinaque tucari mücaxüve. ");
INSERT INTO hchNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Quesusi müpaü tinita'eiya, Titayari 'aixüa netiuca'iyarime penetixata. Tevi 'aixüa mütiuca'iyari 'apüca'uyeica. Cacaüyari yuxevitü 'aixüa pütiuca'iyari püta. ");
INSERT INTO hchNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","'Ecü 'aisica pepümate, xeime 'üyaya pepücacumaüvani ya xeime cünaya, pepücati'amemivani, pepücatinavayani, xeimesie pepücarahüpani peti'itavatü, 'aquemasi 'avarusi quetinivareuyehüvirieca, que manuyüne. ");
INSERT INTO hchNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","'Iya rehüave, 'Icü naimesie yanepüticamie temaicüyaripai. ");
INSERT INTO hchNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Quesusi 'u'enaca müpaü tinitahüave, Xei mieme xeicüa peuyevese yapemütiyurieni. Nai pemürexeiya quetineutua, quetinivarumicua memümamave. Müpaü petiyurieme muyuavisie vaüca pepeucaqueni. 'Arique quenayaca, nehesie quetineviyani. ");
INSERT INTO hchNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Hicü mücü niuqui 'u'enieca niyuhiveriecaitüni vaüca mürexeiyacaicü. ");
INSERT INTO hchNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Hicü Quesusi 'ixeiyatü yuhiveriecame, müpaü niutayüni, Canicuaniveni xicusixi memaye'axüanicü Cacaüyari mütiva'aitüvametünicü. ");
INSERT INTO hchNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Sepa mücacuaniveniqueyu cameyu manuyehanicü 'ivipame hüxieyasie, peru siepüre masi yeme pücuanive xicu maye'anicü Cacaüyari müti'aitüvametünicü. ");
INSERT INTO hchNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Memü'enanacai müpaü meniutiyuani, Mericüte, xüca müpaü 'aneni, quepai püyüve mütavicueisitüarienicü. ");
INSERT INTO hchNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","'Iya müpaü tiutayü, Tita teüteri memütetexie, Cacaüyari caniyüveni. ");
INSERT INTO hchNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Hicü Pecuru müpaü niutayüni, Camü, tame tapini nai tete'ucu'eirieca 'ahesie tepüteviya. ");
INSERT INTO hchNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Müpaü tinivarutahüave, Niuqui caniseüyeni que nemütixecühüave, que mü'ane micu'eirie yuqui yu'uquiyarima yü'üya yu'ivama yumarema yütüriyama, yamütiyünicü que müti'ane Cacaüyari ti'aitametücacu, ");
INSERT INTO hchNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","mücü cuini mieme masi vaüca varexeiyatü canayeimücü hicü, tucari 'umamiesie 'aye'ame, tucari mücaxüve hexeiyatü canayeimücüta. ");
INSERT INTO hchNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Hicü Tamamata Heimana Yuhutame yateva varevitüca müpaü tinivarutahüave, Neuxei, Querusareme teneta'axüacuni. Naitü que müre'uxa texaxatamete vaxapasie Yuri Tevi hepaüsita, naitü catinaye'amücü. ");
INSERT INTO hchNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Necaniyetuiyamücü müme memücatateüterima vahesüa, necaninanaimariemücü 'axa netinitahüavariemücü, ");
INSERT INTO hchNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","mecaneni'aüsicamacuni meha'atü. Menesicuvaxüame mecanenimiecuni. Peru hairieca tucarisie necananucuquemücü. ");
INSERT INTO hchNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Müme 'asimepücatemaicai tita mütixatacai. Niuquieya masi pü'aviesiecai vahesie mieme. 'Asimepücatehetima que müticuxatacai. ");
INSERT INTO hchNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Mericüsü Quericu quiecarisie 'aye'aximecacu Quesusi, xevitü 'acüpetü mana huye tesita niucateitüni tivautü. ");
INSERT INTO hchNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Hicü varu'enieca yumüireme teüteri me'anuyecücame nivacu'ivaviyacaitüni que mütiyüniquecai. ");
INSERT INTO hchNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Müpaü metenitahüave quename Quesusi 'uyüximecai Nasaretitanaca. ");
INSERT INTO hchNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Hicü macüpe carima niutahiva müpaü 'utaitü, Quesusi 'acu Raviri pemünu'aya, quenenenenimayaca cuerietü. ");
INSERT INTO hchNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Mexüacate menitatieni cayuvatü müticanicü. 'Iya masi carima niutahiva müpaü 'utaitü, Raviri nu'aya 'acu, quenenenenimayaca cuerietü. ");
INSERT INTO hchNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Hicü Quesusi mana 'utaqueca nita'aita mahanienicü hesüana. Nuacu 'auriena müpaü tinitahüave, ");
INSERT INTO hchNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Que matinaque nemümasiyurienicü. Rehüave, Ti'aitame, nepayeniereniqueyu. ");
INSERT INTO hchNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Hicü Quesusi müpaü tinitahüave, Quenanutanierisü. Yuri pemütiuta'ericü pepanayeve. ");
INSERT INTO hchNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Yapaucua nanutaniere. Neiveiya 'aixüa 'utaitü Cacaüyari hepaüsita. Yunaitü teüteri me'ixeiyaca visi meniutiyuanecaitüni Cacaüyari hepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Hicü heutahaca Quericusie hixüata niuyemiecaitüni. ");
INSERT INTO hchNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Mericüsü tevi mana niucateitüni Saqueu titevatü. Mücü tevavamete catiniva'aitüvametücaitüni cuviyexunusie mieme, püxicutücai. ");
INSERT INTO hchNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Nixeiyamücücaitüni Quesusi que müpaicütücai, peru 'esimutevicaicü puyutatexie teüteri memüyumüirecaicü. ");
INSERT INTO hchNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Vahüxie 'utanausaca nitimaque xapasie mixeiyacü, mana muyeyaniquecaicü. ");
INSERT INTO hchNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Hicü Quesusi mana 'uyemietü neutiniere. Müpaü tinitahüave, Saqueu, quenacamaqui xeiya. Peuyevese 'aquita nemenuanicü hicü. ");
INSERT INTO hchNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Cuitü nacamaque, yutemavietü nitanaqui'erieni. ");
INSERT INTO hchNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Me'ixeiyaca yunaitü meniniuquixiecaitüni hepaüsitana müpaü me'utiyuatü, Cari tevi 'axa mütiyuruvasüa punua. ");
INSERT INTO hchNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Peru Saqueu mana 'uvetü müpaü tinitahüave Ti'aitame, Neuxei Ti'aitame, nepini hixüata 'arücame nepütivamini memümamave. 'Itaricacü que nemütivacuamanacai hipame, naucamecü nepürapica. ");
INSERT INTO hchNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Hicü Quesusi müpaü tinicühüaveni, Camü, 'icü quie quiecatari meputavicueisitüarie hicü. Senecatü 'icütari 'Apurahami canixiüyarieyatüni. ");
INSERT INTO hchNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Yuri Tevi que nemütiteva, necaninuani nemüvacuvaunenicü müme memeuyexürie nemüvatavicueisitüanicü. ");
INSERT INTO hchNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Mericüsü 'icü me'eniecacu tavari 'üxasi hepaüsita ticuxatatü tinivaruta'üquitüani, Querusareme 'aurie meyeicacaicü, mümeta müpaü memütecu'erivacaicü quename cuitü 'isutüaniquecai ti'aitatü Cacaüyari masiücütü 'ayame. ");
INSERT INTO hchNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Müpaü niutayüni, Tevi ve'eme münu'ayatücai teva caniyemiecaitüni xeime cuieyarisie. Mana cayerieme para yucuiepa ti'aitametütü mayanicü, 'ariqueque ninuaniquecaitüni. ");
INSERT INTO hchNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Hicü tamamata yu'aurie varutahüaveca yuhesüa miemete te'uximayatamete, tumini nivaru'üitüani xei sienituyari yuxexuime. Müpaü tinivarutahüave, Xequetenetuaca mexi necanuave. ");
INSERT INTO hchNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Mericüsü hesüana miemete quiecatari meni'uxive'eriecaitüni. Niucamete menivarenü'ani 'utümana müpaü me'utiyuatü, Tame tepüca'inaqui'erie 'icü mütati'aitüacacü. ");
INSERT INTO hchNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Mericüsü 'anucayerieca 'ayeneca ti'aitametütü, tiniuta'aita hesüana memütahüavarienicü te'uximayatamete tumini müvaru'üitüa yamüretimanicü que memüte'uyuri yuxexuitü metetuatü. ");
INSERT INTO hchNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Mericüsü mexüacame caninuani müpaü 'utaitü, Cusiyari, 'atuminicü xei sienituyaricü tamamata sienituyari nepana'ivaxü. ");
INSERT INTO hchNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Müpaü tinitahüave, 'Aixüa puyü, ti'uximayatame 'aixüa pemütiuca'iyari pecanihücütüni. 'Esipaümemecü yapetihüritüarieca yapeticamietü pepatüa. Camü, heiserie nemanipitüaca, tamamata quiecariyari petiva'aitüvame pemayanicü. ");
INSERT INTO hchNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Hicü xevitü ninuani müpaü 'utaitü, Cusiyari, 'atuminicü xei sienituyaricü, 'auxüme sienituyari nepana'ivaxü. ");
INSERT INTO hchNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Müpaü tinitahüave 'iyata, Mericüte, 'ecü pepühüritüarie 'auxüme quiecariyari petiva'aitüvame pemayanicü. ");
INSERT INTO hchNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Hicüta xevitü ninuani müpaü 'utaitü, Cusiyari camü 'atumini xei sienituyari. Nepiti'avietaxü paniyucü 'eimeme, ");
INSERT INTO hchNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","nemasimacatü pema'a'eriyacü 'ecü, pemenu'üvecü tita pemücatiucaye, pemica'isanacü tita pemücatiuca'e. ");
INSERT INTO hchNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Müpaü tinita'eiya, 'Ahesie pepürahüpa 'acümana que pemutayü, ti'uximayatame 'aixüa pemücatiuca'iyari pemühücücü. 'Ecüsü müpaü pepütimaicai nemane'eriyacü, nemenu'üvecü tita nemücatiucaye, ne'ica'isanatü tita nemücatiuca'e. ");
INSERT INTO hchNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Titayari siquere netumini pecatiyetua tumini hüvemesüa, para nenuame nemüvaye'ünicü yapaümeme 'ana'ivame. ");
INSERT INTO hchNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Hicü müpaü tinivarutahüave yutupirisixima, Mücü tuminieya xequenenavairi, xequene'üitüa 'iya tamamata sienituyari mexeiya. ");
INSERT INTO hchNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Müpaü metenitahüave, Ti'aitame, tamamata canexeiyaniri. ");
INSERT INTO hchNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Müpaü nepütixecühüave, yunaitü tixaütü memütehexeiya mepütemiquieni, peru que mü'ane tixaü mücarexeiya, sepa que mütitita mürexeiya pütinavaiyarieni. ");
INSERT INTO hchNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Müme meta memünesi'aye'uniecai memücanesinaqui'eriecai netiva'aitüvame nemayanicü, 'uva xequenivarahapaca, nehüxie xequenivarucuya. ");
INSERT INTO hchNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Mericüsü müpaü 'utayüca neyani Querusareme heutiyuneque. ");
INSERT INTO hchNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Hicü Vetüpaque Vetaniya quiecaritesie heta'aximetü, Huriva Macu'u müracutevasie yemuri hetüa nuaca, yuhutame nivarutanü'ani teyü'üquitüvamete ");
INSERT INTO hchNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","müpaü haitü, Quiecari 'anutaüye mucumasie xequenehu. Mana xeheutahaxüame xepeitaxeiya puxu nunusi hacuviecame, tevi müca'anutiyerüve cuxi hesiena. Xehecuxüname xequenahani. ");
INSERT INTO hchNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Xevitü xüca müpaü tixe'utahüave, Titayari xete'ecuxüna, müpaü xepüte'itahüave, Ti'aitame peiyehüva. ");
INSERT INTO hchNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Hicü memutanü'arie menecüne. Meneitaxeiya que mütivarutahüavixü. ");
INSERT INTO hchNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Puxu nunusi mecuxünacacu, cusiyarimama müpaü metenivarutahüave, Titayari xete'ecuxüna puxu nunusi. ");
INSERT INTO hchNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Müme müpaü metenivarutahüave, Ti'aitame peiyehüva. ");
INSERT INTO hchNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Hicü Quesusisüa meneihana. Yü'ücarite me'enutitüaca puxu nunusisie menenutiyeni Quesusi. ");
INSERT INTO hchNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Hicü 'uyemiecacu yü'ücarite meni'itüaximecaitüni huyeta. ");
INSERT INTO hchNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Hicü Huriva Macu'u yemuriyaritüa viyeta me'ucahutü, yunaitü teyü'üquitüvamete meyumüiretü meyutemamavietü menisutüani carima 'aixüa me'utiyuatü Cacaüyari hepaüsita, nai que memüte'uxei türücaüyemecü que mütiuyü hepaüsita ");
INSERT INTO hchNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","müpaü me'utiyuatü, 'Aixüa queticühüavarüvani que mü'ane ti'aitametütü 'umamie, que mü'ane Tati'aitüvamesüa miemetütü 'umamie. Taheima 'aixüa mequeteyuxeiyani, vapaitü visi meque'utiyuaneni. ");
INSERT INTO hchNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Hicü Pareseusixi hipatü memu'uvacai teüteri vasata müpaü metenitahüave, Ti'üquitame, 'ahesüa miemete quenivarutati'a teyü'üquitüvamete. ");
INSERT INTO hchNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Müpaü tinivarutahüave, Yanepütixehahüave, 'ime xüca cayuvatü me'umacaque, tetexi püta mepütihivaqueyu. ");
INSERT INTO hchNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Mericüsü 'aura 'umietü 'ixeiyaca quiecari, niutasuani he'erivatü, ");
INSERT INTO hchNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","müpaü 'utaitü, 'Ecütütü siquere 'icü tucarisie xüca tüma peheitimanique tita müreuyevese para 'aixüa pemütixeiyariecacü. Masi niuti'aviesieni hicü 'ahüxicü pemüca'ixeiyacü. ");
INSERT INTO hchNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Tucari canaye'amücü, 'ana müme memümasi'aye'unie cuya tesariyayari meniti'uitüacuni 'a'aurie, 'ana 'a'aurie meniti'uicuni, para teüteri memücavayecünecü. ");
INSERT INTO hchNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Mecamanatihüacuni cuiepa 'ecü, 'ateüterimata 'ahesüa memüyetei mepatixüriyani cuiepa. 'Ahesie tete xevitü pücacu'eiriva yuheima 'atetü. Müpaü catiniyümücü 'ecü pemüca'imaicaicü tucari quepaucua Cacaüyari müyuvaüriyacai 'ahesie mieme. ");
INSERT INTO hchNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Hicü tuqui 'amüpa curaruyarita heutahaca nisutüani varanuyeveveiyatü tetuayamete ");
INSERT INTO hchNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","müpaü tivacühüavetü, 'Ipaü püre'uxa, Nequi nenevieri caniquiyaritüni. Xeme püta terü xecanayeitüani haque tenavayamete memeyu'avieta. ");
INSERT INTO hchNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Mericüsü tucaricü tini'üquitacaitüni tuqui curaruyarita. Mara'acate memühüritüariecai, müme meta 'inüaricü memüte'üquitametetücai, teüteri va'uquiyarima yunaitü menicuvautüvecaitüni me'imienique. ");
INSERT INTO hchNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Peru müme mecaniyutatexieni müpaü meteyurienique, yunaitü teüteri memi'eniecaicü me'ihive'erietü niuquieya. ");
INSERT INTO hchNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Mericüsü heiva teüteri tiniva'üquitüacaitüni tuqui 'amüpa curaruyarita 'ayevetü, niuqui 'aixüa manuyüne vacuxaxatüvatü. Hicü mara'acate memühüritüariecai mümeta 'inüaricü memüte'üquitametetücai vahamatü 'uquiravesixi vahamatü meniu'axüani. ");
INSERT INTO hchNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Müpaü metenitahüave, Quetatineutahecüatüa haque memieme heiserie pemexeiya 'ipaü pemütiyurienecü. Que mü'ane 'icü heiserie masipitüa 'iya pemütiyurienecü. ");
INSERT INTO hchNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Müpaü tinivarutahüave, Mericüte neta xei niuquiyari nepüxeta'ivaviya. Yaxequeneteneutahüavi ne. ");
INSERT INTO hchNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Vani quepaucua müti'üyanecai, taheima mieme yatipitüariecai, teüteri xeicüa yamepüte'ipitüa nusu. ");
INSERT INTO hchNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Mümeri müpaü meteniyücühüavecaitüni, Xüca tame müpaü te'utiyuani quename taheima mieme pitüariecai mücü müpaü canitayümücü, Mericüte, titayari yuri xecate'ita'eriri. ");
INSERT INTO hchNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Masi xüca müpaü te'utiyuani quename teüteri me'ipitüacai, yunaitü teüteri tetecü mepütasitituaxa, yuri memüte'eriecü quename Vani tixaxatame hücütücai Cacaüyarisüa mieme. ");
INSERT INTO hchNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Hicü müpaü metenita'eiya quename 'asimecatemaicai haque mepitüariecai. ");
INSERT INTO hchNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Quesusita müpaü tinivaruta'eiya, Mericüte neta 'asinepücatixetahüave haque memieme heiserie nemexeiya 'iya nemütiyurienecü. ");
INSERT INTO hchNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Mericüsü 'icü 'üxasi hepaüsita ticuxatatü nisutüani tiva'üquitüatü teüteri müpaü 'utaitü, Tevi haraveri putavevi. Te'üviyamete nivaruhüritüani vacuetatüatü. Tevapai caneyani müixa. ");
INSERT INTO hchNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Hicü tucari canaye'ani maticuacuaxesie. Ti'uximayatame niutanü'ani te'üviyamete vahesüa memiyetuirienicü haraverita mieme yapaümeme cusiyarisie mieme. Peru te'üviyamete me'icuvaxüaca yacü xeicüa maveme meneinü'ani. ");
INSERT INTO hchNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Hicü tavari ti'uximayatame niutanü'ani. Müme me'icuvaxüaca 'iyata, me'inanaimaca, meneinü'ani yacü xeicüa maveme. ");
INSERT INTO hchNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Tavari hairieca xeime niutanü'ani. Meheicuvitexüaca menenuyehüani. ");
INSERT INTO hchNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Hicü haraveri cusiyari müpaü niutayüni, Queri netiyurieni. Nenive nepanunü'ani neminaqui'erie. Tietü meteheiyehüviriecuni. ");
INSERT INTO hchNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Hicü te'üviyamete me'ixeiyaca, niuqui meniutixüatüatücüne müpaü me'utiyuatü, Camüsü, 'icüsie catininaquimücü cusiyari pinieya. Tepimieni tahesie püta mütinaquenicü pinieya. ");
INSERT INTO hchNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Hicü haraveri vari meneicahüani, menimieni. Mericüte, que vayurieni haraveri cusiyari. ");
INSERT INTO hchNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Caninuamücü, nivatixütüamücü müme te'üviyamete. Hipame püta nivahüritüamücü yuharaveri. Müme memü'enanacai müpaü meniutiyuane, Xüca müpaü catiuyünique tüma. ");
INSERT INTO hchNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","'Iya vaxeiyatü müpaü niutayüni, Mericüte, xüca müpaü catiyüni, titayari 'ipaü raine 'utüarica 'aumü, Mücü tete memutixani'erie qui vevivamete, Mücü 'isiquina titutuicame nayani. ");
INSERT INTO hchNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Yunaitü mücü tetesie memacaxürieni mepütimurixüani. Que mü'anesie mücaveni, pitaviviexüani. ");
INSERT INTO hchNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Mericüsü 'anatütü müme 'inüaricü memüte'üquitametetücai mara'acate memühüritüariecai yunaitü metenicuvautüvecaitüni que memüte'iviyacü, peru menivamacarücaitüni teüteri müpaü metemaitü, müme müvaxatacaicü mücü 'üxasi hepaüsita ti'üquitatü. ");
INSERT INTO hchNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Hicü me'itihupienique menivarutanü'ani 'avie nenieremete teüteri heiseriemecü yamemütecahu vahepaü memüyüacai yacü xeicüa. Me'iviyame niuquieyacü meniyetuaniquecaitüni, cuvexunaruri mita'ivaviyacü 'isücametütü. ");
INSERT INTO hchNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Hicü menicu'ivaviyacaitüni müpaü me'utiyuatü, Ti'üquitame, tame tepütemate 'ecü heiseriemecü pemüticuxatacü, heiseriemecü pemüti'üquitacü. Yücü pepücativaxeiya teüteri, masi Cacaüyari huyeya hepaüsita pepüti'üquita que mütivaiyacü. ");
INSERT INTO hchNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Tamüsü, titauniva temütetatuanicü Sesaxi cuviyexunuyasüa mieme, pücatauniva nusu. ");
INSERT INTO hchNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Timaitü que memüte'i'irüviyacai, müpaü tinivarutahüave, Titayari xenete'inüatatüve. ");
INSERT INTO hchNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Tuminiyari xequeneneuxeisitüa. Quepai ramu'u püra'uxa, quepai püra'utüarica. Müme müpaü metenitahüave, Sesaxi mu'uya canihücütüni, 'utüaricaya meta. ");
INSERT INTO hchNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Müpaü tinivarutahüave, Mericüte tita Sesaxisüa mütimieme, Sesaxi xequetenapinirieca, tita Cacauyarisüa mütimieme, Cacaüyari xequetenapinirieca. ");
INSERT INTO hchNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Mepüyutatexi niuquieyasie me'iviyacutü teüteri vahüxie. Mehüxiyatü müya mütivarutahüavixücü cayuvatü meniumacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Mericüsü Saruseusixi hipatü meniu'axüani müpaü memutiyuanecai quename müquite meca'anucu'uni. Hicü müme menita'ivaviya, ");
INSERT INTO hchNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","müpaü me'utiyuatü, Ti'üquitame, Muisexi müpaü catiniu'utüani tahesie mieme, tevi xüca masicaya 'umüni neüquetü, xüca türi cavarexeiyani, mücü tevi mutaya canitivitümücü yucue, türi nivativevimücü yumasica nivemama. ");
INSERT INTO hchNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Mericüsü 'atahutatü 'amenititecaitüni 'ivamarixi. Vamasica 'itivitüca 'uca niumüni, türi cavaruhayevaca. ");
INSERT INTO hchNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Mutaya yaxeicüa tiniuyurieni, tiumü türi cavaruhayevaca. ");
INSERT INTO hchNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","'Iyata mutaya hairieca nitivitüni niumüni. Yaxeicüa 'atahutatü yunaitü türi mecavaruhayevaca meniucuini. ");
INSERT INTO hchNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","'Imatüriecata niumüni 'uca. ");
INSERT INTO hchNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Mericüte, quepaucua xeniu memanucu'uni, 'atahutatü memitivitü, quepai ra'üya pürayani. ");
INSERT INTO hchNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Hicü Quesusi müpaü tinivarutahüave, Hicü miemete teüteri mepüneneüque mepüviquie. ");
INSERT INTO hchNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Müme vahesie mütinaque mücü cuie mühecuasie memaye'axüanicü, vahesie mütinaque memanucu'unicü müquite vasata, müme mepücaneneüqueni mepücaviquieca. ");
INSERT INTO hchNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Mücü meta, 'ana mepücayüvaveni tavari memücuinicü, Cacaüyarisüa miemete niuqui tuayamete vahepaü me'anenetü. Masi Cacaüyari nivemama mecanihümetüni, müme memanucu'uni. ");
INSERT INTO hchNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Müquite que memüte'anucu'uni, müpaüta Muisexi tiniu'üquita, yuxapasie haque tupiriya mexata. Müpaü cananuyüneni, 'Apurahami 'Isahaqui Cacuvu vacacaüyari canihücütüni Ti'aitametütü. ");
INSERT INTO hchNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","'Ayumieme müquite pücavaxata quename vacacaüyari haitü. Memayeneniere püta vacacaüyari caniyuxatani, sepa memucui. Yunaitü mepayeneniere que mütivaxeiya. ");
INSERT INTO hchNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Hicü müme 'inüaricü memüte'üquitametetücai hipatü müpaü metenicühüaveni, Ti'üquitame, 'aixüa pepaine. ");
INSERT INTO hchNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Tavari mepücayuvaüriyacai memita'ivaviyacü. ");
INSERT INTO hchNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Hicü müpaü tinivarutahüave Quesusi, Titayari müpaü mete'utiyuane quename Cürisitu Raviri xiüyarieya hücü. ");
INSERT INTO hchNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Mücü Raviritütü cuicari xapayarisie müpaü paine, Ti'aitame müpaü tinitahüave que mü'ane müneti'aitüa, Neserieta quenacani. ");
INSERT INTO hchNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","'Ahetüapai mexi nevarahapani müme memümasi'aca'unie. ");
INSERT INTO hchNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Hicümü Raviritütü Neti'aitüvame tinitaterüva. Mericüte, xüca Cürisitu tita'aitüani Raviri, que timasiücü quename xiüyarieya. ");
INSERT INTO hchNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Mericüsü yunaitü teüteri me'i'eniecacu müpaü tinivarutahüave teyü'üquitüvamete, ");
INSERT INTO hchNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Xequeneyucuerivayurieca müme 'inüaricü memüte'üquitamete vahepaüsita, müme müvanaque 'etütüme me'anacatütü memeu'uvanicü, müme memeunaqui'a vaürisica memüpitüarienicü quiecari hixüapa, teüteri vahüxie memüyeyaxecü tuquita, quiecame 'aurie memayaxecü 'ixüararipa, müme vahepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Müme viyurasixi vapini mepütevarutixütüiri, 'emeteheutevitü neneviericü para mücamasiücünicü que memüteyurie. Müme vahesie masi yemecü tinahüivani. ");
INSERT INTO hchNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Mericüsü heutaniereca nivaruxeiya xicusixi yu'imiquieri meheucaxürüvame tumini cacuniyarisie tuquita. ");
INSERT INTO hchNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Hicü 'uca tiuxei cünaya mumü tuminicü mümavecai mana heicaxürüvame huta senitavuyari. ");
INSERT INTO hchNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Müpaü niutayüni, Niuqui caniseüyeni que nemütixecühüave, 'icü viyura tuminicü mavetü cacunisie neicaxürieni vaücava, müme yunaitü 'esiva xeicüa meneicaxürieni. ");
INSERT INTO hchNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Müme yunaitü yuhayevame meneucaxürieni Cacaüyarisie mieme 'imiquieri. 'Icü 'uca yuhaveri mieme püta neucaxürieni cümana mütiyumicuacai naime. ");
INSERT INTO hchNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Mericüsü hipatü tuqui 'amüpa hepaüsita metenicuxatacaitüni, que mütiquemaritüariecai tete visi 'anenemecü mavari visi 'anenemecü. Müpaü niutayüni Quesusi, ");
INSERT INTO hchNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Xepixeiya 'icü. Tucari canaye'amücü quepaucua tete pücacu'eiriva yuheima 'atetü. Naitü püca'unarieni. ");
INSERT INTO hchNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Müme müpaü metenita'ivaviya, Ti'üquitame, quepaucua müpaü pütiyüni que pemaine. Tita ti'inüaritüni quepaucua maye'aximeni. ");
INSERT INTO hchNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Hicü müpaü niutayüni, Xequeneyucuerivayurieca capa xeheuyexüriyanicü. Yumüiretü mecani'axüacuni, quename nehesüa memiemete me'utiyuatü, Ne necanihücütüni me'utiyuatü, Tucari canaye'aniri me'utiyuatü. Va'utüma xepücahecücani. ");
INSERT INTO hchNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Quepaucua cuyaxi xemüva'enieni meyucuitüveme, quepaucua xemütetamarieni memanucu'uiximecü cuyacü, xepüca'atixürüveni maricacü. Neuyeveca müpaü mütiyünicü meri, peru 'acuxi cuitü pücatapare. ");
INSERT INTO hchNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","'Ana müpaü tinivarutahüave, Nuivarite mecaniyeha'acuni mevacuicutü hipame nuivarite. Xexuime cuieyarisie quiecatari mepüyeha'ani hipame cuieyarisie miemete mevacuicutü. ");
INSERT INTO hchNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Cuie carima canitayuamücü, xexuime quiecariyarisie haca canitavemücü vaüca cuiniyata. 'Inüari mamarivaveme muyuavisie mexeiyatü, mecanimariusiecacuni. ");
INSERT INTO hchNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Yacatiyüvecacu cuxi, mepüxetiviya xeme, mepüxe'anuyeveiya. Mepüxeyetuani tuquiteta, casariyanata xemanutaxüriyanicü. Xepanuhapaniexüani te'aitamete vahüxie 'isücate vahüxie nehesüa xemümiemetecü. ");
INSERT INTO hchNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Müpaü xe'itüarieme xecaniyüvavecuni xemütehecüatanicü. ");
INSERT INTO hchNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","'Ayumieme yu'iyari xequeneseiriyani, xetiviyarieme xepücayu'iyaritüaca que xemutiyuaneni. ");
INSERT INTO hchNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ne püta temaivavemete necanixe'ayeitüamücü, xemütiniunicü. 'Ayumieme yunaitü memüxe'aye'unie mecaniyutatexicuni mexe'a'ivacutü mexeniuquimacutü. ");
INSERT INTO hchNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","'Asita xe'uquiyarima xe'ivama xemarema xehamicuma mecanixeyetuacuni. Hipame xeme mepüxecuini. ");
INSERT INTO hchNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Yunaitü mecanixe'uxive'eriecacuni nehesüa xemümiemetecü. ");
INSERT INTO hchNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Peru ni xei cüpayari pücaheuyeveni xemu'usie mieme. ");
INSERT INTO hchNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Xete'uca'enivatü tucari xecaniyupitüacacuni. ");
INSERT INTO hchNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Quepaucua xemüvaxeiya cuyaxi Querusareme 'aurie meyucuxeürieximecacu, 'ana müpaü xecatenimaicacuni maye'aximecü quepaucua 'acumavetü mayani. ");
INSERT INTO hchNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","'Ana müme Cureya cuieyarisie meme'uvani meque'uyuta'unaxüani hürisie. Müme quiecarisie memütiteni mequevayecüni. Müme yeuta meme'uvani mepücaheutahaxüani quiecarisie. ");
INSERT INTO hchNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Mücü tucarisie heiseriemecü mepüte'apiniyarieni quiecatari, 'ana catinaye'amücü naitü que müre'uxa. ");
INSERT INTO hchNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Xüa 'ui müme memuhuca müme memütesisitüani mücü tucarisie. 'Uximatüarica canitavemücü cuiepa, haxüa canitixuaverimücüta 'icü teüteri vahepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","'Ixiparacü menitacui'ivacuni, yunaime nuivarite vahesüa mecananuhapaniecuni vaüriyarica. Nuivarite memücatateüterima mepütetürücariya Querusaremesie mexi vatucari cataparive. ");
INSERT INTO hchNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","'Inüarite pütixuavere tausie mesasie xuravesixi vahesie. Cuiepa meta nuivarite mepü'iyarixitüarieca meyuhiverietü, 'asimecatemaitü que memüteyurieni, haramara hamevari que mütiuyuane, müpaü meteyumaitü. ");
INSERT INTO hchNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Maricacü teüteri mepü'amüxüani mehe'erivatü cuiepa memütama que memü'itüarieni. Taheima miemete türücavimete mepütayuitüarienita. ");
INSERT INTO hchNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","'Ana Yuri Tevi que nemütiteva mecanenixeiyacuni haisata ne'acamieme netürücaüyetü cui nexavatütü. ");
INSERT INTO hchNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Yatisutüarieximecacu xequeneutineniereni 'aixüa xequeteneyumaica. 'Ana paye'aximeni quepaucua xemütixünarieni. ");
INSERT INTO hchNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Hicü 'üxasi hepaüsita ticuxatatü tinivaruta'üquitüani müpaü 'utaitü, Xequeneu'ixüari pini ya naime cüyexi. ");
INSERT INTO hchNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Quepaucua mütixavata, xe'i'ixüarietü yücümana xepütemaica tasüari 'auracacutüca. ");
INSERT INTO hchNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Xemeta yaxeicüa, quepaucua xemixeiya 'ipaü yüaneme, xequetenemaica maye'aximecü Cacaüyari misutüanicü ti'aitatü. ");
INSERT INTO hchNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Niuqui caniseüyeni que nemütixecühüave, hicü miemete mepücatixüni mexi ca'aye'ave naitü. ");
INSERT INTO hchNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Muyuavi cuie naitü canitixümücü, peru neniuqui pücaxüni. ");
INSERT INTO hchNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Xequeneyü'üviyani capa xe'iyari 'u'itutuperecü xecu'ixüaratüvecacu xetarüvecacu cuiepa mieme tucaricü xeyu'iyaritüacacu. Xüca müpaü xeteyuriecaque, 'iya tucari yapaucua püxe'axe ");
INSERT INTO hchNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","viniyaripaü. Mücü tucarisie menita'axiyariecuni yunaitü cuiepa memütama naisarie. ");
INSERT INTO hchNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Xequenayeneniereni 'aixüa, yuheyemecü xeyunenevietü para xemüyüvavenicü, Yuri Tevi hüxie xemaye'axüanicü xetavicueme 'uximatüaricasata 'umüramie. ");
INSERT INTO hchNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Mericüsü tucaricü tuqui 'amüpa curaruyarita niuyeicacaitüni ti'üquitatü. Tücaricü vayeyeicatü Huriva Macu'u yemuriyarisie nehupucaitüni. ");
INSERT INTO hchNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Yunaitü teüteri yuimuana meni'axecaitüni hesüana me'i'enienique tuquipa. ");
INSERT INTO hchNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Mericüsü 'ixüarari canahurare quepaucua pa mücacuxanariyarie memücuacai mehe'erivatü Cacaüyari que mütivaruhayevaxü vateüterima. ");
INSERT INTO hchNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Hicü mara'acate memühüritüariecai müme 'inüaricü memüte'üquitametetücai metenicuvautüvecaitüni que memüte'imieniquecai memüvamacarücaicü teüteri. ");
INSERT INTO hchNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Hicü Cauyumarie niviya Cura 'Isicariutitanaca. Mücü Tamamata Heimana Yuhutame canixevitütücaitüni. ");
INSERT INTO hchNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Heyaca mara'acate memühüritüariecai vahesüa vacuyaxima vahesüa, metenicuxatacaitüni que mütivayetuirieniquecai. ");
INSERT INTO hchNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Müme meniyutemamaviecaitüni. Mepuyu'enie müpaü me'utiyuatü quename tumini me'i'üitüaniquecai. ");
INSERT INTO hchNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Mücü 'iyarieya ya'anecacu tinicuvaunecaitüni quepaucua 'aixüa müyüniquecai müvayetuirienicü teüteri 'ameca'u'uvacacu. ");
INSERT INTO hchNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Mericüsü Pa Mücacuxanariyari tucariyari naye'ani. 'Ana peuyevecai memüvacuinicü muxasi türixi 'ixüararicü. ");
INSERT INTO hchNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Hicü Quesusi nivarutanü'ani Pecuru Vanimame müpaü haitü, Xequenehu 'aixüa xequeneyuri 'ixüarari 'icuaiyari, temütecuanicü. ");
INSERT INTO hchNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Müme müpaü metenitahüave, Haque masihenaque 'aixüa temeiyurienicü. ");
INSERT INTO hchNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Müpaü tinivarutahüave, Camüsü xeheutahaxüaximecacu quiecarisie 'uqui nixe'anucunaquimücü ye'ü 'ahanatü hecuhanüca. Mücü xequenanuveiya quita haque meuhani. ");
INSERT INTO hchNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Müpaü xepüteheitahüave muva quiecame, Ti'üquitame müpaü pümarahüave, Hipatüte haqueva qui müme nemütiva'üquitüa nehamatü 'ixüarari 'icuaiyari temücuanicü. ");
INSERT INTO hchNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Mücü qui taüta xeheutivitüme canixexeisitüamücü hipame qui 'amüyeva naitü 'ureyepicame. Muva 'aixüa xequeteneyuri. ");
INSERT INTO hchNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Hicü menecüne, meneitaxeiya que mütivarutahüavixü. Muva 'ixüarari 'icuaiyari 'aixüa meniuyurieni para meme'erivanicü Cacaüyari que mütivaruhayevaxü vateüterima. ");
INSERT INTO hchNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Hicü 'aye'acu mexa 'aurie nayerüni, nü'arisixi yunaitü. ");
INSERT INTO hchNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Hicü müpaü tinivarutahüave, Cuini mieme nepihive'eriecai xehamatü 'icü 'ixüarari 'icuaiyari nemücuanicü necaticuinivetü cuxi. ");
INSERT INTO hchNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Yanepütixecühüave, tavari 'icü nepücacuani mexi ca'aye'ave tita 'ixüarari müti'inüariyari Cacaüyari ti'aitametücacu. ");
INSERT INTO hchNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Hicü tecüxi 'anuhanaca pamüpariyusi 'ipitüaca Cacaüyari müpaü niutayüni, Xequenanuhani 'icü, yuxexuitü xequenanuti'inüataxüa. ");
INSERT INTO hchNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Yanepütixecühüave, ni hicü ni 'uxa'atüni varie tavari nepüca'enu'ieni caxie hayari mexi ca'aye'ave Cacaüyari misutüanicü ti'aitatü. ");
INSERT INTO hchNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Hicü pa 'anu'üca pamüpariyusi 'ipitüaca Cacaüyari 'ititaraca nivarumini müpaü 'utaitü, 'Icü caninevaiyaritüni xehesie mieme müyetuiyani. 'Ipaü xequeteneyurieca xemünesi'a'erivanicü. ");
INSERT INTO hchNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Yaxeicüa tiniuyurieni tecüxi hepaüsita mete'ucuacu müpaü 'utaitü, 'Icü tecüxita mieme türatu hecuame canihücütüni nexuriyacü, müseiriyarieni xehesie mieme que mütitayeuriyani. ");
INSERT INTO hchNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Perusü que mü'ane münesiyetuani 'ena paca, mamaya mexasie pama haque nemaca. ");
INSERT INTO hchNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Yuri Tevi que nemütiteva, necaniyemieni nemümierienicü, que müti'aisie yamütiyünicü, perusü xüa 'ui que mü'ane münesiyetuani. ");
INSERT INTO hchNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Müme menisutüani niuqui mexüatüatü que mü'ane müme müxatacai quename müya tiyurieniquecai 'utaitü. ");
INSERT INTO hchNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","'Anata müme me'ütesatü menayu'iva que mü'ane müme masi müve'emetücai. ");
INSERT INTO hchNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","'Iya müpaü tinivarutahüave, Nuivarite teva'aitüvamete meteniva'uxitüaca mete'aitatü, müme heiserie memexeiya vahepaüsita quename 'aixüa meteyuruvamete meteniyuterüvani. ");
INSERT INTO hchNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Xeme püta müpaü xepücayüaca. Masi que mü'ane xeme müve'eme, mücü que mü'ane masi mühecuapaü queyüaneni. Que mü'ane mütixe'aitüa, mücü que mü'ane xehesie mieme müti'uximayapaü queyüaneni. ");
INSERT INTO hchNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Que xetecu'eriva, que mü'ane masi püve'eme, que mü'ane quiecametütü müticua'a, que mü'ane miparevie timicuatü, mücü nusu püve'eme. Xüari quiecame masi püve'eme. Perusü ne xesata nepuyeica xehesie mieme neti'uximayatü püta. ");
INSERT INTO hchNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Xeme nehesie xecateniviyacaitüni xecatehayevatü ne'inüasienecacu. ");
INSERT INTO hchNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ne'uquiyari que münetiucaye ti'aitame nemayanicü, neta yaxeicüa te'aitamete necanixecayasamücü. ");
INSERT INTO hchNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Nehamatü xecatenicuaicuni xeteni'iecuni mexa 'aurie ne'acaime neti'aitametücacu. 'Isücate xecanacünicuni, 'uvenisie xe'ayaxeme xecateniva'aitüacacuni teüteri tamamata heimana yuhutame nuivarite 'Ixaherisie memüyecü. ");
INSERT INTO hchNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Neuxei Simuni, yumarima 'aixüa. Cauyumarie püxevaucai, püxeta'inüata, püxeticase türicupaü. ");
INSERT INTO hchNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ne masi nepünetanenevie 'ahesie mieme pemücatihayevacü yuri peti'erietü. 'Ecüta quepaucua pemütihayeva peheuyevausetü quenivatuicani 'a'ivama. ");
INSERT INTO hchNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Mücü müpaü tinitahüave, Ti'aitame, nepünevaüriya 'ahesie nemütiviyanicü sepa nemanutahüiyani sepa nemumierieni. ");
INSERT INTO hchNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Rehüave, Pecuru 'acu, müpaü nepümaticühüave, vacana catahivavecacu cuxi hicü, 'ecü haicacüa pecani'acu'imavamücü, quename pecanesimate pe'utaitü. ");
INSERT INTO hchNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Hicü müpaü tinivarutahüave, Quepaucua nemüxeheutanü'axüa cüsiuri xerai cacai xecate'upicame, tixaü xeteheuyehüacai 'acu. Müme Tixaüsü meniutiyuani. ");
INSERT INTO hchNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Müpaü tinivarutahüave, Hicüsü püta müpaü pücatiyüni. Que mü'ane cüsiuri mexeiya queheihurieni, xerai meta yaxeicüa. Que mü'ane mücaheixeiya cuya cusiraya yü'ücari que'utuani que'inaneni. ");
INSERT INTO hchNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Yanepütixecühüave, peuyevese nehesie maye'atüarienicü müpaü que müre'uxa, 'Inüari niuquiyari sanamete vahepaü niu'itüarieni que müranuyüne. Naitü nehepaüsita que müre'uxa canaye'atüarieximeni. ");
INSERT INTO hchNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Hicü müme müpaü meniutiyuani, Ti'aitame, neuxei cusirate 'uva hutatü. 'Ariri, tinivacühüaveni. ");
INSERT INTO hchNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Mericüsü vayeyaca neyani haque me'axecai Huriva Macu'u yemuriyarisie. Teyü'üquitüvamete meniveiyacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Hicü muva heta'aca müpaü tinivarutahüave, Xequeneyunenevieca, capa xe'uta'isiparienicü. ");
INSERT INTO hchNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Hicü yuxaüta yerümütü yateva niuyani memanucateisie tete que mürehüiva yacütütü. 'Utitunumaqueca niyutanenevieni ");
INSERT INTO hchNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","müpaü 'utaitü, Ne'uquiyari, xüca pe'avaüriyani, 'icü tecüxi quenanuhani cuerietü yanemüca'itüarienicü. Masi que münetinaque ne pücatixaü, que matinaque 'ecü püta yaquetiuyüni. ");
INSERT INTO hchNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Hicü niuqui tuayame masiücütü nayuyeitüani taheima mieme 'itürücariyatü, nixeiya. ");
INSERT INTO hchNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Hicü cui yüanetü hivericacü, masi cuini mieme yutatuatü niyuneneviecaitüni. Cuaxiyaya xuriya suniriyaripaü cani'anenecaitüni cuiepa caxürüvetü. ");
INSERT INTO hchNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Mericüsü yutanenevieca 'anucuqueca teyü'üquitüvamete vahesüa nuaca mana nivarutaxeiya mecusume hivericacü. ");
INSERT INTO hchNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Müpaü tinivarutahüave, Titayari xetecusu. Xequenanucu'uti xequeneyunenevieca capa xe'uta'isiparienicü. ");
INSERT INTO hchNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Mericüsü 'utaniucacacu cuxi yumüiretü teüteri meniu'axüani. Xevitü nivaravitücücaitüni Tamamata Heimana Yuhutame vahesie miemetütü Cura titevatü. Quesusi 'aurie niutaqueni 'i'isenique. ");
INSERT INTO hchNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Peru Quesusi müpaü tinitahüave, Cura, penesi'iseme penetiyetuani Yuri Tevi que nemütiteva. ");
INSERT INTO hchNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Teüterimama metemarietü que mütiyüniquecai müpaü meniutiyuani, Ti'aitame, tacusiracü tetetacuini. ");
INSERT INTO hchNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Xevitü müme nicuva tevi mara'acame mühüritüariecaisüa mieme müti'uximayatametücai. Nacaya naviteni serietana mieme. ");
INSERT INTO hchNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Peru Quesusi müpaü niutayüni, 'Ari xequeteneuhayeva. 'Imayüaca nacaya nenayehüani. ");
INSERT INTO hchNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Hicü Quesusi müpaü tinivarutahüave mara'acate memühüritüariecai cuyaxi tuquipa miemete 'uquiravesixi memeyecü me'iviyaque, Cari xepeyecü cusirate cüyexi xe'u'ütü xenesiviyaque, tinavayamepaü que mütiviviyarüva. ");
INSERT INTO hchNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Tucaricü xehesüa ne'uyeicacacu tuquipa xepücanesi'umayüa. Peru 'icü xetucari canihücütüni yamütiyünicü, Yüvicame heiserie pexeiya hicü. ");
INSERT INTO hchNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Mericüsü me'iviyaca meneivitüni. Mara'acame mühüritüariecai quita meni'atüani. Pecuru yateva niveiyacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Tacua hixüapa me'utinaicu me'utiyaxecu Pecuruta niutayerüni va'aurie. ");
INSERT INTO hchNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Hicü xevitü 'üimari mana müti'uximayacai 'ixeiyaca hecüaripa 'ucaime 'ixeiyatü müpaü niutayüni, Cari 'icüta hamatüana niuyeicacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Mücü niyucu'imavacaitüni müpaü 'utaitü, 'Uca 'acu, nepüca'imate. ");
INSERT INTO hchNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Yareutevitüta xevitü 'ixeiyaca müpaü tiutayü, 'Ecüsü xevitü müme pecanihücütüni. Pecuru müpaü tiutayü, Que cüxipa ne nepücahücü. ");
INSERT INTO hchNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Hicü xei hurayari 'aye'acu yacütüniquetü xevitüta heiseriemecü müpaü niutayüni, Masi 'icü hamatüana niuyeicacaitüni, pücarereyatanaca. ");
INSERT INTO hchNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pecuru raine, Quetütüri, ne 'asinepücatimate que pemaine. Yapaucua haniucacacu cuxi vacana niutahiva. ");
INSERT INTO hchNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ti'aitame ta'aurie 'aveca neutaniere Pecuru xeiyatü. Hicü Pecuru Ti'aitame niuquieya na'erivacaitüni que mütitahüavixü, Vacana catahivavecacu cuxi hicü, 'ecü haicacüa pepü'acu'imavani quename pecanesimate pe'utaitü. ");
INSERT INTO hchNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Vayeyaca niutasuani cui yuhiverietü. ");
INSERT INTO hchNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Hicü 'uquisi Quesusi memü'üviyacai meninanaimacaitüni. Menicuvayacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Meheitinaca menicu'ivaviyacaitüni yame'utiyuatü, Cari Cacaüyarisüa mieme pepütixaxatame. Quetaneutaxatüa, quepaicü masicuvaya. ");
INSERT INTO hchNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Vaüca masi metenicühüavecaitüni 'axa me'utiyuatü. ");
INSERT INTO hchNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Mericüsü 'ucatarecu teüteri va'uquiyarima meniyucuxeürieni mara'acate memühüritüariecai mümeta 'inüaricü memüte'üquitametetücai. Meni'atüani memayuxeüriecaisie. ");
INSERT INTO hchNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Müpaü metenitahüave, Que mü'ane heiserie mupitüarie xüca pehücütüni 'ecü pecürisitutütü, yaquetatineutahüavi. Müpaü tinivaruta'eiya, Xüca yanetixehahüavenique yuri xepücaneteta'eririeniqueyu. ");
INSERT INTO hchNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Xüca nexecu'ivaviyanique xepücanesiha'eiyaniqueyu, xepücanesixünaqueyu. ");
INSERT INTO hchNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Peru hicüri 'uxa'atünita Yuri Tevi que nemütiteva Cacaüyari mütürücaüye serieta nepacani. ");
INSERT INTO hchNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Yunaitü müpaü metenicühüaveni, 'A, 'ecü xeniu Cacaüyari petinu'aya. Tivarahüave, Xeme müpaü xeputiyua, ne nepühücü. ");
INSERT INTO hchNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Müpaü meniutiyuani, Que cuxi tetevareuyehüva tehecüatamete. Tamesietü tepi'eni tetana mieme. ");
INSERT INTO hchNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Hicü yunaitü mepanucu'ui meneihana müta'ivaviyarienicü Piratusüa. ");
INSERT INTO hchNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","'Ana menisutüani me'ixanetatü müpaü me'utiyuatü, Te'icu'ivaviyatü 'ipaü tecatenimaica, cuamanarica vevietü tiniva'üquitüaca tateüterima, nivanenaca memücateyutuanicü Sesaxi cuviyexunuya tuminieya, müpaü canaineni quename heiserie 'upitüarie Cürisitutütü, ti'aitame yuxatatü. ");
INSERT INTO hchNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Hicü Piratu müpaü tinita'ivaviya, 'Ecü Huriyusixi teüteriyari tiva'aitüvame petihücü. Tita'ei, 'Ecüsü müpaü pecanaineni. ");
INSERT INTO hchNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Hicü Piratu müpaü tinivarutahüave mara'acate memühüritüariecai, teüteri memüyucuxeürie, Que nemütimate, tixaü pücareuyevese 'icü tevi müxanesiecacü. ");
INSERT INTO hchNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Müme masi cuini mieme menicu'imavacaitüni yame'utiyuatü, Canivaxamurieneni teüteri, ti'üquitatü naisarie Cureya cuieyarisie, Carereya cuieyarisie heisutüaca 'uvapaita. ");
INSERT INTO hchNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Mericüsü Piratu 'u'enaca nicu'ivavacaitüni xüca Carereyatanaca hücütücaitüni tevi. ");
INSERT INTO hchNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Tiutamarieca Herurexi mehüritüariecaisie müquiecametücaicü, hesüana neinü'ani, Herurexi Querusaremesie muyeicacaicü 'ana. ");
INSERT INTO hchNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Mericüsü Herurexi Quesusi xeiyatü niyutemaviecaitüni vaüca. Müixa nixeiyamücücaitüni mü'enacaicü hepaüsitana. Müpaü tinicu'erivacaitüni, Quesusi tixaütü mütiyurieniquecaicü 'inüari, 'ixeiyamütü. ");
INSERT INTO hchNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Vaüca niuqui nicu'ivaviyacaitüni, 'iya 'asicare'eiyacacu. ");
INSERT INTO hchNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Peru mara'acate memühüritüariecai müme 'inüaricü memüte'üquitametetücai yunaitü mecaniu'axüani, carima menixanetacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","'Ana Herurexi yucuyaxima vahamatü menitave'eriecaitüni me'inanaimatü. 'Ixuriqui visi mü'anecü me'itiquemaritüaca tavari meneinü'ani Piratusüa. ");
INSERT INTO hchNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Mücü tucarisie Herurexi Piratu meniyutemaviecaitüni. Mepayuca'uniecai müixa, 'anaque 'aixüa mepüteyuxeiyacai. ");
INSERT INTO hchNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Hicü Piratu varucuxeürieca mara'acate memühüritüariecai 'isücate teüteri yunaime, ");
INSERT INTO hchNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","müpaü tinivarutahüave, Nehesüa xepi'atüa 'icü tevi, quename cuamanarica vevietü tiva'üquitüa teüteri xe'utiyuatü. Camü, xehüxie ne'ita'ivaviyaca ne, que nemütimate, tixaü pücareuyevese 'icü tevisie mürahüiyanicü que xemüte'ixaneta. ");
INSERT INTO hchNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herurexita yaxeicüa niutayüni, nexe'utanü'acu hesüana tavari nehesüa caneiyenü'aniri. 'Asipücatiuyuri hesiena mütinaquenicü mümierienicü. ");
INSERT INTO hchNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","'Ayumieme nepütita'aita mücuveiyaxüanicü, 'arique nepixüna. ");
INSERT INTO hchNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Mericüsü 'ixüararipa neuyevecaitüni xeime müvaxünirienicü 'anutahüiyacame. ");
INSERT INTO hchNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","'Ana yunaitü 'axeicüa meniutihiva müpaü me'utiyuatü, Quenemi'a 'icü, quetaneuxüniri Vaxavaxi püta. ");
INSERT INTO hchNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Mücü müyumienecaicü quiecarisie, xeime mumicü, casariyanata nanutahüiyacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Piratu tavari nivarutahüave, Quesusi xünamütü. ");
INSERT INTO hchNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Müme masi meniutihivacaitüni müpaü me'utiyuatü, Curuxisie quenecavi, quenemi'a. ");
INSERT INTO hchNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Hairieca müpaü tinivarutahüave, Titayaricutaxi, quecuta tiuyuri 'icü. Que nemütimate ne, tixaü pücareuyevese mümierienicü. 'Ayumieme cuveiyaxüayu nepixüna. ");
INSERT INTO hchNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Müme masi carima menivaviriecaitüni curuxisie mümierienicü. Teüteri, mara'acate memühüritüariecai hivaricü mene'iva. ");
INSERT INTO hchNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Hicü Piratu müpaü tiniuta'aita yamütiyünicü que memüte'ivautüvecai müme. ");
INSERT INTO hchNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Nixüna que mü'ane memüvaucai, que mü'ane manutahüiyacai casariyanata müyumienecaicü xeime mumicü, Quesusi püta neyetuani yamüranayeyanicü que mütivanaquecai. ");
INSERT INTO hchNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Mericüsü mehevitütü me'imienique, meniviya xeime Simuni titevacame Sirenetanaca. Mücü xaüsie heyeyaca, quiecarisie ni'aximecaitüni. Menititütüani curuxi Quesusi 'utüma menutünicü. ");
INSERT INTO hchNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","'Ana yumüiretü teüteri meniveiyacaitüni, 'ucari meta me'utisuatü me'isuariviyatü. ");
INSERT INTO hchNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Hicü ta'aurie 'aveca müpaü Quesusi tinivarutahüave, Xeme 'ucari Querusaremetari xepüca'utisuanani nehepaüsita. Yuhepaüsita püta yunivema vahepaüsita xequeneutisuanani. ");
INSERT INTO hchNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Tucari canaye'amücü quepaucua müpaü memutiyuaneni, müme memücayüvave türi memüvarexeiyanicü, müme 'aixüa mepü'itüarie, müme memücatinivevave müme memücatesisitüavave, 'aixüa mepü'itüarie müme. ");
INSERT INTO hchNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","'Anari menisutüacuni müpaü mete'icühüavetü hüri, Taheima quenanacaxüri, müpaüta metenivatahüavicuni yemurite, Xequetaneuti'avieta. ");
INSERT INTO hchNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Hicüpaü xüca meteyurieni cüye yuricacu, quesü tiyüni tavayu. ");
INSERT INTO hchNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Hipatüta yuhutatü mepehapanie 'axa teyuruvamete memücui'ivacü hepaüna. ");
INSERT INTO hchNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Mericüsü quepaucua memu'axüa Müqui Mu'uya Manuve müracutevasie, mana curuxisie menitivieni. 'Axa teyuruvameteta menivarutivütüani, serietana xeime 'utatanata xeime. ");
INSERT INTO hchNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Hicü Quesusi müpaü niutayüni, Ne'uquiyari, quetinivareuyehüvirieca. 'Asimepücatemate que memüteyurie. 'Ana cuyaxi meniyuta'iva 'ixuriquiteya meyutahuritüanique. ");
INSERT INTO hchNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Teüteri mana meniti'ucaitüni metanenieretü. 'Isücate menitave'eriecaitüni müpaü me'utiyuatü, Hipame niu püvavicueisitüacai, yücümana queyutavicueisitüani xüca 'acu hücütüni que mü'ane Cacaüyari heiserie mipitüa Cürisitutüme, que mü'ane manayexeiyarie xüca hücütüni 'icü. ");
INSERT INTO hchNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Cuyaxita yaxeicüa meninanaimacaitüni me'axetü masina me'i'itüatü ");
INSERT INTO hchNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","müpaü me'utiyuatü, 'Ecü Huriyusixi tiva'aitüvame xüca pehücütüni, quene'atavicueisitüa. ");
INSERT INTO hchNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Mücü meta, xapa mu'uya heima meneimani, 'ICÜ HURIYUSIXI TIVA'AITÜVAME CANIHÜCÜTÜNI 'anuyüneme Cüriyecusixi Xumatari Hepürayusixi teüteriyari vaniuquicü 'aye'uxame. ");
INSERT INTO hchNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Hicü 'axa teyuruvamete mana memutivücai xevitü 'axa tinicühüavecaitüni, müpaü 'utaitü, Cari 'ecü pecaticürisitu. Mericüte, quene'atavicueisitüa, tameta quetaneutavicueisitüa, ticühüavetü. ");
INSERT INTO hchNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Xevitü püta tapa mutiviecai nitatieni müpaü 'utaitü, Cari 'ecü Cacaüyari pecatimacaxe sepa hepaüna pemü'itüariene yaxeicüa petiutahüavarieca. ");
INSERT INTO hchNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Peru caniheiserietüni tahesie que mütiunaquixü, que müreuyevese xeicüa tepü'itüarietüve yatemüteyuriecaicü. 'Icü masi tixaü 'asipücatiyurieve. ");
INSERT INTO hchNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Müpaü niutayünita, Quesusi 'acu, quenena'erivani quepaucua pemunuani ti'aitame pehücütütü. ");
INSERT INTO hchNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Hicü Quesusi müpaü tinitahüave, Niuqui caniseüyeni que nematicühüave, hicütütü nehesüa pepeyeicani visi müracu'anesie. ");
INSERT INTO hchNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Mericüsü tuca naye'ani. Mana cuiepa nacuyüre naisarie cüa caviecacuque. ");
INSERT INTO hchNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Tau 'uyürecu 'ixuriqui meuviecai tuqui 'amüpata hixüata nisane. ");
INSERT INTO hchNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Hicü Quesusi carima 'utahivaca müpaü niutayüni, Ne'uquiyari, ne'iyari nepümasihüritüa. Müpaü 'utayüca yu'iyari niyetuani. ");
INSERT INTO hchNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Hicü cuya mühüritüariecai 'uniereca que mütiuyü 'aixüa niutayüni Cacaüyari hepaüsita müpaü 'utaitü, Xüari 'icü tevi heiserie pexeiyacai. ");
INSERT INTO hchNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Yunaitü teüteri menenierenique memüyucuxeürie, me'uneniereca que mütiuyü, yu'utüma menecüne yutavisie meyucusunatü hivericacü. ");
INSERT INTO hchNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Peru yunaitü memimaicai mana meniti'ucaitüni yateva. 'Ucari meta hamatüana memeyecü Carereyasie, müme mana meniti'ucaitünita menenieretü. ");
INSERT INTO hchNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Mericüsü tevi 'aniuyeicacaitüni Cuse titevatü. 'Isücate canixevitütücaitüni, 'aixüa pütiuca'iyaricai heiseriemecü yapüticamiecai. Mücü yapüca'anecai que memüteyu'eni que memüte'uyuri. 'Arimateya caniquiecametücaitüni Cureya cuieyarisie, yuri tini'eriecaitüni ta'icuevatü Cacaüyari misutüanicü ti'aitatü. ");
INSERT INTO hchNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Hicü Piratusüa nuaca nitavavirieni Quesusi caxarieya. ");
INSERT INTO hchNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Hecacueca nicu'eima rinu 'ixuriquiyaricü, neicuteucu teuquiyapa 'aitüa müvaye'inieriesie haque tevi hasuacu mücaheutatequievesie. ");
INSERT INTO hchNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Mericüsü püpienixitücai 'ana, 'uxipiya tucari püsutüariximecai. ");
INSERT INTO hchNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Meneiveiya 'ucari Carereyasie memeyecü 'utümana. Menixeiya teuquiya, caxarieya mete'uxei que mütiuteque. ");
INSERT INTO hchNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Yu'utüma mehecüneca 'aixüa meniyurieni visi mu'üa mixaxi nücame 'uhaye. Mericüsü 'uxipiya tucarisie mecani'uxipiecaitüni 'aisica que maine. ");
INSERT INTO hchNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Perusü ximeri cuitü, teuquiyapa meniu'axüani semana mexüacame tucarisie visi mu'üa me'ahapatü memicuxeüri. ");
INSERT INTO hchNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Hicü tete meniutaxeiya heuhüiyacame quitenie meucatei. ");
INSERT INTO hchNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","'Umeheutahaxüaca teuquiyapa, mepüca'itaxei Ti'aitame Quesusi caxarieya. ");
INSERT INTO hchNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","'Asimepücatemaicai que memüteyurieniquecai müpaü mütiuyücü. Hicü 'uquisi yuhutatü va'aurie meniuti'uni merücavime me'anacatütü. ");
INSERT INTO hchNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Memamacacu cuiepa metihüxima'ucacu müpaü metenivarutahüave, Titayari müquite vasata xete'ivautüve mücü mayeyuri. ");
INSERT INTO hchNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","'Uva pücayeca, cananucuquetüarieni püta. Xequena'erivani que mütixe'utahüavixü Carereyasie 'uyeicatü cuxi, ");
INSERT INTO hchNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","que xemüte'utahüavarie Yuri Tevi hepaüsita, que müreuyevecai müyetuiyanicü 'axa teyuruvamete memiviyacü, curuxisie mümierienicü, hairieca tucarisie manucuquenicü que müreuyevecai. ");
INSERT INTO hchNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","'Ana mene'erivani niuquieya. ");
INSERT INTO hchNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Hicü teuquiyapa mevayecüneca menecüne. 'Icü naime metenivarutaxatüani Tamamata Heimana Xeime, hipameta yunaime. ");
INSERT INTO hchNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","'Ucari Mariya Mararatanaca, Vana, Mariya Cacuvu müvarusieyatücai metenitetevacaitüni. Hipatüta vahamatü memu'uvacai 'ucari yunaitü yametenivarutaxatüani nü'arisixi. ");
INSERT INTO hchNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Peru müme yacü me'utiyuaneme meni'eriecaitüni metecuxatacacu, yuri mepücatevaruta'eriri. ");
INSERT INTO hchNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Perusü Pecuru caneyani teuquiyapa 'unausarümetü. 'Anahuca nixeiya 'ixuriqui mana 'acateme 'uyemaveme. Yuquie neyani vaüca 'iyarixietü que mütiunierixü hepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Mericüsü mücü tucarisie yuhutatü müme huyeta menecüne, quiecarisie meneta'axüaniquecaitüni 'Emau müracutevasie. Querusareme nehuracaitüni, yanetevacaitüni tamamata heimana huta quirumetüruyari xeicüa. ");
INSERT INTO hchNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Metenicuxatacaitüni naitü que mütiuyü hepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Mericüsü metecuxatacacu niuqui mexüatüacacu Quesusitütü nivaranucu'axe me'uhucacu. Vahamatü niumiecaitüni. ");
INSERT INTO hchNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Mepücapitüariecai memeitimanicü. ");
INSERT INTO hchNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Müpaü tinivarutahüave, Que titita 'icü niuqui xemüxüatüa xe'uhutü. Titayari xeteyuhiverie. Müme mana meniuti'uni me'ayexüxünitü yühüxie. ");
INSERT INTO hchNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Xevitü müme Cüreupaxi mütitevacai müpaü tinitahüave, Cari 'ecü 'asipepücatimate Querusareme que müreyü tacai 'atu. 'Asita cücamete müpaü mepütemate. ");
INSERT INTO hchNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","'Iya müpaü tinivacühüaveni, Que reyücuta. Müme müpaü mete'itahüavixü, Quesusi Nasaretitanaca, que müranayetüa pecatimate. Mücü 'uqui Cacaüyarisie mieme catinixaxatametücaitüni. Que mütiyurienecai que müticuxatacai, canitürücaüyecaitüni Cacaüyari hüxie yunaime teüteri vahüxie. ");
INSERT INTO hchNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Tamara'acate memühüritüarie ta'isücateta meniyetuani hesiena mürahüiyanicü mümierienicü, 'arique curuxisie mepeimie. ");
INSERT INTO hchNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Tamesietü tecanita'icuevacaitüni yuri tete'erietü 'iya mühücütücaicü que mü'ane mütasitixünaquecai 'Ixaherisixi teüteriyari. Mücü meta, haica tucari caniyuriecari hicü, müya reyücu. ");
INSERT INTO hchNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Süricüte, 'ucari tasata miemete mepütasihüxiyatüa hicü. Ximeri vaniu menecucünixüani teuquiyapa, ");
INSERT INTO hchNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","peru caxarieya mepücahexei. Meniu'axüani müpaü me'utiyuatü quename niuqui tuayamete mevarexei meteheinüme meyu'erietü. Müme vaniu quename Quesusi 'ayeyuri metenivaretahüave. ");
INSERT INTO hchNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","'Ana hipatüta tahamatü memu'uva teuquiyapa menecüne. 'Ucari que memaitücatei, müpaü 'aneme mepetaxei, peru Quesusi mepücahexei. ");
INSERT INTO hchNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Hicü Quesusi müpaü tinivarutahüave, Cari 'asixepücatemate, yu'iyarisie xepu'itutupe, 'acuxi yuri xepücateta'erivave texaxatamete que memütecuxatacaisie naime. ");
INSERT INTO hchNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Careuyevecai Cürisitu müpaü müticuinecü, 'arique mücaque visi 'anetü carayaniquecai. ");
INSERT INTO hchNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","'Ana Muisexi xapaya xatatü meri yunaime texaxatamete vaxapa xatatü, nisutüani tivahecüasitüiyatü que müre'ucai hepaüsitana naime 'utüaricasie. ");
INSERT INTO hchNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Mericüsü quiecari haque memeta'axüaniquecai meneta'axüani. 'Iya masi teva niumiecaitüni. ");
INSERT INTO hchNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Müme cuini mieme meni'iniecaitüni müpaü me'utiyuatü, Tahamatü quene'ahayeva, 'esivatücacu putaicai pacayunirüme. Hicü muva neutahani vahamatü müyuhayevacü. ");
INSERT INTO hchNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Hicü vahamatü 'ayerüca mexa 'aurie, 'enu'üca pa, 'aixüa niutayüni Cacaüyari hepaüsita pa hepaüsita. 'Ititaraca nivarumini. ");
INSERT INTO hchNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","'Ana vahüxie canenarietü nayani, meneitimani. 'Iya masi camasiücütü nayuyeitüani tavari memüca'ixeiyacü. ");
INSERT INTO hchNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Hicü müpaü meteniyücühüavecaitüni, 'E'e, 'ayumieme ta'iyarisie cuini mieme tepütayetuacai mexi taticuxaxatüvacai huyeta te'uhucacu, mexi tasihecüasitüiyacai 'utüarica que maine. ");
INSERT INTO hchNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Hicü me'anucu'uca cuitü, Querusareme menecüne yu'utüma. Tamamata Heimana Xeime hipameta menivaretaxeiya meyuxeüriecame. ");
INSERT INTO hchNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Müme müpaü meniutiyuanecaitüni, Caniyuritüni, Ti'aitame panucuque. Masiücütü nayuyeitüani Simuni 'ixeiyacacu. ");
INSERT INTO hchNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Mümeta metenivarutaxatüani huyeta que müreyü, que memüteheitima pa 'utitaracu. ");
INSERT INTO hchNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Mericüsü metecuxatacacu cuxi, 'iya vahixüata niutaqueni. Müpaü niutayüni, 'Aixüa 'acu. ");
INSERT INTO hchNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Müme meniutimamani, müqui mexeiyame meyu'erietü. ");
INSERT INTO hchNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Mücüsü müpaü tinivarutahüave, Titayari xeteyuxamurie. Titayari xete'isutüa niuqui xexüatüatü yu'iyarisie. ");
INSERT INTO hchNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Xequeneu'ixüari nemamate ne'ücate, ne necanihücütüni. Xequeneneumayüa xequeneneuxeiya. 'Iyari 'ume pücahexeiya vai pücahexeiya nehepaü. ");
INSERT INTO hchNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Müpaü 'utayüca yumamate yü'ücate nivaruxeisitüani. ");
INSERT INTO hchNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Meyutemamavietü mehüxiyatü, cayuri mepü'eriecai cuxi. Hicü müpaü tinivarutahüave, Tixaü xecatehexeiya 'uva ticuaivame. ");
INSERT INTO hchNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Quesü vaiyari menimini variquime texicamame. ");
INSERT INTO hchNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","'Enu'üca nitacuani vahüxie. ");
INSERT INTO hchNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Mericüsü müpaü tinivarutahüave, 'Icü niuqui necanixecuxaxatüvacaitüni xehamatü ne'uyeicatü cuxi, müpaü ne'utaitü quename heuyevecai maye'atüarienicü naitü nehepaüsita que müre'uxa Muisexi 'inüarieya niuquiyarisie texaxatamete vaxapasie cuicari xapayarisie ne'utaitü. ");
INSERT INTO hchNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","'Ana va'iyari nivatiyepieni memeitimanicü tita 'utüarica xapayari mütixatacai. ");
INSERT INTO hchNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Müpaüta tinivarutahüave, Müpaü püre'uxa, que müreuyevecai Cürisitu nehücütütü müya netinicuinequecaitüni, hairieca tucarisie nenanucuqueniquecaitüni müquite vasata. ");
INSERT INTO hchNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Mücü meta, yunaitü nuivarite müpaü mecatenitahüavariecuni, xüca xetehayeva que xemüteyuriecai, xenesihahüavetü que mü'ane nemühücü, xepüteheuyehüviyarieni 'axa xemüte'uyuricü. Querusareme meri, 'ariqueta xaüsie yacatinicuxaxasivamücü. ");
INSERT INTO hchNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Xeme xecanihümetüni xemunenierixü xemihecüata 'icü que mütiuyü hepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ne meta nepütixehanü'airieni tita ne'uquiyari mürainecai mütixeminiquecaicü. Xeme quiecarisie xequeneyuhayevani tucari 'aye'ayuque quepaucua türücariya xemüpitüarieni taheima mieme, 'anaque xepüvayecüne. ");
INSERT INTO hchNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Hicü nivarayevitüni Vetaniya 'aurie. Yumama teicü heseratü niutaniuni 'aixüa memü'itüarienicü. ");
INSERT INTO hchNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Mexi müpaü 'utaniucacai vahesüa nayeyani, muyuavisie nanutivitüquieni. ");
INSERT INTO hchNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Müme nenevieri me'ipitüaca Querusareme menecüne cuini mieme meyutemamavietü. ");
INSERT INTO hchNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Tucaricü tuqui curaruyarita meniu'uvacaitüni 'aixüa me'utiyuatü Cacaüyari hepaüsita. Müpaü xeicüa cani'aneni.");
INSERT INTO hchNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Sutüapai niuqui caniyüanecaitüni. Niuqui niteütacaitüni Cacaüyari. Canicacaüyaritücaitüni niuquitütü. ");
INSERT INTO hchNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Mücütütü niuqui sutüapai Cacaüyari niteütacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Naitü tiniuneni mücü 'inetüacu. Xüca mücü ca'inetüanique, pücaneniqueyu ni xevitü. ");
INSERT INTO hchNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Mücüsüa tucari canixuavecaitüni. Tucari teüteri vahecüariviyame canihücütücaitüni. ");
INSERT INTO hchNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Hecüariya yüvipa nihecüariyani, yüriya pücahe'ivave. ");
INSERT INTO hchNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Mericüsü tevi Cacaüyari meiyenü'a 'aniucateitüni Vani titevatü. ");
INSERT INTO hchNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Mücü titahecüataque caninuani, hecüariya hepaüsita mütitahecüatacü, yunaitü yuri memüteta'erienicü tiutahecüatacacu 'iya. ");
INSERT INTO hchNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","'Iya hecüariya pücahücütücai. Titahecüataque hecüariya hepaüsita xeicüa caninuani. ");
INSERT INTO hchNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Tita yuricü mütihecüariya, tita mütivahecüatüa yunaime teüteri, mücü cuiepa caninuaximecaitüni. ");
INSERT INTO hchNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Cuiepa caniuyeicacaitüni, cuie niuneni 'iya 'inetüacu, masi cuiepa memütama mepücaheitima. ");
INSERT INTO hchNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Yuquie caninuani, teüterimama mepücaheitanaqui'eri. ");
INSERT INTO hchNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Queyupaümetü memitanaqui'eri, müme yuri memüte'erie que mü'ane mühücüsie, müme heiserie nivarupitüani Cacaüyari nivemama memacünecü. ");
INSERT INTO hchNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Teüteri que memüte'ununuivasie mepücayecü, va'uquiyarima meyuhive'eriecacu teüteri que memüteyurie, mana mepücayecü, 'uqui türi vavevimücücacu, mana mepücayecü. Cacaüyarisie püta mepüyecü. ");
INSERT INTO hchNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Mericüsü mücü niuquitütü tevi canayani, tasata 'ucaitü ratüa. Tame tecanixeiya visi que mü'anecai, 'uquiyarieya visi que mütipitüa yunive muyuxevi. Canaye'ani 'aixüa tiuca'iyaritü yuri ticuxatatü. ");
INSERT INTO hchNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Vani tinihecüatacaitüni hepaüsitana. Canahivacaitüni müpaü 'utaitü, 'Icü canihücütücaitüni nemixatacai yane'utaitü, 'Iya ne'utüa 'umamie nesi'anuhaitüiyatü nayani meripai mümiemecü, ne meripai necamiemetücacu. ");
INSERT INTO hchNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","'Iya que müraye'ave, yacatatinipitüaca hepaüna te'anenetü temacünecü tanaitü. 'Aixüa tiuca'iyaritü pütasiyuriene, pütasimüiriyarüme. ");
INSERT INTO hchNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","'Inüari niuquiyari tecaniupitüarieni Muisexi tasi'upitüacu. Tepupitüarie mücü 'aixüa mütiuca'iyarinicü tahepaüsita, tita yuri müraine temütehexeiyanicü, Quesusi Cürisitu yatatiupitüacu. ");
INSERT INTO hchNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Xevitü hasuacua püca'ixeiyave Cacaüyari. Cacaüyari muyuxevi, que mü'ane yu'uquiyarisie mütiviya, mücü canihecüatani yu'uquiyari. ");
INSERT INTO hchNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Mericüsü müpaü tiniutahecüata Vani quepaucua Huriyusixi hesüana memüvareyenü'a mara'acate Revitasixi vahamame Querusareme memeyecü memita'ivaviyacü, 'Ecüri que pepüpaicü. ");
INSERT INTO hchNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Mücü puyutahecüataxü, pücayucu'imavacai. Masi puyutahecüataxü müpaü 'utaitü, Neri Cürisitu nepücahücü. ");
INSERT INTO hchNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Müme mete'ita'ivaviya, Quesü 'ane. 'Eriyaxi pecatihücü. Mücü tiutayü, Ne pücatixaü. 'Ecü pecatihücü mücü tixaxatame, mete'icühüave. Mücü tivaruta'ei, Havaicü. ");
INSERT INTO hchNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Müme 'ayumieme mete'itahüaveri, Que pepüpaicüte, xasuni temütevaretahüavecü müme memütasiheyenü'a. Que pe'utaine 'ahepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Mücü tiutayü, Nesü necanihücütüni que mü'ane mücuxaxasivacai haque müpaü mainecai, Xevitü mahiva macumavesie, Xeuraüyeme xequeneutavevi Ti'aitame huyeya 'utaitü, Quisariyaxi tixaxatame mainecaipaü. ");
INSERT INTO hchNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Müme memeyenü'ari Pareseusixi vahesüa mecanimiemetetücaitüni. ");
INSERT INTO hchNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Hicü menita'ivaviya müpaü mete'icühüavetü, Mericüte, titayari peti'üyane xüca pecacürisitutüni xüca 'Eriyaxi pecahücütüni xüca mücü tixaxatame pecahücütüni. ");
INSERT INTO hchNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Vani nivaruta'eiya ya'utaitü, Nericü necatini'üyaneni hacü. Xesata 'acaniuveni xevitü, xemüca'imate xeme. ");
INSERT INTO hchNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","'Iya ne'utüma 'ucanamieniri. Ne 'aixüa nepücatiuca'iyari nehesie mütinaquenicü ni nemiparevienicü nemixünirienicü cacaiya cuitaxiyari. ");
INSERT INTO hchNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Müpaü tiniuyüni Vetavarasie Curutani hatuxame 'anutaüye. Mana catini'üyanecaitüni Vani. ");
INSERT INTO hchNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Mericüsü 'uxa'arieca Vani canixeiya Quesusi 'a'amiecame. Müpaü niutayüni, Camü muxa nunusi Cacaüyarisüa mieme. Cuiepa memütama tita 'axa memüteyurie canivacunavairivani mücü. ");
INSERT INTO hchNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Mücü canihücütüni que mü'ane hepaüsita nemainecai, Ne'utüma 'ucanamieni 'uqui nesi'anuhaitüiyatü matüa, meripai mümiemecü, ne meripai necamiemetücacu. ");
INSERT INTO hchNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nesüari nepücaheitimaitüyeicacai, peru mümasiücünicü 'Ixaherisixi vahüxie, 'ayumieme necaninuani hacü netiuca'üyatü. ");
INSERT INTO hchNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Hicü Vani tiniutahecüata müpaü 'utaitü, Ne necanixeiya 'Iyari taheima 'acamieme cucuru 'amacamiepaü. Hesiena niyuhayeva. ");
INSERT INTO hchNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ne nepüca'imaicai cuxi, masi que mü'ane münesiheyenü'a nemütiuca'üyanicü hacü, mücütütü müpaü pünetiutahüavixü, Que mü'ane heima pemixeiya 'Iyari 'acamieme hesiena yuhayevame, 'iya canihücütüni que mü'ane mütiuca'üya 'Iyari Mütiyupata rapitüatü. ");
INSERT INTO hchNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Nesü necaniuniere, necatiniutahecüata 'icü Cacaüyari Nu'aya mühücü. ");
INSERT INTO hchNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Hicü 'uxa'arieca tavari mana niutivecaitüni Vani, teyü'üquitüvametemama yuhutatü mana meteti'ucaita. ");
INSERT INTO hchNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","'Ixeiyaca Quesusi 'uyeicacacu, müpaü niutayüni, Camü muxa nunusi Cacaüyarisüa mieme. ");
INSERT INTO hchNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Yuhutatü teyü'üquitüvametemama mecani'enieni müpaü haineme, mecaneiveiya Quesusi. ");
INSERT INTO hchNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Hicü Quesusi ta'aurie 'aveca, varuxeiyaca me'iveiyame, müpaü tinivarutahüave, Tita xetecuvautüve. Müme metenitahüave, Xavi, haque pepeca. Xavi taniuquicü Ti'üquitame paine. ");
INSERT INTO hchNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Mücü tivaruta'ei, Xequenacüni xepüneniere. Hicü mana meniu'axüani, meniuneniere haque mecatei. 'Iya tucarisie me'iteütatü meniyuhayeva, memenuveiyacü tau ya'atevacacu. ");
INSERT INTO hchNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Mericüsü yuhutatü memu'enaxü Vani que mainecai, memeiveiya Quesusi, xevitü 'Atürexi catinitevacaitüni Simuni Pecuru mü'ivayatücai. ");
INSERT INTO hchNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","'Iya yu'iva Simuni netaxeiya meri. Müpaü tinitahüave, Tecaneitaxeiya Mesiya, taniuquicü Cürisitu heiserie mupitüarie maine. ");
INSERT INTO hchNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Quesusisüa caneivitüni. Quesusi 'ixeiyaca müpaü niutayüni, 'Ecü Simuni pecanihücütüni, Vani pemünu'aya. Sepaxi pepütitaterüvarieni, taniuquicü Pecuru maine, Tete maine. ");
INSERT INTO hchNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Hicü Quesusi 'uxa'arieca Carereyapai niyeimücücaitüni. Canitaxeiya Piripe, müpaü tinitahüave, Quenenanuveiya. ");
INSERT INTO hchNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","'Iya Piripe Vesaira caniquiecametücaitüni 'Atürexi Pecuru vaquiecari. ");
INSERT INTO hchNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Hicü Piripe neitaxeiya Natanaheri. Müpaü tinitahüave, Que mü'ane raxatatü Muisexi mütiuta'utüa 'inüari niuquiyarisie, texaxatameteta mete'uti'utüa metexatatü, mücü tenetaxeiya. Quesusi canihücütüni Cuse nu'aya Nasaretitanaca. ");
INSERT INTO hchNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanaheri müpaü tinitahüave, Nasaretisie que tiyüve 'aixüa müti'ane mürayeneica. Piripesü müpaü titahüave, Quenenierimie. ");
INSERT INTO hchNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Hicü Quesusi Natanaheri niuxeiya 'a'amiecame. Müpaü niutayüni hepaüsitana, Camü yuricü 'Ixaheri teviyari canihücütüni 'icü, püca'irümari. ");
INSERT INTO hchNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanaheri müpaü tinitahüave, Haque pepünesihetima 'ecü. Quesusi müpaü tinitahüave, Piripe camatitahüavivecacu cuxi, quepaucua pinitüa pemucatei, nepümasi'uxei. ");
INSERT INTO hchNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanaheri müpaü tita'ei, Ti'üquitame, 'ecü Cacaüyari pecaninu'ayatüni, 'Ixaherisixi tati'aitüvame pecanihücütüni. ");
INSERT INTO hchNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Quesusi müpaü tita'ei, Nemutainecü pinitüa pe'ucaime nepümasi'uxei, yuri petiuta'eri. 'Ipaü 'aneneme masi vaücava pecanixeiyamücü. ");
INSERT INTO hchNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Müpaü tinitahüaveta, Niuqui caniseüyeni que nemütixecühüave, xecanixeiyacuni muyuavisie reuyepiyacame, Cacaüyarisüa miemete niuqui tuayamete xetevaxeiya me'anuticücame me'acaneicame Yuri Tevisüa. ");
INSERT INTO hchNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Mericüsü hairieca tucari 'aye'acu meneitineüquitüani xeime. 'Ixüarari mepeveviecai Canasie Carereya cuieyarisie. Quesusi varusieya mana niuyeicacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Quesusi niuta'inierieni, teyü'üquitüvameteta mete'uta'inieri 'ixüararipa. ");
INSERT INTO hchNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Hicü vinu 'ayexücu Quesusi varusieya müpaü tinitahüave, Vinu mepücahexeiya. ");
INSERT INTO hchNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Quesusi müpaü tinitahüave, 'Uca titasü tetehexeiya 'ecü ne 'axeicüa. Netucari cuxi püca'aye'ave. ");
INSERT INTO hchNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Hicü varusieya müpaü tinivarutahüave teparevivamete, Sepa que mütixehahüave, yaxequetenecahuni. ");
INSERT INTO hchNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Mericüsü mana meniyetecaitüni tete ye'üyari 'auxüvitü Huriyusixi que memüte'i'itiva yupini. Xexuimesie müpaü paümetü tinacananaquecaitüni nauca teviyari ya xei sienituyari ritüruyari yacütüniquetü. ");
INSERT INTO hchNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Hicü Quesusi müpaü tinivarutahüave, Ha xequeneutihüniya ye'ürütesie. Cüsitanapai mecanitihüniya. ");
INSERT INTO hchNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Müpaü tinivarutahüave, Xequenivatihapaniri, 'ixüarari mühüritüariesüa xequenanuhapani. Müme mecaneihapanirieni. ");
INSERT INTO hchNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Mühüritüarie quepaucua menuti'inüataxü 'iya ha vinu matüa, 'asicatimaitü haque memiemetücai, teparevivamete memüvatihapa yametemaicacusüari, 'iya 'ixüarari mühüritüariecai nitahüave neneüqueme. ");
INSERT INTO hchNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Müpaü tinitahüave, Cari yunaitü teüteri vinu 'aixüa ma'ane mecaniva'itüaca meri. Quepaucua memütitarüveni 'axa mü'ane mepüva'itüa. 'Ecüsü püta pecaniticuerieni vinu 'aixüa ma'ane hicüque. ");
INSERT INTO hchNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","'Ipaü tiniuyurieni Quesusi Canasie Carereya cuieyarisie 'isutüatü 'inüari que mütiyurienecai. Masiücütü nayuyeitüani que mütimarivecai. Teyü'üquitüvamete yuri mecateniuta'erieni hesiena. ");
INSERT INTO hchNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Mericüsü 'arique Caperünaume neuyeyune mücüri, varusieyari, 'ivamamari, teyü'üquitüvametemamari. Mana müixa mepüca'uyuhayevaxü. ");
INSERT INTO hchNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Mericüsü Huriyusixi va'ixüarari Pasicua mütiteva canahuracaitüni. Quesusi Querusareme neutiyune. ");
INSERT INTO hchNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Mana tuqui curaruyarita nivaretaxeiya memüvareutatuayacai puixisixi muxasi cucuruxi. Tumini patamete tivaretaxei mana me'ayeteme. ");
INSERT INTO hchNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Caunari tiyuvayame 'utavevieca yunaime nivaranuyeveiya tuqui curaruyarita, muxasi puixisixi vahamame. Tumini patamete vatumini nanacaxürieni, vamexate natixürieni. ");
INSERT INTO hchNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Memüvareutatuayacai cucuruxi müpaü tinivarutahüave, 'Icü xequenanuye'üi tacuapai. Ne'uquiyari quiya xepüca'ayeitüvani tetuayamete vaquie. ");
INSERT INTO hchNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Teyü'üquitüvamete mene'erivani niuqui müpaü müre'uxa, 'Aqui yemecü nemücueriecü neputa'unari. ");
INSERT INTO hchNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Hicü Huriyusixi müpaü metenita'eiya, Tita petatixeisitüani 'inüari müya pemütiyurienecü. ");
INSERT INTO hchNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Quesusi müpaü tivaruta'ei, 'Icü tuqui xequeneuca'una, ne hairieca tucari 'anucayayu necanenucuquetüamücü hutarieca. ");
INSERT INTO hchNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","'Ayumieme Huriyusixi müpaü meniutiyuani, 'Icü tuqui veviyari huta teviyari heimana 'ataxevime viyari caniuyurieni. Cari 'ecü haica tucari perenucuquetüani. ");
INSERT INTO hchNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Masi mücü yuvaiyari canixatacaitüni tuquitüme. ");
INSERT INTO hchNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Quepaucuari müquite vasata manucuquetüarie, teyü'üquitüvametemama mene'erivacaitüni müpaü mutayücü. 'Ana yuri metenita'eririeni 'utüarica, yuri mete'ita'eririta niuqui Quesusi mutayücü. ");
INSERT INTO hchNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Mericüsü Querusareme 'uyeicacacu Pasicua 'ixüararipa, yumüiretü yuri meteniuta'eriecaxüani que mü'ane mühücütücaisie me'ixeiyaca 'inüariteya mücü que mütiyurienecai. ");
INSERT INTO hchNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Masi Quesusitütü pücayuyetuacai xeimesie, 'iya müvamaicaicü yunaime, ");
INSERT INTO hchNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","tixaü mücareuyehüacaicü xevitü mütitahecüatacü tevi hepaüsita. 'Iyasietü yücümana tinimaicaitüni tita tevi 'iyarieyasie mütiyeca. ");
INSERT INTO hchNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Mericüsü tevi 'eniuyeicacaitüni müpareseutücai Nicuremu titevatü, Huriyusixi teva'aitüvamete müxevitütücai. ");
INSERT INTO hchNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","'Iya Quesusisüa caninuani yüvicüta. Müpaü tinitahüave, Ti'üquitame, tame müpaü tecatenimaica, 'ecü Cacaüyarisüa pemiemetütü pemunuacü peti'üquitametütü. Xevitü pücayüveniqueyu 'icü 'inüari mütiyurieneni pemütiyurienepaü, me xüca Cacaüyari hamatüana ca'uyeicanique. ");
INSERT INTO hchNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Quesusi nita'eiya, Caniseüyeni que nematicühüave, xüca hutarieca ca'utinuiva tevi, pücayüve mixeiya tita Cacaüyari müra'aita. ");
INSERT INTO hchNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nicuremu rehüave, Tevi quepaü tiyüve mutinuiva 'uquirasitütü. Tiyüve hutarieca yuvarusisie meutahani mutinuiva. ");
INSERT INTO hchNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Quesusi tita'ei, Niuqui caniseüyeni que nematicühüave, hasie 'iyarisie xüca ca'utinuiva, pücayüve meutahani Cacaüyari müra'aitasie. ");
INSERT INTO hchNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Tita tevisie mütiyenuiva canitevitüni. Tita 'iyarisie mütiyenuiva cani'iyaritüni. ");
INSERT INTO hchNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Pemücahüxiyaca nemütixecühüavecü quename heuyevese xeme hutarieca xemütinunuiva. ");
INSERT INTO hchNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Que mütinaque caniu'ecani. Pecani'enieca yuariyaya, perusü 'asipepücatimate que müraneica que müreumie. Müpaü mecani'aneneni yunaitü 'iyarisie memüyenunuiva. ");
INSERT INTO hchNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nicuremu müpaü tita'ei, Quesü quepaütütü 'icü. ");
INSERT INTO hchNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Quesusi müpaü tinita'eiya, 'Ecü 'Ixaherisixi pecatiniva'üquitüvametüni. Cari 'icü pecatimate. ");
INSERT INTO hchNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Niuqui caniseüyeni que nematicühüave, tecatenicuxatani tita temütemate hepaüsita, tetenihecüatani tita temüte'uxei hepaüsita. Xemesü xepüca'itanaqui'eri tita temütetahecüataquecai. ");
INSERT INTO hchNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Xüca yuri xecate'erieca tita cuiepa mütimieme nexecuxaxatüvacacu, quepaütütü yuri xeteta'erieniqueyu xüca nexecuxaxatüvanique tita taheima mütimieme. ");
INSERT INTO hchNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Xevitü taheima püca'anutiyeive, 'iya taheima macane Yuri Tevitütü xeicüa pemari. ");
INSERT INTO hchNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Muisexi macumavesie 'uyeicatü cu muyetepaü, müpaürita caneuyevecani Yuri Tevi muyetequieni ");
INSERT INTO hchNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","yunaitü yuri memüte'erie hesiena tucari mücaxüve memexeiyanicü. ");
INSERT INTO hchNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Cacaüyari 'ipaü tinivanaqui'erieca cuiepa memütama. Yunive muyuxevi caniyetuani memücatatümaiyarienicü yunaitü yuri memüte'erie hesiena, tucari mücaxüve memexeiyanicü püta. ");
INSERT INTO hchNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Cacaüyari cuiepa que müreiyenü'a yunive, müpaü pücatiuyuri müvaranutaxürienicü cuiepa memütama. Masi cuiepa memütama memütavicueisitüarienicü cümana, 'ayumieme püta neiyenü'ani. ");
INSERT INTO hchNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Que mü'ane yuri müti'erie hesiena, püca'anutahüiyani. Que mü'ane yuri mücati'erie 'ari nanutahüiyaniri, yuri mücatiuta'erievecü que mü'ane Cacaüyari Nu'aya muyuxevi mühücüsie. ");
INSERT INTO hchNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","'Ipaü tinivaranutaxürüvani 'isücame. Hecüariya cuiepa caninuaniri. Teüteri yüriya mecaninaqui'eriecaitüni, hecüariya mecanaqui'erietü, 'axa memüteyuriecaicü. ");
INSERT INTO hchNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Yunaitü 'axa memüteyurie mecani'uxieca hecüariya, hecüaripa mepücacünicu capa me'utatierivanicü que memüteyurie. ");
INSERT INTO hchNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Que mü'ane yamütiyuriene tita yuri müraine, hecüaripa püyeimücü mümasiücünicü que mütiyuriene Cacaüyarisie tiviyatü. ");
INSERT INTO hchNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Mericüsü 'arique Quesusi teyü'üquitüvametemamata menecüne Cureya cuieyarisie. Mana vahamatü 'etineutere ti'üyanetü. ");
INSERT INTO hchNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Vanita tini'üyanecaitüni 'Enunisie Sarimi 'aurie, ha mana vaüca muhanecaicü. Meniu'axecaitüni meniuca'üyarüvacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Vani casariyanata püca'anutahüiyavecai cuxi. ");
INSERT INTO hchNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","'Ayumieme Vanisüa miemete teyü'üquitüvamete hipatü Huriyusixi vahamatü niuqui menixüatüacaitüni 'itiya hepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Vanisüa me'u'axüaca müpaü metenitahüave, Ti'üquitame, 'iya 'ahamatü meyeicacai hatuxame Curutani müracuteva 'anutaüye, que mü'ane hepaüsita pemütihecüatacai, titayari re'üyane hicü. Yunaitü hesüana meni'axeni. ");
INSERT INTO hchNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Vani müpaü tinivarutahüave, Tevi pücayüve tixaütü mütiutanaqui'erieni, me xüca taheima mieme yatipitüarieca püyüve. ");
INSERT INTO hchNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Xemetütü xecatenihecüatani nehepaüsita müpaü que nemainecai, Ne Cürisitu nepücahücü, masi hüxiena nemetanü'arie. ");
INSERT INTO hchNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Que mü'ane 'uca viquivame mexeiya, 'uqui neneüqueme canihücütüni. Neneüqueme teütameya mana mutive mi'enie, mücü caniyutemavieca mi'eniecü neneüqueme. 'Ayumieme 'icü netemavierica naye'aniri. ");
INSERT INTO hchNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Neuyeveca 'iya ve'eme mücuxaxasivarümeni marivatü mayeiximeni, ne püta nemütaparirümeni reuyevese. ");
INSERT INTO hchNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Que mü'ane taheima macane nai catinita'aitüani. Que mü'ane cuiepa mutine cuiepa canimiemetüni, catinicuxatani cuiepa mieme. Que mü'ane muyuavisie macane nai catinita'aitüani. ");
INSERT INTO hchNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Tita mütiuxei, tita mütiu'eni, mücü hepaüsita tinihecüatani. Xevitü püca'itanaqui'eri tita mütiutahecüataxü. ");
INSERT INTO hchNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Que mü'ane mitanaqui'eri tita mütiutahecüataxü, mücüri niyu'inüaritüani müpaü 'utaitü quename Cacaüyari yuri haine. ");
INSERT INTO hchNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Que mü'ane Cacaüyari meiyenü'a, mücü Cacaüyari niuquieyacü catinicuxatani. Cacaüyari nipitüani yu'iyari, que müreupaüme cati'inüatatü. ");
INSERT INTO hchNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","'Uquiyarieya yunive ninaqui'erieca. Nai tiniyetuirieni mamayasie. ");
INSERT INTO hchNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Que mü'ane nu'ayasie yuri müti'eri tucari mücaxüve canexeiyani. Que mü'ane yamücaticamie nu'aya que maine, pücaheitimani tucari, masi Cacaüyari 'ihecacacu püyuhayeva. ");
INSERT INTO hchNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Mericüsü Ti'aitame tiniutamarieni Pareseusixi memu'enanacü quename Quesusi yumüireme teyü'üquitüvamete varayeitüvacai va'üyanecai, Vani hipame xeicüa va'üyanecacu. ");
INSERT INTO hchNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Quesusi yücümana pücavaruca'üyacai, teyü'üquitüvametemama püta mepüvaruca'üyacai. ");
INSERT INTO hchNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Müpaü tiutamarieca Cureya neyeyani, hutarieca Carereya ninuani. ");
INSERT INTO hchNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Neuyevecaitüni Samariya cuieyarisie meutayunecü. ");
INSERT INTO hchNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Hicü quiecarisie ninuani Samariya cuieyarisie Sicari mütiuyetevasie. Mana canehurani cuie Cacuvu yunive mumi Cuse. ");
INSERT INTO hchNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Pusu Cacuvu müvati'inixü mana nitiniereni. Mericüsü Quesusi 'uxetü yeiyacü ya'anetü mana nacateitüni pusu tesie tuca. ");
INSERT INTO hchNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Mericüsü 'uca mana caninuani Samariya quiecame cuhanünetü. Quesusi müpaü tinitahüave, Queneneuharitüa. ");
INSERT INTO hchNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Teyü'üquitüvametemama quiecari hixüapa mene'uvacaitüni 'icuai meheunanaiyuca. ");
INSERT INTO hchNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Hicü 'uca Samariyatanaca müpaü tinitahüave, Quepaütütü 'ecü pemühuriyu ha penetivaviri ne nemüsamariyatanaca nemü'uca. Huriyusixi tixaü xepücatehexeiya Samariyatari tahamatü. ");
INSERT INTO hchNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Quesusi tita'ei, Xüca pe'imaicaque tita Cacaüyari matimicua, xüca pe'imaicaque quepai ha mümasivaviri, Queneneuharitüa ne'utaitü, 'ecüsü püta pepünesitavavirieniqueyu, nepümasiharitüaniqueyu ha muhanesie mieme. ");
INSERT INTO hchNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Mücü rehüave, Neuxei, hanüveme pepücahexeiya. Pusu peucateva. Haque pepeixeiya mücü ha muhanesie mümieme. ");
INSERT INTO hchNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ta'uquiyari Cacuvu nive'emetücaitüni 'icü pusu mütasi'umi. 'Ena nitiharevecaitüni 'iya, nivemamata tevamamata. 'Ecü masi que petive'eme que mücü. ");
INSERT INTO hchNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Quesusi nita'eiya, Yunaitü 'icü ha memütihareve tavari mepeuharicuni. ");
INSERT INTO hchNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Que mü'ane manuhareni ne ne'iharitüayu tavari hasuacua pücaheuharimücüni. Masisü mücü ha nemiharitüani, mücü haixa canayeimücü hesiena 'atineicatü tucari mücaxüve 'ipitüatü. ");
INSERT INTO hchNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","'Uca müpaü tita'eiyaxü, Neuxei, 'icü ha queneneuharitüa tavari nemücaheuharimücünicü, 'uvapai nemücahanünenicü. ");
INSERT INTO hchNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Tita'ei, Mericüte, 'acüna quene'iniemie, 'uvapai xequenacüne. ");
INSERT INTO hchNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","'Uca müpaü tita'ei, Nepücarecacüna. Quesusi müpaü tinitahüave, 'Erite, 'aixüa pecanaineni nepücarecacüna pehaitü. ");
INSERT INTO hchNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Yu'auxüme pepüvarexeiyacai 'acünama. Mücü meta, hicü pemeixeiya, mücü püca'acüna. 'Ayumieme xasunicü peputaine. ");
INSERT INTO hchNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","'Uca müpaü tita'ei, Camü, nemanetimani 'ecü, tixaxatame pecanihücütüni. ");
INSERT INTO hchNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Tame ta'uquiyarima 'icü yemurisie mecaniyutinenevivacaitüni. Xeme xeniutiyuaneni quename heuyevese Querusareme memüyutinenevivani. ");
INSERT INTO hchNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Quesusi tita'ei, Neuxei 'uca, yuri quenetine'eririeca. Tucari canaye'amücü quepaucua nenevieri xemüca'ipitüaca yu'uquiyari 'icü yemurisie ni Querusareme. ");
INSERT INTO hchNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Xeme nenevieri xepipitüa que mü'ane xemücamate. Tame püta nenevieri tenipitüaca que mü'ane temümate, vicueisitüarica mayeneicacü Huriyusixi tahesie. ");
INSERT INTO hchNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Masi tucari canaye'amücü, hicü canaye'aniri, quepaucua müme yuricü memüyutineneviva nenevieri memipitüani yu'uquiyari yu'iyaricü yuri me'utiyuatü. Mücü meta, ne'uquiyari müya me'aneneme nivacuvauneni nenevieri memipitüanicü. ");
INSERT INTO hchNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Cacaüyari cani'iyaritüni. Neuyeveca müme nenevieri memipitüa yu'iyaricü memipitüanicü yuri me'utiyuatü. ");
INSERT INTO hchNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","'Uca tita'ei, Ne necatinimaica quename 'uhamie Mesiya Cürisitu heiserie mupitüarie mütiteva. Quepaucua munuani 'iya, nai catatinitahecüatüamücü. ");
INSERT INTO hchNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Quesusi tita'ei, Nesü necanihücütüni 'ahamatü nemüticuxata. ");
INSERT INTO hchNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Hicü teyü'üquitüvamete mecaniu'axüani. Meniuhüxiyani 'ucamatü müticuxatacaicü. Siepüre xevitü 'asipüca'utayü, Tita peticuvaune, titayari hamatüana peticuxata nusu. ");
INSERT INTO hchNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Hicü 'uca yuye'ü 'ucu'eirieca quiecarisie neyani. Müpaü tinivaretahüave 'uquisi, ");
INSERT INTO hchNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Camü xequene'ixüariyu tevi müneretahecüatüa nai que nemütiuyuri. Caticürisitu 'icü. ");
INSERT INTO hchNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Quiecarisie mecanayecüne, hepana menahucaitüni. ");
INSERT INTO hchNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Mericüsü mexi 'ame'ahucai, teyü'üquitüvamete menita'inieni müpaü me'utiyuatü, Ti'üquitame, quetineucuacari. ");
INSERT INTO hchNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","'Iya müpaü tinivarutahüave, Ne 'icuai necanexeiyani xemüca'imate xeme. ");
INSERT INTO hchNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","'Ayumieme müpaü meteniyücühüavecaitüni teyü'üquitüvamete, Xevitü cati'atüiri catimi. ");
INSERT INTO hchNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Quesusi tivarutahüave, Que nemüticamie tita mütinaque 'iya münesiheyenü'a, 'uximayasicaya que nemütinüxime, mücü canine'icuaitüni. ");
INSERT INTO hchNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Xeme müpaü xecate'utiyuane, Nauca meseri tixüyu 'isanari naye'amücü. Camü müpaü nepütixecühüave, Xequenetaneniereni, vaxa xequenexeiyani. 'Aixüa nivavaquiniri xemüca'isanacü. Hicü ");
INSERT INTO hchNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","'isaname catini'ivaneni. Nicuxeürieni tita mütiutixuaverixü, tucari mücaxüve memexeiyanicü, 'esame 'isanamematü yaxeicüa memüyutemamaviecacü. ");
INSERT INTO hchNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","'Icü hepaüsita niuqui yuri paine, Xevitü cani'esametüni, xevitüta ti'isaname maine. ");
INSERT INTO hchNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ne nepüxeheutanü'axüa xemüca'isanacü xemücateha'uximayacaisie. Hipatü mecateni'uximayacaitüni. Va'uximayasica xehesie tiniunaque. ");
INSERT INTO hchNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Mericüsü yumüiretü mana quiecatari Samariyatari yuri mecateniuta'erieni hesiena 'uca tiutahecüatacu yuniuquicü ya'utaitü, Nai que nemütiuyuri canetiniutahecüatüani. ");
INSERT INTO hchNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","'Ayumieme Samariyatari hesüana me'u'axüaca mecanita'inieni vahesüa müyuhayevacü. Mana huta tucari niyuhayeva. ");
INSERT INTO hchNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Hipatüta yumüiretü yuri mecateniuta'erieni niuquieyacü. ");
INSERT INTO hchNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Müpaü metenitahüave 'uca, Hicürixüa 'aniuquicü xeicüa yuri tepücate'erie. Tameri tecani'enieni, tecatenimaica 'icü yuricü cuiepa memütama vavicueisitüvame mühücücü. ");
INSERT INTO hchNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Mericüsü huta tucari 'anucayacu mana neyani. Carereya caninuani. ");
INSERT INTO hchNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Quesusi yücümana tiniutahecüata quename tixaxatame yucuiepa 'aye'aveme ca'eriva. ");
INSERT INTO hchNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Peru quepaucua Carereya munua Carereyatari mecanitanaqui'erieni nai mete'uxeiyaca que müreyurienecai Querusareme 'ixüararipa. Mümeta mecanecu'ixüara. ");
INSERT INTO hchNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Mericüsü hutarieca Canasie ninuani Carereya cuieyarisie ha vinu mayeitüasie. Xevitü cuiepa ti'aitame müparevivameyatücai mana niuyeicacaitüni. Nu'aya tinecuyecaitüni Caperünaumesie. ");
INSERT INTO hchNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Tiutamarieca 'iya quename Quesusi Cureya heyetüa Carereya nua, hesüana caneyani. Nitavavirieni mana müyemiecü, menayehüanicü nu'aya. Mücü nemüximecaitüni. ");
INSERT INTO hchNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Quesusi 'ayumieme müpaü tinitahüave, Cari xüca 'inüarite xecaxeiyani, mamarivavemeta, yuri xepücateta'erienicuta. ");
INSERT INTO hchNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Mücü ti'aitame parevivameya müpaü tinitahüave, Neuxei, mana quenemie nenive camüvecacu cuerietü. ");
INSERT INTO hchNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Quesusi titahüave, Quenemie. 'Anive nayeyuriniri. Hicü mücü tevi yuri tiniuta'erieni niuquieyasie Quesusi que mütitahüavixü. Neyani. ");
INSERT INTO hchNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Mana heutamiecacu te'uximayatametemama menenucunaque metehehüavetü niveya mayeyuricüri. ");
INSERT INTO hchNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","'Iya niuta'ivauni ya'utaitü que 'upaucuacacu manayeve. Müme müpaü metenitahüave, Tacai 'esiva cüa caviecacu cahüiyatü nayani. ");
INSERT INTO hchNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Hicü quemasieya tinetimani 'ana maye'acaicü quepaucua Quesusi mütitahüavixü, 'Anive nayeyuriniri. Mücüri yuri tiniuta'erieni, yunaitü hesüana quiecatarita. ");
INSERT INTO hchNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","'Ipaü hutarieca 'inüari tiniuyurieni Quesusi Cureya heyeyaca Carereya nuaca. ");
INSERT INTO hchNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Mericüsü 'arique Huriyusixi va'ixüarari naye'ani. Quesusi Querusareme neutiyune. ");
INSERT INTO hchNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Querusareme ha mana niyemacaitüni Muxasi Vaquitenie hura. Hepürayusixi vaniuquicü Vetesita tiniuyetevacaitüni ha muyemacai. 'Etüpivari niye'ucaitüni 'auriena 'auxüvitü. ");
INSERT INTO hchNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Mücütüa mecanayetecaitüni yumüiretü tecuicuicate, memacücüpe, memühurietüca, memümamavavaqui, meta'icuevatü ha mücuyuitüarienicü. ");
INSERT INTO hchNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Heiva mana niuta'axecaitüni niuqui tuayame. Ha nicuyuitüvacaitüni. Que mü'ane meri mana munua ha 'ucuyuitüariecu nanayeveni sepa que müticuyecai. ");
INSERT INTO hchNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Mericüsü xevitü tevi mana nayecateitüni xei teviyari heimana tamamata heimana 'atahaica viyari müticuyecai. ");
INSERT INTO hchNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Quesusi 'ixeiyaca mana 'ucaime, heitimaica müixa müyuriecaicü, müpaü tinitahüave, Peti'avaüriya pemanayeveni. ");
INSERT INTO hchNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ticuicame müpaü tinita'eiya, Neuxei 'uqui, havaicü tevi münesiheucahüani hapa quepaucua ha mucuyuitüarie. Mana ne'ucamiecacu xevitü meri mana caninuani. ");
INSERT INTO hchNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Quesusi tinitahüave, Quenanucuquexi, 'a'itari quenanucucue'i, quenecuyeicani. ");
INSERT INTO hchNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Cuitüva 'aixüa reu'erietü nayani tevi. Yu'itari nanucucueni, nicuyeicacaitüni. Mericüsü mücü tucari 'uxipiya tucari canihücütücaitüni. ");
INSERT INTO hchNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","'Ayumieme Huriyusixi müpaü metenitahüave 'iya manayehüiya, Hicü 'uxipiya tucari canihücütüni. Heiserie pepücahexeiya 'a'itari pemanucucuenicü. ");
INSERT INTO hchNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Mücü müpaü tivaruta'ei, Que mü'ane 'aixüa nereu'eriecame münesi'ayeitüa, mücü canetiniutahüave, 'A'itari quenanucucue'i quenecuyeicani. ");
INSERT INTO hchNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Müme müpaü metenita'ivaviya, Que püpaicü mücü tevi müya mümatiutahüavixü, Quenenucucue'i quenecuyeicani. ");
INSERT INTO hchNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Manayehüiya 'asipücatimaicai que müpaicütücai, metüacü Quesusi yumüiretü me'u'uvacacu mana. ");
INSERT INTO hchNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Hicü 'ariquemüca Quesusi nitaxeiya tuqui curaruyarita. Müpaü tinitahüave, Camüsü 'aixüa pereu'erietü pecanayani. Tavari 'axa pepücareyurieneni capa vaüca pe'u'itüarienicü masi. ");
INSERT INTO hchNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Tevi neyani. Müpaü tinivarutahüave Huriyusixi quename Quesusi hücütücai que mü'ane 'aixüa reu'eriecame meyeitüa. ");
INSERT INTO hchNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","'Ayumieme Huriyusixi meniveiyacaitüni Quesusi müpaü mütiyurienecaicü 'uxipiya tucarisie. ");
INSERT INTO hchNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Quesusisü müpaü tinivaruta'eiya, Ne'uquiyari müya tiniu'uximayatani hicüque, neta müya netiu'uximayata. ");
INSERT INTO hchNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","'Ayumieme masi cuini mieme menicuvautüvecaitüni Huriyusixi me'imienique, 'uxipiya tucari 'inüariyari mayeyeitüaximecaicü, masisü cuxi Cacaüyari müxatacaicü yu'uquiyaritüme, Cacaüyaripaü 'anetü 'ayuyeitüvatü. ");
INSERT INTO hchNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Hicü 'ayumieme Quesusi müpaü tinivaruta'eiya, Niuqui caniseüyeni que nemütixecühüave, nu'aya 'asipücayüve yücümana, que mütixeiya yu'uquiyari yatiyurieneme xeicüa püyüve. Tita mütiyuriene 'iya, müpaüta yaxeicüa tiniyurieneni nu'aya. ");
INSERT INTO hchNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ne'uquiyari yunive pünaqui'erie. Naime catinixeisitüani que mütiyuriene 'iya. 'Icü que mütiyuriene 'esiva marivemecü xeicüa, yemecü nixeisitüamücü mamarivavemecü, xemühüxiyanicü xeme. ");
INSERT INTO hchNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ne'uquiyari mütivaranucu'uitüvapaü müquite, tucari mütivarupitüvapaü nu'ayata müpaü catinivaru'uitüvani müme müyuvaüriya müvaranucu'uitüanicü. ");
INSERT INTO hchNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Mücü meta, ne'uquiyari xeime püca'inüata 'isücamepaü, masi heiserie nipitüani yunive 'isücamepaü mita'inüatacü naime, ");
INSERT INTO hchNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","yunaitü ve'eme memü'eriecacü nu'aya, yaxeicüa ve'eme memü'eriepaü 'uquiyarieya yunive meiyenü'a. Que mü'ane ve'eme müca'erie nu'aya, ve'eme püca'erie 'uquiyarieyata meiyenü'a. ");
INSERT INTO hchNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Niuqui caniseüyeni que nemütixecühüave, que mü'ane neniuqui mü'enie, yuri ti'eririetü 'iya münesiheyenü'a, mücü tucari mücaxüve canexeiyani. 'Isücame hüxie pücatacueviyani, masi niuyupata, camüquitüri, 'ayeyuritü püta hicü. ");
INSERT INTO hchNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Niuqui caniseüyeni que nemütixecühüave, tucari naye'amücü, hicüri naye'aniri, quepaucua müquite memi'enieni Cacaüyari Nu'aya 'utaniucame. Müme memü'enanani mecanayeyuyuricacuni. ");
INSERT INTO hchNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ne'uquiyari yücümana tucari que mürexeiya, müpaü yaxeicüa tinipitüani yunive tucari mexeiyanicü yücümana. ");
INSERT INTO hchNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Heiserie tipitüata 'isücamepaü müva'inüatacü Yuri Tevi mühücücü. ");
INSERT INTO hchNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Tixaü xepücahüxiyaca 'icücü. Tucari naye'amücü quepaucua yunaitü memucateuqui memi'enieni 'iya 'utaniucame. ");
INSERT INTO hchNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Mepüvaticüneta. Müme 'aixüa memüteyuriecai menanucu'uicuni tucari memüpitüarienicü, 'axa memüteyuriecai mete'anucu'uni memanutaxüriyanicü. ");
INSERT INTO hchNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ne necümana 'asinepücatiyüve. Que nemüti'ena, müpaü nepütiva'inüata 'isücamepaü neyüanetü. Que mütiheiserie nepüva'inüata nemüca'icuvaunecü tita münetinaque ne, tita mütinaque 'iya münesiheyenü'a püta nemücuvaunecü. ");
INSERT INTO hchNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ne xüca nehepaüsita netihecüatanique, yuricü nepücatihecüataniqueyu. ");
INSERT INTO hchNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Xevitü 'ecaniuyeicani mütihecüata nehepaüsita. Necatinimaica 'iya yuri mütihecüatacü nehepaüsita que mütihecüata. ");
INSERT INTO hchNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Xeme Vanisüa xecanivarenü'ani. Mücü tita yuri müraine hepaüsita tiniutahecüata. ");
INSERT INTO hchNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ne masi nepüca'itanaqui'eri tita teüteri memütehecüata nehepaüsita, perusü 'ipaü necaniutaineni xemütavicueisitüarienicü xeme. ");
INSERT INTO hchNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","'Iya cüxeme canihücütücaitüni tatü hecüarivietü. Xeme xeniyuvaüriyacaitüni xemüyutemamaviecacü 'iya yatixehecüariviyacacu yareutevitü. ");
INSERT INTO hchNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Mücü nehepaüsita mütihecüata, mücü masi türücaüyemecü catinihecüatani, tita mütihecüatacai Vani 'esiva xeicüa tihecüatacacu. Tita nemütiyuriene, ne'uquiyari que münetiupitüa nemeye'atüanicü, 'icü 'uximayasica que nemütiyuriene, 'icü nehepaüsita tinihecüatani quename ne'uquiyari nesiheyenü'a. ");
INSERT INTO hchNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Mücürita ne'uquiyari münesiheyenü'a, mücütütü nehepaüsita tinihecüatani. Xeme hasuacua xepüca'i'enievave 'utaniucame, xepüca'ixeiyavave que mütiyuxexeiya. ");
INSERT INTO hchNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Niuquieya xepücahexeiya xehesie yuhayevame yuri xemücate'i'eririecü que mü'ane 'Iya meiyenü'a. ");
INSERT INTO hchNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","'Utüaricasie xequetenecuvava, müpaü xemütecu'erivacü quename mücücü tucari mücaxüve xehexeiya. Mücütütü canihücütüni tita nehepaüsita mütihecüata. ");
INSERT INTO hchNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Xepücayuvaüriya nehepa xemahuni tucari xemexeiyanicü. ");
INSERT INTO hchNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Tita teüteri memütexata visi menetexeiyatü, mücü nepüca'utanaqui'eri. ");
INSERT INTO hchNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Siepüre nepüxehetima xeme, xemücayuhayevacü xe'inaqui'erietü Cacaüyari. ");
INSERT INTO hchNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ne necaninuani ne'uquiyarisüa nemiemetütü. Xemeri xepücanesi'utanaqui'eri. Xüca xevitü nuani yuhesüa miemetütü püta, xecanitanaqui'ericuni 'iya. ");
INSERT INTO hchNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Que xeteyüvave yuri xemüteta'erienicü xüca xe'itanaqui'erieni tita xemütexata visi xeteyuxeiyatü, xücarita xecatecuvautüveni 'iya muyuxevi Cacaüyaritütü visi mütixexeiyanicü xeme. ");
INSERT INTO hchNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Müpaü xepücatecu'erivani quename nexetaxaneta ne'uquiyari hüxie. Xevitü 'acaniuyeicani müxexaneta. Muisexi canihücütüni. Hesiena xeniu yuri xepüte'erie. ");
INSERT INTO hchNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Xücasü yuri xete'eriecaque Muisexisie, nehesietari yuri xepüte'eriecaqueyu. 'Iya nehepaüsita tiniuti'utüani. ");
INSERT INTO hchNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Xüca 'iya 'utüaricayasie yuri xecate'erieca, queri yuri xeteta'erieni tita nemüticuxatasie. ");
INSERT INTO hchNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Mericüsü 'arique caneyani Quesusi. Carereya haracunayarisie Tiveriya müracutevasie 'anutaüye neta'ani. ");
INSERT INTO hchNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Yumüiretü mecanicuveiyatüvecaitüni teüteri 'inüari memüxeiyacaicü que mütiyurienecai tecuicuicate vahesie. ");
INSERT INTO hchNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Hicü hürisie neutiyune Quesusi. Mana necateitüni, teyü'üquitüvametemamata metehetitecai hamatüana. ");
INSERT INTO hchNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Mericüsü Huriyusixi va'ixüarari Pasicua mütiteva nahuracaitüni. ");
INSERT INTO hchNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Hicü Quesusi heutaniereca, yumüireme varuxeiyaca hepana me'atihume, müpaü tinitahüave Piripe, Haque tepeinanaiyu pa 'ime memütecuanicü. ");
INSERT INTO hchNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Müpaü tiutayü 'i'isipatü. Mücüsietü tinimaicaitüni que mütiyurieniquecai. ");
INSERT INTO hchNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Hicü Piripe nita'eiya, Pa huta sienituyari 'inüariyarisie 'atü capütinaque vahesie mieme yuxexuitü 'esiva xeicüa memita'üixüanicü. ");
INSERT INTO hchNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Xevitü teyü'üquitüvametemama 'Atürexi mütitevacai Simuni Pecuru 'ivaya müpaü tinitahüave, ");
INSERT INTO hchNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","'Ena puyeica temaicü sevara payari 'auxüvime huta quesüteyari vara'ütü. Perusü 'icü que tipaüme yumüireme vahesie mieme. ");
INSERT INTO hchNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Quesusisü müpaü tiutayü, Xequenivaranucayasa teüteri. Mana vaüca nacu'üxayacaitüni. Hicü 'uquisi menanucayaxe 'auxüme miriyari meyupaümetü yacütüniquetü. ");
INSERT INTO hchNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Hicü Quesusi nenu'üni pa. Pamüpariyusi 'ipitüaca Cacaüyari tinivarumini mana memütitecai. Yaxeicüa tinivarumini quesüteta quepaü memüteucuaicucai. ");
INSERT INTO hchNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Hicü me'utihuxacu müpaü tinivarutahüave teyü'üquitüvamete, Xequeneucuxeüri tarimeyari manuyuhayevaxü capa reuyevenicü. ");
INSERT INTO hchNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","'Ayumieme mecanicuxeürieni. Tamamata heimana huta quirivayari meniutihüniya tarimeyari tecua'amete memicu'eirie 'auxüme sevara payarisie mieme. ");
INSERT INTO hchNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Mericüsü teüteri me'ixeiyaca 'inüari mütiuyuri müpaü meniutiyuanecaitüni, Cari yuricü 'icü canihücütüni 'iya tixaxatame cuiepa 'umamie. ");
INSERT INTO hchNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Hicü retimaica Quesusi quename me'axüaniquecai me'iviyaquecai tiva'aitüvame memayeitüanicü, tavari yuxaüta mana neutiyune hürisie. ");
INSERT INTO hchNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Mericüsü quepaucua tau macayunixü teyü'üquitüvamete mana meniucanexüani haracunapai. ");
INSERT INTO hchNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Canuvasie mecayaxeca haracuna 'anutaüye menecüne Caperünaumepai. Hicü niucuyüreri. Quesusi vahesüa pücanuavecai cuxi. ");
INSERT INTO hchNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Carima 'u'ecacacu haracuna niuyuanecaitüni. ");
INSERT INTO hchNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Hicü yateva 'auxüme 'ataxeime quirumetüruyari me'uhutü mecanixeiya Quesusi haracunasie 'uyeicame canuva hepa 'amiecame. Meniutimamani. ");
INSERT INTO hchNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","'Iya müpaü tinivarutahüave, Ne nepühücü. Xepücaheumamaca. ");
INSERT INTO hchNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Hicü meniyuvaüriya memitanaqui'erienicü canuvasie. Yapaucua canuva nivataneni cuiepa haque memeucünecai. ");
INSERT INTO hchNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Mericüsü 'uxa'arieca teüteri haracuna 'anutaüye memüti'ucai mecaniuneniere mana mucateicü xevitü canuva xeicüa, hipatü pücatixaü. Mepunenierixü Quesusi müca'acayerüvecai mücü canuvasie teyü'üquitüvamete vahamatü, masi teyü'üquitüvamete memecü yuhücüate. ");
INSERT INTO hchNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Hipatüta canuvate meneyecüne Tiveriya. Mana hura meniu'axüani haque pa memeticuai Ti'aitame pamüpariyusi 'ipitüacu Cacaüyari. ");
INSERT INTO hchNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Me'uneniereca teüteri Quesusi mana müca'uyeicacaicü, teyü'üquitüvametemamata memüca'u'uvacaicü, mümetari canuvatesie mecayaxeca menecüne Caperünaumepai me'icuvautüvetü Quesusi. ");
INSERT INTO hchNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Haracuna 'anutaüye meheitaxeiyaca müpaü metenitahüave, Ti'üquitame, quepaucua pepunua 'uvapai. ");
INSERT INTO hchNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Quesusi müpaü tivaruta'ei, Niuqui caniseüyeni que nemütixecühüave, xepücanesicuvautüve 'inüarite xemüxeicü. Pa xemeticuaicü xemetihuxaicü püta xepünesicuvautüve. ");
INSERT INTO hchNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Xepücate'uximayaca 'icuai mütipünive xema'ivacü xeicüa. Xequetene'uximayaca püta xeme'ivacü 'icuai 'amütiterive tucari mücaxüve müxepitüa Yuri Tevi mütixemini. 'Uquiyarieya Cacaüyaritütü ni'inüaritüani 'iya. ");
INSERT INTO hchNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","'Ayumieme müpaü metenitahüave, Queri teteyurieca Cacaüyari 'uximayasicaya temüte'uximayacacü. ");
INSERT INTO hchNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Quesusi müpaü tivaruta'ei. 'Icü canihücütüni Cacaüyari 'uximayasicaya, yuri xemüte'eriecacü 'iya meiyenü'asie. ");
INSERT INTO hchNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Müme mete'icühüave, Mericüte, tita petiyuriene 'inüari, temixeiyacü, yuri temümateta'eririenicü. Que petiu'uximayata. ");
INSERT INTO hchNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Tame tatevarima manana payari metenicuacaitüni macumavesie, que müre'uxa, Taheima mieme pa tinivamicuacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Hicü Quesusi müpaü tivarutahüave, Niuqui caniseüyeni que nemütixecühüave, Muisexi capühücütücai que mü'ane müxe'umi mücü pa taheima mieme. Ne'uquiyari püta tinixemicuani tita yuricü mütipa taheima mieme. ");
INSERT INTO hchNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Que mü'ane taheima macaneica, tucari müvamicua cuiepa memütama, mücütütü canihücütüni Cacaüyarisüa mieme pa. ");
INSERT INTO hchNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Müme metehehüave, Ti'aitame, 'aheyemecü quetatineumicua 'icü pa. ");
INSERT INTO hchNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Quesusi müpaü tivarutahüave, Ne necanihücütüni pa tucari tiyupitüvame. Que mü'ane nehesüa müye'ani pücaheuhacamücüni. Que mü'ane nehesie yuri müti'erie havai pücaheuharimücüni hasuacua. ");
INSERT INTO hchNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Masi yanepütixecühüavecai, xepünesixeiya peru yuri xepücate'erie. ");
INSERT INTO hchNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Naime ne'uquiyari münetipitüa nehesüa püye'ani. Que mü'ane nehesüa müye'ani, tacua nepüca'anuyehüani. ");
INSERT INTO hchNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ne taheima nepüca'acane tita münetinaque yanemütiyurienenicü. Tita mütinaque 'iya münesiheyenü'a püta yanemütiyurienenicü nepacane. ");
INSERT INTO hchNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","'Ipaü catininaqueni 'iya münesiheyenü'a, nai münetiupitüa nemücaheiyehüanicü ni xeime, masi nemenucuquetüanicü tucari 'aye'ayu quepaucua mütapare. ");
INSERT INTO hchNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","'Ipaürita catininaqueni ne'uquiyari, yunaitü memixeiya nu'aya, yuri memüte'erie hesiena, tucari mücaxüve memexeiyanicü. Ne nepüvaranucu'uitüani tucari 'aye'ayu quepaucua mütapare. ");
INSERT INTO hchNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Hicü Huriyusixi meniniuquixiecaitüni hepaüsitana müpaü mutayücü, Ne pa necanihücütüni taheima macane. ");
INSERT INTO hchNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Müpaü meniutiyuanecaitüni, 'Icü catiquesusi Cuse münu'aya. Tame quemasieya varusieya tepüvamate. Quetütü paine hicü taheima macane. ");
INSERT INTO hchNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Quesusi müpaü tivaruta'ei, Xepücaniuquixieca yusata. ");
INSERT INTO hchNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Xevitü pücayüve nehesüa müye'ani, me xüca ne'uquiyari münesiheyenü'a 'enucuhana xeicüa püyüve. Ne tucari 'aye'ayu quepaucua mütapare necanenucuquetüamücü. ");
INSERT INTO hchNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Texaxatamete vaxapasie müpaü catine'uca, Cacaüyari tiniva'üquitüaca yunaime. Yunaitü memü'enana ne'uquiyari que maine, memüteyü'üquitüa, müme nehesüa mecaniye'axüacuni. ");
INSERT INTO hchNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Perusü xevitü püca'ixeiyave ne'uquiyari. Que mü'ane Cacaüyarisüa miemetütü 'amuyeica, mücü xeicüa canixeiyaveni ne'uquiyari. ");
INSERT INTO hchNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Niuqui caniseüyeni que nemütixecühüave, que mü'ane nehesie yuri müti'erie, tucari mücaxüve canexeiyani. ");
INSERT INTO hchNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ne pa tucari tiyupitüvame necanihücütüni. ");
INSERT INTO hchNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Xetevarima manana payari metenecuacaitüni macumavesie. Müme menecuini. ");
INSERT INTO hchNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","'Icü canihücütüni pa mayeyuri taheima macaneica tevi miticuanicü mücamünicü. ");
INSERT INTO hchNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ne necanihücütüni pa mayeyuri taheima macane. Xüca tevi 'icü pa 'uticuani, yuheyemecü payeyurini. 'Icü pa nemüyetuani ne, nevaiyari canihücütüni, cuiepa memütama vatucari cani'ayumiemetüni. ");
INSERT INTO hchNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Hicü Huriyusixi meniyuxamurietüvecaitüni yameteyücühüavetü, Quetütü püyüve 'icü yuvaiyari mütasimicua temiticuanicü. ");
INSERT INTO hchNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Quesusi 'ayumieme müpaü tinivarutahüave, Niuqui caniseüyeni que nemütixecühüave, xüca xeca'iticuani Yuri Tevi vaiyarieya, xüca xuriyaya xeca'anu'ieni, tucari xepücahexeiya yuhesie. ");
INSERT INTO hchNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Que mü'ane nevaiyari mücüa'a nexuriya mü'ie, tucari mücaxüve canexeiyani. Tucari 'aye'ayu quepaucua mütapare, necanenucuquetüamücü. ");
INSERT INTO hchNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ne nevaiyari yuricü cani'icuaitüni, nexuriya yuricü cananu'ivani. ");
INSERT INTO hchNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Que mü'ane nevaiyari mücua'a nexuriya mü'ie, mücü nehesie tiviyatü niyuhayevamücü, neta hesiena netiviyatü netinehayeva. ");
INSERT INTO hchNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ne'uquiyari mayeyuri cuiepa que münerenü'apaü, ne que nemürayeyuri ne'uquiyaricü, müpaürita yaxeicüa que mü'ane münesicua'a, mücüta canayeyuricamücü necümana. ");
INSERT INTO hchNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","'Icü canihücütüni pa taheima macane. Xetevarima que memüte'ucuai que memüte'ucui, müpaü püca'ane. Que mü'ane 'icü pa mücua'a yuheyemecü canayeyuricamücü. ");
INSERT INTO hchNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Müpaü niutayüni Caperünaumesie ti'üquitatü tuquita. ");
INSERT INTO hchNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Hicü 'ayumieme teyü'üquitüvametemama yumüiretü me'u'enanaca müpaü meniutiyuani, 'Icü niuqui canicuaniveni. Quepai püyüve mi'enieni. ");
INSERT INTO hchNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Quesusi yu'iyarisie retimaica memüniuquixiecaicü teyü'üquitüvametemama 'icü hepaüsita, müpaü tinivarutahüave, 'Icücü xetetiquetamürique 'acu. ");
INSERT INTO hchNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Quesü yüniqueyu xüca xe'ixeiyanique Yuri Tevi mana 'utimiecame haque meripai mecatei. ");
INSERT INTO hchNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","'Iyari canihücütüni tucari tiyupitüvame. Vaiyari 'asipücayüni. Tita nemütixecuxaxatüva ne, mücü cani'iyaritüni canitucaritüni. ");
INSERT INTO hchNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Peru hipatü xeme yuri xepücate'erie. Quesusi matüaripai nivamaicaitüni quehate müme yuri memücate'eriecai, timaicaita que mü'ane miyetuaniquecai. ");
INSERT INTO hchNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Müpaü tinicuxatacaitünita, 'Ayumieme nepütixecühüave, xevitü mücayüve nehesüa müye'ani xüca ne'uquiyari müpaü catipitüaca. ");
INSERT INTO hchNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Mücücü yumüiretü teyü'üquitüvametemama yucutama menitacüni, hamatüana mepüca'u'uvacairi. ");
INSERT INTO hchNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","'Ayumieme Quesusi müpaü tinivarutahüave tamamata heimana yuhutame, Xemerita xeteyuvaüriya xemüyehu. ");
INSERT INTO hchNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simuni Pecuru müpaü tinita'eiya yucu'imavatü, Ti'aitame, quepai rahesüa tepüteyehu. 'Ecüsü niuqui tucari mücaxüve hepaüsita pecanexeiyani. ");
INSERT INTO hchNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Hicürixüa yuri tecateniuta'erieni, tecamanetimani 'ecü que mü'ane Cacaüyarisüa mümieme müpasie pemühücücü. ");
INSERT INTO hchNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Quesusi müpaü tivaruta'ei, Camü necatixe'anayexei tamamata heimana yuhutame xeme. Xevitü xeme Cauyumariepaü cani'aneni. ");
INSERT INTO hchNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Mücü Cura Simuni nu'aya 'Isicariutitanaca nixatacaitüni. Mücü niyetuaniquecaitüni xevitü mühücütücai tamamata heimana yuhutatü. ");
INSERT INTO hchNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Mericüsü 'arique Quesusi Carereya niuyeicacaitüni. Pücayuvaüriyacai Cureya muyeicani Huriyusixi memicuvautüvecaicü me'imienique. ");
INSERT INTO hchNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Hicü Huriyusixi va'ixüarari nahuracaitüni quepaucua xamaru memutiveviva. ");
INSERT INTO hchNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","'Ivamama 'ayumieme müpaü metenitahüave, 'Uva peyeyame Cureya quenemie, 'ahesüa miemete teyü'üquitüvamete memixeiyacü tita pemütiyuriene. ");
INSERT INTO hchNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Tevi 'avie capütiyuriene, ticuvaunetü yunaime vahürüpa mümarivanicü. Xüca müpaü petiyurieneni, pemasiücüme quena'ayeitüa cuiepa memütama vahüxie. ");
INSERT INTO hchNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","'Ivamamata yuri mepücate'eriecai hesiena. ");
INSERT INTO hchNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Hicü Quesusi müpaü tinivarutahüave, Ne netucari püca'aye'ave cuxi. Xeme tixaü xepücatetacuevi. ");
INSERT INTO hchNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Cuiepa memütama mepücayüvave memüxe'uxive'erieca. Ne püta mecaneni'uxive'erieca vahepaüsita nemütihecüatacü, tita memüteyurie 'axa mü'anene nemutainecü. ");
INSERT INTO hchNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Xemeri xequene'ixüarayu. Ne cuxi nepüca'ixüaramie 'icüsie, netucari müca'aye'avecü cuxi. ");
INSERT INTO hchNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Müpaü tivarutahüaveca Carereya niyuhayeva. ");
INSERT INTO hchNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Hicü 'ivamama meheu'ixüarayucacu 'iyata neyani 'arique, 'avie xeicüa cayuhecüatatü. ");
INSERT INTO hchNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Hicü Huriyusixi meneicuvautüvecaitüni 'ixüararipa müpaü me'utiyuatü, Haque peyeica 'iya. ");
INSERT INTO hchNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Teüteri vaüca mepütecuxatacai hepaüsitana, 'avie xeicüa. Hipatü müpaü meniutiyuanecaitüni, Masi 'aixüa pütiuca'iyari. Hipatüri mete'utiyuanecai, Tixaüsietü püvareuyexürüva teüteri. ");
INSERT INTO hchNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Masi xevitü teüteri vahürüpa pücaticuxatacai hepaüsitana yunaitü memüvamacarücaicü Huriyusixi. ");
INSERT INTO hchNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Hicü 'ixüarari hixüapariecari Quesusi neutiyune tuquipa. Mana tini'üquitacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Huriyusixi menihüxiyacaitüni yame'utiyuatü, Queri timaive 'icü 'utüarica. Pücatiyuti'üquitüave. ");
INSERT INTO hchNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Quesusiri 'ayumieme müpaü tinivarutahüave, Tita nemüti'üquita nehesüa pücamieme. Que mü'ane münesiheyenü'asüa püta canimiemetüni. ");
INSERT INTO hchNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Xüca tevi yuvaüriyani yamüticamienicü tita mütinaque 'iya, catinimaicamücü tita nemüti'üquita hepaüsita, xüca Cacaüyarisüa miemetüni, me xüca necümana ne'utaineni nusu. ");
INSERT INTO hchNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Que mü'ane yücümana mutaine catinicuvauneni visi müticühüavarüvanicü. Que mü'ane müticuvauneni visi müticühüavarüvanicü 'iya meiyenü'a püta, mücü yuri paine, tita mücatiheiserie pumave heisiena. ");
INSERT INTO hchNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Camü Muisexi catixe'upitüa 'inüari niuquiyari xemeixeiyanicü. Perusü ni xevitü xeme yapücaticamie 'inüari niuquiyarisie. Titayari xenetecuvautüve xenesimienique. ");
INSERT INTO hchNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Teüteri müpaü mete'ita'ei, Cari cacaüyari 'axa mü'ane pümasinü'ü. Quepai masicuvaune masimienique. ");
INSERT INTO hchNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Quesusi müpaü tivaruta'ei, Ne 'uxipiya tucarisie heiva xeicüa tixaütü nepütiuyuri, peru yunaitü xecanihüxiyaca. ");
INSERT INTO hchNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","'Ayumieme meta Muisexi nixe'upitüani xitequiya 'inüariyari. Muisexisüa pücamieme, tatevarima vahesüa püta canimiemetüni. Peru 'uxipiya tucarisie xepi'inüaritüa 'uqui nunusi. ");
INSERT INTO hchNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Xüca 'uqui 'uxitequieni 'uxipiya tucarisie Muisexisüa mieme 'inüari niuquiyari müca'ayeitüarienicü, que xeneteheca ne nai 'aixüa reu'eriecame nemayeitüacü xeime tevi 'uxipiya tucarisie. ");
INSERT INTO hchNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Que mütiyuxexeiya xeicüa niuqui xepücavevieca, que mütiheiserie püta xequenevevieca niuqui. ");
INSERT INTO hchNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Hicü Querusaremetari hipatü 'ayumieme müpaü meniutiyuanecaitüni, 'Icü catihücü memicuvautüve me'imienique. ");
INSERT INTO hchNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Camü yunaime vahürüpa catinicuxatani, 'asimepücatehehüave. Ta'uquiyarima xüari yuricü mepücaheitima 'icü mücürisitu heiserie mupitüarie. ");
INSERT INTO hchNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Perusü tame tecanimaica 'icü haque memieme. Quepaucua munuani Cürisitu, xevitü 'asipücatimaica haque memieme. ");
INSERT INTO hchNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Hicü Quesusi müpaü tiniuhiva tuqui curaruyarita ti'üquitatü, Xeme xenetemate 'acu, haque nememieme xetemate. Ne necümana nepücanua. Masi yuri canaineni 'iya münesiheyenü'a. Xeme xepüca'imate. ");
INSERT INTO hchNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Nesü necanimaica hesüana nemümiemecü, münesiheyenü'acü. ");
INSERT INTO hchNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Hicü mecanicuvautüvecaitüni me'iviyaque. Xevitü püca'ivi tucarieya müca'aye'avecaicü cuxi. ");
INSERT INTO hchNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Teüteri yumüiretü yuri mecateniuta'erieni hesiena. Müpaü meniutiyuanecaitüni, Quepaucua munuani Cürisitu, masi vaüca catiyurieneni 'inüarite, 'e'ivatü 'icü que mütiyuriene. ");
INSERT INTO hchNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Hicü Pareseusixi meniva'eniecaitüni teüteri hepaüsitana vaüca metecuxatame. Mara'acate memühüritüariecai Pareseusixi vahamatü mecanivaretanü'ani tupirisixi memiviyacü. ");
INSERT INTO hchNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Hicü müpaü niutayüni Quesusi, Yareutevitü cuxi xehamatü neniuyeicamücü. 'Arique 'iya münesiheyenü'asüa nepüyemie. ");
INSERT INTO hchNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Xepünesicuvautüveni peru xepücanesitaxeiya. Mücü meta, haque nemeyeicani xepücayüvave xemeta'axüani. ");
INSERT INTO hchNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Huriyusixi müpaü meteniyücühüavecaitüni, Que tiyune 'icü temüca'itaxeiyacü. Cüriyecusixi vasata memeutayeixüa vahesüa catiyemie, Cüriyecusixi tivareti'üquitüanique. ");
INSERT INTO hchNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Quesü 'icü titita niuqui müya mutaine, Xepünesicuvautüveni, xepücanesitaxeiya, haque nemeyeicani xepücayüvave xemeta'axüani, haitü. ");
INSERT INTO hchNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Hicü ve'eme tucarisie 'ixüarari heutiparirümecacu, mana niuvecaitüni Quesusi. Nahivacaitüni müpaü 'utaitü, Xüca tevi heuharimücüni, nehesüa quenuani, que'anuhareni. ");
INSERT INTO hchNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Que mü'ane nehesie yuri müti'erie, 'utüarica manuyünepaü, hatüapaü 'anenetü caniuhanecamücü taütana ha muhanesie miemepaü 'anenetü. ");
INSERT INTO hchNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Müpaü niutayüni 'Iyari xatatü memitanaqui'erieniquecai müme yuri memüteta'erieniquecai hesiena. Mücü 'Iyari mepücatanaqui'erivavecai cuxi Quesusi cuxi visi 'anetü müca'ayeitüarievecaicü. ");
INSERT INTO hchNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Hicü teüteri hipatü 'icü niuquite me'u'enieca müpaü meniutiyuanecaitüni, Yuricü mücü tixaxatame canihücütüni 'icü. ");
INSERT INTO hchNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Hipatüta mete'utiyuanecai, Cari 'icü Cürisitu canihücütüni. Hipatüta mete'utiyuanecai, Masi Cürisitu Carereya pücamiemetüni. ");
INSERT INTO hchNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Camü 'utüarica müpaü caranuyüne, Cürisitu Raviri püxiüyarieyatüni, quiecarisie Raviri mecateisie pümiemetüni Verenisie. ");
INSERT INTO hchNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","'Ayumieme teüteri hixüata meniyusana cümana. ");
INSERT INTO hchNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Hipatüta müme meniviyacucaitüni, perusü xevitü püca'ivi. ");
INSERT INTO hchNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Hicü tupirisixi meniu'axüani mara'acate memühüritüariecai vahesüa Pareseusixi vahesüa. Mümeri müpaü metenivarutahüave, Titayari xecate'i'atüa. ");
INSERT INTO hchNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Tupirisixi müpaü metevaruta'ei. Tevi hasuacuari pücaticuxatacai 'icü tevi müticuxatapaü. ");
INSERT INTO hchNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Hicü Pareseusixi müpaü metevaruta'ei, Cari xemeta xepeuyexüriya. ");
INSERT INTO hchNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Camü te'aitamete Pareseusixi que mü'ane müme hesiena yuri pütiuta'eri. ");
INSERT INTO hchNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Peru 'icü teüteri 'inüari niuquiyari memücamate 'axa mepütecühüavarüva. ");
INSERT INTO hchNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Hicü 'iya meripai Quesusisüa munua yüvicüta Nicuremu müpaü tinivarutahüave, xevitü mühücütücaicü müme, ");
INSERT INTO hchNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Camüsü ta'inüari niuquiyaricü tepüca'enutahüani tevi xüca meri teca'i'enieni que mutaine, xüca teca'imaica que mütiyuriene. ");
INSERT INTO hchNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Mümeri müpaü metenita'eiya, Quesü 'ecütari Carereya petimieme. Quetinecuvava, quetinexeiyani Carereyasie müca'ayenevecü tixaxatame havaicü. ");
INSERT INTO hchNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Yuxexuitü yuquie mepeutayeixüa. ");
INSERT INTO hchNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Quesusisü yemurisie neyani Huriva Mati'u müracutevasie. ");
INSERT INTO hchNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ximeri tavari tuquipa ninuani. Yunaitü teüteri hesüana meni'axecaitüni. Mana 'ayerüca tiniva'üquitüacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Hicü te'utüvamete Pareseusixi vahamatü mecani'atüirieni 'uca muviyarie xeime cünayamame meyucumaüvacacu. Hixüapa me'itaqueca ");
INSERT INTO hchNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","müpaü metenitahüave, Ti'üquitame, 'icü 'uca caniuviyarieni xeime cünayamatü meyucumaüvame. ");
INSERT INTO hchNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","'Inüari niuquiyarisie Muisexi müpaü catatiniu'aitüani tetexicü temüvatituaxanicü müya memüyüa. Camüsü que petayüni 'ecü. ");
INSERT INTO hchNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Müpaü meniutiyuani me'i'isipatüvetü me'itaxanetaque. Quesusisü 'anacatusireca, cuiepa tiniuta'utüani yu'itüvamecü. ");
INSERT INTO hchNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Müme 'ameteheuterecu meheicu'ivaviyatü, 'iya nanucuqueni. Müpaü tinivarutahüave, Que mü'ane xeme 'axa mücatiyurieve, mücü meri pitatuaxa tetecü. ");
INSERT INTO hchNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Tavari 'anacatusireca, cuiepa tiuta'utüa. ");
INSERT INTO hchNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Mümeri memu'enana, va'iyari vatate'acacu, meneutayeixüani yuxexuitü me'ayecücatü, 'uquiravesixi meri. Quesusi yuxaüta niyuhayeva, 'uca hixüapa muvecai tiuyuhayevaxüta. ");
INSERT INTO hchNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Hicü 'anucuqueca Quesusi, hipame cavaxeiyatü, 'uca xeicüa, müpaü tinitahüave, Neuxei, 'uca, haquevari müme masixanetamete. Xevitü 'ahesie carahüa. ");
INSERT INTO hchNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","'Iya tiutayü, Ti'aitame, haquevasü. Quesusi titahüavixü, Neta 'ahesie nepücatihüani. Quenemie, tavari 'axa pepücareyurieneni. ");
INSERT INTO hchNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Mericüsü Quesusi tavari tinivarutixatüani müpaü 'utaitü, Ne cuiepa memütama vahecüarivivame necanihücütüni. Que mü'ane münesi'anuveiya yüvipa püca'uyeicani, masi hecüariya canexeiyacamücü tucaritüme. ");
INSERT INTO hchNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Pareseusixi 'ayumieme müpaü metenicühüaveni, 'Ecü 'ahepaüsita xeicüa pecatinihecüatani. Tita pemütihecüata pücayuri. ");
INSERT INTO hchNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Quesusi müpaü tinivaruta'eiya, Sepasü nehepaüsita nemütihecüata, tita nemütihecüata puyuri nemütimatecü haque nememieme que nemütimie. Xeme 'asixepücatemate haque nememieme que nemütimie. ");
INSERT INTO hchNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Xeme teüteri vahepaü xepüteyu'inüata. Ne püta tevi nepüca'inüata. ");
INSERT INTO hchNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Masisü xüca ne'ita'inüataque, nepihecüatüaniqueyu tita yuricü müti'inüari nehexeiyatü, nexaüta nemüca'uyeicacü, 'iya münesiheyenü'a nehamatü muyeicacü. ");
INSERT INTO hchNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Mücü meta, xe'inüari niuquiyarisie müpaü catine'uxani, Yuhutatü teüteri tita memütetahecüata puyuri. ");
INSERT INTO hchNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Mericüte, ne necanihücütüni que mü'ane nehepaüsita mütihecüata, ne'uquiyari münesiheyenü'a nehepaüsita tinihecüatanita. ");
INSERT INTO hchNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Müme müpaü metenitahüave, Haqueri 'a'uquiyari. Quesusi müpaü tivaruta'ei, Xeme xepücanesimate ne, ne'uquiyarita xepücamate. Xüca xenesimaicaque ne, ne'uquiyarita xepümaicaqueyu. ");
INSERT INTO hchNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","'Icü niuquicü catinicuxatacaitüni tumini mahüriesie tuqui curaruyarita ti'üquitatü. Xevitü püca'ivi tucarieya müca'aye'avecaicü cuxi. ");
INSERT INTO hchNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Hicü tavari müpaü tinivarutahüave, Nesü nepüyemie. Xepünesicuvautüveni, tita 'axa xemüteyuriesie xeteviyatü xecanicuicuni. Que nemüreumie xepücayüvave xemeta'axüani. ");
INSERT INTO hchNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Huriyusixi 'ayumieme müpaü metenicuxatacaitüni, Yücümana catiyumieni müpaü mutayücü, Que nemütimie xepücayüvave xemeta'axüani. ");
INSERT INTO hchNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","'Iya müpaü tinivarutahüave, Xeme 'ena xepümiemete. Ne püta taheima necanimiemetüni. Xeme 'ena cuiepa xepümiemete. Ne püta 'ena cuiepa nepücamieme. ");
INSERT INTO hchNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","'Ayumieme yanepütixe'utahüavixü xemücuini tita 'axa xemüteyuriesie xeteviyatü. Xüca yuri xecate'uta'erieni quename ne nehücü, xecanicuicuni tita 'axa xemüteyuriesie xeteviyatü. ");
INSERT INTO hchNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Müme müpaü metenicühüavecaitüni, 'Ecü que pepüpaicüte. Quesusi tivarahüave, Yemecü nepühücü tita nemütixecuxaxatüva. ");
INSERT INTO hchNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Vaüca necaneixeiyani xehepaüsita nemüticuxatanicü, xehesie nemütihüpanicü. 'Iya münesiheyenü'a masi yuri canaineni. Tita nemütiu'eni 'iya yahainecacu, mücü nepütivataxatüani cuiepa memütama. ");
INSERT INTO hchNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Müme 'asimepücatehetima yu'uquiyari müvacuxaxatüvacaicü. ");
INSERT INTO hchNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Hicü Quesusi müpaü niutayüni, Quepaucua xemenutihana Yuri Tevi, 'anari xepütehetimani ne nemühücücü, necümana 'asinemücatiyurienecü. Ne'uquiyari münetiu'üquitüapaü, müpaü xeicüa nepüticuxata. ");
INSERT INTO hchNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Mücü meta, 'iya münesiheyenü'a nehamatü caniuyeicani. Pücanesi'ucu'eiri nexaüta, neheyemecü yanemütiyurienecü tita mütinaque. ");
INSERT INTO hchNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","'Ipaü ticuxatacacu yumüiretü yuri mecateniuta'erieni hesiena. ");
INSERT INTO hchNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Quesusi 'ayumieme müpaü tinivarutahüave müme yuri memüte'ita'eriri Huriyusixi, Xeme neniuquisie xeteviyatü xüca xeyuhayevani, yuricü nehesüa miemete teyü'üquitüvamete xecanihümetüni. ");
INSERT INTO hchNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Tita yuri müraine xecanetimaicuni. Mücü yuri maine canixetixünamücü. ");
INSERT INTO hchNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Müme müpaü metenita'eiya, Tame 'Apurahami tecanixiüyarimamatüni. Xeimesie mieme vaüriyarica tepücate'uti'uximayataxü hasuacua. Que pehaine, xexüxünitü xemacüne pemaine. ");
INSERT INTO hchNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Quesusi müpaü tivaruta'ei, Niuqui caniseüyeni que nemütixecühüave, yunaitü 'axa memüteyurie vaüriyarica meteni'uximayaca tita 'axa müti'anesie mieme. ");
INSERT INTO hchNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Mericüte, vaüriyarica müti'uximaya yuheyemecü 'apüca'uca quiecamepaü. Quiecame nu'aya püta 'apuca yuheyemecü. ");
INSERT INTO hchNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Xüca nu'aya xetixünamücü, panasi xexüxünitü xecanacünicuni. ");
INSERT INTO hchNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ne nepütimate 'Apurahami xemüxiüyarimama. Siepüre xecanenicuvautüveni xenesimienique neniuqui müyutexiecü xehesüa. ");
INSERT INTO hchNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Tita nemütiuxei ne'uquiyarisüa yanepüticuxata. Xemesüari tita xemüte'u'eni yu'uquiyarisüa yaxepütecahu. ");
INSERT INTO hchNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Müme müpaü mete'ita'ei, Tame ta'uquiyari 'Apurahami canihücütüni. Quesusi müpaü tivarutahüave, 'Apurahami xüca xexiüyarimamatüni, 'Apurahami que mütiyurienecai yaxequeteneyurieca. ");
INSERT INTO hchNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Masi hicü xepünesicuvautüve xenesimienique. Ne necanitevitüni nemütixecuxaxatüva tita yuri müraine que nemütiu'enaxü Cacaüyarisüa. Xehepaü capütiuyuri 'Apurahami. ");
INSERT INTO hchNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Xeme xe'uquiyari que mütiyuriene yaxetenicahuni. Mete'itahüave, Tametütü tavarusi que mü'ane mücacünayatücai, mücü pücatasi'utivevi. Xei 'uquiyariyari tecanexeiyani Cacaüyaritüme. ");
INSERT INTO hchNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Quesusi müpaü tivarutahüave, Xüca Cacaüyari xe'uquiyaritünique, xecaneninaqui'eriecaqueyu ne. Ne Cacaüyarisüa necaneyeyani necaninuaniri. Mücü meta, necümana nepücanua. 'Iya püta caneneyenü'ani. ");
INSERT INTO hchNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Titayari xecateheitimaivave tita nemütixata. Xemücayüvavecü neniuqui xemü'enieni, 'ayumieme xepüca'iquema. ");
INSERT INTO hchNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Xeme yu'uquiyarisüa xecanimiemetetüni Cauyumariesüa. Xecaniyuvaüriyani yaxemüteyuriecacü tita mütihive'erie xe'uquiyari. 'Iya meripai catiniyumemivani. Tita yuri mürainesie tiviyatü 'apüca'uvecai, tita yuri müraine mumavecü hesiena. Quepaucua 'itaricacü müticuxata, yücümana tinicuxatani müti'itavacü, memüte'itava müva'uquiyaricü. ");
INSERT INTO hchNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ne püta yuri nemainecü, yuri xepücanete'eriri. ");
INSERT INTO hchNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Que mü'ane xeme nehesie pürahüani, 'axa nemütiuyuri 'utaitü. Me xüca yuri nehaineni, titayari yuri xecanete'eriri. ");
INSERT INTO hchNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Que mü'ane Cacaüyarisüa mümieme cani'enieca tita Cacaüyari müticuxata. 'Ayumieme xepücaheu'enana, Cacaüyarisüa xemücamiemetecü. ");
INSERT INTO hchNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Huriyusixi müpaü metenita'eiya, Cari 'aixüa teniutiyuaneni quename 'ecü pesamariyatanaca, quename cacaüyari 'axa mü'ane masinü'ü. ");
INSERT INTO hchNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Quesusi tivaruta'ei, Neri cacaüyari 'axa mü'ane pücanesinü'ü. Masi 'aye'ame ne'erietü nepixata ne'uquiyari, xeme püta ne'aye'ame xecanesi'erietü xepünesixata. ");
INSERT INTO hchNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ne tixaü nepücaticuvaune visi nemüticühüavarüvanicü. Que mü'ane müticuvaune visi nemüticühüavarüvanicü, que mü'ane 'isücamepaü müva'inüata, mücü 'acaniuyeicani. ");
INSERT INTO hchNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Niuqui caniseüyeni que nemütixecühüave, xüca tevi neniuquisie yaticamieni, hasuacua pücahetimani müya. ");
INSERT INTO hchNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Huriyusixi müpaü mete'itahüave, Hicürixüa tepütehetima cacaüyari 'axa mü'ane mümasinü'ü. Camü 'Apurahami caniumüni, texaxatameteta mete'ucui. 'Ecüsü müpaü pecanaineni, xüca tevi neniuquisie yaticamieni, müya pücamaica hasuacua. ");
INSERT INTO hchNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","'Ecü que petive'eme ta'uquiyari 'Apurahami 'asicayüvecacu. Mücü caniumüni, texaxatameteta mete'ucui. Titari pera'ayeitüaxime. ");
INSERT INTO hchNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Quesusi tivaruta'ei, Xüca ne visi nehainenique nehepaüsita, tixaü pücatihücütüniqueyu visi que nemüticühüavarüvaniqueyu. Ne'uquiyari canihücütüni que mü'ane visi maine nehepaüsita. Xeme yaxeputiyuane quename xecacaüyari 'iya. ");
INSERT INTO hchNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Masi xepücaheitimaivave. Nesü püta necanimaica. Xüca nehainenique quename neca'imate, xehepaü neti'itavatü nenayaniqueyu. Masiri necanimaica, niuquieyasie yanepüticamie. ");
INSERT INTO hchNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Xe'uquiyari 'Apurahami cuini mieme tiniyutemavieca netucari ha'erivatü mixeiyacü. Nixeiya, tinaqui'acai. ");
INSERT INTO hchNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Huriyusixi 'ayumieme müpaü metenitahüave, 'Ecü huta teviyari heimana tamamata viyari pepücahü. Que petixei 'Apurahami. ");
INSERT INTO hchNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Quesusi tivarutahüave, Niuqui caniseüyeni que nemütixecühüave, 'Apurahami 'aca'uyeicacacu cuxi, 'aneniuyeicani ne. ");
INSERT INTO hchNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Hicü 'ayumieme tetexi mecaniutitücü me'ituaxaque. Quesusi niyuti'avieta, tuqui curaruyarita nivayeyani vasata 'umietü. ");
INSERT INTO hchNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Hicü mana 'uyemietü tevi niuxeiya 'acüpetü mutinuivaxü. ");
INSERT INTO hchNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Teyü'üquitüvametemama müpaü metenita'ivaviya, Ti'üquitame 'acu, quepai 'axa pütiuyuri, 'icü 'axa tiuyuri, 'uquiyarimama nusu 'axa mepüte'uyuri, 'acüpetü mutinuivaxücü. ");
INSERT INTO hchNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Quesusi müpaü niutayüni, 'Icü müpaü püca'ane 'axa mütiuyuricü, ni 'uquiyarimamata 'asimemüte'uyuricü müpaü püca'ane. Mümasiücürecü Cacaüyari que mütiyuriene hesiena püta cani'aneni. ");
INSERT INTO hchNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Caneuyeveca 'iya münesiheyenü'a que müti'uximaya, yanemütiyurienenicü ne 'uhecüacacu cuxi. Yüriya 'acanamieni quepaucua mücayüve müti'uximayaca. ");
INSERT INTO hchNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Quepaucua cuiepa nemuyeica, necanihecüariyatüni cuiepa memütama vahesie mieme. ");
INSERT INTO hchNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Müpaü 'utayüca niuta'aüsicavieni cuiepa. Haxu 'uhaviyaca yu'aüsicacü, hüxitana haxu neviriexüani. ");
INSERT INTO hchNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Müpaü tinitahüave, Quenemie, mana quenehütaimami ha mayema Siruhe müracutevasie, taniuquicü Mutanü'arie müracutevasie. Hicü neyani, nanacahütaima, heunieretü 'ayaca, nacunuani. ");
INSERT INTO hchNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Hicü 'auravatariri, mümeri meripai memixeiyacai rimusinavieneme, müpaü meniutiyuanecaitüni, 'Icü catihücü mana mutiyeixacai müticu'ivavacai. ");
INSERT INTO hchNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Hipatü mete'utiyuanecai, 'Eri, 'iya pühücü. Hipatüta mete'utiyuanecai, Tixaüsüari, hepaüna pütiyuxexeiya xeicüa. 'Iyasü müpaü nainecaitüni, Ne nepühücü. ");
INSERT INTO hchNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Hicüsü müpaü metenitahüave, Mericüte, que petiunieritüarie. ");
INSERT INTO hchNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","'Iya müpaü tivaruta'ei, Mücü tevi Quesusi mütiteva haxu 'uhaviyaca nehüxita canenaviriexüani. Müpaü netiutahüavixü, Siruhe quenemie quenehütaimamie. Neheyaca ne'anacahütaimaca nepanutanierixü. ");
INSERT INTO hchNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Müme metehehüave, Haqueri mücü. Hauqui, tiutayü. ");
INSERT INTO hchNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Mericüsü Pareseusixi vahesüa mecaneivitüni macüpecai. ");
INSERT INTO hchNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","'Uxipiya tucari nihücütücaitüni quepaucua Quesusi haxu muhaviyaxü menutanieritüa. ");
INSERT INTO hchNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","'Ayumieme tavari menita'ivaviya Pareseusixi que tiunierixü. 'Iya müpaü tivarutahüave, Haxu pünesi'aviriexüa nehüxita, nepanacahütaimaxü, hicü nepeuniere. ");
INSERT INTO hchNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Pareseusixi hipatü 'ayumieme müpaü meniutiyuanecaitüni, Xüari 'iya tevi Cacaüyarisüa pücamieme, 'uxipiya 'inüariyarisie yamücaticamiecü. Hipatü mete'utiyuanecai, Quepaü tiyüve tevi 'axa mütiyuriene 'inüari 'ipaü 'aneneme mütiyuriene. Hixüata mepuyusanaxüa. ");
INSERT INTO hchNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","'Ayumieme tavari müpaü metenitahüave macüpecai, Que pe'utaine 'ecü 'iya hepaüsita. Pümasi'anutanieritüa. 'Iya rainecai, Catinixaxatametüni. ");
INSERT INTO hchNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Hicü Huriyusixi yuri mepücate'uta'eri quename 'acüpecai 'anutanierixü, 'arique xeicüa yuri mepüte'uta'eri mevarutahüaveca manutanierixü 'uquiyarimama. ");
INSERT INTO hchNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","mevaruta'ivaviyaca müpaü me'utiyuatü, 'Icü tixenive, hepaüsitana xemutiyuane quename 'acüpetü 'utinuivaxü. Que yüanetü hicü peuniere. ");
INSERT INTO hchNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","'Uquiyarimama menivaruta'eiya yame'utiyuatü, Tame tepütemate 'icü tanive mühücü 'acüpetü mutinuivaxü. ");
INSERT INTO hchNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Masi hicü que yüanetü meuniere 'asitepücatemate. Quepai menutanieritüa 'asitepücatemate. Mücü xequeneuta'ivaviya. 'Ecaniuteviniri, yücümana caniyutaxatamücüri. ");
INSERT INTO hchNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","'Uquiyarimama müpaü meniutiyuanecaitüni Huriyusixi memüvamacarücaicü. Huriyusixi meyu'enieca müpaü meteniyücühüavecaitüni, quename xüca xevitü yutahecüatanique Cürisitusie tiviyatü, tuquita capitüarieniqueyu. ");
INSERT INTO hchNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","'Ayumieme 'uquiyarimama meniutiyuani, 'Ecaniuteviniri, xequeneuta'ivaviya mücü. ");
INSERT INTO hchNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Hicü hutarieca menitahüave tevi macüpecai. Müpaü metenitahüave, 'Aixüa queneutayüqui Cacaüyari hepaüsita. Tame tepütemate 'icü tevi 'axa mütiyuriene. ");
INSERT INTO hchNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Mücü müpaü tivaruta'ei, Me 'asinepücatimate xüca 'axa tiyurieneni. 'Icü xeicüa necatinimaica ne. 'Ana nepacüpecai, hicürixüa nepeuniere. ");
INSERT INTO hchNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Hicü müpaü metenitahüave, Que masi'uyuri. Que matiunieritüa. ");
INSERT INTO hchNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Müpaü tinivaruta'eiya, Meripai yanepütixe'utahüavixü, xepücaheu'enana. Que cuxi xete'enacu tavari. Xemeta teyü'üquitüvametemama xecate'acünicu. ");
INSERT INTO hchNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Müme 'axa mepüte'itahüavixü müpaü mete'icühüavetü, 'Ecüsü hesüana mieme tiyü'üquitüvame pepühücü. Tame Muisexisüa miemete teyü'üquitüvamete tepühüme. ");
INSERT INTO hchNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Tame tecatenimaica Cacaüyari mütitahüavixü Muisexi. 'Icü püta 'asitepücatemate haque memieme. ");
INSERT INTO hchNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Tevi müpaü tivaruta'ei, Camüte, 'icü pümarive. Xeme 'asixepücatemate haque memieme, peru pünesi'anutanieritüa ne. ");
INSERT INTO hchNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Tepütemate Cacaüyari mücava'enie 'axa memüteyurie. Masi xüca tevi Cacaüyari 'ayexeiyani, xüca yaticamieni tita mütinaque Cacaüyari, cani'eniecamücü 'iya. ");
INSERT INTO hchNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Sutüapai hicüque pücaxasiva quename tevi 'enutanieritüa que mü'ane 'acüpetü mutinuivaxü. ");
INSERT INTO hchNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Xüca 'icü Cacaüyarisüa camiemetünique, pücayüveniqueyu 'asimütiyurieni. ");
INSERT INTO hchNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Müme mete'ita'ei, Cari 'ecü 'axa petiyurienetü peputinuivaxü yemecü. 'Ecü que petati'üquitüa tame. Tacua mecanenuyehüani. ");
INSERT INTO hchNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Mericüsü caniu'ena Quesusi quename tacua mehenuyehüa. 'Itaxeiyaca müpaü niutayüni, 'Ecü yuri peti'erie que mü'ane Yuri Tevi mühücüsie. ");
INSERT INTO hchNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","'Iya tita'ei, Ti'aitame, que püpaicü yuri nemütita'erienicü hesiena. ");
INSERT INTO hchNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Quesusi titahüave, Pepixei. Que mü'ane 'ahamatü müticuxata, mücü necanihücütüni. ");
INSERT INTO hchNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","'Iya tiutayü, Yuri nepüti'erie, Ti'aitame 'acu. Nenevieri nipitüaniri. ");
INSERT INTO hchNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Quesusi müpaü niutayüni, Ne necaninuani 'ena cuiepa nemüvapatacü, memücaheuneniere memanutanenierenicü, memeuneniere me'acücüpetü memacünecü. ");
INSERT INTO hchNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Mericüsü Pareseusixi hipatü hamatüana memu'uvacai 'icü meniu'enieni. Müpaü metenitahüave, Tamerita tete'acücüpe. ");
INSERT INTO hchNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Quesusi müpaü tivarahüave, Xüca xe'acücüpenique, mücücü xehesie pücarahüivaniqueyu. Masi hicü müpaü xeputiyuane quename xeheuneniere. 'Ayumieme 'apuve xehesie que mürahüiva. ");
INSERT INTO hchNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Niuqui caniseüyeni que nemütixecühüave, que mü'ane quitenie mücaheutahani muxasi vacuraruta, huteicü püta meutimaque, mücü tinavayame canihücütüni catininavamücü. ");
INSERT INTO hchNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Que mü'ane quitenie meutahani, muxasi canivahüvemetüni. ");
INSERT INTO hchNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","'Iparevivame quitenie catineuyepivani hesiena mieme. Muxasi mecanimaica niuquieyasie. Yuxexuime püvarahüave yumuxasi que memüteteteva, nivaranuyevitüni. ");
INSERT INTO hchNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Quepaucua yumuxasi yunaime müvaranuyevitü, mücü varanuhaitüiyatü caniumieni. Muxasi 'utümana mecaniveiyani niuquieyasie memimatecü. ");
INSERT INTO hchNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Cuyeicame mepüca'anucuveiya, meniyuta'unacuni püta cu'uvamete vaniuquisie memücavamatecü. ");
INSERT INTO hchNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Quesusi 'icü 'üquisica xatatü müpaü tinivacuxaxatüvacaitüni. Müme 'asimepücatehetima tita mütihücütücai mütivacuxaxatüvacai. ");
INSERT INTO hchNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","'Ayumieme tavari müpaü niutayüni Quesusi, Niuqui caniseüyeni que nemütixecühüave, ne muxasi necanivaquitenietüni. ");
INSERT INTO hchNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Yunaitü memu'axüa necanuavecacu cuxi ne, tenavayamete mecanihümetüni, menivanavatüveni. Muxasi mepücavaru'eni masi. ");
INSERT INTO hchNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ne necaniquitenietüni. Necümana xüca tevi heutahani, nitavicueisitüariemücü. Neutahamücü nivayeyeicamücü, macusiüraüye netamariecaxüamücü. ");
INSERT INTO hchNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Tinavayame vanavamütü vacuimütü vata'unamütü xeicüa cani'axeni. Ne püta necaninuani tucari memexeiyanicü, 'anuyuhayevame memexeiyanicü. ");
INSERT INTO hchNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ne ti'üviyame 'aixüa nemütiuca'iyari necanihücütüni. Ti'üviyame 'aixüa mütiuca'iyari yutucari niyetuani muxasi vahesie mieme. ");
INSERT INTO hchNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ti'ivame, que mü'ane mücavahüveme, muxasi mücavacusiyari, mücü canixeiyani 'ürave 'a'amieme. Mücü muxasi nivacu'e'eirivani niyuta'unani. 'Ürave nivativiyamücü nivataxüriexüamücü. ");
INSERT INTO hchNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","'Iya müti'ivamecü xeicüa pücayucuerivayurie muxasi vahepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Ne necatini'üviyametüni 'aixüa nemütiuca'iyari. Nemuxasima nepüvamate, mümeta menetemate nemuxasi, ");
INSERT INTO hchNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","yaxeicüa ne'uquiyari münetimatepaü, ne nemimatepaü ne'uquiyari. Netucari necaniyetuani muxasi vahesie mieme. ");
INSERT INTO hchNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Hipameta muxasi nepüvarexeiya 'icü xei curaruyarita memücamiemete. Neuyeveca nemüva'atüani mümeta. Neniuqui mecani'eniecuni. Xeime mehexeiyatü ti'üviyame, xei curaruyari mehexeiyatü mecanacünicuni. ");
INSERT INTO hchNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","'Ayumieme ne'uquiyari caneninaqui'erieca netucari nemüyetuacü tavari nemitanaqui'erienicü. ");
INSERT INTO hchNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Xevitü pücanesinavairieni, necümana püta necaniyetuamücü. Heiserie necanexeiyani nemiyetuanicü, heiserie nerexeiyata tavari nemitanaqui'erienicü. 'Ipaü ne'uquiyari canetiniu'aitüani. ");
INSERT INTO hchNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Mericüsü tavari hixüata meniyusana Huriyusixi 'icü niuquieyacü. ");
INSERT INTO hchNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Yumüiretü müme müpaü meniutiyuanecaitüni, Cari cacaüyari 'axa mü'ane caninüca 'iya, pücayumate. Titayari xete'i'enie. ");
INSERT INTO hchNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Hipatüta mete'utiyuanecai, 'Icü niuquieya, cacaüyari 'axa mü'ane minü'ü capüniuquieya. Cacaüyari 'axa mü'ane que tiyüve müvaranutanieritüani memacücüpe. ");
INSERT INTO hchNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Mericüsü 'ana 'ixüarari naye'ani quepaucua hehecuame memayeitüvacai Querusaremesie. Niuhaütücaitüni. ");
INSERT INTO hchNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Quesusi tuqui curaruyarita niyeyeicacaitüni Sarumuni 'etüpivarieyatüa. ");
INSERT INTO hchNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Hicü Huriyusixi 'auriena meniyucuxeürieni. Müpaü metenitahüave, Quepaümexa pepütasi'iyaritüaca. 'Ecü xüca pecürisitutüni, heiseriemecü quetatineutaxatüa. ");
INSERT INTO hchNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Quesusi tivaruta'ei, Yanepütixe'utahüavixüri, haquevasü yuri xepücate'erie. 'Icü tita nemütiyuriene ne'uquiyarisüa nemiemetütü, mücü nehepaüsita catinihecüatani. ");
INSERT INTO hchNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Masi yuri xepücate'erie, nemuxasi vahesie xemücamiemetecü, que nemütixecuxaxatüvacai. ");
INSERT INTO hchNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Nemuxasi mepünesi'enie, neta nepüvamate, mecaneniuveiyani. ");
INSERT INTO hchNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Tucari mücaxüve nenivapitüaca. Hasuacuari mepücata'unarieni. Xevitü pücavativiya nesinavairienique nemamasie. ");
INSERT INTO hchNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ne'uquiyari müme münesiyetuiri, mücü yemecü canitürücaüyeni, hipatü yunaitü mecatürücavicacu. Xevitü pücayüve müvativiya 'inavairienique ne'uquiyari mamayasie. ");
INSERT INTO hchNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ne ne'uquiyarimatü tenitaxevini. ");
INSERT INTO hchNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Hicü Huriyusixi tavari tetexi meniutitücü me'ituaxaque. ");
INSERT INTO hchNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Quesusi müpaü tinivarutahüave, Camü vaüca nepüxe'uxeisitüa 'uximayasica 'aixüa mü'anene ne'uquiyarisüa mümieme. Que 'aneme 'uximayasicacü xepünesituaxa. ");
INSERT INTO hchNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Huriyusixi müpaü mete'ita'ei, 'Uximayasica 'aixüa mü'anecü tepücamasituaxa, 'axa pemutainecü püta tepümasituaxa. 'Ecü tevi pehücütütü cacaüyari pena'ayeitüvani. ");
INSERT INTO hchNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Quesusi müpaü tivaruta'ei, Camü 'ipaü care'uxa xe'inüari niuquiyarisie, Ne xemücacaüyarixi neputayü. ");
INSERT INTO hchNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Xücari cacaüyarixi varutaterüva müme vahesüa munua Cacaüyari niuquieya, xücari 'utüarica cayüveni mayeyeitüarieni, ");
INSERT INTO hchNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","'iya ne'uquiyari mipataxü yuhesie mieme, cuiepa meiyenü'a, quename 'axa 'utaine queri xe'utiyuane hepaüsitana, müpaü nemutayücü, Cacaüyari necaninu'ayatüni. ");
INSERT INTO hchNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Xüca yanecatiyurieneni ne'uquiyari que mütiyuriene, yuri xepücaneteta'eririeni. ");
INSERT INTO hchNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Me xüca yanetiyurieneni, sepa yuri xemücanete'eririe ne, tita nemütiyurienesie püta yuri xequetene'erieca müpaü xemütetimanicü quename ne'uquiyari nehesie tiviya, neta ne'uquiyarisie netiviya. ");
INSERT INTO hchNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Hicü tavari menicuvautüvecaitüni me'iviyaque. Mücü neyani meca'iviyavecacu. ");
INSERT INTO hchNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Mericüsü mana neyani tavari Curutani 'anutaüye haque Vani meripai müti'üyanecai. Mana niyuhayeva. ");
INSERT INTO hchNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Yumüiretü hesüana meni'axecaitüni. Müpaü meniutiyuanecaitüni, Vani 'inüari pücatiuyuri. Naime que müticuxatacai Vani 'icü tevi hepaüsita, yuri canainecaitüni. ");
INSERT INTO hchNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Mana yumüiretü yuri meteniuta'erieni hesiena. ");
INSERT INTO hchNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Mericüsü tevi catinecuyecaitüni Rasaru titevatü, Vetaniya mecatei, Mariya quiecariena Maritata Mariya mü'ivayatücai quiecariena quiecametütü. ");
INSERT INTO hchNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","'Iya Mariya canihücütücaitüni que mü'ane Ti'aitame mucaviri visi mu'üacü, quetateya mucavasiüxaxü yücüpacü. 'Iya 'ivaya Rasaru recuyecai. ");
INSERT INTO hchNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Hicü 'ivamama 'ucari niuqui mecaneitanü'airieni Quesusi yame'utiyuatü, Ti'aitame neuxei, 'iya que mü'ane peminaqui'eri tinicuyeni. ");
INSERT INTO hchNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Quesusi 'u'enaca müpaü niutayüni, 'Icü cuiniya mümünicü püca'ayumieme. Masi Cacaüyari visi 'anetü mayeitüarienicü pühücü, Cacaüyari Nu'aya visi 'anetü mayeitüarienicü mücü cuiniyacü. ");
INSERT INTO hchNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Quesusi nivanaqui'eriecaitüni Marita 'ivayata Rasaruta. ");
INSERT INTO hchNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","'Ayumieme quepaucua mu'enaxü quename recuyecai, mana niyuhayeva huta tucari haque meyeicacai. ");
INSERT INTO hchNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","'Ana müpaü tinivarutahüave teyü'üquitüvamete 'ariquemüca, Cümü tavari Cureya tepuhu. ");
INSERT INTO hchNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Teyü'üquitüvamete müpaü mete'icühüave, Ti'üquitame, xique Huriyusixi mepümasicuvautüvecai memasituaxaque. Tavari petimie 'uma. ");
INSERT INTO hchNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Quesusi müpaü tivaruta'ei, Camü tamamata heimana huta hurayari carexeiya xei tucari. Xüca hecüaripa 'uyeicani tevi, püca'uti'ücamüre, 'ena cuiepa mieme hecüariya müxeiyacü. ");
INSERT INTO hchNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Xüca yüvipa 'uyeicani pütiquetamüre hecüariya mümavecü hesiena. ");
INSERT INTO hchNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Müpaü niutayüni. 'Arique müpaü tinivarutahüave, 'Iya teminaqui'eri Rasaru canecusuni. Ne nepümie nemenutahütüanicü. ");
INSERT INTO hchNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Teyü'üquitüvamete müpaü mete'itahüave, Ti'aitame, camü xüca hecusuni pütavicueisitüarieni. ");
INSERT INTO hchNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Quesusi müpaü putayü memücü. Müme cusutü me'uxipi haineme mepü'eriecai. ");
INSERT INTO hchNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Hicü 'ayumieme Quesusi müpaü tinivarutahüave heiseriemecü, Pemü Rasaru. ");
INSERT INTO hchNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Mana nemücaheyeicacaicü ne'iyari 'aixüa puyü xehesie mieme, yuri xemüteta'erienicü. Masi tepuhu hesüana. ");
INSERT INTO hchNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Hicü Tumaxi Vavari mütitevacai müpaü tinivarutahüave hipame teyü'üquitüvamete, Cümüri tepuhu hamatüana temecuinicü tametari. ");
INSERT INTO hchNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Mericüsü Quesusi henuaca müpaü tiniutimarieni quename Rasaru nauca tucari yuriecairi teuquiyapa yecaitü. ");
INSERT INTO hchNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Vetaniya Querusareme nehuracaitüni, haica quirumetüruyari xeicüa petevacai. ");
INSERT INTO hchNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Huriyusixi yumüiretü meniu'axüani Marita Mariya vahesüa memüvanütüanicü va'iva hepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Hicü Marita quepaucua mütiutamari quename Quesusi nuaximecai, neicunaque. Mariyari quita nayecateitüni. ");
INSERT INTO hchNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Hicü Marita müpaü tinitahüave Quesusi, Ti'aitame, xüca 'ena pe'uyeicanique, ne'iva pücamüniqueyu. ");
INSERT INTO hchNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Hicürita nepütimate nai pemütitavavirieni Cacaüyari, Cacaüyari pümasipitüani. ");
INSERT INTO hchNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Quesusi müpaü titahüave, 'A'iva nanucuquemücü. ");
INSERT INTO hchNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marita müpaü titahüave, Ne nepütimate manucuqueni tucari 'aye'ayu quepaucua mütapare, quepaucua memanucu'uni. ");
INSERT INTO hchNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Quesusi müpaü titahüave, Ne necanihücütüni va'uitüvame, tucari netihücüta. Que mü'ane nehesie yuri müti'erie, sepa mümüqui, canayeyuricamücü. ");
INSERT INTO hchNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Yunaitü memayeyuyuri, nehesie yuri memüte'erie, hasuacuari mepücacuini. 'Ipaü yuri peti'erie 'ecü. ");
INSERT INTO hchNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Müpaü titahüave, Hü Ti'aitame. Ne yuri necatini'erieca 'ecü pemücürisitu, 'ecü Cacaüyari Nu'aya cuiepa 'umamie pemühücü. ");
INSERT INTO hchNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Müpaü 'utayüca neyani. Yühücüate me'ayetecacu nitahüave yu'iva Mariya, müpaü tinitahüave 'avie, Ti'üquitame caninuani. Pümasitahüave. ");
INSERT INTO hchNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mücü 'u'enaca cuitüva nanucuqueni, hesüana neyani. ");
INSERT INTO hchNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Quesusi quiecarisie pücanuavecai. Manari cuxi niutivecaitüni Marita menucunaquixüsie. ");
INSERT INTO hchNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Hicü Huriyusixi Mariyamatü memayetecai quita, meminütüacai, me'ixeiyaca Mariya cuitüva 'anucuquecu heyacu, mecaneiveiya, teuquiyapa metüa mana tasuanique metecu'erivatü. ");
INSERT INTO hchNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Hicü Mariya quepaucua munua Quesusi manutivecaisie, 'ixeiyaca, hetüana niutitunumaqueni müpaü ticühüavetü, Ti'aitame xüca 'ena pe'uyeicanique ne'iva pücamüniqueyu. ");
INSERT INTO hchNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Quesusi quepaucua mixei 'iya 'utasuacame Huriyusixi hamatüana memu'axüa me'utisuaname, yu'iyarisie niyumuinanecaitüni, niyu'uximatüacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Müpaü niutayüni, Haque xepeicateuquixü. Müpaü mete'itahüave, Ti'aitame quenaye'a queneuxeiya. ");
INSERT INTO hchNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Quesusi niutasuani. ");
INSERT INTO hchNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Huriyusixi 'ayumieme müpaü meniutiyuanecaitüni, Neuxei que tinaqui'eriecai. ");
INSERT INTO hchNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Hipatü müme mete'utiyuane, 'Icü menutanieritüa macüpe, catiyüveniqueyu mipitüanicü 'icüta mücamünicü. ");
INSERT INTO hchNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Hicü Quesusiri tavari yumuinatü yu'iyarisie teuquiyapa ninuani. Mücü caniterütücaitüni, tetecü tineunacaitüni quitenie. ");
INSERT INTO hchNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Quesusi müpaü niutayüni, Xequeneuhüva tete. Müqui 'ivaya Marita müpaü titahüave, Ti'aitame, pucuri'üari. ");
INSERT INTO hchNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Quesusi müpaü titahüave, Müpaü necamatiutahüavixü, xüca yuri petita'erieni pecanixeiyamücü que mütimarive Cacaüyari. ");
INSERT INTO hchNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Hicü tete mecaneuhüani. Quesusi heutiniereca müpaü niutayüni, Ne'uquiyari, pamüpariyusi necamanipitüaca pemünesi'u'enicü. ");
INSERT INTO hchNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nesü nepütimaicai 'aheyemecü pemünesi'enie, masi teüteri ne'aurie memüti'u vahesie mieme, müpaü neputayü, yuri memüteta'erienicü quename penesiheyenü'a 'ecü. ");
INSERT INTO hchNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Müpaü 'utayüca carima niutahiva, Rasaru, quenevayeye'a haitü. ");
INSERT INTO hchNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Mümüquicai nivayeyani 'ixuriquitecü 'eimetü quetateyasie mamateyasie. Hüxiena panucuhüacai tuvaxacü. Quesusi müpaü tinivarutahüave, Xequeneuxüna. Xequeneupitüa müyemiecü. ");
INSERT INTO hchNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Hicü Huriyusixi yumüiretü Mariyasüa memu'axüa memunenierixü que mütiuyuri, yuri mecateniuta'erieni hesiena. ");
INSERT INTO hchNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Masi hipatü müme Pareseusixi vahesüa menecüne. Metenivaretaxatüani que mütiuyuri Quesusi. ");
INSERT INTO hchNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","'Ayumieme mara'acate memühüritüariecai Pareseusixi vahamatü meniyucuxeürieni meyu'enienique. Müpaü meteniyutahüave, Quesü teteyurieni. 'Icü tevi vaüca 'inüari tiniyurieneni. ");
INSERT INTO hchNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Xüca te'ipitüaca müpaü mütiyurieneni, yunaitü yuri mecatenita'ericuni hesiena. 'Anari Xumatari meni'axüacuni, mepütasinavairieni 'icü 'ena, tateüterima mepütasinavairienita. ");
INSERT INTO hchNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Xevitü müme Caipasi mütitevacai, mara'acametütü mühüritüariecai mücü viyarisie, müpaü tinivarutahüave, Xeme 'asixepücatemate. ");
INSERT INTO hchNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Müpaü xepücatehetimaivave masi 'aixüa müyünicü tahesie mieme, xevitü tevi mümünicü teüteri vahesie mieme, capa meheuyevenicü tateüterima. ");
INSERT INTO hchNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Müpaü püca'utayü yücümana. 'Iya viyarisie mara'acame mühüritüarie mühücütücaicü yacatinicuxatacaitüni quename Quesusi vateüterima vahesie mieme müniquecai. ");
INSERT INTO hchNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","'Iya vateüterima vahesie mieme xeicüa pücamüniquecai, masi pümüniquecai müvacuxeürienicü Cacaüyari nivemama memeutaxüriexüa memüyutaxevirecü. ");
INSERT INTO hchNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Hicü 'iya tucarisie menisutüani meyu'enietü memimienicü. ");
INSERT INTO hchNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Hicürita Quesusi teüteri vahürüpa püca'uyeicacairi Huriyusixi vasata. 'Iya cuieyarisie püta macumave 'aurie neyani, quiecari 'Epüraini müracutevasie. Mana niyuhayeva teyü'üquitüvamete vahamatü. ");
INSERT INTO hchNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Mericüsü Huriyusixi va'ixüarari Pasicua mütiteva nahuracaitüni. Yumüiretü 'esimüyeyeusie quiecatari menecüne Querusareme 'ixüarari casutüarievecacu cuxi memüyu'itienicü. ");
INSERT INTO hchNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Menicuvautüvecaitüni Quesusi. Tuqui curaruyarita me'aye'utü müpaü meteniyücühüavecaitüni, Que xetecu'eriva, xüca ha'ixüaramieni 'iya. ");
INSERT INTO hchNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Mara'acate memühüritüariecai Pareseusixi vahamatü müpaü mecateniu'aita, xüca tevi retimanique haque meyeicacai, mitahecüataniquecai memiviyacü. ");
INSERT INTO hchNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Hicü 'ataxeime tucari heuyevecacu Pasicua maye'anicü, Quesusi Vetaniya ninuani haque Rasaru manucatei, Quesusi menucuquetüa müquite vasata. ");
INSERT INTO hchNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Hicü mana menivarucuxeürieni hamatüana memütecuanicü. Marita nivapareviecaitüni. Hamatüana mematecai, xevitü Rasaru canihücütücaitüni. ");
INSERT INTO hchNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Hicü Mariya naru visi mu'üa canücame vaüca müraye'axe ne'üni, merie quiruyaripaü paümeme. Quesusi quetayasie nicavirieni. Quetaya niucavasiüxa yücüpacü. Naisari quita visi tiniuye'üacaitüni narucü. ");
INSERT INTO hchNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Hicü teyü'üquitüvametemama xevitü, Cura 'Isicariutitanaca, miyetuaniquecai, müpaü niutayüni, ");
INSERT INTO hchNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Titayariri catiutuiya 'icü visi mu'üa haica sienituyari 'inüariyaricü, müva'üitüanicü memümamave. ");
INSERT INTO hchNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Müpaü niutayüni memümamave müvara'erivacaicü pücatixaü, masi mütinavayametücaicü püta müpaü tiutayü. 'Iya vatumini maname 'ahanatü, tita hesiena mütiucaxüri nivati'üvecaitüni. ");
INSERT INTO hchNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Quesusi müpaü niutayüni, Quetineuhayeva. 'Ipaü catiniuyurieni neteuquiya tucarisie mieme maye'aximecü. ");
INSERT INTO hchNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Yuheyemecü yuhesüa xecanivarexeiyani memümamave. Ne püta xepücanesihexeiya yuheyemecü. ");
INSERT INTO hchNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Hicü Huriyusixi yumüiretü meteniutamarieni quename muva hayecatei. Quesusicü xeicüa mepüca'axecai, Rasaruta mexeiyaque müquite vasata menucuquetüacü meni'axecaitüni. ");
INSERT INTO hchNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Hicü mara'acate memühüritüariecai meyu'enieca 'axeicüa meniutiyuani quename Rasaruta memieniquecai ");
INSERT INTO hchNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","yumüiretü Huriyusixi cümana memecücü, Quesusisie yuri memüte'uta'ericü. ");
INSERT INTO hchNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Mericüsü 'uxa'arieca yumüiretü teüteri 'ixüaramete meniu'enanani quename Quesusi 'uhamiecai Querusareme. ");
INSERT INTO hchNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Parapa mamateya me'uhapatü menecüne meheinaquiyuca. Müpaü meteniuhivacaitüni, Quetaneutavicueisitüa 'aixüa. 'Aixüa queticühüavarüvani Que mü'ane Ti'aitamesüa miemetütü 'umamie hepaüsita 'Ixaherisixi tati'aitüvame hepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Hicü Quesusi puxu 'utaxeiyaca hesiena nanutiyerüni, que müre'uxa, ");
INSERT INTO hchNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Siyuni quiecame nu'aya, pepücaheumaca. Camü 'iya mümati'aitüa 'ucanamieni Puxu nunusisie 'acaitü. ");
INSERT INTO hchNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Teyü'üquitüvametemama 'icü mepücahetimaivavecai meripai. Quepaucuari visi 'anetü matüa Quesusi, 'anaque mecanaye'erieni müpaü müre'uxa hepaüsitana, müpaü memiyuri. ");
INSERT INTO hchNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Mücü teüteri hamatüana meme'uvacai quepaucua mitahüavixü Rasaru müvayeyanicü teuquiyata, quepaucua menucuquetüa müquite vasata, mümerita mecanihecüatacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","'Ayumieme teüteri meneinaquiyuni memu'enanacü quename 'icü 'inüari tiuyuri. ");
INSERT INTO hchNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Hicü Pareseusixi müpaü meteniyücühüavecaitüni, Xepüneniere 'asixemücayüvave. Camü yunaitü cuiepa memütama 'utümana menecüne. ");
INSERT INTO hchNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Mericüsü teüteri memu'axüa 'ixüararipa meyutanenevienique, hipatü müme mecanicüriyecusixitücaitüni. ");
INSERT INTO hchNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Müme Piripesüa meniu'axüani Vesairasie Carereya cuieyarisie mecateisüa. Mecanita'ivaviya yame'utiyuatü, Neuxei, Quesusi tepüxeiyaqueyu. ");
INSERT INTO hchNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Piripe neyani. Nitahüave 'Atürexi. Hicü 'Atürexi Piripematü menecüne. Müme menitahüave Quesusi. ");
INSERT INTO hchNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Quesusi nivaruta'eiya ya'utaitü, Tucari naye'aniri Yuri Tevi nehücütütü visi ne'anetü nemayanicü. ");
INSERT INTO hchNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Niuqui caniseüyeni que nemütixecühüave, xüca türicu 'imüariyari ca'ucateuquiyani cuiepa 'ucaveca, yuxaüta niyuhayeva xeicüa. Mesü xüca 'ucateuquiyani, vaüca canititacaimücü. ");
INSERT INTO hchNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Que mü'ane yutucari münaqui'eri canitatümaiyamücü. Que mü'ane 'ena cuiepa yutucari mü'uxive'erie, yuheyemecü caneixeiyacamücü, pücaxüveni. ");
INSERT INTO hchNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Xüca tevi nesiparevivame yüaneni, quenesiheveiya ne. Haque nemeyeicani, manarita caniuyeicamücü nesiparevivame. Xüca tevi nesiparevivame yüaneni, ne'uquiyari 'aye'ame ni'eriecamücü 'iya. ");
INSERT INTO hchNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Hicüri ne'iyari niyumuinaneni. Queri ne'utaineni. Ne'uquiyari, queneneutavicueisitüa 'icü tucarisie que nehaineniqueyu. Masi 'icü 'ayumieme necaninuani 'ena cuiepa. ");
INSERT INTO hchNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ne'uquiyari, visi peticühüavarüvatü quena'ayeitüa. Hicü xevitü niutaniuni taheima müpaü 'utaitü, Neri visi neticühüavarüvatü nepaneyeitüave, tavarita müpaü necatiniyuriemücü. ");
INSERT INTO hchNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Teüteri yumüiretü mana memüti'ucai memu'enana müpaü meniutiyuanecaitüni, Camü necutürarücani. Hipatüta mete'utiyuanecai, Xüari niuqui tuayame pitahüavixüri. ");
INSERT INTO hchNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Quesusiri müpaü tinivaruta'eiya, 'Iya nehesie mieme püca'utaniu, xehesie mieme püta putaniu. ");
INSERT INTO hchNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Hicürixüa 'ena cuiepa memütama nivatahüavimücü 'isücame. Hicürixüa 'iya mütiva'aitüva cuiepa memütama tacua nanuyehüiyamücüri. ");
INSERT INTO hchNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ne xüca cuie heima ne'anucuhanieni, yunaime necanivarahapamücü nehepa. ");
INSERT INTO hchNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Müpaü niutainecaitüni tihecüatatü que mütimierieniquecai. ");
INSERT INTO hchNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Teüteri 'ayumieme müpaü metenita'eiya, Tame 'inüari niuquiyaricü tecaniu'ena quename 'iya Cürisitu yuheyemecü yuhayeva. Que pehaine meuyevese Yuri Tevi manucuhanienicü pemaine. Que püpaicü 'icü Yuri Tevi mütiteva. ");
INSERT INTO hchNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Quesusiri 'ayumieme müpaü tinivarutahüave, Yareutevitü cuxi xeicüa hecüariya xesata caniuyeicamücü. Mexi hecüariya xehexeiya xequeneu'uvani, yüriya capa xeha'ivacü. Que mü'ane yüvipa muyeica 'asipücatimate que mütimie. ");
INSERT INTO hchNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Mexi hecüariya xehexeiya, yuri xequetene'erieca hecüariyasie, hecüaripa miemete xemacünecü. Müpaü tinicuxatacaitüni Quesusi. 'Arique heyaca niyuti'avieta memücaheitaxeiyacü. ");
INSERT INTO hchNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Sepasü müya paümeme 'inüari mütiyurienecai vahüxie, yuri mecacateni'eriecaitüni hesiena. ");
INSERT INTO hchNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Müpaü catinaye'ani Quisariyaxi tixaxatame niuquieya müpaü mutayücü, Ti'aitame quepai yuri pütita'eriri taniuqui. Quepai püxeisitüarie Ti'aitame türücariyaya. ");
INSERT INTO hchNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","'Ayumieme mepücayüvavecai yuri memüteta'erienicü, tavari müpaü mutayücü Quisariyaxi, ");
INSERT INTO hchNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Nivaracüpiriya vahüxita, Nivaruseiriya va'iyarisie, Capa yuhüxicü meheunenierenicü, Capa yu'iyarisie meteyücühüavenicü, Capa ta'aurie me'axürienicü nemüvaranayexürienicü. ");
INSERT INTO hchNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Müpaü niutayüni Quisariyaxi quepaucua mixei visi que mü'anecai, quepaucua hepaüsitana müticuxatacai. ");
INSERT INTO hchNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Siepüresü hipatü teüteri va'uquiyarima yumüiretü yuri mecateniuta'erieni hesiena. Pareseusixi vacü mepücayuhecüatacai capa tuquita me'anuyeveiyarienicü. ");
INSERT INTO hchNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Vaüca nivanaquecaitüni teüteri 'aixüa memütevacühüavenicü, 'esiva xeicüa vanaquecacu Cacaüyari püta 'aixüa mütivacühüavenicü. ");
INSERT INTO hchNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Hicü Quesusi müpaü tiniuhiva, Que mü'ane nehesie yuri müti'erie, nehesie xeicüa yuri pücati'erie. Masi que mü'ane münesiheyenü'asie yuri tini'erieca. ");
INSERT INTO hchNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Que mü'ane münesixeiya, canixeiyani 'iya münesiheyenü'a. ");
INSERT INTO hchNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ne nehecüariyatütü cuiepa necaninuani yunaitü yuri memüte'erie nehesie yüvipa memücayuhayevacü. ");
INSERT INTO hchNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Xüca tevi 'icü 'u'enieni que nemüticuxata, xüca yacaticamieni, ne nepüca'ixaneta. Cuiepa memütama nevataxanetaque nepücanua, cuiepa memütama nevatavicueisitüanique püta necaninuani. ");
INSERT INTO hchNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Que mü'ane münesixani'eri, neniuqui müca'utanaqui'eri, caneixeiyani que mü'ane mixaneta. Mücü neniuqui que nemutayü, mücü canitaxanetamücü, tucari 'aye'ayu quepaucua mütapare. ");
INSERT INTO hchNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ne necümana 'asinepücaticuxata. Masi 'iya münesiheyenü'a ne'uquiyaritütü, canetiniuta'aitüani que nemutaineni que nemüticuxatani. ");
INSERT INTO hchNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ne necatinimaica tita müti'aita 'iya, tucari mücaxüve mühücücü. Tita nemüticuxata ne, ne'uquiyari que münetiutahüavixü, müpaü necatinicuxatani. ");
INSERT INTO hchNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Mericüsü Pasicua 'ixüarari pücasutüarievecai cuxi. Quesusi catinimaicaitüni tucarieya maye'a müyupatacü 'ena cuiepa müyemiecü yu'uquiyarisüa. Yuhesüa miemete cuiepa memütama que mütivanaqui'eriecai, 'aye'arücamecü nivanaqui'eriecaitüni. ");
INSERT INTO hchNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Hicüsüari metenicuacaitüni. Cauyumarieri müpaü tini'iyaritüani Cura 'Isicariutitanaca Simuni nu'aya miyetuanicü Quesusi. ");
INSERT INTO hchNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Mericüsü Quesusi müpaü tinimaicaitüni 'uquiyarieya nai mütiyetuiri mamayasie. Cacaüyarisüa meyetüacü timaitü, Cacaüyarisüa müyemiecü timaitü, ");
INSERT INTO hchNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","nanucuqueni mexa 'aurie macatei. Herie mieme yu'ixuriqui 'anutihünaca vasiüxame 'anuhurieca nayühüani. ");
INSERT INTO hchNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ha 'acatuaca pateyusie, nisutüani vahauxinatü teyü'üquitüvamete vaquetasie, vacavasiüxatü vasiüxamecü cümana mayühüacü. ");
INSERT INTO hchNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Hicü Simuni Pecuru manucatei ninuani. Mücü tinitahüave, Ti'aitame, 'ecü penetihauxina nequetasie. ");
INSERT INTO hchNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Quesusi müpaü tita'ei, Ne tita nemütiyuriene 'asipepücatimate hicü, 'ariquemücaque pecaneitimaimücü. ");
INSERT INTO hchNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pecuru rehüave, Hasuacuari pepücanesihauxinani nequetasie. Quesusi müpaü tita'ei, Xüca necamasihauxinani, 'ahesie pücatinaqueni nehepaü. ");
INSERT INTO hchNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simuni Pecuru müpaü titahüave, Ti'aitame, nequetasie xeicüa pepücanesihauxinani, masi nemamasieta nemu'usieta cuerietü. ");
INSERT INTO hchNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Quesusi müpaü ticühüave, Que mü'ane mecu'üvaxü pücaheiyehüva hauxinarica, yuquetasie xeicüa. Masi naitü caneu'itiyaca. Xemerita xecani'itiyatücani, peru yunaitü pücatixaü. ");
INSERT INTO hchNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Mücüri canimaicaitüni quepai miyetuaniquecai. 'Ayumieme yunaitü xemüca'itiyatüca niutayüni. ");
INSERT INTO hchNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Vaquetasie varuhauxica, yu'ixuriqui herie mieme 'anacatüca, mana 'ayerüca, hutarieca müpaü tinivarutahüave, Xetemate tita nemütiuyuri xehesie mieme. ");
INSERT INTO hchNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Xeme Ti'üquitame Ti'aitame xepünete'uterüva. 'Aixüa xepaitüca nemühücücü. ");
INSERT INTO hchNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Mericüte, ne Ti'üquitame Ti'aitame nehücütütü xüca xequetasie nexe'uhauxini, caneuyeveca xemeta yunaitü xemüyutihauxinani yuquetasie. ");
INSERT INTO hchNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Xemünesi'üquenicü 'inüari necanixe'upitüani xemeta müpaü xemüteyuriecacü nemüxe'uyuripaü. ");
INSERT INTO hchNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Niuqui caniseüyeni que nemütixecühüave, que mü'ane vaüriyarica müti'uximaya pücahe'iva yucusiyari cui ve'emetütü, 'iya cave'emetücacu. Nü'ari pücahe'iva que mü'ane meiyenü'a cui ve'emetütü, 'iya cave'emetücacu. ");
INSERT INTO hchNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Xüca 'ipaü xetemaica, xecaniyutemamaviecacuni xüca yaxetecahuni. ");
INSERT INTO hchNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Yunaime xehepaüsita nepücaticuxata. Ne nepüxemate quehate nemüxe'anuyexei. Masi müpaü netiniuyurieni 'utüarica maye'anicü müpaü maine, 'Iya ne'icuai mücuacai yuquepusacü pünesi'uquesi. ");
INSERT INTO hchNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Hicüri necatinixetaxatüamücü yacatiyüvecacu cuxi, yuri xemüteta'erienicü quename ne nehücü quepaucua müpaü mütiyüni. ");
INSERT INTO hchNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Niuqui caniseüyeni que nemütixecühüave, que mü'ane mitanaqui'erie que mü'ane nemanunü'ani, mücü caneniutanaqui'erieni ne. Que mü'ane münesi'utanaqui'erie ne, 'iya münesiheyenü'a caniutanaqui'erienita. ");
INSERT INTO hchNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Müpaü 'utayüca Quesusi niyumuinanecaitüni yu'iyarisie. Tiniutahecüata, müpaü niutayüni, Niuqui caniseüyeni que nemütixecühüave, xevitü xeme caneniyetuamücü. ");
INSERT INTO hchNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Teyü'üquitüvamete meniuyuxexeiyacaitüni me'iyarixietü 'asimecatemaitü quepai müraxatacai. ");
INSERT INTO hchNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Xevitü tiyü'üquitüvame Quesusi 'aurie niucateitüni Quesusi minaqui'eriecai. ");
INSERT INTO hchNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simuni Pecuru 'ayumieme nitamaviya. Müpaü titahüave, Quepai pepüraxata quetineutahüavi. ");
INSERT INTO hchNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Mücü Quesusi 'aurie 'ucaitü ta'aurie 'aveca müpaü tinitahüave, Ti'aitame, quepai pühücü. ");
INSERT INTO hchNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Quesusi müpaü tinita'eiya, 'Iya canihücütüni pa tarimeyari nemi'üitüani ne'itihaviyame xacüsie. Hicü pa 'utihaviyaca nenucu'üni, ni'üitüani Cura 'Isicariutitanaca Simuni nu'aya. ");
INSERT INTO hchNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Pa 'anu'ücu, 'ana Cauyumarie caniviya mücü. Quesusi müpaü tinitahüave, Que pemütiyurieni, xeiya quetineuyuri. ");
INSERT INTO hchNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Müme mana mematecai ni xevitü 'asimepücatemaicai titayari mürehüavecai. ");
INSERT INTO hchNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Cura vatumini maname mahanacaicü, hipatü müpaü metenicu'erivacaitüni Quesusi mütitahüavixücü, Tita temüteuyehüva 'ixüararipa quetinenanaimie, tumini müva'üitüaniquecai memümamave nusu metecu'erivacai. ");
INSERT INTO hchNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Cura pa 'anu'üca caneyani. Niuyüvicaitüni. ");
INSERT INTO hchNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Mericüsü quepaucua metüa, müpaü niutayüni Quesusi, Hicürixüa Yuri Tevi visi 'anetü nayeitüarieni, Cacaüyarita visi 'anetü rayeitüari hesiena tiviyatü. ");
INSERT INTO hchNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Xüca Cacaüyari visi 'anetü 'ayeitüarieni hesiena tiviyatü, Cacaüyarita yücümana visi 'aneme canayeitüamücü Yuri Tevi. Cuitüva visi 'aneme rayeitüani. ");
INSERT INTO hchNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Nenivema, yareutevitü xeicüa xehamatü necaniuyeicamücü. Xenenicuvautüvecuni. Que nemütivacühüavecai Huriyusixi, haque nemeyemie xepücayüvave xemeta'axüani ne'utaitü, yaxeicüa netinixehahüaveni xeme hicü. ");
INSERT INTO hchNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Hecuamecu necatinixe'aitüaca, xequeneyunaqui'erieca. Ne que nemütixenaqui'eriecaipaü, xequeneyunaqui'erieca yunaitü. ");
INSERT INTO hchNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","'Icücü yunaitü mecatenimaicacuni nehesüa miemete teyü'üquitüvamete xemühüme, xüca xeyunaqui'erieca yuhesie. ");
INSERT INTO hchNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simuni Pecuru müpaü tinitahüave, Ti'aitame, haque pepeyemie. Quesusi müpaü tita'ei, Haque nemeyemie pepücayüve pemünesi'anuveiya hicü. 'Arique pepünesi'anuveiya. ");
INSERT INTO hchNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pecuru müpaü titahüave, Ti'aitame, titayari necatiyüve nemümasi'anuveiya hicü. Netucari nepüyetuani 'ahesie mieme. ");
INSERT INTO hchNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Quesusi müpaü tita'ei, 'Atucari nehesie mieme petiyetuanitütü. Niuqui caniseüyeni que nematicühüave, vacana catahivavecacu, 'ecü haicacüa pepü'acu'imavani, quename pecanesimate pe'utaitü. ");
INSERT INTO hchNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yu'iyarisie xüca xecayumuinani. Cacaüyarisie yuri xecateni'erieca, nehesietari yuri xequetene'erieca. ");
INSERT INTO hchNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ne'uquiyari quiecariena vaüca canexuaveni qui. Xüca müpaü ca'anenique, müpaü nepücatixecühüaveniqueyu. Nepüyemie xehesie mieme 'aixüa nemeiyurienicü mana. ");
INSERT INTO hchNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Xüca neheyani, xüca xehesie mieme 'aixüa neheiyurieni mana, tavari necaninuamücü, nehesüa nenixe'anuvitümücü, haque nemeyeica xemeta mana xeme'uvanicü. ");
INSERT INTO hchNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Haque nemeyemie xecatenimaica, huye xetemateta. ");
INSERT INTO hchNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tumaxi müpaü tinitahüave, Ti'aitame, tame 'asitepücatemate haque pemeyemie. Que tete'imani huye. ");
INSERT INTO hchNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Quesusi müpaü ticühüave, Ne necanihücütüni huye, tita yuricü müraine netihücü, tucari netihücü. Xevitü ne'uquiyarisüa püca'aye'ave yuxaüta, necümana xeicüa paye'ave. ");
INSERT INTO hchNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Xüca xenesihetimanique, ne'uquiyarita xepümaicaqueyu. Hicürixüa xecaneitimani xecanixeiya. ");
INSERT INTO hchNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Piripe müpaü tinitahüave, Ti'aitame, quetaneuxeisitüa 'a'uquiyari. Mücücü tepünaqui'aca. ");
INSERT INTO hchNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Quesusi müpaü titahüavixü, Müixa xehamatü ne'uyeicacacu pecaneretimaive cuxi, Piripe 'acu. Que mü'ane münesixeiya, ne'uquiyarita canixeiyani. Quepaütütü peputaine, 'a'uquiyari quetaneuxeisitüa pemaine. ");
INSERT INTO hchNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Yuri pecati'eri quename ne ne'uquiyarisie netiviya, ne'uquiyarita nehesie tiviya. Que nemütixecuxaxatüva, necümana nepücaticuxata. Ne'uquiyari nehesie tiviyatü müyuhayeva, mücü yacatiniyurieneni. ");
INSERT INTO hchNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Yuri xequenetene'eririeca ne'uquiyarisie nemütiviyacü, ne'uquiyarita nehesie mütiviyacü. Me xüca müpaü yuri xecate'erieca, yanemütiyurienecü püta yuri xequetene'erieca. ");
INSERT INTO hchNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Niuqui caniseüyeni que nemütixecühüave, que mü'ane nehesie yuri müti'eri yacatiniyurienemücü que nemütiyuriene ne. Canena'ivamücü yatiyurienetü, ne ne'uquiyarisüa nemüyemiecü. ");
INSERT INTO hchNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Sepanetü que mütitita xemünetetavavirieni nehesüa xemiemetetütü, ne müpaü necatiniyuriemücü, ne'uquiyari visi 'anetü mayeitüarienicü yunivesie tiviyatü. ");
INSERT INTO hchNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Xücari tixaütü xenete'utavavirieni nehesüa xemiemetetütü, ne müpaü necatiniyuriemücü. ");
INSERT INTO hchNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Xüca xenesinaqui'erieca, yaxequetenecahuni que nemüti'aita. ");
INSERT INTO hchNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Neta nepitavavirieni ne'uquiyari. Mücü xeime canixepitüacamücü Titutuicametüme xehamatü muyeicanicü yuheyemecü. ");
INSERT INTO hchNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","'Iyari yuri maine necanixatani. Cuiepa memütama mepücayüvave memitanaqui'erieni memüca'ixeiyavavecü memüca'imatecü. Xemeri xecanimaicatütü. Xeteütatü niyuhayevani, xehesie catiniviyani. ");
INSERT INTO hchNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ne nepücaxecu'eirieni nepücaxenutuita. Xehesüa necani'axemücü. ");
INSERT INTO hchNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Yareutevitü cuxi, cuiepa memütama mepücanesixeiya. Xeme püta xepünesixeiya. Nemayeyuricü, xemerita xecanayeyuyuricacuni. ");
INSERT INTO hchNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","'Iya tucari 'aye'ayu, müpaü xecatenimaicacuni ne ne'uquiyarisie nemütiviyacü, xeme nehesie xemüteviyacü, neta xehesie nemütiviyacü. ");
INSERT INTO hchNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Que mü'ane mimate tita nemüti'aita, yamüticamie, mücü canihücütüni que mü'ane münesinaqui'erie. Que mü'ane münesinaqui'erie, ne'uquiyarita caninaqui'eriecamücü 'iya. Neta netinaqui'erieca, nemasiücüme nepaneyeitüani hesiena. ");
INSERT INTO hchNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Xevitü Cura müca'isicariutitanacatücai müpaü tinitahüave, Ti'aitame que 'uyü pemasiücütü pema'ayeitüani tame tahesie pemainecü, cuiepa memütama vahüxie pücatixaü. ");
INSERT INTO hchNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Quesusi müpaü tita'ei, Xüca tevi nesinaqui'erieca, neniuquisie yacatinicamiemücü. Ne'uquiyari caninaqui'eriecamücü 'iya. Hesüana tecani'axecuni, hesüana tenitaquicuni. Que mü'ane mücanesinaqui'eri, neniuquisie yapücaticamie. ");
INSERT INTO hchNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","'Icü niuqui xemü'enie, nehesüa pücamieme. Ne'uquiyari münesiheyenü'asüa canimiemetüni püta. ");
INSERT INTO hchNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","'Icü netinixe'utaxatüani xehesüa ne'uyeicatü. ");
INSERT INTO hchNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Titutuicame, 'iya 'Iyari Mütiyupata ne'uquiyari meiyenü'ani nehesüa miemetüme, mücü catinixeta'üquitüamücü naime. Catinixeta'eritüamücü nai que nemütixecuxaxatüvacai ne. ");
INSERT INTO hchNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Müpaü nepütixe'uhayevi, yu'iyarisie xemüca'uximatüariecacü. Nehepaü yu'iyarisie xemüca'uximatüariecacü nepüxepitüa. Cuiepa memütama que memüteyupitüva nepücatixepitüa. Xe'iyari xüca cayumuinaneni, xüca camamaca. ");
INSERT INTO hchNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Xeneniu'enieni, nemüyemie, xehesüa nemayeneni que nemütixe'utahüavixü. Xüca xenesinaqui'eriecaque, xecaniyutemamaviecaqueyu ne'uquiyarisüa nemüyemiecü. Ne'uquiyari yemecü canive'emetüni, ne hepaüna nepücave'eme. ");
INSERT INTO hchNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Hicü yanepütixe'utahüavixü yacatiyüvecacu cuxi, yuri xemüteta'erienicü quepaucua müpaü mütiyüni. ");
INSERT INTO hchNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Hicü xehamatü vaüca nepücaticuxataniri. Que mü'ane mütiva'aitüva cuiepa memütama 'ucanamieni. Tixaü pücarexeiya nehesie timieme. ");
INSERT INTO hchNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Masi cuiepa memütama memütehetimanicü ne'uquiyari nemünaqui'erie, ne'uquiyari que münetiu'aitüa, müpaü netiniyurieneni. Xequenanucu'uti, cümü tepüyehuri. ");
INSERT INTO hchNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Ne nana necanihücütüni, tita yuricü mütinanayari. Ne'uquiyari catini'üviyametüni. ");
INSERT INTO hchNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Yunaitü nana mamateya nehesie memüteviya xüca meca'utixuxuavereni, 'iya nivaranuyexürimücü. Yunaitü memutixuxuavere, 'iya nivati'itimücü masi vaücava mütixuaverenicü. ");
INSERT INTO hchNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Hicürixüa xecaniu'itiyani xeme neniuquicü nemütixecuxaxatüvacaicü. ");
INSERT INTO hchNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Nehesie xeteviyatü xequeneyuhayevani, neta xehesie netiviyatü netinehayeva. Mamateya pücayüve yücümana mütixuavere xüca nanayarisie tiviyatü cayuhayeva. Yaxeicüa xemerita xepücayüvave xemütixuavere xüca nehesie xeteviyatü xecayuhayeva. ");
INSERT INTO hchNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Ne nanayari necanihücütüni, xeme mamateya xetehüme. Que mü'ane nehesie tiviyatü müyuhayeva, neta hesiena netiviyacacu, mücü vaüca canitixuaverimücü. Nehesie xecateviyatü 'asixepücateyüvave xeme. ");
INSERT INTO hchNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Xüca tevi nehesie tiviyatü cayuhayeva, nana mamayaripaü cananuyehüiyamücü, nitavamücü. 'Icuxeüriyame taipa neuxüriyamücü, nititaiyariemücü. ");
INSERT INTO hchNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Xüca nehesie xeteviyatü xeyuhayeva, xücari tita nemüticuxata xehesie tiviyatü yuhayeva, tita mütixenaque xequenecuvava, müpaü catiniyümücü xehesie mieme. ");
INSERT INTO hchNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ne'uquiyari visi 'anetü canayeitüarivani quepaucua vaüca xemutixuxuavere, quepaucua nehesüa miemete teyü'üquitüvamete xemacüca. ");
INSERT INTO hchNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ne'uquiyari münetinaqui'eriecaipaü, müpaüta necatinixenaqui'eriecaitüni. Xequeneyuhayeva nehesie xeteviyatü, ne nexenaqui'eriecacu. ");
INSERT INTO hchNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Xüca yaxetecahuni que nemüti'aita, xeniyuhayevacuni nehesie xeteviyatü, nexenaqui'eriecacu ne, ne'uquiyari 'aisicayasie yanemüticamiepaü, iyasie netiviyatü nemünehayevapaü nesinaqui'eriecacu 'iya. ");
INSERT INTO hchNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","'Ipaü netinixecuxaxatüvacaitüni netemavierica xehesie müyuhayevanicü, xetemavierica maye'atüarienicü. ");
INSERT INTO hchNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","'Ipaü necatini'aitani, xequeneyunaqui'erieca que nemütixenaqui'eriecai ne. ");
INSERT INTO hchNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Que tevi yamücatiyucanaqui'eriepaü, vaüca masi pütiyucanaqui'erie yutucari yetuatü müme müvanaqui'erie vahesie mieme. ");
INSERT INTO hchNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Xeme xecaninenaqui'erimatüni xüca yaxetecahuni que nemütixe'aitüa. ");
INSERT INTO hchNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Te'uximayatameteri nepücatixe'uterüva. Ti'uximayatame 'asipücatimate que mütiyuriene cusiyarieya. Ne masi nenaqui'erima nepütixe'uterüva, naime nemütiu'eni ne'uquiyarisüa nepütixe'uta'üquitüa. ");
INSERT INTO hchNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Xeme xepücanesi'anayexei. Ne püta nenixe'anayexeiya. Nepüxe'uhüritüa xemüyehucü, xemutixuxuaverenicü, xehesüa mieme 'icuaxi müyuhayevanicü, sepanetü que mütitita xemitavavirieni ne'uquiyari nehesüa xemiemetetütü müxepitüanicü. ");
INSERT INTO hchNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","'Ipaü necatinixe'aitüaca, xequeneyunaqui'erieca. ");
INSERT INTO hchNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Xüca cuiepa memütama mexe'uxive'erieca, yaxequetenemaica, memünesita'uxi ne meri. ");
INSERT INTO hchNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Xüca cuiepa xemiemetetünique xeme, cuiepa memütama mecanixenaqui'eriecaqueyu yuteüterima. Xemeri cuiepa xepücamiemete, ne masi nenixe'anayexeiya cuiepa memütama vasata. 'Ayumieme cuiepa memütama mecanixe'uxive'erieca. ");
INSERT INTO hchNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Neniuqui xequena'erivani que nemütixe'utahüavixü, Que mü'ane müti'uximayatame pücahe'iva yucusiyari cui ve'emetütü 'iya cave'emetücacu. Que memünete'uveveiyacai ne, xemeta mecanixetaveveiyacuni. Neniuquisie yamepücatecahucai, yaxeicüa xeniuquisieta yamepücatecacüne. ");
INSERT INTO hchNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Masi 'ipaü naime mecanixeyuriecuni nehesüa xemümiemetecü, memüca'imatecü 'iya münesiheyenü'a. ");
INSERT INTO hchNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Xüca necanuanique, xüca necavarutaxatüanique, tita 'axa müti'ane mepücatehexeiyaqueyu. Hicüri tixaü mepücatehexeiya memiti'avietacü tita 'axa memüteyurie. ");
INSERT INTO hchNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Que mü'ane ne'uquiyari mü'uxive'erie, netari caneni'uxive'erieca. ");
INSERT INTO hchNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Vasata xüca yanecatiuyurienique xevitü yamücatiyurievepaü, müme tita 'axa müti'ane mepücatehexeiyaqueyu. Hicüri mecaniuneniere, mecatani'uxive'erieca neri ne'uquiyarita. ");
INSERT INTO hchNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Masi niuqui canaye'atüarieni 'inüari niuquiyarisie müpaü müre'uxa, Sepa 'asinemücatiuyuri, mecaneni'uxive'eriecaitüni. ");
INSERT INTO hchNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Quepaucua munuani 'iya Titutuicame nemüxehanü'airieni ne'uquiyarisüa mieme, 'Iyari yuri maine ne'uquiyarisüa mayeneica quepaucua munuani, 'iya nehepaüsita catinitahecüatamücü. ");
INSERT INTO hchNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Xemetari xecatenitahecüatacuni nehamatü xemu'uvacü matüaripaitü. ");
INSERT INTO hchNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","'Ipaü nepütixecuxaxatüvacai xemücatiquetamürecü. Müme mepücaxepitüani tuquita. ");
INSERT INTO hchNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Masicutaxi tucari canaye'amücü quepaucua yunaitü memüxecuini Cacaüyari me'ayexeiyame memüyu'erieca. ");
INSERT INTO hchNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Müpaü mecateniyuriecuni memüca'imatecü ne'uquiyari, memücanesimatecü neta. ");
INSERT INTO hchNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Masi 'ipaü netinixecuxaxatüvacaitüni, xeme'erivanicü neniuqui quepaucua maye'ani tucariyari, müpaü nemütixe'utahüavixü xeteha'erivatü. Matüaripai 'ipaü nepücatixe'utahüavixü xehamatü nemuyeicacaicü. ");
INSERT INTO hchNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Hicü necaniyemieni 'iya münesiheyenü'asüa. Xevitü xeme pücanesita'ivaviyave, haque pepeyemie 'utaitü. ");
INSERT INTO hchNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Müpaü nemütixecuxaxatüvacaicü xe'iyari canihüpüneni hivericacü. ");
INSERT INTO hchNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ne nepütixecuxaxatüva tita yuri müraine, masi 'aixüa caniyümücü xehesie mieme nemüyemiecü. Me xüca necaheyani, Titutuicame pücanuani xehesüa. Masisü xüca neheyani, necanixehanü'airiemücü. ");
INSERT INTO hchNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","'Iya nuame nivatatiemücü cuiepa memütama tita 'axa memüteyurie hepaüsita, tita mütiheiserie hepaüsita, titacü müranutahüiyani hepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Tita 'axa memüteyurie hepaüsita püvatatieni yuri memücate'eriecü nehesie. ");
INSERT INTO hchNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Tita mütiheiserie hepaüsita tivatatieni ne'uquiyarisüa nemüyemiecü, tavari xecanesixeiyacacu. ");
INSERT INTO hchNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Titacü müranutahüiyani hepaüsita tivatatieni, cuiepa memütama tiva'aitüvame que müranutahüiya. ");
INSERT INTO hchNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Vaüca cuxi necaneixeiyani nemütixetaxatüanicü. Xeme xeicüa xepücayüvave cuxi xemi'enieni hicü. ");
INSERT INTO hchNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Quepaucua 'iya munuani 'Iyari yuri maine, 'iya nixehecüatüamücü xemeitimanicü naitü yuri maine. Yücümana pücaticuxatani. Tita müti'enie catinitaxatamücü. Tita 'umüramie tinixetaxatüamücü. ");
INSERT INTO hchNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","'Iya visi ne'aneme canenayeitüamücü. Tita nehesüa mütimieme catinanupimücü catinixetaxatüamücü. ");
INSERT INTO hchNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Quepaü mürexeiya ne'uquiyari, naitü catininepinitüni. 'Ayumieme neputayü, tita nehesüa mütimieme catinanupimücü tinixetaxatüamücü. ");
INSERT INTO hchNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Yareutevitüri xepücanesixeiya. Tavari yareutevitüta xecanenixeiyacuni. ");
INSERT INTO hchNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","'Ayumieme teyü'üquitüvamete hipatü müpaü meteniyücühüavecaitüni, Titari taticühüave, yareutevitü xepücanesixeiya, tavari yareutevitü xepünesixeiya 'utaitü, müpaüta 'utaitü, ne'uquiyarisüa nemüyemie. ");
INSERT INTO hchNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","'Ayumieme mete'utiyuanecai, tita 'icü tixata yareutevitü maine. 'Asitepücatemate quetütü mutaine. ");
INSERT INTO hchNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Quesusi müpaü tinetimani memi'ivaviyacucaicü. Müpaü tinivarutahüave, 'Icücü niuqui xetexüatüa, müya nemutayücü, yareutevitü xepücanesixeiya, tavari yareutevitü xepünesixeiya nemainecaicü. ");
INSERT INTO hchNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Niuqui caniseüyeni que nemütixecühüave, xecaniutisuanacuni xeniyuhiveriecacuni. Cuiepa memütama püta meniyutemamaviecacuni. Xeme xecaniyuhiveriecacuni, peru xeyutihiverieme masi xeyutemamavietü xecanacünicuni. ");
INSERT INTO hchNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","'Uca tiniverümetü niyuhiveriecamücü tucarieya maye'acü. Nu'esi 'utinuivacu 'uximatüarica pücaha'eriva müyutemaviecü tevi mutinuivaxücü cuiepa. ");
INSERT INTO hchNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","'Ayumieme xemeta hiverica xecanexeiyani hicü. Tavari necanixexeiyamücü. 'Ana xe'iyari niyutemamaviecamücü. Xevitü pücaxenavairieni xetemavierica. ");
INSERT INTO hchNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","'Iya tucarisie tixaü xepücanetecu'ivaviyani. Niuqui caniseüyeni que nemütixecühüave, sepa que mütitita xemüte'itavavirieni ne'uquiyari nehesüa xemiemetetütü, yacatinixepitüamücü. ");
INSERT INTO hchNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Hicüque tixaütü xepücate'itavavirievave nehesüa xemiemetetütü. Xequeneutavaviriri, xenitanaqui'eriecuni xetemavierica maye'anicü. ");
INSERT INTO hchNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","'Icü ha'aviecamecü necatinixetaxatüacaitüni. Tucari canaye'amücü quepaucua nemücatixetaxatüani ha'aviecamecü, masi heiseriemecü necatinixetaxatüamücü ne'uquiyari hepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","'Iya tucarisie xecanitavaviriecuni nehesüa xemiemetetütü. Ne 'asinepücatixecühüave quename xehesie mieme ne'itavavirieni ne'uquiyari. ");
INSERT INTO hchNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","'Iyasü ne'uquiyaritütü canixenaqui'erieca, xeme xemünesinaqui'eriecaicü, yuri xemüte'uta'ericü quename Cacaüyarisüa neheyetüa. ");
INSERT INTO hchNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ne ne'uquiyarisüa nemiemetütü necaneyeyani, cuiepa necaninuani. Tavari nepüyemie cuiepa, ne'uquiyarisüa necaniyemieni. ");
INSERT INTO hchNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Teyü'üquitüvamete müpaü meniutiyuani, Camü hicürixüa heiseriemecü pecatinicuxatani, ha'aviecamecü pecaticuxatatü. ");
INSERT INTO hchNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Hicü müpaü tepütemate nai pemütimate, tixaü pücareuyevese xevitü mümasicu'ivaviyanicü. 'Ayumieme müpaü yuri tecateni'erieca Cacaüyarisüa pemeyetüacü. ");
INSERT INTO hchNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Quesusi müpaü tivaruta'ei, Yuri xete'erie hicü 'acu. ");
INSERT INTO hchNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Camü tucari canaye'amücü, canaye'aniri masi, quepaucua xemütaxüriyaxüani yuxexuitü yuquie. Xepünesicu'eirieni nexaütamecü. Masi nexaütamecü nepüca'uyeica, ne'uquiyari nehamatü puyeica. ");
INSERT INTO hchNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","'Ipaü necatinixecuxaxatüvacaitüni yu'iyarisie xemüca'uximatüariecacü nehesie xeteviyatü. Cuiepa 'uximatüarica xecanexeiyacacuni. Yu'iyari xequeneucayesa masi, ne necane'iva tita cuiepa mütimieme. ");
INSERT INTO hchNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Mericüsü müpaü tinicuxatacaitüni Quesusi. Yuheima heutiniereca müpaü niutayüni, Ne'uquiyari, tucariri paye'a. Visi 'ane quenayeitüa 'anive, 'iyata 'anive visi pe'aneme mümasi'ayeitüanicü ");
INSERT INTO hchNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","heiserie pemipitüapaü yunaime teüteri vahepaüsita, 'iya tucari mücaxüve müvapitüacacü yunaime pemiyetuirie 'ecü. ");
INSERT INTO hchNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","'Icü tucari mücaxüve canihücütüni, memümasimaicacü 'ecü pe'axevitü yuri pemücacaüyari, memünesimaicacü neta Quesusi Cürisitu pemünesiheyenü'a. ");
INSERT INTO hchNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ne cuiepa visi pe'aneme nemanayeitüani. Que pemünetiuhüritüa yanemütiyurienenicü, netinaye'atüaniri. ");
INSERT INTO hchNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Hicüri ne'uquiyari, 'ahesüa visi ne'aneme quenenayeitüa, visi nemü'anecaipaü cuie caxuavecacu cuxi. ");
INSERT INTO hchNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Ne nepümasitahecüataxü 'ecü que pemü'ane mücü teüteri vahüxie, cuiepa memütama vasata miemete pemünesiyetuiri vahüxie. Mepü'ateüterimatücai, pepünesiyetuiri müme. 'Aniuquisie yamecatenicahuni. ");
INSERT INTO hchNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Hicürixüa müpaü mecatenetimani quename 'ahesüa nemieme, nai pemünetiyetuiri. ");
INSERT INTO hchNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Niuqui pemünesi'upitüa nenivarupitüani müme. Mümerita mecanitanaqui'erieni. Müpaü mecatenetimani, yuricü 'ahesüa nemeyetüacü. Yuri mecateniuta'erieni quename penesiheyenü'a. ");
INSERT INTO hchNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Vahesie mieme nepümasitavaviri. Cuiepa memütama vahesie mieme nepücamasivaviri, müme pemünesiyetuiri vahesie mieme püta nepümasivaviri, 'ateüterima memühümecü. ");
INSERT INTO hchNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Naitü nepini 'apini catinihücütüni, 'apini nepini tihücüta. Vahesie netiviyatü visi ne'anetü necanayeitüarivani. ");
INSERT INTO hchNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","'Ari cuiepa nepüca'uyeica. 'Ime masi cuiepa mecaniu'uvani, ne 'ahesüa neniyemieni. Ne'uquiyari pemüpasie, queniva'üviyani müme pemünesiyetuiri 'ahesüa memümiemetecü, memüyutaxevirecü que temütetaxevi tame. ");
INSERT INTO hchNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Mexi vahamatü ne'uyeicacai necaniva'üviyacaitüni müme pemünesiyetuiri 'ahesüa memümiemetetücaicü. Nenivacueriecaitüni. Xevitü müme püca'uta'unari, 'iya xeicüa 'unaricacü mü'ayumiemetücai niuta'unarieni 'utüarica maye'anicü. ");
INSERT INTO hchNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Hicü 'ahesüa neniyemieni. 'Ipaü netinicuxatani cuiepa, yuhesie netemavierica memexeiyanicü 'aye'arücame. ");
INSERT INTO hchNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ne 'aniuqui necanivarupitüani. Cuiepa memütama mecanivaruti'uxive'erietücüne cuiepa memücamiemetecü, ne cuiepa nemücamiemepaü. ");
INSERT INTO hchNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Nepücamasivaviri pemüvaranuvitünicü cuiepa memüca'u'uvanicü. Masi nepümasivaviri pemüva'üviyanicü tita 'axa müti'ane hepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Cuiepa mepücamiemete ne cuiepa nemücamiemepaü. ");
INSERT INTO hchNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Tita yuri mürainecü quenivapatani 'ahesie mieme. 'Aniuqui canihücütüni tita yuri müraine. ");
INSERT INTO hchNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Cuiepa pemünesiheyenü'apaü, neta nepüvareutanü'axüa cuiepa. ");
INSERT INTO hchNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Vahesie mieme nepasietü nepüyüane, mümerita 'ahesie mieme memüpasienicü tita yuri mürainesie meteviyatü. ");
INSERT INTO hchNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","'Ime xeicüa vahesie mieme nepücamasivaviri. Masi müme nehesie yuri memüteta'erieni vaniuquicü, müme vahesie mieme nepümasivavirieta ");
INSERT INTO hchNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","yunaitü memüyuxevinicü, ne'uquiyari 'acu, 'ecü nehesie pemütiviyapaü, neta 'ahesie nemütiviyapaü, mümerita tahesie memüteviyanicü, cuiepa memütama yuri memüteta'erienicü quename 'ecü penesiheyenü'a. ");
INSERT INTO hchNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Visi ne'aneme pemünesi'ayeitüapaü, neta müpaü me'aneneme nenivarayeitüani memüyuxevinicü tame temütaxevipaü, ");
INSERT INTO hchNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","ne vahesie netiviyacacu, 'ecüta nehesie petiviyacacu, me'aye'atü memüyutaxevirecü, cuiepa memütama memütemaicacü quename penesiheyenü'a, quename müpaü petivarutanaqui'eri pemünetiunaqui'eripaü ne. ");
INSERT INTO hchNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Ne'uquiyari, tita pemünetiyetuiri, müpaü pünetinaque, haque nemeyeicani, mümeta nehamatü meme'uvanicü, memünesixeiyacü visi ne'aneme que pemünerayeitüa. Tamüsü 'ecü pecaneninaqui'eriecaitüni cuie cuxi canevecacu. ");
INSERT INTO hchNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ne'uquiyari yapemütiyuriene que mütiheiserie, cuiepa memütama mepücamasihetimaivave. Ne püta nepümasihetima. 'Ime müpaü mecatenetimani quename penesiheyenü'a. ");
INSERT INTO hchNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ne necanivarutahecüatüani memümasimaicacü 'ecü que pemü'ane. Yaxeicüa netinivatahecüatüamücü, pemü'ahayevacü 'ecü pevanaqui'erietü que pemünetinaqui'eriecai ne, neta vahesie nemütiviyanicü. ");
INSERT INTO hchNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Müpaü 'utayüca caneyani Quesusi teyü'üquitüvamete vahamatü. 'Aquisie Cariuxa Muye'u mütiuyetevasie menanucüne haraveri muyemacaisiepai. Mana neutahani teyü'üquitüvamete vahamatü. ");
INSERT INTO hchNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Hicü Cura miyetuaniquecai mana canemariecaitüni, müixa Quesusi teyü'üquitüvamete vahamatü memüyuyexexeürivacaicü muva. ");
INSERT INTO hchNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Cura cuyaxi varavitütü, tupirisixi mara'acate memühüritüariecai vahesüa miemete Pareseusixi vahesüa miemete varavitütü, mana caninuani cüxemete haurite cusirate mete'u'ütü. ");
INSERT INTO hchNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Quesusiri nai timaitü 'amüramiecai hepana, nivayeyani. Müpaü tinivarutahüave, Quepai xepütehacuvautüve. ");
INSERT INTO hchNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Müme müpaü metenita'eiya, Quesusi Nasaretitanaca. 'Iya müpaü tivarutahüave, Nesü nepühücü. Cura miyetuaniquecai mana niutivecaitüni vahamatü. ");
INSERT INTO hchNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Hicü ne nepühücü tivarutahüavecu yucuta meniyecüne, mecanatixürieni cuiepa. ");
INSERT INTO hchNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","'Ayumieme tavari müpaü tinivaruta'ivaviya, Quepai xepütehacuvautüve. Müme müpaü mete'utiyuane, Quesusi Nasaretitanaca. ");
INSERT INTO hchNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Quesusi müpaü tivaruta'ei, Yanepütixehahüave, ne nepühücü. Xücari xenesicuvautüveni ne, xequenivaruhayeva 'ime memüyehucü, ");
INSERT INTO hchNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","maye'anicü niuquieya que mainecai, Müme pemünesiyetuiri nepücavareuyexüriexüa xeime. ");
INSERT INTO hchNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Hicü Simuni Pecuru cusira 'acavietü nivatihana. Mara'acame mühüritüariecai ti'uximayatameya niuvani. Serietana mieme nacaya neucuviteni. Ti'uximayatame Marucu catinitevacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Hicü Quesusi müpaü tinitahüave Pecuru, 'Acusira queneucaquesa painatana. Ne necarenu'ieni 'iya tecüxita mieme ne'uquiyari münesi'itüani yanemüranayeyanicü. ");
INSERT INTO hchNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Hicü cuyaxiri, cuyaxi tiva'aitüvameri, Huriyusixi vatupirisixiri mecaniviya Quesusi. Menihüani. ");
INSERT INTO hchNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","'Anasisüa meri mecani'atüani. 'Iya Caipasi munieya nihücütücaitüni. Caipasi mara'acate vahepaüsita canihüritüariecaitüni mücü viyarisie. ");
INSERT INTO hchNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Caipasi tihücütücai que mü'ane müvaruti'imaiyaxü Huriyusixi masi 'aixüa müyünicü xevitü tevi mümünicü teüteri vahesie mieme, 'utaitü. ");
INSERT INTO hchNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Mericüsü Simuni Pecuru niveiyacaitüni Quesusi, xevitüta tiyü'üquitüvame tiveiyacai. Mara'acame mühüritüariecai nimaicaitüni 'iya tiyü'üquitüvame. Quesusimatü neutahani mara'acame mühüritüariecai curarutanapai. ");
INSERT INTO hchNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pecurusü mana niutivecaitüni tacua quitenie 'aurie. Hicü mücü tiyü'üquitüvame mara'acame mühüritüariecai mimaicai mana neyani. Nitahüave quitenie tihüveme, curarutapai Pecuru ni'atüani. ");
INSERT INTO hchNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","'Üimari quitenie mütihüvemetücai müpaü tinitahüave Pecuru, 'Ecüta 'icü tevi teyü'üquitüvametemama vahesüa mieme pecatihücü. 'Iya tiutayü, Ne pücatixaü. ");
INSERT INTO hchNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Hicü te'uximayatamete tupirisixi vahamatü mana meniuti'ucaitüni mecüxetü me'atinaica, muhaütücaicü. Pecuruta vahamatü niutivecaitüni cüxetü. ");
INSERT INTO hchNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Mericüsü mara'acame mühüritüariecai canita'ivaviya Quesusi teyü'üquitüvametemama vahepaüsita, tita müti'üquitacai hepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Quesusi müpaü tinita'eiya, Ne teüteri vahüxie netinicuxatacaitüni cuiepa. Ne neheyemecü netini'üquitacaitüni tuquiteta, tuqui 'amüpatata, haque yunaitü Huriyusixi memüyutixexeüriva. Ne tixaütü nepücaticuxatacai 'avie. ");
INSERT INTO hchNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Titayari peneticu'ivaviya ne. Quenivaruta'ivaviya müme memünesi'eniecai püta, siparasü que nemütivacuxaxatüvacai. Camü 'ime mecatenimaica que nemutayü. ");
INSERT INTO hchNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Müpaü 'utayücu, xevitü tupiri mana mutivecai canivani Quesusi müpaü 'utaitü, Quepaü petita'eiya mara'acame mühüritüarie. ");
INSERT INTO hchNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Quesusi müpaü tita'ei, Xücasü 'axa ne'utaineni, quetineutahecüata tita 'axa müti'anecü. Me xüca 'aixüa ne'utaineni, titayari penetiuva. ");
INSERT INTO hchNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Hicü 'Anasi neinü'ani hüiyacame Caipasisüa mara'acame mühüritüariecaisüa. ");
INSERT INTO hchNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Mericüsü Simuni Pecuru mana niutivecaitüni cüxetü. Hicü müpaü mete'itahüave, 'Iya teyü'üquitüvametemama vahesüa mieme pecatihücü. Mücü niyuta'imani, müpaü niutayüni, Ne pücatixaü. ");
INSERT INTO hchNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Mara'acame mühüritüariecai te'uximayatametemama xevitü, 'iya Pecuru minacavite canimarieyatücaitüni. Mücü müpaü rehüave, Quete ne necamarexei vana haraverita hamatüana pe'uyeicame. ");
INSERT INTO hchNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Tavari niyuta'imani Pecuru. Yapaucua niutahiva vacana. ");
INSERT INTO hchNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Hicü Caipasisüa meheyecüneca mecani'atüani Quesusi 'isücame quie. Niyuimuanatücaitüni. Mümeri mepücaheutahaxüa 'isücame quita capa meca'itiyatü me'acünecü, masi Pasicua 'icuaiyari memütecuanicü. ");
INSERT INTO hchNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","'Ayumieme Piratu tacua nivayeyani vahüxie. Müpaü niutayüni, Titacü xete'ixaneta 'icü tevi. ");
INSERT INTO hchNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Müme müpaü metenita'eiya, Xüca 'icü 'axa catiyurienenique, tepücamasiyetuirieniqueyu. ");
INSERT INTO hchNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Hicü Piratu müpaü tivarutahüave, Xequenanuvitüqui. Xequeneuta'inüata xe'inüari niuquiyari que maine. Huriyusixi müpaü mete'itahüave, Tame heiserie tepücahexeiya temimienicü tevi. ");
INSERT INTO hchNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Mücücü naye'ani Quesusi niuquieya mutainecai que mütimüniquecai ticuxatatü. ");
INSERT INTO hchNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Hicü tavari Piratu neutahani 'isücame quita. Nitahüave Quesusi, müpaü tinitahüave, 'Ecü Huriyusixi petiva'aitüvame. ");
INSERT INTO hchNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Quesusi müpaü tita'ei, 'Acümana müpaü petiutaine, hipatü nusu memate'utahüavixü nehepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Piratu tita'ei, Ne netihuriyu. 'Ateüterima, mara'acate memühüritüarie mepümasiyetua nehesüa. Que petiuyuri. ");
INSERT INTO hchNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Quesusi müpaü tita'ei, 'Ena cuiepa pücamieme que nemüti'aita. Xüca 'ena cuiepa miemetünique que nemüti'aita, netupirisixima mecaniyucuitüveniqueyu nemücayetuiyanicü Huriyusixi vahesüa. Masi hicü que nemüti'aita 'uva pücamieme. ");
INSERT INTO hchNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Piratu müpaü titahüave, Que peti'aitametüni 'ecü. Quesusi müpaü tita'ei, 'Ecü pecaniutaineni ne ti'aitame nemühücü. 'Ayumieme necaniutinuiva, 'ayumieme cuiepa necaninuani, nemütitahecüatanicü tita yuri müraine hepaüsita. Yunaitü yuri mürainesie miemete mecaneni'enieca ne'utaniucame. ");
INSERT INTO hchNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Piratu müpaü tinitahüave, Que titita yuri maine. Hicü müpaü 'utayüca tavari nivayeyani Huriyusixi vahüxie. Müpaü tinivarutahüave, Ne tixaü nepücatiucaxei nemütiuhüpanicü hesiena. ");
INSERT INTO hchNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","'Ipaü cani'aneni xeyeiyari, xeime nemüxexünirienicü Pasicua 'ixüararipa. Mericüte, xecateyuvaüriya nemüxexünirieni Huriyusixi tixe'aitüvame. ");
INSERT INTO hchNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Hicü müpaü meniutihiva tavari, Mücü pücatixaü, Vaxavaxi püta me'utiyuatü. 'Iya Vaxavaxi catininavayametücaitüni. ");
INSERT INTO hchNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Hicü Piratu neivitüni Quesusi, tiniuta'aita mücuveiyaxüanicü. ");
INSERT INTO hchNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Cuyaxita xuya mumayari me'utasaca mu'uyasie menenutimanirieni. Herie mieme 'ixuriqui mütaüraüyecü menenacuvirieni. ");
INSERT INTO hchNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Hüxiena meni'axecaitüni müpaü me'utiyuatü, 'Aixüa 'acu Huriyusixi tiva'aitüvame. Menicuvaxüanita. ");
INSERT INTO hchNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Hicü tavari tacua nivayeyani Piratu. Müpaü tinivarutahüave, Camü 'uva tacuapai nepüxe'atüirieni xemütemaicaicacü tixaü nemücatiucaxeicü hesiena nemütiuhüpanicü. ");
INSERT INTO hchNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Hicü Quesusi nivayeyani xuya mumayari 'anamatü, herie mieme 'ixuriqui mütaüraüye 'anacuvietü. Müpaü tivarahüave, Camü tevi. ");
INSERT INTO hchNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Hicüri mara'acate memühüritüariecai tupirisixita quepaucua memixei meniutihiva müpaü me'utiyuatü, Curuxisie queneumi'a, curuxisie. Piratu müpaü tivacühüave, Xemesü xequenanuvitüqui, curuxisie xequenemi'a. Neri tixaü nepücatiucaxei hesiena nemütiuhüpanicü. ");
INSERT INTO hchNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Huriyusixi müpaü mete'ita'ei, Tame 'inüari niuquiyari tecanexeiyani. Mücü 'inüari que maine, neuyeveca 'icü mümüni Cacaüyari nu'aya mayuyeitüacü. ");
INSERT INTO hchNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Piratu 'icü niuqui 'u'enieca masi vaüca neumacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Tavari 'isücame quita heutahaca müpaü tinitahüave Quesusi, Haque pepemieme 'ecü. Quesusiri haquevasü cacanita'eiya. ");
INSERT INTO hchNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Piraturi müpaü titahüave, Pecanetita'eiya ne. Pecatimate ne heiserie nemexeiya nemümasixünacü, heiserie nerexeiyata curuxisie nemümasimienicü. ");
INSERT INTO hchNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Quesusi müpaü tita'ei, 'Ecü heiserie pepücahexeiyaniqueyu nehepaüsita taheima miemecü xüca pecapitüariecaque. 'Ayumieme 'iya münesiyetua 'ahesüa, mücü masi vaücava 'axa tiniuyurieni. ");
INSERT INTO hchNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Piratu 'ayumiemeri tinicuvaunecaitüni que mütixünacü. Huriyusixi mecaniutihiva müpaü me'utiyuatü, Xüca 'icü pe'uxüna, pepüca'inaqui'erie Ti'aitame Sesaxi. Yunaitü te'aitamete memayuyeitüa mecaneye'unieca Sesaxi. ");
INSERT INTO hchNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Hicü Piratu 'icü vaniuqui 'u'enieca nivayehana Quesusi. Mana caniucayerüni Piratu yu'uvenisie Macutenusariya müracutevasie, Hepürayusixi vaniuquicü Cavata müracutevasie. ");
INSERT INTO hchNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","'Iya tucarisie meniha'aritüacaitüni Pasicua 'ixüarariyari. 'Esivatücacu tuca nayeiximecaitüni. Müpaü tinivarutahüave Huriyusixi, Camü tixe'aitüvame. ");
INSERT INTO hchNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Mümeri meniutihiva, Quenanuvitüqui, quenanuvitüqui, curuxisie quenemi'a. Piratu müpaü tivacühüave, Quetütüri curuxisie nepeimieni tixe'aitüvame. Mara'acate memühüritüariecai müpaü mete'ita'ei, Tame xeime tepücahexeiya tati'aitüvame, Sesaxi xeicüa pütati'aitüvame. ");
INSERT INTO hchNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Hicü nivayetuirieni curuxisie mümierienicü. Hicü meneihana Quesusi. ");
INSERT INTO hchNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Yucuruxi 'atütü mana neyani Müqui Mu'uya Manuca müracutevasie, Hepürayusixi vaniuquicü Curucuta müracutevasie. ");
INSERT INTO hchNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Manari curuxisie menitivieni. Yuhutame hamatüana metevarutivütüa naisata, Quesusi vahixüata. ");
INSERT INTO hchNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Piratuta 'inüari niuta'utüani. Curuxisie neimani. Müpaü catine'ucaitüni, QUESUSI NASARETITANACA HURIYUSIXI TIVA'AITÜVAME. ");
INSERT INTO hchNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Huriyusixi yumüiretü menititerüva 'iya 'inüari quiecari mehuracü Quesusi mamieriesie. Hepürayusixi Xumatari Cüriyecusixi vaniuquitecü püraye'uxacai. ");
INSERT INTO hchNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Hicü Huriyusixi vamara'acate memühüritüariecai müpaü metenitahüave Piratu, Pepücaniu'utüani Huriyusixi Tiva'aitüvame. 'Ipaü püta, 'Iya mainecai Huriyusixi nepütiva'aitüvame pepütiniu'utüani. ");
INSERT INTO hchNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Piratu müpaü tivaruta'ei, Que nemütiu'utüa netiniuta'utüaniri. ");
INSERT INTO hchNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Hicü cuyaxi curuxisie me'icavieca Quesusi, 'ixuriquiteya meneutahuriexüani. Naucame menayeitüani, yuxexuitü cuyaxi xei 'ixuriquiyari memexeiyanicü, tetüata mieme 'ixuriquita 'aparüte yuxaüta. Tetüata mieme 'ixuriquieya pücavipecai, yuxevitü ni'isecaitüni naitü. ");
INSERT INTO hchNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Hicü müpaü meteniyutahüaveni, Camü tepüca'itisanani. Masi tepütata'iva, siparasü quepai pe'iva. Müpaü tinaye'atüarieni 'utüarica müpaü maine, Ne'ixuriqui meniutapataxüani yuhesie mieme, ne'ixuriquicü menayu'iva. Mericüsü müpaü mecateniuyurieni cuyaxi. ");
INSERT INTO hchNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Quesusi curuxieya 'aurie meniti'ucaitünita Quesusi varusieya, varusieya 'ivaya, Mariya Cüreupa 'üyaya, Mariya Mararatanaca yunaitü. ");
INSERT INTO hchNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Quesusisü varuxeiyaca mana meti'ucacu yuvarusi, 'iya tiyü'üquitüvame münaqui'eriecai, müpaü tinitahüave yuvarusi, 'Uca 'acu, camü 'anive. ");
INSERT INTO hchNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","'Arique müpaü tinihüritüani 'iya tiyü'üquitüvame, Camü 'avarusi 'utaitü. 'Iya tucarisie tiyü'üquitüvame yuhesüa nei'inieni. ");
INSERT INTO hchNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","'Anari Quesusi müpaü timaitü naitü 'ari maye'atüariecü, 'utüarica maye'atüarienicü müpaü niutayüni, Nepeuharimücü. ");
INSERT INTO hchNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Xari mana niucateitüni vinu masina hünetü. Hicü ha 'iseveme mucuxani me'utahüniyaca vinu masinacü, hisupu cüyeyarisie me'iyeca, teniena meneitiserieni. ");
INSERT INTO hchNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Quesusi he'inüataca vinu masina müpaü niutayüni, Canaye'aniri. Yumu'usie 'anacatusireca niyetuani yu'iyari. ");
INSERT INTO hchNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Mericüsü 'iya tucarisie meniha'aritüacaitüni 'ixüarari. 'Ayumieme Huriyusixi menitavavirieni Piratu vavatute memütitaracü memüvaraca'ünicü, caxarite memücayuhayevacü curuxisie me'uyevütü 'uxipiya tucarisie. 'Iya 'uxipiya tucari yemecü cani'ixüararitücaitüni. ");
INSERT INTO hchNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","'Ayumieme cuyaxi mana meniu'axüani, memucavütüarie curuxisie hamatüana xeime vatuteya meniutitara, xeimetari vatuteya mete'utitaraxü. ");
INSERT INTO hchNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Quesusisüa me'u'axüaca vatuteya mepüca'utitaraxü memixeicü müquime. ");
INSERT INTO hchNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Masi xevitü cuya pisicacü neitiseni 'aquitana. Yapaucua naneni xuriya hata. ");
INSERT INTO hchNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Que mü'ane munierixü tiniutahecüata. Tita mütitahecüata yuri canaineni. Mücüta tinimaica yuri mainecü, yuri xemüte'eriecacü xemeta. ");
INSERT INTO hchNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Müpaü tiniuyüni 'utüarica maye'atüarienicü müpaü mutaine, 'Umeyari pücatitare. ");
INSERT INTO hchNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Tavari xevitü 'utüarica 'ipaü naineni, Mecani'ixüariecuni que mü'ane memuse. ");
INSERT INTO hchNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Mericüsü 'arique Cuse 'Arimateyatanaca canitavavirieni Piratu menucuenicü Quesusi caxarieya. 'Iya Cuse Quesusisüa mieme catiniyü'üquitüvametücaitüni 'avie, müvamacarücaicü Huriyusixi. Piraturi canipitüani. Neyani, caxarieya necueni. ");
INSERT INTO hchNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nicuremu mana ninuanita meripai hesüana munua yüvicüta. 'Iyasü miru haruhemame visi mu'üa mutacuicuiya ni'atüani merie necapaü paümeme. ");
INSERT INTO hchNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Hicü meneicueni Quesusi caxarieya. Menicu'eima 'ixuriquitecü visi mu'üa me'icavirieca. Müpaü cani'aneni Huriyusixi vayeiyari teuquiyacü. ");
INSERT INTO hchNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Mana curuxisie mamieriesie haraveri niyemacaitüni. Haraverita teuquiyapa xique müvaye'inierie nicumacaitüni. Xevitü cuxi mücü teuquiyapa pücacateuquievecai. ");
INSERT INTO hchNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Muva 'ayumieme meneiteni Quesusi, Huriyusixi memüyuha'aritüacaicü 'iya tucarisie, teuquiyapa mehuracaicü. ");
INSERT INTO hchNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Mericüsü mexüacame tucariyarisie semanasie teuquiyapa ninuani Mariya Mararatanaca 'uyüvicacu cuxi yuimuana. Heuhüiyacame niuxeiya tete teuquiya hüxie meucatei. ");
INSERT INTO hchNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Hicü nausarümetü neyani. Simuni Pecurusüa ninuani, xeimesüata tiyü'üquitüvame Quesusi minaqui'eriecaisüa. Müpaü tinivarutahüave, Teuquiyapa menivayecueni Ti'aitame. 'Asitepücatemate haque memeite. ");
INSERT INTO hchNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Hicü Pecuru neyani xevitü tiyü'üquitüvamematü. Teuquiyapa menahucaitüni. ");
INSERT INTO hchNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Yuhepaüsita meniunausarümecaitüni. Xevitü tiyü'üquitüvame masi niutanausacai, Pecuru na'iva, naye'ani meri teuquiyapa. ");
INSERT INTO hchNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","'Anahuca nixeiya 'ixuriquite mana 'acateme, peru muva pücaheutaha. ");
INSERT INTO hchNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Hicü Simuni Pecuru 'u'imatütü ninuani. Teuquiyapa neutahani. 'Ixuriquite niuxeiya mana 'acateme. ");
INSERT INTO hchNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Tuvaxa tiuxei mu'uya me'eimecai 'ixuriquite 'aurie caticateme, yateva ticateme püta tutunime 'uxeicüa. ");
INSERT INTO hchNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","'Ana neutahani 'iya tiyü'üquitüvame 'umexüatü munua teuquiyapa. Nixeiya, yuri tiniuta'erieni. ");
INSERT INTO hchNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Müme cuxi mepücaheitimaivavecai 'utüarica meuyevecaicü müquite vasata manucuqueni maine. ");
INSERT INTO hchNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Hicü teyü'üquitüvamete yuquie menecüne. ");
INSERT INTO hchNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Mericüsü Mariya teuquiya hüxie niutivecaitüni tacua 'utasuatü. Hicü 'utasuatü nanahuni, teuquiyapa neutaniere. ");
INSERT INTO hchNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Mana nivaruxeiya niuqui tuayamete yuhutame me'anacatuxame. Xevitü Quesusi mu'uya manucatei nacateitüni, xevitüta quetaya manucatei racatei haque Quesusi caxarieya manutequiecai. ");
INSERT INTO hchNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Müme müpaü metenitahüave, Neuxei 'uca, titayari petiutasuaca. ");
INSERT INTO hchNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Müpaü tivacühüave, Neti'aitüvame mepecuei, 'asinepücatimate haque memeite. Müpaü 'utayüca ta'aurie naveni. Nixeiya Quesusi mana 'utiveme, masi 'asipücatimaicai müquesusitücaicü. ");
INSERT INTO hchNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Quesusi müpaü tinitahüave, Neuxei 'uca, titayari petiutasuaca. Quepai pepüracuvaune. Mücü haravericame 'erietü müpaü tinitahüave, Neuxei 'uqui, xüca 'ecü peheicueni, queneneutaxatüa haque pemeite. Neri nenenucueimücü. ");
INSERT INTO hchNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Quesusi müpaü ticühüave, Mariya 'acu. 'Iya hepana 'aniereca müpaü tinitahüave Hepürayusixi vaniuquicü, Xavuni, taniuquicü Ti'üquitame maine. ");
INSERT INTO hchNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Quesusi müpaü ticühüave, Pepücanesiviyani. Ne'uquiyarisüa nepüca'anutiyeive cuxi. Masi ne'ivama vahesüa quenemie. Müpaü quetinivaretahüavi, Ne'uquiyarisüa müxe'uquiyarisüa nenanutiyeimücü, necacaüyarisüa müxecacaüyarisüa neranutiyani. ");
INSERT INTO hchNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Hicü Mariya Mararatanaca mana ninuani müpaü tivacuxaxatüvatü teyü'üquitüvamete Ti'aitame muxeicü, müpaü mürehüavecaicü. ");
INSERT INTO hchNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Mericüsü 'acayunecu mücü mexüacame tucariyarisie semanasie, teyü'üquitüvamete memütitecaisie quiteniete reunatücaicacu memüvamacarücaicü Huriyusixi, Quesusi ninuani. Vahixüapa niutaqueni. Müpaü tinivarutahüave, Xüca xeca'uximatüarieca yu'iyarisie. ");
INSERT INTO hchNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Müpaü 'utayüca nivaruxeisitüani yumamate yu'aqui. Teyü'üquitüvamete meniyutemamaviecaitüni Ti'aitame mexeiyatü. ");
INSERT INTO hchNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Hicü Quesusi tavari müpaü tivarutahüave, Xüca xeca'uximatüarieca yu'iyarisie. Ne'uquiyari münesiheyenü'apaü, neta müpaü necanixeheutanü'axüani. ");
INSERT INTO hchNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Müpaü 'utayüca nivaru'iyamani. Müpaü tivarutahüave, Xequeneutanaqui'eri 'Iyari Mütiyupata. ");
INSERT INTO hchNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Sepa que memühate xemütevareuyehüvirieni tita 'axa memüteyurie, meteneuyehüviyariecuni. Sepa que memühate xemüvavesitüaca tita 'axa memüteyurie, menivecacuni mepücayutaxüna. ");
INSERT INTO hchNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Mericüsü Tumaxi Vavari mütitevacai tamamata heimana yuhutame vahesüa mieme canihücütücaitüni. 'Iya vahamatü püca'uyeicacai quepaucua Quesusi munua. ");
INSERT INTO hchNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Hicü hipatü teyü'üquitüvamete müpaü metenicuxaxatüvacaitüni, Ti'aitame tecaniuxeiya, me'utiyuatü. 'Iya tivacühüave, Xücari mamayasie neca'ixeiyani cürapuxi 'uxayari, xüca ne'itüvamecü neca'imayüani cürapuxi 'uxayari, 'aquieya xüca nemamacü neca'imayüani, yuri nepücatita'erieniri. ");
INSERT INTO hchNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Mericüsü 'atahairieca tucari 'anucayacu tavari menititecaitüni quita teyü'üquitüvametemama. Tumaxita vahamatü tiucatei. Hicü quiteniete reunarümacacu Quesusi ninuani. Vahixüapa niutaqueni. Müpaü tinivarutahüave, Xüca xeca'uximatüarieca yu'iyarisie. ");
INSERT INTO hchNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Hicü müpaü titahüavixü Tumaxi, Quenaye'a, 'a'itüvamecü queneneumayüa nemamatesie, 'amamacü queneneumayüani ne'aquita. Yuri pecati'erietü pepüca'ayeiximeni, yuri peti'erietü püta quenaye'a. ");
INSERT INTO hchNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tumaxi müpaü tinita'eiya, Neti'aitüvame necacaüyari 'acu. ");
INSERT INTO hchNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Quesusi müpaü titahüave, Yuri petiuta'erie pemünesi'uxeicü. Müme memücanesixeiyavave peru yuri memüte'erie, müme mecaniyutemamavieca. ");
INSERT INTO hchNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Mericüte, 'inüari yücü 'aneneme müireme yatiniyurienecaitüni Quesusi teyü'üquitüvamete vahüxie, que mücare'utüarie 'icü xapasie. ");
INSERT INTO hchNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","'Icüri canaca'utüarieni yuri xemüte'eriecacü Quesusi mücürisitucü, Cacaüyari münu'ayacü. Yuri xete'erietü tucari xemexeiyanicü hesüana xemiemetetütü raca'utüarie. ");
INSERT INTO hchNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Mericüsü 'arique tavari Quesusi masiücütü nayuyeitüani teyü'üquitüvamete vahüxie Tiveriya haracunayarisie. 'Ipaü masiücütü nayuyeitüani. ");
INSERT INTO hchNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","'Axeicüa meniu'uvacaitüni Simuni Pecuru, Tumaxi Vavari mütitevacai, Natanaheri Canatanaca Carereya cuieyarisie mieme, Severeu nivemama, teyü'üquitüvametemama hipatü yuhutatü. ");
INSERT INTO hchNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simuni Pecuru müpaü tinivarutahüave, Ne nepüquesüveiyami. Müpaü mete'itahüave, Tame 'ahamatü tepuhu tanaitü. Mana menecüne, canuvasie menicayaxe. Mücü tücarisie tixaütü mepücate'u'axixü. ");
INSERT INTO hchNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Mericüsü 'esiva 'uhecüacacu mana niutaqueni Quesusi haracuna tesita. Masi teyü'üquitüvamete mepüca'imaicai Quesusitüme. ");
INSERT INTO hchNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Hicü Quesusi müpaü tinivarutahüave, Neuxei temari, 'icuai xecatehexeiya. Müpaü mete'ita'ei, Havaicü. ");
INSERT INTO hchNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","'Iya tivacühüave, Vipi xequeneucavivi canuva serieta. Mana xecanivacaxeiyacuni. Mana meneicavivieni. Mepüyutatexi me'ihanatü memüvaücavacaicü quesüte. ");
INSERT INTO hchNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Hicü 'iya tiyü'üquitüvame Quesusi minaqui'eriecai müpaü tinitahüave Pecuru, Cari Ti'aitame canihücütüni. Hicü Simuni Pecuru 'u'enaca quename Ti'aitame hücütücai, yu'ixuriqui herie mieme 'anacuvieca 'amavetü 'amuyeicacaicü, hapa neucasuna. ");
INSERT INTO hchNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Hipatü teyü'üquitüvamete canuvasie meyetetü mecaniu'axüani vipi me'uhaximetü quesüte mehüneme. Cuiepa pücahetevacai, huta teviyari heimana tamamata mamayari xeicüa petevacai. ");
INSERT INTO hchNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Cuiepa me'u'axüaca tü meniuxeiya 'etiniereme, quesü tüpa 'acaime mete'uxei pamame. ");
INSERT INTO hchNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Quesusi müpaü tinivarutahüave, Quesüte xique xemüvarutivi xequenivara'üi. ");
INSERT INTO hchNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simuni Pecuru mana neutimaque, vipi caniuhana cuiepa. Quesüte 'amepapatü menihünecaitüni, xei sienituyari heimana huta teviyari heimana tamamata heimana yuhaicatü meniyupaümecaitüni. Sepanetü memüvaücavacai, püca'utasanixü vipi. ");
INSERT INTO hchNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Quesusi müpaü tinivarutahüave, Xequenacüni xequetenecuacari. Teyü'üquitüvamete ni xevitü pücayuvaüriyacai 'ecü que pepüpaicü titahüaveque, Ti'aitame mühücütücaicü memütemaicaicü. ");
INSERT INTO hchNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Hicü Quesusi mana ninuani, pa nanucu'üni. Nivarumini, quesü yaxeicüata tivarumi. ");
INSERT INTO hchNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","'Ana hairieca masiücütü nayuyeitüani Quesusi teyü'üquitüvamete vahüxie müquite vasata 'anucuqueca. ");
INSERT INTO hchNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Mericüsü mete'ucuacu Quesusi müpaü tinitahüave Simuni Pecuru, Simuni 'acu Vani nu'aya, vaücava penetinaqui'erie, 'ime 'esiva xeicüa menesinaqui'eriecacu. 'Iya rehüave, Hü Ti'aitame. 'Ecü pepütimate nemümasinaqui'erie. Titahüave, Mericüte, nemuxasi türixi quetinivarumicua. ");
INSERT INTO hchNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Hutarieca müpaü titahüave, Simuni 'acu Vani nu'aya, penetinaqui'erie. Müpaü titahüave, Hü Ti'aitame. 'Ecü pepütimate nemümasinaqui'erie. Müpaü titahüave, Nemuxasi queniva'üviyani. ");
INSERT INTO hchNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Hairiecari titahüave, Simuni 'acu Vani nu'aya, penetinaqui'erie. Pecuru niyuhiverieca hairieca penetinaqui'erie mütitahüavixücü. Müpaü tinitahüave, Ti'aitame, 'ecü nai pecatinimaica. Pepütimate nemümasinaqui'erie. Quesusi titahüave, Quetinivarumicua nemuxasi. ");
INSERT INTO hchNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Niuqui caniseüyeni que nematicühüave, quepaucua pemühecuacai 'acümana pena'ahüayacaitüni peticuyeicacai haque pemeuyeimücücai. Quepaucua pemütaseüye, xevitü camananahüamücü maranuhana haque pemücaheuyeimücü, 'amama penitaseraxüamücü. ");
INSERT INTO hchNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Müpaü niutayüni tihecüatatü que mütimüniquecai visi 'aneme 'ayeitüanique Cacaüyari. Müpaü 'utayüca müpaü tinitahüave, Quenenanuveiya ne'utüma. ");
INSERT INTO hchNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pecuru ta'aurie 'aveca nixeiya mücü tiyü'üquitüvame Quesusi minaqui'eriecai, mücü memüte'ucuaisie 'auriena mucatei müpaü mütitahüavixü, Ti'aitame que paicü masiyetuani. Nixeiya 'iya varuveiyame. ");
INSERT INTO hchNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pecuru 'ixeiyaca mücü, müpaü tinitahüave Quesusi, Ti'aitame que tiyurieni 'iya. ");
INSERT INTO hchNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Quesusi müpaü ticühüave, Xüca nesi'unaqueque 'icü müyuhayevacü nemunuanique, quesü pe'aneniqueyu 'ecü. Quenenanuveiya ne'utüma. ");
INSERT INTO hchNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","'Ayumieme ta'ivama vasata 'icü niuqui canixasivacaitüni, quename 'iya tiyü'üquitüvame camüniquecai. Masi Quesusi müpaü pücatitahüavixü mücamüniquecaicü. Xüca nesi'unaqueque müyuhayevacü nemunuanique, quesü pe'aneniqueyu 'ecü, püta titahüavixü. ");
INSERT INTO hchNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Mücü tiyü'üquitüvame canihücütüni que mü'ane mütihecüata 'icü hepaüsita, que mü'ane mütiuti'utüa 'icü. Tepütemate tita mütihecüata yuri maine. ");
INSERT INTO hchNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Vaücava cuxi yücü 'anenetü canixuaveni que mütiuyuri Quesusi. Xüca xexuitü tiuti'utüarienique, müpaü nepüticu'eriva, 'ena cuiepa pücatinaqueniqueyu xapate mütiti'utüarieniqueyu. Müpaü xeicüa.");
INSERT INTO hchNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Neuxei Teuquiru, matüaripai mieme xapa neputavevi mexüacame, nai que mütiuyü hepaüsita ticuxatame, Quesusi que mütisutüa yatiyurienetü yati'üquitatü. ");
INSERT INTO hchNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Müpaü tiuyurieca, 'ana nanutivitüquieni, 'aisica varupitüaca nü'arisixi müvaranuyeteüxixü, 'Iyari Mütiyupata yati'aitacacu. ");
INSERT INTO hchNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Tiucuineca mücü, vahesüa 'ayenieretü puyuhecüatacai mamarivaveme tiyurienetü. Huta teviyari tucari mepixeiyacai. Tinivacuxaxatüvacaitüni que müti'ane Cacaüyari ti'aitametücacu. ");
INSERT INTO hchNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Hicü vahamatü 'a'ucaitü 'ipaü tinivaruta'aitüani, Xepüca'ayecücani Querusareme, masi xequetenecuevieca tita ne'uquiyari mütixatacai quename tixehanü'airieni, que nemütixe'utahüavixü. ");
INSERT INTO hchNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Vani hacü tiniuca'üyacaitüni, xeme püta xepüca'üyarieni 'Iyari Mütiyupatacü yapaümexa tucari tixüyu. Müpaü niutayüni. ");
INSERT INTO hchNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Mericüsü müme hamatüana memuyucuxeürie müpaü metenicu'ivaviyacaitüni, Neuxei Ti'aitame, hicü petatipitüa tame 'Ixaherisixi teüteriyari temütetati'aitüanicü meripaipaü. ");
INSERT INTO hchNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Mücüsü müpaü tinivarutahüave, Xeme xehesie pücatinaque xemütemaicacü viyari tucari hepaüsita. Ne'uquiyari püta nipata mücü naime heiserie mexeiyanicü hepaüsitana. ");
INSERT INTO hchNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Masisü xecanitürücariyariecuni 'Iyari Mütiyupata xehesie tiviyayu. Xemunenierixü xepüyüaca xetehecüatatü nehepaüsita Querusareme, naisarie Cureyasie Samariyasie naisarie cuie manunierepai. ");
INSERT INTO hchNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Müpaü 'utayüca, müme me'ixeiyacacu, nanutivitüquieni. Hai niucuyani memüca'ixeiyacü. ");
INSERT INTO hchNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Hicü yuheima me'utinenierecacu mexi 'utimiecai, camü 'uquisi yuhutatü va'aurie meniuti'uni me'anacatuxatü. ");
INSERT INTO hchNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Müme müpaü metenivarutahüave, Carereyatari 'acu, titayari yuheima xete'utineniere. Mücütütü xesata 'uvetü meutivitüquie yuheima Quesusitütü, que xemüte'ixei heutimieme yuheima, yaxeicüa 'anetü caninuamücü. ");
INSERT INTO hchNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Mericüsü yemuri Huriva Mati'usie me'ayenexüaca Querusareme meniu'axüani. 'Uxipiya tucarisie tevi que mütipitüarie muyeicanicü, müpaü pehura Querusareme. ");
INSERT INTO hchNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Me'u'axüaca, quita meheutahaxüaca meneuticüne qui taüta. Mana mepü'axecai Pecuru Cacuvu Vani 'Atürexi Piripe Tumaxi Parüturume Mateu Cacuvu 'Aripeu nu'aya, Simuni müserutisitatücai, Cura Cacuvu 'ivaya. ");
INSERT INTO hchNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Müme yunaitü 'axeicüa mepü'ayumiemetetücai neneviericü, 'ucarita, Mariyata Quesusi müvarusieyatücai, 'ivamamata. ");
INSERT INTO hchNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Mericüsü 'ana Pecuru nanucuqueni yu'ivama vahixüapa. Teüteri 'axeicüa meyuxeürietü xei sienituyari heimana xei teviyari yacütütü meniyupaümecaitüni. Müpaü niutayüni Pecuru, ");
INSERT INTO hchNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Ne'ivamarixi, neuyevecaitüni 'utüarica maye'anicü, meripai que mütiutayü 'Iyari Mütiyupata, Raviri müpaü 'utayücu Cura hepaüsita, que mü'ane müvarevitü müme memivi Quesusi hepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Tame xevitü pühücütücai, 'icü tahüritüarica hesiena pütinaquecai. ");
INSERT INTO hchNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Mericüsü vaniu cuie punanai mücü tumini ma'ivaxücü yatiuyurieca que mücatiheiserie. Mana 'ativeca yuhuriepa pasanixü, cuinurieya naitü navivieni. ");
INSERT INTO hchNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Querusareme memütama yunaitü mepüte'utamari. 'Ayumieme mücü cuie Haserama catinacutevaca vaniuquicü, taniuquicü Xuriya Mataxüri racuteva. ");
INSERT INTO hchNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Puta'utüarie Cuicari Xapayarisie müpaü 'anuyütü, Que'uyemaveni quiya, Xevitütüma püca'ayecani. Müpaü panuyüneta, Que mütihüritüariecai, Xevitü püta yaquetihüritüarieca. ");
INSERT INTO hchNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Mericüte, neuyeveca xevitü müme 'uquisi tahamatü memu'uvacai tucaricü quepaucua Ti'aitame Quesusi tahesüa manuyeicacai ");
INSERT INTO hchNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","'iya tucarisie Vani meca'üyaxüsie, 'iya tucarisie tasata manutivitüquieque, peuyevese xevitü müme memunenierixü tahamatü tihecüatatü mayanicü que müranucuque. ");
INSERT INTO hchNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Hicü yuhutame menivaruti'uitüani Cuse Varüsavaxi mütitevacai Cusitu müremu'uhüacai, Matiya. ");
INSERT INTO hchNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Meniyutanenevieni müpaü me'utiyuatü, 'Ecü Ti'aitame pecatinimaica yunaime va'iyari. Quetaneuxeisitüa que mü'ane pemanuyexei 'icü yuhutame, ");
INSERT INTO hchNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","hesiena mütinaquenicü 'icü hepaüsita mühüritüarienicü mütanü'arienicü, Cura yatiuhayevacu yuhuyeripa metüacü. ");
INSERT INTO hchNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","'Inüari meputavevi que mü'ane mühücütüni. Matiyasie tiniunaque. Mepi'inüataxü tamamata heimana xevime nü'arisixi vahamatü. ");
INSERT INTO hchNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Mericüsü 'ixüarari 'atahutarieca semanasie mieme 'aye'acu yunaitü mepüyuxeüriecai yameteyurienique 'uxeicüa. ");
INSERT INTO hchNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Yapaucua taheima mieme 'ecapaü 'anetü niuyuani türücaüyetü carima 'uyemietü. Mücü yuariya putahünixü quita memüvayetecaisie. ");
INSERT INTO hchNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Taipaü 'aneneme mepuxei yuxexuime vahesie 'a'ucame. ");
INSERT INTO hchNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Yunaime püvaruvi 'Iyari Mütiyupata. Mepisutüa me'utiniutü niuquitecü, 'Iyari que mütivapitüacai memütiniunicü. ");
INSERT INTO hchNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Mericüsü Querusareme mepütitecai Huriyusixi Cacaüyari memayexeiyacai yunaime nuivarite vahesüa memümiemetetücai naisari muyuavitüa. ");
INSERT INTO hchNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Quepaucua yuariya muyua yunaitü mepuyuxeüri, mepüxamuriyacai yuxexuitü yuniuquicü memüva'eniecaicü me'utiniucame. ");
INSERT INTO hchNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Mepü'iyarixiecai mepühüxiyacai müpaü me'utiyuatü, Neuxei, 'icü yunaitü memutiniuca mecatecarereyatari. ");
INSERT INTO hchNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Quetütüri 'icü teteva'enie taxexuitü taniuquicü memutiniuca que temüte'ununuivaxü. ");
INSERT INTO hchNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Parutiyatari, Meriyatari, 'Eramitatari, Mesuputamiyasie temütama, Cureyasie Caparusiyasie Punitusie 'Asiyasie ");
INSERT INTO hchNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Püriquiyasie Pamüpiriyasie 'Equipitusie 'Apüricasie Sirene temütama, Xumatari memü'ivatatüve, ");
INSERT INTO hchNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Huriyusixi, hipatü Huriyusixi memacü, Cüretatari, 'Araviyatari, tanaitü tepüva'enie me'utiniucame taniuquicü, que mütimarive Cacaüyari me'utiyuaneme. ");
INSERT INTO hchNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Yunaitü meni'iyarixiecaitüni, 'asimepücatemaicai quetütü mütiyüanecai, yuxexuitü müpaü meteyücühüavetü, Que tititari 'icü. ");
INSERT INTO hchNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Hipatü mevananaimatü müpaü meniutiyuanecaitüni, Mepuhuxa xeicüa vinu macacacü. ");
INSERT INTO hchNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Hicü Pecuru 'anucuqueca tamamata heimana xevime vahamatü, carima niutaniuni, müpaü tinivarutahüave, Neuxei Huriyusixi, yunaitü Querusareme xemütama. Xequetenemaica 'icü, xequeneneu'enie que nemütayüni. ");
INSERT INTO hchNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","'Ime mepücatarüve xeme xemütecu'erivapaü, 'esiva xeicüa tucari püxüca. ");
INSERT INTO hchNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Masi 'icü canihücütüni tita mütixasivacai, tixaxatame Cuheri ya'utainecacu, ");
INSERT INTO hchNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Müpaü paine Cacaüyari, tucari 'aye'ayu quepaucua mütaparirümeni, müpaü pütiyüni. Ne'iyari nepütatuani teüteri yunaime vahesie. Xenivema nehesie mieme mepütaniuni 'uquisi 'ucari, Xetemari hecüta heinüsipaü 'aneneme mepüxeiyani, Xe'uquiravesixi cusipa mepüteheinüni. ");
INSERT INTO hchNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Yuricü müme nemütiva'aitüa 'uquisi 'ucari vahesie Ne'iyari nepütatuani 'iya tucarisie, Nehesie mieme mepütaniuni. ");
INSERT INTO hchNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Nepüvahüxiyasitüani vaheima muyuavisie, Hetüanata cuiepa 'inüari nepütiyurieni vaücava, Xuriya, tai, 'aüxi cüsi nücame 'inüariyari. ");
INSERT INTO hchNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Tau yüvitü canayeimücü, Meserita xuriya payani. 'Arique 'upamie Ti'aitame mücü tucarisie marivemesie xavatümesie. ");
INSERT INTO hchNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","'Anarique yunaitü memihüaveni que mü'ane Ti'aitame mühücü, Müme mepütavicueisitüarieni. ");
INSERT INTO hchNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Neuxei 'Ixaherisixi, 'icü neniuqui xequene'enieca. Cacaüyari xesata pitahecüataxü Quesusi Nasaretitanaca marivemecü tiyurienetü türücaüyemecü, 'inüari tiyurienetü, 'iyacü que mütiuyuri Cacaüyari xesata que xemütemate xeme. ");
INSERT INTO hchNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Cacaüyari müpaü tiyücühüavetü, matüaripai müpaü timaitü, nicayeni müyetuiyanicü. 'Inüari sanamete xetevaruta'aitüaca xeniviya, vamamacü cüyesie xe'icavieca xecanimieni. ");
INSERT INTO hchNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Cacaüyari nenucuquetüani 'ixünaca que mürehüiyacai müquitü. 'Iya pücayüvecai müquitü muyuhayevacü. ");
INSERT INTO hchNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Raviri müpaü paine hepaüsitana, Ti'aitame nepüxeiyacai yuheyemecü nehüxie, Neserieta mutivecü nepücacuyuani. ");
INSERT INTO hchNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ne'iyarisie 'ayumieme nepünetemavi, Nenetemavietü nepütaniuni nenenicü. Sepa necaxari 'amuca, Mexi neta'icueva yuri nepüti'erie ");
INSERT INTO hchNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Quename ne'iyari peca'ucu'eirieni müquime. Que mü'ane pemupataxü 'ahesie mieme pepüca'ipitüaca mütapüne. ");
INSERT INTO hchNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Pepünesi'utamaricasitüa nemayeyurinicü. Temavierica pepünesipitüaca vaücava, nehamatü pe'uyeicatü. ");
INSERT INTO hchNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Neuxei 'ivamarixi. 'Aixüa cani'aneni heiseriemecü mütixecuxaxatüvanicü tatevari Raviri hepaüsita. Caniumüni 'iya, tiucateuqui, macateuquesie mana tiuca cuxi tasata hicüque. ");
INSERT INTO hchNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Tixaxatame hücütütü catinimaicaitüni quename Cacaüyari 'üyühüritüa heiseriemecü müpaü 'utaitü, xevitü Ravirisie müyeyaniquecai heiserie püpitüarieniquecai Cürisitutütü, picayeniquecai 'uvenieya müra'aitasie haitü. ");
INSERT INTO hchNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Matüaripai 'ixeiyatü müpaü caniutayüni, Cürisitu que müranucuque ticuxatatü, müpaü 'utaitü, 'Iyarieya püca'ucu'eirivaxü müquitü, Vaiyarieya püca'utapünixü. ");
INSERT INTO hchNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Mericüsü Cacaüyari penucuquetüa 'iya Quesusi. Tame tanaitü tepühüme temunenierixü temitahecüata. ");
INSERT INTO hchNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","'Anutivitüquieca Cacaüyari serieta, nitanaqui'erieni tita 'uquiyarieya mütitahüavixü mütipitüaniquecai, 'Iyari Mütiyupata hücütüme. Mücü niutatuani que xemüte'ixeiya que xemüte'i'enie. ");
INSERT INTO hchNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Mücü Raviritütü püca'anutitüa muyuavisie, siepüre müpaü paine, Ti'aitame müpaü tinitahüave 'iya müneti'aitüva, Neserieta mexicuxi quenacani ");
INSERT INTO hchNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Müme memümasi'aca'unie nemüva'atüani 'ahetüa. ");
INSERT INTO hchNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Heiseriemecü 'ipaü xequetenemaica yunaitü 'Ixaheri quie quiecatari. Cacaüyari Ti'aitame payeitüa 'icü Quesusi, heiserie canipitüani que mü'ane xemumi curuxisie. ");
INSERT INTO hchNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Mericüsü me'u'enanaca yu'iyarisie mepühiveritüariecai. Müpaü metenivarutahüave Pecuru hipame nü'arisixita, ");
INSERT INTO hchNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Que teteyurieni ta'ivama. Pecuru müpaü tinivarutahüave, Xequeteneuhayeva que xemüteyurie, yuxexuitü xepüca'üyarieni Quesusi Cürisitu xehüavetü. Tita 'axa xemüte'uyuri, xepüteheuyehüviyarieni. Xepütemiquieni 'Iyari Mütiyupata. ");
INSERT INTO hchNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","'Icü que mutayü que mütiyurieni niuquieya xehesie pümieme, xetüriyama vahesie timiemeta, yunaime teva miemete vahesie timiemeta, müme müvata'inieni Ti'aitame tacacaüyari vahesie timiemeta. ");
INSERT INTO hchNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Hipame müireme niuquicü püvarutahecüasitüiyaxü, nivavaviriecaitüni müpaü 'utaitü, Xequeneyutavicueisitüa hicü miemete 'axa memüte'u'iyari vasata. ");
INSERT INTO hchNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Hicü müme niuquieya memutanaqui'eri meniuca'üyarieni. Mepüvarutinüi mücü tucarisie teüteri haica miriyari yacütütü. ");
INSERT INTO hchNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Yamepü'ayumiemetetücai tita nü'arisixi memüte'üquitacai me'enietü meyuparevietü me'ititaratü pa meyunenevietü. ");
INSERT INTO hchNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Hicü yuxexuitü yu'iyarisie meheumamatü menacüne. Vaücava mamarivavame 'inüari meteniyuriecaitüni nü'arisixi. ");
INSERT INTO hchNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Yunaitü yuri memüte'uta'eri meniyuteütacaitüni yunaitü meyuxevitü, 'axeicüa mepeixeiyacai naime. ");
INSERT INTO hchNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Yucuie yupinite mepüte'utua, mepüvapitüacai yuxexuitü que memüteheiyehüacai. ");
INSERT INTO hchNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Tucaricü yamepü'ayumiemetetücai mepüyuxeüriecai tuqui curaruyarita. Mepititaracai pa qui meuti'uta, yu'inüa meputicuai meyutemamavietü 'aixüa mete'u'iyaritü. ");
INSERT INTO hchNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Meputiniucacai Cacaüyari hepaüsita 'aixüa me'utiyuatü. Yunaitü teüteri 'aixüa mepütecu'erivacai vahepaüsita. Tucaricü Ti'aitame püvaxeüriecai müme memütavicueisitüarieximecai vaxeviriyatü. ");
INSERT INTO hchNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Mericüsü Pecuru Vanimatü meneuticüne tuquipa cüa caviecacu tau quepaucua müyuneneviva. ");
INSERT INTO hchNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","'Uqui hurietü mutinuivaxü mana ni'atüarivacaitüni. Tucaricü menitiyesacaitüni tuqui quitenie Visi Mü'ane müracutevasie. Mana rimusina püvavaviriecai müme tuquita memeutahaquecai. ");
INSERT INTO hchNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Varuxeiyaca Pecuru Vani tuquita meheutahaxüaximecacu, rimusina püvavaviriecai. ");
INSERT INTO hchNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pecuru 'ixeiyatü, Vanita, müpaü Pecuru tinitahüave, Quetaneuxeiya. ");
INSERT INTO hchNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Mücü nivaruxeiya tixaü mete'iminiqueme 'erietü. ");
INSERT INTO hchNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Müpaü niutayüni masi Pecuru, Ni pürata tuminiyari ni huru tuminiyari nepücahexeiya. Tita nemürexeiya, mücü nepümatimini. Quesusi Cürisitu Nasaretitanacasüa nemümiemecü nepaine, quenanucuquexi quenecuyeicani. ");
INSERT INTO hchNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Serietana 'iviyaca mamayasie nenucuhana. Yapaucua niutiserire 'ücateya turuteya. ");
INSERT INTO hchNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","'Anucusunaca niutaqueni, nicuyeicacaitüni. Vahamatü neutahani tuquita cuyeicatü 'utisucuacatü 'aixüa 'utaitü Cacaüyari hepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Yunaitü teüteri menixeiya 'uyeicame 'aixüa 'utaineme Cacaüyari hepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Meneitimani quename mücü hücütücai que mü'ane mutiyeixacai rimusinavietü tuqui quitenie Visi Mü'ane müracutevasie. Mepühüxiyacai mepü'iyarixiecai müya mütiuyücü. ");
INSERT INTO hchNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Hicü mücü tevi nivaruviya Pecuru Vanimame. Teüteri me'unausarümetü mehüxiyatü vahesüa mepu'axüa Sarumuni Nivetarieyatüa mütiuyetevasie. ");
INSERT INTO hchNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pecuru varuxeiyaca müpaü tinivarutahüave teüteri, Neuxei 'Ixaherisixi, titayari xetehüxiya 'icücü. Titayari xetatexeiya müpaü xetecu'erivatü, tatürücariyacü Cacaüyari cui temayexeiyacü nusu 'uyeicame temeyeitüa 'icü. ");
INSERT INTO hchNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","'Apurahami 'Isahaqui Cacuvu vacacaüyari tatevarima müvacacaüyari mariveme nayeitüani yunive Quesusi. 'Iya xepüyetua xepitixani'eri Piratu hüxie quepaucua mücü mixünaquecai. ");
INSERT INTO hchNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Xeme masi xepitixani'eri que mü'ane mupasie Cacaüyarisie mieme que mü'ane heiserie mexeiya, xepitavaviri tiyumemivame püta müxünarienicü, ");
INSERT INTO hchNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","tucari tiyupitüvame xepumi. Cacaüyari nenucuquetüani müquite vasata. Tame tepühüme temunenierixü temihecüata. ");
INSERT INTO hchNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Yuri mütiuta'ericü que mü'ane mühücüsie, mücü 'ayumieme pitiseraxü 'icü xemüxeiya xemimate. Yuri que müti'erie Quesusi 'ipareviecacu, müpaü naime 'aixüa reu'eriecame neyeitüani yunaime xehüxie. ");
INSERT INTO hchNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Hicütütüri ne'ivamarixi, ne nepütimate xeme müpaü xepüte'uyuri 'asixecatemaitü, xe'uquiyarima vahepaü. ");
INSERT INTO hchNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Cacaüyari meripai müpaü putayücai yunaitü texaxatametemama müpaü me'utiyuanecacu, quename Cürisitu ticuinequecai que mü'ane Cacaüyari heiserie mipitüaniquecai. Müpaü tinaye'atüani. ");
INSERT INTO hchNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","'Ayumieme xequeteneuhayeva que xemüteyurie, ta'aurie xequenaxürieca manuyeitüarienicü tita 'axa xemüte'uyuri, xehesüa 'uxipiya maye'anicü Ti'aitamesüa mieme, ");
INSERT INTO hchNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","menü'anicü mücü Cürisitu que mü'ane xehesie mieme mucayeri, Quesusi heiserie mupitüari. ");
INSERT INTO hchNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Peuyevese mütanaqui'eriyani taheima mexi tucari ca'aye'ave quepaucua 'aixüa mütiyurieni naime, que müticuxatacai Cacaüyari, texaxatametemama hesiena mieme memupasie meripai miemete yame'utiyuanecacu. ");
INSERT INTO hchNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Muisexi müpaü pütivarutahüavixü tatevarima, Ti'aitame müxecacaüyari tixexaxatüvame payeitüani xeime xe'ivama vasata mieme nehepaü 'aneme. Xeme xepi'enieca nai que mütixetahüave. ");
INSERT INTO hchNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Que mü'ane müca'i'enieni mücü tixaxatame, teüteri vasata pü'unierieca. ");
INSERT INTO hchNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Camüsü yunaitü texaxatamete, Samueri meri, 'arique yuxexuitü quemeyupaümetü memütecuxaxatacai, 'icü tucari hepaüsita metenihecüatacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Xeme texaxatamete xepüvanivema. Xehesie catiniunaque 'iya türatu Cacaüyari mitavevi xetevarima vahamatü. Cacaüyari müpaü tinitahüave 'Apurahami, Que mü'ane 'ahesie müyeyani 'aixüa nivayuriemücü nuivarite cuiepa miemete yunaime. ");
INSERT INTO hchNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Mericüte, Cacaüyari 'enucuquetüaca yunive, peiyenü'a xehesie mieme meri 'aixüa müxeyurienicü, yuxexuitü ta'aurie xemaxürienicü tita 'axa xemüteyurie xetecu'eirieme. ");
INSERT INTO hchNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Mericüsü metevacuxaxatüvacacu cuxi teüteri, yapaucua vahesüa meniu'axüani mara'acate, tuqui mühüritüariematü Saruseusixi vahamatü ");
INSERT INTO hchNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","meha'atü Pecuru Vani memüteva'üquitüacaicü teüteri, memüvahecüatüacaicü müquite vasata que müranucuqueni me'utiyuatü Quesusi mexatatü. ");
INSERT INTO hchNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Mepüvarutiviyaxü, mepüvaranutaxüri 'uxa'ariecaque mucutaicairixücüri. ");
INSERT INTO hchNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Yumüiretü memi'eniecai niuqui yuri mepüte'uta'erie. 'Uquisi 'auxüme miriyari yacütütü meyupaümetü mepacü. ");
INSERT INTO hchNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Hicü 'uxa'arieca Querusaremesie mepüyucuxeüri va'uquiyarima, 'uquiravesixi, müme 'inüari niuquiyaricü memüte'üquitametetücai, ");
INSERT INTO hchNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","mücü meta, 'Anasi mühüritüariecai mara'acate vahepaüsita, Caipasi, Vani, Herecanuturu, yunaitü mara'acate memühüritüariecai vaquie miemete. ");
INSERT INTO hchNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Mana yuhixüapa mevati'uitüaca mecanivaruta'ivaviya 'ipaü me'utiyuatü, Que 'aneme türücariya xehexeiyatü, que mü'anesüa xemiemetütü müya xepüteyurie xeme. ");
INSERT INTO hchNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Hicü 'Iyari Mütiyupatacü hünetü müpaü tinivarutahüave Pecuru, Neuxei teüteri va'uquiyarima 'uquiravesixi xemü'ixaherisixi, ");
INSERT INTO hchNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","'icü tucarisie tepüta'ivaviyariexime 'aixüa temiyuricü tevi ticuicame, que mütiuvicueisitüarie 'icü. ");
INSERT INTO hchNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Siepüre xequetenemaica yunaitü, yunaitü teüteri 'Ixaherisixita yamequetemaica, Quesusi Cürisitu Nasaretitanacasüa mümiemecü, mücüsie tiviyatü 'icü 'ena puve xehüxie 'aixüa reu'erietü. Curuxisie xepicavi Quesusi, Cacaüyari nenucuquetüani müquite vasata. ");
INSERT INTO hchNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","'Icü tete canihücütüni xemixani'eri qui vevivamete, tete 'amünena sicurita mieme canayani. ");
INSERT INTO hchNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Xevitüta 'apüca'uyeica tasitavicueisitüvame. Ni xevitü püca'ucayerie muyuavitüa tame teüteri tasata cümana temütavicueisitüarienicü, mücü xeicüa pucayerie. ");
INSERT INTO hchNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Mericüsü menivaxeiyacaitüni Pecuru Vanimame mecamamacame. Müpaü metenimaicaitüni hasuacua memücateyü'üquitüacaicü müme, tixaü memücatehümetücaicü. Menihüxiyacaitüni, menivaretimani Quesusimatü que memüte'u'uvacai. ");
INSERT INTO hchNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Me'ixeiyatü mücü 'uqui manayehüiya va'aurie 'uveme, mepücayüvavecai memüvaniuquimanicü. ");
INSERT INTO hchNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Mericüsü mevaruta'aitüaca memanuyecünecü 'isücate vahesüa, mecaniuyu'enieni ");
INSERT INTO hchNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","müpaü me'utiyuatü, Quesü teteyurieni 'icü teüteri vahepaüsita. Yuricü vacümana 'inüari püreyü, yunaitü que memütemate, que mütimasiücü yunaitü Querusareme memütama vahüxie. Tame tepücayüvave müpaü temutiyuanenicü quename 'asicatiuyü. ");
INSERT INTO hchNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Mericüte, tavari capa cuxasivanicü teüteri vasata, cümü türücaüyemecü tepüvahüritüani 'uxa'atüni varie 'iyasüa memiemetetütü memüca'icühüavenicü xeimeri. ");
INSERT INTO hchNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Yuhesüa mevarutahüaveca yemecü mecanivaruta'aitüani tixaü memücatecuxatanicü memücateti'üquitanicü Quesusisüa memiemetetütü. ");
INSERT INTO hchNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pecuru Vanimatü müpaü metenivaruta'eiya, Xequeteneuta'inüata xeme xüca heiseritüni Cacaüyari hüxie temüxe'enienicü, Cacaüyari püta temüca'enienicü. ");
INSERT INTO hchNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Mesü tepücayüvave temütehayeva tetecuxatatü tita temüte'uxei tita temüte'u'eni hepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Müme tavari yametevaruta'aitüaca menivarutatuani. Tixaütü mepücate'ucaxei memüva'uximatüacacü teüteri vacü, yunaitü 'aixüa memutiyuanecaicü Cacaüyari hepaüsita mete'utamarieca que mütiuyü. ");
INSERT INTO hchNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","'Iya tevi huta teviyari heimana yapaümeme viyari pexeiyacai mücü 'inüaricü manayehüiya. ");
INSERT INTO hchNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Mericüsü me'uxünarieca meniu'axüani yuteüterima vahesüa. Mecanivarutahecüatüani nai que memütevacühüavecai mara'acate memühüritüariecai 'uquiravesixi vahamatü. ");
INSERT INTO hchNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Müme mevaru'enieca 'axeicüa müpaü metenitahüave Cacaüyari, Nai Ti'aitame 'ecü Cacaüyaritütü muyuavi peputavevi, cuie haramara naime vahesie mütitama petiutivevi. ");
INSERT INTO hchNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Müpaü peniutayüni mücü pemüti'aitüacai Raviri tatevari yutetacü müpaü ticuxatacacu, 'a'iyari Mütiyupata ya'utainecacu, Titayari meteyuxamurie teüterixi, Titayari xüanacüa metecu'eriva nuivarite. ");
INSERT INTO hchNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Cuiepa memütama teva'aitüvamete xurucu mepu'ucai, Va'uquiyarima 'axeicüa mepuyucuxeüri Ti'aitame me'aye'unietü, Que mü'ane heiserie mipitüa Cürisitutüme me'aye'unietü. ");
INSERT INTO hchNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Tamüsü 'anive 'ahesie mieme mupasie Quesusi hepaüsita que mü'ane heiserie pemipitüa hepaüsita, yuricü mepuyucuxeüri 'icü quiecarisie Herurexi Punisiyu Piratu teüteri memücahuriyusixiri 'Ixaherisixiri teüteriyari yunaitü. ");
INSERT INTO hchNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Meniyucuxeürie yameteyurienique tita 'amamacü pemütiyurieniquecai meripai pemüti'acühüavecaicü que mütiyüniquecai. ");
INSERT INTO hchNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Hicürixüa Ti'aitame quenivaruxeiya 'axa que memutiyuane, quetatineupitüa tame pemütati'aitüa tixaü tecaheumamatü temütecuxatanicü 'aniuqui hepaüsita, ");
INSERT INTO hchNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","'ecüta 'amama queneutasera teüteri memanayexüriyanicü 'inüarite petiyurienecacu mamarivaveme petiyurienecacu mücü 'anive 'ahesie mieme mupasie Quesusisüa temümiemetecü. ");
INSERT INTO hchNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Hicü me'uyutaneneviecu mana niutayuani memayuxeüriesie. 'Iyari Mütiyupatacü meniutihüne yunaitü, Cacaüyari niuquieya menicuxatacaitüni mecamamatü. ");
INSERT INTO hchNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Queyupaümetü yuri memüte'uta'erie va'iyari caniyuxevicaitüni, yaxeicüa mepüte'u'iyaricai. Ni xevitü 'asipücahainecai yupini mütipinieyatücai, masi naime 'axeicüa metenexeiyacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Cui türücaüyemecü nü'arisixi mecatenihecüatacaitüni Ti'aitame Quesusi hepaüsita que müranucuque. 'Aixüa yemecü meteniu'iyaricaitüni yunaitü. ");
INSERT INTO hchNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Tixaü pücareuyehüacai xevitü müme. Yuxexuitü cuie, qui nusu, memexeiyacai meneituacaitüni, que memüteheitua tuminiyari meni'atüvacaitüni, ");
INSERT INTO hchNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","nü'arisixi vahetüa menitimana. Menivapitüacaitüni yuxexuime que memüteheiyehüacai. ");
INSERT INTO hchNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Mericüsü Cuse, nü'arisixi meteniterüva Verunave, taniuquicü Titutuicame maine. Mücü pürevitatücai, Sipüresie petinuivaxü. Mücüta cuie pexeiyacai. ");
INSERT INTO hchNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Heituaca, que müreitua menu'üi, ni'atüani, nü'arisixi vahetüa nitimana. ");
INSERT INTO hchNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Mericüsü 'uqui Hananiya mütitevacai yü'üitatü Sapiramatü mecaneituani cuie. ");
INSERT INTO hchNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Yuhesie mieme 'esiva niyuhayevieni que müreitua, 'üyayata yatimaicacu. Hipame pü'atüa, nü'arisixi vahetüa pitimanaxü. ");
INSERT INTO hchNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Hicü Pecuru müpaü tinitahüave, Neuxei Hananiya, titayari Cauyumarie 'a'iyari tinü'ü, pemüti'itai 'Iyari Mütiyupata, yapaümeme pemeucu'üicü cuie pemetuasie mieme. ");
INSERT INTO hchNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Süricüte quepaucua mü'acuietücai catini'apinitücaitüni. Peheituaca heiserie pepexeiyacai cuxi hepaüsitana. Titayariri 'a'iyarisie peti'acühüave 'ipaü. 'Ecü teüteri pepücativaru'itai, Cacaüyari püta pecatiniu'itaiya. ");
INSERT INTO hchNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Hicü 'icü niuqui 'u'enieca Hananiya, 'ativeca pumü. Mepümamacai yemecü yunaitü memu'enanaxü. ");
INSERT INTO hchNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Me'anucu'uca 'uquisi me'icu'eimaca mepeicuei me'icateucuque. ");
INSERT INTO hchNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Hicü haica hurayari yacütütü 'aye'acu 'üyaya caninuani 'asicatimaitü que mütiuyü. ");
INSERT INTO hchNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pecuru müpaü tinitahüave, Yaquenetineutahüavi, yucuie yapaümemecü xüca xeheituani. 'Iya müpaü tinitahüave, 'Eri, müpaü canipaümecaitüni. ");
INSERT INTO hchNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Pecuru müpaü titahüave, Titayari xete'uyu'eni 'ipaü xemüte'i'isipacacü Ti'aitame 'Iyarieya. Neuxei 'acüna teucumete mana meniuti'uca quiteni 'aurie. Mecamananucueicunita 'ecü. ");
INSERT INTO hchNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Yapaucua canativeni hetüana, tiumü. 'Uquisi meheutahaxüaca mepicaxei müquime. Meheicueca mecaneicuteucu cünaya 'aurie. ");
INSERT INTO hchNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Vaücava mepümamacai yunaitü memüyuyexexeürivacai, yunaitü memi'eni 'icü. ");
INSERT INTO hchNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Mericüsü nü'arisixi vamamacü vaücava 'inüarite mamarivaveme tiniuyüni teüteri vahüxie. Yunaitü 'axeicüa meniu'uvacaitüni Sarumuni Nivetarieyatüa. ");
INSERT INTO hchNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Hipatüri memamatü vahesie mepücateviyacai. Siepüre teüteri yemecü 'aixüa meniutiyuanecaitüni vahepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Yumüiretü meniyucuxexeürivacaitüni yuri mete'uta'erieca Ti'aitamesie 'uquisi 'ucari. ");
INSERT INTO hchNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Müpaürita caye 'utüa meputuarieximecai tecuicuicate 'utasie 'isisie me'aheitü, Pecuru siqueresü 'etürieya siparasü maye'ani vahesie xeime 'anuyenecacu. ");
INSERT INTO hchNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Yumüiretüta Querusareme hura quiecatari meni'axecaitüni mevaravitütü tecuicuicate, cacaüyarixi 'axa memü'anene memüva'uximatüacai vahamame, yunaitü mepanayexüri. ");
INSERT INTO hchNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Hicü me'anucu'uca mara'acame mühüritüariecairi, yunaitüri 'auriena memu'uvacai memütecu'erivacai Saruseusixi memütecu'erivapaü, müme meni'uxiva'acaitüni. ");
INSERT INTO hchNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Mecanivarutiviya nü'arisixi, mepüvaranutaxüri casariyanata. ");
INSERT INTO hchNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ti'aitame niuquieya tuayame tücaricü püreuyepiexü casariyanata. Püvaranuyevitü müpaü 'utaitü, ");
INSERT INTO hchNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Xequenehu, tuqui curaruyarita xequenaye'uca. Xequetenivacuxaxatüvani teüteri naime que mütixasiva tevi 'ipaü tucari que mürexeiyani hepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Me'i'enieca meneutahaxüani tuquita tuxacüta. Mana meteni'üquitacaitüni. Mara'acame mühüritüariecai, müme 'auriena memu'uvacai me'u'axüaca menivarucuxeürieni 'isücate yunaime 'Ixaheri xiüyarimama va'uquiyarima. Mepüvarenü'a tupirisixi casariyanapai memüva'atüanicü. ");
INSERT INTO hchNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Tupirisixi me'u'axüaca mepücavaretaxei casariyanata. Ta'aurie mepaxüri, metenivarutahecüatüani ");
INSERT INTO hchNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","müpaü me'utiyuatü, Panasi casariyana tepetaxei 'aixüa renacame, tehüvemete mepeti'ucai quitenie 'aurie, perusü teteheuyepieca xeime tepücahetaxei quita. ");
INSERT INTO hchNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","'Aruvasini tuquita miemete tupirisixi tiva'aitüvame, mara'acate memühüritüariecaita mepüvaru'enie 'icü vaniuquicü. 'Asimepücatemaicai vahepaüsita que mütiuyü. ");
INSERT INTO hchNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Xevitü nuaca tinivarutahecüatüani müpaü 'utaitü, Neuxei müme 'uquisi xemüvaranutaxüri, müme tuqui curaruyarita mepaye'u meteva'üquitüatü teüteri. ");
INSERT INTO hchNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","'Ana 'aruvasini petüa tupirisixi varavitütü. Menivarayevitüni siepüre carima mecavaravitütü, memüvamacarücaicü teüteri capa mevarutituaxacü tetecü. ");
INSERT INTO hchNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Mericüsü meva'atüaca menivaruti'uitüani 'isücate vahüxie. Mara'acame mühüritüariecai nivaruta'ivaviya ");
INSERT INTO hchNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","müpaü 'utaitü, Tamesü cuini mieme tecatexe'uta'aitüa xemücate'üquitanicü mücüsüa xemiemetetütü. Camüsü, Querusareme xepüte'utihüniyaxü yü'üquisicacü. Xeme tahesie xepüte'ahüpaniqueyu 'iya tevi xuriyayacü. ");
INSERT INTO hchNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pecuru nü'arisixi vahamatü mevacu'eiyatü müpaü metenivarutahüave, Püreuyevese siepüre temi'enienicü Cacaüyari, teüteri sepa temücava'enieni. ");
INSERT INTO hchNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Tatevarima vacacaüyari nenucuquetüani Quesusi xeme xemimi cüyesie xe'icavivatü. ");
INSERT INTO hchNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Cacaüyariri Ti'aitame Tiyuvicueisitüvame nanutivitüni yuserieta, müxepitüanicü 'Ixaherisixi xemütehayevanicü que xemüteyurie, tita 'axa xemüteyurie xemüteheuyehüviyarienicü. ");
INSERT INTO hchNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Tame tecanihümetüni temunenierixü temütehecüata 'icü que mütiuyü hepaüsita. Müpaüta tinihecüatani 'Iyari Mütiyupata Cacaüyari müvarupitüa müme memi'enie. ");
INSERT INTO hchNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Müme me'u'enanaca meniuyeha'ani menivacuicucaitüni. ");
INSERT INTO hchNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Hicü xevitü 'anucuqueca memayuxeüriesie Pareseu mühücütücai, Camarieri mütitevacai, 'inüari niuquiyari ti'üquitameya mühücütücai, ve'eme memü'eriecai yunaitü teüteri, mücü tivaruta'aitüaca memüvaranuyenü'anicü mücü teüteri yareutevicacu, ");
INSERT INTO hchNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","müpaü tinivarutahüave, Neuxei 'Ixaherisixi, yumarima 'aixüa que xemüteyurieni 'icü teüteri vahepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Meripai panucuque Teuraxi, ya'utaitü quename yüvemetücai. Nauca sienituyari 'uquisi yacütütü hesiena mecateniviyacaitüni. Mücü pumierie, yunaitü memi'eniecai mepeutaxüriexüa, tixaü mepücate'acü. ");
INSERT INTO hchNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","'Arique nanucuqueni Cura Carereyatanaca quepaucua memacayasarie. Teüteri yumüireme canivarevitüni yu'utüma. Mücüta pu'unieriecai, yunaitü memi'eniecai mepeutayeixüa. ");
INSERT INTO hchNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Hicüri nepaine, xequenivaruhayeva 'ime teüteri, xequenivarutixüna. Que memütecu'eriva que memüteyurie xüca teüteri vahesüa miemetüni cani'unieriecamücü. ");
INSERT INTO hchNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Mesü xüca Cacaüyarisüa miemetüni püta, xepücayüvaveni xemeye'unie tietüsü Cacaüyari xe'aye'unieca. ");
INSERT INTO hchNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Mericüsü meni'enieni. Yuhesüa mevarutahüaveca nü'arisixi mevarutivaca müpaü metenivaruta'aitüani memücatiniunicü Quesusisüa memiemetetütü. Menivarutixüna. ");
INSERT INTO hchNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","'Isücate vahesüa menivayenexüani meyutemamavietü Cacaüyari meyüvaveme müva'eriecaicü memütave'erivanicü hesüana memümiemetetücaicü. ");
INSERT INTO hchNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Tucaricü tuquita yuquiteta mepücatehayevacai mete'üquitatü metecuxatatü niuqui 'aixüa manuyüne quename Quesusi heiserie hexeiya Cürisitutütü me'utiyuatü. ");
INSERT INTO hchNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Mericüsü 'ana mepütetamüiriyarümecai teyü'üquitüvamete. Müme Cüriyecusixi vaniuquicü memutiniucacai mepüniuquixiecai müme Hepürayusixi vaniuquicü memutiniucacai vahepaüsita, viyurasixi vahesüa miemete memüvaratümaiyacaicü tucaricü quepaucua memüvapareviecai. ");
INSERT INTO hchNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Tamamata heimana yuhutatü mevarucuxeürieca teyü'üquitüvamete müpaü mecatenivarutahüave, 'Aixüa püca'aneniqueyu tame Cacaüyari niuquieya xüca tehayevaque mexasie temüte'apinenicü püta. ");
INSERT INTO hchNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Hicü ta'ivama, xequenivacuvava yusata 'uquisi 'atahutame 'aixüa memütehecüasie 'Iyaricü memühüpüne memütemaivave. Müme tepüvahüritüani 'icü hepaüsita que müreuyevese. ");
INSERT INTO hchNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Tamesü tetanenevietü niuquicü texeparevietü tepü'ayumiemetetüni. ");
INSERT INTO hchNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Mericüsü 'icü niuqui püvanaquecai yunaitü memüyucuxeüri. Mepüvaranuyexei 'Esitevani, 'uqui yuri müti'eriecai 'Iyari Mütiyupatacü mühünecai, Piripe, Purucuru, Nicanuri, Timuni, Parumenaxi, Nicuraxi Huriyu mayuyeitüa 'Anutiyuquiyatanaca. ");
INSERT INTO hchNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Mepüvaruti'uitüa nü'arisixi vahüxie. Müme meyunenevietü yametenivaruhüritüani vaheima me'utimetü. ");
INSERT INTO hchNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Mericüsü Cacaüyari niuquieya niutixuavere. Teyü'üquitüvamete mepütetimüiriyarümecai vaücava Querusaremesie. Mara'acate yumüiretü mepu'enana yuri mete'erietü. ");
INSERT INTO hchNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Mericüsü 'Esitevani 'aixüa tiuca'iyaritü türücaüyemecü tiyurienetü vaücava tiniyurienecaitüni teüteri vasata, 'inüari mamarivaveme tiyurienetü. ");
INSERT INTO hchNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Hicü tuqui 'epuvecai Xünariecate Sirenetari Herecanütüreyatari Vatuqui titevatü. Mana miemeteri, Sirisiya 'Asiya miemete vahamatü mepanucu'ui mehe'ivarümetü niuqui mexüatüatü 'Esitevanimatü. ");
INSERT INTO hchNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Mepitexiecai que müticuxatacai mütimaivecaicü, 'Iyari mipareviecaicü. ");
INSERT INTO hchNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Mepüteva'aitüacai 'uquisi memütecuxatanicü 'ipaü, Tame tepi'enie 'axa 'utaineme Muisexi hepaüsita Cacaüyari hepaüsita me'utiyuatü. ");
INSERT INTO hchNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Mepüvaxamuriecai teüteri, 'uquiravesixi, müme 'inüari niuquiyaricü memüte'üquitacai. Yapaucua me'u'axüaca meniviya, meneivitüni 'isücate vahesüa. ");
INSERT INTO hchNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Mana mepüvaruti'uitüa hipame memütehecüatanicü mete'itavatü yame'utiyuatü, 'Icü tevi pücatihayeva 'axa 'utaitü 'icü 'ena Cacaüyarisie mieme mupasie hepaüsita, ta'inüari niuquiyari hepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Tepi'enie müpaü 'utaineme quename 'icü Quesusi Nasaretitanaca 'i'unieca 'icü 'ena, quename 'ipata tayeiyari Muisexi mütasi'upitüa. ");
INSERT INTO hchNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Me'i'ixüarietü yunaitü mana memütitecai memayuxeüriesie, mecanixeiya niericaya taheima mieme niuqui tuayame niericayapaü 'aneme. ");
INSERT INTO hchNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Mericüsü mara'acame mühüritüariecai müpaü niutayüni, Müpaü ti'ane 'icü. ");
INSERT INTO hchNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","'Iya rehüave, Neuxei 'ivamarixi, 'uquiyarima, xequeneu'enana. Tatevari 'Apurahami 'ixeiyacacu Cacaüyari visi mü'ane masiücütü nayuyeitüani Mesuputamiyasie 'uyeicacacu Haranisie caheta'avetü cuxi. ");
INSERT INTO hchNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Müpaü tinitahüave Cacaüyari, Quenemie 'ena 'acuiepa 'amarema vahesüa, cümü mücü cuieyarisie nemümasihetamaricasitüani quenemie. ");
INSERT INTO hchNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Mericüsü Cariteyusixi vacuie heyeyaca Haranisie niucayerüni. Manata quemasieya 'umücu Cacaüyari nipata 'icü cuiepa haque xeme'uva hicü. ");
INSERT INTO hchNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Cacaüyari püca'imi 'ena mütinaqueni ni yü'ücacü mücataquenicü, masi Cacaüyari müpaü tinitahüave quename 'ipitüaniquecai mücü, pinieya mürayanicü, 'arique hesiena memüyecünequecaita vapini mürayanicü, sepa yunive mücahexeiyacai cuxi. ");
INSERT INTO hchNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Müpaü tinitahüave Cacaüyari, 'Atevarima cu'uvamete mepacüne hipame vacuiepa. Mepüteta'uximayasitüarieni vaüriyarica. Nauca sienituyari viyari meniyuriecuni 'axa me'itüarietüvetü muva. ");
INSERT INTO hchNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Necanivataxanetamücü 'iya nuivari vaüriyarica memütevata'uximayasitüani. Müpaü niutayüni Cacaüyari, 'Ariquemücaque menayecünicuni, ne'uximayasica menexeiyacuni 'ena. ");
INSERT INTO hchNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Xitequiya 'inüariyari 'ipitüatü nitavevirieni türatu. Müpaüri yüanecacu 'Apurahami nitinuivitüani 'Isahaqui. 'Atahairieca tucarisie pi'inüaritaxü 'ixitetü, 'Isahaquita müpaü piyuri Cacuvu, Cacuvuta müpaü tivaruyuri tamamata heimana yuhutame tatevarima. ");
INSERT INTO hchNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Müme tatevarima me'ita'uxieca Cuse menituani 'Equipitusie manuvitüquienicü. Cacaüyari hamatüana puyeicacai. ");
INSERT INTO hchNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Nitavicueisitüani nai que müti'uximatüariecai, pipitüa 'aixüa mütixeiyarienicü mütimaivenicü Parahuni hüxie 'Equipitutari mütiva'aitüvametücai hüxie. Mücüri 'isücame neyeitüani Cuse 'Equipitu cuieyari hepaüsita naime yuquita mieme hepaüsita 'ihüritüatü. ");
INSERT INTO hchNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Mericüsü pühacaxatücai naisarie 'Equipitusie Cananisie, me'uximatüarieximecacu vaücava. 'Icuai mepüca'ucaxexeiyacai tatevarima. ");
INSERT INTO hchNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","'U'enaca Cacuvu quename 'icuai hexuavecai türicutütü 'Equipitusie, canivarenü'ani tatevarima heiva. ");
INSERT INTO hchNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Hutarieca me'u'axüacu Cuse puyuhecüataxü yu'ivama vahüxie. Parahunita canivaretimani Cuse maremama. ");
INSERT INTO hchNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Cuse tiutanü'aca nivaruta'inieni yuquemasi Cacuvu yunaime yumarema haica teviyari heimana tamamata heimana 'auxüvitü meyupaümeme teüteri. ");
INSERT INTO hchNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Mücü Cacuvu caneyani 'Equipitusie. Mana canemüni, tatevarima mana mecanecuinita. ");
INSERT INTO hchNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Mana mepayevitüqui Siquemisiepai, mepucateuquiexüa teuquiyapa 'Apurahami minanai pürata tuminiyaricü 'Emuri nivemama Siquemitari me'ituiriecu. ");
INSERT INTO hchNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Mericüsü 'ayehuracacu mücü tucari maye'atüarienicü tita Cacaüyari yühüritüatü mütitahüavixü 'Apurahami que mütiyünequecai haitü, mücü teüteri mepütetimüiriyarümecai 'Equipitusie. ");
INSERT INTO hchNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","'Anari panucuque xevitü 'Equipitutari tiva'aitüvametütü. Mücü püca'imaicai Cuse. ");
INSERT INTO hchNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Mücü cuiepa ti'aitame tateüterima pütivacuamanacai. 'Axa püvaruyuri tatevarima 'üsita memüvarecu'eirienicü yutüriyama, capa meyutinuivitüaxüanicü. ");
INSERT INTO hchNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Mericüsü 'ana caniutinuiva Muisexi. Visi pü'anecai Cacaüyari hüxie. Mücü haica meseri puverecai yu'uquiyari quie. ");
INSERT INTO hchNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Quepaucua mucu'eirivaxü, Parahuni nu'aya nicaxeiya 'ucatütü, yunivepaü pitaveriyaxü. ");
INSERT INTO hchNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Püti'üquitüarie Muisexi naime que memütemaivavecai 'Equipitutari yatimaitü. Que mütiniuvecai que mütiuyuri püyüvemetücai. ");
INSERT INTO hchNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Mericüsü huta teviyari viyari hexeiyatü puyuvaüri müva'ivatamiecü yu'ivama 'Ixaheri xiüyarimama. ");
INSERT INTO hchNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","'Ixeiyatü xeime 'axa 'itüariecame, heimana niutanuani, 'aixüa pütiuyuri hesiena mieme, pimi 'Equipitutanaca. ");
INSERT INTO hchNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Müpaü tinicu'erivacaitüni quename 'ivamama metemaicaquecai Cacaüyari que mütivatavicueisitüaniquecai 'iya vapareviecacu. Mümesü müpaü mepücatemaicai. ");
INSERT INTO hchNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Mericüsü 'uxa'arieca menixeiya teyucucuyamete. Nivanütüamücücaitüni 'aixüa memüteyuxeiyanicü müpaü 'utaitü, Neuxei, xeme xecaniyu'ivamaca. Titayari 'axa xeteyuyurie. ");
INSERT INTO hchNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Que mü'ane yu'iva 'axa müyurienecai penuyehüa Muisexi müpaü 'utaitü, Quepaicü tati'aitüvame ta'isücame pümasi'acaye 'ecü. ");
INSERT INTO hchNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Cauca penesimiemücü neta, tacai pemütimipaü 'Equipitutanaca. ");
INSERT INTO hchNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Hicü 'i'enieca mücü niuqui niyuta'una Muisexi. Cuyeicame nayani Mariyani cuieyarisie. Mana meniutinunuiva nivemama yuhutatü. ");
INSERT INTO hchNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Mericüsü huta teviyari viyari 'anuye'acu, macumavesie canixeiya niuqui tuayame taipa 'uveme tupiriya matitatavecaisie yemuri 'aurie Sinahi mütitevasie. ");
INSERT INTO hchNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Mücü Muisexi 'ixeiyaca heinüsicapaü 'aneme canihüxiyacaitüni. 'Aura 'ayacu müretimanicü que mütiyüanecai, Ti'aitame putaniu müpaü 'utaitü, ");
INSERT INTO hchNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Ne 'atevarima necanivacacaüyaritüni. 'Apurahami 'Isahaqui Cacuvu necanivacacaüyaritüni. Mücü Muisexi 'uyüyüacatü pücayuvaüriyacai münierenicü. ");
INSERT INTO hchNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ti'aitame müpaü tinitahüave, 'Acacai quenanuyexünaxüa 'a'ücasie, mana pemanuca nehesie mieme mupasiecü. ");
INSERT INTO hchNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Yemecü necanivaxeiya neteüterima que memüte'uximatüarie 'Equipitusie. Necaniva'enieca mema'aiva. Nenacaneni mana nemüvarayevitünicü. Cümüsüari nepümasi'anunü'ani 'Equipitusie. ");
INSERT INTO hchNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Mücü Muisexi memutixani'eri müpaü me'utiyuatü, Quepai tati'aitüvame ta'isücame pümasi'ayeitüa, mücütüme Cacaüyari caneyenü'ani tiva'aitüvame vavicueisitüvame, niuqui tuayame muxei tupiriyasie 'uveme 'ipareviecacu yütürücariyacü. ");
INSERT INTO hchNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Mücüri nivarayevitüni 'inüari tiuyurieca mamarivaveme tiuyurieca 'Equipitu cuieyarisie, Haramara Müxetasie, macumavesieta yatiyurienetü huta teviyari viyari. ");
INSERT INTO hchNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","'Icü Muisexi canihücütüni que mü'ane müpaü mütivarutahüavixü 'Ixaheri xiüyarimama, Ti'aitame müxecacaüyari tixexaxatüvame nanucuquetüamücü xe'ivama vasata nehepaü 'aneme. Xepi'enieca. ");
INSERT INTO hchNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","'Icü Muisexi canihücütüni que mü'ane meyeicacai memüyuyexexeürivacai vahesüa macumavesie, niuqui tuayamematü meyeicacai mitahüavixü yemurisie Sinahi mütitevasie, tatevarima vahamatü meyeicacai. Mücüta niuqui mayeyuri putanaqui'erie tasipitüanique. ");
INSERT INTO hchNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Müme tatevarima mepüca'i'eniecucai, masi mepenuyehüacucai. Yu'iyarisie ta'aurie mepaxüricucai 'Equipitusie ");
INSERT INTO hchNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","müpaü mete'icühüavetü 'Aruni, Cacaüyarixi quetaneutiveviri. Müme tahüxi meniyehuni. Tame 'asitepücatemate que mütiuyunixü 'icü Muisexi mütasi'ayevitü 'Equipitusie. ");
INSERT INTO hchNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","'Ana siqueru meputavevie, mavari mepütecupi mücü cacaüyaritüa. Mecaniyutemamaviecaitüni tita yumamacü memüte'utivevi me'ayexeiyatü. ");
INSERT INTO hchNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Hicü Cacaüyari ta'aurie pave. Püvayetua taheima memücaneniere yunaime va'uximayasica memexeiyanicü, müpaü que müre'utüarie texaxatamete vaxapayarisie müpaü 'anuyütü, Xeme 'Ixaheri quie quiecatari Xenete'atüirivacai 'acu caxarite mavarite Huta teviyari viyari macumavesie xehe'uvatü. ");
INSERT INTO hchNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Masi xepeyexeiyacai Muruqui xiriquieya, Xemüpani yucacaüyari xuraveyari, Vahepaü tiyuxexeiyame xepüyuveviriecai Nenevieri xemüvapitüanicü. Nesü necanixe'anuvitümücü Vaviruniya varita. ");
INSERT INTO hchNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Mericüsü 'ixuriqui tuquiyari haque hecüasica mayecatei mana niuvecaitüni tatevarima vahesüa macumavesie, que mütiu'aitaxü mücü mitahüavixü Muisexi quename hepaüna 'aneme 'ita'aitaquecai 'ixuriqui tuquiyari, 'inüari muxeipaü 'aneme. ");
INSERT INTO hchNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Mücü tuqui meputanaqui'eri tatevarima. Cusuematü meni'atüani quepaucua memüvareutaveiyaxüa 'ena memütitecai hipame nuivarite. Mümesietü Cacaüyari vaüriyarica püvati'unasitüa tatevarima vahüxie. 'Arique 'aniuyeicacaitüni Raviri. ");
INSERT INTO hchNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Cacaüyari 'aixüa tiniuca'iyaricaitüni hesiena mieme. Mücü pitavaviri Cacaüyari qui vevimütü haque Cacuvu Cacaüyarieya mayecanicü. ");
INSERT INTO hchNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Sarumuni püta pitaveviri qui, ");
INSERT INTO hchNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","sepanetü mücü taheima mümieme tixaü quita müca'ayeca mamacü müveviyata. Que maine tixaxatame, ");
INSERT INTO hchNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Muyuavi canine'uvenitüni haque nemüra'aita. Cuie püta nequetatüa pucuma. Que 'aneme qui xepünesitavevirieni, Naineni Ti'aitame, Haque nemeca'uxipieni. ");
INSERT INTO hchNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Camüsü, ne nemamacü 'icü naime nepütiutivevi. ");
INSERT INTO hchNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Xeme xecüipi püsese'i, yu'iyarisie yunacata xepüca'inüaritüarievave Cacaüyari 'inüarieyacü, xeme yuheyemecü xepi'unie 'Iyari Mütiyupata xemeri xetevarimata. ");
INSERT INTO hchNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Que mü'ane texaxatamete 'atiuyeicacai meca'itaveiyavecacu xetevarima. Mepüvarucui müme meripai memitahecüataxü 'iya Heiserie Mexeiya 'umamieniquecai. Mücüri xepüyetua, teyucucuyamete xepacü hicü. ");
INSERT INTO hchNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","'Inüari niuquiyari xeputanaqui'eri niuqui tuayamete metexe'aitüacacu, yaxepücatecahu. ");
INSERT INTO hchNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Mericüsü me'i'enieca 'icü, yu'iyarisie mepuyeha'a. Mepüyutaquevecai me'ihecatü. ");
INSERT INTO hchNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","'Esitevaniri hünetü 'Iyari Mütiyupatacü, heutinieretü yuheima, visi 'aneme catiniuxeiya Cacaüyari, Quesusi tiuxei Cacaüyari serieta 'utiveme. ");
INSERT INTO hchNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Müpaü niutayüni, Camü, muyuavi nepüxeiya 'anacatenime, Yuri Tevi Cacaüyari serieta 'utiveme netixeiya. ");
INSERT INTO hchNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Carima me'utihivatü meneuyucanaca yunacata. Meniviya 'axeicüa. ");
INSERT INTO hchNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Quiecarisie menenuyehüani, meneitituaxixüani tetecü. Tehecüatamete memunenierixü yu'ixuriqui meputivivi 'uquitüa Sauru mütitevacaitüa. ");
INSERT INTO hchNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Meneitituaxixüani 'Esitevani. Mücü nitahüave Quesusi. Müpaü niutayüni, Quesusi Ti'aitame 'acu, queneutanaqui'eri ne'iyari. ");
INSERT INTO hchNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","'Utitunumaqueca carima caniutahiva, Ti'aitame 'acu, 'icü 'axa memüteyuriecü vahesie pepücarahüpani. Müpaü 'utayüca caneucuni. ");
INSERT INTO hchNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sauruta 'iyarieya 'aixüa pü'anecai mumieriecü. Mericüsü 'ana Querusaremesie memüyutixexeürivacai carima menitaveiyarieximecaitüni memü'uximatüariecaicü. Yunaitü meneutayeixüani naisarie quiecari mucumanesie Cureyasie Samariyasie. Nü'arisixi xeicüa meniyuhayeva. ");
INSERT INTO hchNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","'Uquisi Cacaüyari memayexeiyacai meneicuteucu 'Esitevani, vaücava me'utisuatü hepaüsitana. ");
INSERT INTO hchNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Sauru cuini mieme püva'uximatüacai memüyutixexeürivacai. Vaquita peutahaquecai, varayehapaca 'uquisi 'ucari nivaranutaxürüvacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Mericüsü memeutaxüriexüa naisarie meneutayeixüani niuqui 'aixüa manuyüne mecuxatatü. ");
INSERT INTO hchNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Piriperi nuaca Samariya quiecarisie tinivahecüatüacaitüni Cürisitu heiserie mupitüarie hepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Meni'enieni yunaitü que mutainecai Piripe 'axeicüa me'i'enietü me'ixeiyatü 'inüari que mütiyurienecai. ");
INSERT INTO hchNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Cacaüyarixi 'axa memü'anene carima me'utihivatü mepüvarutixünaxüa yumüireme memüvaviyacai. Yuvaücavatü memütutunicai memühurietücatei menanayexürieni. ");
INSERT INTO hchNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Mücü quiecarisie yemecü meniyutemamaviecaitüni. ");
INSERT INTO hchNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Mericüsü 'uqui Simuni mütitevacai mana puyeicacai mücü quiecarisie meripaitü vaquevayatü, Samariyatari tiva'irüviyatü, müpaü 'utaitü quename türücaüyecai. ");
INSERT INTO hchNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Yunaitüri 'uquiravesixi türita mepi'eniecai müpaü me'utiyuatü, 'Icü Cacaüyari türücariyaya canihücütüni, Mümarive mütiteva. ");
INSERT INTO hchNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Mepi'eniecai müixa mütiva'irüviyacaicü vaquevayatü. ");
INSERT INTO hchNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Quepaucua yuri memüte'ita'eriri Piripe tivacuxaxatüvame niuqui 'aixüa manuyüne, que müti'ane Cacaüyari ti'aitametücacu ticuxatatü, que mü'ane Quesusi Cürisitu mühücü cuxatatü, 'uquisi 'ucari mepuca'üyarie. ");
INSERT INTO hchNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Mücüta Simuni yuri tiniuta'erieni. 'Uca'üyarieca pipareviecai Piripe. 'Ixeiyatü 'inüari türücaüyemecü vaücavamecü que mütiyurienecai pü'iyarixiecai. ");
INSERT INTO hchNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Mericüsü me'u'enanaca nü'arisixi Querusareme meme'uvacai quename Samariyatari me'itanaqui'eri Cacaüyari niuquieya, vahesüa mepüvarenü'a Pecuru Vanimame. ");
INSERT INTO hchNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Müme meheta'axüaca meniyutanenevieni vahesie mieme 'Iyari Mütiyupata mehexeiyatü memacünecü. ");
INSERT INTO hchNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","'Acuxisü pücativiyavecai ni xeimesie müme. Mepuca'üyarie xeicüa Cürisitusüa memiemetetütü. ");
INSERT INTO hchNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","'Ana vaheima meniutimeni, 'Iyari Mütiyupata mehexeiyatü menacüne. ");
INSERT INTO hchNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Hicü Simuni nivaruxeiya 'Iyari que memüte'upitüari nü'arisixi vaheima me'utimecu. Nivaranu'üirieniquecaitüni tumini ");
INSERT INTO hchNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","müpaü 'utaitü, Xequeneneupitüa neta 'icü türücariya, que mü'ane heima nemutimeni 'Iyari Mütiyupata hexeiyatü mayanicü. ");
INSERT INTO hchNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Pecuru müpaü tinitahüave, 'Atumini 'ahamatü que'uta'une, tita Cacaüyari mütimicua tuminicü nanaiyacame pemü'eriecaicü. ");
INSERT INTO hchNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","'Icü paürisie mieme 'ecü tixaütü pepücarexeiyani, 'ahesie pücatinaqueni. 'A'iyari pücaheiserie Cacaüyari 'ixeiyacacu. ");
INSERT INTO hchNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Quetineuhayeva que pemütiyuriene, pe'icu'eirieme 'icü tita 'axa pemütiyuriene, queneutavaviri Ti'aitame siparasü xüca pereuyehüviyariemücü 'ipaü pemüti'acühüavecü. ");
INSERT INTO hchNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ne nepümasixeiya siüricapaü pehasivime, tita mücatiheiserie penücame. ");
INSERT INTO hchNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Hicü Simuni müpaü tinita'eiya, Xemesü xequeneutavaviri Ti'aitame nehesie mieme, 'asinemüca'itüarienicü que xemutiyuane. ");
INSERT INTO hchNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Hicü mümeri mevarutahecüatüaca me'itixataca Ti'aitame niuquieya, ta'aurie mepaxüri, Querusareme menecüne. Metenicuxatacaitüni niuqui 'aixüa manuyüne naisarie Samariyatari vaquiecaritesie. ");
INSERT INTO hchNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Mericüsü Ti'aitame niuquieya tuayame müpaü tinitahüave Piripe, Quenanucuquexi, taserieta quenemie huyeta Querusareme mayehane 'utüma quiecari Caxa müracutevasie müye'axe, haque macumave. ");
INSERT INTO hchNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","'Anucuqueca neyani. Camüsü 'uqui 'Etiyupiyatanaca vaücavamecü mühüritüariecai 'enunucutütü, 'Etiyupiyatari va'uquiyari 'uca Canarase mütitevacaisie miemetütü. Catinihüritüariecaitüni naime piniteya hepaüsita. Mücü 'uqui necuyeixüani Querusareme müyutanenevienicü, yu'utüma 'acunuaca pumiecai ");
INSERT INTO hchNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","yucaxetasie yecaitü, titerüvatü tixaxatame Quisariyaxi xapaya. ");
INSERT INTO hchNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Cacaüyari 'Iyarieya müpaü tinitahüave Piripe, Mana quenemie, 'aura queneuye'a mücü caxeta 'aurie. ");
INSERT INTO hchNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","'Unausarümetü Piripe, ni'enieni titerüvacame tixaxatame Quisariyaxi xapaya. Müpaüsü tinitahüave, Petimate 'acu tita pemütiterüva. ");
INSERT INTO hchNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Mücüri rehüave, Que netiyüveniqueyu, me xüca xevitü canesi'utahecüatüanique. Piripe niuta'inieni manutimaquecü, 'auriena mayerünicü. ");
INSERT INTO hchNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","'Ipaü panuyüne 'utüarica miterüvacai, Muxa nunusipaü ni'atüarieni mümierienicü, Muxa müca'utaniucapaü texicamete vahüxie Müpaüta püca'utaniu. ");
INSERT INTO hchNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Tixaü mücaratüacü, heiserie püca'upitüarie Que müreuyevecai quepaucua muta'inüasie. Quepai püvamaica türiyamama Tucarieya munavaiyariecü cuiepa. ");
INSERT INTO hchNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Hicü tevi mühüritüariecai müpaü tinita'eiya Piripe, Yaquenetineutahüavi cuerietü, quepai püraxata tixaxatame. Püyuxata, xeime püta püxata nusu. ");
INSERT INTO hchNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Piripe niutaniuni, nisutüani mücü 'utüaricasie tihecüatüatü ticuxaxatüvatü niuqui 'aixüa manuyüne Quesusi hepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Huyeta me'uhutü haixapa meniu'axüani. Müpaü niutayüni tevi, Camü ha. Titari reuyevese nemüca'üyarienicü. ");
INSERT INTO hchNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Müpaü niutayüni Piripe, Xüca 'a'iyarisie yemecü yuri peti'erieca, 'aixüa caniyümücü. Mücü müpaü tinita'eiya, Ne yuri necatini'erieca Cacaüyari Nu'aya Quesusi Cürisitu mühücü. ");
INSERT INTO hchNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Nita'aita mana mütaquenicü caxeta. Yuhutatü meneucacüne hapa Piripe tevi mühüritüariecaimatü. Nica'üya. ");
INSERT INTO hchNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Hapa me'anaticünecu Ti'aitame 'Iyarieya canitihana Piripe. Tevi tavari püca'ixei, yutemavietü yuhuyeta niumiecaitüni. ");
INSERT INTO hchNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Piripe 'Asutusie caniuyeicacaitüni. Tinicuxatacaitüni niuqui 'aixüa manuyüne naisarie cuyeicatü quiecaritesie, 'arique peta'a Sesareyapaitü. ");
INSERT INTO hchNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Mericüsü Sauru 'uxiva'atü cuxi müpaü 'utaitü müvacuiniquecai Ti'aitame teyü'üquitüvametemama, caninuani mara'acame mühüritüariecaisüa. ");
INSERT INTO hchNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Nitavavirieni xapate mütivati'utüirienicü tuquita miemete Ramasicusie, müpaü 'utaineme, Xücasü 'icü varetaxeiya hipame mücü huyeta miemete 'uquisi 'ucari, nivaravitümücü mehüatücaime Querusaremepai. ");
INSERT INTO hchNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Hicü huyeta 'uyemiecacu, Ramasicu hura 'aye'aximecacu, 'auriena niucumerüca taheima mieme. ");
INSERT INTO hchNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Cuiepa 'ucaveca ni'enieni xeime müpaü haineme, Sauru 'acu, Sauru, titayari peneticuveiyane 'ecü. ");
INSERT INTO hchNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Mücü rehüave, 'Uqui que pepüpaicü. 'Iya müpaü niutayüni, Nesü necaniquesusitüni pemünesicuveiyane. Pümasi'ucucuine pemüca'avaüriyacü, pemüti'aquesinacü pe'anaseivatü tisevemecü. ");
INSERT INTO hchNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Sauru 'utayüyüacatü matü müpaü niutayüni, Ti'aitame, tita matinaque yanemütiyurieni. Ti'aitame rehüave, Hicü quenanucuquexi, quiecarisie queneutahaqui. Manari yapepüretahüavarieni que müreuyevese pemütiyurienenicü. ");
INSERT INTO hchNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","'Uquisi hamatüana memu'uvacai mehüxiyatü meniuti'uni me'i'enietü que mu'ane mutaniu, peru tevi mecaxeiyatü. ");
INSERT INTO hchNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Hicü nanucuqueni Sauru cuiepa. Yühüxita 'anutaniereca tixaü pücatiuxei. Mepeiha mamayasie metivütü, meni'atüani Ramasicupai. ");
INSERT INTO hchNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Haica tucari puyuri caheunieretü caticuatü caharetü. ");
INSERT INTO hchNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Mericüsü xevitü mana niuyeicacaitüni Ramasicusie tiyü'üquitüvametütü Hananiya titevatü. Tücaricü heinüsita Ti'aitame müpaü tinitahüave, Hananiya 'acu. Mücü müpaü niutayüni, Camüsü Ti'aitame ne necanihücütüni. ");
INSERT INTO hchNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ti'aitame müpaü rehüave, Quenanucuquexi, mana quenemie caye Müxeuraüye mütiteva 'utüa. Cura quita queneta'ivau Tarusutanaca Sauru mütiteva. Camü mana peyunenevi. ");
INSERT INTO hchNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Mücüta heinüsita nixeiya 'uqui Hananiya titevacame mana ye'arücame heimana 'utimecame manutanierecü. ");
INSERT INTO hchNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Hananiya müpaü tinita'eiya, Ti'aitame nepüvaru'eni yumüireme metecuxatame 'icü 'uqui hepaüsita, naime 'axa que mütivayurienecai müme 'ateüterima Querusaremesie. ");
INSERT INTO hchNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","'Enata heiserie menipitüani vaniu mara'acate memühüritüarie müvaviyanicü yunaime 'uva mematetahüave. ");
INSERT INTO hchNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ti'aitame müpaü tinitahüave, Quenemiesü. Ne nepenuyeteüxixü 'icü, mütihecüatanicü nehepaüsita nuivarite vahüxie cuiepa te'aitamete vahüxie 'Ixaheri xiüyarimama vahüxie. ");
INSERT INTO hchNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Netinita'üquitüamücü que müreuyevese müticuinecü nehesie mieme. ");
INSERT INTO hchNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Hicü Hananiya petüa, quita neutahani. Heimana 'utimeca müpaü niutayüni, Ne'iva Sauru, Ti'aitame caneneyenü'ani ne. Mücü Quesusi pemuxei huyeta pe'aye'aximetü, mücü caneneyenü'ani peheunieretü pemayanicü, pemühünenicü 'Iyari Mütiyupatacü. ");
INSERT INTO hchNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Yapaucua payexüri hüxitana cunieripaü 'anenetü. Heunieretü nayani, 'anucuqueca niuca'üyarieni. ");
INSERT INTO hchNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","'Itanaqui'erieca 'icuai türücaüyetü nayani. Mericüsü Ramasicusie puyeicacai yapaümexa tucari teyü'üquitüvamete vahamatü. ");
INSERT INTO hchNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Cuitüva Huriyusixi vatuquiteta tinihecüatacaitüni Quesusi hepaüsita, 'Iya Cacaüyari caninu'ayatüni 'utaitü. ");
INSERT INTO hchNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Menihüxiyacaitüni yunaitü memi'eniecai. Müpaü meniutiyuanecaitüni, Cari 'icü canihücütüni que mü'ane müvaraye'uniecai müme memehüave mücü que mü'ane mühücü Querusareme quiecatari, 'uvata 'ayumieme munua, müvaranuvitünicü mehüatücaime mara'acate memühüritüarie vahesüa. ");
INSERT INTO hchNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Sauru yemecü canitürücariyarieximecaitüni. Niva'iyarixitüacaitüni Huriyusixi Ramasicusie memütamacai, nivarutahecüatüani quename 'iyatütü que mü'ane heiserie mupitüarie hücü Cürisitu. ");
INSERT INTO hchNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Mericüsü müixa tucari 'utixücu Huriyusixi mecaniyu'enieni me'imienique. ");
INSERT INTO hchNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Sauru tinetimani que memüteyurieniquecai. Quiecari quitenitesie tucaricü tücaricü menihupiecaitüni me'imienique. ");
INSERT INTO hchNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Quirivasie me'icayeca tesariya varie meneicatuani yüvicüta teyü'üquitüvamete. ");
INSERT INTO hchNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Hicü Querusareme nuaca pütiviyamücücai teyü'üquitüvamete vahesie. Yunaitü mepimacarücai yuri mecate'erietü quename tiyü'üquitüvametücai. ");
INSERT INTO hchNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Verunave heivitüca cani'atüani nü'arisixi vahesüa. Nivarutahecüatüani ya'utaitü quename huyeta 'ixei Ti'aitame, quename Ti'aitame 'itahüavixü, quename Ramasicusie camatü ticuxatacai Quesusisüa miemetütü. ");
INSERT INTO hchNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Hicü vahesüa niuyeicacaitüni Querusaremesie naisarie cuyeicatü. ");
INSERT INTO hchNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Pücamacai mütaniunicü Ti'aitamesüa mümiemetücaicü. Niuqui nixüatüacaitüni Cüriyecusixi vaniuquicü memutiniucacai vahamatü. Mümesü menimiecucaitüni. ");
INSERT INTO hchNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","'Ivamariximama yametehetimaica meneivitüni Sesareyasiepai, Tarusupaitü meneitanü'ani. ");
INSERT INTO hchNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Mericüsü memüyutixexeürivacai naisarie Cureyasie, Carereyasie, Samariyasie mepüca'uximatüariecai. Mepuseiriyarie, 'ameniu'uvacaitüni meteheiyehüvirietü Ti'aitame. 'Iyari Mütiyupata müiremecü nivatuicacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Mericüsü Pecuru naisarie pücuyeicacai. Manata penua Cacaüyari teüterimama vahesüa Rirasie memütamacai. ");
INSERT INTO hchNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Mana nicaxeiya xeime 'uqui 'Eneya mütitevacai 'atahaica viyari müyuriecai yu'utasie cacaitü mühuriecaicü. ");
INSERT INTO hchNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Müpaü tinitahüave Pecuru, 'Eneya 'acu, Quesusi Cürisitu pümasi'anayehüa. Quenanucuquexi, 'a'isi queneutacuicui. Yapaucua nanucuqueni. ");
INSERT INTO hchNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Yunaitü Rirasie Sarunisie memütamacai menixeiyacaitüni. Ta'aurie me'axürieca Ti'aitamesie meteniviyani mümerita. ");
INSERT INTO hchNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Mericüsü tiyü'üquitüvame 'uca Cupesie necateitüni Tavita titevatü, taniuquicü Rurucaxi titevatü Maxama titevatü. Mücü 'aixüa ti'aneneme tiniyurienecaitüni cuini mieme, tiniyucanenimayacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Hicü 'ana tiutacuineca caniumüni. Me'itahauxica qui taüta meneitateni. ");
INSERT INTO hchNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Mericüsü Rirasie pehura Cupe. Teyü'üquitüvamete me'u'enanaca quename Pecuru mana heyeicacai, hesüana menivarenü'ani 'uquisi yuhutame müpaü mete'itavavirienique, Penücahürixüa 'areutevini tahesüa pemünuani. ");
INSERT INTO hchNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Pecuru 'anucuqueca vahamatü petüa. Nuacu qui taüta meneitivitüni. 'Auriena meniu'axüani yunaitü 'ucari vacünama memucui, me'utisuatü me'ixeisitüatü 'ixuriquite tetüata miemete herie miemete miveviecai Maxama vahesüa 'uyeicatü. ");
INSERT INTO hchNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Yunaime nivaranuyenü'ani Pecuru. 'Utitunumaqueca niyutanenevieni. Ta'aurie 'aveca caxari manucatei müpaü niutayüni, Tavita 'acu, quenanucuquexi. Mücü nanutaniere. Pecuru 'uxeiyaca 'aniutayerüni. ");
INSERT INTO hchNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","'Iya mamayasie tiviereca nenucuhana. Yuhesüa nivarutahüave Cacaüyari teüterimama 'ucari vacünama memucui vahamame. Niyetuani 'ayeniereme. ");
INSERT INTO hchNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Naisarie tiniutamariva Cupesie, yuvaücavatü yuri meteniuta'erieni Ti'aitamesie. ");
INSERT INTO hchNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Müixa tucari Cupesie pecatei Simunisüa navi 'uhayamesüa. ");
INSERT INTO hchNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Mericüsü 'uqui Sesareyasie pecatei Curineriyu titevatü xei sienituyari cuyaxi tiva'aitüatü. Mücü cuyaxi 'Itariyasie Miemete Cuyaxi mepütetetevacai. ");
INSERT INTO hchNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","'Iya caneyexeiyacaitüni Cacaüyari, tineiyehüviriecaitüni, yunaitü quiena quiecatarita. Vaücava tiniyurienecaitüni teüteri vahesie mieme vanenimayatü, nenevieri pipitüacai Cacaüyari yuheyemecü. ");
INSERT INTO hchNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Mericüsü heinüsipaü 'aneme niuxeiya hecüacame cüa caviecacu tau yacütütü. Cacaüyari niuquieya tuayame hesüana neutahani. Müpaü tinitahüave, Curineriyu 'acu. ");
INSERT INTO hchNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Mücü 'ixeiyatü pümacai. Müpaü niutayüni, Tita 'acu 'uqui. Mücü müpaü tinitahüave, 'Anenevieri 'anenimayasica nanutiyeicani Cacaüyari hüxie, pümasi'a'eriva. ");
INSERT INTO hchNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Hicü quenivaranunü'a 'uquisi Cupepai memivitüyucü xeime Simuni Pecuru mütiteva. ");
INSERT INTO hchNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Mücü necani Simunisüa navi 'uhayamesüa. Quiya haramara tesita peve. Mücü camatinitaxatüamücü que müreuyevese yapemütiyurienenicü. ");
INSERT INTO hchNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Heyacu niuqui tuayame yamütitahüavixü, yu'aurie püvarutahüavixü yuhutame yunü'arivamete cuya meta Cacaüyari mayexeiyacai, memipareviecai xevitü mühücütücai. ");
INSERT INTO hchNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Tivarutahecüatüaca naime, nivarenü'ani Cupepai. ");
INSERT INTO hchNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","'Uxa'arieca me'uhucacu cuxi, quiecari 'aurie me'aye'axüaximecacu, neutiyani Pecuru qui heima manuvericaisie yutanenevienique tuca. ");
INSERT INTO hchNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Neuhacamücücaitüni, reucuaimücücai. Mexicuxi 'aixüa ticuyünecai 'icuai pütiuheinü. ");
INSERT INTO hchNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Nixeiya muyuavi 'anacatenime, paüri 'acamieme savanapaü 'aneme, cuiepapai macatuiya 'eyeutü tesitana tivütücaitü. ");
INSERT INTO hchNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Mana meniye'ucaitüni yunaitü cuiepa temiemete nauca 'ücayari memexeiya, cuterixi, viquixi taheima miemete. ");
INSERT INTO hchNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Xevitü müpaü tinitahüave, Quenanucuquexi Pecuru, quenivarucuya quenivaruticua'i. ");
INSERT INTO hchNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pecuru müpaü niutayüni, Tixaü Ti'aitame. Hasuacu nepüca'iticuaive paüri 'axa müti'anene mücati'itiyatüca. ");
INSERT INTO hchNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Hutarieca müpaü tinitahüave mücü, Tita Cacaüyari müti'itie 'axa ti'aneneme pepücatixata. ");
INSERT INTO hchNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Haicacüa müpaü pütiuyü, cuitü yapaucua mücü paüri panutihani taheima. ");
INSERT INTO hchNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pecuru 'asicatimaicacu tita müti'ayumiemetücai heinüsi, camü 'uquisi Curineriyu müvareyenü'a quiteni meniu'axüani me'icu'ivavatü Simuni quiya. ");
INSERT INTO hchNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Meputihivacai meheicu'ivaviyatü xüca mana hecateitüni Simuni Pecuru mütiteva. ");
INSERT INTO hchNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Mücü Pecuru yu'iyaritüacacu heinüsi hepaüsita, 'Iyari müpaü tinitahüave, Neuxei, 'uquisi yuhaicatü mepümasicu'ivava. ");
INSERT INTO hchNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Quenanucuquexi, mana queneucaye'a, vahamatü quenemie peca'a'iyaritüatü. Nesü nepüvareyenü'a. ");
INSERT INTO hchNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","'Anacayaca haque memeti'ucai 'uquisi Pecuru müpaü tinivarutahüave, Camüsü ne necanihücütüni xemicuvautüve. Titayari xete'u'axüa. ");
INSERT INTO hchNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Mümesü müpaü meniutiyuani, Curineriyu xei sienituyari cuyaxi mütiva'aitüvame, mücü heiseriemecü yapütiyuriene, püreiyehüviri Cacaüyari. Yunaitü Huriyusixi teüteriyari mepitahecüata. Niuqui tuayame Cacaüyarisüa mümieme müpaü tinitahüave 'ahesüa mütiutanü'acü yuquie masi'inietü, niuqui mü'enienicü 'ecü yapeticuxatacacu. ");
INSERT INTO hchNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Quita nivaruta'inieni, nivarupitüani haque memayeyaxecü. 'Uxa'arieca 'anucuqueca vahamatü neyani. Hipatü 'ivamarixi Cupesie miemete vahamatü menecüne. ");
INSERT INTO hchNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","'Uxa'arieca Sesareyapai meneta'axüani. Curineriyu nivarecueviecaitüni varuta'inieca yumarema yuhamicuma müvanaqui'eriecai. ");
INSERT INTO hchNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Heutahaximecacu Pecuru, Curineriyu nenucunaque. Hetüana 'ucaveca nenevieri pipitüa. ");
INSERT INTO hchNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pecuru nenucuquetüani müpaü 'utaitü, Quenanucuquexi. Nesü 'ahepaü necanitevitüni. ");
INSERT INTO hchNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Metecuxatacacu mana neutahani. Nivaretaxeiya yuvaücavame memüyuxeürie. ");
INSERT INTO hchNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Müpaü tinivarutahüave, Xeme müpaü xepütemate, que mü'ane Huriyu teviyari mühücü pücatauniva mütiviyanicü xeime nuivarisie, va'aurie mamienicü. Perusü Cacaüyari müpaü pünetiutahecüatüa tevi mücayüve müpaü mütayüni quename tevi 'axa 'ane quename ca'itiya. ");
INSERT INTO hchNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","'Ayumieme necanecu'imavatü necaninuani quepaucua nemeyevitüquie. Hicü necanixecu'ivaviyaniqueyu titayari xenete'utanü'airi. ");
INSERT INTO hchNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Curineriyu müpaü tinitahüave, Ranuca'atu nepünehaquiecai 'epaucua. Cüa caviecacu tau yacütütü nenineneneviecaitüni nequita. Camü 'uqui nehüxie putique 'ixuriqui merücaüyeme 'anacatütü ");
INSERT INTO hchNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","müpaü 'utaitü, Curineriyu 'acu, pe'enierie 'anenevieri. Cacaüyari pümasiha'eriva que pemüti'acanenimaya. ");
INSERT INTO hchNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Mericüte, quetineutanü'a Cupepai. Queneta'ini Simuni Pecuru mütiteva. Mücü Simuni navi 'uhayame quie peca haramara tesita. Nuame pümatitaxatüani. ");
INSERT INTO hchNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Hicü cuitü nepütiutanü'a. 'Ecüsü 'aixüa petiniuyurieni pemunuacü. Hicüsüari tanaitü 'uva tepütacuxeüri Cacaüyari hüxie temi'enienicü naime Ti'aitame mümati'aitüa. ");
INSERT INTO hchNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Hicü Pecuru müpaü niutayüni, Yuricü hicürixüa nepütimate, Cacaüyari yücü pücativaxeiya teüteri, ");
INSERT INTO hchNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","masi yuxexuime nuivarite vasata que mü'ane müreiyehüviri, que mü'ane heiseriemecü yamütiyuriene, Cacaüyari pitanaqui'eri 'iya. ");
INSERT INTO hchNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Niuqui 'aixüa manuyüne meyenü'a 'Ixaheri xiüyarimama vahesüa müpaü paine quename Quesusi Cürisitu vapitüani yu'iyarisie memüca'uximatüariecacü. Mücü Quesusi yunaime tiva'aitüvame canihücütüni. ");
INSERT INTO hchNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Xemeri xepütemate naisarie Cureyasie que mütiuyü, Carereyasie tiusutüariecu quepaucua Vani mütihecüatacai que memüteca'üyarieniquecai. ");
INSERT INTO hchNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Quesusi Nasaretitanaca canihücütüni, que mü'ane Cacaüyari micaviri yu'iyari Mütiyupatacü türücariyacü. Mücü 'aniuyeicacaitüni 'aixüa tiyurienetü, yunaime Cauyumarie müva'uximatüacai varanayexürüvatü, Cacaüyari muyeicacaicü hamatüana. ");
INSERT INTO hchNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Tameta tepühüme temunenierixü temütehecüata naime hepaüsita que mütiuyurie Huriyusixi vacuiepa Querusaremesie. Müme menimieni me'icavivatü cüyesie. ");
INSERT INTO hchNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Cacaüyari nenucuquetüani hairieca tucarisie. Nipitüani masiücütü mayanicü ");
INSERT INTO hchNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","yunaitü teüteri meca'ixeiyacacu, tehecüatamete xeicüa Cacaüyari müvaranuyexei matüaripai menixeiya, temixei tame temütecuacai temüte'u'i hamatüana müquite vasata 'anucuquecu. ");
INSERT INTO hchNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Pütasi'uta'aitüa temütevacuxaxatüvanicü teüteri, temütehecüatanicü quename 'icü hücü que mü'ane Cacaüyari micaye 'ayenenieremete müquiteta va'isücame mayanicü. ");
INSERT INTO hchNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Hepaüsitanata yunaitü texaxatamete mecatenihecüatani müpaü me'utiyuatü, müme hesiena yuri memüte'erie tinivareuyehüvirieni tita 'axa memüte'uyuricü hesüana memümiemetecü. ");
INSERT INTO hchNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Mericüsü 'icü niuqui ticuxatacacu cuxi Pecuru, 'Iyari Mütiyupata vahesie tiniviyani, yunaitü niuquieya memu'enie vahesie. ");
INSERT INTO hchNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Yuri memüte'eriecai Pecurumatü memu'axüa memühuriyusixitücai mecanihüxiyacaitüni memücahuriyusixi müpaü memüte'umiquiecü, 'Iyari Mütiyupata vahesie mutatuiyacü. ");
INSERT INTO hchNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Mepüva'eniecai metecuxatame niuquitecü, 'aixüa me'utiyuaneme Cacaüyari hepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Mericüsü müpaü tinivarutahüave Pecuru, Quepai püvanenasitüiya ha, memücaca'üyarienicü 'ime. Havaicü. 'Iyari Mütiyupata meputanaqui'eriexüa tahepaü. ");
INSERT INTO hchNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Tinivaruta'aitüani memüca'üyarienicü Quesusi Cürisitu mehüavetü. 'Ana menitavavirieni vahesüa 'amüreutevinicü yapaümexa tucari. ");
INSERT INTO hchNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Mericüsü nü'arisixi ta'ivamata Cureyasie memu'uvacai meteniutamarieni quename müme memücahuriyusixitücai me'itanaqui'eri Cacaüyari niuquieya. ");
INSERT INTO hchNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Quepaucua Querusaremesie meutiyunixü Pecuru, müme xitequiya 'inüariyarisie miemete meniniuquixiecaitüni ");
INSERT INTO hchNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","müpaü me'utiyuatü, Titayari 'ecü petinua müme memüca'inüaritüarie xitequiya 'inüariyaricü vahesüa, vahamatü perecuacai. ");
INSERT INTO hchNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Pecuru tinivarutixatüatüyani xexuime que müreyü müpaü 'utaitü, ");
INSERT INTO hchNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Ne quiecari Cupe müracutevasie neneyeicacaitüni. Nenenenevietü, heinüsipaü 'aneme nexeiyatü, necanixeiya paüri taheima 'acamieme tesitana tivütücaime savana 'amayeyevapaü tiyuxexeiyame. Ne'aurie niucaveni. ");
INSERT INTO hchNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Neni'ixüariecaitüni nehe'erivatü. Nenivaruxeiya nauca 'ücateyari memexeiya cuiepa miemete, yeutari cuterixi viquixi taheima miemete. ");
INSERT INTO hchNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Nepi'enie xeime müpaü münetiutahüavixü, Quenanucuquexi Pecuru, quenivarucuya quenivaruticua'i. ");
INSERT INTO hchNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Nesü müpaü neniutayüni, Tixaü Ti'aitame, tita 'axa müti'anene mücati'itiya hasuacua neteta pücaheutahave. ");
INSERT INTO hchNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Hutarieca müpaü canetiniuta'eiya que mü'ane taheima mutaniucacai, Tita Cacaüyari müti'itie pepücahaine 'ecü quename 'axa ti'anene. ");
INSERT INTO hchNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Haicacüa müpaü pütiuyü. Paüri naitü nanutihanieni taheima. ");
INSERT INTO hchNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Camüsü yapaucua meniu'axüani yuhaicatü 'uquisi mücü qui nemüvayecateisie, nehesüa memeyenü'ari Sesareyasie meheyecüneca. ");
INSERT INTO hchNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","'Iyari müpaü pünetiutahüavixü, Vahamatü quenemie tixaü pecati'a'iyaritüatü. 'Ime ta'ivama 'ataxevitü menesiteütacacu mana teneta'axüani. 'Uqui quita teneutahaxüani. ");
INSERT INTO hchNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Mücü catatiniutahecüatüani que mütixei niuqui tuayame yuquita 'utiveme müpaü 'utaineme, Cupepai quetineutanü'a memevitünicü Simuni Pecuru mütiteva. ");
INSERT INTO hchNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Mücü pümatitaxatüani niuqui cümana pemütavicueisitüarieni 'ecü, 'aquie quiecatarita metetavicueisitüarieni yunaitü. ");
INSERT INTO hchNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Ne netiusutüacu neticuxatatü, 'Iyari Mütiyupata vahesie pütiuviyaxü tahepaü sutüapai tahesie mütiuviyaxüpaü. ");
INSERT INTO hchNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ne nepeye'erie Ti'aitame niuquieya que mainecai, Vani pütiuca'üyacai hacü, xeme püta xepüca'üyarieni 'Iyari Mütiyupatacü. ");
INSERT INTO hchNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Mericüte, Cacaüyari yaxeicüa que mütatiupitüa yuri temüteta'erienicü Ti'aitame Quesusi Cürisitusie, müpaürita tinivarupitüani müme. Ne quesü netiyüvecai nemitanenanicü Cacaüyari. ");
INSERT INTO hchNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Hicü 'icü me'u'enieca, cayuvatü meniumacaitüni. 'Aixüa meniutiyuanecaitüni Cacaüyari hepaüsita müpaü me'utiyuatü, Mericüte Cacaüyari tinivarupitüani müme memücahuriyusixita memütehayevanicü que memüteyuriecai para tucari memexeiyanicü. ");
INSERT INTO hchNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Mericüsü müme memüveveiyarietüvecai 'umieriecu 'Esitevani meneutayeixüani. Meneta'axüani Penisiyasie Sipüresie 'Anutiyuquiyasie. Niuqui mepücatevacuxaxatüvacai hipame, Huriyusixi xeicüa. ");
INSERT INTO hchNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Hipatü müme mecanisipüretaritücaitüni mecanisirenetaritücaitüni. Müme 'Anutiyuquiya me'u'axüaca metenivacuxaxatüvacaitüni Cüriyecusixi niuqui 'aixüa manuyüne Ti'aitame Quesusi hepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Mücü Ti'aitame yütürücariyacü nivapareviecaitüni. Yuvaücavatü yuri mete'erietü, ta'aurie me'axürieca, Ti'aitamesie meteniviyani. ");
INSERT INTO hchNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Mericüsü vahepaüsita mepu'enanaxü müme memüyuyexexeürivacai 'ana Querusaremesie. Verunave menenü'ani 'Anutiyuquiyapai. ");
INSERT INTO hchNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Nuaca, nieretü 'aixüa quemütiuca'iyaricai Cacaüyari, caniyutemaviecaitüni. Yunaime nivatuicacaitüni Ti'aitamesie memüteviyanicü ya'ayumiemetücacu va'iyari. ");
INSERT INTO hchNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Mücü 'uqui 'aixüa pütiyurienecai, pühünecai 'Iyari Mütiyupatacü, yuri püti'eriecai vaüca. Yumüiretü yemecü Ti'aitamesie meteniviyacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Hicü Verunave Tarusupai neyani 'icuvaunetü Sauru. Heitaxeiyaca caneivitüni 'Anutiyuquiyapai. ");
INSERT INTO hchNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Mana xei viyari mepuyurie memüyuyexexeürivacai vahamatü meyucuxexeürivatü. Yumüireme meteniva'üquitüacaitüni vaücava. 'Anutiyuquiyasie teyü'üquitüvamete Cürisitiyanusixi mepüte'utaterüvari meri. ");
INSERT INTO hchNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Mericüsü 'ana menacanexüani texaxatamete Querusaremetari 'Anutiyuquiyapai. ");
INSERT INTO hchNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Xevitü 'anucuqueca Hacapu mütitevacai tiniutahecüata 'Iyari müpaü titahecüatüacu quename hacaxa 'ayaniquecai vaücava naisarie teüteri mematitecaisie. Müpaü pütiuyü quepaucua Cürauriyu müti'aitametücai mücü cuiepa. ");
INSERT INTO hchNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Yuxexuitü teyü'üquitüvamete que memüteheixeiyacai, meniyuvaüriyacaitüni tixaütü memüte'anunü'anicü memüvaparevienicü yu'ivama Cureyasie memütamacai. ");
INSERT INTO hchNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Müpaüsü mepüte'uyuri. Meneinü'a va'uquiyarima vahesüa. Verunaveri Saururi menei'üni. ");
INSERT INTO hchNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Mericüsü 'ana Herurexi müti'aitametücai mücü cuiepa nivarutiviya memüyuyexexeürivacai hipame 'axa vayurienique. ");
INSERT INTO hchNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","'Ixiparacü tiniuta'aita mümierienicü Cacuvu Vani mü'ivayatücai. ");
INSERT INTO hchNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Retimaica que mütivanaquecai Huriyusixi, müpaüta 'arique niviya Pecuruta, 'iya semanasie quepaucua 'ixüararipa pa mücuxaxani mecuatü memüte'uhayevaxü. ");
INSERT INTO hchNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Pecuru 'uviyaca nenutahüani. Nivaruhüritüani tamamata heimana 'ataxeime cuyaxi yunanaucatü memi'üviyanicü. Pasicua 'ixüarariyari 'aye'ayu teüteri vahüxie ni'atüarieniquecaitüni Pecuru mümierienicü. ");
INSERT INTO hchNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Mücü ni'üviyariecaitüni casariyanata. Memüyuyexexeürivacai mecatehayevatü nenevieri mepipitüacai Cacaüyari hesiena mieme. ");
INSERT INTO hchNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Mericüsü quepaucua Herurexi 'uxa'arieca mi'atüaniquecai Pecuru teüteri vahüxie mümierienicü, mücü tücarisie nicusucaitüni Pecuru yuhutatü cuyaxi naisata me'uti'ucacu, huta tepüayaricü 'acuvietü. Tehüvemete quitenie hüxi meni'üviyacaitüni casariyana. ");
INSERT INTO hchNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Camüsü Ti'aitame niuquieya tuayame mana niutiqueni. Quitapai pucumerücaxü. Serietana heicuvaca Pecuru nenutahütüani müpaü 'utaitü, Quenanucuquexi xeiya. Tepüa panacaxüri mamayasie puxünixü. ");
INSERT INTO hchNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Niuqui tuayame müpaü tinitahüave, Quena'ahüa, 'acacaisie queneuquexi. Müpaü pütiuyuri. 'Arique müpaü tinitahüave, 'A'ücari quenivacuquema quenenanuveiya. ");
INSERT INTO hchNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","'Anuyeyaca neiveiya. 'Asipücatimaicai muyuritücai que mütiyurienecai niuqui tuayame. Heinüsi püta pü'eriecai. ");
INSERT INTO hchNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Me'anuyenexüaca xeime yuhutame tehüvemete va'aurie, tepüa 'itupariyarisie meniu'axüani quiecarisie muyenena. 'Itupari yücümana natenire vahesie mieme. Mana me'anuyenexüaca xeime cayesie menanuyenexüani. Yapaucua neyani hesüana niuqui tuayame. ");
INSERT INTO hchNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Hicü Pecuru tiyumaica müpaü niutayüni, Hicürixüa nepütimate yuricü Ti'aitame meiyenü'a yuniuqui tuayame. Herurexi nesi'uviyacu pünesi'uxünaxü, Huriyusixi teüteriyari que memünetexeiyacucai nai pünesi'uxünaxü. ");
INSERT INTO hchNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Mericüsü yatiumaica mana ninuani Vani Maricuxi mütitevacai varusieya quie, Mariya mütitevacai varusieya. Muva meniyuxeüriecaitüni yumüiretü meyunenevietü. ");
INSERT INTO hchNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","'Itupari vari neyuitüani. 'Üimari püvayetüa Xute mütitevacai heu'enaque. ");
INSERT INTO hchNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Tinetimani Pecuru müniuquieyatücaicü, peru cacatineuyepieni müyutemaviecaicü. Masi 'unausarümetü quita tinivarutahecüatüani Pecuru quitenie mutivecaicü. ");
INSERT INTO hchNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Müme müpaü metenitahüave, Tietü peca'amaica. Mücüsü, Xüari mücü pühücü 'utaitü, müpaü tinivacühüavecaitüni masi. Müme müpaü meniutiyuani, Niuquieya tuayame pühücü. ");
INSERT INTO hchNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Pecuru mana puyuhayevacai heyuitüvatü. Meteheuyepieca menixeiya, menihüxiyacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Yumamacü nivaru'inüaritüani cayuvatü memütamarecü, tinivarutahecüatüani Ti'aitame que mütivayevitü casariyanata. Müpaü tinivarutahüave, Yaxequetenivarutahecüatüa Cacuvu ta'ivamarixita. 'Anuyeyaca xaüsie neyani. ");
INSERT INTO hchNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Mericüsü 'ucatarecu cuyaxi yemecü meniyuxamurietüvecaitüni queri tiuyunixü Pecuru me'utiyuatü. ");
INSERT INTO hchNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herurexi heicuvauca pücaheitaxei. 'Ayumieme nivaruta'ivaviya tehüvemete, tini'aitacaitüni memücui'ivacü. Hicü Herurexi Cureya heyeyaca yapaümexa tucari neyuriecaitüni Sesareyasie. ");
INSERT INTO hchNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Mericüsü Herurexi püvaxeümacai Tirutari Sirunitari. Müme 'axeicüa meniu'axüani hesüana, me'itihamicutaca que mü'ane cuiepa ti'aitame quita mühüritüariecai Purasitutütü. 'Aixüa memüteyuxeiyanicü menitavavirieni, vacuiepa quiecatari memeiyehüacaicü 'icuai mematücünicü ti'aitame cuieyarisie timieme. ");
INSERT INTO hchNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Xeime tucarisie Herurexi ti'aitame 'ixuriquiyari 'anacatütü, ti'aitame 'uvenieyasie 'acaitü, tinivacuxaxatüvacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Teüteri müpaü meniutihivacaitüni, Tevi püca'utaine, Cacaüyari püta putaine. ");
INSERT INTO hchNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ti'aitame niuquieya tuayame yapaucua nivani 'aixüa müca'utainecaicü Cacaüyari hepaüsita. Cuisietü niumüni. ");
INSERT INTO hchNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Mericüsü Ti'aitame niuquieya naisarie pü'enieriecai niutimüire. ");
INSERT INTO hchNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Verunave Saurumatü Querusareme me'ayenexüaca yu'utüma meniucunuaxüani 'aye'acu vahüritüarica. Meneivitüni Vani Maricuxi mütitevacai. ");
INSERT INTO hchNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Mericüsü memüyuyexexeürivacai 'Anutiyuquiyasie hipatü mecatenixaxatametetücaitüni meteni'üquitametetücaitüni Verunave, Simuni Niqueri mütitevacai, Rusiyu Sirenetanaca, Manaheni ti'aitame Herureximatü memutivaverixü, Sauru. ");
INSERT INTO hchNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Müme Ti'aitame 'uximayasicaya yameteyuriecacu meyuhaquiecacu, müpaü niutayüni 'Iyari Mütiyupata, Nehesie mieme xequenivarupata Verunave Saurumame 'ipaü memüte'uximayacacü que nemütivatahüave. ");
INSERT INTO hchNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Me'uyuhaquieca meyutanenevieca vaheima me'utimeca memühüritüariecaicü, menivarutatuani. ");
INSERT INTO hchNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Mericüsü 'Iyari Mütiyupata nivarenü'ani. Sereusiyasie menecüne. Mana naviyasie menecüne Sipürepai. ");
INSERT INTO hchNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Saramina me'u'axüaca metenihecüatacaitüni Cacaüyari niuquieya Huriyusixi vatuquiteta. Vani püvatupiritücai. ");
INSERT INTO hchNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Cuie hapa müyema 'amacuyevasie meniuyecüne Papuxipai. Mana meneitaxeiya xeime Huriyu mütiyuquevayametücai, ti'itavatü mütixaxatametücai, Paruquesusi mutitevacai. ");
INSERT INTO hchNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Mücü necateitüni que mü'ane cuiepa mühüritüariecaisüa, Seruquiyu Pauru mütitevacaisüa mütimaivecaisüa. 'Iya nivaruta'inieni Verunave Sauru. Ni'eniemücücaitüni Cacaüyari niuquieya. ");
INSERT INTO hchNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Vahepaüsita ni'uxiva'acaitüni mücü tiyuquevayame 'Erimasi mütitevacai Cüriyecusixi vaniuquicü. Nicunuitüamücücaitüni que mü'ane cuiepa mühüritüariecai yuri mücatita'erienicü. ");
INSERT INTO hchNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Saurutütü, Papuru mütitevata, hünetü 'Iyari Mütiyupatacü, 'ixeiyatü, ");
INSERT INTO hchNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","müpaü niutayüni, Cari 'ecü pepühüne naime 'irümaricü nai 'axa müti'anecü. Cauyumarie pepünu'aya, pepica'una nai mütiheiserie, pepücatihayeva 'ecü pe'itunatü Ti'aitame huyeya müxexeuravi. ");
INSERT INTO hchNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Camüsü Ti'aitame pümasinenani yumamacü. Pe'acüpetü peca'ixeiyavetü tau penayeimücü yapaümexa. Yapaucua pucucutuxaxüa pu'iyüri. Cumenetü xeime nicuvaunecaitüni menuhanacü mamayasie tiviereme. ");
INSERT INTO hchNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","'Iya cuiepa mühüritüariecai 'uniereca que mütiuyü yuri tiniuta'erieni. Pühüxiyacai Ti'aitame 'üquisicaya hepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Mericüsü Papuxisie menecüne müme Papurumatü memu'uvacai. Perüque meniu'axüani Pamüpiriya cuieyarisie. Vani mana nanayeyani vahesie. Ta'aurie 'aveca Querusareme neyani. ");
INSERT INTO hchNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Mümesü me'anucüneca Perüque, meniu'axüani 'Anutiyuquiyasie Pisiriya cuieyarisie. Meheutahaxüaca Huriyusixi vatuquita 'uxipiya tucarisie mana menatecaitüni. ");
INSERT INTO hchNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","'Utiterüvariecu 'inüari xapayari texaxatamete vaxapayari, tuqui vava'üte niuqui menenü'ani vahesüa müpaü me'utiyuatü, Ta'ivama xüca niuqui xehexeiyani xemüvatuicanicü teüteri, yaxequeteneutaxata. ");
INSERT INTO hchNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Papuru 'anucuqueca yumamacü varu'inüaritüaca müpaü niutayüni, Neuxei 'Ixaherisixi, xemeta Cacaüyari xemüteheuyehüviri, xequene'enanaca. ");
INSERT INTO hchNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","'Icü 'Ixaherisixi teüteriyari vacacaüyari nivaranuyeteüxü tatevarima. Teüteri vahesie mieme 'aixüa pütiuyuri quepaucua memücu'uvametetücai 'Equipitu cuieyarisie. Yütürücariyacü nivarayevitüni muva. ");
INSERT INTO hchNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Huta teviyari viyari yacütütü tinivamicuacaitüni macumavesie me'u'uvacacu. ");
INSERT INTO hchNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Varuca'unaxüaca 'atahutame nuivarite Canani cuieyarisie mana nivarupitüani vacuie vahesie mütinaquenicü. ");
INSERT INTO hchNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","'Arique nauca sienituyari heimana huta teviyari heimana tamamata viyari yacütütü 'isücate nivapitüacaitüni, 'ariqueta Samueri pütixaxatametücai. ");
INSERT INTO hchNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Mericüsü 'ana menitavavirieni cuiepa ti'aitame. Cacaüyari nivarupitüani Sauru Sixi nu'aya Venicamini nuivarieyasie mieme. Huta teviyari viyari 'anucayacu ");
INSERT INTO hchNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Cacaüyari nipata. Nicayeni Raviri, cuiepa ti'aitame mayanicü vahesie mieme. Müpaü tinitahecüata hepaüsitana, Ne nenitaxeiya Raviri Quisahi nu'aya, 'uquitüme ne'iyaripaü yaticamieme. Naime que münetinaque yatiniyuriemücü. ");
INSERT INTO hchNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","'Iyasie memüyecü xevitü, Cacaüyari que mainecaipaü 'Ixaherisixi vavicueisitüvame payeitüa Quesusi. ");
INSERT INTO hchNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Meripai canuavecacu cuxi mücü, Vani tinivahecüatüacaitüni yunaime 'Ixaherisixi teüteriyari memüca'üyarienicü metehayevatü que memüteyuriecai. ");
INSERT INTO hchNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Yu'uximayasica nüximetü Vani, müpaü niutainecaitüni, Que xetecu'eriva ne nemühücü. Nesü nepücahücü. Camü xevitü ne'utüma 'upamie. Nesü 'aixüa nepücatiuca'iyari nehesie mütinaquenicü ni cacaiya nemixünirienicü nemiparevienicü. ");
INSERT INTO hchNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Neuxei 'ivamarixi, 'Apurahami xemüxiüyarimama, xeme Cacaüyari xeteheuyehüvirietü xemu'uva, xehesie mieme peyenü'ari 'icü niuqui que xemütetavicueisitüarieni manuyüne. ");
INSERT INTO hchNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Querusareme memütama va'uquiyarimata mepücaheitima Quesusi, mepücaheitima texaxatamete vaniuqui 'uxipiya tucarisie mütiutiterüvarüva, masi mepeye'atüa mücü niuqui me'enutahüatü. ");
INSERT INTO hchNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Sepa tixaü memücate'utaxei me'imienique, menitavavirieni Piratu mümierienicü. ");
INSERT INTO hchNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Mete'aye'atüaca naime hepaüsitana mütiuti'utüarie, mehecaxünaca cüyesie, teuquiyapa meneitateni. ");
INSERT INTO hchNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Cacaüyari püta müquite vasata nenucuquetüani. ");
INSERT INTO hchNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Müixa tucari müme hamatüana memeutiyunixü Querusaremepaitü Carereyasie meheyecüneca, müme mecanixeiyacaitüni. Müme memunenierixü metenivahecüatüaca teüteri hicü cuxi. ");
INSERT INTO hchNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Tameta tepütexetaxatüani niuqui 'aixüa manuyüne, quename 'ipaü tiuyü que mütivarutahüavixü tatevarima manuyüne. ");
INSERT INTO hchNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Cacaüyari 'enucuquetüaca Quesusi müpaü püreye'atüa tame temüvatüriyama tahesie mieme. Müpaüta hutarieca mieme cuicari Cuicari Xapayarisie müpaü paine, 'Ecüsü pecaninenivetüni, hicü nepümasi'utinuivitüa. ");
INSERT INTO hchNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Müpaü paineta quename 'enucuquetüayu müquite vasata, hasuacuari tavari catapünequecai müpaü 'utaitü, Ne yaneticamietü netinixepitüamücü tita nemütiuta'aitaxü Raviri hepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","'Ayumieme xeime cuicarisie müpaü paineta, Que mü'ane pemipataxü 'ahesie mieme, mücü pepücapitüani mütapünecü. ");
INSERT INTO hchNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Mericüsü Raviri yutucarisie miemete varuparevieca, Cacaüyari que mütiyücühüavecai, müpaü tineucuni Raviri. Yutevarima vahesüa neyani. Xüari putapünixü. ");
INSERT INTO hchNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Mücü masi que mü'ane Cacaüyari menucuquetüa, mücüri pücapünicai. ");
INSERT INTO hchNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","'Ayumieme yaxequetenemaica xeme ne'ivama, müpaü tepütexehecüatüa, tita 'axa xemüteyurie xemüteheuyehüviyarieni 'iya yamütiuyuricü. Naime cümana xemücayüvavecai heiserie xemüpitüarienicü Muisexi 'inüarieya niuquiyaricü, ");
INSERT INTO hchNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","mücüsie meteviyatü yunaitü yuri memüte'erie heiserie mecanipitüarieca. ");
INSERT INTO hchNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Yumarima 'aixüa 'asixe'itüarienicü texaxatamete vaxapayarisie que maine, ");
INSERT INTO hchNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Neuxei tave'eriecate, Xequene'iyarixieca xequenecui'ini. Que nemütiyurieni ne mexi xe'u'uva, Yuri xepücate'erieca sepa xevitü mütixe'utaxatüanique. ");
INSERT INTO hchNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Mericüsü me'ayenexüaca Huriyusixi vatuquita, müme menivarutavavirieni 'icü niuqui memütecuxatanicü tavari 'uxipiya tucarisie. ");
INSERT INTO hchNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Tuquipa mehecünecu yumüiretü Huriyusixi menivaranucuveiya Papuru Verunavemame, hipatüta Cacaüyari me'ayexeiyatü Huriyusixi memayuyeitüa vahamatü. Müme metenivacuxaxatüvacaitüni menivatuicacaitüni memüyuhayevacü tavari memücayupatacü Cacaüyari 'aixüa tiuca'iyaricacu vahesie mieme. ");
INSERT INTO hchNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Hicü tavari 'uxipiya tucarisie 'esivatücacu yunaitü quiecatari meniyucuxeürieni memi'enienicü Cacaüyari niuquieya. ");
INSERT INTO hchNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Huriyusixi mevaruxeiyaca müme memüyucuxeüri, meniuye'uxiva'ani. Meneuniuni Papuru niuquieya hepaüsita 'axa metecuxatatü. ");
INSERT INTO hchNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Papuru Verunave mecamamatü müpaü meniutiyuani, Püreuyevecai temütexetaxatüanicü xeme Cacaüyari niuquieya meri. Xeme xepixani'eri, xecaniyuhecüatani 'aixüa xemücate'u'iyari xehesie mütinaquenicü tucari mücaxüve. 'Ayumiemericü ta'aurie tepaxüri, nuivarite tenivatahüavicuni. ");
INSERT INTO hchNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Müpaü pütatiuta'aitüa Ti'aitame müpaü 'utaitü, Ne hecüarivivame nepümasi'ucaye nuivarite vahesie mieme Pemüvatavicueisitüanicü naisari cuie manunierepai. ");
INSERT INTO hchNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Hicü nuivarite me'i'enieca meniyutemamaviecaitüni. 'Aixüa meniutiyuanecaitüni Cacaüyari niuquieya hepaüsita. Yunaitü tucari mücaxüve memupitüarieniquecai yuri meteniuta'erieni. ");
INSERT INTO hchNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Mücü cuiepa naisarie pü'enieriecai Ti'aitame niuquieya. ");
INSERT INTO hchNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Huriyusixi mepüvarutaxamuri 'ucari memütehayexeiyacai memümarivacai, quiecatari va'uquiyarimata, memüvaruveiyanicü Papuru Verunave. Menivaranuyenü'ani yucuiepa. ");
INSERT INTO hchNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Müme meneicasixüani tumuanari yü'ücatesie 'inüari meyurietü vahepaüsita. 'Icuniyu meneta'axüani. ");
INSERT INTO hchNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Teyü'üquitüvamete vaücava meniyutemamaviecaitüni, 'Iyari Mütiyupatacü mecanihüpünecaitüni. ");
INSERT INTO hchNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Mericüsü 'Icuniyusie meyuteütatü meneutahaxüani Huriyusixi vatuquita. Metenicuxatacaitüni, 'ayumieme yuri meteniuta'erieni Huriyusixi Cüriyecusitüxita yumüiretü. ");
INSERT INTO hchNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Huriyusixi yuri memücate'eriecai mepüvarucunuitüa mepüvahaxüatüacai müme memücahuriyusixitücai ta'ivama vahepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Müme masi müixa 'amepütitecai mecamamatü Ti'aitamesüa memümiemetetücaicü. 'Iya tinihecüatacaitüni niuqui 'aixüa que mütiuca'iyari manuyüne hepaüsita. Püvarupitüaxüa yumamacü 'inüari mamarivaveme memüteyurienicü. ");
INSERT INTO hchNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Hicü quiecatari hixüata mepüyusanaxü. Hipatü Huriyusixi vahesie meteniviyacaitüni, hipatüta nü'arisixi vahesie meteviyacai. ");
INSERT INTO hchNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Müme memücahuriyusixitücai Huriyusixi vahamatü va'uquiyarima vahamatü menisutüani 'axa mevayuriecutü mevatuaxicutü. ");
INSERT INTO hchNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Nü'arisixi yamepütehetima, mepüyuta'unaxüa quiecaritesie Risitürasie Rerüvesie mana hurava Ricahuniya cuieyarisie. ");
INSERT INTO hchNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Muva mepe'uvacai metecuxatatü niuqui 'aixüa manuyüne. ");
INSERT INTO hchNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Mericüsü 'uqui Risitürasie pecatei müyutexiecai yü'ücatecü, hurietü mutinuivaxü hasuacua müca'uyeicacai. ");
INSERT INTO hchNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Mücü ni'eniecaitüni Papuru ticuxatame. 'Iya 'ixeiyatü, yatimaitü yuri müti'eriecaicü mütavicueisitüarienicü, ");
INSERT INTO hchNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","carima müpaü tinitahüave, Quenanucuquexi, 'a'ücate queneutixusera. Niutisuna, cuyeicatü nayani. ");
INSERT INTO hchNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Teüteri me'ixeiyaca Papuru que mütiuyuri, me'utihivatü Ricahuniyatari vaniuquicü, müpaü meniutiyuani, Cacaüyarixi tahesüa mepacanexüa teüteri vahepaü meteyuxexeiyatü. ");
INSERT INTO hchNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Verunave meputaterüvaxü Cupiteri, Papuru mete'utaterüvaxü Mericuriyu mücü niuqui mecutuacü masi. ");
INSERT INTO hchNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Cupiteri tuquieya quiecari 'aurie manuve, mara'acameya niva'atüani turusixi va'avate xuturiyatücaime quiteniesie. Teüteri vahamatü, 'iya mavari nivacui'iriemücücaitüni. ");
INSERT INTO hchNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Me'u'enanaca nü'arisixi Verunave Papuru, yu'ixuriqui metisanatü me'unausaxüaximetü meniu'axüani teüteri vahesüa me'utihivatü ");
INSERT INTO hchNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","müpaü me'utiyuatü, Xeme 'acu titayari müpaü xeteyurie. Tame xehepaü tecaniteüteritüni, xehepaü teteniu'iyarini. Tepütexetaxatüani niuqui 'aixüa manuyüne ta'aurie xemaxürienicü, xetehayevame 'icü yacü xemüyüa, Cacaüyari mayeyurisie xemüteviyanicü püta. Mücü muyuavi cuie haramara putivevi, naime vahesie mütiyeyeica tiutivevi. ");
INSERT INTO hchNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Xeteüterima quepaucua memanuticüpai nivapitüacaitüni yunaime nuivarite yuhuyeta memeu'uvanicü. ");
INSERT INTO hchNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Siepüre pücayuhayevacai caheixeiyatü que mü'ane mitahecüataque. 'Aixüa tiniyurienecaitüni, taheima mieme viyeri pütasipitüacai, 'icuaxi mutixuxuavere pütasipitüacai. Xe'iyarisie putihüniyaxü xemütecuacacü xemüyutemamaviecacü. ");
INSERT INTO hchNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Müpaü me'utiyuaca haveri mieme xeicüa menivarucunuitüani teüteri mavari memücavacui'irienicü. ");
INSERT INTO hchNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Mericüsü Huriyusixi mana meniu'axüani 'Anutiyuquiyasie 'Icuniyusie meheyecüneca. Menivarucunuitüani teüteri. Menitituaxixüani Papuru. Meneihana quiecari tesie müquime me'eritü. ");
INSERT INTO hchNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Teyü'üquitüvamete mehaquetücünecu 'auriena, nanucuqueni. Quiecarisie neutahani. 'Uxa'arieca Rerüve petüa Verunavematü. ");
INSERT INTO hchNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Mana niuqui 'aixüa manuyüne metenivacuxaxatüvacaitüni quiecatari, yuvaücavame meteniva'üquitüacaitüni. 'Arique ta'aurie menaxürieni, Risitürasie 'Icuniyusie 'Anutiyuquiyasie meniuyecüne. ");
INSERT INTO hchNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Teyü'üquitüvamete va'iyari meniutuicaxüani metevacuxaxatüvatü para yuri mete'erietü memüyuhayevacü, müpaü me'utiyuatü que müreuyevese vaüca te'u'uximatüarieme temeutahaxüani Cacaüyari müra'aitasie. ");
INSERT INTO hchNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Naisarie memüyutixexeürivacai va'uquiyarima menivaranucayasa. Meyutanenevieca me'uyuhaquieca mepihüritüa Ti'aitame müme yuri memüte'uta'erie hesiena vahepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Hicü Pisiriya cuieyarisie mepuyecü. Pamüpiriya cuieyarisie meniu'axüani. ");
INSERT INTO hchNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Perüquesie niuqui mete'utixataca meniucayune Hatareyasie. ");
INSERT INTO hchNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Mana naviyasie menecüne 'Anutiyuquiyasiepai haque memetatuiya Cacaüyari 'aixüa mütiuca'iyarinicü vahesie mieme, memüte'uximayacacü que memüteheye'atüa. ");
INSERT INTO hchNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Me'u'axüaca menivarucuxeürieni memüyuyexexeürivacai. Metenivacuxaxatüvacaitüni quepaümeme mütiyurienecai Cacaüyari vahamatü 'uyeicatü, müpaüta que müreteni yuri memüteta'erienicü nuivarite. ");
INSERT INTO hchNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Müixa meniyuhayeva teyü'üquitüvamete vahesüa. ");
INSERT INTO hchNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Mericüsü hipatü Cureya meheyecüneca meteniva'üquitüacaitüni ta'ivama müpaü me'utiyuatü, Xeme xüca xitequiyacü xeca'inüaritüarieni que maine Muisexi yeiyarieya, xepücayüvave xemütavicueisitüarienicü. ");
INSERT INTO hchNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Papuru Verunave yemecü meniniuquixiecaitüni niuqui metexüatüacai müiremecü vahepaüsita. 'Aixüa meniyurieni Papuru Verunavematü hipatü müme me'üaritü Querusareme memanuticünecü nü'arisixi vahesüa 'uquiravesixi vahesüa 'icü niuqui hepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Mana memüyuyexexeürivacai mepüvarenü'a. Penisiyasie Samariyasie mepuyecü metecuxatatü nuivarite vahepaüsita quename ta'aurie me'axürie me'utiyuatü. Yunaime ta'ivamarixi mepüvatemavieriyacai yemecü. ");
INSERT INTO hchNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Meheta'axüacu Querusareme, müme memüyuyexexeürivacai nü'arisixi 'uquiravesixi yunaitü menivarutanaqui'erieni. Metenitahecüatani naime que mütiyurienecai Cacaüyari vahamatü 'uyeicatü. ");
INSERT INTO hchNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Mericüsü hipatü Pareseusixi vahepaü memütecu'erivacai mecananucu'uni müpaü me'utiyuatü, Peuyevese temüvata'aitüani memü'inüaritüarienicü xitequiyacü, Muisexi 'inüari niuquiyarisie yamemütecahunicü reuyevese. ");
INSERT INTO hchNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Hicü meniyucuxeürieni nü'arisixi 'uquiravesixi yametehetimanique 'icü niuqui hepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Vaüca niuqui mexüatüacacu, Pecuru 'anucuqueca müpaü tinivarutahüave, Neuxei 'ivamarixi, xeme müpaü xepütemate, Cacaüyari meripaitü pünesi'anuyexei xesata, müme memücahuriyusixi memi'enienicü niuqui 'aixüa manuyüne ne ne'utaniucacacu, mücücü memütavicueisitüarienicü. ");
INSERT INTO hchNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Cacaüyari ta'iyari mümate tinivarutahecüatüani vapitüatü 'Iyari Mütiyupata tahepaü. ");
INSERT INTO hchNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Yücü pücatatiuxei müme tame. Yuri mete'uta'eriecu nivaru'itirieni va'iyari. ");
INSERT INTO hchNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Hicü camüsüari, titayari xete'i'isipatüve Cacaüyari, titayari yuyeiyari xetevaranuyetequirie teyü'üquitüvamete puixisixi vahepaü. Tatevarima tameta tepütatexiecai temenuyetenicü. ");
INSERT INTO hchNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Masi Ti'aitame Quesusi 'aixüa mütiuca'iyaricü yuri tepüte'erie quename tetavicueisitüarieni tame vahepaü. ");
INSERT INTO hchNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Mericüsü yunaitü cayuvatü meputamarixü, mepüvaru'enie Verunave Papuru metehecüatame 'inüari mamarivaveme que mütiyurienecai Cacaüyari memücahuriyusixi vasata müme metecuxatacacu. ");
INSERT INTO hchNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Cayuvatü mehexeiyacacu müpaü tinivaruta'eiya Cacuvu, Ne'ivamarixi xequenene'enieca. ");
INSERT INTO hchNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simuni tiniutahecüata Cacaüyari meripai que mütiyuvaüri menuyexeiyacü xei nuivariyari nuivarite vasata hesüana memümiemetetünicü. ");
INSERT INTO hchNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Yaxeicüa paine texaxatamete vaniuqui, müpaü que müre'utüariepaü, ");
INSERT INTO hchNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","'Arique ta'aurie nepaveni. Raviri quiya nepütavevieni mü'unicai. Cüyexiyari mana meutihe nai nepanucu'uitüani. Nepiseiriya. ");
INSERT INTO hchNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","'Ayumieme teüteri memüyuhayeva menicuvaucuni Ti'aitame Yunaitü nuivarite vahesie mieme nemücühüavarüva Neteüterima memüteteteva ");
INSERT INTO hchNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Müpaü paine Ti'aitame masiücüme meyeitüa 'icü matüaripai. ");
INSERT INTO hchNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","'Ayumieme ne 'ipaü nepüticu'eriva, tepücava'uximatüaca müme memücahuriyusixi ta'aurie memaxürie Cacaüyarisie memüteviya. ");
INSERT INTO hchNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Xapacü tepüvata'aitüani xeicüa memüyucuerivayuriecacü tita mütisevixima tetexi vahesie mütimiemecü, mücü hepaüsita, memücavacumaüvanicü que mü'ane mücayü'üya mücayücüna, memüyucuerivayuriecacü 'ucaviyacame vaiyarieya hepaüsita xuriya hepaüsita memüca'icuanicü. ");
INSERT INTO hchNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","'Iya Muisexi meripaitü hicüque püvarexeiya müme memitahecüata quiecari mucumanesie vatuquiteta yamemüte'ititerüva 'uxipiya tucarisie. ");
INSERT INTO hchNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Mericüsü nü'arisixi 'uquiravesixi vahamatü yunaitü memüyuyexexeürivacai vahamatü 'aixüa 'aneme meni'eriecaitüni yusata memüvaranuyexeiyacü 'uquisi, memüvaranunü'anicü 'Anutiyuquiyapai Papuru Verunave vahamame. Menivaranuyexeiya Cura Varüsavaxi mütitevacai, Siraxi meta. Müme 'uquisi mepüte'aitametetücai yu'ivama vasata. ");
INSERT INTO hchNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","'Ipaü meteniu'utüani memenuhurienicü xapa, Nü'arisixi 'uquiravesixi 'ivamarixi tecanixevaüritüaca ta'ivamarixi 'Anutiyuquiyasie Siriyasie Sirisiyasie xemümiemete xemünuivarite. ");
INSERT INTO hchNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Tepu'enana quename hipatü tahesüa miemete mexexamurietüvecai yuniuquicü xe'iyari meyuitüatüvetü mexe'aitüatü xemüyu'inüaritüanicü xitequiyacü, 'inüari niuquiyarisie yaxemütecahunicü. Tame tepücateva'aitüa. ");
INSERT INTO hchNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Mericüte, 'axeicüa te'uta'enieca 'aixüa 'aneme teni'eriecaitüni temüvaranuyeteüxücü 'uquisi temüvaranunü'anicü xehesüa Verunave Papuru temüvanaqui'eri vahamame. ");
INSERT INTO hchNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Müme yutucari meniyetuacaitüni Quesusi Cürisitu Tati'aitüvamesüa memümiemetecü. ");
INSERT INTO hchNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","'Ayumiemericü tepüvarenü'a Cura Siraxita. Müme yuniuquicü yaxeicüa mepütexehecüatüani. ");
INSERT INTO hchNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","'Aixüa 'anemeta tepü'eriecai tameri, 'Iyari Mütiyupatata, haheteme temücaxeti'icatüanicü, 'icü xeicüa que müreuyevese, ");
INSERT INTO hchNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","xemüca'icuacacü tita tetexi memütexatüarie, xuriya, que mü'ane mücaviyacame vaiyarieya, xemücavacumaüvanicü que mü'ane mücaxe'üya mücaxecüna. Xüca mücü xeca'umayüani, 'aixüa xepüyüaca. Müpaü xeicüa cani'aneni. ");
INSERT INTO hchNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Mericüsü müme memeyenü'ari meniu'axüani 'Anutiyuquiyasie. Mevarucuxeürieca yunaime meniyetuani xapa. ");
INSERT INTO hchNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Me'itaterüvaca mecaniyutemamaviecaitüni 'ivamarixi memütuicariecaicü. ");
INSERT INTO hchNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Cura Siraxi memütexaxatametetücaicü, vaüca metecuxatatü menivatuicacaitüni yu'ivama, menivaseiriyacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Yapaümexa tucari me'uyurieca, yu'ivama vahesüa menecüne 'aixüa metevaxeiyatü. Müme memüvareyenü'a vahesüa meniu'axüani. ");
INSERT INTO hchNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Siraxisietü 'aixüa tini'eriecaitüni mana muyuhayevacü. ");
INSERT INTO hchNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Papuru Verunavematü mana meniyuhayevani 'Anutiyuquiyasie mete'üquitatü Ti'aitame niuquieya, metecuxatatü niuqui 'aixüa manuyüne hipame yumüireme vahamatü. ");
INSERT INTO hchNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Mericüsü yapaümexa tucari 'anucayacu, Papuru müpaü tinitahüave Verunave, Cümüsüari hutarieca tepüyehu, ta'ivama tepüva'ivatayu naime quiecaritesie haque temütecuxatacai Ti'aitame niuquieya, parasü que metecahu. ");
INSERT INTO hchNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Verunave nivitümücücaitüni Vani Maricuxi mütitevacai. ");
INSERT INTO hchNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Papururi müpaü tinicu'erivacaitüni, 'aixüa püca'anecai memenuvitünicü que mü'ane müvarecu'eirie Pamüpiriyasie, vahamatü mücahetüa müti'uximayacacü. ");
INSERT INTO hchNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","'Ayumieme mepuyeha'a, mepeutayeixüa. Verunave Maricuxi havitütü naviyasie petüa Sipürepai. ");
INSERT INTO hchNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Papururi 'enuyexeiyaca Siraxi caneyani. Ta'ivama menihüritüani Ti'aitame 'aixüa mütiuca'iyarinicü müme vahepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Siriyasie Sirisiyasie puyetüa vatuicatü müme memüyutixexeürivacai. ");
INSERT INTO hchNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Mericüsü Rerüve Risitüra caneta'ani. Mana pecatei tiyü'üquitüvame Timuteu titevatü. Varusieya Huriyu yuri müti'eriecai nihücütücaitüni, quemasieya Cüriyecu tihücütücai. ");
INSERT INTO hchNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","'Ivamarixi Risitüratari 'Icuniyutari menihecüatacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Papuru pita'ini hamatüana müyemiecü. Ni'inüaritüani 'ixitetü Huriyusixi teüteriyari vayeiyari que maine, Huriyusixi muva memütamacai vacü, yunaitü memimaicaicü quemasieya mücüriyecutücaicü. ");
INSERT INTO hchNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Mecu'uvatü quiecaritesie menivahüritüacaitüni yamemütecahunicü 'aisicasie que memüte'aitacai nü'arisixi 'uquiravesixi Querusaremetari. ");
INSERT INTO hchNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Memüyutixexeürivacai menituicariecaitüni yuri mete'erietü. Tucaricü que memüyupaümecai metenimüiriyacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Mericüsü Püriquiyasie Carasiya cuieyarisie meniuyecüne. 'Iyari Mütiyupata püvanenacai 'Asiyasie memücatecuxatanicü niuqui. ");
INSERT INTO hchNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Misiya cuieyari tesita me'u'axüaca Vitiniyasie meneuyeyunequecaitüni. Quesusi 'Iyarieya yapücativarupitüa. ");
INSERT INTO hchNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Misiya cuieyari tesita me'uyenexüaca mana meneucacüne Türuhasipai. ");
INSERT INTO hchNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Yüvicüta heinüsita Papuru nixeiya 'uqui Maseruniyatanaca muva 'utiveme yativavirietü müpaü 'utaitü, Quenanaye'a 'anataüye Maseruniyapai, quetaneparevieca. ");
INSERT INTO hchNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Yuheinüsita 'ixeiyacu cuitü tepicuvau que temüte'anucünecü 'anutaüye Maseruniyapai müpaü tete'umaica Cacaüyari mütasi'uta'inie temütevaretaxatüanicü niuqui 'aixüa manuyüne. ");
INSERT INTO hchNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Mericüsü Türuhasi tehecüneca heiseriemecü tecaneta'axüani Samutürasiyasie, 'uxa'arieca Quiecari Mühecuasiepai teneta'axüani, ");
INSERT INTO hchNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","'arique Piripusiepai. Mücü quiecari 'amüyeva nihücütücaitüni 'esimüyeyeu hesiena mütiviya Maseruniya cuieyarisie. Xumatari canivacuruniyatücaitüni. Yapaümexa tucari teniuyurieni 'iya quiecarisie. ");
INSERT INTO hchNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","'Uxipiya tucarisie tepanuyenexüa quiecari tesie. Mana hatüa tesita mürayutinenevitüre 'uveme teni'eriecaitüni. Mana tetiyaxeca tenivarutaxatüani 'ucari mana memüyuxeürie. ");
INSERT INTO hchNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Xevitü 'uca Ririya mütitevacai purupura 'ixuriquiyari mutuacai Tiyatira quiecarisie mieme meyexeiyacai Cacaüyari, mücü pütasi'u'enie. Ti'aitame nivatiyepieni 'iyarieya mi'enienicü Papuru que mainecai. ");
INSERT INTO hchNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Mücü puca'üyarie, quiena quiecatarita. Hicü cataniuta'inieni müpaü 'utaitü, Xeme Ti'aitamesie yaneticamieme xüca xenesi'erieca, nequie xequeneu'axüaca, mana xequenetiteni. Müpaü 'utaitü vaüriyarica cataniupitüani. ");
INSERT INTO hchNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Mericüsü mürayutinenevitüre tehecünecu, 'üimari vaüriyarica müti'uximayacai catananucunaque. Xevitü cacaüyari pinücai mütimaicai que mütiyüniquecai 'arique. Mücü ticuxatatü que mütiyüniquecai vaüca püti'ivacai yucusiyarima vahesie mieme. ");
INSERT INTO hchNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Mücü pütasi'uveiyacai Papuru tameta. Putahivacai müpaü 'utaitü, Cacaüyari taheima macavesie mieme mepüte'uximaya 'icü 'uquisi. Mepütexetahecüasitüani huye xemütavicueisitüarienicü. ");
INSERT INTO hchNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Müpaü tiniyurienecaitüni müixa tucari. Hicü puti'uxixü Papuru. Ta'aurie 'aveca müpaü tinitahüave 'iya cacaüyari, Quesusi Cürisitusüa nemümiemecü nepümasita'aitüani, queneuxüna. ");
INSERT INTO hchNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Cuitü nixüna. Cusiyarimama me'uneniereca que müretüa cümana memüte'ivaniquecai, mepüvarutivi Papuru Siraxi. Quiecari hixüapa mepüvarehapa haque va'uquiyarima memacatei. ");
INSERT INTO hchNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Mevarevitüca püraheturisixi memü'isücatetücai vahesüa, müpaü meniutiyuani, 'Icü teüteri mepüvaxamurietüve tahesüa quiecatari. Mecanihuriyusixitüni. ");
INSERT INTO hchNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Mepihecüata tutuyari tame Xumatari temücatauniva temitanaqui'erieni yatemüteyurienicü. ");
INSERT INTO hchNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Yunaitü meniyucuxeürieni vahepaüsita. 'Isücate va'ixuriqui menivaranutihüniriexüani. Meteniuta'aita memütiveiyanicü cüyecü. ");
INSERT INTO hchNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Mevarutivaca vaüca, menivaranutaxürieni casariyanata. Menihüritüani 'aixüa mütiva'üviyanicü tihüveme. ");
INSERT INTO hchNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Mücü 'aisica 'utanaqui'erieca nivaranutaxürieni mutapurupai. Neiye'uitüani va'ücate tiyüxürüvamesie. ");
INSERT INTO hchNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Mericüsü tücari hixüapa yacütütü Papuru Siraximatü meyunenevietü meninüavacaitüni Cacaüyari. Vahamatü memanutaxüriyacai meniva'eniecaitüni. ");
INSERT INTO hchNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Yapaucua cuie carima niutayuani, casariyanatüa mieme tiutayua. Naitü quiteniete püreutenirixüa. Yunaime vatepüate canacaxürieni vamamasie va'ücatesie. ");
INSERT INTO hchNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","'Anutaniereca tihüveme, 'ixeiyaca casariyana quitenie hatetenime, yucusira nivatihana yumienique, memanutaxüriyacai meyuta'unaxüame 'erietü. ");
INSERT INTO hchNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Papuru carima nitahivieni, Penücahürixüa peti'acuinitüani rehüavetü, Tame tanaitü 'uva tecanayeteni haitü. ");
INSERT INTO hchNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","'Ita'aitüaca tai, 'utayüyüacatü, quita neutasuna. Pucave Papuru Siraxi vahetüa. ");
INSERT INTO hchNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Tacua varanuyevitüca müpaü niutayüni, Neuxei, tita reuyevese yanemütiyurienicü nemütavicueisitüarienicü. ");
INSERT INTO hchNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Müme müpaü meniutiyuani, Yuri quetineuta'eri Ti'aitame Quesusisie, mücücü pecanitavicueisitüariemücü 'ecüri, 'aquie quiecatarita. ");
INSERT INTO hchNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Metenivacuxaxatüvacaitüni Cacaüyari niuquieya 'iya, yunaime quitana memüye'uvacai hamatüana. ");
INSERT INTO hchNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Mücü nivarevitüni cuitü yüvicüta, nivarahauxixüani memaveiyatücateisie. Yareutevitü mepuca'üyarie 'iya, yunaitü hesüana miemete 'axeicüa. ");
INSERT INTO hchNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Yuquie varevitüca mexasie 'atinapini, yunaitü yuri mete'uta'erieca Cacaüyarisie 'axeicüa meniyutemamaviecaitüni. ");
INSERT INTO hchNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Hicü 'ucatarecu 'isücate yutupirisixi menivarenü'ani müpaü me'utiyuatü, Quenivarutixüna mücü teüteri. ");
INSERT INTO hchNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Tihüveme nitahecüatüani Papuru 'icü niuqui hepaüsita, müpaü 'utaitü, 'Isücate niuqui meneyenü'ani xemütixünarienicü. Hicüsüari xe'ayecüneme xequenehu xeca'uximatüarietü. ");
INSERT INTO hchNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Papuru müpaü tinivarutahüave, Müme mepütasi'utiva yunaime vahüxie sepa 'isücame havai pücatatahüave, sepa temüxumanusixi. Mepütasi'anutaxüri. Caucasü hicü metasi'anuyenü'ani 'avie. Tixaütütüri, 'uva meque'u'axüani, mümetütü mequetasi'anuyevitüni. ");
INSERT INTO hchNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Tupirisixi metenivarutahecüatüani 'isücate que mütiuyü. Quepaucua memu'enana quename Xumanusixi mehümetücai, mepümamacai. ");
INSERT INTO hchNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Me'u'axüaca menivanütüacucaitüni, mevaranuyevitüca menivarutavavirieni memüyehucü 'iya quiecarisie. ");
INSERT INTO hchNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Hicü casariyanata me'ayenexüaca Ririyasüa meniu'axüani. Mevaruxeiyaca yu'ivamarixi menivatuicani menecüne. ");
INSERT INTO hchNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Mericüsü 'Amipipurisie 'Apuruniyasie me'uyecüneca meneta'axüani Tesarunicasiepai. Huriyusixi vatuqui mana niuvecaitüni. ");
INSERT INTO hchNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Papuru que mütiyeiyarieyatücai, vahesüa neutahani, hairieca 'uxipiya tucarisie tinivacuxaxatüvacaitüni ");
INSERT INTO hchNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","'utüaricasie mieme vahecüatüatü vatuicatü quename reuyevecai 'iya Cürisitu heiserie mupitüarie müticuinecü müquite vasata manucuquenicü, müpaü 'utaitü, 'Icü nemüxehecüatüa, 'icü que mü'ane heiserie mupitüarie Cürisitu canihücütüni Quesusitütü. ");
INSERT INTO hchNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Hipatü müme yuri meteniuta'erieni, Papurusie Siraxisie meteniuviya. Yumüiretü Cüriyecusixi memeyexeiyacai Cacaüyari, yumüiretü 'ucari ve'emete mecanihümetücaitüni. ");
INSERT INTO hchNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Huriyusixi yuri memücate'eriecai me'uxiva'atü menivaruta'inieni hipame 'axa memüteyuriecai quiecari hixüapa memu'uvacai, mevaruxeürieca yumüireme menivareutaxamuriexüani quiecatari. Casuni quie me'u'axüaca mepüvarutavaviri memüvaranuyevitünicü nü'arisixi quiecatari memüyuyexexeürivacai vahürüpa. ");
INSERT INTO hchNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Mecavataxeiyavavetü, Casuni hipame 'ivamamata mepüvarahapa 'isücate vahüxie müpaü mete'uhivatü, 'Ime naisarie cuiepa memütama menivaxamurietüveni, 'uvata meniu'axüani. ");
INSERT INTO hchNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Casuni nivarutanaqui'erieni. 'Ime yunaitü yamepücatecahu Sesaxi que müti'aita, meniutiyuani quename xevitü ti'aitametütü 'a'uyeica Quesusitütü. ");
INSERT INTO hchNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Müpaü me'utiyuatü menivamuinacaitüni yunaime memu'uvacai, 'isücateta memi'enie 'icü. ");
INSERT INTO hchNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Casuni hipatüta meniucuetatüarieni 'uxa'atüni varie 'asimücatiyünicü, meniutixünarieni. ");
INSERT INTO hchNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Mericüsü cuitü yüvicüta teyü'üquitüvamete mepüvarenü'a Papuru Siraxi memüyehucü Vereyasiepai. Mana me'u'axüaca Huriyusixi vatuquita meneutahaxüani. ");
INSERT INTO hchNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Mana memütamacai Huriyusixi yemecü 'aixüa mepüte'u'iyaricai, Tesarunicatari yamecate'u'iyaricacu. Menitanaqui'erieni niuqui vaüca meyuvaüriyatü. Tucaricü metenicuvautüvecaitüni 'utüarica xapayarisie siparasü xüca müpaü 'aneniqueyu 'icü. ");
INSERT INTO hchNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Yumüiretü müme yuri meteniuta'erieni. 'Ucari memücüriyecusixitücai memüseüyecai, 'uquisita yuvaücavatü yuri mepüte'uta'erie. ");
INSERT INTO hchNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Mericüsü Huriyusixi Tesarunicatari metenetimani quename Papuru tihecüatacai Cacaüyari niuquieya Vereyasieta. Manarita meniu'axüani mevacuyuitüvatü mevamuinatüvetü teüteri yumüireme. ");
INSERT INTO hchNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","'Ivamarixi cuitü meneinü'ani Papuru haramara tesita müyemiecü. Siraxi Timuteu Vereyasie meniyuhayeva. ");
INSERT INTO hchNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Müme memiteütacai Papuru meneivitüni 'Atenasiepai. Mana menitinuaxüani 'iya müpaü tivaruta'aitüacu, Siraxi Timuteu hesüana memü'axüanicü mexüima. ");
INSERT INTO hchNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Mericüsü Papuru vacuevietü 'Atenasie, yu'iyarisie niyühüavecaitüni müvaxeiyacaicü quiecatari tetexi me'ayexeiyame yemecü. ");
INSERT INTO hchNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Tuquita niuqui nixüatüacaitüni Huriyusixi vahamatü, hipameta Cacaüyari memayexeiyacai vahamatü. Quiecari hixüapata tucaricü niuqui nixüatüacaitüni mana memu'uvacai vahamatü. ");
INSERT INTO hchNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Hipatü 'Epicureyusixi 'Esituicusixi temaivavemete meniti'eiyarümecaitüni. Hipatü müpaü meniutiyuanecaitüni, Titacuta raineniqueyu 'icü niuquivivame, hipatüta 'ipaü mete'utiyuanecai, Süricüte cacaüyarixi xaüsie miemete nivahecüatani. Müpaü meniutiyuanecaitüni Papuru Quesusi müxatacaicü, müquite que memüte'anucu'uni müticuxatacaicüta. ");
INSERT INTO hchNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Meneivitüni 'isücate 'Arexi yemuriyarisie memüyuyexexeürivacai vahürüpa müpaü me'utiyuatü, Siparasü tame xüca teyüvaveni temeitimaniqueyu que mütitita 'icü 'üquisica mühecua pemüxata. ");
INSERT INTO hchNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Xaüsie timieme pepütasi'atüiri tanacata. 'Ayumieme tecatenetimaniqueyu que maine 'icü. ");
INSERT INTO hchNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","'Atenatari yunaitü, cu'uvamete mana memü'ivatatüveta 'asimepücateyuruva, tixaütü mütihecua mepütahüavicu mepüte'eniecu xeicüa. ");
INSERT INTO hchNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Hicü 'isücate vahixüata 'uvetü 'Arexi yemuriyarisie müpaü niutayüni Papuru, Neuxei 'Atenatari, necanixexeiyani xeme naimecü xevarayexeiyame memanucuneniere. ");
INSERT INTO hchNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","'Uva necuyeicatü ne'i'ixüarietü tita xemüte'ayexeiya, neneitaxeiya mürayutimavatüre, hesiena mütiuti'utüari 'ipaü, CACAÜYARI TEMÜCAMATESIE PÜMIEME 'ICÜ. Mericüte, que mü'ane xemayexeiya xeca'imaitü, mücü nenixetahecüatüamücü ne. ");
INSERT INTO hchNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Mücü Cacaüyari mitivevi cuie, nai cuiepa mütimieme, mücü tini'aitani muyuavisie cuiepata. Mücü mamacü müveviyata püca'ayeca tuquita, ");
INSERT INTO hchNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","teüteri yumamacü mepüca'eyexeiya, tixaü mücareuyehüvacü. Mücütütü pütivamicua vatucari va'iya naime. ");
INSERT INTO hchNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Xeime tevi va'uquiyari 'ayeitüaca, püvarutivevi yunaime nuivarite naisarie cuie manuniere memütamacacü. Vatucarite meripai pucaye, vacuie 'inüariyari tiucaye ");
INSERT INTO hchNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","memicuvaunicü Cacaüyari siparasü mecumetüvetü memitaxeiyacü. Xüari mücü teva püca'uyeica taxexuime tahesüa. ");
INSERT INTO hchNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","'Iyasie teteviyatü tenayeneniereni tenicuyuaneni teniu'uvani, müpaü que memutiyuanepaü hipatü teyününüavamete xehesüa miemete, Tame hesiena tepüyecü, me'utiyuatü. ");
INSERT INTO hchNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Mericüte, xücasü hesiena teyecüne, 'aixüa püca'ane para müpaü temüte'ixeiyani hurupaü püratapaü tetepaü 'aneme, tevi veviyayapaü 'aneme, tita tevi mütiyücühüavepaü 'aneme. ");
INSERT INTO hchNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Mericüsü Cacaüyari 'axa pücatixeiyacai tita memüteyuriecai quepaucua 'asimemücatemaicai, peru hicüri püvahecüasitüa yunaime teüteri naisarie memütama memütehayevanicü que memüteyurie. ");
INSERT INTO hchNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Xeime tucari pütiucaye müva'inüatanicü cuiepa memütama heiseriemecü yüanetü, 'iya 'uqui manuyexei yatiyurienecacu. Cacaüyari yuricü nivarutahecüatüani yunaime, 'enucuquetüaca 'iya müquite vasata. ");
INSERT INTO hchNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Hicü me'u'enanaca müquite que memüte'anucu'uni, hipatü meninanaimacaitüni, hipatüta müpaü meniutiyuani, Hutarieca tepümasi'enieni 'icü hepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Hicü tiuhayevaca Papuru, vahixüata nayeneni. ");
INSERT INTO hchNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Hipatü hesiena meteviyatü yuri meteniuta'erieni. Riyunisiyu mü'isücametücai 'Arexi yemuriyarisie miemetütüri, xevitü 'uca Ramarisi mütitevacairi, hipatüri vahamatü yuri mepüte'eriecai. ");
INSERT INTO hchNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","'Arique 'Atenasie heyeyaca Curinitusie neta'ani. ");
INSERT INTO hchNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Muva neitaxeiya xeime Huriyu 'Aquira mütitevacai Punitusie metinuivaxü yü'üitacame Pürisiramame. Xique punua 'Itariya cuieyarisie heyeyaca, Cürauriyu mütivaruta'aitüacü yunaime Huriyusixi memüyehucü Xumasie. Vahesie tiniuviya Papuru. ");
INSERT INTO hchNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Vahepaü 'ivarica mexeiyacaicü, vahesüa niucateitüni, meteni'uximayacaitüni yuhamatü. Müme 'ixuriqui quiyari mecanivevivametetücaitüni. ");
INSERT INTO hchNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Xexuime 'uxipiya tucarisie tuquita tinicuxatacaitüni, Huriyusixi Cüriyecusixi yuri tiniva'eritüamücücaitüni. ");
INSERT INTO hchNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Hicü Siraxi Timuteu meheyecünecu Maseruniyasie, me'u'axüacu, Papuru niuquicü 'ayumiemetütü nayani, tivahecüatüatü Huriyusixi quename Quesusi hücü que mü'ane heiserie mupitüarie Cürisitütü. ");
INSERT INTO hchNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Me'i'uxive'eriecacu 'axa me'utiyuanecacu müme, Papuru yu'ixuriqui 'utacaseca 'inüari 'ayeitüaca, müpaü tinivarutahüave, Xeme yuhesie xepütehahüpa xüca xe'ucuini. Ne püta nepü'itiya. Hicürixüa memücahuriyusixi vahesüa nepüyemie. ");
INSERT INTO hchNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Muva 'ayeneca xeime quie ninuani Cusitu mütitevacai quiecame. Mücü neyexeiyacaitüni Cacaüyari. Quiena pehuracai tuqui. ");
INSERT INTO hchNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Cürisipu tuqui va'üyaritütü yuri tinita'eririeni Ti'aitame, yunaitü quiena quiecatari hamatüana yuri mete'uta'erita. Yumüiretü Curinitutari me'u'enanaca yuri mepüte'uta'eri mepuca'üyarie. ");
INSERT INTO hchNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Yüvicüta Ti'aitame müpaü tinitahüave Papuru heinüsita, Pepücamaca, masi quetinecuxatani, cayuvatü pepücaticani. ");
INSERT INTO hchNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Ne 'ahamatü 'anepuyeica, xevitü tixaü pücamasiviya 'axa masiyurienique. 'Icü quiecarisie yuvaücavame teüteri necanivarexeiyani. ");
INSERT INTO hchNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Xei viyari heimana 'ataxeime meseri mana puyuriecai tiva'üquitüatü Cacaüyari niuquieya. ");
INSERT INTO hchNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Mericüsü, Careuni cani'isücametücaitüni, 'Acaiya cuieyarisie mühüritüariecai. Huriyusixi 'axeicüa mepuyuxeüri Papuru mehecatü. Meneivitüni 'isücame 'uvenieya hüxie haque müre'inüatacai ");
INSERT INTO hchNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","müpaü me'utiyuatü, 'Icü yuri tiniva'eritüaca teüteri Cacaüyari memayexeiyanicü 'inüari niuquiyari que mücahaine. ");
INSERT INTO hchNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Papuru 'esivatücacu pütaniuximecai, masi Careuni müpaü tinivarutahüave Huriyusixi, Neuxei Huriyusixi, 'icü xüca caheiserietünique xüca cuamanaricatünique 'icü, xasunimecü nepüxe'enieniqueyu Huriyusixi. ");
INSERT INTO hchNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Mesü xüca xeniuquixieca niuqui hepaüsita terüvarica hepaüsita xe'inüari hepaüsita xeicüa, 'aixüa xequeteneuyuri xemetütü. 'Isücame nepüca'ayeimücü 'icü hepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Nivaranuyenü'ani yuhüxie. ");
INSERT INTO hchNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Müme yunaitü me'iviyaca Susitenexi tuqui va'üyari mühücütücai, meneicuvaxüani 'isücame 'uvenieya hüxie. Careuni 'asipücahainecai 'icü hepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Mericüsü Papuru müixa tucari mana puyuhayevaxü. Varutateutüaca yu'ivama Siriyasie nanuyani naviyasie. Pürisira 'Aquira hamatüana menecüne. Meripai müyühüritüacaicü, 'ayumieme Senicüreyasie yumu'usie pucaxiri. ");
INSERT INTO hchNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Hicü 'Epesusie meneta'axüani. Mana nivarecu'eirieni Papuru. 'Iya tuquita heutahaca niuqui nixüatüacaitüni Huriyusixi vahamatü. ");
INSERT INTO hchNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Müme menitavavirieni yapaümexa tucari müyurienicü vahesüa, perusü mücü pücayuvaüriyacai. ");
INSERT INTO hchNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Nivarutateutüani masi müpaü 'utaitü, Yemecü neuyeveca Querusareme nemü'ixüaramieni 'umamiesie. Hutarieca neninuamücü xehesüa xüca müpaü tinaqueni Cacaüyari. Hicü 'Epesusie neyani. ");
INSERT INTO hchNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Hicü Sesareyapai nuaca, heutiyuneca, nivavaüritüani memüyutixexeürivacai, 'arique 'Anutiyuquiyasie petüa. ");
INSERT INTO hchNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Yapaümexa mana 'uyurieca caneyani 'uyemietü Carasiya cuieyarisie Püriquiyasie yunaime teyü'üquitüvamete vatuicatü. ");
INSERT INTO hchNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Mericüsü Huriyu teviyari 'aniuyeicacaitüni 'Apuruxi mütitevacai Herecanitüreyasie metinuivaxü. 'Epesusie caninuani. 'Aixüa pü'anecai niucamecü. 'Utüarica xapayaricü pütürücaüyecai. ");
INSERT INTO hchNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Mücü Ti'aitame huyeya hepaüsita tiniuta'üquitüarieni. 'Aixüa 'iyaricü niyuvaüriyacaitüni. Tinicuxatacaitüni ti'üquitatü heiseriemecü Quesusi hepaüsita, sepa mütimaicai Vani que mütiu'üyacai xeicüa. ");
INSERT INTO hchNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Tuquita nisutüani ticuxatatü yutatuatü. Me'i'enieca Pürisira 'Aquira menita'inieni, heiseriemecü masi meteni'üquitüacaitüni Cacaüyari huyeya hepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Mücü niyeimücücaitüni 'Acaiya cuieyarisie. 'Ivamarixi me'ituicatü metenivaruta'utüirieni teyü'üquitüvamete memitanaqui'erienicü. Henuaca vaüca nivapareviecaitüni müme yuri memüte'uta'eri Cacaüyari 'aixüa tiuca'iyaricacu. ");
INSERT INTO hchNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Yunaime vahüxie cuini mieme nivara'ivaxüani Huriyusixi yuniuquicü, 'utüarica xapayarisie tivaxeisitüatü quename que mü'ane heiserie mupitüarie Cürisitutütü, Quesusi hücütücai. ");
INSERT INTO hchNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Mericüsü 'Apuruxi Curinitusie 'uyeicacacu cuxi, Papuru hüri 'utüa 'uyeyaca 'Epesusie neta'ani. Hipame nivaretaxeiya muva teyü'üquitüvamete. ");
INSERT INTO hchNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Müpaü tinivarutahüave, 'Iyari Mütiyupata xete'utanaqui'eri yuri xete'uta'erieca. Mümesü müpaü metenitahüave, Masi tepüca'enanavave quename 'Iyari Mütiyupata xuave. ");
INSERT INTO hchNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Mücü müpaü niutayüni, Mericüte, titasie xeteviyatü xete'uca'üyarie. Müme müpaü meniutiyuani, Vani que mütiu'üyacai teniuca'üyarieni tame. ");
INSERT INTO hchNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Papuru müpaü niutayüni, Vani nivaruca'üyacaitüni metehayevacacu que memüteyuriecai, müpaü tivacuxaxatüvatü teüteri yuri memüteta'erienicü que mü'ane 'utümana 'umamiecaisie. Mücü Quesusi canihücütücaitüni Cürisitutütü. ");
INSERT INTO hchNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Me'u'enanaca meniuca'üyarieni Ti'aitame Quesusisüa memiemetetütü. ");
INSERT INTO hchNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Vaheima 'utimecu Papuru, 'Iyari Mütiyupata mehexeiyatü mepacü. Niuquitecü meniutiniutücüne, Cacaüyarisie mieme metenicuxatacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Yunaitü tamamata heimana yuhutatü yacütütü mepüyupaümecai 'uquisi. ");
INSERT INTO hchNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Mericüsü haica meseri puyuriecai Huriyusixi teüteriyari vatuquita 'axetü, ticuxatatü camatü. Niuqui nixüatüacaitüni, yuri tiniva'eritüamücücaitüni, que müti'ane Cacaüyari ti'aitametücacu ticuxatatü. ");
INSERT INTO hchNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Hipatü menisese'icaitüni. Yuri mecacateniuta'erieni, 'axa me'utiyuatü 'iya huye hepaüsita yumüireme vahüxie. Papuru varucu'eirieca nivaranuyevitüni teyü'üquitüvamete. Tucaricü Tiranu müti'üquitacaisie niuqui nixüatüacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Müpaü tiniyurienecaitüni huta viyari. Yunaitü 'Asiyasie memütamacai Huriyusixi Cüriyecusixi meni'enieni Ti'aitame Quesusi niuquieya. ");
INSERT INTO hchNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Mericüsü 'inüari türücavime tiniyurienecaitüni Cacaüyari Papuru yatiyurienecacu, xaüsie müpaü mücatiyurienecaipaü. ");
INSERT INTO hchNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Tecuicuicate mepüvarahuririvacai tuvaxate peserate manacatütücatei Papuru. Mücücü yucuiniyacü mepanayexürüvecai, cacaüyarixi 'axa memü'anene mepüvarutixünaxü. ");
INSERT INTO hchNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Hipatü cu'uvamete Huriyusixi cacaüyarixi memüvaranuyenü'avacai, müme menitixatatücüne Ti'aitame Quesusi, cacaüyarixi 'axa memü'anene memüvanücai teüteri vahepaüsita, müpaü me'utiyuatü, Ne nepüxe'aitüa Quesusisüa Papuru mitahecüatasüa nemümiemecü, me'utiyuatü. ");
INSERT INTO hchNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Hicü Huriyu 'Isiqueva mütitevacai mara'acate memühüritüariecai vahesüa mümiemetücai, mücü 'atahutame nivarexeiyacaitüni yunivema müpaü memüteyuriecai. ");
INSERT INTO hchNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Hicü cacaüyari 'axa mü'ane müpaü tinivaruta'eiya, Quesusi nepümate, Papuruta nepetima. Xemesü que xepühatetütü. ");
INSERT INTO hchNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Mücü tevi cacaüyari 'axa mü'ane miviyacai vaheima niutiveni, nivara'iva yunaime türücaüyetü. Mümesü memamavetü meheuxitequietücaitü meniyuta'una 'iya quita. ");
INSERT INTO hchNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Yametenetimani que mütiuyü yunaitü Huriyusixi Cüriyecusixi 'Epesusie memütamacai. Cui menimamacaitüni yunaitü. Que mü'ane Ti'aitame Quesusi mühücü 'aixüa cuxasivatü nayani. ");
INSERT INTO hchNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Yumüiretü yuri memüte'uta'eri meniu'axüani meyumurucuitüatü me'ihecüatatü yu'iquevari. ");
INSERT INTO hchNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Yumüiretü müme memüteyuquevayametetücai, xapayari me'ucuxeürieca menititaiya yunaime vahüxie. Meniti'inüata 'axeicüa que müraye'arücai xapayari. Huta teviyari heimana tamamata miriyari pürata tuminiyari 'inüariyari naye'arücaitüni. ");
INSERT INTO hchNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Müpaü tiuyücu, Ti'aitame niuquieya türücaüyemecü niutimüire, caniutürücare. ");
INSERT INTO hchNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Mericüsü müya tiuyücu, Papuru yu'iyarisie niyuvaüriya Maseruniyasie 'Acaiyasie 'uyeyame meta'anicü Querusaremesie, müpaü 'utaitü, Mana neheta'ayu, 'arique peuyevese nemixeiya Xumata. ");
INSERT INTO hchNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Yuhutame 'iparevivamete Timuteu 'Erasitu varenü'aca Maseruniyasie, mücütütü 'acuxi 'apüreutevicai 'Asiyasie. ");
INSERT INTO hchNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Mericüsü 'ana vaücavamecü mepüyumuinacai teüteri 'iya huye hepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Xevitü Remetüriyu mütitevacai püratavevivame mühücütücai, pürata cacaüyarixiyari püvaveviecai Riyanapaü tiyuxexeiyame. 'Iya müpaü tiyurienetü vaüca 'ivarica nivapitüacaitüni tevevivamete. ");
INSERT INTO hchNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Hicü varucuxeürieca müme, vahepaü te'uximayatamete vahamame, müpaü niutayüni, Neuxei, xeme xecatenimaica tame temüte'iva 'icü ta'uximayasicacü. ");
INSERT INTO hchNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Müpaü xepütexeiya, müpaü xepüte'enana, Papuru yuri que mütiva'eritüa que mütivarucunuitüa yumüireme teüteri, 'ena 'Epesusie xeicüa pücatixaü, masi naisarie 'Asiyasie 'esivatücacu. Müpaü tinicuxatani 'iya, müme mamacü memüveviya cacaüyarixi memücahüme haitü. ");
INSERT INTO hchNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Mücü meta, tita temütehexeiya tame pücueriva'ane capa xüanacüa 'ayanicü. Masita, 'icü cacaüyari mütürücaüye Riyana tuquieya, tixaü catihücütüme cauca me'erieca teüteri. Yunaitü 'Asiyatari, naisarie cuiepa memütamata, que mü'ane memayexeiya, 'icü türücariyaya püca'unarieximeni. ");
INSERT INTO hchNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Hicü me'u'enanaca mepuyeha'a. Meniutihivacaitüni müpaü me'utiyuatü, Canitürücaüyeni 'Epesutari tacacaüyari Riyana. ");
INSERT INTO hchNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Quiecarisie pühünecai yuariyacü. 'Axeicüa mepecü me'unausaxüaximetü xeüripa, mevarutiviyaca Cayu 'Arisitaricu Maseruniyatari, Papuru teütameteya memühümetücai. ");
INSERT INTO hchNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Papuru nihamücücaitüni haque quiecatari memeyuxeürie, peru teyü'üquitüvamete mepüca'ipitüa. ");
INSERT INTO hchNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Hipatü 'Asiya cuieyarisie quiecatari va'uquiyarima, hamicumama mehümetütü, metenetanü'ani hesüana me'itavavirietü xeüripa mücamiecü. ");
INSERT INTO hchNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Mericüsü hipatü yücü mete'uhivatü hipatüta yücü mete'uhivatü meniutihivacaitüni. Mana xeicüa meniyucuxeürie yunaitü, yumüiretü 'asimepücatemaicai titayari muva memüte'u'axüa. ");
INSERT INTO hchNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","'Amemu'uvacai vasata menenuyexeiya Herecanituru, Huriyusixi me'itaquecu vahüxie. Herecanituru yumamacü varu'inüaritüaca nitaniumücücaitüni yuhesie mieme memüyucuxeüri vahüxie. ");
INSERT INTO hchNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Meheitimaica Huriyu mühücütücaicü, carima meniutihivacaitüni 'axeicüa yunaitü huta hurayari meyurietü müpaü mete'uhivatü, Canitürücaüyeni 'Epesutari tacacaüyari Riyana. ");
INSERT INTO hchNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Mericüsü quiecarisie mieme sicürivanu vanütüatü müpaü tinivarutahüave 'amemu'uvacai, Neuxei 'Epesutari, haquevasü tevi 'asimücatimate quename 'Epesu quiecatari Riyana mütürücaüye vava'ütemama tehüme, Cupiterisüa macane tete cacaüyariyari vava'ütemama quename tehüme. ");
INSERT INTO hchNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Mericüte, xüca müpaü 'aneni, xüca cayuxamurieca 'icü niuqui, neuyeveca cayuvatü xemütamarecü xemücarucusixitünicü. ");
INSERT INTO hchNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Xeniva'atüani 'icü 'uquisi, sepa 'axa memücate'uyuri tuqui hepaüsita, sepa 'axa memücatecuxata xecacaüyari hepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","'Ayumieme Remetüriyu, tevevivamete hamatüana memu'uva xüca tixaü metehexeiya xeime hepaüsita, tucari puxuave quepaucua 'isücate 'amemütiteni, müme cuiepa memühüritüarie 'ameniu'uvani. Mana mequehei'atüani yuxanesica. ");
INSERT INTO hchNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Xücasü masi cuxi xetecuvauni, 'aixüa püyüni quepaucua quiecatari memüyuxeürie, 'inüari niuquiyari que maine. ");
INSERT INTO hchNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Hicümüsüari tepücueriva'aca capa tahesie rahüiyanicü cuya temüveviecü hicü, sepa mücareuyevecai. Tame tepücayüvave 'asitemütiyuani tahesie mieme 'icü xamuriyacü. ");
INSERT INTO hchNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Müpaü 'utayüca nivaranuyenü'ani memayuxeürie. ");
INSERT INTO hchNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Mericüsü yuariya heunuacu, Papuru yu'aurie nivarutahüave teyü'üquitüvamete. Vatuicaca varutateutüaca Maseruniyapai neyani. ");
INSERT INTO hchNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Muva 'uyemietü, nivatuicacaitüni vaücavame niuquicü. 'Arique Cüresiya cuieyarisie neta'ani. ");
INSERT INTO hchNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Haica meseri yuriecacu, Huriyusixi meniyu'enieni me'imienique quepaucua Siriyapai müyemiecai. 'Ayumieme müpaü tiniyumaicaitüni Maseruniya püta muyeyunecü. ");
INSERT INTO hchNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","'Asiyapai hamatüana meniu'uvacaitüni Supateri Vereyatanaca 'Arisitaricu Secunitu memütesarunicataritücai, Cayu Rerüvetanaca, Timuteu, Tiquicu Türupimumatü memü'asiyataritücai. ");
INSERT INTO hchNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Müme mehaitütüaca metanecueviecaitüni Türuhasisiepai. ");
INSERT INTO hchNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Tamesü Piripusie tecaneyecüne naviyasie, pa cacuxanariyame 'ixüarariyari 'anutiyacu. Vahesüa teneta'axüani Türuhasisie 'auxüme tucari 'anucayacu. Mana 'atahuta tucari tepuyuri. ");
INSERT INTO hchNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Mericüsü mexüacame tucari semanasie tenitacuxeürieni pa temütitaracü. Papuru tinivacuxaxatüvacaitüni. 'Uxa'arieca müyemiecaicü, 'ayumieme 'apüreuterixü ticuxatatü tücari hixüapaque. ");
INSERT INTO hchNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Vaücava puti'ucai cüxemete qui taüta haicacüa heutitevacacu temütayexeüriesie. ");
INSERT INTO hchNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Xevitü temaicü 'Euticu mütitevacai mana nacateitüni quitenie. Mücü neucuni yemecü. Papuru vaüca ticuxatacacu, nayexüne cusutü, neucaveni haicame quiyarisie, müquitü niuticueiyani. ");
INSERT INTO hchNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","'Anacayaca Papuru, heimana niuveni, niviya, müpaü niutayüni, Cayuvatü xepücayumuinani. 'Iyarieya 'upüyeca. ");
INSERT INTO hchNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Hicü neutiyani Papuru. Pa 'utitaraca, he'inüataca 'icuai, mana tinicuxatacaitüni vaücava. 'Atinecu tau caneyani. ");
INSERT INTO hchNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Meni'atüani temaicü 'ayeniereme, mepütuicariecai vaücava. ");
INSERT INTO hchNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Hicü tame naviyasie tepecü te'uhaitütüatü. 'Asunisie teneta'axüani. Mana tepenucunaquequecai. Papurumatü müpaü tetenipini. 'Iya yü'ücama neta'aniquecaitüni. ");
INSERT INTO hchNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","'Asunisie tasi'anucunaquecu, te'itanaqui'erieca naviyasie, Mitirenepai tenecüne. ");
INSERT INTO hchNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Manata 'uxa'arieca tenecüne naviyasie teheta'axüanique Quiuxi hüxie, 'uxa'arieca Samusie tepeta'axüa, 'arique Turuquiriyu teheta'axüaca 'uxa'arieca Miretupai teneta'axüani. ");
INSERT INTO hchNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Müpaü pütiyumaicai Papuru, temuyecünequecai 'Epesu 'aurie, tucari mücayurienicü 'Asiya cuieyarisie. Niyumexüitüacaitüni xüca yüvenique Querusareme meyeicanicü 'ixüarari 'atahutarieca semanasie mieme 'aye'ayu. ");
INSERT INTO hchNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Hicü Miretusie 'ucaitü, retanü'aca 'Epesusie, nivarecu'inieni memüyutixexeürivacai va'uquiyarima. ");
INSERT INTO hchNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Hesüana me'u'axüacu müpaü tinivarutahüave, Xeme xecatenimaica matüaripai nemunua 'Asiyasie, tucaricü que nemütiuyeicacai xehesüa. ");
INSERT INTO hchNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Ti'aitamesie mieme netini'uximayacaitüni tixaü netihücütüme necane'erietü, ne'utasuatü, ne'inüasienetü, Huriyusixi que memüteyu'eniecai nehepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Nepücanecu'imavacai, nepünevaüriyacai nemütixetahecüatüanicü tita müreuyevecai, teüteri vahüxie xequitata netinixe'üquitüacaitüni püta. ");
INSERT INTO hchNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Huriyusixi Cüriyecusixi müpaü nepütixetahecüatüacai xetehayevame que xemüteyurie Cacaüyarisie xemüteviyanicü, yuri xemüteta'erienicü Tati'aitüvame Quesusisie. ");
INSERT INTO hchNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Hicüsüari ne Querusaremesie nepüyemie ne'iyarisie vaüriyarica nepitüarietü. 'Asinecacatinimaica que neme'itüarieni mana. ");
INSERT INTO hchNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","'Ipaü xeicüa nepütimate, 'Iyari Mütiyupata pünetitahecüatüa xexuime quiecarisie, müpaü 'utaitü quename caunaritecü 'uximatüaricacü necueviya mana. ");
INSERT INTO hchNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Sepanetü, netucari raye'arücame nepüca'eri nehesie mieme. Nepinüniqueyu xeicüa neyeiya nenetemavietü, nepinüniqueyu nehüritüaricacü Ti'aitame Quesusi que münetiuhüritüa, nemütihecüatanicü niuqui 'aixüa manuyüne hepaüsita, Cacaüyari 'aixüa que mütiuca'iyari manuyüne hepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Hicümüsüari ne nepütimate hasuacuari nenierica xepücaxeiya yunaitü xeme xehesüa nemuyeicacai netihecüatatü que müti'ane Cacaüyari ti'aitametücacu. ");
INSERT INTO hchNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","'Ayumieme 'icü tucarisie necatinixe'utahecüatüani quename ne'itiya, quename ni xeime xuriyayacü necarahüviyarüva. ");
INSERT INTO hchNT_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Tixaü nepücanecu'imavacai, nepünevaüriyacai nemütixetaxatüanicü naime Cacaüyari mütisutüa. ");
INSERT INTO hchNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Xequeneyucuerivayurieca xeme, xequenivacuerivayurieca mümeta muxasi vacümana 'Iyari Mütiyupata xehüritüariecame müxe'ayeitüa, xemüva'üviyanicü müme yunaime Ti'aitamesüa miemete memüyutixexeüriva, 'iya müvarunanai yuxuriyacü. ");
INSERT INTO hchNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Nesü necatinimaica neyemieyu 'arique 'üravesixi xesata meneutahaxüacuni teyu'uximatüvamete. Mepücavahayeva muxasi. ");
INSERT INTO hchNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","'Uquisi xesata menanucu'uicuni tutunimecü me'utiniutü, yu'utüma memüvarahapanacü teyü'üquitüvamete. ");
INSERT INTO hchNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","'Ayumieme xequenayeneniereni, xequena'erivani haica viyari tucaricü tücaricü que nemücatinehayevacai nexecu'imaiyatü yuxexuime, ne'utasuatü. ");
INSERT INTO hchNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Hicürixüa xehepaüsita nenihüritüani Cacaüyariri, niuquiyarita. Mücü niuqui quename 'aixüa tiuca'iyari manuyüne, mücü caniyüveni müxeseiriyani, müxepitüani xehesie mütinaquenicü yunaime Cacaüyari müvarupataxü yuhesie mieme, müme vahesie que mütinaqueni. ");
INSERT INTO hchNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Ne xeime tuminieya püratu huru 'ixuriquieyata nepüca'ihive'eririecai. ");
INSERT INTO hchNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Masi xeme xecatenimaica 'icü nemamacü nepütinepitüacai tita nemüreuyehüacai ne, nehamatü memu'uvacai tita memüteheuyehüacai nepütivapitüacaita. ");
INSERT INTO hchNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Neheyemecü netinixehecüatüacaitüni müpaü xete'uximayatatü xemüvaparevienicü müme memücatürücavi, xeme xema'erivanicü Ti'aitame Quesusi niuquieya que mutayü, Que mü'ane mütiyumicua yemecü caniyutemavieca, que mü'ane mütimiquie 'esiva xeicüa caniyutemavieca. ");
INSERT INTO hchNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Hicü müpaü 'utayüca, 'utitunumaqueca, yunaime vahamatü niyutanenevieni. ");
INSERT INTO hchNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Yunaitü vaüca meniutisuanacaitüni. Cüipieyasie me'acavütü meni'iseni ");
INSERT INTO hchNT_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","meyuhiverietücaitü yeme niuquieyacü que mainecaicü, quename niericaya mecaxeiyaniquecai tavari. Meneiteüta naviyasiepai. ");
INSERT INTO hchNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Hicü tevarutateutüaca tenecüne. Heiseriemecü te'u'uvatü naviyasie Cuhusipai teneta'axüani, 'uxa'arieca Ruraxisiepai, 'arique Patarasiepai teneta'axüani. ");
INSERT INTO hchNT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Mana tepeitaxeiya naviya Penisiyasie muyeyunequecai. Te'acayaxeca tenecüne. ");
INSERT INTO hchNT_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Te'ixeiyaca Sipüre, ta'utata teheicu'eirieca, Siriyasie teneta'axüani. Mana Tirusie teniuyeyunixüani naviya mana müti'icapiyaniquecaicü. ");
INSERT INTO hchNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Tevaretaxeiyaca teyü'üquitüvamete, 'atahuta tucari teniuyurieni mana. 'Iyari müpaü tiva'üquitüacacu müpaü metenitahüave Papuru müca'uyeyanicü Querusaremepaitü. ");
INSERT INTO hchNT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Yapaümexa tucari 'anucayacu, te'ayenexüaca tenecüne. Yunaitü 'ucarita türita mepütasi'uvitüximecai quiecari tesiepai. Mana ha tesita te'utitunuma'uca, tetatanenevieca, ");
INSERT INTO hchNT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","tenitatateutüaxüani. Tame mücü naviyasie tepacayaxixü, mümesü yuquiecarisie meniucunuaxüani. ");
INSERT INTO hchNT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Tirusie teheyecüneca mücü naviyasie, tavari tenecüne. Turemaira tecaneta'axüani. Mana tevarutavaüritüaca 'ivamarixi, xei tucari tepuyuri vahesüa. ");
INSERT INTO hchNT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Teheyecüneca Papurumatü temu'uvacai, 'uxa'arieca Sesareya teneta'axüani. Piripe niuqui 'aixüa manuyünecü mütixaxatametücai, mücü quita teheutahaxüaca hesüana tenitahayeva. 'Iya xevitü canihücütücaitüni 'atahutame vasata. ");
INSERT INTO hchNT_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Yunaucame yunivema püvarexeiyacai 'üimarixi texaxatamete. ");
INSERT INTO hchNT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Hicü yapaümexa tucari te'uyuriecu, xevitü muva nacaneni Cureyasie heyeyaca, tixaxatametütü Hacapu mütitevacai. ");
INSERT INTO hchNT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Tahesüa nuaca, Papuru hüyameya 'uviyaca, yü'ücate yumamate niutihüani müpaü 'utaitü, 'Iyari Mütiyupata müpaü paine, 'icü hüyame cusiyarieya, 'ipaü meteneihüacuni Huriyusixi Querusaremesie. Menivayetuiriecuni müme memücahuriyusixi. ");
INSERT INTO hchNT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Te'i'enieca 'icü, tame quiecatari vahamatü tenitavavirieni Querusaremepai müca'uyeyanicü. ");
INSERT INTO hchNT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Papuru müpaü tatiniuta'eiya, Titari xeteyurie xe'utisuatü ne'iyari xeveranariyatü. Ne nepüha'arisi Querusaremesie nemühüiyanicü, masi nemümünicü Ti'aitame Quesusisüa nemümiemecü. ");
INSERT INTO hchNT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Ca'ucunuitüariecu cayuvatü tepumacai, müpaü te'utiyuatü, Mericüte, yaquetiuyüni que mütinaque Ti'aitame. ");
INSERT INTO hchNT_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Mericüsü yapaümexa tucari 'utixücu tetacuha'aritüaca Querusaremesie teneutiyune. ");
INSERT INTO hchNT_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Teyü'üquitüvamete Sesareyasie miemete hipatü tahamatü mepu'uvacai xeime mehavitütü Münasunitüme. Mücü Sipüretanaca tiyü'üquitüvame canihücütücaitüni matüaripai mieme. Mana hesüana tepütahayevaquecai. ");
INSERT INTO hchNT_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Mericüsü Querusaremesie teheta'axüacu, 'ivamarixi metaniutanaqui'erieni meyutemamavietü. ");
INSERT INTO hchNT_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","'Uxa'arieca Papuru Cacuvusüa neutahani tahamatü. Hesüana meniu'uvacaitüni va'uquiyarima yunaitü. ");
INSERT INTO hchNT_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Varutavaüritüaca tinivahecüatüacaitüni naime que mütihüritüariecai hepaüsita xexuime que mütiuyuri Cacaüyari nuivarite vasata. ");
INSERT INTO hchNT_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Müme me'u'enanaca 'aixüa meniutiyuanecaitüni Cacaüyari hepaüsita. Müpaü metenitahüave, Neuxei ta'iva, pecanivaxeiyaveni quepaümeme miriyari Huriyusixi yuri memüte'erie. Yunaitü yemecü mepüteviya yu'inüari niuquiyarisie. ");
INSERT INTO hchNT_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Müpaü mepütecühüavarüva 'ahepaüsita, quename yapeti'üquitane yunaitü Huriyusixi nuivarite vasata memütama yamemücatecahunicü Muisexi niuquieyasie pe'utaitü vaniu, yape'utaitüta vaniu memücava'inüaritüanicü yütüriyama xitequiyacü, yututuyarisie yamemücatecahunicü vaniu. ");
INSERT INTO hchNT_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Queteri 'aneni. Yumüiretü xüari mepüyuxeürieni. Mepü'enanani pemunua. ");
INSERT INTO hchNT_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Mericüte, 'ipaü quetineuyuri que temümatecühüave. 'Uva tasata mepu'uva 'uquisi yunaucatü, paye'axime memüyuxünacü que memüteyühüritüacai. ");
INSERT INTO hchNT_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Quenivaranuvitüqui, queneu'a'itieca vahamatü, quetineu'atua vacüpa mücaxirienicü 'inüari mayanicü vatucari maye'acü. Müpaü petiyurieyu yunaitü mecatenimaica tixaü mücatihücü que memütecühüavarüva 'ahepaüsita, masi 'inüari niuquiyarisie yapeticamietü 'apemuyeica. ");
INSERT INTO hchNT_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Mümesü memücahuriyusixi yuri memüte'uta'erie, niuqui tepüvarenü'airi teva'aitüatü müpaü 'anenemesie yamemücatecahunicü, masi memüca'icuacacü tita tetexi memütexatüarie, xuriya, caviyacame, que mü'ane mücayü'üya mücayücüna memücavacumaüvanicü. ");
INSERT INTO hchNT_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Hicü 'uxa'arieca Papuru nivarevitüni müme 'uquisi. Vahamatü neutahani tuquita yu'itieca, müpaü tihecüatatü quename tucari 'aye'a memuyu'iti, yuxexuime vamavari mexi ca'atüarievecai. ");
INSERT INTO hchNT_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Mericüsü 'atahuta tucari 'aye'aximecacu, Huriyusixi 'Asiyasie miemete me'ixeiyaca Papuru tuquita, menivarutamuina yunaime muva memu'uvacai. Meniviya ");
INSERT INTO hchNT_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","müpaü me'utihivatü, Xequetaneuparevi 'Ixaherisixi. 'Icü tevi canihücütüni que mü'ane tateüterima vahepaüsita 'inüari niuquiyari hepaüsitata 'icü 'ena hepaüsitata 'axa mütiva'üquitüa yunaime naisarie. Hicüri Cüriyecusixi 'uva nivaratavitüni tuquita, 'icü 'ena Cacaüyarisie mieme müracupasie caniuseviximani. ");
INSERT INTO hchNT_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Meripai mepixeiyacai Türupimu 'Epesutanaca hamatüana 'uyeicame quiecarisie. Papuru tuquita hetavitüme mepü'eriecai. ");
INSERT INTO hchNT_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Yunaitü quiecatari meputayua. Teüteri me'unausaxüaximetü meniu'axüani. Me'iviyaca Papuru, menenuyehana tuqui tacua. Yapaucua 'itupariyari neunarixüani. ");
INSERT INTO hchNT_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Hicü me'imiecucacu, niuqui nenuani xei miriyari cuyaxi tiva'aitüvamesüa quename yunaitü Querusareme quiecatari metemuinatüvecai. ");
INSERT INTO hchNT_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Cuitü cuyaxi varevitüca, xei sienituyari cuyaxi teva'aitüvamete varevitücata, mücü mana niutanausa vahesüa. Teüteri mevaruxeiyaca cuyaxi tiva'aitüvame, cuyaxirita, meteniuhayeva me'icuvayatü Papuru. ");
INSERT INTO hchNT_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","'Aura 'ayaca cuyaxi va'uquiyari, niviya. Tiniuta'aita memihüanicü huta tepüayaricü. Nivaruta'ivaviya que müpaicütücai que mütiuyuri. ");
INSERT INTO hchNT_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Hipatü yücü meteniuhivacaitüni, hipatüta yücü mete'uhivacai. 'Asimücaretimaivecaicü heiseriemecü müme memutihivacaicü, 'ayumieme nivaruta'aitüani memenuvitünicü cuyaxi vaqui. ");
INSERT INTO hchNT_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","'Imumuitüa me'u'axüaca, püreuyevecai cuyaxi me'enuyevietü memenuhanacü vaüriyarica, teüteri memüsaipünecaicü. ");
INSERT INTO hchNT_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Yumüiretü meniveiyacaitüni, Queneumi'a mete'uhivatü. ");
INSERT INTO hchNT_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Hicü meheutahaxüaximecacu cuyaxi vaquita, Papuru müpaü tinitahüave cuyaxi tiva'aitüvame, Catiyüve nemasitahüave. 'Iya müpaü niutayüni, Que petiniuve 'ecü Cüriyecusixi vaniuquicü 'acu. ");
INSERT INTO hchNT_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","'Iya 'Equipitutanaca pecatihücü meripai cuya matüa, 'uma macumavesiepaitü müvarevitü navaxa'üvemete nauca miriyari meyupaümeme. ");
INSERT INTO hchNT_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Papuru müpaü tinitahüave, Nesü necanihuriyutüni, necanitarusutanacatüni Sirisiya cuieyarisie nemiemetütü, quiecari 'amüyevasie necaniquiecametüni. Hicü nepümasivaviri, queneneupitüa nemütivataxatüanicü teüteri. ");
INSERT INTO hchNT_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","'Ipitüacu, Papuru 'imumuisie 'utivetü yumamacü nivaru'inüaritüani teüteri. Cayuvatü me'utamarecu yeme, Hepürayusixi vaniuquicü niutaniuni, müpaü 'utaitü, ");
INSERT INTO hchNT_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Neuxei 'ivamarixi 'uquiyarimata. Xequenene'enieca nehesie mieme que nemütitaniuni hicü xehüxie. ");
INSERT INTO hchNT_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Hicü me'i'enieca Hepürayusixi vaniuquicü ticuxatame, masi cayuvatü mepumacai. Müpaü niutayüni, ");
INSERT INTO hchNT_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","Ne necanihuriyutüni. Tarususie Sirisiya cuieyarisie nenetinuiva. Neniutavere 'icü quiecarisie Camarierisüa netine'üquitüatü heiseriemecü tatevarima va'inüari niuquiyari hepaüsita. Ne neheyemecü nepü'ayumiemetücai Cacaüyari hepaüsita, xehepaü 'icü tucarisie xemü'ayumiemetepaü. ");
INSERT INTO hchNT_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","'Icü huyeta miemete nepüvareutaveiyaxüa nevacuinique. Nepüvarutihüa, netivaranutaxüri 'uquisi 'ucari. ");
INSERT INTO hchNT_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Mara'acame mühüritüarie, ta'uquiyarimata yamepünetehecüata. Mümeri menesi'uhuritüacu xapa ta'ivama vahesie mieme, neneyani Ramasicusie nevaravitünique Querusaremesie mehüatücaime müme mana memecü, memanutaxüriyanicü. ");
INSERT INTO hchNT_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Mericüsü ne'uyemiecacu, Ramasicu 'aurie ne'aye'aximecacu, yapaucua tuca taheima mieme hecüariya niucumerüca ne'aurie. ");
INSERT INTO hchNT_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Cuiepa nenativeni. Xeime nepu'eni müpaü müneretahüavixü, Sauru 'acu, Sauru, titayari penetiuveiya. ");
INSERT INTO hchNT_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Nesü müpaü netinita'eiya, 'Uqui que pepüpaicü 'ecü. 'Iya müpaü netiniutahüave, Ne necaniquesusitüni Nasaretitanaca pemünesi'uveiya. ");
INSERT INTO hchNT_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Nehamatü memu'uvacai hecüariya menixeiyacaitüni meniutimama. Mepüca'i'eniecai que mü'ane müneticühüavecai. ");
INSERT INTO hchNT_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Ne müpaü neniutayüni, Que netiyurieni ne Ti'aitame. Ti'aitame müpaü pünetiutahüavixü, Quenanucuquexi, Ramasicusie quenemie. Manari yapepütitahüavarieni naime que müti'aisie yapemütiyurienenicü. ");
INSERT INTO hchNT_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Nepütauruxiecai xavatüricü. Müme nehamatü memu'uvacai menesi'ahanacacu, neninuani Ramasicusie. ");
INSERT INTO hchNT_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Mericüsü xevitü Hananiya mütitevacai mana peyeicacai 'uquitütü 'aixüa yamüticamiecai 'inüari niuquiyarisie. Yunaitü Huriyusixi muva memütamacai menihecüatacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Hicü nehesüa nuaca, mana 'utivetü, müpaü pünetiutahüavixü, Ne'iva Sauru, quenanutanieri. 'Anatütü ne'anutaniereca nenixeiya. ");
INSERT INTO hchNT_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Mücü müpaü niutayüni, Tatevarima vacacaüyari matüaripai camananuyexeiya yapemütimanicü tita mütinaque, 'iya Heiserie Mexeiya pemüxeiyanicü, niuquieya pemü'enienicü 'utaniucame. ");
INSERT INTO hchNT_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Que pemütiunierixü que pemütiu'enaxü yapecatinivahecüatüamücü yunaime teüteri. ");
INSERT INTO hchNT_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Hicümüsüari, titayari petita'icuevani. Quenanucuquexi, queneuca'üyari, tita 'axa pemütiuyuri quene'ahauxina pehehüavetü que mü'ane mühücü. ");
INSERT INTO hchNT_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Mericüsü Querusareme nenuaca, tuqui curaruyarita nenenenevietü, heinüsipaü 'aneme neniuxeiya. ");
INSERT INTO hchNT_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Nenixeiya Ti'aitame müpaü neticühüaveme, Quene'amexüitüaca, Querusareme quenayeye'a, memüca'itanaqui'ericü 'aniuqui que pemütihecüata nehepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Nesü müpaü necaniutayüni, Ti'aitame, müme mecatenimaica ne que nemüticuyeicacai tuquiteta nevaranutaxürüvatü nevahüatü müme yuri memüte'eriecai 'ahesie. ");
INSERT INTO hchNT_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Mücü meta, quepaucua 'Esitevani xuriyaya mutaxüri 'ahepaüsita mütihecüatacai, ne 'aneputivecai ne'iyari ya'anecacu, ne'ihütü müme memimieniquecai va'ixuriquite. ");
INSERT INTO hchNT_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Mücü müpaü pünetiutahüavixü, Quenemiesü, tevapai necamananunü'amücü memücahuriyusixi vahesüa. ");
INSERT INTO hchNT_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Mericüsü teüteri meni'eniecaitüni 'iya niuquique, perusü 'ana carima meputihivaxü müpaü me'utiyuatü, Queneumi'a, cuiepa püca'uyeicani que mü'ane müpaü mütiyuriene. 'Aixüa cacani'aneni 'ayenieretü müyuhayeva. ");
INSERT INTO hchNT_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Me'utihivacacu yu'ixuriqui 'itüata mehevivivacacu tumuanari me'uti'enisitüvacacu, ");
INSERT INTO hchNT_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","cuyaxi tiva'aitüvame tiniuta'aita manuvitüquienicü cuyaxi vaquita, müpaü 'utaitü, Tepita'inüata 'aruvasini 'icuvaxüayu, yanemüretimanicü titayari müya mete'uhivacai hepaüsitana. ");
INSERT INTO hchNT_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Mexi me'enutihanacai navicü quita, Papuru müpaü tinitahüave xei sienituyari cuyaxi tiva'aitüvame mana 'utivecacu, Que xetetauniva xemicuvaxüani tevi Xumasie müquiecame ca'itahüavivecacu 'isücame. ");
INSERT INTO hchNT_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Xei sienituyari tiva'aitüvame 'u'enaca, xei miriyari tiva'aitüvamesüa neyani. Tiniutahecüata müpaü 'utaitü, Que petiyuriemücü. 'Icü tevi Xuma caniquiecametüni. ");
INSERT INTO hchNT_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Nuaca xei miriyari cuyaxi tiva'aitüvame, müpaü tinitahüave, Yaquenetineutahüavi, 'ecü Xuma petiquiecame. 'Iya, Hü, niutayüni. ");
INSERT INTO hchNT_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Cuyaxi tiva'aitüvame müpaü tinita'eiya, Cari ne vaüca netinetuaca quiecame nepatüa. Papuru müpaü tinitahüave, Nesü müpaü ne'anetü nenetinuiva. ");
INSERT INTO hchNT_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","'Ayumieme yapaucua hesüana menecüne müme memita'inüataquecai. Xei miriyari cuyaxi tiva'aitüvame nimacaitüni yamüretimacü quename Xuma quiecame hücütücai, quename 'ihüacai. ");
INSERT INTO hchNT_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Hicü 'uxa'arieca heiseriemecü tinimaimücücaitüni titayari Huriyusixi meteniuquixiecai hepaüsitana. Pixünaxü, tinivaruta'aitüani memüyucuxeürienicü mara'acate memühüritüariecai 'isücate yunaitü. Heivitüca Papuru, vahüxi nitaqueni. ");
INSERT INTO hchNT_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Hicü Papuru varuxeiyaca 'isücate, müpaü niutayüni, Ne'ivamarixi, ne'iyari 'aixüa 'anecacu canesitate'acacu 'aneniuyeicani Cacaüyari hüxie meripai hicü cuxi. ");
INSERT INTO hchNT_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Hicü Hananiya mara'acametütü mühüritüariecai tinivaruta'aitüani müme 'auriena memüti'ucai teniena memitavanicü. ");
INSERT INTO hchNT_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Hicü Papuru müpaü tinitahüave, Cacaüyari pümasivani 'ecüta, que pemütimasiücü yapepüca'ane 'ixumari münaximapaü. 'Ecü 'apecanacani penesi'inüatanetü 'inüari niuquiyari que maine, masi 'inüari mücahainepaü püta pepüti'aita nemüveiyanicü. ");
INSERT INTO hchNT_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Mana memu'uvacai müpaü meniutiyuani, Tietüsü pe'itatieni Cacaüyari mara'acameya mühüritüarie. ");
INSERT INTO hchNT_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Papuru müpaü niutayüni, Ne'ivama, 'asinepücatimaicai mara'acame mühüritüarie mühücücü. Müpaü pütiu'utüarie, 'Axa pepüca'utaineni 'ateüterima tiva'aitüvame hepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Mericüsü retimaica Papuru hixüata me'atü memüsaruseusixitücai hixüata me'atü memüpareseusixitücai, 'isücate vahüxie müpaü tiniuhiva, Ne'ivamarixi ne necanipareseutüni, Pareseu nepünu'aya. Yanetita'icuevatü yuri nemüti'eriecü quename müquite me'anucu'uni, 'ayumieme nepü'inüasie. ");
INSERT INTO hchNT_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Mexi cuxi 'utaniuca, Pareseusixi Saruseusixi meniyuticuitücüne. 'Amemu'uvacai hixüata meniyusana. ");
INSERT INTO hchNT_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Saruseusixi müpaü meputiyuane quename müquite meca'anucu'uni, quename niuqui tuayamete tixaü mecatehüme, quename 'iyari tixaü catihücü. Pareseusixi yamecani'aneneni naimecü. ");
INSERT INTO hchNT_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Hicü carima meniutihiva. Me'anucu'uca hipatü 'inüari niuquiyaricü memüte'üquitametetücai Pareseusixi vahesie memüteviyacai, meniyuticuitücüne müpaü me'utiyuatü, Tame tixaütü tepücate'ucaxei 'axa ti'aneme 'icü tevi hepaüsita. Tietüsü 'iyari 'itahüave niuqui tuayame nusu. ");
INSERT INTO hchNT_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","'Utimüirecu 'imieri, xei miriyari cuyaxi tiva'aitüvame nimacaitüni capa hixüata me'isanacü Papuru. Tinivaruta'aitüani yucuyaxima memeutacünecü, memiviyacü vasata, memenuvitünicü cuyaxi vaquita. ");
INSERT INTO hchNT_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","'Uxa'arieca yüvicüta Ti'aitame 'auriena 'utivetü müpaü niutayüni, Pepücamaca Papuru. Que pemünetihecüatacai Querusaremesie, müpaü tineuyeveca pemünetihecüatanicü Xumasieta. ");
INSERT INTO hchNT_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Mericüsü 'atinecu tau, Huriyusixi hipatü meniyu'enieni. Meniyühüritüani müpaü me'utiyuatü, Tepüca'anuhareni tepücatecuaca te'imiemeque Papuru. ");
INSERT INTO hchNT_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Huta teviyari meyupaümetü yacütüniquetü müpaü meteniyühüritüacaitüni. ");
INSERT INTO hchNT_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Mara'acate memühüritüariecai vahesüa yu'uquiyarima vahesüa me'u'axüaca müpaü meniutiyuani, Tame müpaü tepüte'utahüritüa, tixaütü tepücateha'inüatani Papuru temiemeque. ");
INSERT INTO hchNT_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Hicü 'ayumieme xeme 'isücate vahamatü yaxequeteneutahüavi xei miriyari cuyaxi tiva'aitüvame xehesüa mevitünicü, 'aixüa 'anemecü masi xemütetimanicü hepaüsitana yacütüniquetü. Tame canuavecacu cuxi 'uma tenetaha'aritüaca temimienicü. ");
INSERT INTO hchNT_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Mericüsü Papuru masuya niu'ena que memüte'imieniquecai. Mana nuaca, cuyaxi vaquita heutahaca, tinitaxatüani Papuru. ");
INSERT INTO hchNT_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Papuru yu'aurie 'itahüaveca xei sienituyari cuyaxi teva'aitüvamete xeime, müpaü niutayüni, 'Icü temaicü quenanuvitüqui xei miriyari cuyaxi tixe'aitüvamesüa. Tixaü pürexeiya yamütitahüavecü. ");
INSERT INTO hchNT_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","'Iya caneivitüni xei miriyari tiva'aitüvame hüxie. Müpaü niutayüni, Papuru manutahüiya yu'aurie nesi'utahüaveca pünesi'utavaviri 'ahüxie nemenuvitünicü 'icü temaicü. Tixaütü niu pürexeiya yamümatitahüavecü. ");
INSERT INTO hchNT_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Xei miriyari cuyaxi tiva'aitüvame tiviereca mamayasie vatipai yühücüate mematitei neihana müpaü ticu'ivaviyatü, Que titita pemeixeiya yapemüneticühüave. ");
INSERT INTO hchNT_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Mücü müpaü niutayüni, Huriyusixi mepuyu'enie. Mepümasitavavirieni 'uxa'a pemenuvitünicü Papuru 'isücate vahesüa, heiseriemecü memütemaicacü hepaüsitana yacütütü. ");
INSERT INTO hchNT_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","'Ecü pepücava'enieni. Huta teviyari yacütütü 'uquisi vahesüa miemete mepicuevie. Müpaü mepüte'uyühüritüa memücatecuacacü memüca'anuharenicü me'imiemeque. Hicü meniyuha'aritüaca memasicuevietü pemü'avaüriyanicü. ");
INSERT INTO hchNT_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Hicü xei miriyari tiva'aitüvame neinü'ani temaicü müpaü ti'aitüaca, Tixaü xeime pepücaraxaxatüvani 'icü hepaüsita que pemünetiutahecüatüa. ");
INSERT INTO hchNT_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Mericüsü yu'aurie varutahüaveca xei sienituyari cuyaxi teva'aitüvamete yuhutame, müpaü niutayüni, Xequenivarucuha'aritüaca huta sienituyari cuyaxi, cavayasie memayaxivave haica teviyari heimana tamamata, 'ixipara vivamete huta sienituyari vahamame, Sesareyasie memüyehucü haica hurayari 'aye'ayu yüvicüta. ");
INSERT INTO hchNT_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Cavayasixi xequenivarexeiya, Papuru me'anuhanatü memivicueisitüanicü Perixi mü'isücamesüa. ");
INSERT INTO hchNT_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Xapa nita'utüirieni 'ipaü 'utaineme, ");
INSERT INTO hchNT_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Ne Cürauriyu Risiyaxi nepümasivaüritüa 'isücame pemütürücaüye Perixi. ");
INSERT INTO hchNT_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Huriyusixi meniviya 'icü tevi, 'esivatücacu menimieni. Yanetiumaica, cuyaxi vahamatü nepiviya, nemüretimacü Xuma müquiecamecü. ");
INSERT INTO hchNT_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Netimaimütü titayari meteniuquixiecai hepaüsitana, neneivitüni va'isücate vahesüa. ");
INSERT INTO hchNT_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Nepüvaretaxei meniuquixiecame que maine va'inüari niuquiyari hepaüsita. Tixaü 'asipücati'anecai hesiena mürahüiyani mümierienicü manutahüiyanicü. ");
INSERT INTO hchNT_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Müpaü netiutahüavarieca memimieniquecaicü 'icü tevi, cuitüva necaneinü'ani 'ahesüa. Nepütivaruta'aitüa müme hepaüsitana memüniuquixie 'ahüxie memitahüavecü. Müpaü xeicüa. ");
INSERT INTO hchNT_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Mericüsü cuyaxi que mütivaruta'aitüa, yüvicüta meneivitüni Papuru 'Anutipatürisisiepai. ");
INSERT INTO hchNT_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","'Uxa'arieca mevarucu'eirieca müme cavayasie mematecai memüyehucü hamatüana, cuyaxi yuquiepai meniucunuaxüani. ");
INSERT INTO hchNT_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Müme Sesareyasie meheutahaxüaca, xapa meniyetuirieni 'isücame. Papuruta mete'iyetuiri. ");
INSERT INTO hchNT_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","'Itaterüvaca xapa, nita'ivaviya Papuru que mü'ane cuieyarisie mümiemetücai. Sirisiyasie mümiemetücai timaitü ");
INSERT INTO hchNT_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","müpaü niutayüni, Mericüte, nepümasi'enieni me'axüayu müme 'ahepaüsita memüniuquixie. Tiniuta'aita Herurexi parasiyuyasie me'üviyariecacü. ");
INSERT INTO hchNT_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Mericüsü 'auxüvirieca tucari 'anucayacu, mara'acame mühüritüariecai mana neta'ani Hananiya mütitevacai, hipatüta va'uquiyarima, xevitüta Teruturu müniucametücai mete'u'axüa. 'Isücame hüxie meteniutahecüata Papuru hepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","'Isücame 'itahüavecu, Teruturu nisutüani 'ixanetatü, müpaü 'utaitü, Yemecü cayuvatü pecatanipitüaca 'ecü. Timaiveme pemühücücü pecaniheiserietüaca vaücava tateüterima tahesie mieme. ");
INSERT INTO hchNT_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Neuxei Perixi pemütürücaüye, naisarie tenitanaqui'erieni naime pamüpariyusi temasipitüatü. ");
INSERT INTO hchNT_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Mericüte necamasi'uximatüamütü vaüca niuquicü, 'ayumieme nepümasitavaviri pemütasi'enienicü yareutevitü 'aixüa pemütiuca'iyaricü. ");
INSERT INTO hchNT_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Tenitaxeiya 'icü tevi 'axa tiyurieneme cuya vevieneme yunaime Huriyusixi vasata naisarie cuiepa. Nasaretitanacasie memüteviya catiniva'aitüvametüni. ");
INSERT INTO hchNT_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Tuquita neutahani 'iseviximanique. Tepivi, teni'inüatacucaitüni que maine ta'inüari niuquiyari. ");
INSERT INTO hchNT_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Perusü nuaca Risiyaxi xei miriyari cuyaxi tiva'aitüvame mühücü, vaüriyarica cataniunavairieni. ");
INSERT INTO hchNT_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Catatineta'aitüani tame hepaüsitana temüniuquixie 'ahesüa temüyehucü. 'Ecüta pe'ita'ivaviyame pecaniyüveni pemüretimani naime que temüteniuquixi hepaüsitana. ");
INSERT INTO hchNT_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Huriyusixita hepaüna mecaniniuquimacaitüni, quename müpaütütü 'ane me'utiyuatü. ");
INSERT INTO hchNT_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Hicü 'isücame yumu'ucü 'i'inüaritüacu mütaniunicü, müpaü niutayüni Papuru, Yanetimaitü 'ecü müixa viyari que pemütiuyuri 'ena 'icü teüteri va'isücame pehücütütü, 'ayumieme 'aixüa 'iyaricü nehesie mieme nepütaniuni que müticuxasiva nehepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","'Ecü pecaniyüveni pemütimaica, tamamata heimana huta tucari püca'anucayeive cuxi quepaucua nemeutiyunixü Querusaremesie nemünetanenevienicü. ");
INSERT INTO hchNT_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Sepa tuqui 'amüpata, tuquite 'esimüpepeta, quiecarisieta, tixaü mepücanesihetaxei niuqui nexüatüacame xeimematü, teüteri nevacuyataneme. ");
INSERT INTO hchNT_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Mepücayüvave memiseiriyani yuniuqui que memüteniuquixie nehepaüsita hicü. ");
INSERT INTO hchNT_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","'Ipaü nepümatitahecüatüaniqueyu, ne 'iya huyeta netiviyatü nepüti'uximaya tatevarima vacacaüyarisie mieme, sepa müme xaüsie tiviyacame memüxata 'iya huye. Yuri nepüti'eri naitü que mütiuti'utüarie 'inüari xapayarisie texaxatamete vaxapayarisie. ");
INSERT INTO hchNT_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","'Imetütü vahepaü yuri que memüte'erie meta'icuevatü, neta yuri netini'erieca müpaü netita'icuevatü Cacaüyari müvaranucu'uitüani müquite, heiseriemecü yamemüteyurie, heiseriemecü yamemücateyurie yunaime. ");
INSERT INTO hchNT_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Mücücü yanetinicuvauneni ne'iyari mücanesitatienicü naime hepaüsita, sepa Cacaüyari hepaüsita, sepa teüteri vahepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Ne tumini nenicuxeürieni neteüterima vahesie mieme. Yapaümexa viyari müpaü netiniyurienecaitüni. 'Arique 'uva neninuani ne'e'ütü. ");
INSERT INTO hchNT_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Müpaü netiyurienecacu hipatü Huriyusixi 'Asiyatari menenetaxeiya tuquita nene'itiecame. Yumüiretü teüteri 'amepüca'u'uvacai ne'aurie, nepücavaxamuriecai. ");
INSERT INTO hchNT_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Neuyeveca memü'axüani 'ahüxie müme, reuyevese müme memüniuquixieni que memüneteniuquimanique. ");
INSERT INTO hchNT_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Mesü, 'ime 'ena yameque'utiyuaneni tita memüte'ucaxei mücatiheiserie quepaucua ne nemutivecai 'isücate vahüxie, ");
INSERT INTO hchNT_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","tita memüte'ucaxei xeime neniuqui hepaüsita que nemütiuhiva vahüxie ne'utivetü müpaü ne'utaitü, Müquite me'anucu'ume nemüti'eriecü, 'ayumieme xehesüa neni'inüasieca hicü. ");
INSERT INTO hchNT_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Mericüsü Perixi heiseriemecü tinimaicaitüni 'iya huye hepaüsita. 'Ayumieme müpaü tinivaruta'eiya, Nuayu Risiyaxi xei miriyari cuyaxi tiva'aitüvame, nepi'inüatani xeniuqui. ");
INSERT INTO hchNT_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Tinita'aitüani xei sienituyari cuyaxi tiva'aitüvame mi'üviyanicü, mi'uxipitüacacü, mücavanenacacü hesüana miemete memiparevienicü hesüana memü'axenicü. ");
INSERT INTO hchNT_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Mericüsü yapaümexa 'anucayacu, Perixi mana niuyeicacaitüni yü'üitatü Rurusiramatü mühuriyutücai. Yu'aurie nitacuevieni Papuru, ni'eniecaitüni ticuxatame yuri que müti'erie Cürisitu Quesusisie. ");
INSERT INTO hchNT_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Ticuxatacacu tita mütiheiserie hepaüsita, tevi que mütiyünü'a hepaüsita, tevi que mütita'inüasieni hepaüsita, Perixi pümacai. Müpaü tinitahüave, Hicürixüa quenemie. Quepaucua tucari nemühüca ne'aurie nepümasitacuevieni. ");
INSERT INTO hchNT_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Siepüre nicueviecaitüni Papuru mi'üitüaniquecai tumini 'iya mixünacü ticu'erivatü. 'Ayumieme müixa yu'aurie pitacuecuevivacai, tinicuxatacaitüni hamatüana. ");
INSERT INTO hchNT_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Huta viyari 'uyurieca Perixi niuyupata. Purusiyu Pesitu 'isücame nayani. Perixi vanaqui'aritüamütü Huriyusixi, 'ayumieme hüacame necu'eirieni Papuru. ");
INSERT INTO hchNT_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Mericüsü Pesitu nuaca haque mehüritüariecai, hairieca tucari 'aye'acu, Sesareya heyeyaca Querusaremesie ninuani. ");
INSERT INTO hchNT_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Mara'acate memühüritüariecai Huriyusixi va'uquiyarima hüxiena meniu'axüani metehecüatatü Papuru hepaüsita. Menitavavirieni ");
INSERT INTO hchNT_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","müpaü me'utiyuatü, 'Aixüa petiuca'iyaritü Querusaremesie quenanunü'a Papuru. Müme meneicueviecaquecaitüni me'imienique huyeta 'uyemieme. ");
INSERT INTO hchNT_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Pesitu masi müpaü tinivaruta'eiya, Sesareyasiepai nepei'üviyani Papuru. Ne yareutevitü mana nepümie. ");
INSERT INTO hchNT_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Xesata miemete teyüvavemete nehamatü meque'uhuni, müme mequeheniuquixieca hepaüsitana, xüca tixaütü catiheiserietüni 'icü tevi hepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Mana müixa püca'uyuri, 'atahaica tucari xeicüa ya tamamata. 'Arique Sesareyasie neyani. 'Uxa'arieca yu'uveni haque müre'inüatacai 'acaitü tinivaruta'aitüani memi'atüanicü Papuru. ");
INSERT INTO hchNT_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Mana nuacu 'auriena meniyuxeürieni Huriyusixi Querusaremesie miemete. Vaüca türücavimecü metenexeiyacaitüni memüniuquixienicü hepaüsitana. Mepüyutatexie me'iseiriyatü yuniuqui. ");
INSERT INTO hchNT_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Papuru müpaü tiniutaniuni yuhesie mieme, Huriyusixi va'inüari niuquiyari hepaüsita, tuqui hepaüsita, Sesaxi hepaüsita, 'asinepücatiuyuri 'axa ti'aneme, 'utaitü. ");
INSERT INTO hchNT_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Pesitu vanaqui'aritüamütü Huriyusixi müpaü tinita'eiya Papuru, Peti'avaüriya Querusareme pemüyemie mana nemümasita'inüatacü 'icü niuquixiya hepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Papuru müpaü niutayüni, Ne Sesaxi 'uvenieya hüxie xeicüa 'aneputiveni nemü'inüasienicü. Mana xeicüa peuyevese nemü'inüasieni. 'Axa nepücavaruyuri Huriyusixi, heiseriemecü que pemütimate 'ecü. ");
INSERT INTO hchNT_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","'Axa xüca netiuyurienique, tixaü xüca netiuyurienique que müreuyevese nemümünicü, nepücanecu'imavaniqueyu nemümünicü. Mesü xüca tixaütü catihücütüni 'icü que memüteniuquixie nehepaüsita, xevitü tixaü pücayüve münesiyetuani vanaqui'aritüamütü. Necanitahüavimücü Sesaxi. ");
INSERT INTO hchNT_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Hicü Pesitu varutahüaveca 'imavamete müpaü tinita'eiya, Sesaxi petitahüavimücü 'acu. Mericüte, Sesaxisüa pecaniyemieni. ");
INSERT INTO hchNT_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Mericüsü müixa tucari 'anucayacu, cuiepa ti'aitame 'Acüripa mütitevacai Verenisematü meneicu'ivata Pesitu Sesareyapai. ");
INSERT INTO hchNT_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Yapaümexa tucari mana mepuyuri. Pesitu tinicuxaxatüvacaitüni cuiepa ti'aitame Papuru hepaüsita, müpaü 'utaitü, Xevitü tevi 'uva pucu'eiriva Perixi mivi menutahüa. ");
INSERT INTO hchNT_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Querusaremesie neheta'acu, hepaüsitana meteniutahecüata mara'acate memühüritüarie, Huriyusixi va'uquiyarima, menesivavirietü manutahüiyanicü. ");
INSERT INTO hchNT_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Nesü müpaü netinivaruta'eiya, Xumatari tatutuyari müpaü püca'ane, tepüca'iyetuani 'uqui, hüxiena meca'axüavavecacu cuxi müme hepaüsitana memüniuquixie, cayüvecacu cuxi yuhesie mieme mütaniuni vaniuquixiya 'hepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","'Uva me'u'axüacu, 'ayumieme 'enepücareuterixü. 'Uxa'arieca 'isücame 'uvenieyasie haque nemüra'inüata ne'ayerüca, nenivaruta'aitüani memevitünicü 'iya 'uqui. ");
INSERT INTO hchNT_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Müme memüniuquixiecai quepaucua memanucu'ui, mepücaniuquixiecai 'axa müti'ane mütiuyuricü, que nemütimaicai ne. ");
INSERT INTO hchNT_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Niuqui xüatüaricacü xeicüa tita memüte'ayexeiya hepaüsita xeime Quesusi hepaüsita mümüquicai, Papuru 'ayeniereme müxatacai, mücücü püta meniniuquixiecaitüni hepaüsitana. ");
INSERT INTO hchNT_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Nesü 'asinepücatimaicai 'icü niuqui hepaüsita. 'Ayumieme müpaü netinitahüave, Peti'avaüriya Querusaremesie pemüyemie mana peme'inüasienicü 'icü hepaüsita. ");
INSERT INTO hchNT_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Papuru caneniutavavirieni nemi'üviyanicü, ti'aitame 'Aucusitu mi'enienique. 'Ayumieme netinivaruta'aitüani memi'üviyanicü Sesaxisüa nemenunü'anique. ");
INSERT INTO hchNT_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","'Acüripa müpaü tinitahüave Pesitu, Nesüari necani'enieniqueyu 'iya tevi. Müpaü niutayüni, Mericüte 'uxa'a pecani'eniemücü. ");
INSERT INTO hchNT_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","'Uxa'arieca meniu'axüani 'Acüripa Verenisematü cuini mieme mete'uniütü memamarivavetü. Mana mürayuti'enieritüre meneutahaxüani xei miriyari cuyaxi teva'aitüvamete vahamatü, 'uquisi quiecatari memüva'uquiyarimatücai vahamatü. Pesitu tinivaruta'aitüani memevitünicü Papuru. ");
INSERT INTO hchNT_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Hicü Pesitu müpaü niutayüni, Ti'aitame 'Acüripa, xemeta yunaitü tahamatü xemüyucuxeüri 'uquisita, manari xenixeiyani que mü'ane hepaüsita vaüriyarica memünesi'upitüa yunaitü Huriyusixi teüteriyari Querusaremesie 'uvata, müpaü mete'uhivatü quename 'aixüa ca'ane mayeyurini. ");
INSERT INTO hchNT_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Ne tixaütü nepücatiucaxei que mütiuyuri que müreuyevese mumünicü. 'Iyasü yamütitahüavimücücaicü 'Aucusitu, ne yanepütinemaicai nemenunü'anicü. ");
INSERT INTO hchNT_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Niuqui müheiserie nepücahexeiya nemiti'utüirienicü cuiepa ti'aitame. 'Ayumieme neni'atüani xehesüa, 'ahesüatütü ti'aitame 'Acüripa, pe'iti'inüatayu tixaütü nemürexeiyanicü nemütiti'utüanicü. ");
INSERT INTO hchNT_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Timaivemepaü nepücayüniqueyu xüca xeime nehenü'anique hüacame, necatihecüatatü que mütiniuquimarie. ");
INSERT INTO hchNT_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Mericüsü 'Acüripa müpaü tinitahüave