﻿USE sofia;
DROP TABLE IF EXISTS sofia.hbo_vpl;
CREATE TABLE hbo_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES hbo_vpl WRITE;
INSERT INTO hbo_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","בְּרֵאשִׁ֖ית בָּרָ֣א אֱלֹהִ֑ים אֵ֥ת הַשָּׁמַ֖יִם וְאֵ֥ת הָאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","וְהָאָ֗רֶץ הָיְתָ֥ה תֹ֙הוּ֙ וָבֹ֔הוּ וְחֹ֖שֶׁךְ עַל־פְּנֵ֣י תְהֹ֑ום וְר֣וּחַ אֱלֹהִ֔ים מְרַחֶ֖פֶת עַל־פְּנֵ֥י הַמָּֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","וַיֹּ֥אמֶר אֱלֹהִ֖ים יְהִ֣י אֹ֑ור וַֽיְהִי־אֹֽור׃ ");
INSERT INTO hbo_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","וַיַּ֧רְא אֱלֹהִ֛ים אֶת־הָאֹ֖ור כִּי־טֹ֑וב וַיַּבְדֵּ֣ל אֱלֹהִ֔ים בֵּ֥ין הָאֹ֖ור וּבֵ֥ין הַחֹֽשֶׁךְ׃ ");
INSERT INTO hbo_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","וַיִּקְרָ֨א אֱלֹהִ֤ים ׀ לָאֹור֙ יֹ֔ום וְלַחֹ֖שֶׁךְ קָ֣רָא לָ֑יְלָה וַֽיְהִי־עֶ֥רֶב וַֽיְהִי־בֹ֖קֶר יֹ֥ום אֶחָֽד׃ פ ");
INSERT INTO hbo_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","וַיֹּ֣אמֶר אֱלֹהִ֔ים יְהִ֥י רָקִ֖יעַ בְּתֹ֣וךְ הַמָּ֑יִם וִיהִ֣י מַבְדִּ֔יל בֵּ֥ין מַ֖יִם לָמָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","וַיַּ֣עַשׂ אֱלֹהִים֮ אֶת־הָרָקִיעַ֒ וַיַּבְדֵּ֗ל בֵּ֤ין הַמַּ֙יִם֙ אֲשֶׁר֙ מִתַּ֣חַת לָרָקִ֔יעַ וּבֵ֣ין הַמַּ֔יִם אֲשֶׁ֖ר מֵעַ֣ל לָרָקִ֑יעַ וַֽיְהִי־כֵֽן׃ ");
INSERT INTO hbo_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","וַיִּקְרָ֧א אֱלֹהִ֛ים לָֽרָקִ֖יעַ שָׁמָ֑יִם וַֽיְהִי־עֶ֥רֶב וַֽיְהִי־בֹ֖קֶר יֹ֥ום שֵׁנִֽי׃ פ ");
INSERT INTO hbo_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","וַיֹּ֣אמֶר אֱלֹהִ֗ים יִקָּו֨וּ הַמַּ֜יִם מִתַּ֤חַת הַשָּׁמַ֙יִם֙ אֶל־מָקֹ֣ום אֶחָ֔ד וְתֵרָאֶ֖ה הַיַּבָּשָׁ֑ה וַֽיְהִי־כֵֽן׃ ");
INSERT INTO hbo_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","וַיִּקְרָ֨א אֱלֹהִ֤ים ׀ לַיַּבָּשָׁה֙ אֶ֔רֶץ וּלְמִקְוֵ֥ה הַמַּ֖יִם קָרָ֣א יַמִּ֑ים וַיַּ֥רְא אֱלֹהִ֖ים כִּי־טֹֽוב׃ ");
INSERT INTO hbo_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","וַיֹּ֣אמֶר אֱלֹהִ֗ים תַּֽדְשֵׁ֤א הָאָ֙רֶץ֙ דֶּ֔שֶׁא עֵ֚שֶׂב מַזְרִ֣יעַ זֶ֔רַע עֵ֣ץ פְּרִ֞י עֹ֤שֶׂה פְּרִי֙ לְמִינֹ֔ו אֲשֶׁ֥ר זַרְעֹו־בֹ֖ו עַל־הָאָ֑רֶץ וַֽיְהִי־כֵֽן׃ ");
INSERT INTO hbo_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","וַתֹּוצֵ֨א הָאָ֜רֶץ דֶּ֠שֶׁא עֵ֣שֶׂב מַזְרִ֤יעַ זֶ֙רַע֙ לְמִינֵ֔הוּ וְעֵ֧ץ עֹֽשֶׂה־פְּרִ֛י אֲשֶׁ֥ר זַרְעֹו־בֹ֖ו לְמִינֵ֑הוּ וַיַּ֥רְא אֱלֹהִ֖ים כִּי־טֹֽוב׃ ");
INSERT INTO hbo_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","וֽ͏ַיְהִי־עֶ֥רֶב וֽ͏ַיְהִי־בֹ֖קֶר יֹ֥ום שְׁלִישִֽׁי׃ פ ");
INSERT INTO hbo_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","וַיֹּ֣אמֶר אֱלֹהִ֗ים יְהִ֤י מְאֹרֹת֙ בִּרְקִ֣יעַ הַשָּׁמַ֔יִם לְהַבְדִּ֕יל בֵּ֥ין הַיֹּ֖ום וּבֵ֣ין הַלָּ֑יְלָה וְהָי֤וּ לְאֹתֹת֙ וּלְמֹ֣ועֲדִ֔ים וּלְיָמִ֖ים וְשָׁנִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","וְהָי֤וּ לִמְאֹורֹת֙ בִּרְקִ֣יעַ הַשָּׁמַ֔יִם לְהָאִ֖יר עַל־הָאָ֑רֶץ וֽ͏ַיְהִי־כֵֽן׃ ");
INSERT INTO hbo_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","וַיַּ֣עַשׂ אֱלֹהִ֔ים אֶת־שְׁנֵ֥י הַמְּאֹרֹ֖ת הַגְּדֹלִ֑ים אֶת־הַמָּאֹ֤ור הַגָּדֹל֙ לְמֶמְשֶׁ֣לֶת הַיֹּ֔ום וְאֶת־הַמָּאֹ֤ור הַקָּטֹן֙ לְמֶמְשֶׁ֣לֶת הַלַּ֔יְלָה וְאֵ֖ת הַכֹּוכָבִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","וַיִּתֵּ֥ן אֹתָ֛ם אֱלֹהִ֖ים בִּרְקִ֣יעַ הַשָּׁמָ֑יִם לְהָאִ֖יר עַל־הָאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","וְלִמְשֹׁל֙ בַּיֹּ֣ום וּבַלַּ֔יְלָה וּֽלֲהַבְדִּ֔יל בֵּ֥ין הָאֹ֖ור וּבֵ֣ין הַחֹ֑שֶׁךְ וַיַּ֥רְא אֱלֹהִ֖ים כִּי־טֹֽוב׃ ");
INSERT INTO hbo_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","וַֽיְהִי־עֶ֥רֶב וַֽיְהִי־בֹ֖קֶר יֹ֥ום רְבִיעִֽי׃ פ ");
INSERT INTO hbo_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","וַיֹּ֣אמֶר אֱלֹהִ֔ים יִשְׁרְצ֣וּ הַמַּ֔יִם שֶׁ֖רֶץ נֶ֣פֶשׁ חַיָּ֑ה וְעֹוף֙ יְעֹופֵ֣ף עַל־הָאָ֔רֶץ עַל־פְּנֵ֖י רְקִ֥יעַ הַשָּׁמָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","וַיִּבְרָ֣א אֱלֹהִ֔ים אֶת־הַתַּנִּינִ֖ם הַגְּדֹלִ֑ים וְאֵ֣ת כָּל־נֶ֣פֶשׁ הֽ͏ַחַיָּ֣ה ׀ הָֽרֹמֶ֡שֶׂת אֲשֶׁר֩ שָׁרְצ֨וּ הַמַּ֜יִם לְמִֽינֵהֶ֗ם וְאֵ֨ת כָּל־עֹ֤וף כָּנָף֙ לְמִינֵ֔הוּ וַיַּ֥רְא אֱלֹהִ֖ים כִּי־טֹֽוב׃ ");
INSERT INTO hbo_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","וַיְבָ֧רֶךְ אֹתָ֛ם אֱלֹהִ֖ים לֵאמֹ֑ר פְּר֣וּ וּרְב֗וּ וּמִלְא֤וּ אֶת־הַמַּ֙יִם֙ בַּיַּמִּ֔ים וְהָעֹ֖וף יִ֥רֶב בָּאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","וַֽיְהִי־עֶ֥רֶב וַֽיְהִי־בֹ֖קֶר יֹ֥ום חֲמִישִֽׁי׃ פ ");
INSERT INTO hbo_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","וַיֹּ֣אמֶר אֱלֹהִ֗ים תֹּוצֵ֨א הָאָ֜רֶץ נֶ֤פֶשׁ חַיָּה֙ לְמִינָ֔הּ בְּהֵמָ֥ה וָרֶ֛מֶשׂ וְחַֽיְתֹו־אֶ֖רֶץ לְמִינָ֑הּ וַֽיְהִי־כֵֽן׃ ");
INSERT INTO hbo_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","וַיַּ֣עַשׂ אֱלֹהִים֩ אֶת־חַיַּ֨ת הָאָ֜רֶץ לְמִינָ֗הּ וְאֶת־הַבְּהֵמָה֙ לְמִינָ֔הּ וְאֵ֛ת כָּל־רֶ֥מֶשׂ הָֽאֲדָמָ֖ה לְמִינֵ֑הוּ וַיַּ֥רְא אֱלֹהִ֖ים כִּי־טֹֽוב׃ ");
INSERT INTO hbo_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","וַיֹּ֣אמֶר אֱלֹהִ֔ים נַֽעֲשֶׂ֥ה אָדָ֛ם בְּצַלְמֵ֖נוּ כִּדְמוּתֵ֑נוּ וְיִרְדּוּ֩ בִדְגַ֨ת הַיָּ֜ם וּבְעֹ֣וף הַשָּׁמַ֗יִם וּבַבְּהֵמָה֙ וּבְכָל־הָאָ֔רֶץ וּבְכָל־הָרֶ֖מֶשׂ הֽ͏ָרֹמֵ֥שׂ עַל־הָאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","וַיִּבְרָ֨א אֱלֹהִ֤ים ׀ אֶת־הֽ͏ָאָדָם֙ בְּצַלְמֹ֔ו בְּצֶ֥לֶם אֱלֹהִ֖ים בָּרָ֣א אֹתֹ֑ו זָכָ֥ר וּנְקֵבָ֖ה בָּרָ֥א אֹתָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","וַיְבָ֣רֶךְ אֹתָם֮ אֱלֹהִים֒ וַיֹּ֨אמֶר לָהֶ֜ם אֱלֹהִ֗ים פְּר֥וּ וּרְב֛וּ וּמִלְא֥וּ אֶת־הָאָ֖רֶץ וְכִבְשֻׁ֑הָ וּרְד֞וּ בִּדְגַ֤ת הַיָּם֙ וּבְעֹ֣וף הַשָּׁמַ֔יִם וּבְכָל־חַיָּ֖ה הֽ͏ָרֹמֶ֥שֶׂת עַל־הָאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","וַיֹּ֣אמֶר אֱלֹהִ֗ים הִנֵּה֩ נָתַ֨תִּי לָכֶ֜ם אֶת־כָּל־עֵ֣שֶׂב ׀ זֹרֵ֣עַ זֶ֗רַע אֲשֶׁר֙ עַל־פְּנֵ֣י כָל־הָאָ֔רֶץ וְאֶת־כָּל־הָעֵ֛ץ אֲשֶׁר־בֹּ֥ו פְרִי־עֵ֖ץ זֹרֵ֣עַ זָ֑רַע לָכֶ֥ם יִֽהְיֶ֖ה לְאָכְלָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","וּֽלְכָל־חַיַּ֣ת הָ֠אָרֶץ וּלְכָל־עֹ֨וף הַשָּׁמַ֜יִם וּלְכֹ֣ל ׀ רֹומֵ֣שׂ עַל־הָאָ֗רֶץ אֲשֶׁר־בֹּו֙ נֶ֣פֶשׁ חַיָּ֔ה אֶת־כָּל־יֶ֥רֶק עֵ֖שֶׂב לְאָכְלָ֑ה וַֽיְהִי־כֵֽן׃ ");
INSERT INTO hbo_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","וַיַּ֤רְא אֱלֹהִים֙ אֶת־כָּל־אֲשֶׁ֣ר עָשָׂ֔ה וְהִנֵּה־טֹ֖וב מְאֹ֑ד וֽ͏ַיְהִי־עֶ֥רֶב וֽ͏ַיְהִי־בֹ֖קֶר יֹ֥ום הַשִּׁשִּֽׁי׃ פ ");
INSERT INTO hbo_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","וַיְכֻלּ֛וּ הַשָּׁמַ֥יִם וְהָאָ֖רֶץ וְכָל־צְבָאָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","וַיְכַ֤ל אֱלֹהִים֙ בַּיֹּ֣ום הַשְּׁבִיעִ֔י מְלַאכְתֹּ֖ו אֲשֶׁ֣ר עָשָׂ֑ה וַיִּשְׁבֹּת֙ בַּיֹּ֣ום הַשְּׁבִיעִ֔י מִכָּל־מְלַאכְתֹּ֖ו אֲשֶׁ֥ר עָשָֽׂה׃ ");
INSERT INTO hbo_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","וַיְבָ֤רֶךְ אֱלֹהִים֙ אֶת־יֹ֣ום הַשְּׁבִיעִ֔י וַיְקַדֵּ֖שׁ אֹתֹ֑ו כִּ֣י בֹ֤ו שָׁבַת֙ מִכָּל־מְלַאכְתֹּ֔ו אֲשֶׁר־בָּרָ֥א אֱלֹהִ֖ים לַעֲשֹֽׂות׃ פ ");
INSERT INTO hbo_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","אֵ֣לֶּה תֹולְדֹ֧ות הַשָּׁמַ֛יִם וְהָאָ֖רֶץ בְּהִבָּֽרְאָ֑ם בְּיֹ֗ום עֲשֹׂ֛ות יְהוָ֥ה אֱלֹהִ֖ים אֶ֥רֶץ וְשָׁמָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","וְכֹ֣ל ׀ שִׂ֣יחַ הַשָּׂדֶ֗ה טֶ֚רֶם יִֽהְיֶ֣ה בָאָ֔רֶץ וְכָל־עֵ֥שֶׂב הַשָּׂדֶ֖ה טֶ֣רֶם יִצְמָ֑ח כִּי֩ לֹ֨א הִמְטִ֜יר יְהוָ֤ה אֱלֹהִים֙ עַל־הָאָ֔רֶץ וְאָדָ֣ם אַ֔יִן לַֽעֲבֹ֖ד אֶת־הָֽאֲדָמָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","וְאֵ֖ד יַֽעֲלֶ֣ה מִן־הָאָ֑רֶץ וְהִשְׁקָ֖ה אֶֽת־כָּל־פְּנֵֽי־הָֽאֲדָמָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","וַיִּיצֶר֩ יְהוָ֨ה אֱלֹהִ֜ים אֶת־הָֽאָדָ֗ם עָפָר֙ מִן־הָ֣אֲדָמָ֔ה וַיִּפַּ֥ח בְּאַפָּ֖יו נִשְׁמַ֣ת חַיִּ֑ים וַֽיְהִ֥י הָֽאָדָ֖ם לְנֶ֥פֶשׁ חַיָּֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","וַיִּטַּ֞ע יְהוָ֧ה אֱלֹהִ֛ים גַּן־בְּעֵ֖דֶן מִקֶּ֑דֶם וַיָּ֣שֶׂם שָׁ֔ם אֶת־הָֽאָדָ֖ם אֲשֶׁ֥ר יָצָֽר׃ ");
INSERT INTO hbo_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","וַיַּצְמַ֞ח יְהוָ֤ה אֱלֹהִים֙ מִן־הָ֣אֲדָמָ֔ה כָּל־עֵ֛ץ נֶחְמָ֥ד לְמַרְאֶ֖ה וְטֹ֣וב לְמַאֲכָ֑ל וְעֵ֤ץ הַֽחַיִּים֙ בְּתֹ֣וךְ הַגָּ֔ן וְעֵ֕ץ הַדַּ֖עַת טֹ֥וב וָרָֽע׃ ");
INSERT INTO hbo_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","וְנָהָר֙ יֹצֵ֣א מֵעֵ֔דֶן לְהַשְׁקֹ֖ות אֶת־הַגָּ֑ן וּמִשָּׁם֙ יִפָּרֵ֔ד וְהָיָ֖ה לְאַרְבָּעָ֥ה רָאשִֽׁים׃ ");
INSERT INTO hbo_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","שֵׁ֥ם הָֽאֶחָ֖ד פִּישֹׁ֑ון ה֣וּא הַסֹּבֵ֗ב אֵ֚ת כָּל־אֶ֣רֶץ הַֽחֲוִילָ֔ה אֲשֶׁר־שָׁ֖ם הַזָּהָֽב׃ ");
INSERT INTO hbo_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","וּֽזֲהַ֛ב הָאָ֥רֶץ הַהִ֖וא טֹ֑וב שָׁ֥ם הַבְּדֹ֖לַח וְאֶ֥בֶן הַשֹּֽׁהַם׃ ");
INSERT INTO hbo_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","וְשֵֽׁם־הַנָּהָ֥ר הַשֵּׁנִ֖י גִּיחֹ֑ון ה֣וּא הַסֹּובֵ֔ב אֵ֖ת כָּל־אֶ֥רֶץ כּֽוּשׁ׃ ");
INSERT INTO hbo_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","וְשֵׁ֨ם הַנָּהָ֤ר הַשְּׁלִישִׁי֙ חִדֶּ֔קֶל ה֥וּא הַֽהֹלֵ֖ךְ קִדְמַ֣ת אַשּׁ֑וּר וְהַנָּהָ֥ר הָֽרְבִיעִ֖י ה֥וּא פְרָֽת׃ ");
INSERT INTO hbo_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","וַיִּקַּ֛ח יְהוָ֥ה אֱלֹהִ֖ים אֶת־הָֽאָדָ֑ם וַיַּנִּחֵ֣הוּ בְגַן־עֵ֔דֶן לְעָבְדָ֖הּ וּלְשָׁמְרָֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","וַיְצַו֙ יְהוָ֣ה אֱלֹהִ֔ים עַל־הָֽאָדָ֖ם לֵאמֹ֑ר מִכֹּ֥ל עֵֽץ־הַגָּ֖ן אָכֹ֥ל תֹּאכֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","וּמֵעֵ֗ץ הַדַּ֙עַת֙ טֹ֣וב וָרָ֔ע לֹ֥א תֹאכַ֖ל מִמֶּ֑נּוּ כִּ֗י בְּיֹ֛ום אֲכָלְךָ֥ מִמֶּ֖נּוּ מֹ֥ות תָּמֽוּת׃ ");
INSERT INTO hbo_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","וַיֹּ֙אמֶר֙ יְהוָ֣ה אֱלֹהִ֔ים לֹא־טֹ֛וב הֱיֹ֥ות הָֽאָדָ֖ם לְבַדֹּ֑ו אֶֽעֱשֶׂהּ־לֹּ֥ו עֵ֖זֶר כְּנֶגְדֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","וַיִּצֶר֩ יְהוָ֨ה אֱלֹהִ֜ים מִן־הָֽאֲדָמָ֗ה כָּל־חַיַּ֤ת הַשָּׂדֶה֙ וְאֵת֙ כָּל־עֹ֣וף הַשָּׁמַ֔יִם וַיָּבֵא֙ אֶל־הָ֣אָדָ֔ם לִרְאֹ֖ות מַה־יִּקְרָא־לֹ֑ו וְכֹל֩ אֲשֶׁ֨ר יִקְרָא־לֹ֧ו הָֽאָדָ֛ם נֶ֥פֶשׁ חַיָּ֖ה ה֥וּא שְׁמֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","וַיִּקְרָ֨א הָֽאָדָ֜ם שֵׁמֹ֗ות לְכָל־הַבְּהֵמָה֙ וּלְעֹ֣וף הַשָּׁמַ֔יִם וּלְכֹ֖ל חַיַּ֣ת הַשָּׂדֶ֑ה וּלְאָדָ֕ם לֹֽא־מָצָ֥א עֵ֖זֶר כְּנֶגְדֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","וַיַּפֵּל֩ יְהוָ֨ה אֱלֹהִ֧ים ׀ תַּרְדֵּמָ֛ה עַל־הָאָדָ֖ם וַיִּישָׁ֑ן וַיִּקַּ֗ח אַחַת֙ מִצַּלְעֹתָ֔יו וַיִּסְגֹּ֥ר בָּשָׂ֖ר תַּחְתֶּֽנָּה׃ ");
INSERT INTO hbo_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","וַיִּבֶן֩ יְהוָ֨ה אֱלֹהִ֧ים ׀ אֶֽת־הַצֵּלָ֛ע אֲשֶׁר־לָקַ֥ח מִן־הָֽאָדָ֖ם לְאִשָּׁ֑ה וַיְבִאֶ֖הָ אֶל־הָֽאָדָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","וַיֹּאמֶר֮ הֽ͏ָאָדָם֒ זֹ֣את הַפַּ֗עַם עֶ֚צֶם מֵֽעֲצָמַ֔י וּבָשָׂ֖ר מִבְּשָׂרִ֑י לְזֹאת֙ יִקָּרֵ֣א אִשָּׁ֔ה כִּ֥י מֵאִ֖ישׁ לֻֽקֳחָה־זֹּֽאת׃ ");
INSERT INTO hbo_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","עַל־כֵּן֙ יֽ͏ַעֲזָב־אִ֔ישׁ אֶת־אָבִ֖יו וְאֶת־אִמֹּ֑ו וְדָבַ֣ק בְּאִשְׁתֹּ֔ו וְהָי֖וּ לְבָשָׂ֥ר אֶחָֽד׃ ");
INSERT INTO hbo_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","וַיִּֽהְי֤וּ שְׁנֵיהֶם֙ עֲרוּמִּ֔ים הָֽאָדָ֖ם וְאִשְׁתֹּ֑ו וְלֹ֖א יִתְבֹּשָֽׁשׁוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","וְהַנָּחָשׁ֙ הָיָ֣ה עָר֔וּם מִכֹּל֙ חַיַּ֣ת הַשָּׂדֶ֔ה אֲשֶׁ֥ר עָשָׂ֖ה יְהוָ֣ה אֱלֹהִ֑ים וַיֹּ֙אמֶר֙ אֶל־הָ֣אִשָּׁ֔ה אַ֚ף כִּֽי־אָמַ֣ר אֱלֹהִ֔ים לֹ֣א תֹֽאכְל֔וּ מִכֹּ֖ל עֵ֥ץ הַגָּֽן׃ ");
INSERT INTO hbo_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","וַתֹּ֥אמֶר הָֽאִשָּׁ֖ה אֶל־הַנָּחָ֑שׁ מִפְּרִ֥י עֵֽץ־הַגָּ֖ן נֹאכֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","וּמִפְּרִ֣י הָעֵץ֮ אֲשֶׁ֣ר בְּתֹוךְ־הַגָּן֒ אָמַ֣ר אֱלֹהִ֗ים לֹ֤א תֹֽאכְלוּ֙ מִמֶּ֔נּוּ וְלֹ֥א תִגְּע֖וּ בֹּ֑ו פֶּן־תְּמֻתֽוּן׃ ");
INSERT INTO hbo_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","וַיֹּ֥אמֶר הַנָּחָ֖שׁ אֶל־הָֽאִשָּׁ֑ה לֹֽא־מֹ֖ות תְּמֻתֽוּן׃ ");
INSERT INTO hbo_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","כִּ֚י יֹדֵ֣עַ אֱלֹהִ֔ים כִּ֗י בְּיֹום֙ אֲכָלְכֶ֣ם מִמֶּ֔נּוּ וְנִפְקְח֖וּ עֵֽינֵיכֶ֑ם וִהְיִיתֶם֙ כֵּֽאלֹהִ֔ים יֹדְעֵ֖י טֹ֥וב וָרָֽע׃ ");
INSERT INTO hbo_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","וַתֵּ֣רֶא הָֽאִשָּׁ֡ה כִּ֣י טֹוב֩ הָעֵ֨ץ לְמַאֲכָ֜ל וְכִ֧י תַֽאֲוָה־ה֣וּא לָעֵינַ֗יִם וְנֶחְמָ֤ד הָעֵץ֙ לְהַשְׂכִּ֔יל וַתִּקַּ֥ח מִפִּרְיֹ֖ו וַתֹּאכַ֑ל וַתִּתֵּ֧ן גַּם־לְאִישָׁ֛הּ עִמָּ֖הּ וַיֹּאכַֽל׃ ");
INSERT INTO hbo_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","וַתִּפָּקַ֙חְנָה֙ עֵינֵ֣י שְׁנֵיהֶ֔ם וַיֵּ֣דְע֔וּ כִּ֥י עֵֽירֻמִּ֖ם הֵ֑ם וַֽיִּתְפְּרוּ֙ עֲלֵ֣ה תְאֵנָ֔ה וַיַּעֲשׂ֥וּ לָהֶ֖ם חֲגֹרֹֽת׃ ");
INSERT INTO hbo_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","וַֽיִּשְׁמְע֞וּ אֶת־קֹ֨ול יְהוָ֧ה אֱלֹהִ֛ים מִתְהַלֵּ֥ךְ בַּגָּ֖ן לְר֣וּחַ הַיֹּ֑ום וַיִּתְחַבֵּ֨א הָֽאָדָ֜ם וְאִשְׁתֹּ֗ו מִפְּנֵי֙ יְהוָ֣ה אֱלֹהִ֔ים בְּתֹ֖וךְ עֵ֥ץ הַגָּֽן׃ ");
INSERT INTO hbo_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","וַיִּקְרָ֛א יְהוָ֥ה אֱלֹהִ֖ים אֶל־הָֽאָדָ֑ם וַיֹּ֥אמֶר לֹ֖ו אַיֶּֽכָּה׃ ");
INSERT INTO hbo_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","וַיֹּ֕אמֶר אֶת־קֹלְךָ֥ שָׁמַ֖עְתִּי בַּגָּ֑ן וָאִירָ֛א כִּֽי־עֵירֹ֥ם אָנֹ֖כִי וָאֵחָבֵֽא׃ ");
INSERT INTO hbo_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","וַיֹּ֕אמֶר מִ֚י הִגִּ֣יד לְךָ֔ כִּ֥י עֵירֹ֖ם אָ֑תָּה הֲמִן־הָעֵ֗ץ אֲשֶׁ֧ר צִוִּיתִ֛יךָ לְבִלְתִּ֥י אֲכָל־מִמֶּ֖נּוּ אָכָֽלְתָּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","וַיֹּ֖אמֶר הָֽאָדָ֑ם הָֽאִשָּׁה֙ אֲשֶׁ֣ר נָתַ֣תָּה עִמָּדִ֔י הִ֛וא נָֽתְנָה־לִּ֥י מִן־הָעֵ֖ץ וָאֹכֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","וַיֹּ֨אמֶר יְהוָ֧ה אֱלֹהִ֛ים לָאִשָּׁ֖ה מַה־זֹּ֣את עָשִׂ֑ית וַתֹּ֙אמֶר֙ הָֽאִשָּׁ֔ה הַנָּחָ֥שׁ הִשִּׁיאַ֖נִי וָאֹכֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","וַיֹּאמֶר֩ יְהֹוָ֨ה אֱלֹהִ֥ים ׀ אֶֽל־הַנָּחָשׁ֮ כִּ֣י עָשִׂ֣יתָ זֹּאת֒ אָר֤וּר אַתָּה֙ מִכָּל־הַבְּהֵמָ֔ה וּמִכֹּ֖ל חַיַּ֣ת הַשָּׂדֶ֑ה עַל־גְּחֹנְךָ֣ תֵלֵ֔ךְ וְעָפָ֥ר תֹּאכַ֖ל כָּל־יְמֵ֥י חַיֶּֽיךָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","וְאֵיבָ֣ה ׀ אָשִׁ֗ית בֵּֽינְךָ֙ וּבֵ֣ין הָֽאִשָּׁ֔ה וּבֵ֥ין זַרְעֲךָ֖ וּבֵ֣ין זַרְעָ֑הּ ה֚וּא יְשׁוּפְךָ֣ רֹ֔אשׁ וְאַתָּ֖ה תְּשׁוּפֶ֥נּוּ עָקֵֽב׃ ס ");
INSERT INTO hbo_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","אֶֽל־הָאִשָּׁ֣ה אָמַ֗ר הַרְבָּ֤ה אַרְבֶּה֙ עִצְּבֹונֵ֣ךְ וְהֵֽרֹנֵ֔ךְ בְּעֶ֖צֶב תֵּֽלְדִ֣י בָנִ֑ים וְאֶל־אִישֵׁךְ֙ תְּשׁ֣וּקָתֵ֔ךְ וְה֖וּא יִמְשָׁל־בָּֽךְ׃ ס ");
INSERT INTO hbo_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","וּלְאָדָ֣ם אָמַ֗ר כִּֽי־שָׁמַעְתָּ֮ לְקֹ֣ול אִשְׁתֶּךָ֒ וַתֹּ֙אכַל֙ מִן־הָעֵ֔ץ אֲשֶׁ֤ר צִוִּיתִ֙יךָ֙ לֵאמֹ֔ר לֹ֥א תֹאכַ֖ל מִמֶּ֑נּוּ אֲרוּרָ֤ה הָֽאֲדָמָה֙ בַּֽעֲבוּרֶ֔ךָ בְּעִצָּבֹון֙ תֹּֽאכֲלֶ֔נָּה כֹּ֖ל יְמֵ֥י חַיֶּֽיךָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","וְקֹ֥וץ וְדַרְדַּ֖ר תַּצְמִ֣יחַֽ לָ֑ךְ וְאָכַלְתָּ֖ אֶת־עֵ֥שֶׂב הַשָּׂדֶֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","בְּזֵעַ֤ת אַפֶּ֙יךָ֙ תֹּ֣אכַל לֶ֔חֶם עַ֤ד שֽׁוּבְךָ֙ אֶל־הָ֣אֲדָמָ֔ה כִּ֥י מִמֶּ֖נָּה לֻקָּ֑חְתָּ כִּֽי־עָפָ֣ר אַ֔תָּה וְאֶל־עָפָ֖ר תָּשֽׁוּב׃ ");
INSERT INTO hbo_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","וַיִּקְרָ֧א הָֽאָדָ֛ם שֵׁ֥ם אִשְׁתֹּ֖ו חַוָּ֑ה כִּ֛י הִ֥וא הָֽיְתָ֖ה אֵ֥ם כָּל־חָֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","וַיַּעַשׂ֩ יְהוָ֨ה אֱלֹהִ֜ים לְאָדָ֧ם וּלְאִשְׁתֹּ֛ו כָּתְנֹ֥ות עֹ֖ור וַיַּלְבִּשֵֽׁם׃ פ ");
INSERT INTO hbo_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","וַיֹּ֣אמֶר ׀ יְהוָ֣ה אֱלֹהִ֗ים הֵ֤ן הָֽאָדָם֙ הָיָה֙ כְּאַחַ֣ד מִמֶּ֔נּוּ לָדַ֖עַת טֹ֣וב וָרָ֑ע וְעַתָּ֣ה ׀ פֶּן־יִשְׁלַ֣ח יָדֹ֗ו וְלָקַח֙ גַּ֚ם מֵעֵ֣ץ הַֽחַיִּ֔ים וְאָכַ֖ל וָחַ֥י לְעֹלָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","וַֽיְשַׁלְּחֵ֛הוּ יְהוָ֥ה אֱלֹהִ֖ים מִגַּן־עֵ֑דֶן לַֽעֲבֹד֙ אֶת־הָ֣אֲדָמָ֔ה אֲשֶׁ֥ר לֻקַּ֖ח מִשָּֽׁם׃ ");
INSERT INTO hbo_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","וַיְגָ֖רֶשׁ אֶת־הָֽאָדָ֑ם וַיַּשְׁכֵּן֩ מִקֶּ֨דֶם לְגַן־עֵ֜דֶן אֶת־הַכְּרֻבִ֗ים וְאֵ֨ת לַ֤הַט הַחֶ֙רֶב֙ הַמִּתְהַפֶּ֔כֶת לִשְׁמֹ֕ר אֶת־דֶּ֖רֶךְ עֵ֥ץ הַֽחַיִּֽים׃ ס ");
INSERT INTO hbo_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","וְהָ֣אָדָ֔ם יָדַ֖ע אֶת־חַוָּ֣ה אִשְׁתֹּ֑ו וַתַּ֙הַר֙ וַתֵּ֣לֶד אֶת־קַ֔יִן וַתֹּ֕אמֶר קָנִ֥יתִי אִ֖ישׁ אֶת־יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","וַתֹּ֣סֶף לָלֶ֔דֶת אֶת־אָחִ֖יו אֶת־הָ֑בֶל וַֽיְהִי־הֶ֙בֶל֙ רֹ֣עֵה צֹ֔אן וְקַ֕יִן הָיָ֖ה עֹבֵ֥ד אֲדָמָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","וֽ͏ַיְהִ֖י מִקֵּ֣ץ יָמִ֑ים וַיָּבֵ֨א קַ֜יִן מִפְּרִ֧י הֽ͏ָאֲדָמָ֛ה מִנְחָ֖ה לַֽיהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","וְהֶ֨בֶל הֵבִ֥יא גַם־ה֛וּא מִבְּכֹרֹ֥ות צֹאנֹ֖ו וּמֵֽחֶלְבֵהֶ֑ן וַיִּ֣שַׁע יְהוָ֔ה אֶל־הֶ֖בֶל וְאֶל־מִנְחָתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","וְאֶל־קַ֥יִן וְאֶל־מִנְחָתֹ֖ו לֹ֣א שָׁעָ֑ה וַיִּ֤חַר לְקַ֙יִן֙ מְאֹ֔ד וַֽיִּפְּל֖וּ פָּנָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","וַיֹּ֥אמֶר יְהוָ֖ה אֶל־קָ֑יִן לָ֚מָּה חָ֣רָה לָ֔ךְ וְלָ֖מָּה נָפְל֥וּ פָנֶֽיךָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","הֲלֹ֤וא אִם־תֵּיטִיב֙ שְׂאֵ֔ת וְאִם֙ לֹ֣א תֵיטִ֔יב לַפֶּ֖תַח חַטָּ֣את רֹבֵ֑ץ וְאֵלֶ֙יךָ֙ תְּשׁ֣וּקָתֹ֔ו וְאַתָּ֖ה תִּמְשָׁל־בֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","וַיֹּ֥אמֶר קַ֖יִן אֶל־הֶ֣בֶל אָחִ֑יו וֽ͏ַיְהִי֙ בִּהְיֹותָ֣ם בַּשָּׂדֶ֔ה וַיָּ֥קָם קַ֛יִן אֶל־הֶ֥בֶל אָחִ֖יו וַיַּהַרְגֵֽהוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","וַיֹּ֤אמֶר יְהוָה֙ אֶל־קַ֔יִן אֵ֖י הֶ֣בֶל אָחִ֑יךָ וַיֹּ֙אמֶר֙ לֹ֣א יָדַ֔עְתִּי הֲשֹׁמֵ֥ר אָחִ֖י אָנֹֽכִי׃ ");
INSERT INTO hbo_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","וַיֹּ֖אמֶר מֶ֣ה עָשִׂ֑יתָ קֹ֚ול דְּמֵ֣י אָחִ֔יךָ צֹעֲקִ֥ים אֵלַ֖י מִן־הָֽאֲדָמָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","וְעַתָּ֖ה אָר֣וּר אָ֑תָּה מִן־הָֽאֲדָמָה֙ אֲשֶׁ֣ר פָּצְתָ֣ה אֶת־פִּ֔יהָ לָקַ֛חַת אֶת־דְּמֵ֥י אָחִ֖יךָ מִיָּדֶֽךָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","כִּ֤י תַֽעֲבֹד֙ אֶת־הָ֣אֲדָמָ֔ה לֹֽא־תֹסֵ֥ף תֵּת־כֹּחָ֖הּ לָ֑ךְ נָ֥ע וָנָ֖ד תִּֽהְיֶ֥ה בָאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","וַיֹּ֥אמֶר קַ֖יִן אֶל־יְהוָ֑ה גָּדֹ֥ול עֲוֹנִ֖י מִנְּשֹֽׂא׃ ");
INSERT INTO hbo_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","הֵן֩ גֵּרַ֨שְׁתָּ אֹתִ֜י הַיֹּ֗ום מֵעַל֙ פְּנֵ֣י הֽ͏ָאֲדָמָ֔ה וּמִפָּנֶ֖יךָ אֶסָּתֵ֑ר וְהָיִ֜יתִי נָ֤ע וָנָד֙ בָּאָ֔רֶץ וְהָיָ֥ה כָל־מֹצְאִ֖י יֽ͏ַהַרְגֵֽנִי׃ ");
INSERT INTO hbo_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","וַיֹּ֧אמֶר לֹ֣ו יְהוָ֗ה לָכֵן֙ כָּל־הֹרֵ֣ג קַ֔יִן שִׁבְעָתַ֖יִם יֻקָּ֑ם וַיָּ֨שֶׂם יְהוָ֤ה לְקַ֙יִן֙ אֹ֔ות לְבִלְתִּ֥י הַכֹּות־אֹתֹ֖ו כָּל־מֹצְאֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","וַיֵּ֥צֵא קַ֖יִן מִלִּפְנֵ֣י יְהוָ֑ה וַיֵּ֥שֶׁב בְּאֶֽרֶץ־נֹ֖וד קִדְמַת־עֵֽדֶן׃ ");
INSERT INTO hbo_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","וַיֵּ֤דַע קַ֙יִן֙ אֶת־אִשְׁתֹּ֔ו וַתַּ֖הַר וַתֵּ֣לֶד אֶת־חֲנֹ֑וךְ וַֽיְהִי֙ בֹּ֣נֶה עִ֔יר וַיִּקְרָא֙ שֵׁ֣ם הָעִ֔יר כְּשֵׁ֖ם בְּנֹ֥ו חֲנֹֽוךְ׃ ");
INSERT INTO hbo_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","וַיִּוָּלֵ֤ד לַֽחֲנֹוךְ֙ אֶת־עִירָ֔ד וְעִירָ֕ד יָלַ֖ד אֶת־מְחֽוּיָאֵ֑ל וּמְחִיּיָאֵ֗ל יָלַד֙ אֶת־מְת֣וּשָׁאֵ֔ל וּמְתוּשָׁאֵ֖ל יָלַ֥ד אֶת־לָֽמֶךְ׃ ");
INSERT INTO hbo_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","וַיִּֽקַּֽח־לֹ֥ו לֶ֖מֶךְ שְׁתֵּ֣י נָשִׁ֑ים שֵׁ֤ם הָֽאַחַת֙ עָדָ֔ה וְשֵׁ֥ם הַשֵּׁנִ֖ית צִלָּֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","וַתֵּ֥לֶד עָדָ֖ה אֶת־יָבָ֑ל ה֣וּא הָיָ֔ה אֲבִ֕י יֹשֵׁ֥ב אֹ֖הֶל וּמִקְנֶֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","וְשֵׁ֥ם אָחִ֖יו יוּבָ֑ל ה֣וּא הָיָ֔ה אֲבִ֕י כָּל־תֹּפֵ֥שׂ כִּנֹּ֖ור וְעוּגָֽב׃ ");
INSERT INTO hbo_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","וְצִלָּ֣ה גַם־הִ֗וא יָֽלְדָה֙ אֶת־תּ֣וּבַל קַ֔יִן לֹטֵ֕שׁ כָּל־חֹרֵ֥שׁ נְחֹ֖שֶׁת וּבַרְזֶ֑ל וַֽאֲחֹ֥ות תּֽוּבַל־קַ֖יִן נַֽעֲמָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","וַיֹּ֨אמֶר לֶ֜מֶךְ לְנָשָׁ֗יו עָדָ֤ה וְצִלָּה֙ שְׁמַ֣עַן קֹולִ֔י נְשֵׁ֣י לֶ֔מֶךְ הַאְזֵ֖נָּה אִמְרָתִ֑י כִּ֣י אִ֤ישׁ הָרַ֙גְתִּי֙ לְפִצְעִ֔י וְיֶ֖לֶד לְחַבֻּרָתִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","כִּ֥י שִׁבְעָתַ֖יִם יֻקַּם־קָ֑יִן וְלֶ֖מֶךְ שִׁבְעִ֥ים וְשִׁבְעָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","וַיֵּ֨דַע אָדָ֥ם עֹוד֙ אֶת־אִשְׁתֹּ֔ו וַתֵּ֣לֶד בֵּ֔ן וַתִּקְרָ֥א אֶת־שְׁמֹ֖ו שֵׁ֑ת כִּ֣י שָֽׁת־לִ֤י אֱלֹהִים֙ זֶ֣רַע אַחֵ֔ר תַּ֣חַת הֶ֔בֶל כִּ֥י הֲרָגֹ֖ו קָֽיִן׃ ");
INSERT INTO hbo_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","וּלְשֵׁ֤ת גַּם־הוּא֙ יֻלַּד־בֵּ֔ן וַיִּקְרָ֥א אֶת־שְׁמֹ֖ו אֱנֹ֑ושׁ אָ֣ז הוּחַ֔ל לִקְרֹ֖א בְּשֵׁ֥ם יְהוָֽה׃ פ ");
INSERT INTO hbo_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","זֶ֣ה סֵ֔פֶר תֹּולְדֹ֖ת אָדָ֑ם בְּיֹ֗ום בְּרֹ֤א אֱלֹהִים֙ אָדָ֔ם בִּדְמ֥וּת אֱלֹהִ֖ים עָשָׂ֥ה אֹתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","זָכָ֥ר וּנְקֵבָ֖ה בְּרָאָ֑ם וַיְבָ֣רֶךְ אֹתָ֗ם וַיִּקְרָ֤א אֶת־שְׁמָם֙ אָדָ֔ם בְּיֹ֖ום הִבָּֽרְאָֽם׃ ס ");
INSERT INTO hbo_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","וֽ͏ַיְחִ֣י אָדָ֗ם שְׁלֹשִׁ֤ים וּמְאַת֙ שָׁנָ֔ה וַיֹּ֥ולֶד בִּדְמוּתֹ֖ו כְּצַלְמֹ֑ו וַיִּקְרָ֥א אֶת־שְׁמֹ֖ו שֵֽׁת׃ ");
INSERT INTO hbo_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","וַיִּֽהְי֣וּ יְמֵי־אָדָ֗ם אֽ͏ַחֲרֵי֙ הֹולִידֹ֣ו אֶת־שֵׁ֔ת שְׁמֹנֶ֥ה מֵאֹ֖ת שָׁנָ֑ה וַיֹּ֥ולֶד בָּנִ֖ים וּבָנֹֽות׃ ");
INSERT INTO hbo_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","וַיִּֽהְי֞וּ כָּל־יְמֵ֤י אָדָם֙ אֲשֶׁר־חַ֔י תְּשַׁ֤ע מֵאֹות֙ שָׁנָ֔ה וּשְׁלֹשִׁ֖ים שָׁנָ֑ה וַיָּמֹֽת׃ ס ");
INSERT INTO hbo_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","וֽ͏ַיְחִי־שֵׁ֕ת חָמֵ֥שׁ שָׁנִ֖ים וּמְאַ֣ת שָׁנָ֑ה וַיֹּ֖ולֶד אֶת־אֱנֹֽושׁ׃ ");
INSERT INTO hbo_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","וֽ͏ַיְחִי־שֵׁ֗ת אֽ͏ַחֲרֵי֙ הֹולִידֹ֣ו אֶת־אֱנֹ֔ושׁ שֶׁ֣בַע שָׁנִ֔ים וּשְׁמֹנֶ֥ה מֵאֹ֖ות שָׁנָ֑ה וַיֹּ֥ולֶד בָּנִ֖ים וּבָנֹֽות׃ ");
INSERT INTO hbo_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","וַיִּֽהְיוּ֙ כָּל־יְמֵי־שֵׁ֔ת שְׁתֵּ֤ים עֶשְׂרֵה֙ שָׁנָ֔ה וּתְשַׁ֥ע מֵאֹ֖ות שָׁנָ֑ה וַיָּמֹֽת׃ ס ");
INSERT INTO hbo_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","וֽ͏ַיְחִ֥י אֱנֹ֖ושׁ תִּשְׁעִ֣ים שָׁנָ֑ה וַיֹּ֖ולֶד אֶת־קֵינָֽן׃ ");
INSERT INTO hbo_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","וֽ͏ַיְחִ֣י אֱנֹ֗ושׁ אֽ͏ַחֲרֵי֙ הֹולִידֹ֣ו אֶת־קֵינָ֔ן חֲמֵ֤שׁ עֶשְׂרֵה֙ שָׁנָ֔ה וּשְׁמֹנֶ֥ה מֵאֹ֖ות שָׁנָ֑ה וַיֹּ֥ולֶד בָּנִ֖ים וּבָנֹֽות׃ ");
INSERT INTO hbo_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","וַיִּֽהְיוּ֙ כָּל־יְמֵ֣י אֱנֹ֔ושׁ חָמֵ֣שׁ שָׁנִ֔ים וּתְשַׁ֥ע מֵאֹ֖ות שָׁנָ֑ה וַיָּמֹֽת׃ ס ");
INSERT INTO hbo_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","וֽ͏ַיְחִ֥י קֵינָ֖ן שִׁבְעִ֣ים שָׁנָ֑ה וַיֹּ֖ולֶד אֶת־מֽ͏ַהֲלַלְאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","וַיְחִ֣י קֵינָ֗ן אַחֲרֵי֙ הֹולִידֹ֣ו אֶת־מֽ͏ַהֲלַלְאֵ֔ל אַרְבָּעִ֣ים שָׁנָ֔ה וּשְׁמֹנֶ֥ה מֵאֹ֖ות שָׁנָ֑ה וַיֹּ֥ולֶד בָּנִ֖ים וּבָנֹֽות׃ ");
INSERT INTO hbo_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","וַיִּֽהְיוּ֙ כָּל־יְמֵ֣י קֵינָ֔ן עֶ֣שֶׂר שָׁנִ֔ים וּתְשַׁ֥ע מֵאֹ֖ות שָׁנָ֑ה וַיָּמֹֽת׃ ס ");
INSERT INTO hbo_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","וֽ͏ַיְחִ֣י מֽ͏ַהֲלַלְאֵ֔ל חָמֵ֥שׁ שָׁנִ֖ים וְשִׁשִּׁ֣ים שָׁנָ֑ה וַיֹּ֖ולֶד אֶת־יָֽרֶד׃ ");
INSERT INTO hbo_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","וֽ͏ַיְחִ֣י מֽ͏ַהֲלַלְאֵ֗ל אֽ͏ַחֲרֵי֙ הֹולִידֹ֣ו אֶת־יֶ֔רֶד שְׁלֹשִׁ֣ים שָׁנָ֔ה וּשְׁמֹנֶ֥ה מֵאֹ֖ות שָׁנָ֑ה וַיֹּ֥ולֶד בָּנִ֖ים וּבָנֹֽות׃ ");
INSERT INTO hbo_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","וַיִּהְיוּ֙ כָּל־יְמֵ֣י מַהֲלַלְאֵ֔ל חָמֵ֤שׁ וְתִשְׁעִים֙ שָׁנָ֔ה וּשְׁמֹנֶ֥ה מֵאֹ֖ות שָׁנָ֑ה וַיָּמֹֽת׃ ס ");
INSERT INTO hbo_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","וֽ͏ַיְחִי־יֶ֕רֶד שְׁתַּ֧יִם וְשִׁשִּׁ֛ים שָׁנָ֖ה וּמְאַ֣ת שָׁנָ֑ה וַיֹּ֖ולֶד אֶת־חֲנֹֽוךְ׃ ");
INSERT INTO hbo_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","וֽ͏ַיְחִי־יֶ֗רֶד אֽ͏ַחֲרֵי֙ הֹולִידֹ֣ו אֶת־חֲנֹ֔וךְ שְׁמֹנֶ֥ה מֵאֹ֖ות שָׁנָ֑ה וַיֹּ֥ולֶד בָּנִ֖ים וּבָנֹֽות׃ ");
INSERT INTO hbo_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","וַיִּֽהְיוּ֙ כָּל־יְמֵי־יֶ֔רֶד שְׁתַּ֤יִם וְשִׁשִּׁים֙ שָׁנָ֔ה וּתְשַׁ֥ע מֵאֹ֖ות שָׁנָ֑ה וַיָּמֹֽת׃ פ ");
INSERT INTO hbo_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","וֽ͏ַיְחִ֣י חֲנֹ֔וךְ חָמֵ֥שׁ וְשִׁשִּׁ֖ים שָׁנָ֑ה וַיֹּ֖ולֶד אֶת־מְתוּשָֽׁלַח׃ ");
INSERT INTO hbo_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","וַיִּתְהַלֵּ֨ךְ חֲנֹ֜וךְ אֶת־הֽ͏ָאֱלֹהִ֗ים אֽ͏ַחֲרֵי֙ הֹולִידֹ֣ו אֶת־מְתוּשֶׁ֔לַח שְׁלֹ֥שׁ מֵאֹ֖ות שָׁנָ֑ה וַיֹּ֥ולֶד בָּנִ֖ים וּבָנֹֽות׃ ");
INSERT INTO hbo_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","וַיְהִ֖י כָּל־יְמֵ֣י חֲנֹ֑וךְ חָמֵ֤שׁ וְשִׁשִּׁים֙ שָׁנָ֔ה וּשְׁלֹ֥שׁ מֵאֹ֖ות שָׁנָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","וַיִּתְהַלֵּ֥ךְ חֲנֹ֖וךְ אֶת־הֽ͏ָאֱלֹהִ֑ים וְאֵינֶ֕נּוּ כִּֽי־לָקַ֥ח אֹתֹ֖ו אֱלֹהִֽים׃ פ ");
INSERT INTO hbo_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","וַיְחִ֣י מְתוּשֶׁ֔לַח שֶׁ֧בַע וּשְׁמֹנִ֛ים שָׁנָ֖ה וּמְאַ֣ת שָׁנָ֑ה וַיֹּ֖ולֶד אֶת־לָֽמֶךְ׃ ");
INSERT INTO hbo_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","וֽ͏ַיְחִ֣י מְתוּשֶׁ֗לַח אֽ͏ַחֲרֵי֙ הֹולִידֹ֣ו אֶת־לֶ֔מֶךְ שְׁתַּ֤יִם וּשְׁמֹונִים֙ שָׁנָ֔ה וּשְׁבַ֥ע מֵאֹ֖ות שָׁנָ֑ה וַיֹּ֥ולֶד בָּנִ֖ים וּבָנֹֽות׃ ");
INSERT INTO hbo_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","וַיִּהְיוּ֙ כָּל־יְמֵ֣י מְתוּשֶׁ֔לַח תֵּ֤שַׁע וְשִׁשִּׁים֙ שָׁנָ֔ה וּתְשַׁ֥ע מֵאֹ֖ות שָׁנָ֑ה וַיָּמֹֽת׃ פ ");
INSERT INTO hbo_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","וֽ͏ַיְחִי־לֶ֕מֶךְ שְׁתַּ֧יִם וּשְׁמֹנִ֛ים שָׁנָ֖ה וּמְאַ֣ת שָׁנָ֑ה וַיֹּ֖ולֶד בֵּֽן׃ ");
INSERT INTO hbo_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","וַיִּקְרָ֧א אֶת־שְׁמֹ֛ו נֹ֖חַ לֵאמֹ֑ר זֶ֞֠ה יְנַחֲמֵ֤נוּ מִֽמַּעֲשֵׂ֙נוּ֙ וּמֵעִצְּבֹ֣ון יָדֵ֔ינוּ מִן־הָ֣אֲדָמָ֔ה אֲשֶׁ֥ר אֽ͏ֵרְרָ֖הּ יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","וֽ͏ַיְחִי־לֶ֗מֶךְ אֽ͏ַחֲרֵי֙ הֹולִידֹ֣ו אֶת־נֹ֔חַ חָמֵ֤שׁ וְתִשְׁעִים֙ שָׁנָ֔ה וַחֲמֵ֥שׁ מֵאֹ֖ת שָׁנָ֑ה וַיֹּ֥ולֶד בָּנִ֖ים וּבָנֹֽות׃ ");
INSERT INTO hbo_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","וֽ͏ַיְהִי֙ כָּל־יְמֵי־לֶ֔מֶךְ שֶׁ֤בַע וְשִׁבְעִים֙ שָׁנָ֔ה וּשְׁבַ֥ע מֵאֹ֖ות שָׁנָ֑ה וַיָּמֹֽת׃ ס ");
INSERT INTO hbo_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","וֽ͏ַיְהִי־נֹ֕חַ בֶּן־חֲמֵ֥שׁ מֵאֹ֖ות שָׁנָ֑ה וַיֹּ֣ולֶד נֹ֔חַ אֶת־שֵׁ֖ם אֶת־חָ֥ם וְאֶת־יָֽפֶת׃ ");
INSERT INTO hbo_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","וַֽיְהִי֙ כִּֽי־הֵחֵ֣ל הֽ͏ָאָדָ֔ם לָרֹ֖ב עַל־פְּנֵ֣י הֽ͏ָאֲדָמָ֑ה וּבָנֹ֖ות יֻלְּד֥וּ לָהֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","וַיִּרְא֤וּ בְנֵי־הָֽאֱלֹהִים֙ אֶת־בְּנֹ֣ות הָֽאָדָ֔ם כִּ֥י טֹבֹ֖ת הֵ֑נָּה וַיִּקְח֤וּ לָהֶם֙ נָשִׁ֔ים מִכֹּ֖ל אֲשֶׁ֥ר בָּחָֽרוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","וַיֹּ֣אמֶר יְהוָ֗ה לֹֽא־יָדֹ֨ון רוּחִ֤י בָֽאָדָם֙ לְעֹלָ֔ם בְּשַׁגַּ֖ם ה֣וּא בָשָׂ֑ר וְהָי֣וּ יָמָ֔יו מֵאָ֥ה וְעֶשְׂרִ֖ים שָׁנָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","הַנְּפִלִ֞ים הָי֣וּ בָאָרֶץ֮ בַּיָּמִ֣ים הָהֵם֒ וְגַ֣ם אַֽחֲרֵי־כֵ֗ן אֲשֶׁ֨ר יָבֹ֜אוּ בְּנֵ֤י הָֽאֱלֹהִים֙ אֶל־בְּנֹ֣ות הֽ͏ָאָדָ֔ם וְיָלְד֖וּ לָהֶ֑ם הֵ֧מָּה הַגִּבֹּרִ֛ים אֲשֶׁ֥ר מֵעֹולָ֖ם אַנְשֵׁ֥י הַשֵּֽׁם׃ פ ");
INSERT INTO hbo_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","וַיַּ֣רְא יְהוָ֔ה כִּ֥י רַבָּ֛ה רָעַ֥ת הָאָדָ֖ם בָּאָ֑רֶץ וְכָל־יֵ֙צֶר֙ מַחְשְׁבֹ֣ת לִבֹּ֔ו רַ֥ק רַ֖ע כָּל־הַיֹּֽום׃ ");
INSERT INTO hbo_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","וַיִּנָּ֣חֶם יְהוָ֔ה כִּֽי־עָשָׂ֥ה אֶת־הֽ͏ָאָדָ֖ם בָּאָ֑רֶץ וַיִּתְעַצֵּ֖ב אֶל־לִבֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","וַיֹּ֣אמֶר יְהוָ֗ה אֶמְחֶ֨ה אֶת־הָאָדָ֤ם אֲשֶׁר־בָּרָ֙אתִי֙ מֵעַל֙ פְּנֵ֣י הֽ͏ָאֲדָמָ֔ה מֽ͏ֵאָדָם֙ עַד־בְּהֵמָ֔ה עַד־רֶ֖מֶשׂ וְעַד־עֹ֣וף הַשָּׁמָ֑יִם כִּ֥י נִחַ֖מְתִּי כִּ֥י עֲשִׂיתִֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","וְנֹ֕חַ מָ֥צָא חֵ֖ן בְּעֵינֵ֥י יְהוָֽה׃ פ ");
INSERT INTO hbo_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","אֵ֚לֶּה תֹּולְדֹ֣ת נֹ֔חַ נֹ֗חַ אִ֥ישׁ צַדִּ֛יק תָּמִ֥ים הָיָ֖ה בְּדֹֽרֹתָ֑יו אֶת־הֽ͏ָאֱלֹהִ֖ים הִֽתְהַלֶּךְ־נֹֽחַ׃ ");
INSERT INTO hbo_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","וַיֹּ֥ולֶד נֹ֖חַ שְׁלֹשָׁ֣ה בָנִ֑ים אֶת־שֵׁ֖ם אֶת־חָ֥ם וְאֶת־יָֽפֶת׃ ");
INSERT INTO hbo_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","וַתִּשָּׁחֵ֥ת הָאָ֖רֶץ לִפְנֵ֣י הֽ͏ָאֱלֹהִ֑ים וַתִּמָּלֵ֥א הָאָ֖רֶץ חָמָֽס׃ ");
INSERT INTO hbo_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","וַיַּ֧רְא אֱלֹהִ֛ים אֶת־הָאָ֖רֶץ וְהִנֵּ֣ה נִשְׁחָ֑תָה כִּֽי־הִשְׁחִ֧ית כָּל־בָּשָׂ֛ר אֶת־דַּרְכֹּ֖ו עַל־הָאָֽרֶץ׃ ס ");
INSERT INTO hbo_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","וַיֹּ֨אמֶר אֱלֹהִ֜ים לְנֹ֗חַ קֵ֤ץ כָּל־בָּשָׂר֙ בָּ֣א לְפָנַ֔י כִּֽי־מָלְאָ֥ה הָאָ֛רֶץ חָמָ֖ס מִפְּנֵיהֶ֑ם וְהִנְנִ֥י מַשְׁחִיתָ֖ם אֶת־הָאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","עֲשֵׂ֤ה לְךָ֙ תֵּבַ֣ת עֲצֵי־גֹ֔פֶר קִנִּ֖ים תּֽ͏ַעֲשֶׂ֣ה אֶת־הַתֵּבָ֑ה וְכָֽפַרְתָּ֥ אֹתָ֛הּ מִבַּ֥יִת וּמִח֖וּץ בַּכֹּֽפֶר׃ ");
INSERT INTO hbo_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","וְזֶ֕ה אֲשֶׁ֥ר תַּֽעֲשֶׂ֖ה אֹתָ֑הּ שְׁלֹ֧שׁ מֵאֹ֣ות אַמָּ֗ה אֹ֚רֶךְ הַתֵּבָ֔ה חֲמִשִּׁ֤ים אַמָּה֙ רָחְבָּ֔הּ וּשְׁלֹשִׁ֥ים אַמָּ֖ה קֹומָתָֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","צֹ֣הַר ׀ תַּעֲשֶׂ֣ה לַתֵּבָ֗ה וְאֶל־אַמָּה֙ תְּכַלֶ֣נָּה מִלְמַ֔עְלָה וּפֶ֥תַח הַתֵּבָ֖ה בְּצִדָּ֣הּ תָּשִׂ֑ים תַּחְתִּיִּ֛ם שְׁנִיִּ֥ם וּשְׁלִשִׁ֖ים תּֽ͏ַעֲשֶֽׂהָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","וַאֲנִ֗י הִנְנִי֩ מֵבִ֨יא אֶת־הַמַּבּ֥וּל מַ֙יִם֙ עַל־הָאָ֔רֶץ לְשַׁחֵ֣ת כָּל־בָּשָׂ֗ר אֲשֶׁר־בֹּו֙ ר֣וּחַ חַיִּ֔ים מִתַּ֖חַת הַשָּׁמָ֑יִם כֹּ֥ל אֲשֶׁר־בָּאָ֖רֶץ יִגְוָֽע׃ ");
INSERT INTO hbo_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","וַהֲקִמֹתִ֥י אֶת־בְּרִיתִ֖י אִתָּ֑ךְ וּבָאתָ֙ אֶל־הַתֵּבָ֔ה אַתָּ֕ה וּבָנֶ֛יךָ וְאִשְׁתְּךָ֥ וּנְשֵֽׁי־בָנֶ֖יךָ אִתָּֽךְ׃ ");
INSERT INTO hbo_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","וּמִכָּל־הָ֠חַי מִֽכָּל־בָּשָׂ֞ר שְׁנַ֧יִם מִכֹּ֛ל תָּבִ֥יא אֶל־הַתֵּבָ֖ה לְהַחֲיֹ֣ת אִתָּ֑ךְ זָכָ֥ר וּנְקֵבָ֖ה יִֽהְיֽוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","מֵהָעֹ֣וף לְמִינֵ֗הוּ וּמִן־הַבְּהֵמָה֙ לְמִינָ֔הּ מִכֹּ֛ל רֶ֥מֶשׂ הֽ͏ָאֲדָמָ֖ה לְמִינֵ֑הוּ שְׁנַ֧יִם מִכֹּ֛ל יָבֹ֥אוּ אֵלֶ֖יךָ לְהֽ͏ַחֲיֹֽות׃ ");
INSERT INTO hbo_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","וְאַתָּ֣ה קַח־לְךָ֗ מִכָּל־מֽ͏ַאֲכָל֙ אֲשֶׁ֣ר יֽ͏ֵאָכֵ֔ל וְאָסַפְתָּ֖ אֵלֶ֑יךָ וְהָיָ֥ה לְךָ֛ וְלָהֶ֖ם לְאָכְלָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","וַיַּ֖עַשׂ נֹ֑חַ כְּ֠כֹל אֲשֶׁ֨ר צִוָּ֥ה אֹתֹ֛ו אֱלֹהִ֖ים כֵּ֥ן עָשָֽׂה׃ ס ");
INSERT INTO hbo_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","וַיֹּ֤אמֶר יְהוָה֙ לְנֹ֔חַ בֹּֽא־אַתָּ֥ה וְכָל־בֵּיתְךָ֖ אֶל־הַתֵּבָ֑ה כִּֽי־אֹתְךָ֥ רָאִ֛יתִי צַדִּ֥יק לְפָנַ֖י בַּדֹּ֥ור הַזֶּֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","מִכֹּ֣ל ׀ הַבְּהֵמָ֣ה הַטְּהֹורָ֗ה תִּֽקַּח־לְךָ֛ שִׁבְעָ֥ה שִׁבְעָ֖ה אִ֣ישׁ וְאִשְׁתֹּ֑ו וּמִן־הַבְּהֵמָ֡ה אֲ֠שֶׁר לֹ֣א טְהֹרָ֥ה הִ֛וא שְׁנַ֖יִם אִ֥ישׁ וְאִשְׁתֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","גַּ֣ם מֵעֹ֧וף הַשָּׁמַ֛יִם שִׁבְעָ֥ה שִׁבְעָ֖ה זָכָ֣ר וּנְקֵבָ֑ה לְחַיֹּ֥ות זֶ֖רַע עַל־פְּנֵ֥י כָל־הָאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","כִּי֩ לְיָמִ֨ים עֹ֜וד שִׁבְעָ֗ה אָֽנֹכִי֙ מַמְטִ֣יר עַל־הָאָ֔רֶץ אַרְבָּעִ֣ים יֹ֔ום וְאַרְבָּעִ֖ים לָ֑יְלָה וּמָחִ֗יתִי אֶֽת־כָּל־הַיְקוּם֙ אֲשֶׁ֣ר עָשִׂ֔יתִי מֵעַ֖ל פְּנֵ֥י הֽ͏ָאֲדָמָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","וַיַּ֖עַשׂ נֹ֑חַ כְּכֹ֥ל אֲשֶׁר־צִוָּ֖הוּ יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","וְנֹ֕חַ בֶּן־שֵׁ֥שׁ מֵאֹ֖ות שָׁנָ֑ה וְהַמַּבּ֣וּל הָיָ֔ה מַ֖יִם עַל־הָאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","וַיָּ֣בֹא נֹ֗חַ וּ֠בָנָיו וְאִשְׁתֹּ֧ו וּנְשֵֽׁי־בָנָ֛יו אִתֹּ֖ו אֶל־הַתֵּבָ֑ה מִפְּנֵ֖י מֵ֥י הַמַּבּֽוּל׃ ");
INSERT INTO hbo_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","מִן־הַבְּהֵמָה֙ הַטְּהֹורָ֔ה וּמִן־הַ֨בְּהֵמָ֔ה אֲשֶׁ֥ר אֵינֶ֖נָּה טְהֹרָ֑ה וּמִ֨ן־הָעֹ֔וף וְכֹ֥ל אֲשֶׁר־רֹמֵ֖שׂ עַל־הָֽאֲדָמָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","שְׁנַ֨יִם שְׁנַ֜יִם בָּ֧אוּ אֶל־נֹ֛חַ אֶל־הַתֵּבָ֖ה זָכָ֣ר וּנְקֵבָ֑ה כּֽ͏ַאֲשֶׁ֛ר צִוָּ֥ה אֱלֹהִ֖ים אֶת־נֹֽחַ׃ ");
INSERT INTO hbo_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","וֽ͏ַיְהִ֖י לְשִׁבְעַ֣ת הַיָּמִ֑ים וּמֵ֣י הַמַּבּ֔וּל הָי֖וּ עַל־הָאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","בִּשְׁנַ֨ת שֵׁשׁ־מֵאֹ֤ות שָׁנָה֙ לְחַיֵּי־נֹ֔חַ בַּחֹ֙דֶשׁ֙ הַשֵּׁנִ֔י בְּשִׁבְעָֽה־עָשָׂ֥ר יֹ֖ום לַחֹ֑דֶשׁ בַּיֹּ֣ום הַזֶּ֗ה נִבְקְעוּ֙ כָּֽל־מַעְיְנֹת֙ תְּהֹ֣ום רַבָּ֔ה וַאֲרֻבֹּ֥ת הַשָּׁמַ֖יִם נִפְתָּֽחוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","וֽ͏ַיְהִ֥י הַגֶּ֖שֶׁם עַל־הָאָ֑רֶץ אַרְבָּעִ֣ים יֹ֔ום וְאַרְבָּעִ֖ים לָֽיְלָה׃ ");
INSERT INTO hbo_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","בְּעֶ֨צֶם הַיֹּ֤ום הַזֶּה֙ בָּ֣א נֹ֔חַ וְשֵׁם־וְחָ֥ם וָיֶ֖פֶת בְּנֵי־נֹ֑חַ וְאֵ֣שֶׁת נֹ֗חַ וּשְׁלֹ֧שֶׁת נְשֵֽׁי־בָנָ֛יו אִתָּ֖ם אֶל־הַתֵּבָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","הֵ֜מָּה וְכָל־הֽ͏ַחַיָּ֣ה לְמִינָ֗הּ וְכָל־הַבְּהֵמָה֙ לְמִינָ֔הּ וְכָל־הָרֶ֛מֶשׂ הָרֹמֵ֥שׂ עַל־הָאָ֖רֶץ לְמִינֵ֑הוּ וְכָל־הָעֹ֣וף לְמִינֵ֔הוּ כֹּ֖ל צִפֹּ֥ור כָּל־כָּנָֽף׃ ");
INSERT INTO hbo_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","וַיָּבֹ֥אוּ אֶל־נֹ֖חַ אֶל־הַתֵּבָ֑ה שְׁנַ֤יִם שְׁנַ֙יִם֙ מִכָּל־הַבָּשָׂ֔ר אֲשֶׁר־בֹּ֖ו ר֥וּחַ חַיִּֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","וְהַבָּאִ֗ים זָכָ֨ר וּנְקֵבָ֤ה מִכָּל־בָּשָׂר֙ בָּ֔אוּ כּֽ͏ַאֲשֶׁ֛ר צִוָּ֥ה אֹתֹ֖ו אֱלֹהִ֑ים וַיִּסְגֹּ֥ר יְהוָ֖ה בּֽ͏ַעֲדֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","וֽ͏ַיְהִ֧י הַמַּבּ֛וּל אַרְבָּעִ֥ים יֹ֖ום עַל־הָאָ֑רֶץ וַיִּרְבּ֣וּ הַמַּ֗יִם וַיִּשְׂאוּ֙ אֶת־הַתֵּבָ֔ה וַתָּ֖רָם מֵעַ֥ל הָאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","וַיִּגְבְּר֥וּ הַמַּ֛יִם וַיִּרְבּ֥וּ מְאֹ֖ד עַל־הָאָ֑רֶץ וַתֵּ֥לֶךְ הַתֵּבָ֖ה עַל־פְּנֵ֥י הַמָּֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","וְהַמַּ֗יִם גָּ֥בְר֛וּ מְאֹ֥ד מְאֹ֖ד עַל־הָאָ֑רֶץ וַיְכֻסּ֗וּ כָּל־הֽ͏ֶהָרִים֙ הַגְּבֹהִ֔ים אֲשֶׁר־תַּ֖חַת כָּל־הַשָּׁמָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","חֲמֵ֨שׁ עֶשְׂרֵ֤ה אַמָּה֙ מִלְמַ֔עְלָה גָּבְר֖וּ הַמָּ֑יִם וַיְכֻסּ֖וּ הֶהָרִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","וַיִּגְוַ֞ע כָּל־בָּשָׂ֣ר ׀ הָרֹמֵ֣שׂ עַל־הָאָ֗רֶץ בָּעֹ֤וף וּבַבְּהֵמָה֙ וּבַ֣חַיָּ֔ה וּבְכָל־הַשֶּׁ֖רֶץ הַשֹּׁרֵ֣ץ עַל־הָאָ֑רֶץ וְכֹ֖ל הָאָדָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","כֹּ֡ל אֲשֶׁר֩ נִשְׁמַת־ר֨וּחַ חַיִּ֜ים בְּאַפָּ֗יו מִכֹּ֛ל אֲשֶׁ֥ר בֶּחָֽרָבָ֖ה מֵֽתוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","וַיִּ֜מַח אֶֽת־כָּל־הַיְק֣וּם ׀ אֲשֶׁ֣ר ׀ עַל־פְּנֵ֣י הֽ͏ָאֲדָמָ֗ה מֵאָדָ֤ם עַד־בְּהֵמָה֙ עַד־רֶ֙מֶשׂ֙ וְעַד־עֹ֣וף הַשָּׁמַ֔יִם וַיִּמָּח֖וּ מִן־הָאָ֑רֶץ וַיִשָּׁ֧אֶר אַךְ־נֹ֛חַ וֽ͏ַאֲשֶׁ֥ר אִתֹּ֖ו בַּתֵּבָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","וַיִּגְבְּר֥וּ הַמַּ֖יִם עַל־הָאָ֑רֶץ חֲמִשִּׁ֥ים וּמְאַ֖ת יֹֽום׃ ");
INSERT INTO hbo_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","וַיִּזְכֹּ֤ר אֱלֹהִים֙ אֶת־נֹ֔חַ וְאֵ֤ת כָּל־הֽ͏ַחַיָּה֙ וְאֶת־כָּל־הַבְּהֵמָ֔ה אֲשֶׁ֥ר אִתֹּ֖ו בַּתֵּבָ֑ה וַיַּעֲבֵ֨ר אֱלֹהִ֥ים ר֙וּחַ֙ עַל־הָאָ֔רֶץ וַיָּשֹׁ֖כּוּ הַמָּֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","וַיִּסָּֽכְרוּ֙ מַעְיְנֹ֣ת תְּהֹ֔ום וֽ͏ַאֲרֻבֹּ֖ת הַשָּׁמָ֑יִם וַיִּכָּלֵ֥א הַגֶּ֖שֶׁם מִן־הַשָּׁמָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","וַיָּשֻׁ֧בוּ הַמַּ֛יִם מֵעַ֥ל הָאָ֖רֶץ הָלֹ֣וךְ וָשֹׁ֑וב וַיַּחְסְר֣וּ הַמַּ֔יִם מִקְצֵ֕ה חֲמִשִּׁ֥ים וּמְאַ֖ת יֹֽום׃ ");
INSERT INTO hbo_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","וַתָּ֤נַח הַתֵּבָה֙ בַּחֹ֣דֶשׁ הַשְּׁבִיעִ֔י בְּשִׁבְעָה־עָשָׂ֥ר יֹ֖ום לַחֹ֑דֶשׁ עַ֖ל הָרֵ֥י אֲרָרָֽט׃ ");
INSERT INTO hbo_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","וְהַמַּ֗יִם הָיוּ֙ הָלֹ֣וךְ וְחָסֹ֔ור עַ֖ד הַחֹ֣דֶשׁ הֽ͏ָעֲשִׂירִ֑י בּֽ͏ָעֲשִׂירִי֙ בְּאֶחָ֣ד לַחֹ֔דֶשׁ נִרְא֖וּ רָאשֵׁ֥י הֽ͏ֶהָרִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","וֽ͏ַיְהִ֕י מִקֵּ֖ץ אַרְבָּעִ֣ים יֹ֑ום וַיִּפְתַּ֣ח נֹ֔חַ אֶת־חַלֹּ֥ון הַתֵּבָ֖ה אֲשֶׁ֥ר עָשָֽׂה׃ ");
INSERT INTO hbo_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","וַיְשַׁלַּ֖ח אֶת־הֽ͏ָעֹרֵ֑ב וַיֵּצֵ֤א יָצֹוא֙ וָשֹׁ֔וב עַד־יְבֹ֥שֶׁת הַמַּ֖יִם מֵעַ֥ל הָאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","וַיְשַׁלַּ֥ח אֶת־הַיֹּונָ֖ה מֵאִתֹּ֑ו לִרְאֹות֙ הֲקַ֣לּוּ הַמַּ֔יִם מֵעַ֖ל פְּנֵ֥י הֽ͏ָאֲדָמָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","וְלֹֽא־מָצְאָה֩ הַיֹּונָ֨ה מָנֹ֜וחַ לְכַף־רַגְלָ֗הּ וַתָּ֤שָׁב אֵלָיו֙ אֶל־הַתֵּבָ֔ה כִּי־מַ֖יִם עַל־פְּנֵ֣י כָל־הָאָ֑רֶץ וַיִּשְׁלַ֤ח יָדֹו֙ וַיִּקָּחֶ֔הָ וַיָּבֵ֥א אֹתָ֛הּ אֵלָ֖יו אֶל־הַתֵּבָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","וַיָּ֣חֶל עֹ֔וד שִׁבְעַ֥ת יָמִ֖ים אֲחֵרִ֑ים וַיֹּ֛סֶף שַׁלַּ֥ח אֶת־הַיֹּונָ֖ה מִן־הַתֵּבָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","וַתָּבֹ֨א אֵלָ֤יו הַיֹּונָה֙ לְעֵ֣ת עֶ֔רֶב וְהִנֵּ֥ה עֲלֵה־זַ֖יִת טָרָ֣ף בְּפִ֑יהָ וַיֵּ֣דַע נֹ֔חַ כִּי־קַ֥לּוּ הַמַּ֖יִם מֵעַ֥ל הָאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","וַיִּיָּ֣חֶל עֹ֔וד שִׁבְעַ֥ת יָמִ֖ים אֲחֵרִ֑ים וַיְשַׁלַּח֙ אֶת־הַיֹּונָ֔ה וְלֹֽא־יָסְפָ֥ה שׁוּב־אֵלָ֖יו עֹֽוד׃ ");
INSERT INTO hbo_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","וֽ͏ַ֠יְהִי בְּאַחַ֨ת וְשֵׁשׁ־מֵאֹ֜ות שָׁנָ֗ה בּֽ͏ָרִאשֹׁון֙ בְּאֶחָ֣ד לַחֹ֔דֶשׁ חָֽרְב֥וּ הַמַּ֖יִם מֵעַ֣ל הָאָ֑רֶץ וַיָּ֤סַר נֹ֙חַ֙ אֶת־מִכְסֵ֣ה הַתֵּבָ֔ה וַיַּ֕רְא וְהִנֵּ֥ה חֽ͏ָרְב֖וּ פְּנֵ֥י הֽ͏ָאֲדָמָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","וּבַחֹ֙דֶשׁ֙ הַשֵּׁנִ֔י בְּשִׁבְעָ֧ה וְעֶשְׂרִ֛ים יֹ֖ום לַחֹ֑דֶשׁ יָבְשָׁ֖ה הָאָֽרֶץ׃ ס ");
INSERT INTO hbo_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","וַיְדַבֵּ֥ר אֱלֹהִ֖ים אֶל־נֹ֥חַ לֵאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","צֵ֖א מִן־הַתֵּבָ֑ה אַתָּ֕ה וְאִשְׁתְּךָ֛ וּבָנֶ֥יךָ וּנְשֵֽׁי־בָנֶ֖יךָ אִתָּֽךְ׃ ");
INSERT INTO hbo_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","כָּל־הַחַיָּ֨ה אֲשֶֽׁר־אִתְּךָ֜ מִכָּל־בָּשָׂ֗ר בָּעֹ֧וף וּבַבְּהֵמָ֛ה וּבְכָל־הָרֶ֛מֶשׂ הָרֹמֵ֥שׂ עַל־הָאָ֖רֶץ *הֹוצֵא (הַיְצֵ֣א) אִתָּ֑ךְ וְשֽׁ͏ָרְצ֣וּ בָאָ֔רֶץ וּפָר֥וּ וְרָב֖וּ עַל־הָאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","וַיֵּ֖צֵא־נֹ֑חַ וּבָנָ֛יו וְאִשְׁתֹּ֥ו וּנְשֵֽׁי־בָנָ֖יו אִתֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","כָּל־הֽ͏ַחַיָּ֗ה כָּל־הָרֶ֙מֶשׂ֙ וְכָל־הָעֹ֔וף כֹּ֖ל רֹומֵ֣שׂ עַל־הָאָ֑רֶץ לְמִשְׁפְּחֹ֣תֵיהֶ֔ם יָצְא֖וּ מִן־הַתֵּבָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","וַיִּ֥בֶן נֹ֛חַ מִזְבֵּ֖חַ לֽ͏ַיהוָ֑ה וַיִּקַּ֞ח מִכֹּ֣ל ׀ הַבְּהֵמָ֣ה הַטְּהֹורָ֗ה וּמִכֹּל֙ הָעֹ֣וף הַטָּהֹ֔ר וַיַּ֥עַל עֹלֹ֖ת בַּמִּזְבֵּֽחַ׃ ");
INSERT INTO hbo_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","וַיָּ֣רַח יְהוָה֮ אֶת־רֵ֣יחַ הַנִּיחֹחַ֒ וַיֹּ֨אמֶר יְהוָ֜ה אֶל־לִבֹּ֗ו לֹֽא־אֹ֠סִף לְקַלֵּ֨ל עֹ֤וד אֶת־הָֽאֲדָמָה֙ בַּעֲב֣וּר הֽ͏ָאָדָ֔ם כִּ֠י יֵ֣צֶר לֵ֧ב הָאָדָ֛ם רַ֖ע מִנְּעֻרָ֑יו וְלֹֽא־אֹסִ֥ף עֹ֛וד לְהַכֹּ֥ות אֶת־כָּל־חַ֖י כּֽ͏ַאֲשֶׁ֥ר עָשִֽׂיתִי׃ ");
INSERT INTO hbo_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","עֹ֖ד כָּל־יְמֵ֣י הָאָ֑רֶץ זֶ֡רַע וְ֠קָצִיר וְקֹ֨ר וָחֹ֜ם וְקַ֧יִץ וָחֹ֛רֶף וְיֹ֥ום וָלַ֖יְלָה לֹ֥א יִשְׁבֹּֽתוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","וַיְבָ֣רֶךְ אֱלֹהִ֔ים אֶת־נֹ֖חַ וְאֶת־בָּנָ֑יו וַיֹּ֧אמֶר לָהֶ֛ם פְּר֥וּ וּרְב֖וּ וּמִלְא֥וּ אֶת־הָאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","וּמֹורַאֲכֶ֤ם וְחִתְּכֶם֙ יִֽהְיֶ֔ה עַ֚ל כָּל־חַיַּ֣ת הָאָ֔רֶץ וְעַ֖ל כָּל־עֹ֣וף הַשָּׁמָ֑יִם בְּכֹל֩ אֲשֶׁ֨ר תִּרְמֹ֧שׂ הֽ͏ָאֲדָמָ֛ה וּֽבְכָל־דְּגֵ֥י הַיָּ֖ם בְּיֶדְכֶ֥ם נִתָּֽנוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","כָּל־רֶ֙מֶשׂ֙ אֲשֶׁ֣ר הוּא־חַ֔י לָכֶ֥ם יִהְיֶ֖ה לְאָכְלָ֑ה כְּיֶ֣רֶק עֵ֔שֶׂב נָתַ֥תִּי לָכֶ֖ם אֶת־כֹּֽל׃ ");
INSERT INTO hbo_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","אַךְ־בָּשָׂ֕ר בְּנַפְשֹׁ֥ו דָמֹ֖ו לֹ֥א תֹאכֵֽלוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","וְאַ֨ךְ אֶת־דִּמְכֶ֤ם לְנַפְשֹֽׁתֵיכֶם֙ אֶדְרֹ֔שׁ מִיַּ֥ד כָּל־חַיָּ֖ה אֶדְרְשֶׁ֑נּוּ וּמִיַּ֣ד הֽ͏ָאָדָ֗ם מִיַּד֙ אִ֣ישׁ אָחִ֔יו אֶדְרֹ֖שׁ אֶת־נֶ֥פֶשׁ הֽ͏ָאָדָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","שֹׁפֵךְ֙ דַּ֣ם הֽ͏ָאָדָ֔ם בּֽ͏ָאָדָ֖ם דָּמֹ֣ו יִשָּׁפֵ֑ךְ כִּ֚י בְּצֶ֣לֶם אֱלֹהִ֔ים עָשָׂ֖ה אֶת־הָאָדָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","וְאַתֶּ֖ם פְּר֣וּ וּרְב֑וּ שִׁרְצ֥וּ בָאָ֖רֶץ וּרְבוּ־בָֽהּ׃ ס ");
INSERT INTO hbo_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","וַיֹּ֤אמֶר אֱלֹהִים֙ אֶל־נֹ֔חַ וְאֶל־בָּנָ֥יו אִתֹּ֖ו לֵאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","וַאֲנִ֕י הִנְנִ֥י מֵקִ֛ים אֶת־בְּרִיתִ֖י אִתְּכֶ֑ם וְאֶֽת־זַרְעֲכֶ֖ם אֽ͏ַחֲרֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","וְאֵ֨ת כָּל־נֶ֤פֶשׁ הֽ͏ַחַיָּה֙ אֲשֶׁ֣ר אִתְּכֶ֔ם בָּעֹ֧וף בַּבְּהֵמָ֛ה וּֽבְכָל־חַיַּ֥ת הָאָ֖רֶץ אִתְּכֶ֑ם מִכֹּל֙ יֹצְאֵ֣י הַתֵּבָ֔ה לְכֹ֖ל חַיַּ֥ת הָאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","וַהֲקִמֹתִ֤י אֶת־בְּרִיתִי֙ אִתְּכֶ֔ם וְלֹֽא־יִכָּרֵ֧ת כָּל־בָּשָׂ֛ר עֹ֖וד מִמֵּ֣י הַמַּבּ֑וּל וְלֹֽא־יִהְיֶ֥ה עֹ֛וד מַבּ֖וּל לְשַׁחֵ֥ת הָאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","וַיֹּ֣אמֶר אֱלֹהִ֗ים זֹ֤את אֹֽות־הַבְּרִית֙ אֲשֶׁר־אֲנִ֣י נֹתֵ֗ן בֵּינִי֙ וּבֵ֣ינֵיכֶ֔ם וּבֵ֛ין כָּל־נֶ֥פֶשׁ חַיָּ֖ה אֲשֶׁ֣ר אִתְּכֶ֑ם לְדֹרֹ֖ת עֹולָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","אֶת־קַשְׁתִּ֕י נָתַ֖תִּי בֶּֽעָנָ֑ן וְהָֽיְתָה֙ לְאֹ֣ות בְּרִ֔ית בֵּינִ֖י וּבֵ֥ין הָאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","וְהָיָ֕ה בְּעֽ͏ַנְנִ֥י עָנָ֖ן עַל־הָאָ֑רֶץ וְנִרְאֲתָ֥ה הַקֶּ֖שֶׁת בֶּעָנָֽן׃ ");
INSERT INTO hbo_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","וְזָכַרְתִּ֣י אֶת־בְּרִיתִ֗י אֲשֶׁ֤ר בֵּינִי֙ וּבֵ֣ינֵיכֶ֔ם וּבֵ֛ין כָּל־נֶ֥פֶשׁ חַיָּ֖ה בְּכָל־בָּשָׂ֑ר וְלֹֽא־יִֽהְיֶ֨ה עֹ֤וד הַמַּ֙יִם֙ לְמַבּ֔וּל לְשַׁחֵ֖ת כָּל־בָּשָֽׂר׃ ");
INSERT INTO hbo_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","וְהָיְתָ֥ה הַקֶּ֖שֶׁת בֶּֽעָנָ֑ן וּרְאִיתִ֗יהָ לִזְכֹּר֙ בְּרִ֣ית עֹולָ֔ם בֵּ֣ין אֱלֹהִ֔ים וּבֵין֙ כָּל־נֶ֣פֶשׁ חַיָּ֔ה בְּכָל־בָּשָׂ֖ר אֲשֶׁ֥ר עַל־הָאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","וַיֹּ֥אמֶר אֱלֹהִ֖ים אֶל־נֹ֑חַ זֹ֤את אֹֽות־הַבְּרִית֙ אֲשֶׁ֣ר הֲקִמֹ֔תִי בֵּינִ֕י וּבֵ֥ין כָּל־בָּשָׂ֖ר אֲשֶׁ֥ר עַל־הָאָֽרֶץ׃ פ ");
INSERT INTO hbo_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","וַיִּֽהְי֣וּ בְנֵי־נֹ֗חַ הַיֹּֽצְאִים֙ מִן־הַתֵּבָ֔ה שֵׁ֖ם וְחָ֣ם וָיָ֑פֶת וְחָ֕ם ה֖וּא אֲבִ֥י כְנָֽעַן׃ ");
INSERT INTO hbo_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","שְׁלֹשָׁ֥ה אֵ֖לֶּה בְּנֵי־נֹ֑חַ וּמֵאֵ֖לֶּה נָֽפְצָ֥ה כָל־הָאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","וַיָּ֥חֶל נֹ֖חַ אִ֣ישׁ הֽ͏ָאֲדָמָ֑ה וַיִּטַּ֖ע כָּֽרֶם׃ ");
INSERT INTO hbo_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","וַיֵּ֥שְׁתְּ מִן־הַיַּ֖יִן וַיִּשְׁכָּ֑ר וַיִּתְגַּ֖ל בְּתֹ֥וךְ אָהֳלֹֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","וַיַּ֗רְא חָ֚ם אֲבִ֣י כְנַ֔עַן אֵ֖ת עֶרְוַ֣ת אָבִ֑יו וַיַּגֵּ֥ד לִשְׁנֵֽי־אֶחָ֖יו בַּחֽוּץ׃ ");
INSERT INTO hbo_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","וַיִּקַּח֩ שֵׁ֨ם וָיֶ֜פֶת אֶת־הַשִּׂמְלָ֗ה וַיָּשִׂ֙ימוּ֙ עַל־שְׁכֶ֣ם שְׁנֵיהֶ֔ם וַיֵּֽלְכוּ֙ אֲחֹ֣רַנִּ֔ית וַיְכַסּ֕וּ אֵ֖ת עֶרְוַ֣ת אֲבִיהֶ֑ם וּפְנֵיהֶם֙ אֲחֹ֣רַנִּ֔ית וְעֶרְוַ֥ת אֲבִיהֶ֖ם לֹ֥א רָאֽוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","וַיִּ֥יקֶץ נֹ֖חַ מִיֵּינֹ֑ו וַיֵּ֕דַע אֵ֛ת אֲשֶׁר־עָ֥שָׂה־לֹ֖ו בְּנֹ֥ו הַקָּטָֽן׃ ");
INSERT INTO hbo_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","וַיֹּ֖אמֶר אָר֣וּר כְּנָ֑עַן עֶ֥בֶד עֲבָדִ֖ים יִֽהְיֶ֥ה לְאֶחָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","וַיֹּ֕אמֶר בָּר֥וּךְ יְהֹוָ֖ה אֱלֹ֣הֵי שֵׁ֑ם וִיהִ֥י כְנַ֖עַן עֶ֥בֶד לָֽמֹו׃ ");
INSERT INTO hbo_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","יַ֤פְתְּ אֱלֹהִים֙ לְיֶ֔פֶת וְיִשְׁכֹּ֖ן בְּאָֽהֳלֵי־שֵׁ֑ם וִיהִ֥י כְנַ֖עַן עֶ֥בֶד לָֽמֹו׃ ");
INSERT INTO hbo_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","וֽ͏ַיְחִי־נֹ֖חַ אַחַ֣ר הַמַּבּ֑וּל שְׁלֹ֤שׁ מֵאֹות֙ שָׁנָ֔ה וֽ͏ַחֲמִשִּׁ֖ים שָׁנָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","וַיִּֽהְיוּ֙ כָּל־יְמֵי־נֹ֔חַ תְּשַׁ֤ע מֵאֹות֙ שָׁנָ֔ה וַחֲמִשִּׁ֖ים שָׁנָ֑ה וַיָּמֹֽת׃ פ ");
INSERT INTO hbo_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","וְאֵ֙לֶּה֙ תֹּולְדֹ֣ת בְּנֵי־נֹ֔חַ שֵׁ֖ם חָ֣ם וָיָ֑פֶת וַיִּוָּלְד֥וּ לָהֶ֛ם בָּנִ֖ים אַחַ֥ר הַמַּבּֽוּל׃ ");
INSERT INTO hbo_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","בְּנֵ֣י יֶ֔פֶת גֹּ֣מֶר וּמָגֹ֔וג וּמָדַ֖י וְיָוָ֣ן וְתֻבָ֑ל וּמֶ֖שֶׁךְ וְתִירָֽס׃ ");
INSERT INTO hbo_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","וּבְנֵ֖י גֹּ֑מֶר אַשְׁכֲּנַ֥ז וְרִיפַ֖ת וְתֹגַרְמָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","וּבְנֵ֥י יָוָ֖ן אֱלִישָׁ֣ה וְתַרְשִׁ֑ישׁ כִּתִּ֖ים וְדֹדָנִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","מֵ֠אֵלֶּה נִפְרְד֞וּ אִיֵּ֤י הַגֹּויִם֙ בְּאַרְצֹתָ֔ם אִ֖ישׁ לִלְשֹׁנֹ֑ו לְמִשְׁפְּחֹתָ֖ם בְּגֹויֵהֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","וּבְנֵ֖י חָ֑ם כּ֥וּשׁ וּמִצְרַ֖יִם וּפ֥וּט וּכְנָֽעַן׃ ");
INSERT INTO hbo_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","וּבְנֵ֣י כ֔וּשׁ סְבָא֙ וֽ͏ַחֲוִילָ֔ה וְסַבְתָּ֥ה וְרַעְמָ֖ה וְסַבְתְּכָ֑א וּבְנֵ֥י רַעְמָ֖ה שְׁבָ֥א וּדְדָֽן׃ ");
INSERT INTO hbo_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","וְכ֖וּשׁ יָלַ֣ד אֶת־נִמְרֹ֑ד ה֣וּא הֵחֵ֔ל לֽ͏ִהְיֹ֥ות גִּבֹּ֖ר בָּאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","הֽוּא־הָיָ֥ה גִבֹּֽר־צַ֖יִד לִפְנֵ֣י יְהוָ֑ה עַל־כֵּן֙ יֵֽאָמַ֔ר כְּנִמְרֹ֛ד גִּבֹּ֥ור צַ֖יִד לִפְנֵ֥י יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","וַתְּהִ֨י רֵאשִׁ֤ית מַמְלַכְתֹּו֙ בָּבֶ֔ל וְאֶ֖רֶךְ וְאַכַּ֣ד וְכַלְנֵ֑ה בְּאֶ֖רֶץ שִׁנְעָֽר׃ ");
INSERT INTO hbo_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","מִן־הָאָ֥רֶץ הַהִ֖וא יָצָ֣א אַשּׁ֑וּר וַיִּ֙בֶן֙ אֶת־נִ֣ינְוֵ֔ה וְאֶת־רְחֹבֹ֥ת עִ֖יר וְאֶת־כָּֽלַח׃ ");
INSERT INTO hbo_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","וְֽאֶת־רֶ֔סֶן בֵּ֥ין נִֽינְוֵ֖ה וּבֵ֣ין כָּ֑לַח הִ֖וא הָעִ֥יר הַגְּדֹלָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","וּמִצְרַ֡יִם יָלַ֞ד אֶת־לוּדִ֧ים וְאֶת־עֲנָמִ֛ים וְאֶת־לְהָבִ֖ים וְאֶת־נַפְתֻּחִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","וְֽאֶת־פַּתְרֻסִ֞ים וְאֶת־כַּסְלֻחִ֗ים אֲשֶׁ֨ר יָצְא֥וּ מִשָּׁ֛ם פְּלִשְׁתִּ֖ים וְאֶת־כַּפְתֹּרִֽים׃ ס ");
INSERT INTO hbo_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","וּכְנַ֗עַן יָלַ֛ד אֶת־צִידֹ֥ן בְּכֹרֹ֖ו וְאֶת־חֵֽת׃ ");
INSERT INTO hbo_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","וְאֶת־הַיְבוּסִי֙ וְאֶת־הָ֣אֱמֹרִ֔י וְאֵ֖ת הַגִּרְגָּשִֽׁי׃ ");
INSERT INTO hbo_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","וְאֶת־הֽ͏ַחִוִּ֥י וְאֶת־הֽ͏ַעַרְקִ֖י וְאֶת־הַסִּינִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","וְאֶת־הֽ͏ָאַרְוָדִ֥י וְאֶת־הַצְּמָרִ֖י וְאֶת־הֽ͏ַחֲמָתִ֑י וְאַחַ֣ר נָפֹ֔צוּ מִשְׁפְּחֹ֖ות הֽ͏ַכְּנַעֲנִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","וֽ͏ַיְהִ֞י גְּב֤וּל הֽ͏ַכְּנַעֲנִי֙ מִצִּידֹ֔ן בֹּאֲכָ֥ה גְרָ֖רָה עַד־עַזָּ֑ה בֹּאֲכָ֞ה סְדֹ֧מָה וַעֲמֹרָ֛ה וְאַדְמָ֥ה וּצְבֹיִ֖ם עַד־לָֽשַׁע׃ ");
INSERT INTO hbo_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","אֵ֣לֶּה בְנֵי־חָ֔ם לְמִשְׁפְּחֹתָ֖ם לִלְשֹֽׁנֹתָ֑ם בְּאַרְצֹתָ֖ם בְּגֹויֵהֶֽם׃ ס ");
INSERT INTO hbo_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","וּלְשֵׁ֥ם יֻלַּ֖ד גַּם־ה֑וּא אֲבִי֙ כָּל־בְּנֵי־עֵ֔בֶר אֲחִ֖י יֶ֥פֶת הַגָּדֹֽול׃ ");
INSERT INTO hbo_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","בְּנֵ֥י שֵׁ֖ם עֵילָ֣ם וְאַשּׁ֑וּר וְאַרְפַּכְשַׁ֖ד וְל֥וּד וֽ͏ַאֲרָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","וּבְנֵ֖י אֲרָ֑ם ע֥וּץ וְח֖וּל וְגֶ֥תֶר וָמַֽשׁ׃ ");
INSERT INTO hbo_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","וְאַרְפַּכְשַׁ֖ד יָלַ֣ד אֶת־שָׁ֑לַח וְשֶׁ֖לַח יָלַ֥ד אֶת־עֵֽבֶר׃ ");
INSERT INTO hbo_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","וּלְעֵ֥בֶר יֻלַּ֖ד שְׁנֵ֣י בָנִ֑ים שֵׁ֣ם הֽ͏ָאֶחָ֞ד פֶּ֗לֶג כִּ֤י בְיָמָיו֙ נִפְלְגָ֣ה הָאָ֔רֶץ וְשֵׁ֥ם אָחִ֖יו יָקְטָֽן׃ ");
INSERT INTO hbo_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","וְיָקְטָ֣ן יָלַ֔ד אֶת־אַלְמֹודָ֖ד וְאֶת־שָׁ֑לֶף וְאֶת־חֲצַרְמָ֖וֶת וְאֶת־יָֽרַח׃ ");
INSERT INTO hbo_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","וְאֶת־הֲדֹורָ֥ם וְאֶת־אוּזָ֖ל וְאֶת־דִּקְלָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","וְאֶת־עֹובָ֥ל וְאֶת־אֲבִֽימָאֵ֖ל וְאֶת־שְׁבָֽא׃ ");
INSERT INTO hbo_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","וְאֶת־אֹופִ֥ר וְאֶת־חֲוִילָ֖ה וְאֶת־יֹובָ֑ב כָּל־אֵ֖לֶּה בְּנֵ֥י יָקְטָֽן׃ ");
INSERT INTO hbo_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","וֽ͏ַיְהִ֥י מֹושָׁבָ֖ם מִמֵּשָׁ֑א בֹּאֲכָ֥ה סְפָ֖רָה הַ֥ר הַקֶּֽדֶם׃ ");
INSERT INTO hbo_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","אֵ֣לֶּה בְנֵי־שֵׁ֔ם לְמִשְׁפְּחֹתָ֖ם לִלְשֹׁנֹתָ֑ם בְּאַרְצֹתָ֖ם לְגֹויֵהֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","אֵ֣לֶּה מִשְׁפְּחֹ֧ת בְּנֵי־נֹ֛חַ לְתֹולְדֹתָ֖ם בְּגֹויֵהֶ֑ם וּמֵאֵ֜לֶּה נִפְרְד֧וּ הַגֹּויִ֛ם בָּאָ֖רֶץ אַחַ֥ר הַמַּבּֽוּל׃ פ ");
INSERT INTO hbo_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","וֽ͏ַיְהִ֥י כָל־הָאָ֖רֶץ שָׂפָ֣ה אֶחָ֑ת וּדְבָרִ֖ים אֲחָדִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","וֽ͏ַיְהִ֖י בְּנָסְעָ֣ם מִקֶּ֑דֶם וֽ͏ַיִּמְצְא֥וּ בִקְעָ֛ה בְּאֶ֥רֶץ שִׁנְעָ֖ר וַיֵּ֥שְׁבוּ שָֽׁם׃ ");
INSERT INTO hbo_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","וַיֹּאמְר֞וּ אִ֣ישׁ אֶל־רֵעֵ֗הוּ הָ֚בָה נִלְבְּנָ֣ה לְבֵנִ֔ים וְנִשְׂרְפָ֖ה לִשְׂרֵפָ֑ה וַתְּהִ֨י לָהֶ֤ם הַלְּבֵנָה֙ לְאָ֔בֶן וְהַ֣חֵמָ֔ר הָיָ֥ה לָהֶ֖ם לַחֹֽמֶר׃ ");
INSERT INTO hbo_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","וַיֹּאמְר֞וּ הָ֣בָה ׀ נִבְנֶה־לָּ֣נוּ עִ֗יר וּמִגְדָּל֙ וְרֹאשֹׁ֣ו בַשָּׁמַ֔יִם וְנַֽעֲשֶׂה־לָּ֖נוּ שֵׁ֑ם פֶּן־נָפ֖וּץ עַל־פְּנֵ֥י כָל־הָאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","וַיֵּ֣רֶד יְהוָ֔ה לִרְאֹ֥ת אֶת־הָעִ֖יר וְאֶת־הַמִּגְדָּ֑ל אֲשֶׁ֥ר בָּנ֖וּ בְּנֵ֥י הָאָדָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","וַיֹּ֣אמֶר יְהוָ֗ה הֵ֣ן עַ֤ם אֶחָד֙ וְשָׂפָ֤ה אַחַת֙ לְכֻלָּ֔ם וְזֶ֖ה הַחִלָּ֣ם לַעֲשֹׂ֑ות וְעַתָּה֙ לֹֽא־יִבָּצֵ֣ר מֵהֶ֔ם כֹּ֛ל אֲשֶׁ֥ר יָזְמ֖וּ לֽ͏ַעֲשֹֽׂות׃ ");
INSERT INTO hbo_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","הָ֚בָה נֽ͏ֵרְדָ֔ה וְנָבְלָ֥ה שָׁ֖ם שְׂפָתָ֑ם אֲשֶׁר֙ לֹ֣א יִשְׁמְע֔וּ אִ֖ישׁ שְׂפַ֥ת רֵעֵֽהוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","וַיָּ֨פֶץ יְהוָ֥ה אֹתָ֛ם מִשָּׁ֖ם עַל־פְּנֵ֣י כָל־הָאָ֑רֶץ וֽ͏ַיַּחְדְּל֖וּ לִבְנֹ֥ת הָעִֽיר׃ ");
INSERT INTO hbo_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","עַל־כֵּ֞ן קָרָ֤א שְׁמָהּ֙ בָּבֶ֔ל כִּי־שָׁ֛ם בָּלַ֥ל יְהוָ֖ה שְׂפַ֣ת כָּל־הָאָ֑רֶץ וּמִשָּׁם֙ הֱפִיצָ֣ם יְהוָ֔ה עַל־פְּנֵ֖י כָּל־הָאָֽרֶץ׃ פ ");
INSERT INTO hbo_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","אֵ֚לֶּה תֹּולְדֹ֣ת שֵׁ֔ם שֵׁ֚ם בֶּן־מְאַ֣ת שָׁנָ֔ה וַיֹּ֖ולֶד אֶת־אַרְפַּכְשָׁ֑ד שְׁנָתַ֖יִם אַחַ֥ר הַמַּבּֽוּל׃ ");
INSERT INTO hbo_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","וֽ͏ַיְחִי־שֵׁ֗ם אֽ͏ַחֲרֵי֙ הֹולִידֹ֣ו אֶת־אַרְפַּכְשָׁ֔ד חֲמֵ֥שׁ מֵאֹ֖ות שָׁנָ֑ה וַיֹּ֥ולֶד בָּנִ֖ים וּבָנֹֽות׃ ס ");
INSERT INTO hbo_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","וְאַרְפַּכְשַׁ֣ד חַ֔י חָמֵ֥שׁ וּשְׁלֹשִׁ֖ים שָׁנָ֑ה וַיֹּ֖ולֶד אֶת־שָֽׁלַח׃ ");
INSERT INTO hbo_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","וֽ͏ַיְחִ֣י אַרְפַּכְשַׁ֗ד אֽ͏ַחֲרֵי֙ הֹולִידֹ֣ו אֶת־שֶׁ֔לַח שָׁלֹ֣שׁ שָׁנִ֔ים וְאַרְבַּ֥ע מֵאֹ֖ות שָׁנָ֑ה וַיֹּ֥ולֶד בָּנִ֖ים וּבָנֹֽות׃ ס ");
INSERT INTO hbo_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","וְשֶׁ֥לַח חַ֖י שְׁלֹשִׁ֣ים שָׁנָ֑ה וַיֹּ֖ולֶד אֶת־עֵֽבֶר׃ ");
INSERT INTO hbo_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","וֽ͏ַיְחִי־שֶׁ֗לַח אַחֲרֵי֙ הֹולִידֹ֣ו אֶת־עֵ֔בֶר שָׁלֹ֣שׁ שָׁנִ֔ים וְאַרְבַּ֥ע מֵאֹ֖ות שָׁנָ֑ה וַיֹּ֥ולֶד בָּנִ֖ים וּבָנֹֽות׃ ס ");
INSERT INTO hbo_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","וַֽיְחִי־עֵ֕בֶר אַרְבַּ֥ע וּשְׁלֹשִׁ֖ים שָׁנָ֑ה וַיֹּ֖ולֶד אֶת־פָּֽלֶג׃ ");
INSERT INTO hbo_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","וַֽיְחִי־עֵ֗בֶר אַחֲרֵי֙ הֹולִידֹ֣ו אֶת־פֶּ֔לֶג שְׁלֹשִׁ֣ים שָׁנָ֔ה וְאַרְבַּ֥ע מֵאֹ֖ות שָׁנָ֑ה וַיֹּ֥ולֶד בָּנִ֖ים וּבָנֹֽות׃ ס ");
INSERT INTO hbo_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","וֽ͏ַיְחִי־פֶ֖לֶג שְׁלֹשִׁ֣ים שָׁנָ֑ה וַיֹּ֖ולֶד אֶת־רְעֽוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","וֽ͏ַיְחִי־פֶ֗לֶג אַחֲרֵי֙ הֹולִידֹ֣ו אֶת־רְע֔וּ תֵּ֥שַׁע שָׁנִ֖ים וּמָאתַ֣יִם שָׁנָ֑ה וַיֹּ֥ולֶד בָּנִ֖ים וּבָנֹֽות׃ ס ");
INSERT INTO hbo_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","וַיְחִ֣י רְע֔וּ שְׁתַּ֥יִם וּשְׁלֹשִׁ֖ים שָׁנָ֑ה וַיֹּ֖ולֶד אֶת־שְׂרֽוּג׃ ");
INSERT INTO hbo_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","וַיְחִ֣י רְע֗וּ אַחֲרֵי֙ הֹולִידֹ֣ו אֶת־שְׂר֔וּג שֶׁ֥בַע שָׁנִ֖ים וּמָאתַ֣יִם שָׁנָ֑ה וַיֹּ֥ולֶד בָּנִ֖ים וּבָנֹֽות׃ ס ");
INSERT INTO hbo_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","וַיְחִ֥י שְׂר֖וּג שְׁלֹשִׁ֣ים שָׁנָ֑ה וַיֹּ֖ולֶד אֶת־נָחֹֽור׃ ");
INSERT INTO hbo_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","וַיְחִ֣י שְׂר֗וּג אַחֲרֵ֛י הֹולִידֹ֥ו אֶת־נָחֹ֖ור מָאתַ֣יִם שָׁנָ֑ה וַיֹּ֥ולֶד בָּנִ֖ים וּבָנֹֽות׃ ס ");
INSERT INTO hbo_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","וַיְחִ֣י נָחֹ֔ור תֵּ֥שַׁע וְעֶשְׂרִ֖ים שָׁנָ֑ה וַיֹּ֖ולֶד אֶת־תָּֽרַח׃ ");
INSERT INTO hbo_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","וַיְחִ֣י נָחֹ֗ור אַחֲרֵי֙ הֹולִידֹ֣ו אֶת־תֶּ֔רַח תְּשַֽׁע־עֶשְׂרֵ֥ה שָׁנָ֖ה וּמְאַ֣ת שָׁנָ֑ה וַיֹּ֥ולֶד בָּנִ֖ים וּבָנֹֽות׃ ס ");
INSERT INTO hbo_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","וֽ͏ַיְחִי־תֶ֖רַח שִׁבְעִ֣ים שָׁנָ֑ה וַיֹּ֙ולֶד֙ אֶת־אַבְרָ֔ם אֶת־נָחֹ֖ור וְאֶת־הָרָֽן׃ ");
INSERT INTO hbo_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","וְאֵ֙לֶּה֙ תֹּולְדֹ֣ת תֶּ֔רַח תֶּ֚רַח הֹולִ֣יד אֶת־אַבְרָ֔ם אֶת־נָחֹ֖ור וְאֶת־הָרָ֑ן וְהָרָ֖ן הֹולִ֥יד אֶת־לֹֽוט׃ ");
INSERT INTO hbo_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","וַיָּ֣מָת הָרָ֔ן עַל־פְּנֵ֖י תֶּ֣רַח אָבִ֑יו בְּאֶ֥רֶץ מֹולַדְתֹּ֖ו בְּא֥וּר כַּשְׂדִּֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","וַיִּקַּ֨ח אַבְרָ֧ם וְנָחֹ֛ור לָהֶ֖ם נָשִׁ֑ים שֵׁ֤ם אֵֽשֶׁת־אַבְרָם֙ שָׂרָ֔י וְשֵׁ֤ם אֵֽשֶׁת־נָחֹור֙ מִלְכָּ֔ה בַּת־הָרָ֥ן אֲבִֽי־מִלְכָּ֖ה וֽ͏ַאֲבִ֥י יִסְכָּֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","וַתְּהִ֥י שָׂרַ֖י עֲקָרָ֑ה אֵ֥ין לָ֖הּ וָלָֽד׃ ");
INSERT INTO hbo_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","וַיִּקַּ֨ח תֶּ֜רַח אֶת־אַבְרָ֣ם בְּנֹ֗ו וְאֶת־לֹ֤וט בֶּן־הָרָן֙ בֶּן־בְּנֹ֔ו וְאֵת֙ שָׂרַ֣י כַּלָּתֹ֔ו אֵ֖שֶׁת אַבְרָ֣ם בְּנֹ֑ו וַיֵּצְא֨וּ אִתָּ֜ם מֵא֣וּר כַּשְׂדִּ֗ים לָלֶ֙כֶת֙ אַ֣רְצָה כְּנַ֔עַן וַיָּבֹ֥אוּ עַד־חָרָ֖ן וַיֵּ֥שְׁבוּ שָֽׁם׃ ");
INSERT INTO hbo_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","וַיִּהְי֣וּ יְמֵי־תֶ֔רַח חָמֵ֥שׁ שָׁנִ֖ים וּמָאתַ֣יִם שָׁנָ֑ה וַיָּ֥מָת תֶּ֖רַח בְּחָרָֽן׃ ס ");
INSERT INTO hbo_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","וַיֹּ֤אמֶר יְהוָה֙ אֶל־אַבְרָ֔ם לֶךְ־לְךָ֛ מֵאַרְצְךָ֥ וּמִמֹּֽולַדְתְּךָ֖ וּמִבֵּ֣ית אָבִ֑יךָ אֶל־הָאָ֖רֶץ אֲשֶׁ֥ר אַרְאֶֽךָּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","וְאֶֽעֶשְׂךָ֙ לְגֹ֣וי גָּדֹ֔ול וַאֲבָ֣רֶכְךָ֔ וַאֲגַדְּלָ֖ה שְׁמֶ֑ךָ וֶהְיֵ֖ה בְּרָכָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","וַאֲבָֽרֲכָה֙ מְבָ֣רְכֶ֔יךָ וּמְקַלֶּלְךָ֖ אָאֹ֑ר וְנִבְרְכ֣וּ בְךָ֔ כֹּ֖ל מִשְׁפְּחֹ֥ת הָאֲדָמָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","וַיֵּ֣לֶךְ אַבְרָ֗ם כַּאֲשֶׁ֨ר דִּבֶּ֤ר אֵלָיו֙ יְהוָ֔ה וַיֵּ֥לֶךְ אִתֹּ֖ו לֹ֑וט וְאַבְרָ֗ם בֶּן־חָמֵ֤שׁ שָׁנִים֙ וְשִׁבְעִ֣ים שָׁנָ֔ה בְּצֵאתֹ֖ו מֵחָרָֽן׃ ");
INSERT INTO hbo_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","וַיִּקַּ֣ח אַבְרָם֩ אֶת־שָׂרַ֨י אִשְׁתֹּ֜ו וְאֶת־לֹ֣וט בֶּן־אָחִ֗יו וְאֶת־כָּל־רְכוּשָׁם֙ אֲשֶׁ֣ר רָכָ֔שׁוּ וְאֶת־הַנֶּ֖פֶשׁ אֲשֶׁר־עָשׂ֣וּ בְחָרָ֑ן וַיֵּצְא֗וּ לָלֶ֙כֶת֙ אַ֣רְצָה כְּנַ֔עַן וַיָּבֹ֖אוּ אַ֥רְצָה כְּנָֽעַן׃ ");
INSERT INTO hbo_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","וַיַּעֲבֹ֤ר אַבְרָם֙ בָּאָ֔רֶץ עַ֚ד מְקֹ֣ום שְׁכֶ֔ם עַ֖ד אֵלֹ֣ון מֹורֶ֑ה וְהֽ͏ַכְּנַעֲנִ֖י אָ֥ז בָּאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","וַיֵּרָ֤א יְהוָה֙ אֶל־אַבְרָ֔ם וַיֹּ֕אמֶר לְזַ֨רְעֲךָ֔ אֶתֵּ֖ן אֶת־הָאָ֣רֶץ הַזֹּ֑את וַיִּ֤בֶן שָׁם֙ מִזְבֵּ֔חַ לַיהוָ֖ה הַנִּרְאֶ֥ה אֵלָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","וַיַּעְתֵּ֨ק מִשָּׁ֜ם הָהָ֗רָה מִקֶּ֛דֶם לְבֵֽית־אֵ֖ל וַיֵּ֣ט אָהֳלֹ֑ה בֵּֽית־אֵ֤ל מִיָּם֙ וְהָעַ֣י מִקֶּ֔דֶם וַיִּֽבֶן־שָׁ֤ם מִזְבֵּ֙חַ֙ לֽ͏ַיהוָ֔ה וַיִּקְרָ֖א בְּשֵׁ֥ם יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","וַיִּסַּ֣ע אַבְרָ֔ם הָלֹ֥וךְ וְנָסֹ֖ועַ הַנֶּֽגְבָּה׃ פ ");
INSERT INTO hbo_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","וַיְהִ֥י רָעָ֖ב בָּאָ֑רֶץ וַיֵּ֨רֶד אַבְרָ֤ם מִצְרַ֙יְמָה֙ לָג֣וּר שָׁ֔ם כִּֽי־כָבֵ֥ד הָרָעָ֖ב בָּאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","וַיְהִ֕י כַּאֲשֶׁ֥ר הִקְרִ֖יב לָבֹ֣וא מִצְרָ֑יְמָה וַיֹּ֙אמֶר֙ אֶל־שָׂרַ֣י אִשְׁתֹּ֔ו הִנֵּה־נָ֣א יָדַ֔עְתִּי כִּ֛י אִשָּׁ֥ה יְפַת־מַרְאֶ֖ה אָֽתְּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","וְהָיָ֗ה כִּֽי־יִרְא֤וּ אֹתָךְ֙ הַמִּצְרִ֔ים וְאָמְר֖וּ אִשְׁתֹּ֣ו זֹ֑את וְהָרְג֥וּ אֹתִ֖י וְאֹתָ֥ךְ יְחַיּֽוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","אִמְרִי־נָ֖א אֲחֹ֣תִי אָ֑תְּ לְמַ֙עַן֙ יִֽיטַב־לִ֣י בַעֲבוּרֵ֔ךְ וְחָיְתָ֥ה נַפְשִׁ֖י בִּגְלָלֵֽךְ׃ ");
INSERT INTO hbo_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","וַיְהִ֕י כְּבֹ֥וא אַבְרָ֖ם מִצְרָ֑יְמָה וַיִּרְא֤וּ הַמִּצְרִים֙ אֶת־הָ֣אִשָּׁ֔ה כִּֽי־יָפָ֥ה הִ֖וא מְאֹֽד׃ ");
INSERT INTO hbo_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","וַיִּרְא֤וּ אֹתָהּ֙ שָׂרֵ֣י פַרְעֹ֔ה וַיְהַֽלְל֥וּ אֹתָ֖הּ אֶל־פַּרְעֹ֑ה וַתֻּקַּ֥ח הָאִשָּׁ֖ה בֵּ֥ית פַּרְעֹֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","וּלְאַבְרָ֥ם הֵיטִ֖יב בַּעֲבוּרָ֑הּ וֽ͏ַיְהִי־לֹ֤ו צֹאן־וּבָקָר֙ וַחֲמֹרִ֔ים וַעֲבָדִים֙ וּשְׁפָחֹ֔ת וַאֲתֹנֹ֖ת וּגְמַלִּֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","וַיְנַגַּ֨ע יְהוָ֧ה ׀ אֶת־פַּרְעֹ֛ה נְגָעִ֥ים גְּדֹלִ֖ים וְאֶת־בֵּיתֹ֑ו עַל־דְּבַ֥ר שָׂרַ֖י אֵ֥שֶׁת אַבְרָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","וַיִּקְרָ֤א פַרְעֹה֙ לְאַבְרָ֔ם וַיֹּ֕אמֶר מַה־זֹּ֖את עָשִׂ֣יתָ לִּ֑י לָ֚מָּה לֹא־הִגַּ֣דְתָּ לִּ֔י כִּ֥י אִשְׁתְּךָ֖ הִֽוא׃ ");
INSERT INTO hbo_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","לָמָ֤ה אָמַ֙רְתָּ֙ אֲחֹ֣תִי הִ֔וא וָאֶקַּ֥ח אֹתָ֛הּ לִ֖י לְאִשָּׁ֑ה וְעַתָּ֕ה הִנֵּ֥ה אִשְׁתְּךָ֖ קַ֥ח וָלֵֽךְ׃ ");
INSERT INTO hbo_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","וַיְצַ֥ו עָלָ֛יו פַּרְעֹ֖ה אֲנָשִׁ֑ים וֽ͏ַיְשַׁלְּח֥וּ אֹתֹ֛ו וְאֶת־אִשְׁתֹּ֖ו וְאֶת־כָּל־אֲשֶׁר־לֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","וַיַּעַל֩ אַבְרָ֨ם מִמִּצְרַ֜יִם ה֠וּא וְאִשְׁתֹּ֧ו וְכָל־אֲשֶׁר־לֹ֛ו וְלֹ֥וט עִמֹּ֖ו הַנֶּֽגְבָּה׃ ");
INSERT INTO hbo_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","וְאַבְרָ֖ם כָּבֵ֣ד מְאֹ֑ד בַּמִּקְנֶ֕ה בַּכֶּ֖סֶף וּבַזָּהָֽב׃ ");
INSERT INTO hbo_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","וַיֵּ֙לֶךְ֙ לְמַסָּעָ֔יו מִנֶּ֖גֶב וְעַד־בֵּֽית־אֵ֑ל עַד־הַמָּקֹ֗ום אֲשֶׁר־הָ֨יָה שָׁ֤ם *אָהֳלֹה (אֽ͏ָהֳלֹו֙) בַּתְּחִלָּ֔ה בֵּ֥ין בֵּֽית־אֵ֖ל וּבֵ֥ין הָעָֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","אֶל־מְקֹום֙ הַמִּזְבֵּ֔חַ אֲשֶׁר־עָ֥שָׂה שָׁ֖ם בָּרִאשֹׁנָ֑ה וַיִּקְרָ֥א שָׁ֛ם אַבְרָ֖ם בְּשֵׁ֥ם יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","וְגַם־לְלֹ֔וט הַהֹלֵ֖ךְ אֶת־אַבְרָ֑ם הָיָ֥ה צֹאן־וּבָקָ֖ר וְאֹהָלִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","וְלֹא־נָשָׂ֥א אֹתָ֛ם הָאָ֖רֶץ לָשֶׁ֣בֶת יַחְדָּ֑ו כִּֽי־הָיָ֤ה רְכוּשָׁם֙ רָ֔ב וְלֹ֥א יָֽכְל֖וּ לָשֶׁ֥בֶת יַחְדָּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","וֽ͏ַיְהִי־רִ֗יב בֵּ֚ין רֹעֵ֣י מִקְנֵֽה־אַבְרָ֔ם וּבֵ֖ין רֹעֵ֣י מִקְנֵה־לֹ֑וט וְהַֽכְּנַעֲנִי֙ וְהַפְּרִזִּ֔י אָ֖ז יֹשֵׁ֥ב בָּאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","וַיֹּ֨אמֶר אַבְרָ֜ם אֶל־לֹ֗וט אַל־נָ֨א תְהִ֤י מְרִיבָה֙ בֵּינִ֣י וּבֵינֶ֔יךָ וּבֵ֥ין רֹעַ֖י וּבֵ֣ין רֹעֶ֑יךָ כִּֽי־אֲנָשִׁ֥ים אַחִ֖ים אֲנָֽחְנוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","הֲלֹ֤א כָל־הָאָ֙רֶץ֙ לְפָנֶ֔יךָ הִפָּ֥רֶד נָ֖א מֵעָלָ֑י אִם־הַשְּׂמֹ֣אל וְאֵימִ֔נָה וְאִם־הַיָּמִ֖ין וְאַשְׂמְאִֽילָה׃ ");
INSERT INTO hbo_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","וַיִּשָּׂא־לֹ֣וט אֶת־עֵינָ֗יו וַיַּרְא֙ אֶת־כָּל־כִּכַּ֣ר הַיַּרְדֵּ֔ן כִּ֥י כֻלָּ֖הּ מַשְׁקֶ֑ה לִפְנֵ֣י ׀ שַׁחֵ֣ת יְהוָ֗ה אֶת־סְדֹם֙ וְאֶת־עֲמֹרָ֔ה כְּגַן־יְהוָה֙ כְּאֶ֣רֶץ מִצְרַ֔יִם בֹּאֲכָ֖ה צֹֽעַר׃ ");
INSERT INTO hbo_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","וַיִּבְחַר־לֹ֣ו לֹ֗וט אֵ֚ת כָּל־כִּכַּ֣ר הַיַּרְדֵּ֔ן וַיִּסַּ֥ע לֹ֖וט מִקֶּ֑דֶם וַיִּפָּ֣רְד֔וּ אִ֖ישׁ מֵעַ֥ל אָחִֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","אַבְרָ֖ם יָשַׁ֣ב בְּאֶֽרֶץ־כְּנָ֑עַן וְלֹ֗וט יָשַׁב֙ בְּעָרֵ֣י הַכִּכָּ֔ר וַיֶּאֱהַ֖ל עַד־סְדֹֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","וְאַנְשֵׁ֣י סְדֹ֔ם רָעִ֖ים וְחַטָּאִ֑ים לַיהוָ֖ה מְאֹֽד׃ ");
INSERT INTO hbo_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","וֽ͏ַיהוָ֞ה אָמַ֣ר אֶל־אַבְרָ֗ם אַחֲרֵי֙ הִפָּֽרֶד־לֹ֣וט מֽ͏ֵעִמֹּ֔ו שָׂ֣א נָ֤א עֵינֶ֙יךָ֙ וּרְאֵ֔ה מִן־הַמָּקֹ֖ום אֲשֶׁר־אַתָּ֣ה שָׁ֑ם צָפֹ֥נָה וָנֶ֖גְבָּה וָקֵ֥דְמָה וָיָֽמָּה׃ ");
INSERT INTO hbo_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","כִּ֧י אֶת־כָּל־הָאָ֛רֶץ אֲשֶׁר־אַתָּ֥ה רֹאֶ֖ה לְךָ֣ אֶתְּנֶ֑נָּה וּֽלְזַרְעֲךָ֖ עַד־עֹולָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","וְשַׂמְתִּ֥י אֶֽת־זַרְעֲךָ֖ כַּעֲפַ֣ר הָאָ֑רֶץ אֲשֶׁ֣ר ׀ אִם־יוּכַ֣ל אִ֗ישׁ לִמְנֹות֙ אֶת־עֲפַ֣ר הָאָ֔רֶץ גַּֽם־זַרְעֲךָ֖ יִמָּנֶֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","ק֚וּם הִתְהַלֵּ֣ךְ בָּאָ֔רֶץ לְאָרְכָּ֖הּ וּלְרָחְבָּ֑הּ כִּ֥י לְךָ֖ אֶתְּנֶֽנָּה׃ ");
INSERT INTO hbo_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","וַיֶּאֱהַ֣ל אַבְרָ֗ם וַיָּבֹ֛א וַיֵּ֛שֶׁב בְּאֵלֹנֵ֥י מַמְרֵ֖א אֲשֶׁ֣ר בְּחֶבְרֹ֑ון וַיִּֽבֶן־שָׁ֥ם מִזְבֵּ֖חַ לֽ͏ַיהוָֽה׃ פ ");
INSERT INTO hbo_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","וַיְהִ֗י בִּימֵי֙ אַמְרָפֶ֣ל מֶֽלֶךְ־שִׁנְעָ֔ר אַרְיֹ֖וךְ מֶ֣לֶךְ אֶלָּסָ֑ר כְּדָרְלָעֹ֙מֶר֙ מֶ֣לֶךְ עֵילָ֔ם וְתִדְעָ֖ל מֶ֥לֶךְ גֹּויִֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","עָשׂ֣וּ מִלְחָמָ֗ה אֶת־בֶּ֙רַע֙ מֶ֣לֶךְ סְדֹ֔ם וְאֶת־בִּרְשַׁ֖ע מֶ֣לֶךְ עֲמֹרָ֑ה שִׁנְאָ֣ב ׀ מֶ֣לֶךְ אַדְמָ֗ה וְשֶׁמְאֵ֙בֶר֙ מֶ֣לֶךְ *צְבֹיִים (צְבֹויִ֔ים) וּמֶ֥לֶךְ בֶּ֖לַע הִיא־צֹֽעַר׃ ");
INSERT INTO hbo_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","כָּל־אֵ֙לֶּה֙ חָֽבְר֔וּ אֶל־עֵ֖מֶק הַשִּׂדִּ֑ים ה֖וּא יָ֥ם הַמֶּֽלַח׃ ");
INSERT INTO hbo_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","שְׁתֵּ֤ים עֶשְׂרֵה֙ שָׁנָ֔ה עָבְד֖וּ אֶת־כְּדָרְלָעֹ֑מֶר וּשְׁלֹשׁ־עֶשְׂרֵ֥ה שָׁנָ֖ה מָרָֽדוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","וּבְאַרְבַּע֩ עֶשְׂרֵ֨ה שָׁנָ֜ה בָּ֣א כְדָרְלָעֹ֗מֶר וְהַמְּלָכִים֙ אֲשֶׁ֣ר אִתֹּ֔ו וַיַּכּ֤וּ אֶת־רְפָאִים֙ בְּעַשְׁתְּרֹ֣ת קַרְנַ֔יִם וְאֶת־הַזּוּזִ֖ים בְּהָ֑ם וְאֵת֙ הֽ͏ָאֵימִ֔ים בְּשָׁוֵ֖ה קִרְיָתָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","וְאֶת־הַחֹרִ֖י בְּהַרְרָ֣ם שֵׂעִ֑יר עַ֚ד אֵ֣יל פָּארָ֔ן אֲשֶׁ֖ר עַל־הַמִּדְבָּֽר׃ ");
INSERT INTO hbo_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","וַ֠יָּשֻׁבוּ וַיָּבֹ֜אוּ אֶל־עֵ֤ין מִשְׁפָּט֙ הִ֣וא קָדֵ֔שׁ וַיַּכּ֕וּ אֶֽת־כָּל־שְׂדֵ֖ה הָעֲמָלֵקִ֑י וְגַם֙ אֶת־הָ֣אֱמֹרִ֔י הַיֹּשֵׁ֖ב בְּחַֽצְצֹ֥ן תָּמָֽר׃ ");
INSERT INTO hbo_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","וַיֵּצֵ֨א מֶֽלֶךְ־סְדֹ֜ם וּמֶ֣לֶךְ עֲמֹרָ֗ה וּמֶ֤לֶךְ אַדְמָה֙ וּמֶ֣לֶךְ *צְבֹיִים (צְבֹויִ֔ם) וּמֶ֥לֶךְ בֶּ֖לַע הִוא־צֹ֑עַר וַיַּֽעַרְכ֤וּ אִתָּם֙ מִלְחָמָ֔ה בְּעֵ֖מֶק הַשִּׂדִּֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","אֵ֣ת כְּדָרְלָעֹ֜מֶר מֶ֣לֶךְ עֵילָ֗ם וְתִדְעָל֙ מֶ֣לֶךְ גֹּויִ֔ם וְאַמְרָפֶל֙ מֶ֣לֶךְ שִׁנְעָ֔ר וְאַרְיֹ֖וךְ מֶ֣לֶךְ אֶלָּסָ֑ר אַרְבָּעָ֥ה מְלָכִ֖ים אֶת־הַחֲמִשָּֽׁה׃ ");
INSERT INTO hbo_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","וְעֵ֣מֶק הַשִׂדִּ֗ים בּֽ͏ֶאֱרֹ֤ת בֶּאֱרֹת֙ חֵמָ֔ר וַיָּנֻ֛סוּ מֶֽלֶךְ־סְדֹ֥ם וַעֲמֹרָ֖ה וַיִּפְּלוּ־שָׁ֑מָּה וְהַנִּשְׁאָרִ֖ים הֶ֥רָה נָּֽסוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","וַ֠יִּקְחוּ אֶת־כָּל־רְכֻ֨שׁ סְדֹ֧ם וַעֲמֹרָ֛ה וְאֶת־כָּל־אָכְלָ֖ם וַיֵּלֵֽכוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","וַיִּקְח֨וּ אֶת־לֹ֧וט וְאֶת־רְכֻשֹׁ֛ו בֶּן־אֲחִ֥י אַבְרָ֖ם וַיֵּלֵ֑כוּ וְה֥וּא יֹשֵׁ֖ב בִּסְדֹֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","וַיָּבֹא֙ הַפָּלִ֔יט וַיַּגֵּ֖ד לְאַבְרָ֣ם הָעִבְרִ֑י וְהוּא֩ שֹׁכֵ֨ן בְּאֵֽלֹנֵ֜י מַמְרֵ֣א הָאֱמֹרִ֗י אֲחִ֤י אֶשְׁכֹּל֙ וַאֲחִ֣י עָנֵ֔ר וְהֵ֖ם בַּעֲלֵ֥י בְרִית־אַבְרָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","וַיִּשְׁמַ֣ע אַבְרָ֔ם כִּ֥י נִשְׁבָּ֖ה אָחִ֑יו וַיָּ֨רֶק אֶת־חֲנִיכָ֜יו יְלִידֵ֣י בֵיתֹ֗ו שְׁמֹנָ֤ה עָשָׂר֙ וּשְׁלֹ֣שׁ מֵאֹ֔ות וַיִּרְדֹּ֖ף עַד־דָּֽן׃ ");
INSERT INTO hbo_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","וַיֵּחָלֵ֨ק עֲלֵיהֶ֧ם ׀ לַ֛יְלָה ה֥וּא וַעֲבָדָ֖יו וַיַּכֵּ֑ם וֽ͏ַיִּרְדְּפֵם֙ עַד־חֹובָ֔ה אֲשֶׁ֥ר מִשְּׂמֹ֖אל לְדַמָּֽשֶׂק׃ ");
INSERT INTO hbo_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","וַיָּ֕שֶׁב אֵ֖ת כָּל־הָרְכֻ֑שׁ וְגַם֩ אֶת־לֹ֨וט אָחִ֤יו וּרְכֻשֹׁו֙ הֵשִׁ֔יב וְגַ֥ם אֶת־הַנָּשִׁ֖ים וְאֶת־הָעָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","וַיֵּצֵ֣א מֶֽלֶךְ־סְדֹם֮ לִקְרָאתֹו֒ אַחֲרֵ֣י שׁוּבֹ֗ו מֽ͏ֵהַכֹּות֙ אֶת־כְּדָר־לָעֹ֔מֶר וְאֶת־הַמְּלָכִ֖ים אֲשֶׁ֣ר אִתֹּ֑ו אֶל־עֵ֣מֶק שָׁוֵ֔ה ה֖וּא עֵ֥מֶק הַמֶּֽלֶךְ׃ ");
INSERT INTO hbo_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","וּמַלְכִּי־צֶ֙דֶק֙ מֶ֣לֶךְ שָׁלֵ֔ם הֹוצִ֖יא לֶ֣חֶם וָיָ֑יִן וְה֥וּא כֹהֵ֖ן לְאֵ֥ל עֶלְיֹֽון׃ ");
INSERT INTO hbo_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","וֽ͏ַיְבָרְכֵ֖הוּ וַיֹּאמַ֑ר בָּר֤וּךְ אַבְרָם֙ לְאֵ֣ל עֶלְיֹ֔ון קֹנֵ֖ה שָׁמַ֥יִם וָאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","וּבָרוּךְ֙ אֵ֣ל עֶלְיֹ֔ון אֲשֶׁר־מִגֵּ֥ן צָרֶ֖יךָ בְּיָדֶ֑ךָ וַיִּתֶּן־לֹ֥ו מַעֲשֵׂ֖ר מִכֹּֽל׃ ");
INSERT INTO hbo_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","וַיֹּ֥אמֶר מֶֽלֶךְ־סְדֹ֖ם אֶל־אַבְרָ֑ם תֶּן־לִ֣י הַנֶּ֔פֶשׁ וְהָרְכֻ֖שׁ קַֽח־לָֽךְ׃ ");
INSERT INTO hbo_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","וַיֹּ֥אמֶר אַבְרָ֖ם אֶל־מֶ֣לֶךְ סְדֹ֑ם הֲרִימֹ֨תִי יָדִ֤י אֶל־יְהוָה֙ אֵ֣ל עֶלְיֹ֔ון קֹנֵ֖ה שָׁמַ֥יִם וָאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","אִם־מִחוּט֙ וְעַ֣ד שְׂרֹֽוךְ־נַ֔עַל וְאִם־אֶקַּ֖ח מִכָּל־אֲשֶׁר־לָ֑ךְ וְלֹ֣א תֹאמַ֔ר אֲנִ֖י הֶעֱשַׁ֥רְתִּי אֶת־אַבְרָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","בִּלְעָדַ֗י רַ֚ק אֲשֶׁ֣ר אֽ͏ָכְל֣וּ הַנְּעָרִ֔ים וְחֵ֙לֶק֙ הֽ͏ָאֲנָשִׁ֔ים אֲשֶׁ֥ר הָלְכ֖וּ אִתִּ֑י עָנֵר֙ אֶשְׁכֹּ֣ל וּמַמְרֵ֔א הֵ֖ם יִקְח֥וּ חֶלְקָֽם׃ ס ");
INSERT INTO hbo_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","אַחַ֣ר ׀ הַדְּבָרִ֣ים הָאֵ֗לֶּה הָיָ֤ה דְבַר־יְהוָה֙ אֶל־אַבְרָ֔ם בּֽ͏ַמַּחֲזֶ֖ה לֵאמֹ֑ר אַל־תִּירָ֣א אַבְרָ֗ם אָנֹכִי֙ מָגֵ֣ן לָ֔ךְ שְׂכָרְךָ֖ הַרְבֵּ֥ה מְאֹֽד׃ ");
INSERT INTO hbo_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","וַיֹּ֣אמֶר אַבְרָ֗ם אֲדֹנָ֤י יֱהוִה֙ מַה־תִּתֶּן־לִ֔י וְאָנֹכִ֖י הֹולֵ֣ךְ עֲרִירִ֑י וּבֶן־מֶ֣שֶׁק בֵּיתִ֔י ה֖וּא דַּמֶּ֥שֶׂק אֱלִיעֶֽזֶר׃ ");
INSERT INTO hbo_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","וַיֹּ֣אמֶר אַבְרָ֔ם הֵ֣ן לִ֔י לֹ֥א נָתַ֖תָּה זָ֑רַע וְהִנֵּ֥ה בֶן־בֵּיתִ֖י יֹורֵ֥שׁ אֹתִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","וְהִנֵּ֨ה דְבַר־יְהוָ֤ה אֵלָיו֙ לֵאמֹ֔ר לֹ֥א יִֽירָשְׁךָ֖ זֶ֑ה כִּי־אִם֙ אֲשֶׁ֣ר יֵצֵ֣א מִמֵּעֶ֔יךָ ה֖וּא יִֽירָשֶֽׁךָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","וַיֹּוצֵ֨א אֹתֹ֜ו הַח֗וּצָה וַיֹּ֙אמֶר֙ הַבֶּט־נָ֣א הַשָּׁמַ֗יְמָה וּסְפֹר֙ הַכֹּ֣וכָבִ֔ים אִם־תּוּכַ֖ל לִסְפֹּ֣ר אֹתָ֑ם וַיֹּ֣אמֶר לֹ֔ו כֹּ֥ה יִהְיֶ֖ה זַרְעֶֽךָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","וְהֶאֱמִ֖ן בּֽ͏ַיהוָ֑ה וַיַּחְשְׁבֶ֥הָ לֹּ֖ו צְדָקָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","וַיֹּ֖אמֶר אֵלָ֑יו אֲנִ֣י יְהוָ֗ה אֲשֶׁ֤ר הֹוצֵאתִ֙יךָ֙ מֵא֣וּר כַּשְׂדִּ֔ים לָ֧תֶת לְךָ֛ אֶת־הָאָ֥רֶץ הַזֹּ֖את לְרִשְׁתָּֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","וַיֹּאמַ֑ר אֲדֹנָ֣י יֱהוִ֔ה בַּמָּ֥ה אֵדַ֖ע כִּ֥י אֽ͏ִירָשֶֽׁנָּה׃ ");
INSERT INTO hbo_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","וַיֹּ֣אמֶר אֵלָ֗יו קְחָ֥ה לִי֙ עֶגְלָ֣ה מְשֻׁלֶּ֔שֶׁת וְעֵ֥ז מְשֻׁלֶּ֖שֶׁת וְאַ֣יִל מְשֻׁלָּ֑שׁ וְתֹ֖ר וְגֹוזָֽל׃ ");
INSERT INTO hbo_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","וַיִּֽקַּֽח־לֹ֣ו אֶת־כָּל־אֵ֗לֶּה וַיְבַתֵּ֤ר אֹתָם֙ בַּתָּ֔וֶךְ וַיִּתֵּ֥ן אִישׁ־בִּתְרֹ֖ו לִקְרַ֣את רֵעֵ֑הוּ וְאֶת־הַצִפֹּ֖ר לֹ֥א בָתָֽר׃ ");
INSERT INTO hbo_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","וַיֵּ֥רֶד הָעַ֖יִט עַל־הַפְּגָרִ֑ים וַיַּשֵּׁ֥ב אֹתָ֖ם אַבְרָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","וַיְהִ֤י הַשֶּׁ֙מֶשׁ֙ לָבֹ֔וא וְתַרְדֵּמָ֖ה נָפְלָ֣ה עַל־אַבְרָ֑ם וְהִנֵּ֥ה אֵימָ֛ה חֲשֵׁכָ֥ה גְדֹלָ֖ה נֹפֶ֥לֶת עָלָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","וַיֹּ֣אמֶר לְאַבְרָ֗ם יָדֹ֨עַ תֵּדַ֜ע כִּי־גֵ֣ר ׀ יִהְיֶ֣ה זַרְעֲךָ֗ בְּאֶ֙רֶץ֙ לֹ֣א לָהֶ֔ם וַעֲבָד֖וּם וְעִנּ֣וּ אֹתָ֑ם אַרְבַּ֥ע מֵאֹ֖ות שָׁנָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","וְגַ֧ם אֶת־הַגֹּ֛וי אֲשֶׁ֥ר יַעֲבֹ֖דוּ דָּ֣ן אָנֹ֑כִי וְאַחֲרֵי־כֵ֥ן יֵצְא֖וּ בִּרְכֻ֥שׁ גָּדֹֽול׃ ");
INSERT INTO hbo_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","וְאַתָּ֛ה תָּבֹ֥וא אֶל־אֲבֹתֶ֖יךָ בְּשָׁלֹ֑ום תִּקָּבֵ֖ר בְּשֵׂיבָ֥ה טֹובָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","וְדֹ֥ור רְבִיעִ֖י יָשׁ֣וּבוּ הֵ֑נָּה כִּ֧י לֹא־שָׁלֵ֛ם עֲוֹ֥ן הָאֱמֹרִ֖י עַד־הֵֽנָּה׃ ");
INSERT INTO hbo_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","וַיְהִ֤י הַשֶּׁ֙מֶשׁ֙ בָּ֔אָה וַעֲלָטָ֖ה הָיָ֑ה וְהִנֵּ֨ה תַנּ֤וּר עָשָׁן֙ וְלַפִּ֣יד אֵ֔שׁ אֲשֶׁ֣ר עָבַ֔ר בֵּ֖ין הַגְּזָרִ֥ים הָאֵֽלֶּה׃ ");
INSERT INTO hbo_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","בַּיֹּ֣ום הַה֗וּא כָּרַ֧ת יְהוָ֛ה אֶת־אַבְרָ֖ם בְּרִ֣ית לֵאמֹ֑ר לְזַרְעֲךָ֗ נָתַ֙תִּי֙ אֶת־הָאָ֣רֶץ הַזֹּ֔את מִנְּהַ֣ר מִצְרַ֔יִם עַד־הַנָּהָ֥ר הַגָּדֹ֖ל נְהַר־פְּרָֽת׃ ");
INSERT INTO hbo_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","אֶת־הַקֵּינִי֙ וְאֶת־הַקְּנִזִּ֔י וְאֵ֖ת הַקַּדְמֹנִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","וְאֶת־הַחִתִּ֥י וְאֶת־הַפְּרִזִּ֖י וְאֶת־הָרְפָאִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","וְאֶת־הֽ͏ָאֱמֹרִי֙ וְאֶת־הֽ͏ַכְּנַעֲנִ֔י וְאֶת־הַגִּרְגָּשִׁ֖י וְאֶת־הַיְבוּסִֽי׃ ס ");
INSERT INTO hbo_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","וְשָׂרַי֙ אֵ֣שֶׁת אַבְרָ֔ם לֹ֥א יָלְדָ֖ה לֹ֑ו וְלָ֛הּ שִׁפְחָ֥ה מִצְרִ֖ית וּשְׁמָ֥הּ הָגָֽר׃ ");
INSERT INTO hbo_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","וַתֹּ֨אמֶר שָׂרַ֜י אֶל־אַבְרָ֗ם הִנֵּה־נָ֞א עֲצָרַ֤נִי יְהוָה֙ מִלֶּ֔דֶת בֹּא־נָא֙ אֶל־שִׁפְחָתִ֔י אוּלַ֥י אִבָּנֶ֖ה מִמֵּ֑נָּה וַיִּשְׁמַ֥ע אַבְרָ֖ם לְקֹ֥ול שָׂרָֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","וַתִּקַּ֞ח שָׂרַ֣י אֵֽשֶׁת־אַבְרָ֗ם אֶת־הָגָ֤ר הַמִּצְרִית֙ שִׁפְחָתָ֔הּ מִקֵּץ֙ עֶ֣שֶׂר שָׁנִ֔ים לְשֶׁ֥בֶת אַבְרָ֖ם בְּאֶ֣רֶץ כְּנָ֑עַן וַתִּתֵּ֥ן אֹתָ֛הּ לְאַבְרָ֥ם אִישָׁ֖הּ לֹ֥ו לְאִשָּֽׁה׃ ");
INSERT INTO hbo_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","וַיָּבֹ֥א אֶל־הָגָ֖ר וַתַּ֑הַר וַתֵּ֙רֶא֙ כִּ֣י הָרָ֔תָה וַתֵּקַ֥ל גְּבִרְתָּ֖הּ בְּעֵינֶֽיהָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","וַתֹּ֨אמֶר שָׂרַ֣י אֶל־אַבְרָם֮ חֲמָסִ֣י עָלֶיךָ֒ אָנֹכִ֗י נָתַ֤תִּי שִׁפְחָתִי֙ בְּחֵיקֶ֔ךָ וַתֵּ֙רֶא֙ כִּ֣י הָרָ֔תָה וָאֵקַ֖ל בְּעֵינֶ֑יהָ יִשְׁפֹּ֥ט יְהוָ֖ה בֵּינִ֥י וּבֵינֶֽיׄךָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","וַיֹּ֨אמֶר אַבְרָ֜ם אֶל־שָׂרַ֗י הִנֵּ֤ה שִׁפְחָתֵךְ֙ בְּיָדֵ֔ךְ עֲשִׂי־לָ֖הּ הַטֹּ֣וב בְּעֵינָ֑יִךְ וַתְּעַנֶּ֣הָ שָׂרַ֔י וַתִּבְרַ֖ח מִפָּנֶֽיהָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","וַֽיִּמְצָאָ֞הּ מַלְאַ֧ךְ יְהוָ֛ה עַל־עֵ֥ין הַמַּ֖יִם בַּמִּדְבָּ֑ר עַל־הָעַ֖יִן בְּדֶ֥רֶךְ שֽׁוּר׃ ");
INSERT INTO hbo_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","וַיֹּאמַ֗ר הָגָ֞ר שִׁפְחַ֥ת שָׂרַ֛י אֵֽי־מִזֶּ֥ה בָ֖את וְאָ֣נָה תֵלֵ֑כִי וַתֹּ֕אמֶר מִפְּנֵי֙ שָׂרַ֣י גְּבִרְתִּ֔י אָנֹכִ֖י בֹּרַֽחַת׃ ");
INSERT INTO hbo_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","וַיֹּ֤אמֶר לָהּ֙ מַלְאַ֣ךְ יְהוָ֔ה שׁ֖וּבִי אֶל־גְּבִרְתֵּ֑ךְ וְהִתְעַנִּ֖י תַּ֥חַת יָדֶֽיהָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","וַיֹּ֤אמֶר לָהּ֙ מַלְאַ֣ךְ יְהוָ֔ה הַרְבָּ֥ה אַרְבֶּ֖ה אֶת־זַרְעֵ֑ךְ וְלֹ֥א יִסָּפֵ֖ר מֵרֹֽב׃ ");
INSERT INTO hbo_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","וַיֹּ֤אמֶר לָהּ֙ מַלְאַ֣ךְ יְהוָ֔ה הִנָּ֥ךְ הָרָ֖ה וְיֹלַ֣דְתְּ בֵּ֑ן וְקָרָ֤את שְׁמֹו֙ יִשְׁמָעֵ֔אל כִּֽי־שָׁמַ֥ע יְהוָ֖ה אֶל־עָנְיֵֽךְ׃ ");
INSERT INTO hbo_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","וְה֤וּא יִהְיֶה֙ פֶּ֣רֶא אָדָ֔ם יָדֹ֣ו בַכֹּ֔ל וְיַ֥ד כֹּ֖ל בֹּ֑ו וְעַל־פְּנֵ֥י כָל־אֶחָ֖יו יִשְׁכֹּֽן׃ ");
INSERT INTO hbo_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","וַתִּקְרָ֤א שֵׁם־יְהוָה֙ הַדֹּבֵ֣ר אֵלֶ֔יהָ אַתָּ֖ה אֵ֣ל רֳאִ֑י כִּ֣י אֽ͏ָמְרָ֗ה הֲגַ֥ם הֲלֹ֛ם רָאִ֖יתִי אַחֲרֵ֥י רֹאִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","עַל־כֵּן֙ קָרָ֣א לַבְּאֵ֔ר בְּאֵ֥ר לַחַ֖י רֹאִ֑י הִנֵּ֥ה בֵין־קָדֵ֖שׁ וּבֵ֥ין בָּֽרֶד׃ ");
INSERT INTO hbo_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","וַתֵּ֧לֶד הָגָ֛ר לְאַבְרָ֖ם בֵּ֑ן וַיִּקְרָ֨א אַבְרָ֧ם שֶׁם־בְּנֹ֛ו אֲשֶׁר־יָלְדָ֥ה הָגָ֖ר יִשְׁמָעֵֽאל׃ ");
INSERT INTO hbo_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","וְאַבְרָ֕ם בֶּן־שְׁמֹנִ֥ים שָׁנָ֖ה וְשֵׁ֣שׁ שָׁנִ֑ים בְּלֶֽדֶת־הָגָ֥ר אֶת־יִשְׁמָעֵ֖אל לְאַבְרָֽם׃ ס ");
INSERT INTO hbo_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","וַיְהִ֣י אַבְרָ֔ם בֶּן־תִּשְׁעִ֥ים שָׁנָ֖ה וְתֵ֣שַׁע שָׁנִ֑ים וַיֵּרָ֨א יְהוָ֜ה אֶל־אַבְרָ֗ם וַיֹּ֤אמֶר אֵלָיו֙ אֲנִי־אֵ֣ל שַׁדַּ֔י הִתְהַלֵּ֥ךְ לְפָנַ֖י וֶהְיֵ֥ה תָמִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","וְאֶתְּנָ֥ה בְרִיתִ֖י בֵּינִ֣י וּבֵינֶ֑ךָ וְאַרְבֶּ֥ה אֹותְךָ֖ בִּמְאֹ֥ד מְאֹֽד׃ ");
INSERT INTO hbo_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","וַיִּפֹּ֥ל אַבְרָ֖ם עַל־פָּנָ֑יו וַיְדַבֵּ֥ר אִתֹּ֛ו אֱלֹהִ֖ים לֵאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","אֲנִ֕י הִנֵּ֥ה בְרִיתִ֖י אִתָּ֑ךְ וְהָיִ֕יתָ לְאַ֖ב הֲמֹ֥ון גֹּויִֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","וְלֹא־יִקָּרֵ֥א עֹ֛וד אֶת־שִׁמְךָ֖ אַבְרָ֑ם וְהָיָ֤ה שִׁמְךָ֙ אַבְרָהָ֔ם כִּ֛י אַב־הֲמֹ֥ון גֹּויִ֖ם נְתַתִּֽיךָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","וְהִפְרֵתִ֤י אֹֽתְךָ֙ בִּמְאֹ֣ד מְאֹ֔ד וּנְתַתִּ֖יךָ לְגֹויִ֑ם וּמְלָכִ֖ים מִמְּךָ֥ יֵצֵֽאוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","וַהֲקִמֹתִ֨י אֶת־בְּרִיתִ֜י בֵּינִ֣י וּבֵינֶ֗ךָ וּבֵ֨ין זַרְעֲךָ֧ אַחֲרֶ֛יךָ לְדֹרֹתָ֖ם לִבְרִ֣ית עֹולָ֑ם לִהְיֹ֤ות לְךָ֙ לֵֽאלֹהִ֔ים וּֽלְזַרְעֲךָ֖ אַחֲרֶֽיךָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","וְנָתַתִּ֣י לְ֠ךָ וּלְזַרְעֲךָ֨ אַחֲרֶ֜יךָ אֵ֣ת ׀ אֶ֣רֶץ מְגֻרֶ֗יךָ אֵ֚ת כָּל־אֶ֣רֶץ כְּנַ֔עַן לַאֲחֻזַּ֖ת עֹולָ֑ם וְהָיִ֥יתִי לָהֶ֖ם לֵאלֹהִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","וַיֹּ֤אמֶר אֱלֹהִים֙ אֶל־אַבְרָהָ֔ם וְאַתָּ֖ה אֶת־בְּרִיתִ֣י תִשְׁמֹ֑ר אַתָּ֛ה וְזַרְעֲךָ֥ אֽ͏ַחֲרֶ֖יךָ לְדֹרֹתָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","זֹ֣את בְּרִיתִ֞י אֲשֶׁ֣ר תִּשְׁמְר֗וּ בֵּינִי֙ וּבֵ֣ינֵיכֶ֔ם וּבֵ֥ין זַרְעֲךָ֖ אַחֲרֶ֑יךָ הִמֹּ֥ול לָכֶ֖ם כָּל־זָכָֽר׃ ");
INSERT INTO hbo_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","וּנְמַלְתֶּ֕ם אֵ֖ת בְּשַׂ֣ר עָרְלַתְכֶ֑ם וְהָיָה֙ לְאֹ֣ות בְּרִ֔ית בֵּינִ֖י וּבֵינֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","וּבֶן־שְׁמֹנַ֣ת יָמִ֗ים יִמֹּ֥ול לָכֶ֛ם כָּל־זָכָ֖ר לְדֹרֹתֵיכֶ֑ם יְלִ֣יד בָּ֔יִת וּמִקְנַת־כֶּ֙סֶף֙ מִכֹּ֣ל בֶּן־נֵכָ֔ר אֲשֶׁ֛ר לֹ֥א מִֽזַּרְעֲךָ֖ הֽוּא׃ ");
INSERT INTO hbo_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","הִמֹּ֧ול ׀ יִמֹּ֛ול יְלִ֥יד בּֽ͏ֵיתְךָ֖ וּמִקְנַ֣ת כַּסְפֶּ֑ךָ וְהָיְתָ֧ה בְרִיתִ֛י בִּבְשַׂרְכֶ֖ם לִבְרִ֥ית עֹולָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","וְעָרֵ֣ל ׀ זָכָ֗ר אֲשֶׁ֤ר לֹֽא־יִמֹּול֙ אֶת־בְּשַׂ֣ר עָרְלָתֹ֔ו וְנִכְרְתָ֛ה הַנֶּ֥פֶשׁ הַהִ֖וא מֵעַמֶּ֑יהָ אֶת־בְּרִיתִ֖י הֵפַֽר׃ ס ");
INSERT INTO hbo_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","וַיֹּ֤אמֶר אֱלֹהִים֙ אֶל־אַבְרָהָ֔ם שָׂרַ֣י אִשְׁתְּךָ֔ לֹא־תִקְרָ֥א אֶת־שְׁמָ֖הּ שָׂרָ֑י כִּ֥י שָׂרָ֖ה שְׁמָֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","וּבֵרַכְתִּ֣י אֹתָ֔הּ וְגַ֨ם נָתַ֧תִּי מִמֶּ֛נָּה לְךָ֖ בֵּ֑ן וּבֵֽרַכְתִּ֙יהָ֙ וְהָֽיְתָ֣ה לְגֹויִ֔ם מַלְכֵ֥י עַמִּ֖ים מִמֶּ֥נָּה יִהְיֽוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","וַיִּפֹּ֧ל אַבְרָהָ֛ם עַל־פָּנָ֖יו וַיִּצְחָ֑ק וַיֹּ֣אמֶר בְּלִבֹּ֗ו הַלְּבֶ֤ן מֵאָֽה־שָׁנָה֙ יִוָּלֵ֔ד וְאִ֨ם־שָׂרָ֔ה הֲבַת־תִּשְׁעִ֥ים שָׁנָ֖ה תֵּלֵֽד׃ ");
INSERT INTO hbo_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","וַיֹּ֥אמֶר אַבְרָהָ֖ם אֶל־הֽ͏ָאֱלֹהִ֑ים ל֥וּ יִשְׁמָעֵ֖אל יִחְיֶ֥ה לְפָנֶֽיךָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","וַיֹּ֣אמֶר אֱלֹהִ֗ים אֲבָל֙ שָׂרָ֣ה אִשְׁתְּךָ֗ יֹלֶ֤דֶת לְךָ֙ בֵּ֔ן וְקָרָ֥אתָ אֶת־שְׁמֹ֖ו יִצְחָ֑ק וַהֲקִמֹתִ֨י אֶת־בְּרִיתִ֥י אִתֹּ֛ו לִבְרִ֥ית עֹולָ֖ם לְזַרְעֹ֥ו אַחֲרָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","וּֽלְיִשְׁמָעֵאל֮ שְׁמַעְתִּיךָ֒ הִנֵּ֣ה ׀ בֵּרַ֣כְתִּי אֹתֹ֗ו וְהִפְרֵיתִ֥י אֹתֹ֛ו וְהִרְבֵּיתִ֥י אֹתֹ֖ו בִּמְאֹ֣ד מְאֹ֑ד שְׁנֵים־עָשָׂ֤ר נְשִׂיאִם֙ יֹולִ֔יד וּנְתַתִּ֖יו לְגֹ֥וי גָּדֹֽול׃ ");
INSERT INTO hbo_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","וְאֶת־בְּרִיתִ֖י אָקִ֣ים אֶת־יִצְחָ֑ק אֲשֶׁר֩ תֵּלֵ֨ד לְךָ֤ שָׂרָה֙ לַמֹּועֵ֣ד הַזֶּ֔ה בַּשָּׁנָ֖ה הָאַחֶֽרֶת׃ ");
INSERT INTO hbo_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","וַיְכַ֖ל לְדַבֵּ֣ר אִתֹּ֑ו וַיַּ֣עַל אֱלֹהִ֔ים מֵעַ֖ל אַבְרָהָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","וַיִּקַּ֨ח אַבְרָהָ֜ם אֶת־יִשְׁמָעֵ֣אל בְּנֹ֗ו וְאֵ֨ת כָּל־יְלִידֵ֤י בֵיתֹו֙ וְאֵת֙ כָּל־מִקְנַ֣ת כַּסְפֹּ֔ו כָּל־זָכָ֕ר בְּאַנְשֵׁ֖י בֵּ֣ית אַבְרָהָ֑ם וַיָּ֜מָל אֶת־בְּשַׂ֣ר עָרְלָתָ֗ם בְּעֶ֙צֶם֙ הַיֹּ֣ום הַזֶּ֔ה כַּאֲשֶׁ֛ר דִּבֶּ֥ר אִתֹּ֖ו אֱלֹהִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","וְאַ֨בְרָהָ֔ם בֶּן־תִּשְׁעִ֥ים וָתֵ֖שַׁע שָׁנָ֑ה בְּהִמֹּלֹ֖ו בְּשַׂ֥ר עָרְלָתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","וְיִשְׁמָעֵ֣אל בְּנֹ֔ו בֶּן־שְׁלֹ֥שׁ עֶשְׂרֵ֖ה שָׁנָ֑ה בְּהִ֨מֹּלֹ֔ו אֵ֖ת בְּשַׂ֥ר עָרְלָתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","בְּעֶ֙צֶם֙ הַיֹּ֣ום הַזֶּ֔ה נִמֹּ֖ול אַבְרָהָ֑ם וְיִשְׁמָעֵ֖אל בְּנֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","וְכָל־אַנְשֵׁ֤י בֵיתֹו֙ יְלִ֣יד בָּ֔יִת וּמִקְנַת־כֶּ֖סֶף מֵאֵ֣ת בֶּן־נֵכָ֑ר נִמֹּ֖לוּ אִתֹּֽו׃ פ ");
INSERT INTO hbo_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","וַיֵּרָ֤א אֵלָיו֙ יְהוָ֔ה בְּאֵלֹנֵ֖י מַמְרֵ֑א וְה֛וּא יֹשֵׁ֥ב פֶּֽתַח־הָאֹ֖הֶל כְּחֹ֥ם הַיֹּֽום׃ ");
INSERT INTO hbo_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","וַיִּשָּׂ֤א עֵינָיו֙ וַיַּ֔רְא וְהִנֵּה֙ שְׁלֹשָׁ֣ה אֲנָשִׁ֔ים נִצָּבִ֖ים עָלָ֑יו וַיַּ֗רְא וַיָּ֤רָץ לִקְרָאתָם֙ מִפֶּ֣תַח הָאֹ֔הֶל וַיִּשְׁתַּ֖חוּ אָֽרְצָה׃ ");
INSERT INTO hbo_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","וַיֹּאמַ֑ר אֲדֹנָ֗י אִם־נָ֨א מָצָ֤אתִי חֵן֙ בְּעֵינֶ֔יךָ אַל־נָ֥א תַעֲבֹ֖ר מֵעַ֥ל עַבְדֶּֽךָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","יֻקַּֽח־נָ֣א מְעַט־מַ֔יִם וְרַחֲצ֖וּ רַגְלֵיכֶ֑ם וְהִֽשָּׁעֲנ֖וּ תַּ֥חַת הָעֵֽץ׃ ");
INSERT INTO hbo_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","וְאֶקְחָ֨ה פַת־לֶ֜חֶם וְסַעֲד֤וּ לִבְּכֶם֙ אַחַ֣ר תַּעֲבֹ֔רוּ כִּֽי־עַל־כֵּ֥ן עֲבַרְתֶּ֖ם עַֽל־עַבְדְּכֶ֑ם וַיֹּ֣אמְר֔וּ כֵּ֥ן תַּעֲשֶׂ֖ה כַּאֲשֶׁ֥ר דִּבַּֽרְתָּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","וַיְמַהֵ֧ר אַבְרָהָ֛ם הָאֹ֖הֱלָה אֶל־שָׂרָ֑ה וַיֹּ֗אמֶר מַהֲרִ֞י שְׁלֹ֤שׁ סְאִים֙ קֶ֣מַח סֹ֔לֶת ל֖וּשִׁי וַעֲשִׂ֥י עֻגֹֽות׃ ");
INSERT INTO hbo_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","וְאֶל־הַבָּקָ֖ר רָ֣ץ אַבְרָהָ֑ם וַיִּקַּ֨ח בֶּן־בָּקָ֜ר רַ֤ךְ וָטֹוב֙ וַיִּתֵּ֣ן אֶל־הַנַּ֔עַר וַיְמַהֵ֖ר לַעֲשֹׂ֥ות אֹתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","וַיִּקַּ֨ח חֶמְאָ֜ה וְחָלָ֗ב וּבֶן־הַבָּקָר֙ אֲשֶׁ֣ר עָשָׂ֔ה וַיִּתֵּ֖ן לִפְנֵיהֶ֑ם וְהֽוּא־עֹמֵ֧ד עֲלֵיהֶ֛ם תַּ֥חַת הָעֵ֖ץ וַיֹּאכֵֽלוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","וַיֹּאמְר֣וּ אֵׄלָ֔ׄיׄוׄ אַיֵּ֖ה שָׂרָ֣ה אִשְׁתֶּ֑ךָ וַיֹּ֖אמֶר הִנֵּ֥ה בָאֹֽהֶל׃ ");
INSERT INTO hbo_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","וַיֹּ֗אמֶר שֹׁ֣וב אָשׁ֤וּב אֵלֶ֙יךָ֙ כָּעֵ֣ת חַיָּ֔ה וְהִנֵּה־בֵ֖ן לְשָׂרָ֣ה אִשְׁתֶּ֑ךָ וְשָׂרָ֥ה שֹׁמַ֛עַת פֶּ֥תַח הָאֹ֖הֶל וְה֥וּא אַחֲרָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","וְאַבְרָהָ֤ם וְשָׂרָה֙ זְקֵנִ֔ים בָּאִ֖ים בַּיָּמִ֑ים חָדַל֙ לִהְיֹ֣ות לְשָׂרָ֔ה אֹ֖רַח כַּנָּשִֽׁים׃ ");
INSERT INTO hbo_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","וַתִּצְחַ֥ק שָׂרָ֖ה בְּקִרְבָּ֣הּ לֵאמֹ֑ר אַחֲרֵ֤י בְלֹתִי֙ הֽ͏ָיְתָה־לִּ֣י עֶדְנָ֔ה וֽ͏ַאדֹנִ֖י זָקֵֽן׃ ");
INSERT INTO hbo_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","וַיֹּ֥אמֶר יְהוָ֖ה אֶל־אַבְרָהָ֑ם לָ֣מָּה זֶּה֩ צָחֲקָ֨ה שָׂרָ֜ה לֵאמֹ֗ר הַאַ֥ף אֻמְנָ֛ם אֵלֵ֖ד וַאֲנִ֥י זָקַֽנְתִּי׃ ");
INSERT INTO hbo_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","הֲיִפָּלֵ֥א מֵיְהוָ֖ה דָּבָ֑ר לַמֹּועֵ֞ד אָשׁ֥וּב אֵלֶ֛יךָ כָּעֵ֥ת חַיָּ֖ה וּלְשָׂרָ֥ה בֵֽן׃ ");
INSERT INTO hbo_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","וַתְּכַחֵ֨שׁ שָׂרָ֧ה ׀ לֵאמֹ֛ר לֹ֥א צָחַ֖קְתִּי כִּ֣י ׀ יָרֵ֑אָה וַיֹּ֥אמֶר ׀ לֹ֖א כִּ֥י צָחָֽקְתְּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","וַיָּקֻ֤מוּ מִשָּׁם֙ הֽ͏ָאֲנָשִׁ֔ים וַיַּשְׁקִ֖פוּ עַל־פְּנֵ֣י סְדֹ֑ם וְאַ֨בְרָהָ֔ם הֹלֵ֥ךְ עִמָּ֖ם לְשַׁלְּחָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","וַֽיהֹוָ֖ה אָמָ֑ר הֽ͏ַמְכַסֶּ֤ה אֲנִי֙ מֽ͏ֵאַבְרָהָ֔ם אֲשֶׁ֖ר אֲנִ֥י עֹשֶֽׂה׃ ");
INSERT INTO hbo_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","וְאַ֨בְרָהָ֔ם הָיֹ֧ו יִֽהְיֶ֛ה לְגֹ֥וי גָּדֹ֖ול וְעָצ֑וּם וְנִ֨בְרְכוּ בֹ֔ו כֹּ֖ל גֹּויֵ֥י הָאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","כִּ֣י יְדַעְתִּ֗יו לְמַעַן֩ אֲשֶׁ֨ר יְצַוֶּ֜ה אֶת־בָּנָ֤יו וְאֶת־בֵּיתֹו֙ אַחֲרָ֔יו וְשָֽׁמְרוּ֙ דֶּ֣רֶךְ יְהוָ֔ה לַעֲשֹׂ֥ות צְדָקָ֖ה וּמִשְׁפָּ֑ט לְמַ֗עַן הָבִ֤יא יְהוָה֙ עַל־אַבְרָהָ֔ם אֵ֥ת אֲשֶׁר־דִּבֶּ֖ר עָלָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","וַיֹּ֣אמֶר יְהוָ֔ה זַעֲקַ֛ת סְדֹ֥ם וַעֲמֹרָ֖ה כִּי־רָ֑בָּה וְחַ֨טָּאתָ֔ם כִּ֥י כָבְדָ֖ה מְאֹֽד׃ ");
INSERT INTO hbo_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","אֵֽרֲדָה־נָּ֣א וְאֶרְאֶ֔ה הַכְּצַעֲקָתָ֛הּ הַבָּ֥אָה אֵלַ֖י עָשׂ֣וּ ׀ כָּלָ֑ה וְאִם־לֹ֖א אֵדָֽעָה׃ ");
INSERT INTO hbo_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","וַיִּפְנ֤וּ מִשָּׁם֙ הֽ͏ָאֲנָשִׁ֔ים וַיֵּלְכ֖וּ סְדֹ֑מָה וְאַ֨בְרָהָ֔ם עֹודֶ֥נּוּ עֹמֵ֖ד לִפְנֵ֥י יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","וַיִּגַּ֥שׁ אַבְרָהָ֖ם וַיֹּאמַ֑ר הַאַ֣ף תִּסְפֶּ֔ה צַדִּ֖יק עִם־רָשָֽׁע׃ ");
INSERT INTO hbo_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","אוּלַ֥י יֵ֛שׁ חֲמִשִּׁ֥ים צַדִּיקִ֖ם בְּתֹ֣וךְ הָעִ֑יר הַאַ֤ף תִּסְפֶּה֙ וְלֹא־תִשָּׂ֣א לַמָּקֹ֔ום לְמַ֛עַן חֲמִשִּׁ֥ים הַצַּדִּיקִ֖ם אֲשֶׁ֥ר בְּקִרְבָּֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","חָלִ֨לָה לְּךָ֜ מֵעֲשֹׂ֣ת ׀ כַּדָּבָ֣ר הַזֶּ֗ה לְהָמִ֤ית צַדִּיק֙ עִם־רָשָׁ֔ע וְהָיָ֥ה כַצַּדִּ֖יק כָּרָשָׁ֑ע חָלִ֣לָה לָּ֔ךְ הֲשֹׁפֵט֙ כָּל־הָאָ֔רֶץ לֹ֥א יַעֲשֶׂ֖ה מִשְׁפָּֽט׃ ");
INSERT INTO hbo_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","וַיֹּ֣אמֶר יְהוָ֔ה אִם־אֶמְצָ֥א בִסְדֹ֛ם חֲמִשִּׁ֥ים צַדִּיקִ֖ם בְּתֹ֣וךְ הָעִ֑יר וְנָשָׂ֥אתִי לְכָל־הַמָּקֹ֖ום בַּעֲבוּרָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","וַיַּ֥עַן אַבְרָהָ֖ם וַיֹּאמַ֑ר הִנֵּה־נָ֤א הֹואַ֙לְתִּי֙ לְדַבֵּ֣ר אֶל־אֲדֹנָ֔י וְאָנֹכִ֖י עָפָ֥ר וָאֵֽפֶר׃ ");
INSERT INTO hbo_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","א֠וּלַי יַחְסְר֞וּן חֲמִשִּׁ֤ים הַצַּדִּיקִם֙ חֲמִשָּׁ֔ה הֲתַשְׁחִ֥ית בַּחֲמִשָּׁ֖ה אֶת־כָּל־הָעִ֑יר וַיֹּ֙אמֶר֙ לֹ֣א אַשְׁחִ֔ית אִם־אֶמְצָ֣א שָׁ֔ם אַרְבָּעִ֖ים וַחֲמִשָּֽׁה׃ ");
INSERT INTO hbo_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","וַיֹּ֨סֶף עֹ֜וד לְדַבֵּ֤ר אֵלָיו֙ וַיֹּאמַ֔ר אוּלַ֛י יִמָּצְא֥וּן שָׁ֖ם אַרְבָּעִ֑ים וַיֹּ֙אמֶר֙ לֹ֣א אֽ͏ֶעֱשֶׂ֔ה בַּעֲב֖וּר הָאַרְבָּעִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","וַ֠יֹּאמֶר אַל־נָ֞א יִ֤חַר לֽ͏ַאדֹנָי֙ וַאֲדַבֵּ֔רָה אוּלַ֛י יִמָּצְא֥וּן שָׁ֖ם שְׁלֹשִׁ֑ים וַיֹּ֙אמֶר֙ לֹ֣א אֽ͏ֶעֱשֶׂ֔ה אִם־אֶמְצָ֥א שָׁ֖ם שְׁלֹשִֽׁים׃ ");
INSERT INTO hbo_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","וַיֹּ֗אמֶר הִנֵּֽה־נָ֤א הֹואַ֙לְתִּי֙ לְדַבֵּ֣ר אֶל־אֲדֹנָ֔י אוּלַ֛י יִמָּצְא֥וּן שָׁ֖ם עֶשְׂרִ֑ים וַיֹּ֙אמֶר֙ לֹ֣א אַשְׁחִ֔ית בַּעֲב֖וּר הֽ͏ָעֶשְׂרִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","וַ֠יֹּאמֶר אַל־נָ֞א יִ֤חַר לַֽאדֹנָי֙ וַאֲדַבְּרָ֣ה אַךְ־הַפַּ֔עַם אוּלַ֛י יִמָּצְא֥וּן שָׁ֖ם עֲשָׂרָ֑ה וַיֹּ֙אמֶר֙ לֹ֣א אַשְׁחִ֔ית בַּעֲב֖וּר הָעֲשָׂרָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","וַיֵּ֣לֶךְ יְהוָ֔ה כַּאֲשֶׁ֣ר כִּלָּ֔ה לְדַבֵּ֖ר אֶל־אַבְרָהָ֑ם וְאַבְרָהָ֖ם שָׁ֥ב לִמְקֹמֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","וַ֠יָּבֹאוּ שְׁנֵ֨י הַמַּלְאָכִ֤ים סְדֹ֙מָה֙ בָּעֶ֔רֶב וְלֹ֖וט יֹשֵׁ֣ב בְּשַֽׁעַר־סְדֹ֑ם וַיַּרְא־לֹוט֙ וַיָּ֣קָם לִקְרָאתָ֔ם וַיִּשְׁתַּ֥חוּ אַפַּ֖יִם אָֽרְצָה׃ ");
INSERT INTO hbo_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","וַיֹּ֜אמֶר הִנֶּ֣ה נָּא־אֲדֹנַ֗י ס֣וּרוּ נָ֠א אֶל־בֵּ֨ית עַבְדְּכֶ֤ם וְלִ֙ינוּ֙ וְרַחֲצ֣וּ רַגְלֵיכֶ֔ם וְהִשְׁכַּמְתֶּ֖ם וַהֲלַכְתֶּ֣ם לְדַרְכְּכֶ֑ם וַיֹּאמְר֣וּ לֹּ֔א כִּ֥י בָרְחֹ֖וב נָלִֽין׃ ");
INSERT INTO hbo_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","וַיִּפְצַר־בָּ֣ם מְאֹ֔ד וַיָּסֻ֣רוּ אֵלָ֔יו וַיָּבֹ֖אוּ אֶל־בֵּיתֹ֑ו וַיַּ֤עַשׂ לָהֶם֙ מִשְׁתֶּ֔ה וּמַצֹּ֥ות אָפָ֖ה וַיֹּאכֵֽלוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","טֶרֶם֮ יִשְׁכָּבוּ֒ וְאַנְשֵׁ֨י הָעִ֜יר אַנְשֵׁ֤י סְדֹם֙ נָסַ֣בּוּ עַל־הַבַּ֔יִת מִנַּ֖עַר וְעַד־זָקֵ֑ן כָּל־הָעָ֖ם מִקָּצֶֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","וַיִּקְרְא֤וּ אֶל־לֹוט֙ וַיֹּ֣אמְרוּ לֹ֔ו אַיֵּ֧ה הָאֲנָשִׁ֛ים אֲשֶׁר־בָּ֥אוּ אֵלֶ֖יךָ הַלָּ֑יְלָה הֹוצִיאֵ֣ם אֵלֵ֔ינוּ וְנֵדְעָ֖ה אֹתָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","וַיֵּצֵ֧א אֲלֵהֶ֛ם לֹ֖וט הַפֶּ֑תְחָה וְהַדֶּ֖לֶת סָגַ֥ר אַחֲרָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","וַיֹּאמַ֑ר אַל־נָ֥א אַחַ֖י תָּרֵֽעוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","הִנֵּה־נָ֨א לִ֜י שְׁתֵּ֣י בָנֹ֗ות אֲשֶׁ֤ר לֹֽא־יָדְעוּ֙ אִ֔ישׁ אֹוצִֽיאָה־נָּ֤א אֶתְהֶן֙ אֲלֵיכֶ֔ם וַעֲשׂ֣וּ לָהֶ֔ן כַּטֹּ֖וב בְּעֵינֵיכֶ֑ם רַ֠ק לָֽאֲנָשִׁ֤ים הָאֵל֙ אַל־תַּעֲשׂ֣וּ דָבָ֔ר כִּֽי־עַל־כֵּ֥ן בָּ֖אוּ בְּצֵ֥ל קֹרָתִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","וַיֹּאמְר֣וּ ׀ גֶּשׁ־הָ֗לְאָה וַיֹּֽאמְרוּ֙ הָאֶחָ֤ד בָּֽא־לָגוּר֙ וַיִּשְׁפֹּ֣ט שָׁפֹ֔וט עַתָּ֕ה נָרַ֥ע לְךָ֖ מֵהֶ֑ם וַיִּפְצְר֨וּ בָאִ֤ישׁ בְּלֹוט֙ מְאֹ֔ד וַֽיִּגְּשׁ֖וּ לִשְׁבֹּ֥ר הַדָּֽלֶת׃ ");
INSERT INTO hbo_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","וַיִּשְׁלְח֤וּ הֽ͏ָאֲנָשִׁים֙ אֶת־יָדָ֔ם וַיָּבִ֧יאוּ אֶת־לֹ֛וט אֲלֵיהֶ֖ם הַבָּ֑יְתָה וְאֶת־הַדֶּ֖לֶת סָגָֽרוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","וְֽאֶת־הָאֲנָשִׁ֞ים אֲשֶׁר־פֶּ֣תַח הַבַּ֗יִת הִכּוּ֙ בַּסַּנְוֵרִ֔ים מִקָּטֹ֖ן וְעַד־גָּדֹ֑ול וַיִּלְא֖וּ לִמְצֹ֥א הַפָּֽתַח׃ ");
INSERT INTO hbo_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","וַיֹּאמְר֨וּ הָאֲנָשִׁ֜ים אֶל־לֹ֗וט עֹ֚ד מִֽי־לְךָ֣ פֹ֔ה חָתָן֙ וּבָנֶ֣יךָ וּבְנֹתֶ֔יךָ וְכֹ֥ל אֲשֶׁר־לְךָ֖ בָּעִ֑יר הֹוצֵ֖א מִן־הַמָּקֹֽום׃ ");
INSERT INTO hbo_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","כִּֽי־מַשְׁחִתִ֣ים אֲנַ֔חְנוּ אֶת־הַמָּקֹ֖ום הַזֶּ֑ה כִּֽי־גֽ͏ָדְלָ֤ה צַעֲקָתָם֙ אֶת־פְּנֵ֣י יְהוָ֔ה וַיְשַׁלְּחֵ֥נוּ יְהוָ֖ה לְשַׁחֲתָֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","וַיֵּצֵ֨א לֹ֜וט וַיְדַבֵּ֣ר ׀ אֶל־חֲתָנָ֣יו ׀ לֹקְחֵ֣י בְנֹתָ֗יו וַיֹּ֙אמֶר֙ ק֤וּמוּ צְּאוּ֙ מִן־הַמָּקֹ֣ום הַזֶּ֔ה כִּֽי־מַשְׁחִ֥ית יְהוָ֖ה אֶת־הָעִ֑יר וַיְהִ֥י כִמְצַחֵ֖ק בְּעֵינֵ֥י חֲתָנָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","וּכְמֹו֙ הַשַּׁ֣חַר עָלָ֔ה וַיָּאִ֥יצוּ הַמַּלְאָכִ֖ים בְּלֹ֣וט לֵאמֹ֑ר קוּם֩ קַ֨ח אֶֽת־אִשְׁתְּךָ֜ וְאֶת־שְׁתֵּ֤י בְנֹתֶ֙יךָ֙ הַנִּמְצָאֹ֔ת פֶּן־תִּסָּפֶ֖ה בַּעֲוֹ֥ן הָעִֽיר׃ ");
INSERT INTO hbo_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","וֽ͏ַיִּתְמַהְמָ֓הּ ׀ וַיַּחֲזִ֨קוּ הָאֲנָשִׁ֜ים בְּיָדֹ֣ו וּבְיַד־אִשְׁתֹּ֗ו וּבְיַד֙ שְׁתֵּ֣י בְנֹתָ֔יו בְּחֶמְלַ֥ת יְהוָ֖ה עָלָ֑יו וַיֹּצִאֻ֥הוּ וַיַּנִּחֻ֖הוּ מִח֥וּץ לָעִֽיר׃ ");
INSERT INTO hbo_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","וַיְהִי֩ כְהֹוצִיאָ֨ם אֹתָ֜ם הַח֗וּצָה וַיֹּ֙אמֶר֙ הִמָּלֵ֣ט עַל־נַפְשֶׁ֔ךָ אַל־תַּבִּ֣יט אַחֲרֶ֔יךָ וְאַֽל־תַּעֲמֹ֖ד בְּכָל־הַכִּכָּ֑ר הָהָ֥רָה הִמָּלֵ֖ט פֶּן־תִּסָּפֶֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","וַיֹּ֥אמֶר לֹ֖וט אֲלֵהֶ֑ם אַל־נָ֖א אֲדֹנָֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","הִנֵּה־נָ֠א מָצָ֨א עַבְדְּךָ֣ חֵן֮ בְּעֵינֶיךָ֒ וַתַּגְדֵּ֣ל חַסְדְּךָ֗ אֲשֶׁ֤ר עָשִׂ֙יתָ֙ עִמָּדִ֔י לְהַחֲיֹ֖ות אֶת־נַפְשִׁ֑י וְאָנֹכִ֗י לֹ֤א אוּכַל֙ לְהִמָּלֵ֣ט הָהָ֔רָה פֶּן־תִּדְבָּקַ֥נִי הָרָעָ֖ה וָמַֽתִּי׃ ");
INSERT INTO hbo_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","הִנֵּה־נָ֠א הָעִ֨יר הַזֹּ֧את קְרֹבָ֛ה לָנ֥וּס שָׁ֖מָּה וְהִ֣יא מִצְעָ֑ר אִמָּלְטָ֨ה נָּ֜א שָׁ֗מָּה הֲלֹ֥א מִצְעָ֛ר הִ֖וא וּתְחִ֥י נַפְשִֽׁי׃ ");
INSERT INTO hbo_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","וַיֹּ֣אמֶר אֵלָ֔יו הִנֵּה֙ נָשָׂ֣אתִי פָנֶ֔יךָ גַּ֖ם לַדָּבָ֣ר הַזֶּ֑ה לְבִלְתִּ֛י הָפְכִּ֥י אֶת־הָעִ֖יר אֲשֶׁ֥ר דִּבַּֽרְתָּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","מַהֵר֙ הִמָּלֵ֣ט שָׁ֔מָּה כִּ֣י לֹ֤א אוּכַל֙ לַעֲשֹׂ֣ות דָּבָ֔ר עַד־בֹּאֲךָ֖ שָׁ֑מָּה עַל־כֵּ֛ן קָרָ֥א שֵׁם־הָעִ֖יר צֹֽועַר׃ ");
INSERT INTO hbo_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","הַשֶּׁ֖מֶשׁ יָצָ֣א עַל־הָאָ֑רֶץ וְלֹ֖וט בָּ֥א צֹֽעֲרָה׃ ");
INSERT INTO hbo_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","וֽ͏ַיהוָ֗ה הִמְטִ֧יר עַל־סְדֹ֛ם וְעַל־עֲמֹרָ֖ה גָּפְרִ֣ית וָאֵ֑שׁ מֵאֵ֥ת יְהוָ֖ה מִן־הַשָּׁמָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","וֽ͏ַיַּהֲפֹךְ֙ אֶת־הֶעָרִ֣ים הָאֵ֔ל וְאֵ֖ת כָּל־הַכִּכָּ֑ר וְאֵת֙ כָּל־יֹשְׁבֵ֣י הֶעָרִ֔ים וְצֶ֖מַח הָאֲדָמָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","וַתַּבֵּ֥ט אִשְׁתֹּ֖ו מֵאַחֲרָ֑יו וַתְּהִ֖י נְצִ֥יב מֶֽלַח׃ ");
INSERT INTO hbo_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","וַיַּשְׁכֵּ֥ם אַבְרָהָ֖ם בַּבֹּ֑קֶר אֶל־הַ֨מָּקֹ֔ום אֲשֶׁר־עָ֥מַד שָׁ֖ם אֶת־פְּנֵ֥י יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","וַיַּשְׁקֵ֗ף עַל־פְּנֵ֤י סְדֹם֙ וַעֲמֹרָ֔ה וְעַֽל־כָּל־פְּנֵ֖י אֶ֣רֶץ הַכִּכָּ֑ר וַיַּ֗רְא וְהִנֵּ֤ה עָלָה֙ קִיטֹ֣ר הָאָ֔רֶץ כְּקִיטֹ֖ר הַכִּבְשָֽׁן׃ ");
INSERT INTO hbo_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","וַיְהִ֗י בְּשַׁחֵ֤ת אֱלֹהִים֙ אֶת־עָרֵ֣י הַכִּכָּ֔ר וַיִּזְכֹּ֥ר אֱלֹהִ֖ים אֶת־אַבְרָהָ֑ם וַיְשַׁלַּ֤ח אֶת־לֹוט֙ מִתֹּ֣וךְ הַהֲפֵכָ֔ה בַּהֲפֹךְ֙ אֶת־הֶ֣עָרִ֔ים אֲשֶׁר־יָשַׁ֥ב בָּהֵ֖ן לֹֽוט׃ ");
INSERT INTO hbo_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","וַיַּעַל֩ לֹ֨וט מִצֹּ֜ועַר וַיֵּ֣שֶׁב בָּהָ֗ר וּשְׁתֵּ֤י בְנֹתָיו֙ עִמֹּ֔ו כִּ֥י יָרֵ֖א לָשֶׁ֣בֶת בְּצֹ֑ועַר וַיֵּ֙שֶׁב֙ בַּמְּעָרָ֔ה ה֖וּא וּשְׁתֵּ֥י בְנֹתָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","וַתֹּ֧אמֶר הַבְּכִירָ֛ה אֶל־הַצְּעִירָ֖ה אָבִ֣ינוּ זָקֵ֑ן וְאִ֨ישׁ אֵ֤ין בָּאָ֙רֶץ֙ לָבֹ֣וא עָלֵ֔ינוּ כְּדֶ֖רֶךְ כָּל־הָאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","לְכָ֨ה נַשְׁקֶ֧ה אֶת־אָבִ֛ינוּ יַ֖יִן וְנִשְׁכְּבָ֣ה עִמֹּ֑ו וּנְחַיֶּ֥ה מֵאָבִ֖ינוּ זָֽרַע׃ ");
INSERT INTO hbo_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","וַתַּשְׁקֶ֧יןָ אֶת־אֲבִיהֶ֛ן יַ֖יִן בַּלַּ֣יְלָה ה֑וּא וַתָּבֹ֤א הַבְּכִירָה֙ וַתִּשְׁכַּ֣ב אֶת־אָבִ֔יהָ וְלֹֽא־יָדַ֥ע בְּשִׁכְבָ֖הּ וּבְקוּׄמָֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","וֽ͏ַיְהִי֙ מִֽמָּחֳרָ֔ת וַתֹּ֤אמֶר הַבְּכִירָה֙ אֶל־הַצְּעִירָ֔ה הֵן־שָׁכַ֥בְתִּי אֶ֖מֶשׁ אֶת־אָבִ֑י נַשְׁקֶ֨נּוּ יַ֜יִן גַּם־הַלַּ֗יְלָה וּבֹ֙אִי֙ שִׁכְבִ֣י עִמֹּ֔ו וּנְחַיֶּ֥ה מֵאָבִ֖ינוּ זָֽרַע׃ ");
INSERT INTO hbo_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","וַתַּשְׁקֶ֜יןָ גַּ֣ם בַּלַּ֧יְלָה הַה֛וּא אֶת־אֲבִיהֶ֖ן יָ֑יִן וַתָּ֤קָם הַצְּעִירָה֙ וַתִּשְׁכַּ֣ב עִמֹּ֔ו וְלֹֽא־יָדַ֥ע בְּשִׁכְבָ֖הּ וּבְקֻמָֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","וֽ͏ַתַּהֲרֶ֛יןָ שְׁתֵּ֥י בְנֹֽות־לֹ֖וט מֵאֲבִיהֶֽן׃ ");
INSERT INTO hbo_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","וַתֵּ֤לֶד הַבְּכִירָה֙ בֵּ֔ן וַתִּקְרָ֥א שְׁמֹ֖ו מֹואָ֑ב ה֥וּא אֲבִֽי־מֹואָ֖ב עַד־הַיֹּֽום׃ ");
INSERT INTO hbo_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","וְהַצְּעִירָ֤ה גַם־הִוא֙ יָ֣לְדָה בֵּ֔ן וַתִּקְרָ֥א שְׁמֹ֖ו בֶּן־עַמִּ֑י ה֛וּא אֲבִ֥י בְנֵֽי־עַמֹּ֖ון עַד־הַיֹּֽום׃ ס ");
INSERT INTO hbo_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","וַיִּסַּ֨ע מִשָּׁ֤ם אַבְרָהָם֙ אַ֣רְצָה הַנֶּ֔גֶב וַיֵּ֥שֶׁב בֵּין־קָדֵ֖שׁ וּבֵ֣ין שׁ֑וּר וַיָּ֖גָר בִּגְרָֽר׃ ");
INSERT INTO hbo_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","וַיֹּ֧אמֶר אַבְרָהָ֛ם אֶל־שָׂרָ֥ה אִשְׁתֹּ֖ו אֲחֹ֣תִי הִ֑וא וַיִּשְׁלַ֗ח אֲבִימֶ֙לֶךְ֙ מֶ֣לֶךְ גְּרָ֔ר וַיִּקַּ֖ח אֶת־שָׂרָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","וַיָּבֹ֧א אֱלֹהִ֛ים אֶל־אֲבִימֶ֖לֶךְ בַּחֲלֹ֣ום הַלָּ֑יְלָה וַיֹּ֣אמֶר לֹ֗ו הִנְּךָ֥ מֵת֙ עַל־הָאִשָּׁ֣ה אֲשֶׁר־לָקַ֔חְתָּ וְהִ֖וא בְּעֻ֥לַת בָּֽעַל׃ ");
INSERT INTO hbo_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","וַאֲבִימֶ֕לֶךְ לֹ֥א קָרַ֖ב אֵלֶ֑יהָ וַיֹּאמַ֕ר אֲדֹנָ֕י הֲגֹ֥וי גַּם־צַדִּ֖יק תַּהֲרֹֽג׃ ");
INSERT INTO hbo_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","הֲלֹ֨א ה֤וּא אָֽמַר־לִי֙ אֲחֹ֣תִי הִ֔וא וְהִֽיא־גַם־הִ֥וא אֽ͏ָמְרָ֖ה אָחִ֣י ה֑וּא בְּתָם־לְבָבִ֛י וּבְנִקְיֹ֥ן כַּפַּ֖י עָשִׂ֥יתִי זֹֽאת׃ ");
INSERT INTO hbo_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","וַיֹּאמֶר֩ אֵלָ֨יו הֽ͏ָאֱלֹהִ֜ים בַּחֲלֹ֗ם גַּ֣ם אָנֹכִ֤י יָדַ֙עְתִּי֙ כִּ֤י בְתָם־לְבָבְךָ֙ עָשִׂ֣יתָ זֹּ֔את וָאֶחְשֹׂ֧ךְ גַּם־אָנֹכִ֛י אֹֽותְךָ֖ מֵחֲטֹו־לִ֑י עַל־כֵּ֥ן לֹא־נְתַתִּ֖יךָ לִנְגֹּ֥עַ אֵלֶֽיהָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","וְעַתָּ֗ה הָשֵׁ֤ב אֵֽשֶׁת־הָאִישׁ֙ כִּֽי־נָבִ֣יא ה֔וּא וְיִתְפַּלֵּ֥ל בּֽ͏ַעַדְךָ֖ וֶֽחְיֵ֑ה וְאִם־אֵֽינְךָ֣ מֵשִׁ֗יב דַּ֚ע כִּי־מֹ֣ות תָּמ֔וּת אַתָּ֖ה וְכָל־אֲשֶׁר־לָֽךְ׃ ");
INSERT INTO hbo_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","וַיַּשְׁכֵּ֨ם אֲבִימֶ֜לֶךְ בַּבֹּ֗קֶר וַיִּקְרָא֙ לְכָל־עֲבָדָ֔יו וַיְדַבֵּ֛ר אֶת־כָּל־הַדְּבָרִ֥ים הָאֵ֖לֶּה בְּאָזְנֵיהֶ֑ם וַיִּֽירְא֥וּ הָאֲנָשִׁ֖ים מְאֹֽד׃ ");
INSERT INTO hbo_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","וַיִּקְרָ֨א אֲבִימֶ֜לֶךְ לְאַבְרָהָ֗ם וַיֹּ֨אמֶר לֹ֜ו מֶֽה־עָשִׂ֤יתָ לָּ֙נוּ֙ וּמֶֽה־חָטָ֣אתִי לָ֔ךְ כִּֽי־הֵבֵ֧אתָ עָלַ֛י וְעַל־מַמְלַכְתִּ֖י חֲטָאָ֣ה גְדֹלָ֑ה מַעֲשִׂים֙ אֲשֶׁ֣ר לֹא־יֵֽעָשׂ֔וּ עָשִׂ֖יתָ עִמָּדִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","וַיֹּ֥אמֶר אֲבִימֶ֖לֶךְ אֶל־אַבְרָהָ֑ם מָ֣ה רָאִ֔יתָ כִּ֥י עָשִׂ֖יתָ אֶת־הַדָּבָ֥ר הַזֶּֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","וַיֹּ֙אמֶר֙ אַבְרָהָ֔ם כִּ֣י אָמַ֗רְתִּי רַ֚ק אֵין־יִרְאַ֣ת אֱלֹהִ֔ים בַּמָּקֹ֖ום הַזֶּ֑ה וַהֲרָג֖וּנִי עַל־דְּבַ֥ר אִשְׁתִּֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","וְגַם־אָמְנָ֗ה אֲחֹתִ֤י בַת־אָבִי֙ הִ֔וא אַ֖ךְ לֹ֣א בַת־אִמִּ֑י וַתְּהִי־לִ֖י לְאִשָּֽׁה׃ ");
INSERT INTO hbo_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","וַיְהִ֞י כַּאֲשֶׁ֧ר הִתְע֣וּ אֹתִ֗י אֱלֹהִים֮ מִבֵּ֣ית אָבִי֒ וָאֹמַ֣ר לָ֔הּ זֶ֣ה חַסְדֵּ֔ךְ אֲשֶׁ֥ר תַּעֲשִׂ֖י עִמָּדִ֑י אֶ֤ל כָּל־הַמָּקֹום֙ אֲשֶׁ֣ר נָבֹ֣וא שָׁ֔מָּה אִמְרִי־לִ֖י אָחִ֥י הֽוּא׃ ");
INSERT INTO hbo_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","וַיִּקַּ֨ח אֲבִימֶ֜לֶךְ צֹ֣אן וּבָקָ֗ר וַעֲבָדִים֙ וּשְׁפָחֹ֔ת וַיִּתֵּ֖ן לְאַבְרָהָ֑ם וַיָּ֣שֶׁב לֹ֔ו אֵ֖ת שָׂרָ֥ה אִשְׁתֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","וַיֹּ֣אמֶר אֲבִימֶ֔לֶךְ הִנֵּ֥ה אַרְצִ֖י לְפָנֶ֑יךָ בַּטֹּ֥וב בְּעֵינֶ֖יךָ שֵֽׁב׃ ");
INSERT INTO hbo_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","וּלְשָׂרָ֣ה אָמַ֗ר הִנֵּ֨ה נָתַ֜תִּי אֶ֤לֶף כֶּ֙סֶף֙ לְאָחִ֔יךְ הִנֵּ֤ה הוּא־לָךְ֙ כְּס֣וּת עֵינַ֔יִם לְכֹ֖ל אֲשֶׁ֣ר אִתָּ֑ךְ וְאֵ֥ת כֹּ֖ל וְנֹכָֽחַת׃ ");
INSERT INTO hbo_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","וַיִּתְפַּלֵּ֥ל אַבְרָהָ֖ם אֶל־הָאֱלֹהִ֑ים וַיִּרְפָּ֨א אֱלֹהִ֜ים אֶת־אֲבִימֶ֧לֶךְ וְאֶת־אִשְׁתֹּ֛ו וְאַמְהֹתָ֖יו וַיֵּלֵֽדוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","כִּֽי־עָצֹ֤ר עָצַר֙ יְהוָ֔ה בְּעַ֥ד כָּל־רֶ֖חֶם לְבֵ֣ית אֲבִימֶ֑לֶךְ עַל־דְּבַ֥ר שָׂרָ֖ה אֵ֥שֶׁת אַבְרָהָֽם׃ ס ");
INSERT INTO hbo_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","וֽ͏ַיהוָ֛ה פָּקַ֥ד אֶת־שָׂרָ֖ה כַּאֲשֶׁ֣ר אָמָ֑ר וַיַּ֧עַשׂ יְהוָ֛ה לְשָׂרָ֖ה כַּאֲשֶׁ֥ר דִּבֵּֽר׃ ");
INSERT INTO hbo_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","וַתַּהַר֩ וַתֵּ֨לֶד שָׂרָ֧ה לְאַבְרָהָ֛ם בֵּ֖ן לִזְקֻנָ֑יו לַמֹּועֵ֕ד אֲשֶׁר־דִּבֶּ֥ר אֹתֹ֖ו אֱלֹהִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","וַיִּקְרָ֨א אַבְרָהָ֜ם אֶֽת־שֶׁם־בְּנֹ֧ו הַנֹּֽולַד־לֹ֛ו אֲשֶׁר־יָלְדָה־לֹּ֥ו שָׂרָ֖ה יִצְחָֽק׃ ");
INSERT INTO hbo_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","וַיָּ֤מָל אַבְרָהָם֙ אֶת־יִצְחָ֣ק בְּנֹ֔ו בֶּן־שְׁמֹנַ֖ת יָמִ֑ים כַּאֲשֶׁ֛ר צִוָּ֥ה אֹתֹ֖ו אֱלֹהִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","וְאַבְרָהָ֖ם בֶּן־מְאַ֣ת שָׁנָ֑ה בְּהִוָּ֣לֶד לֹ֔ו אֵ֖ת יִצְחָ֥ק בְּנֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","וַתֹּ֣אמֶר שָׂרָ֔ה צְחֹ֕ק עָ֥שָׂה לִ֖י אֱלֹהִ֑ים כָּל־הַשֹּׁמֵ֖עַ יִֽצְחַק־לִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","וַתֹּ֗אמֶר מִ֤י מִלֵּל֙ לְאַבְרָהָ֔ם הֵינִ֥יקָה בָנִ֖ים שָׂרָ֑ה כִּֽי־יָלַ֥דְתִּי בֵ֖ן לִזְקֻנָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","וַיִּגְדַּ֥ל הַיֶּ֖לֶד וַיִּגָּמַ֑ל וַיַּ֤עַשׂ אַבְרָהָם֙ מִשְׁתֶּ֣ה גָדֹ֔ול בְּיֹ֖ום הִגָּמֵ֥ל אֶת־יִצְחָֽק׃ ");
INSERT INTO hbo_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","וַתֵּ֨רֶא שָׂרָ֜ה אֶֽת־בֶּן־הָגָ֧ר הַמִּצְרִ֛ית אֲשֶׁר־יָלְדָ֥ה לְאַבְרָהָ֖ם מְצַחֵֽק׃ ");
INSERT INTO hbo_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","וַתֹּ֙אמֶר֙ לְאַבְרָהָ֔ם גָּרֵ֛שׁ הָאָמָ֥ה הַזֹּ֖את וְאֶת־בְּנָ֑הּ כִּ֣י לֹ֤א יִירַשׁ֙ בֶּן־הָאָמָ֣ה הַזֹּ֔את עִם־בְּנִ֖י עִם־יִצְחָֽק׃ ");
INSERT INTO hbo_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","וַיֵּ֧רַע הַדָּבָ֛ר מְאֹ֖ד בְּעֵינֵ֣י אַבְרָהָ֑ם עַ֖ל אֹודֹ֥ת בְּנֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","וַיֹּ֨אמֶר אֱלֹהִ֜ים אֶל־אַבְרָהָ֗ם אַל־יֵרַ֤ע בְּעֵינֶ֙יךָ֙ עַל־הַנַּ֣עַר וְעַל־אֲמָתֶ֔ךָ כֹּל֩ אֲשֶׁ֨ר תֹּאמַ֥ר אֵלֶ֛יךָ שָׂרָ֖ה שְׁמַ֣ע בְּקֹלָ֑הּ כִּ֣י בְיִצְחָ֔ק יִקָּרֵ֥א לְךָ֖ זָֽרַע׃ ");
INSERT INTO hbo_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","וְגַ֥ם אֶת־בֶּן־הָאָמָ֖ה לְגֹ֣וי אֲשִׂימֶ֑נּוּ כִּ֥י זַרְעֲךָ֖ הֽוּא׃ ");
INSERT INTO hbo_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","וַיַּשְׁכֵּ֣ם אַבְרָהָ֣ם ׀ בַּבֹּ֡קֶר וַיִּֽקַּֽח־לֶחֶם֩ וְחֵ֨מַת מַ֜יִם וַיִּתֵּ֣ן אֶל־הָ֠גָר שָׂ֧ם עַל־שִׁכְמָ֛הּ וְאֶת־הַיֶּ֖לֶד וַֽיְשַׁלְּחֶ֑הָ וַתֵּ֣לֶךְ וַתֵּ֔תַע בְּמִדְבַּ֖ר בְּאֵ֥ר שָֽׁבַע׃ ");
INSERT INTO hbo_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","וַיִּכְל֥וּ הַמַּ֖יִם מִן־הַחֵ֑מֶת וַתַּשְׁלֵ֣ךְ אֶת־הַיֶּ֔לֶד תַּ֖חַת אַחַ֥ד הַשִּׂיחִֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","וַתֵּלֶךְ֩ וַתֵּ֨שֶׁב לָ֜הּ מִנֶּ֗גֶד הַרְחֵק֙ כִּמְטַחֲוֵ֣י קֶ֔שֶׁת כִּ֣י אֽ͏ָמְרָ֔ה אַל־אֶרְאֶ֖ה בְּמֹ֣ות הַיָּ֑לֶד וַתֵּ֣שֶׁב מִנֶּ֔גֶד וַתִּשָּׂ֥א אֶת־קֹלָ֖הּ וַתֵּֽבְךְּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","וַיִּשְׁמַ֣ע אֱלֹהִים֮ אֶת־קֹ֣ול הַנַּעַר֒ וַיִּקְרָא֩ מַלְאַ֨ךְ אֱלֹהִ֤ים ׀ אֶל־הָגָר֙ מִן־הַשָּׁמַ֔יִם וַיֹּ֥אמֶר לָ֖הּ מַה־לָּ֣ךְ הָגָ֑ר אַל־תִּ֣ירְאִ֔י כִּֽי־שָׁמַ֧ע אֱלֹהִ֛ים אֶל־קֹ֥ול הַנַּ֖עַר בַּאֲשֶׁ֥ר הוּא־שָֽׁם׃ ");
INSERT INTO hbo_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","ק֚וּמִי שְׂאִ֣י אֶת־הַנַּ֔עַר וְהַחֲזִ֥יקִי אֶת־יָדֵ֖ךְ בֹּ֑ו כִּֽי־לְגֹ֥וי גָּדֹ֖ול אֲשִׂימֶֽנּוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","וַיִּפְקַ֤ח אֱלֹהִים֙ אֶת־עֵינֶ֔יהָ וַתֵּ֖רֶא בְּאֵ֣ר מָ֑יִם וַתֵּ֜לֶךְ וַתְּמַלֵּ֤א אֶת־הַחֵ֙מֶת֙ מַ֔יִם וַתַּ֖שְׁקְ אֶת־הַנָּֽעַר׃ ");
INSERT INTO hbo_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","וַיְהִ֧י אֱלֹהִ֛ים אֶת־הַנַּ֖עַר וַיִּגְדָּ֑ל וַיֵּ֙שֶׁב֙ בַּמִּדְבָּ֔ר וַיְהִ֖י רֹבֶ֥ה קַשָּֽׁת׃ ");
INSERT INTO hbo_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","וַיֵּ֖שֶׁב בְּמִדְבַּ֣ר פָּארָ֑ן וַתִּֽקַּֽח־לֹ֥ו אִמֹּ֛ו אִשָּׁ֖ה מֵאֶ֥רֶץ מִצְרָֽיִם׃ פ ");
INSERT INTO hbo_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","וֽ͏ַיְהִי֙ בָּעֵ֣ת הַהִ֔וא וַיֹּ֣אמֶר אֲבִימֶ֗לֶךְ וּפִיכֹל֙ שַׂר־צְבָאֹ֔ו אֶל־אַבְרָהָ֖ם לֵאמֹ֑ר אֱלֹהִ֣ים עִמְּךָ֔ בְּכֹ֥ל אֲשֶׁר־אַתָּ֖ה עֹשֶֽׂה׃ ");
INSERT INTO hbo_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","וְעַתָּ֗ה הִשָּׁ֨בְעָה לִּ֤י בֵֽאלֹהִים֙ הֵ֔נָּה אִם־תִּשְׁקֹ֣ר לִ֔י וּלְנִינִ֖י וּלְנֶכְדִּ֑י כַּחֶ֜סֶד אֲשֶׁר־עָשִׂ֤יתִי עִמְּךָ֙ תַּעֲשֶׂ֣ה עִמָּדִ֔י וְעִם־הָאָ֖רֶץ אֲשֶׁר־גַּ֥רְתָּה בָּֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","וַיֹּ֙אמֶר֙ אַבְרָהָ֔ם אָנֹכִ֖י אִשָּׁבֵֽעַ׃ ");
INSERT INTO hbo_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","וְהֹוכִ֥חַ אַבְרָהָ֖ם אֶת־אֲבִימֶ֑לֶךְ עַל־אֹדֹות֙ בְּאֵ֣ר הַמַּ֔יִם אֲשֶׁ֥ר גָּזְל֖וּ עַבְדֵ֥י אֲבִימֶֽלֶךְ׃ ");
INSERT INTO hbo_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","וַיֹּ֣אמֶר אֲבִימֶ֔לֶךְ לֹ֣א יָדַ֔עְתִּי מִ֥י עָשָׂ֖ה אֶת־הַדָּבָ֣ר הַזֶּ֑ה וְגַם־אַתָּ֞ה לֹא־הִגַּ֣דְתָּ לִּ֗י וְגַ֧ם אָנֹכִ֛י לֹ֥א שָׁמַ֖עְתִּי בִּלְתִּ֥י הַיֹּֽום׃ ");
INSERT INTO hbo_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","וַיִּקַּ֤ח אַבְרָהָם֙ צֹ֣אן וּבָקָ֔ר וַיִּתֵּ֖ן לַאֲבִימֶ֑לֶךְ וַיִּכְרְת֥וּ שְׁנֵיהֶ֖ם בְּרִֽית׃ ");
INSERT INTO hbo_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","וַיַּצֵּ֣ב אַבְרָהָ֗ם אֶת־שֶׁ֛בַע כִּבְשֹׂ֥ת הַצֹּ֖אן לְבַדְּהֶֽן׃ ");
INSERT INTO hbo_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","וַיֹּ֥אמֶר אֲבִימֶ֖לֶךְ אֶל־אַבְרָהָ֑ם מָ֣ה הֵ֗נָּה שֶׁ֤בַע כְּבָשֹׂת֙ הָאֵ֔לֶּה אֲשֶׁ֥ר הִצַּ֖בְתָּ לְבַדָּֽנָה׃ ");
INSERT INTO hbo_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","וַיֹּ֕אמֶר כִּ֚י אֶת־שֶׁ֣בַע כְּבָשֹׂ֔ת תִּקַּ֖ח מִיָּדִ֑י בַּעֲבוּר֙ תִּֽהְיֶה־לִּ֣י לְעֵדָ֔ה כִּ֥י חָפַ֖רְתִּי אֶת־הַבְּאֵ֥ר הַזֹּֽאת׃ ");
INSERT INTO hbo_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","עַל־כֵּ֗ן קָרָ֛א לַמָּקֹ֥ום הַה֖וּא בְּאֵ֣ר שָׁ֑בַע כִּ֛י שָׁ֥ם נִשְׁבְּע֖וּ שְׁנֵיהֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","וַיִּכְרְת֥וּ בְרִ֖ית בִּבְאֵ֣ר שָׁ֑בַע וַיָּ֣קָם אֲבִימֶ֗לֶךְ וּפִיכֹל֙ שַׂר־צְבָאֹ֔ו וַיָּשֻׁ֖בוּ אֶל־אֶ֥רֶץ פְּלִשְׁתִּֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","וַיִּטַּ֥ע אֶ֖שֶׁל בִּבְאֵ֣ר שָׁ֑בַע וַיִּ֨קְרָא־שָׁ֔ם בְּשֵׁ֥ם יְהוָ֖ה אֵ֥ל עֹולָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","וַיָּ֧גָר אַבְרָהָ֛ם בְּאֶ֥רֶץ פְּלִשְׁתִּ֖ים יָמִ֥ים רַבִּֽים׃ פ ");
INSERT INTO hbo_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","וַיְהִ֗י אַחַר֙ הַדְּבָרִ֣ים הָאֵ֔לֶּה וְהָ֣אֱלֹהִ֔ים נִסָּ֖ה אֶת־אַבְרָהָ֑ם וַיֹּ֣אמֶר אֵלָ֔יו אַבְרָהָ֖ם וַיֹּ֥אמֶר הִנֵּֽנִי׃ ");
INSERT INTO hbo_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","וַיֹּ֡אמֶר קַח־נָ֠א אֶת־בִּנְךָ֙ אֶת־יְחִֽידְךָ֤ אֲשֶׁר־אָהַ֙בְתָּ֙ אֶת־יִצְחָ֔ק וְלֶךְ־לְךָ֔ אֶל־אֶ֖רֶץ הַמֹּרִיָּ֑ה וְהַעֲלֵ֤הוּ שָׁם֙ לְעֹלָ֔ה עַ֚ל אַחַ֣ד הֶֽהָרִ֔ים אֲשֶׁ֖ר אֹמַ֥ר אֵלֶֽיךָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","וַיַּשְׁכֵּ֨ם אַבְרָהָ֜ם בַּבֹּ֗קֶר וַֽיַּחֲבֹשׁ֙ אֶת־חֲמֹרֹ֔ו וַיִּקַּ֞ח אֶת־שְׁנֵ֤י נְעָרָיו֙ אִתֹּ֔ו וְאֵ֖ת יִצְחָ֣ק בְּנֹ֑ו וַיְבַקַּע֙ עֲצֵ֣י עֹלָ֔ה וַיָּ֣קָם וַיֵּ֔לֶךְ אֶל־הַמָּקֹ֖ום אֲשֶׁר־אָֽמַר־לֹ֥ו הָאֱלֹהִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","בַּיֹּ֣ום הַשְּׁלִישִׁ֗י וַיִּשָּׂ֨א אַבְרָהָ֧ם אֶת־עֵינָ֛יו וַיַּ֥רְא אֶת־הַמָּקֹ֖ום מֵרָחֹֽק׃ ");
INSERT INTO hbo_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","וַיֹּ֨אמֶר אַבְרָהָ֜ם אֶל־נְעָרָ֗יו שְׁבוּ־לָכֶ֥ם פֹּה֙ עִֽם־הַחֲמֹ֔ור וַאֲנִ֣י וְהַנַּ֔עַר נֵלְכָ֖ה עַד־כֹּ֑ה וְנִֽשְׁתַּחֲוֶ֖ה וְנָשׁ֥וּבָה אֲלֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","וַיִּקַּ֨ח אַבְרָהָ֜ם אֶת־עֲצֵ֣י הָעֹלָ֗ה וַיָּ֙שֶׂם֙ עַל־יִצְחָ֣ק בְּנֹ֔ו וַיִּקַּ֣ח בְּיָדֹ֔ו אֶת־הָאֵ֖שׁ וְאֶת־הַֽמַּאֲכֶ֑לֶת וַיֵּלְכ֥וּ שְׁנֵיהֶ֖ם יַחְדָּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","וַיֹּ֨אמֶר יִצְחָ֜ק אֶל־אַבְרָהָ֤ם אָבִיו֙ וַיֹּ֣אמֶר אָבִ֔י וַיֹּ֖אמֶר הִנֶּ֣נִּֽי בְנִ֑י וַיֹּ֗אמֶר הִנֵּ֤ה הָאֵשׁ֙ וְהָ֣עֵצִ֔ים וְאַיֵּ֥ה הַשֶּׂ֖ה לְעֹלָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","וַיֹּ֙אמֶר֙ אַבְרָהָ֔ם אֱלֹהִ֞ים יִרְאֶה־לֹּ֥ו הַשֶּׂ֛ה לְעֹלָ֖ה בְּנִ֑י וַיֵּלְכ֥וּ שְׁנֵיהֶ֖ם יַחְדָּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","וַיָּבֹ֗אוּ אֶֽל־הַמָּקֹום֮ אֲשֶׁ֣ר אָֽמַר־לֹ֣ו הָאֱלֹהִים֒ וַיִּ֨בֶן שָׁ֤ם אַבְרָהָם֙ אֶת־הַמִּזְבֵּ֔חַ וַֽיַּעֲרֹ֖ךְ אֶת־הָעֵצִ֑ים וַֽיַּעֲקֹד֙ אֶת־יִצְחָ֣ק בְּנֹ֔ו וַיָּ֤שֶׂם אֹתֹו֙ עַל־הַמִּזְבֵּ֔חַ מִמַּ֖עַל לָעֵצִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","וַיִּשְׁלַ֤ח אַבְרָהָם֙ אֶת־יָדֹ֔ו וַיִּקַּ֖ח אֶת־הַֽמַּאֲכֶ֑לֶת לִשְׁחֹ֖ט אֶת־בְּנֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","וַיִּקְרָ֨א אֵלָ֜יו מַלְאַ֤ךְ יְהוָה֙ מִן־הַשָּׁמַ֔יִם וַיֹּ֖אמֶר אַבְרָהָ֣ם ׀ אַבְרָהָ֑ם וַיֹּ֖אמֶר הִנֵּֽנִי׃ ");
INSERT INTO hbo_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","וַיֹּ֗אמֶר אַל־תִּשְׁלַ֤ח יָֽדְךָ֙ אֶל־הַנַּ֔עַר וְאַל־תַּ֥עַשׂ לֹ֖ו מְא֑וּמָּה כִּ֣י ׀ עַתָּ֣ה יָדַ֗עְתִּי כִּֽי־יְרֵ֤א אֱלֹהִים֙ אַ֔תָּה וְלֹ֥א חָשַׂ֛כְתָּ אֶת־בִּנְךָ֥ אֶת־יְחִידְךָ֖ מִמֶּֽנִּי׃ ");
INSERT INTO hbo_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","וַיִּשָּׂ֨א אַבְרָהָ֜ם אֶת־עֵינָ֗יו וַיַּרְא֙ וְהִנֵּה־אַ֔יִל אַחַ֕ר נֶאֱחַ֥ז בַּסְּבַ֖ךְ בְּקַרְנָ֑יו וַיֵּ֤לֶךְ אַבְרָהָם֙ וַיִּקַּ֣ח אֶת־הָאַ֔יִל וַיַּעֲלֵ֥הוּ לְעֹלָ֖ה תַּ֥חַת בְּנֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","וַיִּקְרָ֧א אַבְרָהָ֛ם שֵֽׁם־הַמָּקֹ֥ום הַה֖וּא יְהוָ֣ה ׀ יִרְאֶ֑ה אֲשֶׁר֙ יֵאָמֵ֣ר הַיֹּ֔ום בְּהַ֥ר יְהוָ֖ה יֵרָאֶֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","וַיִּקְרָ֛א מַלְאַ֥ךְ יְהוָ֖ה אֶל־אַבְרָהָ֑ם שֵׁנִ֖ית מִן־הַשָּׁמָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","וַיֹּ֕אמֶר בִּ֥י נִשְׁבַּ֖עְתִּי נְאֻם־יְהוָ֑ה כִּ֗י יַ֚עַן אֲשֶׁ֤ר עָשִׂ֙יתָ֙ אֶת־הַדָּבָ֣ר הַזֶּ֔ה וְלֹ֥א חָשַׂ֖כְתָּ אֶת־בִּנְךָ֥ אֶת־יְחִידֶֽךָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","כִּֽי־בָרֵ֣ךְ אֲבָרֶכְךָ֗ וְהַרְבָּ֨ה אַרְבֶּ֤ה אֶֽת־זַרְעֲךָ֙ כְּכֹוכְבֵ֣י הַשָּׁמַ֔יִם וְכַחֹ֕ול אֲשֶׁ֖ר עַל־שְׂפַ֣ת הַיָּ֑ם וְיִרַ֣שׁ זַרְעֲךָ֔ אֵ֖ת שַׁ֥עַר אֹיְבָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","וְהִתְבָּרֲכ֣וּ בְזַרְעֲךָ֔ כֹּ֖ל גֹּויֵ֣י הָאָ֑רֶץ עֵ֕קֶב אֲשֶׁ֥ר שָׁמַ֖עְתָּ בְּקֹלִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","וַיָּ֤שָׁב אַבְרָהָם֙ אֶל־נְעָרָ֔יו וַיָּקֻ֛מוּ וַיֵּלְכ֥וּ יַחְדָּ֖ו אֶל־בְּאֵ֣ר שָׁ֑בַע וַיֵּ֥שֶׁב אַבְרָהָ֖ם בִּבְאֵ֥ר שָֽׁבַע׃ פ ");
INSERT INTO hbo_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","וַיְהִ֗י אַחֲרֵי֙ הַדְּבָרִ֣ים הָאֵ֔לֶּה וַיֻּגַּ֥ד לְאַבְרָהָ֖ם לֵאמֹ֑ר הִ֠נֵּה יָלְדָ֨ה מִלְכָּ֥ה גַם־הִ֛וא בָּנִ֖ים לְנָחֹ֥ור אָחִֽיךָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","אֶת־ע֥וּץ בְּכֹרֹ֖ו וְאֶת־בּ֣וּז אָחִ֑יו וְאֶת־קְמוּאֵ֖ל אֲבִ֥י אֲרָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","וְאֶת־כֶּ֣שֶׂד וְאֶת־חֲזֹ֔ו וְאֶת־פִּלְדָּ֖שׁ וְאֶת־יִדְלָ֑ף וְאֵ֖ת בְּתוּאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","וּבְתוּאֵ֖ל יָלַ֣ד אֶת־רִבְקָ֑ה שְׁמֹנָ֥ה אֵ֙לֶּה֙ יָלְדָ֣ה מִלְכָּ֔ה לְנָחֹ֖ור אֲחִ֥י אַבְרָהָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","וּפִֽילַגְשֹׁ֖ו וּשְׁמָ֣הּ רְאוּמָ֑ה וַתֵּ֤לֶד גַּם־הִוא֙ אֶת־טֶ֣בַח וְאֶת־גַּ֔חַם וְאֶת־תַּ֖חַשׁ וְאֶֽת־מַעֲכָֽה׃ ס ");
INSERT INTO hbo_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","וַיִּהְיוּ֙ חַיֵּ֣י שָׂרָ֔ה מֵאָ֥ה שָׁנָ֛ה וְעֶשְׂרִ֥ים שָׁנָ֖ה וְשֶׁ֣בַע שָׁנִ֑ים שְׁנֵ֖י חַיֵּ֥י שָׂרָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","וַתָּ֣מָת שָׂרָ֗ה בְּקִרְיַ֥ת אַרְבַּ֛ע הִ֥וא חֶבְרֹ֖ון בְּאֶ֣רֶץ כְּנָ֑עַן וַיָּבֹא֙ אַבְרָהָ֔ם לִסְפֹּ֥ד לְשָׂרָ֖ה וְלִבְכֹּתָֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","וַיָּ֙קָם֙ אַבְרָהָ֔ם מֵעַ֖ל פְּנֵ֣י מֵתֹ֑ו וַיְדַבֵּ֥ר אֶל־בְּנֵי־חֵ֖ת לֵאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","גֵּר־וְתֹושָׁ֥ב אָנֹכִ֖י עִמָּכֶ֑ם תְּנ֨וּ לִ֤י אֲחֻזַּת־קֶ֙בֶר֙ עִמָּכֶ֔ם וְאֶקְבְּרָ֥ה מֵתִ֖י מִלְּפָנָֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","וַיַּעֲנ֧וּ בְנֵי־חֵ֛ת אֶת־אַבְרָהָ֖ם לֵאמֹ֥ר לֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","שְׁמָעֵ֣נוּ ׀ אֲדֹנִ֗י נְשִׂ֨יא אֱלֹהִ֤ים אַתָּה֙ בְּתֹוכֵ֔נוּ בְּמִבְחַ֣ר קְבָרֵ֔ינוּ קְבֹ֖ר אֶת־מֵתֶ֑ךָ אִ֣ישׁ מִמֶּ֔נּוּ אֶת־קִבְרֹ֛ו לֹֽא־יִכְלֶ֥ה מִמְּךָ֖ מִקְּבֹ֥ר מֵתֶֽךָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","וַיָּ֧קָם אַבְרָהָ֛ם וַיִּשְׁתַּ֥חוּ לְעַם־הָאָ֖רֶץ לִבְנֵי־חֵֽת׃ ");
INSERT INTO hbo_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","וַיְדַבֵּ֥ר אִתָּ֖ם לֵאמֹ֑ר אִם־יֵ֣שׁ אֶֽת־נַפְשְׁכֶ֗ם לִקְבֹּ֤ר אֶת־מֵתִי֙ מִלְּפָנַ֔י שְׁמָע֕וּנִי וּפִגְעוּ־לִ֖י בְּעֶפְרֹ֥ון בֶּן־צֹֽחַר׃ ");
INSERT INTO hbo_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","וְיִתֶּן־לִ֗י אֶת־מְעָרַ֤ת הַמַּכְפֵּלָה֙ אֲשֶׁר־לֹ֔ו אֲשֶׁ֖ר בִּקְצֵ֣ה שָׂדֵ֑הוּ בְּכֶ֨סֶף מָלֵ֜א יִתְּנֶ֥נָּה לִ֛י בְּתֹוכְכֶ֖ם לַאֲחֻזַּת־קָֽבֶר׃ ");
INSERT INTO hbo_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","וְעֶפְרֹ֥ון יֹשֵׁ֖ב בְּתֹ֣וךְ בְּנֵי־חֵ֑ת וַיַּעַן֩ עֶפְרֹ֨ון הַחִתִּ֤י אֶת־אַבְרָהָם֙ בְּאָזְנֵ֣י בְנֵי־חֵ֔ת לְכֹ֛ל בָּאֵ֥י שַֽׁעַר־עִירֹ֖ו לֵאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","לֹֽא־אֲדֹנִ֣י שְׁמָעֵ֔נִי הַשָּׂדֶה֙ נָתַ֣תִּי לָ֔ךְ וְהַמְּעָרָ֥ה אֲשֶׁר־בֹּ֖ו לְךָ֣ נְתַתִּ֑יהָ לְעֵינֵ֧י בְנֵי־עַמִּ֛י נְתַתִּ֥יהָ לָּ֖ךְ קְבֹ֥ר מֵתֶֽךָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","וַיִּשְׁתַּ֙חוּ֙ אַבְרָהָ֔ם לִפְנֵ֖י עַ֥ם הָאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","וַיְדַבֵּ֨ר אֶל־עֶפְרֹ֜ון בְּאָזְנֵ֤י עַם־הָאָ֙רֶץ֙ לֵאמֹ֔ר אַ֛ךְ אִם־אַתָּ֥ה ל֖וּ שְׁמָעֵ֑נִי נָתַ֜תִּי כֶּ֤סֶף הַשָּׂדֶה֙ קַ֣ח מִמֶּ֔נִּי וְאֶקְבְּרָ֥ה אֶת־מֵתִ֖י שָֽׁמָּה׃ ");
INSERT INTO hbo_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","וַיַּ֧עַן עֶפְרֹ֛ון אֶת־אַבְרָהָ֖ם לֵאמֹ֥ר לֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","אֲדֹנִ֣י שְׁמָעֵ֔נִי אֶרֶץ֩ אַרְבַּ֨ע מֵאֹ֧ת שֶֽׁקֶל־כֶּ֛סֶף בֵּינִ֥י וּבֵֽינְךָ֖ מַה־הִ֑וא וְאֶת־מֵתְךָ֖ קְבֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","וַיִּשְׁמַ֣ע אַבְרָהָם֮ אֶל־עֶפְרֹון֒ וַיִּשְׁקֹ֤ל אַבְרָהָם֙ לְעֶפְרֹ֔ן אֶת־הַכֶּ֕סֶף אֲשֶׁ֥ר דִּבֶּ֖ר בְּאָזְנֵ֣י בְנֵי־חֵ֑ת אַרְבַּ֤ע מֵאֹות֙ שֶׁ֣קֶל כֶּ֔סֶף עֹבֵ֖ר לַסֹּחֵֽר׃ ");
INSERT INTO hbo_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","וַיָּ֣קָם ׀ שְׂדֵ֣ה עֶפְרֹ֗ון אֲשֶׁר֙ בַּמַּכְפֵּלָ֔ה אֲשֶׁ֖ר לִפְנֵ֣י מַמְרֵ֑א הַשָּׂדֶה֙ וְהַמְּעָרָ֣ה אֲשֶׁר־בֹּ֔ו וְכָל־הָעֵץ֙ אֲשֶׁ֣ר בַּשָּׂדֶ֔ה אֲשֶׁ֥ר בְּכָל־גְּבֻלֹ֖ו סָבִֽיב׃ ");
INSERT INTO hbo_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","לְאַבְרָהָ֥ם לְמִקְנָ֖ה לְעֵינֵ֣י בְנֵי־חֵ֑ת בְּכֹ֖ל בָּאֵ֥י שַֽׁעַר־עִירֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","וְאַחֲרֵי־כֵן֩ קָבַ֨ר אַבְרָהָ֜ם אֶת־שָׂרָ֣ה אִשְׁתֹּ֗ו אֶל־מְעָרַ֞ת שְׂדֵ֧ה הַמַּכְפֵּלָ֛ה עַל־פְּנֵ֥י מַמְרֵ֖א הִ֣וא חֶבְרֹ֑ון בְּאֶ֖רֶץ כְּנָֽעַן׃ ");
INSERT INTO hbo_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","וַיָּ֨קָם הַשָּׂדֶ֜ה וְהַמְּעָרָ֧ה אֲשֶׁר־בֹּ֛ו לְאַבְרָהָ֖ם לַאֲחֻזַּת־קָ֑בֶר מֵאֵ֖ת בְּנֵי־חֵֽת׃ ס ");
INSERT INTO hbo_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","וְאַבְרָהָ֣ם זָקֵ֔ן בָּ֖א בַּיָּמִ֑ים וֽ͏ַיהוָ֛ה בֵּרַ֥ךְ אֶת־אַבְרָהָ֖ם בַּכֹּֽל׃ ");
INSERT INTO hbo_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","וַיֹּ֣אמֶר אַבְרָהָ֗ם אֶל־עַבְדֹּו֙ זְקַ֣ן בֵּיתֹ֔ו הַמֹּשֵׁ֖ל בְּכָל־אֲשֶׁר־לֹ֑ו שִֽׂים־נָ֥א יָדְךָ֖ תַּ֥חַת יְרֵכִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","וְאַשְׁבִּ֣יעֲךָ֔ בּֽ͏ַיהוָה֙ אֱלֹהֵ֣י הַשָּׁמַ֔יִם וֽ͏ֵאלֹהֵ֖י הָאָ֑רֶץ אֲשֶׁ֨ר לֹֽא־תִקַּ֤ח אִשָּׁה֙ לִבְנִ֔י מִבְּנֹות֙ הַֽכְּנַעֲנִ֔י אֲשֶׁ֥ר אָנֹכִ֖י יֹושֵׁ֥ב בְּקִרְבֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","כִּ֧י אֶל־אַרְצִ֛י וְאֶל־מֹולַדְתִּ֖י תֵּלֵ֑ךְ וְלָקַחְתָּ֥ אִשָּׁ֖ה לִבְנִ֥י לְיִצְחָֽק׃ ");
INSERT INTO hbo_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","וַיֹּ֤אמֶר אֵלָיו֙ הָעֶ֔בֶד אוּלַי֙ לֹא־תֹאבֶ֣ה הָֽאִשָּׁ֔ה לָלֶ֥כֶת אַחֲרַ֖י אֶל־הָאָ֣רֶץ הַזֹּ֑את הֶֽהָשֵׁ֤ב אָשִׁיב֙ אֶת־בִּנְךָ֔ אֶל־הָאָ֖רֶץ אֲשֶׁר־יָצָ֥אתָ מִשָּֽׁם׃ ");
INSERT INTO hbo_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","וַיֹּ֥אמֶר אֵלָ֖יו אַבְרָהָ֑ם הִשָּׁ֣מֶר לְךָ֔ פֶּן־תָּשִׁ֥יב אֶת־בְּנִ֖י שָֽׁמָּה׃ ");
INSERT INTO hbo_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","יְהוָ֣ה ׀ אֱלֹהֵ֣י הַשָּׁמַ֗יִם אֲשֶׁ֨ר לְקָחַ֜נִי מִבֵּ֣ית אָבִי֮ וּמֵאֶ֣רֶץ מֹֽולַדְתִּי֒ וַאֲשֶׁ֨ר דִּבֶּר־לִ֜י וַאֲשֶׁ֤ר נִֽשְׁבַּֽע־לִי֙ לֵאמֹ֔ר לְזַ֨רְעֲךָ֔ אֶתֵּ֖ן אֶת־הָאָ֣רֶץ הַזֹּ֑את ה֗וּא יִשְׁלַ֤ח מַלְאָכֹו֙ לְפָנֶ֔יךָ וְלָקַחְתָּ֥ אִשָּׁ֛ה לִבְנִ֖י מִשָּֽׁם׃ ");
INSERT INTO hbo_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","וְאִם־לֹ֨א תֹאבֶ֤ה הָֽאִשָּׁה֙ לָלֶ֣כֶת אַחֲרֶ֔יךָ וְנִקִּ֕יתָ מִשְּׁבֻעָתִ֖י זֹ֑את רַ֣ק אֶת־בְּנִ֔י לֹ֥א תָשֵׁ֖ב שָֽׁמָּה׃ ");
INSERT INTO hbo_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","וַיָּ֤שֶׂם הָעֶ֙בֶד֙ אֶת־יָדֹ֔ו תַּ֛חַת יֶ֥רֶךְ אַבְרָהָ֖ם אֲדֹנָ֑יו וַיִּשָּׁ֣בַֽע לֹ֔ו עַל־הַדָּבָ֖ר הַזֶּֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","וַיִּקַּ֣ח הָ֠עֶבֶד עֲשָׂרָ֨ה גְמַלִּ֜ים מִגְּמַלֵּ֤י אֲדֹנָיו֙ וַיֵּ֔לֶךְ וְכָל־ט֥וּב אֲדֹנָ֖יו בְּיָדֹ֑ו וַיָּ֗קָם וַיֵּ֛לֶךְ אֶל־אֲרַ֥ם נֽ͏ַהֲרַ֖יִם אֶל־עִ֥יר נָחֹֽור׃ ");
INSERT INTO hbo_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","וַיַּבְרֵ֧ךְ הַגְּמַלִּ֛ים מִח֥וּץ לָעִ֖יר אֶל־בְּאֵ֣ר הַמָּ֑יִם לְעֵ֣ת עֶ֔רֶב לְעֵ֖ת צֵ֥את הַשֹּׁאֲבֹֽת׃ ");
INSERT INTO hbo_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","וַיֹּאמַ֓ר ׀ יְהוָ֗ה אֱלֹהֵי֙ אֲדֹנִ֣י אַבְרָהָ֔ם הַקְרֵה־נָ֥א לְפָנַ֖י הַיֹּ֑ום וַעֲשֵׂה־חֶ֕סֶד עִ֖ם אֲדֹנִ֥י אַבְרָהָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","הִנֵּ֛ה אָנֹכִ֥י נִצָּ֖ב עַל־עֵ֣ין הַמָּ֑יִם וּבְנֹות֙ אַנְשֵׁ֣י הָעִ֔יר יֹצְאֹ֖ת לִשְׁאֹ֥ב מָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","וְהָיָ֣ה הַֽנַּעֲרָ֗ אֲשֶׁ֨ר אֹמַ֤ר אֵלֶ֙יהָ֙ הַטִּי־נָ֤א כַדֵּךְ֙ וְאֶשְׁתֶּ֔ה וְאָמְרָ֣ה שְׁתֵ֔ה וְגַם־גְּמַלֶּ֖יךָ אַשְׁקֶ֑ה אֹתָ֤הּ הֹכַ֙חְתָּ֙ לְעַבְדְּךָ֣ לְיִצְחָ֔ק וּבָ֣הּ אֵדַ֔ע כִּי־עָשִׂ֥יתָ חֶ֖סֶד עִם־אֲדֹנִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","וַֽיְהִי־ה֗וּא טֶרֶם֮ כִּלָּ֣ה לְדַבֵּר֒ וְהִנֵּ֧ה רִבְקָ֣ה יֹצֵ֗את אֲשֶׁ֤ר יֻלְּדָה֙ לִבְתוּאֵ֣ל בֶּן־מִלְכָּ֔ה אֵ֥שֶׁת נָחֹ֖ור אֲחִ֣י אַבְרָהָ֑ם וְכַדָּ֖הּ עַל־שִׁכְמָֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","וְהַֽנַּעֲרָ֗ טֹבַ֤ת מַרְאֶה֙ מְאֹ֔ד בְּתוּלָ֕ה וְאִ֖ישׁ לֹ֣א יְדָעָ֑הּ וַתֵּ֣רֶד הָעַ֔יְנָה וַתְּמַלֵּ֥א כַדָּ֖הּ וַתָּֽעַל׃ ");
INSERT INTO hbo_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","וַיָּ֥רָץ הָעֶ֖בֶד לִקְרָאתָ֑הּ וַיֹּ֕אמֶר הַגְמִיאִ֥ינִי נָ֛א מְעַט־מַ֖יִם מִכַּדֵּֽךְ׃ ");
INSERT INTO hbo_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","וַתֹּ֖אמֶר שְׁתֵ֣ה אֲדֹנִ֑י וַתְּמַהֵ֗ר וַתֹּ֧רֶד כַּדָּ֛הּ עַל־יָדָ֖הּ וַתַּשְׁקֵֽהוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","וַתְּכַ֖ל לְהַשְׁקֹתֹ֑ו וַתֹּ֗אמֶר גַּ֤ם לִגְמַלֶּ֙יךָ֙ אֶשְׁאָ֔ב עַ֥ד אִם־כִּלּ֖וּ לִשְׁתֹּֽת׃ ");
INSERT INTO hbo_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","וַתְּמַהֵ֗ר וַתְּעַ֤ר כַּדָּהּ֙ אֶל־הַשֹּׁ֔קֶת וַתָּ֥רָץ עֹ֛וד אֶֽל־הַבְּאֵ֖ר לִשְׁאֹ֑ב וַתִּשְׁאַ֖ב לְכָל־גְּמַלָּֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","וְהָאִ֥ישׁ מִשְׁתָּאֵ֖ה לָ֑הּ מַחֲרִ֕ישׁ לָדַ֗עַת הֽ͏ַהִצְלִ֧יחַ יְהוָ֛ה דַּרְכֹּ֖ו אִם־לֹֽא׃ ");
INSERT INTO hbo_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","וַיְהִ֗י כַּאֲשֶׁ֨ר כִּלּ֤וּ הַגְּמַלִּים֙ לִשְׁתֹּ֔ות וַיִּקַּ֤ח הָאִישׁ֙ נֶ֣זֶם זָהָ֔ב בֶּ֖קַע מִשְׁקָלֹ֑ו וּשְׁנֵ֤י צְמִידִים֙ עַל־יָדֶ֔יהָ עֲשָׂרָ֥ה זָהָ֖ב מִשְׁקָלָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","וַיֹּ֙אמֶר֙ בַּת־מִ֣י אַ֔תְּ הַגִּ֥ידִי נָ֖א לִ֑י הֲיֵ֧שׁ בֵּית־אָבִ֛יךְ מָקֹ֥ום לָ֖נוּ לָלִֽין׃ ");
INSERT INTO hbo_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","וַתֹּ֣אמֶר אֵלָ֔יו בַּת־בְּתוּאֵ֖ל אָנֹ֑כִי בֶּן־מִלְכָּ֕ה אֲשֶׁ֥ר יָלְדָ֖ה לְנָחֹֽור׃ ");
INSERT INTO hbo_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","וַתֹּ֣אמֶר אֵלָ֔יו גַּם־תֶּ֥בֶן גַּם־מִסְפֹּ֖וא רַ֣ב עִמָּ֑נוּ גַּם־מָקֹ֖ום לָלֽוּן׃ ");
INSERT INTO hbo_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","וַיִּקֹּ֣ד הָאִ֔ישׁ וַיִּשְׁתַּ֖חוּ לֽ͏ַיהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","וַיֹּ֗אמֶר בָּר֤וּךְ יְהוָה֙ אֱלֹהֵי֙ אֲדֹנִ֣י אַבְרָהָ֔ם אֲ֠שֶׁר לֹֽא־עָזַ֥ב חַסְדֹּ֛ו וַאֲמִתֹּ֖ו מֵעִ֣ם אֲדֹנִ֑י אָנֹכִ֗י בַּדֶּ֙רֶךְ֙ נָחַ֣נִי יְהוָ֔ה בֵּ֖ית אֲחֵ֥י אֲדֹנִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","וַתָּ֙רָץ֙ הַֽנַּעֲרָ֔ וַתַּגֵּ֖ד לְבֵ֣ית אִמָּ֑הּ כַּדְּבָרִ֖ים הָאֵֽלֶּה׃ ");
INSERT INTO hbo_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","וּלְרִבְקָ֥ה אָ֖ח וּשְׁמֹ֣ו לָבָ֑ן וַיָּ֨רָץ לָבָ֧ן אֶל־הָאִ֛ישׁ הַח֖וּצָה אֶל־הָעָֽיִן׃ ");
INSERT INTO hbo_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","וַיְהִ֣י ׀ כִּרְאֹ֣ת אֶת־הַנֶּ֗זֶם וְֽאֶת־הַצְּמִדִים֮ עַל־יְדֵ֣י אֲחֹתֹו֒ וּכְשָׁמְעֹ֗ו אֶת־דִּבְרֵ֞י רִבְקָ֤ה אֲחֹתֹו֙ לֵאמֹ֔ר כֹּֽה־דִבֶּ֥ר אֵלַ֖י הָאִ֑ישׁ וַיָּבֹא֙ אֶל־הָאִ֔ישׁ וְהִנֵּ֛ה עֹמֵ֥ד עַל־הַגְּמַלִּ֖ים עַל־הָעָֽיִן׃ ");
INSERT INTO hbo_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","וַיֹּ֕אמֶר בֹּ֖וא בְּר֣וּךְ יְהוָ֑ה לָ֤מָּה תַעֲמֹד֙ בַּח֔וּץ וְאָנֹכִי֙ פִּנִּ֣יתִי הַבַּ֔יִת וּמָקֹ֖ום לַגְּמַלִּֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","וַיָּבֹ֤א הָאִישׁ֙ הַבַּ֔יְתָה וַיְפַתַּ֖ח הַגְּמַלִּ֑ים וַיִּתֵּ֨ן תֶּ֤בֶן וּמִסְפֹּוא֙ לַגְּמַלִּ֔ים וּמַ֙יִם֙ לִרְחֹ֣ץ רַגְלָ֔יו וְרַגְלֵ֥י הָאֲנָשִׁ֖ים אֲשֶׁ֥ר אִתֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","*וַיִּישֶׂם (וַיּוּשַׂ֤ם) לְפָנָיו֙ לֶאֱכֹ֔ל וַיֹּ֙אמֶר֙ לֹ֣א אֹכַ֔ל עַ֥ד אִם־דִּבַּ֖רְתִּי דְּבָרָ֑י וַיֹּ֖אמֶר דַּבֵּֽר׃ ");
INSERT INTO hbo_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","וַיֹּאמַ֑ר עֶ֥בֶד אַבְרָהָ֖ם אָנֹֽכִי׃ ");
INSERT INTO hbo_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","וַיהוָ֞ה בֵּרַ֧ךְ אֶת־אֲדֹנִ֛י מְאֹ֖ד וַיִּגְדָּ֑ל וַיִּתֶּן־לֹ֞ו צֹ֤אן וּבָקָר֙ וְכֶ֣סֶף וְזָהָ֔ב וַעֲבָדִם֙ וּשְׁפָחֹ֔ת וּגְמַלִּ֖ים וַחֲמֹרִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","וַתֵּ֡לֶד שָׂרָה֩ אֵ֨שֶׁת אֲדֹנִ֥י בֵן֙ לֽ͏ַאדֹנִ֔י אַחֲרֵ֖י זִקְנָתָ֑הּ וַיִּתֶּן־לֹּ֖ו אֶת־כָּל־אֲשֶׁר־לֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","וַיַּשְׁבִּעֵ֥נִי אֲדֹנִ֖י לֵאמֹ֑ר לֹא־תִקַּ֤ח אִשָּׁה֙ לִבְנִ֔י מִבְּנֹות֙ הַֽכְּנַעֲנִ֔י אֲשֶׁ֥ר אָנֹכִ֖י יֹשֵׁ֥ב בְּאַרְצֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","אִם־לֹ֧א אֶל־בֵּית־אָבִ֛י תֵּלֵ֖ךְ וְאֶל־מִשְׁפַּחְתִּ֑י וְלָקַחְתָּ֥ אִשָּׁ֖ה לִבְנִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","וָאֹמַ֖ר אֶל־אֲדֹנִ֑י אֻלַ֛י לֹא־תֵלֵ֥ךְ הָאִשָּׁ֖ה אַחֲרָֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","וַיֹּ֖אמֶר אֵלָ֑י יְהוָ֞ה אֲשֶׁר־הִתְהַלַּ֣כְתִּי לְפָנָ֗יו יִשְׁלַ֨ח מַלְאָכֹ֤ו אִתָּךְ֙ וְהִצְלִ֣יחַ דַּרְכֶּ֔ךָ וְלָקַחְתָּ֤ אִשָּׁה֙ לִבְנִ֔י מִמִּשְׁפַּחְתִּ֖י וּמִבֵּ֥ית אָבִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","אָ֤ז תִּנָּקֶה֙ מֵאָ֣לָתִ֔י כִּ֥י תָבֹ֖וא אֶל־מִשְׁפַּחְתִּ֑י וְאִם־לֹ֤א יִתְּנוּ֙ לָ֔ךְ וְהָיִ֥יתָ נָקִ֖י מֵאָלָתִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","וָאָבֹ֥א הַיֹּ֖ום אֶל־הָעָ֑יִן וָאֹמַ֗ר יְהוָה֙ אֱלֹהֵי֙ אֲדֹנִ֣י אַבְרָהָ֔ם אִם־יֶשְׁךָ־נָּא֙ מַצְלִ֣יחַ דַּרְכִּ֔י אֲשֶׁ֥ר אָנֹכִ֖י הֹלֵ֥ךְ עָלֶֽיהָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","הִנֵּ֛ה אָנֹכִ֥י נִצָּ֖ב עַל־עֵ֣ין הַמָּ֑יִם וְהָיָ֤ה הָֽעַלְמָה֙ הַיֹּצֵ֣את לִשְׁאֹ֔ב וְאָמַרְתִּ֣י אֵלֶ֔יהָ הַשְׁקִֽינִי־נָ֥א מְעַט־מַ֖יִם מִכַּדֵּֽךְ׃ ");
INSERT INTO hbo_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","וְאָמְרָ֤ה אֵלַי֙ גַּם־אַתָּ֣ה שְׁתֵ֔ה וְגַ֥ם לִגְמַלֶּ֖יךָ אֶשְׁאָ֑ב הִ֣וא הֽ͏ָאִשָּׁ֔ה אֲשֶׁר־הֹכִ֥יחַ יְהוָ֖ה לְבֶן־אֲדֹנִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","אֲנִי֩ טֶ֨רֶם אֲכַלֶּ֜ה לְדַבֵּ֣ר אֶל־לִבִּ֗י וְהִנֵּ֨ה רִבְקָ֤ה יֹצֵאת֙ וְכַדָּ֣הּ עַל־שִׁכְמָ֔הּ וַתֵּ֥רֶד הָעַ֖יְנָה וַתִּשְׁאָ֑ב וָאֹמַ֥ר אֵלֶ֖יהָ הַשְׁקִ֥ינִי נָֽא׃ ");
INSERT INTO hbo_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","וַתְּמַהֵ֗ר וַתֹּ֤ורֶד כַּדָּהּ֙ מֵֽעָלֶ֔יהָ וַתֹּ֣אמֶר שְׁתֵ֔ה וְגַם־גְּמַלֶּ֖יךָ אַשְׁקֶ֑ה וָאֵ֕שְׁתְּ וְגַ֥ם הַגְּמַלִּ֖ים הִשְׁקָֽתָה׃ ");
INSERT INTO hbo_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","וָאֶשְׁאַ֣ל אֹתָ֗הּ וָאֹמַר֮ בַּת־מִ֣י אַתְּ֒ וַתֹּ֗אמֶר בַּת־בְּתוּאֵל֙ בֶּן־נָחֹ֔ור אֲשֶׁ֥ר יָֽלְדָה־לֹּ֖ו מִלְכָּ֑ה וָאָשִׂ֤ם הַנֶּ֙זֶם֙ עַל־אַפָּ֔הּ וְהַצְּמִידִ֖ים עַל־יָדֶֽיהָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","וָאֶקֹּ֥ד וָֽאֶשְׁתַּחֲוֶ֖ה לַיהוָ֑ה וָאֲבָרֵ֗ךְ אֶת־יְהוָה֙ אֱלֹהֵי֙ אֲדֹנִ֣י אַבְרָהָ֔ם אֲשֶׁ֤ר הִנְחַ֙נִי֙ בְּדֶ֣רֶךְ אֱמֶ֔ת לָקַ֛חַת אֶת־בַּת־אֲחִ֥י אֲדֹנִ֖י לִבְנֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","וְ֠עַתָּה אִם־יֶשְׁכֶ֨ם עֹשִׂ֜ים חֶ֧סֶד וֽ͏ֶאֱמֶ֛ת אֶת־אֲדֹנִ֖י הַגִּ֣ידוּ לִ֑י וְאִם־לֹ֕א הַגִּ֣ידוּ לִ֔י וְאֶפְנֶ֥ה עַל־יָמִ֖ין אֹ֥ו עַל־שְׂמֹֽאל׃ ");
INSERT INTO hbo_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","וַיַּ֨עַן לָבָ֤ן וּבְתוּאֵל֙ וַיֹּ֣אמְר֔וּ מֵיְהוָ֖ה יָצָ֣א הַדָּבָ֑ר לֹ֥א נוּכַ֛ל דַּבֵּ֥ר אֵלֶ֖יךָ רַ֥ע אֹו־טֹֽוב׃ ");
INSERT INTO hbo_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","הִנֵּֽה־רִבְקָ֥ה לְפָנֶ֖יךָ קַ֣ח וָלֵ֑ךְ וּתְהִ֤י אִשָּׁה֙ לְבֶן־אֲדֹנֶ֔יךָ כַּאֲשֶׁ֖ר דִּבֶּ֥ר יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","וַיְהִ֕י כַּאֲשֶׁ֥ר שָׁמַ֛ע עֶ֥בֶד אַבְרָהָ֖ם אֶת־דִּבְרֵיהֶ֑ם וַיִּשְׁתַּ֥חוּ אַ֖רְצָה לֽ͏ַיהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","וַיֹּוצֵ֨א הָעֶ֜בֶד כְּלֵי־כֶ֨סֶף וּכְלֵ֤י זָהָב֙ וּבְגָדִ֔ים וַיִּתֵּ֖ן לְרִבְקָ֑ה וּמִ֨גְדָּנֹ֔ת נָתַ֥ן לְאָחִ֖יהָ וּלְאִמָּֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","וַיֹּאכְל֣וּ וַיִּשְׁתּ֗וּ ה֛וּא וְהָאֲנָשִׁ֥ים אֲשֶׁר־עִמֹּ֖ו וַיָּלִ֑ינוּ וַיָּק֣וּמוּ בַבֹּ֔קֶר וַיֹּ֖אמֶר שַׁלְּחֻ֥נִי לֽ͏ַאדֹנִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","וַיֹּ֤אמֶר אָחִ֙יהָ֙ וְאִמָּ֔הּ תֵּשֵׁ֨ב הַנַּעֲרָ֥ אִתָּ֛נוּ יָמִ֖ים אֹ֣ו עָשֹׂ֑ור אַחַ֖ר תֵּלֵֽךְ׃ ");
INSERT INTO hbo_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","וַיֹּ֤אמֶר אֲלֵהֶם֙ אַל־תְּאַחֲר֣וּ אֹתִ֔י וֽ͏ַיהוָ֖ה הִצְלִ֣יחַ דַּרְכִּ֑י שַׁלְּח֕וּנִי וְאֵלְכָ֖ה לֽ͏ַאדֹנִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","וַיֹּאמְר֖וּ נִקְרָ֣א לַֽנַּעֲרָ֑ וְנִשְׁאֲלָ֖ה אֶת־פִּֽיהָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","וַיִּקְרְא֤וּ לְרִבְקָה֙ וַיֹּאמְר֣וּ אֵלֶ֔יהָ הֲתֵלְכִ֖י עִם־הָאִ֣ישׁ הַזֶּ֑ה וַתֹּ֖אמֶר אֵלֵֽךְ׃ ");
INSERT INTO hbo_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","וַֽיְשַׁלְּח֛וּ אֶת־רִבְקָ֥ה אֲחֹתָ֖ם וְאֶת־מֵנִקְתָּ֑הּ וְאֶת־עֶ֥בֶד אַבְרָהָ֖ם וְאֶת־אֲנָשָֽׁיו׃ ");
INSERT INTO hbo_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","וַיְבָרֲכ֤וּ אֶת־רִבְקָה֙ וַיֹּ֣אמְרוּ לָ֔הּ אֲחֹתֵ֕נוּ אַ֥תְּ הֲיִ֖י לְאַלְפֵ֣י רְבָבָ֑ה וְיִירַ֣שׁ זַרְעֵ֔ךְ אֵ֖ת שַׁ֥עַר שֹׂנְאָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","וַתָּ֨קָם רִבְקָ֜ה וְנַעֲרֹתֶ֗יהָ וַתִּרְכַּ֙בְנָה֙ עַל־הַגְּמַלִּ֔ים וַתֵּלַ֖כְנָה אַחֲרֵ֣י הָאִ֑ישׁ וַיִּקַּ֥ח הָעֶ֛בֶד אֶת־רִבְקָ֖ה וַיֵּלַֽךְ׃ ");
INSERT INTO hbo_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","וְיִצְחָק֙ בָּ֣א מִבֹּ֔וא בְּאֵ֥ר לַחַ֖י רֹאִ֑י וְה֥וּא יֹושֵׁ֖ב בְּאֶ֥רֶץ הַנֶּֽגֶב׃ ");
INSERT INTO hbo_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","וַיֵּצֵ֥א יִצְחָ֛ק לָשׂ֥וּחַ בַּשָּׂדֶ֖ה לִפְנֹ֣ות עָ֑רֶב וַיִּשָּׂ֤א עֵינָיו֙ וַיַּ֔רְא וְהִנֵּ֥ה גְמַלִּ֖ים בָּאִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","וַתִּשָּׂ֤א רִבְקָה֙ אֶת־עֵינֶ֔יהָ וַתֵּ֖רֶא אֶת־יִצְחָ֑ק וַתִּפֹּ֖ל מֵעַ֥ל הַגָּמָֽל׃ ");
INSERT INTO hbo_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","וַתֹּ֣אמֶר אֶל־הָעֶ֗בֶד מִֽי־הָאִ֤ישׁ הַלָּזֶה֙ הַהֹלֵ֤ךְ בַּשָּׂדֶה֙ לִקְרָאתֵ֔נוּ וַיֹּ֥אמֶר הָעֶ֖בֶד ה֣וּא אֲדֹנִ֑י וַתִּקַּ֥ח הַצָּעִ֖יף וַתִּתְכָּֽס׃ ");
INSERT INTO hbo_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","וַיְסַפֵּ֥ר הָעֶ֖בֶד לְיִצְחָ֑ק אֵ֥ת כָּל־הַדְּבָרִ֖ים אֲשֶׁ֥ר עָשָֽׂה׃ ");
INSERT INTO hbo_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","וַיְבִאֶ֣הָ יִצְחָ֗ק הָאֹ֙הֱלָה֙ שָׂרָ֣ה אִמֹּ֔ו וַיִּקַּ֧ח אֶת־רִבְקָ֛ה וַתְּהִי־לֹ֥ו לְאִשָּׁ֖ה וַיֶּאֱהָבֶ֑הָ וַיִּנָּחֵ֥ם יִצְחָ֖ק אַחֲרֵ֥י אִמֹּֽו׃ פ ");
INSERT INTO hbo_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","וַיֹּ֧סֶף אַבְרָהָ֛ם וַיִּקַּ֥ח אִשָּׁ֖ה וּשְׁמָ֥הּ קְטוּרָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","וַתֵּ֣לֶד לֹ֗ו אֶת־זִמְרָן֙ וְאֶת־יָקְשָׁ֔ן וְאֶת־מְדָ֖ן וְאֶת־מִדְיָ֑ן וְאֶת־יִשְׁבָּ֖ק וְאֶת־שֽׁוּחַ׃ ");
INSERT INTO hbo_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","וְיָקְשָׁ֣ן יָלַ֔ד אֶת־שְׁבָ֖א וְאֶת־דְּדָ֑ן וּבְנֵ֣י דְדָ֔ן הָי֛וּ אַשּׁוּרִ֥ם וּלְטוּשִׁ֖ים וּלְאֻמִּֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","וּבְנֵ֣י מִדְיָ֗ן עֵיפָ֤ה וָעֵ֙פֶר֙ וַחֲנֹ֔ךְ וַאֲבִידָ֖ע וְאֶלְדָּעָ֑ה כָּל־אֵ֖לֶּה בְּנֵ֥י קְטוּרָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","וַיִּתֵּ֧ן אַבְרָהָ֛ם אֶת־כָּל־אֲשֶׁר־לֹ֖ו לְיִצְחָֽק׃ ");
INSERT INTO hbo_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","וְלִבְנֵ֤י הַפִּֽילַגְשִׁים֙ אֲשֶׁ֣ר לְאַבְרָהָ֔ם נָתַ֥ן אַבְרָהָ֖ם מַתָּנֹ֑ת וַֽיְשַׁלְּחֵ֞ם מֵעַ֨ל יִצְחָ֤ק בְּנֹו֙ בְּעֹודֶ֣נּוּ חַ֔י קֵ֖דְמָה אֶל־אֶ֥רֶץ קֶֽדֶם׃ ");
INSERT INTO hbo_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","וְאֵ֗לֶּה יְמֵ֛י שְׁנֵֽי־חַיֵּ֥י אַבְרָהָ֖ם אֲשֶׁר־חָ֑י מְאַ֥ת שָׁנָ֛ה וְשִׁבְעִ֥ים שָׁנָ֖ה וְחָמֵ֥שׁ שָׁנִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","וַיִּגְוַ֨ע וַיָּ֧מָת אַבְרָהָ֛ם בְּשֵׂיבָ֥ה טֹובָ֖ה זָקֵ֣ן וְשָׂבֵ֑עַ וַיֵּאָ֖סֶף אֶל־עַמָּֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","וַיִּקְבְּר֨וּ אֹתֹ֜ו יִצְחָ֤ק וְיִשְׁמָעֵאל֙ בָּנָ֔יו אֶל־מְעָרַ֖ת הַמַּכְפֵּלָ֑ה אֶל־שְׂדֵ֞ה עֶפְרֹ֤ן בֶּן־צֹ֙חַר֙ הַֽחִתִּ֔י אֲשֶׁ֖ר עַל־פְּנֵ֥י מַמְרֵֽא׃ ");
INSERT INTO hbo_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","הַשָּׂדֶ֛ה אֲשֶׁר־קָנָ֥ה אַבְרָהָ֖ם מֵאֵ֣ת בְּנֵי־חֵ֑ת שָׁ֛מָּה קֻבַּ֥ר אַבְרָהָ֖ם וְשָׂרָ֥ה אִשְׁתֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","וַיְהִ֗י אַחֲרֵי֙ מֹ֣ות אַבְרָהָ֔ם וַיְבָ֥רֶךְ אֱלֹהִ֖ים אֶת־יִצְחָ֣ק בְּנֹ֑ו וַיֵּ֣שֶׁב יִצְחָ֔ק עִם־בְּאֵ֥ר לַחַ֖י רֹאִֽי׃ ס ");
INSERT INTO hbo_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","וְאֵ֛לֶּה תֹּלְדֹ֥ת יִשְׁמָעֵ֖אל בֶּן־אַבְרָהָ֑ם אֲשֶׁ֨ר יָלְדָ֜ה הָגָ֧ר הַמִּצְרִ֛ית שִׁפְחַ֥ת שָׂרָ֖ה לְאַבְרָהָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","וְאֵ֗לֶּה שְׁמֹות֙ בְּנֵ֣י יִשְׁמָעֵ֔אל בִּשְׁמֹתָ֖ם לְתֹולְדֹתָ֑ם בְּכֹ֤ר יִשְׁמָעֵאל֙ נְבָיֹ֔ת וְקֵדָ֥ר וְאַדְבְּאֵ֖ל וּמִבְשָֽׂם׃ ");
INSERT INTO hbo_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","וּמִשְׁמָ֥ע וְדוּמָ֖ה וּמַשָּֽׂא׃ ");
INSERT INTO hbo_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","חֲדַ֣ד וְתֵימָ֔א יְט֥וּר נָפִ֖ישׁ וָקֵֽדְמָה׃ ");
INSERT INTO hbo_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","אֵ֣לֶּה הֵ֞ם בְּנֵ֤י יִשְׁמָעֵאל֙ וְאֵ֣לֶּה שְׁמֹתָ֔ם בְּחַצְרֵיהֶ֖ם וּבְטִֽירֹתָ֑ם שְׁנֵים־עָשָׂ֥ר נְשִׂיאִ֖ם לְאֻמֹּתָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","וְאֵ֗לֶּה שְׁנֵי֙ חַיֵּ֣י יִשְׁמָעֵ֔אל מְאַ֥ת שָׁנָ֛ה וּשְׁלֹשִׁ֥ים שָׁנָ֖ה וְשֶׁ֣בַע שָׁנִ֑ים וַיִּגְוַ֣ע וַיָּ֔מָת וַיֵּאָ֖סֶף אֶל־עַמָּֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","וַיִּשְׁכְּנ֨וּ מֽ͏ֵחֲוִילָ֜ה עַד־שׁ֗וּר אֲשֶׁר֙ עַל־פְּנֵ֣י מִצְרַ֔יִם בֹּאֲכָ֖ה אַשּׁ֑וּרָה עַל־פְּנֵ֥י כָל־אֶחָ֖יו נָפָֽל׃ פ ");
INSERT INTO hbo_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","וְאֵ֛לֶּה תֹּולְדֹ֥ת יִצְחָ֖ק בֶּן־אַבְרָהָ֑ם אַבְרָהָ֖ם הֹולִ֥יד אֶת־יִצְחָֽק׃ ");
INSERT INTO hbo_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","וַיְהִ֤י יִצְחָק֙ בֶּן־אַרְבָּעִ֣ים שָׁנָ֔ה בְּקַחְתֹּ֣ו אֶת־רִבְקָ֗ה בַּת־בְּתוּאֵל֙ הֽ͏ָאֲרַמִּ֔י מִפַּדַּ֖ן אֲרָ֑ם אֲחֹ֛ות לָבָ֥ן הָאֲרַמִּ֖י לֹ֥ו לְאִשָּֽׁה׃ ");
INSERT INTO hbo_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","וַיֶּעְתַּ֨ר יִצְחָ֤ק לֽ͏ַיהוָה֙ לְנֹ֣כַח אִשְׁתֹּ֔ו כִּ֥י עֲקָרָ֖ה הִ֑וא וַיֵּעָ֤תֶר לֹו֙ יְהוָ֔ה וַתַּ֖הַר רִבְקָ֥ה אִשְׁתֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","וַיִּתְרֹֽצֲצ֤וּ הַבָּנִים֙ בְּקִרְבָּ֔הּ וַתֹּ֣אמֶר אִם־כֵּ֔ן לָ֥מָּה זֶּ֖ה אָנֹ֑כִי וַתֵּ֖לֶךְ לִדְרֹ֥שׁ אֶת־יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","וַיֹּ֨אמֶר יְהוָ֜ה לָ֗הּ שְׁנֵ֤י *גֹיִים (גֹויִם֙) בְּבִטְנֵ֔ךְ וּשְׁנֵ֣י לְאֻמִּ֔ים מִמֵּעַ֖יִךְ יִפָּרֵ֑דוּ וּלְאֹם֙ מִלְאֹ֣ם יֶֽאֱמָ֔ץ וְרַ֖ב יַעֲבֹ֥ד צָעִֽיר׃ ");
INSERT INTO hbo_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","וַיִּמְלְא֥וּ יָמֶ֖יהָ לָלֶ֑דֶת וְהִנֵּ֥ה תֹומִ֖ם בְּבִטְנָֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","וַיֵּצֵ֤א הָרִאשֹׁון֙ אַדְמֹונִ֔י כֻּלֹּ֖ו כְּאַדֶּ֣רֶת שֵׂעָ֑ר וַיִּקְרְא֥וּ שְׁמֹ֖ו עֵשָֽׂו׃ ");
INSERT INTO hbo_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","וְאַֽחֲרֵי־כֵ֞ן יָצָ֣א אָחִ֗יו וְיָדֹ֤ו אֹחֶ֙זֶת֙ בַּעֲקֵ֣ב עֵשָׂ֔ו וַיִּקְרָ֥א שְׁמֹ֖ו יַעֲקֹ֑ב וְיִצְחָ֛ק בֶּן־שִׁשִּׁ֥ים שָׁנָ֖ה בְּלֶ֥דֶת אֹתָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","וֽ͏ַיִּגְדְּלוּ֙ הַנְּעָרִ֔ים וַיְהִ֣י עֵשָׂ֗ו אִ֛ישׁ יֹדֵ֥עַ צַ֖יִד אִ֣ישׁ שָׂדֶ֑ה וְיַעֲקֹב֙ אִ֣ישׁ תָּ֔ם יֹשֵׁ֖ב אֹהָלִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","וַיֶּאֱהַ֥ב יִצְחָ֛ק אֶת־עֵשָׂ֖ו כִּי־צַ֣יִד בְּפִ֑יו וְרִבְקָ֖ה אֹהֶ֥בֶת אֶֽת־יַעֲקֹֽב׃ ");
INSERT INTO hbo_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","וַיָּ֥זֶד יַעֲקֹ֖ב נָזִ֑יד וַיָּבֹ֥א עֵשָׂ֛ו מִן־הַשָּׂדֶ֖ה וְה֥וּא עָיֵֽף׃ ");
INSERT INTO hbo_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","וַיֹּ֨אמֶר עֵשָׂ֜ו אֶֽל־יַעֲקֹ֗ב הַלְעִיטֵ֤נִי נָא֙ מִן־הָאָדֹ֤ם הָאָדֹם֙ הַזֶּ֔ה כִּ֥י עָיֵ֖ף אָנֹ֑כִי עַל־כֵּ֥ן קָרָֽא־שְׁמֹ֖ו אֱדֹֽום׃ ");
INSERT INTO hbo_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","וַיֹּ֖אמֶר יַעֲקֹ֑ב מִכְרָ֥ה כַיֹּ֛ום אֶת־בְּכֹֽרָתְךָ֖ לִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","וַיֹּ֣אמֶר עֵשָׂ֔ו הִנֵּ֛ה אָנֹכִ֥י הֹולֵ֖ךְ לָמ֑וּת וְלָמָּה־זֶּ֥ה לִ֖י בְּכֹרָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","וַיֹּ֣אמֶר יַעֲקֹ֗ב הִשָּׁ֤בְעָה לִּי֙ כַּיֹּ֔ום וַיִּשָּׁבַ֖ע לֹ֑ו וַיִּמְכֹּ֥ר אֶת־בְּכֹרָתֹ֖ו לְיַעֲקֹֽב׃ ");
INSERT INTO hbo_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","וְיַעֲקֹ֞ב נָתַ֣ן לְעֵשָׂ֗ו לֶ֚חֶם וּנְזִ֣יד עֲדָשִׁ֔ים וַיֹּ֣אכַל וַיֵּ֔שְׁתְּ וַיָּ֖קָם וַיֵּלַ֑ךְ וַיִּ֥בֶז עֵשָׂ֖ו אֶת־הַבְּכֹרָֽה׃ ס ");
INSERT INTO hbo_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","וַיְהִ֤י רָעָב֙ בָּאָ֔רֶץ מִלְּבַד֙ הָרָעָ֣ב הָרִאשֹׁ֔ון אֲשֶׁ֥ר הָיָ֖ה בִּימֵ֣י אַבְרָהָ֑ם וַיֵּ֧לֶךְ יִצְחָ֛ק אֶל־אֲבִימֶּ֥לֶךְ מֶֽלֶךְ־פְּלִשְׁתִּ֖ים גְּרָֽרָה׃ ");
INSERT INTO hbo_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","וַיֵּרָ֤א אֵלָיו֙ יְהוָ֔ה וַיֹּ֖אמֶר אַל־תֵּרֵ֣ד מִצְרָ֑יְמָה שְׁכֹ֣ן בָּאָ֔רֶץ אֲשֶׁ֖ר אֹמַ֥ר אֵלֶֽיךָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","גּ֚וּר בָּאָ֣רֶץ הַזֹּ֔את וְאֶֽהְיֶ֥ה עִמְּךָ֖ וַאֲבָרְכֶ֑ךָּ כִּֽי־לְךָ֣ וּֽלְזַרְעֲךָ֗ אֶתֵּן֙ אֶת־כָּל־הָֽאֲרָצֹ֣ת הָאֵ֔ל וַהֲקִֽמֹתִי֙ אֶת־הַשְּׁבֻעָ֔ה אֲשֶׁ֥ר נִשְׁבַּ֖עְתִּי לְאַבְרָהָ֥ם אָבִֽיךָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","וְהִרְבֵּיתִ֤י אֶֽת־זַרְעֲךָ֙ כְּכֹוכְבֵ֣י הַשָּׁמַ֔יִם וְנָתַתִּ֣י לְזַרְעֲךָ֔ אֵ֥ת כָּל־הָאֲרָצֹ֖ת הָאֵ֑ל וְהִתְבָּרֲכ֣וּ בְזַרְעֲךָ֔ כֹּ֖ל גֹּויֵ֥י הָאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","עֵ֕קֶב אֲשֶׁר־שָׁמַ֥ע אַבְרָהָ֖ם בְּקֹלִ֑י וַיִּשְׁמֹר֙ מִשְׁמַרְתִּ֔י מִצְוֹתַ֖י חֻקֹּותַ֥י וְתֹורֹתָֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","וַיֵּ֥שֶׁב יִצְחָ֖ק בִּגְרָֽר׃ ");
INSERT INTO hbo_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","וַֽיִּשְׁאֲל֞וּ אַנְשֵׁ֤י הַמָּקֹום֙ לְאִשְׁתֹּ֔ו וַיֹּ֖אמֶר אֲחֹ֣תִי הִ֑וא כִּ֤י יָרֵא֙ לֵאמֹ֣ר אִשְׁתִּ֔י פֶּן־יַֽהַרְגֻ֜נִי אַנְשֵׁ֤י הַמָּקֹום֙ עַל־רִבְקָ֔ה כִּֽי־טֹובַ֥ת מַרְאֶ֖ה הִֽיא׃ ");
INSERT INTO hbo_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","וַיְהִ֗י כִּ֣י אָֽרְכוּ־לֹ֥ו שָׁם֙ הַיָּמִ֔ים וַיַּשְׁקֵ֗ף אֲבִימֶ֙לֶךְ֙ מֶ֣לֶךְ פְּלִשְׁתִּ֔ים בְּעַ֖ד הֽ͏ַחַלֹּ֑ון וַיַּ֗רְא וְהִנֵּ֤ה יִצְחָק֙ מְצַחֵ֔ק אֵ֖ת רִבְקָ֥ה אִשְׁתֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","וַיִּקְרָ֨א אֲבִימֶ֜לֶךְ לְיִצְחָ֗ק וַיֹּ֙אמֶר֙ אַ֣ךְ הִנֵּ֤ה אִשְׁתְּךָ֙ הִ֔וא וְאֵ֥יךְ אָמַ֖רְתָּ אֲחֹ֣תִי הִ֑וא וַיֹּ֤אמֶר אֵלָיו֙ יִצְחָ֔ק כִּ֣י אָמַ֔רְתִּי פֶּן־אָמ֖וּת עָלֶֽיהָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","וַיֹּ֣אמֶר אֲבִימֶ֔לֶךְ מַה־זֹּ֖את עָשִׂ֣יתָ לָּ֑נוּ כִּ֠מְעַט שָׁכַ֞ב אַחַ֤ד הָעָם֙ אֶת־אִשְׁתֶּ֔ךָ וְהֵבֵאתָ֥ עָלֵ֖ינוּ אָשָֽׁם׃ ");
INSERT INTO hbo_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","וַיְצַ֣ו אֲבִימֶ֔לֶךְ אֶת־כָּל־הָעָ֖ם לֵאמֹ֑ר הַנֹּגֵ֜עַ בָּאִ֥ישׁ הַזֶּ֛ה וּבְאִשְׁתֹּ֖ו מֹ֥ות יוּמָֽת׃ ");
INSERT INTO hbo_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","וַיִּזְרַ֤ע יִצְחָק֙ בָּאָ֣רֶץ הַהִ֔וא וַיִּמְצָ֛א בַּשָּׁנָ֥ה הַהִ֖וא מֵאָ֣ה שְׁעָרִ֑ים וֽ͏ַיְבָרֲכֵ֖הוּ יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","וַיִּגְדַּ֖ל הָאִ֑ישׁ וַיֵּ֤לֶךְ הָלֹוךְ֙ וְגָדֵ֔ל עַ֥ד כִּֽי־גָדַ֖ל מְאֹֽד׃ ");
INSERT INTO hbo_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","וֽ͏ַיְהִי־לֹ֤ו מִקְנֵה־צֹאן֙ וּמִקְנֵ֣ה בָקָ֔ר וַעֲבֻדָּ֖ה רַבָּ֑ה וַיְקַנְא֥וּ אֹתֹ֖ו פְּלִשְׁתִּֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","וְכָל־הַבְּאֵרֹ֗ת אֲשֶׁ֤ר חָֽפְרוּ֙ עַבְדֵ֣י אָבִ֔יו בִּימֵ֖י אַבְרָהָ֣ם אָבִ֑יו סִתְּמ֣וּם פְּלִשְׁתִּ֔ים וַיְמַלְא֖וּם עָפָֽר׃ ");
INSERT INTO hbo_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","וַיֹּ֥אמֶר אֲבִימֶ֖לֶךְ אֶל־יִצְחָ֑ק לֵ֚ךְ מֽ͏ֵעִמָּ֔נוּ כִּֽי־עָצַֽמְתָּ־מִמֶּ֖נּוּ מְאֹֽד׃ ");
INSERT INTO hbo_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","וַיֵּ֥לֶךְ מִשָּׁ֖ם יִצְחָ֑ק וַיִּ֥חַן בְּנַֽחַל־גְּרָ֖ר וַיֵּ֥שֶׁב שָֽׁם׃ ");
INSERT INTO hbo_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","וַיָּ֨שָׁב יִצְחָ֜ק וַיַּחְפֹּ֣ר ׀ אֶת־בְּאֵרֹ֣ת הַמַּ֗יִם אֲשֶׁ֤ר חָֽפְרוּ֙ בִּימֵי֙ אַבְרָהָ֣ם אָבִ֔יו וַיְסַתְּמ֣וּם פְּלִשְׁתִּ֔ים אַחֲרֵ֖י מֹ֣ות אַבְרָהָ֑ם וַיִּקְרָ֤א לָהֶן֙ שֵׁמֹ֔ות כַּשֵּׁמֹ֕ת אֲשֶׁר־קָרָ֥א לָהֶ֖ן אָבִֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","וַיַּחְפְּר֥וּ עַבְדֵֽי־יִצְחָ֖ק בַּנָּ֑חַל וַיִּ֨מְצְאוּ־שָׁ֔ם בְּאֵ֖ר מַ֥יִם חַיִּֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","וַיָּרִ֜יבוּ רֹעֵ֣י גְרָ֗ר עִם־רֹעֵ֥י יִצְחָ֛ק לֵאמֹ֖ר לָ֣נוּ הַמָּ֑יִם וַיִּקְרָ֤א שֵֽׁם־הַבְּאֵר֙ עֵ֔שֶׂק כִּ֥י הִֽתְעַשְּׂק֖וּ עִמֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","וַֽיַּחְפְּרוּ֙ בְּאֵ֣ר אַחֶ֔רֶת וַיָּרִ֖יבוּ גַּם־עָלֶ֑יהָ וַיִּקְרָ֥א שְׁמָ֖הּ שִׂטְנָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","וַיַּעְתֵּ֣ק מִשָּׁ֗ם וַיַּחְפֹּר֙ בְּאֵ֣ר אַחֶ֔רֶת וְלֹ֥א רָב֖וּ עָלֶ֑יהָ וַיִּקְרָ֤א שְׁמָהּ֙ רְחֹבֹ֔ות וַיֹּ֗אמֶר כִּֽי־עַתָּ֞ה הִרְחִ֧יב יְהוָ֛ה לָ֖נוּ וּפָרִ֥ינוּ בָאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","וַיַּ֥עַל מִשָּׁ֖ם בְּאֵ֥ר שָֽׁבַע׃ ");
INSERT INTO hbo_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","וַיֵּרָ֨א אֵלָ֤יו יְהוָה֙ בַּלַּ֣יְלָה הַה֔וּא וַיֹּ֕אמֶר אָנֹכִ֕י אֱלֹהֵ֖י אַבְרָהָ֣ם אָבִ֑יךָ אַל־תִּירָא֙ כִּֽי־אִתְּךָ֣ אָנֹ֔כִי וּבֵֽרַכְתִּ֙יךָ֙ וְהִרְבֵּיתִ֣י אֶֽת־זַרְעֲךָ֔ בַּעֲב֖וּר אַבְרָהָ֥ם עַבְדִּֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","וַיִּ֧בֶן שָׁ֣ם מִזְבֵּ֗חַ וַיִּקְרָא֙ בְּשֵׁ֣ם יְהוָ֔ה וַיֶּט־שָׁ֖ם אָהֳלֹ֑ו וַיִּכְרוּ־שָׁ֥ם עַבְדֵי־יִצְחָ֖ק בְּאֵֽר׃ ");
INSERT INTO hbo_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","וַאֲבִימֶ֕לֶךְ הָלַ֥ךְ אֵלָ֖יו מִגְּרָ֑ר וַאֲחֻזַּת֙ מֵֽרֵעֵ֔הוּ וּפִיכֹ֖ל שַׂר־צְבָאֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","וַיֹּ֤אמֶר אֲלֵהֶם֙ יִצְחָ֔ק מַדּ֖וּעַ בָּאתֶ֣ם אֵלָ֑י וְאַתֶּם֙ שְׂנֵאתֶ֣ם אֹתִ֔י וַתְּשַׁלְּח֖וּנִי מֵאִתְּכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","וַיֹּאמְר֗וּ רָאֹ֣ו רָאִינוּ֮ כִּֽי־הָיָ֣ה יְהוָ֣ה ׀ עִמָּךְ֒ וַנֹּ֗אמֶר תְּהִ֨י נָ֥א אָלָ֛ה בֵּינֹותֵ֖ינוּ בֵּינֵ֣ינוּ וּבֵינֶ֑ךָ וְנִכְרְתָ֥ה בְרִ֖ית עִמָּֽךְ׃ ");
INSERT INTO hbo_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","אִם־תַּעֲשֵׂ֨ה עִמָּ֜נוּ רָעָ֗ה כַּאֲשֶׁר֙ לֹ֣א נְגַֽעֲנ֔וּךָ וְכַאֲשֶׁ֨ר עָשִׂ֤ינוּ עִמְּךָ֙ רַק־טֹ֔וב וַנְּשַׁלֵּֽחֲךָ֖ בְּשָׁלֹ֑ום אַתָּ֥ה עַתָּ֖ה בְּר֥וּךְ יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","וַיַּ֤עַשׂ לָהֶם֙ מִשְׁתֶּ֔ה וַיֹּאכְל֖וּ וַיִּשְׁתּֽוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","וַיַּשְׁכִּ֣ימוּ בַבֹּ֔קֶר וַיִּשָּׁבְע֖וּ אִ֣ישׁ לְאָחִ֑יו וַיְשַׁלְּחֵ֣ם יִצְחָ֔ק וַיֵּלְכ֥וּ מֵאִתֹּ֖ו בְּשָׁלֹֽום׃ ");
INSERT INTO hbo_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","וַיְהִ֣י ׀ בַּיֹּ֣ום הַה֗וּא וַיָּבֹ֙אוּ֙ עַבְדֵ֣י יִצְחָ֔ק וַיַּגִּ֣דוּ לֹ֔ו עַל־אֹדֹ֥ות הַבְּאֵ֖ר אֲשֶׁ֣ר חָפָ֑רוּ וַיֹּ֥אמְרוּ לֹ֖ו מָצָ֥אנוּ מָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","וַיִּקְרָ֥א אֹתָ֖הּ שִׁבְעָ֑ה עַל־כֵּ֤ן שֵׁם־הָעִיר֙ בְּאֵ֣ר שֶׁ֔בַע עַ֖ד הַיֹּ֥ום הַזֶּֽה׃ ס ");
INSERT INTO hbo_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","וַיְהִ֤י עֵשָׂו֙ בֶּן־אַרְבָּעִ֣ים שָׁנָ֔ה וַיִּקַּ֤ח אִשָּׁה֙ אֶת־יְהוּדִ֔ית בַּת־בְּאֵרִ֖י הַֽחִתִּ֑י וְאֶת־בָּ֣שְׂמַ֔ת בַּת־אֵילֹ֖ן הֽ͏ַחִתִּֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","וַתִּהְיֶ֖יןָ מֹ֣רַת ר֑וּחַ לְיִצְחָ֖ק וּלְרִבְקָֽה׃ ס ");
INSERT INTO hbo_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","וַיְהִי֙ כִּֽי־זָקֵ֣ן יִצְחָ֔ק וַתִּכְהֶ֥יןָ עֵינָ֖יו מֵרְאֹ֑ת וַיִּקְרָ֞א אֶת־עֵשָׂ֣ו ׀ בְּנֹ֣ו הַגָּדֹ֗ל וַיֹּ֤אמֶר אֵלָיו֙ בְּנִ֔י וַיֹּ֥אמֶר אֵלָ֖יו הִנֵּֽנִי׃ ");
INSERT INTO hbo_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","וַיֹּ֕אמֶר הִנֵּה־נָ֖א זָקַ֑נְתִּי לֹ֥א יָדַ֖עְתִּי יֹ֥ום מֹותִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","וְעַתָּה֙ שָׂא־נָ֣א כֵלֶ֔יךָ תֶּלְיְךָ֖ וְקַשְׁתֶּ֑ךָ וְצֵא֙ הַשָּׂדֶ֔ה וְצ֥וּדָה לִּ֖י *צֵידָה (צָֽיִד)׃ ");
INSERT INTO hbo_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","וַעֲשֵׂה־לִ֨י מַטְעַמִּ֜ים כַּאֲשֶׁ֥ר אָהַ֛בְתִּי וְהָבִ֥יאָה לִּ֖י וְאֹכֵ֑לָה בַּעֲב֛וּר תְּבָרֶכְךָ֥ נַפְשִׁ֖י בְּטֶ֥רֶם אָמֽוּת׃ ");
INSERT INTO hbo_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","וְרִבְקָ֣ה שֹׁמַ֔עַת בְּדַבֵּ֣ר יִצְחָ֔ק אֶל־עֵשָׂ֖ו בְּנֹ֑ו וַיֵּ֤לֶךְ עֵשָׂו֙ הַשָּׂדֶ֔ה לָצ֥וּד צַ֖יִד לְהָבִֽיא׃ ");
INSERT INTO hbo_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","וְרִבְקָה֙ אָֽמְרָ֔ה אֶל־יַעֲקֹ֥ב בְּנָ֖הּ לֵאמֹ֑ר הִנֵּ֤ה שָׁמַ֙עְתִּי֙ אֶת־אָבִ֔יךָ מְדַבֵּ֛ר אֶל־עֵשָׂ֥ו אָחִ֖יךָ לֵאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","הָבִ֨יאָה לִּ֥י צַ֛יִד וַעֲשֵׂה־לִ֥י מַטְעַמִּ֖ים וְאֹכֵ֑לָה וַאֲבָרֶכְכָ֛ה לִפְנֵ֥י יְהוָ֖ה לִפְנֵ֥י מֹותִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","וְעַתָּ֥ה בְנִ֖י שְׁמַ֣ע בְּקֹלִ֑י לַאֲשֶׁ֥ר אֲנִ֖י מְצַוָּ֥ה אֹתָֽךְ׃ ");
INSERT INTO hbo_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","לֶךְ־נָא֙ אֶל־הַצֹּ֔אן וְקַֽח־לִ֣י מִשָּׁ֗ם שְׁנֵ֛י גְּדָיֵ֥י עִזִּ֖ים טֹבִ֑ים וְאֽ͏ֶעֱשֶׂ֨ה אֹתָ֧ם מַטְעַמִּ֛ים לְאָבִ֖יךָ כַּאֲשֶׁ֥ר אָהֵֽב׃ ");
INSERT INTO hbo_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","וְהֵבֵאתָ֥ לְאָבִ֖יךָ וְאָכָ֑ל בַּעֲבֻ֛ר אֲשֶׁ֥ר יְבָרֶכְךָ֖ לִפְנֵ֥י מֹותֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","וַיֹּ֣אמֶר יַעֲקֹ֔ב אֶל־רִבְקָ֖ה אִמֹּ֑ו הֵ֣ן עֵשָׂ֤ו אָחִי֙ אִ֣ישׁ שָׂעִ֔ר וְאָנֹכִ֖י אִ֥ישׁ חָלָֽק׃ ");
INSERT INTO hbo_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","אוּלַ֤י יְמֻשֵּׁ֙נִי֙ אָבִ֔י וְהָיִ֥יתִי בְעֵינָ֖יו כִּמְתַעְתֵּ֑עַ וְהֵבֵאתִ֥י עָלַ֛י קְלָלָ֖ה וְלֹ֥א בְרָכָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","וַתֹּ֤אמֶר לֹו֙ אִמֹּ֔ו עָלַ֥י קִלְלָתְךָ֖ בְּנִ֑י אַ֛ךְ שְׁמַ֥ע בְּקֹלִ֖י וְלֵ֥ךְ קַֽח־לִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","וַיֵּ֙לֶךְ֙ וַיִּקַּ֔ח וַיָּבֵ֖א לְאִמֹּ֑ו וַתַּ֤עַשׂ אִמֹּו֙ מַטְעַמִּ֔ים כַּאֲשֶׁ֖ר אָהֵ֥ב אָבִֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","וַתִּקַּ֣ח רִ֠בְקָה אֶת־בִּגְדֵ֨י עֵשָׂ֜ו בְּנָ֤הּ הַגָּדֹל֙ הַחֲמֻדֹ֔ת אֲשֶׁ֥ר אִתָּ֖הּ בַּבָּ֑יִת וַתַּלְבֵּ֥שׁ אֶֽת־יַעֲקֹ֖ב בְּנָ֥הּ הַקָּטָֽן׃ ");
INSERT INTO hbo_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","וְאֵ֗ת עֹרֹת֙ גְּדָיֵ֣י הָֽעִזִּ֔ים הִלְבִּ֖ישָׁה עַל־יָדָ֑יו וְעַ֖ל חֶלְקַ֥ת צַוָּארָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","וַתִּתֵּ֧ן אֶת־הַמַּטְעַמִּ֛ים וְאֶת־הַלֶּ֖חֶם אֲשֶׁ֣ר עָשָׂ֑תָה בְּיַ֖ד יַעֲקֹ֥ב בְּנָֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","וַיָּבֹ֥א אֶל־אָבִ֖יו וַיֹּ֣אמֶר אָבִ֑י וַיֹּ֣אמֶר הִנֶּ֔נִּי מִ֥י אַתָּ֖ה בְּנִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","וַיֹּ֨אמֶר יַעֲקֹ֜ב אֶל־אָבִ֗יו אָנֹכִי֙ עֵשָׂ֣ו בְּכֹרֶ֔ךָ עָשִׂ֕יתִי כַּאֲשֶׁ֥ר דִּבַּ֖רְתָּ אֵלָ֑י קֽוּם־נָ֣א שְׁבָ֗ה וְאָכְלָה֙ מִצֵּידִ֔י בַּעֲב֖וּר תְּבָרֲכַ֥נִּי נַפְשֶֽׁךָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","וַיֹּ֤אמֶר יִצְחָק֙ אֶל־בְּנֹ֔ו מַה־זֶּ֛ה מִהַ֥רְתָּ לִמְצֹ֖א בְּנִ֑י וַיֹּ֕אמֶר כִּ֥י הִקְרָ֛ה יְהוָ֥ה אֱלֹהֶ֖יךָ לְפָנָֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","וַיֹּ֤אמֶר יִצְחָק֙ אֶֽל־יַעֲקֹ֔ב גְּשָׁה־נָּ֥א וַאֲמֻֽשְׁךָ֖ בְּנִ֑י הַֽאַתָּ֥ה זֶ֛ה בְּנִ֥י עֵשָׂ֖ו אִם־לֹֽא׃ ");
INSERT INTO hbo_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","וַיִּגַּ֧שׁ יַעֲקֹ֛ב אֶל־יִצְחָ֥ק אָבִ֖יו וַיְמֻשֵּׁ֑הוּ וַיֹּ֗אמֶר הַקֹּל֙ קֹ֣ול יַעֲקֹ֔ב וְהַיָּדַ֖יִם יְדֵ֥י עֵשָֽׂו׃ ");
INSERT INTO hbo_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","וְלֹ֣א הִכִּירֹ֔ו כִּֽי־הָי֣וּ יָדָ֗יו כִּידֵ֛י עֵשָׂ֥ו אָחִ֖יו שְׂעִרֹ֑ת וַֽיְבָרְכֵֽהוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","וַיֹּ֕אמֶר אַתָּ֥ה זֶ֖ה בְּנִ֣י עֵשָׂ֑ו וַיֹּ֖אמֶר אָֽנִי׃ ");
INSERT INTO hbo_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","וַיֹּ֗אמֶר הַגִּ֤שָׁה לִּי֙ וְאֹֽכְלָה֙ מִצֵּ֣יד בְּנִ֔י לְמַ֥עַן תְּבָֽרֶכְךָ֖ נַפְשִׁ֑י וַיַּגֶּשׁ־לֹו֙ וַיֹּאכַ֔ל וַיָּ֧בֵא לֹ֦ו יַ֖יִן וַיֵּֽשְׁתְּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","וַיֹּ֥אמֶר אֵלָ֖יו יִצְחָ֣ק אָבִ֑יו גְּשָׁה־נָּ֥א וּשְׁקָה־לִּ֖י בְּנִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","וַיִּגַּשׁ֙ וַיִּשַּׁק־לֹ֔ו וַיָּ֛רַח אֶת־רֵ֥יחַ בְּגָדָ֖יו וֽ͏ַיְבָרֲכֵ֑הוּ וַיֹּ֗אמֶר רְאֵה֙ רֵ֣יחַ בְּנִ֔י כְּרֵ֣יחַ שָׂדֶ֔ה אֲשֶׁ֥ר בֵּרֲכֹ֖ו יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","וְיִֽתֶּן־לְךָ֙ הָאֱלֹהִ֔ים מִטַּל֙ הַשָּׁמַ֔יִם וּמִשְׁמַנֵּ֖י הָאָ֑רֶץ וְרֹ֥ב דָּגָ֖ן וְתִירֹֽשׁ׃ ");
INSERT INTO hbo_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","יֽ͏ַעַבְד֣וּךָ עַמִּ֗ים *וְיִשְׁתַּחוּ (וְיִֽשְׁתַּחֲו֤וּ) לְךָ֙ לְאֻמִּ֔ים הֱוֵ֤ה גְבִיר֙ לְאַחֶ֔יךָ וְיִשְׁתַּחֲוּ֥וּ לְךָ֖ בְּנֵ֣י אִמֶּ֑ךָ אֹרְרֶ֣יךָ אָר֔וּר וּֽמְבָרֲכֶ֖יךָ בָּרֽוּךְ׃ ");
INSERT INTO hbo_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","וַיְהִ֗י כַּאֲשֶׁ֨ר כִּלָּ֣ה יִצְחָק֮ לְבָרֵ֣ךְ אֶֽת־יַעֲקֹב֒ וַיְהִ֗י אַ֣ךְ יָצֹ֤א יָצָא֙ יַעֲקֹ֔ב מֵאֵ֥ת פְּנֵ֖י יִצְחָ֣ק אָבִ֑יו וְעֵשָׂ֣ו אָחִ֔יו בָּ֖א מִצֵּידֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","וַיַּ֤עַשׂ גַּם־הוּא֙ מַטְעַמִּ֔ים וַיָּבֵ֖א לְאָבִ֑יו וַיֹּ֣אמֶר לְאָבִ֗יו יָקֻ֤ם אָבִי֙ וְיֹאכַל֙ מִצֵּ֣יד בְּנֹ֔ו בַּעֲב֖וּר תְּבָרֲכַ֥נִּי נַפְשֶֽׁךָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","וַיֹּ֥אמֶר לֹ֛ו יִצְחָ֥ק אָבִ֖יו מִי־אָ֑תָּה וַיֹּ֕אמֶר אֲנִ֛י בִּנְךָ֥ בְכֹֽרְךָ֖ עֵשָֽׂו׃ ");
INSERT INTO hbo_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","וַיֶּחֱרַ֨ד יִצְחָ֣ק חֲרָדָה֮ גְּדֹלָ֣ה עַד־מְאֹד֒ וַיֹּ֡אמֶר מִֽי־אֵפֹ֡וא ה֣וּא הַצָּֽד־צַיִד֩ וַיָּ֨בֵא לִ֜י וָאֹכַ֥ל מִכֹּ֛ל בְּטֶ֥רֶם תָּבֹ֖וא וָאֲבָרֲכֵ֑הוּ גַּם־בָּר֖וּךְ יִהְיֶֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","כִּשְׁמֹ֤עַ עֵשָׂו֙ אֶת־דִּבְרֵ֣י אָבִ֔יו וַיִּצְעַ֣ק צְעָקָ֔ה גְּדֹלָ֥ה וּמָרָ֖ה עַד־מְאֹ֑ד וַיֹּ֣אמֶר לְאָבִ֔יו בָּרֲכֵ֥נִי גַם־אָ֖נִי אָבִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","וַיֹּ֕אמֶר בָּ֥א אָחִ֖יךָ בְּמִרְמָ֑ה וַיִּקַּ֖ח בִּרְכָתֶֽךָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","וַיֹּ֡אמֶר הֲכִי֩ קָרָ֨א שְׁמֹ֜ו יַעֲקֹ֗ב וֽ͏ַיַּעְקְבֵ֙נִי֙ זֶ֣ה פַעֲמַ֔יִם אֶת־בְּכֹרָתִ֣י לָקָ֔ח וְהִנֵּ֥ה עַתָּ֖ה לָקַ֣ח בִּרְכָתִ֑י וַיֹּאמַ֕ר הֲלֹא־אָצַ֥לְתָּ לִּ֖י בְּרָכָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","וַיַּ֨עַן יִצְחָ֜ק וַיֹּ֣אמֶר לְעֵשָׂ֗ו הֵ֣ן גְּבִ֞יר שַׂמְתִּ֥יו לָךְ֙ וְאֶת־כָּל־אֶחָ֗יו נָתַ֤תִּי לֹו֙ לַעֲבָדִ֔ים וְדָגָ֥ן וְתִירֹ֖שׁ סְמַכְתִּ֑יו וּלְכָ֣ה אֵפֹ֔וא מָ֥ה אֽ͏ֶעֱשֶׂ֖ה בְּנִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","וַיֹּ֨אמֶר עֵשָׂ֜ו אֶל־אָבִ֗יו הַֽבְרָכָ֨ה אַחַ֤ת הִֽוא־לְךָ֙ אָבִ֔י בָּרֲכֵ֥נִי גַם־אָ֖נִי אָבִ֑י וַיִּשָּׂ֥א עֵשָׂ֛ו קֹלֹ֖ו וַיֵּֽבְךְּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","וַיַּ֛עַן יִצְחָ֥ק אָבִ֖יו וַיֹּ֣אמֶר אֵלָ֑יו הִנֵּ֞ה מִשְׁמַנֵּ֤י הָאָ֙רֶץ֙ יִהְיֶ֣ה מֹֽושָׁבֶ֔ךָ וּמִטַּ֥ל הַשָּׁמַ֖יִם מֵעָֽל׃ ");
INSERT INTO hbo_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","וְעַל־חַרְבְּךָ֣ תִֽחְיֶ֔ה וְאֶת־אָחִ֖יךָ תַּעֲבֹ֑ד וְהָיָה֙ כַּאֲשֶׁ֣ר תָּרִ֔יד וּפָרַקְתָּ֥ עֻלֹּ֖ו מֵעַ֥ל צַוָּארֶֽךָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","וַיִּשְׂטֹ֤ם עֵשָׂו֙ אֶֽת־יַעֲקֹ֔ב עַל־הַ֨בְּרָכָ֔ה אֲשֶׁ֥ר בֵּרֲכֹ֖ו אָבִ֑יו וַיֹּ֨אמֶר עֵשָׂ֜ו בְּלִבֹּ֗ו יִקְרְבוּ֙ יְמֵי֙ אֵ֣בֶל אָבִ֔י וְאַֽהַרְגָ֖ה אֶת־יַעֲקֹ֥ב אָחִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","וַיֻּגַּ֣ד לְרִבְקָ֔ה אֶת־דִּבְרֵ֥י עֵשָׂ֖ו בְּנָ֣הּ הַגָּדֹ֑ל וַתִּשְׁלַ֞ח וַתִּקְרָ֤א לְיַעֲקֹב֙ בְּנָ֣הּ הַקָּטָ֔ן וַתֹּ֣אמֶר אֵלָ֔יו הִנֵּה֙ עֵשָׂ֣ו אָחִ֔יךָ מִתְנַחֵ֥ם לְךָ֖ לְהָרְגֶֽךָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","וְעַתָּ֥ה בְנִ֖י שְׁמַ֣ע בְּקֹלִ֑י וְק֧וּם בְּרַח־לְךָ֛ אֶל־לָבָ֥ן אָחִ֖י חָרָֽנָה׃ ");
INSERT INTO hbo_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","וְיָשַׁבְתָּ֥ עִמֹּ֖ו יָמִ֣ים אֲחָדִ֑ים עַ֥ד אֲשֶׁר־תָּשׁ֖וּב חֲמַ֥ת אָחִֽיךָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","עַד־שׁ֨וּב אַף־אָחִ֜יךָ מִמְּךָ֗ וְשָׁכַח֙ אֵ֣ת אֲשֶׁר־עָשִׂ֣יתָ לֹּ֔ו וְשָׁלַחְתִּ֖י וּלְקַחְתִּ֣יךָ מִשָּׁ֑ם לָמָ֥ה אֶשְׁכַּ֛ל גַּם־שְׁנֵיכֶ֖ם יֹ֥ום אֶחָֽד׃ ");
INSERT INTO hbo_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","וַתֹּ֤אמֶר רִבְקָה֙ אֶל־יִצְחָ֔ק קַ֣צְתִּי בְחַיַּ֔י מִפְּנֵ֖י בְּנֹ֣ות חֵ֑ת אִם־לֹקֵ֣חַ יַ֠עֲקֹב אִשָּׁ֨ה מִבְּנֹֽות־חֵ֤ת כָּאֵ֙לֶּה֙ מִבְּנֹ֣ות הָאָ֔רֶץ לָ֥מָּה לִּ֖י חַיִּֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","וַיִּקְרָ֥א יִצְחָ֛ק אֶֽל־יַעֲקֹ֖ב וַיְבָ֣רֶךְ אֹתֹ֑ו וַיְצַוֵּ֙הוּ֙ וַיֹּ֣אמֶר לֹ֔ו לֹֽא־תִקַּ֥ח אִשָּׁ֖ה מִבְּנֹ֥ות כְּנָֽעַן׃ ");
INSERT INTO hbo_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","ק֥וּם לֵךְ֙ פַּדֶּ֣נָֽה אֲרָ֔ם בֵּ֥יתָה בְתוּאֵ֖ל אֲבִ֣י אִמֶּ֑ךָ וְקַח־לְךָ֤ מִשָּׁם֙ אִשָּׁ֔ה מִבְּנֹ֥ות לָבָ֖ן אֲחִ֥י אִמֶּֽךָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","וְאֵ֤ל שַׁדַּי֙ יְבָרֵ֣ךְ אֹֽתְךָ֔ וְיַפְרְךָ֖ וְיַרְבֶּ֑ךָ וְהָיִ֖יתָ לִקְהַ֥ל עַמִּֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","וְיִֽתֶּן־לְךָ֙ אֶת־בִּרְכַּ֣ת אַבְרָהָ֔ם לְךָ֖ וּלְזַרְעֲךָ֣ אִתָּ֑ךְ לְרִשְׁתְּךָ֙ אֶת־אֶ֣רֶץ מְגֻרֶ֔יךָ אֲשֶׁר־נָתַ֥ן אֱלֹהִ֖ים לְאַבְרָהָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","וַיִּשְׁלַ֤ח יִצְחָק֙ אֶֽת־יַעֲקֹ֔ב וַיֵּ֖לֶךְ פַּדֶּ֣נָֽה אֲרָ֑ם אֶל־לָבָ֤ן בֶּן־בְּתוּאֵל֙ הָֽאֲרַמִּ֔י אֲחִ֣י רִבְקָ֔ה אֵ֥ם יַעֲקֹ֖ב וְעֵשָֽׂו׃ ");
INSERT INTO hbo_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","וַיַּ֣רְא עֵשָׂ֗ו כִּֽי־בֵרַ֣ךְ יִצְחָק֮ אֶֽת־יַעֲקֹב֒ וְשִׁלַּ֤ח אֹתֹו֙ פַּדֶּ֣נָֽה אֲרָ֔ם לָקַֽחַת־לֹ֥ו מִשָּׁ֖ם אִשָּׁ֑ה בְּבָרֲכֹ֣ו אֹתֹ֔ו וַיְצַ֤ו עָלָיו֙ לֵאמֹ֔ר לֹֽא־תִקַּ֥ח אִשָּׁ֖ה מִבְּנֹ֥ות כְּנָֽעַן׃ ");
INSERT INTO hbo_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","וַיִּשְׁמַ֣ע יַעֲקֹ֔ב אֶל־אָבִ֖יו וְאֶל־אִמֹּ֑ו וַיֵּ֖לֶךְ פַּדֶּ֥נָֽה אֲרָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","וַיַּ֣רְא עֵשָׂ֔ו כִּ֥י רָעֹ֖ות בְּנֹ֣ות כְּנָ֑עַן בְּעֵינֵ֖י יִצְחָ֥ק אָבִֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","וַיֵּ֥לֶךְ עֵשָׂ֖ו אֶל־יִשְׁמָעֵ֑אל וַיִּקַּ֡ח אֶֽת־מָחֲלַ֣ת ׀ בַּת־יִשְׁמָעֵ֨אל בֶּן־אַבְרָהָ֜ם אֲחֹ֧ות נְבָיֹ֛ות עַל־נָשָׁ֖יו לֹ֥ו לְאִשָּֽׁה׃ ס ");
INSERT INTO hbo_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","וַיֵּצֵ֥א יַעֲקֹ֖ב מִבְּאֵ֣ר שָׁ֑בַע וַיֵּ֖לֶךְ חָרָֽנָה׃ ");
INSERT INTO hbo_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","וַיִּפְגַּ֨ע בַּמָּקֹ֜ום וַיָּ֤לֶן שָׁם֙ כִּי־בָ֣א הַשֶּׁ֔מֶשׁ וַיִּקַּח֙ מֵאַבְנֵ֣י הַמָּקֹ֔ום וַיָּ֖שֶׂם מְרַֽאֲשֹׁתָ֑יו וַיִּשְׁכַּ֖ב בַּמָּקֹ֥ום הַהֽוּא׃ ");
INSERT INTO hbo_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","וֽ͏ַיַּחֲלֹ֗ם וְהִנֵּ֤ה סֻלָּם֙ מֻצָּ֣ב אַ֔רְצָה וְרֹאשֹׁ֖ו מַגִּ֣יעַ הַשָּׁמָ֑יְמָה וְהִנֵּה֙ מַלְאֲכֵ֣י אֱלֹהִ֔ים עֹלִ֥ים וְיֹרְדִ֖ים בֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","וְהִנֵּ֨ה יְהוָ֜ה נִצָּ֣ב עָלָיו֮ וַיֹּאמַר֒ אֲנִ֣י יְהוָ֗ה אֱלֹהֵי֙ אַבְרָהָ֣ם אָבִ֔יךָ וֵאלֹהֵ֖י יִצְחָ֑ק הָאָ֗רֶץ אֲשֶׁ֤ר אַתָּה֙ שֹׁכֵ֣ב עָלֶ֔יהָ לְךָ֥ אֶתְּנֶ֖נָּה וּלְזַרְעֶֽךָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","וְהָיָ֤ה זַרְעֲךָ֙ כַּעֲפַ֣ר הָאָ֔רֶץ וּפָרַצְתָּ֛ יָ֥מָּה וָקֵ֖דְמָה וְצָפֹ֣נָה וָנֶ֑גְבָּה וְנִבְרֲכ֥וּ בְךָ֛ כָּל־מִשְׁפְּחֹ֥ת הָאֲדָמָ֖ה וּבְזַרְעֶֽךָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","וְהִנֵּ֨ה אָנֹכִ֜י עִמָּ֗ךְ וּשְׁמַרְתִּ֙יךָ֙ בְּכֹ֣ל אֲשֶׁר־תֵּלֵ֔ךְ וַהֲשִׁ֣בֹתִ֔יךָ אֶל־הָאֲדָמָ֖ה הַזֹּ֑את כִּ֚י לֹ֣א אֽ͏ֶעֱזָבְךָ֔ עַ֚ד אֲשֶׁ֣ר אִם־עָשִׂ֔יתִי אֵ֥ת אֲשֶׁר־דִּבַּ֖רְתִּי לָֽךְ׃ ");
INSERT INTO hbo_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","וַיִּיקַ֣ץ יַעֲקֹב֮ מִשְּׁנָתֹו֒ וַיֹּ֕אמֶר אָכֵן֙ יֵ֣שׁ יְהוָ֔ה בַּמָּקֹ֖ום הַזֶּ֑ה וְאָנֹכִ֖י לֹ֥א יָדָֽעְתִּי׃ ");
INSERT INTO hbo_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","וַיִּירָא֙ וַיֹּאמַ֔ר מַה־נֹּורָ֖א הַמָּקֹ֣ום הַזֶּ֑ה אֵ֣ין זֶ֗ה כִּ֚י אִם־בֵּ֣ית אֱלֹהִ֔ים וְזֶ֖ה שַׁ֥עַר הַשָּׁמָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","וַיַּשְׁכֵּ֨ם יַעֲקֹ֜ב בַּבֹּ֗קֶר וַיִּקַּ֤ח אֶת־הָאֶ֙בֶן֙ אֲשֶׁר־שָׂ֣ם מְרַֽאֲשֹׁתָ֔יו וַיָּ֥שֶׂם אֹתָ֖הּ מַצֵּבָ֑ה וַיִּצֹ֥ק שֶׁ֖מֶן עַל־רֹאשָֽׁהּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","וַיִּקְרָ֛א אֶת־שֵֽׁם־הַמָּקֹ֥ום הַה֖וּא בֵּֽית־אֵ֑ל וְאוּלָ֛ם ל֥וּז שֵׁם־הָעִ֖יר לָרִאשֹׁנָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","וַיִּדַּ֥ר יַעֲקֹ֖ב נֶ֣דֶר לֵאמֹ֑ר אִם־יִהְיֶ֨ה אֱלֹהִ֜ים עִמָּדִ֗י וּשְׁמָרַ֙נִי֙ בַּדֶּ֤רֶךְ הַזֶּה֙ אֲשֶׁ֣ר אָנֹכִ֣י הֹולֵ֔ךְ וְנָֽתַן־לִ֥י לֶ֛חֶם לֶאֱכֹ֖ל וּבֶ֥גֶד לִלְבֹּֽשׁ׃ ");
INSERT INTO hbo_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","וְשַׁבְתִּ֥י בְשָׁלֹ֖ום אֶל־בֵּ֣ית אָבִ֑י וְהָיָ֧ה יְהוָ֛ה לִ֖י לֵאלֹהִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","וְהָאֶ֣בֶן הַזֹּ֗את אֲשֶׁר־שַׂ֙מְתִּי֙ מַצֵּבָ֔ה יִהְיֶ֖ה בֵּ֣ית אֱלֹהִ֑ים וְכֹל֙ אֲשֶׁ֣ר תִּתֶּן־לִ֔י עַשֵּׂ֖ר אֲעַשְּׂרֶ֥נּוּ לָֽךְ׃ ");
INSERT INTO hbo_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","וַיִּשָּׂ֥א יַעֲקֹ֖ב רַגְלָ֑יו וַיֵּ֖לֶךְ אַ֥רְצָה בְנֵי־קֶֽדֶם׃ ");
INSERT INTO hbo_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","וַיַּ֞רְא וְהִנֵּ֧ה בְאֵ֣ר בַּשָּׂדֶ֗ה וְהִנֵּה־שָׁ֞ם שְׁלֹשָׁ֤ה עֶדְרֵי־צֹאן֙ רֹבְצִ֣ים עָלֶ֔יהָ כִּ֚י מִן־הַבְּאֵ֣ר הַהִ֔וא יַשְׁק֖וּ הָעֲדָרִ֑ים וְהָאֶ֥בֶן גְּדֹלָ֖ה עַל־פִּ֥י הַבְּאֵֽר׃ ");
INSERT INTO hbo_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","וְנֶאֶסְפוּ־שָׁ֣מָּה כָל־הָעֲדָרִ֗ים וְגָלֲל֤וּ אֶת־הָאֶ֙בֶן֙ מֵעַל֙ פִּ֣י הַבְּאֵ֔ר וְהִשְׁק֖וּ אֶת־הַצֹּ֑אן וְהֵשִׁ֧יבוּ אֶת־הָאֶ֛בֶן עַל־פִּ֥י הַבְּאֵ֖ר לִמְקֹמָֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","וַיֹּ֤אמֶר לָהֶם֙ יַעֲקֹ֔ב אַחַ֖י מֵאַ֣יִן אַתֶּ֑ם וַיֹּ֣אמְר֔וּ מֵחָרָ֖ן אֲנָֽחְנוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","וַיֹּ֣אמֶר לָהֶ֔ם הַיְדַעְתֶּ֖ם אֶת־לָבָ֣ן בֶּן־נָחֹ֑ור וַיֹּאמְר֖וּ יָדָֽעְנוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","וַיֹּ֥אמֶר לָהֶ֖ם הֲשָׁלֹ֣ום לֹ֑ו וַיֹּאמְר֣וּ שָׁלֹ֔ום וְהִנֵּה֙ רָחֵ֣ל בִּתֹּ֔ו בָּאָ֖ה עִם־הַצֹּֽאן׃ ");
INSERT INTO hbo_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","וַיֹּ֗אמֶר הֵ֥ן עֹוד֙ הַיֹּ֣ום גָּדֹ֔ול לֹא־עֵ֖ת הֵאָסֵ֣ף הַמִּקְנֶ֑ה הַשְׁק֥וּ הַצֹּ֖אן וּלְכ֥וּ רְעֽוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","וַיֹּאמְרוּ֮ לֹ֣א נוּכַל֒ עַ֣ד אֲשֶׁ֤ר יֵאָֽסְפוּ֙ כָּל־הָ֣עֲדָרִ֔ים וְגָֽלֲלוּ֙ אֶת־הָאֶ֔בֶן מֵעַ֖ל פִּ֣י הַבְּאֵ֑ר וְהִשְׁקִ֖ינוּ הַצֹּֽאן׃ ");
INSERT INTO hbo_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","עֹודֶ֖נּוּ מְדַבֵּ֣ר עִמָּ֑ם וְרָחֵ֣ל ׀ בָּ֗אָה עִם־הַצֹּאן֙ אֲשֶׁ֣ר לְאָבִ֔יהָ כִּ֥י רֹעָ֖ה הִֽוא׃ ");
INSERT INTO hbo_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","וַיְהִ֡י כַּאֲשֶׁר֩ רָאָ֨ה יַעֲקֹ֜ב אֶת־רָחֵ֗ל בַּת־לָבָן֙ אֲחִ֣י אִמֹּ֔ו וְאֶת־צֹ֥אן לָבָ֖ן אֲחִ֣י אִמֹּ֑ו וַיִּגַּ֣שׁ יַעֲקֹ֗ב וַיָּ֤גֶל אֶת־הָאֶ֙בֶן֙ מֵעַל֙ פִּ֣י הַבְּאֵ֔ר וַיַּ֕שְׁקְ אֶת־צֹ֥אן לָבָ֖ן אֲחִ֥י אִמֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","וַיִּשַּׁ֥ק יַעֲקֹ֖ב לְרָחֵ֑ל וַיִּשָּׂ֥א אֶת־קֹלֹ֖ו וַיֵּֽבְךְּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","וַיַּגֵּ֨ד יַעֲקֹ֜ב לְרָחֵ֗ל כִּ֣י אֲחִ֤י אָבִ֙יהָ֙ ה֔וּא וְכִ֥י בֶן־רִבְקָ֖ה ה֑וּא וַתָּ֖רָץ וַתַּגֵּ֥ד לְאָבִֽיהָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","וַיְהִי֩ כִשְׁמֹ֨עַ לָבָ֜ן אֶת־שֵׁ֣מַע ׀ יַעֲקֹ֣ב בֶּן־אֲחֹתֹ֗ו וַיָּ֤רָץ לִקְרָאתֹו֙ וַיְחַבֶּק־לֹו֙ וַיְנַשֶּׁק־לֹ֔ו וַיְבִיאֵ֖הוּ אֶל־בֵּיתֹ֑ו וַיְסַפֵּ֣ר לְלָבָ֔ן אֵ֥ת כָּל־הַדְּבָרִ֖ים הָאֵֽלֶּה׃ ");
INSERT INTO hbo_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","וַיֹּ֤אמֶר לֹו֙ לָבָ֔ן אַ֛ךְ עַצְמִ֥י וּבְשָׂרִ֖י אָ֑תָּה וַיֵּ֥שֶׁב עִמֹּ֖ו חֹ֥דֶשׁ יָמִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","וַיֹּ֤אמֶר לָבָן֙ לְיַעֲקֹ֔ב הֲכִי־אָחִ֣י אַ֔תָּה וַעֲבַדְתַּ֖נִי חִנָּ֑ם הַגִּ֥ידָה לִּ֖י מַה־מַּשְׂכֻּרְתֶּֽךָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","וּלְלָבָ֖ן שְׁתֵּ֣י בָנֹ֑ות שֵׁ֤ם הַגְּדֹלָה֙ לֵאָ֔ה וְשֵׁ֥ם הַקְּטַנָּ֖ה רָחֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","וְעֵינֵ֥י לֵאָ֖ה רַכֹּ֑ות וְרָחֵל֙ הָֽיְתָ֔ה יְפַת־תֹּ֖אַר וִיפַ֥ת מַרְאֶֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","וַיֶּאֱהַ֥ב יַעֲקֹ֖ב אֶת־רָחֵ֑ל וַיֹּ֗אמֶר אֽ͏ֶעֱבָדְךָ֙ שֶׁ֣בַע שָׁנִ֔ים בְּרָחֵ֥ל בִּתְּךָ֖ הַקְּטַנָּֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","וַיֹּ֣אמֶר לָבָ֗ן טֹ֚וב תִּתִּ֣י אֹתָ֣הּ לָ֔ךְ מִתִּתִּ֥י אֹתָ֖הּ לְאִ֣ישׁ אַחֵ֑ר שְׁבָ֖ה עִמָּדִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","וַיַּעֲבֹ֧ד יַעֲקֹ֛ב בְּרָחֵ֖ל שֶׁ֣בַע שָׁנִ֑ים וַיִּהְי֤וּ בְעֵינָיו֙ כְּיָמִ֣ים אֲחָדִ֔ים בְּאַהֲבָתֹ֖ו אֹתָֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","וַיֹּ֨אמֶר יַעֲקֹ֤ב אֶל־לָבָן֙ הָבָ֣ה אֶת־אִשְׁתִּ֔י כִּ֥י מָלְא֖וּ יָמָ֑י וְאָבֹ֖ואָה אֵלֶֽיהָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","וַיֶּאֱסֹ֥ף לָבָ֛ן אֶת־כָּל־אַנְשֵׁ֥י הַמָּקֹ֖ום וַיַּ֥עַשׂ מִשְׁתֶּֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","וַיְהִ֣י בָעֶ֔רֶב וַיִּקַּח֙ אֶת־לֵאָ֣ה בִתֹּ֔ו וַיָּבֵ֥א אֹתָ֖הּ אֵלָ֑יו וַיָּבֹ֖א אֵלֶֽיהָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","וַיִּתֵּ֤ן לָבָן֙ לָ֔הּ אֶת־זִלְפָּ֖ה שִׁפְחָתֹ֑ו לְלֵאָ֥ה בִתֹּ֖ו שִׁפְחָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","וַיְהִ֣י בַבֹּ֔קֶר וְהִנֵּה־הִ֖וא לֵאָ֑ה וַיֹּ֣אמֶר אֶל־לָבָ֗ן מַה־זֹּאת֙ עָשִׂ֣יתָ לִּ֔י הֲלֹ֤א בְרָחֵל֙ עָבַ֣דְתִּי עִמָּ֔ךְ וְלָ֖מָּה רִמִּיתָֽנִי׃ ");
INSERT INTO hbo_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","וַיֹּ֣אמֶר לָבָ֔ן לֹא־יֵעָשֶׂ֥ה כֵ֖ן בִּמְקֹומֵ֑נוּ לָתֵ֥ת הַצְּעִירָ֖ה לִפְנֵ֥י הַבְּכִירָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","מַלֵּ֖א שְׁבֻ֣עַ זֹ֑את וְנִתְּנָ֨ה לְךָ֜ גַּם־אֶת־זֹ֗את בַּעֲבֹדָה֙ אֲשֶׁ֣ר תַּעֲבֹ֣ד עִמָּדִ֔י עֹ֖וד שֶֽׁבַע־שָׁנִ֥ים אֲחֵרֹֽות׃ ");
INSERT INTO hbo_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","וַיַּ֤עַשׂ יַעֲקֹב֙ כֵּ֔ן וַיְמַלֵּ֖א שְׁבֻ֣עַ זֹ֑את וַיִּתֶּן־לֹ֛ו אֶת־רָחֵ֥ל בִּתֹּ֖ו לֹ֥ו לְאִשָּֽׁה׃ ");
INSERT INTO hbo_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","וַיִּתֵּ֤ן לָבָן֙ לְרָחֵ֣ל בִּתֹּ֔ו אֶת־בִּלְהָ֖ה שִׁפְחָתֹ֑ו לָ֖הּ לְשִׁפְחָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","וַיָּבֹא֙ גַּ֣ם אֶל־רָחֵ֔ל וַיֶּאֱהַ֥ב גַּֽם־אֶת־רָחֵ֖ל מִלֵּאָ֑ה וַיַּעֲבֹ֣ד עִמֹּ֔ו עֹ֖וד שֶֽׁבַע־שָׁנִ֥ים אֲחֵרֹֽות׃ ");
INSERT INTO hbo_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","וַיַּ֤רְא יְהוָה֙ כִּֽי־שְׂנוּאָ֣ה לֵאָ֔ה וַיִּפְתַּ֖ח אֶת־רַחְמָ֑הּ וְרָחֵ֖ל עֲקָרָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","וַתַּ֤הַר לֵאָה֙ וַתֵּ֣לֶד בֵּ֔ן וַתִּקְרָ֥א שְׁמֹ֖ו רְאוּבֵ֑ן כִּ֣י אָֽמְרָ֗ה כִּֽי־רָאָ֤ה יְהוָה֙ בְּעָנְיִ֔י כִּ֥י עַתָּ֖ה יֶאֱהָבַ֥נִי אִישִֽׁי׃ ");
INSERT INTO hbo_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","וַתַּ֣הַר עֹוד֮ וַתֵּ֣לֶד בֵּן֒ וַתֹּ֗אמֶר כִּֽי־שָׁמַ֤ע יְהוָה֙ כִּֽי־שְׂנוּאָ֣ה אָנֹ֔כִי וַיִּתֶּן־לִ֖י גַּם־אֶת־זֶ֑ה וַתִּקְרָ֥א שְׁמֹ֖ו שִׁמְעֹֽון׃ ");
INSERT INTO hbo_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","וַתַּ֣הַר עֹוד֮ וַתֵּ֣לֶד בֵּן֒ וַתֹּ֗אמֶר עַתָּ֤ה הַפַּ֙עַם֙ יִלָּוֶ֤ה אִישִׁי֙ אֵלַ֔י כִּֽי־יָלַ֥דְתִּי לֹ֖ו שְׁלֹשָׁ֣ה בָנִ֑ים עַל־כֵּ֥ן קָרָֽא־שְׁמֹ֖ו לֵוִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","וַתַּ֨הַר עֹ֜וד וַתֵּ֣לֶד בֵּ֗ן וַתֹּ֙אמֶר֙ הַפַּ֙עַם֙ אֹודֶ֣ה אֶת־יְהוָ֔ה עַל־כֵּ֛ן קָרְאָ֥ה שְׁמֹ֖ו יְהוּדָ֑ה וַֽתַּעֲמֹ֖ד מִלֶּֽדֶת׃ ");
INSERT INTO hbo_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","וַתֵּ֣רֶא רָחֵ֗ל כִּ֣י לֹ֤א יָֽלְדָה֙ לְיַעֲקֹ֔ב וַתְּקַנֵּ֥א רָחֵ֖ל בַּאֲחֹתָ֑הּ וַתֹּ֤אמֶר אֶֽל־יַעֲקֹב֙ הָֽבָה־לִּ֣י בָנִ֔ים וְאִם־אַ֖יִן מֵתָ֥ה אָנֹֽכִי׃ ");
INSERT INTO hbo_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","וַיִּֽחַר־אַ֥ף יַעֲקֹ֖ב בְּרָחֵ֑ל וַיֹּ֗אמֶר הֲתַ֤חַת אֱלֹהִים֙ אָנֹ֔כִי אֲשֶׁר־מָנַ֥ע מִמֵּ֖ךְ פְּרִי־בָֽטֶן׃ ");
INSERT INTO hbo_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","וַתֹּ֕אמֶר הִנֵּ֛ה אֲמָתִ֥י בִלְהָ֖ה בֹּ֣א אֵלֶ֑יהָ וְתֵלֵד֙ עַל־בִּרְכַּ֔י וְאִבָּנֶ֥ה גַם־אָנֹכִ֖י מִמֶּֽנָּה׃ ");
INSERT INTO hbo_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","וַתִּתֶּן־לֹ֛ו אֶת־בִּלְהָ֥ה שִׁפְחָתָ֖הּ לְאִשָּׁ֑ה וַיָּבֹ֥א אֵלֶ֖יהָ יַעֲקֹֽב׃ ");
INSERT INTO hbo_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","וַתַּ֣הַר בִּלְהָ֔ה וַתֵּ֥לֶד לְיַעֲקֹ֖ב בֵּֽן׃ ");
INSERT INTO hbo_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","וַתֹּ֤אמֶר רָחֵל֙ דָּנַ֣נִּי אֱלֹהִ֔ים וְגַם֙ שָׁמַ֣ע בְּקֹלִ֔י וַיִּתֶּן־לִ֖י בֵּ֑ן עַל־כֵּ֛ן קָרְאָ֥ה שְׁמֹ֖ו דָּֽן׃ ");
INSERT INTO hbo_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","וַתַּ֣הַר עֹ֔וד וַתֵּ֕לֶד בִּלְהָ֖ה שִׁפְחַ֣ת רָחֵ֑ל בֵּ֥ן שֵׁנִ֖י לְיַעֲקֹֽב׃ ");
INSERT INTO hbo_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","וַתֹּ֣אמֶר רָחֵ֗ל נַפְתּוּלֵ֨י אֱלֹהִ֧ים ׀ נִפְתַּ֛לְתִּי עִם־אֲחֹתִ֖י גַּם־יָכֹ֑לְתִּי וַתִּקְרָ֥א שְׁמֹ֖ו נַפְתָּלִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","וַתֵּ֣רֶא לֵאָ֔ה כִּ֥י עָמְדָ֖ה מִלֶּ֑דֶת וַתִּקַּח֙ אֶת־זִלְפָּ֣ה שִׁפְחָתָ֔הּ וַתִּתֵּ֥ן אֹתָ֛הּ לְיַעֲקֹ֖ב לְאִשָּֽׁה׃ ");
INSERT INTO hbo_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","וַתֵּ֗לֶד זִלְפָּ֛ה שִׁפְחַ֥ת לֵאָ֖ה לְיַעֲקֹ֥ב בֵּֽן׃ ");
INSERT INTO hbo_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","וַתֹּ֥אמֶר לֵאָ֖ה *בְּגָד (בָּ֣א גָ֑ד) וַתִּקְרָ֥א אֶת־שְׁמֹ֖ו גָּֽד׃ ");
INSERT INTO hbo_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","וַתֵּ֗לֶד זִלְפָּה֙ שִׁפְחַ֣ת לֵאָ֔ה בֵּ֥ן שֵׁנִ֖י לְיַעֲקֹֽב׃ ");
INSERT INTO hbo_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","וַתֹּ֣אמֶר לֵאָ֔ה בְּאָשְׁרִ֕י כִּ֥י אִשְּׁר֖וּנִי בָּנֹ֑ות וַתִּקְרָ֥א אֶת־שְׁמֹ֖ו אָשֵֽׁר׃ ");
INSERT INTO hbo_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","וַיֵּ֨לֶךְ רְאוּבֵ֜ן בִּימֵ֣י קְצִיר־חִטִּ֗ים וַיִּמְצָ֤א דֽוּדָאִים֙ בַּשָּׂדֶ֔ה וַיָּבֵ֣א אֹתָ֔ם אֶל־לֵאָ֖ה אִמֹּ֑ו וַתֹּ֤אמֶר רָחֵל֙ אֶל־לֵאָ֔ה תְּנִי־נָ֣א לִ֔י מִדּוּדָאֵ֖י בְּנֵֽךְ׃ ");
INSERT INTO hbo_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","וַתֹּ֣אמֶר לָ֗הּ הַמְעַט֙ קַחְתֵּ֣ךְ אֶת־אִישִׁ֔י וְלָקַ֕חַת גַּ֥ם אֶת־דּוּדָאֵ֖י בְּנִ֑י וַתֹּ֣אמֶר רָחֵ֗ל לָכֵן֙ יִשְׁכַּ֤ב עִמָּךְ֙ הַלַּ֔יְלָה תַּ֖חַת דּוּדָאֵ֥י בְנֵֽךְ׃ ");
INSERT INTO hbo_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","וַיָּבֹ֨א יַעֲקֹ֣ב מִן־הַשָּׂדֶה֮ בָּעֶרֶב֒ וַתֵּצֵ֨א לֵאָ֜ה לִקְרָאתֹ֗ו וַתֹּ֙אמֶר֙ אֵלַ֣י תָּבֹ֔וא כִּ֚י שָׂכֹ֣ר שְׂכַרְתִּ֔יךָ בְּדוּדָאֵ֖י בְּנִ֑י וַיִּשְׁכַּ֥ב עִמָּ֖הּ בַּלַּ֥יְלָה הֽוּא׃ ");
INSERT INTO hbo_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","וַיִּשְׁמַ֥ע אֱלֹהִ֖ים אֶל־לֵאָ֑ה וַתַּ֛הַר וַתֵּ֥לֶד לְיַעֲקֹ֖ב בֵּ֥ן חֲמִישִֽׁי׃ ");
INSERT INTO hbo_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","וַתֹּ֣אמֶר לֵאָ֗ה נָתַ֤ן אֱלֹהִים֙ שְׂכָרִ֔י אֲשֶׁר־נָתַ֥תִּי שִׁפְחָתִ֖י לְאִישִׁ֑י וַתִּקְרָ֥א שְׁמֹ֖ו יִשָּׂשכָֽר׃ ");
INSERT INTO hbo_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","וַתַּ֤הַר עֹוד֙ לֵאָ֔ה וַתֵּ֥לֶד בֵּן־שִׁשִּׁ֖י לְּיַעֲקֹֽב׃ ");
INSERT INTO hbo_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","וַתֹּ֣אמֶר לֵאָ֗ה זְבָדַ֨נִי אֱלֹהִ֥ים ׀ אֹתִי֮ זֵ֣בֶד טֹוב֒ הַפַּ֙עַם֙ יִזְבְּלֵ֣נִי אִישִׁ֔י כִּֽי־יָלַ֥דְתִּי לֹ֖ו שִׁשָּׁ֣ה בָנִ֑ים וַתִּקְרָ֥א אֶת־שְׁמֹ֖ו זְבֻלֽוּן׃ ");
INSERT INTO hbo_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","וְאַחַ֖ר יָ֣לְדָה בַּ֑ת וַתִּקְרָ֥א אֶת־שְׁמָ֖הּ דִּינָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","וַיִּזְכֹּ֥ר אֱלֹהִ֖ים אֶת־רָחֵ֑ל וַיִּשְׁמַ֤ע אֵלֶ֙יהָ֙ אֱלֹהִ֔ים וַיִּפְתַּ֖ח אֶת־רַחְמָֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","וַתַּ֖הַר וַתֵּ֣לֶד בֵּ֑ן וַתֹּ֕אמֶר אָסַ֥ף אֱלֹהִ֖ים אֶת־חֶרְפָּתִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","וַתִּקְרָ֧א אֶת־שְׁמֹ֛ו יֹוסֵ֖ף לֵאמֹ֑ר יֹסֵ֧ף יְהוָ֛ה לִ֖י בֵּ֥ן אַחֵֽר׃ ");
INSERT INTO hbo_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","וַיְהִ֕י כַּאֲשֶׁ֛ר יָלְדָ֥ה רָחֵ֖ל אֶת־יֹוסֵ֑ף וַיֹּ֤אמֶר יַעֲקֹב֙ אֶל־לָבָ֔ן שַׁלְּחֵ֙נִי֙ וְאֵ֣לְכָ֔ה אֶל־מְקֹומִ֖י וּלְאַרְצִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","תְּנָ֞ה אֶת־נָשַׁ֣י וְאֶת־יְלָדַ֗י אֲשֶׁ֨ר עָבַ֧דְתִּי אֹֽתְךָ֛ בָּהֵ֖ן וְאֵלֵ֑כָה כִּ֚י אַתָּ֣ה יָדַ֔עְתָּ אֶת־עֲבֹדָתִ֖י אֲשֶׁ֥ר עֲבַדְתִּֽיךָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","וַיֹּ֤אמֶר אֵלָיו֙ לָבָ֔ן אִם־נָ֛א מָצָ֥אתִי חֵ֖ן בְּעֵינֶ֑יךָ נִחַ֕שְׁתִּי וַיְבָרֲכֵ֥נִי יְהוָ֖ה בִּגְלָלֶֽךָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","וַיֹּאמַ֑ר נָקְבָ֧ה שְׂכָרְךָ֛ עָלַ֖י וְאֶתֵּֽנָה׃ ");
INSERT INTO hbo_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","וַיֹּ֣אמֶר אֵלָ֔יו אַתָּ֣ה יָדַ֔עְתָּ אֵ֖ת אֲשֶׁ֣ר עֲבַדְתִּ֑יךָ וְאֵ֛ת אֲשֶׁר־הָיָ֥ה מִקְנְךָ֖ אִתִּֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","כִּ֡י מְעַט֩ אֲשֶׁר־הָיָ֨ה לְךָ֤ לְפָנַי֙ וַיִּפְרֹ֣ץ לָרֹ֔ב וַיְבָ֧רֶךְ יְהוָ֛ה אֹתְךָ֖ לְרַגְלִ֑י וְעַתָּ֗ה מָתַ֛י אֽ͏ֶעֱשֶׂ֥ה גַם־אָנֹכִ֖י לְבֵיתִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","וַיֹּ֖אמֶר מָ֣ה אֶתֶּן־לָ֑ךְ וַיֹּ֤אמֶר יַעֲקֹב֙ לֹא־תִתֶּן־לִ֣י מְא֔וּמָה אִם־תּֽ͏ַעֲשֶׂה־לִּי֙ הַדָּבָ֣ר הַזֶּ֔ה אָשׁ֛וּבָה אֶרְעֶ֥ה צֹֽאנְךָ֖ אֶשְׁמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","אֽ͏ֶעֱבֹ֨ר בְּכָל־צֹֽאנְךָ֜ הַיֹּ֗ום הָסֵ֨ר מִשָּׁ֜ם כָּל־שֶׂ֣ה ׀ נָקֹ֣ד וְטָל֗וּא וְכָל־שֶׂה־חוּם֙ בַּכְּשָׂבִ֔ים וְטָל֥וּא וְנָקֹ֖ד בָּעִזִּ֑ים וְהָיָ֖ה שְׂכָרִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","וְעָֽנְתָה־בִּ֤י צִדְקָתִי֙ בְּיֹ֣ום מָחָ֔ר כִּֽי־תָבֹ֥וא עַל־שְׂכָרִ֖י לְפָנֶ֑יךָ כֹּ֣ל אֲשֶׁר־אֵינֶנּוּ֩ נָקֹ֨ד וְטָל֜וּא בָּֽעִזִּ֗ים וְחוּם֙ בַּכְּשָׂבִ֔ים גָּנ֥וּב ה֖וּא אִתִּֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","וַיֹּ֥אמֶר לָבָ֖ן הֵ֑ן ל֖וּ יְהִ֥י כִדְבָרֶֽךָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","וַיָּ֣סַר בַּיֹּום֩ הַה֨וּא אֶת־הַתְּיָשִׁ֜ים הָֽעֲקֻדִּ֣ים וְהַטְּלֻאִ֗ים וְאֵ֤ת כָּל־הֽ͏ָעִזִּים֙ הַנְּקֻדֹּ֣ות וְהַטְּלֻאֹ֔ת כֹּ֤ל אֲשֶׁר־לָבָן֙ בֹּ֔ו וְכָל־ח֖וּם בַּכְּשָׂבִ֑ים וַיִּתֵּ֖ן בְּיַד־בָּנָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","וַיָּ֗שֶׂם דֶּ֚רֶךְ שְׁלֹ֣שֶׁת יָמִ֔ים בֵּינֹ֖ו וּבֵ֣ין יַעֲקֹ֑ב וְיַעֲקֹ֗ב רֹעֶ֛ה אֶת־צֹ֥אן לָבָ֖ן הַנֹּותָרֹֽת׃ ");
INSERT INTO hbo_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","וַיִּֽקַּֽח־לֹ֣ו יַעֲקֹ֗ב מַקַּ֥ל לִבְנֶ֛ה לַ֖ח וְל֣וּז וְעֶרְמֹ֑ון וַיְפַצֵּ֤ל בָּהֵן֙ פְּצָלֹ֣ות לְבָנֹ֔ות מַחְשֹׂף֙ הַלָּבָ֔ן אֲשֶׁ֖ר עַל־הַמַּקְלֹֽות׃ ");
INSERT INTO hbo_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","וַיַּצֵּ֗ג אֶת־הַמַּקְלֹות֙ אֲשֶׁ֣ר פִּצֵּ֔ל בָּרֳהָטִ֖ים בְּשִֽׁקֲתֹ֣ות הַמָּ֑יִם אֲשֶׁר֩ תָּבֹ֨אןָ הַצֹּ֤אן לִשְׁתֹּות֙ לְנֹ֣כַח הַצֹּ֔אן וַיֵּחַ֖מְנָה בְּבֹאָ֥ן לִשְׁתֹּֽות׃ ");
INSERT INTO hbo_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","וַיֶּחֱמ֥וּ הַצֹּ֖אן אֶל־הַמַּקְלֹ֑ות וַתֵּלַ֣דְןָ הַצֹּ֔אן עֲקֻדִּ֥ים נְקֻדִּ֖ים וּטְלֻאִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","וְהַכְּשָׂבִים֮ הִפְרִ֣יד יַעֲקֹב֒ וַ֠יִּתֵּן פְּנֵ֨י הַצֹּ֧אן אֶל־עָקֹ֛ד וְכָל־ח֖וּם בְּצֹ֣אן לָבָ֑ן וַיָּֽשֶׁת־לֹ֤ו עֲדָרִים֙ לְבַדֹּ֔ו וְלֹ֥א שָׁתָ֖ם עַל־צֹ֥אן לָבָֽן׃ ");
INSERT INTO hbo_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","וְהָיָ֗ה בְּכָל־יַחֵם֮ הַצֹּ֣אן הַמְקֻשָּׁרֹות֒ וְשָׂ֨ם יַעֲקֹ֧ב אֶת־הַמַּקְלֹ֛ות לְעֵינֵ֥י הַצֹּ֖אן בָּרֳהָטִ֑ים לְיַחְמֵ֖נָּה בַּמַּקְלֹֽות׃ ");
INSERT INTO hbo_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","וּבְהַעֲטִ֥יף הַצֹּ֖אן לֹ֣א יָשִׂ֑ים וְהָיָ֤ה הָעֲטֻפִים֙ לְלָבָ֔ן וְהַקְּשֻׁרִ֖ים לְיַעֲקֹֽב׃ ");
INSERT INTO hbo_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","וַיִּפְרֹ֥ץ הָאִ֖ישׁ מְאֹ֣ד מְאֹ֑ד וֽ͏ַיְהִי־לֹו֙ צֹ֣אן רַבֹּ֔ות וּשְׁפָחֹות֙ וַעֲבָדִ֔ים וּגְמַלִּ֖ים וַחֲמֹרִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","וַיִּשְׁמַ֗ע אֶת־דִּבְרֵ֤י בְנֵֽי־לָבָן֙ לֵאמֹ֔ר לָקַ֣ח יַעֲקֹ֔ב אֵ֖ת כָּל־אֲשֶׁ֣ר לְאָבִ֑ינוּ וּמֵאֲשֶׁ֣ר לְאָבִ֔ינוּ עָשָׂ֕ה אֵ֥ת כָּל־הַכָּבֹ֖ד הַזֶּֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","וַיַּ֥רְא יַעֲקֹ֖ב אֶת־פְּנֵ֣י לָבָ֑ן וְהִנֵּ֥ה אֵינֶנּ֛וּ עִמֹּ֖ו כִּתְמֹ֥ול שִׁלְשֹֽׁום׃ ");
INSERT INTO hbo_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","וַיֹּ֤אמֶר יְהוָה֙ אֶֽל־יַעֲקֹ֔ב שׁ֛וּב אֶל־אֶ֥רֶץ אֲבֹותֶ֖יךָ וּלְמֹולַדְתֶּ֑ךָ וְאֶֽהְיֶ֖ה עִמָּֽךְ׃ ");
INSERT INTO hbo_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","וַיִּשְׁלַ֣ח יַעֲקֹ֔ב וַיִּקְרָ֖א לְרָחֵ֣ל וּלְלֵאָ֑ה הַשָּׂדֶ֖ה אֶל־צֹאנֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","וַיֹּ֣אמֶר לָהֶ֗ן רֹאֶ֤ה אָנֹכִי֙ אֶת־פְּנֵ֣י אֲבִיכֶ֔ן כִּֽי־אֵינֶ֥נּוּ אֵלַ֖י כִּתְמֹ֣ל שִׁלְשֹׁ֑ם וֽ͏ֵאלֹהֵ֣י אָבִ֔י הָיָ֖ה עִמָּדִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","וְאַתֵּ֖נָה יְדַעְתֶּ֑ן כִּ֚י בְּכָל־כֹּחִ֔י עָבַ֖דְתִּי אֶת־אֲבִיכֶֽן׃ ");
INSERT INTO hbo_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","וַאֲבִיכֶן֙ הֵ֣תֶל בִּ֔י וְהֶחֱלִ֥ף אֶת־מַשְׂכֻּרְתִּ֖י עֲשֶׂ֣רֶת מֹנִ֑ים וְלֹֽא־נְתָנֹ֣ו אֱלֹהִ֔ים לְהָרַ֖ע עִמָּדִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","אִם־כֹּ֣ה יֹאמַ֗ר נְקֻדִּים֙ יִהְיֶ֣ה שְׂכָרֶ֔ךָ וְיָלְד֥וּ כָל־הַצֹּ֖אן נְקֻדִּ֑ים וְאִם־כֹּ֣ה יֹאמַ֗ר עֲקֻדִּים֙ יִהְיֶ֣ה שְׂכָרֶ֔ךָ וְיָלְד֥וּ כָל־הַצֹּ֖אן עֲקֻדִּֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","וַיַּצֵּ֧ל אֱלֹהִ֛ים אֶת־מִקְנֵ֥ה אֲבִיכֶ֖ם וַיִּתֶּן־לִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","וַיְהִ֗י בְּעֵת֙ יַחֵ֣ם הַצֹּ֔אן וָאֶשָּׂ֥א עֵינַ֛י וָאֵ֖רֶא בַּחֲלֹ֑ום וְהִנֵּ֤ה הָֽעַתֻּדִים֙ הָעֹלִ֣ים עַל־הַצֹּ֔אן עֲקֻדִּ֥ים נְקֻדִּ֖ים וּבְרֻדִּֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","וַיֹּ֨אמֶר אֵלַ֜י מַלְאַ֧ךְ הָאֱלֹהִ֛ים בַּחֲלֹ֖ום יֽ͏ַעֲקֹ֑ב וָאֹמַ֖ר הִנֵּֽנִי׃ ");
INSERT INTO hbo_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","וַיֹּ֗אמֶר שָׂא־נָ֨א עֵינֶ֤יךָ וּרְאֵה֙ כָּל־הָֽעַתֻּדִים֙ הָעֹלִ֣ים עַל־הַצֹּ֔אן עֲקֻדִּ֥ים נְקֻדִּ֖ים וּבְרֻדִּ֑ים כִּ֣י רָאִ֔יתִי אֵ֛ת כָּל־אֲשֶׁ֥ר לָבָ֖ן עֹ֥שֶׂה לָּֽךְ׃ ");
INSERT INTO hbo_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","אָנֹכִ֤י הָאֵל֙ בֵּֽית־אֵ֔ל אֲשֶׁ֨ר מָשַׁ֤חְתָּ שָּׁם֙ מַצֵּבָ֔ה אֲשֶׁ֨ר נָדַ֥רְתָּ לִּ֛י שָׁ֖ם נֶ֑דֶר עַתָּ֗ה ק֥וּם צֵא֙ מִן־הָאָ֣רֶץ הַזֹּ֔את וְשׁ֖וּב אֶל־אֶ֥רֶץ מֹולַדְתֶּֽךָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","וַתַּ֤עַן רָחֵל֙ וְלֵאָ֔ה וַתֹּאמַ֖רְנָה לֹ֑ו הַעֹ֥וד לָ֛נוּ חֵ֥לֶק וְנַחֲלָ֖ה בְּבֵ֥ית אָבִֽינוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","הֲלֹ֧וא נָכְרִיֹּ֛ות נֶחְשַׁ֥בְנוּ לֹ֖ו כִּ֣י מְכָרָ֑נוּ וַיֹּ֥אכַל גַּם־אָכֹ֖ול אֶת־כַּסְפֵּֽנוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","כִּ֣י כָל־הָעֹ֗שֶׁר אֲשֶׁ֨ר הִצִּ֤יל אֱלֹהִים֙ מֵֽאָבִ֔ינוּ לָ֥נוּ ה֖וּא וּלְבָנֵ֑ינוּ וְעַתָּ֗ה כֹּל֩ אֲשֶׁ֨ר אָמַ֧ר אֱלֹהִ֛ים אֵלֶ֖יךָ עֲשֵֽׂה׃ ");
INSERT INTO hbo_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","וַיָּ֖קָם יַעֲקֹ֑ב וַיִּשָּׂ֛א אֶת־בָּנָ֥יו וְאֶת־נָשָׁ֖יו עַל־הַגְּמַלִּֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","וַיִּנְהַ֣ג אֶת־כָּל־מִקְנֵ֗הוּ וְאֶת־כָּל־רְכֻשֹׁו֙ אֲשֶׁ֣ר רָכָ֔שׁ מִקְנֵה֙ קִנְיָנֹ֔ו אֲשֶׁ֥ר רָכַ֖שׁ בְּפַדַּ֣ן אֲרָ֑ם לָבֹ֛וא אֶל־יִצְחָ֥ק אָבִ֖יו אַ֥רְצָה כְּנָֽעַן׃ ");
INSERT INTO hbo_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","וְלָבָ֣ן הָלַ֔ךְ לִגְזֹ֖ז אֶת־צֹאנֹ֑ו וַתִּגְנֹ֣ב רָחֵ֔ל אֶת־הַתְּרָפִ֖ים אֲשֶׁ֥ר לְאָבִֽיהָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","וַיִּגְנֹ֣ב יַעֲקֹ֔ב אֶת־לֵ֥ב לָבָ֖ן הָאֲרַמִּ֑י עַל־בְּלִי֙ הִגִּ֣יד לֹ֔ו כִּ֥י בֹרֵ֖חַ הֽוּא׃ ");
INSERT INTO hbo_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","וַיִּבְרַ֥ח הוּא֙ וְכָל־אֲשֶׁר־לֹ֔ו וַיָּ֖קָם וַיַּעֲבֹ֣ר אֶת־הַנָּהָ֑ר וַיָּ֥שֶׂם אֶת־פָּנָ֖יו הַ֥ר הַגִּלְעָֽד׃ ");
INSERT INTO hbo_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","וַיֻּגַּ֥ד לְלָבָ֖ן בַּיֹּ֣ום הַשְּׁלִישִׁ֑י כִּ֥י בָרַ֖ח יַעֲקֹֽב׃ ");
INSERT INTO hbo_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","וַיִּקַּ֤ח אֶת־אֶחָיו֙ עִמֹּ֔ו וַיִּרְדֹּ֣ף אַחֲרָ֔יו דֶּ֖רֶךְ שִׁבְעַ֣ת יָמִ֑ים וַיַּדְבֵּ֥ק אֹתֹ֖ו בְּהַ֥ר הַגִּלְעָֽד׃ ");
INSERT INTO hbo_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","וַיָּבֹ֧א אֱלֹהִ֛ים אֶל־לָבָ֥ן הָאֲרַמִּ֖י בַּחֲלֹ֣ם הַלָּ֑יְלָה וַיֹּ֣אמֶר לֹ֗ו הִשָּׁ֧מֶר לְךָ֛ פֶּן־תְּדַבֵּ֥ר עִֽם־יַעֲקֹ֖ב מִטֹּ֥וב עַד־רָֽע׃ ");
INSERT INTO hbo_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","וַיַּשֵּׂ֥ג לָבָ֖ן אֶֽת־יַעֲקֹ֑ב וְיַעֲקֹ֗ב תָּקַ֤ע אֶֽת־אָהֳלֹו֙ בָּהָ֔ר וְלָבָ֛ן תָּקַ֥ע אֶת־אֶחָ֖יו בְּהַ֥ר הַגִּלְעָֽד׃ ");
INSERT INTO hbo_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","וַיֹּ֤אמֶר לָבָן֙ לְיַעֲקֹ֔ב מֶ֣ה עָשִׂ֔יתָ וַתִּגְנֹ֖ב אֶת־לְבָבִ֑י וַתְּנַהֵג֙ אֶת־בְּנֹתַ֔י כִּשְׁבֻיֹ֖ות חָֽרֶב׃ ");
INSERT INTO hbo_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","לָ֤מָּה נַחְבֵּ֙אתָ֙ לִבְרֹ֔חַ וַתִּגְנֹ֖ב אֹתִ֑י וְלֹא־הִגַּ֣דְתָּ לִּ֔י וָֽאֲשַׁלֵּחֲךָ֛ בְּשִׂמְחָ֥ה וּבְשִׁרִ֖ים בְּתֹ֥ף וּבְכִנֹּֽור׃ ");
INSERT INTO hbo_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","וְלֹ֣א נְטַשְׁתַּ֔נִי לְנַשֵּׁ֥ק לְבָנַ֖י וְלִבְנֹתָ֑י עַתָּ֖ה הִסְכַּ֥לְתָּֽ עֲשֹֽׂו׃ ");
INSERT INTO hbo_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","יֶשׁ־לְאֵ֣ל יָדִ֔י לַעֲשֹׂ֥ות עִמָּכֶ֖ם רָ֑ע וֽ͏ֵאלֹהֵ֨י אֲבִיכֶ֜ם אֶ֣מֶשׁ ׀ אָמַ֧ר אֵלַ֣י לֵאמֹ֗ר הִשָּׁ֧מֶר לְךָ֛ מִדַּבֵּ֥ר עִֽם־יַעֲקֹ֖ב מִטֹּ֥וב עַד־רָֽע׃ ");
INSERT INTO hbo_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","וְעַתָּה֙ הָלֹ֣ךְ הָלַ֔כְתָּ כִּֽי־נִכְסֹ֥ף נִכְסַ֖פְתָּה לְבֵ֣ית אָבִ֑יךָ לָ֥מָּה גָנַ֖בְתָּ אֶת־אֱלֹהָֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","וַיַּ֥עַן יַעֲקֹ֖ב וַיֹּ֣אמֶר לְלָבָ֑ן כִּ֣י יָרֵ֔אתִי כִּ֣י אָמַ֔רְתִּי פֶּן־תִּגְזֹ֥ל אֶת־בְּנֹותֶ֖יךָ מֵעִמִּֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","עִ֠ם אֲשֶׁ֨ר תִּמְצָ֣א אֶת־אֱלֹהֶיךָ֮ לֹ֣א יִֽחְיֶה֒ נֶ֣גֶד אַחֵ֧ינוּ הַֽכֶּר־לְךָ֛ מָ֥ה עִמָּדִ֖י וְקַֽח־לָ֑ךְ וְלֹֽא־יָדַ֣ע יַעֲקֹ֔ב כִּ֥י רָחֵ֖ל גְּנָבָֽתַם׃ ");
INSERT INTO hbo_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","וַיָּבֹ֨א לָבָ֜ן בְּאֹ֥הֶל יַעֲקֹ֣ב ׀ וּבְאֹ֣הֶל לֵאָ֗ה וּבְאֹ֛הֶל שְׁתֵּ֥י הָאֲמָהֹ֖ת וְלֹ֣א מָצָ֑א וַיֵּצֵא֙ מֵאֹ֣הֶל לֵאָ֔ה וַיָּבֹ֖א בְּאֹ֥הֶל רָחֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","וְרָחֵ֞ל לָקְחָ֣ה אֶת־הַתְּרָפִ֗ים וַתְּשִׂמֵ֛ם בְּכַ֥ר הַגָּמָ֖ל וַתֵּ֣שֶׁב עֲלֵיהֶ֑ם וַיְמַשֵּׁ֥שׁ לָבָ֛ן אֶת־כָּל־הָאֹ֖הֶל וְלֹ֥א מָצָֽא׃ ");
INSERT INTO hbo_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","וַתֹּ֣אמֶר אֶל־אָבִ֗יהָ אַל־יִ֙חַר֙ בְּעֵינֵ֣י אֲדֹנִ֔י כִּ֣י לֹ֤וא אוּכַל֙ לָק֣וּם מִפָּנֶ֔יךָ כִּי־דֶ֥רֶךְ נָשִׁ֖ים לִ֑י וַיְחַפֵּ֕שׂ וְלֹ֥א מָצָ֖א אֶת־הַתְּרָפִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","וַיִּ֥חַר לְיַעֲקֹ֖ב וַיָּ֣רֶב בְּלָבָ֑ן וַיַּ֤עַן יַעֲקֹב֙ וַיֹּ֣אמֶר לְלָבָ֔ן מַה־פִּשְׁעִי֙ מַ֣ה חַטָּאתִ֔י כִּ֥י דָלַ֖קְתָּ אַחֲרָֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","כִּֽי־מִשַּׁ֣שְׁתָּ אֶת־כָּל־כֵּלַ֗י מַה־מָּצָ֙אתָ֙ מִכֹּ֣ל כְּלֵי־בֵיתֶ֔ךָ שִׂ֣ים כֹּ֔ה נֶ֥גֶד אַחַ֖י וְאַחֶ֑יךָ וְיֹוכִ֖יחוּ בֵּ֥ין שְׁנֵֽינוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","זֶה֩ עֶשְׂרִ֨ים שָׁנָ֤ה אָנֹכִי֙ עִמָּ֔ךְ רְחֵלֶ֥יךָ וְעִזֶּ֖יךָ לֹ֣א שִׁכֵּ֑לוּ וְאֵילֵ֥י צֹאנְךָ֖ לֹ֥א אָכָֽלְתִּי׃ ");
INSERT INTO hbo_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","טְרֵפָה֙ לֹא־הֵבֵ֣אתִי אֵלֶ֔יךָ אָנֹכִ֣י אֲחַטֶּ֔נָּה מִיָּדִ֖י תְּבַקְשֶׁ֑נָּה גְּנֻֽבְתִ֣י יֹ֔ום וּגְנֻֽבְתִ֖י לָֽיְלָה׃ ");
INSERT INTO hbo_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","הָיִ֧יתִי בַיֹּ֛ום אֲכָלַ֥נִי חֹ֖רֶב וְקֶ֣רַח בַּלָּ֑יְלָה וַתִּדַּ֥ד שְׁנָתִ֖י מֵֽעֵינָֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","זֶה־לִּ֞י עֶשְׂרִ֣ים שָׁנָה֮ בְּבֵיתֶךָ֒ עֲבַדְתִּ֜יךָ אַרְבַּֽע־עֶשְׂרֵ֤ה שָׁנָה֙ בִּשְׁתֵּ֣י בְנֹתֶ֔יךָ וְשֵׁ֥שׁ שָׁנִ֖ים בְּצֹאנֶ֑ךָ וַתַּחֲלֵ֥ף אֶת־מַשְׂכֻּרְתִּ֖י עֲשֶׂ֥רֶת מֹנִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","לוּלֵ֡י אֱלֹהֵ֣י אָבִי֩ אֱלֹהֵ֨י אַבְרָהָ֜ם וּפַ֤חַד יִצְחָק֙ הָ֣יָה לִ֔י כִּ֥י עַתָּ֖ה רֵיקָ֣ם שִׁלַּחְתָּ֑נִי אֶת־עָנְיִ֞י וְאֶת־יְגִ֧יעַ כַּפַּ֛י רָאָ֥ה אֱלֹהִ֖ים וַיֹּ֥וכַח אָֽמֶשׁ׃ ");
INSERT INTO hbo_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","וַיַּ֨עַן לָבָ֜ן וַיֹּ֣אמֶר אֶֽל־יַעֲקֹ֗ב הַבָּנֹ֨ות בְּנֹתַ֜י וְהַבָּנִ֤ים בָּנַי֙ וְהַצֹּ֣אן צֹאנִ֔י וְכֹ֛ל אֲשֶׁר־אַתָּ֥ה רֹאֶ֖ה לִי־ה֑וּא וְלִבְנֹתַ֞י מָֽה־אֽ͏ֶעֱשֶׂ֤ה לָאֵ֙לֶּה֙ הַיֹּ֔ום אֹ֥ו לִבְנֵיהֶ֖ן אֲשֶׁ֥ר יָלָֽדוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","וְעַתָּ֗ה לְכָ֛ה נִכְרְתָ֥ה בְרִ֖ית אֲנִ֣י וָאָ֑תָּה וְהָיָ֥ה לְעֵ֖ד בֵּינִ֥י וּבֵינֶֽךָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","וַיִּקַּ֥ח יַעֲקֹ֖ב אָ֑בֶן וַיְרִימֶ֖הָ מַצֵּבָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","וַיֹּ֨אמֶר יַעֲקֹ֤ב לְאֶחָיו֙ לִקְט֣וּ אֲבָנִ֔ים וַיִּקְח֥וּ אֲבָנִ֖ים וַיַּֽעֲשׂוּ־גָ֑ל וַיֹּ֥אכְלוּ שָׁ֖ם עַל־הַגָּֽל׃ ");
INSERT INTO hbo_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","וַיִּקְרָא־לֹ֣ו לָבָ֔ן יְגַ֖ר שָׂהֲדוּתָ֑א וְיַֽעֲקֹ֔ב קָ֥רָא לֹ֖ו גַּלְעֵֽד׃ ");
INSERT INTO hbo_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","וַיֹּ֣אמֶר לָבָ֔ן הַגַּ֨ל הַזֶּ֥ה עֵ֛ד בֵּינִ֥י וּבֵינְךָ֖ הַיֹּ֑ום עַל־כֵּ֥ן קָרָֽא־שְׁמֹ֖ו גַּלְעֵֽד׃ ");
INSERT INTO hbo_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","וְהַמִּצְפָּה֙ אֲשֶׁ֣ר אָמַ֔ר יִ֥צֶף יְהוָ֖ה בֵּינִ֣י וּבֵינֶ֑ךָ כִּ֥י נִסָּתֵ֖ר אִ֥ישׁ מֵרֵעֵֽהוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","אִם־תְּעַנֶּ֣ה אֶת־בְּנֹתַ֗י וְאִם־תִּקַּ֤ח נָשִׁים֙ עַל־בְּנֹתַ֔י אֵ֥ין אִ֖ישׁ עִמָּ֑נוּ רְאֵ֕ה אֱלֹהִ֥ים עֵ֖ד בֵּינִ֥י וּבֵינֶֽךָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","וַיֹּ֥אמֶר לָבָ֖ן לְיַעֲקֹ֑ב הִנֵּ֣ה ׀ הַגַּ֣ל הַזֶּ֗ה וְהִנֵּה֙ הַמַצֵּבָ֔ה אֲשֶׁ֥ר יָרִ֖יתִי בֵּינִ֥י וּבֵינֶֽךָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","עֵ֚ד הַגַּ֣ל הַזֶּ֔ה וְעֵדָ֖ה הַמַּצֵּבָ֑ה אִם־אָ֗נִי לֹֽא־אֽ͏ֶעֱבֹ֤ר אֵלֶ֙יךָ֙ אֶת־הַגַּ֣ל הַזֶּ֔ה וְאִם־אַ֠תָּה לֹא־תַעֲבֹ֨ר אֵלַ֜י אֶת־הַגַּ֥ל הַזֶּ֛ה וְאֶת־הַמַּצֵּבָ֥ה הַזֹּ֖את לְרָעָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","אֱלֹהֵ֨י אַבְרָהָ֜ם וֵֽאלֹהֵ֤י נָחֹור֙ יִשְׁפְּט֣וּ בֵינֵ֔ינוּ אֱלֹהֵ֖י אֲבִיהֶ֑ם וַיִּשָּׁבַ֣ע יַעֲקֹ֔ב בְּפַ֖חַד אָבִ֥יו יִצְחָֽק׃ ");
INSERT INTO hbo_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","וַיִּזְבַּ֨ח יַעֲקֹ֥ב זֶ֙בַח֙ בָּהָ֔ר וַיִּקְרָ֥א לְאֶחָ֖יו לֶאֱכָל־לָ֑חֶם וַיֹּ֣אכְלוּ לֶ֔חֶם וַיָּלִ֖ינוּ בָּהָֽר׃ ");
INSERT INTO hbo_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","וַיַּשְׁכֵּ֨ם לָבָ֜ן בַּבֹּ֗קֶר וַיְנַשֵּׁ֧ק לְבָנָ֛יו וְלִבְנֹותָ֖יו וַיְבָ֣רֶךְ אֶתְהֶ֑ם וַיֵּ֛לֶךְ וַיָּ֥שָׁב לָבָ֖ן לִמְקֹמֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","וְיַעֲקֹ֖ב הָלַ֣ךְ לְדַרְכֹּ֑ו וַיִּפְגְּעוּ־בֹ֖ו מַלְאֲכֵ֥י אֱלֹהִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","וַיֹּ֤אמֶר יַעֲקֹב֙ כַּאֲשֶׁ֣ר רָאָ֔ם מַחֲנֵ֥ה אֱלֹהִ֖ים זֶ֑ה וַיִּקְרָ֛א שֵֽׁם־הַמָּקֹ֥ום הַה֖וּא מֽ͏ַחֲנָֽיִם׃ פ ");
INSERT INTO hbo_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","וַיִּשְׁלַ֨ח יַעֲקֹ֤ב מַלְאָכִים֙ לְפָנָ֔יו אֶל־עֵשָׂ֖ו אָחִ֑יו אַ֥רְצָה שֵׂעִ֖יר שְׂדֵ֥ה אֱדֹֽום׃ ");
INSERT INTO hbo_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","וַיְצַ֤ו אֹתָם֙ לֵאמֹ֔ר כֹּ֣ה תֹאמְר֔וּן לַֽאדֹנִ֖י לְעֵשָׂ֑ו כֹּ֤ה אָמַר֙ עַבְדְּךָ֣ יַעֲקֹ֔ב עִם־לָבָ֣ן גַּ֔רְתִּי וָאֵחַ֖ר עַד־עָֽתָּה׃ ");
INSERT INTO hbo_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","וַֽיְהִי־לִי֙ שֹׁ֣ור וַחֲמֹ֔ור צֹ֖אן וְעֶ֣בֶד וְשִׁפְחָ֑ה וָֽאֶשְׁלְחָה֙ לְהַגִּ֣יד לֽ͏ַאדֹנִ֔י לִמְצֹא־חֵ֖ן בְּעֵינֶֽיךָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","וַיָּשֻׁ֙בוּ֙ הַמַּלְאָכִ֔ים אֶֽל־יַעֲקֹ֖ב לֵאמֹ֑ר בָּ֤אנוּ אֶל־אָחִ֙יךָ֙ אֶל־עֵשָׂ֔ו וְגַם֙ הֹלֵ֣ךְ לִקְרָֽאתְךָ֔ וְאַרְבַּע־מֵאֹ֥ות אִ֖ישׁ עִמֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","וַיִּירָ֧א יַעֲקֹ֛ב מְאֹ֖ד וַיֵּ֣צֶר לֹ֑ו וַיַּ֜חַץ אֶת־הָעָ֣ם אֲשֶׁר־אִתֹּ֗ו וְאֶת־הַצֹּ֧אן וְאֶת־הַבָּקָ֛ר וְהַגְּמַלִּ֖ים לִשְׁנֵ֥י מַחֲנֹֽות׃ ");
INSERT INTO hbo_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","וַיֹּ֕אמֶר אִם־יָבֹ֥וא עֵשָׂ֛ו אֶל־הַמַּחֲנֶ֥ה הָאַחַ֖ת וְהִכָּ֑הוּ וְהָיָ֛ה הַמַּחֲנֶ֥ה הַנִּשְׁאָ֖ר לִפְלֵיטָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","וַיֹּאמֶר֮ יַעֲקֹב֒ אֱלֹהֵי֙ אָבִ֣י אַבְרָהָ֔ם וֵאלֹהֵ֖י אָבִ֣י יִצְחָ֑ק יְהוָ֞ה הָאֹמֵ֣ר אֵלַ֗י שׁ֧וּב לְאַרְצְךָ֛ וּלְמֹולַדְתְּךָ֖ וְאֵיטִ֥יבָה עִמָּֽךְ׃ ");
INSERT INTO hbo_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","קָטֹ֜נְתִּי מִכֹּ֤ל הַחֲסָדִים֙ וּמִכָּל־הָ֣אֱמֶ֔ת אֲשֶׁ֥ר עָשִׂ֖יתָ אֶת־עַבְדֶּ֑ךָ כִּ֣י בְמַקְלִ֗י עָבַ֙רְתִּי֙ אֶת־הַיַּרְדֵּ֣ן הַזֶּ֔ה וְעַתָּ֥ה הָיִ֖יתִי לִשְׁנֵ֥י מַחֲנֹֽות׃ ");
INSERT INTO hbo_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","הַצִּילֵ֥נִי נָ֛א מִיַּ֥ד אָחִ֖י מִיַּ֣ד עֵשָׂ֑ו כִּֽי־יָרֵ֤א אָנֹכִי֙ אֹתֹ֔ו פֶּן־יָבֹ֣וא וְהִכַּ֔נִי אֵ֖ם עַל־בָּנִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","וְאַתָּ֣ה אָמַ֔רְתָּ הֵיטֵ֥ב אֵיטִ֖יב עִמָּ֑ךְ וְשַׂמְתִּ֤י אֶֽת־זַרְעֲךָ֙ כְּחֹ֣ול הַיָּ֔ם אֲשֶׁ֥ר לֹא־יִסָּפֵ֖ר מֵרֹֽב׃ ");
INSERT INTO hbo_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","וַיָּ֥לֶן שָׁ֖ם בַּלַּ֣יְלָה הַה֑וּא וַיִּקַּ֞ח מִן־הַבָּ֧א בְיָדֹ֛ו מִנְחָ֖ה לְעֵשָׂ֥ו אָחִֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","עִזִּ֣ים מָאתַ֔יִם וּתְיָשִׁ֖ים עֶשְׂרִ֑ים רְחֵלִ֥ים מָאתַ֖יִם וְאֵילִ֥ים עֶשְׂרִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","גְּמַלִּ֧ים מֵינִיקֹ֛ות וּבְנֵיהֶ֖ם שְׁלֹשִׁ֑ים פָּרֹ֤ות אַרְבָּעִים֙ וּפָרִ֣ים עֲשָׂרָ֔ה אֲתֹנֹ֣ת עֶשְׂרִ֔ים וַעְיָרִ֖ם עֲשָׂרָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","וַיִּתֵּן֙ בְּיַד־עֲבָדָ֔יו עֵ֥דֶר עֵ֖דֶר לְבַדֹּ֑ו וַ֤יֹּאמֶר אֶל־עֲבָדָיו֙ עִבְר֣וּ לְפָנַ֔י וְרֶ֣וַח תָּשִׂ֔ימוּ בֵּ֥ין עֵ֖דֶר וּבֵ֥ין עֵֽדֶר׃ ");
INSERT INTO hbo_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","וַיְצַ֥ו אֶת־הָרִאשֹׁ֖ון לֵאמֹ֑ר כִּ֣י יִֽפְגָּשְׁךָ֞ עֵשָׂ֣ו אָחִ֗י וִשְׁאֵֽלְךָ֙ לֵאמֹ֔ר לְמִי־אַ֙תָּה֙ וְאָ֣נָה תֵלֵ֔ךְ וּלְמִ֖י אֵ֥לֶּה לְפָנֶֽיךָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","וְאָֽמַרְתָּ֙ לְעַבְדְּךָ֣ לְיַעֲקֹ֔ב מִנְחָ֥ה הִוא֙ שְׁלוּחָ֔ה לֽ͏ַאדֹנִ֖י לְעֵשָׂ֑ו וְהִנֵּ֥ה גַם־ה֖וּא אַחֲרֵֽינוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","וַיְצַ֞ו גַּ֣ם אֶת־הַשֵּׁנִ֗י גַּ֚ם אֶת־הַשְּׁלִישִׁ֔י גַּ֚ם אֶת־כָּל־הַהֹ֣לְכִ֔ים אַחֲרֵ֥י הָעֲדָרִ֖ים לֵאמֹ֑ר כַּדָּבָ֤ר הַזֶּה֙ תְּדַבְּר֣וּן אֶל־עֵשָׂ֔ו בְּמֹצַאֲכֶ֖ם אֹתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","וַאֲמַרְתֶּ֕ם גַּ֗ם הִנֵּ֛ה עַבְדְּךָ֥ יַעֲקֹ֖ב אַחֲרֵ֑ינוּ כִּֽי־אָמַ֞ר אֲכַפְּרָ֣ה פָנָ֗יו בַּמִּנְחָה֙ הַהֹלֶ֣כֶת לְפָנָ֔י וְאַחֲרֵי־כֵן֙ אֶרְאֶ֣ה פָנָ֔יו אוּלַ֖י יִשָּׂ֥א פָנָֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","וַתַּעֲבֹ֥ר הַמִּנְחָ֖ה עַל־פָּנָ֑יו וְה֛וּא לָ֥ן בַּלַּֽיְלָה־הַה֖וּא בַּֽמַּחֲנֶֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","וַיָּ֣קָם ׀ בַּלַּ֣יְלָה ה֗וּא וַיִּקַּ֞ח אֶת־שְׁתֵּ֤י נָשָׁיו֙ וְאֶת־שְׁתֵּ֣י שִׁפְחֹתָ֔יו וְאֶת־אַחַ֥ד עָשָׂ֖ר יְלָדָ֑יו וַֽיַּעֲבֹ֔ר אֵ֖ת מַעֲבַ֥ר יַבֹּֽק׃ ");
INSERT INTO hbo_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","וַיִּקָּחֵ֔ם וַיַּֽעֲבִרֵ֖ם אֶת־הַנָּ֑חַל וַֽיַּעֲבֵ֖ר אֶת־אֲשֶׁר־לֹו׃ ");
INSERT INTO hbo_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","וַיִּוָּתֵ֥ר יַעֲקֹ֖ב לְבַדֹּ֑ו וַיֵּאָבֵ֥ק אִישׁ֙ עִמֹּ֔ו עַ֖ד עֲלֹ֥ות הַשָּֽׁחַר׃ ");
INSERT INTO hbo_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","וַיַּ֗רְא כִּ֣י לֹ֤א יָכֹל֙ לֹ֔ו וַיִּגַּ֖ע בְּכַף־יְרֵכֹ֑ו וַתֵּ֙קַע֙ כַּף־יֶ֣רֶךְ יַעֲקֹ֔ב בְּהֵֽאָבְקֹ֖ו עִמֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","וַיֹּ֣אמֶר שַׁלְּחֵ֔נִי כִּ֥י עָלָ֖ה הַשָּׁ֑חַר וַיֹּ֙אמֶר֙ לֹ֣א אֲשַֽׁלֵּחֲךָ֔ כִּ֖י אִם־בֵּרַכְתָּֽנִי׃ ");
INSERT INTO hbo_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","וַיֹּ֥אמֶר אֵלָ֖יו מַה־שְּׁמֶ֑ךָ וַיֹּ֖אמֶר יַעֲקֹֽב׃ ");
INSERT INTO hbo_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","וַיֹּ֗אמֶר לֹ֤א יַעֲקֹב֙ יֵאָמֵ֥ר עֹוד֙ שִׁמְךָ֔ כִּ֖י אִם־יִשְׂרָאֵ֑ל כִּֽי־שָׂרִ֧יתָ עִם־אֱלֹהִ֛ים וְעִם־אֲנָשִׁ֖ים וַתּוּכָֽל׃ ");
INSERT INTO hbo_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","וַיִּשְׁאַ֣ל יַעֲקֹ֗ב וַיֹּ֙אמֶר֙ הַגִּֽידָה־נָּ֣א שְׁמֶ֔ךָ וַיֹּ֕אמֶר לָ֥מָּה זֶּ֖ה תִּשְׁאַ֣ל לִשְׁמִ֑י וַיְבָ֥רֶךְ אֹתֹ֖ו שָֽׁם׃ ");
INSERT INTO hbo_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","וַיִּקְרָ֧א יַעֲקֹ֛ב שֵׁ֥ם הַמָּקֹ֖ום פְּנִיאֵ֑ל כִּֽי־רָאִ֤יתִי אֱלֹהִים֙ פָּנִ֣ים אֶל־פָּנִ֔ים וַתִּנָּצֵ֖ל נַפְשִֽׁי׃ ");
INSERT INTO hbo_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","וַיִּֽזְרַֽח־לֹ֣ו הַשֶּׁ֔מֶשׁ כַּאֲשֶׁ֥ר עָבַ֖ר אֶת־פְּנוּאֵ֑ל וְה֥וּא צֹלֵ֖עַ עַל־יְרֵכֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN32_33","002_32_33","GEN","32","33","33","עַל־כֵּ֡ן לֹֽא־יֹאכְל֨וּ בְנֵֽי־יִשְׂרָאֵ֜ל אֶת־גִּ֣יד הַנָּשֶׁ֗ה אֲשֶׁר֙ עַל־כַּ֣ף הַיָּרֵ֔ךְ עַ֖ד הַיֹּ֣ום הַזֶּ֑ה כִּ֤י נָגַע֙ בְּכַף־יֶ֣רֶךְ יַעֲקֹ֔ב בְּגִ֖יד הַנָּשֶֽׁה׃ ");
INSERT INTO hbo_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","וַיִּשָּׂ֨א יַעֲקֹ֜ב עֵינָ֗יו וַיַּרְא֙ וְהִנֵּ֣ה עֵשָׂ֣ו בָּ֔א וְעִמֹּ֕ו אַרְבַּ֥ע מֵאֹ֖ות אִ֑ישׁ וַיַּ֣חַץ אֶת־הַיְלָדִ֗ים עַל־לֵאָה֙ וְעַל־רָחֵ֔ל וְעַ֖ל שְׁתֵּ֥י הַשְּׁפָחֹֽות׃ ");
INSERT INTO hbo_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","וַיָּ֧שֶׂם אֶת־הַשְּׁפָחֹ֛ות וְאֶת־יַלְדֵיהֶ֖ן רִֽאשֹׁנָ֑ה וְאֶת־לֵאָ֤ה וִֽילָדֶ֙יהָ֙ אַחֲרֹנִ֔ים וְאֶת־רָחֵ֥ל וְאֶת־יֹוסֵ֖ף אַחֲרֹנִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","וְה֖וּא עָבַ֣ר לִפְנֵיהֶ֑ם וַיִּשְׁתַּ֤חוּ אַ֙רְצָה֙ שֶׁ֣בַע פְּעָמִ֔ים עַד־גִּשְׁתֹּ֖ו עַד־אָחִֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","וַיָּ֨רָץ עֵשָׂ֤ו לִקְרָאתֹו֙ וֽ͏ַיְחַבְּקֵ֔הוּ וַיִּפֹּ֥ל עַל־צַוָּארָ֖ו וַׄיִּׄשָּׁׄקֵ֑ׄהׄוּׄ וַיִּבְכּֽוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","וַיִּשָּׂ֣א אֶת־עֵינָ֗יו וַיַּ֤רְא אֶת־הַנָּשִׁים֙ וְאֶת־הַיְלָדִ֔ים וַיֹּ֖אמֶר מִי־אֵ֣לֶּה לָּ֑ךְ וַיֹּאמַ֕ר הַיְלָדִ֕ים אֲשֶׁר־חָנַ֥ן אֱלֹהִ֖ים אֶת־עַבְדֶּֽךָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","וַתִּגַּ֧שְׁןָ הַשְּׁפָחֹ֛ות הֵ֥נָּה וְיַלְדֵיהֶ֖ן וַתִּֽשְׁתַּחֲוֶֽיןָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","וַתִּגַּ֧שׁ גַּם־לֵאָ֛ה וִילָדֶ֖יהָ וַיִּֽשְׁתַּחֲו֑וּ וְאַחַ֗ר נִגַּ֥שׁ יֹוסֵ֛ף וְרָחֵ֖ל וַיִּֽשְׁתַּחֲוֽוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","וַיֹּ֕אמֶר מִ֥י לְךָ֛ כָּל־הַמַּחֲנֶ֥ה הַזֶּ֖ה אֲשֶׁ֣ר פָּגָ֑שְׁתִּי וַיֹּ֕אמֶר לִמְצֹא־חֵ֖ן בְּעֵינֵ֥י אֲדֹנִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","וַיֹּ֥אמֶר עֵשָׂ֖ו יֶשׁ־לִ֣י רָ֑ב אָחִ֕י יְהִ֥י לְךָ֖ אֲשֶׁר־לָֽךְ׃ ");
INSERT INTO hbo_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","וַיֹּ֣אמֶר יַעֲקֹ֗ב אַל־נָא֙ אִם־נָ֨א מָצָ֤אתִי חֵן֙ בְּעֵינֶ֔יךָ וְלָקַחְתָּ֥ מִנְחָתִ֖י מִיָּדִ֑י כִּ֣י עַל־כֵּ֞ן רָאִ֣יתִי פָנֶ֗יךָ כִּרְאֹ֛ת פְּנֵ֥י אֱלֹהִ֖ים וַתִּרְצֵֽנִי׃ ");
INSERT INTO hbo_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","קַח־נָ֤א אֶת־בִּרְכָתִי֙ אֲשֶׁ֣ר הֻבָ֣את לָ֔ךְ כִּֽי־חַנַּ֥נִי אֱלֹהִ֖ים וְכִ֣י יֶשׁ־לִי־כֹ֑ל וַיִּפְצַר־בֹּ֖ו וַיִּקָּֽח׃ ");
INSERT INTO hbo_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","וַיֹּ֖אמֶר נִסְעָ֣ה וְנֵלֵ֑כָה וְאֵלְכָ֖ה לְנֶגְדֶּֽךָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","וַיֹּ֣אמֶר אֵלָ֗יו אֲדֹנִ֤י יֹדֵ֙עַ֙ כִּֽי־הַיְלָדִ֣ים רַכִּ֔ים וְהַצֹּ֥אן וְהַבָּקָ֖ר עָלֹ֣ות עָלָ֑י וּדְפָקוּם֙ יֹ֣ום אֶחָ֔ד וָמֵ֖תוּ כָּל־הַצֹּֽאן׃ ");
INSERT INTO hbo_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","יַעֲבָר־נָ֥א אֲדֹנִ֖י לִפְנֵ֣י עַבְדֹּ֑ו וַאֲנִ֞י אֶֽתְנָהֲלָ֣ה לְאִטִּ֗י לְרֶ֨גֶל הַמְּלָאכָ֤ה אֲשֶׁר־לְפָנַי֙ וּלְרֶ֣גֶל הַיְלָדִ֔ים עַ֛ד אֲשֶׁר־אָבֹ֥א אֶל־אֲדֹנִ֖י שֵׂעִֽירָה׃ ");
INSERT INTO hbo_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","וַיֹּ֣אמֶר עֵשָׂ֔ו אַצִּֽיגָה־נָּ֣א עִמְּךָ֔ מִן־הָעָ֖ם אֲשֶׁ֣ר אִתִּ֑י וַיֹּ֙אמֶר֙ לָ֣מָּה זֶּ֔ה אֶמְצָא־חֵ֖ן בְּעֵינֵ֥י אֲדֹנִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","וַיָּשָׁב֩ בַּיֹּ֨ום הַה֥וּא עֵשָׂ֛ו לְדַרְכֹּ֖ו שֵׂעִֽירָה׃ ");
INSERT INTO hbo_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","וְיַעֲקֹב֙ נָסַ֣ע סֻכֹּ֔תָה וַיִּ֥בֶן לֹ֖ו בָּ֑יִת וּלְמִקְנֵ֙הוּ֙ עָשָׂ֣ה סֻכֹּ֔ת עַל־כֵּ֛ן קָרָ֥א שֵׁם־הַמָּקֹ֖ום סֻכֹּֽות׃ ס ");
INSERT INTO hbo_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","וַיָּבֹא֩ יַעֲקֹ֨ב שָׁלֵ֜ם עִ֣יר שְׁכֶ֗ם אֲשֶׁר֙ בְּאֶ֣רֶץ כְּנַ֔עַן בְּבֹאֹ֖ו מִפַּדַּ֣ן אֲרָ֑ם וַיִּ֖חַן אֶת־פְּנֵ֥י הָעִֽיר׃ ");
INSERT INTO hbo_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","וַיִּ֜קֶן אֶת־חֶלְקַ֣ת הַשָּׂדֶ֗ה אֲשֶׁ֤ר נָֽטָה־שָׁם֙ אָהֳלֹ֔ו מִיַּ֥ד בְּנֵֽי־חֲמֹ֖ור אֲבִ֣י שְׁכֶ֑ם בְּמֵאָ֖ה קְשִׂיטָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","וַיַּצֶּב־שָׁ֖ם מִזְבֵּ֑חַ וַיִּ֨קְרָא־לֹ֔ו אֵ֖ל אֱלֹהֵ֥י יִשְׂרָאֵֽל׃ ס ");
INSERT INTO hbo_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","וַתֵּצֵ֤א דִינָה֙ בַּת־לֵאָ֔ה אֲשֶׁ֥ר יָלְדָ֖ה לְיַעֲקֹ֑ב לִרְאֹ֖ות בִּבְנֹ֥ות הָאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","וַיַּ֨רְא אֹתָ֜הּ שְׁכֶ֧ם בֶּן־חֲמֹ֛ור הֽ͏ַחִוִּ֖י נְשִׂ֣יא הָאָ֑רֶץ וַיִּקַּ֥ח אֹתָ֛הּ וַיִּשְׁכַּ֥ב אֹתָ֖הּ וַיְעַנֶּֽהָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","וַתִּדְבַּ֣ק נַפְשֹׁ֔ו בְּדִינָ֖ה בַּֽת־יַעֲקֹ֑ב וַיֶּֽאֱהַב֙ אֶת־הַֽנַּעֲרָ֔ וַיְדַבֵּ֖ר עַל־לֵ֥ב הַֽנַּעֲרָֽ׃ ");
INSERT INTO hbo_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","וַיֹּ֣אמֶר שְׁכֶ֔ם אֶל־חֲמֹ֥ור אָבִ֖יו לֵאמֹ֑ר קַֽח־לִ֛י אֶת־הַיַּלְדָּ֥ה הַזֹּ֖את לְאִשָּֽׁה׃ ");
INSERT INTO hbo_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","וְיַעֲקֹ֣ב שָׁמַ֗ע כִּ֤י טִמֵּא֙ אֶת־דִּינָ֣ה בִתֹּ֔ו וּבָנָ֛יו הָי֥וּ אֶת־מִקְנֵ֖הוּ בַּשָּׂדֶ֑ה וְהֶחֱרִ֥שׁ יַעֲקֹ֖ב עַד־בֹּאָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","וַיֵּצֵ֛א חֲמֹ֥ור אֲבִֽי־שְׁכֶ֖ם אֶֽל־יַעֲקֹ֑ב לְדַבֵּ֖ר אִתֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","וּבְנֵ֨י יַעֲקֹ֜ב בָּ֤אוּ מִן־הַשָּׂדֶה֙ כְּשָׁמְעָ֔ם וַיִּֽתְעַצְּבוּ֙ הָֽאֲנָשִׁ֔ים וַיִּ֥חַר לָהֶ֖ם מְאֹ֑ד כִּֽי־נְבָלָ֞ה עָשָׂ֣ה בְיִשְׂרָאֵ֗ל לִשְׁכַּב֙ אֶת־בַּֽת־יַעֲקֹ֔ב וְכֵ֖ן לֹ֥א יֵעָשֶֽׂה׃ ");
INSERT INTO hbo_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","וַיְדַבֵּ֥ר חֲמֹ֖ור אִתָּ֣ם לֵאמֹ֑ר שְׁכֶ֣ם בְּנִ֗י חָֽשְׁקָ֤ה נַפְשֹׁו֙ בְּבִתְּכֶ֔ם תְּנ֨וּ נָ֥א אֹתָ֛הּ לֹ֖ו לְאִשָּֽׁה׃ ");
INSERT INTO hbo_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","וְהִֽתְחַתְּנ֖וּ אֹתָ֑נוּ בְּנֹֽתֵיכֶם֙ תִּתְּנוּ־לָ֔נוּ וְאֶת־בְּנֹתֵ֖ינוּ תִּקְח֥וּ לָכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","וְאִתָּ֖נוּ תֵּשֵׁ֑בוּ וְהָאָ֙רֶץ֙ תִּהְיֶ֣ה לִפְנֵיכֶ֔ם שְׁבוּ֙ וּסְחָר֔וּהָ וְהֵֽאָחֲז֖וּ בָּֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","וַיֹּ֤אמֶר שְׁכֶם֙ אֶל־אָבִ֣יה וְאֶל־אַחֶ֔יהָ אֶמְצָא־חֵ֖ן בְּעֵינֵיכֶ֑ם וַאֲשֶׁ֥ר תֹּאמְר֛וּ אֵלַ֖י אֶתֵּֽן׃ ");
INSERT INTO hbo_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","הַרְבּ֨וּ עָלַ֤י מְאֹד֙ מֹ֣הַר וּמַתָּ֔ן וְאֶ֨תְּנָ֔ה כַּאֲשֶׁ֥ר תֹּאמְר֖וּ אֵלָ֑י וּתְנוּ־לִ֥י אֶת־הַֽנַּעֲרָ֖ לְאִשָּֽׁה׃ ");
INSERT INTO hbo_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","וַיַּעֲנ֨וּ בְנֵֽי־יַעֲקֹ֜ב אֶת־שְׁכֶ֨ם וְאֶת־חֲמֹ֥ור אָבִ֛יו בְּמִרְמָ֖ה וַיְדַבֵּ֑רוּ אֲשֶׁ֣ר טִמֵּ֔א אֵ֖ת דִּינָ֥ה אֲחֹתָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","וַיֹּאמְר֣וּ אֲלֵיהֶ֗ם לֹ֤א נוּכַל֙ לַעֲשֹׂות֙ הַדָּבָ֣ר הַזֶּ֔ה לָתֵת֙ אֶת־אֲחֹתֵ֔נוּ לְאִ֖ישׁ אֲשֶׁר־לֹ֣ו עָרְלָ֑ה כִּֽי־חֶרְפָּ֥ה הִ֖וא לָֽנוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","אַךְ־בְּזֹ֖את נֵאֹ֣ות לָכֶ֑ם אִ֚ם תִּהְי֣וּ כָמֹ֔נוּ לְהִמֹּ֥ל לָכֶ֖ם כָּל־זָכָֽר׃ ");
INSERT INTO hbo_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","וְנָתַ֤נּוּ אֶת־בְּנֹתֵ֙ינוּ֙ לָכֶ֔ם וְאֶת־בְּנֹתֵיכֶ֖ם נִֽקַּֽח־לָ֑נוּ וְיָשַׁ֣בְנוּ אִתְּכֶ֔ם וְהָיִ֖ינוּ לְעַ֥ם אֶחָֽד׃ ");
INSERT INTO hbo_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","וְאִם־לֹ֧א תִשְׁמְע֛וּ אֵלֵ֖ינוּ לְהִמֹּ֑ול וְלָקַ֥חְנוּ אֶת־בִּתֵּ֖נוּ וְהָלָֽכְנוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","וַיִּֽיטְב֥וּ דִבְרֵיהֶ֖ם בְּעֵינֵ֣י חֲמֹ֑ור וּבְעֵינֵ֖י שְׁכֶ֥ם בֶּן־חֲמֹֽור׃ ");
INSERT INTO hbo_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","וְלֹֽא־אֵחַ֤ר הַנַּ֙עַר֙ לַעֲשֹׂ֣ות הַדָּבָ֔ר כִּ֥י חָפֵ֖ץ בְּבַֽת־יַעֲקֹ֑ב וְה֣וּא נִכְבָּ֔ד מִכֹּ֖ל בֵּ֥ית אָבִֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","וַיָּבֹ֥א חֲמֹ֛ור וּשְׁכֶ֥ם בְּנֹ֖ו אֶל־שַׁ֣עַר עִירָ֑ם וַֽיְדַבְּר֛וּ אֶל־אַנְשֵׁ֥י עִירָ֖ם לֵאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","הָאֲנָשִׁ֨ים הָאֵ֜לֶּה שְֽׁלֵמִ֧ים הֵ֣ם אִתָּ֗נוּ וְיֵשְׁב֤וּ בָאָ֙רֶץ֙ וְיִסְחֲר֣וּ אֹתָ֔הּ וְהָאָ֛רֶץ הִנֵּ֥ה רַֽחֲבַת־יָדַ֖יִם לִפְנֵיהֶ֑ם אֶת־בְּנֹתָם֙ נִקַּֽח־לָ֣נוּ לְנָשִׁ֔ים וְאֶת־בְּנֹתֵ֖ינוּ נִתֵּ֥ן לָהֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","אַךְ־בְּ֠זֹאת יֵאֹ֨תוּ לָ֤נוּ הָאֲנָשִׁים֙ לָשֶׁ֣בֶת אִתָּ֔נוּ לִהְיֹ֖ות לְעַ֣ם אֶחָ֑ד בְּהִמֹּ֥ול לָ֙נוּ֙ כָּל־זָכָ֔ר כַּאֲשֶׁ֖ר הֵ֥ם נִמֹּלִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","מִקְנֵהֶ֤ם וְקִנְיָנָם֙ וְכָל־בְּהֶמְתָּ֔ם הֲלֹ֥וא לָ֖נוּ הֵ֑ם אַ֚ךְ נֵאֹ֣ותָה לָהֶ֔ם וְיֵשְׁב֖וּ אִתָּֽנוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","וַיִּשְׁמְע֤וּ אֶל־חֲמֹור֙ וְאֶל־שְׁכֶ֣ם בְּנֹ֔ו כָּל־יֹצְאֵ֖י שַׁ֣עַר עִירֹ֑ו וַיִּמֹּ֙לוּ֙ כָּל־זָכָ֔ר כָּל־יֹצְאֵ֖י שַׁ֥עַר עִירֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","וַיְהִי֩ בַיֹּ֨ום הַשְּׁלִישִׁ֜י בִּֽהְיֹותָ֣ם כֹּֽאֲבִ֗ים וַיִּקְח֣וּ שְׁנֵֽי־בְנֵי־יַ֠עֲקֹב שִׁמְעֹ֨ון וְלֵוִ֜י אֲחֵ֤י דִינָה֙ אִ֣ישׁ חַרְבֹּ֔ו וַיָּבֹ֥אוּ עַל־הָעִ֖יר בֶּ֑טַח וַיַּֽהַרְג֖וּ כָּל־זָכָֽר׃ ");
INSERT INTO hbo_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","וְאֶת־חֲמֹור֙ וְאֶת־שְׁכֶ֣ם בְּנֹ֔ו הָרְג֖וּ לְפִי־חָ֑רֶב וַיִּקְח֧וּ אֶת־דִּינָ֛ה מִבֵּ֥ית שְׁכֶ֖ם וַיֵּצֵֽאוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","בְּנֵ֣י יַעֲקֹ֗ב בָּ֚אוּ עַל־הַ֣חֲלָלִ֔ים וַיָּבֹ֖זּוּ הָעִ֑יר אֲשֶׁ֥ר טִמְּא֖וּ אֲחֹותָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","אֶת־צֹאנָ֥ם וְאֶת־בְּקָרָ֖ם וְאֶת־חֲמֹרֵיהֶּ֑ם וְאֵ֧ת אֲשֶׁר־בָּעִ֛יר וְאֶת־אֲשֶׁ֥ר בַּשָּׂדֶ֖ה לָקָֽחוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","וְאֶת־כָּל־חֵילָ֤ם וְאֶת־כָּל־טַפָּם֙ וְאֶת־נְשֵׁיהֶ֔ם שָׁב֖וּ וַיָּבֹ֑זּוּ וְאֵ֖ת כָּל־אֲשֶׁ֥ר בַּבָּֽיִת׃ ");
INSERT INTO hbo_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","וַיֹּ֨אמֶר יַעֲקֹ֜ב אֶל־שִׁמְעֹ֣ון וְאֶל־לֵוִי֮ עֲכַרְתֶּ֣ם אֹתִי֒ לְהַבְאִישֵׁ֙נִי֙ בְּיֹשֵׁ֣ב הָאָ֔רֶץ בַּֽכְּנַעֲנִ֖י וּבַפְּרִזִּ֑י וַאֲנִי֙ מְתֵ֣י מִסְפָּ֔ר וְנֶאֶסְפ֤וּ עָלַי֙ וְהִכּ֔וּנִי וְנִשְׁמַדְתִּ֖י אֲנִ֥י וּבֵיתִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","וַיֹּאמְר֑וּ הַכְזֹונָ֕ה יַעֲשֶׂ֖ה אֶת־אֲחֹותֵֽנוּ׃ פ ");
INSERT INTO hbo_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","וַיֹּ֤אמֶר אֱלֹהִים֙ אֶֽל־יַעֲקֹ֔ב ק֛וּם עֲלֵ֥ה בֵֽית־אֵ֖ל וְשֶׁב־שָׁ֑ם וַעֲשֵׂה־שָׁ֣ם מִזְבֵּ֔חַ לָאֵל֙ הַנִּרְאֶ֣ה אֵלֶ֔יךָ בְּבָרְחֲךָ֔ מִפְּנֵ֖י עֵשָׂ֥ו אָחִֽיךָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","וַיֹּ֤אמֶר יַעֲקֹב֙ אֶל־בֵּיתֹ֔ו וְאֶ֖ל כָּל־אֲשֶׁ֣ר עִמֹּ֑ו הָסִ֜רוּ אֶת־אֱלֹהֵ֤י הַנֵּכָר֙ אֲשֶׁ֣ר בְּתֹכְכֶ֔ם וְהִֽטַּהֲר֔וּ וְהַחֲלִ֖יפוּ שִׂמְלֹתֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","וְנָק֥וּמָה וְנַעֲלֶ֖ה בֵּֽית־אֵ֑ל וְאֶֽעֱשֶׂה־שָּׁ֣ם מִזְבֵּ֗חַ לָאֵ֞ל הָעֹנֶ֤ה אֹתִי֙ בְּיֹ֣ום צָֽרָתִ֔י וַיְהִי֙ עִמָּדִ֔י בַּדֶּ֖רֶךְ אֲשֶׁ֥ר הָלָֽכְתִּי׃ ");
INSERT INTO hbo_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","וַיִּתְּנ֣וּ אֶֽל־יַעֲקֹ֗ב אֵ֣ת כָּל־אֱלֹהֵ֤י הַנֵּכָר֙ אֲשֶׁ֣ר בְּיָדָ֔ם וְאֶת־הַנְּזָמִ֖ים אֲשֶׁ֣ר בְּאָזְנֵיהֶ֑ם וַיִּטְמֹ֤ן אֹתָם֙ יַעֲקֹ֔ב תַּ֥חַת הָאֵלָ֖ה אֲשֶׁ֥ר עִם־שְׁכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","וַיִּסָּ֑עוּ וַיְהִ֣י ׀ חִתַּ֣ת אֱלֹהִ֗ים עַל־הֶֽעָרִים֙ אֲשֶׁר֙ סְבִיבֹ֣תֵיהֶ֔ם וְלֹ֣א רָֽדְפ֔וּ אַחֲרֵ֖י בְּנֵ֥י יַעֲקֹֽב׃ ");
INSERT INTO hbo_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","וַיָּבֹ֨א יַעֲקֹ֜ב ל֗וּזָה אֲשֶׁר֙ בְּאֶ֣רֶץ כְּנַ֔עַן הִ֖וא בֵּֽית־אֵ֑ל ה֖וּא וְכָל־הָעָ֥ם אֲשֶׁר־עִמֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","וַיִּ֤בֶן שָׁם֙ מִזְבֵּ֔חַ וַיִּקְרָא֙ לַמָּקֹ֔ום אֵ֖ל בֵּֽית־אֵ֑ל כִּ֣י שָׁ֗ם נִגְל֤וּ אֵלָיו֙ הָֽאֱלֹהִ֔ים בְּבָרְחֹ֖ו מִפְּנֵ֥י אָחִֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","וַתָּ֤מָת דְּבֹרָה֙ מֵינֶ֣קֶת רִבְקָ֔ה וַתִּקָּבֵ֛ר מִתַּ֥חַת לְבֵֽית־אֵ֖ל תַּ֣חַת הָֽאַלֹּ֑ון וַיִּקְרָ֥א שְׁמֹ֖ו אַלֹּ֥ון בָּכֽוּת׃ פ ");
INSERT INTO hbo_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","וַיֵּרָ֨א אֱלֹהִ֤ים אֶֽל־יַעֲקֹב֙ עֹ֔וד בְּבֹאֹ֖ו מִפַּדַּ֣ן אֲרָ֑ם וַיְבָ֖רֶךְ אֹתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","וַיֹּֽאמֶר־לֹ֥ו אֱלֹהִ֖ים שִׁמְךָ֣ יַעֲקֹ֑ב לֹֽא־יִקָּרֵא֩ שִׁמְךָ֨ עֹ֜וד יַעֲקֹ֗ב כִּ֤י אִם־יִשְׂרָאֵל֙ יִהְיֶ֣ה שְׁמֶ֔ךָ וַיִּקְרָ֥א אֶת־שְׁמֹ֖ו יִשְׂרָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","וַיֹּאמֶר֩ לֹ֨ו אֱלֹהִ֜ים אֲנִ֨י אֵ֤ל שַׁדַּי֙ פְּרֵ֣ה וּרְבֵ֔ה גֹּ֛וי וּקְהַ֥ל גֹּויִ֖ם יִהְיֶ֣ה מִמֶּ֑ךָּ וּמְלָכִ֖ים מֵחֲלָצֶ֥יךָ יֵצֵֽאוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","וְאֶת־הָאָ֗רֶץ אֲשֶׁ֥ר נָתַ֛תִּי לְאַבְרָהָ֥ם וּלְיִצְחָ֖ק לְךָ֣ אֶתְּנֶ֑נָּה וּֽלְזַרְעֲךָ֥ אַחֲרֶ֖יךָ אֶתֵּ֥ן אֶת־הָאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","וַיַּ֥עַל מֵעָלָ֖יו אֱלֹהִ֑ים בַּמָּקֹ֖ום אֲשֶׁר־דִּבֶּ֥ר אִתֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","וַיַּצֵּ֨ב יַעֲקֹ֜ב מַצֵּבָ֗ה בַּמָּקֹ֛ום אֲשֶׁר־דִּבֶּ֥ר אִתֹּ֖ו מַצֶּ֣בֶת אָ֑בֶן וַיַּסֵּ֤ךְ עָלֶ֙יהָ֙ נֶ֔סֶךְ וַיִּצֹ֥ק עָלֶ֖יהָ שָֽׁמֶן׃ ");
INSERT INTO hbo_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","וַיִּקְרָ֨א יַעֲקֹ֜ב אֶת־שֵׁ֣ם הַמָּקֹ֗ום אֲשֶׁר֩ דִּבֶּ֨ר אִתֹּ֥ו שָׁ֛ם אֱלֹהִ֖ים בֵּֽית־אֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","וַיִּסְעוּ֙ מִבֵּ֣ית אֵ֔ל וַֽיְהִי־עֹ֥וד כִּבְרַת־הָאָ֖רֶץ לָבֹ֣וא אֶפְרָ֑תָה וַתֵּ֥לֶד רָחֵ֖ל וַתְּקַ֥שׁ בְּלִדְתָּֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","וַיְהִ֥י בְהַקְשֹׁתָ֖הּ בְּלִדְתָּ֑הּ וַתֹּ֨אמֶר לָ֤הּ הַמְיַלֶּ֙דֶת֙ אַל־תִּ֣ירְאִ֔י כִּֽי־גַם־זֶ֥ה לָ֖ךְ בֵּֽן׃ ");
INSERT INTO hbo_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","וַיְהִ֞י בְּצֵ֤את נַפְשָׁהּ֙ כִּ֣י מֵ֔תָה וַתִּקְרָ֥א שְׁמֹ֖ו בֶּן־אֹונִ֑י וְאָבִ֖יו קָֽרָא־לֹ֥ו בִנְיָמִֽין׃ ");
INSERT INTO hbo_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","וַתָּ֖מָת רָחֵ֑ל וַתִּקָּבֵר֙ בְּדֶ֣רֶךְ אֶפְרָ֔תָה הִ֖וא בֵּ֥ית לָֽחֶם׃ ");
INSERT INTO hbo_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","וַיַּצֵּ֧ב יַעֲקֹ֛ב מַצֵּבָ֖ה עַל־קְבֻרָתָ֑הּ הִ֛וא מַצֶּ֥בֶת קְבֻרַֽת־רָחֵ֖ל עַד־הַיֹּֽום׃ ");
INSERT INTO hbo_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","וַיִּסַּ֖ע יִשְׂרָאֵ֑ל וַיֵּ֣ט אָֽהֳלֹ֔ה מֵהָ֖לְאָה לְמִגְדַּל־עֵֽדֶר׃ ");
INSERT INTO hbo_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","וַיְהִ֗י בִּשְׁכֹּ֤ן יִשְׂרָאֵל֙ בָּאָ֣רֶץ הַהִ֔וא וַיֵּ֣לֶךְ רְאוּבֵ֔ן וַיִּשְׁכַּ֕ב֙ אֶת־בִּלְהָ֖ה֙ פִּילֶ֣גֶשׁ אָבִ֑֔יו וַיִּשְׁמַ֖ע יִשְׂרָאֵֽ֑ל פ וַיִּֽהְי֥וּ בְנֵֽי־יַעֲקֹ֖ב שְׁנֵ֥ים עָשָֽׂר׃ ");
INSERT INTO hbo_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","בְּנֵ֣י לֵאָ֔ה בְּכֹ֥ור יַעֲקֹ֖ב רְאוּבֵ֑ן וְשִׁמְעֹון֙ וְלֵוִ֣י וִֽיהוּדָ֔ה וְיִשָּׂשכָ֖ר וּזְבוּלֻֽן׃ ");
INSERT INTO hbo_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","בְּנֵ֣י רָחֵ֔ל יֹוסֵ֖ף וּבִנְיָמִֽן׃ ");
INSERT INTO hbo_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","וּבְנֵ֤י בִלְהָה֙ שִׁפְחַ֣ת רָחֵ֔ל דָּ֖ן וְנַפְתָּלִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","וּבְנֵ֥י זִלְפָּ֛ה שִׁפְחַ֥ת לֵאָ֖ה גָּ֣ד וְאָשֵׁ֑ר אֵ֚לֶּה בְּנֵ֣י יַעֲקֹ֔ב אֲשֶׁ֥ר יֻלַּד־לֹ֖ו בְּפַדַּ֥ן אֲרָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","וַיָּבֹ֤א יַעֲקֹב֙ אֶל־יִצְחָ֣ק אָבִ֔יו מַמְרֵ֖א קִרְיַ֣ת הָֽאַרְבַּ֑ע הִ֣וא חֶבְרֹ֔ון אֲשֶׁר־גָּֽר־שָׁ֥ם אַבְרָהָ֖ם וְיִצְחָֽק׃ ");
INSERT INTO hbo_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","וַיִּֽהְי֖וּ יְמֵ֣י יִצְחָ֑ק מְאַ֥ת שָׁנָ֖ה וּשְׁמֹנִ֥ים שָׁנָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","וַיִּגְוַ֨ע יִצְחָ֤ק וַיָּ֙מָת֙ וַיֵּאָ֣סֶף אֶל־עַמָּ֔יו זָקֵ֖ן וּשְׂבַ֣ע יָמִ֑ים וַיִּקְבְּר֣וּ אֹתֹ֔ו עֵשָׂ֥ו וְיַעֲקֹ֖ב בָּנָֽיו׃ פ ");
INSERT INTO hbo_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","וְאֵ֛לֶּה תֹּלְדֹ֥ות עֵשָׂ֖ו ה֥וּא אֱדֹֽום׃ ");
INSERT INTO hbo_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","עֵשָׂ֛ו לָקַ֥ח אֶת־נָשָׁ֖יו מִבְּנֹ֣ות כְּנָ֑עַן אֶת־עָדָ֗ה בַּת־אֵילֹון֙ הַֽחִתִּ֔י וְאֶת־אָהֳלִֽיבָמָה֙ בַּת־עֲנָ֔ה בַּת־צִבְעֹ֖ון הֽ͏ַחִוִּֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","וְאֶת־בָּשְׂמַ֥ת בַּת־יִשְׁמָעֵ֖אל אֲחֹ֥ות נְבָיֹֽות׃ ");
INSERT INTO hbo_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","וַתֵּ֧לֶד עָדָ֛ה לְעֵשָׂ֖ו אֶת־אֱלִיפָ֑ז וּבָ֣שְׂמַ֔ת יָלְדָ֖ה אֶת־רְעוּאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","וְאָהֳלִֽיבָמָה֙ יָֽלְדָ֔ה אֶת־*יעישׁ (יְע֥וּשׁ) וְאֶת־יַעְלָ֖ם וְאֶת־קֹ֑רַח אֵ֚לֶּה בְּנֵ֣י עֵשָׂ֔ו אֲשֶׁ֥ר יֻלְּדוּ־לֹ֖ו בְּאֶ֥רֶץ כְּנָֽעַן׃ ");
INSERT INTO hbo_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","וַיִּקַּ֣ח עֵשָׂ֡ו אֶת־נָ֠שָׁיו וְאֶת־בָּנָ֣יו וְאֶת־בְּנֹתָיו֮ וְאֶת־כָּל־נַפְשֹׁ֣ות בֵּיתֹו֒ וְאֶת־מִקְנֵ֣הוּ וְאֶת־כָּל־בְּהֶמְתֹּ֗ו וְאֵת֙ כָּל־קִנְיָנֹ֔ו אֲשֶׁ֥ר רָכַ֖שׁ בְּאֶ֣רֶץ כְּנָ֑עַן וַיֵּ֣לֶךְ אֶל־אֶ֔רֶץ מִפְּנֵ֖י יַעֲקֹ֥ב אָחִֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","כִּֽי־הָיָ֧ה רְכוּשָׁ֛ם רָ֖ב מִשֶּׁ֣בֶת יַחְדָּ֑ו וְלֹ֨א יֽ͏ָכְלָ֜ה אֶ֤רֶץ מְגֽוּרֵיהֶם֙ לָשֵׂ֣את אֹתָ֔ם מִפְּנֵ֖י מִקְנֵיהֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","וַיֵּ֤שֶׁב עֵשָׂו֙ בְּהַ֣ר שֵׂעִ֔יר עֵשָׂ֖ו ה֥וּא אֱדֹֽום׃ ");
INSERT INTO hbo_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","וְאֵ֛לֶּה תֹּלְדֹ֥ות עֵשָׂ֖ו אֲבִ֣י אֱדֹ֑ום בְּהַ֖ר שֵׂעִֽיר׃ ");
INSERT INTO hbo_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","אֵ֖לֶּה שְׁמֹ֣ות בְּנֵֽי־עֵשָׂ֑ו אֱלִיפַ֗ז בֶּן־עָדָה֙ אֵ֣שֶׁת עֵשָׂ֔ו רְעוּאֵ֕ל בֶּן־בָּשְׂמַ֖ת אֵ֥שֶׁת עֵשָֽׂו׃ ");
INSERT INTO hbo_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","וַיִּהְי֖וּ בְּנֵ֣י אֱלִיפָ֑ז תֵּימָ֣ן אֹומָ֔ר צְפֹ֥ו וְגַעְתָּ֖ם וּקְנַֽז׃ ");
INSERT INTO hbo_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","וְתִמְנַ֣ע ׀ הָיְתָ֣ה פִילֶ֗גֶשׁ לֶֽאֱלִיפַז֙ בֶּן־עֵשָׂ֔ו וַתֵּ֥לֶד לֶאֱלִיפַ֖ז אֶת־עֲמָלֵ֑ק אֵ֕לֶּה בְּנֵ֥י עָדָ֖ה אֵ֥שֶׁת עֵשָֽׂו׃ ");
INSERT INTO hbo_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","וְאֵ֙לֶּה֙ בְּנֵ֣י רְעוּאֵ֔ל נַ֥חַת וָזֶ֖רַח שַׁמָּ֣ה וּמִזָּ֑ה אֵ֣לֶּ֣ה הָי֔וּ בְּנֵ֥י בָשְׂמַ֖ת אֵ֥שֶׁת עֵשָֽׂו׃ ");
INSERT INTO hbo_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","וְאֵ֣לֶּה הָי֗וּ בְּנֵ֨י אָהֳלִיבָמָ֧ה בַת־עֲנָ֛ה בַּת־צִבְעֹ֖ון אֵ֣שֶׁת עֵשָׂ֑ו וַתֵּ֣לֶד לְעֵשָׂ֔ו אֶת־*יעישׁ (יְע֥וּשׁ) וְאֶת־יַעְלָ֖ם וְאֶת־קֹֽרַח׃ ");
INSERT INTO hbo_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","אֵ֖לֶּה אַלּוּפֵ֣י בְנֵֽי־עֵשָׂ֑ו בְּנֵ֤י אֱלִיפַז֙ בְּכֹ֣ור עֵשָׂ֔ו אַלּ֤וּף תֵּימָן֙ אַלּ֣וּף אֹומָ֔ר אַלּ֥וּף צְפֹ֖ו אַלּ֥וּף קְנַֽז׃ ");
INSERT INTO hbo_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","אַלּֽוּף־קֹ֛רַח אַלּ֥וּף גַּעְתָּ֖ם אַלּ֣וּף עֲמָלֵ֑ק אֵ֣לֶּה אַלּוּפֵ֤י אֱלִיפַז֙ בְּאֶ֣רֶץ אֱדֹ֔ום אֵ֖לֶּה בְּנֵ֥י עָדָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","וְאֵ֗לֶּה בְּנֵ֤י רְעוּאֵל֙ בֶּן־עֵשָׂ֔ו אַלּ֥וּף נַ֙חַת֙ אַלּ֣וּף זֶ֔רַח אַלּ֥וּף שַׁמָּ֖ה אַלּ֣וּף מִזָּ֑ה אֵ֣לֶּה אַלּוּפֵ֤י רְעוּאֵל֙ בְּאֶ֣רֶץ אֱדֹ֔ום אֵ֕לֶּה בְּנֵ֥י בָשְׂמַ֖ת אֵ֥שֶׁת עֵשָֽׂו׃ ");
INSERT INTO hbo_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","וְאֵ֗לֶּה בְּנֵ֤י אָהֳלִֽיבָמָה֙ אֵ֣שֶׁת עֵשָׂ֔ו אַלּ֥וּף יְע֛וּשׁ אַלּ֥וּף יַעְלָ֖ם אַלּ֣וּף קֹ֑רַח אֵ֣לֶּה אַלּוּפֵ֞י אָֽהֳלִיבָמָ֛ה בַּת־עֲנָ֖ה אֵ֥שֶׁת עֵשָֽׂו׃ ");
INSERT INTO hbo_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","אֵ֧לֶּה בְנֵי־עֵשָׂ֛ו וְאֵ֥לֶּה אַלּוּפֵיהֶ֖ם ה֥וּא אֱדֹֽום׃ ס ");
INSERT INTO hbo_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","אֵ֤לֶּה בְנֵֽי־שֵׂעִיר֙ הַחֹרִ֔י יֹשְׁבֵ֖י הָאָ֑רֶץ לֹוטָ֥ן וְשֹׁובָ֖ל וְצִבְעֹ֥ון וַעֲנָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","וְדִשֹׁ֥ון וְאֵ֖צֶר וְדִישָׁ֑ן אֵ֣לֶּה אַלּוּפֵ֧י הַחֹרִ֛י בְּנֵ֥י שֵׂעִ֖יר בְּאֶ֥רֶץ אֱדֹֽום׃ ");
INSERT INTO hbo_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","וַיִּהְי֥וּ בְנֵי־לֹוטָ֖ן חֹרִ֣י וְהֵימָ֑ם וַאֲחֹ֥ות לֹוטָ֖ן תִּמְנָֽע׃ ");
INSERT INTO hbo_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","וְאֵ֙לֶּה֙ בְּנֵ֣י שֹׁובָ֔ל עַלְוָ֥ן וּמָנַ֖חַת וְעֵיבָ֑ל שְׁפֹ֖ו וְאֹונָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","וְאֵ֥לֶּה בְנֵֽי־צִבְעֹ֖ון וְאַיָּ֣ה וַעֲנָ֑ה ה֣וּא עֲנָ֗ה אֲשֶׁ֨ר מָצָ֤א אֶת־הַיֵּמִם֙ בַּמִּדְבָּ֔ר בִּרְעֹתֹ֥ו אֶת־הַחֲמֹרִ֖ים לְצִבְעֹ֥ון אָבִֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","וְאֵ֥לֶּה בְנֵֽי־עֲנָ֖ה דִּשֹׁ֑ן וְאָהֳלִיבָמָ֖ה בַּת־עֲנָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","וְאֵ֖לֶּה בְּנֵ֣י דִישָׁ֑ן חֶמְדָּ֥ן וְאֶשְׁבָּ֖ן וְיִתְרָ֥ן וּכְרָֽן׃ ");
INSERT INTO hbo_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","אֵ֖לֶּה בְּנֵי־אֵ֑צֶר בִּלְהָ֥ן וְזַעֲוָ֖ן וַעֲקָֽן׃ ");
INSERT INTO hbo_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","אֵ֥לֶּה בְנֵֽי־דִישָׁ֖ן ע֥וּץ וַאֲרָֽן׃ ");
INSERT INTO hbo_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","אֵ֖לֶּה אַלּוּפֵ֣י הַחֹרִ֑י אַלּ֤וּף לֹוטָן֙ אַלּ֣וּף שֹׁובָ֔ל אַלּ֥וּף צִבְעֹ֖ון אַלּ֥וּף עֲנָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","אַלּ֥וּף דִּשֹׁ֛ן אַלּ֥וּף אֵ֖צֶר אַלּ֣וּף דִּישָׁ֑ן אֵ֣לֶּה אַלּוּפֵ֧י הַחֹרִ֛י לְאַלֻּפֵיהֶ֖ם בְּאֶ֥רֶץ שֵׂעִֽיר׃ פ ");
INSERT INTO hbo_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","וְאֵ֙לֶּה֙ הַמְּלָכִ֔ים אֲשֶׁ֥ר מָלְכ֖וּ בְּאֶ֣רֶץ אֱדֹ֑ום לִפְנֵ֥י מְלָךְ־מֶ֖לֶךְ לִבְנֵ֥י יִשְׂרָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","וַיִּמְלֹ֣ךְ בֶּאֱדֹ֔ום בֶּ֖לַע בֶּן־בְּעֹ֑ור וְשֵׁ֥ם עִירֹ֖ו דִּנְהָֽבָה׃ ");
INSERT INTO hbo_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","וַיָּ֖מָת בָּ֑לַע וַיִּמְלֹ֣ךְ תַּחְתָּ֔יו יֹובָ֥ב בֶּן־זֶ֖רַח מִבָּצְרָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","וַיָּ֖מָת יֹובָ֑ב וַיִּמְלֹ֣ךְ תַּחְתָּ֔יו חֻשָׁ֖ם מֵאֶ֥רֶץ הַתֵּימָנִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","וַיָּ֖מָת חֻשָׁ֑ם וַיִּמְלֹ֨ךְ תַּחְתָּ֜יו הֲדַ֣ד בֶּן־בְּדַ֗ד הַמַּכֶּ֤ה אֶת־מִדְיָן֙ בִּשְׂדֵ֣ה מֹואָ֔ב וְשֵׁ֥ם עִירֹ֖ו עֲוִֽית׃ ");
INSERT INTO hbo_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","וַיָּ֖מָת הֲדָ֑ד וַיִּמְלֹ֣ךְ תַּחְתָּ֔יו שַׂמְלָ֖ה מִמַּשְׂרֵקָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","וַיָּ֖מָת שַׂמְלָ֑ה וַיִּמְלֹ֣ךְ תַּחְתָּ֔יו שָׁא֖וּל מֵרְחֹבֹ֥ות הַנָּהָֽר׃ ");
INSERT INTO hbo_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","וַיָּ֖מָת שָׁא֑וּל וַיִּמְלֹ֣ךְ תַּחְתָּ֔יו בַּ֥עַל חָנָ֖ן בֶּן־עַכְבֹּֽור׃ ");
INSERT INTO hbo_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","וַיָּמָת֮ בַּ֣עַל חָנָ֣ן בֶּן־עַכְבֹּור֒ וַיִּמְלֹ֤ךְ תַּחְתָּיו֙ הֲדַ֔ר וְשֵׁ֥ם עִירֹ֖ו פָּ֑עוּ וְשֵׁ֨ם אִשְׁתֹּ֤ו מְהֵֽיטַבְאֵל֙ בַּת־מַטְרֵ֔ד בַּ֖ת מֵ֥י זָהָֽב׃ ");
INSERT INTO hbo_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","וְ֠אֵלֶּה שְׁמֹ֞ות אַלּוּפֵ֤י עֵשָׂו֙ לְמִשְׁפְּחֹתָ֔ם לִמְקֹמֹתָ֖ם בִּשְׁמֹתָ֑ם אַלּ֥וּף תִּמְנָ֛ע אַלּ֥וּף עַֽלְוָ֖ה אַלּ֥וּף יְתֵֽת׃ ");
INSERT INTO hbo_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","אַלּ֧וּף אָהֳלִיבָמָ֛ה אַלּ֥וּף אֵלָ֖ה אַלּ֥וּף פִּינֹֽן׃ ");
INSERT INTO hbo_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","אַלּ֥וּף קְנַ֛ז אַלּ֥וּף תֵּימָ֖ן אַלּ֥וּף מִבְצָֽר׃ ");
INSERT INTO hbo_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","אַלּ֥וּף מַגְדִּיאֵ֖ל אַלּ֣וּף עִירָ֑ם אֵ֣לֶּה ׀ אַלּוּפֵ֣י אֱדֹ֗ום לְמֹֽשְׁבֹתָם֙ בְּאֶ֣רֶץ אֲחֻזָּתָ֔ם ה֥וּא עֵשָׂ֖ו אֲבִ֥י אֱדֹֽום׃ פ ");
INSERT INTO hbo_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","וַיֵּ֣שֶׁב יַעֲקֹ֔ב בְּאֶ֖רֶץ מְגוּרֵ֣י אָבִ֑יו בְּאֶ֖רֶץ כְּנָֽעַן׃ ");
INSERT INTO hbo_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","אֵ֣לֶּה ׀ תֹּלְדֹ֣ות יַעֲקֹ֗ב יֹוסֵ֞ף בֶּן־שְׁבַֽע־עֶשְׂרֵ֤ה שָׁנָה֙ הָיָ֨ה רֹעֶ֤ה אֶת־אֶחָיו֙ בַּצֹּ֔אן וְה֣וּא נַ֗עַר אֶת־בְּנֵ֥י בִלְהָ֛ה וְאֶת־בְּנֵ֥י זִלְפָּ֖ה נְשֵׁ֣י אָבִ֑יו וַיָּבֵ֥א יֹוסֵ֛ף אֶת־דִּבָּתָ֥ם רָעָ֖ה אֶל־אֲבִיהֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","וְיִשְׂרָאֵ֗ל אָהַ֤ב אֶת־יֹוסֵף֙ מִכָּל־בָּנָ֔יו כִּֽי־בֶן־זְקֻנִ֥ים ה֖וּא לֹ֑ו וְעָ֥שָׂה לֹ֖ו כְּתֹ֥נֶת פַּסִּֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","וַיִּרְא֣וּ אֶחָ֗יו כִּֽי־אֹתֹ֞ו אָהַ֤ב אֲבִיהֶם֙ מִכָּל־אֶחָ֔יו וַֽיִּשְׂנְא֖וּ אֹתֹ֑ו וְלֹ֥א יָכְל֖וּ דַּבְּרֹ֥ו לְשָׁלֹֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","וַיַּחֲלֹ֤ם יֹוסֵף֙ חֲלֹ֔ום וַיַּגֵּ֖ד לְאֶחָ֑יו וַיֹּוסִ֥פוּ עֹ֖וד שְׂנֹ֥א אֹתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","וַיֹּ֖אמֶר אֲלֵיהֶ֑ם שִׁמְעוּ־נָ֕א הַחֲלֹ֥ום הַזֶּ֖ה אֲשֶׁ֥ר חָלָֽמְתִּי׃ ");
INSERT INTO hbo_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","וְ֠הִנֵּה אֲנַ֜חְנוּ מְאַלְּמִ֤ים אֲלֻמִּים֙ בְּתֹ֣וךְ הַשָּׂדֶ֔ה וְהִנֵּ֛ה קָ֥מָה אֲלֻמָּתִ֖י וְגַם־נִצָּ֑בָה וְהִנֵּ֤ה תְסֻבֶּ֙ינָה֙ אֲלֻמֹּ֣תֵיכֶ֔ם וַתִּֽשְׁתַּחֲוֶ֖יןָ לַאֲלֻמָּתִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","וַיֹּ֤אמְרוּ לֹו֙ אֶחָ֔יו הֲמָלֹ֤ךְ תִּמְלֹךְ֙ עָלֵ֔ינוּ אִם־מָשֹׁ֥ול תִּמְשֹׁ֖ל בָּ֑נוּ וַיֹּוסִ֤פוּ עֹוד֙ שְׂנֹ֣א אֹתֹ֔ו עַל־חֲלֹמֹתָ֖יו וְעַל־דְּבָרָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","וַיַּחֲלֹ֥ם עֹוד֙ חֲלֹ֣ום אַחֵ֔ר וַיְסַפֵּ֥ר אֹתֹ֖ו לְאֶחָ֑יו וַיֹּ֗אמֶר הִנֵּ֨ה חָלַ֤מְתִּֽי חֲלֹום֙ עֹ֔וד וְהִנֵּ֧ה הַשֶּׁ֣מֶשׁ וְהַיָּרֵ֗חַ וְאַחַ֤ד עָשָׂר֙ כֹּֽוכָבִ֔ים מִֽשְׁתַּחֲוִ֖ים לִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","וַיְסַפֵּ֣ר אֶל־אָבִיו֮ וְאֶל־אֶחָיו֒ וַיִּגְעַר־בֹּ֣ו אָבִ֔יו וַיֹּ֣אמֶר לֹ֔ו מָ֛ה הַחֲלֹ֥ום הַזֶּ֖ה אֲשֶׁ֣ר חָלָ֑מְתָּ הֲבֹ֣וא נָבֹ֗וא אֲנִי֙ וְאִמְּךָ֣ וְאַחֶ֔יךָ לְהִשְׁתַּחֲוֹ֥ת לְךָ֖ אָֽרְצָה׃ ");
INSERT INTO hbo_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","וַיְקַנְאוּ־בֹ֖ו אֶחָ֑יו וְאָבִ֖יו שָׁמַ֥ר אֶת־הַדָּבָֽר׃ ");
INSERT INTO hbo_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","וַיֵּלְכ֖וּ אֶחָ֑יו לִרְעֹ֛ות אֶׄתׄ־צֹ֥אן אֲבִיהֶ֖ם בִּשְׁכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","וַיֹּ֨אמֶר יִשְׂרָאֵ֜ל אֶל־יֹוסֵ֗ף הֲלֹ֤וא אַחֶ֙יךָ֙ רֹעִ֣ים בִּשְׁכֶ֔ם לְכָ֖ה וְאֶשְׁלָחֲךָ֣ אֲלֵיהֶ֑ם וַיֹּ֥אמֶר לֹ֖ו הִנֵּֽנִי׃ ");
INSERT INTO hbo_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","וַיֹּ֣אמֶר לֹ֗ו לֶךְ־נָ֨א רְאֵ֜ה אֶת־שְׁלֹ֤ום אַחֶ֙יךָ֙ וְאֶת־שְׁלֹ֣ום הַצֹּ֔אן וַהֲשִׁבֵ֖נִי דָּבָ֑ר וַיִּשְׁלָחֵ֙הוּ֙ מֵעֵ֣מֶק חֶבְרֹ֔ון וַיָּבֹ֖א שְׁכֶֽמָה׃ ");
INSERT INTO hbo_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","וַיִּמְצָאֵ֣הוּ אִ֔ישׁ וְהִנֵּ֥ה תֹעֶ֖ה בַּשָּׂדֶ֑ה וַיִּשְׁאָלֵ֧הוּ הָאִ֛ישׁ לֵאמֹ֖ר מַה־תְּבַקֵּֽשׁ׃ ");
INSERT INTO hbo_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","וַיֹּ֕אמֶר אֶת־אַחַ֖י אָנֹכִ֣י מְבַקֵּ֑שׁ הַגִּֽידָה־נָּ֣א לִ֔י אֵיפֹ֖ה הֵ֥ם רֹעִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","וַיֹּ֤אמֶר הָאִישׁ֙ נָסְע֣וּ מִזֶּ֔ה כִּ֤י שָׁמַ֙עְתִּי֙ אֹֽמְרִ֔ים נֵלְכָ֖ה דֹּתָ֑יְנָה וַיֵּ֤לֶךְ יֹוסֵף֙ אַחַ֣ר אֶחָ֔יו וַיִּמְצָאֵ֖ם בְּדֹתָֽן׃ ");
INSERT INTO hbo_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","וַיִּרְא֥וּ אֹתֹ֖ו מֵרָחֹ֑ק וּבְטֶ֙רֶם֙ יִקְרַ֣ב אֲלֵיהֶ֔ם וַיִּֽתְנַכְּל֥וּ אֹתֹ֖ו לַהֲמִיתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","וַיֹּאמְר֖וּ אִ֣ישׁ אֶל־אָחִ֑יו הִנֵּ֗ה בַּ֛עַל הַחֲלֹמֹ֥ות הַלָּזֶ֖ה בָּֽא׃ ");
INSERT INTO hbo_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","וְעַתָּ֣ה ׀ לְכ֣וּ וְנַֽהַרְגֵ֗הוּ וְנַשְׁלִכֵ֙הוּ֙ בְּאַחַ֣ד הַבֹּרֹ֔ות וְאָמַ֕רְנוּ חַיָּ֥ה רָעָ֖ה אֲכָלָ֑תְהוּ וְנִרְאֶ֕ה מַה־יִּהְי֖וּ חֲלֹמֹתָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","וַיִּשְׁמַ֣ע רְאוּבֵ֔ן וַיַּצִּלֵ֖הוּ מִיָּדָ֑ם וַיֹּ֕אמֶר לֹ֥א נַכֶּ֖נּוּ נָֽפֶשׁ׃ ");
INSERT INTO hbo_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","וַיֹּ֨אמֶר אֲלֵהֶ֣ם ׀ רְאוּבֵן֮ אַל־תִּשְׁפְּכוּ־דָם֒ הַשְׁלִ֣יכוּ אֹתֹ֗ו אֶל־הַבֹּ֤ור הַזֶּה֙ אֲשֶׁ֣ר בַּמִּדְבָּ֔ר וְיָ֖ד אַל־תִּשְׁלְחוּ־בֹ֑ו לְמַ֗עַן הַצִּ֤יל אֹתֹו֙ מִיָּדָ֔ם לַהֲשִׁיבֹ֖ו אֶל־אָבִֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","וֽ͏ַיְהִ֕י כּֽ͏ַאֲשֶׁר־בָּ֥א יֹוסֵ֖ף אֶל־אֶחָ֑יו וַיַּפְשִׁ֤יטוּ אֶת־יֹוסֵף֙ אֶת־כֻּתָּנְתֹּ֔ו אֶת־כְּתֹ֥נֶת הַפַּסִּ֖ים אֲשֶׁ֥ר עָלָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","וַיִּ֨קָּחֻ֔הוּ וַיַּשְׁלִ֥כוּ אֹתֹ֖ו הַבֹּ֑רָה וְהַבֹּ֣ור רֵ֔ק אֵ֥ין בֹּ֖ו מָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","וַיֵּשְׁבוּ֮ לֶֽאֱכָל־לֶחֶם֒ וַיִּשְׂא֤וּ עֵֽינֵיהֶם֙ וַיִּרְא֔וּ וְהִנֵּה֙ אֹרְחַ֣ת יִשְׁמְעֵאלִ֔ים בָּאָ֖ה מִגִּלְעָ֑ד וּגְמַלֵּיהֶ֣ם נֹֽשְׂאִ֗ים נְכֹאת֙ וּצְרִ֣י וָלֹ֔ט הֹולְכִ֖ים לְהֹורִ֥יד מִצְרָֽיְמָה׃ ");
INSERT INTO hbo_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","וַיֹּ֥אמֶר יְהוּדָ֖ה אֶל־אֶחָ֑יו מַה־בֶּ֗צַע כִּ֤י נַהֲרֹג֙ אֶת־אָחִ֔ינוּ וְכִסִּ֖ינוּ אֶת־דָּמֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","לְכ֞וּ וְנִמְכְּרֶ֣נּוּ לַיִּשְׁמְעֵאלִ֗ים וְיָדֵ֙נוּ֙ אַל־תְּהִי־בֹ֔ו כִּֽי־אָחִ֥ינוּ בְשָׂרֵ֖נוּ ה֑וּא וַֽיִּשְׁמְע֖וּ אֶחָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","וַיַּֽעַבְרוּ֩ אֲנָשִׁ֨ים מִדְיָנִ֜ים סֹֽחֲרִ֗ים וַֽיִּמְשְׁכוּ֙ וַיַּֽעֲל֤וּ אֶת־יֹוסֵף֙ מִן־הַבֹּ֔ור וַיִּמְכְּר֧וּ אֶת־יֹוסֵ֛ף לַיִּשְׁמְעֵאלִ֖ים בְּעֶשְׂרִ֣ים כָּ֑סֶף וַיָּבִ֥יאוּ אֶת־יֹוסֵ֖ף מִצְרָֽיְמָה׃ ");
INSERT INTO hbo_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","וַיָּ֤שָׁב רְאוּבֵן֙ אֶל־הַבֹּ֔ור וְהִנֵּ֥ה אֵין־יֹוסֵ֖ף בַּבֹּ֑ור וַיִּקְרַ֖ע אֶת־בְּגָדָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","וַיָּ֥שָׁב אֶל־אֶחָ֖יו וַיֹּאמַ֑ר הַיֶּ֣לֶד אֵינֶ֔נּוּ וַאֲנִ֖י אָ֥נָה אֲנִי־בָֽא׃ ");
INSERT INTO hbo_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","וַיִּקְח֖וּ אֶת־כְּתֹ֣נֶת יֹוסֵ֑ף וַֽיִּשְׁחֲטוּ֙ שְׂעִ֣יר עִזִּ֔ים וַיִּטְבְּל֥וּ אֶת־הַכֻּתֹּ֖נֶת בַּדָּֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","וַֽיְשַׁלְּח֞וּ אֶת־כְּתֹ֣נֶת הַפַּסִּ֗ים וַיָּבִ֙יאוּ֙ אֶל־אֲבִיהֶ֔ם וַיֹּאמְר֖וּ זֹ֣את מָצָ֑אנוּ הַכֶּר־נָ֗א הַכְּתֹ֧נֶת בִּנְךָ֛ הִ֖וא אִם־לֹֽא׃ ");
INSERT INTO hbo_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","וַיַּכִּירָ֤הּ וַיֹּ֙אמֶר֙ כְּתֹ֣נֶת בְּנִ֔י חַיָּ֥ה רָעָ֖ה אֲכָלָ֑תְהוּ טָרֹ֥ף טֹרַ֖ף יֹוסֵֽף׃ ");
INSERT INTO hbo_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","וַיִּקְרַ֤ע יַעֲקֹב֙ שִׂמְלֹתָ֔יו וַיָּ֥שֶׂם שַׂ֖ק בְּמָתְנָ֑יו וַיִּתְאַבֵּ֥ל עַל־בְּנֹ֖ו יָמִ֥ים רַבִּֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","וַיָּקֻמוּ֩ כָל־בָּנָ֨יו וְכָל־בְּנֹתָ֜יו לְנַחֲמֹ֗ו וַיְמָאֵן֙ לְהִתְנַחֵ֔ם וַיֹּ֕אמֶר כִּֽי־אֵרֵ֧ד אֶל־בְּנִ֛י אָבֵ֖ל שְׁאֹ֑לָה וַיֵּ֥בְךְּ אֹתֹ֖ו אָבִֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","וְהַ֨מְּדָנִ֔ים מָכְר֥וּ אֹתֹ֖ו אֶל־מִצְרָ֑יִם לְפֹֽוטִיפַר֙ סְרִ֣יס פַּרְעֹ֔ה שַׂ֖ר הַטַּבָּחִֽים׃ פ ");
INSERT INTO hbo_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","וַֽיְהִי֙ בָּעֵ֣ת הַהִ֔וא וַיֵּ֥רֶד יְהוּדָ֖ה מֵאֵ֣ת אֶחָ֑יו וַיֵּ֛ט עַד־אִ֥ישׁ עֲדֻלָּמִ֖י וּשְׁמֹ֥ו חִירָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","וַיַּרְא־שָׁ֧ם יְהוּדָ֛ה בַּת־אִ֥ישׁ כְּנַעֲנִ֖י וּשְׁמֹ֣ו שׁ֑וּעַ וַיִּקָּחֶ֖הָ וַיָּבֹ֥א אֵלֶֽיהָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","וַתַּ֖הַר וַתֵּ֣לֶד בֵּ֑ן וַיִּקְרָ֥א אֶת־שְׁמֹ֖ו עֵֽר׃ ");
INSERT INTO hbo_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","וַתַּ֥הַר עֹ֖וד וַתֵּ֣לֶד בֵּ֑ן וַתִּקְרָ֥א אֶת־שְׁמֹ֖ו אֹונָֽן׃ ");
INSERT INTO hbo_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","וַתֹּ֤סֶף עֹוד֙ וַתֵּ֣לֶד בֵּ֔ן וַתִּקְרָ֥א אֶת־שְׁמֹ֖ו שֵׁלָ֑ה וְהָיָ֥ה בִכְזִ֖יב בְּלִדְתָּ֥הּ אֹתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","וַיִּקַּ֧ח יְהוּדָ֛ה אִשָּׁ֖ה לְעֵ֣ר בְּכֹורֹ֑ו וּשְׁמָ֖הּ תָּמָֽר׃ ");
INSERT INTO hbo_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","וַיְהִ֗י עֵ֚ר בְּכֹ֣ור יְהוּדָ֔ה רַ֖ע בְּעֵינֵ֣י יְהוָ֑ה וַיְמִתֵ֖הוּ יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","וַיֹּ֤אמֶר יְהוּדָה֙ לְאֹונָ֔ן בֹּ֛א אֶל־אֵ֥שֶׁת אָחִ֖יךָ וְיַבֵּ֣ם אֹתָ֑הּ וְהָקֵ֥ם זֶ֖רַע לְאָחִֽיךָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","וַיֵּ֣דַע אֹונָ֔ן כִּ֛י לֹּ֥א לֹ֖ו יִהְיֶ֣ה הַזָּ֑רַע וְהָיָ֞ה אִם־בָּ֨א אֶל־אֵ֤שֶׁת אָחִיו֙ וְשִׁחֵ֣ת אַ֔רְצָה לְבִלְתִּ֥י נְתָן־זֶ֖רַע לְאָחִֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","וַיֵּ֛רַע בְּעֵינֵ֥י יְהוָ֖ה אֲשֶׁ֣ר עָשָׂ֑ה וַיָּ֖מֶת גַּם־אֹתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","וַיֹּ֣אמֶר יְהוּדָה֩ לְתָמָ֨ר כַּלָּתֹ֜ו שְׁבִ֧י אַלְמָנָ֣ה בֵית־אָבִ֗יךְ עַד־יִגְדַּל֙ שֵׁלָ֣ה בְנִ֔י כִּ֣י אָמַ֔ר פֶּן־יָמ֥וּת גַּם־ה֖וּא כְּאֶחָ֑יו וַתֵּ֣לֶךְ תָּמָ֔ר וַתֵּ֖שֶׁב בֵּ֥ית אָבִֽיהָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","וַיִּרְבּוּ֙ הַיָּמִ֔ים וַתָּ֖מָת בַּת־שׁ֣וּעַ אֵֽשֶׁת־יְהוּדָ֑ה וַיִּנָּ֣חֶם יְהוּדָ֗ה וַיַּ֜עַל עַל־גֹּֽזֲזֵ֤י צֹאנֹו֙ ה֗וּא וְחִירָ֛ה רֵעֵ֥הוּ הָעֲדֻלָּמִ֖י תִּמְנָֽתָה׃ ");
INSERT INTO hbo_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","וַיֻּגַּ֥ד לְתָמָ֖ר לֵאמֹ֑ר הִנֵּ֥ה חָמִ֛יךְ עֹלֶ֥ה תִמְנָ֖תָה לָגֹ֥ז צֹאנֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","וַתָּסַר֩ בִּגְדֵ֨י אַלְמְנוּתָ֜הּ מֵֽעָלֶ֗יהָ וַתְּכַ֤ס בַּצָּעִיף֙ וַתִּתְעַלָּ֔ף וַתֵּ֙שֶׁב֙ בְּפֶ֣תַח עֵינַ֔יִם אֲשֶׁ֖ר עַל־דֶּ֣רֶךְ תִּמְנָ֑תָה כִּ֤י רָאֲתָה֙ כִּֽי־גָדַ֣ל שֵׁלָ֔ה וְהִ֕וא לֹֽא־נִתְּנָ֥ה לֹ֖ו לְאִשָּֽׁה׃ ");
INSERT INTO hbo_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","וַיִּרְאֶ֣הָ יְהוּדָ֔ה וֽ͏ַיַּחְשְׁבֶ֖הָ לְזֹונָ֑ה כִּ֥י כִסְּתָ֖ה פָּנֶֽיהָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","וַיֵּ֨ט אֵלֶ֜יהָ אֶל־הַדֶּ֗רֶךְ וַיֹּ֙אמֶר֙ הָֽבָה־נָּא֙ אָבֹ֣וא אֵלַ֔יִךְ כִּ֚י לֹ֣א יָדַ֔ע כִּ֥י כַלָּתֹ֖ו הִ֑וא וַתֹּ֙אמֶר֙ מַה־תִּתֶּן־לִּ֔י כִּ֥י תָבֹ֖וא אֵלָֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","וַיֹּ֕אמֶר אָנֹכִ֛י אֲשַׁלַּ֥ח גְּדִֽי־עִזִּ֖ים מִן־הַצֹּ֑אן וַתֹּ֕אמֶר אִם־תִּתֵּ֥ן עֵרָבֹ֖ון עַ֥ד שָׁלְחֶֽךָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","וַיֹּ֗אמֶר מָ֣ה הֽ͏ָעֵרָבֹון֮ אֲשֶׁ֣ר אֶתֶּן־לָּךְ֒ וַתֹּ֗אמֶר חֹתָֽמְךָ֙ וּפְתִילֶ֔ךָ וּמַטְּךָ֖ אֲשֶׁ֣ר בְּיָדֶ֑ךָ וַיִּתֶּן־לָּ֛הּ וַיָּבֹ֥א אֵלֶ֖יהָ וַתַּ֥הַר לֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","וַתָּ֣קָם וַתֵּ֔לֶךְ וַתָּ֥סַר צְעִיפָ֖הּ מֵעָלֶ֑יהָ וַתִּלְבַּ֖שׁ בִּגְדֵ֥י אַלְמְנוּתָֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","וַיִּשְׁלַ֨ח יְהוּדָ֜ה אֶת־גְּדִ֣י הָֽעִזִּ֗ים בְּיַד֙ רֵעֵ֣הוּ הָֽעֲדֻלָּמִ֔י לָקַ֥חַת הָעֵרָבֹ֖ון מִיַּ֣ד הָאִשָּׁ֑ה וְלֹ֖א מְצָאָֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","וַיִּשְׁאַ֞ל אֶת־אַנְשֵׁ֤י מְקֹמָהּ֙ לֵאמֹ֔ר אַיֵּ֧ה הַקְּדֵשָׁ֛ה הִ֥וא בָעֵינַ֖יִם עַל־הַדָּ֑רֶךְ וַיֹּ֣אמְר֔וּ לֹא־הָיְתָ֥ה בָזֶ֖ה קְדֵשָֽׁה׃ ");
INSERT INTO hbo_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","וַיָּ֙שָׁב֙ אֶל־יְהוּדָ֔ה וַיֹּ֖אמֶר לֹ֣א מְצָאתִ֑יהָ וְגַ֨ם אַנְשֵׁ֤י הַמָּקֹום֙ אָֽמְר֔וּ לֹא־הָיְתָ֥ה בָזֶ֖ה קְדֵשָֽׁה׃ ");
INSERT INTO hbo_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","וַיֹּ֤אמֶר יְהוּדָה֙ תִּֽקַּֽח־לָ֔הּ פֶּ֖ן נִהְיֶ֣ה לָב֑וּז הִנֵּ֤ה שָׁלַ֙חְתִּי֙ הַגְּדִ֣י הַזֶּ֔ה וְאַתָּ֖ה לֹ֥א מְצָאתָֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","וַיְהִ֣י ׀ כְּמִשְׁלֹ֣שׁ חֳדָשִׁ֗ים וַיֻּגַּ֨ד לִֽיהוּדָ֤ה לֽ͏ֵאמֹר֙ זָֽנְתָה֙ תָּמָ֣ר כַּלָּתֶ֔ךָ וְגַ֛ם הִנֵּ֥ה הָרָ֖ה לִזְנוּנִ֑ים וַיֹּ֣אמֶר יְהוּדָ֔ה הֹוצִיא֖וּהָ וְתִשָּׂרֵֽף׃ ");
INSERT INTO hbo_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","הִ֣וא מוּצֵ֗את וְהִ֨יא שָׁלְחָ֤ה אֶל־חָמִ֙יהָ֙ לֵאמֹ֔ר לְאִישׁ֙ אֲשֶׁר־אֵ֣לֶּה לֹּ֔ו אָנֹכִ֖י הָרָ֑ה וַתֹּ֙אמֶר֙ הַכֶּר־נָ֔א לְמִ֞י הַחֹתֶ֧מֶת וְהַפְּתִילִ֛ים וְהַמַּטֶּ֖ה הָאֵֽלֶּה׃ ");
INSERT INTO hbo_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","וַיַּכֵּ֣ר יְהוּדָ֗ה וַיֹּ֙אמֶר֙ צָֽדְקָ֣ה מִמֶּ֔נִּי כִּֽי־עַל־כֵּ֥ן לֹא־נְתַתִּ֖יהָ לְשֵׁלָ֣ה בְנִ֑י וְלֹֽא־יָסַ֥ף עֹ֖וד לְדַעְתָּֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","וַיְהִ֖י בְּעֵ֣ת לִדְתָּ֑הּ וְהִנֵּ֥ה תְאֹומִ֖ים בְּבִטְנָֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","וַיְהִ֥י בְלִדְתָּ֖הּ וַיִּתֶּן־יָ֑ד וַתִּקַּ֣ח הַמְיַלֶּ֗דֶת וַתִּקְשֹׁ֨ר עַל־יָדֹ֤ו שָׁנִי֙ לֵאמֹ֔ר זֶ֖ה יָצָ֥א רִאשֹׁנָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","וַיְהִ֣י ׀ כְּמֵשִׁ֣יב יָדֹ֗ו וְהִנֵּה֙ יָצָ֣א אָחִ֔יו וַתֹּ֕אמֶר מַה־פָּרַ֖צְתָּ עָלֶ֣יךָ פָּ֑רֶץ וַיִּקְרָ֥א שְׁמֹ֖ו פָּֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","וְאַחַר֙ יָצָ֣א אָחִ֔יו אֲשֶׁ֥ר עַל־יָדֹ֖ו הַשָּׁנִ֑י וַיִּקְרָ֥א שְׁמֹ֖ו זָֽרַח׃ ס ");
INSERT INTO hbo_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","וְיֹוסֵ֖ף הוּרַ֣ד מִצְרָ֑יְמָה וַיִּקְנֵ֡הוּ פֹּוטִיפַר֩ סְרִ֨יס פַּרְעֹ֜ה שַׂ֤ר הַטַּבָּחִים֙ אִ֣ישׁ מִצְרִ֔י מִיַּד֙ הַיִּשְׁמְעֵאלִ֔ים אֲשֶׁ֥ר הֹורִדֻ֖הוּ שָֽׁמָּה׃ ");
INSERT INTO hbo_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","וַיְהִ֤י יְהוָה֙ אֶת־יֹוסֵ֔ף וַיְהִ֖י אִ֣ישׁ מַצְלִ֑יחַ וַיְהִ֕י בְּבֵ֥ית אֲדֹנָ֖יו הַמִּצְרִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","וַיַּ֣רְא אֲדֹנָ֔יו כִּ֥י יְהוָ֖ה אִתֹּ֑ו וְכֹל֙ אֲשֶׁר־ה֣וּא עֹשֶׂ֔ה יְהוָ֖ה מַצְלִ֥יחַ בְּיָדֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","וַיִּמְצָ֨א יֹוסֵ֥ף חֵ֛ן בְּעֵינָ֖יו וַיְשָׁ֣רֶת אֹתֹ֑ו וַיַּפְקִדֵ֙הוּ֙ עַל־בֵּיתֹ֔ו וְכָל־יֶשׁ־לֹ֖ו נָתַ֥ן בְּיָדֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","וַיְהִ֡י מֵאָז֩ הִפְקִ֨יד אֹתֹ֜ו בְּבֵיתֹ֗ו וְעַל֙ כָּל־אֲשֶׁ֣ר יֶשׁ־לֹ֔ו וַיְבָ֧רֶךְ יְהוָ֛ה אֶת־בֵּ֥ית הַמִּצְרִ֖י בִּגְלַ֣ל יֹוסֵ֑ף וַיְהִ֞י בִּרְכַּ֤ת יְהוָה֙ בְּכָל־אֲשֶׁ֣ר יֶשׁ־לֹ֔ו בַּבַּ֖יִת וּבַשָּׂדֶֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","וַיַּעֲזֹ֣ב כָּל־אֲשֶׁר־לֹו֮ בְּיַד־יֹוסֵף֒ וְלֹא־יָדַ֤ע אִתֹּו֙ מְא֔וּמָה כִּ֥י אִם־הַלֶּ֖חֶם אֲשֶׁר־ה֣וּא אֹוכֵ֑ל וַיְהִ֣י יֹוסֵ֔ף יְפֵה־תֹ֖אַר וִיפֵ֥ה מַרְאֶֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","וַיְהִ֗י אַחַר֙ הַדְּבָרִ֣ים הָאֵ֔לֶּה וַתִּשָּׂ֧א אֵֽשֶׁת־אֲדֹנָ֛יו אֶת־עֵינֶ֖יהָ אֶל־יֹוסֵ֑ף וַתֹּ֖אמֶר שִׁכְבָ֥ה עִמִּֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","וַיְמָאֵ֓ן ׀ וַיֹּ֙אמֶר֙ אֶל־אֵ֣שֶׁת אֲדֹנָ֔יו הֵ֣ן אֲדֹנִ֔י לֹא־יָדַ֥ע אִתִּ֖י מַה־בַּבָּ֑יִת וְכֹ֥ל אֲשֶׁר־יֶשׁ־לֹ֖ו נָתַ֥ן בְּיָדִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","אֵינֶ֨נּוּ גָדֹ֜ול בַּבַּ֣יִת הַזֶּה֮ מִמֶּנִּי֒ וְלֹֽא־חָשַׂ֤ךְ מִמֶּ֙נִּי֙ מְא֔וּמָה כִּ֥י אִם־אֹותָ֖ךְ בַּאֲשֶׁ֣ר אַתְּ־אִשְׁתֹּ֑ו וְאֵ֨יךְ אֶֽעֱשֶׂ֜ה הָרָעָ֤ה הַגְּדֹלָה֙ הַזֹּ֔את וְחָטָ֖אתִי לֵֽאלֹהִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","וַיְהִ֕י כְּדַבְּרָ֥הּ אֶל־יֹוסֵ֖ף יֹ֣ום ׀ יֹ֑ום וְלֹא־שָׁמַ֥ע אֵלֶ֛יהָ לִשְׁכַּ֥ב אֶצְלָ֖הּ לִהְיֹ֥ות עִמָּֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","וַיְהִי֙ כְּהַיֹּ֣ום הַזֶּ֔ה וַיָּבֹ֥א הַבַּ֖יְתָה לַעֲשֹׂ֣ות מְלַאכְתֹּ֑ו וְאֵ֨ין אִ֜ישׁ מֵאַנְשֵׁ֥י הַבַּ֛יִת שָׁ֖ם בַּבָּֽיִת׃ ");
INSERT INTO hbo_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","וַתִּתְפְּשֵׂ֧הוּ בְּבִגְדֹ֛ו לֵאמֹ֖ר שִׁכְבָ֣ה עִמִּ֑י וַיַּעֲזֹ֤ב בִּגְדֹו֙ בְּיָדָ֔הּ וַיָּ֖נָס וַיֵּצֵ֥א הַחֽוּצָה׃ ");
INSERT INTO hbo_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","וַיְהִי֙ כִּרְאֹותָ֔הּ כִּֽי־עָזַ֥ב בִּגְדֹ֖ו בְּיָדָ֑הּ וַיָּ֖נָס הַחֽוּצָה׃ ");
INSERT INTO hbo_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","וַתִּקְרָ֞א לְאַנְשֵׁ֣י בֵיתָ֗הּ וַתֹּ֤אמֶר לָהֶם֙ לֵאמֹ֔ר רְא֗וּ הֵ֥בִיא לָ֛נוּ אִ֥ישׁ עִבְרִ֖י לְצַ֣חֶק בָּ֑נוּ בָּ֤א אֵלַי֙ לִשְׁכַּ֣ב עִמִּ֔י וָאֶקְרָ֖א בְּקֹ֥ול גָּדֹֽול׃ ");
INSERT INTO hbo_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","וַיְהִ֣י כְשָׁמְעֹ֔ו כִּֽי־הֲרִימֹ֥תִי קֹולִ֖י וָאֶקְרָ֑א וַיַּעֲזֹ֤ב בִּגְדֹו֙ אֶצְלִ֔י וַיָּ֖נָס וַיֵּצֵ֥א הַחֽוּצָה׃ ");
INSERT INTO hbo_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","וַתַּנַּ֥ח בִּגְדֹ֖ו אֶצְלָ֑הּ עַד־בֹּ֥וא אֲדֹנָ֖יו אֶל־בֵּיתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","וַתְּדַבֵּ֣ר אֵלָ֔יו כַּדְּבָרִ֥ים הָאֵ֖לֶּה לֵאמֹ֑ר בָּֽא־אֵלַ֞י הָעֶ֧בֶד הָֽעִבְרִ֛י אֲשֶׁר־הֵבֵ֥אתָ לָּ֖נוּ לְצַ֥חֶק בִּֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","וַיְהִ֕י כַּהֲרִימִ֥י קֹולִ֖י וָאֶקְרָ֑א וַיַּעֲזֹ֥ב בִּגְדֹ֛ו אֶצְלִ֖י וַיָּ֥נָס הַחֽוּצָה׃ ");
INSERT INTO hbo_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","וַיְהִי֩ כִשְׁמֹ֨עַ אֲדֹנָ֜יו אֶת־דִּבְרֵ֣י אִשְׁתֹּ֗ו אֲשֶׁ֨ר דִּבְּרָ֤ה אֵלָיו֙ לֵאמֹ֔ר כַּדְּבָרִ֣ים הָאֵ֔לֶּה עָ֥שָׂהּ לִ֖י עַבְדֶּ֑ךָ וַיִּ֖חַר אַפֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","וַיִּקַּח֩ אֲדֹנֵ֨י יֹוסֵ֜ף אֹתֹ֗ו וַֽיִּתְּנֵ֙הוּ֙ אֶל־בֵּ֣ית הַסֹּ֔הַר מְקֹ֕ום אֲשֶׁר־*אֲסוּרֵי (אֲסִירֵ֥י) הַמֶּ֖לֶךְ אֲסוּרִ֑ים וֽ͏ַיְהִי־שָׁ֖ם בְּבֵ֥ית הַסֹּֽהַר׃ ");
INSERT INTO hbo_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","וַיְהִ֤י יְהוָה֙ אֶת־יֹוסֵ֔ף וַיֵּ֥ט אֵלָ֖יו חָ֑סֶד וַיִּתֵּ֣ן חִנֹּ֔ו בְּעֵינֵ֖י שַׂ֥ר בֵּית־הַסֹּֽהַר׃ ");
INSERT INTO hbo_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","וַיִּתֵּ֞ן שַׂ֤ר בֵּית־הַסֹּ֙הַר֙ בְּיַד־יֹוסֵ֔ף אֵ֚ת כָּל־הָ֣אֲסִירִ֔ם אֲשֶׁ֖ר בְּבֵ֣ית הַסֹּ֑הַר וְאֵ֨ת כָּל־אֲשֶׁ֤ר עֹשִׂים֙ שָׁ֔ם ה֖וּא הָיָ֥ה עֹשֶֽׂה׃ ");
INSERT INTO hbo_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","אֵ֣ין ׀ שַׂ֣ר בֵּית־הַסֹּ֗הַר רֹאֶ֤ה אֶֽת־כָּל־מְא֙וּמָה֙ בְּיָדֹ֔ו בַּאֲשֶׁ֥ר יְהוָ֖ה אִתֹּ֑ו וַֽאֲשֶׁר־ה֥וּא עֹשֶׂ֖ה יְהוָ֥ה מַצְלִֽיחַ׃ ס ");
INSERT INTO hbo_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","וַיְהִ֗י אַחַר֙ הַדְּבָרִ֣ים הָאֵ֔לֶּה חָ֥טְא֛וּ מַשְׁקֵ֥ה מֶֽלֶךְ־מִצְרַ֖יִם וְהָאֹפֶ֑ה לַאֲדֹנֵיהֶ֖ם לְמֶ֥לֶךְ מִצְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","וַיִּקְצֹ֣ף פַּרְעֹ֔ה עַ֖ל שְׁנֵ֣י סָרִיסָ֑יו עַ֚ל שַׂ֣ר הַמַּשְׁקִ֔ים וְעַ֖ל שַׂ֥ר הָאֹופִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","וַיִּתֵּ֨ן אֹתָ֜ם בְּמִשְׁמַ֗ר בֵּ֛ית שַׂ֥ר הַטַבָּחִ֖ים אֶל־בֵּ֣ית הַסֹּ֑הַר מְקֹ֕ום אֲשֶׁ֥ר יֹוסֵ֖ף אָס֥וּר שָֽׁם׃ ");
INSERT INTO hbo_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","וַ֠יִּפְקֹד שַׂ֣ר הַטַּבָּחִ֧ים אֶת־יֹוסֵ֛ף אִתָּ֖ם וַיְשָׁ֣רֶת אֹתָ֑ם וַיִּהְי֥וּ יָמִ֖ים בְּמִשְׁמָֽר׃ ");
INSERT INTO hbo_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","וַיַּֽחַלְמוּ֩ חֲלֹ֨ום שְׁנֵיהֶ֜ם אִ֤ישׁ חֲלֹמֹו֙ בְּלַ֣יְלָה אֶחָ֔ד אִ֖ישׁ כְּפִתְרֹ֣ון חֲלֹמֹ֑ו הַמַּשְׁקֶ֣ה וְהָאֹפֶ֗ה אֲשֶׁר֙ לְמֶ֣לֶךְ מִצְרַ֔יִם אֲשֶׁ֥ר אֲסוּרִ֖ים בְּבֵ֥ית הַסֹּֽהַר׃ ");
INSERT INTO hbo_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","וַיָּבֹ֧א אֲלֵיהֶ֛ם יֹוסֵ֖ף בַּבֹּ֑קֶר וַיַּ֣רְא אֹתָ֔ם וְהִנָּ֖ם זֹעֲפִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","וַיִּשְׁאַ֞ל אֶת־סְרִיסֵ֣י פַרְעֹ֗ה אֲשֶׁ֨ר אִתֹּ֧ו בְמִשְׁמַ֛ר בֵּ֥ית אֲדֹנָ֖יו לֵאמֹ֑ר מַדּ֛וּעַ פְּנֵיכֶ֥ם רָעִ֖ים הַיֹּֽום׃ ");
INSERT INTO hbo_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","וַיֹּאמְר֣וּ אֵלָ֔יו חֲלֹ֣ום חָלַ֔מְנוּ וּפֹתֵ֖ר אֵ֣ין אֹתֹ֑ו וַיֹּ֨אמֶר אֲלֵהֶ֜ם יֹוסֵ֗ף הֲלֹ֤וא לֽ͏ֵאלֹהִים֙ פִּתְרֹנִ֔ים סַפְּרוּ־נָ֖א לִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","וַיְסַפֵּ֧ר שַֽׂר־הַמַּשְׁקִ֛ים אֶת־חֲלֹמֹ֖ו לְיֹוסֵ֑ף וַיֹּ֣אמֶר לֹ֔ו בַּחֲלֹומִ֕י וְהִנֵּה־גֶ֖פֶן לְפָנָֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","וּבַגֶּ֖פֶן שְׁלֹשָׁ֣ה שָׂרִיגִ֑ם וְהִ֤יא כְפֹרַ֙חַת֙ עָלְתָ֣ה נִצָּ֔הּ הִבְשִׁ֥ילוּ אַשְׁכְּלֹתֶ֖יהָ עֲנָבִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","וְכֹ֥וס פַּרְעֹ֖ה בְּיָדִ֑י וָאֶקַּ֣ח אֶת־הָֽעֲנָבִ֗ים וָֽאֶשְׂחַ֤ט אֹתָם֙ אֶל־כֹּ֣וס פַּרְעֹ֔ה וָאֶתֵּ֥ן אֶת־הַכֹּ֖וס עַל־כַּ֥ף פַּרְעֹֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","וַיֹּ֤אמֶר לֹו֙ יֹוסֵ֔ף זֶ֖ה פִּתְרֹנֹ֑ו שְׁלֹ֙שֶׁת֙ הַשָּׂ֣רִגִ֔ים שְׁלֹ֥שֶׁת יָמִ֖ים הֵֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","בְּעֹ֣וד ׀ שְׁלֹ֣שֶׁת יָמִ֗ים יִשָּׂ֤א פַרְעֹה֙ אֶת־רֹאשֶׁ֔ךָ וַהֲשִֽׁיבְךָ֖ עַל־כַּנֶּ֑ךָ וְנָתַתָּ֤ כֹוס־פַּרְעֹה֙ בְּיָדֹ֔ו כַּמִּשְׁפָּט֙ הָֽרִאשֹׁ֔ון אֲשֶׁ֥ר הָיִ֖יתָ מַשְׁקֵֽהוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","כִּ֧י אִם־זְכַרְתַּ֣נִי אִתְּךָ֗ כַּאֲשֶׁר֙ יִ֣יטַב לָ֔ךְ וְעָשִֽׂיתָ־נָּ֥א עִמָּדִ֖י חָ֑סֶד וְהִזְכַּרְתַּ֙נִי֙ אֶל־פַּרְעֹ֔ה וְהֹוצֵאתַ֖נִי מִן־הַבַּ֥יִת הַזֶּֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","כִּֽי־גֻנֹּ֣ב גֻּנַּ֔בְתִּי מֵאֶ֖רֶץ הָעִבְרִ֑ים וְגַם־פֹּה֙ לֹא־עָשִׂ֣יתִֽי מְא֔וּמָה כִּֽי־שָׂמ֥וּ אֹתִ֖י בַּבֹּֽור׃ ");
INSERT INTO hbo_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","וַיַּ֥רְא שַׂר־הָאֹפִ֖ים כִּ֣י טֹ֣וב פָּתָ֑ר וַיֹּ֙אמֶר֙ אֶל־יֹוסֵ֔ף אַף־אֲנִי֙ בַּחֲלֹומִ֔י וְהִנֵּ֗ה שְׁלֹשָׁ֛ה סַלֵּ֥י חֹרִ֖י עַל־רֹאשִֽׁי׃ ");
INSERT INTO hbo_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","וּבַסַּ֣ל הָֽעֶלְיֹו֔ן מִכֹּ֛ל מַאֲכַ֥ל פַּרְעֹ֖ה מַעֲשֵׂ֣ה אֹפֶ֑ה וְהָעֹ֗וף אֹכֵ֥ל אֹתָ֛ם מִן־הַסַּ֖ל מֵעַ֥ל רֹאשִֽׁי׃ ");
INSERT INTO hbo_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","וַיַּ֤עַן יֹוסֵף֙ וַיֹּ֔אמֶר זֶ֖ה פִּתְרֹנֹ֑ו שְׁלֹ֙שֶׁת֙ הַסַּלִּ֔ים שְׁלֹ֥שֶׁת יָמִ֖ים הֵֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","בְּעֹ֣וד ׀ שְׁלֹ֣שֶׁת יָמִ֗ים יִשָּׂ֨א פַרְעֹ֤ה אֶת־רֹֽאשְׁךָ֙ מֵֽעָלֶ֔יךָ וְתָלָ֥ה אֹותְךָ֖ עַל־עֵ֑ץ וְאָכַ֥ל הָעֹ֛וף אֶת־בְּשָׂרְךָ֖ מֵעָלֶֽיךָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","וַיְהִ֣י ׀ בַּיֹּ֣ום הַשְּׁלִישִׁ֗י יֹ֚ום הֻלֶּ֣דֶת אֶת־פַּרְעֹ֔ה וַיַּ֥עַשׂ מִשְׁתֶּ֖ה לְכָל־עֲבָדָ֑יו וַיִּשָּׂ֞א אֶת־רֹ֣אשׁ ׀ שַׂ֣ר הַמַּשְׁקִ֗ים וְאֶת־רֹ֛אשׁ שַׂ֥ר הָאֹפִ֖ים בְּתֹ֥וךְ עֲבָדָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","וַיָּ֛שֶׁב אֶת־שַׂ֥ר הַמַּשְׁקִ֖ים עַל־מַשְׁקֵ֑הוּ וַיִּתֵּ֥ן הַכֹּ֖וס עַל־כַּ֥ף פַּרְעֹֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","וְאֵ֛ת שַׂ֥ר הָאֹפִ֖ים תָּלָ֑ה כַּאֲשֶׁ֥ר פָּתַ֛ר לָהֶ֖ם יֹוסֵֽף׃ ");
INSERT INTO hbo_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","וְלֹֽא־זָכַ֧ר שַֽׂר־הַמַּשְׁקִ֛ים אֶת־יֹוסֵ֖ף וַיִּשְׁכָּחֵֽהוּ׃ פ ");
INSERT INTO hbo_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","וַיְהִ֕י מִקֵּ֖ץ שְׁנָתַ֣יִם יָמִ֑ים וּפַרְעֹ֣ה חֹלֵ֔ם וְהִנֵּ֖ה עֹמֵ֥ד עַל־הַיְאֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","וְהִנֵּ֣ה מִן־הַיְאֹ֗ר עֹלֹת֙ שֶׁ֣בַע פָּרֹ֔ות יְפֹ֥ות מַרְאֶ֖ה וּבְרִיאֹ֣ת בָּשָׂ֑ר וַתִּרְעֶ֖ינָה בָּאָֽחוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","וְהִנֵּ֞ה שֶׁ֧בַע פָּרֹ֣ות אֲחֵרֹ֗ות עֹלֹ֤ות אַחֲרֵיהֶן֙ מִן־הַיְאֹ֔ר רָעֹ֥ות מַרְאֶ֖ה וְדַקֹּ֣ות בָּשָׂ֑ר וַֽתַּעֲמֹ֛דְנָה אֵ֥צֶל הַפָּרֹ֖ות עַל־שְׂפַ֥ת הַיְאֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","וַתֹּאכַ֣לְנָה הַפָּרֹ֗ות רָעֹ֤ות הַמַּרְאֶה֙ וְדַקֹּ֣ת הַבָּשָׂ֔ר אֵ֚ת שֶׁ֣בַע הַפָּרֹ֔ות יְפֹ֥ת הַמַּרְאֶ֖ה וְהַבְּרִיאֹ֑ת וַיִּיקַ֖ץ פַּרְעֹֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","וַיִּישָׁ֕ן וַֽיַּחֲלֹ֖ם שֵׁנִ֑ית וְהִנֵּ֣ה ׀ שֶׁ֣בַע שִׁבֳּלִ֗ים עֹלֹ֛ות בְּקָנֶ֥ה אֶחָ֖ד בְּרִיאֹ֥ות וְטֹבֹֽות׃ ");
INSERT INTO hbo_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","וְהִנֵּה֙ שֶׁ֣בַע שִׁבֳּלִ֔ים דַּקֹּ֖ות וּשְׁדוּפֹ֣ת קָדִ֑ים צֹמְחֹ֖ות אַחֲרֵיהֶֽן׃ ");
INSERT INTO hbo_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","וַתִּבְלַ֙עְנָה֙ הַשִּׁבֳּלִ֣ים הַדַּקֹּ֔ות אֵ֚ת שֶׁ֣בַע הַֽשִּׁבֳּלִ֔ים הַבְּרִיאֹ֖ות וְהַמְּלֵאֹ֑ות וַיִּיקַ֥ץ פַּרְעֹ֖ה וְהִנֵּ֥ה חֲלֹֽום׃ ");
INSERT INTO hbo_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","וַיְהִ֤י בַבֹּ֙קֶר֙ וַתִּפָּ֣עֶם רוּחֹ֔ו וַיִּשְׁלַ֗ח וַיִּקְרָ֛א אֶת־כָּל־חַרְטֻמֵּ֥י מִצְרַ֖יִם וְאֶת־כָּל־חֲכָמֶ֑יהָ וַיְסַפֵּ֨ר פַּרְעֹ֤ה לָהֶם֙ אֶת־חֲלֹמֹ֔ו וְאֵין־פֹּותֵ֥ר אֹותָ֖ם לְפַרְעֹֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","וַיְדַבֵּר֙ שַׂ֣ר הַמַּשְׁקִ֔ים אֶת־פַּרְעֹ֖ה לֵאמֹ֑ר אֶת־חֲטָאַ֕י אֲנִ֖י מַזְכִּ֥יר הַיֹּֽום׃ ");
INSERT INTO hbo_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","פַּרְעֹ֖ה קָצַ֣ף עַל־עֲבָדָ֑יו וַיִּתֵּ֨ן אֹתִ֜י בְּמִשְׁמַ֗ר בֵּ֚ית שַׂ֣ר הַטַּבָּחִ֔ים אֹתִ֕י וְאֵ֖ת שַׂ֥ר הָאֹפִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","וַנַּֽחַלְמָ֥ה חֲלֹ֛ום בְּלַ֥יְלָה אֶחָ֖ד אֲנִ֣י וָה֑וּא אִ֛ישׁ כְּפִתְרֹ֥ון חֲלֹמֹ֖ו חָלָֽמְנוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","וְשָׁ֨ם אִתָּ֜נוּ נַ֣עַר עִבְרִ֗י עֶ֚בֶד לְשַׂ֣ר הַטַּבָּחִ֔ים וַנְּ֨סַפֶּר־לֹ֔ו וַיִּפְתָּר־לָ֖נוּ אֶת־חֲלֹמֹתֵ֑ינוּ אִ֥ישׁ כַּחֲלֹמֹ֖ו פָּתָֽר׃ ");
INSERT INTO hbo_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","וַיְהִ֛י כַּאֲשֶׁ֥ר פָּֽתַר־לָ֖נוּ כֵּ֣ן הָיָ֑ה אֹתִ֛י הֵשִׁ֥יב עַל־כַּנִּ֖י וְאֹתֹ֥ו תָלָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","וַיִּשְׁלַ֤ח פַּרְעֹה֙ וַיִּקְרָ֣א אֶת־יֹוסֵ֔ף וַיְרִיצֻ֖הוּ מִן־הַבֹּ֑ור וַיְגַלַּח֙ וַיְחַלֵּ֣ף שִׂמְלֹתָ֔יו וַיָּבֹ֖א אֶל־פַּרְעֹֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","וַיֹּ֤אמֶר פַּרְעֹה֙ אֶל־יֹוסֵ֔ף חֲלֹ֣ום חָלַ֔מְתִּי וּפֹתֵ֖ר אֵ֣ין אֹתֹ֑ו וַאֲנִ֗י שָׁמַ֤עְתִּי עָלֶ֙יךָ֙ לֵאמֹ֔ר תִּשְׁמַ֥ע חֲלֹ֖ום לִפְתֹּ֥ר אֹתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","וַיַּ֨עַן יֹוסֵ֧ף אֶת־פַּרְעֹ֛ה לֵאמֹ֖ר בִּלְעָדָ֑י אֱלֹהִ֕ים יַעֲנֶ֖ה אֶת־שְׁלֹ֥ום פַּרְעֹֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","וַיְדַבֵּ֥ר פַּרְעֹ֖ה אֶל־יֹוסֵ֑ף בַּחֲלֹמִ֕י הִנְנִ֥י עֹמֵ֖ד עַל־שְׂפַ֥ת הַיְאֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","וְהִנֵּ֣ה מִן־הַיְאֹ֗ר עֹלֹת֙ שֶׁ֣בַע פָּרֹ֔ות בְּרִיאֹ֥ות בָּשָׂ֖ר וִיפֹ֣ת תֹּ֑אַר וַתִּרְעֶ֖ינָה בָּאָֽחוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","וְהִנֵּ֞ה שֶֽׁבַע־פָּרֹ֤ות אֲחֵרֹות֙ עֹלֹ֣ות אַחֲרֵיהֶ֔ן דַּלֹּ֨ות וְרָעֹ֥ות תֹּ֛אַר מְאֹ֖ד וְרַקֹּ֣ות בָּשָׂ֑ר לֹֽא־רָאִ֧יתִי כָהֵ֛נָּה בְּכָל־אֶ֥רֶץ מִצְרַ֖יִם לָרֹֽעַ׃ ");
INSERT INTO hbo_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","וַתֹּאכַ֙לְנָה֙ הַפָּרֹ֔ות הָרַקֹּ֖ות וְהָרָעֹ֑ות אֵ֣ת שֶׁ֧בַע הַפָּרֹ֛ות הָרִאשֹׁנֹ֖ות הַבְּרִיאֹֽת׃ ");
INSERT INTO hbo_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","וַתָּבֹ֣אנָה אֶל־קִרְבֶּ֗נָה וְלֹ֤א נֹודַע֙ כִּי־בָ֣אוּ אֶל־קִרְבֶּ֔נָה וּמַרְאֵיהֶ֣ן רַ֔ע כַּאֲשֶׁ֖ר בַּתְּחִלָּ֑ה וָאִיקָֽץ׃ ");
INSERT INTO hbo_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","וָאֵ֖רֶא בַּחֲלֹמִ֑י וְהִנֵּ֣ה ׀ שֶׁ֣בַע שִׁבֳּלִ֗ים עֹלֹ֛ת בְּקָנֶ֥ה אֶחָ֖ד מְלֵאֹ֥ת וְטֹבֹֽות׃ ");
INSERT INTO hbo_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","וְהִנֵּה֙ שֶׁ֣בַע שִׁבֳּלִ֔ים צְנֻמֹ֥ות דַּקֹּ֖ות שְׁדֻפֹ֣ות קָדִ֑ים צֹמְחֹ֖ות אַחֲרֵיהֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","וַתִּבְלַ֙עְןָ֙ הָשִׁבֳּלִ֣ים הַדַּקֹּ֔ת אֵ֛ת שֶׁ֥בַע הַֽשִׁבֳּלִ֖ים הַטֹּבֹ֑ות וָֽאֹמַר֙ אֶל־הַֽחַרְטֻמִּ֔ים וְאֵ֥ין מַגִּ֖יד לִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","וַיֹּ֤אמֶר יֹוסֵף֙ אֶל־פַּרְעֹ֔ה חֲלֹ֥ום פַּרְעֹ֖ה אֶחָ֣ד ה֑וּא אֵ֣ת אֲשֶׁ֧ר הָאֱלֹהִ֛ים עֹשֶׂ֖ה הִגִּ֥יד לְפַרְעֹֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","שֶׁ֧בַע פָּרֹ֣ת הַטֹּבֹ֗ת שֶׁ֤בַע שָׁנִים֙ הֵ֔נָּה וְשֶׁ֤בַע הַֽשִּׁבֳּלִים֙ הַטֹּבֹ֔ת שֶׁ֥בַע שָׁנִ֖ים הֵ֑נָּה חֲלֹ֖ום אֶחָ֥ד הֽוּא׃ ");
INSERT INTO hbo_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","וְשֶׁ֣בַע הַ֠פָּרֹות הָֽרַקֹּ֨ות וְהָרָעֹ֜ת הָעֹלֹ֣ת אַחֲרֵיהֶ֗ן שֶׁ֤בַע שָׁנִים֙ הֵ֔נָּה וְשֶׁ֤בַע הַֽשִׁבֳּלִים֙ הָרֵקֹ֔ות שְׁדֻפֹ֖ות הַקָּדִ֑ים יִהְי֕וּ שֶׁ֖בַע שְׁנֵ֥י רָעָֽב׃ ");
INSERT INTO hbo_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","ה֣וּא הַדָּבָ֔ר אֲשֶׁ֥ר דִּבַּ֖רְתִּי אֶל־פַּרְעֹ֑ה אֲשֶׁ֧ר הָאֱלֹהִ֛ים עֹשֶׂ֖ה הֶרְאָ֥ה אֶת־פַּרְעֹֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","הִנֵּ֛ה שֶׁ֥בַע שָׁנִ֖ים בָּאֹ֑ות שָׂבָ֥ע גָּדֹ֖ול בְּכָל־אֶ֥רֶץ מִצְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","וְ֠קָמוּ שֶׁ֨בַע שְׁנֵ֤י רָעָב֙ אַחֲרֵיהֶ֔ן וְנִשְׁכַּ֥ח כָּל־הַשָּׂבָ֖ע בְּאֶ֣רֶץ מִצְרָ֑יִם וְכִלָּ֥ה הָרָעָ֖ב אֶת־הָאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","וְלֹֽא־יִוָּדַ֤ע הַשָּׂבָע֙ בָּאָ֔רֶץ מִפְּנֵ֛י הָרָעָ֥ב הַה֖וּא אַחֲרֵי־כֵ֑ן כִּֽי־כָבֵ֥ד ה֖וּא מְאֹֽד׃ ");
INSERT INTO hbo_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","וְעַ֨ל הִשָּׁנֹ֧ות הַחֲלֹ֛ום אֶל־פַּרְעֹ֖ה פַּעֲמָ֑יִם כִּֽי־נָכֹ֤ון הַדָּבָר֙ מֵעִ֣ם הָאֱלֹהִ֔ים וּמְמַהֵ֥ר הָאֱלֹהִ֖ים לַעֲשֹׂתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","וְעַתָּה֙ יֵרֶ֣א פַרְעֹ֔ה אִ֖ישׁ נָבֹ֣ון וְחָכָ֑ם וִישִׁיתֵ֖הוּ עַל־אֶ֥רֶץ מִצְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","יַעֲשֶׂ֣ה פַרְעֹ֔ה וְיַפְקֵ֥ד פְּקִדִ֖ים עַל־הָאָ֑רֶץ וְחִמֵּשׁ֙ אֶת־אֶ֣רֶץ מִצְרַ֔יִם בְּשֶׁ֖בַע שְׁנֵ֥י הַשָּׂבָֽע׃ ");
INSERT INTO hbo_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","וְיִקְבְּצ֗וּ אֶת־כָּל־אֹ֙כֶל֙ הַשָּׁנִ֣ים הַטֹּבֹ֔ת הַבָּאֹ֖ת הָאֵ֑לֶּה וְיִצְבְּרוּ־בָ֞ר תַּ֧חַת יַד־פַּרְעֹ֛ה אֹ֥כֶל בֶּעָרִ֖ים וְשָׁמָֽרוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","וְהָיָ֨ה הָאֹ֤כֶל לְפִקָּדֹון֙ לָאָ֔רֶץ לְשֶׁ֙בַע֙ שְׁנֵ֣י הָרָעָ֔ב אֲשֶׁ֥ר תִּהְיֶ֖יןָ בְּאֶ֣רֶץ מִצְרָ֑יִם וְלֹֽא־תִכָּרֵ֥ת הָאָ֖רֶץ בָּרָעָֽב׃ ");
INSERT INTO hbo_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","וַיִּיטַ֥ב הַדָּבָ֖ר בְּעֵינֵ֣י פַרְעֹ֑ה וּבְעֵינֵ֖י כָּל־עֲבָדָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","וַיֹּ֥אמֶר פַּרְעֹ֖ה אֶל־עֲבָדָ֑יו הֲנִמְצָ֣א כָזֶ֔ה אִ֕ישׁ אֲשֶׁ֛ר ר֥וּחַ אֱלֹהִ֖ים בֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","וַיֹּ֤אמֶר פַּרְעֹה֙ אֶל־יֹוסֵ֔ף אַחֲרֵ֨י הֹודִ֧יעַ אֱלֹהִ֛ים אֹותְךָ֖ אֶת־כָּל־זֹ֑את אֵין־נָבֹ֥ון וְחָכָ֖ם כָּמֹֽוךָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","אַתָּה֙ תִּהְיֶ֣ה עַל־בֵּיתִ֔י וְעַל־פִּ֖יךָ יִשַּׁ֣ק כָּל־עַמִּ֑י רַ֥ק הַכִּסֵּ֖א אֶגְדַּ֥ל מִמֶּֽךָּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","וַיֹּ֥אמֶר פַּרְעֹ֖ה אֶל־יֹוסֵ֑ף רְאֵה֙ נָתַ֣תִּי אֹֽתְךָ֔ עַ֖ל כָּל־אֶ֥רֶץ מִצְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","וַיָּ֨סַר פַּרְעֹ֤ה אֶת־טַבַּעְתֹּו֙ מֵעַ֣ל יָדֹ֔ו וַיִּתֵּ֥ן אֹתָ֖הּ עַל־יַ֣ד יֹוסֵ֑ף וַיַּלְבֵּ֤שׁ אֹתֹו֙ בִּגְדֵי־שֵׁ֔שׁ וַיָּ֛שֶׂם רְבִ֥ד הַזָּהָ֖ב עַל־צַוָּארֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","וַיַּרְכֵּ֣ב אֹתֹ֗ו בְּמִרְכֶּ֤בֶת הַמִּשְׁנֶה֙ אֲשֶׁר־לֹ֔ו וַיִּקְרְא֥וּ לְפָנָ֖יו אַבְרֵ֑ךְ וְנָתֹ֣ון אֹתֹ֔ו עַ֖ל כָּל־אֶ֥רֶץ מִצְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","וַיֹּ֧אמֶר פַּרְעֹ֛ה אֶל־יֹוסֵ֖ף אֲנִ֣י פַרְעֹ֑ה וּבִלְעָדֶ֗יךָ לֹֽא־יָרִ֨ים אִ֧ישׁ אֶת־יָדֹ֛ו וְאֶת־רַגְלֹ֖ו בְּכָל־אֶ֥רֶץ מִצְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","וַיִּקְרָ֨א פַרְעֹ֣ה שֵׁם־יֹוסֵף֮ צָֽפְנַ֣ת פַּעְנֵחַ֒ וַיִּתֶּן־לֹ֣ו אֶת־אָֽסְנַ֗ת בַּת־פֹּ֥וטִי פֶ֛רַע כֹּהֵ֥ן אֹ֖ן לְאִשָּׁ֑ה וַיֵּצֵ֥א יֹוסֵ֖ף עַל־אֶ֥רֶץ מִצְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","וְיֹוסֵף֙ בֶּן־שְׁלֹשִׁ֣ים שָׁנָ֔ה בְּעָמְדֹ֕ו לִפְנֵ֖י פַּרְעֹ֣ה מֶֽלֶךְ־מִצְרָ֑יִם וַיֵּצֵ֤א יֹוסֵף֙ מִלִּפְנֵ֣י פַרְעֹ֔ה וַֽיַּעְבֹ֖ר בְּכָל־אֶ֥רֶץ מִצְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","וַתַּ֣עַשׂ הָאָ֔רֶץ בְּשֶׁ֖בַע שְׁנֵ֣י הַשָּׂבָ֑ע לִקְמָצִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","וַיִּקְבֹּ֞ץ אֶת־כָּל־אֹ֣כֶל ׀ שֶׁ֣בַע שָׁנִ֗ים אֲשֶׁ֤ר הָיוּ֙ בְּאֶ֣רֶץ מִצְרַ֔יִם וַיִּתֶּן־אֹ֖כֶל בֶּעָרִ֑ים אֹ֧כֶל שְׂדֵה־הָעִ֛יר אֲשֶׁ֥ר סְבִיבֹתֶ֖יהָ נָתַ֥ן בְּתֹוכָֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","וַיִּצְבֹּ֨ר יֹוסֵ֥ף בָּ֛ר כְּחֹ֥ול הַיָּ֖ם הַרְבֵּ֣ה מְאֹ֑ד עַ֛ד כִּי־חָדַ֥ל לִסְפֹּ֖ר כִּי־אֵ֥ין מִסְפָּֽר׃ ");
INSERT INTO hbo_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","וּלְיֹוסֵ֤ף יֻלַּד֙ שְׁנֵ֣י בָנִ֔ים בְּטֶ֥רֶם תָּבֹ֖וא שְׁנַ֣ת הָרָעָ֑ב אֲשֶׁ֤ר יָֽלְדָה־לֹּו֙ אָֽסְנַ֔ת בַּת־פֹּ֥וטִי פֶ֖רַע כֹּהֵ֥ן אֹֽון׃ ");
INSERT INTO hbo_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","וַיִּקְרָ֥א יֹוסֵ֛ף אֶת־שֵׁ֥ם הַבְּכֹ֖ור מְנַשֶּׁ֑ה כִּֽי־נַשַּׁ֤נִי אֱלֹהִים֙ אֶת־כָּל־עֲמָלִ֔י וְאֵ֖ת כָּל־בֵּ֥ית אָבִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","וְאֵ֛ת שֵׁ֥ם הַשֵּׁנִ֖י קָרָ֣א אֶפְרָ֑יִם כִּֽי־הִפְרַ֥נִי אֱלֹהִ֖ים בְּאֶ֥רֶץ עָנְיִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","וַתִּכְלֶ֕ינָה שֶׁ֖בַע שְׁנֵ֣י הַשָּׂבָ֑ע אֲשֶׁ֥ר הָיָ֖ה בְּאֶ֥רֶץ מִצְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","וַתְּחִלֶּ֜ינָה שֶׁ֣בַע שְׁנֵ֤י הָרָעָב֙ לָבֹ֔וא כַּאֲשֶׁ֖ר אָמַ֣ר יֹוסֵ֑ף וַיְהִ֤י רָעָב֙ בְּכָל־הָ֣אֲרָצֹ֔ות וּבְכָל־אֶ֥רֶץ מִצְרַ֖יִם הָ֥יָה לָֽחֶם׃ ");
INSERT INTO hbo_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","וַתִּרְעַב֙ כָּל־אֶ֣רֶץ מִצְרַ֔יִם וַיִּצְעַ֥ק הָעָ֛ם אֶל־פַּרְעֹ֖ה לַלָּ֑חֶם וַיֹּ֨אמֶר פַּרְעֹ֤ה לְכָל־מִצְרַ֙יִם֙ לְכ֣וּ אֶל־יֹוסֵ֔ף אֲשֶׁר־יֹאמַ֥ר לָכֶ֖ם תַּעֲשֽׂוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","וְהָרָעָ֣ב הָיָ֔ה עַ֖ל כָּל־פְּנֵ֣י הָאָ֑רֶץ וַיִּפְתַּ֨ח יֹוסֵ֜ף אֶֽת־כָּל־אֲשֶׁ֤ר בָּהֶם֙ וַיִּשְׁבֹּ֣ר לְמִצְרַ֔יִם וַיֶּחֱזַ֥ק הָֽרָעָ֖ב בְּאֶ֥רֶץ מִצְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","וְכָל־הָאָ֙רֶץ֙ בָּ֣אוּ מִצְרַ֔יְמָה לִשְׁבֹּ֖ר אֶל־יֹוסֵ֑ף כִּֽי־חָזַ֥ק הָרָעָ֖ב בְּכָל־הָאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","וַיַּ֣רְא יַעֲקֹ֔ב כִּ֥י יֶשׁ־שֶׁ֖בֶר בְּמִצְרָ֑יִם וַיֹּ֤אמֶר יַעֲקֹב֙ לְבָנָ֔יו לָ֖מָּה תִּתְרָאֽוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","וַיֹּ֕אמֶר הִנֵּ֣ה שָׁמַ֔עְתִּי כִּ֥י יֶשׁ־שֶׁ֖בֶר בְּמִצְרָ֑יִם רְדוּ־שָׁ֙מָּה֙ וְשִׁבְרוּ־לָ֣נוּ מִשָּׁ֔ם וְנִחְיֶ֖ה וְלֹ֥א נָמֽוּת׃ ");
INSERT INTO hbo_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","וַיֵּרְד֥וּ אֲחֵֽי־יֹוסֵ֖ף עֲשָׂרָ֑ה לִשְׁבֹּ֥ר בָּ֖ר מִמִּצְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","וְאֶת־בִּנְיָמִין֙ אֲחִ֣י יֹוסֵ֔ף לֹא־שָׁלַ֥ח יַעֲקֹ֖ב אֶת־אֶחָ֑יו כִּ֣י אָמַ֔ר פֶּן־יִקְרָאֶ֖נּוּ אָסֹֽון׃ ");
INSERT INTO hbo_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","וַיָּבֹ֙אוּ֙ בְּנֵ֣י יִשְׂרָאֵ֔ל לִשְׁבֹּ֖ר בְּתֹ֣וךְ הַבָּאִ֑ים כִּֽי־הָיָ֥ה הָרָעָ֖ב בְּאֶ֥רֶץ כְּנָֽעַן׃ ");
INSERT INTO hbo_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","וְיֹוסֵ֗ף ה֚וּא הַשַּׁלִּ֣יט עַל־הָאָ֔רֶץ ה֥וּא הַמַּשְׁבִּ֖יר לְכָל־עַ֣ם הָאָ֑רֶץ וַיָּבֹ֙אוּ֙ אֲחֵ֣י יֹוסֵ֔ף וַיִּשְׁתַּֽחֲווּ־לֹ֥ו אַפַּ֖יִם אָֽרְצָה׃ ");
INSERT INTO hbo_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","וַיַּ֥רְא יֹוסֵ֛ף אֶת־אֶחָ֖יו וַיַּכִּרֵ֑ם וַיִּתְנַכֵּ֨ר אֲלֵיהֶ֜ם וַיְדַבֵּ֧ר אִתָּ֣ם קָשֹׁ֗ות וַיֹּ֤אמֶר אֲלֵהֶם֙ מֵאַ֣יִן בָּאתֶ֔ם וַיֹּ֣אמְר֔וּ מֵאֶ֥רֶץ כְּנַ֖עַן לִשְׁבָּר־אֹֽכֶל׃ ");
INSERT INTO hbo_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","וַיַּכֵּ֥ר יֹוסֵ֖ף אֶת־אֶחָ֑יו וְהֵ֖ם לֹ֥א הִכִּרֻֽהוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","וַיִּזְכֹּ֣ר יֹוסֵ֔ף אֵ֚ת הַחֲלֹמֹ֔ות אֲשֶׁ֥ר חָלַ֖ם לָהֶ֑ם וַיֹּ֤אמֶר אֲלֵהֶם֙ מְרַגְּלִ֣ים אַתֶּ֔ם לִרְאֹ֛ות אֶת־עֶרְוַ֥ת הָאָ֖רֶץ בָּאתֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","וַיֹּאמְר֥וּ אֵלָ֖יו לֹ֣א אֲדֹנִ֑י וַעֲבָדֶ֥יךָ בָּ֖אוּ לִשְׁבָּר־אֹֽכֶל׃ ");
INSERT INTO hbo_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","כֻּלָּ֕נוּ בְּנֵ֥י אִישׁ־אֶחָ֖ד נָ֑חְנוּ כֵּנִ֣ים אֲנַ֔חְנוּ לֹא־הָי֥וּ עֲבָדֶ֖יךָ מְרַגְּלִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","וַיֹּ֖אמֶר אֲלֵהֶ֑ם לֹ֕א כִּֽי־עֶרְוַ֥ת הָאָ֖רֶץ בָּאתֶ֥ם לִרְאֹֽות׃ ");
INSERT INTO hbo_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","וַיֹּאמְר֗וּ שְׁנֵ֣ים עָשָׂר֩ עֲבָדֶ֨יךָ אַחִ֧ים ׀ אֲנַ֛חְנוּ בְּנֵ֥י אִישׁ־אֶחָ֖ד בְּאֶ֣רֶץ כְּנָ֑עַן וְהִנֵּ֨ה הַקָּטֹ֤ן אֶת־אָבִ֙ינוּ֙ הַיֹּ֔ום וְהָאֶחָ֖ד אֵינֶֽנּוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","וַיֹּ֥אמֶר אֲלֵהֶ֖ם יֹוסֵ֑ף ה֗וּא אֲשֶׁ֨ר דִּבַּ֧רְתִּי אֲלֵכֶ֛ם לֵאמֹ֖ר מְרַגְּלִ֥ים אַתֶּֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","בְּזֹ֖את תִּבָּחֵ֑נוּ חֵ֤י פַרְעֹה֙ אִם־תֵּצְא֣וּ מִזֶּ֔ה כִּ֧י אִם־בְּבֹ֛וא אֲחִיכֶ֥ם הַקָּטֹ֖ן הֵֽנָּה׃ ");
INSERT INTO hbo_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","שִׁלְח֨וּ מִכֶּ֣ם אֶחָד֮ וְיִקַּ֣ח אֶת־אֲחִיכֶם֒ וְאַתֶּם֙ הֵאָ֣סְר֔וּ וְיִבָּֽחֲנוּ֙ דִּבְרֵיכֶ֔ם הַֽאֱמֶ֖ת אִתְּכֶ֑ם וְאִם־לֹ֕א חֵ֣י פַרְעֹ֔ה כִּ֥י מְרַגְּלִ֖ים אַתֶּֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","וַיֶּאֱסֹ֥ף אֹתָ֛ם אֶל־מִשְׁמָ֖ר שְׁלֹ֥שֶׁת יָמִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","וַיֹּ֨אמֶר אֲלֵהֶ֤ם יֹוסֵף֙ בַּיֹּ֣ום הַשְּׁלִישִׁ֔י זֹ֥את עֲשׂ֖וּ וִֽחְי֑וּ אֶת־הָאֱלֹהִ֖ים אֲנִ֥י יָרֵֽא׃ ");
INSERT INTO hbo_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","אִם־כֵּנִ֣ים אַתֶּ֔ם אֲחִיכֶ֣ם אֶחָ֔ד יֵאָסֵ֖ר בְּבֵ֣ית מִשְׁמַרְכֶ֑ם וְאַתֶּם֙ לְכ֣וּ הָבִ֔יאוּ שֶׁ֖בֶר רַעֲבֹ֥ון בָּתֵּיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","וְאֶת־אֲחִיכֶ֤ם הַקָּטֹן֙ תָּבִ֣יאוּ אֵלַ֔י וְיֵאָמְנ֥וּ דִבְרֵיכֶ֖ם וְלֹ֣א תָמ֑וּתוּ וַיַּעֲשׂוּ־כֵֽן׃ ");
INSERT INTO hbo_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","וַיֹּאמְר֞וּ אִ֣ישׁ אֶל־אָחִ֗יו אֲבָל֮ אֲשֵׁמִ֣ים ׀ אֲנַחְנוּ֮ עַל־אָחִינוּ֒ אֲשֶׁ֨ר רָאִ֜ינוּ צָרַ֥ת נַפְשֹׁ֛ו בְּהִתְחַֽנְנֹ֥ו אֵלֵ֖ינוּ וְלֹ֣א שָׁמָ֑עְנוּ עַל־כֵּן֙ בָּ֣אָה אֵלֵ֔ינוּ הַצָּרָ֖ה הַזֹּֽאת׃ ");
INSERT INTO hbo_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","וַיַּעַן֩ רְאוּבֵ֨ן אֹתָ֜ם לֵאמֹ֗ר הֲלֹוא֩ אָמַ֨רְתִּי אֲלֵיכֶ֧ם ׀ לֵאמֹ֛ר אַל־תֶּחֶטְא֥וּ בַיֶּ֖לֶד וְלֹ֣א שְׁמַעְתֶּ֑ם וְגַם־דָּמֹ֖ו הִנֵּ֥ה נִדְרָֽשׁ׃ ");
INSERT INTO hbo_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","וְהֵם֙ לֹ֣א יֽ͏ָדְע֔וּ כִּ֥י שֹׁמֵ֖עַ יֹוסֵ֑ף כִּ֥י הַמֵּלִ֖יץ בֵּינֹתָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","וַיִּסֹּ֥ב מֵֽעֲלֵיהֶ֖ם וַיֵּ֑בְךְּ וַיָּ֤שָׁב אֲלֵהֶם֙ וַיְדַבֵּ֣ר אֲלֵהֶ֔ם וַיִּקַּ֤ח מֵֽאִתָּם֙ אֶת־שִׁמְעֹ֔ון וַיֶּאֱסֹ֥ר אֹתֹ֖ו לְעֵינֵיהֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","וַיְצַ֣ו יֹוסֵ֗ף וַיְמַלְא֣וּ אֶת־כְּלֵיהֶם֮ בָּר֒ וּלְהָשִׁ֤יב כַּסְפֵּיהֶם֙ אִ֣ישׁ אֶל־שַׂקֹּ֔ו וְלָתֵ֥ת לָהֶ֛ם צֵדָ֖ה לַדָּ֑רֶךְ וַיַּ֥עַשׂ לָהֶ֖ם כֵּֽן׃ ");
INSERT INTO hbo_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","וַיִּשְׂא֥וּ אֶת־שִׁבְרָ֖ם עַל־חֲמֹרֵיהֶ֑ם וַיֵּלְכ֖וּ מִשָּֽׁם׃ ");
INSERT INTO hbo_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","וַיִּפְתַּ֨ח הָאֶחָ֜ד אֶת־שַׂקֹּ֗ו לָתֵ֥ת מִסְפֹּ֛וא לַחֲמֹרֹ֖ו בַּמָּלֹ֑ון וַיַּרְא֙ אֶת־כַּסְפֹּ֔ו וְהִנֵּה־ה֖וּא בְּפִ֥י אַמְתַּחְתֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","וַיֹּ֤אמֶר אֶל־אֶחָיו֙ הוּשַׁ֣ב כַּסְפִּ֔י וְגַ֖ם הִנֵּ֣ה בְאַמְתַּחְתִּ֑י וַיֵּצֵ֣א לִבָּ֗ם וַיֶּֽחֶרְד֞וּ אִ֤ישׁ אֶל־אָחִיו֙ לֵאמֹ֔ר מַה־זֹּ֛את עָשָׂ֥ה אֱלֹהִ֖ים לָֽנוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","וַיָּבֹ֛אוּ אֶל־יַעֲקֹ֥ב אֲבִיהֶ֖ם אַ֣רְצָה כְּנָ֑עַן וַיַּגִּ֣ידוּ לֹ֔ו אֵ֛ת כָּל־הַקֹּרֹ֥ת אֹתָ֖ם לֵאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","דִּ֠בֶּר הָאִ֨ישׁ אֲדֹנֵ֥י הָאָ֛רֶץ אִתָּ֖נוּ קָשֹׁ֑ות וַיִּתֵּ֣ן אֹתָ֔נוּ כִּֽמְרַגְּלִ֖ים אֶת־הָאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","וַנֹּ֥אמֶר אֵלָ֖יו כֵּנִ֣ים אֲנָ֑חְנוּ לֹ֥א הָיִ֖ינוּ מְרַגְּלִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","שְׁנֵים־עָשָׂ֥ר אֲנַ֛חְנוּ אַחִ֖ים בְּנֵ֣י אָבִ֑ינוּ הָאֶחָ֣ד אֵינֶ֔נּוּ וְהַקָּטֹ֥ן הַיֹּ֛ום אֶת־אָבִ֖ינוּ בְּאֶ֥רֶץ כְּנָֽעַן׃ ");
INSERT INTO hbo_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","וַיֹּ֣אמֶר אֵלֵ֗ינוּ הָאִישׁ֙ אֲדֹנֵ֣י הָאָ֔רֶץ בְּזֹ֣את אֵדַ֔ע כִּ֥י כֵנִ֖ים אַתֶּ֑ם אֲחִיכֶ֤ם הָֽאֶחָד֙ הַנִּ֣יחוּ אִתִּ֔י וְאֶת־רַעֲבֹ֥ון בָּתֵּיכֶ֖ם קְח֥וּ וָלֵֽכוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","וְ֠הָבִיאוּ אֶת־אֲחִיכֶ֣ם הַקָּטֹן֮ אֵלַי֒ וְאֵֽדְעָ֗ה כִּ֣י לֹ֤א מְרַגְּלִים֙ אַתֶּ֔ם כִּ֥י כֵנִ֖ים אַתֶּ֑ם אֶת־אֲחִיכֶם֙ אֶתֵּ֣ן לָכֶ֔ם וְאֶת־הָאָ֖רֶץ תִּסְחָֽרוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","וַיְהִ֗י הֵ֚ם מְרִיקִ֣ים שַׂקֵּיהֶ֔ם וְהִנֵּה־אִ֥ישׁ צְרֹור־כַּסְפֹּ֖ו בְּשַׂקֹּ֑ו וַיִּרְא֞וּ אֶת־צְרֹרֹ֧ות כַּסְפֵּיהֶ֛ם הֵ֥מָּה וַאֲבִיהֶ֖ם וַיִּירָֽאוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","וַיֹּ֤אמֶר אֲלֵהֶם֙ יַעֲקֹ֣ב אֲבִיהֶ֔ם אֹתִ֖י שִׁכַּלְתֶּ֑ם יֹוסֵ֤ף אֵינֶ֙נּוּ֙ וְשִׁמְעֹ֣ון אֵינֶ֔נּוּ וְאֶת־בִּנְיָמִ֣ן תִּקָּ֔חוּ עָלַ֖י הָי֥וּ כֻלָּֽנָה׃ ");
INSERT INTO hbo_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","וַיֹּ֤אמֶר רְאוּבֵן֙ אֶל־אָבִ֣יו לֵאמֹ֔ר אֶת־שְׁנֵ֤י בָנַי֙ תָּמִ֔ית אִם־לֹ֥א אֲבִיאֶ֖נּוּ אֵלֶ֑יךָ תְּנָ֤ה אֹתֹו֙ עַל־יָדִ֔י וַאֲנִ֖י אֲשִׁיבֶ֥נּוּ אֵלֶֽיךָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","וַיֹּ֕אמֶר לֹֽא־יֵרֵ֥ד בְּנִ֖י עִמָּכֶ֑ם כִּֽי־אָחִ֨יו מֵ֜ת וְה֧וּא לְבַדֹּ֣ו נִשְׁאָ֗ר וּקְרָאָ֤הוּ אָסֹון֙ בַּדֶּ֙רֶךְ֙ אֲשֶׁ֣ר תֵּֽלְכוּ־בָ֔הּ וְהֹורַדְתֶּ֧ם אֶת־שֵׂיבָתִ֛י בְּיָגֹ֖ון שְׁאֹֽולָה׃ ");
INSERT INTO hbo_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","וְהָרָעָ֖ב כָּבֵ֥ד בָּאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","וַיְהִ֗י כַּאֲשֶׁ֤ר כִּלּוּ֙ לֶאֱכֹ֣ל אֶת־הַשֶּׁ֔בֶר אֲשֶׁ֥ר הֵבִ֖יאוּ מִמִּצְרָ֑יִם וַיֹּ֤אמֶר אֲלֵיהֶם֙ אֲבִיהֶ֔ם שֻׁ֖בוּ שִׁבְרוּ־לָ֥נוּ מְעַט־אֹֽכֶל׃ ");
INSERT INTO hbo_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","וַיֹּ֧אמֶר אֵלָ֛יו יְהוּדָ֖ה לֵאמֹ֑ר הָעֵ֣ד הֵעִד֩ בָּ֨נוּ הָאִ֤ישׁ לֵאמֹר֙ לֹֽא־תִרְא֣וּ פָנַ֔י בִּלְתִּ֖י אֲחִיכֶ֥ם אִתְּכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","אִם־יֶשְׁךָ֛ מְשַׁלֵּ֥חַ אֶת־אָחִ֖ינוּ אִתָּ֑נוּ נֵרְדָ֕ה וְנִשְׁבְּרָ֥ה לְךָ֖ אֹֽכֶל׃ ");
INSERT INTO hbo_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","וְאִם־אֵינְךָ֥ מְשַׁלֵּ֖חַ לֹ֣א נֵרֵ֑ד כִּֽי־הָאִ֞ישׁ אָמַ֤ר אֵלֵ֙ינוּ֙ לֹֽא־תִרְא֣וּ פָנַ֔י בִּלְתִּ֖י אֲחִיכֶ֥ם אִתְּכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","וַיֹּ֙אמֶר֙ יִשְׂרָאֵ֔ל לָמָ֥ה הֲרֵעֹתֶ֖ם לִ֑י לְהַגִּ֣יד לָאִ֔ישׁ הַעֹ֥וד לָכֶ֖ם אָֽח׃ ");
INSERT INTO hbo_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","וַיֹּאמְר֡וּ שָׁאֹ֣ול שָֽׁאַל־הָ֠אִישׁ לָ֣נוּ וּלְמֹֽולַדְתֵּ֜נוּ לֵאמֹ֗ר הַעֹ֨וד אֲבִיכֶ֥ם חַי֙ הֲיֵ֣שׁ לָכֶ֣ם אָ֔ח וַנַ֨גֶּד־לֹ֔ו עַל־פִּ֖י הַדְּבָרִ֣ים הָאֵ֑לֶּה הֲיָדֹ֣ועַ נֵדַ֔ע כִּ֣י יֹאמַ֔ר הֹורִ֖ידוּ אֶת־אֲחִיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","וַיֹּ֨אמֶר יְהוּדָ֜ה אֶל־יִשְׂרָאֵ֣ל אָבִ֗יו שִׁלְחָ֥ה הַנַּ֛עַר אִתִּ֖י וְנָק֣וּמָה וְנֵלֵ֑כָה וְנִֽחְיֶה֙ וְלֹ֣א נָמ֔וּת גַּם־אֲנַ֥חְנוּ גַם־אַתָּ֖ה גַּם־טַפֵּֽנוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","אָֽנֹכִי֙ אֽ͏ֶעֶרְבֶ֔נּוּ מִיָּדִ֖י תְּבַקְשֶׁ֑נּוּ אִם־לֹ֨א הֲבִיאֹתִ֤יו אֵלֶ֙יךָ֙ וְהִצַּגְתִּ֣יו לְפָנֶ֔יךָ וְחָטָ֥אתִֽי לְךָ֖ כָּל־הַיָּמִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","כִּ֖י לוּלֵ֣א הִתְמַהְמָ֑הְנוּ כִּֽי־עַתָּ֥ה שַׁ֖בְנוּ זֶ֥ה פַעֲמָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","וַיֹּ֨אמֶר אֲלֵהֶ֜ם יִשְׂרָאֵ֣ל אֲבִיהֶ֗ם אִם־כֵּ֣ן ׀ אֵפֹוא֮ זֹ֣את עֲשׂוּ֒ קְח֞וּ מִזִּמְרַ֤ת הָאָ֙רֶץ֙ בִּכְלֵיכֶ֔ם וְהֹורִ֥ידוּ לָאִ֖ישׁ מִנְחָ֑ה מְעַ֤ט צֳרִי֙ וּמְעַ֣ט דְּבַ֔שׁ נְכֹ֣את וָלֹ֔ט בָּטְנִ֖ים וּשְׁקֵדִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","וְכֶ֥סֶף מִשְׁנֶ֖ה קְח֣וּ בְיֶדְכֶ֑ם וְאֶת־הַכֶּ֜סֶף הַמּוּשָׁ֨ב בְּפִ֤י אַמְתְּחֹֽתֵיכֶם֙ תָּשִׁ֣יבוּ בְיֶדְכֶ֔ם אוּלַ֥י מִשְׁגֶּ֖ה הֽוּא׃ ");
INSERT INTO hbo_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","וְאֶת־אֲחִיכֶ֖ם קָ֑חוּ וְק֖וּמוּ שׁ֥וּבוּ אֶל־הָאִֽישׁ׃ ");
INSERT INTO hbo_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","וְאֵ֣ל שַׁדַּ֗י יִתֵּ֨ן לָכֶ֤ם רַחֲמִים֙ לִפְנֵ֣י הָאִ֔ישׁ וְשִׁלַּ֥ח לָכֶ֛ם אֶת־אֲחִיכֶ֥ם אַחֵ֖ר וְאֶת־בִּנְיָמִ֑ין וַאֲנִ֕י כַּאֲשֶׁ֥ר שָׁכֹ֖לְתִּי שָׁכָֽלְתִּי׃ ");
INSERT INTO hbo_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","וַיִּקְח֤וּ הָֽאֲנָשִׁים֙ אֶת־הַמִּנְחָ֣ה הַזֹּ֔את וּמִשְׁנֶה־כֶּ֛סֶף לָקְח֥וּ בְיָדָ֖ם וְאֶת־בִּנְיָמִ֑ן וַיָּקֻ֙מוּ֙ וַיֵּרְד֣וּ מִצְרַ֔יִם וַיַּֽעַמְד֖וּ לִפְנֵ֥י יֹוסֵֽף׃ ");
INSERT INTO hbo_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","וַיַּ֨רְא יֹוסֵ֣ף אִתָּם֮ אֶת־בִּנְיָמִין֒ וַיֹּ֙אמֶר֙ לַֽאֲשֶׁ֣ר עַל־בֵּיתֹ֔ו הָבֵ֥א אֶת־הָאֲנָשִׁ֖ים הַבָּ֑יְתָה וּטְבֹ֤חַ טֶ֙בַח֙ וְהָכֵ֔ן כִּ֥י אִתִּ֛י יֹאכְל֥וּ הָאֲנָשִׁ֖ים בַּֽצָּהֳרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","וַיַּ֣עַשׂ הָאִ֔ישׁ כַּֽאֲשֶׁ֖ר אָמַ֣ר יֹוסֵ֑ף וַיָּבֵ֥א הָאִ֛ישׁ אֶת־הָאֲנָשִׁ֖ים בֵּ֥יתָה יֹוסֵֽף׃ ");
INSERT INTO hbo_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","וַיִּֽירְא֣וּ הָֽאֲנָשִׁ֗ים כִּ֣י הֽוּבְאוּ֮ בֵּ֣ית יֹוסֵף֒ וַיֹּאמְר֗וּ עַל־דְּבַ֤ר הַכֶּ֙סֶף֙ הַשָּׁ֤ב בְּאַמְתְּחֹתֵ֙ינוּ֙ בַּתְּחִלָּ֔ה אֲנַ֖חְנוּ מֽוּבָאִ֑ים לְהִתְגֹּלֵ֤ל עָלֵ֙ינוּ֙ וּלְהִתְנַפֵּ֣ל עָלֵ֔ינוּ וְלָקַ֧חַת אֹתָ֛נוּ לַעֲבָדִ֖ים וְאֶת־חֲמֹרֵֽינוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","וַֽיִּגְּשׁוּ֙ אֶל־הָאִ֔ישׁ אֲשֶׁ֖ר עַל־בֵּ֣ית יֹוסֵ֑ף וַיְדַבְּר֥וּ אֵלָ֖יו פֶּ֥תַח הַבָּֽיִת׃ ");
INSERT INTO hbo_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","וַיֹּאמְר֖וּ בִּ֣י אֲדֹנִ֑י יָרֹ֥ד יָרַ֛דְנוּ בַּתְּחִלָּ֖ה לִשְׁבָּר־אֹֽכֶל׃ ");
INSERT INTO hbo_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","וַֽיְהִ֞י כִּי־בָ֣אנוּ אֶל־הַמָּלֹ֗ון וַֽנִּפְתְּחָה֙ אֶת־אַמְתְּחֹתֵ֔ינוּ וְהִנֵּ֤ה כֶֽסֶף־אִישׁ֙ בְּפִ֣י אַמְתַּחְתֹּ֔ו כַּסְפֵּ֖נוּ בְּמִשְׁקָלֹ֑ו וַנָּ֥שֶׁב אֹתֹ֖ו בְּיָדֵֽנוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","וְכֶ֧סֶף אַחֵ֛ר הֹורַ֥דְנוּ בְיָדֵ֖נוּ לִשְׁבָּר־אֹ֑כֶל לֹ֣א יָדַ֔עְנוּ מִי־שָׂ֥ם כַּסְפֵּ֖נוּ בְּאַמְתְּחֹתֵֽינוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","וַיֹּאמֶר֩ שָׁלֹ֨ום לָכֶ֜ם אַל־תִּירָ֗אוּ אֱלֹ֨הֵיכֶ֜ם וֽ͏ֵאלֹהֵ֤י אֲבִיכֶם֙ נָתַ֨ן לָכֶ֤ם מַטְמֹון֙ בְּאַמְתְּחֹ֣תֵיכֶ֔ם כַּסְפְּכֶ֖ם בָּ֣א אֵלָ֑י וַיֹּוצֵ֥א אֲלֵהֶ֖ם אֶת־שִׁמְעֹֽון׃ ");
INSERT INTO hbo_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","וַיָּבֵ֥א הָאִ֛ישׁ אֶת־הָאֲנָשִׁ֖ים בֵּ֣יתָה יֹוסֵ֑ף וַיִּתֶּן־מַ֙יִם֙ וַיִּרְחֲצ֣וּ רַגְלֵיהֶ֔ם וַיִּתֵּ֥ן מִסְפֹּ֖וא לַחֲמֹֽרֵיהֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","וַיָּכִ֙ינוּ֙ אֶת־הַמִּנְחָ֔ה עַד־בֹּ֥וא יֹוסֵ֖ף בַּֽצָּהֳרָ֑יִם כִּ֣י שָֽׁמְע֔וּ כִּי־שָׁ֖ם יֹ֥אכְלוּ לָֽחֶם׃ ");
INSERT INTO hbo_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","וַיָּבֹ֤א יֹוסֵף֙ הַבַּ֔יְתָה וַיָּבִ֥יאּוּ לֹ֛ו אֶת־הַמִּנְחָ֥ה אֲשֶׁר־בְּיָדָ֖ם הַבָּ֑יְתָה וַיִּשְׁתַּחֲווּ־לֹ֖ו אָֽרְצָה׃ ");
INSERT INTO hbo_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","וַיִּשְׁאַ֤ל לָהֶם֙ לְשָׁלֹ֔ום וַיֹּ֗אמֶר הֲשָׁלֹ֛ום אֲבִיכֶ֥ם הַזָּקֵ֖ן אֲשֶׁ֣ר אֲמַרְתֶּ֑ם הַעֹודֶ֖נּוּ חָֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","וַיֹּאמְר֗וּ שָׁלֹ֛ום לְעַבְדְּךָ֥ לְאָבִ֖ינוּ עֹודֶ֣נּוּ חָ֑י וַֽיִּקְּד֖וּ *וַיִּשְׁתַּחוּ (וַיִּֽשְׁתַּחֲוּֽוּ)׃ ");
INSERT INTO hbo_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","וַיִּשָּׂ֣א עֵינָ֗יו וַיַּ֞רְא אֶת־בִּנְיָמִ֣ין אָחִיו֮ בֶּן־אִמֹּו֒ וַיֹּ֗אמֶר הֲזֶה֙ אֲחִיכֶ֣ם הַקָּטֹ֔ן אֲשֶׁ֥ר אֲמַרְתֶּ֖ם אֵלָ֑י וַיֹּאמַ֕ר אֱלֹהִ֥ים יָחְנְךָ֖ בְּנִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","וַיְמַהֵ֣ר יֹוסֵ֗ף כִּֽי־נִכְמְר֤וּ רַחֲמָיו֙ אֶל־אָחִ֔יו וַיְבַקֵּ֖שׁ לִבְכֹּ֑ות וַיָּבֹ֥א הַחַ֖דְרָה וַיֵּ֥בְךְּ שָֽׁמָּה׃ ");
INSERT INTO hbo_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","וַיִּרְחַ֥ץ פָּנָ֖יו וַיֵּצֵ֑א וַיִּ֨תְאַפַּ֔ק וַיֹּ֖אמֶר שִׂ֥ימוּ לָֽחֶם׃ ");
INSERT INTO hbo_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","וַיָּשִׂ֥ימוּ לֹ֛ו לְבַדֹּ֖ו וְלָהֶ֣ם לְבַדָּ֑ם וְלַמִּצְרִ֞ים הָאֹכְלִ֤ים אִתֹּו֙ לְבַדָּ֔ם כִּי֩ לֹ֨א יוּכְל֜וּן הַמִּצְרִ֗ים לֶאֱכֹ֤ל אֶת־הָֽעִבְרִים֙ לֶ֔חֶם כִּי־תֹועֵבָ֥ה הִ֖וא לְמִצְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","וַיֵּשְׁב֣וּ לְפָנָ֔יו הַבְּכֹר֙ כִּבְכֹ֣רָתֹ֔ו וְהַצָּעִ֖יר כִּצְעִרָתֹ֑ו וַיִּתְמְה֥וּ הָאֲנָשִׁ֖ים אִ֥ישׁ אֶל־רֵעֵֽהוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","וַיִּשָּׂ֨א מַשְׂאֹ֜ת מֵאֵ֣ת פָּנָיו֮ אֲלֵהֶם֒ וַתֵּ֜רֶב מַשְׂאַ֧ת בִּנְיָמִ֛ן מִמַּשְׂאֹ֥ת כֻּלָּ֖ם חָמֵ֣שׁ יָדֹ֑ות וַיִּשְׁתּ֥וּ וַֽיִּשְׁכְּר֖וּ עִמֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","וַיְצַ֞ו אֶת־אֲשֶׁ֣ר עַל־בֵּיתֹו֮ לֵאמֹר֒ מַלֵּ֞א אֶת־אַמְתְּחֹ֤ת הָֽאֲנָשִׁים֙ אֹ֔כֶל כַּאֲשֶׁ֥ר יוּכְל֖וּן שְׂאֵ֑ת וְשִׂ֥ים כֶּֽסֶף־אִ֖ישׁ בְּפִ֥י אַמְתַּחְתֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","וְאֶת־גְּבִיעִ֞י גְּבִ֣יעַ הַכֶּ֗סֶף תָּשִׂים֙ בְּפִי֙ אַמְתַּ֣חַת הַקָּטֹ֔ן וְאֵ֖ת כֶּ֣סֶף שִׁבְרֹ֑ו וַיַּ֕עַשׂ כִּדְבַ֥ר יֹוסֵ֖ף אֲשֶׁ֥ר דִּבֵּֽר׃ ");
INSERT INTO hbo_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","הַבֹּ֖קֶר אֹ֑ור וְהָאֲנָשִׁ֣ים שֻׁלְּח֔וּ הֵ֖מָּה וַחֲמֹרֵיהֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","הֵ֠ם יָֽצְא֣וּ אֶת־הָעִיר֮ לֹ֣א הִרְחִיקוּ֒ וְיֹוסֵ֤ף אָמַר֙ לַֽאֲשֶׁ֣ר עַל־בֵּיתֹ֔ו ק֥וּם רְדֹ֖ף אַחֲרֵ֣י הָֽאֲנָשִׁ֑ים וְהִשַּׂגְתָּם֙ וְאָמַרְתָּ֣ אֲלֵהֶ֔ם לָ֛מָּה שִׁלַּמְתֶּ֥ם רָעָ֖ה תַּ֥חַת טֹובָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","הֲלֹ֣וא זֶ֗ה אֲשֶׁ֨ר יִשְׁתֶּ֤ה אֲדֹנִי֙ בֹּ֔ו וְה֕וּא נַחֵ֥שׁ יְנַחֵ֖שׁ בֹּ֑ו הֲרֵעֹתֶ֖ם אֲשֶׁ֥ר עֲשִׂיתֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","וַֽיַּשִּׂגֵ֑ם וַיְדַבֵּ֣ר אֲלֵהֶ֔ם אֶת־הַדְּבָרִ֖ים הָאֵֽלֶּה׃ ");
INSERT INTO hbo_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","וַיֹּאמְר֣וּ אֵלָ֔יו לָ֚מָּה יְדַבֵּ֣ר אֲדֹנִ֔י כַּדְּבָרִ֖ים הָאֵ֑לֶּה חָלִ֙ילָה֙ לַעֲבָדֶ֔יךָ מֵעֲשֹׂ֖ות כַּדָּבָ֥ר הַזֶּֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","הֵ֣ן כֶּ֗סֶף אֲשֶׁ֤ר מָצָ֙אנוּ֙ בְּפִ֣י אַמְתְּחֹתֵ֔ינוּ הֱשִׁיבֹ֥נוּ אֵלֶ֖יךָ מֵאֶ֣רֶץ כְּנָ֑עַן וְאֵ֗יךְ נִגְנֹב֙ מִבֵּ֣ית אֲדֹנֶ֔יךָ כֶּ֖סֶף אֹ֥ו זָהָֽב׃ ");
INSERT INTO hbo_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","אֲשֶׁ֨ר יִמָּצֵ֥א אִתֹּ֛ו מֵעֲבָדֶ֖יךָ וָמֵ֑ת וְגַם־אֲנַ֕חְנוּ נִֽהְיֶ֥ה לַֽאדֹנִ֖י לַעֲבָדִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","וַיֹּ֕אמֶר גַּם־עַתָּ֥ה כְדִבְרֵיכֶ֖ם כֶּן־ה֑וּא אֲשֶׁ֨ר יִמָּצֵ֤א אִתֹּו֙ יִהְיֶה־לִּ֣י עָ֔בֶד וְאַתֶּ֖ם תִּהְי֥וּ נְקִיִּֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","וֽ͏ַיְמַהֲר֗וּ וַיֹּורִ֛דוּ אִ֥ישׁ אֶת־אַמְתַּחְתֹּ֖ו אָ֑רְצָה וַֽיִּפְתְּח֖וּ אִ֥ישׁ אַמְתַּחְתֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","וַיְחַפֵּ֕שׂ בַּגָּדֹ֣ול הֵחֵ֔ל וּבַקָּטֹ֖ן כִּלָּ֑ה וַיִּמָּצֵא֙ הַגָּבִ֔יעַ בְּאַמְתַּ֖חַת בִּנְיָמִֽן׃ ");
INSERT INTO hbo_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","וֽ͏ַיִּקְרְע֖וּ שִׂמְלֹתָ֑ם וַֽיַּעֲמֹס֙ אִ֣ישׁ עַל־חֲמֹרֹ֔ו וַיָּשֻׁ֖בוּ הָעִֽירָה׃ ");
INSERT INTO hbo_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","וַיָּבֹ֨א יְהוּדָ֤ה וְאֶחָיו֙ בֵּ֣יתָה יֹוסֵ֔ף וְה֖וּא עֹודֶ֣נּוּ שָׁ֑ם וַיִּפְּל֥וּ לְפָנָ֖יו אָֽרְצָה׃ ");
INSERT INTO hbo_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","וַיֹּ֤אמֶר לָהֶם֙ יֹוסֵ֔ף מָֽה־הַמַּעֲשֶׂ֥ה הַזֶּ֖ה אֲשֶׁ֣ר עֲשִׂיתֶ֑ם הֲלֹ֣וא יְדַעְתֶּ֔ם כִּֽי־נַחֵ֧שׁ יְנַחֵ֛שׁ אִ֖ישׁ אֲשֶׁ֥ר כָּמֹֽנִי׃ ");
INSERT INTO hbo_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","וַיֹּ֣אמֶר יְהוּדָ֗ה מַה־נֹּאמַר֙ לַֽאדֹנִ֔י מַה־נְּדַבֵּ֖ר וּמַה־נִּצְטַדָּ֑ק הָאֱלֹהִ֗ים מָצָא֙ אֶת־עֲוֹ֣ן עֲבָדֶ֔יךָ הִנֶּנּ֤וּ עֲבָדִים֙ לַֽאדֹנִ֔י גַּם־אֲנַ֕חְנוּ גַּ֛ם אֲשֶׁר־נִמְצָ֥א הַגָּבִ֖יעַ בְּיָדֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","וַיֹּ֕אמֶר חָלִ֣ילָה לִּ֔י מֵעֲשֹׂ֖ות זֹ֑את הָאִ֡ישׁ אֲשֶׁר֩ נִמְצָ֨א הַגָּבִ֜יעַ בְּיָדֹ֗ו ה֚וּא יִהְיֶה־לִּ֣י עָ֔בֶד וְאַתֶּ֕ם עֲל֥וּ לְשָׁלֹ֖ום אֶל־אֲבִיכֶֽם׃ פ ");
INSERT INTO hbo_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","וַיִּגַּ֨שׁ אֵלָ֜יו יְהוּדָ֗ה וַיֹּאמֶר֮ בִּ֣י אֲדֹנִי֒ יְדַבֶּר־נָ֨א עַבְדְּךָ֤ דָבָר֙ בְּאָזְנֵ֣י אֲדֹנִ֔י וְאַל־יִ֥חַר אַפְּךָ֖ בְּעַבְדֶּ֑ךָ כִּ֥י כָמֹ֖וךָ כְּפַרְעֹֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","אֲדֹנִ֣י שָׁאַ֔ל אֶת־עֲבָדָ֖יו לֵאמֹ֑ר הֲיֵשׁ־לָכֶ֥ם אָ֖ב אֹו־אָֽח׃ ");
INSERT INTO hbo_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","וַנֹּ֙אמֶר֙ אֶל־אֲדֹנִ֔י יֶשׁ־לָ֙נוּ֙ אָ֣ב זָקֵ֔ן וְיֶ֥לֶד זְקֻנִ֖ים קָטָ֑ן וְאָחִ֨יו מֵ֜ת וַיִּוָּתֵ֨ר ה֧וּא לְבַדֹּ֛ו לְאִמֹּ֖ו וְאָבִ֥יו אֲהֵבֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","וַתֹּ֙אמֶר֙ אֶל־עֲבָדֶ֔יךָ הֹורִדֻ֖הוּ אֵלָ֑י וְאָשִׂ֥ימָה עֵינִ֖י עָלָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","וַנֹּ֙אמֶר֙ אֶל־אֲדֹנִ֔י לֹא־יוּכַ֥ל הַנַּ֖עַר לַעֲזֹ֣ב אֶת־אָבִ֑יו וְעָזַ֥ב אֶת־אָבִ֖יו וָמֵֽת׃ ");
INSERT INTO hbo_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","וַתֹּ֙אמֶר֙ אֶל־עֲבָדֶ֔יךָ אִם־לֹ֥א יֵרֵ֛ד אֲחִיכֶ֥ם הַקָּטֹ֖ן אִתְּכֶ֑ם לֹ֥א תֹסִפ֖וּן לִרְאֹ֥ות פָּנָֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","וַיְהִי֙ כִּ֣י עָלִ֔ינוּ אֶֽל־עַבְדְּךָ֖ אָבִ֑י וַנַּ֨גֶּד־לֹ֔ו אֵ֖ת דִּבְרֵ֥י אֲדֹנִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","וַיֹּ֖אמֶר אָבִ֑ינוּ שֻׁ֖בוּ שִׁבְרוּ־לָ֥נוּ מְעַט־אֹֽכֶל׃ ");
INSERT INTO hbo_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","וַנֹּ֕אמֶר לֹ֥א נוּכַ֖ל לָרֶ֑דֶת אִם־יֵשׁ֩ אָחִ֨ינוּ הַקָּטֹ֤ן אִתָּ֙נוּ֙ וְיָרַ֔דְנוּ כִּי־לֹ֣א נוּכַ֗ל לִרְאֹות֙ פְּנֵ֣י הָאִ֔ישׁ וְאָחִ֥ינוּ הַקָּטֹ֖ן אֵינֶ֥נּוּ אִתָּֽנוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","וַיֹּ֛אמֶר עַבְדְּךָ֥ אָבִ֖י אֵלֵ֑ינוּ אַתֶּ֣ם יְדַעְתֶּ֔ם כִּ֥י שְׁנַ֖יִם יָֽלְדָה־לִּ֥י אִשְׁתִּֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","וַיֵּצֵ֤א הָֽאֶחָד֙ מֵֽאִתִּ֔י וָאֹמַ֕ר אַ֖ךְ טָרֹ֣ף טֹרָ֑ף וְלֹ֥א רְאִיתִ֖יו עַד־הֵֽנָּה׃ ");
INSERT INTO hbo_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","וּלְקַחְתֶּ֧ם גַּם־אֶת־זֶ֛ה מֵעִ֥ם פָּנַ֖י וְקָרָ֣הוּ אָסֹ֑ון וְהֹֽורַדְתֶּ֧ם אֶת־שֵׂיבָתִ֛י בְּרָעָ֖ה שְׁאֹֽלָה׃ ");
INSERT INTO hbo_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","וְעַתָּ֗ה כְּבֹאִי֙ אֶל־עַבְדְּךָ֣ אָבִ֔י וְהַנַּ֖עַר אֵינֶנּ֣וּ אִתָּ֑נוּ וְנַפְשֹׁ֖ו קְשׁוּרָ֥ה בְנַפְשֹֽׁו׃ ");
INSERT INTO hbo_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","וְהָיָ֗ה כִּרְאֹותֹ֛ו כִּי־אֵ֥ין הַנַּ֖עַר וָמֵ֑ת וְהֹורִ֨ידוּ עֲבָדֶ֜יךָ אֶת־שֵׂיבַ֨ת עַבְדְּךָ֥ אָבִ֛ינוּ בְּיָגֹ֖ון שְׁאֹֽלָה׃ ");
INSERT INTO hbo_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","כִּ֤י עַבְדְּךָ֙ עָרַ֣ב אֶת־הַנַּ֔עַר מֵעִ֥ם אָבִ֖י לֵאמֹ֑ר אִם־לֹ֤א אֲבִיאֶ֙נּוּ֙ אֵלֶ֔יךָ וְחָטָ֥אתִי לְאָבִ֖י כָּל־הַיָּמִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","וְעַתָּ֗ה יֵֽשֶׁב־נָ֤א עַבְדְּךָ֙ תַּ֣חַת הַנַּ֔עַר עֶ֖בֶד לַֽאדֹנִ֑י וְהַנַּ֖עַר יַ֥עַל עִם־אֶחָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","כִּי־אֵיךְ֙ אֶֽעֱלֶ֣ה אֶל־אָבִ֔י וְהַנַּ֖עַר אֵינֶנּ֣וּ אִתִּ֑י פֶּ֚ן אֶרְאֶ֣ה בָרָ֔ע אֲשֶׁ֥ר יִמְצָ֖א אֶת־אָבִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","וְלֹֽא־יָכֹ֨ל יֹוסֵ֜ף לְהִתְאַפֵּ֗ק לְכֹ֤ל הַנִּצָּבִים֙ עָלָ֔יו וַיִּקְרָ֕א הֹוצִ֥יאוּ כָל־אִ֖ישׁ מֵעָלָ֑י וְלֹא־עָ֤מַד אִישׁ֙ אִתֹּ֔ו בְּהִתְוַדַּ֥ע יֹוסֵ֖ף אֶל־אֶחָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","וַיִּתֵּ֥ן אֶת־קֹלֹ֖ו בִּבְכִ֑י וַיִּשְׁמְע֣וּ מִצְרַ֔יִם וַיִּשְׁמַ֖ע בֵּ֥ית פַּרְעֹֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","וַיֹּ֨אמֶר יֹוסֵ֤ף אֶל־אֶחָיו֙ אֲנִ֣י יֹוסֵ֔ף הַעֹ֥וד אָבִ֖י חָ֑י וְלֹֽא־יָכְל֤וּ אֶחָיו֙ לַעֲנֹ֣ות אֹתֹ֔ו כִּ֥י נִבְהֲל֖וּ מִפָּנָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","וַיֹּ֨אמֶר יֹוסֵ֧ף אֶל־אֶחָ֛יו גְּשׁוּ־נָ֥א אֵלַ֖י וַיִּגָּ֑שׁוּ וַיֹּ֗אמֶר אֲנִי֙ יֹוסֵ֣ף אֲחִיכֶ֔ם אֲשֶׁר־מְכַרְתֶּ֥ם אֹתִ֖י מִצְרָֽיְמָה׃ ");
INSERT INTO hbo_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","וְעַתָּ֣ה ׀ אַל־תֵּעָ֣צְב֗וּ וְאַל־יִ֙חַר֙ בְּעֵ֣ינֵיכֶ֔ם כִּֽי־מְכַרְתֶּ֥ם אֹתִ֖י הֵ֑נָּה כִּ֣י לְמִֽחְיָ֔ה שְׁלָחַ֥נִי אֱלֹהִ֖ים לִפְנֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","כִּי־זֶ֛ה שְׁנָתַ֥יִם הָרָעָ֖ב בְּקֶ֣רֶב הָאָ֑רֶץ וְעֹוד֙ חָמֵ֣שׁ שָׁנִ֔ים אֲשֶׁ֥ר אֵין־חָרִ֖ישׁ וְקָצִּֽיר׃ ");
INSERT INTO hbo_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","וַיִּשְׁלָחֵ֤נִי אֱלֹהִים֙ לִפְנֵיכֶ֔ם לָשׂ֥וּם לָכֶ֛ם שְׁאֵרִ֖ית בָּאָ֑רֶץ וּלְהַחֲיֹ֣ות לָכֶ֔ם לִפְלֵיטָ֖ה גְּדֹלָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","וְעַתָּ֗ה לֹֽא־אַתֶּ֞ם שְׁלַחְתֶּ֤ם אֹתִי֙ הֵ֔נָּה כִּ֖י הָאֱלֹהִ֑ים וַיְשִׂימֵ֨נִֽי לְאָ֜ב לְפַרְעֹ֗ה וּלְאָדֹון֙ לְכָל־בֵּיתֹ֔ו וּמֹשֵׁ֖ל בְּכָל־אֶ֥רֶץ מִצְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","מַהֲרוּ֮ וַעֲל֣וּ אֶל־אָבִי֒ וַאֲמַרְתֶּ֣ם אֵלָ֗יו כֹּ֤ה אָמַר֙ בִּנְךָ֣ יֹוסֵ֔ף שָׂמַ֧נִי אֱלֹהִ֛ים לְאָדֹ֖ון לְכָל־מִצְרָ֑יִם רְדָ֥ה אֵלַ֖י אַֽל־תַּעֲמֹֽד׃ ");
INSERT INTO hbo_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","וְיָשַׁבְתָּ֣ בְאֶֽרֶץ־גֹּ֗שֶׁן וְהָיִ֤יתָ קָרֹוב֙ אֵלַ֔י אַתָּ֕ה וּבָנֶ֖יךָ וּבְנֵ֣י בָנֶ֑יךָ וְצֹאנְךָ֥ וּבְקָרְךָ֖ וְכָל־אֲשֶׁר־לָֽךְ׃ ");
INSERT INTO hbo_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","וְכִלְכַּלְתִּ֤י אֹֽתְךָ֙ שָׁ֔ם כִּי־עֹ֛וד חָמֵ֥שׁ שָׁנִ֖ים רָעָ֑ב פֶּן־תִּוָּרֵ֛שׁ אַתָּ֥ה וּבֵֽיתְךָ֖ וְכָל־אֲשֶׁר־לָֽךְ׃ ");
INSERT INTO hbo_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","וְהִנֵּ֤ה עֵֽינֵיכֶם֙ רֹאֹ֔ות וְעֵינֵ֖י אָחִ֣י בִנְיָמִ֑ין כִּי־פִ֖י הַֽמְדַבֵּ֥ר אֲלֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","וְהִגַּדְתֶּ֣ם לְאָבִ֗י אֶת־כָּל־כְּבֹודִי֙ בְּמִצְרַ֔יִם וְאֵ֖ת כָּל־אֲשֶׁ֣ר רְאִיתֶ֑ם וּמִֽהַרְתֶּ֛ם וְהֹורַדְתֶּ֥ם אֶת־אָבִ֖י הֵֽנָּה׃ ");
INSERT INTO hbo_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","וַיִּפֹּ֛ל עַל־צַוְּארֵ֥י בִנְיָמִֽן־אָחִ֖יו וַיֵּ֑בְךְּ וּבִנְיָמִ֔ן בָּכָ֖ה עַל־צַוָּארָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","וַיְנַשֵּׁ֥ק לְכָל־אֶחָ֖יו וַיֵּ֣בְךְּ עֲלֵיהֶ֑ם וְאַ֣חֲרֵי כֵ֔ן דִּבְּר֥וּ אֶחָ֖יו אִתֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","וְהַקֹּ֣ל נִשְׁמַ֗ע בֵּ֤ית פַּרְעֹה֙ לֵאמֹ֔ר בָּ֖אוּ אֲחֵ֣י יֹוסֵ֑ף וַיִּיטַב֙ בְּעֵינֵ֣י פַרְעֹ֔ה וּבְעֵינֵ֖י עֲבָדָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","וַיֹּ֤אמֶר פַּרְעֹה֙ אֶל־יֹוסֵ֔ף אֱמֹ֥ר אֶל־אַחֶ֖יךָ זֹ֣את עֲשׂ֑וּ טַֽעֲנוּ֙ אֶת־בְּעִ֣ירְכֶ֔ם וּלְכוּ־בֹ֖אוּ אַ֥רְצָה כְּנָֽעַן׃ ");
INSERT INTO hbo_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","וּקְח֧וּ אֶת־אֲבִיכֶ֛ם וְאֶת־בָּתֵּיכֶ֖ם וּבֹ֣אוּ אֵלָ֑י וְאֶתְּנָ֣ה לָכֶ֗ם אֶת־טוּב֙ אֶ֣רֶץ מִצְרַ֔יִם וְאִכְל֖וּ אֶת־חֵ֥לֶב הָאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","וְאַתָּ֥ה צֻוֵּ֖יתָה זֹ֣את עֲשׂ֑וּ קְחוּ־לָכֶם֩ מֵאֶ֨רֶץ מִצְרַ֜יִם עֲגָלֹ֗ות לְטַפְּכֶם֙ וְלִנְשֵׁיכֶ֔ם וּנְשָׂאתֶ֥ם אֶת־אֲבִיכֶ֖ם וּבָאתֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","וְעֵ֣ינְכֶ֔ם אַל־תָּחֹ֖ס עַל־כְּלֵיכֶ֑ם כִּי־ט֛וּב כָּל־אֶ֥רֶץ מִצְרַ֖יִם לָכֶ֥ם הֽוּא׃ ");
INSERT INTO hbo_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","וַיַּֽעֲשׂוּ־כֵן֙ בְּנֵ֣י יִשְׂרָאֵ֔ל וַיִּתֵּ֨ן לָהֶ֥ם יֹוסֵ֛ף עֲגָלֹ֖ות עַל־פִּ֣י פַרְעֹ֑ה וַיִּתֵּ֥ן לָהֶ֛ם צֵדָ֖ה לַדָּֽרֶךְ׃ ");
INSERT INTO hbo_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","לְכֻלָּ֥ם נָתַ֛ן לָאִ֖ישׁ חֲלִפֹ֣ות שְׂמָלֹ֑ת וּלְבִנְיָמִ֤ן נָתַן֙ שְׁלֹ֣שׁ מֵאֹ֣ות כֶּ֔סֶף וְחָמֵ֖שׁ חֲלִפֹ֥ת שְׂמָלֹֽת׃ ");
INSERT INTO hbo_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","וּלְאָבִ֞יו שָׁלַ֤ח כְּזֹאת֙ עֲשָׂרָ֣ה חֲמֹרִ֔ים נֹשְׂאִ֖ים מִטּ֣וּב מִצְרָ֑יִם וְעֶ֣שֶׂר אֲתֹנֹ֡ת נֹֽ֠שְׂאֹת בָּ֣ר וָלֶ֧חֶם וּמָזֹ֛ון לְאָבִ֖יו לַדָּֽרֶךְ׃ ");
INSERT INTO hbo_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","וַיְשַׁלַּ֥ח אֶת־אֶחָ֖יו וַיֵּלֵ֑כוּ וַיֹּ֣אמֶר אֲלֵהֶ֔ם אַֽל־תִּרְגְּז֖וּ בַּדָּֽרֶךְ׃ ");
INSERT INTO hbo_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","וַֽיַּעֲל֖וּ מִמִּצְרָ֑יִם וַיָּבֹ֙אוּ֙ אֶ֣רֶץ כְּנַ֔עַן אֶֽל־יַעֲקֹ֖ב אֲבִיהֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","וַיַּגִּ֨דוּ לֹ֜ו לֵאמֹ֗ר עֹ֚וד יֹוסֵ֣ף חַ֔י וְכִֽי־ה֥וּא מֹשֵׁ֖ל בְּכָל־אֶ֣רֶץ מִצְרָ֑יִם וַיָּ֣פָג לִבֹּ֔ו כִּ֥י לֹא־הֶאֱמִ֖ין לָהֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","וַיְדַבְּר֣וּ אֵלָ֗יו אֵ֣ת כָּל־דִּבְרֵ֤י יֹוסֵף֙ אֲשֶׁ֣ר דִּבֶּ֣ר אֲלֵהֶ֔ם וַיַּרְא֙ אֶת־הָ֣עֲגָלֹ֔ות אֲשֶׁר־שָׁלַ֥ח יֹוסֵ֖ף לָשֵׂ֣את אֹתֹ֑ו וַתְּחִ֕י ר֖וּחַ יַעֲקֹ֥ב אֲבִיהֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","וַיֹּ֙אמֶר֙ יִשְׂרָאֵ֔ל רַ֛ב עֹוד־יֹוסֵ֥ף בְּנִ֖י חָ֑י אֵֽלְכָ֥ה וְאֶרְאֶ֖נּוּ בְּטֶ֥רֶם אָמֽוּת׃ ");
INSERT INTO hbo_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","וַיִּסַּ֤ע יִשְׂרָאֵל֙ וְכָל־אֲשֶׁר־לֹ֔ו וַיָּבֹ֖א בְּאֵ֣רָה שָּׁ֑בַע וַיִּזְבַּ֣ח זְבָחִ֔ים לֵאלֹהֵ֖י אָבִ֥יו יִצְחָֽק׃ ");
INSERT INTO hbo_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","וַיֹּ֨אמֶר אֱלֹהִ֤ים ׀ לְיִשְׂרָאֵל֙ בְּמַרְאֹ֣ת הַלַּ֔יְלָה וַיֹּ֖אמֶר יַעֲקֹ֣ב ׀ יַעֲקֹ֑ב וַיֹּ֖אמֶר הִנֵּֽנִי׃ ");
INSERT INTO hbo_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","וַיֹּ֕אמֶר אָנֹכִ֥י הָאֵ֖ל אֱלֹהֵ֣י אָבִ֑יךָ אַל־תִּירָא֙ מֵרְדָ֣ה מִצְרַ֔יְמָה כִּֽי־לְגֹ֥וי גָּדֹ֖ול אֲשִֽׂימְךָ֥ שָֽׁם׃ ");
INSERT INTO hbo_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","אָנֹכִ֗י אֵרֵ֤ד עִמְּךָ֙ מִצְרַ֔יְמָה וְאָנֹכִ֖י אַֽעַלְךָ֣ גַם־עָלֹ֑ה וְיֹוסֵ֕ף יָשִׁ֥ית יָדֹ֖ו עַל־עֵינֶֽיךָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","וַיָּ֥קָם יַעֲקֹ֖ב מִבְּאֵ֣ר שָׁ֑בַע וַיִּשְׂא֨וּ בְנֵֽי־יִשְׂרָאֵ֜ל אֶת־יַעֲקֹ֣ב אֲבִיהֶ֗ם וְאֶת־טַפָּם֙ וְאֶת־נְשֵׁיהֶ֔ם בָּעֲגָלֹ֕ות אֲשֶׁר־שָׁלַ֥ח פַּרְעֹ֖ה לָשֵׂ֥את אֹתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","וַיִּקְח֣וּ אֶת־מִקְנֵיהֶ֗ם וְאֶת־רְכוּשָׁם֙ אֲשֶׁ֤ר רָֽכְשׁוּ֙ בְּאֶ֣רֶץ כְּנַ֔עַן וַיָּבֹ֖אוּ מִצְרָ֑יְמָה יַעֲקֹ֖ב וְכָל־זַרְעֹ֥ו אִתֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","בָּנָ֞יו וּבְנֵ֤י בָנָיו֙ אִתֹּ֔ו בְּנֹתָ֛יו וּבְנֹ֥ות בָּנָ֖יו וְכָל־זַרְעֹ֑ו הֵבִ֥יא אִתֹּ֖ו מִצְרָֽיְמָה׃ ס ");
INSERT INTO hbo_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","וְאֵ֨לֶּה שְׁמֹ֧ות בְּנֵֽי־יִשְׂרָאֵ֛ל הַבָּאִ֥ים מִצְרַ֖יְמָה יַעֲקֹ֣ב וּבָנָ֑יו בְּכֹ֥ר יַעֲקֹ֖ב רְאוּבֵֽן׃ ");
INSERT INTO hbo_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","וּבְנֵ֖י רְאוּבֵ֑ן חֲנֹ֥וךְ וּפַלּ֖וּא וְחֶצְרֹ֥ון וְכַרְמִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","וּבְנֵ֣י שִׁמְעֹ֗ון יְמוּאֵ֧ל וְיָמִ֛ין וְאֹ֖הַד וְיָכִ֣ין וְצֹ֑חַר וְשָׁא֖וּל בֶּן־הַֽכְּנַעֲנִֽית׃ ");
INSERT INTO hbo_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","וּבְנֵ֖י לֵוִ֑י גֵּרְשֹׁ֕ון קְהָ֖ת וּמְרָרִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","וּבְנֵ֣י יְהוּדָ֗ה עֵ֧ר וְאֹונָ֛ן וְשֵׁלָ֖ה וָפֶ֣רֶץ וָזָ֑רַח וַיָּ֨מָת עֵ֤ר וְאֹונָן֙ בְּאֶ֣רֶץ כְּנַ֔עַן וַיִּהְי֥וּ בְנֵי־פֶ֖רֶץ חֶצְרֹ֥ון וְחָמֽוּל׃ ");
INSERT INTO hbo_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","וּבְנֵ֖י יִשָׂשכָ֑ר תֹּולָ֥ע וּפֻוָּ֖ה וְיֹ֥וב וְשִׁמְרֹֽון׃ ");
INSERT INTO hbo_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","וּבְנֵ֖י זְבוּלֻ֑ן סֶ֥רֶד וְאֵלֹ֖ון וְיַחְלְאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","אֵ֣לֶּה ׀ בְּנֵ֣י לֵאָ֗ה אֲשֶׁ֨ר יָֽלְדָ֤ה לְיַעֲקֹב֙ בְּפַדַּ֣ן אֲרָ֔ם וְאֵ֖ת דִּינָ֣ה בִתֹּ֑ו כָּל־נֶ֧פֶשׁ בָּנָ֛יו וּבְנֹותָ֖יו שְׁלֹשִׁ֥ים וְשָׁלֹֽשׁ׃ ");
INSERT INTO hbo_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","וּבְנֵ֣י גָ֔ד צִפְיֹ֥ון וְחַגִּ֖י שׁוּנִ֣י וְאֶצְבֹּ֑ן עֵרִ֥י וַֽאֲרֹודִ֖י וְאַרְאֵלִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","וּבְנֵ֣י אָשֵׁ֗ר יִמְנָ֧ה וְיִשְׁוָ֛ה וְיִשְׁוִ֥י וּבְרִיעָ֖ה וְשֶׂ֣רַח אֲחֹתָ֑ם וּבְנֵ֣י בְרִיעָ֔ה חֶ֖בֶר וּמַלְכִּיאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","אֵ֚לֶּה בְּנֵ֣י זִלְפָּ֔ה אֲשֶׁר־נָתַ֥ן לָבָ֖ן לְלֵאָ֣ה בִתֹּ֑ו וַתֵּ֤לֶד אֶת־אֵ֙לֶּה֙ לְיַעֲקֹ֔ב שֵׁ֥שׁ עֶשְׂרֵ֖ה נָֽפֶשׁ׃ ");
INSERT INTO hbo_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","בְּנֵ֤י רָחֵל֙ אֵ֣שֶׁת יַעֲקֹ֔ב יֹוסֵ֖ף וּבִנְיָמִֽן׃ ");
INSERT INTO hbo_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","וַיִּוָּלֵ֣ד לְיֹוסֵף֮ בְּאֶ֣רֶץ מִצְרַיִם֒ אֲשֶׁ֤ר יָֽלְדָה־לֹּו֙ אָֽסְנַ֔ת בַּת־פֹּ֥וטִי פֶ֖רַע כֹּהֵ֣ן אֹ֑ן אֶת־מְנַשֶּׁ֖ה וְאֶת־אֶפְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","וּבְנֵ֣י בִנְיָמִ֗ן בֶּ֤לַע וָבֶ֙כֶר֙ וְאַשְׁבֵּ֔ל גֵּרָ֥א וְנַעֲמָ֖ן אֵחִ֣י וָרֹ֑אשׁ מֻפִּ֥ים וְחֻפִּ֖ים וָאָֽרְדְּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","אֵ֚לֶּה בְּנֵ֣י רָחֵ֔ל אֲשֶׁ֥ר יֻלַּ֖ד לְיַעֲקֹ֑ב כָּל־נֶ֖פֶשׁ אַרְבָּעָ֥ה עָשָֽׂר׃ ");
INSERT INTO hbo_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","וּבְנֵי־דָ֖ן חֻשִֽׁים׃ ");
INSERT INTO hbo_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","וּבְנֵ֖י נַפְתָּלִ֑י יַחְצְאֵ֥ל וְגוּנִ֖י וְיֵ֥צֶר וְשִׁלֵּֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","אֵ֚לֶּה בְּנֵ֣י בִלְהָ֔ה אֲשֶׁר־נָתַ֥ן לָבָ֖ן לְרָחֵ֣ל בִּתֹּ֑ו וַתֵּ֧לֶד אֶת־אֵ֛לֶּה לְיַעֲקֹ֖ב כָּל־נֶ֥פֶשׁ שִׁבְעָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","כָּל־הַ֠נֶּפֶשׁ הַבָּאָ֨ה לְיַעֲקֹ֤ב מִצְרַ֙יְמָה֙ יֹצְאֵ֣י יְרֵכֹ֔ו מִלְּבַ֖ד נְשֵׁ֣י בְנֵי־יַעֲקֹ֑ב כָּל־נֶ֖פֶשׁ שִׁשִּׁ֥ים וָשֵֽׁשׁ׃ ");
INSERT INTO hbo_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","וּבְנֵ֥י יֹוסֵ֛ף אֲשֶׁר־יֻלַּד־לֹ֥ו בְמִצְרַ֖יִם נֶ֣פֶשׁ שְׁנָ֑יִם כָּל־הַנֶּ֧פֶשׁ לְבֵֽית־יַעֲקֹ֛ב הַבָּ֥אָה מִצְרַ֖יְמָה שִׁבְעִֽים׃ פ ");
INSERT INTO hbo_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","וְאֶת־יְהוּדָ֞ה שָׁלַ֤ח לְפָנָיו֙ אֶל־יֹוסֵ֔ף לְהֹורֹ֥ת לְפָנָ֖יו גֹּ֑שְׁנָה וַיָּבֹ֖אוּ אַ֥רְצָה גֹּֽשֶׁן׃ ");
INSERT INTO hbo_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","וַיֶּאְסֹ֤ר יֹוסֵף֙ מֶרְכַּבְתֹּ֔ו וַיַּ֛עַל לִקְרַֽאת־יִשְׂרָאֵ֥ל אָבִ֖יו גֹּ֑שְׁנָה וַיֵּרָ֣א אֵלָ֗יו וַיִּפֹּל֙ עַל־צַוָּארָ֔יו וַיֵּ֥בְךְּ עַל־צַוָּארָ֖יו עֹֽוד׃ ");
INSERT INTO hbo_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","וַיֹּ֧אמֶר יִשְׂרָאֵ֛ל אֶל־יֹוסֵ֖ף אָמ֣וּתָה הַפָּ֑עַם אַחֲרֵי֙ רְאֹותִ֣י אֶת־פָּנֶ֔יךָ כִּ֥י עֹודְךָ֖ חָֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","וַיֹּ֨אמֶר יֹוסֵ֤ף אֶל־אֶחָיו֙ וְאֶל־בֵּ֣ית אָבִ֔יו אֶעֱלֶ֖ה וְאַגִּ֣ידָה לְפַרְעֹ֑ה וְאֹֽמְרָ֣ה אֵלָ֔יו אַחַ֧י וּבֵית־אָבִ֛י אֲשֶׁ֥ר בְּאֶֽרֶץ־כְּנַ֖עַן בָּ֥אוּ אֵלָֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","וְהָאֲנָשִׁים֙ רֹ֣עֵי צֹ֔אן כִּֽי־אַנְשֵׁ֥י מִקְנֶ֖ה הָ֑יוּ וְצֹאנָ֧ם וּבְקָרָ֛ם וְכָל־אֲשֶׁ֥ר לָהֶ֖ם הֵבִֽיאוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","וְהָיָ֕ה כִּֽי־יִקְרָ֥א לָכֶ֖ם פַּרְעֹ֑ה וְאָמַ֖ר מַה־מַּעֲשֵׂיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","וַאֲמַרְתֶּ֗ם אַנְשֵׁ֨י מִקְנֶ֜ה הָי֤וּ עֲבָדֶ֙יךָ֙ מִנְּעוּרֵ֣ינוּ וְעַד־עַ֔תָּה גַּם־אֲנַ֖חְנוּ גַּם־אֲבֹתֵ֑ינוּ בַּעֲב֗וּר תֵּשְׁבוּ֙ בְּאֶ֣רֶץ גֹּ֔שֶׁן כִּֽי־תֹועֲבַ֥ת מִצְרַ֖יִם כָּל־רֹ֥עֵה צֹֽאן׃ ");
INSERT INTO hbo_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","וַיָּבֹ֣א יֹוסֵף֮ וַיַּגֵּ֣ד לְפַרְעֹה֒ וַיֹּ֗אמֶר אָבִ֨י וְאַחַ֜י וְצֹאנָ֤ם וּבְקָרָם֙ וְכָל־אֲשֶׁ֣ר לָהֶ֔ם בָּ֖אוּ מֵאֶ֣רֶץ כְּנָ֑עַן וְהִנָּ֖ם בְּאֶ֥רֶץ גֹּֽשֶׁן׃ ");
INSERT INTO hbo_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","וּמִקְצֵ֣ה אֶחָ֔יו לָקַ֖ח חֲמִשָּׁ֣ה אֲנָשִׁ֑ים וַיַּצִּגֵ֖ם לִפְנֵ֥י פַרְעֹֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","וַיֹּ֧אמֶר פַּרְעֹ֛ה אֶל־אֶחָ֖יו מַה־מַּעֲשֵׂיכֶ֑ם וַיֹּאמְר֣וּ אֶל־פַּרְעֹ֗ה רֹעֵ֥ה צֹאן֙ עֲבָדֶ֔יךָ גַּם־אֲנַ֖חְנוּ גַּם־אֲבֹותֵֽינוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","וַיֹּאמְר֣וּ אֶל־פַּרְעֹ֗ה לָג֣וּר בָּאָרֶץ֮ בָּאנוּ֒ כִּי־אֵ֣ין מִרְעֶ֗ה לַצֹּאן֙ אֲשֶׁ֣ר לַעֲבָדֶ֔יךָ כִּֽי־כָבֵ֥ד הָרָעָ֖ב בְּאֶ֣רֶץ כְּנָ֑עַן וְעַתָּ֛ה יֵֽשְׁבוּ־נָ֥א עֲבָדֶ֖יךָ בְּאֶ֥רֶץ גֹּֽשֶׁן׃ ");
INSERT INTO hbo_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","וַיֹּ֣אמֶר פַּרְעֹ֔ה אֶל־יֹוסֵ֖ף לֵאמֹ֑ר אָבִ֥יךָ וְאַחֶ֖יךָ בָּ֥אוּ אֵלֶֽיךָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","אֶ֤רֶץ מִצְרַ֙יִם֙ לְפָנֶ֣יךָ הִ֔וא בְּמֵיטַ֣ב הָאָ֔רֶץ הֹושֵׁ֥ב אֶת־אָבִ֖יךָ וְאֶת־אַחֶ֑יךָ יֵשְׁבוּ֙ בְּאֶ֣רֶץ גֹּ֔שֶׁן וְאִם־יָדַ֗עְתָּ וְיֶשׁ־בָּם֙ אַנְשֵׁי־חַ֔יִל וְשַׂמְתָּ֛ם שָׂרֵ֥י מִקְנֶ֖ה עַל־אֲשֶׁר־לִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","וַיָּבֵ֤א יֹוסֵף֙ אֶת־יַֽעֲקֹ֣ב אָבִ֔יו וַיַּֽעֲמִדֵ֖הוּ לִפְנֵ֣י פַרְעֹ֑ה וַיְבָ֥רֶךְ יַעֲקֹ֖ב אֶת־פַּרְעֹֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","וַיֹּ֥אמֶר פַּרְעֹ֖ה אֶֽל־יַעֲקֹ֑ב כַּמָּ֕ה יְמֵ֖י שְׁנֵ֥י חַיֶּֽיךָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","וַיֹּ֤אמֶר יַעֲקֹב֙ אֶל־פַּרְעֹ֔ה יְמֵי֙ שְׁנֵ֣י מְגוּרַ֔י שְׁלֹשִׁ֥ים וּמְאַ֖ת שָׁנָ֑ה מְעַ֣ט וְרָעִ֗ים הָיוּ֙ יְמֵי֙ שְׁנֵ֣י חַיַּ֔י וְלֹ֣א הִשִּׂ֗יגוּ אֶת־יְמֵי֙ שְׁנֵי֙ חַיֵּ֣י אֲבֹתַ֔י בִּימֵ֖י מְגוּרֵיהֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","וַיְבָ֥רֶךְ יַעֲקֹ֖ב אֶת־פַּרְעֹ֑ה וַיֵּצֵ֖א מִלִּפְנֵ֥י פַרְעֹֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","וַיֹּושֵׁ֣ב יֹוסֵף֮ אֶת־אָבִ֣יו וְאֶת־אֶחָיו֒ וַיִּתֵּ֨ן לָהֶ֤ם אֲחֻזָּה֙ בְּאֶ֣רֶץ מִצְרַ֔יִם בְּמֵיטַ֥ב הָאָ֖רֶץ בְּאֶ֣רֶץ רַעְמְסֵ֑ס כַּאֲשֶׁ֖ר צִוָּ֥ה פַרְעֹֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","וַיְכַלְכֵּ֤ל יֹוסֵף֙ אֶת־אָבִ֣יו וְאֶת־אֶחָ֔יו וְאֵ֖ת כָּל־בֵּ֣ית אָבִ֑יו לֶ֖חֶם לְפִ֥י הַטָּֽף׃ ");
INSERT INTO hbo_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","וְלֶ֤חֶם אֵין֙ בְּכָל־הָאָ֔רֶץ כִּֽי־כָבֵ֥ד הָרָעָ֖ב מְאֹ֑ד וַתֵּ֜לַהּ אֶ֤רֶץ מִצְרַ֙יִם֙ וְאֶ֣רֶץ כְּנַ֔עַן מִפְּנֵ֖י הָרָעָֽב׃ ");
INSERT INTO hbo_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","וַיְלַקֵּ֣ט יֹוסֵ֗ף אֶת־כָּל־הַכֶּ֙סֶף֙ הַנִּמְצָ֤א בְאֶֽרֶץ־מִצְרַ֙יִם֙ וּבְאֶ֣רֶץ כְּנַ֔עַן בַּשֶּׁ֖בֶר אֲשֶׁר־הֵ֣ם שֹׁבְרִ֑ים וַיָּבֵ֥א יֹוסֵ֛ף אֶת־הַכֶּ֖סֶף בֵּ֥יתָה פַרְעֹֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","וַיִּתֹּ֣ם הַכֶּ֗סֶף מֵאֶ֣רֶץ מִצְרַיִם֮ וּמֵאֶ֣רֶץ כְּנַעַן֒ וַיָּבֹאוּ֩ כָל־מִצְרַ֨יִם אֶל־יֹוסֵ֤ף לֵאמֹר֙ הָֽבָה־לָּ֣נוּ לֶ֔חֶם וְלָ֥מָּה נָמ֖וּת נֶגְדֶּ֑ךָ כִּ֥י אָפֵ֖ס כָּֽסֶף׃ ");
INSERT INTO hbo_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","וַיֹּ֤אמֶר יֹוסֵף֙ הָב֣וּ מִקְנֵיכֶ֔ם וְאֶתְּנָ֥ה לָכֶ֖ם בְּמִקְנֵיכֶ֑ם אִם־אָפֵ֖ס כָּֽסֶף׃ ");
INSERT INTO hbo_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","וַיָּבִ֣יאוּ אֶת־מִקְנֵיהֶם֮ אֶל־יֹוסֵף֒ וַיִּתֵּ֣ן לָהֶם֩ יֹוסֵ֨ף לֶ֜חֶם בַּסּוּסִ֗ים וּבְמִקְנֵ֥ה הַצֹּ֛אן וּבְמִקְנֵ֥ה הַבָּקָ֖ר וּבַחֲמֹרִ֑ים וַיְנַהֲלֵ֤ם בַּלֶּ֙חֶם֙ בְּכָל־מִקְנֵהֶ֔ם בַּשָּׁנָ֖ה הַהִֽוא׃ ");
INSERT INTO hbo_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","וַתִּתֹּם֮ הַשָּׁנָ֣ה הַהִוא֒ וַיָּבֹ֨אוּ אֵלָ֜יו בַּשָּׁנָ֣ה הַשֵּׁנִ֗ית וַיֹּ֤אמְרוּ לֹו֙ לֹֽא־נְכַחֵ֣ד מֵֽאֲדֹנִ֔י כִּ֚י אִם־תַּ֣ם הַכֶּ֔סֶף וּמִקְנֵ֥ה הַבְּהֵמָ֖ה אֶל־אֲדֹנִ֑י לֹ֤א נִשְׁאַר֙ לִפְנֵ֣י אֲדֹנִ֔י בִּלְתִּ֥י אִם־גְּוִיָּתֵ֖נוּ וְאַדְמָתֵֽנוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","לָ֧מָּה נָמ֣וּת לְעֵינֶ֗יךָ גַּם־אֲנַ֙חְנוּ֙ גַּ֣ם אַדְמָתֵ֔נוּ קְנֵֽה־אֹתָ֥נוּ וְאֶת־אַדְמָתֵ֖נוּ בַּלָּ֑חֶם וְנִֽהְיֶ֞ה אֲנַ֤חְנוּ וְאַדְמָתֵ֙נוּ֙ עֲבָדִ֣ים לְפַרְעֹ֔ה וְתֶן־זֶ֗רַע וְנִֽחְיֶה֙ וְלֹ֣א נָמ֔וּת וְהָאֲדָמָ֖ה לֹ֥א תֵשָֽׁם׃ ");
INSERT INTO hbo_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","וַיִּ֨קֶן יֹוסֵ֜ף אֶת־כָּל־אַדְמַ֤ת מִצְרַ֙יִם֙ לְפַרְעֹ֔ה כִּֽי־מָכְר֤וּ מִצְרַ֙יִם֙ אִ֣ישׁ שָׂדֵ֔הוּ כִּֽי־חָזַ֥ק עֲלֵהֶ֖ם הָרָעָ֑ב וַתְּהִ֥י הָאָ֖רֶץ לְפַרְעֹֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","וְאֶ֨ת־הָעָ֔ם הֶעֱבִ֥יר אֹתֹ֖ו לֶעָרִ֑ים מִקְצֵ֥ה גְבוּל־מִצְרַ֖יִם וְעַד־קָצֵֽהוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","רַ֛ק אַדְמַ֥ת הַכֹּהֲנִ֖ים לֹ֣א קָנָ֑ה כִּי֩ חֹ֨ק לַכֹּהֲנִ֜ים מֵאֵ֣ת פַּרְעֹ֗ה וְאָֽכְל֤וּ אֶת־חֻקָּם֙ אֲשֶׁ֨ר נָתַ֤ן לָהֶם֙ פַּרְעֹ֔ה עַל־כֵּ֕ן לֹ֥א מָכְר֖וּ אֶת־אַדְמָתָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","וַיֹּ֤אמֶר יֹוסֵף֙ אֶל־הָעָ֔ם הֵן֩ קָנִ֨יתִי אֶתְכֶ֥ם הַיֹּ֛ום וְאֶת־אַדְמַתְכֶ֖ם לְפַרְעֹ֑ה הֵֽא־לָכֶ֣ם זֶ֔רַע וּזְרַעְתֶּ֖ם אֶת־הָאֲדָמָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","וְהָיָה֙ בַּתְּבוּאֹ֔ת וּנְתַתֶּ֥ם חֲמִישִׁ֖ית לְפַרְעֹ֑ה וְאַרְבַּ֣ע הַיָּדֹ֡ת יִהְיֶ֣ה לָכֶם֩ לְזֶ֨רַע הַשָּׂדֶ֧ה וּֽלְאָכְלְכֶ֛ם וְלַאֲשֶׁ֥ר בְּבָתֵּיכֶ֖ם וְלֶאֱכֹ֥ל לְטַפְּכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","וַיֹּאמְר֖וּ הֶחֱיִתָ֑נוּ נִמְצָא־חֵן֙ בְּעֵינֵ֣י אֲדֹנִ֔י וְהָיִ֥ינוּ עֲבָדִ֖ים לְפַרְעֹֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","וַיָּ֣שֶׂם אֹתָ֣הּ יֹוסֵ֡ף לְחֹק֩ עַד־הַיֹּ֨ום הַזֶּ֜ה עַל־אַדְמַ֥ת מִצְרַ֛יִם לְפַרְעֹ֖ה לַחֹ֑מֶשׁ רַ֞ק אַדְמַ֤ת הַכֹּֽהֲנִים֙ לְבַדָּ֔ם לֹ֥א הָיְתָ֖ה לְפַרְעֹֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","וַיֵּ֧שֶׁב יִשְׂרָאֵ֛ל בְּאֶ֥רֶץ מִצְרַ֖יִם בְּאֶ֣רֶץ גֹּ֑שֶׁן וַיֵּאָחֲז֣וּ בָ֔הּ וַיִּפְר֥וּ וַיִּרְבּ֖וּ מְאֹֽד׃ ");
INSERT INTO hbo_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","וַיְחִ֤י יַעֲקֹב֙ בְּאֶ֣רֶץ מִצְרַ֔יִם שְׁבַ֥ע עֶשְׂרֵ֖ה שָׁנָ֑ה וַיְהִ֤י יְמֵֽי־יַעֲקֹב֙ שְׁנֵ֣י חַיָּ֔יו שֶׁ֣בַע שָׁנִ֔ים וְאַרְבָּעִ֥ים וּמְאַ֖ת שָׁנָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","וַיִּקְרְב֣וּ יְמֵֽי־יִשְׂרָאֵל֮ לָמוּת֒ וַיִּקְרָ֣א ׀ לִבְנֹ֣ו לְיֹוסֵ֗ף וַיֹּ֤אמֶר לֹו֙ אִם־נָ֨א מָצָ֤אתִי חֵן֙ בְּעֵינֶ֔יךָ שִֽׂים־נָ֥א יָדְךָ֖ תַּ֣חַת יְרֵכִ֑י וְעָשִׂ֤יתָ עִמָּדִי֙ חֶ֣סֶד וֶאֱמֶ֔ת אַל־נָ֥א תִקְבְּרֵ֖נִי בְּמִצְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","וְשָֽׁכַבְתִּי֙ עִם־אֲבֹתַ֔י וּנְשָׂאתַ֙נִי֙ מִמִּצְרַ֔יִם וּקְבַרְתַּ֖נִי בִּקְבֻרָתָ֑ם וַיֹּאמַ֕ר אָנֹכִ֖י אֶֽעֱשֶׂ֥ה כִדְבָרֶֽךָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","וַיֹּ֗אמֶר הִשָּֽׁבְעָה֙ לִ֔י וַיִּשָּׁבַ֖ע לֹ֑ו וַיִּשְׁתַּ֥חוּ יִשְׂרָאֵ֖ל עַל־רֹ֥אשׁ הַמִּטָּֽה׃ פ ");
INSERT INTO hbo_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","וַיְהִ֗י אַחֲרֵי֙ הַדְּבָרִ֣ים הָאֵ֔לֶּה וַיֹּ֣אמֶר לְיֹוסֵ֔ף הִנֵּ֥ה אָבִ֖יךָ חֹלֶ֑ה וַיִּקַּ֞ח אֶת־שְׁנֵ֤י בָנָיו֙ עִמֹּ֔ו אֶת־מְנַשֶּׁ֖ה וְאֶת־אֶפְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","וַיַּגֵּ֣ד לְיַעֲקֹ֔ב וַיֹּ֕אמֶר הִנֵּ֛ה בִּנְךָ֥ יֹוסֵ֖ף בָּ֣א אֵלֶ֑יךָ וַיִּתְחַזֵּק֙ יִשְׂרָאֵ֔ל וַיֵּ֖שֶׁב עַל־הַמִּטָּֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","וַיֹּ֤אמֶר יַעֲקֹב֙ אֶל־יֹוסֵ֔ף אֵ֥ל שַׁדַּ֛י נִרְאָֽה־אֵלַ֥י בְּל֖וּז בְּאֶ֣רֶץ כְּנָ֑עַן וַיְבָ֖רֶךְ אֹתִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","וַיֹּ֣אמֶר אֵלַ֗י הִנְנִ֤י מַפְרְךָ֙ וְהִרְבִּיתִ֔ךָ וּנְתַתִּ֖יךָ לִקְהַ֣ל עַמִּ֑ים וְנָ֨תַתִּ֜י אֶת־הָאָ֧רֶץ הַזֹּ֛את לְזַרְעֲךָ֥ אַחֲרֶ֖יךָ אֲחֻזַּ֥ת עֹולָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","וְעַתָּ֡ה שְׁנֵֽי־בָנֶיךָ֩ הַנֹּולָדִ֨ים לְךָ֜ בְּאֶ֣רֶץ מִצְרַ֗יִם עַד־בֹּאִ֥י אֵלֶ֛יךָ מִצְרַ֖יְמָה לִי־הֵ֑ם אֶפְרַ֙יִם֙ וּמְנַשֶּׁ֔ה כִּרְאוּבֵ֥ן וְשִׁמְעֹ֖ון יִֽהְיוּ־לִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","וּמֹולַדְתְּךָ֛ אֲשֶׁר־הֹולַ֥דְתָּ אַחֲרֵיהֶ֖ם לְךָ֣ יִהְי֑וּ עַ֣ל שֵׁ֧ם אֲחֵיהֶ֛ם יִקָּרְא֖וּ בְּנַחֲלָתָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","וַאֲנִ֣י ׀ בְּבֹאִ֣י מִפַּדָּ֗ן מֵ֩תָה֩ עָלַ֨י רָחֵ֜ל בְּאֶ֤רֶץ כְּנַ֙עַן֙ בַּדֶּ֔רֶךְ בְּעֹ֥וד כִּבְרַת־אֶ֖רֶץ לָבֹ֣א אֶפְרָ֑תָה וָאֶקְבְּרֶ֤הָ שָּׁם֙ בְּדֶ֣רֶךְ אֶפְרָ֔ת הִ֖וא בֵּ֥ית לָֽחֶם׃ ");
INSERT INTO hbo_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","וַיַּ֥רְא יִשְׂרָאֵ֖ל אֶת־בְּנֵ֣י יֹוסֵ֑ף וַיֹּ֖אמֶר מִי־אֵֽלֶּה׃ ");
INSERT INTO hbo_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","וַיֹּ֤אמֶר יֹוסֵף֙ אֶל־אָבִ֔יו בָּנַ֣י הֵ֔ם אֲשֶׁר־נָֽתַן־לִ֥י אֱלֹהִ֖ים בָּזֶ֑ה וַיֹּאמַ֕ר קָֽחֶם־נָ֥א אֵלַ֖י וַאֲבָרֲכֵֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","וְעֵינֵ֤י יִשְׂרָאֵל֙ כָּבְד֣וּ מִזֹּ֔קֶן לֹ֥א יוּכַ֖ל לִרְאֹ֑ות וַיַּגֵּ֤שׁ אֹתָם֙ אֵלָ֔יו וַיִּשַּׁ֥ק לָהֶ֖ם וַיְחַבֵּ֥ק לָהֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","וַיֹּ֤אמֶר יִשְׂרָאֵל֙ אֶל־יֹוסֵ֔ף רְאֹ֥ה פָנֶ֖יךָ לֹ֣א פִלָּ֑לְתִּי וְהִנֵּ֨ה הֶרְאָ֥ה אֹתִ֛י אֱלֹהִ֖ים גַּ֥ם אֶת־זַרְעֶֽךָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","וַיֹּוצֵ֥א יֹוסֵ֛ף אֹתָ֖ם מֵעִ֣ם בִּרְכָּ֑יו וַיִּשְׁתַּ֥חוּ לְאַפָּ֖יו אָֽרְצָה׃ ");
INSERT INTO hbo_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","וַיִּקַּ֣ח יֹוסֵף֮ אֶת־שְׁנֵיהֶם֒ אֶת־אֶפְרַ֤יִם בִּֽימִינֹו֙ מִשְּׂמֹ֣אל יִשְׂרָאֵ֔ל וְאֶת־מְנַשֶּׁ֥ה בִשְׂמֹאלֹ֖ו מִימִ֣ין יִשְׂרָאֵ֑ל וַיַּגֵּ֖שׁ אֵלָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","וַיִּשְׁלַח֩ יִשְׂרָאֵ֨ל אֶת־יְמִינֹ֜ו וַיָּ֨שֶׁת עַל־רֹ֤אשׁ אֶפְרַ֙יִם֙ וְה֣וּא הַצָּעִ֔יר וְאֶת־שְׂמֹאלֹ֖ו עַל־רֹ֣אשׁ מְנַשֶּׁ֑ה שִׂכֵּל֙ אֶת־יָדָ֔יו כִּ֥י מְנַשֶּׁ֖ה הַבְּכֹֽור׃ ");
INSERT INTO hbo_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","וַיְבָ֥רֶךְ אֶת־יֹוסֵ֖ף וַיֹּאמַ֑ר הָֽאֱלֹהִ֡ים אֲשֶׁר֩ הִתְהַלְּכ֨וּ אֲבֹתַ֤י לְפָנָיו֙ אַבְרָהָ֣ם וְיִצְחָ֔ק הָֽאֱלֹהִים֙ הָרֹעֶ֣ה אֹתִ֔י מֵעֹודִ֖י עַד־הַיֹּ֥ום הַזֶּֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","הַמַּלְאָךְ֩ הַגֹּאֵ֨ל אֹתִ֜י מִכָּל־רָ֗ע יְבָרֵךְ֮ אֶת־הַנְּעָרִים֒ וְיִקָּרֵ֤א בָהֶם֙ שְׁמִ֔י וְשֵׁ֥ם אֲבֹתַ֖י אַבְרָהָ֣ם וְיִצְחָ֑ק וְיִדְגּ֥וּ לָרֹ֖ב בְּקֶ֥רֶב הָאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","וַיַּ֣רְא יֹוסֵ֗ף כִּי־יָשִׁ֨ית אָבִ֧יו יַד־יְמִינֹ֛ו עַל־רֹ֥אשׁ אֶפְרַ֖יִם וַיֵּ֣רַע בְּעֵינָ֑יו וַיִּתְמֹ֣ךְ יַד־אָבִ֗יו לְהָסִ֥יר אֹתָ֛הּ מֵעַ֥ל רֹאשׁ־אֶפְרַ֖יִם עַל־רֹ֥אשׁ מְנַשֶּֽׁה׃ ");
INSERT INTO hbo_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","וַיֹּ֧אמֶר יֹוסֵ֛ף אֶל־אָבִ֖יו לֹא־כֵ֣ן אָבִ֑י כִּי־זֶ֣ה הַבְּכֹ֔ר שִׂ֥ים יְמִינְךָ֖ עַל־רֹאשֹֽׁו׃ ");
INSERT INTO hbo_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","וַיְמָאֵ֣ן אָבִ֗יו וַיֹּ֙אמֶר֙ יָדַ֤עְתִּֽי בְנִי֙ יָדַ֔עְתִּי גַּם־ה֥וּא יִהְיֶה־לְּעָ֖ם וְגַם־ה֣וּא יִגְדָּ֑ל וְאוּלָ֗ם אָחִ֤יו הַקָּטֹן֙ יִגְדַּ֣ל מִמֶּ֔נּוּ וְזַרְעֹ֖ו יִהְיֶ֥ה מְלֹֽא־הַגֹּויִֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","וַיְבָ֨רֲכֵ֜ם בַּיֹּ֣ום הַהוּא֮ לֵאמֹור֒ בְּךָ֗ יְבָרֵ֤ךְ יִשְׂרָאֵל֙ לֵאמֹ֔ר יְשִֽׂמְךָ֣ אֱלֹהִ֔ים כְּאֶפְרַ֖יִם וְכִמְנַשֶּׁ֑ה וַיָּ֥שֶׂם אֶת־אֶפְרַ֖יִם לִפְנֵ֥י מְנַשֶּֽׁה׃ ");
INSERT INTO hbo_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","וַיֹּ֤אמֶר יִשְׂרָאֵל֙ אֶל־יֹוסֵ֔ף הִנֵּ֥ה אָנֹכִ֖י מֵ֑ת וְהָיָ֤ה אֱלֹהִים֙ עִמָּכֶ֔ם וְהֵשִׁ֣יב אֶתְכֶ֔ם אֶל־אֶ֖רֶץ אֲבֹתֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","וַאֲנִ֞י נָתַ֧תִּֽי לְךָ֛ שְׁכֶ֥ם אַחַ֖ד עַל־אַחֶ֑יךָ אֲשֶׁ֤ר לָקַ֙חְתִּי֙ מִיַּ֣ד הָֽאֱמֹרִ֔י בְּחַרְבִּ֖י וּבְקַשְׁתִּֽי׃ פ ");
INSERT INTO hbo_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","וַיִּקְרָ֥א יַעֲקֹ֖ב אֶל־בָּנָ֑יו וַיֹּ֗אמֶר הֵאָֽסְפוּ֙ וְאַגִּ֣ידָה לָכֶ֔ם אֵ֛ת אֲשֶׁר־יִקְרָ֥א אֶתְכֶ֖ם בְּאַחֲרִ֥ית הַיָּמִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","הִקָּבְצ֥וּ וְשִׁמְע֖וּ בְּנֵ֣י יַעֲקֹ֑ב וְשִׁמְע֖וּ אֶל־יִשְׂרָאֵ֥ל אֲבִיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","רְאוּבֵן֙ בְּכֹ֣רִי אַ֔תָּה כֹּחִ֖י וְרֵאשִׁ֣ית אֹונִ֑י יֶ֥תֶר שְׂאֵ֖ת וְיֶ֥תֶר עָֽז׃ ");
INSERT INTO hbo_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","פַּ֤חַז כַּמַּ֙יִם֙ אַל־תֹּותַ֔ר כִּ֥י עָלִ֖יתָ מִשְׁכְּבֵ֣י אָבִ֑יךָ אָ֥ז חִלַּ֖לְתָּ יְצוּעִ֥י עָלָֽה׃ פ ");
INSERT INTO hbo_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","שִׁמְעֹ֥ון וְלֵוִ֖י אַחִ֑ים כְּלֵ֥י חָמָ֖ס מְכֵרֹתֵיהֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","בְּסֹדָם֙ אַל־תָּבֹ֣א נַפְשִׁ֔י בִּקְהָלָ֖ם אַל־תֵּחַ֣ד כְּבֹדִ֑י כִּ֤י בְאַפָּם֙ הָ֣רְגוּ אִ֔ישׁ וּבִרְצֹנָ֖ם עִקְּרוּ־שֹֽׁור׃ ");
INSERT INTO hbo_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","אָר֤וּר אַפָּם֙ כִּ֣י עָ֔ז וְעֶבְרָתָ֖ם כִּ֣י קָשָׁ֑תָה אֲחַלְּקֵ֣ם בְּיַעֲקֹ֔ב וַאֲפִיצֵ֖ם בְּיִשְׂרָאֵֽל׃ ס ");
INSERT INTO hbo_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","יְהוּדָ֗ה אַתָּה֙ יֹוד֣וּךָ אַחֶ֔יךָ יָדְךָ֖ בְּעֹ֣רֶף אֹיְבֶ֑יךָ יִשְׁתַּחֲוּ֥וּ לְךָ֖ בְּנֵ֥י אָבִֽיךָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","גּ֤וּר אַרְיֵה֙ יְהוּדָ֔ה מִטֶּ֖רֶף בְּנִ֣י עָלִ֑יתָ כָּרַ֨ע רָבַ֧ץ כְּאַרְיֵ֛ה וּכְלָבִ֖יא מִ֥י יְקִימֶֽנּוּ׃ ");
INSERT INTO hbo_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","לֹֽא־יָס֥וּר שֵׁ֙בֶט֙ מִֽיהוּדָ֔ה וּמְחֹקֵ֖ק מִבֵּ֣ין רַגְלָ֑יו עַ֚ד כִּֽי־יָבֹ֣א *שִׁילֹה (שִׁילֹ֔ו) וְלֹ֖ו יִקְּהַ֥ת עַמִּֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","אֹסְרִ֤י לַגֶּ֙פֶן֙ *עִירֹה (עִירֹ֔ו) וְלַשֹּׂרֵקָ֖ה בְּנִ֣י אֲתֹנֹ֑ו כִּבֵּ֤ס בַּיַּ֙יִן֙ לְבֻשֹׁ֔ו וּבְדַם־עֲנָבִ֖ים *סוּתֹה (סוּתֹֽו)׃ ");
INSERT INTO hbo_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","חַכְלִילִ֥י עֵינַ֖יִם מִיָּ֑יִן וּלְבֶן־שִׁנַּ֖יִם מֵחָלָֽב׃ פ ");
INSERT INTO hbo_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","זְבוּלֻ֕ן לְחֹ֥וף יַמִּ֖ים יִשְׁכֹּ֑ן וְהוּא֙ לְחֹ֣וף אֳנִיֹּ֔ות וְיַרְכָתֹ֖ו עַל־צִידֹֽן׃ ס ");
INSERT INTO hbo_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","יִשָּׂשכָ֖ר חֲמֹ֣ר גָּ֑רֶם רֹבֵ֖ץ בֵּ֥ין הַֽמִּשְׁפְּתָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","וַיַּ֤רְא מְנֻחָה֙ כִּ֣י טֹ֔וב וְאֶת־הָאָ֖רֶץ כִּ֣י נָעֵ֑מָה וַיֵּ֤ט שִׁכְמֹו֙ לִסְבֹּ֔ל וַיְהִ֖י לְמַס־עֹבֵֽד׃ ס ");
INSERT INTO hbo_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","דָּ֖ן יָדִ֣ין עַמֹּ֑ו כְּאַחַ֖ד שִׁבְטֵ֥י יִשְׂרָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","יְהִי־דָן֙ נָחָ֣שׁ עֲלֵי־דֶ֔רֶךְ שְׁפִיפֹ֖ן עֲלֵי־אֹ֑רַח הַנֹּשֵׁךְ֙ עִקְּבֵי־ס֔וּס וַיִּפֹּ֥ל רֹכְבֹ֖ו אָחֹֽור׃ ");
INSERT INTO hbo_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","לִֽישׁוּעָתְךָ֖ קִוִּ֥יתִי יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","גָּ֖ד גְּד֣וּד יְגוּדֶ֑נּוּ וְה֖וּא יָגֻ֥ד עָקֵֽב׃ ס ");
INSERT INTO hbo_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","מֵאָשֵׁ֖ר שְׁמֵנָ֣ה לַחְמֹ֑ו וְה֥וּא יִתֵּ֖ן מַֽעֲדַנֵּי־מֶֽלֶךְ׃ ס ");
INSERT INTO hbo_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","נַפְתָּלִ֖י אַיָּלָ֣ה שְׁלֻחָ֑ה הַנֹּתֵ֖ן אִמְרֵי־שָֽׁפֶר׃ ס ");
INSERT INTO hbo_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","בֵּ֤ן פֹּרָת֙ יֹוסֵ֔ף בֵּ֥ן פֹּרָ֖ת עֲלֵי־עָ֑יִן בָּנֹ֕ות צָעֲדָ֖ה עֲלֵי־שֽׁוּר׃ ");
INSERT INTO hbo_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","וַֽיְמָרֲרֻ֖הוּ וָרֹ֑בּוּ וַֽיִּשְׂטְמֻ֖הוּ בַּעֲלֵ֥י חִצִּֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","וַתֵּ֤שֶׁב בְּאֵיתָן֙ קַשְׁתֹּ֔ו וַיָּפֹ֖זּוּ זְרֹעֵ֣י יָדָ֑יו מִידֵי֙ אֲבִ֣יר יַעֲקֹ֔ב מִשָּׁ֥ם רֹעֶ֖ה אֶ֥בֶן יִשְׂרָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","מֵאֵ֨ל אָבִ֜יךָ וְיַעְזְרֶ֗ךָּ וְאֵ֤ת שַׁדַּי֙ וִיבָ֣רְכֶ֔ךָּ בִּרְכֹ֤ת שָׁמַ֙יִם֙ מֵעָ֔ל בִּרְכֹ֥ת תְּהֹ֖ום רֹבֶ֣צֶת תָּ֑חַת בִּרְכֹ֥ת שָׁדַ֖יִם וָרָֽחַם׃ ");
INSERT INTO hbo_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","בִּרְכֹ֣ת אָבִ֗יךָ גָּֽבְרוּ֙ עַל־בִּרְכֹ֣ת הֹורַ֔י עַֽד־תַּאֲוַ֖ת גִּבְעֹ֣ת עֹולָ֑ם תִּֽהְיֶ֙ין֙ לְרֹ֣אשׁ יֹוסֵ֔ף וּלְקָדְקֹ֖ד נְזִ֥יר אֶחָֽיו׃ פ ");
INSERT INTO hbo_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","בִּנְיָמִין֙ זְאֵ֣ב יִטְרָ֔ף בַּבֹּ֖קֶר יֹ֣אכַל עַ֑ד וְלָעֶ֖רֶב יְחַלֵּ֥ק שָׁלָֽל׃ ");
INSERT INTO hbo_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","כָּל־אֵ֛לֶּה שִׁבְטֵ֥י יִשְׂרָאֵ֖ל שְׁנֵ֣ים עָשָׂ֑ר וְ֠זֹאת אֲשֶׁר־דִּבֶּ֨ר לָהֶ֤ם אֲבִיהֶם֙ וַיְבָ֣רֶךְ אֹותָ֔ם אִ֛ישׁ אֲשֶׁ֥ר כְּבִרְכָתֹ֖ו בֵּרַ֥ךְ אֹתָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","וַיְצַ֣ו אֹותָ֗ם וַיֹּ֤אמֶר אֲלֵהֶם֙ אֲנִי֙ נֶאֱסָ֣ף אֶל־עַמִּ֔י קִבְר֥וּ אֹתִ֖י אֶל־אֲבֹתָ֑י אֶל־הַ֨מְּעָרָ֔ה אֲשֶׁ֥ר בִּשְׂדֵ֖ה עֶפְרֹ֥ון הֽ͏ַחִתִּֽי׃ ");
INSERT INTO hbo_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","בַּמְּעָרָ֞ה אֲשֶׁ֨ר בִּשְׂדֵ֧ה הַמַּכְפֵּלָ֛ה אֲשֶׁ֥ר עַל־פְּנֵי־מַמְרֵ֖א בְּאֶ֣רֶץ כְּנָ֑עַן אֲשֶׁר֩ קָנָ֨ה אַבְרָהָ֜ם אֶת־הַשָּׂדֶ֗ה מֵאֵ֛ת עֶפְרֹ֥ן הַחִתִּ֖י לַאֲחֻזַּת־קָֽבֶר׃ ");
INSERT INTO hbo_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","שָׁ֣מָּה קֽ͏ָבְר֞וּ אֶת־אַבְרָהָ֗ם וְאֵת֙ שָׂרָ֣ה אִשְׁתֹּ֔ו שָׁ֚מָּה קָבְר֣וּ אֶת־יִצְחָ֔ק וְאֵ֖ת רִבְקָ֣ה אִשְׁתֹּ֑ו וְשָׁ֥מָּה קָבַ֖רְתִּי אֶת־לֵאָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","מִקְנֵ֧ה הַשָּׂדֶ֛ה וְהַמְּעָרָ֥ה אֲשֶׁר־בֹּ֖ו מֵאֵ֥ת בְּנֵי־חֵֽת׃ ");
INSERT INTO hbo_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","וַיְכַ֤ל יַעֲקֹב֙ לְצַוֹּ֣ת אֶת־בָּנָ֔יו וַיֶּאֱסֹ֥ף רַגְלָ֖יו אֶל־הַמִּטָּ֑ה וַיִּגְוַ֖ע וַיֵּאָ֥סֶף אֶל־עַמָּֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","וַיִּפֹּ֥ל יֹוסֵ֖ף עַל־פְּנֵ֣י אָבִ֑יו וַיֵּ֥בְךְּ עָלָ֖יו וַיִּשַּׁק־לֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","וַיְצַ֨ו יֹוסֵ֤ף אֶת־עֲבָדָיו֙ אֶת־הָרֹ֣פְאִ֔ים לַחֲנֹ֖ט אֶת־אָבִ֑יו וַיַּחַנְט֥וּ הָרֹפְאִ֖ים אֶת־יִשְׂרָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","וַיִּמְלְאוּ־לֹו֙ אַרְבָּעִ֣ים יֹ֔ום כִּ֛י כֵּ֥ן יִמְלְא֖וּ יְמֵ֣י הַחֲנֻטִ֑ים וַיִּבְכּ֥וּ אֹתֹ֛ו מִצְרַ֖יִם שִׁבְעִ֥ים יֹֽום׃ ");
INSERT INTO hbo_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","וַיַּֽעַבְרוּ֙ יְמֵ֣י בְכִיתֹ֔ו וַיְדַבֵּ֣ר יֹוסֵ֔ף אֶל־בֵּ֥ית פַּרְעֹ֖ה לֵאמֹ֑ר אִם־נָ֨א מָצָ֤אתִי חֵן֙ בְּעֵ֣ינֵיכֶ֔ם דַּבְּרוּ־נָ֕א בְּאָזְנֵ֥י פַרְעֹ֖ה לֵאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","אָבִ֞י הִשְׁבִּיעַ֣נִי לֵאמֹ֗ר הִנֵּ֣ה אָנֹכִי֮ מֵת֒ בְּקִבְרִ֗י אֲשֶׁ֨ר כָּרִ֤יתִי לִי֙ בְּאֶ֣רֶץ כְּנַ֔עַן שָׁ֖מָּה תִּקְבְּרֵ֑נִי וְעַתָּ֗ה אֶֽעֱלֶה־נָּ֛א וְאֶקְבְּרָ֥ה אֶת־אָבִ֖י וְאָשֽׁוּבָה׃ ");
INSERT INTO hbo_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","וַיֹּ֖אמֶר פַּרְעֹ֑ה עֲלֵ֛ה וּקְבֹ֥ר אֶת־אָבִ֖יךָ כַּאֲשֶׁ֥ר הִשְׁבִּיעֶֽךָ׃ ");
INSERT INTO hbo_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","וַיַּ֥עַל יֹוסֵ֖ף לִקְבֹּ֣ר אֶת־אָבִ֑יו וַיּֽ͏ַעֲל֨וּ אִתֹּ֜ו כָּל־עַבְדֵ֤י פַרְעֹה֙ זִקְנֵ֣י בֵיתֹ֔ו וְכֹ֖ל זִקְנֵ֥י אֶֽרֶץ־מִצְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","וְכֹל֙ בֵּ֣ית יֹוסֵ֔ף וְאֶחָ֖יו וּבֵ֣ית אָבִ֑יו רַ֗ק טַפָּם֙ וְצֹאנָ֣ם וּבְקָרָ֔ם עָזְב֖וּ בְּאֶ֥רֶץ גֹּֽשֶׁן׃ ");
INSERT INTO hbo_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","וַיַּ֣עַל עִמֹּ֔ו גַּם־רֶ֖כֶב גַּם־פָּרָשִׁ֑ים וַיְהִ֥י הַֽמַּחֲנֶ֖ה כָּבֵ֥ד מְאֹֽד׃ ");
INSERT INTO hbo_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","וַיָּבֹ֜אוּ עַד־גֹּ֣רֶן הָאָטָ֗ד אֲשֶׁר֙ בְּעֵ֣בֶר הַיַּרְדֵּ֔ן וַיִּ֨סְפְּדוּ־שָׁ֔ם מִסְפֵּ֛ד גָּדֹ֥ול וְכָבֵ֖ד מְאֹ֑ד וַיַּ֧עַשׂ לְאָבִ֛יו אֵ֖בֶל שִׁבְעַ֥ת יָמִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","וַיַּ֡רְא יֹושֵׁב֩ הָאָ֨רֶץ הַֽכְּנַעֲנִ֜י אֶת־הָאֵ֗בֶל בְּגֹ֙רֶן֙ הָֽאָטָ֔ד וַיֹּ֣אמְר֔וּ אֵֽבֶל־כָּבֵ֥ד זֶ֖ה לְמִצְרָ֑יִם עַל־כֵּ֞ן קָרָ֤א שְׁמָהּ֙ אָבֵ֣ל מִצְרַ֔יִם אֲשֶׁ֖ר בְּעֵ֥בֶר הַיַּרְדֵּֽן׃ ");
INSERT INTO hbo_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","וַיַּעֲשׂ֥וּ בָנָ֖יו לֹ֑ו כֵּ֖ן כַּאֲשֶׁ֥ר צִוָּֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","וַיִּשְׂא֨וּ אֹתֹ֤ו בָנָיו֙ אַ֣רְצָה כְּנַ֔עַן וַיִּקְבְּר֣וּ אֹתֹ֔ו בִּמְעָרַ֖ת שְׂדֵ֣ה הַמַּכְפֵּלָ֑ה אֲשֶׁ֣ר קָנָה֩ אַבְרָהָ֨ם אֶת־הַשָּׂדֶ֜ה לַאֲחֻזַּת־קֶ֗בֶר מֵאֵ֛ת עֶפְרֹ֥ן הַחִתִּ֖י עַל־פְּנֵ֥י מַמְרֵֽא׃ ");
INSERT INTO hbo_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","וַיָּ֨שָׁב יֹוסֵ֤ף מִצְרַ֙יְמָה֙ ה֣וּא וְאֶחָ֔יו וְכָל־הָעֹלִ֥ים אִתֹּ֖ו לִקְבֹּ֣ר אֶת־אָבִ֑יו אַחֲרֵ֖י קָבְרֹ֥ו אֶת־אָבִֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","וַיִּרְא֤וּ אֲחֵֽי־יֹוסֵף֙ כִּי־מֵ֣ת אֲבִיהֶ֔ם וַיֹּ֣אמְר֔וּ ל֥וּ יִשְׂטְמֵ֖נוּ יֹוסֵ֑ף וְהָשֵׁ֤ב יָשִׁיב֙ לָ֔נוּ אֵ֚ת כָּל־הָ֣רָעָ֔ה אֲשֶׁ֥ר גָּמַ֖לְנוּ אֹתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","וַיְצַוּ֕וּ אֶל־יֹוסֵ֖ף לֵאמֹ֑ר אָבִ֣יךָ צִוָּ֔ה לִפְנֵ֥י מֹותֹ֖ו לֵאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","כֹּֽה־תֹאמְר֣וּ לְיֹוסֵ֗ף אָ֣נָּ֡א שָׂ֣א נָ֠א פֶּ֣שַׁע אַחֶ֤יךָ וְחַטָּאתָם֙ כִּי־רָעָ֣ה גְמָל֔וּךָ וְעַתָּה֙ שָׂ֣א נָ֔א לְפֶ֥שַׁע עַבְדֵ֖י אֱלֹהֵ֣י אָבִ֑יךָ וַיֵּ֥בְךְּ יֹוסֵ֖ף בְּדַבְּרָ֥ם אֵלָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","וַיֵּלְכוּ֙ גַּם־אֶחָ֔יו וֽ͏ַיִּפְּל֖וּ לְפָנָ֑יו וַיֹּ֣אמְר֔וּ הִנֶּ֥נּֽוּ לְךָ֖ לַעֲבָדִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","וַיֹּ֧אמֶר אֲלֵהֶ֛ם יֹוסֵ֖ף אַל־תִּירָ֑אוּ כִּ֛י הֲתַ֥חַת אֱלֹהִ֖ים אָֽנִי׃ ");
INSERT INTO hbo_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","וְאַתֶּ֕ם חֲשַׁבְתֶּ֥ם עָלַ֖י רָעָ֑ה אֱלֹהִים֙ חֲשָׁבָ֣הּ לְטֹבָ֔ה לְמַ֗עַן עֲשֹׂ֛ה כַּיֹּ֥ום הַזֶּ֖ה לְהַחֲיֹ֥ת עַם־רָֽב׃ ");
INSERT INTO hbo_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","וְעַתָּה֙ אַל־תִּירָ֔אוּ אָנֹכִ֛י אֲכַלְכֵּ֥ל אֶתְכֶ֖ם וְאֶֽת־טַפְּכֶ֑ם וַיְנַחֵ֣ם אֹותָ֔ם וַיְדַבֵּ֖ר עַל־לִבָּֽם׃ ");
INSERT INTO hbo_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","וַיֵּ֤שֶׁב יֹוסֵף֙ בְּמִצְרַ֔יִם ה֖וּא וּבֵ֣ית אָבִ֑יו וַיְחִ֣י יֹוסֵ֔ף מֵאָ֥ה וָעֶ֖שֶׂר שָׁנִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","וַיַּ֤רְא יֹוסֵף֙ לְאֶפְרַ֔יִם בְּנֵ֖י שִׁלֵּשִׁ֑ים גַּ֗ם בְּנֵ֤י מָכִיר֙ בֶּן־מְנַשֶּׁ֔ה יֻלְּד֖וּ עַל־בִּרְכֵּ֥י יֹוסֵֽף׃ ");
INSERT INTO hbo_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","וַיֹּ֤אמֶר יֹוסֵף֙ אֶל־אֶחָ֔יו אָנֹכִ֖י מֵ֑ת וֵֽאלֹהִ֞ים פָּקֹ֧ד יִפְקֹ֣ד אֶתְכֶ֗ם וְהֶעֱלָ֤ה אֶתְכֶם֙ מִן־הָאָ֣רֶץ הַזֹּ֔את אֶל־הָאָ֕רֶץ אֲשֶׁ֥ר נִשְׁבַּ֛ע לְאַבְרָהָ֥ם לְיִצְחָ֖ק וּֽלְיַעֲקֹֽב׃ ");
INSERT INTO hbo_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","וַיַּשְׁבַּ֣ע יֹוסֵ֔ף אֶת־בְּנֵ֥י יִשְׂרָאֵ֖ל לֵאמֹ֑ר פָּקֹ֨ד יִפְקֹ֤ד אֱלֹהִים֙ אֶתְכֶ֔ם וְהַעֲלִתֶ֥ם אֶת־עַצְמֹתַ֖י מִזֶּֽה׃ ");
INSERT INTO hbo_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","וַיָּ֣מָת יֹוסֵ֔ף בֶּן־מֵאָ֥ה וָעֶ֖שֶׂר שָׁנִ֑ים וַיַּחַנְט֣וּ אֹתֹ֔ו וַיִּ֥ישֶׂם בָּאָרֹ֖ון בְּמִצְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","וְאֵ֗לֶּה שְׁמֹות֙ בְּנֵ֣י יִשְׂרָאֵ֔ל הַבָּאִ֖ים מִצְרָ֑יְמָה אֵ֣ת יַעֲקֹ֔ב אִ֥ישׁ וּבֵיתֹ֖ו בָּֽאוּ׃ ");
INSERT INTO hbo_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","רְאוּבֵ֣ן שִׁמְעֹ֔ון לֵוִ֖י וִיהוּדָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","יִשָּׂשכָ֥ר זְבוּלֻ֖ן וּבְנְיָמִֽן׃ ");
INSERT INTO hbo_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","דָּ֥ן וְנַפְתָּלִ֖י גָּ֥ד וְאָשֵֽׁר׃ ");
INSERT INTO hbo_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","וֽ͏ַיְהִ֗י כָּל־נֶ֛פֶשׁ יֹצְאֵ֥י יֶֽרֶךְ־יַעֲקֹ֖ב שִׁבְעִ֣ים נָ֑פֶשׁ וְיֹוסֵ֖ף הָיָ֥ה בְמִצְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","וַיָּ֤מָת יֹוסֵף֙ וְכָל־אֶחָ֔יו וְכֹ֖ל הַדֹּ֥ור הַהֽוּא׃ ");
INSERT INTO hbo_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","וּבְנֵ֣י יִשְׂרָאֵ֗ל פָּר֧וּ וַֽיִּשְׁרְצ֛וּ וַיִּרְבּ֥וּ וַיַּֽעַצְמ֖וּ בִּמְאֹ֣ד מְאֹ֑ד וַתִּמָּלֵ֥א הָאָ֖רֶץ אֹתָֽם׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","וַיָּ֥קָם מֶֽלֶךְ־חָדָ֖שׁ עַל־מִצְרָ֑יִם אֲשֶׁ֥ר לֹֽא־יָדַ֖ע אֶת־יֹוסֵֽף׃ ");
INSERT INTO hbo_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","וַיֹּ֖אמֶר אֶל־עַמֹּ֑ו הִנֵּ֗ה עַ֚ם בְּנֵ֣י יִשְׂרָאֵ֔ל רַ֥ב וְעָצ֖וּם מִמֶּֽנּוּ׃ ");
INSERT INTO hbo_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","הָ֥בָה נִֽתְחַכְּמָ֖ה לֹ֑ו פֶּן־יִרְבֶּ֗ה וְהָיָ֞ה כִּֽי־תִקְרֶ֤אנָה מִלְחָמָה֙ וְנֹוסַ֤ף גַּם־הוּא֙ עַל־שֹׂ֣נְאֵ֔ינוּ וְנִלְחַם־בָּ֖נוּ וְעָלָ֥ה מִן־הָאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","וַיָּשִׂ֤ימוּ עָלָיו֙ שָׂרֵ֣י מִסִּ֔ים לְמַ֥עַן עַנֹּתֹ֖ו בְּסִבְלֹתָ֑ם וַיִּ֜בֶן עָרֵ֤י מִסְכְּנֹות֙ לְפַרְעֹ֔ה אֶת־פִּתֹ֖ם וְאֶת־רַעַמְסֵֽס׃ ");
INSERT INTO hbo_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","וְכַאֲשֶׁר֙ יְעַנּ֣וּ אֹתֹ֔ו כֵּ֥ן יִרְבֶּ֖ה וְכֵ֣ן יִפְרֹ֑ץ וַיָּקֻ֕צוּ מִפְּנֵ֖י בְּנֵ֥י יִשְׂרָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","וַיַּעֲבִ֧דוּ מִצְרַ֛יִם אֶת־בְּנֵ֥י יִשְׂרָאֵ֖ל בְּפָֽרֶךְ׃ ");
INSERT INTO hbo_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","וַיְמָרְר֨וּ אֶת־חַיֵּיהֶ֜ם בַּעֲבֹדָ֣ה קָשָׁ֗ה בְּחֹ֙מֶר֙ וּבִלְבֵנִ֔ים וּבְכָל־עֲבֹדָ֖ה בַּשָּׂדֶ֑ה אֵ֚ת כָּל־עֲבֹ֣דָתָ֔ם אֲשֶׁר־עָבְד֥וּ בָהֶ֖ם בְּפָֽרֶךְ׃ ");
INSERT INTO hbo_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","וַיֹּ֙אמֶר֙ מֶ֣לֶךְ מִצְרַ֔יִם לַֽמְיַלְּדֹ֖ת הָֽעִבְרִיֹּ֑ת אֲשֶׁ֨ר שֵׁ֤ם הָֽאַחַת֙ שִׁפְרָ֔ה וְשֵׁ֥ם הַשֵּׁנִ֖ית פּוּעָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","וַיֹּ֗אמֶר בְּיַלֶּדְכֶן֙ אֶת־הָֽעִבְרִיֹּ֔ות וּרְאִיתֶ֖ן עַל־הָאָבְנָ֑יִם אִם־בֵּ֥ן הוּא֙ וַהֲמִתֶּ֣ן אֹתֹ֔ו וְאִם־בַּ֥ת הִ֖יא וָחָֽיָה׃ ");
INSERT INTO hbo_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","וַתִּירֶ֤אןָ הַֽמְיַלְּדֹת֙ אֶת־הָ֣אֱלֹהִ֔ים וְלֹ֣א עָשׂ֔וּ כַּאֲשֶׁ֛ר דִּבֶּ֥ר אֲלֵיהֶ֖ן מֶ֣לֶךְ מִצְרָ֑יִם וַתְּחַיֶּ֖יןָ אֶת־הַיְלָדִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","וַיִּקְרָ֤א מֶֽלֶךְ־מִצְרַ֙יִם֙ לַֽמְיַלְּדֹ֔ת וַיֹּ֣אמֶר לָהֶ֔ן מַדּ֥וּעַ עֲשִׂיתֶ֖ן הַדָּבָ֣ר הַזֶּ֑ה וַתְּחַיֶּ֖יןָ אֶת־הַיְלָדִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","וַתֹּאמַ֤רְןָ הַֽמְיַלְּדֹת֙ אֶל־פַּרְעֹ֔ה כִּ֣י לֹ֧א כַנָּשִׁ֛ים הַמִּצְרִיֹּ֖ת הָֽעִבְרִיֹּ֑ת כִּֽי־חָיֹ֣ות הֵ֔נָּה בְּטֶ֨רֶם תָּבֹ֧וא אֲלֵהֶ֛ן הַמְיַלֶּ֖דֶת וְיָלָֽדוּ׃ ");
INSERT INTO hbo_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","וַיֵּ֥יטֶב אֱלֹהִ֖ים לַֽמְיַלְּדֹ֑ת וַיִּ֧רֶב הָעָ֛ם וַיַּֽעַצְמ֖וּ מְאֹֽד׃ ");
INSERT INTO hbo_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","וַיְהִ֕י כִּֽי־יָֽרְא֥וּ הַֽמְיַלְּדֹ֖ת אֶת־הָאֱלֹהִ֑ים וַיַּ֥עַשׂ לָהֶ֖ם בָּתִּֽים׃ ");
INSERT INTO hbo_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","וַיְצַ֣ו פַּרְעֹ֔ה לְכָל־עַמֹּ֖ו לֵאמֹ֑ר כָּל־הַבֵּ֣ן הַיִּלֹּ֗וד הַיְאֹ֙רָה֙ תַּשְׁלִיכֻ֔הוּ וְכָל־הַבַּ֖ת תְּחַיּֽוּן׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","וַיֵּ֥לֶךְ אִ֖ישׁ מִבֵּ֣ית לֵוִ֑י וַיִּקַּ֖ח אֶת־בַּת־לֵוִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","וַתַּ֥הַר הָאִשָּׁ֖ה וַתֵּ֣לֶד בֵּ֑ן וַתֵּ֤רֶא אֹתֹו֙ כִּי־טֹ֣וב ה֔וּא וַֽתִּצְפְּנֵ֖הוּ שְׁלֹשָׁ֥ה יְרָחִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","וְלֹא־יָכְלָ֣ה עֹוד֮ הַצְּפִינֹו֒ וַתִּֽקַּֽח־לֹו֙ תֵּ֣בַת גֹּ֔מֶא וַתַּחְמְרָ֥ה בַחֵמָ֖ר וּבַזָּ֑פֶת וַתָּ֤שֶׂם בָּהּ֙ אֶת־הַיֶּ֔לֶד וַתָּ֥שֶׂם בַּסּ֖וּף עַל־שְׂפַ֥ת הַיְאֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","וַתֵּתַצַּ֥ב אֲחֹתֹ֖ו מֵרָחֹ֑ק לְדֵעָ֕ה מַה־יֵּעָשֶׂ֖ה לֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","וַתֵּ֤רֶד בַּת־פַּרְעֹה֙ לִרְחֹ֣ץ עַל־הַיְאֹ֔ר וְנַעֲרֹתֶ֥יהָ הֹלְכֹ֖ת עַל־יַ֣ד הַיְאֹ֑ר וַתֵּ֤רֶא אֶת־הַתֵּבָה֙ בְּתֹ֣וךְ הַסּ֔וּף וַתִּשְׁלַ֥ח אֶת־אֲמָתָ֖הּ וַתִּקָּחֶֽהָ: ");
INSERT INTO hbo_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","וַתִּפְתַּח֙ וַתִּרְאֵ֣הוּ אֶת־הַיֶּ֔לֶד וְהִנֵּה־נַ֖עַר בֹּכֶ֑ה וַתַּחְמֹ֣ל עָלָ֔יו וַתֹּ֕אמֶר מִיַּלְדֵ֥י הָֽעִבְרִ֖ים זֶֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","וַתֹּ֣אמֶר אֲחֹתֹו֮ אֶל־בַּת־פַּרְעֹה֒ הַאֵלֵ֗ךְ וְקָרָ֤אתִי לָךְ֙ אִשָּׁ֣ה מֵינֶ֔קֶת מִ֖ן הָעִבְרִיֹּ֑ת וְתֵינִ֥ק לָ֖ךְ אֶת־הַיָּֽלֶד׃ ");
INSERT INTO hbo_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","וַתֹּֽאמֶר־לָ֥הּ בַּת־פַּרְעֹ֖ה לֵ֑כִי וַתֵּ֙לֶךְ֙ הָֽעַלְמָ֔ה וַתִּקְרָ֖א אֶת־אֵ֥ם הַיָּֽלֶד׃ ");
INSERT INTO hbo_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","וַתֹּ֧אמֶר לָ֣הּ בַּת־פַּרְעֹ֗ה הֵילִ֜יכִי אֶת־הַיֶּ֤לֶד הַזֶּה֙ וְהֵינִקִ֣הוּ לִ֔י וַאֲנִ֖י אֶתֵּ֣ן אֶת־שְׂכָרֵ֑ךְ וַתִּקַּ֧ח הָאִשָּׁ֛ה הַיֶּ֖לֶד וַתְּנִיקֵֽהוּ׃ ");
INSERT INTO hbo_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","וַיִגְדַּ֣ל הַיֶּ֗לֶד וַתְּבִאֵ֙הוּ֙ לְבַת־פַּרְעֹ֔ה וֽ͏ַיְהִי־לָ֖הּ לְבֵ֑ן וַתִּקְרָ֤א שְׁמֹו֙ מֹשֶׁ֔ה וַתֹּ֕אמֶר כִּ֥י מִן־הַמַּ֖יִם מְשִׁיתִֽהוּ׃ ");
INSERT INTO hbo_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","וַיְהִ֣י ׀ בַּיָּמִ֣ים הָהֵ֗ם וַיִּגְדַּ֤ל מֹשֶׁה֙ וַיֵּצֵ֣א אֶל־אֶחָ֔יו וַיַּ֖רְא בְּסִבְלֹתָ֑ם וַיַּרְא֙ אִ֣ישׁ מִצְרִ֔י מַכֶּ֥ה אִישׁ־עִבְרִ֖י מֵאֶחָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","וַיִּ֤פֶן כֹּה֙ וָכֹ֔ה וַיַּ֖רְא כִּ֣י אֵ֣ין אִ֑ישׁ וַיַּךְ֙ אֶת־הַמִּצְרִ֔י וַֽיִּטְמְנֵ֖הוּ בַּחֹֽול׃ ");
INSERT INTO hbo_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","וַיֵּצֵא֙ בַּיֹּ֣ום הַשֵּׁנִ֔י וְהִנֵּ֛ה שְׁנֵֽי־אֲנָשִׁ֥ים עִבְרִ֖ים נִצִּ֑ים וַיֹּ֙אמֶר֙ לָֽרָשָׁ֔ע לָ֥מָּה תַכֶּ֖ה רֵעֶֽךָ׃ ");
INSERT INTO hbo_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","וַ֠יֹּאמֶר מִ֣י שָֽׂמְךָ֞ לְאִ֨ישׁ שַׂ֤ר וְשֹׁפֵט֙ עָלֵ֔ינוּ הַלְהָרְגֵ֙נִי֙ אַתָּ֣ה אֹמֵ֔ר כַּאֲשֶׁ֥ר הָרַ֖גְתָּ אֶת־הַמִּצְרִ֑י וַיִּירָ֤א מֹשֶׁה֙ וַיֹּאמַ֔ר אָכֵ֖ן נֹודַ֥ע הַדָּבָֽר׃ ");
INSERT INTO hbo_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","וַיִּשְׁמַ֤ע פַּרְעֹה֙ אֶת־הַדָּבָ֣ר הַזֶּ֔ה וַיְבַקֵּ֖שׁ לַהֲרֹ֣ג אֶת־מֹשֶׁ֑ה וַיִּבְרַ֤ח מֹשֶׁה֙ מִפְּנֵ֣י פַרְעֹ֔ה וַיֵּ֥שֶׁב בְּאֶֽרֶץ־מִדְיָ֖ן וַיֵּ֥שֶׁב עַֽל־הַבְּאֵֽר׃ ");
INSERT INTO hbo_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","וּלְכֹהֵ֥ן מִדְיָ֖ן שֶׁ֣בַע בָּנֹ֑ות וַתָּבֹ֣אנָה וַתִּדְלֶ֗נָה וַתְּמַלֶּ֙אנָה֙ אֶת־הָ֣רְהָטִ֔ים לְהַשְׁקֹ֖ות צֹ֥אן אֲבִיהֶֽן׃ ");
INSERT INTO hbo_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","וַיָּבֹ֥אוּ הָרֹעִ֖ים וַיְגָרְשׁ֑וּם וַיָּ֤קָם מֹשֶׁה֙ וַיֹּ֣ושִׁעָ֔ן וַיַּ֖שְׁקְ אֶת־צֹאנָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","וַתָּבֹ֕אנָה אֶל־רְעוּאֵ֖ל אֲבִיהֶ֑ן וַיֹּ֕אמֶר מַדּ֛וּעַ מִהַרְתֶּ֥ן בֹּ֖א הַיֹּֽום׃ ");
INSERT INTO hbo_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","וַתֹּאמַ֕רְןָ אִ֣ישׁ מִצְרִ֔י הִצִּילָ֖נוּ מִיַּ֣ד הָרֹעִ֑ים וְגַם־דָּלֹ֤ה דָלָה֙ לָ֔נוּ וַיַּ֖שְׁקְ אֶת־הַצֹּֽאן׃ ");
INSERT INTO hbo_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","וַיֹּ֥אמֶר אֶל־בְּנֹתָ֖יו וְאַיֹּ֑ו לָ֤מָּה זֶּה֙ עֲזַבְתֶּ֣ן אֶת־הָאִ֔ישׁ קִרְאֶ֥ן לֹ֖ו וְיֹ֥אכַל לָֽחֶם׃ ");
INSERT INTO hbo_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","וַיֹּ֥ואֶל מֹשֶׁ֖ה לָשֶׁ֣בֶת אֶת־הָאִ֑ישׁ וַיִּתֵּ֛ן אֶת־צִפֹּרָ֥ה בִתֹּ֖ו לְמֹשֶֽׁה׃ ");
INSERT INTO hbo_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","וַתֵּ֣לֶד בֵּ֔ן וַיִּקְרָ֥א אֶת־שְׁמֹ֖ו גֵּרְשֹׁ֑ם כִּ֣י אָמַ֔ר גֵּ֣ר הָיִ֔יתִי בְּאֶ֖רֶץ נָכְרִיָּֽה׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","וַיְהִי֩ בַיָּמִ֨ים הֽ͏ָרַבִּ֜ים הָהֵ֗ם וַיָּ֙מָת֙ מֶ֣לֶךְ מִצְרַ֔יִם וַיֵּאָנְח֧וּ בְנֵֽי־יִשְׂרָאֵ֛ל מִן־הָעֲבֹדָ֖ה וַיִּזְעָ֑קוּ וַתַּ֧עַל שַׁוְעָתָ֛ם אֶל־הָאֱלֹהִ֖ים מִן־הָעֲבֹדָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","וַיִּשְׁמַ֥ע אֱלֹהִ֖ים אֶת־נַאֲקָתָ֑ם וַיִּזְכֹּ֤ר אֱלֹהִים֙ אֶת־בְּרִיתֹ֔ו אֶת־אַבְרָהָ֖ם אֶת־יִצְחָ֥ק וְאֶֽת־יַעֲקֹֽב׃ ");
INSERT INTO hbo_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","וַיַּ֥רְא אֱלֹהִ֖ים אֶת־בְּנֵ֣י יִשְׂרָאֵ֑ל וַיֵּ֖דַע אֱלֹהִֽים׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","וּמֹשֶׁ֗ה הָיָ֥ה רֹעֶ֛ה אֶת־צֹ֛אן יִתְרֹ֥ו חֹתְנֹ֖ו כֹּהֵ֣ן מִדְיָ֑ן וַיִּנְהַ֤ג אֶת־הַצֹּאן֙ אַחַ֣ר הַמִּדְבָּ֔ר וַיָּבֹ֛א אֶל־הַ֥ר הָאֱלֹהִ֖ים חֹרֵֽבָה׃ ");
INSERT INTO hbo_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","וַ֠יֵּרָא מַלְאַ֨ךְ יְהֹוָ֥ה אֵלָ֛יו בְּלַבַּת־אֵ֖שׁ מִתֹּ֣וךְ הַסְּנֶ֑ה וַיַּ֗רְא וְהִנֵּ֤ה הַסְּנֶה֙ בֹּעֵ֣ר בָּאֵ֔שׁ וְהַסְּנֶ֖ה אֵינֶ֥נּוּ אֻכָּֽל׃ ");
INSERT INTO hbo_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","וַיֹּ֣אמֶר מֹשֶׁ֔ה אָסֻֽרָה־נָּ֣א וְאֶרְאֶ֔ה אֶת־הַמַּרְאֶ֥ה הַגָּדֹ֖ל הַזֶּ֑ה מַדּ֖וּעַ לֹא־יִבְעַ֥ר הַסְּנֶֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","וַיַּ֥רְא יְהוָ֖ה כִּ֣י סָ֣ר לִרְאֹ֑ות וַיִּקְרָא֩ אֵלָ֨יו אֱלֹהִ֜ים מִתֹּ֣וךְ הַסְּנֶ֗ה וַיֹּ֛אמֶר מֹשֶׁ֥ה מֹשֶׁ֖ה וַיֹּ֥אמֶר הִנֵּֽנִי׃ ");
INSERT INTO hbo_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","וַיֹּ֖אמֶר אַל־תִּקְרַ֣ב הֲלֹ֑ם שַׁל־נְעָלֶ֙יךָ֙ מֵעַ֣ל רַגְלֶ֔יךָ כִּ֣י הַמָּקֹ֗ום אֲשֶׁ֤ר אַתָּה֙ עֹומֵ֣ד עָלָ֔יו אַדְמַת־קֹ֖דֶשׁ הֽוּא׃ ");
INSERT INTO hbo_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","וַיֹּ֗אמֶר אָנֹכִי֙ אֱלֹהֵ֣י אָבִ֔יךָ אֱלֹהֵ֧י אַבְרָהָ֛ם אֱלֹהֵ֥י יִצְחָ֖ק וֵאלֹהֵ֣י יַעֲקֹ֑ב וַיַּסְתֵּ֤ר מֹשֶׁה֙ פָּנָ֔יו כִּ֣י יָרֵ֔א מֵהַבִּ֖יט אֶל־הָאֱלֹהִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","וַיֹּ֣אמֶר יְהוָ֔ה רָאֹ֥ה רָאִ֛יתִי אֶת־עֳנִ֥י עַמִּ֖י אֲשֶׁ֣ר בְּמִצְרָ֑יִם וְאֶת־צַעֲקָתָ֤ם שָׁמַ֙עְתִּי֙ מִפְּנֵ֣י נֹֽגְשָׂ֔יו כִּ֥י יָדַ֖עְתִּי אֶת־מַכְאֹבָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","וָאֵרֵ֞ד לְהַצִּילֹ֣ו ׀ מִיַּ֣ד מִצְרַ֗יִם וּֽלְהַעֲלֹתֹו֮ מִן־הָאָ֣רֶץ הַהִוא֒ אֶל־אֶ֤רֶץ טֹובָה֙ וּרְחָבָ֔ה אֶל־אֶ֛רֶץ זָבַ֥ת חָלָ֖ב וּדְבָ֑שׁ אֶל־מְקֹ֤ום הַֽכְּנַעֲנִי֙ וְהַ֣חִתִּ֔י וְהָֽאֱמֹרִי֙ וְהַפְּרִזִּ֔י וְהַחִוִּ֖י וְהַיְבוּסִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","וְעַתָּ֕ה הִנֵּ֛ה צַעֲקַ֥ת בְּנֵי־יִשְׂרָאֵ֖ל בָּ֣אָה אֵלָ֑י וְגַם־רָאִ֙יתִי֙ אֶת־הַלַּ֔חַץ אֲשֶׁ֥ר מִצְרַ֖יִם לֹחֲצִ֥ים אֹתָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","וְעַתָּ֣ה לְכָ֔ה וְאֶֽשְׁלָחֲךָ֖ אֶל־פַּרְעֹ֑ה וְהֹוצֵ֛א אֶת־עַמִּ֥י בְנֵֽי־יִשְׂרָאֵ֖ל מִמִּצְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","וַיֹּ֤אמֶר מֹשֶׁה֙ אֶל־הָ֣אֱלֹהִ֔ים מִ֣י אָנֹ֔כִי כִּ֥י אֵלֵ֖ךְ אֶל־פַּרְעֹ֑ה וְכִ֥י אֹוצִ֛יא אֶת־בְּנֵ֥י יִשְׂרָאֵ֖ל מִמִּצְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","וַיֹּ֙אמֶר֙ כִּֽי־אֶֽהְיֶ֣ה עִמָּ֔ךְ וְזֶה־לְּךָ֣ הָאֹ֔ות כִּ֥י אָנֹכִ֖י שְׁלַחְתִּ֑יךָ בְּהֹוצִֽיאֲךָ֤ אֶת־הָעָם֙ מִמִּצְרַ֔יִם תַּֽעַבְדוּן֙ אֶת־הָ֣אֱלֹהִ֔ים עַ֖ל הָהָ֥ר הַזֶּֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","וַיֹּ֨אמֶר מֹשֶׁ֜ה אֶל־הָֽאֱלֹהִ֗ים הִנֵּ֨ה אָנֹכִ֣י בָא֮ אֶל־בְּנֵ֣י יִשְׂרָאֵל֒ וְאָמַרְתִּ֣י לָהֶ֔ם אֱלֹהֵ֥י אֲבֹותֵיכֶ֖ם שְׁלָחַ֣נִי אֲלֵיכֶ֑ם וְאָֽמְרוּ־לִ֣י מַה־שְּׁמֹ֔ו מָ֥ה אֹמַ֖ר אֲלֵהֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","וַיֹּ֤אמֶר אֱלֹהִים֙ אֶל־מֹשֶׁ֔ה אֶֽהְיֶ֖ה אֲשֶׁ֣ר אֶֽהְיֶ֑ה וַיֹּ֗אמֶר כֹּ֤ה תֹאמַר֙ לִבְנֵ֣י יִשְׂרָאֵ֔ל אֶֽהְיֶ֖ה שְׁלָחַ֥נִי אֲלֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","וַיֹּאמֶר֩ עֹ֨וד אֱלֹהִ֜ים אֶל־מֹשֶׁ֗ה כֹּֽה־תֹאמַר֮ אֶל־בְּנֵ֣י יִשְׂרָאֵל֒ יְהוָ֞ה אֱלֹהֵ֣י אֲבֹתֵיכֶ֗ם אֱלֹהֵ֨י אַבְרָהָ֜ם אֱלֹהֵ֥י יִצְחָ֛ק וֵאלֹהֵ֥י יַעֲקֹ֖ב שְׁלָחַ֣נִי אֲלֵיכֶ֑ם זֶה־שְּׁמִ֣י לְעֹלָ֔ם וְזֶ֥ה זִכְרִ֖י לְדֹ֥ר דֹּֽר׃ ");
INSERT INTO hbo_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","לֵ֣ךְ וְאָֽסַפְתָּ֞ אֶת־זִקְנֵ֣י יִשְׂרָאֵ֗ל וְאָמַרְתָּ֤ אֲלֵהֶם֙ יְהוָ֞ה אֱלֹהֵ֤י אֲבֹֽתֵיכֶם֙ נִרְאָ֣ה אֵלַ֔י אֱלֹהֵ֧י אַבְרָהָ֛ם יִצְחָ֥ק וְיַעֲקֹ֖ב לֵאמֹ֑ר פָּקֹ֤ד פָּקַ֙דְתִּי֙ אֶתְכֶ֔ם וְאֶת־הֶעָשׂ֥וּי לָכֶ֖ם בְּמִצְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","וָאֹמַ֗ר אַעֲלֶ֣ה אֶתְכֶם֮ מֵעֳנִ֣י מִצְרַיִם֒ אֶל־אֶ֤רֶץ הַֽכְּנַעֲנִי֙ וְהַ֣חִתִּ֔י וְהָֽאֱמֹרִי֙ וְהַפְּרִזִּ֔י וְהַחִוִּ֖י וְהַיְבוּסִ֑י אֶל־אֶ֛רֶץ זָבַ֥ת חָלָ֖ב וּדְבָֽשׁ׃ ");
INSERT INTO hbo_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","וְשָׁמְע֖וּ לְקֹלֶ֑ךָ וּבָאתָ֡ אַתָּה֩ וְזִקְנֵ֨י יִשְׂרָאֵ֜ל אֶל־מֶ֣לֶךְ מִצְרַ֗יִם וַאֲמַרְתֶּ֤ם אֵלָיו֙ יְהוָ֞ה אֱלֹהֵ֤י הָֽעִבְרִיִּים֙ נִקְרָ֣ה עָלֵ֔ינוּ וְעַתָּ֗ה נֵֽלֲכָה־נָּ֞א דֶּ֣רֶךְ שְׁלֹ֤שֶׁת יָמִים֙ בַּמִּדְבָּ֔ר וְנִזְבְּחָ֖ה לַֽיהוָ֥ה אֱלֹהֵֽינוּ׃ ");
INSERT INTO hbo_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","וַאֲנִ֣י יָדַ֔עְתִּי כִּ֠י לֹֽא־יִתֵּ֥ן אֶתְכֶ֛ם מֶ֥לֶךְ מִצְרַ֖יִם לַהֲלֹ֑ךְ וְלֹ֖א בְּיָ֥ד חֲזָקָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","וְשָׁלַחְתִּ֤י אֶת־יָדִי֙ וְהִכֵּיתִ֣י אֶת־מִצְרַ֔יִם בְּכֹל֙ נִפְלְאֹתַ֔י אֲשֶׁ֥ר אֽ͏ֶעֱשֶׂ֖ה בְּקִרְבֹּ֑ו וְאַחֲרֵי־כֵ֖ן יְשַׁלַּ֥ח אֶתְכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","וְנָתַתִּ֛י אֶת־חֵ֥ן הָֽעָם־הַזֶּ֖ה בְּעֵינֵ֣י מִצְרָ֑יִם וְהָיָה֙ כִּ֣י תֵֽלֵכ֔וּן לֹ֥א תֵלְכ֖וּ רֵיקָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","וְשָׁאֲלָ֨ה אִשָּׁ֤ה מִשְּׁכֶנְתָּהּ֙ וּמִגָּרַ֣ת בֵּיתָ֔הּ כְּלֵי־כֶ֛סֶף וּכְלֵ֥י זָהָ֖ב וּשְׂמָלֹ֑ת וְשַׂמְתֶּ֗ם עַל־בְּנֵיכֶם֙ וְעַל־בְּנֹ֣תֵיכֶ֔ם וְנִצַּלְתֶּ֖ם אֶת־מִצְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","וַיַּ֤עַן מֹשֶׁה֙ וַיֹּ֔אמֶר וְהֵן֙ לֹֽא־יַאֲמִ֣ינוּ לִ֔י וְלֹ֥א יִשְׁמְע֖וּ בְּקֹלִ֑י כִּ֣י יֹֽאמְר֔וּ לֹֽא־נִרְאָ֥ה אֵלֶ֖יךָ יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","וַיֹּ֧אמֶר אֵלָ֛יו יְהוָ֖ה *מַזֶּה (מַה־זֶּ֣ה) בְיָדֶ֑ךָ וַיֹּ֖אמֶר מַטֶּֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","וַיֹּ֙אמֶר֙ הַשְׁלִיכֵ֣הוּ אַ֔רְצָה וַיַּשְׁלִיכֵ֥הוּ אַ֖רְצָה וַיְהִ֣י לְנָחָ֑שׁ וַיָּ֥נָס מֹשֶׁ֖ה מִפָּנָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","וַיֹּ֤אמֶר יְהוָה֙ אֶל־מֹשֶׁ֔ה שְׁלַח֙ יָֽדְךָ֔ וֶאֱחֹ֖ז בִּזְנָבֹ֑ו וַיִּשְׁלַ֤ח יָדֹו֙ וַיַּ֣חֲזֶק בֹּ֔ו וַיְהִ֥י לְמַטֶּ֖ה בְּכַפֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","לְמַ֣עַן יַאֲמִ֔ינוּ כִּֽי־נִרְאָ֥ה אֵלֶ֛יךָ יְהוָ֖ה אֱלֹהֵ֣י אֲבֹתָ֑ם אֱלֹהֵ֧י אַבְרָהָ֛ם אֱלֹהֵ֥י יִצְחָ֖ק וֵאלֹהֵ֥י יַעֲקֹֽב׃ ");
INSERT INTO hbo_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","וַיֹּאמֶר֩ יְהוָ֨ה לֹ֜ו עֹ֗וד הָֽבֵא־נָ֤א יָֽדְךָ֙ בְּחֵיקֶ֔ךָ וַיָּבֵ֥א יָדֹ֖ו בְּחֵיקֹ֑ו וַיֹּ֣וצִאָ֔הּ וְהִנֵּ֥ה יָדֹ֖ו מְצֹרַ֥עַת כַּשָּֽׁלֶג׃ ");
INSERT INTO hbo_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","וַיֹּ֗אמֶר הָשֵׁ֤ב יָֽדְךָ֙ אֶל־חֵיקֶ֔ךָ וַיָּ֥שֶׁב יָדֹ֖ו אֶל־חֵיקֹ֑ו וַיֹּֽוצִאָהּ֙ מֵֽחֵיקֹ֔ו וְהִנֵּה־שָׁ֖בָה כִּבְשָׂרֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","וְהָיָה֙ אִם־לֹ֣א יַאֲמִ֣ינוּ לָ֔ךְ וְלֹ֣א יִשְׁמְע֔וּ לְקֹ֖ל הָאֹ֣ת הָרִאשֹׁ֑ון וְהֶֽאֱמִ֔ינוּ לְקֹ֖ל הָאֹ֥ת הָאַחֲרֹֽון׃ ");
INSERT INTO hbo_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","וְהָיָ֡ה אִם־לֹ֣א יַאֲמִ֡ינוּ גַּם֩ לִשְׁנֵ֨י הָאֹתֹ֜ות הָאֵ֗לֶּה וְלֹ֤א יִשְׁמְעוּן֙ לְקֹלֶ֔ךָ וְלָקַחְתָּ֙ מִמֵּימֵ֣י הַיְאֹ֔ר וְשָׁפַכְתָּ֖ הַיַּבָּשָׁ֑ה וְהָי֤וּ הַמַּ֙יִם֙ אֲשֶׁ֣ר תִּקַּ֣ח מִן־הַיְאֹ֔ר וְהָי֥וּ לְדָ֖ם בַּיַּבָּֽשֶׁת׃ ");
INSERT INTO hbo_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","וַיֹּ֨אמֶר מֹשֶׁ֣ה אֶל־יְהוָה֮ בִּ֣י אֲדֹנָי֒ לֹא֩ אִ֨ישׁ דְּבָרִ֜ים אָנֹ֗כִי גַּ֤ם מִתְּמֹול֙ גַּ֣ם מִשִּׁלְשֹׁ֔ם גַּ֛ם מֵאָ֥ז דַּבֶּרְךָ אֶל־עַבְדֶּ֑ךָ כִּ֧י כְבַד־פֶּ֛ה וּכְבַ֥ד לָשֹׁ֖ון אָנֹֽכִי׃ ");
INSERT INTO hbo_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","וַיֹּ֨אמֶר יְהוָ֜ה אֵלָ֗יו מִ֣י שָׂ֣ם פֶּה֮ לָֽאָדָם֒ אֹ֚ו מִֽי־יָשׂ֣וּם אִלֵּ֔ם אֹ֣ו חֵרֵ֔שׁ אֹ֥ו פִקֵּ֖חַ אֹ֣ו עִוֵּ֑ר הֲלֹ֥א אָנֹכִ֖י יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","וְעַתָּ֖ה לֵ֑ךְ וְאָנֹכִי֙ אֶֽהְיֶ֣ה עִם־פִּ֔יךָ וְהֹורֵיתִ֖יךָ אֲשֶׁ֥ר תְּדַבֵּֽר׃ ");
INSERT INTO hbo_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","וַיֹּ֖אמֶר בִּ֣י אֲדֹנָ֑י שְֽׁלַֽח־נָ֖א בְּיַד־תִּשְׁלָֽח׃ ");
INSERT INTO hbo_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","וַיִּֽחַר־אַ֨ף יְהוָ֜ה בְּמֹשֶׁ֗ה וַיֹּ֙אמֶר֙ הֲלֹ֨א אַהֲרֹ֤ן אָחִ֙יךָ֙ הַלֵּוִ֔י יָדַ֕עְתִּי כִּֽי־דַבֵּ֥ר יְדַבֵּ֖ר ה֑וּא וְגַ֤ם הִנֵּה־הוּא֙ יֹצֵ֣א לִקְרָאתֶ֔ךָ וְרָאֲךָ֖ וְשָׂמַ֥ח בְּלִבֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","וְדִבַּרְתָּ֣ אֵלָ֔יו וְשַׂמְתָּ֥ אֶת־הַדְּבָרִ֖ים בְּפִ֑יו וְאָנֹכִ֗י אֶֽהְיֶ֤ה עִם־פִּ֙יךָ֙ וְעִם־פִּ֔יהוּ וְהֹורֵיתִ֣י אֶתְכֶ֔ם אֵ֖ת אֲשֶׁ֥ר תַּעֲשֽׂוּן׃ ");
INSERT INTO hbo_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","וְדִבֶּר־ה֥וּא לְךָ֖ אֶל־הָעָ֑ם וְהָ֤יָה הוּא֙ יִֽהְיֶה־לְּךָ֣ לְפֶ֔ה וְאַתָּ֖ה תִּֽהְיֶה־לֹּ֥ו לֵֽאלֹהִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","וְאֶת־הַמַּטֶּ֥ה הַזֶּ֖ה תִּקַּ֣ח בְּיָדֶ֑ךָ אֲשֶׁ֥ר תַּעֲשֶׂה־בֹּ֖ו אֶת־הָאֹתֹֽת׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","וַיֵּ֨לֶךְ מֹשֶׁ֜ה וַיָּ֣שָׁב ׀ אֶל־יֶ֣תֶר חֹֽתְנֹ֗ו וַיֹּ֤אמֶר לֹו֙ אֵ֣לְכָה נָּ֗א וְאָשׁ֙וּבָה֙ אֶל־אַחַ֣י אֲשֶׁר־בְּמִצְרַ֔יִם וְאֶרְאֶ֖ה הַעֹודָ֣ם חַיִּ֑ים וַיֹּ֧אמֶר יִתְרֹ֛ו לְמֹשֶׁ֖ה לֵ֥ךְ לְשָׁלֹֽום׃ ");
INSERT INTO hbo_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","וַיֹּ֨אמֶר יְהוָ֤ה אֶל־מֹשֶׁה֙ בְּמִדְיָ֔ן לֵ֖ךְ שֻׁ֣ב מִצְרָ֑יִם כִּי־מֵ֙תוּ֙ כָּל־הָ֣אֲנָשִׁ֔ים הַֽמְבַקְשִׁ֖ים אֶת־נַפְשֶֽׁךָ׃ ");
INSERT INTO hbo_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","וַיִּקַּ֨ח מֹשֶׁ֜ה אֶת־אִשְׁתֹּ֣ו וְאֶת־בָּנָ֗יו וַיַּרְכִּבֵם֙ עַֽל־הַחֲמֹ֔ר וַיָּ֖שָׁב אַ֣רְצָה מִצְרָ֑יִם וַיִּקַּ֥ח מֹשֶׁ֛ה אֶת־מַטֵּ֥ה הָאֱלֹהִ֖ים בְּיָדֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","וַיֹּ֣אמֶר יְהוָה֮ אֶל־מֹשֶׁה֒ בְּלֶכְתְּךָ֙ לָשׁ֣וּב מִצְרַ֔יְמָה רְאֵ֗ה כָּל־הַמֹּֽפְתִים֙ אֲשֶׁר־שַׂ֣מְתִּי בְיָדֶ֔ךָ וַעֲשִׂיתָ֖ם לִפְנֵ֣י פַרְעֹ֑ה וַאֲנִי֙ אֲחַזֵּ֣ק אֶת־לִבֹּ֔ו וְלֹ֥א יְשַׁלַּ֖ח אֶת־הָעָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","וְאָמַרְתָּ֖ אֶל־פַּרְעֹ֑ה כֹּ֚ה אָמַ֣ר יְהוָ֔ה בְּנִ֥י בְכֹרִ֖י יִשְׂרָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","וָאֹמַ֣ר אֵלֶ֗יךָ שַׁלַּ֤ח אֶת־בְּנִי֙ וְיַֽעַבְדֵ֔נִי וַתְּמָאֵ֖ן לְשַׁלְּחֹ֑ו הִנֵּה֙ אָנֹכִ֣י הֹרֵ֔ג אֶת־בִּנְךָ֖ בְּכֹרֶֽךָ׃ ");
INSERT INTO hbo_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","וַיְהִ֥י בַדֶּ֖רֶךְ בַּמָּלֹ֑ון וַיִּפְגְּשֵׁ֣הוּ יְהוָ֔ה וַיְבַקֵּ֖שׁ הֲמִיתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","וַתִּקַּ֨ח צִפֹּרָ֜ה צֹ֗ר וַתִּכְרֹת֙ אֶת־עָרְלַ֣ת בְּנָ֔הּ וַתַּגַּ֖ע לְרַגְלָ֑יו וַתֹּ֕אמֶר כִּ֧י חֲתַן־דָּמִ֛ים אַתָּ֖ה לִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","וַיִּ֖רֶף מִמֶּ֑נּוּ אָ֚ז אָֽמְרָ֔ה חֲתַ֥ן דָּמִ֖ים לַמּוּלֹֽת׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","וַיֹּ֤אמֶר יְהוָה֙ אֶֽל־אַהֲרֹ֔ן לֵ֛ךְ לִקְרַ֥את מֹשֶׁ֖ה הַמִּדְבָּ֑רָה וַיֵּ֗לֶךְ וַֽיִּפְגְּשֵׁ֛הוּ בְּהַ֥ר הָאֱלֹהִ֖ים וַיִּשַּׁק־לֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","וַיַּגֵּ֤ד מֹשֶׁה֙ לְאַֽהֲרֹ֔ן אֵ֛ת כָּל־דִּבְרֵ֥י יְהוָ֖ה אֲשֶׁ֣ר שְׁלָחֹ֑ו וְאֵ֥ת כָּל־הָאֹתֹ֖ת אֲשֶׁ֥ר צִוָּֽהוּ׃ ");
INSERT INTO hbo_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","וַיֵּ֥לֶךְ מֹשֶׁ֖ה וְאַהֲרֹ֑ן וַיַּ֣אַסְפ֔וּ אֶת־כָּל־זִקְנֵ֖י בְּנֵ֥י יִשְׂרָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","וַיְדַבֵּ֣ר אַהֲרֹ֔ן אֵ֚ת כָּל־הַדְּבָרִ֔ים אֲשֶׁר־דִּבֶּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֑ה וַיַּ֥עַשׂ הָאֹתֹ֖ת לְעֵינֵ֥י הָעָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","וַֽיַּאֲמֵ֖ן הָעָ֑ם וַֽיִּשְׁמְע֡וּ כִּֽי־פָקַ֨ד יְהוָ֜ה אֶת־בְּנֵ֣י יִשְׂרָאֵ֗ל וְכִ֤י רָאָה֙ אֶת־עָנְיָ֔ם וַֽיִּקְּד֖וּ וַיִּֽשְׁתַּחֲוּֽוּ׃ ");
INSERT INTO hbo_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","וְאַחַ֗ר בָּ֚אוּ מֹשֶׁ֣ה וְאַהֲרֹ֔ן וַיֹּאמְר֖וּ אֶל־פַּרְעֹ֑ה כֹּֽה־אָמַ֤ר יְהוָה֙ אֱלֹהֵ֣י יִשְׂרָאֵ֔ל שַׁלַּח֙ אֶת־עַמִּ֔י וְיָחֹ֥גּוּ לִ֖י בַּמִּדְבָּֽר׃ ");
INSERT INTO hbo_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","וַיֹּ֣אמֶר פַּרְעֹ֔ה מִ֤י יְהוָה֙ אֲשֶׁ֣ר אֶשְׁמַ֣ע בְּקֹלֹ֔ו לְשַׁלַּ֖ח אֶת־יִשְׂרָאֵ֑ל לֹ֤א יָדַ֙עְתִּי֙ אֶת־יְהוָ֔ה וְגַ֥ם אֶת־יִשְׂרָאֵ֖ל לֹ֥א אֲשַׁלֵּֽחַ׃ ");
INSERT INTO hbo_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","וַיֹּ֣אמְר֔וּ אֱלֹהֵ֥י הָעִבְרִ֖ים נִקְרָ֣א עָלֵ֑ינוּ נֵ֣לֲכָה נָּ֡א דֶּרֶךְ֩ שְׁלֹ֨שֶׁת יָמִ֜ים בַּמִּדְבָּ֗ר וְנִזְבְּחָה֙ לַֽיהוָ֣ה אֱלֹהֵ֔ינוּ פֶּ֨ן־יִפְגָּעֵ֔נוּ בַּדֶּ֖בֶר אֹ֥ו בֶחָֽרֶב׃ ");
INSERT INTO hbo_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","וַיֹּ֤אמֶר אֲלֵהֶם֙ מֶ֣לֶךְ מִצְרַ֔יִם לָ֚מָּה מֹשֶׁ֣ה וְאַהֲרֹ֔ן תַּפְרִ֥יעוּ אֶת־הָעָ֖ם מִמַּֽעֲשָׂ֑יו לְכ֖וּ לְסִבְלֹתֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","וַיֹּ֣אמֶר פַּרְעֹ֔ה הֵן־רַבִּ֥ים עַתָּ֖ה עַ֣ם הָאָ֑רֶץ וְהִשְׁבַּתֶּ֥ם אֹתָ֖ם מִסִּבְלֹתָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","וַיְצַ֥ו פַּרְעֹ֖ה בַּיֹּ֣ום הַה֑וּא אֶת־הַנֹּגְשִׂ֣ים בָּעָ֔ם וְאֶת־שֹׁטְרָ֖יו לֵאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","לֹ֣א תֹאסִפ֞וּן לָתֵ֨ת תֶּ֧בֶן לָעָ֛ם לִלְבֹּ֥ן הַלְּבֵנִ֖ים כִּתְמֹ֣ול שִׁלְשֹׁ֑ם הֵ֚ם יֵֽלְכ֔וּ וְקֹשְׁשׁ֥וּ לָהֶ֖ם תֶּֽבֶן׃ ");
INSERT INTO hbo_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","וְאֶת־מַתְכֹּ֨נֶת הַלְּבֵנִ֜ים אֲשֶׁ֣ר הֵם֩ עֹשִׂ֨ים תְּמֹ֤ול שִׁלְשֹׁם֙ תָּשִׂ֣ימוּ עֲלֵיהֶ֔ם לֹ֥א תִגְרְע֖וּ מִמֶּ֑נּוּ כִּֽי־נִרְפִּ֣ים הֵ֔ם עַל־כֵּ֗ן הֵ֤ם צֹֽעֲקִים֙ לֵאמֹ֔ר נֵלְכָ֖ה נִזְבְּחָ֥ה לֵאלֹהֵֽינוּ׃ ");
INSERT INTO hbo_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","תִּכְבַּ֧ד הָעֲבֹדָ֛ה עַל־הָאֲנָשִׁ֖ים וְיַעֲשׂוּ־בָ֑הּ וְאַל־יִשְׁע֖וּ בְּדִבְרֵי־שָֽׁקֶר׃ ");
INSERT INTO hbo_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","וַיֵּ֨צְא֜וּ נֹגְשֵׂ֤י הָעָם֙ וְשֹׁ֣טְרָ֔יו וַיֹּאמְר֥וּ אֶל־הָעָ֖ם לֵאמֹ֑ר כֹּ֚ה אָמַ֣ר פַּרְעֹ֔ה אֵינֶ֛נִּי נֹתֵ֥ן לָכֶ֖ם תֶּֽבֶן׃ ");
INSERT INTO hbo_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","אַתֶּ֗ם לְכ֨וּ קְח֤וּ לָכֶם֙ תֶּ֔בֶן מֵאֲשֶׁ֖ר תִּמְצָ֑אוּ כִּ֣י אֵ֥ין נִגְרָ֛ע מֵעֲבֹדַתְכֶ֖ם דָּבָֽר׃ ");
INSERT INTO hbo_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","וַיָּ֥פֶץ הָעָ֖ם בְּכָל־אֶ֣רֶץ מִצְרָ֑יִם לְקֹשֵׁ֥שׁ קַ֖שׁ לַתֶּֽבֶן׃ ");
INSERT INTO hbo_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","וְהַנֹּגְשִׂ֖ים אָצִ֣ים לֵאמֹ֑ר כַּלּ֤וּ מַעֲשֵׂיכֶם֙ דְּבַר־יֹ֣ום בְּיֹומֹ֔ו כַּאֲשֶׁ֖ר בִּהְיֹ֥ות הַתֶּֽבֶן׃ ");
INSERT INTO hbo_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","וַיֻּכּ֗וּ שֹֽׁטְרֵי֙ בְּנֵ֣י יִשְׂרָאֵ֔ל אֲשֶׁר־שָׂ֣מוּ עֲלֵהֶ֔ם נֹגְשֵׂ֥י פַרְעֹ֖ה לֵאמֹ֑ר מַדּ֡וּעַ לֹא֩ כִלִּיתֶ֨ם חָקְכֶ֤ם לִלְבֹּן֙ כִּתְמֹ֣ול שִׁלְשֹׁ֔ם גַּם־תְּמֹ֖ול גַּם־הַיֹּֽום׃ ");
INSERT INTO hbo_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","וַיָּבֹ֗אוּ שֹֽׁטְרֵי֙ בְּנֵ֣י יִשְׂרָאֵ֔ל וַיִּצְעֲק֥וּ אֶל־פַּרְעֹ֖ה לֵאמֹ֑ר לָ֧מָּה תַעֲשֶׂ֦ה כֹ֖ה לַעֲבָדֶֽיךָ׃ ");
INSERT INTO hbo_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","תֶּ֗בֶן אֵ֤ין נִתָּן֙ לַעֲבָדֶ֔יךָ וּלְבֵנִ֛ים אֹמְרִ֥ים לָ֖נוּ עֲשׂ֑וּ וְהִנֵּ֧ה עֲבָדֶ֛יךָ מֻכִּ֖ים וְחָטָ֥את עַמֶּֽךָ׃ ");
INSERT INTO hbo_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","וַיֹּ֛אמֶר נִרְפִּ֥ים אַתֶּ֖ם נִרְפִּ֑ים עַל־כֵּן֙ אַתֶּ֣ם אֹֽמְרִ֔ים נֵלְכָ֖ה נִזְבְּחָ֥ה לַֽיהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","וְעַתָּה֙ לְכ֣וּ עִבְד֔וּ וְתֶ֖בֶן לֹא־יִנָּתֵ֣ן לָכֶ֑ם וְתֹ֥כֶן לְבֵנִ֖ים תִּתֵּֽנּוּ׃ ");
INSERT INTO hbo_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","וַיִּרְא֞וּ שֹֽׁטְרֵ֧י בְנֵֽי־יִשְׂרָאֵ֛ל אֹתָ֖ם בְּרָ֣ע לֵאמֹ֑ר לֹא־תִגְרְע֥וּ מִלִּבְנֵיכֶ֖ם דְּבַר־יֹ֥ום בְּיֹומֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","וַֽיִּפְגְּעוּ֙ אֶת־מֹשֶׁ֣ה וְאֶֽת־אַהֲרֹ֔ן נִצָּבִ֖ים לִקְרָאתָ֑ם בְּצֵאתָ֖ם מֵאֵ֥ת פַּרְעֹֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","וַיֹּאמְר֣וּ אֲלֵהֶ֔ם יֵ֧רֶא יְהוָ֛ה עֲלֵיכֶ֖ם וְיִשְׁפֹּ֑ט אֲשֶׁ֧ר הִבְאַשְׁתֶּ֣ם אֶת־רֵיחֵ֗נוּ בְּעֵינֵ֤י פַרְעֹה֙ וּבְעֵינֵ֣י עֲבָדָ֔יו לָֽתֶת־חֶ֥רֶב בְּיָדָ֖ם לְהָרְגֵֽנוּ׃ ");
INSERT INTO hbo_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","וַיָּ֧שָׁב מֹשֶׁ֛ה אֶל־יְהוָ֖ה וַיֹּאמַ֑ר אֲדֹנָ֗י לָמָ֤ה הֲרֵעֹ֙תָה֙ לָעָ֣ם הַזֶּ֔ה לָ֥מָּה זֶּ֖ה שְׁלַחְתָּֽנִי׃ ");
INSERT INTO hbo_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","וּמֵאָ֞ז בָּ֤אתִי אֶל־פַּרְעֹה֙ לְדַבֵּ֣ר בִּשְׁמֶ֔ךָ הֵרַ֖ע לָעָ֣ם הַזֶּ֑ה וְהַצֵּ֥ל לֹא־הִצַּ֖לְתָּ אֶת־עַמֶּֽךָ׃ ");
INSERT INTO hbo_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","וַיֹּ֤אמֶר יְהוָה֙ אֶל־מֹשֶׁ֔ה עַתָּ֣ה תִרְאֶ֔ה אֲשֶׁ֥ר אֽ͏ֶעֱשֶׂ֖ה לְפַרְעֹ֑ה כִּ֣י בְיָ֤ד חֲזָקָה֙ יְשַׁלְּחֵ֔ם וּבְיָ֣ד חֲזָקָ֔ה יְגָרְשֵׁ֖ם מֵאַרְצֹֽו׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","וַיְדַבֵּ֥ר אֱלֹהִ֖ים אֶל־מֹשֶׁ֑ה וַיֹּ֥אמֶר אֵלָ֖יו אֲנִ֥י יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","וָאֵרָ֗א אֶל־אַבְרָהָ֛ם אֶל־יִצְחָ֥ק וְאֶֽל־יַעֲקֹ֖ב בְּאֵ֣ל שַׁדָּ֑י וּשְׁמִ֣י יְהוָ֔ה לֹ֥א נֹודַ֖עְתִּי לָהֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","וְגַ֨ם הֲקִמֹ֤תִי אֶת־בְּרִיתִי֙ אִתָּ֔ם לָתֵ֥ת לָהֶ֖ם אֶת־אֶ֣רֶץ כְּנָ֑עַן אֵ֛ת אֶ֥רֶץ מְגֻרֵיהֶ֖ם אֲשֶׁר־גָּ֥רוּ בָֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","וְגַ֣ם ׀ אֲנִ֣י שָׁמַ֗עְתִּי אֶֽת־נַאֲקַת֙ בְּנֵ֣י יִשְׂרָאֵ֔ל אֲשֶׁ֥ר מִצְרַ֖יִם מַעֲבִדִ֣ים אֹתָ֑ם וָאֶזְכֹּ֖ר אֶת־בְּרִיתִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","לָכֵ֞ן אֱמֹ֥ר לִבְנֵֽי־יִשְׂרָאֵל֮ אֲנִ֣י יְהוָה֒ וְהֹוצֵאתִ֣י אֶתְכֶ֗ם מִתַּ֙חַת֙ סִבְלֹ֣ת מִצְרַ֔יִם וְהִצַּלְתִּ֥י אֶתְכֶ֖ם מֵעֲבֹדָתָ֑ם וְגָאַלְתִּ֤י אֶתְכֶם֙ בִּזְרֹ֣ועַ נְטוּיָ֔ה וּבִשְׁפָטִ֖ים גְּדֹלִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","וְלָקַחְתִּ֨י אֶתְכֶ֥ם לִי֙ לְעָ֔ם וְהָיִ֥יתִי לָכֶ֖ם לֵֽאלֹהִ֑ים וִֽידַעְתֶּ֗ם כִּ֣י אֲנִ֤י יְהוָה֙ אֱלֹ֣הֵיכֶ֔ם הַמֹּוצִ֣יא אֶתְכֶ֔ם מִתַּ֖חַת סִבְלֹ֥ות מִצְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","וְהֵבֵאתִ֤י אֶתְכֶם֙ אֶל־הָאָ֔רֶץ אֲשֶׁ֤ר נָשָׂ֙אתִי֙ אֶת־יָדִ֔י לָתֵ֣ת אֹתָ֔הּ לְאַבְרָהָ֥ם לְיִצְחָ֖ק וּֽלְיַעֲקֹ֑ב וְנָתַתִּ֨י אֹתָ֥הּ לָכֶ֛ם מֹורָשָׁ֖ה אֲנִ֥י יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","וַיְדַבֵּ֥ר מֹשֶׁ֛ה כֵּ֖ן אֶל־בְּנֵ֣י יִשְׂרָאֵ֑ל וְלֹ֤א שָֽׁמְעוּ֙ אֶל־מֹשֶׁ֔ה מִקֹּ֣צֶר ר֔וּחַ וּמֵעֲבֹדָ֖ה קָשָֽׁה׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","בֹּ֣א דַבֵּ֔ר אֶל־פַּרְעֹ֖ה מֶ֣לֶךְ מִצְרָ֑יִם וִֽישַׁלַּ֥ח אֶת־בְּנֵֽי־יִשְׂרָאֵ֖ל מֵאַרְצֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","וַיְדַבֵּ֣ר מֹשֶׁ֔ה לִפְנֵ֥י יְהוָ֖ה לֵאמֹ֑ר הֵ֤ן בְּנֵֽי־יִשְׂרָאֵל֙ לֹֽא־שָׁמְע֣וּ אֵלַ֔י וְאֵיךְ֙ יִשְׁמָעֵ֣נִי פַרְעֹ֔ה וַאֲנִ֖י עֲרַ֥ל שְׂפָתָֽיִם׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","וַיְדַבֵּ֣ר יְהוָה֮ אֶל־מֹשֶׁ֣ה וְאֶֽל־אַהֲרֹן֒ וַיְצַוֵּם֙ אֶל־בְּנֵ֣י יִשְׂרָאֵ֔ל וְאֶל־פַּרְעֹ֖ה מֶ֣לֶךְ מִצְרָ֑יִם לְהֹוצִ֥יא אֶת־בְּנֵֽי־יִשְׂרָאֵ֖ל מֵאֶ֥רֶץ מִצְרָֽיִם׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","אֵ֖לֶּה רָאשֵׁ֣י בֵית־אֲבֹתָ֑ם בְּנֵ֨י רְאוּבֵ֜ן בְּכֹ֣ר יִשְׂרָאֵ֗ל חֲנֹ֤וךְ וּפַלּוּא֙ חֶצְרֹ֣ון וְכַרְמִ֔י אֵ֖לֶּה מִשְׁפְּחֹ֥ת רְאוּבֵֽן׃ ");
INSERT INTO hbo_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","וּבְנֵ֣י שִׁמְעֹ֗ון יְמוּאֵ֨ל וְיָמִ֤ין וְאֹ֙הַד֙ וְיָכִ֣ין וְצֹ֔חַר וְשָׁא֖וּל בֶּן־הַֽכְּנַעֲנִ֑ית אֵ֖לֶּה מִשְׁפְּחֹ֥ת שִׁמְעֹֽון׃ ");
INSERT INTO hbo_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","וְאֵ֨לֶּה שְׁמֹ֤ות בְּנֵֽי־לֵוִי֙ לְתֹ֣לְדֹתָ֔ם גֵּרְשֹׁ֕ון וּקְהָ֖ת וּמְרָרִ֑י וּשְׁנֵי֙ חַיֵּ֣י לֵוִ֔י שֶׁ֧בַע וּשְׁלֹשִׁ֛ים וּמְאַ֖ת שָׁנָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","בְּנֵ֥י גֵרְשֹׁ֛ון לִבְנִ֥י וְשִׁמְעִ֖י לְמִשְׁפְּחֹתָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","וּבְנֵ֣י קְהָ֔ת עַמְרָ֣ם וְיִצְהָ֔ר וְחֶבְרֹ֖ון וְעֻזִּיאֵ֑ל וּשְׁנֵי֙ חַיֵּ֣י קְהָ֔ת שָׁלֹ֧שׁ וּשְׁלֹשִׁ֛ים וּמְאַ֖ת שָׁנָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","וּבְנֵ֥י מְרָרִ֖י מַחְלִ֣י וּמוּשִׁ֑י אֵ֛לֶּה מִשְׁפְּחֹ֥ת הַלֵּוִ֖י לְתֹלְדֹתָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","וַיִּקַּ֨ח עַמְרָ֜ם אֶת־יֹוכֶ֤בֶד דֹּֽדָתֹו֙ לֹ֣ו לְאִשָּׁ֔ה וַתֵּ֣לֶד לֹ֔ו אֶֽת־אַהֲרֹ֖ן וְאֶת־מֹשֶׁ֑ה וּשְׁנֵי֙ חַיֵּ֣י עַמְרָ֔ם שֶׁ֧בַע וּשְׁלֹשִׁ֛ים וּמְאַ֖ת שָׁנָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","וּבְנֵ֖י יִצְהָ֑ר קֹ֥רַח וָנֶ֖פֶג וְזִכְרִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","וּבְנֵ֖י עֻזִּיאֵ֑ל מִֽישָׁאֵ֥ל וְאֶלְצָפָ֖ן וְסִתְרִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","וַיִּקַּ֨ח אַהֲרֹ֜ן אֶת־אֱלִישֶׁ֧בַע בַּת־עַמִּינָדָ֛ב אֲחֹ֥ות נַחְשֹׁ֖ון לֹ֣ו לְאִשָּׁ֑ה וַתֵּ֣לֶד לֹ֗ו אֶת־נָדָב֙ וְאֶת־אֲבִיה֔וּא אֶת־אֶלְעָזָ֖ר וְאֶת־אִֽיתָמָֽר׃ ");
INSERT INTO hbo_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","וּבְנֵ֣י קֹ֔רַח אַסִּ֥יר וְאֶלְקָנָ֖ה וַאֲבִיאָסָ֑ף אֵ֖לֶּה מִשְׁפְּחֹ֥ת הַקָּרְחִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","וְאֶלְעָזָ֨ר בֶּֽן־אַהֲרֹ֜ן לָקַֽח־לֹ֨ו מִבְּנֹ֤ות פּֽוּטִיאֵל֙ לֹ֣ו לְאִשָּׁ֔ה וַתֵּ֥לֶד לֹ֖ו אֶת־פִּֽינְחָ֑ס אֵ֗לֶּה רָאשֵׁ֛י אֲבֹ֥ות הַלְוִיִּ֖ם לְמִשְׁפְּחֹתָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","ה֥וּא אַהֲרֹ֖ן וּמֹשֶׁ֑ה אֲשֶׁ֨ר אָמַ֤ר יְהוָה֙ לָהֶ֔ם הֹוצִ֜יאוּ אֶת־בְּנֵ֧י יִשְׂרָאֵ֛ל מֵאֶ֥רֶץ מִצְרַ֖יִם עַל־צִבְאֹתָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","הֵ֗ם הַֽמְדַבְּרִים֙ אֶל־פַּרְעֹ֣ה מֶֽלֶךְ־מִצְרַ֔יִם לְהֹוצִ֥יא אֶת־בְּנֵֽי־יִשְׂרָאֵ֖ל מִמִּצְרָ֑יִם ה֥וּא מֹשֶׁ֖ה וְאַהֲרֹֽן׃ ");
INSERT INTO hbo_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","וַיְהִ֗י בְּיֹ֨ום דִּבֶּ֧ר יְהוָ֛ה אֶל־מֹשֶׁ֖ה בְּאֶ֥רֶץ מִצְרָֽיִם׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","וַיְדַבֵּ֧ר יְהוָ֛ה אֶל־מֹשֶׁ֥ה לֵּאמֹ֖ר אֲנִ֣י יְהוָ֑ה דַּבֵּ֗ר אֶל־פַּרְעֹה֙ מֶ֣לֶךְ מִצְרַ֔יִם אֵ֛ת כָּל־אֲשֶׁ֥ר אֲנִ֖י דֹּבֵ֥ר אֵלֶֽיךָ׃ ");
INSERT INTO hbo_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","וַיֹּ֥אמֶר מֹשֶׁ֖ה לִפְנֵ֣י יְהוָ֑ה הֵ֤ן אֲנִי֙ עֲרַ֣ל שְׂפָתַ֔יִם וְאֵ֕יךְ יִשְׁמַ֥ע אֵלַ֖י פַּרְעֹֽה׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","וַיֹּ֤אמֶר יְהוָה֙ אֶל־מֹשֶׁ֔ה רְאֵ֛ה נְתַתִּ֥יךָ אֱלֹהִ֖ים לְפַרְעֹ֑ה וְאַהֲרֹ֥ן אָחִ֖יךָ יִהְיֶ֥ה נְבִיאֶֽךָ׃ ");
INSERT INTO hbo_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","אַתָּ֣ה תְדַבֵּ֔ר אֵ֖ת כָּל־אֲשֶׁ֣ר אֲצַוֶּ֑ךָּ וְאַהֲרֹ֤ן אָחִ֙יךָ֙ יְדַבֵּ֣ר אֶל־פַּרְעֹ֔ה וְשִׁלַּ֥ח אֶת־בְּנֵֽי־יִשְׂרָאֵ֖ל מֵאַרְצֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","וַאֲנִ֥י אַקְשֶׁ֖ה אֶת־לֵ֣ב פַּרְעֹ֑ה וְהִרְבֵּיתִ֧י אֶת־אֹתֹתַ֛י וְאֶת־מֹופְתַ֖י בְּאֶ֥רֶץ מִצְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","וְלֹֽא־יִשְׁמַ֤ע אֲלֵכֶם֙ פַּרְעֹ֔ה וְנָתַתִּ֥י אֶת־יָדִ֖י בְּמִצְרָ֑יִם וְהֹוצֵאתִ֨י אֶת־צִבְאֹתַ֜י אֶת־עַמִּ֤י בְנֵֽי־יִשְׂרָאֵל֙ מֵאֶ֣רֶץ מִצְרַ֔יִם בִּשְׁפָטִ֖ים גְּדֹלִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","וְיָדְע֤וּ מִצְרַ֙יִם֙ כִּֽי־אֲנִ֣י יְהוָ֔ה בִּנְטֹתִ֥י אֶת־יָדִ֖י עַל־מִצְרָ֑יִם וְהֹוצֵאתִ֥י אֶת־בְּנֵֽי־יִשְׂרָאֵ֖ל מִתֹּוכָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","וַיַּ֥עַשׂ מֹשֶׁ֖ה וְאַהֲרֹ֑ן כַּאֲשֶׁ֨ר צִוָּ֧ה יְהוָ֛ה אֹתָ֖ם כֵּ֥ן עָשֽׂוּ׃ ");
INSERT INTO hbo_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","וּמֹשֶׁה֙ בֶּן־שְׁמֹנִ֣ים שָׁנָ֔ה וְאֽ͏ַהֲרֹ֔ן בֶּן־שָׁלֹ֥שׁ וּשְׁמֹנִ֖ים שָׁנָ֑ה בְּדַבְּרָ֖ם אֶל־פַּרְעֹֽה׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","וַיֹּ֣אמֶר יְהוָ֔ה אֶל־מֹשֶׁ֥ה וְאֶֽל־אַהֲרֹ֖ן לֵאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","כִּי֩ יְדַבֵּ֨ר אֲלֵכֶ֤ם פַּרְעֹה֙ לֵאמֹ֔ר תְּנ֥וּ לָכֶ֖ם מֹופֵ֑ת וְאָמַרְתָּ֣ אֶֽל־אַהֲרֹ֗ן קַ֧ח אֶֽת־מַטְּךָ֛ וְהַשְׁלֵ֥ךְ לִפְנֵֽי־פַרְעֹ֖ה יְהִ֥י לְתַנִּֽין׃ ");
INSERT INTO hbo_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","וַיָּבֹ֨א מֹשֶׁ֤ה וְאַהֲרֹן֙ אֶל־פַּרְעֹ֔ה וַיַּ֣עַשׂוּ כֵ֔ן כַּאֲשֶׁ֖ר צִוָּ֣ה יְהוָ֑ה וַיַּשְׁלֵ֨ךְ אַהֲרֹ֜ן אֶת־מַטֵּ֗הוּ לִפְנֵ֥י פַרְעֹ֛ה וְלִפְנֵ֥י עֲבָדָ֖יו וַיְהִ֥י לְתַנִּֽין׃ ");
INSERT INTO hbo_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","וַיִּקְרָא֙ גַּם־פַּרְעֹ֔ה לֽ͏ַחֲכָמִ֖ים וְלַֽמְכַשְּׁפִ֑ים וַיַּֽעֲשׂ֨וּ גַם־הֵ֜ם חַרְטֻמֵּ֥י מִצְרַ֛יִם בְּלַהֲטֵיהֶ֖ם כֵּֽן׃ ");
INSERT INTO hbo_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","וַיַּשְׁלִ֙יכוּ֙ אִ֣ישׁ מַטֵּ֔הוּ וַיִּהְי֖וּ לְתַנִּינִ֑ם וַיִּבְלַ֥ע מַטֵּֽה־אַהֲרֹ֖ן אֶת־מַטֹּתָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","וַיֶּחֱזַק֙ לֵ֣ב פַּרְעֹ֔ה וְלֹ֥א שָׁמַ֖ע אֲלֵהֶ֑ם כַּאֲשֶׁ֖ר דִּבֶּ֥ר יְהוָֽה׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","וַיֹּ֤אמֶר יְהוָה֙ אֶל־מֹשֶׁ֔ה כָּבֵ֖ד לֵ֣ב פַּרְעֹ֑ה מֵאֵ֖ן לְשַׁלַּ֥ח הָעָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","לֵ֣ךְ אֶל־פַּרְעֹ֞ה בַּבֹּ֗קֶר הִנֵּה֙ יֹצֵ֣א הַמַּ֔יְמָה וְנִצַּבְתָּ֥ לִקְרָאתֹ֖ו עַל־שְׂפַ֣ת הַיְאֹ֑ר וְהַמַּטֶּ֛ה אֲשֶׁר־נֶהְפַּ֥ךְ לְנָחָ֖שׁ תִּקַּ֥ח בְּיָדֶֽךָ׃ ");
INSERT INTO hbo_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","וְאָמַרְתָּ֣ אֵלָ֗יו יְהוָ֞ה אֱלֹהֵ֤י הָעִבְרִים֙ שְׁלָחַ֤נִי אֵלֶ֙יךָ֙ לֵאמֹ֔ר שַׁלַּח֙ אֶת־עַמִּ֔י וְיַֽעַבְדֻ֖נִי בַּמִּדְבָּ֑ר וְהִנֵּ֥ה לֹא־שָׁמַ֖עְתָּ עַד־כֹּֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","כֹּ֚ה אָמַ֣ר יְהוָ֔ה בְּזֹ֣את תֵּדַ֔ע כִּ֖י אֲנִ֣י יְהוָ֑ה הִנֵּ֨ה אָנֹכִ֜י מַכֶּ֣ה ׀ בַּמַּטֶּ֣ה אֲשֶׁר־בְּיָדִ֗י עַל־הַמַּ֛יִם אֲשֶׁ֥ר בַּיְאֹ֖ר וְנֶהֶפְכ֥וּ לְדָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","וְהַדָּגָ֧ה אֲשֶׁר־בַּיְאֹ֛ר תָּמ֖וּת וּבָאַ֣שׁ הַיְאֹ֑ר וְנִלְא֣וּ מִצְרַ֔יִם לִשְׁתֹּ֥ות מַ֖יִם מִן־הַיְאֹֽר׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","וַיֹּ֨אמֶר יְהוָ֜ה אֶל־מֹשֶׁ֗ה אֱמֹ֣ר אֶֽל־אַהֲרֹ֡ן קַ֣ח מַטְּךָ֣ וּנְטֵֽה־יָדְךָ֩ עַל־מֵימֵ֨י מִצְרַ֜יִם עַֽל־נַהֲרֹתָ֣ם ׀ עַל־יְאֹרֵיהֶ֣ם וְעַל־אַגְמֵיהֶ֗ם וְעַ֛ל כָּל־מִקְוֵ֥ה מֵימֵיהֶ֖ם וְיִֽהְיוּ־דָ֑ם וְהָ֤יָה דָם֙ בְּכָל־אֶ֣רֶץ מִצְרַ֔יִם וּבָעֵצִ֖ים וּבָאֲבָנִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","וַיַּֽעֲשׂוּ־כֵן֩ מֹשֶׁ֨ה וְאַהֲרֹ֜ן כַּאֲשֶׁ֣ר ׀ צִוָּ֣ה יְהוָ֗ה וַיָּ֤רֶם בַּמַּטֶּה֙ וַיַּ֤ךְ אֶת־הַמַּ֙יִם֙ אֲשֶׁ֣ר בַּיְאֹ֔ר לְעֵינֵ֣י פַרְעֹ֔ה וּלְעֵינֵ֖י עֲבָדָ֑יו וַיֵּהָֽפְכ֛וּ כָּל־הַמַּ֥יִם אֲשֶׁר־בַּיְאֹ֖ר לְדָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","וְהַדָּגָ֨ה אֲשֶׁר־בַּיְאֹ֥ר מֵ֙תָה֙ וַיִּבְאַ֣שׁ הַיְאֹ֔ר וְלֹא־יָכְל֣וּ מִצְרַ֔יִם לִשְׁתֹּ֥ות מַ֖יִם מִן־הַיְאֹ֑ר וַיְהִ֥י הַדָּ֖ם בְּכָל־אֶ֥רֶץ מִצְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","וַיַּֽעֲשׂוּ־כֵ֛ן חַרְטֻמֵּ֥י מִצְרַ֖יִם בְּלָטֵיהֶ֑ם וַיֶּחֱזַ֤ק לֵב־פַּרְעֹה֙ וְלֹא־שָׁמַ֣ע אֲלֵהֶ֔ם כַּאֲשֶׁ֖ר דִּבֶּ֥ר יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","וַיִּ֣פֶן פַּרְעֹ֔ה וַיָּבֹ֖א אֶל־בֵּיתֹ֑ו וְלֹא־שָׁ֥ת לִבֹּ֖ו גַּם־לָזֹֽאת׃ ");
INSERT INTO hbo_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","וַיַּחְפְּר֧וּ כָל־מִצְרַ֛יִם סְבִיבֹ֥ת הַיְאֹ֖ר מַ֣יִם לִשְׁתֹּ֑ות כִּ֣י לֹ֤א יָֽכְלוּ֙ לִשְׁתֹּ֔ת מִמֵּימֵ֖י הַיְאֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","וַיִּמָּלֵ֖א שִׁבְעַ֣ת יָמִ֑ים אַחֲרֵ֥י הַכֹּות־יְהוָ֖ה אֶת־הַיְאֹֽר׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX7_26","003_7_26","EXO","7","26","26","וַיֹּ֤אמֶר יְהוָה֙ אֶל־מֹשֶׁ֔ה בֹּ֖א אֶל־פַּרְעֹ֑ה וְאָמַרְתָּ֣ אֵלָ֗יו כֹּ֚ה אָמַ֣ר יְהוָ֔ה שַׁלַּ֥ח אֶת־עַמִּ֖י וְיַֽעַבְדֻֽנִי׃ ");
INSERT INTO hbo_vpl VALUES ("EX7_27","003_7_27","EXO","7","27","27","וְאִם־מָאֵ֥ן אַתָּ֖ה לְשַׁלֵּ֑חַ הִנֵּ֣ה אָנֹכִ֗י נֹגֵ֛ף אֶת־כָּל־גְּבוּלְךָ֖ בַּֽצְפַרְדְּעִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("EX7_28","003_7_28","EXO","7","28","28","וְשָׁרַ֣ץ הַיְאֹר֮ צְפַרְדְּעִים֒ וְעָלוּ֙ וּבָ֣אוּ בְּבֵיתֶ֔ךָ וּבַחֲדַ֥ר מִשְׁכָּבְךָ֖ וְעַל־מִטָּתֶ֑ךָ וּבְבֵ֤ית עֲבָדֶ֙יךָ֙ וּבְעַמֶּ֔ךָ וּבְתַנּוּרֶ֖יךָ וּבְמִשְׁאֲרֹותֶֽיךָ׃ ");
INSERT INTO hbo_vpl VALUES ("EX7_29","003_7_29","EXO","7","29","29","וּבְכָ֥ה וּֽבְעַמְּךָ֖ וּבְכָל־עֲבָדֶ֑יךָ יַעֲל֖וּ הַֽצְפַרְדְּעִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","וַיֹּ֣אמֶר יְהוָה֮ אֶל־מֹשֶׁה֒ אֱמֹ֣ר אֶֽל־אַהֲרֹ֗ן נְטֵ֤ה אֶת־יָדְךָ֙ בְּמַטֶּ֔ךָ עַל־הַ֨נְּהָרֹ֔ת עַל־הַיְאֹרִ֖ים וְעַל־הָאֲגַמִּ֑ים וְהַ֥עַל אֶת־הַֽצְפַרְדְּעִ֖ים עַל־אֶ֥רֶץ מִצְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","וַיֵּ֤ט אַהֲרֹן֙ אֶת־יָדֹ֔ו עַ֖ל מֵימֵ֣י מִצְרָ֑יִם וַתַּ֙עַל֙ הַצְּפַרְדֵּ֔עַ וַתְּכַ֖ס אֶת־אֶ֥רֶץ מִצְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","וַיַּֽעֲשׂוּ־כֵ֥ן הֽ͏ַחֲרְטֻמִּ֖ים בְּלָטֵיהֶ֑ם וַיַּעֲל֥וּ אֶת־הַֽצְפַרְדְּעִ֖ים עַל־אֶ֥רֶץ מִצְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","וַיִּקְרָ֨א פַרְעֹ֜ה לְמֹשֶׁ֣ה וּֽלְאַהֲרֹ֗ן וַיֹּ֙אמֶר֙ הַעְתִּ֣ירוּ אֶל־יְהוָ֔ה וְיָסֵר֙ הַֽצְפַרְדְּעִ֔ים מִמֶּ֖נִּי וּמֵֽעַמִּ֑י וַאֲשַׁלְּחָה֙ אֶת־הָעָ֔ם וְיִזְבְּח֖וּ לַיהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","וַיֹּ֣אמֶר מֹשֶׁ֣ה לְפַרְעֹה֮ הִתְפָּאֵ֣ר עָלַי֒ לְמָתַ֣י ׀ אַעְתִּ֣יר לְךָ֗ וְלַעֲבָדֶ֙יךָ֙ וּֽלְעַמְּךָ֔ לְהַכְרִית֙ הַֽצֲפַרְדְּעִ֔ים מִמְּךָ֖ וּמִבָּתֶּ֑יךָ רַ֥ק בַּיְאֹ֖ר תִּשָּׁאַֽרְנָה׃ ");
INSERT INTO hbo_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","וַיֹּ֖אמֶר לְמָחָ֑ר וַיֹּ֙אמֶר֙ כִּדְבָ֣רְךָ֔ לְמַ֣עַן תֵּדַ֔ע כִּי־אֵ֖ין כַּיהוָ֥ה אֱלֹהֵֽינוּ׃ ");
INSERT INTO hbo_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","וְסָר֣וּ הַֽצְפַרְדְּעִ֗ים מִמְּךָ֙ וּמִבָּ֣תֶּ֔יךָ וּמֵעֲבָדֶ֖יךָ וּמֵעַמֶּ֑ךָ רַ֥ק בַּיְאֹ֖ר תִּשָּׁאַֽרְנָה׃ ");
INSERT INTO hbo_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","וַיֵּצֵ֥א מֹשֶׁ֛ה וְאַהֲרֹ֖ן מֵעִ֣ם פַּרְעֹ֑ה וַיִּצְעַ֤ק מֹשֶׁה֙ אֶל־יְהוָ֔ה עַל־דְּבַ֥ר הַֽצְפַרְדְּעִ֖ים אֲשֶׁר־שָׂ֥ם לְפַרְעֹֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","וַיַּ֥עַשׂ יְהוָ֖ה כִּדְבַ֣ר מֹשֶׁ֑ה וַיָּמֻ֙תוּ֙ הַֽצְפַרְדְּעִ֔ים מִן־הַבָּתִּ֥ים מִן־הַחֲצֵרֹ֖ת וּמִן־הַשָּׂדֹֽת׃ ");
INSERT INTO hbo_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","וַיִּצְבְּר֥וּ אֹתָ֖ם חֳמָרִ֣ם חֳמָרִ֑ם וַתִּבְאַ֖שׁ הָאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","וַיַּ֣רְא פַּרְעֹ֗ה כִּ֤י הָֽיְתָה֙ הָֽרְוָחָ֔ה וְהַכְבֵּד֙ אֶת־לִבֹּ֔ו וְלֹ֥א שָׁמַ֖ע אֲלֵהֶ֑ם כַּאֲשֶׁ֖ר דִּבֶּ֥ר יְהוָֽה׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","וַיֹּ֣אמֶר יְהוָה֮ אֶל־מֹשֶׁה֒ אֱמֹר֙ אֶֽל־אַהֲרֹ֔ן נְטֵ֣ה אֶֽת־מַטְּךָ֔ וְהַ֖ךְ אֶת־עֲפַ֣ר הָאָ֑רֶץ וְהָיָ֥ה לְכִנִּ֖ם בְּכָל־אֶ֥רֶץ מִצְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","וַיַּֽעֲשׂוּ־כֵ֗ן וַיֵּט֩ אַהֲרֹ֨ן אֶת־יָדֹ֤ו בְמַטֵּ֙הוּ֙ וַיַּךְ֙ אֶת־עֲפַ֣ר הָאָ֔רֶץ וַתְּהִי֙ הַכִּנָּ֔ם בָּאָדָ֖ם וּבַבְּהֵמָ֑ה כָּל־עֲפַ֥ר הָאָ֛רֶץ הָיָ֥ה כִנִּ֖ים בְּכָל־אֶ֥רֶץ מִצְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","וַיַּעֲשׂוּ־כֵ֨ן הַחַרְטֻמִּ֧ים בְּלָטֵיהֶ֛ם לְהֹוצִ֥יא אֶת־הַכִּנִּ֖ים וְלֹ֣א יָכֹ֑לוּ וַתְּהִי֙ הַכִּנָּ֔ם בָּאָדָ֖ם וּבַבְּהֵמָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","וַיֹּאמְר֤וּ הַֽחַרְטֻמִּים֙ אֶל־פַּרְעֹ֔ה אֶצְבַּ֥ע אֱלֹהִ֖ים הִ֑וא וַיֶּחֱזַ֤ק לֵב־פַּרְעֹה֙ וְלֹֽא־שָׁמַ֣ע אֲלֵהֶ֔ם כַּאֲשֶׁ֖ר דִּבֶּ֥ר יְהוָֽה׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","וַיֹּ֨אמֶר יְהוָ֜ה אֶל־מֹשֶׁ֗ה הַשְׁכֵּ֤ם בַּבֹּ֙קֶר֙ וְהִתְיַצֵּב֙ לִפְנֵ֣י פַרְעֹ֔ה הִנֵּ֖ה יֹוצֵ֣א הַמָּ֑יְמָה וְאָמַרְתָּ֣ אֵלָ֗יו כֹּ֚ה אָמַ֣ר יְהוָ֔ה שַׁלַּ֥ח עַמִּ֖י וְיַֽעַבְדֻֽנִי׃ ");
INSERT INTO hbo_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","כִּ֣י אִם־אֵינְךָ֮ מְשַׁלֵּ֣חַ אֶת־עַמִּי֒ הִנְנִי֩ מַשְׁלִ֨יחַ בְּךָ֜ וּבַעֲבָדֶ֧יךָ וּֽבְעַמְּךָ֛ וּבְבָתֶּ֖יךָ אֶת־הֶעָרֹ֑ב וּמָ֨לְא֜וּ בָּתֵּ֤י מִצְרַ֙יִם֙ אֶת־הֶ֣עָרֹ֔ב וְגַ֥ם הָאֲדָמָ֖ה אֲשֶׁר־הֵ֥ם עָלֶֽיהָ׃ ");
INSERT INTO hbo_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","וְהִפְלֵיתִי֩ בַיֹּ֨ום הַה֜וּא אֶת־אֶ֣רֶץ גֹּ֗שֶׁן אֲשֶׁ֤ר עַמִּי֙ עֹמֵ֣ד עָלֶ֔יהָ לְבִלְתִּ֥י הֱיֹֽות־שָׁ֖ם עָרֹ֑ב לְמַ֣עַן תֵּדַ֔ע כִּ֛י אֲנִ֥י יְהוָ֖ה בְּקֶ֥רֶב הָאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","וְשַׂמְתִּ֣י פְדֻ֔ת בֵּ֥ין עַמִּ֖י וּבֵ֣ין עַמֶּ֑ךָ לְמָחָ֥ר יִהְיֶ֖ה הָאֹ֥ת הַזֶּֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","וַיַּ֤עַשׂ יְהוָה֙ כֵּ֔ן וַיָּבֹא֙ עָרֹ֣ב כָּבֵ֔ד בֵּ֥יתָה פַרְעֹ֖ה וּבֵ֣ית עֲבָדָ֑יו וּבְכָל־אֶ֧רֶץ מִצְרַ֛יִם תִּשָּׁחֵ֥ת הָאָ֖רֶץ מִפְּנֵ֥י הֶעָרֹֽב׃ ");
INSERT INTO hbo_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","וַיִּקְרָ֣א פַרְעֹ֔ה אֶל־מֹשֶׁ֖ה וּֽלְאַהֲרֹ֑ן וַיֹּ֗אמֶר לְכ֛וּ זִבְח֥וּ לֽ͏ֵאלֹהֵיכֶ֖ם בָּאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","וַיֹּ֣אמֶר מֹשֶׁ֗ה לֹ֤א נָכֹון֙ לַעֲשֹׂ֣ות כֵּ֔ן כִּ֚י תֹּועֲבַ֣ת מִצְרַ֔יִם נִזְבַּ֖ח לַיהוָ֣ה אֱלֹהֵ֑ינוּ הֵ֣ן נִזְבַּ֞ח אֶת־תֹּועֲבַ֥ת מִצְרַ֛יִם לְעֵינֵיהֶ֖ם וְלֹ֥א יִסְקְלֻֽנוּ׃ ");
INSERT INTO hbo_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","דֶּ֚רֶךְ שְׁלֹ֣שֶׁת יָמִ֔ים נֵלֵ֖ךְ בַּמִּדְבָּ֑ר וְזָבַ֙חְנוּ֙ לַֽיהוָ֣ה אֱלֹהֵ֔ינוּ כַּאֲשֶׁ֖ר יֹאמַ֥ר אֵלֵֽינוּ׃ ");
INSERT INTO hbo_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","וַיֹּ֣אמֶר פַּרְעֹ֗ה אָנֹכִ֞י אֲשַׁלַּ֤ח אֶתְכֶם֙ וּזְבַחְתֶּ֞ם לַיהוָ֤ה אֱלֹֽהֵיכֶם֙ בַּמִּדְבָּ֔ר רַ֛ק הַרְחֵ֥ק לֹא־תַרְחִ֖יקוּ לָלֶ֑כֶת הַעְתִּ֖ירוּ בַּעֲדִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","וַיֹּ֣אמֶר מֹשֶׁ֗ה הִנֵּ֨ה אָנֹכִ֜י יֹוצֵ֤א מֵֽעִמָּךְ֙ וְהַעְתַּרְתִּ֣י אֶל־יְהוָ֔ה וְסָ֣ר הֶעָרֹ֗ב מִפַּרְעֹ֛ה מֵעֲבָדָ֥יו וּמֵעַמֹּ֖ו מָחָ֑ר רַ֗ק אַל־יֹסֵ֤ף פַּרְעֹה֙ הָתֵ֔ל לְבִלְתִּי֙ שַׁלַּ֣ח אֶת־הָעָ֔ם לִזְבֹּ֖חַ לַֽיהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","וַיֵּצֵ֥א מֹשֶׁ֖ה מֵעִ֣ם פַּרְעֹ֑ה וַיֶּעְתַּ֖ר אֶל־יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","וַיַּ֤עַשׂ יְהוָה֙ כִּדְבַ֣ר מֹשֶׁ֔ה וַיָּ֙סַר֙ הֶעָרֹ֔ב מִפַּרְעֹ֖ה מֵעֲבָדָ֣יו וּמֵעַמֹּ֑ו לֹ֥א נִשְׁאַ֖ר אֶחָֽד׃ ");
INSERT INTO hbo_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","וַיַּכְבֵּ֤ד פַּרְעֹה֙ אֶת־לִבֹּ֔ו גַּ֖ם בַּפַּ֣עַם הַזֹּ֑את וְלֹ֥א שִׁלַּ֖ח אֶת־הָעָֽם׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","וַיֹּ֤אמֶר יְהוָה֙ אֶל־מֹשֶׁ֔ה בֹּ֖א אֶל־פַּרְעֹ֑ה וְדִבַּרְתָּ֣ אֵלָ֗יו כֹּֽה־אָמַ֤ר יְהוָה֙ אֱלֹהֵ֣י הָֽעִבְרִ֔ים שַׁלַּ֥ח אֶת־עַמִּ֖י וְיַֽעַבְדֻֽנִי׃ ");
INSERT INTO hbo_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","כִּ֛י אִם־מָאֵ֥ן אַתָּ֖ה לְשַׁלֵּ֑חַ וְעֹודְךָ֖ מַחֲזִ֥יק בָּֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","הִנֵּ֨ה יַד־יְהוָ֜ה הֹויָ֗ה בְּמִקְנְךָ֙ אֲשֶׁ֣ר בַּשָּׂדֶ֔ה בַּסּוּסִ֤ים בַּֽחֲמֹרִים֙ בַּגְּמַלִּ֔ים בַּבָּקָ֖ר וּבַצֹּ֑אן דֶּ֖בֶר כָּבֵ֥ד מְאֹֽד׃ ");
INSERT INTO hbo_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","וְהִפְלָ֣ה יְהוָ֔ה בֵּ֚ין מִקְנֵ֣ה יִשְׂרָאֵ֔ל וּבֵ֖ין מִקְנֵ֣ה מִצְרָ֑יִם וְלֹ֥א יָמ֛וּת מִכָּל־לִבְנֵ֥י יִשְׂרָאֵ֖ל דָּבָֽר׃ ");
INSERT INTO hbo_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","וַיָּ֥שֶׂם יְהוָ֖ה מֹועֵ֣ד לֵאמֹ֑ר מָחָ֗ר יַעֲשֶׂ֧ה יְהוָ֛ה הַדָּבָ֥ר הַזֶּ֖ה בָּאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","וַיַּ֨עַשׂ יְהוָ֜ה אֶת־הַדָּבָ֤ר הַזֶּה֙ מִֽמָּחֳרָ֔ת וַיָּ֕מָת כֹּ֖ל מִקְנֵ֣ה מִצְרָ֑יִם וּמִמִּקְנֵ֥ה בְנֵֽי־יִשְׂרָאֵ֖ל לֹא־מֵ֥ת אֶחָֽד׃ ");
INSERT INTO hbo_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","וַיִּשְׁלַ֣ח פַּרְעֹ֔ה וְהִנֵּ֗ה לֹא־מֵ֛ת מִמִּקְנֵ֥ה יִשְׂרָאֵ֖ל עַד־אֶחָ֑ד וַיִּכְבַּד֙ לֵ֣ב פַּרְעֹ֔ה וְלֹ֥א שִׁלַּ֖ח אֶת־הָעָֽם׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","וַיֹּ֣אמֶר יְהוָה֮ אֶל־מֹשֶׁ֣ה וְאֶֽל־אַהֲרֹן֒ קְח֤וּ לָכֶם֙ מְלֹ֣א חָפְנֵיכֶ֔ם פִּ֖יחַ כִּבְשָׁ֑ן וּזְרָקֹ֥ו מֹשֶׁ֛ה הַשָּׁמַ֖יְמָה לְעֵינֵ֥י פַרְעֹֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","וְהָיָ֣ה לְאָבָ֔ק עַ֖ל כָּל־אֶ֣רֶץ מִצְרָ֑יִם וְהָיָ֨ה עַל־הָאָדָ֜ם וְעַל־הַבְּהֵמָ֗ה לִשְׁחִ֥ין פֹּרֵ֛חַ אֲבַעְבֻּעֹ֖ת בְּכָל־אֶ֥רֶץ מִצְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","וַיִּקְח֞וּ אֶת־פִּ֣יחַ הַכִּבְשָׁ֗ן וַיַּֽעַמְדוּ֙ לִפְנֵ֣י פַרְעֹ֔ה וַיִּזְרֹ֥ק אֹתֹ֛ו מֹשֶׁ֖ה הַשָּׁמָ֑יְמָה וַיְהִ֗י שְׁחִין֙ אֲבַעְבֻּעֹ֔ת פֹּרֵ֕חַ בָּאָדָ֖ם וּבַבְּהֵמָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","וְלֹֽא־יָכְל֣וּ הֽ͏ַחַרְטֻמִּ֗ים לַעֲמֹ֛ד לִפְנֵ֥י מֹשֶׁ֖ה מִפְּנֵ֣י הַשְּׁחִ֑ין כִּֽי־הָיָ֣ה הַשְּׁחִ֔ין בּֽ͏ַחֲרְטֻמִּ֖ם וּבְכָל־מִצְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","וַיְחַזֵּ֤ק יְהוָה֙ אֶת־לֵ֣ב פַּרְעֹ֔ה וְלֹ֥א שָׁמַ֖ע אֲלֵהֶ֑ם כַּאֲשֶׁ֛ר דִּבֶּ֥ר יְהוָ֖ה אֶל־מֹשֶֽׁה׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","וַיֹּ֤אמֶר יְהוָה֙ אֶל־מֹשֶׁ֔ה הַשְׁכֵּ֣ם בַּבֹּ֔קֶר וְהִתְיַצֵּ֖ב לִפְנֵ֣י פַרְעֹ֑ה וְאָמַרְתָּ֣ אֵלָ֗יו כֹּֽה־אָמַ֤ר יְהוָה֙ אֱלֹהֵ֣י הָֽעִבְרִ֔ים שַׁלַּ֥ח אֶת־עַמִּ֖י וְיַֽעַבְדֻֽנִי׃ ");
INSERT INTO hbo_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","כִּ֣י ׀ בַּפַּ֣עַם הַזֹּ֗את אֲנִ֨י שֹׁלֵ֜חַ אֶת־כָּל־מַגֵּפֹתַי֙ אֶֽל־לִבְּךָ֔ וּבַעֲבָדֶ֖יךָ וּבְעַמֶּ֑ךָ בַּעֲב֣וּר תֵּדַ֔ע כִּ֛י אֵ֥ין כָּמֹ֖נִי בְּכָל־הָאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","כִּ֤י עַתָּה֙ שָׁלַ֣חְתִּי אֶת־יָדִ֔י וָאַ֥ךְ אֹותְךָ֛ וְאֶֽת־עַמְּךָ֖ בַּדָּ֑בֶר וַתִּכָּחֵ֖ד מִן־הָאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","וְאוּלָ֗ם בַּעֲב֥וּר זֹאת֙ הֶעֱמַדְתִּ֔יךָ בַּעֲב֖וּר הַרְאֹתְךָ֣ אֶת־כֹּחִ֑י וּלְמַ֛עַן סַפֵּ֥ר שְׁמִ֖י בְּכָל־הָאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","עֹודְךָ֖ מִסְתֹּולֵ֣ל בְּעַמִּ֑י לְבִלְתִּ֖י שַׁלְּחָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","הִנְנִ֤י מַמְטִיר֙ כָּעֵ֣ת מָחָ֔ר בָּרָ֖ד כָּבֵ֣ד מְאֹ֑ד אֲשֶׁ֨ר לֹא־הָיָ֤ה כָמֹ֙הוּ֙ בְּמִצְרַ֔יִם לְמִן־הַיֹּ֥ום הִוָּסְדָ֖ה וְעַד־עָֽתָּה׃ ");
INSERT INTO hbo_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","וְעַתָּ֗ה שְׁלַ֤ח הָעֵז֙ אֶֽת־מִקְנְךָ֔ וְאֵ֛ת כָּל־אֲשֶׁ֥ר לְךָ֖ בַּשָּׂדֶ֑ה כָּל־הָאָדָ֨ם וְהַבְּהֵמָ֜ה אֲשֶֽׁר־יִמָּצֵ֣א בַשָּׂדֶ֗ה וְלֹ֤א יֵֽאָסֵף֙ הַבַּ֔יְתָה וְיָרַ֧ד עֲלֵהֶ֛ם הַבָּרָ֖ד וָמֵֽתוּ׃ ");
INSERT INTO hbo_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","הַיָּרֵא֙ אֶת־דְּבַ֣ר יְהוָ֔ה מֵֽעַבְדֵ֖י פַּרְעֹ֑ה הֵנִ֛יס אֶת־עֲבָדָ֥יו וְאֶת־מִקְנֵ֖הוּ אֶל־הַבָּתִּֽים׃ ");
INSERT INTO hbo_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","וַאֲשֶׁ֥ר לֹא־שָׂ֛ם לִבֹּ֖ו אֶל־דְּבַ֣ר יְהוָ֑ה וַֽיַּעֲזֹ֛ב אֶת־עֲבָדָ֥יו וְאֶת־מִקְנֵ֖הוּ בַּשָּׂדֶֽה׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","וַיֹּ֨אמֶר יְהוָ֜ה אֶל־מֹשֶׁה נְטֵ֤ה אֶת־יָֽדְךָ֙ עַל־הַשָּׁמַ֔יִם וִיהִ֥י בָרָ֖ד בְּכָל־אֶ֣רֶץ מִצְרָ֑יִם עַל־הָאָדָ֣ם וְעַל־הַבְּהֵמָ֗ה וְעַ֛ל כָּל־עֵ֥שֶׂב הַשָּׂדֶ֖ה בְּאֶ֥רֶץ מִצְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","וַיֵּ֨ט מֹשֶׁ֣ה אֶת־מַטֵּהוּ֮ עַל־הַשָּׁמַיִם֒ וַֽיהוָ֗ה נָתַ֤ן קֹלֹת֙ וּבָרָ֔ד וַתִּ֥הֲלַךְ אֵ֖שׁ אָ֑רְצָה וַיַּמְטֵ֧ר יְהוָ֛ה בָּרָ֖ד עַל־אֶ֥רֶץ מִצְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","וַיְהִ֣י בָרָ֔ד וְאֵ֕שׁ מִתְלַקַּ֖חַת בְּתֹ֣וךְ הַבָּרָ֑ד כָּבֵ֣ד מְאֹ֔ד אֲ֠שֶׁר לֹֽא־הָיָ֤ה כָמֹ֙הוּ֙ בְּכָל־אֶ֣רֶץ מִצְרַ֔יִם מֵאָ֖ז הָיְתָ֥ה לְגֹֽוי׃ ");
INSERT INTO hbo_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","וַיַּ֨ךְ הַבָּרָ֜ד בְּכָל־אֶ֣רֶץ מִצְרַ֗יִם אֵ֚ת כָּל־אֲשֶׁ֣ר בַּשָּׂדֶ֔ה מֵאָדָ֖ם וְעַד־בְּהֵמָ֑ה וְאֵ֨ת כָּל־עֵ֤שֶׂב הַשָּׂדֶה֙ הִכָּ֣ה הַבָּרָ֔ד וְאֶת־כָּל־עֵ֥ץ הַשָּׂדֶ֖ה שִׁבֵּֽר׃ ");
INSERT INTO hbo_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","רַ֚ק בְּאֶ֣רֶץ גֹּ֔שֶׁן אֲשֶׁר־שָׁ֖ם בְּנֵ֣י יִשְׂרָאֵ֑ל לֹ֥א הָיָ֖ה בָּרָֽד׃ ");
INSERT INTO hbo_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","וַיִּשְׁלַ֣ח פַּרְעֹ֗ה וַיִּקְרָא֙ לְמֹשֶׁ֣ה וּֽלְאַהֲרֹ֔ן וַיֹּ֥אמֶר אֲלֵהֶ֖ם חָטָ֣אתִי הַפָּ֑עַם יְהוָה֙ הַצַּדִּ֔יק וַאֲנִ֥י וְעַמִּ֖י הָרְשָׁעִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","הַעְתִּ֙ירוּ֙ אֶל־יְהוָ֔ה וְרַ֕ב מִֽהְיֹ֛ת קֹלֹ֥ת אֱלֹהִ֖ים וּבָרָ֑ד וַאֲשַׁלְּחָ֣ה אֶתְכֶ֔ם וְלֹ֥א תֹסִפ֖וּן לַעֲמֹֽד׃ ");
INSERT INTO hbo_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","וַיֹּ֤אמֶר אֵלָיו֙ מֹשֶׁ֔ה כְּצֵאתִי֙ אֶת־הָעִ֔יר אֶפְרֹ֥שׂ אֶת־כַּפַּ֖י אֶל־יְהוָ֑ה הַקֹּלֹ֣ות יֶחְדָּל֗וּן וְהַבָּרָד֙ לֹ֣א יִֽהְיֶה־עֹ֔וד לְמַ֣עַן תֵּדַ֔ע כִּ֥י לַיהוָ֖ה הָאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","וְאַתָּ֖ה וַעֲבָדֶ֑יךָ יָדַ֕עְתִּי כִּ֚י טֶ֣רֶם תִּֽירְא֔וּן מִפְּנֵ֖י יְהוָ֥ה אֱלֹהִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","וְהַפִּשְׁתָּ֥ה וְהַשְּׂעֹרָ֖ה נֻכָּ֑תָה כִּ֤י הַשְּׂעֹרָה֙ אָבִ֔יב וְהַפִּשְׁתָּ֖ה גִּבְעֹֽל׃ ");
INSERT INTO hbo_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","וְהַחִטָּ֥ה וְהַכֻּסֶּ֖מֶת לֹ֣א נֻכּ֑וּ כִּ֥י אֲפִילֹ֖ת הֵֽנָּה׃ ");
INSERT INTO hbo_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","וַיֵּצֵ֨א מֹשֶׁ֜ה מֵעִ֤ם פַּרְעֹה֙ אֶת־הָעִ֔יר וַיִּפְרֹ֥שׂ כַּפָּ֖יו אֶל־יְהוָ֑ה וַֽיַּחְדְּל֤וּ הַקֹּלֹות֙ וְהַבָּרָ֔ד וּמָטָ֖ר לֹא־נִתַּ֥ךְ אָֽרְצָה׃ ");
INSERT INTO hbo_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","וַיַּ֣רְא פַּרְעֹ֗ה כִּֽי־חָדַ֨ל הַמָּטָ֧ר וְהַבָּרָ֛ד וְהַקֹּלֹ֖ת וַיֹּ֣סֶף לַחֲטֹ֑א וַיַּכְבֵּ֥ד לִבֹּ֖ו ה֥וּא וַעֲבָדָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","וַֽיֶּחֱזַק֙ לֵ֣ב פַּרְעֹ֔ה וְלֹ֥א שִׁלַּ֖ח אֶת־בְּנֵ֣י יִשְׂרָאֵ֑ל כַּאֲשֶׁ֛ר דִּבֶּ֥ר יְהוָ֖ה בְּיַד־מֹשֶֽׁה׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","וַיֹּ֤אמֶר יְהוָה֙ אֶל־מֹשֶׁ֔ה בֹּ֖א אֶל־פַּרְעֹ֑ה כִּֽי־אֲנִ֞י הִכְבַּ֤דְתִּי אֶת־לִבֹּו֙ וְאֶת־לֵ֣ב עֲבָדָ֔יו לְמַ֗עַן שִׁתִ֛י אֹתֹתַ֥י אֵ֖לֶּה בְּקִרְבֹּו׃ ");
INSERT INTO hbo_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","וּלְמַ֡עַן תְּסַפֵּר֩ בְּאָזְנֵ֨י בִנְךָ֜ וּבֶן־בִּנְךָ֗ אֵ֣ת אֲשֶׁ֤ר הִתְעַלַּ֙לְתִּי֙ בְּמִצְרַ֔יִם וְאֶת־אֹתֹתַ֖י אֲשֶׁר־שַׂ֣מְתִּי בָ֑ם וִֽידַעְתֶּ֖ם כִּי־אֲנִ֥י יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","וַיָּבֹ֨א מֹשֶׁ֣ה וְאַהֲרֹן֮ אֶל־פַּרְעֹה֒ וַיֹּאמְר֣וּ אֵלָ֗יו כֹּֽה־אָמַ֤ר יְהוָה֙ אֱלֹהֵ֣י הָֽעִבְרִ֔ים עַד־מָתַ֣י מֵאַ֔נְתָּ לֵעָנֹ֖ת מִפָּנָ֑י שַׁלַּ֥ח עַמִּ֖י וְיַֽעַבְדֻֽנִי׃ ");
INSERT INTO hbo_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","כִּ֛י אִם־מָאֵ֥ן אַתָּ֖ה לְשַׁלֵּ֣חַ אֶת־עַמִּ֑י הִנְנִ֨י מֵבִ֥יא מָחָ֛ר אַרְבֶּ֖ה בִּגְבֻלֶֽךָ׃ ");
INSERT INTO hbo_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","וְכִסָּה֙ אֶת־עֵ֣ין הָאָ֔רֶץ וְלֹ֥א יוּכַ֖ל לִרְאֹ֣ת אֶת־הָאָ֑רֶץ וְאָכַ֣ל ׀ אֶת־יֶ֣תֶר הַפְּלֵטָ֗ה הַנִּשְׁאֶ֤רֶת לָכֶם֙ מִן־הַבָּרָ֔ד וְאָכַל֙ אֶת־כָּל־הָעֵ֔ץ הַצֹּמֵ֥חַ לָכֶ֖ם מִן־הַשָּׂדֶֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","וּמָלְא֨וּ בָתֶּ֜יךָ וּבָתֵּ֣י כָל־עֲבָדֶיךָ֮ וּבָתֵּ֣י כָל־מִצְרַיִם֒ אֲשֶׁ֨ר לֹֽא־רָא֤וּ אֲבֹתֶ֙יךָ֙ וַאֲבֹ֣ות אֲבֹתֶ֔יךָ מִיֹּ֗ום הֱיֹותָם֙ עַל־הָ֣אֲדָמָ֔ה עַ֖ד הַיֹּ֣ום הַזֶּ֑ה וַיִּ֥פֶן וַיֵּצֵ֖א מֵעִ֥ם פַּרְעֹֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","וַיֹּאמְרוּ֩ עַבְדֵ֨י פַרְעֹ֜ה אֵלָ֗יו עַד־מָתַי֙ יִהְיֶ֨ה זֶ֥ה לָ֙נוּ֙ לְמֹוקֵ֔שׁ שַׁלַּח֙ אֶת־הָ֣אֲנָשִׁ֔ים וְיַֽעַבְד֖וּ אֶת־יְהוָ֣ה אֱלֹהֵיהֶ֑ם הֲטֶ֣רֶם תֵּדַ֔ע כִּ֥י אָבְדָ֖ה מִצְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","וַיּוּשַׁ֞ב אֶת־מֹשֶׁ֤ה וְאֶֽת־אַהֲרֹן֙ אֶל־פַּרְעֹ֔ה וַיֹּ֣אמֶר אֲלֵהֶ֔ם לְכ֥וּ עִבְד֖וּ אֶת־יְהוָ֣ה אֱלֹהֵיכֶ֑ם מִ֥י וָמִ֖י הַהֹלְכִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","וַיֹּ֣אמֶר מֹשֶׁ֔ה בִּנְעָרֵ֥ינוּ וּבִזְקֵנֵ֖ינוּ נֵלֵ֑ךְ בְּבָנֵ֨ינוּ וּבִבְנֹותֵ֜נוּ בְּצֹאנֵ֤נוּ וּבִבְקָרֵ֙נוּ֙ נֵלֵ֔ךְ כִּ֥י חַג־יְהוָ֖ה לָֽנוּ׃ ");
INSERT INTO hbo_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","וַיֹּ֣אמֶר אֲלֵהֶ֗ם יְהִ֨י כֵ֤ן יְהוָה֙ עִמָּכֶ֔ם כַּאֲשֶׁ֛ר אֲשַׁלַּ֥ח אֶתְכֶ֖ם וְאֶֽת־טַפְּכֶ֑ם רְא֕וּ כִּ֥י רָעָ֖ה נֶ֥גֶד פְּנֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","לֹ֣א כֵ֗ן לְכֽוּ־נָ֤א הַגְּבָרִים֙ וְעִבְד֣וּ אֶת־יְהוָ֔ה כִּ֥י אֹתָ֖הּ אַתֶּ֣ם מְבַקְשִׁ֑ים וַיְגָ֣רֶשׁ אֹתָ֔ם מֵאֵ֖ת פְּנֵ֥י פַרְעֹֽה׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","וַיֹּ֨אמֶר יְהוָ֜ה אֶל־מֹשֶׁ֗ה נְטֵ֨ה יָדְךָ֜ עַל־אֶ֤רֶץ מִצְרַ֙יִם֙ בָּֽאַרְבֶּ֔ה וְיַ֖עַל עַל־אֶ֣רֶץ מִצְרָ֑יִם וְיֹאכַל֙ אֶת־כָּל־עֵ֣שֶׂב הָאָ֔רֶץ אֵ֛ת כָּל־אֲשֶׁ֥ר הִשְׁאִ֖יר הַבָּרָֽד׃ ");
INSERT INTO hbo_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","וַיֵּ֨ט מֹשֶׁ֣ה אֶת־מַטֵּהוּ֮ עַל־אֶ֣רֶץ מִצְרַיִם֒ וֽ͏ַיהוָ֗ה נִהַ֤ג ר֥וּחַ קָדִים֙ בָּאָ֔רֶץ כָּל־הַיֹּ֥ום הַה֖וּא וְכָל־הַלָּ֑יְלָה הַבֹּ֣קֶר הָיָ֔ה וְר֙וּחַ֙ הַקָּדִ֔ים נָשָׂ֖א אֶת־הָאַרְבֶּֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","וַיַּ֣עַל הָֽאַרְבֶּ֗ה עַ֚ל כָּל־אֶ֣רֶץ מִצְרַ֔יִם וַיָּ֕נַח בְּכֹ֖ל גְּב֣וּל מִצְרָ֑יִם כָּבֵ֣ד מְאֹ֔ד לְ֠פָנָיו לֹא־הָ֨יָה כֵ֤ן אַרְבֶּה֙ כָּמֹ֔הוּ וְאַחֲרָ֖יו לֹ֥א יִֽהְיֶה־כֵּֽן׃ ");
INSERT INTO hbo_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","וַיְכַ֞ס אֶת־עֵ֣ין כָּל־הָאָרֶץ֮ וַתֶּחְשַׁ֣ךְ הָאָרֶץ֒ וַיֹּ֜אכַל אֶת־כָּל־עֵ֣שֶׂב הָאָ֗רֶץ וְאֵת֙ כָּל־פְּרִ֣י הָעֵ֔ץ אֲשֶׁ֥ר הֹותִ֖יר הַבָּרָ֑ד וְלֹא־נֹותַ֨ר כָּל־יֶ֧רֶק בָּעֵ֛ץ וּבְעֵ֥שֶׂב הַשָּׂדֶ֖ה בְּכָל־אֶ֥רֶץ מִצְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","וַיְמַהֵ֣ר פַּרְעֹ֔ה לִקְרֹ֖א לְמֹשֶׁ֣ה וּֽלְאַהֲרֹ֑ן וַיֹּ֗אמֶר חָטָ֛אתִי לַיהוָ֥ה אֱלֹֽהֵיכֶ֖ם וְלָכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","וְעַתָּ֗ה שָׂ֣א נָ֤א חַטָּאתִי֙ אַ֣ךְ הַפַּ֔עַם וְהַעְתִּ֖ירוּ לַיהוָ֣ה אֱלֹהֵיכֶ֑ם וְיָסֵר֙ מֵֽעָלַ֔י רַ֖ק אֶת־הַמָּ֥וֶת הַזֶּֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","וַיֵּצֵ֖א מֵעִ֣ם פַּרְעֹ֑ה וַיֶּעְתַּ֖ר אֶל־יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","וַיַּהֲפֹ֨ךְ יְהוָ֤ה רֽוּחַ־יָם֙ חָזָ֣ק מְאֹ֔ד וַיִּשָּׂא֙ אֶת־הָ֣אַרְבֶּ֔ה וַיִּתְקָעֵ֖הוּ יָ֣מָּה סּ֑וּף לֹ֤א נִשְׁאַר֙ אַרְבֶּ֣ה אֶחָ֔ד בְּכֹ֖ל גְּב֥וּל מִצְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","וַיְחַזֵּ֥ק יְהוָ֖ה אֶת־לֵ֣ב פַּרְעֹ֑ה וְלֹ֥א שִׁלַּ֖ח אֶת־בְּנֵ֥י יִשְׂרָאֵֽל׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","וַיֹּ֨אמֶר יְהוָ֜ה אֶל־מֹשֶׁ֗ה נְטֵ֤ה יָֽדְךָ֙ עַל־הַשָּׁמַ֔יִם וִ֥יהִי חֹ֖שֶׁךְ עַל־אֶ֣רֶץ מִצְרָ֑יִם וְיָמֵ֖שׁ חֹֽשֶׁךְ׃ ");
INSERT INTO hbo_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","וַיֵּ֥ט מֹשֶׁ֛ה אֶת־יָדֹ֖ו עַל־הַשָּׁמָ֑יִם וַיְהִ֧י חֹֽשֶׁךְ־אֲפֵלָ֛ה בְּכָל־אֶ֥רֶץ מִצְרַ֖יִם שְׁלֹ֥שֶׁת יָמִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","לֹֽא־רָא֞וּ אִ֣ישׁ אֶת־אָחִ֗יו וְלֹא־קָ֛מוּ אִ֥ישׁ מִתַּחְתָּ֖יו שְׁלֹ֣שֶׁת יָמִ֑ים וּֽלְכָל־בְּנֵ֧י יִשְׂרָאֵ֛ל הָ֥יָה אֹ֖ור בְּמֹושְׁבֹתָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","וַיִּקְרָ֨א פַרְעֹ֜ה אֶל־מֹשֶׁ֗ה וַיֹּ֙אמֶר֙ לְכוּ֙ עִבְד֣וּ אֶת־יְהוָ֔ה רַ֛ק צֹאנְכֶ֥ם וּבְקַרְכֶ֖ם יֻצָּ֑ג גַּֽם־טַפְּכֶ֖ם יֵלֵ֥ךְ עִמָּכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","וַיֹּ֣אמֶר מֹשֶׁ֔ה גַּם־אַתָּ֛ה תִּתֵּ֥ן בְּיָדֵ֖נוּ זְבָחִ֣ים וְעֹלֹ֑ות וְעָשִׂ֖ינוּ לַיהוָ֥ה אֱלֹהֵֽינוּ׃ ");
INSERT INTO hbo_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","וְגַם־מִקְנֵ֜נוּ יֵלֵ֣ךְ עִמָּ֗נוּ לֹ֤א תִשָּׁאֵר֙ פַּרְסָ֔ה כִּ֚י מִמֶּ֣נּוּ נִקַּ֔ח לַעֲבֹ֖ד אֶת־יְהוָ֣ה אֱלֹהֵ֑ינוּ וַאֲנַ֣חְנוּ לֹֽא־נֵדַ֗ע מַֽה־נַּעֲבֹד֙ אֶת־יְהוָ֔ה עַד־בֹּאֵ֖נוּ שָֽׁמָּה׃ ");
INSERT INTO hbo_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","וַיְחַזֵּ֥ק יְהוָ֖ה אֶת־לֵ֣ב פַּרְעֹ֑ה וְלֹ֥א אָבָ֖ה לְשַׁלְּחָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","וַיֹּֽאמֶר־לֹ֥ו פַרְעֹ֖ה לֵ֣ךְ מֵעָלָ֑י הִשָּׁ֣מֶר לְךָ֗ אֶל־תֹּ֙סֶף֙ רְאֹ֣ות פָּנַ֔י כִּ֗י בְּיֹ֛ום רְאֹתְךָ֥ פָנַ֖י תָּמֽוּת׃ ");
INSERT INTO hbo_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","וַיֹּ֥אמֶר מֹשֶׁ֖ה כֵּ֣ן דִּבַּ֑רְתָּ לֹא־אֹסִ֥ף עֹ֖וד רְאֹ֥ות פָּנֶֽיךָ׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","וַיֹּ֨אמֶר יְהוָ֜ה אֶל־מֹשֶׁ֗ה עֹ֣וד נֶ֤גַע אֶחָד֙ אָבִ֤יא עַל־פַּרְעֹה֙ וְעַל־מִצְרַ֔יִם אֽ͏ַחֲרֵי־כֵ֕ן יְשַׁלַּ֥ח אֶתְכֶ֖ם מִזֶּ֑ה כְּשַׁ֨לְּחֹ֔ו כָּלָ֕ה גָּרֵ֛שׁ יְגָרֵ֥שׁ אֶתְכֶ֖ם מִזֶּֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","דַּבֶּר־נָ֖א בְּאָזְנֵ֣י הָעָ֑ם וְיִשְׁאֲל֞וּ אִ֣ישׁ ׀ מֵאֵ֣ת רֵעֵ֗הוּ וְאִשָּׁה֙ מֵאֵ֣ת רְעוּתָ֔הּ כְּלֵי־כֶ֖סֶף וּכְלֵ֥י זָהָֽב׃ ");
INSERT INTO hbo_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","וַיִּתֵּ֧ן יְהוָ֛ה אֶת־חֵ֥ן הָעָ֖ם בְּעֵינֵ֣י מִצְרָ֑יִם גַּ֣ם ׀ הָאִ֣ישׁ מֹשֶׁ֗ה גָּדֹ֤ול מְאֹד֙ בְּאֶ֣רֶץ מִצְרַ֔יִם בְּעֵינֵ֥י עַבְדֵֽי־פַרְעֹ֖ה וּבְעֵינֵ֥י הָעָֽם׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","וַיֹּ֣אמֶר מֹשֶׁ֔ה כֹּ֖ה אָמַ֣ר יְהוָ֑ה כַּחֲצֹ֣ת הַלַּ֔יְלָה אֲנִ֥י יֹוצֵ֖א בְּתֹ֥וךְ מִצְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","וּמֵ֣ת כָּל־בְּכֹור֮ בְּאֶ֣רֶץ מִצְרַיִם֒ מִבְּכֹ֤ור פַּרְעֹה֙ הַיֹּשֵׁ֣ב עַל־כִּסְאֹ֔ו עַ֚ד בְּכֹ֣ור הַשִּׁפְחָ֔ה אֲשֶׁ֖ר אַחַ֣ר הָרֵחָ֑יִם וְכֹ֖ל בְּכֹ֥ור בְּהֵמָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","וְהָֽיְתָ֛ה צְעָקָ֥ה גְדֹלָ֖ה בְּכָל־אֶ֣רֶץ מִצְרָ֑יִם אֲשֶׁ֤ר כָּמֹ֙הוּ֙ לֹ֣א נִהְיָ֔תָה וְכָמֹ֖הוּ לֹ֥א תֹסִֽף׃ ");
INSERT INTO hbo_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","וּלְכֹ֣ל ׀ בְּנֵ֣י יִשְׂרָאֵ֗ל לֹ֤א יֶֽחֱרַץ־כֶּ֙לֶב֙ לְשֹׁנֹ֔ו לְמֵאִ֖ישׁ וְעַד־בְּהֵמָ֑ה לְמַ֙עַן֙ תֵּֽדְע֔וּן אֲשֶׁר֙ יַפְלֶ֣ה יְהוָ֔ה בֵּ֥ין מִצְרַ֖יִם וּבֵ֥ין יִשְׂרָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","וְיָרְד֣וּ כָל־עֲבָדֶיךָ֩ אֵ֨לֶּה אֵלַ֜י וְהִשְׁתַּֽחֲוּוּ־לִ֣י לֵאמֹ֗ר צֵ֤א אַתָּה֙ וְכָל־הָעָ֣ם אֲשֶׁר־בְּרַגְלֶ֔יךָ וְאַחֲרֵי־כֵ֖ן אֵצֵ֑א וַיֵּצֵ֥א מֵֽעִם־פַּרְעֹ֖ה בָּחֳרִי־אָֽף׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","וַיֹּ֤אמֶר יְהוָה֙ אֶל־מֹשֶׁ֔ה לֹא־יִשְׁמַ֥ע אֲלֵיכֶ֖ם פַּרְעֹ֑ה לְמַ֛עַן רְבֹ֥ות מֹופְתַ֖י בְּאֶ֥רֶץ מִצְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","וּמֹשֶׁ֣ה וְאַהֲרֹ֗ן עָשׂ֛וּ אֶת־כָּל־הַמֹּפְתִ֥ים הָאֵ֖לֶּה לִפְנֵ֣י פַרְעֹ֑ה וַיְחַזֵּ֤ק יְהוָה֙ אֶת־לֵ֣ב פַּרְעֹ֔ה וְלֹֽא־שִׁלַּ֥ח אֶת־בְּנֵֽי־יִשְׂרָאֵ֖ל מֵאַרְצֹֽו׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","וַיֹּ֤אמֶר יְהוָה֙ אֶל־מֹשֶׁ֣ה וְאֶֽל־אַהֲרֹ֔ן בְּאֶ֥רֶץ מִצְרַ֖יִם לֵאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","הַחֹ֧דֶשׁ הַזֶּ֛ה לָכֶ֖ם רֹ֣אשׁ חֳדָשִׁ֑ים רִאשֹׁ֥ון הוּא֙ לָכֶ֔ם לְחָדְשֵׁ֖י הַשָּׁנָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","דַּבְּר֗וּ אֶֽל־כָּל־עֲדַ֤ת יִשְׂרָאֵל֙ לֵאמֹ֔ר בֶּעָשֹׂ֖ר לַחֹ֣דֶשׁ הַזֶּ֑ה וְיִקְח֣וּ לָהֶ֗ם אִ֛ישׁ שֶׂ֥ה לְבֵית־אָבֹ֖ת שֶׂ֥ה לַבָּֽיִת׃ ");
INSERT INTO hbo_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","וְאִם־יִמְעַ֣ט הַבַּיִת֮ מִהְיֹ֣ת מִשֶּׂה֒ וְלָקַ֣ח ה֗וּא וּשְׁכֵנֹ֛ו הַקָּרֹ֥ב אֶל־בֵּיתֹ֖ו בְּמִכְסַ֣ת נְפָשֹׁ֑ת אִ֚ישׁ לְפִ֣י אָכְלֹ֔ו תָּכֹ֖סּוּ עַל־הַשֶּֽׂה׃ ");
INSERT INTO hbo_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","שֶׂ֥ה תָמִ֛ים זָכָ֥ר בֶּן־שָׁנָ֖ה יִהְיֶ֣ה לָכֶ֑ם מִן־הַכְּבָשִׂ֥ים וּמִן־הָעִזִּ֖ים תִּקָּֽחוּ׃ ");
INSERT INTO hbo_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","וְהָיָ֤ה לָכֶם֙ לְמִשְׁמֶ֔רֶת עַ֣ד אַרְבָּעָ֥ה עָשָׂ֛ר יֹ֖ום לַחֹ֣דֶשׁ הַזֶּ֑ה וְשָׁחֲט֣וּ אֹתֹ֗ו כֹּ֛ל קְהַ֥ל עֲדַֽת־יִשְׂרָאֵ֖ל בֵּ֥ין הָעַרְבָּֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","וְלָֽקְחוּ֙ מִן־הַדָּ֔ם וְנָֽתְנ֛וּ עַל־שְׁתֵּ֥י הַמְּזוּזֹ֖ת וְעַל־הַמַּשְׁקֹ֑וף עַ֚ל הַבָּ֣תִּ֔ים אֲשֶׁר־יֹאכְל֥וּ אֹתֹ֖ו בָּהֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","וְאָכְל֥וּ אֶת־הַבָּשָׂ֖ר בַּלַּ֣יְלָה הַזֶּ֑ה צְלִי־אֵ֣שׁ וּמַצֹּ֔ות עַל־מְרֹרִ֖ים יֹאכְלֻֽהוּ׃ ");
INSERT INTO hbo_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","אַל־תֹּאכְל֤וּ מִמֶּ֙נּוּ֙ נָ֔א וּבָשֵׁ֥ל מְבֻשָּׁ֖ל בַּמָּ֑יִם כִּ֣י אִם־צְלִי־אֵ֔שׁ רֹאשֹׁ֥ו עַל־כְּרָעָ֖יו וְעַל־קִרְבֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","וְלֹא־תֹותִ֥ירוּ מִמֶּ֖נּוּ עַד־בֹּ֑קֶר וְהַנֹּתָ֥ר מִמֶּ֛נּוּ עַד־בֹּ֖קֶר בָּאֵ֥שׁ תִּשְׂרֹֽפוּ׃ ");
INSERT INTO hbo_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","וְכָכָה֮ תֹּאכְל֣וּ אֹתֹו֒ מָתְנֵיכֶ֣ם חֲגֻרִ֔ים נֽ͏ַעֲלֵיכֶם֙ בְּרַגְלֵיכֶ֔ם וּמַקֶּלְכֶ֖ם בְּיֶדְכֶ֑ם וַאֲכַלְתֶּ֤ם אֹתֹו֙ בְּחִפָּזֹ֔ון פֶּ֥סַח ה֖וּא לַיהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","וְעָבַרְתִּ֣י בְאֶֽרֶץ־מִצְרַיִם֮ בַּלַּ֣יְלָה הַזֶּה֒ וְהִכֵּיתִ֤י כָל־בְּכֹור֙ בְּאֶ֣רֶץ מִצְרַ֔יִם מֵאָדָ֖ם וְעַד־בְּהֵמָ֑ה וּבְכָל־אֱלֹהֵ֥י מִצְרַ֛יִם אֶֽעֱשֶׂ֥ה שְׁפָטִ֖ים אֲנִ֥י יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","וְהָיָה֩ הַדָּ֨ם לָכֶ֜ם לְאֹ֗ת עַ֤ל הַבָּתִּים֙ אֲשֶׁ֣ר אַתֶּ֣ם שָׁ֔ם וְרָאִ֙יתִי֙ אֶת־הַדָּ֔ם וּפָסַחְתִּ֖י עֲלֵכֶ֑ם וְלֹֽא־יִֽהְיֶ֨ה בָכֶ֥ם נֶ֙גֶף֙ לְמַשְׁחִ֔ית בְּהַכֹּתִ֖י בְּאֶ֥רֶץ מִצְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","וְהָיָה֩ הַיֹּ֨ום הַזֶּ֤ה לָכֶם֙ לְזִכָּרֹ֔ון וְחַגֹּתֶ֥ם אֹתֹ֖ו חַ֣ג לַֽיהוָ֑ה לְדֹרֹ֣תֵיכֶ֔ם חֻקַּ֥ת עֹולָ֖ם תְּחָגֻּֽהוּ׃ ");
INSERT INTO hbo_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","שִׁבְעַ֤ת יָמִים֙ מַצֹּ֣ות תֹּאכֵ֔לוּ אַ֚ךְ בַּיֹּ֣ום הָרִאשֹׁ֔ון תַּשְׁבִּ֥יתוּ שְּׂאֹ֖ר מִבָּתֵּיכֶ֑ם כִּ֣י ׀ כָּל־אֹכֵ֣ל חָמֵ֗ץ וְנִכְרְתָ֞ה הַנֶּ֤פֶשׁ הַהִוא֙ מִיִּשְׂרָאֵ֔ל מִיֹּ֥ום הָרִאשֹׁ֖ן עַד־יֹ֥ום הַשְּׁבִעִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","וּבַיֹּ֤ום הָרִאשֹׁון֙ מִקְרָא־קֹ֔דֶשׁ וּבַיֹּום֙ הַשְּׁבִיעִ֔י מִקְרָא־קֹ֖דֶשׁ יִהְיֶ֣ה לָכֶ֑ם כָּל־מְלָאכָה֙ לֹא־יֵעָשֶׂ֣ה בָהֶ֔ם אַ֚ךְ אֲשֶׁ֣ר יֵאָכֵ֣ל לְכָל־נֶ֔פֶשׁ ה֥וּא לְבַדֹּ֖ו יֵעָשֶׂ֥ה לָכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","וּשְׁמַרְתֶּם֮ אֶת־הַמַּצֹּות֒ כִּ֗י בְּעֶ֙צֶם֙ הַיֹּ֣ום הַזֶּ֔ה הֹוצֵ֥אתִי אֶת־צִבְאֹותֵיכֶ֖ם מֵאֶ֣רֶץ מִצְרָ֑יִם וּשְׁמַרְתֶּ֞ם אֶת־הַיֹּ֥ום הַזֶּ֛ה לְדֹרֹתֵיכֶ֖ם חֻקַּ֥ת עֹולָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","בָּרִאשֹׁ֡ן בְּאַרְבָּעָה֩ עָשָׂ֨ר יֹ֤ום לַחֹ֙דֶשׁ֙ בָּעֶ֔רֶב תֹּאכְל֖וּ מַצֹּ֑ת עַ֠ד יֹ֣ום הָאֶחָ֧ד וְעֶשְׂרִ֛ים לַחֹ֖דֶשׁ בָּעָֽרֶב׃ ");
INSERT INTO hbo_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","שִׁבְעַ֣ת יָמִ֔ים שְׂאֹ֕ר לֹ֥א יִמָּצֵ֖א בְּבָתֵּיכֶ֑ם כִּ֣י ׀ כָּל־אֹכֵ֣ל מַחְמֶ֗צֶת וְנִכְרְתָ֞ה הַנֶּ֤פֶשׁ הַהִוא֙ מֵעֲדַ֣ת יִשְׂרָאֵ֔ל בַּגֵּ֖ר וּבְאֶזְרַ֥ח הָאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","כָּל־מַחְמֶ֖צֶת לֹ֣א תֹאכֵ֑לוּ בְּכֹל֙ מֹושְׁבֹ֣תֵיכֶ֔ם תֹּאכְל֖וּ מַצֹּֽות׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","וַיִּקְרָ֥א מֹשֶׁ֛ה לְכָל־זִקְנֵ֥י יִשְׂרָאֵ֖ל וַיֹּ֣אמֶר אֲלֵהֶ֑ם מִֽשְׁכ֗וּ וּקְח֨וּ לָכֶ֥ם צֹ֛אן לְמִשְׁפְּחֹתֵיכֶ֖ם וְשַׁחֲט֥וּ הַפָּֽסַח׃ ");
INSERT INTO hbo_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","וּלְקַחְתֶּ֞ם אֲגֻדַּ֣ת אֵזֹ֗וב וּטְבַלְתֶּם֮ בַּדָּ֣ם אֲשֶׁר־בַּסַּף֒ וְהִגַּעְתֶּ֤ם אֶל־הַמַּשְׁקֹוף֙ וְאֶל־שְׁתֵּ֣י הַמְּזוּזֹ֔ת מִן־הַדָּ֖ם אֲשֶׁ֣ר בַּסָּ֑ף וְאַתֶּ֗ם לֹ֥א תֵצְא֛וּ אִ֥ישׁ מִפֶּֽתַח־בֵּיתֹ֖ו עַד־בֹּֽקֶר׃ ");
INSERT INTO hbo_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","וְעָבַ֣ר יְהוָה֮ לִנְגֹּ֣ף אֶת־מִצְרַיִם֒ וְרָאָ֤ה אֶת־הַדָּם֙ עַל־הַמַּשְׁקֹ֔וף וְעַ֖ל שְׁתֵּ֣י הַמְּזוּזֹ֑ת וּפָסַ֤ח יְהוָה֙ עַל־הַפֶּ֔תַח וְלֹ֤א יִתֵּן֙ הַמַּשְׁחִ֔ית לָבֹ֥א אֶל־בָּתֵּיכֶ֖ם לִנְגֹּֽף׃ ");
INSERT INTO hbo_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","וּשְׁמַרְתֶּ֖ם אֶת־הַדָּבָ֣ר הַזֶּ֑ה לְחָק־לְךָ֥ וּלְבָנֶ֖יךָ עַד־עֹולָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","וְהָיָ֞ה כִּֽי־תָבֹ֣אוּ אֶל־הָאָ֗רֶץ אֲשֶׁ֨ר יִתֵּ֧ן יְהוָ֛ה לָכֶ֖ם כַּאֲשֶׁ֣ר דִּבֵּ֑ר וּשְׁמַרְתֶּ֖ם אֶת־הָעֲבֹדָ֥ה הַזֹּֽאת׃ ");
INSERT INTO hbo_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","וְהָיָ֕ה כִּֽי־יֹאמְר֥וּ אֲלֵיכֶ֖ם בְּנֵיכֶ֑ם מָ֛ה הָעֲבֹדָ֥ה הַזֹּ֖את לָכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","וַאֲמַרְתֶּ֡ם זֶֽבַח־פֶּ֨סַח ה֜וּא לַֽיהוָ֗ה אֲשֶׁ֣ר פָּ֠סַח עַל־בָּתֵּ֤י בְנֵֽי־יִשְׂרָאֵל֙ בְּמִצְרַ֔יִם בְּנָגְפֹּ֥ו אֶת־מִצְרַ֖יִם וְאֶת־בָּתֵּ֣ינוּ הִצִּ֑יל וַיִּקֹּ֥ד הָעָ֖ם וַיִּֽשְׁתַּחֲוּֽוּ׃ ");
INSERT INTO hbo_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","וַיֵּלְכ֥וּ וַיּֽ͏ַעֲשׂ֖וּ בְּנֵ֣י יִשְׂרָאֵ֑ל כַּאֲשֶׁ֨ר צִוָּ֧ה יְהוָ֛ה אֶת־מֹשֶׁ֥ה וְאַהֲרֹ֖ן כֵּ֥ן עָשֽׂוּ׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","וַיְהִ֣י ׀ בַּחֲצִ֣י הַלַּ֗יְלָה וַֽיהוָה֮ הִכָּ֣ה כָל־בְּכֹור֮ בְּאֶ֣רֶץ מִצְרַיִם֒ מִבְּכֹ֤ר פַּרְעֹה֙ הַיֹּשֵׁ֣ב עַל־כִּסְאֹ֔ו עַ֚ד בְּכֹ֣ור הַשְּׁבִ֔י אֲשֶׁ֖ר בְּבֵ֣ית הַבֹּ֑ור וְכֹ֖ל בְּכֹ֥ור בְּהֵמָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","וַיָּ֨קָם פַּרְעֹ֜ה לַ֗יְלָה ה֤וּא וְכָל־עֲבָדָיו֙ וְכָל־מִצְרַ֔יִם וַתְּהִ֛י צְעָקָ֥ה גְדֹלָ֖ה בְּמִצְרָ֑יִם כִּֽי־אֵ֣ין בַּ֔יִת אֲשֶׁ֥ר אֵֽין־שָׁ֖ם מֵֽת׃ ");
INSERT INTO hbo_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","וַיִּקְרָא֩ לְמֹשֶׁ֨ה וּֽלְאַהֲרֹ֜ן לַ֗יְלָה וַיֹּ֙אמֶר֙ ק֤וּמוּ צְּאוּ֙ מִתֹּ֣וךְ עַמִּ֔י גַּם־אַתֶּ֖ם גַּם־בְּנֵ֣י יִשְׂרָאֵ֑ל וּלְכ֛וּ עִבְד֥וּ אֶת־יְהוָ֖ה כְּדַבֶּרְכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","גַּם־צֹאנְכֶ֨ם גַּם־בְּקַרְכֶ֥ם קְח֛וּ כַּאֲשֶׁ֥ר דִּבַּרְתֶּ֖ם וָלֵ֑כוּ וּבֵֽרַכְתֶּ֖ם גַּם־אֹתִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","וַתֶּחֱזַ֤ק מִצְרַ֙יִם֙ עַל־הָעָ֔ם לְמַהֵ֖ר לְשַׁלְּחָ֣ם מִן־הָאָ֑רֶץ כִּ֥י אָמְר֖וּ כֻּלָּ֥נוּ מֵתִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","וַיִּשָּׂ֥א הָעָ֛ם אֶת־בְּצֵקֹ֖ו טֶ֣רֶם יֶחְמָ֑ץ מִשְׁאֲרֹתָ֛ם צְרֻרֹ֥ת בְּשִׂמְלֹתָ֖ם עַל־שִׁכְמָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","וּבְנֵי־יִשְׂרָאֵ֥ל עָשׂ֖וּ כִּדְבַ֣ר מֹשֶׁ֑ה וַֽיִּשְׁאֲלוּ֙ מִמִּצְרַ֔יִם כְּלֵי־כֶ֛סֶף וּכְלֵ֥י זָהָ֖ב וּשְׂמָלֹֽת׃ ");
INSERT INTO hbo_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","וַֽיהוָ֞ה נָתַ֨ן אֶת־חֵ֥ן הָעָ֛ם בְּעֵינֵ֥י מִצְרַ֖יִם וַיַּשְׁאִל֑וּם וַֽיְנַצְּל֖וּ אֶת־מִצְרָֽיִם׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","וַיִּסְע֧וּ בְנֵֽי־יִשְׂרָאֵ֛ל מֵרַעְמְסֵ֖ס סֻכֹּ֑תָה כְּשֵׁשׁ־מֵאֹ֨ות אֶ֧לֶף רַגְלִ֛י הַגְּבָרִ֖ים לְבַ֥ד מִטָּֽף׃ ");
INSERT INTO hbo_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","וְגַם־עֵ֥רֶב רַ֖ב עָלָ֣ה אִתָּ֑ם וְצֹ֣אן וּבָקָ֔ר מִקְנֶ֖ה כָּבֵ֥ד מְאֹֽד׃ ");
INSERT INTO hbo_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","וַיֹּאפ֨וּ אֶת־הַבָּצֵ֜ק אֲשֶׁ֨ר הֹוצִ֧יאוּ מִמִּצְרַ֛יִם עֻגֹ֥ת מַצֹּ֖ות כִּ֣י לֹ֣א חָמֵ֑ץ כִּֽי־גֹרְשׁ֣וּ מִמִּצְרַ֗יִם וְלֹ֤א יָֽכְלוּ֙ לְהִתְמַהְמֵ֔הַּ וְגַם־צֵדָ֖ה לֹא־עָשׂ֥וּ לָהֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","וּמֹושַׁב֙ בְּנֵ֣י יִשְׂרָאֵ֔ל אֲשֶׁ֥ר יָשְׁב֖וּ בְּמִצְרָ֑יִם שְׁלֹשִׁ֣ים שָׁנָ֔ה וְאַרְבַּ֥ע מֵאֹ֖ות שָׁנָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","וַיְהִ֗י מִקֵּץ֙ שְׁלֹשִׁ֣ים שָׁנָ֔ה וְאַרְבַּ֥ע מֵאֹ֖ות שָׁנָ֑ה וַיְהִ֗י בְּעֶ֙צֶם֙ הַיֹּ֣ום הַזֶּ֔ה יָֽצְא֛וּ כָּל־צִבְאֹ֥ות יְהוָ֖ה מֵאֶ֥רֶץ מִצְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","לֵ֣יל שִׁמֻּרִ֥ים הוּא֙ לַֽיהוָ֔ה לְהֹוצִיאָ֖ם מֵאֶ֣רֶץ מִצְרָ֑יִם הֽוּא־הַלַּ֤יְלָה הַזֶּה֙ לַֽיהוָ֔ה שִׁמֻּרִ֛ים לְכָל־בְּנֵ֥י יִשְׂרָאֵ֖ל לְדֹרֹתָֽם׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","וַיֹּ֤אמֶר יְהוָה֙ אֶל־מֹשֶׁ֣ה וְאַהֲרֹ֔ן זֹ֖את חֻקַּ֣ת הַפָּ֑סַח כָּל־בֶּן־נֵכָ֖ר לֹא־יֹ֥אכַל בֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","וְכָל־עֶ֥בֶד אִ֖ישׁ מִקְנַת־כָּ֑סֶף וּמַלְתָּ֣ה אֹתֹ֔ו אָ֖ז יֹ֥אכַל בֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","תֹּושָׁ֥ב וְשָׂכִ֖יר לֹא־יֹ֥אכַל־בֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","בְּבַ֤יִת אֶחָד֙ יֵאָכֵ֔ל לֹא־תֹוצִ֧יא מִן־הַבַּ֛יִת מִן־הַבָּשָׂ֖ר ח֑וּצָה וְעֶ֖צֶם לֹ֥א תִשְׁבְּרוּ־בֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","כָּל־עֲדַ֥ת יִשְׂרָאֵ֖ל יַעֲשׂ֥וּ אֹתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","וְכִֽי־יָג֨וּר אִתְּךָ֜ גֵּ֗ר וְעָ֣שָׂה פֶסַח֮ לַיהוָה֒ הִמֹּ֧ול לֹ֣ו כָל־זָכָ֗ר וְאָז֙ יִקְרַ֣ב לַעֲשֹׂתֹ֔ו וְהָיָ֖ה כְּאֶזְרַ֣ח הָאָ֑רֶץ וְכָל־עָרֵ֖ל לֹֽא־יֹ֥אכַל בֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","תֹּורָ֣ה אַחַ֔ת יִהְיֶ֖ה לָֽאֶזְרָ֑ח וְלַגֵּ֖ר הַגָּ֥ר בְּתֹוכְכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","וַיּֽ͏ַעֲשׂ֖וּ כָּל־בְּנֵ֣י יִשְׂרָאֵ֑ל כַּאֲשֶׁ֨ר צִוָּ֧ה יְהוָ֛ה אֶת־מֹשֶׁ֥ה וְאֶֽת־אַהֲרֹ֖ן כֵּ֥ן עָשֽׂוּ׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","וַיְהִ֕י בְּעֶ֖צֶם הַיֹּ֣ום הַזֶּ֑ה הֹוצִ֨יא יְהוָ֜ה אֶת־בְּנֵ֧י יִשְׂרָאֵ֛ל מֵאֶ֥רֶץ מִצְרַ֖יִם עַל־צִבְאֹתָֽם׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","קַדֶּשׁ־לִ֨י כָל־בְּכֹ֜ור פֶּ֤טֶר כָּל־רֶ֙חֶם֙ בִּבְנֵ֣י יִשְׂרָאֵ֔ל בָּאָדָ֖ם וּבַבְּהֵמָ֑ה לִ֖י הֽוּא׃ ");
INSERT INTO hbo_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","וַיֹּ֨אמֶר מֹשֶׁ֜ה אֶל־הָעָ֗ם זָכֹ֞ור אֶת־הַיֹּ֤ום הַזֶּה֙ אֲשֶׁ֨ר יְצָאתֶ֤ם מִמִּצְרַ֙יִם֙ מִבֵּ֣ית עֲבָדִ֔ים כִּ֚י בְּחֹ֣זֶק יָ֔ד הֹוצִ֧יא יְהֹוָ֛ה אֶתְכֶ֖ם מִזֶּ֑ה וְלֹ֥א יֵאָכֵ֖ל חָמֵֽץ׃ ");
INSERT INTO hbo_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","הַיֹּ֖ום אַתֶּ֣ם יֹצְאִ֑ים בְּחֹ֖דֶשׁ הָאָבִֽיב׃ ");
INSERT INTO hbo_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","וְהָיָ֣ה כִֽי־יְבִֽיאֲךָ֣ יְהוָ֡ה אֶל־אֶ֣רֶץ הַֽ֠כְּנַעֲנִי וְהַחִתִּ֨י וְהָאֱמֹרִ֜י וְהַחִוִּ֣י וְהַיְבוּסִ֗י אֲשֶׁ֨ר נִשְׁבַּ֤ע לַאֲבֹתֶ֙יךָ֙ לָ֣תֶת לָ֔ךְ אֶ֛רֶץ זָבַ֥ת חָלָ֖ב וּדְבָ֑שׁ וְעָבַדְתָּ֛ אֶת־הָעֲבֹדָ֥ה הַזֹּ֖את בַּחֹ֥דֶשׁ הַזֶּֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","שִׁבְעַ֥ת יָמִ֖ים תֹּאכַ֣ל מַצֹּ֑ת וּבַיֹּום֙ הַשְּׁבִיעִ֔י חַ֖ג לַיהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","מַצֹּות֙ יֵֽאָכֵ֔ל אֵ֖ת שִׁבְעַ֣ת הַיָּמִ֑ים וְלֹֽא־יֵרָאֶ֨ה לְךָ֜ חָמֵ֗ץ וְלֹֽא־יֵרָאֶ֥ה לְךָ֛ שְׂאֹ֖ר בְּכָל־גְּבֻלֶֽךָ׃ ");
INSERT INTO hbo_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","וְהִגַּדְתָּ֣ לְבִנְךָ֔ בַּיֹּ֥ום הַה֖וּא לֵאמֹ֑ר בַּעֲב֣וּר זֶ֗ה עָשָׂ֤ה יְהוָה֙ לִ֔י בְּצֵאתִ֖י מִמִּצְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","וְהָיָה֩ לְךָ֨ לְאֹ֜ות עַל־יָדְךָ֗ וּלְזִכָּרֹון֙ בֵּ֣ין עֵינֶ֔יךָ לְמַ֗עַן תִּהְיֶ֛ה תֹּורַ֥ת יְהוָ֖ה בְּפִ֑יךָ כִּ֚י בְּיָ֣ד חֲזָקָ֔ה הֹוצִֽאֲךָ֥ יְהֹוָ֖ה מִמִּצְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","וְשָׁמַרְתָּ֛ אֶת־הַחֻקָּ֥ה הַזֹּ֖את לְמֹועֲדָ֑הּ מִיָּמִ֖ים יָמִֽימָה׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","וְהָיָ֞ה כִּֽי־יְבִֽאֲךָ֤ יְהוָה֙ אֶל־אֶ֣רֶץ הַֽכְּנַעֲנִ֔י כַּאֲשֶׁ֛ר נִשְׁבַּ֥ע לְךָ֖ וְלַֽאֲבֹתֶ֑יךָ וּנְתָנָ֖הּ לָֽךְ׃ ");
INSERT INTO hbo_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","וְהַעֲבַרְתָּ֥ כָל־פֶּֽטֶר־רֶ֖חֶם לַֽיהֹוָ֑ה וְכָל־פֶּ֣טֶר ׀ שֶׁ֣גֶר בְּהֵמָ֗ה אֲשֶׁ֨ר יִהְיֶ֥ה לְךָ֛ הַזְּכָרִ֖ים לַיהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","וְכָל־פֶּ֤טֶר חֲמֹר֙ תִּפְדֶּ֣ה בְשֶׂ֔ה וְאִם־לֹ֥א תִפְדֶּ֖ה וַעֲרַפְתֹּ֑ו וְכֹ֨ל בְּכֹ֥ור אָדָ֛ם בְּבָנֶ֖יךָ תִּפְדֶּֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","וְהָיָ֞ה כִּֽי־יִשְׁאָלְךָ֥ בִנְךָ֛ מָחָ֖ר לֵאמֹ֣ר מַה־זֹּ֑את וְאָמַרְתָּ֣ אֵלָ֔יו בְּחֹ֣זֶק יָ֗ד הֹוצִיאָ֧נוּ יְהוָ֛ה מִמִּצְרַ֖יִם מִבֵּ֥ית עֲבָדִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","וַיְהִ֗י כִּֽי־הִקְשָׁ֣ה פַרְעֹה֮ לְשַׁלְּחֵנוּ֒ וַיַּהֲרֹ֨ג יְהֹוָ֤ה כָּל־בְּכֹור֙ בְּאֶ֣רֶץ מִצְרַ֔יִם מִבְּכֹ֥ר אָדָ֖ם וְעַד־בְּכֹ֣ור בְּהֵמָ֑ה עַל־כֵּן֩ אֲנִ֨י זֹבֵ֜חַ לַֽיהוָ֗ה כָּל־פֶּ֤טֶר רֶ֙חֶם֙ הַזְּכָרִ֔ים וְכָל־בְּכֹ֥ור בָּנַ֖י אֶפְדֶּֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","וְהָיָ֤ה לְאֹות֙ עַל־יָ֣דְכָ֔ה וּלְטֹוטָפֹ֖ת בֵּ֣ין עֵינֶ֑יךָ כִּ֚י בְּחֹ֣זֶק יָ֔ד הֹוצִיאָ֥נוּ יְהוָ֖ה מִמִּצְרָֽיִם׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","וַיְהִ֗י בְּשַׁלַּ֣ח פַּרְעֹה֮ אֶת־הָעָם֒ וְלֹא־נָחָ֣ם אֱלֹהִ֗ים דֶּ֚רֶךְ אֶ֣רֶץ פְּלִשְׁתִּ֔ים כִּ֥י קָרֹ֖וב ה֑וּא כִּ֣י ׀ אָמַ֣ר אֱלֹהִ֗ים פֶּֽן־יִנָּחֵ֥ם הָעָ֛ם בִּרְאֹתָ֥ם מִלְחָמָ֖ה וְשָׁ֥בוּ מִצְרָֽיְמָה׃ ");
INSERT INTO hbo_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","וַיַּסֵּ֨ב אֱלֹהִ֧ים ׀ אֶת־הָעָ֛ם דֶּ֥רֶךְ הַמִּדְבָּ֖ר יַם־ס֑וּף וַחֲמֻשִׁ֛ים עָל֥וּ בְנֵי־יִשְׂרָאֵ֖ל מֵאֶ֥רֶץ מִצְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","וַיִּקַּ֥ח מֹשֶׁ֛ה אֶת־עַצְמֹ֥ות יֹוסֵ֖ף עִמֹּ֑ו כִּי֩ הַשְׁבֵּ֨עַ הִשְׁבִּ֜יעַ אֶת־בְּנֵ֤י יִשְׂרָאֵל֙ לֵאמֹ֔ר פָּקֹ֨ד יִפְקֹ֤ד אֱלֹהִים֙ אֶתְכֶ֔ם וְהַעֲלִיתֶ֧ם אֶת־עַצְמֹתַ֛י מִזֶּ֖ה אִתְּכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","וַיִּסְע֖וּ מִסֻּכֹּ֑ת וַיַּחֲנ֣וּ בְאֵתָ֔ם בִּקְצֵ֖ה הַמִּדְבָּֽר׃ ");
INSERT INTO hbo_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","וַֽיהוָ֡ה הֹלֵךְ֩ לִפְנֵיהֶ֨ם יֹומָ֜ם בְּעַמּ֤וּד עָנָן֙ לַנְחֹתָ֣ם הַדֶּ֔רֶךְ וְלַ֛יְלָה בְּעַמּ֥וּד אֵ֖שׁ לְהָאִ֣יר לָהֶ֑ם לָלֶ֖כֶת יֹומָ֥ם וָלָֽיְלָה׃ ");
INSERT INTO hbo_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","לֹֽא־יָמִ֞ישׁ עַמּ֤וּד הֶֽעָנָן֙ יֹומָ֔ם וְעַמּ֥וּד הָאֵ֖שׁ לָ֑יְלָה לִפְנֵ֖י הָעָֽם׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","וַיְדַבֵּ֥ר יְהֹוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","דַּבֵּר֮ אֶל־בְּנֵ֣י יִשְׂרָאֵל֒ וְיָשֻׁ֗בוּ וְיַחֲנוּ֙ לִפְנֵי֙ פִּ֣י הַחִירֹ֔ת בֵּ֥ין מִגְדֹּ֖ל וּבֵ֣ין הַיָּ֑ם לִפְנֵי֙ בַּ֣עַל צְפֹ֔ן נִכְחֹ֥ו תַחֲנ֖וּ עַל־הַיָּֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","וְאָמַ֤ר פַּרְעֹה֙ לִבְנֵ֣י יִשְׂרָאֵ֔ל נְבֻכִ֥ים הֵ֖ם בָּאָ֑רֶץ סָגַ֥ר עֲלֵיהֶ֖ם הַמִּדְבָּֽר׃ ");
INSERT INTO hbo_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","וְחִזַּקְתִּ֣י אֶת־לֵב־פַּרְעֹה֮ וְרָדַ֣ף אַחֲרֵיהֶם֒ וְאִכָּבְדָ֤ה בְּפַרְעֹה֙ וּבְכָל־חֵילֹ֔ו וְיָדְע֥וּ מִצְרַ֖יִם כִּֽי־אֲנִ֣י יְהוָ֑ה וַיּֽ͏ַעֲשׂוּ־כֵֽן׃ ");
INSERT INTO hbo_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","וַיֻּגַּד֙ לְמֶ֣לֶךְ מִצְרַ֔יִם כִּ֥י בָרַ֖ח הָעָ֑ם וַ֠יֵּהָפֵךְ לְבַ֨ב פַּרְעֹ֤ה וַעֲבָדָיו֙ אֶל־הָעָ֔ם וַיֹּֽאמרוּ֙ מַה־זֹּ֣את עָשִׂ֔ינוּ כִּֽי־שִׁלַּ֥חְנוּ אֶת־יִשְׂרָאֵ֖ל מֵעָבְדֵֽנוּ׃ ");
INSERT INTO hbo_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","וַיֶּאְסֹ֖ר אֶת־רִכְבֹּ֑ו וְאֶת־עַמֹּ֖ו לָקַ֥ח עִמֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","וַיִּקַּ֗ח שֵׁשׁ־מֵאֹ֥ות רֶ֙כֶב֙ בָּח֔וּר וְכֹ֖ל רֶ֣כֶב מִצְרָ֑יִם וְשָׁלִשִׁ֖ם עַל־כֻּלֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","וַיְחַזֵּ֣ק יְהֹוָ֗ה אֶת־לֵ֤ב פַּרְעֹה֙ מֶ֣לֶךְ מִצְרַ֔יִם וַיִּרְדֹּ֕ף אַחֲרֵ֖י בְּנֵ֣י יִשְׂרָאֵ֑ל וּבְנֵ֣י יִשְׂרָאֵ֔ל יֹצְאִ֖ים בְּיָ֥ד רָמָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","וַיִּרְדְּפ֨וּ מִצְרַ֜יִם אַחֲרֵיהֶ֗ם וַיַּשִּׂ֤יגוּ אֹותָם֙ חֹנִ֣ים עַל־הַיָּ֔ם כָּל־סוּס֙ רֶ֣כֶב פַּרְעֹ֔ה וּפָרָשָׁ֖יו וְחֵילֹ֑ו עַל־פִּי֙ הַֽחִירֹ֔ת לִפְנֵ֖י בַּ֥עַל צְפֹֽן׃ ");
INSERT INTO hbo_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","וּפַרְעֹ֖ה הִקְרִ֑יב וַיִּשְׂאוּ֩ בְנֵֽי־יִשְׂרָאֵ֨ל אֶת־עֵינֵיהֶ֜ם וְהִנֵּ֥ה מִצְרַ֣יִם ׀ נֹסֵ֣עַ אַחֲרֵיהֶ֗ם וַיִּֽירְאוּ֙ מְאֹ֔ד וַיִּצְעֲק֥וּ בְנֵֽי־יִשְׂרָאֵ֖ל אֶל־יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","וַיֹּאמְרוּ֮ אֶל־מֹשֶׁה֒ הַֽמִבְּלִ֤י אֵין־קְבָרִים֙ בְּמִצְרַ֔יִם לְקַחְתָּ֖נוּ לָמ֣וּת בַּמִּדְבָּ֑ר מַה־זֹּאת֙ עָשִׂ֣יתָ לָּ֔נוּ לְהֹוצִיאָ֖נוּ מִמִּצְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","הֲלֹא־זֶ֣ה הַדָּבָ֗ר אֲשֶׁר֩ דִּבַּ֨רְנוּ אֵלֶ֤יךָ בְמִצְרַ֙יִם֙ לֵאמֹ֔ר חֲדַ֥ל מִמֶּ֖נּוּ וְנַֽעַבְדָ֣ה אֶת־מִצְרָ֑יִם כִּ֣י טֹ֥וב לָ֙נוּ֙ עֲבֹ֣ד אֶת־מִצְרַ֔יִם מִמֻּתֵ֖נוּ בַּמִּדְבָּֽר׃ ");
INSERT INTO hbo_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","וַיֹּ֨אמֶר מֹשֶׁ֣ה אֶל־הָעָם֮ אַל־תִּירָאוּ֒ הִֽתְיַצְב֗וּ וּרְאוּ֙ אֶת־יְשׁוּעַ֣ת יְהוָ֔ה אֲשֶׁר־יַעֲשֶׂ֥ה לָכֶ֖ם הַיֹּ֑ום כִּ֗י אֲשֶׁ֨ר רְאִיתֶ֤ם אֶת־מִצְרַ֙יִם֙ הַיֹּ֔ום לֹ֥א תֹסִ֛יפוּ לִרְאֹתָ֥ם עֹ֖וד עַד־עֹולָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","יְהוָ֖ה יִלָּחֵ֣ם לָכֶ֑ם וְאַתֶּ֖ם תַּחֲרִישֽׁוּן׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","וַיֹּ֤אמֶר יְהוָה֙ אֶל־מֹשֶׁ֔ה מַה־תִּצְעַ֖ק אֵלָ֑י דַּבֵּ֥ר אֶל־בְּנֵי־יִשְׂרָאֵ֖ל וְיִסָּֽעוּ׃ ");
INSERT INTO hbo_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","וְאַתָּ֞ה הָרֵ֣ם אֶֽת־מַטְּךָ֗ וּנְטֵ֧ה אֶת־יָדְךָ֛ עַל־הַיָּ֖ם וּבְקָעֵ֑הוּ וְיָבֹ֧אוּ בְנֵֽי־יִשְׂרָאֵ֛ל בְּתֹ֥וךְ הַיָּ֖ם בַּיַּבָּשָֽׁה׃ ");
INSERT INTO hbo_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","וַאֲנִ֗י הִנְנִ֤י מְחַזֵּק֙ אֶת־לֵ֣ב מִצְרַ֔יִם וְיָבֹ֖אוּ אַחֲרֵיהֶ֑ם וְאִכָּבְדָ֤ה בְּפַרְעֹה֙ וּבְכָל־חֵילֹ֔ו בְּרִכְבֹּ֖ו וּבְפָרָשָֽׁיו׃ ");
INSERT INTO hbo_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","וְיָדְע֥וּ מִצְרַ֖יִם כִּי־אֲנִ֣י יְהוָ֑ה בְּהִכָּבְדִ֣י בְּפַרְעֹ֔ה בְּרִכְבֹּ֖ו וּבְפָרָשָֽׁיו׃ ");
INSERT INTO hbo_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","וַיִּסַּ֞ע מַלְאַ֣ךְ הָאֱלֹהִ֗ים הַהֹלֵךְ֙ לִפְנֵי֙ מַחֲנֵ֣ה יִשְׂרָאֵ֔ל וַיֵּ֖לֶךְ מֵאַחֲרֵיהֶ֑ם וַיִּסַּ֞ע עַמּ֤וּד הֶֽעָנָן֙ מִפְּנֵיהֶ֔ם וַיּֽ͏ַעֲמֹ֖ד מֵאַחֲרֵיהֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","וַיָּבֹ֞א בֵּ֣ין ׀ מַחֲנֵ֣ה מִצְרַ֗יִם וּבֵין֙ מַחֲנֵ֣ה יִשְׂרָאֵ֔ל וַיְהִ֤י הֶֽעָנָן֙ וְהַחֹ֔שֶׁךְ וַיָּ֖אֶר אֶת־הַלָּ֑יְלָה וְלֹא־קָרַ֥ב זֶ֛ה אֶל־זֶ֖ה כָּל־הַלָּֽיְלָה׃ ");
INSERT INTO hbo_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","וַיֵּ֨ט מֹשֶׁ֣ה אֶת־יָדֹו֮ עַל־הַיָּם֒ וַיֹּ֣ולֶךְ יְהוָ֣ה ׀ אֶת־הַ֠יָּם בְּר֨וּחַ קָדִ֤ים עַזָּה֙ כָּל־הַלַּ֔יְלָה וַיָּ֥שֶׂם אֶת־הַיָּ֖ם לֶחָרָבָ֑ה וַיִּבָּקְע֖וּ הַמָּֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","וַיָּבֹ֧אוּ בְנֵֽי־יִשְׂרָאֵ֛ל בְּתֹ֥וךְ הַיָּ֖ם בַּיַּבָּשָׁ֑ה וְהַמַּ֤יִם לָהֶם֙ חֹמָ֔ה מִֽימִינָ֖ם וּמִשְּׂמֹאלָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","וַיִּרְדְּפ֤וּ מִצְרַ֙יִם֙ וַיָּבֹ֣אוּ אַחֲרֵיהֶ֔ם כֹּ֚ל ס֣וּס פַּרְעֹ֔ה רִכְבֹּ֖ו וּפָרָשָׁ֑יו אֶל־תֹּ֖וךְ הַיָּֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","וַֽיְהִי֙ בְּאַשְׁמֹ֣רֶת הַבֹּ֔קֶר וַיַּשְׁקֵ֤ף יְהוָה֙ אֶל־מַחֲנֵ֣ה מִצְרַ֔יִם בְּעַמּ֥וּד אֵ֖שׁ וְעָנָ֑ן וַיָּ֕הָם אֵ֖ת מַחֲנֵ֥ה מִצְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","וַיָּ֗סַר אֵ֚ת אֹפַ֣ן מַרְכְּבֹתָ֔יו וַֽיְנַהֲגֵ֖הוּ בִּכְבֵדֻ֑ת וַיֹּ֣אמֶר מִצְרַ֗יִם אָנ֙וּסָה֙ מִפְּנֵ֣י יִשְׂרָאֵ֔ל כִּ֣י יְהוָ֔ה נִלְחָ֥ם לָהֶ֖ם בְּמִצְרָֽיִם פ ");
INSERT INTO hbo_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","וַיֹּ֤אמֶר יְהוָה֙ אֶל־מֹשֶׁ֔ה נְטֵ֥ה אֶת־יָדְךָ֖ עַל־הַיָּ֑ם וְיָשֻׁ֤בוּ הַמַּ֙יִם֙ עַל־מִצְרַ֔יִם עַל־רִכְבֹּ֖ו וְעַל־פָּרָשָֽׁיו׃ ");
INSERT INTO hbo_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","וַיֵּט֩ מֹשֶׁ֨ה אֶת־יָדֹ֜ו עַל־הַיָּ֗ם וַיָּ֨שָׁב הַיָּ֜ם לִפְנֹ֥ות בֹּ֙קֶר֙ לְאֵ֣יתָנֹ֔ו וּמִצְרַ֖יִם נָסִ֣ים לִקְרָאתֹ֑ו וַיְנַעֵ֧ר יְהוָ֛ה אֶת־מִצְרַ֖יִם בְּתֹ֥וךְ הַיָּֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","וַיָּשֻׁ֣בוּ הַמַּ֗יִם וַיְכַסּ֤וּ אֶת־הָרֶ֙כֶב֙ וְאֶת־הַפָּ֣רָשִׁ֔ים לְכֹל֙ חֵ֣יל פַּרְעֹ֔ה הַבָּאִ֥ים אַחֲרֵיהֶ֖ם בַּיָּ֑ם לֹֽא־נִשְׁאַ֥ר בָּהֶ֖ם עַד־אֶחָֽד׃ ");
INSERT INTO hbo_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","וּבְנֵ֧י יִשְׂרָאֵ֛ל הָלְכ֥וּ בַיַּבָּשָׁ֖ה בְּתֹ֣וךְ הַיָּ֑ם וְהַמַּ֤יִם לָהֶם֙ חֹמָ֔ה מִֽימִינָ֖ם וּמִשְּׂמֹאלָֽם ");
INSERT INTO hbo_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","וַיֹּ֨ושַׁע יְהוָ֜ה בַּיֹּ֥ום הַה֛וּא אֶת־יִשְׂרָאֵ֖ל מִיַּ֣ד מִצְרָ֑יִם וַיַּ֤רְא יִשְׂרָאֵל֙ אֶת־מִצְרַ֔יִם מֵ֖ת עַל־שְׂפַ֥ת הַיָּֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","וַיַּ֨רְא יִשְׂרָאֵ֜ל אֶת־הַיָּ֣ד הַגְּדֹלָ֗ה אֲשֶׁ֨ר עָשָׂ֤ה יְהוָה֙ בְּמִצְרַ֔יִם וַיִּֽירְא֥וּ הָעָ֖ם אֶת־יְהוָ֑ה וַיּֽ͏ַאֲמִ֙ינוּ֙ בַּֽיהוָ֔ה וּבְמֹשֶׁ֖ה עַבְדֹּֽו׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","אָ֣ז יָשִֽׁיר־מֹשֶׁה֩ וּבְנֵ֨י יִשְׂרָאֵ֜ל אֶת־הַשִּׁירָ֤ה הַזֹּאת֙ לַֽיהוָ֔ה וַיֹּאמְר֖וּ לֵאמֹ֑ר אָשִׁ֤ירָה לֽ͏ַיהוָה֙ כִּֽי־גָאֹ֣ה גָּאָ֔ה ס֥וּס וְרֹכְבֹ֖ו רָמָ֥ה בַיָּֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","עָזִּ֤י וְזִמְרָת֙ יָ֔הּ וַֽיְהִי־לִ֖י לִֽישׁוּעָ֑ה זֶ֤ה אֵלִי֙ וְאַנְוֵ֔הוּ אֱלֹהֵ֥י אָבִ֖י וַאֲרֹמְמֶֽנְהוּ׃ ");
INSERT INTO hbo_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","יְהוָ֖ה אִ֣ישׁ מִלְחָמָ֑ה יְהוָ֖ה שְׁמֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","מַרְכְּבֹ֥ת פַּרְעֹ֛ה וְחֵילֹ֖ו יָרָ֣ה בַיָּ֑ם וּמִבְחַ֥ר שָֽׁלִשָׁ֖יו טֻבְּע֥וּ בְיַם־סֽוּף׃ ");
INSERT INTO hbo_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","תְּהֹמֹ֖ת יְכַסְיֻ֑מוּ יָרְד֥וּ בִמְצֹולֹ֖ת כְּמֹו־אָֽבֶן׃ ");
INSERT INTO hbo_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","יְמִֽינְךָ֣ יְהוָ֔ה נֶאְדָּרִ֖י בַּכֹּ֑חַ יְמִֽינְךָ֥ יְהוָ֖ה תִּרְעַ֥ץ אֹויֵֽב׃ ");
INSERT INTO hbo_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","וּבְרֹ֥ב גְּאֹונְךָ֖ תַּהֲרֹ֣ס קָמֶ֑יךָ תְּשַׁלַּח֙ חֲרֹ֣נְךָ֔ יֹאכְלֵ֖מֹו כַּקַּֽשׁ׃ ");
INSERT INTO hbo_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","וּבְר֤וּחַ אַפֶּ֙יךָ֙ נֶ֣עֶרְמוּ מַ֔יִם נִצְּב֥וּ כְמֹו־נֵ֖ד נֹזְלִ֑ים קָֽפְא֥וּ תְהֹמֹ֖ת בְּלֶב־יָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","אָמַ֥ר אֹויֵ֛ב אֶרְדֹּ֥ף אַשִּׂ֖יג אֲחַלֵּ֣ק שָׁלָ֑ל תִּמְלָאֵ֣מֹו נַפְשִׁ֔י אָרִ֣יק חַרְבִּ֔י תֹּורִישֵׁ֖מֹו יָדִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","נָשַׁ֥פְתָּ בְרוּחֲךָ֖ כִּסָּ֣מֹו יָ֑ם צָֽלֲלוּ֙ כַּֽעֹופֶ֔רֶת בְּמַ֖יִם אַדִּירִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","מִֽי־כָמֹ֤כָה בָּֽאֵלִם֙ יְהוָ֔ה מִ֥י כָּמֹ֖כָה נֶאְדָּ֣ר בַּקֹּ֑דֶשׁ נֹורָ֥א תְהִלֹּ֖ת עֹ֥שֵׂה פֶֽלֶא׃ ");
INSERT INTO hbo_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","נָטִ֙יתָ֙ יְמִ֣ינְךָ֔ תִּבְלָעֵ֖מֹו אָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","נָחִ֥יתָ בְחַסְדְּךָ֖ עַם־ז֣וּ גָּאָ֑לְתָּ נֵהַ֥לְתָּ בְעָזְּךָ֖ אֶל־נְוֵ֥ה קָדְשֶֽׁךָ׃ ");
INSERT INTO hbo_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","שָֽׁמְע֥וּ עַמִּ֖ים יִרְגָּז֑וּן חִ֣יל אָחַ֔ז יֹשְׁבֵ֖י פְּלָֽשֶׁת׃ ");
INSERT INTO hbo_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","אָ֤ז נִבְהֲלוּ֙ אַלּוּפֵ֣י אֱדֹ֔ום אֵילֵ֣י מֹואָ֔ב יֹֽאחֲזֵ֖מֹו רָ֑עַד נָמֹ֕גוּ כֹּ֖ל יֹשְׁבֵ֥י כְנָֽעַן׃ ");
INSERT INTO hbo_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","תִּפֹּ֨ל עֲלֵיהֶ֤ם אֵימָ֙תָה֙ וָפַ֔חַד בִּגְדֹ֥ל זְרֹועֲךָ֖ יִדְּמ֣וּ כָּאָ֑בֶן עַד־יַעֲבֹ֤ר עַמְּךָ֙ יְהוָ֔ה עַֽד־יַעֲבֹ֖ר עַם־ז֥וּ קָנִֽיתָ׃ ");
INSERT INTO hbo_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","תְּבִאֵ֗מֹו וְתִטָּעֵ֙מֹו֙ בְּהַ֣ר נַחֲלָֽתְךָ֔ מָכֹ֧ון לְשִׁבְתְּךָ֛ פָּעַ֖לְתָּ יְהוָ֑ה מִקְּדָ֕שׁ אֲדֹנָ֖י כֹּונְנ֥וּ יָדֶֽיךָ׃ ");
INSERT INTO hbo_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","יְהוָ֥ה ׀ יִמְלֹ֖ךְ לְעֹלָ֥ם וָעֶֽד׃ ");
INSERT INTO hbo_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","כִּ֣י בָא֩ ס֨וּס פַּרְעֹ֜ה בְּרִכְבֹּ֤ו וּבְפָרָשָׁיו֙ בַּיָּ֔ם וַיָּ֧שֶׁב יְהוָ֛ה עֲלֵהֶ֖ם אֶת־מֵ֣י הַיָּ֑ם וּבְנֵ֧י יִשְׂרָאֵ֛ל הָלְכ֥וּ בַיַּבָּשָׁ֖ה בְּתֹ֥וךְ הַיָּֽם׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","וַתִּקַּח֩ מִרְיָ֨ם הַנְּבִיאָ֜ה אֲחֹ֧ות אַהֲרֹ֛ן אֶת־הַתֹּ֖ף בְּיָדָ֑הּ וַתֵּצֶ֤אןָ כָֽל־הַנָּשִׁים֙ אַחֲרֶ֔יהָ בְּתֻפִּ֖ים וּבִמְחֹלֹֽת׃ ");
INSERT INTO hbo_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","וַתַּ֥עַן לָהֶ֖ם מִרְיָ֑ם שִׁ֤ירוּ לַֽיהוָה֙ כִּֽי־גָאֹ֣ה גָּאָ֔ה ס֥וּס וְרֹכְבֹ֖ו רָמָ֥ה בַיָּֽם׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","וַיַּסַּ֨ע מֹשֶׁ֤ה אֶת־יִשְׂרָאֵל֙ מִיַּם־ס֔וּף וַיֵּצְא֖וּ אֶל־מִדְבַּר־שׁ֑וּר וַיֵּלְכ֧וּ שְׁלֹֽשֶׁת־יָמִ֛ים בַּמִּדְבָּ֖ר וְלֹא־מָ֥צְאוּ מָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","וַיָּבֹ֣אוּ מָרָ֔תָה וְלֹ֣א יָֽכְל֗וּ לִשְׁתֹּ֥ת מַ֙יִם֙ מִמָּרָ֔ה כִּ֥י מָרִ֖ים הֵ֑ם עַל־כֵּ֥ן קָרָֽא־שְׁמָ֖הּ מָרָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","וַיִּלֹּ֧נוּ הָעָ֛ם עַל־מֹשֶׁ֥ה לֵּאמֹ֖ר מַה־נִּשְׁתֶּֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","וַיִּצְעַ֣ק אֶל־יְהוָ֗ה וַיֹּורֵ֤הוּ יְהוָה֙ עֵ֔ץ וַיַּשְׁלֵךְ֙ אֶל־הַמַּ֔יִם וַֽיִּמְתְּק֖וּ הַמָּ֑יִם שָׁ֣ם שָׂ֥ם לֹ֛ו חֹ֥ק וּמִשְׁפָּ֖ט וְשָׁ֥ם נִסָּֽהוּ׃ ");
INSERT INTO hbo_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","וַיֹּאמֶר֩ אִם־שָׁמֹ֨ועַ תִּשְׁמַ֜ע לְקֹ֣ול ׀ יְהוָ֣ה אֱלֹהֶ֗יךָ וְהַיָּשָׁ֤ר בְּעֵינָיו֙ תַּעֲשֶׂ֔ה וְהֽ͏ַאֲזַנְתָּ֙ לְמִצְוֹתָ֔יו וְשָׁמַרְתָּ֖ כָּל־חֻקָּ֑יו כָּֽל־הַמּֽ͏ַחֲלָ֞ה אֲשֶׁר־שַׂ֤מְתִּי בְמִצְרַ֙יִם֙ לֹא־אָשִׂ֣ים עָלֶ֔יךָ כִּ֛י אֲנִ֥י יְהוָ֖ה רֹפְאֶֽךָ׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","וַיָּבֹ֣אוּ אֵילִ֔מָה וְשָׁ֗ם שְׁתֵּ֥ים עֶשְׂרֵ֛ה עֵינֹ֥ת מַ֖יִם וְשִׁבְעִ֣ים תְּמָרִ֑ים וַיַּחֲנוּ־שָׁ֖ם עַל־הַמָּֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","וַיִּסְעוּ֙ מֵֽאֵילִ֔ם וַיָּבֹ֜אוּ כָּל־עֲדַ֤ת בְּנֵֽי־יִשְׂרָאֵל֙ אֶל־מִדְבַּר־סִ֔ין אֲשֶׁ֥ר בֵּין־אֵילִ֖ם וּבֵ֣ין סִינָ֑י בַּחֲמִשָּׁ֨ה עָשָׂ֥ר יֹום֙ לַחֹ֣דֶשׁ הַשֵּׁנִ֔י לְצֵאתָ֖ם מֵאֶ֥רֶץ מִצְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","*וַיִּלִּינוּ (וַיִּלֹּ֜ונוּ) כָּל־עֲדַ֧ת בְּנֵי־יִשְׂרָאֵ֛ל עַל־מֹשֶׁ֥ה וְעַֽל־אַהֲרֹ֖ן בַּמִּדְבָּֽר׃ ");
INSERT INTO hbo_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","וַיֹּאמְר֨וּ אֲלֵהֶ֜ם בְּנֵ֣י יִשְׂרָאֵ֗ל מִֽי־יִתֵּ֨ן מוּתֵ֤נוּ בְיַד־יְהוָה֙ בְּאֶ֣רֶץ מִצְרַ֔יִם בְּשִׁבְתֵּ֙נוּ֙ עַל־סִ֣יר הַבָּשָׂ֔ר בְּאָכְלֵ֥נוּ לֶ֖חֶם לָשֹׂ֑בַע כִּֽי־הֹוצֵאתֶ֤ם אֹתָ֙נוּ֙ אֶל־הַמִּדְבָּ֣ר הַזֶּ֔ה לְהָמִ֛ית אֶת־כָּל־הַקָּהָ֥ל הַזֶּ֖ה בָּרָעָֽב׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","וַיֹּ֤אמֶר יְהוָה֙ אֶל־מֹשֶׁ֔ה הִנְנִ֨י מַמְטִ֥יר לָכֶ֛ם לֶ֖חֶם מִן־הַשָּׁמָ֑יִם וְיָצָ֨א הָעָ֤ם וְלָֽקְטוּ֙ דְּבַר־יֹ֣ום בְּיֹומֹ֔ו לְמַ֧עַן אֲנַסֶּ֛נּוּ הֲיֵלֵ֥ךְ בְּתֹורָתִ֖י אִם־לֹֽא׃ ");
INSERT INTO hbo_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","וְהָיָה֙ בַּיֹּ֣ום הַשִּׁשִּׁ֔י וְהֵכִ֖ינוּ אֵ֣ת אֲשֶׁר־יָבִ֑יאוּ וְהָיָ֣ה מִשְׁנֶ֔ה עַ֥ל אֲשֶֽׁר־יִלְקְט֖וּ יֹ֥ום ׀ יֹֽום׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","וַיֹּ֤אמֶר מֹשֶׁה֙ וְאַהֲרֹ֔ן אֶֽל־כָּל־בְּנֵ֖י יִשְׂרָאֵ֑ל עֶ֕רֶב וִֽידַעְתֶּ֕ם כִּ֧י יְהוָ֛ה הֹוצִ֥יא אֶתְכֶ֖ם מֵאֶ֥רֶץ מִצְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","וּבֹ֗קֶר וּרְאִיתֶם֙ אֶת־כְּבֹ֣וד יְהוָ֔ה בְּשָׁמְעֹ֥ו אֶת־תְּלֻנֹּתֵיכֶ֖ם עַל־יְהוָ֑ה וְנַ֣חְנוּ מָ֔ה כִּ֥י *תַלֹּונוּ (תַלִּ֖ינוּ) עָלֵֽינוּ׃ ");
INSERT INTO hbo_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","וַיֹּ֣אמֶר מֹשֶׁ֗ה בְּתֵ֣ת יְהוָה֩ לָכֶ֨ם בָּעֶ֜רֶב בָּשָׂ֣ר לֶאֱכֹ֗ל וְלֶ֤חֶם בַּבֹּ֙קֶר֙ לִשְׂבֹּ֔עַ בִּשְׁמֹ֤עַ יְהוָה֙ אֶת־תְּלֻנֹּ֣תֵיכֶ֔ם אֲשֶׁר־אַתֶּ֥ם מַלִּינִ֖ם עָלָ֑יו וְנַ֣חְנוּ מָ֔ה לֹא־עָלֵ֥ינוּ תְלֻנֹּתֵיכֶ֖ם כִּ֥י עַל־יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","וַיֹּ֤אמֶר מֹשֶׁה֙ אֶֽל־אַהֲרֹ֔ן אֱמֹ֗ר אֶֽל־כָּל־עֲדַת֙ בְּנֵ֣י יִשְׂרָאֵ֔ל קִרְב֖וּ לִפְנֵ֣י יְהוָ֑ה כִּ֣י שָׁמַ֔ע אֵ֖ת תְּלֻנֹּתֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","וַיְהִ֗י כְּדַבֵּ֤ר אַהֲרֹן֙ אֶל־כָּל־עֲדַ֣ת בְּנֵֽי־יִשְׂרָאֵ֔ל וַיִּפְנ֖וּ אֶל־הַמִּדְבָּ֑ר וְהִנֵּה֙ כְּבֹ֣וד יְהוָ֔ה נִרְאָ֖ה בֶּעָנָֽן׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","שָׁמַ֗עְתִּי אֶת־תְּלוּנֹּת֮ בְּנֵ֣י יִשְׂרָאֵל֒ דַּבֵּ֨ר אֲלֵהֶ֜ם לֵאמֹ֗ר בֵּ֤ין הָֽעַרְבַּ֙יִם֙ תֹּאכְל֣וּ בָשָׂ֔ר וּבַבֹּ֖קֶר תִּשְׂבְּעוּ־לָ֑חֶם וִֽידַעְתֶּ֕ם כִּ֛י אֲנִ֥י יְהוָ֖ה אֱלֹהֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","וַיְהִ֣י בָעֶ֔רֶב וַתַּ֣עַל הַשְּׂלָ֔ו וַתְּכַ֖ס אֶת־הַֽמַּחֲנֶ֑ה וּבַבֹּ֗קֶר הָֽיְתָה֙ שִׁכְבַ֣ת הַטַּ֔ל סָבִ֖יב לַֽמַּחֲנֶֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","וַתַּ֖עַל שִׁכְבַ֣ת הַטָּ֑ל וְהִנֵּ֞ה עַל־פְּנֵ֤י הַמִּדְבָּר֙ דַּ֣ק מְחֻסְפָּ֔ס דַּ֥ק כַּכְּפֹ֖ר עַל־הָאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","וַיִּרְא֣וּ בְנֵֽי־יִשְׂרָאֵ֗ל וַיֹּ֨אמְר֜וּ אִ֤ישׁ אֶל־אָחִיו֙ מָ֣ן ה֔וּא כִּ֛י לֹ֥א יָדְע֖וּ מַה־ה֑וּא וַיֹּ֤אמֶר מֹשֶׁה֙ אֲלֵהֶ֔ם ה֣וּא הַלֶּ֔חֶם אֲשֶׁ֨ר נָתַ֧ן יְהוָ֛ה לָכֶ֖ם לְאָכְלָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","זֶ֤ה הַדָּבָר֙ אֲשֶׁ֣ר צִוָּ֣ה יְהוָ֔ה לִקְט֣וּ מִמֶּ֔נּוּ אִ֖ישׁ לְפִ֣י אָכְלֹ֑ו עֹ֣מֶר לַגֻּלְגֹּ֗לֶת מִסְפַּר֙ נַפְשֹׁ֣תֵיכֶ֔ם אִ֛ישׁ לַאֲשֶׁ֥ר בְּאָהֳלֹ֖ו תִּקָּֽחוּ׃ ");
INSERT INTO hbo_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","וַיַּעֲשׂוּ־כֵ֖ן בְּנֵ֣י יִשְׂרָאֵ֑ל וַֽיִּלְקְט֔וּ הַמַּרְבֶּ֖ה וְהַמַּמְעִֽיט׃ ");
INSERT INTO hbo_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","וַיָּמֹ֣דּוּ בָעֹ֔מֶר וְלֹ֤א הֶעְדִּיף֙ הַמַּרְבֶּ֔ה וְהַמַּמְעִ֖יט לֹ֣א הֶחְסִ֑יר אִ֥ישׁ לְפִֽי־אָכְלֹ֖ו לָקָֽטוּ׃ ");
INSERT INTO hbo_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","וַיֹּ֥אמֶר מֹשֶׁ֖ה אֲלֵהֶ֑ם אִ֕ישׁ אַל־יֹותֵ֥ר מִמֶּ֖נּוּ עַד־בֹּֽקֶר׃ ");
INSERT INTO hbo_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","וְלֹא־שָׁמְע֣וּ אֶל־מֹשֶׁ֗ה וַיֹּותִ֨רוּ אֲנָשִׁ֤ים מִמֶּ֙נּוּ֙ עַד־בֹּ֔קֶר וַיָּ֥רֻם תֹּולָעִ֖ים וַיִּבְאַ֑שׁ וַיִּקְצֹ֥ף עֲלֵהֶ֖ם מֹשֶֽׁה׃ ");
INSERT INTO hbo_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","וַיִּלְקְט֤וּ אֹתֹו֙ בַּבֹּ֣קֶר בַּבֹּ֔קֶר אִ֖ישׁ כְּפִ֣י אָכְלֹ֑ו וְחַ֥ם הַשֶּׁ֖מֶשׁ וְנָמָֽס׃ ");
INSERT INTO hbo_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","וַיְהִ֣י ׀ בַּיֹּ֣ום הַשִּׁשִּׁ֗י לָֽקְט֥וּ לֶ֙חֶם֙ מִשְׁנֶ֔ה שְׁנֵ֥י הָעֹ֖מֶר לָאֶחָ֑ד וַיָּבֹ֙אוּ֙ כָּל־נְשִׂיאֵ֣י הָֽעֵדָ֔ה וַיַּגִּ֖ידוּ לְמֹשֶֽׁה׃ ");
INSERT INTO hbo_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","וַיֹּ֣אמֶר אֲלֵהֶ֗ם ה֚וּא אֲשֶׁ֣ר דִּבֶּ֣ר יְהוָ֔ה שַׁבָּתֹ֧ון שַׁבַּת־קֹ֛דֶשׁ לַֽיהוָ֖ה מָחָ֑ר אֵ֣ת אֲשֶׁר־תֹּאפ֞וּ אֵפ֗וּ וְאֵ֤ת אֲשֶֽׁר־תְּבַשְּׁלוּ֙ בַּשֵּׁ֔לוּ וְאֵת֙ כָּל־הָ֣עֹדֵ֔ף הַנִּ֧יחוּ לָכֶ֛ם לְמִשְׁמֶ֖רֶת עַד־הַבֹּֽקֶר׃ ");
INSERT INTO hbo_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","וַיַּנִּ֤יחוּ אֹתֹו֙ עַד־הַבֹּ֔קֶר כַּאֲשֶׁ֖ר צִוָּ֣ה מֹשֶׁ֑ה וְלֹ֣א הִבְאִ֔ישׁ וְרִמָּ֖ה לֹא־הָ֥יְתָה בֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","וַיֹּ֤אמֶר מֹשֶׁה֙ אִכְלֻ֣הוּ הַיֹּ֔ום כִּֽי־שַׁבָּ֥ת הַיֹּ֖ום לַיהוָ֑ה הַיֹּ֕ום לֹ֥א תִמְצָאֻ֖הוּ בַּשָּׂדֶֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","שֵׁ֥שֶׁת יָמִ֖ים תִּלְקְטֻ֑הוּ וּבַיֹּ֧ום הַשְּׁבִיעִ֛י שַׁבָּ֖ת לֹ֥א יִֽהְיֶה־בֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","וֽ͏ַיְהִי֙ בַּיֹּ֣ום הַשְּׁבִיעִ֔י יָצְא֥וּ מִן־הָעָ֖ם לִלְקֹ֑ט וְלֹ֖א מָצָֽאוּ׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","וַיֹּ֥אמֶר יְהוָ֖ה אֶל־מֹשֶׁ֑ה עַד־אָ֙נָה֙ מֵֽאַנְתֶּ֔ם לִשְׁמֹ֥ר מִצְוֹתַ֖י וְתֹורֹתָֽי׃ ");
INSERT INTO hbo_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","רְא֗וּ כִּֽי־יְהוָה֮ נָתַ֣ן לָכֶ֣ם הַשַּׁבָּת֒ עַל־כֵּ֠ן ה֣וּא נֹתֵ֥ן לָכֶ֛ם בַּיֹּ֥ום הַשִּׁשִּׁ֖י לֶ֣חֶם יֹומָ֑יִם שְׁב֣וּ ׀ אִ֣ישׁ תַּחְתָּ֗יו אַל־יֵ֥צֵא אִ֛ישׁ מִמְּקֹמֹ֖ו בַּיֹּ֥ום הַשְּׁבִיעִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","וַיִּשְׁבְּת֥וּ הָעָ֖ם בַּיֹּ֥ום הַשְּׁבִעִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","וַיִּקְרְא֧וּ בֵֽית־יִשְׂרָאֵ֛ל אֶת־שְׁמֹ֖ו מָ֑ן וְה֗וּא כְּזֶ֤רַע גַּד֙ לָבָ֔ן וְטַעְמֹ֖ו כְּצַפִּיחִ֥ת בִּדְבָֽשׁ׃ ");
INSERT INTO hbo_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","וַיֹּ֣אמֶר מֹשֶׁ֗ה זֶ֤ה הַדָּבָר֙ אֲשֶׁ֣ר צִוָּ֣ה יְהוָ֔ה מְלֹ֤א הָעֹ֙מֶר֙ מִמֶּ֔נּוּ לְמִשְׁמֶ֖רֶת לְדֹרֹתֵיכֶ֑ם לְמַ֣עַן ׀ יִרְא֣וּ אֶת־הַלֶּ֗חֶם אֲשֶׁ֨ר הֶאֱכַ֤לְתִּי אֶתְכֶם֙ בַּמִּדְבָּ֔ר בְּהֹוצִיאִ֥י אֶתְכֶ֖ם מֵאֶ֥רֶץ מִצְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","וַיֹּ֨אמֶר מֹשֶׁ֜ה אֶֽל־אַהֲרֹ֗ן קַ֚ח צִנְצֶ֣נֶת אַחַ֔ת וְתֶן־שָׁ֥מָּה מְלֹֽא־הָעֹ֖מֶר מָ֑ן וְהַנַּ֤ח אֹתֹו֙ לִפְנֵ֣י יְהוָ֔ה לְמִשְׁמֶ֖רֶת לְדֹרֹתֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","כַּאֲשֶׁ֛ר צִוָּ֥ה יְהוָ֖ה אֶל־מֹשֶׁ֑ה וַיַּנִּיחֵ֧הוּ אַהֲרֹ֛ן לִפְנֵ֥י הָעֵדֻ֖ת לְמִשְׁמָֽרֶת׃ ");
INSERT INTO hbo_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","וּבְנֵ֣י יִשְׂרָאֵ֗ל אֽ͏ָכְל֤וּ אֶת־הַמָּן֙ אַרְבָּעִ֣ים שָׁנָ֔ה עַד־בֹּאָ֖ם אֶל־אֶ֣רֶץ נֹושָׁ֑בֶת אֶת־הַמָּן֙ אָֽכְל֔וּ עַד־בֹּאָ֕ם אֶל־קְצֵ֖ה אֶ֥רֶץ כְּנָֽעַן׃ ");
INSERT INTO hbo_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","וְהָעֹ֕מֶר עֲשִׂרִ֥ית הָאֵיפָ֖ה הֽוּא׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","וַ֠יִּסְעוּ כָּל־עֲדַ֨ת בְּנֵֽי־יִשְׂרָאֵ֧ל מִמִּדְבַּר־סִ֛ין לְמַסְעֵיהֶ֖ם עַל־פִּ֣י יְהוָ֑ה וַֽיַּחֲנוּ֙ בִּרְפִידִ֔ים וְאֵ֥ין מַ֖יִם לִשְׁתֹּ֥ת הָעָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","וַיָּ֤רֶב הָעָם֙ עִם־מֹשֶׁ֔ה וַיֹּ֣אמְר֔וּ תְּנוּ־לָ֥נוּ מַ֖יִם וְנִשְׁתֶּ֑ה וַיֹּ֤אמֶר לָהֶם֙ מֹשֶׁ֔ה מַה־תְּרִיבוּן֙ עִמָּדִ֔י מַה־תְּנַסּ֖וּן אֶת־יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","וַיִּצְמָ֨א שָׁ֤ם הָעָם֙ לַמַּ֔יִם וַיָּ֥לֶן הָעָ֖ם עַל־מֹשֶׁ֑ה וַיֹּ֗אמֶר לָ֤מָּה זֶּה֙ הֶעֱלִיתָ֣נוּ מִמִּצְרַ֔יִם לְהָמִ֥ית אֹתִ֛י וְאֶת־בָּנַ֥י וְאֶת־מִקְנַ֖י בַּצָּמָֽא׃ ");
INSERT INTO hbo_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","וַיִּצְעַ֤ק מֹשֶׁה֙ אֶל־יְהוָ֣ה לֵאמֹ֔ר מָ֥ה אֶעֱשֶׂ֖ה לָעָ֣ם הַזֶּ֑ה עֹ֥וד מְעַ֖ט וּסְקָלֻֽנִי׃ ");
INSERT INTO hbo_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","וַיֹּ֨אמֶר יְהוָ֜ה אֶל־מֹשֶׁ֗ה עֲבֹר֙ לִפְנֵ֣י הָעָ֔ם וְקַ֥ח אִתְּךָ֖ מִזִּקְנֵ֣י יִשְׂרָאֵ֑ל וּמַטְּךָ֗ אֲשֶׁ֨ר הִכִּ֤יתָ בֹּו֙ אֶת־הַיְאֹ֔ר קַ֥ח בְּיָדְךָ֖ וְהָלָֽכְתָּ׃ ");
INSERT INTO hbo_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","הִנְנִ֣י עֹמֵד֩ לְפָנֶ֨יךָ שָּׁ֥ם ׀ עַֽל־הַצּוּר֮ בְּחֹרֵב֒ וְהִכִּ֣יתָ בַצּ֗וּר וְיָצְא֥וּ מִמֶּ֛נּוּ מַ֖יִם וְשָׁתָ֣ה הָעָ֑ם וַיַּ֤עַשׂ כֵּן֙ מֹשֶׁ֔ה לְעֵינֵ֖י זִקְנֵ֥י יִשְׂרָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","וַיִּקְרָא֙ שֵׁ֣ם הַמָּקֹ֔ום מַסָּ֖ה וּמְרִיבָ֑ה עַל־רִ֣יב ׀ בְּנֵ֣י יִשְׂרָאֵ֗ל וְעַ֨ל נַסֹּתָ֤ם אֶת־יְהוָה֙ לֵאמֹ֔ר הֲיֵ֧שׁ יְהוָ֛ה בְּקִרְבֵּ֖נוּ אִם־אָֽיִן׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","וַיָּבֹ֖א עֲמָלֵ֑ק וַיִּלָּ֥חֶם עִם־יִשְׂרָאֵ֖ל בִּרְפִידִֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","וַיֹּ֨אמֶר מֹשֶׁ֤ה אֶל־יְהֹושֻׁ֙עַ֙ בְּחַר־לָ֣נוּ אֲנָשִׁ֔ים וְצֵ֖א הִלָּחֵ֣ם בַּעֲמָלֵ֑ק מָחָ֗ר אָנֹכִ֤י נִצָּב֙ עַל־רֹ֣אשׁ הַגִּבְעָ֔ה וּמַטֵּ֥ה הָאֱלֹהִ֖ים בְּיָדִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","וַיַּ֣עַשׂ יְהֹושֻׁ֗עַ כַּאֲשֶׁ֤ר אָֽמַר־לֹו֙ מֹשֶׁ֔ה לְהִלָּחֵ֖ם בַּעֲמָלֵ֑ק וּמֹשֶׁה֙ אַהֲרֹ֣ן וְח֔וּר עָל֖וּ רֹ֥אשׁ הַגִּבְעָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","וְהָיָ֗ה כַּאֲשֶׁ֨ר יָרִ֥ים מֹשֶׁ֛ה יָדֹ֖ו וְגָבַ֣ר יִשְׂרָאֵ֑ל וְכַאֲשֶׁ֥ר יָנִ֛יחַ יָדֹ֖ו וְגָבַ֥ר עֲמָלֵֽק׃ ");
INSERT INTO hbo_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","וִידֵ֤י מֹשֶׁה֙ כְּבֵדִ֔ים וַיִּקְחוּ־אֶ֛בֶן וַיָּשִׂ֥ימוּ תַחְתָּ֖יו וַיֵּ֣שֶׁב עָלֶ֑יהָ וְאַהֲרֹ֨ן וְח֜וּר תָּֽמְכ֣וּ בְיָדָ֗יו מִזֶּ֤ה אֶחָד֙ וּמִזֶּ֣ה אֶחָ֔ד וַיְהִ֥י יָדָ֛יו אֱמוּנָ֖ה עַד־בֹּ֥א הַשָּֽׁמֶשׁ׃ ");
INSERT INTO hbo_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","וַיַּחֲלֹ֧שׁ יְהֹושֻׁ֛עַ אֶת־עֲמָלֵ֥ק וְאֶת־עַמֹּ֖ו לְפִי־חָֽרֶב׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","וַיֹּ֨אמֶר יְהוָ֜ה אֶל־מֹשֶׁ֗ה כְּתֹ֨ב זֹ֤את זִכָּרֹון֙ בַּסֵּ֔פֶר וְשִׂ֖ים בְּאָזְנֵ֣י יְהֹושֻׁ֑עַ כִּֽי־מָחֹ֤ה אֶמְחֶה֙ אֶת־זֵ֣כֶר עֲמָלֵ֔ק מִתַּ֖חַת הַשָּׁמָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","וַיִּ֥בֶן מֹשֶׁ֖ה מִזְבֵּ֑חַ וַיִּקְרָ֥א שְׁמֹ֖ו יְהוָ֥ה ׀ נִסִּֽי׃ ");
INSERT INTO hbo_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","וַיֹּ֗אמֶר כִּֽי־יָד֙ עַל־כֵּ֣ס יָ֔הּ מִלְחָמָ֥ה לַיהוָ֖ה בַּֽעֲמָלֵ֑ק מִדֹּ֖ר דֹּֽר׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","וַיִּשְׁמַ֞ע יִתְרֹ֨ו כֹהֵ֤ן מִדְיָן֙ חֹתֵ֣ן מֹשֶׁ֔ה אֵת֩ כָּל־אֲשֶׁ֨ר עָשָׂ֤ה אֱלֹהִים֙ לְמֹשֶׁ֔ה וּלְיִשְׂרָאֵ֖ל עַמֹּ֑ו כִּֽי־הֹוצִ֧יא יְהוָ֛ה אֶת־יִשְׂרָאֵ֖ל מִמִּצְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","וַיִּקַּ֗ח יִתְרֹו֙ חֹתֵ֣ן מֹשֶׁ֔ה אֶת־צִפֹּרָ֖ה אֵ֣שֶׁת מֹשֶׁ֑ה אַחַ֖ר שִׁלּוּחֶֽיהָ׃ ");
INSERT INTO hbo_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","וְאֵ֖ת שְׁנֵ֣י בָנֶ֑יהָ אֲשֶׁ֨ר שֵׁ֤ם הָֽאֶחָד֙ גֵּֽרְשֹׁ֔ם כִּ֣י אָמַ֔ר גֵּ֣ר הָיִ֔יתִי בְּאֶ֖רֶץ נָכְרִיָּֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","וְשֵׁ֥ם הָאֶחָ֖ד אֱלִיעֶ֑זֶר כִּֽי־אֱלֹהֵ֤י אָבִי֙ בְּעֶזְרִ֔י וַיַּצִּלֵ֖נִי מֵחֶ֥רֶב פַּרְעֹֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","וַיָּבֹ֞א יִתְרֹ֨ו חֹתֵ֥ן מֹשֶׁ֛ה וּבָנָ֥יו וְאִשְׁתֹּ֖ו אֶל־מֹשֶׁ֑ה אֶל־הַמִּדְבָּ֗ר אֲשֶׁר־ה֛וּא חֹנֶ֥ה שָׁ֖ם הַ֥ר הָאֱלֹהִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","וַיֹּ֙אמֶר֙ אֶל־מֹשֶׁ֔ה אֲנִ֛י חֹתֶנְךָ֥ יִתְרֹ֖ו בָּ֣א אֵלֶ֑יךָ וְאִ֨שְׁתְּךָ֔ וּשְׁנֵ֥י בָנֶ֖יהָ עִמָּֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","וַיֵּצֵ֨א מֹשֶׁ֜ה לִקְרַ֣את חֹֽתְנֹ֗ו וַיִּשְׁתַּ֙חוּ֙ וַיִּשַּׁק־לֹ֔ו וַיִּשְׁאֲל֥וּ אִישׁ־לְרֵעֵ֖הוּ לְשָׁלֹ֑ום וַיָּבֹ֖אוּ הָאֹֽהֱלָה׃ ");
INSERT INTO hbo_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","וַיְסַפֵּ֤ר מֹשֶׁה֙ לְחֹ֣תְנֹ֔ו אֵת֩ כָּל־אֲשֶׁ֨ר עָשָׂ֤ה יְהוָה֙ לְפַרְעֹ֣ה וּלְמִצְרַ֔יִם עַ֖ל אֹודֹ֣ת יִשְׂרָאֵ֑ל אֵ֤ת כָּל־הַתְּלָאָה֙ אֲשֶׁ֣ר מְצָאָ֣תַם בַּדֶּ֔רֶךְ וַיַּצִּלֵ֖ם יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","וַיִּ֣חַדְּ יִתְרֹ֔ו עַ֚ל כָּל־הַטֹּובָ֔ה אֲשֶׁר־עָשָׂ֥ה יְהוָ֖ה לְיִשְׂרָאֵ֑ל אֲשֶׁ֥ר הִצִּילֹ֖ו מִיַּ֥ד מִצְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","וַיֹּאמֶר֮ יִתְרֹו֒ בָּר֣וּךְ יְהוָ֔ה אֲשֶׁ֨ר הִצִּ֥יל אֶתְכֶ֛ם מִיַּ֥ד מִצְרַ֖יִם וּמִיַּ֣ד פַּרְעֹ֑ה אֲשֶׁ֤ר הִצִּיל֙ אֶת־הָעָ֔ם מִתַּ֖חַת יַד־מִצְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","עַתָּ֣ה יָדַ֔עְתִּי כִּֽי־גָדֹ֥ול יְהוָ֖ה מִכָּל־הָאֱלֹהִ֑ים כִּ֣י בַדָּבָ֔ר אֲשֶׁ֥ר זָד֖וּ עֲלֵיהֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","וַיִּקַּ֞ח יִתְרֹ֨ו חֹתֵ֥ן מֹשֶׁ֛ה עֹלָ֥ה וּזְבָחִ֖ים לֵֽאלֹהִ֑ים וַיָּבֹ֨א אַהֲרֹ֜ן וְכֹ֣ל ׀ זִקְנֵ֣י יִשְׂרָאֵ֗ל לֶאֱכָל־לֶ֛חֶם עִם־חֹתֵ֥ן מֹשֶׁ֖ה לִפְנֵ֥י הָאֱלֹהִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","וַיְהִי֙ מִֽמָּחֳרָ֔ת וַיֵּ֥שֶׁב מֹשֶׁ֖ה לִשְׁפֹּ֣ט אֶת־הָעָ֑ם וַיַּעֲמֹ֤ד הָעָם֙ עַל־מֹשֶׁ֔ה מִן־הַבֹּ֖קֶר עַד־הָעָֽרֶב׃ ");
INSERT INTO hbo_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","וַיַּרְא֙ חֹתֵ֣ן מֹשֶׁ֔ה אֵ֛ת כָּל־אֲשֶׁר־ה֥וּא עֹשֶׂ֖ה לָעָ֑ם וַיֹּ֗אמֶר מָֽה־הַדָּבָ֤ר הַזֶּה֙ אֲשֶׁ֨ר אַתָּ֤ה עֹשֶׂה֙ לָעָ֔ם מַדּ֗וּעַ אַתָּ֤ה יֹושֵׁב֙ לְבַדֶּ֔ךָ וְכָל־הָעָ֛ם נִצָּ֥ב עָלֶ֖יךָ מִן־בֹּ֥קֶר עַד־עָֽרֶב׃ ");
INSERT INTO hbo_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","וַיֹּ֥אמֶר מֹשֶׁ֖ה לְחֹתְנֹ֑ו כִּֽי־יָבֹ֥א אֵלַ֛י הָעָ֖ם לִדְרֹ֥שׁ אֱלֹהִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","כִּֽי־יִהְיֶ֨ה לָהֶ֤ם דָּבָר֙ בָּ֣א אֵלַ֔י וְשָׁ֣פַטְתִּ֔י בֵּ֥ין אִ֖ישׁ וּבֵ֣ין רֵעֵ֑הוּ וְהֹודַעְתִּ֛י אֶת־חֻקֵּ֥י הָאֱלֹהִ֖ים וְאֶת־תֹּורֹתָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","וַיֹּ֛אמֶר חֹתֵ֥ן מֹשֶׁ֖ה אֵלָ֑יו לֹא־טֹוב֙ הַדָּבָ֔ר אֲשֶׁ֥ר אַתָּ֖ה עֹשֶֽׂה׃ ");
INSERT INTO hbo_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","נָבֹ֣ל תִּבֹּ֔ל גַּם־אַתָּ֕ה גַּם־הָעָ֥ם הַזֶּ֖ה אֲשֶׁ֣ר עִמָּ֑ךְ כִּֽי־כָבֵ֤ד מִמְּךָ֙ הַדָּבָ֔ר לֹא־תוּכַ֥ל עֲשֹׂ֖הוּ לְבַדֶּֽךָ׃ ");
INSERT INTO hbo_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","עַתָּ֞ה שְׁמַ֤ע בְּקֹלִי֙ אִיעָ֣צְךָ֔ וִיהִ֥י אֱלֹהִ֖ים עִמָּ֑ךְ הֱיֵ֧ה אַתָּ֣ה לָעָ֗ם מ֚וּל הָֽאֱלֹהִ֔ים וְהֵבֵאתָ֥ אַתָּ֛ה אֶת־הַדְּבָרִ֖ים אֶל־הָאֱלֹהִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","וְהִזְהַרְתָּ֣ה אֶתְהֶ֔ם אֶת־הַחֻקִּ֖ים וְאֶת־הַתֹּורֹ֑ת וְהֹודַעְתָּ֣ לָהֶ֗ם אֶת־הַדֶּ֙רֶךְ֙ יֵ֣לְכוּ בָ֔הּ וְאֶת־הַֽמַּעֲשֶׂ֖ה אֲשֶׁ֥ר יַעֲשֽׂוּן׃ ");
INSERT INTO hbo_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","וְאַתָּ֣ה תֶחֱזֶ֣ה מִכָּל־הָ֠עָם אַנְשֵׁי־חַ֜יִל יִרְאֵ֧י אֱלֹהִ֛ים אַנְשֵׁ֥י אֱמֶ֖ת שֹׂ֣נְאֵי בָ֑צַע וְשַׂמְתָּ֣ עֲלֵהֶ֗ם שָׂרֵ֤י אֲלָפִים֙ שָׂרֵ֣י מֵאֹ֔ות שָׂרֵ֥י חֲמִשִּׁ֖ים וְשָׂרֵ֥י עֲשָׂרֹֽת׃ ");
INSERT INTO hbo_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","וְשָׁפְט֣וּ אֶת־הָעָם֮ בְּכָל־עֵת֒ וְהָיָ֞ה כָּל־הַדָּבָ֤ר הַגָּדֹל֙ יָבִ֣יאוּ אֵלֶ֔יךָ וְכָל־הַדָּבָ֥ר הַקָּטֹ֖ן יִשְׁפְּטוּ־הֵ֑ם וְהָקֵל֙ מֵֽעָלֶ֔יךָ וְנָשְׂא֖וּ אִתָּֽךְ׃ ");
INSERT INTO hbo_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","אִ֣ם אֶת־הַדָּבָ֤ר הַזֶּה֙ תַּעֲשֶׂ֔ה וְצִוְּךָ֣ אֱלֹהִ֔ים וְיָֽכָלְתָּ֖ עֲמֹ֑ד וְגַם֙ כָּל־הָעָ֣ם הַזֶּ֔ה עַל־מְקֹמֹ֖ו יָבֹ֥א בְשָׁלֹֽום׃ ");
INSERT INTO hbo_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","וַיִּשְׁמַ֥ע מֹשֶׁ֖ה לְקֹ֣ול חֹתְנֹ֑ו וַיַּ֕עַשׂ כֹּ֖ל אֲשֶׁ֥ר אָמָֽר׃ ");
INSERT INTO hbo_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","וַיִּבְחַ֨ר מֹשֶׁ֤ה אַנְשֵׁי־חַ֙יִל֙ מִכָּל־יִשְׂרָאֵ֔ל וַיִּתֵּ֥ן אֹתָ֛ם רָאשִׁ֖ים עַל־הָעָ֑ם שָׂרֵ֤י אֲלָפִים֙ שָׂרֵ֣י מֵאֹ֔ות שָׂרֵ֥י חֲמִשִּׁ֖ים וְשָׂרֵ֥י עֲשָׂרֹֽת׃ ");
INSERT INTO hbo_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","וְשָׁפְט֥וּ אֶת־הָעָ֖ם בְּכָל־עֵ֑ת אֶת־הַדָּבָ֤ר הַקָּשֶׁה֙ יְבִיא֣וּן אֶל־מֹשֶׁ֔ה וְכָל־הַדָּבָ֥ר הַקָּטֹ֖ן יִשְׁפּוּט֥וּ הֵֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","וַיְשַׁלַּ֥ח מֹשֶׁ֖ה אֶת־חֹתְנֹ֑ו וַיֵּ֥לֶךְ לֹ֖ו אֶל־אַרְצֹֽו׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","בַּחֹ֙דֶשׁ֙ הַשְּׁלִישִׁ֔י לְצֵ֥את בְּנֵי־יִשְׂרָאֵ֖ל מֵאֶ֣רֶץ מִצְרָ֑יִם בַּיֹּ֣ום הַזֶּ֔ה בָּ֖אוּ מִדְבַּ֥ר סִינָֽי׃ ");
INSERT INTO hbo_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","וַיִּסְע֣וּ מֵרְפִידִ֗ים וַיָּבֹ֙אוּ֙ מִדְבַּ֣ר סִינַ֔י וַֽיַּחֲנ֖וּ בַּמִּדְבָּ֑ר וַיִּֽחַן־שָׁ֥ם יִשְׂרָאֵ֖ל נֶ֥גֶד הָהָֽר׃ ");
INSERT INTO hbo_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","וּמֹשֶׁ֥ה עָלָ֖ה אֶל־הָאֱלֹהִ֑ים וַיִּקְרָ֨א אֵלָ֤יו יְהוָה֙ מִן־הָהָ֣ר לֵאמֹ֔ר כֹּ֤ה תֹאמַר֙ לְבֵ֣ית יַעֲקֹ֔ב וְתַגֵּ֖יד לִבְנֵ֥י יִשְׂרָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","אַתֶּ֣ם רְאִיתֶ֔ם אֲשֶׁ֥ר עָשִׂ֖יתִי לְמִצְרָ֑יִם וָאֶשָּׂ֤א אֶתְכֶם֙ עַל־כַּנְפֵ֣י נְשָׁרִ֔ים וָאָבִ֥א אֶתְכֶ֖ם אֵלָֽי׃ ");
INSERT INTO hbo_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","וְעַתָּ֗ה אִם־שָׁמֹ֤ועַ תִּשְׁמְעוּ֙ בְּקֹלִ֔י וּשְׁמַרְתֶּ֖ם אֶת־בְּרִיתִ֑י וִהְיִ֨יתֶם לִ֤י סְגֻלָּה֙ מִכָּל־הָ֣עַמִּ֔ים כִּי־לִ֖י כָּל־הָאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","וְאַתֶּ֧ם תִּהְיוּ־לִ֛י מַמְלֶ֥כֶת כֹּהֲנִ֖ים וְגֹ֣וי קָדֹ֑ושׁ אֵ֚לֶּה הַדְּבָרִ֔ים אֲשֶׁ֥ר תְּדַבֵּ֖ר אֶל־בְּנֵ֥י יִשְׂרָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","וַיָּבֹ֣א מֹשֶׁ֔ה וַיִּקְרָ֖א לְזִקְנֵ֣י הָעָ֑ם וַיָּ֣שֶׂם לִפְנֵיהֶ֗ם אֵ֚ת כָּל־הַדְּבָרִ֣ים הָאֵ֔לֶּה אֲשֶׁ֥ר צִוָּ֖הוּ יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","וַיַּעֲנ֨וּ כָל־הָעָ֤ם יַחְדָּו֙ וַיֹּ֣אמְר֔וּ כֹּ֛ל אֲשֶׁר־דִּבֶּ֥ר יְהוָ֖ה נַעֲשֶׂ֑ה וַיָּ֧שֶׁב מֹשֶׁ֛ה אֶת־דִּבְרֵ֥י הָעָ֖ם אֶל־יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","וַיֹּ֨אמֶר יְהוָ֜ה אֶל־מֹשֶׁ֗ה הִנֵּ֨ה אָנֹכִ֜י בָּ֣א אֵלֶיךָ֮ בְּעַ֣ב הֶֽעָנָן֒ בַּעֲב֞וּר יִשְׁמַ֤ע הָעָם֙ בְּדַבְּרִ֣י עִמָּ֔ךְ וְגַם־בְּךָ֖ יַאֲמִ֣ינוּ לְעֹולָ֑ם וַיַּגֵּ֥ד מֹשֶׁ֛ה אֶת־דִּבְרֵ֥י הָעָ֖ם אֶל־יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","וַיֹּ֨אמֶר יְהוָ֤ה אֶל־מֹשֶׁה֙ לֵ֣ךְ אֶל־הָעָ֔ם וְקִדַּשְׁתָּ֥ם הַיֹּ֖ום וּמָחָ֑ר וְכִבְּס֖וּ שִׂמְלֹתָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","וְהָי֥וּ נְכֹנִ֖ים לַיֹּ֣ום הַשְּׁלִישִׁ֑י כִּ֣י ׀ בַּיֹּ֣ום הַשְּׁלִישִׁ֗י יֵרֵ֧ד יְהוָ֛ה לְעֵינֵ֥י כָל־הָעָ֖ם עַל־הַ֥ר סִינָֽי׃ ");
INSERT INTO hbo_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","וְהִגְבַּלְתָּ֤ אֶת־הָעָם֙ סָבִ֣יב לֵאמֹ֔ר הִשָּׁמְר֥וּ לָכֶ֛ם עֲלֹ֥ות בָּהָ֖ר וּנְגֹ֣עַ בְּקָצֵ֑הוּ כָּל־הַנֹּגֵ֥עַ בָּהָ֖ר מֹ֥ות יוּמָֽת׃ ");
INSERT INTO hbo_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","לֹא־תִגַּ֨ע בֹּ֜ו יָ֗ד כִּֽי־סָקֹ֤ול יִסָּקֵל֙ אֹו־יָרֹ֣ה יִיָּרֶ֔ה אִם־בְּהֵמָ֥ה אִם־אִ֖ישׁ לֹ֣א יִחְיֶ֑ה בִּמְשֹׁךְ֙ הַיֹּבֵ֔ל הֵ֖מָּה יַעֲל֥וּ בָהָֽר׃ ");
INSERT INTO hbo_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","וַיֵּ֧רֶד מֹשֶׁ֛ה מִן־הָהָ֖ר אֶל־הָעָ֑ם וַיְקַדֵּשׁ֙ אֶת־הָעָ֔ם וַֽיְכַבְּס֖וּ שִׂמְלֹתָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","וַיֹּ֙אמֶר֙ אֶל־הָעָ֔ם הֱי֥וּ נְכֹנִ֖ים לִשְׁלֹ֣שֶׁת יָמִ֑ים אַֽל־תִּגְּשׁ֖וּ אֶל־אִשָּֽׁה׃ ");
INSERT INTO hbo_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","וַיְהִי֩ בַיֹּ֨ום הַשְּׁלִישִׁ֜י בִּֽהְיֹ֣ת הַבֹּ֗קֶר וַיְהִי֩ קֹלֹ֨ת וּבְרָקִ֜ים וְעָנָ֤ן כָּבֵד֙ עַל־הָהָ֔ר וְקֹ֥ל שֹׁפָ֖ר חָזָ֣ק מְאֹ֑ד וַיֶּחֱרַ֥ד כָּל־הָעָ֖ם אֲשֶׁ֥ר בַּֽמַּחֲנֶֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","וַיֹּוצֵ֨א מֹשֶׁ֧ה אֶת־הָעָ֛ם לִקְרַ֥את הָֽאֱלֹהִ֖ים מִן־הַֽמַּחֲנֶ֑ה וַיִּֽתְיַצְּב֖וּ בְּתַחְתִּ֥ית הָהָֽר׃ ");
INSERT INTO hbo_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","וְהַ֤ר סִינַי֙ עָשַׁ֣ן כֻּלֹּ֔ו מִ֠פְּנֵי אֲשֶׁ֨ר יָרַ֥ד עָלָ֛יו יְהוָ֖ה בָּאֵ֑שׁ וַיַּ֤עַל עֲשָׁנֹו֙ כְּעֶ֣שֶׁן הַכִּבְשָׁ֔ן וַיֶּחֱרַ֥ד כָּל־הָהָ֖ר מְאֹֽד׃ ");
INSERT INTO hbo_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","וַיְהִי֙ קֹ֣ול הַשֹּׁופָ֔ר הֹולֵ֖ךְ וְחָזֵ֣ק מְאֹ֑ד מֹשֶׁ֣ה יְדַבֵּ֔ר וְהָאֱלֹהִ֖ים יַעֲנֶ֥נּוּ בְקֹֽול׃ ");
INSERT INTO hbo_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","וַיֵּ֧רֶד יְהוָ֛ה עַל־הַ֥ר סִינַ֖י אֶל־רֹ֣אשׁ הָהָ֑ר וַיִּקְרָ֨א יְהוָ֧ה לְמֹשֶׁ֛ה אֶל־רֹ֥אשׁ הָהָ֖ר וַיַּ֥עַל מֹשֶֽׁה׃ ");
INSERT INTO hbo_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","וַיֹּ֤אמֶר יְהוָה֙ אֶל־מֹשֶׁ֔ה רֵ֖ד הָעֵ֣ד בָּעָ֑ם פֶּן־יֶהֶרְס֤וּ אֶל־יְהוָה֙ לִרְאֹ֔ות וְנָפַ֥ל מִמֶּ֖נּוּ רָֽב׃ ");
INSERT INTO hbo_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","וְגַ֧ם הַכֹּהֲנִ֛ים הַנִּגָּשִׁ֥ים אֶל־יְהוָ֖ה יִתְקַדָּ֑שׁוּ פֶּן־יִפְרֹ֥ץ בָּהֶ֖ם יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","וַיֹּ֤אמֶר מֹשֶׁה֙ אֶל־יְהוָ֔ה לֹא־יוּכַ֣ל הָעָ֔ם לַעֲלֹ֖ת אֶל־הַ֣ר סִינָ֑י כִּֽי־אַתָּ֞ה הַעֵדֹ֤תָה בָּ֙נוּ֙ לֵאמֹ֔ר הַגְבֵּ֥ל אֶת־הָהָ֖ר וְקִדַּשְׁתֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","וַיֹּ֨אמֶר אֵלָ֤יו יְהוָה֙ לֶךְ־רֵ֔ד וְעָלִ֥יתָ אַתָּ֖ה וְאַהֲרֹ֣ן עִמָּ֑ךְ וְהַכֹּהֲנִ֣ים וְהָעָ֗ם אַל־יֽ͏ֶהֶרְס֛וּ לַעֲלֹ֥ת אֶל־יְהוָ֖ה פֶּן־יִפְרָץ־בָּֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","וַיֵּ֥רֶד מֹשֶׁ֖ה אֶל־הָעָ֑ם וַיֹּ֖אמֶר אֲלֵהֶֽם׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","וַיְדַבֵּ֣ר אֱלֹהִ֔ים אֵ֛ת כָּל־הַדְּבָרִ֥ים הָאֵ֖לֶּה לֵאמֹֽר׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","אָֽנֹכִ֖י֙ יְהוָ֣ה אֱלֹהֶ֑֔יךָ אֲשֶׁ֧ר הֹוצֵאתִ֛יךָ מֵאֶ֥רֶץ מִצְרַ֖יִם מִבֵּ֣֥ית עֲבָדִֽ֑ים׃ ");
INSERT INTO hbo_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","לֹֽ֣א יִהְיֶֽה־לְךָ֛֩ אֱלֹהִ֥֨ים אֲחֵרִ֖֜ים עַל־פָּנָֽ֗יַ ");
INSERT INTO hbo_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","לֹֽ֣א תֽ͏ַעֲשֶׂ֨ה־לְךָ֥֣ פֶ֣֙סֶל֙ ׀ וְכָל־תְּמוּנָ֡֔ה אֲשֶׁ֤֣ר בַּשָּׁמַ֣֙יִם֙ ׀ מִמַּ֡֔עַל וֽ͏ַאֲשֶׁ֥ר֩ בָּאָ֖֨רֶץ מִתָּ֑͏ַ֜חַת וַאֲשֶׁ֥֣ר בַּמַּ֖֣יִם ׀ מִתַּ֥֣חַת לָאָֽ֗רֶץ ");
INSERT INTO hbo_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","לֹֽא־תִשְׁתַּחְוֶ֥֣ה לָהֶ֖ם֮ וְלֹ֣א תָעָבְדֵ֑ם֒ כִּ֣י אֽ͏ָנֹכִ֞י יְהוָ֤ה אֱלֹהֶ֙יךָ֙ אֵ֣ל קַנָּ֔א פֹּ֠קֵד עֲוֹ֨ן אָבֹ֧ת עַל־בָּנִ֛ים עַל־שִׁלֵּשִׁ֥ים וְעַל־רִבֵּעִ֖ים לְשֹׂנְאָֽ֑י׃ ");
INSERT INTO hbo_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","וְעֹ֥֤שֶׂה חֶ֖֙סֶד֙ לַאֲלָפִ֑֔ים לְאֹהֲבַ֖י וּלְשֹׁמְרֵ֥י מִצְוֹתָֽי׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","לֹ֥א תִשָּׂ֛א אֶת־שֵֽׁם־יְהוָ֥ה אֱלֹהֶ֖יךָ לַשָּׁ֑וְא כִּ֣י לֹ֤א יְנַקֶּה֙ יְהוָ֔ה אֵ֛ת אֲשֶׁר־יִשָּׂ֥א אֶת־שְׁמֹ֖ו לַשָּֽׁוְא׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","זָכֹ֛ור֩ אֶת־יֹ֥֨ום הַשַּׁבָּ֖֜ת לְקַדְּשֹֽׁ֗ו ");
INSERT INTO hbo_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","שֵׁ֤֣שֶׁת יָמִ֣ים֙ תּֽ͏ַעֲבֹ֔ד֮ וְעָשִׂ֖֣יתָ כָּל־מְלַאכְתֶּֽךָ֒ ");
INSERT INTO hbo_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","וְיֹ֙ום֙ הַשְּׁבִיעִ֔֜י שַׁבָּ֖֣ת ׀ לַיהוָ֣ה אֱלֹהֶ֑֗יךָ לֹֽ֣א־תַעֲשֶׂ֣֨ה כָל־מְלָאכָ֡֜ה אַתָּ֣ה ׀ וּבִנְךָֽ֣־וּ֠בִתֶּ֗ךָ עַבְדְּךָ֤֨ וַאֲמָֽתְךָ֜֙ וּבְהֶמְתֶּ֔֗ךָ וְגֵרְךָ֖֙ אֲשֶׁ֥֣ר בִּשְׁעָרֶֽ֔יךָ ");
INSERT INTO hbo_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","כִּ֣י שֵֽׁשֶׁת־יָמִים֩ עָשָׂ֨ה יְהוָ֜ה אֶת־הַשָּׁמַ֣יִם וְאֶת־הָאָ֗רֶץ אֶת־הַיָּם֙ וְאֶת־כָּל־אֲשֶׁר־בָּ֔ם וַיָּ֖נַח בַּיֹּ֣ום הַשְּׁבִיעִ֑י עַל־כֵּ֗ן בֵּרַ֧ךְ יְהוָ֛ה אֶת־יֹ֥ום הַשַּׁבָּ֖ת וַֽיְקַדְּשֵֽׁהוּ׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","כַּבֵּ֥ד אֶת־אָבִ֖יךָ וְאֶת־אִמֶּ֑ךָ לְמַ֙עַן֙ יַאֲרִכ֣וּן יָמֶ֔יךָ עַ֚ל הָאֲדָמָ֔ה אֲשֶׁר־יְהוָ֥ה אֱלֹהֶ֖יךָ נֹתֵ֥ן לָֽךְ׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","לֹ֥֖א תִּֿרְצָֽ֖ח׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","לֹ֣֖א תִּֿנְאָֽ֑ף׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","לֹ֣֖א תִּֿגְנֹֽ֔ב׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","לֹֽא־תַעֲנֶ֥ה בְרֵעֲךָ֖ עֵ֥ד שָֽׁקֶר׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","לֹ֥א תַחְמֹ֖ד בֵּ֣ית רֵעֶ֑ךָ לֹֽא־תַחְמֹ֞ד אֵ֣שֶׁת רֵעֶ֗ךָ וְעַבְדֹּ֤ו וַאֲמָתֹו֙ וְשֹׁורֹ֣ו וַחֲמֹרֹ֔ו וְכֹ֖ל אֲשֶׁ֥ר לְרֵעֶֽךָ׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","וְכָל־הָעָם֩ רֹאִ֨ים אֶת־הַקֹּולֹ֜ת וְאֶת־הַלַּפִּידִ֗ם וְאֵת֙ קֹ֣ול הַשֹּׁפָ֔ר וְאֶת־הָהָ֖ר עָשֵׁ֑ן וַיַּ֤רְא הָעָם֙ וַיָּנֻ֔עוּ וַיּֽ͏ַעַמְד֖וּ מֵֽרָחֹֽק׃ ");
INSERT INTO hbo_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","וַיֹּֽאמְרוּ֙ אֶל־מֹשֶׁ֔ה דַּבֵּר־אַתָּ֥ה עִמָּ֖נוּ וְנִשְׁמָ֑עָה וְאַל־יְדַבֵּ֥ר עִמָּ֛נוּ אֱלֹהִ֖ים פֶּן־נָמֽוּת׃ ");
INSERT INTO hbo_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","וַיֹּ֨אמֶר מֹשֶׁ֣ה אֶל־הָעָם֮ אַל־תִּירָאוּ֒ כִּ֗י לְבַֽעֲבוּר֙ נַסֹּ֣ות אֶתְכֶ֔ם בָּ֖א הָאֱלֹהִ֑ים וּבַעֲב֗וּר תִּהְיֶ֧ה יִרְאָתֹ֛ו עַל־פְּנֵיכֶ֖ם לְבִלְתִּ֥י תֶחֱטָֽאוּ׃ ");
INSERT INTO hbo_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","וַיַּעֲמֹ֥ד הָעָ֖ם מֵרָחֹ֑ק וּמֹשֶׁה֙ נִגַּ֣שׁ אֶל־הָֽעֲרָפֶ֔ל אֲשֶׁר־שָׁ֖ם הָאֱלֹהִֽים׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","וַיֹּ֤אמֶר יְהוָה֙ אֶל־מֹשֶׁ֔ה כֹּ֥ה תֹאמַ֖ר אֶל־בְּנֵ֣י יִשְׂרָאֵ֑ל אַתֶּ֣ם רְאִיתֶ֔ם כִּ֚י מִן־הַשָּׁמַ֔יִם דִּבַּ֖רְתִּי עִמָּכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","לֹ֥א תַעֲשׂ֖וּן אִתִּ֑י אֱלֹ֤הֵי כֶ֙סֶף֙ וֵאלֹהֵ֣י זָהָ֔ב לֹ֥א תַעֲשׂ֖וּ לָכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","מִזְבַּ֣ח אֲדָמָה֮ תַּעֲשֶׂה־לִּי֒ וְזָבַחְתָּ֣ עָלָ֗יו אֶת־עֹלֹתֶ֙יךָ֙ וְאֶת־שְׁלָמֶ֔יךָ אֶת־צֹֽאנְךָ֖ וְאֶת־בְּקָרֶ֑ךָ בְּכָל־הַמָּקֹום֙ אֲשֶׁ֣ר אַזְכִּ֣יר אֶת־שְׁמִ֔י אָבֹ֥וא אֵלֶ֖יךָ וּבֵרַכְתִּֽיךָ׃ ");
INSERT INTO hbo_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","וְאִם־מִזְבַּ֤ח אֲבָנִים֙ תַּֽעֲשֶׂה־לִּ֔י לֹֽא־תִבְנֶ֥ה אֶתְהֶ֖ן גָּזִ֑ית כִּ֧י חַרְבְּךָ֛ הֵנַ֥פְתָּ עָלֶ֖יהָ וַתְּחַֽלְלֶֽהָ׃ ");
INSERT INTO hbo_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","וְלֹֽא־תַעֲלֶ֥ה בְמַעֲלֹ֖ת עַֽל־מִזְבְּחִ֑י אֲשֶׁ֛ר לֹֽא־תִגָּלֶ֥ה עֶרְוָתְךָ֖ עָלָֽיו׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","וְאֵ֙לֶּה֙ הַמִּשְׁפָּטִ֔ים אֲשֶׁ֥ר תָּשִׂ֖ים לִפְנֵיהֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","כִּ֤י תִקְנֶה֙ עֶ֣בֶד עִבְרִ֔י שֵׁ֥שׁ שָׁנִ֖ים יַעֲבֹ֑ד וּבַ֨שְּׁבִעִ֔ת יֵצֵ֥א לַֽחָפְשִׁ֖י חִנָּֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","אִם־בְּגַפֹּ֥ו יָבֹ֖א בְּגַפֹּ֣ו יֵצֵ֑א אִם־בַּ֤עַל אִשָּׁה֙ ה֔וּא וְיָצְאָ֥ה אִשְׁתֹּ֖ו עִמֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","אִם־אֲדֹנָיו֙ יִתֶּן־לֹ֣ו אִשָּׁ֔ה וְיָלְדָה־לֹ֥ו בָנִ֖ים אֹ֣ו בָנֹ֑ות הָאִשָּׁ֣ה וִילָדֶ֗יהָ תִּהְיֶה֙ לַֽאדֹנֶ֔יהָ וְה֖וּא יֵצֵ֥א בְגַפֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","וְאִם־אָמֹ֤ר יֹאמַר֙ הָעֶ֔בֶד אָהַ֙בְתִּי֙ אֶת־אֲדֹנִ֔י אֶת־אִשְׁתִּ֖י וְאֶת־בָּנָ֑י לֹ֥א אֵצֵ֖א חָפְשִֽׁי׃ ");
INSERT INTO hbo_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","וְהִגִּישֹׁ֤ו אֲדֹנָיו֙ אֶל־הָ֣אֱלֹהִ֔ים וְהִגִּישֹׁו֙ אֶל־הַדֶּ֔לֶת אֹ֖ו אֶל־הַמְּזוּזָ֑ה וְרָצַ֨ע אֲדֹנָ֤יו אֶת־אָזְנֹו֙ בַּמַּרְצֵ֔עַ וַעֲבָדֹ֖ו לְעֹלָֽם׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","וְכִֽי־יִמְכֹּ֥ר אִ֛ישׁ אֶת־בִּתֹּ֖ו לְאָמָ֑ה לֹ֥א תֵצֵ֖א כְּצֵ֥את הָעֲבָדִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","אִם־רָעָ֞ה בְּעֵינֵ֧י אֲדֹנֶ֛יהָ אֲשֶׁר־*לֹא (לֹ֥ו) יְעָדָ֖הּ וְהֶפְדָּ֑הּ לְעַ֥ם נָכְרִ֛י לֹא־יִמְשֹׁ֥ל לְמָכְרָ֖הּ בְּבִגְדֹו־בָֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","וְאִם־לִבְנֹ֖ו יִֽיעָדֶ֑נָּה כְּמִשְׁפַּ֥ט הַבָּנֹ֖ות יַעֲשֶׂה־לָּֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","אִם־אַחֶ֖רֶת יִֽקַּֽח־לֹ֑ו שְׁאֵרָ֛הּ כְּסוּתָ֥הּ וְעֹנָתָ֖הּ לֹ֥א יִגְרָֽע׃ ");
INSERT INTO hbo_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","וְאִם־שְׁלָ֨שׁ־אֵ֔לֶּה לֹ֥א יַעֲשֶׂ֖ה לָ֑הּ וְיָצְאָ֥ה חִנָּ֖ם אֵ֥ין כָּֽסֶף׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","מַכֵּ֥ה אִ֛ישׁ וָמֵ֖ת מֹ֥ות יוּמָֽת׃ ");
INSERT INTO hbo_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","וַאֲשֶׁר֙ לֹ֣א צָדָ֔ה וְהָאֱלֹהִ֖ים אִנָּ֣ה לְיָדֹ֑ו וְשַׂמְתִּ֤י לְךָ֙ מָקֹ֔ום אֲשֶׁ֥ר יָנ֖וּס שָֽׁמָּה׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","וְכִי־יָזִ֥ד אִ֛ישׁ עַל־רֵעֵ֖הוּ לְהָרְגֹ֣ו בְעָרְמָ֑ה מֵעִ֣ם מִזְבְּחִ֔י תִּקָּחֶ֖נּוּ לָמֽוּת׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","וּמַכֵּ֥ה אָבִ֛יו וְאִמֹּ֖ו מֹ֥ות יוּמָֽת׃ ");
INSERT INTO hbo_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","וְגֹנֵ֨ב אִ֧ישׁ וּמְכָרֹ֛ו וְנִמְצָ֥א בְיָדֹ֖ו מֹ֥ות יוּמָֽת׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","וּמְקַלֵּ֥ל אָבִ֛יו וְאִמֹּ֖ו מֹ֥ות יוּמָֽת׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","וְכִֽי־יְרִיבֻ֣ן אֲנָשִׁ֔ים וְהִכָּה־אִישׁ֙ אֶת־רֵעֵ֔הוּ בְּאֶ֖בֶן אֹ֣ו בְאֶגְרֹ֑ף וְלֹ֥א יָמ֖וּת וְנָפַ֥ל לְמִשְׁכָּֽב׃ ");
INSERT INTO hbo_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","אִם־יָק֞וּם וְהִתְהַלֵּ֥ךְ בַּח֛וּץ עַל־מִשְׁעַנְתֹּ֖ו וְנִקָּ֣ה הַמַּכֶּ֑ה רַ֥ק שִׁבְתֹּ֛ו יִתֵּ֖ן וְרַפֹּ֥א יְרַפֵּֽא׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","וְכִֽי־יַכֶּה֩ אִ֨ישׁ אֶת־עַבְדֹּ֜ו אֹ֤ו אֶת־אֲמָתֹו֙ בַּשֵּׁ֔בֶט וּמֵ֖ת תַּ֣חַת יָדֹ֑ו נָקֹ֖ם יִנָּקֵֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","אַ֥ךְ אִם־יֹ֛ום אֹ֥ו יֹומַ֖יִם יַעֲמֹ֑ד לֹ֣א יֻקַּ֔ם כִּ֥י כַסְפֹּ֖ו הֽוּא׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","וְכִֽי־יִנָּצ֣וּ אֲנָשִׁ֗ים וְנָ֨גְפ֜וּ אִשָּׁ֤ה הָרָה֙ וְיָצְא֣וּ יְלָדֶ֔יהָ וְלֹ֥א יִהְיֶ֖ה אָסֹ֑ון עָנֹ֣ושׁ יֵעָנֵ֗שׁ כּֽ͏ַאֲשֶׁ֨ר יָשִׁ֤ית עָלָיו֙ בַּ֣עַל הָֽאִשָּׁ֔ה וְנָתַ֖ן בִּפְלִלִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","וְאִם־אָסֹ֖ון יִהְיֶ֑ה וְנָתַתָּ֥ה נֶ֖פֶשׁ תַּ֥חַת נָֽפֶשׁ׃ ");
INSERT INTO hbo_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","עַ֚יִן תַּ֣חַת עַ֔יִן שֵׁ֖ן תַּ֣חַת שֵׁ֑ן יָ֚ד תַּ֣חַת יָ֔ד רֶ֖גֶל תַּ֥חַת רָֽגֶל׃ ");
INSERT INTO hbo_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","כְּוִיָּה֙ תַּ֣חַת כְּוִיָּ֔ה פֶּ֖צַע תַּ֣חַת פָּ֑צַע חַבּוּרָ֕ה תַּ֖חַת חַבּוּרָֽה׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","וְכִֽי־יַכֶּ֨ה אִ֜ישׁ אֶת־עֵ֥ין עַבְדֹּ֛ו אֹֽו־אֶת־עֵ֥ין אֲמָתֹ֖ו וְשִֽׁחֲתָ֑הּ לֽ͏ַחָפְשִׁ֥י יְשַׁלְּחֶ֖נּוּ תַּ֥חַת עֵינֹֽו׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","וְאִם־שֵׁ֥ן עַבְדֹּ֛ו אֹֽו־שֵׁ֥ן אֲמָתֹ֖ו יַפִּ֑יל לֽ͏ַחָפְשִׁ֥י יְשַׁלְּחֶ֖נּוּ תַּ֥חַת שִׁנֹּֽו׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","וְכִֽי־יִגַּ֨ח שֹׁ֥ור אֶת־אִ֛ישׁ אֹ֥ו אֶת־אִשָּׁ֖ה וָמֵ֑ת סָקֹ֨ול יִסָּקֵ֜ל הַשֹּׁ֗ור וְלֹ֤א יֵאָכֵל֙ אֶת־בְּשָׂרֹ֔ו וּבַ֥עַל הַשֹּׁ֖ור נָקִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","וְאִ֡ם שֹׁור֩ נַגָּ֨ח ה֜וּא מִתְּמֹ֣ל שִׁלְשֹׁ֗ם וְהוּעַ֤ד בִּבְעָלָיו֙ וְלֹ֣א יִשְׁמְרֶ֔נּוּ וְהֵמִ֥ית אִ֖ישׁ אֹ֣ו אִשָּׁ֑ה הַשֹּׁור֙ יִסָּקֵ֔ל וְגַם־בְּעָלָ֖יו יוּמָֽת׃ ");
INSERT INTO hbo_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","אִם־כֹּ֖פֶר יוּשַׁ֣ת עָלָ֑יו וְנָתַן֙ פִּדְיֹ֣ן נַפְשֹׁ֔ו כְּכֹ֥ל אֲשֶׁר־יוּשַׁ֖ת עָלָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","אֹו־בֵ֥ן יִגָּ֖ח אֹו־בַ֣ת יִגָּ֑ח כַּמִּשְׁפָּ֥ט הַזֶּ֖ה יֵעָ֥שֶׂה לֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","אִם־עֶ֛בֶד יִגַּ֥ח הַשֹּׁ֖ור אֹ֣ו אָמָ֑ה כֶּ֣סֶף ׀ שְׁלֹשִׁ֣ים שְׁקָלִ֗ים יִתֵּן֙ לַֽאדֹנָ֔יו וְהַשֹּׁ֖ור יִסָּקֵֽל׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","וְכִֽי־יִפְתַּ֨ח אִ֜ישׁ בֹּ֗ור אֹ֠ו כִּֽי־יִכְרֶ֥ה אִ֛ישׁ בֹּ֖ר וְלֹ֣א יְכַסֶּ֑נּוּ וְנָֽפַל־שָׁ֥מָּה שֹּׁ֖ור אֹ֥ו חֲמֹֽור׃ ");
INSERT INTO hbo_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","בַּ֤עַל הַבֹּור֙ יְשַׁלֵּ֔ם כֶּ֖סֶף יָשִׁ֣יב לִבְעָלָ֑יו וְהַמֵּ֖ת יִֽהְיֶה־לֹּֽו׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","וְכִֽי־יִגֹּ֧ף שֹֽׁור־אִ֛ישׁ אֶת־שֹׁ֥ור רֵעֵ֖הוּ וָמֵ֑ת וּמָ֨כְר֜וּ אֶת־הַשֹּׁ֤ור הַחַי֙ וְחָצ֣וּ אֶת־כַּסְפֹּ֔ו וְגַ֥ם אֶת־הַמֵּ֖ת יֽ͏ֶחֱצֽוּן׃ ");
INSERT INTO hbo_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","אֹ֣ו נֹודַ֗ע כִּ֠י שֹׁ֣ור נַגָּ֥ח הוּא֙ מִתְּמֹ֣ול שִׁלְשֹׁ֔ם וְלֹ֥א יִשְׁמְרֶ֖נּוּ בְּעָלָ֑יו שַׁלֵּ֨ם יְשַׁלֵּ֥ם שֹׁור֙ תַּ֣חַת הַשֹּׁ֔ור וְהַמֵּ֖ת יִֽהְיֶה־לֹּֽו׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX21_37","003_21_37","EXO","21","37","37","כִּ֤י יִגְנֹֽב־אִישׁ֙ שֹׁ֣ור אֹו־שֶׂ֔ה וּטְבָחֹ֖ו אֹ֣ו מְכָרֹ֑ו חֲמִשָּׁ֣ה בָקָ֗ר יְשַׁלֵּם֙ תַּ֣חַת הַשֹּׁ֔ור וְאַרְבַּע־צֹ֖אן תַּ֥חַת הַשֶּֽׂה׃ ");
INSERT INTO hbo_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","אִם־בַּמַּחְתֶּ֛רֶת יִמָּצֵ֥א הַגַּנָּ֖ב וְהֻכָּ֣ה וָמֵ֑ת אֵ֥ין לֹ֖ו דָּמִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","אִם־זָרְחָ֥ה הַשֶּׁ֛מֶשׁ עָלָ֖יו דָּמִ֣ים לֹ֑ו שַׁלֵּ֣ם יְשַׁלֵּ֔ם אִם־אֵ֣ין לֹ֔ו וְנִמְכַּ֖ר בִּגְנֵבָתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","אִֽם־הִמָּצֵא֩ תִמָּצֵ֨א בְיָדֹ֜ו הַגְּנֵבָ֗ה מִשֹּׁ֧ור עַד־חֲמֹ֛ור עַד־שֶׂ֖ה חַיִּ֑ים שְׁנַ֖יִם יְשַׁלֵּֽם׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","כִּ֤י יַבְעֶר־אִישׁ֙ שָׂדֶ֣ה אֹו־כֶ֔רֶם וְשִׁלַּח֙ אֶת־*בְּעִירָה (בְּעִירֹ֔ו) וּבִעֵ֖ר בִּשְׂדֵ֣ה אַחֵ֑ר מֵיטַ֥ב שָׂדֵ֛הוּ וּמֵיטַ֥ב כַּרְמֹ֖ו יְשַׁלֵּֽם׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","כִּֽי־תֵצֵ֨א אֵ֜שׁ וּמָצְאָ֤ה קֹצִים֙ וְנֶאֱכַ֣ל גָּדִ֔ישׁ אֹ֥ו הַקָּמָ֖ה אֹ֣ו הַשָּׂדֶ֑ה שַׁלֵּ֣ם יְשַׁלֵּ֔ם הַמַּבְעִ֖ר אֶת־הַבְּעֵרָֽה׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","כִּֽי־יִתֵּן֩ אִ֨ישׁ אֶל־רֵעֵ֜הוּ כֶּ֤סֶף אֹֽו־כֵלִים֙ לִשְׁמֹ֔ר וְגֻנַּ֖ב מִבֵּ֣ית הָאִ֑ישׁ אִם־יִמָּצֵ֥א הַגַּנָּ֖ב יְשַׁלֵּ֥ם שְׁנָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","אִם־לֹ֤א יִמָּצֵא֙ הַגַּנָּ֔ב וְנִקְרַ֥ב בַּֽעַל־הַבַּ֖יִת אֶל־הָֽאֱלֹהִ֑ים אִם־לֹ֥א שָׁלַ֛ח יָדֹ֖ו בִּמְלֶ֥אכֶת רֵעֵֽהוּ׃ ");
INSERT INTO hbo_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","עַֽל־כָּל־דְּבַר־פֶּ֡שַׁע עַל־שֹׁ֡ור עַל־חֲ֠מֹור עַל־שֶׂ֨ה עַל־שַׂלְמָ֜ה עַל־כָּל־אֲבֵדָ֗ה אֲשֶׁ֤ר יֹאמַר֙ כִּי־ה֣וּא זֶ֔ה עַ֚ד הָֽאֱלֹהִ֔ים יָבֹ֖א דְּבַר־שְׁנֵיהֶ֑ם אֲשֶׁ֤ר יַרְשִׁיעֻן֙ אֱלֹהִ֔ים יְשַׁלֵּ֥ם שְׁנַ֖יִם לְרֵעֵֽהוּ׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","כִּֽי־יִתֵּן֩ אִ֨ישׁ אֶל־רֵעֵ֜הוּ חֲמֹ֨ור אֹו־שֹׁ֥ור אֹו־שֶׂ֛ה וְכָל־בְּהֵמָ֖ה לִשְׁמֹ֑ר וּמֵ֛ת אֹו־נִשְׁבַּ֥ר אֹו־נִשְׁבָּ֖ה אֵ֥ין רֹאֶֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","שְׁבֻעַ֣ת יְהוָ֗ה תִּהְיֶה֙ בֵּ֣ין שְׁנֵיהֶ֔ם אִם־לֹ֥א שָׁלַ֛ח יָדֹ֖ו בִּמְלֶ֣אכֶת רֵעֵ֑הוּ וְלָקַ֥ח בְּעָלָ֖יו וְלֹ֥א יְשַׁלֵּֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","וְאִם־גָּנֹ֥ב יִגָּנֵ֖ב מֵעִמֹּ֑ו יְשַׁלֵּ֖ם לִבְעָלָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","אִם־טָרֹ֥ף יִטָּרֵ֖ף יְבִאֵ֣הוּ עֵ֑ד הַטְּרֵפָ֖ה לֹ֥א יְשַׁלֵּֽם׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","וְכִֽי־יִשְׁאַ֥ל אִ֛ישׁ מֵעִ֥ם רֵעֵ֖הוּ וְנִשְׁבַּ֣ר אֹו־מֵ֑ת בְּעָלָ֥יו אֵין־עִמֹּ֖ו שַׁלֵּ֥ם יְשַׁלֵּֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","אִם־בְּעָלָ֥יו עִמֹּ֖ו לֹ֣א יְשַׁלֵּ֑ם אִם־שָׂכִ֣יר ה֔וּא בָּ֖א בִּשְׂכָרֹֽו׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","וְכִֽי־יְפַתֶּ֣ה אִ֗ישׁ בְּתוּלָ֛ה אֲשֶׁ֥ר לֹא־אֹרָ֖שָׂה וְשָׁכַ֣ב עִמָּ֑הּ מָהֹ֛ר יִמְהָרֶ֥נָּה לֹּ֖ו לְאִשָּֽׁה׃ ");
INSERT INTO hbo_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","אִם־מָאֵ֧ן יְמָאֵ֛ן אָבִ֖יהָ לְתִתָּ֣הּ לֹ֑ו כֶּ֣סֶף יִשְׁקֹ֔ל כְּמֹ֖הַר הַבְּתוּלֹֽת׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","מְכַשֵּׁפָ֖ה לֹ֥א תְחַיֶּֽה׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","כָּל־שֹׁכֵ֥ב עִם־בְּהֵמָ֖ה מֹ֥ות יוּמָֽת׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","זֹבֵ֥חַ לָאֱלֹהִ֖ים יָֽחֳרָ֑ם בִּלְתִּ֥י לַיהוָ֖ה לְבַדֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","וְגֵ֥ר לֹא־תֹונֶ֖ה וְלֹ֣א תִלְחָצֶ֑נּוּ כִּֽי־גֵרִ֥ים הֱיִיתֶ֖ם בְּאֶ֥רֶץ מִצְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","כָּל־אַלְמָנָ֥ה וְיָתֹ֖ום לֹ֥א תְעַנּֽוּן׃ ");
INSERT INTO hbo_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","אִם־עַנֵּ֥ה תְעַנֶּ֖ה אֹתֹ֑ו כִּ֣י אִם־צָעֹ֤ק יִצְעַק֙ אֵלַ֔י שָׁמֹ֥עַ אֶשְׁמַ֖ע צַעֲקָתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","וְחָרָ֣ה אַפִּ֔י וְהָרַגְתִּ֥י אֶתְכֶ֖ם בֶּחָ֑רֶב וְהָי֤וּ נְשֵׁיכֶם֙ אַלְמָנֹ֔ות וּבְנֵיכֶ֖ם יְתֹמִֽים׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","אִם־כֶּ֣סֶף ׀ תַּלְוֶ֣ה אֶת־עַמִּ֗י אֶת־הֶֽעָנִי֙ עִמָּ֔ךְ לֹא־תִהְיֶ֥ה לֹ֖ו כְּנֹשֶׁ֑ה לֹֽא־תְשִׂימ֥וּן עָלָ֖יו נֶֽשֶׁךְ׃ ");
INSERT INTO hbo_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","אִם־חָבֹ֥ל תַּחְבֹּ֖ל שַׂלְמַ֣ת רֵעֶ֑ךָ עַד־בֹּ֥א הַשֶּׁ֖מֶשׁ תְּשִׁיבֶ֥נּוּ לֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","כִּ֣י הִ֤וא *כְסוּתָה (כְסוּתֹו֙) לְבַדָּ֔הּ הִ֥וא שִׂמְלָתֹ֖ו לְעֹרֹ֑ו בַּמֶּ֣ה יִשְׁכָּ֔ב וְהָיָה֙ כִּֽי־יִצְעַ֣ק אֵלַ֔י וְשָׁמַעְתִּ֖י כִּֽי־חַנּ֥וּן אָֽנִי׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","אֱלֹהִ֖ים לֹ֣א תְקַלֵּ֑ל וְנָשִׂ֥יא בְעַמְּךָ֖ לֹ֥א תָאֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","מְלֵאָתְךָ֥ וְדִמְעֲךָ֖ לֹ֣א תְאַחֵ֑ר בְּכֹ֥ור בָּנֶ֖יךָ תִּתֶּן־לִּֽי׃ ");
INSERT INTO hbo_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","כֵּֽן־תַּעֲשֶׂ֥ה לְשֹׁרְךָ֖ לְצֹאנֶ֑ךָ שִׁבְעַ֤ת יָמִים֙ יִהְיֶ֣ה עִם־אִמֹּ֔ו בַּיֹּ֥ום הַשְּׁמִינִ֖י תִּתְּנֹו־לִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","וְאַנְשֵׁי־קֹ֖דֶשׁ תִּהְי֣וּן לִ֑י וּבָשָׂ֨ר בַּשָּׂדֶ֤ה טְרֵפָה֙ לֹ֣א תֹאכֵ֔לוּ לַכֶּ֖לֶב תַּשְׁלִכ֥וּן אֹתֹֽו׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","לֹ֥א תִשָּׂ֖א שֵׁ֣מַע שָׁ֑וְא אַל־תָּ֤שֶׁת יָֽדְךָ֙ עִם־רָשָׁ֔ע לִהְיֹ֖ת עֵ֥ד חָמָֽס׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","לֹֽא־תִהְיֶ֥ה אַחֲרֵֽי־רַבִּ֖ים לְרָעֹ֑ת וְלֹא־תַעֲנֶ֣ה עַל־רִ֗ב לִנְטֹ֛ת אַחֲרֵ֥י רַבִּ֖ים לְהַטֹּֽת׃ ");
INSERT INTO hbo_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","וְדָ֕ל לֹ֥א תֶהְדַּ֖ר בְּרִיבֹֽו׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","כִּ֣י תִפְגַּ֞ע שֹׁ֧ור אֹֽיִבְךָ֛ אֹ֥ו חֲמֹרֹ֖ו תֹּעֶ֑ה הָשֵׁ֥ב תְּשִׁיבֶ֖נּוּ לֹֽו׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","כִּֽי־תִרְאֶ֞ה חֲמֹ֣ור שֹׂנַאֲךָ֗ רֹבֵץ֙ תַּ֣חַת מַשָּׂאֹ֔ו וְחָדַלְתָּ֖ מֵעֲזֹ֣ב לֹ֑ו עָזֹ֥ב תַּעֲזֹ֖ב עִמֹּֽו׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","לֹ֥א תַטֶּ֛ה מִשְׁפַּ֥ט אֶבְיֹנְךָ֖ בְּרִיבֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","מִדְּבַר־שֶׁ֖קֶר תִּרְחָ֑ק וְנָקִ֤י וְצַדִּיק֙ אַֽל־תַּהֲרֹ֔ג כִּ֥י לֹא־אַצְדִּ֖יק רָשָֽׁע׃ ");
INSERT INTO hbo_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","וְשֹׁ֖חַד לֹ֣א תִקָּ֑ח כִּ֤י הַשֹּׁ֙חַד֙ יְעַוֵּ֣ר פִּקְחִ֔ים וִֽיסַלֵּ֖ף דִּבְרֵ֥י צַדִּיקִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","וְגֵ֖ר לֹ֣א תִלְחָ֑ץ וְאַתֶּ֗ם יְדַעְתֶּם֙ אֶת־נֶ֣פֶשׁ הַגֵּ֔ר כִּֽי־גֵרִ֥ים הֱיִיתֶ֖ם בְּאֶ֥רֶץ מִצְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","וְשֵׁ֥שׁ שָׁנִ֖ים תִּזְרַ֣ע אֶת־אַרְצֶ֑ךָ וְאָסַפְתָּ֖ אֶת־תְּבוּאָתָֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","וְהַשְּׁבִיעִ֞ת תִּשְׁמְטֶ֣נָּה וּנְטַשְׁתָּ֗הּ וְאָֽכְלוּ֙ אֶבְיֹנֵ֣י עַמֶּ֔ךָ וְיִתְרָ֕ם תֹּאכַ֖ל חַיַּ֣ת הַשָּׂדֶ֑ה כֵּֽן־תַּעֲשֶׂ֥ה לְכַרְמְךָ֖ לְזֵיתֶֽךָ׃ ");
INSERT INTO hbo_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","שֵׁ֤שֶׁת יָמִים֙ תַּעֲשֶׂ֣ה מַעֲשֶׂ֔יךָ וּבַיֹּ֥ום הַשְּׁבִיעִ֖י תִּשְׁבֹּ֑ת לְמַ֣עַן יָנ֗וּחַ שֹֽׁורְךָ֙ וַחֲמֹרֶ֔ךָ וְיִנָּפֵ֥שׁ בֶּן־אֲמָתְךָ֖ וְהַגֵּֽר׃ ");
INSERT INTO hbo_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","וּבְכֹ֛ל אֲשֶׁר־אָמַ֥רְתִּי אֲלֵיכֶ֖ם תִּשָּׁמֵ֑רוּ וְשֵׁ֨ם אֱלֹהִ֤ים אֲחֵרִים֙ לֹ֣א תַזְכִּ֔ירוּ לֹ֥א יִשָּׁמַ֖ע עַל־פִּֽיךָ׃ ");
INSERT INTO hbo_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","שָׁלֹ֣שׁ רְגָלִ֔ים תָּחֹ֥ג לִ֖י בַּשָּׁנָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","אֶת־חַ֣ג הַמַּצֹּות֮ תִּשְׁמֹר֒ שִׁבְעַ֣ת יָמִים֩ תֹּאכַ֨ל מַצֹּ֜ות כּֽ͏ַאֲשֶׁ֣ר צִוִּיתִ֗ךָ לְמֹועֵד֙ חֹ֣דֶשׁ הָֽאָבִ֔יב כִּי־בֹ֖ו יָצָ֣אתָ מִמִּצְרָ֑יִם וְלֹא־יֵרָא֥וּ פָנַ֖י רֵיקָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","וְחַ֤ג הַקָּצִיר֙ בִּכּוּרֵ֣י מַעֲשֶׂ֔יךָ אֲשֶׁ֥ר תִּזְרַ֖ע בַּשָּׂדֶ֑ה וְחַ֤ג הָֽאָסִף֙ בְּצֵ֣את הַשָּׁנָ֔ה בְּאָסְפְּךָ֥ אֶֽת־מַעֲשֶׂ֖יךָ מִן־הַשָּׂדֶֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","שָׁלֹ֥שׁ פְּעָמִ֖ים בַּשָּׁנָ֑ה יֵרָאֶה֙ כָּל־זְכ֣וּרְךָ֔ אֶל־פְּנֵ֖י הָאָדֹ֥ן ׀ יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","לֹֽא־תִזְבַּ֥ח עַל־חָמֵ֖ץ דַּם־זִבְחִ֑י וְלֹֽא־יָלִ֥ין חֵֽלֶב־חַגִּ֖י עַד־בֹּֽקֶר׃ ");
INSERT INTO hbo_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","רֵאשִׁ֗ית בִּכּוּרֵי֙ אַדְמָ֣תְךָ֔ תָּבִ֕יא בֵּ֖ית יְהוָ֣ה אֱלֹהֶ֑יךָ לֹֽא־תְבַשֵּׁ֥ל גְּדִ֖י בַּחֲלֵ֥ב אִמֹּֽו׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","הִנֵּ֨ה אָנֹכִ֜י שֹׁלֵ֤חַ מַלְאָךְ֙ לְפָנֶ֔יךָ לִשְׁמָרְךָ֖ בַּדָּ֑רֶךְ וְלַהֲבִ֣יאֲךָ֔ אֶל־הַמָּקֹ֖ום אֲשֶׁ֥ר הֲכִנֹֽתִי׃ ");
INSERT INTO hbo_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","הִשָּׁ֧מֶר מִפָּנָ֛יו וּשְׁמַ֥ע בְּקֹלֹ֖ו אַל־תַּמֵּ֣ר בֹּ֑ו כִּ֣י לֹ֤א יִשָּׂא֙ לְפִשְׁעֲכֶ֔ם כִּ֥י שְׁמִ֖י בְּקִרְבֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","כִּ֣י אִם־שָׁמֹ֤עַ תִּשְׁמַע֙ בְּקֹלֹ֔ו וְעָשִׂ֕יתָ כֹּ֖ל אֲשֶׁ֣ר אֲדַבֵּ֑ר וְאָֽיַבְתִּי֙ אֶת־אֹ֣יְבֶ֔יךָ וְצַרְתִּ֖י אֶת־צֹרְרֶֽיךָ׃ ");
INSERT INTO hbo_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","כִּֽי־יֵלֵ֣ךְ מַלְאָכִי֮ לְפָנֶיךָ֒ וֶהֱבִֽיאֲךָ֗ אֶל־הָֽאֱמֹרִי֙ וְהַ֣חִתִּ֔י וְהַפְּרִזִּי֙ וְהַֽכְּנַעֲנִ֔י הַחִוִּ֖י וְהַיְבוּסִ֑י וְהִכְחַדְתִּֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","לֹֽא־תִשְׁתַּחֲוֶ֤ה לֵאלֹֽהֵיהֶם֙ וְלֹ֣א תָֽעָבְדֵ֔ם וְלֹ֥א תַעֲשֶׂ֖ה כְּמַֽעֲשֵׂיהֶ֑ם כִּ֤י הָרֵס֙ תְּהָ֣רְסֵ֔ם וְשַׁבֵּ֥ר תְּשַׁבֵּ֖ר מַצֵּבֹתֵיהֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","וַעֲבַדְתֶּ֗ם אֵ֚ת יְהוָ֣ה אֱלֹֽהֵיכֶ֔ם וּבֵרַ֥ךְ אֶֽת־לַחְמְךָ֖ וְאֶת־מֵימֶ֑יךָ וַהֲסִרֹתִ֥י מַחֲלָ֖ה מִקִּרְבֶּֽךָ׃ ");
INSERT INTO hbo_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","לֹ֥א תִהְיֶ֛ה מְשַׁכֵּלָ֥ה וַעֲקָרָ֖ה בְּאַרְצֶ֑ךָ אֶת־מִסְפַּ֥ר יָמֶ֖יךָ אֲמַלֵּֽא׃ ");
INSERT INTO hbo_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","אֶת־אֵֽימָתִי֙ אֲשַׁלַּ֣ח לְפָנֶ֔יךָ וְהַמֹּתִי֙ אֶת־כָּל־הָעָ֔ם אֲשֶׁ֥ר תָּבֹ֖א בָּהֶ֑ם וְנָתַתִּ֧י אֶת־כָּל־אֹיְבֶ֛יךָ אֵלֶ֖יךָ עֹֽרֶף׃ ");
INSERT INTO hbo_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","וְשָׁלַחְתִּ֥י אֶת־הַצִּרְעָ֖ה לְפָנֶ֑יךָ וְגֵרְשָׁ֗ה אֶת־הַחִוִּ֧י אֶת־הַֽכְּנַעֲנִ֛י וְאֶת־הַחִתִּ֖י מִלְּפָנֶֽיךָ׃ ");
INSERT INTO hbo_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","לֹ֧א אֲגָרְשֶׁ֛נּוּ מִפָּנֶ֖יךָ בְּשָׁנָ֣ה אֶחָ֑ת פֶּן־תִּהְיֶ֤ה הָאָ֙רֶץ֙ שְׁמָמָ֔ה וְרַבָּ֥ה עָלֶ֖יךָ חַיַּ֥ת הַשָּׂדֶֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","מְעַ֥ט מְעַ֛ט אֲגָרְשֶׁ֖נּוּ מִפָּנֶ֑יךָ עַ֚ד אֲשֶׁ֣ר תִּפְרֶ֔ה וְנָחַלְתָּ֖ אֶת־הָאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","וְשַׁתִּ֣י אֶת־גְּבֻלְךָ֗ מִיַּם־סוּף֙ וְעַד־יָ֣ם פְּלִשְׁתִּ֔ים וּמִמִּדְבָּ֖ר עַד־הַנָּהָ֑ר כִּ֣י ׀ אֶתֵּ֣ן בְּיֶדְכֶ֗ם אֵ֚ת יֹשְׁבֵ֣י הָאָ֔רֶץ וְגֵרַשְׁתָּ֖מֹו מִפָּנֶֽיךָ׃ ");
INSERT INTO hbo_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","לֹא־תִכְרֹ֥ת לָהֶ֛ם וְלֵאלֹֽהֵיהֶ֖ם בְּרִֽית׃ ");
INSERT INTO hbo_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","לֹ֤א יֵשְׁבוּ֙ בְּאַרְצְךָ֔ פֶּן־יַחֲטִ֥יאוּ אֹתְךָ֖ לִ֑י כִּ֤י תַעֲבֹד֙ אֶת־אֱלֹ֣הֵיהֶ֔ם כִּֽי־יִהְיֶ֥ה לְךָ֖ לְמֹוקֵֽשׁ׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","וְאֶל־מֹשֶׁ֨ה אָמַ֜ר עֲלֵ֣ה אֶל־יְהוָ֗ה אַתָּה֙ וְאַהֲרֹן֙ נָדָ֣ב וַאֲבִיה֔וּא וְשִׁבְעִ֖ים מִזִּקְנֵ֣י יִשְׂרָאֵ֑ל וְהִשְׁתַּחֲוִיתֶ֖ם מֵרָחֹֽק׃ ");
INSERT INTO hbo_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","וְנִגַּ֨שׁ מֹשֶׁ֤ה לְבַדֹּו֙ אֶל־יְהוָ֔ה וְהֵ֖ם לֹ֣א יִגָּ֑שׁוּ וְהָעָ֕ם לֹ֥א יַעֲל֖וּ עִמֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","וַיָּבֹ֣א מֹשֶׁ֗ה וַיְסַפֵּ֤ר לָעָם֙ אֵ֚ת כָּל־דִּבְרֵ֣י יְהוָ֔ה וְאֵ֖ת כָּל־הַמִּשְׁפָּטִ֑ים וַיַּ֨עַן כָּל־הָעָ֜ם קֹ֤ול אֶחָד֙ וַיֹּ֣אמְר֔וּ כָּל־הַדְּבָרִ֛ים אֲשֶׁר־דִּבֶּ֥ר יְהוָ֖ה נַעֲשֶֽׂה׃ ");
INSERT INTO hbo_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","וַיִּכְתֹּ֣ב מֹשֶׁ֗ה אֵ֚ת כָּל־דִּבְרֵ֣י יְהוָ֔ה וַיַּשְׁכֵּ֣ם בַּבֹּ֔קֶר וַיִּ֥בֶן מִזְבֵּ֖חַ תַּ֣חַת הָהָ֑ר וּשְׁתֵּ֤ים עֶשְׂרֵה֙ מַצֵּבָ֔ה לִשְׁנֵ֥ים עָשָׂ֖ר שִׁבְטֵ֥י יִשְׂרָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","וַיִּשְׁלַ֗ח אֶֽת־נַעֲרֵי֙ בְּנֵ֣י יִשְׂרָאֵ֔ל וַיּֽ͏ַעֲל֖וּ עֹלֹ֑ת וַֽיִּזְבְּח֞וּ זְבָחִ֧ים שְׁלָמִ֛ים לַיהוָ֖ה פָּרִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","וַיִּקַּ֤ח מֹשֶׁה֙ חֲצִ֣י הַדָּ֔ם וַיָּ֖שֶׂם בָּאַגָּנֹ֑ת וַחֲצִ֣י הַדָּ֔ם זָרַ֖ק עַל־הַמִּזְבֵּֽחַ׃ ");
INSERT INTO hbo_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","וַיִּקַּח֙ סֵ֣פֶר הַבְּרִ֔ית וַיִּקְרָ֖א בְּאָזְנֵ֣י הָעָ֑ם וַיֹּ֣אמְר֔וּ כֹּ֛ל אֲשֶׁר־דִּבֶּ֥ר יְהוָ֖ה נַעֲשֶׂ֥ה וְנִשְׁמָֽע׃ ");
INSERT INTO hbo_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","וַיִּקַּ֤ח מֹשֶׁה֙ אֶת־הַדָּ֔ם וַיִּזְרֹ֖ק עַל־הָעָ֑ם וַיֹּ֗אמֶר הִנֵּ֤ה דַֽם־הַבְּרִית֙ אֲשֶׁ֨ר כָּרַ֤ת יְהוָה֙ עִמָּכֶ֔ם עַ֥ל כָּל־הַדְּבָרִ֖ים הָאֵֽלֶּה׃ ");
INSERT INTO hbo_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","וַיַּ֥עַל מֹשֶׁ֖ה וְאַהֲרֹ֑ן נָדָב֙ וַאֲבִיה֔וּא וְשִׁבְעִ֖ים מִזִּקְנֵ֥י יִשְׂרָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","וַיִּרְא֕וּ אֵ֖ת אֱלֹהֵ֣י יִשְׂרָאֵ֑ל וְתַ֣חַת רַגְלָ֗יו כְּמַעֲשֵׂה֙ לִבְנַ֣ת הַסַּפִּ֔יר וּכְעֶ֥צֶם הַשָּׁמַ֖יִם לָטֹֽהַר׃ ");
INSERT INTO hbo_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","וְאֶל־אֲצִילֵי֙ בְּנֵ֣י יִשְׂרָאֵ֔ל לֹ֥א שָׁלַ֖ח יָדֹ֑ו וַֽיֶּחֱזוּ֙ אֶת־הָ֣אֱלֹהִ֔ים וַיֹּאכְל֖וּ וַיִּשְׁתּֽוּ׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","וַיֹּ֨אמֶר יְהוָ֜ה אֶל־מֹשֶׁ֗ה עֲלֵ֥ה אֵלַ֛י הָהָ֖רָה וֶהְיֵה־שָׁ֑ם וְאֶתְּנָ֨ה לְךָ֜ אֶת־לֻחֹ֣ת הָאֶ֗בֶן וְהַתֹּורָה֙ וְהַמִּצְוָ֔ה אֲשֶׁ֥ר כָּתַ֖בְתִּי לְהֹורֹתָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","וַיָּ֣קָם מֹשֶׁ֔ה וִיהֹושֻׁ֖עַ מְשָׁרְתֹ֑ו וַיַּ֥עַל מֹשֶׁ֖ה אֶל־הַ֥ר הָאֱלֹהִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","וְאֶל־הַזְּקֵנִ֤ים אָמַר֙ שְׁבוּ־לָ֣נוּ בָזֶ֔ה עַ֥ד אֲשֶׁר־נָשׁ֖וּב אֲלֵיכֶ֑ם וְהִנֵּ֨ה אַהֲרֹ֤ן וְחוּר֙ עִמָּכֶ֔ם מִי־בַ֥עַל דְּבָרִ֖ים יִגַּ֥שׁ אֲלֵהֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","וַיַּ֥עַל מֹשֶׁ֖ה אֶל־הָהָ֑ר וַיְכַ֥ס הֶעָנָ֖ן אֶת־הָהָֽר׃ ");
INSERT INTO hbo_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","וַיִּשְׁכֹּ֤ן כְּבֹוד־יְהוָה֙ עַל־הַ֣ר סִינַ֔י וַיְכַסֵּ֥הוּ הֶעָנָ֖ן שֵׁ֣שֶׁת יָמִ֑ים וַיִּקְרָ֧א אֶל־מֹשֶׁ֛ה בַּיֹּ֥ום הַשְּׁבִיעִ֖י מִתֹּ֥וךְ הֶעָנָֽן׃ ");
INSERT INTO hbo_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","וּמַרְאֵה֙ כְּבֹ֣וד יְהוָ֔ה כְּאֵ֥שׁ אֹכֶ֖לֶת בְּרֹ֣אשׁ הָהָ֑ר לְעֵינֵ֖י בְּנֵ֥י יִשְׂרָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","וַיָּבֹ֥א מֹשֶׁ֛ה בְּתֹ֥וךְ הֶעָנָ֖ן וַיַּ֣עַל אֶל־הָהָ֑ר וַיְהִ֤י מֹשֶׁה֙ בָּהָ֔ר אַרְבָּעִ֣ים יֹ֔ום וְאַרְבָּעִ֖ים לָֽיְלָה׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","דַּבֵּר֙ אֶל־בְּנֵ֣י יִשְׂרָאֵ֔ל וְיִקְחוּ־לִ֖י תְּרוּמָ֑ה מֵאֵ֤ת כָּל־אִישׁ֙ אֲשֶׁ֣ר יִדְּבֶ֣נּוּ לִבֹּ֔ו תִּקְח֖וּ אֶת־תְּרוּמָתִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","וְזֹאת֙ הַתְּרוּמָ֔ה אֲשֶׁ֥ר תִּקְח֖וּ מֵאִתָּ֑ם זָהָ֥ב וָכֶ֖סֶף וּנְחֹֽשֶׁת׃ ");
INSERT INTO hbo_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","וּתְכֵ֧לֶת וְאַרְגָּמָ֛ן וְתֹולַ֥עַת שָׁנִ֖י וְשֵׁ֥שׁ וְעִזִּֽים׃ ");
INSERT INTO hbo_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","וְעֹרֹ֨ת אֵילִ֧ם מְאָדָּמִ֛ים וְעֹרֹ֥ת תְּחָשִׁ֖ים וַעֲצֵ֥י שִׁטִּֽים׃ ");
INSERT INTO hbo_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","שֶׁ֖מֶן לַמָּאֹ֑ר בְּשָׂמִים֙ לְשֶׁ֣מֶן הַמִּשְׁחָ֔ה וְלִקְטֹ֖רֶת הַסַּמִּֽים׃ ");
INSERT INTO hbo_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","אַבְנֵי־שֹׁ֕הַם וְאַבְנֵ֖י מִלֻּאִ֑ים לָאֵפֹ֖ד וְלַחֹֽשֶׁן׃ ");
INSERT INTO hbo_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","וְעָ֥שׂוּ לִ֖י מִקְדָּ֑שׁ וְשָׁכַנְתִּ֖י בְּתֹוכָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","כְּכֹ֗ל אֲשֶׁ֤ר אֲנִי֙ מַרְאֶ֣ה אֹותְךָ֔ אֵ֚ת תַּבְנִ֣ית הַמִּשְׁכָּ֔ן וְאֵ֖ת תַּבְנִ֣ית כָּל־כֵּלָ֑יו וְכֵ֖ן תַּעֲשֽׂוּ׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","וְעָשׂ֥וּ אֲרֹ֖ון עֲצֵ֣י שִׁטִּ֑ים אַמָּתַ֨יִם וָחֵ֜צִי אָרְכֹּ֗ו וְאַמָּ֤ה וָחֵ֙צִי֙ רָחְבֹּ֔ו וְאַמָּ֥ה וָחֵ֖צִי קֹמָתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","וְצִפִּיתָ֤ אֹתֹו֙ זָהָ֣ב טָהֹ֔ור מִבַּ֥יִת וּמִח֖וּץ תְּצַפֶּ֑נּוּ וְעָשִׂ֧יתָ עָלָ֛יו זֵ֥ר זָהָ֖ב סָבִֽיב׃ ");
INSERT INTO hbo_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","וְיָצַ֣קְתָּ לֹּ֗ו אַרְבַּע֙ טַבְּעֹ֣ת זָהָ֔ב וְנָ֣תַתָּ֔ה עַ֖ל אַרְבַּ֣ע פַּעֲמֹתָ֑יו וּשְׁתֵּ֣י טַבָּעֹ֗ת עַל־צַלְעֹו֙ הָֽאֶחָ֔ת וּשְׁתֵּי֙ טַבָּעֹ֔ת עַל־צַלְעֹ֖ו הַשֵּׁנִֽית׃ ");
INSERT INTO hbo_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","וְעָשִׂ֥יתָ בַדֵּ֖י עֲצֵ֣י שִׁטִּ֑ים וְצִפִּיתָ֥ אֹתָ֖ם זָהָֽב׃ ");
INSERT INTO hbo_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","וְהֵבֵאתָ֤ אֶת־הַבַּדִּים֙ בַּטַּבָּעֹ֔ת עַ֖ל צַלְעֹ֣ת הָאָרֹ֑ן לָשֵׂ֥את אֶת־הָאָרֹ֖ן בָּהֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","בְּטַבְּעֹת֙ הָאָרֹ֔ן יִהְי֖וּ הַבַּדִּ֑ים לֹ֥א יָסֻ֖רוּ מִמֶּֽנּוּ׃ ");
INSERT INTO hbo_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","וְנָתַתָּ֖ אֶל־הָאָרֹ֑ן אֵ֚ת הָעֵדֻ֔ת אֲשֶׁ֥ר אֶתֵּ֖ן אֵלֶֽיךָ׃ ");
INSERT INTO hbo_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","וְעָשִׂ֥יתָ כַפֹּ֖רֶת זָהָ֣ב טָהֹ֑ור אַמָּתַ֤יִם וָחֵ֙צִי֙ אָרְכָּ֔הּ וְאַמָּ֥ה וָחֵ֖צִי רָחְבָּֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","וְעָשִׂ֛יתָ שְׁנַ֥יִם כְּרֻבִ֖ים זָהָ֑ב מִקְשָׁה֙ תַּעֲשֶׂ֣ה אֹתָ֔ם מִשְּׁנֵ֖י קְצֹ֥ות הַכַּפֹּֽרֶת׃ ");
INSERT INTO hbo_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","וַ֠עֲשֵׂה כְּר֨וּב אֶחָ֤ד מִקָּצָה֙ מִזֶּ֔ה וּכְרוּב־אֶחָ֥ד מִקָּצָ֖ה מִזֶּ֑ה מִן־הַכַּפֹּ֛רֶת תַּעֲשׂ֥וּ אֶת־הַכְּרֻבִ֖ים עַל־שְׁנֵ֥י קְצֹותָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","וְהָי֣וּ הַכְּרֻבִים֩ פֹּרְשֵׂ֨י כְנָפַ֜יִם לְמַ֗עְלָה סֹכְכִ֤ים בְּכַנְפֵיהֶם֙ עַל־הַכַּפֹּ֔רֶת וּפְנֵיהֶ֖ם אִ֣ישׁ אֶל־אָחִ֑יו אֶל־הַכַּפֹּ֔רֶת יִהְי֖וּ פְּנֵ֥י הַכְּרֻבִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","וְנָתַתָּ֧ אֶת־הַכַּפֹּ֛רֶת עַל־הָאָרֹ֖ן מִלְמָ֑עְלָה וְאֶל־הָ֣אָרֹ֔ן תִּתֵּן֙ אֶת־הָ֣עֵדֻ֔ת אֲשֶׁ֥ר אֶתֵּ֖ן אֵלֶֽיךָ׃ ");
INSERT INTO hbo_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","וְנֹועַדְתִּ֣י לְךָ֮ שָׁם֒ וְדִבַּרְתִּ֨י אִתְּךָ֜ מֵעַ֣ל הַכַּפֹּ֗רֶת מִבֵּין֙ שְׁנֵ֣י הַכְּרֻבִ֔ים אֲשֶׁ֖ר עַל־אֲרֹ֣ן הָעֵדֻ֑ת אֵ֣ת כָּל־אֲשֶׁ֧ר אֲצַוֶּ֛ה אֹותְךָ֖ אֶל־בְּנֵ֥י יִשְׂרָאֵֽל׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","וְעָשִׂ֥יתָ שֻׁלְחָ֖ן עֲצֵ֣י שִׁטִּ֑ים אַמָּתַ֤יִם אָרְכֹּו֙ וְאַמָּ֣ה רָחְבֹּ֔ו וְאַמָּ֥ה וָחֵ֖צִי קֹמָתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","וְצִפִּיתָ֥ אֹתֹ֖ו זָהָ֣ב טָהֹ֑ור וְעָשִׂ֥יתָ לֹּ֛ו זֵ֥ר זָהָ֖ב סָבִֽיב׃ ");
INSERT INTO hbo_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","וְעָשִׂ֨יתָ לֹּ֥ו מִסְגֶּ֛רֶת טֹ֖פַח סָבִ֑יב וְעָשִׂ֧יתָ זֵר־זָהָ֛ב לְמִסְגַּרְתֹּ֖ו סָבִֽיב׃ ");
INSERT INTO hbo_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","וְעָשִׂ֣יתָ לֹּ֔ו אַרְבַּ֖ע טַבְּעֹ֣ת זָהָ֑ב וְנָתַתָּ֙ אֶת־הַטַּבָּעֹ֔ת עַ֚ל אַרְבַּ֣ע הַפֵּאֹ֔ת אֲשֶׁ֖ר לְאַרְבַּ֥ע רַגְלָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","לְעֻמַּת֙ הַמִּסְגֶּ֔רֶת תִּהְיֶ֖יןָ הַטַּבָּעֹ֑ת לְבָתִּ֣ים לְבַדִּ֔ים לָשֵׂ֖את אֶת־הַשֻּׁלְחָֽן׃ ");
INSERT INTO hbo_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","וְעָשִׂ֤יתָ אֶת־הַבַּדִּים֙ עֲצֵ֣י שִׁטִּ֔ים וְצִפִּיתָ֥ אֹתָ֖ם זָהָ֑ב וְנִשָּׂא־בָ֖ם אֶת־הַשֻּׁלְחָֽן׃ ");
INSERT INTO hbo_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","וְעָשִׂ֨יתָ קְּעָרֹתָ֜יו וְכַפֹּתָ֗יו וּקְשֹׂותָיו֙ וּמְנַקִּיֹּתָ֔יו אֲשֶׁ֥ר יֻסַּ֖ךְ בָּהֵ֑ן זָהָ֥ב טָהֹ֖ור תַּעֲשֶׂ֥ה אֹתָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","וְנָתַתָּ֧ עַֽל־הַשֻּׁלְחָ֛ן לֶ֥חֶם פָּנִ֖ים לְפָנַ֥י תָּמִֽיד׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","וְעָשִׂ֥יתָ מְנֹרַ֖ת זָהָ֣ב טָהֹ֑ור מִקְשָׁ֞ה תֵּעָשֶׂ֤ה הַמְּנֹורָה֙ יְרֵכָ֣הּ וְקָנָ֔הּ גְּבִיעֶ֛יהָ כַּפְתֹּרֶ֥יהָ וּפְרָחֶ֖יהָ מִמֶּ֥נָּה יִהְיֽוּ׃ ");
INSERT INTO hbo_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","וְשִׁשָּׁ֣ה קָנִ֔ים יֹצְאִ֖ים מִצִּדֶּ֑יהָ שְׁלֹשָׁ֣ה ׀ קְנֵ֣י מְנֹרָ֗ה מִצִּדָּהּ֙ הָאֶחָ֔ד וּשְׁלֹשָׁה֙ קְנֵ֣י מְנֹרָ֔ה מִצִּדָּ֖הּ הַשֵּׁנִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","שְׁלֹשָׁ֣ה גְ֠בִעִים מְֽשֻׁקָּדִ֞ים בַּקָּנֶ֣ה הָאֶחָד֮ כַּפְתֹּ֣ר וָפֶרַח֒ וּשְׁלֹשָׁ֣ה גְבִעִ֗ים מְשֻׁקָּדִ֛ים בַּקָּנֶ֥ה הָאֶחָ֖ד כַּפְתֹּ֣ר וָפָ֑רַח כֵּ֚ן לְשֵׁ֣שֶׁת הַקָּנִ֔ים הַיֹּצְאִ֖ים מִן־הַמְּנֹרָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","וּבַמְּנֹרָ֖ה אַרְבָּעָ֣ה גְבִעִ֑ים מְשֻׁקָּדִ֔ים כַּפְתֹּרֶ֖יהָ וּפְרָחֶֽיהָ׃ ");
INSERT INTO hbo_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","וְכַפְתֹּ֡ר תַּחַת֩ שְׁנֵ֨י הַקָּנִ֜ים מִמֶּ֗נָּה וְכַפְתֹּר֙ תַּ֣חַת שְׁנֵ֤י הַקָּנִים֙ מִמֶּ֔נָּה וְכַפְתֹּ֕ר תַּחַת־שְׁנֵ֥י הַקָּנִ֖ים מִמֶּ֑נָּה לְשֵׁ֙שֶׁת֙ הַקָּנִ֔ים הַיֹּצְאִ֖ים מִן־הַמְּנֹרָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","כַּפְתֹּרֵיהֶ֥ם וּקְנֹתָ֖ם מִמֶּ֣נָּה יִהְי֑וּ כֻּלָּ֛הּ מִקְשָׁ֥ה אַחַ֖ת זָהָ֥ב טָהֹֽור׃ ");
INSERT INTO hbo_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","וְעָשִׂ֥יתָ אֶת־נֵרֹתֶ֖יהָ שִׁבְעָ֑ה וְהֶֽעֱלָה֙ אֶת־נֵ֣רֹתֶ֔יהָ וְהֵאִ֖יר עַל־עֵ֥בֶר פָּנֶֽיהָ׃ ");
INSERT INTO hbo_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","וּמַלְקָחֶ֥יהָ וּמַחְתֹּתֶ֖יהָ זָהָ֥ב טָהֹֽור׃ ");
INSERT INTO hbo_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","כִּכָּ֛ר זָהָ֥ב טָהֹ֖ור יַעֲשֶׂ֣ה אֹתָ֑הּ אֵ֥ת כָּל־הַכֵּלִ֖ים הָאֵֽלֶּה׃ ");
INSERT INTO hbo_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","וּרְאֵ֖ה וַעֲשֵׂ֑ה בְּתַ֨בְנִיתָ֔ם אֲשֶׁר־אַתָּ֥ה מָרְאֶ֖ה בָּהָֽר׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","וְאֶת־הַמִּשְׁכָּ֥ן תַּעֲשֶׂ֖ה עֶ֣שֶׂר יְרִיעֹ֑ת שֵׁ֣שׁ מָשְׁזָ֗ר וּתְכֵ֤לֶת וְאַרְגָּמָן֙ וְתֹלַ֣עַת שָׁנִ֔י כְּרֻבִ֛ים מַעֲשֵׂ֥ה חֹשֵׁ֖ב תַּעֲשֶׂ֥ה אֹתָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","אֹ֣רֶךְ ׀ הַיְרִיעָ֣ה הָֽאַחַ֗ת שְׁמֹנֶ֤ה וְעֶשְׂרִים֙ בָּֽאַמָּ֔ה וְרֹ֙חַב֙ אַרְבַּ֣ע בָּאַמָּ֔ה הַיְרִיעָ֖ה הָאֶחָ֑ת מִדָּ֥ה אַחַ֖ת לְכָל־הַיְרִיעֹֽת׃ ");
INSERT INTO hbo_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","חֲמֵ֣שׁ הַיְרִיעֹ֗ת תִּֽהְיֶ֙יןָ֙ חֹֽבְרֹ֔ת אִשָּׁ֖ה אֶל־אֲחֹתָ֑הּ וְחָמֵ֤שׁ יְרִיעֹת֙ חֹֽבְרֹ֔ת אִשָּׁ֖ה אֶל־אֲחֹתָֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","וְעָשִׂ֜יתָ לֻֽלְאֹ֣ת תְּכֵ֗לֶת עַ֣ל שְׂפַ֤ת הַיְרִיעָה֙ הָאֶחָ֔ת מִקָּצָ֖ה בַּחֹבָ֑רֶת וְכֵ֤ן תַּעֲשֶׂה֙ בִּשְׂפַ֣ת הַיְרִיעָ֔ה הַקִּ֣יצֹונָ֔ה בַּמַּחְבֶּ֖רֶת הַשֵּׁנִֽית׃ ");
INSERT INTO hbo_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","חֲמִשִּׁ֣ים לֻֽלָאֹ֗ת תַּעֲשֶׂה֮ בַּיְרִיעָ֣ה הָאֶחָת֒ וַחֲמִשִּׁ֣ים לֻֽלָאֹ֗ת תַּעֲשֶׂה֙ בִּקְצֵ֣ה הַיְרִיעָ֔ה אֲשֶׁ֖ר בַּמַּחְבֶּ֣רֶת הַשֵּׁנִ֑ית מַקְבִּילֹת֙ הַלֻּ֣לָאֹ֔ת אִשָּׁ֖ה אֶל־אֲחֹתָֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","וְעָשִׂ֕יתָ חֲמִשִּׁ֖ים קַרְסֵ֣י זָהָ֑ב וְחִבַּרְתָּ֙ אֶת־הַיְרִיעֹ֜ת אִשָּׁ֤ה אֶל־אֲחֹתָהּ֙ בַּקְּרָסִ֔ים וְהָיָ֥ה הַמִּשְׁכָּ֖ן אֶחָֽד׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","וְעָשִׂ֙יתָ֙ יְרִיעֹ֣ת עִזִּ֔ים לְאֹ֖הֶל עַל־הַמִּשְׁכָּ֑ן עַשְׁתֵּי־עֶשְׂרֵ֥ה יְרִיעֹ֖ת תַּעֲשֶׂ֥ה אֹתָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","אֹ֣רֶךְ ׀ הַיְרִיעָ֣ה הָֽאַחַ֗ת שְׁלֹשִׁים֙ בָּֽאַמָּ֔ה וְרֹ֙חַב֙ אַרְבַּ֣ע בָּאַמָּ֔ה הַיְרִיעָ֖ה הָאֶחָ֑ת מִדָּ֣ה אַחַ֔ת לְעַשְׁתֵּ֥י עֶשְׂרֵ֖ה יְרִיעֹֽת׃ ");
INSERT INTO hbo_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","וְחִבַּרְתָּ֞ אֶת־חֲמֵ֤שׁ הַיְרִיעֹת֙ לְבָ֔ד וְאֶת־שֵׁ֥שׁ הַיְרִיעֹ֖ת לְבָ֑ד וְכָפַלְתָּ֙ אֶת־הַיְרִיעָ֣ה הַשִּׁשִּׁ֔ית אֶל־מ֖וּל פְּנֵ֥י הָאֹֽהֶל׃ ");
INSERT INTO hbo_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","וְעָשִׂ֜יתָ חֲמִשִּׁ֣ים לֻֽלָאֹ֗ת עַ֣ל שְׂפַ֤ת הַיְרִיעָה֙ הָֽאֶחָ֔ת הַקִּיצֹנָ֖ה בַּחֹבָ֑רֶת וַחֲמִשִּׁ֣ים לֻֽלָאֹ֗ת עַ֚ל שְׂפַ֣ת הַיְרִיעָ֔ה הַחֹבֶ֖רֶת הַשֵּׁנִֽית׃ ");
INSERT INTO hbo_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","וְעָשִׂ֛יתָ קַרְסֵ֥י נְחֹ֖שֶׁת חֲמִשִּׁ֑ים וְהֵבֵאתָ֤ אֶת־הַקְּרָסִים֙ בַּלֻּ֣לָאֹ֔ת וְחִבַּרְתָּ֥ אֶת־הָאֹ֖הֶל וְהָיָ֥ה אֶחָֽד׃ ");
INSERT INTO hbo_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","וְסֶ֙רַח֙ הָעֹדֵ֔ף בִּירִיעֹ֖ת הָאֹ֑הֶל חֲצִ֤י הַיְרִיעָה֙ הָעֹדֶ֔פֶת תִּסְרַ֕ח עַ֖ל אֲחֹרֵ֥י הַמִּשְׁכָּֽן׃ ");
INSERT INTO hbo_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","וְהָאַמָּ֨ה מִזֶּ֜ה וְהָאַמָּ֤ה מִזֶּה֙ בָּעֹדֵ֔ף בְּאֹ֖רֶךְ יְרִיעֹ֣ת הָאֹ֑הֶל יִהְיֶ֨ה סָר֜וּחַ עַל־צִדֵּ֧י הַמִּשְׁכָּ֛ן מִזֶּ֥ה וּמִזֶּ֖ה לְכַסֹּתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","וְעָשִׂ֤יתָ מִכְסֶה֙ לָאֹ֔הֶל עֹרֹ֥ת אֵילִ֖ם מְאָדָּמִ֑ים וּמִכְסֵ֛ה עֹרֹ֥ת תְּחָשִׁ֖ים מִלְמָֽעְלָה׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","וְעָשִׂ֥יתָ אֶת־הַקְּרָשִׁ֖ים לַמִּשְׁכָּ֑ן עֲצֵ֥י שִׁטִּ֖ים עֹמְדִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","עֶ֥שֶׂר אַמֹּ֖ות אֹ֣רֶךְ הַקָּ֑רֶשׁ וְאַמָּה֙ וַחֲצִ֣י הָֽאַמָּ֔ה רֹ֖חַב הַקֶּ֥רֶשׁ הָאֶחָֽד׃ ");
INSERT INTO hbo_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","שְׁתֵּ֣י יָדֹ֗ות לַקֶּ֙רֶשׁ֙ הָאֶחָ֔ד מְשֻׁלָּבֹ֔ת אִשָּׁ֖ה אֶל־אֲחֹתָ֑הּ כֵּ֣ן תַּעֲשֶׂ֔ה לְכֹ֖ל קַרְשֵׁ֥י הַמִּשְׁכָּֽן׃ ");
INSERT INTO hbo_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","וְעָשִׂ֥יתָ אֶת־הַקְּרָשִׁ֖ים לַמִּשְׁכָּ֑ן עֶשְׂרִ֣ים קֶ֔רֶשׁ לִפְאַ֖ת נֶ֥גְבָּה תֵימָֽנָה׃ ");
INSERT INTO hbo_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","וְאַרְבָּעִים֙ אַדְנֵי־כֶ֔סֶף תַּעֲשֶׂ֕ה תַּ֖חַת עֶשְׂרִ֣ים הַקָּ֑רֶשׁ שְׁנֵ֨י אֲדָנִ֜ים תַּֽחַת־הַקֶּ֤רֶשׁ הָאֶחָד֙ לִשְׁתֵּ֣י יְדֹתָ֔יו וּשְׁנֵ֧י אֲדָנִ֛ים תַּֽחַת־הַקֶּ֥רֶשׁ הָאֶחָ֖ד לִשְׁתֵּ֥י יְדֹתָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","וּלְצֶ֧לַע הַמִּשְׁכָּ֛ן הַשֵּׁנִ֖ית לִפְאַ֣ת צָפֹ֑ון עֶשְׂרִ֖ים קָֽרֶשׁ׃ ");
INSERT INTO hbo_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","וְאַרְבָּעִ֥ים אַדְנֵיהֶ֖ם כָּ֑סֶף שְׁנֵ֣י אֲדָנִ֗ים תַּ֚חַת הַקֶּ֣רֶשׁ הָֽאֶחָ֔ד וּשְׁנֵ֣י אֲדָנִ֔ים תַּ֖חַת הַקֶּ֥רֶשׁ הָאֶחָֽד׃ ");
INSERT INTO hbo_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","וּֽלְיַרְכְּתֵ֥י הַמִּשְׁכָּ֖ן יָ֑מָּה תַּעֲשֶׂ֖ה שִׁשָּׁ֥ה קְרָשִֽׁים׃ ");
INSERT INTO hbo_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","וּשְׁנֵ֤י קְרָשִׁים֙ תַּעֲשֶׂ֔ה לִמְקֻצְעֹ֖ת הַמִּשְׁכָּ֑ן בַּיַּרְכָתָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","וְיִֽהְי֣וּ תֹֽאֲמִים֮ מִלְּמַטָּה֒ וְיַחְדָּ֗ו יִהְי֤וּ תַמִּים֙ עַל־רֹאשֹׁ֔ו אֶל־הַטַּבַּ֖עַת הָאֶחָ֑ת כֵּ֚ן יִהְיֶ֣ה לִשְׁנֵיהֶ֔ם לִשְׁנֵ֥י הַמִּקְצֹעֹ֖ת יִהְיֽוּ׃ ");
INSERT INTO hbo_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","וְהָיוּ֙ שְׁמֹנָ֣ה קְרָשִׁ֔ים וְאַדְנֵיהֶ֣ם כֶּ֔סֶף שִׁשָּׁ֥ה עָשָׂ֖ר אֲדָנִ֑ים שְׁנֵ֣י אֲדָנִ֗ים תַּ֚חַת הַקֶּ֣רֶשׁ הָאֶחָ֔ד וּשְׁנֵ֣י אֲדָנִ֔ים תַּ֖חַת הַקֶּ֥רֶשׁ הָאֶחָֽד׃ ");
INSERT INTO hbo_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","וְעָשִׂ֥יתָ בְרִיחִ֖ם עֲצֵ֣י שִׁטִּ֑ים חֲמִשָּׁ֕ה לְקַרְשֵׁ֥י צֶֽלַע־הַמִּשְׁכָּ֖ן הָאֶחָֽד׃ ");
INSERT INTO hbo_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","וַחֲמִשָּׁ֣ה בְרִיחִ֔ם לְקַרְשֵׁ֥י צֶֽלַע־הַמִּשְׁכָּ֖ן הַשֵּׁנִ֑ית וַחֲמִשָּׁ֣ה בְרִיחִ֗ם לְקַרְשֵׁי֙ צֶ֣לַע הַמִּשְׁכָּ֔ן לַיַּרְכָתַ֖יִם יָֽמָּה׃ ");
INSERT INTO hbo_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","וְהַבְּרִ֥יחַ הַתִּיכֹ֖ן בְּתֹ֣וךְ הַקְּרָשִׁ֑ים מַבְרִ֕חַ מִן־הַקָּצֶ֖ה אֶל־הַקָּצֶֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","וְֽאֶת־הַקְּרָשִׁ֞ים תְּצַפֶּ֣ה זָהָ֗ב וְאֶת־טַבְּעֹֽתֵיהֶם֙ תַּעֲשֶׂ֣ה זָהָ֔ב בָּתִּ֖ים לַבְּרִיחִ֑ם וְצִפִּיתָ֥ אֶת־הַבְּרִיחִ֖ם זָהָֽב׃ ");
INSERT INTO hbo_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","וַהֲקֵמֹתָ֖ אֶת־הַמִּשְׁכָּ֑ן כְּמִ֨שְׁפָּטֹ֔ו אֲשֶׁ֥ר הָרְאֵ֖יתָ בָּהָֽר׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","וְעָשִׂ֣יתָ פָרֹ֗כֶת תְּכֵ֧לֶת וְאַרְגָּמָ֛ן וְתֹולַ֥עַת שָׁנִ֖י וְשֵׁ֣שׁ מָשְׁזָ֑ר מַעֲשֵׂ֥ה חֹשֵׁ֛ב יַעֲשֶׂ֥ה אֹתָ֖הּ כְּרֻבִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","וְנָתַתָּ֣ה אֹתָ֗הּ עַל־אַרְבָּעָה֙ עַמּוּדֵ֣י שִׁטִּ֔ים מְצֻפִּ֣ים זָהָ֔ב וָוֵיהֶ֖ם זָהָ֑ב עַל־אַרְבָּעָ֖ה אַדְנֵי־כָֽסֶף׃ ");
INSERT INTO hbo_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","וְנָתַתָּ֣ה אֶת־הַפָּרֹכֶת֮ תַּ֣חַת הַקְּרָסִים֒ וְהֵבֵאתָ֥ שָׁ֙מָּה֙ מִבֵּ֣ית לַפָּרֹ֔כֶת אֵ֖ת אֲרֹ֣ון הָעֵד֑וּת וְהִבְדִּילָ֤ה הַפָּרֹ֙כֶת֙ לָכֶ֔ם בֵּ֣ין הַקֹּ֔דֶשׁ וּבֵ֖ין קֹ֥דֶשׁ הַקֳּדָשִֽׁים׃ ");
INSERT INTO hbo_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","וְנָתַתָּ֙ אֶת־הַכַּפֹּ֔רֶת עַ֖ל אֲרֹ֣ון הָעֵדֻ֑ת בְּקֹ֖דֶשׁ הַקֳּדָשִֽׁים׃ ");
INSERT INTO hbo_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","וְשַׂמְתָּ֤ אֶת־הַשֻּׁלְחָן֙ מִח֣וּץ לַפָּרֹ֔כֶת וְאֶת־הַמְּנֹרָה֙ נֹ֣כַח הַשֻּׁלְחָ֔ן עַ֛ל צֶ֥לַע הַמִּשְׁכָּ֖ן תֵּימָ֑נָה וְהַ֨שֻּׁלְחָ֔ן תִּתֵּ֖ן עַל־צֶ֥לַע צָפֹֽון׃ ");
INSERT INTO hbo_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","וְעָשִׂ֤יתָ מָסָךְ֙ לְפֶ֣תַח הָאֹ֔הֶל תְּכֵ֧לֶת וְאַרְגָּמָ֛ן וְתֹולַ֥עַת שָׁנִ֖י וְשֵׁ֣שׁ מָשְׁזָ֑ר מַעֲשֵׂ֖ה רֹקֵֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","וְעָשִׂ֣יתָ לַמָּסָ֗ךְ חֲמִשָּׁה֙ עַמּוּדֵ֣י שִׁטִּ֔ים וְצִפִּיתָ֤ אֹתָם֙ זָהָ֔ב וָוֵיהֶ֖ם זָהָ֑ב וְיָצַקְתָּ֣ לָהֶ֔ם חֲמִשָּׁ֖ה אַדְנֵ֥י נְחֹֽשֶׁת׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","וְעָשִׂ֥יתָ אֶת־הַמִּזְבֵּ֖חַ עֲצֵ֣י שִׁטִּ֑ים חָמֵשׁ֩ אַמֹּ֨ות אֹ֜רֶךְ וְחָמֵ֧שׁ אַמֹּ֣ות רֹ֗חַב רָב֤וּעַ יִהְיֶה֙ הַמִּזְבֵּ֔חַ וְשָׁלֹ֥שׁ אַמֹּ֖ות קֹמָתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","וְעָשִׂ֣יתָ קַרְנֹתָ֗יו עַ֚ל אַרְבַּ֣ע פִּנֹּתָ֔יו מִמֶּ֖נּוּ תִּהְיֶ֣יןָ קַרְנֹתָ֑יו וְצִפִּיתָ֥ אֹתֹ֖ו נְחֹֽשֶׁת׃ ");
INSERT INTO hbo_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","וְעָשִׂ֤יתָ סִּֽירֹתָיו֙ לְדַשְּׁנֹ֔ו וְיָעָיו֙ וּמִזְרְקֹתָ֔יו וּמִזְלְגֹתָ֖יו וּמַחְתֹּתָ֑יו לְכָל־כֵּלָ֖יו תַּעֲשֶׂ֥ה נְחֹֽשֶׁת׃ ");
INSERT INTO hbo_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","וְעָשִׂ֤יתָ לֹּו֙ מִכְבָּ֔ר מַעֲשֵׂ֖ה רֶ֣שֶׁת נְחֹ֑שֶׁת וְעָשִׂ֣יתָ עַל־הָרֶ֗שֶׁת אַרְבַּע֙ טַבְּעֹ֣ת נְחֹ֔שֶׁת עַ֖ל אַרְבַּ֥ע קְצֹותָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","וְנָתַתָּ֣ה אֹתָ֗הּ תַּ֛חַת כַּרְכֹּ֥ב הַמִּזְבֵּ֖חַ מִלְּמָ֑טָּה וְהָיְתָ֣ה הָרֶ֔שֶׁת עַ֖ד חֲצִ֥י הַמִּזְבֵּֽחַ׃ ");
INSERT INTO hbo_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","וְעָשִׂ֤יתָ בַדִּים֙ לַמִּזְבֵּ֔חַ בַּדֵּ֖י עֲצֵ֣י שִׁטִּ֑ים וְצִפִּיתָ֥ אֹתָ֖ם נְחֹֽשֶׁת׃ ");
INSERT INTO hbo_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","וְהוּבָ֥א אֶת־בַּדָּ֖יו בַּטַּבָּעֹ֑ת וְהָי֣וּ הַבַּדִּ֗ים עַל־שְׁתֵּ֛י צַלְעֹ֥ת הַמִּזְבֵּ֖חַ בִּשְׂאֵ֥ת אֹתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","נְב֥וּב לֻחֹ֖ת תַּעֲשֶׂ֣ה אֹתֹ֑ו כַּאֲשֶׁ֨ר הֶרְאָ֥ה אֹתְךָ֛ בָּהָ֖ר כֵּ֥ן יַעֲשֽׂוּ׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","וְעָשִׂ֕יתָ אֵ֖ת חֲצַ֣ר הַמִּשְׁכָּ֑ן לִפְאַ֣ת נֶֽגֶב־תֵּ֠ימָנָה קְלָעִ֨ים לֶחָצֵ֜ר שֵׁ֣שׁ מָשְׁזָ֗ר מֵאָ֤ה בָֽאַמָּה֙ אֹ֔רֶךְ לַפֵּאָ֖ה הָאֶחָֽת׃ ");
INSERT INTO hbo_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","וְעַמֻּדָ֣יו עֶשְׂרִ֔ים וְאַדְנֵיהֶ֥ם עֶשְׂרִ֖ים נְחֹ֑שֶׁת וָוֵ֧י הָעַמֻּדִ֛ים וַחֲשֻׁקֵיהֶ֖ם כָּֽסֶף׃ ");
INSERT INTO hbo_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","וְכֵ֨ן לִפְאַ֤ת צָפֹון֙ בָּאֹ֔רֶךְ קְלָעִ֖ים מֵ֣אָה אֹ֑רֶךְ *וְעַמְדּוּ (וְעַמּוּדָ֣יו) עֶשְׂרִ֗ים וְאַדְנֵיהֶ֤ם עֶשְׂרִים֙ נְחֹ֔שֶׁת וָוֵ֧י הָֽעַמֻּדִ֛ים וַחֲשֻׁקֵיהֶ֖ם כָּֽסֶף׃ ");
INSERT INTO hbo_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","וְרֹ֤חַב הֶֽחָצֵר֙ לִפְאַת־יָ֔ם קְלָעִ֖ים חֲמִשִּׁ֣ים אַמָּ֑ה עַמֻּדֵיהֶ֣ם עֲשָׂרָ֔ה וְאַדְנֵיהֶ֖ם עֲשָׂרָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","וְרֹ֣חַב הֶֽחָצֵ֗ר לִפְאַ֛ת קֵ֥דְמָה מִזְרָ֖חָה חֲמִשִּׁ֥ים אַמָּֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","וַחֲמֵ֨שׁ עֶשְׂרֵ֥ה אַמָּ֛ה קְלָעִ֖ים לַכָּתֵ֑ף עַמֻּדֵיהֶ֣ם שְׁלֹשָׁ֔ה וְאַדְנֵיהֶ֖ם שְׁלֹשָֽׁה׃ ");
INSERT INTO hbo_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","וְלַכָּתֵף֙ הַשֵּׁנִ֔ית חְמֵ֥שׁ עֶשְׂרֵ֖ה קְלָעִ֑ים עַמֻּדֵיהֶ֣ם שְׁלֹשָׁ֔ה וְאַדְנֵיהֶ֖ם שְׁלֹשָֽׁה׃ ");
INSERT INTO hbo_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","וּלְשַׁ֨עַר הֶֽחָצֵ֜ר מָסָ֣ךְ ׀ עֶשְׂרִ֣ים אַמָּ֗ה תְּכֵ֨לֶת וְאַרְגָּמָ֜ן וְתֹולַ֧עַת שָׁנִ֛י וְשֵׁ֥שׁ מָשְׁזָ֖ר מַעֲשֵׂ֣ה רֹקֵ֑ם עַמֻּֽדֵיהֶם֙ אַרְבָּעָ֔ה וְאַדְנֵיהֶ֖ם אַרְבָּעָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","כָּל־עַמּוּדֵ֨י הֶֽחָצֵ֤ר סָבִיב֙ מְחֻשָּׁקִ֣ים כֶּ֔סֶף וָוֵיהֶ֖ם כָּ֑סֶף וְאַדְנֵיהֶ֖ם נְחֹֽשֶׁת׃ ");
INSERT INTO hbo_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","אֹ֣רֶךְ הֶֽחָצֵר֩ מֵאָ֨ה בָֽאַמָּ֜ה וְרֹ֣חַב ׀ חֲמִשִּׁ֣ים בַּחֲמִשִּׁ֗ים וְקֹמָ֛ה חָמֵ֥שׁ אַמֹּ֖ות שֵׁ֣שׁ מָשְׁזָ֑ר וְאַדְנֵיהֶ֖ם נְחֹֽשֶׁת׃ ");
INSERT INTO hbo_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","לְכֹל֙ כְּלֵ֣י הַמִּשְׁכָּ֔ן בְּכֹ֖ל עֲבֹדָתֹ֑ו וְכָל־יְתֵדֹתָ֛יו וְכָל־יִתְדֹ֥ת הֶחָצֵ֖ר נְחֹֽשֶׁת׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","וְאַתָּ֞ה תְּצַוֶּ֣ה ׀ אֶת־בְּנֵ֣י יִשְׂרָאֵ֗ל וְיִקְח֨וּ אֵלֶ֜יךָ שֶׁ֣מֶן זַ֥יִת זָ֛ךְ כָּתִ֖ית לַמָּאֹ֑ור לְהַעֲלֹ֥ת נֵ֖ר תָּמִֽיד׃ ");
INSERT INTO hbo_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","בְּאֹ֣הֶל מֹועֵד֩ מִח֨וּץ לַפָּרֹ֜כֶת אֲשֶׁ֣ר עַל־הָעֵדֻ֗ת יַעֲרֹךְ֩ אֹתֹ֨ו אַהֲרֹ֧ן וּבָנָ֛יו מֵעֶ֥רֶב עַד־בֹּ֖קֶר לִפְנֵ֣י יְהוָ֑ה חֻקַּ֤ת עֹולָם֙ לְדֹ֣רֹתָ֔ם מֵאֵ֖ת בְּנֵ֥י יִשְׂרָאֵֽל׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","וְאַתָּ֡ה הַקְרֵ֣ב אֵלֶיךָ֩ אֶת־אַהֲרֹ֨ן אָחִ֜יךָ וְאֶת־בָּנָ֣יו אִתֹּ֔ו מִתֹּ֛וךְ בְּנֵ֥י יִשְׂרָאֵ֖ל לְכַהֲנֹו־לִ֑י אַהֲרֹ֕ן נָדָ֧ב וַאֲבִיה֛וּא אֶלְעָזָ֥ר וְאִיתָמָ֖ר בְּנֵ֥י אַהֲרֹֽן׃ ");
INSERT INTO hbo_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","וְעָשִׂ֥יתָ בִגְדֵי־קֹ֖דֶשׁ לְאַהֲרֹ֣ן אָחִ֑יךָ לְכָבֹ֖וד וּלְתִפְאָֽרֶת׃ ");
INSERT INTO hbo_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","וְאַתָּ֗ה תְּדַבֵּר֙ אֶל־כָּל־חַכְמֵי־לֵ֔ב אֲשֶׁ֥ר מִלֵּאתִ֖יו ר֣וּחַ חָכְמָ֑ה וְעָשׂ֞וּ אֶת־בִּגְדֵ֧י אַהֲרֹ֛ן לְקַדְּשֹׁ֖ו לְכַהֲנֹו־לִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","וְאֵ֨לֶּה הַבְּגָדִ֜ים אֲשֶׁ֣ר יַעֲשׂ֗וּ חֹ֤שֶׁן וְאֵפֹוד֙ וּמְעִ֔יל וּכְתֹ֥נֶת תַּשְׁבֵּ֖ץ מִצְנֶ֣פֶת וְאַבְנֵ֑ט וְעָשׂ֨וּ בִגְדֵי־קֹ֜דֶשׁ לְאַהֲרֹ֥ן אָחִ֛יךָ וּלְבָנָ֖יו לְכַהֲנֹו־לִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","וְהֵם֙ יִקְח֣וּ אֶת־הַזָּהָ֔ב וְאֶת־הַתְּכֵ֖לֶת וְאֶת־הָֽאַרְגָּמָ֑ן וְאֶת־תֹּולַ֥עַת הַשָּׁנִ֖י וְאֶת־הַשֵּֽׁשׁ׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","וְעָשׂ֖וּ אֶת־הָאֵפֹ֑ד זָ֠הָב תְּכֵ֨לֶת וְאַרְגָּמָ֜ן תֹּולַ֧עַת שָׁנִ֛י וְשֵׁ֥שׁ מָשְׁזָ֖ר מַעֲשֵׂ֥ה חֹשֵֽׁב׃ ");
INSERT INTO hbo_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","שְׁתֵּ֧י כְתֵפֹ֣ת חֹֽבְרֹ֗ת יִֽהְיֶה־לֹּ֛ו אֶל־שְׁנֵ֥י קְצֹותָ֖יו וְחֻבָּֽר׃ ");
INSERT INTO hbo_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","וְחֵ֤שֶׁב אֲפֻדָּתֹו֙ אֲשֶׁ֣ר עָלָ֔יו כְּמַעֲשֵׂ֖הוּ מִמֶּ֣נּוּ יִהְיֶ֑ה זָהָ֗ב תְּכֵ֧לֶת וְאַרְגָּמָ֛ן וְתֹולַ֥עַת שָׁנִ֖י וְשֵׁ֥שׁ מָשְׁזָֽר׃ ");
INSERT INTO hbo_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","וְלָ֣קַחְתָּ֔ אֶת־שְׁתֵּ֖י אַבְנֵי־שֹׁ֑הַם וּפִתַּחְתָּ֣ עֲלֵיהֶ֔ם שְׁמֹ֖ות בְּנֵ֥י יִשְׂרָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","שִׁשָּׁה֙ מִשְּׁמֹתָ֔ם עַ֖ל הָאֶ֣בֶן הָאֶחָ֑ת וְאֶת־שְׁמֹ֞ות הַשִּׁשָּׁ֧ה הַנֹּותָרִ֛ים עַל־הָאֶ֥בֶן הַשֵּׁנִ֖ית כְּתֹולְדֹתָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","מַעֲשֵׂ֣ה חָרַשׁ֮ אֶבֶן֒ פִּתּוּחֵ֣י חֹתָ֗ם תְּפַתַּח֙ אֶת־שְׁתֵּ֣י הָאֲבָנִ֔ים עַל־שְׁמֹ֖ת בְּנֵ֣י יִשְׂרָאֵ֑ל מֻסַבֹּ֛ת מִשְׁבְּצֹ֥ות זָהָ֖ב תַּעֲשֶׂ֥ה אֹתָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","וְשַׂמְתָּ֞ אֶת־שְׁתֵּ֣י הָאֲבָנִ֗ים עַ֚ל כִּתְפֹ֣ת הָֽאֵפֹ֔ד אַבְנֵ֥י זִכָּרֹ֖ן לִבְנֵ֣י יִשְׂרָאֵ֑ל וְנָשָׂא֩ אַהֲרֹ֨ן אֶת־שְׁמֹותָ֜ם לִפְנֵ֧י יְהוָ֛ה עַל־שְׁתֵּ֥י כְתֵפָ֖יו לְזִכָּרֹֽן׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","וְעָשִׂ֥יתָ מִשְׁבְּצֹ֖ת זָהָֽב׃ ");
INSERT INTO hbo_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","וּשְׁתֵּ֤י שַׁרְשְׁרֹת֙ זָהָ֣ב טָהֹ֔ור מִגְבָּלֹ֛ת תַּעֲשֶׂ֥ה אֹתָ֖ם מַעֲשֵׂ֣ה עֲבֹ֑ת וְנָתַתָּ֛ה אֶת־שַׁרְשְׁרֹ֥ת הָעֲבֹתֹ֖ת עַל־הַֽמִּשְׁבְּצֹֽת׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","וְעָשִׂ֜יתָ חֹ֤שֶׁן מִשְׁפָּט֙ מַעֲשֵׂ֣ה חֹשֵׁ֔ב כְּמַעֲשֵׂ֥ה אֵפֹ֖ד תַּעֲשֶׂ֑נּוּ זָ֠הָב תְּכֵ֨לֶת וְאַרְגָּמָ֜ן וְתֹולַ֧עַת שָׁנִ֛י וְשֵׁ֥שׁ מָשְׁזָ֖ר תַּעֲשֶׂ֥ה אֹתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","רָב֥וּעַ יִֽהְיֶ֖ה כָּפ֑וּל זֶ֥רֶת אָרְכֹּ֖ו וְזֶ֥רֶת רָחְבֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","וּמִלֵּאתָ֥ בֹו֙ מִלֻּ֣אַת אֶ֔בֶן אַרְבָּעָ֖ה טוּרִ֣ים אָ֑בֶן ט֗וּר אֹ֤דֶם פִּטְדָה֙ וּבָרֶ֔קֶת הַטּ֖וּר הָאֶחָֽד׃ ");
INSERT INTO hbo_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","וְהַטּ֖וּר הַשֵּׁנִ֑י נֹ֥פֶךְ סַפִּ֖יר וְיָהֲלֹֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","וְהַטּ֖וּר הַשְּׁלִישִׁ֑י לֶ֥שֶׁם שְׁבֹ֖ו וְאַחְלָֽמָה׃ ");
INSERT INTO hbo_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","וְהַטּוּר֙ הָרְבִיעִ֔י תַּרְשִׁ֥ישׁ וְשֹׁ֖הַם וְיָשְׁפֵ֑ה מְשֻׁבָּצִ֥ים זָהָ֛ב יִהְי֖וּ בְּמִלּוּאֹתָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","וְ֠הָאֲבָנִים תִּֽהְיֶ֜יןָ עַל־שְׁמֹ֧ת בְּנֵֽי־יִשְׂרָאֵ֛ל שְׁתֵּ֥ים עֶשְׂרֵ֖ה עַל־שְׁמֹתָ֑ם פִּתּוּחֵ֤י חֹותָם֙ אִ֣ישׁ עַל־שְׁמֹ֔ו תִּֽהְיֶ֕יןָ לִשְׁנֵ֥י עָשָׂ֖ר שָֽׁבֶט׃ ");
INSERT INTO hbo_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","וְעָשִׂ֧יתָ עַל־הַחֹ֛שֶׁן שַֽׁרְשֹׁ֥ת גַּבְלֻ֖ת מַעֲשֵׂ֣ה עֲבֹ֑ת זָהָ֖ב טָהֹֽור׃ ");
INSERT INTO hbo_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","וְעָשִׂ֙יתָ֙ עַל־הַחֹ֔שֶׁן שְׁתֵּ֖י טַבְּעֹ֣ות זָהָ֑ב וְנָתַתָּ֗ אֶת־שְׁתֵּי֙ הַטַּבָּעֹ֔ות עַל־שְׁנֵ֖י קְצֹ֥ות הַחֹֽשֶׁן׃ ");
INSERT INTO hbo_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","וְנָתַתָּ֗ה אֶת־שְׁתֵּי֙ עֲבֹתֹ֣ת הַזָּהָ֔ב עַל־שְׁתֵּ֖י הַטַּבָּעֹ֑ת אֶל־קְצֹ֖ות הַחֹֽשֶׁן׃ ");
INSERT INTO hbo_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","וְאֵ֨ת שְׁתֵּ֤י קְצֹות֙ שְׁתֵּ֣י הָעֲבֹתֹ֔ת תִּתֵּ֖ן עַל־שְׁתֵּ֣י הַֽמִּשְׁבְּצֹ֑ות וְנָתַתָּ֛ה עַל־כִּתְפֹ֥ות הָאֵפֹ֖ד אֶל־מ֥וּל פָּנָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","וְעָשִׂ֗יתָ שְׁתֵּי֙ טַבְּעֹ֣ות זָהָ֔ב וְשַׂמְתָּ֣ אֹתָ֔ם עַל־שְׁנֵ֖י קְצֹ֣ות הַחֹ֑שֶׁן עַל־שְׂפָתֹ֕ו אֲשֶׁ֛ר אֶל־עֵ֥בֶר הָאֵפֹ֖ד בָּֽיְתָה׃ ");
INSERT INTO hbo_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","וְעָשִׂיתָ֮ שְׁתֵּ֣י טַבְּעֹ֣ות זָהָב֒ וְנָתַתָּ֣ה אֹתָ֡ם עַל־שְׁתֵּי֩ כִתְפֹ֨ות הָאֵפֹ֤וד מִלְּמַ֙טָּה֙ מִמּ֣וּל פָּנָ֔יו לְעֻמַּ֖ת מֶחְבַּרְתֹּ֑ו מִמַּ֕עַל לְחֵ֖שֶׁב הָאֵפֹֽוד׃ ");
INSERT INTO hbo_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","וְיִרְכְּס֣וּ אֶת־הַ֠חֹשֶׁן *מִטַּבְּעֹתֹו (מִֽטַּבְּעֹתָ֞יו) אֶל־טַבְּעֹ֤ת הָאֵפֹד֙ בִּפְתִ֣יל תְּכֵ֔לֶת לִֽהְיֹ֖ות עַל־חֵ֣שֶׁב הָאֵפֹ֑וד וְלֹֽא־יִזַּ֣ח הַחֹ֔שֶׁן מֵעַ֖ל הָאֵפֹֽוד׃ ");
INSERT INTO hbo_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","וְנָשָׂ֣א אַ֠הֲרֹן אֶת־שְׁמֹ֨ות בְּנֵֽי־יִשְׂרָאֵ֜ל בְּחֹ֧שֶׁן הַמִּשְׁפָּ֛ט עַל־לִבֹּ֖ו בְּבֹאֹ֣ו אֶל־הַקֹּ֑דֶשׁ לְזִכָּרֹ֥ן לִפְנֵֽי־יְהוָ֖ה תָּמִֽיד׃ ");
INSERT INTO hbo_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","וְנָתַתָּ֞ אֶל־חֹ֣שֶׁן הַמִּשְׁפָּ֗ט אֶת־הָאוּרִים֙ וְאֶת־הַתֻּמִּ֔ים וְהָיוּ֙ עַל־לֵ֣ב אַהֲרֹ֔ן בְּבֹאֹ֖ו לִפְנֵ֣י יְהוָ֑ה וְנָשָׂ֣א אַ֠הֲרֹן אֶת־מִשְׁפַּ֨ט בְּנֵי־יִשְׂרָאֵ֧ל עַל־לִבֹּ֛ו לִפְנֵ֥י יְהוָ֖ה תָּמִֽיד׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","וְעָשִׂ֛יתָ אֶת־מְעִ֥יל הָאֵפֹ֖וד כְּלִ֥יל תְּכֵֽלֶת׃ ");
INSERT INTO hbo_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","וְהָיָ֥ה פִֽי־רֹאשֹׁ֖ו בְּתֹוכֹ֑ו שָׂפָ֡ה יִֽהְיֶה֩ לְפִ֨יו סָבִ֜יב מַעֲשֵׂ֣ה אֹרֵ֗ג כְּפִ֥י תַחְרָ֛א יִֽהְיֶה־לֹּ֖ו לֹ֥א יִקָּרֵֽעַ׃ ");
INSERT INTO hbo_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","וְעָשִׂ֣יתָ עַל־שׁוּלָ֗יו רִמֹּנֵי֙ תְּכֵ֤לֶת וְאַרְגָּמָן֙ וְתֹולַ֣עַת שָׁנִ֔י עַל־שׁוּלָ֖יו סָבִ֑יב וּפַעֲמֹנֵ֥י זָהָ֛ב בְּתֹוכָ֖ם סָבִֽיב׃ ");
INSERT INTO hbo_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","פַּעֲמֹ֤ן זָהָב֙ וְרִמֹּ֔ון פּֽ͏ַעֲמֹ֥ן זָהָ֖ב וְרִמֹּ֑ון עַל־שׁוּלֵ֥י הַמְּעִ֖יל סָבִֽיב׃ ");
INSERT INTO hbo_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","וְהָיָ֥ה עַֽל־אַהֲרֹ֖ן לְשָׁרֵ֑ת וְנִשְׁמַ֣ע קֹ֠ולֹו בְּבֹאֹ֨ו אֶל־הַקֹּ֜דֶשׁ לִפְנֵ֧י יְהוָ֛ה וּבְצֵאתֹ֖ו וְלֹ֥א יָמֽוּת׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","וְעָשִׂ֥יתָ צִּ֖יץ זָהָ֣ב טָהֹ֑ור וּפִתַּחְתָּ֤ עָלָיו֙ פִּתּוּחֵ֣י חֹתָ֔ם קֹ֖דֶשׁ לַֽיהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","וְשַׂמְתָּ֤ אֹתֹו֙ עַל־פְּתִ֣יל תְּכֵ֔לֶת וְהָיָ֖ה עַל־הַמִּצְנָ֑פֶת אֶל־מ֥וּל פְּנֵֽי־הַמִּצְנֶ֖פֶת יִהְיֶֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","וְהָיָה֮ עַל־מֵ֣צַח אַהֲרֹן֒ וְנָשָׂ֨א אַהֲרֹ֜ן אֶת־עֲוֹ֣ן הַקֳּדָשִׁ֗ים אֲשֶׁ֤ר יַקְדִּ֙ישׁוּ֙ בְּנֵ֣י יִשְׂרָאֵ֔ל לְכָֽל־מַתְּנֹ֖ת קָדְשֵׁיהֶ֑ם וְהָיָ֤ה עַל־מִצְחֹו֙ תָּמִ֔יד לְרָצֹ֥ון לָהֶ֖ם לִפְנֵ֥י יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","וְשִׁבַּצְתָּ֙ הַכְּתֹ֣נֶת שֵׁ֔שׁ וְעָשִׂ֖יתָ מִצְנֶ֣פֶת שֵׁ֑שׁ וְאַבְנֵ֥ט תַּעֲשֶׂ֖ה מַעֲשֵׂ֥ה רֹקֵֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","וְלִבְנֵ֤י אַהֲרֹן֙ תַּעֲשֶׂ֣ה כֻתֳּנֹ֔ת וְעָשִׂ֥יתָ לָהֶ֖ם אַבְנֵטִ֑ים וּמִגְבָּעֹות֙ תַּעֲשֶׂ֣ה לָהֶ֔ם לְכָבֹ֖וד וּלְתִפְאָֽרֶת׃ ");
INSERT INTO hbo_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","וְהִלְבַּשְׁתָּ֤ אֹתָם֙ אֶת־אַהֲרֹ֣ן אָחִ֔יךָ וְאֶת־בָּנָ֖יו אִתֹּ֑ו וּמָשַׁחְתָּ֨ אֹתָ֜ם וּמִלֵּאתָ֧ אֶת־יָדָ֛ם וְקִדַּשְׁתָּ֥ אֹתָ֖ם וְכִהֲנ֥וּ לִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","וַעֲשֵׂ֤ה לָהֶם֙ מִכְנְסֵי־בָ֔ד לְכַסֹּ֖ות בְּשַׂ֣ר עֶרְוָ֑ה מִמָּתְנַ֥יִם וְעַד־יְרֵכַ֖יִם יִהְיֽוּ׃ ");
INSERT INTO hbo_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","וְהָיוּ֩ עַל־אַהֲרֹ֨ן וְעַל־בָּנָ֜יו בְּבֹאָ֣ם ׀ אֶל־אֹ֣הֶל מֹועֵ֗ד אֹ֣ו בְגִשְׁתָּ֤ם אֶל־הַמִּזְבֵּ֙חַ֙ לְשָׁרֵ֣ת בַּקֹּ֔דֶשׁ וְלֹא־יִשְׂא֥וּ עָוֹ֖ן וָמֵ֑תוּ חֻקַּ֥ת עֹולָ֛ם לֹ֖ו וּלְזַרְעֹ֥ו אַחֲרָֽיו׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","וְזֶ֨ה הַדָּבָ֜ר אֲשֶֽׁר־תַּעֲשֶׂ֥ה לָהֶ֛ם לְקַדֵּ֥שׁ אֹתָ֖ם לְכַהֵ֣ן לִ֑י לְ֠קַח פַּ֣ר אֶחָ֧ד בֶּן־בָּקָ֛ר וְאֵילִ֥ם שְׁנַ֖יִם תְּמִימִֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","וְלֶ֣חֶם מַצֹּ֗ות וְחַלֹּ֤ת מַצֹּת֙ בְּלוּלֹ֣ת בַּשֶּׁ֔מֶן וּרְקִיקֵ֥י מַצֹּ֖ות מְשֻׁחִ֣ים בַּשָּׁ֑מֶן סֹ֥לֶת חִטִּ֖ים תַּעֲשֶׂ֥ה אֹתָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","וְנָתַתָּ֤ אֹותָם֙ עַל־סַ֣ל אֶחָ֔ד וְהִקְרַבְתָּ֥ אֹתָ֖ם בַּסָּ֑ל וְאֶ֨ת־הַפָּ֔ר וְאֵ֖ת שְׁנֵ֥י הָאֵילִֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","וְאֶת־אַהֲרֹ֤ן וְאֶת־בָּנָיו֙ תַּקְרִ֔יב אֶל־פֶּ֖תַח אֹ֣הֶל מֹועֵ֑ד וְרָחַצְתָּ֥ אֹתָ֖ם בַּמָּֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","וְלָקַחְתָּ֣ אֶת־הַבְּגָדִ֗ים וְהִלְבַּשְׁתָּ֤ אֶֽת־אַהֲרֹן֙ אֶת־הַכֻּתֹּ֔נֶת וְאֵת֙ מְעִ֣יל הָאֵפֹ֔ד וְאֶת־הָאֵפֹ֖ד וְאֶת־הַחֹ֑שֶׁן וְאָפַדְתָּ֣ לֹ֔ו בְּחֵ֖שֶׁב הָאֵפֹֽד׃ ");
INSERT INTO hbo_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","וְשַׂמְתָּ֥ הַמִּצְנֶ֖פֶת עַל־רֹאשֹׁ֑ו וְנָתַתָּ֛ אֶת־נֵ֥זֶר הַקֹּ֖דֶשׁ עַל־הַמִּצְנָֽפֶת׃ ");
INSERT INTO hbo_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","וְלָֽקַחְתָּ֙ אֶת־שֶׁ֣מֶן הַמִּשְׁחָ֔ה וְיָצַקְתָּ֖ עַל־רֹאשֹׁ֑ו וּמָשַׁחְתָּ֖ אֹתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","וְאֶת־בָּנָ֖יו תַּקְרִ֑יב וְהִלְבַּשְׁתָּ֖ם כֻּתֳּנֹֽת׃ ");
INSERT INTO hbo_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","וְחָגַרְתָּ֩ אֹתָ֨ם אַבְנֵ֜ט אַהֲרֹ֣ן וּבָנָ֗יו וְחָבַשְׁתָּ֤ לָהֶם֙ מִגְבָּעֹ֔ת וְהָיְתָ֥ה לָהֶ֛ם כְּהֻנָּ֖ה לְחֻקַּ֣ת עֹולָ֑ם וּמִלֵּאתָ֥ יֽ͏ַד־אַהֲרֹ֖ן וְיַד־בָּנָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","וְהִקְרַבְתָּ֙ אֶת־הַפָּ֔ר לִפְנֵ֖י אֹ֣הֶל מֹועֵ֑ד וְסָמַ֨ךְ אַהֲרֹ֧ן וּבָנָ֛יו אֶת־יְדֵיהֶ֖ם עַל־רֹ֥אשׁ הַפָּֽר׃ ");
INSERT INTO hbo_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","וְשָׁחַטְתָּ֥ אֶת־הַפָּ֖ר לִפְנֵ֣י יְהוָ֑ה פֶּ֖תַח אֹ֥הֶל מֹועֵֽד׃ ");
INSERT INTO hbo_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","וְלָֽקַחְתָּ֙ מִדַּ֣ם הַפָּ֔ר וְנָתַתָּ֛ה עַל־קַרְנֹ֥ת הַמִּזְבֵּ֖חַ בְּאֶצְבָּעֶ֑ךָ וְאֶת־כָּל־הַדָּ֣ם תִּשְׁפֹּ֔ךְ אֶל־יְסֹ֖וד הַמִּזְבֵּֽחַ׃ ");
INSERT INTO hbo_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","וְלָֽקַחְתָּ֗ אֶֽת־כָּל־הַחֵלֶב֮ הַֽמְכַסֶּ֣ה אֶת־הַקֶּרֶב֒ וְאֵ֗ת הַיֹּתֶ֙רֶת֙ עַל־הַכָּבֵ֔ד וְאֵת֙ שְׁתֵּ֣י הַכְּלָיֹ֔ת וְאֶת־הַחֵ֖לֶב אֲשֶׁ֣ר עֲלֵיהֶ֑ן וְהִקְטַרְתָּ֖ הַמִּזְבֵּֽחָה׃ ");
INSERT INTO hbo_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","וְאֶת־בְּשַׂ֤ר הַפָּר֙ וְאֶת־עֹרֹ֣ו וְאֶת־פִּרְשֹׁ֔ו תִּשְׂרֹ֣ף בָּאֵ֔שׁ מִח֖וּץ לַֽמַּחֲנֶ֑ה חַטָּ֖את הֽוּא׃ ");
INSERT INTO hbo_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","וְאֶת־הָאַ֥יִל הָאֶחָ֖ד תִּקָּ֑ח וְסָ֨מְכ֜וּ אַהֲרֹ֧ן וּבָנָ֛יו אֶת־יְדֵיהֶ֖ם עַל־רֹ֥אשׁ הָאָֽיִל׃ ");
INSERT INTO hbo_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","וְשָׁחַטְתָּ֖ אֶת־הָאָ֑יִל וְלָֽקַחְתָּ֙ אֶת־דָּמֹ֔ו וְזָרַקְתָּ֥ עַל־הַמִּזְבֵּ֖חַ סָבִֽיב׃ ");
INSERT INTO hbo_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","וְאֶ֨ת־הָאַ֔יִל תְּנַתֵּ֖חַ לִנְתָחָ֑יו וְרָחַצְתָּ֤ קִרְבֹּו֙ וּכְרָעָ֔יו וְנָתַתָּ֥ עַל־נְתָחָ֖יו וְעַל־רֹאשֹֽׁו׃ ");
INSERT INTO hbo_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","וְהִקְטַרְתָּ֤ אֶת־כָּל־הָאַ֙יִל֙ הַמִּזְבֵּ֔חָה עֹלָ֥ה ה֖וּא לַֽיהוָ֑ה רֵ֣יחַ נִיחֹ֔וחַ אִשֶּׁ֥ה לַיהוָ֖ה הֽוּא׃ ");
INSERT INTO hbo_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","וְלָ֣קַחְתָּ֔ אֵ֖ת הָאַ֣יִל הַשֵּׁנִ֑י וְסָמַ֨ךְ אַהֲרֹ֧ן וּבָנָ֛יו אֶת־יְדֵיהֶ֖ם עַל־רֹ֥אשׁ הָאָֽיִל׃ ");
INSERT INTO hbo_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","וְשָׁחַטְתָּ֣ אֶת־הָאַ֗יִל וְלָקַחְתָּ֤ מִדָּמֹו֙ וְנָֽתַתָּ֡ה עַל־תְּנוּךְ֩ אֹ֨זֶן אַהֲרֹ֜ן וְעַל־תְּנ֨וּךְ אֹ֤זֶן בָּנָיו֙ הַיְמָנִ֔ית וְעַל־בֹּ֤הֶן יָדָם֙ הַיְמָנִ֔ית וְעַל־בֹּ֥הֶן רַגְלָ֖ם הַיְמָנִ֑ית וְזָרַקְתָּ֧ אֶת־הַדָּ֛ם עַל־הַמִּזְבֵּ֖חַ סָבִֽיב׃ ");
INSERT INTO hbo_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","וְלָקַחְתָּ֞ מִן־הַדָּ֨ם אֲשֶׁ֥ר עַֽל־הַמִּזְבֵּחַ֮ וּמִשֶּׁ֣מֶן הַמִּשְׁחָה֒ וְהִזֵּיתָ֤ עַֽל־אַהֲרֹן֙ וְעַל־בְּגָדָ֔יו וְעַל־בָּנָ֛יו וְעַל־בִּגְדֵ֥י בָנָ֖יו אִתֹּ֑ו וְקָדַ֥שׁ הוּא֙ וּבְגָדָ֔יו וּבָנָ֛יו וּבִגְדֵ֥י בָנָ֖יו אִתֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","וְלָקַחְתָּ֣ מִן־הָ֠אַיִל הַחֵ֨לֶב וְהָֽאַלְיָ֜ה וְאֶת־הַחֵ֣לֶב ׀ הַֽמְכַסֶּ֣ה אֶת־הַקֶּ֗רֶב וְאֵ֨ת יֹתֶ֤רֶת הַכָּבֵד֙ וְאֵ֣ת ׀ שְׁתֵּ֣י הַכְּלָיֹ֗ת וְאֶת־הַחֵ֙לֶב֙ אֲשֶׁ֣ר עֲלֵהֶ֔ן וְאֵ֖ת שֹׁ֣וק הַיָּמִ֑ין כִּ֛י אֵ֥יל מִלֻּאִ֖ים הֽוּא׃ ");
INSERT INTO hbo_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","וְכִכַּ֨ר לֶ֜חֶם אַחַ֗ת וַֽחַלַּ֨ת לֶ֥חֶם שֶׁ֛מֶן אַחַ֖ת וְרָקִ֣יק אֶחָ֑ד מִסַּל֙ הַמַּצֹּ֔ות אֲשֶׁ֖ר לִפְנֵ֥י יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","וְשַׂמְתָּ֣ הַכֹּ֔ל עַ֚ל כַּפֵּ֣י אַהֲרֹ֔ן וְעַ֖ל כַּפֵּ֣י בָנָ֑יו וְהֵנַפְתָּ֥ אֹתָ֛ם תְּנוּפָ֖ה לִפְנֵ֥י יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","וְלָקַחְתָּ֤ אֹתָם֙ מִיָּדָ֔ם וְהִקְטַרְתָּ֥ הַמִּזְבֵּ֖חָה עַל־הָעֹלָ֑ה לְרֵ֤יחַ נִיחֹ֙וחַ֙ לִפְנֵ֣י יְהוָ֔ה אִשֶּׁ֥ה ה֖וּא לַיהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","וְלָקַחְתָּ֣ אֶת־הֶֽחָזֶ֗ה מֵאֵ֤יל הַמִּלֻּאִים֙ אֲשֶׁ֣ר לְאַהֲרֹ֔ן וְהֵנַפְתָּ֥ אֹתֹ֛ו תְּנוּפָ֖ה לִפְנֵ֣י יְהוָ֑ה וְהָיָ֥ה לְךָ֖ לְמָנָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","וְקִדַּשְׁתָּ֞ אֵ֣ת ׀ חֲזֵ֣ה הַתְּנוּפָ֗ה וְאֵת֙ שֹׁ֣וק הַתְּרוּמָ֔ה אֲשֶׁ֥ר הוּנַ֖ף וַאֲשֶׁ֣ר הוּרָ֑ם מֵאֵיל֙ הַמִּלֻּאִ֔ים מֵאֲשֶׁ֥ר לְאַהֲרֹ֖ן וּמֵאֲשֶׁ֥ר לְבָנָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","וְהָיָה֩ לְאַהֲרֹ֨ן וּלְבָנָ֜יו לְחָק־עֹולָ֗ם מֵאֵת֙ בְּנֵ֣י יִשְׂרָאֵ֔ל כִּ֥י תְרוּמָ֖ה ה֑וּא וּתְרוּמָ֞ה יִהְיֶ֨ה מֵאֵ֤ת בְּנֵֽי־יִשְׂרָאֵל֙ מִזִּבְחֵ֣י שַׁלְמֵיהֶ֔ם תְּרוּמָתָ֖ם לַיהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","וּבִגְדֵ֤י הַקֹּ֙דֶשׁ֙ אֲשֶׁ֣ר לְאַהֲרֹ֔ן יִהְי֥וּ לְבָנָ֖יו אַחֲרָ֑יו לְמָשְׁחָ֣ה בָהֶ֔ם וּלְמַלֵּא־בָ֖ם אֶת־יָדָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","שִׁבְעַ֣ת יָמִ֗ים יִלְבָּשָׁ֧ם הַכֹּהֵ֛ן תַּחְתָּ֖יו מִבָּנָ֑יו אֲשֶׁ֥ר יָבֹ֛א אֶל־אֹ֥הֶל מֹועֵ֖ד לְשָׁרֵ֥ת בַּקֹּֽדֶשׁ׃ ");
INSERT INTO hbo_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","וְאֵ֛ת אֵ֥יל הַמִּלֻּאִ֖ים תִּקָּ֑ח וּבִשַּׁלְתָּ֥ אֶת־בְּשָׂרֹ֖ו בְּמָקֹ֥ם קָדֹֽשׁ׃ ");
INSERT INTO hbo_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","וְאָכַ֨ל אַהֲרֹ֤ן וּבָנָיו֙ אֶת־בְּשַׂ֣ר הָאַ֔יִל וְאֶת־הַלֶּ֖חֶם אֲשֶׁ֣ר בַּסָּ֑ל פֶּ֖תַח אֹ֥הֶל מֹועֵֽד׃ ");
INSERT INTO hbo_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","וְאָכְל֤וּ אֹתָם֙ אֲשֶׁ֣ר כֻּפַּ֣ר בָּהֶ֔ם לְמַלֵּ֥א אֶת־יָדָ֖ם לְקַדֵּ֣שׁ אֹתָ֑ם וְזָ֥ר לֹא־יֹאכַ֖ל כִּי־קֹ֥דֶשׁ הֵֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","וְֽאִם־יִוָּתֵ֞ר מִבְּשַׂ֧ר הַמִּלֻּאִ֛ים וּמִן־הַלֶּ֖חֶם עַד־הַבֹּ֑קֶר וְשָׂרַפְתָּ֤ אֶת־הַנֹּותָר֙ בָּאֵ֔שׁ לֹ֥א יֵאָכֵ֖ל כִּי־קֹ֥דֶשׁ הֽוּא׃ ");
INSERT INTO hbo_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","וְעָשִׂ֜יתָ לְאַהֲרֹ֤ן וּלְבָנָיו֙ כָּ֔כָה כְּכֹ֥ל אֲשֶׁר־צִוִּ֖יתִי אֹתָ֑כָה שִׁבְעַ֥ת יָמִ֖ים תְּמַלֵּ֥א יָדָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","וּפַ֨ר חַטָּ֜את תַּעֲשֶׂ֤ה לַיֹּום֙ עַל־הַכִּפֻּרִ֔ים וְחִטֵּאתָ֙ עַל־הַמִּזְבֵּ֔חַ בְּכַפֶּרְךָ֖ עָלָ֑יו וּמָֽשַׁחְתָּ֥ אֹתֹ֖ו לְקַדְּשֹֽׁו׃ ");
INSERT INTO hbo_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","שִׁבְעַ֣ת יָמִ֗ים תְּכַפֵּר֙ עַל־הַמִּזְבֵּ֔חַ וְקִדַּשְׁתָּ֖ אֹתֹ֑ו וְהָיָ֤ה הַמִּזְבֵּ֙חַ֙ קֹ֣דֶשׁ קָֽדָשִׁ֔ים כָּל־הַנֹּגֵ֥עַ בַּמִּזְבֵּ֖חַ יִקְדָּֽשׁ׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","וְזֶ֕ה אֲשֶׁ֥ר תַּעֲשֶׂ֖ה עַל־הַמִּזְבֵּ֑חַ כְּבָשִׂ֧ים בְּנֵֽי־שָׁנָ֛ה שְׁנַ֥יִם לַיֹּ֖ום תָּמִֽיד׃ ");
INSERT INTO hbo_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","אֶת־הַכֶּ֥בֶשׂ הָאֶחָ֖ד תַּעֲשֶׂ֣ה בַבֹּ֑קֶר וְאֵת֙ הַכֶּ֣בֶשׂ הַשֵּׁנִ֔י תַּעֲשֶׂ֖ה בֵּ֥ין הָעַרְבָּֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","וְעִשָּׂרֹ֨ן סֹ֜לֶת בָּל֨וּל בְּשֶׁ֤מֶן כָּתִית֙ רֶ֣בַע הַהִ֔ין וְנֵ֕סֶךְ רְבִעִ֥ית הַהִ֖ין יָ֑יִן לַכֶּ֖בֶשׂ הָאֶחָֽד׃ ");
INSERT INTO hbo_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","וְאֵת֙ הַכֶּ֣בֶשׂ הַשֵּׁנִ֔י תַּעֲשֶׂ֖ה בֵּ֣ין הָעַרְבָּ֑יִם כְּמִנְחַ֨ת הַבֹּ֤קֶר וּכְנִסְכָּהּ֙ תּֽ͏ַעֲשֶׂה־לָּ֔הּ לְרֵ֣יחַ נִיחֹ֔חַ אִשֶּׁ֖ה לַיהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","עֹלַ֤ת תָּמִיד֙ לְדֹרֹ֣תֵיכֶ֔ם פֶּ֥תַח אֹֽהֶל־מֹועֵ֖ד לִפְנֵ֣י יְהוָ֑ה אֲשֶׁ֨ר אִוָּעֵ֤ד לָכֶם֙ שָׁ֔מָּה לְדַבֵּ֥ר אֵלֶ֖יךָ שָֽׁם׃ ");
INSERT INTO hbo_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","וְנֹעַדְתִּ֥י שָׁ֖מָּה לִבְנֵ֣י יִשְׂרָאֵ֑ל וְנִקְדַּ֖שׁ בִּכְבֹדִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","וְקִדַּשְׁתִּ֛י אֶת־אֹ֥הֶל מֹועֵ֖ד וְאֶת־הַמִּזְבֵּ֑חַ וְאֶת־אַהֲרֹ֧ן וְאֶת־בָּנָ֛יו אֲקַדֵּ֖שׁ לְכַהֵ֥ן לִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","וְשָׁ֣כַנְתִּ֔י בְּתֹ֖וךְ בְּנֵ֣י יִשְׂרָאֵ֑ל וְהָיִ֥יתִי לָהֶ֖ם לֵאלֹהִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","וְיָדְע֗וּ כִּ֣י אֲנִ֤י יְהוָה֙ אֱלֹ֣הֵיהֶ֔ם אֲשֶׁ֨ר הֹוצֵ֧אתִי אֹתָ֛ם מֵאֶ֥רֶץ מִצְרַ֖יִם לְשָׁכְנִ֣י בְתֹוכָ֑ם אֲנִ֖י יְהוָ֥ה אֱלֹהֵיהֶֽם׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","וְעָשִׂ֥יתָ מִזְבֵּ֖חַ מִקְטַ֣ר קְטֹ֑רֶת עֲצֵ֥י שִׁטִּ֖ים תַּעֲשֶׂ֥ה אֹתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","אַמָּ֨ה אָרְכֹּ֜ו וְאַמָּ֤ה רָחְבֹּו֙ רָב֣וּעַ יִהְיֶ֔ה וְאַמָּתַ֖יִם קֹמָתֹ֑ו מִמֶּ֖נּוּ קַרְנֹתָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","וְצִפִּיתָ֨ אֹתֹ֜ו זָהָ֣ב טָהֹ֗ור אֶת־גַּגֹּ֧ו וְאֶת־קִירֹתָ֛יו סָבִ֖יב וְאֶת־קַרְנֹתָ֑יו וְעָשִׂ֥יתָ לֹּ֛ו זֵ֥ר זָהָ֖ב סָבִֽיב׃ ");
INSERT INTO hbo_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","וּשְׁתֵּי֩ טַבְּעֹ֨ת זָהָ֜ב תַּֽעֲשֶׂה־לֹּ֣ו ׀ מִתַּ֣חַת לְזֵרֹ֗ו עַ֚ל שְׁתֵּ֣י צַלְעֹתָ֔יו תַּעֲשֶׂ֖ה עַל־שְׁנֵ֣י צִדָּ֑יו וְהָיָה֙ לְבָתִּ֣ים לְבַדִּ֔ים לָשֵׂ֥את אֹתֹ֖ו בָּהֵֽמָּה׃ ");
INSERT INTO hbo_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","וְעָשִׂ֥יתָ אֶת־הַבַּדִּ֖ים עֲצֵ֣י שִׁטִּ֑ים וְצִפִּיתָ֥ אֹתָ֖ם זָהָֽב׃ ");
INSERT INTO hbo_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","וְנָתַתָּ֤ה אֹתֹו֙ לִפְנֵ֣י הַפָּרֹ֔כֶת אֲשֶׁ֖ר עַל־אֲרֹ֣ן הָעֵדֻ֑ת לִפְנֵ֣י הַכַּפֹּ֗רֶת אֲשֶׁר֙ עַל־הָ֣עֵדֻ֔ת אֲשֶׁ֛ר אִוָּעֵ֥ד לְךָ֖ שָֽׁמָּה׃ ");
INSERT INTO hbo_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","וְהִקְטִ֥יר עָלָ֛יו אַהֲרֹ֖ן קְטֹ֣רֶת סַמִּ֑ים בַּבֹּ֣קֶר בַּבֹּ֗קֶר בְּהֵיטִיבֹ֛ו אֶת־הַנֵּרֹ֖ת יַקְטִירֶֽנָּה׃ ");
INSERT INTO hbo_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","וּבְהַעֲלֹ֨ת אַהֲרֹ֧ן אֶת־הַנֵּרֹ֛ת בֵּ֥ין הָעֲרְבַּ֖יִם יַקְטִירֶ֑נָּה קְטֹ֧רֶת תָּמִ֛יד לִפְנֵ֥י יְהוָ֖ה לְדֹרֹתֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","לֹא־תַעֲל֥וּ עָלָ֛יו קְטֹ֥רֶת זָרָ֖ה וְעֹלָ֣ה וּמִנְחָ֑ה וְנֵ֕סֶךְ לֹ֥א תִסְּכ֖וּ עָלָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","וְכִפֶּ֤ר אַהֲרֹן֙ עַל־קַרְנֹתָ֔יו אַחַ֖ת בַּשָּׁנָ֑ה מִדַּ֞ם חַטַּ֣את הַכִּפֻּרִ֗ים אַחַ֤ת בַּשָּׁנָה֙ יְכַפֵּ֤ר עָלָיו֙ לְדֹרֹ֣תֵיכֶ֔ם קֹֽדֶשׁ־קֽ͏ָדָשִׁ֥ים ה֖וּא לַיהוָֽה׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","כִּ֣י תִשָּׂ֞א אֶת־רֹ֥אשׁ בְּנֽ͏ֵי־יִשְׂרָאֵל֮ לִפְקֻדֵיהֶם֒ וְנָ֨תְנ֜וּ אִ֣ישׁ כֹּ֧פֶר נַפְשֹׁ֛ו לַיהוָ֖ה בִּפְקֹ֣ד אֹתָ֑ם וְלֹא־יִהְיֶ֥ה בָהֶ֛ם נֶ֖גֶף בִּפְקֹ֥ד אֹתָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","זֶ֣ה ׀ יִתְּנ֗וּ כָּל־הָעֹבֵר֙ עַל־הַפְּקֻדִ֔ים מַחֲצִ֥ית הַשֶּׁ֖קֶל בְּשֶׁ֣קֶל הַקֹּ֑דֶשׁ עֶשְׂרִ֤ים גֵּרָה֙ הַשֶּׁ֔קֶל מַחֲצִ֣ית הַשֶּׁ֔קֶל תְּרוּמָ֖ה לֽ͏ַיהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","כֹּ֗ל הָעֹבֵר֙ עַל־הַפְּקֻדִ֔ים מִבֶּ֛ן עֶשְׂרִ֥ים שָׁנָ֖ה וָמָ֑עְלָה יִתֵּ֖ן תְּרוּמַ֥ת יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","הֶֽעָשִׁ֣יר לֹֽא־יַרְבֶּ֗ה וְהַדַּל֙ לֹ֣א יַמְעִ֔יט מִֽמַּחֲצִ֖ית הַשָּׁ֑קֶל לָתֵת֙ אֶת־תְּרוּמַ֣ת יְהוָ֔ה לְכַפֵּ֖ר עַל־נַפְשֹׁתֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","וְלָקַחְתָּ֞ אֶת־כֶּ֣סֶף הַכִּפֻּרִ֗ים מֵאֵת֙ בְּנֵ֣י יִשְׂרָאֵ֔ל וְנָתַתָּ֣ אֹתֹ֔ו עַל־עֲבֹדַ֖ת אֹ֣הֶל מֹועֵ֑ד וְהָיָה֩ לִבְנֵ֨י יִשְׂרָאֵ֤ל לְזִכָּרֹון֙ לִפְנֵ֣י יְהוָ֔ה לְכַפֵּ֖ר עַל־נַפְשֹׁתֵיכֶֽם׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","וְעָשִׂ֜יתָ כִּיֹּ֥ור נְחֹ֛שֶׁת וְכַנֹּ֥ו נְחֹ֖שֶׁת לְרָחְצָ֑ה וְנָתַתָּ֣ אֹתֹ֗ו בֵּֽין־אֹ֤הֶל מֹועֵד֙ וּבֵ֣ין הַמִּזְבֵּ֔חַ וְנָתַתָּ֥ שָׁ֖מָּה מָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","וְרָחֲצ֛וּ אַהֲרֹ֥ן וּבָנָ֖יו מִמֶּ֑נּוּ אֶת־יְדֵיהֶ֖ם וְאֶת־רַגְלֵיהֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","בְּבֹאָ֞ם אֶל־אֹ֧הֶל מֹועֵ֛ד יִרְחֲצוּ־מַ֖יִם וְלֹ֣א יָמֻ֑תוּ אֹ֣ו בְגִשְׁתָּ֤ם אֶל־הַמִּזְבֵּ֙חַ֙ לְשָׁרֵ֔ת לְהַקְטִ֥יר אִשֶּׁ֖ה לַֽיהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","וְרָחֲצ֛וּ יְדֵיהֶ֥ם וְרַגְלֵיהֶ֖ם וְלֹ֣א יָמֻ֑תוּ וְהָיְתָ֨ה לָהֶ֧ם חָק־עֹולָ֛ם לֹ֥ו וּלְזַרְעֹ֖ו לְדֹרֹתָֽם׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","וְאַתָּ֣ה קַח־לְךָ֮ בְּשָׂמִ֣ים רֹאשׁ֒ מָר־דְּרֹור֙ חֲמֵ֣שׁ מֵאֹ֔ות וְקִנְּמָן־בֶּ֥שֶׂם מַחֲצִיתֹ֖ו חֲמִשִּׁ֣ים וּמָאתָ֑יִם וּקְנֵה־בֹ֖שֶׂם חֲמִשִּׁ֥ים וּמָאתָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","וְקִדָּ֕ה חֲמֵ֥שׁ מֵאֹ֖ות בְּשֶׁ֣קֶל הַקֹּ֑דֶשׁ וְשֶׁ֥מֶן זַ֖יִת הִֽין׃ ");
INSERT INTO hbo_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","וְעָשִׂ֣יתָ אֹתֹ֗ו שֶׁ֚מֶן מִשְׁחַת־קֹ֔דֶשׁ רֹ֥קַח מִרְקַ֖חַת מַעֲשֵׂ֣ה רֹקֵ֑חַ שֶׁ֥מֶן מִשְׁחַת־קֹ֖דֶשׁ יִהְיֶֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","וּמָשַׁחְתָּ֥ בֹ֖ו אֶת־אֹ֣הֶל מֹועֵ֑ד וְאֵ֖ת אֲרֹ֥ון הָעֵדֻֽת׃ ");
INSERT INTO hbo_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","וְאֶת־הַשֻּׁלְחָן֙ וְאֶת־כָּל־כֵּלָ֔יו וְאֶת־הַמְּנֹרָ֖ה וְאֶת־כֵּלֶ֑יהָ וְאֵ֖ת מִזְבַּ֥ח הַקְּטֹֽרֶת׃ ");
INSERT INTO hbo_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","וְאֶת־מִזְבַּ֥ח הָעֹלָ֖ה וְאֶת־כָּל־כֵּלָ֑יו וְאֶת־הַכִּיֹּ֖ר וְאֶת־כַּנֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","וְקִדַּשְׁתָּ֣ אֹתָ֔ם וְהָי֖וּ קֹ֣דֶשׁ קֽ͏ָדָשִׁ֑ים כָּל־הַנֹּגֵ֥עַ בָּהֶ֖ם יִקְדָּֽשׁ׃ ");
INSERT INTO hbo_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","וְאֶת־אַהֲרֹ֥ן וְאֶת־בָּנָ֖יו תִּמְשָׁ֑ח וְקִדַּשְׁתָּ֥ אֹתָ֖ם לְכַהֵ֥ן לִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","וְאֶל־בְּנֵ֥י יִשְׂרָאֵ֖ל תְּדַבֵּ֣ר לֵאמֹ֑ר שֶׁ֠מֶן מִשְׁחַת־קֹ֨דֶשׁ יִהְיֶ֥ה זֶ֛ה לִ֖י לְדֹרֹתֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","עַל־בְּשַׂ֤ר אָדָם֙ לֹ֣א יִיסָ֔ךְ וּבְמַ֨תְכֻּנְתֹּ֔ו לֹ֥א תַעֲשׂ֖וּ כָּמֹ֑הוּ קֹ֣דֶשׁ ה֔וּא קֹ֖דֶשׁ יִהְיֶ֥ה לָכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","אִ֚ישׁ אֲשֶׁ֣ר יִרְקַ֣ח כָּמֹ֔הוּ וַאֲשֶׁ֥ר יִתֵּ֛ן מִמֶּ֖נּוּ עַל־זָ֑ר וְנִכְרַ֖ת מֵעַמָּֽיו׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","וַיֹּאמֶר֩ יְהוָ֨ה אֶל־מֹשֶׁ֜ה קַח־לְךָ֣ סַמִּ֗ים נָטָ֤ף ׀ וּשְׁחֵ֙לֶת֙ וְחֶלְבְּנָ֔ה סַמִּ֖ים וּלְבֹנָ֣ה זַכָּ֑ה בַּ֥ד בְּבַ֖ד יִהְיֶֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","וְעָשִׂ֤יתָ אֹתָהּ֙ קְטֹ֔רֶת רֹ֖קַח מַעֲשֵׂ֣ה רֹוקֵ֑חַ מְמֻלָּ֖ח טָהֹ֥ור קֹֽדֶשׁ׃ ");
INSERT INTO hbo_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","וְשָֽׁחַקְתָּ֣ מִמֶּנָּה֮ הָדֵק֒ וְנָתַתָּ֨ה מִמֶּ֜נָּה לִפְנֵ֤י הָעֵדֻת֙ בְּאֹ֣הֶל מֹועֵ֔ד אֲשֶׁ֛ר אִוָּעֵ֥ד לְךָ֖ שָׁ֑מָּה קֹ֥דֶשׁ קֽ͏ָדָשִׁ֖ים תִּהְיֶ֥ה לָכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","וְהַקְּטֹ֙רֶת֙ אֲשֶׁ֣ר תַּעֲשֶׂ֔ה בְּמַ֨תְכֻּנְתָּ֔הּ לֹ֥א תַעֲשׂ֖וּ לָכֶ֑ם קֹ֛דֶשׁ תִּהְיֶ֥ה לְךָ֖ לַיהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","אִ֛ישׁ אֲשֶׁר־יַעֲשֶׂ֥ה כָמֹ֖והָ לְהָרִ֣יחַ בָּ֑הּ וְנִכְרַ֖ת מֵעַמָּֽיו׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","רְאֵ֖ה קָרָ֣אתִֽי בְשֵׁ֑ם בְּצַלְאֵ֛ל בֶּן־אוּרִ֥י בֶן־ח֖וּר לְמַטֵּ֥ה יְהוּדָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","וָאֲמַלֵּ֥א אֹתֹ֖ו ר֣וּחַ אֱלֹהִ֑ים בְּחָכְמָ֛ה וּבִתְבוּנָ֥ה וּבְדַ֖עַת וּבְכָל־מְלָאכָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","לַחְשֹׁ֖ב מַחֲשָׁבֹ֑ת לַעֲשֹׂ֛ות בַּזָּהָ֥ב וּבַכֶּ֖סֶף וּבַנְּחֹֽשֶׁת׃ ");
INSERT INTO hbo_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","וּבַחֲרֹ֥שֶׁת אֶ֛בֶן לְמַלֹּ֖את וּבַחֲרֹ֣שֶׁת עֵ֑ץ לַעֲשֹׂ֖ות בְּכָל־מְלָאכָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","וַאֲנִ֞י הִנֵּ֧ה נָתַ֣תִּי אִתֹּ֗ו אֵ֣ת אָהֳלִיאָ֞ב בֶּן־אֲחִֽיסָמָךְ֙ לְמַטֵּה־דָ֔ן וּבְלֵ֥ב כָּל־חֲכַם־לֵ֖ב נָתַ֣תִּי חָכְמָ֑ה וְעָשׂ֕וּ אֵ֖ת כָּל־אֲשֶׁ֥ר צִוִּיתִֽךָ׃ ");
INSERT INTO hbo_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","אֵ֣ת ׀ אֹ֣הֶל מֹועֵ֗ד וְאֶת־הָֽאָרֹן֙ לָֽעֵדֻ֔ת וְאֶת־הַכַּפֹּ֖רֶת אֲשֶׁ֣ר עָלָ֑יו וְאֵ֖ת כָּל־כְּלֵ֥י הָאֹֽהֶל׃ ");
INSERT INTO hbo_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","וְאֶת־הַשֻּׁלְחָן֙ וְאֶת־כֵּלָ֔יו וְאֶת־הַמְּנֹרָ֥ה הַטְּהֹרָ֖ה וְאֶת־כָּל־כֵּלֶ֑יהָ וְאֵ֖ת מִזְבַּ֥ח הַקְּטֹֽרֶת׃ ");
INSERT INTO hbo_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","וְאֶת־מִזְבַּ֥ח הָעֹלָ֖ה וְאֶת־כָּל־כֵּלָ֑יו וְאֶת־הַכִּיֹּ֖ור וְאֶת־כַּנֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","וְאֵ֖ת בִּגְדֵ֣י הַשְּׂרָ֑ד וְאֶת־בִּגְדֵ֤י הַקֹּ֙דֶשׁ֙ לְאַהֲרֹ֣ן הַכֹּהֵ֔ן וְאֶת־בִּגְדֵ֥י בָנָ֖יו לְכַהֵֽן׃ ");
INSERT INTO hbo_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","וְאֵ֨ת שֶׁ֧מֶן הַמִּשְׁחָ֛ה וְאֶת־קְטֹ֥רֶת הַסַּמִּ֖ים לַקֹּ֑דֶשׁ כְּכֹ֥ל אֲשֶׁר־צִוִּיתִ֖ךָ יַעֲשֽׂוּ׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","וַיֹּ֥אמֶר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","וְאַתָּ֞ה דַּבֵּ֨ר אֶל־בְּנֵ֤י יִשְׂרָאֵל֙ לֵאמֹ֔ר אַ֥ךְ אֶת־שַׁבְּתֹתַ֖י תִּשְׁמֹ֑רוּ כִּי֩ אֹ֨ות הִ֜וא בֵּינִ֤י וּבֵֽינֵיכֶם֙ לְדֹרֹ֣תֵיכֶ֔ם לָדַ֕עַת כִּ֛י אֲנִ֥י יְהוָ֖ה מְקַדִּשְׁכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","וּשְׁמַרְתֶּם֙ אֶת־הַשַּׁבָּ֔ת כִּ֛י קֹ֥דֶשׁ הִ֖וא לָכֶ֑ם מְחַֽלְלֶ֙יהָ֙ מֹ֣ות יוּמָ֔ת כִּ֗י כָּל־הָעֹשֶׂ֥ה בָהּ֙ מְלָאכָ֔ה וְנִכְרְתָ֛ה הַנֶּ֥פֶשׁ הַהִ֖וא מִקֶּ֥רֶב עַמֶּֽיהָ׃ ");
INSERT INTO hbo_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","שֵׁ֣שֶׁת יָמִים֮ יֵעָשֶׂ֣ה מְלָאכָה֒ וּבַיֹּ֣ום הַשְּׁבִיעִ֗י שַׁבַּ֧ת שַׁבָּתֹ֛ון קֹ֖דֶשׁ לַיהוָ֑ה כָּל־הָעֹשֶׂ֧ה מְלָאכָ֛ה בְּיֹ֥ום הַשַּׁבָּ֖ת מֹ֥ות יוּמָֽת׃ ");
INSERT INTO hbo_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","וְשָׁמְר֥וּ בְנֵֽי־יִשְׂרָאֵ֖ל אֶת־הַשַּׁבָּ֑ת לַעֲשֹׂ֧ות אֶת־הַשַּׁבָּ֛ת לְדֹרֹתָ֖ם בְּרִ֥ית עֹולָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","בֵּינִ֗י וּבֵין֙ בְּנֵ֣י יִשְׂרָאֵ֔ל אֹ֥ות הִ֖וא לְעֹלָ֑ם כִּי־שֵׁ֣שֶׁת יָמִ֗ים עָשָׂ֤ה יְהוָה֙ אֶת־הַשָּׁמַ֣יִם וְאֶת־הָאָ֔רֶץ וּבַיֹּום֙ הַשְּׁבִיעִ֔י שָׁבַ֖ת וַיִּנָּפַֽשׁ׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","וַיִּתֵּ֣ן אֶל־מֹשֶׁ֗ה כְּכַלֹּתֹו֙ לְדַבֵּ֤ר אִתֹּו֙ בְּהַ֣ר סִינַ֔י שְׁנֵ֖י לֻחֹ֣ת הָעֵדֻ֑ת לֻחֹ֣ת אֶ֔בֶן כְּתֻבִ֖ים בְּאֶצְבַּ֥ע אֱלֹהִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","וַיַּ֣רְא הָעָ֔ם כִּֽי־בֹשֵׁ֥שׁ מֹשֶׁ֖ה לָרֶ֣דֶת מִן־הָהָ֑ר וַיִּקָּהֵ֨ל הָעָ֜ם עַֽל־אַהֲרֹ֗ן וַיֹּאמְר֤וּ אֵלָיו֙ ק֣וּם ׀ עֲשֵׂה־לָ֣נוּ אֱלֹהִ֗ים אֲשֶׁ֤ר יֵֽלְכוּ֙ לְפָנֵ֔ינוּ כִּי־זֶ֣ה ׀ מֹשֶׁ֣ה הָאִ֗ישׁ אֲשֶׁ֤ר הֶֽעֱלָ֙נוּ֙ מֵאֶ֣רֶץ מִצְרַ֔יִם לֹ֥א יָדַ֖עְנוּ מֶה־הָ֥יָה לֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","וַיֹּ֤אמֶר אֲלֵהֶם֙ אַהֲרֹ֔ן פָּֽרְקוּ֙ נִזְמֵ֣י הַזָּהָ֔ב אֲשֶׁר֙ בְּאָזְנֵ֣י נְשֵׁיכֶ֔ם בְּנֵיכֶ֖ם וּבְנֹתֵיכֶ֑ם וְהָבִ֖יאוּ אֵלָֽי׃ ");
INSERT INTO hbo_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","וַיִּתְפָּֽרְקוּ֙ כָּל־הָעָ֔ם אֶת־נִזְמֵ֥י הַזָּהָ֖ב אֲשֶׁ֣ר בְּאָזְנֵיהֶ֑ם וַיָּבִ֖יאוּ אֶֽל־אַהֲרֹֽן׃ ");
INSERT INTO hbo_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","וַיִּקַּ֣ח מִיָּדָ֗ם וַיָּ֤צַר אֹתֹו֙ בַּחֶ֔רֶט וַֽיַּעֲשֵׂ֖הוּ עֵ֣גֶל מַסֵּכָ֑ה וַיֹּ֣אמְר֔וּ אֵ֤לֶּה אֱלֹהֶ֙יךָ֙ יִשְׂרָאֵ֔ל אֲשֶׁ֥ר הֶעֱל֖וּךָ מֵאֶ֥רֶץ מִצְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","וַיַּ֣רְא אַהֲרֹ֔ן וַיִּ֥בֶן מִזְבֵּ֖חַ לְפָנָ֑יו וַיִּקְרָ֤א אַֽהֲרֹן֙ וַיֹּאמַ֔ר חַ֥ג לַיהוָ֖ה מָחָֽר׃ ");
INSERT INTO hbo_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","וַיַּשְׁכִּ֙ימוּ֙ מִֽמָּחֳרָ֔ת וַיַּעֲל֣וּ עֹלֹ֔ת וַיַּגִּ֖שׁוּ שְׁלָמִ֑ים וַיֵּ֤שֶׁב הָעָם֙ לֽ͏ֶאֱכֹ֣ל וְשָׁתֹ֔ו וַיָּקֻ֖מוּ לְצַחֵֽק׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֑ה לֶךְ־רֵ֕ד כִּ֚י שִׁחֵ֣ת עַמְּךָ֔ אֲשֶׁ֥ר הֶעֱלֵ֖יתָ מֵאֶ֥רֶץ מִצְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","סָ֣רוּ מַהֵ֗ר מִן־הַדֶּ֙רֶךְ֙ אֲשֶׁ֣ר צִוִּיתִ֔ם עָשׂ֣וּ לָהֶ֔ם עֵ֖גֶל מַסֵּכָ֑ה וַיִּשְׁתַּֽחֲווּ־לֹו֙ וַיִּזְבְּחוּ־לֹ֔ו וַיֹּ֣אמְר֔וּ אֵ֤לֶּה אֱלֹהֶ֙יךָ֙ יִשְׂרָאֵ֔ל אֲשֶׁ֥ר הֽ͏ֶעֱל֖וּךָ מֵאֶ֥רֶץ מִצְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","וַיֹּ֥אמֶר יְהוָ֖ה אֶל־מֹשֶׁ֑ה רָאִ֙יתִי֙ אֶת־הָעָ֣ם הַזֶּ֔ה וְהִנֵּ֥ה עַם־קְשֵׁה־עֹ֖רֶף הֽוּא׃ ");
INSERT INTO hbo_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","וְעַתָּה֙ הַנִּ֣יחָה לִּ֔י וְיִֽחַר־אַפִּ֥י בָהֶ֖ם וַאֲכַלֵּ֑ם וְאֶֽעֱשֶׂ֥ה אֹותְךָ֖ לְגֹ֥וי גָּדֹֽול׃ ");
INSERT INTO hbo_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","וַיְחַ֣ל מֹשֶׁ֔ה אֶת־פְּנֵ֖י יְהוָ֣ה אֱלֹהָ֑יו וַיֹּ֗אמֶר לָמָ֤ה יְהוָה֙ יֶחֱרֶ֤ה אַפְּךָ֙ בְּעַמֶּ֔ךָ אֲשֶׁ֤ר הֹוצֵ֙אתָ֙ מֵאֶ֣רֶץ מִצְרַ֔יִם בְּכֹ֥חַ גָּדֹ֖ול וּבְיָ֥ד חֲזָקָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","לָמָּה֩ יֹאמְר֨וּ מִצְרַ֜יִם לֵאמֹ֗ר בְּרָעָ֤ה הֹֽוצִיאָם֙ לַהֲרֹ֤ג אֹתָם֙ בֶּֽהָרִ֔ים וּ֨לְכַלֹּתָ֔ם מֵעַ֖ל פְּנֵ֣י הָֽאֲדָמָ֑ה שׁ֚וּב מֵחֲרֹ֣ון אַפֶּ֔ךָ וְהִנָּחֵ֥ם עַל־הָרָעָ֖ה לְעַמֶּֽךָ׃ ");
INSERT INTO hbo_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","זְכֹ֡ר לְאַבְרָהָם֩ לְיִצְחָ֨ק וּלְיִשְׂרָאֵ֜ל עֲבָדֶ֗יךָ אֲשֶׁ֨ר נִשְׁבַּ֣עְתָּ לָהֶם֮ בָּךְ֒ וַתְּדַבֵּ֣ר אֲלֵהֶ֔ם אַרְבֶּה֙ אֶֽת־זַרְעֲכֶ֔ם כְּכֹוכְבֵ֖י הַשָּׁמָ֑יִם וְכָל־הָאָ֨רֶץ הַזֹּ֜את אֲשֶׁ֣ר אָמַ֗רְתִּי אֶתֵּן֙ לְזַרְעֲכֶ֔ם וְנָחֲל֖וּ לְעֹלָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","וַיִּנָּ֖חֶם יְהוָ֑ה עַל־הָ֣רָעָ֔ה אֲשֶׁ֥ר דִּבֶּ֖ר לַעֲשֹׂ֥ות לְעַמֹּֽו׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","וַיִּ֜פֶן וַיֵּ֤רֶד מֹשֶׁה֙ מִן־הָהָ֔ר וּשְׁנֵ֛י לֻחֹ֥ת הָעֵדֻ֖ת בְּיָדֹ֑ו לֻחֹ֗ת כְּתֻבִים֙ מִשְּׁנֵ֣י עֶבְרֵיהֶ֔ם מִזֶּ֥ה וּמִזֶּ֖ה הֵ֥ם כְּתֻבִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","וְהַ֨לֻּחֹ֔ת מַעֲשֵׂ֥ה אֱלֹהִ֖ים הֵ֑מָּה וְהַמִּכְתָּ֗ב מִכְתַּ֤ב אֱלֹהִים֙ ה֔וּא חָר֖וּת עַל־הַלֻּחֹֽת׃ ");
INSERT INTO hbo_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","וַיִּשְׁמַ֧ע יְהֹושֻׁ֛עַ אֶת־קֹ֥ול הָעָ֖ם בְּרֵעֹ֑ה וַיֹּ֙אמֶר֙ אֶל־מֹשֶׁ֔ה קֹ֥ול מִלְחָמָ֖ה בַּֽמַּחֲנֶה׃ ");
INSERT INTO hbo_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","וַיֹּ֗אמֶר אֵ֥ין קֹול֙ עֲנֹ֣ות גְּבוּרָ֔ה וְאֵ֥ין קֹ֖ול עֲנֹ֣ות חֲלוּשָׁ֑ה קֹ֣ול עַנֹּ֔ות אָנֹכִ֖י שֹׁמֵֽעַ׃ ");
INSERT INTO hbo_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","וֽ͏ַיְהִ֗י כַּאֲשֶׁ֤ר קָרַב֙ אֶל־הַֽמַּחֲנֶ֔ה וַיַּ֥רְא אֶת־הָעֵ֖גֶל וּמְחֹלֹ֑ת וַיִּֽחַר־אַ֣ף מֹשֶׁ֗ה וַיַּשְׁלֵ֤ךְ *מִיָּדֹו (מִיָּדָיו֙) אֶת־הַלֻּחֹ֔ת וַיְשַׁבֵּ֥ר אֹתָ֖ם תַּ֥חַת הָהָֽר׃ ");
INSERT INTO hbo_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","וַיִּקַּ֞ח אֶת־הָעֵ֨גֶל אֲשֶׁ֤ר עָשׂוּ֙ וַיִּשְׂרֹ֣ף בָּאֵ֔שׁ וַיִּטְחַ֖ן עַ֣ד אֲשֶׁר־דָּ֑ק וַיִּ֙זֶר֙ עַל־פְּנֵ֣י הַמַּ֔יִם וַיַּ֖שְׁקְ אֶת־בְּנֵ֥י יִשְׂרָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","וַיֹּ֤אמֶר מֹשֶׁה֙ אֶֽל־אַהֲרֹ֔ן מֶֽה־עָשָׂ֥ה לְךָ֖ הָעָ֣ם הַזֶּ֑ה כִּֽי־הֵבֵ֥אתָ עָלָ֖יו חֲטָאָ֥ה גְדֹלָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","וַיֹּ֣אמֶר אַהֲרֹ֔ן אַל־יִ֥חַר אַ֖ף אֲדֹנִ֑י אַתָּה֙ יָדַ֣עְתָּ אֶת־הָעָ֔ם כִּ֥י בְרָ֖ע הֽוּא׃ ");
INSERT INTO hbo_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","וַיֹּ֣אמְרוּ לִ֔י עֲשֵׂה־לָ֣נוּ אֱלֹהִ֔ים אֲשֶׁ֥ר יֵלְכ֖וּ לְפָנֵ֑ינוּ כִּי־זֶ֣ה ׀ מֹשֶׁ֣ה הָאִ֗ישׁ אֲשֶׁ֤ר הֽ͏ֶעֱלָ֙נוּ֙ מֵאֶ֣רֶץ מִצְרַ֔יִם לֹ֥א יָדַ֖עְנוּ מֶה־הָ֥יָה לֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","וָאֹמַ֤ר לָהֶם֙ לְמִ֣י זָהָ֔ב הִתְפָּרָ֖קוּ וַיִּתְּנוּ־לִ֑י וָאַשְׁלִכֵ֣הוּ בָאֵ֔שׁ וַיֵּצֵ֖א הָעֵ֥גֶל הַזֶּֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","וַיַּ֤רְא מֹשֶׁה֙ אֶת־הָעָ֔ם כִּ֥י פָרֻ֖עַ ה֑וּא כִּֽי־פְרָעֹ֣ה אַהֲרֹ֔ן לְשִׁמְצָ֖ה בְּקָמֵיהֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","וַיַּעֲמֹ֤ד מֹשֶׁה֙ בְּשַׁ֣עַר הַֽמַּחֲנֶ֔ה וַיֹּ֕אמֶר מִ֥י לַיהוָ֖ה אֵלָ֑י וַיֵּאָסְפ֥וּ אֵלָ֖יו כָּל־בְּנֵ֥י לֵוִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","וַיֹּ֣אמֶר לָהֶ֗ם כֹּֽה־אָמַ֤ר יְהוָה֙ אֱלֹהֵ֣י יִשְׂרָאֵ֔ל שִׂ֥ימוּ אִישׁ־חַרְבֹּ֖ו עַל־יְרֵכֹ֑ו עִבְר֨וּ וָשׁ֜וּבוּ מִשַּׁ֤עַר לָשַׁ֙עַר֙ בַּֽמַּחֲנֶ֔ה וְהִרְג֧וּ אִֽישׁ־אֶת־אָחִ֛יו וְאִ֥ישׁ אֶת־רֵעֵ֖הוּ וְאִ֥ישׁ אֶת־קְרֹבֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","וַיַּֽעֲשׂ֥וּ בְנֵֽי־לֵוִ֖י כִּדְבַ֣ר מֹשֶׁ֑ה וַיִּפֹּ֤ל מִן־הָעָם֙ בַּיֹּ֣ום הַה֔וּא כִּשְׁלֹ֥שֶׁת אַלְפֵ֖י אִֽישׁ׃ ");
INSERT INTO hbo_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","וַיֹּ֣אמֶר מֹשֶׁ֗ה מִלְא֨וּ יֶדְכֶ֤ם הַיֹּום֙ לַֽיהוָ֔ה כִּ֛י אִ֥ישׁ בִּבְנֹ֖ו וּבְאָחִ֑יו וְלָתֵ֧ת עֲלֵיכֶ֛ם הַיֹּ֖ום בְּרָכָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","וַיְהִי֙ מִֽמָּחֳרָ֔ת וַיֹּ֤אמֶר מֹשֶׁה֙ אֶל־הָעָ֔ם אַתֶּ֥ם חֲטָאתֶ֖ם חֲטָאָ֣ה גְדֹלָ֑ה וְעַתָּה֙ אֽ͏ֶעֱלֶ֣ה אֶל־יְהוָ֔ה אוּלַ֥י אֲכַפְּרָ֖ה בְּעַ֥ד חַטַּאתְכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","וַיָּ֧שָׁב מֹשֶׁ֛ה אֶל־יְהוָ֖ה וַיֹּאמַ֑ר אָ֣נָּ֗א חָטָ֞א הָעָ֤ם הַזֶּה֙ חֲטָאָ֣ה גְדֹלָ֔ה וַיַּֽעֲשׂ֥וּ לָהֶ֖ם אֱלֹהֵ֥י זָהָֽב׃ ");
INSERT INTO hbo_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","וְעַתָּ֖ה אִם־תִּשָּׂ֣א חַטָּאתָ֑ם וְאִם־אַ֕יִן מְחֵ֣נִי נָ֔א מִֽסִּפְרְךָ֖ אֲשֶׁ֥ר כָּתָֽבְתָּ׃ ");
INSERT INTO hbo_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","וַיֹּ֥אמֶר יְהוָ֖ה אֶל־מֹשֶׁ֑ה מִ֚י אֲשֶׁ֣ר חָֽטָא־לִ֔י אֶמְחֶ֖נּוּ מִסִּפְרִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","וְעַתָּ֞ה לֵ֣ךְ ׀ נְחֵ֣ה אֶת־הָעָ֗ם אֶ֤ל אֲשֶׁר־דִּבַּ֙רְתִּי֙ לָ֔ךְ הִנֵּ֥ה מַלְאָכִ֖י יֵלֵ֣ךְ לְפָנֶ֑יךָ וּבְיֹ֣ום פָּקְדִ֔י וּפָקַדְתִּ֥י עֲלֵיהֶ֖ם חַטָּאתָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","וַיִּגֹּ֥ף יְהוָ֖ה אֶת־הָעָ֑ם עַ֚ל אֲשֶׁ֣ר עָשׂ֣וּ אֶת־הָעֵ֔גֶל אֲשֶׁ֥ר עָשָׂ֖ה אַהֲרֹֽן׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","וַיְדַבֵּ֨ר יְהוָ֤ה אֶל־מֹשֶׁה֙ לֵ֣ךְ עֲלֵ֣ה מִזֶּ֔ה אַתָּ֣ה וְהָעָ֔ם אֲשֶׁ֥ר הֽ͏ֶעֱלִ֖יתָ מֵאֶ֣רֶץ מִצְרָ֑יִם אֶל־הָאָ֗רֶץ אֲשֶׁ֣ר נִ֠שְׁבַּעְתִּי לְאַבְרָהָ֨ם לְיִצְחָ֤ק וּֽלְיַעֲקֹב֙ לֵאמֹ֔ר לְזַרְעֲךָ֖ אֶתְּנֶֽנָּה׃ ");
INSERT INTO hbo_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","וְשָׁלַחְתִּ֥י לְפָנֶ֖יךָ מַלְאָ֑ךְ וְגֵֽרַשְׁתִּ֗י אֶת־הַֽכְּנַעֲנִי֙ הָֽאֱמֹרִ֔י וְהַֽחִתִּי֙ וְהַפְּרִזִּ֔י הַחִוִּ֖י וְהַיְבוּסִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","אֶל־אֶ֛רֶץ זָבַ֥ת חָלָ֖ב וּדְבָ֑שׁ כִּי֩ לֹ֨א אֶֽעֱלֶ֜ה בְּקִרְבְּךָ֗ כִּ֤י עַם־קְשֵׁה־עֹ֙רֶף֙ אַ֔תָּה פֶּן־אֲכֶלְךָ֖ בַּדָּֽרֶךְ׃ ");
INSERT INTO hbo_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","וַיִּשְׁמַ֣ע הָעָ֗ם אֶת־הַדָּבָ֥ר הָרָ֛ע הַזֶּ֖ה וַיִּתְאַבָּ֑לוּ וְלֹא־שָׁ֛תוּ אִ֥ישׁ עֶדְיֹ֖ו עָלָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","וַיֹּ֨אמֶר יְהוָ֜ה אֶל־מֹשֶׁ֗ה אֱמֹ֤ר אֶל־בְּנֵֽי־יִשְׂרָאֵל֙ אַתֶּ֣ם עַם־קְשֵׁה־עֹ֔רֶף רֶ֧גַע אֶחָ֛ד אֽ͏ֶעֱלֶ֥ה בְקִרְבְּךָ֖ וְכִלִּיתִ֑יךָ וְעַתָּ֗ה הֹורֵ֤ד עֶדְיְךָ֙ מֵֽעָלֶ֔יךָ וְאֵדְעָ֖ה מָ֥ה אֶֽעֱשֶׂה־לָּֽךְ׃ ");
INSERT INTO hbo_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","וַיִּֽתְנַצְּל֧וּ בְנֵֽי־יִשְׂרָאֵ֛ל אֶת־עֶדְיָ֖ם מֵהַ֥ר חֹורֵֽב׃ ");
INSERT INTO hbo_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","וּמֹשֶׁה֩ יִקַּ֨ח אֶת־הָאֹ֜הֶל וְנָֽטָה־לֹ֣ו ׀ מִח֣וּץ לַֽמַּחֲנֶ֗ה הַרְחֵק֙ מִן־הַֽמַּחֲנֶ֔ה וְקָ֥רָא לֹ֖ו אֹ֣הֶל מֹועֵ֑ד וְהָיָה֙ כָּל־מְבַקֵּ֣שׁ יְהוָ֔ה יֵצֵא֙ אֶל־אֹ֣הֶל מֹועֵ֔ד אֲשֶׁ֖ר מִח֥וּץ לַֽמַּחֲנֶֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","וְהָיָ֗ה כְּצֵ֤את מֹשֶׁה֙ אֶל־הָאֹ֔הֶל יָק֙וּמוּ֙ כָּל־הָעָ֔ם וְנִ֨צְּב֔וּ אִ֖ישׁ פֶּ֣תַח אָהֳלֹ֑ו וְהִבִּ֙יטוּ֙ אַחֲרֵ֣י מֹשֶׁ֔ה עַד־בֹּאֹ֖ו הָאֹֽהֱלָה׃ ");
INSERT INTO hbo_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","וְהָיָ֗ה כְּבֹ֤א מֹשֶׁה֙ הָאֹ֔הֱלָה יֵרֵד֙ עַמּ֣וּד הֶֽעָנָ֔ן וְעָמַ֖ד פֶּ֣תַח הָאֹ֑הֶל וְדִבֶּ֖ר עִם־מֹשֶֽׁה׃ ");
INSERT INTO hbo_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","וְרָאָ֤ה כָל־הָעָם֙ אֶת־עַמּ֣וּד הֶֽעָנָ֔ן עֹמֵ֖ד פֶּ֣תַח הָאֹ֑הֶל וְקָ֤ם כָּל־הָעָם֙ וְהִֽשְׁתַּחֲוּ֔וּ אִ֖ישׁ פֶּ֥תַח אָהֳלֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","וְדִבֶּ֨ר יְהוָ֤ה אֶל־מֹשֶׁה֙ פָּנִ֣ים אֶל־פָּנִ֔ים כַּאֲשֶׁ֛ר יְדַבֵּ֥ר אִ֖ישׁ אֶל־רֵעֵ֑הוּ וְשָׁב֙ אֶל־הַֽמַּחֲנֶ֔ה וּמְשָׁ֨רְתֹ֜ו יְהֹושֻׁ֤עַ בִּן־נוּן֙ נַ֔עַר לֹ֥א יָמִ֖ישׁ מִתֹּ֥וךְ הָאֹֽהֶל׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","וַיֹּ֨אמֶר מֹשֶׁ֜ה אֶל־יְהוָ֗ה רְ֠אֵה אַתָּ֞ה אֹמֵ֤ר אֵלַי֙ הַ֚עַל אֶת־הָעָ֣ם הַזֶּ֔ה וְאַתָּה֙ לֹ֣א הֹֽודַעְתַּ֔נִי אֵ֥ת אֲשֶׁר־תִּשְׁלַ֖ח עִמִּ֑י וְאַתָּ֤ה אָמַ֙רְתָּ֙ יְדַעְתִּ֣יךָֽ בְשֵׁ֔ם וְגַם־מָצָ֥אתָ חֵ֖ן בְּעֵינָֽי׃ ");
INSERT INTO hbo_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","וְעַתָּ֡ה אִם־נָא֩ מָצָ֨אתִי חֵ֜ן בְּעֵינֶ֗יךָ הֹודִעֵ֤נִי נָא֙ אֶת־דְּרָכֶ֔ךָ וְאֵדָ֣עֲךָ֔ לְמַ֥עַן אֶמְצָא־חֵ֖ן בְּעֵינֶ֑יךָ וּרְאֵ֕ה כִּ֥י עַמְּךָ֖ הַגֹּ֥וי הַזֶּֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","וַיֹּאמַ֑ר פָּנַ֥י יֵלֵ֖כוּ וַהֲנִחֹ֥תִי לָֽךְ׃ ");
INSERT INTO hbo_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","וַיֹּ֖אמֶר אֵלָ֑יו אִם־אֵ֤ין פָּנֶ֙יךָ֙ הֹלְכִ֔ים אַֽל־תַּעֲלֵ֖נוּ מִזֶּֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","וּבַמֶּ֣ה ׀ יִוָּדַ֣ע אֵפֹ֗וא כִּֽי־מָצָ֨אתִי חֵ֤ן בְּעֵינֶ֙יךָ֙ אֲנִ֣י וְעַמֶּ֔ךָ הֲלֹ֖וא בְּלֶכְתְּךָ֣ עִמָּ֑נוּ וְנִפְלֵ֙ינוּ֙ אֲנִ֣י וְעַמְּךָ֔ מִכָּ֨ל־הָעָ֔ם אֲשֶׁ֖ר עַל־פְּנֵ֥י הָאֲדָמָֽה׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","וַיֹּ֤אמֶר יְהוָה֙ אֶל־מֹשֶׁ֔ה גַּ֣ם אֶת־הַדָּבָ֥ר הַזֶּ֛ה אֲשֶׁ֥ר דִּבַּ֖רְתָּ אֶֽעֱשֶׂ֑ה כִּֽי־מָצָ֤אתָ חֵן֙ בְּעֵינַ֔י וָאֵדָעֲךָ֖ בְּשֵֽׁם׃ ");
INSERT INTO hbo_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","וַיֹּאמַ֑ר הַרְאֵ֥נִי נָ֖א אֶת־כְּבֹדֶֽךָ׃ ");
INSERT INTO hbo_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","וַיֹּ֗אמֶר אֲנִ֨י אַעֲבִ֤יר כָּל־טוּבִי֙ עַל־פָּנֶ֔יךָ וְקָרָ֧אתִֽי בְשֵׁ֛ם יְהוָ֖ה לְפָנֶ֑יךָ וְחַנֹּתִי֙ אֶת־אֲשֶׁ֣ר אָחֹ֔ן וְרִחַמְתִּ֖י אֶת־אֲשֶׁ֥ר אֲרַחֵֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","וַיֹּ֕אמֶר לֹ֥א תוּכַ֖ל לִרְאֹ֣ת אֶת־פָּנָ֑י כִּ֛י לֹֽא־יִרְאַ֥נִי הָאָדָ֖ם וָחָֽי׃ ");
INSERT INTO hbo_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","וַיֹּ֣אמֶר יְהוָ֔ה הִנֵּ֥ה מָקֹ֖ום אִתִּ֑י וְנִצַּבְתָּ֖ עַל־הַצּֽוּר׃ ");
INSERT INTO hbo_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","וְהָיָה֙ בַּעֲבֹ֣ר כְּבֹדִ֔י וְשַׂמְתִּ֖יךָ בְּנִקְרַ֣ת הַצּ֑וּר וְשַׂכֹּתִ֥י כַפִּ֛י עָלֶ֖יךָ עַד־עָבְרִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","וַהֲסִרֹתִי֙ אֶת־כַּפִּ֔י וְרָאִ֖יתָ אֶת־אֲחֹרָ֑י וּפָנַ֖י לֹ֥א יֵרָאֽוּ׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","וַיֹּ֤אמֶר יְהוָה֙ אֶל־מֹשֶׁ֔ה פְּסָל־לְךָ֛ שְׁנֵֽי־לֻחֹ֥ת אֲבָנִ֖ים כָּרִאשֹׁנִ֑ים וְכָתַבְתִּי֙ עַל־הַלֻּחֹ֔ת אֶת־הַדְּבָרִ֔ים אֲשֶׁ֥ר הָי֛וּ עַל־הַלֻּחֹ֥ת הָרִאשֹׁנִ֖ים אֲשֶׁ֥ר שִׁבַּֽרְתָּ׃ ");
INSERT INTO hbo_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","וֶהְיֵ֥ה נָכֹ֖ון לַבֹּ֑קֶר וְעָלִ֤יתָ בַבֹּ֙קֶר֙ אֶל־הַ֣ר סִינַ֔י וְנִצַּבְתָּ֥ לִ֛י שָׁ֖ם עַל־רֹ֥אשׁ הָהָֽר׃ ");
INSERT INTO hbo_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","וְאִישׁ֙ לֹֽא־יַעֲלֶ֣ה עִמָּ֔ךְ וְגַם־אִ֥ישׁ אַל־יֵרָ֖א בְּכָל־הָהָ֑ר גַּם־הַצֹּ֤אן וְהַבָּקָר֙ אַל־יִרְע֔וּ אֶל־מ֖וּל הָהָ֥ר הַהֽוּא׃ ");
INSERT INTO hbo_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","וַיִּפְסֹ֡ל שְׁנֵֽי־לֻחֹ֨ת אֲבָנִ֜ים כָּרִאשֹׁנִ֗ים וַיַּשְׁכֵּ֨ם מֹשֶׁ֤ה בַבֹּ֙קֶר֙ וַיַּ֙עַל֙ אֶל־הַ֣ר סִינַ֔י כַּאֲשֶׁ֛ר צִוָּ֥ה יְהוָ֖ה אֹתֹ֑ו וַיִּקַּ֣ח בְּיָדֹ֔ו שְׁנֵ֖י לֻחֹ֥ת אֲבָנִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","וַיֵּ֤רֶד יְהוָה֙ בֶּֽעָנָ֔ן וַיִּתְיַצֵּ֥ב עִמֹּ֖ו שָׁ֑ם וַיִּקְרָ֥א בְשֵׁ֖ם יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","וַיַּעֲבֹ֨ר יְהוָ֥ה ׀ עַל־פָּנָיו֮ וַיִּקְרָא֒ יְהוָ֣ה ׀ יְהוָ֔ה אֵ֥ל רַח֖וּם וְחַנּ֑וּן אֶ֥רֶךְ אַפַּ֖יִם וְרַב־חֶ֥סֶד וֶאֱמֶֽת׃ ");
INSERT INTO hbo_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","נֹצֵ֥ר חֶ֙סֶד֙ לָאֲלָפִ֔ים נֹשֵׂ֥א עָוֹ֛ן וָפֶ֖שַׁע וְחַטָּאָ֑ה וְנַקֵּה֙ לֹ֣א יְנַקֶּ֔ה פֹּקֵ֣ד ׀ עֲוֹ֣ן אָבֹ֗ות עַל־בָּנִים֙ וְעַל־בְּנֵ֣י בָנִ֔ים עַל־שִׁלֵּשִׁ֖ים וְעַל־רִבֵּעִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","וַיְמַהֵ֖ר מֹשֶׁ֑ה וַיִּקֹּ֥ד אַ֖רְצָה וַיִּשְׁתָּֽחוּ׃ ");
INSERT INTO hbo_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","וַיֹּ֡אמֶר אִם־נָא֩ מָצָ֨אתִי חֵ֤ן בְּעֵינֶ֙יךָ֙ אֲדֹנָ֔י יֵֽלֶךְ־נָ֥א אֲדֹנָ֖י בְּקִרְבֵּ֑נוּ כִּ֤י עַם־קְשֵׁה־עֹ֙רֶף֙ ה֔וּא וְסָלַחְתָּ֛ לַעֲוֹנֵ֥נוּ וּלְחַטָּאתֵ֖נוּ וּנְחַלְתָּֽנוּ׃ ");
INSERT INTO hbo_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","וַיֹּ֗אמֶר הִנֵּ֣ה אָנֹכִי֮ כֹּרֵ֣ת בְּרִית֒ נֶ֤גֶד כָּֽל־עַמְּךָ֙ אֶעֱשֶׂ֣ה נִפְלָאֹ֔ת אֲשֶׁ֛ר לֹֽא־נִבְרְא֥וּ בְכָל־הָאָ֖רֶץ וּבְכָל־הַגֹּויִ֑ם וְרָאָ֣ה כָל־הָ֠עָם אֲשֶׁר־אַתָּ֨ה בְקִרְבֹּ֜ו אֶת־מַעֲשֵׂ֤ה יְהוָה֙ כִּֽי־נֹורָ֣א ה֔וּא אֲשֶׁ֥ר אֲנִ֖י עֹשֶׂ֥ה עִמָּֽךְ׃ ");
INSERT INTO hbo_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","שְׁמָ֨ר־לְךָ֔ אֵ֛ת אֲשֶׁ֥ר אָנֹכִ֖י מְצַוְּךָ֣ הַיֹּ֑ום הִנְנִ֧י גֹרֵ֣שׁ מִפָּנֶ֗יךָ אֶת־הָאֱמֹרִי֙ וְהַֽכְּנַעֲנִ֔י וְהַחִתִּי֙ וְהַפְּרִזִּ֔י וְהַחִוִּ֖י וְהַיְבוּסִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","הִשָּׁ֣מֶר לְךָ֗ פֶּן־תִּכְרֹ֤ת בְּרִית֙ לְיֹושֵׁ֣ב הָאָ֔רֶץ אֲשֶׁ֥ר אַתָּ֖ה בָּ֣א עָלֶ֑יהָ פֶּן־יִהְיֶ֥ה לְמֹוקֵ֖שׁ בְּקִרְבֶּֽךָ׃ ");
INSERT INTO hbo_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","כִּ֤י אֶת־מִזְבְּחֹתָם֙ תִּתֹּצ֔וּן וְאֶת־מַצֵּבֹתָ֖ם תְּשַׁבֵּר֑וּן וְאֶת־אֲשֵׁרָ֖יו תִּכְרֹתֽוּן׃ ");
INSERT INTO hbo_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","כִּ֛י לֹ֥א תִֽשְׁתַּחֲוֶ֖ה לְאֵ֣ל אַחֵ֑ר כִּ֤י יְהוָה֙ קַנָּ֣א שְׁמֹ֔ו אֵ֥ל קַנָּ֖א הֽוּא׃ ");
INSERT INTO hbo_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","פֶּן־תִּכְרֹ֥ת בְּרִ֖ית לְיֹושֵׁ֣ב הָאָ֑רֶץ וְזָנ֣וּ ׀ אַחֲרֵ֣י אֱלֹֽהֵיהֶ֗ם וְזָבְחוּ֙ לֵאלֹ֣הֵיהֶ֔ם וְקָרָ֣א לְךָ֔ וְאָכַלְתָּ֖ מִזִּבְחֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","וְלָקַחְתָּ֥ מִבְּנֹתָ֖יו לְבָנֶ֑יךָ וְזָנ֣וּ בְנֹתָ֗יו אַחֲרֵי֙ אֱלֹ֣הֵיהֶ֔ן וְהִזְנוּ֙ אֶת־בָּנֶ֔יךָ אַחֲרֵ֖י אֱלֹהֵיהֶֽן׃ ");
INSERT INTO hbo_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","אֱלֹהֵ֥י מַסֵּכָ֖ה לֹ֥א תַעֲשֶׂה־לָּֽךְ׃ ");
INSERT INTO hbo_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","אֶת־חַ֣ג הַמַּצֹּות֮ תִּשְׁמֹר֒ שִׁבְעַ֨ת יָמִ֜ים תֹּאכַ֤ל מַצֹּות֙ אֲשֶׁ֣ר צִוִּיתִ֔ךָ לְמֹועֵ֖ד חֹ֣דֶשׁ הָאָבִ֑יב כִּ֚י בְּחֹ֣דֶשׁ הָֽאָבִ֔יב יָצָ֖אתָ מִמִּצְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","כָּל־פֶּ֥טֶר רֶ֖חֶם לִ֑י וְכָֽל־מִקְנְךָ֙ תִּזָּכָ֔ר פֶּ֖טֶר שֹׁ֥ור וָשֶֽׂה׃ ");
INSERT INTO hbo_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","וּפֶ֤טֶר חֲמֹור֙ תִּפְדֶּ֣ה בְשֶׂ֔ה וְאִם־לֹ֥א תִפְדֶּ֖ה וַעֲרַפְתֹּ֑ו כֹּ֣ל בְּכֹ֤ור בָּנֶ֙יךָ֙ תִּפְדֶּ֔ה וְלֹֽא־יֵרָא֥וּ פָנַ֖י רֵיקָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","שֵׁ֤שֶׁת יָמִים֙ תַּעֲבֹ֔ד וּבַיֹּ֥ום הַשְּׁבִיעִ֖י תִּשְׁבֹּ֑ת בֶּחָרִ֥ישׁ וּבַקָּצִ֖יר תִּשְׁבֹּֽת׃ ");
INSERT INTO hbo_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","וְחַ֤ג שָׁבֻעֹת֙ תַּעֲשֶׂ֣ה לְךָ֔ בִּכּוּרֵ֖י קְצִ֣יר חִטִּ֑ים וְחַג֙ הָֽאָסִ֔יף תְּקוּפַ֖ת הַשָּׁנָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","שָׁלֹ֥שׁ פְּעָמִ֖ים בַּשָּׁנָ֑ה יֵרָאֶה֙ כָּל־זְכ֣וּרְךָ֔ אֶת־פְּנֵ֛י הָֽאָדֹ֥ן ׀ יְהוָ֖ה אֱלֹהֵ֥י יִשְׂרָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","כִּֽי־אֹורִ֤ישׁ גֹּויִם֙ מִפָּנֶ֔יךָ וְהִרְחַבְתִּ֖י אֶת־גְּבוּלֶ֑ךָ וְלֹא־יַחְמֹ֥ד אִישׁ֙ אֶֽת־אַרְצְךָ֔ בַּעֲלֹֽתְךָ֗ לֵרָאֹות֙ אֶת־פְּנֵי֙ יְהוָ֣ה אֱלֹהֶ֔יךָ שָׁלֹ֥שׁ פְּעָמִ֖ים בַּשָּׁנָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","לֹֽא־תִשְׁחַ֥ט עַל־חָמֵ֖ץ דַּם־זִבְחִ֑י וְלֹא־יָלִ֣ין לַבֹּ֔קֶר זֶ֖בַח חַ֥ג הַפָּֽסַח׃ ");
INSERT INTO hbo_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","רֵאשִׁ֗ית בִּכּוּרֵי֙ אַדְמָ֣תְךָ֔ תָּבִ֕יא בֵּ֖ית יְהוָ֣ה אֱלֹהֶ֑יךָ לֹא־תְבַשֵּׁ֥ל גְּדִ֖י בַּחֲלֵ֥ב אִמֹּֽו׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","וַיֹּ֤אמֶר יְהוָה֙ אֶל־מֹשֶׁ֔ה כְּתָב־לְךָ֖ אֶת־הַדְּבָרִ֣ים הָאֵ֑לֶּה כִּ֞י עַל־פִּ֣י ׀ הַדְּבָרִ֣ים הָאֵ֗לֶּה כָּרַ֧תִּי אִתְּךָ֛ בְּרִ֖ית וְאֶת־יִשְׂרָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","וֽ͏ַיְהִי־שָׁ֣ם עִם־יְהוָ֗ה אַרְבָּעִ֥ים יֹום֙ וְאַרְבָּעִ֣ים לַ֔יְלָה לֶ֚חֶם לֹ֣א אָכַ֔ל וּמַ֖יִם לֹ֣א שָׁתָ֑ה וַיִּכְתֹּ֣ב עַל־הַלֻּחֹ֗ת אֵ֚ת דִּבְרֵ֣י הַבְּרִ֔ית עֲשֶׂ֖רֶת הַדְּבָרִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","וַיְהִ֗י בְּרֶ֤דֶת מֹשֶׁה֙ מֵהַ֣ר סִינַ֔י וּשְׁנֵ֨י לֻחֹ֤ת הָֽעֵדֻת֙ בְּיַד־מֹשֶׁ֔ה בְּרִדְתֹּ֖ו מִן־הָהָ֑ר וּמֹשֶׁ֣ה לֹֽא־יָדַ֗ע כִּ֥י קָרַ֛ן עֹ֥ור פָּנָ֖יו בְּדַבְּרֹ֥ו אִתֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","וַיַּ֨רְא אַהֲרֹ֜ן וְכָל־בְּנֵ֤י יִשְׂרָאֵל֙ אֶת־מֹשֶׁ֔ה וְהִנֵּ֥ה קָרַ֖ן עֹ֣ור פָּנָ֑יו וַיִּֽירְא֖וּ מִגֶּ֥שֶׁת אֵלָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","וַיִּקְרָ֤א אֲלֵהֶם֙ מֹשֶׁ֔ה וַיָּשֻׁ֧בוּ אֵלָ֛יו אַהֲרֹ֥ן וְכָל־הַנְּשִׂאִ֖ים בָּעֵדָ֑ה וַיְדַבֵּ֥ר מֹשֶׁ֖ה אֲלֵהֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","וְאַחֲרֵי־כֵ֥ן נִגְּשׁ֖וּ כָּל־בְּנֵ֣י יִשְׂרָאֵ֑ל וַיְצַוֵּ֕ם אֵת֩ כָּל־אֲשֶׁ֨ר דִּבֶּ֧ר יְהוָ֛ה אִתֹּ֖ו בְּהַ֥ר סִינָֽי׃ ");
INSERT INTO hbo_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","וַיְכַ֣ל מֹשֶׁ֔ה מִדַּבֵּ֖ר אִתָּ֑ם וַיִּתֵּ֥ן עַל־פָּנָ֖יו מַסְוֶֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","וּבְבֹ֨א מֹשֶׁ֜ה לִפְנֵ֤י יְהוָה֙ לְדַבֵּ֣ר אִתֹּ֔ו יָסִ֥יר אֶת־הַמַּסְוֶ֖ה עַד־צֵאתֹ֑ו וְיָצָ֗א וְדִבֶּר֙ אֶל־בְּנֵ֣י יִשְׂרָאֵ֔ל אֵ֖ת אֲשֶׁ֥ר יְצֻוֶּֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","וְרָא֤וּ בְנֵֽי־יִשְׂרָאֵל֙ אֶת־פְּנֵ֣י מֹשֶׁ֔ה כִּ֣י קָרַ֔ן עֹ֖ור פְּנֵ֣י מֹשֶׁ֑ה וְהֵשִׁ֨יב מֹשֶׁ֤ה אֶת־הַמַּסְוֶה֙ עַל־פָּנָ֔יו עַד־בֹּאֹ֖ו לְדַבֵּ֥ר אִתֹּֽו׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","וַיַּקְהֵ֣ל מֹשֶׁ֗ה אֶֽת־כָּל־עֲדַ֛ת בְּנֵ֥י יִשְׂרָאֵ֖ל וַיֹּ֣אמֶר אֲלֵהֶ֑ם אֵ֚לֶּה הַדְּבָרִ֔ים אֲשֶׁר־צִוָּ֥ה יְהוָ֖ה לַעֲשֹׂ֥ת אֹתָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","שֵׁ֣שֶׁת יָמִים֮ תֵּעָשֶׂ֣ה מְלָאכָה֒ וּבַיֹּ֣ום הַשְּׁבִיעִ֗י יִהְיֶ֨ה לָכֶ֥ם קֹ֛דֶשׁ שַׁבַּ֥ת שַׁבָּתֹ֖ון לַיהוָ֑ה כָּל־הָעֹשֶׂ֥ה בֹ֛ו מְלָאכָ֖ה יוּמָֽת׃ ");
INSERT INTO hbo_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","לֹא־תְבַעֲר֣וּ אֵ֔שׁ בְּכֹ֖ל מֹשְׁבֹֽתֵיכֶ֑ם בְּיֹ֖ום הַשַּׁבָּֽת׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","וַיֹּ֣אמֶר מֹשֶׁ֔ה אֶל־כָּל־עֲדַ֥ת בְּנֵֽי־יִשְׂרָאֵ֖ל לֵאמֹ֑ר זֶ֣ה הַדָּבָ֔ר אֲשֶׁר־צִוָּ֥ה יְהוָ֖ה לֵאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","קְח֨וּ מֵֽאִתְּכֶ֤ם תְּרוּמָה֙ לַֽיהוָ֔ה כֹּ֚ל נְדִ֣יב לִבֹּ֔ו יְבִיאֶ֕הָ אֵ֖ת תְּרוּמַ֣ת יְהוָ֑ה זָהָ֥ב וָכֶ֖סֶף וּנְחֹֽשֶׁת׃ ");
INSERT INTO hbo_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","וּתְכֵ֧לֶת וְאַרְגָּמָ֛ן וְתֹולַ֥עַת שָׁנִ֖י וְשֵׁ֥שׁ וְעִזִּֽים׃ ");
INSERT INTO hbo_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","וְעֹרֹ֨ת אֵילִ֧ם מְאָדָּמִ֛ים וְעֹרֹ֥ת תְּחָשִׁ֖ים וַעֲצֵ֥י שִׂטִּֽים׃ ");
INSERT INTO hbo_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","וְשֶׁ֖מֶן לַמָּאֹ֑ור וּבְשָׂמִים֙ לְשֶׁ֣מֶן הַמִּשְׁחָ֔ה וְלִקְטֹ֖רֶת הַסַּמִּֽים׃ ");
INSERT INTO hbo_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","וְאַ֨בְנֵי־שֹׁ֔הַם וְאַבְנֵ֖י מִלֻּאִ֑ים לָאֵפֹ֖וד וְלַחֹֽשֶׁן׃ ");
INSERT INTO hbo_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","וְכָל־חֲכַם־לֵ֖ב בָּכֶ֑ם יָבֹ֣אוּ וְיַעֲשׂ֔וּ אֵ֛ת כָּל־אֲשֶׁ֥ר צִוָּ֖ה יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","אֶת־הַ֨מִּשְׁכָּ֔ן אֶֽת־אָהֳלֹ֖ו וְאֶת־מִכְסֵ֑הוּ אֶת־קְרָסָיו֙ וְאֶת־קְרָשָׁ֔יו אֶת־בְּרִיחָ֕ו אֶת־עַמֻּדָ֖יו וְאֶת־אֲדָנָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","אֶת־הָאָרֹ֥ן וְאֶת־בַּדָּ֖יו אֶת־הַכַּפֹּ֑רֶת וְאֵ֖ת פָּרֹ֥כֶת הַמָּסָֽךְ׃ ");
INSERT INTO hbo_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","אֶת־הַשֻּׁלְחָ֥ן וְאֶת־בַּדָּ֖יו וְאֶת־כָּל־כֵּלָ֑יו וְאֵ֖ת לֶ֥חֶם הַפָּנִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","וְאֶת־מְנֹרַ֧ת הַמָּאֹ֛ור וְאֶת־כֵּלֶ֖יהָ וְאֶת־נֵרֹתֶ֑יהָ וְאֵ֖ת שֶׁ֥מֶן הַמָּאֹֽור׃ ");
INSERT INTO hbo_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","וְאֶת־מִזְבַּ֤ח הַקְּטֹ֙רֶת֙ וְאֶת־בַּדָּ֔יו וְאֵת֙ שֶׁ֣מֶן הַמִּשְׁחָ֔ה וְאֵ֖ת קְטֹ֣רֶת הַסַּמִּ֑ים וְאֶת־מָסַ֥ךְ הַפֶּ֖תַח לְפֶ֥תַח הַמִּשְׁכָּֽן׃ ");
INSERT INTO hbo_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","אֵ֣ת ׀ מִזְבַּ֣ח הָעֹלָ֗ה וְאֶת־מִכְבַּ֤ר הַנְּחֹ֙שֶׁת֙ אֲשֶׁר־לֹ֔ו אֶת־בַּדָּ֖יו וְאֶת־כָּל־כֵּלָ֑יו אֶת־הַכִּיֹּ֖ר וְאֶת־כַּנֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","אֵ֚ת קַלְעֵ֣י הֶחָצֵ֔ר אֶת־עַמֻּדָ֖יו וְאֶת־אֲדָנֶ֑יהָ וְאֵ֕ת מָסַ֖ךְ שַׁ֥עַר הֶחָצֵֽר׃ ");
INSERT INTO hbo_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","אֶת־יִתְדֹ֧ת הַמִּשְׁכָּ֛ן וְאֶת־יִתְדֹ֥ת הֶחָצֵ֖ר וְאֶת־מֵיתְרֵיהֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","אֶת־בִּגְדֵ֥י הַשְּׂרָ֖ד לְשָׁרֵ֣ת בַּקֹּ֑דֶשׁ אֶת־בִּגְדֵ֤י הַקֹּ֙דֶשׁ֙ לְאַהֲרֹ֣ן הַכֹּהֵ֔ן וְאֶת־בִּגְדֵ֥י בָנָ֖יו לְכַהֵֽן׃ ");
INSERT INTO hbo_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","וַיֵּ֥צְא֛וּ כָּל־עֲדַ֥ת בְּנֽ͏ֵי־יִשְׂרָאֵ֖ל מִלִּפְנֵ֥י מֹשֶֽׁה׃ ");
INSERT INTO hbo_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","וַיָּבֹ֕אוּ כָּל־אִ֖ישׁ אֲשֶׁר־נְשָׂאֹ֣ו לִבֹּ֑ו וְכֹ֡ל אֲשֶׁר֩ נָדְבָ֨ה רוּחֹ֜ו אֹתֹ֗ו הֵ֠בִיאוּ אֶת־תְּרוּמַ֨ת יְהוָ֜ה לִמְלֶ֨אכֶת אֹ֤הֶל מֹועֵד֙ וּלְכָל־עֲבֹ֣דָתֹ֔ו וּלְבִגְדֵ֖י הַקֹּֽדֶשׁ׃ ");
INSERT INTO hbo_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","וַיָּבֹ֥אוּ הָאֲנָשִׁ֖ים עַל־הַנָּשִׁ֑ים כֹּ֣ל ׀ נְדִ֣יב לֵ֗ב הֵ֠בִיאוּ חָ֣ח וָנֶ֜זֶם וְטַבַּ֤עַת וְכוּמָז֙ כָּל־כְּלִ֣י זָהָ֔ב וְכָל־אִ֕ישׁ אֲשֶׁ֥ר הֵנִ֛יף תְּנוּפַ֥ת זָהָ֖ב לַיהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","וְכָל־אִ֞ישׁ אֲשֶׁר־נִמְצָ֣א אִתֹּ֗ו תְּכֵ֧לֶת וְאַרְגָּמָ֛ן וְתֹולַ֥עַת שָׁנִ֖י וְשֵׁ֣שׁ וְעִזִּ֑ים וְעֹרֹ֨ת אֵילִ֧ם מְאָדָּמִ֛ים וְעֹרֹ֥ת תְּחָשִׁ֖ים הֵבִֽיאוּ׃ ");
INSERT INTO hbo_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","כָּל־מֵרִ֗ים תְּר֤וּמַת כֶּ֙סֶף֙ וּנְחֹ֔שֶׁת הֵבִ֕יאוּ אֵ֖ת תְּרוּמַ֣ת יְהוָ֑ה וְכֹ֡ל אֲשֶׁר֩ נִמְצָ֨א אִתֹּ֜ו עֲצֵ֥י שִׁטִּ֛ים לְכָל־מְלֶ֥אכֶת הָעֲבֹדָ֖ה הֵבִֽיאוּ׃ ");
INSERT INTO hbo_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","וְכָל־אִשָּׁ֥ה חַכְמַת־לֵ֖ב בְּיָדֶ֣יהָ טָו֑וּ וַיָּבִ֣יאוּ מַטְוֶ֗ה אֶֽת־הַתְּכֵ֙לֶת֙ וְאֶת־הָֽאַרְגָּמָ֔ן אֶת־תֹּולַ֥עַת הַשָּׁנִ֖י וְאֶת־הַשֵּֽׁשׁ׃ ");
INSERT INTO hbo_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","וְכָל־הַ֨נָּשִׁ֔ים אֲשֶׁ֨ר נָשָׂ֥א לִבָּ֛ן אֹתָ֖נָה בְּחָכְמָ֑ה טָו֖וּ אֶת־הָעִזִּֽים׃ ");
INSERT INTO hbo_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","וְהַנְּשִׂאִ֣ם הֵבִ֔יאוּ אֵ֚ת אַבְנֵ֣י הַשֹּׁ֔הַם וְאֵ֖ת אַבְנֵ֣י הַמִּלֻּאִ֑ים לָאֵפֹ֖וד וְלַחֹֽשֶׁן׃ ");
INSERT INTO hbo_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","וְאֶת־הַבֹּ֖שֶׂם וְאֶת־הַשָּׁ֑מֶן לְמָאֹ֕ור וּלְשֶׁ֙מֶן֙ הַמִּשְׁחָ֔ה וְלִקְטֹ֖רֶת הַסַּמִּֽים׃ ");
INSERT INTO hbo_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","כָּל־אִ֣ישׁ וְאִשָּׁ֗ה אֲשֶׁ֨ר נָדַ֣ב לִבָּם֮ אֹתָם֒ לְהָבִיא֙ לְכָל־הַמְּלָאכָ֔ה אֲשֶׁ֨ר צִוָּ֧ה יְהוָ֛ה לַעֲשֹׂ֖ות בְּיַד־מֹשֶׁ֑ה הֵבִ֧יאוּ בְנֵי־יִשְׂרָאֵ֛ל נְדָבָ֖ה לַיהוָֽה׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","וַיֹּ֤אמֶר מֹשֶׁה֙ אֶל־בְּנֵ֣י יִשְׂרָאֵ֔ל רְא֛וּ קָרָ֥א יְהוָ֖ה בְּשֵׁ֑ם בְּצַלְאֵ֛ל בֶּן־אוּרִ֥י בֶן־ח֖וּר לְמַטֵּ֥ה יְהוּדָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","וַיְמַלֵּ֥א אֹתֹ֖ו ר֣וּחַ אֱלֹהִ֑ים בְּחָכְמָ֛ה בִּתְבוּנָ֥ה וּבְדַ֖עַת וּבְכָל־מְלָאכָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","וְלַחְשֹׁ֖ב מַֽחַשָׁבֹ֑ת לַעֲשֹׂ֛ת בַּזָּהָ֥ב וּבַכֶּ֖סֶף וּבַנְּחֹֽשֶׁת׃ ");
INSERT INTO hbo_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","וּבַחֲרֹ֥שֶׁת אֶ֛בֶן לְמַלֹּ֖את וּבַחֲרֹ֣שֶׁת עֵ֑ץ לַעֲשֹׂ֖ות בְּכָל־מְלֶ֥אכֶת מַחֲשָֽׁבֶת׃ ");
INSERT INTO hbo_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","וּלְהֹורֹ֖ת נָתַ֣ן בְּלִבֹּ֑ו ה֕וּא וְאָֽהֳלִיאָ֥ב בֶּן־אֲחִיסָמָ֖ךְ לְמַטֵּה־דָֽן׃ ");
INSERT INTO hbo_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","מִלֵּ֨א אֹתָ֜ם חָכְמַת־לֵ֗ב לַעֲשֹׂות֮ כָּל־מְלֶ֣אכֶת חָרָ֣שׁ ׀ וְחֹשֵׁב֒ וְרֹקֵ֞ם בַּתְּכֵ֣לֶת וּבָֽאַרְגָּמָ֗ן בְּתֹולַ֧עַת הַשָּׁנִ֛י וּבַשֵּׁ֖שׁ וְאֹרֵ֑ג עֹשֵׂי֙ כָּל־מְלָאכָ֔ה וְחֹשְׁבֵ֖י מַחֲשָׁבֹֽת׃ ");
INSERT INTO hbo_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","וְעָשָׂה֩ בְצַלְאֵ֨ל וְאָהֳלִיאָ֜ב וְכֹ֣ל ׀ אִ֣ישׁ חֲכַם־לֵ֗ב אֲשֶׁר֩ נָתַ֨ן יְהוָ֜ה חָכְמָ֤ה וּתְבוּנָה֙ בָּהֵ֔מָּה לָדַ֣עַת לַעֲשֹׂ֔ת אֶֽת־כָּל־מְלֶ֖אכֶת עֲבֹדַ֣ת הַקֹּ֑דֶשׁ לְכֹ֥ל אֲשֶׁר־צִוָּ֖ה יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","וַיִּקְרָ֣א מֹשֶׁ֗ה אֶל־בְּצַלְאֵל֮ וְאֶל־אָֽהֳלִיאָב֒ וְאֶל֙ כָּל־אִ֣ישׁ חֲכַם־לֵ֔ב אֲשֶׁ֨ר נָתַ֧ן יְהוָ֛ה חָכְמָ֖ה בְּלִבֹּ֑ו כֹּ֚ל אֲשֶׁ֣ר נְשָׂאֹ֣ו לִבֹּ֔ו לְקָרְבָ֥ה אֶל־הַמְּלָאכָ֖ה לַעֲשֹׂ֥ת אֹתָֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","וַיִּקְח֞וּ מִלִּפְנֵ֣י מֹשֶׁ֗ה אֵ֤ת כָּל־הַתְּרוּמָה֙ אֲשֶׁ֨ר הֵבִ֜יאוּ בְּנֵ֣י יִשְׂרָאֵ֗ל לִמְלֶ֛אכֶת עֲבֹדַ֥ת הַקֹּ֖דֶשׁ לַעֲשֹׂ֣ת אֹתָ֑הּ וְ֠הֵם הֵבִ֨יאוּ אֵלָ֥יו עֹ֛וד נְדָבָ֖ה בַּבֹּ֥קֶר בַּבֹּֽקֶר׃ ");
INSERT INTO hbo_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","וַיָּבֹ֙אוּ֙ כָּל־הַ֣חֲכָמִ֔ים הָעֹשִׂ֕ים אֵ֖ת כָּל־מְלֶ֣אכֶת הַקֹּ֑דֶשׁ אִֽישׁ־אִ֥ישׁ מִמְּלַאכְתֹּ֖ו אֲשֶׁר־הֵ֥מָּה עֹשִֽׂים׃ ");
INSERT INTO hbo_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","וַיֹּאמְרוּ֙ אֶל־מֹשֶׁ֣ה לֵּאמֹ֔ר מַרְבִּ֥ים הָעָ֖ם לְהָבִ֑יא מִדֵּ֤י הָֽעֲבֹדָה֙ לַמְּלָאכָ֔ה אֲשֶׁר־צִוָּ֥ה יְהוָ֖ה לַעֲשֹׂ֥ת אֹתָֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","וַיְצַ֣ו מֹשֶׁ֗ה וַיַּעֲבִ֨ירוּ קֹ֥ול בַּֽמַּחֲנֶה֮ לֵאמֹר֒ אִ֣ישׁ וְאִשָּׁ֗ה אַל־יַעֲשׂוּ־עֹ֛וד מְלָאכָ֖ה לִתְרוּמַ֣ת הַקֹּ֑דֶשׁ וַיִּכָּלֵ֥א הָעָ֖ם מֵהָבִֽיא׃ ");
INSERT INTO hbo_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","וְהַמְּלָאכָ֗ה הָיְתָ֥ה דַיָּ֛ם לְכָל־הַמְּלָאכָ֖ה לַעֲשֹׂ֣ות אֹתָ֑הּ וְהֹותֵֽר׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","וַיַּעֲשׂ֨וּ כָל־חֲכַם־לֵ֜ב בְּעֹשֵׂ֧י הַמְּלָאכָ֛ה אֶת־הַמִּשְׁכָּ֖ן עֶ֣שֶׂר יְרִיעֹ֑ת שֵׁ֣שׁ מָשְׁזָ֗ר וּתְכֵ֤לֶת וְאַרְגָּמָן֙ וְתֹולַ֣עַת שָׁנִ֔י כְּרֻבִ֛ים מַעֲשֵׂ֥ה חֹשֵׁ֖ב עָשָׂ֥ה אֹתָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","אֹ֜רֶךְ הַיְרִיעָ֣ה הָֽאַחַ֗ת שְׁמֹנֶ֤ה וְעֶשְׂרִים֙ בָּֽאַמָּ֔ה וְרֹ֙חַב֙ אַרְבַּ֣ע בָּֽאַמָּ֔ה הַיְרִיעָ֖ה הָאֶחָ֑ת מִדָּ֥ה אַחַ֖ת לְכָל־הַיְרִיעֹֽת׃ ");
INSERT INTO hbo_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","וַיְחַבֵּר֙ אֶת־חֲמֵ֣שׁ הַיְרִיעֹ֔ת אַחַ֖ת אֶל־אֶחָ֑ת וְחָמֵ֤שׁ יְרִיעֹת֙ חִבַּ֔ר אַחַ֖ת אֶל־אֶחָֽת׃ ");
INSERT INTO hbo_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","וַיַּ֜עַשׂ לֻֽלְאֹ֣ת תְּכֵ֗לֶת עַ֣ל שְׂפַ֤ת הַיְרִיעָה֙ הָֽאֶחָ֔ת מִקָּצָ֖ה בַּמַּחְבָּ֑רֶת כֵּ֤ן עָשָׂה֙ בִּשְׂפַ֣ת הַיְרִיעָ֔ה הַקִּ֣יצֹונָ֔ה בַּמַּחְבֶּ֖רֶת הַשֵּׁנִֽית׃ ");
INSERT INTO hbo_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","חֲמִשִּׁ֣ים לֻלָאֹ֗ת עָשָׂה֮ בַּיְרִיעָ֣ה הָאֶחָת֒ וַחֲמִשִּׁ֣ים לֻלָאֹ֗ת עָשָׂה֙ בִּקְצֵ֣ה הַיְרִיעָ֔ה אֲשֶׁ֖ר בַּמַּחְבֶּ֣רֶת הַשֵּׁנִ֑ית מַקְבִּילֹת֙ הַלֻּ֣לָאֹ֔ת אַחַ֖ת אֶל־אֶחָֽת׃ ");
INSERT INTO hbo_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","וַיַּ֕עַשׂ חֲמִשִּׁ֖ים קַרְסֵ֣י זָהָ֑ב וַיְחַבֵּ֨ר אֶת־הַיְרִעֹ֜ת אַחַ֤ת אֶל־אַחַת֙ בַּקְּרָסִ֔ים וַֽיְהִ֥י הַמִּשְׁכָּ֖ן אֶחָֽד׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","וַיַּ֙עַשׂ֙ יְרִיעֹ֣ת עִזִּ֔ים לְאֹ֖הֶל עַל־הַמִּשְׁכָּ֑ן עַשְׁתֵּֽי־עֶשְׂרֵ֥ה יְרִיעֹ֖ת עָשָׂ֥ה אֹתָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","אֹ֜רֶךְ הַיְרִיעָ֣ה הָאַחַ֗ת שְׁלֹשִׁים֙ בָּֽאַמָּ֔ה וְאַרְבַּ֣ע אַמֹּ֔ות רֹ֖חַב הַיְרִיעָ֣ה הָאֶחָ֑ת מִדָּ֣ה אַחַ֔ת לְעַשְׁתֵּ֥י עֶשְׂרֵ֖ה יְרִיעֹֽת׃ ");
INSERT INTO hbo_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","וַיְחַבֵּ֛ר אֶת־חֲמֵ֥שׁ הַיְרִיעֹ֖ת לְבָ֑ד וְאֶת־שֵׁ֥שׁ הַיְרִיעֹ֖ת לְבָֽד׃ ");
INSERT INTO hbo_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","וַיַּ֜עַשׂ לֻֽלָאֹ֣ת חֲמִשִּׁ֗ים עַ֚ל שְׂפַ֣ת הַיְרִיעָ֔ה הַקִּיצֹנָ֖ה בַּמַּחְבָּ֑רֶת וַחֲמִשִּׁ֣ים לֻלָאֹ֗ת עָשָׂה֙ עַל־שְׂפַ֣ת הַיְרִיעָ֔ה הַחֹבֶ֖רֶת הַשֵּׁנִֽית׃ ");
INSERT INTO hbo_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","וַיַּ֛עַשׂ קַרְסֵ֥י נְחֹ֖שֶׁת חֲמִשִּׁ֑ים לְחַבֵּ֥ר אֶת־הָאֹ֖הֶל לִהְיֹ֥ת אֶחָֽד׃ ");
INSERT INTO hbo_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","וַיַּ֤עַשׂ מִכְסֶה֙ לָאֹ֔הֶל עֹרֹ֥ת אֵלִ֖ים מְאָדָּמִ֑ים וּמִכְסֵ֛ה עֹרֹ֥ת תְּחָשִׁ֖ים מִלְמָֽעְלָה׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","וַיַּ֥עַשׂ אֶת־הַקְּרָשִׁ֖ים לַמִּשְׁכָּ֑ן עֲצֵ֥י שִׁטִּ֖ים עֹמְדִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","עֶ֥שֶׂר אַמֹּ֖ת אֹ֣רֶךְ הַקָּ֑רֶשׁ וְאַמָּה֙ וַחֲצִ֣י הָֽאַמָּ֔ה רֹ֖חַב הַקֶּ֥רֶשׁ הָאֶחָֽד׃ ");
INSERT INTO hbo_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","שְׁתֵּ֣י יָדֹ֗ת לַקֶּ֙רֶשׁ֙ הָֽאֶחָ֔ד מְשֻׁלָּבֹ֔ת אַחַ֖ת אֶל־אֶחָ֑ת כֵּ֣ן עָשָׂ֔ה לְכֹ֖ל קַרְשֵׁ֥י הַמִּשְׁכָּֽן׃ ");
INSERT INTO hbo_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","וַיַּ֥עַשׂ אֶת־הַקְּרָשִׁ֖ים לַמִּשְׁכָּ֑ן עֶשְׂרִ֣ים קְרָשִׁ֔ים לִפְאַ֖ת נֶ֥גֶב תֵּימָֽנָה׃ ");
INSERT INTO hbo_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","וְאַרְבָּעִים֙ אַדְנֵי־כֶ֔סֶף עָשָׂ֕ה תַּ֖חַת עֶשְׂרִ֣ים הַקְּרָשִׁ֑ים שְׁנֵ֨י אֲדָנִ֜ים תַּֽחַת־הַקֶּ֤רֶשׁ הָאֶחָד֙ לִשְׁתֵּ֣י יְדֹתָ֔יו וּשְׁנֵ֧י אֲדָנִ֛ים תַּֽחַת־הַקֶּ֥רֶשׁ הָאֶחָ֖ד לִשְׁתֵּ֥י יְדֹתָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","וּלְצֶ֧לַע הַמִּשְׁכָּ֛ן הַשֵּׁנִ֖ית לִפְאַ֣ת צָפֹ֑ון עָשָׂ֖ה עֶשְׂרִ֥ים קְרָשִֽׁים׃ ");
INSERT INTO hbo_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","וְאַרְבָּעִ֥ים אַדְנֵיהֶ֖ם כָּ֑סֶף שְׁנֵ֣י אֲדָנִ֗ים תַּ֚חַת הַקֶּ֣רֶשׁ הָאֶחָ֔ד וּשְׁנֵ֣י אֲדָנִ֔ים תַּ֖חַת הַקֶּ֥רֶשׁ הָאֶחָֽד׃ ");
INSERT INTO hbo_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","וּֽלְיַרְכְּתֵ֥י הַמִּשְׁכָּ֖ן יָ֑מָּה עָשָׂ֖ה שִׁשָּׁ֥ה קְרָשִֽׁים׃ ");
INSERT INTO hbo_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","וּשְׁנֵ֤י קְרָשִׁים֙ עָשָׂ֔ה לִמְקֻצְעֹ֖ת הַמִּשְׁכָּ֑ן בַּיַּרְכָתָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","וְהָי֣וּ תֹואֲמִם֮ מִלְּמַטָּה֒ וְיַחְדָּ֗ו יִהְי֤וּ תַמִּים֙ אֶל־רֹאשֹׁ֔ו אֶל־הַטַּבַּ֖עַת הָאֶחָ֑ת כֵּ֚ן עָשָׂ֣ה לִשְׁנֵיהֶ֔ם לִשְׁנֵ֖י הַמִּקְצֹעֹֽת׃ ");
INSERT INTO hbo_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","וְהָיוּ֙ שְׁמֹנָ֣ה קְרָשִׁ֔ים וְאַדְנֵיהֶ֣ם כֶּ֔סֶף שִׁשָּׁ֥ה עָשָׂ֖ר אֲדָנִ֑ים שְׁנֵ֤י אֲדָנִים֙ שְׁנֵ֣י אֲדָנִ֔ים תַּ֖חַת הַקֶּ֥רֶשׁ הָאֶחָֽד׃ ");
INSERT INTO hbo_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","וַיַּ֥עַשׂ בְּרִיחֵ֖י עֲצֵ֣י שִׁטִּ֑ים חֲמִשָּׁ֕ה לְקַרְשֵׁ֥י צֶֽלַע־הַמִּשְׁכָּ֖ן הָאֶחָֽת׃ ");
INSERT INTO hbo_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","וַחֲמִשָּׁ֣ה בְרִיחִ֔ם לְקַרְשֵׁ֥י צֶֽלַע־הַמִּשְׁכָּ֖ן הַשֵּׁנִ֑ית וַחֲמִשָּׁ֤ה בְרִיחִם֙ לְקַרְשֵׁ֣י הַמִּשְׁכָּ֔ן לַיַּרְכָתַ֖יִם יָֽמָּה׃ ");
INSERT INTO hbo_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","וַיַּ֖עַשׂ אֶת־הַבְּרִ֣יחַ הַתִּיכֹ֑ן לִבְרֹ֙חַ֙ בְּתֹ֣וךְ הַקְּרָשִׁ֔ים מִן־הַקָּצֶ֖ה אֶל־הַקָּצֶֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","וְֽאֶת־הַקְּרָשִׁ֞ים צִפָּ֣ה זָהָ֗ב וְאֶת־טַבְּעֹתָם֙ עָשָׂ֣ה זָהָ֔ב בָּתִּ֖ים לַבְּרִיחִ֑ם וַיְצַ֥ף אֶת־הַבְּרִיחִ֖ם זָהָֽב׃ ");
INSERT INTO hbo_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","וַיַּ֙עַשׂ֙ אֶת־הַפָּרֹ֔כֶת תְּכֵ֧לֶת וְאַרְגָּמָ֛ן וְתֹולַ֥עַת שָׁנִ֖י וְשֵׁ֣שׁ מָשְׁזָ֑ר מַעֲשֵׂ֥ה חֹשֵׁ֛ב עָשָׂ֥ה אֹתָ֖הּ כְּרֻבִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","וַיַּ֣עַשׂ לָ֗הּ אַרְבָּעָה֙ עַמּוּדֵ֣י שִׁטִּ֔ים וַיְצַפֵּ֣ם זָהָ֔ב וָוֵיהֶ֖ם זָהָ֑ב וַיִּצֹ֣ק לָהֶ֔ם אַרְבָּעָ֖ה אַדְנֵי־כָֽסֶף׃ ");
INSERT INTO hbo_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","וַיַּ֤עַשׂ מָסָךְ֙ לְפֶ֣תַח הָאֹ֔הֶל תְּכֵ֧לֶת וְאַרְגָּמָ֛ן וְתֹולַ֥עַת שָׁנִ֖י וְשֵׁ֣שׁ מָשְׁזָ֑ר מַעֲשֵׂ֖ה רֹקֵֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","וְאֶת־עַמּוּדָ֤יו חֲמִשָּׁה֙ וְאֶת־וָ֣וֵיהֶ֔ם וְצִפָּ֧ה רָאשֵׁיהֶ֛ם וַחֲשֻׁקֵיהֶ֖ם זָהָ֑ב וְאַדְנֵיהֶ֥ם חֲמִשָּׁ֖ה נְחֹֽשֶׁת׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","וַיַּ֧עַשׂ בְּצַלְאֵ֛ל אֶת־הָאָרֹ֖ן עֲצֵ֣י שִׁטִּ֑ים אַמָּתַ֨יִם וָחֵ֜צִי אָרְכֹּ֗ו וְאַמָּ֤ה וָחֵ֙צִי֙ רָחְבֹּ֔ו וְאַמָּ֥ה וָחֵ֖צִי קֹמָתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","וַיְצַפֵּ֛הוּ זָהָ֥ב טָהֹ֖ור מִבַּ֣יִת וּמִח֑וּץ וַיַּ֥עַשׂ לֹ֛ו זֵ֥ר זָהָ֖ב סָבִֽיב׃ ");
INSERT INTO hbo_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","וַיִּצֹ֣ק לֹ֗ו אַרְבַּע֙ טַבְּעֹ֣ת זָהָ֔ב עַ֖ל אַרְבַּ֣ע פַּעֲמֹתָ֑יו וּשְׁתֵּ֣י טַבָּעֹ֗ת עַל־צַלְעֹו֙ הָֽאֶחָ֔ת וּשְׁתֵּי֙ טַבָּעֹ֔ות עַל־צַלְעֹ֖ו הַשֵּׁנִֽית׃ ");
INSERT INTO hbo_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","וַיַּ֥עַשׂ בַּדֵּ֖י עֲצֵ֣י שִׁטִּ֑ים וַיְצַ֥ף אֹתָ֖ם זָהָֽב׃ ");
INSERT INTO hbo_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","וַיָּבֵ֤א אֶת־הַבַּדִּים֙ בַּטַּבָּעֹ֔ת עַ֖ל צַלְעֹ֣ת הָאָרֹ֑ן לָשֵׂ֖את אֶת־הָאָרֹֽן׃ ");
INSERT INTO hbo_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","וַיַּ֥עַשׂ כַּפֹּ֖רֶת זָהָ֣ב טָהֹ֑ור אַמָּתַ֤יִם וָחֵ֙צִי֙ אָרְכָּ֔הּ וְאַמָּ֥ה וָחֵ֖צִי רָחְבָּֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","וַיַּ֛עַשׂ שְׁנֵ֥י כְרֻבִ֖ים זָהָ֑ב מִקְשָׁה֙ עָשָׂ֣ה אֹתָ֔ם מִשְּׁנֵ֖י קְצֹ֥ות הַכַּפֹּֽרֶת׃ ");
INSERT INTO hbo_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","כְּרוּב־אֶחָ֤ד מִקָּצָה֙ מִזֶּ֔ה וּכְרוּב־אֶחָ֥ד מִקָּצָ֖ה מִזֶּ֑ה מִן־הַכַּפֹּ֛רֶת עָשָׂ֥ה אֶת־הַכְּרֻבִ֖ים מִשְּׁנֵ֥י *קִצְוֹותֹו (קְצֹותָֽיו)׃ ");
INSERT INTO hbo_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","וַיִּהְי֣וּ הַכְּרֻבִים֩ פֹּרְשֵׂ֨י כְנָפַ֜יִם לְמַ֗עְלָה סֹֽכְכִ֤ים בְּכַנְפֵיהֶם֙ עַל־הַכַּפֹּ֔רֶת וּפְנֵיהֶ֖ם אִ֣ישׁ אֶל־אָחִ֑יו אֶל־הַכַּפֹּ֔רֶת הָי֖וּ פְּנֵ֥י הַכְּרֻבִֽים׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","וַיַּ֥עַשׂ אֶת־הַשֻּׁלְחָ֖ן עֲצֵ֣י שִׁטִּ֑ים אַמָּתַ֤יִם אָרְכֹּו֙ וְאַמָּ֣ה רָחְבֹּ֔ו וְאַמָּ֥ה וָחֵ֖צִי קֹמָתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","וַיְצַ֥ף אֹתֹ֖ו זָהָ֣ב טָהֹ֑ור וַיַּ֥עַשׂ לֹ֛ו זֵ֥ר זָהָ֖ב סָבִֽיב׃ ");
INSERT INTO hbo_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","וַיַּ֨עַשׂ לֹ֥ו מִסְגֶּ֛רֶת טֹ֖פַח סָבִ֑יב וַיַּ֧עַשׂ זֵר־זָהָ֛ב לְמִסְגַּרְתֹּ֖ו סָבִֽיב׃ ");
INSERT INTO hbo_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","וַיִּצֹ֣ק לֹ֔ו אַרְבַּ֖ע טַבְּעֹ֣ת זָהָ֑ב וַיִּתֵּן֙ אֶת־הַטַּבָּעֹ֔ת עַ֚ל אַרְבַּ֣ע הַפֵּאֹ֔ת אֲשֶׁ֖ר לְאַרְבַּ֥ע רַגְלָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","לְעֻמַּת֙ הַמִּסְגֶּ֔רֶת הָי֖וּ הַטַּבָּעֹ֑ת בָּתִּים֙ לַבַּדִּ֔ים לָשֵׂ֖את אֶת־הַשֻּׁלְחָֽן׃ ");
INSERT INTO hbo_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","וַיַּ֤עַשׂ אֶת־הַבַּדִּים֙ עֲצֵ֣י שִׁטִּ֔ים וַיְצַ֥ף אֹתָ֖ם זָהָ֑ב לָשֵׂ֖את אֶת־הַשֻּׁלְחָֽן׃ ");
INSERT INTO hbo_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","וַיַּ֜עַשׂ אֶֽת־הַכֵּלִ֣ים ׀ אֲשֶׁ֣ר עַל־הַשֻּׁלְחָ֗ן אֶת־קְעָרֹתָ֤יו וְאֶת־כַּפֹּתָיו֙ וְאֵת֙ מְנַקִּיֹּתָ֔יו וְאֶת־הַקְּשָׂוֹ֔ת אֲשֶׁ֥ר יֻסַּ֖ךְ בָּהֵ֑ן זָהָ֖ב טָהֹֽור׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","וַיַּ֥עַשׂ אֶת־הַמְּנֹרָ֖ה זָהָ֣ב טָהֹ֑ור מִקְשָׁ֞ה עָשָׂ֤ה אֶת־הַמְּנֹרָה֙ יְרֵכָ֣הּ וְקָנָ֔הּ גְּבִיעֶ֛יהָ כַּפְתֹּרֶ֥יהָ וּפְרָחֶ֖יהָ מִמֶּ֥נָּה הָיֽוּ׃ ");
INSERT INTO hbo_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","וְשִׁשָּׁ֣ה קָנִ֔ים יֹצְאִ֖ים מִצִּדֶּ֑יהָ שְׁלֹשָׁ֣ה ׀ קְנֵ֣י מְנֹרָ֗ה מִצִּדָּהּ֙ הָֽאֶחָ֔ד וּשְׁלֹשָׁה֙ קְנֵ֣י מְנֹרָ֔ה מִצִּדָּ֖הּ הַשֵּׁנִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","שְׁלֹשָׁ֣ה גְ֠בִעִים מְֽשֻׁקָּדִ֞ים בַּקָּנֶ֣ה הָאֶחָד֮ כַּפְתֹּ֣ר וָפֶרַח֒ וּשְׁלֹשָׁ֣ה גְבִעִ֗ים מְשֻׁקָּדִ֛ים בְּקָנֶ֥ה אֶחָ֖ד כַּפְתֹּ֣ר וָפָ֑רַח כֵּ֚ן לְשֵׁ֣שֶׁת הַקָּנִ֔ים הַיֹּצְאִ֖ים מִן־הַמְּנֹרָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","וּבַמְּנֹרָ֖ה אַרְבָּעָ֣ה גְבִעִ֑ים מְשֻׁ֨קָּדִ֔ים כַּפְתֹּרֶ֖יהָ וּפְרָחֶֽיהָ׃ ");
INSERT INTO hbo_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","וְכַפְתֹּ֡ר תַּחַת֩ שְׁנֵ֨י הַקָּנִ֜ים מִמֶּ֗נָּה וְכַפְתֹּר֙ תַּ֣חַת שְׁנֵ֤י הַקָּנִים֙ מִמֶּ֔נָּה וְכַפְתֹּ֕ר תַּֽחַת־שְׁנֵ֥י הַקָּנִ֖ים מִמֶּ֑נָּה לְשֵׁ֙שֶׁת֙ הַקָּנִ֔ים הַיֹּצְאִ֖ים מִמֶּֽנָּה׃ ");
INSERT INTO hbo_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","כַּפְתֹּרֵיהֶ֥ם וּקְנֹתָ֖ם מִמֶּ֣נָּה הָי֑וּ כֻּלָּ֛הּ מִקְשָׁ֥ה אַחַ֖ת זָהָ֥ב טָהֹֽור׃ ");
INSERT INTO hbo_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","וַיַּ֥עַשׂ אֶת־נֵרֹתֶ֖יהָ שִׁבְעָ֑ה וּמַלְקָחֶ֥יהָ וּמַחְתֹּתֶ֖יהָ זָהָ֥ב טָהֹֽור׃ ");
INSERT INTO hbo_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","כִּכָּ֛ר זָהָ֥ב טָהֹ֖ור עָשָׂ֣ה אֹתָ֑הּ וְאֵ֖ת כָּל־כֵּלֶֽיהָ׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","וַיַּ֛עַשׂ אֶת־מִזְבַּ֥ח הַקְּטֹ֖רֶת עֲצֵ֣י שִׁטִּ֑ים אַמָּ֣ה אָרְכֹּו֩ וְאַמָּ֨ה רָחְבֹּ֜ו רָב֗וּעַ וְאַמָּתַ֙יִם֙ קֹֽמָתֹ֔ו מִמֶּ֖נּוּ הָי֥וּ קַרְנֹתָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","וַיְצַ֨ף אֹתֹ֜ו זָהָ֣ב טָהֹ֗ור אֶת־גַּגֹּ֧ו וְאֶת־קִירֹתָ֛יו סָבִ֖יב וְאֶת־קַרְנֹתָ֑יו וַיַּ֥עַשׂ לֹ֛ו זֵ֥ר זָהָ֖ב סָבִֽיב׃ ");
INSERT INTO hbo_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","וּשְׁתֵּי֩ טַבְּעֹ֨ת זָהָ֜ב עָֽשָׂה־לֹ֣ו ׀ מִתַּ֣חַת לְזֵרֹ֗ו עַ֚ל שְׁתֵּ֣י צַלְעֹתָ֔יו עַ֖ל שְׁנֵ֣י צִדָּ֑יו לְבָתִּ֣ים לְבַדִּ֔ים לָשֵׂ֥את אֹתֹ֖ו בָּהֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","וַיַּ֥עַשׂ אֶת־הַבַּדִּ֖ים עֲצֵ֣י שִׁטִּ֑ים וַיְצַ֥ף אֹתָ֖ם זָהָֽב׃ ");
INSERT INTO hbo_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","וַיַּ֜עַשׂ אֶת־שֶׁ֤מֶן הַמִּשְׁחָה֙ קֹ֔דֶשׁ וְאֶת־קְטֹ֥רֶת הַסַּמִּ֖ים טָהֹ֑ור מַעֲשֵׂ֖ה רֹקֵֽחַ׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","וַיַּ֛עַשׂ אֶת־מִזְבַּ֥ח הָעֹלָ֖ה עֲצֵ֣י שִׁטִּ֑ים חָמֵשׁ֩ אַמֹּ֨ות אָרְכֹּ֜ו וְחָֽמֵשׁ־אַמֹּ֤ות רָחְבֹּו֙ רָב֔וּעַ וְשָׁלֹ֥שׁ אַמֹּ֖ות קֹמָתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","וַיַּ֣עַשׂ קַרְנֹתָ֗יו עַ֚ל אַרְבַּ֣ע פִּנֹּתָ֔יו מִמֶּ֖נּוּ הָי֣וּ קַרְנֹתָ֑יו וַיְצַ֥ף אֹתֹ֖ו נְחֹֽשֶׁת׃ ");
INSERT INTO hbo_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","וַיַּ֜עַשׂ אֶֽת־כָּל־כְּלֵ֣י הַמִּזְבֵּ֗חַ אֶת־הַסִּירֹ֤ת וְאֶת־הַיָּעִים֙ וְאֶת־הַמִּזְרָקֹ֔ת אֶת־הַמִּזְלָגֹ֖ת וְאֶת־הַמַּחְתֹּ֑ת כָּל־כֵּלָ֖יו עָשָׂ֥ה נְחֹֽשֶׁת׃ ");
INSERT INTO hbo_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","וַיַּ֤עַשׂ לַמִּזְבֵּ֙חַ֙ מִכְבָּ֔ר מַעֲשֵׂ֖ה רֶ֣שֶׁת נְחֹ֑שֶׁת תַּ֧חַת כַּרְכֻּבֹּ֛ו מִלְּמַ֖טָּה עַד־חֶצְיֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","וַיִּצֹ֞ק אַרְבַּ֧ע טַבָּעֹ֛ת בְּאַרְבַּ֥ע הַקְּצָוֹ֖ת לְמִכְבַּ֣ר הַנְּחֹ֑שֶׁת בָּתִּ֖ים לַבַּדִּֽים׃ ");
INSERT INTO hbo_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","וַיַּ֥עַשׂ אֶת־הַבַּדִּ֖ים עֲצֵ֣י שִׁטִּ֑ים וַיְצַ֥ף אֹתָ֖ם נְחֹֽשֶׁת׃ ");
INSERT INTO hbo_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","וַיָּבֵ֨א אֶת־הַבַּדִּ֜ים בַּטַּבָּעֹ֗ת עַ֚ל צַלְעֹ֣ת הַמִּזְבֵּ֔חַ לָשֵׂ֥את אֹתֹ֖ו בָּהֶ֑ם נְב֥וּב לֻחֹ֖ת עָשָׂ֥ה אֹתֹֽו׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","וַיַּ֗עַשׂ אֵ֚ת הַכִּיֹּ֣ור נְחֹ֔שֶׁת וְאֵ֖ת כַּנֹּ֣ו נְחֹ֑שֶׁת בְּמַרְאֹת֙ הַצֹּ֣בְאֹ֔ת אֲשֶׁ֣ר צָֽבְא֔וּ פֶּ֖תַח אֹ֥הֶל מֹועֵֽד׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","וַיַּ֖עַשׂ אֶת־הֶחָצֵ֑ר לִפְאַ֣ת ׀ נֶ֣גֶב תֵּימָ֗נָה קַלְעֵ֤י הֶֽחָצֵר֙ שֵׁ֣שׁ מָשְׁזָ֔ר מֵאָ֖ה בָּאַמָּֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","עַמּוּדֵיהֶ֣ם עֶשְׂרִ֔ים וְאַדְנֵיהֶ֥ם עֶשְׂרִ֖ים נְחֹ֑שֶׁת וָוֵ֧י הָעַמֻּדִ֛ים וַחֲשֻׁקֵיהֶ֖ם כָּֽסֶף׃ ");
INSERT INTO hbo_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","וְלִפְאַ֤ת צָפֹון֙ מֵאָ֣ה בָֽאַמָּ֔ה עַמּוּדֵיהֶ֣ם עֶשְׂרִ֔ים וְאַדְנֵיהֶ֥ם עֶשְׂרִ֖ים נְחֹ֑שֶׁת וָוֵ֧י הָֽעַמּוּדִ֛ים וַחֲשֻׁקֵיהֶ֖ם כָּֽסֶף׃ ");
INSERT INTO hbo_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","וְלִפְאַת־יָ֗ם קְלָעִים֙ חֲמִשִּׁ֣ים בָּֽאַמָּ֔ה עַמּוּדֵיהֶ֥ם עֲשָׂרָ֔ה וְאַדְנֵיהֶ֖ם עֲשָׂרָ֑ה וָוֵ֧י הָעַמֻּדִ֛ים וַחֲשׁוּקֵיהֶ֖ם כָּֽסֶף׃ ");
INSERT INTO hbo_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","וְלִפְאַ֛ת קֵ֥דְמָה מִזְרָ֖חָה חֲמִשִּׁ֥ים אַמָּֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","קְלָעִ֛ים חֲמֵשׁ־עֶשְׂרֵ֥ה אַמָּ֖ה אֶל־הַכָּתֵ֑ף עַמּוּדֵיהֶ֣ם שְׁלֹשָׁ֔ה וְאַדְנֵיהֶ֖ם שְׁלֹשָֽׁה׃ ");
INSERT INTO hbo_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","וְלַכָּתֵ֣ף הַשֵּׁנִ֗ית מִזֶּ֤ה וּמִזֶּה֙ לְשַׁ֣עַר הֶֽחָצֵ֔ר קְלָעִ֕ים חֲמֵ֥שׁ עֶשְׂרֵ֖ה אַמָּ֑ה עַמֻּדֵיהֶ֣ם שְׁלֹשָׁ֔ה וְאַדְנֵיהֶ֖ם שְׁלֹשָֽׁה׃ ");
INSERT INTO hbo_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","כָּל־קַלְעֵ֧י הֶחָצֵ֛ר סָבִ֖יב שֵׁ֥שׁ מָשְׁזָֽר׃ ");
INSERT INTO hbo_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","וְהָאֲדָנִ֣ים לָֽעַמֻּדִים֮ נְחֹשֶׁת֒ וָוֵ֨י הָֽעַמּוּדִ֜ים וַחֲשׁוּקֵיהֶם֙ כֶּ֔סֶף וְצִפּ֥וּי רָאשֵׁיהֶ֖ם כָּ֑סֶף וְהֵם֙ מְחֻשָּׁקִ֣ים כֶּ֔סֶף כֹּ֖ל עַמֻּדֵ֥י הֶחָצֵֽר׃ ");
INSERT INTO hbo_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","וּמָסַ֞ךְ שַׁ֤עַר הֶחָצֵר֙ מַעֲשֵׂ֣ה רֹקֵ֔ם תְּכֵ֧לֶת וְאַרְגָּמָ֛ן וְתֹולַ֥עַת שָׁנִ֖י וְשֵׁ֣שׁ מָשְׁזָ֑ר וְעֶשְׂרִ֤ים אַמָּה֙ אֹ֔רֶךְ וְקֹומָ֤ה בְרֹ֙חַב֙ חָמֵ֣שׁ אַמֹּ֔ות לְעֻמַּ֖ת קַלְעֵ֥י הֶחָצֵֽר׃ ");
INSERT INTO hbo_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","וְעַמֻּֽדֵיהֶם֙ אַרְבָּעָ֔ה וְאַדְנֵיהֶ֥ם אַרְבָּעָ֖ה נְחֹ֑שֶׁת וָוֵיהֶ֣ם כֶּ֔סֶף וְצִפּ֧וּי רָאשֵׁיהֶ֛ם וַחֲשֻׁקֵיהֶ֖ם כָּֽסֶף׃ ");
INSERT INTO hbo_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","וְֽכָל־הַיְתֵדֹ֞ת לַמִּשְׁכָּ֧ן וְלֶחָצֵ֛ר סָבִ֖יב נְחֹֽשֶׁת׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","אֵ֣לֶּה פְקוּדֵ֤י הַמִּשְׁכָּן֙ מִשְׁכַּ֣ן הָעֵדֻ֔ת אֲשֶׁ֥ר פֻּקַּ֖ד עַל־פִּ֣י מֹשֶׁ֑ה עֲבֹדַת֙ הַלְוִיִּ֔ם בְּיַד֙ אִֽיתָמָ֔ר בֶּֽן־אַהֲרֹ֖ן הַכֹּהֵֽן׃ ");
INSERT INTO hbo_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","וּבְצַלְאֵ֛ל בֶּן־אוּרִ֥י בֶן־ח֖וּר לְמַטֵּ֣ה יְהוּדָ֑ה עָשָׂ֕ה אֵ֛ת כָּל־אֲשֶׁר־צִוָּ֥ה יְהוָ֖ה אֶת־מֹשֶֽׁה׃ ");
INSERT INTO hbo_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","וְאִתֹּ֗ו אָהֳלִיאָ֞ב בֶּן־אֲחִיסָמָ֛ךְ לְמַטֵּה־דָ֖ן חָרָ֣שׁ וְחֹשֵׁ֑ב וְרֹקֵ֗ם בַּתְּכֵ֙לֶת֙ וּבָֽאַרְגָּמָ֔ן וּבְתֹולַ֥עַת הַשָּׁנִ֖י וּבַשֵּֽׁשׁ׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","כָּל־הַזָּהָ֗ב הֶֽעָשׂוּי֙ לַמְּלָאכָ֔ה בְּכֹ֖ל מְלֶ֣אכֶת הַקֹּ֑דֶשׁ וַיְהִ֣י ׀ זְהַ֣ב הַתְּנוּפָ֗ה תֵּ֤שַׁע וְעֶשְׂרִים֙ כִּכָּ֔ר וּשְׁבַ֨ע מֵאֹ֧ות וּשְׁלֹשִׁ֛ים שֶׁ֖קֶל בְּשֶׁ֥קֶל הַקֹּֽדֶשׁ׃ ");
INSERT INTO hbo_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","וְכֶ֛סֶף פְּקוּדֵ֥י הָעֵדָ֖ה מְאַ֣ת כִּכָּ֑ר וְאֶלֶף֩ וּשְׁבַ֨ע מֵאֹ֜ות וַחֲמִשָּׁ֧ה וְשִׁבְעִ֛ים שֶׁ֖קֶל בְּשֶׁ֥קֶל הַקֹּֽדֶשׁ׃ ");
INSERT INTO hbo_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","בֶּ֚קַע לַגֻּלְגֹּ֔לֶת מַחֲצִ֥ית הַשֶּׁ֖קֶל בְּשֶׁ֣קֶל הַקֹּ֑דֶשׁ לְכֹ֨ל הָעֹבֵ֜ר עַל־הַפְּקֻדִ֗ים מִבֶּ֨ן עֶשְׂרִ֤ים שָׁנָה֙ וָמַ֔עְלָה לְשֵׁשׁ־מֵאֹ֥ות אֶ֙לֶף֙ וּשְׁלֹ֣שֶׁת אֲלָפִ֔ים וַחֲמֵ֥שׁ מֵאֹ֖ות וַחֲמִשִּֽׁים׃ ");
INSERT INTO hbo_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","וַיְהִ֗י מְאַת֙ כִּכַּ֣ר הַכֶּ֔סֶף לָצֶ֗קֶת אֵ֚ת אַדְנֵ֣י הַקֹּ֔דֶשׁ וְאֵ֖ת אַדְנֵ֣י הַפָּרֹ֑כֶת מְאַ֧ת אֲדָנִ֛ים לִמְאַ֥ת הַכִּכָּ֖ר כִּכָּ֥ר לָאָֽדֶן׃ ");
INSERT INTO hbo_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","וְאֶת־הָאֶ֜לֶף וּשְׁבַ֤ע הַמֵּאֹות֙ וַחֲמִשָּׁ֣ה וְשִׁבְעִ֔ים עָשָׂ֥ה וָוִ֖ים לָעַמּוּדִ֑ים וְצִפָּ֥ה רָאשֵׁיהֶ֖ם וְחִשַּׁ֥ק אֹתָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","וּנְחֹ֥שֶׁת הַתְּנוּפָ֖ה שִׁבְעִ֣ים כִּכָּ֑ר וְאַלְפַּ֥יִם וְאַרְבַּע־מֵאֹ֖ות שָֽׁקֶל׃ ");
INSERT INTO hbo_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","וַיַּ֣עַשׂ בָּ֗הּ אֶת־אַדְנֵי֙ פֶּ֚תַח אֹ֣הֶל מֹועֵ֔ד וְאֵת֙ מִזְבַּ֣ח הַנְּחֹ֔שֶׁת וְאֶת־מִכְבַּ֥ר הַנְּחֹ֖שֶׁת אֲשֶׁר־לֹ֑ו וְאֵ֖ת כָּל־כְּלֵ֥י הַמִּזְבֵּֽחַ׃ ");
INSERT INTO hbo_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","וְאֶת־אַדְנֵ֤י הֶֽחָצֵר֙ סָבִ֔יב וְאֶת־אַדְנֵ֖י שַׁ֣עַר הֶחָצֵ֑ר וְאֵ֨ת כָּל־יִתְדֹ֧ת הַמִּשְׁכָּ֛ן וְאֶת־כָּל־יִתְדֹ֥ת הֶחָצֵ֖ר סָבִֽיב׃ ");
INSERT INTO hbo_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","וּמִן־הַתְּכֵ֤לֶת וְהָֽאַרְגָּמָן֙ וְתֹולַ֣עַת הַשָּׁנִ֔י עָשׂ֥וּ בִגְדֵי־שְׂרָ֖ד לְשָׁרֵ֣ת בַּקֹּ֑דֶשׁ וַֽיַּעֲשׂ֞וּ אֶת־בִּגְדֵ֤י הַקֹּ֙דֶשׁ֙ אֲשֶׁ֣ר לְאַהֲרֹ֔ן כַּאֲשֶׁ֛ר צִוָּ֥ה יְהוָ֖ה אֶת־מֹשֶֽׁה׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","וַיַּ֖עַשׂ אֶת־הָאֵפֹ֑ד זָהָ֗ב תְּכֵ֧לֶת וְאַרְגָּמָ֛ן וְתֹולַ֥עַת שָׁנִ֖י וְשֵׁ֥שׁ מָשְׁזָֽר׃ ");
INSERT INTO hbo_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","וַֽיְרַקְּע֞וּ אֶת־פַּחֵ֣י הַזָּהָב֮ וְקִצֵּ֣ץ פְּתִילִם֒ לַעֲשֹׂ֗ות בְּתֹ֤וךְ הַתְּכֵ֙לֶת֙ וּבְתֹ֣וךְ הָֽאַרְגָּמָ֔ן וּבְתֹ֛וךְ תֹּולַ֥עַת הַשָּׁנִ֖י וּבְתֹ֣וךְ הַשֵּׁ֑שׁ מַעֲשֵׂ֖ה חֹשֵֽׁב׃ ");
INSERT INTO hbo_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","כְּתֵפֹ֥ת עָֽשׂוּ־לֹ֖ו חֹבְרֹ֑ת עַל־שְׁנֵ֥י *קִצְוֹותֹו (קְצֹותָ֖יו) חֻבָּֽר׃ ");
INSERT INTO hbo_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","וְחֵ֨שֶׁב אֲפֻדָּתֹ֜ו אֲשֶׁ֣ר עָלָ֗יו מִמֶּ֣נּוּ הוּא֮ כְּמַעֲשֵׂהוּ֒ זָהָ֗ב תְּכֵ֧לֶת וְאַרְגָּמָ֛ן וְתֹולַ֥עַת שָׁנִ֖י וְשֵׁ֣שׁ מָשְׁזָ֑ר כַּאֲשֶׁ֛ר צִוָּ֥ה יְהוָ֖ה אֶת־מֹשֶֽׁה׃ ");
INSERT INTO hbo_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","וַֽיַּעֲשׂוּ֙ אֶת־אַבְנֵ֣י הַשֹּׁ֔הַם מֻֽסַבֹּ֖ת מִשְׁבְּצֹ֣ת זָהָ֑ב מְפֻתָּחֹת֙ פִּתּוּחֵ֣י חֹותָ֔ם עַל־שְׁמֹ֖ות בְּנֵ֥י יִשְׂרָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","וַיָּ֣שֶׂם אֹתָ֗ם עַ֚ל כִּתְפֹ֣ת הָאֵפֹ֔ד אַבְנֵ֥י זִכָּרֹ֖ון לִבְנֵ֣י יִשְׂרָאֵ֑ל כַּאֲשֶׁ֛ר צִוָּ֥ה יְהוָ֖ה אֶת־מֹשֶֽׁה׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","וַיַּ֧עַשׂ אֶת־הַחֹ֛שֶׁן מַעֲשֵׂ֥ה חֹשֵׁ֖ב כְּמַעֲשֵׂ֣ה אֵפֹ֑ד זָהָ֗ב תְּכֵ֧לֶת וְאַרְגָּמָ֛ן וְתֹולַ֥עַת שָׁנִ֖י וְשֵׁ֥שׁ מָשְׁזָֽר׃ ");
INSERT INTO hbo_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","רָב֧וּעַ הָיָ֛ה כָּפ֖וּל עָשׂ֣וּ אֶת־הַחֹ֑שֶׁן זֶ֧רֶת אָרְכֹּ֛ו וְזֶ֥רֶת רָחְבֹּ֖ו כָּפֽוּל׃ ");
INSERT INTO hbo_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","וַיְמַלְאוּ־בֹ֔ו אַרְבָּעָ֖ה ט֣וּרֵי אָ֑בֶן ט֗וּר אֹ֤דֶם פִּטְדָה֙ וּבָרֶ֔קֶת הַטּ֖וּר הָאֶחָֽד׃ ");
INSERT INTO hbo_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","וְהַטּ֖וּר הַשֵּׁנִ֑י נֹ֥פֶךְ סַפִּ֖יר וְיָהֲלֹֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","וְהַטּ֖וּר הַשְּׁלִישִׁ֑י לֶ֥שֶׁם שְׁבֹ֖ו וְאַחְלָֽמָה׃ ");
INSERT INTO hbo_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","וְהַטּוּר֙ הָֽרְבִיעִ֔י תַּרְשִׁ֥ישׁ שֹׁ֖הַם וְיָשְׁפֵ֑ה מֽוּסַבֹּ֛ת מִשְׁבְּצֹ֥ות זָהָ֖ב בְּמִלֻּאֹתָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","וְ֠הָאֲבָנִים עַל־שְׁמֹ֨ת בְּנֵי־יִשְׂרָאֵ֥ל הֵ֛נָּה שְׁתֵּ֥ים עֶשְׂרֵ֖ה עַל־שְׁמֹתָ֑ם פִּתּוּחֵ֤י חֹתָם֙ אִ֣ישׁ עַל־שְׁמֹ֔ו לִשְׁנֵ֥ים עָשָׂ֖ר שָֽׁבֶט׃ ");
INSERT INTO hbo_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","וַיַּעֲשׂ֧וּ עַל־הַחֹ֛שֶׁן שַׁרְשְׁרֹ֥ת גַּבְלֻ֖ת מַעֲשֵׂ֣ה עֲבֹ֑ת זָהָ֖ב טָהֹֽור׃ ");
INSERT INTO hbo_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","וַֽיַּעֲשׂ֗וּ שְׁתֵּי֙ מִשְׁבְּצֹ֣ת זָהָ֔ב וּשְׁתֵּ֖י טַבְּעֹ֣ת זָהָ֑ב וֽ͏ַיִּתְּנ֗וּ אֶת־שְׁתֵּי֙ הַטַּבָּעֹ֔ת עַל־שְׁנֵ֖י קְצֹ֥ות הַחֹֽשֶׁן׃ ");
INSERT INTO hbo_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","וַֽיִּתְּנ֗וּ שְׁתֵּי֙ הָעֲבֹתֹ֣ת הַזָּהָ֔ב עַל־שְׁתֵּ֖י הַטַּבָּעֹ֑ת עַל־קְצֹ֖ות הַחֹֽשֶׁן׃ ");
INSERT INTO hbo_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","וְאֵ֨ת שְׁתֵּ֤י קְצֹות֙ שְׁתֵּ֣י הָֽעֲבֹתֹ֔ת נָתְנ֖וּ עַל־שְׁתֵּ֣י הַֽמִּשְׁבְּצֹ֑ת וַֽיִּתְּנֻ֛ם עַל־כִּתְפֹ֥ת הָאֵפֹ֖ד אֶל־מ֥וּל פָּנָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","וַֽיַּעֲשׂ֗וּ שְׁתֵּי֙ טַבְּעֹ֣ת זָהָ֔ב וַיָּשִׂ֕ימוּ עַל־שְׁנֵ֖י קְצֹ֣ות הַחֹ֑שֶׁן עַל־שְׂפָתֹ֕ו אֲשֶׁ֛ר אֶל־עֵ֥בֶר הָאֵפֹ֖ד בָּֽיְתָה׃ ");
INSERT INTO hbo_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","וַֽיַּעֲשׂוּ֮ שְׁתֵּ֣י טַבְּעֹ֣ת זָהָב֒ וַֽיִּתְּנֻ֡ם עַל־שְׁתֵּי֩ כִתְפֹ֨ת הָאֵפֹ֤ד מִלְמַ֙טָּה֙ מִמּ֣וּל פָּנָ֔יו לְעֻמַּ֖ת מֶחְבַּרְתֹּ֑ו מִמַּ֕עַל לְחֵ֖שֶׁב הָאֵפֹֽד׃ ");
INSERT INTO hbo_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","וַיִּרְכְּס֣וּ אֶת־הַחֹ֡שֶׁן מִטַּבְּעֹתָיו֩ אֶל־טַבְּעֹ֨ת הָאֵפֹ֜ד בִּפְתִ֣יל תְּכֵ֗לֶת לִֽהְיֹת֙ עַל־חֵ֣שֶׁב הָאֵפֹ֔ד וְלֹֽא־יִזַּ֣ח הַחֹ֔שֶׁן מֵעַ֖ל הָאֵפֹ֑ד כַּאֲשֶׁ֛ר צִוָּ֥ה יְהוָ֖ה אֶת־מֹשֶֽׁה׃ ");
INSERT INTO hbo_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","וַיַּ֛עַשׂ אֶת־מְעִ֥יל הָאֵפֹ֖ד מַעֲשֵׂ֣ה אֹרֵ֑ג כְּלִ֖יל תְּכֵֽלֶת׃ ");
INSERT INTO hbo_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","וּפִֽי־הַמְּעִ֥יל בְּתֹוכֹ֖ו כְּפִ֣י תַחְרָ֑א שָׂפָ֥ה לְפִ֛יו סָבִ֖יב לֹ֥א יִקָּרֵֽעַ׃ ");
INSERT INTO hbo_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","וַֽיַּעֲשׂוּ֙ עַל־שׁוּלֵ֣י הַמְּעִ֔יל רִמֹּונֵ֕י תְּכֵ֥לֶת וְאַרְגָּמָ֖ן וְתֹולַ֣עַת שָׁנִ֑י מָשְׁזָֽר׃ ");
INSERT INTO hbo_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","וַיַּעֲשׂ֥וּ פַעֲמֹנֵ֖י זָהָ֣ב טָהֹ֑ור וַיִּתְּנ֨וּ אֶת־הַפַּֽעֲמֹנִ֜ים בְּתֹ֣וךְ הָרִמֹּנִ֗ים עַל־שׁוּלֵ֤י הַמְּעִיל֙ סָבִ֔יב בְּתֹ֖וךְ הָרִמֹּנִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","פַּעֲמֹ֤ן וְרִמֹּן֙ פַּעֲמֹ֣ן וְרִמֹּ֔ן עַל־שׁוּלֵ֥י הַמְּעִ֖יל סָבִ֑יב לְשָׁרֵ֕ת כַּאֲשֶׁ֛ר צִוָּ֥ה יְהוָ֖ה אֶת־מֹשֶֽׁה׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","וֽ͏ַיַּעֲשׂ֛וּ אֶת־הַכָּתְנֹ֥ת שֵׁ֖שׁ מַעֲשֵׂ֣ה אֹרֵ֑ג לְאַהֲרֹ֖ן וּלְבָנָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","וְאֵת֙ הַמִּצְנֶ֣פֶת שֵׁ֔שׁ וְאֶת־פַּאֲרֵ֥י הַמִּגְבָּעֹ֖ת שֵׁ֑שׁ וְאֶת־מִכְנְסֵ֥י הַבָּ֖ד שֵׁ֥שׁ מָשְׁזָֽר׃ ");
INSERT INTO hbo_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","וְֽאֶת־הָאַבְנֵ֞ט שֵׁ֣שׁ מָשְׁזָ֗ר וּתְכֵ֧לֶת וְאַרְגָּמָ֛ן וְתֹולַ֥עַת שָׁנִ֖י מַעֲשֵׂ֣ה רֹקֵ֑ם כַּאֲשֶׁ֛ר צִוָּ֥ה יְהוָ֖ה אֶת־מֹשֶֽׁה׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","וֽ͏ַיַּעֲשׂ֛וּ אֶת־צִ֥יץ נֵֽזֶר־הַקֹּ֖דֶשׁ זָהָ֣ב טָהֹ֑ור וַיִּכְתְּב֣וּ עָלָ֗יו מִכְתַּב֙ פִּתּוּחֵ֣י חֹותָ֔ם קֹ֖דֶשׁ לַיהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","וַיִּתְּנ֤וּ עָלָיו֙ פְּתִ֣יל תְּכֵ֔לֶת לָתֵ֥ת עַל־הַמִּצְנֶ֖פֶת מִלְמָ֑עְלָה כַּאֲשֶׁ֛ר צִוָּ֥ה יְהוָ֖ה אֶת־מֹשֶֽׁה׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","וַתֵּ֕כֶל כָּל־עֲבֹדַ֕ת מִשְׁכַּ֖ן אֹ֣הֶל מֹועֵ֑ד וַֽיַּעֲשׂוּ֙ בְּנֵ֣י יִשְׂרָאֵ֔ל כְּ֠כֹל אֲשֶׁ֨ר צִוָּ֧ה יְהוָ֛ה אֶת־מֹשֶׁ֖ה כֵּ֥ן עָשֽׂוּ׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","וַיָּבִ֤יאוּ אֶת־הַמִּשְׁכָּן֙ אֶל־מֹשֶׁ֔ה אֶת־הָאֹ֖הֶל וְאֶת־כָּל־כֵּלָ֑יו קְרָסָ֣יו קְרָשָׁ֔יו *בְּרִיחֹו (בְּרִיחָ֖יו) וְעַמֻּדָ֥יו וַאֲדָנָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","וְאֶת־מִכְסֵ֞ה עֹורֹ֤ת הָֽאֵילִם֙ הַמְאָדָּמִ֔ים וְאֶת־מִכְסֵ֖ה עֹרֹ֣ת הַתְּחָשִׁ֑ים וְאֵ֖ת פָּרֹ֥כֶת הַמָּסָֽךְ׃ ");
INSERT INTO hbo_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","אֶת־אֲרֹ֥ן הָעֵדֻ֖ת וְאֶת־בַּדָּ֑יו וְאֵ֖ת הַכַּפֹּֽרֶת׃ ");
INSERT INTO hbo_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","אֶת־הַשֻּׁלְחָן֙ אֶת־כָּל־כֵּלָ֔יו וְאֵ֖ת לֶ֥חֶם הַפָּנִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","אֶת־הַמְּנֹרָ֨ה הַטְּהֹרָ֜ה אֶת־נֵרֹתֶ֗יהָ נֵרֹ֛ת הַמַּֽעֲרָכָ֖ה וְאֶת־כָּל־כֵּלֶ֑יהָ וְאֵ֖ת שֶׁ֥מֶן הַמָּאֹֽור׃ ");
INSERT INTO hbo_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","וְאֵת֙ מִזְבַּ֣ח הַזָּהָ֔ב וְאֵת֙ שֶׁ֣מֶן הַמִּשְׁחָ֔ה וְאֵ֖ת קְטֹ֣רֶת הַסַּמִּ֑ים וְאֵ֕ת מָסַ֖ךְ פֶּ֥תַח הָאֹֽהֶל׃ ");
INSERT INTO hbo_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","אֵ֣ת ׀ מִזְבַּ֣ח הַנְּחֹ֗שֶׁת וְאֶת־מִכְבַּ֤ר הַנְּחֹ֙שֶׁת֙ אֲשֶׁר־לֹ֔ו אֶת־בַּדָּ֖יו וְאֶת־כָּל־כֵּלָ֑יו אֶת־הַכִּיֹּ֖ר וְאֶת־כַּנֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","אֵת֩ קַלְעֵ֨י הֶחָצֵ֜ר אֶת־עַמֻּדֶ֣יהָ וְאֶת־אֲדָנֶ֗יהָ וְאֶת־הַמָּסָךְ֙ לְשַׁ֣עַר הֶֽחָצֵ֔ר אֶת־מֵיתָרָ֖יו וִיתֵדֹתֶ֑יהָ וְאֵ֗ת כָּל־כְּלֵ֛י עֲבֹדַ֥ת הַמִּשְׁכָּ֖ן לְאֹ֥הֶל מֹועֵֽד׃ ");
INSERT INTO hbo_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","אֶת־בִּגְדֵ֥י הַשְּׂרָ֖ד לְשָׁרֵ֣ת בַּקֹּ֑דֶשׁ אֶת־בִּגְדֵ֤י הַקֹּ֙דֶשׁ֙ לְאַהֲרֹ֣ן הַכֹּהֵ֔ן וְאֶת־בִּגְדֵ֥י בָנָ֖יו לְכַהֵֽן׃ ");
INSERT INTO hbo_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","כְּכֹ֛ל אֲשֶׁר־צִוָּ֥ה יְהוָ֖ה אֶת־מֹשֶׁ֑ה כֵּ֤ן עָשׂוּ֙ בְּנֵ֣י יִשְׂרָאֵ֔ל אֵ֖ת כָּל־הָעֲבֹדָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","וַיַּ֨רְא מֹשֶׁ֜ה אֶת־כָּל־הַמְּלָאכָ֗ה וְהִנֵּה֙ עָשׂ֣וּ אֹתָ֔הּ כַּאֲשֶׁ֛ר צִוָּ֥ה יְהוָ֖ה כֵּ֣ן עָשׂ֑וּ וַיְבָ֥רֶךְ אֹתָ֖ם מֹשֶֽׁה׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","בְּיֹום־הַחֹ֥דֶשׁ הָרִאשֹׁ֖ון בְּאֶחָ֣ד לַחֹ֑דֶשׁ תָּקִ֕ים אֶת־מִשְׁכַּ֖ן אֹ֥הֶל מֹועֵֽד׃ ");
INSERT INTO hbo_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","וְשַׂמְתָּ֣ שָׁ֔ם אֵ֖ת אֲרֹ֣ון הָעֵד֑וּת וְסַכֹּתָ֥ עַל־הָאָרֹ֖ן אֶת־הַפָּרֹֽכֶת׃ ");
INSERT INTO hbo_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","וְהֵבֵאתָ֙ אֶת־הַשֻּׁלְחָ֔ן וְעָרַכְתָּ֖ אֶת־עֶרְכֹּ֑ו וְהֵבֵאתָ֙ אֶת־הַמְּנֹרָ֔ה וְהַעֲלֵיתָ֖ אֶת־נֵרֹתֶֽיהָ׃ ");
INSERT INTO hbo_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","וְנָתַתָּ֞ה אֶת־מִזְבַּ֤ח הַזָּהָב֙ לִקְטֹ֔רֶת לִפְנֵ֖י אֲרֹ֣ון הָעֵדֻ֑ת וְשַׂמְתָּ֛ אֶת־מָסַ֥ךְ הַפֶּ֖תַח לַמִּשְׁכָּֽן׃ ");
INSERT INTO hbo_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","וְנָ֣תַתָּ֔ה אֵ֖ת מִזְבַּ֣ח הָעֹלָ֑ה לִפְנֵ֕י פֶּ֖תַח מִשְׁכַּ֥ן אֹֽהֶל־מֹועֵֽד׃ ");
INSERT INTO hbo_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","וְנָֽתַתָּ֙ אֶת־הַכִּיֹּ֔ר בֵּֽין־אֹ֥הֶל מֹועֵ֖ד וּבֵ֣ין הַמִּזְבֵּ֑חַ וְנָתַתָּ֥ שָׁ֖ם מָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","וְשַׂמְתָּ֥ אֶת־הֶחָצֵ֖ר סָבִ֑יב וְנָ֣תַתָּ֔ אֶת־מָסַ֖ךְ שַׁ֥עַר הֶחָצֵֽר׃ ");
INSERT INTO hbo_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","וְלָקַחְתָּ֙ אֶת־שֶׁ֣מֶן הַמִּשְׁחָ֔ה וּמָשַׁחְתָּ֥ אֶת־הַמִּשְׁכָּ֖ן וְאֶת־כָּל־אֲשֶׁר־בֹּ֑ו וְקִדַּשְׁתָּ֥ אֹתֹ֛ו וְאֶת־כָּל־כֵּלָ֖יו וְהָ֥יָה קֹֽדֶשׁ׃ ");
INSERT INTO hbo_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","וּמָשַׁחְתָּ֛ אֶת־מִזְבַּ֥ח הָעֹלָ֖ה וְאֶת־כָּל־כֵּלָ֑יו וְקִדַּשְׁתָּ֙ אֶת־הַמִּזְבֵּ֔חַ וְהָיָ֥ה הַמִּזְבֵּ֖חַ קֹ֥דֶשׁ קֽ͏ָדָשִֽׁים׃ ");
INSERT INTO hbo_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","וּמָשַׁחְתָּ֥ אֶת־הַכִּיֹּ֖ר וְאֶת־כַּנֹּ֑ו וְקִדַּשְׁתָּ֖ אֹתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","וְהִקְרַבְתָּ֤ אֶֽת־אַהֲרֹן֙ וְאֶת־בָּנָ֔יו אֶל־פֶּ֖תַח אֹ֣הֶל מֹועֵ֑ד וְרָחַצְתָּ֥ אֹתָ֖ם בַּמָּֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","וְהִלְבַּשְׁתָּ֙ אֶֽת־אַהֲרֹ֔ן אֵ֖ת בִּגְדֵ֣י הַקֹּ֑דֶשׁ וּמָשַׁחְתָּ֥ אֹתֹ֛ו וְקִדַּשְׁתָּ֥ אֹתֹ֖ו וְכִהֵ֥ן לִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","וְאֶת־בָּנָ֖יו תַּקְרִ֑יב וְהִלְבַּשְׁתָּ֥ אֹתָ֖ם כֻּתֳּנֹֽת׃ ");
INSERT INTO hbo_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","וּמָשַׁחְתָּ֣ אֹתָ֗ם כַּאֲשֶׁ֤ר מָשַׁ֙חְתָּ֙ אֶת־אֲבִיהֶ֔ם וְכִהֲנ֖וּ לִ֑י וְ֠הָיְתָה לִהְיֹ֨ת לָהֶ֧ם מָשְׁחָתָ֛ם לִכְהֻנַּ֥ת עֹולָ֖ם לְדֹרֹתָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","וַיַּ֖עַשׂ מֹשֶׁ֑ה כְּ֠כֹל אֲשֶׁ֨ר צִוָּ֧ה יְהוָ֛ה אֹתֹ֖ו כֵּ֥ן עָשָֽׂה׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","וַיְהִ֞י בַּחֹ֧דֶשׁ הָרִאשֹׁ֛ון בַּשָּׁנָ֥ה הַשֵּׁנִ֖ית בְּאֶחָ֣ד לַחֹ֑דֶשׁ הוּקַ֖ם הַמִּשְׁכָּֽן׃ ");
INSERT INTO hbo_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","וַיָּ֨קֶם מֹשֶׁ֜ה אֶת־הַמִּשְׁכָּ֗ן וַיִּתֵּן֙ אֶת־אֲדָנָ֔יו וַיָּ֙שֶׂם֙ אֶת־קְרָשָׁ֔יו וַיִּתֵּ֖ן אֶת־בְּרִיחָ֑יו וַיָּ֖קֶם אֶת־עַמּוּדָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","וַיִּפְרֹ֤שׂ אֶת־הָאֹ֙הֶל֙ עַל־הַמִּשְׁכָּ֔ן וַיָּ֜שֶׂם אֶת־מִכְסֵ֥ה הָאֹ֛הֶל עָלָ֖יו מִלְמָ֑עְלָה כַּאֲשֶׁ֛ר צִוָּ֥ה יְהוָ֖ה אֶת־מֹשֶֽׁה׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","וַיִּקַּ֞ח וַיִּתֵּ֤ן אֶת־הָעֵדֻת֙ אֶל־הָ֣אָרֹ֔ן וַיָּ֥שֶׂם אֶת־הַבַּדִּ֖ים עַל־הָאָרֹ֑ן וַיִּתֵּ֧ן אֶת־הַכַּפֹּ֛רֶת עַל־הָאָרֹ֖ן מִלְמָֽעְלָה׃ ");
INSERT INTO hbo_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","וַיָּבֵ֣א אֶת־הָאָרֹן֮ אֶל־הַמִּשְׁכָּן֒ וַיָּ֗שֶׂם אֵ֚ת פָּרֹ֣כֶת הַמָּסָ֔ךְ וַיָּ֕סֶךְ עַ֖ל אֲרֹ֣ון הָעֵד֑וּת כַּאֲשֶׁ֛ר צִוָּ֥ה יְהוָ֖ה אֶת־מֹשֶֽׁה׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","וַיִּתֵּ֤ן אֶת־הַשֻּׁלְחָן֙ בְּאֹ֣הֶל מֹועֵ֔ד עַ֛ל יֶ֥רֶךְ הַמִּשְׁכָּ֖ן צָפֹ֑נָה מִח֖וּץ לַפָּרֹֽכֶת׃ ");
INSERT INTO hbo_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","וַיַּעֲרֹ֥ךְ עָלָ֛יו עֵ֥רֶךְ לֶ֖חֶם לִפְנֵ֣י יְהוָ֑ה כַּאֲשֶׁ֛ר צִוָּ֥ה יְהוָ֖ה אֶת־מֹשֶֽׁה׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","וַיָּ֤שֶׂם אֶת־הַמְּנֹרָה֙ בְּאֹ֣הֶל מֹועֵ֔ד נֹ֖כַח הַשֻּׁלְחָ֑ן עַ֛ל יֶ֥רֶךְ הַמִּשְׁכָּ֖ן נֶֽגְבָּה׃ ");
INSERT INTO hbo_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","וַיַּ֥עַל הַנֵּרֹ֖ת לִפְנֵ֣י יְהוָ֑ה כַּאֲשֶׁ֛ר צִוָּ֥ה יְהוָ֖ה אֶת־מֹשֶֽׁה׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","וַיָּ֛שֶׂם אֶת־מִזְבַּ֥ח הַזָּהָ֖ב בְּאֹ֣הֶל מֹועֵ֑ד לִפְנֵ֖י הַפָּרֹֽכֶת׃ ");
INSERT INTO hbo_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","וַיַּקְטֵ֥ר עָלָ֖יו קְטֹ֣רֶת סַמִּ֑ים כַּאֲשֶׁ֛ר צִוָּ֥ה יְהוָ֖ה אֶת־מֹשֶֽׁה׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","וַיָּ֛שֶׂם אֶת־מָסַ֥ךְ הַפֶּ֖תַח לַמִּשְׁכָּֽן׃ ");
INSERT INTO hbo_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","וְאֵת֙ מִזְבַּ֣ח הָעֹלָ֔ה שָׂ֕ם פֶּ֖תַח מִשְׁכַּ֣ן אֹֽהֶל־מֹועֵ֑ד וַיַּ֣עַל עָלָ֗יו אֶת־הָעֹלָה֙ וְאֶת־הַמִּנְחָ֔ה כַּאֲשֶׁ֛ר צִוָּ֥ה יְהוָ֖ה אֶת־מֹשֶֽׁה׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","וַיָּ֙שֶׂם֙ אֶת־הַכִּיֹּ֔ר בֵּֽין־אֹ֥הֶל מֹועֵ֖ד וּבֵ֣ין הַמִּזְבֵּ֑חַ וַיִּתֵּ֥ן שָׁ֛מָּה מַ֖יִם לְרָחְצָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","וְרָחֲצ֣וּ מִמֶּ֔נּוּ מֹשֶׁ֖ה וְאַהֲרֹ֣ן וּבָנָ֑יו אֶת־יְדֵיהֶ֖ם וְאֶת־רַגְלֵיהֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","בְּבֹאָ֞ם אֶל־אֹ֣הֶל מֹועֵ֗ד וּבְקָרְבָתָ֛ם אֶל־הַמִּזְבֵּ֖חַ יִרְחָ֑צוּ כַּאֲשֶׁ֛ר צִוָּ֥ה יְהוָ֖ה אֶת־מֹשֶֽׁה׃ ס ");
INSERT INTO hbo_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","וַיָּ֣קֶם אֶת־הֶחָצֵ֗ר סָבִיב֙ לַמִּשְׁכָּ֣ן וְלַמִּזְבֵּ֔חַ וַיִּתֵּ֕ן אֶת־מָסַ֖ךְ שַׁ֣עַר הֶחָצֵ֑ר וַיְכַ֥ל מֹשֶׁ֖ה אֶת־הַמְּלָאכָֽה׃ פ ");
INSERT INTO hbo_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","וַיְכַ֥ס הֶעָנָ֖ן אֶת־אֹ֣הֶל מֹועֵ֑ד וּכְבֹ֣וד יְהוָ֔ה מָלֵ֖א אֶת־הַמִּשְׁכָּֽן׃ ");
INSERT INTO hbo_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","וְלֹא־יָכֹ֣ל מֹשֶׁ֗ה לָבֹוא֙ אֶל־אֹ֣הֶל מֹועֵ֔ד כִּֽי־שָׁכַ֥ן עָלָ֖יו הֶעָנָ֑ן וּכְבֹ֣וד יְהוָ֔ה מָלֵ֖א אֶת־הַמִּשְׁכָּֽן׃ ");
INSERT INTO hbo_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","וּבְהֵעָלֹ֤ות הֶֽעָנָן֙ מֵעַ֣ל הַמִּשְׁכָּ֔ן יִסְע֖וּ בְּנֵ֣י יִשְׂרָאֵ֑ל בְּכֹ֖ל מַסְעֵיהֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","וְאִם־לֹ֥א יֵעָלֶ֖ה הֶעָנָ֑ן וְלֹ֣א יִסְע֔וּ עַד־יֹ֖ום הֵעָלֹתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","כִּי֩ עֲנַ֨ן יְהוָ֤ה עַֽל־הַמִּשְׁכָּן֙ יֹומָ֔ם וְאֵ֕שׁ תִּהְיֶ֥ה לַ֖יְלָה בֹּ֑ו לְעֵינֵ֥י כָל־בֵּֽית־יִשְׂרָאֵ֖ל בְּכָל־מַסְעֵיהֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","וַיִּקְרָ֖א אֶל־מֹשֶׁ֑ה וַיְדַבֵּ֤ר יְהוָה֙ אֵלָ֔יו מֵאֹ֥הֶל מֹועֵ֖ד לֵאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","דַּבֵּ֞ר אֶל־בְּנֵ֤י יִשְׂרָאֵל֙ וְאָמַרְתָּ֣ אֲלֵהֶ֔ם אָדָ֗ם כִּֽי־יַקְרִ֥יב מִכֶּ֛ם קָרְבָּ֖ן לַֽיהוָ֑ה מִן־הַבְּהֵמָ֗ה מִן־הַבָּקָר֙ וּמִן־הַצֹּ֔אן תַּקְרִ֖יבוּ אֶת־קָרְבַּנְכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","אִם־עֹלָ֤ה קָרְבָּנֹו֙ מִן־הַבָּקָ֔ר זָכָ֥ר תָּמִ֖ים יַקְרִיבֶ֑נּוּ אֶל־פֶּ֝תַח אֹ֤הֶל מֹועֵד֙ יַקְרִ֣יב אֹתֹ֔ו לִרְצֹנֹ֖ו לִפְנֵ֥י יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","וְסָמַ֣ךְ יָדֹ֔ו עַ֖ל רֹ֣אשׁ הָעֹלָ֑ה וְנִרְצָ֥ה לֹ֖ו לְכַפֵּ֥ר עָלָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","וְשָׁחַ֛ט אֶת־בֶּ֥ן הַבָּקָ֖ר לִפְנֵ֣י יְהוָ֑ה וְ֠הִקְרִיבוּ בְּנֵ֨י אַהֲרֹ֤ן הֽ͏ַכֹּֽהֲנִים֙ אֶת־הַדָּ֔ם וְזָרְק֨וּ אֶת־הַדָּ֤ם עַל־הַמִּזְבֵּ֙חַ֙ סָבִ֔יב אֲשֶׁר־פֶּ֖תַח אֹ֥הֶל מֹועֵֽד׃ ");
INSERT INTO hbo_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","וְהִפְשִׁ֖יט אֶת־הָעֹלָ֑ה וְנִתַּ֥ח אֹתָ֖הּ לִנְתָחֶֽיהָ׃ ");
INSERT INTO hbo_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","וְ֠נָתְנוּ בְּנֵ֨י אַהֲרֹ֧ן הַכֹּהֵ֛ן אֵ֖שׁ עַל־הַמִּזְבֵּ֑חַ וְעָרְכ֥וּ עֵצִ֖ים עַל־הָאֵֽשׁ׃ ");
INSERT INTO hbo_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","וְעָרְכ֗וּ בְּנֵ֤י אַהֲרֹן֙ הַכֹּ֣הֲנִ֔ים אֵ֚ת הַנְּתָחִ֔ים אֶת־הָרֹ֖אשׁ וְאֶת־הַפָּ֑דֶר עַל־הָעֵצִים֙ אֲשֶׁ֣ר עַל־הָאֵ֔שׁ אֲשֶׁ֖ר עַל־הַמִּזְבֵּֽחַ׃ ");
INSERT INTO hbo_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","וְקִרְבֹּ֥ו וּכְרָעָ֖יו יִרְחַ֣ץ בַּמָּ֑יִם וְהִקְטִ֨יר הַכֹּהֵ֤ן אֶת־הַכֹּל֙ הַמִּזְבֵּ֔חָה עֹלָ֛ה אִשֵּׁ֥ה רֵֽיחַ־נִיחֹ֖וחַ לַֽיהוָֽה׃ ס ");
INSERT INTO hbo_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","וְאִם־מִן־הַצֹּ֨אן קָרְבָּנֹ֧ו מִן־הַכְּשָׂבִ֛ים אֹ֥ו מִן־הָעִזִּ֖ים לְעֹלָ֑ה זָכָ֥ר תָּמִ֖ים יַקְרִיבֶֽנּוּ׃ ");
INSERT INTO hbo_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","וְשָׁחַ֨ט אֹתֹ֜ו עַ֣ל יֶ֧רֶךְ הַמִּזְבֵּ֛חַ צָפֹ֖נָה לִפְנֵ֣י יְהוָ֑ה וְזָרְק֡וּ בְּנֵי֩ אַהֲרֹ֨ן הַכֹּהֲנִ֧ים אֶת־דָּמֹ֛ו עַל־הַמִּזְבֵּ֖חַ סָבִֽיב׃ ");
INSERT INTO hbo_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","וְנִתַּ֤ח אֹתֹו֙ לִנְתָחָ֔יו וְאֶת־רֹאשֹׁ֖ו וְאֶת־פִּדְרֹ֑ו וְעָרַ֤ךְ הַכֹּהֵן֙ אֹתָ֔ם עַל־הָֽעֵצִים֙ אֲשֶׁ֣ר עַל־הָאֵ֔שׁ אֲשֶׁ֖ר עַל־הַמִּזְבֵּֽחַ׃ ");
INSERT INTO hbo_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","וְהַקֶּ֥רֶב וְהַכְּרָעַ֖יִם יִרְחַ֣ץ בַּמָּ֑יִם וְהִקְרִ֨יב הַכֹּהֵ֤ן אֶת־הַכֹּל֙ וְהִקְטִ֣יר הַמִּזְבֵּ֔חָה עֹלָ֣ה ה֗וּא אִשֵּׁ֛ה רֵ֥יחַ נִיחֹ֖חַ לַיהוָֽה׃ פ ");
INSERT INTO hbo_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","וְאִ֧ם מִן־הָעֹ֛וף עֹלָ֥ה קָרְבָּנֹ֖ו לַֽיהוָ֑ה וְהִקְרִ֣יב מִן־הַתֹּרִ֗ים אֹ֛ו מִן־בְּנֵ֥י הַיֹּונָ֖ה אֶת־קָרְבָּנֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","וְהִקְרִיבֹ֤ו הַכֹּהֵן֙ אֶל־הַמִּזְבֵּ֔חַ וּמָלַק֙ אֶת־רֹאשֹׁ֔ו וְהִקְטִ֖יר הַמִּזְבֵּ֑חָה וְנִמְצָ֣ה דָמֹ֔ו עַ֖ל קִ֥יר הַמִּזְבֵּֽחַ׃ ");
INSERT INTO hbo_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","וְהֵסִ֥יר אֶת־מֻרְאָתֹ֖ו בְּנֹצָתָ֑הּ וְהִשְׁלִ֨יךְ אֹתָ֜הּ אֵ֤צֶל הַמִּזְבֵּ֙חַ֙ קֵ֔דְמָה אֶל־מְקֹ֖ום הַדָּֽשֶׁן׃ ");
INSERT INTO hbo_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","וְשִׁסַּ֨ע אֹתֹ֣ו בִכְנָפָיו֮ לֹ֣א יַבְדִּיל֒ וְהִקְטִ֨יר אֹתֹ֤ו הַכֹּהֵן֙ הַמִּזְבֵּ֔חָה עַל־הָעֵצִ֖ים אֲשֶׁ֣ר עַל־הָאֵ֑שׁ עֹלָ֣ה ה֗וּא אִשֵּׁ֛ה רֵ֥יחַ נִיחֹ֖חַ לַיהוָֽה׃ ס ");
INSERT INTO hbo_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","וְנֶ֗פֶשׁ כִּֽי־תַקְרִ֞יב קָרְבַּ֤ן מִנְחָה֙ לַֽיהוָ֔ה סֹ֖לֶת יִהְיֶ֣ה קָרְבָּנֹ֑ו וְיָצַ֤ק עָלֶ֙יהָ֙ שֶׁ֔מֶן וְנָתַ֥ן עָלֶ֖יהָ לְבֹנָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","וֽ͏ֶהֱבִיאָ֗הּ אֶל־בְּנֵ֣י אַהֲרֹן֮ הַכֹּהֲנִים֒ וְקָמַ֨ץ מִשָּׁ֜ם מְלֹ֣א קֻמְצֹ֗ו מִסָּלְתָּהּ֙ וּמִשַּׁמְנָ֔הּ עַ֖ל כָּל־לְבֹנָתָ֑הּ וְהִקְטִ֨יר הַכֹּהֵ֜ן אֶת־אַזְכָּרָתָהּ֙ הַמִּזְבֵּ֔חָה אִשֵּׁ֛ה רֵ֥יחַ נִיחֹ֖חַ לַיהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","וְהַנֹּותֶ֙רֶת֙ מִן־הַמִּנְחָ֔ה לְאַהֲרֹ֖ן וּלְבָנָ֑יו קֹ֥דֶשׁ קָֽדָשִׁ֖ים מֵאִשֵּׁ֥י יְהוָֽה׃ ס ");
INSERT INTO hbo_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","וְכִ֥י תַקְרִ֛ב קָרְבַּ֥ן מִנְחָ֖ה מַאֲפֵ֣ה תַנּ֑וּר סֹ֣לֶת חַלֹּ֤ות מַצֹּת֙ בְּלוּלֹ֣ת בַּשֶּׁ֔מֶן וּרְקִיקֵ֥י מַצֹּ֖ות מְשֻׁחִ֥ים בַּשָּֽׁמֶן׃ ס ");
INSERT INTO hbo_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","וְאִם־מִנְחָ֥ה עַל־הַֽמַּחֲבַ֖ת קָרְבָּנֶ֑ךָ סֹ֛לֶת בְּלוּלָ֥ה בַשֶּׁ֖מֶן מַצָּ֥ה תִהְיֶֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","פָּתֹ֤ות אֹתָהּ֙ פִּתִּ֔ים וְיָצַקְתָּ֥ עָלֶ֖יהָ שָׁ֑מֶן מִנְחָ֖ה הִֽוא׃ ס ");
INSERT INTO hbo_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","וְאִם־מִנְחַ֥ת מַרְחֶ֖שֶׁת קָרְבָּנֶ֑ךָ סֹ֥לֶת בַּשֶּׁ֖מֶן תֵּעָשֶֽׂה׃ ");
INSERT INTO hbo_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","וְהֵבֵאתָ֣ אֶת־הַמִּנְחָ֗ה אֲשֶׁ֧ר יֵעָשֶׂ֛ה מֵאֵ֖לֶּה לַיהוָ֑ה וְהִקְרִיבָהּ֙ אֶל־הַכֹּהֵ֔ן וְהִגִּישָׁ֖הּ אֶל־הַמִּזְבֵּֽחַ׃ ");
INSERT INTO hbo_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","וְהֵרִ֨ים הַכֹּהֵ֤ן מִן־הַמִּנְחָה֙ אֶת־אַזְכָּ֣רָתָ֔הּ וְהִקְטִ֖יר הַמִּזְבֵּ֑חָה אִשֵּׁ֛ה רֵ֥יחַ נִיחֹ֖חַ לַיהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","וְהַנֹּותֶ֙רֶת֙ מִן־הַמִּנְחָ֔ה לְאַהֲרֹ֖ן וּלְבָנָ֑יו קֹ֥דֶשׁ קֽ͏ָדָשִׁ֖ים מֵאִשֵּׁ֥י יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","כָּל־הַמִּנְחָ֗ה אֲשֶׁ֤ר תַּקְרִ֙יבוּ֙ לַיהוָ֔ה לֹ֥א תֵעָשֶׂ֖ה חָמֵ֑ץ כִּ֤י כָל־שְׂאֹר֙ וְכָל־דְּבַ֔שׁ לֹֽא־תַקְטִ֧ירוּ מִמֶּ֛נּוּ אִשֶּׁ֖ה לַֽיהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","קָרְבַּ֥ן רֵאשִׁ֛ית תַּקְרִ֥יבוּ אֹתָ֖ם לַיהוָ֑ה וְאֶל־הַמִּזְבֵּ֥חַ לֹא־יַעֲל֖וּ לְרֵ֥יחַ נִיחֹֽחַ׃ ");
INSERT INTO hbo_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","וְכָל־קָרְבַּ֣ן מִנְחָתְךָ֮ בַּמֶּ֣לַח תִּמְלָח֒ וְלֹ֣א תַשְׁבִּ֗ית מֶ֚לַח בְּרִ֣ית אֱלֹהֶ֔יךָ מֵעַ֖ל מִנְחָתֶ֑ךָ עַ֥ל כָּל־קָרְבָּנְךָ֖ תַּקְרִ֥יב מֶֽלַח׃ ס ");
INSERT INTO hbo_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","וְאִם־תַּקְרִ֛יב מִנְחַ֥ת בִּכּוּרִ֖ים לַיהוָ֑ה אָבִ֞יב קָל֤וּי בָּאֵשׁ֙ גֶּ֣רֶשׂ כַּרְמֶ֔ל תַּקְרִ֕יב אֵ֖ת מִנְחַ֥ת בִּכּוּרֶֽיךָ׃ ");
INSERT INTO hbo_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","וְנָתַתָּ֤ עָלֶ֙יהָ֙ שֶׁ֔מֶן וְשַׂמְתָּ֥ עָלֶ֖יהָ לְבֹנָ֑ה מִנְחָ֖ה הִֽוא׃ ");
INSERT INTO hbo_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","וְהִקְטִ֨יר הַכֹּהֵ֜ן אֶת־אַזְכָּרָתָ֗הּ מִגִּרְשָׂהּ֙ וּמִשַּׁמְנָ֔הּ עַ֖ל כָּל־לְבֹנָתָ֑הּ אִשֶּׁ֖ה לַיהוָֽה׃ פ ");
INSERT INTO hbo_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","וְאִם־זֶ֥בַח שְׁלָמִ֖ים קָרְבָּנֹ֑ו אִ֤ם מִן־הַבָּקָר֙ ה֣וּא מַקְרִ֔יב אִם־זָכָר֙ אִם־נְקֵבָ֔ה תָּמִ֥ים יַקְרִיבֶ֖נּוּ לִפְנֵ֥י יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","וְסָמַ֤ךְ יָדֹו֙ עַל־רֹ֣אשׁ קָרְבָּנֹ֔ו וּשְׁחָטֹ֕ו פֶּ֖תַח אֹ֣הֶל מֹועֵ֑ד וְזָרְק֡וּ בְּנֵי֩ אַהֲרֹ֨ן הַכֹּהֲנִ֧ים אֶת־הַדָּ֛ם עַל־הַמִּזְבֵּ֖חַ סָבִֽיב׃ ");
INSERT INTO hbo_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","וְהִקְרִיב֙ מִזֶּ֣בַח הַשְּׁלָמִ֔ים אִשֶּׁ֖ה לַיהוָ֑ה אֶת־הַחֵ֙לֶב֙ הַֽמְכַסֶּ֣ה אֶת־הַקֶּ֔רֶב וְאֵת֙ כָּל־הַחֵ֔לֶב אֲשֶׁ֖ר עַל־הַקֶּֽרֶב׃ ");
INSERT INTO hbo_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","וְאֵת֙ שְׁתֵּ֣י הַכְּלָיֹ֔ת וְאֶת־הַחֵ֙לֶב֙ אֲשֶׁ֣ר עֲלֵהֶ֔ן אֲשֶׁ֖ר עַל־הַכְּסָלִ֑ים וְאֶת־הַיֹּתֶ֙רֶת֙ עַל־הַכָּבֵ֔ד עַל־הַכְּלָיֹ֖ות יְסִירֶֽנָּה׃ ");
INSERT INTO hbo_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","וְהִקְטִ֨ירוּ אֹתֹ֤ו בְנֵֽי־אַהֲרֹן֙ הַמִּזְבֵּ֔חָה עַל־הָ֣עֹלָ֔ה אֲשֶׁ֥ר עַל־הָעֵצִ֖ים אֲשֶׁ֣ר עַל־הָאֵ֑שׁ אִשֵּׁ֛ה רֵ֥יחַ נִיחֹ֖חַ לַֽיהוָֽה׃ פ ");
INSERT INTO hbo_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","וְאִם־מִן־הַצֹּ֧אן קָרְבָּנֹ֛ו לְזֶ֥בַח שְׁלָמִ֖ים לַיהוָ֑ה זָכָר֙ אֹ֣ו נְקֵבָ֔ה תָּמִ֖ים יַקְרִיבֶֽנּוּ׃ ");
INSERT INTO hbo_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","אִם־כֶּ֥שֶׂב הֽוּא־מַקְרִ֖יב אֶת־קָרְבָּנֹ֑ו וְהִקְרִ֥יב אֹתֹ֖ו לִפְנֵ֥י יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","וְסָמַ֤ךְ אֶת־יָדֹו֙ עַל־רֹ֣אשׁ קָרְבָּנֹ֔ו וְשָׁחַ֣ט אֹתֹ֔ו לִפְנֵ֖י אֹ֣הֶל מֹועֵ֑ד וְ֠זָרְקוּ בְּנֵ֨י אַהֲרֹ֧ן אֶת־דָּמֹ֛ו עַל־הַמִּזְבֵּ֖חַ סָבִֽיב׃ ");
INSERT INTO hbo_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","וְהִקְרִ֨יב מִזֶּ֣בַח הַשְּׁלָמִים֮ אִשֶּׁ֣ה לַיהוָה֒ חֶלְבֹּו֙ הָאַלְיָ֣ה תְמִימָ֔ה לְעֻמַּ֥ת הֶעָצֶ֖ה יְסִירֶ֑נָּה וְאֶת־הַחֵ֙לֶב֙ הַֽמְכַסֶּ֣ה אֶת־הַקֶּ֔רֶב וְאֵת֙ כָּל־הַחֵ֔לֶב אֲשֶׁ֖ר עַל־הַקֶּֽרֶב׃ ");
INSERT INTO hbo_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","וְאֵת֙ שְׁתֵּ֣י הַכְּלָיֹ֔ת וְאֶת־הַחֵ֙לֶב֙ אֲשֶׁ֣ר עֲלֵהֶ֔ן אֲשֶׁ֖ר עַל־הַכְּסָלִ֑ים וְאֶת־הַיֹּתֶ֙רֶת֙ עַל־הַכָּבֵ֔ד עַל־הַכְּלָיֹ֖ת יְסִירֶֽנָּה׃ ");
INSERT INTO hbo_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","וְהִקְטִירֹ֥ו הַכֹּהֵ֖ן הַמִּזְבֵּ֑חָה לֶ֥חֶם אִשֶּׁ֖ה לַיהוָֽה׃ פ ");
INSERT INTO hbo_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","וְאִ֥ם עֵ֖ז קָרְבָּנֹ֑ו וְהִקְרִיבֹ֖ו לִפְנֵ֥י יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","וְסָמַ֤ךְ אֶת־יָדֹו֙ עַל־רֹאשֹׁ֔ו וְשָׁחַ֣ט אֹתֹ֔ו לִפְנֵ֖י אֹ֣הֶל מֹועֵ֑ד וְ֠זָרְקוּ בְּנֵ֨י אַהֲרֹ֧ן אֶת־דָּמֹ֛ו עַל־הַמִּזְבֵּ֖חַ סָבִֽיב׃ ");
INSERT INTO hbo_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","וְהִקְרִ֤יב מִמֶּ֙נּוּ֙ קָרְבָּנֹ֔ו אִשֶּׁ֖ה לַֽיהוָ֑ה אֶת־הַחֵ֙לֶב֙ הַֽמְכַסֶּ֣ה אֶת־הַקֶּ֔רֶב וְאֵת֙ כָּל־הַחֵ֔לֶב אֲשֶׁ֖ר עַל־הַקֶּֽרֶב׃ ");
INSERT INTO hbo_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","וְאֵת֙ שְׁתֵּ֣י הַכְּלָיֹ֔ת וְאֶת־הַחֵ֙לֶב֙ אֲשֶׁ֣ר עֲלֵהֶ֔ן אֲשֶׁ֖ר עַל־הַכְּסָלִ֑ים וְאֶת־הַיֹּתֶ֙רֶת֙ עַל־הַכָּבֵ֔ד עַל־הַכְּלָיֹ֖ת יְסִירֶֽנָּה׃ ");
INSERT INTO hbo_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","וְהִקְטִירָ֥ם הַכֹּהֵ֖ן הַמִּזְבֵּ֑חָה לֶ֤חֶם אִשֶּׁה֙ לְרֵ֣יחַ נִיחֹ֔חַ כָּל־חֵ֖לֶב לַיהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","חֻקַּ֤ת עֹולָם֙ לְדֹרֹ֣תֵיכֶ֔ם בְּכֹ֖ל מֹֽושְׁבֹתֵיכֶ֑ם כָּל־חֵ֥לֶב וְכָל־דָּ֖ם לֹ֥א תֹאכֵֽלוּ׃ פ ");
INSERT INTO hbo_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","דַּבֵּ֞ר אֶל־בְּנֵ֣י יִשְׂרָאֵל֮ לֵאמֹר֒ נֶ֗פֶשׁ כִּֽי־תֶחֱטָ֤א בִשְׁגָגָה֙ מִכֹּל֙ מִצְוֹ֣ת יְהוָ֔ה אֲשֶׁ֖ר לֹ֣א תֵעָשֶׂ֑ינָה וְעָשָׂ֕ה מֵאַחַ֖ת מֵהֵֽנָּה׃ ");
INSERT INTO hbo_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","אִ֣ם הַכֹּהֵ֧ן הַמָּשִׁ֛יחַ יֶחֱטָ֖א לְאַשְׁמַ֣ת הָעָ֑ם וְהִקְרִ֡יב עַ֣ל חַטָּאתֹו֩ אֲשֶׁ֨ר חָטָ֜א פַּ֣ר בֶּן־בָּקָ֥ר תָּמִ֛ים לַיהוָ֖ה לְחַטָּֽאת׃ ");
INSERT INTO hbo_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","וְהֵבִ֣יא אֶת־הַפָּ֗ר אֶל־פֶּ֛תַח אֹ֥הֶל מֹועֵ֖ד לִפְנֵ֣י יְהוָ֑ה וְסָמַ֤ךְ אֶת־יָדֹו֙ עַל־רֹ֣אשׁ הַפָּ֔ר וְשָׁחַ֥ט אֶת־הַפָּ֖ר לִפְנֵ֥י יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","וְלָקַ֛ח הַכֹּהֵ֥ן הַמָּשִׁ֖יחַ מִדַּ֣ם הַפָּ֑ר וְהֵבִ֥יא אֹתֹ֖ו אֶל־אֹ֥הֶל מֹועֵֽד׃ ");
INSERT INTO hbo_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","וְטָבַ֧ל הַכֹּהֵ֛ן אֶת־אֶצְבָּעֹ֖ו בַּדָּ֑ם וְהִזָּ֨ה מִן־הַדָּ֜ם שֶׁ֤בַע פְּעָמִים֙ לִפְנֵ֣י יְהוָ֔ה אֶת־פְּנֵ֖י פָּרֹ֥כֶת הַקֹּֽדֶשׁ׃ ");
INSERT INTO hbo_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","וְנָתַן֩ הַכֹּהֵ֨ן מִן־הַדָּ֜ם עַל־קַ֠רְנֹות מִזְבַּ֨ח קְטֹ֤רֶת הַסַּמִּים֙ לִפְנֵ֣י יְהוָ֔ה אֲשֶׁ֖ר בְּאֹ֣הֶל מֹועֵ֑ד וְאֵ֣ת ׀ כָּל־דַּ֣ם הַפָּ֗ר יִשְׁפֹּךְ֙ אֶל־יְסֹוד֙ מִזְבַּ֣ח הָעֹלָ֔ה אֲשֶׁר־פֶּ֖תַח אֹ֥הֶל מֹועֵֽד׃ ");
INSERT INTO hbo_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","וְאֶת־כָּל־חֵ֛לֶב פַּ֥ר הַֽחַטָּ֖את יָרִ֣ים מִמֶּ֑נּוּ אֶת־הַחֵ֙לֶב֙ הַֽמְכַסֶּ֣ה עַל־הַקֶּ֔רֶב וְאֵת֙ כָּל־הַחֵ֔לֶב אֲשֶׁ֖ר עַל־הַקֶּֽרֶב׃ ");
INSERT INTO hbo_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","וְאֵת֙ שְׁתֵּ֣י הַכְּלָיֹ֔ת וְאֶת־הַחֵ֙לֶב֙ אֲשֶׁ֣ר עֲלֵיהֶ֔ן אֲשֶׁ֖ר עַל־הַכְּסָלִ֑ים וְאֶת־הַיֹּתֶ֙רֶת֙ עַל־הַכָּבֵ֔ד עַל־הַכְּלָיֹ֖ות יְסִירֶֽנָּה׃ ");
INSERT INTO hbo_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","כַּאֲשֶׁ֣ר יוּרַ֔ם מִשֹּׁ֖ור זֶ֣בַח הַשְּׁלָמִ֑ים וְהִקְטִירָם֙ הַכֹּהֵ֔ן עַ֖ל מִזְבַּ֥ח הָעֹלָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","וְאֶת־עֹ֤ור הַפָּר֙ וְאֶת־כָּל־בְּשָׂרֹ֔ו עַל־רֹאשֹׁ֖ו וְעַל־כְּרָעָ֑יו וְקִרְבֹּ֖ו וּפִרְשֹֽׁו׃ ");
INSERT INTO hbo_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","וְהֹוצִ֣יא אֶת־כָּל־הַ֠פָּר אֶל־מִח֨וּץ לַֽמַּחֲנֶ֜ה אֶל־מָקֹ֤ום טָהֹור֙ אֶל־שֶׁ֣פֶךְ הַדֶּ֔שֶׁן וְשָׂרַ֥ף אֹתֹ֛ו עַל־עֵצִ֖ים בָּאֵ֑שׁ עַל־שֶׁ֥פֶךְ הַדֶּ֖שֶׁן יִשָּׂרֵֽף׃ פ ");
INSERT INTO hbo_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","וְאִ֨ם כָּל־עֲדַ֤ת יִשְׂרָאֵל֙ יִשְׁגּ֔וּ וְנֶעְלַ֣ם דָּבָ֔ר מֵעֵינֵ֖י הַקָּהָ֑ל וְ֠עָשׂוּ אַחַ֨ת מִכָּל־מִצְוֹ֧ת יְהוָ֛ה אֲשֶׁ֥ר לֹא־תֵעָשֶׂ֖ינָה וְאָשֵֽׁמוּ׃ ");
INSERT INTO hbo_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","וְנֹֽודְעָה֙ הַֽחַטָּ֔את אֲשֶׁ֥ר חָטְא֖וּ עָלֶ֑יהָ וְהִקְרִ֨יבוּ הַקָּהָ֜ל פַּ֤ר בֶּן־בָּקָר֙ לְחַטָּ֔את וְהֵבִ֣יאוּ אֹתֹ֔ו לִפְנֵ֖י אֹ֥הֶל מֹועֵֽד׃ ");
INSERT INTO hbo_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","וְ֠סָמְכוּ זִקְנֵ֨י הָעֵדָ֧ה אֶת־יְדֵיהֶ֛ם עַל־רֹ֥אשׁ הַפָּ֖ר לִפְנֵ֣י יְהוָ֑ה וְשָׁחַ֥ט אֶת־הַפָּ֖ר לִפְנֵ֥י יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","וְהֵבִ֛יא הַכֹּהֵ֥ן הַמָּשִׁ֖יחַ מִדַּ֣ם הַפָּ֑ר אֶל־אֹ֖הֶל מֹועֵֽד׃ ");
INSERT INTO hbo_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","וְטָבַ֧ל הַכֹּהֵ֛ן אֶצְבָּעֹ֖ו מִן־הַדָּ֑ם וְהִזָּ֞ה שֶׁ֤בַע פְּעָמִים֙ לִפְנֵ֣י יְהוָ֔ה אֵ֖ת פְּנֵ֥י הַפָּרֹֽכֶת׃ ");
INSERT INTO hbo_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","וּמִן־הַדָּ֞ם יִתֵּ֣ן ׀ עַל־קַרְנֹ֣ת הַמִּזְבֵּ֗חַ אֲשֶׁר֙ לִפְנֵ֣י יְהוָ֔ה אֲשֶׁ֖ר בְּאֹ֣הֶל מֹועֵ֑ד וְאֵ֣ת כָּל־הַדָּ֗ם יִשְׁפֹּךְ֙ אֶל־יְסֹוד֙ מִזְבַּ֣ח הָעֹלָ֔ה אֲשֶׁר־פֶּ֖תַח אֹ֥הֶל מֹועֵֽד׃ ");
INSERT INTO hbo_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","וְאֵ֥ת כָּל־חֶלְבֹּ֖ו יָרִ֣ים מִמֶּ֑נּוּ וְהִקְטִ֖יר הַמִּזְבֵּֽחָה׃ ");
INSERT INTO hbo_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","וְעָשָׂ֣ה לַפָּ֔ר כַּאֲשֶׁ֤ר עָשָׂה֙ לְפַ֣ר הַֽחַטָּ֔את כֵּ֖ן יַעֲשֶׂה־לֹּ֑ו וְכִפֶּ֧ר עֲלֵהֶ֛ם הַכֹּהֵ֖ן וְנִסְלַ֥ח לָהֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","וְהֹוצִ֣יא אֶת־הַפָּ֗ר אֶל־מִחוּץ֙ לַֽמַּחֲנֶ֔ה וְשָׂרַ֣ף אֹתֹ֔ו כַּאֲשֶׁ֣ר שָׂרַ֔ף אֵ֖ת הַפָּ֣ר הָרִאשֹׁ֑ון חַטַּ֥את הַקָּהָ֖ל הֽוּא׃ פ ");
INSERT INTO hbo_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","אֲשֶׁ֥ר נָשִׂ֖יא יֶֽחֱטָ֑א וְעָשָׂ֡ה אַחַ֣ת מִכָּל־מִצְוֹת֩ יְהוָ֨ה אֱלֹהָ֜יו אֲשֶׁ֧ר לֹא־תֵעָשֶׂ֛ינָה בִּשְׁגָגָ֖ה וְאָשֵֽׁם׃ ");
INSERT INTO hbo_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","אֹֽו־הֹודַ֤ע אֵלָיו֙ חַטָּאתֹ֔ו אֲשֶׁ֥ר חָטָ֖א בָּ֑הּ וְהֵבִ֧יא אֶת־קָרְבָּנֹ֛ו שְׂעִ֥יר עִזִּ֖ים זָכָ֥ר תָּמִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","וְסָמַ֤ךְ יָדֹו֙ עַל־רֹ֣אשׁ הַשָּׂעִ֔יר וְשָׁחַ֣ט אֹתֹ֔ו בִּמְקֹ֛ום אֲשֶׁר־יִשְׁחַ֥ט אֶת־הָעֹלָ֖ה לִפְנֵ֣י יְהוָ֑ה חַטָּ֖את הֽוּא׃ ");
INSERT INTO hbo_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","וְלָקַ֨ח הַכֹּהֵ֜ן מִדַּ֤ם הַֽחַטָּאת֙ בְּאֶצְבָּעֹ֔ו וְנָתַ֕ן עַל־קַרְנֹ֖ת מִזְבַּ֣ח הָעֹלָ֑ה וְאֶת־דָּמֹ֣ו יִשְׁפֹּ֔ךְ אֶל־יְסֹ֖וד מִזְבַּ֥ח הָעֹלָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","וְאֶת־כָּל־חֶלְבֹּו֙ יַקְטִ֣יר הַמִּזְבֵּ֔חָה כְּחֵ֖לֶב זֶ֣בַח הַשְּׁלָמִ֑ים וְכִפֶּ֨ר עָלָ֧יו הַכֹּהֵ֛ן מֵחַטָּאתֹ֖ו וְנִסְלַ֥ח לֹֽו׃ פ ");
INSERT INTO hbo_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","וְאִם־נֶ֧פֶשׁ אַחַ֛ת תֶּחֱטָ֥א בִשְׁגָגָ֖ה מֵעַ֣ם הָאָ֑רֶץ בַּ֠עֲשֹׂתָהּ אַחַ֨ת מִמִּצְוֹ֧ת יְהוָ֛ה אֲשֶׁ֥ר לֹא־תֵעָשֶׂ֖ינָה וְאָשֵֽׁם׃ ");
INSERT INTO hbo_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","אֹ֚ו הֹודַ֣ע אֵלָ֔יו חַטָּאתֹ֖ו אֲשֶׁ֣ר חָטָ֑א וְהֵבִ֨יא קָרְבָּנֹ֜ו שְׂעִירַ֤ת עִזִּים֙ תְּמִימָ֣ה נְקֵבָ֔ה עַל־חַטָּאתֹ֖ו אֲשֶׁ֥ר חָטָֽא׃ ");
INSERT INTO hbo_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","וְסָמַךְ֙ אֶת־יָדֹ֔ו עַ֖ל רֹ֣אשׁ הַֽחַטָּ֑את וְשָׁחַט֙ אֶת־הַ֣חַטָּ֔את בִּמְקֹ֖ום הָעֹלָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","וְלָקַ֨ח הַכֹּהֵ֤ן מִדָּמָהּ֙ בְּאֶצְבָּעֹ֔ו וְנָתַ֕ן עַל־קַרְנֹ֖ת מִזְבַּ֣ח הָעֹלָ֑ה וְאֶת־כָּל־דָּמָ֣הּ יִשְׁפֹּ֔ךְ אֶל־יְסֹ֖וד הַמִּזְבֵּֽחַ׃ ");
INSERT INTO hbo_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","וְאֶת־כָּל־חֶלְבָּ֣הּ יָסִ֗יר כַּאֲשֶׁ֨ר הוּסַ֣ר חֵלֶב֮ מֵעַ֣ל זֶ֣בַח הַשְּׁלָמִים֒ וְהִקְטִ֤יר הַכֹּהֵן֙ הַמִּזְבֵּ֔חָה לְרֵ֥יחַ נִיחֹ֖חַ לַיהוָ֑ה וְכִפֶּ֥ר עָלָ֛יו הַכֹּהֵ֖ן וְנִסְלַ֥ח לֹֽו׃ פ ");
INSERT INTO hbo_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","וְאִם־כֶּ֛בֶשׂ יָבִ֥יא קָרְבָּנֹ֖ו לְחַטָּ֑את נְקֵבָ֥ה תְמִימָ֖ה יְבִיאֶֽנָּה׃ ");
INSERT INTO hbo_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","וְסָמַךְ֙ אֶת־יָדֹ֔ו עַ֖ל רֹ֣אשׁ הַֽחַטָּ֑את וְשָׁחַ֤ט אֹתָהּ֙ לְחַטָּ֔את בִּמְקֹ֕ום אֲשֶׁ֥ר יִשְׁחַ֖ט אֶת־הָעֹלָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","וְלָקַ֨ח הַכֹּהֵ֜ן מִדַּ֤ם הַֽחַטָּאת֙ בְּאֶצְבָּעֹ֔ו וְנָתַ֕ן עַל־קַרְנֹ֖ת מִזְבַּ֣ח הָעֹלָ֑ה וְאֶת־כָּל־דָּמָ֣הּ יִשְׁפֹּ֔ךְ אֶל־יְסֹ֖וד הַמִּזְבֵּֽחַ׃ ");
INSERT INTO hbo_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","וְאֶת־כָּל־חֶלְבָּ֣ה יָסִ֗יר כַּאֲשֶׁ֨ר יוּסַ֥ר חֵֽלֶב־הַכֶּשֶׂב֮ מִזֶּ֣בַח הַשְּׁלָמִים֒ וְהִקְטִ֨יר הַכֹּהֵ֤ן אֹתָם֙ הַמִּזְבֵּ֔חָה עַ֖ל אִשֵּׁ֣י יְהוָ֑ה וְכִפֶּ֨ר עָלָ֧יו הַכֹּהֵ֛ן עַל־חַטָּאתֹ֥ו אֲשֶׁר־חָטָ֖א וְנִסְלַ֥ח לֹֽו׃ פ ");
INSERT INTO hbo_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","וְנֶ֣פֶשׁ כִּֽי־תֶחֱטָ֗א וְשָֽׁמְעָה֙ קֹ֣ול אָלָ֔ה וְה֣וּא עֵ֔ד אֹ֥ו רָאָ֖ה אֹ֣ו יָדָ֑ע אִם־לֹ֥וא יַגִּ֖יד וְנָשָׂ֥א עֲוֹנֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","אֹ֣ו נֶ֗פֶשׁ אֲשֶׁ֣ר תִּגַּע֮ בְּכָל־דָּבָ֣ר טָמֵא֒ אֹו֩ בְנִבְלַ֨ת חַיָּ֜ה טְמֵאָ֗ה אֹ֚ו בְּנִבְלַת֙ בְּהֵמָ֣ה טְמֵאָ֔ה אֹ֕ו בְּנִבְלַ֖ת שֶׁ֣רֶץ טָמֵ֑א וְנֶעְלַ֣ם מִמֶּ֔נּוּ וְה֥וּא טָמֵ֖א וְאָשֵֽׁם׃ ");
INSERT INTO hbo_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","אֹ֣ו כִ֤י יִגַּע֙ בְּטֻמְאַ֣ת אָדָ֔ם לְכֹל֙ טֻמְאָתֹ֔ו אֲשֶׁ֥ר יִטְמָ֖א בָּ֑הּ וְנֶעְלַ֣ם מִמֶּ֔נּוּ וְה֥וּא יָדַ֖ע וְאָשֵֽׁם׃ ");
INSERT INTO hbo_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","אֹ֣ו נֶ֡פֶשׁ כִּ֣י תִשָּׁבַע֩ לְבַטֵּ֨א בִשְׂפָתַ֜יִם לְהָרַ֣ע ׀ אֹ֣ו לְהֵיטִ֗יב לְ֠כֹל אֲשֶׁ֨ר יְבַטֵּ֧א הָאָדָ֛ם בִּשְׁבֻעָ֖ה וְנֶעְלַ֣ם מִמֶּ֑נּוּ וְהוּא־יָדַ֥ע וְאָשֵׁ֖ם לְאַחַ֥ת מֵאֵֽלֶּה׃ ");
INSERT INTO hbo_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","וְהָיָ֥ה כִֽי־יֶאְשַׁ֖ם לְאַחַ֣ת מֵאֵ֑לֶּה וְהִ֨תְוַדָּ֔ה אֲשֶׁ֥ר חָטָ֖א עָלֶֽיהָ׃ ");
INSERT INTO hbo_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","וְהֵבִ֣יא אֶת־אֲשָׁמֹ֣ו לַיהוָ֡ה עַ֣ל חַטָּאתֹו֩ אֲשֶׁ֨ר חָטָ֜א נְקֵבָ֨ה מִן־הַצֹּ֥אן כִּשְׂבָּ֛ה אֹֽו־שְׂעִירַ֥ת עִזִּ֖ים לְחַטָּ֑את וְכִפֶּ֥ר עָלָ֛יו הַכֹּהֵ֖ן מֵחַטָּאתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","וְאִם־לֹ֨א תַגִּ֣יע יָדֹו֮ דֵּ֣י שֶׂה֒ וְהֵבִ֨יא אֶת־אֲשָׁמֹ֜ו אֲשֶׁ֣ר חָטָ֗א שְׁתֵּ֥י תֹרִ֛ים אֹֽו־שְׁנֵ֥י בְנֵֽי־יֹונָ֖ה לַֽיהוָ֑ה אֶחָ֥ד לְחַטָּ֖את וְאֶחָ֥ד לְעֹלָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","וְהֵבִ֤יא אֹתָם֙ אֶל־הַכֹּהֵ֔ן וְהִקְרִ֛יב אֶת־אֲשֶׁ֥ר לַחַטָּ֖את רִאשֹׁונָ֑ה וּמָלַ֧ק אֶת־רֹאשֹׁ֛ו מִמּ֥וּל עָרְפֹּ֖ו וְלֹ֥א יַבְדִּֽיל׃ ");
INSERT INTO hbo_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","וְהִזָּ֞ה מִדַּ֤ם הַחַטָּאת֙ עַל־קִ֣יר הַמִּזְבֵּ֔חַ וְהַנִּשְׁאָ֣ר בַּדָּ֔ם יִמָּצֵ֖ה אֶל־יְסֹ֣וד הַמִּזְבֵּ֑חַ חַטָּ֖את הֽוּא׃ ");
INSERT INTO hbo_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","וְאֶת־הַשֵּׁנִ֛י יַעֲשֶׂ֥ה עֹלָ֖ה כַּמִּשְׁפָּ֑ט וְכִפֶּ֨ר עָלָ֧יו הַכֹּהֵ֛ן מֵחַטָּאתֹ֥ו אֲשֶׁר־חָטָ֖א וְנִסְלַ֥ח לֹֽו׃ ס ");
INSERT INTO hbo_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","וְאִם־לֹא֩ תַשִּׂ֨יג יָדֹ֜ו לִשְׁתֵּ֣י תֹרִ֗ים אֹו֮ לִשְׁנֵ֣י בְנֵי־יֹונָה֒ וְהֵבִ֨יא אֶת־קָרְבָּנֹ֜ו אֲשֶׁ֣ר חָטָ֗א עֲשִׂירִ֧ת הָאֵפָ֛ה סֹ֖לֶת לְחַטָּ֑את לֹא־יָשִׂ֨ים עָלֶ֜יהָ שֶׁ֗מֶן וְלֹא־יִתֵּ֤ן עָלֶ֙יהָ֙ לְבֹנָ֔ה כִּ֥י חַטָּ֖את הִֽיא׃ ");
INSERT INTO hbo_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","וֶהֱבִיאָהּ֮ אֶל־הַכֹּהֵן֒ וְקָמַ֣ץ הַכֹּהֵ֣ן ׀ מִ֠מֶּנָּה מְלֹ֨וא קֻמְצֹ֜ו אֶת־אַזְכָּרָתָה֙ וְהִקְטִ֣יר הַמִּזְבֵּ֔חָה עַ֖ל אִשֵּׁ֣י יְהוָ֑ה חַטָּ֖את הִֽוא׃ ");
INSERT INTO hbo_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","וְכִפֶּר֩ עָלָ֨יו הַכֹּהֵ֜ן עַל־חַטָּאתֹ֧ו אֲשֶׁר־חָטָ֛א מֵֽאַחַ֥ת מֵאֵ֖לֶּה וְנִסְלַ֣ח לֹ֑ו וְהָיְתָ֥ה לַכֹּהֵ֖ן כַּמִּנְחָֽה׃ ס ");
INSERT INTO hbo_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","נֶ֚פֶשׁ כִּֽי־תִמְעֹ֣ל מַ֔עַל וְחָֽטְאָה֙ בִּשְׁגָגָ֔ה מִקָּדְשֵׁ֖י יְהוָ֑ה וְהֵבִיא֩ אֶת־אֲשָׁמֹ֨ו לַֽיהוָ֜ה אַ֧יִל תָּמִ֣ים מִן־הַצֹּ֗אן בְּעֶרְכְּךָ֛ כֶּֽסֶף־שְׁקָלִ֥ים בְּשֶֽׁקֶל־הַקֹּ֖דֶשׁ לְאָשָֽׁם׃ ");
INSERT INTO hbo_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","וְאֵ֣ת אֲשֶׁר֩ חָטָ֨א מִן־הַקֹּ֜דֶשׁ יְשַׁלֵּ֗ם וְאֶת־חֲמִֽישִׁתֹו֙ יֹוסֵ֣ף עָלָ֔יו וְנָתַ֥ן אֹתֹ֖ו לַכֹּהֵ֑ן וְהַכֹּהֵ֗ן יְכַפֵּ֥ר עָלָ֛יו בְּאֵ֥יל הָאָשָׁ֖ם וְנִסְלַ֥ח לֹֽו׃ פ ");
INSERT INTO hbo_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","וְאִם־נֶ֙פֶשׁ֙ כִּ֣י תֶֽחֱטָ֔א וְעָֽשְׂתָ֗ה אַחַת֙ מִכָּל־מִצְוֹ֣ת יְהוָ֔ה אֲשֶׁ֖ר לֹ֣א תֵעָשֶׂ֑ינָה וְלֹֽא־יָדַ֥ע וְאָשֵׁ֖ם וְנָשָׂ֥א עֲוֹנֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","וְ֠הֵבִיא אַ֣יִל תָּמִ֧ים מִן־הַצֹּ֛אן בְּעֶרְכְּךָ֥ לְאָשָׁ֖ם אֶל־הַכֹּהֵ֑ן וְכִפֶּר֩ עָלָ֨יו הַכֹּהֵ֜ן עַ֣ל שִׁגְגָתֹ֧ו אֲשֶׁר־שָׁגָ֛ג וְה֥וּא לֹֽא־יָדַ֖ע וְנִסְלַ֥ח לֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","אָשָׁ֖ם ה֑וּא אָשֹׁ֥ם אָשַׁ֖ם לַיהוָֽה׃ פ ");
INSERT INTO hbo_vpl VALUES ("LV5_20","004_5_20","LEV","5","20","20","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("LV5_21","004_5_21","LEV","5","21","21","נֶ֚פֶשׁ כִּ֣י תֶחֱטָ֔א וּמָעֲלָ֥ה מַ֖עַל בַּיהוָ֑ה וְכִחֵ֨שׁ בַּעֲמִיתֹ֜ו בְּפִקָּדֹ֗ון אֹֽו־בִתְשׂ֤וּמֶת יָד֙ אֹ֣ו בְגָזֵ֔ל אֹ֖ו עָשַׁ֥ק אֶת־עֲמִיתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("LV5_22","004_5_22","LEV","5","22","22","אֹֽו־מָצָ֧א אֲבֵדָ֛ה וְכִ֥חֶשׁ בָּ֖הּ וְנִשְׁבַּ֣ע עַל־שָׁ֑קֶר עַל־אַחַ֗ת מִכֹּ֛ל אֲשֶׁר־יַעֲשֶׂ֥ה הָאָדָ֖ם לַחֲטֹ֥א בָהֵֽנָּה׃ ");
INSERT INTO hbo_vpl VALUES ("LV5_23","004_5_23","LEV","5","23","23","וְהָיָה֮ כִּֽי־יֶחֱטָ֣א וְאָשֵׁם֒ וְהֵשִׁ֨יב אֶת־הַגְּזֵלָ֜ה אֲשֶׁ֣ר גָּזָ֗ל אֹ֤ו אֶת־הָעֹ֙שֶׁק֙ אֲשֶׁ֣ר עָשָׁ֔ק אֹ֚ו אֶת־הַפִּקָּדֹ֔ון אֲשֶׁ֥ר הָפְקַ֖ד אִתֹּ֑ו אֹ֥ו אֶת־הָאֲבֵדָ֖ה אֲשֶׁ֥ר מָצָֽא׃ ");
INSERT INTO hbo_vpl VALUES ("LV5_24","004_5_24","LEV","5","24","24","אֹ֠ו מִכֹּ֞ל אֲשֶׁר־יִשָּׁבַ֣ע עָלָיו֮ לַשֶּׁקֶר֒ וְשִׁלַּ֤ם אֹתֹו֙ בְּרֹאשֹׁ֔ו וַחֲמִשִׁתָ֖יו יֹסֵ֣ף עָלָ֑יו לַאֲשֶׁ֨ר ה֥וּא לֹ֛ו יִתְּנֶ֖נּוּ בְּיֹ֥ום אַשְׁמָתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("LV5_25","004_5_25","LEV","5","25","25","וְאֶת־אֲשָׁמֹ֥ו יָבִ֖יא לַיהוָ֑ה אַ֣יִל תָּמִ֧ים מִן־הַצֹּ֛אן בְּעֶרְכְּךָ֥ לְאָשָׁ֖ם אֶל־הַכֹּהֵֽן׃ ");
INSERT INTO hbo_vpl VALUES ("LV5_26","004_5_26","LEV","5","26","26","וְכִפֶּ֨ר עָלָ֧יו הַכֹּהֵ֛ן לִפְנֵ֥י יְהוָ֖ה וְנִסְלַ֣ח לֹ֑ו עַל־אַחַ֛ת מִכֹּ֥ל אֲשֶֽׁר־יַעֲשֶׂ֖ה לְאַשְׁמָ֥ה בָֽהּ׃ פ ");
INSERT INTO hbo_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","צַ֤ו אֶֽת־אַהֲרֹן֙ וְאֶת־בָּנָ֣יו לֵאמֹ֔ר זֹ֥את תֹּורַ֖ת הָעֹלָ֑ה הִ֣וא הָעֹלָ֡ה עַל֩ מֹוקְדָ֨ה עַל־הַמִּזְבֵּ֤חַ כָּל־הַלַּ֙יְלָה֙ עַד־הַבֹּ֔קֶר וְאֵ֥שׁ הַמִּזְבֵּ֖חַ תּ֥וּקַד בֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","וְלָבַ֨שׁ הַכֹּהֵ֜ן מִדֹּ֣ו בַ֗ד וּמִֽכְנְסֵי־בַד֮ יִלְבַּ֣שׁ עַל־בְּשָׂרֹו֒ וְהֵרִ֣ים אֶת־הַדֶּ֗שֶׁן אֲשֶׁ֨ר תֹּאכַ֥ל הָאֵ֛שׁ אֶת־הָעֹלָ֖ה עַל־הַמִּזְבֵּ֑חַ וְשָׂמֹ֕ו אֵ֖צֶל הַמִּזְבֵּֽחַ׃ ");
INSERT INTO hbo_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","וּפָשַׁט֙ אֶת־בְּגָדָ֔יו וְלָבַ֖שׁ בְּגָדִ֣ים אֲחֵרִ֑ים וְהֹוצִ֤יא אֶת־הַדֶּ֙שֶׁן֙ אֶל־מִח֣וּץ לַֽמַּחֲנֶ֔ה אֶל־מָקֹ֖ום טָהֹֽור׃ ");
INSERT INTO hbo_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","וְהָאֵ֨שׁ עַל־הַמִּזְבֵּ֤חַ תּֽוּקַד־בֹּו֙ לֹ֣א תִכְבֶּ֔ה וּבִעֵ֨ר עָלֶ֧יהָ הַכֹּהֵ֛ן עֵצִ֖ים בַּבֹּ֣קֶר בַּבֹּ֑קֶר וְעָרַ֤ךְ עָלֶ֙יהָ֙ הָֽעֹלָ֔ה וְהִקְטִ֥יר עָלֶ֖יהָ חֶלְבֵ֥י הַשְּׁלָמִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","אֵ֗שׁ תָּמִ֛יד תּוּקַ֥ד עַל־הַמִּזְבֵּ֖חַ לֹ֥א תִכְבֶֽה׃ ס ");
INSERT INTO hbo_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","וְזֹ֥את תֹּורַ֖ת הַמִּנְחָ֑ה הַקְרֵ֨ב אֹתָ֤הּ בְּנֵֽי־אַהֲרֹן֙ לִפְנֵ֣י יְהוָ֔ה אֶל־פְּנֵ֖י הַמִּזְבֵּֽחַ׃ ");
INSERT INTO hbo_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","וְהֵרִ֨ים מִמֶּ֜נּוּ בְּקֻמְצֹ֗ו מִסֹּ֤לֶת הַמִּנְחָה֙ וּמִשַּׁמְנָ֔הּ וְאֵת֙ כָּל־הַלְּבֹנָ֔ה אֲשֶׁ֖ר עַל־הַמִּנְחָ֑ה וְהִקְטִ֣יר הַמִּזְבֵּ֗חַ רֵ֧יחַ נִיחֹ֛חַ אַזְכָּרָתָ֖הּ לַיהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","וְהַנֹּותֶ֣רֶת מִמֶּ֔נָּה יֹאכְל֖וּ אַהֲרֹ֣ן וּבָנָ֑יו מַצֹּ֤ות תֵּֽאָכֵל֙ בְּמָקֹ֣ום קָדֹ֔שׁ בַּחֲצַ֥ר אֹֽהֶל־מֹועֵ֖ד יֹאכְלֽוּהָ׃ ");
INSERT INTO hbo_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","לֹ֤א תֵאָפֶה֙ חָמֵ֔ץ חֶלְקָ֛ם נָתַ֥תִּי אֹתָ֖הּ מֵאִשָּׁ֑י קֹ֤דֶשׁ קָֽדָשִׁים֙ הִ֔וא כַּחַטָּ֖את וְכָאָשָֽׁם׃ ");
INSERT INTO hbo_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","כָּל־זָכָ֞ר בִּבְנֵ֤י אַהֲרֹן֙ יֹֽאכֲלֶ֔נָּה חָק־עֹולָם֙ לְדֹרֹ֣תֵיכֶ֔ם מֵאִשֵּׁ֖י יְהוָ֑ה כֹּ֛ל אֲשֶׁר־יִגַּ֥ע בָּהֶ֖ם יִקְדָּֽשׁ׃ פ ");
INSERT INTO hbo_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","זֶ֡ה קָרְבַּן֩ אַהֲרֹ֨ן וּבָנָ֜יו אֲשֶׁר־יַקְרִ֣יבוּ לַֽיהוָ֗ה בְּיֹום֙ הִמָּשַׁ֣ח אֹתֹ֔ו עֲשִׂירִ֨ת הָאֵפָ֥ה סֹ֛לֶת מִנְחָ֖ה תָּמִ֑יד מַחֲצִיתָ֣הּ בַּבֹּ֔קֶר וּמַחֲצִיתָ֖הּ בָּעָֽרֶב׃ ");
INSERT INTO hbo_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","עַֽל־מַחֲבַ֗ת בַּשֶּׁ֛מֶן תֵּעָשֶׂ֖ה מֻרְבֶּ֣כֶת תְּבִיאֶ֑נָּה תֻּפִינֵי֙ מִנְחַ֣ת פִּתִּ֔ים תַּקְרִ֥יב רֵֽיחַ־נִיחֹ֖חַ לַיהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","וְהַכֹּהֵ֨ן הַמָּשִׁ֧יחַ תַּחְתָּ֛יו מִבָּנָ֖יו יַעֲשֶׂ֣ה אֹתָ֑הּ חָק־עֹולָ֕ם לַיהוָ֖ה כָּלִ֥יל תָּקְטָֽר׃ ");
INSERT INTO hbo_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","וְכָל־מִנְחַ֥ת כֹּהֵ֛ן כָּלִ֥יל תִּהְיֶ֖ה לֹ֥א תֵאָכֵֽל׃ פ ");
INSERT INTO hbo_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","דַּבֵּ֤ר אֶֽל־אַהֲרֹן֙ וְאֶל־בָּנָ֣יו לֵאמֹ֔ר זֹ֥את תֹּורַ֖ת הַֽחַטָּ֑את בִּמְקֹ֡ום אֲשֶׁר֩ תִּשָּׁחֵ֨ט הָעֹלָ֜ה תִּשָּׁחֵ֤ט הַֽחַטָּאת֙ לִפְנֵ֣י יְהוָ֔ה קֹ֥דֶשׁ קֽ͏ָדָשִׁ֖ים הִֽוא׃ ");
INSERT INTO hbo_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","הַכֹּהֵ֛ן הַֽמְחַטֵּ֥א אֹתָ֖הּ יֹאכֲלֶ֑נָּה בְּמָקֹ֤ום קָדֹשׁ֙ תֵּֽאָכֵ֔ל בַּחֲצַ֖ר אֹ֥הֶל מֹועֵֽד׃ ");
INSERT INTO hbo_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","כֹּ֛ל אֲשֶׁר־יִגַּ֥ע בִּבְשָׂרָ֖הּ יִקְדָּ֑שׁ וַאֲשֶׁ֨ר יִזֶּ֤ה מִדָּמָהּ֙ עַל־הַבֶּ֔גֶד אֲשֶׁר֙ יִזֶּ֣ה עָלֶ֔יהָ תְּכַבֵּ֖ס בְּמָקֹ֥ום קָדֹֽשׁ׃ ");
INSERT INTO hbo_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","וּכְלִי־חֶ֛רֶשׂ אֲשֶׁ֥ר תְּבֻשַּׁל־בֹּ֖ו יִשָּׁבֵ֑ר וְאִם־בִּכְלִ֤י נְחֹ֙שֶׁת֙ בֻּשָּׁ֔לָה וּמֹרַ֥ק וְשֻׁטַּ֖ף בַּמָּֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","כָּל־זָכָ֥ר בַּכֹּהֲנִ֖ים יֹאכַ֣ל אֹתָ֑הּ קֹ֥דֶשׁ קֽ͏ָדָשִׁ֖ים הִֽוא׃ ");
INSERT INTO hbo_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","וְכָל־חַטָּ֡את אֲשֶׁר֩ יוּבָ֨א מִדָּמָ֜הּ אֶל־אֹ֧הֶל מֹועֵ֛ד לְכַפֵּ֥ר בַּקֹּ֖דֶשׁ לֹ֣א תֵאָכֵ֑ל בָּאֵ֖שׁ תִּשָּׂרֵֽף׃ פ ");
INSERT INTO hbo_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","וְזֹ֥את תֹּורַ֖ת הָאָשָׁ֑ם קֹ֥דֶשׁ קֽ͏ָדָשִׁ֖ים הֽוּא׃ ");
INSERT INTO hbo_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","בִּמְקֹ֗ום אֲשֶׁ֤ר יִשְׁחֲטוּ֙ אֶת־הָ֣עֹלָ֔ה יִשְׁחֲט֖וּ אֶת־הָאָשָׁ֑ם וְאֶת־דָּמֹ֛ו יִזְרֹ֥ק עַל־הַמִּזְבֵּ֖חַ סָבִֽיב׃ ");
INSERT INTO hbo_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","וְאֵ֥ת כָּל־חֶלְבֹּ֖ו יַקְרִ֣יב מִמֶּ֑נּוּ אֵ֚ת הָֽאַלְיָ֔ה וְאֶת־הַחֵ֖לֶב הַֽמְכַסֶּ֥ה אֶת־הַקֶּֽרֶב׃ ");
INSERT INTO hbo_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","וְאֵת֙ שְׁתֵּ֣י הַכְּלָיֹ֔ת וְאֶת־הַחֵ֙לֶב֙ אֲשֶׁ֣ר עֲלֵיהֶ֔ן אֲשֶׁ֖ר עַל־הַכְּסָלִ֑ים וְאֶת־הַיֹּתֶ֙רֶת֙ עַל־הַכָּבֵ֔ד עַל־הַכְּלָיֹ֖ת יְסִירֶֽנָּה׃ ");
INSERT INTO hbo_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","וְהִקְטִ֨יר אֹתָ֤ם הַכֹּהֵן֙ הַמִּזְבֵּ֔חָה אִשֶּׁ֖ה לַיהוָ֑ה אָשָׁ֖ם הֽוּא׃ ");
INSERT INTO hbo_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","כָּל־זָכָ֥ר בַּכֹּהֲנִ֖ים יֹאכְלֶ֑נּוּ בְּמָקֹ֤ום קָדֹושׁ֙ יֵאָכֵ֔ל קֹ֥דֶשׁ קָֽדָשִׁ֖ים הֽוּא׃ ");
INSERT INTO hbo_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","כַּֽחַטָּאת֙ כָּֽאָשָׁ֔ם תֹּורָ֥ה אַחַ֖ת לָהֶ֑ם הַכֹּהֵ֛ן אֲשֶׁ֥ר יְכַפֶּר־בֹּ֖ו לֹ֥ו יִהְיֶֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","וְהַ֨כֹּהֵ֔ן הַמַּקְרִ֖יב אֶת־עֹ֣לַת אִ֑ישׁ עֹ֤ור הָֽעֹלָה֙ אֲשֶׁ֣ר הִקְרִ֔יב לַכֹּהֵ֖ן לֹ֥ו יִהְיֶֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","וְכָל־מִנְחָ֗ה אֲשֶׁ֤ר תֵּֽאָפֶה֙ בַּתַּנּ֔וּר וְכָל־נַעֲשָׂ֥ה בַמַּרְחֶ֖שֶׁת וְעַֽל־מַחֲבַ֑ת לַכֹּהֵ֛ן הַמַּקְרִ֥יב אֹתָ֖הּ לֹ֥ו תִֽהְיֶֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","וְכָל־מִנְחָ֥ה בְלוּלָֽה־בַשֶּׁ֖מֶן וַחֲרֵבָ֑ה לְכָל־בְּנֵ֧י אַהֲרֹ֛ן תִּהְיֶ֖ה אִ֥ישׁ כְּאָחִֽיו׃ פ ");
INSERT INTO hbo_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","וְזֹ֥את תֹּורַ֖ת זֶ֣בַח הַשְּׁלָמִ֑ים אֲשֶׁ֥ר יַקְרִ֖יב לַיהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","אִ֣ם עַל־תֹּודָה֮ יַקְרִיבֶנּוּ֒ וְהִקְרִ֣יב ׀ עַל־זֶ֣בַח הַתֹּודָ֗ה חַלֹּ֤ות מַצֹּות֙ בְּלוּלֹ֣ת בַּשֶּׁ֔מֶן וּרְקִיקֵ֥י מַצֹּ֖ות מְשֻׁחִ֣ים בַּשָּׁ֑מֶן וְסֹ֣לֶת מֻרְבֶּ֔כֶת חַלֹּ֖ת בְּלוּלֹ֥ת בַּשָּֽׁמֶן׃ ");
INSERT INTO hbo_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","עַל־חַלֹּת֙ לֶ֣חֶם חָמֵ֔ץ יַקְרִ֖יב קָרְבָּנֹ֑ו עַל־זֶ֖בַח תֹּודַ֥ת שְׁלָמָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","וְהִקְרִ֨יב מִמֶּ֤נּוּ אֶחָד֙ מִכָּל־קָרְבָּ֔ן תְּרוּמָ֖ה לַיהוָ֑ה לַכֹּהֵ֗ן הַזֹּרֵ֛ק אֶת־דַּ֥ם הַשְּׁלָמִ֖ים לֹ֥ו יִהְיֶֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","וּבְשַׂ֗ר זֶ֚בַח תֹּודַ֣ת שְׁלָמָ֔יו בְּיֹ֥ום קָרְבָּנֹ֖ו יֵאָכֵ֑ל לֹֽא־יַנִּ֥יחַ מִמֶּ֖נּוּ עַד־בֹּֽקֶר׃ ");
INSERT INTO hbo_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","וְאִם־נֶ֣דֶר ׀ אֹ֣ו נְדָבָ֗ה זֶ֚בַח קָרְבָּנֹ֔ו בְּיֹ֛ום הַקְרִיבֹ֥ו אֶת־זִבְחֹ֖ו יֵאָכֵ֑ל וּמִֽמָּחֳרָ֔ת וְהַנֹּותָ֥ר מִמֶּ֖נּוּ יֵאָכֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","וְהַנֹּותָ֖ר מִבְּשַׂ֣ר הַזָּ֑בַח בַּיֹּום֙ הַשְּׁלִישִׁ֔י בָּאֵ֖שׁ יִשָּׂרֵֽף׃ ");
INSERT INTO hbo_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","וְאִ֣ם הֵאָכֹ֣ל יֵ֠אָכֵל מִבְּשַׂר־זֶ֨בַח שְׁלָמָ֜יו בַּיֹּ֣ום הַשְּׁלִישִׁי֮ לֹ֣א יֵרָצֶה֒ הַמַּקְרִ֣יב אֹתֹ֗ו לֹ֧א יֵחָשֵׁ֛ב לֹ֖ו פִּגּ֣וּל יִהְיֶ֑ה וְהַנֶּ֛פֶשׁ הָאֹכֶ֥לֶת מִמֶּ֖נּוּ עֲוֹנָ֥הּ תִּשָּֽׂא׃ ");
INSERT INTO hbo_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","וְהַבָּשָׂ֞ר אֲשֶׁר־יִגַּ֤ע בְּכָל־טָמֵא֙ לֹ֣א יֵֽאָכֵ֔ל בָּאֵ֖שׁ יִשָּׂרֵ֑ף וְהַ֨בָּשָׂ֔ר כָּל־טָהֹ֖ור יֹאכַ֥ל בָּשָֽׂר׃ ");
INSERT INTO hbo_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","וְהַנֶּ֜פֶשׁ אֲשֶׁר־תֹּאכַ֣ל בָּשָׂ֗ר מִזֶּ֤בַח הַשְּׁלָמִים֙ אֲשֶׁ֣ר לַיהוָ֔ה וְטֻמְאָתֹ֖ו עָלָ֑יו וְנִכְרְתָ֛ה הַנֶּ֥פֶשׁ הַהִ֖וא מֵעַמֶּֽיהָ׃ ");
INSERT INTO hbo_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","וְנֶ֜פֶשׁ כִּֽי־תִגַּ֣ע בְּכָל־טָמֵ֗א בְּטֻמְאַ֤ת אָדָם֙ אֹ֣ו ׀ בִּבְהֵמָ֣ה טְמֵאָ֗ה אֹ֚ו בְּכָל־שֶׁ֣קֶץ טָמֵ֔א וְאָכַ֛ל מִבְּשַׂר־זֶ֥בַח הַשְּׁלָמִ֖ים אֲשֶׁ֣ר לַיהוָ֑ה וְנִכְרְתָ֛ה הַנֶּ֥פֶשׁ הַהִ֖וא מֵעַמֶּֽיהָ׃ פ ");
INSERT INTO hbo_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","דַּבֵּ֛ר אֶל־בְּנֵ֥י יִשְׂרָאֵ֖ל לֵאמֹ֑ר כָּל־חֵ֜לֶב שֹׁ֥ור וְכֶ֛שֶׂב וָעֵ֖ז לֹ֥א תֹאכֵֽלוּ׃ ");
INSERT INTO hbo_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","וְחֵ֤לֶב נְבֵלָה֙ וְחֵ֣לֶב טְרֵפָ֔ה יֵעָשֶׂ֖ה לְכָל־מְלָאכָ֑ה וְאָכֹ֖ל לֹ֥א תֹאכְלֻֽהוּ׃ ");
INSERT INTO hbo_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","כִּ֚י כָּל־אֹכֵ֣ל חֵ֔לֶב מִן־הַ֨בְּהֵמָ֔ה אֲשֶׁ֨ר יַקְרִ֥יב מִמֶּ֛נָּה אִשֶּׁ֖ה לַיהוָ֑ה וְנִכְרְתָ֛ה הַנֶּ֥פֶשׁ הָאֹכֶ֖לֶת מֵֽעַמֶּֽיהָ׃ ");
INSERT INTO hbo_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","וְכָל־דָּם֙ לֹ֣א תֹאכְל֔וּ בְּכֹ֖ל מֹושְׁבֹתֵיכֶ֑ם לָעֹ֖וף וְלַבְּהֵמָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","כָּל־נֶ֖פֶשׁ אֲשֶׁר־תֹּאכַ֣ל כָּל־דָּ֑ם וְנִכְרְתָ֛ה הַנֶּ֥פֶשׁ הַהִ֖וא מֵֽעַמֶּֽיהָ׃ פ ");
INSERT INTO hbo_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","דַּבֵּ֛ר אֶל־בְּנֵ֥י יִשְׂרָאֵ֖ל לֵאמֹ֑ר הַמַּקְרִ֞יב אֶת־זֶ֤בַח שְׁלָמָיו֙ לַיהוָ֔ה יָבִ֧יא אֶת־קָרְבָּנֹ֛ו לַיהוָ֖ה מִזֶּ֥בַח שְׁלָמָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","יָדָ֣יו תְּבִיאֶ֔ינָה אֵ֖ת אִשֵּׁ֣י יְהוָ֑ה אֶת־הַחֵ֤לֶב עַל־הֶֽחָזֶה֙ יְבִיאֶ֔נּוּ אֵ֣ת הֶחָזֶ֗ה לְהָנִ֥יף אֹתֹ֛ו תְּנוּפָ֖ה לִפְנֵ֥י יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","וְהִקְטִ֧יר הַכֹּהֵ֛ן אֶת־הַחֵ֖לֶב הַמִּזְבֵּ֑חָה וְהָיָה֙ הֶֽחָזֶ֔ה לְאַהֲרֹ֖ן וּלְבָנָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","וְאֵת֙ שֹׁ֣וק הַיָּמִ֔ין תִּתְּנ֥וּ תְרוּמָ֖ה לַכֹּהֵ֑ן מִזִּבְחֵ֖י שַׁלְמֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","הַמַּקְרִ֞יב אֶת־דַּ֧ם הַשְּׁלָמִ֛ים וְאֶת־הַחֵ֖לֶב מִבְּנֵ֣י אַהֲרֹ֑ן לֹ֧ו תִהְיֶ֛ה שֹׁ֥וק הַיָּמִ֖ין לְמָנָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","כִּי֩ אֶת־חֲזֵ֨ה הַתְּנוּפָ֜ה וְאֵ֣ת ׀ שֹׁ֣וק הַתְּרוּמָ֗ה לָקַ֙חְתִּי֙ מֵאֵ֣ת בְּנֵֽי־יִשְׂרָאֵ֔ל מִזִּבְחֵ֖י שַׁלְמֵיהֶ֑ם וָאֶתֵּ֣ן אֹ֠תָם לְאַהֲרֹ֨ן הַכֹּהֵ֤ן וּלְבָנָיו֙ לְחָק־עֹולָ֔ם מֵאֵ֖ת בְּנֵ֥י יִשְׂרָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","זֹ֣את מִשְׁחַ֤ת אַהֲרֹן֙ וּמִשְׁחַ֣ת בָּנָ֔יו מֵאִשֵּׁ֖י יְהוָ֑ה בְּיֹום֙ הִקְרִ֣יב אֹתָ֔ם לְכַהֵ֖ן לַיהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","אֲשֶׁר֩ צִוָּ֨ה יְהוָ֜ה לָתֵ֣ת לָהֶ֗ם בְּיֹום֙ מָשְׁחֹ֣ו אֹתָ֔ם מֵאֵ֖ת בְּנֵ֣י יִשְׂרָאֵ֑ל חֻקַּ֥ת עֹולָ֖ם לְדֹרֹתָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","זֹ֣את הַתֹּורָ֗ה לָֽעֹלָה֙ לַמִּנְחָ֔ה וְלַֽחַטָּ֖את וְלָאָשָׁ֑ם וְלַ֨מִּלּוּאִ֔ים וּלְזֶ֖בַח הַשְּׁלָמִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","אֲשֶׁ֨ר צִוָּ֧ה יְהוָ֛ה אֶת־מֹשֶׁ֖ה בְּהַ֣ר סִינָ֑י בְּיֹ֨ום צַוֹּתֹ֜ו אֶת־בְּנֵ֣י יִשְׂרָאֵ֗ל לְהַקְרִ֧יב אֶת־קָרְבְּנֵיהֶ֛ם לַיהוָ֖ה בְּמִדְבַּ֥ר סִינָֽי׃ פ ");
INSERT INTO hbo_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","קַ֤ח אֶֽת־אַהֲרֹן֙ וְאֶת־בָּנָ֣יו אִתֹּ֔ו וְאֵת֙ הַבְּגָדִ֔ים וְאֵ֖ת שֶׁ֣מֶן הַמִּשְׁחָ֑ה וְאֵ֣ת ׀ פַּ֣ר הֽ͏ַחַטָּ֗את וְאֵת֙ שְׁנֵ֣י הָֽאֵילִ֔ים וְאֵ֖ת סַ֥ל הַמַּצֹּֽות׃ ");
INSERT INTO hbo_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","וְאֵ֥ת כָּל־הָעֵדָ֖ה הַקְהֵ֑ל אֶל־פֶּ֖תַח אֹ֥הֶל מֹועֵֽד׃ ");
INSERT INTO hbo_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","וַיַּ֣עַשׂ מֹשֶׁ֔ה כּֽ͏ַאֲשֶׁ֛ר צִוָּ֥ה יְהוָ֖ה אֹתֹ֑ו וַתִּקָּהֵל֙ הָֽעֵדָ֔ה אֶל־פֶּ֖תַח אֹ֥הֶל מֹועֵֽד׃ ");
INSERT INTO hbo_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","וַיֹּ֥אמֶר מֹשֶׁ֖ה אֶל־הָעֵדָ֑ה זֶ֣ה הַדָּבָ֔ר אֲשֶׁר־צִוָּ֥ה יְהוָ֖ה לַעֲשֹֽׂות׃ ");
INSERT INTO hbo_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","וַיַּקְרֵ֣ב מֹשֶׁ֔ה אֶֽת־אַהֲרֹ֖ן וְאֶת־בָּנָ֑יו וַיִּרְחַ֥ץ אֹתָ֖ם בַּמָּֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","וַיִּתֵּ֨ן עָלָ֜יו אֶת־הַכֻּתֹּ֗נֶת וַיַּחְגֹּ֤ר אֹתֹו֙ בָּֽאַבְנֵ֔ט וַיַּלְבֵּ֤שׁ אֹתֹו֙ אֶֽת־הַמְּעִ֔יל וַיִּתֵּ֥ן עָלָ֖יו אֶת־הָאֵפֹ֑ד וַיַּחְגֹּ֣ר אֹתֹ֗ו בְּחֵ֙שֶׁב֙ הָֽאֵפֹ֔ד וַיֶּאְפֹּ֥ד לֹ֖ו בֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","וַיָּ֥שֶׂם עָלָ֖יו אֶת־הַחֹ֑שֶׁן וַיִּתֵּן֙ אֶל־הַחֹ֔שֶׁן אֶת־הָאוּרִ֖ים וְאֶת־הַתֻּמִּֽים׃ ");
INSERT INTO hbo_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","וַיָּ֥שֶׂם אֶת־הַמִּצְנֶ֖פֶת עַל־רֹאשֹׁ֑ו וַיָּ֨שֶׂם עַֽל־הַמִּצְנֶ֜פֶת אֶל־מ֣וּל פָּנָ֗יו אֵ֣ת צִ֤יץ הַזָּהָב֙ נֵ֣זֶר הַקֹּ֔דֶשׁ כַּאֲשֶׁ֛ר צִוָּ֥ה יְהוָ֖ה אֶת־מֹשֶֽׁה׃ ");
INSERT INTO hbo_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","וַיִּקַּ֤ח מֹשֶׁה֙ אֶת־שֶׁ֣מֶן הַמִּשְׁחָ֔ה וַיִּמְשַׁ֥ח אֶת־הַמִּשְׁכָּ֖ן וְאֶת־כָּל־אֲשֶׁר־בֹּ֑ו וַיְקַדֵּ֖שׁ אֹתָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","וַיַּ֥ז מִמֶּ֛נּוּ עַל־הַמִּזְבֵּ֖חַ שֶׁ֣בַע פְּעָמִ֑ים וַיִּמְשַׁ֨ח אֶת־הַמִּזְבֵּ֜חַ וְאֶת־כָּל־כֵּלָ֗יו וְאֶת־הַכִּיֹּ֛ר וְאֶת־כַּנֹּ֖ו לְקַדְּשָֽׁם׃ ");
INSERT INTO hbo_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","וַיִּצֹק֙ מִשֶּׁ֣מֶן הַמִּשְׁחָ֔ה עַ֖ל רֹ֣אשׁ אַהֲרֹ֑ן וַיִּמְשַׁ֥ח אֹתֹ֖ו לְקַדְּשֹֽׁו׃ ");
INSERT INTO hbo_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","וַיַּקְרֵ֨ב מֹשֶׁ֜ה אֶת־בְּנֵ֣י אַהֲרֹ֗ן וַיַּלְבִּשֵׁ֤ם כֻּתֳּנֹת֙ וַיַּחְגֹּ֤ר אֹתָם֙ אַבְנֵ֔ט וַיַּחֲבֹ֥שׁ לָהֶ֖ם מִגְבָּעֹ֑ות כַּאֲשֶׁ֛ר צִוָּ֥ה יְהוָ֖ה אֶת־מֹשֶֽׁה׃ ");
INSERT INTO hbo_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","וַיַּגֵּ֕שׁ אֵ֖ת פַּ֣ר הַֽחַטָּ֑את וַיִּסְמֹ֨ךְ אַהֲרֹ֤ן וּבָנָיו֙ אֶת־יְדֵיהֶ֔ם עַל־רֹ֖אשׁ פַּ֥ר הֽ͏ַחַטָּֽאת׃ ");
INSERT INTO hbo_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","וַיִּשְׁחָ֗ט וַיִּקַּ֨ח מֹשֶׁ֤ה אֶת־הַדָּם֙ וַ֠יִּתֵּן עַל־קַרְנֹ֨ות הַמִּזְבֵּ֤חַ סָבִיב֙ בְּאֶצְבָּעֹ֔ו וַיְחַטֵּ֖א אֶת־הַמִּזְבֵּ֑חַ וְאֶת־הַדָּ֗ם יָצַק֙ אֶל־יְסֹ֣וד הַמִּזְבֵּ֔חַ וַֽיְקַדְּשֵׁ֖הוּ לְכַפֵּ֥ר עָלָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","וַיִּקַּ֗ח אֶֽת־כָּל־הַחֵלֶב֮ אֲשֶׁ֣ר עַל־הַקֶּרֶב֒ וְאֵת֙ יֹתֶ֣רֶת הַכָּבֵ֔ד וְאֶת־שְׁתֵּ֥י הַכְּלָיֹ֖ת וְאֶֽת־חֶלְבְּהֶ֑ן וַיַּקְטֵ֥ר מֹשֶׁ֖ה הַמִּזְבֵּֽחָה׃ ");
INSERT INTO hbo_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","וְאֶת־הַפָּ֤ר וְאֶת־עֹרֹו֙ וְאֶת־בְּשָׂרֹ֣ו וְאֶת־פִּרְשֹׁ֔ו שָׂרַ֣ף בָּאֵ֔שׁ מִח֖וּץ לַֽמַּחֲנֶ֑ה כַּאֲשֶׁ֛ר צִוָּ֥ה יְהוָ֖ה אֶת־מֹשֶֽׁה׃ ");
INSERT INTO hbo_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","וַיַּקְרֵ֕ב אֵ֖ת אֵ֣יל הָעֹלָ֑ה וַֽיִּסְמְכ֞וּ אַהֲרֹ֧ן וּבָנָ֛יו אֶת־יְדֵיהֶ֖ם עַל־רֹ֥אשׁ הָאָֽיִל׃ ");
INSERT INTO hbo_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","וַיִּשְׁחָ֑ט וַיִּזְרֹ֨ק מֹשֶׁ֧ה אֶת־הַדָּ֛ם עַל־הַמִּזְבֵּ֖חַ סָבִֽיב׃ ");
INSERT INTO hbo_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","וְאֶת־הָאַ֔יִל נִתַּ֖ח לִנְתָחָ֑יו וַיַּקְטֵ֤ר מֹשֶׁה֙ אֶת־הָרֹ֔אשׁ וְאֶת־הַנְּתָחִ֖ים וְאֶת־הַפָּֽדֶר׃ ");
INSERT INTO hbo_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","וְאֶת־הַקֶּ֥רֶב וְאֶת־הַכְּרָעַ֖יִם רָחַ֣ץ בַּמָּ֑יִם וַיַּקְטֵר֩ מֹשֶׁ֨ה אֶת־כָּל־הָאַ֜יִל הַמִּזְבֵּ֗חָה עֹלָ֨ה ה֤וּא לְרֵֽיחַ־נִיחֹ֙חַ֙ אִשֶּׁ֥ה הוּא֙ לַיהוָ֔ה כַּאֲשֶׁ֛ר צִוָּ֥ה יְהוָ֖ה אֶת־מֹשֶֽׁה׃ ");
INSERT INTO hbo_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","וַיַּקְרֵב֙ אֶת־הָאַ֣יִל הַשֵּׁנִ֔י אֵ֖יל הַמִּלֻּאִ֑ים וַֽיִּסְמְכ֞וּ אַהֲרֹ֧ן וּבָנָ֛יו אֶת־יְדֵיהֶ֖ם עַל־רֹ֥אשׁ הָאָֽיִל׃ ");
INSERT INTO hbo_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","וַיִּשְׁחָ֓ט ׀ וַיִּקַּ֤ח מֹשֶׁה֙ מִדָּמֹ֔ו וַיִּתֵּ֛ן עַל־תְּנ֥וּךְ אֹֽזֶן־אַהֲרֹ֖ן הַיְמָנִ֑ית וְעַל־בֹּ֤הֶן יָדֹו֙ הַיְמָנִ֔ית וְעַל־בֹּ֥הֶן רַגְלֹ֖ו הַיְמָנִֽית׃ ");
INSERT INTO hbo_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","וַיַּקְרֵ֞ב אֶת־בְּנֵ֣י אַהֲרֹ֗ן וַיִּתֵּ֨ן מֹשֶׁ֤ה מִן־הַדָּם֙ עַל־תְּנ֤וּךְ אָזְנָם֙ הַיְמָנִ֔ית וְעַל־בֹּ֤הֶן יָדָם֙ הַיְמָנִ֔ית וְעַל־בֹּ֥הֶן רַגְלָ֖ם הַיְמָנִ֑ית וַיִּזְרֹ֨ק מֹשֶׁ֧ה אֶת־הַדָּ֛ם עַל־הֽ͏ַמִּזְבֵּ֖חַ סָבִֽיב׃ ");
INSERT INTO hbo_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","וַיִּקַּ֞ח אֶת־הַחֵ֣לֶב וְאֶת־הָֽאַלְיָ֗ה וְאֶֽת־כָּל־הַחֵלֶב֮ אֲשֶׁ֣ר עַל־הַקֶּרֶב֒ וְאֵת֙ יֹתֶ֣רֶת הַכָּבֵ֔ד וְאֶת־שְׁתֵּ֥י הַכְּלָיֹ֖ת וְאֶֽת־חֶלְבְּהֶ֑ן וְאֵ֖ת שֹׁ֥וק הַיָּמִֽין׃ ");
INSERT INTO hbo_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","וּמִסַּ֨ל הַמַּצֹּ֜ות אֲשֶׁ֣ר ׀ לִפְנֵ֣י יְהוָ֗ה לָ֠קַח חַלַּ֨ת מַצָּ֤ה אַחַת֙ וְֽחַלַּ֨ת לֶ֥חֶם שֶׁ֛מֶן אַחַ֖ת וְרָקִ֣יק אֶחָ֑ד וַיָּ֙שֶׂם֙ עַל־הַ֣חֲלָבִ֔ים וְעַ֖ל שֹׁ֥וק הַיָּמִֽין׃ ");
INSERT INTO hbo_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","וַיִּתֵּ֣ן אֶת־הַכֹּ֔ל עַ֚ל כַּפֵּ֣י אַהֲרֹ֔ן וְעַ֖ל כַּפֵּ֣י בָנָ֑יו וַיָּ֧נֶף אֹתָ֛ם תְּנוּפָ֖ה לִפְנֵ֥י יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","וַיִּקַּ֨ח מֹשֶׁ֤ה אֹתָם֙ מֵעַ֣ל כַּפֵּיהֶ֔ם וַיַּקְטֵ֥ר הַמִּזְבֵּ֖חָה עַל־הָעֹלָ֑ה מִלֻּאִ֥ים הֵם֙ לְרֵ֣יחַ נִיחֹ֔חַ אִשֶּׁ֥ה ה֖וּא לַיהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","וַיִּקַּ֤ח מֹשֶׁה֙ אֶת־הֶ֣חָזֶ֔ה וַיְנִיפֵ֥הוּ תְנוּפָ֖ה לִפְנֵ֣י יְהוָ֑ה מֵאֵ֣יל הַמִּלֻּאִ֗ים לְמֹשֶׁ֤ה הָיָה֙ לְמָנָ֔ה כַּאֲשֶׁ֛ר צִוָּ֥ה יְהוָ֖ה אֶת־מֹשֶֽׁה׃ ");
INSERT INTO hbo_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","וַיִּקַּ֨ח מֹשֶׁ֜ה מִשֶּׁ֣מֶן הַמִּשְׁחָ֗ה וּמִן־הַדָּם֮ אֲשֶׁ֣ר עַל־הַמִּזְבֵּחַ֒ וַיַּ֤ז עַֽל־אַהֲרֹן֙ עַל־בְּגָדָ֔יו וְעַל־בָּנָ֛יו וְעַל־בִּגְדֵ֥י בָנָ֖יו אִתֹּ֑ו וַיְקַדֵּ֤שׁ אֶֽת־אַהֲרֹן֙ אֶת־בְּגָדָ֔יו וְאֶת־בָּנָ֛יו וְאֶת־בִּגְדֵ֥י בָנָ֖יו אִתֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","וַיֹּ֨אמֶר מֹשֶׁ֜ה אֶל־אַהֲרֹ֣ן וְאֶל־בָּנָ֗יו בַּשְּׁל֣וּ אֶת־הַבָּשָׂר֮ פֶּ֣תַח אֹ֣הֶל מֹועֵד֒ וְשָׁם֙ תֹּאכְל֣וּ אֹתֹ֔ו וְאֶ֨ת־הַלֶּ֔חֶם אֲשֶׁ֖ר בְּסַ֣ל הַמִּלֻּאִ֑ים כַּאֲשֶׁ֤ר צִוֵּ֙יתִי֙ לֵאמֹ֔ר אַהֲרֹ֥ן וּבָנָ֖יו יֹאכְלֻֽהוּ׃ ");
INSERT INTO hbo_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","וְהַנֹּותָ֥ר בַּבָּשָׂ֖ר וּבַלָּ֑חֶם בָּאֵ֖שׁ תִּשְׂרֹֽפוּ׃ ");
INSERT INTO hbo_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","וּמִפֶּתַח֩ אֹ֨הֶל מֹועֵ֜ד לֹ֤א תֵֽצְאוּ֙ שִׁבְעַ֣ת יָמִ֔ים עַ֚ד יֹ֣ום מְלֹ֔את יְמֵ֖י מִלֻּאֵיכֶ֑ם כִּ֚י שִׁבְעַ֣ת יָמִ֔ים יְמַלֵּ֖א אֶת־יֶדְכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","כַּאֲשֶׁ֥ר עָשָׂ֖ה בַּיֹּ֣ום הַזֶּ֑ה צִוָּ֧ה יְהוָ֛ה לַעֲשֹׂ֖ת לְכַפֵּ֥ר עֲלֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","וּפֶתַח֩ אֹ֨הֶל מֹועֵ֜ד תֵּשְׁב֨וּ יֹומָ֤ם וָלַ֙יְלָה֙ שִׁבְעַ֣ת יָמִ֔ים וּשְׁמַרְתֶּ֛ם אֶת־מִשְׁמֶ֥רֶת יְהוָ֖ה וְלֹ֣א תָמ֑וּתוּ כִּי־כֵ֖ן צֻוֵּֽיתִי׃ ");
INSERT INTO hbo_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","וַיַּ֥עַשׂ אַהֲרֹ֖ן וּבָנָ֑יו אֵ֚ת כָּל־הַדְּבָרִ֔ים אֲשֶׁר־צִוָּ֥ה יְהוָ֖ה בְּיַד־מֹשֶֽׁה׃ ס ");
INSERT INTO hbo_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","וַיְהִי֙ בַּיֹּ֣ום הַשְּׁמִינִ֔י קָרָ֣א מֹשֶׁ֔ה לְאַהֲרֹ֖ן וּלְבָנָ֑יו וּלְזִקְנֵ֖י יִשְׂרָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","וַיֹּ֣אמֶר אֶֽל־אַהֲרֹ֗ן קַח־לְ֠ךָ עֵ֣גֶל בֶּן־בָּקָ֧ר לְחַטָּ֛את וְאַ֥יִל לְעֹלָ֖ה תְּמִימִ֑ם וְהַקְרֵ֖ב לִפְנֵ֥י יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","וְאֶל־בְּנֵ֥י יִשְׂרָאֵ֖ל תְּדַבֵּ֣ר לֵאמֹ֑ר קְח֤וּ שְׂעִיר־עִזִּים֙ לְחַטָּ֔את וְעֵ֨גֶל וָכֶ֧בֶשׂ בְּנֵי־שָׁנָ֛ה תְּמִימִ֖ם לְעֹלָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","וְשֹׁ֨ור וָאַ֜יִל לִשְׁלָמִ֗ים לִזְבֹּ֙חַ֙ לִפְנֵ֣י יְהוָ֔ה וּמִנְחָ֖ה בְּלוּלָ֣ה בַשָּׁ֑מֶן כִּ֣י הַיֹּ֔ום יְהוָ֖ה נִרְאָ֥ה אֲלֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","וַיִּקְח֗וּ אֵ֚ת אֲשֶׁ֣ר צִוָּ֣ה מֹשֶׁ֔ה אֶל־פְּנֵ֖י אֹ֣הֶל מֹועֵ֑ד וַֽיִּקְרְבוּ֙ כָּל־הָ֣עֵדָ֔ה וַיַּֽעַמְד֖וּ לִפְנֵ֥י יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","וַיֹּ֣אמֶר מֹשֶׁ֔ה זֶ֧ה הַדָּבָ֛ר אֲשֶׁר־צִוָּ֥ה יְהוָ֖ה תַּעֲשׂ֑וּ וְיֵרָ֥א אֲלֵיכֶ֖ם כְּבֹ֥וד יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","וַיֹּ֨אמֶר מֹשֶׁ֜ה אֶֽל־אַהֲרֹ֗ן קְרַ֤ב אֶל־הַמִּזְבֵּ֙חַ֙ וַעֲשֵׂ֞ה אֶת־חַטָּֽאתְךָ֙ וְאֶת־עֹ֣לָתֶ֔ךָ וְכַפֵּ֥ר בַּֽעַדְךָ֖ וּבְעַ֣ד הָעָ֑ם וַעֲשֵׂ֞ה אֶת־קָרְבַּ֤ן הָעָם֙ וְכַפֵּ֣ר בּֽ͏ַעֲדָ֔ם כַּאֲשֶׁ֖ר צִוָּ֥ה יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","וַיִּקְרַ֥ב אַהֲרֹ֖ן אֶל־הַמִּזְבֵּ֑חַ וַיִּשְׁחַ֛ט אֶת־עֵ֥גֶל הַחַטָּ֖את אֲשֶׁר־לֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","וַ֠יַּקְרִבוּ בְּנֵ֨י אַהֲרֹ֣ן אֶת־הַדָּם֮ אֵלָיו֒ וַיִּטְבֹּ֤ל אֶצְבָּעֹו֙ בַּדָּ֔ם וַיִּתֵּ֖ן עַל־קַרְנֹ֣ות הַמִּזְבֵּ֑חַ וְאֶת־הַדָּ֣ם יָצַ֔ק אֶל־יְסֹ֖וד הַמִּזְבֵּֽחַ׃ ");
INSERT INTO hbo_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","וְאֶת־הַחֵ֨לֶב וְאֶת־הַכְּלָיֹ֜ת וְאֶת־הַיֹּתֶ֤רֶת מִן־הַכָּבֵד֙ מִן־הַ֣חַטָּ֔את הִקְטִ֖יר הַמִּזְבֵּ֑חָה כַּאֲשֶׁ֛ר צִוָּ֥ה יְהוָ֖ה אֶת־מֹשֶֽׁה׃ ");
INSERT INTO hbo_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","וְאֶת־הַבָּשָׂ֖ר וְאֶת־הָעֹ֑ור שָׂרַ֣ף בָּאֵ֔שׁ מִח֖וּץ לַֽמַּחֲנֶֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","וַיִּשְׁחַ֖ט אֶת־הָעֹלָ֑ה וַ֠יַּמְצִאוּ בְּנֵ֨י אַהֲרֹ֤ן אֵלָיו֙ אֶת־הַדָּ֔ם וַיִּזְרְקֵ֥הוּ עַל־הַמִּזְבֵּ֖חַ סָבִֽיב׃ ");
INSERT INTO hbo_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","וְאֶת־הָעֹלָ֗ה הִמְצִ֧יאוּ אֵלָ֛יו לִנְתָחֶ֖יהָ וְאֶת־הָרֹ֑אשׁ וַיַּקְטֵ֖ר עַל־הַמִּזְבֵּֽחַ׃ ");
INSERT INTO hbo_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","וַיִּרְחַ֥ץ אֶת־הַקֶּ֖רֶב וְאֶת־הַכְּרָעָ֑יִם וַיַּקְטֵ֥ר עַל־הָעֹלָ֖ה הַמִּזְבֵּֽחָה׃ ");
INSERT INTO hbo_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","וַיַּקְרֵ֕ב אֵ֖ת קָרְבַּ֣ן הָעָ֑ם וַיִּקַּ֞ח אֶת־שְׂעִ֤יר הַֽחַטָּאת֙ אֲשֶׁ֣ר לָעָ֔ם וַיִּשְׁחָטֵ֥הוּ וַֽיְחַטְּאֵ֖הוּ כָּרִאשֹֽׁון׃ ");
INSERT INTO hbo_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","וַיַּקְרֵ֖ב אֶת־הָעֹלָ֑ה וַֽיַּעֲשֶׂ֖הָ כַּמִּשְׁפָּֽט׃ ");
INSERT INTO hbo_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","וַיַּקְרֵב֮ אֶת־הַמִּנְחָה֒ וַיְמַלֵּ֤א כַפֹּו֙ מִמֶּ֔נָּה וַיַּקְטֵ֖ר עַל־הַמִּזְבֵּ֑חַ מִלְּבַ֖ד עֹלַ֥ת הַבֹּֽקֶר׃ ");
INSERT INTO hbo_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","וַיִּשְׁחַ֤ט אֶת־הַשֹּׁור֙ וְאֶת־הָאַ֔יִל זֶ֥בַח הַשְּׁלָמִ֖ים אֲשֶׁ֣ר לָעָ֑ם וַ֠יַּמְצִאוּ בְּנֵ֨י אַהֲרֹ֤ן אֶת־הַדָּם֙ אֵלָ֔יו וַיִּזְרְקֵ֥הוּ עַל־הַמִּזְבֵּ֖חַ סָבִֽיב׃ ");
INSERT INTO hbo_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","וְאֶת־הַחֲלָבִ֖ים מִן־הַשֹּׁ֑ור וּמִן־הָאַ֔יִל הָֽאַלְיָ֤ה וְהַֽמְכַסֶּה֙ וְהַכְּלָיֹ֔ת וְיֹתֶ֖רֶת הַכָּבֵֽד׃ ");
INSERT INTO hbo_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","וַיָּשִׂ֥ימוּ אֶת־הַחֲלָבִ֖ים עַל־הֶחָזֹ֑ות וַיַּקְטֵ֥ר הַחֲלָבִ֖ים הַמִּזְבֵּֽחָה׃ ");
INSERT INTO hbo_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","וְאֵ֣ת הֶחָזֹ֗ות וְאֵת֙ שֹׁ֣וק הַיָּמִ֔ין הֵנִ֧יף אַהֲרֹ֛ן תְּנוּפָ֖ה לִפְנֵ֣י יְהוָ֑ה כַּאֲשֶׁ֖ר צִוָּ֥ה מֹשֶֽׁה׃ ");
INSERT INTO hbo_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","וַיִּשָּׂ֨א אַהֲרֹ֧ן אֶת־*יָדֹו (יָדָ֛יו) אֶל־הָעָ֖ם וַֽיְבָרְכֵ֑ם וַיֵּ֗רֶד מֵעֲשֹׂ֧ת הַֽחַטָּ֛את וְהָעֹלָ֖ה וְהַשְּׁלָמִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","וַיָּבֹ֨א מֹשֶׁ֤ה וְאַהֲרֹן֙ אֶל־אֹ֣הֶל מֹועֵ֔ד וַיֵּ֣צְא֔וּ וַֽיְבָרֲכ֖וּ אֶת־הָעָ֑ם וַיֵּרָ֥א כְבֹוד־יְהוָ֖ה אֶל־כָּל־הָעָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","וַתֵּ֤צֵא אֵשׁ֙ מִלִּפְנֵ֣י יְהוָ֔ה וַתֹּ֙אכַל֙ עַל־הַמִּזְבֵּ֔חַ אֶת־הָעֹלָ֖ה וְאֶת־הַחֲלָבִ֑ים וַיַּ֤רְא כָּל־הָעָם֙ וַיָּרֹ֔נּוּ וַֽיִּפְּל֖וּ עַל־פְּנֵיהֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","וַיִּקְח֣וּ בְנֵֽי־אַ֠הֲרֹן נָדָ֨ב וַאֲבִיה֜וּא אִ֣ישׁ מַחְתָּתֹ֗ו וַיִּתְּנ֤וּ בָהֵן֙ אֵ֔שׁ וַיָּשִׂ֥ימוּ עָלֶ֖יהָ קְטֹ֑רֶת וַיַּקְרִ֜בוּ לִפְנֵ֤י יְהוָה֙ אֵ֣שׁ זָרָ֔ה אֲשֶׁ֧ר לֹ֦א צִוָּ֖ה אֹתָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","וַתֵּ֥צֵא אֵ֛שׁ מִלִּפְנֵ֥י יְהוָ֖ה וַתֹּ֣אכַל אֹותָ֑ם וַיָּמֻ֖תוּ לִפְנֵ֥י יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","וַיֹּ֨אמֶר מֹשֶׁ֜ה אֶֽל־אַהֲרֹ֗ן הוּא֩ אֲשֶׁר־דִּבֶּ֨ר יְהוָ֤ה ׀ לֵאמֹר֙ בִּקְרֹבַ֣י אֶקָּדֵ֔שׁ וְעַל־פְּנֵ֥י כָל־הָעָ֖ם אֶכָּבֵ֑ד וַיִּדֹּ֖ם אַהֲרֹֽן׃ ");
INSERT INTO hbo_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","וַיִּקְרָ֣א מֹשֶׁ֗ה אֶל־מִֽישָׁאֵל֙ וְאֶ֣ל אֶלְצָפָ֔ן בְּנֵ֥י עֻזִּיאֵ֖ל דֹּ֣ד אַהֲרֹ֑ן וַיֹּ֣אמֶר אֲלֵהֶ֗ם קִ֠רְב֞וּ שְׂא֤וּ אֶת־אֲחֵיכֶם֙ מֵאֵ֣ת פְּנֵי־הַקֹּ֔דֶשׁ אֶל־מִח֖וּץ לַֽמַּחֲנֶֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","וַֽיִּקְרְב֗וּ וַיִּשָּׂאֻם֙ בְּכֻתֳּנֹתָ֔ם אֶל־מִח֖וּץ לַֽמַּחֲנֶ֑ה כַּאֲשֶׁ֖ר דִּבֶּ֥ר מֹשֶֽׁה׃ ");
INSERT INTO hbo_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","וַיֹּ֣אמֶר מֹשֶׁ֣ה אֶֽל־אַהֲרֹ֡ן וּלְאֶלְעָזָר֩ וּלְאִֽיתָמָ֨ר ׀ בָּנָ֜יו רֽ͏ָאשֵׁיכֶ֥ם אַל־תִּפְרָ֣עוּ ׀ וּבִגְדֵיכֶ֤ם לֹֽא־תִפְרֹ֙מוּ֙ וְלֹ֣א תָמֻ֔תוּ וְעַ֥ל כָּל־הָעֵדָ֖ה יִקְצֹ֑ף וַאֲחֵיכֶם֙ כָּל־בֵּ֣ית יִשְׂרָאֵ֔ל יִבְכּוּ֙ אֶת־הַשְּׂרֵפָ֔ה אֲשֶׁ֖ר שָׂרַ֥ף יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","וּמִפֶּתַח֩ אֹ֨הֶל מֹועֵ֜ד לֹ֤א תֵֽצְאוּ֙ פֶּן־תָּמֻ֔תוּ כִּי־שֶׁ֛מֶן מִשְׁחַ֥ת יְהוָ֖ה עֲלֵיכֶ֑ם וַֽיַּעֲשׂ֖וּ כִּדְבַ֥ר מֹשֶֽׁה׃ פ ");
INSERT INTO hbo_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","וַיְדַבֵּ֣ר יְהוָ֔ה אֶֽל־אַהֲרֹ֖ן לֵאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","יַ֣יִן וְשֵׁכָ֞ר אַל־תֵּ֣שְׁתְּ ׀ אַתָּ֣ה ׀ וּבָנֶ֣יךָ אִתָּ֗ךְ בְּבֹאֲכֶ֛ם אֶל־אֹ֥הֶל מֹועֵ֖ד וְלֹ֣א תָמֻ֑תוּ חֻקַּ֥ת עֹולָ֖ם לְדֹרֹתֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","וּֽלֲהַבְדִּ֔יל בֵּ֥ין הַקֹּ֖דֶשׁ וּבֵ֣ין הַחֹ֑ל וּבֵ֥ין הַטָּמֵ֖א וּבֵ֥ין הַטָּהֹֽור׃ ");
INSERT INTO hbo_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","וּלְהֹורֹ֖ת אֶת־בְּנֵ֣י יִשְׂרָאֵ֑ל אֵ֚ת כָּל־הַ֣חֻקִּ֔ים אֲשֶׁ֨ר דִּבֶּ֧ר יְהוָ֛ה אֲלֵיהֶ֖ם בְּיַד־מֹשֶֽׁה׃ פ ");
INSERT INTO hbo_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","וַיְדַבֵּ֨ר מֹשֶׁ֜ה אֶֽל־אַהֲרֹ֗ן וְאֶ֣ל אֶ֠לְעָזָר וְאֶל־אִ֨יתָמָ֥ר ׀ בָּנָיו֮ הַנֹּֽותָרִים֒ קְח֣וּ אֶת־הַמִּנְחָ֗ה הַנֹּותֶ֙רֶת֙ מֵאִשֵּׁ֣י יְהוָ֔ה וְאִכְל֥וּהָ מַצֹּ֖ות אֵ֣צֶל הַמִּזְבֵּ֑חַ כִּ֛י קֹ֥דֶשׁ קָֽדָשִׁ֖ים הִֽוא׃ ");
INSERT INTO hbo_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","וַאֲכַלְתֶּ֤ם אֹתָהּ֙ בְּמָקֹ֣ום קָדֹ֔שׁ כִּ֣י חָקְךָ֤ וְחָק־בָּנֶ֙יךָ֙ הִ֔וא מֵאִשֵּׁ֖י יְהוָ֑ה כִּי־כֵ֖ן צֻוֵּֽיתִי׃ ");
INSERT INTO hbo_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","וְאֵת֩ חֲזֵ֨ה הַתְּנוּפָ֜ה וְאֵ֣ת ׀ שֹׁ֣וק הַתְּרוּמָ֗ה תֹּֽאכְלוּ֙ בְּמָקֹ֣ום טָהֹ֔ור אַתָּ֕ה וּבָנֶ֥יךָ וּבְנֹתֶ֖יךָ אִתָּ֑ךְ כִּֽי־חָקְךָ֤ וְחָק־בָּנֶ֙יךָ֙ נִתְּנ֔וּ מִזִּבְחֵ֥י שַׁלְמֵ֖י בְּנֵ֥י יִשְׂרָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","שֹׁ֣וק הַתְּרוּמָ֞ה וַחֲזֵ֣ה הַתְּנוּפָ֗ה עַ֣ל אִשֵּׁ֤י הַחֲלָבִים֙ יָבִ֔יאוּ לְהָנִ֥יף תְּנוּפָ֖ה לִפְנֵ֣י יְהוָ֑ה וְהָיָ֨ה לְךָ֜ וּלְבָנֶ֤יךָ אִתְּךָ֙ לְחָק־עֹולָ֔ם כַּאֲשֶׁ֖ר צִוָּ֥ה יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","וְאֵ֣ת ׀ שְׂעִ֣יר הַֽחַטָּ֗את דָּרֹ֥שׁ דָּרַ֛שׁ מֹשֶׁ֖ה וְהִנֵּ֣ה שֹׂרָ֑ף וַ֠יִּקְצֹף עַל־אֶלְעָזָ֤ר וְעַל־אִֽיתָמָר֙ בְּנֵ֣י אַהֲרֹ֔ן הַנֹּותָרִ֖ם לֵאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","מַדּ֗וּעַ לֹֽא־אֲכַלְתֶּ֤ם אֶת־הַחַטָּאת֙ בִּמְקֹ֣ום הַקֹּ֔דֶשׁ כִּ֛י קֹ֥דֶשׁ קָֽדָשִׁ֖ים הִ֑וא וְאֹתָ֣הּ ׀ נָתַ֣ן לָכֶ֗ם לָשֵׂאת֙ אֶת־עֲוֹ֣ן הָעֵדָ֔ה לְכַפֵּ֥ר עֲלֵיהֶ֖ם לִפְנֵ֥י יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","הֵ֚ן לֹא־הוּבָ֣א אֶת־דָּמָ֔הּ אֶל־הַקֹּ֖דֶשׁ פְּנִ֑ימָה אָכֹ֨ול תֹּאכְל֥וּ אֹתָ֛הּ בַּקֹּ֖דֶשׁ כַּאֲשֶׁ֥ר צִוֵּֽיתִי׃ ");
INSERT INTO hbo_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","וַיְדַבֵּ֨ר אַהֲרֹ֜ן אֶל־מֹשֶׁ֗ה הֵ֣ן הַ֠יֹּום הִקְרִ֨יבוּ אֶת־חַטָּאתָ֤ם וְאֶת־עֹֽלָתָם֙ לִפְנֵ֣י יְהוָ֔ה וַתִּקְרֶ֥אנָה אֹתִ֖י כָּאֵ֑לֶּה וְאָכַ֤לְתִּי חַטָּאת֙ הַיֹּ֔ום הַיִּיטַ֖ב בְּעֵינֵ֥י יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","וַיִּשְׁמַ֣ע מֹשֶׁ֔ה וַיִּיטַ֖ב בְּעֵינָֽיו׃ פ ");
INSERT INTO hbo_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","וַיְדַבֵּ֧ר יְהוָ֛ה אֶל־מֹשֶׁ֥ה וְאֶֽל־אַהֲרֹ֖ן לֵאמֹ֥ר אֲלֵהֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","דַּבְּר֛וּ אֶל־בְּנֵ֥י יִשְׂרָאֵ֖ל לֵאמֹ֑ר זֹ֤את הַֽחַיָּה֙ אֲשֶׁ֣ר תֹּאכְל֔וּ מִכָּל־הַבְּהֵמָ֖ה אֲשֶׁ֥ר עַל־הָאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","כֹּ֣ל ׀ מַפְרֶ֣סֶת פַּרְסָ֗ה וְשֹׁסַ֤עַת שֶׁ֙סַע֙ פְּרָסֹ֔ת מַעֲלַ֥ת גֵּרָ֖ה בַּבְּהֵמָ֑ה אֹתָ֖הּ תֹּאכֵֽלוּ׃ ");
INSERT INTO hbo_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","אַ֤ךְ אֶת־זֶה֙ לֹ֣א תֹֽאכְל֔וּ מִֽמַּעֲלֵי֙ הַגֵּרָ֔ה וּמִמַּפְרִיסֵ֖י הַפַּרְסָ֑ה אֶֽת־הַ֠גָּמָל כִּֽי־מַעֲלֵ֨ה גֵרָ֜ה ה֗וּא וּפַרְסָה֙ אֵינֶ֣נּוּ מַפְרִ֔יס טָמֵ֥א ה֖וּא לָכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","וְאֶת־הַשָּׁפָ֗ן כִּֽי־מַעֲלֵ֤ה גֵרָה֙ ה֔וּא וּפַרְסָ֖ה לֹ֣א יַפְרִ֑יס טָמֵ֥א ה֖וּא לָכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","וְאֶת־הָאַרְנֶ֗בֶת כִּֽי־מַעֲלַ֤ת גֵּרָה֙ הִ֔וא וּפַרְסָ֖ה לֹ֣א הִפְרִ֑יסָה טְמֵאָ֥ה הִ֖וא לָכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","וְאֶת־הַ֠חֲזִיר כִּֽי־מַפְרִ֨יס פַּרְסָ֜ה ה֗וּא וְשֹׁסַ֥ע שֶׁ֙סַע֙ פַּרְסָ֔ה וְה֖וּא גֵּרָ֣ה לֹֽא־יִגָּ֑ר טָמֵ֥א ה֖וּא לָכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","מִבְּשָׂרָם֙ לֹ֣א תֹאכֵ֔לוּ וּבְנִבְלָתָ֖ם לֹ֣א תִגָּ֑עוּ טְמֵאִ֥ים הֵ֖ם לָכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","אֶת־זֶה֙ תֹּֽאכְל֔וּ מִכֹּ֖ל אֲשֶׁ֣ר בַּמָּ֑יִם כֹּ֣ל אֲשֶׁר־לֹו֩ סְנַפִּ֨יר וְקַשְׂקֶ֜שֶׂת בַּמַּ֗יִם בַּיַּמִּ֛ים וּבַנְּחָלִ֖ים אֹתָ֥ם תֹּאכֵֽלוּ׃ ");
INSERT INTO hbo_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","וְכֹל֩ אֲשֶׁ֨ר אֵֽין־לֹ֜ו סְנַפִּ֣יר וְקַשְׂקֶ֗שֶׂת בַּיַּמִּים֙ וּבַנְּחָלִ֔ים מִכֹּל֙ שֶׁ֣רֶץ הַמַּ֔יִם וּמִכֹּ֛ל נֶ֥פֶשׁ הַחַיָּ֖ה אֲשֶׁ֣ר בַּמָּ֑יִם שֶׁ֥קֶץ הֵ֖ם לָכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","וְשֶׁ֖קֶץ יִהְי֣וּ לָכֶ֑ם מִבְּשָׂרָם֙ לֹ֣א תֹאכֵ֔לוּ וְאֶת־נִבְלָתָ֖ם תְּשַׁקֵּֽצוּ׃ ");
INSERT INTO hbo_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","כֹּ֣ל אֲשֶׁ֥ר אֵֽין־לֹ֛ו סְנַפִּ֥יר וְקַשְׂקֶ֖שֶׂת בַּמָּ֑יִם שֶׁ֥קֶץ ה֖וּא לָכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","וְאֶת־אֵ֙לֶּה֙ תְּשַׁקְּצ֣וּ מִן־הָעֹ֔וף לֹ֥א יֵאָכְל֖וּ שֶׁ֣קֶץ הֵ֑ם אֶת־הַנֶּ֙שֶׁר֙ וְאֶת־הַפֶּ֔רֶס וְאֵ֖ת הָעָזְנִיָּֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","וְאֶת־הַ֨דָּאָ֔ה וְאֶת־הָאַיָּ֖ה לְמִינָֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","אֵ֥ת כָּל־עֹרֵ֖ב לְמִינֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","וְאֵת֙ בַּ֣ת הַֽיַּעֲנָ֔ה וְאֶת־הַתַּחְמָ֖ס וְאֶת־הַשָּׁ֑חַף וְאֶת־הַנֵּ֖ץ לְמִינֵֽהוּ׃ ");
INSERT INTO hbo_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","וְאֶת־הַכֹּ֥וס וְאֶת־הַשָּׁלָ֖ךְ וְאֶת־הַיַּנְשֽׁוּף׃ ");
INSERT INTO hbo_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","וְאֶת־הַתִּנְשֶׁ֥מֶת וְאֶת־הַקָּאָ֖ת וְאֶת־הָרָחָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","וְאֵת֙ הַחֲסִידָ֔ה הָאֲנָפָ֖ה לְמִינָ֑הּ וְאֶת־הַדּוּכִיפַ֖ת וְאֶת־הָעֲטַלֵּֽף׃ ");
INSERT INTO hbo_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","כֹּ֚ל שֶׁ֣רֶץ הָעֹ֔וף הַהֹלֵ֖ךְ עַל־אַרְבַּ֑ע שֶׁ֥קֶץ ה֖וּא לָכֶֽם׃ ס ");
INSERT INTO hbo_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","אַ֤ךְ אֶת־זֶה֙ תֹּֽאכְל֔וּ מִכֹּל֙ שֶׁ֣רֶץ הָעֹ֔וף הַהֹלֵ֖ךְ עַל־אַרְבַּ֑ע אֲשֶׁר־*לֹא (לֹ֤ו) כְרָעַ֙יִם֙ מִמַּ֣עַל לְרַגְלָ֔יו לְנַתֵּ֥ר בָּהֵ֖ן עַל־הָאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","אֶת־אֵ֤לֶּה מֵהֶם֙ תֹּאכֵ֔לוּ אֶת־הָֽאַרְבֶּ֣ה לְמִינֹ֔ו וְאֶת־הַסָּלְעָ֖ם לְמִינֵ֑הוּ וְאֶת־הַחַרְגֹּ֣ל לְמִינֵ֔הוּ וְאֶת־הֶחָגָ֖ב לְמִינֵֽהוּ׃ ");
INSERT INTO hbo_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","וְכֹל֙ שֶׁ֣רֶץ הָעֹ֔וף אֲשֶׁר־לֹ֖ו אַרְבַּ֣ע רַגְלָ֑יִם שֶׁ֥קֶץ ה֖וּא לָכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","וּלְאֵ֖לֶּה תִּטַּמָּ֑אוּ כָּל־הַנֹּגֵ֥עַ בְּנִבְלָתָ֖ם יִטְמָ֥א עַד־הָעָֽרֶב׃ ");
INSERT INTO hbo_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","וְכָל־הַנֹּשֵׂ֖א מִנִּבְלָתָ֑ם יְכַבֵּ֥ס בְּגָדָ֖יו וְטָמֵ֥א עַד־הָעָֽרֶב׃ ");
INSERT INTO hbo_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","לְֽכָל־הַבְּהֵמָ֡ה אֲשֶׁ֣ר הִוא֩ מַפְרֶ֨סֶת פַּרְסָ֜ה וְשֶׁ֣סַע ׀ אֵינֶ֣נָּה שֹׁסַ֗עַת וְגֵרָה֙ אֵינֶ֣נָּה מַעֲלָ֔ה טְמֵאִ֥ים הֵ֖ם לָכֶ֑ם כָּל־הַנֹּגֵ֥עַ בָּהֶ֖ם יִטְמָֽא׃ ");
INSERT INTO hbo_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","וְכֹ֣ל ׀ הֹולֵ֣ךְ עַל־כַּפָּ֗יו בְּכָל־הַֽחַיָּה֙ הַהֹלֶ֣כֶת עַל־אַרְבַּ֔ע טְמֵאִ֥ים הֵ֖ם לָכֶ֑ם כָּל־הַנֹּגֵ֥עַ בְּנִבְלָתָ֖ם יִטְמָ֥א עַד־הָעָֽרֶב׃ ");
INSERT INTO hbo_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","וְהַנֹּשֵׂא֙ אֶת־נִבְלָתָ֔ם יְכַבֵּ֥ס בְּגָדָ֖יו וְטָמֵ֣א עַד־הָעָ֑רֶב טְמֵאִ֥ים הֵ֖מָּה לָכֶֽם׃ ס ");
INSERT INTO hbo_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","וְזֶ֤ה לָכֶם֙ הַטָּמֵ֔א בַּשֶּׁ֖רֶץ הַשֹּׁרֵ֣ץ עַל־הָאָ֑רֶץ הַחֹ֥לֶד וְהָעַכְבָּ֖ר וְהַצָּ֥ב לְמִינֵֽהוּ׃ ");
INSERT INTO hbo_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","וְהָאֲנָקָ֥ה וְהַכֹּ֖חַ וְהַלְּטָאָ֑ה וְהַחֹ֖מֶט וְהַתִּנְשָֽׁמֶת׃ ");
INSERT INTO hbo_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","אֵ֛לֶּה הַטְּמֵאִ֥ים לָכֶ֖ם בְּכָל־הַשָּׁ֑רֶץ כָּל־הַנֹּגֵ֧עַ בָּהֶ֛ם בְּמֹתָ֖ם יִטְמָ֥א עַד־הָעָֽרֶב׃ ");
INSERT INTO hbo_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","וְכֹ֣ל אֲשֶׁר־יִפֹּל־עָלָיו֩ מֵהֶ֨ם ׀ בְּמֹתָ֜ם יִטְמָ֗א מִכָּל־כְּלִי־עֵץ֙ אֹ֣ו בֶ֤גֶד אֹו־עֹור֙ אֹ֣ו שָׂ֔ק כָּל־כְּלִ֕י אֲשֶׁר־יֵעָשֶׂ֥ה מְלָאכָ֖ה בָּהֶ֑ם בַּמַּ֧יִם יוּבָ֛א וְטָמֵ֥א עַד־הָעֶ֖רֶב וְטָהֵֽר׃ ");
INSERT INTO hbo_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","וְכָל־כְּלִי־חֶ֔רֶשׂ אֲשֶׁר־יִפֹּ֥ל מֵהֶ֖ם אֶל־תֹּוכֹ֑ו כֹּ֣ל אֲשֶׁ֧ר בְּתֹוכֹ֛ו יִטְמָ֖א וְאֹתֹ֥ו תִשְׁבֹּֽרוּ׃ ");
INSERT INTO hbo_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","מִכָּל־הָאֹ֜כֶל אֲשֶׁ֣ר יֵאָכֵ֗ל אֲשֶׁ֨ר יָבֹ֥וא עָלָ֛יו מַ֖יִם יִטְמָ֑א וְכָל־מַשְׁקֶה֙ אֲשֶׁ֣ר יִשָּׁתֶ֔ה בְּכָל־כְּלִ֖י יִטְמָֽא׃ ");
INSERT INTO hbo_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","וְ֠כֹל אֲשֶׁר־יִפֹּ֨ל מִנִּבְלָתָ֥ם ׀ עָלָיו֮ יִטְמָא֒ תַּנּ֧וּר וְכִירַ֛יִם יֻתָּ֖ץ טְמֵאִ֣ים הֵ֑ם וּטְמֵאִ֖ים יִהְי֥וּ לָכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","אַ֣ךְ מַעְיָ֥ן וּבֹ֛ור מִקְוֵה־מַ֖יִם יִהְיֶ֣ה טָהֹ֑ור וְנֹגֵ֥עַ בְּנִבְלָתָ֖ם יִטְמָֽא׃ ");
INSERT INTO hbo_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","וְכִ֤י יִפֹּל֙ מִנִּבְלָתָ֔ם עַל־כָּל־זֶ֥רַע זֵר֖וּעַ אֲשֶׁ֣ר יִזָּרֵ֑עַ טָהֹ֖ור הֽוּא׃ ");
INSERT INTO hbo_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","וְכִ֤י יֻתַּן־מַ֙יִם֙ עַל־זֶ֔רַע וְנָפַ֥ל מִנִּבְלָתָ֖ם עָלָ֑יו טָמֵ֥א ה֖וּא לָכֶֽם׃ ס ");
INSERT INTO hbo_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","וְכִ֤י יָמוּת֙ מִן־הַבְּהֵמָ֔ה אֲשֶׁר־הִ֥יא לָכֶ֖ם לְאָכְלָ֑ה הַנֹּגֵ֥עַ בְּנִבְלָתָ֖הּ יִטְמָ֥א עַד־הָעָֽרֶב׃ ");
INSERT INTO hbo_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","וְהָֽאֹכֵל֙ מִנִּבְלָתָ֔הּ יְכַבֵּ֥ס בְּגָדָ֖יו וְטָמֵ֣א עַד־הָעָ֑רֶב וְהַנֹּשֵׂא֙ אֶת־נִבְלָתָ֔הּ יְכַבֵּ֥ס בְּגָדָ֖יו וְטָמֵ֥א עַד־הָעָֽרֶב׃ ");
INSERT INTO hbo_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","וְכָל־הַשֶּׁ֖רֶץ הַשֹּׁרֵ֣ץ עַל־הָאָ֑רֶץ שֶׁ֥קֶץ ה֖וּא לֹ֥א יֵאָכֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","כֹּל֩ הֹולֵ֨ךְ עַל־גָּחֹ֜ון וְכֹ֣ל ׀ הֹולֵ֣ךְ עַל־אַרְבַּ֗ע עַ֚ד כָּל־מַרְבֵּ֣ה רַגְלַ֔יִם לְכָל־הַשֶּׁ֖רֶץ הַשֹּׁרֵ֣ץ עַל־הָאָ֑רֶץ לֹ֥א תֹאכְל֖וּם כִּי־שֶׁ֥קֶץ הֵֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","אַל־תְּשַׁקְּצוּ֙ אֶת־נַפְשֹׁ֣תֵיכֶ֔ם בְּכָל־הַשֶּׁ֖רֶץ הַשֹּׁרֵ֑ץ וְלֹ֤א תִֽטַּמְּאוּ֙ בָּהֶ֔ם וְנִטְמֵתֶ֖ם בָּֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","כִּ֣י אֲנִ֣י יְהוָה֮ אֱלֹֽהֵיכֶם֒ וְהִתְקַדִּשְׁתֶּם֙ וִהְיִיתֶ֣ם קְדֹשִׁ֔ים כִּ֥י קָדֹ֖ושׁ אָ֑נִי וְלֹ֤א תְטַמְּאוּ֙ אֶת־נַפְשֹׁ֣תֵיכֶ֔ם בְּכָל־הַשֶּׁ֖רֶץ הָרֹמֵ֥שׂ עַל־הָאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","כִּ֣י ׀ אֲנִ֣י יְהוָ֗ה הַֽמַּעֲלֶ֤ה אֶתְכֶם֙ מֵאֶ֣רֶץ מִצְרַ֔יִם לִהְיֹ֥ת לָכֶ֖ם לֵאלֹהִ֑ים וִהְיִיתֶ֣ם קְדֹשִׁ֔ים כִּ֥י קָדֹ֖ושׁ אָֽנִי׃ ");
INSERT INTO hbo_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","זֹ֣את תֹּורַ֤ת הַבְּהֵמָה֙ וְהָעֹ֔וף וְכֹל֙ נֶ֣פֶשׁ הַֽחַיָּ֔ה הָרֹמֶ֖שֶׂת בַּמָּ֑יִם וּלְכָל־נֶ֖פֶשׁ הַשֹּׁרֶ֥צֶת עַל־הָאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","לְהַבְדִּ֕יל בֵּ֥ין הַטָּמֵ֖א וּבֵ֣ין הַטָּהֹ֑ר וּבֵ֤ין הַֽחַיָּה֙ הַֽנֶּאֱכֶ֔לֶת וּבֵין֙ הַֽחַיָּ֔ה אֲשֶׁ֖ר לֹ֥א תֵאָכֵֽל׃ פ ");
INSERT INTO hbo_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","דַּבֵּ֞ר אֶל־בְּנֵ֤י יִשְׂרָאֵל֙ לֵאמֹ֔ר אִשָּׁה֙ כִּ֣י תַזְרִ֔יעַ וְיָלְדָ֖ה זָכָ֑ר וְטָֽמְאָה֙ שִׁבְעַ֣ת יָמִ֔ים כִּימֵ֛י נִדַּ֥ת דְּוֹתָ֖הּ תִּטְמָֽא׃ ");
INSERT INTO hbo_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","וּבַיֹּ֖ום הַשְּׁמִינִ֑י יִמֹּ֖ול בְּשַׂ֥ר עָרְלָתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","וּשְׁלֹשִׁ֥ים יֹום֙ וּשְׁלֹ֣שֶׁת יָמִ֔ים תֵּשֵׁ֖ב בִּדְמֵ֣י טָהֳרָ֑ה בְּכָל־קֹ֣דֶשׁ לֹֽא־תִגָּ֗ע וְאֶל־הַמִּקְדָּשׁ֙ לֹ֣א תָבֹ֔א עַד־מְלֹ֖את יְמֵ֥י טָהֳרָֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","וְאִם־נְקֵבָ֣ה תֵלֵ֔ד וְטָמְאָ֥ה שְׁבֻעַ֖יִם כְּנִדָּתָ֑הּ וְשִׁשִּׁ֥ים יֹום֙ וְשֵׁ֣שֶׁת יָמִ֔ים תֵּשֵׁ֖ב עַל־דְּמֵ֥י טָהֳרָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","וּבִמְלֹ֣את ׀ יְמֵ֣י טָהֳרָ֗הּ לְבֵן֮ אֹ֣ו לְבַת֒ תָּבִ֞יא כֶּ֤בֶשׂ בֶּן־שְׁנָתֹו֙ לְעֹלָ֔ה וּבֶן־יֹונָ֥ה אֹו־תֹ֖ר לְחַטָּ֑את אֶל־פֶּ֥תַח אֹֽהֶל־מֹועֵ֖ד אֶל־הַכֹּהֵֽן׃ ");
INSERT INTO hbo_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","וְהִקְרִיבֹ֞ו לִפְנֵ֤י יְהוָה֙ וְכִפֶּ֣ר עָלֶ֔יהָ וְטָהֲרָ֖ה מִמְּקֹ֣ר דָּמֶ֑יהָ זֹ֤את תֹּורַת֙ הַיֹּלֶ֔דֶת לַזָּכָ֖ר אֹ֥ו לַנְּקֵבָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","וְאִם־לֹ֨א תִמְצָ֣א יָדָהּ֮ דֵּ֣י שֶׂה֒ וְלָקְחָ֣ה שְׁתֵּֽי־תֹרִ֗ים אֹ֤ו שְׁנֵי֙ בְּנֵ֣י יֹונָ֔ה אֶחָ֥ד לְעֹלָ֖ה וְאֶחָ֣ד לְחַטָּ֑את וְכִפֶּ֥ר עָלֶ֛יהָ הַכֹּהֵ֖ן וְטָהֵֽרָה׃ פ ");
INSERT INTO hbo_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","וַיְדַבֵּ֣ר יְהוָ֔ה אֶל־מֹשֶׁ֥ה וְאֶֽל־אַהֲרֹ֖ן לֵאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","אָדָ֗ם כִּֽי־יִהְיֶ֤ה בְעֹור־בְּשָׂרֹו֙ שְׂאֵ֤ת אֹֽו־סַפַּ֙חַת֙ אֹ֣ו בַהֶ֔רֶת וְהָיָ֥ה בְעֹור־בְּשָׂרֹ֖ו לְנֶ֣גַע צָרָ֑עַת וְהוּבָא֙ אֶל־אַהֲרֹ֣ן הַכֹּהֵ֔ן אֹ֛ו אֶל־אַחַ֥ד מִבָּנָ֖יו הַכֹּהֲנִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","וְרָאָ֣ה הַכֹּהֵ֣ן אֶת־הַנֶּ֣גַע בְּעֹֽור־הַ֠בָּשָׂר וְשֵׂעָ֨ר בַּנֶּ֜גַע הָפַ֣ךְ ׀ לָבָ֗ן וּמַרְאֵ֤ה הַנֶּ֙גַע֙ עָמֹק֙ מֵעֹ֣ור בְּשָׂרֹ֔ו נֶ֥גַע צָרַ֖עַת ה֑וּא וְרָאָ֥הוּ הַכֹּהֵ֖ן וְטִמֵּ֥א אֹתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","וְאִם־בַּהֶרֶת֩ לְבָנָ֨ה הִ֜וא בְּעֹ֣ור בְּשָׂרֹ֗ו וְעָמֹק֙ אֵין־מַרְאֶ֣הָ מִן־הָעֹ֔ור וּשְׂעָרָ֖ה לֹא־הָפַ֣ךְ לָבָ֑ן וְהִסְגִּ֧יר הַכֹּהֵ֛ן אֶת־הַנֶּ֖גַע שִׁבְעַ֥ת יָמִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","וְרָאָ֣הוּ הַכֹּהֵן֮ בַּיֹּ֣ום הַשְּׁבִיעִי֒ וְהִנֵּ֤ה הַנֶּ֙גַע֙ עָמַ֣ד בְּעֵינָ֔יו לֹֽא־פָשָׂ֥ה הַנֶּ֖גַע בָּעֹ֑ור וְהִסְגִּירֹ֧ו הַכֹּהֵ֛ן שִׁבְעַ֥ת יָמִ֖ים שֵׁנִֽית׃ ");
INSERT INTO hbo_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","וְרָאָה֩ הַכֹּהֵ֨ן אֹתֹ֜ו בַּיֹּ֣ום הַשְּׁבִיעִי֮ שֵׁנִית֒ וְהִנֵּה֙ כֵּהָ֣ה הַנֶּ֔גַע וְלֹא־פָשָׂ֥ה הַנֶּ֖גַע בָּעֹ֑ור וְטִהֲרֹ֤ו הַכֹּהֵן֙ מִסְפַּ֣חַת הִ֔יא וְכִבֶּ֥ס בְּגָדָ֖יו וְטָהֵֽר׃ ");
INSERT INTO hbo_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","וְאִם־פָּשֹׂ֨ה תִפְשֶׂ֤ה הַמִּסְפַּ֙חַת֙ בָּעֹ֔ור אַחֲרֵ֧י הֵרָאֹתֹ֛ו אֶל־הַכֹּהֵ֖ן לְטָהֳרָתֹ֑ו וְנִרְאָ֥ה שֵׁנִ֖ית אֶל־הַכֹּהֵֽן׃ ");
INSERT INTO hbo_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","וְרָאָה֙ הַכֹּהֵ֔ן וְהִנֵּ֛ה פָּשְׂתָ֥ה הַמִּסְפַּ֖חַת בָּעֹ֑ור וְטִמְּאֹ֥ו הַכֹּהֵ֖ן צָרַ֥עַת הִֽוא׃ פ ");
INSERT INTO hbo_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","נֶ֣גַע צָרַ֔עַת כִּ֥י תִהְיֶ֖ה בְּאָדָ֑ם וְהוּבָ֖א אֶל־הַכֹּהֵֽן׃ ");
INSERT INTO hbo_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","וְרָאָ֣ה הַכֹּהֵ֗ן וְהִנֵּ֤ה שְׂאֵת־לְבָנָה֙ בָּעֹ֔ור וְהִ֕יא הָפְכָ֖ה שֵׂעָ֣ר לָבָ֑ן וּמִֽחְיַ֛ת בָּשָׂ֥ר חַ֖י בַּשְׂאֵֽת׃ ");
INSERT INTO hbo_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","צָרַ֨עַת נֹושֶׁ֤נֶת הִוא֙ בְּעֹ֣ור בְּשָׂרֹ֔ו וְטִמְּאֹ֖ו הַכֹּהֵ֑ן לֹ֣א יַסְגִּרֶ֔נּוּ כִּ֥י טָמֵ֖א הֽוּא׃ ");
INSERT INTO hbo_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","וְאִם־פָּרֹ֨וחַ תִּפְרַ֤ח הַצָּרַ֙עַת֙ בָּעֹ֔ור וְכִסְּתָ֣ה הַצָּרַ֗עַת אֵ֚ת כָּל־עֹ֣ור הַנֶּ֔גַע מֵרֹאשֹׁ֖ו וְעַד־רַגְלָ֑יו לְכָל־מַרְאֵ֖ה עֵינֵ֥י הַכֹּהֵֽן׃ ");
INSERT INTO hbo_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","וְרָאָ֣ה הַכֹּהֵ֗ן וְהִנֵּ֨ה כִסְּתָ֤ה הַצָּרַ֙עַת֙ אֶת־כָּל־בְּשָׂרֹ֔ו וְטִהַ֖ר אֶת־הַנָּ֑גַע כֻּלֹּ֛ו הָפַ֥ךְ לָבָ֖ן טָהֹ֥ור הֽוּא׃ ");
INSERT INTO hbo_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","וּבְיֹ֨ום הֵרָאֹ֥ות בֹּ֛ו בָּשָׂ֥ר חַ֖י יִטְמָֽא׃ ");
INSERT INTO hbo_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","וְרָאָ֧ה הַכֹּהֵ֛ן אֶת־הַבָּשָׂ֥ר הַחַ֖י וְטִמְּאֹ֑ו הַבָּשָׂ֥ר הַחַ֛י טָמֵ֥א ה֖וּא צָרַ֥עַת הֽוּא׃ ");
INSERT INTO hbo_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","אֹ֣ו כִ֥י יָשׁ֛וּב הַבָּשָׂ֥ר הַחַ֖י וְנֶהְפַּ֣ךְ לְלָבָ֑ן וּבָ֖א אֶל־הַכֹּהֵֽן׃ ");
INSERT INTO hbo_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","וְרָאָ֙הוּ֙ הַכֹּהֵ֔ן וְהִנֵּ֛ה נֶהְפַּ֥ךְ הַנֶּ֖גַע לְלָבָ֑ן וְטִהַ֧ר הַכֹּהֵ֛ן אֶת־הַנֶּ֖גַע טָהֹ֥ור הֽוּא׃ פ ");
INSERT INTO hbo_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","וּבָשָׂ֕ר כִּֽי־יִהְיֶ֥ה בֹֽו־בְעֹרֹ֖ו שְׁחִ֑ין וְנִרְפָּֽא׃ ");
INSERT INTO hbo_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","וְהָיָ֞ה בִּמְקֹ֤ום הַשְּׁחִין֙ שְׂאֵ֣ת לְבָנָ֔ה אֹ֥ו בַהֶ֖רֶת לְבָנָ֣ה אֲדַמְדָּ֑מֶת וְנִרְאָ֖ה אֶל־הַכֹּהֵֽן׃ ");
INSERT INTO hbo_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","וְרָאָ֣ה הַכֹּהֵ֗ן וְהִנֵּ֤ה מַרְאֶ֙הָ֙ שָׁפָ֣ל מִן־הָעֹ֔ור וּשְׂעָרָ֖הּ הָפַ֣ךְ לָבָ֑ן וְטִמְּאֹ֧ו הַכֹּהֵ֛ן נֶֽגַע־צָרַ֥עַת הִ֖וא בַּשְּׁחִ֥ין פָּרָֽחָה׃ ");
INSERT INTO hbo_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","וְאִ֣ם ׀ יִרְאֶ֣נָּה הַכֹּהֵ֗ן וְהִנֵּ֤ה אֵֽין־בָּהּ֙ שֵׂעָ֣ר לָבָ֔ן וּשְׁפָלָ֥ה אֵינֶ֛נָּה מִן־הָעֹ֖ור וְהִ֣יא כֵהָ֑ה וְהִסְגִּירֹ֥ו הַכֹּהֵ֖ן שִׁבְעַ֥ת יָמִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","וְאִם־פָּשֹׂ֥ה תִפְשֶׂ֖ה בָּעֹ֑ור וְטִמֵּ֧א הַכֹּהֵ֛ן אֹתֹ֖ו נֶ֥גַע הִֽוא׃ ");
INSERT INTO hbo_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","וְאִם־תַּחְתֶּ֜יהָ תַּעֲמֹ֤ד הַבַּהֶ֙רֶת֙ לֹ֣א פָשָׂ֔תָה צָרֶ֥בֶת הַשְּׁחִ֖ין הִ֑וא וְטִהֲרֹ֖ו הַכֹּהֵֽן׃ ס ");
INSERT INTO hbo_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","אֹ֣ו בָשָׂ֔ר כִּֽי־יִהְיֶ֥ה בְעֹרֹ֖ו מִכְוַת־אֵ֑שׁ וְֽהָיְתָ֞ה מִֽחְיַ֣ת הַמִּכְוָ֗ה בַּהֶ֛רֶת לְבָנָ֥ה אֲדַמְדֶּ֖מֶת אֹ֥ו לְבָנָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","וְרָאָ֣ה אֹתָ֣הּ הַכֹּהֵ֡ן וְהִנֵּ֣ה נֶהְפַּךְ֩ שֵׂעָ֨ר לָבָ֜ן בַּבַּהֶ֗רֶת וּמַרְאֶ֙הָ֙ עָמֹ֣ק מִן־הָעֹ֔ור צָרַ֣עַת הִ֔וא בַּמִּכְוָ֖ה פָּרָ֑חָה וְטִמֵּ֤א אֹתֹו֙ הַכֹּהֵ֔ן נֶ֥גַע צָרַ֖עַת הִֽוא׃ ");
INSERT INTO hbo_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","וְאִ֣ם ׀ יִרְאֶ֣נָּה הַכֹּהֵ֗ן וְהִנֵּ֤ה אֵֽין־בַּבֶּהֶ֙רֶת֙ שֵׂעָ֣ר לָבָ֔ן וּשְׁפָלָ֥ה אֵינֶ֛נָּה מִן־הָעֹ֖ור וְהִ֣וא כֵהָ֑ה וְהִסְגִּירֹ֥ו הַכֹּהֵ֖ן שִׁבְעַ֥ת יָמִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","וְרָאָ֥הוּ הַכֹּהֵ֖ן בַּיֹּ֣ום הַשְּׁבִיעִ֑י אִם־פָּשֹׂ֤ה תִפְשֶׂה֙ בָּעֹ֔ור וְטִמֵּ֤א הַכֹּהֵן֙ אֹתֹ֔ו נֶ֥גַע צָרַ֖עַת הִֽוא׃ ");
INSERT INTO hbo_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","וְאִם־תַּחְתֶּיהָ֩ תַעֲמֹ֨ד הַבַּהֶ֜רֶת לֹא־פָשְׂתָ֤ה בָעֹור֙ וְהִ֣וא כֵהָ֔ה שְׂאֵ֥ת הַמִּכְוָ֖ה הִ֑וא וְטִֽהֲרֹו֙ הַכֹּהֵ֔ן כִּֽי־צָרֶ֥בֶת הַמִּכְוָ֖ה הִֽוא׃ פ ");
INSERT INTO hbo_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","וְאִישׁ֙ אֹ֣ו אִשָּׁ֔ה כִּֽי־יִהְיֶ֥ה בֹ֖ו נָ֑גַע בְּרֹ֖אשׁ אֹ֥ו בְזָקָֽן׃ ");
INSERT INTO hbo_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","וְרָאָ֨ה הַכֹּהֵ֜ן אֶת־הַנֶּ֗גַע וְהִנֵּ֤ה מַרְאֵ֙הוּ֙ עָמֹ֣ק מִן־הָעֹ֔ור וּבֹ֛ו שֵׂעָ֥ר צָהֹ֖ב דָּ֑ק וְטִמֵּ֨א אֹתֹ֤ו הַכֹּהֵן֙ נֶ֣תֶק ה֔וּא צָרַ֧עַת הָרֹ֛אשׁ אֹ֥ו הַזָּקָ֖ן הֽוּא׃ ");
INSERT INTO hbo_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","וְכִֽי־יִרְאֶ֨ה הַכֹּהֵ֜ן אֶת־נֶ֣גַע הַנֶּ֗תֶק וְהִנֵּ֤ה אֵין־מַרְאֵ֙הוּ֙ עָמֹ֣ק מִן־הָעֹ֔ור וְשֵׂעָ֥ר שָׁחֹ֖ר אֵ֣ין בֹּ֑ו וְהִסְגִּ֧יר הַכֹּהֵ֛ן אֶת־נֶ֥גַע הַנֶּ֖תֶק שִׁבְעַ֥ת יָמִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","וְרָאָ֨ה הַכֹּהֵ֣ן אֶת־הַנֶּגַע֮ בַּיֹּ֣ום הַשְּׁבִיעִי֒ וְהִנֵּה֙ לֹא־פָשָׂ֣ה הַנֶּ֔תֶק וְלֹא־הָ֥יָה בֹ֖ו שֵׂעָ֣ר צָהֹ֑ב וּמַרְאֵ֣ה הַנֶּ֔תֶק אֵ֥ין עָמֹ֖ק מִן־הָעֹֽור׃ ");
INSERT INTO hbo_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","וְהִ֨תְגַּלָּ֔ח וְאֶת־הַנֶּ֖תֶק לֹ֣א יְגַלֵּ֑חַ וְהִסְגִּ֨יר הַכֹּהֵ֧ן אֶת־הַנֶּ֛תֶק שִׁבְעַ֥ת יָמִ֖ים שֵׁנִֽית׃ ");
INSERT INTO hbo_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","וְרָאָה֩ הַכֹּהֵ֨ן אֶת־הַנֶּ֜תֶק בַּיֹּ֣ום הַשְּׁבִיעִ֗י וְ֠הִנֵּה לֹא־פָשָׂ֤ה הַנֶּ֙תֶק֙ בָּעֹ֔ור וּמַרְאֵ֕הוּ אֵינֶ֥נּוּ עָמֹ֖ק מִן־הָעֹ֑ור וְטִהַ֤ר אֹתֹו֙ הַכֹּהֵ֔ן וְכִבֶּ֥ס בְּגָדָ֖יו וְטָהֵֽר׃ ");
INSERT INTO hbo_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","וְאִם־פָּשֹׂ֥ה יִפְשֶׂ֛ה הַנֶּ֖תֶק בָּעֹ֑ור אַחֲרֵ֖י טָהֳרָתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","וְרָאָ֙הוּ֙ הַכֹּהֵ֔ן וְהִנֵּ֛ה פָּשָׂ֥ה הַנֶּ֖תֶק בָּעֹ֑ור לֹֽא־יְבַקֵּ֧ר הַכֹּהֵ֛ן לַשֵּׂעָ֥ר הַצָּהֹ֖ב טָמֵ֥א הֽוּא׃ ");
INSERT INTO hbo_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","וְאִם־בְּעֵינָיו֩ עָמַ֨ד הַנֶּ֜תֶק וְשֵׂעָ֨ר שָׁחֹ֧ר צָֽמַח־בֹּ֛ו נִרְפָּ֥א הַנֶּ֖תֶק טָהֹ֣ור ה֑וּא וְטִהֲרֹ֖ו הַכֹּהֵֽן׃ ס ");
INSERT INTO hbo_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","וְאִישׁ֙ אֹֽו־אִשָּׁ֔ה כִּֽי־יִהְיֶ֥ה בְעֹור־בְּשָׂרָ֖ם בֶּהָרֹ֑ת בֶּהָרֹ֖ת לְבָנֹֽת׃ ");
INSERT INTO hbo_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","וְרָאָ֣ה הַכֹּהֵ֗ן וְהִנֵּ֧ה בְעֹור־בְּשָׂרָ֛ם בֶּהָרֹ֖ת כֵּהֹ֣ות לְבָנֹ֑ת בֹּ֥הַק ה֛וּא פָּרַ֥ח בָּעֹ֖ור טָהֹ֥ור הֽוּא׃ ס ");
INSERT INTO hbo_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","וְאִ֕ישׁ כִּ֥י יִמָּרֵ֖ט רֹאשֹׁ֑ו קֵרֵ֥חַ ה֖וּא טָהֹ֥ור הֽוּא׃ ");
INSERT INTO hbo_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","וְאִם֙ מִפְּאַ֣ת פָּנָ֔יו יִמָּרֵ֖ט רֹאשֹׁ֑ו גִּבֵּ֥חַ ה֖וּא טָהֹ֥ור הֽוּא׃ ");
INSERT INTO hbo_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","וְכִֽי־יִהְיֶ֤ה בַקָּרַ֙חַת֙ אֹ֣ו בַגַּבַּ֔חַת נֶ֖גַע לָבָ֣ן אֲדַמְדָּ֑ם צָרַ֤עַת פֹּרַ֙חַת֙ הִ֔וא בְּקָרַחְתֹּ֖ו אֹ֥ו בְגַבַּחְתֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","וְרָאָ֨ה אֹתֹ֜ו הַכֹּהֵ֗ן וְהִנֵּ֤ה שְׂאֵת־הַנֶּ֙גַע֙ לְבָנָ֣ה אֲדַמְדֶּ֔מֶת בְּקָרַחְתֹּ֖ו אֹ֣ו בְגַבַּחְתֹּ֑ו כְּמַרְאֵ֥ה צָרַ֖עַת עֹ֥ור בָּשָֽׂר׃ ");
INSERT INTO hbo_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","אִישׁ־צָר֥וּעַ ה֖וּא טָמֵ֣א ה֑וּא טַמֵּ֧א יְטַמְּאֶ֛נּוּ הַכֹּהֵ֖ן בְּרֹאשֹׁ֥ו נִגְעֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","וְהַצָּר֜וּעַ אֲשֶׁר־בֹּ֣ו הַנֶּ֗גַע בְּגָדָ֞יו יִהְי֤וּ פְרֻמִים֙ וְרֹאשֹׁו֙ יִהְיֶ֣ה פָר֔וּעַ וְעַל־שָׂפָ֖ם יַעְטֶ֑ה וְטָמֵ֥א ׀ טָמֵ֖א יִקְרָֽא׃ ");
INSERT INTO hbo_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","כָּל־יְמֵ֞י אֲשֶׁ֨ר הַנֶּ֥גַע בֹּ֛ו יִטְמָ֖א טָמֵ֣א ה֑וּא בָּדָ֣ד יֵשֵׁ֔ב מִח֥וּץ לַֽמַּחֲנֶ֖ה מֹושָׁבֹֽו׃ ס ");
INSERT INTO hbo_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","וְהַבֶּ֕גֶד כִּֽי־יִהְיֶ֥ה בֹ֖ו נֶ֣גַע צָרָ֑עַת בְּבֶ֣גֶד צֶ֔מֶר אֹ֖ו בְּבֶ֥גֶד פִּשְׁתִּֽים׃ ");
INSERT INTO hbo_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","אֹ֤ו בִֽשְׁתִי֙ אֹ֣ו בְעֵ֔רֶב לַפִּשְׁתִּ֖ים וְלַצָּ֑מֶר אֹ֣ו בְעֹ֔ור אֹ֖ו בְּכָל־מְלֶ֥אכֶת עֹֽור׃ ");
INSERT INTO hbo_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","וְהָיָ֨ה הַנֶּ֜גַע יְרַקְרַ֣ק ׀ אֹ֣ו אֲדַמְדָּ֗ם בַּבֶּגֶד֩ אֹ֨ו בָעֹ֜ור אֹֽו־בַשְּׁתִ֤י אֹו־בָעֵ֙רֶב֙ אֹ֣ו בְכָל־כְּלִי־עֹ֔ור נֶ֥גַע צָרַ֖עַת ה֑וּא וְהָרְאָ֖ה אֶת־הַכֹּהֵֽן׃ ");
INSERT INTO hbo_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","וְרָאָ֥ה הַכֹּהֵ֖ן אֶת־הַנָּ֑גַע וְהִסְגִּ֥יר אֶת־הַנֶּ֖גַע שִׁבְעַ֥ת יָמִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","וְרָאָ֨ה אֶת־הַנֶּ֜גַע בַּיֹּ֣ום הַשְּׁבִיעִ֗י כִּֽי־פָשָׂ֤ה הַנֶּ֙גַע֙ בַּ֠בֶּגֶד אֹֽו־בַשְּׁתִ֤י אֹֽו־בָעֵ֙רֶב֙ אֹ֣ו בָעֹ֔ור לְכֹ֛ל אֲשֶׁר־יֵעָשֶׂ֥ה הָעֹ֖ור לִמְלָאכָ֑ה צָרַ֧עַת מַמְאֶ֛רֶת הַנֶּ֖גַע טָמֵ֥א הֽוּא׃ ");
INSERT INTO hbo_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","וְשָׂרַ֨ף אֶת־הַבֶּ֜גֶד אֹ֥ו אֶֽת־הַשְּׁתִ֣י ׀ אֹ֣ו אֶת־הָעֵ֗רֶב בַּצֶּ֙מֶר֙ אֹ֣ו בַפִּשְׁתִּ֔ים אֹ֚ו אֶת־כָּל־כְּלִ֣י הָעֹ֔ור אֲשֶׁר־יִהְיֶ֥ה בֹ֖ו הַנָּ֑גַע כִּֽי־צָרַ֤עַת מַמְאֶ֙רֶת֙ הִ֔וא בָּאֵ֖שׁ תִּשָּׂרֵֽף׃ ");
INSERT INTO hbo_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","וְאִם֮ יִרְאֶ֣ה הַכֹּהֵן֒ וְהִנֵּה֙ לֹא־פָשָׂ֣ה הַנֶּ֔גַע בַּבֶּ֕גֶד אֹ֥ו בַשְּׁתִ֖י אֹ֣ו בָעֵ֑רֶב אֹ֖ו בְּכָל־כְּלִי־עֹֽור׃ ");
INSERT INTO hbo_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","וְצִוָּה֙ הַכֹּהֵ֔ן וְכִ֨בְּס֔וּ אֵ֥ת אֲשֶׁר־בֹּ֖ו הַנָּ֑גַע וְהִסְגִּירֹ֥ו שִׁבְעַת־יָמִ֖ים שֵׁנִֽית׃ ");
INSERT INTO hbo_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","וְרָאָ֨ה הַכֹּהֵ֜ן אַחֲרֵ֣י ׀ הֻכַּבֵּ֣ס אֶת־הַנֶּ֗גַע וְ֠הִנֵּה לֹֽא־הָפַ֨ךְ הַנֶּ֤גַע אֶת־עֵינֹו֙ וְהַנֶּ֣גַע לֹֽא־פָשָׂ֔ה טָמֵ֣א ה֔וּא בָּאֵ֖שׁ תִּשְׂרְפֶ֑נּוּ פְּחֶ֣תֶת הִ֔וא בְּקָרַחְתֹּ֖ו אֹ֥ו בְגַבַּחְתֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","וְאִם֮ רָאָ֣ה הַכֹּהֵן֒ וְהִנֵּה֙ כֵּהָ֣ה הַנֶּ֔גַע אַחֲרֵ֖י הֻכַּבֵּ֣ס אֹתֹ֑ו וְקָרַ֣ע אֹתֹ֗ו מִן־הַבֶּ֙גֶד֙ אֹ֣ו מִן־הָעֹ֔ור אֹ֥ו מִן־הַשְּׁתִ֖י אֹ֥ו מִן־הָעֵֽרֶב׃ ");
INSERT INTO hbo_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","וְאִם־תֵּרָאֶ֨ה עֹ֜וד בַּ֠בֶּגֶד אֹֽו־בַשְּׁתִ֤י אֹֽו־בָעֵ֙רֶב֙ אֹ֣ו בְכָל־כְּלִי־עֹ֔ור פֹּרַ֖חַת הִ֑וא בָּאֵ֣שׁ תִּשְׂרְפֶ֔נּוּ אֵ֥ת אֲשֶׁר־בֹּ֖ו הַנָּֽגַע׃ ");
INSERT INTO hbo_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","וְהַבֶּ֡גֶד אֹֽו־הַשְּׁתִ֨י אֹו־הָעֵ֜רֶב אֹֽו־כָל־כְּלִ֤י הָעֹור֙ אֲשֶׁ֣ר תְּכַבֵּ֔ס וְסָ֥ר מֵהֶ֖ם הַנָּ֑גַע וְכֻבַּ֥ס שֵׁנִ֖ית וְטָהֵֽר׃ ");
INSERT INTO hbo_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","זֹ֠את תֹּורַ֨ת נֶֽגַע־צָרַ֜עַת בֶּ֥גֶד הַצֶּ֣מֶר ׀ אֹ֣ו הַפִּשְׁתִּ֗ים אֹ֤ו הַשְּׁתִי֙ אֹ֣ו הָעֵ֔רֶב אֹ֖ו כָּל־כְּלִי־עֹ֑ור לְטַהֲרֹ֖ו אֹ֥ו לְטַמְּאֹֽו׃ פ ");
INSERT INTO hbo_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","זֹ֤את תִּֽהְיֶה֙ תֹּורַ֣ת הַמְּצֹרָ֔ע בְּיֹ֖ום טָהֳרָתֹ֑ו וְהוּבָ֖א אֶל־הַכֹּהֵֽן׃ ");
INSERT INTO hbo_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","וְיָצָא֙ הַכֹּהֵ֔ן אֶל־מִח֖וּץ לַֽמַּחֲנֶ֑ה וְרָאָה֙ הַכֹּהֵ֔ן וְהִנֵּ֛ה נִרְפָּ֥א נֶֽגַע־הַצָּרַ֖עַת מִן־הַצָּרֽוּעַ׃ ");
INSERT INTO hbo_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","וְצִוָּה֙ הַכֹּהֵ֔ן וְלָקַ֧ח לַמִּטַּהֵ֛ר שְׁתֵּֽי־צִפֳּרִ֥ים חַיֹּ֖ות טְהֹרֹ֑ות וְעֵ֣ץ אֶ֔רֶז וּשְׁנִ֥י תֹולַ֖עַת וְאֵזֹֽב׃ ");
INSERT INTO hbo_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","וְצִוָּה֙ הַכֹּהֵ֔ן וְשָׁחַ֖ט אֶת־הַצִּפֹּ֣ור הָאֶחָ֑ת אֶל־כְּלִי־חֶ֖רֶשׂ עַל־מַ֥יִם חַיִּֽים׃ ");
INSERT INTO hbo_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","אֶת־הַצִּפֹּ֤ר הַֽחַיָּה֙ יִקַּ֣ח אֹתָ֔הּ וְאֶת־עֵ֥ץ הָאֶ֛רֶז וְאֶת־שְׁנִ֥י הַתֹּולַ֖עַת וְאֶת־הָאֵזֹ֑ב וְטָבַ֨ל אֹותָ֜ם וְאֵ֣ת ׀ הַצִּפֹּ֣ר הֽ͏ַחַיָּ֗ה בְּדַם֙ הַצִּפֹּ֣ר הַשְּׁחֻטָ֔ה עַ֖ל הַמַּ֥יִם הֽ͏ַחַיִּֽים׃ ");
INSERT INTO hbo_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","וְהִזָּ֗ה עַ֧ל הַמִּטַּהֵ֛ר מִן־הַצָּרַ֖עַת שֶׁ֣בַע פְּעָמִ֑ים וְטִ֣הֲרֹ֔ו וְשִׁלַּ֛ח אֶת־הַצִּפֹּ֥ר הַֽחַיָּ֖ה עַל־פְּנֵ֥י הַשָּׂדֶֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","וְכִבֶּס֩ הַמִּטַּהֵ֨ר אֶת־בְּגָדָ֜יו וְגִלַּ֣ח אֶת־כָּל־שְׂעָרֹ֗ו וְרָחַ֤ץ בַּמַּ֙יִם֙ וְטָהֵ֔ר וְאַחַ֖ר יָבֹ֣וא אֶל־הַֽמַּחֲנֶ֑ה וְיָשַׁ֛ב מִח֥וּץ לְאָהֳלֹ֖ו שִׁבְעַ֥ת יָמִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","וְהָיָה֩ בַיֹּ֨ום הַשְּׁבִיעִ֜י יְגַלַּ֣ח אֶת־כָּל־שְׂעָרֹ֗ו אֶת־רֹאשֹׁ֤ו וְאֶת־זְקָנֹו֙ וְאֵת֙ גַּבֹּ֣ת עֵינָ֔יו וְאֶת־כָּל־שְׂעָרֹ֖ו יְגַלֵּ֑חַ וְכִבֶּ֣ס אֶת־בְּגָדָ֗יו וְרָחַ֧ץ אֶת־בְּשָׂרֹ֛ו בַּמַּ֖יִם וְטָהֵֽר׃ ");
INSERT INTO hbo_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","וּבַיֹּ֣ום הַשְּׁמִינִ֗י יִקַּ֤ח שְׁנֵֽי־כְבָשִׂים֙ תְּמִימִ֔ים וְכַבְשָׂ֥ה אַחַ֛ת בַּת־שְׁנָתָ֖הּ תְּמִימָ֑ה וּשְׁלֹשָׁ֣ה עֶשְׂרֹנִ֗ים סֹ֤לֶת מִנְחָה֙ בְּלוּלָ֣ה בַשֶּׁ֔מֶן וְלֹ֥ג אֶחָ֖ד שָֽׁמֶן׃ ");
INSERT INTO hbo_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","וְהֶעֱמִ֞יד הַכֹּהֵ֣ן הַֽמְטַהֵ֗ר אֵ֛ת הָאִ֥ישׁ הַמִּטַּהֵ֖ר וְאֹתָ֑ם לִפְנֵ֣י יְהוָ֔ה פֶּ֖תַח אֹ֥הֶל מֹועֵֽד׃ ");
INSERT INTO hbo_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","וְלָקַ֨ח הַכֹּהֵ֜ן אֶת־הַכֶּ֣בֶשׂ הָאֶחָ֗ד וְהִקְרִ֥יב אֹתֹ֛ו לְאָשָׁ֖ם וְאֶת־לֹ֣ג הַשָּׁ֑מֶן וְהֵנִ֥יף אֹתָ֛ם תְּנוּפָ֖ה לִפְנֵ֥י יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","וְשָׁחַ֣ט אֶת־הַכֶּ֗בֶשׂ בִּ֠מְקֹום אֲשֶׁ֨ר יִשְׁחַ֧ט אֶת־הַֽחַטָּ֛את וְאֶת־הָעֹלָ֖ה בִּמְקֹ֣ום הַקֹּ֑דֶשׁ כִּ֡י כַּ֠חַטָּאת הָאָשָׁ֥ם הוּא֙ לַכֹּהֵ֔ן קֹ֥דֶשׁ קֽ͏ָדָשִׁ֖ים הֽוּא׃ ");
INSERT INTO hbo_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","וְלָקַ֣ח הַכֹּהֵן֮ מִדַּ֣ם הָאָשָׁם֒ וְנָתַן֙ הַכֹּהֵ֔ן עַל־תְּנ֛וּךְ אֹ֥זֶן הַמִּטַּהֵ֖ר הַיְמָנִ֑ית וְעַל־בֹּ֤הֶן יָדֹו֙ הַיְמָנִ֔ית וְעַל־בֹּ֥הֶן רַגְלֹ֖ו הַיְמָנִֽית׃ ");
INSERT INTO hbo_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","וְלָקַ֥ח הַכֹּהֵ֖ן מִלֹּ֣ג הַשָּׁ֑מֶן וְיָצַ֛ק עַל־כַּ֥ף הַכֹּהֵ֖ן הַשְּׂמָאלִֽית׃ ");
INSERT INTO hbo_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","וְטָבַ֤ל הַכֹּהֵן֙ אֶת־אֶצְבָּעֹ֣ו הַיְמָנִ֔ית מִן־הַשֶּׁ֕מֶן אֲשֶׁ֥ר עַל־כַּפֹּ֖ו הַשְּׂמָאלִ֑ית וְהִזָּ֨ה מִן־הַשֶּׁ֧מֶן בְּאֶצְבָּעֹ֛ו שֶׁ֥בַע פְּעָמִ֖ים לִפְנֵ֥י יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","וּמִיֶּ֨תֶר הַשֶּׁ֜מֶן אֲשֶׁ֣ר עַל־כַּפֹּ֗ו יִתֵּ֤ן הַכֹּהֵן֙ עַל־תְּנ֞וּךְ אֹ֤זֶן הַמִּטַּהֵר֙ הַיְמָנִ֔ית וְעַל־בֹּ֤הֶן יָדֹו֙ הַיְמָנִ֔ית וְעַל־בֹּ֥הֶן רַגְלֹ֖ו הַיְמָנִ֑ית עַ֖ל דַּ֥ם הָאָשָֽׁם׃ ");
INSERT INTO hbo_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","וְהַנֹּותָ֗ר בַּשֶּׁ֙מֶן֙ אֲשֶׁר֙ עַל־כַּ֣ף הַכֹּהֵ֔ן יִתֵּ֖ן עַל־רֹ֣אשׁ הַמִּטַּהֵ֑ר וְכִפֶּ֥ר עָלָ֛יו הַכֹּהֵ֖ן לִפְנֵ֥י יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","וְעָשָׂ֤ה הַכֹּהֵן֙ אֶת־הַ֣חַטָּ֔את וְכִפֶּ֕ר עַל־הַמִּטַּהֵ֖ר מִטֻּמְאָתֹ֑ו וְאַחַ֖ר יִשְׁחַ֥ט אֶת־הָעֹלָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","וְהֶעֱלָ֧ה הַכֹּהֵ֛ן אֶת־הָעֹלָ֥ה וְאֶת־הַמִּנְחָ֖ה הַמִּזְבֵּ֑חָה וְכִפֶּ֥ר עָלָ֛יו הַכֹּהֵ֖ן וְטָהֵֽר׃ ס ");
INSERT INTO hbo_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","וְאִם־דַּ֣ל ה֗וּא וְאֵ֣ין יָדֹו֮ מַשֶּׂגֶת֒ וְ֠לָקַח כֶּ֣בֶשׂ אֶחָ֥ד אָשָׁ֛ם לִתְנוּפָ֖ה לְכַפֵּ֣ר עָלָ֑יו וְעִשָּׂרֹ֨ון סֹ֜לֶת אֶחָ֨ד בָּל֥וּל בַּשֶּׁ֛מֶן לְמִנְחָ֖ה וְלֹ֥ג שָֽׁמֶן׃ ");
INSERT INTO hbo_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","וּשְׁתֵּ֣י תֹרִ֗ים אֹ֤ו שְׁנֵי֙ בְּנֵ֣י יֹונָ֔ה אֲשֶׁ֥ר תַּשִּׂ֖יג יָדֹ֑ו וְהָיָ֤ה אֶחָד֙ חַטָּ֔את וְהָאֶחָ֖ד עֹלָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","וְהֵבִ֨יא אֹתָ֜ם בַּיֹּ֧ום הַשְּׁמִינִ֛י לְטָהֳרָתֹ֖ו אֶל־הַכֹּהֵ֑ן אֶל־פֶּ֥תַח אֹֽהֶל־מֹועֵ֖ד לִפְנֵ֥י יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","וְלָקַ֧ח הַכֹּהֵ֛ן אֶת־כֶּ֥בֶשׂ הָאָשָׁ֖ם וְאֶת־לֹ֣ג הַשָּׁ֑מֶן וְהֵנִ֨יף אֹתָ֧ם הַכֹּהֵ֛ן תְּנוּפָ֖ה לִפְנֵ֥י יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","וְשָׁחַט֮ אֶת־כֶּ֣בֶשׂ הָֽאָשָׁם֒ וְלָקַ֤ח הַכֹּהֵן֙ מִדַּ֣ם הָֽאָשָׁ֔ם וְנָתַ֛ן עַל־תְּנ֥וּךְ אֹֽזֶן־הַמִּטַּהֵ֖ר הַיְמָנִ֑ית וְעַל־בֹּ֤הֶן יָדֹו֙ הַיְמָנִ֔ית וְעַל־בֹּ֥הֶן רַגְלֹ֖ו הַיְמָנִֽית׃ ");
INSERT INTO hbo_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","וּמִן־הַשֶּׁ֖מֶן יִצֹ֣ק הַכֹּהֵ֑ן עַל־כַּ֥ף הַכֹּהֵ֖ן הַשְּׂמָאלִֽית׃ ");
INSERT INTO hbo_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","וְהִזָּ֤ה הַכֹּהֵן֙ בְּאֶצְבָּעֹ֣ו הַיְמָנִ֔ית מִן־הַשֶּׁ֕מֶן אֲשֶׁ֥ר עַל־כַּפֹּ֖ו הַשְּׂמָאלִ֑ית שֶׁ֥בַע פְּעָמִ֖ים לִפְנֵ֥י יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","וְנָתַ֨ן הַכֹּהֵ֜ן מִן־הַשֶּׁ֣מֶן ׀ אֲשֶׁ֣ר עַל־כַּפֹּ֗ו עַל־תְּנ֞וּךְ אֹ֤זֶן הַמִּטַּהֵר֙ הַיְמָנִ֔ית וְעַל־בֹּ֤הֶן יָדֹו֙ הַיְמָנִ֔ית וְעַל־בֹּ֥הֶן רַגְלֹ֖ו הַיְמָנִ֑ית עַל־מְקֹ֖ום דַּ֥ם הָאָשָֽׁם׃ ");
INSERT INTO hbo_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","וְהַנֹּותָ֗ר מִן־הַשֶּׁ֙מֶן֙ אֲשֶׁר֙ עַל־כַּ֣ף הַכֹּהֵ֔ן יִתֵּ֖ן עַל־רֹ֣אשׁ הַמִּטַּהֵ֑ר לְכַפֵּ֥ר עָלָ֖יו לִפְנֵ֥י יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","וְעָשָׂ֤ה אֶת־הָֽאֶחָד֙ מִן־הַתֹּרִ֔ים אֹ֖ו מִן־בְּנֵ֣י הַיֹּונָ֑ה מֵאֲשֶׁ֥ר תַּשִּׂ֖יג יָדֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","אֵ֣ת אֲשֶׁר־תַּשִּׂ֞יג יָדֹ֗ו אֶת־הָאֶחָ֥ד חַטָּ֛את וְאֶת־הָאֶחָ֥ד עֹלָ֖ה עַל־הַמִּנְחָ֑ה וְכִפֶּ֧ר הַכֹּהֵ֛ן עַ֥ל הַמִּטַּהֵ֖ר לִפְנֵ֥י יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","זֹ֣את תֹּורַ֔ת אֲשֶׁר־בֹּ֖ו נֶ֣גַע צָרָ֑עַת אֲשֶׁ֛ר לֹֽא־תַשִּׂ֥יג יָדֹ֖ו בְּטָהֳרָתֹֽו׃ פ ");
INSERT INTO hbo_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","וַיְדַבֵּ֣ר יְהוָ֔ה אֶל־מֹשֶׁ֥ה וְאֶֽל־אַהֲרֹ֖ן לֵאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","כִּ֤י תָבֹ֙אוּ֙ אֶל־אֶ֣רֶץ כְּנַ֔עַן אֲשֶׁ֥ר אֲנִ֛י נֹתֵ֥ן לָכֶ֖ם לַאֲחֻזָּ֑ה וְנָתַתִּי֙ נֶ֣גַע צָרַ֔עַת בְּבֵ֖ית אֶ֥רֶץ אֲחֻזַּתְכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","וּבָא֙ אֲשֶׁר־לֹ֣ו הַבַּ֔יִת וְהִגִּ֥יד לַכֹּהֵ֖ן לֵאמֹ֑ר כְּנֶ֕גַע נִרְאָ֥ה לִ֖י בַּבָּֽיִת׃ ");
INSERT INTO hbo_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","וְצִוָּ֨ה הַכֹּהֵ֜ן וּפִנּ֣וּ אֶת־הַבַּ֗יִת בְּטֶ֨רֶם יָבֹ֤א הַכֹּהֵן֙ לִרְאֹ֣ות אֶת־הַנֶּ֔גַע וְלֹ֥א יִטְמָ֖א כָּל־אֲשֶׁ֣ר בַּבָּ֑יִת וְאַ֥חַר כֵּ֛ן יָבֹ֥א הַכֹּהֵ֖ן לִרְאֹ֥ות אֶת־הַבָּֽיִת׃ ");
INSERT INTO hbo_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","וְרָאָ֣ה אֶת־הַנֶּ֗גַע וְהִנֵּ֤ה הַנֶּ֙גַע֙ בְּקִירֹ֣ת הַבַּ֔יִת שְׁקַֽעֲרוּרֹת֙ יְרַקְרַקֹּ֔ת אֹ֖ו אֲדַמְדַּמֹּ֑ת וּמַרְאֵיהֶ֥ן שָׁפָ֖ל מִן־הַקִּֽיר׃ ");
INSERT INTO hbo_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","וְיָצָ֧א הַכֹּהֵ֛ן מִן־הַבַּ֖יִת אֶל־פֶּ֣תַח הַבָּ֑יִת וְהִסְגִּ֥יר אֶת־הַבַּ֖יִת שִׁבְעַ֥ת יָמִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","וְשָׁ֥ב הַכֹּהֵ֖ן בַּיֹּ֣ום הַשְּׁבִיעִ֑י וְרָאָ֕ה וְהִנֵּ֛ה פָּשָׂ֥ה הַנֶּ֖גַע בְּקִירֹ֥ת הַבָּֽיִת׃ ");
INSERT INTO hbo_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","וְצִוָּה֙ הַכֹּהֵ֔ן וְחִלְּצוּ֙ אֶת־הָ֣אֲבָנִ֔ים אֲשֶׁ֥ר בָּהֵ֖ן הַנָּ֑גַע וְהִשְׁלִ֤יכוּ אֶתְהֶן֙ אֶל־מִח֣וּץ לָעִ֔יר אֶל־מָקֹ֖ום טָמֵֽא׃ ");
INSERT INTO hbo_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","וְאֶת־הַבַּ֛יִת יַקְצִ֥עַ מִבַּ֖יִת סָבִ֑יב וְשָׁפְכ֗וּ אֶת־הֶֽעָפָר֙ אֲשֶׁ֣ר הִקְצ֔וּ אֶל־מִח֣וּץ לָעִ֔יר אֶל־מָקֹ֖ום טָמֵֽא׃ ");
INSERT INTO hbo_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","וְלָקְחוּ֙ אֲבָנִ֣ים אֲחֵרֹ֔ות וְהֵבִ֖יאוּ אֶל־תַּ֣חַת הָאֲבָנִ֑ים וְעָפָ֥ר אַחֵ֛ר יִקַּ֖ח וְטָ֥ח אֶת־הַבָּֽיִת׃ ");
INSERT INTO hbo_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","וְאִם־יָשׁ֤וּב הַנֶּ֙גַע֙ וּפָרַ֣ח בַּבַּ֔יִת אַחַ֖ר חִלֵּ֣ץ אֶת־הָאֲבָנִ֑ים וְאַחֲרֵ֛י הִקְצֹ֥ות אֶת־הַבַּ֖יִת וְאַחֲרֵ֥י הִטֹּֽוחַ׃ ");
INSERT INTO hbo_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","וּבָא֙ הַכֹּהֵ֔ן וְרָאָ֕ה וְהִנֵּ֛ה פָּשָׂ֥ה הַנֶּ֖גַע בַּבָּ֑יִת צָרַ֨עַת מַמְאֶ֥רֶת הִ֛וא בַּבַּ֖יִת טָמֵ֥א הֽוּא׃ ");
INSERT INTO hbo_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","וְנָתַ֣ץ אֶת־הַבַּ֗יִת אֶת־אֲבָנָיו֙ וְאֶת־עֵצָ֔יו וְאֵ֖ת כָּל־עֲפַ֣ר הַבָּ֑יִת וְהֹוצִיא֙ אֶל־מִח֣וּץ לָעִ֔יר אֶל־מָקֹ֖ום טָמֵֽא׃ ");
INSERT INTO hbo_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","וְהַבָּא֙ אֶל־הַבַּ֔יִת כָּל־יְמֵ֖י הִסְגִּ֣יר אֹתֹ֑ו יִטְמָ֖א עַד־הָעָֽרֶב׃ ");
INSERT INTO hbo_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","וְהַשֹּׁכֵ֣ב בַּבַּ֔יִת יְכַבֵּ֖ס אֶת־בְּגָדָ֑יו וְהָאֹכֵ֣ל בַּבַּ֔יִת יְכַבֵּ֖ס אֶת־בְּגָדָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","וְאִם־בֹּ֨א יָבֹ֜א הַכֹּהֵ֗ן וְרָאָה֙ וְ֠הִנֵּה לֹא־פָשָׂ֤ה הַנֶּ֙גַע֙ בַּבַּ֔יִת אַחֲרֵ֖י הִטֹּ֣חַ אֶת־הַבָּ֑יִת וְטִהַ֤ר הַכֹּהֵן֙ אֶת־הַבַּ֔יִת כִּ֥י נִרְפָּ֖א הַנָּֽגַע׃ ");
INSERT INTO hbo_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","וְלָקַ֛ח לְחַטֵּ֥א אֶת־הַבַּ֖יִת שְׁתֵּ֣י צִפֳּרִ֑ים וְעֵ֣ץ אֶ֔רֶז וּשְׁנִ֥י תֹולַ֖עַת וְאֵזֹֽב׃ ");
INSERT INTO hbo_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","וְשָׁחַ֖ט אֶת־הַצִּפֹּ֣ר הָאֶחָ֑ת אֶל־כְּלִי־חֶ֖רֶשׂ עַל־מַ֥יִם חַיִּֽים׃ ");
INSERT INTO hbo_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","וְלָקַ֣ח אֶת־עֵֽץ־הָ֠אֶרֶז וְאֶת־הָ֨אֵזֹ֜ב וְאֵ֣ת ׀ שְׁנִ֣י הַתֹּולַ֗עַת וְאֵת֮ הַצִּפֹּ֣ר הֽ͏ַחַיָּה֒ וְטָבַ֣ל אֹתָ֗ם בְּדַם֙ הַצִּפֹּ֣ר הַשְּׁחוּטָ֔ה וּבַמַּ֖יִם הַֽחַיִּ֑ים וְהִזָּ֥ה אֶל־הַבַּ֖יִת שֶׁ֥בַע פְּעָמִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","וְחִטֵּ֣א אֶת־הַבַּ֔יִת בְּדַם֙ הַצִּפֹּ֔ור וּבַמַּ֖יִם הַֽחַיִּ֑ים וּבַצִּפֹּ֣ר הַחַיָּ֗ה וּבְעֵ֥ץ הָאֶ֛רֶז וּבָאֵזֹ֖ב וּבִשְׁנִ֥י הַתֹּולָֽעַת׃ ");
INSERT INTO hbo_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","וְשִׁלַּ֞ח אֶת־הַצִּפֹּ֧ר הַֽחַיָּ֛ה אֶל־מִח֥וּץ לָעִ֖יר אֶל־פְּנֵ֣י הַשָּׂדֶ֑ה וְכִפֶּ֥ר עַל־הַבַּ֖יִת וְטָהֵֽר׃ ");
INSERT INTO hbo_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","זֹ֖את הַתֹּורָ֑ה לְכָל־נֶ֥גַע הַצָּרַ֖עַת וְלַנָּֽתֶק׃ ");
INSERT INTO hbo_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","וּלְצָרַ֥עַת הַבֶּ֖גֶד וְלַבָּֽיִת׃ ");
INSERT INTO hbo_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","וְלַשְׂאֵ֥ת וְלַסַּפַּ֖חַת וְלַבֶּהָֽרֶת׃ ");
INSERT INTO hbo_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","לְהֹורֹ֕ת בְּיֹ֥ום הַטָּמֵ֖א וּבְיֹ֣ום הַטָּהֹ֑ר זֹ֥את תֹּורַ֖ת הַצָּרָֽעַת׃ ס ");
INSERT INTO hbo_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","וַיְדַבֵּ֣ר יְהוָ֔ה אֶל־מֹשֶׁ֥ה וְאֶֽל־אַהֲרֹ֖ן לֵאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","דַּבְּרוּ֙ אֶל־בְּנֵ֣י יִשְׂרָאֵ֔ל וַאֲמַרְתֶּ֖ם אֲלֵהֶ֑ם אִ֣ישׁ אִ֗ישׁ כִּ֤י יִהְיֶה֙ זָ֣ב מִבְּשָׂרֹ֔ו זֹובֹ֖ו טָמֵ֥א הֽוּא׃ ");
INSERT INTO hbo_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","וְזֹ֛את תִּהְיֶ֥ה טֻמְאָתֹ֖ו בְּזֹובֹ֑ו רָ֣ר בְּשָׂרֹ֞ו אֶת־זֹובֹ֗ו אֹֽו־הֶחְתִּ֤ים בְּשָׂרֹו֙ מִזֹּובֹ֔ו טֻמְאָתֹ֖ו הִֽוא׃ ");
INSERT INTO hbo_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","כָּל־הַמִּשְׁכָּ֗ב אֲשֶׁ֨ר יִשְׁכַּ֥ב עָלָ֛יו הַזָּ֖ב יִטְמָ֑א וְכָֽל־הַכְּלִ֛י אֲשֶׁר־יֵשֵׁ֥ב עָלָ֖יו יִטְמָֽא׃ ");
INSERT INTO hbo_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","וְאִ֕ישׁ אֲשֶׁ֥ר יִגַּ֖ע בְּמִשְׁכָּבֹ֑ו יְכַבֵּ֧ס בְּגָדָ֛יו וְרָחַ֥ץ בַּמַּ֖יִם וְטָמֵ֥א עַד־הָעָֽרֶב׃ ");
INSERT INTO hbo_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","וְהַיֹּשֵׁב֙ עַֽל־הַכְּלִ֔י אֲשֶׁר־יֵשֵׁ֥ב עָלָ֖יו הַזָּ֑ב יְכַבֵּ֧ס בְּגָדָ֛יו וְרָחַ֥ץ בַּמַּ֖יִם וְטָמֵ֥א עַד־הָעָֽרֶב׃ ");
INSERT INTO hbo_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","וְהַנֹּגֵ֖עַ בִּבְשַׂ֣ר הַזָּ֑ב יְכַבֵּ֧ס בְּגָדָ֛יו וְרָחַ֥ץ בַּמַּ֖יִם וְטָמֵ֥א עַד־הָעָֽרֶב׃ ");
INSERT INTO hbo_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","וְכִֽי־יָרֹ֛ק הַזָּ֖ב בַּטָּהֹ֑ור וְכִבֶּ֧ס בְּגָדָ֛יו וְרָחַ֥ץ בַּמַּ֖יִם וְטָמֵ֥א עַד־הָעָֽרֶב׃ ");
INSERT INTO hbo_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","וְכָל־הַמֶּרְכָּ֗ב אֲשֶׁ֨ר יִרְכַּ֥ב עָלָ֛יו הַזָּ֖ב יִטְמָֽא׃ ");
INSERT INTO hbo_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","וְכָל־הַנֹּגֵ֗עַ בְּכֹל֙ אֲשֶׁ֣ר יִהְיֶ֣ה תַחְתָּ֔יו יִטְמָ֖א עַד־הָעָ֑רֶב וְהַנֹּושֵׂ֣א אֹותָ֔ם יְכַבֵּ֧ס בְּגָדָ֛יו וְרָחַ֥ץ בַּמַּ֖יִם וְטָמֵ֥א עַד־הָעָֽרֶב׃ ");
INSERT INTO hbo_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","וְכֹ֨ל אֲשֶׁ֤ר יִגַּע־בֹּו֙ הַזָּ֔ב וְיָדָ֖יו לֹא־שָׁטַ֣ף בַּמָּ֑יִם וְכִבֶּ֧ס בְּגָדָ֛יו וְרָחַ֥ץ בַּמַּ֖יִם וְטָמֵ֥א עַד־הָעָֽרֶב׃ ");
INSERT INTO hbo_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","וּכְלִי־חֶ֛רֶשׂ אֲשֶׁר־יִגַּע־בֹּ֥ו הַזָּ֖ב יִשָּׁבֵ֑ר וְכָל־כְּלִי־עֵ֔ץ יִשָּׁטֵ֖ף בַּמָּֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","וְכִֽי־יִטְהַ֤ר הַזָּב֙ מִזֹּובֹ֔ו וְסָ֨פַר לֹ֜ו שִׁבְעַ֥ת יָמִ֛ים לְטָהֳרָתֹ֖ו וְכִבֶּ֣ס בְּגָדָ֑יו וְרָחַ֧ץ בְּשָׂרֹ֛ו בְּמַ֥יִם חַיִּ֖ים וְטָהֵֽר׃ ");
INSERT INTO hbo_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","וּבַיֹּ֣ום הַשְּׁמִינִ֗י יִֽקַּֽח־לֹו֙ שְׁתֵּ֣י תֹרִ֔ים אֹ֥ו שְׁנֵ֖י בְּנֵ֣י יֹונָ֑ה וּבָ֣א ׀ לִפְנֵ֣י יְהוָ֗ה אֶל־פֶּ֙תַח֙ אֹ֣הֶל מֹועֵ֔ד וּנְתָנָ֖ם אֶל־הַכֹּהֵֽן׃ ");
INSERT INTO hbo_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","וְעָשָׂ֤ה אֹתָם֙ הַכֹּהֵ֔ן אֶחָ֣ד חַטָּ֔את וְהָאֶחָ֖ד עֹלָ֑ה וְכִפֶּ֨ר עָלָ֧יו הַכֹּהֵ֛ן לִפְנֵ֥י יְהוָ֖ה מִזֹּובֹֽו׃ ס ");
INSERT INTO hbo_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","וְאִ֕ישׁ כִּֽי־תֵצֵ֥א מִמֶּ֖נּוּ שִׁכְבַת־זָ֑רַע וְרָחַ֥ץ בַּמַּ֛יִם אֶת־כָּל־בְּשָׂרֹ֖ו וְטָמֵ֥א עַד־הָעָֽרֶב׃ ");
INSERT INTO hbo_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","וְכָל־בֶּ֣גֶד וְכָל־עֹ֔ור אֲשֶׁר־יִהְיֶ֥ה עָלָ֖יו שִׁכְבַת־זָ֑רַע וְכֻבַּ֥ס בַּמַּ֖יִם וְטָמֵ֥א עַד־הָעָֽרֶב׃ פ ");
INSERT INTO hbo_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","וְאִשָּׁ֕ה אֲשֶׁ֨ר יִשְׁכַּ֥ב אִ֛ישׁ אֹתָ֖הּ שִׁכְבַת־זָ֑רַע וְרָחֲצ֣וּ בַמַּ֔יִם וְטָמְא֖וּ עַד־הָעָֽרֶב׃ ");
INSERT INTO hbo_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","וְאִשָּׁה֙ כִּֽי־תִהְיֶ֣ה זָבָ֔ה דָּ֛ם יִהְיֶ֥ה זֹבָ֖הּ בִּבְשָׂרָ֑הּ שִׁבְעַ֤ת יָמִים֙ תִּהְיֶ֣ה בְנִדָּתָ֔הּ וְכָל־הַנֹּגֵ֥עַ בָּ֖הּ יִטְמָ֥א עַד־הָעָֽרֶב׃ ");
INSERT INTO hbo_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","וְכֹל֩ אֲשֶׁ֨ר תִּשְׁכַּ֥ב עָלָ֛יו בְּנִדָּתָ֖הּ יִטְמָ֑א וְכֹ֛ל אֲשֶׁר־תֵּשֵׁ֥ב עָלָ֖יו יִטְמָֽא׃ ");
INSERT INTO hbo_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","וְכָל־הַנֹּגֵ֖עַ בְּמִשְׁכָּבָ֑הּ יְכַבֵּ֧ס בְּגָדָ֛יו וְרָחַ֥ץ בַּמַּ֖יִם וְטָמֵ֥א עַד־הָעָֽרֶב׃ ");
INSERT INTO hbo_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","וְכָל־הַנֹּגֵ֔עַ בְּכָל־כְּלִ֖י אֲשֶׁר־תֵּשֵׁ֣ב עָלָ֑יו יְכַבֵּ֧ס בְּגָדָ֛יו וְרָחַ֥ץ בַּמַּ֖יִם וְטָמֵ֥א עַד־הָעָֽרֶב׃ ");
INSERT INTO hbo_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","וְאִ֨ם עַֽל־הַמִּשְׁכָּ֜ב ה֗וּא אֹ֧ו עַֽל־הַכְּלִ֛י אֲשֶׁר־הִ֥וא יֹשֶֽׁבֶת־עָלָ֖יו בְּנָגְעֹו־בֹ֑ו יִטְמָ֖א עַד־הָעָֽרֶב׃ ");
INSERT INTO hbo_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","וְאִ֡ם שָׁכֹב֩ יִשְׁכַּ֨ב אִ֜ישׁ אֹתָ֗הּ וּתְהִ֤י נִדָּתָהּ֙ עָלָ֔יו וְטָמֵ֖א שִׁבְעַ֣ת יָמִ֑ים וְכָל־הַמִּשְׁכָּ֛ב אֲשֶׁר־יִשְׁכַּ֥ב עָלָ֖יו יִטְמָֽא׃ פ ");
INSERT INTO hbo_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","וְאִשָּׁ֡ה כִּֽי־יָזוּב֩ זֹ֨וב דָּמָ֜הּ יָמִ֣ים רַבִּ֗ים בְּלֹא֙ עֶת־נִדָּתָ֔הּ אֹ֥ו כִֽי־תָז֖וּב עַל־נִדָּתָ֑הּ כָּל־יְמֵ֞י זֹ֣וב טֻמְאָתָ֗הּ כִּימֵ֧י נִדָּתָ֛הּ תִּהְיֶ֖ה טְמֵאָ֥ה הִֽוא׃ ");
INSERT INTO hbo_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","כָּל־הַמִּשְׁכָּ֞ב אֲשֶׁר־תִּשְׁכַּ֤ב עָלָיו֙ כָּל־יְמֵ֣י זֹובָ֔הּ כְּמִשְׁכַּ֥ב נִדָּתָ֖הּ יִֽהְיֶה־לָּ֑הּ וְכָֽל־הַכְּלִי֙ אֲשֶׁ֣ר תֵּשֵׁ֣ב עָלָ֔יו טָמֵ֣א יִהְיֶ֔ה כְּטֻמְאַ֖ת נִדָּתָֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","וְכָל־הַנֹּוגֵ֥עַ בָּ֖ם יִטְמָ֑א וְכִבֶּ֧ס בְּגָדָ֛יו וְרָחַ֥ץ בַּמַּ֖יִם וְטָמֵ֥א עַד־הָעָֽרֶב׃ ");
INSERT INTO hbo_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","וְאִֽם־טָהֲרָ֖ה מִזֹּובָ֑הּ וְסָ֥פְרָה לָּ֛הּ שִׁבְעַ֥ת יָמִ֖ים וְאַחַ֥ר תִּטְהָֽר׃ ");
INSERT INTO hbo_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","וּבַיֹּ֣ום הַשְּׁמִינִ֗י תִּֽקַּֽח־לָהּ֙ שְׁתֵּ֣י תֹרִ֔ים אֹ֥ו שְׁנֵ֖י בְּנֵ֣י יֹונָ֑ה וְהֵבִיאָ֤ה אֹותָם֙ אֶל־הַכֹּהֵ֔ן אֶל־פֶּ֖תַח אֹ֥הֶל מֹועֵֽד׃ ");
INSERT INTO hbo_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","וְעָשָׂ֤ה הַכֹּהֵן֙ אֶת־הָאֶחָ֣ד חַטָּ֔את וְאֶת־הָאֶחָ֖ד עֹלָ֑ה וְכִפֶּ֨ר עָלֶ֤יהָ הַכֹּהֵן֙ לִפְנֵ֣י יְהוָ֔ה מִזֹּ֖וב טֻמְאָתָֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","וְהִזַּרְתֶּ֥ם אֶת־בְּנֵי־יִשְׂרָאֵ֖ל מִטֻּמְאָתָ֑ם וְלֹ֤א יָמֻ֙תוּ֙ בְּטֻמְאָתָ֔ם בְּטַמְּאָ֥ם אֶת־מִשְׁכָּנִ֖י אֲשֶׁ֥ר בְּתֹוכָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","זֹ֥את תֹּורַ֖ת הַזָּ֑ב וַאֲשֶׁ֨ר תֵּצֵ֥א מִמֶּ֛נּוּ שִׁכְבַת־זֶ֖רַע לְטָמְאָה־בָֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","וְהַדָּוָה֙ בְּנִדָּתָ֔הּ וְהַזָּב֙ אֶת־זֹובֹ֔ו לַזָּכָ֖ר וְלַנְּקֵבָ֑ה וּלְאִ֕ישׁ אֲשֶׁ֥ר יִשְׁכַּ֖ב עִם־טְמֵאָֽה׃ פ ");
INSERT INTO hbo_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","וַיְדַבֵּ֤ר יְהוָה֙ אֶל־מֹשֶׁ֔ה אַחֲרֵ֣י מֹ֔ות שְׁנֵ֖י בְּנֵ֣י אַהֲרֹ֑ן בְּקָרְבָתָ֥ם לִפְנֵי־יְהוָ֖ה וַיָּמֻֽתוּ׃ ");
INSERT INTO hbo_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","וַיֹּ֨אמֶר יְהוָ֜ה אֶל־מֹשֶׁ֗ה דַּבֵּר֮ אֶל־אַהֲרֹ֣ן אָחִיךָ֒ וְאַל־יָבֹ֤א בְכָל־עֵת֙ אֶל־הַקֹּ֔דֶשׁ מִבֵּ֖ית לַפָּרֹ֑כֶת אֶל־פְּנֵ֨י הַכַּפֹּ֜רֶת אֲשֶׁ֤ר עַל־הָאָרֹן֙ וְלֹ֣א יָמ֔וּת כִּ֚י בֶּֽעָנָ֔ן אֵרָאֶ֖ה עַל־הַכַּפֹּֽרֶת׃ ");
INSERT INTO hbo_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","בְּזֹ֛את יָבֹ֥א אַהֲרֹ֖ן אֶל־הַקֹּ֑דֶשׁ בְּפַ֧ר בֶּן־בָּקָ֛ר לְחַטָּ֖את וְאַ֥יִל לְעֹלָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","כְּתֹֽנֶת־בַּ֨ד קֹ֜דֶשׁ יִלְבָּ֗שׁ וּמִֽכְנְסֵי־בַד֮ יִהְי֣וּ עַל־בְּשָׂרֹו֒ וּבְאַבְנֵ֥ט בַּד֙ יַחְגֹּ֔ר וּבְמִצְנֶ֥פֶת בַּ֖ד יִצְנֹ֑ף בִּגְדֵי־קֹ֣דֶשׁ הֵ֔ם וְרָחַ֥ץ בַּמַּ֛יִם אֶת־בְּשָׂרֹ֖ו וּלְבֵשָֽׁם׃ ");
INSERT INTO hbo_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","וּמֵאֵ֗ת עֲדַת֙ בְּנֵ֣י יִשְׂרָאֵ֔ל יִקַּ֛ח שְׁנֵֽי־שְׂעִירֵ֥י עִזִּ֖ים לְחַטָּ֑את וְאַ֥יִל אֶחָ֖ד לְעֹלָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","וְהִקְרִ֧יב אַהֲרֹ֛ן אֶת־פַּ֥ר הַחַטָּ֖את אֲשֶׁר־לֹ֑ו וְכִפֶּ֥ר בַּעֲדֹ֖ו וּבְעַ֥ד בֵּיתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","וְלָקַ֖ח אֶת־שְׁנֵ֣י הַשְּׂעִירִ֑ם וְהֶעֱמִ֤יד אֹתָם֙ לִפְנֵ֣י יְהוָ֔ה פֶּ֖תַח אֹ֥הֶל מֹועֵֽד׃ ");
INSERT INTO hbo_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","וְנָתַ֧ן אַהֲרֹ֛ן עַל־שְׁנֵ֥י הַשְּׂעִירִ֖ם גֹּורָלֹ֑ות גֹּורָ֤ל אֶחָד֙ לַיהוָ֔ה וְגֹורָ֥ל אֶחָ֖ד לַעֲזָאזֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","וְהִקְרִ֤יב אַהֲרֹן֙ אֶת־הַשָּׂעִ֔יר אֲשֶׁ֨ר עָלָ֥ה עָלָ֛יו הַגֹּורָ֖ל לַיהוָ֑ה וְעָשָׂ֖הוּ חַטָּֽאת׃ ");
INSERT INTO hbo_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","וְהַשָּׂעִ֗יר אֲשֶׁר֩ עָלָ֨ה עָלָ֤יו הַגֹּורָל֙ לַעֲזָאזֵ֔ל יָֽעֳמַד־חַ֛י לִפְנֵ֥י יְהוָ֖ה לְכַפֵּ֣ר עָלָ֑יו לְשַׁלַּ֥ח אֹתֹ֛ו לַעֲזָאזֵ֖ל הַמִּדְבָּֽרָה׃ ");
INSERT INTO hbo_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","וְהִקְרִ֨יב אַהֲרֹ֜ן אֶת־פַּ֤ר הַֽחַטָּאת֙ אֲשֶׁר־לֹ֔ו וְכִפֶּ֥ר בַּֽעֲדֹ֖ו וּבְעַ֣ד בֵּיתֹ֑ו וְשָׁחַ֛ט אֶת־פַּ֥ר הֽ͏ַחַטָּ֖את אֲשֶׁר־לֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","וְלָקַ֣ח מְלֹֽא־הַ֠מַּחְתָּה גַּֽחֲלֵי־אֵ֞שׁ מֵעַ֤ל הַמִּזְבֵּ֙חַ֙ מִלִּפְנֵ֣י יְהוָ֔ה וּמְלֹ֣א חָפְנָ֔יו קְטֹ֥רֶת סַמִּ֖ים דַּקָּ֑ה וְהֵבִ֖יא מִבֵּ֥ית לַפָּרֹֽכֶת׃ ");
INSERT INTO hbo_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","וְנָתַ֧ן אֶֽת־הַקְּטֹ֛רֶת עַל־הָאֵ֖שׁ לִפְנֵ֣י יְהוָ֑ה וְכִסָּ֣ה ׀ עֲנַ֣ן הַקְּטֹ֗רֶת אֶת־הַכַּפֹּ֛רֶת אֲשֶׁ֥ר עַל־הָעֵד֖וּת וְלֹ֥א יָמֽוּת׃ ");
INSERT INTO hbo_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","וְלָקַח֙ מִדַּ֣ם הַפָּ֔ר וְהִזָּ֧ה בְאֶצְבָּעֹ֛ו עַל־פְּנֵ֥י הַכַּפֹּ֖רֶת קֵ֑דְמָה וְלִפְנֵ֣י הַכַּפֹּ֗רֶת יַזֶּ֧ה שֶֽׁבַע־פְּעָמִ֛ים מִן־הַדָּ֖ם בְּאֶצְבָּעֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","וְשָׁחַ֞ט אֶת־שְׂעִ֤יר הַֽחַטָּאת֙ אֲשֶׁ֣ר לָעָ֔ם וְהֵבִיא֙ אֶת־דָּמֹ֔ו אֶל־מִבֵּ֖ית לַפָּרֹ֑כֶת וְעָשָׂ֣ה אֶת־דָּמֹ֗ו כַּאֲשֶׁ֤ר עָשָׂה֙ לְדַ֣ם הַפָּ֔ר וְהִזָּ֥ה אֹתֹ֛ו עַל־הַכַּפֹּ֖רֶת וְלִפְנֵ֥י הַכַּפֹּֽרֶת׃ ");
INSERT INTO hbo_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","וְכִפֶּ֣ר עַל־הַקֹּ֗דֶשׁ מִטֻּמְאֹת֙ בְּנֵ֣י יִשְׂרָאֵ֔ל וּמִפִּשְׁעֵיהֶ֖ם לְכָל־חַטֹּאתָ֑ם וְכֵ֤ן יַעֲשֶׂה֙ לְאֹ֣הֶל מֹועֵ֔ד הַשֹּׁכֵ֣ן אִתָּ֔ם בְּתֹ֖וךְ טֻמְאֹתָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","וְכָל־אָדָ֞ם לֹא־יִהְיֶ֣ה ׀ בְּאֹ֣הֶל מֹועֵ֗ד בְּבֹאֹ֛ו לְכַפֵּ֥ר בַּקֹּ֖דֶשׁ עַד־צֵאתֹ֑ו וְכִפֶּ֤ר בַּעֲדֹו֙ וּבְעַ֣ד בֵּיתֹ֔ו וּבְעַ֖ד כָּל־קְהַ֥ל יִשְׂרָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","וְיָצָ֗א אֶל־הַמִּזְבֵּ֛חַ אֲשֶׁ֥ר לִפְנֵֽי־יְהוָ֖ה וְכִפֶּ֣ר עָלָ֑יו וְלָקַ֞ח מִדַּ֤ם הַפָּר֙ וּמִדַּ֣ם הַשָּׂעִ֔יר וְנָתַ֛ן עַל־קַרְנֹ֥ות הַמִּזְבֵּ֖חַ סָבִֽיב׃ ");
INSERT INTO hbo_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","וְהִזָּ֨ה עָלָ֧יו מִן־הַדָּ֛ם בְּאֶצְבָּעֹ֖ו שֶׁ֣בַע פְּעָמִ֑ים וְטִהֲרֹ֣ו וְקִדְּשֹׁ֔ו מִטֻּמְאֹ֖ת בְּנֵ֥י יִשְׂרָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","וְכִלָּה֙ מִכַּפֵּ֣ר אֶת־הַקֹּ֔דֶשׁ וְאֶת־אֹ֥הֶל מֹועֵ֖ד וְאֶת־הַמִּזְבֵּ֑חַ וְהִקְרִ֖יב אֶת־הַשָּׂעִ֥יר הֶחָֽי׃ ");
INSERT INTO hbo_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","וְסָמַ֨ךְ אַהֲרֹ֜ן אֶת־שְׁתֵּ֣י *יָדֹו (יָדָ֗יו) עַ֨ל רֹ֣אשׁ הַשָּׂעִיר֮ הַחַי֒ וְהִתְוַדָּ֣ה עָלָ֗יו אֶת־כָּל־עֲוֹנֹת֙ בְּנֵ֣י יִשְׂרָאֵ֔ל וְאֶת־כָּל־פִּשְׁעֵיהֶ֖ם לְכָל־חַטֹּאתָ֑ם וְנָתַ֤ן אֹתָם֙ עַל־רֹ֣אשׁ הַשָּׂעִ֔יר וְשִׁלַּ֛ח בְּיַד־אִ֥ישׁ עִתִּ֖י הַמִּדְבָּֽרָה׃ ");
INSERT INTO hbo_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","וְנָשָׂ֨א הַשָּׂעִ֥יר עָלָ֛יו אֶת־כָּל־עֲוֹנֹתָ֖ם אֶל־אֶ֣רֶץ גְּזֵרָ֑ה וְשִׁלַּ֥ח אֶת־הַשָּׂעִ֖יר בַּמִּדְבָּֽר׃ ");
INSERT INTO hbo_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","וּבָ֤א אַהֲרֹן֙ אֶל־אֹ֣הֶל מֹועֵ֔ד וּפָשַׁט֙ אֶת־בִּגְדֵ֣י הַבָּ֔ד אֲשֶׁ֥ר לָבַ֖שׁ בְּבֹאֹ֣ו אֶל־הַקֹּ֑דֶשׁ וְהִנִּיחָ֖ם שָֽׁם׃ ");
INSERT INTO hbo_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","וְרָחַ֨ץ אֶת־בְּשָׂרֹ֤ו בַמַּ֙יִם֙ בְּמָקֹ֣ום קָדֹ֔ושׁ וְלָבַ֖שׁ אֶת־בְּגָדָ֑יו וְיָצָ֗א וְעָשָׂ֤ה אֶת־עֹֽלָתֹו֙ וְאֶת־עֹלַ֣ת הָעָ֔ם וְכִפֶּ֥ר בַּעֲדֹ֖ו וּבְעַ֥ד הָעָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","וְאֵ֛ת חֵ֥לֶב הַֽחַטָּ֖את יַקְטִ֥יר הַמִּזְבֵּֽחָה׃ ");
INSERT INTO hbo_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","וְהַֽמְשַׁלֵּ֤חַ אֶת־הַשָּׂעִיר֙ לַֽעֲזָאזֵ֔ל יְכַבֵּ֣ס בְּגָדָ֔יו וְרָחַ֥ץ אֶת־בְּשָׂרֹ֖ו בַּמָּ֑יִם וְאַחֲרֵי־כֵ֖ן יָבֹ֥וא אֶל־הַֽמַּחֲנֶֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","וְאֵת֩ פַּ֨ר הֽ͏ַחַטָּ֜את וְאֵ֣ת ׀ שְׂעִ֣יר הַֽחַטָּ֗את אֲשֶׁ֨ר הוּבָ֤א אֶת־דָּמָם֙ לְכַפֵּ֣ר בַּקֹּ֔דֶשׁ יֹוצִ֖יא אֶל־מִח֣וּץ לַֽמַּחֲנֶ֑ה וְשָׂרְפ֣וּ בָאֵ֔שׁ אֶת־עֹרֹתָ֥ם וְאֶת־בְּשָׂרָ֖ם וְאֶת־פִּרְשָֽׁם׃ ");
INSERT INTO hbo_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","וְהַשֹּׂרֵ֣ף אֹתָ֔ם יְכַבֵּ֣ס בְּגָדָ֔יו וְרָחַ֥ץ אֶת־בְּשָׂרֹ֖ו בַּמָּ֑יִם וְאַחֲרֵי־כֵ֖ן יָבֹ֥וא אֶל־הַֽמַּחֲנֶֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","וְהָיְתָ֥ה לָכֶ֖ם לְחֻקַּ֣ת עֹולָ֑ם בַּחֹ֣דֶשׁ הַ֠שְּׁבִיעִי בֶּֽעָשֹׂ֨ור לַחֹ֜דֶשׁ תְּעַנּ֣וּ אֶת־נַפְשֹֽׁתֵיכֶ֗ם וְכָל־מְלָאכָה֙ לֹ֣א תַעֲשׂ֔וּ הָֽאֶזְרָ֔ח וְהַגֵּ֖ר הַגָּ֥ר בְּתֹוכְכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","כִּֽי־בַיֹּ֥ום הַזֶּ֛ה יְכַפֵּ֥ר עֲלֵיכֶ֖ם לְטַהֵ֣ר אֶתְכֶ֑ם מִכֹּל֙ חַטֹּ֣אתֵיכֶ֔ם לִפְנֵ֥י יְהוָ֖ה תִּטְהָֽרוּ׃ ");
INSERT INTO hbo_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","שַׁבַּ֨ת שַׁבָּתֹ֥ון הִיא֙ לָכֶ֔ם וְעִנִּיתֶ֖ם אֶת־נַפְשֹׁתֵיכֶ֑ם חֻקַּ֖ת עֹולָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","וְכִפֶּ֨ר הַכֹּהֵ֜ן אֲשֶׁר־יִמְשַׁ֣ח אֹתֹ֗ו וַאֲשֶׁ֤ר יְמַלֵּא֙ אֶת־יָדֹ֔ו לְכַהֵ֖ן תַּ֣חַת אָבִ֑יו וְלָבַ֛שׁ אֶת־בִּגְדֵ֥י הַבָּ֖ד בִּגְדֵ֥י הַקֹּֽדֶשׁ׃ ");
INSERT INTO hbo_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","וְכִפֶּר֙ אֶת־מִקְדַּ֣שׁ הַקֹּ֔דֶשׁ וְאֶת־אֹ֧הֶל מֹועֵ֛ד וְאֶת־הַמִּזְבֵּ֖חַ יְכַפֵּ֑ר וְעַ֧ל הַכֹּהֲנִ֛ים וְעַל־כָּל־עַ֥ם הַקָּהָ֖ל יְכַפֵּֽר׃ ");
INSERT INTO hbo_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","וְהָֽיְתָה־זֹּ֨את לָכֶ֜ם לְחֻקַּ֣ת עֹולָ֗ם לְכַפֵּ֞ר עַל־בְּנֵ֤י יִשְׂרָאֵל֙ מִכָּל־חַטֹּאתָ֔ם אַחַ֖ת בַּשָּׁנָ֑ה וַיַּ֕עַשׂ כַּאֲשֶׁ֛ר צִוָּ֥ה יְהוָ֖ה אֶת־מֹשֶֽׁה׃ פ ");
INSERT INTO hbo_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","דַּבֵּ֨ר אֶֽל־אַהֲרֹ֜ן וְאֶל־בָּנָ֗יו וְאֶל֙ כָּל־בְּנֵ֣י יִשְׂרָאֵ֔ל וְאָמַרְתָּ֖ אֲלֵיהֶ֑ם זֶ֣ה הַדָּבָ֔ר אֲשֶׁר־צִוָּ֥ה יְהוָ֖ה לֵאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","אִ֥ישׁ אִישׁ֙ מִבֵּ֣ית יִשְׂרָאֵ֔ל אֲשֶׁ֨ר יִשְׁחַ֜ט שֹׁ֥ור אֹו־כֶ֛שֶׂב אֹו־עֵ֖ז בַּֽמַּחֲנֶ֑ה אֹ֚ו אֲשֶׁ֣ר יִשְׁחַ֔ט מִח֖וּץ לַֽמַּחֲנֶֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","וְאֶל־פֶּ֜תַח אֹ֣הֶל מֹועֵד֮ לֹ֣א הֱבִיאֹו֒ לְהַקְרִ֤יב קָרְבָּן֙ לַֽיהוָ֔ה לִפְנֵ֖י מִשְׁכַּ֣ן יְהוָ֑ה דָּ֣ם יֵחָשֵׁ֞ב לָאִ֤ישׁ הַהוּא֙ דָּ֣ם שָׁפָ֔ךְ וְנִכְרַ֛ת הָאִ֥ישׁ הַה֖וּא מִקֶּ֥רֶב עַמֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","לְמַעַן֩ אֲשֶׁ֨ר יָבִ֜יאוּ בְּנֵ֣י יִשְׂרָאֵ֗ל אֶֽת־זִבְחֵיהֶם֮ אֲשֶׁ֣ר הֵ֣ם זֹבְחִים֮ עַל־פְּנֵ֣י הַשָּׂדֶה֒ וֽ͏ֶהֱבִיאֻ֣ם לַֽיהוָ֗ה אֶל־פֶּ֛תַח אֹ֥הֶל מֹועֵ֖ד אֶל־הַכֹּהֵ֑ן וְזָ֨בְח֜וּ זִבְחֵ֧י שְׁלָמִ֛ים לַֽיהוָ֖ה אֹותָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","וְזָרַ֨ק הַכֹּהֵ֤ן אֶת־הַדָּם֙ עַל־מִזְבַּ֣ח יְהוָ֔ה פֶּ֖תַח אֹ֣הֶל מֹועֵ֑ד וְהִקְטִ֣יר הַחֵ֔לֶב לְרֵ֥יחַ נִיחֹ֖חַ לַיהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","וְלֹא־יִזְבְּח֥וּ עֹוד֙ אֶת־זִבְחֵיהֶ֔ם לַשְּׂעִירִ֕ם אֲשֶׁ֛ר הֵ֥ם זֹנִ֖ים אַחֲרֵיהֶ֑ם חֻקַּ֥ת עֹולָ֛ם תִּֽהְיֶה־זֹּ֥את לָהֶ֖ם לְדֹרֹתָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","וַאֲלֵהֶ֣ם תֹּאמַ֔ר אִ֥ישׁ אִישׁ֙ מִבֵּ֣ית יִשְׂרָאֵ֔ל וּמִן־הַגֵּ֖ר אֲשֶׁר־יָג֣וּר בְּתֹוכָ֑ם אֲשֶׁר־יַעֲלֶ֥ה עֹלָ֖ה אֹו־זָֽבַח׃ ");
INSERT INTO hbo_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","וְאֶל־פֶּ֜תַח אֹ֤הֶל מֹועֵד֙ לֹ֣א יְבִיאֶ֔נּוּ לַעֲשֹׂ֥ות אֹתֹ֖ו לַיהוָ֑ה וְנִכְרַ֛ת הָאִ֥ישׁ הַה֖וּא מֵעַמָּֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","וְאִ֨ישׁ אִ֜ישׁ מִבֵּ֣ית יִשְׂרָאֵ֗ל וּמִן־הַגֵּר֙ הַגָּ֣ר בְּתֹוכָ֔ם אֲשֶׁ֥ר יֹאכַ֖ל כָּל־דָּ֑ם וְנָתַתִּ֣י פָנַ֗י בַּנֶּ֙פֶשׁ֙ הָאֹכֶ֣לֶת אֶת־הַדָּ֔ם וְהִכְרַתִּ֥י אֹתָ֖הּ מִקֶּ֥רֶב עַמָּֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","כִּ֣י נֶ֣פֶשׁ הַבָּשָׂר֮ בַּדָּ֣ם הִוא֒ וַאֲנִ֞י נְתַתִּ֤יו לָכֶם֙ עַל־הַמִּזְבֵּ֔חַ לְכַפֵּ֖ר עַל־נַפְשֹׁתֵיכֶ֑ם כִּֽי־הַדָּ֥ם ה֖וּא בַּנֶּ֥פֶשׁ יְכַפֵּֽר׃ ");
INSERT INTO hbo_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","עַל־כֵּ֤ן אָמַ֙רְתִּי֙ לִבְנֵ֣י יִשְׂרָאֵ֔ל כָּל־נֶ֥פֶשׁ מִכֶּ֖ם לֹא־תֹ֣אכַל דָּ֑ם וְהַגֵּ֛ר הַגָּ֥ר בְּתֹוכְכֶ֖ם לֹא־יֹ֥אכַל דָּֽם׃ ס ");
INSERT INTO hbo_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","וְאִ֨ישׁ אִ֜ישׁ מִבְּנֵ֣י יִשְׂרָאֵ֗ל וּמִן־הַגֵּר֙ הַגָּ֣ר בְּתֹוכָ֔ם אֲשֶׁ֨ר יָצ֜וּד צֵ֥יד חַיָּ֛ה אֹו־עֹ֖וף אֲשֶׁ֣ר יֵאָכֵ֑ל וְשָׁפַךְ֙ אֶת־דָּמֹ֔ו וְכִסָּ֖הוּ בֶּעָפָֽר׃ ");
INSERT INTO hbo_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","כִּֽי־נֶ֣פֶשׁ כָּל־בָּשָׂ֗ר דָּמֹ֣ו בְנַפְשֹׁו֮ הוּא֒ וָֽאֹמַר֙ לִבְנֵ֣י יִשְׂרָאֵ֔ל דַּ֥ם כָּל־בָּשָׂ֖ר לֹ֣א תֹאכֵ֑לוּ כִּ֣י נֶ֤פֶשׁ כָּל־בָּשָׂר֙ דָּמֹ֣ו הִ֔וא כָּל־אֹכְלָ֖יו יִכָּרֵֽת׃ ");
INSERT INTO hbo_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","וְכָל־נֶ֗פֶשׁ אֲשֶׁ֨ר תֹּאכַ֤ל נְבֵלָה֙ וּטְרֵפָ֔ה בָּאֶזְרָ֖ח וּבַגֵּ֑ר וְכִבֶּ֨ס בְּגָדָ֜יו וְרָחַ֥ץ בַּמַּ֛יִם וְטָמֵ֥א עַד־הָעֶ֖רֶב וְטָהֵֽר׃ ");
INSERT INTO hbo_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","וְאִם֙ לֹ֣א יְכַבֵּ֔ס וּבְשָׂרֹ֖ו לֹ֣א יִרְחָ֑ץ וְנָשָׂ֖א עֲוֹנֹֽו׃ פ ");
INSERT INTO hbo_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","דַּבֵּר֙ אֶל־בְּנֵ֣י יִשְׂרָאֵ֔ל וְאָמַרְתָּ֖ אֲלֵהֶ֑ם אֲנִ֖י יְהוָ֥ה אֱלֹהֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","כְּמַעֲשֵׂ֧ה אֶֽרֶץ־מִצְרַ֛יִם אֲשֶׁ֥ר יְשַׁבְתֶּם־בָּ֖הּ לֹ֣א תַעֲשׂ֑וּ וּכְמַעֲשֵׂ֣ה אֶֽרֶץ־כְּנַ֡עַן אֲשֶׁ֣ר אֲנִי֩ מֵבִ֨יא אֶתְכֶ֥ם שָׁ֙מָּה֙ לֹ֣א תַעֲשׂ֔וּ וּבְחֻקֹּתֵיהֶ֖ם לֹ֥א תֵלֵֽכוּ׃ ");
INSERT INTO hbo_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","אֶת־מִשְׁפָּטַ֧י תַּעֲשׂ֛וּ וְאֶת־חֻקֹּתַ֥י תִּשְׁמְר֖וּ לָלֶ֣כֶת בָּהֶ֑ם אֲנִ֖י יְהוָ֥ה אֱלֹהֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","וּשְׁמַרְתֶּ֤ם אֶת־חֻקֹּתַי֙ וְאֶת־מִשְׁפָּטַ֔י אֲשֶׁ֨ר יַעֲשֶׂ֥ה אֹתָ֛ם הָאָדָ֖ם וָחַ֣י בָּהֶ֑ם אֲנִ֖י יְהוָֽה׃ ס ");
INSERT INTO hbo_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","אִ֥ישׁ אִישׁ֙ אֶל־כָּל־שְׁאֵ֣ר בְּשָׂרֹ֔ו לֹ֥א תִקְרְב֖וּ לְגַלֹּ֣ות עֶרְוָ֑ה אֲנִ֖י יְהוָֽה׃ ס ");
INSERT INTO hbo_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","עֶרְוַ֥ת אָבִ֛יךָ וְעֶרְוַ֥ת אִמְּךָ֖ לֹ֣א תְגַלֵּ֑ה אִמְּךָ֣ הִ֔וא לֹ֥א תְגַלֶּ֖ה עֶרְוָתָֽהּ׃ ס ");
INSERT INTO hbo_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","עֶרְוַ֥ת אֵֽשֶׁת־אָבִ֖יךָ לֹ֣א תְגַלֵּ֑ה עֶרְוַ֥ת אָבִ֖יךָ הִֽוא׃ ס ");
INSERT INTO hbo_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","עֶרְוַ֨ת אֲחֹֽותְךָ֤ בַת־אָבִ֙יךָ֙ אֹ֣ו בַת־אִמֶּ֔ךָ מֹולֶ֣דֶת בַּ֔יִת אֹ֖ו מֹולֶ֣דֶת ח֑וּץ לֹ֥א תְגַלֶּ֖ה עֶרְוָתָֽן׃ ס ");
INSERT INTO hbo_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","עֶרְוַ֤ת בַּת־בִּנְךָ֙ אֹ֣ו בַֽת־בִּתְּךָ֔ לֹ֥א תְגַלֶּ֖ה עֶרְוָתָ֑ן כִּ֥י עֶרְוָתְךָ֖ הֵֽנָּה׃ ס ");
INSERT INTO hbo_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","עֶרְוַ֨ת בַּת־אֵ֤שֶׁת אָבִ֙יךָ֙ מֹולֶ֣דֶת אָבִ֔יךָ אֲחֹותְךָ֖ הִ֑וא לֹ֥א תְגַלֶּ֖ה עֶרְוָתָֽהּ׃ ס ");
INSERT INTO hbo_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","עֶרְוַ֥ת אֲחֹות־אָבִ֖יךָ לֹ֣א תְגַלֵּ֑ה שְׁאֵ֥ר אָבִ֖יךָ הִֽוא׃ ס ");
INSERT INTO hbo_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","עֶרְוַ֥ת אֲחֹֽות־אִמְּךָ֖ לֹ֣א תְגַלֵּ֑ה כִּֽי־שְׁאֵ֥ר אִמְּךָ֖ הִֽוא׃ ס ");
INSERT INTO hbo_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","עֶרְוַ֥ת אֲחִֽי־אָבִ֖יךָ לֹ֣א תְגַלֵּ֑ה אֶל־אִשְׁתֹּו֙ לֹ֣א תִקְרָ֔ב דֹּדָֽתְךָ֖ הִֽוא׃ ס ");
INSERT INTO hbo_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","עֶרְוַ֥ת כַּלָּֽתְךָ֖ לֹ֣א תְגַלֵּ֑ה אֵ֤שֶׁת בִּנְךָ֙ הִ֔וא לֹ֥א תְגַלֶּ֖ה עֶרְוָתָֽהּ׃ ס ");
INSERT INTO hbo_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","עֶרְוַ֥ת אֵֽשֶׁת־אָחִ֖יךָ לֹ֣א תְגַלֵּ֑ה עֶרְוַ֥ת אָחִ֖יךָ הִֽוא׃ ס ");
INSERT INTO hbo_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","עֶרְוַ֥ת אִשָּׁ֛ה וּבִתָּ֖הּ לֹ֣א תְגַלֵּ֑ה אֶֽת־בַּת־בְּנָ֞הּ וְאֶת־בַּת־בִּתָּ֗הּ לֹ֤א תִקַּח֙ לְגַלֹּ֣ות עֶרְוָתָ֔הּ שַׁאֲרָ֥ה הֵ֖נָּה זִמָּ֥ה הִֽוא ");
INSERT INTO hbo_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","וְאִשָּׁ֥ה אֶל־אֲחֹתָ֖הּ לֹ֣א תִקָּ֑ח לִצְרֹ֗ר לְגַלֹּ֧ות עֶרְוָתָ֛הּ עָלֶ֖יהָ בְּחַיֶּֽיהָ׃ ");
INSERT INTO hbo_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","וְאֶל־אִשָּׁ֖ה בְּנִדַּ֣ת טֻמְאָתָ֑הּ לֹ֣א תִקְרַ֔ב לְגַלֹּ֖ות עֶרְוָתָֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","וְאֶל־אֵ֙שֶׁת֙ עֲמִֽיתְךָ֔ לֹא־תִתֵּ֥ן שְׁכָבְתְּךָ֖ לְזָ֑רַע לְטָמְאָה־בָֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","וּמִֽזַּרְעֲךָ֥ לֹא־תִתֵּ֖ן לְהַעֲבִ֣יר לַמֹּ֑לֶךְ וְלֹ֧א תְחַלֵּ֛ל אֶת־שֵׁ֥ם אֱלֹהֶ֖יךָ אֲנִ֥י יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","וְאֶ֨ת־זָכָ֔ר לֹ֥א תִשְׁכַּ֖ב מִשְׁכְּבֵ֣י אִשָּׁ֑ה תֹּועֵבָ֖ה הִֽוא׃ ");
INSERT INTO hbo_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","וּבְכָל־בְּהֵמָ֛ה לֹא־תִתֵּ֥ן שְׁכָבְתְּךָ֖ לְטָמְאָה־בָ֑הּ וְאִשָּׁ֗ה לֹֽא־תַעֲמֹ֞ד לִפְנֵ֧י בְהֵמָ֛ה לְרִבְעָ֖הּ תֶּ֥בֶל הֽוּא׃ ");
INSERT INTO hbo_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","אַל־תִּֽטַּמְּא֖וּ בְּכָל־אֵ֑לֶּה כִּ֤י בְכָל־אֵ֙לֶּה֙ נִטְמְא֣וּ הַגֹּויִ֔ם אֲשֶׁר־אֲנִ֥י מְשַׁלֵּ֖חַ מִפְּנֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","וַתִּטְמָ֣א הָאָ֔רֶץ וָאֶפְקֹ֥ד עֲוֹנָ֖הּ עָלֶ֑יהָ וַתָּקִ֥א הָאָ֖רֶץ אֶת־יֹשְׁבֶֽיהָ׃ ");
INSERT INTO hbo_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","וּשְׁמַרְתֶּ֣ם אַתֶּ֗ם אֶת־חֻקֹּתַי֙ וְאֶת־מִשְׁפָּטַ֔י וְלֹ֣א תַעֲשׂ֔וּ מִכֹּ֥ל הַתֹּועֵבֹ֖ת הָאֵ֑לֶּה הָֽאֶזְרָ֔ח וְהַגֵּ֖ר הַגָּ֥ר בְּתֹוכְכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","כִּ֚י אֶת־כָּל־הַתֹּועֵבֹ֣ת הָאֵ֔ל עָשׂ֥וּ אַנְשֵֽׁי־הָאָ֖רֶץ אֲשֶׁ֣ר לִפְנֵיכֶ֑ם וַתִּטְמָ֖א הָאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","וְלֹֽא־תָקִ֤יא הָאָ֙רֶץ֙ אֶתְכֶ֔ם בְּטַֽמַּאֲכֶ֖ם אֹתָ֑הּ כַּאֲשֶׁ֥ר קָאָ֛ה אֶת־הַגֹּ֖וי אֲשֶׁ֥ר לִפְנֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","כִּ֚י כָּל־אֲשֶׁ֣ר יַעֲשֶׂ֔ה מִכֹּ֥ל הַתֹּועֵבֹ֖ות הָאֵ֑לֶּה וְנִכְרְת֛וּ הַנְּפָשֹׁ֥ות הָעֹשֹׂ֖ת מִקֶּ֥רֶב עַמָּֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","וּשְׁמַרְתֶּ֣ם אֶת־מִשְׁמַרְתִּ֗י לְבִלְתִּ֨י עֲשֹׂ֜ות מֵחֻקֹּ֤ות הַתֹּֽועֵבֹת֙ אֲשֶׁ֣ר נַעֲשׂ֣וּ לִפְנֵיכֶ֔ם וְלֹ֥א תִֽטַּמְּא֖וּ בָּהֶ֑ם אֲנִ֖י יְהוָ֥ה אֱלֹהֵיכֶֽם׃ פ ");
INSERT INTO hbo_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר ");
INSERT INTO hbo_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","דַּבֵּ֞ר אֶל־כָּל־עֲדַ֧ת בְּנֵי־יִשְׂרָאֵ֛ל וְאָמַרְתָּ֥ אֲלֵהֶ֖ם קְדֹשִׁ֣ים תִּהְי֑וּ כִּ֣י קָדֹ֔ושׁ אֲנִ֖י יְהוָ֥ה אֱלֹהֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","אִ֣ישׁ אִמֹּ֤ו וְאָבִיו֙ תִּירָ֔אוּ וְאֶת־שַׁבְּתֹתַ֖י תִּשְׁמֹ֑רוּ אֲנִ֖י יְהוָ֥ה אֱלֹהֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","אַל־תִּפְנוּ֙ אֶל־הָ֣אֱלִילִ֔ים וֵֽאלֹהֵי֙ מַסֵּכָ֔ה לֹ֥א תַעֲשׂ֖וּ לָכֶ֑ם אֲנִ֖י יְהוָ֥ה אֱלֹהֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","וְכִ֧י תִזְבְּח֛וּ זֶ֥בַח שְׁלָמִ֖ים לַיהוָ֑ה לִֽרְצֹנְכֶ֖ם תִּזְבָּחֻֽהוּ׃ ");
INSERT INTO hbo_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","בְּיֹ֧ום זִבְחֲכֶ֛ם יֵאָכֵ֖ל וּמִֽמָּחֳרָ֑ת וְהַנֹּותָר֙ עַד־יֹ֣ום הַשְּׁלִישִׁ֔י בָּאֵ֖שׁ יִשָּׂרֵֽף׃ ");
INSERT INTO hbo_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","וְאִ֛ם הֵאָכֹ֥ל יֵאָכֵ֖ל בַּיֹּ֣ום הַשְּׁלִישִׁ֑י פִּגּ֥וּל ה֖וּא לֹ֥א יֵרָצֶֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","וְאֹֽכְלָיו֙ עֲוֹנֹ֣ו יִשָּׂ֔א כִּֽי־אֶת־קֹ֥דֶשׁ יְהוָ֖ה חִלֵּ֑ל וְנִכְרְתָ֛ה הַנֶּ֥פֶשׁ הַהִ֖וא מֵעַמֶּֽיהָ׃ ");
INSERT INTO hbo_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","וּֽבְקֻצְרְכֶם֙ אֶת־קְצִ֣יר אַרְצְכֶ֔ם לֹ֧א תְכַלֶּ֛ה פְּאַ֥ת שָׂדְךָ֖ לִקְצֹ֑ר וְלֶ֥קֶט קְצִֽירְךָ֖ לֹ֥א תְלַקֵּֽט׃ ");
INSERT INTO hbo_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","וְכַרְמְךָ֙ לֹ֣א תְעֹולֵ֔ל וּפֶ֥רֶט כַּרְמְךָ֖ לֹ֣א תְלַקֵּ֑ט לֶֽעָנִ֤י וְלַגֵּר֙ תַּעֲזֹ֣ב אֹתָ֔ם אֲנִ֖י יְהוָ֥ה אֱלֹהֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","לֹ֖א תִּגְנֹ֑בוּ וְלֹא־תְכַחֲשׁ֥וּ וְלֹֽא־תְשַׁקְּר֖וּ אִ֥ישׁ בַּעֲמִיתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","וְלֹֽא־תִשָּׁבְע֥וּ בִשְׁמִ֖י לַשָּׁ֑קֶר וְחִלַּלְתָּ֛ אֶת־שֵׁ֥ם אֱלֹהֶ֖יךָ אֲנִ֥י יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","לֹֽא־תַעֲשֹׁ֥ק אֶת־רֵֽעֲךָ֖ וְלֹ֣א תִגְזֹ֑ל לֹֽא־תָלִ֞ין פְּעֻלַּ֥ת שָׂכִ֛יר אִתְּךָ֖ עַד־בֹּֽקֶר׃ ");
INSERT INTO hbo_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","לֹא־תְקַלֵּ֣ל חֵרֵ֔שׁ וְלִפְנֵ֣י עִוֵּ֔ר לֹ֥א תִתֵּ֖ן מִכְשֹׁ֑ל וְיָרֵ֥אתָ מֵּאֱלֹהֶ֖יךָ אֲנִ֥י יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","לֹא־תַעֲשׂ֥וּ עָ֙וֶל֙ בַּמִּשְׁפָּ֔ט לֹא־תִשָּׂ֣א פְנֵי־דָ֔ל וְלֹ֥א תֶהְדַּ֖ר פְּנֵ֣י גָדֹ֑ול בְּצֶ֖דֶק תִּשְׁפֹּ֥ט עֲמִיתֶֽךָ׃ ");
INSERT INTO hbo_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","לֹא־תֵלֵ֤ךְ רָכִיל֙ בְּעַמֶּ֔יךָ לֹ֥א תַעֲמֹ֖ד עַל־דַּ֣ם רֵעֶ֑ךָ אֲנִ֖י יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","לֹֽא־תִשְׂנָ֥א אֶת־אָחִ֖יךָ בִּלְבָבֶ֑ךָ הֹוכֵ֤חַ תֹּוכִ֙יחַ֙ אֶת־עֲמִיתֶ֔ךָ וְלֹא־תִשָּׂ֥א עָלָ֖יו חֵֽטְא׃ ");
INSERT INTO hbo_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","לֹֽא־תִקֹּ֤ם וְלֹֽא־תִטֹּר֙ אֶת־בְּנֵ֣י עַמֶּ֔ךָ וְאָֽהַבְתָּ֥ לְרֵעֲךָ֖ כָּמֹ֑וךָ אֲנִ֖י יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","אֶֽת־חֻקֹּתַי֮ תִּשְׁמֹרוּ֒ בְּהֶמְתְּךָ֙ לֹא־תַרְבִּ֣יעַ כִּלְאַ֔יִם שָׂדְךָ֖ לֹא־תִזְרַ֣ע כִּלְאָ֑יִם וּבֶ֤גֶד כִּלְאַ֙יִם֙ שֽׁ͏ַעַטְנֵ֔ז לֹ֥א יַעֲלֶ֖ה עָלֶֽיךָ׃ פ ");
INSERT INTO hbo_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","וְ֠אִישׁ כִּֽי־יִשְׁכַּ֨ב אֶת־אִשָּׁ֜ה שִׁכְבַת־זֶ֗רַע וְהִ֤וא שִׁפְחָה֙ נֶחֱרֶ֣פֶת לְאִ֔ישׁ וְהָפְדֵּה֙ לֹ֣א נִפְדָּ֔תָה אֹ֥ו חֻפְשָׁ֖ה לֹ֣א נִתַּן־לָ֑הּ בִּקֹּ֧רֶת תִּהְיֶ֛ה לֹ֥א יוּמְת֖וּ כִּי־לֹ֥א חֻפָּֽשָׁה׃ ");
INSERT INTO hbo_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","וְהֵבִ֤יא אֶת־אֲשָׁמֹו֙ לַֽיהוָ֔ה אֶל־פֶּ֖תַח אֹ֣הֶל מֹועֵ֑ד אֵ֖יל אָשָֽׁם׃ ");
INSERT INTO hbo_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","וְכִפֶּר֩ עָלָ֨יו הַכֹּהֵ֜ן בְּאֵ֤יל הָֽאָשָׁם֙ לִפְנֵ֣י יְהוָ֔ה עַל־חַטָּאתֹ֖ו אֲשֶׁ֣ר חָטָ֑א וְנִסְלַ֣ח לֹ֔ו מֵחַטָּאתֹ֖ו אֲשֶׁ֥ר חָטָֽא׃ פ ");
INSERT INTO hbo_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","וְכִי־תָבֹ֣אוּ אֶל־הָאָ֗רֶץ וּנְטַעְתֶּם֙ כָּל־עֵ֣ץ מַאֲכָ֔ל וַעֲרַלְתֶּ֥ם עָרְלָתֹ֖ו אֶת־פִּרְיֹ֑ו שָׁלֹ֣שׁ שָׁנִ֗ים יִהְיֶ֥ה לָכֶ֛ם עֲרֵלִ֖ים לֹ֥א יֵאָכֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","וּבַשָּׁנָה֙ הָרְבִיעִ֔ת יִהְיֶ֖ה כָּל־פִּרְיֹ֑ו קֹ֥דֶשׁ הִלּוּלִ֖ים לַיהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","וּבַשָּׁנָ֣ה הַחֲמִישִׁ֗ת תֹּֽאכְלוּ֙ אֶת־פִּרְיֹ֔ו לְהֹוסִ֥יף לָכֶ֖ם תְּבוּאָתֹ֑ו אֲנִ֖י יְהוָ֥ה אֱלֹהֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","לֹ֥א תֹאכְל֖וּ עַל־הַדָּ֑ם לֹ֥א תְנַחֲשׁ֖וּ וְלֹ֥א תְעֹונֵֽנוּ׃ ");
INSERT INTO hbo_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","לֹ֣א תַקִּ֔פוּ פְּאַ֖ת רֹאשְׁכֶ֑ם וְלֹ֣א תַשְׁחִ֔ית אֵ֖ת פְּאַ֥ת זְקָנֶֽךָ׃ ");
INSERT INTO hbo_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","וְשֶׂ֣רֶט לָנֶ֗פֶשׁ לֹ֤א תִתְּנוּ֙ בִּבְשַׂרְכֶ֔ם וּכְתֹ֣בֶת קֽ͏ַעֲקַ֔ע לֹ֥א תִתְּנ֖וּ בָּכֶ֑ם אֲנִ֖י יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","אַל־תְּחַלֵּ֥ל אֶֽת־בִּתְּךָ֖ לְהַזְנֹותָ֑הּ וְלֹא־תִזְנֶ֣ה הָאָ֔רֶץ וּמָלְאָ֥ה הָאָ֖רֶץ זִמָּֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","אֶת־שַׁבְּתֹתַ֣י תִּשְׁמֹ֔רוּ וּמִקְדָּשִׁ֖י תִּירָ֑אוּ אֲנִ֖י יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","אַל־תִּפְנ֤וּ אֶל־הָאֹבֹת֙ וְאֶל־הַיִּדְּעֹנִ֔ים אַל־תְּבַקְשׁ֖וּ לְטָמְאָ֣ה בָהֶ֑ם אֲנִ֖י יְהוָ֥ה אֱלֹהֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","מִפְּנֵ֤י שֵׂיבָה֙ תָּק֔וּם וְהָדַרְתָּ֖ פְּנֵ֣י זָקֵ֑ן וְיָרֵ֥אתָ מֵּאֱלֹהֶ֖יךָ אֲנִ֥י יְהוָֽה׃ פ ");
INSERT INTO hbo_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","וְכִֽי־יָג֧וּר אִתְּךָ֛ גֵּ֖ר בְּאַרְצְכֶ֑ם לֹ֥א תֹונ֖וּ אֹתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","כְּאֶזְרָ֣ח מִכֶּם֩ יִהְיֶ֨ה לָכֶ֜ם הַגֵּ֣ר ׀ הַגָּ֣ר אִתְּכֶ֗ם וְאָהַבְתָּ֥ לֹו֙ כָּמֹ֔וךָ כִּֽי־גֵרִ֥ים הֱיִיתֶ֖ם בְּאֶ֣רֶץ מִצְרָ֑יִם אֲנִ֖י יְהוָ֥ה אֱלֹהֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","לֹא־תַעֲשׂ֥וּ עָ֖וֶל בַּמִּשְׁפָּ֑ט בַּמִּדָּ֕ה בַּמִּשְׁקָ֖ל וּבַמְּשׂוּרָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","מֹ֧אזְנֵי צֶ֣דֶק אַבְנֵי־צֶ֗דֶק אֵ֥יפַת צֶ֛דֶק וְהִ֥ין צֶ֖דֶק יִהְיֶ֣ה לָכֶ֑ם אֲנִי֙ יְהוָ֣ה אֱלֹֽהֵיכֶ֔ם אֲשֶׁר־הֹוצֵ֥אתִי אֶתְכֶ֖ם מֵאֶ֥רֶץ מִצְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","וּשְׁמַרְתֶּ֤ם אֶת־כָּל־חֻקֹּתַי֙ וְאֶת־כָּל־מִשְׁפָּטַ֔י וַעֲשִׂיתֶ֖ם אֹתָ֑ם אֲנִ֖י יְהוָֽה׃ פ ");
INSERT INTO hbo_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","וְאֶל־בְּנֵ֣י יִשְׂרָאֵל֮ תֹּאמַר֒ אִ֣ישׁ אִישׁ֩ מִבְּנֵ֨י יִשְׂרָאֵ֜ל וּמִן־הַגֵּ֣ר ׀ הַגָּ֣ר בְּיִשְׂרָאֵ֗ל אֲשֶׁ֨ר יִתֵּ֧ן מִזַּרְעֹ֛ו לַמֹּ֖לֶךְ מֹ֣ות יוּמָ֑ת עַ֥ם הָאָ֖רֶץ יִרְגְּמֻ֥הוּ בָאָֽבֶן׃ ");
INSERT INTO hbo_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","וַאֲנִ֞י אֶתֵּ֤ן אֶת־פָּנַי֙ בָּאִ֣ישׁ הַה֔וּא וְהִכְרַתִּ֥י אֹתֹ֖ו מִקֶּ֣רֶב עַמֹּ֑ו כִּ֤י מִזַּרְעֹו֙ נָתַ֣ן לַמֹּ֔לֶךְ לְמַ֗עַן טַמֵּא֙ אֶת־מִקְדָּשִׁ֔י וּלְחַלֵּ֖ל אֶת־שֵׁ֥ם קָדְשִֽׁי׃ ");
INSERT INTO hbo_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","וְאִ֡ם הַעְלֵ֣ם יַעְלִימֽוּ֩ עַ֨ם הָאָ֜רֶץ אֶת־עֵֽינֵיהֶם֙ מִן־הָאִ֣ישׁ הַה֔וּא בְּתִתֹּ֥ו מִזַּרְעֹ֖ו לַמֹּ֑לֶךְ לְבִלְתִּ֖י הָמִ֥ית אֹתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","וְשַׂמְתִּ֨י אֲנִ֧י אֶת־פָּנַ֛י בָּאִ֥ישׁ הַה֖וּא וּבְמִשְׁפַּחְתֹּ֑ו וְהִכְרַתִּ֨י אֹתֹ֜ו וְאֵ֣ת ׀ כָּל־הַזֹּנִ֣ים אַחֲרָ֗יו לִזְנֹ֛ות אַחֲרֵ֥י הַמֹּ֖לֶךְ מִקֶּ֥רֶב עַמָּֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","וְהַנֶּ֗פֶשׁ אֲשֶׁ֨ר תִּפְנֶ֤ה אֶל־הָֽאֹבֹת֙ וְאֶל־הַיִּדְּעֹנִ֔ים לִזְנֹ֖ות אַחֲרֵיהֶ֑ם וְנָתַתִּ֤י אֶת־פָּנַי֙ בַּנֶּ֣פֶשׁ הַהִ֔וא וְהִכְרַתִּ֥י אֹתֹ֖ו מִקֶּ֥רֶב עַמֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","וְהִ֨תְקַדִּשְׁתֶּ֔ם וִהְיִיתֶ֖ם קְדֹשִׁ֑ים כִּ֛י אֲנִ֥י יְהוָ֖ה אֱלֹהֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","וּשְׁמַרְתֶּם֙ אֶת־חֻקֹּתַ֔י וַעֲשִׂיתֶ֖ם אֹתָ֑ם אֲנִ֥י יְהוָ֖ה מְקַדִּשְׁכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","כִּֽי־אִ֣ישׁ אִ֗ישׁ אֲשֶׁ֨ר יְקַלֵּ֧ל אֶת־אָבִ֛יו וְאֶת־אִמֹּ֖ו מֹ֣ות יוּמָ֑ת אָבִ֧יו וְאִמֹּ֛ו קִלֵּ֖ל דָּמָ֥יו בֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","וְאִ֗ישׁ אֲשֶׁ֤ר יִנְאַף֙ אֶת־אֵ֣שֶׁת אִ֔ישׁ אֲשֶׁ֥ר יִנְאַ֖ף אֶת־אֵ֣שֶׁת רֵעֵ֑הוּ מֹֽות־יוּמַ֥ת הַנֹּאֵ֖ף וְהַנֹּאָֽפֶת׃ ");
INSERT INTO hbo_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","וְאִ֗ישׁ אֲשֶׁ֤ר יִשְׁכַּב֙ אֶת־אֵ֣שֶׁת אָבִ֔יו עֶרְוַ֥ת אָבִ֖יו גִּלָּ֑ה מֹֽות־יוּמְת֥וּ שְׁנֵיהֶ֖ם דְּמֵיהֶ֥ם בָּֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","וְאִ֗ישׁ אֲשֶׁ֤ר יִשְׁכַּב֙ אֶת־כַּלָּתֹ֔ו מֹ֥ות יוּמְת֖וּ שְׁנֵיהֶ֑ם תֶּ֥בֶל עָשׂ֖וּ דְּמֵיהֶ֥ם בָּֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","וְאִ֗ישׁ אֲשֶׁ֨ר יִשְׁכַּ֤ב אֶת־זָכָר֙ מִשְׁכְּבֵ֣י אִשָּׁ֔ה תֹּועֵבָ֥ה עָשׂ֖וּ שְׁנֵיהֶ֑ם מֹ֥ות יוּמָ֖תוּ דְּמֵיהֶ֥ם בָּֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","וְאִ֗ישׁ אֲשֶׁ֨ר יִקַּ֧ח אֶת־אִשָּׁ֛ה וְאֶת־אִמָּ֖הּ זִמָּ֣ה הִ֑וא בָּאֵ֞שׁ יִשְׂרְפ֤וּ אֹתֹו֙ וְאֶתְהֶ֔ן וְלֹא־תִהְיֶ֥ה זִמָּ֖ה בְּתֹוכְכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","וְאִ֗ישׁ אֲשֶׁ֨ר יִתֵּ֧ן שְׁכָבְתֹּ֛ו בִּבְהֵמָ֖ה מֹ֣ות יוּמָ֑ת וְאֶת־הַבְּהֵמָ֖ה תַּהֲרֹֽגוּ׃ ");
INSERT INTO hbo_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","וְאִשָּׁ֗ה אֲשֶׁ֨ר תִּקְרַ֤ב אֶל־כָּל־בְּהֵמָה֙ לְרִבְעָ֣ה אֹתָ֔הּ וְהָרַגְתָּ֥ אֶת־הָאִשָּׁ֖ה וְאֶת־הַבְּהֵמָ֑ה מֹ֥ות יוּמָ֖תוּ דְּמֵיהֶ֥ם בָּֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","וְאִ֣ישׁ אֲשֶׁר־יִקַּ֣ח אֶת־אֲחֹתֹ֡ו בַּת־אָבִ֣יו אֹ֣ו בַת־אִ֠מֹּו וְרָאָ֨ה אֶת־עֶרְוָתָ֜הּ וְהִֽיא־תִרְאֶ֤ה אֶת־עֶרְוָתֹו֙ חֶ֣סֶד ה֔וּא וְנִ֨כְרְת֔וּ לְעֵינֵ֖י בְּנֵ֣י עַמָּ֑ם עֶרְוַ֧ת אֲחֹתֹ֛ו גִּלָּ֖ה עֲוֹנֹ֥ו יִשָּֽׂא׃ ");
INSERT INTO hbo_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","וְ֠אִישׁ אֲשֶׁר־יִשְׁכַּ֨ב אֶת־אִשָּׁ֜ה דָּוָ֗ה וְגִלָּ֤ה אֶת־עֶרְוָתָהּ֙ אֶת־מְקֹרָ֣הּ הֶֽעֱרָ֔ה וְהִ֕יא גִּלְּתָ֖ה אֶת־מְקֹ֣ור דָּמֶ֑יהָ וְנִכְרְת֥וּ שְׁנֵיהֶ֖ם מִקֶּ֥רֶב עַמָּֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","וְעֶרְוַ֨ת אֲחֹ֧ות אִמְּךָ֛ וַאֲחֹ֥ות אָבִ֖יךָ לֹ֣א תְגַלֵּ֑ה כִּ֧י אֶת־שְׁאֵרֹ֛ו הֶעֱרָ֖ה עֲוֹנָ֥ם יִשָּֽׂאוּ׃ ");
INSERT INTO hbo_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","וְאִ֗ישׁ אֲשֶׁ֤ר יִשְׁכַּב֙ אֶת־דֹּ֣דָתֹ֔ו עֶרְוַ֥ת דֹּדֹ֖ו גִּלָּ֑ה חֶטְאָ֥ם יִשָּׂ֖אוּ עֲרִירִ֥ים יָמֻֽתוּ׃ ");
INSERT INTO hbo_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","וְאִ֗ישׁ אֲשֶׁ֥ר יִקַּ֛ח אֶת־אֵ֥שֶׁת אָחִ֖יו נִדָּ֣ה הִ֑וא עֶרְוַ֥ת אָחִ֛יו גִּלָּ֖ה עֲרִירִ֥ים יִהְיֽוּ׃ ");
INSERT INTO hbo_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","וּשְׁמַרְתֶּ֤ם אֶת־כָּל־חֻקֹּתַי֙ וְאֶת־כָּל־מִשְׁפָּטַ֔י וַעֲשִׂיתֶ֖ם אֹתָ֑ם וְלֹא־תָקִ֤יא אֶתְכֶם֙ הָאָ֔רֶץ אֲשֶׁ֨ר אֲנִ֜י מֵבִ֥יא אֶתְכֶ֛ם שָׁ֖מָּה לָשֶׁ֥בֶת בָּֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","וְלֹ֤א תֵֽלְכוּ֙ בְּחֻקֹּ֣ת הַגֹּ֔וי אֲשֶׁר־אֲנִ֥י מְשַׁלֵּ֖חַ מִפְּנֵיכֶ֑ם כִּ֤י אֶת־כָּל־אֵ֙לֶּה֙ עָשׂ֔וּ וָאָקֻ֖ץ בָּֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","וָאֹמַ֣ר לָכֶ֗ם אַתֶּם֮ תִּֽירְשׁ֣וּ אֶת־אַדְמָתָם֒ וַאֲנִ֞י אֶתְּנֶ֤נָּה לָכֶם֙ לָרֶ֣שֶׁת אֹתָ֔הּ אֶ֛רֶץ זָבַ֥ת חָלָ֖ב וּדְבָ֑שׁ אֲנִי֙ יְהוָ֣ה אֱלֹֽהֵיכֶ֔ם אֲשֶׁר־הִבְדַּ֥לְתִּי אֶתְכֶ֖ם מִן־הָֽעַמִּֽים׃ ");
INSERT INTO hbo_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","וְהִבְדַּלְתֶּ֞ם בֵּֽין־הַבְּהֵמָ֤ה הַטְּהֹרָה֙ לַטְּמֵאָ֔ה וּבֵין־הָעֹ֥וף הַטָּמֵ֖א לַטָּהֹ֑ר וְלֹֽא־תְשַׁקְּצ֨וּ אֶת־נַפְשֹֽׁתֵיכֶ֜ם בַּבְּהֵמָ֣ה וּבָעֹ֗וף וּבְכֹל֙ אֲשֶׁ֣ר תִּרְמֹ֣שׂ הָֽאֲדָמָ֔ה אֲשֶׁר־הִבְדַּ֥לְתִּי לָכֶ֖ם לְטַמֵּֽא׃ ");
INSERT INTO hbo_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","וִהְיִ֤יתֶם לִי֙ קְדֹשִׁ֔ים כִּ֥י קָדֹ֖ושׁ אֲנִ֣י יְהוָ֑ה וָאַבְדִּ֥ל אֶתְכֶ֛ם מִן־הֽ͏ָעַמִּ֖ים לִהְיֹ֥ות לִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","וְאִ֣ישׁ אֹֽו־אִשָּׁ֗ה כִּי־יִהְיֶ֨ה בָהֶ֥ם אֹ֛וב אֹ֥ו יִדְּעֹנִ֖י מֹ֣ות יוּמָ֑תוּ בָּאֶ֛בֶן יִרְגְּמ֥וּ אֹתָ֖ם דְּמֵיהֶ֥ם בָּֽם׃ פ ");
INSERT INTO hbo_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","וַיֹּ֤אמֶר יְהוָה֙ אֶל־מֹשֶׁ֔ה אֱמֹ֥ר אֶל־הַכֹּהֲנִ֖ים בְּנֵ֣י אַהֲרֹ֑ן וְאָמַרְתָּ֣ אֲלֵהֶ֔ם לְנֶ֥פֶשׁ לֹֽא־יִטַּמָּ֖א בְּעַמָּֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","כִּ֚י אִם־לִשְׁאֵרֹ֔ו הַקָּרֹ֖ב אֵלָ֑יו לְאִמֹּ֣ו וּלְאָבִ֔יו וְלִבְנֹ֥ו וּלְבִתֹּ֖ו וּלְאָחִֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","וְלַאֲחֹתֹ֤ו הַבְּתוּלָה֙ הַקְּרֹובָ֣ה אֵלָ֔יו אֲשֶׁ֥ר לֹֽא־הָיְתָ֖ה לְאִ֑ישׁ לָ֖הּ יִטַּמָּֽא׃ ");
INSERT INTO hbo_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","לֹ֥א יִטַּמָּ֖א בַּ֣עַל בְּעַמָּ֑יו לְהֵ֖חַלֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","לֹֽא־*יִקְרְחָה (יִקְרְח֤וּ) קָרְחָה֙ בְּרֹאשָׁ֔ם וּפְאַ֥ת זְקָנָ֖ם לֹ֣א יְגַלֵּ֑חוּ וּבִ֨בְשָׂרָ֔ם לֹ֥א יִשְׂרְט֖וּ שָׂרָֽטֶת׃ ");
INSERT INTO hbo_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","קְדֹשִׁ֤ים יִהְיוּ֙ לֵאלֹ֣הֵיהֶ֔ם וְלֹ֣א יְחַלְּל֔וּ שֵׁ֖ם אֱלֹהֵיהֶ֑ם כִּי֩ אֶת־אִשֵּׁ֨י יְהוָ֜ה לֶ֧חֶם אֱלֹהֵיהֶ֛ם הֵ֥ם מַקְרִיבִ֖ם וְהָ֥יוּ קֹֽדֶשׁ׃ ");
INSERT INTO hbo_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","אִשָּׁ֨ה זֹנָ֤ה וַחֲלָלָה֙ לֹ֣א יִקָּ֔חוּ וְאִשָּׁ֛ה גְּרוּשָׁ֥ה מֵאִישָׁ֖הּ לֹ֣א יִקָּ֑חוּ כִּֽי־קָדֹ֥שׁ ה֖וּא לֵאלֹהָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","וְקִדַּשְׁתֹּ֔ו כִּֽי־אֶת־לֶ֥חֶם אֱלֹהֶ֖יךָ ה֣וּא מַקְרִ֑יב קָדֹשׁ֙ יִֽהְיֶה־לָּ֔ךְ כִּ֣י קָדֹ֔ושׁ אֲנִ֥י יְהוָ֖ה מְקַדִּשְׁכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","וּבַת֙ אִ֣ישׁ כֹּהֵ֔ן כִּ֥י תֵחֵ֖ל לִזְנֹ֑ות אֶת־אָבִ֙יהָ֙ הִ֣יא מְחַלֶּ֔לֶת בָּאֵ֖שׁ תִּשָּׂרֵֽף׃ ס ");
INSERT INTO hbo_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","וְהַכֹּהֵן֩ הַגָּדֹ֨ול מֵאֶחָ֜יו אֲ‍ֽשֶׁר־יוּצַ֥ק עַל־רֹאשֹׁ֣ו ׀ שֶׁ֤מֶן הַמִּשְׁחָה֙ וּמִלֵּ֣א אֶת־יָדֹ֔ו לִלְבֹּ֖שׁ אֶת־הַבְּגָדִ֑ים אֶת־רֹאשֹׁו֙ לֹ֣א יִפְרָ֔ע וּבְגָדָ֖יו לֹ֥א יִפְרֹֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","וְעַ֛ל כָּל־נַפְשֹׁ֥ת מֵ֖ת לֹ֣א יָבֹ֑א לְאָבִ֥יו וּלְאִמֹּ֖ו לֹ֥א יִטַּמָּֽא׃ ");
INSERT INTO hbo_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","וּמִן־הַמִּקְדָּשׁ֙ לֹ֣א יֵצֵ֔א וְלֹ֣א יְחַלֵּ֔ל אֵ֖ת מִקְדַּ֣שׁ אֱלֹהָ֑יו כִּ֡י נֵ֠זֶר שֶׁ֣מֶן מִשְׁחַ֧ת אֱלֹהָ֛יו עָלָ֖יו אֲנִ֥י יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","וְה֕וּא אִשָּׁ֥ה בִבְתוּלֶ֖יהָ יִקָּֽח׃ ");
INSERT INTO hbo_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","אַלְמָנָ֤ה וּגְרוּשָׁה֙ וַחֲלָלָ֣ה זֹנָ֔ה אֶת־אֵ֖לֶּה לֹ֣א יִקָּ֑ח כִּ֛י אִם־בְּתוּלָ֥ה מֵעַמָּ֖יו יִקַּ֥ח אִשָּֽׁה׃ ");
INSERT INTO hbo_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","וְלֹֽא־יְחַלֵּ֥ל זַרְעֹ֖ו בְּעַמָּ֑יו כִּ֛י אֲנִ֥י יְהוָ֖ה מְקַדְּשֹֽׁו׃ פ ");
INSERT INTO hbo_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","דַּבֵּ֥ר אֶֽל־אַהֲרֹ֖ן לֵאמֹ֑ר אִ֣ישׁ מִֽזַּרְעֲךָ֞ לְדֹרֹתָ֗ם אֲשֶׁ֨ר יִהְיֶ֥ה בֹו֙ מ֔וּם לֹ֣א יִקְרַ֔ב לְהַקְרִ֖יב לֶ֥חֶם אֱלֹהָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","כִּ֥י כָל־אִ֛ישׁ אֲשֶׁר־בֹּ֥ו מ֖וּם לֹ֣א יִקְרָ֑ב אִ֤ישׁ עִוֵּר֙ אֹ֣ו פִסֵּ֔חַ אֹ֥ו חָרֻ֖ם אֹ֥ו שָׂרֽוּעַ׃ ");
INSERT INTO hbo_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","אֹ֣ו אִ֔ישׁ אֲשֶׁר־יִהְיֶ֥ה בֹ֖ו שֶׁ֣בֶר רָ֑גֶל אֹ֖ו שֶׁ֥בֶר יָֽד׃ ");
INSERT INTO hbo_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","אֹֽו־גִבֵּ֣ן אֹו־דַ֔ק אֹ֖ו תְּבַלֻּ֣ל בְּעֵינֹ֑ו אֹ֤ו גָרָב֙ אֹ֣ו יַלֶּ֔פֶת אֹ֖ו מְרֹ֥וחַ אָֽשֶׁךְ׃ ");
INSERT INTO hbo_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","כָּל־אִ֞ישׁ אֲשֶׁר־בֹּ֣ו מ֗וּם מִזֶּ֙רַע֙ אַהֲרֹ֣ן הַכֹּהֵ֔ן לֹ֣א יִגַּ֔שׁ לְהַקְרִ֖יב אֶת־אִשֵּׁ֣י יְהוָ֑ה מ֣וּם בֹּ֔ו אֵ֚ת לֶ֣חֶם אֱלֹהָ֔יו לֹ֥א יִגַּ֖שׁ לְהַקְרִֽיב׃ ");
INSERT INTO hbo_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","לֶ֣חֶם אֱלֹהָ֔יו מִקָּדְשֵׁ֖י הַקֳּדָשִׁ֑ים וּמִן־הַקֳּדָשִׁ֖ים יֹאכֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","אַ֣ךְ אֶל־הַפָּרֹ֜כֶת לֹ֣א יָבֹ֗א וְאֶל־הַמִּזְבֵּ֛חַ לֹ֥א יִגַּ֖שׁ כִּֽי־מ֣וּם בֹּ֑ו וְלֹ֤א יְחַלֵּל֙ אֶת־מִקְדָּשַׁ֔י כִּ֛י אֲנִ֥י יְהוָ֖ה מְקַדְּשָֽׁם׃ ");
INSERT INTO hbo_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","וַיְדַבֵּ֣ר מֹשֶׁ֔ה אֶֽל־אַהֲרֹ֖ן וְאֶל־בָּנָ֑יו וְאֶֽל־כָּל־בְּנֵ֖י יִשְׂרָאֵֽל׃ פ ");
INSERT INTO hbo_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","דַּבֵּ֨ר אֶֽל־אַהֲרֹ֜ן וְאֶל־בָּנָ֗יו וְיִנָּֽזְרוּ֙ מִקָּדְשֵׁ֣י בְנֵֽי־יִשְׂרָאֵ֔ל וְלֹ֥א יְחַלְּל֖וּ אֶת־שֵׁ֣ם קָדְשִׁ֑י אֲשֶׁ֨ר הֵ֧ם מַקְדִּשִׁ֛ים לִ֖י אֲנִ֥י יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","אֱמֹ֣ר אֲלֵהֶ֗ם לְדֹרֹ֨תֵיכֶ֜ם כָּל־אִ֣ישׁ ׀ אֲשֶׁר־יִקְרַ֣ב מִכָּל־זַרְעֲכֶ֗ם אֶל־הַקֳּדָשִׁים֙ אֲשֶׁ֨ר יַקְדִּ֤ישׁוּ בְנֵֽי־יִשְׂרָאֵל֙ לַֽיהוָ֔ה וְטֻמְאָתֹ֖ו עָלָ֑יו וְנִכְרְתָ֞ה הַנֶּ֧פֶשׁ הַהִ֛וא מִלְּפָנַ֖י אֲנִ֥י יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","אִ֣ישׁ אִ֞ישׁ מִזֶּ֣רַע אַהֲרֹ֗ן וְה֤וּא צָר֙וּעַ֙ אֹ֣ו זָ֔ב בַּקֳּדָשִׁים֙ לֹ֣א יֹאכַ֔ל עַ֖ד אֲשֶׁ֣ר יִטְהָ֑ר וְהַנֹּגֵ֙עַ֙ בְּכָל־טְמֵא־נֶ֔פֶשׁ אֹ֣ו אִ֔ישׁ אֲשֶׁר־תֵּצֵ֥א מִמֶּ֖נּוּ שִׁכְבַת־זָֽרַע׃ ");
INSERT INTO hbo_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","אֹו־אִישׁ֙ אֲשֶׁ֣ר יִגַּ֔ע בְּכָל־שֶׁ֖רֶץ אֲשֶׁ֣ר יִטְמָא־לֹ֑ו אֹ֤ו בְאָדָם֙ אֲשֶׁ֣ר יִטְמָא־לֹ֔ו לְכֹ֖ל טֻמְאָתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","נֶ֚פֶשׁ אֲשֶׁ֣ר תִּגַּע־בֹּ֔ו וְטָמְאָ֖ה עַד־הָעָ֑רֶב וְלֹ֤א יֹאכַל֙ מִן־הַקֳּדָשִׁ֔ים כִּ֛י אִם־רָחַ֥ץ בְּשָׂרֹ֖ו בַּמָּֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","וּבָ֥א הַשֶּׁ֖מֶשׁ וְטָהֵ֑ר וְאַחַר֙ יֹאכַ֣ל מִן־הַקֳּדָשִׁ֔ים כִּ֥י לַחְמֹ֖ו הֽוּא׃ ");
INSERT INTO hbo_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","נְבֵלָ֧ה וּטְרֵפָ֛ה לֹ֥א יֹאכַ֖ל לְטָמְאָה־בָ֑הּ אֲנִ֖י יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","וְשָׁמְר֣וּ אֶת־מִשְׁמַרְתִּ֗י וְלֹֽא־יִשְׂא֤וּ עָלָיו֙ חֵ֔טְא וּמֵ֥תוּ בֹ֖ו כִּ֣י יְחַלְּלֻ֑הוּ אֲנִ֥י יְהוָ֖ה מְקַדְּשָֽׁם׃ ");
INSERT INTO hbo_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","וְכָל־זָ֖ר לֹא־יֹ֣אכַל קֹ֑דֶשׁ תֹּושַׁ֥ב כֹּהֵ֛ן וְשָׂכִ֖יר לֹא־יֹ֥אכַל קֹֽדֶשׁ׃ ");
INSERT INTO hbo_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","וְכֹהֵ֗ן כִּֽי־יִקְנֶ֥ה נֶ֙פֶשׁ֙ קִנְיַ֣ן כַּסְפֹּ֔ו ה֖וּא יֹ֣אכַל בֹּ֑ו וִילִ֣יד בֵּיתֹ֔ו הֵ֖ם יֹאכְל֥וּ בְלַחְמֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","וּבַת־כֹּהֵ֔ן כִּ֥י תִהְיֶ֖ה לְאִ֣ישׁ זָ֑ר הִ֕וא בִּתְרוּמַ֥ת הַקֳּדָשִׁ֖ים לֹ֥א תֹאכֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","וּבַת־כֹּהֵן֩ כִּ֨י תִהְיֶ֜ה אַלְמָנָ֣ה וּגְרוּשָׁ֗ה וְזֶרַע֮ אֵ֣ין לָהּ֒ וְשָׁבָ֞ה אֶל־בֵּ֤ית אָבִ֙יהָ֙ כִּנְעוּרֶ֔יהָ מִלֶּ֥חֶם אָבִ֖יהָ תֹּאכֵ֑ל וְכָל־זָ֖ר לֹא־יֹ֥אכַל בֹּֽו׃ ס ");
INSERT INTO hbo_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","וְאִ֕ישׁ כִּֽי־יֹאכַ֥ל קֹ֖דֶשׁ בִּשְׁגָגָ֑ה וְיָסַ֤ף חֲמִֽשִׁיתֹו֙ עָלָ֔יו וְנָתַ֥ן לַכֹּהֵ֖ן אֶת־הַקֹּֽדֶשׁ׃ ");
INSERT INTO hbo_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","וְלֹ֣א יְחַלְּל֔וּ אֶת־קָדְשֵׁ֖י בְּנֵ֣י יִשְׂרָאֵ֑ל אֵ֥ת אֲשֶׁר־יָרִ֖ימוּ לַיהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","וְהִשִּׂ֤יאוּ אֹותָם֙ עֲוֹ֣ן אַשְׁמָ֔ה בְּאָכְלָ֖ם אֶת־קָדְשֵׁיהֶ֑ם כִּ֛י אֲנִ֥י יְהוָ֖ה מְקַדְּשָֽׁם׃ פ ");
INSERT INTO hbo_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","דַּבֵּ֨ר אֶֽל־אַהֲרֹ֜ן וְאֶל־בָּנָ֗יו וְאֶל֙ כָּל־בְּנֵ֣י יִשְׂרָאֵ֔ל וְאָמַרְתָּ֖ אֲלֵהֶ֑ם אִ֣ישׁ אִישׁ֩ מִבֵּ֨ית יִשְׂרָאֵ֜ל וּמִן־הַגֵּ֣ר בְּיִשְׂרָאֵ֗ל אֲשֶׁ֨ר יַקְרִ֤יב קָרְבָּנֹו֙ לְכָל־נִדְרֵיהֶם֙ וּלְכָל־נִדְבֹותָ֔ם אֲשֶׁר־יַקְרִ֥יבוּ לַיהוָ֖ה לְעֹלָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","לִֽרְצֹנְכֶ֑ם תָּמִ֣ים זָכָ֔ר בַּבָּקָ֕ר בַּכְּשָׂבִ֖ים וּבָֽעִזִּֽים׃ ");
INSERT INTO hbo_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","כֹּ֛ל אֲשֶׁר־בֹּ֥ו מ֖וּם לֹ֣א תַקְרִ֑יבוּ כִּי־לֹ֥א לְרָצֹ֖ון יִהְיֶ֥ה לָכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","וְאִ֗ישׁ כִּֽי־יַקְרִ֤יב זֶֽבַח־שְׁלָמִים֙ לַיהוָ֔ה לְפַלֵּא־נֶ֙דֶר֙ אֹ֣ו לִנְדָבָ֔ה בַּבָּקָ֖ר אֹ֣ו בַצֹּ֑אן תָּמִ֤ים יִֽהְיֶה֙ לְרָצֹ֔ון כָּל־מ֖וּם לֹ֥א יִהְיֶה־בֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","עַוֶּרֶת֩ אֹ֨ו שָׁב֜וּר אֹו־חָר֣וּץ אֹֽו־יַבֶּ֗לֶת אֹ֤ו גָרָב֙ אֹ֣ו יַלֶּ֔פֶת לֹא־תַקְרִ֥יבוּ אֵ֖לֶּה לַיהוָ֑ה וְאִשֶּׁ֗ה לֹא־תִתְּנ֥וּ מֵהֶ֛ם עַל־הַמִּזְבֵּ֖חַ לַיהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","וְשֹׁ֥ור וָשֶׂ֖ה שָׂר֣וּעַ וְקָל֑וּט נְדָבָה֙ תַּעֲשֶׂ֣ה אֹתֹ֔ו וּלְנֵ֖דֶר לֹ֥א יֵרָצֶֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","וּמָע֤וּךְ וְכָתוּת֙ וְנָת֣וּק וְכָר֔וּת לֹ֥א תַקְרִ֖יבוּ לַֽיהוָ֑ה וּֽבְאַרְצְכֶ֖ם לֹ֥א תַעֲשֽׂוּ׃ ");
INSERT INTO hbo_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","וּמִיַּ֣ד בֶּן־נֵכָ֗ר לֹ֥א תַקְרִ֛יבוּ אֶת־לֶ֥חֶם אֱלֹהֵיכֶ֖ם מִכָּל־אֵ֑לֶּה כִּ֣י מָשְׁחָתָ֤ם בָּהֶם֙ מ֣וּם בָּ֔ם לֹ֥א יֵרָצ֖וּ לָכֶֽם׃ פ ");
INSERT INTO hbo_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","שֹׁ֣ור אֹו־כֶ֤שֶׂב אֹו־עֵז֙ כִּ֣י יִוָּלֵ֔ד וְהָיָ֛ה שִׁבְעַ֥ת יָמִ֖ים תַּ֣חַת אִמֹּ֑ו וּמִיֹּ֤ום הַשְּׁמִינִי֙ וָהָ֔לְאָה יֵרָצֶ֕ה לְקָרְבַּ֥ן אִשֶּׁ֖ה לַיהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","וְשֹׁ֖ור אֹו־שֶׂ֑ה אֹתֹ֣ו וְאֶת־בְּנֹ֔ו לֹ֥א תִשְׁחֲט֖וּ בְּיֹ֥ום אֶחָֽד׃ ");
INSERT INTO hbo_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","וְכִֽי־תִזְבְּח֥וּ זֶֽבַח־תֹּודָ֖ה לַיהוָ֑ה לִֽרְצֹנְכֶ֖ם תִּזְבָּֽחוּ׃ ");
INSERT INTO hbo_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","בַּיֹּ֤ום הַהוּא֙ יֵאָכֵ֔ל לֹֽא־תֹותִ֥ירוּ מִמֶּ֖נּוּ עַד־בֹּ֑קֶר אֲנִ֖י יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","וּשְׁמַרְתֶּם֙ מִצְוֹתַ֔י וַעֲשִׂיתֶ֖ם אֹתָ֑ם אֲנִ֖י יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","וְלֹ֤א תְחַלְּלוּ֙ אֶת־שֵׁ֣ם קָדְשִׁ֔י וְנִ֨קְדַּשְׁתִּ֔י בְּתֹ֖וךְ בְּנֵ֣י יִשְׂרָאֵ֑ל אֲנִ֥י יְהוָ֖ה מְקַדִּשְׁכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","הַמֹּוצִ֤יא אֶתְכֶם֙ מֵאֶ֣רֶץ מִצְרַ֔יִם לִהְיֹ֥ות לָכֶ֖ם לֵאלֹהִ֑ים אֲנִ֖י יְהוָֽה׃ פ ");
INSERT INTO hbo_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","דַּבֵּ֞ר אֶל־בְּנֵ֤י יִשְׂרָאֵל֙ וְאָמַרְתָּ֣ אֲלֵהֶ֔ם מֹועֲדֵ֣י יְהוָ֔ה אֲשֶׁר־תִּקְרְא֥וּ אֹתָ֖ם מִקְרָאֵ֣י קֹ֑דֶשׁ אֵ֥לֶּה הֵ֖ם מֹועֲדָֽי׃ ");
INSERT INTO hbo_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","שֵׁ֣שֶׁת יָמִים֮ תֵּעָשֶׂ֣ה מְלָאכָה֒ וּבַיֹּ֣ום הַשְּׁבִיעִ֗י שַׁבַּ֤ת שַׁבָּתֹון֙ מִקְרָא־קֹ֔דֶשׁ כָּל־מְלָאכָ֖ה לֹ֣א תַעֲשׂ֑וּ שַׁבָּ֥ת הִוא֙ לַֽיהוָ֔ה בְּכֹ֖ל מֹֽושְׁבֹתֵיכֶֽם׃ פ ");
INSERT INTO hbo_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","אֵ֚לֶּה מֹועֲדֵ֣י יְהוָ֔ה מִקְרָאֵ֖י קֹ֑דֶשׁ אֲשֶׁר־תִּקְרְא֥וּ אֹתָ֖ם בְּמֹועֲדָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","בַּחֹ֣דֶשׁ הָרִאשֹׁ֗ון בְּאַרְבָּעָ֥ה עָשָׂ֛ר לַחֹ֖דֶשׁ בֵּ֣ין הָעַרְבָּ֑יִם פֶּ֖סַח לַיהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","וּבַחֲמִשָּׁ֨ה עָשָׂ֥ר יֹום֙ לַחֹ֣דֶשׁ הַזֶּ֔ה חַ֥ג הַמַּצֹּ֖ות לַיהוָ֑ה שִׁבְעַ֥ת יָמִ֖ים מַצֹּ֥ות תֹּאכֵֽלוּ׃ ");
INSERT INTO hbo_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","בַּיֹּום֙ הָֽרִאשֹׁ֔ון מִקְרָא־קֹ֖דֶשׁ יִהְיֶ֣ה לָכֶ֑ם כָּל־מְלֶ֥אכֶת עֲבֹדָ֖ה לֹ֥א תַעֲשֽׂוּ׃ ");
INSERT INTO hbo_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","וְהִקְרַבְתֶּ֥ם אִשֶּׁ֛ה לַיהוָ֖ה שִׁבְעַ֣ת יָמִ֑ים בַּיֹּ֤ום הַשְּׁבִיעִי֙ מִקְרָא־קֹ֔דֶשׁ כָּל־מְלֶ֥אכֶת עֲבֹדָ֖ה לֹ֥א תַעֲשֽׂוּ׃ פ ");
INSERT INTO hbo_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","דַּבֵּ֞ר אֶל־בְּנֵ֤י יִשְׂרָאֵל֙ וְאָמַרְתָּ֣ אֲלֵהֶ֔ם כִּֽי־תָבֹ֣אוּ אֶל־הָאָ֗רֶץ אֲשֶׁ֤ר אֲנִי֙ נֹתֵ֣ן לָכֶ֔ם וּקְצַרְתֶּ֖ם אֶת־קְצִירָ֑הּ וַהֲבֵאתֶ֥ם אֶת־עֹ֛מֶר רֵאשִׁ֥ית קְצִירְכֶ֖ם אֶל־הַכֹּהֵֽן׃ ");
INSERT INTO hbo_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","וְהֵנִ֧יף אֶת־הָעֹ֛מֶר לִפְנֵ֥י יְהוָ֖ה לִֽרְצֹנְכֶ֑ם מִֽמָּחֳרַת֙ הַשַּׁבָּ֔ת יְנִיפֶ֖נּוּ הַכֹּהֵֽן׃ ");
INSERT INTO hbo_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","וַעֲשִׂיתֶ֕ם בְּיֹ֥ום הֲנִֽיפְכֶ֖ם אֶת־הָעֹ֑מֶר כֶּ֣בֶשׂ תָּמִ֧ים בֶּן־שְׁנָתֹ֛ו לְעֹלָ֖ה לַיהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","וּמִנְחָתֹו֩ שְׁנֵ֨י עֶשְׂרֹנִ֜ים סֹ֣לֶת בְּלוּלָ֥ה בַשֶּׁ֛מֶן אִשֶּׁ֥ה לַיהוָ֖ה רֵ֣יחַ נִיחֹ֑חַ וְנִסְכֹּ֥ה יַ֖יִן רְבִיעִ֥ת הַהִֽין׃ ");
INSERT INTO hbo_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","וְלֶחֶם֩ וְקָלִ֨י וְכַרְמֶ֜ל לֹ֣א תֹֽאכְל֗וּ עַד־עֶ֙צֶם֙ הַיֹּ֣ום הַזֶּ֔ה עַ֚ד הֲבִ֣יאֲכֶ֔ם אֶת־קָרְבַּ֖ן אֱלֹהֵיכֶ֑ם חֻקַּ֤ת עֹולָם֙ לְדֹרֹ֣תֵיכֶ֔ם בְּכֹ֖ל מֹשְׁבֹֽתֵיכֶֽם׃ ס ");
INSERT INTO hbo_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","וּסְפַרְתֶּ֤ם לָכֶם֙ מִמָּחֳרַ֣ת הַשַּׁבָּ֔ת מִיֹּום֙ הֲבִ֣יאֲכֶ֔ם אֶת־עֹ֖מֶר הַתְּנוּפָ֑ה שֶׁ֥בַע שַׁבָּתֹ֖ות תְּמִימֹ֥ת תִּהְיֶֽינָה׃ ");
INSERT INTO hbo_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","עַ֣ד מִֽמָּחֳרַ֤ת הַשַּׁבָּת֙ הַשְּׁבִיעִ֔ת תִּסְפְּר֖וּ חֲמִשִּׁ֣ים יֹ֑ום וְהִקְרַבְתֶּ֛ם מִנְחָ֥ה חֲדָשָׁ֖ה לַיהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","מִמֹּושְׁבֹ֨תֵיכֶ֜ם תָּבִ֣יאּוּ ׀ לֶ֣חֶם תְּנוּפָ֗ה שְׁ֚תַּיִם שְׁנֵ֣י עֶשְׂרֹנִ֔ים סֹ֣לֶת תִּהְיֶ֔ינָה חָמֵ֖ץ תֵּאָפֶ֑ינָה בִּכּוּרִ֖ים לֽ͏ַיהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","וְהִקְרַבְתֶּ֣ם עַל־הַלֶּ֗חֶם שִׁבְעַ֨ת כְּבָשִׂ֤ים תְּמִימִם֙ בְּנֵ֣י שָׁנָ֔ה וּפַ֧ר בֶּן־בָּקָ֛ר אֶחָ֖ד וְאֵילִ֣ם שְׁנָ֑יִם יִהְי֤וּ עֹלָה֙ לַֽיהוָ֔ה וּמִנְחָתָם֙ וְנִסְכֵּיהֶ֔ם אִשֵּׁ֥ה רֵֽיחַ־נִיחֹ֖חַ לַיהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","וַעֲשִׂיתֶ֛ם שְׂעִיר־עִזִּ֥ים אֶחָ֖ד לְחַטָּ֑את וּשְׁנֵ֧י כְבָשִׂ֛ים בְּנֵ֥י שָׁנָ֖ה לְזֶ֥בַח שְׁלָמִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","וְהֵנִ֣יף הַכֹּהֵ֣ן ׀ אֹתָ֡ם עַל֩ לֶ֨חֶם הַבִּכּוּרִ֤ים תְּנוּפָה֙ לִפְנֵ֣י יְהוָ֔ה עַל־שְׁנֵ֖י כְּבָשִׂ֑ים קֹ֛דֶשׁ יִהְי֥וּ לַיהוָ֖ה לַכֹּהֵֽן׃ ");
INSERT INTO hbo_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","וּקְרָאתֶ֞ם בְּעֶ֣צֶם ׀ הַיֹּ֣ום הַזֶּ֗ה מִֽקְרָא־קֹ֙דֶשׁ֙ יִהְיֶ֣ה לָכֶ֔ם כָּל־מְלֶ֥אכֶת עֲבֹדָ֖ה לֹ֣א תַעֲשׂ֑וּ חֻקַּ֥ת עֹולָ֛ם בְּכָל־מֹושְׁבֹ֥תֵיכֶ֖ם לְדֹרֹֽתֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","וּֽבְקֻצְרְכֶ֞ם אֶת־קְצִ֣יר אַרְצְכֶ֗ם לֹֽא־תְכַלֶּ֞ה פְּאַ֤ת שָֽׂדְךָ֙ בְּקֻצְרֶ֔ךָ וְלֶ֥קֶט קְצִירְךָ֖ לֹ֣א תְלַקֵּ֑ט לֶֽעָנִ֤י וְלַגֵּר֙ תַּעֲזֹ֣ב אֹתָ֔ם אֲנִ֖י יְהוָ֥ה אֱלֹהֵיכֶֽם׃ ס ");
INSERT INTO hbo_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","דַּבֵּ֛ר אֶל־בְּנֵ֥י יִשְׂרָאֵ֖ל לֵאמֹ֑ר בַּחֹ֨דֶשׁ הַשְּׁבִיעִ֜י בְּאֶחָ֣ד לַחֹ֗דֶשׁ יִהְיֶ֤ה לָכֶם֙ שַׁבָּתֹ֔ון זִכְרֹ֥ון תְּרוּעָ֖ה מִקְרָא־קֹֽדֶשׁ׃ ");
INSERT INTO hbo_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","כָּל־מְלֶ֥אכֶת עֲבֹדָ֖ה לֹ֣א תַעֲשׂ֑וּ וְהִקְרַבְתֶּ֥ם אִשֶּׁ֖ה לַיהוָֽה׃ ס ");
INSERT INTO hbo_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","אַ֡ךְ בֶּעָשֹׂ֣ור לַחֹדֶשׁ֩ הַשְּׁבִיעִ֨י הַזֶּ֜ה יֹ֧ום הַכִּפֻּרִ֣ים ה֗וּא מִֽקְרָא־קֹ֙דֶשׁ֙ יִהְיֶ֣ה לָכֶ֔ם וְעִנִּיתֶ֖ם אֶת־נַפְשֹׁתֵיכֶ֑ם וְהִקְרַבְתֶּ֥ם אִשֶּׁ֖ה לַיהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","וְכָל־מְלָאכָה֙ לֹ֣א תַעֲשׂ֔וּ בְּעֶ֖צֶם הַיֹּ֣ום הַזֶּ֑ה כִּ֣י יֹ֤ום כִּפֻּרִים֙ ה֔וּא לְכַפֵּ֣ר עֲלֵיכֶ֔ם לִפְנֵ֖י יְהוָ֥ה אֱלֹהֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","כִּ֤י כָל־הַנֶּ֙פֶשׁ֙ אֲשֶׁ֣ר לֹֽא־תְעֻנֶּ֔ה בְּעֶ֖צֶם הַיֹּ֣ום הַזֶּ֑ה וְנִכְרְתָ֖ה מֵֽעַמֶּֽיהָ׃ ");
INSERT INTO hbo_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","וְכָל־הַנֶּ֗פֶשׁ אֲשֶׁ֤ר תַּעֲשֶׂה֙ כָּל־מְלָאכָ֔ה בְּעֶ֖צֶם הַיֹּ֣ום הַזֶּ֑ה וְהַֽאֲבַדְתִּ֛י אֶת־הַנֶּ֥פֶשׁ הַהִ֖וא מִקֶּ֥רֶב עַמָּֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","כָּל־מְלָאכָ֖ה לֹ֣א תַעֲשׂ֑וּ חֻקַּ֤ת עֹולָם֙ לְדֹרֹ֣תֵיכֶ֔ם בְּכֹ֖ל מֹֽשְׁבֹֽתֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","שַׁבַּ֨ת שַׁבָּתֹ֥ון הוּא֙ לָכֶ֔ם וְעִנִּיתֶ֖ם אֶת־נַפְשֹׁתֵיכֶ֑ם בְּתִשְׁעָ֤ה לַחֹ֙דֶשׁ֙ בָּעֶ֔רֶב מֵעֶ֣רֶב עַד־עֶ֔רֶב תִּשְׁבְּת֖וּ שַׁבַּתְּכֶֽם׃ פ ");
INSERT INTO hbo_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","דַּבֵּ֛ר אֶל־בְּנֵ֥י יִשְׂרָאֵ֖ל לֵאמֹ֑ר בַּחֲמִשָּׁ֨ה עָשָׂ֜ר יֹ֗ום לַחֹ֤דֶשׁ הַשְּׁבִיעִי֙ הַזֶּ֔ה חַ֧ג הַסֻּכֹּ֛ות שִׁבְעַ֥ת יָמִ֖ים לַיהֹוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","בַּיֹּ֥ום הָרִאשֹׁ֖ון מִקְרָא־קֹ֑דֶשׁ כָּל־מְלֶ֥אכֶת עֲבֹדָ֖ה לֹ֥א תַעֲשֽׂוּ׃ ");
INSERT INTO hbo_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","שִׁבְעַ֣ת יָמִ֔ים תַּקְרִ֥יבוּ אִשֶּׁ֖ה לַיהוָ֑ה בַּיֹּ֣ום הַשְּׁמִינִ֡י מִקְרָא־קֹדֶשׁ֩ יִהְיֶ֨ה לָכֶ֜ם וְהִקְרַבְתֶּ֨ם אִשֶּׁ֤ה לַֽיהוָה֙ עֲצֶ֣רֶת הִ֔וא כָּל־מְלֶ֥אכֶת עֲבֹדָ֖ה לֹ֥א תַעֲשֽׂוּ׃ ");
INSERT INTO hbo_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","אֵ֚לֶּה מֹועֲדֵ֣י יְהוָ֔ה אֲשֶׁר־תִּקְרְא֥וּ אֹתָ֖ם מִקְרָאֵ֣י קֹ֑דֶשׁ לְהַקְרִ֨יב אִשֶּׁ֜ה לַיהוָ֗ה עֹלָ֧ה וּמִנְחָ֛ה זֶ֥בַח וּנְסָכִ֖ים דְּבַר־יֹ֥ום בְּיֹומֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","מִלְּבַ֖ד שַׁבְּתֹ֣ת יְהוָ֑ה וּמִלְּבַ֣ד מַתְּנֹֽותֵיכֶ֗ם וּמִלְּבַ֤ד כָּל־נִדְרֵיכֶם֙ וּמִלְּבַד֙ כָּל־נִדְבֹ֣ותֵיכֶ֔ם אֲשֶׁ֥ר תִּתְּנ֖וּ לַיהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","אַ֡ךְ בַּחֲמִשָּׁה֩ עָשָׂ֨ר יֹ֜ום לַחֹ֣דֶשׁ הַשְּׁבִיעִ֗י בְּאָסְפְּכֶם֙ אֶת־תְּבוּאַ֣ת הָאָ֔רֶץ תָּחֹ֥גּוּ אֶת־חַג־יְהוָ֖ה שִׁבְעַ֣ת יָמִ֑ים בַּיֹּ֤ום הָֽרִאשֹׁון֙ שַׁבָּתֹ֔ון וּבַיֹּ֥ום הַשְּׁמִינִ֖י שַׁבָּתֹֽון׃ ");
INSERT INTO hbo_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","וּלְקַחְתֶּ֨ם לָכֶ֜ם בַּיֹּ֣ום הָרִאשֹׁ֗ון פְּרִ֨י עֵ֤ץ הָדָר֙ כַּפֹּ֣ת תְּמָרִ֔ים וַעֲנַ֥ף עֵץ־עָבֹ֖ת וְעַרְבֵי־נָ֑חַל וּשְׂמַחְתֶּ֗ם לִפְנֵ֛י יְהוָ֥ה אֱלֹהֵיכֶ֖ם שִׁבְעַ֥ת יָמִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","וְחַגֹּתֶ֤ם אֹתֹו֙ חַ֣ג לַֽיהוָ֔ה שִׁבְעַ֥ת יָמִ֖ים בַּשָּׁנָ֑ה חֻקַּ֤ת עֹולָם֙ לְדֹרֹ֣תֵיכֶ֔ם בַּחֹ֥דֶשׁ הַשְּׁבִיעִ֖י תָּחֹ֥גּוּ אֹתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","בַּסֻּכֹּ֥ת תֵּשְׁב֖וּ שִׁבְעַ֣ת יָמִ֑ים כָּל־הָֽאֶזְרָח֙ בְּיִשְׂרָאֵ֔ל יֵשְׁב֖וּ בַּסֻּכֹּֽת׃ ");
INSERT INTO hbo_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","לְמַעַן֮ יֵדְע֣וּ דֹרֹֽתֵיכֶם֒ כִּ֣י בַסֻּכֹּ֗ות הֹושַׁ֙בְתִּי֙ אֶת־בְּנֵ֣י יִשְׂרָאֵ֔ל בְּהֹוצִיאִ֥י אֹותָ֖ם מֵאֶ֣רֶץ מִצְרָ֑יִם אֲנִ֖י יְהוָ֥ה אֱלֹהֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","וַיְדַבֵּ֣ר מֹשֶׁ֔ה אֶת־מֹעֲדֵ֖י יְהוָ֑ה אֶל־בְּנֵ֖י יִשְׂרָאֵֽל׃ פ ");
INSERT INTO hbo_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","צַ֞ו אֶת־בְּנֵ֣י יִשְׂרָאֵ֗ל וְיִקְח֨וּ אֵלֶ֜יךָ שֶׁ֣מֶן זַ֥יִת זָ֛ךְ כָּתִ֖ית לַמָּאֹ֑ור לְהַעֲלֹ֥ת נֵ֖ר תָּמִֽיד׃ ");
INSERT INTO hbo_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","מִחוּץ֩ לְפָרֹ֨כֶת הָעֵדֻ֜ת בְּאֹ֣הֶל מֹועֵ֗ד יַעֲרֹךְ֩ אֹתֹ֨ו אַהֲרֹ֜ן מֵעֶ֧רֶב עַד־בֹּ֛קֶר לִפְנֵ֥י יְהוָ֖ה תָּמִ֑יד חֻקַּ֥ת עֹולָ֖ם לְדֹרֹֽתֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","עַ֚ל הַמְּנֹרָ֣ה הַטְּהֹרָ֔ה יַעֲרֹ֖ךְ אֶת־הַנֵּרֹ֑ות לִפְנֵ֥י יְהוָ֖ה תָּמִֽיד׃ פ ");
INSERT INTO hbo_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","וְלָקַחְתָּ֣ סֹ֔לֶת וְאָפִיתָ֣ אֹתָ֔הּ שְׁתֵּ֥ים עֶשְׂרֵ֖ה חַלֹּ֑ות שְׁנֵי֙ עֶשְׂרֹנִ֔ים יִהְיֶ֖ה הַֽחַלָּ֥ה הָאֶחָֽת׃ ");
INSERT INTO hbo_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","וְשַׂמְתָּ֥ אֹותָ֛ם שְׁתַּ֥יִם מַֽעֲרָכֹ֖ות שֵׁ֣שׁ הַֽמַּעֲרָ֑כֶת עַ֛ל הַשֻּׁלְחָ֥ן הַטָּהֹ֖ר לִפְנֵ֥י יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","וְנָתַתָּ֥ עַל־הַֽמַּעֲרֶ֖כֶת לְבֹנָ֣ה זַכָּ֑ה וְהָיְתָ֤ה לַלֶּ֙חֶם֙ לְאַזְכָּרָ֔ה אִשֶּׁ֖ה לַֽיהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","בְּיֹ֨ום הַשַּׁבָּ֜ת בְּיֹ֣ום הַשַּׁבָּ֗ת יַֽעַרְכֶ֛נּוּ לִפְנֵ֥י יְהוָ֖ה תָּמִ֑יד מֵאֵ֥ת בְּנֵֽי־יִשְׂרָאֵ֖ל בְּרִ֥ית עֹולָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","וְהָֽיְתָה֙ לְאַהֲרֹ֣ן וּלְבָנָ֔יו וַאֲכָלֻ֖הוּ בְּמָקֹ֣ום קָדֹ֑שׁ כִּ֡י קֹדֶשׁ֩ קֽ͏ָדָשִׁ֨ים ה֥וּא לֹ֛ו מֵאִשֵּׁ֥י יְהוָ֖ה חָק־עֹולָֽם׃ ס ");
INSERT INTO hbo_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","וַיֵּצֵא֙ בֶּן־אִשָּׁ֣ה יִשְׂרְאֵלִ֔ית וְהוּא֙ בֶּן־אִ֣ישׁ מִצְרִ֔י בְּתֹ֖וךְ בְּנֵ֣י יִשְׂרָאֵ֑ל וַיִּנָּצוּ֙ בַּֽמַּחֲנֶ֔ה בֶּ֚ן הַיִּשְׂרְאֵלִ֔ית וְאִ֖ישׁ הַיִּשְׂרְאֵלִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","וַ֠יִּקֹּב בֶּן־הָֽאִשָּׁ֨ה הַיִּשְׂרְאֵלִ֤ית אֶת־הַשֵּׁם֙ וַיְקַלֵּ֔ל וַיָּבִ֥יאוּ אֹתֹ֖ו אֶל־מֹשֶׁ֑ה וְשֵׁ֥ם אִמֹּ֛ו שְׁלֹמִ֥ית בַּת־דִּבְרִ֖י לְמַטֵּה־דָֽן׃ ");
INSERT INTO hbo_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","וַיַּנִּיחֻ֖הוּ בַּמִּשְׁמָ֑ר לִפְרֹ֥שׁ לָהֶ֖ם עַל־פִּ֥י יְהוָֽה׃ פ ");
INSERT INTO hbo_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","הֹוצֵ֣א אֶת־הַֽמְקַלֵּ֗ל אֶל־מִחוּץ֙ לַֽמַּחֲנֶ֔ה וְסָמְכ֧וּ כָֽל־הַשֹּׁמְעִ֛ים אֶת־יְדֵיהֶ֖ם עַל־רֹאשֹׁ֑ו וְרָגְמ֥וּ אֹתֹ֖ו כָּל־הָעֵדָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","וְאֶל־בְּנֵ֥י יִשְׂרָאֵ֖ל תְּדַבֵּ֣ר לֵאמֹ֑ר אִ֥ישׁ אִ֛ישׁ כִּֽי־יְקַלֵּ֥ל אֱלֹהָ֖יו וְנָשָׂ֥א חֶטְאֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","וְנֹקֵ֤ב שֵׁם־יְהוָה֙ מֹ֣ות יוּמָ֔ת רָגֹ֥ום יִרְגְּמוּ־בֹ֖ו כָּל־הָעֵדָ֑ה כַּגֵּר֙ כָּֽאֶזְרָ֔ח בְּנָקְבֹו־שֵׁ֖ם יוּמָֽת׃ ");
INSERT INTO hbo_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","וְאִ֕ישׁ כִּ֥י יַכֶּ֖ה כָּל־נֶ֣פֶשׁ אָדָ֑ם מֹ֖ות יוּמָֽת׃ ");
INSERT INTO hbo_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","וּמַכֵּ֥ה נֶֽפֶשׁ־בְּהֵמָ֖ה יְשַׁלְּמֶ֑נָּה נֶ֖פֶשׁ תַּ֥חַת נָֽפֶשׁ׃ ");
INSERT INTO hbo_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","וְאִ֕ישׁ כִּֽי־יִתֵּ֥ן מ֖וּם בַּעֲמִיתֹ֑ו כַּאֲשֶׁ֣ר עָשָׂ֔ה כֵּ֖ן יֵעָ֥שֶׂה לֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","שֶׁ֚בֶר תַּ֣חַת שֶׁ֔בֶר עַ֚יִן תַּ֣חַת עַ֔יִן שֵׁ֖ן תַּ֣חַת שֵׁ֑ן כַּאֲשֶׁ֨ר יִתֵּ֥ן מוּם֙ בָּֽאָדָ֔ם כֵּ֖ן יִנָּ֥תֶן בֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","וּמַכֵּ֥ה בְהֵמָ֖ה יְשַׁלְּמֶ֑נָּה וּמַכֵּ֥ה אָדָ֖ם יוּמָֽת׃ ");
INSERT INTO hbo_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","מִשְׁפַּ֤ט אֶחָד֙ יִהְיֶ֣ה לָכֶ֔ם כַּגֵּ֥ר כָּאֶזְרָ֖ח יִהְיֶ֑ה כִּ֛י אֲנִ֥י יְהוָ֖ה אֱלֹהֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","וַיְדַבֵּ֣ר מֹשֶׁה֮ אֶל־בְּנֵ֣י יִשְׂרָאֵל֒ וַיֹּוצִ֣יאוּ אֶת־הַֽמְקַלֵּ֗ל אֶל־מִחוּץ֙ לַֽמַּחֲנֶ֔ה וַיִּרְגְּמ֥וּ אֹתֹ֖ו אָ֑בֶן וּבְנֵֽי־יִשְׂרָאֵ֣ל עָשׂ֔וּ כּֽ͏ַאֲשֶׁ֛ר צִוָּ֥ה יְהוָ֖ה אֶת־מֹשֶֽׁה׃ פ ");
INSERT INTO hbo_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","וַיְדַבֵּ֤ר יְהוָה֙ אֶל־מֹשֶׁ֔ה בְּהַ֥ר סִינַ֖י לֵאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","דַּבֵּ֞ר אֶל־בְּנֵ֤י יִשְׂרָאֵל֙ וְאָמַרְתָּ֣ אֲלֵהֶ֔ם כִּ֤י תָבֹ֙אוּ֙ אֶל־הָאָ֔רֶץ אֲשֶׁ֥ר אֲנִ֖י נֹתֵ֣ן לָכֶ֑ם וְשָׁבְתָ֣ה הָאָ֔רֶץ שַׁבָּ֖ת לַיהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","שֵׁ֤שׁ שָׁנִים֙ תִּזְרַ֣ע שָׂדֶ֔ךָ וְשֵׁ֥שׁ שָׁנִ֖ים תִּזְמֹ֣ר כַּרְמֶ֑ךָ וְאָסַפְתָּ֖ אֶת־תְּבוּאָתָֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","וּבַשָּׁנָ֣ה הַשְּׁבִיעִ֗ת שַׁבַּ֤ת שַׁבָּתֹון֙ יִהְיֶ֣ה לָאָ֔רֶץ שַׁבָּ֖ת לַיהוָ֑ה שָֽׂדְךָ֙ לֹ֣א תִזְרָ֔ע וְכַרְמְךָ֖ לֹ֥א תִזְמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","אֵ֣ת סְפִ֤יחַ קְצִֽירְךָ֙ לֹ֣א תִקְצֹ֔ור וְאֶת־עִנְּבֵ֥י נְזִירֶ֖ךָ לֹ֣א תִבְצֹ֑ר שְׁנַ֥ת שַׁבָּתֹ֖ון יִהְיֶ֥ה לָאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","וְ֠הָיְתָה שַׁבַּ֨ת הָאָ֤רֶץ לָכֶם֙ לְאָכְלָ֔ה לְךָ֖ וּלְעַבְדְּךָ֣ וְלַאֲמָתֶ֑ךָ וְלִשְׂכִֽירְךָ֙ וּלְתֹושָׁ֣בְךָ֔ הַגָּרִ֖ים עִמָּֽךְ׃ ");
INSERT INTO hbo_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","וְלִ֨בְהֶמְתְּךָ֔ וְלַֽחַיָּ֖ה אֲשֶׁ֣ר בְּאַרְצֶ֑ךָ תִּהְיֶ֥ה כָל־תְּבוּאָתָ֖הּ לֶאֱכֹֽל׃ ס ");
INSERT INTO hbo_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","וְסָפַרְתָּ֣ לְךָ֗ שֶׁ֚בַע שַׁבְּתֹ֣ת שָׁנִ֔ים שֶׁ֥בַע שָׁנִ֖ים שֶׁ֣בַע פְּעָמִ֑ים וְהָי֣וּ לְךָ֗ יְמֵי֙ שֶׁ֚בַע שַׁבְּתֹ֣ת הַשָּׁנִ֔ים תֵּ֥שַׁע וְאַרְבָּעִ֖ים שָׁנָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","וְהֽ͏ַעֲבַרְתָּ֞ שֹׁופַ֤ר תְּרוּעָה֙ בַּחֹ֣דֶשׁ הַשְּׁבִעִ֔י בֶּעָשֹׂ֖ור לַחֹ֑דֶשׁ בְּיֹום֙ הַכִּפֻּרִ֔ים תַּעֲבִ֥ירוּ שֹׁופָ֖ר בְּכָל־אַרְצְכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","וְקִדַּשְׁתֶּ֗ם אֵ֣ת שְׁנַ֤ת הַחֲמִשִּׁים֙ שָׁנָ֔ה וּקְרָאתֶ֥ם דְּרֹ֛ור בָּאָ֖רֶץ לְכָל־יֹשְׁבֶ֑יהָ יֹובֵ֥ל הִוא֙ תִּהְיֶ֣ה לָכֶ֔ם וְשַׁבְתֶּ֗ם אִ֚ישׁ אֶל־אֲחֻזָּתֹ֔ו וְאִ֥ישׁ אֶל־מִשְׁפַּחְתֹּ֖ו תָּשֻֽׁבוּ׃ ");
INSERT INTO hbo_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","יֹובֵ֣ל הִ֗וא שְׁנַ֛ת הַחֲמִשִּׁ֥ים שָׁנָ֖ה תִּהְיֶ֣ה לָכֶ֑ם לֹ֣א תִזְרָ֔עוּ וְלֹ֤א תִקְצְרוּ֙ אֶת־סְפִיחֶ֔יהָ וְלֹ֥א תִבְצְר֖וּ אֶת־נְזִרֶֽיהָ׃ ");
INSERT INTO hbo_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","כִּ֚י יֹובֵ֣ל הִ֔וא קֹ֖דֶשׁ תִּהְיֶ֣ה לָכֶ֑ם מִן־הַ֨שָּׂדֶ֔ה תֹּאכְל֖וּ אֶת־תְּבוּאָתָֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","בִּשְׁנַ֥ת הַיֹּובֵ֖ל הַזֹּ֑את תָּשֻׁ֕בוּ אִ֖ישׁ אֶל־אֲחֻזָּתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","וְכִֽי־תִמְכְּר֤וּ מִמְכָּר֙ לַעֲמִיתֶ֔ךָ אֹ֥ו קָנֹ֖ה מִיַּ֣ד עֲמִיתֶ֑ךָ אַל־תֹּונ֖וּ אִ֥ישׁ אֶת־אָחִֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","בְּמִסְפַּ֤ר שָׁנִים֙ אַחַ֣ר הַיֹּובֵ֔ל תִּקְנֶ֖ה מֵאֵ֣ת עֲמִיתֶ֑ךָ בְּמִסְפַּ֥ר שְׁנֵֽי־תְבוּאֹ֖ת יִמְכָּר־לָֽךְ׃ ");
INSERT INTO hbo_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","לְפִ֣י ׀ רֹ֣ב הַשָּׁנִ֗ים תַּרְבֶּה֙ מִקְנָתֹ֔ו וּלְפִי֙ מְעֹ֣ט הַשָּׁנִ֔ים תַּמְעִ֖יט מִקְנָתֹ֑ו כִּ֚י מִסְפַּ֣ר תְּבוּאֹ֔ת ה֥וּא מֹכֵ֖ר לָֽךְ׃ ");
INSERT INTO hbo_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","וְלֹ֤א תֹונוּ֙ אִ֣ישׁ אֶת־עֲמִיתֹ֔ו וְיָרֵ֖אתָ מֵֽאֱלֹהֶ֑יךָ כִּ֛י אֲנִ֥י יְהֹוָ֖ה אֱלֹהֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","וַעֲשִׂיתֶם֙ אֶת־חֻקֹּתַ֔י וְאֶת־מִשְׁפָּטַ֥י תִּשְׁמְר֖וּ וַעֲשִׂיתֶ֣ם אֹתָ֑ם וִֽישַׁבְתֶּ֥ם עַל־הָאָ֖רֶץ לָבֶֽטַח׃ ");
INSERT INTO hbo_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","וְנָתְנָ֤ה הָאָ֙רֶץ֙ פִּרְיָ֔הּ וַאֲכַלְתֶּ֖ם לָשֹׂ֑בַע וִֽישַׁבְתֶּ֥ם לָבֶ֖טַח עָלֶֽיהָ׃ ");
INSERT INTO hbo_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","וְכִ֣י תֹאמְר֔וּ מַה־נֹּאכַ֖ל בַּשָּׁנָ֣ה הַשְּׁבִיעִ֑ת הֵ֚ן לֹ֣א נִזְרָ֔ע וְלֹ֥א נֶאֱסֹ֖ף אֶת־תְּבוּאָתֵֽנוּ׃ ");
INSERT INTO hbo_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","וְצִוִּ֤יתִי אֶת־בִּרְכָתִי֙ לָכֶ֔ם בַּשָּׁנָ֖ה הַשִּׁשִּׁ֑ית וְעָשָׂת֙ אֶת־הַתְּבוּאָ֔ה לִשְׁלֹ֖שׁ הַשָּׁנִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","וּזְרַעְתֶּ֗ם אֵ֚ת הַשָּׁנָ֣ה הַשְּׁמִינִ֔ת וַאֲכַלְתֶּ֖ם מִן־הַתְּבוּאָ֣ה יָשָׁ֑ן עַ֣ד ׀ הַשָּׁנָ֣ה הַתְּשִׁיעִ֗ת עַד־בֹּוא֙ תְּב֣וּאָתָ֔הּ תֹּאכְל֖וּ יָשָֽׁן׃ ");
INSERT INTO hbo_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","וְהָאָ֗רֶץ לֹ֤א תִמָּכֵר֙ לִצְמִתֻ֔ת כִּי־לִ֖י הָאָ֑רֶץ כִּֽי־גֵרִ֧ים וְתֹושָׁבִ֛ים אַתֶּ֖ם עִמָּדִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","וּבְכֹ֖ל אֶ֣רֶץ אֲחֻזַּתְכֶ֑ם גְּאֻלָּ֖ה תִּתְּנ֥וּ לָאָֽרֶץ׃ ס ");
INSERT INTO hbo_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","כִּֽי־יָמ֣וּךְ אָחִ֔יךָ וּמָכַ֖ר מֵאֲחֻזָּתֹ֑ו וּבָ֤א גֹֽאֲלֹו֙ הַקָּרֹ֣ב אֵלָ֔יו וְגָאַ֕ל אֵ֖ת מִמְכַּ֥ר אָחִֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","וְאִ֕ישׁ כִּ֛י לֹ֥א יִֽהְיֶה־לֹּ֖ו גֹּאֵ֑ל וְהִשִּׂ֣יגָה יָדֹ֔ו וּמָצָ֖א כְּדֵ֥י גְאֻלָּתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","וְחִשַּׁב֙ אֶת־שְׁנֵ֣י מִמְכָּרֹ֔ו וְהֵשִׁיב֙ אֶת־הָ֣עֹדֵ֔ף לָאִ֖ישׁ אֲשֶׁ֣ר מָֽכַר־לֹ֑ו וְשָׁ֖ב לַאֲחֻזָּתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","וְאִ֨ם לֹֽא־מֽ͏ָצְאָ֜ה יָדֹ֗ו דֵּי֮ הָשִׁ֣יב לֹו֒ וְהָיָ֣ה מִמְכָּרֹ֗ו בְּיַד֙ הַקֹּנֶ֣ה אֹתֹ֔ו עַ֖ד שְׁנַ֣ת הַיֹּובֵ֑ל וְיָצָא֙ בַּיֹּבֵ֔ל וְשָׁ֖ב לַאֲחֻזָּתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","וְאִ֗ישׁ כִּֽי־יִמְכֹּ֤ר בֵּית־מֹושַׁב֙ עִ֣יר חֹומָ֔ה וְהָיְתָה֙ גְּאֻלָּתֹ֔ו עַד־תֹּ֖ם שְׁנַ֣ת מִמְכָּרֹ֑ו יָמִ֖ים תִּהְיֶ֥ה גְאֻלָּתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","וְאִ֣ם לֹֽא־יִגָּאֵ֗ל עַד־מְלֹ֣את לֹו֮ שָׁנָ֣ה תְמִימָה֒ וְ֠קָם הַבַּ֨יִת אֲשֶׁר־בָּעִ֜יר אֲשֶׁר־*לֹא (לֹ֣ו) חֹמָ֗ה לַצְּמִיתֻ֛ת לַקֹּנֶ֥ה אֹתֹ֖ו לְדֹרֹתָ֑יו לֹ֥א יֵצֵ֖א בַּיֹּבֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","וּבָתֵּ֣י הַחֲצֵרִ֗ים אֲשֶׁ֨ר אֵין־לָהֶ֤ם חֹמָה֙ סָבִ֔יב עַל־שְׂדֵ֥ה הָאָ֖רֶץ יֵחָשֵׁ֑ב גְּאֻלָּה֙ תִּהְיֶה־לֹּ֔ו וּבַיֹּבֵ֖ל יֵצֵֽא׃ ");
INSERT INTO hbo_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","וְעָרֵי֙ הַלְוִיִּ֔ם בָּתֵּ֖י עָרֵ֣י אֲחֻזָּתָ֑ם גְּאֻלַּ֥ת עֹולָ֖ם תִּהְיֶ֥ה לַלְוִיִּֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","וַאֲשֶׁ֤ר יִגְאַל֙ מִן־הַלְוִיִּ֔ם וְיָצָ֧א מִמְכַּר־בַּ֛יִת וְעִ֥יר אֲחֻזָּתֹ֖ו בַּיֹּבֵ֑ל כִּ֣י בָתֵּ֞י עָרֵ֣י הַלְוִיִּ֗ם הִ֚וא אֲחֻזָּתָ֔ם בְּתֹ֖וךְ בְּנֵ֥י יִשְׂרָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","וּֽשְׂדֵ֛ה מִגְרַ֥שׁ עָרֵיהֶ֖ם לֹ֣א יִמָּכֵ֑ר כִּֽי־אֲחֻזַּ֥ת עֹולָ֛ם ה֖וּא לָהֶֽם׃ ס ");
INSERT INTO hbo_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","וְכִֽי־יָמ֣וּךְ אָחִ֔יךָ וּמָ֥טָה יָדֹ֖ו עִמָּ֑ךְ וְהֶֽחֱזַ֣קְתָּ בֹּ֔ו גֵּ֧ר וְתֹושָׁ֛ב וָחַ֖י עִמָּֽךְ׃ ");
INSERT INTO hbo_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","אַל־תִּקַּ֤ח מֵֽאִתֹּו֙ נֶ֣שֶׁךְ וְתַרְבִּ֔ית וְיָרֵ֖אתָ מֽ͏ֵאֱלֹהֶ֑יךָ וְחֵ֥י אָחִ֖יךָ עִמָּֽךְ׃ ");
INSERT INTO hbo_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","אֶ֨ת־כַּסְפְּךָ֔ לֹֽא־תִתֵּ֥ן לֹ֖ו בְּנֶ֑שֶׁךְ וּבְמַרְבִּ֖ית לֹא־תִתֵּ֥ן אָכְלֶֽךָ׃ ");
INSERT INTO hbo_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","אֲנִ֗י יְהוָה֙ אֱלֹ֣הֵיכֶ֔ם אֲשֶׁר־הֹוצֵ֥אתִי אֶתְכֶ֖ם מֵאֶ֣רֶץ מִצְרָ֑יִם לָתֵ֤ת לָכֶם֙ אֶת־אֶ֣רֶץ כְּנַ֔עַן לִהְיֹ֥ות לָכֶ֖ם לֵאלֹהִֽים׃ ס ");
INSERT INTO hbo_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","וְכִֽי־יָמ֥וּךְ אָחִ֛יךָ עִמָּ֖ךְ וְנִמְכַּר־לָ֑ךְ לֹא־תַעֲבֹ֥ד בֹּ֖ו עֲבֹ֥דַת עָֽבֶד׃ ");
INSERT INTO hbo_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","כְּשָׂכִ֥יר כְּתֹושָׁ֖ב יִהְיֶ֣ה עִמָּ֑ךְ עַד־שְׁנַ֥ת הַיֹּבֵ֖ל יַעֲבֹ֥ד עִמָּֽךְ׃ ");
INSERT INTO hbo_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","וְיָצָא֙ מֵֽעִמָּ֔ךְ ה֖וּא וּבָנָ֣יו עִמֹּ֑ו וְשָׁב֙ אֶל־מִשְׁפַּחְתֹּ֔ו וְאֶל־אֲחֻזַּ֥ת אֲבֹתָ֖יו יָשֽׁוּב׃ ");
INSERT INTO hbo_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","כִּֽי־עֲבָדַ֣י הֵ֔ם אֲשֶׁר־הֹוצֵ֥אתִי אֹתָ֖ם מֵאֶ֣רֶץ מִצְרָ֑יִם לֹ֥א יִמָּכְר֖וּ מִמְכֶּ֥רֶת עָֽבֶד׃ ");
INSERT INTO hbo_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","לֹא־תִרְדֶּ֥ה בֹ֖ו בְּפָ֑רֶךְ וְיָרֵ֖אתָ מֵאֱלֹהֶֽיךָ׃ ");
INSERT INTO hbo_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","וְעַבְדְּךָ֥ וַאֲמָתְךָ֖ אֲשֶׁ֣ר יִהְיוּ־לָ֑ךְ מֵאֵ֣ת הַגֹּויִ֗ם אֲשֶׁר֙ סְבִיבֹ֣תֵיכֶ֔ם מֵהֶ֥ם תִּקְנ֖וּ עֶ֥בֶד וְאָמָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","וְ֠גַם מִבְּנֵ֨י הַתֹּושָׁבִ֜ים הַגָּרִ֤ים עִמָּכֶם֙ מֵהֶ֣ם תִּקְנ֔וּ וּמִמִּשְׁפַּחְתָּם֙ אֲשֶׁ֣ר עִמָּכֶ֔ם אֲשֶׁ֥ר הֹולִ֖ידוּ בְּאַרְצְכֶ֑ם וְהָי֥וּ לָכֶ֖ם לֽ͏ַאֲחֻזָּֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","וְהִתְנַחֲלְתֶּ֨ם אֹתָ֜ם לִבְנֵיכֶ֤ם אַחֲרֵיכֶם֙ לָרֶ֣שֶׁת אֲחֻזָּ֔ה לְעֹלָ֖ם בָּהֶ֣ם תַּעֲבֹ֑דוּ וּבְאַ֨חֵיכֶ֤ם בְּנֵֽי־יִשְׂרָאֵל֙ אִ֣ישׁ בְּאָחִ֔יו לֹא־תִרְדֶּ֥ה בֹ֖ו בְּפָֽרֶךְ׃ ס ");
INSERT INTO hbo_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","וְכִ֣י תַשִּׂ֗יג יַ֣ד גֵּ֤ר וְתֹושָׁב֙ עִמָּ֔ךְ וּמָ֥ךְ אָחִ֖יךָ עִמֹּ֑ו וְנִמְכַּ֗ר לְגֵ֤ר תֹּושָׁב֙ עִמָּ֔ךְ אֹ֥ו לְעֵ֖קֶר מִשְׁפַּ֥חַת גֵּֽר׃ ");
INSERT INTO hbo_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","אַחֲרֵ֣י נִמְכַּ֔ר גְּאֻלָּ֖ה תִּהְיֶה־לֹּ֑ו אֶחָ֥ד מֵאֶחָ֖יו יִגְאָלֶֽנּוּ׃ ");
INSERT INTO hbo_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","אֹו־דֹדֹ֞ו אֹ֤ו בֶן־דֹּדֹו֙ יִגְאָלֶ֔נּוּ אֹֽו־מִשְּׁאֵ֧ר בְּשָׂרֹ֛ו מִמִּשְׁפַּחְתֹּ֖ו יִגְאָלֶ֑נּוּ אֹֽו־הִשִּׂ֥יגָה יָדֹ֖ו וְנִגְאָֽל׃ ");
INSERT INTO hbo_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","וְחִשַּׁב֙ עִם־קֹנֵ֔הוּ מִשְּׁנַת֙ הִמָּ֣כְרֹו לֹ֔ו עַ֖ד שְׁנַ֣ת הַיֹּבֵ֑ל וְהָיָ֞ה כֶּ֤סֶף מִמְכָּרֹו֙ בְּמִסְפַּ֣ר שָׁנִ֔ים כִּימֵ֥י שָׂכִ֖יר יִהְיֶ֥ה עִמֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","אִם־עֹ֥וד רַבֹּ֖ות בַּשָּׁנִ֑ים לְפִיהֶן֙ יָשִׁ֣יב גְּאֻלָּתֹ֔ו מִכֶּ֖סֶף מִקְנָתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","וְאִם־מְעַ֞ט נִשְׁאַ֧ר בַּשָּׁנִ֛ים עַד־שְׁנַ֥ת הַיֹּבֵ֖ל וְחִשַּׁב־לֹ֑ו כְּפִ֣י שָׁנָ֔יו יָשִׁ֖יב אֶת־גְּאֻלָּתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","כִּשְׂכִ֥יר שָׁנָ֛ה בְּשָׁנָ֖ה יִהְיֶ֣ה עִמֹּ֑ו לֹֽא־יִרְדֶּ֥נּֽוּ בְּפֶ֖רֶךְ לְעֵינֶֽיךָ׃ ");
INSERT INTO hbo_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","וְאִם־לֹ֥א יִגָּאֵ֖ל בְּאֵ֑לֶּה וְיָצָא֙ בִּשְׁנַ֣ת הַיֹּבֵ֔ל ה֖וּא וּבָנָ֥יו עִמֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","כִּֽי־לִ֤י בְנֵֽי־יִשְׂרָאֵל֙ עֲבָדִ֔ים עֲבָדַ֣י הֵ֔ם אֲשֶׁר־הֹוצֵ֥אתִי אֹותָ֖ם מֵאֶ֣רֶץ מִצְרָ֑יִם אֲנִ֖י יְהוָ֥ה אֱלֹהֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","לֹֽא־תַעֲשׂ֨וּ לָכֶ֜ם אֱלִילִ֗ם וּפֶ֤סֶל וּמַצֵּבָה֙ לֹֽא־תָקִ֣ימוּ לָכֶ֔ם וְאֶ֣בֶן מַשְׂכִּ֗ית לֹ֤א תִתְּנוּ֙ בְּאַרְצְכֶ֔ם לְהִֽשְׁתַּחֲוֹ֖ת עָלֶ֑יהָ כִּ֛י אֲנִ֥י יְהוָ֖ה אֱלֹהֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","אֶת־שַׁבְּתֹתַ֣י תִּשְׁמֹ֔רוּ וּמִקְדָּשִׁ֖י תִּירָ֑אוּ אֲנִ֖י יְהוָֽה׃ ס ");
INSERT INTO hbo_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","אִם־בְּחֻקֹּתַ֖י תֵּלֵ֑כוּ וְאֶת־מִצְוֹתַ֣י תִּשְׁמְר֔וּ וַעֲשִׂיתֶ֖ם אֹתָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","וְנָתַתִּ֥י גִשְׁמֵיכֶ֖ם בְּעִתָּ֑ם וְנָתְנָ֤ה הָאָ֙רֶץ֙ יְבוּלָ֔הּ וְעֵ֥ץ הַשָּׂדֶ֖ה יִתֵּ֥ן פִּרְיֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","וְהִשִּׂ֨יג לָכֶ֥ם דַּ֙יִשׁ֙ אֶת־בָּצִ֔יר וּבָצִ֖יר יַשִּׂ֣יג אֶת־זָ֑רַע וַאֲכַלְתֶּ֤ם לַחְמְכֶם֙ לָשֹׂ֔בַע וִֽישַׁבְתֶּ֥ם לָבֶ֖טַח בְּאַרְצְכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","וְנָתַתִּ֤י שָׁלֹום֙ בָּאָ֔רֶץ וּשְׁכַבְתֶּ֖ם וְאֵ֣ין מַחֲרִ֑יד וְהִשְׁבַּתִּ֞י חַיָּ֤ה רָעָה֙ מִן־הָאָ֔רֶץ וְחֶ֖רֶב לֹא־תַעֲבֹ֥ר בְּאַרְצְכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","וּרְדַפְתֶּ֖ם אֶת־אֹיְבֵיכֶ֑ם וְנָפְל֥וּ לִפְנֵיכֶ֖ם לֶחָֽרֶב ");
INSERT INTO hbo_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","וְרָדְפוּ֙ מִכֶּ֤ם חֲמִשָּׁה֙ מֵאָ֔ה וּמֵאָ֥ה מִכֶּ֖ם רְבָבָ֣ה יִרְדֹּ֑פוּ וְנָפְל֧וּ אֹיְבֵיכֶ֛ם לִפְנֵיכֶ֖ם לֶחָֽרֶב׃ ");
INSERT INTO hbo_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","וּפָנִ֣יתִי אֲלֵיכֶ֔ם וְהִפְרֵיתִ֣י אֶתְכֶ֔ם וְהִרְבֵּיתִ֖י אֶתְכֶ֑ם וַהֲקִימֹתִ֥י אֶת־בְּרִיתִ֖י אִתְּכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","וַאֲכַלְתֶּ֥ם יָשָׁ֖ן נֹושָׁ֑ן וְיָשָׁ֕ן מִפְּנֵ֥י חָדָ֖שׁ תֹּוצִֽיאוּ׃ ");
INSERT INTO hbo_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","וְנָתַתִּ֥י מִשְׁכָּנִ֖י בְּתֹוכְכֶ֑ם וְלֹֽא־תִגְעַ֥ל נַפְשִׁ֖י אֶתְכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","וְהִתְהַלַּכְתִּי֙ בְּתֹ֣וכְכֶ֔ם וְהָיִ֥יתִי לָכֶ֖ם לֵֽאלֹהִ֑ים וְאַתֶּ֖ם תִּהְיוּ־לִ֥י לְעָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","אֲנִ֞י יְהוָ֣ה אֱלֹֽהֵיכֶ֗ם אֲשֶׁ֨ר הֹוצֵ֤אתִי אֶתְכֶם֙ מֵאֶ֣רֶץ מִצְרַ֔יִם מִֽהְיֹ֥ת לָהֶ֖ם עֲבָדִ֑ים וָאֶשְׁבֹּר֙ מֹטֹ֣ת עֻלְּכֶ֔ם וָאֹולֵ֥ךְ אֶתְכֶ֖ם קֹֽומְמִיּֽוּת׃ פ ");
INSERT INTO hbo_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","וְאִם־לֹ֥א תִשְׁמְע֖וּ לִ֑י וְלֹ֣א תַעֲשׂ֔וּ אֵ֥ת כָּל־הַמִּצְוֹ֖ת הָאֵֽלֶּה׃ ");
INSERT INTO hbo_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","וְאִם־בְּחֻקֹּתַ֣י תִּמְאָ֔סוּ וְאִ֥ם אֶת־מִשְׁפָּטַ֖י תִּגְעַ֣ל נַפְשְׁכֶ֑ם לְבִלְתִּ֤י עֲשֹׂות֙ אֶת־כָּל־מִצְוֹתַ֔י לְהַפְרְכֶ֖ם אֶת־בְּרִיתִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","אַף־אֲנִ֞י אֽ͏ֶעֱשֶׂה־זֹּ֣את לָכֶ֗ם וְהִפְקַדְתִּ֨י עֲלֵיכֶ֤ם בֶּֽהָלָה֙ אֶת־הַשַּׁחֶ֣פֶת וְאֶת־הַקַּדַּ֔חַת מְכַלֹּ֥ות עֵינַ֖יִם וּמְדִיבֹ֣ת נָ֑פֶשׁ וּזְרַעְתֶּ֤ם לָרִיק֙ זַרְעֲכֶ֔ם וַאֲכָלֻ֖הוּ אֹיְבֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","וְנָתַתִּ֤י פָנַי֙ בָּכֶ֔ם וְנִגַּפְתֶּ֖ם לִפְנֵ֣י אֹיְבֵיכֶ֑ם וְרָד֤וּ בָכֶם֙ שֹֽׂנְאֵיכֶ֔ם וְנַסְתֶּ֖ם וְאֵין־רֹדֵ֥ף אֶתְכֶֽם׃ ס ");
INSERT INTO hbo_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","וְאִ֨ם־עַד־אֵ֔לֶּה לֹ֥א תִשְׁמְע֖וּ לִ֑י וְיָסַפְתִּי֙ לְיַסְּרָ֣ה אֶתְכֶ֔ם שֶׁ֖בַע עַל־חַטֹּאתֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","וְשָׁבַרְתִּ֖י אֶת־גְּאֹ֣ון עֻזְּכֶ֑ם וְנָתַתִּ֤י אֶת־שְׁמֵיכֶם֙ כַּבַּרְזֶ֔ל וְאֶֽת־אַרְצְכֶ֖ם כַּנְּחֻשָֽׁה׃ ");
INSERT INTO hbo_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","וְתַ֥ם לָרִ֖יק כֹּחֲכֶ֑ם וְלֹֽא־תִתֵּ֤ן אַרְצְכֶם֙ אֶת־יְבוּלָ֔הּ וְעֵ֣ץ הָאָ֔רֶץ לֹ֥א יִתֵּ֖ן פִּרְיֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","וְאִם־תֵּֽלְכ֤וּ עִמִּי֙ קֶ֔רִי וְלֹ֥א תֹאב֖וּ לִשְׁמֹ֣עַֽ לִ֑י וְיָסַפְתִּ֤י עֲלֵיכֶם֙ מַכָּ֔ה שֶׁ֖בַע כְּחַטֹּאתֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","וְהִשְׁלַחְתִּ֨י בָכֶ֜ם אֶת־חַיַּ֤ת הַשָּׂדֶה֙ וְשִׁכְּלָ֣ה אֶתְכֶ֔ם וְהִכְרִ֙יתָה֙ אֶת־בְּהֶמְתְּכֶ֔ם וְהִמְעִ֖יטָה אֶתְכֶ֑ם וְנָשַׁ֖מּוּ דַּרְכֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","וְאִ֨ם־בְּאֵ֔לֶּה לֹ֥א תִוָּסְר֖וּ לִ֑י וַהֲלַכְתֶּ֥ם עִמִּ֖י קֶֽרִי׃ ");
INSERT INTO hbo_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","וְהָלַכְתִּ֧י אַף־אֲנִ֛י עִמָּכֶ֖ם בְּקֶ֑רִי וְהִכֵּיתִ֤י אֶתְכֶם֙ גַּם־אָ֔נִי שֶׁ֖בַע עַל־חַטֹּאתֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","וְהֵבֵאתִ֨י עֲלֵיכֶ֜ם חֶ֗רֶב נֹקֶ֙מֶת֙ נְקַם־בְּרִ֔ית וְנֶאֱסַפְתֶּ֖ם אֶל־עָרֵיכֶ֑ם וְשִׁלַּ֤חְתִּי דֶ֙בֶר֙ בְּתֹ֣וכְכֶ֔ם וְנִתַּתֶּ֖ם בְּיַד־אֹויֵֽב׃ ");
INSERT INTO hbo_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","בְּשִׁבְרִ֣י לָכֶם֮ מַטֵּה־לֶחֶם֒ וְ֠אָפוּ עֶ֣שֶׂר נָשִׁ֤ים לַחְמְכֶם֙ בְּתַנּ֣וּר אֶחָ֔ד וְהֵשִׁ֥יבוּ לַחְמְכֶ֖ם בַּמִּשְׁקָ֑ל וַאֲכַלְתֶּ֖ם וְלֹ֥א תִשְׂבָּֽעוּ׃ ס ");
INSERT INTO hbo_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","וְאִ֨ם־בְּזֹ֔את לֹ֥א תִשְׁמְע֖וּ לִ֑י וַהֲלַכְתֶּ֥ם עִמִּ֖י בְּקֶֽרִי׃ ");
INSERT INTO hbo_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","וְהָלַכְתִּ֥י עִמָּכֶ֖ם בַּחֲמַת־קֶ֑רִי וְיִסַּרְתִּ֤י אֶתְכֶם֙ אַף־אָ֔נִי שֶׁ֖בַע עַל־חַטֹּאתֵיכֶם׃ ");
INSERT INTO hbo_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","וַאֲכַלְתֶּ֖ם בְּשַׂ֣ר בְּנֵיכֶ֑ם וּבְשַׂ֥ר בְּנֹתֵיכֶ֖ם תֹּאכֵֽלוּ׃ ");
INSERT INTO hbo_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","וְהִשְׁמַדְתִּ֞י אֶת־בָּמֹֽתֵיכֶ֗ם וְהִכְרַתִּי֙ אֶת־חַמָּ֣נֵיכֶ֔ם וְנָֽתַתִּי֙ אֶת־פִּגְרֵיכֶ֔ם עַל־פִּגְרֵ֖י גִּלּוּלֵיכֶ֑ם וְגָעֲלָ֥ה נַפְשִׁ֖י אֶתְכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","וְנָתַתִּ֤י אֶת־עָֽרֵיכֶם֙ חָרְבָּ֔ה וַהֲשִׁמֹּותִ֖י אֶת־מִקְדְּשֵׁיכֶ֑ם וְלֹ֣א אָרִ֔יחַ בְּרֵ֖יחַ נִיחֹֽחֲכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","וַהֲשִׁמֹּתִ֥י אֲנִ֖י אֶת־הָאָ֑רֶץ וְשָֽׁמְמ֤וּ עָלֶ֙יהָ֙ אֹֽיְבֵיכֶ֔ם הַיֹּשְׁבִ֖ים בָּֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","וְאֶתְכֶם֙ אֱזָרֶ֣ה בַגֹּויִ֔ם וַהֲרִיקֹתִ֥י אַחֲרֵיכֶ֖ם חָ֑רֶב וְהָיְתָ֤ה אַרְצְכֶם֙ שְׁמָמָ֔ה וְעָרֵיכֶ֖ם יִהְי֥וּ חָרְבָּֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","אָז֩ תִּרְצֶ֨ה הָאָ֜רֶץ אֶת־שַׁבְּתֹתֶ֗יהָ כֹּ֚ל יְמֵ֣י הֳשַּׁמָּ֔ה וְאַתֶּ֖ם בְּאֶ֣רֶץ אֹיְבֵיכֶ֑ם אָ֚ז תִּשְׁבַּ֣ת הָאָ֔רֶץ וְהִרְצָ֖ת אֶת־שַׁבְּתֹתֶֽיהָ׃ ");
INSERT INTO hbo_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","כָּל־יְמֵ֥י הָשַּׁמָּ֖ה תִּשְׁבֹּ֑ת אֵ֣ת אֲשֶׁ֧ר לֹֽא־שָׁבְתָ֛ה בְּשַׁבְּתֹתֵיכֶ֖ם בְּשִׁבְתְּכֶ֥ם עָלֶֽיהָ׃ ");
INSERT INTO hbo_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","וְהַנִּשְׁאָרִ֣ים בָּכֶ֔ם וְהֵבֵ֤אתִי מֹ֙רֶךְ֙ בִּלְבָבָ֔ם בְּאַרְצֹ֖ת אֹיְבֵיהֶ֑ם וְרָדַ֣ף אֹתָ֗ם קֹ֚ול עָלֶ֣ה נִדָּ֔ף וְנָס֧וּ מְנֻֽסַת־חֶ֛רֶב וְנָפְל֖וּ וְאֵ֥ין רֹדֵֽף׃ ");
INSERT INTO hbo_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","וְכָשְׁל֧וּ אִישׁ־בְּאָחִ֛יו כְּמִפְּנֵי־חֶ֖רֶב וְרֹדֵ֣ף אָ֑יִן וְלֹא־תִֽהְיֶ֤ה לָכֶם֙ תְּקוּמָ֔ה לִפְנֵ֖י אֹֽיְבֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","וַאֲבַדְתֶּ֖ם בַּגֹּויִ֑ם וְאָכְלָ֣ה אֶתְכֶ֔ם אֶ֖רֶץ אֹיְבֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","וְהַנִּשְׁאָרִ֣ים בָּכֶ֗ם יִמַּ֙קּוּ֙ בּֽ͏ַעֲוֹנָ֔ם בְּאַרְצֹ֖ת אֹיְבֵיכֶ֑ם וְאַ֛ף בַּעֲוֹנֹ֥ת אֲבֹתָ֖ם אִתָּ֥ם יִמָּֽקּוּ׃ ");
INSERT INTO hbo_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","וְהִתְוַדּ֤וּ אֶת־עֲוֹנָם֙ וְאֶת־עֲוֹ֣ן אֲבֹתָ֔ם בְּמַעֲלָ֖ם אֲשֶׁ֣ר מָֽעֲלוּ־בִ֑י וְאַ֕ף אֲשֶׁר־הֽ͏ָלְכ֥וּ עִמִּ֖י בְּקֶֽרִי׃ ");
INSERT INTO hbo_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","אַף־אֲנִ֗י אֵלֵ֤ךְ עִמָּם֙ בְּקֶ֔רִי וְהֵבֵאתִ֣י אֹתָ֔ם בְּאֶ֖רֶץ אֹיְבֵיהֶ֑ם אֹו־אָ֣ז יִכָּנַ֗ע לְבָבָם֙ הֶֽעָרֵ֔ל וְאָ֖ז יִרְצ֥וּ אֶת־עֲוֹנָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","וְזָכַרְתִּ֖י אֶת־בְּרִיתִ֣י יַעֲקֹ֑וב וְאַף֩ אֶת־בְּרִיתִ֨י יִצְחָ֜ק וְאַ֨ף אֶת־בְּרִיתִ֧י אַבְרָהָ֛ם אֶזְכֹּ֖ר וְהָאָ֥רֶץ אֶזְכֹּֽר׃ ");
INSERT INTO hbo_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","וְהָאָרֶץ֩ תֵּעָזֵ֨ב מֵהֶ֜ם וְתִ֣רֶץ אֶת־שַׁבְּתֹתֶ֗יהָ בָּהְשַׁמָּה֙ מֵהֶ֔ם וְהֵ֖ם יִרְצ֣וּ אֶת־עֲוֹנָ֑ם יַ֣עַן וּבְיַ֔עַן בְּמִשְׁפָּטַ֣י מָאָ֔סוּ וְאֶת־חֻקֹּתַ֖י גָּעֲלָ֥ה נַפְשָֽׁם׃ ");
INSERT INTO hbo_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","וְאַף־גַּם־זֹ֠את בִּֽהְיֹותָ֞ם בְּאֶ֣רֶץ אֹֽיְבֵיהֶ֗ם לֹֽא־מְאַסְתִּ֤ים וְלֹֽא־גְעַלְתִּים֙ לְכַלֹּתָ֔ם לְהָפֵ֥ר בְּרִיתִ֖י אִתָּ֑ם כִּ֛י אֲנִ֥י יְהוָ֖ה אֱלֹהֵיהֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","וְזָכַרְתִּ֥י לָהֶ֖ם בְּרִ֣ית רִאשֹׁנִ֑ים אֲשֶׁ֣ר הֹוצֵֽאתִי־אֹתָם֩ מֵאֶ֨רֶץ מִצְרַ֜יִם לְעֵינֵ֣י הַגֹּויִ֗ם לִהְיֹ֥ת לָהֶ֛ם לֵאלֹהִ֖ים אֲנִ֥י יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","אֵ֠לֶּה הַֽחֻקִּ֣ים וְהַמִּשְׁפָּטִים֮ וְהַתֹּורֹת֒ אֲשֶׁר֙ נָתַ֣ן יְהוָ֔ה בֵּינֹ֕ו וּבֵ֖ין בְּנֵ֣י יִשְׂרָאֵ֑ל בְּהַ֥ר סִינַ֖י בְּיַד־מֹשֶֽׁה׃ פ ");
INSERT INTO hbo_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","דַּבֵּ֞ר אֶל־בְּנֵ֤י יִשְׂרָאֵל֙ וְאָמַרְתָּ֣ אֲלֵהֶ֔ם אִ֕ישׁ כִּ֥י יַפְלִ֖א נֶ֑דֶר בְּעֶרְכְּךָ֥ נְפָשֹׁ֖ת לַֽיהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","וְהָיָ֤ה עֶרְכְּךָ֙ הַזָּכָ֔ר מִבֶּן֙ עֶשְׂרִ֣ים שָׁנָ֔ה וְעַ֖ד בֶּן־שִׁשִּׁ֣ים שָׁנָ֑ה וְהָיָ֣ה עֶרְכְּךָ֗ חֲמִשִּׁ֛ים שֶׁ֥קֶל כֶּ֖סֶף בְּשֶׁ֥קֶל הַקֹּֽדֶשׁ׃ ");
INSERT INTO hbo_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","וְאִם־נְקֵבָ֖ה הִ֑וא וְהָיָ֥ה עֶרְכְּךָ֖ שְׁלֹשִׁ֥ים שָֽׁקֶל׃ ");
INSERT INTO hbo_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","וְאִ֨ם מִבֶּן־חָמֵ֜שׁ שָׁנִ֗ים וְעַד֙ בֶּן־עֶשְׂרִ֣ים שָׁנָ֔ה וְהָיָ֧ה עֶרְכְּךָ֛ הַזָּכָ֖ר עֶשְׂרִ֣ים שְׁקָלִ֑ים וְלַנְּקֵבָ֖ה עֲשֶׂ֥רֶת שְׁקָלִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","וְאִ֣ם מִבֶּן־חֹ֗דֶשׁ וְעַד֙ בֶּן־חָמֵ֣שׁ שָׁנִ֔ים וְהָיָ֤ה עֶרְכְּךָ֙ הַזָּכָ֔ר חֲמִשָּׁ֥ה שְׁקָלִ֖ים כָּ֑סֶף וְלַנְּקֵבָ֣ה עֶרְכְּךָ֔ שְׁלֹ֥שֶׁת שְׁקָלִ֖ים כָּֽסֶף׃ ");
INSERT INTO hbo_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","וְ֠אִם מִבֶּן־שִׁשִּׁ֨ים שָׁנָ֤ה וָמַ֙עְלָה֙ אִם־זָכָ֔ר וְהָיָ֣ה עֶרְכְּךָ֔ חֲמִשָּׁ֥ה עָשָׂ֖ר שָׁ֑קֶל וְלַנְּקֵבָ֖ה עֲשָׂרָ֥ה שְׁקָלִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","וְאִם־מָ֥ךְ הוּא֙ מֵֽעֶרְכֶּ֔ךָ וְהֶֽעֱמִידֹו֙ לִפְנֵ֣י הַכֹּהֵ֔ן וְהֶעֱרִ֥יךְ אֹתֹ֖ו הַכֹּהֵ֑ן עַל־פִּ֗י אֲשֶׁ֤ר תַּשִּׂיג֙ יַ֣ד הַנֹּדֵ֔ר יַעֲרִיכֶ֖נּוּ הַכֹּהֵֽן׃ ס ");
INSERT INTO hbo_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","וְאִם־בְּהֵמָ֔ה אֲשֶׁ֨ר יַקְרִ֧יבוּ מִמֶּ֛נָּה קָרְבָּ֖ן לַֽיהוָ֑ה כֹּל֩ אֲשֶׁ֨ר יִתֵּ֥ן מִמֶּ֛נּוּ לַיהוָ֖ה יִֽהְיֶה־קֹּֽדֶשׁ׃ ");
INSERT INTO hbo_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","לֹ֣א יַחֲלִיפֶ֗נּוּ וְלֹֽא־יָמִ֥יר אֹתֹ֛ו טֹ֥וב בְּרָ֖ע אֹו־רַ֣ע בְּטֹ֑וב וְאִם־הָמֵ֨ר יָמִ֤יר בְּהֵמָה֙ בִּבְהֵמָ֔ה וְהָֽיָה־ה֥וּא וּתְמוּרָתֹ֖ו יִֽהְיֶה־קֹּֽדֶשׁ׃ ");
INSERT INTO hbo_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","וְאִם֙ כָּל־בְּהֵמָ֣ה טְמֵאָ֔ה אֲ֠שֶׁר לֹא־יַקְרִ֧יבוּ מִמֶּ֛נָּה קָרְבָּ֖ן לַֽיהוָ֑ה וְהֽ͏ֶעֱמִ֥יד אֶת־הַבְּהֵמָ֖ה לִפְנֵ֥י הַכֹּהֵֽן׃ ");
INSERT INTO hbo_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","וְהֶעֱרִ֤יךְ הַכֹּהֵן֙ אֹתָ֔הּ בֵּ֥ין טֹ֖וב וּבֵ֣ין רָ֑ע כְּעֶרְכְּךָ֥ הַכֹּהֵ֖ן כֵּ֥ן יִהְיֶֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","וְאִם־גָּאֹ֖ל יִגְאָלֶ֑נָּה וְיָסַ֥ף חֲמִישִׁתֹ֖ו עַל־עֶרְכֶּֽךָ׃ ");
INSERT INTO hbo_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","וְאִ֗ישׁ כִּֽי־יַקְדִּ֨שׁ אֶת־בֵּיתֹ֥ו קֹ֙דֶשׁ֙ לַֽיהוָ֔ה וְהֶעֱרִיכֹו֙ הַכֹּהֵ֔ן בֵּ֥ין טֹ֖וב וּבֵ֣ין רָ֑ע כַּאֲשֶׁ֨ר יַעֲרִ֥יךְ אֹתֹ֛ו הַכֹּהֵ֖ן כֵּ֥ן יָקֽוּם׃ ");
INSERT INTO hbo_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","וְאִ֨ם־הַמַּקְדִּ֔ישׁ יִגְאַ֖ל אֶת־בֵּיתֹ֑ו וְ֠יָסַף חֲמִישִׁ֧ית כֶּֽסֶף־עֶרְכְּךָ֛ עָלָ֖יו וְהָ֥יָה לֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","וְאִ֣ם ׀ מִשְּׂדֵ֣ה אֲחֻזָּתֹ֗ו יַקְדִּ֥ישׁ אִישׁ֙ לַֽיהוָ֔ה וְהָיָ֥ה עֶרְכְּךָ֖ לְפִ֣י זַרְעֹ֑ו זֶ֚רַע חֹ֣מֶר שְׂעֹרִ֔ים בַּחֲמִשִּׁ֖ים שֶׁ֥קֶל כָּֽסֶף׃ ");
INSERT INTO hbo_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","אִם־מִשְּׁנַ֥ת הַיֹּבֵ֖ל יַקְדִּ֣ישׁ שָׂדֵ֑הוּ כְּעֶרְכְּךָ֖ יָקֽוּם׃ ");
INSERT INTO hbo_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","וְאִם־אַחַ֣ר הַיֹּבֵל֮ יַקְדִּ֣ישׁ שָׂדֵהוּ֒ וְחִשַּׁב־לֹ֨ו הַכֹּהֵ֜ן אֶת־הַכֶּ֗סֶף עַל־פִּ֤י הַשָּׁנִים֙ הַנֹּ֣ותָרֹ֔ת עַ֖ד שְׁנַ֣ת הַיֹּבֵ֑ל וְנִגְרַ֖ע מֵֽעֶרְכֶּֽךָ׃ ");
INSERT INTO hbo_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","וְאִם־גָּאֹ֤ל יִגְאַל֙ אֶת־הַשָּׂדֶ֔ה הַמַּקְדִּ֖ישׁ אֹתֹ֑ו וְ֠יָסַף חֲמִשִׁ֧ית כֶּֽסֶף־עֶרְכְּךָ֛ עָלָ֖יו וְקָ֥ם לֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","וְאִם־לֹ֤א יִגְאַל֙ אֶת־הַשָּׂדֶ֔ה וְאִם־מָכַ֥ר אֶת־הַשָּׂדֶ֖ה לְאִ֣ישׁ אַחֵ֑ר לֹ֥א יִגָּאֵ֖ל עֹֽוד׃ ");
INSERT INTO hbo_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","וְהָיָ֨ה הַשָּׂדֶ֜ה בְּצֵאתֹ֣ו בַיֹּבֵ֗ל קֹ֛דֶשׁ לַֽיהוָ֖ה כִּשְׂדֵ֣ה הַחֵ֑רֶם לַכֹּהֵ֖ן תִּהְיֶ֥ה אֲחֻזָּתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","וְאִם֙ אֶת־שְׂדֵ֣ה מִקְנָתֹ֔ו אֲשֶׁ֕ר לֹ֖א מִשְּׂדֵ֣ה אֲחֻזָּתֹ֑ו יַקְדִּ֖ישׁ לַֽיהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","וְחִשַּׁב־לֹ֣ו הַכֹּהֵ֗ן אֵ֚ת מִכְסַ֣ת הָֽעֶרְכְּךָ֔ עַ֖ד שְׁנַ֣ת הַיֹּבֵ֑ל וְנָתַ֤ן אֶת־הָעֶרְכְּךָ֙ בַּיֹּ֣ום הַה֔וּא קֹ֖דֶשׁ לַיהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","בִּשְׁנַ֤ת הַיֹּובֵל֙ יָשׁ֣וּב הַשָּׂדֶ֔ה לַאֲשֶׁ֥ר קָנָ֖הוּ מֵאִתֹּ֑ו לַאֲשֶׁר־לֹ֖ו אֲחֻזַּ֥ת הָאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","וְכָל־עֶרְכְּךָ֔ יִהְיֶ֖ה בְּשֶׁ֣קֶל הַקֹּ֑דֶשׁ עֶשְׂרִ֥ים גֵּרָ֖ה יִהְיֶ֥ה הַשָּֽׁקֶל׃ ס ");
INSERT INTO hbo_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","אַךְ־בְּכֹ֞ור אֲשֶׁר־יְבֻכַּ֤ר לַֽיהוָה֙ בִּבְהֵמָ֔ה לֹֽא־יַקְדִּ֥ישׁ אִ֖ישׁ אֹתֹ֑ו אִם־שֹׁ֣ור אִם־שֶׂ֔ה לַֽיהוָ֖ה הֽוּא׃ ");
INSERT INTO hbo_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","וְאִ֨ם בַּבְּהֵמָ֤ה הַטְּמֵאָה֙ וּפָדָ֣ה בְעֶרְכֶּ֔ךָ וְיָסַ֥ף חֲמִשִׁתֹ֖ו עָלָ֑יו וְאִם־לֹ֥א יִגָּאֵ֖ל וְנִמְכַּ֥ר בְּעֶרְכֶּֽךָ׃ ");
INSERT INTO hbo_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","אַךְ־כָּל־חֵ֡רֶם אֲשֶׁ֣ר יַחֲרִם֩ אִ֨ישׁ לַֽיהוָ֜ה מִכָּל־אֲשֶׁר־לֹ֗ו מֵאָדָ֤ם וּבְהֵמָה֙ וּמִשְּׂדֵ֣ה אֲחֻזָּתֹ֔ו לֹ֥א יִמָּכֵ֖ר וְלֹ֣א יִגָּאֵ֑ל כָּל־חֵ֕רֶם קֹֽדֶשׁ־קָֽדָשִׁ֥ים ה֖וּא לַיהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","כָּל־חֵ֗רֶם אֲשֶׁ֧ר יָחֳרַ֛ם מִן־הָאָדָ֖ם לֹ֣א יִפָּדֶ֑ה מֹ֖ות יוּמָֽת׃ ");
INSERT INTO hbo_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","וְכָל־מַעְשַׂ֨ר הָאָ֜רֶץ מִזֶּ֤רַע הָאָ֙רֶץ֙ מִפְּרִ֣י הָעֵ֔ץ לַיהוָ֖ה ה֑וּא קֹ֖דֶשׁ לַֽיהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","וְאִם־גָּאֹ֥ל יִגְאַ֛ל אִ֖ישׁ מִמַּֽעַשְׂרֹ֑ו חֲמִשִׁיתֹ֖ו יֹסֵ֥ף עָלָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","וְכָל־מַעְשַׂ֤ר בָּקָר֙ וָצֹ֔אן כֹּ֥ל אֲשֶׁר־יַעֲבֹ֖ר תַּ֣חַת הַשָּׁ֑בֶט הֽ͏ָעֲשִׂירִ֕י יִֽהְיֶה־קֹּ֖דֶשׁ לַֽיהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","לֹ֧א יְבַקֵּ֛ר בֵּֽין־טֹ֥וב לָרַ֖ע וְלֹ֣א יְמִירֶ֑נּוּ וְאִם־הָמֵ֣ר יְמִירֶ֔נּוּ וְהָֽיָה־ה֧וּא וּתְמוּרָתֹ֛ו יִֽהְיֶה־קֹ֖דֶשׁ לֹ֥א יִגָּאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","אֵ֣לֶּה הַמִּצְוֹ֗ת אֲשֶׁ֨ר צִוָּ֧ה יְהוָ֛ה אֶת־מֹשֶׁ֖ה אֶל־בְּנֵ֣י יִשְׂרָאֵ֑ל בְּהַ֖ר סִינָֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","וַיְדַבֵּ֨ר יְהוָ֧ה אֶל־מֹשֶׁ֛ה בְּמִדְבַּ֥ר סִינַ֖י בְּאֹ֣הֶל מֹועֵ֑ד בְּאֶחָד֩ לַחֹ֨דֶשׁ הַשֵּׁנִ֜י בַּשָּׁנָ֣ה הַשֵּׁנִ֗ית לְצֵאתָ֛ם מֵאֶ֥רֶץ מִצְרַ֖יִם לֵאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","שְׂא֗וּ אֶת־רֹאשׁ֙ כָּל־עֲדַ֣ת בְּנֵֽי־יִשְׂרָאֵ֔ל לְמִשְׁפְּחֹתָ֖ם לְבֵ֣ית אֲבֹתָ֑ם בְּמִסְפַּ֣ר שֵׁמֹ֔ות כָּל־זָכָ֖ר לְגֻלְגְּלֹתָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","מִבֶּ֨ן עֶשְׂרִ֤ים שָׁנָה֙ וָמַ֔עְלָה כָּל־יֹצֵ֥א צָבָ֖א בְּיִשְׂרָאֵ֑ל תִּפְקְד֥וּ אֹתָ֛ם לְצִבְאֹתָ֖ם אַתָּ֥ה וְאַהֲרֹֽן׃ ");
INSERT INTO hbo_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","וְאִתְּכֶ֣ם יִהְי֔וּ אִ֥ישׁ אִ֖ישׁ לַמַּטֶּ֑ה אִ֛ישׁ רֹ֥אשׁ לְבֵית־אֲבֹתָ֖יו הֽוּא׃ ");
INSERT INTO hbo_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","וְאֵ֙לֶּה֙ שְׁמֹ֣ות הָֽאֲנָשִׁ֔ים אֲשֶׁ֥ר יַֽעַמְד֖וּ אִתְּכֶ֑ם לִרְאוּבֵ֕ן אֱלִיצ֖וּר בֶּן־שְׁדֵיאֽוּר׃ ");
INSERT INTO hbo_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","לְשִׁמְעֹ֕ון שְׁלֻמִיאֵ֖ל בֶּן־צוּרִֽישַׁדָּֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","לִֽיהוּדָ֕ה נַחְשֹׁ֖ון בֶּן־עַמִּינָדָֽב׃ ");
INSERT INTO hbo_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","לְיִ֨שָּׂשכָ֔ר נְתַנְאֵ֖ל בֶּן־צוּעָֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","לִזְבוּלֻ֕ן אֱלִיאָ֖ב בֶּן־חֵלֹֽן׃ ");
INSERT INTO hbo_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","לִבְנֵ֣י יֹוסֵ֔ף לְאֶפְרַ֕יִם אֱלִישָׁמָ֖ע בֶּן־עַמִּיה֑וּד לִמְנַשֶּׁ֕ה גַּמְלִיאֵ֖ל בֶּן־פְּדָהצֽוּר׃ ");
INSERT INTO hbo_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","לְבִ֨נְיָמִ֔ן אֲבִידָ֖ן בֶּן־גִּדְעֹנִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","לְדָ֕ן אֲחִיעֶ֖זֶר בֶּן־עַמִּֽישַׁדָּֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","לְאָשֵׁ֕ר פַּגְעִיאֵ֖ל בֶּן־עָכְרָֽן׃ ");
INSERT INTO hbo_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","לְגָ֕ד אֶלְיָסָ֖ף בֶּן־דְּעוּאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","לְנַ֨פְתָּלִ֔י אֲחִירַ֖ע בֶּן־עֵינָֽן׃ ");
INSERT INTO hbo_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","אֵ֚לֶּה *קְרִיאֵי (קְרוּאֵ֣י) הָעֵדָ֔ה נְשִׂיאֵ֖י מַטֹּ֣ות אֲבֹותָ֑ם רָאשֵׁ֛י אַלְפֵ֥י יִשְׂרָאֵ֖ל הֵֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","וַיִּקַּ֥ח מֹשֶׁ֖ה וְאַהֲרֹ֑ן אֵ֚ת הָאֲנָשִׁ֣ים הָאֵ֔לֶּה אֲשֶׁ֥ר נִקְּב֖וּ בְּשֵׁמֹֽות׃ ");
INSERT INTO hbo_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","וְאֵ֨ת כָּל־הָעֵדָ֜ה הִקְהִ֗ילוּ בְּאֶחָד֙ לַחֹ֣דֶשׁ הַשֵּׁנִ֔י וַיִּתְיַֽלְד֥וּ עַל־מִשְׁפְּחֹתָ֖ם לְבֵ֣ית אֲבֹתָ֑ם בְּמִסְפַּ֣ר שֵׁמֹ֗ות מִבֶּ֨ן עֶשְׂרִ֥ים שָׁנָ֛ה וָמַ֖עְלָה לְגֻלְגְּלֹתָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","כַּאֲשֶׁ֛ר צִוָּ֥ה יְהוָ֖ה אֶת־מֹשֶׁ֑ה וַֽיִּפְקְדֵ֖ם בְּמִדְבַּ֥ר סִינָֽי׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","וַיִּהְי֤וּ בְנֵֽי־רְאוּבֵן֙ בְּכֹ֣ר יִשְׂרָאֵ֔ל תֹּולְדֹתָ֥ם לְמִשְׁפְּחֹתָ֖ם לְבֵ֣ית אֲבֹתָ֑ם בְּמִסְפַּ֤ר שֵׁמֹות֙ לְגֻלְגְּלֹתָ֔ם כָּל־זָכָ֗ר מִבֶּ֨ן עֶשְׂרִ֤ים שָׁנָה֙ וָמַ֔עְלָה כֹּ֖ל יֹצֵ֥א צָבָֽא׃ ");
INSERT INTO hbo_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","פְּקֻדֵיהֶ֖ם לְמַטֵּ֣ה רְאוּבֵ֑ן שִׁשָּׁ֧ה וְאַרְבָּעִ֛ים אֶ֖לֶף וַחֲמֵ֥שׁ מֵאֹֽות׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","לִבְנֵ֣י שִׁמְעֹ֔ון תֹּולְדֹתָ֥ם לְמִשְׁפְּחֹתָ֖ם לְבֵ֣ית אֲבֹתָ֑ם פְּקֻדָ֗יו בְּמִסְפַּ֤ר שֵׁמֹות֙ לְגֻלְגְּלֹתָ֔ם כָּל־זָכָ֗ר מִבֶּ֨ן עֶשְׂרִ֤ים שָׁנָה֙ וָמַ֔עְלָה כֹּ֖ל יֹצֵ֥א צָבָֽא׃ ");
INSERT INTO hbo_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","פְּקֻדֵיהֶ֖ם לְמַטֵּ֣ה שִׁמְעֹ֑ון תִּשְׁעָ֧ה וַחֲמִשִּׁ֛ים אֶ֖לֶף וּשְׁלֹ֥שׁ מֵאֹֽות׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","לִבְנֵ֣י גָ֔ד תֹּולְדֹתָ֥ם לְמִשְׁפְּחֹתָ֖ם לְבֵ֣ית אֲבֹתָ֑ם בְּמִסְפַּ֣ר שֵׁמֹ֗ות מִבֶּ֨ן עֶשְׂרִ֤ים שָׁנָה֙ וָמַ֔עְלָה כֹּ֖ל יֹצֵ֥א צָבָֽא׃ ");
INSERT INTO hbo_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","פְּקֻדֵיהֶ֖ם לְמַטֵּ֣ה גָ֑ד חֲמִשָּׁ֤ה וְאַרְבָּעִים֙ אֶ֔לֶף וְשֵׁ֥שׁ מֵאֹ֖ות וַחֲמִשִּֽׁים׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","לִבְנֵ֣י יְהוּדָ֔ה תֹּולְדֹתָ֥ם לְמִשְׁפְּחֹתָ֖ם לְבֵ֣ית אֲבֹתָ֑ם בְּמִסְפַּ֣ר שֵׁמֹ֗ת מִבֶּ֨ן עֶשְׂרִ֤ים שָׁנָה֙ וָמַ֔עְלָה כֹּ֖ל יֹצֵ֥א צָבָֽא׃ ");
INSERT INTO hbo_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","פְּקֻדֵיהֶ֖ם לְמַטֵּ֣ה יְהוּדָ֑ה אַרְבָּעָ֧ה וְשִׁבְעִ֛ים אֶ֖לֶף וְשֵׁ֥שׁ מֵאֹֽות׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","לִבְנֵ֣י יִשָּׂשכָ֔ר תֹּולְדֹתָ֥ם לְמִשְׁפְּחֹתָ֖ם לְבֵ֣ית אֲבֹתָ֑ם בְּמִסְפַּ֣ר שֵׁמֹ֗ת מִבֶּ֨ן עֶשְׂרִ֤ים שָׁנָה֙ וָמַ֔עְלָה כֹּ֖ל יֹצֵ֥א צָבָֽא׃ ");
INSERT INTO hbo_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","פְּקֻדֵיהֶ֖ם לְמַטֵּ֣ה יִשָּׂשכָ֑ר אַרְבָּעָ֧ה וַחֲמִשִּׁ֛ים אֶ֖לֶף וְאַרְבַּ֥ע מֵאֹֽות׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","לִבְנֵ֣י זְבוּלֻ֔ן תֹּולְדֹתָ֥ם לְמִשְׁפְּחֹתָ֖ם לְבֵ֣ית אֲבֹתָ֑ם בְּמִסְפַּ֣ר שֵׁמֹ֗ת מִבֶּ֨ן עֶשְׂרִ֤ים שָׁנָה֙ וָמַ֔עְלָה כֹּ֖ל יֹצֵ֥א צָבָֽא׃ ");
INSERT INTO hbo_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","פְּקֻדֵיהֶ֖ם לְמַטֵּ֣ה זְבוּלֻ֑ן שִׁבְעָ֧ה וַחֲמִשִּׁ֛ים אֶ֖לֶף וְאַרְבַּ֥ע מֵאֹֽות׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","לִבְנֵ֤י יֹוסֵף֙ לִבְנֵ֣י אֶפְרַ֔יִם תֹּולְדֹתָ֥ם לְמִשְׁפְּחֹתָ֖ם לְבֵ֣ית אֲבֹתָ֑ם בְּמִסְפַּ֣ר שֵׁמֹ֗ת מִבֶּ֨ן עֶשְׂרִ֤ים שָׁנָה֙ וָמַ֔עְלָה כֹּ֖ל יֹצֵ֥א צָבָֽא׃ ");
INSERT INTO hbo_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","פְּקֻדֵיהֶ֖ם לְמַטֵּ֣ה אֶפְרָ֑יִם אַרְבָּעִ֥ים אֶ֖לֶף וַחֲמֵ֥שׁ מֵאֹֽות׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","לִבְנֵ֣י מְנַשֶּׁ֔ה תֹּולְדֹתָ֥ם לְמִשְׁפְּחֹתָ֖ם לְבֵ֣ית אֲבֹתָ֑ם בְּמִסְפַּ֣ר שֵׁמֹ֗ות מִבֶּ֨ן עֶשְׂרִ֤ים שָׁנָה֙ וָמַ֔עְלָה כֹּ֖ל יֹצֵ֥א צָבָֽא׃ ");
INSERT INTO hbo_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","פְּקֻדֵיהֶ֖ם לְמַטֵּ֣ה מְנַשֶּׁ֑ה שְׁנַ֧יִם וּשְׁלֹשִׁ֛ים אֶ֖לֶף וּמָאתָֽיִם׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","לִבְנֵ֣י בִנְיָמִ֔ן תֹּולְדֹתָ֥ם לְמִשְׁפְּחֹתָ֖ם לְבֵ֣ית אֲבֹתָ֑ם בְּמִסְפַּ֣ר שֵׁמֹ֗ת מִבֶּ֨ן עֶשְׂרִ֤ים שָׁנָה֙ וָמַ֔עְלָה כֹּ֖ל יֹצֵ֥א צָבָֽא׃ ");
INSERT INTO hbo_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","פְּקֻדֵיהֶ֖ם לְמַטֵּ֣ה בִנְיָמִ֑ן חֲמִשָּׁ֧ה וּשְׁלֹשִׁ֛ים אֶ֖לֶף וְאַרְבַּ֥ע מֵאֹֽות׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","לִבְנֵ֣י דָ֔ן תֹּולְדֹתָ֥ם לְמִשְׁפְּחֹתָ֖ם לְבֵ֣ית אֲבֹתָ֑ם בְּמִסְפַּ֣ר שֵׁמֹ֗ת מִבֶּ֨ן עֶשְׂרִ֤ים שָׁנָה֙ וָמַ֔עְלָה כֹּ֖ל יֹצֵ֥א צָבָֽא׃ ");
INSERT INTO hbo_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","פְּקֻדֵיהֶ֖ם לְמַטֵּ֣ה דָ֑ן שְׁנַ֧יִם וְשִׁשִּׁ֛ים אֶ֖לֶף וּשְׁבַ֥ע מֵאֹֽות׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","לִבְנֵ֣י אָשֵׁ֔ר תֹּולְדֹתָ֥ם לְמִשְׁפְּחֹתָ֖ם לְבֵ֣ית אֲבֹתָ֑ם בְּמִסְפַּ֣ר שֵׁמֹ֗ת מִבֶּ֨ן עֶשְׂרִ֤ים שָׁנָה֙ וָמַ֔עְלָה כֹּ֖ל יֹצֵ֥א צָבָֽא׃ ");
INSERT INTO hbo_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","פְּקֻדֵיהֶ֖ם לְמַטֵּ֣ה אָשֵׁ֑ר אֶחָ֧ד וְאַרְבָּעִ֛ים אֶ֖לֶף וַחֲמֵ֥שׁ מֵאֹֽות׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","בְּנֵ֣י נַפְתָּלִ֔י תֹּולְדֹתָ֥ם לְמִשְׁפְּחֹתָ֖ם לְבֵ֣ית אֲבֹתָ֑ם בְּמִסְפַּ֣ר שֵׁמֹ֗ת מִבֶּ֨ן עֶשְׂרִ֤ים שָׁנָה֙ וָמַ֔עְלָה כֹּ֖ל יֹצֵ֥א צָבָֽא׃ ");
INSERT INTO hbo_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","פְּקֻדֵיהֶ֖ם לְמַטֵּ֣ה נַפְתָּלִ֑י שְׁלֹשָׁ֧ה וַחֲמִשִּׁ֛ים אֶ֖לֶף וְאַרְבַּ֥ע מֵאֹֽות׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","אֵ֣לֶּה הַפְּקֻדִ֡ים אֲשֶׁר֩ פָּקַ֨ד מֹשֶׁ֤ה וְאַהֲרֹן֙ וּנְשִׂיאֵ֣י יִשְׂרָאֵ֔ל שְׁנֵ֥ים עָשָׂ֖ר אִ֑ישׁ אִישׁ־אֶחָ֥ד לְבֵית־אֲבֹתָ֖יו הָיֽוּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","וַיִּֽהְי֛וּ כָּל־פְּקוּדֵ֥י בְנֵֽי־יִשְׂרָאֵ֖ל לְבֵ֣ית אֲבֹתָ֑ם מִבֶּ֨ן עֶשְׂרִ֤ים שָׁנָה֙ וָמַ֔עְלָה כָּל־יֹצֵ֥א צָבָ֖א בְּיִשְׂרָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","וַיִּֽהְיוּ֙ כָּל־הַפְּקֻדִ֔ים שֵׁשׁ־מֵאֹ֥ות אֶ֖לֶף וּשְׁלֹ֣שֶׁת אֲלָפִ֑ים וַחֲמֵ֥שׁ מֵאֹ֖ות וַחֲמִשִּֽׁים׃ ");
INSERT INTO hbo_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","וְהַלְוִיִּ֖ם לְמַטֵּ֣ה אֲבֹתָ֑ם לֹ֥א הָתְפָּקְד֖וּ בְּתֹוכָֽם׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","אַ֣ךְ אֶת־מַטֵּ֤ה לֵוִי֙ לֹ֣א תִפְקֹ֔ד וְאֶת־רֹאשָׁ֖ם לֹ֣א תִשָּׂ֑א בְּתֹ֖וךְ בְּנֵ֥י יִשְׂרָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","וְאַתָּ֡ה הַפְקֵ֣ד אֶת־הַלְוִיִּם֩ עַל־מִשְׁכַּ֨ן הָעֵדֻ֜ת וְעַ֣ל כָּל־כֵּלָיו֮ וְעַ֣ל כָּל־אֲשֶׁר־לֹו֒ הֵ֜מָּה יִשְׂא֤וּ אֶת־הַמִּשְׁכָּן֙ וְאֶת־כָּל־כֵּלָ֔יו וְהֵ֖ם יְשָׁרְתֻ֑הוּ וְסָבִ֥יב לַמִּשְׁכָּ֖ן יַחֲנֽוּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","וּבִנְסֹ֣עַ הַמִּשְׁכָּ֗ן יֹורִ֤ידוּ אֹתֹו֙ הַלְוִיִּ֔ם וּבַחֲנֹת֙ הַמִּשְׁכָּ֔ן יָקִ֥ימוּ אֹתֹ֖ו הַלְוִיִּ֑ם וְהַזָּ֥ר הַקָּרֵ֖ב יוּמָֽת׃ ");
INSERT INTO hbo_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","וְחָנ֖וּ בְּנֵ֣י יִשְׂרָאֵ֑ל אִ֧ישׁ עַֽל־מַחֲנֵ֛הוּ וְאִ֥ישׁ עַל־דִּגְלֹ֖ו לְצִבְאֹתָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","וְהַלְוִיִּ֞ם יַחֲנ֤וּ סָבִיב֙ לְמִשְׁכַּ֣ן הָעֵדֻ֔ת וְלֹֽא־יִהְיֶ֣ה קֶ֔צֶף עַל־עֲדַ֖ת בְּנֵ֣י יִשְׂרָאֵ֑ל וְשָׁמְרוּ֙ הַלְוִיִּ֔ם אֶת־מִשְׁמֶ֖רֶת מִשְׁכַּ֥ן הָעֵדֽוּת׃ ");
INSERT INTO hbo_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","וַֽיַּעֲשׂ֖וּ בְּנֵ֣י יִשְׂרָאֵ֑ל כְּ֠כֹל אֲשֶׁ֨ר צִוָּ֧ה יְהוָ֛ה אֶת־מֹשֶׁ֖ה כֵּ֥ן עָשֽׂוּ׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","וַיְדַבֵּ֣ר יְהוָ֔ה אֶל־מֹשֶׁ֥ה וְאֶֽל־אַהֲרֹ֖ן לֵאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","אִ֣ישׁ עַל־דִּגְלֹ֤ו בְאֹתֹת֙ לְבֵ֣ית אֲבֹתָ֔ם יַחֲנ֖וּ בְּנֵ֣י יִשְׂרָאֵ֑ל מִנֶּ֕גֶד סָבִ֥יב לְאֹֽהֶל־מֹועֵ֖ד יַחֲנֽוּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","וְהַחֹנִים֙ קֵ֣דְמָה מִזְרָ֔חָה דֶּ֛גֶל מַחֲנֵ֥ה יְהוּדָ֖ה לְצִבְאֹתָ֑ם וְנָשִׂיא֙ לִבְנֵ֣י יְהוּדָ֔ה נַחְשֹׁ֖ון בֶּן־עַמִּינָדָֽב׃ ");
INSERT INTO hbo_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","וּצְבָאֹ֖ו וּפְקֻדֵיהֶ֑ם אַרְבָּעָ֧ה וְשִׁבְעִ֛ים אֶ֖לֶף וְשֵׁ֥שׁ מֵאֹֽות׃ ");
INSERT INTO hbo_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","וְהַחֹנִ֥ים עָלָ֖יו מַטֵּ֣ה יִשָּׂשכָ֑ר וְנָשִׂיא֙ לִבְנֵ֣י יִשָּׂשכָ֔ר נְתַנְאֵ֖ל בֶּן־צוּעָֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","וּצְבָאֹ֖ו וּפְקֻדָ֑יו אַרְבָּעָ֧ה וַחֲמִשִּׁ֛ים אֶ֖לֶף וְאַרְבַּ֥ע מֵאֹֽות׃ ס ");
INSERT INTO hbo_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","מַטֵּ֖ה זְבוּלֻ֑ן וְנָשִׂיא֙ לִבְנֵ֣י זְבוּלֻ֔ן אֱלִיאָ֖ב בֶּן־חֵלֹֽן׃ ");
INSERT INTO hbo_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","וּצְבָאֹ֖ו וּפְקֻדָ֑יו שִׁבְעָ֧ה וַחֲמִשִּׁ֛ים אֶ֖לֶף וְאַרְבַּ֥ע מֵאֹֽות׃ ");
INSERT INTO hbo_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","כָּֽל־הַפְּקֻדִ֞ים לְמַחֲנֵ֣ה יְהוּדָ֗ה מְאַ֨ת אֶ֜לֶף וּשְׁמֹנִ֥ים אֶ֛לֶף וְשֵֽׁשֶׁת־אֲלָפִ֥ים וְאַרְבַּע־מֵאֹ֖ות לְצִבְאֹתָ֑ם רִאשֹׁנָ֖ה יִסָּֽעוּ׃ ס ");
INSERT INTO hbo_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","דֶּ֣גֶל מַחֲנֵ֧ה רְאוּבֵ֛ן תֵּימָ֖נָה לְצִבְאֹתָ֑ם וְנָשִׂיא֙ לִבְנֵ֣י רְאוּבֵ֔ן אֱלִיצ֖וּר בֶּן־שְׁדֵיאֽוּר׃ ");
INSERT INTO hbo_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","וּצְבָאֹ֖ו וּפְקֻדָ֑יו שִׁשָּׁ֧ה וְאַרְבָּעִ֛ים אֶ֖לֶף וַחֲמֵ֥שׁ מֵאֹֽות׃ ");
INSERT INTO hbo_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","וְהַחֹונִ֥ם עָלָ֖יו מַטֵּ֣ה שִׁמְעֹ֑ון וְנָשִׂיא֙ לִבְנֵ֣י שִׁמְעֹ֔ון שְׁלֻמִיאֵ֖ל בֶּן־צוּרִֽי־שַׁדָּֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","וּצְבָאֹ֖ו וּפְקֻדֵיהֶ֑ם תִּשְׁעָ֧ה וַחֲמִשִּׁ֛ים אֶ֖לֶף וּשְׁלֹ֥שׁ מֵאֹֽות׃ ");
INSERT INTO hbo_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","וְמַטֵּ֖ה גָּ֑ד וְנָשִׂיא֙ לִבְנֵ֣י גָ֔ד אֶלְיָסָ֖ף בֶּן־רְעוּאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","וּצְבָאֹ֖ו וּפְקֻדֵיהֶ֑ם חֲמִשָּׁ֤ה וְאַרְבָּעִים֙ אֶ֔לֶף וְשֵׁ֥שׁ מֵאֹ֖ות וַחֲמִשִּֽׁים׃ ");
INSERT INTO hbo_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","כָּֽל־הַפְּקֻדִ֞ים לְמַחֲנֵ֣ה רְאוּבֵ֗ן מְאַ֨ת אֶ֜לֶף וְאֶחָ֨ד וַחֲמִשִּׁ֥ים אֶ֛לֶף וְאַרְבַּע־מֵאֹ֥ות וַחֲמִשִּׁ֖ים לְצִבְאֹתָ֑ם וּשְׁנִיִּ֖ם יִסָּֽעוּ׃ ס ");
INSERT INTO hbo_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","וְנָסַ֧ע אֹֽהֶל־מֹועֵ֛ד מַחֲנֵ֥ה הַלְוִיִּ֖ם בְּתֹ֣וךְ הַֽמַּחֲנֹ֑ת כַּאֲשֶׁ֤ר יַחֲנוּ֙ כֵּ֣ן יִסָּ֔עוּ אִ֥ישׁ עַל־יָדֹ֖ו לְדִגְלֵיהֶֽם׃ ס ");
INSERT INTO hbo_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","דֶּ֣גֶל מַחֲנֵ֥ה אֶפְרַ֛יִם לְצִבְאֹתָ֖ם יָ֑מָּה וְנָשִׂיא֙ לִבְנֵ֣י אֶפְרַ֔יִם אֱלִישָׁמָ֖ע בֶּן־עַמִּיהֽוּד׃ ");
INSERT INTO hbo_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","וּצְבָאֹ֖ו וּפְקֻדֵיהֶ֑ם אַרְבָּעִ֥ים אֶ֖לֶף וַחֲמֵ֥שׁ מֵאֹֽות׃ ");
INSERT INTO hbo_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","וְעָלָ֖יו מַטֵּ֣ה מְנַשֶּׁ֑ה וְנָשִׂיא֙ לִבְנֵ֣י מְנַשֶּׁ֔ה גַּמְלִיאֵ֖ל בֶּן־פְּדָהצֽוּר׃ ");
INSERT INTO hbo_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","וּצְבָאֹ֖ו וּפְקֻדֵיהֶ֑ם שְׁנַ֧יִם וּשְׁלֹשִׁ֛ים אֶ֖לֶף וּמָאתָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","וּמַטֵּ֖ה בִּנְיָמִ֑ן וְנָשִׂיא֙ לִבְנֵ֣י בִנְיָמִ֔ן אֲבִידָ֖ן בֶּן־גִּדְעֹנִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","וּצְבָאֹ֖ו וּפְקֻדֵיהֶ֑ם חֲמִשָּׁ֧ה וּשְׁלֹשִׁ֛ים אֶ֖לֶף וְאַרְבַּ֥ע מֵאֹֽות׃ ");
INSERT INTO hbo_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","כָּֽל־הַפְּקֻדִ֞ים לְמַחֲנֵ֣ה אֶפְרַ֗יִם מְאַ֥ת אֶ֛לֶף וּשְׁמֹֽנַת־אֲלָפִ֥ים וּמֵאָ֖ה לְצִבְאֹתָ֑ם וּשְׁלִשִׁ֖ים יִסָּֽעוּ׃ ס ");
INSERT INTO hbo_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","דֶּ֣גֶל מַחֲנֵ֥ה דָ֛ן צָפֹ֖נָה לְצִבְאֹתָ֑ם וְנָשִׂיא֙ לִבְנֵ֣י דָ֔ן אֲחִיעֶ֖זֶר בֶּן־עַמִּֽישַׁדָּֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","וּצְבָאֹ֖ו וּפְקֻדֵיהֶ֑ם שְׁנַ֧יִם וְשִׁשִּׁ֛ים אֶ֖לֶף וּשְׁבַ֥ע מֵאֹֽות׃ ");
INSERT INTO hbo_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","וְהַחֹנִ֥ים עָלָ֖יו מַטֵּ֣ה אָשֵׁ֑ר וְנָשִׂיא֙ לִבְנֵ֣י אָשֵׁ֔ר פַּגְעִיאֵ֖ל בֶּן־עָכְרָֽן׃ ");
INSERT INTO hbo_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","וּצְבָאֹ֖ו וּפְקֻדֵיהֶ֑ם אֶחָ֧ד וְאַרְבָּעִ֛ים אֶ֖לֶף וַחֲמֵ֥שׁ מֵאֹֽות׃ ");
INSERT INTO hbo_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","וּמַטֵּ֖ה נַפְתָּלִ֑י וְנָשִׂיא֙ לִבְנֵ֣י נַפְתָּלִ֔י אֲחִירַ֖ע בֶּן־עֵינָֽן׃ ");
INSERT INTO hbo_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","וּצְבָאֹ֖ו וּפְקֻדֵיהֶ֑ם שְׁלֹשָׁ֧ה וַחֲמִשִּׁ֛ים אֶ֖לֶף וְאַרְבַּ֥ע מֵאֹֽות׃ ");
INSERT INTO hbo_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","כָּל־הַפְּקֻדִים֙ לְמַ֣חֲנֵה דָ֔ן מְאַ֣ת אֶ֗לֶף וְשִׁבְעָ֧ה וַחֲמִשִּׁ֛ים אֶ֖לֶף וְשֵׁ֣שׁ מֵאֹ֑ות לָאַחֲרֹנָ֥ה יִסְע֖וּ לְדִגְלֵיהֶֽם׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","אֵ֛לֶּה פְּקוּדֵ֥י בְנֵֽי־יִשְׂרָאֵ֖ל לְבֵ֣ית אֲבֹתָ֑ם כָּל־פְּקוּדֵ֤י הַֽמַּחֲנֹת֙ לְצִבְאֹתָ֔ם שֵׁשׁ־מֵאֹ֥ות אֶ֙לֶף֙ וּשְׁלֹ֣שֶׁת אֲלָפִ֔ים וַחֲמֵ֥שׁ מֵאֹ֖ות וַחֲמִשִּֽׁים׃ ");
INSERT INTO hbo_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","וְהַ֨לְוִיִּ֔ם לֹ֣א הָתְפָּקְד֔וּ בְּתֹ֖וךְ בְּנֵ֣י יִשְׂרָאֵ֑ל כַּאֲשֶׁ֛ר צִוָּ֥ה יְהוָ֖ה אֶת־מֹשֶֽׁה׃ ");
INSERT INTO hbo_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","וֽ͏ַיַּעֲשׂ֖וּ בְּנֵ֣י יִשְׂרָאֵ֑ל כְּ֠כֹל אֲשֶׁר־צִוָּ֨ה יְהוָ֜ה אֶת־מֹשֶׁ֗ה כֵּֽן־חָנ֤וּ לְדִגְלֵיהֶם֙ וְכֵ֣ן נָסָ֔עוּ אִ֥ישׁ לְמִשְׁפְּחֹתָ֖יו עַל־בֵּ֥ית אֲבֹתָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","וְאֵ֛לֶּה תֹּולְדֹ֥ת אַהֲרֹ֖ן וּמֹשֶׁ֑ה בְּיֹ֗ום דִּבֶּ֧ר יְהוָ֛ה אֶת־מֹשֶׁ֖ה בְּהַ֥ר סִינָֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","וְאֵ֛לֶּה שְׁמֹ֥ות בְּֽנֵי־אַהֲרֹ֖ן הַבְּכֹ֣ור ׀ נָדָ֑ב וַאֲבִיה֕וּא אֶלְעָזָ֖ר וְאִיתָמָֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","אֵ֗לֶּה שְׁמֹות֙ בְּנֵ֣י אַהֲרֹ֔ן הַכֹּהֲנִ֖ים הַמְּשֻׁחִ֑ים אֲשֶׁר־מִלֵּ֥א יָדָ֖ם לְכַהֵֽן׃ ");
INSERT INTO hbo_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","וַיָּ֣מָת נָדָ֣ב וַאֲבִיה֣וּא לִפְנֵ֣י יְהוָ֡ה בְּֽהַקְרִבָם֩ אֵ֨שׁ זָרָ֜ה לִפְנֵ֤י יְהוָה֙ בְּמִדְבַּ֣ר סִינַ֔י וּבָנִ֖ים לֹא־הָי֣וּ לָהֶ֑ם וַיְכַהֵ֤ן אֶלְעָזָר֙ וְאִ֣יתָמָ֔ר עַל־פְּנֵ֖י אַהֲרֹ֥ן אֲבִיהֶֽם׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","הַקְרֵב֙ אֶת־מַטֵּ֣ה לֵוִ֔י וְֽהַעֲמַדְתָּ֣ אֹתֹ֔ו לִפְנֵ֖י אַהֲרֹ֣ן הַכֹּהֵ֑ן וְשֵׁרְת֖וּ אֹתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","וְשָׁמְר֣וּ אֶת־מִשְׁמַרְתֹּ֗ו וְאֶת־מִשְׁמֶ֙רֶת֙ כָּל־הָ֣עֵדָ֔ה לִפְנֵ֖י אֹ֣הֶל מֹועֵ֑ד לַעֲבֹ֖ד אֶת־עֲבֹדַ֥ת הַמִּשְׁכָּֽן׃ ");
INSERT INTO hbo_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","וְשָׁמְר֗וּ אֶֽת־כָּל־כְּלֵי֙ אֹ֣הֶל מֹועֵ֔ד וְאֶת־מִשְׁמֶ֖רֶת בְּנֵ֣י יִשְׂרָאֵ֑ל לַעֲבֹ֖ד אֶת־עֲבֹדַ֥ת הַמִּשְׁכָּֽן׃ ");
INSERT INTO hbo_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","וְנָתַתָּה֙ אֶת־הַלְוִיִּ֔ם לְאַהֲרֹ֖ן וּלְבָנָ֑יו נְתוּנִ֨ם נְתוּנִ֥ם הֵ֙מָּה֙ לֹ֔ו מֵאֵ֖ת בְּנֵ֥י יִשְׂרָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","וְאֶת־אַהֲרֹ֤ן וְאֶת־בָּנָיו֙ תִּפְקֹ֔ד וְשָׁמְר֖וּ אֶת־כְּהֻנָּתָ֑ם וְהַזָּ֥ר הַקָּרֵ֖ב יוּמָֽת׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","וַאֲנִ֞י הִנֵּ֧ה לָקַ֣חְתִּי אֶת־הַלְוִיִּ֗ם מִתֹּוךְ֙ בְּנֵ֣י יִשְׂרָאֵ֔ל תַּ֧חַת כָּל־בְּכֹ֛ור פֶּ֥טֶר רֶ֖חֶם מִבְּנֵ֣י יִשְׂרָאֵ֑ל וְהָ֥יוּ לִ֖י הַלְוִיִּֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","כִּ֣י לִי֮ כָּל־בְּכֹור֒ בְּיֹום֩ הַכֹּתִ֨י כָל־בְּכֹ֜ור בְּאֶ֣רֶץ מִצְרַ֗יִם הִקְדַּ֨שְׁתִּי לִ֤י כָל־בְּכֹור֙ בְּיִשְׂרָאֵ֔ל מֵאָדָ֖ם עַד־בְּהֵמָ֑ה לִ֥י יִהְי֖וּ אֲנִ֥י יְהוָֽה׃ ס ");
INSERT INTO hbo_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","וַיְדַבֵּ֤ר יְהוָה֙ אֶל־מֹשֶׁ֔ה בְּמִדְבַּ֥ר סִינַ֖י לֵאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","פְּקֹד֙ אֶת־בְּנֵ֣י לֵוִ֔י לְבֵ֥ית אֲבֹתָ֖ם לְמִשְׁפְּחֹתָ֑ם כָּל־זָכָ֛ר מִבֶּן־חֹ֥דֶשׁ וָמַ֖עְלָה תִּפְקְדֵֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","וַיִּפְקֹ֥ד אֹתָ֛ם מֹשֶׁ֖ה עַל־פִּ֣י יְהוָ֑ה כַּאֲשֶׁ֖ר צֻוָּֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","וַיִּֽהְיוּ־אֵ֥לֶּה בְנֵֽי־לֵוִ֖י בִּשְׁמֹתָ֑ם גֵּרְשֹׁ֕ון וּקְהָ֖ת וּמְרָרִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","וְאֵ֛לֶּה שְׁמֹ֥ות בְּֽנֵי־גֵרְשֹׁ֖ון לְמִשְׁפְּחֹתָ֑ם לִבְנִ֖י וְשִׁמְעִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","וּבְנֵ֥י קְהָ֖ת לְמִשְׁפְּחֹתָ֑ם עַמְרָ֣ם וְיִצְהָ֔ר חֶבְרֹ֖ון וְעֻזִּיאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","וּבְנֵ֧י מְרָרִ֛י לְמִשְׁפְּחֹתָ֖ם מַחְלִ֣י וּמוּשִׁ֑י אֵ֥לֶּה הֵ֛ם מִשְׁפְּחֹ֥ת הַלֵּוִ֖י לְבֵ֥ית אֲבֹתָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","לְגֵ֣רְשֹׁ֔ון מִשְׁפַּ֙חַת֙ הַלִּבְנִ֔י וּמִשְׁפַּ֖חַת הַשִּׁמְעִ֑י אֵ֣לֶּה הֵ֔ם מִשְׁפְּחֹ֖ת הַגֵּרְשֻׁנִּֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","פְּקֻדֵיהֶם֙ בְּמִסְפַּ֣ר כָּל־זָכָ֔ר מִבֶּן־חֹ֖דֶשׁ וָמָ֑עְלָה פְּקֻ֣דֵיהֶ֔ם שִׁבְעַ֥ת אֲלָפִ֖ים וַחֲמֵ֥שׁ מֵאֹֽות׃ ");
INSERT INTO hbo_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","מִשְׁפְּחֹ֖ת הַגֵּרְשֻׁנִּ֑י אַחֲרֵ֧י הַמִּשְׁכָּ֛ן יַחֲנ֖וּ יָֽמָּה׃ ");
INSERT INTO hbo_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","וּנְשִׂ֥יא בֵֽית־אָ֖ב לַגֵּרְשֻׁנִּ֑י אֶלְיָסָ֖ף בֶּן־לָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","וּמִשְׁמֶ֤רֶת בְּנֵֽי־גֵרְשֹׁון֙ בְּאֹ֣הֶל מֹועֵ֔ד הַמִּשְׁכָּ֖ן וְהָאֹ֑הֶל מִכְסֵ֕הוּ וּמָסַ֕ךְ פֶּ֖תַח אֹ֥הֶל מֹועֵֽד׃ ");
INSERT INTO hbo_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","וְקַלְעֵ֣י הֶֽחָצֵ֗ר וְאֶת־מָסַךְ֙ פֶּ֣תַח הֶֽחָצֵ֔ר אֲשֶׁ֧ר עַל־הַמִּשְׁכָּ֛ן וְעַל־הַמִּזְבֵּ֖חַ סָבִ֑יב וְאֵת֙ מֵֽיתָרָ֔יו לְכֹ֖ל עֲבֹדָתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","וְלִקְהָ֗ת מִשְׁפַּ֤חַת הֽ͏ַעַמְרָמִי֙ וּמִשְׁפַּ֣חַת הַיִּצְהָרִ֔י וּמִשְׁפַּ֙חַת֙ הֽ͏ַחֶבְרֹנִ֔י וּמִשְׁפַּ֖חַת הָֽעָזִּיאֵלִ֑י אֵ֥לֶּה הֵ֖ם מִשְׁפְּחֹ֥ת הַקְּהָתִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","בְּמִסְפַּר֙ כָּל־זָכָ֔ר מִבֶּן־חֹ֖דֶשׁ וָמָ֑עְלָה שְׁמֹנַ֤ת אֲלָפִים֙ וְשֵׁ֣שׁ מֵאֹ֔ות שֹׁמְרֵ֖י מִשְׁמֶ֥רֶת הַקֹּֽדֶשׁ׃ ");
INSERT INTO hbo_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","מִשְׁפְּחֹ֥ת בְּנֵי־קְהָ֖ת יַחֲנ֑וּ עַ֛ל יֶ֥רֶךְ הַמִּשְׁכָּ֖ן תֵּימָֽנָה׃ ");
INSERT INTO hbo_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","וּנְשִׂ֥יא בֵֽית־אָ֖ב לְמִשְׁפְּחֹ֣ת הַקְּהָתִ֑י אֶלִיצָפָ֖ן בֶּן־עֻזִּיאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","וּמִשְׁמַרְתָּ֗ם הָאָרֹ֤ן וְהַשֻּׁלְחָן֙ וְהַמְּנֹרָ֣ה וְהַֽמִּזְבְּחֹ֔ת וּכְלֵ֣י הַקֹּ֔דֶשׁ אֲשֶׁ֥ר יְשָׁרְת֖וּ בָּהֶ֑ם וְהַ֨מָּסָ֔ךְ וְכֹ֖ל עֲבֹדָתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","וּנְשִׂיא֙ נְשִׂיאֵ֣י הַלֵּוִ֔י אֶלְעָזָ֖ר בֶּן־אַהֲרֹ֣ן הַכֹּהֵ֑ן פְּקֻדַּ֕ת שֹׁמְרֵ֖י מִשְׁמֶ֥רֶת הַקֹּֽדֶשׁ׃ ");
INSERT INTO hbo_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","לִמְרָרִ֕י מִשְׁפַּ֙חַת֙ הַמַּחְלִ֔י וּמִשְׁפַּ֖חַת הַמּוּשִׁ֑י אֵ֥לֶּה הֵ֖ם מִשְׁפְּחֹ֥ת מְרָרִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","וּפְקֻדֵיהֶם֙ בְּמִסְפַּ֣ר כָּל־זָכָ֔ר מִבֶּן־חֹ֖דֶשׁ וָמָ֑עְלָה שֵׁ֥שֶׁת אֲלָפִ֖ים וּמָאתָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","וּנְשִׂ֤יא בֵֽית־אָב֙ לְמִשְׁפְּחֹ֣ת מְרָרִ֔י צוּרִיאֵ֖ל בֶּן־אֲבִיחָ֑יִל עַ֣ל יֶ֧רֶךְ הַמִּשְׁכָּ֛ן יַחֲנ֖וּ צָפֹֽנָה׃ ");
INSERT INTO hbo_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","וּפְקֻדַּ֣ת מִשְׁמֶרֶת֮ בְּנֵ֣י מְרָרִי֒ קַרְשֵׁי֙ הַמִּשְׁכָּ֔ן וּבְרִיחָ֖יו וְעַמֻּדָ֣יו וַאֲדָנָ֑יו וְכָל־כֵּלָ֔יו וְכֹ֖ל עֲבֹדָתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","וְעַמֻּדֵ֧י הֶחָצֵ֛ר סָבִ֖יב וְאַדְנֵיהֶ֑ם וִיתֵדֹתָ֖ם וּמֵֽיתְרֵיהֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","וְהַחֹנִ֣ים לִפְנֵ֣י הַמִּשְׁכָּ֡ן קֵ֣דְמָה לִפְנֵי֩ אֹֽהֶל־מֹועֵ֨ד ׀ מִזְרָ֜חָה מֹשֶׁ֣ה ׀ וְאַהֲרֹ֣ן וּבָנָ֗יו שֹֽׁמְרִים֙ מִשְׁמֶ֣רֶת הַמִּקְדָּ֔שׁ לְמִשְׁמֶ֖רֶת בְּנֵ֣י יִשְׂרָאֵ֑ל וְהַזָּ֥ר הַקָּרֵ֖ב יוּמָֽת׃ ");
INSERT INTO hbo_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","כָּל־פְּקוּדֵ֨י הַלְוִיִּ֜ם אֲשֶׁר֩ פָּקַ֨ד מֹשֶׁ֧ה וְׄאַׄהֲׄרֹ֛ׄןׄ עַל־פִּ֥י יְהוָ֖ה לְמִשְׁפְּחֹתָ֑ם כָּל־זָכָר֙ מִבֶּן־חֹ֣דֶשׁ וָמַ֔עְלָה שְׁנַ֥יִם וְעֶשְׂרִ֖ים אָֽלֶף׃ ס ");
INSERT INTO hbo_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","וַיֹּ֨אמֶר יְהוָ֜ה אֶל־מֹשֶׁ֗ה פְּקֹ֨ד כָּל־בְּכֹ֤ר זָכָר֙ לִבְנֵ֣י יִשְׂרָאֵ֔ל מִבֶּן־חֹ֖דֶשׁ וָמָ֑עְלָה וְשָׂ֕א אֵ֖ת מִסְפַּ֥ר שְׁמֹתָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","וְלָקַחְתָּ֨ אֶת־הַלְוִיִּ֥ם לִי֙ אֲנִ֣י יְהוָ֔ה תַּ֥חַת כָּל־בְּכֹ֖ר בִּבְנֵ֣י יִשְׂרָאֵ֑ל וְאֵת֙ בֶּהֱמַ֣ת הַלְוִיִּ֔ם תַּ֣חַת כָּל־בְּכֹ֔ור בְּבֶהֱמַ֖ת בְּנֵ֥י יִשְׂרָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","וַיִּפְקֹ֣ד מֹשֶׁ֔ה כַּאֲשֶׁ֛ר צִוָּ֥ה יְהוָ֖ה אֹתֹ֑ו אֶֽת־כָּל־בְּכֹ֖ר בִּבְנֵ֥י יִשְׂרָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","וַיְהִי֩ כָל־בְּכֹ֨ור זָכָ֜ר בְּמִסְפַּ֥ר שֵׁמֹ֛ות מִבֶּן־חֹ֥דֶשׁ וָמַ֖עְלָה לִפְקֻדֵיהֶ֑ם שְׁנַ֤יִם וְעֶשְׂרִים֙ אֶ֔לֶף שְׁלֹשָׁ֥ה וְשִׁבְעִ֖ים וּמָאתָֽיִם׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","קַ֣ח אֶת־הַלְוִיִּ֗ם תַּ֤חַת כָּל־בְּכֹור֙ בִּבְנֵ֣י יִשְׂרָאֵ֔ל וְאֶת־בֶּהֱמַ֥ת הַלְוִיִּ֖ם תַּ֣חַת בְּהֶמְתָּ֑ם וְהָיוּ־לִ֥י הַלְוִיִּ֖ם אֲנִ֥י יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","וְאֵת֙ פְּדוּיֵ֣י הַשְּׁלֹשָׁ֔ה וְהַשִּׁבְעִ֖ים וְהַמָּאתָ֑יִם הָעֹֽדְפִים֙ עַל־הַלְוִיִּ֔ם מִבְּכֹ֖ור בְּנֵ֥י יִשְׂרָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","וְלָקַחְתָּ֗ חֲמֵ֧שֶׁת חֲמֵ֛שֶׁת שְׁקָלִ֖ים לַגֻּלְגֹּ֑לֶת בְּשֶׁ֤קֶל הַקֹּ֙דֶשׁ֙ תִּקָּ֔ח עֶשְׂרִ֥ים גֵּרָ֖ה הַשָּֽׁקֶל׃ ");
INSERT INTO hbo_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","וְנָתַתָּ֣ה הַכֶּ֔סֶף לְאַהֲרֹ֖ן וּלְבָנָ֑יו פְּדוּיֵ֕י הָעֹדְפִ֖ים בָּהֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","וַיִּקַּ֣ח מֹשֶׁ֔ה אֵ֖ת כֶּ֣סֶף הַפִּדְיֹ֑ום מֵאֵת֙ הָעֹ֣דְפִ֔ים עַ֖ל פְּדוּיֵ֥י הַלְוִיִּֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","מֵאֵ֗ת בְּכֹ֛ור בְּנֵ֥י יִשְׂרָאֵ֖ל לָקַ֣ח אֶת־הַכָּ֑סֶף חֲמִשָּׁ֨ה וְשִׁשִּׁ֜ים וּשְׁלֹ֥שׁ מֵאֹ֛ות וָאֶ֖לֶף בְּשֶׁ֥קֶל הַקֹּֽדֶשׁ׃ ");
INSERT INTO hbo_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","וַיִּתֵּ֨ן מֹשֶׁ֜ה אֶת־כֶּ֧סֶף הַפְּדֻיִ֛ם לְאַהֲרֹ֥ן וּלְבָנָ֖יו עַל־פִּ֣י יְהוָ֑ה כַּאֲשֶׁ֛ר צִוָּ֥ה יְהוָ֖ה אֶת־מֹשֶֽׁה׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","וַיְדַבֵּ֣ר יְהוָ֔ה אֶל־מֹשֶׁ֥ה וְאֶֽל־אַהֲרֹ֖ן לֵאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","נָשֹׂ֗א אֶת־רֹאשׁ֙ בְּנֵ֣י קְהָ֔ת מִתֹּ֖וךְ בְּנֵ֣י לֵוִ֑י לְמִשְׁפְּחֹתָ֖ם לְבֵ֥ית אֲבֹתָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","מִבֶּ֨ן שְׁלֹשִׁ֤ים שָׁנָה֙ וָמַ֔עְלָה וְעַ֖ד בֶּן־חֲמִשִּׁ֣ים שָׁנָ֑ה כָּל־בָּא֙ לַצָּבָ֔א לַעֲשֹׂ֥ות מְלָאכָ֖ה בְּאֹ֥הֶל מֹועֵֽד׃ ");
INSERT INTO hbo_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","זֹ֛את עֲבֹדַ֥ת בְּנֵי־קְהָ֖ת בְּאֹ֣הֶל מֹועֵ֑ד קֹ֖דֶשׁ הַקֳּדָשִֽׁים׃ ");
INSERT INTO hbo_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","וּבָ֨א אַהֲרֹ֤ן וּבָנָיו֙ בִּנְסֹ֣עַ הַֽמַּחֲנֶ֔ה וְהֹורִ֕דוּ אֵ֖ת פָּרֹ֣כֶת הַמָּסָ֑ךְ וְכִ֨סּוּ־בָ֔הּ אֵ֖ת אֲרֹ֥ן הָעֵדֻֽת׃ ");
INSERT INTO hbo_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","וְנָתְנ֣וּ עָלָ֗יו כְּסוּי֙ עֹ֣ור תַּ֔חַשׁ וּפָרְשׂ֧וּ בֶֽגֶד־כְּלִ֛יל תְּכֵ֖לֶת מִלְמָ֑עְלָה וְשָׂמ֖וּ בַּדָּֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","וְעַ֣ל ׀ שֻׁלְחַ֣ן הַפָּנִ֗ים יִפְרְשׂוּ֮ בֶּ֣גֶד תְּכֵלֶת֒ וְנָתְנ֣וּ עָ֠לָיו אֶת־הַקְּעָרֹ֤ת וְאֶת־הַכַּפֹּת֙ וְאֶת־הַמְּנַקִּיֹּ֔ת וְאֵ֖ת קְשֹׂ֣ות הַנָּ֑סֶךְ וְלֶ֥חֶם הַתָּמִ֖יד עָלָ֥יו יִהְיֶֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","וּפָרְשׂ֣וּ עֲלֵיהֶ֗ם בֶּ֚גֶד תֹּולַ֣עַת שָׁנִ֔י וְכִסּ֣וּ אֹתֹ֔ו בְּמִכְסֵ֖ה עֹ֣ור תָּ֑חַשׁ וְשָׂמ֖וּ אֶת־בַּדָּֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","וְלָקְח֣וּ ׀ בֶּ֣גֶד תְּכֵ֗לֶת וְכִסּ֞וּ אֶת־מְנֹרַ֤ת הַמָּאֹור֙ וְאֶת־נֵ֣רֹתֶ֔יהָ וְאֶת־מַלְקָחֶ֖יהָ וְאֶת־מַחְתֹּתֶ֑יהָ וְאֵת֙ כָּל־כְּלֵ֣י שַׁמְנָ֔הּ אֲשֶׁ֥ר יְשָׁרְתוּ־לָ֖הּ בָּהֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","וְנָתְנ֤וּ אֹתָהּ֙ וְאֶת־כָּל־כֵּלֶ֔יהָ אֶל־מִכְסֵ֖ה עֹ֣ור תָּ֑חַשׁ וְנָתְנ֖וּ עַל־הַמֹּֽוט׃ ");
INSERT INTO hbo_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","וְעַ֣ל ׀ מִזְבַּ֣ח הַזָּהָ֗ב יִפְרְשׂוּ֙ בֶּ֣גֶד תְּכֵ֔לֶת וְכִסּ֣וּ אֹתֹ֔ו בְּמִכְסֵ֖ה עֹ֣ור תָּ֑חַשׁ וְשָׂמ֖וּ אֶת־בַּדָּֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","וְלָקְחוּ֩ אֶת־כָּל־כְּלֵ֨י הַשָּׁרֵ֜ת אֲשֶׁ֧ר יְשָֽׁרְתוּ־בָ֣ם בַּקֹּ֗דֶשׁ וְנָֽתְנוּ֙ אֶל־בֶּ֣גֶד תְּכֵ֔לֶת וְכִסּ֣וּ אֹותָ֔ם בְּמִכְסֵ֖ה עֹ֣ור תָּ֑חַשׁ וְנָתְנ֖וּ עַל־הַמֹּֽוט׃ ");
INSERT INTO hbo_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","וְדִשְּׁנ֖וּ אֶת־הַמִּזְבֵּ֑חַ וּפָרְשׂ֣וּ עָלָ֔יו בֶּ֖גֶד אַרְגָּמָֽן׃ ");
INSERT INTO hbo_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","וְנָתְנ֣וּ עָ֠לָיו אֶֽת־כָּל־כֵּלָ֞יו אֲשֶׁ֣ר יְֽשָׁרְת֧וּ עָלָ֣יו בָּהֶ֗ם אֶת־הַמַּחְתֹּ֤ת אֶת־הַמִּזְלָגֹת֙ וְאֶת־הַיָּעִ֣ים וְאֶת־הַמִּזְרָקֹ֔ת כֹּ֖ל כְּלֵ֣י הַמִּזְבֵּ֑חַ וּפָרְשׂ֣וּ עָלָ֗יו כְּס֛וּי עֹ֥ור תַּ֖חַשׁ וְשָׂמ֥וּ בַדָּֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","וְכִלָּ֣ה אַֽהֲרֹן־וּ֠בָנָיו לְכַסֹּ֨ת אֶת־הַקֹּ֜דֶשׁ וְאֶת־כָּל־כְּלֵ֣י הַקֹּדֶשׁ֮ בִּנְסֹ֣עַ הֽ͏ַמַּחֲנֶה֒ וְאַחֲרֵי־כֵ֗ן יָבֹ֤אוּ בְנֵי־קְהָת֙ לָשֵׂ֔את וְלֹֽא־יִגְּע֥וּ אֶל־הַקֹּ֖דֶשׁ וָמֵ֑תוּ אֵ֛לֶּה מַשָּׂ֥א בְנֵֽי־קְהָ֖ת בְּאֹ֥הֶל מֹועֵֽד׃ ");
INSERT INTO hbo_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","וּפְקֻדַּ֞ת אֶלְעָזָ֣ר ׀ בֶּן־אַהֲרֹ֣ן הַכֹּהֵ֗ן שֶׁ֤מֶן הַמָּאֹור֙ וּקְטֹ֣רֶת הַסַּמִּ֔ים וּמִנְחַ֥ת הַתָּמִ֖יד וְשֶׁ֣מֶן הַמִּשְׁחָ֑ה פְּקֻדַּ֗ת כָּל־הַמִּשְׁכָּן֙ וְכָל־אֲשֶׁר־בֹּ֔ו בְּקֹ֖דֶשׁ וּבְכֵלָֽיו׃ ס ");
INSERT INTO hbo_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","וַיְדַבֵּ֣ר יְהוָ֔ה אֶל־מֹשֶׁ֥ה וְאֶֽל־אַהֲרֹ֖ן לֵאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","אַל־תַּכְרִ֕יתוּ אֶת־שֵׁ֖בֶט מִשְׁפְּחֹ֣ת הַקְּהָתִ֑י מִתֹּ֖וךְ הַלְוִיִּֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","וְזֹ֣את ׀ עֲשׂ֣וּ לָהֶ֗ם וְחָיוּ֙ וְלֹ֣א יָמֻ֔תוּ בְּגִשְׁתָּ֖ם אֶת־קֹ֣דֶשׁ הַקֳּדָשִׁ֑ים אַהֲרֹ֤ן וּבָנָיו֙ יָבֹ֔אוּ וְשָׂמ֣וּ אֹותָ֗ם אִ֥ישׁ אִ֛ישׁ עַל־עֲבֹדָתֹ֖ו וְאֶל־מַשָּׂאֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","וְלֹא־יָבֹ֧אוּ לִרְאֹ֛ות כְּבַלַּ֥ע אֶת־הַקֹּ֖דֶשׁ וָמֵֽתוּ׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","נָשֹׂ֗א אֶת־רֹ֛אשׁ בְּנֵ֥י גֵרְשֹׁ֖ון גַּם־הֵ֑ם לְבֵ֥ית אֲבֹתָ֖ם לְמִשְׁפְּחֹתָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","מִבֶּן֩ שְׁלֹשִׁ֨ים שָׁנָ֜ה וָמַ֗עְלָה עַ֛ד בֶּן־חֲמִשִּׁ֥ים שָׁנָ֖ה תִּפְקֹ֣ד אֹותָ֑ם כָּל־הַבָּא֙ לִצְבֹ֣א צָבָ֔א לַעֲבֹ֥ד עֲבֹדָ֖ה בְּאֹ֥הֶל מֹועֵֽד׃ ");
INSERT INTO hbo_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","זֹ֣את עֲבֹדַ֔ת מִשְׁפְּחֹ֖ת הַגֵּרְשֻׁנִּ֑י לַעֲבֹ֖ד וּלְמַשָּֽׂא׃ ");
INSERT INTO hbo_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","וְנָ֨שְׂא֜וּ אֶת־יְרִיעֹ֤ת הַמִּשְׁכָּן֙ וְאֶת־אֹ֣הֶל מֹועֵ֔ד מִכְסֵ֕הוּ וּמִכְסֵ֛ה הַתַּ֥חַשׁ אֲשֶׁר־עָלָ֖יו מִלְמָ֑עְלָה וְאֶ֨ת־מָסַ֔ךְ פֶּ֖תַח אֹ֥הֶל מֹועֵֽד׃ ");
INSERT INTO hbo_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","וְאֵת֩ קַלְעֵ֨י הֶֽחָצֵ֜ר וְאֶת־מָסַ֣ךְ ׀ פֶּ֣תַח ׀ שַׁ֣עַר הֶחָצֵ֗ר אֲשֶׁ֨ר עַל־הַמִּשְׁכָּ֤ן וְעַל־הַמִּזְבֵּ֙חַ֙ סָבִ֔יב וְאֵת֙ מֵֽיתְרֵיהֶ֔ם וְאֶֽת־כָּל־כְּלֵ֖י עֲבֹדָתָ֑ם וְאֵ֨ת כָּל־אֲשֶׁ֧ר יֵעָשֶׂ֛ה לָהֶ֖ם וְעָבָֽדוּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","עַל־פִּי֩ אַהֲרֹ֨ן וּבָנָ֜יו תִּהְיֶ֗ה כָּל־עֲבֹדַת֙ בְּנֵ֣י הַגֵּרְשֻׁנִּ֔י לְכָל־מַשָּׂאָ֔ם וּלְכֹ֖ל עֲבֹדָתָ֑ם וּפְקַדְתֶּ֤ם עֲלֵהֶם֙ בְּמִשְׁמֶ֔רֶת אֵ֖ת כָּל־מַשָּׂאָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","זֹ֣את עֲבֹדַ֗ת מִשְׁפְּחֹ֛ת בְּנֵ֥י הַגֵּרְשֻׁנִּ֖י בְּאֹ֣הֶל מֹועֵ֑ד וּמִ֨שְׁמַרְתָּ֔ם בְּיַד֙ אִֽיתָמָ֔ר בֶּֽן־אַהֲרֹ֖ן הַכֹּהֵֽן׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","בְּנֵ֖י מְרָרִ֑י לְמִשְׁפְּחֹתָ֥ם לְבֵית־אֲבֹתָ֖ם תִּפְקֹ֥ד אֹתָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","מִבֶּן֩ שְׁלֹשִׁ֨ים שָׁנָ֜ה וָמַ֗עְלָה וְעַ֛ד בֶּן־חֲמִשִּׁ֥ים שָׁנָ֖ה תִּפְקְדֵ֑ם כָּל־הַבָּא֙ לַצָּבָ֔א לַעֲבֹ֕ד אֶת־עֲבֹדַ֖ת אֹ֥הֶל מֹועֵֽד׃ ");
INSERT INTO hbo_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","וְזֹאת֙ מִשְׁמֶ֣רֶת מַשָּׂאָ֔ם לְכָל־עֲבֹדָתָ֖ם בְּאֹ֣הֶל מֹועֵ֑ד קַרְשֵׁי֙ הַמִּשְׁכָּ֔ן וּבְרִיחָ֖יו וְעַמּוּדָ֥יו וַאֲדָנָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","וְעַמּוּדֵי֩ הֶחָצֵ֨ר סָבִ֜יב וְאַדְנֵיהֶ֗ם וִֽיתֵדֹתָם֙ וּמֵ֣יתְרֵיהֶ֔ם לְכָל־כְּלֵיהֶ֔ם וּלְכֹ֖ל עֲבֹדָתָ֑ם וּבְשֵׁמֹ֣ת תִּפְקְד֔וּ אֶת־כְּלֵ֖י מִשְׁמֶ֥רֶת מַשָּׂאָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","זֹ֣את עֲבֹדַ֗ת מִשְׁפְּחֹת֙ בְּנֵ֣י מְרָרִ֔י לְכָל־עֲבֹדָתָ֖ם בְּאֹ֣הֶל מֹועֵ֑ד בְּיַד֙ אִֽיתָמָ֔ר בֶּֽן־אַהֲרֹ֖ן הַכֹּהֵֽן׃ ");
INSERT INTO hbo_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","וַיִּפְקֹ֨ד מֹשֶׁ֧ה וְאַהֲרֹ֛ן וּנְשִׂיאֵ֥י הָעֵדָ֖ה אֶת־בְּנֵ֣י הַקְּהָתִ֑י לְמִשְׁפְּחֹתָ֖ם וּלְבֵ֥ית אֲבֹתָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","מִבֶּ֨ן שְׁלֹשִׁ֤ים שָׁנָה֙ וָמַ֔עְלָה וְעַ֖ד בֶּן־חֲמִשִּׁ֣ים שָׁנָ֑ה כָּל־הַבָּא֙ לַצָּבָ֔א לַעֲבֹדָ֖ה בְּאֹ֥הֶל מֹועֵֽד׃ ");
INSERT INTO hbo_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","וַיִּהְי֥וּ פְקֻדֵיהֶ֖ם לְמִשְׁפְּחֹתָ֑ם אַלְפַּ֕יִם שְׁבַ֥ע מֵאֹ֖ות וַחֲמִשִּֽׁים׃ ");
INSERT INTO hbo_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","אֵ֤לֶּה פְקוּדֵי֙ מִשְׁפְּחֹ֣ת הַקְּהָתִ֔י כָּל־הָעֹבֵ֖ד בְּאֹ֣הֶל מֹועֵ֑ד אֲשֶׁ֨ר פָּקַ֤ד מֹשֶׁה֙ וְאַהֲרֹ֔ן עַל־פִּ֥י יְהוָ֖ה בְּיַד־מֹשֶֽׁה׃ ס ");
INSERT INTO hbo_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","וּפְקוּדֵ֖י בְּנֵ֣י גֵרְשֹׁ֑ון לְמִשְׁפְּחֹותָ֖ם וּלְבֵ֥ית אֲבֹתָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","מִבֶּ֨ן שְׁלֹשִׁ֤ים שָׁנָה֙ וָמַ֔עְלָה וְעַ֖ד בֶּן־חֲמִשִּׁ֣ים שָׁנָ֑ה כָּל־הַבָּא֙ לַצָּבָ֔א לַעֲבֹדָ֖ה בְּאֹ֥הֶל מֹועֵֽד׃ ");
INSERT INTO hbo_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","וַיִּֽהְיוּ֙ פְּקֻ֣דֵיהֶ֔ם לְמִשְׁפְּחֹתָ֖ם לְבֵ֣ית אֲבֹתָ֑ם אַלְפַּ֕יִם וְשֵׁ֥שׁ מֵאֹ֖ות וּשְׁלֹשִֽׁים׃ ");
INSERT INTO hbo_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","אֵ֣לֶּה פְקוּדֵ֗י מִשְׁפְּחֹת֙ בְּנֵ֣י גֵרְשֹׁ֔ון כָּל־הָעֹבֵ֖ד בְּאֹ֣הֶל מֹועֵ֑ד אֲשֶׁ֨ר פָּקַ֥ד מֹשֶׁ֛ה וְאַהֲרֹ֖ן עַל־פִּ֥י יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","וּפְקוּדֵ֕י מִשְׁפְּחֹ֖ת בְּנֵ֣י מְרָרִ֑י לְמִשְׁפְּחֹתָ֖ם לְבֵ֥ית אֲבֹתָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","מִבֶּ֨ן שְׁלֹשִׁ֤ים שָׁנָה֙ וָמַ֔עְלָה וְעַ֖ד בֶּן־חֲמִשִּׁ֣ים שָׁנָ֑ה כָּל־הַבָּא֙ לַצָּבָ֔א לַעֲבֹדָ֖ה בְּאֹ֥הֶל מֹועֵֽד׃ ");
INSERT INTO hbo_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","וַיִּהְי֥וּ פְקֻדֵיהֶ֖ם לְמִשְׁפְּחֹתָ֑ם שְׁלֹ֥שֶׁת אֲלָפִ֖ים וּמָאתָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","אֵ֣לֶּה פְקוּדֵ֔י מִשְׁפְּחֹ֖ת בְּנֵ֣י מְרָרִ֑י אֲשֶׁ֨ר פָּקַ֤ד מֹשֶׁה֙ וְאַהֲרֹ֔ן עַל־פִּ֥י יְהוָ֖ה בְּיַד־מֹשֶֽׁה׃ ");
INSERT INTO hbo_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","כָּֽל־הַפְּקֻדִ֡ים אֲשֶׁר֩ פָּקַ֨ד מֹשֶׁ֧ה וְאַהֲרֹ֛ן וּנְשִׂיאֵ֥י יִשְׂרָאֵ֖ל אֶת־הַלְוִיִּ֑ם לְמִשְׁפְּחֹתָ֖ם וּלְבֵ֥ית אֲבֹתָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","מִבֶּ֨ן שְׁלֹשִׁ֤ים שָׁנָה֙ וָמַ֔עְלָה וְעַ֖ד בֶּן־חֲמִשִּׁ֣ים שָׁנָ֑ה כָּל־הַבָּ֗א לַעֲבֹ֨ד עֲבֹדַ֧ת עֲבֹדָ֛ה וַעֲבֹדַ֥ת מַשָּׂ֖א בְּאֹ֥הֶל מֹועֵֽד׃ ");
INSERT INTO hbo_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","וַיִּהְי֖וּ פְּקֻדֵיהֶ֑ם שְׁמֹנַ֣ת אֲלָפִ֔ים וַחֲמֵ֥שׁ מֵאֹ֖ות וּשְׁמֹנִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","עַל־פִּ֨י יְהוָ֜ה פָּקַ֤ד אֹותָם֙ בְּיַד־מֹשֶׁ֔ה אִ֥ישׁ אִ֛ישׁ עַל־עֲבֹדָתֹ֖ו וְעַל־מַשָּׂאֹ֑ו וּפְקֻדָ֕יו אֲשֶׁר־צִוָּ֥ה יְהוָ֖ה אֶת־מֹשֶֽׁה׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","צַ֚ו אֶת־בְּנֵ֣י יִשְׂרָאֵ֔ל וִֽישַׁלְּחוּ֙ מִן־הַֽמַּחֲנֶ֔ה כָּל־צָר֖וּעַ וְכָל־זָ֑ב וְכֹ֖ל טָמֵ֥א לָנָֽפֶשׁ׃ ");
INSERT INTO hbo_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","מִזָּכָ֤ר עַד־נְקֵבָה֙ תְּשַׁלֵּ֔חוּ אֶל־מִח֥וּץ לַֽמַּחֲנֶ֖ה תְּשַׁלְּח֑וּם וְלֹ֤א יְטַמְּאוּ֙ אֶת־מַ֣חֲנֵיהֶ֔ם אֲשֶׁ֥ר אֲנִ֖י שֹׁכֵ֥ן בְּתֹוכָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","וַיַּֽעֲשׂוּ־כֵן֙ בְּנֵ֣י יִשְׂרָאֵ֔ל וַיְשַׁלְּח֣וּ אֹותָ֔ם אֶל־מִח֖וּץ לַֽמַּחֲנֶ֑ה כַּאֲשֶׁ֨ר דִּבֶּ֤ר יְהוָה֙ אֶל־מֹשֶׁ֔ה כֵּ֥ן עָשׂ֖וּ בְּנֵ֥י יִשְׂרָאֵֽל׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","דַּבֵּר֮ אֶל־בְּנֵ֣י יִשְׂרָאֵל֒ אִ֣ישׁ אֹֽו־אִשָּׁ֗ה כִּ֤י יַעֲשׂוּ֙ מִכָּל־חַטֹּ֣את הָֽאָדָ֔ם לִמְעֹ֥ל מַ֖עַל בַּיהוָ֑ה וְאָֽשְׁמָ֖ה הַנֶּ֥פֶשׁ הַהִֽוא׃ ");
INSERT INTO hbo_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","וְהִתְוַדּ֗וּ אֶֽת־חַטָּאתָם֮ אֲשֶׁ֣ר עָשׂוּ֒ וְהֵשִׁ֤יב אֶת־אֲשָׁמֹו֙ בְּרֹאשֹׁ֔ו וַחֲמִישִׁתֹ֖ו יֹסֵ֣ף עָלָ֑יו וְנָתַ֕ן לַאֲשֶׁ֖ר אָשַׁ֥ם לֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","וְאִם־אֵ֨ין לָאִ֜ישׁ גֹּאֵ֗ל לְהָשִׁ֤יב הָאָשָׁם֙ אֵלָ֔יו הָאָשָׁ֛ם הַמּוּשָׁ֥ב לַיהוָ֖ה לַכֹּהֵ֑ן מִלְּבַ֗ד אֵ֚יל הַכִּפֻּרִ֔ים אֲשֶׁ֥ר יְכַפֶּר־בֹּ֖ו עָלָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","וְכָל־תְּרוּמָ֞ה לְכָל־קָדְשֵׁ֧י בְנֵי־יִשְׂרָאֵ֛ל אֲשֶׁר־יַקְרִ֥יבוּ לַכֹּהֵ֖ן לֹ֥ו יִהְיֶֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","וְאִ֥ישׁ אֶת־קֳדָשָׁ֖יו לֹ֣ו יִהְי֑וּ אִ֛ישׁ אֲשֶׁר־יִתֵּ֥ן לַכֹּהֵ֖ן לֹ֥ו יִהְיֶֽה׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","דַּבֵּר֙ אֶל־בְּנֵ֣י יִשְׂרָאֵ֔ל וְאָמַרְתָּ֖ אֲלֵהֶ֑ם אִ֥ישׁ אִישׁ֙ כִּֽי־תִשְׂטֶ֣ה אִשְׁתֹּ֔ו וּמָעֲלָ֥ה בֹ֖ו מָֽעַל׃ ");
INSERT INTO hbo_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","וְשָׁכַ֨ב אִ֣ישׁ אֹתָהּ֮ שִׁכְבַת־זֶרַע֒ וְנֶעְלַם֙ מֵעֵינֵ֣י אִישָׁ֔הּ וְנִסְתְּרָ֖ה וְהִ֣יא נִטְמָ֑אָה וְעֵד֙ אֵ֣ין בָּ֔הּ וְהִ֖וא לֹ֥א נִתְפָּֽשָׂה׃ ");
INSERT INTO hbo_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","וְעָבַ֨ר עָלָ֧יו רֽוּחַ־קִנְאָ֛ה וְקִנֵּ֥א אֶת־אִשְׁתֹּ֖ו וְהִ֣וא נִטְמָ֑אָה אֹו־עָבַ֨ר עָלָ֤יו רֽוּחַ־קִנְאָה֙ וְקִנֵּ֣א אֶת־אִשְׁתֹּ֔ו וְהִ֖יא לֹ֥א נִטְמָֽאָה׃ ");
INSERT INTO hbo_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","וְהֵבִ֨יא הָאִ֣ישׁ אֶת־אִשְׁתֹּו֮ אֶל־הַכֹּהֵן֒ וְהֵבִ֤יא אֶת־קָרְבָּנָהּ֙ עָלֶ֔יהָ עֲשִׂירִ֥ת הָאֵיפָ֖ה קֶ֣מַח שְׂעֹרִ֑ים לֹֽא־יִצֹ֨ק עָלָ֜יו שֶׁ֗מֶן וְלֹֽא־יִתֵּ֤ן עָלָיו֙ לְבֹנָ֔ה כִּֽי־מִנְחַ֤ת קְנָאֹת֙ ה֔וּא מִנְחַ֥ת זִכָּרֹ֖ון מַזְכֶּ֥רֶת עָוֹֽן׃ ");
INSERT INTO hbo_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","וְהִקְרִ֥יב אֹתָ֖הּ הַכֹּהֵ֑ן וְהֶֽעֱמִדָ֖הּ לִפְנֵ֥י יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","וְלָקַ֧ח הַכֹּהֵ֛ן מַ֥יִם קְדֹשִׁ֖ים בִּכְלִי־חָ֑רֶשׂ וּמִן־הֶֽעָפָ֗ר אֲשֶׁ֤ר יִהְיֶה֙ בְּקַרְקַ֣ע הַמִּשְׁכָּ֔ן יִקַּ֥ח הַכֹּהֵ֖ן וְנָתַ֥ן אֶל־הַמָּֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","וְהֶעֱמִ֨יד הַכֹּהֵ֥ן אֶֽת־הָאִשָּׁה֮ לִפְנֵ֣י יְהוָה֒ וּפָרַע֙ אֶת־רֹ֣אשׁ הָֽאִשָּׁ֔ה וְנָתַ֣ן עַל־כַּפֶּ֗יהָ אֵ֚ת מִנְחַ֣ת הַזִּכָּרֹ֔ון מִנְחַ֥ת קְנָאֹ֖ת הִ֑וא וּבְיַ֤ד הַכֹּהֵן֙ יִהְי֔וּ מֵ֥י הַמָּרִ֖ים הַמְאָֽרֲרִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","וְהִשְׁבִּ֨יעַ אֹתָ֜הּ הַכֹּהֵ֗ן וְאָמַ֤ר אֶל־הָֽאִשָּׁה֙ אִם־לֹ֨א שָׁכַ֥ב אִישׁ֙ אֹתָ֔ךְ וְאִם־לֹ֥א שָׂטִ֛ית טֻמְאָ֖ה תַּ֣חַת אִישֵׁ֑ךְ הִנָּקִ֕י מִמֵּ֛י הַמָּרִ֥ים הַֽמְאָרֲרִ֖ים הָאֵֽלֶּה׃ ");
INSERT INTO hbo_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","וְאַ֗תְּ כִּ֥י שָׂטִ֛ית תַּ֥חַת אִישֵׁ֖ךְ וְכִ֣י נִטְמֵ֑את וַיִּתֵּ֨ן אִ֥ישׁ בָּךְ֙ אֶת־שְׁכָבְתֹּ֔ו מִֽבַּלְעֲדֵ֖י אִישֵֽׁךְ׃ ");
INSERT INTO hbo_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","וְהִשְׁבִּ֨יעַ הַכֹּהֵ֥ן אֶֽת־הָֽאִשָּׁה֮ בִּשְׁבֻעַ֣ת הָאָלָה֒ וְאָמַ֤ר הַכֹּהֵן֙ לָֽאִשָּׁ֔ה יִתֵּ֨ן יְהוָ֥ה אֹותָ֛ךְ לְאָלָ֥ה וְלִשְׁבֻעָ֖ה בְּתֹ֣וךְ עַמֵּ֑ךְ בְּתֵ֨ת יְהוָ֤ה אֶת־יְרֵכֵךְ֙ נֹפֶ֔לֶת וְאֶת־בִּטְנֵ֖ךְ צָבָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","וּ֠בָאוּ הַמַּ֨יִם הַמְאָרְרִ֤ים הָאֵ֙לֶּה֙ בְּֽמֵעַ֔יִךְ לַצְבֹּ֥ות בֶּ֖טֶן וְלַנְפִּ֣ל יָרֵ֑ךְ וְאָמְרָ֥ה הָאִשָּׁ֖ה אָמֵ֥ן ׀ אָמֵֽן׃ ");
INSERT INTO hbo_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","וְ֠כָתַב אֶת־הָאָלֹ֥ת הָאֵ֛לֶּה הַכֹּהֵ֖ן בַּסֵּ֑פֶר וּמָחָ֖ה אֶל־מֵ֥י הַמָּרִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","וְהִשְׁקָה֙ אֶת־הָ֣אִשָּׁ֔ה אֶת־מֵ֥י הַמָּרִ֖ים הַמְאָֽרֲרִ֑ים וּבָ֥אוּ בָ֛הּ הַמַּ֥יִם הַֽמְאָרֲרִ֖ים לְמָרִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","וְלָקַ֤ח הַכֹּהֵן֙ מִיַּ֣ד הָֽאִשָּׁ֔ה אֵ֖ת מִנְחַ֣ת הַקְּנָאֹ֑ת וְהֵנִ֤יף אֶת־הַמִּנְחָה֙ לִפְנֵ֣י יְהוָ֔ה וְהִקְרִ֥יב אֹתָ֖הּ אֶל־הַמִּזְבֵּֽחַ׃ ");
INSERT INTO hbo_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","וְקָמַ֨ץ הַכֹּהֵ֤ן מִן־הַמִּנְחָה֙ אֶת־אַזְכָּ֣רָתָ֔הּ וְהִקְטִ֖יר הַמִּזְבֵּ֑חָה וְאַחַ֛ר יַשְׁקֶ֥ה אֶת־הָאִשָּׁ֖ה אֶת־הַמָּֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","וְהִשְׁקָ֣הּ אֶת־הַמַּ֗יִם וְהָיְתָ֣ה אִֽם־נִטְמְאָה֮ וַתִּמְעֹ֣ל מַ֣עַל בְּאִישָׁהּ֒ וּבָ֨אוּ בָ֜הּ הַמַּ֤יִם הַמְאֽ͏ָרֲרִים֙ לְמָרִ֔ים וְצָבְתָ֣ה בִטְנָ֔הּ וְנָפְלָ֖ה יְרֵכָ֑הּ וְהָיְתָ֧ה הָאִשָּׁ֛ה לְאָלָ֖ה בְּקֶ֥רֶב עַמָּֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","וְאִם־לֹ֤א נִטְמְאָה֙ הָֽאִשָּׁ֔ה וּטְהֹרָ֖ה הִ֑וא וְנִקְּתָ֖ה וְנִזְרְעָ֥ה זָֽרַע׃ ");
INSERT INTO hbo_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","זֹ֥את תֹּורַ֖ת הַקְּנָאֹ֑ת אֲשֶׁ֨ר תִּשְׂטֶ֥ה אִשָּׁ֛ה תַּ֥חַת אִישָׁ֖הּ וְנִטְמָֽאָה׃ ");
INSERT INTO hbo_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","אֹ֣ו אִ֗ישׁ אֲשֶׁ֨ר תַּעֲבֹ֥ר עָלָ֛יו ר֥וּחַ קִנְאָ֖ה וְקִנֵּ֣א אֶת־אִשְׁתֹּ֑ו וְהֶעֱמִ֤יד אֶת־הָֽאִשָּׁה֙ לִפְנֵ֣י יְהוָ֔ה וְעָ֤שָׂה לָהּ֙ הַכֹּהֵ֔ן אֵ֥ת כָּל־הַתֹּורָ֖ה הַזֹּֽאת׃ ");
INSERT INTO hbo_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","וְנִקָּ֥ה הָאִ֖ישׁ מֵעָוֹ֑ן וְהָאִשָּׁ֣ה הַהִ֔וא תִּשָּׂ֖א אֶת־עֲוֹנָֽהּ׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","דַּבֵּר֙ אֶל־בְּנֵ֣י יִשְׂרָאֵ֔ל וְאָמַרְתָּ֖ אֲלֵהֶ֑ם אִ֣ישׁ אֹֽו־אִשָּׁ֗ה כִּ֤י יַפְלִא֙ לִנְדֹּר֙ נֶ֣דֶר נָזִ֔יר לְהַזִּ֖יר לַֽיהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","מִיַּ֤יִן וְשֵׁכָר֙ יַזִּ֔יר חֹ֥מֶץ יַ֛יִן וְחֹ֥מֶץ שֵׁכָ֖ר לֹ֣א יִשְׁתֶּ֑ה וְכָל־מִשְׁרַ֤ת עֲנָבִים֙ לֹ֣א יִשְׁתֶּ֔ה וַעֲנָבִ֛ים לַחִ֥ים וִיבֵשִׁ֖ים לֹ֥א יֹאכֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","כֹּ֖ל יְמֵ֣י נִזְרֹ֑ו מִכֹּל֩ אֲשֶׁ֨ר יֵעָשֶׂ֜ה מִגֶּ֣פֶן הַיַּ֗יִן מֵחַרְצַנִּ֛ים וְעַד־זָ֖ג לֹ֥א יֹאכֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","כָּל־יְמֵי֙ נֶ֣דֶר נִזְרֹ֔ו תַּ֖עַר לֹא־יַעֲבֹ֣ר עַל־רֹאשֹׁ֑ו עַד־מְלֹ֨את הַיָּמִ֜ם אֲשֶׁר־יַזִּ֤יר לַיהוָה֙ קָדֹ֣שׁ יִהְיֶ֔ה גַּדֵּ֥ל פֶּ֖רַע שְׂעַ֥ר רֹאשֹֽׁו׃ ");
INSERT INTO hbo_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","כָּל־יְמֵ֥י הַזִּירֹ֖ו לַיהוָ֑ה עַל־נֶ֥פֶשׁ מֵ֖ת לֹ֥א יָבֹֽא׃ ");
INSERT INTO hbo_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","לְאָבִ֣יו וּלְאִמֹּ֗ו לְאָחִיו֙ וּלְאַ֣חֹתֹ֔ו לֹא־יִטַּמָּ֥א לָהֶ֖ם בְּמֹתָ֑ם כִּ֛י נֵ֥זֶר אֱלֹהָ֖יו עַל־רֹאשֹֽׁו׃ ");
INSERT INTO hbo_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","כֹּ֖ל יְמֵ֣י נִזְרֹ֑ו קָדֹ֥שׁ ה֖וּא לַֽיהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","וְכִֽי־יָמ֨וּת מֵ֤ת עָלָיו֙ בְּפֶ֣תַע פִּתְאֹ֔ם וְטִמֵּ֖א רֹ֣אשׁ נִזְרֹ֑ו וְגִלַּ֤ח רֹאשֹׁו֙ בְּיֹ֣ום טָהֳרָתֹ֔ו בַּיֹּ֥ום הַשְּׁבִיעִ֖י יְגַלְּחֶֽנּוּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","וּבַיֹּ֣ום הַשְּׁמִינִ֗י יָבִא֙ שְׁתֵּ֣י תֹרִ֔ים אֹ֥ו שְׁנֵ֖י בְּנֵ֣י יֹונָ֑ה אֶל־הַכֹּהֵ֔ן אֶל־פֶּ֖תַח אֹ֥הֶל מֹועֵֽד׃ ");
INSERT INTO hbo_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","וְעָשָׂ֣ה הַכֹּהֵ֗ן אֶחָ֤ד לְחַטָּאת֙ וְאֶחָ֣ד לְעֹלָ֔ה וְכִפֶּ֣ר עָלָ֔יו מֵאֲשֶׁ֥ר חָטָ֖א עַל־הַנָּ֑פֶשׁ וְקִדַּ֥שׁ אֶת־רֹאשֹׁ֖ו בַּיֹּ֥ום הַהֽוּא׃ ");
INSERT INTO hbo_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","וְהִזִּ֤יר לַֽיהוָה֙ אֶת־יְמֵ֣י נִזְרֹ֔ו וְהֵבִ֛יא כֶּ֥בֶשׂ בֶּן־שְׁנָתֹ֖ו לְאָשָׁ֑ם וְהַיָּמִ֤ים הָרִאשֹׁנִים֙ יִפְּל֔וּ כִּ֥י טָמֵ֖א נִזְרֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","וְזֹ֥את תֹּורַ֖ת הַנָּזִ֑יר בְּיֹ֗ום מְלֹאת֙ יְמֵ֣י נִזְרֹ֔ו יָבִ֣יא אֹתֹ֔ו אֶל־פֶּ֖תַח אֹ֥הֶל מֹועֵֽד׃ ");
INSERT INTO hbo_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","וְהִקְרִ֣יב אֶת־קָרְבָּנֹ֣ו לַיהוָ֡ה כֶּבֶשׂ֩ בֶּן־שְׁנָתֹ֨ו תָמִ֤ים אֶחָד֙ לְעֹלָ֔ה וְכַבְשָׂ֨ה אַחַ֧ת בַּת־שְׁנָתָ֛הּ תְּמִימָ֖ה לְחַטָּ֑את וְאַֽיִל־אֶחָ֥ד תָּמִ֖ים לִשְׁלָמִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","וְסַ֣ל מַצֹּ֗ות סֹ֤לֶת חַלֹּת֙ בְּלוּלֹ֣ת בַּשֶּׁ֔מֶן וּרְקִיקֵ֥י מַצֹּ֖ות מְשֻׁחִ֣ים בַּשָּׁ֑מֶן וּמִנְחָתָ֖ם וְנִסְכֵּיהֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","וְהִקְרִ֥יב הַכֹּהֵ֖ן לִפְנֵ֣י יְהוָ֑ה וְעָשָׂ֥ה אֶת־חַטָּאתֹ֖ו וְאֶת־עֹלָתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","וְאֶת־הָאַ֜יִל יַעֲשֶׂ֨ה זֶ֤בַח שְׁלָמִים֙ לַֽיהוָ֔ה עַ֖ל סַ֣ל הַמַּצֹּ֑ות וְעָשָׂה֙ הַכֹּהֵ֔ן אֶת־מִנְחָתֹ֖ו וְאֶת־נִסְכֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","וְגִלַּ֣ח הַנָּזִ֗יר פֶּ֛תַח אֹ֥הֶל מֹועֵ֖ד אֶת־רֹ֣אשׁ נִזְרֹ֑ו וְלָקַ֗ח אֶת־שְׂעַר֙ רֹ֣אשׁ נִזְרֹ֔ו וְנָתַן֙ עַל־הָאֵ֔שׁ אֲשֶׁר־תַּ֖חַת זֶ֥בַח הַשְּׁלָמִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","וְלָקַ֨ח הַכֹּהֵ֜ן אֶת־הַזְּרֹ֣עַ בְּשֵׁלָה֮ מִן־הָאַיִל֒ וְֽחַלַּ֨ת מַצָּ֤ה אַחַת֙ מִן־הַסַּ֔ל וּרְקִ֥יק מַצָּ֖ה אֶחָ֑ד וְנָתַן֙ עַל־כַּפֵּ֣י הַנָּזִ֔יר אַחַ֖ר הִֽתְגַּלְּחֹ֥ו אֶת־נִזְרֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","וְהֵנִיף֩ אֹותָ֨ם הַכֹּהֵ֥ן ׀ תְּנוּפָה֮ לִפְנֵ֣י יְהוָה֒ קֹ֤דֶשׁ הוּא֙ לַכֹּהֵ֔ן עַ֚ל חֲזֵ֣ה הַתְּנוּפָ֔ה וְעַ֖ל שֹׁ֣וק הַתְּרוּמָ֑ה וְאַחַ֛ר יִשְׁתֶּ֥ה הַנָּזִ֖יר יָֽיִן׃ ");
INSERT INTO hbo_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","זֹ֣את תֹּורַ֣ת הַנָּזִיר֮ אֲשֶׁ֣ר יִדֹּר֒ קָרְבָּנֹ֤ו לַֽיהוָה֙ עַל־נִזְרֹ֔ו מִלְּבַ֖ד אֲשֶׁר־תַּשִּׂ֣יג יָדֹ֑ו כְּפִ֤י נִדְרֹו֙ אֲשֶׁ֣ר יִדֹּ֔ר כֵּ֣ן יַעֲשֶׂ֔ה עַ֖ל תֹּורַ֥ת נִזְרֹֽו׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","דַּבֵּ֤ר אֶֽל־אַהֲרֹן֙ וְאֶל־בָּנָ֣יו לֵאמֹ֔ר כֹּ֥ה תְבָרֲכ֖וּ אֶת־בְּנֵ֣י יִשְׂרָאֵ֑ל אָמֹ֖ור לָהֶֽם׃ ס ");
INSERT INTO hbo_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","יְבָרֶכְךָ֥ יְהוָ֖ה וְיִשְׁמְרֶֽךָ׃ ס ");
INSERT INTO hbo_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","יָאֵ֨ר יְהוָ֧ה ׀ פָּנָ֛יו אֵלֶ֖יךָ וִֽיחֻנֶּֽךָּ׃ ס ");
INSERT INTO hbo_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","יִשָּׂ֨א יְהוָ֤ה ׀ פָּנָיו֙ אֵלֶ֔יךָ וְיָשֵׂ֥ם לְךָ֖ שָׁלֹֽום׃ ס ");
INSERT INTO hbo_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","וְשָׂמ֥וּ אֶת־שְׁמִ֖י עַל־בְּנֵ֣י יִשְׂרָאֵ֑ל וַאֲנִ֖י אֲבָרֲכֵֽם׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","וַיְהִ֡י בְּיֹום֩ כַּלֹּ֨ות מֹשֶׁ֜ה לְהָקִ֣ים אֶת־הַמִּשְׁכָּ֗ן וַיִּמְשַׁ֨ח אֹתֹ֜ו וַיְקַדֵּ֤שׁ אֹתֹו֙ וְאֶת־כָּל־כֵּלָ֔יו וְאֶת־הַמִּזְבֵּ֖חַ וְאֶת־כָּל־כֵּלָ֑יו וַיִּמְשָׁחֵ֖ם וַיְקַדֵּ֥שׁ אֹתָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","וַיַּקְרִ֙יבוּ֙ נְשִׂיאֵ֣י יִשְׂרָאֵ֔ל רָאשֵׁ֖י בֵּ֣ית אֲבֹתָ֑ם הֵ֚ם נְשִׂיאֵ֣י הַמַּטֹּ֔ת הֵ֥ם הָעֹמְדִ֖ים עַל־הַפְּקֻדִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","וַיָּבִ֨יאוּ אֶת־קָרְבָּנָ֜ם לִפְנֵ֣י יְהוָ֗ה שֵׁשׁ־עֶגְלֹ֥ת צָב֙ וּשְׁנֵ֣י עָשָׂ֣ר בָּקָ֔ר עֲגָלָ֛ה עַל־שְׁנֵ֥י הַנְּשִׂאִ֖ים וְשֹׁ֣ור לְאֶחָ֑ד וַיַּקְרִ֥יבוּ אֹותָ֖ם לִפְנֵ֥י הַמִּשְׁכָּֽן׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","וַיֹּ֥אמֶר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","קַ֚ח מֵֽאִתָּ֔ם וְהָי֕וּ לַעֲבֹ֕ד אֶת־עֲבֹדַ֖ת אֹ֣הֶל מֹועֵ֑ד וְנָתַתָּ֤ה אֹותָם֙ אֶל־הַלְוִיִּ֔ם אִ֖ישׁ כְּפִ֥י עֲבֹדָתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","וַיִּקַּ֣ח מֹשֶׁ֔ה אֶת־הָעֲגָלֹ֖ת וְאֶת־הַבָּקָ֑ר וַיִּתֵּ֥ן אֹותָ֖ם אֶל־הַלְוִיִּֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","אֵ֣ת ׀ שְׁתֵּ֣י הָעֲגָלֹ֗ת וְאֵת֙ אַרְבַּ֣עַת הַבָּקָ֔ר נָתַ֖ן לִבְנֵ֣י גֵרְשֹׁ֑ון כְּפִ֖י עֲבֹדָתָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","וְאֵ֣ת ׀ אַרְבַּ֣ע הָעֲגָלֹ֗ת וְאֵת֙ שְׁמֹנַ֣ת הַבָּקָ֔ר נָתַ֖ן לִבְנֵ֣י מְרָרִ֑י כְּפִי֙ עֲבֹ֣דָתָ֔ם בְּיַד֙ אִֽיתָמָ֔ר בֶּֽן־אַהֲרֹ֖ן הַכֹּהֵֽן׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","וְלִבְנֵ֥י קְהָ֖ת לֹ֣א נָתָ֑ן כִּֽי־עֲבֹדַ֤ת הַקֹּ֙דֶשׁ֙ עֲלֵהֶ֔ם בַּכָּתֵ֖ף יִשָּֽׂאוּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","וַיַּקְרִ֣יבוּ הַנְּשִׂאִ֗ים אֵ֚ת חֲנֻכַּ֣ת הַמִּזְבֵּ֔חַ בְּיֹ֖ום הִמָּשַׁ֣ח אֹתֹ֑ו וַיַּקְרִ֧יבוּ הַנְּשִׂיאִ֛ם אֶת־קָרְבָּנָ֖ם לִפְנֵ֥י הַמִּזְבֵּֽחַ׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","וַיֹּ֥אמֶר יְהוָ֖ה אֶל־מֹשֶׁ֑ה נָשִׂ֨יא אֶחָ֜ד לַיֹּ֗ום נָשִׂ֤יא אֶחָד֙ לַיֹּ֔ום יַקְרִ֙יבוּ֙ אֶת־קָרְבָּנָ֔ם לַחֲנֻכַּ֖ת הַמִּזְבֵּֽחַ׃ ס ");
INSERT INTO hbo_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","וַיְהִ֗י הַמַּקְרִ֛יב בַּיֹּ֥ום הָרִאשֹׁ֖ון אֶת־קָרְבָּנֹ֑ו נַחְשֹׁ֥ון בֶּן־עַמִּינָדָ֖ב לְמַטֵּ֥ה יְהוּדָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","וְקָרְבָּנֹ֞ו קֽ͏ַעֲרַת־כֶּ֣סֶף אַחַ֗ת שְׁלֹשִׁ֣ים וּמֵאָה֮ מִשְׁקָלָהּ֒ מִזְרָ֤ק אֶחָד֙ כֶּ֔סֶף שִׁבְעִ֥ים שֶׁ֖קֶל בְּשֶׁ֣קֶל הַקֹּ֑דֶשׁ שְׁנֵיהֶ֣ם ׀ מְלֵאִ֗ים סֹ֛לֶת בְּלוּלָ֥ה בַשֶּׁ֖מֶן לְמִנְחָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","כַּ֥ף אַחַ֛ת עֲשָׂרָ֥ה זָהָ֖ב מְלֵאָ֥ה קְטֹֽרֶת׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","פַּ֣ר אֶחָ֞ד בֶּן־בָּקָ֗ר אַ֧יִל אֶחָ֛ד כֶּֽבֶשׂ־אֶחָ֥ד בֶּן־שְׁנָתֹ֖ו לְעֹלָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","שְׂעִיר־עִזִּ֥ים אֶחָ֖ד לְחַטָּֽאת׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","וּלְזֶ֣בַח הַשְּׁלָמִים֮ בָּקָ֣ר שְׁנַיִם֒ אֵילִ֤ם חֲמִשָּׁה֙ עַתּוּדִ֣ים חֲמִשָּׁ֔ה כְּבָשִׂ֥ים בְּנֵֽי־שָׁנָ֖ה חֲמִשָּׁ֑ה זֶ֛ה קָרְבַּ֥ן נַחְשֹׁ֖ון בֶּן־עַמִּינָדָֽב׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","בַּיֹּום֙ הַשֵּׁנִ֔י הִקְרִ֖יב נְתַנְאֵ֣ל בֶּן־צוּעָ֑ר נְשִׂ֖יא יִשָּׂשכָֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","הִקְרִ֨ב אֶת־קָרְבָּנֹ֜ו קַֽעֲרַת־כֶּ֣סֶף אַחַ֗ת שְׁלֹשִׁ֣ים וּמֵאָה֮ מִשְׁקָלָהּ֒ מִזְרָ֤ק אֶחָד֙ כֶּ֔סֶף שִׁבְעִ֥ים שֶׁ֖קֶל בְּשֶׁ֣קֶל הַקֹּ֑דֶשׁ שְׁנֵיהֶ֣ם ׀ מְלֵאִ֗ים סֹ֛לֶת בְּלוּלָ֥ה בַשֶּׁ֖מֶן לְמִנְחָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","כַּ֥ף אַחַ֛ת עֲשָׂרָ֥ה זָהָ֖ב מְלֵאָ֥ה קְטֹֽרֶת׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","פַּ֣ר אֶחָ֞ד בֶּן־בָּקָ֗ר אַ֧יִל אֶחָ֛ד כֶּֽבֶשׂ־אֶחָ֥ד בֶּן־שְׁנָתֹ֖ו לְעֹלָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","שְׂעִיר־עִזִּ֥ים אֶחָ֖ד לְחַטָּֽאת׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","וּלְזֶ֣בַח הַשְּׁלָמִים֮ בָּקָ֣ר שְׁנַיִם֒ אֵילִ֤ם חֲמִשָּׁה֙ עַתּוּדִ֣ים חֲמִשָּׁ֔ה כְּבָשִׂ֥ים בְּנֵי־שָׁנָ֖ה חֲמִשָּׁ֑ה זֶ֛ה קָרְבַּ֥ן נְתַנְאֵ֖ל בֶּן־צוּעָֽר׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","בַּיֹּום֙ הַשְּׁלִישִׁ֔י נָשִׂ֖יא לִבְנֵ֣י זְבוּלֻ֑ן אֱלִיאָ֖ב בֶּן־חֵלֹֽן׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","קָרְבָּנֹ֞ו קַֽעֲרַת־כֶּ֣סֶף אַחַ֗ת שְׁלֹשִׁ֣ים וּמֵאָה֮ מִשְׁקָלָהּ֒ מִזְרָ֤ק אֶחָד֙ כֶּ֔סֶף שִׁבְעִ֥ים שֶׁ֖קֶל בְּשֶׁ֣קֶל הַקֹּ֑דֶשׁ שְׁנֵיהֶ֣ם ׀ מְלֵאִ֗ים סֹ֛לֶת בְּלוּלָ֥ה בַשֶּׁ֖מֶן לְמִנְחָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","כַּ֥ף אַחַ֛ת עֲשָׂרָ֥ה זָהָ֖ב מְלֵאָ֥ה קְטֹֽרֶת׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","פַּ֣ר אֶחָ֞ד בֶּן־בָּקָ֗ר אַ֧יִל אֶחָ֛ד כֶּֽבֶשׂ־אֶחָ֥ד בֶּן־שְׁנָתֹ֖ו לְעֹלָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","שְׂעִיר־עִזִּ֥ים אֶחָ֖ד לְחַטָּֽאת׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","וּלְזֶ֣בַח הַשְּׁלָמִים֮ בָּקָ֣ר שְׁנַיִם֒ אֵילִ֤ם חֲמִשָּׁה֙ עַתֻּדִ֣ים חֲמִשָּׁ֔ה כְּבָשִׂ֥ים בְּנֵי־שָׁנָ֖ה חֲמִשָּׁ֑ה זֶ֛ה קָרְבַּ֥ן אֱלִיאָ֖ב בֶּן־חֵלֹֽן׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","בַּיֹּום֙ הָרְבִיעִ֔י נָשִׂ֖יא לִבְנֵ֣י רְאוּבֵ֑ן אֱלִיצ֖וּר בֶּן־שְׁדֵיאֽוּר׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","קָרְבָּנֹ֞ו קַֽעֲרַת־כֶּ֣סֶף אַחַ֗ת שְׁלֹשִׁ֣ים וּמֵאָה֮ מִשְׁקָלָהּ֒ מִזְרָ֤ק אֶחָד֙ כֶּ֔סֶף שִׁבְעִ֥ים שֶׁ֖קֶל בְּשֶׁ֣קֶל הַקֹּ֑דֶשׁ שְׁנֵיהֶ֣ם ׀ מְלֵאִ֗ים סֹ֛לֶת בְּלוּלָ֥ה בַשֶּׁ֖מֶן לְמִנְחָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","כַּ֥ף אַחַ֛ת עֲשָׂרָ֥ה זָהָ֖ב מְלֵאָ֥ה קְטֹֽרֶת ");
INSERT INTO hbo_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","פַּ֣ר אֶחָ֞ד בֶּן־בָּקָ֗ר אַ֧יִל אֶחָ֛ד כֶּֽבֶשׂ־אֶחָ֥ד בֶּן־שְׁנָתֹ֖ו לְעֹלָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","שְׂעִיר־עִזִּ֥ים אֶחָ֖ד לְחַטָּֽאת׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","וּלְזֶ֣בַח הַשְּׁלָמִים֮ בָּקָ֣ר שְׁנַיִם֒ אֵילִ֤ם חֲמִשָּׁה֙ עַתֻּדִ֣ים חֲמִשָּׁ֔ה כְּבָשִׂ֥ים בְּנֵֽי־שָׁנָ֖ה חֲמִשָּׁ֑ה זֶ֛ה קָרְבַּ֥ן אֱלִיצ֖וּר בֶּן־שְׁדֵיאֽוּר׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","בַּיֹּום֙ הַחֲמִישִׁ֔י נָשִׂ֖יא לִבְנֵ֣י שִׁמְעֹ֑ון שְׁלֻֽמִיאֵ֖ל בֶּן־צוּרִֽישַׁדָּֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","קָרְבָּנֹ֞ו קַֽעֲרַת־כֶּ֣סֶף אַחַ֗ת שְׁלֹשִׁ֣ים וּמֵאָה֮ מִשְׁקָלָהּ֒ מִזְרָ֤ק אֶחָד֙ כֶּ֔סֶף שִׁבְעִ֥ים שֶׁ֖קֶל בְּשֶׁ֣קֶל הַקֹּ֑דֶשׁ שְׁנֵיהֶ֣ם ׀ מְלֵאִ֗ים סֹ֛לֶת בְּלוּלָ֥ה בַשֶּׁ֖מֶן לְמִנְחָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","כַּ֥ף אַחַ֛ת עֲשָׂרָ֥ה זָהָ֖ב מְלֵאָ֥ה קְטֹֽרֶת׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","פַּ֣ר אֶחָ֞ד בֶּן־בָּקָ֗ר אַ֧יִל אֶחָ֛ד כֶּֽבֶשׂ־אֶחָ֥ד בֶּן־שְׁנָתֹ֖ו לְעֹלָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","שְׂעִיר־עִזִּ֥ים אֶחָ֖ד לְחַטָּֽאת ");
INSERT INTO hbo_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","וּלְזֶ֣בַח הַשְּׁלָמִים֮ בָּקָ֣ר שְׁנַיִם֒ אֵילִ֤ם חֲמִשָּׁה֙ עַתֻּדִ֣ים חֲמִשָּׁ֔ה כְּבָשִׂ֥ים בְּנֵי־שָׁנָ֖ה חֲמִשָּׁ֑ה זֶ֛ה קָרְבַּ֥ן שְׁלֻמִיאֵ֖ל בֶּן־צוּרִֽישַׁדָּֽי׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","בַּיֹּום֙ הַשִּׁשִּׁ֔י נָשִׂ֖יא לִבְנֵ֣י גָ֑ד אֶלְיָסָ֖ף בֶּן־דְּעוּאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","קָרְבָּנֹ֞ו קַֽעֲרַת־כֶּ֣סֶף אַחַ֗ת שְׁלֹשִׁ֣ים וּמֵאָה֮ מִשְׁקָלָהּ֒ מִזְרָ֤ק אֶחָד֙ כֶּ֔סֶף שִׁבְעִ֥ים שֶׁ֖קֶל בְּשֶׁ֣קֶל הַקֹּ֑דֶשׁ שְׁנֵיהֶ֣ם ׀ מְלֵאִ֗ים סֹ֛לֶת בְּלוּלָ֥ה בַשֶּׁ֖מֶן לְמִנְחָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","כַּ֥ף אַחַ֛ת עֲשָׂרָ֥ה זָהָ֖ב מְלֵאָ֥ה קְטֹֽרֶת׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","פַּ֣ר אֶחָ֞ד בֶּן־בָּקָ֗ר אַ֧יִל אֶחָ֛ד כֶּֽבֶשׂ־אֶחָ֥ד בֶּן־שְׁנָתֹ֖ו לְעֹלָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","שְׂעִיר־עִזִּ֥ים אֶחָ֖ד לְחַטָּֽאת׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","וּלְזֶ֣בַח הַשְּׁלָמִים֮ בָּקָ֣ר שְׁנַיִם֒ אֵילִ֤ם חֲמִשָּׁה֙ עַתֻּדִ֣ים חֲמִשָּׁ֔ה כְּבָשִׂ֥ים בְּנֵי־שָׁנָ֖ה חֲמִשָּׁ֑ה זֶ֛ה קָרְבַּ֥ן אֶלְיָסָ֖ף בֶּן־דְּעוּאֵֽל׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","בַּיֹּום֙ הַשְּׁבִיעִ֔י נָשִׂ֖יא לִבְנֵ֣י אֶפְרָ֑יִם אֱלִֽישָׁמָ֖ע בֶּן־עַמִּיהֽוּד׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","קָרְבָּנֹ֞ו קַֽעֲרַת־כֶּ֣סֶף אַחַ֗ת שְׁלֹשִׁ֣ים וּמֵאָה֮ מִשְׁקָלָהּ֒ מִזְרָ֤ק אֶחָד֙ כֶּ֔סֶף שִׁבְעִ֥ים שֶׁ֖קֶל בְּשֶׁ֣קֶל הַקֹּ֑דֶשׁ שְׁנֵיהֶ֣ם ׀ מְלֵאִ֗ים סֹ֛לֶת בְּלוּלָ֥ה בַשֶּׁ֖מֶן לְמִנְחָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","כַּ֥ף אַחַ֛ת עֲשָׂרָ֥ה זָהָ֖ב מְלֵאָ֥ה קְטֹֽרֶת׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","פַּ֣ר אֶחָ֞ד בֶּן־בָּקָ֗ר אַ֧יִל אֶחָ֛ד כֶּֽבֶשׂ־אֶחָ֥ד בֶּן־שְׁנָתֹ֖ו לְעֹלָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","שְׂעִיר־עִזִּ֥ים אֶחָ֖ד לְחַטָּֽאת׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","וּלְזֶ֣בַח הַשְּׁלָמִים֮ בָּקָ֣ר שְׁנַיִם֒ אֵילִ֤ם חֲמִשָּׁה֙ עַתֻּדִ֣ים חֲמִשָּׁ֔ה כְּבָשִׂ֥ים בְּנֵֽי־שָׁנָ֖ה חֲמִשָּׁ֑ה זֶ֛ה קָרְבַּ֥ן אֱלִישָׁמָ֖ע בֶּן־עַמִּיהֽוּד׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","בַּיֹּום֙ הַשְּׁמִינִ֔י נָשִׂ֖יא לִבְנֵ֣י מְנַשֶּׁ֑ה גַּמְלִיאֵ֖ל בֶּן־פְּדָה־צֽוּר׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","קָרְבָּנֹ֞ו קַֽעֲרַת־כֶּ֣סֶף אַחַ֗ת שְׁלֹשִׁ֣ים וּמֵאָה֮ מִשְׁקָלָהּ֒ מִזְרָ֤ק אֶחָד֙ כֶּ֔סֶף שִׁבְעִ֥ים שֶׁ֖קֶל בְּשֶׁ֣קֶל הַקֹּ֑דֶשׁ שְׁנֵיהֶ֣ם ׀ מְלֵאִ֗ים סֹ֛לֶת בְּלוּלָ֥ה בַשֶּׁ֖מֶן לְמִנְחָֽה ");
INSERT INTO hbo_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","כַּ֥ף אַחַ֛ת עֲשָׂרָ֥ה זָהָ֖ב מְלֵאָ֥ה קְטֹֽרֶת׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","פַּ֣ר אֶחָ֞ד בֶּן־בָּקָ֗ר אַ֧יִל אֶחָ֛ד כֶּֽבֶשׂ־אֶחָ֥ד בֶּן־שְׁנָתֹ֖ו לְעֹלָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","שְׂעִיר־עִזִּ֥ים אֶחָ֖ד לְחַטָּֽאת׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","וּלְזֶ֣בַח הַשְּׁלָמִים֮ בָּקָ֣ר שְׁנַיִם֒ אֵילִ֤ם חֲמִשָּׁה֙ עַתֻּדִ֣ים חֲמִשָּׁ֔ה כְּבָשִׂ֥ים בְּנֵי־שָׁנָ֖ה חֲמִשָּׁ֑ה זֶ֛ה קָרְבַּ֥ן גַּמְלִיאֵ֖ל בֶּן־פְּדָהצֽוּר׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","בַּיֹּום֙ הַתְּשִׁיעִ֔י נָשִׂ֖יא לִבְנֵ֣י בִנְיָמִ֑ן אֲבִידָ֖ן בֶּן־גִּדְעֹנִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","קָרְבָּנֹ֞ו קַֽעֲרַת־כֶּ֣סֶף אַחַ֗ת שְׁלֹשִׁ֣ים וּמֵאָה֮ מִשְׁקָלָהּ֒ מִזְרָ֤ק אֶחָד֙ כֶּ֔סֶף שִׁבְעִ֥ים שֶׁ֖קֶל בְּשֶׁ֣קֶל הַקֹּ֑דֶשׁ שְׁנֵיהֶ֣ם ׀ מְלֵאִ֗ים סֹ֛לֶת בְּלוּלָ֥ה בַשֶּׁ֖מֶן לְמִנְחָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","כַּ֥ף אַחַ֛ת עֲשָׂרָ֥ה זָהָ֖ב מְלֵאָ֥ה קְטֹֽרֶת׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","פַּ֣ר אֶחָ֞ד בֶּן־בָּקָ֗ר אַ֧יִל אֶחָ֛ד כֶּֽבֶשׂ־אֶחָ֥ד בֶּן־שְׁנָתֹ֖ו לְעֹלָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","שְׂעִיר־עִזִּ֥ים אֶחָ֖ד לְחַטָּֽאת׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","וּלְזֶ֣בַח הַשְּׁלָמִים֮ בָּקָ֣ר שְׁנַיִם֒ אֵילִ֤ם חֲמִשָּׁה֙ עַתֻּדִ֣ים חֲמִשָּׁ֔ה כְּבָשִׂ֥ים בְּנֵי־שָׁנָ֖ה חֲמִשָּׁ֑ה זֶ֛ה קָרְבַּ֥ן אֲבִידָ֖ן בֶּן־גִּדְעֹנִֽי׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","בַּיֹּום֙ הָעֲשִׂירִ֔י נָשִׂ֖יא לִבְנֵ֣י דָ֑ן אֲחִיעֶ֖זֶר בֶּן־עַמִּישַׁדָּֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","קָרְבָּנֹ֞ו קַֽעֲרַת־כֶּ֣סֶף אַחַ֗ת שְׁלֹשִׁ֣ים וּמֵאָה֮ מִשְׁקָלָהּ֒ מִזְרָ֤ק אֶחָד֙ כֶּ֔סֶף שִׁבְעִ֥ים שֶׁ֖קֶל בְּשֶׁ֣קֶל הַקֹּ֑דֶשׁ שְׁנֵיהֶ֣ם ׀ מְלֵאִ֗ים סֹ֛לֶת בְּלוּלָ֥ה בַשֶּׁ֖מֶן לְמִנְחָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","כַּ֥ף אַחַ֛ת עֲשָׂרָ֥ה זָהָ֖ב מְלֵאָ֥ה קְטֹֽרֶת ");
INSERT INTO hbo_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","פַּ֣ר אֶחָ֞ד בֶּן־בָּקָ֗ר אַ֧יִל אֶחָ֛ד כֶּֽבֶשׂ־אֶחָ֥ד בֶּן־שְׁנָתֹ֖ו לְעֹלָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","שְׂעִיר־עִזִּ֥ים אֶחָ֖ד לְחַטָּֽאת׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","וּלְזֶ֣בַח הַשְּׁלָמִים֮ בָּקָ֣ר שְׁנַיִם֒ אֵילִ֤ם חֲמִשָּׁה֙ עַתֻּדִ֣ים חֲמִשָּׁ֔ה כְּבָשִׂ֥ים בְּנֵֽי־שָׁנָ֖ה חֲמִשָּׁ֑ה זֶ֛ה קָרְבַּ֥ן אֲחִיעֶ֖זֶר בֶּן־עַמִּישַׁדָּֽי׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","בְּיֹום֙ עַשְׁתֵּ֣י עָשָׂ֣ר יֹ֔ום נָשִׂ֖יא לִבְנֵ֣י אָשֵׁ֑ר פַּגְעִיאֵ֖ל בֶּן־עָכְרָֽן׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","קָרְבָּנֹ֞ו קַֽעֲרַת־כֶּ֣סֶף אַחַ֗ת שְׁלֹשִׁ֣ים וּמֵאָה֮ מִשְׁקָלָהּ֒ מִזְרָ֤ק אֶחָד֙ כֶּ֔סֶף שִׁבְעִ֥ים שֶׁ֖קֶל בְּשֶׁ֣קֶל הַקֹּ֑דֶשׁ שְׁנֵיהֶ֣ם ׀ מְלֵאִ֗ים סֹ֛לֶת בְּלוּלָ֥ה בַשֶּׁ֖מֶן לְמִנְחָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","כַּ֥ף אַחַ֛ת עֲשָׂרָ֥ה זָהָ֖ב מְלֵאָ֥ה קְטֹֽרֶת׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","פַּ֣ר אֶחָ֞ד בֶּן־בָּקָ֗ר אַ֧יִל אֶחָ֛ד כֶּֽבֶשׂ־אֶחָ֥ד בֶּן־שְׁנָתֹ֖ו לְעֹלָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","שְׂעִיר־עִזִּ֥ים אֶחָ֖ד לְחַטָּֽאת׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","וּלְזֶ֣בַח הַשְּׁלָמִים֮ בָּקָ֣ר שְׁנַיִם֒ אֵילִ֤ם חֲמִשָּׁה֙ עַתֻּדִ֣ים חֲמִשָּׁ֔ה כְּבָשִׂ֥ים בְּנֵֽי־שָׁנָ֖ה חֲמִשָּׁ֑ה זֶ֛ה קָרְבַּ֥ן פַּגְעִיאֵ֖ל בֶּן־עָכְרָֽן׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","בְּיֹום֙ שְׁנֵ֣ים עָשָׂ֣ר יֹ֔ום נָשִׂ֖יא לִבְנֵ֣י נַפְתָּלִ֑י אֲחִירַ֖ע בֶּן־עֵינָֽן׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","קָרְבָּנֹ֞ו קֽ͏ַעֲרַת־כֶּ֣סֶף אַחַ֗ת שְׁלֹשִׁ֣ים וּמֵאָה֮ מִשְׁקָלָהּ֒ מִזְרָ֤ק אֶחָד֙ כֶּ֔סֶף שִׁבְעִ֥ים שֶׁ֖קֶל בְּשֶׁ֣קֶל הַקֹּ֑דֶשׁ שְׁנֵיהֶ֣ם ׀ מְלֵאִ֗ים סֹ֛לֶת בְּלוּלָ֥ה בַשֶּׁ֖מֶן לְמִנְחָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","כַּ֥ף אַחַ֛ת עֲשָׂרָ֥ה זָהָ֖ב מְלֵאָ֥ה קְטֹֽרֶת׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","פַּ֣ר אֶחָ֞ד בֶּן־בָּקָ֗ר אַ֧יִל אֶחָ֛ד כֶּֽבֶשׂ־אֶחָ֥ד בֶּן־שְׁנָתֹ֖ו לְעֹלָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","שְׂעִיר־עִזִּ֥ים אֶחָ֖ד לְחַטָּֽאת׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","וּלְזֶ֣בַח הַשְּׁלָמִים֮ בָּקָ֣ר שְׁנַיִם֒ אֵילִ֤ם חֲמִשָּׁה֙ עַתֻּדִ֣ים חֲמִשָּׁ֔ה כְּבָשִׂ֥ים בְּנֵֽי־שָׁנָ֖ה חֲמִשָּׁ֑ה זֶ֛ה קָרְבַּ֥ן אֲחִירַ֖ע בֶּן־עֵינָֽן׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","זֹ֣את ׀ חֲנֻכַּ֣ת הַמִּזְבֵּ֗חַ בְּיֹום֙ הִמָּשַׁ֣ח אֹתֹ֔ו מֵאֵ֖ת נְשִׂיאֵ֣י יִשְׂרָאֵ֑ל קַעֲרֹ֨ת כֶּ֜סֶף שְׁתֵּ֣ים עֶשְׂרֵ֗ה מִֽזְרְקֵי־כֶ֙סֶף֙ שְׁנֵ֣ים עָשָׂ֔ר כַּפֹּ֥ות זָהָ֖ב שְׁתֵּ֥ים עֶשְׂרֵֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","שְׁלֹשִׁ֣ים וּמֵאָ֗ה הַקְּעָרָ֤ה הָֽאַחַת֙ כֶּ֔סֶף וְשִׁבְעִ֖ים הַמִּזְרָ֣ק הָאֶחָ֑ד כֹּ֚ל כֶּ֣סֶף הַכֵּלִ֔ים אַלְפַּ֥יִם וְאַרְבַּע־מֵאֹ֖ות בְּשֶׁ֥קֶל הַקֹּֽדֶשׁ׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","כַּפֹּ֨ות זָהָ֤ב שְׁתֵּים־עֶשְׂרֵה֙ מְלֵאֹ֣ת קְטֹ֔רֶת עֲשָׂרָ֧ה עֲשָׂרָ֛ה הַכַּ֖ף בְּשֶׁ֣קֶל הַקֹּ֑דֶשׁ כָּל־זְהַ֥ב הַכַּפֹּ֖ות עֶשְׂרִ֥ים וּמֵאָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","כָּל־הַבָּקָ֨ר לָעֹלָ֜ה שְׁנֵ֧ים עָשָׂ֣ר פָּרִ֗ים אֵילִ֤ם שְׁנֵים־עָשָׂר֙ כְּבָשִׂ֧ים בְּנֵֽי־שָׁנָ֛ה שְׁנֵ֥ים עָשָׂ֖ר וּמִנְחָתָ֑ם וּשְׂעִירֵ֥י עִזִּ֛ים שְׁנֵ֥ים עָשָׂ֖ר לְחַטָּֽאת׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","וְכֹ֞ל בְּקַ֣ר ׀ זֶ֣בַח הַשְּׁלָמִ֗ים עֶשְׂרִ֣ים וְאַרְבָּעָה֮ פָּרִים֒ אֵילִ֤ם שִׁשִּׁים֙ עַתֻּדִ֣ים שִׁשִּׁ֔ים כְּבָשִׂ֥ים בְּנֵי־שָׁנָ֖ה שִׁשִּׁ֑ים זֹ֚את חֲנֻכַּ֣ת הַמִּזְבֵּ֔חַ אַחֲרֵ֖י הִמָּשַׁ֥ח אֹתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","וּבְבֹ֨א מֹשֶׁ֜ה אֶל־אֹ֣הֶל מֹועֵד֮ לְדַבֵּ֣ר אִתֹּו֒ וַיִּשְׁמַ֨ע אֶת־הַקֹּ֜ול מִדַּבֵּ֣ר אֵלָ֗יו מֵעַ֤ל הַכַּפֹּ֙רֶת֙ אֲשֶׁר֙ עַל־אֲרֹ֣ן הָעֵדֻ֔ת מִבֵּ֖ין שְׁנֵ֣י הַכְּרֻבִ֑ים וַיְדַבֵּ֖ר אֵלָֽיו׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","דַּבֵּר֙ אֶֽל־אַהֲרֹ֔ן וְאָמַרְתָּ֖ אֵלָ֑יו בְּהַעֲלֹֽתְךָ֙ אֶת־הַנֵּרֹ֔ת אֶל־מוּל֙ פְּנֵ֣י הַמְּנֹורָ֔ה יָאִ֖ירוּ שִׁבְעַ֥ת הַנֵּרֹֽות׃ ");
INSERT INTO hbo_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","וַיַּ֤עַשׂ כֵּן֙ אַהֲרֹ֔ן אֶל־מוּל֙ פְּנֵ֣י הַמְּנֹורָ֔ה הֶעֱלָ֖ה נֵרֹתֶ֑יהָ כּֽ͏ַאֲשֶׁ֛ר צִוָּ֥ה יְהוָ֖ה אֶת־מֹשֶֽׁה׃ ");
INSERT INTO hbo_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","וְזֶ֨ה מַעֲשֵׂ֤ה הַמְּנֹרָה֙ מִקְשָׁ֣ה זָהָ֔ב עַד־יְרֵכָ֥הּ עַד־פִּרְחָ֖הּ מִקְשָׁ֣ה הִ֑וא כַּמַּרְאֶ֗ה אֲשֶׁ֨ר הֶרְאָ֤ה יְהוָה֙ אֶת־מֹשֶׁ֔ה כֵּ֥ן עָשָׂ֖ה אֶת־הַמְּנֹרָֽה׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","קַ֚ח אֶת־הַלְוִיִּ֔ם מִתֹּ֖וךְ בְּנֵ֣י יִשְׂרָאֵ֑ל וְטִהַרְתָּ֖ אֹתָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","וְכֹֽה־תַעֲשֶׂ֤ה לָהֶם֙ לְטֽ͏ַהֲרָ֔ם הַזֵּ֥ה עֲלֵיהֶ֖ם מֵ֣י חַטָּ֑את וְהֶעֱבִ֤ירוּ תַ֙עַר֙ עַל־כָּל־בְּשָׂרָ֔ם וְכִבְּס֥וּ בִגְדֵיהֶ֖ם וְהִטֶּהָֽרוּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","וְלָֽקְחוּ֙ פַּ֣ר בֶּן־בָּקָ֔ר וּמִנְחָתֹ֔ו סֹ֖לֶת בְּלוּלָ֣ה בַשָּׁ֑מֶן וּפַר־שֵׁנִ֥י בֶן־בָּקָ֖ר תִּקַּ֥ח לְחַטָּֽאת׃ ");
INSERT INTO hbo_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","וְהִקְרַבְתָּ֙ אֶת־הַלְוִיִּ֔ם לִפְנֵ֖י אֹ֣הֶל מֹועֵ֑ד וְהִ֨קְהַלְתָּ֔ אֶֽת־כָּל־עֲדַ֖ת בְּנֵ֥י יִשְׂרָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","וְהִקְרַבְתָּ֥ אֶת־הַלְוִיִּ֖ם לִפְנֵ֣י יְהוָ֑ה וְסָמְכ֧וּ בְנֵי־יִשְׂרָאֵ֛ל אֶת־יְדֵיהֶ֖ם עַל־הַלְוִיִּֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","וְהֵנִיף֩ אַהֲרֹ֨ן אֶת־הַלְוִיִּ֤ם תְּנוּפָה֙ לִפְנֵ֣י יְהוָ֔ה מֵאֵ֖ת בְּנֵ֣י יִשְׂרָאֵ֑ל וְהָי֕וּ לַעֲבֹ֖ד אֶת־עֲבֹדַ֥ת יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","וְהַלְוִיִּם֙ יִסְמְכ֣וּ אֶת־יְדֵיהֶ֔ם עַ֖ל רֹ֣אשׁ הַפָּרִ֑ים וַ֠עֲשֵׂה אֶת־הָאֶחָ֨ד חַטָּ֜את וְאֶת־הָאֶחָ֤ד עֹלָה֙ לַֽיהוָ֔ה לְכַפֵּ֖ר עַל־הַלְוִיִּֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","וְהַֽעֲמַדְתָּ֙ אֶת־הַלְוִיִּ֔ם לִפְנֵ֥י אַהֲרֹ֖ן וְלִפְנֵ֣י בָנָ֑יו וְהֵנַפְתָּ֥ אֹתָ֛ם תְּנוּפָ֖ה לַֽיהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","וְהִבְדַּלְתָּ֙ אֶת־הַלְוִיִּ֔ם מִתֹּ֖וךְ בְּנֵ֣י יִשְׂרָאֵ֑ל וְהָ֥יוּ לִ֖י הַלְוִיִּֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","וְאַֽחֲרֵי־כֵן֙ יָבֹ֣אוּ הַלְוִיִּ֔ם לַעֲבֹ֖ד אֶת־אֹ֣הֶל מֹועֵ֑ד וְטִֽהַרְתָּ֣ אֹתָ֔ם וְהֵנַפְתָּ֥ אֹתָ֖ם תְּנוּפָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","כִּי֩ נְתֻנִ֨ים נְתֻנִ֥ים הֵ֙מָּה֙ לִ֔י מִתֹּ֖וךְ בְּנֵ֣י יִשְׂרָאֵ֑ל תַּחַת֩ פִּטְרַ֨ת כָּל־רֶ֜חֶם בְּכֹ֥ור כֹּל֙ מִבְּנֵ֣י יִשְׂרָאֵ֔ל לָקַ֥חְתִּי אֹתָ֖ם לִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","כִּ֣י לִ֤י כָל־בְּכֹור֙ בִּבְנֵ֣י יִשְׂרָאֵ֔ל בָּאָדָ֖ם וּבַבְּהֵמָ֑ה בְּיֹ֗ום הַכֹּתִ֤י כָל־בְּכֹור֙ בְּאֶ֣רֶץ מִצְרַ֔יִם הִקְדַּ֥שְׁתִּי אֹתָ֖ם לִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","וָאֶקַּח֙ אֶת־הַלְוִיִּ֔ם תַּ֥חַת כָּל־בְּכֹ֖ור בִּבְנֵ֥י יִשְׂרָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","וָאֶתְּנָ֨ה אֶת־הַלְוִיִּ֜ם נְתֻנִ֣ים ׀ לְאַהֲרֹ֣ן וּלְבָנָ֗יו מִתֹּוךְ֮ בְּנֵ֣י יִשְׂרָאֵל֒ לַעֲבֹ֞ד אֶת־עֲבֹדַ֤ת בְּנֵֽי־יִשְׂרָאֵל֙ בְּאֹ֣הֶל מֹועֵ֔ד וּלְכַפֵּ֖ר עַל־בְּנֵ֣י יִשְׂרָאֵ֑ל וְלֹ֨א יִהְיֶ֜ה בִּבְנֵ֤י יִשְׂרָאֵל֙ נֶ֔גֶף בְּגֶ֥שֶׁת בְּנֵֽי־יִשְׂרָאֵ֖ל אֶל־הַקֹּֽדֶשׁ׃ ");
INSERT INTO hbo_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","וַיַּ֨עַשׂ מֹשֶׁ֧ה וְאַהֲרֹ֛ן וְכָל־עֲדַ֥ת בְּנֵי־יִשְׂרָאֵ֖ל לַלְוִיִּ֑ם כְּ֠כֹל אֲשֶׁר־צִוָּ֨ה יְהוָ֤ה אֶת־מֹשֶׁה֙ לַלְוִיִּ֔ם כֵּן־עָשׂ֥וּ לָהֶ֖ם בְּנֵ֥י יִשְׂרָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","וַיִּֽתְחַטְּא֣וּ הַלְוִיִּ֗ם וַֽיְכַבְּסוּ֙ בִּגְדֵיהֶ֔ם וַיָּ֨נֶף אַהֲרֹ֥ן אֹתָ֛ם תְּנוּפָ֖ה לִפְנֵ֣י יְהוָ֑ה וַיְכַפֵּ֧ר עֲלֵיהֶ֛ם אַהֲרֹ֖ן לְטַהֲרָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","וְאַחֲרֵי־כֵ֞ן בָּ֣אוּ הַלְוִיִּ֗ם לַעֲבֹ֤ד אֶת־עֲבֹֽדָתָם֙ בְּאֹ֣הֶל מֹועֵ֔ד לִפְנֵ֥י אַהֲרֹ֖ן וְלִפְנֵ֣י בָנָ֑יו כַּאֲשֶׁר֩ צִוָּ֨ה יְהוָ֤ה אֶת־מֹשֶׁה֙ עַל־הַלְוִיִּ֔ם כֵּ֖ן עָשׂ֥וּ לָהֶֽם׃ ס ");
INSERT INTO hbo_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","זֹ֖את אֲשֶׁ֣ר לַלְוִיִּ֑ם מִבֶּן֩ חָמֵ֨שׁ וְעֶשְׂרִ֤ים שָׁנָה֙ וָמַ֔עְלָה יָבֹוא֙ לִצְבֹ֣א צָבָ֔א בַּעֲבֹדַ֖ת אֹ֥הֶל מֹועֵֽד׃ ");
INSERT INTO hbo_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","וּמִבֶּן֙ חֲמִשִּׁ֣ים שָׁנָ֔ה יָשׁ֖וּב מִצְּבָ֣א הָעֲבֹדָ֑ה וְלֹ֥א יַעֲבֹ֖ד עֹֽוד׃ ");
INSERT INTO hbo_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","וְשֵׁרֵ֨ת אֶת־אֶחָ֜יו בְּאֹ֤הֶל מֹועֵד֙ לִשְׁמֹ֣ר מִשְׁמֶ֔רֶת וַעֲבֹדָ֖ה לֹ֣א יַעֲבֹ֑ד כָּ֛כָה תַּעֲשֶׂ֥ה לַלְוִיִּ֖ם בְּמִשְׁמְרֹתָֽם׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","וַיְדַבֵּ֣ר יְהוָ֣ה אֶל־מֹשֶׁ֣ה בְמִדְבַּר־סִ֠ינַי בַּשָּׁנָ֨ה הַשֵּׁנִ֜ית לְצֵאתָ֨ם מֵאֶ֧רֶץ מִצְרַ֛יִם בַּחֹ֥דֶשׁ הָרִאשֹׁ֖ון לֵאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","וְיַעֲשׂ֧וּ בְנֵי־יִשְׂרָאֵ֛ל אֶת־הַפָּ֖סַח בְּמֹועֲדֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","בְּאַרְבָּעָ֣ה עָשָֽׂר־יֹ֠ום בַּחֹ֨דֶשׁ הַזֶּ֜ה בֵּ֧ין הָֽעֲרְבַּ֛יִם תַּעֲשׂ֥וּ אֹתֹ֖ו בְּמֹועֲדֹ֑ו כְּכָל־חֻקֹּתָ֥יו וּכְכָל־מִשְׁפָּטָ֖יו תַּעֲשׂ֥וּ אֹתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","וַיְדַבֵּ֥ר מֹשֶׁ֛ה אֶל־בְּנֵ֥י יִשְׂרָאֵ֖ל לַעֲשֹׂ֥ת הַפָּֽסַח׃ ");
INSERT INTO hbo_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","וַיַּעֲשׂ֣וּ אֶת־הַפֶּ֡סַח בָּרִאשֹׁ֡ון בְּאַרְבָּעָה֩ עָשָׂ֨ר יֹ֥ום לַחֹ֛דֶשׁ בֵּ֥ין הָעַרְבַּ֖יִם בְּמִדְבַּ֣ר סִינָ֑י כְּ֠כֹל אֲשֶׁ֨ר צִוָּ֤ה יְהוָה֙ אֶת־מֹשֶׁ֔ה כֵּ֥ן עָשׂ֖וּ בְּנֵ֥י יִשְׂרָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","וַיְהִ֣י אֲנָשִׁ֗ים אֲשֶׁ֨ר הָי֤וּ טְמֵאִים֙ לְנֶ֣פֶשׁ אָדָ֔ם וְלֹא־יָכְל֥וּ לַעֲשֹׂת־הַפֶּ֖סַח בַּיֹּ֣ום הַה֑וּא וַֽיִּקְרְב֞וּ לִפְנֵ֥י מֹשֶׁ֛ה וְלִפְנֵ֥י אַהֲרֹ֖ן בַּיֹּ֥ום הַהֽוּא׃ ");
INSERT INTO hbo_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","וַ֠יֹּאמְרוּ הָאֲנָשִׁ֤ים הָהֵ֙מָּה֙ אֵלָ֔יו אֲנַ֥חְנוּ טְמֵאִ֖ים לְנֶ֣פֶשׁ אָדָ֑ם לָ֣מָּה נִגָּרַ֗ע לְבִלְתִּ֨י הַקְרִ֜ב אֶת־קָרְבַּ֤ן יְהוָה֙ בְּמֹ֣עֲדֹ֔ו בְּתֹ֖וךְ בְּנֵ֥י יִשְׂרָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","וַיֹּ֥אמֶר אֲלֵהֶ֖ם מֹשֶׁ֑ה עִמְד֣וּ וְאֶשְׁמְעָ֔ה מַה־יְצַוֶּ֥ה יְהוָ֖ה לָכֶֽם׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","דַּבֵּ֛ר אֶל־בְּנֵ֥י יִשְׂרָאֵ֖ל לֵאמֹ֑ר אִ֣ישׁ אִ֣ישׁ כִּי־יִהְיֶֽה־טָמֵ֣א ׀ לָנֶ֡פֶשׁ אֹו֩ בְדֶ֨רֶךְ רְחֹקָ֜הׄ לָכֶ֗ם אֹ֚ו לְדֹרֹ֣תֵיכֶ֔ם וְעָ֥שָׂה פֶ֖סַח לַיהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","בַּחֹ֨דֶשׁ הַשֵּׁנִ֜י בְּאַרְבָּעָ֨ה עָשָׂ֥ר יֹ֛ום בֵּ֥ין הָעַרְבַּ֖יִם יַעֲשׂ֣וּ אֹתֹ֑ו עַל־מַצֹּ֥ות וּמְרֹרִ֖ים יֹאכְלֻֽהוּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","לֹֽא־יַשְׁאִ֤ירוּ מִמֶּ֙נּוּ֙ עַד־בֹּ֔קֶר וְעֶ֖צֶם לֹ֣א יִשְׁבְּרוּ־בֹ֑ו כְּכָל־חֻקַּ֥ת הַפֶּ֖סַח יַעֲשׂ֥וּ אֹתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","וְהָאִישׁ֩ אֲשֶׁר־ה֨וּא טָהֹ֜ור וּבְדֶ֣רֶךְ לֹא־הָיָ֗ה וְחָדַל֙ לַעֲשֹׂ֣ות הַפֶּ֔סַח וְנִכְרְתָ֛ה הַנֶּ֥פֶשׁ הַהִ֖וא מֵֽעַמֶּ֑יהָ כִּ֣י ׀ קָרְבַּ֣ן יְהוָ֗ה לֹ֤א הִקְרִיב֙ בְּמֹ֣עֲדֹ֔ו חֶטְאֹ֥ו יִשָּׂ֖א הָאִ֥ישׁ הַהֽוּא׃ ");
INSERT INTO hbo_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","וְכִֽי־יָג֨וּר אִתְּכֶ֜ם גֵּ֗ר וְעָ֤שָֽׂה פֶ֙סַח֙ לַֽיהוָ֔ה כְּחֻקַּ֥ת הַפֶּ֛סַח וּכְמִשְׁפָּטֹ֖ו כֵּ֣ן יַעֲשֶׂ֑ה חֻקָּ֤ה אַחַת֙ יִהְיֶ֣ה לָכֶ֔ם וְלַגֵּ֖ר וּלְאֶזְרַ֥ח הָאָֽרֶץ׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","וּבְיֹום֙ הָקִ֣ים אֶת־הַמִּשְׁכָּ֔ן כִּסָּ֤ה הֶֽעָנָן֙ אֶת־הַמִּשְׁכָּ֔ן לְאֹ֖הֶל הָעֵדֻ֑ת וּבָעֶ֜רֶב יִהְיֶ֧ה עַֽל־הַמִּשְׁכָּ֛ן כְּמַרְאֵה־אֵ֖שׁ עַד־בֹּֽקֶר׃ ");
INSERT INTO hbo_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","כֵּ֚ן יִהְיֶ֣ה תָמִ֔יד הֶעָנָ֖ן יְכַסֶּ֑נּוּ וּמַרְאֵה־אֵ֖שׁ לָֽיְלָה׃ ");
INSERT INTO hbo_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","וּלְפִ֞י הֵעָלֹ֤ת הֶֽעָנָן֙ מֵעַ֣ל הָאֹ֔הֶל וְאַ֣חֲרֵי־כֵ֔ן יִסְע֖וּ בְּנֵ֣י יִשְׂרָאֵ֑ל וּבִמְקֹ֗ום אֲשֶׁ֤ר יִשְׁכָּן־שָׁם֙ הֶֽעָנָ֔ן שָׁ֥ם יַחֲנ֖וּ בְּנֵ֥י יִשְׂרָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","עַל־פִּ֣י יְהוָ֗ה יִסְעוּ֙ בְּנֵ֣י יִשְׂרָאֵ֔ל וְעַל־פִּ֥י יְהוָ֖ה יַחֲנ֑וּ כָּל־יְמֵ֗י אֲשֶׁ֨ר יִשְׁכֹּ֧ן הֶעָנָ֛ן עַל־הַמִּשְׁכָּ֖ן יַחֲנֽוּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","וּבְהַאֲרִ֧יךְ הֶֽעָנָ֛ן עַל־הַמִּשְׁכָּ֖ן יָמִ֣ים רַבִּ֑ים וְשָׁמְר֧וּ בְנֵי־יִשְׂרָאֵ֛ל אֶת־מִשְׁמֶ֥רֶת יְהוָ֖ה וְלֹ֥א יִסָּֽעוּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","וְיֵ֞שׁ אֲשֶׁ֨ר יִהְיֶ֧ה הֶֽעָנָ֛ן יָמִ֥ים מִסְפָּ֖ר עַל־הַמִּשְׁכָּ֑ן עַל־פִּ֤י יְהוָה֙ יַחֲנ֔וּ וְעַל־פִּ֥י יְהוָ֖ה יִסָּֽעוּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","וְיֵ֞שׁ אֲשֶׁר־יִהְיֶ֤ה הֶֽעָנָן֙ מֵעֶ֣רֶב עַד־בֹּ֔קֶר וְנַעֲלָ֧ה הֶֽעָנָ֛ן בַּבֹּ֖קֶר וְנָסָ֑עוּ אֹ֚ו יֹומָ֣ם וָלַ֔יְלָה וְנַעֲלָ֥ה הֶעָנָ֖ן וְנָסָֽעוּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","אֹֽו־יֹמַ֜יִם אֹו־חֹ֣דֶשׁ אֹו־יָמִ֗ים בְּהַאֲרִ֨יךְ הֶעָנָ֤ן עַל־הַמִּשְׁכָּן֙ לִשְׁכֹּ֣ן עָלָ֔יו יַחֲנ֥וּ בְנֵֽי־יִשְׂרָאֵ֖ל וְלֹ֣א יִסָּ֑עוּ וּבְהֵעָלֹתֹ֖ו יִסָּֽעוּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","עַל־פִּ֤י יְהוָה֙ יַחֲנ֔וּ וְעַל־פִּ֥י יְהוָ֖ה יִסָּ֑עוּ אֶת־מִשְׁמֶ֤רֶת יְהוָה֙ שָׁמָ֔רוּ עַל־פִּ֥י יְהוָ֖ה בְּיַד־מֹשֶֽׁה׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","עֲשֵׂ֣ה לְךָ֗ שְׁתֵּי֙ חֲצֹֽוצְרֹ֣ת כֶּ֔סֶף מִקְשָׁ֖ה תַּעֲשֶׂ֣ה אֹתָ֑ם וְהָי֤וּ לְךָ֙ לְמִקְרָ֣א הָֽעֵדָ֔ה וּלְמַסַּ֖ע אֶת־הַֽמַּחֲנֹֽות׃ ");
INSERT INTO hbo_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","וְתָקְע֖וּ בָּהֵ֑ן וְנֹֽועֲד֤וּ אֵלֶ֙יךָ֙ כָּל־הָ֣עֵדָ֔ה אֶל־פֶּ֖תַח אֹ֥הֶל מֹועֵֽד׃ ");
INSERT INTO hbo_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","וְאִם־בְּאַחַ֖ת יִתְקָ֑עוּ וְנֹועֲד֤וּ אֵלֶ֙יךָ֙ הַנְּשִׂיאִ֔ים רָאשֵׁ֖י אַלְפֵ֥י יִשְׂרָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","וּתְקַעְתֶּ֖ם תְּרוּעָ֑ה וְנָֽסְעוּ֙ הַֽמַּחֲנֹ֔ות הַחֹנִ֖ים קֵֽדְמָה׃ ");
INSERT INTO hbo_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","וּתְקַעְתֶּ֤ם תְּרוּעָה֙ שֵׁנִ֔ית וְנָֽסְעוּ֙ הַֽמַּחֲנֹ֔ות הַחֹנִ֖ים תֵּימָ֑נָה תְּרוּעָ֥ה יִתְקְע֖וּ לְמַסְעֵיהֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","וּבְהַקְהִ֖יל אֶת־הַקָּהָ֑ל תִּתְקְע֖וּ וְלֹ֥א תָרִֽיעוּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","וּבְנֵ֤י אַהֲרֹן֙ הַכֹּ֣הֲנִ֔ים יִתְקְע֖וּ בּֽ͏ַחֲצֹצְרֹ֑ות וְהָי֥וּ לָכֶ֛ם לְחֻקַּ֥ת עֹולָ֖ם לְדֹרֹתֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","וְכִֽי־תָבֹ֨אוּ מִלְחָמָ֜ה בְּאַרְצְכֶ֗ם עַל־הַצַּר֙ הַצֹּרֵ֣ר אֶתְכֶ֔ם וַהֲרֵעֹתֶ֖ם בַּחֲצֹצְרֹ֑ות וֲנִזְכַּרְתֶּ֗ם לִפְנֵי֙ יְהוָ֣ה אֱלֹֽהֵיכֶ֔ם וְנֹושַׁעְתֶּ֖ם מֵאֹיְבֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","וּבְיֹ֨ום שִׂמְחַתְכֶ֥ם וּֽבְמֹועֲדֵיכֶם֮ וּבְרָאשֵׁ֣י חָדְשֵׁיכֶם֒ וּתְקַעְתֶּ֣ם בַּחֲצֹֽצְרֹ֗ת עַ֚ל עֹלֹ֣תֵיכֶ֔ם וְעַ֖ל זִבְחֵ֣י שַׁלְמֵיכֶ֑ם וְהָי֨וּ לָכֶ֤ם לְזִכָּרֹון֙ לִפְנֵ֣י אֱלֹֽהֵיכֶ֔ם אֲנִ֖י יְהוָ֥ה אֱלֹהֵיכֶֽם׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","וַיְהִ֞י בַּשָּׁנָ֧ה הַשֵּׁנִ֛ית בַּחֹ֥דֶשׁ הַשֵּׁנִ֖י בְּעֶשְׂרִ֣ים בַּחֹ֑דֶשׁ נַעֲלָה֙ הֶֽעָנָ֔ן מֵעַ֖ל מִשְׁכַּ֥ן הָעֵדֻֽת׃ ");
INSERT INTO hbo_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","וַיִּסְע֧וּ בְנֵֽי־יִשְׂרָאֵ֛ל לְמַסְעֵיהֶ֖ם מִמִּדְבַּ֣ר סִינָ֑י וַיִּשְׁכֹּ֥ן הֶעָנָ֖ן בְּמִדְבַּ֥ר פָּארָֽן׃ ");
INSERT INTO hbo_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","וַיִּסְע֖וּ בָּרִאשֹׁנָ֑ה עַל־פִּ֥י יְהוָ֖ה בְּיַד־מֹשֶֽׁה׃ ");
INSERT INTO hbo_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","וַיִּסַּ֞ע דֶּ֣גֶל מַחֲנֵ֧ה בְנֵֽי־יְהוּדָ֛ה בָּרִאשֹׁנָ֖ה לְצִבְאֹתָ֑ם וְעַל־צְבָאֹ֔ו נַחְשֹׁ֖ון בֶּן־עַמִּינָדָֽב׃ ");
INSERT INTO hbo_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","וְעַ֨ל־צְבָ֔א מַטֵּ֖ה בְּנֵ֣י יִשָׂשכָ֑ר נְתַנְאֵ֖ל בֶּן־צוּעָֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","וְעַ֨ל־צְבָ֔א מַטֵּ֖ה בְּנֵ֣י זְבוּלֻ֑ן אֱלִיאָ֖ב בֶּן־חֵלֹֽון׃ ");
INSERT INTO hbo_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","וְהוּרַ֖ד הַמִּשְׁכָּ֑ן וְנָסְע֤וּ בְנֵֽי־גֵרְשֹׁון֙ וּבְנֵ֣י מְרָרִ֔י נֹשְׂאֵ֖י הַמִּשְׁכָּֽן׃ ס ");
INSERT INTO hbo_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","וְנָסַ֗ע דֶּ֛גֶל מַחֲנֵ֥ה רְאוּבֵ֖ן לְצִבְאֹתָ֑ם וְעַל־צְבָאֹ֔ו אֱלִיצ֖וּר בֶּן־שְׁדֵיאֽוּר׃ ");
INSERT INTO hbo_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","וְעַ֨ל־צְבָ֔א מַטֵּ֖ה בְּנֵ֣י שִׁמְעֹ֑ון שְׁלֻֽמִיאֵ֖ל בֶּן־צוּרִֽי שַׁדָּֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","וְעַל־צְבָ֖א מַטֵּ֣ה בְנֵי־גָ֑ד אֶלְיָסָ֖ף בֶּן־דְּעוּאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","וְנָסְעוּ֙ הַקְּהָתִ֔ים נֹשְׂאֵ֖י הַמִּקְדָּ֑שׁ וְהֵקִ֥ימוּ אֶת־הַמִּשְׁכָּ֖ן עַד־בֹּאָֽם׃ ס ");
INSERT INTO hbo_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","וְנָסַ֗ע דֶּ֛גֶל מַחֲנֵ֥ה בְנֵֽי־אֶפְרַ֖יִם לְצִבְאֹתָ֑ם וְעַל־צְבָאֹ֔ו אֱלִישָׁמָ֖ע בֶּן־עַמִּיהֽוּד׃ ");
INSERT INTO hbo_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","וְעַ֨ל־צְבָ֔א מַטֵּ֖ה בְּנֵ֣י מְנַשֶּׁ֑ה גַּמְלִיאֵ֖ל בֶּן־פְּדָה־צֽוּר׃ ");
INSERT INTO hbo_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","וְעַ֨ל־צְבָ֔א מַטֵּ֖ה בְּנֵ֣י בִנְיָמִ֑ן אֲבִידָ֖ן בֶּן־גִּדְעֹונִֽי׃ ס ");
INSERT INTO hbo_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","וְנָסַ֗ע דֶּ֚גֶל מַחֲנֵ֣ה בְנֵי־דָ֔ן מְאַסֵּ֥ף לְכָל־הַֽמַּחֲנֹ֖ת לְצִבְאֹתָ֑ם וְעַל־צְבָאֹ֔ו אֲחִיעֶ֖זֶר בֶּן־עַמִּישַׁדָּֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","וְעַל־צְבָ֔א מַטֵּ֖ה בְּנֵ֣י אָשֵׁ֑ר פַּגְעִיאֵ֖ל בֶּן־עָכְרָֽן׃ ");
INSERT INTO hbo_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","וְעַ֨ל־צְבָ֔א מַטֵּ֖ה בְּנֵ֣י נַפְתָּלִ֑י אֲחִירַ֖ע בֶּן־עֵינָֽן׃ ");
INSERT INTO hbo_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","אֵ֛לֶּה מַסְעֵ֥י בְנֵֽי־יִשְׂרָאֵ֖ל לְצִבְאֹתָ֑ם וַיִּסָּֽעוּ׃ ס ");
INSERT INTO hbo_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","וַיֹּ֣אמֶר מֹשֶׁ֗ה לְ֠חֹבָב בֶּן־רְעוּאֵ֣ל הַמִּדְיָנִי֮ חֹתֵ֣ן מֹשֶׁה֒ נֹסְעִ֣ים ׀ אֲנַ֗חְנוּ אֶל־הַמָּקֹום֙ אֲשֶׁ֣ר אָמַ֣ר יְהוָ֔ה אֹתֹ֖ו אֶתֵּ֣ן לָכֶ֑ם לְכָ֤ה אִתָּ֙נוּ֙ וְהֵטַ֣בְנוּ לָ֔ךְ כִּֽי־יְהוָ֥ה דִּבֶּר־טֹ֖וב עַל־יִשְׂרָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","וַיֹּ֥אמֶר אֵלָ֖יו לֹ֣א אֵלֵ֑ךְ כִּ֧י אִם־אֶל־אַרְצִ֛י וְאֶל־מֹולַדְתִּ֖י אֵלֵֽךְ׃ ");
INSERT INTO hbo_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","וַיֹּ֕אמֶר אַל־נָ֖א תַּעֲזֹ֣ב אֹתָ֑נוּ כִּ֣י ׀ עַל־כֵּ֣ן יָדַ֗עְתָּ חֲנֹתֵ֙נוּ֙ בַּמִּדְבָּ֔ר וְהָיִ֥יתָ לָּ֖נוּ לְעֵינָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","וְהָיָ֖ה כִּי־תֵלֵ֣ךְ עִמָּ֑נוּ וְהָיָ֣ה ׀ הַטֹּ֣וב הַה֗וּא אֲשֶׁ֨ר יֵיטִ֧יב יְהוָ֛ה עִמָּ֖נוּ וְהֵטַ֥בְנוּ לָֽךְ׃ ");
INSERT INTO hbo_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","וַיִּסְעוּ֙ מֵהַ֣ר יְהוָ֔ה דֶּ֖רֶךְ שְׁלֹ֣שֶׁת יָמִ֑ים וַאֲרֹ֨ון בְּרִית־יְהוָ֜ה נֹסֵ֣עַ לִפְנֵיהֶ֗ם דֶּ֚רֶךְ שְׁלֹ֣שֶׁת יָמִ֔ים לָת֥וּר לָהֶ֖ם מְנוּחָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","וַעֲנַ֧ן יְהוָ֛ה עֲלֵיהֶ֖ם יֹומָ֑ם בְּנָסְעָ֖ם מִן־הַֽמַּחֲנֶֽה׃ ׆ ס ");
INSERT INTO hbo_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","וַיְהִ֛י בִּנְסֹ֥עַ הָאָרֹ֖ן וַיֹּ֣אמֶר מֹשֶׁ֑ה קוּמָ֣ה ׀ יְהוָ֗ה וְיָפֻ֙צוּ֙ אֹֽיְבֶ֔יךָ וְיָנֻ֥סוּ מְשַׂנְאֶ֖יךָ מִפָּנֶֽיךָ׃ ");
INSERT INTO hbo_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","וּבְנֻחֹ֖ה יֹאמַ֑ר שׁוּבָ֣ה יְהוָ֔ה רִֽבְבֹ֖ות אַלְפֵ֥י יִשְׂרָאֵֽל׃ ׆ פ ");
INSERT INTO hbo_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","וַיְהִ֤י הָעָם֙ כְּמִתְאֹ֣נְנִ֔ים רַ֖ע בְּאָזְנֵ֣י יְהוָ֑ה וַיִּשְׁמַ֤ע יְהוָה֙ וַיִּ֣חַר אַפֹּ֔ו וַתִּבְעַר־בָּם֙ אֵ֣שׁ יְהוָ֔ה וַתֹּ֖אכַל בִּקְצֵ֥ה הַֽמַּחֲנֶֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","וַיִּצְעַ֥ק הָעָ֖ם אֶל־מֹשֶׁ֑ה וַיִּתְפַּלֵּ֤ל מֹשֶׁה֙ אֶל־יְהוָ֔ה וַתִּשְׁקַ֖ע הָאֵֽשׁ׃ ");
INSERT INTO hbo_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","וַיִּקְרָ֛א שֵֽׁם־הַמָּקֹ֥ום הַה֖וּא תַּבְעֵרָ֑ה כִּֽי־בָעֲרָ֥ה בָ֖ם אֵ֥שׁ יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","וְהָֽאסַפְסֻף֙ אֲשֶׁ֣ר בְּקִרְבֹּ֔ו הִתְאַוּ֖וּ תַּאֲוָ֑ה וַיָּשֻׁ֣בוּ וַיִּבְכּ֗וּ גַּ֚ם בְּנֵ֣י יִשְׂרָאֵ֔ל וַיֹּ֣אמְר֔וּ מִ֥י יַאֲכִלֵ֖נוּ בָּשָֽׂר׃ ");
INSERT INTO hbo_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","זָכַ֙רְנוּ֙ אֶת־הַדָּגָ֔ה אֲשֶׁר־נֹאכַ֥ל בְּמִצְרַ֖יִם חִנָּ֑ם אֵ֣ת הַקִּשֻּׁאִ֗ים וְאֵת֙ הָֽאֲבַטִּחִ֔ים וְאֶת־הֶחָצִ֥יר וְאֶת־הַבְּצָלִ֖ים וְאֶת־הַשּׁוּמִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","וְעַתָּ֛ה נַפְשֵׁ֥נוּ יְבֵשָׁ֖ה אֵ֣ין כֹּ֑ל בִּלְתִּ֖י אֶל־הַמָּ֥ן עֵינֵֽינוּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","וְהַמָּ֕ן כִּזְרַע־גַּ֖ד ה֑וּא וְעֵינֹ֖ו כְּעֵ֥ין הַבְּדֹֽלַח׃ ");
INSERT INTO hbo_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","שָׁטוּ֩ הָעָ֨ם וְלָֽקְט֜וּ וְטָחֲנ֣וּ בָרֵחַ֗יִם אֹ֤ו דָכוּ֙ בַּמְּדֹכָ֔ה וּבִשְּׁלוּ֙ בַּפָּר֔וּר וְעָשׂ֥וּ אֹתֹ֖ו עֻגֹ֑ות וְהָיָ֣ה טַעְמֹ֔ו כְּטַ֖עַם לְשַׁ֥ד הַשָּֽׁמֶן׃ ");
INSERT INTO hbo_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","וּבְרֶ֧דֶת הַטַּ֛ל עַל־הַֽמַּחֲנֶ֖ה לָ֑יְלָה יֵרֵ֥ד הַמָּ֖ן עָלָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","וַיִּשְׁמַ֨ע מֹשֶׁ֜ה אֶת־הָעָ֗ם בֹּכֶה֙ לְמִשְׁפְּחֹתָ֔יו אִ֖ישׁ לְפֶ֣תַח אָהֳלֹ֑ו וַיִּֽחַר־אַ֤ף יְהוָה֙ מְאֹ֔ד וּבְעֵינֵ֥י מֹשֶׁ֖ה רָֽע׃ ");
INSERT INTO hbo_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","וַיֹּ֨אמֶר מֹשֶׁ֜ה אֶל־יְהוָ֗ה לָמָ֤ה הֲרֵעֹ֙תָ֙ לְעַבְדֶּ֔ךָ וְלָ֛מָּה לֹא־מָצָ֥תִי חֵ֖ן בְּעֵינֶ֑יךָ לָשׂ֗וּם אֶת־מַשָּׂ֛א כָּל־הָעָ֥ם הַזֶּ֖ה עָלָֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","הֶאָנֹכִ֣י הָרִ֗יתִי אֵ֚ת כָּל־הָעָ֣ם הַזֶּ֔ה אִם־אָנֹכִ֖י יְלִדְתִּ֑יהוּ כִּֽי־תֹאמַ֨ר אֵלַ֜י שָׂאֵ֣הוּ בְחֵיקֶ֗ךָ כַּאֲשֶׁ֨ר יִשָּׂ֤א הָאֹמֵן֙ אֶת־הַיֹּנֵ֔ק עַ֚ל הָֽאֲדָמָ֔ה אֲשֶׁ֥ר נִשְׁבַּ֖עְתָּ לַאֲבֹתָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","מֵאַ֤יִן לִי֙ בָּשָׂ֔ר לָתֵ֖ת לְכָל־הָעָ֣ם הַזֶּ֑ה כִּֽי־יִבְכּ֤וּ עָלַי֙ לֵאמֹ֔ר תְּנָה־לָּ֥נוּ בָשָׂ֖ר וְנֹאכֵֽלָה׃ ");
INSERT INTO hbo_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","לֹֽא־אוּכַ֤ל אָנֹכִי֙ לְבַדִּ֔י לָשֵׂ֖את אֶת־כָּל־הָעָ֣ם הַזֶּ֑ה כִּ֥י כָבֵ֖ד מִמֶּֽנִּי׃ ");
INSERT INTO hbo_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","וְאִם־כָּ֣כָה ׀ אַתְּ־עֹ֣שֶׂה לִּ֗י הָרְגֵ֤נִי נָא֙ הָרֹ֔ג אִם־מָצָ֥אתִי חֵ֖ן בְּעֵינֶ֑יךָ וְאַל־אֶרְאֶ֖ה בְּרָעָתִֽי׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","וַיֹּ֨אמֶר יְהוָ֜ה אֶל־מֹשֶׁ֗ה אֶסְפָה־לִּ֞י שִׁבְעִ֣ים אִישׁ֮ מִזִּקְנֵ֣י יִשְׂרָאֵל֒ אֲשֶׁ֣ר יָדַ֔עְתָּ כִּי־הֵ֛ם זִקְנֵ֥י הָעָ֖ם וְשֹׁטְרָ֑יו וְלָקַחְתָּ֤ אֹתָם֙ אֶל־אֹ֣הֶל מֹועֵ֔ד וְהִֽתְיַצְּב֥וּ שָׁ֖ם עִמָּֽךְ׃ ");
INSERT INTO hbo_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","וְיָרַדְתִּ֗י וְדִבַּרְתִּ֣י עִמְּךָ֮ שָׁם֒ וְאָצַלְתִּ֗י מִן־הָר֛וּחַ אֲשֶׁ֥ר עָלֶ֖יךָ וְשַׂמְתִּ֣י עֲלֵיהֶ֑ם וְנָשְׂא֤וּ אִתְּךָ֙ בְּמַשָּׂ֣א הָעָ֔ם וְלֹא־תִשָּׂ֥א אַתָּ֖ה לְבַדֶּֽךָ׃ ");
INSERT INTO hbo_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","וְאֶל־הָעָ֨ם תֹּאמַ֜ר הִתְקַדְּשׁ֣וּ לְמָחָר֮ וַאֲכַלְתֶּ֣ם בָּשָׂר֒ כִּ֡י בְּכִיתֶם֩ בְּאָזְנֵ֨י יְהוָ֜ה לֵאמֹ֗ר מִ֤י יַאֲכִלֵ֙נוּ֙ בָּשָׂ֔ר כִּי־טֹ֥וב לָ֖נוּ בְּמִצְרָ֑יִם וְנָתַ֨ן יְהוָ֥ה לָכֶ֛ם בָּשָׂ֖ר וַאֲכַלְתֶּֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","לֹ֣א יֹ֥ום אֶחָ֛ד תֹּאכְל֖וּן וְלֹ֣א יֹומָ֑יִם וְלֹ֣א ׀ חֲמִשָּׁ֣ה יָמִ֗ים וְלֹא֙ עֲשָׂרָ֣ה יָמִ֔ים וְלֹ֖א עֶשְׂרִ֥ים יֹֽום׃ ");
INSERT INTO hbo_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","עַ֣ד ׀ חֹ֣דֶשׁ יָמִ֗ים עַ֤ד אֲשֶׁר־יֵצֵא֙ מֵֽאַפְּכֶ֔ם וְהָיָ֥ה לָכֶ֖ם לְזָרָ֑א יַ֗עַן כִּֽי־מְאַסְתֶּ֤ם אֶת־יְהוָה֙ אֲשֶׁ֣ר בְּקִרְבְּכֶ֔ם וַתִּבְכּ֤וּ לְפָנָיו֙ לֵאמֹ֔ר לָ֥מָּה זֶּ֖ה יָצָ֥אנוּ מִמִּצְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","וַיֹּאמֶר֮ מֹשֶׁה֒ שֵׁשׁ־מֵאֹ֥ות אֶ֙לֶף֙ רַגְלִ֔י הָעָ֕ם אֲשֶׁ֥ר אָנֹכִ֖י בְּקִרְבֹּ֑ו וְאַתָּ֣ה אָמַ֗רְתָּ בָּשָׂר֙ אֶתֵּ֣ן לָהֶ֔ם וְאָכְל֖וּ חֹ֥דֶשׁ יָמִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","הֲצֹ֧אן וּבָקָ֛ר יִשָּׁחֵ֥ט לָהֶ֖ם וּמָצָ֣א לָהֶ֑ם אִ֣ם אֶֽת־כָּל־דְּגֵ֥י הַיָּ֛ם יֵאָסֵ֥ף לָהֶ֖ם וּמָצָ֥א לָהֶֽם׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","וַיֹּ֤אמֶר יְהוָה֙ אֶל־מֹשֶׁ֔ה הֲיַ֥ד יְהוָ֖ה תִּקְצָ֑ר עַתָּ֥ה תִרְאֶ֛ה הֲיִקְרְךָ֥ דְבָרִ֖י אִם־לֹֽא׃ ");
INSERT INTO hbo_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","וַיֵּצֵ֣א מֹשֶׁ֗ה וַיְדַבֵּר֙ אֶל־הָעָ֔ם אֵ֖ת דִּבְרֵ֣י יְהוָ֑ה וַיֶּאֱסֹ֞ף שִׁבְעִ֥ים אִישׁ֙ מִזִּקְנֵ֣י הָעָ֔ם וַֽיַּעֲמֵ֥ד אֹתָ֖ם סְבִיבֹ֥ת הָאֹֽהֶל׃ ");
INSERT INTO hbo_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","וַיֵּ֨רֶד יְהוָ֥ה ׀ בֶּעָנָן֮ וַיְדַבֵּ֣ר אֵלָיו֒ וַיָּ֗אצֶל מִן־הָר֙וּחַ֙ אֲשֶׁ֣ר עָלָ֔יו וַיִּתֵּ֕ן עַל־שִׁבְעִ֥ים אִ֖ישׁ הַזְּקֵנִ֑ים וַיְהִ֗י כְּנֹ֤וחַ עֲלֵיהֶם֙ הָר֔וּחַ וַיִּֽתְנַבְּא֖וּ וְלֹ֥א יָסָֽפוּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","וַיִּשָּׁאֲר֣וּ שְׁנֵֽי־אֲנָשִׁ֣ים ׀ בַּֽמַּחֲנֶ֡ה שֵׁ֣ם הָאֶחָ֣ד ׀ אֶלְדָּ֡ד וְשֵׁם֩ הַשֵּׁנִ֨י מֵידָ֜ד וַתָּ֧נַח עֲלֵיהֶ֣ם הָר֗וּחַ וְהֵ֙מָּה֙ בַּכְּתֻבִ֔ים וְלֹ֥א יָצְא֖וּ הָאֹ֑הֱלָה וַיִּֽתְנַבְּא֖וּ בּֽ͏ַמַּחֲנֶֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","וַיָּ֣רָץ הַנַּ֔עַר וַיַּגֵּ֥ד לְמֹשֶׁ֖ה וַיֹּאמַ֑ר אֶלְדָּ֣ד וּמֵידָ֔ד מִֽתְנַבְּאִ֖ים בַּֽמַּחֲנֶֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","וַיַּ֜עַן יְהֹושֻׁ֣עַ בִּן־נ֗וּן מְשָׁרֵ֥ת מֹשֶׁ֛ה מִבְּחֻרָ֖יו וַיֹּאמַ֑ר אֲדֹנִ֥י מֹשֶׁ֖ה כְּלָאֵֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","וַיֹּ֤אמֶר לֹו֙ מֹשֶׁ֔ה הַֽמְקַנֵּ֥א אַתָּ֖ה לִ֑י וּמִ֨י יִתֵּ֜ן כָּל־עַ֤ם יְהוָה֙ נְבִיאִ֔ים כִּי־יִתֵּ֧ן יְהוָ֛ה אֶת־רוּחֹ֖ו עֲלֵיהֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","וַיֵּאָסֵ֥ף מֹשֶׁ֖ה אֶל־הַֽמַּחֲנֶ֑ה ה֖וּא וְזִקְנֵ֥י יִשְׂרָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","וְר֜וּחַ נָסַ֣ע ׀ מֵאֵ֣ת יְהוָ֗ה וַיָּ֣גָז שַׂלְוִים֮ מִן־הַיָּם֒ וַיִּטֹּ֨שׁ עַל־הַֽמַּחֲנֶ֜ה כְּדֶ֧רֶךְ יֹ֣ום כֹּ֗ה וּכְדֶ֤רֶךְ יֹום֙ כֹּ֔ה סְבִיבֹ֖ות הַֽמַּחֲנֶ֑ה וּכְאַמָּתַ֖יִם עַל־פְּנֵ֥י הָאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","וַיָּ֣קָם הָעָ֡ם כָּל־הַיֹּום֩ הַה֨וּא וְכָל־הַלַּ֜יְלָה וְכֹ֣ל ׀ יֹ֣ום הַֽמָּחֳרָ֗ת וַיַּֽאַסְפוּ֙ אֶת־הַשְּׂלָ֔ו הַמַּמְעִ֕יט אָסַ֖ף עֲשָׂרָ֣ה חֳמָרִ֑ים וַיִּשְׁטְח֤וּ לָהֶם֙ שָׁטֹ֔וחַ סְבִיבֹ֖ות הַֽמַּחֲנֶֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","הַבָּשָׂ֗ר עֹודֶ֙נּוּ֙ בֵּ֣ין שִׁנֵּיהֶ֔ם טֶ֖רֶם יִכָּרֵ֑ת וְאַ֤ף יְהוָה֙ חָרָ֣ה בָעָ֔ם וַיַּ֤ךְ יְהוָה֙ בָּעָ֔ם מַכָּ֖ה רַבָּ֥ה מְאֹֽד׃ ");
INSERT INTO hbo_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","וַיִּקְרָ֛א אֶת־שֵֽׁם־הַמָּקֹ֥ום הַה֖וּא קִבְרֹ֣ות הַֽתַּאֲוָ֑ה כִּי־שָׁם֙ קָֽבְר֔וּ אֶת־הָעָ֖ם הַמִּתְאַוִּֽים׃ ");
INSERT INTO hbo_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","מִקִּבְרֹ֧ות הַֽתַּאֲוָ֛ה נָסְע֥וּ הָעָ֖ם חֲצֵרֹ֑ות וַיִּהְי֖וּ בַּחֲצֵרֹֽות׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","וַתְּדַבֵּ֨ר מִרְיָ֤ם וְאַהֲרֹן֙ בְּמֹשֶׁ֔ה עַל־אֹדֹ֛ות הָאִשָּׁ֥ה הַכֻּשִׁ֖ית אֲשֶׁ֣ר לָקָ֑ח כִּֽי־אִשָּׁ֥ה כֻשִׁ֖ית לָקָֽח׃ ");
INSERT INTO hbo_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","וַיֹּאמְר֗וּ הֲרַ֤ק אַךְ־בְּמֹשֶׁה֙ דִּבֶּ֣ר יְהוָ֔ה הֲלֹ֖א גַּם־בָּ֣נוּ דִבֵּ֑ר וַיִּשְׁמַ֖ע יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","וְהָאִ֥ישׁ מֹשֶׁ֖ה *עָנָו (עָנָ֣יו) מְאֹ֑ד מִכֹּל֙ הָֽאָדָ֔ם אֲשֶׁ֖ר עַל־פְּנֵ֥י הָאֲדָמָֽה׃ ס ");
INSERT INTO hbo_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","וַיֹּ֨אמֶר יְהוָ֜ה פִּתְאֹ֗ם אֶל־מֹשֶׁ֤ה וְאֶֽל־אַהֲרֹן֙ וְאֶל־מִרְיָ֔ם צְא֥וּ שְׁלָשְׁתְּכֶ֖ם אֶל־אֹ֣הֶל מֹועֵ֑ד וַיֵּצְא֖וּ שְׁלָשְׁתָּֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","וַיֵּ֤רֶד יְהוָה֙ בְּעַמּ֣וּד עָנָ֔ן וַֽיַּעֲמֹ֖ד פֶּ֣תַח הָאֹ֑הֶל וַיִּקְרָא֙ אַהֲרֹ֣ן וּמִרְיָ֔ם וַיֵּצְא֖וּ שְׁנֵיהֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","וַיֹּ֖אמֶר שִׁמְעוּ־נָ֣א דְבָרָ֑י אִם־יִֽהְיֶה֙ נְבִ֣יאֲכֶ֔ם יְהוָ֗ה בַּמַּרְאָה֙ אֵלָ֣יו אֶתְוַדָּ֔ע בַּחֲלֹ֖ום אֲדַבֶּר־בֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","לֹא־כֵ֖ן עַבְדִּ֣י מֹשֶׁ֑ה בְּכָל־בֵּיתִ֖י נֶאֱמָ֥ן הֽוּא׃ ");
INSERT INTO hbo_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","פֶּ֣ה אֶל־פֶּ֞ה אֲדַבֶּר־בֹּ֗ו וּמַרְאֶה֙ וְלֹ֣א בְחִידֹ֔ת וּתְמֻנַ֥ת יְהוָ֖ה יַבִּ֑יט וּמַדּ֙וּעַ֙ לֹ֣א יְרֵאתֶ֔ם לְדַבֵּ֖ר בְּעַבְדִּ֥י בְמֹשֶֽׁה׃ ");
INSERT INTO hbo_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","וַיִּֽחַר אַ֧ף יְהוָ֛ה בָּ֖ם וַיֵּלַֽךְ׃ ");
INSERT INTO hbo_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","וְהֶעָנָ֗ן סָ֚ר מֵעַ֣ל הָאֹ֔הֶל וְהִנֵּ֥ה מִרְיָ֖ם מְצֹרַ֣עַת כַּשָּׁ֑לֶג וַיִּ֧פֶן אַהֲרֹ֛ן אֶל־מִרְיָ֖ם וְהִנֵּ֥ה מְצֹרָֽעַת׃ ");
INSERT INTO hbo_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","וַיֹּ֥אמֶר אַהֲרֹ֖ן אֶל־מֹשֶׁ֑ה בִּ֣י אֲדֹנִ֔י אַל־נָ֨א תָשֵׁ֤ת עָלֵ֙ינוּ֙ חַטָּ֔את אֲשֶׁ֥ר נֹואַ֖לְנוּ וַאֲשֶׁ֥ר חָטָֽאנוּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","אַל־נָ֥א תְהִ֖י כַּמֵּ֑ת אֲשֶׁ֤ר בְּצֵאתֹו֙ מֵרֶ֣חֶם אִמֹּ֔ו וַיֵּאָכֵ֖ל חֲצִ֥י בְשָׂרֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","וַיִּצְעַ֣ק מֹשֶׁ֔ה אֶל־יְהוָ֖ה לֵאמֹ֑ר אֵ֕ל נָ֛א רְפָ֥א נָ֖א לָֽהּ׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","וַיֹּ֨אמֶר יְהוָ֜ה אֶל־מֹשֶׁ֗ה וְאָבִ֙יהָ֙ יָרֹ֤ק יָרַק֙ בְּפָנֶ֔יהָ הֲלֹ֥א תִכָּלֵ֖ם שִׁבְעַ֣ת יָמִ֑ים תִּסָּגֵ֞ר שִׁבְעַ֤ת יָמִים֙ מִח֣וּץ לַֽמַּחֲנֶ֔ה וְאַחַ֖ר תֵּאָסֵֽף׃ ");
INSERT INTO hbo_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","וַתִּסָּגֵ֥ר מִרְיָ֛ם מִח֥וּץ לַֽמַּחֲנֶ֖ה שִׁבְעַ֣ת יָמִ֑ים וְהָעָם֙ לֹ֣א נָסַ֔ע עַד־הֵאָסֵ֖ף מִרְיָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","וְאַחַ֛ר נָסְע֥וּ הָעָ֖ם מֵחֲצֵרֹ֑ות וַֽיַּחֲנ֖וּ בְּמִדְבַּ֥ר פָּארָֽן׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","שְׁלַח־לְךָ֣ אֲנָשִׁ֗ים וְיָתֻ֙רוּ֙ אֶת־אֶ֣רֶץ כְּנַ֔עַן אֲשֶׁר־אֲנִ֥י נֹתֵ֖ן לִבְנֵ֣י יִשְׂרָאֵ֑ל אִ֣ישׁ אֶחָד֩ אִ֨ישׁ אֶחָ֜ד לְמַטֵּ֤ה אֲבֹתָיו֙ תִּשְׁלָ֔חוּ כֹּ֖ל נָשִׂ֥יא בָהֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","וַיִּשְׁלַ֨ח אֹתָ֥ם מֹשֶׁ֛ה מִמִּדְבַּ֥ר פָּארָ֖ן עַל־פִּ֣י יְהוָ֑ה כֻּלָּ֣ם אֲנָשִׁ֔ים רָאשֵׁ֥י בְנֵֽי־יִשְׂרָאֵ֖ל הֵֽמָּה׃ ");
INSERT INTO hbo_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","וְאֵ֖לֶּה שְׁמֹותָ֑ם לְמַטֵּ֣ה רְאוּבֵ֔ן שַׁמּ֖וּעַ בֶּן־זַכּֽוּר׃ ");
INSERT INTO hbo_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","לְמַטֵּ֣ה שִׁמְעֹ֔ון שָׁפָ֖ט בֶּן־חֹורִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","לְמַטֵּ֣ה יְהוּדָ֔ה כָּלֵ֖ב בֶּן־יְפֻנֶּֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","לְמַטֵּ֣ה יִשָּׂשכָ֔ר יִגְאָ֖ל בֶּן־יֹוסֵֽף׃ ");
INSERT INTO hbo_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","לְמַטֵּ֥ה אֶפְרָ֖יִם הֹושֵׁ֥עַ בִּן־נֽוּן׃ ");
INSERT INTO hbo_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","לְמַטֵּ֣ה בִנְיָמִ֔ן פַּלְטִ֖י בֶּן־רָפֽוּא׃ ");
INSERT INTO hbo_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","לְמַטֵּ֣ה זְבוּלֻ֔ן גַּדִּיאֵ֖ל בֶּן־סֹודִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","לְמַטֵּ֥ה יֹוסֵ֖ף לְמַטֵּ֣ה מְנַשֶּׁ֑ה גַּדִּ֖י בֶּן־סוּסִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","לְמַטֵּ֣ה דָ֔ן עַמִּיאֵ֖ל בֶּן־גְּמַלִּֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","לְמַטֵּ֣ה אָשֵׁ֔ר סְת֖וּר בֶּן־מִיכָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","לְמַטֵּ֣ה נַפְתָּלִ֔י נַחְבִּ֖י בֶּן־וָפְסִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","לְמַטֵּ֣ה גָ֔ד גְּאוּאֵ֖ל בֶּן־מָכִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","אֵ֚לֶּה שְׁמֹ֣ות הָֽאֲנָשִׁ֔ים אֲשֶׁר־שָׁלַ֥ח מֹשֶׁ֖ה לָת֣וּר אֶת־הָאָ֑רֶץ וַיִּקְרָ֥א מֹשֶׁ֛ה לְהֹושֵׁ֥עַ בִּן־נ֖וּן יְהֹושֻֽׁעַ׃ ");
INSERT INTO hbo_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","וַיִּשְׁלַ֤ח אֹתָם֙ מֹשֶׁ֔ה לָת֖וּר אֶת־אֶ֣רֶץ כְּנָ֑עַן וַיֹּ֣אמֶר אֲלֵהֶ֗ם עֲל֥וּ זֶה֙ בַּנֶּ֔גֶב וַעֲלִיתֶ֖ם אֶת־הָהָֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","וּרְאִיתֶ֥ם אֶת־הָאָ֖רֶץ מַה־הִ֑וא וְאֶת־הָעָם֙ הַיֹּשֵׁ֣ב עָלֶ֔יהָ הֶחָזָ֥ק הוּא֙ הֲרָפֶ֔ה הַמְעַ֥ט ה֖וּא אִם־רָֽב׃ ");
INSERT INTO hbo_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","וּמָ֣ה הָאָ֗רֶץ אֲשֶׁר־הוּא֙ יֹשֵׁ֣ב בָּ֔הּ הֲטֹובָ֥ה הִ֖וא אִם־רָעָ֑ה וּמָ֣ה הֶֽעָרִ֗ים אֲשֶׁר־הוּא֙ יֹושֵׁ֣ב בָּהֵ֔נָּה הַבְּמַֽחֲנִ֖ים אִ֥ם בְּמִבְצָרִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","וּמָ֣ה הָ֠אָרֶץ הַשְּׁמֵנָ֨ה הִ֜וא אִם־רָזָ֗ה הֲיֵֽשׁ־בָּ֥הּ עֵץ֙ אִם־אַ֔יִן וְהִ֨תְחַזַּקְתֶּ֔ם וּלְקַחְתֶּ֖ם מִפְּרִ֣י הָאָ֑רֶץ וְהַ֨יָּמִ֔ים יְמֵ֖י בִּכּוּרֵ֥י עֲנָבִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","וַֽיַּעֲל֖וּ וַיָּתֻ֣רוּ אֶת־הָאָ֑רֶץ מִמִּדְבַּר־צִ֥ן עַד־רְחֹ֖ב לְבֹ֥א חֲמָֽת׃ ");
INSERT INTO hbo_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","וַיַּעֲל֣וּ בַנֶּגֶב֮ וַיָּבֹ֣א עַד־חֶבְרֹון֒ וְשָׁ֤ם אֲחִימַן֙ שֵׁשַׁ֣י וְתַלְמַ֔י יְלִידֵ֖י הָעֲנָ֑ק וְחֶבְרֹ֗ון שֶׁ֤בַע שָׁנִים֙ נִבְנְתָ֔ה לִפְנֵ֖י צֹ֥עַן מִצְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","וַיָּבֹ֜אוּ עַד־נַ֣חַל אֶשְׁכֹּ֗ל וַיִּכְרְת֨וּ מִשָּׁ֤ם זְמֹורָה֙ וְאֶשְׁכֹּ֤ול עֲנָבִים֙ אֶחָ֔ד וַיִּשָּׂאֻ֥הוּ בַמֹּ֖וט בִּשְׁנָ֑יִם וּמִן־הָרִמֹּנִ֖ים וּמִן־הַתְּאֵנִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","לַמָּקֹ֣ום הַה֔וּא קָרָ֖א נַ֣חַל אֶשְׁכֹּ֑ול עַ֚ל אֹדֹ֣ות הָֽאֶשְׁכֹּ֔ול אֲשֶׁר־כָּרְת֥וּ מִשָּׁ֖ם בְּנֵ֥י יִשְׂרָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","וַיָּשֻׁ֖בוּ מִתּ֣וּר הָאָ֑רֶץ מִקֵּ֖ץ אַרְבָּעִ֥ים יֹֽום׃ ");
INSERT INTO hbo_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","וַיֵּלְכ֡וּ וַיָּבֹאוּ֩ אֶל־מֹשֶׁ֨ה וְאֶֽל־אַהֲרֹ֜ן וְאֶל־כָּל־עֲדַ֧ת בְּנֵֽי־יִשְׂרָאֵ֛ל אֶל־מִדְבַּ֥ר פָּארָ֖ן קָדֵ֑שָׁה וַיָּשִׁ֨יבוּ אֹותָ֤ם דָּבָר֙ וְאֶת־כָּל־הָ֣עֵדָ֔ה וַיַּרְא֖וּם אֶת־פְּרִ֥י הָאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","וַיְסַפְּרוּ־לֹו֙ וַיֹּ֣אמְר֔וּ בָּ֕אנוּ אֶל־הָאָ֖רֶץ אֲשֶׁ֣ר שְׁלַחְתָּ֑נוּ וְ֠גַם זָבַ֨ת חָלָ֥ב וּדְבַ֛שׁ הִ֖וא וְזֶה־פִּרְיָֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","אֶ֚פֶס כִּֽי־עַ֣ז הָעָ֔ם הַיֹּשֵׁ֖ב בָּאָ֑רֶץ וְהֶֽעָרִ֗ים בְּצֻרֹ֤ות גְּדֹלֹת֙ מְאֹ֔ד וְגַם־יְלִדֵ֥י הֽ͏ָעֲנָ֖ק רָאִ֥ינוּ שָֽׁם׃ ");
INSERT INTO hbo_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","עֲמָלֵ֥ק יֹושֵׁ֖ב בְּאֶ֣רֶץ הַנֶּ֑גֶב וְ֠הַֽחִתִּי וְהַיְבוּסִ֤י וְהָֽאֱמֹרִי֙ יֹושֵׁ֣ב בָּהָ֔ר וְהַֽכְּנַעֲנִי֙ יֹשֵׁ֣ב עַל־הַיָּ֔ם וְעַ֖ל יַ֥ד הַיַּרְדֵּֽן׃ ");
INSERT INTO hbo_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","וַיַּ֧הַס כָּלֵ֛ב אֶת־הָעָ֖ם אֶל־מֹשֶׁ֑ה וַיֹּ֗אמֶר עָלֹ֤ה נַעֲלֶה֙ וְיָרַ֣שְׁנוּ אֹתָ֔הּ כִּֽי־יָכֹ֥ול נוּכַ֖ל לָֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","וְהָ֨אֲנָשִׁ֜ים אֲשֶׁר־עָל֤וּ עִמֹּו֙ אָֽמְר֔וּ לֹ֥א נוּכַ֖ל לַעֲלֹ֣ות אֶל־הָעָ֑ם כִּֽי־חָזָ֥ק ה֖וּא מִמֶּֽנּוּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","וַיֹּוצִ֜יאוּ דִּבַּ֤ת הָאָ֙רֶץ֙ אֲשֶׁ֣ר תָּר֣וּ אֹתָ֔הּ אֶל־בְּנֵ֥י יִשְׂרָאֵ֖ל לֵאמֹ֑ר הָאָ֡רֶץ אֲשֶׁר֩ עָבַ֨רְנוּ בָ֜הּ לָת֣וּר אֹתָ֗הּ אֶ֣רֶץ אֹכֶ֤לֶת יֹושְׁבֶ֙יהָ֙ הִ֔וא וְכָל־הָעָ֛ם אֲשֶׁר־רָאִ֥ינוּ בְתֹוכָ֖הּ אַנְשֵׁ֥י מִדֹּֽות׃ ");
INSERT INTO hbo_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","וְשָׁ֣ם רָאִ֗ינוּ אֶת־הַנְּפִילִ֛ים בְּנֵ֥י עֲנָ֖ק מִן־הַנְּפִלִ֑ים וַנְּהִ֤י בְעֵינֵ֙ינוּ֙ כּֽ͏ַחֲגָבִ֔ים וְכֵ֥ן הָיִ֖ינוּ בְּעֵינֵיהֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","וַתִּשָּׂא֙ כָּל־הָ֣עֵדָ֔ה וַֽיִּתְּנ֖וּ אֶת־קֹולָ֑ם וַיִּבְכּ֥וּ הָעָ֖ם בַּלַּ֥יְלָה הַהֽוּא׃ ");
INSERT INTO hbo_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","וַיִּלֹּ֙נוּ֙ עַל־מֹשֶׁ֣ה וְעַֽל־אַהֲרֹ֔ן כֹּ֖ל בְּנֵ֣י יִשְׂרָאֵ֑ל וַֽיֹּאמְר֨וּ אֲלֵהֶ֜ם כָּל־הָעֵדָ֗ה לוּ־מַ֙תְנוּ֙ בְּאֶ֣רֶץ מִצְרַ֔יִם אֹ֛ו בַּמִּדְבָּ֥ר הַזֶּ֖ה לוּ־מָֽתְנוּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","וְלָמָ֣ה יְ֠הוָה מֵבִ֨יא אֹתָ֜נוּ אֶל־הָאָ֤רֶץ הַזֹּאת֙ לִנְפֹּ֣ל בַּחֶ֔רֶב נָשֵׁ֥ינוּ וְטַפֵּ֖נוּ יִהְי֣וּ לָבַ֑ז הֲלֹ֧וא טֹ֦וב לָ֖נוּ שׁ֥וּב מִצְרָֽיְמָה׃ ");
INSERT INTO hbo_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","וַיֹּאמְר֖וּ אִ֣ישׁ אֶל־אָחִ֑יו נִתְּנָ֥ה רֹ֖אשׁ וְנָשׁ֥וּבָה מִצְרָֽיְמָה׃ ");
INSERT INTO hbo_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","וַיִּפֹּ֥ל מֹשֶׁ֛ה וְאַהֲרֹ֖ן עַל־פְּנֵיהֶ֑ם לִפְנֵ֕י כָּל־קְהַ֥ל עֲדַ֖ת בְּנֵ֥י יִשְׂרָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","וִיהֹושֻׁ֣עַ בִּן־נ֗וּן וְכָלֵב֙ בֶּן־יְפֻנֶּ֔ה מִן־הַתָּרִ֖ים אֶת־הָאָ֑רֶץ קָרְע֖וּ בִּגְדֵיהֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","וַיֹּ֣אמְר֔וּ אֶל־כָּל־עֲדַ֥ת בְּנֵֽי־יִשְׂרָאֵ֖ל לֵאמֹ֑ר הָאָ֗רֶץ אֲשֶׁ֨ר עָבַ֤רְנוּ בָהּ֙ לָת֣וּר אֹתָ֔הּ טֹובָ֥ה הָאָ֖רֶץ מְאֹ֥ד מְאֹֽד׃ ");
INSERT INTO hbo_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","אִם־חָפֵ֥ץ בָּ֙נוּ֙ יְהוָ֔ה וְהֵבִ֤יא אֹתָ֙נוּ֙ אֶל־הָאָ֣רֶץ הַזֹּ֔את וּנְתָנָ֖הּ לָ֑נוּ אֶ֕רֶץ אֲשֶׁר־הִ֛וא זָבַ֥ת חָלָ֖ב וּדְבָֽשׁ׃ ");
INSERT INTO hbo_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","אַ֣ךְ בַּֽיהוָה֮ אַל־תִּמְרֹדוּ֒ וְאַתֶּ֗ם אַל־תִּֽירְאוּ֙ אֶת־עַ֣ם הָאָ֔רֶץ כִּ֥י לַחְמֵ֖נוּ הֵ֑ם סָ֣ר צִלָּ֧ם מֵעֲלֵיהֶ֛ם וַֽיהוָ֥ה אִתָּ֖נוּ אַל־תִּירָאֻֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","וַיֹּֽאמְרוּ֙ כָּל־הָ֣עֵדָ֔ה לִרְגֹּ֥ום אֹתָ֖ם בָּאֲבָנִ֑ים וּכְבֹ֣וד יְהוָ֗ה נִרְאָה֙ בְּאֹ֣הֶל מֹועֵ֔ד אֶֽל־כָּל־בְּנֵ֖י יִשְׂרָאֵֽל׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","וַיֹּ֤אמֶר יְהוָה֙ אֶל־מֹשֶׁ֔ה עַד־אָ֥נָה יְנַאֲצֻ֖נִי הָעָ֣ם הַזֶּ֑ה וְעַד־אָ֙נָה֙ לֹא־יַאֲמִ֣ינוּ בִ֔י בְּכֹל֙ הָֽאֹתֹ֔ות אֲשֶׁ֥ר עָשִׂ֖יתִי בְּקִרְבֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","אַכֶּ֥נּוּ בַדֶּ֖בֶר וְאֹורִשֶׁ֑נּוּ וְאֶֽעֱשֶׂה֙ אֹֽתְךָ֔ לְגֹוי־גָּדֹ֥ול וְעָצ֖וּם מִמֶּֽנּוּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","וַיֹּ֥אמֶר מֹשֶׁ֖ה אֶל־יְהוָ֑ה וְשָׁמְע֣וּ מִצְרַ֔יִם כִּֽי־הֶעֱלִ֧יתָ בְכֹחֲךָ֛ אֶת־הָעָ֥ם הַזֶּ֖ה מִקִּרְבֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","וְאָמְר֗וּ אֶל־יֹושֵׁב֮ הָאָ֣רֶץ הַזֹּאת֒ שָֽׁמְעוּ֙ כִּֽי־אַתָּ֣ה יְהוָ֔ה בְּקֶ֖רֶב הָעָ֣ם הַזֶּ֑ה אֲשֶׁר־עַ֨יִן בְּעַ֜יִן נִרְאָ֣ה ׀ אַתָּ֣ה יְהוָ֗ה וַעֲנָֽנְךָ֙ עֹמֵ֣ד עֲלֵהֶ֔ם וּבְעַמֻּ֣ד עָנָ֗ן אַתָּ֨ה הֹלֵ֤ךְ לִפְנֵיהֶם֙ יֹומָ֔ם וּבְעַמּ֥וּד אֵ֖שׁ לָֽיְלָה׃ ");
INSERT INTO hbo_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","וְהֵמַתָּ֛ה אֶת־הָעָ֥ם הַזֶּ֖ה כְּאִ֣ישׁ אֶחָ֑ד וְאָֽמְרוּ֙ הַגֹּויִ֔ם אֲשֶׁר־שָׁמְע֥וּ אֶֽת־שִׁמְעֲךָ֖ לֵאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","מִבִּלְתִּ֞י יְכֹ֣לֶת יְהוָ֗ה לְהָבִיא֙ אֶת־הָעָ֣ם הַזֶּ֔ה אֶל־הָאָ֖רֶץ אֲשֶׁר־נִשְׁבַּ֣ע לָהֶ֑ם וַיִּשְׁחָטֵ֖ם בַּמִּדְבָּֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","וְעַתָּ֕ה יִגְדַּל־נָ֖א כֹּ֣חַ אֲדֹנָ֑י כַּאֲשֶׁ֥ר דִּבַּ֖רְתָּ לֵאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","יְהוָ֗ה אֶ֤רֶךְ אַפַּ֙יִם֙ וְרַב־חֶ֔סֶד נֹשֵׂ֥א עָוֹ֖ן וָפָ֑שַׁע וְנַקֵּה֙ לֹ֣א יְנַקֶּ֔ה פֹּקֵ֞ד עֲוֹ֤ן אָבֹות֙ עַל־בָּנִ֔ים עַל־שִׁלֵּשִׁ֖ים וְעַל־רִבֵּעִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","סְלַֽח־נָ֗א לַעֲוֹ֛ן הָעָ֥ם הַזֶּ֖ה כְּגֹ֣דֶל חַסְדֶּ֑ךָ וְכַאֲשֶׁ֤ר נָשָׂ֙אתָה֙ לָעָ֣ם הַזֶּ֔ה מִמִּצְרַ֖יִם וְעַד־הֵֽנָּה׃ ");
INSERT INTO hbo_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","וַיֹּ֣אמֶר יְהוָ֔ה סָלַ֖חְתִּי כִּדְבָרֶֽךָ׃ ");
INSERT INTO hbo_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","וְאוּלָ֖ם חַי־אָ֑נִי וְיִמָּלֵ֥א כְבֹוד־יְהוָ֖ה אֶת־כָּל־הָאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","כִּ֣י כָל־הָאֲנָשִׁ֗ים הָרֹאִ֤ים אֶת־כְּבֹדִי֙ וְאֶת־אֹ֣תֹתַ֔י אֲשֶׁר־עָשִׂ֥יתִי בְמִצְרַ֖יִם וּבַמִּדְבָּ֑ר וַיְנַסּ֣וּ אֹתִ֗י זֶ֚ה עֶ֣שֶׂר פְּעָמִ֔ים וְלֹ֥א שָׁמְע֖וּ בְּקֹולִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","אִם־יִרְאוּ֙ אֶת־הָאָ֔רֶץ אֲשֶׁ֥ר נִשְׁבַּ֖עְתִּי לַאֲבֹתָ֑ם וְכָל־מְנַאֲצַ֖י לֹ֥א יִרְאֽוּהָ׃ ");
INSERT INTO hbo_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","וְעַבְדִּ֣י כָלֵ֗ב עֵ֣קֶב הָֽיְתָ֞ה ר֤וּחַ אַחֶ֙רֶת֙ עִמֹּ֔ו וַיְמַלֵּ֖א אַחֲרָ֑י וַהֲבִֽיאֹתִ֗יו אֶל־הָאָ֙רֶץ֙ אֲשֶׁר־בָּ֣א שָׁ֔מָּה וְזַרְעֹ֖ו יֹורִשֶֽׁנָּה׃ ");
INSERT INTO hbo_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","וְהָֽעֲמָלֵקִ֥י וְהַֽכְּנַעֲנִ֖י יֹושֵׁ֣ב בָּעֵ֑מֶק מָחָ֗ר פְּנ֨וּ וּסְע֥וּ לָכֶ֛ם הַמִּדְבָּ֖ר דֶּ֥רֶךְ יַם־סֽוּף׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","וַיְדַבֵּ֣ר יְהוָ֔ה אֶל־מֹשֶׁ֥ה וְאֶֽל־אַהֲרֹ֖ן לֵאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","עַד־מָתַ֗י לָעֵדָ֤ה הָֽרָעָה֙ הַזֹּ֔את אֲשֶׁ֛ר הֵ֥מָּה מַלִּינִ֖ים עָלָ֑י אֶת־תְּלֻנֹּ֞ות בְּנֵ֣י יִשְׂרָאֵ֗ל אֲשֶׁ֨ר הֵ֧מָּה מַלִּינִ֛ים עָלַ֖י שָׁמָֽעְתִּי׃ ");
INSERT INTO hbo_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","אֱמֹ֣ר אֲלֵהֶ֗ם חַי־אָ֙נִי֙ נְאֻם־יְהוָ֔ה אִם־לֹ֕א כַּאֲשֶׁ֥ר דִּבַּרְתֶּ֖ם בְּאָזְנָ֑י כֵּ֖ן אֶֽעֱשֶׂ֥ה לָכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","בַּמִּדְבָּ֣ר הַ֠זֶּה יִפְּל֨וּ פִגְרֵיכֶ֜ם וְכָל־פְּקֻדֵיכֶם֙ לְכָל־מִסְפַּרְכֶ֔ם מִבֶּ֛ן עֶשְׂרִ֥ים שָׁנָ֖ה וָמָ֑עְלָה אֲשֶׁ֥ר הֲלִֽינֹתֶ֖ם עָלָֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","אִם־אַתֶּם֙ תָּבֹ֣אוּ אֶל־הָאָ֔רֶץ אֲשֶׁ֤ר נָשָׂ֙אתִי֙ אֶת־יָדִ֔י לְשַׁכֵּ֥ן אֶתְכֶ֖ם בָּ֑הּ כִּ֚י אִם־כָּלֵ֣ב בֶּן־יְפֻנֶּ֔ה וִיהֹושֻׁ֖עַ בִּן־נֽוּן׃ ");
INSERT INTO hbo_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","וְטַ֨פְּכֶ֔ם אֲשֶׁ֥ר אֲמַרְתֶּ֖ם לָבַ֣ז יִהְיֶ֑ה וְהֵבֵיאתִ֣י אֹתָ֔ם וְיָֽדְעוּ֙ אֶת־הָאָ֔רֶץ אֲשֶׁ֥ר מְאַסְתֶּ֖ם בָּֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","וּפִגְרֵיכֶ֖ם אַתֶּ֑ם יִפְּל֖וּ בַּמִּדְבָּ֥ר הַזֶּֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","וּ֠בְנֵיכֶם יִהְי֨וּ רֹעִ֤ים בַּמִּדְבָּר֙ אַרְבָּעִ֣ים שָׁנָ֔ה וְנָשְׂא֖וּ אֶת־זְנוּתֵיכֶ֑ם עַד־תֹּ֥ם פִּגְרֵיכֶ֖ם בַּמִּדְבָּֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","בְּמִסְפַּ֨ר הַיָּמִ֜ים אֲשֶׁר־תַּרְתֶּ֣ם אֶת־הָאָרֶץ֮ אַרְבָּעִ֣ים יֹום֒ יֹ֣ום לַשָּׁנָ֞ה יֹ֣ום לַשָּׁנָ֗ה תִּשְׂאוּ֙ אֶת־עֲוֹנֹ֣תֵיכֶ֔ם אַרְבָּעִ֖ים שָׁנָ֑ה וִֽידַעְתֶּ֖ם אֶת־תְּנוּאָתִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","אֲנִ֣י יְהוָה֮ דִּבַּרְתִּי֒ אִם־לֹ֣א ׀ זֹ֣את אֽ͏ֶעֱשֶׂ֗ה לְכָל־הָעֵדָ֤ה הָֽרָעָה֙ הַזֹּ֔את הַנֹּועָדִ֖ים עָלָ֑י בַּמִּדְבָּ֥ר הַזֶּ֛ה יִתַּ֖מּוּ וְשָׁ֥ם יָמֻֽתוּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","וְהָ֣אֲנָשִׁ֔ים אֲשֶׁר־שָׁלַ֥ח מֹשֶׁ֖ה לָת֣וּר אֶת־הָאָ֑רֶץ וַיָּשֻׁ֗בוּ *וַיִּלֹּונוּ (וַיַּלִּ֤ינוּ) עָלָיו֙ אֶת־כָּל־הָ֣עֵדָ֔ה לְהֹוצִ֥יא דִבָּ֖ה עַל־הָאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","וַיָּמֻ֙תוּ֙ הָֽאֲנָשִׁ֔ים מֹוצִאֵ֥י דִבַּת־הָאָ֖רֶץ רָעָ֑ה בַּמַּגֵּפָ֖ה לִפְנֵ֥י יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","וִיהֹושֻׁ֣עַ בִּן־נ֔וּן וְכָלֵ֖ב בֶּן־יְפֻנֶּ֑ה חָיוּ֙ מִן־הָאֲנָשִׁ֣ים הָהֵ֔ם הַֽהֹלְכִ֖ים לָת֥וּר אֶת־הָאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","וַיְדַבֵּ֤ר מֹשֶׁה֙ אֶת־הַדְּבָרִ֣ים הָאֵ֔לֶּה אֶֽל־כָּל־בְּנֵ֖י יִשְׂרָאֵ֑ל וַיִּֽתְאַבְּל֥וּ הָעָ֖ם מְאֹֽד׃ ");
INSERT INTO hbo_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","וַיַּשְׁכִּ֣מוּ בַבֹּ֔קֶר וַיַּֽעֲל֥וּ אֶל־רֹאשׁ־הָהָ֖ר לֵאמֹ֑ר הִנֶּ֗נּוּ וְעָלִ֛ינוּ אֶל־הַמָּקֹ֛ום אֲשֶׁר־אָמַ֥ר יְהוָ֖ה כִּ֥י חָטָֽאנוּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","וַיֹּ֣אמֶר מֹשֶׁ֔ה לָ֥מָּה זֶּ֛ה אַתֶּ֥ם עֹבְרִ֖ים אֶת־פִּ֣י יְהוָ֑ה וְהִ֖וא לֹ֥א תִצְלָֽח׃ ");
INSERT INTO hbo_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","אַֽל־תַּעֲל֔וּ כִּ֛י אֵ֥ין יְהוָ֖ה בְּקִרְבְּכֶ֑ם וְלֹא֙ תִּנָּ֣גְפ֔וּ לִפְנֵ֖י אֹיְבֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","כִּי֩ הָעֲמָלֵקִ֨י וְהַכְּנַעֲנִ֥י שָׁם֙ לִפְנֵיכֶ֔ם וּנְפַלְתֶּ֖ם בֶּחָ֑רֶב כִּֽי־עַל־כֵּ֤ן שַׁבְתֶּם֙ מֵאַחֲרֵ֣י יְהוָ֔ה וְלֹא־יִהְיֶ֥ה יְהוָ֖ה עִמָּכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","וַיַּעְפִּ֕לוּ לַעֲלֹ֖ות אֶל־רֹ֣אשׁ הָהָ֑ר וַאֲרֹ֤ון בְּרִית־יְהוָה֙ וּמֹשֶׁ֔ה לֹא־מָ֖שׁוּ מִקֶּ֥רֶב הַֽמַּחֲנֶֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","וַיֵּ֤רֶד הָעֲמָלֵקִי֙ וְהַֽכְּנַעֲנִ֔י הַיֹּשֵׁ֖ב בָּהָ֣ר הַה֑וּא וַיַּכּ֥וּם וַֽיַּכְּת֖וּם עַד־הַֽחָרְמָֽה׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","דַּבֵּר֙ אֶל־בְּנֵ֣י יִשְׂרָאֵ֔ל וְאָמַרְתָּ֖ אֲלֵהֶ֑ם כִּ֣י תָבֹ֗אוּ אֶל־אֶ֙רֶץ֙ מֹושְׁבֹ֣תֵיכֶ֔ם אֲשֶׁ֥ר אֲנִ֖י נֹתֵ֥ן לָכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","וַעֲשִׂיתֶ֨ם אִשֶּׁ֤ה לַֽיהוָה֙ עֹלָ֣ה אֹו־זֶ֔בַח לְפַלֵּא־נֶ֙דֶר֙ אֹ֣ו בִנְדָבָ֔ה אֹ֖ו בְּמֹעֲדֵיכֶ֑ם לַעֲשֹׂ֞ות רֵ֤יחַ נִיחֹ֙חַ֙ לַֽיהוָ֔ה מִן־הַבָּקָ֖ר אֹ֥ו מִן־הַצֹּֽאן׃ ");
INSERT INTO hbo_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","וְהִקְרִ֛יב הַמַּקְרִ֥יב קָרְבָּנֹ֖ו לַֽיהוָ֑ה מִנְחָה֙ סֹ֣לֶת עִשָּׂרֹ֔ון בָּל֕וּל בִּרְבִעִ֥ית הַהִ֖ין שָֽׁמֶן׃ ");
INSERT INTO hbo_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","וְיַ֤יִן לַנֶּ֙סֶךְ֙ רְבִיעִ֣ית הַהִ֔ין תַּעֲשֶׂ֥ה עַל־הָעֹלָ֖ה אֹ֣ו לַזָּ֑בַח לַכֶּ֖בֶשׂ הָאֶחָֽד׃ ");
INSERT INTO hbo_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","אֹ֤ו לָאַ֙יִל֙ תַּעֲשֶׂ֣ה מִנְחָ֔ה סֹ֖לֶת שְׁנֵ֣י עֶשְׂרֹנִ֑ים בְּלוּלָ֥ה בַשֶּׁ֖מֶן שְׁלִשִׁ֥ית הַהִֽין׃ ");
INSERT INTO hbo_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","וְיַ֥יִן לַנֶּ֖סֶךְ שְׁלִשִׁ֣ית הַהִ֑ין תַּקְרִ֥יב רֵֽיחַ־נִיחֹ֖חַ לַיהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","וְכִֽי־תַעֲשֶׂ֥ה בֶן־בָּקָ֖ר עֹלָ֣ה אֹו־זָ֑בַח לְפַלֵּא־נֶ֥דֶר אֹֽו־שְׁלָמִ֖ים לַֽיהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","וְהִקְרִ֤יב עַל־בֶּן־הַבָּקָר֙ מִנְחָ֔ה סֹ֖לֶת שְׁלֹשָׁ֣ה עֶשְׂרֹנִ֑ים בָּל֥וּל בַּשֶּׁ֖מֶן חֲצִ֥י הַהִֽין׃ ");
INSERT INTO hbo_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","וְיַ֛יִן תַּקְרִ֥יב לַנֶּ֖סֶךְ חֲצִ֣י הַהִ֑ין אִשֵּׁ֥ה רֵֽיחַ־נִיחֹ֖חַ לַיהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","כָּ֣כָה יֵעָשֶׂ֗ה לַשֹּׁור֙ הָֽאֶחָ֔ד אֹ֖ו לָאַ֣יִל הָאֶחָ֑ד אֹֽו־לַשֶּׂ֥ה בַכְּבָשִׂ֖ים אֹ֥ו בָעִזִּֽים׃ ");
INSERT INTO hbo_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","כַּמִּסְפָּ֖ר אֲשֶׁ֣ר תַּעֲשׂ֑וּ כָּ֛כָה תַּעֲשׂ֥וּ לָאֶחָ֖ד כְּמִסְפָּרָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","כָּל־הָאֶזְרָ֥ח יַעֲשֶׂה־כָּ֖כָה אֶת־אֵ֑לֶּה לְהַקְרִ֛יב אִשֵּׁ֥ה רֵֽיחַ־נִיחֹ֖חַ לַֽיהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","וְכִֽי־יָגוּר֩ אִתְּכֶ֨ם גֵּ֜ר אֹ֤ו אֲשֶֽׁר־בְּתֹֽוכְכֶם֙ לְדֹרֹ֣תֵיכֶ֔ם וְעָשָׂ֛ה אִשֵּׁ֥ה רֵֽיחַ־נִיחֹ֖חַ לַיהוָ֑ה כַּאֲשֶׁ֥ר תַּעֲשׂ֖וּ כֵּ֥ן יַעֲשֶֽׂה׃ ");
INSERT INTO hbo_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","הַקָּהָ֕ל חֻקָּ֥ה אַחַ֛ת לָכֶ֖ם וְלַגֵּ֣ר הַגָּ֑ר חֻקַּ֤ת עֹולָם֙ לְדֹרֹ֣תֵיכֶ֔ם כָּכֶ֛ם כַּגֵּ֥ר יִהְיֶ֖ה לִפְנֵ֥י יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","תֹּורָ֥ה אַחַ֛ת וּמִשְׁפָּ֥ט אֶחָ֖ד יִהְיֶ֣ה לָכֶ֑ם וְלַגֵּ֖ר הַגָּ֥ר אִתְּכֶֽם׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","דַּבֵּר֙ אֶל־בְּנֵ֣י יִשְׂרָאֵ֔ל וְאָמַרְתָּ֖ אֲלֵהֶ֑ם בְּבֹֽאֲכֶם֙ אֶל־הָאָ֔רֶץ אֲשֶׁ֥ר אֲנִ֛י מֵבִ֥יא אֶתְכֶ֖ם שָֽׁמָּה׃ ");
INSERT INTO hbo_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","וְהָיָ֕ה בַּאֲכָלְכֶ֖ם מִלֶּ֣חֶם הָאָ֑רֶץ תָּרִ֥ימוּ תְרוּמָ֖ה לַיהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","רֵאשִׁית֙ עֲרִסֹ֣תֵכֶ֔ם חַלָּ֖ה תָּרִ֣ימוּ תְרוּמָ֑ה כִּתְרוּמַ֣ת גֹּ֔רֶן כֵּ֖ן תָּרִ֥ימוּ אֹתָֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","מֵרֵאשִׁית֙ עֲרִסֹ֣תֵיכֶ֔ם תִּתְּנ֥וּ לַיהוָ֖ה תְּרוּמָ֑ה לְדֹרֹ֖תֵיכֶֽם׃ ס ");
INSERT INTO hbo_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","וְכִ֣י תִשְׁגּ֔וּ וְלֹ֣א תַעֲשׂ֔וּ אֵ֥ת כָּל־הַמִּצְוֹ֖ת הָאֵ֑לֶּה אֲשֶׁר־דִּבֶּ֥ר יְהוָ֖ה אֶל־מֹשֶֽׁה׃ ");
INSERT INTO hbo_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","אֵת֩ כָּל־אֲשֶׁ֨ר צִוָּ֧ה יְהוָ֛ה אֲלֵיכֶ֖ם בְּיַד־מֹשֶׁ֑ה מִן־הַיֹּ֞ום אֲשֶׁ֨ר צִוָּ֧ה יְהוָ֛ה וָהָ֖לְאָה לְדֹרֹתֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","וְהָיָ֗ה אִ֣ם מֵעֵינֵ֣י הָעֵדָה֮ נֶעֶשְׂתָ֣ה לִשְׁגָגָה֒ וְעָשׂ֣וּ כָל־הָעֵדָ֡ה פַּ֣ר בֶּן־בָּקָר֩ אֶחָ֨ד לְעֹלָ֜ה לְרֵ֤יחַ נִיחֹ֙חַ֙ לַֽיהוָ֔ה וּמִנְחָתֹ֥ו וְנִסְכֹּ֖ו כַּמִּשְׁפָּ֑ט וּשְׂעִיר־עִזִּ֥ים אֶחָ֖ד לְחַטָּֽת׃ ");
INSERT INTO hbo_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","וְכִפֶּ֣ר הַכֹּהֵ֗ן עַֽל־כָּל־עֲדַ֛ת בְּנֵ֥י יִשְׂרָאֵ֖ל וְנִסְלַ֣ח לָהֶ֑ם כִּֽי־שְׁגָגָ֣ה הִ֔וא וְהֵם֩ הֵבִ֨יאוּ אֶת־קָרְבָּנָ֜ם אִשֶּׁ֣ה לַֽיהוָ֗ה וְחַטָּאתָ֛ם לִפְנֵ֥י יְהוָ֖ה עַל־שִׁגְגָתָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","וְנִסְלַ֗ח לְכָל־עֲדַת֙ בְּנֵ֣י יִשְׂרָאֵ֔ל וְלַגֵּ֖ר הַגָּ֣ר בְּתֹוכָ֑ם כִּ֥י לְכָל־הָעָ֖ם בִּשְׁגָגָֽה׃ ס ");
INSERT INTO hbo_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","וְאִם־נֶ֥פֶשׁ אַחַ֖ת תֶּחֱטָ֣א בִשְׁגָגָ֑ה וְהִקְרִ֛יבָה עֵ֥ז בַּת־שְׁנָתָ֖הּ לְחַטָּֽאת׃ ");
INSERT INTO hbo_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","וְכִפֶּ֣ר הַכֹּהֵ֗ן עַל־הַנֶּ֧פֶשׁ הַשֹּׁגֶ֛גֶת בְּחֶטְאָ֥ה בִשְׁגָגָ֖ה לִפְנֵ֣י יְהוָ֑ה לְכַפֵּ֥ר עָלָ֖יו וְנִסְלַ֥ח לֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","הָֽאֶזְרָח֙ בִּבְנֵ֣י יִשְׂרָאֵ֔ל וְלַגֵּ֖ר הַגָּ֣ר בְּתֹוכָ֑ם תֹּורָ֤ה אַחַת֙ יִהְיֶ֣ה לָכֶ֔ם לָעֹשֶׂ֖ה בִּשְׁגָגָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","וְהַנֶּ֜פֶשׁ אֲשֶֽׁר־תַּעֲשֶׂ֣ה ׀ בְּיָ֣ד רָמָ֗ה מִן־הָֽאֶזְרָח֙ וּמִן־הַגֵּ֔ר אֶת־יְהוָ֖ה ה֣וּא מְגַדֵּ֑ף וְנִכְרְתָ֛ה הַנֶּ֥פֶשׁ הַהִ֖וא מִקֶּ֥רֶב עַמָּֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","כִּ֤י דְבַר־יְהוָה֙ בָּזָ֔ה וְאֶת־מִצְוָתֹ֖ו הֵפַ֑ר הִכָּרֵ֧ת ׀ תִּכָּרֵ֛ת הַנֶּ֥פֶשׁ הַהִ֖וא עֲוֹנָ֥ה בָֽהּ׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","וַיִּהְי֥וּ בְנֵֽי־יִשְׂרָאֵ֖ל בַּמִּדְבָּ֑ר וַֽיִּמְצְא֗וּ אִ֛ישׁ מְקֹשֵׁ֥שׁ עֵצִ֖ים בְּיֹ֥ום הַשַּׁבָּֽת׃ ");
INSERT INTO hbo_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","וַיַּקְרִ֣יבוּ אֹתֹ֔ו הַמֹּצְאִ֥ים אֹתֹ֖ו מְקֹשֵׁ֣שׁ עֵצִ֑ים אֶל־מֹשֶׁה֙ וְאֶֽל־אַהֲרֹ֔ן וְאֶ֖ל כָּל־הָעֵדָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","וַיַּנִּ֥יחוּ אֹתֹ֖ו בַּמִּשְׁמָ֑ר כִּ֚י לֹ֣א פֹרַ֔שׁ מַה־יֵּעָשֶׂ֖ה לֹֽו׃ ס ");
INSERT INTO hbo_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","וַיֹּ֤אמֶר יְהוָה֙ אֶל־מֹשֶׁ֔ה מֹ֥ות יוּמַ֖ת הָאִ֑ישׁ רָגֹ֨ום אֹתֹ֤ו בָֽאֲבָנִים֙ כָּל־הָ֣עֵדָ֔ה מִח֖וּץ לַֽמַּחֲנֶֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","וַיֹּצִ֨יאוּ אֹתֹ֜ו כָּל־הָעֵדָ֗ה אֶל־מִחוּץ֙ לַֽמַּחֲנֶ֔ה וַיִּרְגְּמ֥וּ אֹתֹ֛ו בָּאֲבָנִ֖ים וַיָּמֹ֑ת כַּאֲשֶׁ֛ר צִוָּ֥ה יְהוָ֖ה אֶת־מֹשֶֽׁה׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","וַיֹּ֥אמֶר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","דַּבֵּ֞ר אֶל־בְּנֵ֤י יִשְׂרָאֵל֙ וְאָמַרְתָּ֣ אֲלֵהֶ֔ם וְעָשׂ֨וּ לָהֶ֥ם צִיצִ֛ת עַל־כַּנְפֵ֥י בִגְדֵיהֶ֖ם לְדֹרֹתָ֑ם וְנָ֥תְנ֛וּ עַל־צִיצִ֥ת הַכָּנָ֖ף פְּתִ֥יל תְּכֵֽלֶת׃ ");
INSERT INTO hbo_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","וְהָיָ֣ה לָכֶם֮ לְצִיצִת֒ וּרְאִיתֶ֣ם אֹתֹ֗ו וּזְכַרְתֶּם֙ אֶת־כָּל־מִצְוֹ֣ת יְהוָ֔ה וַעֲשִׂיתֶ֖ם אֹתָ֑ם וְלֹֽא־תָתֻ֜רוּ אַחֲרֵ֤י לְבַבְכֶם֙ וְאַחֲרֵ֣י עֵֽינֵיכֶ֔ם אֲשֶׁר־אַתֶּ֥ם זֹנִ֖ים אַחֲרֵיהֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","לְמַ֣עַן תִּזְכְּר֔וּ וַעֲשִׂיתֶ֖ם אֶת־כָּל־מִצְוֹתָ֑י וִהְיִיתֶ֥ם קְדֹשִׁ֖ים לֵֽאלֹהֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","אֲנִ֞י יְהוָ֣ה אֱלֹֽהֵיכֶ֗ם אֲשֶׁ֨ר הֹוצֵ֤אתִי אֶתְכֶם֙ מֵאֶ֣רֶץ מִצְרַ֔יִם לִהְיֹ֥ות לָכֶ֖ם לֵאלֹהִ֑ים אֲנִ֖י יְהוָ֥ה אֱלֹהֵיכֶֽם׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","וַיִּקַּ֣ח קֹ֔רַח בֶּן־יִצְהָ֥ר בֶּן־קְהָ֖ת בֶּן־לֵוִ֑י וְדָתָ֨ן וַאֲבִירָ֜ם בְּנֵ֧י אֱלִיאָ֛ב וְאֹ֥ון בֶּן־פֶּ֖לֶת בְּנֵ֥י רְאוּבֵֽן׃ ");
INSERT INTO hbo_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","וַיָּקֻ֙מוּ֙ לִפְנֵ֣י מֹשֶׁ֔ה וַאֲנָשִׁ֥ים מִבְּנֵֽי־יִשְׂרָאֵ֖ל חֲמִשִּׁ֣ים וּמָאתָ֑יִם נְשִׂיאֵ֥י עֵדָ֛ה קְרִאֵ֥י מֹועֵ֖ד אַנְשֵׁי־שֵֽׁם׃ ");
INSERT INTO hbo_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","וַיִּֽקָּהֲל֞וּ עַל־מֹשֶׁ֣ה וְעַֽל־אַהֲרֹ֗ן וַיֹּאמְר֣וּ אֲלֵהֶם֮ רַב־לָכֶם֒ כִּ֤י כָל־הָֽעֵדָה֙ כֻּלָּ֣ם קְדֹשִׁ֔ים וּבְתֹוכָ֖ם יְהוָ֑ה וּמַדּ֥וּעַ תִּֽתְנַשְּׂא֖וּ עַל־קְהַ֥ל יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","וַיִּשְׁמַ֣ע מֹשֶׁ֔ה וַיִּפֹּ֖ל עַל־פָּנָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","וַיְדַבֵּ֨ר אֶל־קֹ֜רַח וְאֶֽל־כָּל־עֲדָתֹו֮ לֵאמֹר֒ בֹּ֠קֶר וְיֹדַ֨ע יְהוָ֧ה אֶת־אֲשֶׁר־לֹ֛ו וְאֶת־הַקָּדֹ֖ושׁ וְהִקְרִ֣יב אֵלָ֑יו וְאֵ֛ת אֲשֶׁ֥ר יִבְחַר־בֹּ֖ו יַקְרִ֥יב אֵלָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","זֹ֖את עֲשׂ֑וּ קְחוּ־לָכֶ֣ם מַחְתֹּ֔ות קֹ֖רַח וְכָל־עֲדָתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","וּתְנ֣וּ בָהֵ֣ן ׀ אֵ֡שׁ וְשִׂימוּ֩ עֲלֵיהֶ֨ן קְטֹ֜רֶת לִפְנֵ֤י יְהוָה֙ מָחָ֔ר וְהָיָ֗ה הָאִ֛ישׁ אֲשֶׁר־יִבְחַ֥ר יְהוָ֖ה ה֣וּא הַקָּדֹ֑ושׁ רַב־לָכֶ֖ם בְּנֵ֥י לֵוִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","וַיֹּ֥אמֶר מֹשֶׁ֖ה אֶל־קֹ֑רַח שִׁמְעוּ־נָ֖א בְּנֵ֥י לֵוִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","הַמְעַ֣ט מִכֶּ֗ם כִּֽי־הִבְדִּיל֩ אֱלֹהֵ֨י יִשְׂרָאֵ֤ל אֶתְכֶם֙ מֵעֲדַ֣ת יִשְׂרָאֵ֔ל לְהַקְרִ֥יב אֶתְכֶ֖ם אֵלָ֑יו לַעֲבֹ֗ד אֶת־עֲבֹדַת֙ מִשְׁכַּ֣ן יְהוָ֔ה וְלַעֲמֹ֛ד לִפְנֵ֥י הָעֵדָ֖ה לְשָׁרְתָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","וַיַּקְרֵב֙ אֹֽתְךָ֔ וְאֶת־כָּל־אַחֶ֥יךָ בְנֵי־לֵוִ֖י אִתָּ֑ךְ וּבִקַּשְׁתֶּ֖ם גַּם־כְּהֻנָּֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","לָכֵ֗ן אַתָּה֙ וְכָל־עֲדָ֣תְךָ֔ הַנֹּעָדִ֖ים עַל־יְהוָ֑ה וְאַהֲרֹ֣ן מַה־ה֔וּא כִּ֥י *תִלֹּונוּ (תַלִּ֖ינוּ) עָלָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","וַיִּשְׁלַ֣ח מֹשֶׁ֔ה לִקְרֹ֛א לְדָתָ֥ן וְלַאֲבִירָ֖ם בְּנֵ֣י אֱלִיאָ֑ב וַיֹּאמְר֖וּ לֹ֥א נַעֲלֶֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","הַמְעַ֗ט כִּ֤י הֶֽעֱלִיתָ֙נוּ֙ מֵאֶ֨רֶץ זָבַ֤ת חָלָב֙ וּדְבַ֔שׁ לַהֲמִיתֵ֖נוּ בַּמִּדְבָּ֑ר כִּֽי־תִשְׂתָּרֵ֥ר עָלֵ֖ינוּ גַּם־הִשְׂתָּרֵֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","אַ֡ף לֹ֣א אֶל־אֶרֶץ֩ זָבַ֨ת חָלָ֤ב וּדְבַשׁ֙ הֲבִ֣יאֹתָ֔נוּ וַתִּ֨תֶּן־לָ֔נוּ נַחֲלַ֖ת שָׂדֶ֣ה וָכָ֑רֶם הַעֵינֵ֞י הָאֲנָשִׁ֥ים הָהֵ֛ם תְּנַקֵּ֖ר לֹ֥א נַעֲלֶֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","וַיִּ֤חַר לְמֹשֶׁה֙ מְאֹ֔ד וַיֹּ֙אמֶר֙ אֶל־יְהוָ֔ה אַל־תֵּ֖פֶן אֶל־מִנְחָתָ֑ם לֹ֠א חֲמֹ֨ור אֶחָ֤ד מֵהֶם֙ נָשָׂ֔אתִי וְלֹ֥א הֲרֵעֹ֖תִי אֶת־אַחַ֥ד מֵהֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","וַיֹּ֤אמֶר מֹשֶׁה֙ אֶל־קֹ֔רַח אַתָּה֙ וְכָל־עֲדָ֣תְךָ֔ הֱי֖וּ לִפְנֵ֣י יְהוָ֑ה אַתָּ֥ה וָהֵ֛ם וְאַהֲרֹ֖ן מָחָֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","וּקְח֣וּ ׀ אִ֣ישׁ מַחְתָּתֹ֗ו וּנְתַתֶּ֤ם עֲלֵיהֶם֙ קְטֹ֔רֶת וְהִקְרַבְתֶּ֞ם לִפְנֵ֤י יְהוָה֙ אִ֣ישׁ מַחְתָּתֹ֔ו חֲמִשִּׁ֥ים וּמָאתַ֖יִם מַחְתֹּ֑ת וְאַתָּ֥ה וְאַהֲרֹ֖ן אִ֥ישׁ מַחְתָּתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","וַיִּקְח֞וּ אִ֣ישׁ מַחְתָּתֹ֗ו וַיִּתְּנ֤וּ עֲלֵיהֶם֙ אֵ֔שׁ וַיָּשִׂ֥ימוּ עֲלֵיהֶ֖ם קְטֹ֑רֶת וַֽיַּעַמְד֗וּ פֶּ֛תַח אֹ֥הֶל מֹועֵ֖ד וּמֹשֶׁ֥ה וְאַהֲרֹֽן׃ ");
INSERT INTO hbo_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","וַיַּקְהֵ֨ל עֲלֵיהֶ֥ם קֹ֙רַח֙ אֶת־כָּל־הָ֣עֵדָ֔ה אֶל־פֶּ֖תַח אֹ֣הֶל מֹועֵ֑ד וַיֵּרָ֥א כְבֹוד־יְהוָ֖ה אֶל־כָּל־הָעֵדָֽה׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","וַיְדַבֵּ֣ר יְהוָ֔ה אֶל־מֹשֶׁ֥ה וְאֶֽל־אַהֲרֹ֖ן לֵאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","הִבָּ֣דְל֔וּ מִתֹּ֖וךְ הָעֵדָ֣ה הַזֹּ֑את וַאַכַלֶּ֥ה אֹתָ֖ם כְּרָֽגַע׃ ");
INSERT INTO hbo_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","וַיִּפְּל֤וּ עַל־פְּנֵיהֶם֙ וַיֹּ֣אמְר֔וּ אֵ֕ל אֱלֹהֵ֥י הָרוּחֹ֖ת לְכָל־בָּשָׂ֑ר הָאִ֤ישׁ אֶחָד֙ יֶחֱטָ֔א וְעַ֥ל כָּל־הָעֵדָ֖ה תִּקְצֹֽף׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","דַּבֵּ֥ר אֶל־הָעֵדָ֖ה לֵאמֹ֑ר הֵֽעָלוּ֙ מִסָּבִ֔יב לְמִשְׁכַּן־קֹ֖רַח דָּתָ֥ן וַאֲבִירָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","וַיָּ֣קָם מֹשֶׁ֔ה וַיֵּ֖לֶךְ אֶל־דָּתָ֣ן וַאֲבִירָ֑ם וַיֵּלְכ֥וּ אַחֲרָ֖יו זִקְנֵ֥י יִשְׂרָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","וַיְדַבֵּ֨ר אֶל־הָעֵדָ֜ה לֵאמֹ֗ר ס֣וּרוּ נָ֡א מֵעַל֩ אָהֳלֵ֨י הָאֲנָשִׁ֤ים הָֽרְשָׁעִים֙ הָאֵ֔לֶּה וְאַֽל־תִּגְּע֖וּ בְּכָל־אֲשֶׁ֣ר לָהֶ֑ם פֶּן־תִּסָּפ֖וּ בְּכָל־חַטֹּאתָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","וַיֵּעָל֗וּ מֵעַ֧ל מִשְׁכַּן־קֹ֛רֶח דָּתָ֥ן וַאֲבִירָ֖ם מִסָּבִ֑יב וְדָתָ֨ן וַאֲבִירָ֜ם יָצְא֣וּ נִצָּבִ֗ים פֶּ֚תַח אֽ͏ָהֳלֵיהֶ֔ם וּנְשֵׁיהֶ֥ם וּבְנֵיהֶ֖ם וְטַפָּֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","וַיֹּאמֶר֮ מֹשֶׁה֒ בְּזֹאת֙ תֵּֽדְע֔וּן כִּֽי־יְהוָ֣ה שְׁלָחַ֔נִי לַעֲשֹׂ֕ות אֵ֥ת כָּל־הַֽמַּעֲשִׂ֖ים הָאֵ֑לֶּה כִּי־לֹ֖א מִלִּבִּֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","אִם־כְּמֹ֤ות כָּל־הָֽאָדָם֙ יְמֻת֣וּן אֵ֔לֶּה וּפְקֻדַּת֙ כָּל־הָ֣אָדָ֔ם יִפָּקֵ֖ד עֲלֵיהֶ֑ם לֹ֥א יְהוָ֖ה שְׁלָחָֽנִי׃ ");
INSERT INTO hbo_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","וְאִם־בְּרִיאָ֞ה יִבְרָ֣א יְהוָ֗ה וּפָצְתָ֨ה הָאֲדָמָ֤ה אֶת־פִּ֙יהָ֙ וּבָלְעָ֤ה אֹתָם֙ וְאֶת־כָּל־אֲשֶׁ֣ר לָהֶ֔ם וְיָרְד֥וּ חַיִּ֖ים שְׁאֹ֑לָה וִֽידַעְתֶּ֕ם כִּ֧י נִֽאֲצ֛וּ הָאֲנָשִׁ֥ים הָאֵ֖לֶּה אֶת־יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","וַיְהִי֙ כְּכַלֹּתֹ֔ו לְדַבֵּ֕ר אֵ֥ת כָּל־הַדְּבָרִ֖ים הָאֵ֑לֶּה וַתִּבָּקַ֥ע הָאֲדָמָ֖ה אֲשֶׁ֥ר תַּחְתֵּיהֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","וַתִּפְתַּ֤ח הָאָ֙רֶץ֙ אֶת־פִּ֔יהָ וַתִּבְלַ֥ע אֹתָ֖ם וְאֶת־בָּתֵּיהֶ֑ם וְאֵ֤ת כָּל־הָאָדָם֙ אֲשֶׁ֣ר לְקֹ֔רַח וְאֵ֖ת כָּל־הָרֲכֽוּשׁ׃ ");
INSERT INTO hbo_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","וַיֵּ֨רְד֜וּ הֵ֣ם וְכָל־אֲשֶׁ֥ר לָהֶ֛ם חַיִּ֖ים שְׁאֹ֑לָה וַתְּכַ֤ס עֲלֵיהֶם֙ הָאָ֔רֶץ וַיֹּאבְד֖וּ מִתֹּ֥וךְ הַקָּהָֽל׃ ");
INSERT INTO hbo_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","וְכָל־יִשְׂרָאֵ֗ל אֲשֶׁ֛ר סְבִיבֹתֵיהֶ֖ם נָ֣סוּ לְקֹלָ֑ם כִּ֣י אָֽמְר֔וּ פֶּן־תִּבְלָעֵ֖נוּ הָאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","וְאֵ֥שׁ יָצְאָ֖ה מֵאֵ֣ת יְהוָ֑ה וַתֹּ֗אכַל אֵ֣ת הַחֲמִשִּׁ֤ים וּמָאתַ֙יִם֙ אִ֔ישׁ מַקְרִיבֵ֖י הַקְּטֹֽרֶת׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","אֱמֹ֨ר אֶל־אֶלְעָזָ֜ר בֶּן־אַהֲרֹ֣ן הַכֹּהֵ֗ן וְיָרֵ֤ם אֶת־הַמַּחְתֹּת֙ מִבֵּ֣ין הַשְּׂרֵפָ֔ה וְאֶת־הָאֵ֖שׁ זְרֵה־הָ֑לְאָה כִּ֖י קָדֵֽשׁוּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","אֵ֡ת מַחְתֹּות֩ הֽ͏ַחַטָּאִ֨ים הָאֵ֜לֶּה בְּנַפְשֹׁתָ֗ם וְעָשׂ֨וּ אֹתָ֜ם רִקֻּעֵ֤י פַחִים֙ צִפּ֣וּי לַמִּזְבֵּ֔חַ כִּֽי־הִקְרִיבֻ֥ם לִפְנֵֽי־יְהוָ֖ה וַיִּקְדָּ֑שׁוּ וְיִֽהְי֥וּ לְאֹ֖ות לִבְנֵ֥י יִשְׂרָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","וַיִּקַּ֞ח אֶלְעָזָ֣ר הַכֹּהֵ֗ן אֵ֚ת מַחְתֹּ֣ות הַנְּחֹ֔שֶׁת אֲשֶׁ֥ר הִקְרִ֖יבוּ הַשְּׂרֻפִ֑ים וַֽיְרַקְּע֖וּם צִפּ֥וּי לַמִּזְבֵּֽחַ׃ ");
INSERT INTO hbo_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","זִכָּרֹ֞ון לִבְנֵ֣י יִשְׂרָאֵ֗ל לְ֠מַעַן אֲשֶׁ֨ר לֹֽא־יִקְרַ֜ב אִ֣ישׁ זָ֗ר אֲ֠שֶׁר לֹ֣א מִזֶּ֤רַע אַהֲרֹן֙ ה֔וּא לְהַקְטִ֥יר קְטֹ֖רֶת לִפְנֵ֣י יְהוָ֑ה וְלֹֽא־יִהְיֶ֤ה כְקֹ֙רַח֙ וְכַ֣עֲדָתֹ֔ו כַּאֲשֶׁ֨ר דִּבֶּ֧ר יְהוָ֛ה בְּיַד־מֹשֶׁ֖ה לֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","וַיִּלֹּ֜נוּ כָּל־עֲדַ֤ת בְּנֵֽי־יִשְׂרָאֵל֙ מִֽמָּחֳרָ֔ת עַל־מֹשֶׁ֥ה וְעַֽל־אַהֲרֹ֖ן לֵאמֹ֑ר אַתֶּ֥ם הֲמִתֶּ֖ם אֶת־עַ֥ם יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","וַיְהִ֗י בְּהִקָּהֵ֤ל הָֽעֵדָה֙ עַל־מֹשֶׁ֣ה וְעַֽל־אַהֲרֹ֔ן וַיִּפְנוּ֙ אֶל־אֹ֣הֶל מֹועֵ֔ד וְהִנֵּ֥ה כִסָּ֖הוּ הֶעָנָ֑ן וַיֵּרָ֖א כְּבֹ֥וד יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","וַיָּבֹ֤א מֹשֶׁה֙ וְאַהֲרֹ֔ן אֶל־פְּנֵ֖י אֹ֥הֶל מֹועֵֽד׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","הֵרֹ֗מּוּ מִתֹּוךְ֙ הָעֵדָ֣ה הַזֹּ֔את וַאֲכַלֶּ֥ה אֹתָ֖ם כְּרָ֑גַע וַֽיִּפְּל֖וּ עַל־פְּנֵיהֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","וַיֹּ֨אמֶר מֹשֶׁ֜ה אֶֽל־אַהֲרֹ֗ן קַ֣ח אֶת־הַ֠מַּחְתָּה וְתֶן־עָלֶ֨יהָ אֵ֜שׁ מֵעַ֤ל הַמִּזְבֵּ֙חַ֙ וְשִׂ֣ים קְטֹ֔רֶת וְהֹולֵ֧ךְ מְהֵרָ֛ה אֶל־הָעֵדָ֖ה וְכַפֵּ֣ר עֲלֵיהֶ֑ם כִּֽי־יָצָ֥א הַקֶּ֛צֶף מִלִּפְנֵ֥י יְהוָ֖ה הֵחֵ֥ל הַנָּֽגֶף׃ ");
INSERT INTO hbo_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","וַיִּקַּ֨ח אַהֲרֹ֜ן כַּאֲשֶׁ֣ר ׀ דִּבֶּ֣ר מֹשֶׁ֗ה וַיָּ֙רָץ֙ אֶל־תֹּ֣וך הַקָּהָ֔ל וְהִנֵּ֛ה הֵחֵ֥ל הַנֶּ֖גֶף בָּעָ֑ם וַיִּתֵּן֙ אֶֽת־הַקְּטֹ֔רֶת וַיְכַפֵּ֖ר עַל־הָעָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","וַיַּעֲמֹ֥ד בֵּֽין־הַמֵּתִ֖ים וּבֵ֣ין הֽ͏ַחַיִּ֑ים וַתֵּעָצַ֖ר הַמַּגֵּפָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU17_14","005_17_14","NUM","17","14","14","וַיִּהְי֗וּ הַמֵּתִים֙ בַּמַּגֵּפָ֔ה אַרְבָּעָ֥ה עָשָׂ֛ר אֶ֖לֶף וּשְׁבַ֣ע מֵאֹ֑ות מִלְּבַ֥ד הַמֵּתִ֖ים עַל־דְּבַר־קֹֽרַח׃ ");
INSERT INTO hbo_vpl VALUES ("NU17_15","005_17_15","NUM","17","15","15","וַיָּ֤שָׁב אַהֲרֹן֙ אֶל־מֹשֶׁ֔ה אֶל־פֶּ֖תַח אֹ֣הֶל מֹועֵ֑ד וְהַמַּגֵּפָ֖ה נֶעֱצָֽרָה׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU17_16","005_17_16","NUM","17","16","16","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU17_17","005_17_17","NUM","17","17","17","דַּבֵּ֣ר ׀ אֶל־בְּנֵ֣י יִשְׂרָאֵ֗ל וְקַ֣ח מֵֽאִתָּ֡ם מַטֶּ֣ה מַטֶּה֩ לְבֵ֨ית אָ֜ב מֵאֵ֤ת כָּל־נְשִֽׂיאֵהֶם֙ לְבֵ֣ית אֲבֹתָ֔ם שְׁנֵ֥ים עָשָׂ֖ר מַטֹּ֑ות אִ֣ישׁ אֶת־שְׁמֹ֔ו תִּכְתֹּ֖ב עַל־מַטֵּֽהוּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU17_18","005_17_18","NUM","17","18","18","וְאֵת֙ שֵׁ֣ם אַהֲרֹ֔ן תִּכְתֹּ֖ב עַל־מַטֵּ֣ה לֵוִ֑י כִּ֚י מַטֶּ֣ה אֶחָ֔ד לְרֹ֖אשׁ בֵּ֥ית אֲבֹותָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU17_19","005_17_19","NUM","17","19","19","וְהִנַּחְתָּ֖ם בְּאֹ֣הֶל מֹועֵ֑ד לִפְנֵי֙ הָֽעֵד֔וּת אֲשֶׁ֛ר אִוָּעֵ֥ד לָכֶ֖ם שָֽׁמָּה׃ ");
INSERT INTO hbo_vpl VALUES ("NU17_20","005_17_20","NUM","17","20","20","וְהָיָ֗ה הָאִ֛ישׁ אֲשֶׁ֥ר אֶבְחַר־בֹּ֖ו מַטֵּ֣הוּ יִפְרָ֑ח וַהֲשִׁכֹּתִ֣י מֵֽעָלַ֗י אֶת־תְּלֻנֹּות֙ בְּנֵ֣י יִשְׂרָאֵ֔ל אֲשֶׁ֛ר הֵ֥ם מַלִּינִ֖ם עֲלֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU17_21","005_17_21","NUM","17","21","21","וַיְדַבֵּ֨ר מֹשֶׁ֜ה אֶל־בְּנֵ֣י יִשְׂרָאֵ֗ל וַיִּתְּנ֣וּ אֵלָ֣יו ׀ כָּֽל־נְשִֽׂיאֵיהֶ֡ם מַטֶּה֩ לְנָשִׂ֨יא אֶחָ֜ד מַטֶּ֨ה לְנָשִׂ֤יא אֶחָד֙ לְבֵ֣ית אֲבֹתָ֔ם שְׁנֵ֥ים עָשָׂ֖ר מַטֹּ֑ות וּמַטֵּ֥ה אַהֲרֹ֖ן בְּתֹ֥וךְ מַטֹּותָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU17_22","005_17_22","NUM","17","22","22","וַיַּנַּ֥ח מֹשֶׁ֛ה אֶת־הַמַּטֹּ֖ת לִפְנֵ֣י יְהוָ֑ה בְּאֹ֖הֶל הָעֵדֻֽת׃ ");
INSERT INTO hbo_vpl VALUES ("NU17_23","005_17_23","NUM","17","23","23","וַיְהִ֣י מִֽמָּחֳרָ֗ת וַיָּבֹ֤א מֹשֶׁה֙ אֶל־אֹ֣הֶל הָעֵד֔וּת וְהִנֵּ֛ה פָּרַ֥ח מַטֵּֽה־אַהֲרֹ֖ן לְבֵ֣ית לֵוִ֑י וַיֹּ֤צֵֽא פֶ֙רַח֙ וַיָּ֣צֵֽץ צִ֔יץ וַיִּגְמֹ֖ל שְׁקֵדִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("NU17_24","005_17_24","NUM","17","24","24","וַיֹּצֵ֨א מֹשֶׁ֤ה אֶת־כָּל־הַמַּטֹּת֙ מִלִּפְנֵ֣י יְהוָ֔ה אֶֽל־כָּל־בְּנֵ֖י יִשְׂרָאֵ֑ל וַיִּרְא֥וּ וַיִּקְח֖וּ אִ֥ישׁ מַטֵּֽהוּ׃ ס ");
INSERT INTO hbo_vpl VALUES ("NU17_25","005_17_25","NUM","17","25","25","וַיֹּ֨אמֶר יְהוָ֜ה אֶל־מֹשֶׁ֗ה הָשֵׁ֞ב אֶת־מַטֵּ֤ה אַהֲרֹן֙ לִפְנֵ֣י הָעֵד֔וּת לְמִשְׁמֶ֥רֶת לְאֹ֖ות לִבְנֵי־מֶ֑רִי וּתְכַ֧ל תְּלוּנֹּתָ֛ם מֵעָלַ֖י וְלֹ֥א יָמֻֽתוּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU17_26","005_17_26","NUM","17","26","26","וַיַּ֖עַשׂ מֹשֶׁ֑ה כַּאֲשֶׁ֨ר צִוָּ֧ה יְהוָ֛ה אֹתֹ֖ו כֵּ֥ן עָשָֽׂה׃ ס ");
INSERT INTO hbo_vpl VALUES ("NU17_27","005_17_27","NUM","17","27","27","וַיֹּֽאמְרוּ֙ בְּנֵ֣י יִשְׂרָאֵ֔ל אֶל־מֹשֶׁ֖ה לֵאמֹ֑ר הֵ֥ן גָּוַ֛עְנוּ אָבַ֖דְנוּ כֻּלָּ֥נוּ אָבַֽדְנוּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU17_28","005_17_28","NUM","17","28","28","כֹּ֣ל הַקָּרֵ֧ב ׀ הַקָּרֵ֛ב אֶל־מִשְׁכַּ֥ן יְהוָ֖ה יָמ֑וּת הַאִ֥ם תַּ֖מְנוּ לִגְוֹֽעַ׃ ס ");
INSERT INTO hbo_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","וַיֹּ֤אמֶר יְהוָה֙ אֶֽל־אַהֲרֹ֔ן אַתָּ֗ה וּבָנֶ֤יךָ וּבֵית־אָבִ֙יךָ֙ אִתָּ֔ךְ תִּשְׂא֖וּ אֶת־עֲוֹ֣ן הַמִּקְדָּ֑שׁ וְאַתָּה֙ וּבָנֶ֣יךָ אִתָּ֔ךְ תִּשְׂא֖וּ אֶת־עֲוֹ֥ן כְּהֻנַּתְכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","וְגַ֣ם אֶת־אַחֶיךָ֩ מַטֵּ֨ה לֵוִ֜י שֵׁ֤בֶט אָבִ֙יךָ֙ הַקְרֵ֣ב אִתָּ֔ךְ וְיִלָּו֥וּ עָלֶ֖יךָ וִֽישָׁרְת֑וּךָ וְאַתָּה֙ וּבָנֶ֣יךָ אִתָּ֔ךְ לִפְנֵ֖י אֹ֥הֶל הָעֵדֻֽת׃ ");
INSERT INTO hbo_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","וְשָֽׁמְרוּ֙ מִֽשְׁמַרְתְּךָ֔ וּמִשְׁמֶ֖רֶת כָּל־הָאֹ֑הֶל אַךְ֩ אֶל־כְּלֵ֨י הַקֹּ֤דֶשׁ וְאֶל־הַמִּזְבֵּ֙חַ֙ לֹ֣א יִקְרָ֔בוּ וְלֹֽא־יָמֻ֥תוּ גַם־הֵ֖ם גַּם־אַתֶּֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","וְנִלְו֣וּ עָלֶ֔יךָ וְשָֽׁמְר֗וּ אֶת־מִשְׁמֶ֙רֶת֙ אֹ֣הֶל מֹועֵ֔ד לְכֹ֖ל עֲבֹדַ֣ת הָאֹ֑הֶל וְזָ֖ר לֹא־יִקְרַ֥ב אֲלֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","וּשְׁמַרְתֶּ֗ם אֵ֚ת מִשְׁמֶ֣רֶת הַקֹּ֔דֶשׁ וְאֵ֖ת מִשְׁמֶ֣רֶת הַמִּזְבֵּ֑חַ וְלֹֽא־יִהְיֶ֥ה עֹ֛וד קֶ֖צֶף עַל־בְּנֵ֥י יִשְׂרָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","וַאֲנִ֗י הִנֵּ֤ה לָקַ֙חְתִּי֙ אֶת־אֲחֵיכֶ֣ם הַלְוִיִּ֔ם מִתֹּ֖וךְ בְּנֵ֣י יִשְׂרָאֵ֑ל לָכֶ֞ם מַתָּנָ֤ה נְתֻנִים֙ לַֽיהוָ֔ה לַעֲבֹ֕ד אֶת־עֲבֹדַ֖ת אֹ֥הֶל מֹועֵֽד׃ ");
INSERT INTO hbo_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","וְאַתָּ֣ה וּבָנֶ֣יךָ אִ֠תְּךָ תִּשְׁמְר֨וּ אֶת־כְּהֻנַּתְכֶ֜ם לְכָל־דְּבַ֧ר הַמִּזְבֵּ֛חַ וּלְמִבֵּ֥ית לַפָּרֹ֖כֶת וַעֲבַדְתֶּ֑ם עֲבֹדַ֣ת מַתָּנָ֗ה אֶתֵּן֙ אֶת־כְּהֻנַּתְכֶ֔ם וְהַזָּ֥ר הַקָּרֵ֖ב יוּמָֽת׃ ס ");
INSERT INTO hbo_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","וַיְדַבֵּ֣ר יְהוָה֮ אֶֽל־אַהֲרֹן֒ וַאֲנִי֙ הִנֵּ֣ה נָתַ֣תִּֽי לְךָ֔ אֶת־מִשְׁמֶ֖רֶת תְּרוּמֹתָ֑י לְכָל־קָדְשֵׁ֣י בְנֵֽי־יִ֠שְׂרָאֵל לְךָ֙ נְתַתִּ֧ים לְמָשְׁחָ֛ה וּלְבָנֶ֖יךָ לְחָק־עֹולָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","זֶֽה־יִהְיֶ֥ה לְךָ֛ מִקֹּ֥דֶשׁ הַקֳּדָשִׁ֖ים מִן־הָאֵ֑שׁ כָּל־קָ֠רְבָּנָם לְֽכָל־מִנְחָתָ֞ם וּלְכָל־חַטָּאתָ֗ם וּלְכָל־אֲשָׁמָם֙ אֲשֶׁ֣ר יָשִׁ֣יבוּ לִ֔י קֹ֣דֶשׁ קָֽדָשִׁ֥ים לְךָ֛ ה֖וּא וּלְבָנֶֽיךָ׃ ");
INSERT INTO hbo_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","בְּקֹ֥דֶשׁ הַקֳּדָשִׁ֖ים תֹּאכֲלֶ֑נּוּ כָּל־זָכָר֙ יֹאכַ֣ל אֹתֹ֔ו קֹ֖דֶשׁ יִֽהְיֶה־לָּֽךְ׃ ");
INSERT INTO hbo_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","וְזֶה־לְּךָ֞ תְּרוּמַ֣ת מַתָּנָ֗ם לְכָל־תְּנוּפֹת֮ בְּנֵ֣י יִשְׂרָאֵל֒ לְךָ֣ נְתַתִּ֗ים וּלְבָנֶ֧יךָ וְלִבְנֹתֶ֛יךָ אִתְּךָ֖ לְחָק־עֹולָ֑ם כָּל־טָהֹ֥ור בְּבֵיתְךָ֖ יֹאכַ֥ל אֹתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","כֹּ֚ל חֵ֣לֶב יִצְהָ֔ר וְכָל־חֵ֖לֶב תִּירֹ֣ושׁ וְדָגָ֑ן רֵאשִׁיתָ֛ם אֲשֶׁר־יִתְּנ֥וּ לַֽיהוָ֖ה לְךָ֥ נְתַתִּֽים׃ ");
INSERT INTO hbo_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","בִּכּוּרֵ֞י כָּל־אֲשֶׁ֧ר בְּאַרְצָ֛ם אֲשֶׁר־יָבִ֥יאוּ לַיהוָ֖ה לְךָ֣ יִהְיֶ֑ה כָּל־טָהֹ֥ור בְּבֵיתְךָ֖ יֹאכֲלֶֽנּוּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","כָּל־חֵ֥רֶם בְּיִשְׂרָאֵ֖ל לְךָ֥ יִהְיֶֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","כָּל־פֶּ֣טֶר רֶ֠חֶם לְֽכָל־בָּשָׂ֞ר אֲשֶׁר־יַקְרִ֧יבוּ לַֽיהוָ֛ה בָּאָדָ֥ם וּבַבְּהֵמָ֖ה יִֽהְיֶה־לָּ֑ךְ אַ֣ךְ ׀ פָּדֹ֣ה תִפְדֶּ֗ה אֵ֚ת בְּכֹ֣ור הָֽאָדָ֔ם וְאֵ֛ת בְּכֹֽור־הַבְּהֵמָ֥ה הַטְּמֵאָ֖ה תִּפְדֶּֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","וּפְדוּיָו֙ מִבֶּן־חֹ֣דֶשׁ תִּפְדֶּ֔ה בְּעֶ֨רְכְּךָ֔ כֶּ֛סֶף חֲמֵ֥שֶׁת שְׁקָלִ֖ים בְּשֶׁ֣קֶל הַקֹּ֑דֶשׁ עֶשְׂרִ֥ים גֵּרָ֖ה הֽוּא׃ ");
INSERT INTO hbo_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","אַ֣ךְ בְּֽכֹור־שֹׁ֡ור אֹֽו־בְכֹ֨ור כֶּ֜שֶׂב אֹֽו־בְכֹ֥ור עֵ֛ז לֹ֥א תִפְדֶּ֖ה קֹ֣דֶשׁ הֵ֑ם אֶת־דָּמָ֞ם תִּזְרֹ֤ק עַל־הַמִּזְבֵּ֙חַ֙ וְאֶת־חֶלְבָּ֣ם תַּקְטִ֔יר אִשֶּׁ֛ה לְרֵ֥יחַ נִיחֹ֖חַ לַֽיהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","וּבְשָׂרָ֖ם יִהְיֶה־לָּ֑ךְ כַּחֲזֵ֧ה הַתְּנוּפָ֛ה וּכְשֹׁ֥וק הַיָּמִ֖ין לְךָ֥ יִהְיֶֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","כֹּ֣ל ׀ תְּרוּמֹ֣ת הַקֳּדָשִׁ֗ים אֲשֶׁ֨ר יָרִ֥ימוּ בְנֵֽי־יִשְׂרָאֵל֮ לַֽיהוָה֒ נָתַ֣תִּֽי לְךָ֗ וּלְבָנֶ֧יךָ וְלִבְנֹתֶ֛יךָ אִתְּךָ֖ לְחָק־עֹולָ֑ם בְּרִית֩ מֶ֨לַח עֹולָ֥ם הִוא֙ לִפְנֵ֣י יְהוָ֔ה לְךָ֖ וּלְזַרְעֲךָ֥ אִתָּֽךְ׃ ");
INSERT INTO hbo_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","וַיֹּ֨אמֶר יְהוָ֜ה אֶֽל־אַהֲרֹ֗ן בְּאַרְצָם֙ לֹ֣א תִנְחָ֔ל וְחֵ֕לֶק לֹא־יִהְיֶ֥ה לְךָ֖ בְּתֹוכָ֑ם אֲנִ֤י חֶלְקְךָ֙ וְנַחֲלָ֣תְךָ֔ בְּתֹ֖וךְ בְּנֵ֥י יִשְׂרָאֵֽל׃ ס ");
INSERT INTO hbo_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","וְלִבְנֵ֣י לֵוִ֔י הִנֵּ֥ה נָתַ֛תִּי כָּל־מֽ͏ַעֲשֵׂ֥ר בְּיִשְׂרָאֵ֖ל לְנַחֲלָ֑ה חֵ֤לֶף עֲבֹֽדָתָם֙ אֲשֶׁר־הֵ֣ם עֹֽבְדִ֔ים אֶת־עֲבֹדַ֖ת אֹ֥הֶל מֹועֵֽד׃ ");
INSERT INTO hbo_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","וְלֹא־יִקְרְב֥וּ עֹ֛וד בְּנֵ֥י יִשְׂרָאֵ֖ל אֶל־אֹ֣הֶל מֹועֵ֑ד לָשֵׂ֥את חֵ֖טְא לָמֽוּת׃ ");
INSERT INTO hbo_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","וְעָבַ֨ד הַלֵּוִ֜י ה֗וּא אֶת־עֲבֹדַת֙ אֹ֣הֶל מֹועֵ֔ד וְהֵ֖ם יִשְׂא֣וּ עֲוֹנָ֑ם חֻקַּ֤ת עֹולָם֙ לְדֹרֹ֣תֵיכֶ֔ם וּבְתֹוךְ֙ בְּנֵ֣י יִשְׂרָאֵ֔ל לֹ֥א יִנְחֲל֖וּ נַחֲלָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","כִּ֞י אֶת־מַעְשַׂ֣ר בְּנֵֽי־יִשְׂרָאֵ֗ל אֲשֶׁ֨ר יָרִ֤ימוּ לֽ͏ַיהוָה֙ תְּרוּמָ֔ה נָתַ֥תִּי לַלְוִיִּ֖ם לְנַחֲלָ֑ה עַל־כֵּן֙ אָמַ֣רְתִּי לָהֶ֔ם בְּתֹוךְ֙ בְּנֵ֣י יִשְׂרָאֵ֔ל לֹ֥א יִנְחֲל֖וּ נַחֲלָֽה׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","וְאֶל־הַלְוִיִּ֣ם תְּדַבֵּר֮ וְאָמַרְתָּ֣ אֲלֵהֶם֒ כִּֽי־תִ֠קְחוּ מֵאֵ֨ת בְּנֵֽי־יִשְׂרָאֵ֜ל אֶת־הַֽמַּעֲשֵׂ֗ר אֲשֶׁ֨ר נָתַ֧תִּי לָכֶ֛ם מֵאִתָּ֖ם בְּנַחֲלַתְכֶ֑ם וַהֲרֵמֹתֶ֤ם מִמֶּ֙נּוּ֙ תְּרוּמַ֣ת יְהוָ֔ה מַעֲשֵׂ֖ר מִן־הַֽמַּעֲשֵֽׂר׃ ");
INSERT INTO hbo_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","וְנֶחְשַׁ֥ב לָכֶ֖ם תְּרוּמַתְכֶ֑ם כַּדָּגָן֙ מִן־הַגֹּ֔רֶן וְכַֽמְלֵאָ֖ה מִן־הַיָּֽקֶב׃ ");
INSERT INTO hbo_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","כֵּ֣ן תָּרִ֤ימוּ גַם־אַתֶּם֙ תְּרוּמַ֣ת יְהוָ֔ה מִכֹּל֙ מַעְשְׂרֹ֣תֵיכֶ֔ם אֲשֶׁ֣ר תִּקְח֔וּ מֵאֵ֖ת בְּנֵ֣י יִשְׂרָאֵ֑ל וּנְתַתֶּ֤ם מִמֶּ֙נּוּ֙ אֶת־תְּרוּמַ֣ת יְהוָ֔ה לְאַהֲרֹ֖ן הַכֹּהֵֽן׃ ");
INSERT INTO hbo_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","מִכֹּל֙ מַתְּנֹ֣תֵיכֶ֔ם תָּרִ֕ימוּ אֵ֖ת כָּל־תְּרוּמַ֣ת יְהוָ֑ה מִכָּל־חֶלְבֹּ֔ו אֶֽת־מִקְדְּשֹׁ֖ו מִמֶּֽנּוּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","וְאָמַרְתָּ֖ אֲלֵהֶ֑ם בַּהֲרִֽימְכֶ֤ם אֶת־חֶלְבֹּו֙ מִמֶּ֔נּוּ וְנֶחְשַׁב֙ לַלְוִיִּ֔ם כִּתְבוּאַ֥ת גֹּ֖רֶן וְכִתְבוּאַ֥ת יָֽקֶב׃ ");
INSERT INTO hbo_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","וַאֲכַלְתֶּ֤ם אֹתֹו֙ בְּכָל־מָקֹ֔ום אַתֶּ֖ם וּבֵֽיתְכֶ֑ם כִּֽי־שָׂכָ֥ר הוּא֙ לָכֶ֔ם חֵ֥לֶף עֲבֹֽדַתְכֶ֖ם בְּאֹ֥הֶל מֹועֵֽד׃ ");
INSERT INTO hbo_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","וְלֹֽא־תִשְׂא֤וּ עָלָיו֙ חֵ֔טְא בַּהֲרִֽימְכֶ֥ם אֶת־חֶלְבֹּ֖ו מִמֶּ֑נּוּ וְאֶת־קָדְשֵׁ֧י בְנֵי־יִשְׂרָאֵ֛ל לֹ֥א תְחַלְּל֖וּ וְלֹ֥א תָמֽוּתוּ׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","וַיְדַבֵּ֣ר יְהוָ֔ה אֶל־מֹשֶׁ֥ה וְאֶֽל־אַהֲרֹ֖ן לֵאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","זֹ֚את חֻקַּ֣ת הַתֹּורָ֔ה אֲשֶׁר־צִוָּ֥ה יְהוָ֖ה לֵאמֹ֑ר דַּבֵּ֣ר ׀ אֶל־בְּנֵ֣י יִשְׂרָאֵ֗ל וְיִקְח֣וּ אֵלֶיךָ֩ פָרָ֨ה אֲדֻמָּ֜ה תְּמִימָ֗ה אֲשֶׁ֤ר אֵֽין־בָּהּ֙ מ֔וּם אֲשֶׁ֛ר לֹא־עָלָ֥ה עָלֶ֖יהָ עֹֽל׃ ");
INSERT INTO hbo_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","וּנְתַתֶּ֣ם אֹתָ֔הּ אֶל־אֶלְעָזָ֖ר הַכֹּהֵ֑ן וְהֹוצִ֤יא אֹתָהּ֙ אֶל־מִח֣וּץ לַֽמַּחֲנֶ֔ה וְשָׁחַ֥ט אֹתָ֖הּ לְפָנָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","וְלָקַ֞ח אֶלְעָזָ֧ר הַכֹּהֵ֛ן מִדָּמָ֖הּ בְּאֶצְבָּעֹ֑ו וְהִזָּ֞ה אֶל־נֹ֨כַח פְּנֵ֧י אֹֽהֶל־מֹועֵ֛ד מִדָּמָ֖הּ שֶׁ֥בַע פְּעָמִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","וְשָׂרַ֥ף אֶת־הַפָּרָ֖ה לְעֵינָ֑יו אֶת־עֹרָ֤הּ וְאֶת־בְּשָׂרָהּ֙ וְאֶת־דָּמָ֔הּ עַל־פִּרְשָׁ֖הּ יִשְׂרֹֽף׃ ");
INSERT INTO hbo_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","וְלָקַ֣ח הַכֹּהֵ֗ן עֵ֥ץ אֶ֛רֶז וְאֵזֹ֖וב וּשְׁנִ֣י תֹולָ֑עַת וְהִשְׁלִ֕יךְ אֶל־תֹּ֖וךְ שְׂרֵפַ֥ת הַפָּרָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","וְכִבֶּ֨ס בְּגָדָ֜יו הַכֹּהֵ֗ן וְרָחַ֤ץ בְּשָׂרֹו֙ בַּמַּ֔יִם וְאַחַ֖ר יָבֹ֣וא אֶל־הַֽמַּחֲנֶ֑ה וְטָמֵ֥א הַכֹּהֵ֖ן עַד־הָעָֽרֶב׃ ");
INSERT INTO hbo_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","וְהַשֹּׂרֵ֣ף אֹתָ֔הּ יְכַבֵּ֤ס בְּגָדָיו֙ בַּמַּ֔יִם וְרָחַ֥ץ בְּשָׂרֹ֖ו בַּמָּ֑יִם וְטָמֵ֖א עַד־הָעָֽרֶב׃ ");
INSERT INTO hbo_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","וְאָסַ֣ף ׀ אִ֣ישׁ טָהֹ֗ור אֵ֚ת אֵ֣פֶר הַפָּרָ֔ה וְהִנִּ֛יחַ מִח֥וּץ לַֽמַּחֲנֶ֖ה בְּמָקֹ֣ום טָהֹ֑ור וְ֠הָיְתָה לַעֲדַ֨ת בְּנֵֽי־יִשְׂרָאֵ֧ל לְמִשְׁמֶ֛רֶת לְמֵ֥י נִדָּ֖ה חַטָּ֥את הִֽוא׃ ");
INSERT INTO hbo_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","וְ֠כִבֶּס הָאֹסֵ֨ף אֶת־אֵ֤פֶר הַפָּרָה֙ אֶת־בְּגָדָ֔יו וְטָמֵ֖א עַד־הָעָ֑רֶב וְֽהָיְתָ֞ה לִבְנֵ֣י יִשְׂרָאֵ֗ל וְלַגֵּ֛ר הַגָּ֥ר בְּתֹוכָ֖ם לְחֻקַּ֥ת עֹולָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","הַנֹּגֵ֥עַ בְּמֵ֖ת לְכָל־נֶ֣פֶשׁ אָדָ֑ם וְטָמֵ֖א שִׁבְעַ֥ת יָמִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","ה֣וּא יִתְחַטָּא־בֹ֞ו בַּיֹּ֧ום הַשְּׁלִישִׁ֛י וּבַיֹּ֥ום הַשְּׁבִיעִ֖י יִטְהָ֑ר וְאִם־לֹ֨א יִתְחַטָּ֜א בַּיֹּ֧ום הַשְּׁלִישִׁ֛י וּבַיֹּ֥ום הַשְּׁבִיעִ֖י לֹ֥א יִטְהָֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","כָּֽל־הַנֹּגֵ֡עַ בְּמֵ֣ת בְּנֶפֶשׁ֩ הָאָדָ֨ם אֲשֶׁר־יָמ֜וּת וְלֹ֣א יִתְחַטָּ֗א אֶת־מִשְׁכַּ֤ן יְהוָה֙ טִמֵּ֔א וְנִכְרְתָ֛ה הַנֶּ֥פֶשׁ הַהִ֖וא מִיִּשְׂרָאֵ֑ל כִּי֩ מֵ֨י נִדָּ֜ה לֹא־זֹרַ֤ק עָלָיו֙ טָמֵ֣א יִהְיֶ֔ה עֹ֖וד טֻמְאָתֹ֥ו בֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","זֹ֚את הַתֹּורָ֔ה אָדָ֖ם כִּֽי־יָמ֣וּת בְּאֹ֑הֶל כָּל־הַבָּ֤א אֶל־הָאֹ֙הֶל֙ וְכָל־אֲשֶׁ֣ר בָּאֹ֔הֶל יִטְמָ֖א שִׁבְעַ֥ת יָמִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","וְכֹל֙ כְּלִ֣י פָת֔וּחַ אֲשֶׁ֛ר אֵין־צָמִ֥יד פָּתִ֖יל עָלָ֑יו טָמֵ֖א הֽוּא׃ ");
INSERT INTO hbo_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","וְכֹ֨ל אֲשֶׁר־יִגַּ֜ע עַל־פְּנֵ֣י הַשָּׂדֶ֗ה בּֽ͏ַחֲלַל־חֶ֙רֶב֙ אֹ֣ו בְמֵ֔ת אֹֽו־בְעֶ֥צֶם אָדָ֖ם אֹ֣ו בְקָ֑בֶר יִטְמָ֖א שִׁבְעַ֥ת יָמִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","וְלָֽקְחוּ֙ לַטָּמֵ֔א מֵעֲפַ֖ר שְׂרֵפַ֣ת הַֽחַטָּ֑את וְנָתַ֥ן עָלָ֛יו מַ֥יִם חַיִּ֖ים אֶל־כֶּֽלִי׃ ");
INSERT INTO hbo_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","וְלָקַ֨ח אֵזֹ֜וב וְטָבַ֣ל בַּמַּיִם֮ אִ֣ישׁ טָהֹור֒ וְהִזָּ֤ה עַל־הָאֹ֙הֶל֙ וְעַל־כָּל־הַכֵּלִ֔ים וְעַל־הַנְּפָשֹׁ֖ות אֲשֶׁ֣ר הָֽיוּ־שָׁ֑ם וְעַל־הַנֹּגֵ֗עַ בַּעֶ֙צֶם֙ אֹ֣ו בֶֽחָלָ֔ל אֹ֥ו בַמֵּ֖ת אֹ֥ו בַקָּֽבֶר׃ ");
INSERT INTO hbo_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","וְהִזָּ֤ה הַטָּהֹר֙ עַל־הַטָּמֵ֔א בַּיֹּ֥ום הַשְּׁלִישִׁ֖י וּבַיֹּ֣ום הַשְּׁבִיעִ֑י וְחִטְּאֹו֙ בַּיֹּ֣ום הַשְּׁבִיעִ֔י וְכִבֶּ֧ס בְּגָדָ֛יו וְרָחַ֥ץ בַּמַּ֖יִם וְטָהֵ֥ר בָּעָֽרֶב׃ ");
INSERT INTO hbo_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","וְאִ֤ישׁ אֲשֶׁר־יִטְמָא֙ וְלֹ֣א יִתְחַטָּ֔א וְנִכְרְתָ֛ה הַנֶּ֥פֶשׁ הַהִ֖וא מִתֹּ֣וךְ הַקָּהָ֑ל כִּי֩ אֶת־מִקְדַּ֨שׁ יְהוָ֜ה טִמֵּ֗א מֵ֥י נִדָּ֛ה לֹא־זֹרַ֥ק עָלָ֖יו טָמֵ֥א הֽוּא׃ ");
INSERT INTO hbo_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","וְהָיְתָ֥ה לָּהֶ֖ם לְחֻקַּ֣ת עֹולָ֑ם וּמַזֵּ֤ה מֵֽי־הַנִּדָּה֙ יְכַבֵּ֣ס בְּגָדָ֔יו וְהַנֹּגֵ֙עַ֙ בְּמֵ֣י הַנִּדָּ֔ה יִטְמָ֖א עַד־הָעָֽרֶב׃ ");
INSERT INTO hbo_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","וְכֹ֛ל אֲשֶׁר־יִגַּע־בֹּ֥ו הַטָּמֵ֖א יִטְמָ֑א וְהַנֶּ֥פֶשׁ הַנֹּגַ֖עַת תִּטְמָ֥א עַד־הָעָֽרֶב׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","וַיָּבֹ֣אוּ בְנֵֽי־יִ֠שְׂרָאֵל כָּל־הָ֨עֵדָ֤ה מִדְבַּר־צִן֙ בַּחֹ֣דֶשׁ הָֽרִאשֹׁ֔ון וַיֵּ֥שֶׁב הָעָ֖ם בְּקָדֵ֑שׁ וַתָּ֤מָת שָׁם֙ מִרְיָ֔ם וַתִּקָּבֵ֖ר שָֽׁם׃ ");
INSERT INTO hbo_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","וְלֹא־הָ֥יָה מַ֖יִם לָעֵדָ֑ה וַיִּקָּ֣הֲל֔וּ עַל־מֹשֶׁ֖ה וְעַֽל־אַהֲרֹֽן׃ ");
INSERT INTO hbo_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","וַיָּ֥רֶב הָעָ֖ם עִם־מֹשֶׁ֑ה וַיֹּאמְר֣וּ לֵאמֹ֔ר וְל֥וּ גָוַ֛עְנוּ בִּגְוַ֥ע אַחֵ֖ינוּ לִפְנֵ֥י יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","וְלָמָ֤ה הֲבֵאתֶם֙ אֶת־קְהַ֣ל יְהוָ֔ה אֶל־הַמִּדְבָּ֖ר הַזֶּ֑ה לָמ֣וּת שָׁ֔ם אֲנַ֖חְנוּ וּבְעִירֵֽנוּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","וְלָמָ֤ה הֶֽעֱלִיתֻ֙נוּ֙ מִמִּצְרַ֔יִם לְהָבִ֣יא אֹתָ֔נוּ אֶל־הַמָּקֹ֥ום הָרָ֖ע הַזֶּ֑ה לֹ֣א ׀ מְקֹ֣ום זֶ֗רַע וּתְאֵנָ֤ה וְגֶ֙פֶן֙ וְרִמֹּ֔ון וּמַ֥יִם אַ֖יִן לִשְׁתֹּֽות׃ ");
INSERT INTO hbo_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","וַיָּבֹא֩ מֹשֶׁ֨ה וְאַהֲרֹ֜ן מִפְּנֵ֣י הַקָּהָ֗ל אֶל־פֶּ֙תַח֙ אֹ֣הֶל מֹועֵ֔ד וַֽיִּפְּל֖וּ עַל־פְּנֵיהֶ֑ם וַיֵּרָ֥א כְבֹוד־יְהוָ֖ה אֲלֵיהֶֽם׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","קַ֣ח אֶת־הַמַּטֶּ֗ה וְהַקְהֵ֤ל אֶת־הָעֵדָה֙ אַתָּה֙ וְאַהֲרֹ֣ן אָחִ֔יךָ וְדִבַּרְתֶּ֧ם אֶל־הַסֶּ֛לַע לְעֵינֵיהֶ֖ם וְנָתַ֣ן מֵימָ֑יו וְהֹוצֵאתָ֙ לָהֶ֥ם מַ֙יִם֙ מִן־הַסֶּ֔לַע וְהִשְׁקִיתָ֥ אֶת־הָעֵדָ֖ה וְאֶת־בְּעִירָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","וַיִּקַּ֥ח מֹשֶׁ֛ה אֶת־הַמַּטֶּ֖ה מִלִּפְנֵ֣י יְהוָ֑ה כַּאֲשֶׁ֖ר צִוָּֽהוּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","וַיַּקְהִ֜לוּ מֹשֶׁ֧ה וְאַהֲרֹ֛ן אֶת־הַקָּהָ֖ל אֶל־פְּנֵ֣י הַסָּ֑לַע וַיֹּ֣אמֶר לָהֶ֗ם שִׁמְעוּ־נָא֙ הַמֹּרִ֔ים הֲמִן־הַסֶּ֣לַע הַזֶּ֔ה נֹוצִ֥יא לָכֶ֖ם מָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","וַיָּ֨רֶם מֹשֶׁ֜ה אֶת־יָדֹ֗ו וַיַּ֧ךְ אֶת־הַסֶּ֛לַע בְּמַטֵּ֖הוּ פַּעֲמָ֑יִם וַיֵּצְאוּ֙ מַ֣יִם רַבִּ֔ים וַתֵּ֥שְׁתְּ הָעֵדָ֖ה וּבְעִירָֽם׃ ס ");
INSERT INTO hbo_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","וַיֹּ֣אמֶר יְהוָה֮ אֶל־מֹשֶׁ֣ה וְאֶֽל־אַהֲרֹן֒ יַ֚עַן לֹא־הֶאֱמַנְתֶּ֣ם בִּ֔י לְהַ֨קְדִּישֵׁ֔נִי לְעֵינֵ֖י בְּנֵ֣י יִשְׂרָאֵ֑ל לָכֵ֗ן לֹ֤א תָבִ֙יאוּ֙ אֶת־הַקָּהָ֣ל הַזֶּ֔ה אֶל־הָאָ֖רֶץ אֲשֶׁר־נָתַ֥תִּי לָהֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","הֵ֚מָּה מֵ֣י מְרִיבָ֔ה אֲשֶׁר־רָב֥וּ בְנֵֽי־יִשְׂרָאֵ֖ל אֶת־יְהוָ֑ה וַיִּקָּדֵ֖שׁ בָּֽם׃ ס ");
INSERT INTO hbo_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","וַיִּשְׁלַ֨ח מֹשֶׁ֧ה מַלְאָכִ֛ים מִקָּדֵ֖שׁ אֶל־מֶ֣לֶךְ אֱדֹ֑ום כֹּ֤ה אָמַר֙ אָחִ֣יךָ יִשְׂרָאֵ֔ל אַתָּ֣ה יָדַ֔עְתָּ אֵ֥ת כָּל־הַתְּלָאָ֖ה אֲשֶׁ֥ר מְצָאָֽתְנוּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","וַיֵּרְד֤וּ אֲבֹתֵ֙ינוּ֙ מִצְרַ֔יְמָה וַנֵּ֥שֶׁב בְּמִצְרַ֖יִם יָמִ֣ים רַבִּ֑ים וַיָּרֵ֥עוּ לָ֛נוּ מִצְרַ֖יִם וְלַאֲבֹתֵֽינוּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","וַנִּצְעַ֤ק אֶל־יְהוָה֙ וַיִּשְׁמַ֣ע קֹלֵ֔נוּ וַיִּשְׁלַ֣ח מַלְאָ֔ךְ וַיֹּצִאֵ֖נוּ מִמִּצְרָ֑יִם וְהִנֵּה֙ אֲנַ֣חְנוּ בְקָדֵ֔שׁ עִ֖יר קְצֵ֥ה גְבוּלֶֽךָ׃ ");
INSERT INTO hbo_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","נַעְבְּרָה־נָּ֣א בְאַרְצֶ֗ךָ לֹ֤א נַעֲבֹר֙ בְּשָׂדֶ֣ה וּבְכֶ֔רֶם וְלֹ֥א נִשְׁתֶּ֖ה מֵ֣י בְאֵ֑ר דֶּ֧רֶךְ הַמֶּ֣לֶךְ נֵלֵ֗ךְ לֹ֤א נִטֶּה֙ יָמִ֣ין וּשְׂמֹ֔אול עַ֥ד אֲשֶֽׁר־נַעֲבֹ֖ר גְּבוּלֶֽךָ׃ ");
INSERT INTO hbo_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","וַיֹּ֤אמֶר אֵלָיו֙ אֱדֹ֔ום לֹ֥א תַעֲבֹ֖ר בִּ֑י פֶּן־בַּחֶ֖רֶב אֵצֵ֥א לִקְרָאתֶֽךָ׃ ");
INSERT INTO hbo_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","וַיֹּאמְר֨וּ אֵלָ֥יו בְּנֵֽי־יִשְׂרָאֵל֮ בַּֽמְסִלָּ֣ה נַעֲלֶה֒ וְאִם־מֵימֶ֤יךָ נִשְׁתֶּה֙ אֲנִ֣י וּמִקְנַ֔י וְנָתַתִּ֖י מִכְרָ֑ם רַ֥ק אֵין־דָּבָ֖ר בְּרַגְלַ֥י אֶֽעֱבֹֽרָה׃ ");
INSERT INTO hbo_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","וַיֹּ֖אמֶר לֹ֣א תַעֲבֹ֑ר וַיֵּצֵ֤א אֱדֹום֙ לִקְרָאתֹ֔ו בְּעַ֥ם כָּבֵ֖ד וּבְיָ֥ד חֲזָקָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","וַיְמָאֵ֣ן ׀ אֱדֹ֗ום נְתֹן֙ אֶת־יִשְׂרָאֵ֔ל עֲבֹ֖ר בִּגְבֻלֹ֑ו וַיֵּ֥ט יִשְׂרָאֵ֖ל מֵעָלָֽיו׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","וַיִּסְע֖וּ מִקָּדֵ֑שׁ וַיָּבֹ֧אוּ בְנֵֽי־יִשְׂרָאֵ֛ל כָּל־הָעֵדָ֖ה הֹ֥ר הָהָֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","וַיֹּ֧אמֶר יְהוָ֛ה אֶל־מֹשֶׁ֥ה וְאֶֽל־אַהֲרֹ֖ן בְּהֹ֣ר הָהָ֑ר עַל־גְּב֥וּל אֶֽרֶץ־אֱדֹ֖ום לֵאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","יֵאָסֵ֤ף אַהֲרֹן֙ אֶל־עַמָּ֔יו כִּ֣י לֹ֤א יָבֹא֙ אֶל־הָאָ֔רֶץ אֲשֶׁ֥ר נָתַ֖תִּי לִבְנֵ֣י יִשְׂרָאֵ֑ל עַ֛ל אֲשֶׁר־מְרִיתֶ֥ם אֶת־פִּ֖י לְמֵ֥י מְרִיבָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","קַ֚ח אֶֽת־אַהֲרֹ֔ן וְאֶת־אֶלְעָזָ֖ר בְּנֹ֑ו וְהַ֥עַל אֹתָ֖ם הֹ֥ר הָהָֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","וְהַפְשֵׁ֤ט אֶֽת־אַהֲרֹן֙ אֶת־בְּגָדָ֔יו וְהִלְבַּשְׁתָּ֖ם אֶת־אֶלְעָזָ֣ר בְּנֹ֑ו וְאַהֲרֹ֥ן יֵאָסֵ֖ף וּמֵ֥ת שָֽׁם׃ ");
INSERT INTO hbo_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","וַיַּ֣עַשׂ מֹשֶׁ֔ה כַּאֲשֶׁ֖ר צִוָּ֣ה יְהוָ֑ה וֽ͏ַיַּעֲלוּ֙ אֶל־הֹ֣ר הָהָ֔ר לְעֵינֵ֖י כָּל־הָעֵדָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","וַיַּפְשֵׁט֩ מֹשֶׁ֨ה אֶֽת־אַהֲרֹ֜ן אֶת־בְּגָדָ֗יו וַיַּלְבֵּ֤שׁ אֹתָם֙ אֶת־אֶלְעָזָ֣ר בְּנֹ֔ו וַיָּ֧מָת אַהֲרֹ֛ן שָׁ֖ם בְּרֹ֣אשׁ הָהָ֑ר וַיֵּ֧רֶד מֹשֶׁ֛ה וְאֶלְעָזָ֖ר מִן־הָהָֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","וַיִּרְאוּ֙ כָּל־הָ֣עֵדָ֔ה כִּ֥י גָוַ֖ע אַהֲרֹ֑ן וַיִּבְכּ֤וּ אֶֽת־אַהֲרֹן֙ שְׁלֹשִׁ֣ים יֹ֔ום כֹּ֖ל בֵּ֥ית יִשְׂרָאֵֽל׃ ס ");
INSERT INTO hbo_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","וַיִּשְׁמַ֞ע הַכְּנַעֲנִ֤י מֶֽלֶךְ־עֲרָד֙ יֹשֵׁ֣ב הַנֶּ֔גֶב כִּ֚י בָּ֣א יִשְׂרָאֵ֔ל דֶּ֖רֶךְ הָאֲתָרִ֑ים וַיִּלָּ֙חֶם֙ בְּיִשְׂרָאֵ֔ל וַיִּ֥שְׁבְּ ׀ מִמֶּ֖נּוּ שֶֽׁבִי׃ ");
INSERT INTO hbo_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","וַיִּדַּ֨ר יִשְׂרָאֵ֥ל נֶ֛דֶר לַֽיהוָ֖ה וַיֹּאמַ֑ר אִם־נָתֹ֨ן תִּתֵּ֜ן אֶת־הָעָ֤ם הַזֶּה֙ בְּיָדִ֔י וְהֽ͏ַחֲרַמְתִּ֖י אֶת־עָרֵיהֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","וַיִּשְׁמַ֨ע יְהוָ֜ה בְּקֹ֣ול יִשְׂרָאֵ֗ל וַיִּתֵּן֙ אֶת־הַֽכְּנַעֲנִ֔י וַיַּחֲרֵ֥ם אֶתְהֶ֖ם וְאֶת־עָרֵיהֶ֑ם וַיִּקְרָ֥א שֵׁם־הַמָּקֹ֖ום חָרְמָֽה׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","וַיִּסְע֞וּ מֵהֹ֤ר הָהָר֙ דֶּ֣רֶךְ יַם־ס֔וּף לִסְבֹ֖ב אֶת־אֶ֣רֶץ אֱדֹ֑ום וַתִּקְצַ֥ר נֶֽפֶשׁ־הָעָ֖ם בַּדָּֽרֶךְ׃ ");
INSERT INTO hbo_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","וַיְדַבֵּ֣ר הָעָ֗ם בֵּֽאלֹהִים֮ וּבְמֹשֶׁה֒ לָמָ֤ה הֶֽעֱלִיתֻ֙נוּ֙ מִמִּצְרַ֔יִם לָמ֨וּת בַּמִּדְבָּ֑ר כִּ֣י אֵ֥ין לֶ֙חֶם֙ וְאֵ֣ין מַ֔יִם וְנַפְשֵׁ֣נוּ קָ֔צָה בַּלֶּ֖חֶם הַקְּלֹקֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","וַיְשַׁלַּ֨ח יְהוָ֜ה בָּעָ֗ם אֵ֚ת הַנְּחָשִׁ֣ים הַשְּׂרָפִ֔ים וַֽיְנַשְּׁכ֖וּ אֶת־הָעָ֑ם וַיָּ֥מָת עַם־רָ֖ב מִיִּשְׂרָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","וַיָּבֹא֩ הָעָ֨ם אֶל־מֹשֶׁ֜ה וַיֹּאמְר֣וּ חָטָ֗אנוּ כִּֽי־דִבַּ֤רְנוּ בַֽיהוָה֙ וָבָ֔ךְ הִתְפַּלֵּל֙ אֶל־יְהוָ֔ה וְיָסֵ֥ר מֵעָלֵ֖ינוּ אֶת־הַנָּחָ֑שׁ וַיִּתְפַּלֵּ֥ל מֹשֶׁ֖ה בְּעַ֥ד הָעָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","וַיֹּ֨אמֶר יְהוָ֜ה אֶל־מֹשֶׁ֗ה עֲשֵׂ֤ה לְךָ֙ שָׂרָ֔ף וְשִׂ֥ים אֹתֹ֖ו עַל־נֵ֑ס וְהָיָה֙ כָּל־הַנָּשׁ֔וּךְ וְרָאָ֥ה אֹתֹ֖ו וָחָֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","וַיַּ֤עַשׂ מֹשֶׁה֙ נְחַ֣שׁ נְחֹ֔שֶׁת וַיְשִׂמֵ֖הוּ עַל־הַנֵּ֑ס וְהָיָ֗ה אִם־נָשַׁ֤ךְ הַנָּחָשׁ֙ אֶת־אִ֔ישׁ וְהִבִּ֛יט אֶל־נְחַ֥שׁ הַנְּחֹ֖שֶׁת וָחָֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","וַיִּסְע֖וּ בְּנֵ֣י יִשְׂרָאֵ֑ל וַֽיַּחֲנ֖וּ בְּאֹבֹֽת׃ ");
INSERT INTO hbo_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","וַיִּסְע֖וּ מֵאֹבֹ֑ת וַֽיַּחֲנ֞וּ בְּעִיֵּ֣י הָֽעֲבָרִ֗ים בַּמִּדְבָּר֙ אֲשֶׁר֙ עַל־פְּנֵ֣י מֹואָ֔ב מִמִּזְרַ֖ח הַשָּֽׁמֶשׁ׃ ");
INSERT INTO hbo_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","מִשָּׁ֖ם נָסָ֑עוּ וַֽיַּחֲנ֖וּ בְּנַ֥חַל זָֽרֶד׃ ");
INSERT INTO hbo_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","מִשָּׁם֮ נָסָעוּ֒ וַֽיַּחֲנ֗וּ מֵעֵ֤בֶר אַרְנֹון֙ אֲשֶׁ֣ר בַּמִּדְבָּ֔ר הַיֹּצֵ֖א מִגְּב֣וּל הָֽאֱמֹרִ֑י כִּ֤י אַרְנֹון֙ גְּב֣וּל מֹואָ֔ב בֵּ֥ין מֹואָ֖ב וּבֵ֥ין הָאֱמֹרִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","עַל־כֵּן֙ יֵֽאָמַ֔ר בְּסֵ֖פֶר מִלְחֲמֹ֣ת יְהוָ֑ה אֶת־וָהֵ֣ב בְּסוּפָ֔ה וְאֶת־הַנְּחָלִ֖ים אַרְנֹֽון׃ ");
INSERT INTO hbo_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","וְאֶ֙שֶׁד֙ הַנְּחָלִ֔ים אֲשֶׁ֥ר נָטָ֖ה לְשֶׁ֣בֶת עָ֑ר וְנִשְׁעַ֖ן לִגְב֥וּל מֹואָֽב׃ ");
INSERT INTO hbo_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","וּמִשָּׁ֖ם בְּאֵ֑רָה הִ֣וא הַבְּאֵ֗ר אֲשֶׁ֨ר אָמַ֤ר יְהוָה֙ לְמֹשֶׁ֔ה אֱסֹף֙ אֶת־הָעָ֔ם וְאֶתְּנָ֥ה לָהֶ֖ם מָֽיִם׃ ס ");
INSERT INTO hbo_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","אָ֚ז יָשִׁ֣יר יִשְׂרָאֵ֔ל אֶת־הַשִּׁירָ֖ה הַזֹּ֑את עֲלִ֥י בְאֵ֖ר עֱנוּ־לָֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","בְּאֵ֞ר חֲפָר֣וּהָ שָׂרִ֗ים כָּר֙וּהָ֙ נְדִיבֵ֣י הָעָ֔ם בִּמְחֹקֵ֖ק בְּמִשְׁעֲנֹתָ֑ם וּמִמִּדְבָּ֖ר מַתָּנָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","וּמִמַּתָּנָ֖ה נַחֲלִיאֵ֑ל וּמִנַּחֲלִיאֵ֖ל בָּמֹֽות׃ ");
INSERT INTO hbo_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","וּמִבָּמֹ֗ות הַגַּיְא֙ אֲשֶׁר֙ בִּשְׂדֵ֣ה מֹואָ֔ב רֹ֖אשׁ הַפִּסְגָּ֑ה וְנִשְׁקָ֖פָה עַל־פְּנֵ֥י הַיְשִׁימֹֽן׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","וַיִּשְׁלַ֤ח יִשְׂרָאֵל֙ מַלְאָכִ֔ים אֶל־סִיחֹ֥ן מֶֽלֶךְ־הָאֱמֹרִ֖י לֵאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","אֶעְבְּרָ֣ה בְאַרְצֶ֗ךָ לֹ֤א נִטֶּה֙ בְּשָׂדֶ֣ה וּבְכֶ֔רֶם לֹ֥א נִשְׁתֶּ֖ה מֵ֣י בְאֵ֑ר בְּדֶ֤רֶךְ הַמֶּ֙לֶךְ֙ נֵלֵ֔ךְ עַ֥ד אֲשֶֽׁר־נַעֲבֹ֖ר גְּבֻלֶֽךָ׃ ");
INSERT INTO hbo_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","וְלֹא־נָתַ֨ן סִיחֹ֣ן אֶת־יִשְׂרָאֵל֮ עֲבֹ֣ר בִּגְבֻלֹו֒ וַיֶּאֱסֹ֨ף סִיחֹ֜ן אֶת־כָּל־עַמֹּ֗ו וַיֵּצֵ֞א לִקְרַ֤את יִשְׂרָאֵל֙ הַמִּדְבָּ֔רָה וַיָּבֹ֖א יָ֑הְצָה וַיִּלָּ֖חֶם בְּיִשְׂרָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","וַיַּכֵּ֥הוּ יִשְׂרָאֵ֖ל לְפִי־חָ֑רֶב וַיִּירַ֨שׁ אֶת־אַרְצֹ֜ו מֵֽאַרְנֹ֗ן עַד־יַבֹּק֙ עַד־בְּנֵ֣י עַמֹּ֔ון כִּ֣י עַ֔ז גְּב֖וּל בְּנֵ֥י עַמֹּֽון׃ ");
INSERT INTO hbo_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","וַיִּקַּח֙ יִשְׂרָאֵ֔ל אֵ֥ת כָּל־הֶעָרִ֖ים הָאֵ֑לֶּה וַיֵּ֤שֶׁב יִשְׂרָאֵל֙ בְּכָל־עָרֵ֣י הָֽאֱמֹרִ֔י בְּחֶשְׁבֹּ֖ון וּבְכָל־בְּנֹתֶֽיהָ׃ ");
INSERT INTO hbo_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","כִּ֣י חֶשְׁבֹּ֔ון עִ֗יר סִיחֹ֛ן מֶ֥לֶךְ הָאֱמֹרִ֖י הִ֑וא וְה֣וּא נִלְחַ֗ם בְּמֶ֤לֶךְ מֹואָב֙ הָֽרִאשֹׁ֔ון וַיִּקַּ֧ח אֶת־כָּל־אַרְצֹ֛ו מִיָּדֹ֖ו עַד־אַרְנֹֽן׃ ");
INSERT INTO hbo_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","עַל־כֵּ֛ן יֹאמְר֥וּ הַמֹּשְׁלִ֖ים בֹּ֣אוּ חֶשְׁבֹּ֑ון תִּבָּנֶ֥ה וְתִכֹּונֵ֖ן עִ֥יר סִיחֹֽון׃ ");
INSERT INTO hbo_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","כִּי־אֵשׁ֙ יָֽצְאָ֣ה מֵֽחֶשְׁבֹּ֔ון לֶהָבָ֖ה מִקִּרְיַ֣ת סִיחֹ֑ן אָֽכְלָה֙ עָ֣ר מֹואָ֔ב בַּעֲלֵ֖י בָּמֹ֥ות אַרְנֹֽן׃ ");
INSERT INTO hbo_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","אֹוי־לְךָ֣ מֹואָ֔ב אָבַ֖דְתָּ עַם־כְּמֹ֑ושׁ נָתַ֨ן בָּנָ֤יו פְּלֵיטִם֙ וּבְנֹתָ֣יו בַּשְּׁבִ֔ית לְמֶ֥לֶךְ אֱמֹרִ֖י סִיחֹֽון׃ ");
INSERT INTO hbo_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","וַנִּירָ֛ם אָבַ֥ד חֶשְׁבֹּ֖ון עַד־דִּיבֹ֑ון וַנַּשִּׁ֣ים עַד־נֹ֔פַח אֲשֶׁ֖רׄ עַד־מֵֽידְבָֽא׃ ");
INSERT INTO hbo_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","וַיֵּ֙שֶׁב֙ יִשְׂרָאֵ֔ל בְּאֶ֖רֶץ הָאֱמֹרִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","וַיִּשְׁלַ֤ח מֹשֶׁה֙ לְרַגֵּ֣ל אֶת־יַעְזֵ֔ר וַֽיִּלְכְּד֖וּ בְּנֹתֶ֑יהָ *וַיִּירֶשׁ (וַיֹּ֖ורֶשׁ) אֶת־הָאֱמֹרִ֥י אֲשֶׁר־שָֽׁם׃ ");
INSERT INTO hbo_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","וַיִּפְנוּ֙ וַֽיַּעֲל֔וּ דֶּ֖רֶךְ הַבָּשָׁ֑ן וַיֵּצֵ֣א עֹוג֩ מֶֽלֶךְ־הַבָּשָׁ֨ן לִקְרָאתָ֜ם ה֧וּא וְכָל־עַמֹּ֛ו לַמִּלְחָמָ֖ה אֶדְרֶֽעִי׃ ");
INSERT INTO hbo_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","וַיֹּ֨אמֶר יְהוָ֤ה אֶל־מֹשֶׁה֙ אַל־תִּירָ֣א אֹתֹ֔ו כִּ֣י בְיָדְךָ֞ נָתַ֧תִּי אֹתֹ֛ו וְאֶת־כָּל־עַמֹּ֖ו וְאֶת־אַרְצֹ֑ו וְעָשִׂ֣יתָ לֹּ֔ו כַּאֲשֶׁ֣ר עָשִׂ֗יתָ לְסִיחֹן֙ מֶ֣לֶךְ הָֽאֱמֹרִ֔י אֲשֶׁ֥ר יֹושֵׁ֖ב בְּחֶשְׁבֹּֽון׃ ");
INSERT INTO hbo_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","וַיַּכּ֨וּ אֹתֹ֤ו וְאֶת־בָּנָיו֙ וְאֶת־כָּל־עַמֹּ֔ו עַד־בִּלְתִּ֥י הִשְׁאִֽיר־לֹ֖ו שָׂרִ֑יד וַיִּֽירְשׁ֖וּ אֶת־אַרְצֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","וַיִּסְע֖וּ בְּנֵ֣י יִשְׂרָאֵ֑ל וַֽיַּחֲנוּ֙ בְּעַֽרְבֹ֣ות מֹואָ֔ב מֵעֵ֖בֶר לְיַרְדֵּ֥ן יְרֵחֹֽו׃ ס ");
INSERT INTO hbo_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","וַיַּ֥רְא בָּלָ֖ק בֶּן־צִפֹּ֑ור אֵ֛ת כָּל־אֲשֶׁר־עָשָׂ֥ה יִשְׂרָאֵ֖ל לָֽאֱמֹרִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","וַיָּ֨גָר מֹואָ֜ב מִפְּנֵ֥י הָעָ֛ם מְאֹ֖ד כִּ֣י רַב־ה֑וּא וַיָּ֣קָץ מֹואָ֔ב מִפְּנֵ֖י בְּנֵ֥י יִשְׂרָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","וַיֹּ֨אמֶר מֹואָ֜ב אֶל־זִקְנֵ֣י מִדְיָ֗ן עַתָּ֞ה יְלַחֲכ֤וּ הַקָּהָל֙ אֶת־כָּל־סְבִ֣יבֹתֵ֔ינוּ כִּלְחֹ֣ךְ הַשֹּׁ֔ור אֵ֖ת יֶ֣רֶק הַשָּׂדֶ֑ה וּבָלָ֧ק בֶּן־צִפֹּ֛ור מֶ֥לֶךְ לְמֹואָ֖ב בָּעֵ֥ת הַהִֽוא׃ ");
INSERT INTO hbo_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","וַיִּשְׁלַ֨ח מַלְאָכִ֜ים אֶל־בִּלְעָ֣ם בֶּן־בְּעֹ֗ור פְּ֠תֹורָה אֲשֶׁ֧ר עַל־הַנָּהָ֛ר אֶ֥רֶץ בְּנֵי־עַמֹּ֖ו לִקְרֹא־לֹ֑ו לֵאמֹ֗ר הִ֠נֵּה עַ֣ם יָצָ֤א מִמִּצְרַ֙יִם֙ הִנֵּ֤ה כִסָּה֙ אֶת־עֵ֣ין הָאָ֔רֶץ וְה֥וּא יֹשֵׁ֖ב מִמֻּלִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","וְעַתָּה֩ לְכָה־נָּ֨א אָֽרָה־לִּ֜י אֶת־הָעָ֣ם הַזֶּ֗ה כִּֽי־עָצ֥וּם הוּא֙ מִמֶּ֔נִּי אוּלַ֤י אוּכַל֙ נַכֶּה־בֹּ֔ו וַאֲגָרְשֶׁ֖נּוּ מִן־הָאָ֑רֶץ כִּ֣י יָדַ֗עְתִּי אֵ֤ת אֲשֶׁר־תְּבָרֵךְ֙ מְבֹרָ֔ךְ וַאֲשֶׁ֥ר תָּאֹ֖ר יוּאָֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","וַיֵּ֨לְכ֜וּ זִקְנֵ֤י מֹואָב֙ וְזִקְנֵ֣י מִדְיָ֔ן וּקְסָמִ֖ים בְּיָדָ֑ם וַיָּבֹ֙אוּ֙ אֶל־בִּלְעָ֔ם וַיְדַבְּר֥וּ אֵלָ֖יו דִּבְרֵ֥י בָלָֽק׃ ");
INSERT INTO hbo_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","וַיֹּ֣אמֶר אֲלֵיהֶ֗ם לִ֤ינוּ פֹה֙ הַלַּ֔יְלָה וַהֲשִׁבֹתִ֤י אֶתְכֶם֙ דָּבָ֔ר כַּאֲשֶׁ֛ר יְדַבֵּ֥ר יְהוָ֖ה אֵלָ֑י וַיֵּשְׁב֥וּ שָׂרֵֽי־מֹואָ֖ב עִם־בִּלְעָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","וַיָּבֹ֥א אֱלֹהִ֖ים אֶל־בִּלְעָ֑ם וַיֹּ֕אמֶר מִ֛י הָאֲנָשִׁ֥ים הָאֵ֖לֶּה עִמָּֽךְ׃ ");
INSERT INTO hbo_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","וַיֹּ֥אמֶר בִּלְעָ֖ם אֶל־הָאֱלֹהִ֑ים בָּלָ֧ק בֶּן־צִפֹּ֛ר מֶ֥לֶךְ מֹואָ֖ב שָׁלַ֥ח אֵלָֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","הִנֵּ֤ה הָעָם֙ הַיֹּצֵ֣א מִמִּצְרַ֔יִם וַיְכַ֖ס אֶת־עֵ֣ין הָאָ֑רֶץ עַתָּ֗ה לְכָ֤ה קָֽבָה־לִּי֙ אֹתֹ֔ו אוּלַ֥י אוּכַ֛ל לְהִלָּ֥חֶם בֹּ֖ו וְגֵרַשְׁתִּֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","וַיֹּ֤אמֶר אֱלֹהִים֙ אֶל־בִּלְעָ֔ם לֹ֥א תֵלֵ֖ךְ עִמָּהֶ֑ם לֹ֤א תָאֹר֙ אֶת־הָעָ֔ם כִּ֥י בָר֖וּךְ הֽוּא׃ ");
INSERT INTO hbo_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","וַיָּ֤קָם בִּלְעָם֙ בַּבֹּ֔קֶר וַיֹּ֙אמֶר֙ אֶל־שָׂרֵ֣י בָלָ֔ק לְכ֖וּ אֶֽל־אַרְצְכֶ֑ם כִּ֚י מֵאֵ֣ן יְהוָ֔ה לְתִתִּ֖י לַהֲלֹ֥ךְ עִמָּכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","וַיָּק֙וּמוּ֙ שָׂרֵ֣י מֹואָ֔ב וַיָּבֹ֖אוּ אֶל־בָּלָ֑ק וַיֹּ֣אמְר֔וּ מֵאֵ֥ן בִּלְעָ֖ם הֲלֹ֥ךְ עִמָּֽנוּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","וַיֹּ֥סֶף עֹ֖וד בָּלָ֑ק שְׁלֹ֣חַ שָׂרִ֔ים רַבִּ֥ים וְנִכְבָּדִ֖ים מֵאֵֽלֶּה׃ ");
INSERT INTO hbo_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","וַיָּבֹ֖אוּ אֶל־בִּלְעָ֑ם וַיֹּ֣אמְרוּ לֹ֗ו כֹּ֤ה אָמַר֙ בָּלָ֣ק בֶּן־צִפֹּ֔ור אַל־נָ֥א תִמָּנַ֖ע מֵהֲלֹ֥ךְ אֵלָֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","כִּֽי־כַבֵּ֤ד אֲכַבֶּדְךָ֙ מְאֹ֔ד וְכֹ֛ל אֲשֶׁר־תֹּאמַ֥ר אֵלַ֖י אֶֽעֱשֶׂ֑ה וּלְכָה־נָּא֙ קָֽבָה־לִּ֔י אֵ֖ת הָעָ֥ם הַזֶּֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","וַיַּ֣עַן בִּלְעָ֗ם וַיֹּ֙אמֶר֙ אֶל־עַבְדֵ֣י בָלָ֔ק אִם־יִתֶּן־לִ֥י בָלָ֛ק מְלֹ֥א בֵיתֹ֖ו כֶּ֣סֶף וְזָהָ֑ב לֹ֣א אוּכַ֗ל לַעֲבֹר֙ אֶת־פִּי֙ יְהוָ֣ה אֱלֹהָ֔י לַעֲשֹׂ֥ות קְטַנָּ֖ה אֹ֥ו גְדֹולָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","וְעַתָּ֗ה שְׁב֨וּ נָ֥א בָזֶ֛ה גַּם־אַתֶּ֖ם הַלָּ֑יְלָה וְאֵ֣דְעָ֔ה מַה־יֹּסֵ֥ף יְהוָ֖ה דַּבֵּ֥ר עִמִּֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","וַיָּבֹ֨א אֱלֹהִ֥ים ׀ אֶל־בִּלְעָם֮ לַיְלָה֒ וַיֹּ֣אמֶר לֹ֗ו אִם־לִקְרֹ֤א לְךָ֙ בָּ֣אוּ הָאֲנָשִׁ֔ים ק֖וּם לֵ֣ךְ אִתָּ֑ם וְאַ֗ךְ אֶת־הַדָּבָ֛ר אֲשֶׁר־אֲדַבֵּ֥ר אֵלֶ֖יךָ אֹתֹ֥ו תַעֲשֶֽׂה׃ ");
INSERT INTO hbo_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","וַיָּ֤קָם בִּלְעָם֙ בַּבֹּ֔קֶר וַֽיַּחֲבֹ֖שׁ אֶת־אֲתֹנֹ֑ו וַיֵּ֖לֶךְ עִם־שָׂרֵ֥י מֹואָֽב׃ ");
INSERT INTO hbo_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","וַיִּֽחַר־אַ֣ף אֱלֹהִים֮ כִּֽי־הֹולֵ֣ךְ הוּא֒ וַיִּתְיַצֵּ֞ב מַלְאַ֧ךְ יְהוָ֛ה בַּדֶּ֖רֶךְ לְשָׂטָ֣ן לֹ֑ו וְהוּא֙ רֹכֵ֣ב עַל־אֲתֹנֹ֔ו וּשְׁנֵ֥י נְעָרָ֖יו עִמֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","וַתֵּ֣רֶא הָאָתֹון֩ אֶת־מַלְאַ֨ךְ יְהוָ֜ה נִצָּ֣ב בַּדֶּ֗רֶךְ וְחַרְבֹּ֤ו שְׁלוּפָה֙ בְּיָדֹ֔ו וַתֵּ֤ט הָֽאָתֹון֙ מִן־הַדֶּ֔רֶךְ וַתֵּ֖לֶךְ בַּשָּׂדֶ֑ה וַיַּ֤ךְ בִּלְעָם֙ אֶת־הָ֣אָתֹ֔ון לְהַטֹּתָ֖הּ הַדָּֽרֶךְ׃ ");
INSERT INTO hbo_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","וַֽיַּעֲמֹד֙ מַלְאַ֣ךְ יְהוָ֔ה בְּמִשְׁעֹ֖ול הַכְּרָמִ֑ים גָּדֵ֥ר מִזֶּ֖ה וְגָדֵ֥ר מִזֶּֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","וַתֵּ֨רֶא הָאָתֹ֜ון אֶת־מַלְאַ֣ךְ יְהוָ֗ה וַתִּלָּחֵץ֙ אֶל־הַקִּ֔יר וַתִּלְחַ֛ץ אֶת־רֶ֥גֶל בִּלְעָ֖ם אֶל־הַקִּ֑יר וַיֹּ֖סֶף לְהַכֹּתָֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","וַיֹּ֥וסֶף מַלְאַךְ־יְהוָ֖ה עֲבֹ֑ור וַֽיַּעֲמֹד֙ בְּמָקֹ֣ום צָ֔ר אֲשֶׁ֛ר אֵֽין־דֶּ֥רֶךְ לִנְטֹ֖ות יָמִ֥ין וּשְׂמֹֽאול׃ ");
INSERT INTO hbo_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","וַתֵּ֤רֶא הָֽאָתֹון֙ אֶת־מַלְאַ֣ךְ יְהוָ֔ה וַתִּרְבַּ֖ץ תַּ֣חַת בִּלְעָ֑ם וַיִּֽחַר־אַ֣ף בִּלְעָ֔ם וַיַּ֥ךְ אֶת־הָאָתֹ֖ון בַּמַּקֵּֽל׃ ");
INSERT INTO hbo_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","וַיִּפְתַּ֥ח יְהוָ֖ה אֶת־פִּ֣י הָאָתֹ֑ון וַתֹּ֤אמֶר לְבִלְעָם֙ מֶה־עָשִׂ֣יתִֽי לְךָ֔ כִּ֣י הִכִּיתַ֔נִי זֶ֖ה שָׁלֹ֥שׁ רְגָלִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","וַיֹּ֤אמֶר בִּלְעָם֙ לָֽאָתֹ֔ון כִּ֥י הִתְעַלַּ֖לְתְּ בִּ֑י ל֤וּ יֶשׁ־חֶ֙רֶב֙ בְּיָדִ֔י כִּ֥י עַתָּ֖ה הֲרַגְתִּֽיךְ׃ ");
INSERT INTO hbo_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","וַתֹּ֨אמֶר הָאָתֹ֜ון אֶל־בִּלְעָ֗ם הֲלֹוא֩ אָנֹכִ֨י אֲתֹֽנְךָ֜ אֲשֶׁר־רָכַ֣בְתָּ עָלַ֗י מֵעֹֽודְךָ֙ עַד־הַיֹּ֣ום הַזֶּ֔ה הַֽהַסְכֵּ֣ן הִסְכַּ֔נְתִּי לַעֲשֹׂ֥ות לְךָ֖ כֹּ֑ה וַיֹּ֖אמֶר לֹֽא׃ ");
INSERT INTO hbo_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","וַיְגַ֣ל יְהוָה֮ אֶת־עֵינֵ֣י בִלְעָם֒ וַיַּ֞רְא אֶת־מַלְאַ֤ךְ יְהוָה֙ נִצָּ֣ב בַּדֶּ֔רֶךְ וְחַרְבֹּ֥ו שְׁלֻפָ֖ה בְּיָדֹ֑ו וַיִּקֹּ֥ד וַיִּשְׁתַּ֖חוּ לְאַפָּֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","וַיֹּ֤אמֶר אֵלָיו֙ מַלְאַ֣ךְ יְהוָ֔ה עַל־מָ֗ה הִכִּ֙יתָ֙ אֶת־אֲתֹ֣נְךָ֔ זֶ֖ה שָׁלֹ֣ושׁ רְגָלִ֑ים הִנֵּ֤ה אָנֹכִי֙ יָצָ֣אתִי לְשָׂטָ֔ן כִּֽי־יָרַ֥ט הַדֶּ֖רֶךְ לְנֶגְדִּֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","וַתִּרְאַ֙נִי֙ הָֽאָתֹ֔ון וַתֵּ֣ט לְפָנַ֔י זֶ֖ה שָׁלֹ֣שׁ רְגָלִ֑ים אוּלַי֙ נָטְתָ֣ה מִפָּנַ֔י כִּ֥י עַתָּ֛ה גַּם־אֹתְכָ֥ה הָרַ֖גְתִּי וְאֹותָ֥הּ הֶחֱיֵֽיתִי׃ ");
INSERT INTO hbo_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","וַיֹּ֨אמֶר בִּלְעָ֜ם אֶל־מַלְאַ֤ךְ יְהוָה֙ חָטָ֔אתִי כִּ֚י לֹ֣א יָדַ֔עְתִּי כִּ֥י אַתָּ֛ה נִצָּ֥ב לִקְרָאתִ֖י בַּדָּ֑רֶךְ וְעַתָּ֛ה אִם־רַ֥ע בְּעֵינֶ֖יךָ אָשׁ֥וּבָה לִּֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","וַיֹּאמֶר֩ מַלְאַ֨ךְ יְהוָ֜ה אֶל־בִּלְעָ֗ם לֵ֚ךְ עִם־הָ֣אֲנָשִׁ֔ים וְאֶ֗פֶס אֶת־הַדָּבָ֛ר אֲשֶׁר־אֲדַבֵּ֥ר אֵלֶ֖יךָ אֹתֹ֣ו תְדַבֵּ֑ר וַיֵּ֥לֶךְ בִּלְעָ֖ם עִם־שָׂרֵ֥י בָלָֽק׃ ");
INSERT INTO hbo_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","וַיִּשְׁמַ֥ע בָּלָ֖ק כִּ֣י בָ֣א בִלְעָ֑ם וַיֵּצֵ֨א לִקְרָאתֹ֜ו אֶל־עִ֣יר מֹואָ֗ב אֲשֶׁר֙ עַל־גְּב֣וּל אַרְנֹ֔ן אֲשֶׁ֖ר בִּקְצֵ֥ה הַגְּבֽוּל׃ ");
INSERT INTO hbo_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","וַיֹּ֨אמֶר בָּלָ֜ק אֶל־בִּלְעָ֗ם הֲלֹא֩ שָׁלֹ֨חַ שָׁלַ֤חְתִּי אֵלֶ֙יךָ֙ לִקְרֹא־לָ֔ךְ לָ֥מָּה לֹא־הָלַ֖כְתָּ אֵלָ֑י הַֽאֻמְנָ֔ם לֹ֥א אוּכַ֖ל כַּבְּדֶֽךָ׃ ");
INSERT INTO hbo_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","וַיֹּ֨אמֶר בִּלְעָ֜ם אֶל־בָּלָ֗ק הִֽנֵּה־בָ֙אתִי֙ אֵלֶ֔יךָ עַתָּ֕ה הֲיָכֹ֥ול אוּכַ֖ל דַּבֵּ֣ר מְא֑וּמָה הַדָּבָ֗ר אֲשֶׁ֨ר יָשִׂ֧ים אֱלֹהִ֛ים בְּפִ֖י אֹתֹ֥ו אֲדַבֵּֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","וַיֵּ֥לֶךְ בִּלְעָ֖ם עִם־בָּלָ֑ק וַיָּבֹ֖אוּ קִרְיַ֥ת חֻצֹֽות׃ ");
INSERT INTO hbo_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","וַיִּזְבַּ֥ח בָּלָ֖ק בָּקָ֣ר וָצֹ֑אן וַיְשַׁלַּ֣ח לְבִלְעָ֔ם וְלַשָּׂרִ֖ים אֲשֶׁ֥ר אִתֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","וַיְהִ֣י בַבֹּ֔קֶר וַיִּקַּ֤ח בָּלָק֙ אֶת־בִּלְעָ֔ם וַֽיַּעֲלֵ֖הוּ בָּמֹ֣ות בָּ֑עַל וַיַּ֥רְא מִשָּׁ֖ם קְצֵ֥ה הָעָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","וַיֹּ֤אמֶר בִּלְעָם֙ אֶל־בָּלָ֔ק בְּנֵה־לִ֥י בָזֶ֖ה שִׁבְעָ֣ה מִזְבְּחֹ֑ת וְהָכֵ֥ן לִי֙ בָּזֶ֔ה שִׁבְעָ֥ה פָרִ֖ים וְשִׁבְעָ֥ה אֵילִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","וַיַּ֣עַשׂ בָּלָ֔ק כַּאֲשֶׁ֖ר דִּבֶּ֣ר בִּלְעָ֑ם וַיַּ֨עַל בָּלָ֧ק וּבִלְעָ֛ם פָּ֥ר וָאַ֖יִל בַּמִּזְבֵּֽחַ׃ ");
INSERT INTO hbo_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","וַיֹּ֨אמֶר בִּלְעָ֜ם לְבָלָ֗ק הִתְיַצֵּב֮ עַל־עֹלָתֶךָ֒ וְאֵֽלְכָ֗ה אוּלַ֞י יִקָּרֵ֤ה יְהוָה֙ לִקְרָאתִ֔י וּדְבַ֥ר מַה־יַּרְאֵ֖נִי וְהִגַּ֣דְתִּי לָ֑ךְ וַיֵּ֖לֶךְ שֶֽׁפִי׃ ");
INSERT INTO hbo_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","וַיִּקָּ֥ר אֱלֹהִ֖ים אֶל־בִּלְעָ֑ם וַיֹּ֣אמֶר אֵלָ֗יו אֶת־שִׁבְעַ֤ת הַֽמִּזְבְּחֹת֙ עָרַ֔כְתִּי וָאַ֛עַל פָּ֥ר וָאַ֖יִל בַּמִּזְבֵּֽחַ׃ ");
INSERT INTO hbo_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","וַיָּ֧שֶׂם יְהוָ֛ה דָּבָ֖ר בְּפִ֣י בִלְעָ֑ם וַיֹּ֛אמֶר שׁ֥וּב אֶל־בָּלָ֖ק וְכֹ֥ה תְדַבֵּֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","וַיָּ֣שָׁב אֵלָ֔יו וְהִנֵּ֥ה נִצָּ֖ב עַל־עֹלָתֹ֑ו ה֖וּא וְכָל־שָׂרֵ֥י מֹואָֽב׃ ");
INSERT INTO hbo_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","וַיִּשָּׂ֥א מְשָׁלֹ֖ו וַיֹּאמַ֑ר מִן־אֲ֠רָם יַנְחֵ֨נִי בָלָ֤ק מֶֽלֶךְ־מֹואָב֙ מֵֽהַרְרֵי־קֶ֔דֶם לְכָה֙ אָֽרָה־לִּ֣י יַעֲקֹ֔ב וּלְכָ֖ה זֹעֲמָ֥ה יִשְׂרָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","מָ֣ה אֶקֹּ֔ב לֹ֥א קַבֹּ֖ה אֵ֑ל וּמָ֣ה אֶזְעֹ֔ם לֹ֥א זָעַ֖ם יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","כִּֽי־מֵרֹ֤אשׁ צֻרִים֙ אֶרְאֶ֔נּוּ וּמִגְּבָעֹ֖ות אֲשׁוּרֶ֑נּוּ הֶן־עָם֙ לְבָדָ֣ד יִשְׁכֹּ֔ן וּבַגֹּויִ֖ם לֹ֥א יִתְחַשָּֽׁב׃ ");
INSERT INTO hbo_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","מִ֤י מָנָה֙ עֲפַ֣ר יַעֲקֹ֔ב וּמִסְפָּ֖ר אֶת־רֹ֣בַע יִשְׂרָאֵ֑ל תָּמֹ֤ת נַפְשִׁי֙ מֹ֣ות יְשָׁרִ֔ים וּתְהִ֥י אַחֲרִיתִ֖י כָּמֹֽהוּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","וַיֹּ֤אמֶר בָּלָק֙ אֶל־בִּלְעָ֔ם מֶ֥ה עָשִׂ֖יתָ לִ֑י לָקֹ֤ב אֹיְבַי֙ לְקַחְתִּ֔יךָ וְהִנֵּ֖ה בֵּרַ֥כְתָּ בָרֵֽךְ׃ ");
INSERT INTO hbo_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","וַיַּ֖עַן וַיֹּאמַ֑ר הֲלֹ֗א אֵת֩ אֲשֶׁ֨ר יָשִׂ֤ים יְהוָה֙ בְּפִ֔י אֹתֹ֥ו אֶשְׁמֹ֖ר לְדַבֵּֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","וַיֹּ֨אמֶר אֵלָ֜יו בָּלָ֗ק *לְךָ־ (לְכָה)־נָּ֨א אִתִּ֜י אֶל־מָקֹ֤ום אַחֵר֙ אֲשֶׁ֣ר תִּרְאֶ֣נּוּ מִשָּׁ֔ם אֶ֚פֶס קָצֵ֣הוּ תִרְאֶ֔ה וְכֻלֹּ֖ו לֹ֣א תִרְאֶ֑ה וְקָבְנֹו־לִ֖י מִשָּֽׁם׃ ");
INSERT INTO hbo_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","וַיִּקָּחֵ֙הוּ֙ שְׂדֵ֣ה צֹפִ֔ים אֶל־רֹ֖אשׁ הַפִּסְגָּ֑ה וַיִּ֙בֶן֙ שִׁבְעָ֣ה מִזְבְּחֹ֔ת וַיַּ֛עַל פָּ֥ר וָאַ֖יִל בַּמִּזְבֵּֽחַ׃ ");
INSERT INTO hbo_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","וַיֹּ֙אמֶר֙ אֶל־בָּלָ֔ק הִתְיַצֵּ֥ב כֹּ֖ה עַל־עֹלָתֶ֑ךָ וְאָנֹכִ֖י אִקָּ֥רֶה כֹּֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","וַיִּקָּ֤ר יְהוָה֙ אֶל־בִּלְעָ֔ם וַיָּ֥שֶׂם דָּבָ֖ר בְּפִ֑יו וַיֹּ֛אמֶר שׁ֥וּב אֶל־בָּלָ֖ק וְכֹ֥ה תְדַבֵּֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","וַיָּבֹ֣א אֵלָ֗יו וְהִנֹּ֤ו נִצָּב֙ עַל־עֹ֣לָתֹ֔ו וְשָׂרֵ֥י מֹואָ֖ב אִתֹּ֑ו וַיֹּ֤אמֶר לֹו֙ בָּלָ֔ק מַה־דִּבֶּ֖ר יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","וַיִּשָּׂ֥א מְשָׁלֹ֖ו וַיֹּאמַ֑ר ק֤וּם בָּלָק֙ וּֽשֲׁמָ֔ע הַאֲזִ֥ינָה עָדַ֖י בְּנֹ֥ו צִפֹּֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","לֹ֣א אִ֥ישׁ אֵל֙ וִֽיכַזֵּ֔ב וּבֶן־אָדָ֖ם וְיִתְנֶחָ֑ם הַה֤וּא אָמַר֙ וְלֹ֣א יַעֲשֶׂ֔ה וְדִבֶּ֖ר וְלֹ֥א יְקִימֶֽנָּה׃ ");
INSERT INTO hbo_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","הִנֵּ֥ה בָרֵ֖ךְ לָקָ֑חְתִּי וּבֵרֵ֖ךְ וְלֹ֥א אֲשִׁיבֶֽנָּה׃ ");
INSERT INTO hbo_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","לֹֽא־הִבִּ֥יט אָ֙וֶן֙ בְּיַעֲקֹ֔ב וְלֹא־רָאָ֥ה עָמָ֖ל בְּיִשְׂרָאֵ֑ל יְהוָ֤ה אֱלֹהָיו֙ עִמֹּ֔ו וּתְרוּעַ֥ת מֶ֖לֶךְ בֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","אֵ֖ל מֹוצִיאָ֣ם מִמִּצְרָ֑יִם כְּתֹועֲפֹ֥ת רְאֵ֖ם לֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","כִּ֤י לֹא־נַ֙חַשׁ֙ בְּיַעֲקֹ֔ב וְלֹא־קֶ֖סֶם בְּיִשְׂרָאֵ֑ל כָּעֵ֗ת יֵאָמֵ֤ר לְיַעֲקֹב֙ וּלְיִשְׂרָאֵ֔ל מַה־פָּ֖עַל אֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","הֶן־עָם֙ כְּלָבִ֣יא יָק֔וּם וְכַאֲרִ֖י יִתְנַשָּׂ֑א לֹ֤א יִשְׁכַּב֙ עַד־יֹ֣אכַל טֶ֔רֶף וְדַם־חֲלָלִ֖ים יִשְׁתֶּֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","וַיֹּ֤אמֶר בָּלָק֙ אֶל־בִּלְעָ֔ם גַּם־קֹ֖ב לֹ֣א תִקֳּבֶ֑נּוּ גַּם־בָּרֵ֖ךְ לֹ֥א תְבָרֲכֶֽנּוּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","וַיַּ֣עַן בִּלְעָ֔ם וַיֹּ֖אמֶר אֶל־בָּלָ֑ק הֲלֹ֗א דִּבַּ֤רְתִּי אֵלֶ֙יךָ֙ לֵאמֹ֔ר כֹּ֛ל אֲשֶׁר־יְדַבֵּ֥ר יְהוָ֖ה אֹתֹ֥ו אֽ͏ֶעֱשֶֽׂה׃ ");
INSERT INTO hbo_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","וַיֹּ֤אמֶר בָּלָק֙ אֶל־בִּלְעָ֔ם לְכָה־נָּא֙ אֶקָּ֣חֲךָ֔ אֶל־מָקֹ֖ום אַחֵ֑ר אוּלַ֤י יִישַׁר֙ בְּעֵינֵ֣י הָאֱלֹהִ֔ים וְקַבֹּ֥תֹו לִ֖י מִשָּֽׁם׃ ");
INSERT INTO hbo_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","וַיִּקַּ֥ח בָּלָ֖ק אֶת־בִּלְעָ֑ם רֹ֣אשׁ הַפְּעֹ֔ור הַנִּשְׁקָ֖ף עַל־פְּנֵ֥י הַיְשִׁימֹֽן׃ ");
INSERT INTO hbo_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","וַיֹּ֤אמֶר בִּלְעָם֙ אֶל־בָּלָ֔ק בְּנֵה־לִ֥י בָזֶ֖ה שִׁבְעָ֣ה מִזְבְּחֹ֑ת וְהָכֵ֥ן לִי֙ בָּזֶ֔ה שִׁבְעָ֥ה פָרִ֖ים וְשִׁבְעָ֥ה אֵילִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","וַיַּ֣עַשׂ בָּלָ֔ק כַּאֲשֶׁ֖ר אָמַ֣ר בִּלְעָ֑ם וַיַּ֛עַל פָּ֥ר וָאַ֖יִל בַּמִּזְבֵּֽחַ׃ ");
INSERT INTO hbo_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","וַיַּ֣רְא בִּלְעָ֗ם כִּ֣י טֹ֞וב בְּעֵינֵ֤י יְהוָה֙ לְבָרֵ֣ךְ אֶת־יִשְׂרָאֵ֔ל וְלֹא־הָלַ֥ךְ כְּפַֽעַם־בְּפַ֖עַם לִקְרַ֣את נְחָשִׁ֑ים וַיָּ֥שֶׁת אֶל־הַמִּדְבָּ֖ר פָּנָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","וַיִּשָּׂ֨א בִלְעָ֜ם אֶת־עֵינָ֗יו וַיַּרְא֙ אֶת־יִשְׂרָאֵ֔ל שֹׁכֵ֖ן לִשְׁבָטָ֑יו וַתְּהִ֥י עָלָ֖יו ר֥וּחַ אֱלֹהִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","וַיִּשָּׂ֥א מְשָׁלֹ֖ו וַיֹּאמַ֑ר נְאֻ֤ם בִּלְעָם֙ בְּנֹ֣ו בְעֹ֔ר וּנְאֻ֥ם הַגֶּ֖בֶר שְׁתֻ֥ם הָעָֽיִן׃ ");
INSERT INTO hbo_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","נְאֻ֕ם שֹׁמֵ֖עַ אִמְרֵי־אֵ֑ל אֲשֶׁ֨ר מַחֲזֵ֤ה שַׁדַּי֙ יֶֽחֱזֶ֔ה נֹפֵ֖ל וּגְל֥וּי עֵינָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","מַה־טֹּ֥בוּ אֹהָלֶ֖יךָ יַעֲקֹ֑ב מִשְׁכְּנֹתֶ֖יךָ יִשְׂרָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","כִּנְחָלִ֣ים נִטָּ֔יוּ כְּגַנֹּ֖ת עֲלֵ֣י נָהָ֑ר כַּאֲהָלִים֙ נָטַ֣ע יְהוָ֔ה כַּאֲרָזִ֖ים עֲלֵי־מָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","יִֽזַּל־מַ֙יִם֙ מִדָּ֣לְיָ֔ו וְזַרְעֹ֖ו בְּמַ֣יִם רַבִּ֑ים וְיָרֹ֤ם מֵֽאֲגַג֙ מַלְכֹּ֔ו וְתִנַּשֵּׂ֖א מַלְכֻתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","אֵ֚ל מֹוצִיאֹ֣ו מִמִּצְרַ֔יִם כְּתֹועֲפֹ֥ת רְאֵ֖ם לֹ֑ו יֹאכַ֞ל גֹּויִ֣ם צָרָ֗יו וְעַצְמֹתֵיהֶ֛ם יְגָרֵ֖ם וְחִצָּ֥יו יִמְחָֽץ׃ ");
INSERT INTO hbo_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","כָּרַ֨ע שָׁכַ֧ב כַּאֲרִ֛י וּכְלָבִ֖יא מִ֣י יְקִימֶ֑נּוּ מְבָרֲכֶ֣יךָ בָר֔וּךְ וְאֹרְרֶ֖יךָ אָרֽוּר׃ ");
INSERT INTO hbo_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","וַיִּֽחַר־אַ֤ף בָּלָק֙ אֶל־בִּלְעָ֔ם וַיִּסְפֹּ֖ק אֶת־כַּפָּ֑יו וַיֹּ֨אמֶר בָּלָ֜ק אֶל־בִּלְעָ֗ם לָקֹ֤ב אֹֽיְבַי֙ קְרָאתִ֔יךָ וְהִנֵּה֙ בֵּרַ֣כְתָּ בָרֵ֔ךְ זֶ֖ה שָׁלֹ֥שׁ פְּעָמִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","וְעַתָּ֖ה בְּרַח־לְךָ֣ אֶל־מְקֹומֶ֑ךָ אָמַ֙רְתִּי֙ כַּבֵּ֣ד אֲכַבֶּדְךָ֔ וְהִנֵּ֛ה מְנָעֲךָ֥ יְהוָ֖ה מִכָּבֹֽוד׃ ");
INSERT INTO hbo_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","וַיֹּ֥אמֶר בִּלְעָ֖ם אֶל־בָּלָ֑ק הֲלֹ֗א גַּ֧ם אֶל־מַלְאָכֶ֛יךָ אֲשֶׁר־שָׁלַ֥חְתָּ אֵלַ֖י דִּבַּ֥רְתִּי לֵאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","אִם־יִתֶּן־לִ֨י בָלָ֜ק מְלֹ֣א בֵיתֹו֮ כֶּ֣סֶף וְזָהָב֒ לֹ֣א אוּכַ֗ל לַעֲבֹר֙ אֶת־פִּ֣י יְהוָ֔ה לַעֲשֹׂ֥ות טֹובָ֛ה אֹ֥ו רָעָ֖ה מִלִּבִּ֑י אֲשֶׁר־יְדַבֵּ֥ר יְהוָ֖ה אֹתֹ֥ו אֲדַבֵּֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","וְעַתָּ֕ה הִנְנִ֥י הֹולֵ֖ךְ לְעַמִּ֑י לְכָה֙ אִיעָ֣צְךָ֔ אֲשֶׁ֨ר יַעֲשֶׂ֜ה הָעָ֥ם הַזֶּ֛ה לְעַמְּךָ֖ בְּאַחֲרִ֥ית הַיָּמִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","וַיִּשָּׂ֥א מְשָׁלֹ֖ו וַיֹּאמַ֑ר נְאֻ֤ם בִּלְעָם֙ בְּנֹ֣ו בְעֹ֔ר וּנְאֻ֥ם הַגֶּ֖בֶר שְׁתֻ֥ם הָעָֽיִן׃ ");
INSERT INTO hbo_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","נְאֻ֗ם שֹׁמֵ֙עַ֙ אִמְרֵי־אֵ֔ל וְיֹדֵ֖עַ דַּ֣עַת עֶלְיֹ֑ון מַחֲזֵ֤ה שַׁדַּי֙ יֽ͏ֶחֱזֶ֔ה נֹפֵ֖ל וּגְל֥וּי עֵינָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","אֶרְאֶ֙נּוּ֙ וְלֹ֣א עַתָּ֔ה אֲשׁוּרֶ֖נּוּ וְלֹ֣א קָרֹ֑וב דָּרַ֨ךְ כֹּוכָ֜ב מִֽיַּעֲקֹ֗ב וְקָ֥ם שֵׁ֙בֶט֙ מִיִּשְׂרָאֵ֔ל וּמָחַץ֙ פַּאֲתֵ֣י מֹואָ֔ב וְקַרְקַ֖ר כָּל־בְּנֵי־שֵֽׁת׃ ");
INSERT INTO hbo_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","וְהָיָ֨ה אֱדֹ֜ום יְרֵשָׁ֗ה וְהָיָ֧ה יְרֵשָׁ֛ה שֵׂעִ֖יר אֹיְבָ֑יו וְיִשְׂרָאֵ֖ל עֹ֥שֶׂה חָֽיִל׃ ");
INSERT INTO hbo_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","וְיֵ֖רְדְּ מִֽיַּעֲקֹ֑ב וְהֽ͏ֶאֱבִ֥יד שָׂרִ֖יד מֵעִֽיר׃ ");
INSERT INTO hbo_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","וַיַּרְא֙ אֶת־עֲמָלֵ֔ק וַיִּשָּׂ֥א מְשָׁלֹ֖ו וַיֹּאמַ֑ר רֵאשִׁ֤ית גֹּויִם֙ עֲמָלֵ֔ק וְאַחֲרִיתֹ֖ו עֲדֵ֥י אֹבֵֽד׃ ");
INSERT INTO hbo_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","וַיַּרְא֙ אֶת־הַקֵּינִ֔י וַיִּשָּׂ֥א מְשָׁלֹ֖ו וַיֹּאמַ֑ר אֵיתָן֙ מֹֽושָׁבֶ֔ךָ וְשִׂ֥ים בַּסֶּ֖לַע קִנֶּֽךָ׃ ");
INSERT INTO hbo_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","כִּ֥י אִם־יִהְיֶ֖ה לְבָ֣עֵֽר קָ֑יִן עַד־מָ֖ה אַשּׁ֥וּר תִּשְׁבֶּֽךָּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","וַיִּשָּׂ֥א מְשָׁלֹ֖ו וַיֹּאמַ֑ר אֹ֕וי מִ֥י יִחְיֶ֖ה מִשֻּׂמֹ֥ו אֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","וְצִים֙ מִיַּ֣ד כִּתִּ֔ים וְעִנּ֥וּ אַשּׁ֖וּר וְעִנּוּ־עֵ֑בֶר וְגַם־ה֖וּא עֲדֵ֥י אֹבֵֽד׃ ");
INSERT INTO hbo_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","וַיָּ֣קָם בִּלְעָ֔ם וַיֵּ֖לֶךְ וַיָּ֣שָׁב לִמְקֹמֹ֑ו וְגַם־בָּלָ֖ק הָלַ֥ךְ לְדַרְכֹּֽו׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","וַיֵּ֥שֶׁב יִשְׂרָאֵ֖ל בַּשִּׁטִּ֑ים וַיָּ֣חֶל הָעָ֔ם לִזְנֹ֖ות אֶל־בְּנֹ֥ות מֹואָֽב׃ ");
INSERT INTO hbo_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","וַתִּקְרֶ֣אןָ לָעָ֔ם לְזִבְחֵ֖י אֱלֹהֵיהֶ֑ן וַיֹּ֣אכַל הָעָ֔ם וַיִּֽשְׁתַּחֲוּ֖וּ לֵֽאלֹהֵיהֶֽן׃ ");
INSERT INTO hbo_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","וַיִּצָּ֥מֶד יִשְׂרָאֵ֖ל לְבַ֣עַל פְּעֹ֑ור וַיִּֽחַר־אַ֥ף יְהוָ֖ה בְּיִשְׂרָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","וַיֹּ֨אמֶר יְהוָ֜ה אֶל־מֹשֶׁ֗ה קַ֚ח אֶת־כָּל־רָאשֵׁ֣י הָעָ֔ם וְהֹוקַ֥ע אֹותָ֛ם לַיהוָ֖ה נֶ֣גֶד הַשָּׁ֑מֶשׁ וְיָשֹׁ֛ב חֲרֹ֥ון אַף־יְהוָ֖ה מִיִּשְׂרָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","וַיֹּ֣אמֶר מֹשֶׁ֔ה אֶל־שֹׁפְטֵ֖י יִשְׂרָאֵ֑ל הִרְגוּ֙ אִ֣ישׁ אֲנָשָׁ֔יו הַנִּצְמָדִ֖ים לְבַ֥עַל פְּעֹֽור׃ ");
INSERT INTO hbo_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","וְהִנֵּ֡ה אִישׁ֩ מִבְּנֵ֨י יִשְׂרָאֵ֜ל בָּ֗א וַיַּקְרֵ֤ב אֶל־אֶחָיו֙ אֶת־הַמִּדְיָנִ֔ית לְעֵינֵ֣י מֹשֶׁ֔ה וּלְעֵינֵ֖י כָּל־עֲדַ֣ת בְּנֵי־יִשְׂרָאֵ֑ל וְהֵ֣מָּה בֹכִ֔ים פֶּ֖תַח אֹ֥הֶל מֹועֵֽד׃ ");
INSERT INTO hbo_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","וַיַּ֗רְא פִּֽינְחָס֙ בֶּן־אֶלְעָזָ֔ר בֶּֽן־אַהֲרֹ֖ן הַכֹּהֵ֑ן וַיָּ֙קָם֙ מִתֹּ֣וךְ הָֽעֵדָ֔ה וַיִּקַּ֥ח רֹ֖מַח בְּיָדֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","וַ֠יָּבֹא אַחַ֨ר אִֽישׁ־יִשְׂרָאֵ֜ל אֶל־הַקֻּבָּ֗ה וַיִּדְקֹר֙ אֶת־שְׁנֵיהֶ֔ם אֵ֚ת אִ֣ישׁ יִשְׂרָאֵ֔ל וְאֶת־הָאִשָּׁ֖ה אֶל־קֳבָתָ֑הּ וַתֵּֽעָצַר֙ הַמַּגֵּפָ֔ה מֵעַ֖ל בְּנֵ֥י יִשְׂרָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","וַיִּהְי֕וּ הַמֵּתִ֖ים בַּמַּגֵּפָ֑ה אַרְבָּעָ֥ה וְעֶשְׂרִ֖ים אָֽלֶף׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","פִּֽינְחָ֨ס בֶּן־אֶלְעָזָ֜ר בֶּן־אַהֲרֹ֣ן הַכֹּהֵ֗ן הֵשִׁ֤יב אֶת־חֲמָתִי֙ מֵעַ֣ל בְּנֵֽי־יִשְׂרָאֵ֔ל בְּקַנְאֹ֥ו אֶת־קִנְאָתִ֖י בְּתֹוכָ֑ם וְלֹא־כִלִּ֥יתִי אֶת־בְּנֵֽי־יִשְׂרָאֵ֖ל בְּקִנְאָתִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","לָכֵ֖ן אֱמֹ֑ר הִנְנִ֨י נֹתֵ֥ן לֹ֛ו אֶת־בְּרִיתִ֖י שָׁלֹֽום׃ ");
INSERT INTO hbo_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","וְהָ֤יְתָה לֹּו֙ וּלְזַרְעֹ֣ו אַחֲרָ֔יו בְּרִ֖ית כְּהֻנַּ֣ת עֹולָ֑ם תַּ֗חַת אֲשֶׁ֤ר קִנֵּא֙ לֵֽאלֹהָ֔יו וַיְכַפֵּ֖ר עַל־בְּנֵ֥י יִשְׂרָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","וְשֵׁם֩ אִ֨ישׁ יִשְׂרָאֵ֜ל הַמֻּכֶּ֗ה אֲשֶׁ֤ר הֻכָּה֙ אֶת־הַמִּדְיָנִ֔ית זִמְרִ֖י בֶּן־סָל֑וּא נְשִׂ֥יא בֵֽית־אָ֖ב לַשִּׁמְעֹנִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","וְשֵׁ֨ם הָֽאִשָּׁ֧ה הַמֻּכָּ֛ה הַמִּדְיָנִ֖ית כָּזְבִּ֣י בַת־צ֑וּר רֹ֣אשׁ אֻמֹּ֥ות בֵּֽית־אָ֛ב בְּמִדְיָ֖ן הֽוּא׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","צָרֹ֖ור אֶת־הַמִּדְיָנִ֑ים וְהִכִּיתֶ֖ם אֹותָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","כִּ֣י צֹרְרִ֥ים הֵם֙ לָכֶ֔ם בְּנִכְלֵיהֶ֛ם אֲשֶׁר־נִכְּל֥וּ לָכֶ֖ם עַל־דְּבַר־פְּעֹ֑ור וְעַל־דְּבַ֞ר כָּזְבִּ֨י בַת־נְשִׂ֤יא מִדְיָן֙ אֲחֹתָ֔ם הַמֻּכָּ֥ה בְיֹום־הַמַּגֵּפָ֖ה עַל־דְּבַר־פְּעֹֽור׃ ");
INSERT INTO hbo_vpl VALUES ("NU25_19","005_25_19","NUM","25","19","19","וַיְהִ֖י אַחֲרֵ֣י הַמַּגֵּפָ֑ה פ ");
INSERT INTO hbo_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","וַיֹּ֤אמֶר יְהוָה֙ אֶל־מֹשֶׁ֔ה וְאֶ֧ל אֶלְעָזָ֛ר בֶּן־אַהֲרֹ֥ן הַכֹּהֵ֖ן לֵאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","שְׂא֞וּ אֶת־רֹ֣אשׁ ׀ כָּל־עֲדַ֣ת בְּנֵי־יִשְׂרָאֵ֗ל מִבֶּ֨ן עֶשְׂרִ֥ים שָׁנָ֛ה וָמַ֖עְלָה לְבֵ֣ית אֲבֹתָ֑ם כָּל־יֹצֵ֥א צָבָ֖א בְּיִשְׂרָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","וַיְדַבֵּ֨ר מֹשֶׁ֜ה וְאֶלְעָזָ֧ר הַכֹּהֵ֛ן אֹתָ֖ם בְּעַֽרְבֹ֣ת מֹואָ֑ב עַל־יַרְדֵּ֥ן יְרֵחֹ֖ו לֵאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","מִבֶּ֛ן עֶשְׂרִ֥ים שָׁנָ֖ה וָמָ֑עְלָה כַּאֲשֶׁר֩ צִוָּ֨ה יְהוָ֤ה אֶת־מֹשֶׁה֙ וּבְנֵ֣י יִשְׂרָאֵ֔ל הַיֹּצְאִ֖ים מֵאֶ֥רֶץ מִצְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","רְאוּבֵ֖ן בְּכֹ֣ור יִשְׂרָאֵ֑ל בְּנֵ֣י רְאוּבֵ֗ן חֲנֹוךְ֙ מִשְׁפַּ֣חַת הַחֲנֹכִ֔י לְפַלּ֕וּא מִשְׁפַּ֖חַת הַפַּלֻּאִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","לְחֶצְרֹ֕ן מִשְׁפַּ֖חַת הַֽחֶצְרֹונִ֑י לְכַרְמִ֕י מִשְׁפַּ֖חַת הַכַּרְמִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","אֵ֖לֶּה מִשְׁפְּחֹ֣ת הָרֻֽאוּבֵנִ֑י וַיִּהְי֣וּ פְקֻדֵיהֶ֗ם שְׁלֹשָׁ֤ה וְאַרְבָּעִים֙ אֶ֔לֶף וּשְׁבַ֥ע מֵאֹ֖ות וּשְׁלֹשִֽׁים׃ ");
INSERT INTO hbo_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","וּבְנֵ֥י פַלּ֖וּא אֱלִיאָֽב׃ ");
INSERT INTO hbo_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","וּבְנֵ֣י אֱלִיאָ֔ב נְמוּאֵ֖ל וְדָתָ֣ן וַאֲבִירָ֑ם הֽוּא־דָתָ֨ן וַאֲבִירָ֜ם *קְרוּאֵי (קְרִיאֵ֣י) הָעֵדָ֗ה אֲשֶׁ֨ר הִצּ֜וּ עַל־מֹשֶׁ֤ה וְעַֽל־אַהֲרֹן֙ בַּעֲדַת־קֹ֔רַח בְּהַצֹּתָ֖ם עַל־יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","וַתִּפְתַּ֨ח הָאָ֜רֶץ אֶת־פִּ֗יהָ וַתִּבְלַ֥ע אֹתָ֛ם וְאֶת־קֹ֖רַח בְּמֹ֣ות הָעֵדָ֑ה בַּאֲכֹ֣ל הָאֵ֗שׁ אֵ֣ת חֲמִשִּׁ֤ים וּמָאתַ֙יִם֙ אִ֔ישׁ וַיִּהְי֖וּ לְנֵֽס׃ ");
INSERT INTO hbo_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","וּבְנֵי־קֹ֖רַח לֹא־מֵֽתוּ׃ ס ");
INSERT INTO hbo_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","בְּנֵ֣י שִׁמְעֹון֮ לְמִשְׁפְּחֹתָם֒ לִנְמוּאֵ֗ל מִשְׁפַּ֙חַת֙ הַנְּמ֣וּאֵלִ֔י לְיָמִ֕ין מִשְׁפַּ֖חַת הַיָּמִינִ֑י לְיָכִ֕ין מִשְׁפַּ֖חַת הַיָּכִינִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","לְזֶ֕רַח מִשְׁפַּ֖חַת הַזַּרְחִ֑י לְשָׁא֕וּל מִשְׁפַּ֖חַת הַשָּׁאוּלִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","אֵ֖לֶּה מִשְׁפְּחֹ֣ת הַשִּׁמְעֹנִ֑י שְׁנַ֧יִם וְעֶשְׂרִ֛ים אֶ֖לֶף וּמָאתָֽיִם׃ ס ");
INSERT INTO hbo_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","בְּנֵ֣י גָד֮ לְמִשְׁפְּחֹתָם֒ לִצְפֹ֗ון מִשְׁפַּ֙חַת֙ הַצְּפֹונִ֔י לְחַגִּ֕י מִשְׁפַּ֖חַת הַֽחַגִּ֑י לְשׁוּנִ֕י מִשְׁפַּ֖חַת הַשּׁוּנִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","לְאָזְנִ֕י מִשְׁפַּ֖חַת הָאָזְנִ֑י לְעֵרִ֕י מִשְׁפַּ֖חַת הָעֵרִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","לַאֲרֹ֕וד מִשְׁפַּ֖חַת הָאֲרֹודִ֑י לְאַ֨רְאֵלִ֔י מִשְׁפַּ֖חַת הָאַרְאֵלִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","אֵ֛לֶּה מִשְׁפְּחֹ֥ת בְּנֵֽי־גָ֖ד לִפְקֻדֵיהֶ֑ם אַרְבָּעִ֥ים אֶ֖לֶף וַחֲמֵ֥שׁ מֵאֹֽות׃ ס ");
INSERT INTO hbo_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","בְּנֵ֥י יְהוּדָ֖ה עֵ֣ר וְאֹונָ֑ן וַיָּ֥מָת עֵ֛ר וְאֹונָ֖ן בְּאֶ֥רֶץ כְּנָֽעַן׃ ");
INSERT INTO hbo_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","וַיִּהְי֣וּ בְנֵי־יְהוּדָה֮ לְמִשְׁפְּחֹתָם֒ לְשֵׁלָ֗ה מִשְׁפַּ֙חַת֙ הַשֵּׁ֣לָנִ֔י לְפֶ֕רֶץ מִשְׁפַּ֖חַת הַפַּרְצִ֑י לְזֶ֕רַח מִשְׁפַּ֖חַת הַזַּרְחִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","וַיִּהְי֣וּ בְנֵי־פֶ֔רֶץ לְחֶצְרֹ֕ן מִשְׁפַּ֖חַת הַֽחֶצְרֹנִ֑י לְחָמ֕וּל מִשְׁפַּ֖חַת הֶחָמוּלִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","אֵ֛לֶּה מִשְׁפְּחֹ֥ת יְהוּדָ֖ה לִפְקֻדֵיהֶ֑ם שִׁשָּׁ֧ה וְשִׁבְעִ֛ים אֶ֖לֶף וַחֲמֵ֥שׁ מֵאֹֽות׃ ס ");
INSERT INTO hbo_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","בְּנֵ֤י יִשָּׂשכָר֙ לְמִשְׁפְּחֹתָ֔ם תֹּולָ֕ע מִשְׁפַּ֖חַת הַתֹּולָעִ֑י לְפֻוָ֕ה מִשְׁפַּ֖חַת הַפּוּנִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","לְיָשׁ֕וּב מִשְׁפַּ֖חַת הַיָּשׁוּבִ֑י לְשִׁמְרֹ֕ן מִשְׁפַּ֖חַת הַשִּׁמְרֹנִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","אֵ֛לֶּה מִשְׁפְּחֹ֥ת יִשָּׂשכָ֖ר לִפְקֻדֵיהֶ֑ם אַרְבָּעָ֧ה וְשִׁשִּׁ֛ים אֶ֖לֶף וּשְׁלֹ֥שׁ מֵאֹֽות׃ ס ");
INSERT INTO hbo_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","בְּנֵ֣י זְבוּלֻן֮ לְמִשְׁפְּחֹתָם֒ לְסֶ֗רֶד מִשְׁפַּ֙חַת֙ הַסַּרְדִּ֔י לְאֵלֹ֕ון מִשְׁפַּ֖חַת הָאֵלֹנִ֑י לְיַ֨חְלְאֵ֔ל מִשְׁפַּ֖חַת הַיַּחְלְאֵלִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","אֵ֛לֶּה מִשְׁפְּחֹ֥ת הַזְּבוּלֹנִ֖י לִפְקֻדֵיהֶ֑ם שִׁשִּׁ֥ים אֶ֖לֶף וַחֲמֵ֥שׁ מֵאֹֽות׃ ס ");
INSERT INTO hbo_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","בְּנֵ֥י יֹוסֵ֖ף לְמִשְׁפְּחֹתָ֑ם מְנַשֶּׁ֖ה וְאֶפְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","בְּנֵ֣י מְנַשֶּׁ֗ה לְמָכִיר֙ מִשְׁפַּ֣חַת הַמָּכִירִ֔י וּמָכִ֖יר הֹולִ֣יד אֶת־גִּלְעָ֑ד לְגִלְעָ֕ד מִשְׁפַּ֖חַת הַגִּלְעָדִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","אֵ֚לֶּה בְּנֵ֣י גִלְעָ֔ד אִיעֶ֕זֶר מִשְׁפַּ֖חַת הָאִֽיעֶזְרִ֑י לְחֵ֕לֶק מִשְׁפַּ֖חַת הַֽחֶלְקִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","וְאַ֨שְׂרִיאֵ֔ל מִשְׁפַּ֖חַת הָֽאַשְׂרִֽאֵלִ֑י וְשֶׁ֕כֶם מִשְׁפַּ֖חַת הַשִּׁכְמִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","וּשְׁמִידָ֕ע מִשְׁפַּ֖חַת הַשְּׁמִידָעִ֑י וְחֵ֕פֶר מִשְׁפַּ֖חַת הַֽחֶפְרִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","וּצְלָפְחָ֣ד בֶּן־חֵ֗פֶר לֹא־הָ֥יוּ לֹ֛ו בָּנִ֖ים כִּ֣י אִם־בָּנֹ֑ות וְשֵׁם֙ בְּנֹ֣ות צְלָפְחָ֔ד מַחְלָ֣ה וְנֹעָ֔ה חָגְלָ֥ה מִלְכָּ֖ה וְתִרְצָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","אֵ֖לֶּה מִשְׁפְּחֹ֣ת מְנַשֶּׁ֑ה וּפְקֻ֣דֵיהֶ֔ם שְׁנַ֧יִם וַחֲמִשִּׁ֛ים אֶ֖לֶף וּשְׁבַ֥ע מֵאֹֽות׃ ס ");
INSERT INTO hbo_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","אֵ֣לֶּה בְנֵי־אֶפְרַיִם֮ לְמִשְׁפְּחֹתָם֒ לְשׁוּתֶ֗לַח מִשְׁפַּ֙חַת֙ הַשֻּׁ֣תַלְחִ֔י לְבֶ֕כֶר מִשְׁפַּ֖חַת הַבַּכְרִ֑י לְתַ֕חַן מִשְׁפַּ֖חַת הַֽתַּחֲנִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","וְאֵ֖לֶּה בְּנֵ֣י שׁוּתָ֑לַח לְעֵרָ֕ן מִשְׁפַּ֖חַת הָעֵרָנִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","אֵ֣לֶּה מִשְׁפְּחֹ֤ת בְּנֵי־אֶפְרַ֙יִם֙ לִפְקֻ֣דֵיהֶ֔ם שְׁנַ֧יִם וּשְׁלֹשִׁ֛ים אֶ֖לֶף וַחֲמֵ֣שׁ מֵאֹ֑ות אֵ֥לֶּה בְנֵי־יֹוסֵ֖ף לְמִשְׁפְּחֹתָֽם׃ ס ");
INSERT INTO hbo_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","בְּנֵ֣י בִנְיָמִן֮ לְמִשְׁפְּחֹתָם֒ לְבֶ֗לַע מִשְׁפַּ֙חַת֙ הַבַּלְעִ֔י לְאַשְׁבֵּ֕ל מִשְׁפַּ֖חַת הָֽאַשְׁבֵּלִ֑י לַאֲחִירָ֕ם מִשְׁפַּ֖חַת הָאֲחִירָמִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","לִשְׁפוּפָ֕ם מִשְׁפַּ֖חַת הַשּׁוּפָמִ֑י לְחוּפָ֕ם מִשְׁפַּ֖חַת הַחוּפָמִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","וַיִּהְי֥וּ בְנֵי־בֶ֖לַע אַ֣רְדְּ וְנַעֲמָ֑ן מִשְׁפַּ֙חַת֙ הָֽאַרְדִּ֔י לְנַֽעֲמָ֔ן מִשְׁפַּ֖חַת הַֽנַּעֲמִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","אֵ֥לֶּה בְנֵי־בִנְיָמִ֖ן לְמִשְׁפְּחֹתָ֑ם וּפְקֻ֣דֵיהֶ֔ם חֲמִשָּׁ֧ה וְאַרְבָּעִ֛ים אֶ֖לֶף וְשֵׁ֥שׁ מֵאֹֽות׃ ס ");
INSERT INTO hbo_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","אֵ֤לֶּה בְנֵי־דָן֙ לְמִשְׁפְּחֹתָ֔ם לְשׁוּחָ֕ם מִשְׁפַּ֖חַת הַשּׁוּחָמִ֑י אֵ֛לֶּה מִשְׁפְּחֹ֥ת דָּ֖ן לְמִשְׁפְּחֹתָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","כָּל־מִשְׁפְּחֹ֥ת הַשּׁוּחָמִ֖י לִפְקֻדֵיהֶ֑ם אַרְבָּעָ֧ה וְשִׁשִּׁ֛ים אֶ֖לֶף וְאַרְבַּ֥ע מֵאֹֽות׃ ס ");
INSERT INTO hbo_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","בְּנֵ֣י אָשֵׁר֮ לְמִשְׁפְּחֹתָם֒ לְיִמְנָ֗ה מִשְׁפַּ֙חַת֙ הַיִּמְנָ֔ה לְיִשְׁוִ֕י מִשְׁפַּ֖חַת הַיִּשְׁוִ֑י לִבְרִיעָ֕ה מִשְׁפַּ֖חַת הַבְּרִיעִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","לִבְנֵ֣י בְרִיעָ֔ה לְחֶ֕בֶר מִשְׁפַּ֖חַת הַֽחֶבְרִ֑י לְמַ֨לְכִּיאֵ֔ל מִשְׁפַּ֖חַת הַמַּלְכִּיאֵלִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","וְשֵׁ֥ם בַּת־אָשֵׁ֖ר שָֽׂרַח׃ ");
INSERT INTO hbo_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","אֵ֛לֶּה מִשְׁפְּחֹ֥ת בְּנֵי־אָשֵׁ֖ר לִפְקֻדֵיהֶ֑ם שְׁלֹשָׁ֧ה וַחֲמִשִּׁ֛ים אֶ֖לֶף וְאַרְבַּ֥ע מֵאֹֽות׃ ס ");
INSERT INTO hbo_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","בְּנֵ֤י נַפְתָּלִי֙ לְמִשְׁפְּחֹתָ֔ם לְיַ֨חְצְאֵ֔ל מִשְׁפַּ֖חַת הַיַּחְצְאֵלִ֑י לְגוּנִ֕י מִשְׁפַּ֖חַת הַגּוּנִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","לְיֵ֕צֶר מִשְׁפַּ֖חַת הַיִּצְרִ֑י לְשִׁלֵּ֕ם מִשְׁפַּ֖חַת הַשִּׁלֵּמִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","אֵ֛לֶּה מִשְׁפְּחֹ֥ת נַפְתָּלִ֖י לְמִשְׁפְּחֹתָ֑ם וּפְקֻ֣דֵיהֶ֔ם חֲמִשָּׁ֧ה וְאַרְבָּעִ֛ים אֶ֖לֶף וְאַרְבַּ֥ע מֵאֹֽות׃ ");
INSERT INTO hbo_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","אֵ֗לֶּה פְּקוּדֵי֙ בְּנֵ֣י יִשְׂרָאֵ֔ל שֵׁשׁ־מֵאֹ֥ות אֶ֖לֶף וָאָ֑לֶף שְׁבַ֥ע מֵאֹ֖ות וּשְׁלֹשִֽׁים׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","לָאֵ֗לֶּה תֵּחָלֵ֥ק הָאָ֛רֶץ בְּנַחֲלָ֖ה בְּמִסְפַּ֥ר שֵׁמֹֽות׃ ");
INSERT INTO hbo_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","לָרַ֗ב תַּרְבֶּה֙ נַחֲלָתֹ֔ו וְלַמְעַ֕ט תַּמְעִ֖יט נַחֲלָתֹ֑ו אִ֚ישׁ לְפִ֣י פְקֻדָ֔יו יֻתַּ֖ן נַחֲלָתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","אַךְ־בְּגֹורָ֕ל יֵחָלֵ֖ק אֶת־הָאָ֑רֶץ לִשְׁמֹ֥ות מַטֹּות־אֲבֹתָ֖ם יִנְחָֽלוּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","עַל־פִּי֙ הַגֹּורָ֔ל תֵּחָלֵ֖ק נַחֲלָתֹ֑ו בֵּ֥ין רַ֖ב לִמְעָֽט׃ ס ");
INSERT INTO hbo_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","וְאֵ֨לֶּה פְקוּדֵ֣י הַלֵּוִי֮ לְמִשְׁפְּחֹתָם֒ לְגֵרְשֹׁ֗ון מִשְׁפַּ֙חַת֙ הַגֵּ֣רְשֻׁנִּ֔י לִקְהָ֕ת מִשְׁפַּ֖חַת הַקְּהָתִ֑י לִמְרָרִ֕י מִשְׁפַּ֖חַת הַמְּרָרִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","אֵ֣לֶּה ׀ מִשְׁפְּחֹ֣ת לֵוִ֗י מִשְׁפַּ֨חַת הַלִּבְנִ֜י מִשְׁפַּ֤חַת הַֽחֶבְרֹנִי֙ מִשְׁפַּ֤חַת הַמַּחְלִי֙ מִשְׁפַּ֣חַת הַמּוּשִׁ֔י מִשְׁפַּ֖חַת הַקָּרְחִ֑י וּקְהָ֖ת הֹולִ֥ד אֶת־עַמְרָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","וְשֵׁ֣ם ׀ אֵ֣שֶׁת עַמְרָ֗ם יֹוכֶ֙בֶד֙ בַּת־לֵוִ֔י אֲשֶׁ֨ר יָלְדָ֥ה אֹתָ֛הּ לְלֵוִ֖י בְּמִצְרָ֑יִם וַתֵּ֣לֶד לְעַמְרָ֗ם אֶֽת־אַהֲרֹן֙ וְאֶת־מֹשֶׁ֔ה וְאֵ֖ת מִרְיָ֥ם אֲחֹתָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","וַיִּוָּלֵ֣ד לְאַהֲרֹ֔ן אֶת־נָדָ֖ב וְאֶת־אֲבִיה֑וּא אֶת־אֶלְעָזָ֖ר וְאֶת־אִיתָמָֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","וַיָּ֥מָת נָדָ֖ב וַאֲבִיה֑וּא בְּהַקְרִיבָ֥ם אֵשׁ־זָרָ֖ה לִפְנֵ֥י יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","וַיִּהְי֣וּ פְקֻדֵיהֶ֗ם שְׁלֹשָׁ֤ה וְעֶשְׂרִים֙ אֶ֔לֶף כָּל־זָכָ֖ר מִבֶּן־חֹ֣דֶשׁ וָמָ֑עְלָה כִּ֣י ׀ לֹ֣א הָתְפָּקְד֗וּ בְּתֹוךְ֙ בְּנֵ֣י יִשְׂרָאֵ֔ל כִּ֠י לֹא־נִתַּ֤ן לָהֶם֙ נַחֲלָ֔ה בְּתֹ֖וךְ בְּנֵ֥י יִשְׂרָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","אֵ֚לֶּה פְּקוּדֵ֣י מֹשֶׁ֔ה וְאֶלְעָזָ֖ר הַכֹּהֵ֑ן אֲשֶׁ֨ר פּֽ͏ָקְד֜וּ אֶת־בְּנֵ֤י יִשְׂרָאֵל֙ בְּעַֽרְבֹ֣ת מֹואָ֔ב עַ֖ל יַרְדֵּ֥ן יְרֵחֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","וּבְאֵ֙לֶּה֙ לֹא־הָ֣יָה אִ֔ישׁ מִפְּקוּדֵ֣י מֹשֶׁ֔ה וְאַהֲרֹ֖ן הַכֹּהֵ֑ן אֲשֶׁ֥ר פָּקְד֛וּ אֶת־בְּנֵ֥י יִשְׂרָאֵ֖ל בְּמִדְבַּ֥ר סִינָֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","כִּֽי־אָמַ֤ר יְהוָה֙ לָהֶ֔ם מֹ֥ות יָמֻ֖תוּ בַּמִּדְבָּ֑ר וְלֹא־נֹותַ֤ר מֵהֶם֙ אִ֔ישׁ כִּ֚י אִם־כָּלֵ֣ב בֶּן־יְפֻנֶּ֔ה וִיהֹושֻׁ֖עַ בִּן־נֽוּן׃ ס ");
INSERT INTO hbo_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","וַתִּקְרַ֜בְנָה בְּנֹ֣ות צְלָפְחָ֗ד בֶּן־חֵ֤פֶר בֶּן־גִּלְעָד֙ בֶּן־מָכִ֣יר בֶּן־מְנַשֶּׁ֔ה לְמִשְׁפְּחֹ֖ת מְנַשֶּׁ֣ה בֶן־יֹוסֵ֑ף וְאֵ֙לֶּה֙ שְׁמֹ֣ות בְּנֹתָ֔יו מַחְלָ֣ה נֹעָ֔ה וְחָגְלָ֥ה וּמִלְכָּ֖ה וְתִרְצָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","וַֽתַּעֲמֹ֜דְנָה לִפְנֵ֣י מֹשֶׁ֗ה וְלִפְנֵי֙ אֶלְעָזָ֣ר הַכֹּהֵ֔ן וְלִפְנֵ֥י הַנְּשִׂיאִ֖ם וְכָל־הָעֵדָ֑ה פֶּ֥תַח אֹֽהֶל־מֹועֵ֖ד לֵאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","אָבִינוּ֮ מֵ֣ת בַּמִּדְבָּר֒ וְה֨וּא לֹא־הָיָ֜ה בְּתֹ֣וךְ הָעֵדָ֗ה הַנֹּועָדִ֛ים עַל־יְהוָ֖ה בַּעֲדַת־קֹ֑רַח כִּֽי־בְחֶטְאֹ֣ו מֵ֔ת וּבָנִ֖ים לֹא־הָ֥יוּ לֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","לָ֣מָּה יִגָּרַ֤ע שֵׁם־אָבִ֙ינוּ֙ מִתֹּ֣וךְ מִשְׁפַּחְתֹּ֔ו כִּ֛י אֵ֥ין לֹ֖ו בֵּ֑ן תְּנָה־לָּ֣נוּ אֲחֻזָּ֔ה בְּתֹ֖וךְ אֲחֵ֥י אָבִֽינוּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","וַיַּקְרֵ֥ב מֹשֶׁ֛ה אֶת־מִשְׁפָּטָ֖ן לִפְנֵ֥י יְהוָֽה׃ ס ");
INSERT INTO hbo_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","וַיֹּ֥אמֶר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","כֵּ֗ן בְּנֹ֣ות צְלָפְחָד֮ דֹּבְרֹת֒ נָתֹ֨ן תִּתֵּ֤ן לָהֶם֙ אֲחֻזַּ֣ת נַחֲלָ֔ה בְּתֹ֖וךְ אֲחֵ֣י אֲבִיהֶ֑ם וְהַֽעֲבַרְתָּ֛ אֶת־נַחֲלַ֥ת אֲבִיהֶ֖ן לָהֶֽן׃ ");
INSERT INTO hbo_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","וְאֶל־בְּנֵ֥י יִשְׂרָאֵ֖ל תְּדַבֵּ֣ר לֵאמֹ֑ר אִ֣ישׁ כִּֽי־יָמ֗וּת וּבֵן֙ אֵ֣ין לֹ֔ו וְהַֽעֲבַרְתֶּ֥ם אֶת־נַחֲלָתֹ֖ו לְבִתֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","וְאִם־אֵ֥ין לֹ֖ו בַּ֑ת וּנְתַתֶּ֥ם אֶת־נַחֲלָתֹ֖ו לְאֶחָיו׃ ");
INSERT INTO hbo_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","וְאִם־אֵ֥ין לֹ֖ו אַחִ֑ים וּנְתַתֶּ֥ם אֶת־נַחֲלָתֹ֖ו לַאֲחֵ֥י אָבִֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","וְאִם־אֵ֣ין אַחִים֮ לְאָבִיו֒ וּנְתַתֶּ֣ם אֶת־נַחֲלָתֹ֗ו לִשְׁאֵרֹ֞ו הַקָּרֹ֥ב אֵלָ֛יו מִמִּשְׁפַּחְתֹּ֖ו וְיָרַ֣שׁ אֹתָ֑הּ וְֽהָ֨יְתָ֜ה לִבְנֵ֤י יִשְׂרָאֵל֙ לְחֻקַּ֣ת מִשְׁפָּ֔ט כַּאֲשֶׁ֛ר צִוָּ֥ה יְהוָ֖ה אֶת־מֹשֶֽׁה׃ ס ");
INSERT INTO hbo_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","וַיֹּ֤אמֶר יְהוָה֙ אֶל־מֹשֶׁ֔ה עֲלֵ֛ה אֶל־הַ֥ר הָעֲבָרִ֖ים הַזֶּ֑ה וּרְאֵה֙ אֶת־הָאָ֔רֶץ אֲשֶׁ֥ר נָתַ֖תִּי לִבְנֵ֥י יִשְׂרָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","וְרָאִ֣יתָה אֹתָ֔הּ וְנֶאֱסַפְתָּ֥ אֶל־עַמֶּ֖יךָ גַּם־אָ֑תָּה כַּאֲשֶׁ֥ר נֶאֱסַ֖ף אַהֲרֹ֥ן אָחִֽיךָ׃ ");
INSERT INTO hbo_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","כַּאֲשֶׁר֩ מְרִיתֶ֨ם פִּ֜י בְּמִדְבַּר־צִ֗ן בִּמְרִיבַת֙ הֽ͏ָעֵדָ֔ה לְהַקְדִּישֵׁ֥נִי בַמַּ֖יִם לְעֵינֵיהֶ֑ם הֵ֛ם מֵֽי־מְרִיבַ֥ת קָדֵ֖שׁ מִדְבַּר־צִֽן׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","וַיְדַבֵּ֣ר מֹשֶׁ֔ה אֶל־יְהוָ֖ה לֵאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","יִפְקֹ֣ד יְהוָ֔ה אֱלֹהֵ֥י הָרוּחֹ֖ת לְכָל־בָּשָׂ֑ר אִ֖ישׁ עַל־הָעֵדָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","אֲשֶׁר־יֵצֵ֣א לִפְנֵיהֶ֗ם וַאֲשֶׁ֤ר יָבֹא֙ לִפְנֵיהֶ֔ם וַאֲשֶׁ֥ר יֹוצִיאֵ֖ם וַאֲשֶׁ֣ר יְבִיאֵ֑ם וְלֹ֤א תִהְיֶה֙ עֲדַ֣ת יְהוָ֔ה כַּצֹּ֕אן אֲשֶׁ֥ר אֵין־לָהֶ֖ם רֹעֶֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","וַיֹּ֨אמֶר יְהוָ֜ה אֶל־מֹשֶׁ֗ה קַח־לְךָ֙ אֶת־יְהֹושֻׁ֣עַ בִּן־נ֔וּן אִ֖ישׁ אֲשֶׁר־ר֣וּחַ בֹּ֑ו וְסָמַכְתָּ֥ אֶת־יָדְךָ֖ עָלָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","וְהֽ͏ַעֲמַדְתָּ֣ אֹתֹ֗ו לִפְנֵי֙ אֶלְעָזָ֣ר הַכֹּהֵ֔ן וְלִפְנֵ֖י כָּל־הָעֵדָ֑ה וְצִוִּיתָ֥ה אֹתֹ֖ו לְעֵינֵיהֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","וְנָתַתָּ֥ה מֵהֹֽודְךָ֖ עָלָ֑יו לְמַ֣עַן יִשְׁמְע֔וּ כָּל־עֲדַ֖ת בְּנֵ֥י יִשְׂרָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","וְלִפְנֵ֨י אֶלְעָזָ֤ר הַכֹּהֵן֙ יַעֲמֹ֔ד וְשָׁ֥אַל לֹ֛ו בְּמִשְׁפַּ֥ט הָאוּרִ֖ים לִפְנֵ֣י יְהוָ֑ה עַל־פִּ֨יו יֵצְא֜וּ וְעַל־פִּ֣יו יָבֹ֗אוּ ה֛וּא וְכָל־בְּנֵי־יִשְׂרָאֵ֥ל אִתֹּ֖ו וְכָל־הָעֵדָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","וַיַּ֣עַשׂ מֹשֶׁ֔ה כַּאֲשֶׁ֛ר צִוָּ֥ה יְהוָ֖ה אֹתֹ֑ו וַיִּקַּ֣ח אֶת־יְהֹושֻׁ֗עַ וַיַּֽעֲמִדֵ֙הוּ֙ לִפְנֵי֙ אֶלְעָזָ֣ר הַכֹּהֵ֔ן וְלִפְנֵ֖י כָּל־הָעֵדָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","וַיִּסְמֹ֧ךְ אֶת־יָדָ֛יו עָלָ֖יו וַיְצַוֵּ֑הוּ כַּאֲשֶׁ֛ר דִּבֶּ֥ר יְהוָ֖ה בְּיַד־מֹשֶֽׁה׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","צַ֚ו אֶת־בְּנֵ֣י יִשְׂרָאֵ֔ל וְאָמַרְתָּ֖ אֲלֵהֶ֑ם אֶת־קָרְבָּנִ֨י לַחְמִ֜י לְאִשַּׁ֗י רֵ֚יחַ נִֽיחֹחִ֔י תִּשְׁמְר֕וּ לְהַקְרִ֥יב לִ֖י בְּמֹועֲדֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","וְאָמַרְתָּ֣ לָהֶ֔ם זֶ֚ה הָֽאִשֶּׁ֔ה אֲשֶׁ֥ר תַּקְרִ֖יבוּ לַיהוָ֑ה כְּבָשִׂ֨ים בְּנֵֽי־שָׁנָ֧ה תְמִימִ֛ם שְׁנַ֥יִם לַיֹּ֖ום עֹלָ֥ה תָמִֽיד׃ ");
INSERT INTO hbo_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","אֶת־הַכֶּ֥בֶשׂ אֶחָ֖ד תַּעֲשֶׂ֣ה בַבֹּ֑קֶר וְאֵת֙ הַכֶּ֣בֶשׂ הַשֵּׁנִ֔י תַּעֲשֶׂ֖ה בֵּ֥ין הָֽעַרְבָּֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","וַעֲשִׂירִ֧ית הָאֵיפָ֛ה סֹ֖לֶת לְמִנְחָ֑ה בְּלוּלָ֛ה בְּשֶׁ֥מֶן כָּתִ֖ית רְבִיעִ֥ת הַהִֽין׃ ");
INSERT INTO hbo_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","עֹלַ֖ת תָּמִ֑יד הָעֲשֻׂיָה֙ בְּהַ֣ר סִינַ֔י לְרֵ֣יחַ נִיחֹ֔חַ אִשֶּׁ֖ה לַֽיהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","וְנִסְכֹּו֙ רְבִיעִ֣ת הַהִ֔ין לַכֶּ֖בֶשׂ הָאֶחָ֑ד בַּקֹּ֗דֶשׁ הַסֵּ֛ךְ נֶ֥סֶךְ שֵׁכָ֖ר לַיהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","וְאֵת֙ הַכֶּ֣בֶשׂ הַשֵּׁנִ֔י תַּעֲשֶׂ֖ה בֵּ֣ין הָֽעַרְבָּ֑יִם כְּמִנְחַ֨ת הַבֹּ֤קֶר וּכְנִסְכֹּו֙ תַּעֲשֶׂ֔ה אִשֵּׁ֛ה רֵ֥יחַ נִיחֹ֖חַ לַיהוָֽה׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","וּבְיֹום֙ הַשַּׁבָּ֔ת שְׁנֵֽי־כְבָשִׂ֥ים בְּנֵֽי־שָׁנָ֖ה תְּמִימִ֑ם וּשְׁנֵ֣י עֶשְׂרֹנִ֗ים סֹ֧לֶת מִנְחָ֛ה בְּלוּלָ֥ה בַשֶּׁ֖מֶן וְנִסְכֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","עֹלַ֥ת שַׁבַּ֖ת בְּשַׁבַּתֹּ֑ו עַל־עֹלַ֥ת הַתָּמִ֖יד וְנִסְכָּֽהּ׃ ס ");
INSERT INTO hbo_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","וּבְרָאשֵׁי֙ חָדְשֵׁיכֶ֔ם תַּקְרִ֥יבוּ עֹלָ֖ה לַיהוָ֑ה פָּרִ֨ים בְּנֵֽי־בָקָ֤ר שְׁנַ֙יִם֙ וְאַ֣יִל אֶחָ֔ד כְּבָשִׂ֧ים בְּנֵי־שָׁנָ֛ה שִׁבְעָ֖ה תְּמִימִֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","וּשְׁלֹשָׁ֣ה עֶשְׂרֹנִ֗ים סֹ֤לֶת מִנְחָה֙ בְּלוּלָ֣ה בַשֶּׁ֔מֶן לַפָּ֖ר הָאֶחָ֑ד וּשְׁנֵ֣י עֶשְׂרֹנִ֗ים סֹ֤לֶת מִנְחָה֙ בְּלוּלָ֣ה בַשֶּׁ֔מֶן לָאַ֖יִל הָֽאֶחָֽד׃ ");
INSERT INTO hbo_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","וְעִשָּׂרֹ֣ן עִשָּׂרֹ֗ון סֹ֤לֶת מִנְחָה֙ בְּלוּלָ֣ה בַשֶּׁ֔מֶן לַכֶּ֖בֶשׂ הָאֶחָ֑ד עֹלָה֙ רֵ֣יחַ נִיחֹ֔חַ אִשֶּׁ֖ה לַיהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","וְנִסְכֵּיהֶ֗ם חֲצִ֣י הַהִין֩ יִהְיֶ֨ה לַפָּ֜ר וּשְׁלִישִׁ֧ת הַהִ֣ין לָאַ֗יִל וּרְבִיעִ֥ת הַהִ֛ין לַכֶּ֖בֶשׂ יָ֑יִן זֹ֣את עֹלַ֥ת חֹ֙דֶשׁ֙ בְּחָדְשֹׁ֔ו לְחָדְשֵׁ֖י הַשָּׁנָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","וּשְׂעִ֨יר עִזִּ֥ים אֶחָ֛ד לְחַטָּ֖את לַיהוָ֑ה עַל־עֹלַ֧ת הַתָּמִ֛יד יֵעָשֶׂ֖ה וְנִסְכֹּֽו׃ ס ");
INSERT INTO hbo_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","וּבַחֹ֣דֶשׁ הָרִאשֹׁ֗ון בְּאַרְבָּעָ֥ה עָשָׂ֛ר יֹ֖ום לַחֹ֑דֶשׁ פֶּ֖סַח לַיהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","וּבַחֲמִשָּׁ֨ה עָשָׂ֥ר יֹ֛ום לַחֹ֥דֶשׁ הַזֶּ֖ה חָ֑ג שִׁבְעַ֣ת יָמִ֔ים מַצֹּ֖ות יֵאָכֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","בַּיֹּ֥ום הָרִאשֹׁ֖ון מִקְרָא־קֹ֑דֶשׁ כָּל־מְלֶ֥אכֶת עֲבֹדָ֖ה לֹ֥א תַעֲשֽׂוּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","וְהִקְרַבְתֶּ֨ם אִשֶּׁ֤ה עֹלָה֙ לַֽיהוָ֔ה פָּרִ֧ים בְּנֵי־בָקָ֛ר שְׁנַ֖יִם וְאַ֣יִל אֶחָ֑ד וְשִׁבְעָ֤ה כְבָשִׂים֙ בְּנֵ֣י שָׁנָ֔ה תְּמִימִ֖ם יִהְי֥וּ לָכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","וּמִ֨נְחָתָ֔ם סֹ֖לֶת בְּלוּלָ֣ה בַשָּׁ֑מֶן שְׁלֹשָׁ֨ה עֶשְׂרֹנִ֜ים לַפָּ֗ר וּשְׁנֵ֧י עֶשְׂרֹנִ֛ים לָאַ֖יִל תַּעֲשֽׂוּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","עִשָּׂרֹ֤ון עִשָּׂרֹון֙ תַּעֲשֶׂ֔ה לַכֶּ֖בֶשׂ הָאֶחָ֑ד לְשִׁבְעַ֖ת הַכְּבָשִֽׂים׃ ");
INSERT INTO hbo_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","וּשְׂעִ֥יר חַטָּ֖את אֶחָ֑ד לְכַפֵּ֖ר עֲלֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","מִלְּבַד֙ עֹלַ֣ת הַבֹּ֔קֶר אֲשֶׁ֖ר לְעֹלַ֣ת הַתָּמִ֑יד תַּעֲשׂ֖וּ אֶת־אֵֽלֶּה׃ ");
INSERT INTO hbo_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","כָּאֵ֜לֶּה תַּעֲשׂ֤וּ לַיֹּום֙ שִׁבְעַ֣ת יָמִ֔ים לֶ֛חֶם אִשֵּׁ֥ה רֵֽיחַ־נִיחֹ֖חַ לַיהוָ֑ה עַל־עֹולַ֧ת הַתָּמִ֛יד יֵעָשֶׂ֖ה וְנִסְכֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","וּבַיֹּום֙ הַשְּׁבִיעִ֔י מִקְרָא־קֹ֖דֶשׁ יִהְיֶ֣ה לָכֶ֑ם כָּל־מְלֶ֥אכֶת עֲבֹדָ֖ה לֹ֥א תַעֲשֽׂוּ׃ ס ");
INSERT INTO hbo_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","וּבְיֹ֣ום הַבִּכּוּרִ֗ים בְּהַקְרִ֨יבְכֶ֜ם מִנְחָ֤ה חֲדָשָׁה֙ לַֽיהוָ֔ה בְּשָׁבֻעֹ֖תֵיכֶ֑ם מִֽקְרָא־קֹ֙דֶשׁ֙ יִהְיֶ֣ה לָכֶ֔ם כָּל־מְלֶ֥אכֶת עֲבֹדָ֖ה לֹ֥א תַעֲשֽׂוּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","וְהִקְרַבְתֶּ֨ם עֹולָ֜ה לְרֵ֤יחַ נִיחֹ֙חַ֙ לַֽיהוָ֔ה פָּרִ֧ים בְּנֵי־בָקָ֛ר שְׁנַ֖יִם אַ֣יִל אֶחָ֑ד שִׁבְעָ֥ה כְבָשִׂ֖ים בְּנֵ֥י שָׁנָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","וּמִנְחָתָ֔ם סֹ֖לֶת בְּלוּלָ֣ה בַשָּׁ֑מֶן שְׁלֹשָׁ֤ה עֶשְׂרֹנִים֙ לַפָּ֣ר הָֽאֶחָ֔ד שְׁנֵי֙ עֶשְׂרֹנִ֔ים לָאַ֖יִל הָאֶחָֽד׃ ");
INSERT INTO hbo_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","עִשָּׂרֹון֙ עִשָּׂרֹ֔ון לַכֶּ֖בֶשׂ הָאֶחָ֑ד לְשִׁבְעַ֖ת הַכְּבָשִֽׂים׃ ");
INSERT INTO hbo_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","שְׂעִ֥יר עִזִּ֖ים אֶחָ֑ד לְכַפֵּ֖ר עֲלֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","מִלְּבַ֞ד עֹלַ֧ת הַתָּמִ֛יד וּמִנְחָתֹ֖ו תַּעֲשׂ֑וּ תְּמִימִ֥ם יִהְיוּ־לָכֶ֖ם וְנִסְכֵּיהֶֽם׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","וּבַחֹ֨דֶשׁ הַשְּׁבִיעִ֜י בְּאֶחָ֣ד לַחֹ֗דֶשׁ מִֽקְרָא־קֹ֙דֶשׁ֙ יִהְיֶ֣ה לָכֶ֔ם כָּל־מְלֶ֥אכֶת עֲבֹדָ֖ה לֹ֣א תַעֲשׂ֑וּ יֹ֥ום תְּרוּעָ֖ה יִהְיֶ֥ה לָכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","וַעֲשִׂיתֶ֨ם עֹלָ֜ה לְרֵ֤יחַ נִיחֹ֙חַ֙ לַֽיהוָ֔ה פַּ֧ר בֶּן־בָּקָ֛ר אֶחָ֖ד אַ֣יִל אֶחָ֑ד כְּבָשִׂ֧ים בְּנֵי־שָׁנָ֛ה שִׁבְעָ֖ה תְּמִימִֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","וּמִנְחָתָ֔ם סֹ֖לֶת בְּלוּלָ֣ה בַשָּׁ֑מֶן שְׁלֹשָׁ֤ה עֶשְׂרֹנִים֙ לַפָּ֔ר שְׁנֵ֥י עֶשְׂרֹנִ֖ים לָאָֽיִל׃ ");
INSERT INTO hbo_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","וְעִשָּׂרֹ֣ון אֶחָ֔ד לַכֶּ֖בֶשׂ הָאֶחָ֑ד לְשִׁבְעַ֖ת הַכְּבָשִֽׂים׃ ");
INSERT INTO hbo_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","וּשְׂעִיר־עִזִּ֥ים אֶחָ֖ד חַטָּ֑את לְכַפֵּ֖ר עֲלֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","מִלְּבַד֩ עֹלַ֨ת הַחֹ֜דֶשׁ וּמִנְחָתָ֗הּ וְעֹלַ֤ת הַתָּמִיד֙ וּמִנְחָתָ֔הּ וְנִסְכֵּיהֶ֖ם כְּמִשְׁפָּטָ֑ם לְרֵ֣יחַ נִיחֹ֔חַ אִשֶּׁ֖ה לַיהוָֽה׃ ס ");
INSERT INTO hbo_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","וּבֶעָשֹׂור֩ לַחֹ֨דֶשׁ הַשְּׁבִיעִ֜י הַזֶּ֗ה מִֽקְרָא־קֹ֙דֶשׁ֙ יִהְיֶ֣ה לָכֶ֔ם וְעִנִּיתֶ֖ם אֶת־נַפְשֹׁתֵיכֶ֑ם כָּל־מְלָאכָ֖ה לֹ֥א תַעֲשֽׂוּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","וְהִקְרַבְתֶּ֨ם עֹלָ֤ה לַֽיהוָה֙ רֵ֣יחַ נִיחֹ֔חַ פַּ֧ר בֶּן־בָּקָ֛ר אֶחָ֖ד אַ֣יִל אֶחָ֑ד כְּבָשִׂ֤ים בְּנֵֽי־שָׁנָה֙ שִׁבְעָ֔ה תְּמִימִ֖ם יִהְי֥וּ לָכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","וּמִנְחָתָ֔ם סֹ֖לֶת בְּלוּלָ֣ה בַשָּׁ֑מֶן שְׁלֹשָׁ֤ה עֶשְׂרֹנִים֙ לַפָּ֔ר שְׁנֵי֙ עֶשְׂרֹנִ֔ים לָאַ֖יִל הָאֶחָֽד׃ ");
INSERT INTO hbo_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","עִשָּׂרֹון֙ עִשָּׂרֹ֔ון לַכֶּ֖בֶשׂ הָאֶחָ֑ד לְשִׁבְעַ֖ת הַכְּבָשִֽׂים׃ ");
INSERT INTO hbo_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","שְׂעִיר־עִזִּ֥ים אֶחָ֖ד חַטָּ֑את מִלְּבַ֞ד חַטַּ֤את הַכִּפֻּרִים֙ וְעֹלַ֣ת הַתָּמִ֔יד וּמִנְחָתָ֖הּ וְנִסְכֵּיהֶֽם׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","וּבַחֲמִשָּׁה֩ עָשָׂ֨ר יֹ֜ום לַחֹ֣דֶשׁ הַשְּׁבִיעִ֗י מִֽקְרָא־קֹ֙דֶשׁ֙ יִהְיֶ֣ה לָכֶ֔ם כָּל־מְלֶ֥אכֶת עֲבֹדָ֖ה לֹ֣א תַעֲשׂ֑וּ וְחַגֹּתֶ֥ם חַ֛ג לַיהוָ֖ה שִׁבְעַ֥ת יָמִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","וְהִקְרַבְתֶּ֨ם עֹלָ֜ה אִשֵּׁ֨ה רֵ֤יחַ נִיחֹ֙חַ֙ לַֽיהוָ֔ה פָּרִ֧ים בְּנֵי־בָקָ֛ר שְׁלֹשָׁ֥ה עָשָׂ֖ר אֵילִ֣ם שְׁנָ֑יִם כְּבָשִׂ֧ים בְּנֵֽי־שָׁנָ֛ה אַרְבָּעָ֥ה עָשָׂ֖ר תְּמִימִ֥ם יִהְיֽוּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","וּמִנְחָתָ֔ם סֹ֖לֶת בְּלוּלָ֣ה בַשָּׁ֑מֶן שְׁלֹשָׁ֨ה עֶשְׂרֹנִ֜ים לַפָּ֣ר הָֽאֶחָ֗ד לִשְׁלֹשָׁ֤ה עָשָׂר֙ פָּרִ֔ים שְׁנֵ֤י עֶשְׂרֹנִים֙ לָאַ֣יִל הָֽאֶחָ֔ד לִשְׁנֵ֖י הָאֵילִֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","וְעִשָּׂרֹוׄן֙ עִשָּׂרֹ֔ון לַכֶּ֖בֶשׂ הָאֶחָ֑ד לְאַרְבָּעָ֥ה עָשָׂ֖ר כְּבָשִֽׂים׃ ");
INSERT INTO hbo_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","וּשְׂעִיר־עִזִּ֥ים אֶחָ֖ד חַטָּ֑את מִלְּבַד֙ עֹלַ֣ת הַתָּמִ֔יד מִנְחָתָ֖הּ וְנִסְכָּֽהּ׃ ס ");
INSERT INTO hbo_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","וּבַיֹּ֣ום הַשֵּׁנִ֗י פָּרִ֧ים בְּנֵי־בָקָ֛ר שְׁנֵ֥ים עָשָׂ֖ר אֵילִ֣ם שְׁנָ֑יִם כְּבָשִׂ֧ים בְּנֵי־שָׁנָ֛ה אַרְבָּעָ֥ה עָשָׂ֖ר תְּמִימִֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","וּמִנְחָתָ֣ם וְנִסְכֵּיהֶ֡ם לַ֠פָּרִים לָאֵילִ֧ם וְלַכְּבָשִׂ֛ים בְּמִסְפָּרָ֖ם כַּמִּשְׁפָּֽט׃ ");
INSERT INTO hbo_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","וּשְׂעִיר־עִזִּ֥ים אֶחָ֖ד חַטָּ֑את מִלְּבַד֙ עֹלַ֣ת הַתָּמִ֔יד וּמִנְחָתָ֖הּ וְנִסְכֵּיהֶֽם׃ ס ");
INSERT INTO hbo_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","וּבַיֹּ֧ום הַשְּׁלִישִׁ֛י פָּרִ֥ים עַשְׁתֵּי־עָשָׂ֖ר אֵילִ֣ם שְׁנָ֑יִם כְּבָשִׂ֧ים בְּנֵי־שָׁנָ֛ה אַרְבָּעָ֥ה עָשָׂ֖ר תְּמִימִֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","וּמִנְחָתָ֣ם וְנִסְכֵּיהֶ֡ם לַ֠פָּרִים לָאֵילִ֧ם וְלַכְּבָשִׂ֛ים בְּמִסְפָּרָ֖ם כַּמִּשְׁפָּֽט׃ ");
INSERT INTO hbo_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","וּשְׂעִ֥יר חַטָּ֖את אֶחָ֑ד מִלְּבַד֙ עֹלַ֣ת הַתָּמִ֔יד וּמִנְחָתָ֖הּ וְנִסְכָּֽהּ׃ ס ");
INSERT INTO hbo_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","וּבַיֹּ֧ום הָרְבִיעִ֛י פָּרִ֥ים עֲשָׂרָ֖ה אֵילִ֣ם שְׁנָ֑יִם כְּבָשִׂ֧ים בְּנֵֽי־שָׁנָ֛ה אַרְבָּעָ֥ה עָשָׂ֖ר תְּמִימִֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","מִנְחָתָ֣ם וְנִסְכֵּיהֶ֡ם לַ֠פָּרִים לָאֵילִ֧ם וְלַכְּבָשִׂ֛ים בְּמִסְפָּרָ֖ם כַּמִּשְׁפָּֽט׃ ");
INSERT INTO hbo_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","וּשְׂעִיר־עִזִּ֥ים אֶחָ֖ד חַטָּ֑את מִלְּבַד֙ עֹלַ֣ת הַתָּמִ֔יד מִנְחָתָ֖הּ וְנִסְכָּֽהּ׃ ס ");
INSERT INTO hbo_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","וּבַיֹּ֧ום הַחֲמִישִׁ֛י פָּרִ֥ים תִּשְׁעָ֖ה אֵילִ֣ם שְׁנָ֑יִם כְּבָשִׂ֧ים בְּנֵֽי־שָׁנָ֛ה אַרְבָּעָ֥ה עָשָׂ֖ר תְּמִימִֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","וּמִנְחָתָ֣ם וְנִסְכֵּיהֶ֡ם לַ֠פָּרִים לָאֵילִ֧ם וְלַכְּבָשִׂ֛ים בְּמִסְפָּרָ֖ם כַּמִּשְׁפָּֽט׃ ");
INSERT INTO hbo_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","וּשְׂעִ֥יר חַטָּ֖את אֶחָ֑ד מִלְּבַד֙ עֹלַ֣ת הַתָּמִ֔יד וּמִנְחָתָ֖הּ וְנִסְכָּֽהּ׃ ס ");
INSERT INTO hbo_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","וּבַיֹּ֧ום הַשִּׁשִּׁ֛י פָּרִ֥ים שְׁמֹנָ֖ה אֵילִ֣ם שְׁנָ֑יִם כְּבָשִׂ֧ים בְּנֵי־שָׁנָ֛ה אַרְבָּעָ֥ה עָשָׂ֖ר תְּמִימִֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","וּמִנְחָתָ֣ם וְנִסְכֵּיהֶ֡ם לַ֠פָּרִים לָאֵילִ֧ם וְלַכְּבָשִׂ֛ים בְּמִסְפָּרָ֖ם כַּמִּשְׁפָּֽט׃ ");
INSERT INTO hbo_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","וּשְׂעִ֥יר חַטָּ֖את אֶחָ֑ד מִלְּבַד֙ עֹלַ֣ת הַתָּמִ֔יד מִנְחָתָ֖הּ וּנְסָכֶֽיהָ׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","וּבַיֹּ֧ום הַשְּׁבִיעִ֛י פָּרִ֥ים שִׁבְעָ֖ה אֵילִ֣ם שְׁנָ֑יִם כְּבָשִׂ֧ים בְּנֵי־שָׁנָ֛ה אַרְבָּעָ֥ה עָשָׂ֖ר תְּמִימִֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","וּמִנְחָתָ֣ם וְנִסְכֵּהֶ֡ם לַ֠פָּרִים לָאֵילִ֧ם וְלַכְּבָשִׂ֛ים בְּמִסְפָּרָ֖ם כְּמִשְׁפָּטָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","וּשְׂעִ֥יר חַטָּ֖את אֶחָ֑ד מִלְּבַד֙ עֹלַ֣ת הַתָּמִ֔יד מִנְחָתָ֖הּ וְנִסְכָּֽהּ׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","בַּיֹּום֙ הַשְּׁמִינִ֔י עֲצֶ֖רֶת תִּהְיֶ֣ה לָכֶ֑ם כָּל־מְלֶ֥אכֶת עֲבֹדָ֖ה לֹ֥א תַעֲשֽׂוּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","וְהִקְרַבְתֶּ֨ם עֹלָ֜ה אִשֵּׁ֨ה רֵ֤יחַ נִיחֹ֙חַ֙ לַֽיהוָ֔ה פַּ֥ר אֶחָ֖ד אַ֣יִל אֶחָ֑ד כְּבָשִׂ֧ים בְּנֵי־שָׁנָ֛ה שִׁבְעָ֖ה תְּמִימִֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","מִנְחָתָ֣ם וְנִסְכֵּיהֶ֗ם לַפָּ֨ר לָאַ֧יִל וְלַכְּבָשִׂ֛ים בְּמִסְפָּרָ֖ם כַּמִּשְׁפָּֽט׃ ");
INSERT INTO hbo_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","וּשְׂעִ֥יר חַטָּ֖את אֶחָ֑ד מִלְּבַד֙ עֹלַ֣ת הַתָּמִ֔יד וּמִנְחָתָ֖הּ וְנִסְכָּֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","אֵ֛לֶּה תַּעֲשׂ֥וּ לַיהוָ֖ה בְּמֹועֲדֵיכֶ֑ם לְבַ֨ד מִנִּדְרֵיכֶ֜ם וְנִדְבֹתֵיכֶ֗ם לְעֹלֹֽתֵיכֶם֙ וּלְמִנְחֹ֣תֵיכֶ֔ם וּלְנִסְכֵּיכֶ֖ם וּלְשַׁלְמֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","וַיֹּ֥אמֶר מֹשֶׁ֖ה אֶל־בְּנֵ֣י יִשְׂרָאֵ֑ל כְּכֹ֛ל אֲשֶׁר־צִוָּ֥ה יְהוָ֖ה אֶת־מֹשֶֽׁה׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","וַיְדַבֵּ֤ר מֹשֶׁה֙ אֶל־רָאשֵׁ֣י הַמַּטֹּ֔ות לִבְנֵ֥י יִשְׂרָאֵ֖ל לֵאמֹ֑ר זֶ֣ה הַדָּבָ֔ר אֲשֶׁ֖ר צִוָּ֥ה יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","אִישׁ֩ כִּֽי־יִדֹּ֨ר נֶ֜דֶר לַֽיהוָ֗ה אֹֽו־הִשָּׁ֤בַע שְׁבֻעָה֙ לֶאְסֹ֤ר אִסָּר֙ עַל־נַפְשֹׁ֔ו לֹ֥א יַחֵ֖ל דְּבָרֹ֑ו כְּכָל־הַיֹּצֵ֥א מִפִּ֖יו יַעֲשֶֽׂה׃ ");
INSERT INTO hbo_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","וְאִשָּׁ֕ה כִּֽי־תִדֹּ֥ר נֶ֖דֶר לַיהוָ֑ה וְאָסְרָ֥ה אִסָּ֛ר בְּבֵ֥ית אָבִ֖יהָ בִּנְעֻרֶֽיהָ׃ ");
INSERT INTO hbo_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","וְשָׁמַ֨ע אָבִ֜יהָ אֶת־נִדְרָ֗הּ וֽ͏ֶאֱסָרָהּ֙ אֲשֶׁ֣ר אֽ͏ָסְרָ֣ה עַל־נַפְשָׁ֔הּ וְהֶחֱרִ֥ישׁ לָ֖הּ אָבִ֑יהָ וְקָ֙מוּ֙ כָּל־נְדָרֶ֔יהָ וְכָל־אִסָּ֛ר אֲשֶׁר־אָסְרָ֥ה עַל־נַפְשָׁ֖הּ יָקֽוּם׃ ");
INSERT INTO hbo_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","וְאִם־הֵנִ֨יא אָבִ֣יהָ אֹתָהּ֮ בְּיֹ֣ום שָׁמְעֹו֒ כָּל־נְדָרֶ֗יהָ וֽ͏ֶאֱסָרֶ֛יהָ אֲשֶׁר־אָסְרָ֥ה עַל־נַפְשָׁ֖הּ לֹ֣א יָק֑וּם וַֽיהוָה֙ יִֽסְלַח־לָ֔הּ כִּי־הֵנִ֥יא אָבִ֖יהָ אֹתָֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","וְאִם־הָיֹ֤ו תִֽהְיֶה֙ לְאִ֔ישׁ וּנְדָרֶ֖יהָ עָלֶ֑יהָ אֹ֚ו מִבְטָ֣א שְׂפָתֶ֔יהָ אֲשֶׁ֥ר אָסְרָ֖ה עַל־נַפְשָֽׁהּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","וְשָׁמַ֥ע אִישָׁ֛הּ בְּיֹ֥ום שָׁמְעֹ֖ו וְהֶחֱרִ֣ישׁ לָ֑הּ וְקָ֣מוּ נְדָרֶ֗יהָ וֶֽאֱסָרֶ֛הָ אֲשֶׁר־אָסְרָ֥ה עַל־נַפְשָׁ֖הּ יָקֻֽמוּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","וְ֠אִם בְּיֹ֨ום שְׁמֹ֣עַ אִישָׁהּ֮ יָנִ֣יא אֹותָהּ֒ וְהֵפֵ֗ר אֶת־נִדְרָהּ֙ אֲשֶׁ֣ר עָלֶ֔יהָ וְאֵת֙ מִבְטָ֣א שְׂפָתֶ֔יהָ אֲשֶׁ֥ר אָסְרָ֖ה עַל־נַפְשָׁ֑הּ וַיהוָ֖ה יִֽסְלַֽח־לָֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","וְנֵ֥דֶר אַלְמָנָ֖ה וּגְרוּשָׁ֑ה כֹּ֛ל אֲשֶׁר־אָסְרָ֥ה עַל־נַפְשָׁ֖הּ יָק֥וּם עָלֶֽיהָ׃ ");
INSERT INTO hbo_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","וְאִם־בֵּ֥ית אִישָׁ֖הּ נָדָ֑רָה אֹֽו־אָסְרָ֥ה אִסָּ֛ר עַל־נַפְשָׁ֖הּ בִּשְׁבֻעָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","וְשָׁמַ֤ע אִישָׁהּ֙ וְהֶחֱרִ֣שׁ לָ֔הּ לֹ֥א הֵנִ֖יא אֹתָ֑הּ וְקָ֙מוּ֙ כָּל־נְדָרֶ֔יהָ וְכָל־אִסָּ֛ר אֲשֶׁר־אָסְרָ֥ה עַל־נַפְשָׁ֖הּ יָקֽוּם׃ ");
INSERT INTO hbo_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","וְאִם־הָפֵר֩ יָפֵ֨ר אֹתָ֥ם ׀ אִישָׁהּ֮ בְּיֹ֣ום שָׁמְעֹו֒ כָּל־מֹוצָ֨א שְׂפָתֶ֧יהָ לִנְדָרֶ֛יהָ וּלְאִסַּ֥ר נַפְשָׁ֖הּ לֹ֣א יָק֑וּם אִישָׁ֣הּ הֲפֵרָ֔ם וַיהוָ֖ה יִֽסְלַֽח־לָֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","כָּל־נֵ֛דֶר וְכָל־שְׁבֻעַ֥ת אִסָּ֖ר לְעַנֹּ֣ת נָ֑פֶשׁ אִישָׁ֥הּ יְקִימֶ֖נּוּ וְאִישָׁ֥הּ יְפֵרֶֽנּוּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","וְאִם־הַחֲרֵשׁ֩ יַחֲרִ֨ישׁ לָ֥הּ אִישָׁהּ֮ מִיֹּ֣ום אֶל־יֹום֒ וְהֵקִים֙ אֶת־כָּל־נְדָרֶ֔יהָ אֹ֥ו אֶת־כָּל־אֱסָרֶ֖יהָ אֲשֶׁ֣ר עָלֶ֑יהָ הֵקִ֣ים אֹתָ֔ם כִּי־הֶחֱרִ֥שׁ לָ֖הּ בְּיֹ֥ום שָׁמְעֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","וְאִם־הָפֵ֥ר יָפֵ֛ר אֹתָ֖ם אַחֲרֵ֣י שָׁמְעֹ֑ו וְנָשָׂ֖א אֶת־עֲוֹנָֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU30_17","005_30_17","NUM","30","17","17","אֵ֣לֶּה הֽ͏ַחֻקִּ֗ים אֲשֶׁ֨ר צִוָּ֤ה יְהוָה֙ אֶת־מֹשֶׁ֔ה בֵּ֥ין אִ֖ישׁ לְאִשְׁתֹּ֑ו בֵּֽין־אָ֣ב לְבִתֹּ֔ו בִּנְעֻרֶ֖יהָ בֵּ֥ית אָבִֽיהָ׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","נְקֹ֗ם נִקְמַת֙ בְּנֵ֣י יִשְׂרָאֵ֔ל מֵאֵ֖ת הַמִּדְיָנִ֑ים אַחַ֖ר תֵּאָסֵ֥ף אֶל־עַמֶּֽיךָ׃ ");
INSERT INTO hbo_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","וַיְדַבֵּ֤ר מֹשֶׁה֙ אֶל־הָעָ֣ם לֵאמֹ֔ר הֵחָלְצ֧וּ מֵאִתְּכֶ֛ם אֲנָשִׁ֖ים לַצָּבָ֑א וְיִהְיוּ֙ עַל־מִדְיָ֔ן לָתֵ֥ת נִקְמַת־יְהוָ֖ה בְּמִדְיָֽן׃ ");
INSERT INTO hbo_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","אֶ֚לֶף לַמַּטֶּ֔ה אֶ֖לֶף לַמַּטֶּ֑ה לְכֹל֙ מַטֹּ֣ות יִשְׂרָאֵ֔ל תִּשְׁלְח֖וּ לַצָּבָֽא׃ ");
INSERT INTO hbo_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","וַיִּמּֽ͏ָסְרוּ֙ מֵאַלְפֵ֣י יִשְׂרָאֵ֔ל אֶ֖לֶף לַמַּטֶּ֑ה שְׁנֵים־עָשָׂ֥ר אֶ֖לֶף חֲלוּצֵ֥י צָבָֽא׃ ");
INSERT INTO hbo_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","וַיִּשְׁלַ֨ח אֹתָ֥ם מֹשֶׁ֛ה אֶ֥לֶף לַמַּטֶּ֖ה לַצָּבָ֑א אֹ֠תָם וְאֶת־פִּ֨ינְחָ֜ס בֶּן־אֶלְעָזָ֤ר הַכֹּהֵן֙ לַצָּבָ֔א וּכְלֵ֥י הַקֹּ֛דֶשׁ וַחֲצֹצְרֹ֥ות הַתְּרוּעָ֖ה בְּיָדֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","וַֽיִּצְבְּאוּ֙ עַל־מִדְיָ֔ן כַּאֲשֶׁ֛ר צִוָּ֥ה יְהוָ֖ה אֶת־מֹשֶׁ֑ה וַיַּֽהַרְג֖וּ כָּל־זָכָֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","וְאֶת־מַלְכֵ֨י מִדְיָ֜ן הָרְג֣וּ עַל־חַלְלֵיהֶ֗ם אֶת־אֱוִ֤י וְאֶת־רֶ֙קֶם֙ וְאֶת־צ֤וּר וְאֶת־חוּר֙ וְאֶת־רֶ֔בַע חֲמֵ֖שֶׁת מַלְכֵ֣י מִדְיָ֑ן וְאֵת֙ בִּלְעָ֣ם בֶּן־בְּעֹ֔ור הָרְג֖וּ בֶּחָֽרֶב׃ ");
INSERT INTO hbo_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","וַיִּשְׁבּ֧וּ בְנֵי־יִשְׂרָאֵ֛ל אֶת־נְשֵׁ֥י מִדְיָ֖ן וְאֶת־טַפָּ֑ם וְאֵ֨ת כָּל־בְּהֶמְתָּ֧ם וְאֶת־כָּל־מִקְנֵהֶ֛ם וְאֶת־כָּל־חֵילָ֖ם בָּזָֽזוּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","וְאֵ֤ת כָּל־עָרֵיהֶם֙ בְּמֹ֣ושְׁבֹתָ֔ם וְאֵ֖ת כָּל־טִֽירֹתָ֑ם שָׂרְפ֖וּ בָּאֵֽשׁ׃ ");
INSERT INTO hbo_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","וַיִּקְחוּ֙ אֶת־כָּל־הַשָּׁלָ֔ל וְאֵ֖ת כָּל־הַמַּלְקֹ֑וחַ בָּאָדָ֖ם וּבַבְּהֵמָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","וַיָּבִ֡אוּ אֶל־מֹשֶׁה֩ וְאֶל־אֶלְעָזָ֨ר הַכֹּהֵ֜ן וְאֶל־עֲדַ֣ת בְּנֵֽי־יִשְׂרָאֵ֗ל אֶת־הַשְּׁבִ֧י וְאֶת־הַמַּלְקֹ֛וחַ וְאֶת־הַשָּׁלָ֖ל אֶל־הַֽמַּחֲנֶ֑ה אֶל־עַֽרְבֹ֣ת מֹואָ֔ב אֲשֶׁ֖ר עַל־יַרְדֵּ֥ן יְרֵחֹֽו׃ ס ");
INSERT INTO hbo_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","וַיֵּ֨צְא֜וּ מֹשֶׁ֨ה וְאֶלְעָזָ֧ר הַכֹּהֵ֛ן וְכָל־נְשִׂיאֵ֥י הָעֵדָ֖ה לִקְרָאתָ֑ם אֶל־מִח֖וּץ לַֽמַּחֲנֶֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","וַיִּקְצֹ֣ף מֹשֶׁ֔ה עַ֖ל פְּקוּדֵ֣י הֶחָ֑יִל שָׂרֵ֤י הָאֲלָפִים֙ וְשָׂרֵ֣י הַמֵּאֹ֔ות הַבָּאִ֖ים מִצְּבָ֥א הַמִּלְחָמָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","וַיֹּ֥אמֶר אֲלֵיהֶ֖ם מֹשֶׁ֑ה הַֽחִיִּיתֶ֖ם כָּל־נְקֵבָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","הֵ֣ן הֵ֜נָּה הָי֨וּ לִבְנֵ֤י יִשְׂרָאֵל֙ בִּדְבַ֣ר בִּלְעָ֔ם לִמְסָר־מַ֥עַל בַּיהוָ֖ה עַל־דְּבַר־פְּעֹ֑ור וַתְּהִ֥י הַמַּגֵּפָ֖ה בַּעֲדַ֥ת יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","וְעַתָּ֕ה הִרְג֥וּ כָל־זָכָ֖ר בַּטָּ֑ף וְכָל־אִשָּׁ֗ה יֹדַ֥עַת אִ֛ישׁ לְמִשְׁכַּ֥ב זָכָ֖ר הֲרֹֽגוּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","וְכֹל֙ הַטַּ֣ף בַּנָּשִׁ֔ים אֲשֶׁ֥ר לֹא־יָדְע֖וּ מִשְׁכַּ֣ב זָכָ֑ר הַחֲי֖וּ לָכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","וְאַתֶּ֗ם חֲנ֛וּ מִח֥וּץ לַֽמַּחֲנֶ֖ה שִׁבְעַ֣ת יָמִ֑ים כֹּל֩ הֹרֵ֨ג נֶ֜פֶשׁ וְכֹ֣ל ׀ נֹגֵ֣עַ בֶּֽחָלָ֗ל תִּֽתְחַטְּא֞וּ בַּיֹּ֤ום הַשְּׁלִישִׁי֙ וּבַיֹּ֣ום הַשְּׁבִיעִ֔י אַתֶּ֖ם וּשְׁבִיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","וְכָל־בֶּ֧גֶד וְכָל־כְּלִי־עֹ֛ור וְכָל־מַעֲשֵׂ֥ה עִזִּ֖ים וְכָל־כְּלִי־עֵ֑ץ תִּתְחַטָּֽאוּ׃ ס ");
INSERT INTO hbo_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","וַיֹּ֨אמֶר אֶלְעָזָ֤ר הַכֹּהֵן֙ אֶל־אַנְשֵׁ֣י הַצָּבָ֔א הַבָּאִ֖ים לַמִּלְחָמָ֑ה זֹ֚את חֻקַּ֣ת הַתֹּורָ֔ה אֲשֶׁר־צִוָּ֥ה יְהוָ֖ה אֶת־מֹשֶֽׁה׃ ");
INSERT INTO hbo_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","אַ֥ךְ אֶת־הַזָּהָ֖ב וְאֶת־הַכָּ֑סֶף אֶֽת־הַנְּחֹ֙שֶׁת֙ אֶת־הַבַּרְזֶ֔ל אֶֽת־הַבְּדִ֖יל וְאֶת־הָעֹפָֽרֶת׃ ");
INSERT INTO hbo_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","כָּל־דָּבָ֞ר אֲשֶׁר־יָבֹ֣א בָאֵ֗שׁ תַּעֲבִ֤ירוּ בָאֵשׁ֙ וְטָהֵ֔ר אַ֕ךְ בְּמֵ֥י נִדָּ֖ה יִתְחַטָּ֑א וְכֹ֨ל אֲשֶׁ֧ר לֹֽא־יָבֹ֛א בָּאֵ֖שׁ תַּעֲבִ֥ירוּ בַמָּֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","וְכִבַּסְתֶּ֧ם בִּגְדֵיכֶ֛ם בַּיֹּ֥ום הַשְּׁבִיעִ֖י וּטְהַרְתֶּ֑ם וְאַחַ֖ר תָּבֹ֥אוּ אֶל־הַֽמַּחֲנֶֽה׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","וַיֹּ֥אמֶר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","שָׂ֗א אֵ֣ת רֹ֤אשׁ מַלְקֹ֙וחַ֙ הַשְּׁבִ֔י בָּאָדָ֖ם וּבַבְּהֵמָ֑ה אַתָּה֙ וְאֶלְעָזָ֣ר הַכֹּהֵ֔ן וְרָאשֵׁ֖י אֲבֹ֥ות הָעֵדָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","וְחָצִ֙יתָ֙ אֶת־הַמַּלְקֹ֔וחַ בֵּ֚ין תֹּפְשֵׂ֣י הַמִּלְחָמָ֔ה הַיֹּצְאִ֖ים לַצָּבָ֑א וּבֵ֖ין כָּל־הָעֵדָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","וַהֲרֵמֹתָ֨ מֶ֜כֶס לַֽיהוָ֗ה מֵאֵ֞ת אַנְשֵׁ֤י הַמִּלְחָמָה֙ הַיֹּצְאִ֣ים לַצָּבָ֔א אֶחָ֣ד נֶ֔פֶשׁ מֵחֲמֵ֖שׁ הַמֵּאֹ֑ות מִן־הָאָדָם֙ וּמִן־הַבָּקָ֔ר וּמִן־הַחֲמֹרִ֖ים וּמִן־הַצֹּֽאן׃ ");
INSERT INTO hbo_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","מִמַּֽחֲצִיתָ֖ם תִּקָּ֑חוּ וְנָתַתָּ֛ה לְאֶלְעָזָ֥ר הַכֹּהֵ֖ן תְּרוּמַ֥ת יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","וּמִמַּחֲצִ֨ת בְּנֵֽי־יִשְׂרָאֵ֜ל תִּקַּ֣ח ׀ אֶחָ֣ד ׀ אָחֻ֣ז מִן־הַחֲמִשִּׁ֗ים מִן־הָאָדָ֧ם מִן־הַבָּקָ֛ר מִן־הַחֲמֹרִ֥ים וּמִן־הַצֹּ֖אן מִכָּל־הַבְּהֵמָ֑ה וְנָתַתָּ֤ה אֹתָם֙ לַלְוִיִּ֔ם שֹׁמְרֵ֕י מִשְׁמֶ֖רֶת מִשְׁכַּ֥ן יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","וַיַּ֣עַשׂ מֹשֶׁ֔ה וְאֶלְעָזָ֖ר הַכֹּהֵ֑ן כַּאֲשֶׁ֛ר צִוָּ֥ה יְהוָ֖ה אֶת־מֹשֶֽׁה׃ ");
INSERT INTO hbo_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","וַיְהִי֙ הַמַּלְקֹ֔וחַ יֶ֣תֶר הַבָּ֔ז אֲשֶׁ֥ר בָּזְז֖וּ עַ֣ם הַצָּבָ֑א צֹ֗אן שֵׁשׁ־מֵאֹ֥ות אֶ֛לֶף וְשִׁבְעִ֥ים אֶ֖לֶף וַחֲמֵֽשֶׁת־אֲלָפִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","וּבָקָ֕ר שְׁנַ֥יִם וְשִׁבְעִ֖ים אָֽלֶף׃ ");
INSERT INTO hbo_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","וַחֲמֹרִ֕ים אֶחָ֥ד וְשִׁשִּׁ֖ים אָֽלֶף׃ ");
INSERT INTO hbo_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","וְנֶ֣פֶשׁ אָדָ֔ם מִן־הַ֨נָּשִׁ֔ים אֲשֶׁ֥ר לֹֽא־יָדְע֖וּ מִשְׁכַּ֣ב זָכָ֑ר כָּל־נֶ֕פֶשׁ שְׁנַ֥יִם וּשְׁלֹשִׁ֖ים אָֽלֶף׃ ");
INSERT INTO hbo_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","וַתְּהִי֙ הַֽמֶּחֱצָ֔ה חֵ֕לֶק הַיֹּצְאִ֖ים בַּצָּבָ֑א מִסְפַּ֣ר הַצֹּ֗אן שְׁלֹשׁ־מֵאֹ֥ות אֶ֙לֶף֙ וּשְׁלֹשִׁ֣ים אֶ֔לֶף וְשִׁבְעַ֥ת אֲלָפִ֖ים וַחֲמֵ֥שׁ מֵאֹֽות׃ ");
INSERT INTO hbo_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","וַיְהִ֛י הַמֶּ֥כֶס לַֽיהוָ֖ה מִן־הַצֹּ֑אן שֵׁ֥שׁ מֵאֹ֖ות חָמֵ֥שׁ וְשִׁבְעִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","וְהַ֨בָּקָ֔ר שִׁשָּׁ֥ה וּשְׁלֹשִׁ֖ים אָ֑לֶף וּמִכְסָ֥ם לַיהוָ֖ה שְׁנַ֥יִם וְשִׁבְעִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","וַחֲמֹרִ֕ים שְׁלֹשִׁ֥ים אֶ֖לֶף וַחֲמֵ֣שׁ מֵאֹ֑ות וּמִכְסָ֥ם לַֽיהוָ֖ה אֶחָ֥ד וְשִׁשִּֽׁים׃ ");
INSERT INTO hbo_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","וְנֶ֣פֶשׁ אָדָ֔ם שִׁשָּׁ֥ה עָשָׂ֖ר אָ֑לֶף וּמִכְסָם֙ לַֽיהוָ֔ה שְׁנַ֥יִם וּשְׁלֹשִׁ֖ים נָֽפֶשׁ׃ ");
INSERT INTO hbo_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","וַיִּתֵּ֣ן מֹשֶׁ֗ה אֶת־מֶ֙כֶס֙ תְּרוּמַ֣ת יְהוָ֔ה לְאֶלְעָזָ֖ר הַכֹּהֵ֑ן כַּאֲשֶׁ֛ר צִוָּ֥ה יְהוָ֖ה אֶת־מֹשֶֽׁה׃ ");
INSERT INTO hbo_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","וּמִֽמַּחֲצִ֖ית בְּנֵ֣י יִשְׂרָאֵ֑ל אֲשֶׁר֙ חָצָ֣ה מֹשֶׁ֔ה מִן־הָאֲנָשִׁ֖ים הַצֹּבְאִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","וַתְּהִ֛י מֶחֱצַ֥ת הָעֵדָ֖ה מִן־הַצֹּ֑אן שְׁלֹשׁ־מֵאֹ֥ות אֶ֙לֶף֙ וּשְׁלֹשִׁ֣ים אֶ֔לֶף שִׁבְעַ֥ת אֲלָפִ֖ים וַחֲמֵ֥שׁ מֵאֹֽות׃ ");
INSERT INTO hbo_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","וּבָקָ֕ר שִׁשָּׁ֥ה וּשְׁלֹשִׁ֖ים אָֽלֶף׃ ");
INSERT INTO hbo_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","וַחֲמֹרִ֕ים שְׁלֹשִׁ֥ים אֶ֖לֶף וַחֲמֵ֥שׁ מֵאֹֽות׃ ");
INSERT INTO hbo_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","וְנֶ֣פֶשׁ אָדָ֔ם שִׁשָּׁ֥ה עָשָׂ֖ר אָֽלֶף׃ ");
INSERT INTO hbo_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","וַיִּקַּ֨ח מֹשֶׁ֜ה מִמַּחֲצִ֣ת בְּנֵֽי־יִשְׂרָאֵ֗ל אֶת־הָֽאָחֻז֙ אֶחָ֣ד מִן־הַחֲמִשִּׁ֔ים מִן־הָאָדָ֖ם וּמִן־הַבְּהֵמָ֑ה וַיִּתֵּ֨ן אֹתָ֜ם לַלְוִיִּ֗ם שֹֽׁמְרֵי֙ מִשְׁמֶ֙רֶת֙ מִשְׁכַּ֣ן יְהוָ֔ה כַּאֲשֶׁ֛ר צִוָּ֥ה יְהוָ֖ה אֶת־מֹשֶֽׁה׃ ");
INSERT INTO hbo_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","וַֽיִּקְרְבוּ֙ אֶל־מֹשֶׁ֔ה הַפְּקֻדִ֕ים אֲשֶׁ֖ר לְאַלְפֵ֣י הַצָּבָ֑א שָׂרֵ֥י הָאֲלָפִ֖ים וְשָׂרֵ֥י הַמֵּאֹֽות׃ ");
INSERT INTO hbo_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","וַיֹּֽאמְרוּ֙ אֶל־מֹשֶׁ֔ה עֲבָדֶ֣יךָ נָֽשְׂא֗וּ אֶת־רֹ֛אשׁ אַנְשֵׁ֥י הַמִּלְחָמָ֖ה אֲשֶׁ֣ר בְּיָדֵ֑נוּ וְלֹא־נִפְקַ֥ד מִמֶּ֖נּוּ אִֽישׁ׃ ");
INSERT INTO hbo_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","וַנַּקְרֵ֞ב אֶת־קָרְבַּ֣ן יְהוָ֗ה אִישׁ֩ אֲשֶׁ֨ר מָצָ֤א כְלִֽי־זָהָב֙ אֶצְעָדָ֣ה וְצָמִ֔יד טַבַּ֖עַת עָגִ֣יל וְכוּמָ֑ז לְכַפֵּ֥ר עַל־נַפְשֹׁתֵ֖ינוּ לִפְנֵ֥י יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","וַיִּקַּ֨ח מֹשֶׁ֜ה וְאֶלְעָזָ֧ר הַכֹּהֵ֛ן אֶת־הַזָּהָ֖ב מֵֽאִתָּ֑ם כֹּ֖ל כְּלִ֥י מַעֲשֶֽׂה׃ ");
INSERT INTO hbo_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","וַיְהִ֣י ׀ כָּל־זְהַ֣ב הַתְּרוּמָ֗ה אֲשֶׁ֤ר הֵרִ֙ימוּ֙ לַֽיהוָ֔ה שִׁשָּׁ֨ה עָשָׂ֥ר אֶ֛לֶף שְׁבַע־מֵאֹ֥ות וַחֲמִשִּׁ֖ים שָׁ֑קֶל מֵאֵת֙ שָׂרֵ֣י הֽ͏ָאֲלָפִ֔ים וּמֵאֵ֖ת שָׂרֵ֥י הַמֵּאֹֽות׃ ");
INSERT INTO hbo_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","אַנְשֵׁי֙ הַצָּבָ֔א בָּזְז֖וּ אִ֥ישׁ לֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","וַיִּקַּ֨ח מֹשֶׁ֜ה וְאֶלְעָזָ֤ר הַכֹּהֵן֙ אֶת־הַזָּהָ֔ב מֵאֵ֛ת שָׂרֵ֥י הָאֲלָפִ֖ים וְהַמֵּאֹ֑ות וַיָּבִ֤אוּ אֹתֹו֙ אֶל־אֹ֣הֶל מֹועֵ֔ד זִכָּרֹ֥ון לִבְנֵֽי־יִשְׂרָאֵ֖ל לִפְנֵ֥י יְהוָֽה׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","וּמִקְנֶ֣ה ׀ רַ֗ב הָיָ֞ה לִבְנֵ֧י רְאוּבֵ֛ן וְלִבְנֵי־גָ֖ד עָצ֣וּם מְאֹ֑ד וַיִּרְא֞וּ אֶת־אֶ֤רֶץ יַעְזֵר֙ וְאֶת־אֶ֣רֶץ גִּלְעָ֔ד וְהִנֵּ֥ה הַמָּקֹ֖ום מְקֹ֥ום מִקְנֶֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","וַיָּבֹ֥אוּ בְנֵֽי־גָ֖ד וּבְנֵ֣י רְאוּבֵ֑ן וַיֹּאמְר֤וּ אֶל־מֹשֶׁה֙ וְאֶל־אֶלְעָזָ֣ר הַכֹּהֵ֔ן וְאֶל־נְשִׂיאֵ֥י הָעֵדָ֖ה לֵאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","עֲטָרֹ֤ות וְדִיבֹן֙ וְיַעְזֵ֣ר וְנִמְרָ֔ה וְחֶשְׁבֹּ֖ון וְאֶלְעָלֵ֑ה וּשְׂבָ֥ם וּנְבֹ֖ו וּבְעֹֽן׃ ");
INSERT INTO hbo_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","הָאָ֗רֶץ אֲשֶׁ֨ר הִכָּ֤ה יְהוָה֙ לִפְנֵי֙ עֲדַ֣ת יִשְׂרָאֵ֔ל אֶ֥רֶץ מִקְנֶ֖ה הִ֑וא וְלַֽעֲבָדֶ֖יךָ מִקְנֶֽה׃ ס ");
INSERT INTO hbo_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","וַיֹּאמְר֗וּ אִם־מָצָ֤אנוּ חֵן֙ בְּעֵינֶ֔יךָ יֻתַּ֞ן אֶת־הָאָ֧רֶץ הַזֹּ֛את לַעֲבָדֶ֖יךָ לַאֲחֻזָּ֑ה אַל־תַּעֲבִרֵ֖נוּ אֶת־הַיַּרְדֵּֽן׃ ");
INSERT INTO hbo_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","וַיֹּ֣אמֶר מֹשֶׁ֔ה לִבְנֵי־גָ֖ד וְלִבְנֵ֣י רְאוּבֵ֑ן הַאַֽחֵיכֶ֗ם יָבֹ֙אוּ֙ לַמִּלְחָמָ֔ה וְאַתֶּ֖ם תֵּ֥שְׁבוּ פֹֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","וְלָ֣מָּה *תְנוּאוּן (תְנִיא֔וּן) אֶת־לֵ֖ב בְּנֵ֣י יִשְׂרָאֵ֑ל מֵֽעֲבֹר֙ אֶל־הָאָ֔רֶץ אֲשֶׁר־נָתַ֥ן לָהֶ֖ם יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","כֹּ֥ה עָשׂ֖וּ אֲבֹתֵיכֶ֑ם בְּשָׁלְחִ֥י אֹתָ֛ם מִקָּדֵ֥שׁ בַּרְנֵ֖עַ לִרְאֹ֥ות אֶת־הָאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","וַֽיַּעֲל֞וּ עַד־נַ֣חַל אֶשְׁכֹּ֗ול וַיִּרְאוּ֙ אֶת־הָאָ֔רֶץ וַיָּנִ֕יאוּ אֶת־לֵ֖ב בְּנֵ֣י יִשְׂרָאֵ֑ל לְבִלְתִּי־בֹא֙ אֶל־הָאָ֔רֶץ אֲשֶׁר־נָתַ֥ן לָהֶ֖ם יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","וַיִּֽחַר־אַ֥ף יְהוָ֖ה בַּיֹּ֣ום הַה֑וּא וַיִּשָּׁבַ֖ע לֵאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","אִם־יִרְא֨וּ הָאֲנָשִׁ֜ים הָעֹלִ֣ים מִמִּצְרַ֗יִם מִבֶּ֨ן עֶשְׂרִ֤ים שָׁנָה֙ וָמַ֔עְלָה אֵ֚ת הָאֲדָמָ֔ה אֲשֶׁ֥ר נִשְׁבַּ֛עְתִּי לְאַבְרָהָ֥ם לְיִצְחָ֖ק וּֽלְיַעֲקֹ֑ב כִּ֥י לֹא־מִלְא֖וּ אַחֲרָֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","בִּלְתִּ֞י כָּלֵ֤ב בֶּן־יְפֻנֶּה֙ הַקְּנִזִּ֔י וִיהֹושֻׁ֖עַ בִּן־נ֑וּן כִּ֥י מִלְא֖וּ אַחֲרֵ֥י יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","וַיִּֽחַר־אַ֤ף יְהוָה֙ בְּיִשְׂרָאֵ֔ל וַיְנִעֵם֙ בַּמִּדְבָּ֔ר אַרְבָּעִ֖ים שָׁנָ֑ה עַד־תֹּם֙ כָּל־הַדֹּ֔ור הָעֹשֶׂ֥ה הָרַ֖ע בְּעֵינֵ֥י יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","וְהִנֵּ֣ה קַמְתֶּ֗ם תַּ֚חַת אֲבֹ֣תֵיכֶ֔ם תַּרְבּ֖וּת אֲנָשִׁ֣ים חַטָּאִ֑ים לִסְפֹּ֣ות עֹ֗וד עַ֛ל חֲרֹ֥ון אַף־יְהוָ֖ה אֶל־יִשְׂרָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","כִּ֤י תְשׁוּבֻן֙ מֵֽאַחֲרָ֔יו וְיָסַ֣ף עֹ֔וד לְהַנִּיחֹ֖ו בַּמִּדְבָּ֑ר וְשִֽׁחַתֶּ֖ם לְכָל־הָעָ֥ם הַזֶּֽה׃ ס ");
INSERT INTO hbo_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","וַיִּגְּשׁ֤וּ אֵלָיו֙ וַ֣יֹּאמְר֔וּ גִּדְרֹ֥ת צֹ֛אן נִבְנֶ֥ה לְמִקְנֵ֖נוּ פֹּ֑ה וְעָרִ֖ים לְטַפֵּֽנוּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","וַאֲנַ֜חְנוּ נֵחָלֵ֣ץ חֻשִׁ֗ים לִפְנֵי֙ בְּנֵ֣י יִשְׂרָאֵ֔ל עַ֛ד אֲשֶׁ֥ר אִם־הֲבִֽיאֹנֻ֖ם אֶל־מְקֹומָ֑ם וְיָשַׁ֤ב טַפֵּ֙נוּ֙ בְּעָרֵ֣י הַמִּבְצָ֔ר מִפְּנֵ֖י יֹשְׁבֵ֥י הָאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","לֹ֥א נָשׁ֖וּב אֶל־בָּתֵּ֑ינוּ עַ֗ד הִתְנַחֵל֙ בְּנֵ֣י יִשְׂרָאֵ֔ל אִ֖ישׁ נַחֲלָתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","כִּ֣י לֹ֤א נִנְחַל֙ אִתָּ֔ם מֵעֵ֥בֶר לַיַּרְדֵּ֖ן וָהָ֑לְאָה כִּ֣י בָ֤אָה נַחֲלָתֵ֙נוּ֙ אֵלֵ֔ינוּ מֵעֵ֥בֶר הַיַּרְדֵּ֖ן מִזְרָֽחָה׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","וַיֹּ֤אמֶר אֲלֵיהֶם֙ מֹשֶׁ֔ה אִֽם־תַּעֲשׂ֖וּן אֶת־הַדָּבָ֣ר הַזֶּ֑ה אִם־תֵּחָ֥לְצ֛וּ לִפְנֵ֥י יְהוָ֖ה לַמִּלְחָמָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","וְעָבַ֨ר לָכֶ֧ם כָּל־חָל֛וּץ אֶת־הַיַּרְדֵּ֖ן לִפְנֵ֣י יְהוָ֑ה עַ֧ד הֹורִישֹׁ֛ו אֶת־אֹיְבָ֖יו מִפָּנָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","וְנִכְבְּשָׁ֨ה הָאָ֜רֶץ לִפְנֵ֤י יְהוָה֙ וְאַחַ֣ר תָּשֻׁ֔בוּ וִהְיִיתֶ֧ם נְקִיִּ֛ים מֵיְהוָ֖ה וּמִיִּשְׂרָאֵ֑ל וְ֠הָיְתָה הָאָ֨רֶץ הַזֹּ֥את לָכֶ֛ם לַאֲחֻזָּ֖ה לִפְנֵ֥י יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","וְאִם־לֹ֤א תַעֲשׂוּן֙ כֵּ֔ן הִנֵּ֥ה חֲטָאתֶ֖ם לַיהוָ֑ה וּדְעוּ֙ חַטַּאתְכֶ֔ם אֲשֶׁ֥ר תִּמְצָ֖א אֶתְכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","בְּנֽוּ־לָכֶ֤ם עָרִים֙ לְטַפְּכֶ֔ם וּגְדֵרֹ֖ת לְצֹנַאֲכֶ֑ם וְהַיֹּצֵ֥א מִפִּיכֶ֖ם תַּעֲשֽׂוּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","וַיֹּ֤אמֶר בְּנֵי־גָד֙ וּבְנֵ֣י רְאוּבֵ֔ן אֶל־מֹשֶׁ֖ה לֵאמֹ֑ר עֲבָדֶ֣יךָ יַעֲשׂ֔וּ כַּאֲשֶׁ֥ר אֲדֹנִ֖י מְצַוֶּֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","טַפֵּ֣נוּ נָשֵׁ֔ינוּ מִקְנֵ֖נוּ וְכָל־בְּהֶמְתֵּ֑נוּ יִֽהְיוּ־שָׁ֖ם בְּעָרֵ֥י הַגִּלְעָֽד׃ ");
INSERT INTO hbo_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","וַעֲבָדֶ֨יךָ יַֽעַבְר֜וּ כָּל־חֲל֥וּץ צָבָ֛א לִפְנֵ֥י יְהוָ֖ה לַמִּלְחָמָ֑ה כַּאֲשֶׁ֥ר אֲדֹנִ֖י דֹּבֵֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","וַיְצַ֤ו לָהֶם֙ מֹשֶׁ֔ה אֵ֚ת אֶלְעָזָ֣ר הַכֹּהֵ֔ן וְאֵ֖ת יְהֹושֻׁ֣עַ בִּן־נ֑וּן וְאֶת־רָאשֵׁ֛י אֲבֹ֥ות הַמַּטֹּ֖ות לִבְנֵ֥י יִשְׂרָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","וַיֹּ֨אמֶר מֹשֶׁ֜ה אֲלֵהֶ֗ם אִם־יַעַבְר֣וּ בְנֵי־גָ֣ד וּבְנֵי־רְאוּבֵ֣ן ׀ אִ֠תְּכֶם אֶֽת־הַיַּרְדֵּ֞ן כָּל־חָל֤וּץ לַמִּלְחָמָה֙ לִפְנֵ֣י יְהוָ֔ה וְנִכְבְּשָׁ֥ה הָאָ֖רֶץ לִפְנֵיכֶ֑ם וּנְתַתֶּ֥ם לָהֶ֛ם אֶת־אֶ֥רֶץ הַגִּלְעָ֖ד לַאֲחֻזָּֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","וְאִם־לֹ֧א יֽ͏ַעַבְר֛וּ חֲלוּצִ֖ים אִתְּכֶ֑ם וְנֹֽאחֲז֥וּ בְתֹכְכֶ֖ם בְּאֶ֥רֶץ כְּנָֽעַן׃ ");
INSERT INTO hbo_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","וַיַּֽעֲנ֧וּ בְנֵי־גָ֛ד וּבְנֵ֥י רְאוּבֵ֖ן לֵאמֹ֑ר אֵת֩ אֲשֶׁ֨ר דִּבֶּ֧ר יְהוָ֛ה אֶל־עֲבָדֶ֖יךָ כֵּ֥ן נַעֲשֶֽׂה׃ ");
INSERT INTO hbo_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","נַ֣חְנוּ נַעֲבֹ֧ר חֲלוּצִ֛ים לִפְנֵ֥י יְהוָ֖ה אֶ֣רֶץ כְּנָ֑עַן וְאִתָּ֙נוּ֙ אֲחֻזַּ֣ת נַחֲלָתֵ֔נוּ מֵעֵ֖בֶר לַיַּרְדֵּֽן׃ ");
INSERT INTO hbo_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","וַיִּתֵּ֣ן לָהֶ֣ם ׀ מֹשֶׁ֡ה לִבְנֵי־גָד֩ וְלִבְנֵ֨י רְאוּבֵ֜ן וְלַחֲצִ֣י ׀ שֵׁ֣בֶט ׀ מְנַשֶּׁ֣ה בֶן־יֹוסֵ֗ף אֶת־מַמְלֶ֙כֶת֙ סִיחֹן֙ מֶ֣לֶךְ הָֽאֱמֹרִ֔י וְאֶת־מַמְלֶ֔כֶת עֹ֖וג מֶ֣לֶךְ הַבָּשָׁ֑ן הָאָ֗רֶץ לְעָרֶ֙יהָ֙ בִּגְבֻלֹ֔ת עָרֵ֥י הָאָ֖רֶץ סָבִֽיב׃ ");
INSERT INTO hbo_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","וַיִּבְנ֣וּ בְנֵי־גָ֔ד אֶת־דִּיבֹ֖ן וְאֶת־עֲטָרֹ֑ת וְאֵ֖ת עֲרֹעֵֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","וְאֶת־עַטְרֹ֥ת שֹׁופָ֛ן וְאֶת־יַעְזֵ֖ר וְיָגְבֳּהָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","וְאֶת־בֵּ֥ית נִמְרָ֖ה וְאֶת־בֵּ֣ית הָרָ֑ן עָרֵ֥י מִבְצָ֖ר וְגִדְרֹ֥ת צֹֽאן׃ ");
INSERT INTO hbo_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","וּבְנֵ֤י רְאוּבֵן֙ בָּנ֔וּ אֶת־חֶשְׁבֹּ֖ון וְאֶת־אֶלְעָלֵ֑א וְאֵ֖ת קִרְיָתָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","וְאֶת־נְבֹ֞ו וְאֶת־בַּ֧עַל מְעֹ֛ון מֽוּסַבֹּ֥ת שֵׁ֖ם וְאֶת־שִׂבְמָ֑ה וַיִּקְרְא֣וּ בְשֵׁמֹ֔ת אֶת־שְׁמֹ֥ות הֶעָרִ֖ים אֲשֶׁ֥ר בָּנֽוּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","וַיֵּ֨לְכ֜וּ בְּנֵ֨י מָכִ֧יר בֶּן־מְנַשֶּׁ֛ה גִּלְעָ֖דָה וַֽיִּלְכְּדֻ֑הָ וַיֹּ֖ורֶשׁ אֶת־הָאֱמֹרִ֥י אֲשֶׁר־בָּֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","וַיִּתֵּ֤ן מֹשֶׁה֙ אֶת־הַגִּלְעָ֔ד לְמָכִ֖יר בֶּן־מְנַשֶּׁ֑ה וַיֵּ֖שֶׁב בָּֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","וְיָאִ֤יר בֶּן־מְנַשֶּׁה֙ הָלַ֔ךְ וַיִּלְכֹּ֖ד אֶת־חַוֹּתֵיהֶ֑ם וַיִּקְרָ֥א אֶתְהֶ֖ן חַוֹּ֥ת יָאִֽיר׃ ");
INSERT INTO hbo_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","וְנֹ֣בַח הָלַ֔ךְ וַיִּלְכֹּ֥ד אֶת־קְנָ֖ת וְאֶת־בְּנֹתֶ֑יהָ וַיִּקְרָ֧א לָ֦ה נֹ֖בַח בִּשְׁמֹֽו׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","אֵ֜לֶּה מַסְעֵ֣י בְנֵֽי־יִשְׂרָאֵ֗ל אֲשֶׁ֥ר יָצְא֛וּ מֵאֶ֥רֶץ מִצְרַ֖יִם לְצִבְאֹתָ֑ם בְּיַד־מֹשֶׁ֖ה וְאַהֲרֹֽן׃ ");
INSERT INTO hbo_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","וַיִּכְתֹּ֨ב מֹשֶׁ֜ה אֶת־מֹוצָאֵיהֶ֛ם לְמַסְעֵיהֶ֖ם עַל־פִּ֣י יְהוָ֑ה וְאֵ֥לֶּה מַסְעֵיהֶ֖ם לְמֹוצָאֵיהֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","וַיִּסְע֤וּ מֵֽרַעְמְסֵס֙ בַּחֹ֣דֶשׁ הָרִאשֹׁ֔ון בַּחֲמִשָּׁ֥ה עָשָׂ֛ר יֹ֖ום לַחֹ֣דֶשׁ הָרִאשֹׁ֑ון מִֽמָּחֳרַ֣ת הַפֶּ֗סַח יָצְא֤וּ בְנֵֽי־יִשְׂרָאֵל֙ בְּיָ֣ד רָמָ֔ה לְעֵינֵ֖י כָּל־מִצְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","וּמִצְרַ֣יִם מְקַבְּרִ֗ים אֵת֩ אֲשֶׁ֨ר הִכָּ֧ה יְהוָ֛ה בָּהֶ֖ם כָּל־בְּכֹ֑ור וּבֵאלֹ֣הֵיהֶ֔ם עָשָׂ֥ה יְהוָ֖ה שְׁפָטִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","וַיִּסְע֥וּ בְנֵֽי־יִשְׂרָאֵ֖ל מֵרַעְמְסֵ֑ס וַֽיַּחֲנ֖וּ בְּסֻכֹּֽת׃ ");
INSERT INTO hbo_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","וַיִּסְע֖וּ מִסֻּכֹּ֑ת וַיַּחֲנ֣וּ בְאֵתָ֔ם אֲשֶׁ֖ר בִּקְצֵ֥ה הַמִּדְבָּֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","וַיִּסְעוּ֙ מֵֽאֵתָ֔ם וַיָּ֙שָׁב֙ עַל־פִּ֣י הַחִירֹ֔ת אֲשֶׁ֥ר עַל־פְּנֵ֖י בַּ֣עַל צְפֹ֑ון וַֽיַּחֲנ֖וּ לִפְנֵ֥י מִגְדֹּֽל׃ ");
INSERT INTO hbo_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","וַיִּסְעוּ֙ מִפְּנֵ֣י הַֽחִירֹ֔ת וַיַּֽעַבְר֥וּ בְתֹוךְ־הַיָּ֖ם הַמִּדְבָּ֑רָה וַיֵּ֨לְכ֜וּ דֶּ֣רֶךְ שְׁלֹ֤שֶׁת יָמִים֙ בְּמִדְבַּ֣ר אֵתָ֔ם וַֽיַּחֲנ֖וּ בְּמָרָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","וַיִּסְעוּ֙ מִמָּרָ֔ה וַיָּבֹ֖אוּ אֵילִ֑מָה וּ֠בְאֵילִם שְׁתֵּ֣ים עֶשְׂרֵ֞ה עֵינֹ֥ת מַ֛יִם וְשִׁבְעִ֥ים תְּמָרִ֖ים וַיַּחֲנוּ־שָֽׁם׃ ");
INSERT INTO hbo_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","וַיִּסְע֖וּ מֵאֵילִ֑ם וַֽיַּחֲנ֖וּ עַל־יַם־סֽוּף׃ ");
INSERT INTO hbo_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","וַיִּסְע֖וּ מִיַּם־ס֑וּף וַֽיַּחֲנ֖וּ בְּמִדְבַּר־סִֽין׃ ");
INSERT INTO hbo_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","וַיִּסְע֖וּ מִמִּדְבַּר־סִ֑ין וַֽיַּחֲנ֖וּ בְּדָפְקָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","וַיִּסְע֖וּ מִדָּפְקָ֑ה וַֽיַּחֲנ֖וּ בְּאָלֽוּשׁ׃ ");
INSERT INTO hbo_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","וַיִּסְע֖וּ מֵאָל֑וּשׁ וַֽיַּחֲנוּ֙ בִּרְפִידִ֔ם וְלֹא־הָ֨יָה שָׁ֥ם מַ֛יִם לָעָ֖ם לִשְׁתֹּֽות׃ ");
INSERT INTO hbo_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","וַיִּסְע֖וּ מֵרְפִידִ֑ם וַֽיַּחֲנ֖וּ בְּמִדְבַּ֥ר סִינָֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","וַיִּסְע֖וּ מִמִּדְבַּ֣ר סִינָ֑י וַֽיַּחֲנ֖וּ בְּקִבְרֹ֥ת הַֽתַּאֲוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","וַיִּסְע֖וּ מִקִּבְרֹ֣ת הַֽתַּאֲוָ֑ה וַֽיַּחֲנ֖וּ בַּחֲצֵרֹֽת׃ ");
INSERT INTO hbo_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","וַיִּסְע֖וּ מֵחֲצֵרֹ֑ת וַֽיַּחֲנ֖וּ בְּרִתְמָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","וַיִּסְע֖וּ מֵרִתְמָ֑ה וַֽיַּחֲנ֖וּ בְּרִמֹּ֥ן פָּֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","וַיִּסְע֖וּ מֵרִמֹּ֣ן פָּ֑רֶץ וַֽיַּחֲנ֖וּ בְּלִבְנָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","וַיִּסְע֖וּ מִלִּבְנָ֑ה וַֽיַּחֲנ֖וּ בְּרִסָּֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","וַיִּסְע֖וּ מֵרִסָּ֑ה וַֽיַּחֲנ֖וּ בִּקְהֵלָֽתָה׃ ");
INSERT INTO hbo_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","וַיִּסְע֖וּ מִקְּהֵלָ֑תָה וַֽיַּחֲנ֖וּ בְּהַר־שָֽׁפֶר׃ ");
INSERT INTO hbo_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","וַיִּסְע֖וּ מֵֽהַר־שָׁ֑פֶר וַֽיַּחֲנ֖וּ בַּחֲרָדָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","וַיִּסְע֖וּ מֵחֲרָדָ֑ה וַֽיַּחֲנ֖וּ בְּמַקְהֵלֹֽת׃ ");
INSERT INTO hbo_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","וַיִּסְע֖וּ מִמַּקְהֵלֹ֑ת וַֽיַּחֲנ֖וּ בְּתָֽחַת׃ ");
INSERT INTO hbo_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","וַיִּסְע֖וּ מִתָּ֑חַת וַֽיַּחֲנ֖וּ בְּתָֽרַח׃ ");
INSERT INTO hbo_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","וַיִּסְע֖וּ מִתָּ֑רַח וַֽיַּחֲנ֖וּ בְּמִתְקָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","וַיִּסְע֖וּ מִמִּתְקָ֑ה וַֽיַּחֲנ֖וּ בְּחַשְׁמֹנָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","וַיִּסְע֖וּ מֵֽחַשְׁמֹנָ֑ה וַֽיַּחֲנ֖וּ בְּמֹסֵרֹֽות׃ ");
INSERT INTO hbo_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","וַיִּסְע֖וּ מִמֹּסֵרֹ֑ות וַֽיַּחֲנ֖וּ בִּבְנֵ֥י יַעֲקָֽן׃ ");
INSERT INTO hbo_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","וַיִּסְע֖וּ מִבְּנֵ֣י יַעֲקָ֑ן וַֽיַּחֲנ֖וּ בְּחֹ֥ר הַגִּדְגָּֽד׃ ");
INSERT INTO hbo_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","וַיִּסְע֖וּ מֵחֹ֣ר הַגִּדְגָּ֑ד וַֽיַּחֲנ֖וּ בְּיָטְבָֽתָה׃ ");
INSERT INTO hbo_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","וַיִּסְע֖וּ מִיָּטְבָ֑תָה וַֽיַּחֲנ֖וּ בְּעַבְרֹנָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","וַיִּסְע֖וּ מֵֽעַבְרֹנָ֑ה וַֽיַּחֲנ֖וּ בְּעֶצְיֹ֥ון גָּֽבֶר׃ ");
INSERT INTO hbo_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","וַיִּסְע֖וּ מֵעֶצְיֹ֣ון גָּ֑בֶר וַיַּחֲנ֥וּ בְמִדְבַּר־צִ֖ן הִ֥וא קָדֵֽשׁ׃ ");
INSERT INTO hbo_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","וַיִּסְע֖וּ מִקָּדֵ֑שׁ וַֽיַּחֲנוּ֙ בְּהֹ֣ר הָהָ֔ר בִּקְצֵ֖ה אֶ֥רֶץ אֱדֹֽום׃ ");
INSERT INTO hbo_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","וַיַּעַל֩ אַהֲרֹ֨ן הַכֹּהֵ֜ן אֶל־הֹ֥ר הָהָ֛ר עַל־פִּ֥י יְהוָ֖ה וַיָּ֣מָת שָׁ֑ם בִּשְׁנַ֣ת הָֽאַרְבָּעִ֗ים לְצֵ֤את בְּנֵֽי־יִשְׂרָאֵל֙ מֵאֶ֣רֶץ מִצְרַ֔יִם בַּחֹ֥דֶשׁ הַחֲמִישִׁ֖י בְּאֶחָ֥ד לַחֹֽדֶשׁ׃ ");
INSERT INTO hbo_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","וְאַהֲרֹ֔ן בֶּן־שָׁלֹ֧שׁ וְעֶשְׂרִ֛ים וּמְאַ֖ת שָׁנָ֑ה בְּמֹתֹ֖ו בְּהֹ֥ר הָהָֽר׃ ס ");
INSERT INTO hbo_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","וַיִּשְׁמַ֗ע הַֽכְּנַעֲנִי֙ מֶ֣לֶךְ עֲרָ֔ד וְהֽוּא־יֹשֵׁ֥ב בַּנֶּ֖גֶב בְּאֶ֣רֶץ כְּנָ֑עַן בְּבֹ֖א בְּנֵ֥י יִשְׂרָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","וַיִּסְע֖וּ מֵהֹ֣ר הָהָ֑ר וַֽיַּחֲנ֖וּ בְּצַלְמֹנָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","וַיִּסְע֖וּ מִצַּלְמֹנָ֑ה וַֽיַּחֲנ֖וּ בְּפוּנֹֽן׃ ");
INSERT INTO hbo_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","וַיִּסְע֖וּ מִפּוּנֹ֑ן וַֽיַּחֲנ֖וּ בְּאֹבֹֽת׃ ");
INSERT INTO hbo_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","וַיִּסְע֖וּ מֵאֹבֹ֑ת וַֽיַּחֲנ֛וּ בְּעִיֵּ֥י הָעֲבָרִ֖ים בִּגְב֥וּל מֹואָֽב׃ ");
INSERT INTO hbo_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","וַיִּסְע֖וּ מֵעִיִּ֑ים וַֽיַּחֲנ֖וּ בְּדִיבֹ֥ן גָּֽד׃ ");
INSERT INTO hbo_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","וַיִּסְע֖וּ מִדִּיבֹ֣ן גָּ֑ד וַֽיַּחֲנ֖וּ בְּעַלְמֹ֥ן דִּבְלָתָֽיְמָה׃ ");
INSERT INTO hbo_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","וַיִּסְע֖וּ מֵעַלְמֹ֣ן דִּבְלָתָ֑יְמָה וַֽיַּחֲנ֛וּ בְּהָרֵ֥י הָעֲבָרִ֖ים לִפְנֵ֥י נְבֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","וַיִּסְע֖וּ מֵהָרֵ֣י הָעֲבָרִ֑ים וַֽיַּחֲנוּ֙ בְּעַֽרְבֹ֣ת מֹואָ֔ב עַ֖ל יַרְדֵּ֥ן יְרֵחֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","וַיַּחֲנ֤וּ עַל־הַיַּרְדֵּן֙ מִבֵּ֣ית הַיְשִׁמֹ֔ת עַ֖ד אָבֵ֣ל הַשִּׁטִּ֑ים בְּעַֽרְבֹ֖ת מֹואָֽב׃ ס ");
INSERT INTO hbo_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","וַיְדַבֵּ֧ר יְהוָ֛ה אֶל־מֹשֶׁ֖ה בְּעַֽרְבֹ֣ת מֹואָ֑ב עַל־יַרְדֵּ֥ן יְרֵחֹ֖ו לֵאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","דַּבֵּר֙ אֶל־בְּנֵ֣י יִשְׂרָאֵ֔ל וְאָמַרְתָּ֖ אֲלֵהֶ֑ם כִּ֥י אַתֶּ֛ם עֹבְרִ֥ים אֶת־הַיַּרְדֵּ֖ן אֶל־אֶ֥רֶץ כְּנָֽעַן׃ ");
INSERT INTO hbo_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","וְהֹ֨ורַשְׁתֶּ֜ם אֶת־כָּל־יֹשְׁבֵ֤י הָאָ֙רֶץ֙ מִפְּנֵיכֶ֔ם וְאִ֨בַּדְתֶּ֔ם אֵ֖ת כָּל־מַשְׂכִּיֹּתָ֑ם וְאֵ֨ת כָּל־צַלְמֵ֤י מַסֵּֽכֹתָם֙ תְּאַבֵּ֔דוּ וְאֵ֥ת כָּל־בָּמֹתָ֖ם תַּשְׁמִֽידוּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","וְהֹורַשְׁתֶּ֥ם אֶת־הָאָ֖רֶץ וִֽישַׁבְתֶּם־בָּ֑הּ כִּ֥י לָכֶ֛ם נָתַ֥תִּי אֶת־הָאָ֖רֶץ לָרֶ֥שֶׁת אֹתָֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","וְהִתְנַחַלְתֶּם֩ אֶת־הָאָ֨רֶץ בְּגֹורָ֜ל לְמִשְׁפְּחֹֽתֵיכֶ֗ם לָרַ֞ב תַּרְבּ֤וּ אֶת־נַחֲלָתֹו֙ וְלַמְעַט֙ תַּמְעִ֣יט אֶת־נַחֲלָתֹ֔ו אֶל֩ אֲשֶׁר־יֵ֨צֵא לֹ֥ו שָׁ֛מָּה הַגֹּורָ֖ל לֹ֣ו יִהְיֶ֑ה לְמַטֹּ֥ות אֲבֹתֵיכֶ֖ם תִּתְנֶחָֽלוּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","וְאִם־לֹ֨א תֹורִ֜ישׁוּ אֶת־יֹשְׁבֵ֣י הָאָרֶץ֮ מִפְּנֵיכֶם֒ וְהָיָה֙ אֲשֶׁ֣ר תֹּותִ֣ירוּ מֵהֶ֔ם לְשִׂכִּים֙ בְּעֵ֣ינֵיכֶ֔ם וְלִצְנִינִ֖ם בְּצִדֵּיכֶ֑ם וְצָרֲר֣וּ אֶתְכֶ֔ם עַל־הָאָ֕רֶץ אֲשֶׁ֥ר אַתֶּ֖ם יֹשְׁבִ֥ים בָּֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","וְהָיָ֗ה כַּאֲשֶׁ֥ר דִּמִּ֛יתִי לַעֲשֹׂ֥ות לָהֶ֖ם אֽ͏ֶעֱשֶׂ֥ה לָכֶֽם׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","צַ֞ו אֶת־בְּנֵ֤י יִשְׂרָאֵל֙ וְאָמַרְתָּ֣ אֲלֵהֶ֔ם כִּֽי־אַתֶּ֥ם בָּאִ֖ים אֶל־הָאָ֣רֶץ כְּנָ֑עַן זֹ֣את הָאָ֗רֶץ אֲשֶׁ֨ר תִּפֹּ֤ל לָכֶם֙ בְּֽנַחֲלָ֔ה אֶ֥רֶץ כְּנַ֖עַן לִגְבֻלֹתֶֽיהָ׃ ");
INSERT INTO hbo_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","וְהָיָ֨ה לָכֶ֧ם פְּאַת־נֶ֛גֶב מִמִּדְבַּר־צִ֖ן עַל־יְדֵ֣י אֱדֹ֑ום וְהָיָ֤ה לָכֶם֙ גְּב֣וּל נֶ֔גֶב מִקְצֵ֥ה יָם־הַמֶּ֖לַח קֵֽדְמָה׃ ");
INSERT INTO hbo_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","וְנָסַ֣ב לָכֶם֩ הַגְּב֨וּל מִנֶּ֜גֶב לְמַעֲלֵ֤ה עַקְרַבִּים֙ וְעָ֣בַר צִ֔נָה *וְהָיָה (וְהָיוּ֙) תֹּֽוצְאֹתָ֔יו מִנֶּ֖גֶב לְקָדֵ֣שׁ בַּרְנֵ֑עַ וְיָצָ֥א חֲצַר־אַדָּ֖ר וְעָבַ֥ר עַצְמֹֽנָה׃ ");
INSERT INTO hbo_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","וְנָסַ֧ב הַגְּב֛וּל מֵעַצְמֹ֖ון נַ֣חְלָה מִצְרָ֑יִם וְהָי֥וּ תֹוצְאֹתָ֖יו הַיָּֽמָּה׃ ");
INSERT INTO hbo_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","וּגְב֣וּל יָ֔ם וְהָיָ֥ה לָכֶ֛ם הַיָּ֥ם הַגָּדֹ֖ול וּגְב֑וּל זֶֽה־יִהְיֶ֥ה לָכֶ֖ם גְּב֥וּל יָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","וְזֶֽה־יִהְיֶ֥ה לָכֶ֖ם גְּב֣וּל צָפֹ֑ון מִן־הַיָּם֙ הַגָּדֹ֔ל תְּתָא֥וּ לָכֶ֖ם הֹ֥ר הָהָֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","מֵהֹ֣ר הָהָ֔ר תְּתָא֖וּ לְבֹ֣א חֲמָ֑ת וְהָי֛וּ תֹּוצְאֹ֥ת הַגְּבֻ֖ל צְדָֽדָה׃ ");
INSERT INTO hbo_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","וְיָצָ֤א הַגְּבֻל֙ זִפְרֹ֔נָה וְהָי֥וּ תֹוצְאֹתָ֖יו חֲצַ֣ר עֵינָ֑ן זֶֽה־יִהְיֶ֥ה לָכֶ֖ם גְּב֥וּל צָפֹֽון׃ ");
INSERT INTO hbo_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","וְהִתְאַוִּיתֶ֥ם לָכֶ֖ם לִגְב֣וּל קֵ֑דְמָה מֵחֲצַ֥ר עֵינָ֖ן שְׁפָֽמָה׃ ");
INSERT INTO hbo_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","וְיָרַ֨ד הַגְּבֻ֧ל מִשְּׁפָ֛ם הָרִבְלָ֖ה מִקֶּ֣דֶם לָעָ֑יִן וְיָרַ֣ד הַגְּב֔וּל וּמָחָ֛ה עַל־כֶּ֥תֶף יָם־כִּנֶּ֖רֶת קֵֽדְמָה׃ ");
INSERT INTO hbo_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","וְיָרַ֤ד הַגְּבוּל֙ הַיַּרְדֵּ֔נָה וְהָי֥וּ תֹוצְאֹתָ֖יו יָ֣ם הַמֶּ֑לַח זֹאת֩ תִּהְיֶ֨ה לָכֶ֥ם הָאָ֛רֶץ לִגְבֻלֹתֶ֖יהָ סָבִֽיב׃ ");
INSERT INTO hbo_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","וַיְצַ֣ו מֹשֶׁ֔ה אֶת־בְּנֵ֥י יִשְׂרָאֵ֖ל לֵאמֹ֑ר זֹ֣את הָאָ֗רֶץ אֲשֶׁ֨ר תִּתְנַחֲל֤וּ אֹתָהּ֙ בְּגֹורָ֔ל אֲשֶׁר֙ צִוָּ֣ה יְהוָ֔ה לָתֵ֛ת לְתִשְׁעַ֥ת הַמַּטֹּ֖ות וַחֲצִ֥י הַמַּטֶּֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","כִּ֣י לָקְח֞וּ מַטֵּ֨ה בְנֵ֤י הָראוּבֵנִי֙ לְבֵ֣ית אֲבֹתָ֔ם וּמַטֵּ֥ה בְנֵֽי־הַגָּדִ֖י לְבֵ֣ית אֲבֹתָ֑ם וַחֲצִי֙ מַטֵּ֣ה מְנַשֶּׁ֔ה לָקְח֖וּ נַחֲלָתָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","שְׁנֵ֥י הַמַּטֹּ֖ות וַחֲצִ֣י הַמַּטֶּ֑ה לָקְח֣וּ נַחֲלָתָ֗ם מֵעֵ֛בֶר לְיַרְדֵּ֥ן יְרֵחֹ֖ו קֵ֥דְמָה מִזְרָֽחָה׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","אֵ֚לֶּה שְׁמֹ֣ות הָֽאֲנָשִׁ֔ים אֲשֶׁר־יִנְחֲל֥וּ לָכֶ֖ם אֶת־הָאָ֑רֶץ אֶלְעָזָר֙ הַכֹּהֵ֔ן וִיהֹושֻׁ֖עַ בִּן־נֽוּן׃ ");
INSERT INTO hbo_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","וְנָשִׂ֥יא אֶחָ֛ד נָשִׂ֥יא אֶחָ֖ד מִמַּטֶּ֑ה תִּקְח֖וּ לִנְחֹ֥ל אֶת־הָאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","וְאֵ֖לֶּה שְׁמֹ֣ות הָאֲנָשִׁ֑ים לְמַטֵּ֣ה יְהוּדָ֔ה כָּלֵ֖ב בֶּן־יְפֻנֶּֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","וּלְמַטֵּה֙ בְּנֵ֣י שִׁמְעֹ֔ון שְׁמוּאֵ֖ל בֶּן־עַמִּיהֽוּד׃ ");
INSERT INTO hbo_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","לְמַטֵּ֣ה בִנְיָמִ֔ן אֱלִידָ֖ד בֶּן־כִּסְלֹֽון׃ ");
INSERT INTO hbo_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","וּלְמַטֵּ֥ה בְנֵי־דָ֖ן נָשִׂ֑יא בֻּקִּ֖י בֶּן־יָגְלִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","לִבְנֵ֣י יֹוסֵ֔ף לְמַטֵּ֥ה בְנֵֽי־מְנַשֶּׁ֖ה נָשִׂ֑יא חַנִּיאֵ֖ל בֶּן־אֵפֹֽד׃ ");
INSERT INTO hbo_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","וּלְמַטֵּ֥ה בְנֵֽי־אֶפְרַ֖יִם נָשִׂ֑יא קְמוּאֵ֖ל בֶּן־שִׁפְטָֽן׃ ");
INSERT INTO hbo_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","וּלְמַטֵּ֥ה בְנֵֽי־זְבוּלֻ֖ן נָשִׂ֑יא אֱלִיצָפָ֖ן בֶּן־פַּרְנָֽךְ׃ ");
INSERT INTO hbo_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","וּלְמַטֵּ֥ה בְנֵֽי־יִשָׂשכָ֖ר נָשִׂ֑יא פַּלְטִיאֵ֖ל בֶּן־עַזָּֽן׃ ");
INSERT INTO hbo_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","וּלְמַטֵּ֥ה בְנֵי־אָשֵׁ֖ר נָשִׂ֑יא אֲחִיה֖וּד בֶּן־שְׁלֹמִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","וּלְמַטֵּ֥ה בְנֵֽי־נַפְתָּלִ֖י נָשִׂ֑יא פְּדַהְאֵ֖ל בֶּן־עַמִּיהֽוּד׃ ");
INSERT INTO hbo_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","אֵ֕לֶּה אֲשֶׁ֖ר צִוָּ֣ה יְהוָ֑ה לְנַחֵ֥ל אֶת־בְּנֵֽי־יִשְׂרָאֵ֖ל בְּאֶ֥רֶץ כְּנָֽעַן׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","וַיְדַבֵּ֧ר יְהוָ֛ה אֶל־מֹשֶׁ֖ה בְּעַֽרְבֹ֣ת מֹואָ֑ב עַל־יַרְדֵּ֥ן יְרֵחֹ֖ו לֵאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","צַו֮ אֶת־בְּנֵ֣י יִשְׂרָאֵל֒ וְנָתְנ֣וּ לַלְוִיִּ֗ם מִֽנַּחֲלַ֛ת אֲחֻזָּתָ֖ם עָרִ֣ים לָשָׁ֑בֶת וּמִגְרָ֗שׁ לֶֽעָרִים֙ סְבִיבֹ֣תֵיהֶ֔ם תִּתְּנ֖וּ לַלְוִיִּֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","וְהָי֧וּ הֽ͏ֶעָרִ֛ים לָהֶ֖ם לָשָׁ֑בֶת וּמִגְרְשֵׁיהֶ֗ם יִהְי֤וּ לִבְהֶמְתָּם֙ וְלִרְכֻשָׁ֔ם וּלְכֹ֖ל חַיָּתָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","וּמִגְרְשֵׁי֙ הֶֽעָרִ֔ים אֲשֶׁ֥ר תִּתְּנ֖וּ לַלְוִיִּ֑ם מִקִּ֤יר הָעִיר֙ וָח֔וּצָה אֶ֥לֶף אַמָּ֖ה סָבִֽיב׃ ");
INSERT INTO hbo_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","וּמַדֹּתֶ֞ם מִח֣וּץ לָעִ֗יר אֶת־פְּאַת־קֵ֣דְמָה אַלְפַּ֪יִם בָּֽאַמָּ֟ה וְאֶת־פְּאַת־נֶגֶב֩ אַלְפַּ֨יִם בָּאַמָּ֜ה וְאֶת־פְּאַת־יָ֣ם ׀ אַלְפַּ֣יִם בָּֽאַמָּ֗ה וְאֵ֨ת פְּאַ֥ת צָפֹ֛ון אַלְפַּ֥יִם בָּאַמָּ֖ה וְהָעִ֣יר בַּתָּ֑וֶךְ זֶ֚ה יִהְיֶ֣ה לָהֶ֔ם מִגְרְשֵׁ֖י הֶעָרִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","וְאֵ֣ת הֶֽעָרִ֗ים אֲשֶׁ֤ר תִּתְּנוּ֙ לַלְוִיִּ֔ם אֵ֚ת שֵׁשׁ־עָרֵ֣י הַמִּקְלָ֔ט אֲשֶׁ֣ר תִּתְּנ֔וּ לָנֻ֥ס שָׁ֖מָּה הָרֹצֵ֑חַ וַעֲלֵיהֶ֣ם תִּתְּנ֔וּ אַרְבָּעִ֥ים וּשְׁתַּ֖יִם עִֽיר׃ ");
INSERT INTO hbo_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","כָּל־הֶעָרִ֗ים אֲשֶׁ֤ר תִּתְּנוּ֙ לַלְוִיִּ֔ם אַרְבָּעִ֥ים וּשְׁמֹנֶ֖ה עִ֑יר אֶתְהֶ֖ן וְאֶת־מִגְרְשֵׁיהֶֽן׃ ");
INSERT INTO hbo_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","וְהֶֽעָרִ֗ים אֲשֶׁ֤ר תִּתְּנוּ֙ מֵאֲחֻזַּ֣ת בְּנֵי־יִשְׂרָאֵ֔ל מֵאֵ֤ת הָרַב֙ תַּרְבּ֔וּ וּמֵאֵ֥ת הַמְעַ֖ט תַּמְעִ֑יטוּ אִ֗ישׁ כְּפִ֤י נַחֲלָתֹו֙ אֲשֶׁ֣ר יִנְחָ֔לוּ יִתֵּ֥ן מֵעָרָ֖יו לַלְוִיִּֽם׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","וַיְדַבֵּ֥ר יְהוָ֖ה אֶל־מֹשֶׁ֥ה לֵּאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","דַּבֵּר֙ אֶל־בְּנֵ֣י יִשְׂרָאֵ֔ל וְאָמַרְתָּ֖ אֲלֵהֶ֑ם כִּ֥י אַתֶּ֛ם עֹבְרִ֥ים אֶת־הַיַּרְדֵּ֖ן אַ֥רְצָה כְּנָֽעַן׃ ");
INSERT INTO hbo_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","וְהִקְרִיתֶ֤ם לָכֶם֙ עָרִ֔ים עָרֵ֥י מִקְלָ֖ט תִּהְיֶ֣ינָה לָכֶ֑ם וְנָ֥ס שָׁ֙מָּה֙ רֹצֵ֔חַ מַכֵּה־נֶ֖פֶשׁ בִּשְׁגָגָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","וְהָי֨וּ לָכֶ֧ם הֶעָרִ֛ים לְמִקְלָ֖ט מִגֹּאֵ֑ל וְלֹ֤א יָמוּת֙ הָרֹצֵ֔חַ עַד־עָמְדֹ֛ו לִפְנֵ֥י הָעֵדָ֖ה לַמִּשְׁפָּֽט׃ ");
INSERT INTO hbo_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","וְהֶעָרִ֖ים אֲשֶׁ֣ר תִּתֵּ֑נוּ שֵׁשׁ־עָרֵ֥י מִקְלָ֖ט תִּהְיֶ֥ינָה לָכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","אֵ֣ת ׀ שְׁלֹ֣שׁ הֶעָרִ֗ים תִּתְּנוּ֙ מֵעֵ֣בֶר לַיַּרְדֵּ֔ן וְאֵת֙ שְׁלֹ֣שׁ הֶֽעָרִ֔ים תִּתְּנ֖וּ בְּאֶ֣רֶץ כְּנָ֑עַן עָרֵ֥י מִקְלָ֖ט תִּהְיֶֽינָה׃ ");
INSERT INTO hbo_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","לִבְנֵ֣י יִשְׂרָאֵ֗ל וְלַגֵּ֤ר וְלַתֹּושָׁב֙ בְּתֹוכָ֔ם תִּהְיֶ֛ינָה שֵׁשׁ־הֶעָרִ֥ים הָאֵ֖לֶּה לְמִקְלָ֑ט לָנ֣וּס שָׁ֔מָּה כָּל־מַכֵּה־נֶ֖פֶשׁ בִּשְׁגָגָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","וְאִם־בִּכְלִ֨י בַרְזֶ֧ל ׀ הִכָּ֛הוּ וַיָּמֹ֖ת רֹצֵ֣חַֽ ה֑וּא מֹ֥ות יוּמַ֖ת הָרֹצֵֽחַ׃ ");
INSERT INTO hbo_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","וְאִ֡ם בְּאֶ֣בֶן יָד֩ אֲשֶׁר־יָמ֨וּת בָּ֥הּ הִכָּ֛הוּ וַיָּמֹ֖ת רֹצֵ֣חַֽ ה֑וּא מֹ֥ות יוּמַ֖ת הָרֹצֵֽחַ׃ ");
INSERT INTO hbo_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","אֹ֡ו בִּכְלִ֣י עֵֽץ־יָד֩ אֲשֶׁר־יָמ֨וּת בֹּ֥ו הִכָּ֛הוּ וַיָּמֹ֖ת רֹצֵ֣חַֽ ה֑וּא מֹ֥ות יוּמַ֖ת הָרֹצֵֽחַ׃ ");
INSERT INTO hbo_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","גֹּאֵ֣ל הַדָּ֔ם ה֥וּא יָמִ֖ית אֶת־הָרֹצֵ֑חַ בְּפִגְעֹו־בֹ֖ו ה֥וּא יְמִיתֶֽנּוּ׃ ");
INSERT INTO hbo_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","וְאִם־בְּשִׂנְאָ֖ה יֶהְדָּפֶ֑נּוּ אֹֽו־הִשְׁלִ֥יךְ עָלָ֛יו בִּצְדִיָּ֖ה וַיָּמֹֽת׃ ");
INSERT INTO hbo_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","אֹ֣ו בְאֵיבָ֞ה הִכָּ֤הוּ בְיָדֹו֙ וַיָּמֹ֔ת מֹֽות־יוּמַ֥ת הַמַּכֶּ֖ה רֹצֵ֣חַֽ ה֑וּא גֹּאֵ֣ל הַדָּ֗ם יָמִ֛ית אֶת־הָרֹצֵ֖חַ בְּפִגְעֹו־בֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","וְאִם־בְּפֶ֥תַע בְּלֹא־אֵיבָ֖ה הֲדָפֹ֑ו אֹו־הִשְׁלִ֥יךְ עָלָ֛יו כָּל־כְּלִ֖י בְּלֹ֥א צְדִיָּֽה׃ ");
INSERT INTO hbo_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","אֹ֣ו בְכָל־אֶ֜בֶן אֲשֶׁר־יָמ֥וּת בָּהּ֙ בְּלֹ֣א רְאֹ֔ות וַיַּפֵּ֥ל עָלָ֖יו וַיָּמֹ֑ת וְהוּא֙ לֹא־אֹויֵ֣ב לֹ֔ו וְלֹ֥א מְבַקֵּ֖שׁ רָעָתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","וְשָֽׁפְטוּ֙ הָֽעֵדָ֔ה בֵּ֚ין הַמַּכֶּ֔ה וּבֵ֖ין גֹּאֵ֣ל הַדָּ֑ם עַ֥ל הַמִּשְׁפָּטִ֖ים הָאֵֽלֶּה׃ ");
INSERT INTO hbo_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","וְהִצִּ֨ילוּ הָעֵדָ֜ה אֶת־הָרֹצֵ֗חַ מִיַּד֮ גֹּאֵ֣ל הַדָּם֒ וְהֵשִׁ֤יבוּ אֹתֹו֙ הָֽעֵדָ֔ה אֶל־עִ֥יר מִקְלָטֹ֖ו אֲשֶׁר־נָ֣ס שָׁ֑מָּה וְיָ֣שַׁב בָּ֗הּ עַד־מֹות֙ הַכֹּהֵ֣ן הַגָּדֹ֔ל אֲשֶׁר־מָשַׁ֥ח אֹתֹ֖ו בְּשֶׁ֥מֶן הַקֹּֽדֶשׁ׃ ");
INSERT INTO hbo_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","וְאִם־יָצֹ֥א יֵצֵ֖א הָרֹצֵ֑חַ אֶת־גְּבוּל֙ עִ֣יר מִקְלָטֹ֔ו אֲשֶׁ֥ר יָנ֖וּס שָֽׁמָּה׃ ");
INSERT INTO hbo_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","וּמָצָ֤א אֹתֹו֙ גֹּאֵ֣ל הַדָּ֔ם מִח֕וּץ לִגְב֖וּל עִ֣יר מִקְלָטֹ֑ו וְרָצַ֞ח גֹּאֵ֤ל הַדָּם֙ אֶת־הָ֣רֹצֵ֔חַ אֵ֥ין לֹ֖ו דָּֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","כִּ֣י בְעִ֤יר מִקְלָטֹו֙ יֵשֵׁ֔ב עַד־מֹ֖ות הַכֹּהֵ֣ן הַגָּדֹ֑ל וְאַחֲרֵ֥י מֹות֙ הַכֹּהֵ֣ן הַגָּדֹ֔ל יָשׁוּב֙ הָרֹצֵ֔חַ אֶל־אֶ֖רֶץ אֲחֻזָּתֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","וְהָי֨וּ אֵ֧לֶּה לָכֶ֛ם לְחֻקַּ֥ת מִשְׁפָּ֖ט לְדֹרֹתֵיכֶ֑ם בְּכֹ֖ל מֹושְׁבֹתֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","כָּל־מַ֨כֵּה־נֶ֔פֶשׁ לְפִ֣י עֵדִ֔ים יִרְצַ֖ח אֶת־הָרֹצֵ֑חַ וְעֵ֣ד אֶחָ֔ד לֹא־יַעֲנֶ֥ה בְנֶ֖פֶשׁ לָמֽוּת׃ ");
INSERT INTO hbo_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","וְלֹֽא־תִקְח֥וּ כֹ֙פֶר֙ לְנֶ֣פֶשׁ רֹצֵ֔חַ אֲשֶׁר־ה֥וּא רָשָׁ֖ע לָמ֑וּת כִּי־מֹ֖ות יוּמָֽת׃ ");
INSERT INTO hbo_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","וְלֹא־תִקְח֣וּ כֹ֔פֶר לָנ֖וּס אֶל־עִ֣יר מִקְלָטֹ֑ו לָשׁוּב֙ לָשֶׁ֣בֶת בָּאָ֔רֶץ עַד־מֹ֖ות הַכֹּהֵֽן׃ ");
INSERT INTO hbo_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","וְלֹא־תַחֲנִ֣יפוּ אֶת־הָאָ֗רֶץ אֲשֶׁ֤ר אַתֶּם֙ בָּ֔הּ כִּ֣י הַדָּ֔ם ה֥וּא יַחֲנִ֖יף אֶת־הָאָ֑רֶץ וְלָאָ֣רֶץ לֹֽא־יְכֻפַּ֗ר לַדָּם֙ אֲשֶׁ֣ר שֻׁפַּךְ־בָּ֔הּ כִּי־אִ֖ם בְּדַ֥ם שֹׁפְכֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","וְלֹ֧א תְטַמֵּ֣א אֶת־הָאָ֗רֶץ אֲשֶׁ֤ר אַתֶּם֙ יֹשְׁבִ֣ים בָּ֔הּ אֲשֶׁ֥ר אֲנִ֖י שֹׁכֵ֣ן בְּתֹוכָ֑הּ כִּ֚י אֲנִ֣י יְהוָ֔ה שֹׁכֵ֕ן בְּתֹ֖וךְ בְּנֵ֥י יִשְׂרָאֵֽל׃ פ ");
INSERT INTO hbo_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","וַֽיִּקְרְב֞וּ רָאשֵׁ֣י הָֽאָבֹ֗ות לְמִשְׁפַּ֤חַת בְּנֵֽי־גִלְעָד֙ בֶּן־מָכִ֣יר בֶּן־מְנַשֶּׁ֔ה מִֽמִּשְׁפְּחֹ֖ת בְּנֵ֣י יֹוסֵ֑ף וַֽיְדַבְּר֞וּ לִפְנֵ֤י מֹשֶׁה֙ וְלִפְנֵ֣י הַנְּשִׂאִ֔ים רָאשֵׁ֥י אָבֹ֖ות לִבְנֵ֥י יִשְׂרָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","וַיֹּאמְר֗וּ אֶת־אֲדֹנִי֙ צִוָּ֣ה יְהוָ֔ה לָתֵ֨ת אֶת־הָאָ֧רֶץ בְּנַחֲלָ֛ה בְּגֹורָ֖ל לִבְנֵ֣י יִשְׂרָאֵ֑ל וַֽאדֹנִי֙ צֻוָּ֣ה בַֽיהוָ֔ה לָתֵ֗ת אֶֽת־נַחֲלַ֛ת צְלָפְחָ֥ד אָחִ֖ינוּ לִבְנֹתָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","וְ֠הָיוּ לְאֶחָ֞ד מִבְּנֵ֨י שִׁבְטֵ֥י בְנֵֽי־יִשְׂרָאֵל֮ לְנָשִׁים֒ וְנִגְרְעָ֤ה נַחֲלָתָן֙ מִנַּחֲלַ֣ת אֲבֹתֵ֔ינוּ וְנֹוסַ֕ף עַ֚ל נַחֲלַ֣ת הַמַּטֶּ֔ה אֲשֶׁ֥ר תִּהְיֶ֖ינָה לָהֶ֑ם וּמִגֹּרַ֥ל נַחֲלָתֵ֖נוּ יִגָּרֵֽעַ׃ ");
INSERT INTO hbo_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","וְאִם־יִהְיֶ֣ה הַיֹּבֵל֮ לִבְנֵ֣י יִשְׂרָאֵל֒ וְנֹֽוסְפָה֙ נַחֲלָתָ֔ן עַ֚ל נַחֲלַ֣ת הַמַּטֶּ֔ה אֲשֶׁ֥ר תִּהְיֶ֖ינָה לָהֶ֑ם וּמִֽנַּחֲלַת֙ מַטֵּ֣ה אֲבֹתֵ֔ינוּ יִגָּרַ֖ע נַחֲלָתָֽן׃ ");
INSERT INTO hbo_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","וַיְצַ֤ו מֹשֶׁה֙ אֶת־בְּנֵ֣י יִשְׂרָאֵ֔ל עַל־פִּ֥י יְהוָ֖ה לֵאמֹ֑ר כֵּ֛ן מַטֵּ֥ה בְנֵֽי־יֹוסֵ֖ף דֹּבְרִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","זֶ֣ה הַדָּבָ֞ר אֲשֶׁר־צִוָּ֣ה יְהוָ֗ה לִבְנֹ֤ות צְלָפְחָד֙ לֵאמֹ֔ר לַטֹּ֥וב בְּעֵינֵיהֶ֖ם תִּהְיֶ֣ינָה לְנָשִׁ֑ים אַ֗ךְ לְמִשְׁפַּ֛חַת מַטֵּ֥ה אֲבִיהֶ֖ם תִּהְיֶ֥ינָה לְנָשִֽׁים׃ ");
INSERT INTO hbo_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","וְלֹֽא־תִסֹּ֤ב נַחֲלָה֙ לִבְנֵ֣י יִשְׂרָאֵ֔ל מִמַּטֶּ֖ה אֶל־מַטֶּ֑ה כִּ֣י אִ֗ישׁ בְּנַחֲלַת֙ מַטֵּ֣ה אֲבֹתָ֔יו יִדְבְּק֖וּ בְּנֵ֥י יִשְׂרָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","וְכָל־בַּ֞ת יֹרֶ֣שֶׁת נַחֲלָ֗ה מִמַּטֹּות֮ בְּנֵ֣י יִשְׂרָאֵל֒ לְאֶחָ֗ד מִמִּשְׁפַּ֛חַת מַטֵּ֥ה אָבִ֖יהָ תִּהְיֶ֣ה לְאִשָּׁ֑ה לְמַ֗עַן יִֽירְשׁוּ֙ בְּנֵ֣י יִשְׂרָאֵ֔ל אִ֖ישׁ נַחֲלַ֥ת אֲבֹתָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","וְלֹֽא־תִסֹּ֧ב נַחֲלָ֛ה מִמַּטֶּ֖ה לְמַטֶּ֣ה אַחֵ֑ר כִּי־אִישׁ֙ בְּנַ֣חֲלָתֹ֔ו יִדְבְּק֕וּ מַטֹּ֖ות בְּנֵ֥י יִשְׂרָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","כַּאֲשֶׁ֛ר צִוָּ֥ה יְהוָ֖ה אֶת־מֹשֶׁ֑ה כֵּ֥ן עָשׂ֖וּ בְּנֹ֥ות צְלָפְחָֽד׃ ");
INSERT INTO hbo_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","וַתִּהְיֶ֜ינָה מַחְלָ֣ה תִרְצָ֗ה וְחָגְלָ֧ה וּמִלְכָּ֛ה וְנֹעָ֖ה בְּנֹ֣ות צְלָפְחָ֑ד לִבְנֵ֥י דֹדֵיהֶ֖ן לְנָשִֽׁים׃ ");
INSERT INTO hbo_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","מִֽמִּשְׁפְּחֹ֛ת בְּנֵֽי־מְנַשֶּׁ֥ה בֶן־יֹוסֵ֖ף הָי֣וּ לְנָשִׁ֑ים וַתְּהִי֙ נַחֲלָתָ֔ן עַל־מַטֵּ֖ה מִשְׁפַּ֥חַת אֲבִיהֶֽן׃ ");
INSERT INTO hbo_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","אֵ֣לֶּה הַמִּצְוֹ֞ת וְהַמִּשְׁפָּטִ֗ים אֲשֶׁ֨ר צִוָּ֧ה יְהוָ֛ה בְּיַד־מֹשֶׁ֖ה אֶל־בְּנֵ֣י יִשְׂרָאֵ֑ל בְּעַֽרְבֹ֣ת מֹואָ֔ב עַ֖ל יַרְדֵּ֥ן יְרֵחֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","אֵ֣לֶּה הַדְּבָרִ֗ים אֲשֶׁ֨ר דִּבֶּ֤ר מֹשֶׁה֙ אֶל־כָּל־יִשְׂרָאֵ֔ל בְּעֵ֖בֶר הַיַּרְדֵּ֑ן בַּמִּדְבָּ֡ר בָּֽעֲרָבָה֩ מֹ֨ול ס֜וּף בֵּֽין־פָּארָ֧ן וּבֵֽין־תֹּ֛פֶל וְלָבָ֥ן וַחֲצֵרֹ֖ת וְדִ֥י זָהָֽב׃ ");
INSERT INTO hbo_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","אַחַ֨ד עָשָׂ֥ר יֹום֙ מֵֽחֹרֵ֔ב דֶּ֖רֶךְ הַר־שֵׂעִ֑יר עַ֖ד קָדֵ֥שׁ בַּרְנֵֽעַ׃ ");
INSERT INTO hbo_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","וַיְהִי֙ בְּאַרְבָּעִ֣ים שָׁנָ֔ה בְּעַשְׁתֵּֽי־עָשָׂ֥ר חֹ֖דֶשׁ בְּאֶחָ֣ד לַחֹ֑דֶשׁ דִּבֶּ֤ר מֹשֶׁה֙ אֶל־בְּנֵ֣י יִשְׂרָאֵ֔ל כְּ֠כֹל אֲשֶׁ֨ר צִוָּ֧ה יְהוָ֛ה אֹתֹ֖ו אֲלֵהֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","אַחֲרֵ֣י הַכֹּתֹ֗ו אֵ֚ת סִיחֹן֙ מֶ֣לֶךְ הָֽאֱמֹרִ֔י אֲשֶׁ֥ר יֹושֵׁ֖ב בְּחֶשְׁבֹּ֑ון וְאֵ֗ת עֹ֚וג מֶ֣לֶךְ הַבָּשָׁ֔ן אֲשֶׁר־יֹושֵׁ֥ב בְּעַשְׁתָּרֹ֖ת בְּאֶדְרֶֽעִי׃ ");
INSERT INTO hbo_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","בְּעֵ֥בֶר הַיַּרְדֵּ֖ן בְּאֶ֣רֶץ מֹואָ֑ב הֹואִ֣יל מֹשֶׁ֔ה בֵּאֵ֛ר אֶת־הַתֹּורָ֥ה הַזֹּ֖את לֵאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","יְהוָ֧ה אֱלֹהֵ֛ינוּ דִּבֶּ֥ר אֵלֵ֖ינוּ בְּחֹרֵ֣ב לֵאמֹ֑ר רַב־לָכֶ֥ם שֶׁ֖בֶת בָּהָ֥ר הַזֶּֽה׃ ");
INSERT INTO hbo_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","פְּנ֣וּ ׀ וּסְע֣וּ לָכֶ֗ם וּבֹ֨אוּ הַ֥ר הָֽאֱמֹרִי֮ וְאֶל־כָּל־שְׁכֵנָיו֒ בָּעֲרָבָ֥ה בָהָ֛ר וּבַשְּׁפֵלָ֥ה וּבַנֶּ֖גֶב וּבְחֹ֣וף הַיָּ֑ם אֶ֤רֶץ הַֽכְּנַעֲנִי֙ וְהַלְּבָנֹ֔ון עַד־הַנָּהָ֥ר הַגָּדֹ֖ל נְהַר־פְּרָֽת׃ ");
INSERT INTO hbo_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","רְאֵ֛ה נָתַ֥תִּי לִפְנֵיכֶ֖ם אֶת־הָאָ֑רֶץ בֹּ֚אוּ וּרְשׁ֣וּ אֶת־הָאָ֔רֶץ אֲשֶׁ֣ר נִשְׁבַּ֣ע יְ֠הוָה לַאֲבֹ֨תֵיכֶ֜ם לְאַבְרָהָ֨ם לְיִצְחָ֤ק וּֽלְיַעֲקֹב֙ לָתֵ֣ת לָהֶ֔ם וּלְזַרְעָ֖ם אַחֲרֵיהֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","וָאֹמַ֣ר אֲלֵכֶ֔ם בָּעֵ֥ת הַהִ֖וא לֵאמֹ֑ר לֹא־אוּכַ֥ל לְבַדִּ֖י שְׂאֵ֥ת אֶתְכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","יְהוָ֥ה אֱלֹהֵיכֶ֖ם הִרְבָּ֣ה אֶתְכֶ֑ם וְהִנְּכֶ֣ם הַיֹּ֔ום כְּכֹוכְבֵ֥י הַשָּׁמַ֖יִם לָרֹֽב׃ ");
INSERT INTO hbo_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","יְהוָ֞ה אֱלֹהֵ֣י אֲבֹֽותֵכֶ֗ם יֹסֵ֧ף עֲלֵיכֶ֛ם כָּכֶ֖ם אֶ֣לֶף פְּעָמִ֑ים וִיבָרֵ֣ךְ אֶתְכֶ֔ם כַּאֲשֶׁ֖ר דִּבֶּ֥ר לָכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","אֵיכָ֥ה אֶשָּׂ֖א לְבַדִּ֑י טָרְחֲכֶ֥ם וּמַֽשַּׂאֲכֶ֖ם וְרִֽיבְכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","הָב֣וּ לָ֠כֶם אֲנָשִׁ֨ים חֲכָמִ֧ים וּנְבֹנִ֛ים וִידֻעִ֖ים לְשִׁבְטֵיכֶ֑ם וַאֲשִׂימֵ֖ם בְּרָאשֵׁיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","וַֽתַּעֲנ֖וּ אֹתִ֑י וַתֹּ֣אמְר֔וּ טֹֽוב־הַדָּבָ֥ר אֲשֶׁר־דִּבַּ֖רְתָּ לַעֲשֹֽׂות׃ ");
INSERT INTO hbo_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","וָאֶקַּ֞ח אֶת־רָאשֵׁ֣י שִׁבְטֵיכֶ֗ם אֲנָשִׁ֤ים חֲכָמִים֙ וִֽידֻעִ֔ים וָאֶתֵּ֥ן אֹתָ֛ם רָאשִׁ֖ים עֲלֵיכֶ֑ם שָׂרֵ֨י אֲלָפִ֜ים וְשָׂרֵ֣י מֵאֹ֗ות וְשָׂרֵ֤י חֲמִשִּׁים֙ וְשָׂרֵ֣י עֲשָׂרֹ֔ת וְשֹׁטְרִ֖ים לְשִׁבְטֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","וָאֲצַוֶּה֙ אֶת־שֹׁ֣פְטֵיכֶ֔ם בָּעֵ֥ת הַהִ֖וא לֵאמֹ֑ר שָׁמֹ֤עַ בֵּין־אֲחֵיכֶם֙ וּשְׁפַטְתֶּ֣ם צֶ֔דֶק בֵּֽין־אִ֥ישׁ וּבֵין־אָחִ֖יו וּבֵ֥ין גֵּרֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","לֹֽא־תַכִּ֨ירוּ פָנִ֜ים בַּמִּשְׁפָּ֗ט כַּקָּטֹ֤ן כַּגָּדֹל֙ תִּשְׁמָע֔וּן לֹ֤א תָג֙וּרוּ֙ מִפְּנֵי־אִ֔ישׁ כִּ֥י הַמִּשְׁפָּ֖ט לֵאלֹהִ֣ים ה֑וּא וְהַדָּבָר֙ אֲשֶׁ֣ר יִקְשֶׁ֣ה מִכֶּ֔ם תַּקְרִב֥וּן אֵלַ֖י וּשְׁמַעְתִּֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","וָאֲצַוֶּ֥ה אֶתְכֶ֖ם בָּעֵ֣ת הַהִ֑וא אֵ֥ת כָּל־הַדְּבָרִ֖ים אֲשֶׁ֥ר תַּעֲשֽׂוּן׃ ");
INSERT INTO hbo_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","וַנִּסַּ֣ע מֵחֹרֵ֗ב וַנֵּ֡לֶךְ אֵ֣ת כָּל־הַמִּדְבָּ֣ר הַגָּדֹול֩ וְהַנֹּורָ֨א הַה֜וּא אֲשֶׁ֣ר רְאִיתֶ֗ם דֶּ֚רֶךְ הַ֣ר הֽ͏ָאֱמֹרִ֔י כַּאֲשֶׁ֥ר צִוָּ֛ה יְהוָ֥ה אֱלֹהֵ֖ינוּ אֹתָ֑נוּ וַנָּבֹ֕א עַ֖ד קָדֵ֥שׁ בַּרְנֵֽעַ׃ ");
INSERT INTO hbo_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","וָאֹמַ֖ר אֲלֵכֶ֑ם בָּאתֶם֙ עַד־הַ֣ר הָאֱמֹרִ֔י אֲשֶׁר־יְהוָ֥ה אֱלֹהֵ֖ינוּ נֹתֵ֥ן לָֽנוּ׃ ");
INSERT INTO hbo_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","רְ֠אֵה נָתַ֨ן יְהוָ֧ה אֱלֹהֶ֛יךָ לְפָנֶ֖יךָ אֶת־הָאָ֑רֶץ עֲלֵ֣ה רֵ֗שׁ כַּאֲשֶׁר֩ דִּבֶּ֨ר יְהוָ֜ה אֱלֹהֵ֤י אֲבֹתֶ֙יךָ֙ לָ֔ךְ אַל־תִּירָ֖א וְאַל־תֵּחָֽת׃ ");
INSERT INTO hbo_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","וַתִּקְרְב֣וּן אֵלַי֮ כֻּלְּכֶם֒ וַתֹּאמְר֗וּ נִשְׁלְחָ֤ה אֲנָשִׁים֙ לְפָנֵ֔ינוּ וְיַחְפְּרוּ־לָ֖נוּ אֶת־הָאָ֑רֶץ וְיָשִׁ֤בוּ אֹתָ֙נוּ֙ דָּבָ֔ר אֶת־הַדֶּ֙רֶךְ֙ אֲשֶׁ֣ר נַעֲלֶה־בָּ֔הּ וְאֵת֙ הֶֽעָרִ֔ים אֲשֶׁ֥ר נָבֹ֖א אֲלֵיהֶֽן׃ ");
INSERT INTO hbo_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","וַיִּיטַ֥ב בְּעֵינַ֖י הַדָּבָ֑ר וָאֶקַּ֤ח מִכֶּם֙ שְׁנֵ֣ים עָשָׂ֣ר אֲנָשִׁ֔ים אִ֥ישׁ אֶחָ֖ד לַשָּֽׁבֶט׃ ");
INSERT INTO hbo_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","וַיִּפְנוּ֙ וַיַּעֲל֣וּ הָהָ֔רָה וַיָּבֹ֖אוּ עַד־נַ֣חַל אֶשְׁכֹּ֑ל וַֽיְרַגְּל֖וּ אֹתָֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","וַיִּקְח֤וּ בְיָדָם֙ מִפְּרִ֣י הָאָ֔רֶץ וַיֹּורִ֖דוּ אֵלֵ֑ינוּ וַיָּשִׁ֨בוּ אֹתָ֤נוּ דָבָר֙ וַיֹּ֣אמְר֔וּ טֹובָ֣ה הָאָ֔רֶץ אֲשֶׁר־יְהוָ֥ה אֱלֹהֵ֖ינוּ נֹתֵ֥ן לָֽנוּ׃ ");
INSERT INTO hbo_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","וְלֹ֥א אֲבִיתֶ֖ם לַעֲלֹ֑ת וַתַּמְר֕וּ אֶת־פִּ֥י יְהוָ֖ה אֱלֹהֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","וַתֵּרָגְנ֤וּ בְאָהֳלֵיכֶם֙ וַתֹּ֣אמְר֔וּ בְּשִׂנְאַ֤ת יְהוָה֙ אֹתָ֔נוּ הֹוצִיאָ֖נוּ מֵאֶ֣רֶץ מִצְרָ֑יִם לָתֵ֥ת אֹתָ֛נוּ בְּיַ֥ד הָאֱמֹרִ֖י לְהַשְׁמִידֵֽנוּ׃ ");
INSERT INTO hbo_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","אָנָ֣ה ׀ אֲנַ֣חְנוּ עֹלִ֗ים אַחֵינוּ֩ הֵמַ֨סּוּ אֶת־לְבָבֵ֜נוּ לֵאמֹ֗ר עַ֣ם גָּדֹ֤ול וָרָם֙ מִמֶּ֔נּוּ עָרִ֛ים גְּדֹלֹ֥ת וּבְצוּרֹ֖ת בַּשָּׁמָ֑יִם וְגַם־בְּנֵ֥י עֲנָקִ֖ים רָאִ֥ינוּ שָֽׁם׃ ");
INSERT INTO hbo_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","וָאֹמַ֖ר אֲלֵכֶ֑ם לֹא־תֽ͏ַעַרְצ֥וּן וְֽלֹא־תִֽירְא֖וּן מֵהֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","יְהוָ֤ה אֱלֹֽהֵיכֶם֙ הַהֹלֵ֣ךְ לִפְנֵיכֶ֔ם ה֖וּא יִלָּחֵ֣ם לָכֶ֑ם כְּ֠כֹל אֲשֶׁ֨ר עָשָׂ֧ה אִתְּכֶ֛ם בְּמִצְרַ֖יִם לְעֵינֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","וּבַמִּדְבָּר֙ אֲשֶׁ֣ר רָאִ֔יתָ אֲשֶׁ֤ר נְשָׂאֲךָ֙ יְהוָ֣ה אֱלֹהֶ֔יךָ כַּאֲשֶׁ֥ר יִשָּׂא־אִ֖ישׁ אֶת־בְּנֹ֑ו בְּכָל־הַדֶּ֙רֶךְ֙ אֲשֶׁ֣ר הֲלַכְתֶּ֔ם עַד־בֹּאֲכֶ֖ם עַד־הַמָּקֹ֥ום הַזֶּֽה׃ ");
INSERT INTO hbo_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","וּבַדָּבָ֖ר הַזֶּ֑ה אֵֽינְכֶם֙ מַאֲמִינִ֔ם בַּיהוָ֖ה אֱלֹהֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","הַהֹלֵ֨ךְ לִפְנֵיכֶ֜ם בַּדֶּ֗רֶךְ לָת֥וּר לָכֶ֛ם מָקֹ֖ום לֽ͏ַחֲנֹֽתְכֶ֑ם בָּאֵ֣שׁ ׀ לַ֗יְלָה לַרְאֹֽתְכֶם֙ בַּדֶּ֙רֶךְ֙ אֲשֶׁ֣ר תֵּֽלְכוּ־בָ֔הּ וּבֶעָנָ֖ן יֹומָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","וַיִּשְׁמַ֥ע יְהוָ֖ה אֶת־קֹ֣ול דִּבְרֵיכֶ֑ם וַיִּקְצֹ֖ף וַיִּשָּׁבַ֥ע לֵאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","אִם־יִרְאֶ֥ה אִישׁ֙ בָּאֲנָשִׁ֣ים הָאֵ֔לֶּה הַדֹּ֥ור הָרָ֖ע הַזֶּ֑ה אֵ֚ת הָאָ֣רֶץ הַטֹּובָ֔ה אֲשֶׁ֣ר נִשְׁבַּ֔עְתִּי לָתֵ֖ת לַאֲבֹתֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","זֽוּלָתִ֞י כָּלֵ֤ב בֶּן־יְפֻנֶּה֙ ה֣וּא יִרְאֶ֔נָּה וְלֹֽו־אֶתֵּ֧ן אֶת־הָאָ֛רֶץ אֲשֶׁ֥ר דָּֽרַךְ־בָּ֖הּ וּלְבָנָ֑יו יַ֕עַן אֲשֶׁ֥ר מִלֵּ֖א אַחֲרֵ֥י יְהוָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","גַּם־בִּי֙ הִתְאַנַּ֣ף יְהוָ֔ה בִּגְלַלְכֶ֖ם לֵאמֹ֑ר גַּם־אַתָּ֖ה לֹא־תָבֹ֥א שָֽׁם׃ ");
INSERT INTO hbo_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","יְהֹושֻׁ֤עַ בִּן־נוּן֙ הָעֹמֵ֣ד לְפָנֶ֔יךָ ה֖וּא יָ֣בֹא שָׁ֑מָּה אֹתֹ֣ו חַזֵּ֔ק כִּי־ה֖וּא יַנְחִלֶ֥נָּה אֶת־יִשְׂרָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","וְטַפְּכֶם֩ אֲשֶׁ֨ר אֲמַרְתֶּ֜ם לָבַ֣ז יִהְיֶ֗ה וּ֠בְנֵיכֶם אֲשֶׁ֨ר לֹא־יָדְע֤וּ הַיֹּום֙ טֹ֣וב וָרָ֔ע הֵ֖מָּה יָבֹ֣אוּ שָׁ֑מָּה וְלָהֶ֣ם אֶתְּנֶ֔נָּה וְהֵ֖ם יִירָשֽׁוּהָ׃ ");
INSERT INTO hbo_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","וְאַתֶּ֖ם פְּנ֣וּ לָכֶ֑ם וּסְע֥וּ הַמִּדְבָּ֖רָה דֶּ֥רֶךְ יַם־סֽוּף׃ ");
INSERT INTO hbo_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","וַֽתַּעֲנ֣וּ ׀ וַתֹּאמְר֣וּ אֵלַ֗י חָטָאנוּ֮ לַֽיהוָה֒ אֲנַ֤חְנוּ נַעֲלֶה֙ וְנִלְחַ֔מְנוּ כְּכֹ֥ל אֲשֶׁר־צִוָּ֖נוּ יְהוָ֣ה אֱלֹהֵ֑ינוּ וַֽתַּחְגְּר֗וּ אִ֚ישׁ אֶת־כְּלֵ֣י מִלְחַמְתֹּ֔ו וַתָּהִ֖ינוּ לַעֲלֹ֥ת הָהָֽרָה׃ ");
INSERT INTO hbo_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","וַיֹּ֨אמֶר יְהוָ֜ה אֵלַ֗י אֱמֹ֤ר לָהֶם֙ לֹ֤א תֽ͏ַעֲלוּ֙ וְלֹא־תִלָּ֣חֲמ֔וּ כִּ֥י אֵינֶ֖נִּי בְּקִרְבְּכֶ֑ם וְלֹא֙ תִּנָּֽגְפ֔וּ לִפְנֵ֖י אֹיְבֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","וָאֲדַבֵּ֥ר אֲלֵיכֶ֖ם וְלֹ֣א שְׁמַעְתֶּ֑ם וַתַּמְרוּ֙ אֶת־פִּ֣י יְהוָ֔ה וַתָּזִ֖דוּ וַתַּעֲל֥וּ הָהָֽרָה׃ ");
INSERT INTO hbo_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","וַיֵּצֵ֨א הָאֱמֹרִ֜י הַיֹּשֵׁ֨ב בָּהָ֤ר הַהוּא֙ לִקְרַאתְכֶ֔ם וַיִּרְדְּפ֣וּ אֶתְכֶ֔ם כַּאֲשֶׁ֥ר תַּעֲשֶׂ֖ינָה הַדְּבֹרִ֑ים וֽ͏ַיַּכְּת֥וּ אֶתְכֶ֛ם בְּשֵׂעִ֖יר עַד־חָרְמָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","וַתָּשֻׁ֥בוּ וַתִּבְכּ֖וּ לִפְנֵ֣י יְהוָ֑ה וְלֹֽא־שָׁמַ֤ע יְהוָה֙ בְּקֹ֣לְכֶ֔ם וְלֹ֥א הֶאֱזִ֖ין אֲלֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","וַתֵּשְׁב֥וּ בְקָדֵ֖שׁ יָמִ֣ים רַבִּ֑ים כַּיָּמִ֖ים אֲשֶׁ֥ר יְשַׁבְתֶּֽם׃ ");
INSERT INTO hbo_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","וַנֵּ֜פֶן וַנִּסַּ֤ע הַמִּדְבָּ֙רָה֙ דֶּ֣רֶךְ יַם־ס֔וּף כַּאֲשֶׁ֛ר דִּבֶּ֥ר יְהוָ֖ה אֵלָ֑י וַנָּ֥סָב אֶת־הַר־שֵׂעִ֖יר יָמִ֥ים רַבִּֽים׃ ס ");
INSERT INTO hbo_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","וַיֹּ֥אמֶר יְהוָ֖ה אֵלַ֥י לֵאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","רַב־לָכֶ֕ם סֹ֖ב אֶת־הָהָ֣ר הַזֶּ֑ה פְּנ֥וּ לָכֶ֖ם צָפֹֽנָה׃ ");
INSERT INTO hbo_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","וְאֶת־הָעָם֮ צַ֣ו לֵאמֹר֒ אַתֶּ֣ם עֹֽבְרִ֗ים בִּגְבוּל֙ אֲחֵיכֶ֣ם בְּנֵי־עֵשָׂ֔ו הַיֹּשְׁבִ֖ים בְּשֵׂעִ֑יר וְיִֽירְא֣וּ מִכֶּ֔ם וְנִשְׁמַרְתֶּ֖ם מְאֹֽד׃ ");
INSERT INTO hbo_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","אַל־תִּתְגָּר֣וּ בָ֔ם כִּ֠י לֹֽא־אֶתֵּ֤ן לָכֶם֙ מֵֽאַרְצָ֔ם עַ֖ד מִדְרַ֣ךְ כַּף־רָ֑גֶל כִּֽי־יְרֻשָּׁ֣ה לְעֵשָׂ֔ו נָתַ֖תִּי אֶת־הַ֥ר שֵׂעִֽיר׃ ");
INSERT INTO hbo_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","אֹ֣כֶל תִּשְׁבְּר֧וּ מֵֽאִתָּ֛ם בַּכֶּ֖סֶף וַאֲכַלְתֶּ֑ם וְגַם־מַ֜יִם תִּכְר֧וּ מֵאִתָּ֛ם בַּכֶּ֖סֶף וּשְׁתִיתֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","כִּי֩ יְהוָ֨ה אֱלֹהֶ֜יךָ בֵּֽרַכְךָ֗ בְּכֹל֙ מַעֲשֵׂ֣ה יָדֶ֔ךָ יָדַ֣ע לֶכְתְּךָ֔ אֶת־הַמִּדְבָּ֥ר הַגָּדֹ֖ל הַזֶּ֑ה זֶ֣ה ׀ אַרְבָּעִ֣ים שָׁנָ֗ה יְהוָ֤ה אֱלֹהֶ֙יךָ֙ עִמָּ֔ךְ לֹ֥א חָסַ֖רְתָּ דָּבָֽר׃ ");
INSERT INTO hbo_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","וַֽנַּעֲבֹ֞ר מֵאֵ֧ת אַחֵ֣ינוּ בְנֵי־עֵשָׂ֗ו הַיֹּֽשְׁבִים֙ בְּשֵׂעִ֔יר מִדֶּ֙רֶךְ֙ הָֽעֲרָבָ֔ה מֵאֵילַ֖ת וּמֵעֶצְיֹ֣ן גָּ֑בֶר ס וַנֵּ֙פֶן֙ וַֽנַּעֲבֹ֔ר דֶּ֖רֶךְ מִדְבַּ֥ר מֹואָֽב׃ ");
INSERT INTO hbo_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","וַיֹּ֨אמֶר יְהוָ֜ה אֵלַ֗י אֶל־תָּ֙צַר֙ אֶת־מֹואָ֔ב וְאַל־תִּתְגָּ֥ר בָּ֖ם מִלְחָמָ֑ה כִּ֠י לֹֽא־אֶתֵּ֨ן לְךָ֤ מֵֽאַרְצֹו֙ יְרֻשָּׁ֔ה כִּ֣י לִבְנֵי־לֹ֔וט נָתַ֥תִּי אֶת־עָ֖ר יְרֻשָּׁה׃ ");
INSERT INTO hbo_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","הָאֵמִ֥ים לְפָנִ֖ים יָ֣שְׁבוּ בָ֑הּ עַ֣ם גָּדֹ֥ול וְרַ֛ב וָרָ֖ם כָּעֲנָקִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","רְפָאִ֛ים יֵחָשְׁב֥וּ אַף־הֵ֖ם כָּעֲנָקִ֑ים וְהַמֹּ֣אָבִ֔ים יִקְרְא֥וּ לָהֶ֖ם אֵמִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","וּבְשֵׂעִ֞יר יָשְׁב֣וּ הַחֹרִים֮ לְפָנִים֒ וּבְנֵ֧י עֵשָׂ֣ו יִֽירָשׁ֗וּם וַיַּשְׁמִידוּם֙ מִפְּנֵיהֶ֔ם וַיֵּשְׁב֖וּ תַּחְתָּ֑ם כַּאֲשֶׁ֧ר עָשָׂ֣ה יִשְׂרָאֵ֗ל לְאֶ֙רֶץ֙ יְרֻשָּׁתֹ֔ו אֲשֶׁר־נָתַ֥ן יְהוָ֖ה לָהֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","עַתָּ֗ה קֻ֛מוּ וְעִבְר֥וּ לָכֶ֖ם אֶת־נַ֣חַל זָ֑רֶד וַֽנַּעֲבֹ֖ר אֶת־נַ֥חַל זָֽרֶד׃ ");
INSERT INTO hbo_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","וְהַיָּמִ֞ים אֲשֶׁר־הָלַ֣כְנוּ ׀ מִקָּדֵ֣שׁ בַּרְנֵ֗עַ עַ֤ד אֲשֶׁר־עָבַ֙רְנוּ֙ אֶת־נַ֣חַל זֶ֔רֶד שְׁלֹשִׁ֥ים וּשְׁמֹנֶ֖ה שָׁנָ֑ה עַד־תֹּ֨ם כָּל־הַדֹּ֜ור אַנְשֵׁ֤י הַמִּלְחָמָה֙ מִקֶּ֣רֶב הַֽמַּחֲנֶ֔ה כַּאֲשֶׁ֛ר נִשְׁבַּ֥ע יְהוָ֖ה לָהֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","וְגַ֤ם יַד־יְהוָה֙ הָ֣יְתָה בָּ֔ם לְהֻמָּ֖ם מִקֶּ֣רֶב הַֽמַּחֲנֶ֑ה עַ֖ד תֻּמָּֽם׃ ");
INSERT INTO hbo_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","וַיְהִ֨י כַאֲשֶׁר־תַּ֜מּוּ כָּל־אַנְשֵׁ֧י הַמִּלְחָמָ֛ה לָמ֖וּת מִקֶּ֥רֶב הָעָֽם׃ ס ");
INSERT INTO hbo_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","וַיְדַבֵּ֥ר יְהוָ֖ה אֵלַ֥י לֵאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","אַתָּ֨ה עֹבֵ֥ר הַיֹּ֛ום אֶת־גְּב֥וּל מֹואָ֖ב אֶת־עָֽר׃ ");
INSERT INTO hbo_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","וְקָרַבְתָּ֗ מ֚וּל בְּנֵ֣י עַמֹּ֔ון אַל־תְּצֻרֵ֖ם וְאַל־תִּתְגָּ֣ר בָּ֑ם כִּ֣י לֹֽא־אֶ֠תֵּן מֵאֶ֨רֶץ בְּנֵי־עַמֹּ֤ון לְךָ֙ יְרֻשָּׁ֔ה כִּ֥י לִבְנֵי־לֹ֖וט נְתַתִּ֥יהָ יְרֻשָּֽׁה׃ ");
INSERT INTO hbo_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","אֶֽרֶץ־רְפָאִ֥ים תֵּחָשֵׁ֖ב אַף־הִ֑וא רְפָאִ֤ים יָֽשְׁבוּ־בָהּ֙ לְפָנִ֔ים וְהָֽעַמֹּנִ֔ים יִקְרְא֥וּ לָהֶ֖ם זַמְזֻמִּֽים׃ ");
INSERT INTO hbo_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","עַ֣ם גָּדֹ֥ול וְרַ֛ב וָרָ֖ם כָּעֲנָקִ֑ים וַיַּשְׁמִידֵ֤ם יְהוָה֙ מִפְּנֵיהֶ֔ם וַיִּירָשֻׁ֖ם וַיֵּשְׁב֥וּ תַחְתָּֽם׃ ");
INSERT INTO hbo_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","כַּאֲשֶׁ֤ר עָשָׂה֙ לִבְנֵ֣י עֵשָׂ֔ו הַיֹּשְׁבִ֖ים בְּשֵׂעִ֑יר אֲשֶׁ֨ר הִשְׁמִ֤יד אֶת־הַחֹרִי֙ מִפְּנֵיהֶ֔ם וַיִּֽירָשֻׁם֙ וַיֵּשְׁב֣וּ תַחְתָּ֔ם עַ֖ד הַיֹּ֥ום הַזֶּֽה׃ ");
INSERT INTO hbo_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","וְהָֽעַוִּ֛ים הַיֹּשְׁבִ֥ים בַּחֲצֵרִ֖ים עַד־עַזָּ֑ה כַּפְתֹּרִים֙ הַיֹּצְאִ֣ים מִכַּפְתֹּ֔ור הִשְׁמִידֻ֖ם וַיֵּשְׁב֥וּ תַחְתָּֽם׃ ");
INSERT INTO hbo_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","ק֣וּמוּ סְּע֗וּ וְעִבְרוּ֮ אֶת־נַ֣חַל אַרְנֹן֒ רְאֵ֣ה נָתַ֣תִּי בְ֠יָדְךָ אֶת־סִיחֹ֨ן מֶֽלֶךְ־חֶשְׁבֹּ֧ון הֽ͏ָאֱמֹרִ֛י וְאֶת־אַרְצֹ֖ו הָחֵ֣ל רָ֑שׁ וְהִתְגָּ֥ר בֹּ֖ו מִלְחָמָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","הַיֹּ֣ום הַזֶּ֗ה אָחֵל֙ תֵּ֤ת פַּחְדְּךָ֙ וְיִרְאָ֣תְךָ֔ עַל־פְּנֵי֙ הָֽעַמִּ֔ים תַּ֖חַת כָּל־הַשָּׁמָ֑יִם אֲשֶׁ֤ר יִשְׁמְעוּן֙ שִׁמְעֲךָ֔ וְרָגְז֥וּ וְחָל֖וּ מִפָּנֶֽיךָ׃ ");
INSERT INTO hbo_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","וָאֶשְׁלַ֤ח מַלְאָכִים֙ מִמִּדְבַּ֣ר קְדֵמֹ֔ות אֶל־סִיחֹ֖ון מֶ֣לֶךְ חֶשְׁבֹּ֑ון דִּבְרֵ֥י שָׁלֹ֖ום לֵאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","אֶעְבְּרָ֣ה בְאַרְצֶ֔ךָ בַּדֶּ֥רֶךְ בַּדֶּ֖רֶךְ אֵלֵ֑ךְ לֹ֥א אָס֖וּר יָמִ֥ין וּשְׂמֹֽאול׃ ");
INSERT INTO hbo_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","אֹ֣כֶל בַּכֶּ֤סֶף תַּשְׁבִּרֵ֙נִי֙ וְאָכַ֔לְתִּי וּמַ֛יִם בַּכֶּ֥סֶף תִּתֶּן־לִ֖י וְשָׁתִ֑יתִי רַ֖ק אֶעְבְּרָ֥ה בְרַגְלָֽי׃ ");
INSERT INTO hbo_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","כַּאֲשֶׁ֨ר עֽ͏ָשׂוּ־לִ֜י בְּנֵ֣י עֵשָׂ֗ו הַיֹּֽשְׁבִים֙ בְּשֵׂעִ֔יר וְהַמֹּ֣ואָבִ֔ים הַיֹּשְׁבִ֖ים בְּעָ֑ר עַ֤ד אֲשֶֽׁר־אֶֽעֱבֹר֙ אֶת־הַיַּרְדֵּ֔ן אֶל־הָאָ֕רֶץ אֲשֶׁר־יְהוָ֥ה אֱלֹהֵ֖ינוּ נֹתֵ֥ן לָֽנוּ׃ ");
INSERT INTO hbo_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","וְלֹ֣א אָבָ֗ה סִיחֹן֙ מֶ֣לֶךְ חֶשְׁבֹּ֔ון הַעֲבִרֵ֖נוּ בֹּ֑ו כִּֽי־הִקְשָׁה֩ יְהוָ֨ה אֱלֹהֶ֜יךָ אֶת־רוּחֹ֗ו וְאִמֵּץ֙ אֶת־לְבָבֹ֔ו לְמַ֛עַן תִּתֹּ֥ו בְיָדְךָ֖ כַּיֹּ֥ום הַזֶּֽה׃ ס ");
INSERT INTO hbo_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","וַיֹּ֤אמֶר יְהוָה֙ אֵלַ֔י רְאֵ֗ה הַֽחִלֹּ֙תִי֙ תֵּ֣ת לְפָנֶ֔יךָ אֶת־סִיחֹ֖ן וְאֶת־אַרְצֹ֑ו הָחֵ֣ל רָ֔שׁ לָרֶ֖שֶׁת אֶת־אַרְצֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","וַיֵּצֵא֩ סִיחֹ֨ן לִקְרָאתֵ֜נוּ ה֧וּא וְכָל־עַמֹּ֛ו לַמִּלְחָמָ֖ה יָֽהְצָה׃ ");
INSERT INTO hbo_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","וַֽיִּתְּנֵ֛הוּ יְהוָ֥ה אֱלֹהֵ֖ינוּ לְפָנֵ֑ינוּ וַנַּ֥ךְ אֹתֹ֛ו וְאֶת־*בְּנֹו (בָּנָ֖יו) וְאֶת־כָּל־עַמֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","וַנִּלְכֹּ֤ד אֶת־כָּל־עָרָיו֙ בָּעֵ֣ת הַהִ֔וא וַֽנַּחֲרֵם֙ אֶת־כָּל־עִ֣יר מְתִ֔ם וְהַנָּשִׁ֖ים וְהַטָּ֑ף לֹ֥א הִשְׁאַ֖רְנוּ שָׂרִֽיד׃ ");
INSERT INTO hbo_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","רַ֥ק הַבְּהֵמָ֖ה בָּזַ֣זְנוּ לָ֑נוּ וּשְׁלַ֥ל הֶעָרִ֖ים אֲשֶׁ֥ר לָכָֽדְנוּ׃ ");
INSERT INTO hbo_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","מֵֽעֲרֹעֵ֡ר אֲשֶׁר֩ עַל־שְׂפַת־נַ֨חַל אַרְנֹ֜ן וְהָעִ֨יר אֲשֶׁ֤ר בַּנַּ֙חַל֙ וְעַד־הַגִּלְעָ֔ד לֹ֤א הָֽיְתָה֙ קִרְיָ֔ה אֲשֶׁ֥ר שָׂגְבָ֖ה מִמֶּ֑נּוּ אֶת־הַכֹּ֕ל נָתַ֛ן יְהוָ֥ה אֱלֹהֵ֖ינוּ לְפָנֵֽינוּ׃ ");
INSERT INTO hbo_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","רַ֛ק אֶל־אֶ֥רֶץ בְּנֵי־עַמֹּ֖ון לֹ֣א קָרָ֑בְתָּ כָּל־יַ֞ד נַ֤חַל יַבֹּק֙ וְעָרֵ֣י הָהָ֔ר וְכֹ֥ל אֲשֶׁר־צִוָּ֖ה יְהוָ֥ה אֱלֹהֵֽינוּ׃ ");
INSERT INTO hbo_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","וַנֵּ֣פֶן וַנַּ֔עַל דֶּ֖רֶךְ הַבָּשָׁ֑ן וַיֵּצֵ֣א עֹוג֩ מֶֽלֶךְ־הַבָּשָׁ֨ן לִקְרָאתֵ֜נוּ ה֧וּא וְכָל־עַמֹּ֛ו לַמִּלְחָמָ֖ה אֶדְרֶֽעִי׃ ");
INSERT INTO hbo_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","וַיֹּ֨אמֶר יְהוָ֤ה אֵלַי֙ אַל־תִּירָ֣א אֹתֹ֔ו כִּ֣י בְיָדְךָ֞ נָתַ֧תִּי אֹתֹ֛ו וְאֶת־כָּל־עַמֹּ֖ו וְאֶת־אַרְצֹ֑ו וְעָשִׂ֣יתָ לֹּ֔ו כַּאֲשֶׁ֣ר עָשִׂ֗יתָ לְסִיחֹן֙ מֶ֣לֶךְ הָֽאֱמֹרִ֔י אֲשֶׁ֥ר יֹושֵׁ֖ב בְּחֶשְׁבֹּֽון׃ ");
INSERT INTO hbo_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","וַיִּתֵּן֩ יְהוָ֨ה אֱלֹהֵ֜ינוּ בְּיָדֵ֗נוּ גַּ֛ם אֶת־עֹ֥וג מֶֽלֶךְ־הַבָּשָׁ֖ן וְאֶת־כָּל־עַמֹּ֑ו וַנַּכֵּ֕הוּ עַד־בִּלְתִּ֥י הִשְׁאִֽיר־לֹ֖ו שָׂרִֽיד׃ ");
INSERT INTO hbo_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","וַנִּלְכֹּ֤ד אֶת־כָּל־עָרָיו֙ בָּעֵ֣ת הַהִ֔וא לֹ֤א הָֽיְתָה֙ קִרְיָ֔ה אֲשֶׁ֥ר לֹא־לָקַ֖חְנוּ מֵֽאִתָּ֑ם שִׁשִּׁ֥ים עִיר֙ כָּל־חֶ֣בֶל אַרְגֹּ֔ב מַמְלֶ֥כֶת עֹ֖וג בַּבָּשָֽׁן׃ ");
INSERT INTO hbo_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","כָּל־אֵ֜לֶּה עָרִ֧ים בְּצֻרֹ֛ות חֹומָ֥ה גְבֹהָ֖ה דְּלָתַ֣יִם וּבְרִ֑יחַ לְבַ֛ד מֵעָרֵ֥י הַפְּרָזִ֖י הַרְבֵּ֥ה מְאֹֽד׃ ");
INSERT INTO hbo_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","וַנַּחֲרֵ֣ם אֹותָ֔ם כַּאֲשֶׁ֣ר עָשִׂ֔ינוּ לְסִיחֹ֖ן מֶ֣לֶךְ חֶשְׁבֹּ֑ון הַחֲרֵם֙ כָּל־עִ֣יר מְתִ֔ם הַנָּשִׁ֖ים וְהַטָּֽף׃ ");
INSERT INTO hbo_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","וְכָל־הַבְּהֵמָ֛ה וּשְׁלַ֥ל הֶעָרִ֖ים בַּזֹּ֥ונוּ לָֽנוּ׃ ");
INSERT INTO hbo_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","וַנִּקַּ֞ח בָּעֵ֤ת הַהִוא֙ אֶת־הָאָ֔רֶץ מִיַּ֗ד שְׁנֵי֙ מַלְכֵ֣י הָאֱמֹרִ֔י אֲשֶׁ֖ר בְּעֵ֣בֶר הַיַּרְדֵּ֑ן מִנַּ֥חַל אַרְנֹ֖ן עַד־הַ֥ר חֶרְמֹֽון׃ ");
INSERT INTO hbo_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","צִידֹנִ֛ים יִקְרְא֥וּ לְחֶרְמֹ֖ון שִׂרְיֹ֑ן וְהָ֣אֱמֹרִ֔י יִקְרְאוּ־לֹ֖ו שְׂנִֽיר׃ ");
INSERT INTO hbo_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","כֹּ֣ל ׀ עָרֵ֣י הַמִּישֹׁ֗ר וְכָל־הַגִּלְעָד֙ וְכָל־הַבָּשָׁ֔ן עַד־סַלְכָ֖ה וְאֶדְרֶ֑עִי עָרֵ֛י מַמְלֶ֥כֶת עֹ֖וג בַּבָּשָֽׁן׃ ");
INSERT INTO hbo_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","כִּ֣י רַק־עֹ֞וג מֶ֣לֶךְ הַבָּשָׁ֗ן נִשְׁאַר֮ מִיֶּ֣תֶר הָרְפָאִים֒ הִנֵּ֤ה עַרְשֹׂו֙ עֶ֣רֶשׂ בַּרְזֶ֔ל הֲלֹ֣ה הִ֔וא בְּרַבַּ֖ת בְּנֵ֣י עַמֹּ֑ון תֵּ֧שַׁע אַמֹּ֣ות אָרְכָּ֗הּ וְאַרְבַּ֥ע אַמֹּ֛ות רָחְבָּ֖הּ בְּאַמַּת־אִֽישׁ׃ ");
INSERT INTO hbo_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","וְאֶת־הָאָ֧רֶץ הַזֹּ֛את יָרַ֖שְׁנוּ בָּעֵ֣ת הַהִ֑וא מֵעֲרֹעֵ֞ר אֲשֶׁר־עַל־נַ֣חַל אַרְנֹ֗ן וַחֲצִ֤י הַֽר־הַגִּלְעָד֙ וְעָרָ֔יו נָתַ֕תִּי לָרֽ͏ֻאוּבֵנִ֖י וְלַגָּדִֽי׃ ");
INSERT INTO hbo_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","וְיֶ֨תֶר הַגִּלְעָ֤ד וְכָל־הַבָּשָׁן֙ מַמְלֶ֣כֶת עֹ֔וג נָתַ֕תִּי לַחֲצִ֖י שֵׁ֣בֶט הַֽמְנַשֶּׁ֑ה כֹּ֣ל חֶ֤בֶל הָֽאַרְגֹּב֙ לְכָל־הַבָּשָׁ֔ן הַה֥וּא יִקָּרֵ֖א אֶ֥רֶץ רְפָאִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","יָאִ֣יר בֶּן־מְנַשֶּׁ֗ה לָקַח֙ אֶת־כָּל־חֶ֣בֶל אַרְגֹּ֔ב עַד־גְּב֥וּל הַגְּשׁוּרִ֖י וְהַמַּֽעֲכָתִ֑י וַיִּקְרָא֩ אֹתָ֨ם עַל־שְׁמֹ֤ו אֶת־הַבָּשָׁן֙ חַוֹּ֣ת יָאִ֔יר עַ֖ד הַיֹּ֥ום הַזֶּֽה׃ ");
INSERT INTO hbo_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","וּלְמָכִ֖יר נָתַ֥תִּי אֶת־הַגִּלְעָֽד׃ ");
INSERT INTO hbo_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","וְלָרֻאוּבֵנִ֨י וְלַגָּדִ֜י נָתַ֤תִּי מִן־הַגִּלְעָד֙ וְעַד־נַ֣חַל אַרְנֹ֔ן תֹּ֥וךְ הַנַּ֖חַל וּגְבֻ֑ל וְעַד֙ יַבֹּ֣ק הַנַּ֔חַל גְּב֖וּל בְּנֵ֥י עַמֹּֽון׃ ");
INSERT INTO hbo_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","וְהָֽעֲרָבָ֖ה וְהַיַּרְדֵּ֣ן וּגְבֻ֑ל מִכִּנֶּ֗רֶת וְעַ֨ד יָ֤ם הָֽעֲרָבָה֙ יָ֣ם הַמֶּ֔לַח תַּ֛חַת אַשְׁדֹּ֥ת הַפִּסְגָּ֖ה מִזְרָֽחָה׃ ");
INSERT INTO hbo_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","וָאֲצַ֣ו אֶתְכֶ֔ם בָּעֵ֥ת הַהִ֖וא לֵאמֹ֑ר יְהוָ֣ה אֱלֹהֵיכֶ֗ם נָתַ֨ן לָכֶ֜ם אֶת־הָאָ֤רֶץ הַזֹּאת֙ לְרִשְׁתָּ֔הּ חֲלוּצִ֣ים תּֽ͏ַעַבְר֗וּ לִפְנֵ֛י אֲחֵיכֶ֥ם בְּנֵֽי־יִשְׂרָאֵ֖ל כָּל־בְּנֵי־חָֽיִל׃ ");
INSERT INTO hbo_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","רַ֠ק נְשֵׁיכֶ֣ם וְטַפְּכֶם֮ וּמִקְנֵכֶם֒ יָדַ֕עְתִּי כִּֽי־מִקְנֶ֥ה רַ֖ב לָכֶ֑ם יֵֽשְׁבוּ֙ בְּעָ֣רֵיכֶ֔ם אֲשֶׁ֥ר נָתַ֖תִּי לָכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","עַ֠ד אֲשֶׁר־יָנִ֨יחַ יְהוָ֥ה ׀ לֽ͏ַאֲחֵיכֶם֮ כָּכֶם֒ וְיָרְשׁ֣וּ גַם־הֵ֔ם אֶת־הָאָ֕רֶץ אֲשֶׁ֨ר יְהוָ֧ה אֱלֹהֵיכֶ֛ם נֹתֵ֥ן לָהֶ֖ם בְּעֵ֣בֶר הַיַּרְדֵּ֑ן וְשַׁבְתֶּ֗ם אִ֚ישׁ לִֽירֻשָּׁתֹ֔ו אֲשֶׁ֥ר נָתַ֖תִּי לָכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","וְאֶת־יְהֹושׁ֣וּעַ צִוֵּ֔יתִי בָּעֵ֥ת הַהִ֖וא לֵאמֹ֑ר עֵינֶ֣יךָ הָרֹאֹ֗ת אֵת֩ כָּל־אֲשֶׁ֨ר עָשָׂ֜ה יְהוָ֤ה אֱלֹהֵיכֶם֙ לִשְׁנֵי֙ הַמְּלָכִ֣ים הָאֵ֔לֶּה כֵּֽן־יַעֲשֶׂ֤ה יְהוָה֙ לְכָל־הַמַּמְלָכֹ֔ות אֲשֶׁ֥ר אַתָּ֖ה עֹבֵ֥ר שָֽׁמָּה׃ ");
INSERT INTO hbo_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","לֹ֖א תִּֽירָא֑וּם כִּ֚י יְהוָ֣ה אֱלֹֽהֵיכֶ֔ם ה֖וּא הַנִּלְחָ֥ם לָכֶֽם׃ ס ");
INSERT INTO hbo_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","וָאֶתְחַנַּ֖ן אֶל־יְהוָ֑ה בָּעֵ֥ת הַהִ֖וא לֵאמֹֽר׃ ");
INSERT INTO hbo_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","אֲדֹנָ֣י יְהוִ֗ה אַתָּ֤ה הַֽחִלֹּ֙ותָ֙ לְהַרְאֹ֣ות אֶֽת־עַבְדְּךָ֔ אֶ֨ת־גָּדְלְךָ֔ וְאֶת־יָדְךָ֖ הַחֲזָקָ֑ה אֲשֶׁ֤ר מִי־אֵל֙ בַּשָּׁמַ֣יִם וּבָאָ֔רֶץ אֲשֶׁר־יַעֲשֶׂ֥ה כְמַעֲשֶׂ֖יךָ וְכִגְבוּרֹתֶֽךָ׃ ");
INSERT INTO hbo_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","אֶעְבְּרָה־נָּ֗א וְאֶרְאֶה֙ אֶת־הָאָ֣רֶץ הַטֹּובָ֔ה אֲשֶׁ֖ר בְּעֵ֣בֶר הַיַּרְדֵּ֑ן הָהָ֥ר הַטֹּ֛וב הַזֶּ֖ה וְהַלְּבָנֹֽון׃ ");
INSERT INTO hbo_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","וַיִּתְעַבֵּ֨ר יְהוָ֥ה בִּי֙ לְמַ֣עַנְכֶ֔ם וְלֹ֥א שָׁמַ֖ע אֵלָ֑י וַיֹּ֨אמֶר יְהוָ֤ה אֵלַי֙ רַב־לָ֔ךְ אַל־תֹּ֗וסֶף דַּבֵּ֥ר אֵלַ֛י עֹ֖וד בַּדָּבָ֥ר הַזֶּֽה׃ ");
INSERT INTO hbo_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","עֲלֵ֣ה ׀ רֹ֣אשׁ הַפִּסְגָּ֗ה וְשָׂ֥א עֵינֶ֛יךָ יָ֧מָּה וְצָפֹ֛נָה וְתֵימָ֥נָה וּמִזְרָ֖חָה וּרְאֵ֣ה בְעֵינֶ֑יךָ כִּי־לֹ֥א תַעֲבֹ֖ר אֶת־הַיַּרְדֵּ֥ן הַזֶּֽה׃ ");
INSERT INTO hbo_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","וְצַ֥ו אֶת־יְהֹושֻׁ֖עַ וְחַזְּקֵ֣הוּ וְאַמְּצֵ֑הוּ כִּי־ה֣וּא יַעֲבֹ֗ר לִפְנֵי֙ הָעָ֣ם הַזֶּ֔ה וְהוּא֙ יַנְחִ֣יל אֹותָ֔ם אֶת־הָאָ֖רֶץ אֲשֶׁ֥ר תִּרְאֶֽה׃ ");
INSERT INTO hbo_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","וַנֵּ֣שֶׁב בַּגָּ֔יְא מ֖וּל בֵּ֥ית פְּעֹֽור׃ פ ");
INSERT INTO hbo_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","וְעַתָּ֣ה יִשְׂרָאֵ֗ל שְׁמַ֤ע אֶל־הַֽחֻקִּים֙ וְאֶל־הַמִּשְׁפָּטִ֔ים אֲשֶׁ֧ר אָֽנֹכִ֛י מְלַמֵּ֥ד אֶתְכֶ֖ם לַעֲשֹׂ֑ות לְמַ֣עַן תִּֽחְי֗וּ וּבָאתֶם֙ וִֽירִשְׁתֶּ֣ם אֶת־הָאָ֔רֶץ אֲשֶׁ֧ר יְהוָ֛ה אֱלֹהֵ֥י אֲבֹתֵיכֶ֖ם נֹתֵ֥ן לָכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","לֹ֣א תֹסִ֗פוּ עַל־הַדָּבָר֙ אֲשֶׁ֤ר אָנֹכִי֙ מְצַוֶּ֣ה אֶתְכֶ֔ם וְלֹ֥א תִגְרְע֖וּ מִמֶּ֑נּוּ לִשְׁמֹ֗ר אֶת־מִצְוֹת֙ יְהוָ֣ה אֱלֹֽהֵיכֶ֔ם אֲשֶׁ֥ר אָנֹכִ֖י מְצַוֶּ֥ה אֶתְכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","עֵֽינֵיכֶם֙ הָֽרֹאֹ֔ת אֵ֛ת אֲשֶׁר־עָשָׂ֥ה יְהוָ֖ה בְּבַ֣עַל פְּעֹ֑ור כִּ֣י כָל־הָאִ֗ישׁ אֲשֶׁ֤ר הָלַךְ֙ אַחֲרֵ֣י בַֽעַל־פְּעֹ֔ור הִשְׁמִידֹ֛ו יְהוָ֥ה אֱלֹהֶ֖יךָ מִקִּרְבֶּֽךָ׃ ");
INSERT INTO hbo_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","וְאַתֶּם֙ הַדְּבֵקִ֔ים בַּיהוָ֖ה אֱלֹהֵיכֶ֑ם חַיִּ֥ים כֻּלְּכֶ֖ם הַיֹּֽום׃ ");
INSERT INTO hbo_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","רְאֵ֣ה ׀ לִמַּ֣דְתִּי אֶתְכֶ֗ם חֻקִּים֙ וּמִשְׁפָּטִ֔ים כַּאֲשֶׁ֥ר צִוַּ֖נִי יְהוָ֣ה אֱלֹהָ֑י לַעֲשֹׂ֣ות כֵּ֔ן בְּקֶ֣רֶב הָאָ֔רֶץ אֲשֶׁ֥ר אַתֶּ֛ם בָּאִ֥ים שָׁ֖מָּה לְרִשְׁתָּֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","וּשְׁמַרְתֶּם֮ וַעֲשִׂיתֶם֒ כִּ֣י הִ֤וא חָכְמַתְכֶם֙ וּבִ֣ינַתְכֶ֔ם לְעֵינֵ֖י הָעַמִּ֑ים אֲשֶׁ֣ר יִשְׁמְע֗וּן אֵ֚ת כָּל־הַחֻקִּ֣ים הָאֵ֔לֶּה וְאָמְר֗וּ רַ֚ק עַם־חָכָ֣ם וְנָבֹ֔ון הַגֹּ֥וי הַגָּדֹ֖ול הַזֶּֽה׃ ");
INSERT INTO hbo_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","כִּ֚י מִי־גֹ֣וי גָּדֹ֔ול אֲשֶׁר־לֹ֥ו אֱלֹהִ֖ים קְרֹבִ֣ים אֵלָ֑יו כַּיהוָ֣ה אֱלֹהֵ֔ינוּ בְּכָל־קָרְאֵ֖נוּ אֵלָֽיו׃ ");
INSERT INTO hbo_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","וּמִי֙ גֹּ֣וי גָּדֹ֔ול אֲשֶׁר־לֹ֛ו חֻקִּ֥ים וּמִשְׁפָּטִ֖ים צַדִּיקִ֑ם כְּכֹל֙ הַתֹּורָ֣ה הַזֹּ֔את אֲשֶׁ֧ר אָנֹכִ֛י נֹתֵ֥ן לִפְנֵיכֶ֖ם הַיֹּֽום׃ ");
INSERT INTO hbo_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","רַ֡ק הִשָּׁ֣מֶר לְךָ֩ וּשְׁמֹ֨ר נַפְשְׁךָ֜ מְאֹ֗ד פֶּן־תִּשְׁכַּ֨ח אֶת־הַדְּבָרִ֜ים אֲשֶׁר־רָא֣וּ עֵינֶ֗יךָ וּפֶן־יָס֙וּרוּ֙ מִלְּבָ֣בְךָ֔ כֹּ֖ל יְמֵ֣י חַיֶּ֑יךָ וְהֹודַעְתָּ֥ם לְבָנֶ֖יךָ וְלִבְנֵ֥י בָנֶֽיךָ׃ ");
INSERT INTO hbo_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","יֹ֗ום אֲשֶׁ֨ר עָמַ֜דְתָּ לִפְנֵ֨י יְהוָ֣ה אֱלֹהֶיךָ֮ בְּחֹרֵב֒ בֶּאֱמֹ֨ר יְהוָ֜ה אֵלַ֗י הַקְהֶל־לִי֙ אֶת־הָעָ֔ם וְאַשְׁמִעֵ֖ם אֶת־דְּבָרָ֑י אֲשֶׁ֨ר יִלְמְד֜וּן לְיִרְאָ֣ה אֹתִ֗י כָּל־הַיָּמִים֙ אֲשֶׁ֨ר הֵ֤ם חַיִּים֙ עַל־הָ֣אֲדָמָ֔ה וְאֶת־בְּנֵיהֶ֖ם יְלַמֵּדֽוּן׃ ");
INSERT INTO hbo_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","וַתִּקְרְב֥וּן וַתַּֽעַמְד֖וּן תַּ֣חַת הָהָ֑ר וְהָהָ֞ר בֹּעֵ֤ר בָּאֵשׁ֙ עַד־לֵ֣ב הַשָּׁמַ֔יִם חֹ֖שֶׁךְ עָנָ֥ן וַעֲרָפֶֽל׃ ");
INSERT INTO hbo_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","וַיְדַבֵּ֧ר יְהוָ֛ה אֲלֵיכֶ֖ם מִתֹּ֣וךְ הָאֵ֑שׁ קֹ֤ול דְּבָרִים֙ אַתֶּ֣ם שֹׁמְעִ֔ים וּתְמוּנָ֛ה אֵינְכֶ֥ם רֹאִ֖ים זוּלָתִ֥י קֹֽול׃ ");
INSERT INTO hbo_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","וַיַּגֵּ֨ד לָכֶ֜ם אֶת־בְּרִיתֹ֗ו אֲשֶׁ֨ר צִוָּ֤ה אֶתְכֶם֙ לַעֲשֹׂ֔ות עֲשֶׂ֖רֶת הַדְּבָרִ֑ים וַֽיִּכְתְּבֵ֔ם עַל־שְׁנֵ֖י לֻחֹ֥ות אֲבָנִֽים׃ ");
INSERT INTO hbo_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","וְאֹתִ֞י צִוָּ֤ה יְהוָה֙ בָּעֵ֣ת הַהִ֔וא לְלַמֵּ֣ד אֶתְכֶ֔ם חֻקִּ֖ים וּמִשְׁפָּטִ֑ים לַעֲשֹׂתְכֶ֣ם אֹתָ֔ם בָּאָ֕רֶץ אֲשֶׁ֥ר אַתֶּ֛ם עֹבְרִ֥ים שָׁ֖מָּה לְרִשְׁתָּֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","וְנִשְׁמַרְתֶּ֥ם מְאֹ֖ד לְנַפְשֹׁתֵיכֶ֑ם כִּ֣י לֹ֤א רְאִיתֶם֙ כָּל־תְּמוּנָ֔ה בְּיֹ֗ום דִּבֶּ֨ר יְהוָ֧ה אֲלֵיכֶ֛ם בְּחֹרֵ֖ב מִתֹּ֥וךְ הָאֵֽשׁ׃ ");
INSERT INTO hbo_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","פֶּ֨ן־תַּשְׁחִת֔וּן וַעֲשִׂיתֶ֥ם לָכֶ֛ם פֶּ֖סֶל תְּמוּנַ֣ת כָּל־סָ֑מֶל תַּבְנִ֥ית זָכָ֖ר אֹ֥ו נְקֵבָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","תַּבְנִ֕ית כָּל־בְּהֵמָ֖ה אֲשֶׁ֣ר בָּאָ֑רֶץ תַּבְנִית֙ כָּל־צִפֹּ֣ור כָּנָ֔ף אֲשֶׁ֥ר תָּע֖וּף בַּשָּׁמָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","תַּבְנִ֕ית כָּל־רֹמֵ֖שׂ בָּאֲדָמָ֑ה תַּבְנִ֛ית כָּל־דָּגָ֥ה אֲשֶׁר־בַּמַּ֖יִם מִתַּ֥חַת לָאָֽרֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","וּפֶן־תִּשָּׂ֨א עֵינֶ֜יךָ הַשָּׁמַ֗יְמָה וְֽ֠רָאִיתָ אֶת־הַשֶּׁ֨מֶשׁ וְאֶת־הַיָּרֵ֜חַ וְאֶת־הַכֹּֽוכָבִ֗ים כֹּ֚ל צְבָ֣א הַשָּׁמַ֔יִם וְנִדַּחְתָּ֛ וְהִשְׁתַּחֲוִ֥יתָ לָהֶ֖ם וַעֲבַדְתָּ֑ם אֲשֶׁ֨ר חָלַ֜ק יְהוָ֤ה אֱלֹהֶ֙יךָ֙ אֹתָ֔ם לְכֹל֙ הָֽעַמִּ֔ים תַּ֖חַת כָּל־הַשָּׁמָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","וְאֶתְכֶם֙ לָקַ֣ח יְהוָ֔ה וַיֹּוצִ֥א אֶתְכֶ֛ם מִכּ֥וּר הַבַּרְזֶ֖ל מִמִּצְרָ֑יִם לִהְיֹ֥ות לֹ֛ו לְעַ֥ם נַחֲלָ֖ה כַּיֹּ֥ום הַזֶּֽה׃ ");
INSERT INTO hbo_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","וַֽיהוָ֥ה הִתְאַנֶּף־בִּ֖י עַל־דִּבְרֵיכֶ֑ם וַיִּשָּׁבַ֗ע לְבִלְתִּ֤י עָבְרִי֙ אֶת־הַיַּרְדֵּ֔ן וּלְבִלְתִּי־בֹא֙ אֶל־הָאָ֣רֶץ הַטֹּובָ֔ה אֲשֶׁר֙ יְהוָ֣ה אֱלֹהֶ֔יךָ נֹתֵ֥ן לְךָ֖ נַחֲלָֽה׃ ");
INSERT INTO hbo_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","כִּ֣י אָנֹכִ֥י מֵת֙ בָּאָ֣רֶץ הַזֹּ֔את אֵינֶ֥נִּי עֹבֵ֖ר אֶת־הַיַּרְדֵּ֑ן וְאַתֶּם֙ עֹֽבְרִ֔ים וִֽירִשְׁתֶּ֕ם אֶת־הָאָ֥רֶץ הַטֹּובָ֖ה הַזֹּֽאת׃ ");
INSERT INTO hbo_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","הִשָּׁמְר֣וּ לָכֶ֗ם פֶּֽן־תִּשְׁכְּחוּ֙ אֶת־בְּרִ֤ית יְהוָה֙ אֱלֹ֣הֵיכֶ֔ם אֲשֶׁ֥ר כָּרַ֖ת עִמָּכֶ֑ם וַעֲשִׂיתֶ֨ם לָכֶ֥ם פֶּ֙סֶל֙ תְּמ֣וּנַת כֹּ֔ל אֲשֶׁ֥ר צִוְּךָ֖ יְהוָ֥ה אֱלֹהֶֽיךָ׃ ");
INSERT INTO hbo_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","כִּ֚י יְהוָ֣ה אֱלֹהֶ֔יךָ אֵ֥שׁ אֹכְלָ֖ה ה֑וּא אֵ֖ל קַנָּֽא׃ פ ");
INSERT INTO hbo_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","כִּֽי־תֹולִ֤יד בָּנִים֙ וּבְנֵ֣י בָנִ֔ים וְנֹושַׁנְתֶּ֖ם בָּאָ֑רֶץ וְהִשְׁחַתֶּ֗ם וַעֲשִׂ֤יתֶם פֶּ֙סֶל֙ תְּמ֣וּנַת כֹּ֔ל וַעֲשִׂיתֶ֥ם הָרַ֛ע בְּעֵינֵ֥י יְהוָֽה־אֱלֹהֶ֖יךָ לְהַכְעִיסֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","הַעִידֹתִי֩ בָכֶ֨ם הַיֹּ֜ום אֶת־הַשָּׁמַ֣יִם וְאֶת־הָאָ֗רֶץ כִּֽי־אָבֹ֣ד תֹּאבֵדוּן֮ מַהֵר֒ מֵעַ֣ל הָאָ֔רֶץ אֲשֶׁ֨ר אַתֶּ֜ם עֹבְרִ֧ים אֶת־הַיַּרְדֵּ֛ן שָׁ֖מָּה לְרִשְׁתָּ֑הּ לֹֽא־תַאֲרִיכֻ֤ן יָמִים֙ עָלֶ֔יהָ כִּ֥י הִשָּׁמֵ֖ד תִּשָּׁמֵדֽוּן׃ ");
INSERT INTO hbo_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","וְהֵפִ֧יץ יְהוָ֛ה אֶתְכֶ֖ם בָּעַמִּ֑ים וְנִשְׁאַרְתֶּם֙ מְתֵ֣י מִסְפָּ֔ר בַּגֹּויִ֕ם אֲשֶׁ֨ר יְנַהֵ֧ג יְהוָ֛ה אֶתְכֶ֖ם שָֽׁמָּה׃ ");
INSERT INTO hbo_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","וַעֲבַדְתֶּם־שָׁ֣ם אֱלֹהִ֔ים מַעֲשֵׂ֖ה יְדֵ֣י אָדָ֑ם עֵ֣ץ וָאֶ֔בֶן אֲשֶׁ֤ר לֹֽא־יִרְאוּן֙ וְלֹ֣א יִשְׁמְע֔וּן וְלֹ֥א יֹֽאכְל֖וּן וְלֹ֥א יְרִיחֻֽן׃ ");
INSERT INTO hbo_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","וּבִקַּשְׁתֶּ֥ם מִשָּׁ֛ם אֶת־יְהוָ֥ה אֱלֹהֶ֖יךָ וּמָצָ֑אתָ כִּ֣י תִדְרְשֶׁ֔נּוּ בְּכָל־לְבָבְךָ֖ וּבְכָל־נַפְשֶֽׁךָ׃ ");
INSERT INTO hbo_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","בַּצַּ֣ר לְךָ֔ וּמְצָא֕וּךָ כֹּ֖ל הַדְּבָרִ֣ים הָאֵ֑לֶּה בְּאַחֲרִית֙ הַיָּמִ֔ים וְשַׁבְתָּ֙ עַד־יְהוָ֣ה אֱלֹהֶ֔יךָ וְשָׁמַעְתָּ֖ בְּקֹלֹֽו׃ ");
INSERT INTO hbo_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","כִּ֣י אֵ֤ל רַחוּם֙ יְהוָ֣ה אֱלֹהֶ֔יךָ לֹ֥א יַרְפְּךָ֖ וְלֹ֣א יַשְׁחִיתֶ֑ךָ וְלֹ֤א יִשְׁכַּח֙ אֶת־בְּרִ֣ית אֲבֹתֶ֔יךָ אֲשֶׁ֥ר נִשְׁבַּ֖ע לָהֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","כִּ֣י שְׁאַל־נָא֩ לְיָמִ֨ים רִֽאשֹׁנִ֜ים אֲשֶׁר־הָי֣וּ לְפָנֶ֗יךָ לְמִן־הַיֹּום֙ אֲשֶׁר֩ בָּרָ֨א אֱלֹהִ֤ים ׀ אָדָם֙ עַל־הָאָ֔רֶץ וּלְמִקְצֵ֥ה הַשָּׁמַ֖יִם וְעַד־קְצֵ֣ה הַשָּׁמָ֑יִם הֲנִֽהְיָ֗ה כַּדָּבָ֤ר הַגָּדֹול֙ הַזֶּ֔ה אֹ֖ו הֲנִשְׁמַ֥ע כָּמֹֽהוּ׃ ");
INSERT INTO hbo_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","הֲשָׁ֣מַֽע עָם֩ קֹ֨ול אֱלֹהִ֜ים מְדַבֵּ֧ר מִתֹּוךְ־הָאֵ֛שׁ כַּאֲשֶׁר־שָׁמַ֥עְתָּ אַתָּ֖ה וַיֶּֽחִי׃ ");
INSERT INTO hbo_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","אֹ֣ו ׀ הֲנִסָּ֣ה אֱלֹהִ֗ים לָ֠בֹוא לָקַ֨חַת לֹ֣ו גֹוי֮ מִקֶּ֣רֶב גֹּוי֒ בְּמַסֹּת֩ בְּאֹתֹ֨ת וּבְמֹופְתִ֜ים וּבְמִלְחָמָ֗ה וּבְיָ֤ד חֲזָקָה֙ וּבִזְרֹ֣ועַ נְטוּיָ֔ה וּבְמֹורָאִ֖ים גְּדֹלִ֑ים כְּ֠כֹל אֲשֶׁר־עָשָׂ֨ה לָכֶ֜ם יְהוָ֧ה אֱלֹהֵיכֶ֛ם בְּמִצְרַ֖יִם לְעֵינֶֽיךָ׃ ");
INSERT INTO hbo_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","אַתָּה֙ הָרְאֵ֣תָ לָדַ֔עַת כִּ֥י יְהוָ֖ה ה֣וּא הָאֱלֹהִ֑ים אֵ֥ין עֹ֖וד מִלְבַדֹּֽו׃ ");
INSERT INTO hbo_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","מִן־הַשָּׁמַ֛יִם הִשְׁמִֽיעֲךָ֥ אֶת־קֹלֹ֖ו לְיַסְּרֶ֑ךָּ וְעַל־הָאָ֗רֶץ הֶרְאֲךָ֙ אֶת־אִשֹּׁ֣ו הַגְּדֹולָ֔ה וּדְבָרָ֥יו שָׁמַ֖עְתָּ מִתֹּ֥וךְ הָאֵֽשׁ׃ ");
INSERT INTO hbo_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","וְתַ֗חַת כִּ֤י אָהַב֙ אֶת־אֲבֹתֶ֔יךָ וַיִּבְחַ֥ר בְּזַרְעֹ֖ו אַחֲרָ֑יו וַיֹּוצִֽאֲךָ֧ בְּפָנָ֛יו בְּכֹחֹ֥ו הַגָּדֹ֖ל מִמִּצְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","לְהֹורִ֗ישׁ גֹּויִ֛ם גְּדֹלִ֧ים וַעֲצֻמִ֛ים מִמְּךָ֖ מִפָּנֶ֑יךָ לַהֲבִֽיאֲךָ֗ לָֽתֶת־לְךָ֧ אֶת־אַרְצָ֛ם נַחֲלָ֖ה כַּיֹּ֥ום הַזֶּֽה׃ ");
INSERT INTO hbo_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","וְיָדַעְתָּ֣ הַיֹּ֗ום וַהֲשֵׁבֹתָ֮ אֶל־לְבָבֶךָ֒ כִּ֤י יְהוָה֙ ה֣וּא הָֽאֱלֹהִ֔ים בַּשָּׁמַ֣יִם מִמַּ֔עַל וְעַל־הָאָ֖רֶץ מִתָּ֑חַת אֵ֖ין עֹֽוד׃ ");
INSERT INTO hbo_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","וְשָׁמַרְתָּ֞ אֶת־חֻקָּ֣יו וְאֶת־מִצְוֹתָ֗יו אֲשֶׁ֨ר אָנֹכִ֤י מְצַוְּךָ֙ הַיֹּ֔ום אֲשֶׁר֙ יִיטַ֣ב לְךָ֔ וּלְבָנֶ֖יךָ אַחֲרֶ֑יךָ וּלְמַ֨עַן תַּאֲרִ֤יךְ יָמִים֙ עַל־הָ֣אֲדָמָ֔ה אֲשֶׁ֨ר יְהוָ֧ה אֱלֹהֶ֛יךָ נֹתֵ֥ן לְךָ֖ כָּל־הַיָּמִֽים׃ פ ");
INSERT INTO hbo_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","אָ֣ז יַבְדִּ֤יל מֹשֶׁה֙ שָׁלֹ֣שׁ עָרִ֔ים בְּעֵ֖בֶר הַיַּרְדֵּ֑ן מִזְרְחָ֖ה שָֽׁמֶשׁ׃ ");
INSERT INTO hbo_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","לָנֻ֨ס שָׁ֜מָּה רֹוצֵ֗חַ אֲשֶׁ֨ר יִרְצַ֤ח אֶת־רֵעֵ֙הוּ֙ בִּבְלִי־דַ֔עַת וְה֛וּא לֹא־שֹׂנֵ֥א לֹ֖ו מִתְּמֹ֣ול שִׁלְשֹׁ֑ום וְנָ֗ס אֶל־אַחַ֛ת מִן־הֶעָרִ֥ים הָאֵ֖ל וָחָֽי׃ ");
INSERT INTO hbo_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","אֶת־בֶּ֧צֶר בַּמִּדְבָּ֛ר בְּאֶ֥רֶץ הַמִּישֹׁ֖ר לָרֻֽאוּבֵנִ֑י וְאֶת־רָאמֹ֤ת בַּגִּלְעָד֙ לַגָּדִ֔י וְאֶת־גֹּולָ֥ן בַּבָּשָׁ֖ן לַֽמְנַשִּֽׁי׃ ");
INSERT INTO hbo_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","וְזֹ֖את הַתֹּורָ֑ה אֲשֶׁר־שָׂ֣ם מֹשֶׁ֔ה לִפְנֵ֖י בְּנֵ֥י יִשְׂרָאֵֽל׃ ");
INSERT INTO hbo_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","אֵ֚לֶּה הָֽעֵדֹ֔ת וְהַֽחֻקִּ֖ים וְהַמִּשְׁפָּטִ֑ים אֲשֶׁ֨ר דִּבֶּ֤ר מֹשֶׁה֙ אֶל־בְּנֵ֣י יִשְׂרָאֵ֔ל בְּצֵאתָ֖ם מִמִּצְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","בְּעֵ֨בֶר הַיַּרְדֵּ֜ן בַּגַּ֗יְא מ֚וּל בֵּ֣ית פְּעֹ֔ור בְּאֶ֗רֶץ סִיחֹן֙ מֶ֣לֶךְ הָֽאֱמֹרִ֔י אֲשֶׁ֥ר יֹושֵׁ֖ב בְּחֶשְׁבֹּ֑ון אֲשֶׁ֨ר הִכָּ֤ה מֹשֶׁה֙ וּבְנֵֽי יִשְׂרָאֵ֔ל בְּצֵאתָ֖ם מִמִּצְרָֽיִם׃ ");
INSERT INTO hbo_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","וַיִּֽירְשׁ֨וּ אֶת־אַרְצֹ֜ו וְאֶת־אֶ֣רֶץ ׀ עֹ֣וג מֶֽלֶךְ־הַבָּשָׁ֗ן שְׁנֵי֙ מַלְכֵ֣י הָֽאֱמֹרִ֔י אֲשֶׁ֖ר בְּעֵ֣בֶר הַיַּרְדֵּ֑ן מִזְרַ֖ח שָֽׁמֶשׁ׃ ");
INSERT INTO hbo_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","מֵעֲרֹעֵ֞ר אֲשֶׁ֨ר עַל־שְׂפַת־נַ֧חַל אַרְנֹ֛ן וְעַד־הַ֥ר שִׂיאֹ֖ן ה֥וּא חֶרְמֹֽון׃ ");
INSERT INTO hbo_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","וְכָל־הָ֨עֲרָבָ֜ה עֵ֤בֶר הַיַּרְדֵּן֙ מִזְרָ֔חָה וְעַ֖ד יָ֣ם הָעֲרָבָ֑ה תַּ֖חַת אַשְׁדֹּ֥ת הַפִּסְגָּֽה׃ פ ");
INSERT INTO hbo_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","וַיִּקְרָ֣א מֹשֶׁה֮ אֶל־כָּל־יִשְׂרָאֵל֒ וַיֹּ֣אמֶר אֲלֵהֶ֗ם שְׁמַ֤ע יִשְׂרָאֵל֙ אֶת־הַחֻקִּ֣ים וְאֶת־הַמִּשְׁפָּטִ֔ים אֲשֶׁ֧ר אָנֹכִ֛י דֹּבֵ֥ר בְּאָזְנֵיכֶ֖ם הַיֹּ֑ום וּלְמַדְתֶּ֣ם אֹתָ֔ם וּשְׁמַרְתֶּ֖ם לַעֲשֹׂתָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","יְהוָ֣ה אֱלֹהֵ֗ינוּ כָּרַ֥ת עִמָּ֛נוּ בְּרִ֖ית בְּחֹרֵֽב׃ ");
INSERT INTO hbo_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","לֹ֣א אֶת־אֲבֹתֵ֔ינוּ כָּרַ֥ת יְהוָ֖ה אֶת־הַבְּרִ֣ית הַזֹּ֑את כִּ֣י אִתָּ֗נוּ אֲנַ֨חְנוּ אֵ֥לֶּה פֹ֛ה הַיֹּ֖ום כֻּלָּ֥נוּ חַיִּֽים׃ ");
INSERT INTO hbo_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","פָּנִ֣ים ׀ בְּפָנִ֗ים דִּבֶּ֨ר יְהוָ֧ה עִמָּכֶ֛ם בָּהָ֖ר מִתֹּ֥וךְ הָאֵֽשׁ׃ ");
INSERT INTO hbo_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","אָ֠נֹכִי עֹמֵ֨ד בֵּין־יְהוָ֤ה וּבֵֽינֵיכֶם֙ בָּעֵ֣ת הַהִ֔וא לְהַגִּ֥יד לָכֶ֖ם אֶת־דְּבַ֣ר יְהוָ֑ה כִּ֤י יְרֵאתֶם֙ מִפְּנֵ֣י הָאֵ֔שׁ וְלֹֽא־עֲלִיתֶ֥ם בָּהָ֖ר לֵאמֹֽר׃ ס ");
INSERT INTO hbo_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","אָֽנֹכִי֙ יְהוָ֣ה אֱלֹהֶ֔יךָ אֲשֶׁ֧ר הֹוצֵאתִ֛יךָ מֵאֶ֥רֶץ מִצְרַ֖יִם מִבֵּ֣ית עֲבָדִֽ֑ים׃ ");
INSERT INTO hbo_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","לֹ֣א יִהְיֶ֥ה־לְךָ֛֩ אֱלֹהִ֥֨ים אֲחֵרִ֖֜ים עַל־פָּנָֽ֗יַ׃ ");
INSERT INTO hbo_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","לֹֽ֣א־תַעֲשֶׂ֥ה־לְךָ֥֣ פֶ֣֙סֶל֙ ׀ כָּל־תְּמוּנָ֔֡ה אֲשֶׁ֤֣ר בַּשָּׁמַ֣֙יִם֙ ׀ מִמַּ֔֡עַל וַאֲשֶׁ֥ר֩ בָּאָ֖֨רֶץ מִתָּ֑֜חַת וַאֲשֶׁ֥ר בַּמַּ֖֣יִם ׀ מִתַּ֥֣חַת לָאָֽ֗רֶץ׃ ");
INSERT INTO hbo_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","לֹא־תִשְׁתַּחֲוֶ֥֣ה לָהֶ֖ם֮ וְלֹ֣א תָעָבְדֵ֑ם֒ כִּ֣י אָנֹכִ֞י יְהוָ֤ה אֱלֹהֶ֙יךָ֙ אֵ֣ל קַנָּ֔א פֹּ֠קֵד עֲוֹ֨ן אָבֹ֧ות עַל־בָּנִ֛ים וְעַל־שִׁלֵּשִׁ֥ים וְעַל־רִבֵּעִ֖ים לְשֹׂנְאָֽ֑י׃ ");
INSERT INTO hbo_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","וְעֹ֤֥שֶׂה חֶ֖֙סֶד֙ לֽ͏ַאֲלָפִ֑֔ים לְאֹהֲבַ֖י וּלְשֹׁמְרֵ֥י *מִצְוֹתֹו (מִצְוֹתָֽי)׃ ס ");
INSERT INTO hbo_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","לֹ֥א תִשָּׂ֛א אֶת־שֵֽׁם־יְהוָ֥ה אֱלֹהֶ֖יךָ לַשָּׁ֑וְא כִּ֣י לֹ֤א יְנַקֶּה֙ יְהוָ֔ה אֵ֛ת אֲשֶׁר־יִשָּׂ֥א אֶת־שְׁמֹ֖ו לַשָּֽׁוְא׃ ס ");
INSERT INTO hbo_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","שָׁמֹ֣֛ור אֶת־יֹ֥ום֩ הַשַּׁבָּ֖֨ת לְקַדְּשֹׁ֑֜ו כַּאֲשֶׁ֥ר צִוְּךָ֖֣ ׀ יְהוָ֥֣ה אֱלֹהֶֽ֗יךָ ");
INSERT INTO hbo_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","שֵׁ֤֣שֶׁת יָמִ֣ים֙ תּֽ͏ַעֲבֹ֔ד֮ וְעָשִׂ֖֣יתָ כָּֿל־מְלַאכְתֶּֽךָ֒׃ ");
INSERT INTO hbo_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","וְיֹ֙ום֙ הַשְּׁבִיעִ֜֔י שַׁבָּ֖֣ת ׀ לַיהוָ֖֣ה אֱלֹהֶ֑֗יךָ לֹ֣א תַעֲשֶׂ֣ה כָל־מְלָאכָ֡ה אַתָּ֣ה וּבִנְךָֽ־וּבִתֶּ֣ךָ וְעַבְדְּךָֽ־וַ֠אֲמָתֶךָ וְשֹׁורְךָ֨ וַחֲמֹֽרְךָ֜ וְכָל־בְּהֶמְתֶּ֗ךָ וְגֵֽרְךָ֙ אֲשֶׁ֣ר בִּשְׁעָרֶ֔יךָ לְמַ֗עַן יָנ֛וּחַ עַבְדְּךָ֥ וַאֲמָתְךָ֖ כָּמֹֽ֑וךָ׃ ");
INSERT INTO hbo_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","וְזָכַרְתָּ֞֗ כִּ֣י־עֶ֤֥בֶד הָיִ֣֙יתָ֙ ׀ בְּאֶ֣רֶץ מִצְרַ֔֗יִם וַיֹּצִ֨אֲךָ֜֩ יְהוָ֤֨ה אֱלֹהֶ֤֙יךָ֙ מִשָּׁ֔ם֙ בְּיָ֤֥ד חֲזָקָ֖ה֙ וּבִזְרֹ֣עַ נְטוּיָ֑֔ה עַל־כֵּ֗ן צִוְּךָ֙ יְהוָ֣ה אֱלֹהֶ֔יךָ לַעֲשֹׂ֖ות אֶת־יֹ֥ום הַשַּׁבָּֽת׃ ס ");
INSERT INTO hbo_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","כַּבֵּ֤ד אֶת־אָבִ֙יךָ֙ וְאֶת־אִמֶּ֔ךָ כַּאֲשֶׁ֥ר צִוְּךָ֖ יְהוָ֣ה אֱלֹהֶ֑יךָ לְמַ֣עַן ׀ יַאֲרִיכֻ֣ן יָמֶ֗יךָ וּלְמַ֙עַן֙ יִ֣יטַב לָ֔ךְ עַ֚ל הָֽאֲדָמָ֔ה אֲשֶׁר־יְהוָ֥ה אֱלֹהֶ֖יךָ נֹתֵ֥ן לָֽךְ׃ ס ");
INSERT INTO hbo_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","לֹ֥֖א תִּֿרְצָֽח׃ ס ");
INSERT INTO hbo_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","וְלֹ֖֣א תִּֿנְאָֽ֑ף׃ ס ");
INSERT INTO hbo_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","וְלֹ֖֣א תִּֿגְנֹֽ֔ב׃ ס ");
INSERT INTO hbo_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","וְלֹֽא־תַעֲנֶ֥ה בְרֵֽעֲךָ֖ עֵ֥ד שָֽׁוְא׃ ס ");
INSERT INTO hbo_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","וְלֹ֥א תַחְמֹ֖ד אֵ֣שֶׁת רֵעֶ֑ךָ ס וְלֹ֨א תִתְאַוֶּ֜ה בֵּ֣ית רֵעֶ֗ךָ שָׂדֵ֜הוּ וְעַבְדֹּ֤ו וַאֲמָתֹו֙ שֹׁורֹ֣ו וַחֲמֹרֹ֔ו וְכֹ֖ל אֲשֶׁ֥ר לְרֵעֶֽךָ׃ ס ");
INSERT INTO hbo_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","אֶֽת־הַדְּבָרִ֣ים הָאֵ֡לֶּה דִּבֶּר֩ יְהוָ֨ה אֶל־כָּל־קְהַלְכֶ֜ם בָּהָ֗ר מִתֹּ֤וךְ הָאֵשׁ֙ הֶֽעָנָ֣ן וְהָֽעֲרָפֶ֔ל קֹ֥ול גָּדֹ֖ול וְלֹ֣א יָסָ֑ף וַֽיִּכְתְּבֵ֗ם עַל־שְׁנֵי֙ לֻחֹ֣ת אֲבָנִ֔ים וַֽיִּתְּנֵ֖ם אֵלָֽי׃ ");
INSERT INTO hbo_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","וַיְהִ֗י כְּשָׁמְעֲכֶ֤ם אֶת־הַקֹּול֙ מִתֹּ֣וךְ הַחֹ֔שֶׁךְ וְהָהָ֖ר בֹּעֵ֣ר בָּאֵ֑שׁ וַתִּקְרְב֣וּן אֵלַ֔י כָּל־רָאשֵׁ֥י שִׁבְטֵיכֶ֖ם וְזִקְנֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","וַתֹּאמְר֗וּ הֵ֣ן הֶרְאָ֜נוּ יְהוָ֤ה אֱלֹהֵ֙ינוּ֙ אֶת־כְּבֹדֹ֣ו וְאֶת־גָּדְלֹ֔ו וְאֶת־קֹלֹ֥ו שָׁמַ֖עְנוּ מִתֹּ֣וךְ הָאֵ֑שׁ הַיֹּ֤ום הַזֶּה֙ רָאִ֔ינוּ כִּֽי־יְדַבֵּ֧ר אֱלֹהִ֛ים אֶת־הָֽאָדָ֖ם וָחָֽי׃ ");
INSERT INTO hbo_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","וְעַתָּה֙ לָ֣מָּה נָמ֔וּת כִּ֣י תֹֽאכְלֵ֔נוּ הָאֵ֥שׁ הַגְּדֹלָ֖ה הַזֹּ֑את אִם־יֹסְפִ֣ים ׀ אֲנַ֗חְנוּ לִ֠שְׁמֹעַ אֶת־קֹ֨ול יְהוָ֧ה אֱלֹהֵ֛ינוּ עֹ֖וד וָמָֽתְנוּ׃ ");
INSERT INTO hbo_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","כִּ֣י מִ֣י כָל־בָּשָׂ֡ר אֲשֶׁ֣ר שָׁמַ֣ע קֹול֩ אֱלֹהִ֨ים חַיִּ֜ים מְדַבֵּ֧ר מִתֹּוךְ־הָאֵ֛שׁ כָּמֹ֖נוּ וַיֶּֽחִי׃ ");
INSERT INTO hbo_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","קְרַ֤ב אַתָּה֙ וּֽשֲׁמָ֔ע אֵ֛ת כָּל־אֲשֶׁ֥ר יֹאמַ֖ר יְהוָ֣ה אֱלֹהֵ֑ינוּ וְאַ֣תְּ ׀ תְּדַבֵּ֣ר אֵלֵ֗ינוּ אֵת֩ כָּל־אֲשֶׁ֨ר יְדַבֵּ֜ר יְהוָ֧ה אֱלֹהֵ֛ינוּ אֵלֶ֖יךָ וְשָׁמַ֥עְנוּ וְעָשִֽׂינוּ׃ ");
INSERT INTO hbo_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","וַיִּשְׁמַ֤ע יְהוָה֙ אֶת־קֹ֣ול דִּבְרֵיכֶ֔ם בְּדַבֶּרְכֶ֖ם אֵלָ֑י וַיֹּ֨אמֶר יְהוָ֜ה אֵלַ֗י שָׁ֠מַעְתִּי אֶת־קֹ֨ול דִּבְרֵ֜י הָעָ֤ם הַזֶּה֙ אֲשֶׁ֣ר דִּבְּר֣וּ אֵלֶ֔יךָ הֵיטִ֖יבוּ כָּל־אֲשֶׁ֥ר דִּבֵּֽרוּ׃ ");
INSERT INTO hbo_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","מִֽי־יִתֵּ֡ן וְהָיָה֩ לְבָבָ֨ם זֶ֜ה לָהֶ֗ם לְיִרְאָ֥ה אֹתִ֛י וְלִשְׁמֹ֥ר אֶת־כָּל־מִצְוֹתַ֖י כָּל־הַיָּמִ֑ים לְמַ֨עַן יִיטַ֥ב לָהֶ֛ם וְלִבְנֵיהֶ֖ם לְעֹלָֽם׃ ");
INSERT INTO hbo_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","לֵ֖ךְ אֱמֹ֣ר לָהֶ֑ם שׁ֥וּבוּ לָכֶ֖ם לְאָהֳלֵיכֶֽם׃ ");
INSERT INTO hbo_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","וְאַתָּ֗ה פֹּה֮ עֲמֹ֣ד עִמָּדִי֒ וַאֲדַבְּרָ֣ה אֵלֶ֗יךָ אֵ֧ת כָּל־הַמִּצְוָ֛ה וְהַחֻקִּ֥ים וְהַמִּשְׁפָּטִ֖ים אֲשֶׁ֣ר תְּלַמְּדֵ֑ם וְעָשׂ֣וּ בָאָ֔רֶץ אֲשֶׁ֧ר אָנֹכִ֛י נֹתֵ֥ן לָהֶ֖ם לְרִשְׁתָּֽהּ׃ ");
INSERT INTO hbo_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","וּשְׁמַרְתֶּ֣ם לַעֲשֹׂ֔ות כַּאֲשֶׁ֥ר צִוָּ֛ה יְהוָ֥ה אֱלֹהֵיכֶ֖ם אֶתְכֶ֑ם לֹ֥א תָסֻ֖רוּ יָמִ֥ין וּשְׂמֹֽאל׃ ");
INSERT INTO hbo_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","בְּכָל־הַדֶּ֗רֶךְ אֲשֶׁ֨ר צִוָּ֜ה יְהוָ֧ה אֱלֹהֵיכֶ֛ם אֶתְכֶ֖ם תֵּלֵ֑כוּ לְמַ֤עַן תִּֽחְיוּן֙ וְטֹ֣וב לָכֶ֔ם וְהַאֲרַכְתֶּ֣ם יָמִ֔ים בָּאָ֖רֶץ אֲשֶׁ֥ר תִּֽירָשֽׁוּן׃ ");
INSERT INTO hbo_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","וְזֹ֣את הַמִּצְוָ֗ה הַֽחֻקִּים֙ וְהַמִּשְׁפָּטִ֔ים אֲשֶׁ֥ר צִוָּ֛ה יְהוָ֥ה אֱלֹה