﻿USE sofia;
DROP TABLE IF EXISTS sofia.haw1868_vpl;
CREATE TABLE haw1868_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES haw1868_vpl WRITE;
INSERT INTO haw1868_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","I KINOHI hana ke Akua i ka lani a me ka honua. ");
INSERT INTO haw1868_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","He ano ole ka honua, ua olohelohe; a maluna no o ka hohonu ka pouli. Hoopunana iho la ka Uhane o ke Akua maluna o ka wai. ");
INSERT INTO haw1868_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","I iho la ke Akua, I malamalama; a ua malamalama ae la. ");
INSERT INTO haw1868_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Nana ae la ke Akua i ka malamalama, ua maikai: a hookaawale ae la ke Akua mawaena o ka malamalama, a me ka pouli. ");
INSERT INTO haw1868_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Kapa mai la ke Akua i ka malamalama, he Ao, a kapa mai hoi ia i ka pouli, he Po. A o ke ahiahi a me ke kakahiaka, o ka la mua ia. ");
INSERT INTO haw1868_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","I iho la ke Akua, I aouli mawaena o na wai, i mea hookaawale i kekahi wai me kekahi wai. ");
INSERT INTO haw1868_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Hana iho la ke Akua i ke aouli; a hookaawale ae la ia i ka wai malalo o ke aouli, me ka wai maluna o ke aouli: a pela io no. ");
INSERT INTO haw1868_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Kapa iho la ke Akua i ke aouli, he Lani. A o ke ahiahi a me ke kakahiaka, o ka lua ia o ka la. ");
INSERT INTO haw1868_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","I iho la ke Akua, E hui pu na wai malalo o ka lani i kahi hookahi, i ikea ai kahi maloo: a pela io no. ");
INSERT INTO haw1868_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Kapa iho la ke Akua i kahi maloo, he Aina; a kapa iho la oia i na wai i hui pu ia 'i, o na moana: a nana ae la ke Akua, ua maikai. ");
INSERT INTO haw1868_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","I iho la ke Akua, E hooulu mai ka honua i ka mauu, a me ka launahele e hua ana i ka hua, a me ka laau hua e hua ana hoi ma kona ano iho, iloko ona iho kona hua maluna o ka honua: a pela io no. ");
INSERT INTO haw1868_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","A hooulu mai la ka honua i ka mauu, a me ka launahele e hua ana i ka hua ma kona ano iho, a me ka laau e hua ana i ka hua, iloko ona kona hua ma kona ano iho: nana iho la hoi ke Akua, ua maikai. ");
INSERT INTO haw1868_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","A o ke ahiahi a me ke kakahiaka, o ke kolu ia o ka la. ");
INSERT INTO haw1868_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","I iho la ke Akua, I mau malamalama iloko o ke aouli o ka lani, i mea hookaawale i ke ao a me ka po; i mau hoailona lakou no na kau, a no na la, a me na makahiki: ");
INSERT INTO haw1868_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","I mau kukui hoi lakou iloko o ke aouli o ka lani, e hoomalamalama mai ai i ka honua: a pela io no. ");
INSERT INTO haw1868_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Hana iho la ke Akua i na malamalama nui elua: o ka malamalama nui, e alii ai maluna o ke ao, a o ka malamalama uuku iho, e alii ai maluna o ka po, a me na hoku hoi. ");
INSERT INTO haw1868_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Kau aku la ke Akua ia mau mea ma ke aouli o ka lani, e hoomalamalama mai ai i ka honua, ");
INSERT INTO haw1868_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","E hooalii hoi maluna o ke ao a me ka po, a e hookaawale ae i ka malamalama a me ka pouli: a nana iho la ke Akua, ua maikai. ");
INSERT INTO haw1868_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","A o ke ahiahi a me ke kakahiaka, o ka ha ia o ka la. ");
INSERT INTO haw1868_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","I iho la ke Akua, E hoohua nui mai na wai i na mea ola e holo ana, a me na manu e lele ae maluna o ka honua, ma ka lewa akea o ka lani. ");
INSERT INTO haw1868_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Hana iho la ke Akua i na ia nui, a me na mea ola a pau e holo ana, a ka wai i hoohua nui mai ai ma ko lakou ano iho a me na mea eheu hoi a pau ma ko lakou ano iho: a nana iho la ke Akua, ua maikai. ");
INSERT INTO haw1868_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Hoomaikai iho la ke Akua ia mau mea, i iho la, E hoohua ae oukou e hoolaha nui hoi, a e hoopiha i na wai o na moana; a e hoolaha ae na manu maluna o ka honua. ");
INSERT INTO haw1868_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","O ke kakahiaka a me ke ahiahi, o ka lima ia o ka la. ");
INSERT INTO haw1868_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","I iho la ke Akua, E hoohua mai ka honua i ka mea ola ma kona ano iho, i ka holoholona laka, me ka mea kolo, a me ka holoholona hihiu ma kona ano iho: a pela io no. ");
INSERT INTO haw1868_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Hana iho la ke Akua i ka holoholona hihiu ma kona ano iho, me na holoholona laka ma ko lakou ano iho, a me na mea kolo a pau o ka honua ma ko lakou ano iho: a nana iho la ke Akua, ua maikai. ");
INSERT INTO haw1868_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","I iho la ke Akua, E hana kakou i ke kanaka o ku ia kakou, ma ka like ana me kakou iho: a e hooalii ia ia maluna o na ia o ke kai, maluna hoi o na manu o ka lewa, maluna hoi o na holoholona laka, a maluna hoi o ka honua a pau, a maluna no hoi o na mea kolo a pau e kolo ana ma ka honua. ");
INSERT INTO haw1868_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Hana iho la ke Akua i ke kanaka ma kona ano iho, ma ke ano o ke Akua oia i hana'i ia ia; hana mai la ia i kane a i wahine. ");
INSERT INTO haw1868_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Hoomaikai mai la ke Akua ia laua, i mai la hoi ke Akua ia laua, E hoohua ae olua, e hoolaha hoi, e hoopiha i ka honua, a e lanakila maluna, a e noho alii maluna o na ia o ke kai, a me na manu o ka lewa, a me na mea a pau e kolo ana maluna o ka honua. ");
INSERT INTO haw1868_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","I mai la ke Akua, Aia hoi, na haawi aku au na olua i na launahele a pau e hua ana i ka hua maluna o ka honua a pau, a me na laau a pau iloko ona ka hua o ka laau e hua ana i ka hua; he mea ai ia na olua. ");
INSERT INTO haw1868_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","A na ka poe holoholona a pau o ka honua, me na manu a pau o ka lewa, a me na mea a pau e kolo ana ma ka honua, na mea e ola ana, na lakou ka nahelehele a pau i mea ai: a pela io no. ");
INSERT INTO haw1868_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Nana iho la ke Akua i na mea a pau ana i hana'i, aia hoi, ua maikai wale no. A o ke ahiahi a me ke kakahiaka, o ke ono ia o ka la. ");
INSERT INTO haw1868_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","PELA i paa ai ka lani a me ka honua i ka hanaia, a me ko laila poe mea a pau. ");
INSERT INTO haw1868_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","A i ka hiku o ka la, hooki iho la ke Akua i ka hana ana i hana'i: a hoornaha iho la oia i kana hana a pau ana i hana'i. ");
INSERT INTO haw1868_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Hoomaikai mai la ke Akua i ka hiku o ka la, a hoano iho la; no ka mea, hoomaha iho la oia ia la i ka hana a pau a ke Akua i hana'i. ");
INSERT INTO haw1868_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Eia ka mooolelo no ka lani a me ka honua i ka wa i hanaia'i ia mau mea, i ka la a Iehova a ke Akua i hana'i i ka honua a me ka lani. ");
INSERT INTO haw1868_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","A me na mea kanu a pau o ka mahiuaai, i ka wa aole ia maloko o ka honua, a mo na launahele a pau o ke kula mamua o kona ulu ana: no ka mea, aole i hooua mai o Iehova ko Akua i ka ua maluna o ka honua, aole hoi he kanaka nana e mahi ka aina. ");
INSERT INTO haw1868_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Aka, pii aku la ka ohu mai ka honua aku, a hoomau iho la i ka ili a pau o ka aina. ");
INSERT INTO haw1868_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Hana iho la o Iehova ke Akua i ke kanaka, he lepo o ka honua, a ha iho la ia i ka hanu ola iloko o na puka ihu ona; a lilo ae la ke kanaka i mea ola. ");
INSERT INTO haw1868_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Kanu iho la o Iehova ke Akua i ka mahinaai maloko o Edena ma ka hikina; a malaila oia i hoonoho iho ai i ke kanaka ana i hana'i. ");
INSERT INTO haw1868_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Hooulu ae la o Iehova ke Akua i na laau a pau mailoko ae o ka honua, i na mea oluolu no ka maka, i na mea ono hoi ke ai; i ka laau o ke ola hoi iwaena konu o ka mahinaai, a me ka laau i ikea'i ka pono a me ka hewa. ");
INSERT INTO haw1868_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Kahe ae la kekahi muliwai mai Edena aku e hoomau i ka mahinaai; a malaila aku, manamana ae la ia a lilo i eha mana. ");
INSERT INTO haw1868_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","O Pisona ka inoa o ka mua: oia no ka mea o hoopuni ana i ka aina a pau o Havila, he wahi gula ia; ");
INSERT INTO haw1868_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","A he maikai ke gula o ia aina: ilaila no ka deliuma a me ka pohaku onika. ");
INSERT INTO haw1868_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","O Gihona ka inoa o ka lua o ka muliwai: oia ka mea e hoopuni ana i ka aina a pau o Aitiopa. ");
INSERT INTO haw1868_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","O Hidekela ka inoa o ke kolu o ka muliwai: oia ka mea e kahe ana ma ka aoao hikina o Asuria. A o Euperate ka inoa o ka ha o ka muliwai. ");
INSERT INTO haw1868_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Lawe ae la o Iehova ke Akua i ke kanaka, a hoonoho iho la ia ia ma ka mahinaai ma Edena, e mahi a e malama ia wahi. ");
INSERT INTO haw1868_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Kauoha mai la o Iehova ke Akua i ke kanaka, i mai la, E ai wale oe i ko keia laau kela laau o ka mahinaai nei: ");
INSERT INTO haw1868_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Aka, o ko ka laau i ikea ai ka pono a me ka hewa, mai ai iho oe ia mea: no ka mea, i kou la e ai ai ia mea, he oiaio no e make oe. ");
INSERT INTO haw1868_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","I iho la o Iehova ke Akua, Aole pono ke kanaka ke noho, oia wale; e hana no wau i kokoolua nona e ku ia ia. ");
INSERT INTO haw1868_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","No ka lepo i hana'i o Iehova ke Akua i na holoholona a pau o ke kula, a me na manu a pau o ka lewa, a kai mai la ia lakou io Adamu la, i ikea na inoa a Adamu e kapa aku ai ia lakou: a o ka inoa a Adamu i kapa aku ai i na mea ola a pau, oia iho la kona inoa. ");
INSERT INTO haw1868_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Kapa aku la o Adamu i na inoa no na holoholona laka a pau, a no na manu o ka lewa, a no na holoholona hihiu a pau; aka no Adamu, aole i loaa kona kokoolua e ku ia ia. ");
INSERT INTO haw1868_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Hookau mai la o Iehova ke Akua i ka hiamoe nui ia Adamu, a hiamoe iho la ia: unuhi ae la kela i kekahi iwiaoao ona, a hoopili iho la ia i ka io ma kona wahi. ");
INSERT INTO haw1868_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","A o ka iwiaoao a Iehova ke Akua i unuhi mai ai noloko mai o ke kanaka, hana iho la oia ia mea i wahine, a alakai ae la ia ia i ke hanaka. ");
INSERT INTO haw1868_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","I aku la o Adamu, Oia nei no ka iwi o kuu mau iwi, a me ka io o kuu io; e kapaia oia nei, wahine, no ka mea, ua unuhiia ae oia mailoko ae o ke kane. ");
INSERT INTO haw1868_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","No keia mea, e haalele aku ke kanaka i kona makuakane a me kona makuwahine, a e pili aku oia i kana wahine: a e lilo laua i io hookahi. ");
INSERT INTO haw1868_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Aohe kapa o laua a elua, o ke kane a me kana wahine, aole hoi o laua hilahila. ");
INSERT INTO haw1868_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","U A oi aku ka maalea o ka nahesa i ko na holoholona o ke kula a pau a Iehova ke Akua i hana'i. I mai la ia i ka wahine, He oiaio anei, ua papa mai ke Akua, Aole olua e ai i ko na laau a pau o ka mahinaai nei! ");
INSERT INTO haw1868_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","I aku la ka wahine i ka nahesa, E pono no maua ke ai i ka hua o na laau o ka mahinaai nei: ");
INSERT INTO haw1868_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Aka, o ka hua o ka laau iwaena konu o ke kihapai, ua i mai ke Akua, Mai ai olua ia mea, aole hoi e hoopa aku, o make olua. ");
INSERT INTO haw1868_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Olelo mai la ka nahesa i ka wahine, Aohe oiaio e make olua: ");
INSERT INTO haw1868_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","No ka mea, ua ike no ke Akua, a i ka la e ai ai olua ia mea, e hookaakaaia auanei ko olua mau maka; a e like olua me ke Akua, i ka ike i ka pono a me ka hewa. ");
INSERT INTO haw1868_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","A ike ae la ka wahine, he ono ko ia laau i mea ai, a he maikai hoi i na maka, a he laau makemakeia i mea hoonaauao, lalau aku la ia i kona hua, ai iho la, a haawi aku la hoi na kana kane me ia, a ai iho la no hoi oia. ");
INSERT INTO haw1868_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","A hookaakaaia ae la na maka o laua a elua, a ike iho la laua, aohe o laua kapa; kui iho la laua i na lau fiku a paa, i mau papalu no laua. ");
INSERT INTO haw1868_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Lohe ae la laua i ka leo o Iehova ke Akua, e holoholo ana ma ka mahinaai i ka wa malu o ka la: pee iho la o Adamu me kana wahine mawaena o na laau o ua mahinaai la, mai ke alo aku o Iehova ke Akua. ");
INSERT INTO haw1868_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Hea mai la o Iehova ke Akua ia Adamu, i mai la ia ia, Auhea oe? ");
INSERT INTO haw1868_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","I aku la oia, I lohe au i kou leo iloko o ka mahinaai nei, a makau no wau, no ka mea, aohe o'u kapa, a pee iho la au. ");
INSERT INTO haw1868_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","I mai la kela, Nawai i hai mai ia oe, aohe ou kapa? Ua ai anei oe i ko ka laau a'u i papa aku ai ia oe, Mai ai oe! ");
INSERT INTO haw1868_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Olelo aku la ke kanaka, Na ka wahine au i haawi mai ai na'u, nana no i haawi mai i ko ka laau, a ai iho la au. ");
INSERT INTO haw1868_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","I mai la o Iehova ke Akua i ka wahine, Heaha keia mea au i hana'i! I aku la ka wahine, Na ka nahesa wau i hoowalewale mai, a ai iho la au. ");
INSERT INTO haw1868_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","I aku la o Iehova ke Akua i ka nahesa, No kau hana ana ia mea, e oi aku kou ahewaia i ko na holoholona laka a pau, a i ko na holoholona hihiu a pau o ke kula; ilalo kou alo e kolo ai oe, o ka lepo kau e ai ai, a pau na la o kou ola ana. ");
INSERT INTO haw1868_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","E waiho no au i ka inaina mawaena o olua a me ka wahine, a mawaena hoi o kou hua a me kona hua; nana e paopao iho kou poo, a nau hoi e pakuikui aku kona kuekuewawae. ");
INSERT INTO haw1868_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","I mai la hoi oia i ka wahine, E hoonui loa aku au i ka eha o kou hapai ana: me ka eha hoi oe e hanau mai ai i na keiki; a o kou makemake aku aia no ia i kau kane, a oia hoi kou haku. ");
INSERT INTO haw1868_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","I mai la hoi oia ia Adamu, No ka mea, ua hoolohe oe i ka leo o kau wahine, a ua ai hoi i ko ka laau a'u i papa aku ai ia oe, i ka i ana, Mai ai oe ia mea, ua hoohewaia ka aina nou; me ka luhi oe e ai ai i kana, a pau na la o kou ola ana: ");
INSERT INTO haw1868_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","E hookupu mai no hoi ia i na kakalaioa a me na puakala nau; a nau no e ai i na mea kanu o ka waena. ");
INSERT INTO haw1868_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Me ka hou o kou maka e ai ai oe i ka ai, a hiki i kou wa e hoi hou aku ai i ka lepo; no ka mea, mailaila oe i laweia mai ai; no ka mea, he lepo no oe, a e hoi hou aku oe i ka lepo. ");
INSERT INTO haw1868_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Kapa aku la o Adamu i ka inoa o kana wahine, o I Eva; no ka mea, ka makuwahine ia o na kanaka a pau. ");
INSERT INTO haw1868_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","A hana iho la o Iehova ke Akua i na kapa ili no Adamu a no kana wahine, a hoaahu iho la ia laua. ");
INSERT INTO haw1868_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","I iho la o Iehova ke Akua, Aia hoi, ua like ke kanaka me kekahi o kakou, ka ike i ka pono a me ka hewa: ano hoi, o lalau aku kona lima, a lawe hoi i ko ka laau ola, ai iho a ola mau loa aku: ");
INSERT INTO haw1868_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","No ia mea, kipaku aku la o Iehova ke Akua ia ia iwaho o ke kihapai o Edena, e mahi i ka lepo, kahi ana i laweia mai ai. ");
INSERT INTO haw1868_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Pela oia i kipaku ai i ke kanaka; a hoonoho iho la ma ka hikina o ka mahinaai o Edena i na kerubima, a me ka pahi wakawaka e ka ana io ia nei i maluhia'i ke ala ma ka laau ola. ");
INSERT INTO haw1868_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","A IKE aku la o Adamu i kana wahine ia Eva; hapai ae la oia, a hanau mai la ia I Kaina, i mai la, Ua loaa no ia'u he kanaka no Iehova mai. ");
INSERT INTO haw1868_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Hanau hou iho la oia i kona kaikaina ia Abela. He kahuhipa o Abela, a he mahiai o Kaina. ");
INSERT INTO haw1868_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Mahope iho o na la, lawe aku la o Kaina i kekahi hua o ka honua i mohai na Iehova. ");
INSERT INTO haw1868_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Lawe aku la hoi o Abela i kekahi o na hanau mua o kana poe hipa, i na mea momona hoi. A maliu mai la o Iehova ia Abela a me kana mohai: ");
INSERT INTO haw1868_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Aka, aole ia i maliu mai ia Kaina a me kana mohai. Huhu loa iho la o Kaina, a kulou iho la kona maka ilalo. ");
INSERT INTO haw1868_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","I mai la o Iehova ia Kaina, Heaha kau i huhu ai? No ke aha hoi i kulou iho ai kou maka ilalo! ");
INSERT INTO haw1868_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","A i hana pono oe, aole anei oe e maliuia'ku? a i ole oe e hana i ka pono, ke waiho la ka mohai hala ma ka puka. A ia oe no ko ia la makemake, a e alii iho oe maluna ona. ");
INSERT INTO haw1868_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Kamailio ae la o Kaina me kona kaikaina, me Abela: a ia laua ma ka waena, ku ae la o Kaina me ke ku e i kona kaikaina ia Abela, pepehi iho la ia ia a make. ");
INSERT INTO haw1868_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Olelo mai la o Iehova ia Kaina, Auhea la o Abela o kou kaikaina! I aku la oia, Aole au i ike: owau anei ke kahu o kuu kaikaina! ");
INSERT INTO haw1868_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","I mai la kela, Heaha kau i hana iho net? ke hea mai nei ka leo o ke koko o kou kaikaina ia'u mai ka lepo mai. ");
INSERT INTO haw1868_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Ma keia hone aku, e hoohewaia'ku ai oe mai ka honua ae, i hamama ae kona waha e ale i ke koko o kou kaikaina, na kou lima aku. ");
INSERT INTO haw1868_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","I kou mahi ana i ka honua, aole ia e hua mai ma keia hope i kona momona: a e lilo hoi oe i kanaka aea a me ke kuewa wale maluna o ka honua. ");
INSERT INTO haw1868_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","I aku la o Kaina ia Iehova, He nui loa kuu hewa: aole paha ia e hiki ke kalaia. ");
INSERT INTO haw1868_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Aia hoi, ua kipaku aku oe ia'u i keia la mai ke alo aku o ka honua nei; a ua hookaawaleia au mai kou alo aku; a e lilo ana au i kanaka aea me ke kuewa wale maluna o ka honua; a i loaa au i kekahi, e pepehi mai ia ia'u a make. ");
INSERT INTO haw1868_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","I mai la o Iehova ia ia, Nolaila, o ka mea nana e pepehi ia Kaina, e pahiku ka hoopai ana i kona hewa. A kau iho la o Iehova i hoailona maluna o Kaina, o loaa ia i kekahi nana ia e pepehi aku a make. ");
INSERT INTO haw1868_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Hele aku la o Kaina mai ke alo aku o Iehova, a noho iho la ma ka aina o Noda, ma ka hikina o Edena. ");
INSERT INTO haw1868_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Ike aku la o Kaina i kana wahine; hapai ae la oia, a hanau mai la ia Enoka: kukulu iho la oia i kulanakauhale, a kapa iho la i ka inoa o ua kulanakauhale la, mamuli o ka inoa o kana keiki, o Enoka. ");
INSERT INTO haw1868_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Na Enoka hoi i hanau mai o Irada: na Irada hoi o Mehuiaela: na Mehuiaela o Metusaela: na Metusaela o Lameka. ");
INSERT INTO haw1868_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lawe ae la o Lameka i na wahine elua nana: o Ada ka inoa o kekahi, a o Zila ka inoa o kekahi. ");
INSERT INTO haw1868_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Na Ada i hanau mai o Iabala: o ka makamua ia o ka poe noho halelewa, a o ka hanai holoholona. ");
INSERT INTO haw1868_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","A o Iubala ka inoa o kona kaikaina: o ka makamua ia o ka poe a pau i hookani i ka lira a me ka ohe. ");
INSERT INTO haw1868_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","A o Zila, hanau mai no hoi nana o Tubalakaina, oia ke kumu a na paahana a pau e kui ana i ke keleawe a me Ka hao: a o Naama ke kaikuwahine o Tubalakaina. ");
INSERT INTO haw1868_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","I aku la o Lameka i na wahine ana, ia Ada, laua o Zila, E hoolohe mai olua i ko'u leo; e na wahine a Lameka, e haliu mai i ka'u olelo: no ka mea, ua pepehi iho la au i ke kanaka no ka hoeha ana mai ia'u, i ke kanaka opiopio no ka paopao ana mai ia'u. ");
INSERT INTO haw1868_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Ina paha e pahiku ka hoopai ana no Kama, he oiaio no, e pakanahiku me kumamahiku hoi ia no Lameka. ");
INSERT INTO haw1868_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Ike hou iho la o Adamu i kana wahine; a hanau mai la ia he keikikane, a kapa aku la i kona inoa o I Seta: No ka mea, ua haawi mai la ke Akua i ka hua hou na'u, wahi ana, i panihakahaka no Abela i pepehiia e Kaina. ");
INSERT INTO haw1868_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Na Seta hoi i hanau kekahi keikikane; a kapa iho ia i kona inoa o Enosa: ia manawa ka hoomaka ana o na kanaka e kahea aku i ka inoa o Iehova. ");
INSERT INTO haw1868_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","EIA ka olelo kuauhau no na hanauna o Adamu. I ka la a ke Akua i hana'i ke kanaka, ma ke ano o ke Akua kana i hana mai ai ia ia. ");
INSERT INTO haw1868_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","He kane laua me ka wahine kana i hana'i; hoomaikai iho la oia ia laua, a kapa iho la i ko laua inoa o Adamu, i ka la i hanaia'i o laua. ");
INSERT INTO haw1868_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Hookahi haneri makahiki o ko Adamu ola ana a me kanakolu, a hanau mai nana ke keikikane i ku ia ia, ma kona ano iho; a kapa aku la i kona inoa o Seta: ");
INSERT INTO haw1868_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","O na la o Adamu mahope mai o ka hanau ana o Seta, ewalu ia haneri makahiki: a nana mai na keikikane a me na kaikamahine: ");
INSERT INTO haw1868_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","O na la a pau o ko Adamu ola ana, he eiwa haneri makahiki a me kanakolu: a make iho la ia. ");
INSERT INTO haw1868_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Hookahi haneri makahiki a me kumamalima o ko Seta ola ana, a hanau ae la o Enosa nana: ");
INSERT INTO haw1868_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Ewalu haneri makahiki o ko Seta ola ana a me kumamahiku mahope mai o ka hanau ana o Enosa, a nana mai na keikikane a me na kaikamahine. ");
INSERT INTO haw1868_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","O na la a pau o Seta, eiwa ia haneri makahiki a me ka umikumamalua: a make iho la ia. ");
INSERT INTO haw1868_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","He kanaiwa makahiki o ko Enosa ola ana, a hanau ae la o Kainana. ");
INSERT INTO haw1868_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Ewalu haneri makahiki a me ka umikumamalima o ko Enosa ola ana, mahope mai o ka hanau ana o Kainana, a nana mai na keikikane a me na kaikamahine: ");
INSERT INTO haw1868_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","O na la a pau o Enosa, eiwa haneri makahiki a me kumamalima: a make iho la ia. ");
INSERT INTO haw1868_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","He kanahiku na makahiki o ko Kainana ola ana, a hanau mai o Mahalaleela nana: ");
INSERT INTO haw1868_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Mahope mai o ka hanau ana o Mahalaleela, ewalu haneri makahiki o ko Kainana ola ana a me kanaha, a nana mai na keikikane a me na kaikamahine: ");
INSERT INTO haw1868_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","A o na la a pau o Kainana, eiwa haneri makahiki a me ka umi keu: a make iho la ia. ");
INSERT INTO haw1868_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","He kanaono na makahiki a me kumamalima o ko Mahalaleela ola ana, a hanau ae la o Iareda nana. ");
INSERT INTO haw1868_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Mahope mai o ko Iareda hanau ana, ewalu haneri makahiki a me ke kanakolu o ko Mahalaleela ola ana, a nana mai na keikikane a me na kaikamahine. ");
INSERT INTO haw1868_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","O na la a pau o Mahalaleela, ewalu ia haneri makahiki a me kanaiwa kumamalima: a make iho la ia. ");
INSERT INTO haw1868_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Hookahi haneri makahiki o ko Iareda ola ana a me kanaonokumamalua, a hanau ae la o Enoka nana. ");
INSERT INTO haw1868_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Mahope mai o ka hanau ana o Enoka, ewalu haneri makahiki o ko Iareda ola ana, a nana mai na keikikane a me na kaikamahine. ");
INSERT INTO haw1868_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","O na la a pau o Iareda, eiwa ia haneri makahiki a me ke kanaonokumamalua: a make iho la ia. ");
INSERT INTO haw1868_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","He kanaonokumamalima na makahiki o ko Enoka ola ana, a hanau ae la o Metusala nana. ");
INSERT INTO haw1868_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Hele pu ae la o Enoka me ke Akua, ekolu haneri makahiki mahope mai o ka hanau ana o Metusala, a nana mai na keikikane a me na kaikamahine: ");
INSERT INTO haw1868_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","O na la a pau o Enoka, ekolu haneri na makahiki a me kanaonokumamalima: ");
INSERT INTO haw1868_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Hele pu ae la o Enoka me ke Akua, aole ia i make; no ka mea, na ke Akua ia i lawe aku. ");
INSERT INTO haw1868_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Hookahi haneri makahiki o ko Metusala ola ana a me kanawalukumamahiku, a hanau ae la o Lameka nana. ");
INSERT INTO haw1868_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Mahope mai o ka hanau ana o Lameka, ehiku haneri me ke kanawalukumamalua na makahiki o ko Metusala ola ana, a nana mai na keikikane a me na kaikamahine. ");
INSERT INTO haw1868_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","O na la a pau o Metusala, eiwa haneri na makahiki a me kanaonokumamaiwa: a make iho la ia. ");
INSERT INTO haw1868_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Hookahi haneri na makahiki a me ke kanawalukumamalua o ko Lameka ola ana, a hanau ae la ke keikikane nana: ");
INSERT INTO haw1868_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Kapa aku la ia i kona inoa, o Noa, i ae la, E hoomaha mai oia nei ia kakou i ka kakou hana ana a me ka luhi ana a ko kakou mau lima, no ka honua a Iehova i hoino mai ai. ");
INSERT INTO haw1868_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Mahope mai o ka hanau ana o Noa, elima haneri na makahiki a me kanaiwakumamalima o ko Lameka ola ana, a nana mai na keikikane a me na kaikamahine. ");
INSERT INTO haw1868_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","A o na la a pau o Lameka, ehiku haneri makahiki a me kanahikukumamahiku: a make iho la ia. ");
INSERT INTO haw1868_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Elima haneri makahiki o Noa: a nana mai o Sema, a o Hama, a me Iapeta. ");
INSERT INTO haw1868_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","A I ka wa o ka hoomaka ana e mahuahua ai na kanaka maluna o ka honua, a ua hanau mai na kaikamahine a lakou. ");
INSERT INTO haw1868_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Ike ae la na keiki a ke Akua i na kaikamahine a na kanaka, ua maikai lakou; lalau aku la lakou i na mea a lakou i makemake ai i mau wahine na lakou. ");
INSERT INTO haw1868_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","I iho la o Iehova, Aole e noho loa ana kuu Uhane me kanaka, no ka mea, he kino no ia; aku, o kona mau la ma keia hope aku, he haneri makahiki ia a me ka iwakalua. ");
INSERT INTO haw1868_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Noho iho la na kanaka nunui ma ka honua ia manawa; a mahope aku, a komo aku la na keiki a ke Akua iloko i na kaikamahine a na kanaka, a hanau mai na lakou ka poe kanaka ikaika, he poe kanaka kaulana lakou i ka wa kahiko. ");
INSERT INTO haw1868_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","A ike mai la ke Akua, he nui ka hewa o kanaka ma ka honua, a ua hewa wale no ka noonoo ana o kona naau, ana i manao ai i na la a pau. ");
INSERT INTO haw1868_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","A mihi iho la o Iehova i kana hana ana i na kanaka maluna o ka honua, a ua ehaeha kona naau. ");
INSERT INTO haw1868_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","I iho la o Iehova, E luku auanei au i na kanaka a'u i hana'i, mai ke alo aku o ka honua, i na kanaka a me na holoholona, a me na mea kolo, a me na manu o ka lewa: no ka mea, ke mihi nei au i ka'u hana ana ia lakou: ");
INSERT INTO haw1868_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Aka, loaa ia Noa ke alohaia mai imua o Iehova. ");
INSERT INTO haw1868_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Eia ka mooolelo no Noa: He kanaka pono o Noa, a he hemolele iwaena o na hanauna ona, a hele pu o Noa me ke Akua. ");
INSERT INTO haw1868_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Ua hanau mai na Noa ekolu keikikane, o Sema, o Hama, a o Iapeta. ");
INSERT INTO haw1868_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Ua inoino hoi ka honua imua o ke Akua; a ua piha ka honua i ka hoino. ");
INSERT INTO haw1868_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Nana mai la ke Akua i ka honua, aia hoi, ua inoino ia; no ka mea, ua hana ino na kanaka a pau i ko lakou aoao ma ka honua. ");
INSERT INTO haw1868_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Olelo mai la o Iehova ia Noa, Ua hiki mai i ko'u alo nei ka hope o na mea ola a pau; no ka mea, ua piha ka honua i ka hoino ma o lakou la: aia hoi, e luku auanei au ia lakou ma ka honua. ");
INSERT INTO haw1868_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","E hana oe i halelana nou; e hana hoi oe i na keena maloko o ka halelana, a e hapala ae i ke kepau maloko a mawaho. ");
INSERT INTO haw1868_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Penei kau e hana aku ai: ekolu haneri kubita o ka loa o ka halelana, he kanalima na kubita ka laula, a he kanakolu na kubita o kona kiekie. ");
INSERT INTO haw1868_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","He malamalama kau e hana'i ma ka halelana, a e hoopaa ia mea maluna ma ke kubita; a e kau oe i ka pukakomo o ka halelana ma kona paia: a he papalalo, me ka papawaena, a me ka papaluna kau e hana'i ma ia mea. ");
INSERT INTO haw1868_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","A owau la e, e lawe mai ana au i ke kaiakahinalii maluna o ka honua, i mea e lukuia'i na mea io a pau, i ka poe nona ka hanu ola malalo o ka lani; a e make na mea a pau ma ka honua. ");
INSERT INTO haw1868_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Aka, e hoopaa aku au i ka'u berita ia oe; a e komo ae oe iloko o ka halelana, o oe, me kau mau keikikane, a me kau wahine, a me na wahine a kau mau keikikane. ");
INSERT INTO haw1868_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","A no na mea io a pau e ola ana, e lawe oe i elua o kela mea keia mea iloko o ka halelana, i kane i wahine, i malama ola pu ia lakou me oe. ");
INSERT INTO haw1868_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","O na manu ma ko lakou ano, a o na holoholona, ma ko lakou ano, a o kela mea kolo keia mea kolo o ka honua, ma kona ano iho, e hele papalua mai lakou iou la, i malama ola ia lakou. ");
INSERT INTO haw1868_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","E lawe oe nau i na mea ai a pau, a e hoiliili oe ia iou la; i mea ai nau, a na lakou. ");
INSERT INTO haw1868_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Pela o Noa i hana'i; ma ka mea a pau a ke Akua i kauoha mai ai ia ia, pela oia i hana'i. ");
INSERT INTO haw1868_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","I MAI ia o Iehova ia Noa, E komo ae oe me kau ohana a pau iloko o ka halelana; no ka mea, o oe no o keia hanauna ka'u i ike ai, he pono imua o'u. ");
INSERT INTO haw1868_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","O na holoholona maemae a pau, e lawe pahiku aku oe ia lakou me oe, i ke Kane a me kana wahine; a o na holoholona maemae ole, e papalua he kane me kana wahine, ");
INSERT INTO haw1868_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","E pahikuia no hoi na manu o ka lewa, ke kane, ka wahine, e hoola i kumuhoolaha maluna o ka honua a pau. ");
INSERT INTO haw1868_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","No ka mea, ehiku la e koe, alaila e hooua iho ai au maluna o ka honua he kanaha la a me na po; a e luku ana au i na mea ola a pau a'u i hana'i, mai ke alo o ka honua aku. ");
INSERT INTO haw1868_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Hana iho la o Noa i na mea a pau a Iehova i kauoha mai ai ia ia. ");
INSERT INTO haw1868_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Eono haneri na makahiki o Noa i ka wa i hiki mai ai ke kaiakahinalii maluna o ka honua. ");
INSERT INTO haw1868_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Komo aku la e Noa me na keikikane ana, a me kana wahine, a me na wahine a kana mau keikikane iloko o ka halelana, no ke kaiakahinalii. ");
INSERT INTO haw1868_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","O na holoholona maemae a me na holoholona maemae ole, a o na manu, a me na mea kolo a pau maluna o ka honua. ");
INSERT INTO haw1868_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","Komo papalua aku la lakou iloko io Noa la, ke kane, ka wahine, me ka ke Akua i kauoha mai ai ia Noa. ");
INSERT INTO haw1868_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","A hala ae la na la ehiku, hiki mai ke kaiakahinalii maluna o ka honua. ");
INSERT INTO haw1868_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","I ka makahiki eono haneri o ko Noa ola ana, i ka lua o ka malama, a ma ka la umikumamahiku o ua malama la, ia la no, huahuai mai la na panawai a pau o ka hohonu nui, a hamarna ae la na puka wai o ka lani. ");
INSERT INTO haw1868_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Hookahi kanaha la a me na po o ka ua ana maluna o ka honua. ");
INSERT INTO haw1868_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Ia la hookahi no, komo ae la o Noa, a o Sema, a o Hama, a o Iapeta, na keikikane a Noa, a me ka wahine a Noa, a me na wahine ekolu a kana mau keikikane me lakou, iloko o ka halelana. ");
INSERT INTO haw1868_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","O lakou me na holoholona hihiu a pau ma ko lakou ano iho, a me na holoholona laka a pau ma ko lakou ano iho, a me kela mea kolo keia mea kolo, e kolo ana maluna o ka honua ma kona ano iho, a me na manu a pau ma ko lakou ano iho, o na mea eheu a pau, o kela ano keia ano. ");
INSERT INTO haw1868_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Komo papalua ae la lakou io Noa la iloko o ka halelana, o na mea io a pau e ha ana i ka hanu ola. ");
INSERT INTO haw1868_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","He kane he wahine o na mea io a pau ka poe i komo aku iloko, mo ka ke Akua i kauoha mai ai ia ia: a papani ae la o Iehova i ka puka mahope ona. ");
INSERT INTO haw1868_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Hookahi kanaha la o ke kaiakahinalii maluna o ka honua; mahuahua ae la ka wai, a hoolana ae la i ka halelana, a ua kaikaiia ae la ia maluna o ka honua. ");
INSERT INTO haw1868_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Lanakila ae la ka wai a mahuahua loa ae la maluna o ka honua; a holo aku la ka halelana maluna o ka wai. ");
INSERT INTO haw1868_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Lanakila loa ae la ka wai maluna o ka honua; a uhiia ae la na kuahiwi kiekie a pau loa malalo o ka lani. ");
INSERT INTO haw1868_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","He umikumamalima na kubita o ke kiekie o ka wai maluna; a uhiia ae la na kuahiwi. ");
INSERT INTO haw1868_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","A make iho la na mea ola a pau i holo maluna o ka honua, o na manu, o na holoholona laka, o na holoholona hihiu, a o na mea kolo a pau e kolo ana maluna o ka honua, a me na kanaka a pau; ");
INSERT INTO haw1868_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","O ka poe a pau nona ka hanu ola iloko o na puka ihu, o na mea a pau ma ka aina maloo, make iho la lakou. ");
INSERT INTO haw1868_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","A pau loa iho la na mea ola maluna o ka honua i ka make, o na kanaka, me na holoholona, a me na mea kolo, a me na manu o ka lewa; a ua hoopauia lakou mai ka honua aku: o Noa wale no ka i koe, a me ka poe me ia iloko o ka halelana. ");
INSERT INTO haw1868_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","A lanakila ae la ka wai maluna o ka honua, hookahi haneri na la a me kanalima. ");
INSERT INTO haw1868_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","HOOMANAO iho la o Iehova ia Noa, a me na mea ola a pau, a me na holoholona a pau me ia iloko o ka halelana: hoohuai mai la ke Akua i ka makani maluna o ka honua, a emi iho la ka wai: ");
INSERT INTO haw1868_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Ua papaniia ae la na punawai o ka hohonu, a me na puka wai o ka lani, a malie iho ka ua mai luna mai: ");
INSERT INTO haw1868_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Hoi hou mau aku la ka wai mailuna ae o ka honua: a mahope o na la he haneri a me kanalima, ua emi ka wai. ");
INSERT INTO haw1868_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","A i ka hiku o ka malama, i ka la umikumamahiku o ua malama la, ili iho la ka halelana ma na kuahiwi o Ararata. ");
INSERT INTO haw1868_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Emi mau iho la ka wai, a hiki i ka umi o ka malama: i ka umi o ka malama, i ka la mua o ua malama la, ua ikea na wahi kiekie o na kuahiwi. ");
INSERT INTO haw1868_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","A hala na la he kanaha, wehe ae la o Noa i ka puka makani o ka halelana ana i hana'i: ");
INSERT INTO haw1868_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Hookuu aku la ia i kekahi koraka, nana i lele aku a hoi mai ma kela wahi a ma keia wahi, a maloo iho ka wai ma ka honua. ");
INSERT INTO haw1868_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Hookuu aku la hoi oia i ka manu nunu e ike i ka emi ana o ka wai mai ka aina aku; ");
INSERT INTO haw1868_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Aka, aole i loaa i ua manu nunu la he wahi e maha'i o kona wawae, a hoi hou mai la ia io na la iloko o ka halelana, no ka mea, ua uhi ka wai maluna o ka honua a pau; alaila, o aku la kona lima, lalau aku la oia ia ia, a huki mai la ia ia io na la iloko o ka halelana. ");
INSERT INTO haw1868_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Noho iho la ia i na la hou aka i ehiku; a hookuu hou aku la i ka manu nunu iwaho o ka halelana; ");
INSERT INTO haw1868_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","A ahiahi iho la, hoi mai la ka manu nunu io na la, aia hoi, he lau oliva hou ma kona waha. Pela o Noa i ike ai, ua emi iho ka wai mai luna aka o ka honua. ");
INSERT INTO haw1868_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Noho iho la ia i na la hou aku i ehiku; a hookuu aku la i ka manu nunu; aole no ia i hoi hou mai io na la ma ia hope mai. ");
INSERT INTO haw1868_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","I ka makahiki eono haneri a me kumamakahi, i ka malama hookahi, a i ka la mua o ua malama la, maloo iho la ka wai mai ka honua aku; a wehe ae la o Noa i ke pani maluna o ka halelana, a nana ae la, aia hoi, ua maloo ka aina. ");
INSERT INTO haw1868_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","A i ka lua o ka malama, i ka la iwakaluakumamahiku o ua malama la, ua maloo iho ka honua. ");
INSERT INTO haw1868_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Olelo mai la ke Akua ia Noa, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","E hele aku oe iwaho o ka halelana, o oe, me kau wahine, me au mau keikikane, a me na wahine a kau mau keikikane me oe. ");
INSERT INTO haw1868_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","E lawe pu mai me oe i na mea ola a pau ia oe, o na mea io, o na manu, na holoholona, a me na mea kolo a pau e kolo ana maluna o ka honua; i hanau nui ai lakou ma ka honua, i hua mai, a mahuahua maluna o ka honua. ");
INSERT INTO haw1868_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Hele aku la o Noa me kana mau keikikane, a me kana wahine, a me na wahine a kana mau keikikane me ia: ");
INSERT INTO haw1868_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","O na holoholona hoi a pau, o na mea kolo a pau, me na manu a pau, a me na mea a pau e kolo ana maluna o ka honua, ma ko lakou mau ano iho, hele aku la lakou iwaho o ka halelana. ");
INSERT INTO haw1868_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Hana iho la o Noa i kuahu no Iehova, lalau aku la ia i kekahi o na holoholona maemae a pau, a o na manu maemae a pau, a kaumaha aku la i na mohaikuni maluna o ke kuahu. ");
INSERT INTO haw1868_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Honi mai la o Iehova i ke ala oluolu: i iho la o Iehova iloko o kona naau, Aole au e hoino hou i ka aina no kanaka, no ka mea, ua hewa no ka manao ana o ko ke kanaka naau mai kona wa opiopio; aole hoi au e luku hou aku i na mea ola a pau, me au i hana iho nei. ");
INSERT INTO haw1868_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","E mau auanei ka wa e kanu ai a e ohi ai; ke ana a me ka wela, ke kau a me ka hooilo, ka la a me ka po; a pau na la o ka honua. ");
INSERT INTO haw1868_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","HOOPOMAIKAI mai la ke Akua ia Noa, a me kana mau keikikane, i mai la ia lakou, E hoohua mai oukou, e mahuahua, a e hoopiha i ka honua. ");
INSERT INTO haw1868_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","E kau mai auanei ka makau ia oukou a me ka weliweli maluna o na holoholona a pau o ka honua, maluna hoi o na manu a pau e ka lewa, a maluna hoi o na mea a pau e hele ana ma ka honua, a maluna no hoi o na ia a pau o ke kai; ua haawiia'ku lakou iloko o na lima o oukou. ");
INSERT INTO haw1868_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","O na mea hele a pau e ola ana, na oukou ia e ai; me ka'u i haawi aku ai i na launahele opiopio na oukou, pela ka'u e haawi aku nei i na mea a pau. ");
INSERT INTO haw1868_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Aka, mai ai oukou i ka io me kona ola, oia kona koko. ");
INSERT INTO haw1868_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","He oiaio, e hoopai auanei au i ke koko o ko oukou ola; ma ka lima o na holoholona a pau ka'u e hoopai aku ai; a ma ka lima hoi o na kanaka; ma ka lima hoi o ka hoahanau o kela kanaka keia kanaka ka'u e hoopai aku ai i ke ola o kanaka. ");
INSERT INTO haw1868_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","O ka mea nana e hookahe i ke koko o kanaka, e hookaheia no kona koko e kanaka: no ka mea, ma ke ano o ke Akua oia i hana'i i kanaka. ");
INSERT INTO haw1868_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","A oukou, e hoohua mai oukou, a e mahuahua; e hanau nui ma ka honua, a e hoolaha malaila. ");
INSERT INTO haw1868_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Olelo mai la ke Akua ia Noa a i kana mau keiki me ia, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","Owau la e, ke hoopaa nei au i ka u berita me oukou a me ka oukou poe mamo mahope o oukou: ");
INSERT INTO haw1868_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","A me na mea ola a pau me oukou, o na manu, o na holoholona laka a me na holoholona hihiu o ka honua me oukou: mai ka poe a pau i hele mai iwaho e ka halelana, a i na holoholona a pau o ka honua. ");
INSERT INTO haw1868_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","E hoopaa no wau i ka'u berita me oukou: aole hoi e luku hou ia ua mea ola a pau i na wai o ke kaiakahinalii: aole hoi he kaiakahinalii e hiki hou mai ana e pau ai ka honua. ");
INSERT INTO haw1868_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","I mai la ke Akua. Eia ka hoailona o ka berita a'u e hana nei mawaena o'u a o oukou, me na mea ola a pau me oukou, no ua hanauna a pau. ");
INSERT INTO haw1868_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Ke kau nei au i kuu anuenue ma ke ae, i hoailona ia uo ka berita mawaena o'u a o ka honua. ");
INSERT INTO haw1868_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","A hoouhi aku ai au i ke ao maluna o ka honua, e ikea auanei ke anuenue ma ke ae.: ");
INSERT INTO haw1868_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","A e hoomanao iho uo au i ka'u berita mawaena o'u a o oukou, me na mea io e ola ana a pau: aole loa e lilo hou ana ka wai i kaiakahinalii e luku ai i na mea io a pau. ");
INSERT INTO haw1868_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","A e kau mai auanei ke anuenue ma ke ao: a e nana aku au ia i hoomanao iho ai au i ka berita mau loa mawaena o ke Akua a o na mea ola a pau o na mea io a pau maluna o ka honua. ");
INSERT INTO haw1868_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Olelo mai la ke Akua ia Noa Ola ka hoailona o ka berita a'u i hoopaa iho ai mawaena o'u a e na mea io a pau maluna o ka houna. ");
INSERT INTO haw1868_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","O na keikikane a Noa. ua mea i puka mai iwaho o ka halelana. oia o Sema, o Hama, a o lapeta: a o Hama ka makuakaue no Kananna. ");
INSERT INTO haw1868_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","O lakou ua keikikane ekolu a Noa. a na lakou i hoolalaia ku na kanaka ma ka honua a pau. ");
INSERT INTO haw1868_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Hoomaka iho la o Noa e mahiai, a kanu iho la ia i ka malawaina: ");
INSERT INTO haw1868_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Inu iho la ia i ka waina, a ona: a ua uhi ole ia oia i ke kapa maloko o kona halelewna. ");
INSERT INTO haw1868_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ike aku la o Hama ka makuakane o Kauaana i kahi hilahila o kona makuakane. a hai mai la i kona mau hoahanau elua mawaho. ");
INSERT INTO haw1868_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Lalau aku la o Sema laua o Iapeta i ka aahu. a kau iho la maluna o ko laua mau poohiwi. a hele hope aku la laua. a uhi iho la i kahi hilahila o ko laua makuakane: ua huli hope ko laua mau maka. a ike ole aku laua i kahi hilahila o ko laua makuakane. ");
INSERT INTO haw1868_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Ala ae la o Noa i ka pau ana o kona waina. a ike iho la ia i ka mea a kana keiki muli iho i hana aku ai ia ia. ");
INSERT INTO haw1868_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Olelo mai la oia. E poino ne o Kanaaua: he kauwa ia ua na kauwa a kona poe hoahanau. ");
INSERT INTO haw1868_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Olelo mai la hoi oia. E hoomaikaiia o Iehova. ke Akua o Sema: a o Kauaana kana kauwa. ");
INSERT INTO haw1868_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","E hoomahuahua auanei ke Akua ia Iapeta, a e noho no auanei ia ma ua halelewa o Sema: a o Kauaana kana kauwa. ");
INSERT INTO haw1868_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","A e ko Noa ola ana mahope o ke kaiakahinalii, akolu ia haneri makahiki a me kanalima. ");
INSERT INTO haw1868_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","O ua la a pau o Noa. aiwa ia haneri makahiki a me kanalima: a make iho la ia. ");
INSERT INTO haw1868_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","EIA ka mooolelo no na keikikane a Noa o Sema, o Hama, a o Iapeta: ua hanau na lakou na keikikaua mahope o ke kaiakahinalii. ");
INSERT INTO haw1868_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","O na keikikane a lapeta: o Gomera, o Magoga, o Madai, o lavaua. o Tuhala. o Meseka, a o Tirasa. ");
INSERT INTO haw1868_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","O na keikikane a Gomera: o Asekenaza, o Kipata, a o Elia. ");
INSERT INTO haw1868_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","O na keikikane a lavana o Elia. o Taresisa. o Kitima, a o Dodanima. ");
INSERT INTO haw1868_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Ua puunaneia na aina kahakai o na lahuikanaka e lakeu nei ma ke lakou mau aina, e kela mea a o keia mea e like me kana olelo, mamuli o ka lakou mau ohnau, ma na lahuikanaka o lakou. ");
INSERT INTO haw1868_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","O na keiki a Hama: o Kusa. o Migeraima, e Puta, a o Kanaaua. ");
INSERT INTO haw1868_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","O na keikikane a Kusa: o Seba e Havila. o Sabeta. e Raama, a o Sabeteka: a o na keikikane a Raama: o Seba, a o Dedana. ");
INSERT INTO haw1868_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Na Kusa o Nimeroda: hoomaka iho la ia e hoolanakila ma ka honua nei. ");
INSERT INTO haw1868_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","He kanaka koa ia i ka hahai holoholona imua o Iehova: nolaila i oleloia'i, E like me Nimeroda ka mea koa loa, ka hahai holoholona imua o Iehova. ");
INSERT INTO haw1868_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","O ka hoomaka ana o kona aupuni, oia o Babela, o Araka, o Akada, a o Kalene, ma ka aina o Sinara. ");
INSERT INTO haw1868_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Ma ia aina aku i hele aku ai o Asura, a kukulu iho la ia Nineva, a me ke kulanakauhale o Rehobota, a me Kala, ");
INSERT INTO haw1868_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","A me Resena mawaena o Nineva a o Kala: he kulanakauhale nui no ia. ");
INSERT INTO haw1868_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Na Mizeraima ka Luda, me ka Anama, me ka Lehaba, me ka Naputuha. ");
INSERT INTO haw1868_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Me ka Paterima, me ka Kaseluhima, (na lakou mai ka Pilisetia,) a me ka Kapetora. ");
INSERT INTO haw1868_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Na Kanaana mai o Sidona, kana hiapo, a o Heta, ");
INSERT INTO haw1868_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","A o ka Iebusa, a o ka Amora, a o ka Giragasa, ");
INSERT INTO haw1868_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","A o ka Hiva, a o ka Areka, a o ka Sinite, ");
INSERT INTO haw1868_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","A o ka Aravada, a o Zemara, a o ka Hamata: a mahope iho ua hoolahaia'ku na ohana a ka poe Kanaana. ");
INSERT INTO haw1868_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","A o ka mokuna aina o ka Kanaana, mai Sidona ia, i kona hele ana mai i Gerara, a hiki i Gaza; i kou hele ana aku i Sodoma, me Gomora, a me Adema, a me Geboima, a hiki i Lasa. ");
INSERT INTO haw1868_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Oia na keikikane a Hama, mamuli o ka lakou mau ohana, mamuli hoi o ka lakou mau olelo, ma na aina o lakou, a ma na lahuikanaka o lakou. ");
INSERT INTO haw1868_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Na Sema hoi, na ka makuakane o ka poe keiki a pau a Ebera, na ke kaikaina a Iapeta ka hoahanau mua, ua hanau no hoi na keiki nana. ");
INSERT INTO haw1868_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","O na keiki a Sema; o Elama, o Asura, o Arepakada, o Luda, a o Arama. ");
INSERT INTO haw1868_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","O na keikikane a Arama; o Uza, o Kula, a o Getera, a o Masa. ");
INSERT INTO haw1868_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Na Arepakada o Sala, na Sala hoi o Ebera. ");
INSERT INTO haw1868_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Ua hanau na Ebera na keikikane elua: o Pelega ka inoa o kekahi; no ka mea, ua maheleia ka honua i kona mau la; a o Ioketana ka inoa o kona kaikaina. ");
INSERT INTO haw1868_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Na Ioketana o Alemodada, o Selepa, a Hazamaveta, o Iera, ");
INSERT INTO haw1868_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","O Hadorama, o Uzala, o Dikela, ");
INSERT INTO haw1868_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","O Obala, o Abimaela, o Seba, ");
INSERT INTO haw1868_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","O Opira, o Havila, a o Iobaba: o lakou nei a pau na keikikane a Ioketana. ");
INSERT INTO haw1868_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","A o ko lakou wahi noho ai, mai Mesa aku no ia, i kou hele ana a hiki i Separa, i kekahi mauna o ka hikina. ");
INSERT INTO haw1868_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Oia na keikikane a Sema, mamuli o ka lakou mau ohana, mamuli hoi o ka lakou mau olelo, ma ko lakou mau aina, a me ko lakou mau lahuikanaka. ");
INSERT INTO haw1868_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Oia na ohana a na keikikane a Noa, e like me ko lakou mau hanauna, ma ko lakou mau lahuikanaka; ma o lakou nei ua maheleia na lahuikanaka ma ka honua mahope mai o ke kaiakahinalii. ");
INSERT INTO haw1868_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","HOOKAHI no lehelehe, hookahi hoi olelo a ko ka honua a pau. ");
INSERT INTO haw1868_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","A i ko lakou hele ana mai ka hikina mai, loaa ia lakou kahi papu ma ka aina o Sinara; a noho iho la lakou ilaila. ");
INSERT INTO haw1868_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Olelo ae la kekahi kanaka i kona hoa, Ina kakou, e hana kakou i na pohaku ula, e kahu a moa loa. O ko lakou pohaku, he pohaku ula, a he bitumena ko lakou puna. ");
INSERT INTO haw1868_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Olelo ae la lakou, Ina kakou, e hana kakou i kulanakauhale no kakou, a me ka halepakui e kiekie ae kona welau i ka lani; a e hookaulana i ko kakou inoa, o hoopuehuia'ku kakou maluna o ka honua a pau. ");
INSERT INTO haw1868_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Iho mai la o Iehova ilalo e nana i ke kulanakauhale a me ka halepakui a na keiki a kanaka i hana'i. ");
INSERT INTO haw1868_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","I iho la o Iehova, Aia hoi, hookahi no ka poe kanaka, hookahi hoi ko lakou lehelehe; eia ka lakou e hoomaka nei e hana: a mahope aku, aohe mea keakea ia lakou ke hana i na mea a pau a lakou e manao ai. ");
INSERT INTO haw1868_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Ina kakou, e iho iho kakou, a malaila kakou hookahuli ai i ka lakou olelo, i hoomaopopo ole ai lakou i ka olelo a kekahi. ");
INSERT INTO haw1868_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Pela o Iehova i hoopuehu aku ai ia lakou maluna o ka honua a pau: a oki iho la ka lakou hana ana i ua kulanakauhale la. ");
INSERT INTO haw1868_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","No ia mea, ua kapaia ka inoa o ia wahi, o Babela, no ka mea, ilaila o Iehova i hookahuli ai i ka olelo a ko ka honua a pau: a mai ia wahi aku i hoopuehu aku ai o Iehova ia lakou maluna o ka honua a pau. ");
INSERT INTO haw1868_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Eia ka mooolelo na Sema: hookani haneri makahiki o Sema, a hanau mai o Arepakada nana, elua makahiki mahope mai o ke kaiakahinalii. ");
INSERT INTO haw1868_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Mahope mai o ka hanau ana o Arepakada, alima haneri no makahiki o ko Sema ola ana, a nana mai na keikikane a me na kaikamahine. ");
INSERT INTO haw1868_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","He kanakolu na makahiki a me kumamalima o ko Arepakada ola ana, a hanau mai o Sala nana: ");
INSERT INTO haw1868_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Mahope mai o ka hanau ana o Sala, aha haneri na makahiki a me kumamakolu o ko Arepakada ola ana, a nana mai na keikikane a me na kaikamahine. ");
INSERT INTO haw1868_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","He kanakolu na makahiki o ko Sala ola ana, a hanau mai o Ebera nana: ");
INSERT INTO haw1868_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Mahope mai o ka hanau ana o Ebera, aha haneri na makahiki me kumamakolu o ko Sala ola ana, a nana mai na keikikane a me na kaikamahine. ");
INSERT INTO haw1868_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","He kanakolu na makahiki a me kumamaha o ko Ebera ola ana, a hanau mai o Pelega nana: ");
INSERT INTO haw1868_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Mahope mai o ka hanau ana o Pelega, aha haneri na makahiki a me kanakolu o ko Ebera ola ana, a nana mai na keikikane a me na kaikamahine. ");
INSERT INTO haw1868_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","He kanakolu na makahiki o ko Pelega ola ana, a hanau mai o Reu nana: ");
INSERT INTO haw1868_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Mahope mai o ko Reu hanau ana, alua haneri na makahiki a me kumamaiwa o ko Pelega ola ana, a nana mai na keikikane a me na kaikamahine. ");
INSERT INTO haw1868_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","He kanakolu na makahiki a me kumamalua o ko Reu ola ana, a hanau mai o Seruga nana: ");
INSERT INTO haw1868_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Elua haneri na makahiki a me kumamahiku o ko Reu ola ana mahope mai o ka hanau ana o Seruga, a nana mai na keikikane a me na kaikamahine. ");
INSERT INTO haw1868_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","He kanakolu na makahiki o ko Seruga ola ana, a hanau mai o Nahora nana: ");
INSERT INTO haw1868_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Mahope mai o ka hanau ana o Nahora, elua haneri na makahiki o ko Seruga ola ana, a nana mai na keikikane a me na kaikamahine. ");
INSERT INTO haw1868_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","He iwakalua na makahiki a me kumamaiwa o ko Nahora ola ana, a hanau mai o Tera nana: ");
INSERT INTO haw1868_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Mahope mai o ka hanau ana o Tera, he haneri na makahiki a me ka umikumamaiwa o ko Nahora ola ana, a nana mai na keikikane a me na kaikamahine. ");
INSERT INTO haw1868_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","He kanahiku na makahiki o ko Tera ola ana, a hanau mai o Aberama, o Nahora, a o Harana. ");
INSERT INTO haw1868_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Eia ka mooolelo no Tera; na Tera o Aberama, o Nahora, a o Harana; na Harana o Lota. ");
INSERT INTO haw1868_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Make iho la o Harana mamua o kona makuakane o Tera, ma kona aina i hanau ai, ma Ura no ko Kaledea. ");
INSERT INTO haw1868_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Lawe ae la o Aberama laua o Nahora i mau wahine na laua: o Sarai ka inoa o ka wahine a Aberama, a o Mileka ka inoa o ka wahine a Nahora; oia ke kaikamahine a Harana, a ka makuakane o Mileka, a o ka makuakane hoi o Iseka. ");
INSERT INTO haw1868_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","A he pa o Sarai; aohe ana keiki. ");
INSERT INTO haw1868_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Lawe ae la o Tera i kana keiki ia Aberama, a me kana moopuna ia Lota, ke keiki a Harana, a me Sarai kana hunonawahine, o ka wahine a kana keiki a Aberama; a haele pu mai la lakou mai Ura mai no ko Kaledea, i ka hele ana ma ka aina o Kanaana: hiki mai la lakou i Harana, a noho iho la ilaila. ");
INSERT INTO haw1868_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","O na la o Tera, elua ia haneri makahiki a me kumamalima: a make iho la o Tera ma Harana. ");
INSERT INTO haw1868_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","I OLELO mai o Iehova ia Aberama, E hele aku oe mai kou aina aku, a mai kou poe hoahanau aku, a mai ka hale o kou makuakane aku, a hiki i ka aina a'u e kuhikuhi aku ai ia oe. ");
INSERT INTO haw1868_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","A e hoolilo au ia oe i lahuikanaka nui, e hoomaikai aku hoi au ia oe, e hookaulana hoi au i kou inoa, a e lilo oe i mea e pomaikai ai. ");
INSERT INTO haw1868_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","E hoopomaikai aku hoi au i ka poe hoomaikai ia oe, a e hoino aku au i ka mea hoino ia oe, a ia oe e pomaikai ai na ohana a pau o ka honua. ");
INSERT INTO haw1868_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Hele aku la o Aberama e like me ka Iehova i olelo mai ai ia ia; a hele pu o Lota me ia. He kanahiku kumamalima na makahiki o Aberama, i kona wa i hele mai ai mai Harana mai. ");
INSERT INTO haw1868_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Lawe ae la o Aberama i kana wahine ia Sarai, a me Lota ke keiki a kona kaikuaana, a me ka waiwai a pau a lakou i hoiliili ai, a me na ohua a pau i loaa ia lakou ma Harana; a puka mai la lakou e hele mai i ka aina o Kanaana; a hiki mai la lakou i ka aina o Kanaana. ");
INSERT INTO haw1868_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Kaahele ae la o Aberama i ka aina, a hiki aku la i kahi o Sikema, i ka laau oka o More. E noho ana no na mamo a Kanaana ma ia aina ia manawa. ");
INSERT INTO haw1868_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Ikea ae la o Iehova e Aberama, i mai la ia, E haawi aku no wau i keia aina no kau poe mamo: malaila oia i hana'i i kuahu no Iehova, ka mea i ikea e ia. ");
INSERT INTO haw1868_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Hele aku la ia mai ia wahi aku a ka puu ma ka hikina o Betela, a kukulu iho la i kona halelewa, o Betela ma ke komohana, a o Hai ma ka hikina: malaila oia i hana'i i kuahu no Iehova, a hea aku la ia i ka inoa o Iehova. ");
INSERT INTO haw1868_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Hele hou aku la o Aberama e neenee ana i ke kukuluhema. ");
INSERT INTO haw1868_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","He wi ma ia aina; a hele aku la o Aberama ilalo i Aigupita e noho malihini malaila, no ka mea, ua nui loa ka wi ma ka aina. ");
INSERT INTO haw1868_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","A kokoke aku la ia e komo i Aigupita, i aku la ia i kana wahine ia Sarai, Eia hoi ke ike nei au he wahine maikai oe ke nanaia'ku: ");
INSERT INTO haw1868_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Nolaila, a ike mai ko Aigupita ia oe, e olelo auanei lakou, Eia kana wahine; a e pepehi mai lakou ia'u, a e hoola ae lakou ia oe. ");
INSERT INTO haw1868_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Ke nonoi aku nei au ia oe, e i aku oe, he kaikuwahine oe no'u, i pomaikai ai au ia oe, a e malamaia kuu ola nou. ");
INSERT INTO haw1868_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","A hiki aku la o Aberama i Aigupita, ike mai la ko Aigupita i ka wahine he maikai loa. ");
INSERT INTO haw1868_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","A ike mai la na luna a Parao ia ia, hoomaikai lakou ia ia imua o Parao, a ua laweia aku la ua wahine la ma ka hale o Parao. ");
INSERT INTO haw1868_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Lokomaikai mai la oia ia Aberama no Sarai: a ia ia na hipa, na bipi, na hoki, na kauwakane, na kauwawahine, na hokiwahine, a me na kamelo. ");
INSERT INTO haw1868_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Hooeha mai la o Iehova ia Parao a me kona poe ohua i na mai eha loa, no Sarai ka wahine a Aberama. ");
INSERT INTO haw1868_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Kahea mai la o Parao ia Aberama, i mai la, Heaha keia mea au i hana mai ai ia'u? No ke aha la i hai ole mai oe ia'u o kau wahine ia? ");
INSERT INTO haw1868_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","No ke aha la oe i olelo mai ai, O ko'u kaikuwahine ia, i mea e lawe ai au ia ia i wahine na'u? Eia hoi kau wahine, e lawe oe ia ia, a e hele aku. ");
INSERT INTO haw1868_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Kauoha aku la o Parao i kona poe kanaka nona, a hoihoi mai la lakou ia ia, me kana wahine, a me kana mau mea a pau. ");
INSERT INTO haw1868_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","PII hou mai la o Aberama mai Aigupita mai, oia me kana wahine, a me kana mau mea a pau, a me ia no o Lota, i kau wahi o ke kukuluhema. ");
INSERT INTO haw1868_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Ua waiwai nui loa o Aberama i na holoholona, i ke kala a me ke gula. ");
INSERT INTO haw1868_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Hele ae la ia i kona hele ana mai ke kukuluhema mai a Betela, kahi i ku ai o kona halelewa mamua, mawaena o Betela a me Hai; ");
INSERT INTO haw1868_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Kahi o ke kuahu ana i haua'i mamua: ilaila o Aberama i kahea aku ai i ka inoa o Iehova. ");
INSERT INTO haw1868_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","A o Lota hoi, ka mea i hele pu me Aberama, he hipa no kana me na bipi a me na halelewa. ");
INSERT INTO haw1868_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Aole i pono ka aina no laua, i noho pu ai laua, no ka nui o ko laua waiwai, aole i hiki ia laua ke noho pu. ");
INSERT INTO haw1868_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Hakaka ae la ka poe kahubipi a Aberama me ka poe kahubipi a Lota: e noho ana no ka Kanaana a me ka Perezi ma ia aina ia manawa. ");
INSERT INTO haw1868_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","I aku la o Aberama ia Lota, Ea, aole make hakaka kaua, kekahi i kekahi, aole hoi ka'u poe kahubipi me kau poe kahubipi; no ka mea, he mau hoahanau kaua. ");
INSERT INTO haw1868_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Aole anei ma kou alo ka aina a pau? ke noi aku nei au ia oe, e hookaawale kaua: ina oe ma ka lima hema, alaila e hele au ma ka lima akau; a ma ka lima akau oe, alaila e hele au ma ka lima hema. ");
INSERT INTO haw1868_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Alawa ae la ko Lota mau maka, ike aku la i na wahi papu o Ioredane, he nui ka wai ma ia wahi a pau i kou hele ana mai i Zoara, mamua o ko Iehova luku ana ia Sodoma a me Gomora, e like me ka mahinaai o Iehova, a e like me ka aina i Aigupita. ");
INSERT INTO haw1868_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Alaila, wae iho la o Lota i ka papu a pau o Ioredane: a hele aku la o Lota ma ka hikina, a hookaawale ae la laua i ke kekahi me kekahi. ");
INSERT INTO haw1868_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Noho iho la o Aberama ma ka aina i Kanaana, a noho aku la o Lota ma na kulanakauhale o ua papu la, a kukulu iho la i kona halelewa ma Sodoma. ");
INSERT INTO haw1868_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","A o na kanaka o Sodoma, he poe hewa lakou, he lawehala loa imua o Iehova. ");
INSERT INTO haw1868_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Olelo mai la o Iehova ia Aberama mahope mai o ko Lota hookaawale ana ae mai ona aku la, E alawa ae oe i kou mau maka, a e nana aku mai kou wahi e noho nei, i ke kukuluakau a i ke kukuluhema, a i ka hikina hoi a i ke komohana: ");
INSERT INTO haw1868_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","No ka mea, o ka aina a pau au e ike nei, na'u ia e haawi aku nou, a no kau poe mamo mahope mau loa aku. ");
INSERT INTO haw1868_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","E hoomahuahua aku no wau i kau poe mamo e like me ka lepo o ka honua: ina e hiki i ke kanaka ke helu i na huna lepo o ka honua, alaila e heluia kau poe mamo. ");
INSERT INTO haw1868_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","E ku ae; e kaahele i ka aina ma kona loa a ma kona laula; no ka mea, na'u no ia e haawi aku nou. ");
INSERT INTO haw1868_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Alaila lawe ae la o Aberama i kona halelewa, hele aku la ia a noho iho la ma na laau oka no Mamere, aia no ma Heberona, a hana iho la ia ilaila i kuahu no Iehova. ");
INSERT INTO haw1868_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","I KA manawa ia Amerapela ke alii o Sinara, o Arioka ke alii o Elasara, o Kedorelaomera ke alii o Elama, a o Tidala ke alii o Goima; ");
INSERT INTO haw1868_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Kaua mai la lakou me Bera ke alii o Sodoma, me Biresa ke alii o Gomora, me Sinaba ke alii o Adema, me Semebara ke alii o Zeboima, a me ke alii o Bela, oia hoi o Zoara. ");
INSERT INTO haw1868_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","I hoakoakoaia keia poe a pau ma ke awawa o Sidima, kahi ia o ka moana paakai. ");
INSERT INTO haw1868_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Hookauwa aku la lakou na Kedorelaomera i na makahiki he umikumamalua; a i ka umikumamakolu o ka makahiki, kipi ae la lakou. ");
INSERT INTO haw1868_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","A i ka makahiki umikumamaha, hele mai la o Kedorelaomera, a me ia pu ua mau alii la, a hahau mai la i ka Repaima ma Aseterota Kanaima, me ka Zuzima ma Hama, a me ka Emima ma Sehave ma Kiriataima. ");
INSERT INTO haw1868_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","A me ka Hora ma ko lakou mauna Seira, a hiki Elepazana ma ka waoakua. ");
INSERT INTO haw1868_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","A hoi mai la lakou, a hiki mai la i Enemisepata, oia o Kadesa, a hahau aku ia i ko ka aina a pau o ka Amaleki, a me ka Amori i noho la ma Hazezona-tamara. ");
INSERT INTO haw1868_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Hele aku la ke alii o Sodoma me ke alii o Gomora, me ke alii o Adema, a me ke alii o Zeboima, a me ke alii o Bela, oia hoi o Zoara; a kaua aku la lakou me kela poe ma ke awawa o Sidima; ");
INSERT INTO haw1868_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Me Kedorelaomera ke alii o Elama, a me Tidala ke alii o Goima, a me Amerapela ke alii o Sinara, a me Arioka ke alii o Elasara; o na'lii eha me na'lii elima. ");
INSERT INTO haw1868_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","He nui na lua bitumena ma ke awawa o Sidima; hee aku la na alii o Sodoma a me Gomora, a haule iho la ilaila; a holo aku la ka poe i koe ma ka mauna. ");
INSERT INTO haw1868_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Lawe pio aku la lakou i ka waiwai a pau o Sodoma a o Gomora, a me ka lakou ai a pau, a hele aku la. ");
INSERT INTO haw1868_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Lawe aku la hoi lakou ia Lota, i noho ai ma Sodoma, o ke keiki a ko Aberama kaikuaana, a me kana waiwai, a hoi aku la. ");
INSERT INTO haw1868_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Hele mai la kekahi o ka poe i pakele, a hai mai la ia Aberama ka Hebera; no ka mea, i noho ai oia ma na laau oka no Mamere ka Amori, ka hoahanau o Esekola, a o Anera: a ua hoolauna pu lakou nei me Aberama. ");
INSERT INTO haw1868_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Lohe ae la o Aberama, ua lawe pio ia kona hoahanau, alakai aku la ia i kona poe kanaka i hoomakaukauia ka poe i hanau ma kona hale iho, akolu haneri a me kumamawalu, a alualu aku la ia lakou a hiki i Dana. ");
INSERT INTO haw1868_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Mahele iho la oia i kona poe e ku e ia lakou, oia a me kana poe kauwa i ka po, poipo aku la ia lakou, a alualu aku la ia lakou a hiki i Hoba, aia ma ka lima hema o Damaseko. ");
INSERT INTO haw1868_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Hoihoi mai la ia i ka waiwai a pau, a lawe mai la hoi oia i kona hoahanau ia Lota, a me kona waiwai, me na wahine hoi, a me na kanaka. ");
INSERT INTO haw1868_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Hele aku ke alii o Sodoma iwaho e halawai me Aberama, mahope o kona hoi hou ana mai mai ka luku ana ia Kedorelaomera a me na alii me ia, ma ke awawa o Save, oia ke awawa o ke alii. ");
INSERT INTO haw1868_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","A o Melekizedeka ke alii o Salema, lawe mai la ia i ka berena a me ka waina: oia ke kahuna o ke Akua kiekie loa. ");
INSERT INTO haw1868_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Hoomaikai mai la oia ia ia, i mai la, E pomaikai no o Aberama i ke Akua kiekie loa, nona ka lani a me ka honua. ");
INSERT INTO haw1868_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","E hoomaikaiia hoi ke Akua kiekie loa, nana i hoolilo mai kou poe enemi iloko o kou lima. A haawi aku la ia nana i ka hapaumi o na mea a pau. ");
INSERT INTO haw1868_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","I mai la ke alii o Sodoma ia Aberama, o ke kanaka ko'u, a e lawe oe i ka waiwai nou. ");
INSERT INTO haw1868_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","I aku la o Aberama i ke alii o Sodoma, Ua hapai aku no au i ko'u lima ia Iehova, i ke Akua kiekie loa, i ka mea nona ka lani a me ka honua, ");
INSERT INTO haw1868_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Aole au e lawe no'u i kekahi maawe, aole hoi kekahi mea iki o kau, o olelo ae oe, Ua waiwai o Aberama ia'u: ");
INSERT INTO haw1868_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","O ka mea wale no a ka poe kanaka opiopio i ai ai, a me ka puu waiwai pio a ka poe kanaka i hele pu ai me an, o Anera, o Esekola, a o Mamere; e lawe lakou i ko lakou puu. ");
INSERT INTO haw1868_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","MAHOPE mai oia mau mea, hiki mai la ka olelo a Iehova ia Aberama ma ka hihio, i mai la, Mai makau oe, e Aberama, owau no kou palekaua a me kau uku nui loa. ");
INSERT INTO haw1868_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","I aku la o Aberama, E ka Haku, e Iehova e, heaha kau mea e haawi mai ai ia'u, no ka mea, ke hele keiki ole nei au, a o ka puuku o kuu hale, oia o Eliezera no Damaseko. ");
INSERT INTO haw1868_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","I aku la o Aberama, Aia hoi, aole oe i haawi mai i keiki na'u; a o kekahi i hanau iloko o ko'u hale, oia kuu hooilina. ");
INSERT INTO haw1868_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Aia hoi, hiki mai la ka olelo a Iehova ia ia, i ka i ana mai, Aole keia o kou hooilina; aka, o ka mea e hele mai ana mailoko mai ou iho, o kou hooilina ia. ");
INSERT INTO haw1868_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Kai aku la oia ia ia mawaho, i mai la, E nana aku oe iluna i ka lani, e helu i na hoku, ina e hiki ia oe ke helu: i mai la kela ia ia, Pela auanei kau poe mamo. ");
INSERT INTO haw1868_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Manaoio aku la oia ia Iehova, a hooili mai la oia ia mea i pono nona. ");
INSERT INTO haw1868_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","I mai la kela ia ia, Owau no Iehova nana oe i lawe mai nei, mai Ura o ko Kaledea mai, e haawi aku nou i keia aina i wahi e noho ai. ");
INSERT INTO haw1868_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","I aku la ia, E ka Haku, e Iehova e, pehea la au e ike ai, e ili mai ana keia aina no'u? ");
INSERT INTO haw1868_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","I mai la kela ia ia, E lalau oe na'u i bipiwahine akolu makahiki ona, i kaowahine akolu makahiki ona, i hipakane akolu ona makahiki, i manu kuhukuku, a me ka nunu opiopio. ");
INSERT INTO haw1868_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Lawe mai la oia ia mau mea a pau io na la, a mahele ae la ia lakou mawaena, a waiho iho la i kela apana i keia apana e ku pono aku i kona hoa: aka, aole ia i mahele i na manu. ");
INSERT INTO haw1868_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","A lele mai la na manu maluna iho o na mohai, hoopuehu aku la o Aberama ia lakou. ");
INSERT INTO haw1868_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","A i ka napoo ana o ka la, ua pauhia o Aberama i ka hiamoe nui; aia hoi, kau mai la ka, weliweli a me ka pouli nui maluna iho ona. ");
INSERT INTO haw1868_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Olelo mai la ia ia Aberama, E ike pono oe, e lilo ana kau poe mamo i malihini ma ka aina e aole no lakou, a e hookauwa aku na lakou; a e hoinoia mai lakou e kela poe i na haneri makahiki eha. ");
INSERT INTO haw1868_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","A o ua lahuikanaka la nana lakou e hooluhi mai, na'u lakou e hoohewa aku: a mahope iho, e puka mai lakou iwaho me ka waiwai nui. ");
INSERT INTO haw1868_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","E huiia'ku oe i ou mau makua me ka malu; a e kanuia oe i ka wa elemakule maikai. ");
INSERT INTO haw1868_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Aka, e hoi hou mai no lakou ia nei i ka ha o ka hanauna: no ka mea, aole i lawa ka hewa o ka Amori i nei manawa. ");
INSERT INTO haw1868_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","A napoo iho la ka la, a poeleele iho la, aia hoi, nee ae la ka umuahi e punohu ana a me ke kukui e a ana mawaena o ua mau apana la. ");
INSERT INTO haw1868_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Ia la no, hoopaa iho la oia i berita me Aberama, i ka i ana mai, Ua haawi aku no wau i keia aina no kau poe mamo, mai ka muliwai o Aigupita a hiki aku i ka muliwai nui, ka muliwai o Euperate: ");
INSERT INTO haw1868_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","I ka Kena, i ka Keniza, i ka Kademona, ");
INSERT INTO haw1868_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","I ka Heta, i ka Periza, me ka Repaima, ");
INSERT INTO haw1868_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","I ka Amora, i ka Kanaana, i ka Giregasa, a me ka Iebusa. ");
INSERT INTO haw1868_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","O SARAI ka wahine a Aberama, aole ia i hanau keiki nana: a ia ia kekahi kauwawahine no Aigupita, o Hagara kona inoa. ");
INSERT INTO haw1868_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","I mai la o Sarai ia Aberama, Aia hoi, ua pa wau ia Iehova; ke nonoi aku nei au ia oe, e komo ae oe iloko i ka'u kauwawahine, i loaa paha ia'u na keiki ma o na la. Hoolohe aku la o Aberama i ka leo o Sarai. ");
INSERT INTO haw1868_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Lalau aku la o Sarai o ka wahine a Aberama ia Hagara i kana kauwawahine no Aigupita, i ka umi o ka makahiki a Aberama i noho ai ma ka aina o Kanaana, a haawi mai la ia ia i wahine na kana kane na Aberama. ");
INSERT INTO haw1868_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Komo aku la ia iloko io Hagara la, a ko ae la ia: a ike iho la ia ua ko, ua hoowahawahaia kona hakuwahine imua o kona maka. ");
INSERT INTO haw1868_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","I mai la o Sarai ia Aberama, Iluna iho ou ko'u hoinoia: ua haawi aku au i ka'u kauwawahine iloko o kou poli; a ike iho la ia, na ko oia, hoowahawahaia no au e ia: e hooponopono mai o Iehova mawaena o kaua. ");
INSERT INTO haw1868_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","I aku la o Aberama ia Sarai, Aia hoi, iloko no o kou lima kau kauwawahine, e hana aku oe ia ia e like me kou makemake. A hoopilikia aku la o Sarai ia ia, mahuka aku la ia mai kona alo aku. ");
INSERT INTO haw1868_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","A loaa oia i ka anela o Iehova ma ka punawai iloko o ka waonahele, ma ka punawai o ke alanui e hele ai i Sura. ");
INSERT INTO haw1868_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","I mai la ia, E Hagara, e ke kauwawahine a Sarai, no hea mai oe? e hele ana hoi oe ihea? I aku la kela, Ke mahuka aku nei au mai ke alo o ko'u hakuwahine, mai o Sarai aku. ");
INSERT INTO haw1868_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Olelo mai la ka anela o Iehova ia ia, E hoi hou oe i kou hakuwahine, a e noho iho oe malalo o kona mau lima. ");
INSERT INTO haw1868_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","I mai la hoi ka anela o Iehova ia ia, E hoonui loa no wau i kau poe mamo, aole lakou e hiki ke heluia no ka lehulehu. ");
INSERT INTO haw1868_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","I mai la hoi ka anela o Iehova ia ia, Aia hoi, ua hapai oe, a e hanau mai no oe i keikikane, a e kapa oe i kona inoa o Isemaela; no ka mea, ua lohe no o Iehova i kou popilikia. ");
INSERT INTO haw1868_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","E lilo auanei ia i kanaka hihiu, e ku e aku no kona lima i na kanaka a pau, a e ku e mai no hoi ka lima o na kanaka a pau ia ia: a e noho auanei no ia ma ke alo o kona poe hoahanau a pau. ");
INSERT INTO haw1868_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Kapa aku la ia i ka inoa o Iehova nana i olelo mai ia ia, O oe e ke Akua ka mea i ike mai ia'u: no ka mea, i iho la ia, Ua imi aku no anei au i ka Mea ike mai ia'u? ");
INSERT INTO haw1868_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Nolaila, ua kapaia ua punawai la, o Beeralahairoi: aia no ia mawaena o Kadesa a o Bereda. ");
INSERT INTO haw1868_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Hanau mai la o Hagara i keikikane na Aberama: kapa aku la o Aberama i ka inoa o kana keiki a Hagara i hanau ai, o Isemaela. ");
INSERT INTO haw1868_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","He kanawalukumamaono na makahiki o Aberama, i ka wa a Hagara i hanau ai ia Isemaela na Aberama. ");
INSERT INTO haw1868_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","I KE kanaiwakumamaiwa o na makahiki o Aberama, ikea mai la o Iehova e Aberama, i mai la ia ia, Owau no ke Akua mana; e hele oe imua o ko'u alo, a e hemolele oe. ");
INSERT INTO haw1868_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","A e hoopaa auanei au i kau berita mawaena o'u a ou; a e hoomahuahua aku au ia oe a nui loa. ");
INSERT INTO haw1868_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Moe iho la o Aberama ilalo kona alo: a kamailio mai la ke Akua me ia, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","Owau no, ea, aia hoi me oe ka'u berita, a e lilo auanei oe i kupuna no na lahuikanaka he nui loa. ");
INSERT INTO haw1868_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Aole oe e hea hou ia, o Aberama, aka, o Aberahama kou inoa: no ka mea, ua hoolilo aku no au ia oe i kupuna no na lahuikanaka he nui loa. ");
INSERT INTO haw1868_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","A e hoolilo no wau ia oe i mea hoohua nui loa, e hoopuka auanei au i na lahuikanaka mailoko aku ou, a e puka mai no hoi na alii nui mailoko aku ou. ");
INSERT INTO haw1868_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","A e hoopaa no hoi au i ka'u berita mawaena o'u a ou, a me kau poe mamo mahope ou ma na hanauna o lakou, i berita mau loa, i Akua no au nou, a no kau poe mamo mahope ou. ");
INSERT INTO haw1868_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","A e haawi aku no au i ka aina au e noho malihini nei, i ka aina a pau o Kanaana, nou, a no kau poe mamo mahope ou, i wahi e noho mau ai: a owau hoi ko lakou Akua. ");
INSERT INTO haw1868_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Olelo mai la ke Akua ia Aberahama, Nolaila, e malama oe i ka'u berita, o oe a me kau poe mamo mahope ou, ma na hanauna o lakou. ");
INSERT INTO haw1868_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Eia ka'u berita e malama ai oukou mawaena o'u a o oukou, a me kau poe mamo mahope ou; E okipoepoeia na keikikane a pau o oukou. ");
INSERT INTO haw1868_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","E okipoepoe oukou i ka io o ko oukou omaka; o ka hoailona ia o ka berita mawaena o'u a o oukou. ");
INSERT INTO haw1868_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","I ka poawalu o kona ola ana, e okipoepoeia na keikikane a pau o na hanauna o oukou; o ka mea i hanau ma kou wahi, a me ka mea i kuaiia i ke kala na ke kanaka e mai, ka mea aole nau i hua mai. ");
INSERT INTO haw1868_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","O ka mea i hanau ma kou wahi, a me ka mea i kuaiia i kou kala, he pono no e okipoepoeia oia: a e pili auanei ka'u berita ma ko oukou io i berita mau loa. ");
INSERT INTO haw1868_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","A o ke keikikane okipoepoe ole ia, ke okipoepoe ole ia ka io o kona omaka, e hookiia'ku ia kanaka mai kona hanauna aku; ua haihai oia i ka'u berita. ");
INSERT INTO haw1868_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Olelo mai la ke Akua ia Aberahama, A o Sarai o kau wahine, aole oe e kahea hou aku i kona inoa, o Sarai, e kapaia oia, o Sara. ");
INSERT INTO haw1868_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","E hoopomaikai aku hoi au ia ia, a e haawi aku hoi au ia oe, i keikikane nana mai: oia, e hoopomaikai no au la ia, nana mai na lahuikanaka; a nana mai no hoi na alii o kanaka. ");
INSERT INTO haw1868_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Alaila, moe iho la o Aberahama ilalo kona maka, akaaka iho la, a i iho la iloko o kona naau, E hanauia anei ke keiki na ka mea nona na makahiki he haneri? E hanau mai no anei o Sara, nona na makahiki he kanaiwa? ");
INSERT INTO haw1868_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","I aku la o Aberahama i ke Akua, Ina no o Isemaela e ola imua ou! ");
INSERT INTO haw1868_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","I mai la ke Akua, He oiaio, na Sara e hanau ke keikikane nau, a e kapa aku oe i kona inoa o Isaaka: a e hoopaa auanei au i ka'u berita me ia, a me kana poe mamo mahope ona, i berita mau loa. ");
INSERT INTO haw1868_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","A o Isemaela, ua hoolohe hoi au ia oe nona: Aia hoi, na hoopomaikai no au ia ia, a e hoohua auanei au i na keiki nana, a e hoomahuahua no hoi au ia ia; e hanau nana na alii he umikumamalua, a e hoolilo hoi au ia ia i Iahuikanaka nui. ");
INSERT INTO haw1868_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Aka, e hoopaa auanei au i kuu berita ia Isaaka, i ka mea a Sara e hanau mai ai nau, i keia manawa o kela makahiki aku. ");
INSERT INTO haw1868_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","A oki iho la kana kamailio ana me ia, hoi aku la ke Akua iluna mai o Aberahama aku. ");
INSERT INTO haw1868_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Lalau aku la o Aberahama i kana keiki ia Isemaela, a me na mea a pau i hanau ma kona hale, a me na mea a pau i kuaiia i kana kala, i na kane a pau o ko Aberahama mau ohua; a okipoepoe iho la i ka io o ko lakou omaka ia la hookahi no, e like me, ka ke Akua i olelo mai ai ia ia. ");
INSERT INTO haw1868_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","He kanaiwa na makahiki a me kumamaiwa o ko Aberahama ola ana, ia ia i okipoepoeia'i ma ka io o kona omaka. ");
INSERT INTO haw1868_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","He umikumamakolu na makahiki o Isemaela, ia ia i okipoepoeia'i ma ka io o kona omaka. ");
INSERT INTO haw1868_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Ia la hookahi no, i okipoepoeia'i o Aberahama, a me kana keiki o Isemaela. ");
INSERT INTO haw1868_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Ua okipoepoe pu ia me ia na kanaka a pau o kona mau ohua, i hanau ma kona hale, a i kuaiia i kona kala na ke kanaka e mai. ");
INSERT INTO haw1868_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","I KEA ae la o Iehova e ia ma na laau oka o Mamere: a noho iho la ia ma ka puka o ka halelewa, i ka manawa i wela mai ai ka la. ");
INSERT INTO haw1868_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Alawa ae la kona mau maka iluna, ike ae la, aia hoi, ku mai la na kanaka ekolu imua ona: a i kona ike ana aku, holo aku la ia mai ka puka o ka halelewa aku e halawai me lakou, a kulou iho la ia ma ka honua. ");
INSERT INTO haw1868_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","I aku la ia, E kuu haku, ina i loaa ia'u ke alohaia imua o kou mau maka, ke noi aku nei au ia oe, mai hele wale aku oe mai kau kauwa aku. ");
INSERT INTO haw1868_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Ke noi aku nei au, i laweia mai kekahi wai iki e holoi i ko oukou mau wawae, a e hoomaha iho oukou malalo o ka laau. ");
INSERT INTO haw1868_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","E lawe mai no hoi au i wahi berena, a e hooluolu iho i ko oukou naau; a mahope iho oukou e hele aku ai; no ka mea, nolaila ko oukou hele ana mai i ko oukou kauwa, I mai la lakou. Me kau i olelo mai ai, pela oe e hana'i. ");
INSERT INTO haw1868_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Wikiwiki ae la o Aberahama i ka hele iloko o ka halelewa io Sara la, i aku la, E hoomakaukau koke oe i ekolu sato palaoa wali; e hookawili a e pulehu i papaberena. ");
INSERT INTO haw1868_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Holo aku la o Aberahama i ka ohana bipi, lalau aku la i ka bipikeiki opiopio momona, haawi aku la i kekahi keiki, a wikiwiki iho la ia e kalua. ");
INSERT INTO haw1868_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Lalau aku ia i wahi bata a me ka waiu, a me ka bipikeiki ana i kalua ai, a kau aku la imua o lakou: a ku aku la ia ma o lakou la malalo o ka laau; a ai iho la lakou. ");
INSERT INTO haw1868_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Ninau mai la lakou ia ia, Auhea kau wahine, o Sara? I aku la ia, aia no iloko o ka halelewa. ");
INSERT INTO haw1868_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Alaila, i mai la kela, Ho oiaio, e hoi hou mai ana au i keia manawa o kela makahiki, aia hoi, e loaa uanei ia Sara he keikikane. A lohe ae la o Sara ma ka puka o ka halelewa ma kona kua. ");
INSERT INTO haw1868_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","A o Aberahama laua o Sara, ua kahiko no laua, he nui ko laua mau la; a ua pau ia Sara ka mea a na wahine. ");
INSERT INTO haw1868_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Nolaila, akaaka iho la o Sara iloko iho ona, i iho la, E olioli no anei au mahope o kuu wa luwahine, a ua elemakule hoi kuu haku? ");
INSERT INTO haw1868_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Ninau mai la o Iehova ia Aberahama, No ko aha la i akaaka ai o Sara, i ka i ana, He oiaio anei, o hanau no wau i keiki i kuu wa luwahine? ");
INSERT INTO haw1868_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","E hakalia anei kekahi mea ia Iehova? I ka wa i oleloia'i e hoi hou mai ana au i ou la, i keia manawa o kela makahiki, a e loaa ia Sara he keikikane. ");
INSERT INTO haw1868_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Alaila hoole aku la o Sara, i aku la, Aole au i akaaka; no ka mea, makau iho la ia. I mai la kela, Aole, ua akaaka no oe. ");
INSERT INTO haw1868_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Ku ae la ua mau kanaka la, nana aku la ma Sodoma; a hele pu o Aberahama me lakou e hookuu aku ia lakou. ");
INSERT INTO haw1868_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","I ae la o Iehova, E huna anei au ia Aberahama i ka'u mea e hana nei? ");
INSERT INTO haw1868_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","No ka mea, e lilo io no auanei o Aberahama i lahuikanaka nui a ikaika hoi, a e pomaikai hoi na lahuikanaka a pau o ka honua ia ia. ");
INSERT INTO haw1868_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","No ka mea, ke ike nei au ia ia, e kauoha aku no ia i kana poe keiki a me kona mau ohua mahope ona, i malama mai ai lakou i ka aoao o Iehova, a e hana lakou ma ka pono a me ka pololei; i hooili aku ai o Iehova maluna o Aberahama i ka mea ana i olelo ai nona. ");
INSERT INTO haw1868_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Olelo mai la o Iehova, Ua nui loa ka leo no Sodoma a me Gomora, ua kaumaha no hoi ko lakou hewa; ");
INSERT INTO haw1868_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","E iho ana au ilaila e ike, i like paha ka lakou hana ana me ka leo no ia wahi i hiki mai ai io'u nei; a i ole paha, o ike auanei hoi au. ");
INSERT INTO haw1868_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Huli ae la ua mau kanaka la i na maka o laua mailaila aku, a hele aku la i Sodoma: aka, ku iho la o Aberahama imua o Iehova. ");
INSERT INTO haw1868_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Neenee aku la o Aberahama a kokoke, i aku la, E luku pu anei oe i ka poe pono me ka poe hewa? ");
INSERT INTO haw1868_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Ina paha he kanalima na kanaka pono maloko o ua kulanakauhale la, e luku anei oe ia wahi, aole no o malama ia wahi no ka poe pono he kanalima maloko? ");
INSERT INTO haw1868_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Aole loa oe e hana pela, ke pepehi pu i ka poe pono me ka poe hewa: i like pu ai ka poe pono me ka poe hewa, aole loa oe pela: aole anei o hana pono ka lunakanawai o ka honua a pau? ");
INSERT INTO haw1868_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","I mai la o Iehova, Ina loaa ia'u ma Sodoma na kanaka pono he kanalima maloko o ke kulanakauhale, alaila au e malama ai ia wahi a pau no lakou. ");
INSERT INTO haw1868_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Olelo aku la o Aberahama, i aku la, Eia hoi, ua hoomaka no wau e olelo aku i ka Haku, owau he lepo wale no, a me ka lehu: ");
INSERT INTO haw1868_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","A i emi mai na mea elima o ka poe pono he kanalima; e luku anei oe ia kulanakauhale a pau no ia mau mea elima? I mai ia kela, A i loaa ia'u ilaila he kanaha a me kumamalima, aole au e luku aku. ");
INSERT INTO haw1868_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Olelo hou aku la oia ia ia, i aku la, Ina paha he kanaha ka poe i loaa ilaila? i mai la kela, Aole au o hana aku ia mea, ke kanaha lakou. ");
INSERT INTO haw1868_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","I aku la hoi oia, Ea, a i huhu ole mai ka Haku, e olelo aku no au: Ina paha he kanakolu ka poe i loaa ilaila? I mai la kela, Aole au e hana ia mea, ke loaa ia'u he kanakolu ilaila. ");
INSERT INTO haw1868_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","I aku la oia, Aia hoi, na hoomaka iho nei au e olelo aku i ka Haku: Ina paha ho iwakalua ka poe i loaa ilaila? I mai la kola, aole au o luku aku, ko iwakalua lakou. ");
INSERT INTO haw1868_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","I aku la hoi oia, A i ole e huhu mai ka Haku, a hookahi wale no a'u olelo e koe: Ina paha he umi ka poe i loaa ilaila? I mai la kela, Aole au e luku aku, ke umi lakou. ");
INSERT INTO haw1868_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","A pau ae la ka Iehova kamailio ana mo Aberahama, hele aku la o Iehova; a hoi hou mai la o Aberahama i kona wahi. ");
INSERT INTO haw1868_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","A AHIAHI iho la, hiki aku la na anela elua ma Sodoma: a noho iho la o Lota ma ka ipuka o Sodoma: ike aku la o Lota, ku ae la ia e halawai me lakou, a kulou iho la kona mau maka ilalo ma ka honua; ");
INSERT INTO haw1868_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","I aku la, E kuu mau haku, ke noi aku nei au ia olua, e kipa mai olua maloko o ka hale o ka olua kauwa nei, e moe no a ao ka po, a e holoi i ko olua wawae, a kakahiaka nui e ala'e olua a e hele aku. I mai la laua, Aole, e moe no maua ma ke alanui a ao ka po. ");
INSERT INTO haw1868_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Koi ikaika aku la ia ia laua; a kipa ae la laua io na la, a komo aku la iloko o kona hale; a hana iho no ia i ahaaina na laua, pulehu iho la i ka palaoa huole, a ai iho la laua. ");
INSERT INTO haw1868_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Aole laua i moe iho, a o na kanaka o ke kulanakauhale, o na kanaka o Sodoma, o ka poe kahiko a me ka poe hou, o na kanaka a pau mai o a o, hoopuni mai la lakou i ka hale: ");
INSERT INTO haw1868_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Kahea mai la lakou ia Lota, i mai la ia ia, Auhea na kanaka i hele mai i ou la i keia po? E kai mai ia laua iwaho io makou nei, i ike makou ia laua. ");
INSERT INTO haw1868_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Hele aku la o Lota iwaho ma ka puka io lakou la; a papani ae la i ka puka mahope ona. ");
INSERT INTO haw1868_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","I aku la, E na hoahanau, ke nonoi aku nei au ia oukou, mai hana hewa oukou. ");
INSERT INTO haw1868_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Eia hoi ia'u na kaikamahine elua i ike ole i ke kane; e ae mai oukou ia'u e lawe mai ia laua iwaho io oukou nei, a e hana aku oukou ia laua i ka mea pono ma ko oukou maka: aka, mai hana aku oukou i kekahi mea i keia mau kanaka; no ka mea, nolaila laua i hele mai nei ma ka malumalu o kuu hale. ");
INSERT INTO haw1868_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","I mai la lakou, E hookaawale oe. I ae la hoi lakou, I hele mai no oia nei e noho wale maanei, a e lilo ana ka ia i lunakanawai: ano hoi, e oi aku ka makou hana ino ana ia oe i ko laua la. A hookeke nui mai la lakou i ua kanaka nei, ia Lota, a neenee mai la e wawahi i ka pani puka. ");
INSERT INTO haw1868_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Aka, lalau aku la ua mau kanaka la ia Lota, a huki mai laua ia ia iloko o ka hale io laua la, a papani aku la i ka puka. ");
INSERT INTO haw1868_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Hoomakapo iho la laua i ka poe kanaka iwaho o ka puka o ka hale, i na mea uuku a me na mea nui: a hoopauaho lakou ia lakou iho i ka imi i ka puka. ");
INSERT INTO haw1868_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","I mai la laua ia Lota, Aole anei ia oe kekahi poe e ae maanei? o ka hunonakane paha, o na keikikane au, a me au mau kaikamahine, a o na mea a pau ia oe, e laweia'ku iwaho o keia wahi: ");
INSERT INTO haw1868_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","No ka mea, e luku aku maua i keia wahi, no ka nui loa ae o ka leo no lakou, imua o ke alo o Iehova; a ua hoouna mai no o Iehova ia maua e luku aku ia wahi. ");
INSERT INTO haw1868_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Hele aku la o Lota iwaho, olelo aku la i kona mau hunonakane i mare me na kaikamahine ana, i aku la, E ala'e, e holo aku iwaho o keia wahi; no ka mea, e luku mai ana o Iehova i neia kulanakauhale. Aka, ua like ia i ka manao o na hunonakane me ka mea hoomaewaewa. ");
INSERT INTO haw1868_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","I ka wanaao, hoolalelale ua mau anela la ia Lota, i mai la, E ala ae, e lawe i kau wahine, a me kau mau kaikamahine elua maanei, o pau auanei oe iloko o ka make o ko ke kulanakauhale. ");
INSERT INTO haw1868_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Ia ia i hookaulua ai, lalau aku la ua mau kanaka la i kona lima, me ka lima o kana wahine, a me ka lima o kana mau kaikamahine elua; ahonui mai la o Iehova ia ia: alakai aku la laua ia ia, a hookuu aku la iwaho o ke kulanakauhale. ");
INSERT INTO haw1868_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","I ka wa i alakai aku ai laua ia lakou iwaho o ke kulanakauhale, alaila i mai la ia, E holo i pakele kou ola; mai nana i hope ou, mai kali oe ma neia wahi papu a pau; e holo i ka mauna, o make oe. ");
INSERT INTO haw1868_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","I aku la o Lota ia laua, Auwe! e kuu Haku, aole pela. ");
INSERT INTO haw1868_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Eia hoi, ua loaa iho nei i kau kauwa ka lokomaikai imua o kou mau maka, a ua hoonui ae nei oe i kou aloha au i hoike mai ai ia'u i ka hoola ana mai ia'u, aole e hiki ia'u ke holo ma ka mauna, o loaa ia'u ka poino, a make au. ");
INSERT INTO haw1868_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Eia ae ke kulanakauhale, e hiki koke ke holo malaila, a ua liilii hoi ia; ea, e ae mai ia'u e holo malaila, (aole anei ia he wahi liilii?) a e malamaia kuu ola. ");
INSERT INTO haw1868_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","I mai la kela ia ia, Aia, ua hoolohe aku no au i keia mea hoi; aole au e luku aku ia kulanakauhale, no ka mea au i olelo mai ai. ");
INSERT INTO haw1868_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","E wikiwiki oe e holo ilaila; no ka mea, aole e hiki ia'u ke hana i kekahi mea, a puka aku no oe ilaila. Nolaila, ua kapaia ka inoa o ia kulanakauhale, o i Zoara. ");
INSERT INTO haw1868_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Ua puka mai ka la maluna o ka honua i ke komo ana o Lota iloko o Zoara. ");
INSERT INTO haw1868_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Alaila, hooua mai la o Iehova maluna o Sodoma i ka luaipele a me ke ahi mai o Iehova la, mai ka lani mai. ");
INSERT INTO haw1868_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Hookahuli iho la oia ia mau kulanakauhale, a me kahi papu a pau, a me na kanaka a pau o ua mau kulanakauhale la, a me na mea ulu ma ka honua. ");
INSERT INTO haw1868_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Aka, nana ae la kana wahine mahope ona, a lilo iho la ia i kukulu paakai. ");
INSERT INTO haw1868_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Ala ae la o Aberahama i kakahiaka nui, a hoi hou aku la ia i kahi ana i ku ai imua o Iehova: ");
INSERT INTO haw1868_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Nana aku la ia ma Sodoma a me Gomora, a ma ka aina papu a pau, ike aku la ia, aia hoi, pii ae la ka uahi o ia aina iluna, e like me ka punohu o ka lua ahi. ");
INSERT INTO haw1868_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","A i ka wa a ke Akua i luku ai i na kulanakauhale o ka papu, hoomanao iho la no ke Akua ia Aberahama, a hoopakele ae la ia Lota maiwaena aku o ka hookahuli ana, ia ia i hookahuli ai i na kulanakauhale kahi a Lota i noho ai. ");
INSERT INTO haw1868_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Pii ae la o Lota mailoko aku o Zoara, a noho iho la ma ka mauna, a me ia pu na kaikamahine ana elua; no ka mea, makau iho la ia ke noho ma Zoara: noho no ia ma kekahi ana, oia a me kana mau kaikamahine elua. ");
INSERT INTO haw1868_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","I aku la ka hanau mua i kona kaikaina, Ea, ua elemakule ko kana makuakane, aole hoi he kanaka ma ka honua nei a pau nana e komo mai io kaua nei, e like me ka nana ana a ko ka honua nei: ");
INSERT INTO haw1868_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Ina kaua, o hooinu kaua i ko kaua makuakane i ka waina, a e moe kaua me ia, i malama ai kana i hua na ko kaua makuakane. ");
INSERT INTO haw1868_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Hooinu laua ia po i ko laua makuakane i ka waina: a komo aku la ka hanau mua iloko, a moe iho la me kona makuakane: aole nae i ike kela i kona wa i moe iho ai, aole hoi kona wa i ala'i. ");
INSERT INTO haw1868_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","A ia la ae, i aku la ka hanau mua i ke kaikaina, Aia hoi, moe iho no au me kuu makuakane i ka po nei: e hooinu kaua ia ia i ka waina i keia po no hoi; a e komo aku oe iloko, e moe me ia, i malama ai kana i hua na ko kana makuakane. ");
INSERT INTO haw1868_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Hooinu laua i ko laua makuakane i ka waina ia po no hoi: a ku ae la ke kaikaina, a moe iho la me ia; aole kela i ike i kona wa i moe iho ai, aole hoi i kona wa i ala ai. ");
INSERT INTO haw1868_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Hapai na kaikamahine elua a Lota na ko laua makuakane. ");
INSERT INTO haw1868_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Hanau mai la ka mua i keikikane, a kapa iho la i kona inoa o Moaba: oia ke kupuna o ka Moaba a hiki i keia manawa. ");
INSERT INTO haw1868_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","A hanau mai la hoi ka muli iho i keikikane, a kapa iho la i kona inoa o Benami: oia ke kupuna o ka Amona a hiki i keia manawa. ");
INSERT INTO haw1868_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","HELE aku la o Aberahama mailaila aku ma ka aina kukuluhema, a noho hoi ia mawaena o Kadesa a o Sura, a ma Gerara kona noho malihini ana. ");
INSERT INTO haw1868_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Olelo aku la o Aberahama no kana wahine no Sara, Oia no kuu kaikuwahine: a hoouna mai la o Abimeleka ke alii o Gerara, a lawe aku la ia Sara. ");
INSERT INTO haw1868_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","A hele mai la ke Akua io Abimeleka la ma ka moeuhane i ka po, i mai la ia ia, Aia hoi, he kanaka make oe, no ka wahine au i lawe iho nei, no ka mea, he wahine mea kane ia. ");
INSERT INTO haw1868_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Aka, aole i hoopili o Abimeleka ia ia: i aku la oia, E ka Haku, e pepehi mai no hoi oe i ka lahuikanaka hala ole? ");
INSERT INTO haw1868_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Aole anei ia i olelo mai ia'u, O ko'u kaikuwahine ia! a o ka wahine, oia ka i i mai, He kaikunane keia no'u: ma ka manao pono o kuu naau a me ka hala ole o kuu mau lima ka'u i hana aku ai i keia. ");
INSERT INTO haw1868_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","I mai la ke Akua ia ia ma ka moeuhane, Oiaio. ke ike nei au, ua hana aku oe i keia ma ka manao pono o kou naau; a ua hoopaa no hoi au ia oe, i ole oe e hana hewa mai ia'u: nolaila, aole au i ae aku ia oe e hoopa ia ia. ");
INSERT INTO haw1868_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","No ia mea hoi, e hoihoi aku na ua kanaka la i kana wahine; no ka mea, he kaula ia, a nana no e pule mai nou, i ola ai oe: a i ole oe e hoihoi mai ia ia, alaila e ike pono oe, he oiaio e make no oe, o oe a me ou poe a pau. ");
INSERT INTO haw1868_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Ala ae la o Abimeleka i kakahiaka nui, houluulu ae la i kana poe kauwa a pau, a hai aku la i keia mau mea maloko o ko lakou mau pepeiao: a makau loa iho la na kanaka. ");
INSERT INTO haw1868_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Alaila, kahea mai la o Abimeleka ia Aberahama, i mai la ia ia, Heaha kau i hana mai ai ia makou? Heaha hoi ko'u hala in oe, i hooili mai ai oe iluna iho o'u a o ko'u aupuni ka hewa nui? Ua hana mai oe ia'u i na mea pono ole ke hanaia. ");
INSERT INTO haw1868_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Ninau mai la o Abimeleka ia Aberahama, Heaha kau i ike mai ai, i hana iho ai oe i keia mea? ");
INSERT INTO haw1868_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","I aku la o Aberahama, No ka mea, i iho la au ma kuu naau, He oiaio, aole ka makau i ke Akua ma keia wahi; a e pepehi mai auanei lakou ia'u no kuu wahine. ");
INSERT INTO haw1868_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","He oiaio hoi, o ko'u kaikuwahine no ia, ke kaikamahine a kuu makuakane, aole nae ia ke kaikamahine a kuu makuwahine, a lilo mai la ia i wahine na'u. ");
INSERT INTO haw1868_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","A i ka manawa a ke Akua i hooanwana mai ai ia'u mai ka hale o ko'u makuakane mai, i aku la au ia ia nei, Eia kou lokomaikai au e hoike mai ai ia'u: i na wahi a pau e hiki aku ai kana, e olelo aku oe no'u, O ko'u kaikunane ia. ");
INSERT INTO haw1868_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Lawe ae la o Abimeleka i na hipa, me na bipikane, i na kauwakane a me na kauwawahine, a haawi mai la ia Aberahama, a hoihoi mai la oia ia Sara kana wahine nana. ");
INSERT INTO haw1868_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","I mai la o Abimeleka, Aia hoi, imua ou ko'u aina, e noho ma kahi i makemake ai oe. ");
INSERT INTO haw1868_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","I mai la hoi oia ia Sara, Aia hoi, ua haawi iho nei au i na apana kala he tausani na kou kaikunane: aia hoi, he mea pale maka ia nou imua o ka poe a pau me oe, a me na mea a pau: pela oia i aoia mai ai. ");
INSERT INTO haw1868_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Pule aku la o Aberahama i ke Akua: a hoola mai la ke Akua ia Abimeleka, me kana wahine a me kana poe kauwawahine; a hanaukeiki lakou. ");
INSERT INTO haw1868_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","No ka mea, ua papaniia e Iehova na opu o na wahine a pau o ka hale o Abimeleka, no Sara ka wahine a Aberahama. ");
INSERT INTO haw1868_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","I KE mai la o Iehova ia Sara e like me kana i i mai ai; a hana mai la o Iehova ia Sara e like me kana i olelo mai ai. ");
INSERT INTO haw1868_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","No ka mea, hapai ae la o Sara, a hanau mai la he keikikane na Aberahama i kona wa elemakule; i ka manawa a ke Akua i olelo mai ai ia ia. ");
INSERT INTO haw1868_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Kapa aku la o Aberahama i ka inoa o kana keiki i hanau nana, i ka mea a Sara i hanau ai nana, o Isaaka. ");
INSERT INTO haw1868_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","I ka po awalu, okipoepoe ae la o Aberahama i kana keiki ia Isaaka e like me ka ke Akua i kauoha mai ai ia ia. ");
INSERT INTO haw1868_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Hookahi haneri makahiki o Aberahama i ka wa i hanau ai o Isaaka nana. ");
INSERT INTO haw1868_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","I mai la o Sara, Ua hoakaaka mai no ke Akua ia'u, a e akaaka pu hoi me au ka poe lohe a pau. ");
INSERT INTO haw1868_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","I mai la hoi oia, Owai ka mea i olelo ia Aberahama, e hanai auanei o Sara i na keiki i ka waiu? no ka mea, ua hanau iho nei au i keikikane nana i kona wa elemakule. ");
INSERT INTO haw1868_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Nui ae la na keiki nei, a ukuhi ia: a hana iho la o Aberahama i ka ahaaina nui, i ka la a Isaaka i haalele ai i ka waiu. ");
INSERT INTO haw1868_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Ike aku la o Sara i ke keiki a Hagara no Aigupita, i ka mea ana i hanau ai na Aberahama, e hoomaewaewa ana. ");
INSERT INTO haw1868_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","No ia mea, i mai la oia ia Aberahama, E hookuke aku oe i ua kauwawahine la a me kana keiki: no ka mea, aole e hooili pu ia'ku ka waiwai i ke keiki a ua kauwawahine la me ka'u keiki, me Isaaka. ");
INSERT INTO haw1868_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","He mea ehaeha loa ia i ka manao o Aberahama, no kana keiki. ");
INSERT INTO haw1868_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","I mai la ke Akua ia Aberahama, Mai hoehaeha oe i kou naau no ke keiki, a no kau kauwawahine, e hoolohe aku oe i ka leo o Sara i ka mea a pau ana i olelo mai ai ia oe; no ka mea, e kapaia'ku kau poe mamo mamuli o Isaaka. ");
INSERT INTO haw1868_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","A e hoolilo auanei hoi au i ke keiki a ke kauwawahine i lahuikanaka, no ka mea, o kau keiki ia. ");
INSERT INTO haw1868_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Ala ae la o Aberahama i ke kakahiaka nui, lalau aku la ia i ka berena a me ka wai iloko o ka hue a haawi ae la ia Hagara, a kau aku la maluna o kona poohiwi, a me ke keiki no hoi, a kuu aku la ia ia: hele aku no ia, a kuewa wale ae la maloko o ka waonahele o Beeresaba. ");
INSERT INTO haw1868_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","A pau ae la ka wai iloko o ka huewai, waiho iho la ia i ke keiki malalo o kekahi laau uuku. ");
INSERT INTO haw1868_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Hele aku la ia, a noho iho la i kahi kupono ia ia, e mamao aku ana e like me ka pana ana o ka pua: no ka mea, i iho la ia, Aole au e pono ke ike i ka make ana o ke keiki Noho aku la ia i kahi kupono, a hookiekie ae la ia i kona leo, a uwe iho la. ");
INSERT INTO haw1868_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Hoolohe mai la ke Akua i ka leo o ke keiki; a kahea mai la ka anela o ke Akua ia Hagara mai ka lani mai, i mai la ia ia, Heaha kau e Hagara? mai makau oe; no ka mea, ua hoolohe mai no ke Akua i ka leo o ke keiki ma kona wahi i waiho ai. ");
INSERT INTO haw1868_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","E ku ae oe, e kaikai ae i ke keiki, a e hoopaa aku kou lima ia ia; no ka mea, e hoolilo auanei au ia ia i lahuikanaka nui. ");
INSERT INTO haw1868_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Hookaakaa ae la ke Akua i kona mau maka, a ike aku la ia i kekahi luawai: hele aku la ia, ukuhi iho la a piha ka huewai i ka wai, a hooinu iho la i ke keiki. ");
INSERT INTO haw1868_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Me ua keiki nei no ke Akua, a nui ae la ia, a noho iho la ma ka waonahele, a lilo ae la ia i kanaka pana pua, ");
INSERT INTO haw1868_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Noho iho la ia ma ka waonahele o Parana: a lawe ae la kona makuwahine i wahine nana, no Aigupita mai. ");
INSERT INTO haw1868_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Ia manawa, olelo mai la o Abimeleka laua o Pikola kona luna koa ia Aberahama, i ka i ana mai, Me oe no ke Akua i na mea a pau au e hana nei: ");
INSERT INTO haw1868_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Nolaila hoi, e hoohiki oe no'u ano ma ke Akua, aole oe e hoopunipuni mai ia'u, aole i ka'u keiki, aole hoi i ka'u moopuna: e like me ka lokomaikai a'u i hana aku ai ia oe, pela hoi oe e hana mai ai ia'u, a i ko ka aina au i noho iho ai. ");
INSERT INTO haw1868_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","I aku la o Aberahama, E hoohiki no wau. ");
INSERT INTO haw1868_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Ao aku la hoi o Aberahama ia Abimeleka no ka luawai a na kauwa a Abimeleka i kaili aku ai. ");
INSERT INTO haw1868_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","I mai la o Abimeleka, Aole au i ike i ka men nana i hana ia mea: aole hoi oe i hai mai; aole hoi au i lohe a hiki i keia la. ");
INSERT INTO haw1868_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Lalau aku la o Aberahama i na hipa a me na bipikane, a haawi aku la ia mau mea no Abimeleka; a hoopaa iho la laua a elua i berita. ");
INSERT INTO haw1868_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","A hoonoho aku la o Aberahama i na hipa keiki wahine i ehiku ma kahi kaawale. ");
INSERT INTO haw1868_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Ninau mai la o Abimeleka ia Aberahama, I me aha keia mau hipa keiki wahine ehiku, au i hoonoho iho ai ma kahi kaawale! ");
INSERT INTO haw1868_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","I aku la keia, No ka mea, e lawe oe i keia mau hipa keiki wahine ehiku na kuu lima aku, i mea hoike maka no'u, na'u no i eli iho i keia luawai. ");
INSERT INTO haw1868_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Nolaila, kapa iho la oia ia wahi, o Beereseba; no ka mea, ilaila i hoohiki aku ai laua a elua. ");
INSERT INTO haw1868_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Pela no laua i hoopaa iho ai i berita ma Beereseba: alaila, ku ae la o Abimeleka laua o Pikola kona luna koa, a hoi hou aku la laua i ka aina o ko Pilisetia. ");
INSERT INTO haw1868_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Kanu iho la o Aberahama i laau ma Beereseba, a kahea aku la ilaila i ka inoa o Iehova ke Akua mau loa. ");
INSERT INTO haw1868_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Noho iho la o Aberahama ma ka aina o ko Pilisetia i na la he nui loa. ");
INSERT INTO haw1868_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","MAHOPE mai o ia mau mea, hoao mai la ke Akua ia Aberahama, i mai la ia ia, E Aberahama: i aku la kela, Eia no wau. ");
INSERT INTO haw1868_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","I mai la oia, E lawe aku oe i kau keiki i kau ponoi, ia Isaaka, i kau mea au e aloha nei, a e hele aku oe i ka aina o Moria; malaila oe e kaumaha aku ai ia ia i mohaikuni maluna o kekahi puu a'u e hoike aku ai ia oe. ");
INSERT INTO haw1868_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Ala ae la o Aberahama i kakahiaka nui, hoee aku la ia i ka noho maluna o kona hoki, kono pu ae la i na kanaka ui elua ona me ia, a me Isaaka kana keiki, kaka iho la i ka wahie no ka mohaikuni, ku ae la a hele aku la i kahi a ke Akua i i mai ai ia ia. ");
INSERT INTO haw1868_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","I ke kolu o ka la alawa ae la na maka o Aberahama, a ike aku la ia wahi mamao aku. ");
INSERT INTO haw1868_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","I aku la o Aberahama i kona mau kanaka ui, E noho iho olua maanei me ka hoki, a hele no maua me ke keiki i o e hoomana ai; a hoi hou mai io olua nei. ");
INSERT INTO haw1868_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Lawe ae la o Aberahama i ka wahie no ka mohaikuni, a kau iho la maluna o kana keiki o Isaaka, lawe aku la ia i ke ahi, a me ka pahi ma kona lima, a haele pu aku la laua. ");
INSERT INTO haw1868_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Olelo aku la o Isaaka i kona makuakane, ia Aberahama, E kuu makua: i mai la kela, Eia wan, e kuu keiki. I aku la ia, Eia ke ahi, a me ka wahie; auhea hoi ke keikihipa i mohaikuni? ");
INSERT INTO haw1868_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","I mai la o Aberahama, E kuu keiki, na ke Akua no e hoomakaukau i keikihipa nana i mohaikuni: a haele pu aku la laua. ");
INSERT INTO haw1868_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","A hiki aku la laua i kahi a ke Akua i i mai ai ia ia; hana iho la o Aberahama i kuahu ilaila, kau pono aku la i ka wahie maluna, hikii iho la ia i kana keiki ia Isaaka, a kau aku la ia ia ma ke kuahu maluna o ka wahie. ");
INSERT INTO haw1868_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","O aku la ko Aberahama lima, a lalau i ka pahi e pepehi i kana keiki. ");
INSERT INTO haw1868_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Kahea mai la ka anela o Iehova mai ka lani mai, i mai la, E Aberahama! e Aberahama! I aku la kela, Eia wau. ");
INSERT INTO haw1868_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","I mai la ia, Mai kau aku oe i kou lima maluna o ke keiki, aole hoi e mea iki aku ia ia: no ka mea, ke ike nei au, ua makau oe i ke Akua: no ka mea, aole oe i aua i kau keiki, i kau keiki ponoi ia'u. ");
INSERT INTO haw1868_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Alawa ae la na maka o Aberahama iluna, ike aku la, aia hoi, ma kona kua he hipakane, ua hihia kona pepeiaohao i ka nahelehele: hele aku la o Aberahama, lalau aku la i ua hipakane la, a kaumaha aku la ia ia i mohaikuni, i kala no kana keiki. ");
INSERT INTO haw1868_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Kapa aku la o Aberahama i ka inoa o ia wahi, O Iehova-iire: me ia i oleloia mai ai a hiki i keia la, Ma ka mauna o Iehova e hoomakaukauia'i. ");
INSERT INTO haw1868_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Kahea hou mai la ka anela o Iehova ia Aberahama mai ka lani mai, ");
INSERT INTO haw1868_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","I mai la, Ke olelo mai nei o Iehova, Ma o'u nei au i hoohiki iho ai, no kau hana ana i keia mea, aole hoi i aua i kau keiki, i kau keiki ponoi; ");
INSERT INTO haw1868_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","E hoopomaikai nui aku no au ia oe, a e hoonui loa aku hoi au i kau poe mamo e like me na hoku o ka lani, a me na one ma kahakai; a e lilo auanei i kau poe mamo ka ipuka o kona poe enemi: ");
INSERT INTO haw1868_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","A ma kou mamo e hoopomaikaiia'i na lahuikanaka a pau o ka honua; no ka mea, ua hoolohe mai oe i ko'u leo. ");
INSERT INTO haw1868_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Hoi hou aku la o Aberahama i kona mau kanaka ui, ku ae la laua a hele pu aku la i Beereseba: a noho iho la o Aberahama i Beereseba. ");
INSERT INTO haw1868_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Mahope mai o ia mau mea, haiia mai ia Aberahama, i ka i ana mai, Aia hoi, o Mileka, ua hanau no hoi oia i na keiki na kou kaikuaana na Nahora; ");
INSERT INTO haw1868_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","O Huza kana hiapo, o Buza kona kaikaina, a o Kemuela ka makuakane o Arama, ");
INSERT INTO haw1868_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","O Keseda, a o Hazo, a o Piledasa, a o Iidelapa, a o Betuela. ");
INSERT INTO haw1868_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Na Betuela o Rebeka: o keia mau mea ewalu ka Mileka i hanau ai na Nahora ke kaikuaana o Aberahama. ");
INSERT INTO haw1868_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Na kana haiawahine hoi, o Reuma kona inoa, nana hoi i hanau mai o Teba, o Gehama, o Tahasa, a o Maaka. ");
INSERT INTO haw1868_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","HOOKAHI haneri na makahiki me ka iwakaluakumamahiku o Sara: oia na makahiki o ke ola ana o Sara. ");
INSERT INTO haw1868_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","A make aku la o Sara ma Kiriatareba, oia o Heberona ma ka aina o Kanaana; a hele mai la o Aberahama e uwe a e kanikau ia Sara. ");
INSERT INTO haw1868_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Ka ae la o Aberahama iluna, mai ke alo ae o kana mea i make, olelo aku la ia i na mamo a Heta, i aku la, ");
INSERT INTO haw1868_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","He malihini no wau e noho wale ana me oukou: e haawi mai i ilina iwaena o oukou, i lilo ia no'u, i kanu aku au i kuu mea i make, mai ko'u mau maka aku. ");
INSERT INTO haw1868_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Olelo mai na mamo a Heta ia Aberahama, i mai la ia ia, ");
INSERT INTO haw1868_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","E hoolohe mai oe i ka makou, e kuu haku: he alii nui no oe iwaena o makou; ma ka ilina maikai loa o makou, e kanu iho ai oe i kau mea make: aole e aua kekahi o makou i kona ilina ia oe, i ole oe e kanu i kou mea make. ");
INSERT INTO haw1868_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Ka ae la o Aberahama, a kulou iho la imua o na kanaka o ka aina, o na mamo a Heta. ");
INSERT INTO haw1868_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Kamailio aku la ia me lakou, i aku la, Ina o ko oukou manao ia, i kanu iho ai au i kuu mea make mai o'u mau maka aku; e hoolohe mai, a e noi aka oukou ia Eperona ke keiki a Zohara no'u; ");
INSERT INTO haw1868_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","I haawi mai ai oia i ke ana o Makepela no'u; nona no ia, aia no ma ka palena o kana mahinaai; no na kala e pono ke kuai, e haawi mai no oia ia wahi no'u i ilina iwaena o oukou. ");
INSERT INTO haw1868_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Noho pa iho la o Eperona me na mamo a Heta: olelo mai la o Eperona ka Heta ia Aberahama, ma ka lohe o na mamo a Heta, a o ka poe a pau i komo ma ka ipuka o ke kulanakauhale, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","E kuu haku, e hoolohe mai oe ia'u: ke haawi wale aku nei au i ka mahinaai a me ke ana maloko, nou, ke haawi aku nei au nou ia wahi: imua o na keiki a o'u poe kanaka, ke haawi aku nei au nou ia wahi: e kanu aku oe i kau mea make. ");
INSERT INTO haw1868_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Kulou iho la o Aberahama ilalo, imua o na kanaka o ia aina. ");
INSERT INTO haw1868_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","I aku la oia ia Eperona ma ka lohe o na kanaka o ia aina, i ka i ana, Ke noi aku nei au ia oe, e hoolohe mai oe ia'u, Ina e ae mai oe, e haawi aku no wau i ke kala no ua mahinaai la; e lawe oe i ka'u, a e kanu no wau i kau mea make ilaila. ");
INSERT INTO haw1868_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Olelo mai la o Eperona ia Aberahama, i mai la ia ia, ");
INSERT INTO haw1868_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","E kuu haku, e hoolohe mai ia'u, eha haneri sekela kala ke kumukuai o ia aina; heaha hoi ia iwaena o kaua? e kanu hoi oe i kau mea make. ");
INSERT INTO haw1868_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Ae mai la o Aberahama ia Eperona; a kaupouna iho la o Aberahama no Eperona i ke kala ana i olelo ai ma ka lohe o na mamo a Heta, eha haneri sekela kala, he kala pono i ka poe kuai. ");
INSERT INTO haw1868_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","A ua hoolilo paa ia ka mahinaai a Eperona ma Makepela, ma ke alo o Mamere, o ka mahinaai me ke ana maloko, a me na laau a pau o na mahinaai la, a e puni ana ma na palena a pau, ");
INSERT INTO haw1868_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","No Aberahama i wahi nona ma ke alo o na mamo a Heta, imua hoi o ka poe a pau i komo ma ka ipuka o kona kulanakauhale. ");
INSERT INTO haw1868_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Mahope iho, kanu iho la o Aberahama i kana wahine ia Sara iloko o ke ana ma ka mahinaai o Makepela ma ke alo o Mamere: oia o Heberona i ka aina o Kanaana. ");
INSERT INTO haw1868_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Ua hoolilo paa ia ka mahinaai a me ke ana maloko, no Aberahama i ilina nona, e na mamo a Heta. ");
INSERT INTO haw1868_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","U A elemakule o Aberahama, ua nui no hoi kona mau la, a ua hoopomaikai o Iehova ia Aberahama i na mea a pau. ");
INSERT INTO haw1868_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","I aku la o Aberahama i ke kauwa kahiko o kona hale, i ka mea ia ia ka malama i kona mea a pau, E, e kau mai oe i kou lima malalo iho o ko'u uha: ");
INSERT INTO haw1868_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","A na'u no e haawi aku ia oe e hoohiki ma o Iehova la, ma ke Akua o ka lani, a ke Akua o ka honua; i lawe ole ai oe i wahine na ka'u keiki na Isaaka, no na kaikamahine a ko Kanaana ka poe a'u o noho nei iwaena. ");
INSERT INTO haw1868_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Aka, e hele aku oe i ko'u aina, a i ko'u poe hoahanau, a e lawe mai i wahine na ka'u keiki na Isaaka. ");
INSERT INTO haw1868_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","I mai la ua kauwa nei ia ia, Ina paha aole e makemake ka wahine e hahai mai ia'u a hiki i keia aina: e pono anei ia'u e kai aku i kau keiki i ka aina au i hele mai nei? ");
INSERT INTO haw1868_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Papa aku la o Aberahama ia ia, E ao oe, mai kai aku oe i ka'u keiki malaila. ");
INSERT INTO haw1868_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Na Iehova ke Akua o ka lani, nana au i lawe, mai ka hale mai o ko'u makuakane, a mai ka aina mai o ko'u poe hoahanau, a olelo mai ia'u, a hoohiki mai no hoi ia'u, i ka i ana mai, E haawi auanei au i keia aina no kau poe mamo; nana no e hoouna aku i kona anela mamua ou, a e lawe mai oe i wahine na ka'u keiki mailaila mai. ");
INSERT INTO haw1868_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","A i makemake ole ka wahine e hahai mai ia oe, alaila e hala ole oe i keia hoohiki ana no'u: aka, mai kai aku oe i ka'u keiki ilaila. ");
INSERT INTO haw1868_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","A kau iho la ke kauwa i kona lima malalo iho o ka uha o Aberahama kona haku, a hoohiki iho la nona ma ia mea. ");
INSERT INTO haw1868_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Lalau aku la ua kauwa la i na kamelo o kona haku he umi, no ka mea, ma kona lima ka waiwai a pau o kona haku: ku ae la ia, a hele aku la i Mesopotamia, i ke kulanakauhale o Nahora. ");
INSERT INTO haw1868_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Hookukuli iho la ia i kona mau kamelo mawaho o ke kulanakauhale, ma ka luawai, i ke ahiahi, i ka manawa e hele mai ai na wahine e huki wai. ");
INSERT INTO haw1868_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","I aku la ia, E Iehova ke Akua o kuu haku o Aberahama, ke pule aku nei au ia oe, e hoopomaikai mai oe ia'u i keia la, a e lokomaikai mai oe i kuu haku ia Aberahama, ");
INSERT INTO haw1868_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Eia au ke ku nei ma ka luawai; a e hele mai ana na kaikamahine a na kanaka o ke kulanakauhale e huki i ka wai: ");
INSERT INTO haw1868_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","E ae mai oe, o ke kaikamahine a'u e olelo aku ai, Ke noi aku nei au ia oe, e kuu iho oe i kou bakeke, i inu ai au; a e i mai oia, E inu oe, a e hoohainu hoi au i na kamelo: oia no ka mea au i koho ai na kau kauwa na Isaaka: ilaila au e ike ai i kau lokomaikai ana mai i kuu haku. ");
INSERT INTO haw1868_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Aole ia i hooki iho i kana olelo ana, Aia hoi, hiki mai la o Rebeka, ka mea i hanau na Betuela, na ke keikikane a Mileka a ka wahine a Nahora, ko Aberahama kaikuaana, me kona bakeke maluna o kona poohiwi. ");
INSERT INTO haw1868_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Ua maikai ka maka o ua kaikamahine la ke nanaia'ku, he wahine puupaa, aole i ikeia e kekahi kane: iho iho la ia ma ka luawai, hoopiha iho la i kona bakeke, a hoi mai la iluna. ");
INSERT INTO haw1868_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Holo aku la ua kauwa la e halawai me ia, i aku la, E, ke noi aku nei au ia oe, e ho mai no'u i wahi wai o kou bakeke e inu. ");
INSERT INTO haw1868_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","I mai la kela, E inu oe, e kuu haku a wikiwiki oia i kuu iho i kona bakeke ma kona lima, a hoohainu mai la ia ia. ");
INSERT INTO haw1868_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","A pau kana hoohainu ana ia ia, i mai la ia, E huki hoi au i ka wai no kou mau kamelo, a pau ko lakou inu ana. ");
INSERT INTO haw1868_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Wikiwiki ae la ia, a ninini iho la i ka wai o kona bakeke iloko o ke pa, a holo hou ae la i ka luawai e huki ai, a huki mai la ia no kona poe kamelo a pau. ");
INSERT INTO haw1868_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Mahalo iho la ka naau o ua kanaka la ia ia, aole ia i ekemu aku, i mea e ike ai oia, i ka hoopomaikai ana mai paha o Iehova i kona hele ana mai, aole paha. ");
INSERT INTO haw1868_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","A pau ka inu ana o na kamelo, lawe ae la ua kanaka la i kekahi apo gula no ka ihu, he hapalua o ka sekela ma ke kaupouna ana, me na kupee gula elua no kona mau lima, he umi na sekela ma ke kaupouna ana; ");
INSERT INTO haw1868_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Ninau aku la ia, He kaikamahine oe nawai? ke noi aku nei au ia oe, e hai mai ia'u: a he wahi kaawale no anei iloko o ka hale o kou makuakane e moe ai makou? ");
INSERT INTO haw1868_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","I mai la kela ia ia, Owau no ke kaikamahine a Betuela a ke keiki a Mileka, ana i hanau ai na Nahora. ");
INSERT INTO haw1868_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","I hou mai la hoi kela ia ia, He mauu maloo no a he ai na na holoholona ia makou a nui, a he wahi no hoi e moe ai. ");
INSERT INTO haw1868_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Kulou iho la ke poo o ua kanaka la, a hoomaikai aku la ia Iehova; ");
INSERT INTO haw1868_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","I aku la, E hoomaikaiia'ku o Iehova ke Akua o kuu haku o Aberahama, aole ia i hoonele mai i kuu haku i kona aloha a me kona oiaio: ma ke alanui wau, a ua alakai aku o Iehova ia'u ma ka hale o na hoahanau o kuu haku. ");
INSERT INTO haw1868_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Holo aku la ua kaikamahine la, a hai aku la i ko ka hale o kona makuwahine ia mau mea. ");
INSERT INTO haw1868_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","He kaikunane ko Rebeka, o Labana kona inoa; a holo mai la o Labana iwaho i ua kanaka la, ma ka luawai. ");
INSERT INTO haw1868_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","A ike aku la ia i ke apo no ka ihu, a me na kupee lima ma na lima o kona kaikuwahine, a lohe aku la ia i ka olelo a kona kaikuwahine a Rebeka, i ka i ana mai, Pela i olelo mai ai ke kanaka ia'u; hele mai la ia i ua kanaka nei; aia hoi, ku iho la ia me na kamelo ma ka luawai. ");
INSERT INTO haw1868_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","I mai la ia, E ka mea i alohaia e Iehova, e komo mai oe; heaha kau e ku wale nei iwaho? no ka mea, ua hoomakaukau iho nei au i ka hale, a me ka wahi no na kamelo. ");
INSERT INTO haw1868_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Komo aku la ua kanaka la iloko o ka hale: wehe ae la ia i na kamelo, a haawi aku la i ka mauu maloo a me ka mea ai na na kamelo, a me ka wai e holoi i kona mau wawae, a me na wawae o na kanaka me ia. ");
INSERT INTO haw1868_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","A laweia mai ka ai nana: i aku la oia, Aole au e ai, a hai e aku au mamua i ka'u mea i hele mai nei. I mai la kela, E hai mai. ");
INSERT INTO haw1868_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","I aku la ia, Owau no ke kauwa a Aberahama. ");
INSERT INTO haw1868_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Ua hoopomaikai nui mai o Iehova i kuu haku; a ua lilo ia i mea nui: ua haawi mai ia nana i hipa, a me na bipi, i ke kala a me ke gula, i na kauwakane a me na kauwawahine, i na kamelo a me na hoki. ");
INSERT INTO haw1868_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","A hanau mai la o Sara ka wahine a kuu haku i keikikane nana i kona wa luwahine, a ua haawi aku kela i kona waiwai a pau nona. ");
INSERT INTO haw1868_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","A ua haawi mai kuu haku ia'u e hoohiki, i ka i ana mai, Mai lawe oe i wahine na kuu keiki no na kaikamahine a ko Kanaana, nona keia wahi a'u e noho nei: ");
INSERT INTO haw1868_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Aka, e hele oe i ka ohana a kuu maknakane, a i ko'u poe hoahanau, a e lawe mai oe i wahine na kuu keiki. ");
INSERT INTO haw1868_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","I aku la au i kuu haku, Ina paha aole e makemake ka wahine e hahai mai ia'u. ");
INSERT INTO haw1868_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","I mai la kela ia'u, Na Iehova, na ka Mea imua ona ko'u hele ana, nana no e hoouna aku i kona anela me oe, a e hoopomaikai i kou hele ana; a e lawe mai oe i wahine na kuu keiki no ko'u poe hoahanau, a no ka ohana a ko'u makuakane: ");
INSERT INTO haw1868_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Alaila, e hala ole oe i kuu hoohiki ana, ke hiki aku oe i ko'u poe hoahanau, a haawi ole mai lakou ia oe, alaila e hala ole oe i kuu hoohiki ana. ");
INSERT INTO haw1868_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","A hiki mai la au i keia la i ka luawai, i aku la, E Iehova ke Akua o kuu haku o Aberahama, ina oe e hoopomaikai mai i kuu hele ana e hele nei: ");
INSERT INTO haw1868_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Eia wau, ke ku nei ma ka luawai, a i ka manawa e hele mai ai ka wahine puupaa e huki wai ai, a e i aku au ia ia, Ke noi aku nei au ia oe, e haawi mai no'u i wahi wai o kou bakeke e inu; ");
INSERT INTO haw1868_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","A e olelo mai oia ia'u, E inu oe, a e huki hoi au no kou mau kamelo; oia ka wahine a Iehova i koho ai na ke keiki a ko'u haku. ");
INSERT INTO haw1868_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Aole au i hooki iho i ka olelo ana iloko o kuu naau, aia hoi, puka mai la o Rebeka, me kona bakeke maluna o kona poohiwi; iho iho la ia ma ka luawai, a huki mai la: i aku la au ia ia, Ke noi aku nei au ia oe, e haawi mai no'u e inu. ");
INSERT INTO haw1868_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Wikiwiki iho la ia, a kuu iho la i kona bakeke mailuna iho ona, i mai la, E inu oe, a e hooinu hoi au i kou mau kamelo: inu iho la no au, a hooinu aku la hoi oia i na kamelo. ");
INSERT INTO haw1868_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Ninau aku la au ia ia, i aku la, He kaikamahine oe nawai? I mai la kela, He kaikamahine na Betuela ke keiki a Nahora, na ka mea a Mileka i hanau ai nana: a lou aku la au i ke apo ma kona ihu, a me na kupee lima ma kona mau lima. ");
INSERT INTO haw1868_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Kulou iho la au i kuu poo, a hoomana aku la ia Iehova, a hoomaikai aku la ia Iehova i ke Akua o kun haku o Aberahama, nana au i alakai ma ke ala pono, i lawe au i ke kaikamahine a ka hoahanau o kuu haku i wahine na kana keiki. ");
INSERT INTO haw1868_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Ano la, a i manao lokomaikai io mai oukou i kuu haku, e hai mai ia'u: a i ole, e hai mai hoi; i huli aku ai au i ka akau paha, i ka hema paha. ");
INSERT INTO haw1868_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Alaila, olelo mai la o Labana laua o Betuela, i mai la, No Iehova mai ia mea; aole e hiki ia maua ke olelo aku ia oe he hewa, aole hoi he pono. ");
INSERT INTO haw1868_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Aia hoi o Rebeka imua o kou alo, e lawe oe ia ia a e hele aku, i lilo ai ia i wahine na ke keiki a kou haku, e like me ka Iehova i olelo mai ai. ");
INSERT INTO haw1868_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","A lohe ae la ke kanwa a Aberahama i ka laua olelo, hoomana aku la ia ia Iehova, e kulou ana i ka honua. ");
INSERT INTO haw1868_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Lawe mai la ua kauwa la i na mea kala a me na mea gula, a me na aahu, a haawi aku la ia mau mea no Rebeka: haawi aku la hoi oia i na mea maikai na kona kaikunane a me kona makuwahine. ");
INSERT INTO haw1868_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Ai iho la lakou a inu hoi, oia a me na kanaka me ia, a moe iho la ia po. Ala ae la lakou i kakahiaka, i aku la ia, E kuu aku oukou ia'u e hele i ko'u haku. ");
INSERT INTO haw1868_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","I mai la kona kaikunane laua o kona makuwahine, E noho no ke kaikamahine me makou i kekahi mau la, i umi paha: a mahope aku e hele no ia. ");
INSERT INTO haw1868_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","I aku la kela ia laua, Mai keakea mai olua ia'u, no ka mea, ua hoopomaikai mai o Iehova i kuu hele ana mai; e kuu aku oukou ia'u e hele aku ai i ko'u haku. ");
INSERT INTO haw1868_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","I mai la laua, E hea aku maua i ke kaikamahine, a e ninau aku ia ia. ");
INSERT INTO haw1868_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Hea aku la laua ia Rebeka, ninau aku la ia ia, E aku oe e hele pu me keia kanaka? I mai la kela, E hele wau. ");
INSERT INTO haw1868_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Kuu aku la laua ia Rebeka o ko laua kaikuwahine, me kona kahu, a me ke kauwa a Aberahama, a me na kanaka ona. ");
INSERT INTO haw1868_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Hoomaikai aku la laua ia Rebeka, i aku la, O oe no ko maua kaikuwahine, e lilo oe i makuwahine o na tausani miliona: e lilo hoi no kau poe mamo, ka pukapa o ka poe inaina aku ia lakou. ");
INSERT INTO haw1868_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Ku ae la o Rebeka, me kona mau wahine, holo mai la lakou maluna o na kamelo, e hahai ana i ua kanaka la: a lawe ae la ua kauwa la ia Rebeka, a hoi mai la. ");
INSERT INTO haw1868_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","I hele mai la o Isaaka ma ke alanui o ka punawai Lahairoi: no ka mea, i noho no ia ma ka aina kukuluhema. ");
INSERT INTO haw1868_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Hele aku la o Isaaka ma ke kula e noonoo ai i ka wa ahiahi: alawa ae la kona mau maka iluna, aia hoi na kamelo e hoi mai ana. ");
INSERT INTO haw1868_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Nana mai la o Rebeka, a ike mai la oia ia Isaaka, lele iho la ia mai luna iho o ke kamelo. ");
INSERT INTO haw1868_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","No ka mea, ua ninau aku ia i ua kauwa la, Owai ia kanaka e hele mai ana i ke kula e halawai me kakou? a ua i mai ke kauwa, O kuu haku no ia: no ia mea, lawe ae la ia i ka pale, a hoouhi iho la ia ia iho. ");
INSERT INTO haw1868_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","A hai mai la ua kauwa la ia Isaaka i na mea a pau ana i hana'i. ");
INSERT INTO haw1868_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Alakai aku la o Isaaka ia ia maloko o ka halelewa o kona makuwahine o Sara; lawe aku la oia ia Rebeka, a lilo iho la ia i wahine nana, a aloha ae la oia ia ia. A ua hooluoluia o Isaaka no kona makuwahine. ");
INSERT INTO haw1868_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","LAWE hou ae la o Aberahama i wahine nana, o Ketura kona inoa. ");
INSERT INTO haw1868_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","O na keiki ana i hanau ai nana, o Zimerama, o Iokesana, o Medana, o Midiana, o Isebaka a o Sua. ");
INSERT INTO haw1868_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Na Iokesana o Seba, a o Dedana. Eia ka poe mamo a Dedana, o ka Asurima, Ka Letusima, a me ka Leumima. ");
INSERT INTO haw1868_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","O na keiki a Midiana; o Epa, o Epera, o Hanoka, o Abida, a o Eledaa. O keia poe a pau na Ketura mai. ");
INSERT INTO haw1868_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Kauoha mai la o Aberahama i kona waiwai a pau ia Isaaka. ");
INSERT INTO haw1868_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Aka, haawi aku la o Aberahama i na makana na na keikikane a na haiawahine a Aberahama, a hookuu aku la ia lakou, i kona wa e ola ana, mai kana keiki o Isaaka aku, e hele i ka aina o ka hikina. ");
INSERT INTO haw1868_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Eia na la o na makahiki o ko Aberahama ola ana, hookahi haneri a me kanahikukumamalima. ");
INSERT INTO haw1868_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Alaila kaliia'ku ke ea o Aberahama, a make iho la ia i ka wa elemakule maikai; he kanaka kahiko loa ia, a ua nui na la ona, a ua huiia'ku ia me kona poe kanaka. ");
INSERT INTO haw1868_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Na kana mau keiki na Isaaka laua o Isemaela i kanu aku ia ia maloko o ke ana o Makepela, ma ka mahinaai a Eperona ke keiki a Zohara no ka Heta, ma ke alo o Mamere, ");
INSERT INTO haw1868_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Ma ka mahinaai a Aberahama i kuai ai me na mamo a Heta: ilaila i kanuia'i o Aberahama, a me Sara o kana wahine. ");
INSERT INTO haw1868_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Mahope mai o ka make ana o Aberahama, hoopomaikai mai la ke Akua ia Isaaka; a noho iho la o Isaaka ma ka luawai o Lahairoi. ");
INSERT INTO haw1868_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Eia ka mooolelo no Isemaela, no ke keikikane a Aberahama, o ka mea a Hagara no Aigupita ke kauwawahine a Sara i hanau ai na Aberahama: ");
INSERT INTO haw1868_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Eia hoi na inoa o na keikikane a Isemaela, ma ko lakou mau inoa, e like me ko lakou hanau ana: o Nebaiota kana hiapo; o Kedara, o Adebeela, o Mibesama, ");
INSERT INTO haw1868_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","O Misama, o Duma, o Masa. ");
INSERT INTO haw1868_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadara, o Tema, o Ietura, o Napisa, a o Kedema. ");
INSERT INTO haw1868_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Oia na keikikane a Isemaela, oia hoi ko lakou mau inoa; ma ko lakou mau kauhale, a ma ko lakou mau kulanahale; he umikumamalua mau alii e like me ko lakou mau lahuikanaka. ");
INSERT INTO haw1868_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Eia na makahiki o ke ola ana o Isemaela, hookahi haneri na makahiki me kanakolukumamahiku: ua kailiia'ku kona ea, a make iho la ia; a ua huiia aku ia me kona poe kanaka. ");
INSERT INTO haw1868_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Noho iho la lakou mai Havila a hiki i Sura, ma ke alo o Aigupita, i kou hele ana i Asuria; pela oia I noho ai ma ke alo o kona poe hoahanau a pau. ");
INSERT INTO haw1868_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Eia ka mooolelo no Isaaka no ke keiki a Aberahama: Na Aberahama o Isaaka: ");
INSERT INTO haw1868_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","He kanaha na makahiki o Isaaka i kona wa i lawe ai ia Rebeka ke kaikamahine a Betuela no Suria, a ke kaikuwahine o Labana no Suria, i wahine nana. ");
INSERT INTO haw1868_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Nonoi aku la o Isaaka ia Iehova no kana wahine, no ka mea, ua pa oia: a hoolohe mai la ke Akua ia ia, a hapai ae la kana wahine o Rebeka. ");
INSERT INTO haw1868_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Oni pu ae la na keiki iloko ona; i iho la ia, A i pela ia, i aha keia mea a'u? A hele aku la ia e ninau ia Iehova. ");
INSERT INTO haw1868_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","I mai la o Iehova ia ia, Elua no lahuikanaka iloko o kou opu, elua hoi poe kanaka e puka mai ana noloko mai o kou opu, a e oi aku ka ikaika o kekahi poe i ko kekahi poe; a e hookauwa aku ka hanau mua i ka hanau hope. ");
INSERT INTO haw1868_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","A hiki mai kona manawa e hanau ai, aia hoi, he mau mahoe iloko o kona opu. ");
INSERT INTO haw1868_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","A puka mai la ka mua, ua huluhulu, a ulaula, e like me ka aahu huluhulu, a kapa iho la lakou i kona inoa, o Esau. ");
INSERT INTO haw1868_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Mahope iho, puka mai la kona kaikaina, a paa aku la kona lima i ke kuekue wawae o Esau; a kapaia kona inoa, o Iakoba. He kanaono na makahiki o Isaaka i ko Rebeka manawa i hanau ai laua. ");
INSERT INTO haw1868_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Nui ae la ua mau keiki la: he kanaka akamai o Esau i ka hahai holoholona hihiu, he kanaka no ka nahelehele: aka, he kanaka noho malie o Iakoba, e noho ana ma na halelewa. ");
INSERT INTO haw1868_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Aloha aku la o Isaaka ia Esau, no ka mea, ai iho la ia i ka io o ua mea hihiu: a o Rebeka ka i aloha ia Iakoba. ");
INSERT INTO haw1868_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Hoolapalapa iho la o Iakoba i ka mea ai: a hoi mai la o Esau mai ka nahelehele mai, a ua nawaliwali ia. ");
INSERT INTO haw1868_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","I mai la o Esau ia Iakoba, Ke noi aku nei au ia oe, e ho mai na'u e ai ia mea ulaula; no ka mea, ua nawaliwali au: nolaila ua kapaia kona inoa o Edoma. ");
INSERT INTO haw1868_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","I aku la o Iakoba, E kuai kaua i keia la, i lilo mai ia'u kau pono o ka hanau mua. ");
INSERT INTO haw1868_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","I iho la o Esau, Eia wau ua kokoke e make, a heaha auanei ko'u pomaikai i keia pono o ka hanau mua? ");
INSERT INTO haw1868_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","I aku la o Iakoba E hoohiki oe na'u i keia la; a hoohiki aku la ia nana: a kuai lilo mai la ia i kana pono o ka hanau mua, na Iakoba. ");
INSERT INTO haw1868_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Alaila, haawi aku la o Iakoba na Esau i ka berena a me na papapa i hoolapalapaia; ai iho la ia a inu hoi, ku ae la ia a hele aku la i kona wahi i hele ai: pela o Esau i hoowahawaha'i i kana pono o ka hanau mua. ");
INSERT INTO haw1868_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","HE wi no ma ia aina, he okoa ka wi mua i hiki mai ai i ka wa ia Aberahama. A hele aku la o Isaaka io Abimeleka la, i ke alii o ko Pilisetia ma Gerara. ");
INSERT INTO haw1868_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Ikea aku la o Iehova e ia, i mai La, Mai hele oe ilalo i Aigupita, E noho iho ma ka aina a'u e hai aku ai ia oe: ");
INSERT INTO haw1868_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","E noho oe ma keia aina, a me oe pu no wau, a e hoopomaikai aku no wau ia oe: no ka mea, e haawi aku auanei au nou, a no kau poe mamo i keia mau aina a pau; a e hooko auanei au i ka hoohiki ana a'u i hoohiki ai i kou makuakane ia Aberahama. ");
INSERT INTO haw1868_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","A e hoonui aku au i kau poe mamo e like me na hoku o ka lani, a e haawi aku. no wau i keia mau aina a pau no kau poe mamo; a i kau mamo e hoopomaikaiia'i na lahuikanaka a pau o ka honua: ");
INSERT INTO haw1868_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","No ka mea, i hoolohe mai no o Aberahama i ko'u leo, a i malama hoi i ka'u mau kauoha, i ka'u mau olelo, a me ko'u mau kanawai. ");
INSERT INTO haw1868_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","A noho iho la o Isaaka ma Gerara. ");
INSERT INTO haw1868_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Ninau mai la na kanaka o ia wahi ia ia no kana wahine; i aku la ia, O ko'u kaikuwahine no ia: no ka mea, makau iho la ia i ka i aku, Oia ka'u wahine; o pepehi mai na kanaka o ia wahi ia'u no Rebeka; no ka mea, he maikai ia ke nanaia'ku. ");
INSERT INTO haw1868_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Ia ia i noho ai ma ia wahi a liuliu, nana mai la o Abimeleka o ke alii o ko Pilisetia, ma ka puka makani, ike mai la ia, aia hoi, o Isaaka e lealea ana me kana wahine, me Rebeka. ");
INSERT INTO haw1868_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Hea mai la o Abimeleka ia Isaaka, i mai la, Aia hoi, he oiaio no, o kau wahine no ia; a pehea hoi oe i olelo mai ai, O ko'u kaikuwahine ia? I aku la o Isaaka ia ia, No ka mea, i iho la au, E make paha uanei au nona. ");
INSERT INTO haw1868_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","I mai la o Abimeleka, Heaha keia au i hana mai ai ia makou? Ina i moe wale paha kekahi o na kanaka me kau wahine, ina ua hooili mai oe i ka hala maluna o makou. ");
INSERT INTO haw1868_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Kauoha aku o Abimeleka i na kanaka a pau, i ka i ana, O ka mea hoopa aku i keia kanaka, a i kana wahine paha, he oiaio e make ia. ");
INSERT INTO haw1868_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Lulu hua iho la o Isaaka ma ia aina, a loaa pahaneri mai la ia ia ia makahiki: a hoopomaikai mai la o Iehova ia ia. ");
INSERT INTO haw1868_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Lilo ae la ua kanaka la i mea nui, mahuahua ae la ia, ulu ae la, a lilo i kanaka nui loa: ");
INSERT INTO haw1868_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","No ka mea, nana na hipa, a me na bipi, a me na kanaka he nui loa: a huahuwa mai la ko Pilisetia ia ia. ");
INSERT INTO haw1868_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","A o na punawai a pau i eliia e na kauwa a kona makuakane, i ka wa ia Aberahama, huna ae la ko Pilisetia ia mau mea i ka hoopiha i ka lepo. ");
INSERT INTO haw1868_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Olelo mai la o Abimeleka ia Isaaka, E hele aku oe mai o makou aku, no ka mea, ua nui loa aku kau, i ka makou. ");
INSERT INTO haw1868_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Hele aku la o Isaaka, a kukulu iho la i kona halelewa ma ke awawa o Gerara, a noho iho la ilaila. ");
INSERT INTO haw1868_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Eli hou iho la o Isaaka i na luawai a lakou i eli iho ai i ka wa ia Aberahama o kona makuakane; no ka mea, ua huna iho ko Pilisetia ia mau mea mahope o ka make ana o Aberahama: a kapa iho la ia i ko lakou mau inoa, ma na inoa a kona makuakane i kapa iho ai. ");
INSERT INTO haw1868_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Eli iho la na kanwa a Isaaka ma ke awawa, a loaa iho la ka punawai ilaila, he wai mau. ");
INSERT INTO haw1868_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Hakaka mai la na kahu bipi no Gerara me na kahu bipi o Isaaka, i ka i ana mai, No makou ia wai: a kapa iho la ia i ka inoa o ua luawai la, o Eseka, no ko lakou hakaka ana mai me ia. ");
INSERT INTO haw1868_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Eli iho la hoi lakou i ka luawai hou, a hakaka mai no hoi lakou no ia mea: a kapa iho la oia i kona inoa, o Sitena. ");
INSERT INTO haw1868_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Neenee aku la ia mai ia wahi aku, a eli iho la i ka luawai hou; aole no lakou i hakaka mai no ia mea: a kapa iho la oia i kona inoa, o i Rehobota: i iho la ia, ano hoi, ua haawi mai o Iehova i kahi akea no kakou; a e hoohua auanei kakou ma ka aina. ");
INSERT INTO haw1868_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","A mahope aku, pii aku la ia malaila aku a Beereseba. ");
INSERT INTO haw1868_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Ikea ae la o Iehova e ia ia po iho, i mai la, Owau no ke Akua o Aberahama o kou makuakane: mai makau oe, owau no me oe, a e hoopomaikai no au ia oe a e hoonui hoi i kau poe mamo no ka'u kauwa, no Aberahama. ");
INSERT INTO haw1868_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Hana iho la ia i kuahu malaila, a kahea aku la ia i ka inoa o Iehova, a kukulu iho la i kona halelewa ilaila: ilaila hoi na kauwa a Isaaka i eli iho ai i ka luawai. ");
INSERT INTO haw1868_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Alaila, hele mai la io na la o Abimeleka mai Gerara mai, oia me Ahuzata kekahi hoalauna ona, a me Pikola ka luna koa o kona poe kaua. ");
INSERT INTO haw1868_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","I aku la o Isaaka ia lakou, Heaha ka oukou i hele mai ai io'u nei, no ka mea, ke inaina mai nei oukou ia'u, a ua hookuke mai nei oukou ia'u mai o oukou aku. ");
INSERT INTO haw1868_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Olelo mai la lakou, Ua ike io makou, aia no o Iehova me oe: olelo ae la makou, I hoohiki ana mawaena o kakou, o makou nei, a on la, a e hoopaa makou i berita me oe; ");
INSERT INTO haw1868_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","I hana ino ole mai oe ia makou, me makou i hoopa ole aku ai ia oe, o ka maikai wale no ka makou i hana aku ai ia oe, a ua hoihoi aku ia oe me ka maluhia: o oe io no ka mea i hoopomaikaiia e Iehova. ");
INSERT INTO haw1868_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Hana iho la ia i ahaaina na lakou, ai iho la lakou a inu hoi. ");
INSERT INTO haw1868_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Ala ae la lakou i kakahiaka nui, a hoohiki iho la laua, i kekahi i kekahi: hookuu aku la o Isaaka ia lakou, a hoi hou aku la lakou mai ona aku la me ke kuikahi. ");
INSERT INTO haw1868_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Ia la hookahi no, hele mai la na kauwa a Isaaka, a hai mai la ia ia no ka luawai a lakou i eli iho ai, i mai la ia ia, Ua loaa ia makou ka wai. ");
INSERT INTO haw1868_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Kapa iho la oia ia wahi, o Seba: nolaila, o Beereseba ka inoa o ia kulanakauhale a hiki i keia la. ");
INSERT INTO haw1868_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Hookahi kanaha na makahiki o Esau ia ia i lawe ai ia Iehudita ke kaikamahine a Beeri no ka Heta, a me Basemata ke kaikamahine a Elona no ka Heta, i mau wahine nana: ");
INSERT INTO haw1868_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","He mau mea ehaeha laua no ka naau o Isaaka a me Rebeka. ");
INSERT INTO haw1868_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","I KO Isaaka manawa i elemakule ai, a powehiwehi ai kona mau maka, a hiki ole ia ia ke ike aku; hea aku la oia ia Esau i kana keiki mua, i aku la ia ia, E kuu keiki: i mai la kela, Eia wau. ");
INSERT INTO haw1868_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","I aku la oia, Eia hoi, ua elemakule au, aole hoi au i ike i kuu la e make ai: ");
INSERT INTO haw1868_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Ano hoi, e lawe oe i kau mau mea pana, i kau aapua a me kau kakaka, e hele aku oe i ka nahelehele e imi i kahi io na'u; ");
INSERT INTO haw1868_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","A e hana oe i mea ono na'u i ka mea hoi a'u i ono ai, a e lawe mai oe i o'u nei, i paina au, a i hoomaikai aku kuu uhane ia oe mamua o kuu make ana. ");
INSERT INTO haw1868_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Lohe ae la o Rebeka i ka wa a Isaaka i olelo aku ai ia Esau i kana keiki A hele aku o Esau i ka nahelehele e imi aku a e lawe mai i ka io o ka holoholona hihiu. ");
INSERT INTO haw1868_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Olelo aku la o Rebeka ia Iakoba i kana keiki, i aku la, Aia hoi, ua lohe iho nei au i kou makuakane e olelo ana i kou kaikuaana ia Esau, i ka i ana ae, ");
INSERT INTO haw1868_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","E lawe mai oe io'u nei i io holoholona hihiu, a e hana i ka mea ono na'u, i paina au, a i hoomaikai hoi au ia oe imua o Iehova mamua o kuu make ana. ");
INSERT INTO haw1868_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Ano hoi, e kuu keiki, e hoolohe mai oe i ko'u leo, ma ka mea a'u e kauoha aku nei ia oe. ");
INSERT INTO haw1868_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","E hele koke aku oe i ka poe holoholona, a e lawe mai i na keiki kao maikai i elua; a na'u no e hana i ka mea ono na kou makuakane, i kana mea i ono ai: ");
INSERT INTO haw1868_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","A e halihali aku oe ia mea i kou makuakane, i ai iho ia, a i hoomaikai mai oia ia oe mamua o kona make ana. ");
INSERT INTO haw1868_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Olelo mai la o Iakoba ia Rebeka i kona makuwahine, Aia hoi, he kanaka huluhulu o Esau kuu kai kuaana, a he kanaka pahee no wau: ");
INSERT INTO haw1868_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","A e hana mai paha kuu makuakane ia'u, a e ikea auanei au e ia he mea hoopunipuni; a e hooili mai au i ka hoinoia maluna iho o'u, aole ka hoomaikaiia, ");
INSERT INTO haw1868_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","I aku la kona makuwahine ia ia, Maluna iho o'u kou hoinoia, e kuu keiki; e hoolohe wale mai oe i ko'u leo, e kii aku, a e lawe mai io'u nei. ");
INSERT INTO haw1868_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Kii aku la ia, a lawe mai la ia mau mea i kona makuwahine: a na kona makuwahine i hana i ka mea ono, a kona makuakane i ono ai. ");
INSERT INTO haw1868_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Lawe ae la o Rebeka i ka aahu maikai o kana keiki mua o Esau, i ka mea e waiho ana iloko o ka hale me ia, a hoaahu iho la ia Iakoba i kana keiki muli iho ia mea. ");
INSERT INTO haw1868_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","A hoopili aku la o Rebeka i na ili o na keiki kao maluna o kona mau lima, a me ka pahee o kona a-i. ");
INSERT INTO haw1868_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Haawi aku la ia i ka mea ono, a me ka berena ana i hoomakaukau ai, iloko o ka lima o Iakoba o kana keiki. ");
INSERT INTO haw1868_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","A hele aku la ia i kona makuakane, i aku la, E kuu makuakane: i mai la kela, Eia no wau; owai la oe, e kuu keiki? ");
INSERT INTO haw1868_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","I aku la o Iakoba i kona makuakane, Owau no o Esau, o kau makahiapo; ua hana iho nei au i kau mea i kauoha mai ai; ke noi aku nei au, e ala mai oe, e noho a e ai iho i ka'u io o ka mea hihiu, i hoomaikai mai kou uhane ia'u. ");
INSERT INTO haw1868_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","I mai la o Isaaka i kana keiki, Pehea ka emoole o ka loaa ana o ia mea ia oe, e kuu keiki? I aku la kela, No ka mea, na Iehova na kou Akua i hoohalawai ia mea me au. ");
INSERT INTO haw1868_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","I mai la o Isaaka ia Iakoba, Ke noi aku nei au ia oe, e neenee mai a kokoke, i hana aku au ia oe, e kuu keiki, i ike au o ka'u keiki o Esau paha oe, aole paha. ");
INSERT INTO haw1868_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Neenee aku la o Iakoba io Isaaka la i kona makuakane: a hana mai la oia ia ia, i mai la, O ka leo, ka leo no o Iakoba, aka, o na lima, na lima no o Esau. ");
INSERT INTO haw1868_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Aole no i ikea oia, no ka mea, ua huluhulu kona mau lima, e like me na lima o kona kaikuaana, o Esau: a hoomaikai mai oia ia ia. ");
INSERT INTO haw1868_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Ninau mai la oia ia ia, O oe io no anei o ka'u keiki o Esau? I aku la kela, Owau no. ");
INSERT INTO haw1868_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","I mai la oia, E lawe mai ia mea a kokoke ia'u, a e ai iho no wau i ka io mea hihiu a kuu keiki, i hoomaikai aku kuu uhane ia oe, Lawe aku la o Iakoba a kokoke, a ai iho la kela: lawe aku la hoi oia i ka waina, a inu iho la kela. ");
INSERT INTO haw1868_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Olelo mai la kona makuakane o Isaaka ia ia, E hele mai oe a honi ia'u, e kuu keiki. ");
INSERT INTO haw1868_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Hele aku la o Iakoba, a honi ae la ia ia: honi iho la o Isaaka i ke ala o kona aahu, hoomaikai mai la ia ia, i mai la, Aia, o ke ala o kuu keiki, ua like me ke ala o ka mahinaai a Iehova i hoomaikai ai: ");
INSERT INTO haw1868_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","E haawi mai ke Akua ia oe i ka hau no ka lani mai, me ka momona o ka honua, a me ka palaoa a me ka waina he nui: ");
INSERT INTO haw1868_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","E hookauwa mai na kanaka nau, a e moe iho na lahuikanaka imua ou, o lilo oe i haku maluna o kou poe hoahanau, a e moe iho na keiki o kou makuwahine imua ou: e hoinoia'ku na mea a pau e hoino mai ia oe, a e hoopomaikaiia'ku ka mea hoomaikai ia oe. ");
INSERT INTO haw1868_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","A oki ae la ka hoomaikai ana mai a Isaaka ia Iakoba, aneane hoi ole mai o Iakoba mai ke alo mai o Isaaka o kona makuakane, puka mai la hoi o Esau o kona kaikuaana mai kona imi mea hihiu ana. ");
INSERT INTO haw1868_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Hana no hoi oia i ka mea ono, a lawe mai hoi ia mea i kona makuakane, i aku la ia i kona makuakane, E ala mai oe, e kuu makuakane, a e ai iho i ka io mea hihia a kana keiki, i hoomaikai mai kou uhane ia'u. ");
INSERT INTO haw1868_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Ninau mai la o Isaaka o kona makuakane ia ia, Owai oe? I aku la kela, Owau no o kau keiki, o kau makahiapo, o Esau. ");
INSERT INTO haw1868_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Haalulu nui loa iho la o Isaaka, i mai la, Owai? auhea hoi ka mea i kii i ka io mea hihiu, a i lawe mai hoi io'u nei, a ua ai iho nei au a pau, mamua o kou hiki ana mai, a ua hoomaikai au ia ia? Oiaio, oia ke hoomaikaiia. ");
INSERT INTO haw1868_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","A lohe ae la o Esau i ka olelo a kona makuakane, uwe iho la ia me ka uwe nui loa, i aku la ia i kona makuakane, E hoomaikai mai ia'u, ia'u hoi, e kuu makuakane, ");
INSERT INTO haw1868_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","I mai la kela, Ua hele mai nei kou kaikaina me ka maalea, a ua lawe aku i kou hoomaikaiia, ");
INSERT INTO haw1868_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","I aku la oia, Aole anei i pono ke kapa ana ia ia o Iakoba? no ka mea, eia ka lua o kona kaili ana i ko'u pono: kaili aku la oia i ko ka hanaumua pono o'u; eia hoi, ano, ua kaili ae la oia i ko'u hoomaikaiia. I aku la hoi o Esau, Aole anei oe i malama no'u kekahi hoomaikai ana? ");
INSERT INTO haw1868_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Olelo mai la o Isaaka ia Esau, Aia hoi, ua hoolilo aku au ia ia i haku nou, a ua haawi aku no wau i kona poe hoahanau a pau i poe kauwa nana; ua malama aku hoi au ia ia i ka palaoa a me ka waina: a heaha ka'u e hana aku ai nau, e kuu keiki? ");
INSERT INTO haw1868_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","I aku la o Esau i kona makuakane, Hookahi wale no anei au hoomaikai ana, e kuu makuakane? e hoomaikai mai oe ia'u hoi, e kuu makuakane. Hookiekie ae la o Esau i kona leo, a uwe iho la. ");
INSERT INTO haw1868_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Olelo mai la o Isaaka, kona makuakane, i mai la ia ia, Aia hoi, ma ka aina momona kou noho ana, a ma kahi o ka hau o ka lani mai luna iho. ");
INSERT INTO haw1868_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","I kau pahikaua e ola auanei oe, a e hookauwa aku oe na kou kaikaina: a i ka manawa e loaa'i ia oe ke alii ana, alaila e haihai iho oe i kana anamo ma kou a-i. ");
INSERT INTO haw1868_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Inaina aku la o Esau ia Iakoba, no ka hoomaikai ana a kona makuakane i hoomaikai aku ai ia ia: i iho la o Esau iloko o kona naau, Ua kokoke mai na la e kanikau ai i kuu makuakane; alaila au e pepehi ai i kuu kaikaina ia Iakoba. ");
INSERT INTO haw1868_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Ua haiia'ku keia olelo ana a Esau ia Rebeka: hoouna aku la ia e hea ia Iakoba i kana keiki muli iho, i aku la ia ia, Aia hoi, o kou kaikuaana o Esau, e hooluolu ana oia ia ia iho nou, e pepehi iho ia oe. ");
INSERT INTO haw1868_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Ano hoi, e kuu keiki, e hoolohe mai oe i kuu lee; e ku ae oe, e holo aku io Labana la, i kuu kaikunane ma Harana: ");
INSERT INTO haw1868_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","E noho me ia i kekahi mau la, a huli ae ka inaina o kou kaikuaana mai ou aku la; ");
INSERT INTO haw1868_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","A huli ae ka inaina o kou kaikuaana mai ou aku la, a poina ia ia kau mea i hana aku ai ia ia: alaila e hoouna aku no wau e hoihoi mai ia oe: no ke aha la e hooneleia mai au ia olua a elua i ka la hookahi? ");
INSERT INTO haw1868_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Olelo aku la o Rebeka ia Isaaka, Ua pauaho no wau i kuu ola ana, no na kaikamahine a ka Heta: ina e lawe o Iakoba i kekahi kaikamahine a ka Heta i wahine nana, e like me na kaikamahine o ka aina, pehea la wau e pono ai i kuu ola aua? ");
INSERT INTO haw1868_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","HEA aku la o Isaaka ia Iakoba, hoomaikai aku la ia ia, kauoha aku la ia ia, i aku la, Mai lawe oe i wahine nau no na kaikamahine a ko Kanaana, ");
INSERT INTO haw1868_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","E ku ae, e hele aku oe i Padanarama, i ka hale o Betuela o ka makuakane o kou makuwahine; a e lawe oe i wahine nau nolaila, no na kaikamahine a Labana a ke kaikunane o kou makuwahine. ");
INSERT INTO haw1868_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","E hoomaikai mai ke Akua mana ia oe, e hoohua mai kela ia oe, e hoomahuahua hoi ia oe, i lilo oe i poe kanaka he nui: ");
INSERT INTO haw1868_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","E haawi mai hoi oia nou i ka pomaikai o Aberahama, nou, a no kau poe mamo me oe; i hooiliia nou ka aina au e noho malihini nei, ka mea a ke Akua i haawi mai ai no Aberahama. ");
INSERT INTO haw1868_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Hoouna aku la o Isaaka ia Iakoba: a hele aku la ia i Padauarama io Labana la, i ke keiki a Betuela no Suria, i ke kaikunane o Rebeka, o ka makuwahine o Iakoba laua o Esau. ");
INSERT INTO haw1868_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","A ike iho o Esau, ua hoomaikai mai o Isaaka ia Iakoba, a ua hoouna aku ia ia e hele i Padanarama, e lawe i wahine nana mai ia wahi mai; a i kana hoomaikai ana ia ia, kauoha aku la ia, i ka i ana, Mai lawe oe i wahine nau no na kaikamahine a ko Kanaana; ");
INSERT INTO haw1868_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","A ua hoolohe mai o Iakoba i kona makuakane, a me kona makuwahine, a ua hala aku la i Padanarama; ");
INSERT INTO haw1868_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","A ike iho la o Esau, aole i oluolu o Isaaka o kona makuakane i na kaikamahine a ko Kanaana; ");
INSERT INTO haw1868_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Alaila, hele aku la o Esau io Isemaela la, a hui mai la me kana mau wahine, ia Mahalata i ke kaikamahine a Isemaela a ke keiki a Aberahama, oia ke kaikuwahine o Nebaiota, i wahine nana. ");
INSERT INTO haw1868_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Hele aku la o Iakoba mai Beereseba aku, i kona hele ana i Harana. ");
INSERT INTO haw1868_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","A hiki aku la ia i kau wahi, a noho iho la ilaila i ka po; no ka mea, ua napoo ka la: lawe ae la ia i kekahi o na pohaku o ia wahi i uluna nona, a moe iho la ilaila. ");
INSERT INTO haw1868_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Moe iho la ia i ka uhane; aia hoi, ku mai la kekahi ala haka maluna o ka honua, a hiki aku la kona welau i ka lani: aia hoi, ua ikea na anela o ke Akua i ka pii ana ae, a i ka iho ana mai maluna o ka haka. ");
INSERT INTO haw1868_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Aia hoi, ku mai la o Iehova maluna ae o ka haka, i mai la, Owau no Iehova ke Akua o Aberahama o kou kupunakane, a ke Akua o Isaaka: e haawi aku no au i ka aina au e moe iho ai nou, a no kau poe mamo; ");
INSERT INTO haw1868_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","A e like auanei ka nui o kau poe mamo me ka lepo o ka honua, a e palahalaha ana ae oe i ke komohana, i ka hikina, i ke kukulu akau, a i ke kukulu hema: ia oe no a i kau poe mamo e hoopomaikaiia'i na ohana a pau o ka honua. ");
INSERT INTO haw1868_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Aia hoi, me oe no wau, a e malama auanei ia oe i na wahi a pau au e hele ai, a e hoihoi mai no wau ia oe i keia aina; no ka mea, aole au e haalele ia oe, a pau i ka hanaia e au ka mea a'u i olelo aku ai ia oe. ");
INSERT INTO haw1868_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Ala ae la o Iakoba mai kona hiamoe ana, i iho la ia. He oiaio, maanei no o Iehova, aole nae au i ike. ");
INSERT INTO haw1868_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Eehia iho la ia, i iho la, He wahi eehia keia! o ka hale wale no keia no ke Akua, o ka ipuka hoi keia o ka lani. ");
INSERT INTO haw1868_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Ala ae la o Iakoba i kakahiaka nui, lalau aku la ia i ka pohaku ana i uluna ai, hooku ae la i eho, a ninini iho la i ka aila maluna o kona welau. ");
INSERT INTO haw1868_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Kapa iho la ia i ka inoa o ia wahi, o i Betela: o Luza ka inoa mamua o ua kulanakauhale la. ");
INSERT INTO haw1868_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Hoohiki aku la o Iakoba i ka hoohiki ana, i aku la, Ina e noho pu ke Akua me au, a e malama mai ia'u ma keia ala a'u e hele nei, a e haawi mai i ai na'u e ai ai, a i kapa hoi e aahu ai, ");
INSERT INTO haw1868_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","A hoi hou mai au i ka hale o ko'u makuakane me ka maluhia; alaila o Iehova no ko'u Akua: ");
INSERT INTO haw1868_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","A o keia pohaku a'u i hooku ae nei i kukulu, a e lilo auanei ia i hale no ke Akua: a e haawi io aku no wau nou i ka hapaumi o na mea a pau au e haawi mai ai ia'u. ");
INSERT INTO haw1868_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","A LAILA, hele aku la o Iakoba i. kona hele ana, a hiki aku la i ka aina o na kanaka o ka hikina. ");
INSERT INTO haw1868_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Nana aku la ia, aia hoi, he luawai ma ke kula, a me na ohana hipa ekolu e moe ana ilaila: no ka mea, ua hoohainuia na ohana holoholona i ka wai o ua luawai la: a aia maluna o ka waha o ka luawai he pohaku nui. ");
INSERT INTO haw1868_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Ilaila i hoakoakoaia'i na ohana holoholona a pau: olokaa ae la lakou i ka pohaku mai ka waha ae o ka luawai, a hoohainu iho la i na hipa; a kau hou iho la i ka pohaku maluna o ka waha o ka luawai, ma kona wahi. ");
INSERT INTO haw1868_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","I aku la o Iakoba ia lakou, E kuu mau hoahanau, nohea oukou? I mai la lakou, No Harana makou. ");
INSERT INTO haw1868_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","I aku la ia ia lakou, Ua ike anei oukou ia Labana, ka moopuna a Nahora? I mai la lakou, Ua ike no makou. ");
INSERT INTO haw1868_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","I aku la ia ia lakou, E ola ana anei oia? I mai la lakou, E ola ana no, aia hoi, ke hele mai la o Rahela, o kana kaikamahine me ka pua hipa. ");
INSERT INTO haw1868_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","I aku la ia, Aia hoi, he la okoa keia; aole i hiki ka manawa e houluulu ai i na bipi: e hoohainu oukou i na hipa, a hele e hanai. ");
INSERT INTO haw1868_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","I mai la lakou, Aole makou e hiki, a pau na ohana hipa i ka houluuluia, a olokaa ae lakou i ka pohaku, mai ka waha mai o ka luawai; alaila makou e hoohainu i na hipa. ");
INSERT INTO haw1868_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Ia ia i olelo ai me lakou, hiki mai la o Rahela me na hipa a kona makuakane: no ka mea, nana lakou i malama. ");
INSERT INTO haw1868_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","A ike aku la o Iakoba ia Rahela, ke kaikamahine a Labana, o ke kaikunane o kona makuwahine, a me ka poe hipa a Labana, o ke kaikunane o kona makuwahine, neenee aku la o Iakoba, olokaa ae la ia i ka pohaku mai ka waha ae o ka luawai, a hoohainu iho la i ka poe hipa a Labana, o ke kaikunane o kona makuwahine. ");
INSERT INTO haw1868_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Honi aku la o Iakoba ia Rahela, hookiekie ae la ia i kona leo, a uwe iho la. ");
INSERT INTO haw1868_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Hai aku la o Iakoba ia Rahela, he hoahanau ia no kona makuakane, a he keiki na Rebeka: holo aku la kela, a hai aku la i kona makuakane. ");
INSERT INTO haw1868_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","A lohe ae la o Labana i ka olelo no Iakoba no ke keikikane a kona kaikuwahine, holo mai la ia e halawai me ia, apo mai la ia ia, honi ae la, a kai aku la ia ia i kona hale. Hai aku la oia ia Labana ia mau mea a pau. ");
INSERT INTO haw1868_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Olelo mai la o Labana ia ia, He oiaio, o oe no kuu iwi, a me kuu io. A noho pu iho la oia me ia, hookahi malama. ");
INSERT INTO haw1868_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Olelo mai la o Labana ia Iakoba, E hookauwa wale anei oe na'u, no kou pili hoahanau ana ia'u? e hai mai oe ia'u i kau uku. ");
INSERT INTO haw1868_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Elua mau kaikamahine a Labana, o Lea ka inoa o ka mua, a o Rahela ka inoa o ka muli iho. ");
INSERT INTO haw1868_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","He makawai ko Lea; aka, ua maikai o Rahela ke nana aku, a ua maikai kona helehelena. ");
INSERT INTO haw1868_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Aloha aku la o Iakoba ia Rahela: i aku la ia, E hooikaika aku no au i kau hana i na makahiki ehiku no Rahela, no kau kaikamahine muli iho. ");
INSERT INTO haw1868_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","I mai la o Labana, E aho no'u ke haawi aku ia ia nau, aole na ke kanaka e ae; e noho pu oe me au. ");
INSERT INTO haw1868_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Hooikaika aku la o Iakoba i na makahiki ehiku no Rahela; a he mau la uuku wale no ia i kona manao, no kona aloha ia ia. ");
INSERT INTO haw1868_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","I aku la o Iakoba ia Labana, E haawi mai oe i ka'u wahine, i komo ai au iloko io na la, no ka mea, ua hala ae nei ko'u mau la. ");
INSERT INTO haw1868_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Houluulu ae la o Labana i na kanaka a pau o ia wahi, a hana iho la i ka ahaaina, ");
INSERT INTO haw1868_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","A ahiahi iho la, lalau aku la ia i kana kaikamahine ia Lea, a lawe mai la ia ia io Iakoba la, a komo aku la ia io na la. ");
INSERT INTO haw1868_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Haawi aku la o Labana ia Zilepa i kona kaikamahine i kauwawahine na kana kaikamahine na Lea. ");
INSERT INTO haw1868_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","A ao ae la, aia hoi, o Lea ka ia: i aku la o Iakoba ia Labana, Heaha keia mea au i hana mai ai ia'u? aole anei o Rahela ka'u i hooikaika aku ai nau? No ke aha hoi oe i hoopunipuni mai ai ia'u? ");
INSERT INTO haw1868_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","I mai la o Labana, Aole pela e pono ke hana ma ko makou aina, ke haawi e aku i ka hanau hope mamua o ka hanau mua. ");
INSERT INTO haw1868_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","E hoopau oe i ko ia nei hebedoma, alaila e haawi hoi makou ia Rahela nau, no ka hooikaika ana au e hooikaika ai me au, i na makahiki hou aku i ehiku. ");
INSERT INTO haw1868_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Pela no o Iakoba i hana aku ai, a hoopau ae la i ko ia la hebedoma: a haawi aku la hoi oia ia Rahela i kana kaikamahine i wahine nana. ");
INSERT INTO haw1868_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Haawi mai la o Labana ia Bileha i kona kaikamahine, i kauwawahine na Rahela, na kana kaikamahine. ");
INSERT INTO haw1868_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Komo aku la hoi oia io Rahela la, a oi aku la kona aloha ia Rahela mamua o kona aloha ia Lea; a hooikaika aku la ia me Labana i na makahiki hou aku i ehiku. ");
INSERT INTO haw1868_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","A ike iho la o Iehova, ua hoowahawahaia o Lea, hoohua iho la ia i kona opu: aka, ua pa o Rahela. ");
INSERT INTO haw1868_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Hapai iho la o Lea, a hanau mai la he keikikane, a kapa iho la ia i kona inoa o I Reubena: no ka mea, i mai la ia, He oiaio, ua nana mai o Iehova i kuu popilikia; ano hoi, e aloha mai auanei ka'u kane ia'u. ");
INSERT INTO haw1868_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Hapai hou iho la ia, a hanau mai la he keikikane; i mai la, No ka mea, ua lohe o Iehova i kuu hoowahawahaia, nolaila, ua haawi mai hoi oia i keia keikikane: kapa iho la ia i kona inoa, o I Simeona. ");
INSERT INTO haw1868_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Hapai hou iho la ia, a hanau mai la, he keikikane; i mai la, I keia manawa no, e hoopiliia mai auanei ka'u kane ia'u; no ka mea, ua hanau no wau i na keikikane ekolu nana: no ia mea i kapaia'i kona inoa, o I Levi. ");
INSERT INTO haw1868_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Hapai hou iho la ia, a hanau mai la he keikikane: i mai la ia, Ano no, e hoolea aku wau ia Iehova; nolaila, kapa iho la ia i kona inoa, o I Iuda; a oki iho la kona hanau ana. ");
INSERT INTO haw1868_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","A IKE ae la o Rahela, aole ia i hanau i na keiki na Iakoba, huahuwa aku la o Rahela i kona kaikaana; i mai la ia ia Iakoba, E haawi, mai oe i keiki na'u, o make au. ");
INSERT INTO haw1868_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Hoaaia ka inaina o Iakoba ia Rahela; i aku la ia, Owau no anei ka panihakahaka no ke Akua, nana i aua mai ka hua o kou opu? ");
INSERT INTO haw1868_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","I mai la ia, Aia hoi kuu kauwawahine o Bileha, e komo aku oe io na la; a e hanau mai auanei ia maluna o kuu mau kuli, i keiki ai hoi au ma ona la. ");
INSERT INTO haw1868_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Haawi mai la oia ia Bileha i kana kauwawahine, i wahine nana: a komo aku la o Iakoba io na la. ");
INSERT INTO haw1868_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Hapai iho la o Bileha, a hanau mai la, he keikikane na Iakoba. ");
INSERT INTO haw1868_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","I mai la o Rahela, Ua hoapono mai ke Akua ia'u, ua hoolohe mai hoi ia i ko'u leo, a ua haawi mai ia i keiki na'u: nolaila, kapa iho la ia i kona inoa, o I Dana. ");
INSERT INTO haw1868_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Hapai hou iho la o Bileha ke kauwawahine a Rahela, a hanau mai la, o ka lua ia o kana keikikane na Iakoba. ");
INSERT INTO haw1868_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","I mai la o Rahela, Me na hakoko nui ka'u i hakoko pu ai me kuu kaikuaana, a ua lanakila au: a kapa iho la ia i kona inoa, o I Napetali. ");
INSERT INTO haw1868_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","A ike iho la o Lea, ua oki kona hanau ana, lalau aku la ia ia Zilepa, i kana kauwawahine, a haawi aku la ia ia i wahine na Iakoba. ");
INSERT INTO haw1868_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","A hanau mai la o Zilepa ke kauwawahine a Lea i keikikane na Iakoba. ");
INSERT INTO haw1868_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","I mai la o Lea, Pomaikai; a kapa iho la ia i kona inoa, o I Gada, ");
INSERT INTO haw1868_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Hanau mai la hoi o Zilepa o ke kauwawahine a Lea i ka lua o ke keikikane na Iakoba. ");
INSERT INTO haw1868_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","I mai la o Lea, Pomaikai no wau, no ka mea, e hoomaikai mai auanei na kaikamahine ia'u: a kapa iho la i kona inoa o I Asera. ");
INSERT INTO haw1868_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Hele aku la o Reubena i na la o ka ohi palaoa ana, a loaa ia ia ma ke kula na hua dudaima, a lawe mai la ia mau mea i kona makuwahine ia Lea. Alaila, i mai la o Rahela ia Lea, Ke noi aku nei au ia oe, o haawi mai na'u i kekahi mau dudaima a kau keikikane. ");
INSERT INTO haw1868_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","I aku la kela ia ia, He mea uuku anei kou lawe ana aku i ka'u kane? a manao anei hoi oe o lawe aku i na dudaima a kuu keiki? I mai la o Rahela, Nolaila, e moe pu ia me oe i neia po no na dudaima a kau keiki. ");
INSERT INTO haw1868_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","I ke ahiahi, hoi mai la o Iakoba mai ke kula mai, a hele aku la o Lea e halawai me ia, i aku la, E komo mai oe io'u nei; no ka mea, he oiaio no, ua hoolimalima au ia oe me na dudaima a ka'u keiki. A moe pu iho la oia me ia ia po. ");
INSERT INTO haw1868_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Hoolohe mai la ke Akua ia Lea a hapai iho la o Lea, a hanau mai la na Iakoba i ka lima o kana keikikane. ");
INSERT INTO haw1868_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","I mai la o Lea, Ua haawi mai la ke Akua i ka'u uku, no kuu haawi ana aku i ka'u kauwawahine na kuu kane: a kapa iho la ia i kona inoa o I Isakara. ");
INSERT INTO haw1868_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Hapai hoa iho la o Lea, a hanau mai na Iakoba i ke ono o kana keikikane. ");
INSERT INTO haw1868_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","I mai la o Lea, Ua haawi mai ke Akua ia'u i ka haawina maikai; ano la, e noho pu auanei ka'u kane me a'u, no ka mea, ua hanau no au i na keikikane eono nana: a kapa iho la ia i kona inoa o I Zebuluna. ");
INSERT INTO haw1868_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","A mahope iho, hanau mai la ia i kaikamahine, a kapa iho la i kona inoa o I Dina. ");
INSERT INTO haw1868_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Hoomanao mai la ke Akua ia Rahela, a hoolohe mai la ke Akua ia ia, a hoohua mai la i kona opu. ");
INSERT INTO haw1868_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Hapai iho la oia, a hanau mai la he keikikane: i mai la ia, Ua lawe aku no ke Akua i kuu hoinoia. ");
INSERT INTO haw1868_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Kapa iho la ia i kona inoa o I Iosepa; i iho la, E haawi mai ke Akua i keikikane hou na'u. ");
INSERT INTO haw1868_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","I ka manawa a Rahela i hanau ai ia Iosepa, i aku la o Iakoba ia Labana, E hoihoi aku oe ia'u, i hele aku ai au i ko'u wahi, a i ko'u aina. ");
INSERT INTO haw1868_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","E haawi mai oe i ka'u mau wahine, a me ka'u mau kamalii, i na mea a'u i hooikaika aku ai nau, a e kuu ae oe ia'u e hele: no ka mea, ua ike oe i ka hana au i hana aku ai nau. ");
INSERT INTO haw1868_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","I mai la o Labana ia ia, Ke noi aku nei au ia oe, ina i loaa ia'u ke aloha imua ou, e noho; ua ike no wau ma ka hoao ana, nou no ka Iehova i hoopomaikai mai ai ia'u. ");
INSERT INTO haw1868_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","I mai la hoi oia, E hai mai oe i kau uku, a e haawi aku no wau. ");
INSERT INTO haw1868_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","I aku la kela ia Labana, Ua ike no oe i ko'u hooikaika ana aku nau, a me ka pono o kau poe holoholona. ");
INSERT INTO haw1868_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","No ka mea, he mea uuku kau mamua o ko'u hiki ana mai, a hoomahuahuaia'e ia he lehulehu loa: a ua hoopomaikai mai o Iehova ia oe, mahope mai o kuu hele ana mai: ano hoi, ahea la au e hoolako ai i ko ka hale o'u kekahi? ");
INSERT INTO haw1868_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","I mai la oia, Heaha ka'u e uku aku ai ia oe? I aku la o Iakoba, Aole oe e uku mai ia'u i kekahi mea: ina paha penei oe e hana mai ai ia'u, alaila au e hana hou, a e malama hoi i kau poe holoholona: ");
INSERT INTO haw1868_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","E hele ae au iwaena o kau poe holoholona a pau i neia la, a e hookaawale aku i na holoholona kikokiko a onionio, a me na mea eleele a pau o ka poe hipa, a me na mea onionio a kikokiko o ka poe kao: a oia ka'u uku. ");
INSERT INTO haw1868_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Pela e hoapono aku ai ho'u pono ia'u i ka wa mahope, i ka wa e lilo mai ai ia i uku na'u imua o kou mau maka: o na mea a pau o ka poe kao me au, aole i kikokiko, aole noi i eleele no ka poe hipa, oia ke oleloia he mea i aihueia. ");
INSERT INTO haw1868_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","I mai la o Labana, Aia hoi, o ko'u makemake no ia, me kau i olelo mai ai. ");
INSERT INTO haw1868_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Ia la no, hookaawale ae la oia i na kao kane a pau i onionio a i kikokiko, a me na kao wahine a pau i onionio a kikokiko, me na mea kiko keokeo a pau; a me na mea eleele o na mea keikihipa, a haawi aku la iloko o ka lima o kana mau keikikane. ");
INSERT INTO haw1868_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","A hookaawale ae la o Labana i na la hele i ekolu mawaena ona a o Iakoba: a hanai aku la o Iakoba i na poe holoholona a Labana i koe. ");
INSERT INTO haw1868_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Lawe ae la o Iakoba i na laau popela maka, me na laau alemone, a me na laau pelane, a ihi iho la i na kaha onionio keokeo ma ua mau laau la, i moakaka na wahi keokeo o na mau laau la. ");
INSERT INTO haw1868_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Kukulu iho la ia i na laau ana i ihi ai, imua o na holoholona, ma na pawai hooinu, i ka wa i hele ai lakou e inu, i hapai ai lakou i ka wa i hele ai lakou e inu. ");
INSERT INTO haw1868_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Hapai iho la na holoholona imua o na mau laau la, a hanau mai la i na keiki onionio, kikokiko, a me ke kikohukohu. ");
INSERT INTO haw1868_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Hookaawale ae la o Iakoba i na keikihipa, a haliu ae la i na maka o ka poe holoholona ma na mea onionio, a me na mea eleele o ko Labana poe holoholona; hookaawale ae la ia i kona mau poe holoholona, aole i hookokoke aku ia lakou me na holoholona a Labana. ");
INSERT INTO haw1868_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","I ka wa i ai ai na holoholona ikaika, alaila, waiho iho la o Iakoba i na laau imua o na maka o na holoholona maloko o na pawaiinu, i hapai ai lakou imua o na laau. ");
INSERT INTO haw1868_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Aka, ina he mau holoholona nawaliwali lakou, aole ia i waiho i na laau iloko; pela no, na Labana ka poe nawaliwali, a na Iakoba ka poe ikaika. ");
INSERT INTO haw1868_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","A he nui loa ka waiwai o ua kanaka nei: ia ia na holoholona he nui wale, me na kauwawahine, a me na kauwakane, na kamelo, a me na hoki. ");
INSERT INTO haw1868_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","LOHE aku la o Iakoba i na olelo a na keikikane a Labana, i ka i ana ae, Ua lawe aku la o Iakoba i na mea a pau a ko kakou makuakane, a ua loaa ia ia keia waiwai a pau no na mea a ko kakou makuakane. ");
INSERT INTO haw1868_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Nana aku la o Iakoba i ka maka o Labana, aole ia i maliu mai ia ia e like mamua. ");
INSERT INTO haw1868_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Olelo mai la hoi o Iehova ia Iakoba, E hoi hou aku oe i ka aina o kou poe makua, a i na hoahanau ou; a owau kekahi pu me oe. ");
INSERT INTO haw1868_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Hoouna aku la o Iakoba e kahea ia Rahela laua o Lea e hele mai ma ke kula i kona poe holoholona. ");
INSERT INTO haw1868_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","I aku la oia ia laua, Ua ike no wau i ka maka o ko olua makuakane, aole ia i maliu mai ia'u e like mamua: aka, me au no ke Akua o ko'u makuakane. ");
INSERT INTO haw1868_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Ua ike hoi olua i ko'u malama i ana i ko olua makuakane me ko'u ikaika a pau. ");
INSERT INTO haw1868_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","A ua hoopunipuni mai ko olua makuakane ia'u, a he umi kana hoololi ana i ka'u uku: aka, aole ke Akua i ae mai e hoopoino mai ia ia'u. ");
INSERT INTO haw1868_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Ina i olelo mai kela penei, O na mea kikokiko kau uku, alaila hanau mai la na holoholona i na mea kikokiko: a i olelo mai ia penei, O na mea onionio kau uku, alaila hanau mai la na holoholona a pau i na mea onionio. ");
INSERT INTO haw1868_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Pela ke Akua i lawe ai i na holoholona a ko olua makuakane, a ua haawi mai ia'u. ");
INSERT INTO haw1868_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","A i ka manawa a ka poe holoholona i ko ai, nana aku la ko'u mau maka ma ka moeuhane, ike aku la, aia hoi, o na kao kane i lele aku maluna o na kao wahine ua onionio, a ua kikokiko, a me ke kikohukohu. ");
INSERT INTO haw1868_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Olelo mai la ka anela o ke Akua ia'u ma ka moeuhane, E Iakoba: i aku la au, Eia wau. ");
INSERT INTO haw1868_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","I mai la kela, E nana aku oe e ike, o na kao kane e lele ana maluna o na kao wahine, ua onionio, ua kikokiko, a me ke kikohukohu: no ka mea, ua ike no wau i ka mea a pau a Labana i hana mai ai ia oe. ");
INSERT INTO haw1868_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Owau no ke Akua no Betela, kahi au i poni ai i ka pohaku kukulu, kahi hoi au i hoohiki ai i ka hoohiki ia'u: ano hoi, e ku ae oe, e haalele aku i keia aina, a e hoi hou aku i ka aina o kou poe hoahanau. ");
INSERT INTO haw1868_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Olelo mai la o Rahela laua o Lea, i mai la ia ia, Auhea kekahi kuleana, a o kekahi waiwai hooili no maua ma ka hale o ko maua makuakane? ");
INSERT INTO haw1868_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Aole anei i manaoia maua e ia, he mau mea e? no ka mea, ua lilo maua i ke kuaiia e ia, a ua pau loa hoi ko maua kala ia ia. ");
INSERT INTO haw1868_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Nolaila, o ka waiwai a pau a ke Akua i lawe ae mai ko maua makuakane mai, no kakou ia a no na keiki a kakou: ano hoi, e hana aku oe i ka mea a ke Akua i olelo mai ai ia oe. ");
INSERT INTO haw1868_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Alaila, ku ae la o Iakoba, hoee aku la i kana mau keiki a me kana mau wahine maluna o na kamelo; ");
INSERT INTO haw1868_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","A lawe aku la ia i kana poe holoholona a pau, a me kona waiwai a pau i loaa ia ia, o na holoholona ana, i loaa ia ia ma Padanarama, e hele aku ai io Isaaka la i kona makuakane, ma ka aina o Kanaana. ");
INSERT INTO haw1868_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Ua hala aku la o Labana e ako i kana poe hipa: a aihue iho la o Rahela i na kii o kona makuakane. ");
INSERT INTO haw1868_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Puni aku la ka naau o Labana ka Suria, ia Iakoba, i ka hai ole aku ia ia i kona mahuka ana. ");
INSERT INTO haw1868_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Pela oia i mahuka ai me kana mau mea a pau: ku ae la ia, hele mai la ma keia aoao o ka muliwai, a hele pololei mai la i ka mauna o Gileada. ");
INSERT INTO haw1868_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","I ke kolu o ka la, olelo aku la kekahi ia Labana, Ua mahuka aku o Iakoba. ");
INSERT INTO haw1868_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Kono aku la ia i kona poe hoahanau e hele pa me ia, alualu mai mahope ona i na la hele ehiku, a hiki mai la io Iakoba la ma ka mauna o Gileada. ");
INSERT INTO haw1868_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Hele mai la ke Akua io Labana la ka Suria ma ka moeuhane i ka po, i mai la ia ia, E ao ia oe iho, mai olelo aku oe ia Iakoba i ka mea aloha, aole hoi ka mea hoino. ");
INSERT INTO haw1868_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Alaila loaa mai la o Iakoba ia Labana. Ua kukulu o Iakoba i kona halelewa ma ua mauna la: kukulu hoi o Labana me kona poe hoahanau ma ka mauna o Gileada. ");
INSERT INTO haw1868_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Olelo mai la o Labana ia Iakoba, Heaha kau i hana'i i hoopunipuni mai ai oe ia'u, a i lawe aku ai hoi i ka'u mau kaikamahine, e like me na pio e ke kana? ");
INSERT INTO haw1868_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","No ke aha la oe i holo malu mai ai, me ka puni mai ia'u, aole hoi i hai mai ia'u, i hoihoi aku ai au ia oe me ka olioli a me na mele, me na pahukani a me na lira! ");
INSERT INTO haw1868_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Aole hoi i ae mai oe ia'u e honi i ka'u mau moopuna a me na kaikamahine a'u? He lapuwale ka hana ana au i hana'i. ");
INSERT INTO haw1868_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","E hiki no i kuu lima ke hana aku ia oe i ke ino: aka, o ke Akua o kou makuakane i olelo mai ia'u, i ka po nei, i ka i ana, E ao oe, mai olelo aku oe ia Iakoba i ka mea aloha, aole hoi ka mea hoino. ");
INSERT INTO haw1868_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Ano hoi, i ka hele ana ua hala aku la oe, no kou iini nui ana i ka hale o kou makuakane; no ke aha hoi oe i aihue ai i ko'u mau akua? ");
INSERT INTO haw1868_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Olelo aku la o Iakoba ia Labana, i aku la, No ka mea, ua makau wau: i iho la au, E kaili aku paha oe i kau mau kaikamahine mai o'u aku nei. ");
INSERT INTO haw1868_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","A o ka mea e loaa ia oe, ia ia kou mau akua, aole ia e ola; imua o ko kana mau hoahanau e nana oe i kau maanei me au, a e lawe aku oe i ou la. No ka mea, aole i ike o Iakoba, na Rahela i aihue ia mau mea. ");
INSERT INTO haw1868_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Komo aku la o Labana iloko o ka halelewa o Iakoba, a iloko o ka halelewa o Lea, iloko hoi o na halelewa o na kauwawahine elua, aole i loaa. Alaila, hele aku la ia iwaho o ka halelewa o Lea, a komo aku la iloko o ka halelewa o Rahela. ");
INSERT INTO haw1868_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Ua lawe aku no o Rahela i ua mau kii la, a waiho pu iho la me na noho kamelo, a noho iho la maluna. Huli iho la o Labana i ka halelewa a pau, aole nae i loaa. ");
INSERT INTO haw1868_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","I aku la o Rahela i kona makuakane, mai huhu mai ko'u haku i kuu hiki ole ke ku ae iluna; no ka mea, he mai wahine ko'u. Imi iho la oia, aole nae i loaa ia ia na kii. ");
INSERT INTO haw1868_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Ukiuki iho la o Iakoba, a ao aku la ia Labana: olelo aku la o Iakoba, i aku la ia Labana, Heaha ko'u hala? heaha hoi ko'u hewa, i alualu wela mai ai oe ia'o? ");
INSERT INTO haw1868_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","A ua huli iho oe i ka'u ukana a pau, a heaha kau i loaa ai o na mea a pau o kou hale? e kau mai ianei imua o ko'u mau hoahanau a me kou mau hoahanau, i hooponopono mai ai lakou iwaena o kaua. ");
INSERT INTO haw1868_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","He iwakalua na makahiki a'u i noho ai me oe; o kau poe hipa wahine a me kau poe kao wahine, aole lakou i hanau i ka wa, aole hoi au i ai i na hipa kane o kou poe holoholona. ");
INSERT INTO haw1868_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","O na mea i haehaeia, aole au i lawe aku ion la; na'u no i uku aku: nau i lawe aku ia mea mai kuu lima aku, no ka mea i aihueia i ke ao, a i aihueia i ka po. ");
INSERT INTO haw1868_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Pela wau; i ke ao, ua wela au i ka la, a i ka po, ua make i ke anu: a holo aku la ka hiamoe mai o'u mau maka aku. ");
INSERT INTO haw1868_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Pela wau i na makahiki he iwakalua maloko o kou hale; hooikaika au nau i na makahiki he umikumamaha no kau mau kaikamahine, a me na makahiki eono no kou poe holoholona: a he umi kau hoololi ana i ka'u uku. ");
INSERT INTO haw1868_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Ina aole me au ke Akua o ko'u knpunakane, ke Akua o Aberahama, a o ka makau o Isaaka, he oiaio, ina ua hoihoi nele mai oe ia'u i neia manawa. Ua ike mai no ke Akua i ko'u popilikia, a me ka hana ana a ko u mau lima, a ua papa mai ia oe i ka po nei. ");
INSERT INTO haw1868_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Olelo mai la o Labana ia Iakoba, i mai la, Na'u no keia mau kaikamahine, a na'u no keia mau kamalii, a na'u no hoi keia poe holoholona, a na'u no na mea a pau au e ike nei; a heaha ka'u mea e hiki ai i keia la ke hana aku i keia mau kaikamahine a'u, a me keia mau kamalii a lakou i hanau ai? ");
INSERT INTO haw1868_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Nolaila ea, e hoopaa kaua i berita, owau a o oe, i mea hoikeike mawaena o kaua. ");
INSERT INTO haw1868_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Lalau aku la o Iakoba i ka pohaku, a hooku ae la ia mea i kukulu. ");
INSERT INTO haw1868_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","I aku la hoi o Iakoba i kona poe hoahanau, E houluulu mai oukou i na pohaku; lawe mai la lakou i na pohaku, a hana iho la i ahu; a ai iho la lakou maluna o ua ahu la. ");
INSERT INTO haw1868_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Kapa iho la o Labana ia ahu, o I Iegasaduha: kapa iho ia o Iakoba ia mea, o I Galeeda. ");
INSERT INTO haw1868_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Olelo mai la o Labana, He mea hoikeike keia ahu pohaku mawaena o kaua i keia la. Nolaila i kapaia'i kona inoa o Galeeda. ");
INSERT INTO haw1868_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","A o I Mizepa hoi; no ka mea, i mai la ia, O Iehova ke kiai mai mawaena o kaua, i ko kaua manawa e noho kaawale ana. ");
INSERT INTO haw1868_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Ina oe e hoopilikia i ka'u mau kaikamahine ina hoi oe e lawe i na wahine hou, he okoa keia mau kaikamahine a'u, aohe kanaka me kaua; e ao oe, o ke Akua no ke ike maka mai mawaena o kaua. ");
INSERT INTO haw1868_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","I mai la o Labana ia Iakoba, E nana i keia ahu, e nana hoi i keia pohaku kukulu a'u i hoolei aku ai mawaena o kaua; ");
INSERT INTO haw1868_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","He mea hoikeike keia ahu, he mea hoikeike hoi keia pohaku kukulu, i hele ole aku ai au ma keia aoao o keia ahu i ou la, aole hoi oe e hele mai ma keia aoao o ua ahu nei a me keia pohaku kukulu i o'u nei, e hana ino. ");
INSERT INTO haw1868_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","O ke Akua o Aberahama, a o ke Akua o Nahora, ke Akua o ko laua makuakane, e hooponopono mawaena o kaua. A hoohiki aku la o Iakoba ma ka Makau o kona makuakane o Isaaka. ");
INSERT INTO haw1868_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Alaila, kaumaha aku la o Iakoba i ka mohai maluna o ia mauna, a kahea aku la i kona poe hoahanau e ai i ka berena: ai iho la lakou i ka berena, a moe iho la ia po ma ka mauna. ");
INSERT INTO haw1868_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","I kakahiaka nui, aia ae ia o Labana, honi ae la i kana mau moopuna a me kana mau kaikamahine, a hoomaikai iho la ia lakou; hele aku la o Labana, a hoi aku la i kona wahi. ");
INSERT INTO haw1868_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","HELE aku la o Iakoba i kona hele ana, a halawai mai la na anela o ke Akua me ia. ");
INSERT INTO haw1868_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","A ike aku la o Iakoba ia lakou, i aku la ia, O ka puali kaua keia o ke Akua: a kapa iho la ia i ka inoa o ia wahi, o I Mahanaima. ");
INSERT INTO haw1868_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Hoouna aku la o Iakoba i na elele imua ona io Esau la i kona kaikuaana, ma ka aina o Seira, oia ka aina o Edoma. ");
INSERT INTO haw1868_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Kauoha aku la ia ia lakou, i aku la, Penei ka oukou e olelo aku ai i kuu haku, ia Esau; Ke i mai nei o kau kauwa o Iakoba penei, Ua noho pu au me Labana, ua kali aku no wau ilaila a hiki i neia manawa. ");
INSERT INTO haw1868_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Ia'u no na bipi, na hoki, na holoholona, me na kauwakane a me na kauwawahine; a ua hoouna aku no wau e hai aku i kuu haku, i loaa ia'u ke alohaia imua o kou maka. ");
INSERT INTO haw1868_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Hoi hou mai la na elele io Iakoba la, i mai la, Hele aku la makou i kou kaikuaana io Esau la; a ke hele mai nei hoi oia e halawai me oe, a me ia na haneri kanaka eha. ");
INSERT INTO haw1868_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Alaila, makau nui iho la o Iakoba, a ua pilikia loa: mahele ae la oia i na kanaka me ia, i na holoholona, i na bipi a me na kamelo, elua poe; ");
INSERT INTO haw1868_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","I aku la, Ina e hele mai o Esau, a pepehi mai i kekahi poe, alaila e pakele ka poe i koe. ");
INSERT INTO haw1868_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","I aku la o Iakoba, E ke Akua o kun kupunakane o Aberahama, ke Akua o kuu makuakane o Isaaka, e Iehova, ka mea nana i olelo mai ia'u, E hoi hou aku oe i kou aina, a i kou poe hoahanau, a e lokomaikai aku no au ia oe: ");
INSERT INTO haw1868_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Aole au e pono no na lokomaikai a pau a me ka oiaio a pau au i hoike mai ai, i kau kauwa nei; no ka mea, me kuu kookoo iho i hele mai ai au ma keia kapa o loredane; a ua lilo no wau ano i elua poe. ");
INSERT INTO haw1868_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Ke pule aku nei au ia oe, e hoopakele ae ae ia'u mai ka lima aku o kuu kaikuaana, mai ka lima o Esau: no ka mea, ke makau nei au ia ia, o hele mai nei oia e pepehi mai ia'u me ka makuwahine a me na kamalii. ");
INSERT INTO haw1868_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Ua olelo mai oe, E lokomaikai io no wau ia oe, a e hoonui au i kau poe mamo e like me ke one o ke kai, aole e pau lakou i ka heluia no ka lehulehu. ");
INSERT INTO haw1868_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Moe iho la ia malaila ia po; lalau aku la ia i na mea i loaa i kona lima, i makana na kona kaikuaana, na Esau, ");
INSERT INTO haw1868_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","I elua haneri kao wahine, me na kao kane he iwakalua; elua haneri hipa wahine, me na hipa kane he iwakalua, ");
INSERT INTO haw1868_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","He kanakolu kamelo waiu, me ka lakou mau keiki; he kanaha bipi wahine, me na bipi kane he umi; he iwakalua hoki wahine a me na hokikeiki he umi. ");
INSERT INTO haw1868_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Haawi aku la oia ia mau mea i ka lima o kana poe kauwa, a kaawale kekahi poe me kahi poe; i aku la ia i kana poe kauwa, E hele e aku oukou mamua o'u, a e hookaawale i kahi poe me kahi poe. ");
INSERT INTO haw1868_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Kauoha aku la ia i ka mea i hele mamua, i aku la, A halawai mai ko'u kaikuaana o Esau me oe, a ninau mai ia oe, i ka i ana mai, Nowai oe? Mahea oe e hele nei? Nawai hoi keia poe mamua ou? ");
INSERT INTO haw1868_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Alaila, e olelo aku oe, Na kau kauwa, na Iakoba lakou nei, ua hoounaia mai, i makana na ko'u haku na Esau: eia ae hoi oia mahope o makou. ");
INSERT INTO haw1868_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Pela hoi oia i kauoha aku ai i ka lua a me ke kolu, a me ka poe a pau i hahai mahope o na pua holoholona, i ka i ana, Pela hoi oukou e olelo aku ai ia Esau, i ka wa e loaa'i ia oukou ia. ");
INSERT INTO haw1868_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","E i aku hoi oukou, Eia ae kau kauwa o Iakoba mahope o makou. No ka mea, i iho la ia, E hoolaulea aku au ia ia i ka makana e hele la mamua o'u, a mahope iho e ike aku au i kona maka; a e maliu mai paha ia ia'u. ");
INSERT INTO haw1868_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Pela i hele aku ai ka makana ma kela kapa imua ona: a moe pu iho la oia ia po me ka huakai. ");
INSERT INTO haw1868_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Ala ae la oia ia po, lalau aku la ia i kana mau wahine elua, me kana mau kauwawahine elua, a me kana mau keiki kane he umikumamakahi, a hele aku la ma kahi papau o Iaboka ma kela kapa. ");
INSERT INTO haw1868_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Lalau aku la ia ia lakou, hoouna aku la ia lakou ma kela kapa o ke kahawai, a hoouka aku la hoi i kana mau mea a pau. ");
INSERT INTO haw1868_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","O Iakoba wale no i koe: a hakoko mai la kekahi kanaka me ia, a wehe ae la ke alaula o ke ao. ");
INSERT INTO haw1868_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","A ike iho la kela, aole ia i lanakila maluna ona, papai mai la ia i ka hena o kona uha, a ua kapeke ae la ka huamoa o ko Iakoba uha, i kona hakoko ana me ia. ");
INSERT INTO haw1868_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","I mai la kela, E kuu ae oe ia'u, no ka mea, ke wehe mai la ke alaula. I aku la oia, Aole au e kuu aku ia oe, a hoomaikai mai oe ia'u. ");
INSERT INTO haw1868_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Ninau mai la kela ia ia, Owai kou inoa? I aku la oia, O Iakoba. ");
INSERT INTO haw1868_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","I mai la kela, Aole e hea hou ia kou inoa, o Iakoba; aka, o Iseraela: no ka mea, he ikaika kou imua o ke Akua; a e lanakila hoi oe maluna o na kanaka. ");
INSERT INTO haw1868_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Ninau aku la o Iakoba, i aku la, Ke noi aku nei au ia oe, e hai mai oe ia'u i kou inoa. I mai la kela, Heaha kau i ninau mai ai i ko'u inoa? A hoomaikai mai la kela ia ia ilaila. ");
INSERT INTO haw1868_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Kapa aku la o Iakoba i ka inoa o ia wahi o i Peniela: No ka mea, ua ike iho nei au i ke Akua, he maka no he maka, a ua malamaia kuu ola. ");
INSERT INTO haw1868_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Puka mai la ka la maluna ona i kona hele ana ae maluna o Penuela, kapeke ae la oia maluna o kona uha. ");
INSERT INTO haw1868_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","No ia mea, aole e ai na mamo a Iseraela i ke olona i eeke, ka mea ma ka uha, a hiki i keia la: no ka mea, papai mai la kela i ka hena o ko Iakoba uha ma ke olona i eeke. ");
INSERT INTO haw1868_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","NANA aku la na maka o Iakoba, ike aku la, aia hoi, ua hiki mai o Esau me na haneri kanaka eha. A puunaue aku la ia i na kamalii ia Lea, a ia Rahela, a i na kauwawahine elua. ");
INSERT INTO haw1868_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Hoonoho aku la ia i na kauwawahine me na keiki a laua mamua, ia Lea hoi me kana mau keiki mahope iho, a ia Rahela me Iosepa mahope loa. ");
INSERT INTO haw1868_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Hele e aku la ia mamua o lakou; kulou pahiku iho la ia ma ka honua, a hiki aku la ia i kona kaikuaana. ");
INSERT INTO haw1868_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Holo mai la o Esau e halawai me ia, apo mai la ia ia, kau iho la ma kona a-i, a honi iho la ia ia: a uwe iho la laua. ");
INSERT INTO haw1868_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Alawa ae la kona mau maka, ike ae i na wahine a me na kamalii; ninau mai la ia, Owai lakou nei me oe? I aku la kela, O lakou no na keiki a ke Akua i haawi lokomaikai mai ai i kau kauwa. ");
INSERT INTO haw1868_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Alaila neenee mai la na kauwawahine, o laua me na keiki a laua, a kulou iho la lakou. ");
INSERT INTO haw1868_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Neenee mai la hoi o Lea me kana mau keiki, a kulou iho la lakou: a mahope iho, neenee mai la o Iosepa me Rahela, a kulou iho la laua. ");
INSERT INTO haw1868_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Ninau mai la kela, Heaha ia oe kela poe nui a pau i halawai me au? I aku la oia, He mea ia e loaa mai ai ke aloha o kuu haku. ");
INSERT INTO haw1868_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","I mai la kela, He nui no ka'u, e kuu kaikaina, ia oe no kau mea. ");
INSERT INTO haw1868_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","I aku la o Iakoba, Aole, ke noi aku nei au ia oe, ina i loaa ia'u ke alohaia imua on, e lawe oe i ka'u makana ma ko'u lima: no ka mea, ua ike iho nei au i kou maka, e like me kuu ike ana i ka maka o ke Akua, a ua oluolu mai oe ia'u. ");
INSERT INTO haw1868_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Ke noi aku nei au ia oe, e lawe oe i ka'u hoomaikai ana i haawiia ku nau; no ka mea, ua lokomaikai mai ke Akua ia'u, a no ka mea, ua lako hoi au. Koi aku la oia ia ia, a lawe hoi kela. ");
INSERT INTO haw1868_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","I mai la kela, e neenee aku kakou i ko kakou hele ana, a e hele hoi au imua ou. ");
INSERT INTO haw1868_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","I aku la oia ia ia, Ua ike no kuu haku, he palupalu na kamalii, a me au no na hipa hapai a me na bipi hapai: ina e hoolalelaleia lakou i ka la hookahi, e pau ka ohana holoholona i ka make. ");
INSERT INTO haw1868_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Ke noi aku nei au ia oe, e hele e aku kuu haku mamua o kana kauwa ma kela kapa; a na'u no e hele malie aku, e like me ka hiki ana o na holoholona a me na kamalii ke hele imua o'u, a hiki aku au i kuu haku ma Seira. ");
INSERT INTO haw1868_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","I mai la o Esau, E pono paha na'u e waiho me oe i kekahi poe kanaka o'u. I aku la ia, No ke aha hoi ia? ina e loaa ia'u ke alohaia imua o kuu haku. ");
INSERT INTO haw1868_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","A hoi hou aku la o Esau ia la i kona hele ana i Seira. ");
INSERT INTO haw1868_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Hele aku la o Iakoba i Sukota, a kukulu ia i hale nona, a hana iho la i hale kamala no kona poe holoholona: nolaila, i kapaia'i ka inoa o ia wahi, o i Sukota. ");
INSERT INTO haw1868_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Hele pomaikai aku la o Iakoba i kekahi kulanakauhale o Sekema, ma ka aina o Kanaana ia ia i hoi mai ai mai Padanarama mai, a kukulu iho la ia i kona halelewa imua o ua kulanakauhale la. ");
INSERT INTO haw1868_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Kuai aku la ia i kauwahi o ka aina, kahi ana i kukulu ai i kona halelewa, ma ka lima o na keiki a Hamora a ka makuakane o Sekema, i na apana kala he haneri. ");
INSERT INTO haw1868_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Malaila oia i hana'i i kuahu, a kapa iho la i kona inoa, o Elelohe-Iseraela. ");
INSERT INTO haw1868_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","HELE aku la o Dina o ke kaikamahine a Lea i hanau ai na Iakoba, e ike i na kaikamahine o ia aina. ");
INSERT INTO haw1868_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","A ike mai la o Sekema o ke keiki a Hamora no ka Hivi ke alii o ua aina la ia ia, lalau aku la kela ia ia, moe iho la me ia, a hoohaumia ia ia. ");
INSERT INTO haw1868_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Hoopili mai la kona naau ia Dina i ke kaikamahine a Iakoba; aloha mai la ia i ua kaikamahine la, a olelo oluolu mai la i ua kaikamahine la. ");
INSERT INTO haw1868_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Olelo aku la o Sekema i kona makuakane ia Hamora, E kii aku oe i ua kaikamahine la, i wahine na'u. ");
INSERT INTO haw1868_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Lohe ae la o Iakoba ua hoohaumia oia i kana kaikamahine ia Dina: aia no kana mau keikikane ma ke kula me kona poe holoholona; a noho olelo ole la o Iakoba, a hoi mai la lakou. ");
INSERT INTO haw1868_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Hele aku la o Hamora, ka makuakane o Sekema iwaho io Iakoba la e kamailio me ia. ");
INSERT INTO haw1868_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","A lohe ae la na keiki a Iakoba, hoi mai la lakou mai ke kela mai: ehaeha loa ka naau o ua poe kanaka la, a huhu loa iho la lakou, no ka mea, ua hana mai ia i ka mea kolohe i ka Iseraela, i ka moe ana me ke kaikamahine a Iakoba; ka mea pono ole ke hanaia pela. ");
INSERT INTO haw1868_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Kamailio mai la o Hamora me lakou, i mai la, Ua pili ka naau o kuu keikikane i ka oukou kaikamahine: ke noi aku nei au ia oukou, e haawi mai ia ia i wahine nana. ");
INSERT INTO haw1868_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","E mare mai oukou me makou; e haawi mai i na kaikamahine a oukou na makou, a e lawe hoi i na kaikamahine a makou na oukou. ");
INSERT INTO haw1868_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","E noho pu oukou me makou: imua hoi o ko oukou alo ka aina: e noho oukou, a e kuai hoi iloko, a e hoolilo i ka aina no oukou. ");
INSERT INTO haw1868_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Olelo mai la hoi o Sekema i ko Dina makuakane a me kona mau kaikunane, E lokomaikai mai oukou ia'u, a e haawi aku hoi au i ka oukou mea e olelo mai ai ia'u. ");
INSERT INTO haw1868_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","E hoonui loa oukou i ka'u mea e uku aku ai, a me ka makana, a e haawi aku no au e like me ka oukou e olelo mai ai: aka, e haawi mai i ke kaikamahine i wahine na'u. ");
INSERT INTO haw1868_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Olelo hoopunipuni aku la na keikikane a Iakoba ia Sekema, a ia Hamora i kona makuakane, olelo lakou pela, no ka mea, ua hoohaumia oia ia Dina i ko lakou kaikuwahine. ");
INSERT INTO haw1868_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Olelo aku la lakou ia laua, Aole e pono ia makou ke hana ia mea, ke haawi aku i ko makou kaikuwahine na ka mea i okipoepoe ole ia; no ka mea, he mea hoino ia no makou. ");
INSERT INTO haw1868_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Penei wale no ka makou e ae aku ai ia olua, a i like auanei oukou me makou, i okipoepoeia na kane o oukou a pau; ");
INSERT INTO haw1868_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Alaila makou e haawi aku ai i ka makou kaikamahine na oukou, a e lawe hoi i na kaikamahine a oukou na makou; a e noho pu me oukou, a lilo kakou i hookahi poe kanaka. ");
INSERT INTO haw1868_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Aka, ke hoolohe ole oukou i ka makou, e okipoepoeia'i; alaila e lawe aku makou i ka makou kaikamahine, a e hele. ");
INSERT INTO haw1868_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","A he oluolu ka lakou olelo ia Hamora, a me Sekema ke keiki a Hamora. ");
INSERT INTO haw1868_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Aole i hoopanee aku na kanaka opiopio la i ka hana ana ia mea; no ka mea, he makemake kona i ke kaikamahine a Iakoba: a ua oi aku kona maikai imua o ko ka hale a pau o kona makuakane. ");
INSERT INTO haw1868_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Hele aku la o Hamora, laua o Sekema o kana keiki ma ka ipuka o ko laua kulanakauhale, a kamailio pu iho la me na kanaka o ko laua kulanakauhale, i kai ana aku, ");
INSERT INTO haw1868_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Ea, ke noho malie nei keia poe kanaka me kakou; nolaila, e hoonoho kakou ia lakou ma ka aina, e piele lakou iloko; no ka mea, o ka aina, aia hoi, ua akea ia no lakou; e lawe kakou i na kaikamahine a lakou i wahine na kakou, a e haawi aku hoi kakou i na kaikamahine a kakou na lakou. ");
INSERT INTO haw1868_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Penei wale no e ae mai ai ua poe kanaka la e noho me kakou, hookahi poe, i okipoepoeia na kane a pau o kakou, e like me lakou i okipoepoeia'i. ");
INSERT INTO haw1868_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Aole anei e lilo na kakou ko lakou poe holoholona iki, ka lakou waiwai, a me na holoholona nui a pau a lakou? E ae wale aku no kakou ia lakou, a e noho pu auanei lakou me kakou. ");
INSERT INTO haw1868_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Hoolohe aku la lakou ia Hamora a i kana keiki ia Sekema, o ka poe a pau i puka iwaho ma ka ipuka o kona kulanakauhale: a ua okipoepoeia na kane a pau, ka poe a pau i puka iwaho ma ka ipuka o kona kulanakauhale. ");
INSERT INTO haw1868_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","A i ke kolu o ka la, ia lakou i eha ai, o na keikikane elua a Iakoba, o Simeona laua o Levi, na kaikunane o Dina, lalau aku la laua i na pahikaua a laua, hele aku la laua i ua kulanakauhale la me ka makau ole, a pepehi aku la i na kane a pau. ");
INSERT INTO haw1868_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Pepehi aku la laua ia Hamora, laua o Sekema o kana keiki me ka maka o ka pahikaua, lawe aku la hoi ia Dina iwaho o ka hale o Sekema, a hele aku la iwaho. ");
INSERT INTO haw1868_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Held mai la na keiki a Iakoba i ka poe i pepehiia, a lawe pio ae la i ka waiwai o ke kulanakauhale; no ka mea, ua hoohaumia lakou i ko lakou kaikuwahine. ");
INSERT INTO haw1868_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Lawe pio aku la hoi lakou i na hipa a lakou, a me na bipi a lakou, a me na hoki a lakou, me ko loko o ke kulanakauhale, a me ko ke kula, ");
INSERT INTO haw1868_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Me ko lakou waiwai a pau, me ka lakou kamalii a pau, a me na wahine a lakou, na pau ia lakou i ka hoopioia; a hao ae la lakou i na mea a pau o ka hale. ");
INSERT INTO haw1868_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Olelo aku la o Iakoba ia Simeona laua o Levi, Ua hoopilikia mai olua ia'u, i pilau aku ai au iwaena o na kanaka o ka aina nei, iwaena o ka Kanaana a me ka Perezi: a owau la e, he poe uuku ko'u, e hoakoakoa mai auanei lakou e ku e ia'u, a e pepehi mai ia'u, a e make auanei au me ko ka Hale o'u. ");
INSERT INTO haw1868_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","I mai la lakou, E pono anei e hana mai ia i ko makou kaikuwahine, me he wahine hookamakama la? ");
INSERT INTO haw1868_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","OLELO mai la ke Akua ia Iakoba, E ku ae oe, e pii aku i Betela, ilaila e noho ai: ilaila oe e hana'i i kuahu no ke Akua i ikea e oe i kou wa i mahuka ai mai ka maka o kou kaikuaana o Esau. ");
INSERT INTO haw1868_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Alaila, i aku la o Iakoba i ko ka hale ona, a i ka poe a pau me ia, E haalele oukou i na akua e iwaena o oukou, e huikala ia oukou iho, a e aahu iho i na kapa hou: ");
INSERT INTO haw1868_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","A e ku ae kakou, e pii aku i Betela; malaila au e hana'i i kuahu no ke Akua nana au i maliu mai i ka la o ko'u popilikia, a i hele pu me au i kuu ala i hele ai. ");
INSERT INTO haw1868_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Haawi mai la lakou ia Iakoba i na akua e ma ko lakou lima, a me na apo ma na pepeiao o lakou: a huna iho la o Iakoba ia mau mea malalo o ka laau oka aia ma Sekema. ");
INSERT INTO haw1868_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Hele aku la lakou: a kau mai la ka weliweli mai ke Akua mai maluna o na kulanakauhale ma kela aoao a keia aoao o lakou, a alualu ole mai la lakou i na keiki o Iakoba. ");
INSERT INTO haw1868_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","A hiki aku la o Iakoba ia Luza, oia hoi o Betela, ma ka aina o Kanaana, oia a me na kanaka a pau me ia. ");
INSERT INTO haw1868_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Hana iho la ia i kuahu malaila, a kapa iho la ia wahi o i Ele-betela: no ka mea, ilaila ke Akua i ikea ai e ia i kona wa i mahuka ai mai ka maka aku o kona kaikuaana. ");
INSERT INTO haw1868_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Make iho la o Debora o ke kahu no Rebeka, a ua kanuia oia malalo o Betela malalo o kekahi laau oka: a ua kapaia ka inoa o ia wahi, o i Alona-bakuta. ");
INSERT INTO haw1868_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Ikea hou ke Akua e Iakoba, i kona hoi ana mai, noloko mai o Padanarama, a hoomaikai mai la ia ia. ");
INSERT INTO haw1868_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","I mai la ke Akua ia ia, O Iakoba kou inoa: aole e hea hou ia kou inoa o Iakoba, aka, o Iseraela kou inoa: a kapa iho la oia i kona inoa o Iseraela. ");
INSERT INTO haw1868_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","I mai la ke Akua ia ia, Owau no ke Akua Mana: a e hoohua ae oe, a e mahuahua; nau mai no kekahi lahuikanaka, a me na lahuikanaka; a e puka mai auanei na alii mailoko mai o kou puhaka; ");
INSERT INTO haw1868_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","A o ka aina a'u i haawi aku ai no Aberahama, a no Isaaka, e haawi aku hoi au nou, a no kau poe mamo mahope ou ka'u e haawi aku ai i ka aina. ");
INSERT INTO haw1868_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","A pii aku la ke Akua iluna mai ona aku la, ma kahi ana i kamailio pu ai me ia. ");
INSERT INTO haw1868_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Hooku ae la o Iakoba i eho ma kahi ana i kamailio mai ai me ia, he eho pohaku: a ninini iho la ia i ka mohaiinu maluna; a ninini iho la hoi oia i ka aila maluna. ");
INSERT INTO haw1868_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Kapa iho la o Iakoba i ka aina o kahi a ke Akua i olelo mai ai me ia, o Betela. ");
INSERT INTO haw1868_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Hele aku la lakou mai Betela aku, a ua kokoke e hiki i Eperata, haakohi iho la o Rahela, a puua iho i ka hanau keiki ana. ");
INSERT INTO haw1868_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","A i kona puua ana, i aku la ka pale keiki ia ia, Mai makau oe, e loaa auanei ia oe keia keiki no hoi. ");
INSERT INTO haw1868_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","A i ka wa e kaili ana kona ea, (no ka mea, make no oia,) kapa iho la ia i kona inoa, i Benoni: aka, kapa aka la kona makuakane ia ia, o Beniamina. ");
INSERT INTO haw1868_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Make iho la o Rahela, a kanuia oia ma ke alanui e hele ai i Eperata, oia o Betelehema. ");
INSERT INTO haw1868_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Hooku ae la o Iseraela, i pohaku eho maluna o kona he, oia ka eho no ka he o Rahela, a hiki i keia manawa. ");
INSERT INTO haw1868_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Hele aku la o Iseraela, a kukulu iho la i kona halelewa ma o aku o ka halekiai o Edara. ");
INSERT INTO haw1868_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","A i ka noho ana o Iseraela ma ia aina, hele aka la o Reubena, a moe pu iho la me Bileha me ka haiawahine a kona makuakane; a lohe ae la o Iseraela. O na keikikane a Iakoba he umikumamalua: ");
INSERT INTO haw1868_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","O na keikikane a Lea; o Reubena ka makahiapo a Iakoba, o Simeona, o Levi, o Iuda, o Isakara, a o Zebuluna. ");
INSERT INTO haw1868_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","O na keikikane a Rahela; o Iosepa, a o Beniamina. ");
INSERT INTO haw1868_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","O na keikikane a Bileha, a ke kauwawahine a Rahela; o Dana, a o Napetali. ");
INSERT INTO haw1868_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","O na keikikane a Zilepa, a ke kauwawahine a Lea; o Gada a o Asera. O lakou na keikikane a Iakoba, i hanau nana ma Padanarama. ");
INSERT INTO haw1868_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Hele aku la o Iakoba i kona makuakane ia Isaaka ma Mamere, ma ke kulanakauhale o Areba, (oia o Heberona,) kahi i noho ai o Aberahama a me Isaaka. ");
INSERT INTO haw1868_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","A o na la o Isaaka, hookahi haneri makahiki a me kanawalu. ");
INSERT INTO haw1868_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Kuu aku la o Isaaka i ka uhane, a make iho la, a ua huiia'ku ia me kona poe kanaka: ua elemakule ia, a nui loa kona mau la: na kana mau keikikane na Esau ma laua o Iakoba oia i kanu. ");
INSERT INTO haw1868_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","EIA ka mooolelo no Esau, oia o Edoma. ");
INSERT INTO haw1868_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Lawe ae la o Esau i kana mau wahine no na kaikamahine o Kanaana: o Ada, ke kaikamahine a Elona ka Heta, a me Aholibama ke kaikamahine a Ana, ke kaikamahine a Zibeona ka Hivi; ");
INSERT INTO haw1868_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","A o Basemata ke kaikamahine a Isemaela, a o ke kaikuwahine o Nebaiota. ");
INSERT INTO haw1868_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Na Ada mai i hanau o Elipaza na Esau; a na Basemata i hanau o Reuela; ");
INSERT INTO haw1868_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Na Aholibama i hanau o Ieusa, o Iaalama, a o Kora: o lakou na keikikane a Esau, i hanau nana ma ka aina o Kanaana. ");
INSERT INTO haw1868_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Lalau aku la o Esau i kana mau wahine, me kana mau keikikane, a me kana mau kaikamahine, a me na kanaka a pau o kona hale, i na holoholona liilii, a me na holoholona nui, a me kona waiwai a pau i loaa ia ia ma ka aina o Kanaana; a hele aku la ma ka aina e, mai ka maka aku o kona kaikaina o Iakoba. ");
INSERT INTO haw1868_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Aole i hiki ia laua ke noho pu, no ka nui loa o ko laua waiwai; aole i pono i ka aina, kahi a laua i noho malihini ai ke malama ia laua, no na holoholona a laua. ");
INSERT INTO haw1868_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","A noho aku la o Esau ma mauna Seira: a o Esau, oia no o Edoma. ");
INSERT INTO haw1868_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Eia na hanauna o Esau, o ke kupuna no ka Edoma, ma mauna Seira. ");
INSERT INTO haw1868_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Eia na inoa o na keikikane a Esau, o Elipaza, ke keiki a Ada, a ka wahine na Esau; o Reuela ke keiki a Basemata a ka wahine na Esau. ");
INSERT INTO haw1868_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","O na keikikane a Elipaza, o Temana, o Omara, o Zepo, o Gatama, a o Kenaza. ");
INSERT INTO haw1868_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","A o Timena ka haiawahine na Elipaza na ke keiki a Esau; a nana mai i hanau o Amaleka na Elipaza: o lakou na keikikane a Ada, a ka wahine na Esau. ");
INSERT INTO haw1868_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Eia na keikikane a Reuela; o Nahata, o Zera, o Sama, a o Miza: o lakou na keikikane a Basemata a ka wahine a Esau. ");
INSERT INTO haw1868_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Eia na keikikane a Aholibama, a ke kaikamahine a Ana, ke kaikamahine a Zibeona, ka wahine a Esau: a nana i hanau mai o Ieusa, o Iaalama, a o Kora na Esau. ");
INSERT INTO haw1868_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","O lakou nei na makualii o na moopuna a Esau: o na keikikane a Elipaza a ka makahiapo na Esau, o Temana he makualii, o Omara he makualii, o Zepo he makualii, o Kenaza he makualii, ");
INSERT INTO haw1868_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","O Kora he makualii, o Gatama he makualii, a o Amaleka he makualii: o lakou na makualii na Elipaza ma ka aina o Edoma: o lakou hoi na keikikane a Ada. ");
INSERT INTO haw1868_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Eia na keikikane a Reuela a ke keikikane a Esau; o Nahata he makualii, o Zera he makualii, o Sama, he makualii, a o Miza he makualii: o lakou na makualii na Reuela, ma ka aina o Edoma: o lakou na moopuna a Basemata, a ka wahine a Esau. ");
INSERT INTO haw1868_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Eia na keikikane a Aholibama, a ka wahine na Esau; o Ieusa he makualii, o Iaalama he makualii, a o Kora he makualii: o lakou na makualii na Aholibama, ke kaikamahine a Ana, a ka wahine a Esau. ");
INSERT INTO haw1868_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","O lakou na keikikane a Esau, oia o Edoma; o lakou hoi na makualii o lakou. ");
INSERT INTO haw1868_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Eia na keikikane a Seira ka Hori, i noho ma ia aina; o Lotara, o Sobala, o Zibeona, o Ana, ");
INSERT INTO haw1868_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","O Disona, o Ezera, a o Disana: o lakou na makualii o ka Hori, o na keikikane a Seira, ma ka aina o Edoma. ");
INSERT INTO haw1868_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","O na keiki a Lotana, o Hori a o Hemama; a o Timena ke kaikuwahine o Lotana. ");
INSERT INTO haw1868_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Eia na keikikane a Sobala: Alevana, o Manahata, o Ebala, o Sepo, a o Onama. ");
INSERT INTO haw1868_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Eia na keikikane a Zibeona, o Aia, laua o Ana: oia no ua Ana la i loaa ia ia na hoki ma ka waonahele, ia ia i hanai ai i na miula o kona makuakane o Zibeona. ");
INSERT INTO haw1868_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Eia na keiki a Ana; o Disona, a o Aholibama ke kaikamahine a Ana. ");
INSERT INTO haw1868_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Eia na keiki a Disona; o Hemedana, o Esebana, o Iterana, a o Kerana. ");
INSERT INTO haw1868_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Eia na keiki a Ezera; o Bilehana, o Zaavana, a o Akana. ");
INSERT INTO haw1868_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Eia na keiki a Disana; o Uza, a o Arana. ");
INSERT INTO haw1868_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Eia na makualii o ka Hori, o Lotana he makualii, o Sobala he makualii, o Zibeona he makualii, a o Ana he makualii, ");
INSERT INTO haw1868_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","O Disona he makualii, o Ezera he makualii, a o Disana he makualii; o lakou na makualii na ka Hori, no ko lakou poe makualii ma ka aina o Seira. ");
INSERT INTO haw1868_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Eia ka poe alii i noho alii ai ma ka aina o Edoma mamua o ka manawa i noho ai kekahi alii maluna o na mamo a Iseraela. ");
INSERT INTO haw1868_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","O Bela ke keikikane a Beora, noho alii ae la ia ma Edoma: a o Dinehaba ka inoa o kona kulanakauhale. ");
INSERT INTO haw1868_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","A make iho la o Bela, a noho alii ae la o Iobaba ke keikikane a Zera no Bozera ma kona hakahaka. ");
INSERT INTO haw1868_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","A make iho la o Iobaba, noho alii ae la o Husama, no ka aina o Temani, ma kona wahi. ");
INSERT INTO haw1868_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","A make iho la o Husama, o Hadada, o ke keiki a Bedada, nana i pepehi ia Midiana ma ke kula o Moaba, a noho alii ae la ia ma kona wahi: a o A vita ka inoa o kona kulanakauhale. ");
INSERT INTO haw1868_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","A make iho la o Hadada, noho alii ae la o Samela no Masereka ma kona wahi. ");
INSERT INTO haw1868_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","A make iho la o Samela, noho alii ae la o Saula no Rehobota o ka muliwai, ma kona wahi. ");
INSERT INTO haw1868_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","A make iho la o Saula, noho alii ae la o Baala-hanana o ke keiki a Akebora ma kona wahi. ");
INSERT INTO haw1868_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","A make iho la o Baala-hanana ke keiki a Akebora, noho alii ae la o Hadara ma kona wahi: o Pau ka inoa o kona kulanakauhale; a o Mehetabela ka inoa o kana wahine, oia ke kaikamahine a Matereda, ke kaikamahine a Mezahaba. ");
INSERT INTO haw1868_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Eia na inoa o na makualii na Esau, e like me ko lakou mau ohana, mamuli o ko lakou mau wahi, ma ko lakou mau inoa; o Timena he makualii, o Aleva he makualii, o Ieteta he makualii, ");
INSERT INTO haw1868_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","O Aholibama he makualii, o Ela he makualii, o Pinona he makualii, ");
INSERT INTO haw1868_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","O Kenaza he makualii, o Temana he makualii, o Mibezara he makualii, ");
INSERT INTO haw1868_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","O Magediela he makualii, a o Irama he makualii; o lakou na makualii na Edoma, e like me ko lakou mau noho ana, ma ka aina i noho ai lakou: oia o Esau ke kupuna no ko Edoma. ");
INSERT INTO haw1868_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","NOHO aka la o Iakoba ma ka aina a kona makuakane i noho malihini ai, ma ka aina i Kanaana. ");
INSERT INTO haw1868_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Eia ka mooolelo no Iakoba. He umi ko Iosepa makahiki a me kumamahiku, e hanai ana oia i na holoholona me kona poe kaikuaana, e noho pu ana o ua keiki la me na keikikane a Bileha, a me na keikikane a Zilepa, na wahine a kona makuakane, a hai mai la o Iosepa i ka makuakane o lakou i ka lono ino o lakou. ");
INSERT INTO haw1868_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Ua oi aku la ke aloha o Iseraela ia Iosepa mamua o kana mau keiki a pau, no ka mea, he keiki ia no kona wa elemakule: a hana iho la ia i kapakomo onionio nona. ");
INSERT INTO haw1868_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","A ike iho la kona poe kaikuaana i ke kela ana aku o ke aloha o ko lakou makuakane ia Iosepa mamua o kona poe hoahanau a pau, inaina aku la lakou ia Iosepa, aole i hiki ke olelo oluolu aku ia ia. ");
INSERT INTO haw1868_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Moe iho la o Iosepa i ka moe, a hai aku la i kona poe kaikuaana, a nui hou mai la ko lakou inaina ana ia ia. ");
INSERT INTO haw1868_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","I aku la ia ia lakou, Ea, e hoolohe mai oukou i keia moe a'u i moe ai. ");
INSERT INTO haw1868_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Eia hoi, i ka pua ana a kakou i na pua, ma ka mahina ai, ala mai la ka'u pua, a kupono ae la iluna; a o ka oukou mau pua ka i ku poai mai la, a kulou iho la i ka'u pua. ");
INSERT INTO haw1868_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Olelo mai la kona poe kaikuaana ia ia, E alii ana ka oe maluna o makou? O oe anei ka haku maluna o makou? Huhu nui aku la lakou ia ia i kana moe, a i kana olelo. ");
INSERT INTO haw1868_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","A mahope aku, moe hou iho la ia i ka moe, a hai hou aku la i kona poe kaikuaana, i aku la, Eia hoi, ua moe hou iho nei au i ka moe; a ua kulou mai ia'u ka la, a me ka mahina, a me na hoku he umikumamakahi. ");
INSERT INTO haw1868_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Hai aku la ia i kona makuakane, a i kona poe kaikuaana. Papa mai la kona makuakane, i mai la ia ia, Heaha keia moe au i moe ai? E hele anei au iou la, a me kou makuwahine, a me kou poe hoahanau, e kulou ilalo i ka honua imua ou? ");
INSERT INTO haw1868_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Huahuwa ae la kona poe kaikuaana ia ia, a malama iho la kona makuakane i ua olelo la. ");
INSERT INTO haw1868_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Hele aku la kona poe kaikuaana i Sekema, e hanai i ka poe holoholona a ka makuakane o lakou. ");
INSERT INTO haw1868_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Olelo aku la o Iseraela ia Iosepa, Aia paha kou poe kaikuaana e hanai holoholona ana ma Sekema? Auhea oe? E hoouna ana au ia oe io lakou la. I mai la kela ia ia, Eia no wau. ");
INSERT INTO haw1868_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","I aku la oia ia ia, Ea, o hele oe e ike i ka pono o kou poe kaikuaana, a me ka pono o na holoholona, a e hai mai ia'u. Hoouna aka la oia ia ia, iwaho o ke awawa o Heberona, a hiki aku la ia i Sekema. ");
INSERT INTO haw1868_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","A loaa ia i kekahi kanaka, aia hoi, ua hele hewa ia i ke kula. Ninau mai la ua kanaka la ia ia, i mai la, Heaha kau mea e imi nei? ");
INSERT INTO haw1868_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Olelo aku la ia, E imi ana au i ko'u poe kaikuaana: e hai mai oe ia'u i kahi a lakou e hanai ai i na holoholona. ");
INSERT INTO haw1868_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Olelo mai la ia kanaka, Ua hala'ku la lakou: ua lohe au i ka olelo ana a lakou, E, e hele kakou i Dotana. Hahai aku la o Iosepa i kona poe kaikuaana, a loaa aku la lakou Dotana. ");
INSERT INTO haw1868_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","A ike mai la lakou ia ia ma kahi loihi aku, aole ia i lihi koke mai, ohumu iho la lakou ia ia, e make ia. ");
INSERT INTO haw1868_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Olelo ae la lakou i kekahi i kekahi, Eia'e ka mea nana na moe, ke hele mai nei. ");
INSERT INTO haw1868_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Ina kakou e pepehi ia ia a make loa, e hoolei ia ia iloko o kahi lua, a e olelo aku kakou, Na ka ilio hihiu ia i ai; alaila, e ike kakou i ka hope o kana mau moe. ");
INSERT INTO haw1868_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","A lohe ae la o Reubena, hoola ae la oia ia ia, mai ko lakou lima ae; i ae la, Mai pepehi kakou ia ia. ");
INSERT INTO haw1868_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Olelo aku la o Reubena ia lakou, Mai hookahe i ke koko; e hoolei ia ia iloko o keia hua o ka aina waonahele. Mai kau i ka lima maluna ona. Manao iho la ia e hoopakele ia ia, mai ko lakou lima ae, a e hoihoi aku ia ia i kona makuakane. ");
INSERT INTO haw1868_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","A hiki aku la o Iosepa i kona poe kaikuaana, hao ae la lakou i ko Iosepa kapa, o ke kapa onionio maluna ona; ");
INSERT INTO haw1868_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Lalau ae la lakou ia ia, hoolei aku la ia ia iloko o ka lua. Ua kaawale ka lua, aole he wai oloko. ");
INSERT INTO haw1868_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","A noho iho la lakou e ai i ka ai. Alawa'e la ko lakou maka, ike aku la, aia hoi kekahi poe mamo a Isemaela, e hele mai ana, mai Gileada mai, me ko lakou mau kamelo, ua kaumaha i ka mea ala, a me ka bama, a me ka mura, e lawe hele ana i Aigupita. ");
INSERT INTO haw1868_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Olelo aku la o Inda i kona poe hoahanau, Heaha ka maikai, ke pepehi kakou i ko kakou kaikaina, a huna i kona koko? ");
INSERT INTO haw1868_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Ina kakou e kuai aku ia ia i ka Isemaela; mai kau ko kakou lima maluna ona; no ka mea, o ko kakou kaikaina no ia, a me ko kakou io. A hoolohe mai la kona poe hoahanau ia ia. ");
INSERT INTO haw1868_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Hele ae la ua poe kanaka kuai la, no Midiana, huki mai la lakou, a hapai ae la ia Iosepa, mai loko mai o ka lua, a kuai aku la ia ia, i ka Isemaela, i na hapakala, he iwakalua. A lawe ae la lakou ia Iosepa i Aigupita. ");
INSERT INTO haw1868_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","A hoi mai la o Reubena i ka lua, aia hoi, aole o Iosepa iloko o ka lua: haehae iho la ia i kona kapa. ");
INSERT INTO haw1868_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","A hoi aku la ia i kona poe hoahanau, i aku la, Aole loa ke keiki; a o wau, ihea la wau e hele ai? ");
INSERT INTO haw1868_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Lawe ae la lakou i ke kapa o Iosepa, pepehi iho la lakou i ke kao keiki, a kupenu iho la i ke kapa i ke koko. ");
INSERT INTO haw1868_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Hoouka aku la lakou i ua kapa onionio la, a hiki i ko lakou makuakane; i aku la, Ua loaa mai keia ia makou: e nana oe, o ke kapa paha o kau keiki, aole paha. ");
INSERT INTO haw1868_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Ike mai la kela, i mai la, Oia, o ke kapa no ia o ka'u keiki; ua pau o Iosepa i ka ilio hihiu, oiaio no, ua haehaeia o Iosepa. ");
INSERT INTO haw1868_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Haehae iho la o Iseraela i kona kapa, kaei ae la i ke kapa inoino ma kona puhaka, a kanikau iho la ia i kana keiki a nui na la. ");
INSERT INTO haw1868_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Ku mai la kana mau keikikane a pau, a me kana mau kaikamahine a pau, e hoonana ia ia. Hoole aku la kela, aole e na: i aku la, E kanikau no au, a hiki au ilalo i ka lua i kuu keiki la. Pela i uwe ai kona makuakane ia ia. ");
INSERT INTO haw1868_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","A kuai aku la ko Midiana ia ia i Aigupita, ia Potipara, he luna na Parao, oia ka luna o ka poe koa. ");
INSERT INTO haw1868_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","I A manawa no, iho aku la o Iuda mai kona poe hoahanau aku, a kipa aku la i kekahi kanaka no Adulama, o Hira kona inoa. ");
INSERT INTO haw1868_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Ike aku la o luda i ke kaikamahine a kekahi mamo a Kanaana ilaila, o Sua kona inoa, lawe ae la oia ia ia, a komo aku la io na la. ");
INSERT INTO haw1868_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Hapai iho la oia, a hanau mai la he keikikane; a kapa iho la ia i kona inoa, o Era. ");
INSERT INTO haw1868_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Hapai hou iho la oia, a hanau mai la he keikikane; a kapa iho la ia i kona inoa, o Onana. ");
INSERT INTO haw1868_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Hapai hou iho la oia a hanau mai la he keikikane; a kapa iho la ia i kona inoa, o Sela: ma Keziba oia i kona wa i hanau ai. ");
INSERT INTO haw1868_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Lawe ae la o Iuda i wahine na Era, na kana hiapo, o Tamara kona inoa. ");
INSERT INTO haw1868_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","A ua hewa o Era, o ka hiapo a Iuda imua o Iehova; a pepehi iho la o Iehova ia ia. ");
INSERT INTO haw1868_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","I aku la o Iuda ia Onana, E komo aku oe i ka wahine a kou kaikuaana, e mare me ia, a e hooku ae i keiki na kou kaikuaana. ");
INSERT INTO haw1868_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Ike iho la o Onana, aole nana ke keiki, alaila, i ka manawa ana i komo aku ai i ka wahine a kona kaikuaana, kiki iho la oia i ka mea ma ka honua, o haawi auanei ia i hua na kona kaikuaana. ");
INSERT INTO haw1868_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","A o ka mea ana i hana'i, ua hewa ia imua o Iehova: a nana hoi ia i pepehi. ");
INSERT INTO haw1868_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Alaila, i aku la o Iuda ia Tamara, E noho kane ole oe ma ka hale o kou makuakane, a ka manawa e nui ai kuu keikikane o Sela: no ka mea, i iho la ia, O make paha hoi oia, e like me kona mau kaikuaana. Hele aku la o Tamara a noho iho la ma ka hale o kona makuakane. ");
INSERT INTO haw1868_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","A nui na la i hala, make iho la ke kaikamahine a Sua, o ka luda wahine; a pau ko Iuda kanikau ana, pii aku la ia i Timenata i kona poe ako hipa, oia a me kona makamaka o Hira no Adulama. ");
INSERT INTO haw1868_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Hai aku la kekahi ia Tamara, Ea, e pii ana kou makuahunowaikane i Timenata e ako i kana hipa. ");
INSERT INTO haw1868_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Wehe ae la ia i kona mau kapa makena, a uhi iho la ia ia iho i ka palemaka, aahu iho la ia ia iho, a noho iho la ma ka pukapa o Enaima ma kapa alanui e hele ai i Timenata: no ka mea, ike aku la ia, ua nui ae la o Sela, aole hoi i haawiia oia i wahine naua. ");
INSERT INTO haw1868_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","A ike aku la o Iuda ia ia, manao iho la ia he wahine hookamakama kela; no ka mea, ua paleia kona maka. ");
INSERT INTO haw1868_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Kipa ae la ia io na la ma kapa alanui, i aku la, Ea, ke noi aku nei au ia oe, e ae mai ia'u e komo aku iou la; (no ka mea, aole ia i ike, o kana hunona wahine ia.) Ninau mai la kela, Heaha kau e haawi mai ai ia'u, i mea e komo mai ai oe i o'u nei? ");
INSERT INTO haw1868_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","I aku la ia, E hoouka aku au i wahi kao keiki no ka poe holoholona mai I mai la kela, Aole anei oe e haawi mai i hoailona, a hoouka mai oe ia mea? ");
INSERT INTO haw1868_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","I aku la oia, Heaha ka hoailona a'u e haawi aku ai ia oe? I mai la kela, O kou apolima, me kou kaula hoolewa, a me ke kookoo maloko o kou lima. Haawi aku la oia ia ia, a komo aku la io na la, a hapai iho la kela ma ona la. ");
INSERT INTO haw1868_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Ku ae la ia, hele aku la, a waiho iho la i kona pale maka, a aahu hou iho la i kona mau kapa no ka noho wahine kanemake ana. ");
INSERT INTO haw1868_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Hoouka aku la o Iuda i ke kao keiki ma ka lima o kona makamaka no Adulama, i loaa mai ai kana hooiaio mai ka lima mai o ka wahine: aole nae i loaa ua wahine la ia ia. ");
INSERT INTO haw1868_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Ninau aku la ia i na kanaka o ia wahi, i aku la, Auhea la ka wahine hookamakama i noho ma Enaima, ma kapa alanui? I mai la lakou, Aohe wahine hookamakama ia nei. ");
INSERT INTO haw1868_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Hoi hou aku la ia io Iuda la i aku la, Aohe i loaa ia ia'u; a ua i mai hoi na kanaka o ia wahi, aole wahine hookamakama ia nei. ");
INSERT INTO haw1868_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","I aku la o Iuda, E aho no e lilo ia mau mea nona, o hoohilahilaia kaua: aia hoi, hoouka aku no au i keia kao keiki, aole ka i loaa ka wahine ia oe. ");
INSERT INTO haw1868_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","A hala na malama ekolu paha, hai mai la kekahi ia Iuda, i ka i ana, Ua moekolohe iho nei kau hunonawahine o Tamara; aia hoi, ua hapai oia ma ka moekolohe. I aku la o Iuda, E kaiia mai oia, i puhiia'i ia i ke ahi. ");
INSERT INTO haw1868_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","A kaiia'ku oia, hoouna mai la ia, i mai la i kona makuahunowaikane, Na ke kanaka nana keia mau mea au i hapai ai. I mai la hoi oia, E nana oe, ea, i ike i ka mea nana keia mau mea, o ke apolima, me ke kaula hoolewa, a me ke kookoo. ");
INSERT INTO haw1868_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","A ike iho la o Iuda, i aku la, Ua oi aku kona pono i ko'u; no ka mea, aole au i haawi aku ia ia na kuu keiki na Sela. Aole hoi o Iuda i ike hou ia ia. ");
INSERT INTO haw1868_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","A i ka manawa o kona haakohi ana, aia hoi, he mau mahoe maloko o kona opu. ");
INSERT INTO haw1868_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","A i ka hanau ana, puka mai la ka lima o kekahi; lalau aku la ka palekeiki i ua lima la a nakii iho la i ke kaula ulaula ilaila, i mai la, Eia ka hanau mua. ");
INSERT INTO haw1868_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","A i ka huki hou ana o kona lima iloko, aia hoi, puka e mai la kona hoahanau: i aku la ke palekeiki, Heaha kau i poha wale mai? Maluna iho ou keia nahae: nolaila, kapa iho la ia i kona inoa o Pareza. ");
INSERT INTO haw1868_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Mahope iho puka mai la ke kaikaina, ia ia ke kaula ulaula ma kona lima: a ua kapaia kona inoa o Zara. ");
INSERT INTO haw1868_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","U A laweia'ku la o Iosepa ilalo i Aigupita; kuaiia'ku la oia no Potipara, he luna na Parao, he luna o ka poe koa, a he kanaka no Aigupita, mai na lima aku o ka Isemaela, nana ia i lawe aku ilalo. ");
INSERT INTO haw1868_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Me Iosepa no o Iehova, he kanaka ia i hoopomaikaiia, aia no ia ma ka hale o kona haku, he Aigupita. ");
INSERT INTO haw1868_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Ike ae la kona haku, aia no o Iehova me Iosepa, a na Iehova no i pono ai ka hana a pau a kona lima. ");
INSERT INTO haw1868_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","A loaa ia Iosepa ka lokomaikaiia imua ona, a hookauwa aku ia nana, a hoolilo aku la oia ia ia i luna no kona ohua, a no kona waiwai a pau, a waiho aku la ia i kana mea a pau i kona lima. ");
INSERT INTO haw1868_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Eia hoi kekahi, mai ka wa mai o kona hoolilo ana ia ia i luna no kona ohua, a maluna o kona mea a pau, hoopomaikai mai ke Akua i ko ka hale o ua kanaka Aigupita nei no Iosepa; a na Iehova no ka pomaikai o na mea a pau ona, ma ka hale, a ma ke kula. ");
INSERT INTO haw1868_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","A waiho iho la oia i kona mea a pau i na lima o Iosepa, aole ia i ike aku i kekahi mea nona, o ka ai ana i ai ai wale no. Ua maikai ke kino o Iosepa, he maikai no hoi ka maka. ");
INSERT INTO haw1868_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","A mahope iho o keia mau mea, ike mai la na maka o ka wahine a kona haku ia Iosepa, i mai la ia, E moe kaua. ");
INSERT INTO haw1868_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Hoole aku la ia, i aku la i ka wahine a kona haku, Aia hoi, aole ike kuu haku i na mea ia'u ma keia hale, ua waiho mai nei ko'u haku i kana mea a pau i kuu lima: ");
INSERT INTO haw1868_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Aohe mea nui e ae oloko o keia hale, owau wale no; aole keia i paa aku i kekahi mea ia'u, o oe wale no, no ka mea, o kana wahine no oe. Pehea la wau e hana'i i keia hewa nui, a hana ino aku i ke Akua? ");
INSERT INTO haw1868_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Koi mai la oia ia Iosepa i keia la a i keia la, aole loa ia i hoolohe iki aku ia ia, e moe me ia, a e noho me ia. ");
INSERT INTO haw1868_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Ia manawa iho, komo ae la o Iosepa iloko o ka hale, e hana i kana hana, aohe kanaka o ka hale iloko. ");
INSERT INTO haw1868_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Apo mai la kela ia ia ma ke kapa ona, i mai la, E moe kaua. Haalele iho la ia i kona kapa ma ka lima ona, holo aku la a hiki iwaho. ");
INSERT INTO haw1868_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","A ike aku la ua wahine la, ua haalele ia i kona kapa ma kona lima, a ua holo aku la iwaho, ");
INSERT INTO haw1868_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","Kahea aku la ua wahine la i na kanaka o kona hale, olelo aku la ia lakou, i aku la, E nana oukou, ua lawe mai nei kela i ke kanaka no ka poe Hebera io kakou nei, e hoomaewaewa mai ia kakou. Hele mai la oia io'u nei e moe me au, a kahea aku la au me ka leo nui; ");
INSERT INTO haw1868_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","A lohe mai la kela i kuu hookiekie ana i kuu leo iluna, a i kuu hea ana aku, haalele iho nei oia i ke kapa ona ia'u, holo aku la a hiki iwaho. ");
INSERT INTO haw1868_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Malama iho la ua wahine la i kona kapa, a hoi mai la kona haku i ka hale. ");
INSERT INTO haw1868_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Olelo aku la ua wahine la ia ia i keia mau olelo, i aku la, O ko kauwa Hebera, au i lawe mai ai io kakou nei, ua komo mai ia io'u nei e hoomaewaewa mai ia'u. ");
INSERT INTO haw1868_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","A hookiekie au i kuu leo iluna a kahea aku au, alaila, haalele iho la ia i ke kapa ona ia'u, a holo aku la iwaho. ");
INSERT INTO haw1868_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","A lohe ae la kona haku i ka olelo a kana wahine i olelo mai ni ia ia, i ka i ana mai, E like me keia mau olelo i hana mai ai kau kauwa ia'u; nui iho la ka huhu ona. ");
INSERT INTO haw1868_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Lalau mai la ka haku o Iosepa ia in, hahao aku la ia ia iloko o ka halepaahao, i kahi i paa ai ka poe paa o ke alii, a paa no ia maluila ma ka halepaahao. ");
INSERT INTO haw1868_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Me Iosepa no o Iehova, aloha nui mai la ia ia, a haawi mai la ia ia i ka pono imua o na maka o ka mea nana i malama ka halepaahao. ");
INSERT INTO haw1868_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Waiho ae la ka mea nana i malama ka halepaahao i ka poe paa a pau oloko o ka halepaahao i ka lima o Iosepa, a o na mea a pau i hanaia malaila, nana no ia i hana. ");
INSERT INTO haw1868_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Aole hoi i nana aku ka luna o ka halepaahao i kekahi mea malalo iho o kona lima, no ka mea, aia no o Iehova me ia, a hoopomaikai mai la o Iehova i ka hana a pau ana i hana'i. ");
INSERT INTO haw1868_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","A MAHOPE iho o keia mau mea, hewa ka mea lawe kiaha, a me ka mea kahuai o ke alii o Aigupita, i ko laua haku, i ke alii o Aigupita. ");
INSERT INTO haw1868_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Huhu aku la Parao i kana mau luna elua, i ka luna lawe kiaha, a me ka luna kahuai. ");
INSERT INTO haw1868_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","A hahao aku la oia ia laua iloko o kahi paa o ka hale o ka luna koa, ma ka halepaahao i kahi o Iosepa i paa ai. ");
INSERT INTO haw1868_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Kauoha aku la ka luna koa ia Iosepa no laua, nana e malama mai laua, a nui na la a laua i paa ai. ");
INSERT INTO haw1868_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Moe iho la laua a elua i ka moe, i ka po hookahi ko laua moe ana, ma ka oiaio ke ano o ko laua moe, o ka mea lawe kiaha, a me ka mea kahuai o ke alii o Aigupita, o na mea i paa ma ka halepaahao. ");
INSERT INTO haw1868_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","A ao ae la, hele aku la o Iosepa io laua la, nana aku la ia laua, aia hoi, ua kaumaha iho la laua. ");
INSERT INTO haw1868_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Ninau aku la ia i ua mau luna la me ia, ana i malama'i ma kahi paa o ka hale o kona haku, i aku la, No ke aha la i inoino ai na maka o olua i keia la? ");
INSERT INTO haw1868_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","I aku la laua ia ia, Ua moe maua i ka moe, aohe mea nana e hai mai ke ano o ia mea. I aku la o Iosepa ia laua, Aole anei na ke Akua ke ano oiaio? e hoike mai olua ia'u. ");
INSERT INTO haw1868_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Hai aku la ka luna lawe kiaha i kana moe ia Iosepa, i aku la ia ia, O kuu moe, aia hoi, he kumu waina imua o'u. ");
INSERT INTO haw1868_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Ekolu manamana o ke kumu waina; me he mea opuu mai la ia, a mohala mai la ka pua; a hua mai la ka hua waina pala. ");
INSERT INTO haw1868_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Ma kuu lima ke kiaha o Parao, a lawe ae la au i na hua waina, kowi iho la ia lakou iloko o ke kiaha o Parao, a haawi aku la au i ke kiaha i ko Parao lima. ");
INSERT INTO haw1868_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Olelo aku la o Iosepa ia ia, Eia ke ano oiaio o ia mea: o na manamana ekolu, ekolu ia la. ");
INSERT INTO haw1868_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","I na la ekolu, e hookiekie ae o Parao i kou poo iluna, a e hoihoi aku ia oe i kou wahi mamua, alaila, e haawi aku oe i ke kiaha o Parao iloko o kona lima, e like me kau hana'na mamua, i ka wa ia oe ka lawe kiaha. ");
INSERT INTO haw1868_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","A pomaikai oe, ea, e hoomanao mai oe ia'u, alaila, ke noi aku nei au, e hana lokomaikai mai oe ia'u. E hai aku oe ia'u ia Parao, e laweia'ku hoi au iwaho o keia hale. ");
INSERT INTO haw1868_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","No ka mea, ua aihue io ia mai au, noloko mai o ka aina o ka poe Hebera; ia nei hoi, aole au i hana i mea i hahaoia'i e lakou iloko o ka lua. ");
INSERT INTO haw1868_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","A ike mai la ka luna kahuai, ua hoike mai kela i ke ano ma ka maikai, olelo mai la oia ia Iosepa, He moe no hoi ka'u, aia hoi, he mau hinai palaoa keokeo ekolu iluna o kuu poo. ");
INSERT INTO haw1868_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","A iloko o ka hinai maluna iho, o na mea ai a pau i kahuia na Parao. Ai mai la na manu ia mau mea noloko mai o ka hinai maluna o kuu poo. ");
INSERT INTO haw1868_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Olelo aku la Iosepa, i aku la, Eia ke ano o ia mea. O na hinai ekolu, ekolu ia la. ");
INSERT INTO haw1868_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","I na la ekolu, e hookiekie aku o Parao i kou poo mai ou aku, a e kaawe aku hoi ia oe iluna o ka laau; a e ai mai na manu i kou io. ");
INSERT INTO haw1868_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","A i ke kolu o ka la, i ka la o Parao i hanau ai, hana iho la ia i ka ahaaina na na kauwa ana a pau: hookiekie ae la ia i ke poo o ka luna lawe kiaha a me ka luna kahuai, mawaena o na kauwa ana. ");
INSERT INTO haw1868_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Hoihoi aku la ia i ka luna lawe kiaha i kona lawe kiaha ana; a haawi aku la ia i ke kiaha i ko Parao lima. ");
INSERT INTO haw1868_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Kau aku la ia i ka luna kahuai iluna, e like me ka Iosepa hai ana mai ia laua. ");
INSERT INTO haw1868_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Aole hoi i hoomanao mai ka luna lawe kiaha ia Iosepa, aka, hoopoina iho la ia ia. ");
INSERT INTO haw1868_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","MAHOPE o na makahiki elua, moe iho la o Parao, aia hoi, ku iho la ia ma kapa o ka muliwai. ");
INSERT INTO haw1868_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Aia hoi, hoea mai la, mai loko mai o ka muliwai, ehiku bipi maikai, kaha ke kino, ai iho la lakou ma kahi weuweu. ");
INSERT INTO haw1868_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Hoea hou mai la, mahope mai o lakou, mai loko mai o ka muliwai, ehiku bipi inoino, a olala ke kino, a ku pu mai la lakou me kela mau bipi, ma kapa o ka muliwai. ");
INSERT INTO haw1868_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Ai iho la na bipi ehiku inoino a olala ke kino, i na bipi maikai a kaha ke kino; a hikilele mai o Parao. ");
INSERT INTO haw1868_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Hiamoe hou iho la ia, a loaa ka moe, aia hoi, hua mai la na opuu palaoa ehiku i ke kumu hookahi, he ohaha a he maikai. ");
INSERT INTO haw1868_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Aia hoi, hua hou mai la mahope mai o lakou, na opuu hou ehiku, he wiwi, a mae i ka makani mai ka hikina mai. ");
INSERT INTO haw1868_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Ai iho la na opuu wiwi ehiku i na opuu ehiku i ohaha a nui. A hikilele mai la o Parao, aia hoi, he moe nana. ");
INSERT INTO haw1868_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","A ao ae la anoninoni iho la kona naau; hoouna aku la ia e kii i na kilo a pau o Aigupita, a me na kanaka naauao a pau o ia wahi; a hai aku la o Parao ia lakou i kana mau moe; aohe mea nana i hoakaka mai i ke ano o ua mau moe nei a Parao. ");
INSERT INTO haw1868_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Alaila olelo aku la ka luna lawe kiaha ia Parao, i aku la, Ke hoomanao nei au i keia la i kuu hewa. ");
INSERT INTO haw1868_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Mamua, huhu mai o Parao i kana mau kauwa, a hahao aku la ia maua me ka luna kahuai iloko o ka halepaahao, i kahi o ka luna koa. ");
INSERT INTO haw1868_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","I ka po hookahi no, moe iho la maua i ka moe, owau a me kela, e like me ka hoike ana mai i ka moe ana i moe ai. ");
INSERT INTO haw1868_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Ilaila kekahi kanaka opiopio me maua, he Hebera, he kauwa ia na ka luna koa; hai aku la maua ia ia, a hai mai la kela ia maua i ke ano o ka maua mau moe. He oiaio ke ano ana i hoike mai ai ia maua. ");
INSERT INTO haw1868_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","E like me kana i hoike mai ai, oiaio no ia. Hoihoiia mai au i ko'u wahi, a kaaweia kela. ");
INSERT INTO haw1868_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Alaila hoouna aku la o Parao, e kii ia Iosepa: hoolalelale ae la lakou ia ia, mai kahi paa mai; kahi ae la oia i ka umiumi, komo iho la ia i ke kapa hou, a hele aku la io Parao la. ");
INSERT INTO haw1868_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Olelo mai la o Parao ia Iosepa, Ua moe au i ka moe, aohe mea nana e hoakaka mai ke ano, ua lohe au nou, aia lohe oe i ka moe, e hiki ia oe ke hai i ke ano. ");
INSERT INTO haw1868_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Olelo aku la o Iosepa ia Parao, i aku la, Aole na'u ia, na ke Akua no e hai lokomaikai mai ia Parao. ");
INSERT INTO haw1868_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","I aku la o Parao ia Iosepa, Ma kuu moe ana, ku aku la au ma kapa o ka muliwai. ");
INSERT INTO haw1868_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Aia hoi, hoea mai la, mai loko mai o ka muliwai, ehiku bipi kaha a maikai ke nana aku, a ai iho la ma kahi weuweu. ");
INSERT INTO haw1868_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Aia hoi, hoea hou mai la, mahope mai o lakou na bipi ehiku he wiwi, a inoino loa ke nana aku, olala ke kino, aole i ikeia ka mea e like me lakou ma ka aina a pau o Aigupita, no ka ino. ");
INSERT INTO haw1868_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Ai iho la na bipi wiwi a olala, i na bipi kaha ehiku i hoea mua mai ai. ");
INSERT INTO haw1868_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","A komo iho la lakou iloko o ko lakou opu, aole hoi i ikeia ko lakou komo ana iloko o ka opu, no ka mea, ua mau no ko lakou ino, e like mamua. A hikilele ae la au. ");
INSERT INTO haw1868_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","A ike aku la au ma kuu moe, aia hoi, ehiku opuu palaoa ma ke kumu hookahi, he ohaha a he maikai. ");
INSERT INTO haw1868_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Aia hoi, kupu hou mai la mahope mai o lakou, ehiku opuu hou, he mimino, he wiwi, a mae i ka makani mai ka hikina mai. ");
INSERT INTO haw1868_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Pau ae la na opuu ohaha maikai ehiku i na opuu wiwi. A hai aku la au i ka poe akamai, aohe mea nana i hoakaka mai. ");
INSERT INTO haw1868_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Olelo aku la o Iosepa ia Parao, O ka moe a Parao, hookahi no ia; ua hoike mai ke Akua ia Parao i kana mea e hana mai ana. ");
INSERT INTO haw1868_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","O ua mau bipi maikai la ehiku, ehiku ia makahiki; a o ua mau opuu palaoa maikai la ehiku, ehiku ia makahiki; hookahi no ia moe. ");
INSERT INTO haw1868_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","A o ua mau bipi wiwi inoino la ehiku, i ea mai ai mahope o lakou, ehiku ia makahiki; a o na opuu palaoa wiwi a mae i ka makani no ka hikina mai, ehiku makahiki ia o ke kau wi. ");
INSERT INTO haw1868_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Eia no ka'u mea i hai aku ai ia Parao: ua hoike mai ke Akua ia Parao i kana mea e hana mai ana. ");
INSERT INTO haw1868_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Aia hoi, e hiki mai ana na makahiki ehiku, he mau makahiki ai nui ma ka aina a pau o Aigupita. ");
INSERT INTO haw1868_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","A mahope iho o lakou, e hiki mai auanei na makahiki ehiku e wi ai, a e poinaia auanei ke ola a pau, ma ka aina i Aigupita, e oki loa ka aina i ka wi. ");
INSERT INTO haw1868_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Aole e ikeia ke ola ma ka aina, no ka wi e hiki ana mahope, no ka mea, e kaumaha loa ia. ");
INSERT INTO haw1868_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Ua papaluaia ka moe a Parao, no ka mea, ua paa ia manao o ke Akua, a ua kokoke e hana io mai no ke Akua. ");
INSERT INTO haw1868_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","No keia mea, pono e imi o Parao i kekahi kanaka naauao a me ke akamai, a e hoonoho ia ia maluna o ka aina o Aigupita a pau loa. ");
INSERT INTO haw1868_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","E pono ia Parao e hoomakaukau, a e hoonoho i poe luna no ka aina, a e ohi lakou i ka hapalima o ka ai ma ka aina o Aigupita, ia mau makahiki momona ehiku: ");
INSERT INTO haw1868_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","A e hoiliili mai lakou i ka ai a pau o na makahiki maikai e hiki mai ana, a e hoahu mai i palaoa malalo o ka lima o Parao, a e malama hoi lakou i ka ai iloko o na kulanakauhale. ");
INSERT INTO haw1868_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","He ai malama ia no ka aina, no na makahiki wi ehiku, e hiki mai ana ma ka aina o Aigupita, i make ole ai ka aina i ka wi. ");
INSERT INTO haw1868_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Ua maikai ia mea i ka maka o Parao, a i ka maka o kana mau kauwa a pau. ");
INSERT INTO haw1868_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Olelo ae la o Parao i kana mau kauwa, E loaa anei ia kakou kekahi kanaka e like me ia nei, ke kanaka iloko ona ka Uhane o ke Akua? ");
INSERT INTO haw1868_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","A olelo aku la o Parao ia Iosepa, No ka mea, ua hoike mai ke Akua ia mea a pau ia oe, aohe mea e ae e like me oe, ka naauao a me ke akamai. ");
INSERT INTO haw1868_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","O oe no maluna o ko'u hale, a ma kau olelo e hoolohe ai ko'u kanaka a pau, aka, o ka nohoalii wale no ka'u maluna ou. ");
INSERT INTO haw1868_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Olelo aku la o Parao ia Iosepa, E nana oe, ua hoonoho au ia oe maluna o ka aina o Aigupita a pau. ");
INSERT INTO haw1868_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Unuhi aku la Parao i ke komo ona, mai kona lima aku, a hookomo aku la i ka lima o Iosepa, a kahiko ae la oia ia ia i ka lole keokeo maikai, a hoolei aku la i ka lei gula ma kona a-i. ");
INSERT INTO haw1868_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Hooholoholo iho la oia ia ia ma ka lua o ke kaa ona, hea mai la lakou imua ona, E kukuli iho. Hoonoho aku la oia ia ia maluna o ka aina a pau o Aigupita. ");
INSERT INTO haw1868_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","I aku la o Parao ia Iosepa, Owau no o Parao. A i ole oe e ae aku, aole loa e hapai kekahi kanaka i kona lima, a me kona wawae, ma ka aina a pau o Aigupita. ");
INSERT INTO haw1868_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Kapa aku la o Parao i ka inoa o Iosepa, o Sapenapanea; a haawi aku la oia ia Asenata, i ke kaikamahine a Potipera a ke kahuna o Ona, i wahine nana. A hele aku la o Iosepa a puni ka aina o Aigupita. ");
INSERT INTO haw1868_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","He kanakolu ko Iosepa mau makahiki, i ka wa ana i ku ai imua o Parao o ke alii o Aigupita. A hoi aku la o Iosepa mai ke alo aku o Parao, a hele aku la i ka aina o Aigupita a pau. ");
INSERT INTO haw1868_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","A i na makahiki ai ehiku, hua mai la ka hua o ka honua a nui loa. ");
INSERT INTO haw1868_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Hoiliili mai la ia i ka ai a pau o na makahiki ehiku ma ka aina o Aigupita, a waiho iho la ia i ka ai maloko o na kulanakauhale, o ka ai o na mahinaai e pili ana i ua kulanakauhale la; waiho iho la ia maloko olaila. ");
INSERT INTO haw1868_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Hoiliili mai la o Iosepa i ka palaoa e like me ke one o ke kai ka nui loa, a oki iho la ka helu no ka hiki ole ke helu aku. ");
INSERT INTO haw1868_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","A hanau iho la ka Iosepa mau keikikane elua, mamua o ka hiki ana o na makahiki wi, na Asenata, ke kaikamahine a Potipera a ke kahuna o Ona i hanau nana. ");
INSERT INTO haw1868_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Kapa aku la o Iosepa i ka inoa o ka hiapo, o Manase, no ka mea, ua haawi mai ke Akua ia'u i ka hoopoina i ko'u luhi, a me na mea a pau o ka hale o ko'u makuakane. ");
INSERT INTO haw1868_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","A o ka inoa o ka muli mai, kapa aku la ia, o Eperaima: No ka mea, ua hoopalahalaha mai ke Akua ia'u, ma ka aina o ko'u popilikia. ");
INSERT INTO haw1868_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Pau ae la na makahiki momona ehiku i hiki mai ai ma ka aina o Aigupita. ");
INSERT INTO haw1868_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Alaila, hiki mai la na makahiki wi ehiku, e like me ka Iosepa i olelo mai ai. He wi no ma na aina a pau, aka, he ai ma na aina a pau i Aigupita. ");
INSERT INTO haw1868_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Oki loa iho la ka aina a pau i Aigupita, i ka wi, a uwe aku la na kanaka ia Parao i ka ai. Olelo aku la o Parao i na kanaka a pau o Aigupita, O hele aku io Iosepa la; a i kana olelo ana mai ia oukou, malaila aku oukou. ");
INSERT INTO haw1868_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","A ua puni i ka wi na aina a pau; a wehe ae la o Iosepa i na halepapaa a pau, a kuai aku la na na kanaka o Aigupita; a ikaika nui mai la ka wi ma ka aina o Aigupita. ");
INSERT INTO haw1868_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","A hele mai la ko na aina a pau i Aigupita io Iosepa la e kuai: no ka mea, ua nui loa ka wi ma na aina a pau. ");
INSERT INTO haw1868_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","A IKE ae la o Iakoba, he ai ma Aigupita, olelo aku la o Iakoba i kana poe keikikane, O ke aha ka oukou e nana aku nei, kekahi i kekahi? ");
INSERT INTO haw1868_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Olelo aku la ia, Aia hoi, ua lohe au, ho ai ma Aigupita, E iho aku oukou ilaila, e kuai i ai na kakou, i ola kakou, aole e make. ");
INSERT INTO haw1868_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Hele aku la ka poe kaikuaana o Iosepa he umi ilalo i Aigupita e kuai i ai. ");
INSERT INTO haw1868_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","A o Beniamina, ke kaikaina o Iosepa, aole o Iakoba i hoouna aku ia ia me kona poe kaikunana, no ka mea, i olelo iho la ia, O poino kela. ");
INSERT INTO haw1868_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Hele pu ae la na keiki a Iseraela iwaena o ka poe hele, e kuai i ai, no ka mea, ua wi loa ka aina o Kanaana. ");
INSERT INTO haw1868_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","O Iosepa no ke kiaaina olaila, a nana no i kuai na na kanaka a pau o ia aina. Hele mai la ka poe kaikuaana o Iosepa, a kulou iho la lakou imua ona, me na maka i ka honua. ");
INSERT INTO haw1868_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","A nana aku la o Iosepa i kona poe kaikuaana, ike ae la oia ia lakou, a hoohuahualau aku oia ia lakou, olelo koikoi aku la oia ia lakou, i aku la ia lakou, Nohea mai oukou? Olelo mai la lakou, No ka aina o Kanaana mai, e kuai i ai. ");
INSERT INTO haw1868_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Ua ike no o Iosepa i kona poe kaikuaana, aole nae lakou i ike ia ia. ");
INSERT INTO haw1868_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Hoomanao iho la o Iosepa i na moe ana i moe ai no lakou, i aku la oia ia lakou, He poe kiu oukou; ua hele mai oukou e nana i ka hemahema o ka aina. ");
INSERT INTO haw1868_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Olelo mai la lakou ia ia, Aole ia, e kuu haku. I hele mai kau poe kauwa e kuai i ai. ");
INSERT INTO haw1868_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","He poe keiki makou a pau na ke kanaka hookahi; he poe kanaka pono, aole he poe kin makou o kau poe kauwa. ");
INSERT INTO haw1868_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Olelo aku la ia ia lakou, Aole, ua hele mai nei oukou e nana i ka hemahema o ka aina. ");
INSERT INTO haw1868_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Olelo mai la lakou, O kau poe kauwa, he umi makou a me kumamalua o ko makou hanauna, na keiki a ke kanaka hookahi i ka aina o Kanaana, aia hoi ka muli loa i keia la me ka makuakane o makou, a o kekahi hoi, aole ia. ");
INSERT INTO haw1868_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Olelo aku la o Iosepa ia lakou, Oia hoi ka'u i olelo aku nei ia oukou, he poe kiu oukou. ");
INSERT INTO haw1868_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","I keia mea e ikea ai oukou, ma ke ola o Parao, aole oukou e hoi aku, ke hiki ole mai ko oukou kaikaina. ");
INSERT INTO haw1868_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","E hoouna ae i kekahi o oukou e kii i ko oukou kaikaina, a e paa oukou, i ikea ka oukou olelo a me ka pono io o oukou, aka, i ole, ma ke ola o Parao, he poe kiu io no oukou. ");
INSERT INTO haw1868_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","A hoakoakoa mai la oia ia lakou a pau iloko o kahi paa, a ekolu la. ");
INSERT INTO haw1868_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","A i ka po akolu, olelo aku la o Iosepa ia lakou, E hana oukou i keia, i ola oukou; ua makau wau i ke Akua. ");
INSERT INTO haw1868_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Ina he poe kanaka pono oukou, e paaia kekahi o oukou i ka halepaahao: e hoi aku oukou e halihali i ai na ka wi o ko oukou mau hale: ");
INSERT INTO haw1868_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","A e lawe mai i ko oukou kaikaina io'u nei, pela e oiaio ai ka oukou olelo, alaila, aole oukou e make. Hana mai la lakou pela. ");
INSERT INTO haw1868_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Olelo ae la lakou kekahi i kekahi, Ua hewa io kakou i ko kakou kaikaina, no ka mea, ua ike kakou i ka ehaeha o kona naau, i ka manawa ana i noi mai ai ia kakou, aole kakou i hoolohe aku; no ia mea, ua hiki mai keia popilikia io kakou nei. ");
INSERT INTO haw1868_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","A olelo aku la o Reubena ia lakou, i aku la, Aole anei au i olelo aku ia oukou, i ka i ana aku, Mai hana hewa aku i ke keiki? Aole oukou i hoolohe mai. Aia hoi, no ia mea, ua imiia mai ko ia la koko. ");
INSERT INTO haw1868_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Aole i ike lakou ua lohe pono o Iosepa ia lakou, no ka mea, ua olelo aku oia ia lakou, ma ke kanaka hoohalike olelo. ");
INSERT INTO haw1868_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Haliu aku la ia, mai o lakou la, a uwe iho la; haliu hou mai la oia ia lakou, kamailio pu me lakou, a lawe mai la oia ia Simeona, mai o lakou mai la, a hana paa iho la ia ia mamua o ko lakou mau maka. ");
INSERT INTO haw1868_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Alaila, kauoha aku la o Iosepa, e uhao i ka ai i na eke a lakou a piha, a e hoihoi i ka moni a lakou iloko o ka lakou mau eke, a e haawi aku i o na lakou no ke alanui. Pela oia i hana aku ai ia lakou. ");
INSERT INTO haw1868_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Hooili ae la lakou i ka ai iluna iho o ko lakou mau hoki, a hele aku la. ");
INSERT INTO haw1868_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","A i ka wehe ana o kekahi i kana eke, e haawi aku i ai na kona hoki, ma kahi oioina, ike ae la ia i kana moni, no ka mea, aia hoi ia ma ka waha o kana eke. ");
INSERT INTO haw1868_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","A olelo aku la ia i kona poe hoahanau, E, ua hoihoiia mai ka'u moni; eia hoi ia iloko o ka'u eke. Hikilele iho la ko lakou naau, haalulu iho la lakou, i aku la kekahi i kekahi, Heaha keia mea a ke Akua i hana mai ai ia kakou? ");
INSERT INTO haw1868_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","A hiki lakou io Iakoba la, i ko lakou makuakane i ka aina o Kanaana, hai aku la lakou ia ia i na mea a pau i loaa'i ia lakou; i aku la, ");
INSERT INTO haw1868_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","O ke kanaka, ka haku o ka aina i olelo koikoi mai ai ia makou; ua kuhi mai kela ia makou, he poe kiu no ka aina. ");
INSERT INTO haw1868_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","A olelo aku la makou ia ia, He poe pono makou; aohe makou he kiu. ");
INSERT INTO haw1868_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","He poe hanauna makou, he umi a me kumamalua, na keiki a ko makou makuakane; aole kekahi, a o ka muli loa, aia no ia i keia la me ko makou makuakane, i ka aina o Kanaana. ");
INSERT INTO haw1868_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","A o ke kanaka, ka haku o ka aina, olelo mai la ia makou, I keia mea e ikeia'i he poe kanaka pono oukou, E waiho mai oukou i kekahi hoahanau o oukou me au, a e lawe i ai na ka wi o ko oukou mau hale, a e hoi aku: ");
INSERT INTO haw1868_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","A e lawe mai oukou i ko oukou kaikaina io'u nei; alaila, ike au ia oukou, aohe kiu, he poe kanaka maikai no oukou; a e kuu aku au ia oukou i ko oukou hoahanau, a e kuai oukou iloko o keia aina. ");
INSERT INTO haw1868_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","A i ka ninini ana aku a lakou i ka lakou mau eke, aia hoi, iloko o na eke a lakou, ka lakou mau laulau moni a pau. A ike ae la lakou a me ko lakou makuakane i na laulau moni, makau nui iho la lakou. ");
INSERT INTO haw1868_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","A olelo mai la o Iakoba ko lakou makuakane ia lakou, Ua hoonele mai oukou ia'u i ka'u mau keiki. O Iosepa, aole ia, a o Simeona, aole ia, a e lawe aku ana oukou ia Beniamina. Ke pale mai nei keia mau mea a pau ia'u. ");
INSERT INTO haw1868_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Olelo aku la o Reubena i kona makuakane, i aku la, E pepehi mai oe i ka'u mau keiki elua, ke hoihoi ole mai au ia ia nei iou la; e haawi mai oe ia ia nei i kuu lima, na'u ia e hoihoi hou mai iou la. ");
INSERT INTO haw1868_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Olelo mai la ia, Aole e iho aku ka'u keiki me oukou ilaila, no ka mea, ua make kona kaikuaana, oia nei wale no koe: ina poino keia, ma ke alanui a oukou e hele ai, alaila, lawe iho oukou i ko'u oho hina i ka lua me ke kaniuhu. ");
INSERT INTO haw1868_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","A OKI loa iho la ka aina i ka wi. ");
INSERT INTO haw1868_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","A pau i ka aiia e lakou ka ai a lakou i lawe mai ai, mai Aigupita mai, olelo mai la ko lakou makuakane ia lakou, O hele hou oukou, e kuai i wahi ai iki na kakou. ");
INSERT INTO haw1868_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","A olelo aku la o Iuda ia ia, i aku la, Ua olelo ikaika mai ua kanaka la ia makou, ua i mai, Aole oukou e ike i kuu maka, ke hele ole mai ko oukou kaikaina me oukou. ");
INSERT INTO haw1868_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","A i hoouna oe i ko makou kaikaina me makou, alaila, hele aku makou ilalo, e kuai i ai nau. ");
INSERT INTO haw1868_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Aka, i hoouna ole oe ia ia, aole makou e hele aku ilalo, no ka mea, ua olelo mai ua kanaka la ia makou, Aole oukou e ike i kuu maka, ke hele ole mai ko oukou kaikaina me oukou. ");
INSERT INTO haw1868_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Olelo mai la o Iseraela, No ke aha la onkou i hana ino mai ai ia'u, i ka hai aku i ua kanaka la i ko oukou kaikaina? ");
INSERT INTO haw1868_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Olelo aku la lakou, I ninau ikaika mai no ua kanaka la ia makou, i ko makou hoahanau, i mai la, Ke ola la no anei ko oukou makuakane? He kaikaina e anei, ko oukou? A hai aku la makou ia ia ma ke ano o keia mau olelo. Ua ike pono anei makou, e i mai ana ia, E lawe mai ilalo nei i ko oukou kaikaina? ");
INSERT INTO haw1868_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Olelo aku la o Iuda ia Iseraela i kona makuakane, E kuu mai oe i ke keiki me au, alaila ku ae makou e hele aku; i ola kakou; aole e make o makou, a o oe, a me ka kakou poe kamalii. ");
INSERT INTO haw1868_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Owau no ka panai nona; ma ko'u lima, e imi mai oe ia ia; i hoihoi ole mai au ia ia iou la, a e hoonoho ia ia mamua ou, no'u mau loa aku no ka hewa. ");
INSERT INTO haw1868_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Ina aole makou i hookaulua, ina ua hoi hou mai makou, mai ka lua o ka hele ana. ");
INSERT INTO haw1868_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Olelo aku la ko lakou makuakane o Iseraela ia lakou, Ina pela mai, e hana i keia; e ahu i ko ka aina hua maikai iloko o ka oukou mau eke, a e lawe aku ilalo i makana na ua kanaka la; i wahi bama iki, a i wahi meli iki, a i mea ala kahi, a me ka mura, a i hua pisetakia, a i alemona. ");
INSERT INTO haw1868_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","A e papalua i na kala ma ko oukou lima; a o ke kala i hoihoiia mai, maloko o ka waha o ka oukou mau eke, e halihali hou aku oukou ia mea, i ko oukou mau lima; malia paha, aole i ikeia. ");
INSERT INTO haw1868_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","E lawe aku hoi oukou i ko oukou kaikaina, a e ku nui iluna, e hele hou aku i ua kanaka la. ");
INSERT INTO haw1868_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","A na ke Akua mana loa e haawi mai ke aloha no oukou mamua o ua kanaka la, i kuu mai ia i kela hoahanau o oukou, a ia Beniamina hoi A i nele au i kuu mau keiki, ua nele au. ");
INSERT INTO haw1868_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Lawe ae la na kanaka i ua makana la, a lawe papalua no hoi lakou i ke kala ma ko lakou lima, a ia Beniamina hoi; ku ae la lakou, a hele aku la ilalo i Aigupita, a ku aku la imua o Iosepa. ");
INSERT INTO haw1868_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","A ike mai la o Iosepa ia Beniamina me lakou, olelo ae la ia i ka luna o kona hale, E alakai oe i keia poe kanaka i ka hale, e kalua i holoholona, a e hoomakaukau hoi; no ka mea, e ai pu keia poe kanaka me au i ke awakea. ");
INSERT INTO haw1868_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Hana mai la ke kanaka e like me ka Iosepa olelo ana ae; a alakai aku la ia i ua poe kanaka la, iloko o ka hale o Iosepa. ");
INSERT INTO haw1868_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Makau iho la ua poe kanaka la, no ka mea, ua alakaiia'ku la lakou iloko o ka hale o Iosepa, a olelo ae la lakou, No ka moni i hoihoiia'i iloko o ka kakou mau eke i ka manawa mamua, nolaila kakou i alakaiia mai ai iloko nei, i hoolawehala mai oia ia kakou a lele mai iluna o kakou, a e hana paa hoi ia kakou, i poe kauwa, a me ko kakou mau hoki. ");
INSERT INTO haw1868_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Hookokoke aku la lakou i ka luna o ko Iosepa hale, a kamailio pu lakou me ia ma ka puka o ka hale; ");
INSERT INTO haw1868_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","I aku la lakou, E kuu haku e, i ko makou hele ana mai mamua, ua hele mai makou e kuai i ai. ");
INSERT INTO haw1868_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","A hiki aku la makou i kahi oioina, wehe ae la makou i ka makou mau eke, aia hoi ka moni a pau a makou iloko o ka waha o na eke a makou. A ua halihali hou mai makou ia mea ma ko makou mau lima. ");
INSERT INTO haw1868_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","A ua halihali mai no hoi makou ilalo nei i na moni e ae ma ko makou mau lima e kuai i ai; aole ike makou i ka mea nana i waiho ka moni a makou iloko o ka makou mau eke. ");
INSERT INTO haw1868_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Olelo mai la kela, Aloha oukou, mai makau; na ko oukou Akua, ke Akua o ko oukou makuakane, nana i haawi ka waiwai na oukou iloko o ka oukou mau eke: ua hiki mai ka oukou moni ia'u. Alakai mai la oia ia Simeona io lakou la. ");
INSERT INTO haw1868_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Alakai ae la ua kanaka la i ka poe kanaka iloko o ko Iosepa hale, a haawi mai la ia lakou i ka wai, holoi iho la lakou i ko lakou mau wawae, a haawi mai la hoi ia i ai na na hoki o lakou. ");
INSERT INTO haw1868_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Hoomakaukau iho la lakou i ka makana i ka hele ana mai o Iosepa i ke awakea; no ka mea, ua lohe lakou, e ai ana lakou i ka ai ilaila. ");
INSERT INTO haw1868_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","A hoi mai la o Iosepa i kona hale, halihali mai la lakou iloko o ka hale i ka makana nana, na ko lakou lima i paa ai, a kulou iho la lakou imua ona ilalo i ka honua. ");
INSERT INTO haw1868_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Ninau mai la ia ia lakou i ko lakou noho ana, i aku la, Pehea ko oukou makuakane, o ka elemakule a oukou i olelo mai ai? Ke ola la no ia, ea? ");
INSERT INTO haw1868_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Olelo aku la lakou, E noho pomaikai ana no kau kauwa, ka makuakane o makou, ke ola la no ia. A kulou iho la lakou a moe ilalo. ");
INSERT INTO haw1868_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Alawa ae la kona maka iluna, ike mai la i kona kaikaina ia Beniamina, ke keiki a kona makuwahine ponoi, a i mai la ia, O ko oukou kaikaina anei keia, a oukou i olelo mai ai ia'u? A olelo ae la hoi ia, E aloha mai ke Akua ia oe, e kuu keiki. ");
INSERT INTO haw1868_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Wikiwiki ae la o Iosepa; no ka mea, ua mokumokuahua kona manawa i kona kaikaina, imi ae la ia i kahi e uwe ai; komo ae la ia i kona keena maluna, a uwe iho la ilaila. ");
INSERT INTO haw1868_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Holoi ae la ia i kona maka, hele aku la iwaho, a uumi iho la ia i kona aloha, a olelo aku la, E ho mai i ka ai. ");
INSERT INTO haw1868_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Kau mai la lakou nana ma ke kaawale, a na lakou ma ke kaawale, a na ko Aigupita i ai pu me ia ma ke kaawale; no ka mea, aole e hiki i ko Aigupita, ke ai pu me na Hebera, he mea haumia ia i ko Aigupita. ");
INSERT INTO haw1868_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Noho iho la lakou imua ona, o ka hiapo e like me kona hanau mua ana, a o ka muli loa e like me kona hanau muli ana mai. Kahaha iho la ko lakou naau kekahi i kekahi. ");
INSERT INTO haw1868_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Lalau ae la ia i ka ai a haawi aku la ia lakou, mai kona alo aku, ua palimaia ka Beniamina i ka lakou. Inu pu lakou a olioli me ia. ");
INSERT INTO haw1868_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","A KAUOHA aku la ia i ka luna o kona hale, i aku la, E uhao i ka ai iloko o na eke a ua mau kanaka la a piha, a e waiho i ka moni a lakou a pau maloko o ka waha o ka lakou mau eke. ");
INSERT INTO haw1868_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","A e uhao hoi i kuu kiaha, i ke kiaha kala maloko o ka waha o ka eke a ka mea opiopio loa, a me kana moni no ka ai. Hana mai la kela ma ka olelo a Iosepa i olelo aku ai. ");
INSERT INTO haw1868_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","A ao ae la, ua hoihoiia'ku la ua poe kanaka la, a me ko lakou mau hoki. ");
INSERT INTO haw1868_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","A puka aku la lakou mawaho o ke kulanakauhale, aole i hiki i kahi loihi, alaila olelo aku la o Iosepa i kana luna, E ku oe, e alualu aku i ua poe kanaka la, a loaa lakou ia oe, e i aku ia lakou, No ke aha oukou i hoihoi mai ai i ka hewa no ka pono? ");
INSERT INTO haw1868_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Aole anei keia o ka mea a ka'u haku i inu ai iloko? a i kilo ai hoi? Ua hewa oukou i ka hana ana pela. ");
INSERT INTO haw1868_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","A hiki aku la ia io lakou la, olelo aku la ia ia lakou i keia mau olelo. ");
INSERT INTO haw1868_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Ninau mai la lakou ia ia, No ke aha la i olelo mai ai kuu haku i keia olelo? Aole loa e hiki i kou poe kauwa ke hana e like me ia. ");
INSERT INTO haw1868_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Eia hoi, o ka moni a makou i loaa'i iloko o ka waha o ka makou mau eke, ua halihali hou mai makou ia nei ia oe mai loko mai o ka aina o Kanaana, Pehea hoi makou i aihue ai i ke kala, a i ke gula, noloko mai o ka hale o kou haku? ");
INSERT INTO haw1868_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","A i ikeia ia mea i kekahi o kou poe kauwa, e make ia, a e lilo makou i poe kauwa na kou haku. ");
INSERT INTO haw1868_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Olelo aku la ia, Ae, e like me ka oukou olelo, pela no ia: o ka mea ua loaa me ke kiaha, e lilo ia i kauwa na'u, a e hala ole oukou. ");
INSERT INTO haw1868_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Kuu koke iho la lakou a pau i ka lakou mau eke ilalo i ka honua, a wehe ae la lakou i ka lakou mau eke. ");
INSERT INTO haw1868_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","A imi iho la kela, a hoomaka iho la ma ka hiapo, a oki ae la ma ka muli loa, a loaa mai la ke kiaha ma ka eke a Beniamina. ");
INSERT INTO haw1868_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Alaila haehae iho la lakou i ko lakou mau kapa, a kau aku la kela kanaka keia kanaka i ka ukana ma kana hoki, a hoi aku la i ke kulanakauhale. ");
INSERT INTO haw1868_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","A hele aku la o Iuda a me kona poe hoahanau i ka hale o Iosepa, aia no ia; a moe iho la lakou imua ona ilalo i ka honua. ");
INSERT INTO haw1868_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Ninau aku la o Iosepa ia lakou, Heaha keia mea a oukou i hana mai nei? Aole anei oukou i ike, e hiki i ke kanaka me a'u nei e kilokilo aku? ");
INSERT INTO haw1868_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Olelo aku la o Iuda, Pehea la makou e pane aku ai ia oe, e kuu haku? Heaha ka makou e olelo aku ai? Pehea makou e hoapono ai ia makou iho? Ua loaa i ke Akua ka hewa o kau poe kauwa; eia hoi, he poe kauwa makou na ko'u haku. o makou, a me ka mea i loaa ke kiaha ma koua lima. ");
INSERT INTO haw1868_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Olelo mai la o Iosepa, Aole loa e hiki ia'u ke hana pela; aka, o ke kanaka, i loaa'i ke kiaha i kona lima, e lilo ia i kauwa na'u: a o oukou, e hoi aku me ka maluhia i ko oukou makuakane. ");
INSERT INTO haw1868_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Alaila neenee aku la o Iuda io na la, i aku la, Auwe, e kuu haku e! Ina e ae mai kuu haku i kana kauwa nei, ke hai aku i kekahi olelo ma kona pepeiao, aole hoi e wela mai kou huhu i kau kauwa, no ka mea, ua like oe me Parao. ");
INSERT INTO haw1868_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Ninau mai la kuu haku i kau poe kauwa nei, i mai la, He makuakane anei ko oukou, a he kaikaina anei? ");
INSERT INTO haw1868_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","A olelo aku la makou i kuu haku, He makuakane no ko makou, he kanaka kahiko, a me kahi keiki o kona wa elemakule, he mea nuku; a o kona kaikuaana, ua make ia, oia wale no ka i koe a kona makuwahine, a ua aloha kona makuakane ia ia. ");
INSERT INTO haw1868_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","A olelo mai la oe i kau poe kauwa, E lawe mai ia ia ilalo io'u nei, i ike aku kuu maka ia ia. ");
INSERT INTO haw1868_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Alaila olelo aku la makou ia oe i kuu haku, Aole e hiki i ke keiki ke haalele i kona makuakane; no ka mea, ina e haalele ke keiki i kona makuakane, e make no ia. ");
INSERT INTO haw1868_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","A olelo mai la oe i kau poe kauwa, A i hele ole mai ko oukou kaikaina me oukou, aole oukou e ike hou mai i kuu maka. ");
INSERT INTO haw1868_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","A hiki aku la makou i kau kauwa i ko'u makuakane, hai aku la makou ia ia i ka olelo a kuu haku. ");
INSERT INTO haw1868_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","A olelo mai la ko makou makuakane, O hele hou oukou e kuai i wahi ai iki na kakou. ");
INSERT INTO haw1868_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Olelo aku makou, Aole loa makou e hiki ke hele ilalo; aka, i hele pu ko makou kaikaina me makou, alaila e hele aku makou ilalo, no ka mea, aole e hiki ia makou ke ike aku i ka maka o ua kanaka la, ke hele pu ole ko makou kaikaina me makou. ");
INSERT INTO haw1868_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Alaila olelo mai la kau kauwa o ko'u makuakane ia makou, Ua ike oukou, ua hanau mai la ka'u wahine i na keiki elua na'u. ");
INSERT INTO haw1868_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","A hele aku la kekahi mai o'u aku nei, a i aku la au, He oiaio no ua weluwelu ia; aole hoi au i ike hou aku ia ia. ");
INSERT INTO haw1868_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","A i lawe aku oukou ia ia nei, mai o'u aku nei, a loohia ia i ka poino, alaila, e lawe aku oukou i ko'u oho hina ilalo i ka lua me ke kaniuhu. ");
INSERT INTO haw1868_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","No keia mea hoi, ke hiki aku au i kau kauwa i ko'u makuakane, aole ke keiki me makou, ua pai pu ia kona ola me ke ola o ke Keiki; ");
INSERT INTO haw1868_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","A ike mai ia, aole ke keiki me makou, alaila, e make ia; a e lawe iho o kau poe kauwa i ke oho hina o kau kauwa o ko makou makuakane ilalo i ka lua me ke kaniuhu. ");
INSERT INTO haw1868_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","No ka mea, ua hoohiki au ia'u iho no ke keiki i ko'u makuakane, ua i aku au, A i hoihoi ole mai au ia ia iou la, no'u mau loa aku no ka hewa imua o ko'u makuakane. ");
INSERT INTO haw1868_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","No keia mea hoi, e ae mai oe ia'u i noho au, kau kauwa i panai no ke keiki, i kanwa na kuu haku; e hoi aku hoi ke keiki me kona poe kaikuaana. ");
INSERT INTO haw1868_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","No ka mea, pehea la au e hoi aku ai i kuu makuakane, aole ke keiki me au? o ike auanei au i ka mea ino e hiki mai ana maluna o kuu makuakane. ");
INSERT INTO haw1868_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","A LAILA aole e hiki ia Iosepa ke uumi iho i ke aloha iloko ona imua o lakou a pau, o ka poe i ku pu mai la me ia: a hea aku la ia, E hele aku na kanaka a pau iwaho, mai o'u aku nei. Aole i noho mai kekahi kanaka me ia, i ka manawa a Iosepa i hoike ai ia ia iho i kona poe hoahanau. ");
INSERT INTO haw1868_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Hooho ae la ia i kona leo me ka uwe nui ana: a lohe ae la na kanaka o Aigupita a lohe pu no ko ka hale o Parao. ");
INSERT INTO haw1868_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Olelo aku la o Iosepa i kona poe hoahanau, Owau no o Iosepa; ke ola la no anei ko'u makuakane? Aole i hiki ke ekemu iki mai kona poe hoahanau ia ia: no ka mea, makau nui iho lakou imua ona. ");
INSERT INTO haw1868_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","A olelo aku la o Iosepa i kona poe hoahanau, E neenee mai oukou io'u nei. A neenee mai la lakou. Olelo aku la ia, Owau no o Iosepa, ko oukou kaikaina a oukou i kuai ai iloko o Aigupita. ");
INSERT INTO haw1868_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Eia hoi, mai hookaumaha oukou, aole hoi e huhu oukou ia oukou iho i ka oukou kuai ana ia'u ia nei. No ka mea, na ke Akua au i hoouna mai mamua o oukou e hoola aku. ");
INSERT INTO haw1868_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","No ka mea, ua wi ae nei ka aina i keia mau makahiki elua; a elima hoi makahiki e koe, aole e mahi, aole hoi e ohi mai. ");
INSERT INTO haw1868_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","A ua hoouna mai ke Akua ia'u mamua o oukou, e hookoe aku ia oukou ma ka honua, a e hoola ia oukou i ke ola nui. ");
INSERT INTO haw1868_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Aia hoi, aole na oukou i hoouna mai au ia nei, na ke Akua no, a ua hoolilo ae ia ia'u i makuakane no Parao, a i haku no kona hale a pau, a i kiaaina no Aigupita a pau. ");
INSERT INTO haw1868_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","E wikiwiki oukou, e hoi aku i ko'u makuakane, a e i aku ia ia, Penei i olelo mai ai kau keiki o Iosepa, Ua hoolilo mai ke Akua ia'u, i haku no ka aina o Aigupita a pau; e hele mai oe ilalo io'u nei, mai hookaulua aku oe. ");
INSERT INTO haw1868_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","A e noho oe ma ka aina o Gosena, a e kokoke mai oe me au, o oe, a me kau poe keiki, a me kau poe moopuna, a o kau poe hipa a me kau poe holoholona a me kou mea a pau loa. ");
INSERT INTO haw1868_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Ilaila au e malama'i ia oe: no ka mea, elima makahiki wi a koe; o ilihune oe, a me ko ka hale ou, a me kau mau mea a pau. ");
INSERT INTO haw1868_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Aia hoi, ua ike ko oukou mau maka, a me ka maka o ko'u kaikaina, o Beniamina, o ko'u waha no ka i olelo aku ia oukou. ");
INSERT INTO haw1868_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","A e hai aku oukou i ko'u makuakane i kuu hanohano a pau ma Aigupita nei, a i na mea a pau a oukou i ike ai: a e wikiwiki oukou e lawe mai i ko'u makuakane ilalo. ");
INSERT INTO haw1868_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Kau iho la ia ma ka a-i o kona kaikaina, o Beniamina, a uwe iho la; a uwe iho la hoi o Beniamina ma kona a-i. ");
INSERT INTO haw1868_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Honi aku la o Iosepa i kona poe hoahanau a pau, a uwe iho la iluna o lakou. A mahope iho o ia mea, kamailio pu kona poe hoahanau me ia. ");
INSERT INTO haw1868_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Lohea iho la keia mea ma ka hale o Parao, oleloia iho la, Ua hiki mai na hoahanau o Iosepa. Ua pono hoi ia i na maka o Parao, a i na maka o kana poe kauwa. ");
INSERT INTO haw1868_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Olelo mai la o Parao ia Iosepa, E i aku oe i kou poe hoahanau, E hana peneia, e kau i ko oukou mea ma na hoki a hoi aku a hiki i ka aina o Kanaana. ");
INSERT INTO haw1868_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","E kii i ko oukou makuakane, a me na mea o ko oukou hale, a e hele mai io'u nei, a na'u no e haawi aku na oukou i ka maikai o ka aina o Aigupita, a e ai hoi oukou i ka momona o ka aina. ");
INSERT INTO haw1868_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Ua kauohaia oe, e hana hoi i keia, E lawe i mau kaa no oukou, mai ka aina o Aigupita aku, no ka oukou kamalii a no ka oukou wahine, a e kii i ko oukou makuakane, a e hele mai. ");
INSERT INTO haw1868_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Mai aua ko oukou mau maka ma ko oukou mea a pau; no ka mea, no oukou ka maikai o ka aina a pau ma Aigupita. ");
INSERT INTO haw1868_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","A hana iho la na keiki a Iseraela pela; a haawi aku la o Iosepa ia lakou i mau kaa e like me ka olelo a Parao, a haawi no hoi i o na lakou ma ke ala. ");
INSERT INTO haw1868_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Haawi aku la hoi ia i kapa komo no lakou a pau; a ia Beniamina, haawi aku la oia ia ia, i ekolu haneri moni, a me na kapa komo elima. ");
INSERT INTO haw1868_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","A hoouna aku la ia no kona makuakane, he umi na hoki e lawe ana i na mea maikai o Aigupita, a he umi na hoki wahine, e lawe ana i ka palaoa a me ka ai i o na kona makuakane ma ke alanui. ");
INSERT INTO haw1868_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Pela hoi i hoouna aku ai oia i kona poe hoahanau, a hoi aku la lakou. Olelo aku ia ia lakou, Mai paio oukou ma ke alanui. ");
INSERT INTO haw1868_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","A hoi aku la lakou, mai waho mai o Aigupita, a hiki aku la i ka aina o Kanaana, ia Iakoba, i ko lakou makuakane. ");
INSERT INTO haw1868_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","A hai aku la lakou ia ia, i aku la, E, ke ola la no o Iosepa, oia ke kiaaina o ka aina o Aigupita a pau. A maule iho la ko Iakoba naau, no ka mea, aole kela i manaoio i ka. ");
INSERT INTO haw1868_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Alaila, hai aku la lakou ia ia i ka olelo a pau a Iosepa i olelo mai ai ia lakou. A ike aku la ia i na kaa a Iosepa i hoouna mai ai e lawe ia ia, pohala iho la ka naau o ko lakou makuakane. ");
INSERT INTO haw1868_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","A olelo aku la Iseraela, Ua nui ia, na ola o Iosepa kuu keiki; e hele aku au e ike ia ia mamua o kuu make ana. ");
INSERT INTO haw1868_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","HELE mai la o Iseraela me kana mau mea a pau loa, a hiki mai la i Beereseba, a mohai aku la ia i na mohai i ke Akua o kona makuakane o Isaaka. ");
INSERT INTO haw1868_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Olelo mai la ke Akua ia Iseraela ma ka hihio i ka po, i mai la, E Iakoba, e Iakoba. I aku la keia, Eia no wau. ");
INSERT INTO haw1868_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","I mai la kela, Owau no ke Akua, o ke Akua o kou makuakane: mai makau oe ke iho ilalo i Aigupita; no ka mea, e hoolilo au ia oe i lahuikanaka nui malaila. ");
INSERT INTO haw1868_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","A e iho pu aku no au me oe i Aigupita; e oiaio no hoi, e lawe hou mai au ia oe malaila mai, a e kau no o Iosepa i kona lima ma kou mau maka. ");
INSERT INTO haw1868_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Ala mai la o Iakoba mai Beereseba mai, a lawe ae la na keiki a Iseraela ia Iakoba, ko lakou makuakane, a me na kamalii, a me ka lakou mau wahine maluna o na kaa a Parao i hoouna aku ai e lawe ia lakou. ");
INSERT INTO haw1868_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Lawe ae la lakou i ka lakou mau holoholona, a me ka waiwai a lakou i loaa ai ma ka aina ma Kanaana, a hele mai i Aigupita; o Iakoba, lakou pu me na keiki ana a pau: ");
INSERT INTO haw1868_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","O kana mau keikikane, a me ka lakou mau keikikane me ia, o kana mau kaikamahine, a me na kaikamahine a kana mau keikikane, a me kana mau hua a pau kana i lawe pu mai ai me ia i Aigupita. ");
INSERT INTO haw1868_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Eia na inoa o na keikikane a Iseraela i hele i Aigupita; o Iakoba a me kana mau keikikane: o Reubena, ka Iakoba makahiapo. ");
INSERT INTO haw1868_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","A o na keikikane a Reubena; o Hanoka, o Palu, o Hezerona, a o Karemi. ");
INSERT INTO haw1868_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","O na keikikane a Simeona; o Iemuela, o Iamina, o Ohada, o Iakina, o Zohara, a o Saula, ke keiki a kekahi wahine no Kanaana. ");
INSERT INTO haw1868_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","O na keikikane a Levi; o Geresona, o Kohata, a o Merari. ");
INSERT INTO haw1868_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","O na keikikane a Iuda; o Era, o Onana, o Sela, o Pareza, a o Zara: aka, make iho la o Era laua o Onana ma ka aina o Kanaana. A o na keikikane a Pareza; o Hezerona a o Hamula. ");
INSERT INTO haw1868_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","O na keikikane a Isakara; o Tola, o Puva, o Ioba a o Simerona. ");
INSERT INTO haw1868_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","O na keikikane a Zebuluna; o Sereda, o Elona a o Iahelela. ");
INSERT INTO haw1868_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","O lakou na keikikane a Lea, ana i hanau ai na Iakoba ma Padanarama, a me kana kaikamahine o Dina: o kana poe keikikane a pau a me na kaikamahine, he kanakolukumamakolu o lakou. ");
INSERT INTO haw1868_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","O na keikikane a Gada; o Zipiona, o Hagi, o Suni, o Ezebona, o Eri, o Arodi, a o Areli. ");
INSERT INTO haw1868_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","O na keikikane a Asera; o Iimena, o Isua, o Isui, o Beria, a o Sera ko lakou kaikuwahine: a o na keikikane a Beria; o Hebera, a o Malekiela, ");
INSERT INTO haw1868_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","O lakou na keikikane a Zilepa, a Labana i haawi aku ai i kana kaikamahine ia Lea: a o lakou kana i hanau ai na Iakoba, he poe umikumamaono. ");
INSERT INTO haw1868_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","O na keikikane a Rahela a ka wahine na Iakoba: o Iosepa, a o Beniamina. ");
INSERT INTO haw1868_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","A ua hanau na Iosepa ma ka aina o Aigupita, o Manase a o Eperaima, a Asenata a ke kaikamahine na Potipera ke kahuna no Ona, i hanau ai nana. ");
INSERT INTO haw1868_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","A o na keikikane a Beniamina; o Bela, o Bekera, o Asebela, o Gera, o Naamana, o Ehi, o Rosa, o Mupima, o Hupima, a o Areda. ");
INSERT INTO haw1868_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","O lakou na keiki a Rahela i hanau na Iakoba: a o lakou a pau, he umikumamaha. ");
INSERT INTO haw1868_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","O na keikikane a Dana; o na Husima. ");
INSERT INTO haw1868_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","O na keiki a Napetali; o Iahezela, o Guni, o Iezera, a o Silema. ");
INSERT INTO haw1868_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","O lakou na keikikane a Bileha, a Labana i haawi aku ai na Rahela na kana kaikamahine; a hanau mai la oia ia laua na Iakoba: a o lakou a pau, ehiku lakou. ");
INSERT INTO haw1868_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","O na kanaka a pau i hele pu me Iakoba i Aigupita, o ka poe mai loko mai o kona puhaka; kanaono lakou, a me kumamaono, aole hoi i heluia na wahine a kana mau keiki. ");
INSERT INTO haw1868_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","A o na keiki a Iosepa, i hanauia nana ma Aigupita, elua laua. O na kanaka a pau ma ka hale o Iakoba i hele mai i Aigupita, kanahiku lakou. ");
INSERT INTO haw1868_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","A hoouna aku la oia ia Iuda, mamua ona io Iosepa la, e kuhiknhi aku mamua ona i Gosena; a hiki mai la lakou i ka aina o Gosena. ");
INSERT INTO haw1868_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","A hoomakaukau ae la o Iosepa i ke kaa ona, pii aku la ia e halawai me Iseraela, me kona makuakane i Gosena, a ike aku la oia ia ia, kau iho la ia ma kona a-i, a uwe iho la ma kona a-i, a liuliu wale. ");
INSERT INTO haw1868_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Olelo aku la o Iseraela ia Iosepa, Ano, e pono ia'u ka make, no kuu ike ana i kou maka, no ka mea, e ola ana oe. ");
INSERT INTO haw1868_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Olelo aku la o Iosepa i kona poe hoahanau a me ka poe o kona makuakane, E, e pii aku au, e hoakaka aku ia Parao, a e hai aku au ia ia; O ko'u poe hoahanau, a me ka poe o ko'u makuakane i noho ai i ka aina o Kanaana, ua hele mai io'u nei: ");
INSERT INTO haw1868_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","He poe kanaka malama hipa lakou, he poe kanaka hanai holoholona, a ua hele mai lakou me ka lakou hipa, a me ka lakou holoholona, a me ka lakou mea a pau. ");
INSERT INTO haw1868_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","A hiki i ka wa e hea mai ai o Parao ia oukou, a e ninau mai, Heaha ka oukou oihana? ");
INSERT INTO haw1868_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Alaila, e olelo aku, He poe kanaka hanai holoholona kau mau kauwa nei, mai ka wa kamalii mai, o makou, a me ko makou poe makua: i noho ai oukou ma ka aina, ma Gosena, no ka mea, he haumia i ko Aigupita, na kahuhipa a pau. ");
INSERT INTO haw1868_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","HELE ae la o Iosepa, hai aku la ia Parao, i aku la, Ua hiki mai nei ko'u makuakane a me ko'u poe hanauna, a me ka lakou hipa, a me ka lakou holoholona, a me ka lakou mea a pau, mai ka aina mai o Kanaana, aia hoi lakou ma ka aina, i Gosena. ");
INSERT INTO haw1868_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Lawe ae la ia i elima o kona poe hanauna, hoonoho iho la ia lakou imua o Parao. ");
INSERT INTO haw1868_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Olelo mai la o Parao i na hoahanau o Iosepa, Heaha ka oukou oihana? I mai la lakou ia Parao, He poe kahuhipa kau poe kauwa nei, o makou a me ko makou poe makua. ");
INSERT INTO haw1868_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","I hou mai la lakou ia Parao, Ua hele mai nei makou e noho ma keia aina, no ka mea, aole ai na ka poe holoholona a kau poe kauwa, no ka nui o ka wi ma ka aina o Kanaana. No ia mea, ke noi aku nei makou ia oe, e noho makou ma ka aina i Gosena. ");
INSERT INTO haw1868_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","A olelo mai la o Parao ia Iosepa, i mai la, Ua hiki mai iou la kou makuakane a me na hoahanau ou. ");
INSERT INTO haw1868_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","O ka aina o Aigupita, eia no ia imua ou: i ka aina maikai nui, e hoonoho ai oe i kou makuakane a me na hoahanau ou: e noho iho lakou i ka aina o Gosena. A ina i ike oe i na kanaka akamai o lakou, e hoonoho oe ia lakou i mau kahu no ka'u poe holoholona, ");
INSERT INTO haw1868_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Alakai mai la o Iosepa ia Iakoba i kona makuakane, a hoonoho mai la ia ia imua o Parao. Hoomaikai aku la o Iakoba ia Parao. ");
INSERT INTO haw1868_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Ninau mai la o Parao ia Iakoba, Ehia la na makahiki o kou ola ana? ");
INSERT INTO haw1868_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","I aku la o Iakoba ia Parao, O na la o ko'u mau makahiki i noho malihini ai, hookahi ia haneri makahiki a me kanakolu. He hapa a he ino hoi na la o ko'u mau makahiki e ola nei; aole nae i loaa ia'u na la a me na makahiki o ko'u poe kupuna i ko lakou noho malihini ana. ");
INSERT INTO haw1868_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Hoomaikai aku la o Iakoba ia Parao, a hele aku la mai ke alo aku o Parao. ");
INSERT INTO haw1868_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Hoonoho iho la o Iosepa i kona makuakane a me kona poe hoahanau, a haawi aku la oia ia lakou i wahi e noho ai ma ka aina o Aigupita, i kahi aina maikai, i ka aina o Ramese, e like me ke kanoha ana mai a Parao. ");
INSERT INTO haw1868_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Malama aku la o Iosepa i kona makuakane, a me kona poe hoahanau, a me ka ohana a kona makuakane a pau i ka ai, e like me na waha o ka ohana. ");
INSERT INTO haw1868_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Aole ai ma ka aina a pau, no ka mea, ua hanahana loa ka wi. Oki loa iho la ka aina o Aigupita a me ka aina o Kanaana i ka wi. ");
INSERT INTO haw1868_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Hooiliili iho la o Iosepa i ke kala a pau loa ma ka aina o Aigupita, a ma ka aina o Kanaana, no ka ai a lakou i kuai ai; a lawe mai la o Iosepa i ke kala iloko o ka hale o Parao. ");
INSERT INTO haw1868_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Pau iho la ko kala ma ka aina o Aigupita, a ma ka aina o Kanaana, a hele mai la ko Aigupita a pau io Iosepa la, i mai la, Ho mai i ai na makou, no ke aha la makou e make ai imua o kou alo i ka pau ana o ke kala? ");
INSERT INTO haw1868_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","I mai la Iosepa ia lakou, Ina i pau ke kala, ho mai i ka oukou holoholona, a e haawi aku au i ai na oukou no ka oukou holoholona. ");
INSERT INTO haw1868_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Lawe mai la lakou i ka lakou holoholona ia Iosepa, a haawi aku la o Iosepa i ai na iakou, no na lio, a no na hipa, a no na bipi, a no na hoki, a malama aku la oia ia lakou i ka ai ia makahiki, no ka lakou holoholona. ");
INSERT INTO haw1868_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","A pau ae la ia makahiki, hele mai la lakou ia ia, i ka lua o na makahiki, i mai la ia ia, Aole makou e huna mai ko makou haku aku, i ka pau ana o ko makou kala, a me ka makou holoholona ia oe i ko makou haku. Aohe mea i koe imua ou, o ko makou kino, a me ko makou aina wale no. ");
INSERT INTO haw1868_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","No ke aha la makou e make ai imua o kou mau maka, o makou a me ko makou aina! E kuai oe ia makou a me ko makou aina, no ka ai, a lilo makou a me ko makou aina i kauwa na Parao. E haawi mai hoi i hua, i ola makou, sole hoi e make, i ole ai e neoneo ka aina. ");
INSERT INTO haw1868_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Kuai iho la o Iosepa i ka aina a pau i Aigupita no Parao, no ka mea, kuai aku la na kanaka a pau o Aigupita i ko lakou aina, no ka mea, ua hauahana loa ka wi maluna o lakou, a lilo ae la ka aina no Parao. ");
INSERT INTO haw1868_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","A lawe ae la ia i kanaka o kekahi kihi, a hoonoho ia lakou ma na kulanakauhale ma kela kihi o ka aina. ");
INSERT INTO haw1868_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","O ka aina o na kahuna, aole ia i kuai, no ka mea, na Parao mai, ka na kahuna, a ai iho la lakou i ka mea a Parao i haawi mai ai na lakou, no ia mea, aole lakou i kuai i ko lakou aina. ");
INSERT INTO haw1868_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Olelo iho o Iosepa i kanaka, Eia hoi, ua kuai au ia oukou i keia la no Parao, a me ko oukou aina; eia no ka hua na oukou e kanu i ka aina. ");
INSERT INTO haw1868_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Eia hoi kekahi, i ka hua ana mai, e haawi oukou i ka hapalima na Parao, a koe no eha mau hapa na oukou, i mea kanu o ka aina, a i mea ai na oukou, a na ko oukou kanaka, a i mea ai hoi na ka oukou kamalii. ");
INSERT INTO haw1868_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","I mai la lakou, Ua hoola mai oe ia makou, ina e loaa ia makou ka lokomaikaiia mai imua o na maka o ko'u haku, a e lilo auanei makou i poe kauwa na Parao. ");
INSERT INTO haw1868_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Hoopaa iho la o Iosepa ia mea i kanawai, mai ia manawa mai, ma ka aina o Aigupita, na Parao ka hapalima o ka ai; o ka aina o na kahuna wale no ka i koe, aole ia i lilo na Parao. ");
INSERT INTO haw1868_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Noho iho la o Iseraela, ma ka aina o Aigupita, i ka aina o Gosena, a loaa mai la ia lakou ka waiwai ilaila, a hanau mai la lakou, a lilo ae la i poe nui loa. ");
INSERT INTO haw1868_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","O na makahiki o ka noho ana o Iakoba i ka aina o Aigupita, he umikumamahiku: a o na makahiki a pau o ke ola ana o Iakoba, hookahi haneri makahiki a me kanahakumamahiku. ");
INSERT INTO haw1868_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","A kokoke aku la ka la e make ai o Iseraela, hea aku la ia i kana keiki ia Iosepa, i aku la ia ia, Ina i loaa mai ia'u ke alohaia imua o kou maka, e kau mai oe i kou lima malalo o ko'u uha. a e hana mai oe ia'u ma ka lokomaikai a me ka oiaio; ea, mai kanu oe ia'u ma Aigupita nei. ");
INSERT INTO haw1868_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","E moe au me o'u mau makua. E lawe oe ia'u mai Aigupita aku, a e kanu ia'u ma ko lakou ilina. I mai la kela, E hana no wau e like mo kau olelo. ");
INSERT INTO haw1868_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","I aku la keia, E hoohiki mai oe ia'u, a hoohiki iho la kela, a kulou hoomana iho la o Iseraela ma ke poo o kona wahi moe. ");
INSERT INTO haw1868_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","A MAHOPE iho o keia mau mea, hai aku la kekahi ia Iosepa, Ua mai kou makuakane. Lawe ae la ia i kana mau keikikane, ia Manase laua o Eperaima. ");
INSERT INTO haw1868_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","A hai ae la kekahi ia Iakoba, i ae la, Eia ae kau keiki o Iosepa, ke hele mai la iou nei. Hooikaika ae la o Iseraela, a noho iho la ma kahi moe. ");
INSERT INTO haw1868_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Olelo aku la o Iakoba ia Iosepa, Ikea mai la ke Akua mana ia'u ma Luza, ma ka aina o Kanaana, a hoomaikai mai la ia ia'u. ");
INSERT INTO haw1868_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","I mai la, E hoomahuahua aku au ia oe; a e hoonui aku ia oe, a e hoolilo ia oe i lahuikanaka nui loa, a e haawi aku i keia aina, no kau poe mamo mahope ou, i hooilina mau loa. ");
INSERT INTO haw1868_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","A o na keiki au elua, i hanauia mai nau ma ka aiua i Aigupita nei, i ka wa mamua aku o ko'u hele ana mai ia oe i Aigupita nei, na'u no laua. O Eperaima a o Manase, e like me Reubena a me Simeona, pela no laua na'u. ");
INSERT INTO haw1868_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","A o kau mau keiki i hanauia mai nau, mahope mai o laua e kapaia lakou ma ka inoa o ko lakou mau kaikuaana ma ko lakou noho ana. ");
INSERT INTO haw1868_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","I ko'u hele ana mai, mai Padana mai, make ae la o Rahela ma ko'u aoao, ma ka aina o Kanaana, ma ke ala, kokoke e hiki aku i Eperata, a kanu iho la au ia ia malaila ma ke ala ma Eperata, oia hoi o Betelehema. ");
INSERT INTO haw1868_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","A ike aku la o Iseraela i na keiki a Iosepa, ninau aku la ia, Owai laua nei? ");
INSERT INTO haw1868_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","I mai la o Iosepa i kona makuakane, O laua nei na keiki a'u, a ke Akua i haawi mai ai na'u ma keia wahi. I mai la kela, E hoonoho oe ia laua imua o'u, a e hoomaikai aku au ia laua. ");
INSERT INTO haw1868_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Kaumaha no na maka o Iseraela, no ka elemakule, aole hiki ia ia ke nana; a hoonoho mai kela ia laua imua ona, a honi aku la oia ia laua, a puliki iho la. ");
INSERT INTO haw1868_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","I ae la o Iseraela ia Iosepa, Aole au i manao e ike aku i kou maka, aia hoi, ua hoike mai ke Akua ia'u i kau mau keiki. ");
INSERT INTO haw1868_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","A lawe mai la o Iosepa ia laua mawaena mai o kona mau kuli, a kulou iho la ia me ka maka ilalo i ka honua. ");
INSERT INTO haw1868_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Lawe iho la o Iosepa ia laua a elua, ia Eperaima i kona lima akau, ma ka lima hema o Iseraela, a ia Manase, i kona lima hema ma ka lima akau o Iseraela, a hoonoho iho la ia laua imua ona. ");
INSERT INTO haw1868_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Hohola aku la o Iseraela i kona lima akau, a kau iho la ma ke poo o Eperaima, oia hoi ke kaikaina, a i kona lima hema hoi, ma ke poo o Manase: kau akamai no ia i kona lima; no ka mea, o Manase ka hanau mua. ");
INSERT INTO haw1868_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Hoomaikai mai la oia ia Iosepa, i mai la, Na ke Akua, ka mea a ko'u mau makua o Aberahama a me Isaaka i hele ae imua ona, na ke Akua nana wau i malama mai, mai ko'u wa uuku a hiki loa mai i neia la; ");
INSERT INTO haw1868_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Na ka Anela i hoopakele mai ia'u mai loko mai o ka hewa a pau, e hoomaikai ia mau keiki, a e heaia ko'u inoa maluna o laua, a me ka inoa o ko'u makua o Aberahama, a me Isaaka, a e laha loa laua i poe nui iwaena o ka honua. ");
INSERT INTO haw1868_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","A ike aku la o Iosepa, ua kau aku kona makuakane i kona lima akau ma ke poo o Eperaima, ua hewa ia i kona maka; hapai ae la ia i ka lima o kona makuakane e hoihoi ae, mai ke poe ae o Eperaima a i ke poo o Manase. ");
INSERT INTO haw1868_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","I aku la o Iosepa i kona makuakane, Aole pela, e ko'u makuakane, o ke kaikuaana keia, e kau oe i kou lima akau maluna o kona poe. ");
INSERT INTO haw1868_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Hoole mai la kona makuakane, i mai la, Ua ike au, e kuu keiki, ua ike au, e lilo no hoi ia i lahuikanaka a e nui no ia, aka, o kona kaikaina, e kela aku kona nui mamua o keia, a e lilo ana ia i lahuikanaka nui loa. ");
INSERT INTO haw1868_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Hoomaikai aku la oia ia laua ia la, i aku la, iloko ou e hoomaikai aku ka Iseraela, me ka i ana aku, E hoohalike mai ke Akua ia oe me Eperaima a me Manase. Hoonoho no oia ia Eperaima mamua o Manase. ");
INSERT INTO haw1868_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","I mai la o Iseraela ia Iosepa, Eia hoi, na kokoke au e make, a e noho ana no ke Akua me oukou, a e hoihoi aku no ia ia oukou i ka aina o ko oukou poe makua. ");
INSERT INTO haw1868_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Ua haawi hoi au in oe i kekahi puu waiwai maluna o kou poe hanauna, i ka mea a'u i loaa ai ma ka lima o ka Amora, me kuu pahikaua a me kuu kakaka. ");
INSERT INTO haw1868_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","KAHEA aku la o Iakoba i kana mau keikikane, i aku la, E houluulu mai ia oukou iho i hai aku ai au ia oukou i na mea e hiki mai ana io oukou la i na la mahope. ");
INSERT INTO haw1868_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","E houluulu mai ia oukou iho, e lohe, e na keiki a Iakoba; e hoolohe mai ia Iseraela i ko oukou makuakane. ");
INSERT INTO haw1868_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","E Reubena e, o oe no ka'u hiapo, o ko'u ikaika, a me ka hoomaka ana o ka ui o'u; ke kela ana i ka hanohano, ke kela ana i ka mana: ");
INSERT INTO haw1868_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","He hu wale me he wai la, aole oe e kela aku, no ka mea, pii aku la oe i ka moe o kou makuakane: alaila oe i hoohaumia iho ai: pii aka la ia i kuu wahi moe. ");
INSERT INTO haw1868_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","O Simeona laua o Levi, he mau hoahanau laua: aia na mea hoomainoino ma ko laua hoolimalima. ");
INSERT INTO haw1868_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Ma ko laua wahi ohumu aole e hele aku kuu uhane, ma ko laua halawai aole e hui pu ia'ku ko'u naui: no ka mea, no ko laua inaina pepehi iho la laua i ke kanaka, a no ko laua makemake oki iho la laua i ke olona wawae o ka bipi. ");
INSERT INTO haw1868_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","E hoinoia ka laua inaina, no ka mea, he ino ia, a me ko laua huhu, no ka mea, he koikoi ia: e mahelehele au ia laua iloko o ka Iakoba, a e hoopuehu au in laua iloko o ka Iseraela. ");
INSERT INTO haw1868_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","E Iuda e, o oe ka mea a na hoahanau ou e hoomaikai ai: o kou lima, aia no ia ma ka a-i o kou poe enemi; e kulou iho hoi na keiki a kou makuakane imua on. ");
INSERT INTO haw1868_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","He keiki a ka liona o Iuda, ua pii ae oe, e kuu keiki, mai ke pio ae: kukuli iho la ia, a moe iho la me he liona kane la, a me ka liona wahine; nawai ia e hoala ae? ");
INSERT INTO haw1868_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Aole e lilo aku ke kookeo alii mai o Iuda aku, aole hoi ka mea webewehe kanawai maiwaena aku o kona mau wawae, a hiki mai ai o Silo; a ia ia ke akoakoa ana ae o na kanaka. ");
INSERT INTO haw1868_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","E hikii ana i kana keikihoki i ke kumuwaina, a me ke keiki a ka hokiwahine i ke kumuwaina maikai, holoi iho la ia i kona kapa i ka waina, a me kona aahu i ke koko o ka huawaina. ");
INSERT INTO haw1868_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","E ulaula kona mau maka i ka waina, e keokeo hoi kona mau niho i ka waiu. ");
INSERT INTO haw1868_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","E noho auanei o Zebuluna ma ke kahakai; oia no ke kahakai no na moku; a e hiki aku kona palena i Sidona. ");
INSERT INTO haw1868_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","He hoki ikaika no o Isakara e moe ana mawaena o na halemalumalu: ");
INSERT INTO haw1868_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Ike iho la ia i ka maha he maikai ia, a i ka aina he oluolu ia, kulon iho la ia i kona hokua i ka ukana, a lilo iho la ia i kauwn e auhauia'i. ");
INSERT INTO haw1868_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","E hooponopono o Dana i kona hanauna a kanaka, e like me kekahi o na ohana o Iseraela. ");
INSERT INTO haw1868_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","He nahesa o Dana ma kapa alanui, he moolele ma ke ala; nana e nahu aku na kuekuewawae o ka lio, a e haule hope iho ka mea e hooholo ana ia ia. ");
INSERT INTO haw1868_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Ua kali au i kou hoola ana, e Iehova. ");
INSERT INTO haw1868_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","O Gada, e lanakila mai ka poe kaua maluna ona, aka, e lanakila aku oia ma ka hope. ");
INSERT INTO haw1868_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Mai Asera mai kana ai momona, a e haawi aku ia i na mea ono na na'lii. ");
INSERT INTO haw1868_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","O Napetali, he diawahine ia i kalaia'ku; ke hua mai nei ia i na huaolelo maikai. ");
INSERT INTO haw1868_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","He lala hua o Iosepa, he lala hua ma ka punawai: ke kolo ae nei na lala ona maluna o ka pa. ");
INSERT INTO haw1868_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Ua hooeha nui mai, a ua pana mai hoi na mea pana ia ia, a ua inaina mai lakou ia ia. ");
INSERT INTO haw1868_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Aka, ua mau no kona kakaka i ka ikaika, a ua hooikaikaia kona mau lima e na lima o ka Mea mana o Iakoba; (nolaila mai ke kahuhipa, ka pohaku no Iseraela;) ");
INSERT INTO haw1868_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","E ke Akua o kou makua, nana oe e kokua mai; e ka Mea mana loa hoi, nana oe e hoomaikai mai i na mea maikai o ka lani iluna, a o ka hohonu ilalo, i na mea maikai o ka u, a o ka opu. ");
INSERT INTO haw1868_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Ua oi aku ka hoomaikai ana o kou makuakane maluna o na hoomaikai ana o na mauna mau, a hiki aku hoi i na mokuna o na puu kahiko loa: maluna no auanei ia o ke poo o Iosepa, a maluna hoi o ka piko o ke poo o ka mea i hookaawaleia ae mai koua poe hanauna aku. ");
INSERT INTO haw1868_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","E haehae o Beniamina me he iliohae la, i ke kakahiaka e ai iho ia i ke pio, a i ke ahiahi e puunaue ia i ka waiwai pio. ");
INSERT INTO haw1868_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","O keia poe a pau, o ka poe ohana ia a Iseraela he umikumamalua: a oia ka mea a ko lakou makuakane i olelo mai ai ia lakou, a i hoomaikai mai ai ia lakou; i kela kanaka keia kanaka e like me ka hoomaikai ana, ana i hoomaikai mai ai ia lakou. ");
INSERT INTO haw1868_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Kauoha aku la oia ia lakou, i aku la, E huipu ana au me ko'u poe makua: e kanu pu hoi oukou la'u me na makua o'u ma ke ana maloko o ke kula o Eperona, no ka Heta, ");
INSERT INTO haw1868_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Ma ke ana iloko o ke kula ma Makepela, ma ke alo o Mamere, ma ka aina o Kanaana, o ke kula a Aberahama i kuai ai me Eperona, no ka Heta, i wahi ilina kupapau nona. ");
INSERT INTO haw1868_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Malaila lakou i kanu ai ia Aberahama, a me kana wahine me Sara, a malaila lakou i kanu ai ia Isaaka a me kana wahine mo Rebeka, a malaila hoi au i kanu ai ia Lea. ");
INSERT INTO haw1868_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Ua kuaiia ke kula, a me ke ana iloko me na mamo a Heta. ");
INSERT INTO haw1868_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","A pau ka Iakoba kauoha ana i kana poe keiki, opili ae la ia i kona mau wawae maluna o kahi moe, kaili aku la ke aho, a huipu ia iho la ia me kona poe makua. ");
INSERT INTO haw1868_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","HAULE iho la o Iosopa ma ka maka o kona makuakane, a uwe iho la maluna iho, a houi aku la. ");
INSERT INTO haw1868_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Kauoha ae la o Iosepa i kana mau kauwa, i na kahnua e ialoa i kona makuakane, a ialoa no na kahuna ia Iseraela. ");
INSERT INTO haw1868_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","A pau ae la na la hookahi kanaha nona, no ka mea, oia na la e pau ai ka ialoa ana o ka poe i ialoaia; a kanikau iho la ko Aigupita nona i na la he kanahiku. ");
INSERT INTO haw1868_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","A pau ae la na la kanikau, olelo aku la o Iosepa i na kanaka o Parao, i aku la, Ina i loaa ia'u ka lokomaikaiia mai ia oukou, ke nei aku nei au, e olelo aku oukou ma ka pepeiao o Parao, me ka i aku, ");
INSERT INTO haw1868_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Na ko'u makuakane i hoohiki ai au, i mai la ia, E, e make ana au. E kanu oe ia'u, ma ka lua kupapau a'u i kohi ai no'u ma ka aina i kanaana. Malaila oe e kanu ai ia'u. E ae mai hoi oe ia'u ke pii aku a kanu i kuu makuakane, a hoi hou mai no. ");
INSERT INTO haw1868_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","I mai la o Parao, O hele e kanu i kou makuakane, e like me kau i hoohiki ai nana. ");
INSERT INTO haw1868_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Pii aku la o Iosepa e kanu i kona makuakane, a pii pu aku la me ia na kauwa a Parao a pau, a me na luna kahiko o kona hale, a me na luna kahiko a pau o ka aina o Aigupita: ");
INSERT INTO haw1868_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","O ko Iosepa poe a pau me kona poe hoahanau, a me ka poe a pau o kona makuakane. O na kamalii, a me na hipa, a me na bipi, oia wale no ka lakou i waiho ai mahope, ma ka aina i Gosena. ");
INSERT INTO haw1868_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Pii pu aku la me ia na kaa a me na hoohololio; he poe nui loa. ");
INSERT INTO haw1868_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Pii aku la lakou i kahi hehi palaoa o Atada, ma o aku o Ioredaue, a malaila lakou i uwe ai me ka uwe nui loa, a kanikau iho la lakou i kona makuakane i na la ehiku. ");
INSERT INTO haw1868_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","A ike ae la ka poe noho ma ia aina, o ko Kanaana i ua kanikau nei, ma kahi hehi palaoa o Atada, olelo iho la lakou, He kanikau nui loa keia a ko Aigupita: no ia mea, ua kapa aku la ka inoa o Abelamizeraima, aia ma o aku o Ioredane. ");
INSERT INTO haw1868_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","A hana aku la kana mau keiki ia ia e like me kana i kauoha ai ia lakou. ");
INSERT INTO haw1868_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Lawe aku la no kana mau keiki ia ia, i ka aina o Kanaana, a kanu iho la ia ia ma ke ana iloko o ke kula, ma Makepela, na Aberahama i kuai ia kula i wahi ilina nona, me Eperona no ka Heta, aia ma ke alo o Mamere. ");
INSERT INTO haw1868_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","A pau ke kanu ana i kona makuakane, hoi aku la o Iosepa i Aigupita, oia, a me kona poe hoahanau a pau i hele pu me ia e kanu i kona makuakane. ");
INSERT INTO haw1868_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","A ike iho la na kaikuaana o Iosepa, ua make ko lakou makuakane, olelo lakou, E ukiuki mai auanei o Iosepa ia kakou; e oiaio no, e hoopai mai ia i ka hewa a pau a kakou i hana aku ai ia ia. ");
INSERT INTO haw1868_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Kauoha ae la lakou ia Iosepa, i ae la, Kauoha mai la kou makuakane, mamua o kona make ana, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","E i aku oukou ia Iosepa, Ke nonoi aku nei makou ia oe, e kala oe i ka hewa o kou poe kaikuaana, a me ko lakou hala, no ka mea, ua hana hewa lakou ia oe. Ano hoi, e kala oe i ka hewa o na kauwa a ke Akua o kou makuakane. Uwe iho la o Iosepa i ka lakou olelo ana mai ia ia. ");
INSERT INTO haw1868_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Hele ae la hoi kona poe kaikuaana, haule iho la ma kona alo, i ae la, O kau mau kanwa makou. ");
INSERT INTO haw1868_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","I mai la o Iosepa ia lakou, Mai makau oukou, Owau anei ma ko ke Akua wahi? ");
INSERT INTO haw1868_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","I manao no oukou e hana ino mai ia'u, a hoololi mai ke Akua ia mea, i mea maikai, e hana mai ai e like me ia i neia la, e hoola i na kanaka he nui loa. ");
INSERT INTO haw1868_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Mai makau: na'u no oukou e malama aku i ka ai, a me ka oukou poe keiki. Hooluolu mai la ia ia lakou, a olelo lokomaikai mai la i ko lakou naau. ");
INSERT INTO haw1868_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Noho iho la o Iosepa ma Aignpita, oia, a me ka ohana a kona makuakane: a o na makahiki o ko Iosepa oia ana, hookahi haneri a me ka umi keu. ");
INSERT INTO haw1868_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","A ike iho la o Iosepa i na keiki a Eperaima a me ke ku akolu, a me na keiki a Makira, ke keiki a Manase, o ka mea i hanauia ma na kuli o Iosepa. ");
INSERT INTO haw1868_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","I ae la o Iosepa i kona poe hoahanau, E make ana au. E oiaio no, e ike mai ke Akua ia oukou, a e hoihoi aku ia oukou, mai keia aina aku, a ka aina ana i hoohiki ai ia Aberahama a ia Isaaka, a ia Iakoba. ");
INSERT INTO haw1868_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Na Iosepa no, na mamo a Iseraela i hoohiki ai, i ae la, E oiaio no, e ike mai ke Akua ia oukou, a e lawe aku oukou i ko'u mau iwi, mai anei aku. ");
INSERT INTO haw1868_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","A make iho la o Iosepa ma ka makahiki o kona ola ana, hookahi haneri a me ka umi keu. A ialoa iho la lakou ia ia a waiho iho la maloko o ka pahu ma Aigupita. ");
INSERT INTO haw1868_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","EIA na inoa o na keiki a Iseraela, i hele aku me Iakoba i Aigupita, o kela kanaka keia kanaka i hele aku me ko ka hale ona. ");
INSERT INTO haw1868_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","O Reubena, o Simeona, o Levi, o Iuda, ");
INSERT INTO haw1868_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","O Isakara, o Zebuluna, o Beniamina, ");
INSERT INTO haw1868_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","O Dana, o Napetali, o Gada a o Asera. ");
INSERT INTO haw1868_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","O na mea ola a pau i puka mai ai, mai loko ae o ko Iakoba puhaka, he kanahiku lakou; a ma Aigupita no o Iosepa. ");
INSERT INTO haw1868_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","A make iho la o Iosepa, a me kona poe hoahanau a pau, a me ia hanauna a pau. ");
INSERT INTO haw1868_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Hanau nui iho la na mamo a Iseraela, a laha loa ae la, a kawowo loa: ua nui loa ko lakou ikaika, a ua piha hoi ka aina ia lakou. ");
INSERT INTO haw1868_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","A ku mai la kekahi alii hou ma Aigupita, aole i ike ia Iosepa. ");
INSERT INTO haw1868_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","I mai la ia i kona poe kanaka, Aia hoi, ua oi aku ka nui o na kanaka mamo a Iseraela, a me ko lakou ikaika i ko kakou. ");
INSERT INTO haw1868_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","E hana maalea kakou ia lakou; o nui auanei lakou, a hiki mai ke kaua, huipu lakou me ko kakou poe enemi, a e kaua mai hoi ia kakou, a pela ia lakou e pii aku ai mai ka aina aku. ");
INSERT INTO haw1868_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","A hoonoho aku lakou i na luna hooluhi maluna o lakou, i mea e hookaumaha loa ai ia lakou i na haua nui. A hana iho la lakou i na kulanakauhale papaa no Parao, o Pitoma, a o Ramese. ");
INSERT INTO haw1868_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","E like me ko lakou hooluhi ana mai, pela no hoi ko lakou nei mahuahua, a me ka palahalaha ana aku. A makau loa lakou i na mamo a Iseraela. ");
INSERT INTO haw1868_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Hoohana iho la ko Aigupita i na mamo a Iseraela me ka hookoikoi. ");
INSERT INTO haw1868_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Hooawahia iho la lakou i ko lakou nei ola ana i ka hana luhi iloko o ka palolo, a i na pohakulepo, a me na hana a pau ma ka mahinaai: a o ka hana a pau a lakou i hoohana iho ai ia lakou nei, he mea koikoi ia. ");
INSERT INTO haw1868_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Olelo mai la ke alii o Aigupita i na palekeiki Hebera, o Sipera ka inoa o kekahi, a o Pua hoi ka inoa o kekahi; ");
INSERT INTO haw1868_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","I mai la, A i palekeiki olua i na wahine Hebera, a nana olua iloko o na paholoi; ina he keikikane ia, alaila e pepehi olua ia ia; aka ina he kaikamahine, e ola no ia. ");
INSERT INTO haw1868_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Aka, makau iho la na palekeiki i ke Akua; aole laua i hana i ka mea a ke alii o Aigupita i kauoha ai in laua; aka, hoola ae la laua i na keikikane. ");
INSERT INTO haw1868_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Kii mai la ke alii o Aigupita i na palekeiki, i mai la ia laua, No ke aha la olua i hana'i i keia mea, a hoola i na keikikane? ");
INSERT INTO haw1868_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","I aku la na palekeiki ia Parao, No ka mea, aole i like na wahine Hebera me ko Aigupita poe wahine, he hiki wawe ko lakou, aole e hiki aku na palekeiki, a hanau e no lakou. ");
INSERT INTO haw1868_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","A hoomaikai mai la ke Akua i na palekeiki: a mahuahua aku la na kanaka, a ua nui loa no hoi ko lakou ikaika. ");
INSERT INTO haw1868_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","A no ka makau ana o na palekeiki i ke Akua, a no kona hoomahuahua ana i ko lakou mau ohana, ");
INSERT INTO haw1868_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Kauoha ae la o Parao i kona poe kanaka a pau, i aku la, O na keikikane a pau ke hanau mai, e kiola aku ia lakou i ka muliwai, aka, o na kaikamahine a pau, ka oukou ia e hoola ai. ");
INSERT INTO haw1868_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","KII aku la kekahi kanaka o ka ohana a Levi, a lawe ae la i kekahi kaikamahine a Levi. ");
INSERT INTO haw1868_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Hapai ae la ua wahine la, a hanau mai la he keikikane; a ike iho la oia ia ia he maikai, huna iho la oia ia ia ekolu malama. ");
INSERT INTO haw1868_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","A i ka wa hiki ole ia ia ke huna hou aku, lawe ae la ia i waa kome nona, a hapala ia mea i ka bitumena a me ke kepau, a hahao iho la i ke keiki maloko; a waiho iho la maloko o na kaluha ma kapa o ka muliwai. ");
INSERT INTO haw1868_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","A ku iho la kona kaikuwahine i kahi mamao aku, e nana i ka mea e hanaia mai ai ia ia. ");
INSERT INTO haw1868_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Iho iho la ke kaikamahine a Parao e auau ma ka muliwai, hele ae la hoi kona mau wahine ma kapa o ka muliwai: a ike aku la kela i ka waa iwaena o na kaluha, hoouna aku la ia i kona wahine e lawe mai. ");
INSERT INTO haw1868_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","A wehe aku la ia, alaila ike iho la i ke keiki: aia hoi, uwe ae la ua keiki la. Aloha aku la kela ia ia, i aku la. He keiki keia na ka Hebera. ");
INSERT INTO haw1868_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Alaila, olelo aku la kona kaikuwahine i ke kaikamahine a Parao, E hele hoi ha wau, e kii aku nou i kekahi wahine Hebera i kahu nana e hanai i ke keiki nau? ");
INSERT INTO haw1868_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","I mai la ke kaikamahine a Parao ia ia, O hele. A hele aku la ke kaikamahine, a kii aku la i ka makuwahine o ua keiki la. ");
INSERT INTO haw1868_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","I mai la ke kaikamahine a Parao ia ia, E lawe oe i keia keiki a e hanai ia ia na'u, a na'u no oe e uku aku. Lawe ae la ua wahine la i ke keiki, a hanai iho la. ");
INSERT INTO haw1868_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","A nui ae ua keiki la: a lawe ae la oia ia ia i ke kaikamahine a Parao, a lilo ae la ia i keiki nana. Kapa iho la oia i kona inoa, o Mose, i iho la ia, No ka mea, ua lawe mai au ia ia mailoko mai o ka wai. ");
INSERT INTO haw1868_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Ia mau la mai, i ko Mose wa kanaka makua, hele aku la ia i kona poe hoahanau, nana aku la ia i ko lakou luhi ana; ike aku la ia i kekahi kanaka o Aigupita e pepehi ana i ka Hebera, i kekahi o kona poe hoahanau. ");
INSERT INTO haw1868_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Aloalo ae la ia, a ike iho la, aole kanaka, alaila pepehi iho la ia i ka Aigupita a make, a huna ia ia maloko o ke one. ");
INSERT INTO haw1868_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","A i ka lua o ka la, hele hou aku la no ia, aia hoi, elua kanaka Hebera e hakaka ana; i aku la ia i ka mea nona ka hewa, No ke aha la oe e pepehi aku nei i kou hoa? ");
INSERT INTO haw1868_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","I mai la kela, Nawai la oe i hoolilo ao nei i alii, a i lunakanawai maluna o makou? Ke manao nei anei oe e pepehi mai ia'u, e like mo kou pepehi ana i ka Aigupita? Alaila makau iho la o Mose, i iho la, Oiaio no, ua ikeia koia mea. ");
INSERT INTO haw1868_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","A lohe ae la o Parao ia mea, imi iho la ia o pepehi ia Mose. Mahuka aku la o Mose mai ka maka aku o Parao, a noho ma ka aina ma Midiana: a noho iho la ia ilalo ma kekahi luawai. ");
INSERT INTO haw1868_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","He mau kaikamahine ehiku na ke kahuna ma Midiana. Hele mai la lakou a hukihuki i ka wai, a ninini iloko o na holowaa, e hooinu ai i na holoholona a ko lakou makuakane. ");
INSERT INTO haw1868_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Hele mai la kekahi poe kahuhipa, a kipaku ae la ia lakou. Ku ae la o Mose iluna, a kokua ia lakou, a hooinu aku la i ka lakou poe holoholona. ");
INSERT INTO haw1868_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","A hoi aku la lakou ia Reuela i ko lakou makuakane, ninau mai la ia, No ke aha la oukou i hoi koke mai ai i koia la? ");
INSERT INTO haw1868_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","I aku la lakou, Na kekahi kanaka o Aigupita i hoopakele ae ia makou mai ka lima mai o ka poe kahuhipa, a huki iho la ia i ka wai no makou a nui, a hooinu aku la i na holoholona. ");
INSERT INTO haw1868_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","I mai la ia i kana poe kaikamahine, Auhea la hoi ia? No ke aha la oukou i haalele aku ai i ua kanaka la? E kii aku ia ia e ai ia i ka ai. ");
INSERT INTO haw1868_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","A walea iho la o Mose e noho me ia kanaka, a haawi mai la oia ia Zipora, kana kaikamahine na Mose. ");
INSERT INTO haw1868_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","A hanau mai la ia he keikikane, a kapa aku la ia i kona inoa o Geresoma; no ka mea, i iho la ia, Ua malihini au ma ka aina e. ");
INSERT INTO haw1868_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","A nui na la i hala, make ke alii o Aigupita, a kaniuhu iho la ka poe mamo a Iseraela, no ka luhi loa ana, a uwe aku la lakou; a hiki aku la ko lakou uwe ana i ke Akua no ko lakou luhi. ");
INSERT INTO haw1868_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","A lohe ke Akua i ko lakou uwe ana, a manao iho la ia i kana berita me Aberahama, a me Isaaka, a me Iakoba. ");
INSERT INTO haw1868_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","A nana mai la ke Akua i ka poe mamo a Iseraela, a manao mai la ko Akua ia lakou. ");
INSERT INTO haw1868_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","HANAI iho la o Mose i na holoholona a Ietero a kona makuahonowaikane, a ke kahuna ma Midiana; alakai aku la no ia i na holoholona ma ke kua o ka waonahele, a hiki aku la i ke kuahiwi o ke Akua, i Horeba. ");
INSERT INTO haw1868_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Ikea mai la e ia ka anela o Iehova maloko o ka lapalapa o ke ahi mawaenakonu o ka laalaau: nana aku la ia, aia hoi, e aa ana ka laalaau i ko ahi, aole nae i pau ka laau. ");
INSERT INTO haw1868_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","I iho la o Mose, E kipa ae no wau e ike i keia mea nui, i ka mea i pau ole ai ka laau i ke ahi. ");
INSERT INTO haw1868_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","A ike mai la o Iehova i kona huli ana e makaikai, hea mai la ke Akua ia ia mailoko mai o ua laalaau la, E Mose, e Mose. I aku la ia, Eia no wau. ");
INSERT INTO haw1868_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","I mai la kela, Mai hookokoke mai oe: e wehe ae oe i kou mau kamaa mai kou mau kapuwai aku, no ka mea, o kahi au e ku nei, he aina hoano ia. ");
INSERT INTO haw1868_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","I mai la hoi oia, Owau no ke Akua o kou makuakane, ke Akua o Aberahama, ke Akua o Isaaka, ke Akua hoi o Iakoba. Papani iho la o Mose i kona maka; no ka mea, ua makau ia ke nana aku i ke Akua. ");
INSERT INTO haw1868_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","I mai la o Iehova, I kuu nana ana ua ike no wau i ka luhi ana o ko'u poe kanaka ma Aigupita, ua lohe no hoi au i ka lakou kaniuhu ana, no na luna hooluhi o lakou; ua ike hoi au i ko lakou ehaeha ana. ");
INSERT INTO haw1868_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Ua iho mai nei au ilalo nei e hookuu ia lakou mai ka lima mai o ko Aigupita, a e lawe mai ia lakou mai ia aina mai, a kekahi aina maikai. a nui no hoi. he aina e kahe ana o ka waiu a me ka meli; i kahi o ka poe Kanaana, a me ka Heta, a me ka Amora, a me ka Pereza, a me ka Hiva, a me ka Iebusa. ");
INSERT INTO haw1868_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Eia hoi, no ka mea, ua hiki mai io'u nei ke kaniuhu ana o na mamo a Iseraela; a na ike no hoi au i ka luhi ana a ko Aigupita i hooluhi iho ai ia lakou. ");
INSERT INTO haw1868_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Nolaila la, e hele mai oe, a na'u no oe e hoouna aku io Parao la, i lawe mai ai oe i o'u poe kanaka, i na mamo a Iseraela mailoko ae o Aigupita. ");
INSERT INTO haw1868_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","I aku la o Mose i ke Akua, Owai la wau, i hele aku ai au io Parao la, a i lawe mai ai hoi au i na mamo a Iseraela mailoko mai o Aigupita? ");
INSERT INTO haw1868_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","I mai la kela, He oiaio, owau no kekahi me oe, eia hoi ka hoailona o ko'u hoouna ana aku ia oe; i ka wa au e lawe mai ai i ka poe kanaka mai Aigupita mai, e hoomana auanei oukou i ke Akua ma keia kuahiwi. ");
INSERT INTO haw1868_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Ninau aku la o Mose i ke Akua, Aia hoi, a hiki aku au i na mamo a Iseraela, a e olelo au ia lakou, Na ke Akua o ko oukou poe kupuna owau i hoouna mai io oukou nei, a e ninau lakou ia'u, Owai kona inoa? Pehea la hoi ka'u e olelo aku ai ia lakou? ");
INSERT INTO haw1868_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","I mai la ke Akua ia Mose, OWAU MAU LOA AKU NO. I mai la hoi oia, Penei kau e olelo aku ai i na mamo a Iseraela, OWAU MAU, oia ka i hoouna mai ia'u io oukou nei. ");
INSERT INTO haw1868_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","I hou mai la ke Akua ia Mose, Penei oe e olelo aku ai i na mamo a Iseraela, Na Iehova ke Akua o ko oukou poe kupuna, ke Akua o Aberahama, ke Akua o Isaaka, ke Akua o Iakoba, owau i hoouna mai io oukou nei. Oia no ko'u inoa mau loa, oia hoi ko'u mea e hoomanaoia i ia hanauna aku ia hanauna aku. ");
INSERT INTO haw1868_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","O hele oe, a e hoakoakoa ae i ka poe lunakahiko o ka Iseraela, a e olelo aku ia lakou, Ua ikeia'ku e au o Iehova ke Akua o ko oukou poe kupuna, ke Akua o Aberahama, o Isaaka a o Iakoba; ua olelo mai oia, Ua ike io no au ia oukou, a me ka mea i hanaia mai ia oukou ma Aigupita. ");
INSERT INTO haw1868_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Ua olelo hoi au, Na'u no oukou e lawe aku iluna, mailoko ae o ka popilikia o Aigupita, a hiki i ka aina o ka Kanaana a me ka Heta a me ka Amora a me ka Pereza a me ka Hiva, a me ka Iebusa, i ka aina e kahe ana o ka waiu a me ka meli. ");
INSERT INTO haw1868_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","A e hoolohe mai lakou i kou leo: a e hele pu oe me ka poe lunakahiko o ka Iseraela i ke alii o Aigupita, a e olelo aku oukou ia ia, Ua halawai mai me makou o Iehova ke Akua o ka poe Hebera: no ia mea, e hookuu mai oe ia makou e hele ma ka waonahele, i ekolu la hele, e kaumaha aku ai na Iehova ko makou Akua. ");
INSERT INTO haw1868_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Ua ike no nae au, aole e hookuu mai ke alii o Aigupita ia oukou, aole no ma ka lima ikaika. ");
INSERT INTO haw1868_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Aka, e o aku no wau i ko'u lima, a e paopao wau ia Aigupita me na mea mana a pau a'u e hana aku ai mawaena konu o lakou: a mahope e hookuu no oia ia oukou. ");
INSERT INTO haw1868_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Ae haawi aku wau i ka lokomaikai i keia poe kanaka imua o na maka o ko Aigupita, a i ka wa a oukou e hele mai ai, aole oukou e hele nele mai. ");
INSERT INTO haw1868_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","E noi aku no kela wahine keia wahine i kona hoalauna, a i ka mea e noho pu ana maloko o kona hale, i na mea kala, a me na mea gula, a me na mea aahu, a e hoaahu iho oukou i ka oukou poe keikikane, a me ka oukou poe kaikamahine; e hao hoi oukou i ko Aigupita. ");
INSERT INTO haw1868_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","OLELO aku la o Mose, i aku la, Aia hoi; aole paha auanei lakou e manaoio mai ia'u, aole hoi e hoolohe mai i ko'u leo; no ka mea, e olelo auanei lakou, Aole i ikeia 'ku o Iehova e oe. ");
INSERT INTO haw1868_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","I mai la o Iehova ia ia, Heaha kela mea ma kou lima? I aku la ia, He kookoo. ");
INSERT INTO haw1868_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","I mai la kela, E hoolei ia ilalo i ka honua. Hoolei iho la ia ilalo i ka honua, a lilo ae la ia i nahesa: a holo aku la o Mose mai kona maka aku. ");
INSERT INTO haw1868_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","I mai la o Iehova ia Mose, E kikoo aku kou lima, a e lalau aku ma kona huelo. Kikoo aku la kona lima a lalau iho la, a hoi hou ae la ia i kookoo ma kona lima. ");
INSERT INTO haw1868_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Ilaila e manaoio ai lakou, ua ikea e oe o Iehova ke Akua o ko lakou poe kupuna, ke Akua o Aberahama, ke Akua o Isaaka, ke Akua hoi o Iakoba. ");
INSERT INTO haw1868_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Olelo hou mai la o Iehova ia ia, E hooholo oe i kou lima ma kou umauma iho. Hooholo ae la ia i kona lima ma kona umauma, a i kona unuhi ana mai, aia hoi, ua lepera ia e like me ka hau. ");
INSERT INTO haw1868_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","I mai la oia, E hooholo hou ae oe i kou lima ma kou umauma. Hooholo hou i kona lima ma kona umauma, a unuhi hou mai, aia hoi, ua hoi hou ae la no e like me kekahi io ona. ");
INSERT INTO haw1868_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","A ina aole lakou e manaoio mai ia oe, aole hoi e hoolohe mai i ka leo o ka hoailona mua, e manaoio paha lakou i ka leo o ka hoailona hope. ");
INSERT INTO haw1868_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","A ina aole lakou e manaoio mai i keia mau hoailona elua, aole hoi e hoolohe i kou leo, alaila e lawe ae oe i kahi wai o ka muliwai, a e ninini ma kahi maloo, a e lilo auanei ka wai au e lawe ai mailoko mai o ka muliwai, i koko ma kahi maloo. ");
INSERT INTO haw1868_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","I aku la o Mose ia Iehova, E kun Haku e, he kanaka akamai ole wau i ka olelo, aole mamua mai a hiki i keia wa au e olelo mai ai i kau kauwa nei, he kali ko'u waha, a he kali hoi ko'u elelo. ");
INSERT INTO haw1868_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","I mai la o Iehova ia ia, Nawai i hana ka waha o ke kanaka? Nawai hoi i hana i ka aa, a me ke kuli, a me ka ike, a me ka makapo? Aole anei na'u, na Iehova? ");
INSERT INTO haw1868_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Nolaila, o hele, a owau pu no me kou waha, e ao aku ana ia oe i ka mea au e olelo aku ai. ");
INSERT INTO haw1868_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","I aku la ia, E kuu Haku e, ke noi aku nei au ia oe, e hoouna aku oe ma ka lima o ka mea au e hoouna aku ai. ");
INSERT INTO haw1868_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Wela mai la ka inaina o Iehova ia Mose, i mai la kela, Aole anei ke kaikuaana ou o Aarona ka Levi? Ua ike no au e hiki no ia ia ke olelo; aia hoi ke hele mai nei ia e halawai me oe: aia ike mai kela ia oe, e olioli auanei oia ma kona naau. ");
INSERT INTO haw1868_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Nau e olelo aku ia ia, a e waiho aku i na hua ma kona waha; a owau pu no me kou waha, a me kona waha, a e ao aku ia olua i ka olua mea e hana'i. ");
INSERT INTO haw1868_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","A oia no kou mea nana e olelo aku i na kanaka: a e lilo no oia i waha nou, a o oe hoi nona e like me ke Akua. ");
INSERT INTO haw1868_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","E lawe pu aku oe i keia kookoo maloko o kou lima, i mea e hana aku ai i na hoailona. ");
INSERT INTO haw1868_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Alaila hele aku la o Mose a hoi aku la io Ietero la i kona makuahonowaikane, i aku la ia ia, E hele paha au, a hoi hou i o'u poe hoahanau aia ma Aigupita, i ike ai au i ko iakou ola ana. I mai la o Ietero ia Mose, O hele oe me ka maluhia. ");
INSERT INTO haw1868_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","I mai la o Iehova ia Mose ma Midiana, E hele oe, a e hoi hou i Aigupita, no ka mea, ua make na kanaka a pau, ka poe i imi e lawe i kou ola. ");
INSERT INTO haw1868_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Lawe ae la o Mose i kana wahine, a me kana mau keikikane, a hoonoho aku la ia lakou maluna o ka hoki, a hoi aku la ia i ka aina o Aigupita. A lawe pu aku la o Mose i ke kookoo o ke Akua maloko o kona lima. ");
INSERT INTO haw1868_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","I mai la o Iehova ia Mose, I kou hele ana aku e hoi i Aigupita, e ao oe, e hana aku imua o Parao i na hana mana a pau a'u i waiho ai maloko o kou lima: a na'u no e hoopaakiki i kona naau, i hookuu ole ai ia i na kanaka. ");
INSERT INTO haw1868_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","E olelo aku oe ia Parao, Ke i mai nei o Iehova penei, O Iseraela no ka'u keikikane, o ka'u hiapo hoi; ");
INSERT INTO haw1868_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Ke olelo aku nei au ia oe, E hookuu oe i ka'u keiki, i malama mai ia ia'u: a ina e hoole mai oe i kona hookuuia, aia hoi, e pepehi aku no au i kau keikikane, i kau hiapo hoi. ");
INSERT INTO haw1868_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","A hiki mai hoi ia ma ke ala, maloko o ka halekipa, halawai mai la o Iehova me ia, a imi iho la e pepehi ia ia. ");
INSERT INTO haw1868_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Lalau aku la o Zipora i pahi, a okipoepoe iho la i ka omaka o kana keikikane, a hoolei iho la ma kona mau wawae, i mai la, He kane koko oe na'u. ");
INSERT INTO haw1868_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Hookuu iho la oia ia ia. Alaila olelo ae la ia, He kane koko oe no ke okipoepoe ana. ");
INSERT INTO haw1868_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","I mai la o Iehova ia Aarona, E hele oe e halawai me Mose ma ka waonahele. Hele aku la ia, a halawai iho la ma ke kuahiwi o ke Akua, a honi ae la ia ia. ");
INSERT INTO haw1868_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Hai ae la o Mose ia Aarona i na olelo a pau a Iehova, nana ia i hoouna mai, a me na ouli a pau ana i kauoha mai ai ia ia. ");
INSERT INTO haw1868_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Hele aku la o Mose laua o Aarona, hoakoakoa iho la laua i na lunakahiko a pau o na mamo a Iseraela. ");
INSERT INTO haw1868_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Hai aku la o Aarona i na olelo a pau a Iehova i olelo mai ai ia Mose; a hana iho la ia i na ouli imua o na maka o kanaka. ");
INSERT INTO haw1868_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Manaoio iho la no hoi na kanaka: a lohe pono no lakou, ua ike mai o Iehova i ka poe mamo a Iseraela, a ua nana mai hoi oia i ko lakou popilikia, alaila kulou iho la ko lakou poo, a hoomana aku la. ");
INSERT INTO haw1868_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","MAHOPE iho, hele aku la o Mose laua o Aarona, a hai aku la ia Parao, Ke i mai nei o Iehova ke Akua o ka Iseraela penei, E hookuu mai oe i ko'u poe kanaka, i ahaaina lakou na'u ma ka waonahele. ");
INSERT INTO haw1868_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","I mai la o Parao, Owai la o Iehova i hoolohe ai au i kona leo, e hookuu aku ai i ka Iseraela? Aole au i ike ia Iehova, aole hoi au e hookuu aku i ka Iseraela. ");
INSERT INTO haw1868_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","I aku la laua, ua halawai mai me makou ke Akua o ka poe Hebera; no ia mea, e hookuu oe ia makou e hele i ka waonahele, i kahi ekolu la hiki, e kaumaha aku ai na Iehova o ko makou Akua, o kau mai ia maluna o makou i ke ahulau a me ka pahikaua. ");
INSERT INTO haw1868_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","I mai la ke alii o Aigupita ia laua, No ke aha la olua, e Mose a me Aarona, e hooki nei i kanaka i ka lakou hana? E hoi oukou ma ko oukou luhi. ");
INSERT INTO haw1868_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Olelo mai la o Parao, Aia hoi, ua nui loa na kanaka o ka aina, a ke hooki nei olua ia lakou i ko lakou luhi. ");
INSERT INTO haw1868_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Ia la no, kauoha mai la o Parao i na lunahooluhi o na kanaka; a me ko lakou mau luna iho, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","Mai haawi hou aku i ka mauu i kanaka no na pohakulepo, e like mamua. E hele lakou e hoiliili i ka lakou mauu. ");
INSERT INTO haw1868_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","A o ka nui o na pohakulepo a lakou i hana'i mamua, pela oukou e haawi hou aku ai ia lakou; mai hoemi iki ia mea; no ka mea, ua molowa lakou: no ia mea, ke uwe mai nei lakou, i ka i ana mai, E hele makou e kaumaha aku na ko makou Akua. ");
INSERT INTO haw1868_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","E kau i ka hana kaumaha maluna o na kanaka, i hana aku ai lakou ilaila, i hoolohe ole ai hoi lakou i na olelo wahahee. ");
INSERT INTO haw1868_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Hele aku la na lunahooluhi o na kanaka, a me ko lakou poe luna iho, olelo ae la i kanaka, i ae la, Ke i mai nei o Parao penei, Aole au e haawi aku i mauu ia oukou. ");
INSERT INTO haw1868_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","E hele oukou, e kii i mauu na oukou iho i kahi e loaa'i ia oukou; no ka mea, aole loa e hoemi iki ia ka oukou mea hana. ");
INSERT INTO haw1868_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","No ia mea, auwana wale aku no na kanaka ma ka aina a pau o Aigupita, e hoiliili i ka opala i mauu. ");
INSERT INTO haw1868_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Wikiwiki mai la na lunahooluhi, i mai la ia lakou, E hoolawa i ka oukou hana, i ka hana o kela la o keia la, e like me ka wa mauu. ");
INSERT INTO haw1868_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","A o na luna o na mamo a Iseraela, o ka poe i hoonohoia maluna o lakou e na lunahooluhi o Parao, ua hahauia mai lakou, me ka ninauia mai, No ke aha la oukou i hoolawa ole ai i ka oukou hana i na pohakulepo inehinei, a i keia la hoi, e like mamua? ");
INSERT INTO haw1868_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Hele aku la na luna o na mamo a Iseraela, a uwe aku la ia Parao, i aku la, No ke aha la oe e hana mai ai pela i kau poe kauwa nei? ");
INSERT INTO haw1868_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Aole i haawiia mai ka mauu i kau poe kauwa, a ke i mai nei lakou ia makou, E hana oukou i na pohakulepo: aia hoi, ua hahauia mai nei kau poe kauwa: aka, no kou poe kanaka iho ka hewa. ");
INSERT INTO haw1868_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","I mai la kela, Ua palela oukou, ua palela oukou; no ia mea, ke olelo mai nei oukou, E hookuu mai oe ia makou e hele, e kaumaha aku na Iehova. ");
INSERT INTO haw1868_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","E hele hoi oukou pela e hana, no ka mea, aole loa e haawiia'ku ka mauu na oukou, aka, e hoolawa oukou i ka hana o na pohakulepo. ");
INSERT INTO haw1868_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Ike iho la na luna o na mamo a Iseraela, ua nui ko lakou pilikia, i ka i ana mai, Mai hoemi iki oukou i na pohakulepo i ka oukou hana ana i kela la i keia la. ");
INSERT INTO haw1868_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Halawai lakou me Mose laua o Aarona, e ku ana ma ke alanui i ko lakou hele ana mai, mai o Parao mai. ");
INSERT INTO haw1868_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","I ae la lakou ia laua, E nana mai o Iehova ia olua, a e hoahewa mai; no ka mea, ua hoolilo olua i ko makou ala i mea pilau imua o Parao, a imua o kana poe kauwa, i ka haawi ana i ka pahikaua maloko o ko lakou lima, e pepehi mai ai ia makou. ");
INSERT INTO haw1868_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Hoi hou aku la o Mose io Iehova la, i aku la ia ia, E ka Haku e, no ke aha la oe i hana ino mai ai i keia poe kanaka? No ke aha la oe i hoouna mai nei ia'u? ");
INSERT INTO haw1868_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","No ka mea, mai ka manawa a'u i hele aku ai io Parao la e olelo aku ma kou inoa, ua hana ino mai kela i keia poe kanaka, aole hoi oe i hookuu iki mai i kou poe kanaka. ");
INSERT INTO haw1868_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","ALAILA olelo mai la o Iehova ia Mose, Ano, e ike auanei oe i ka mea a'u e hana aku ai ia Parao: no ka mea, e hookuu aku no oia ia lakou me ka lima ikaika, a me ka lima ikaika hoi oia e kipaku aku ai ia lakou, mai kona aina aku. ");
INSERT INTO haw1868_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Olelo mai la ke Akua ia Mose, i mai la ia ia, Owau no o Iehova. ");
INSERT INTO haw1868_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Hoike aku wau ia'u iho ia Aberahama, ia Isaaka, a ia Iakoba, o ke Akua Mana; aka, ma ko'u inoa, o IEHOVA, aole au i ikeia mai e lakou. ");
INSERT INTO haw1868_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Ua hoopaa no hoi au i kuu berita me lakou, e haawi aku ai no lakou i ka aina o Kanaana, i ka aina i noho ai lakou, he mau malihini ilaila. ");
INSERT INTO haw1868_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Ua lohe hoi au i ka uu ana o na mamo a Iseraela, o ka poe i hooluhiia'i e ko Aigupita; a ua hoomanao wau i kuu berita. ");
INSERT INTO haw1868_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","No ia mea, e olelo aku oe i na mamo a Iseraela, Owau no Iehova, a e lawe mai ana no wau ia oukou mailalo mai o na mea kaumaha a ko Aigupita, a e hoopakele no wau ia oukou i ko lakou hooluhi ana; a e hoola wau ia oukou me ka lima kakauha, a me na hoopai ana he nui loa. ");
INSERT INTO haw1868_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","A e hoonoho no wau ia oukou i poe kanaka no'u, a owau auanei hoi ko oukou Akua: a e ike auanei hoi oukou, owau no Iehova, o ko oukou Akua, nana oukou e lawe ae, mailalo ae o na mea kaumaha a ko Aigupita. ");
INSERT INTO haw1868_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","A e lawe aku no au ia oukou i ka aina a'u i pai ai i ko'u lima, e haawi aku ia wahi no Aberahama, no Isaaka a no Iakoba, oia ka'u e haawi aku ai no oukou i wahi e noho ai: owau no Iehova. ");
INSERT INTO haw1868_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Pela no hoi o Mose i olelo aku ai i na mamo a Iseraela: aole nae lakou i hoolohe i ka Mose, no ka ehaeha o ka naau, a no ka luhi koikoi. ");
INSERT INTO haw1868_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Olelo mai la o Iehova ia Mose, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","E hele oe, e olelo aku ia Parao i ke alii o Aigupita, e hookuu aku oia i na mamo a Iseraela mai kona aina aku. ");
INSERT INTO haw1868_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Olelo aku o Mose imua o Iehova, i aku la, Aia hoi, aole i hoolohe mai na mamo a Iseraela ia'u, pehea la hoi e hoolohe mai ai o Parao ia'u, i ka mea lehelehe hemahema? ");
INSERT INTO haw1868_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Olelo mai la o Iehova ia Mose a ia Aarona, a hoouna ia laua i na mamo a Iseraela, a ia Parao, no ka lawe ana mai i na mamo a Iseraela mai ka aina mai o Aigupita. ");
INSERT INTO haw1868_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Eia hoi na mea mua o ko lakou mau ohana kupuna: O na keiki a Reubena, a ka hiapo a Iseraela; o Hanoka, o Palu, o Hezerona, a o Karemi: o lakou na ohana a Reubena. ");
INSERT INTO haw1868_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","A o na keiki a Simeona; o Iemuela, a o Iamina, o Ohada, o Iakina, o Zohara, a o Saula ke keiki a kekahi wahine Kanaana: o lakou na ohana a Simeona. ");
INSERT INTO haw1868_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Eia hoi na inoa o na keiki a Levi, ma ko lakou mau hanauna: o Geresona, o Kohata, a o Merari: a o na makahiki o ko Levi ola ana, hookahi haneri me kanakolukumamahiku na makahiki. ");
INSERT INTO haw1868_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","O na keiki a Geresona, o Libeni, a o Simi, ma ka laua mau ohana. ");
INSERT INTO haw1868_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","A o na keiki a Kohata; o Amerama, o Izehara, o Heberona, a me Uziela: a o na makahiki o ko Kohata ola ana, hookahi haneri me kanakolukumamakolu na makahiki. ");
INSERT INTO haw1868_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","A o na keiki a Merari; o Mahali a o Musi: o lakou nei na ohana a Levi, ma na hanauna o lakou. ");
INSERT INTO haw1868_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Lawe iho la o Amerama ia Iokebeda, i ke kaikuwahine o kona makuakane, i wahine nana; a hanau mai la nana o Aarona laua o Mose: a o na makahiki o ko Amerama ola ana, hookahi haneri me kanakolukumamahiku na makahiki. ");
INSERT INTO haw1868_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","A o na keiki a Izehara, o Kora, o Nepega, a me Zikeri. ");
INSERT INTO haw1868_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","A o na keiki a Uziela; o Misaela, o Elezapana, a me Ziteri. ");
INSERT INTO haw1868_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Lawe ae la o Aarona ia Eliseba, i ke kaikamahine a Aminadaba, o ke kaikuwahine o Nahesona i wahine nana, a hanau mai la nana, o Nadaba, o Abihu, o Eleazara a me Itamara. ");
INSERT INTO haw1868_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","A o na keiki a Kora; o Asira, o Elekana, a o Abiasapa; o lakou na ohana a Kora. ");
INSERT INTO haw1868_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Lawe ae la o Eleazara ke keiki a Aarona i kekahi kaikamahine a Putiela i wahine nana: a ua hanau mai nana o Pinehasa; o lakou na mea mua o na makua o ka Levi, ma ka lakou mau ohana. ");
INSERT INTO haw1868_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Oia o ua Aarona la laua o ua Mose la, na mea a Iehova i olelo mai ai, E lawe mai olua i na mamo a Iseraela mai Aigupita mai, ma ko lakou poe kaua. ");
INSERT INTO haw1868_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","O laua no na mea i olelo ia Parao i ke alii o Aigupita, no ka lawe ana mai i na mamo a Iseraela, mai Aigupita mai: o ua Mose la no keia laua o Aarona. ");
INSERT INTO haw1868_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","A i ka la a Iehova i olelo mai ai ia Mose ma ka aina o Aigupita, ");
INSERT INTO haw1868_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","Olelo mai la o Iehova ia Mose, i mai la, Owau no Iehova: e hai aku oe ia Parao i ke alii o Aigupita, i na mea a pau a'u e olelo aku ai ia oe. ");
INSERT INTO haw1868_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Olelo aku o Mose imua o Iehova, Aia hoi, he lehelehe hemahema ko'u, pehea la e hoolohe mai ai o Parao ia'u? ");
INSERT INTO haw1868_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","I MAI la o Iehova ia Mose, e nana hoi, ua hoonoho wau ia oe i akua no Parao, a o Aarona kou kaikuaana, oia no auanei kou kaula. ");
INSERT INTO haw1868_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","O na mea a pau a'u e kauoha aku ai ia oe, oia kau e hai aku ai: a o Aarona kou kaikuaana ke olelo aku ia Parao, e hoouna aku ia i na mamo a Iseraela mai kona aina aku. ");
INSERT INTO haw1868_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","A e hoopaakiki auanei au i ka naau o Parao, a e hana no au i ko'u mau ouli a nui, a me ko'u mau mea mana ma ka aina o Aigupita. ");
INSERT INTO haw1868_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Aole nae e hoolohe mai o Parao ia olua, i kau aku ai au i ko'u lima maluna o Aigupita, a e lawe mai iwaho i ko'u poe kaua i ka poe kanaka o'u, i na mamo a Iseraela, mai ka aina o Aigupita mai, me ka hoopai nui aku. ");
INSERT INTO haw1868_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","A e ike auanei ko Aigupita, owau no Iehova, ia'u e hookakauha aku ai i ko'u lima maluna o Aigupita, a e lawe mai i na mamo a Iseraela maiwaena mai o lakou. ");
INSERT INTO haw1868_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Hana iho la o Mose laua o Aarona, e like me ka Iehova i kauoha mai ai ia laua; pela laua i hana aku ai. ");
INSERT INTO haw1868_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","He kanawalu na makahiki o Mose, a he kanawalu na makahiki o Aarona a me kumamakolu, i ka wa a laua i olelo aku ai ia Parao. ");
INSERT INTO haw1868_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Olelo mai la o Iehova ia Mose a me Aarona, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","I ka wa e olelo mai ai o Parao ia olua, i ka i ana mai, E hoike mai olua i kekahi hana mana; alaila e olelo ae oe ia Aarona, E lalau i kou kookoo, a e kiola iho imua o Parao, a e lilo ia i nahesa: ");
INSERT INTO haw1868_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Hele aku la o Mose laua o Aarona io Parao la, hana iho la laua e like me ke kauoha ana a Iehova, a kiola iho la o Aarona i kona kookoo imua o Parao, a imua o kana poe kauwa, a lilo iho la ia i nahesa. ");
INSERT INTO haw1868_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Kii aku la hoi o Parao i na kanaka akamai, a me na kilo; a o na magoi o Aigupita, hana iho la hoi lakou pela, i ko lakou kilokilo ana. ");
INSERT INTO haw1868_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","No ka mea, kiola iho la kela kanaka keia kanaka a pau i kona kookoo iho, i lilo lakou i mau nahesa: aka, o ke kookoo o Aarona, moni iho la ia i ko lakou mau kookoo. ");
INSERT INTO haw1868_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","A hoopaakikiia mai la ka naau o Parao, i hoolohe ole ai oia ia laua, e like me ka mea a Iehova i olelo mai ai. ");
INSERT INTO haw1868_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","I mai la o Iehova ia Mose, Ua hoopaakikiia ko Parao naau, i ole ai ia e hookuu mai i ka poe kanaka. ");
INSERT INTO haw1868_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","A kakahiaka ae, e hele oe io Parao la, aia e hele ana no ia i ka wai; e ku oe ma ke kapa o ka muliwai e halawai me ia: a e lawe oe ma kou lima i ke kookoo i lilo ai i nahesa. ");
INSERT INTO haw1868_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","A e olelo aku oe ia ia, Ua hoouna mai nei ke Akua o ka poe Hebera ia'u ion nei, ua i mai, E hookuu mai oe i ko'u poe kanaka, i hookauwa mai lakou na'u ma ka waonahele: aia hoi, aole oe i manao e hoolohe mamua. ");
INSERT INTO haw1868_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Ke olelo mai nei o Iehova penei, Ma keia mea e ike auanei oe, owau no Iehova: aia hoi, e hahau no wau i keia kookoo ma kuu lima, maluna o ka wai maloko o ka muliwai, a e lilo ia i koko. ");
INSERT INTO haw1868_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","A e make no ka ia maloko o ka muliwai, a e hoopailua ko Aigupita ke inu i ka wai o ka muliwai. ");
INSERT INTO haw1868_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","I mai la o Iehova ia Mose, E olelo aku oe ia Aarona, E lalau oe i kou kookoo, a e o aku kou lima maluna o na wai o Aigupita, ma na kahawai, a ma na muliwai, a ma na loko, a ma na huinawai a pau o lakou, i lilo ai lakou i koko: i hiki mai ke koko ma na aina a pau o Aigupita nei, maloko o ka laau, a maloko o ka pohaku. ");
INSERT INTO haw1868_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","A hana iho la o Mose laua o Aarona e like me ka mea a Iehova i olelo mai ai. Hapai ae la ia i ke kookoo a hahau iho la i ka wai maloko o ka muliwai, imua i ke alo o Parao, a imua i ke alo o kana poe kauwa: a lilo ae la ka wai a pau o ka muliwai i koko. ");
INSERT INTO haw1868_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","A make iho la ka ia maloko o ka muliwai; pilau mai la ka muliwai; aole i hiki i ko Aigupita ke inu i ka wai o ua muliwai la: a he koko no ma ka aina o Aigupita a pau. ");
INSERT INTO haw1868_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Hana iho la no pela na magoi o Aigupita i ko lakou mea e kilokilo ai; a ua hoopaakikiia ka naau o Parao, aole hoi ia i hoolohe mai ia laua, e like no me ka mea a Iehova i olelo mai ai. ");
INSERT INTO haw1868_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Huli ae la o Parao, a hoi aku la i kona hale; aole hoi ia i kau aku i kona manao ma ia mea. ");
INSERT INTO haw1868_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Kohi iho la ko Aigupita a pau i na wahi e kokoke ana i ka muliwai, i loaa'i ka wai e inu: no ka mea, aole i hiki ia lakou ke inu i ka wai o ka muliwai. ");
INSERT INTO haw1868_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","A ua hala ae la na la ehiku mai ka wa mai o ko Iehova hahau ana i ka muliwai. ");
INSERT INTO haw1868_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","ALAILA, i mai la o Iehova ia Mose, O hele oe io Parao la, a e i aku ia ia, Ke i mai nei o Iehova penei, E hookuu mai oe i ko'u poe Kanaka, i hookauwa mai lakou na'u. ");
INSERT INTO haw1868_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","A ina paha e hookuu ole mai oe, aia hoi, e hoino no wau i kou mau mokuna a pau i na rana; ");
INSERT INTO haw1868_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","A e hoopuka nui mai ka muliwai i na rana, a e hele mai lakou iloko o kou hale, a me kou keena moe, a maluna o kou hikiee, a iloko o ka hale o kau poe kauwa, a maluna o kou poe kanaka, a maloko o kou mau imu, a maloko hoi o kou mau pa wili ai. ");
INSERT INTO haw1868_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","A e hele mai auanei na rana maluna ou, a maluna o kou poe kanaka, a maluna o kau poe kauwa a pau. ");
INSERT INTO haw1868_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","I mai la o Iehova ia Mose, E i aku oe ia Aarona, E o aku kou lima me kou kookoo maluna o na kahawai, a me na muliwai, a me na loko, i hiki mai na rana maluna o ka aina o Aigupita. ");
INSERT INTO haw1868_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","O aku la no ko Aarona lima maluna o ka wai o Aigupita, a hiki mai la na rana, a hoouhi paapu ae la i ka aina o Aigupita. ");
INSERT INTO haw1868_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Hana iho la no pela na magoi i ka lakou mea e kilokilo ai, i hoohiki mai ai i na rana ma ka aina o Aigupita. ");
INSERT INTO haw1868_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Alaila, hea mai la o Parao ia Mose a me Aarona, i mai la, E pule aku olua ia Iehova, i lawe aku ia i na rana mai o'u aku nei, a mai ko'u poe kanaka aku, a e hookuu no wau i na kanaka, i kaumaha ai lakou na Iehova. ");
INSERT INTO haw1868_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","I aku la o Mose ia Parao, E kauoha pono mai oe ia'u, i ka manawa hea ka'u e pule aku ai nou, a no kau poe kauwa hoi, a no kou poe kanaka, i laweia aku na rana mai ou aku la, a mai kou kauhale aku, a koe ma ka muliwai wale no? ");
INSERT INTO haw1868_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Olelo mai la kela, Apopo. I aku la ia, E like me kau olelo, pela no auanei ia, i ike pono ai oe, aohe mea e ae e like me Iehova ko makou Akua. ");
INSERT INTO haw1868_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","A e haalele mai no na rana ia oe, a me kou hale, a me kau poe kauwa, a me kou poe kanaka, a e koe ma ka muliwai wale no. ");
INSERT INTO haw1868_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Hele aku la o Mose laua o Aarona mai o Parao aku la: uwe aku la o Mose ia Iehova no na rana ana i lawe mai ai maluna o Parao. ");
INSERT INTO haw1868_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Hana iho la o Iehova e like me ka Mose olelo ana, a make iho la na rana ma na hale, a ma na pahale a ma na kula. ");
INSERT INTO haw1868_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Hoiliili ae la lakou i na rana ma na puu: a pilau iho la ka aina. ");
INSERT INTO haw1868_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","A ike iho la o Parao, he maha, hoopaakiki iho la ia i kona naau, aole i hoolohe mai i ka laua; e like me ka Iehova i olelo mai ai. ");
INSERT INTO haw1868_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Olelo mai la o Iehova ia Mose, E i aku oe ia Aarona, e o aku oe i kou kookoo, a e hahau i ka lepo o ka aina, i lilo ia i makika ma ka aina a pau o Aigupita. ");
INSERT INTO haw1868_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Hana iho la laua pela; o aku la no ko Aarona lima me kona kookoo, hahau iho la i ka lepo o ka aina, a lilo ae la ia i makika ma na kanaka, a ma na holoholona; lilo no na hunalepo a pau o ka aina i makika ma ka aina a pau o Aigupita. ");
INSERT INTO haw1868_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Hana iho la no pela na magoi, me ko lakou mea kilokilo, i hiki mai ai ka makika, aole nae i hiki ia lakou. He makika no nae maluna o na kanaka, a maluna o na holoholona. ");
INSERT INTO haw1868_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Alaila olelo ae la na magoi ia Parao, Eia no ka lima o ke Akua. Ua hoopaakikiia no nae ko Parao naau; aole ia i hoolohe i ka laua, e like me ka Iehova i olelo mai ai. ");
INSERT INTO haw1868_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Olelo mai la o Iehova ia Mose, A kakahiaka nui, e ala ae oe, a e ku imua i ke alo o Parao, aia hoi, e hele mai no ia iwaho i ka wai, a e i aku oe ia ia, Ke olelo mai nei o Iehova penei, E hookuu oe i ko'u poe kanaka, i hookauwa mai lakou na'u. ");
INSERT INTO haw1868_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Aka hoi, ina aole oe e hookuu mai i ko'u poe kanaka, aia hoi, e hoouna aku no au i na nalonahu maluna ou, a maluna o kau poe kauwa, a maluna o kou poe kanaka, a maloko o kou mau hale; a e piha na hale o ko Aigupita i na nalonahu, a me ka aina hoi kahi a lakou e noho ai. ");
INSERT INTO haw1868_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Ia la hoi, e hookaawale auanei au i ka aina o Gosena, i kahi e noho nei ko'u poe kanaka, i hiki ole ai ka nalonahu ilaila; i mea e ike ai oe, owau no Iehova mawaena o ka honua. ");
INSERT INTO haw1868_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","A e kaa no au i pale mawaena o ko'u poe kanaka a me kou poe kanaka. Apopo e hiki mai keia mea. ");
INSERT INTO haw1868_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Hana iho la no o Iehova pela: a hiki mai la na nalonahu he nui loa maloko o ka hale o Parao, a me na hale o kana poe kauwa, a ma ka aina a pau o Aigupita: ua oki loa ka aina i na nalonahu. ");
INSERT INTO haw1868_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Hea mai la o Parao ia Mose a me Aarona, i mai la, E hele oukou, a e kaumaha aku i ko oukou Akua maloko o ka aina nei. ");
INSERT INTO haw1868_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","I aku la o Mose, Aole pono ke hana pela; no ka mea, e kaumaha auanei makou na Iehova ko makou Akua i ka mea hoopailua a ko Aigupita nei: a ina e kaumaha aku makou i ka mea hoopailua a ko Aigupita nei imua o ko lakou maka, aole anei lakou e hailuku mai ia makou i ka pohaku? ");
INSERT INTO haw1868_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","E hele no makou i ekolu la hele iloko o ka waonahele, a e kaumaha aku na Iehova ko makou Akua, e like me kana e kauoha mai ai ia makou. ");
INSERT INTO haw1868_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","I mai la o Parao, E hookuu aku no wau ia oukou, i kaumaha aku ai oukou na Iehova ko oukou Akua, ma ka waonahele: aka, mai hele aku oukou i kahi mamao. E pule aku olua no'u. ");
INSERT INTO haw1868_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","I aku la o Mose, Aia hoi, ke hele aku nei au mai ou aku nei, a e nonoi aku au ia Iehova e lawe aku ia i na nalonahu mai o Parao aku, a mai kana poe kauwa aku, a mai kona poe kanaka aku; aia apopo. Aka, mai hoopunipuni hou mai o Parao. i ka hookuu ole i na kanaka e kaumaha aku na Iehova. ");
INSERT INTO haw1868_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Hele aku la o Mose mai o Parao aku, a nonoi aku la ia Iehova. ");
INSERT INTO haw1868_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Hana mai la o Iehova e like me ka olelo a Mose, a lawe aku la ia i na nalonahu mai o Parao aku, a mai kana poe kauwa aku, a mai kona poe kanaka aku; aole hookahi i koe. ");
INSERT INTO haw1868_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Hoopaakiki hou iho la o Parao i kona naau ia manawa no hoi, aole i hookuu aku i na kanaka. ");
INSERT INTO haw1868_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","OLELO mai la o Iehova ia Mose, E hele oe io Parao la, a e i aku ia ia, ke olelo mai nei o Iehova ke Akua o na Hebera penei, E hookuu mai oe i ko'u poe kanaka, i hookauwa mai ai lakou na'u. ");
INSERT INTO haw1868_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","No ka mea, ina aole oe e hookuu mai, a e hoopaa loa ia lakou, ");
INSERT INTO haw1868_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","Aia hoi, e kau ana no o Iehova i kona lima maluna o kau poe holoholona ma ke kula, maluna o na lio, a maluna o na hoki, a maluna o na kamelo, a maluna o na bipi, a maluna o na hipa: he ahulau nui loa. ");
INSERT INTO haw1868_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","A e hookaawale o Iehova mawaena o na holoholona a ka Iseraela, a me na holoholona a ko Aigupita. Aole no e make kekahi mea a ka poe mamo a Iseraela. ");
INSERT INTO haw1868_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Haawi mai la o Iehova i wa maopopo, i mai la, Apopo e hana mai ai o Iehova i keia mea ma ka aina. ");
INSERT INTO haw1868_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","A ia la iho no, hana mai la o Iehova i ua mea la, a make iho la na holoholona a pau o Aigupita: aka, o na holoholona a na mamo a Iseraela, aole kekahi i make. ");
INSERT INTO haw1868_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Hoouna aku la o Parao, aia hoi, aole i make kekahi o ka Iseraela poe holoholona. A na hoopaakikiia ka naau o Parao, aole ia i hookuu aku i na kanaka. ");
INSERT INTO haw1868_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Olelo mai la o Iehova ia Mose a me Aarona, E lalau olua a piha ko olua mau poho lima i ka lehu o ke kapuahi, a na Mose e lu aku ia mea ma ka lani imua o na maka o Parao. ");
INSERT INTO haw1868_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","A e lilo no ia i lepo makalii ma ka aina a pau o Aigupita, a e lilo ia i puupuu e poha ana i na maihehe, maluna o na Kanaka, a maluna o na holoholona, ma ka aina a pau o Aigupita. ");
INSERT INTO haw1868_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Lalau ae la laua i lehu o ke kapuahi, a ku iho la imua o Parao; a lu ae la o Mose iluna i ka lani, a lilo ae la ia mea i puupuu e poha ana i na maihehe maluna o kanaka, a maluna o na holoholona. ");
INSERT INTO haw1868_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Aole i hiki i na Magoi ke ku imua o Mose, no na maihehe, no ka mea, maluna no o ka poe Magoi ua maihehe la, a maluna no o ko Aigupita a pau. ");
INSERT INTO haw1868_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Hoopaakiki mai la o Iehova i ka naau o Parao, a hoolohe ole mai la oia ia laua, e like me ka Iehova i olelo mai ai ia Mose. ");
INSERT INTO haw1868_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","I mai la o Iehova ia Mose, E ala ae oe i kakahiaka nui, a e ku imua o Parao, a e olelo aku ia ia, Ke i mai nei o Iehova ke Akua o ka poe Hebera penei, E hookuu mai i ko'u poe kanaka i hookauwa mai lakou na'u. ");
INSERT INTO haw1868_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","No ka mea, ma keia hope aku, e hoouna aku no wau i ko'u mau mea hoino a pau maluna o kou naau, a maluna o kau poe kauwa, a maluna o kou poe kanaka, i ike pono ai oe, ohe mea e ae e like me au ma ka honua a pau. ");
INSERT INTO haw1868_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","No ka mea, ano e o aku ana ko'u lima, i hahau aku ai au ia oe, a me kou poe kanaka i ke ahulau, a e hookiia'e oe mai ka honua aku. ");
INSERT INTO haw1868_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Aka, no keia mea, i hooku ae au ia oe, i mea e holke aku ai au i ko'u mana ma ou la, a i kaulana aku ai ko'u inoa ma ka honua a pau. ");
INSERT INTO haw1868_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Ke hookiekie nei anei oe ia oe iho a hiki i keia wa, e ku e i ko'u poe kanaka, i ole ai e hookuu aku ia lakou? ");
INSERT INTO haw1868_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Aia hoi, a hiki i keia hora o ka la apopo, alaila e hooua iho no au i ka huahekili he nui loa, aole lua e like me ia ma Aigupita nei, mai kona wa i hookumuia'i a hiki i keia manawa. ");
INSERT INTO haw1868_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Nolaila la, e hoouna aku oe e hoakoakoa ae i kau poe holoholona a me kau mau mea a pau ma ke kula: o na kanaka a me na holoholona a pau e koe ma ke kula, aole e hoihoiia maloko o ka hale, e haule mai no ka huahekili maluna iho o lakou, a e make lakou. ");
INSERT INTO haw1868_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","A o ka mea iwaena o na kauwa a Parao i makau i ka olelo a Iehova, hoakoakoa iho la ia i kana poe kauwa, a me kana poe holoholona iloko o na hale. ");
INSERT INTO haw1868_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","A o ka mea huli ole i kona naau ma ka olelo a Iehova, waiho iho la ia i kana poe kauwa a me kana poe holoholona ma ke kula. ");
INSERT INTO haw1868_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","I mai la o Iehova ia Mose, E o aku i kou lima ma ka lani, i hiki mai ai ka huahekili ma ka aina a pau o Aigupita, maluna o na kanaka, a maluna o na holoholona, a maluna o na mea uliuli a pau o ke kula, a puni ka aina o Aigupita. ");
INSERT INTO haw1868_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","O aku la o Mose i kona kookoo ma ka lani; a hoouka mai la o Iehova i ke hekili a me ka huahekili, a naholo mai la ka uila maluna o ka honua; a hooua mai la o Iehova i ka huahekili maluna o ka aina o Aigupita. ");
INSERT INTO haw1868_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","He huahekili no, a ua hui pu ka uila me ka huahekili, he nui loa, aohe mea e like ai ma ka aina a pau o Aigupita, mai ka manawa i lilo ai ia i aupuni. ");
INSERT INTO haw1868_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Paopao mai la ka huahekili ma ka aina a pau o Aigupita, i na mea a pau ma ke kula, i na kanaka a me na holoholona: paopao mai la ka huahekili i na mea uliuli a pau o ke kula, a weluwelu iho la na laau a pau ma ke kula. ");
INSERT INTO haw1868_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","O ka aina i Gosena wale no, o kahi i noho ai na mamo a Iseraela, aohe huahekili ilaila. ");
INSERT INTO haw1868_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Hoouna mai la o Parao, hea mai la ia Mose a me Aarona, i mai la ia laua, Ua hewa no wau i keia manawa; ua hemolele o Iehova, aka, owau a me ko'u poe kanaka, ua hewa makou. ");
INSERT INTO haw1868_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","E nonoi aku olua ia Iehova, U'oki; i ole ai e kui hou ke hekili o ke Akua, a i pau hoi ka huahekili: a e hookuu aku no wau ia oukou, aole oukou e kali hou aku. ");
INSERT INTO haw1868_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","I aku la o Mose ia ia, I ko'u puka ana aku mawaho o ke kulanakauhale, e kikoo aku no wau i ko'u mau lima ia Iehova; a e pau no ke hekili, aole hoi e huahekili hou, i ike ai oe, no Iehova ka honua. ");
INSERT INTO haw1868_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Aka o oe, a me kau poe kauwa, ua ike no au, aole no oukou e makau i keia manawa ia Iehova ke Akua. ");
INSERT INTO haw1868_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","A make iho la ke olona, a me ka palaoa huluhulu, no ka mea, ua pua ae la ka palaoa huluhulu, a ua pua ke olona. ");
INSERT INTO haw1868_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Aka, o ka palaoa, a me ka palaoa eleele, aole i make, no ka mea, ua opiopio. ");
INSERT INTO haw1868_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Hele aku la o Mose mawaho o ke kulanakauhale, mai o Parao aku, a kikoo aku la i kona mau lima imua o Iehova; a ua pau iho la ke hekili a me ka huahekili, aole i ninini hou ia mai ka ua maluna o ka honua. ");
INSERT INTO haw1868_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","A ike iho la o Parao, ua pau ka ua, a me ke hekili, hewa hou iho la no ia, a hoopaakiki iho la i kona naau, oia a me kana poe kauwa. ");
INSERT INTO haw1868_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Ua hoopaakikiia ka naau o Parao, aole hoi ia i hookuu aku i na mamo a Iseraela, e like me ka Iehova i olelo mai ai ma o Mose la. ");
INSERT INTO haw1868_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","OLELO mai la o Iehova ia Mose, E hele aku oe iloko io Parao la, no ke mea, ua hoopaakiki au i kona naau, a me ka naau o kana poe kauwa, i hoike aku ai au i keia mau hoailona o'u iwaena o lakou; ");
INSERT INTO haw1868_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","A i hai aku ai oe maloko o na pepeiao o kau keiki, a o ke keiki a kau keiki i na mea a'u i hana'i ma Aigupita, a me ko'u mau hoailona a'u i hana aku ai ia lakou, i ike ai oukou, owau no Iehova. ");
INSERT INTO haw1868_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Hele aku la o Mose laua o Aarona iloko io Parao la, i aku la ia ia, Ke i mai nei o Iehova, ke Akua o na Hebera, penei, Pehea la ka loihi o kou hoohaahaa ole ana ia oe iho imua o'u? E hookuu mai oe i ko'u poe kanaka, i hookauwa mai lakou na'u. ");
INSERT INTO haw1868_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Aka, ina e hoole oe, aole e hookuu mai i ko'u poe kanaka, aia hoi, i ka la apopo, e halihali mai no wau i na uhini ma kou aina. ");
INSERT INTO haw1868_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","A e uhi mai auanei lakou maluna o ka aina, aole e ikea ka aina ke nana aku: a e ai iho no lakou i ke koena o na mea i waihoia na oukou e ka huahekili: a e ai iho hoi lakou i na laau a pau e ulu ana no oukou ma ke kula. ");
INSERT INTO haw1868_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","E hoopiha hoi lakou i na hale ou, a me na hale o kau poe kauwa a pau, a me na hale o ko Aigupita a pau: aole i ike kou poe makua i keia mea, aole hoi na makua o kou poe makua, mai ka wa i noho mai ai lakou ma ka honua, a hiki i keia la, Haliu ae la ia, a hele aku la mai o Parao aku. ");
INSERT INTO haw1868_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Olelo aku la na kauwa a Parao ia ia, Pehea la ka loihi o ka hoohihia ana o keia kanaka ia kakou? E hookuu aku i ua poe kanaka la, i hookauwa aku ai lakou na Iehova na ko lakou Akua. Aole anei oe i ike i neia manawa, ua oki loa o Aigupita nei? ");
INSERT INTO haw1868_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Ua lawe hou ia aku o Mose laua o Aarona io Parao la, i mai la ia ia laua, E hele oukou, e hookauwa na Iehova na ko oukou Akua. Owai, owai hoi ka poe hele? ");
INSERT INTO haw1868_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","I aku la o Mose, E hele pu no makou me ko makou poe opiopio a me ko makou poe elemakule, me na keikikane a me na kaikamahine a makou, me ka makou hipa, a me ka makou bipi makou e hele aku ai: no ka mea, he ahaaina ka makou no Iehova. ");
INSERT INTO haw1868_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","I mai la kela ia laua, o Iehova kekahi pu me oukou, ke hookuu aku au ia oukou, e hele me ka oukou poe keiki. E malama ia olua, no ka mea, aia no ka hewa ma ko olua alo. ");
INSERT INTO haw1868_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Aole pela: o oukou na kanaka ke hele, e hookauwa aku na Iehova; no ka mea, oia ka oukou mea i imi mai nei. A ua kipakuia mai laua, mai ke alo mai o Parao. ");
INSERT INTO haw1868_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","I mai la o Iehova ia Mose, E o aku kou lima, maluna o ka aina o Aigupita no na uhini, i hele mai ai lakou maluna o ka aina o Aigupita, a e ai iho i na laauikiai a pau o ka aina, i na mea a pau i waihoia e ka huahekili. ");
INSERT INTO haw1868_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","O aku la o Mose i kona kookoo maluna o ka aina o Aigupita, a huai mai la o Iehova i ka makani mai ka hikina mai maluna o ka aina, ia la a po, ia po a ao; a i kakahiaka, hoopuka mai la ua makani hikina la i na uhini. ");
INSERT INTO haw1868_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Lele ae la na uhini maluna o ka aina a pau o Aigupita, a kau iho la ma na mokuna a pau o Aigupita: he ino loa; aohe uhini mamua e like ai, aole hoi e hiki mai ana mahope o lakou na mea e like ai. ");
INSERT INTO haw1868_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","No ka mea, uhi paapu iho la lakou i ka aina a pau, a poeleele hoi ka aina; ai iho la lakou i na laauikiai a pau o ka aina, a me ka hua a pau o na laau, a ka huahekili i waino mai ai; aole i koe kekahi mea uliuli ma na laau, a ma na laauikiai o ke kula, ma ka aina a pau o Aigupita. ");
INSERT INTO haw1868_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Alaila, wikiwiki ae la o Parao e hea mai ia Mose laua o Aarona, i mai la, Ua hana hewa wau ia Iehova i ko oukou Akua, a ia olua no hoi. ");
INSERT INTO haw1868_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Ke noi aku nei au, e kala mai no hoi olua i keia hewa hookahi ana no, a e nonoi aku ia Iehova ike oukou Akua, i lawe aku ai ia i keia make wale no, mai o'u aku nei. ");
INSERT INTO haw1868_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Hele aku la ia mai o Parao aku, a nonoi aku la ia Iehova. ");
INSERT INTO haw1868_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Huai hou mai la o Iehova i makani komohana ikaika, a lawe aku la ia i na uhini, a hoopaa iho la ia lakou iloko o ke Kaiula. Aohe uhini hookahi i koe ma ka aina a pau i Aigupita. ");
INSERT INTO haw1868_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Aka, hoopaakiki iho la o Iehova i ko Parao naau, aole ia hookuu aku i na mamo a Iseraela. ");
INSERT INTO haw1868_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","I mai la o Iehova ia Mose, E o aku kou lima i ka lani, i kau mai ka poeleele maluna o ka aina o Aigupita, i aaki ka pouli. ");
INSERT INTO haw1868_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","O aku la no ko Mose lima i ka lani, a pouli loa iho la ka aina a pau o Aigupita i na la ekolu. ");
INSERT INTO haw1868_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Aole loa lakou i ike i kekahi i kekahi, aole hoi i ala ae kekahi mai kona wahi ae, i na la ekolu; aka, o na mamo a pau a Iseraela, he malamalama ko lakou iloko o ko lakou mau hale. ");
INSERT INTO haw1868_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Hea mai la o Parao ia Mose, i mai la, Ou haele oukou, e hookauwa aku na Iehova; aka, o ka oukou hipa, a me ka oukou bipi, e waiho ia lakou: e hele pu no hoi ka oukou poe keiki. ");
INSERT INTO haw1868_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","I aku la o Mose, E haawi mai hoi iloko o ko makou mau lima, i na mohai, a me na mohai kuni, i kanmaha aku ai makou na Iehova na ko makou Akua. ");
INSERT INTO haw1868_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","E hele pu no hoi ka makou holoholona, aole e waihoia kekahi maanei; no ka mea, e lawe ana makou i na mea o lakou e malama'i ia Iehova i ko makou Akua: aole nae makou e ike i na mea o lakou ka makou e malama ai ia Iehova, a hiki aku makou ilaila. ");
INSERT INTO haw1868_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Aka, hoopaakiki mai la o Iehova i ka naau o Parao, aole no ia i hookuu ia lakou. ");
INSERT INTO haw1868_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","I mai la o Parao ia ia, E hele aku oe pela, mai o'u aku nei, e malama ia oe iho, aole e ike hou mai i ko'u maka, no ka mea, i ka la au e nana hou mai ai i ko'u maka, e make oe. ");
INSERT INTO haw1868_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","I aku la o Mose ia ia, Ua olelo pono mai oe; aole au e ike hou aku i kou maka. ");
INSERT INTO haw1868_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","I MAI la o Iehova ia Mose, E hoouka mai ana au i hookahi hoino hou maluna o Parao, a maluna o Aigupita, a mahope iho, e hookuu mai no ia ia oukou: a i ka la ana e hookuu mai ai ia oukou, alaila e kipaku loa oia ia oukou. ");
INSERT INTO haw1868_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","E olelo aku oe iloko o na pepeiao o kanaka, e nonoi aku kela kanaka keia kanaka a pau i kona hoalauna, a o kela wahine keia wahine i kona hoalauna, i na mea kala a me na mea gula. ");
INSERT INTO haw1868_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Haawi mai la o Iehova i ka lokomaikai i na kanaka imua o ka maka o ko Aigupita. He kanaka nui no hoi o Mose ma ka aina o Aigupita imua o ka maka o na kauwa a Parao, imua hoi o na maka o kanaka. ");
INSERT INTO haw1868_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Olelo aku la o Mose, Penei ka Iehova i i mai nei, A hiki i ke aumoe, e hele aku no au iwaena konu o Aigupita nei. ");
INSERT INTO haw1868_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","A e make auanei na hiapo a pau o ka aina o Aigupita nei, mai ka hiapo mai a Parao, ka mea noho ma kona nohoalii, a hiki i ka hiapo a ke kauwawahine e noho ana ma ka mea wili palaoa; a me na hiapo a pau a na holoholona. ");
INSERT INTO haw1868_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","A e nui loa auanei ka uwe ana ma ka aina a pau i Aigupita nei; aohe mea e like me ia mamua, aole hoi he mea e like ana mahope. ");
INSERT INTO haw1868_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Aka, aole loa e hookala mai kekahi ilio i kona alelo e ku e i kekahi o na mamo a Iseraela; aole i ke kanaka, aole i na holoholona; i ike ai oukou i ka Iehova pale ana mawaena o ko Aigupita a me ka Iseraela. ");
INSERT INTO haw1868_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","A o keia poe kauwa au, e hele mai no lakou io'u nei, a e kulou ilalo imua o'u, a e i mai, E hele aku oe, a me na kanaka a pau mamuli ou. A mahope iho e puka aku no wau. Hele ae la ia mai o Parao mai me ka wela o kona huhu. ");
INSERT INTO haw1868_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Olelo mai la o Iehova ia Mose, Aole e hoolohe mai o Parao ia olua, i mea e nui ai ko'u mau ouli ma ka aina o Aigupita. ");
INSERT INTO haw1868_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Hana iho la o Mose laua o Aarona i keia mau ouli a pau imua i ke alo o Parao; a hoopaakiki mai la o Iehova i ka naau o Parao, aole ia i hookuu mai i na mamo a Iseraela mai kona aina mai. ");
INSERT INTO haw1868_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","OLELO mai la o Iehova ia Mose laua o Aarona, ma ka aina o Aigupita, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","Eia ka malama makamua o ko oukou mau malama, eia ka malama mua o ko oukou makahiki. ");
INSERT INTO haw1868_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","E olelo aku olua i ka poe kanaka o ka Iseraela a pau, e i aku, I ka la umi o keia malama, e lawe kela kanaka keia kanaka i hipakeiki ma ko ka hale o na makua, he hipakeiki no ka hale hookahi. ");
INSERT INTO haw1868_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Aka, ina he uuku ko ka hale, aole lawa no ka hipakeiki, e lawe pu ia me kona hoalauna e kokoke aua ma kona hale, e like me ka nui o lakou; e like me ka ai ana a kela kanaka keia kanaka, pela no oukou e helu ai i na hipakeiki. ");
INSERT INTO haw1868_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","I hipakeiki kina ole ka oukou, he kane o ka makahiki hookahi: noloko o ka poe hipa paha, noloko o ka poe kao paha ka oukou e lawe ai ia ia. ");
INSERT INTO haw1868_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Na oukou ia e malama a hiki i ka la umikumamaha o ia malama; a na ke anaina kanaka a pau o ka Iseraela e pepehi iho ia i ke ahiahi. ");
INSERT INTO haw1868_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","A e lawe lakou i ke koko, a e kau aku ma na lapauila a elua, a maluna ma ka hoaka o ka puka o na hale, kahi a lakou e ai ai ia mea. ");
INSERT INTO haw1868_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","A ia po no, e ai lakou i ka io i ohinuia i ke ahi, e ai pu lakou ia mea me ka palaoa hu ole, a me na mea mulemule. ");
INSERT INTO haw1868_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Mai ai maka oukou ia mea, aole hoi i hoolapalapaia i ka wai; aka, e ohinuia i ke ahi; o kona poo, me kona mau wawae, a me kona naau. ");
INSERT INTO haw1868_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Mai waiho oukou i kekahi a ao; a ina e koe kekahi mea a ao, e hoopau oukou ia mea i ke ahi. ");
INSERT INTO haw1868_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Penei oukou e ai ai; e hoolikiia ko oukou puhaka, a me na kamaa e paa ana ma ko oukou mau wawae, a me ke kookoo ma ko oukou lima: e ai wikiwiki oukou, no ka mea, o ka moliaola ia na Iehova. ");
INSERT INTO haw1868_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","No ka mea, e hele aku ana au ma ka aina a pau o Aigupita i keia po, a e pepehi no wau i na hiapo a pau ma ka aina o Aigupita, o ka ke kanaka a me ka ka holoholona: a e hoopai aku no wau i na akua a pau o Aigupita: owau no Iehova. ");
INSERT INTO haw1868_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","A o ke koko, oia ka hoailona no oukou ma na hale o ko oukou wahi: aia ike aku au i ke koko, e waiho wau ia oukou, aole e kau mai ka mea ino maluna o oukou e make ai, ia'u e pepehi iho ai i ko ka aina o Aigupita. ");
INSERT INTO haw1868_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","A e lilo no keia la i mea e hoomanao ai no oukou: a e malama oukou ia la i ahaaina na Iehova, a hiki i ko oukou mau hanauna a pau: e malama oukou ia i ahaaina, ma ke kanawai mau loa. ");
INSERT INTO haw1868_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Ehiku mau la ka oukou e ai ai i ka berena hu ole; i ka la mua e hoolei aku oukou i ka mea hu mawaho o ko oukou mau hale: o ka mea nana e ai i ka berena hu, mai ka la akahi a hiki i ka la hiku, e okiia'ku ia mai ka Iseraela aku. ");
INSERT INTO haw1868_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","A i ka la makamua, hookahi halawai hemolele ana, a i ka hiku o ka la, hookahi halawai hemolele ana o oukou. Ia mau la la, aohe hana maoli, o ka mea wale no a kela kanaka a keia kanaka e ai ai, oia wale no ka mea a oukou e hana'i. ");
INSERT INTO haw1868_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","E malama no oukou i ka ahaaina berena hu ole; no ka mea, ia la no ua lawe mai au i ko oukou poe koa, mai ka aina mai o Aigupita: no ia mea, e malama oukou i keia la i ka oukou mau hanauna aku, ma ke kanawai mau loa. ");
INSERT INTO haw1868_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","I ka malama makamua, i ka la umikumamaha o ka malama, i ke ahiahi, alaila e ai oukou i ka berena hu ole, a hiki i ke ahiahi o ka la iwakaluakumamakahi o ua malama la. ");
INSERT INTO haw1868_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Ehiku la e loaa ole ai ka mea hu maloko o ko oukou mau hale. O ka mea ai i ka palaoa hu, oia ke hookiia aku mai ke anaina kanaka o ka Iseraela aku: ina paha ho kanaka e oia, a ina paha o ka mea i hanau ma ka aina. ");
INSERT INTO haw1868_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Mai ai oukou i kekahi mea hu: ma na hale o oukou a pau, e ai oukou i ka berena hu ole. ");
INSERT INTO haw1868_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Alaila, kii aku la o Mose i na lunakahiko a pau o ka Iseraela, i aku la ia lakou, E wae oukou, a e lawe i ka oukou hipakeiki, ma ka oukou mau ohana, a e pepehi i ka moliaola. ");
INSERT INTO haw1868_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","A e lawe oukou i pupu husopa, a e kupenu iho iloko o ke koko ma ko kiaha, a e hamo i ka hoaka a me na lapauila elua o ka puka, i ke koko oloko o ke kiaha, a mai puka aku kekahi o oukou mawaho o ka puka o kona hale, a kakahiaka. ");
INSERT INTO haw1868_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","No ka mea, e hele ae ana o Iehova e pepehi i ko Aigupita, a ike mai ia i ke koko ma ka hoaka a ma na lapauila, e waiho no o Iehova ia puka, aole ia e ae mai i ka mea luku e komo i ko oukou mau hale e pepehi mai. ");
INSERT INTO haw1868_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","E malama oukou i keia mea i kanawai mau loa no oukou, a no ka oukou poe keiki. ");
INSERT INTO haw1868_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","A hiki aku oukou i ka aina a Iehova e haawi mai ai no oukou, e like me kana i olelo mai ai, alaila e malama oukou i keia oihana. ");
INSERT INTO haw1868_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","A i ka wa e olelo mai ai ka oukou poe keiki ia oukou, Heaha ke ano o keia oihana ia oukou? ");
INSERT INTO haw1868_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","E olelo aku oukou, O ka mohai moliaola keia na Iehova, nana no i waiho i na hale o na mamo a Iseraela ma Aigupita, i ka wa ana i pepehi aku ai i ko Aigupita, a hoopakele mai i ko na hale o makou. Kulou iho la ke poo o kanaka a hoomana aku la. ");
INSERT INTO haw1868_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Hele aku la na mamo a Iseraela, hana iho la e like me ka mea a Iehova i kauoha mai ai ia Mose laua o Aarona, pela lakou i hana'i. ");
INSERT INTO haw1868_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","A hiki i ke aumoe, pepehi iho la o Iehova i na hiapo a pau, ma ka aina o Aigupita, mai ka hiapo a Parao, a ka mea noho maluna o kona nohoalii, a hiki i ka hiapo a ka mea pio iloko o ka hale luapaahao, a me na hiapo a pau a na holoholona. ");
INSERT INTO haw1868_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Ala ae la o Parao i ka po, oia a me kana poe kauwa a pau, a me ko Aigupita a pau: a he nui loa ke kupinai ana ma Aigupita, no ka mea, aohe hale i make ole ai kekahi. ");
INSERT INTO haw1868_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Hea mai la oia ia Mose laua o Aarona i ka po, i mai la, E ku ae olua e hele aku maiwaena aku o ko'u poe kanaka, o olua a me na mamo a Iseraela: e hele, e hookauwa aku na Iehova, e like me ka olua i olelo mai ai. ");
INSERT INTO haw1868_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","E lawe pu aku no i ka oukou poe hipa, a me ka oukou poe bipi, e like me ka olua i olelo ai, a e hele: a e hoomaikai hoi olua ia'u. ");
INSERT INTO haw1868_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Ikaika iho la ka manao o ko Aigupita, e kipaku koke ia lakou mai ka aina aku: no ka mea, Ua pau makou i ka make, wahi a lakou. ");
INSERT INTO haw1868_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Lawe mai la na kanaka i ka lakou berena maka, hu ole, a me ko lakou mau papawiliai, ua ope pu ia me ko lakou lole maluna o ko lakou mau hokua. ");
INSERT INTO haw1868_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Hana iho la na mamo a Iseraela, e like me ka olelo ana a Mose, a nonoi aku la i ko Aigupita i na mea kala, a me na mea gula, a me na mea aahu. ");
INSERT INTO haw1868_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","A haawi mai la o Iehova i ka lokomaikaiia i na kanaka imua o ka maka o ko Aigupita, a haawi mai la lakou: pela lakou i hao ai i ko Aigupita. ");
INSERT INTO haw1868_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Hele mai la na mamo a Iseraela mai Ramese a hiki i Sukota, eono paha haneri tausani kane i hele wawae, a he okoa na kamalii. ");
INSERT INTO haw1868_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Hele pu mai la ka poe e he nui loa, i hui pu ia mai, a me na hipa, a me na bipi, he nui loa na holoholona. ");
INSERT INTO haw1868_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Pulehu iho la lakou i berena hu ole o ka berena maka a lakou i lawe mai ai mai Aigupita mai, aole ia i hu, no ka mea, ua kipakuia lakou mailoko mai o Aigupita, aole i hiki ia lakou ke kali, aole hoi lakou i hoomakaukau i o na lakou iho. ");
INSERT INTO haw1868_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","O ka noho ana o na mamo a Iseraela, i noho ai lakou ma Aigupita, eha haneri makahiki a me ke kanakolu. ");
INSERT INTO haw1868_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","A pau aku la ia mau makahiki eha haneri a me ke kanakolu, ia la no, hele mai la ka poe koa a pau o Iehova, mai ka aina mai o Aigupita. ");
INSERT INTO haw1868_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","He po ia e hoomanao nui ia'i no Iehova, no kona lawe ana mai ia lakou mai ka aina mai o Aigupita: eia no ka po o Iehova e hoomanaoia'i e na mamo a pau a Iseraela, ma na hanauna o lakou. ");
INSERT INTO haw1868_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","I mai la o Iehova ia Mose laua o Aarona, Eia no ke kanawai o ka moliaola; aole e ai ke kanaka e i a mea. ");
INSERT INTO haw1868_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Aka, o ke kauwa a kela kanaka keia kanaka i kuaiia i ke kala, aia okipoepoe iho oe ia ia, alaila ia e ai iho ai ia mea. ");
INSERT INTO haw1868_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","O ke kanaka e, a me ke kauwa i hoolimalimaia, aole laua e ai ia mea. ");
INSERT INTO haw1868_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","I ka hale hookahi no e aiia'i ia mea; mai lawe oukou i kekahi io ma kahi e aku mawaho o ka hale; mai uhai hoi oukou i kekahi iwi o ia mea. ");
INSERT INTO haw1868_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","E hana no ke anaina kanaka o Iseraela a pau ia mea. ");
INSERT INTO haw1868_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","A i noho pu kekahi kanaka e me oe, a manao no ia e malama i ka moliaola no Iehova, e okipoepoeia kona poe kane a pau; alaila e hookokoke mai ia e malama ia mea; a e lilo ia i mea like me ka mea i hanauia ma ka aina: no ka mea, aole loa e ai kekahi ia mea, ke okipoepoe ole ia oia. ");
INSERT INTO haw1868_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Hookahi no kanawai no ke kanaka i hanauia ma ko oukou wahi, a me ke kanaka e, e noho pu ana me oukou. ");
INSERT INTO haw1868_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Pela no i hana'i na mamo a Iseraela a pau; e like me ka mea a Iehova i kauoha mai ai ia Mose a ia Aarona, pela lakou i hana'i. ");
INSERT INTO haw1868_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Ia la no, lawe mai la no o Iehova i na mamo a Iseraela mai ka aina o Aigupita mai, ma ko lakou poe koa. ");
INSERT INTO haw1868_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","OLELO mai la o Iehova ia Mose, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","E hoolaa mai i na hiapo a pau na'u, o na mea a pau o na mamo a Iseraela i hanau mua o ka ke kanaka, a o ka ka holoholona, na'u no ia. ");
INSERT INTO haw1868_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","I aku la o Mose i na kanaka, E hoomanao oukou i keia la a oukou i puka mai ai, mailoko mai o Aigupita, a mailoko ae o ka hale hooluhi; no ka mea, ua lawe mai nei o Iehova ia oukou mailoko mai o ia wahi, me ka lima ikaika: aole e aiia ka berena hu. ");
INSERT INTO haw1868_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","I keia la oukou i hele mai ai, i ka malama o Abiba. ");
INSERT INTO haw1868_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","A i ka wa a Iehova e lawe aku ai ia oe iloko i ka aina o ka Kanaana, a o ka Heta, a o ka Amora, a o ka Hiva a me ka Iebusa, i kahi ana i hoohiki ai i kou poe kupuna, e haawi mai oia nou, he aina e kahe ana o ka waiu a me ka meli; alaila, i keia malama, e hana oe i keia oihana. ");
INSERT INTO haw1868_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Ehiku mau la au e ai ai i ka berena hu ole, a i ka hiku o ka la, he ahaaina no Iehova. ");
INSERT INTO haw1868_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","I na la ehiku e aiia ka berena hu ole; aole loa e ikea ka berena hu me oe, aole hoi e ikea ka mea hu me oe, i kou mau wahi a pau. ");
INSERT INTO haw1868_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","A e hoike aku oe i kau keikikane i kela la, i ka i ana aku, No ka mea keia a Iehova i hana mai ai ia'u, i ko'u puka ana mai iwaho o Aigupita. ");
INSERT INTO haw1868_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","He hoailona no ia nou ma kou lima, he mea hoomanao no hoi mawaena o kou mau maka, i mau ke kanawai o Iehova ma kou waha; no ka mea, me ka lima ikaika ka Iehova i lawe mai ai ia oe mai Aigupita mai. ");
INSERT INTO haw1868_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","No ia mea, e malama oe i keia oihana, i kona manawa, ia makahiki aku, ia makahiki aku. ");
INSERT INTO haw1868_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Eia hoi kekahi, a hiki i ka wa a Iehova e lawe aku ai ia oe i ka aina o ka Kanaana, e like me kana i hoohiki mai ai ia oe, a i kou poe kupuna, a e haawi mai ana hoi nou; ");
INSERT INTO haw1868_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","Alaila e hoolaa ae oe no Iehova i na mea a pau i hanau mua, a o na hiapo a pau a na holoholona ou; no Iehova no na kane. ");
INSERT INTO haw1868_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","A o na keiki mua a pau a ka hoki, e panai aku oe no ia i keikihipa; a i ole oe e panai, alaila e uhai i kona a-i. A o na keiki mua a pau a kanaka, iwaena o kau poe keiki, o lakou kau e panai aku. ");
INSERT INTO haw1868_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Eia hoi, a i ka wa e ninau mai ai kau keikikane mahope aku nei, e i mai ana, Heaha keia? alaila e hai aku oe ia ia, Me ka lima ikaika ka Iehova i lawe mai ai ia makou mailoko mai o Aigupita, a mailoko mai hoi o ka hale hooluhi; ");
INSERT INTO haw1868_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","A i ka wa i aua ai o Parao i ke kuu mai ia makou, alaila pepehi iho la o Iehova i na hiapo a pau ma ka aina o Aigupita, o ka hiapo a ke kanaka a me ka hiapo a ka holoholona: nolaila ka'u e mohai aku nei i na kane a pau i hanau mua: aka, o na hiapo a pau a ka'u mau keiki, oia ka'u e hoolapanai aku. ");
INSERT INTO haw1868_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","A e lilo keia mea i hoailona ma kou lima, a he mea hoomanao hoi mawaena o kou mau maka; no ka mea, me ka lima ikaika i lawe mai ai o Iehova ia kakou mawaho mai o Aigupita. ");
INSERT INTO haw1868_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","A i ka wa i hookuu mai ai o Parao i na kanaka, aole i alakai mai ke Akua ia lakou ma ke ala o ka aina o ka poe Pilisetia, oia no nae ke ala kokoke; no ka mea, i iho la ke Akua, E makau paha na kanaka, ke ike lakou i ke kaua, a hoi hou lakou i Aigupita. ");
INSERT INTO haw1868_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Aka, alakai puni ae la ke Akua i na kanaka ma ke ala o ka. waonahele o ke Kaiula: hele makaukau mai la na mamo a Iseraela, mai ka aina o Aigupita mai. ");
INSERT INTO haw1868_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Lawe pu mai la o Mose me ia i na iwi o Iosepa; no ka mea, ua kauoha ikaika mai oia i na mamo a Iseraela, i ka i ana mai, He oiaio no, e hele mai ke Akua e ike ia oukou; a e lawe aku hoi oukou i ko'u mau iwi me oukou. ");
INSERT INTO haw1868_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Hele aku la lakou mai Sukota aku, a hoomoana ma Etama, ma ke kihi o ka waonahele. ");
INSERT INTO haw1868_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Hele aku la o Iehova mamua o lakou maloko o ke kia ao i ke ao, e alakai ia lakou ma ke ala; a maloko o ke kia ahi i ka po, e hoomalamalama mai ia lakou; i hele lakou i ke ao a me ka po. ");
INSERT INTO haw1868_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Aole ia i lawe aku i ke kia ao i ke ao, aole hoi i ke kia ahi i ka po, mai ke alo o na kanaka aku. ");
INSERT INTO haw1868_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","OLELO mai la o Iehova ia Mose, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","E i aku oe i na mamo a Iseraela, e kipa ae lakou, a e hoomoana ma ke alo o Pihahirota, mawaena o Migedola a me ke kai, ma kahi e ku pono ana i Baalazepona: ma ke alo o ia wahi oukou e hoomoana ai, ma kahakai. ");
INSERT INTO haw1868_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","E olelo auanei o Parao no na mamo a Iseraela, Ua pilikia lakou iloko o ua aina la, ua paa lakou i ka waonahele. ");
INSERT INTO haw1868_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","A na'u no e hoopaakiki i ka naau o Parao, i hahai mai ai oia mahope o lakou: a e hoouaniia auanei au maluna o Parao, a maluna o kona puali a pau; i ike ai hoi ko Aigupita, owau no Iehova. A pela no lakou i hana'i. ");
INSERT INTO haw1868_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","A haiia aku la i ke alii o Aigupita, Ua holo na kanaka; huli ka naau o Parao a me na kauwa ana e ku e i na kanaka: olelo iho la lakou, no ke aha la kakou i hana'i i keia, a hookuu aku i ka Iseraela i hookauwa ole ai lakou na kakou? ");
INSERT INTO haw1868_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Hoomakaukau ae la ia i kona kaakaua, a lawe pu aku la i kona poe kanaka me ia. ");
INSERT INTO haw1868_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Lawe aku la ia i na halekaa i waeia eono haneri, a me na kaakaua a pau o Aigupita, a me na luna o ia mau mea a pau. ");
INSERT INTO haw1868_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Hoopaakiki iho la o Iehova i ka naau o Parao, o ke alii o Aigupita, a hahai mai la ia mahope o na mamo a Iseraela: a puka mai la na mamo a Iseraela mawaho me ka lima hookiekie. ");
INSERT INTO haw1868_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Hahai mai la ko Aigupita mahope o lakou, o na lio a pau, a me na kaakaua o Parao, a me kona hoohololio, a me kona poe koa, a loaa mai lakou nei e hoomoana ana ma kahakai, ma Pihahirota, e ku pono ana i Baalazepona. ");
INSERT INTO haw1868_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","A hookokoke mai la o Parao, alawa ae la na maka o na mamo a Iseraela, aia hoi, e hele mai ana ko Aigupita mahope o lakou; makau loa iho la lakou: a uwe aku la na mamo a Iseraela ia Iehova. ");
INSERT INTO haw1868_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","I mai la hoi lakou ia Mose, No ka mea, aohe lua kupapau ma Aigupita, ua lawe mai anei oe ia makou e make ma keia waonahele? No ke aha la kau i hana mai ai ia makou pela, i ka lawe ana mai nei ia makou mai Aigupita mai? ");
INSERT INTO haw1868_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Aole anei keia o ka olelo a makou i hai aku ai ia oe ma Aigupita, i ka i ana aku, E waiho pela ia makou, i hookauwa aku ai makou na ko Aigupita? No ka mea, he mea maikai no makou ke hookauwa aku na ko Aigupita, aole hoi e make ma ka waonahele. ");
INSERT INTO haw1868_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Olelo aku la o Mose i na kanaka, mai makau oukou, e ku malie oukou, a e nana aku i ka hoola ana o Iehova, i ka mea ana e hoike mai ai ia oukou i keia la; no ka mea, o ko Aigupita a oukou i ike ai i keia la, aole oukou e ike hou ia lakou, mahope mau loa aku. ");
INSERT INTO haw1868_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Na Iehova no e kaua aku no oukou, a e noho malie oukou. ");
INSERT INTO haw1868_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","I mai la o Iehova ia Mose, No ke ah a la oe e kahea mai nei ia'u? e i aku oe i na mamo a Iseraela, e hele aku lakou imua. ");
INSERT INTO haw1868_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Aka, E hapai oe i kou kookoo, a e o aku kou lima maluna o ke kai, a e hookaawale ia: a e hele aku no na mamo o Iseraela mawaena o ke kai, ma kahi maloo. ");
INSERT INTO haw1868_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","A na'u iho no e hoopaakiki i na naau o ko Aigupita, a e hahai mai lakou mahope o lakou nei: a e hoonani au ia'u iho ma o Parao la a ma kona poe koa a pau, a ma kona mau kaakaua, a me na hoohololio ona. ");
INSERT INTO haw1868_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","A e ike auanei ko Aigupita, owau no Iehova, ke hoonani wau ia'u iho ma o Parao la, a me kona mau kaakaua, a me na hoohololio ona. ");
INSERT INTO haw1868_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","A o ka anela o ke Akua i hele mamua o ke kahua hoomoana o ka Iseraela, hoi aku la ia mahope o lakou; a hele ae la hoi ke kia ao mai mua ao o lakou, a ku iho la mahope o lakou. ");
INSERT INTO haw1868_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Hele mai la ia mawaena o ko Aigupita poe a me ka Iseraela: a lilo ia i ao pouli; a hoomalamalama mai no nae i ka po; nolaila, aole i hookokoke mai kela poe i keia mai ia po a ao. ");
INSERT INTO haw1868_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","O aku la o Mose i kona lima maluna o ke kai; na Iehova i hookahe ke kai me ka makani ikaika, mai ka hikina mai, i kela po a ao, a lilo iho la ke kai i aina maloo, a ua maheleia ae la na wai. ");
INSERT INTO haw1868_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Hele mai la na mamo a Iseraela mawaena o ke kai ma kahi maloo: a lilo ka wai i pali no lakou ma ko lakou lima akau a me ko lakou lima hema. ");
INSERT INTO haw1868_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Hahai mai la ko Aigupita, a hele mai mahope o lakou, o na lio a pau o Parao, a me kona mau kaakaua, a me na hoohololio iwaena o ke kai. ");
INSERT INTO haw1868_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","A hiki i ka wati wanaao, nana mai la o Iehova i ka poe kaua o Aigupita, mai ke kia ahi a me ke ao mai, a hoopilikia ae la i ka poe kaua o Aigupita. ");
INSERT INTO haw1868_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Hoohemohemo iho la ia i na huila o ko lakou mau kaakaua, i hele pupu ai lakou; no ia mea, olelo mai la ko Aigupita, E auhee kakou mai ke alo aku o ka Iseraela; no ka mea, ua kaua mai no o Iehova me lakou pu i ko Aigupita. ");
INSERT INTO haw1868_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Olelo mai la o Iehova ia Mose, E o aku kou lima maluna o ke kai, i hoi hou mai ai ka wai maluna o ko Aigupita, maluna o ko lakou mau halekaa, a maluna o ko lakou poe hoohololio. ");
INSERT INTO haw1868_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Hoo aku la no o Mose i kona lima maluna o ke kai, a hoi mai no ke kai i kona piha ana i ka wa e pualena ana o ke ao; auhee aku la ko Aigupita i ka loaa ana o ka wai; a lulu iho la o Iehova i ko Aigupita iloko o ke kai. ");
INSERT INTO haw1868_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Hoi hou aku la ke kai, a popoi iho la maluna o na kaakaua, a me na hoohololio, a me ka poe koa a pau o Parao i hele mai iloko o ke kai mahope o lakou: aole loa kekahi o lakou i koe. ");
INSERT INTO haw1868_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Aka, o na mamo a Iseraela, hele mai la lakou ma kahi maloo iwaenakonu o ke kai: a o na wai, he pali ia no lakou ma ko lakou lima akau, a me ko lakou lima hema. ");
INSERT INTO haw1868_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Pela i hoola mai ai o Iehova i ka Iseraela ia la, mai ka lima o ko Aigupita mai; a ike aku la ka Iseraela i ko Aigupita maluna o kahakai, ua make. ");
INSERT INTO haw1868_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Ike aku la ka Iseraela i kela hana nui a Iehova i hana aku ai i ko Aigupita: a makau iho la na kanaka ia Iehova; a manaoio aku la lakou ia Iehova, a me kana kauwa o Mose. ");
INSERT INTO haw1868_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","A LAILA mele aku la o Mose, a me na mamo a Iseraela i keia mele ia Iehova: olelo aku la ia me ka i ana aku, Ia Iehova no wau e mele aku ai, No ka mea, ua hoonani loa oia ia ia iho; Ua kiola oia i ka lio, a me kona mea hooholo iloko o ke kai. ");
INSERT INTO haw1868_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","O Iehova no ko'u ikaika, a me ka'u mele, Oia ko'u hoola, o ko'u Akua hoi ia, E hoomakaukau no wau i wahi nona e noho ai. O ke Akua no ia o ko'u makua, A e mililani aku au ia ia. ");
INSERT INTO haw1868_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","He kanaka kaua o Iehova, O Iehova no kona inoa. ");
INSERT INTO haw1868_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Ua ka oia i ke kai i na kaakaua o Parao, A me kona poe koa; Ua poho ilalo o ke Kaiula kona poe kaua ma na kaa: ");
INSERT INTO haw1868_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Ua poipu ka hohonu ia lakou; Poho lakou ilalo me he pohaku la. ");
INSERT INTO haw1868_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Ua nani kou lima akau, e Iehova, no ka mana; Na kou lima akau, e Iehova, i paki iho i ka enemi. ");
INSERT INTO haw1868_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","I ka nui o kou nani, ua hoopuehu aku oe i ka poe i ala ku e mai ia oe; Hoouna aku oe i kou huhu, Pau iho la lakou me he opala la. ");
INSERT INTO haw1868_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","I ka hoohanu ana o kou mau pukaihu, ua hoakoakoaia mai na wai, Ea ae la na wai iluna, me he puu la: Lilo no ka hohonu i mea paa maloko o ka opu o ke kai. ");
INSERT INTO haw1868_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","I iho la ka enemi, E hahai aku no au, E loaa no, a puunauwe aku i ka waiwai pio. E maona auanei ko'u kuko ia lakou, E unuhi au i ko'u pahikaua, A e loaa hou no lakou i ko'u lima. ");
INSERT INTO haw1868_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Pupuhi no oe me kou makani, Uhi mai la ke kai ia lakou, Poho iho la lakou ilalo i ke kai me he kepau la. ");
INSERT INTO haw1868_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Owai ka mea iwaena o ka poe ikaika e like me oe, e Iehova? Owai kou mea like, ma ka nani o ka hemolele? He mea weliweli ka hoomana aku, Ua hana oe i na mea kupanaha. ");
INSERT INTO haw1868_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","O aku la no kou lima akau, Ale iho la ka honua ia lakou. ");
INSERT INTO haw1868_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Ma ka lokomaikai no oe i alakai mai ai i na kanaka au i hoolapanai ai; Me kou mana no oe i alakai ai ia lakou i kahi hemolele au i noho ai. ");
INSERT INTO haw1868_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","E lohe auanei na kanaka, a e makau hoi. E loohia auanei ka poe noho ma Palisetina i ka weliweli. ");
INSERT INTO haw1868_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Alaila, e weliweli mai na'lii o Edoma, E loohia no hoi ka poe ikaika o Moaba i ka haalulu, E hehee auanei ka poe a pau e noho ana ma Kanaana. ");
INSERT INTO haw1868_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","E kau mai no ka makau a me ka weliweli maluna o lakou; No ka nui o kou lima e noho malie lakou me he pohaku la; A hala'e kou poe kanaka, e Iehova, A hala'e na kanaka au i hoolapanai ai. ");
INSERT INTO haw1868_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Nau no lakou e hookomo, A e hoonoho hoi ia lakou ma ka puu o kou hooilina, I kahi au i hana'i i wahi e noho ai nou, e Iehova, I ke keenakapu hoi a kou mau lima i hookumu ai, e ka Haku. ");
INSERT INTO haw1868_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","E noho alii mau loa aku no o Iehova. ");
INSERT INTO haw1868_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","No ka mea, hele ae la ka lio o Parao, Me kona kaahaua, a me na hoohololio ona, A iloko o ke kai, A hoihoi mai la o Iehova i na wai o ke kai maluna o lakou; Aka, o na mamo a Iseraela, Hele ae la lakou ma kahi maloo mawaenakonu o ke kai. ");
INSERT INTO haw1868_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","A o Miriama, ke kaula wahine, ke kaikuwahine o Aarona, lawe ae la ia i mea kuolokani ma kona lima, a hahai aku la na wahine a pau mamuli ona, me na mea kuolokai, a me ka hula. ");
INSERT INTO haw1868_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","I mai la o Miriama ia lakou, E mele aku oukou ia Iehova, No ka mea, ua lanakila loa oia, Ua kiola oia i ka lio a me kona mea hooholo i ke kai. ");
INSERT INTO haw1868_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Pela i lawe mai ai o Mose i ka Iseraela, mai ke Kaiula mai, a hele mai la lakou i ka waonahele i Sura; hele mai la lakou maloko o ka waonahele i na la ekolu, aole hoi i loaa ka wai. ");
INSERT INTO haw1868_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","A hiki mai la lakou i Mara; aole hiki ia lakou ke inu i ka wai o Mara, no ka mea, ua mulea ia; no ia mea, i kapaia'ku ai ia o Mara. ");
INSERT INTO haw1868_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Ohumu ae la na kanaka ia Mose, i ae la, Heaha la ko makou mea inu? ");
INSERT INTO haw1868_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Uwe aku la oia ia Iehova; a hoike mai la o Iehova ia ia i kekahi laau, a hooleiia'ku la ia mea e ia iloko o ka wai, hanaia mai la ka wai a ono: malaila ia i hana'i i olelo kupaa no lakou, a i kanawai hoi, a maiaila oia i hoao ai ia lakou. ");
INSERT INTO haw1868_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","I mai la, A i hoolohe mau mai oe i ka leo o Iehova, o kou Akua, a e hana i ka mea pono imua o kona maka, a e hoolohe i ka mea ana e kauoha mai ai, a malama i kona mau kanawai, alaila aole au e kau maluna ou i kekahi o keia mau mai a'u i kau ai maluna o ko Aigupita; no ka mea, owau no Iehova, ka mea hoola aku ia oe. ");
INSERT INTO haw1868_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","A hele mai la lakou i Elima, malaila na punawai he umikumamalua, a me na laau pama he kanahiku: noho iho la lakou ilaila ma kahi o na wai. ");
INSERT INTO haw1868_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","HELE mai la lakou, mai Elima mai, a hiki mai la ka poe mamo a pau a Iseraela i ka waonahele i Sina, he wahi ia mawaena o, Elima a me Sinai, o ka la umikumamalima ia o ka malama alua, mai ko lakou puka ana mai iwaho, mai ka aina o Aigupita mai. ");
INSERT INTO haw1868_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Ohumu ae la ka poe mamo a pau a Iseraela ia Mose ma laua o Aarona, ma ka waonahele; ");
INSERT INTO haw1868_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","I mai la na mamo a Iseraela ia laua, Ina i haawiia mai ka make no kakou, i ka lima o Iehova, ma ka aina o Aigupita, i ka wa a kakou i noho ai ma na ipu ia, a ai aku no hoi kakou i ka ai a maona; no ka mea, ua lawe mai olua ia kakou, maloko o keia waonahele, e pepehi i keia poe a pau i ka pololi. ");
INSERT INTO haw1868_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","I mai la o Iehova ia Mose, Aia hoi, e hooua aku au i ka ai, mai ka lani aku; a e hele aku na kanaka mawaho, e hoouluulu i ko ka la ma ia la, i hoao aku ai au ia lakou, e hele paha lakou ma ko'u kanawai, aole paha. ");
INSERT INTO haw1868_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","A hiki i ka la aono, e hoomakaukau lakou i ka mea a lakou e lawe mai ai iloko; e papalua ia i ka mea a lakou e hoouluulu ai i kela la i keia la. ");
INSERT INTO haw1868_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Olelo mai la o Mose laua o Aarona i na mamo a pau a Iseraela, A ahiahi, alaila oukou e ike, na Iehova no oukou i lawe mai nei, mai ka aina mai o Aigupita: ");
INSERT INTO haw1868_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","A kakahiaka, alaila oukou e ike ai i ka nani o Iehova; no kona hoolohe ana i ka mea a oukou i ohumu aku ai ia Iehova: heaha hoi maua, i ohumu mai ai oukou ia maua? ");
INSERT INTO haw1868_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","I mai la o Mose, E haawi mai ana o Iehova i ke ahiahi, i ia na oukou e ai ai, a kakahiaka i ai e maona ai; no ka mea, ua lohe mai o Iehova i ka ohumu ana a oukou i ohumu aku ai ia ia: Heaha hoi o maua? aole no maua ka oukou ohumu ana, aka, no Iehova. ");
INSERT INTO haw1868_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Olelo ae la o Mose ia Aarona, E i aku oe i ka poe mamo a pau a Iseraela, E hele mai lakou imua i ke alo o Iehova: no ka mea, ua lohe ia i ka oukou ohumu ana. ");
INSERT INTO haw1868_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","A i ka Aarona olelo ana i ka poe mamo a pau a Iseraela, alawa ae la lakou ma ka waonahele, aia hoi, ikea aku la ka nani o Iehova ma ke ao. ");
INSERT INTO haw1868_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Olelo mai la o Iehova ia Mose, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","Ua lohe au i na ohumu ana a na mamo a Iseraela: E olelo aku oe ia lakou, e i aku, A ahiahi, e ai ana oukou i ka ia, a kakahiaka ae, e maona oukou i ka ai: a e ike auanei oukou, owau no Iehova, ko oukou Akua. ");
INSERT INTO haw1868_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","A i ke ahiahi, hiki mai la na selu, a uhi mai la ma kahi a lakou i hoomoana'i: a kakahiaka ae, ahu iho la ka hau, a puni na kahua. ");
INSERT INTO haw1868_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","A i ka lele ana o ka hau i ahuia mai ai, aia hoi, ma ka ili honua o ka waonahele, he mea liilii me he unahi la, me he hau paa la ka liilii. ");
INSERT INTO haw1868_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","A ike aku la na mamo a Iseraela, olelo ae la kekahi o na kanaka i kona hoa, Heaha keia? no ka mea, aole lakou i ike ia mea. Olelo mai la o Mose ia lakou, Eia ka ai a Iehova i haawi mai ai, i mea na oukou o ai ai. ");
INSERT INTO haw1868_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Eia hoi ka olelo a Iehova i kauoha mai ai, E hoiliili ke kanaka ia mea, e like me ka kona waha e ai ai, hookahi kanaka hookahi omera; e lawe oukou a pau e like me ka nui o ko oukou poe, o kela kanaka keia kanaka no ka poe o kona halelewa. ");
INSERT INTO haw1868_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Hana iho la na mamo a Iseraela pela, a he nui ka kekahi i hoiliili ai, a he uuku iho ka kekahi. ");
INSERT INTO haw1868_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","A i ko lakou ana ana ma ka omera, o ka mea hoiliili nui, aohe ana i koe, a o ka mea hoiliili uuku, aole hoi i emi kana: hoiliili kela kanaka keia kanaka e like me ka kona waha i ai ai. ");
INSERT INTO haw1868_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","I aku la o Mose ia lakou, Mai hookoe kekahi kanaka ia mea a kakahiaka. ");
INSERT INTO haw1868_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Aole nae lakou i hoolohe mai i ka Mose; hookoe no kekahi ia mea a kakahiaka, a piha iho la ia i na ilo, a pilau no hoi: a huhu aku la o Mose ia lakou. ");
INSERT INTO haw1868_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Hoiliili lakou ia mea i kela kakahiaka i keia kakahiaka, o kanaka a pau e like me ka lakou ai ana; a i ka wa i mahana ae ai ka la, hehee iho la ia mea. ");
INSERT INTO haw1868_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","A hiki i ka la eono, hoiliili papalua iho la lakou i ka ai, elua omera a ke kanaka hookahi: a hele aku la na luna a pau o na kanaka, a hai aku la ia Mose. ");
INSERT INTO haw1868_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","I mai la ia ia lakou, Oia hoi ka mea a Iehova i olelo mai ai, i ka la apopo ka hoomaha ana o ka sabati laa no Iehova: ka mea a oukou e kalua ai, e kalua, a o ka mea a oukou e hoolapalapa ai, e hoolapalapa: a o ke koena a pau e hoana e oukou, i malamaia ia mea na oukou no ke kakahiaka. ");
INSERT INTO haw1868_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Hoana e no lakou ia mea, a kakahiaka, e like me ka Mose i kauoha mai ai; aole hoi ia i pilau, aohe ilo hoi maloko o ia mea. ");
INSERT INTO haw1868_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","I mai la o Mose, E ai oukou ia mea i keia la; no ka mea, eia ka sabati no Iehova, i keia la aole e loaa ia mea ma ke kula. ");
INSERT INTO haw1868_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Eono o oukou la e hoouluulu ai; a o ka hiku o ka la, o ka sabati ia, ia la, aole. ");
INSERT INTO haw1868_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","A i ka hiku o ka la, hele aku la no kekahi o na kanaka e hoouluulu, aole nae i loaa ia lakou. ");
INSERT INTO haw1868_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Olelo mai la o Iehova ia Mose, Pehea la ka loihi o ko oukou hoole ana, aole e malama i ka'u mau kauoha, a me ko'u mau kanawai? ");
INSERT INTO haw1868_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","E nana hoi, no ka mea, ua haawi aku o Iehova ia oukou i ka sabati: no ia mea, ua haawi aku la ia na oukou ma ke ono o ka la, i ai no na la elua; e noho oukou, o keia kanaka keia kanaka ma kona wahi iho; mai hele ke kanaka mai kona wahi aku i ka la sabati. ");
INSERT INTO haw1868_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","A hoomaha iho la na kanaka ma ka hiku o ka la. ");
INSERT INTO haw1868_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Kapa aku ka ohana Iseraela i ka inoa o ia mea he Mane: ua like no ia me ka hua koriana, ua keokeo; a i ka ai ana ua like no ia me na wepa me ka meli. ");
INSERT INTO haw1868_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","I mai la o Mose, Eia ka mea a Iehova i kauoha mai nei, E hoopiha i kekahi omera o ia mea, i malama loa ia no kau poe mamo; i ike lakou i ka ai a'u i hanai aku ai ia oukou ma ka waonahele, i ka wa a'u i lawe mai ai ia oukou mai ka aina o Aigupita mai. ");
INSERT INTO haw1868_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","I ae la o Mose ia Aarona, E lawe oe i ipu, a e hahao iloko i kekahi omera a piha i ka mane, a e hoana e imua i ke alo o Iehova, i malama loa ia ia mea no kau poe mamo. ");
INSERT INTO haw1868_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","E like me ka mea a Iehova i kauoha mai ai ia Mose, pela i hoana e ai o Aarona ia mea imua i ke alo o ke kanawai e malama loa ia'i. ");
INSERT INTO haw1868_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Ai iho la na mamo o Iseraela i ka mane hookahi kanaha makahiki, a hiki lakou i ka aina kanaka; ai no lakou i ka mane, a hiki lakou i ke kihi o ka aina i Kanaana. ");
INSERT INTO haw1868_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Hookahi omera, he hapanmi ia no ka epa. ");
INSERT INTO haw1868_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","HELE mai la ka poe mamo a pau a Iseraela, mai ka waonahele o Sina, i ko lakou hele ana, e like no me ke kauoha a Iehova, a hoomoana iho la lakou ma Repidima: aohe hoi wai e inu no na kanaka. ");
INSERT INTO haw1868_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Nuku mai la na kanaka ia Mose, i mai la, E haawi mai i wai no makou e inu ai. I aku la, o Mose ia lakou, No ke aha la oukou i nuku mai ai ia'u? no ke aha la oukou i aa aku ai ia Iehova? ");
INSERT INTO haw1868_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Malaila na kanaka i makewai ai; ohumu ae la na kanaka ia Mose, i mai la lakou, No ke aha la oe i lawe mai ai ia makou, mai Aigupita mai, e make makou, a me ka makou keiki, a me ka makou holoholona, i ka makewai? ");
INSERT INTO haw1868_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Uwe aku la o Mose ia Iehova, i aka la, Pehea la ka'u e hana mai ai i keia poe kanaka? ua kokoke lakou e hailuku mai ia'u. ");
INSERT INTO haw1868_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","I mai la o Iehova ia Mose, E hele ae oe mamua o na kanaka; a e lawe pu aku me oe i na lunakahiko o ka Iseraela; a e lawe no hoi ma kou lima i ke kookoo au i hahau ai i na wai, a e hele: ");
INSERT INTO haw1868_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Aia hoi, e ku no wau ilaila imua ou maluna o ka pohaku ma Horeba; a e hahau oe i ka pohaku, a e puka mai no ka wai mailoko mai o ia mea i inu ai na kanaka. Hana iho la no o Mose pela imua o na lunakahiko a pau o ka Iseraela. ");
INSERT INTO haw1868_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Kapa aku la oia i ka inoa o ia wahi, o Masa, a me Meriba, no ka nuku ana o na mamo o Iseraela, a me ko lakou aa ana ia Iehova, i ae la, O Iehova anei kekahi iwaena o kakou, aole paha? ");
INSERT INTO haw1868_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Hele mai la ka Ameleka, a kaua mai i ka Iseraela ma Repidima. ");
INSERT INTO haw1868_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Olelo ae la o Mose ia Iosua, E wae ae oe i kanaka no kakou, a e hele e kaua aku i ka Ameleka: apopo e ku wau maluna pono o ka puu, me ke kookoo o ke Akua ma ko'u lima. ");
INSERT INTO haw1868_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Hana iho la o Iosua e like me ka mea a Mose i olelo mai ai ia ia, a kaua aku la i ka Ameleka: a o Mose, a me Aarona, a me Hura, pii aku la lakou maluna pono o ka puu. ");
INSERT INTO haw1868_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","A i ka wa a Mose i kikoo aku ai i kona lima, ikaika ka Iseraela: a i ka wa i alu mai ai kona lima, ikaika ka Ameleka. ");
INSERT INTO haw1868_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Kaumaha iho la ko Mose mau lima; a lawe lakou i ka pohaku, a hoonoho iho la malalo iho ona, a noho iho la ia maluna; a o Aarona laua o Hura, paepae ae la laua i kona mau lima, o kekahi ma kekahi aoao, a o kela, ma kela aoao; a paa iho la kona mau lima a napoo ka la. ");
INSERT INTO haw1868_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Hooauhee aku la o Iosua i ka Ameleka, a me kona kanaka, me ka maka o ka pahikaua. ");
INSERT INTO haw1868_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","I mai la o Iehova ia Mose, E palapala oe i keia maloko o ka buke, i mea e hoomanao ai, a e hai ma ka pepeiao o Iosua; no ka mea, e anai loa ana au i ka Ameleka mailalo ae o ka lani. ");
INSERT INTO haw1868_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Hana iho la o Mose i kuahu malaila, a kapa aku la ia i ka inoa o ia mea O IEHOVA-NISI. ");
INSERT INTO haw1868_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Ua olelo no ia, No ka lima ma ka nohoalii o Iehova, e mau loa no ke kaua ana o Iehova i ka Ameleka, mai keia hanauna a ia hanauna aku. ");
INSERT INTO haw1868_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","LOHE ae la o Ietero, ke kahuna o Midiana, ka makuahonowaikane o Mose, i na mea a pau a ke Akua i hana mai ai ia Mose, a me kona poe kanaka o ka Iseraela i ko Iehova lawe ana mai i ka Iseraela mai loko mai o Aigupita; ");
INSERT INTO haw1868_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Alaila kai mai la o Ietero, ka makuahonowaikane o Mose ia Zipora i ka wahine a Mose, mahope o kona hoihoi ana aku ia ia, ");
INSERT INTO haw1868_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","A me na keiki kane ana elua; o Geresona ka inoa o kekahi; no ka mea, ua olelo ia, He malihini au ma ka aina e: ");
INSERT INTO haw1868_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","A o ka inoa o kekahi, o Eliezera; no ka mea, o ke Akua o ko'u makua, i kona kokua ana mai ia'u, hoola mai ia ia'u, mai ka pahikaua mai o Parao; ");
INSERT INTO haw1868_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Hele mai la io Mose la o Ietero, ka makuahonowaikane o Mose, a me kana mau keikikane, a me kana wahine, ma ka waonahele, i kahi ana i hoomoana ai ma ka mauna o ke Akua: ");
INSERT INTO haw1868_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Olelo mai la ia ia Mose, Owau no Ietero, kou makuahonowaikane, ua hele mai au i ou nei a me kau wahine, a me kau mau keikikane elua. ");
INSERT INTO haw1868_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Hele aku la o Mose e halawai me kona makuahonowaikane, a kulou iho la ia, a honi aku la ia ia: a ninau kekahi i kekahi, i ka maikai o ko laua noho ana; a komo ae la laua iloko o ka halelewa. ");
INSERT INTO haw1868_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Hai ae la o Mose i kona makuahonowaikane, i na mea a pau a Iehova i hana mai ai ia Parao, a i ko Aigupita, no ka Iseraela, a me ka pilikia a pau i loaa ia lakou ma ke alanui, a me ka hoopakele ana o Iehova ia lakou. ");
INSERT INTO haw1868_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Olioli iho la o Ietero no na mea raaikai a pau a Iehova i hana mai ai i ka Iseraela, i ka poe ana i hoopakele ai, mai ka lima mai o ko Aigupita. ");
INSERT INTO haw1868_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","I ae la o Ietero, E hoomaikaiia o Iehova, o ka mea i hoopakele ia oukou mai ka lima mai o ko Aigupita, a me ka lima o Parao, o ka mea i hoopakele i kanaka, mailalo mai o ka lima o ko Aigupita. ");
INSERT INTO haw1868_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Ano, ua ike au i ka oi ana o ko Iehova mana mamua o ko na akua a pau: no ka mea, ma kahi a lakou i kookiekie ai, aia no ia maluna o lakou. ");
INSERT INTO haw1868_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Lawe iho la o Ietero, ka makuahonowaikane o Mose, i mohaikuni, a me na alana no ke Akua, a hele mai la o Aarona, a me na lunakahiko a pau o ka Iseraela, e ai pu ai me ka makuahonowaikane o Mose, imua o ke Akua. ");
INSERT INTO haw1868_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","A ia la hope iho, noho iho la o Mose e hooponopono i na kanaka; a ku mai la na kanaka imua o Mose, mai ke kakahiaka a ahiahi. ");
INSERT INTO haw1868_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","A ike ka makuahonowaikane o Mose i na mea a pau ana i hana'i i kanaka; alaila, olelo ae la ia, Heaha keia mea au e hana nei i kanaka? No ke aha la e noho oe, o oe wale no, a ku mai la na kanaka a pau imua ou, mai ke kakahiaka mai a ahiahi? ");
INSERT INTO haw1868_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","I aku la o Mose i kona makuahonowaikane, No ka mea, ua hele mai na kanaka io'u nei e ninau i ke Akua: ");
INSERT INTO haw1868_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Ina loaa ia lakou kekahi mea, hele mai lakou ia'u; a na'u no e hooponopono aku mawaena o ke kanaka, a me. kona hoa; a na'u no e hoike aku ia lakou i ka olelo kupaa a ke Akua, a me kona kanawai. ");
INSERT INTO haw1868_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","I mai la ka makuahonowaikane o Mose ia ia, Aole pono ka mea au e hana nei. ");
INSERT INTO haw1868_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","E oiaio no, e mae wale oe, o oe, a me keia poe kanaka me oe; no ka mea, ua kaumaha keia mea ia oe; aole hiki ia oe ke hana, o oe wale no. ");
INSERT INTO haw1868_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","E hoolohe mai hoi oe i ko'u leo, a e ao aku au ia oe, a o ke Akua pu kekahi me oe; o oe no ko na kanaka mea ma ke Akua, e hai aku i na mea imua o ke Akua: ");
INSERT INTO haw1868_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","A e ao aku oe ia lakou i na oihana a me na kanawai, a e hoike aku oe ia lakou i ke ala e hele ai lakou, a me ka hana e hana'i lakou. ");
INSERT INTO haw1868_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Eia hoi kekahi, e hoomakaukau oe i poe maiau o na kanaka, he poe makau i ke Akua, he poe kanaka oiaio, a huhu i ka waiwai alunu; a e hoonoho ia lakou maluna o kanaka, i luna lakou no na tausani, i luna no hoi no na haneri, a i luna no na kanalima, a i luna no na umi: ");
INSERT INTO haw1868_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Na lakou no e hooponopono i kanaka i na wa a pau; a o na mea nui a pau, na lakou e lawe mai ia oe, a o na mea liilii, na lakou ia e hooponopono: pela oe e mama ai, a na lakou e amo pu me oe. ");
INSERT INTO haw1868_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Ina e hana mai oe i keia mea, a kauoha mai ke Akua ia oe pela, alaila e hiki ia oe ka mau loa ana, a e hele no hoi keia poe kanaka a pau i ko lakou wahi me ka malumaluhia. ");
INSERT INTO haw1868_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Hoolohe ae la o Mose i ka leo o kona makuahonowaikane, a hana iho la ia i na mea a pau ana i olelo ai. ");
INSERT INTO haw1868_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Wae aku la o Mose i kanaka maiau o ka Iseraela a pau, a hoolilo iho la ia lakou i mau poo maluna o kanaka, na luna no na tausani, na luna no na haneri, na luna no na kanalima, a me na luna no na umi. ");
INSERT INTO haw1868_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Na lakou i hooponopono i kanaka i na wa a pau; a o na mea nui ka lakou i lawe mai ai ia Mose, a na lakou no i hooponopono na mea liilii a pau. ");
INSERT INTO haw1868_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Kuu aku la o Mose i kona makuahonowaikane: a hoi aku la i kona aina iho. ");
INSERT INTO haw1868_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","A I ke kolu o ka malama o ka puka ana mai o na mamo a Iseraela mai loko mai o Aigupita, ia la no, hiki mai la lakou i ka waonakele o Sinai. ");
INSERT INTO haw1868_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","A hele mai la lakou, mai Repidima mai, a hiki ma ka waonahele o Sinai, a hoomoana iho la lakou ma ka waonahele; malaila ka Iseraela i hoomoana ai ma kahi e pili ana i ka mauna. ");
INSERT INTO haw1868_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Pii aku la o Mose i ke Akua, a hea mai la o Iehova ia ia mai ka mauna mai, me ka i ana mai, Penei oe e olelo aku ai i na pua a Iakoba, a e hai aku i na mamo a Iseraela; ");
INSERT INTO haw1868_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Ua ike no oukou i na mea a'u i hana'i i ko Aigupita, i ko'u kaikai ana ia oukou ma na eheu o ka aeto, a lawe mai ia oukou io'u nei. ");
INSERT INTO haw1868_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","A ina hoolohe io mai oukou i ko'u leo, a malama hoi i ko'u berita, alaila e lilo auanei oukou i waiwai no'u, mamua o na kanaka a pau; no ka mea, no'u no ka honua nei a pau: ");
INSERT INTO haw1868_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","E lilo no hoi oukou i aupuni kahuna pule no'u, a he lahuikanaka laa. Oia hoi na olelo au e hai aku ai i na mamo a Iseraela. ");
INSERT INTO haw1868_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Hele ae la o Mose, a hea aku la i na lunakahiko o kanaka, a hoonoho iho la imua o lakou i keia mau olelo a pau a Iehova i kauoha mai ai ia ia. ");
INSERT INTO haw1868_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Olelo pu mai la na kanaka a pau, i mai la, O na mea a pau a Iehova i olelo mai ai, e hana makou ia mea. Hai aku la o Mose i na olelo a kanaka ia Iehova. ");
INSERT INTO haw1868_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Olelo mai la o Iehova ia Mose, Aia hoi, e hele mai ana au i ou nei maloko o ke ao panopano, i lohe na kanaka i ka'u kamailio ana me oe, a e manaoio mau loa mai ia oe. A hai aku la o Mose i na olelo a kanaka ia Iehova. ");
INSERT INTO haw1868_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Olelo mai la o Iehova ia Mose, E hele oe i kanaka, e hoolaa ia lakou i keia la, a apopo; e holoi hoi lakou i ko lakou kapa. ");
INSERT INTO haw1868_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","E hoomakaukau, no ke kolu o ka la, no ka mea, i ke kolu o ka la, e iho mai ai o Iehova, imua o na maka o kanaka a pau, ma ka mauna o Sinai. ");
INSERT INTO haw1868_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","A e kau iho oe i pale, no na kanaka a puni, a e i aku hoi, E malama oukou ia oukou iho, i ko oukou pii ana i ka mauna, a me ka pa ana i kona kihi: o ka mea e pa i ka mauna, he oiaio no e make ia. ");
INSERT INTO haw1868_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Mai hoopa aku kekahi lima ia mea, no ka mea, he oiaio no, e hailukuia oia, a houia; ina he holoholona, a he kanaka, aole ia e ola: a i kani loihi ka pu, alaila e hele mai lakou i ka mauna. ");
INSERT INTO haw1868_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Iho iho la o Mose ilalo, mai ka mauna iho i kanaka; hoolaa iho la i kanaka; a holoi iho la lakou i ko lakou kapa. ");
INSERT INTO haw1868_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","I aku la ia i kanaka, E hoomakaukau oukou, no ke kolu o ka la; mai komo ae i na wahine. ");
INSERT INTO haw1868_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","A i ke kakahiaka o ke kolu o ka la, he hekili. a he uila, a he ao polohiwa ma ka mauna, a he leo no ka pu e kani ikaika loa ana; haalulu iho la na kanaka a pau ma. ko lakou wihi i hoomoana ai. ");
INSERT INTO haw1868_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Kai mai la o Mose i kanaka mawaho o kahi a lakou e hoomoana ai, e halawai me ke Akua; a ku iho la lakou ma kahi malalo iho o ka mauna. ");
INSERT INTO haw1868_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Ma ka mauna a pau i Sinai, he uwahi, no ka mea, ua iho mai o Iehova maluna ona maloko o ke ahi: a punohu aku la kona uwahi, me he uwahi umu hao la, haalulu nui iho la ka mauna a pau. ");
INSERT INTO haw1868_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","A i ke kani loihi loa ana o ka pu, a ikaika nui ae la, olelo aku la o Mose, a pane mai la ka leo o ke Akua ia ia. ");
INSERT INTO haw1868_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Iho mai la o Iehova maluna o ka mauna o Sinai, ma ke poo o ka mauna, a hea mai la o Iehova ia Mose e pii aku i ke poo o ka mauna; a pii aku la o Mose. ");
INSERT INTO haw1868_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","I mai la o Iehova ia Mose, E iho oe ilalo, e kauoha aku i kanaka, o hemo mai lakou io Iehova nei, e nana, a haule lakou he nui loa. ");
INSERT INTO haw1868_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","A e huikala hoi na kahuna ia lakou iho, o ka poe e hookokoke ana ia Iehova, o poha aku o Iehova io lakou la. ");
INSERT INTO haw1868_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","I aku la o Mose ia Iehova, Aole e hiki na kanaka ke pii mai i ka mauna nei i Sinai: no ka mea, ua kauoha mai oe ia makou, ua i mai, E kau iho i pale a puni ka mauna, a e hookapu ia mea. ");
INSERT INTO haw1868_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","I mai la o Iehova ia ia, O hele, e iho oe ilalo, a e pii hou mai oe, o oe, a me Aarona pu; aka, o na kahuna a me kanaka, mai hemo mai lakou, e pii mai io Iehova nei, o poha aku ia maluna o lakou. ");
INSERT INTO haw1868_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Iho mai la o Mose ilalo i kanaka, a olelo aku la ia lakou. ");
INSERT INTO haw1868_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","OLELO mai la ke Akua i keia mau olelo a pau, i mai la. ");
INSERT INTO haw1868_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","Owau no Iehova o kou Akua, ka mea nana oe i lawe mai nei, mai ka aina o Aigupita mai, mailoko mai hoi o ka hale hooluhi. ");
INSERT INTO haw1868_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Aole ou akua e ae imua o ko'u alo. ");
INSERT INTO haw1868_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Mai hana oe i ke kii i kalaiia nou, aole ma ka like ana o kekahi mea i ka lani iluna, a me ko ka honua ilalo, a maloko hoi o ka wai malalo o ka honua: ");
INSERT INTO haw1868_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Mai kulou oe ilalo ia lakou, aole hoi e hoomana ia lakou; no ka mea, owau no Iehova o kou Akua, he Akua lili; e hoopai ana i ka na makua hala i na keiki, a hiki aku i ke kuakahi a me ke kualua o ka poe e inaina mai ia'u: ");
INSERT INTO haw1868_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","A e aloha ana hoi i na tausani o ka, poe e aloha mai ia'u, a e malama hoi i ko'u mau kanawai. ");
INSERT INTO haw1868_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Mai hoohiki wahahee oe i ka inoa o Iehova o kou Akua; no ka mea, aole loa e hoapono o Iehova i ka mea hoohiki wahahee i kona inoa. ");
INSERT INTO haw1868_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","E hoomanao i ka la sabati, a e hoano ia. ");
INSERT INTO haw1868_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","I na la eono e hana'i oe i kau haua a pau; ");
INSERT INTO haw1868_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Aka, o ka hiku o ka la, he sabati ia no Iehova no kou Akua, aole loa oe e hana ia la, aole oe, aole hoi kou keikikane, aole hoi kou kaikamahine, aole hoi kau kauwakane, aole hoi kau kauwawahine, aole hoi kou holoholona, aole hoi kou kanaka e ma kou mau ipuka: ");
INSERT INTO haw1868_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","No ka mea, i na la eono i hana'i o Iehova i na lani, a me ka honua, a me ke kai, a me na mea a pau maloko o ia mau mea, a i ka iku o ka la i hoomaha'i; nolaila hoi i hoomaikai ai o Iehova i ka la sabati, a hoano ai hoi oia ia la. ");
INSERT INTO haw1868_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","E hoomaikai oe i kou makuakane, a me kou makuwahine; i loihi ai kou mau la maluna o ka aina a Iehova a kou Akua i haawi mai ai ia oe. ");
INSERT INTO haw1868_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Mai pepehi kanaka oe. ");
INSERT INTO haw1868_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Mai moe kolohe oe. ");
INSERT INTO haw1868_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Mai aihue oe. ");
INSERT INTO haw1868_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Mai hoike hoopunipuni oe e hewa ai kou hoalauna. ");
INSERT INTO haw1868_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Mai kuko oe i ka hale o kou hoalauna, mai kuko i ka wahine a kou hoalauna, aole hoi i kana kauwakane, aole hoi i kana kauwawahine, aole hoi i kona bipi, aole hoi i kona hold, aole hoi i kekahi mea a kou hoalauna. ");
INSERT INTO haw1868_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Ike aku la na kanaka a pau i ke hekili, a me ka uila, a me ke kani ana o ka pu, a me ka mauna e uwahi ana: a ike aku la na kanaka, weliweli iho la; neenee aku la, a ku ma kahi mamao aku. ");
INSERT INTO haw1868_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","I aku la lakou ia Mose, Nau no makou e olelo mai, a e hoolohe aku no makou: aka, mai olelo mai ke Akua ia makou, o make auanei makou. ");
INSERT INTO haw1868_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","I aku la o Mose i kanaka, Mai weliweli oukou; no ka mea, ua hele mai ke Akua e hoao ia oukou, i mau kona makauia maluna o oukou, i lawehala ole oukou. ");
INSERT INTO haw1868_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Ku mai la na kanaka ma kahi loihi e aku, a hookokoke aku la o Mose, i ke ao panopano a ke Akua i uoho ai. ");
INSERT INTO haw1868_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","I mai la o Iehova ia Mose, E olelo aku oe i na mamo a Iseraela penei, Ua ike oukou i ka'u olelo ana ia oukou, mai ka lani mai. ");
INSERT INTO haw1868_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Mai hana oe i na akua e me a'u nei i na akua kala, a mai hana i na akua gula no oukou. ");
INSERT INTO haw1868_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","E hana oe i kuahu lepo no'u a e mohai mai maluna iho i kou mohaikuni, a me kou mohai hoomalu, i kou mau hipa, a me kou mau bipi; i na wahi a pau a'u e hoopaa ai i ko'u inoa, mataila au e hele aku ai i ou la, a e hoomaikai ai ia oe. ");
INSERT INTO haw1868_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","A i hana oe i kuahu pohaku, ea, mai hana oe i pohaku i kalaiia; no ka mea, ina e kau oe i kou koilipi maluna iho, ua haumia ia ia oe. ");
INSERT INTO haw1868_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Mai pii oe maluna o ko'u kuahu ma ke ala hanuu, o ikea aku kou wahi huna malaila. ");
INSERT INTO haw1868_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","EIA na olelo kupaa au e kau ai imua o lakou. ");
INSERT INTO haw1868_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Ina kuai oe nau i kauwa Hebera, e hookauwa mai no oia i eono makahiki; a i ka hiku hoi, o kuu wale ia'ku no oia. ");
INSERT INTO haw1868_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Ina i komo mai oia iloko, o kona kino wale no, alaila, e hele aku no oia iwaho, o kona kino wale no: aka, ina i mareia oia, alaila e hele pu aku no kana wahine me ia. ");
INSERT INTO haw1868_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Ina ua haawi mai kona haku i wahine nana, a ua hanau mai oia i mau keikikane nana, a i mau kaikamahine paha, alaila no ka haku ka wahine a me kana mau keiki. a e hele aku no ke kane, oia wale no. ");
INSERT INTO haw1868_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Aka, ina olelo ikaika mai ke kauwa, Ua aloha au i kuu haku, a me kuu wahine, a me ka'u mau ken ki, aole au e hele kuu wale ia; ");
INSERT INTO haw1868_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","Alaila, e lawe mai kona haku ia ia i na lunakanawai; a lawe mai no hoi ia ia i ka puka, a i ka lapauwila o ka puka paha; a e hou iho koua haku i kona pepeiao i ke kui, a e hookauwa mau loa mai oia nana. ");
INSERT INTO haw1868_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Ina e kuai lilo aku ke kanaka i kana kaikamahine i kauwawahine, aole ia e hookuuia aku e like me ke kuuia'na o na kauwakane. ");
INSERT INTO haw1868_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Ina i hewa oia i na maka o kona haku, ka mea i hoopalau mai ia ia nana, alaila, o hoolapanai oia ia ia. Aole ia e hiki ke kuai aku ia ia i ko ka aina e, no kana hana ino ana ia ia. ");
INSERT INTO haw1868_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","A ina ua hoopalau oia ia ia na kana keikikane, e hana aku no oia ia ia e like me ka hana ana i na kaikamahine. ");
INSERT INTO haw1868_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","A ina i lawe oia i wahine hou nana, mai hoemi ia i ka ai a me ka aahu, a me ka launa mare o kela wahine. ");
INSERT INTO haw1868_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","A i ole ia e hana aku i keia mau mea ekolu ia ia, alaila, e hookuu wale ia aku oia, me ka uku ole ia mai i ke kala. ");
INSERT INTO haw1868_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","O ka mea pepehi i kanaka, a make ia, e oiaio no e pepehiia oia. ");
INSERT INTO haw1868_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Ina hoohalua ole ke kanaka, a na ke Akua i haawi mai ia ia iloko o kona lima, alaila, na'u no e kuhikuhi aku ia oe i kahi nona e pee aku ai. ");
INSERT INTO haw1868_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Aka, ina i hana hookiekie ke kanaka i kona hoalauna, e pepehi maalea ia ia, e lawe no oe ia ia mai ko'u kuahu aku, i make ia. ");
INSERT INTO haw1868_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","O ka mea hahau i kona makuakane, a i kona makuwahine, e oiaio no, e make ia. ");
INSERT INTO haw1868_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","O ka mea aihne i ke kanaka, a kuai lilo aku ia ia, a ina i loaa oia ma kona lima, e oiaio no, e make ia. ");
INSERT INTO haw1868_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","A o ka mea hailiili i kona makuakane, a me kona makuwahine, he oiaio no, e make ia. ");
INSERT INTO haw1868_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","A ina hakaka na kanaka, a pehi aku kekahi i kona hoa i ka pohaku, a kui aku i ka lima, aole hoi ia i make, na moe nae ma kahi moe; ");
INSERT INTO haw1868_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","Ina ala hou oia a hele iwaho ma kona kookoo, alaila, e pakele no ka mea nana ia i pepehi; aka, e uku no oia, no kona booki ana i kana hana, a nana no hoi e hoola loa aku ia ia. ");
INSERT INTO haw1868_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","A ina e hahau ke kanaka i kana kauwakane, a i kana kauwawahine, i ka laau, a make ia malalo iho o kona lima, e oiaio no, e hoopaiia oia. ");
INSERT INTO haw1868_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Aka, ina e ola oia i hookahi la paha, a i elua paha, alaila, aole ia e hooukuia: no ka mea, oia kana kala. ");
INSERT INTO haw1868_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Ina hakaka na kanaka, a hooeha i ka wahine hapai keiki, a hemo aku la kana keiki, aole hoi he hewa mahope; e oiaio no e hooukuia oia e like me ka mea e kauia maluna ona e ke kane a ka wahine; a e haawi no oia imua o na lunakanawai. ");
INSERT INTO haw1868_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Aka, ina he hewa mahope, alaila, e haawi no oe i ke ola no ke ola, ");
INSERT INTO haw1868_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","I ka maka no ka maka, i ka lima no ka lima, i ka wawae no ka wawae. ");
INSERT INTO haw1868_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","I ke kuni ana no ke kuni ana, i ka palapu no ka palapu, i ka paopao ana no ka paopao ana. ");
INSERT INTO haw1868_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","A ina e hahau ke kanaka i ka maka o kana kauwakane, a i ka maka o kana kauwawahine, a oki loa ia, alaila, e hookuu wale iho oia ia ia, no kona maka. ");
INSERT INTO haw1868_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","A ina kui oia i ka niho o kana kauwakane, a i ka niho o kana kauwawahine, alaila, e hookuu wale iho oia ia ia, no kona niho. ");
INSERT INTO haw1868_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Ina e o iho ka bipi i ke kanaka, a i ka wahine, a make laua; alaila, e oiaio no e hailukuia ua bipi la, aole hoi e aiia kona io, a e hala ole ke kahu o ka bipi. ");
INSERT INTO haw1868_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Aka, ina i o oia mamua, a na haiia i kona kahu, aole nae ia i hoopaa ia ia, a ua pepehi oia i ke kanaka, a i ka wahine paha, alaila, e hailukuia ua bipi la, a e make no hoi kona kahu. ");
INSERT INTO haw1868_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Aka, ina o hooukuia oia i ke kala, alaila, e haawi no oia i ka uku no kona ola, e like me ka mea i kauia maluna ona. ");
INSERT INTO haw1868_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Ina i o oia i ke keikikane, a ina i o oia i ke kaikamahine paha, e hanaia aku no oia e like me keia kanawai. ");
INSERT INTO haw1868_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Ina e o iho ka bipi i ke kauwakane, a i ke kauwawahine paha, alaila, e uku aku oia i kanakolu sekela kala na ko laua haku, a e hailukuia ua bipi la. ");
INSERT INTO haw1868_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","A ina wehe ke kanaka i lua, a ina eli ke kanaka i lua, aole hoi e uhi, a i haule ka bipi maloko, a he hoki paha; ");
INSERT INTO haw1868_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","Alaila, e uku ka mea nana ka lua, a e haawi hoi i kala na ke kahu o laua; a e lilo ka mea make nana. ");
INSERT INTO haw1868_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","A ina hooeha ka bipi a ke kahi kanaka i ka kekahi, a make ia, alaila, e kuai lilo aku laua i ka bipi ola, a e puunaue i ke kala, a e puunaue no hoi laua i ka bipi i make. ");
INSERT INTO haw1868_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Aka, ina i ikeia ua o no ia bipi mamua, aole nae i hoopaa kona kahu ia ia, alaila, e oiaio no e uku aku no ia i bipi no ka bipi, a e lilo no ka bipi make nana. ");
INSERT INTO haw1868_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","I NA e aihue ke kanaka i ka bipi a i hi pa paha, a kalua, a kuai lilo aku paha, alaila, e haawi aku oia i elima bipi no ka bipi, a i eha hipa no ka hipa. ");
INSERT INTO haw1868_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Ina e loaa ka aihue e wawahi ana, a ina i pepehiia oia a make, aole e pili kona koko. ");
INSERT INTO haw1868_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Aka, ina i puka mai ka la maluna ona, alaila, ua pili no kona koko. Ua pono no ia ia ke uku pau loa mai, a ina i nele oia, alaila, ua pono ke kuaiia oia no kona aihue ana. ");
INSERT INTO haw1868_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Ina i loaa maopopo ma kona lima ka mea i aihueia e ola ana, ina he bipi, a ina he hoki a ina he hipa paha, e haawi aku no oia i papalua. ");
INSERT INTO haw1868_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Ina e hoopau ke kanaka i ko ka mala, a i ko ka pawaina, a hookomo i kona holoholona iloko: a ai oia maloko o ka mala a hai, alaila e uku aku oia i kahi maikai o kana mala iho, a me kahi maikai o kaua pawaina. ");
INSERT INTO haw1868_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","A ina holo aku ke ahi, a loaa na kakalaioa, a aiia na puu huapalaoa, a o ka hua palaoa e ku ana paha, a o ko ka mala paha, alaila, e oiaio no e uku aku ka mea nana i kuni i ke ahi. ");
INSERT INTO haw1868_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Ina haawi ke kanaka i wahi kala na kona hoalauna e malama, a i waiwai e paha, a ua aihueia mai kona hale aku, ina e loaa ka mea nana i aihue, e uku papalua aku oia. ");
INSERT INTO haw1868_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Ina aole i loaa ka mea nana i aihue, alaila, e laweia mai ka hakuhale i na lunakanawai, ina paha ua kau aku oia i kona lima maluna o ka waiwai o kona hoalauna. ");
INSERT INTO haw1868_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","O na hewa no kela mea keia mea, no ka bipi, no ka hoki, no ka hipa, no ka aahu, no na mea nalowale a pau a kekahi e olelo ai, nana ia, e laweia ko laua pono imua o na lunakanawai, a o ka mea a na lunakanawai e hoohewa ai, e uku papalua aku oia i kona hoalauna. ");
INSERT INTO haw1868_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Ina haawi ke kanaka i hoki na kona hoalauna e malama, a i bipi paha, a i hipa, a i kekahi holoholona e ae nana, a i make ia, a eha, a hooholoia ma kahi e paha, aole mea i ike aku; ");
INSERT INTO haw1868_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","Alaila, mawaena o laua ka hoohiki ana ia Iehova, aole oia i kau i kona lima maluna o ka waiwai o kona hoalauna; a e ae aka no ka mea nana ka waiwai, aole kela e uku. ");
INSERT INTO haw1868_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Aka, ina i aihueia'ku ia mea, mai ona aka, e uka aku no oia i ka mea nana ka waiwai. ");
INSERT INTO haw1868_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Ina e haehaeia oia, alaila, e lawe mai kela i ke kino, i mea koike, aole hoi oia e uku no ka mea i haehaeia. ");
INSERT INTO haw1868_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","A ina nonoi ke kanaka i kekahi mea a kona hoalauna, a eha ia mea, a make paha, aole e noho pu ana ka mea nana ia, alaila, e oiaio no e uku oia. ");
INSERT INTO haw1868_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Aka ina e noho pu ana ka mea nana ka waiwai, alaila, aole oia e uku mai. Ina he mea hoolimalima, ua loaa ia no ka uku. ");
INSERT INTO haw1868_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Ina e pue ke kanaka i ke kaikamahine i noopalau ole ia, a moe pu me ia, e oiaio no e kuai no oia ia ia i wahine nana. ");
INSERT INTO haw1868_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Ina hoole loa kona makuakane aole e haawi ia ia nana, e kaupauna aku oia i kala e like me ke kuai ana i na wahinepuupaa. ");
INSERT INTO haw1868_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Mai hoola i ke kupua. ");
INSERT INTO haw1868_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","O ka mea moe pu me ka holoholona, e oiaio no e make ia. ");
INSERT INTO haw1868_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","O ka mea mohai aku na kekahi akua e, aole na Iehova, e luku loa ia'ku la ia. ");
INSERT INTO haw1868_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Mai hookaumaha oe i ka malihini, aole hoi e hooluhi ia ia, no ka mea, he poe malihini oukou ma ka aina o Aignpita. ");
INSERT INTO haw1868_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Mai hookaumaha oe i ka wahinekanemake, a me ke keiki makun ole. ");
INSERT INTO haw1868_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Ina hookaumaha iki oe in lakou, a uwe uuku mai lakou ia'u, e oiaio no e hoolohe au i ko lakou uwe ana: ");
INSERT INTO haw1868_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","A e wela auanei ko'u huhu, a e pepehi aku au ia oukou i ka pahikaua, a e lilo no ka oukou wahine i wahinekanemake a me ka oukou kamalii i kamalii makua ole. ");
INSERT INTO haw1868_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Ina haawi aie aku oe i ke kala no ko'u poe kanaka i hune e noho pu ana me oe, mai lilo oe ia ia i mea hoouku kuala, mai kau hoi oe i ka uku hoopanee maluna ona. ");
INSERT INTO haw1868_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Ina lawe iki oe i ka aahu o kou hoalauna i ukupanai, e haawi hou aku no oe ia ia ia i ka wa e napoo ai ka la ilalo: ");
INSERT INTO haw1868_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","No ka mea, oia kona mea e uhi ai, o kona aahu no kona ili. Maloko o ke aba oia e moe ai? A hiki i ka manawa e uwe mai ai oia ia'u e hoolohe no wau, no ka mea, ua lokomaikai no au. ");
INSERT INTO haw1868_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Mai olelo hoino oe i na lunakanawai, aole hoi e olelo hoino i ka mea e noho alii ana maluna o ko'u poe kanaka. ");
INSERT INTO haw1868_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Mai aua oe i kau ai i oo mua, a me kou waina mua, E haawi mai no oe i kau hiapo, o kau mau keikikane na'u. ");
INSERT INTO haw1868_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Pela no oe e hana'i me kau mau bipi a me kau poe hipa; ehiku la e noho ai me kona makuwahine, a i ka walu o ka la, e haawi mai oe ia mea ia'u. ");
INSERT INTO haw1868_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","A e lilo auanei oukou i poe kanaka hoano no'u, aole hoi oukou e ai i ka io i haehaeia e na holoholona ma ke kula, e kiola aku oukou ia na na ilio. ");
INSERT INTO haw1868_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","MAI hoala oe i ka olelo wahahee. Mai kau pu i kou lima me ka poe hewa e lilo i mea hoike hookaumaha. ");
INSERT INTO haw1868_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Mai hahai mamuli o ka lehulehu e hana hewa, mai paue aku hoi ma ke ku e mamuli o ka lehulehu, e hoohewa wale. ");
INSERT INTO haw1868_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Mai kokua oe mamuli o ka ilihune i kona hewa ana. ");
INSERT INTO haw1868_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Ina halawai oe me ka bipi a kou hoalauna e hele hewa ana, me kona hoki paha, e oiaio no e hoihoi mai oe ia mea io na la. ");
INSERT INTO haw1868_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Ina ike oe i ka hoki a ka mea i huhu mai ia oe, o moe ana malalo iho o kona kaumaha, a manao oe aole kokua ia ia, alaila, e kokua aku no oe ia ia. ");
INSERT INTO haw1868_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Mai hookahuli oe i ka pono o ke kanaka hune i kona hookolokolo ana. ");
INSERT INTO haw1868_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","E mamao aku oe i ka mea wahahee; a mai pepehi oe i ka mea i hewa ole, a me ka mea i pono: no ka mea, aole au e hoapono aku i ka mea i hewa. ");
INSERT INTO haw1868_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Mai lawe oe i ka waiwai kipe: no ka mea, o ka waiwai kipe ka mea e makapo ai ka poe ike, a e kekee ai na olelo a ka poe pono. ");
INSERT INTO haw1868_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Mai hookaumaha oe i ka malihini, no ka mea, ua ike no oukou i ka manao o ka malihini, no ko oukou noho malihini ana ma ka aina o Aigupita. ");
INSERT INTO haw1868_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","E lulu oe i kou aina i eono mau makahiki, a e hoiliili hoi i kona hua. ");
INSERT INTO haw1868_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Aka i ka hiku o ka makahiki e hoomaha oe i ka aina, e waiho wale hoi; i ai iho ka poe hune o kou poe kanaka; a o ka mea a lakou e hookoe ai, na na holoholona o ke kula ia e ai. Pela no oe e hana'i i kon pawaina, a me kon laau oliva. ");
INSERT INTO haw1868_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","I na la eono e hana'i oe i kau hana, a e hoomaha hoi i ka la hiku; i hoomaha ai kau bipi a me kou hoki, i hoohoihoiia hoi ke koikikane a kau kauwa wahine, a me ka malihini. ");
INSERT INTO haw1868_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Ma na mea a pau au i olelo ai ia oukou e malama ia oukou iho; mai hai iki i ka inoa o na'kna e, aole hoi e loheia ia ma kon waha. ");
INSERT INTO haw1868_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","E malama oe i ekolu ahaaina no u i ka makahiki. ");
INSERT INTO haw1868_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","E malama oe i ka ahaaina o ka berena huole: Ehikn la oe e ai ai i ka berena huole, me a'u i kanoha aka ai ia oe, i ka manawa i haawiia, ma ka malama o Abiba; no ka mea, ia wa oe i hele mai ai mailoko mai o Aigupita: Mai ikeia nae kekahi imua o'u me ka waiwai ole: ");
INSERT INTO haw1868_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","A me ka ahaaina o ka ohi mua ana, o na hua mua hoi o kau hooikaika ana, ka mea au i lulu ai ma ke kola, a me ka ahaaina o ka hoiliili ai ana, oia hoi ka hope o ka makahiki, i kou wa e hoiliili ai mailoko mai o ke kula, i kau mea i hooikaika ai. ");
INSERT INTO haw1868_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","E ikeia no ko oukou poe kane a pau imua o Iehova ke Akua, i ekolu no ikea ana i ka makahiki hookahi. ");
INSERT INTO haw1868_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Mai kaumaha aku oe i ke koko o ko'u mohai, me ka berena hu, aole hoi e hookoeia ke kelekele o ka'u ahaaina a kakahiaka. ");
INSERT INTO haw1868_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","E lawe mai no oe iloko o ka hale o Iehova, kou Akua, i ka mua o na hua mua o kou aina. Mai hoolapalapa oe i ke kaokeiki malokool ka waiu o kona makuwahine. ");
INSERT INTO haw1868_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Aia hoi, e hoouna aku ana au i ko'u Anela mamua on, e malama ia oe ma ke ala, a e hookomo ia oe i kahi a'u i hoomakaukau ai. ");
INSERT INTO haw1868_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","E ao ia ia e hoolohe i kona leo, mai hoohuhu aku ia ia; no ka mea, aole ia e kala mai i kon hewa: aia hoi, maloko ona ko'u inoa. ");
INSERT INTO haw1868_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Aka, ina hoolohe io mai oe i kona leo, a e hana hoi i na mea a'u e olelo aku ai: alaila, e lilo wau i enemi no kou poe enemi, a e hana ino aku au i ka mea e hana ino mai ia oe. ");
INSERT INTO haw1868_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","No ka mea, e hele ana ko'u Anela mamua on, a e kai aku ia oe i kahi o ka Amora a me ka Heta a me ka Pereza, a me ko Kanaana, a me ka Heva a me ka Iebusa, a na'u no lakou e anai aku. ");
INSERT INTO haw1868_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Mai kulou oe i ko lakou akua, aole hoi e malama aku ia lakou, aole hoi e hana aku mamuli o ka lakou hana: aka, e hookahuli loa oe ia lakou, a e wawahi loa i ko lakou mau kii. ");
INSERT INTO haw1868_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","E malama hoi oukou ia Iehova i ko oukou Akua; alaila, nana no e hoomaikai i kau ai, a me kon wai; a e lawe aku no hoi i ka mai, mailoko aku ou. ");
INSERT INTO haw1868_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Aole loa e poholo wale ka hanau ana o kekahi mea ma kon aina, aole hoi e pa; e hooko no wau i kou mau la. ");
INSERT INTO haw1868_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Na'u no e haawi i ka makau mamna on, a na'u no e luku aku i na kanaka a pau, ma kahi au e hele aku ai, a na'u no e hana aku i kou poe enemi, i huli ai ko lakou kua ia oe. ");
INSERT INTO haw1868_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","A na'u no e hoouna aku i nalohopeeha mamna ou, na lakou no e kipaku aku i ka Heva, a me ko Kanaana, a me ka Heta, mamua ou, ");
INSERT INTO haw1868_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Aole nae au e kipaku aku ia lakou mamua on i ka makahiki hookahi; o nahelehele ka aina, a nui loa iho na holoholona hihiu e alo mai ia oe. ");
INSERT INTO haw1868_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","E kipaku liill aku au ia lakou mai kou alo aku, a lilo oe i nui, a ill mai ka aina nou. ");
INSERT INTO haw1868_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","A na'u no e kau i kon palena mai ke Kaiula, a hiki i ke kai o Pilisetia, a mai ka waonahele hoi a hiki i ka muliwai; no ka mea, e haawi aku ana au i na kanaka o ia aina i ko oukou lima; a e kipaku aku oe ia lakou mai kou alo aku. ");
INSERT INTO haw1868_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Mai hoopaa berita me lakou, aole hoi me ko lakou mau akua. ");
INSERT INTO haw1868_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Aole lakou e noho i kou aina, o hoolilo lakou ia oe i mea hana hewa mai ia'u; no ka mea, ina e malama oe i ko lakou mau akua, e lilo auanei ia i mea hoowalewale nou. ");
INSERT INTO haw1868_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","I MAI la oia ia Mose, E pii mai oe io Iehova nei, o oe, a me Aarona, a me Nadaba, a me Abihu, a me na lunakahiko o ka Iseraela he kanahiku; a e hoomana oukou ma kahi mamao aku. ");
INSERT INTO haw1868_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","A o Mose wale no ka mea hele mai a kokoke io Iehova nei: aka, o lakou aole hele mai a kokoke; aole hoi e pii pu na kanaka me ia. ");
INSERT INTO haw1868_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Hoi ae la o Mose, a hai aku la i kanaka i na olelo a pau a Iehova, a me na kanawai a pau; hooho mai la na kanaka a pau me ka leo kahi, i mai la, O na olelo a pau a Iehova i olelo mai ai, e hana no makou. ");
INSERT INTO haw1868_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","A kahakaha iho la o Mose i na olelo a pau a Iehova, a ala'e la i kakahiaka nui, a kukulu iho la i kuahu malalo o ka mauna, a me na kia he umikumamalua, e like me na ohana he umikumamalua o ka Iseraela. ");
INSERT INTO haw1868_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","A hoouna ae la ia i mau kanaka ui o na mamo a Iseraela, na lakou i mohai aku i na mahaikuni, no Iehova, a kaumaha aku no hoi lakou i mau bipi kane i mohai hoomalu. ");
INSERT INTO haw1868_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","A lawe iho la o Mose i ka hapalua o ke koko, a waiho aku la maloko o na kiaha, a kapipi iho la ia i kekahi hapalua o ke koko maluna o ke kuahu. ");
INSERT INTO haw1868_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","A lawe iho la ia i ka buke o ka berita, a heluhelu ma na pepeiao o na kanaka. Olelo aku la lakou, E hana no makou i na mea a pau a Iehova i olelo mai ai, a e hoolohe no. ");
INSERT INTO haw1868_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","A lawe ae la o Mose i ke koko, a kapipi iho la maluna o na kanaka, olelo mai la, Aia hoi ke koko o ka berita a Iehova i hana mai ai me oukou no keia mau olelo a pau. ");
INSERT INTO haw1868_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Alaila, pii aku la o Mose, a me Aarona, a me Nadaba, a me Abihu, a me na lunakahiko o ka Iseraela. ");
INSERT INTO haw1868_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","A ike aku la lakou i ke Akua o ka Iseraela, a malalo iho o kona mau wawae he mea me he sapeiro ka aiai, e like hoi me ke kino o na lani ke kalae. ");
INSERT INTO haw1868_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Aole ia i kau mai i kona lima maluna o na luna o na mamo o ka Iseraela. A ike no lakou i ke Akua, a ai no, a inu no hoi. ");
INSERT INTO haw1868_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Olelo mai la o Iehova ia Mose, E hele mai oe io'u nei i ka mauna, a e noho malaila; a e haawi aku au ia oe i pohaku papa, me ke kanawai, a me na kauoha a'u i palapala ai, i ao aku oe ia mea. ");
INSERT INTO haw1868_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Ku ae la o Mose iluna, a me kana kauwa o Iosua: a pii aku la o Mose i ka mauna o ke Akua. ");
INSERT INTO haw1868_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Olelo iho la ia i na lunakahiko, E kakali oukou no maua, a hoi mai maua ia oukou: aia hoi, me oukou o Aarona haua me Hura; a o ka mea loaa kahi pilikia, e hele ae ia io laua la. ");
INSERT INTO haw1868_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Pii aku la o Mose i ka mauna, a uhi mai la ka ohu i ka mauna. ");
INSERT INTO haw1868_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Puwa mai la ka nani a Iehova maluna o ka mauna i Sinai, a uhi mai la ka ohu maluna iho i na la eono; a i ka hiku o ka la hea mai la oia ia Mose, maloko mai o ka ohu. ");
INSERT INTO haw1868_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","I na maka o na mamo a Iseraela, i ka nana ana i ka nani o Iehova, ua like ia me ke ahi e ai ana ma ke poo o ka mauna. ");
INSERT INTO haw1868_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Hele aku la o Mose iloko pono o ka ohu, a pii aku la i ka mauna, a malaila no o Mose ma ka mauna hookahi kanaha ao, hookahi kanaha po. ");
INSERT INTO haw1868_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","OLELO mai o Iehova ia Mose, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","E i aku oe i na mamo a Iseraela, e lawe mai lakou i mohaimakana na'u. E lawe no oukou na'u i ka mohaimakana o kela kanaka keia kanaka i haawi oluolu mai me kona naau. ");
INSERT INTO haw1868_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Eia hoi ka mohaimakana a oukou e lawe ai no lakou mai, he gula, he kala, he keleawe, ");
INSERT INTO haw1868_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","He lole uliuli, a me ka poni, a me ka ulaula, a me ka lole olona keokeo, a me ka hulu kao, ");
INSERT INTO haw1868_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","A me na ili hipakane i hooluu ulaula ia, a me na ili tehasa, a me ka laau sitima, ");
INSERT INTO haw1868_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","I aila hoi i mea malamalama, a me na hua ala, i mea aila poni, a i mea ala maikai, ");
INSERT INTO haw1868_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","A me na pohaku saredonuka, i mea e hoonohonoho ai iloko o ka epoda, a iloko o ka paleumauma. ");
INSERT INTO haw1868_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","A e hana hoi lakou i keenakapu no'u, i noho ai au iwaena o lakou. ");
INSERT INTO haw1868_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","E like me na mea a pau a'u e hoike aku ai ia oe, o ke kumu hoohalike o ke keenakapu, a me ke kumu hoohalike o kona mau mea e pili ana, pela no oe e hana'i. ");
INSERT INTO haw1868_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","A e hana no lakou i pahu laau sitima, i elua kubita a me ka hapalua kona loihi, i hookahi kubita a me ka hapalua kona laula, a hookahi kubita a me ka hapalua kona kiekie. ");
INSERT INTO haw1868_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","A e uhi no hoi oe ia me ke gula maikai, maloko, a mawaho oe e uhi ai ia, a e hana no hoi oe maluna i lei gula a puni ia mea. ");
INSERT INTO haw1868_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","A e hoohehee oe i eha apo gula nona, a e hookomo ma na kihi eha o ka pahu, i elua apo ma kekahi aoao ona, a i elua apo ma kekahi aoao ona. ");
INSERT INTO haw1868_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","A e hana oe i mau auamo laau sitima, a e uhi ia mau mea i ke gula. ");
INSERT INTO haw1868_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","A e hookomo oe i na auamo maloko o na apo ma na aoao o ka pahu, i laweia ka pahu ma ia mau mea. ");
INSERT INTO haw1868_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","E paa no na auamo maloko o na apo o ka pahu, aole laua e laweia mai ka pahu aku. ");
INSERT INTO haw1868_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","A e waiho oe iloko o ka pahu i na papa kanawai a'u e haawi aku ai ia oe. ");
INSERT INTO haw1868_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","A e hana oe i nohoaloha, he gula maikai: i elua kubita a me ka hapalua kona loa, i hookahi kubita a me ka hapalua kona laula. ");
INSERT INTO haw1868_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","E hana no hoi oe i elua kerubima gula, e hana oe ia mau mea i gula paa wale no, ma na welau o ka nohoaloha. ");
INSERT INTO haw1868_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","E hana oe i kekahi kerubima ma kekahi welau, a i kekahi kerubima ma kela welau, ma ka nohoaloha kau e hana'i ia mau kerubima, ma kona mau welau elua. ");
INSERT INTO haw1868_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","A e hohola aku na kerubima i na eheu maluna, e uhi ana i ka nohoaloha i ko lakou mau eheu: a e ku pono no na maka o laua kekahi i kekahi E kau no ko laua mau maka ma ka nohoaloha. ");
INSERT INTO haw1868_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","A e kau no oe i ka nohoaloha maluna ma ka pahu; a maloko o ka pahu oe e waiho ai i na pahu kanawai a'u e haawi aku ai ia oe. ");
INSERT INTO haw1868_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","A malaila wau e halawai ai me oe, a e kamailio pu no hoi au me oe, mailuna iho o ka nohoaloha, a mawaena aku hoi o na kerubima maluna o ka pahu hoike, no na mea a pau a'u e kauoha aku ai i na mamo a Iseraela. ");
INSERT INTO haw1868_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","E hana no hoi oe i papaaina laau sitima: i elua kubita kona loihi, a i hookahi kubita kona laula, a i hookahi kubita a me ka hapalua kona kiekie. ");
INSERT INTO haw1868_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","A e uhi oe ia mea i ke gula maikai, a e hana hoi oe i lei gula a puni ia mea. ");
INSERT INTO haw1868_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","A e hana oe i kae a puni ia mea, i hookahi lima ka laula, a e hana no hoi oe i lei gula ma ua kae la a puni. ");
INSERT INTO haw1868_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","A e hana no hoi oe i eha apo gula no ua papaaina la, a e hookomo i ua mau apo la ma na kiki eha maluna o kona mau wawae. ");
INSERT INTO haw1868_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","E ku pono no na apo i na kae, i wahi e hookomo ai i na auamo e lawe ai i ua papaaina la. ");
INSERT INTO haw1868_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","A e hana oe i ua mau auamo la, he laau sitima, a e uhi ia mea i ke gula, i laweia ka papaaina maluna o laua. ");
INSERT INTO haw1868_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","A e hana oe i kona mau kiaha, a me kona mau puna, a me kona mau poi, a me kona mau ipu i mea ninini mohai E hana oe ia mau mea, he gula maikai. ");
INSERT INTO haw1868_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","E kau no hoi maluna o ka papaaina i berena hoike mau loa imua o'u. ");
INSERT INTO haw1868_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","A e hana no hoi i ipu kukui manamana he gula maikai, e hanaia ua ipukukui la a poepoe. O kona kumu, o kona mau lala, a me kona mau ipu, a me kona mau puupuu, a me kona mau pua, o ia apana hookahi no. ");
INSERT INTO haw1868_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","E puka mai no na lala eono ma na aoao ona; ekolu lala o ka ipukukui mailoko mai o kekahi aoao, a ekolu lala o ka ipukukui, mailoko mai o kekahi aoao. ");
INSERT INTO haw1868_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Ekolu no ipu e like me na alemona, me ka puupuu a me ka pua, ma ka lala hookahi; a ekolu no ipu e like me na alemona, me ka puupuu a me ka pua, a pela ma na lala eono i puka mai, mailoko mai o ka ipukukui. ");
INSERT INTO haw1868_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","A ma ke kumuipukukui, eha no ipu e like me na alemona, me ko lakou mau puu a me ko lakou mau pua. ");
INSERT INTO haw1868_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","He puu malalo iho o kona mau lala elua, a he puu malalo iho o kona mau lala elua, a he puu malalo iho o kona mau lala elua, e like me na lala eono e puka mai ana mailoko mai o ua ipukukui la. ");
INSERT INTO haw1868_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","E hana hookahi ia na puu a me na lala, o kona mau mea a pau, he gula paa wale no. ");
INSERT INTO haw1868_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","A e hana no hoi oe i kona mau ipu aila ehiku, a e kau oia ia mau mea maluna, i hoomalamalama aku ai lakou ma kona alo. ");
INSERT INTO haw1868_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","A o kona upaahi a me kona upakolikukui, he gula maikai. ");
INSERT INTO haw1868_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","E hana no oia ia mea, a me kona mau mea hana, hookahi talena gula maikai. ");
INSERT INTO haw1868_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","E malama hoi oe e hana e like me ke kumu hoohalike i hoikeia ia oe ma ka mauna. ");
INSERT INTO haw1868_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","E HANA no oe i ka halelewa me na pale he umi, he olona i hiloia, he uliuli, he poni a me ka ulaula; he mau kerubima kekahi, o ka hana a ka poe akamai; ");
INSERT INTO haw1868_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","He iwakaluakumamawalu kubita ka loa o kekahi pale, a o ka laula o kekahi pale, eha no kubita. Hookahi no ana o na pale a pau. ");
INSERT INTO haw1868_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","E huiia na pale elima, o kekahi me kekahi, a e huiia na pale elima, o kekahi me kekahi. ");
INSERT INTO haw1868_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","A e hana oe i mau puka lou lole uliuli ma ke kihi o kekahi pale, ma ke kae kahi o ka hui ana, a e hana no hoi oe pela ma ke kihi loa o kekahi pale, ma ke kihi e hui ai me ka lua. ");
INSERT INTO haw1868_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","E hana oe i kanalima puka lou ma ka pale hookahi, a e hana hoi i kanalima puka lou ma ke kihi o ka pale, ma ka hui ana o ka lua, i lou ae kekahi puka lou i kekahi puka lou. ");
INSERT INTO haw1868_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","E hana no hoi oe i kanalima lou gula, a e hui i na pale me ua mau lou la. A e lilo i halelewa hookahi. ");
INSERT INTO haw1868_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","A e hana oe i mau pale hulu kao i mea uhi maluna o ka halelewa. I umikumamakahi pale kau e hana'i. ");
INSERT INTO haw1868_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","He kanakolu kubita ka loihi o kekahi pale, a i eha kubita ka laula o kekahi pale. E like no ke ana o ua mau pale la, he umikumamakahi. ");
INSERT INTO haw1868_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","A e hui oe i elima mau pale, i kaawale lakou, a e hui i eono mau pale, i kaawale lakou, a e pelu ae i ke ono o ka pale ma ke alo o ka halelewa. ");
INSERT INTO haw1868_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","A e hana oe i kanalima puka lou ma ke kihi o kekahi pale mawaho, ma ka hui ana, a i Kanalima puka lou ma ke kihi o ka pale i hui me ka lua. ");
INSERT INTO haw1868_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","A e hana oe i kanalima lou keleawe, a e hookomo i ua mau lou la iloko o na puka lou, a e hui i ua uhi la, i lilo ai i hookahi. ");
INSERT INTO haw1868_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","A o ka puehu ka mea i puehu aku o na pale o ua uhi la, a ka hapalua o ka pale puehu, e kau no ia ma ke kua o ka halelewa. ");
INSERT INTO haw1868_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","A o ke kubita ma kekahi aoao, a o ke kubita ma kela aoao, ka mea i puehu o ka loihi o na pale o ka hale, e kaulai no ia ma na aoao o ka halelewa, ma kela aoao, a ma keia aoao, i mea uhi nona. ");
INSERT INTO haw1868_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","E hana no hoi oe i uhi no ka hale he mau ili hipa kane i hooluu ulaula ia, a maluna aku i uhi hou, he mau ili tehasa. ");
INSERT INTO haw1868_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","A e hana oe i mau papa laau sitima no ka halelewa, i mea ku iluna. ");
INSERT INTO haw1868_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","He umi kubita ka loihi o kekahi papa, a he kubita a me ka hapalua ka laula o kekahi papa. ");
INSERT INTO haw1868_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Elua komo ma ka papa hookahi, e ku pono kekahi i kekahi. Pela no oe e hana'i ma na papa a pau o ka halelewa. ");
INSERT INTO haw1868_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","A e hana no hoi oe i na papa o ka halelewa, i iwakalua papa ma ka aoao hema, ma ke kukulu hema hoi. ");
INSERT INTO haw1868_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","A e hana no hoi oe i hookahi kanaha kumu kala, malalo iho o na papa he iwakalua, i elua kumu maloko iho o ka papa hookahi, no kona mau komo elua, a i elua kumu malalo iho o kekahi papa no kona mau komo elua. ");
INSERT INTO haw1868_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","A no ka lua o ka aoao o ka halelewa ma ke kukulu akau, he iwakalua no papa: ");
INSERT INTO haw1868_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","A me ko lakou mau kumu kala, he kanaha, elua kumu malalo iho o kekahi papa, a elua kumu malalo iho o kekahi papa. ");
INSERT INTO haw1868_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","A no na aoao o ka halelewa ma ke komohana, e hana no oe i eono papa. ");
INSERT INTO haw1868_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","A e hana no hoi oe i elua papa no na kihi o ka halelewa, ma na aoao elua. ");
INSERT INTO haw1868_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","E huiia no ia mau mea malalo, a e huiia no hoi maluna, ma ke poo, a iloko o ke apo hookahi; pela no laua a elua, a no na kihi elua o laua. ");
INSERT INTO haw1868_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Ewalu no ia mau papa, a me ko lakou mau kumu kala, he umikumamaono kumu, elua no kumu malalo o kekahi papa, a elua no kumu malalo o kekahi papa. ");
INSERT INTO haw1868_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","A e hana no hoi oe i mau laau ki, he sitima ka laau, i elima ki no na papa ma kekahi aoao o ka halelewa, ");
INSERT INTO haw1868_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","A i elima ki no na papa ma kekahi aoao o ka halelewa, a i elima ki hoi no na papa o na aoao o ka halelewa, no na aoao elua hoi ma ke komohana. ");
INSERT INTO haw1868_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","A o ke ki waena, mawaena konu o na papa, e holo no ia, mai kekahi kala a i kekahi kala. ");
INSERT INTO haw1868_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","E uhi no hoi oe i na papa i ke gula, a e hana no hoi oe i ko lakou mau apo, he gula, i wahi no na ki, a e uhi no noi oe i na ki i ke gula. ");
INSERT INTO haw1868_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","A e kukulu oe i ka halelewa me ke kumu hoohalike i hoikeia aku ai ia oe ma ka mauna. ");
INSERT INTO haw1868_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","A e hana hoi oe i paku, he uliuli a me ka poni a me ka ulaula, a me ke olona i hiloia, o ka hana a ka poe akamai: e hanaia hoi ia me na kerubima. ");
INSERT INTO haw1868_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","A e kaulai no hoi ia ma na kia laau sitima eha, i uhiia i ke gula; he gula no ko lakou mau lou, maluna o na kumu kala eha. ");
INSERT INTO haw1868_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","A e kaulai oe i ka paku malalo iho o na lou i lawe mai ai oe i ka pahu hoike malalo o ka paku; a na ka paku e hookaawale no oukou mawaena o kahi hoano, a me kahi hoano loa. ");
INSERT INTO haw1868_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","A e kau no oe i ka noho aloha maluna ma ka pahu hoike, maloko o kahi hoano loa. ");
INSERT INTO haw1868_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","E hoonoho oe i ka papaaina mawaho o ka paku, a e kau oe i ka ipukukui manamana ma ke alo o ka papaaina ma ka aoao o ka halelewa ma ke kukulu hema. A e hoonoho oe i ka papaaina ma ka aoao akau. ");
INSERT INTO haw1868_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","A e hana no hoi oe i pale no ka puka komo o ka halelewa, he uliuli, he poni, he ulaula, a me ke olona i hiloia, i hanaia e ka mea humuhumu lopi ano e. ");
INSERT INTO haw1868_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","E hana hoi oe i elima kia laau sitima no na pale, a e uhi ia mau mea i ke gula, a he gula hoi ko lakou mau lou; a e hoohehee i elima kumu keleawe no lakou. ");
INSERT INTO haw1868_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","E HANA oe i kuahu, he laau sitima, elima kubita ka loihi, elima hoi kubita ka lanla: eha no aoao o ke kuahu, a ekolu kubita kona kiekie. ");
INSERT INTO haw1868_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","A e hana oe i mau pepeiao ma kona mau kihi eha, no ia laau hookahi, a e uhi ia mau mea i ke keleawe. ");
INSERT INTO haw1868_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","E hana oe i kona mau ipu, i mea e lawe aku ai i kona lehu, a me kona mau mea hao lanahu, a me kona mau kiaha, a me kona lou io, a me kona mau ipu ahi, o kona mau oihana a pau, he keleawe. ");
INSERT INTO haw1868_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","E hana no hoi oe i papa manamana, pukapuka keleawe, a ma ia mea e hana oe i eha mau apo keleawe ma kona mau kihi eha. ");
INSERT INTO haw1868_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","A e waiho hoi ia mea malalo iho o ke kae o ke kuahu, i mau ai ua mea pukapuka la mawaena konu o ke kuahu. ");
INSERT INTO haw1868_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","E hana no hoi oe i mau auamo no ke kuahu, i mau auamo laau sitima, e uhi ia mau mea i ke keleawe. ");
INSERT INTO haw1868_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","A e hookomoia na auamo maloko o na apo, aia ma na aoao elua o ke kuahu, ua mau auamo la, e amo ai ia mea. ");
INSERT INTO haw1868_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","E hana oe ia mea me na papa, a kawaha mawaena; me ia i hoikeia'ku ai ia oe ma ka mauna, pela lakou e hana'i. ");
INSERT INTO haw1868_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","E hana no hoi oe i kahua no ka halelewa: no ka aoao akau, ma ke kukulu akau, i mau paku no ke kahua, he olona i hiloia, hookahi haneri kubita ka loihi no ka aoao hookahi: ");
INSERT INTO haw1868_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","A o kona mau pou, he iwakalua, me ko lakou mau kumu he iwakalua, o ke keleawe: o na lou o na kia, a me na auka e paa ai, he kala. ");
INSERT INTO haw1868_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","A no ka aoao akau hoi, ma ka loa, he mau paku, hookahi haneri kubita ka loihi, a me kona mau kia he iwakalua, a me ko lakou mau kumu he iwakalua: o na lou o na kia, a me ko lakou mau auka e paa ai, he kala. ");
INSERT INTO haw1868_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","A no ka laula o ke kahua ma ka aoao komohana, he mau paku no, he kanalima kubita ka loihi, he umi ko lakou mau kia, a he umi ko lakou mau kumu. ");
INSERT INTO haw1868_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","A o ka laula o ke kahua ma ka aoao hikina, ma ka hikina hoi, he kanalima ia mau kubita. ");
INSERT INTO haw1868_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","O na paku ma kekahi aoao, he umikumamalima kubita, ekolu o lakou mau kia, a me ko lakou mau kumu, ekolu no. ");
INSERT INTO haw1868_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","A ma kekahi aoao, he mau paku, he umikumamalima kubita, ekolu o lakou mau kia, a me ko lakou mau kumu, ekolu no. ");
INSERT INTO haw1868_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","A no ka puka o ke kahua, he paku, he iwakalua kubita ka loihi, he uliuli, he poni, he ulaula, a me ke olona i hiloia, i hanaia e ka mea humuhumu lopi ano e: eha ko lakou mau kia, a me ko lakou mau kumu eha. ");
INSERT INTO haw1868_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","O na kia a pau, a puni ke kahua, e hoopaaia lakou i na auka kala: a o ko lakou mau kumu he keleawe. ");
INSERT INTO haw1868_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","O ka loihi o ke kahua, hookahi haneri kubita, a o ka laula, he kanalima, mai o a o; a o ke kiekie, elima no kubita, he olona i hiloia, a o ko lakou mau kumu, he keleawe. ");
INSERT INTO haw1868_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","O na oihana a pau o ka halelewa, na mea e lawelawe ai a me kona mau makia a pau, a me na makia a pau o ke kahua, he keleawe. ");
INSERT INTO haw1868_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","E kauoha hoi oe i na mamo a Iseraela, e lawe mai lakou nou, i aila oliva maikai, i kuiia, no ka malamalama, i mea e aa mau ai ka ipukukui. ");
INSERT INTO haw1868_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Ma ka halelewa o ka ahakanaka, mawaho o ka paku, imua o ka pahu kauawai, na Aarona a me kana mau keiki ia e hooponopono, mai ke ahiahi a kakahiaka imua o Iehova. He kanawai mau loa ia no ko lakou hanauna, no na mamo a Iseraela. ");
INSERT INTO haw1868_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","E LAWE oe iou la ia Aarona, i kou kaikuaana, a me kana mau keikikane pu me ia, mai waena mai o na mamo a Iseraela, i lawelawe oia na'u ma ka oihana a ke kahuna, o Aarona, o Nadaba, o Abihu, o Eleazara, a me Itamara, na keikikane a Aarona. ");
INSERT INTO haw1868_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","A e hana hoi oe i aahu laa no Aarona, no kou kaikuaana, i mea nani, a i mea maikai. ");
INSERT INTO haw1868_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","E olelo aku no hoi oe i ka poe a pau i akamai ma ka naau, ka poe a'u i hoopiha ai i ka manao akamai, e hana lakou i ko Aarona mau aahu, e hookapu ia ia, i lawelawe oia na'u, ma ka oihana a ke kahuna. ");
INSERT INTO haw1868_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Eia na aahu a lakou e hana'i: he paleumauma, he epoda, he holoku, he palule onionio, he papale hainika, a me ke kaei. E hana no lakou i aahu kapu no Aarona, kou kaikuaana, a no kana mau keikikane, i lawelawe oia na'u ma ka oihana a ke kahuna. ");
INSERT INTO haw1868_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","A e lawe lakou i gula, a i lole uliuli, a i poni, a i ulaula, a i keokeo. ");
INSERT INTO haw1868_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","E hana lakou i ka epoda, he gula, a he lole uliuli, i poni, a ulaula, a he olona i hiloia, i humuhumuia e ka poe akamai. ");
INSERT INTO haw1868_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","E huiia kona mau apana poohiwi elua, ma kona mau kihi elua, a e pili no ia. ");
INSERT INTO haw1868_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","A o ke kaei o ka epoda maluna iho, hookahi no ano me ia, ma ka hana ana, he gula, he uliuli, he poni, a me ke olona i hiloia. ");
INSERT INTO haw1868_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","A e lawe hoi oe i elua pohaku onika, a e kahakaha maluna o laua i na inoa o na keiki a Iseraela. ");
INSERT INTO haw1868_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Eono o lakou inoa ma kekahi pohaku, a o na inoa eono i koe, ma kekahi pohaku, e like me ko lakou hanau ana. ");
INSERT INTO haw1868_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Me ka hana a ka mea kahakaha pohaku, o ke kahakaha ana o ka hoailona, pela oe e kahakaha ai i na pohaku elua, me na inoa o na keiki a Iseraela; e hana oe ia mau mea e kau maloko o na kawaha gula. ");
INSERT INTO haw1868_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","A e kau oe ia mau pohaku elua maluna o na poohiwi o ka epoda, i mau pohaku e hoomanao ai i na keiki a Iseraela; a e lawe no o Aarona i ko lakou inoa imua o Iehova, maluna o kona mau poohiwi elua, i mea e hoomanao ai. ");
INSERT INTO haw1868_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","E hana oe i mau kawaha gula: ");
INSERT INTO haw1868_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","A i elua kaula gula maikai ma na welau; e hana ia mau mea i mea e hookaawale ai, he kaula hilo, a e hoopaa i ua mau kaula la ma na kawaha. ");
INSERT INTO haw1868_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","A e hana oe i ka paleumauma o ka hooponopono ana; he hana na ka poe akamai, e like me ka hana ana i ka epoda, pela oe e hana'i: he gula, he uliuli, he poni, he ulaula, he olona i hiloia, pela oe e hana'i. ");
INSERT INTO haw1868_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Eha ona mau aoao ahalike, a papalua hoi: hookahi kikoo kona loihi, a hookahi kikoo kona laula. ");
INSERT INTO haw1868_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","A e hoopiha oe ia mea, a piha i na pohaku, eha lalani pohaku: o ka lalani mua, he saredio, he topazo, he bareka, oia ka lalani mua. ");
INSERT INTO haw1868_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","A o ka lalani lua, he omaomao, he sapeiro, he daimana. ");
INSERT INTO haw1868_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","A o ka lalani kolu, he ligura, he agati, a he ametuseto. ");
INSERT INTO haw1868_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","A o ka lalani ha, he berulo, he onika, he iasepi: e hoopaaia ia mau mea iloko o ke gula, oia ko lakou mea e paa ai. ");
INSERT INTO haw1868_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","A ma ia mau pohaku no, na inoa o na keiki a Iseraela, he umikumamalua, e like me ko lakou inoa, me ke kahakaha ana o ka hoailona: o kela mea, keia mea ma kona inoa, e like me na ohana he umikumamalua. ");
INSERT INTO haw1868_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","A e hana oe ma ka paleumauma, i elua kaula ma na welau, he gula maikai i hiloia. ");
INSERT INTO haw1868_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","A e hana no hoi oe ma ka paleumauma, i elua apo gula, a e hookomo i na apo ma na welau elua o ka paleumauma. ");
INSERT INTO haw1868_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","A e hookomo oe i ua mau kaula hilo la elua, na kaula gula, iloko o na apo elua ma na welau o ka paleumauma. ");
INSERT INTO haw1868_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","A o kekahi mau welau elua o na kaula hilo elua, e hoopaa oe ia ma na kawaha, a e kau hoi maluna o na apana poohiwi elua o ka epoda, ma ke alo. ");
INSERT INTO haw1868_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","E hana no hoi oe i elua apo gula, a e hookomo oe ia i na welau elua o ka paleumauma, ma kona kae, ma ka aoao maloko o ka epoda. ");
INSERT INTO haw1868_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","A e hana oe i elua apo gula, a e hookomo ia ma na apana poohiwi elua o ka epoda malalo, ma ke alo hoi e ku pono ana i kona mau huina, maluna o ke kaei o ka epoda. ");
INSERT INTO haw1868_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","A e nakiki lakou i ka paleumauma ma kona mau apo a i na apo o ka epoda me ke kaula uliuli, i kau oia maluna o ke kaei o ka epoda, i hemo ole ai ka paleumauma, mai ka epoda aku. ");
INSERT INTO haw1868_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","A e lawe o Aarona i na inoa o na keiki a Iseraela ma ka paleumauma o ka hooponopono ma kona naau, i ka wa e hele aku ai ia i kahi kapu, i mea e hoomanao mau ai imua o Iehova. ");
INSERT INTO haw1868_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","A e kau oe iloko o ka paleumauma o ka hooponopono i ka Urima, a me ke Tumima, a e mau no laua ma ka naau o Aarona, ia ia e hele aku ai imua o Iehova. A lawe mau no o Aarona i ka hooponopono ana o na mamo a Iseraela, ma kona naau, imua o Iehova. ");
INSERT INTO haw1868_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","E hana oe i ka holoku o ka epoda, he uliuli wale no. ");
INSERT INTO haw1868_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","He puka no mawaenakonu ona maluna, a o ka pelupelu ana ma ke kae o ka puka, he mea i ulanaia, e like me ka puka o ka puliki koa nahae ole. ");
INSERT INTO haw1868_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","A ma kona mau lepa, e hana oe i mau pomeraite, he uliuli, he poni, he ulaula, a puni kona lepa, a he mau bele gula mawaena o lakou a puni: ");
INSERT INTO haw1868_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","He bele gula, a me ka pomeraite, a he bele gula, a me ka pomeraite, ma ka lepa o ka holoku a puni. ");
INSERT INTO haw1868_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","A maluna ia o Aarona e lawelawe ai; a e loheia kona kani ana, i kona wa e hele aku ai i kahi kapu, imua o Iehova, a i kona wa e puka aku ai iwaho, i ole ia e make. ");
INSERT INTO haw1868_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","E hana hoi oe i papa gula maikai, a e kahakaha hoi i ke kahakaha ana o ka hoailona, UA LAA NO IEHOVA. ");
INSERT INTO haw1868_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","A e hoopaa oe ia mea me ke kaula uliuli, i paa ia maluna o ka papale hainika, ma ke alo o ka papale ia e kau ai. ");
INSERT INTO haw1868_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","A e kauia ia mea ma ka lae o Aarona, i lawe o Aarona i ka hewa o na mea laa, na mea a na mamo a Iseraela e hoolaa ai, i ko lakou mau makana laa a pau: a e mau no ia ma kona lae, i aponoia'i lakou imua o Iehova. ");
INSERT INTO haw1868_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","E hoonionio oe i ka palule olona, a e hana oe i ka papale hainika, he olona; a e hana oe i ke kaei, he humuhumu onionio. ");
INSERT INTO haw1868_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","E hana no hoi oe i mau palule no na keikikane a Aarona, a e hana hoi i mau kaei no lakou; e hana no hoi i mau papale no lakou, i mea nani, a i mea maikai. ");
INSERT INTO haw1868_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","A e kau no oe ia mau mea maluna o Aarona o kou kaikuaana, a me kana mau keikikane pu me ia; a e poni oe ia lakou, a e hoolaa ia lakou, a e hookahuna ia lakou, i lawelawe lakou na'u ma ka oihana a ke kahuna. ");
INSERT INTO haw1868_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","E hana oe i wawae olona e uhi ai i ko lakou wahi huna; mai ka puhaka a i ka uha ka loihi: ");
INSERT INTO haw1868_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Maluna o Aarona ia mea, a maluna o kana mau keikikane, ia lakou e hele mai ai iloko o ka halelewa o ka ahakanaka, a ia lakou e hookokoke mai ai i ke kuahu, e lawelawe ma kahi kapu, i kau ole ai ka hewa maluna o lakou a make. He kanawai mau loa ia nona, a no kana poe mama mahope ona. ");
INSERT INTO haw1868_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","EIA ka mea au e hana'i ia lakou, e hoolaa ia lakou, e lawelawe na'u ma ka oihana kahuna. E lawe oe i hookahi bipi opiopio, a i elua hipakane kina ole, ");
INSERT INTO haw1868_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","A i berena hu ole, a i mau popoberena hu ole i miko i ka aila, a me na papa hu ole i hamoia i ka aila: he palaoa o ka huita kau e hana'i ia mau mea. ");
INSERT INTO haw1868_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","A e uhao oe ia mau mea iloko o ka hinai hookahi, a e lawe mai oe ia mau mea ma ka hinai, me ka bipi a me na hipakane elua. ");
INSERT INTO haw1868_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","A e kai mai oe ia Aarona, a me kana mau keikikane, a i ka puka o ka halelewa o ke anaina kanaka, a e holoi ia lakou i ka wai. ");
INSERT INTO haw1868_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","A lawe oe i na aahu, a e hookomo i ka palule maluna o Aarona, a i ka holoku o ka epoda, a me ka epoda, a me ka paleumauma, a e kaei ia ia i ke kaei o ka epoda; ");
INSERT INTO haw1868_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","A e kau oe i ka papale hainaka maluna o kona poo, a e kau hoi i ka lei kapu, maluna o ka papale. ");
INSERT INTO haw1868_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Alaila e lawe oe i ka aila poni, a e ninini iho maluna o kona poo, a e poni hoi ia ia. ");
INSERT INTO haw1868_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","A e kai mai hoi oe i kana mau keikikane, a e hookomo i na palule maluna o lakou. ");
INSERT INTO haw1868_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","A e kaei ia lakou i na kaei, ia Aarona, a me kana mau keikikane pu, a e nakiikii hoi i na papale maluna o lakou; a o ka oihana a ke kahuna, na lakou no, he kanawai mau loa ia: a e hoolaa oe ia Aarona, a me kana mau keikikane. ");
INSERT INTO haw1868_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","E kai mai hoi oe i bipi imua o ka halelewa o ke anaina kanaka; a e kau o Aarona, a me kana mau keikikane i ko lakou mau lima ma ke poo o ka bipi. ");
INSERT INTO haw1868_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","A e pepehi oe i ka bipi imua o Iehova, ma ka puka o ka halelewa o ke anaina kanaka. ");
INSERT INTO haw1868_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","A e lawe oe i kekahi koko o ka bipi, a e kau ma na pepeiao o ke kuahu me kou manamana lima, a e ninini iho i ke koko a pau ma ke kumu o ke kuahu. ");
INSERT INTO haw1868_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","E lawe hoi oe i ke kaikea a pau e wahi ana i na naau, a me ke aa maluna o ke ake, a me na konahua elua, a me ke kaikea e pili ana, a e puhi ia mau mea i ke ahi maluna o ke kuahu. ");
INSERT INTO haw1868_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Aka, o ka io o ka bipi, a me kona ili, a me kona lepo, e puhi oe ia i ke ahi, mawaho o ke kahua hoomoana. He mohai hala ia. ");
INSERT INTO haw1868_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","E lawe hoi oe i hookahi hipakane, a e kau no o Aarona, a me kana mau keikikane i ko lakou mau lima ma ke poo o ka hipa. ");
INSERT INTO haw1868_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","A e pepehi oe i ka hipa, a e lawe i kona koko, a e kapii iho maluna iho o ke kuahu a puni. ");
INSERT INTO haw1868_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","A e oki liilii oe i ka hipa, a e holoi i ko loko ona, a me kona mau wawae, a e hoolilo i kona mau apana, a me kona poo. ");
INSERT INTO haw1868_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","A e puhi oe i ka hipa a pau maluna o ke kuahu; he mohaikuni ia na Iehova, he mea ala, i puhiia na Iehova. ");
INSERT INTO haw1868_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","E lawe no hoi oe i kekahi hipakane, a e kau no o Aarona a me kana mau keikikane i na lima o lakou ma ke poo o ka hipa. ");
INSERT INTO haw1868_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Alaila, e pepehi oe i ka hipa, a e lawe i kekahi o kona koko, a e kau ma ka piko o ka pepeiao akau o Aarona, a ma ka piko o ka pepeiao akau o kana mau keikikane, a ma ka manamana nui o ko lakou lima akau, a ma ka manamana nui o ko lakou wawae akau, a e kapii hoi i ke koko maluna o ke kuahu a puni. ");
INSERT INTO haw1868_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","A e lawe oe i kekahi o ke koko ma ke kuahu, a me kahi o ka aila poni, a e kapii maluna o Aarona, a maluna o kona kahiko, a maluna o kana mau keikikane, a maluna o ke kahiko o kana mau keikikane pu me ia. A e hoolaaia oia, a me kona kahiko, a o kana mau keikikane, a me ke kahiko o kana mau keikikane pu me ia. ");
INSERT INTO haw1868_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","A e lawe hoi oe i ko ka hipa, i ke kelekele, a me ka huelo a me ke kaikea e wahi ana i na naau, a me ke aa maluna o ke ake, a me na konahua elua a me ke kaikea e pili ana, a me ka uha mua akau, no ka mea, he hipa ia e hoolaa ai: ");
INSERT INTO haw1868_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","A i hookahi popo berena, a i hookahi papa berena, he berena me ka aila, a hookahi papa mailoko mai o ka hinai berena hu ole, ka mea imua o Iehova. ");
INSERT INTO haw1868_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","A e haawi oe ia mau mea a pau iloko o na lima o Aarona, a iloko o na lima a kana mau keikikane, a e hoali lakou i mohai hoali imua o Iehova. ");
INSERT INTO haw1868_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","A e lawe oe ia mau mea mai ko lakou lima, a e puhi maluna o ke kuahu, i mohai kuni, i mea ala imua o Iehova; he mohai ahi ia na Iehova. ");
INSERT INTO haw1868_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","E lawe hoi oe i ka umauma o ka hipa o ko Aarona hoolaaia, a e hoali ae, i mohai hoali imua o Iehova, oia hoi kau apana. ");
INSERT INTO haw1868_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","A e hoolaa oe i ka umauma o ka mohai hoali, a me ka uha mua o ka mohai kaikai, ka mea i hoaliia, a kaikaiia hoi, o ka hipakane o ka hoolaa ana, ka mea no Aarona, a no kana mau keikikane; ");
INSERT INTO haw1868_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","A e lilo ia na Aarona, a na kana mau keikikane, mai na mamo a Iseraela ae, he kanawai mau loa ia; no ka mea, he mohai kaikai ia: a e lilo ia i mohai kaikai, mai na mamo a Iseraela ae, i alana hoi no na mohai hoomalu o ko lakou mohai kaikai no Iehova. ");
INSERT INTO haw1868_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","A o na kahiko laa o Aarona, na kana mau keikikane ia mahope ona; i poniia lakou maloko o ia mau mea, a hoolaaia maloko olaila. ");
INSERT INTO haw1868_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","A o ke keiki e lilo ana i kahuna ma kona hakahaka, nana no e hookomo ia mau mea i ehiku la, i kona manawa e hele mai ai iloko o ka helelewa o ke anaina kanaka, e lawelawe ma kahi hoano. ");
INSERT INTO haw1868_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","A e lawe oe i ka hipakane o ka hoolaa ana, a e hoolapalapa i kona io maloko o kahi hoano. ");
INSERT INTO haw1868_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","A e ai no o Aarona, a me kana mau keikikane i ka io o ka hipakane, a me ka berena maloko o ka hinai, ma ka puka o ka halelewa o ke anaina kanaka. ");
INSERT INTO haw1868_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","A e ai no lakou ia mau mea i huikalaia'i, e hookahuna, a e hoolaa ia lakou: aole e ai ka malihini, no ka mea, ua laa ia mau mea. ");
INSERT INTO haw1868_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","A ina e koe iho kekahi io o ka hoolaa ana, a kekahi berena paha, a kakahiaka, alaila e puhi oe i ke koena i ke ahi; aole ia e aiia, no ka mea, ua laa ia. ");
INSERT INTO haw1868_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","A pela oe e hana'i ia Aarona, a i kana mau keikikane, e like me na mea a pau a'u i kauoha aku ai ia oe, i ehiku la e hoolaa ai oe ia lakou. ");
INSERT INTO haw1868_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","A e kaumaha oe i kela la i keia la, i bipi, he mohai hala, i mea e kalahala ai: a e hoomaemae oe i ke kuahu, i ka wa au e hookalahala ai nona, a e poni oe ia mea, a e hoolaa hoi. ");
INSERT INTO haw1868_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Ehiku la e kalahala'i oe no ke kuahu, a e hoolaa ia men; a e lilo ia i kuahu laa loa. E laa no na mea a pau i pa mai i ke kuahu. ");
INSERT INTO haw1868_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Eia hoi ka mea au e kaumaha'i maluna o ke kuahu a mau i kela la i keia la, elua keikihipa o ka makahiki hookahi. ");
INSERT INTO haw1868_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","E kaumaha oe i hookahi keikihipa i ke kakahiaka, a o kekahi keikihipa kau e kaumaha ai i ke ahiahi. ");
INSERT INTO haw1868_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Me ke keikihipa hookahi, he hapaumi o ka epa palaoa, i huiia me ka hapaha o ka hina aila i kuiia; a me ka hapaha o ka hina waina, i mea mohai inu. ");
INSERT INTO haw1868_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","E kaumaha hoi oe i kekahi keikihipa i ke ahiahi, a e hana aku hoi ia mea, e like me ka mohai makana o ke kakahiaka, a e like hoi me kona mohai inu, i mea ala, he mohai ahi hoi ia no Iehova. ");
INSERT INTO haw1868_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","He mohaikuni mau ia no ko oukou hanauna, ma ka puka o ka halelewa o ke anaina, imua o Iehova; kahi a'u e halawai ai me oe, e kamailio pu me oe malaila. ");
INSERT INTO haw1868_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","A malaila wau e halawai ai me na mamo a Iseraela, a e hoolaaia mai ai, e ko'u nani. ");
INSERT INTO haw1868_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","A e hoolaa no wau i ka halelewa o ke anaina kanaka, a me ke kuahu: e hoolaa no hoi au ia Aarona. a me kana mau keikikane, e lawelawe no'u ma ka oihana kahuna. ");
INSERT INTO haw1868_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","A e noho no wau iwaena konu o na mamo a Iseraela, a owau auanei ko lakou Akua. ");
INSERT INTO haw1868_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","A e ike auanei lakou, owau no Iehova, ko lakou Akua, ka mea i lawe mai ia lakou, mai ka aina o Aigupita mai, i noho wau iwaena o lakou. Owau, o Iehova no ko lakou Akua. ");
INSERT INTO haw1868_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","E HANA oe i kuahu, i wahi e puhi ai i ka mea ala. E hana oe ia mea i ka laau sitima. ");
INSERT INTO haw1868_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Hookahi kubita kona loihi, a he kubita hoi kona laula; e hanaia na aoao ahalike, a elua kubita kona kiekie, oia mea hookahi me na pepeiao ona. ");
INSERT INTO haw1868_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","A e uhi oe ia mea i ke gula maikai, o ko luna, a me na aoao ona a puni, a me kona mau pepeiao, a e hana oe i lei gula a puni ia mea. ");
INSERT INTO haw1868_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","A e hana oe i mau apo gula nona elua, malalo iho o kona lei; ma kona mau kihi, ma na aoao elua ona kau e hana'i ia mea; i mau wahi ia no na auamo e lawe ai i ke kuahu. ");
INSERT INTO haw1868_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","A e hana oe i na auamo, he laau sitima, a e wahi ia mau mea i ke gula. ");
INSERT INTO haw1868_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","A e waiho oe ia mea imua o ka paku e kau ana imua o ka pahu hoike, imua hoi o ka noho aloha e kau ana maluna o ka pahu kanawai, kahi a'u e halawai ai me oe. ");
INSERT INTO haw1868_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","A e puhi o Aarona maluna olaila i mea ala maikai, i kela kakahiaka, keia kakahiaka: i kona wa e koli ai i na kukui, e puhi oia i ka mea ala maluna olaila. ");
INSERT INTO haw1868_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","A i ka wa e hoa ai o Aarona i na kukui i ke ahiahi, e puhi no oia i ka mea ala maluna olaila, he mea ala hoomau no ko oukou mau hanauna a pau. ");
INSERT INTO haw1868_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Mai Kaumaha oe i ka mea ala e maluna olaila, aole hoi he mohaikuni, aole hoi he mohai makana, mai ninini hoi i ka mohai inu maluna olaila. ");
INSERT INTO haw1868_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","A maluna o kona mau pepeiao, e kalahala ai o Aarona, i hookahi kalahala ana o ka makahiki, me ke koko o ka mohai hala o ke kalahala ana. E kalahala no oia maluna olaila, i hookahi no hana ana o ka makahiki no ko oukou hanauna; ua laa loa ia no Iehova. ");
INSERT INTO haw1868_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Olelo mai la o Iehova ia Mose, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","I ka wa e helu ai oe i na mamo a Iseraela, i ka poe e heluia'i, alaila, e haawi no kela kanaka, keia kanaka i uku ia Iehova, no kona uhane, i ka wa au e helu ai ia lakou, i ole ai ka mai ahulau iwaena o lakou, i kou wa e helu ai ia lakou. ");
INSERT INTO haw1868_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Eia ka lakou e haawi mai ai, o kela mea keia mea e hele ae ranwaena o ka poe i heluia, he hapalua o ka sekela, ma ka sekela o ke keenakapu, (he iwakalua gera hookahi ia sekela,) a he hapalua o ka sekela, oia ka haawina ia Iehova. ");
INSERT INTO haw1868_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","O kela mea keia mea e hele ae iwaena o ka poe i heluia, mai ka iwakalua o ka makahiki a keu aku, a haawi no oia i haawina ia Iehova. ");
INSERT INTO haw1868_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Aole hookeu aku ka mea waiwai, aole hoi ka mea hune e hoemi iho i ka hapalua o ka sekela i ko lakou haawi ana ia Iehova, e kalahala ai no ko oukou uhane. ");
INSERT INTO haw1868_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","A e lawe oe i ke kala kalahala o na mamo a Iseraela, a e haawi ia mea no ka hana o ka halelewa o ke anaina kanaka, i lilo ia i mea paipai manao no na mamo a Iseraela imua o Iehova, i mea hoi e kalahala'i no ko oukou poe uhane. ");
INSERT INTO haw1868_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Olelo mai la o Iehova ia Mose, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","E hana no oe i ipu auau keleawe, a o kona kumu hoi he keleawe, i wahi e holoi ai. A e waiho oe ia mea mawaena o ka halelewa o ke anaina kanaka, a me ke kuahu, a e ninini oe i ka wai maloko. ");
INSERT INTO haw1868_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","No ka mea, malaila no e holoi ai o Aarona, a me kana mau keiki i ko lakou mau lima, a me ko lakou mau wawae. ");
INSERT INTO haw1868_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","A hele lakou iloko o ka halelewa o ke anaina kanaka, alaila, e holoi lakou me ka wai, i ole ai lakou e make; a i ka manawa hoi e hookokoke mai ai lakou i ke kuahu e lawelawe ai, e puhi i mohai ahi no Iehova: ");
INSERT INTO haw1868_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","I holoi lakou i ko lakou mau lima, a me ko lakou mau wawae, i ole ai lakou e make. He kanawai mau loa ia no lakou; nona, a no kana poe mamo ma ko lakou hanauna. ");
INSERT INTO haw1868_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Olelo mai no hoi o Iehova ia Mose, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","E lawe oe nou i mau hua ala nui, i mura maikai, elima haneri sekela, a i kinemona ikaika, he hapalua, elua hoi haneri sekela, a me ke kanalima, a i oheala, elua haneri a me ke kanalima sekela. ");
INSERT INTO haw1868_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","A i kida, elima haneri sekela, ma ka sekela o ke keenakapu, a i hookahi hina aila oliva: ");
INSERT INTO haw1868_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","A e hana oe ia i aila poni hoano, he mea poni i huiia ma ke ano o ka hana ana i na mea ala. E lilo ia i aila poni hoano. ");
INSERT INTO haw1868_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","A me ia no oe e poni ai i ka halelewa o ke anaina kanaka, a me ka pahu o ke kanawai, ");
INSERT INTO haw1868_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","A me ka papaaina, a me kona mau oihana a pau, a me ka ipukukui, a me kona mau oihana a pau, a me ke kuahu no ka mea ala, ");
INSERT INTO haw1868_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","A me ke kuahu no ka mohaikuni, a me kona mau oihana a pau, a me ka ipu auau, a me kona kumu. ");
INSERT INTO haw1868_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","A e hoolaa oe ia mau mea, i laa loa lakou: o na mea a pau e pili ana me ia mau mea, e laa no lakou. ");
INSERT INTO haw1868_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","A e poni no hoi oe ia Aarona, a me kana mau keikikane, a e hoolaa ia lakou, i lawelawe lakou na'u ma ka oihana kahuna. ");
INSERT INTO haw1868_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","A e olelo aku oe i na mamo a Iseraela, e i aku, He aila poni hoano keia no'u, ma ko oukou mau hanauna. ");
INSERT INTO haw1868_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Aole ia e nininiia maluna o ka io o ke kanaka, mai hana hoi oe i kekahi mea hamo like, ma ke ano hookahi me ia; ua laa ia, a e laa auanei ia no oukou. ");
INSERT INTO haw1868_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","O ka mea hana i mea ala e like me ia, a o ka mea kau ia mea maluna o ka malihini, e okiia oia mai kona poe kanaka aku. ");
INSERT INTO haw1868_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","I mai la o Iehova ia Mose, E lawe oe i mea ala nou, i natapa, i onika, a i metopio, ia mau mea ala, a me ka libano, e like no ke kaumaha o ia mau mea a pau. ");
INSERT INTO haw1868_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","A e hana oe he mea ala, i laau poni hoi, e like me ka hana ana i na mea ala, i hanaia a miko, maikai, a laa hoi. ");
INSERT INTO haw1868_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","A e kui oe i kekahi o ia mea a wali loa, a e kau aku imua o ke kanawai, maloko o ka halelewa o ke anaina kanaka, kahi a'u e halawai ai me oe. E laa loa auanei ia no oukou. ");
INSERT INTO haw1868_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","A o ka mea ala au e hana'i, mai hana oukou i mea e like ai no oukou; e laa no ia ia oe no Iehova. ");
INSERT INTO haw1868_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","O ka mea hana e like me ia, i mea e honi ai, e okiia no ia, mai kona poe kanaka aku. ");
INSERT INTO haw1868_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","OLELO mai o Iehova ia Mose, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","E nana hoi, ua kahea aku au ma ka inoa, ia Bezalela, i ke keiki a Uri, i ka keiki a Hura, no ka ohana a Iuda. ");
INSERT INTO haw1868_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","A ua hoopiha au ia ia i ka uhane o ke Akua, ma ke akamai, ma ka naauao, ma ka ike, a ma ka hana ana i na mea a pau, ");
INSERT INTO haw1868_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","E imi i na mea akamai, e hana hoi ma ke gala, a ma ke kala, a ma ke keleawe, ");
INSERT INTO haw1868_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","A i ke okioki pohaku, i mea kapili: a i ke kalai ana i ka laau e hana hoi i na hana a pau. ");
INSERT INTO haw1868_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","A owau, aia hoi, ua haawi no wau ia Aholiaba nona, i ke keiki a Ahisamaka, no ka ohana a Dana; a ua haawi no wau i ke akamai maloko o ka naau o ka poe a pau i naauao, i hana lakou i na mea a pau a'u i kauoha aku at ia oe: ");
INSERT INTO haw1868_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","I ka halelewa o ke anaina kanaka, a me ka pahu kanawai, a me ka noho aloha maluna iho, a me ka oihana a pau o ka halelewa, ");
INSERT INTO haw1868_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","A me ka papaaina, a me kona oihana, a me ka ipukukui, me kona oihana a pau, a me ke kuahu no ka mea ala, ");
INSERT INTO haw1868_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","A me ke kuahu no ka mohaikuni a me kona oihana a pau, a me ka ipu auau, a me kona kumu, ");
INSERT INTO haw1868_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","A me na lole hana, a me na kahiko laa no Aarona ke kahuna, a me na kahiko no kana mau keikikane e lawelawe ai ma ka oihana kahuna, ");
INSERT INTO haw1868_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","A me ka aila poni, a mo ka mea ala maikai no kahi laa; e like me na mea a pau a'u i kauoha aku ai ia oe, pela laua e hana'i. ");
INSERT INTO haw1868_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Olelo mai la o Iehova ia Mose, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","E olelo aku oe i na mamo a Iseraela, e i aku, E malama io oukou i ko'u mau sabati, no ka mea, he hoailona ia mawaena o'u a me oukou, i ko oukou mau hanauna; i ike hoi oukou, owau no Iehova, ka mea hoolaa ia oukou. ");
INSERT INTO haw1868_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Nolaila oukou e malama'i i ka sabati; no ka mea, ua hoanoia ia no oukou, O kela mea keia mea hoohaumia ia la, e oiaio no e pepehiia oia: no ka mea, o ka mea hana i ka hana ia la, e okiia kela kanaka, mai kona poe kanaka aku. ");
INSERT INTO haw1868_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Eono la e hanain'i ka hana, aka o ka hiku, he sabati ia e hoomaha'i, he mea laa no Iehova, o ka mea hana i kekahi hana i ka sabati, e oiaio no e pepehiia oia. ");
INSERT INTO haw1868_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","A e malama na mamo a Iseraela i ka sabati e hooponopono i ka sabati, i ko lakou hanauna, i berita mau loa. ");
INSERT INTO haw1868_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","He hoailona mau loa ia mawaena o'u a me na mamo a Iseraela; no ka mea, i na la eono i hana'i o Iehova i ka lani, a me ka honua, a i ka hiku o ka la, hoomaha oia, a oluolu iho la, ");
INSERT INTO haw1868_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","A i kona hoopau ana i ke kamailio me Mose, maluna o ka mauna o Sinai, haawi mai la oia ia ia i elua papa kanawai he mau papa pohaku, ua kahakahaia e ka lima o ke Akua. ");
INSERT INTO haw1868_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","A IKE aku la na kanaka i ko Mose hookaulua ana i ka iho mai, mai ka mauna mai, akoakoa iho la na kanaka io Aarona la, olelo ae la ia ia, E ku oe, e hana i akua no kakou, i mea hele mamua o kakou: no ka mea, o ua Mose la, ke kanaka nana kakou i alakai mai nei, mai ka aina o Aigupita mai; aole kakou ike i kona wahi i lilo aku ai. ");
INSERT INTO haw1868_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","I mai la o Aarona ia lakou, E uhai oukou i na apo gula pepeiao, i na mea iloko o na pepeiao o ka oukou wahine, a me ka oukou keikikane, a me ka oukou kaikamahine, a e lawe mai io'u nei. ");
INSERT INTO haw1868_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Uhai iho la na kanaka a pau i na gula pepeiao, i na mea iloko o ko lakou pepeiao, a lawe mai io Aarona la. ");
INSERT INTO haw1868_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Lawe iho la ia, mai ko lakou lima aku, a koli iho la ia mea i ke kila, a hana ae la i bipi keiki i hooheheeia; a olelo iho la lakou, Eia kou akua, e ka Iseraela, nana oe i lawe mai nei, mai ka aina o Aigupita mai. ");
INSERT INTO haw1868_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","A ike aku la o Aarona, hana iho la ia i kuahu imua i ke alo o ia mai; hea aku la o Aarona, i aku la, E, I apopo, he ahaaina na Iehova. ");
INSERT INTO haw1868_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","A ia la iho, ala koke ae la lakou, a mohai aku la i mohaikuni, a lawe mai no hoi i mohaihoomalu; a noho iho la na kanaka e ai, a e inu, a ku ae la iluna e paani. ");
INSERT INTO haw1868_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","I mai la o Iehova ia Mose, O hele oe, e iho ilalo; ua hana hewa kou poe kanaka au i lawe mai ai, mai ka aina o Aigupita mai. ");
INSERT INTO haw1868_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Ua huli koke ae lakou, mai ke ala aku a'u i kauoha aku ai ia lakou; ua hana lakou i bipi keiki i hooheheeia no lakou, ua hoomana lakou ia mea, a ua mohai hoi lakou ia ia, me ka i ana aku, E ka Iseraela e, eia kou akua, nana oe i lawe mai nei, mai ka aina o Aigupita mai. ");
INSERT INTO haw1868_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","I mai la o Iehova ia Mose, Ua ike no au i keia poe kanaka, aia hoi, he poe kanaka a-i oolea: ");
INSERT INTO haw1868_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Ano hoi, e ae mai oe ia'u, i wela loa ko'u huhu ia lakou, i hoopau wau ia lakou; a na'u no e hana aku ia oe i lahuikanaka nui. ");
INSERT INTO haw1868_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Nonoi aku la o Mose ma ke alo o Iehova, o kona Akua, i aku la, E Iehova, no ke aha la i wela ai kou huhu i kou poe kanaka au i lawe mai ai, mai ka aina o Aigupita mai, me ka mana nui, a me ka lima ikaika? ");
INSERT INTO haw1868_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","No ke aha la e olelo mai ai ko Aigupita, me ka i ana mai, No ka hewa i lawe mai ai oia ia lakou, e pepehi ia lakou ma na mauna, a e luku aku ia lakou, mai ka maka aku o ka honua? E maliu mai oe mai ka wela mai o kou huhu, a e aloha mai oe no ka hewa e hiki mai ana i kou poe kanaka. ");
INSERT INTO haw1868_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","E hoomanao oe ia Aberahama, ia Isaaka, ia Iseraela, i kau mau kauwa, i kou hoohiki ana ia lakou ma ou iho; i kau olelo ana mai ia lakou, E hoonui ana au i ka oukou ohana e like me na hoku o ka lani; a o keia aina a pau a'u i olelo ai, na'u no e haawi aku no ka oukou poe mamo, a e noho mau loa lakou ma ia aina. ");
INSERT INTO haw1868_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Maliu mai la no o Iehova mai ka hoino mai ana i manao ai e hana mai i kona poe kanaka. ");
INSERT INTO haw1868_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Huli mai la o Mose, a iho mai la, mai ka mauna mai, aia hoi, maloko o kona lima na pohaku papa kanawai elua: ua palapalaia na papa ma na aoao elua, ua palapalaia no ma kahi aoao, a ma kahi aoao. ");
INSERT INTO haw1868_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","O ia mau papa ka ke Akua i hana'i, a o ka palapala, na ke Akua ka palapala, ua kahakahaia maloko o na papa. ");
INSERT INTO haw1868_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","A lohe o Iosua i ka walaau o kanaka i ko lakou uwauwa ana, i ae la ia ia Mose, He walaau kaua ka ma kahi e hoomoana'i. ");
INSERT INTO haw1868_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","I mai la kela, Aole ia he leo no ka poe uwauwa lanakila, aole hoi ka leo o ka poe uwe i ke pio ana; aka o ka walaau mele ka'u e lohe nei. ");
INSERT INTO haw1868_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","A kokoke ia i hiki i kahi o lakou i hoomoana'i, ike aku la ia i ka bipi keiki, a me ka haa ana: ulu puni iho la ko Mose huhu, kiola aku la ia i na papa, mai kona lima aku, a naha iho la laua malalo iho o ka mauna. ");
INSERT INTO haw1868_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Lawe iho la ia i ka bipi keiki a lakou i hana'i, a puhi aku la i ke ahi, a hoowali iho la a okaoka, a lulu aku la ia maluna o ka wai, a hoohainu aku la i na mamo a Iseraela i ka wai. ");
INSERT INTO haw1868_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","I aku la o Mose ia Aarona, Heaha ka mea a keia poe kanaka i hana'i ia oe, i hooili mai ai oe i keia hewa nui maluna o lakou. ");
INSERT INTO haw1868_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","I mai la o Aarona, Mai ulu puni mai ka huhu o kuu haku, ua ike no oe i ka poe kanaka, na paa lakou ma ke kolohe. ");
INSERT INTO haw1868_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","No ka mea, olelo mai lakou ia'u, E hana oe i na akua no kakou, e hele aku imua o kakou; no ka mea, o ua Mose nei, ke kanaka nana kakou i lawe mai nei, mai ka aina o Aigupita mai, aole kakou i ike i kona wahi i lilo aku ai. ");
INSERT INTO haw1868_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","I aku la au ia lakou, O ka mea ia ia kekahi gula, e uhai oia ia mea. Haawi mai no hoi lakou ia'u: alaila hahao aku la au ia mea iloko o ke ahi, a puka mai la mawaho ua bipi keiki nei. ");
INSERT INTO haw1868_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","A ike mai la o Mose i na kanaka, ua haunaele; (no ka mea, ua hoohaunaele o Aarona ia lakou i ka lukuia imua o ko lakou poe enemi:) ");
INSERT INTO haw1868_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Alaila ku mai la o Mose ma ka puka o kahi a lakou i hoomoana'i, i mai la, Owai ka mea ma ko Iehova aoao? e hele mai ia io'u nei. A akoakoa pu mai la na mamo a pau a Levi io na la. ");
INSERT INTO haw1868_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","I mai la ia ia lakou, Ke i mai nei o Iehova o ke Akua o Iseraela penei, E kau na kanaka a pau i na pahikaua a lakou ma ko lakou aoao, e hele ae lakou a hoi mai, ma kela ipuka a keia ipuka o kahi hoomoana, a e pepehi ke kanaka i kona hoahanau, a o ke kanaka i kona makamaka, a o ke kanaka i kona hoalauna. ");
INSERT INTO haw1868_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Hana iho la na mamo a Levi e like me ka olelo a Mose: a haule iho la ia lakou ia la na kanaka ekolu paha tausani. ");
INSERT INTO haw1868_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","No ka mea, ua olelo mai o Mose, E hoolaa oukou ia oukou iho no Iehova i keia la, o ke kanaka maluna o kana keiki a maluna o kona hoahanau; i hoomaikai mai kela ia oukou i keia la. ");
INSERT INTO haw1868_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","A ia la iho, i mai la o Mose i na kanaka, Ua lawehala loa oukou; ke pii aku nei no hoi au io Iehova la; e hana paha wau i mea e kalaia mai ai ko oukou hewa. ");
INSERT INTO haw1868_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Hoi aku la o Mose io Iehova la, i aku la, Auwe hoi, ua lawehala loa keia poe kanaka, a ua hana i akua gula no lakou. ");
INSERT INTO haw1868_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Ano hoi, ina paha e kala mai oe i ko lakou hewa?; aka, i ole, ke nonoi aku nei au ia oe e holoi mai oe ia'u, mai ka buke au i palapala ai. ");
INSERT INTO haw1868_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","I mai la o Iehova ia Mose, O ka mea i lawehala i ka'u, e holoi aku au ia ia, mai ka'u buke aku. ");
INSERT INTO haw1868_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","No ia mea, o hele oe, e alakai ia poe kanaka i kahi a'u i olelo ai ia oe: aia hoi, e hele no ko'u anela mamua ou, aka hoi, i ko'u la e hoopai ai, e hoopai aku au i ko lakou hewa maluna o lakou. ");
INSERT INTO haw1868_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Hahau mai la Iehova i na kanaka no ka lakou hana ana i ka bipi keiki a Aarona i hana'i. ");
INSERT INTO haw1868_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","OLELO mai la o Iehova ia Mose, o hele, e pii aku, o oe a me na kanaka au i alakai mai nei, mai ka aina o Aigupita mai, a i ka aina a'u i hoohiki ai ia Aberahama, a ia Isaaka, a ia Iakoba, i ka i ana iho, Ke haawi nei au ia na kau poe mamo. ");
INSERT INTO haw1868_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","A e hoouna aku au i ko'u anela imua ou; a na'u no e kipaku aku i ka Kanaana, i ka Amora, i ka Heta, i ka Pereza, i ka Heva, a i ka Iebusa; ");
INSERT INTO haw1868_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","A i ka aina e kahe ana o ka waiu a me ka mele; no ka mea, aole au e pii aku iwaena ou, no ka mea, he poe kanaka a-i oolea oukou; o hoopau auanei au ia oe ma ke ala. ");
INSERT INTO haw1868_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","A lohe na kanaka i keia olelo o ka hewa, uwe iho la lakou, aohe kanaka i hookomo i kona kahiko ana. ");
INSERT INTO haw1868_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","No ka mea, ua olelo mai o Iehova ia Mose, E i aku oe i na mamo a Iseraela, He poe kanaka a-i oolea oukou: i ka minute hookahi, e pii aku no au iwaena konu ou, a e hoopau ia oe, Nolaila, e wehe oe i kou kahiko ana mai ou aku la, i ike au i ka mea e hana aku ai ia oe. ");
INSERT INTO haw1868_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","A wehe na mamo a Iseraela i ko lakou kahiko ana, ma ka mauna o Horeba. ");
INSERT INTO haw1868_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","A lawe ae la o Mose i ka halelewa, a kukulu iho la mawaho o kahi e hoomoana'i, ma kahi mamao aku o ke kahua i hoomoana'i; a kapa ae la oia ia mea, o ka Halelewa o ke anaina kanaka. A o kela mea keia mea i imi ia Iehova, hele aku la ia iwaho i ka halelewa o ke anaina kanaka, ka mea mawaho o kahi i hoomoana'i. ");
INSERT INTO haw1868_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","A i ka hele ana aku o Mose i ka halelewa, ala ae la na kanaka a pau iluna, a ku no kela kanaka keia kanaka ma ka puka o kona halelewa, a nana aku la mahope o Mose, a hala ia iloko o ka halelewa. ");
INSERT INTO haw1868_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","A i ko Mose komo ana iloko o ka halelewa, iho mai la ke kia ao, a ku ma ka puka o ka halelewa, a kamailio mai la o Iehova me Mose. ");
INSERT INTO haw1868_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","A ike ae la na kanaka a pau i ke kia ao e ku ana ma ka puka o ka halelewa, a ku ae la na Kanaka a pau iluna, a hoomana aku la, o kela kanaka keia kanaka ma ka puka o kona halelewa. ");
INSERT INTO haw1868_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","A kamailio mai la o Iehova ia Mose, he maka no he maka, e like me ke kamailio ana o ke kanaka me kona hoa. A hoi aku la ia iloko o kahi e hoomoana'i, a me kana kauwa, o Iosua, ke keiki a Nuna, he kanaka opiopio; aka, aole ia i hele iwaho o ka halelewa. ");
INSERT INTO haw1868_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","I aku la o Mose ia Iehova, E nana hoi, ke olelo mai nei oe ia'u, E kai mai oe i keia poe kanaka; aole nae oe i hoike mai ia'u i ka mea au e hoouna pu ai me au. Aka, na olelo mai no, Ua ike no wau ia oe ma ka inoa, a e loaa ia oe ka lokomaikaiia i ko'u mau maka. ");
INSERT INTO haw1868_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Nolaila, ke nonoi aku nei au ia oe, ina i loaa ia'u ka lokomaikaiia i kou mau maka, e hoike mai oe ia'u i kou aoao, i ike aku au ia oe, i loaa ia'u ka lokomaikaiia i kou mau maka: a e hoomanao hoi, o kou aupuni no keia poe kanaka. ");
INSERT INTO haw1868_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","I mai la keia, E hele pa ne ko'u maka, a na'u no oe e hoomaha aku. ");
INSERT INTO haw1868_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","I aka la keia, I ole e hele pu kou maka, mai lawe aku oe ia makou. ");
INSERT INTO haw1868_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Mahea la e ikeia'i ua loaa ia'u a me kou poe kanaka ka lokomaikaiia i kou maka? Aole anei ma kou hele pu ana me makou? A pela makou e hookaawaleia'i, owau a me ko'u poe kanaka, mai na kanaka e aka a pau loa e noho ana maluna o ka honua. ");
INSERT INTO haw1868_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Olelo mai la o Iehova, ia Mose, E hana no hoi au i keia mea au i olelo mai ai; no ka mea, ua loaa ia oe ka lokomaikaiia i ko'u maka, a ua ike aka au ia oe ma ka inoa. ");
INSERT INTO haw1868_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","A i aku la keia, Ke nonoi aku nei au ia oe, e hoike mai oe i kou nani ia'u. ");
INSERT INTO haw1868_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Olelo mai la ia, E hoohele au i ko'u maikai a pau imua o kou maka, a e hea aku au i ka inoa o Iehova imua o kou maka; a e lokomaikai aka au i ka mea a'u e manao ai e lokomaikai aku, a e aloha aku au i ka mea a'u e manao ai e aloha aka. ");
INSERT INTO haw1868_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","A i mai la ia, Aole hiki ia oe ke ike mai i ko'u maka; no ka mea, aohe kanaka e ike mai ia'u, a ola. ");
INSERT INTO haw1868_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","A i mai la o Iehova, Aia kahi e kokoke ana ia'u, a e ku no oe maluna o ka pohaku. ");
INSERT INTO haw1868_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","A i ka wa e hele ae ko'u nani, e hookomo no wau ia oe iloko o ka mauae o ka pohaku, a e uhi aku au ia oe i ko'u lima, ia'u e hele ana'e. ");
INSERT INTO haw1868_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","A e lawe aku au i ko'u lima, a e ike mai oe i ko'u kua; aka, aole e ikeia ko'u maka. ");
INSERT INTO haw1868_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","OLELO mai la o Iehova ia Mose, E kalai oe i mau pohaku papa elua nou, e like me na mea mamua; a na'u no e palapala maluna o ua mau papa la i na olelo i kauia'i ma na papa mua au i wahi ai. ");
INSERT INTO haw1868_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","E hoomakaukau oe no ke kakahiaka, a i ke kakahiaka e pii mai oe i ka mauna nei i Sinai, a e hoike mai oe ia oe iho ia'u ilaila ma ke poo o ka mauna. ");
INSERT INTO haw1868_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Mai hele pu mai kekahi kanaka me oe, aole hoi e ikea kekahi kanaka ma ka mauna a pau; aole hoi e ai na hipa a me na holoholona ma ke alo o ia mauna. ");
INSERT INTO haw1868_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Kalai iho la ia i na pohaku papa elua e like me na mea mamua; a ala ae la o Mose i kakahiaka nui, a pii aka la i ka mauna i Sinai, e like me ke kauoha ana mai o Iehova ia ia, a lawe aku la maloko o kona lima i ua mau pohaku papa la elua. ");
INSERT INTO haw1868_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Iho mai la o Iehova maloko o ke ao, a ku pu me ia ilaila, a hai mai la i ka inoa o Iehova. ");
INSERT INTO haw1868_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Hele ae la o Iehova mamua e kona alo, hai mai la ia, O Iehova, o Iehova, ke Akua lokomaikai, a manawalea, a ahonui, ua nui kona maikai a me ka oiaio. ");
INSERT INTO haw1868_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Ke malama nei no i ka lokomaikai no na lehulehu, a me ke kala mai i ka ino a me ka hala a me ka hewa, aole hoi e hoapono loa, e uku ana no i ka ka makua hala i ke keiki, a me na keiki a na keiki, a hiki aku i ke kuakahi a me ke kualua. ");
INSERT INTO haw1868_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Wikiwiki ae la o Mose e kulou i kona poo ilalo i ka honoa a hoomana aku la. ");
INSERT INTO haw1868_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","I aku la ia, A ina i loaa ia'u ka lokomaikaiia mai imua ou, e ka Haku e, ke nonoi aku nei au e hele pa aku ko'u Haku me makou: (he poe kanaka a-i eolea nae keia;) a e kala mai oe i ko makou hala me ko makou hewa, a e lawe oe ia makou i hooilina nou. ");
INSERT INTO haw1868_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","I mai la kela, Aia hoi, ke hana nei au i berita; a e hana no wau i na mea kupanaha mamua o kou poe kanaka a pau, aole i hanaia kekahi mea e like ai ma ka honua a pau, aole ma kekahi aina; a e ike auanei na kanaka a pau o kou wahi i ka hana a Iehova: he mea weliweli kela mea a'u e hana aku ai ia oe. ");
INSERT INTO haw1868_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","E malama hoi oe i ka mea a'u e kauoha aku ai ia oe i keia la. Aia hoi, e kipaku ana au imua ou, i ka Amora, a me ka Kanaaua, a me ka Heta, a me ka Periza, a me ka Heva, a me ka Iebusa. ");
INSERT INTO haw1868_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","E malama oe ia oe, o hana auanei oe i berita me ka poe e uoho ana i ka aina, kahi au e hele ai, o lilo ia i upiki iwaena o oukou. ");
INSERT INTO haw1868_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Aka, e hoopau oukou i ko lakou mau kuahu, a e wawahi i ko lakou kii, a e kua ilalo i ko lakou nlulaau. ");
INSERT INTO haw1868_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","No ka mea, mai hoomana oe i kekahi akua e, no ka mea, o Iehova, nona ka inoa o Lili, he Akua lili ia; ");
INSERT INTO haw1868_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","O hana oe i berita me na kanaka o ka aina, a hele moe kolohe lakou mamuli o ko lakou mau akua, a mohai aku na ko lakou mau akua, a hea mai ia oe, a ai oe i kana mohai. ");
INSERT INTO haw1868_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","A lawe paha oe i ka lakou kaikamahine na ka oukou keikikane; a hele moe kolohe ka lakou kaikamahine mamuli o ko lakou poe akua, a hoomoe kolohe lakou i ka oukou keikikane mamuli o ko lakou poe akua. ");
INSERT INTO haw1868_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Mai hana oe i akua hooheheeia nou. ");
INSERT INTO haw1868_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","E malama oe i ka ahaaina o ka berena huole. Ehiku la kau e ai ai i ka berena huole, me a'u i kauoha aku ai ia oe, i ka vra o ka malama o Abiba; no ka mea, i ka malama o Abiba i puka mai ai oe mawaho mai o Aigupita. ");
INSERT INTO haw1868_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","O na mea a pau i hemo mua, mai ka opu mai, o ka'u ia, a o na hanau mua a pau o na holoholona, ina ho bipi, a ina he hipa. ");
INSERT INTO haw1868_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Aka, o ka hanau mua o ka hoki, e panai aku oe i keiki hipa; a i ole oe e panai, e uhai oe i koua a-i. E hoola panai hoi oe i kau mau hiapo kane a pau. Mai ike nele ia kekahi imua o'u. ");
INSERT INTO haw1868_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Eono la kau e hana'i, aka, e hoomaha oe i ka hiku o ka la. I ka wa kanu, a i ka wa hoiliili ai, e hoomaha no oe. ");
INSERT INTO haw1868_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","E malama hoi oe i ka ahaaina hebedoma, no ka hoiliili mua ana i ka palaoa, a i ka ahaaina o ka hoiliili i ka puni ana o ka makahiki. ");
INSERT INTO haw1868_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","I ekolu no hoikeia'na i ka makahiki hookahi o ka oukou poe keikikane a pau imua o Iehova, ke Akua, ke Akua hoi o ka Iseraela. ");
INSERT INTO haw1868_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","No ka mea, e kipaku aku au i ko na aina imua ou. a e hoopalahalaha ae i kou mau mokuna; aole hoi e kuko mai kekahi kanaka i kou aina i ka wa e pii aku ai oe e ikeia imua o Iehova, kou Akua, ekolu pii ana o ka makahiki. ");
INSERT INTO haw1868_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Mai kaumaha oe i ke koko o kou mohai me ka mea hu; mai hookoe hoi i ka mohai o ka ahaaina moliaola, a kakahiaka. ");
INSERT INTO haw1868_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","E lawe mai no oe i ka mua o na hua mua o kou aina iloko o ka hale o Iehova, o kou Akua. Mai hoolapalapa oe i ke keiki kao iloko o ka waiu o kona makuwahine. ");
INSERT INTO haw1868_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","I mai la o Iehova ia Mose, E palapala oe i keia mau olelo: no ka mea, ma ke ano o keia mau olelo ka'u i hana aku ai i berita me oe, a me ka Iseraela. ");
INSERT INTO haw1868_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Malaila no ia me Iehova hookahi kanaha ao, hookahi kanaha po; aole ia i ai i ka ai, aole hoi i inu i ka wai. A palapala iho la ia ma na papa i na olelo o ka berita, i na olelo he umi. ");
INSERT INTO haw1868_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","A iho mai la o Mose, mai ka mauna o Sinai mai, aia no iloko o ko Mose lima na papa kanawai elua, i ka wa i iho mai ai ia mai ka mauna mai, aole o Mose i ike i ka puwa ana o ka ili o kona maka, i ka wa i kamailio pu ai oia me ia. ");
INSERT INTO haw1868_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","A ike aku la o Aarona, a me na mamo a pau a Iseraela ia Mose, aia hoi, ua puwa ka ili o kona maka; makau iho la lakou ke hookokoke ia ia. ");
INSERT INTO haw1868_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Hea mai la o Mose ia lakou; hoi aku la o Aarona a me na luna a pau o kanaka io na la: a kamailio ae la o Mose me lakou. ");
INSERT INTO haw1868_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","A mahope iho, hookokeke na mamo a pau a Iseraela: a kauoha mai la ia ia lakou i na mea a pau a Iehova i olelo mai ai ia ia, ma ka mauna i Sinai. ");
INSERT INTO haw1868_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Uhi mai la o Mose i ka pale ma kona maka, a pau kana kamailio ana me lakou. ");
INSERT INTO haw1868_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","A i ka wa i komo aku ai o Mose imua i ke alo o Iehova e olelo me ia, wehe ae la ia i ka pale a hiki i ka wa i puka mai ai mawaho mai; a puka mai la ia mawaho, a olelo mai i na mamo a Iseraela i na mea i kauohaia mai ia ia. ");
INSERT INTO haw1868_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","A ike aku la na mamo a Iseraela i ka maka o Mose, ua puwa ka ili o ko Mose maka: a uhi hou ae la o Mose i ka pale maluna o kona maka, a komo hou aku la ia e olelo pu me ia. ");
INSERT INTO haw1868_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","HOAKOAKOA iho la o Mose i ka aha kanaka a pau o ka Iseraela, i mai la ia lakou, Eia na olelo a Iehova i kauoha mai ai, i hana oukou ia mau mea. ");
INSERT INTO haw1868_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","I eono la e hanaia'i ka hana, aka o ka hiku o ka la, he la hoano ia, he Sabati e hoomaha'i no Iehova. O ka mea hana i ka hana ia la, e pepehiia oia. ");
INSERT INTO haw1868_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Mai hoa oukou i ke ahi ma ko oukou mau wahi e noho ai a pau loa, i ka la Sabati. ");
INSERT INTO haw1868_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Olelo mai la o Mose i ka aha kanaka a pau o ka Iseraela, i mai la, Eia ka mea a Iehova i kauoha mai ai, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","E lawe oukou, maiwaena aku o oukou, i mohai na Iehova; o na mea naau manawalea a pau, e lawe mai lakou i mohai na Iehova; i gula, a i kala, a i keleawe, ");
INSERT INTO haw1868_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","A i uliuli, a i poni, a i ulaula, a i olona keokeo, a i hulu kao; ");
INSERT INTO haw1868_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","A me na ili hipakane i hooluu ulaula ia, a me na ili tehasa, a me ka laau sitima; ");
INSERT INTO haw1868_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","A me ka aila no ka malamalama, a me na hua ala no ka aila poni, a no ka mea ala maikai; ");
INSERT INTO haw1868_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","A me na pohaku onika, a me na pohaku e kau ai maloko o ka epoda, a maloko o ka paleumauma. ");
INSERT INTO haw1868_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","A e hele mai no na mea naau akamai a pau, a e hana i na mea a pau a Iehova i kauoha mai ai; ");
INSERT INTO haw1868_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","I ka halelewa, i kona halelole a me kona uhi, a me kona mau lou, a me kona mau papa, a me kona mau auamo, a me kona mau kia, a me kona mau kumu; ");
INSERT INTO haw1868_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","I ka pahu, a me kona mau auamo, a me ka noho aloha, a me ka paku e uhi ai; ");
INSERT INTO haw1868_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","I ka papaaina, a me kona mau auamo, a me kona oihana a pau, a me ka berena hoike; ");
INSERT INTO haw1868_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","I ka ipukukui hoi no ka malamalama, a me kona oihana, a me kona mau ipu aila, me ka aila no ka malamalama; ");
INSERT INTO haw1868_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","I ke kuahu no ka mea ala, a me kona mau auamo, a me ka aila poni, a me ka mea ala maikai, a me ka paku no ka puka e komo aku ai iloko o ka halelewa; ");
INSERT INTO haw1868_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","I ke kuahu no ka mohaikuni, a me kona papa manamana pukapuka, a me kona mau auamo, a me kona mau oihana a pau, a me ka ipu auau, a me kona kumu; ");
INSERT INTO haw1868_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","I na paku o ke kahua, a me kona mau kia, a me ko lakou mau kumu, a me ka paku no ka puka o ke kahua; ");
INSERT INTO haw1868_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","I na makia o ka halelewa, a me na makia o ke kahua, a me ko lakou mau kaula; ");
INSERT INTO haw1868_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","I na lole no ka hana, e hana'i i ka hana ma kahi laa, i na kahiko laa no Aarona ke kahuna, a me na kahiko o kana mau keikikane, e lawelawe ai ma ka oihana kahuna. ");
INSERT INTO haw1868_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","A hele aku la ke anaina kanaka a pau o na mamo a Iseraela, mai ko Mose alo aku. ");
INSERT INTO haw1868_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","A hele mai no lakou, o kela mea keia mea i hooeueuia e kona naau, o kela mea keia mea hoi i hooikaikaia e kona uhane, a lawe mai lakou i ko Iehova haawina no ka hana o ka halelewa o ke anaina kanaka, a no kana hana a pau, a no na kahiko laa. ");
INSERT INTO haw1868_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","A hele mai lakou, o na kane, a me na wahine, o ka poe a pau i makemake ma ka naau, a lawe mai la i na kupee lima, a me na gula pepeiao, a me na apo, a ma na gula a-i, a me na mea gula a pau loa; a o kela mea, keia mea i haawi, haawi oia i gula no Iehova. ");
INSERT INTO haw1868_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","A o kela kanaka keia kanaka i loaa ia ia ka uliuli, ka poni, a me ka ulaula, a me ke olona keokeo, a me ka hulu kao, a me na ili ulaula o na hipakane, a me na ili tehasa, lawe mai no lakou la mau mea. ");
INSERT INTO haw1868_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","O kela mea keia mea i haawi i ka haawina kala, a keleawe, lawe mai no oia i ka Iehova haawina. A o kela kanaka keia kanaka i loaa ia ia ka laau sitima no kahi hana e hana'i, lawe mai la oia ia. ");
INSERT INTO haw1868_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","A o na wahine a pau i akamai ma ka naau, milo lakou me ko lakou lima, a lawe mai la i ka mea a lakou i milo ai, i ka uliuli, a me ka poni, a me ka ulaula, a me ke olona keokeo. ");
INSERT INTO haw1868_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","A o na wahine a pau i hooikaikaia ma ka naau, i mea e akamai ai, milo lakou i ka hulu kao. ");
INSERT INTO haw1868_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","A lawe mai na'lii i pohaku onika, a me na pohaku e kau ai ma ka epoda, a ma ka paleumauma; ");
INSERT INTO haw1868_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","A me na mea ala, a me ka aila no ka malamalama, a no ka aila poni a me ka mea ala maikai. ");
INSERT INTO haw1868_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Lawe mai no na mamo a Iseraela i makana aloha no Iehova, o kela kane keia kane i makemake ma ka naau e lawe, no ka hana a pau a Iehova i kauoha mai ai ma ka lima o Mose. ");
INSERT INTO haw1868_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Olelo mai la o Mose i na mamo a Iseraela, E nana hoi, ma ka inoa no i hea mai ai o Iehova ia Bezalela, i ke keiki a Uri, i ke keiki a Hura, no ka ohana a Iuda; ");
INSERT INTO haw1868_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","A ua hoopiha ia ia i ka uhane o ke Akua, i ke akamai, a i ka naauao, a i ka ike, a i ke ano o na hana a pau; ");
INSERT INTO haw1868_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","I imi oia i na hana akamai, e hana i ke gula, a i ke kala, a i ke keleawe, ");
INSERT INTO haw1868_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","A i ke okioki pohaku ana, a me ke kapilipili, i ke kalai laau, a me ka hana i na hana akamai a pau. ");
INSERT INTO haw1868_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","A ua haawi hoi oia iloko o kona naau i ke ao aku, oia, a me Aholiaba, ke keiki a Ahisamaka, no ka ohana a Dana. ");
INSERT INTO haw1868_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Ua hoopiha oia ia laua i ke akamai o ka naau, e hana i na hana a pau, o ka mea kahakaha, a me ka mea hana akamai, a me ka mea humuhumu i ka uliuli, a me ka poni, a me ka ulaula, a me ke olona keokeo, a me ka mea upena, a me ka mea hana i na hana a pau, a me ka mea imi i ka hana akamai, ");
INSERT INTO haw1868_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","A LAILA hana o Bezalela, a me Aholiaba, a me na kanaka a pau i akamai ka naau, na mea a Iehova i haawi mai ai i ke akamai, a me ka naauao e ike ai i ka hana i na hana a pau no ka oihana o ke keenakapu, e like me na mea a pau a Iehova i kauoha mai ai. ");
INSERT INTO haw1868_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","A hea aku la o Mose ia Bezalela, a me Aholiaba, a me na kanaka a pau i akamai ma ka naau, a Iehova i haawi mai ai i naau akamai, i na mea a pau hoi i ikaika ma ko lakou naau e hele e kokua i ka hana. ");
INSERT INTO haw1868_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","A loaa ia lakou, na Mose ae, na haawina a pau a na mamo a Iseraela i lawe mai ai no ka hana o ka oihana o ke keenakapu, i mea e paa ai ka hana. A lawe mai no lakou ia ia i makana hou i kela kakahiaka, i keia kakahiaka. ");
INSERT INTO haw1868_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","A hele mai la na kanaka akamai a pau, ka poe i hana i na hana a pau o ke keenakapu, mai ka hana mai, a lakou i hana'i. ");
INSERT INTO haw1868_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","A olelo mai la lakou ia Mose, i mai la, Ke lawe mai nei na kanaka a nui okoa aku, mamua o ka lawelawe ana i ka hana a Iehova i kauaha mai ai e hana. ");
INSERT INTO haw1868_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","A kauoha ae la o Mose, a hookala aku la lakou ia, a puni kahi i hoomoana'i, i ae la, Mai hana hou kekahi kanaka, aole hoi kekahi wahine i hana no ka haawina o ke keenakapu. A hookiia iho la ka lawe ana mai o na kanaka. ");
INSERT INTO haw1868_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","No ka mea, ua lawa na mea e paa ai ka hana a pau e hanaia'i a keu aku no. ");
INSERT INTO haw1868_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","A o ka poe mea naau akamai a pau i hana i ka hana o ka halelewa, hana lakou i umi mau pale, he olona i hiloia, he uliuli, he poni, a me ka ulaula; hana no oia ia mau mea na kerubima, o ka hana a ka poe akamai. ");
INSERT INTO haw1868_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","He iwakaluakumamawalu kubita ka loihi o kekahi pale, eha kubita ka laula o kekahi pale, ua like hoi ka nui o na pale a pau. ");
INSERT INTO haw1868_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","A hai pu oia i na pale elima, kekahi i kekahi, a hui pu oia i kekahi mau lima, kekahi i kekahi. ");
INSERT INTO haw1868_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","A hana iho la no hoi ia i na puka lou uliuli, ma ke kae o kekahi pale, ma ka pelupelu ana maloko o ka huina. A pela no oia i hana'i, ma ke kihi loa o kekahi pale, ma kahi i huiia'i me ka lua. ");
INSERT INTO haw1868_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Hana no oia i kanalima puka lou ma kekahi pale, a hana no hoi i kanalima puka lou ma ke kae o ka pale, kahi i haiia'i me ka lua. O na puka lou ka mea i paa ai kekahi i kekahi. ");
INSERT INTO haw1868_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","A hana oia i kanalima lou gula, a hui oia i na pale, kekahi me kekahi a paa i na lou. A lilo iho la ia i halelewa hookahi. ");
INSERT INTO haw1868_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","A hana no hoi oia i pale hulu kao no ka hale maluna o ka halelewa: hana oia ia mau mea, he umikumamakahi pale. ");
INSERT INTO haw1868_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","He kanakolu kubita ka loihi o kekahi pale, a eha no kubita ka laula o kekahi pale; ua like ka nui o na pale he umikumamakahi. ");
INSERT INTO haw1868_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","A hui oia i elima mau pale a kaawale lakou, a i eono mau pale a kaawale lakou. ");
INSERT INTO haw1868_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","A hana iho la no oia i kanalima puka lou ma ke kae loa o kekahi pale ma ka hui ana, a hana no hoi oia i kanalima puka lou ma ke kae o ka pale i hui me ka lua. ");
INSERT INTO haw1868_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","A hana no hoi oia i kanalima lou keleawe e paa ai ka hale, i lilo ia i hookahi. ");
INSERT INTO haw1868_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","A hana no hoi oia i uhi no ka hale, he mau ili hipakane i hooluu ulaula ia, a maluna aku, i uhi hou, he mau ili tehasa. ");
INSERT INTO haw1868_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","A hana no hoi oia i mau papa no ka halelewa, he laau sitima, e ku pono ana iluna. ");
INSERT INTO haw1868_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","He umi kabita ka loa o kekahi papa, a hookahi kubita a me ka hapalua ka laula o kekahi papa. ");
INSERT INTO haw1868_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Elua no komo ko ka papa hookahi, ua like no ke kaawale ana o kekahi, a me kekahi. Pela no ia i hana'i no na papa a pau o ka halelewa. ");
INSERT INTO haw1868_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","A hana oia i papa no ka halelewa, he iwakalua papa no ka aoao hema ma ka hema. ");
INSERT INTO haw1868_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","A hana oia i hookahi kanaha kumu kala malalo iho o na papa he iwakalua; elua kumu malalo o ka papa hookahi, no kona mau komo elua, a elua hoi kumu malalo o kekahi papa no kona mau komo elua. ");
INSERT INTO haw1868_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","A no kela aoao hoi o ka halelewa, ma ke kihi akau, hana no oia i iwakalua papa, ");
INSERT INTO haw1868_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","A me ko lakou kumu kala he kanaha; elua kumu malalo iho o kekahi papa, elua hoi kumu malalo iho o kekahi papa. ");
INSERT INTO haw1868_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","A no na aoao o ka halelewa, ma ke komohana, hana oia i eono papa. ");
INSERT INTO haw1868_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","A hana oia i elua papa no na kihi o ka halelewa, ma na aoao elua. ");
INSERT INTO haw1868_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","A ua huiia ia mau mea malalo, a ua huiia ma na poo ma ke apo hookahi. Pela no oia i hana'i ia laua a elua, ma na kihi elua. ");
INSERT INTO haw1868_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Ewalu no ia mau papa a o ko lakou mau kumu, he umikumamaono kumu kala, elua no kumu, a elua hoi kumu malalo o ka papa hookahi. ");
INSERT INTO haw1868_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","A hana no oia i mau laau ki, he laau sitima; i elima no na papa ma kekahi aoao o ka halelewa, ");
INSERT INTO haw1868_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","A i elima hoi ki no na papa o kekahi aoao o ka halelewa, a i elima hoi ki no na papa o ka halelewa no na aoao ma ke komohana. ");
INSERT INTO haw1868_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","A hana iho la oia i ka laau ki mawaenakonu, e puka loa, mai kekahi kala a i kekahi kala. ");
INSERT INTO haw1868_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","A wahi iho la oia i na papa i ke gula, a hana iho la i ko lakou mau apo, he gula, i wahi no na laau ki, a wahi iho la i na ki i ke guia. ");
INSERT INTO haw1868_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","A hana iho la oia i paku, he uliuli, a he ulaula, a he olona i hiloia, a hana no hoi i na kerubima, he hana na ka mea akamai. ");
INSERT INTO haw1868_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","A hana oia i eha kia nona, he laau sitima, a uhi oia ia mau mea i ke gula. He gula no ko lakou mau lou, a hoohehee oia no lakou i mau kumu kala eha. ");
INSERT INTO haw1868_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Hana iho la no hoi oia i pale no ka puka komo o ka halelewa, he uliuli, he poni, he ulaula, a me ke olona i hiloia, ka hana a ka mea humuhumu lope ano e; ");
INSERT INTO haw1868_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","A me na kia ona elima, a me ko lakou mau lou; a uhi no hoi oia i ko lakou mau poo, a me ko lakou mau auka e paa ai i ke gula. Aka, he keleawe no ko lakou mau kumu elima. ");
INSERT INTO haw1868_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","A HANA iho la o Bezalela i ka pahu, he laau sitima; elua kubita a me ka hapalua kona loihi, a hookahi kubita a me ka hapalua kona laula; a hookahi kubita a me ka hapalua kona kiekie: ");
INSERT INTO haw1868_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","A uhi iho la oia ia mea i ke gula maikai, maloko, a mawaho, a hana iho la oia nona i lei gula a puni. ");
INSERT INTO haw1868_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","A hoohehee oia i eha apo gula nona, no kona mau kihi eha; i elua apo ma kekahi aoao ona, a i elua apo ma kekahi aoao ona. ");
INSERT INTO haw1868_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","A hana iho la oia i mau auamo laau sitima, a uhi iho la ia mau mea i ke gula. ");
INSERT INTO haw1868_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Hookomo ae la oia i na auamo iloko o na apo, ma na aoao o ka pahu e amo ai i ka pahu. ");
INSERT INTO haw1868_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","A hana iho la oia i ka noho aloha, he gula maikai; elua kubita a me ka hapalua kona loa, a hookahi kubita a me ka hapalua kona laula. ");
INSERT INTO haw1868_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","A hana iho la oia i elua kerabima, he gula paa wale no, hookahi apana ia i hana'i ia laua ma na welau o ka noho aloha. ");
INSERT INTO haw1868_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Hookahi kerubima ma kekahi welau, ma keia aoao, a o kekahi kerubima ma kekahi welau ma kela aoao. Maluna o ka noho aloha oia i hana'i i na kerubima, ma kona mau welau elua. ");
INSERT INTO haw1868_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","A hohola ae la na kerubima i ko laua mau eheu iluna, a uhi ao la ko laua mau eheu i ka noho aloha, a ku pono iho la ko laua mau maka kekahi i kekahi, ma ka noho aloha na maka o na kerubima. ");
INSERT INTO haw1868_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Hana no hoi oia i ka papaaina, he laau sitima; elua kubita kona loa, hookahi kubita kona laula, a hookahi kubita a me ka hapa kona kiekie. ");
INSERT INTO haw1868_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","A uhi iho la oia ia i ke gula maikai, a hana ae la i lei gula nona a puni. ");
INSERT INTO haw1868_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","A hana no hoi oia i kae a puni ia mea, i hookahi lima ka laula, a hana ae la ia i lei gula no ua kae la a puni. ");
INSERT INTO haw1868_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","A hoohehee oia nona i eha apo gula, a kau oia i na apo ma na kihi eha ma kona mau wawae eha. ");
INSERT INTO haw1868_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","I ku pono na apo i ko kae, na wahi e komo ai na auamo e lawe i ka papaaina. ");
INSERT INTO haw1868_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","A nana iho la oia i na auamo, he laau sitima, a uhi iho la ia lakou i ke gula, i mea e lawe ai i ka papaaina. ");
INSERT INTO haw1868_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","A hana no hoi oia i ka oihana maluna o ka papa, i kona mau kiaha, a me kona mau puna, a me kona mau ipu, a me na poi e ninini ai, he gula maikai. ");
INSERT INTO haw1868_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","A hana iho la ia i ka ipukukui manamana he gula maikai, hana oia i ka ipukukui he gula wale no a paa, o kona kumu, a me kona lala, o kona mau puupuu, a me kona mau pua, oia apana hookahi no. ");
INSERT INTO haw1868_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Eono no lala e puka ana mawaho o kona mau aoao; ekolu manamana o ka ipukukui mai kekahi aoao ona mai, a ekolu manamana o ka ipukukui, mai kela aoao ona mai. ");
INSERT INTO haw1868_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Ekolu no ipu e like me na alemona ma ka mana hookahi, he puupuu, a me ka pua; a ekolu no ipu e like me na alemona ma kekahi mana, he puupuu a me ka pua: a pela wale no ma na manamana eono, e puka ana mawaho o ka ipukukui manamana. ");
INSERT INTO haw1868_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Eha no ipu ma ke knmukukui, ua hanaia e like me na alemona, o kona mau puupuu, a me kona mau pua. ");
INSERT INTO haw1868_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","A he puupuu malalo o kona mau lala elua, a he puupuu malalo iho o kona mau lala elua, a he puupuu malalo iho o kona mau lala elua, e like me na lala eono, o puka mai ana mawaho ona. ");
INSERT INTO haw1868_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Hookahi no apana ko lakou puupuu, a me ko lakou manamana. Hookahi no apana ia hana a pau, he gula maikai. ");
INSERT INTO haw1868_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","A hana no hoi oia i kona mau ipu aila ehiku, a me kona mau upaahi, a me kona mau upakolikukui, he gula maikai. ");
INSERT INTO haw1868_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Hana no oia ia mea, a me kona oihana a pau, hookahi talena gula maikai. ");
INSERT INTO haw1868_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","A hana no hoi oia i ke kuahu no ka mea ala, he laau sitima: hookahi kubita kona loa, hookahi kubita kona laula, he ahalike; a elua kubita kona kiekie, a hookahi no ia apana me kona mau pepeiao elua. ");
INSERT INTO haw1868_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","A uhi oia ia mea i ke gala maikai, ma ko luna ona a me kona mau aoao a puni, a me kona mau pepeiao. A hana no hoi oia i lei gala a puni ia mea. ");
INSERT INTO haw1868_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","A hana iho la oia i elua apo gula nona, malalo iho o kona lei, ma kona mau kihi elua, ma na aoao ona elua, i wahi no na auamo, e amo ai ia mea. ");
INSERT INTO haw1868_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","A hana iho la oia i na auamo, he laau sitima, a uhi iho la ia mau mea i ke gula. ");
INSERT INTO haw1868_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","A hana iho la oia i ka aila poni laa, a me ka mea ala maikai i hua ala loa, e like me ka hana ana a ka mea kaawili laau. ");
INSERT INTO haw1868_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","A HANA no hoi oia i ke kuahu no ka mohaikuni: elima kubita kona loihi, a elima kubita kona laula, he ahalike: a ekolu kubita kona kiekie. ");
INSERT INTO haw1868_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","A hana oia i kona mau pepeiao, ma na kihi eha ona; no ia mea hookahi no na pepeiao, a uhi oia ia i ke keleawe. ");
INSERT INTO haw1868_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","A hana oia i na oihana a pau o ke kaahu, i na ipu, a me na papale, a me na kiaha, a me na o io, a me na ipu ahi; hana no oia i kona oihana a pau, he keleawe. ");
INSERT INTO haw1868_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","A hana no hoi oia no ke kuahu, i papa manamana pukapuka malalo iho o ke kae ona, mawaenakonu. ");
INSERT INTO haw1868_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","A hoohehee oia i eha mau apo no na welau eha o ua mea manamana keleawe la, i wahi no na auamo. ");
INSERT INTO haw1868_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","A hana oia i na auamo, he laau sitima, a ubi iho la ia laua i ko keleawe. ");
INSERT INTO haw1868_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","A hookomo oia i na auamo iloko o na apo ma na aoao o ke kuahu i mea e lawe ai, a hana oia i ke kuahu, he papa laau, ua kawaha. ");
INSERT INTO haw1868_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","A hana oia i ka ipu auau, he keleawe, ko loko o kona kumu, he keleawe, a me na aniani keleawe o ka poe e akoakoa nui ana, ka poe i akoakoa ma ka puka o ka halelewa o ke anaina. ");
INSERT INTO haw1868_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","A hana oia i ke kahua, ma ka aoao hema, ma ka hema hoi; a o na pale o ke kahua, he olona ia i hiloia, hookahi haneri kubita. ");
INSERT INTO haw1868_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","O ko lakou mau pou, he iwakalua, o ko lakou mau Kumu keleawe, he iwakalua. O na lou o na pou, a me ko lakou auka e paa ai, ne kala. ");
INSERT INTO haw1868_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","A no ka aoao akau, hookahi haneri kubita, o ko lakou mau pou, he iwakalua, a o ko lakou mau kumu keleawe, he iwakalua. O na lou o na pou, a me ko lakou auka e paa ai, he kala. ");
INSERT INTO haw1868_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","A no ka aoao komohana, he pale no, he kanalima kubita ka loihi, o ko lakou mau pou, he umi, a o ko lakou mau kumu he umi. O na lou o na pau a me ko lakou auka e paa ai, he kala. ");
INSERT INTO haw1868_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","A no ka aoao hikina ma na hikina, he kanalima kubita. ");
INSERT INTO haw1868_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","A o na pale ma kekahi aoao o ka puka, he umikumamalima kubita; a o ko lakou mau pau ekolu, a o ko lakou mau kumu, ekolu. ");
INSERT INTO haw1868_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","A no kela aoao o ka puka o ke kahua, he mau pale ma keia aoao a ma kela aoao, he umikumamalima kubita, o ko lakou mau pau ekolu, a o ko lakou mau kumu ekolu. ");
INSERT INTO haw1868_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","O na pale a pau a puni ke kahua, he olona no i hiloia. ");
INSERT INTO haw1868_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","A o na kumu no na pou, he keleawe ia. O na lou o na pou, a me ko lakou mau auka e paa ai, he kala no. A o ka uhi ana o ko lakou mau poo, he kala: a paa no na pau a pau o ke kahua i na auka kala. ");
INSERT INTO haw1868_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","A o ka pale o ka puka o ke kahua, he hana no ia a ka mea humuhumu lope ano e, he uliuli, he poni, he ulaula, he olona i hiloia: he iwakalua kubita ka loihi, a o ke kiekie ma ka laula, elima no kubita, e like me na pale o ke kahua. ");
INSERT INTO haw1868_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","A o ko lakou mau pou, eha, a. o ko lakou mau kumu, eha no, he keleawe; o ko lakou lou, he kala, a o ka uhi ana o ko lakou mau poo, a o ko lakou mau auka e paa ai, he kala no. ");
INSERT INTO haw1868_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","A o na makia a pau o ka halelewa, a me ke kahua e puni ana, he keleawe no ia. ");
INSERT INTO haw1868_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Eia ka huina o ka halelewa, o ka halelewa hoi o ke kanawai, e like me ia i heluia, mamuli o ke kauoha a Mose, no ka hana a ko Levi, ma ka lima o Itamara, ke keiki a Aarona, ke kahuna. ");
INSERT INTO haw1868_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","A hana iho la o Bezalela, ke keiki a Uri, ke keiki a Hura, no ka ohana a Iuda, i na mea a pau a Iehova i kauoha mai ai ia Mose. ");
INSERT INTO haw1868_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","A me ia pu no o Aholiaba, ke keiki a Ahisamaka, no ka ohana a Dana, he kahuna kalai, he mea akamai i ka hana, a he mea humuhumu lope ano e, he uliuli, a he poni, a he ulaula, a me ke olona keokeo. ");
INSERT INTO haw1868_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","A o ke gula a pau i hanaia ma ka hana o ia mea laa, o ke gula laa he iwakaluakumamaiwa talena a me na sekela ehiku haneri me kanakolu, ma ka sekela o ke keenakapu. ");
INSERT INTO haw1868_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","A o ke kala o ka poe i heluia o ka aha kanaka, hookahi haneri talena, a me ka sekela hookahi tausani, ehiku haneri, me kanahikukumamalima, ma ka sekela o ke keenakapu. ");
INSERT INTO haw1868_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","He beka no kela kanaka keia kanaka, he hapalua sekela hoi, ma ka sekela o ke keenakapu, no kela mea keia mea i hele ae i ka helu ana, mai ka iwakalua o ka makahiki a keu aku, no na kanaka eono haneri kumamakolu tausani, elima haneri, a me kanalima. ");
INSERT INTO haw1868_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","A noloko o ia haneri talena kala, i hooheheeia'i na kumu o ke keenakapu, a me na kumu o ka paku: hookahi haneri kumu, noloko o ia mau haneri talena, hookahi talena, hookahi kumu. ");
INSERT INTO haw1868_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","A noloko mai o ke tausani sekela a me na haneri keu ehiku, a me kanahikukumamalima, hana iho la oia i mau lou no na pou, a uhi iho la i ko lakou poo, a hoopaa ne la ia lakou i na auka. ");
INSERT INTO haw1868_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","A o ke keleawe o ka haawina, he kanahiku ia mau talena, a me na sekela keu elua tausani, a me na haneri eha. ");
INSERT INTO haw1868_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","A noloko olaila hana ae la oia i na kumu no ka puka o ka halelewa o ke anaina kanaka, a me ke kuahu keleawe, a me kona papa manamana pukapuka, a me ka oihana a pau o ke kuahu, ");
INSERT INTO haw1868_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","A me na kumu o ke kahua a puni, a me na kumu o ka puka o ke Kahua, a me na makia a pau o ka halelewa, a me na makia a pau o ke kahua a puni. ");
INSERT INTO haw1868_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","A HANA lakou i lole hana, he uliuli, he poni, he ulaula, i mea hana maloko o kahi kapu, a hana no hoi lakou i na kahiko laa no Aarona, e like me ka Iehova i kauoha mai ai ia Mose. ");
INSERT INTO haw1868_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","A hana iho la oia i ka epoda, he gula, he uliuli, he poni, he ulaula, a me ke olona i hiloia. ");
INSERT INTO haw1868_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","A kui lakou i ke gula a lahilahi, a okioki iho la i kaula, i mea hana pu me ka uliuli, a me ka poni, a me ka ulaula, a me ke olona i hiloia, he hana na ka mea akamai. ");
INSERT INTO haw1868_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Hana no hoi lakou i mau apana poohiwi no ka epoda, i mea e uhiia oia a paa. Ua huiia ma na kihi a elua. ");
INSERT INTO haw1868_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","A o ke kaei o kona epoda, ka mea maluna ona, o ia ano hookahi no, e like me ia i hanaia, he gula, he uliuli, he poni, he ulaula, a me ke olona i hiloia, me ka Iehova i kauoha mai ai ia Mose. ");
INSERT INTO haw1868_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","A hana iho la lakou i pohaku onika, i hoopaaia a puni iloko o na kawaha gula, i kahakahaia e like me ke kahakaha ana o na hoailona me na inoa o na keiki a Iseraela. ");
INSERT INTO haw1868_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","A kau aku la oia ia mau mea maluna o na poohiwi o ka epoda, i pohaku paipai manao no na mamo a Iseraela, me ka Iehova i kauoha mai ai ia Mose. ");
INSERT INTO haw1868_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","A hana iho la oia i ka paleumauma, he hana na ka mea akamai, e like me ka hana ana i ka epoda, he gula, he uliuli, he poni, he ulaula, a me ke olona i hiloia. ");
INSERT INTO haw1868_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","He ahalike ia; a hana lakou i ka paleumauma a papalua: hookahi kikoo kona loa, a hookahi kikoo kona laula, a ua papalua. ");
INSERT INTO haw1868_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","A kau lakou iloko olaila i eha lalani pohaku; he saredio, he topazo, he paea, oia ka lalani mua. ");
INSERT INTO haw1868_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","A o ka lalani lua, he omaomao he sapeiro, he daimana. ");
INSERT INTO haw1868_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","A o ka lalani kolu, he lesema, he ula, he ametuseto. ");
INSERT INTO haw1868_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","A o ka lalani aha, he berulo, he onika, he iasepi. Ua hoopaaia ia mau mea iloko o na kawaha gula, oia ko lakou mea i paa ai. ");
INSERT INTO haw1868_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","A ua like na pohaku me na keiki a Iseraela, he umikumamalua, ma ko lakou inoa, e like me ke kahakaha ana o ka hoailona, o kela mea keia mea ma kona inoa, ma na ohana he umikumamalua. ");
INSERT INTO haw1868_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","A hana no hoi lakou ma ka paleumauma i mau kaula ma na welau, he gula maikai i hiloia. ");
INSERT INTO haw1868_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","A hana lakou i elua kawaha gula, a elua hoi apo gula, a hookomo ae la i na apo elua iloko o na welau o ka paleumauma. ");
INSERT INTO haw1868_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","A hookomo lakou i na kaula gula elua i hiloia a i loko o na apo elua ma na welau o ka paleumauma. ");
INSERT INTO haw1868_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","A hoopaa lakou i na piko o na kaula kilo elua a i na kawaha elua, a kau aku la ia laua maluna o na apana poohiwi o ka epoda, a ma kona alo. ");
INSERT INTO haw1868_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","A hana iho la lakou i elua apo gula, a kau aku la ma na welau elua o ka paleumauma, ma kona kae, ma ka aoao maloko o ka epoda. ");
INSERT INTO haw1868_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","A hana no hoi lakou i elua apo gula, a kau aku la ia laua ma na aoao elua o ka epoda malalo iho, ma kona alo, e ku pono ana i ka huina, maluna o ke kaei o ka epoda. ");
INSERT INTO haw1868_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","A nakinaki lakou i ka paleumauma ma na apo ona, a paa i na apo o ka epoda me ke kaula uliuli, i kau ia maluna o ke kaei o ka epoda, i ole ai e weheia ka paleumauma mai ka epoda aku, me ka Iehova i kauoha mai ai ia Mose. ");
INSERT INTO haw1868_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","A hana iho la oia i ka holoku o ka epoda, he hana na ka mea ulana, he uliuli wale no. ");
INSERT INTO haw1868_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","A he puka no mawaena konu o ka holoku, e like me ka puka o ka puliki koa, ua pelupeluia a puni ka puka, i ole ia e nahae. ");
INSERT INTO haw1868_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","A hana lakou i mau pomegerane ma na lepa o ka holoku, he uliuli, he poni, he ulaula, a me ke olona i hiloia. ");
INSERT INTO haw1868_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","A hana no hoi lakou i mau bele he gula maikai, a kau aku la i na bele mawaena o na pomegerane, ma ka lepa o ka holoku a puni na pomegerane mawaena. ");
INSERT INTO haw1868_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","He bele a me ka pomegerane, he bele a me ka pomegerane, a puni ka lepa o ka holoku hana, me ka Iehova i kauoha mai ai ia Mose. ");
INSERT INTO haw1868_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","A hana no hoi lakou i mau palule, he olona i hiloia, o ka hana a ka mea ulana, no Aarona, a no kana mau keikikane, ");
INSERT INTO haw1868_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","A me ka papale hainaka, he olona keokeo, a me na papale migebo, he olona keokeo, a me na wawae, he olona i hiloia, ");
INSERT INTO haw1868_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","A me ke kaei he olona i hiloia, he uliuli, he poni, a me ka ulaula, he mea i humuhumuia: me ka Iehova i kauoha mai ai ia Mose. ");
INSERT INTO haw1868_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","A hana no hoi lakou i ka papa o ka papale laa, he gula maikai, a palapala iho la i ka palapala e like me ke kahakaha ana o ka hoailona, UA LAA NO IEHOVA. ");
INSERT INTO haw1868_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","A nakinaki lakou ia me ke kaula uliuli, i mea e paa ai ia maluna, ma ka papale; me ka Iehova i kauoha mai ai ia Mose. ");
INSERT INTO haw1868_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","A paa iho la ka hana a pau o ka halelewa, ka halelole hoi o ke anaina kanaka. A hana iho la na mamo a Iseraela, e like me na mea a pau a Iehova i kauoha mai ai ia Mose, pela lakou i hana'i. ");
INSERT INTO haw1868_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","A lawe mai lakou i ka halelewa ia Mose, i ka halelole, a me kona oihana a pau, i kona mau lou, i kona mau papa, i kona mau auka e paa ai, i kona mau pou, i kona mau kumu; ");
INSERT INTO haw1868_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","A me ka uhi ili hipakane i hooluu ulaula ia, a me ka uhi ili tehasa, a me ka paku e uhi ai; ");
INSERT INTO haw1868_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","I ka pahu kanawai, a me kona mau auamo, a me ka noho aloha; ");
INSERT INTO haw1868_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","I ka papaaina, a me kona oihana, a me ka berena hoike; ");
INSERT INTO haw1868_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","I ka ipukukui manamana maikai, a me kona mau ipu aila, e ku pololei ana, a me kona oihana a pau, a me ka aila no ka malamalama; ");
INSERT INTO haw1868_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","I ke kuahu gula, a me ka aila poni a me ka mea ala maikai, a me ka pale no ka puka o ka halelewa; ");
INSERT INTO haw1868_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","I ke kahua keleawe, a me kona pa keleawo manamana pukapuka, a me kona mau auamo, a me kona oihana a pau, i ka ipu auau a me kona kumu; ");
INSERT INTO haw1868_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","I na pale o ke kahua, a me kona mau pou, a me kona mau kumu, a me ka pale no ka puka o ke kahua, a me kona mau kaula, a me kona mau makia, a me na mea hana a pau no ka halelewa, no ka halelole o ke anaina kanaka; ");
INSERT INTO haw1868_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","I ka lole hana e hana'i iloko o kahi laa, a mo na kahiko laa no Aarona ke kahuna, a me na kahiko o kana mau keiki, e lawelawe ai ma ka oihana kahuna. ");
INSERT INTO haw1868_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","E like me ka Iehova i kauoha mai ai ia Mose, pela i hana'i na mamo a Iseraela i ka hana a pau. ");
INSERT INTO haw1868_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","A makaikai ae la o Mose i ka hana a pau, aia hoi, ua hana lakou ia e like me ka Iehova i kauoha mai ai, pela no lakou i hana'i. A hoomaikai ae la o Mose ia lakou. ");
INSERT INTO haw1868_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","OLELO mai la hoi o Iehova ia Mose, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","I ka la mua o ka malama mua, e kukulu oe i ka halelewa o ka halelole o ke anaina kanaka: ");
INSERT INTO haw1868_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","A e waiho oe maloko olaila i ka pahu kanawai, a e uhi i ka pahu i ka paku. ");
INSERT INTO haw1868_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","A e lawe oe i ka papaaina iloko, a e hoonohonoho i na ohana maluna iho; a e lawe mai hoi i ka ipukukui manamana, a e hoa hoi i kona mau ipu aila. ");
INSERT INTO haw1868_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","A e kau oe i ke kuahu gula no ka mea ala imua o ka pahu kanawai, a e kau aku i ka pale o ka puka o ka halelewa. ");
INSERT INTO haw1868_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","A e hoonoho oe i ke kuahu no ka mohaikuni imua o ka puka o ka halelewa o ka halelole o ke anaina kanaka. ");
INSERT INTO haw1868_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","A e kau oe i ka ipuanau mawaena o ka halelole o ke anaina kanaka, a me ke kuahu, a e ninini hoi i ka wai maloko. ");
INSERT INTO haw1868_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","A e kukulu oe i ka paku kahua a pau, a e kau aku i ka pale ma ka puka o ke kahua. ");
INSERT INTO haw1868_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","E lawe no hoi oe i ka aila poni, a e poni iho i ka halelewa, a me na mea a pau maloko, a e hoolaa ia mea, a me kona oihana a pau, a e lilo ia i mea laa. ");
INSERT INTO haw1868_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","A e poni no hoi oe i ke kuahu no ka mohaikuni, a me kana oihana a pau, a e hoolaa i ke kuahu, a e lilo ia i kuahu laa loa. ");
INSERT INTO haw1868_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","A e poni oe i ka ipuauau a me kona kumu, a e hoolaa ia mea. ");
INSERT INTO haw1868_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","A e lawe mai oe ia Aarona a me kana mau keikikane i ka puka o ka halelewa o ke anaina kanaka, a e holoi ia lakou i ka wai. ");
INSERT INTO haw1868_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","A e hookomo no oe maluna o Aarona i na kahiko laa, a e poni ia ia, a e hoolaa ia ia, i lawelawe oia na'u ma ka oihana kahuna. ");
INSERT INTO haw1868_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","A e lawe mai no hoi oe i kana mau keikikane, a e hookomo maluna o lakou i na palule: ");
INSERT INTO haw1868_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","A e poni oe ia lakou, e like me kou poni ana i ko lakou makuakane, i lawelawe lakou na'u ma ka oihana kahuna; no ka mea, he oiaio, e lilo ko lakou poni ana, i mea e kahuna mau loa ai, i ko lakou mau hanauna aku. ");
INSERT INTO haw1868_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Pela o Mose i hana'i: e like me na mea a pau a Iehova i kauoha mai ai ia ia, pela no ia i hana'i. ");
INSERT INTO haw1868_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","A i ka malama mua o ka makahiki alua, i ka la mua o ka malama, ua kukuluia ka halelewa. ");
INSERT INTO haw1868_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","A kukulu o Mose i ka halelewa, a hoopaa iho la i kona mau kumu, a kukulu hoi i kona mau papa, a hookomo ae la i kona mau auka e paa ai, a kukulu no hoi i kona mau pou. ");
INSERT INTO haw1868_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","A haalii ae la oia i ka halelole maluna o ka halelewa, a kau aku la i ka uhi o ka halelole maluna aku; e like me ka Iehova i kauoha mai ai ia Mose. ");
INSERT INTO haw1868_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","A lawe oia, a waiho aku la i ke kanawai iloko o ka pahu, a hoonoho i ka noho aloha maluna ma ka pahu. ");
INSERT INTO haw1868_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","A lawe ae la oia i ka pahu iloko o ka halelewa, a kau aku la maluna i ka paku e uhi ai, a uhi ae la i ka pahu kanawai; e like me ka Iehova i kauoha mai ai ia Mose. ");
INSERT INTO haw1868_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","A waiho aku la oia i ka papaaina iloko o ka halelole o ke anaina kanaka, ma ka aoao akau o ka halelewa, mawaho o ka paku. ");
INSERT INTO haw1868_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","A hoonohonoho oia i ka berena maluna olaila, imua o Iehova; e like me ka Iehova i kauoha mai ai ia Mose. ");
INSERT INTO haw1868_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","A kau aku la oia i ka ipukukui manamana maloko o ka halelewa o ke anaina e ka pono ana i ka papaaina, ma ka aoao hema o ka halelewa. ");
INSERT INTO haw1868_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","A hoa iho la oia i na kukui imua o Iehova; e like me ka Iehova i kauoha mai ai ia Mose. ");
INSERT INTO haw1868_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","A waiho aku la oia i ke kuahu gula maloko o ka halelole o ke anaina kanaka, imua o ka paku. ");
INSERT INTO haw1868_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","A puhi iho la oia i ka mea ala maikai maluna olaila; e like me ka Iehova i kanoha mai ai ia Mose. ");
INSERT INTO haw1868_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","A kau aku la oia i ka pale o ka puka o ka halelewa. ");
INSERT INTO haw1868_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","A waiho aku la oia i ke kuahu o ka mohaikuni ma ka puka o ka halelewa o ka halelole o ke anaina kanaka, a kaumaha aku la maluna olaila i ka mohaikuni, a me ka mohaiai; e like me ka Iehova i kauoha mai ai ia Mose. ");
INSERT INTO haw1868_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","A kau aku la oia i ka ipuanau mawaena o ka halelole o ke anaina kanaka, a me ke kuahu, a ninini iho la i ka wai iloko, i mea e holoi ai. ");
INSERT INTO haw1868_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","A holoi no Mose, a me Aarona, a me kana mau keikikane i ko lakou mau lima, a me ko lakou mau wawae malaila. ");
INSERT INTO haw1868_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","A ia lakou i komo ai iloko o ka halelole o ke anaina kanaka, a ia lakou i hookokoke ai i ke kuahu, holoi no lakou; me ka Iehova i kauoha mai ai ia Mose. ");
INSERT INTO haw1868_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","A kukula no hoi oia i ka paku kahuna a puni ka halelewa a me ke kuahu, a kau aku la i ka pale o ka puka o ke kahua; pela o Mose i hoopau ai i ka hana. ");
INSERT INTO haw1868_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Alaila, uhi mai la ke ao i ka halelole o ke anaina kanaka, e hoopiha mai la ka nani o Iehova i ka halelewa. ");
INSERT INTO haw1868_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Aole hiki ia Mose ke komo iloko o ka halelole o ke anaina kanaka, no ka mea, kau mau no ke ao maluna olaila, a hoopiha hoi ka nani o Iehova i ka halelewa. ");
INSERT INTO haw1868_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","A i ka pii ana o ke ao mai ka halelewa aku, alaila, hele aku la na mamo a Iseraela i ko lakou hele ana a pau. ");
INSERT INTO haw1868_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","A i ole e pii aku ke ao, alaila, aole lakou i hele, a hiki i ka la i pii aku ai ia. ");
INSERT INTO haw1868_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","No ka mea, aia no maluna o ka halelewa, ua ao la o Iehova i ke ao, a he ahi hoi maluna olaila i ka po, imua o na maka o ko ka hale a pau o ka Iseraela, i ko lakou hele ana a pau. ");
INSERT INTO haw1868_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","KAHEA mai la o Iehova ia Mose, olelo mai la hoi ia ia mai loko mai o ka halelewa o ke anaina, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","E olelo aku oe i na mamo a Iseraela, e i aku hoi ia lakou, Ina e lawe kekahi kanaka o oukou i ka mohai ia Iehova, no na holoholona e lawe ai oukou i ka oukou mohai, no ka ohana bipi, a no ka ohana hipa, ");
INSERT INTO haw1868_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Ina o kana mohai he mohaikuni noloko o ka ohana bipi, e mohai oia i ke kane kina ole: e mohai aku hoi oia ia no kona makemake iho ma ka puka o ka halelewa o ke anaina, ma ke alo o Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","A e kau ae oia i kona lima maluna o ke poo o ka mohaikuni; a e maliuia nona e hooliloia i kalahala nona. ");
INSERT INTO haw1868_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","A e pepehi oia i ka bipi kane ma ke alo o Iehova; a o lawe mai na kahuna, ka Aarona mau keiki, i ke koko, a e pipi i ke koko a puni maluna iho o ke Kuahu, ka mea ma ka puka o ka halelewa o ke anaina. ");
INSERT INTO haw1868_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","A e lole oia i ka ili o ka mohaikuni, a e okioki i ka mohai i mau apana. ");
INSERT INTO haw1868_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","A e kau ae na keiki a Aarona ke kahuna i ke ahi maluna o ke kuahu, a e kau pono i ka wahie maluna o ke ahi. ");
INSERT INTO haw1868_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","A e kau na kahuna, ka Aarona mau keiki i na apana, i ke poo, a me ke kaikea, a pono maluna o ka wahie ka mea maluna o ke ahi, ka mea maluna o ke kuahu. ");
INSERT INTO haw1868_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Aka e holoi oia i kona naau, a me kona mau wawae, me ka wai; a e kuni ke kahuna i na mea a pau maluna o ke kuahu, i mohaikuni, he inohai i kaumahaia ma ke ahi, he mea ala ono ia Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","A ina no loko o ka ohana o na hipa, a o na kao kona mohai i mohaikuni, e lawe mai oia ia he kane kina ole, ");
INSERT INTO haw1868_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","A e pepehi oia ia ia ma ka aoao kukulu akau ma ke alo o Iehova; a e pipi na kahuna ka Aarona mau keiki i kona koko a puni maluna o ke kuahu. ");
INSERT INTO haw1868_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","A e okioki iho oia i mau apana una me kona poo a me kona konahua: a e kau ke kahuna ia mau mea a pono, maluna o ka wahie, ka mea maluna o ke ahi, ka mea maluna o ke kuahu. ");
INSERT INTO haw1868_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Aka e holoi oia i ka naau, a me kona mau wawae me ka wai; a e lawe pu mai ke kahuna a e kuni maluna iho o ke kuahu: he mohaikuni ia, he mohai i kaumahaia ma ke ahi, he mea ala ono ia Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","A ina no na manu ka mohaikuni kona mohai ia Iehova, alaila e lawe mai oia i kana mohai no na kuhukuku, a i ole ia, no na nunu opiopio. ");
INSERT INTO haw1868_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","A e lawe mai ke kahuna ia i ke kuahu, a e niki i kona poo, a e kuni aku ia ma ke kuahu, a e uwiia kona koko ma ka aoao o ke kuahu. ");
INSERT INTO haw1868_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","A e unuhi ae oia i kona opu a me kona haumia, a e holoi ae ia ma ka aoao o ke kuahu, ma ka hikina, ma kahi o ka lehu. ");
INSERT INTO haw1868_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","A e mahele oia ia ia me kona mau eheu, aole hoi e hookaawale loa; a e kuni ke kahuna ia ma ke kuahu maluna o ka wahie ka mea iluna o ke ahi; he mohaikuni ia, he mohai kaumahaia ma ke ahi, he mea ala ono ia Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","A INA e lawe mai kekahi i ka mohaiai, ia Iehova, o kana mohai auanei he palaoa wali; a e ninini iho oia i ka aila maluna iho, a e kau hoi i ka libano maluna iho. ");
INSERT INTO haw1868_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","A e lawe mai oia ia i ka Aarona mau keiki, i na kahuna; a e lawe ae noloko, a piha kona lima i kona palaoa, a me kona aila me kona libano a pau, a e kuni ke kahuna i kona mea hoomanao, maluna o ke kuahu, i mohai i kaumahaia ma ke ahi, he mea ala ono ia Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","A e lilo ke koena na Aarona, a me kana mau keiki, he mea hoano loa no na mohaipuhi o Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","A ina e lawe mai oe i ka alana o ka mohaiai i kahuia ma ka umu, he mau popo palaoa hu ole i hui pu me ka aila, a i ole ia he mau papa palaoa i hamoia me ka aila. ");
INSERT INTO haw1868_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","A ina o kau alana he mohaiai moa ma ke pa, ka palaoa hu ole no ia i hui me ka aila. ");
INSERT INTO haw1868_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","E wawahi hoi oe i mau apana, a e ninini i ka aila maluna; he mohaiai ia. ");
INSERT INTO haw1868_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","A ina o kau alana he mohaiai moa ma ke paparai, e hanaia ia no ka palaoa a me ka aila. ");
INSERT INTO haw1868_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","A e lawe mai oe i ka mohaiai i hanaia no ia mau mea ia Iehova; a haawiia'e i ke kahuna, e lawe oia ia i ke kuahu. ");
INSERT INTO haw1868_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","A e lawe ke kahuna i ka mea hoomanao mai loko mai o ka mohaiai, a e kuni aku ia mea ma ke kuahu: he mohai ia i alanaia ma ke ahi, he mea ala ono ia Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","A o ke koena o ka mohaiai, e lilo ia no Aarona, a me kana mau keiki; he mea hoano loa no na mohai i kaumahaia ma ke ahi no Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Aole e hanaia me ka hu ka mohaiai a oukou e lawe ai ia Iehova; no ka mea, aole oukou e kuni i ka hu, aole hoi i ka meli, iloko o na mohaipuhi na Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","A o ka alana o na hua mua, e mohai aku no oukou ia mau mea ia Iehova; aole hoi lakou e kuniia ma ke kuahu i mea ala ono. ");
INSERT INTO haw1868_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","A o na alana a pau o kau mau mohaiai, oia kau e hoomiko ai me ka paakai; aole oe e hoonele i kau mau mohaiai i ka paakai o ka berita o kou Akua: me kau mau mohai a pau, e mohai pu oe i ka paakai. ");
INSERT INTO haw1868_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","A ina e mohai aku oe na Iehova i ka mohaiai no kau mau hua mua, o na opuu maka moa ma ke ahi, na hua hohoaia, oia kau e alana ai i mohaiai no kau mau hua mua. ");
INSERT INTO haw1868_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","A e ninini oe i ka aila maluna a me ka libano; he mohaiai no ia. ");
INSERT INTO haw1868_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","A e kuni ke kahuna i ka mea hoomanao ona, o kona hua hohoaia, a o kona aila, a me kona libano a pau, he mohai puhi no Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","A INA o kona alana, he mohaihoomalu, a no na holoholona i kaumaha ai oia ia, ina he kane paha, he wahine paha, e mohai no hoi oia ia mea me ke kina ole imua o Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","A e kau no oia i kona lima maluna o ke poo o kona mohai, a e pepehi iho ia ma ka puka o ka halelewa o ke anaina; a e pipi na kahuna, na keiki a Aarona i ke koko maluna o ke kuahu a puni. ");
INSERT INTO haw1868_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","A e kanmaha aku oia i ka mohaihoomalu, he mohai i kaumahaia ma ke ahi ia Iehova, ka makaupena e uhi ana i ka naau, a me ka nikiniki a pau ma ka naau; ");
INSERT INTO haw1868_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","A o na puupaa elua, a me ke konahua maluna iho o laua, ka mea ma na puhaka, a me ka aa o ke au ma ke akepaa a me na puupaa, oia kana e lawe aku ai. ");
INSERT INTO haw1868_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","A e kuni na keiki a Aarona ia mea ma ke kuahu maluna o ka mohaikuni ma ka wahie, ka mea maluna o ke ahi; he mohai puhi ala ono ia Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","A ina hoi no na ohana kana mohai, he mohaihoomalu ia Iehova, he kane paha, he wahine paha, he mea kina ole hoi kana e kaumaha ai. ");
INSERT INTO haw1868_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","A ina e kanmaha oia i keikihipa he mohai ana, e kaumaha aku hoi oia ia mea ma ke alo o Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","A e kau ae hoi oia i kona lima ma ke poo o kana mohai, a e pepehi hoi oia ia ma ke alo o ka halelewa o ke anaina; a e pipi ae o ka Aarona mau keiki i kona koko ma ke kuahu a puni. ");
INSERT INTO haw1868_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","A e kaumaha aku oia i ka mohaihoomalu, he alana puhi ia Iehova; o kona kaikea a me ka huelo, e lawe ae oia ma ka iwi kuamoo: o ka makaupena e uhi ana i ka naau, a me ka nikiniki a pau ma ka naau, ");
INSERT INTO haw1868_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","A o na puupaa elua, a me ke konahua maluna iho o laua, ka mea ma na puhaka, a me ka aa o ke au ma ke akepaa, a me na puupaa, oia kana e lawe aku ai. ");
INSERT INTO haw1868_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","A e kuni iho ke kahuna ia ma ke kuahu; he ai o ka mohai i kaumahaia ma ke ahi ia Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","A ina he kao kana mohai, alaila e mohai aku oia ia ma ke alo o Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","A e kau ae hoi oia i kona lima ma kona poo, a e pepehi hoi oia ia ma ke alo o ka halelewa o ke anaina; a e pipi ae o ka Aarona mau keiki i kona koko ma ke kuahu a puni. ");
INSERT INTO haw1868_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","No ia mea e alana ai oia i kana mohai, he alana puhi no Iehova; o ka makaupena e uhi ana i ka naau, a me ka nikiniki a pau ma ka naau, ");
INSERT INTO haw1868_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","A o na puupaa elua, a me ke konahua maluna iho o laua, ka mea ma na puhaka, a me ka aa o ke au ma ke akepaa, a me na puupaa, oia kana e lawe aku ai. ");
INSERT INTO haw1868_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","A e kuni iho ke kahuna ia mau mea ma ke kuahu; he ai ia o ka alana puhi no Iehova he mea ala ono. O ke kaikea a pau, no Iehova no ia. ");
INSERT INTO haw1868_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","He kanawai mau keia no ko oukou mau hanauna ma ko oukou mau hale a pau, aole loa oukou e ai i ke kaikea a me ke koko. ");
INSERT INTO haw1868_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","OLELO mai la hoi o Iehova ia Mose, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","E olelo aku oe i na mamo a Iseraela, penei, Ina no ka ike ole e hana hewa kekahi uhane i kekahi kauoha a Iehova, i ka mea pono ole ke hana, a e hana hewa aku i kekahi o ia mau mea: ");
INSERT INTO haw1868_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","Ina e hana hewa ke kahuna i poniia i hewa ai na kanaka: alaila e lawe mai oia no ka hewa ana i hana'i, i ka bipikane opiopio kina ole ia Iehova i mohailawehala. ");
INSERT INTO haw1868_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","A e lawe mai ia i ka bipikane i ka puka o ka halelewa o ke anaina imua o Iehova; a e kau i kona lima ma ke poo o ka bipikane, a e pepehi iho i ka bipikane ma ke alo o Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","A e lalau iho ke kahuna i poniia i ke koko o ka bipikane, a e lawe mai ia i ka puka o ka halelewa. ");
INSERT INTO haw1868_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","A e hoo ke kahuna i kona manamana lima iloko e ke koko, a e pipi i kauwahi o ke koko, i ehiku ka pipi ana ma ke alo o Iehova, mamua o ka paku o ke keenakapu. ");
INSERT INTO haw1868_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","A e kau ke kahuna i kauwahi o ke koko ma na pepeiaohao o ke kuahu mea ala ono, ma ke alo o Iehova, ka mea maloko o ka halelewa o ke anaina; a e ninini iho i ke koko a pau o ka bipikane, malalo o ke kuahu mohaikuni, ka mea ma ka puka o ka halelewa o ke anaina. ");
INSERT INTO haw1868_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","A e lawe nolaila mai i ke kaikea a pau o ka bipikane, i mohailawehala; o ka makaupena e uhi ana i ka naau a me ka nikiniki a pau ma ka naau, ");
INSERT INTO haw1868_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","O na puupaa hoi elua a me ke konahua maluna iho o laua, ka mea ma na puhaka, a me ka aa o ke au ma ke akepaa, me na puupaa, oia kana e lawe aku ai; ");
INSERT INTO haw1868_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","Me ia i laweia'e mai luna ae o ka alana o na mohaihoomalu; a e kuni iho ke kahuna ia mau mea ma ke kuahu mohaikuni. ");
INSERT INTO haw1868_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","A o ka ili o ka bipikane, a me kona io a pau, me kona poo, a me kona mau wawae, a me kona naau, a me kona lepo; ");
INSERT INTO haw1868_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","O ka bipikane hoi a pau, oia kana e lawe aku ai iwaho o kahi e hoomoana'i, i kahi maemae, kahi i nininiia'i ka lehu, a e hoopau iho ia ia maluna o ka wahie me ke ahi; ma kahi i nininiia'i ka lehu e kuniia'i ia. ");
INSERT INTO haw1868_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","A ina e hana hewa ke anaina a pau o Iseraela, no ka ike ole, a i hunaia ia i na maka o ka ahakanaka, a ua hana i kekahi o na kauoha a Iehova, i ka mea pono ole ke hana, a ua hewa; ");
INSERT INTO haw1868_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","A i ka wa e ikeia'i ka hewa a lakou i hana aku ai ia ia, alaila e mohai iho ke anaina i ka bipikane opiopio, no ia hewa, a e lawe mai ia ia i ke alo o ke anaina. ");
INSERT INTO haw1868_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","A e kau na lunakahiko o ke anaina i ko lakou mau lima maluna o ke poo o ka bipikane, imua i ke alo o Iehova; a e pepehi i na bipikane la imua i ke alo o Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","A e lawe mai ke kahuna i poniia i ke koko o ka bipikane i ka halelewa o ke anaina. ");
INSERT INTO haw1868_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","A e hoo iho ke kahuna i kona manamana lima i kauwahi o ke koko, a e pipi aku ia, i ehiku ka pipi ana, ma ke alo o Iehova, imua o ka paku. ");
INSERT INTO haw1868_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","A e kau aku oia i kauwahi o ke koko ma na pepeiaohao o ke kuahu, ka mea ma ke alo o Iehova, ka mea iloko o ka halelewa o ke anaina, a e ninini aku i ke koko a pau malalo o ke kuahu mohaikuni, ka mea ma ka puka o ka halelewa o ke anaina. ");
INSERT INTO haw1868_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","A e lawe oia i ke kaikea a pau mai ona aku, a e kuni iho ma ke kuahu. ");
INSERT INTO haw1868_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","A e hana hoi oia i ka bipikane, me ia i hana aku ai i ka bipikane i mohailawehala, pela no ia e hana'i i keia; a e hana ke kahuna i kala hala no lakou, a e kalaia mai ko lakou hewa. ");
INSERT INTO haw1868_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","A e lawe aku oia i ka bipikane mawaho o kahi e hoomoana'i, a e puhi ia ia, me ia i puhi aku ai i ka bipikane mua; he mohailawehala ia no ke anaina. ");
INSERT INTO haw1868_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Aia hana hewa ke'lii, a no ka ike ole i hana aku ai i kekahi o na kauoha a Iehova kona Akua, i ka mea pono ole ke hana, a na hewa ia; ");
INSERT INTO haw1868_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","A ina i loaa ia ia kona hewa ana i hana'i; e lawe mai no oia i kana mohai he keikikao, he kane kina ole. ");
INSERT INTO haw1868_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","A e kau ae i kona lima maluna o ke poo o ke kao, a e pepehi ia ia ma kahi i pepehi ai lakou i ka mohaikuni imua o Iehova; he mohailawehala ia. ");
INSERT INTO haw1868_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","A e lawe ke kahuna i kauwahi o ke koko o ka mohailawehala me kona manamana lima, a e kau aku hoi ia ma na pepeiaohao o ke kuahu mohaikuni, a e ninini aku i kona koko malalo o ke kuahu mohaikuni. ");
INSERT INTO haw1868_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","A e kuni iho oia i kona kaikea a pau maiuna o ke kuahu, e like me ke kaikea o ka alana o na mohaihoomalu; a e hana ke kahuna i ke kalahala no kona hewa, a e kalaia kona hewa. ");
INSERT INTO haw1868_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","A ina e hana hewa no ka ike ole kekahi o na kanaka i kana hana ana i kekahi o na kauoha a Iehova, i ka mea pono ole ke hana, a ua hewa ia: ");
INSERT INTO haw1868_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","A ina e loaa ia ia kona hewa ana i hana'i; alaila e lawe mai no oia i kana mohai, he keikikao, he wahine kina ole, no kona hewa ana i hana'i. ");
INSERT INTO haw1868_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","A e kau ae oia i kona lima maluna o ke poo o ka mohailawehala, a e pepeni i ka mohailawehala ma kahi o ka mohaikuni. ");
INSERT INTO haw1868_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","A e lawe ke kahuna i kauwahi o kona koko me kona manamana lima, a e kau ae ma na pepeiaohao o ke kuahu mohaikuni, a e ninini aku i kona koko a pau malalo o ke kuahu. ");
INSERT INTO haw1868_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","A e lawe aku oia i kona kaikea a pau, e like me ke kaikea i laweia ku ai mai ka alana o na mohaihoomalu; a e kuni iho ke kahuna ia mea ma ke kuahu i mea ala ono ia Iehova; a e hana ke kahuna i ke kalahala nona, a e kalaia kona hewa. ");
INSERT INTO haw1868_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","A ina i lawe mai oia i ke keikihipa i mohailawehala, e lawe mai hoi oia ia ia he wahine kina ole. ");
INSERT INTO haw1868_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","A e kau oia i kona lima ma ke poo o ka mohailawehala, a e pepehi ia ia i mohailawehala ma kahi i pepehi ai lakou i ka mohaikuni. ");
INSERT INTO haw1868_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","A e lawe ke kahuna i kauwahi o ke koko o ka mohailawehala me kona manamana lima, a e kau ae ma na pepeiaohao o ke kuahu mohaikuni, a e ninini aku i kona koko a pau malalo o ke kuahu. ");
INSERT INTO haw1868_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","A e lawe aku oia i kena kaikea a pau, me ke kaikea o ke keikihipa i laweta'ku ai mai ka alana aku o na mohaihoomalu; a e kuni iho ke kahuna ia ma ke kuahu, e like me na mohai i kaumahaia ma ke ahi ia Iehova: a e hana ke kahuna i ke kalahala nona, no kona hewa ana i hana'i, a e kalaia mai ia. ");
INSERT INTO haw1868_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","A INA e lawehala kekahi uhane, a lohe oia i leo o ka hoohiki ana, a he mea hoike ia, a ua ike paha, ua lohe paha, aole ia e hai, alaila, maluna ona kona hewa. ");
INSERT INTO haw1868_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","A ina e hoopa aku kekahi i ka mea haumia, ina he kupapau o ka holoholona hihiu haumia, a ina he kupapau o na holoholona laka haumia, a ina he kinomake o na mea kolo, a i nalo ia ia; e haumia no hoi ia, a hewa. ");
INSERT INTO haw1868_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","A ina e hoopa aku oia i ka haumia o ke kanaka, i kela haumia a i keia i haumia ai ia, a i nalo ia ia; aia ike oia, alaila hewa ia. ");
INSERT INTO haw1868_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","A ina e hoohiki kekahi e olelo walewale ana me kona lehelehe e hana hewa paha, a e hana pono paha, o ka mea a ke kanaka i olelo ai me ka hoohiki i ke Akua, a nalo ia ia ia; a loaa ia ia, a ua hewa ia i kekahi o ia mau mea. ");
INSERT INTO haw1868_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","A penei keia, i ka wa e hewa ai ia i kekahi o ia mau mea, alaila e hai mai ia, ua hana hewa oia ia mea. ");
INSERT INTO haw1868_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","A e lawe mai oia i kana mohaihala ia Iehova no kona hewa ana i hana'i, he wahine no ka ohana, he keikihipa, a i ole ia, he keikikao, i mohaihala; a e hana ke kahuna i ke kalahala nona no kona hewa. ");
INSERT INTO haw1868_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","A ina aole e hiki i kona lima ke lawe mai i ke keiki holoholona, alaila e lawe mai oia no kona hewa ana i hana'i, i elua mau kuhukuku, a i ole ia, elua manu nunu opiopio ia Iehova, i kekahi i mohailawehala, a i kekahi hoi i mohaikuni. ");
INSERT INTO haw1868_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","A e lawe mai oia ia mau mea i ke kahuna, a e alana mua oia i ka mea mohailawehala, a e niki oia i kona poo mai kona a-i, aole hoi e mahele a kaawale. ");
INSERT INTO haw1868_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","A e pipi ae oia i kauwahi o ke koko o ka mohailawehala ma ka aoao o ke kuahu; a e uwiia'e ke koena o ke koko malalo o ke kuahu: he mohailawehala ia. ");
INSERT INTO haw1868_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","A e alana sku oia i ka Iua i mohaikuni mamuli o ke kanawai; ae hana ke kahuna i kalahala nona, no ka hewa ana i hana'i, a e kalaia uanei oia. ");
INSERT INTO haw1868_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","A i ole e hiki i kona lima ke lawe mai i eloa manu kuhukuku, a i elua manu nunu opiopio paha, alaila, e lawe mai ka mea i hana hewa i mohai nons i ka hapaumi o ka epa palaoa wali i mohailawehala; aole e kau oia i ka aila maluna iho o ia mea, aole hoi ia e kau i ka libano ma ia mea, no ka mea, he mohailawehala ia. ");
INSERT INTO haw1868_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","A e lawe mai oia ia mea i ke kahuna, a e lalau iho ke kahuna a piha kona lima ia mea i mea hoomanao nona, a e kuni iho ma ke kuahu, e like me na mohaipuhi ia Iehova; he mohailawehala ia. ");
INSERT INTO haw1868_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","A e hana ke kahuna nona i kalahala no kona hewa ana i hana'i, ma kekahi o na mau mea la, a e kalaia nona; a e lilo ia na ke kahuna he mohaiai. ");
INSERT INTO haw1868_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Olelo mai la hoi o Iehova ia Mose, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","Ina e hana kekahi i ka hewa, a lawehala no ka ike ole, ma na mea hoano o Iehova, alaila e lawe mai oia ia Iehova no kona hewa, i ka hipakane kina ole noloko mai o na ohana, me ka mea au i manao ai ma na sekela kala, mamuli o ke sekela o ke keenakapu, i mohaihala. ");
INSERT INTO haw1868_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","A e hooponopono oia no ka hewa ana i hana'i ma ka mea hoano, a e hui hou i ka hapa lima ona ilaila, a e haawi aku oia ia mea i ke kahuna; a e hoolilo ke kahuna i ka hipakane mohaihala i kalahala nona, a e kalaia no ia. ");
INSERT INTO haw1868_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","A ina e lawehala kekahi, a e hana i kekahi o ia mau mea i papaia ma na kauoha a Iehova, aole hoi i ike, e hihia no ia, a e kau no ia ia kona hewa. ");
INSERT INTO haw1868_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","A e lawe mai oia i ka hipakane kina ole noloko mai o ka ohana, me ka mea au i manao ai, i ke kahuna i mohaihala; a e hana ke kahuna i kalahala nona, no kona ike ole i hewa ai a ike ole hoi, a e kalaia no ia. ");
INSERT INTO haw1868_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","He mohaihala no ia: ua lawehala io no ia i ka Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","OLELO mai la hoi o Iehova ia Mose i mai la, ");
INSERT INTO haw1868_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","Ina e lawehala kekahi uhane a e hana hewa ia Iehova, a e hoopunipuni i kona hoalauna i ka mea i haawiia ia ia e malama, a i ka hoolimalima paha, a i ka mea kaili wale ia paha, a na hoopunipuni oia i kona hoalauna; ");
INSERT INTO haw1868_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","A ina i loaa ia ia kekahi mea haule, a hoopunipuni oia no ia mea, a hoohiki wahahee hoi; i kahi o neia mau mea a pau a ke kanaka i hana'i, a hewa ilaila: ");
INSERT INTO haw1868_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","Penei hoi ia, no ka mea ua lawehala ia, a ua hewa, e hoihoi aku no ia i ka mea ana e kaili wale ai, a i ka mea i loaa ia ia ma ka wahahee, a i ka mea i haawiia ia ia e malama, a i ka mea haute paha i loaa ia ia; ");
INSERT INTO haw1868_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","A i kela mea keia mea ana i hoohiki wahahee ai, e hoihoi okoa aku no oia ia i kona kino, a e hui i ka hapa lima hou me ia, a e haawi aku i ka mea nana ia, i ka la o kona mohaihala. ");
INSERT INTO haw1868_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","A e lawe mai oia i kona mohaihala ia Iehova, he hipakane kina ole noloko mai o ka ohana, me kau mea i manao ai, i mohaihala, i ke kahuna. ");
INSERT INTO haw1868_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","A e hana ke kahuna i kalahala nona, ma ke alo o Iehova, a e kalaia no ia, no ka mea ana i hana'i, i ka mea i hewa'i. ");
INSERT INTO haw1868_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Olelo mai la o Iehova ia Mose, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","E kauoha ia Aarona a me kana mau keiki, e i aku, Eia ke kanawai o ka mohaikuni; he mohaikuni no ia no ka aa ana o ke ahi ma ke kuahu a pau ka po, a kakahiaka, e aa ana hoi ke ahi kuahu ilaila. ");
INSERT INTO haw1868_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","E komo hoi ke kahuna i kona kapa olona, a komo no kona lole wawae olona i kona io, a e hao ia i ka lehu i pau i ke ahi me ka mohai, maluna o ke kuahu, a e waiho iho ma ka aoao o ke kuahu. ");
INSERT INTO haw1868_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","A e hemo ia ia koua mau kapa, a e komo hou i kekahi mau kapa okoa, a e lawe aku i ka lehu mawaho o kahi hoomoana'i a kahi maemae. ");
INSERT INTO haw1868_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","A o ke ahi maluna o ke kuahu e aa mau no ia malaila, aole e kinaiia ia; a e puhi ke kahuna i ka wahie maluna, i kela kakahiaka i keia kakahiaka, a e kau pono i ka mohaikuni maluna ona; a e kuni hoi oia maluna iho i ka momona o na mohaihoomalu. ");
INSERT INTO haw1868_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","E aa mau no ke ahi ma ke kuahu, aole loa e pio. ");
INSERT INTO haw1868_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Eia hoi ke kanawai o ka mohaiai; e mohai aku no na keiki a Aarona ia ma ke alo o Iehova imua o ke kuahu. ");
INSERT INTO haw1868_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","A e lalau oia a piha kona lima i ka palaoa o ka mohaiai a i kona aila, a i kona libano a pau e kau ana maluna o ka mohaiai, a e kuni aku hoi ia he mea ala ono, o kona mea hoomanao ia Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","A o ke koena o ia mea, na Aarona ia a me kana mau keiki e ai: me ka berena hu ole e aiia'i ia ma kahi hoano; ma ka pa o ka halelewa o ke anaina e ai ai lakou ia mea. ");
INSERT INTO haw1868_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Aole ia e moa me ka hu: ua haawi aku wau ia he kuleana no lakou noloko o kuu mau mahaipuhi; he mea hoano loa, e like me ka mohailawehala a me ka mohaihala. ");
INSERT INTO haw1868_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","E ai na kane o ka Aarona mau keiki a pau ia mea: he kanawai mau ia i ko oukou hanauna, no na mohaipuhi ia Iehova; o ka mea e hoopa ia mau mea, e hoano ia. ");
INSERT INTO haw1868_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Olelo mai la hoi o Iehova ia Mose, i mai la; ");
INSERT INTO haw1868_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","Eia ka mohai a Aarona a me kana mau keiki, a lakou e mohai aku ai ia Iehova i ka la i poniia'i oia, o ka hapaumi o ka epa palaoa wali, e mohai mau ai, o ka hapalua ona i ke kakahiaka, a o ka hapalua ona i ke ahiahi. ");
INSERT INTO haw1868_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Ma ke pa e hanaia'i ia me ka aila; a moa, e lawe mai oe ia, a o na apana moa, o ka mohaiai kau e mohai ai i mea ala ono ia Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","A o ke kahuna no na keiki mai ana i poniia no kona wahi, oia ka mea nana ia e mohai aku: ke kanawai mau ia no Iehova, e pau loa ia i ke ahi. ");
INSERT INTO haw1868_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","O na mohaiai a pau no ke kahuna e pau no ia i ke ahi; aole e aiia. ");
INSERT INTO haw1868_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","A ua olelo mai la o Iehova ia Mose, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","E olelo aku oe ia Aarona a me kana mau keiki, penei, Eia ke kanawai o ka mohailawehala; ma kahi i pepehiia'i ka mohaikuni, malaila e pepehiia'i ka mohailawehala, ma ke alo o Iehova; he mea hoano loa ia. ");
INSERT INTO haw1868_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","O ke kahuna nana ia i mohai aku, oia ke ai ia mea; ma kahi hoano no ia e aiia'i, maloko o ka pa o ka halelewa o ke anaina. ");
INSERT INTO haw1868_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","O ka mea nana e hoopa aku i ka io ona, e hoano no ia: a ina e pipiia ke koko ona ma ke kapakomo, e holoi ae oe i ka mem i pipiia'i ia, ma kahi hoano. ");
INSERT INTO haw1868_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Aka o ka ipu lepo i hoolapalapaia'i ia, e wawahiia ia; a ina he ipu keleawe i hoolapalapaia'i ia, alaila e anaiia ia a e holoiia me ka wai. ");
INSERT INTO haw1868_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","E ai na kane a pau iwaena o na kahuna ia mea; he mea hoano loa no ia. ");
INSERT INTO haw1868_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","A o ka mohailawehala, i laweia kona koko iloko o ka halelewa o ke anaina, e hoolaulea ma kahi hoano, aole ia e aiia, e hoopauia ia i ke ahi. ");
INSERT INTO haw1868_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","EIA hoi ke kanawai o ka mohaihala: he hoano loa ia. ");
INSERT INTO haw1868_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Ma kahi e pepehi ai lakou i ka mohaikuni, malaila no e pepehi ai lakou i ka mohaihala, a e pipi i ke koko ona maluna o ke kuahu a puni. ");
INSERT INTO haw1868_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","A e mohai aku oia i kona kaikea a pau; o ka huelo, a me ka nikiniki maluna o ka naau, ");
INSERT INTO haw1868_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","A o na puupaa elua, a me ke konahua maluna o laua, ka mea ma ka puhaka, a me ka aa o ke au ma ke akepaa, me na puupaa, oia kana e lawe ai: ");
INSERT INTO haw1868_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","A e kuni aku ke kahuna ia mau mea, maluna o ke kuahu, he mohai kanmahaia ma ke ahi ia Iehova; he mohaihala ia. ");
INSERT INTO haw1868_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","A e ai na kane a pau iwaena o na kahuna ia mea; e aiia ma kahi hoano; he mea hoano loa ia. ");
INSERT INTO haw1868_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","E like me ka mohailawehala, pela no ka mohaihala, he kanawai hookahi no ia mau mea; e lilo no ia i ke kahuna, nana ia e hoolilo i kalahala. ");
INSERT INTO haw1868_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","A o ke kahuna nana i mohai aku i ka mohaikuni o kekahi kanaka, e lilo nona ka ili o ka mohaikuni ana i mohai ai. ");
INSERT INTO haw1868_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","A o kamohaiai apau i moa i ka umu, a i moa i ko paparai, a me ke pa, e lilo no ia na ke kahuna nana ia i mohai aku. ");
INSERT INTO haw1868_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","A o na mohaiai a pau i huiia me ka aila, a maloo, e lilo na na keiki a pau a Aarona e like ka kekahi me ka kekahi. ");
INSERT INTO haw1868_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Eia hoi ke kanawai o ka alaila o na mohaihoomalu ana e mohai aku ai ia Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","A ma e mohai oia ia i mea e hoomaikai ai, alaila, e mohai aku oia me ka alana hoomaikai i na popopalaoa hn ole i huiia me ka aila, a me na papapalaoa hu ole i hamoia me ka aila, a me na popopalaoa i huiia me ka aila, no ka palaoa wali i paraiia. ");
INSERT INTO haw1868_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","A he mea e ae kana e mohaiai he mohai nana, o ka berena hu me ka alana hoomaikai no kana mau mohaihoomalu. ");
INSERT INTO haw1868_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","A noloko o ia mea e mohai aku ai ia i hookahi no ka mohai okoa, i mohai hoali ia Iehova; a e lilo ia na ke kahuna nana i pipi i ke koko o na mohaihoomalu. ");
INSERT INTO haw1868_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","A o ka io o ka alana, o kana mau mohaihoomalu no ka hoomaikai, e aiia ia i ka la i mohaiia'i ia; aole oia e hookoe i kauwahi a kakahiaka. ");
INSERT INTO haw1868_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Aka, ina he mea hoohiki paha, a he mohai haawi wale, ka alana o kona mohai, e aiia ia i ka la i mohai aku ai oia i kana mohai; a ia la ae, aiia'i kolaila koena. ");
INSERT INTO haw1868_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Aka o ke koena o ka io o ka alana, i ke kolu o ka la, e hoopauia ia i ke ahi. ");
INSERT INTO haw1868_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","A ina e aiia kauwahi o ka io o ka alana o kana mau mohaihoomalu, i ke kolu o ka la, aole ia e maliuia mai, aole hoi e heluia ia na ka mea nana ia e mohai aku; e lilo ia i mea e hoowahawahaia, a o ka mea nana e ai ia mea, o kau maluna ona kona hewa. ");
INSERT INTO haw1868_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","A o ka io i pili i ka mea maemae ole, aole ia e aiia, e hoopauia oia i ke ahi. A o ka io hoi, e ai ka poe maemae a pau i ka io. ");
INSERT INTO haw1868_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Aka o ka mea nana e ai i ka io o ka alana o na mohaihoomalu, na mea o Iehova, e kau ana kona haumia maluna ona, e okiia'ku ia mai kona poe kanaka aku. ");
INSERT INTO haw1868_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","A o ke kanaka nana e hoopa aku i ka mea haumia, i ka haumia paha o ke kanaka, a i ka holoholona haumia, a i kekahi mea haumia e hoowahawahaia, a e ai hoi i ka io o ka alana o na mohaihoomalu, na mea o Iehova, e okiia'ku oia mai kona poe kanaka aku. ");
INSERT INTO haw1868_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Olelo mai la hoi o Iehova ia Mose, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","E olelo aku oe i na mamo a Iseraela, penei, Mai ai oukou i ke kaikea o ka bipi kauo, a o ka hipa, a o ke kao. ");
INSERT INTO haw1868_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","A o ke kaikea o ka holoholona make wale, a o ke kaikea o ka mea i haehaeia e na holoholona, e pono ia i ka kela mea keia mea e ae, aole loa hoi oukou e ai ia mea. ");
INSERT INTO haw1868_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","A o ka mea nana e ai i ko kaikea o ka holoholona a na kanaka i kaumaha ai i ka mohai ma ke ahi ia Iehova, o ka mea i ai ia mea, oia ke okiia'ku mai kona poo kanaka aku. ");
INSERT INTO haw1868_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Aole hoi oukou e ai i ko koko, o ke koko o ka manu, a o ka holoholona, iloko o kahi o ko oukou mau hale. ");
INSERT INTO haw1868_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","O ke kanaka i ai i ke koko, oia ke okiia'ku mai kona poe kanaka aku. ");
INSERT INTO haw1868_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Olelo mai la hoi o Iehova ia Mose, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","E olelo aku oe i na mamo a Iseraela, penei, O ka mea mohai i ka alana o kana mau mohaihoomalu ia Iehova, e lawe mai oia i kana mohai ia Iehova noloko o ka alana o kana mau mohaihoomalu. ");
INSERT INTO haw1868_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Na kona mau lima no e lawe mai i na mohai o Iehova i kaumahaia ma ke ahi, o ke kaikea me ka umauma, oia kana e lawe mai ai, i hooluliia ka umauma i mohaihoali ma ke alo o Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","A e kuni ke kahuna i ke kai kea maluna o ke kuahu; a e lilo ka umauma na Aaroua a me kana mau keiki. ");
INSERT INTO haw1868_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","A o ka uha mua akau, oia ka oukou e haawi aku ai i ke kahuna i mohaihoali, noloko o na alana o na mohaihoomalu a oukou. ");
INSERT INTO haw1868_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","O kekahi o ka Aarona mau keiki nana e mohai aku i ke koko o na mohaihoomalu a me ke kaikea, e lilo nana ka nha mua akau i kuleana nona. ");
INSERT INTO haw1868_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","No ka mea, o ka umauma luli, a me ka uha hoali, oia ka'u i lawe ai mai na mamo a Iseraela, noluna mai hoi o na alana o ka lakou mau mohaihoomalu, a na haawi hoi aa ia mau mea ia Aarona ke kahuna, a i kana mau keiki; he kanawai mau iwaena o na mamo a Iseraela, ");
INSERT INTO haw1868_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Oia hoi ko ka poni ana o Aarona, a me ko ka pom ana o kana mau keiki noloko mai o na mohai o Iehova i kanmahaia ma ke ahi, i ka la i haawi ai oia ia lakou e lawelawe imua o Iehova ma ka oihanakahuna; ");
INSERT INTO haw1868_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","O ka mea a Iehova i kanoha mai ai e haawiia na lakou ko na mamo a Iseraela, i ka la i poni ai oia ia lakou, he kanawai mau no ko lakou mau hanauna. ");
INSERT INTO haw1868_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Oia ka kanawai o ka mohaikuni, o ka mohaiai, a o ka mohailawehala, a me ka mohaihala, a o na mohai poni, a me ka alana o na mohaihoomalu; ");
INSERT INTO haw1868_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Ka mea a Iehova i kanoha mai ai ia Mose ma ka mauna Sinai, i ka la i kanoha mai ai oia i na mamo a Iseraela e kanmaha lakou i ko lakou mau mohai ia Iehova, ma ka waonahele o Sinai. ");
INSERT INTO haw1868_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","OLELO mai la hoi o Iehova ia Mose, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","E lawe oe ia Aarona a me kana mau keiki pu, a me na kapa komo, a me ka aila poni, a me ka bipikane i mohailawehala, a me na hipakane elua, a me ka hinai berena hu ole. ");
INSERT INTO haw1868_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","A e hoakoakoa oe i ke anaina a pau ma ka puka o ka halelewa o ke anaina. ");
INSERT INTO haw1868_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Hana iho la o Mose e like me ka Iehova i kanoha mai ai ia ia; a ua hoakoakoaia ka ahakaoaka i ka puka o ka halelewa o ke anaina. ");
INSERT INTO haw1868_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","I aku la o Mose i ke anaina, Eia ka mea a Iehova i kauoha mai. ");
INSERT INTO haw1868_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","A lawe mai la o Mose ia Aarona a me kana mau keiki, a holoi ae la ia lakou i ka wai. ");
INSERT INTO haw1868_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","A hookomo aku la oia i ke kapa komo ia ia, a kaei ae la ia ia i ke Kaei, a hoaahu ia ia i ka aahu, a kau hoi i ka epoda maluna ona, a kaei ae la ia ia i ke kaei onionio o ka epoda, a hoopili aku la ia mea ia ia. ");
INSERT INTO haw1868_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","A kau iho la hoi oia maluna ona i ka palenmanma; a kau hoi i ka Urima a me ke Tumima ma ka paleumanma. ");
INSERT INTO haw1868_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","A kau aku la hoi i papale kahuna ma kona poo; a ma ka papale kahuna, ma ke alo pono i kau ai oia i ka papa gula, ka lei hoano, e like me ka mea a Iehova i kanoha mai ai ia Mose. ");
INSERT INTO haw1868_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Lawe iho la hoi o Mose i ka ai la poni, a poni aku la i ka halelewa, a me na mea a pau oloko, a hoolaa ae la ia mau mea. ");
INSERT INTO haw1868_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","A pipi iho la oia i kanwahi o ia mea ma ke kuahu, ehiku ka pipi ana, a poni hoi ia i ke kuahn a me kana mau ipn a pau, ka ipu holoi a me kona wawae, a hoolaa ae la ia mau mea. ");
INSERT INTO haw1868_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Niumi iho la hoi oia i kanwahi o ka aila pom ma ke poo o Aarona, a poni iho la ia ia e hoano ia ia. ");
INSERT INTO haw1868_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","A lawe mai la hoi o Mose i na keiki a Aarona, a hookomo i na kapa komo ia lakou, a kaei ae la hoi ia lakou i na kaei, a kau aku la hoi i na papale maluna o lakou, e like me ke kanoha a Iehova ia Mose, ");
INSERT INTO haw1868_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Lawe mai la hoi oia i ka bipikane i mohailawehala; a kau aku la o Aarona a me kana mau keiki i ko lakou mau lima maluna o ke poo o ka hipikane i mohaihala. ");
INSERT INTO haw1868_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","A pepehi ae la oia, a lawe hoi o Mose i ke koko, a kau aku hoi ma na pepeiaohao o ke knahn puni, me kona manamanalima, a hoomaemae ae la ke kuahu; a ninini iho la i ke koko malalo o ke kuahu, e hana i kalahala malun a ona. ");
INSERT INTO haw1868_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Lawe iho la oia i ke kaikea a pau maluna o ka nsau, a me ka aa o ke au ma ke akepaa, a me na puupaa elua, a me ko laua mau konahua, a kuni iho la o Mose ma ke kuahn. ");
INSERT INTO haw1868_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Aka o ka bipikane, a me kona ili, a me kona io, a me kona lepo, oia kana i hoopau ai i ke ahi mawaho o kahi e hooraoana'i, e like me ke kanoha a Iehova ia Mose. ");
INSERT INTO haw1868_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Lawe mai la hoi oia i ka hipakano i mohaikuni; a kau ae la o Aarona, a me kana mau keiki i ko lakou mau lima maluna o ke poo o ka hipakano. ");
INSERT INTO haw1868_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Pepehi iho la oia, a pipi ae la hoi o Mose i ke koko maluna o ke kuahu a puni. ");
INSERT INTO haw1868_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Okioki ae la hoi oia i ka hipakano i mau apana; a puhi ae la hoi o Mose i ko poo, a mo na apana, a mo ko kaikea. ");
INSERT INTO haw1868_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Holoi ae la hoi oia i ka naau a me na wawae i ka wai; a puhi ae la o Mose i ka hipakane okoa ma ke kuahu; he mohaikuni ia, he mea ala ono, he mohai i kaumahaia ma ke ahi ia Iehova, e like me ka Iehova kauoha ia Mose. ");
INSERT INTO haw1868_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Lawe mai la hoi oia i ka lua o ka hipakane, ka hipakane no ka hoolaa ana; a kau aku la o Aarona a me kana mau keiki i ko lakou mau lima maluna o ke poo o ka hipakane. ");
INSERT INTO haw1868_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Pepehi ae la hoi oia, a lawe hoi o Mose i kauwahi o kona koko, a kau aku la ma ke kihi o ko Aarona pepeiao akau, a ma ka manamananui o kona lima akau, a ma ka manamananui o kona kapuwakakau. ");
INSERT INTO haw1868_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Lawe mai la hoi oia i ka Aarona mau keiki, a kau aku la o Mose i ko koko ma ke kihi o ko lakou pepeiao akau, a ma na manamananui o ko lakou mau lima akau, a ma na manamananui o ko lakou mau kapuwai akau; a pipi ae la o Mose i ke koko ma ke kuahu a puni. ");
INSERT INTO haw1868_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Lawe ae la hoi oia i ke kaikea, a mo ka huelo, a me ka nikiniki ma ka naau, a me ka aa o ke au ma ke akepaa, a me na pnupaa elua, a me ko laua konahua, a me ka uha mua akau. ");
INSERT INTO haw1868_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","A mailoko mai o ka hinai berena hu ole, imua o Iehova, lawe ae la oia i hookahi poponalaoa hu ole a me ka popoberena i hamoia i ka aila, a me ka papaberena hookahi, a kau ae la hoi maluna o ko kaikea a me ka uha mua akau. ");
INSERT INTO haw1868_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","A kau okoa ae la oia ia maluna o ko Aarona mau lima, a ma na lima o kana mau keiki, a hooluli ae ia mau mea i mohaihoali imua o Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Lawe ae la hoi o Mose ia mau mea mai luna ae o ko lakou mau lima, a kuni ae la maluna o ke kuahu maluna o ka mohaikuni; he mau mea hoolaaia i mea ala ono, he mohai i kaumahaia ma ke ahi ia Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Lawe ae la hoi o Mose i ka umauma, a hooluli ae i mohaihoali ma ke alo o Iehova; o ko Mose kuleana ia o ka hipakane no ka hoolaa ana, e like me ka Iehova kauoha ia Mose. ");
INSERT INTO haw1868_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Lawe ae la hoi o Mose i kau wahi o ka aila poni, a o ke koko ka mea maluna o ke kuahu, a pipi ae la maluna o Aarona, a ma kona mau kapa, a me kana mau keiki, a ma na kapa o kana mau keiki pu me ia; a ua hoolaa aku ia Aarona, a me kona mau kapa, a me kana mau keiki a mo na kapa o kana mau keiki me ia. ");
INSERT INTO haw1868_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","I aku la o Mose ia Aarona a i kana mau keiki, E hoolapalapa i ka io ma ka puka o ka halelewa o ke anaina; a malaila hoi e ai ai ia me ka berena oloko o ka hinai o na mea hoolaaia, me au hoi i kauoha ai e olelo ana, E ai o Aarona a me kana mau keiki ia mea. ");
INSERT INTO haw1868_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","A o ke koena o ka io, a me ka berena, oia ka oukou e hoopau ai i ke ahi. ");
INSERT INTO haw1868_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Aole oukou e pnka ae ma ka puka o ka halelewa o ke anaina i na la ehiku, a pau na la o ko oukou hoolaa ana; no ka mea, e hoolaa oia ia oukou i na la ehiku. ");
INSERT INTO haw1868_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Me ia i hana'i i keia la, pela no Iehova i kauoha mai ai o hana, e hana i kalahala no oukou. ");
INSERT INTO haw1868_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Nolaila e noho ai oukou ma ka puka o ka halelewa o ke anaina i ke ao, i ka po, i na la ehiku, a e malama ke kauoha a Iehova, i ole ai oukou o make; no ka mea, pela no wau i kauohaia mai ai. ");
INSERT INTO haw1868_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Pela i hana'i o Aarona a me kana mau keiki i na mea a pau a Iehova i kauoha mai ai ma ka lima o Mose. ");
INSERT INTO haw1868_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","EIA hoi kekahi, i ka walu o ka la, hea ae la o Mose ia Aarona a me kana mau keiki a me na luna kahiko o ka Iseraela; ");
INSERT INTO haw1868_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Olelo ae la oia la Aarona, E lawe oe i ke keikibipi opiopio i mohailawehala, a me ka hipakane i mohaikuni, he kina ole, a e mohai aka ma ke alo o Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","A e olelo aka oe i na mamo a Iseraela, penei, E lawe oukou i ke keikikao i mohailawehala; a me ke keikibipi a me ke keikihipa, na mea o ka makahiki hookahi, me ke kina ole, i mohaikuni; ");
INSERT INTO haw1868_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","A me ka bipikane a me ka hipakane i mau mohaihoomalu, e mohai aku ma ke alo o Iehova, a me ka mohaiai i huiia me ka aila; no ka mea, i keia la e ikeia'i o Iehova e oukou. ");
INSERT INTO haw1868_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","A lawe mai la lakou i ka mea a Mose i kauoha ai, ma ke alo o ka halelewa o ke anaina; a hookokoke mai la ke anaina a pau, a kukulu ae la imua o Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","I ae la o Mose, Eia ka mea a Iehova i kauoha mai ai e hana oukou; a e ikeia ka nani o Iehova e oukou. ");
INSERT INTO haw1868_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Olelo aku la hoi o Mose ia Aarona, E hele oe i ke kuahu, a e kanmaha aku i kau mohailawehala, a me kau mohaikuni, a e hana i kalahala nou iho, a no na kanaka; a e alana aku i ka mohai a na kanaka, a e hana i kalahala no lakou, e like me ka Iehova kauoha, ");
INSERT INTO haw1868_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Nolaila, hele ae la o Aarona i ke kuahu, a pepehi iho la i ke keikibipi mohailawehala, ka mea nona iho. ");
INSERT INTO haw1868_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Lawe mai la hoi ka Aarona mau keiki i ke koko io na la; a hoo iho oia i kona manamanalima iloko o ke koko, a kau aku la ma na pepeiaohao o ke kuahu, a ninini iho la i ke koko malalo o ke kuahu. ");
INSERT INTO haw1868_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Aka o ke kaikea a me na puupaa, a me ka aa o ke au ma ke akepaa, o ka mohailawehala, oia kana i kuni ai ma ke kuahu, e like me ka Iehova kaaoha ia Mose. ");
INSERT INTO haw1868_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","A ua puhi oia i ka io a me ka ili me ke am mawaho o kahi e hoomoana'i. ");
INSERT INTO haw1868_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Pepehi ae la ia i ka mohaikuni, a haawi ka Aarona mau keiki i ke koko ia ia, a pipi oia ia ma ke kuahu a puni. ");
INSERT INTO haw1868_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Haawi ae la hoi lakou i ka mohaikuni ia ia, me na apana a me ke poo; a puhi ae la hoi oia ma ke kuahu. ");
INSERT INTO haw1868_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Holoi ae la oia i ka naau a me na wawae, a puhi ae la hoi maluna o ka mohaikuni ma ke kuahu. ");
INSERT INTO haw1868_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Lawe mai la hoi oia i ka mohai a na kanaka, a lalau ae la i ke kao, i ka mohailawehala no na kanaka, a pepehi ae la ia mea, a kaumaha aku la hoi ia no ka hewa, e like me ka mua. ");
INSERT INTO haw1868_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Lawe mai la hoi oia i ka mohaikuni, a kanmaha aku la ia e like me ke kanawai. ");
INSERT INTO haw1868_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Lawe mai la hoi oia i ka mohaiai, e hoopiha i kona lima ia mea, a puhi ae la ma ke kuahu, okoa ka mohaikuni o ke kakahiaka. ");
INSERT INTO haw1868_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Pepehi ae la hoi oia i ka bipikane, a me ka hipakane, i alana no na mohaihoomalu, ka mea no na kanaka; a haawi ae la ka Aarona mau keiki i ke koko ia ia, a pipi ae ia oia ia mea ma ke kuahu a puni, ");
INSERT INTO haw1868_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","A i ke kaikea o ka bipikane a me ka hipakane, a me ka huelo, a me ka makaupena, a me na puupaa, a me ka aa o ke au ma ke akepaa: ");
INSERT INTO haw1868_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","Kau aku la hoi lakou i ke kaikea maluna o na umauma, a kuni ae la oia i ke kaikea ma ke kuahu; ");
INSERT INTO haw1868_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","A hooluli ae la hoi o Aarona i ka umauma a me ka uha mua akau i mohaihoali ma ke alo o Iehova, e like me ka Mose kauoha. ");
INSERT INTO haw1868_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Hohola ae la hoi o Aarona i kona mau lima i na kanaka, a hoomaikai aku la ia lakou; a iho mai la hoi mai ke kaumaha ana i ka mohailawehala; a me ka mohaikuni, a me na mohaihoomalu. ");
INSERT INTO haw1868_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Komo aku la hoi o Mose me Aarona i ka halelewa o ke anaina, a puka mai la hoi laua, a hoomaikai aku la i na kanaka; a ikeia aku la ka nani o Iehova e ka poe kanaka a pau. ");
INSERT INTO haw1868_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Puka mai la hoi ke ahi mai ke alo mai o Iehova, a hoopau iho la i ka mohaikuni a me ke kaikea maluna o ke kuahu; a ike ka poe kanaka a pau ia, hooho ae la lakou a moe iho la ilalo ke alo. ");
INSERT INTO haw1868_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","LALAU iho la hoi, ka Aarona mau keiki o Nadaha a me Abihu, i ko laua mau ipuahi, a hahao ae la i ke ahi maloko, a kau hoi i ka mea ala maluna iho, a mohai aku la i ke ahi o ma ke alo o Iehova ka mea ana i kauoha ole ai ia laua. ");
INSERT INTO haw1868_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Puka mai la hoi ke ahi mai ke alo mai o Iehova, a ai iho la ia laua, a make iho la laua imua o Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Alaila olelo ae la o Mose ia Aarona, O ka mea keia a Iehova i olelo mai ai, i ka i ana, E hoanoia mai no wau e ka poe e hookokoke mai io'u nei, a e hoonaniia mai hoi au ma ke alo o na kanaka a pau. A hakanu iho la o Aarona. ");
INSERT INTO haw1868_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Kahea ae la hoi o Mose ia Misaela, a me Elezapana, na keiki a Uziela, ka hoahanau o ko Aarona makua, i aku la hoi ia laua, E hookokoke mai, o lawe aku i ko olua mau hoahanau mai ke alo aku o ke keenakapu, mawaho o kahi e hoomoana ai. ");
INSERT INTO haw1868_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Hookokoke ae la hoi laua, a halihali ae la ia laua iloko o ko laua mau kapa mawaho o kahi e hoomoana'i, e like me ka Mose olelo. ");
INSERT INTO haw1868_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Olelo aku la hoi o Mose ia Aarona, a me Eleazara, a me Itamara, kana mau keiki, Mai wehe ae i ko oukou mau poo, aole hoi e uhae i ko oukou mau kapa, o make oukou, a kau mai ka inaina maluna o ka poe kanaka a pau; aka e uwe ko oukou poe hoahanau, ka ohana a pau o Iseraela, i ka aa ana a Iehova i kuni iho ai. ");
INSERT INTO haw1868_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Aole hoi oukou e hele mawaho o ka puka o ka halelewa o ke anaina, o make oukou; no ka mea, maluna o oukou ka aila poni o Iehova. A hana iho la lakou e like me ka olelo a Mose. ");
INSERT INTO haw1868_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","A olelo mai la o Iehova ia Aarona, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","Mai inu i ka waina a me ka mea ona, o oe a me kau mau keiki me oe, i ka wa e hele ai oukou iloko o ka halelewa o ke anaina, o make oukou: he kanawai mau no ia i na hanauna o oukou; ");
INSERT INTO haw1868_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","I hiki hoi ia oukou ke hookaawale iwaena o ka hoano, a me ka hoano ole, a iwaena o ka haumia a me ka maemae; ");
INSERT INTO haw1868_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","A e ao aku hoi oukou i na mamo a Iseraela, i na kanawai a pau a Iehova i olelo mai ai ia lakou, ma ka lima o Mose. ");
INSERT INTO haw1868_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Olelo ae la hoi o Mose ia Aarona, a ia Eleazara, a ia Itamara, i kana mau keiki i koe mai, E lawe i ka mohaiai i koe mai o na mohai o Iehova i kamnahaia'ku ai ma ke ahi, a e ai ia mea me ka hu ole kokoke i ke kuahu; no ka mea, he mea hoano loa ia. ");
INSERT INTO haw1868_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","E ai hoi oukou ia mea ma kahi hoano; no ka mea, nau no ia, a na kau mau keiki noloko o na mohai o Iehova i kanmahaia ma ke ahi; no ka mea, pela wau i kauohaia mai ai. ");
INSERT INTO haw1868_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","E ai hoi oukou i ka umauma luli, a me ka uha mua hoali ma kahi maemae, o oe, a me kau mau keiki, a me kau mau kaikamahine me oe; no ka mea, o kou kuleana ia, a me ko na keiki au, o na mea i haawiia noloko o na alana o na mohaihoomalu a na mamo a Iseraela. ");
INSERT INTO haw1868_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","E lawe mai lakou i ka uha hoali a me ka umauma luli me na mohai kaikea kuniia, e hooluli i mohaihoali ma ke alo o Iehova; a e lilo ia nau a na kau mau keiki me oe, ma ke kanawai mau loa, e like me ka Iehova kauoha. ");
INSERT INTO haw1868_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Imi ikaika ae la o Mose i ke kao mohailawehala, aia hoi, ua puhiia; a na huhu oia ia Eleazara a ia Itamara na keiki a Aarona i koe mai, i ae la, ");
INSERT INTO haw1868_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","No ke aha la i ai ole ai olua i ka mohailawehala ma kahi hoano, no ka mea, he mea hoano loa, a ua haawiia ia oukou, o hali i ka hewa o ke anaina, e hana hoi i kalahala uo lakou ma ko alo o Iehova! ");
INSERT INTO haw1868_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Eia hoi, aole i laweia mai ke koko maloko o kahi hoano, he pono no i ai io oukou ia mea ma kahi hoano, me a'u i kauoha aku ai. ");
INSERT INTO haw1868_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","A olelo ae la o Aarona ia Mose, Eia hoi, i keia la ua mohai aku laua i ka laua mohailawehala a me ka laua mohaikuni ma ke alo o Iehova; a ua loaa ia'u na mea e like me nei: a ina i ai au i ka mohailawehala, i keia la, ua pono anei ia i na maka o Iehova! ");
INSERT INTO haw1868_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","A lohe o Mose, he pono ia i kona manao. ");
INSERT INTO haw1868_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","OLELO mai la hoi o Iehova ia Mose a me Aarona, i mai la ia laua, ");
INSERT INTO haw1868_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","E olelo olua i na mamo a Iseraela, penei, Eia na holoholona a oukou e ai ai, o ko na holoholona a pau maluna o ka honua. ");
INSERT INTO haw1868_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","O ka mea mahele i ka maiuu, a ua kapuwai maheleia, a ua nau i ka mea hoolualuaiia, iwaena o na holoholona, oia ka oukou e ai ai. ");
INSERT INTO haw1868_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Aka, aole oukou e ai i keia mau mea o na mea nau i ka mea hoolualuaiia, a o na mea mahele maiuu, o ke kamelo, no ka mea, ua nau ia i ka mea hoolualuaiia, aole nae i mahele i ka maiuu, he haumia ia ia oukou. ");
INSERT INTO haw1868_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","A o ke kone hoi, no ka mea, ua nau no ia i ka mea hoolualuaiia, aole mahele i ka maiuu, he haumia ia ia oukou. ");
INSERT INTO haw1868_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","A o ka hare hoi, no ka mea, ua nau no ia i ka mea hoolualuaiia, aole hoi i mahele i ka maiuu, he haumia ia ia oukou. ");
INSERT INTO haw1868_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","A o ka puaa hoi, no ka mea, ua mahele no ia i ka maiuu, ua kapuwai maheleia, aole hoi ia i nau i ka mea hoolualuaiia, he haumia ia ia oukou. ");
INSERT INTO haw1868_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Aole oukou e ai i ko lakou io, aole e hoopa i ko lakou kupapau, he haumia lakou ia oukou. ");
INSERT INTO haw1868_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Eia na mea e ai ai oukou, o na mea maloko o na wai, o ka mea halo, a me ka unahi, iloko o na wai a me na kai, a me na muliwai, o lakou ka oukou e ai ai. ");
INSERT INTO haw1868_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","A o ka mea halo ole, a me ka unahi ole, iloko o na kai, a me na muliwai, o na mea a pau e oni ana iloko o na wai, a o na mea ola iloko o na wai, he mea hoowahawahaia ia oukou. ");
INSERT INTO haw1868_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","He mau mea e hoowahawahaia ia oukou; aole oukou e ai i ko lakou io, a e hoopailua oukou i ko lakou mau kupapau. ");
INSERT INTO haw1868_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","O ka mea halo ole, a unahi ole maloko o na wai, oia ke hoowahawahaia e oukou. ");
INSERT INTO haw1868_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","Eia hoi na mea a oukou e hoowahawaha ai iwaena o na manu, aole e aiia lakou, he mea e hoowahawahaia no; o ka aeto, a me ka oseferaga, a me ka osepera; ");
INSERT INTO haw1868_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","A o ka vuletura, a me ka falekona me kona like; ");
INSERT INTO haw1868_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","A o ke koraka me kona like; ");
INSERT INTO haw1868_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","A o ka iana, a me ke tama, a me ke kuku, a me ka nisu me kona like; ");
INSERT INTO haw1868_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","A o ka pueo pepeiao, a me ka lawaia, a me ka pueo; ");
INSERT INTO haw1868_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","A o ka noketura, a me ka pelikana a me ka vuletura keokeo; ");
INSERT INTO haw1868_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","A o ke kikonia, a me ka aredea me kona like, a me ka upupa, a me ka opeapea. ");
INSERT INTO haw1868_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","O na manu kolo e hele ana ma na ha, he mea ia e hoowahawahaia e oukou. ");
INSERT INTO haw1868_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Eia nae na mea e pono ke ai oukou, o na mea lele e kolo ana, na mea hele ma na ha, he mau wawae hoi ko lakou maluna o na kapuwai, e mahiki ai ma ka honua; ");
INSERT INTO haw1868_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","O neia poe o lakou e pono ke ai oukou; o ka uhini me kona like, a me ka uhini wawae ha me kona like, a me ka uhini lele me kona like, a me ka uhini akerida me kona like. ");
INSERT INTO haw1868_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Aka o na mea lele e ae a pau e kolo ana, me na wawae ha, he mea ia e hoopailuaia e oukou. ");
INSERT INTO haw1868_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","A no ia mau mea e haumia ai oukou; o ka mea i pa aku i ko lakou kupapau e haumia ia a hiki i ke ahiahi. ");
INSERT INTO haw1868_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","A o ka mea e hali i kauwahi o ke kupapau o lakou, e holoi oia i kona mau kapa, a e haumia hoi ia a hiki i ke ahiahi. ");
INSERT INTO haw1868_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","O ke kupapau o ka holoholona i mahele i ka maiuu, aole mahele lea ia ke kapuwai, aole nau i ka mea i hoolualuaiia, oia ke haumia ia oukou, o ka mea e pa ia lakou e haumia no ia. ");
INSERT INTO haw1868_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","O ka mea hele ma kona mau kapuwai manamana, o ko na holoholona a pau e hele ana ma na ha, he haumia ia ia oukou; a o ka mea i pa i ko lakou kupapau e haumia ia a hiki i ke ahiahi. ");
INSERT INTO haw1868_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","A o ka mea nana e hali i ko lakou kupapau, e holoi oia i kona kapa, a e haumia a hiki i ke ahiahi, he mau mea haumia ia oukou. ");
INSERT INTO haw1868_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","Eia hoi na mea haumia ia oukou iwaena o na mea kolo e kolo ana ma ka lepo, o ka mole, o ka iole, a me ka honu me kona like, ");
INSERT INTO haw1868_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","A me ke anaka, a me ke koa, a me ka moo, a me ka hometa, a me ke kameleona. ");
INSERT INTO haw1868_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","He mau mea haumia ia ia oukou iwaena o na mea a pau e kolo ana; o ka mea e pa ia mau mea mahope o ko lakou make ana, e haumia no ia a hiki i ke ahiahi. ");
INSERT INTO haw1868_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","A o ka mea i hauleia iho e kekahi mea i make o lakou, e haumia no ia; ina he ipu laau, a he kapa paha, a he ili, he eke, o kela ipu keia ipu, kahi e hanaia'i ka hana, e hookomoia iloko o ka wai, a e haumia ia a hiki i ke ahiahi, alaila e hoomaemaeia ia. ");
INSERT INTO haw1868_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","A o ka ipu lepo, i hauleia iloko e kekahi o lakou, e haumia ka mea oloko, a e wawahi oukou ia. ");
INSERT INTO haw1868_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","A o ka ai e aiia, ke hiki ia wai maluna iho, e haumia ia; a o ka mea inu e inuia oloko o ia ipu, e haumia ia. ");
INSERT INTO haw1868_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","A o ka mea i hauleia'i e kauwahi o ko lakou kupapau, e haumia ia, o ka umu paha, kahi e kau ai na ipuhao, e wawahiia no ia mau mea; ua haumia, a e haumia hoi ia mau mea ia oukou. ");
INSERT INTO haw1868_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Aka he kumuwai, a he lua paha, kahi wai nui, e maemae ia; aka o ka mea pa i ko lakou kupapau e haumia oia. ");
INSERT INTO haw1868_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","A ina e haule iho kauwahi o ko lakou kupapau maluna o ka hua lulu e luluia'na, e maemae hoi ia. ");
INSERT INTO haw1868_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","A ina i kau ka wai maluna o ka hua, a haule kauwahi o ko lakou kupapau maluna iho ona, e haumia ia ia oukou. ");
INSERT INTO haw1868_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","A ina e make ka holoholona he pono ke aiia e oukou, o ka mea i pa i kona kupapau, e haumia ia a hiki i ke ahiahi. ");
INSERT INTO haw1868_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","A o ka mea i ai i kona kupapau, e holoi oia i kona kapa, a haumia hoi ia a hiki i ke ahiahi: a o ka mea hali i kona kupapau, e holoi oia i kona kapa, a haumia hoi a hiki i ke ahiahi. ");
INSERT INTO haw1868_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","A o ka mea kolo e kolo ana ma ka lepo, he mea hoowahawahaia, aole ia e aiia. ");
INSERT INTO haw1868_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","A o ka mea kolo ma ka opu, a o ka mea hele ma na ha, a o ka mea he nui kona mau kapuwai, iwaena o na mea kolo a pau e kolo ana ma ka lepo, aole oukou e ai ia lakou; no ka mea, he mau mea hoowahawahaia. ");
INSERT INTO haw1868_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Mai hoolilo ia oukou iho i mea hoowahawahaia, i kekahi mea kolo e kolo ana; aole hoi e hoohaumia ia oukou me lakou i haumia oukou ilaila. ");
INSERT INTO haw1868_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","No ka mea, owau, no Iehova ko oukou Akua; nolaila, e hoomaemae oukou ia oukou iho i maemae oukou, no ka mea, he maemae wau; aole hoi oukou e hoohaumia ia oukou iho me kekahi mea kolo e kolo ana ma ka lepo. ");
INSERT INTO haw1868_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","No ka mea, owau no Iehova, e lawe ana ia oukou mailoko mai o ka aina o Aigupita, i Akua no oukou: nolaila e hoano oukou, no ka mea, he hoano no wau. ");
INSERT INTO haw1868_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Oia ke kanawai no na holoholona, a no na manu, a no na mea ola e oni ana iloko o ka wai, a no na mea kolo e kolo ana ma ka lepo: ");
INSERT INTO haw1868_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","E hookaawale iwaena o ka mea haumia a me ka mea maemae, a iwaena hoi o na holoholona e pono ke aiia a me na holoholona pono ole ke aiia. ");
INSERT INTO haw1868_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","OLELO mai la hoi o Iehova ia Mose, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","E olelo aku oe i na mamo a Iseraela, penei, Ina i hapai ka wahine a hanau he keikikane, e haumia ka wahine i na la ehiku, e like me na la o kona kaawale ana no kona mai, e haumia ana no ia. ");
INSERT INTO haw1868_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","A i ka walu o ka la e okipoepoeia'i kona iliomaka. ");
INSERT INTO haw1868_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Alaila noho ka wahine iloko o kona koko o kona hoomaemaeia, i na la he kanakolukumamakolu; aole e pa aku oia i ka mea hoano, aole hoi e komo i ke keenakapu, a pau ae na la o kona hoomaemae ana. ");
INSERT INTO haw1868_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Aka ina i hanau oia he kaikamahine, alaila e haumia ia i na hebedoma elua, me ia i kona kaawale ana; a e noho no oia iloko o ke koko o kona hoomaemaeia i na la he kanaonokumamaono. ");
INSERT INTO haw1868_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Aia pau na la o kona hoomaemae ana, no ke keikikane, a no ke kaikamahine paha, e lawe mai no oia i ke keikihipa o ka makahiki hookahi, i mohaikuni, a i ka manu nunu opiopio, a i ke kuhukuku paha i mohailawehala, i ka puka o ka halelewa o ke anaina, i ke kahuna; ");
INSERT INTO haw1868_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Nana no ia e kaumaha aku ma ke alo o Iehova, a e hana i kalahala nona, a e hoomaemaeia oia mai ke kahe ana o kona koko. Oia ke kanawai no ka wahine i hanau he kane, he wahine paha. ");
INSERT INTO haw1868_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","A ina e hiki ole ia ia ke lawe mai i ke keikihipa, alaila e lawe mai oia i na kuhukuku elua, a i na manu nunu opiopio paha, i kekahi i mohaikuni, a i kekahi i mohailawehala: a e hana ke kahuna i kalahala nona, a maemae no ia. ");
INSERT INTO haw1868_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","OLELO mai la hoi o Iehova ia Mose a me Aarona, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","A loaa i ke kanaka ka pehu ana ma ka ili o kona io, a o ka pehupala paha, a o kahi lilelile paha, a iloko no o ka ili o kona io e like me ka mai lepera; alaila e laweia mai oia io Aarona la ke kahuna, a i kekahi paha o na keiki ana, na kahuna pule; ");
INSERT INTO haw1868_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","A e nana iho ke kahuna pule i ka mai iloko o ka ili o kona io, a i lilo ka huluhulu iloko o ka mai i keokeo, a ina malalo iho o ka ili o kona io ka mai i ikeia, he mai lepera ia; a e nana ae ke kahuna ia ia a e olelo aku, he haumia ia. ");
INSERT INTO haw1868_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","A ina he keokeo kahi lilelile iloko o ka ili o kona io, a ina aole malalo ia o ka ili i ka ikeia, aole hoi i lilo kolaila huluhulu i keokeo; alaila e papani i ka mea mai, i na la ehiku. ");
INSERT INTO haw1868_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","A i ka hiku o ka la e nana hou aku ke kahuna ia ia; aia hoi, ina aole ai ka mai, aole hoi i nui ae maloko o ka ili; alaila e papani hou ke kahuna ia ia i na la hou ehiku. ");
INSERT INTO haw1868_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","A i ka hiku o ka la, e nana hou aku ke kahuna ia ia; aia hoi, ina i eleele iki mai ka mai, aole hoi i nui ae ka mai iloko o ka ili, alaila e olelo ke kahuna he maemae oia; he pehupala ia, e holoi oia i kona kapa, a e maemae ia. ");
INSERT INTO haw1868_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Aka ina i nunui ae ka pehupala iloko o ka ili, mahope iho o kona ikeia ana e ke kahuna, e ike hou ia oia e ke kahuna pule. ");
INSERT INTO haw1868_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","A ina i ike ke kahuna pule, aia hoi, ua nunui ae ka pehupala iloko o ka ili, alaila e olelo aku ke kahuna, ua haumia ia, he lepera ia mai. ");
INSERT INTO haw1868_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","A ina he mai lepera iloko o ke kanaka, e laweia mai oia i ke kahuna pule; ");
INSERT INTO haw1868_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","A e nana aku ke kahuna ia ia; aia hoi, ina he keokeo ka pehu ana iloko o ka ili, a ua hoolilo ae i ka huluhulu i keokeo, a he io kupu maloko o ka pehu ana, ");
INSERT INTO haw1868_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","He mai lepera kahiko ia iloko o ka ili o kona io, a e olelo ke kahuna he haumia oia, aole e papani ae ia ia, no ka mea he haumia ia. ");
INSERT INTO haw1868_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Ina i poha ka mai lepera iloko o ka ili, a paapu i ka lepera ka ili o ka mea mai lepera mai kona poo a hiki i kona kapuwai, ma kela wahi keia wahi a puni a ke kahuna i nana ai: ");
INSERT INTO haw1868_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","Alaila, e noonoo ae ke kahuna; aia hoi, ina ua paapu kona io a pau i ka mai lepera, e olelo ae no ia he maemae ka mea mai; ua pau ae i ke keokeo, he maemae oia. ");
INSERT INTO haw1868_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Aka i na la i ikeia ka io kupu iloko ona, e haumia no ia. ");
INSERT INTO haw1868_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","A e nana hoi ke kahuna i ka io, a e olelo aku hoi he haumia ia; he haumia ka io, he mai lepera ia. ");
INSERT INTO haw1868_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","A ina i ano hou ka io, a lilo ia i keokeo, e hele hou mai no ia i ke kahuna pule; ");
INSERT INTO haw1868_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","A e nana ke kahuna ia ia; aia hoi, ina ua lilo ka mai i keokeo, alaila e olelo ke kahuna, he maemae ka mea mai; he maemae no ia. ");
INSERT INTO haw1868_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","A o ka io hoi maloko ona, a maloko o kolaila ili, he mai hehee, a ua ola ia; ");
INSERT INTO haw1868_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","A ina ma kahi o ka mai hehee, he pehu keokeo, he wahi lilelile paha, he keokeo, he ula iki nae, a i hoikeia'e i ke kahuna pule; ");
INSERT INTO haw1868_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","A ike ke kahuna, aia hoi, malalo o ka ili ia i ka ikeia, a ua lilo kolaila huluhulu i keokeo, alaila e olelo ke kahuna he haumia ia: he mai lepera ia i poha mai, mailoko mai o ka mai hehee. ");
INSERT INTO haw1868_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","A ina i nana ke kahuna ia mea, aia hoi, aole huluhulu keokeo malaila, aole hoi ia maloko o ka ili, aka he eleele iki; alaila e papani aku ke kahuna ia ia i na la ehiku; ");
INSERT INTO haw1868_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","A ina e palahalaha nui ae ia ma ka ili, alaila e olelo ke kahuna he haumia ia, he mai ino ia. ");
INSERT INTO haw1868_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Aka ina e mau kahi lilelile ma kona wahi no, aole palahalaha ae, he wewela ia; a e olelo ke kahuna he maemae ia. ");
INSERT INTO haw1868_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","A ina he io iloko o ka ili kahi i wewela ai a he wahi lilelile keokeo ko ka mea e wewela ana, he ulaula iki paha, he keokeo paha; ");
INSERT INTO haw1868_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","Alaila e nana ke kahuna ia mea; aia hoi, ina ua lilo ka huluhulu maloko o kahi lilelile, i keokeo, a malalo o ka ili ia i ke ikeia, he mai lepera ia i pahu mai mai loko mai o ka wela: nolaila e olelo ai ke kahuna he haumia ia; he mai lepera ia. ");
INSERT INTO haw1868_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","A ina e nana ke kahuna ia mea, aia hoi, aole huluhulu keokeo ma kahi lilelile, aole hoi ia malalo o kekahi ili, aka he eleele iki; alaila e papani aku ke kahuna ia ia i na la ehiku. ");
INSERT INTO haw1868_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","A i ka hiku o ka la, e nana hou ke kahuna ia ia; a ina ua palahalaha nui ae ia ma ka ili, alaila e olelo ke kahuna he haumia ia; he mai lepera ia. ");
INSERT INTO haw1868_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","A ina e mau kahi lilelile i kona wahi iho, aole palahalaha ae ma ka ili, aka he eleele iki nae ia, he pehu ia o ka wela, a e olelo ke kahuna he maemae ia; he hoailona ia o ka wela. ");
INSERT INTO haw1868_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Ina he mai ko ke kanaka paha, ko ka wahine paha ma ke poo paha, ma ka umiumi paha: ");
INSERT INTO haw1868_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","Alaila e nana ke kahuna i ka mai ino, aia hoi, ina malalo ia o ka ili i ka ikeia, a malaila ke oho melemele lahilahi; alaila e olelo ke kahuna he haumia ia, he mai lepera ia, he mai lepera ma ke poo paha, a ma ka umiumi paha. ");
INSERT INTO haw1868_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","A ina e nana ke kahuna i ka mai lepera, aia hoi, aole malalo iho ia o ka ili i ka ikeia, aole hoi oho eleele iloko ona; alaila e papani aku ke kahuna i ka mea mai lepera i na la ehiku: ");
INSERT INTO haw1868_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","A i ka hiku o ka la, e nana hou ke kahuna i ka mai; aia hoi, i palahalaha ole ae ka mai lepera, aole hoi oho melemele malaila, aole hoi ka mai lepera malalo o ka ili; ");
INSERT INTO haw1868_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","E kahiia oia, aka aole e kahi i ka mai lepera; a e papani aku ke kahuna i ka mea mai lepera i na la hou ehiku. ");
INSERT INTO haw1868_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","A i ka hiku o ka la, e nana hou ke kahuna i ka mai lepera; aia hoi, ina aole palahalaha ae ka mai lepera ma ka ili, aole hoi ia malalo o ka ili i ka ikeia; alaila e olelo ke kahuna he maemae ia, a e holoi oia i kona kapa, a e maemae no hoi. ");
INSERT INTO haw1868_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Aka ina i palahalaha nui ae ka mai lepera ma ka ili mahope o kona maemae ana, ");
INSERT INTO haw1868_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","Alaila e nana ko kahuna ia ia; aia hoi, ina ua palahalaha ae ka mai lepera ma ka ili, aole e imi ke kahuna i ke oho melemele, he haumia no ia. ");
INSERT INTO haw1868_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Aka ina he mau ko ka mai lepera i ka ikeia, a ua kupu ke oho eleele iloko, ua ola ia mai lepera, he maemae no oia: a e olelo ke kahuna he maemae ia. ");
INSERT INTO haw1868_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","A ina he mau wahi lilelile, he lilelile keokeo ko ke kanaka paha, ko ka wahine paha, iloko o ko laua ili; ");
INSERT INTO haw1868_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","Alaila e nana ke kahuna, aia hoi, ina he keokeo eleele iki, he wahi ahinahina ia e ulu ana iloko o ka ili; he maemae no ia. ");
INSERT INTO haw1868_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","A o ke kanaka ua haule iho kona lauoho mai kona poo iho, he ohule ia, he maemae nae. ");
INSERT INTO haw1868_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","A o ke kanaka ua haule ka lauoho mai kahi e kokoke ana i kona maka, he lae ohule ia, he maemae nae. ");
INSERT INTO haw1868_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","A ina ma kahi ohule o ke poo, a o ka lae paha he mai keokeo ulaula iki; he mai lepera ia i kupu ma kona poo ohule, a ma kona lae ohule paha. ");
INSERT INTO haw1868_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Alaila e nana ke kahuna pule ia mea; aia hoi, ina o ka pehu ana o ka mai he ulaula keokeo, ma kona poo ohule paha, a ma kona lae ohule paha, e like me ka mai lepera i ka nanaia ma ka ili o ka io; ");
INSERT INTO haw1868_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","He kanaka lepera ia, he haumia; e olelo ke kahuna, he haumia loa ia, ma kona poo kona mai. ");
INSERT INTO haw1868_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","A o ka lepera iloko ona ka mai, e uhaeia kona kapa, a e papale ole kona poo, a e uhi i kona lehelehe luna, a e kahea aku, He haumia, he haumia. ");
INSERT INTO haw1868_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","I na la a pau e noho ai ka mai iloko ona, e maemae ole no ia; he haumia no, e noho kaawale ia, mawaho o kahi hoomoana kona wahi e noho ai. ");
INSERT INTO haw1868_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","O ke kapa hoi koloko ona ka mai lepera, ina he kapa hula hipa, ina he kapa olona; ");
INSERT INTO haw1868_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","Ina ma ka maaweloloa, a ina ma ka maawepokopoko, o ke olona paha, o ka huluhipa; a ina ma ka ili, a ina ma kekahi mea i hanaia o ka ili; ");
INSERT INTO haw1868_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","A ina he omaomao iki, a he ulaula iki ka lepera iloko o ke kapa paha, a iloko paha o ka ili, a iloko paha o ka maaweloloa, a ma ka maawepokopoko paha, a iloko paha o ka mea i hanaia no ka ili; he mai lepera ia, a e hoikeia ia i ke kahuna pule. ");
INSERT INTO haw1868_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","A e nana ke kahuna i ka lepera, a e papani aku i ka mea lepera i na la ehiku. ");
INSERT INTO haw1868_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","A i ka hiku o ka la, e nana aku oia i ka lepera; a ina i palahalaha ae ka lepera iloko o ke kapa, ina maloko o ka maaweloloa, o ina ma ha maawepokopoko, a ina ma ka ili, a ina ma ka mea i hanaia no ka ili; he lepera aai ia, he haumia no ia. ");
INSERT INTO haw1868_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","E puhi hoi oia ia kapa, ina he maaweloloa, ina he maawepokopoko, a ina ma ka huluhipa, ina ma ke olona, a ina ma ko ka ili, kahi e noho ai ka lepera; no ka mea he lepera aai ia, a hoopauia ia i ke ahi. ");
INSERT INTO haw1868_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","A ina e nana ke kahuna, aia hoi, aole i palahalaha ae ka lepera iloko o ke kapa, ma ka maaweloloa, ka maawepokopoko, a ma ka mea paha i hanaia no ka ili; ");
INSERT INTO haw1868_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","Alaila e kauoha ke kahuna e holoi lakou i ka mea lepera, a e papani hou oia i na la hou ehiku; ");
INSERT INTO haw1868_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","A e nana ke kahuna i ka lepera mahope o ka holoi ana; aia hoi, ina aole ano hou, aole i palahalaha ae ka lepera, he haumia no ia; e puhi oe ia mea i ke ahi, ua aai no ia, ua kuakea ma ke kua a ma ke alo paha. ");
INSERT INTO haw1868_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","A ina e nana ke kahuna, aia hoi, ua eleele iki ka lepera mahope iho o ka holoi ana ia mea; alaila e uhae oia ia mea mailoko ae o ke kapa paha, a o ka ili paha, a o ka maaweloloa paha, a o ka maawepokopoko paha: ");
INSERT INTO haw1868_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","A i ike mau ia ia iloko o ke kapa, ina ma ka maaweloloa, a ina ma ka maawepokopoko, a ina ma ka mea ili, he mea e palahalaha ana; e puhi oe i ka mea lepera i ke ahi. ");
INSERT INTO haw1868_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","A o ke kapa, o ka maaweloloa, a o ka maawepokopoko, a o ka mea ili, au e holoi ai, ina ua haalele aku ka lepera mailaila aku, alaila e holoi hou ia'e ia mea, a e maemae no. ");
INSERT INTO haw1868_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Oia ke kanawai o ka lepera iloko o ke kapa huluhipa, a he olona, ma ka maaweloloa paha, ka maawepokopoko paha, a he mea ili paha, a e olelo ai he maemae, a e olelo ai hoi he haumia. ");
INSERT INTO haw1868_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","OLELO mai la hoi o Iehova ia Mose, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","Eia ke kanawai o ka lepero i kona la e hoomaemaeia'i; e laweia mai ia i ke kahuna pule; ");
INSERT INTO haw1868_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","A e hele aku ke kahuna mailoko aku o kahi hoomoana, a e nana ke kahuna, aia hoi, ina ua ola ka mai lepera iloko o ka lepero; ");
INSERT INTO haw1868_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","Alaila e kauoha ke kahuna e lawe iho no ka mea e hoomaemaeia ana, elua manu ola, maemae, a me ka laau kedera, a me ka lole ula, a me ka husopa; ");
INSERT INTO haw1868_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","A e kauoha ke kahuna e pepehi ia kekahi o na manu maloko o ka ipu lepo, maluna o ka wai e kahe ana: ");
INSERT INTO haw1868_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","A o ka manu ola, e lalau oia ia, a me ka laau kedera, a me ka lole ula, a me ka husopa, a e hou iho ia mau mea me ka manu ola, iloko o ke koko o ka manu i pepehiia maluna o ka wai e kahe ana: ");
INSERT INTO haw1868_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","A e pipi aku oia maluna o ka mea e hoomaemaeia'na i ka lepera, i ehiku ka pipi ana, a e olelo aku he maemae ia, a e hookuu aku oia i ka manu ola mawaho ma ke kula. ");
INSERT INTO haw1868_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","A o ka mea e hoomaemaeia'na e holoi oia i kona kapa, a e koli i kona lauoho a pau, a e auau ia i ka wai, i maemae ia; a mahope iho, e hele mai ia i kahi hoomoana, a e noho mawaho o kona halelewa i na la ehiku. ");
INSERT INTO haw1868_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","A i ka hiku o ka la, e koli oia i kona lauoho a pau ma kona poe, a me kona umiumi, a me kona hulu kuemaka, o kona lauoho a pau kana e koli ai; a e holoi i kona kapa, a e holoi hoi oia i kona kino iho i ka wai, a a maemae ia. ");
INSERT INTO haw1868_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","A i ka walu o ka la, e lawe oia i elua keikihipa kane kina ole, a i hookahi keikihipa wahine kina ole o ka makahiki hookahi, a i ekolu paha umi epa o ka palaoa wali, i mohaiai i huiia me ka aila, a i hookahi loga aila. ");
INSERT INTO haw1868_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","A o ke kahuna e hoomaemae ana ia ia, e hoike oia i ke kanaka e hoomaemaeia'na a me kela mau mea, ma ke alo o Iehova ma ka puka o ka halelewa o ke anaina. ");
INSERT INTO haw1868_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","A e lawe ke kahuna i kekahi o ua mau keikihipa kane la, a e kaumaha aku i mohaihala, a me ka loga aila, a e hooluli ae ia mau mea i mohaihoali imua o ke alo o Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","A e pepehi ai oia i ke keikihipa ma kahi e pepehi ai oia i ka mohailawehala, a me ka mohaikuni, ma kahi hoano; no ka mea, no ke kahuna pule ka mohailawehala, pela ka mohaihala, he laa loa ia. ");
INSERT INTO haw1868_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","A e lawe ke kahuna i kauwahi o ke koko o ka mohaihala, a e kau aku ke kahuna ia ma ke kihi o ka pepeiao akau o ka mea e hoomaemaeia'na, a ma ka manamananui o kona lima akau, a ma ka manamananui hoi o kona kapuwai akau. ");
INSERT INTO haw1868_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","A e lawe ke kahuna i kauwahi o ka loga aila, a e ninini iho maloko o ka poho o kona lima hema: ");
INSERT INTO haw1868_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","A e hoo iho ke kahuna i kona manamanalima akau iloko o ka aila ka mea iloko o kona lima hema, a e pipi i ka aila me kona manamanalima, ehiku ka pipi ana imua o Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","A o ko ke koena o ka aila iloko o kona lima hema, o ka ke kahuna ia e kau ai ma ke kihi o ka pepeiao akau o ke kanaka e hoomaemaeia'na, a ma ka manamananui o kona lima akau, a ma ka manamananui o kona kapuwai akau maluna iho o ke koko o ka mohailawehala. ");
INSERT INTO haw1868_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","A o ke koena o ka aila iloko o ka lima o ke kahuna, oia kana e ninini ai maluna iho o ke poo o ka mea e hoomaemaeia'na; a e hana ke kahuna i kalahala nona imua o Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","A e kaumaha aku ke kahuna i ka mohailawehala, a e hana hoi i kalahala no ka mea e hoomaemaeia na mai kona haumia ana; a mahope iho e pepehi ai oia i ka mohaikuni. ");
INSERT INTO haw1868_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","A e kaumaha aku ke kahuna i ka mohaikuni, a me ka mohaiai, maluna o ke kuahu, a e hana ke kahuna i kalahala nona; a e maemae oia. ");
INSERT INTO haw1868_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","A ina he ilihune ia, aole hoi hiki keia mau mea ia ia; alaila e lawe oia i hookahi keikihipa i mohaihala e hooluliia i kalahala nona, a i hookahi hapaumi o ka epa palaoa wali i huiia me ka aila i mohaiai, a me ka loga aila: ");
INSERT INTO haw1868_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","A i elua kuhukuku, a i ole ia, i elua manu nunu opiopio, na mea e loaa ia ia; a e lilo kekahi i mohailawehala, a o kekahi i mohaikuni. ");
INSERT INTO haw1868_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","A e lawe mai oia ia mau mea i ka walu o ka la, e hoomaemaeia'i oia, i ke kahuna ma ka puka o ka halelewa o ke anaina imua o Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","A e lawe ke kahuna i ke keikihipa mohaihala a me ka loga aila, a hooluli ke kahuna ia mau mea i mohaihoali imua o Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","A e pepehi oia i ke keikihipa i mohaihala, a e lawe ke kahuna i kauwahi o ke koko o ka mohaihala, a e kau ae ma ke kihi o ka pepeiao akau o ka mea e hoomaemaeia'na, a ma ka manamananui o kona lima akau, a ma ka manamananui o kona kapuwai akau. ");
INSERT INTO haw1868_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","A e ninini ke kahuna i kauwahi o ka aila ma ka poho o kona lima hema iho: ");
INSERT INTO haw1868_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","A e pipi ke kahuna me kona manamanalima akau i kauwahi o ka aila iloko o kona lima hema, ehiku ka pipi ana imua o Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","A e kau ke kahuna i kauwahi o ka aila ka mea iloko o kona lima, ma ke kihi o ka pepeiao akau o ka mea e hoomaemaeia'na, a ma ka manamananui o kona lima akau, a ma ka manamananui o kona kapuwai akau, ma kahi o ke koko o ka mohaihala. ");
INSERT INTO haw1868_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","A o ke koena o ka aila maloko o ka lima o ke kahuna, oia kana e kau ai ma ke poo o ka mea e hoomaemaeia'na, a e hana hoi i kalahala nona ma ke alo o Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","A e kaumaha hoi oia i kekahi o na kuhukuku, a o na manu nunu paha, ka mea e hiki ke loaa ia ia; ");
INSERT INTO haw1868_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","Ka mea e hiki i kona lima, i kekahi i mohailawehala, a i kekahi i mohaikuni, me ka mohaiai; a e hana ke kahuna i kalahala no ka mea e hoomaemaeia'na imua o Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Oia ke kanawai no ka mea mai lepera, aole hiki ke loaa i kona lima na mea no kona hoomaemae ana. ");
INSERT INTO haw1868_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Olelo mai la hoi o Iehova ia Mose a me Aarona, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","Aia komo oukou i ka aina o Kanaana a'u e haawi ai ia oukou i hooilina, a hookomo au i ka ino lepera iloko o ka hale o ka aina o oukou; ");
INSERT INTO haw1868_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","A hele mai ka mea nona ka hale e hai i ke kahuna pule, e i mai ana, I kuu manao, ea, me he ino lepera la iloko o ka hale: ");
INSERT INTO haw1868_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Alaila e kauoha ke kahuna e hookaawale i ka hale mamua o ke komo ana o ke kahuna e ike i ka ino, i ole ai e pau i ka haumia koloko o ka hale; a mahope iho e hele ae ke kahuna iloko e nana i ka hale. ");
INSERT INTO haw1868_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","A e nana aku oia i ka mai ino, aia hoi, ina ma na paia ka mai ino, he mau alualu, he omaomao iki, a he ulaula iki paha, ua poopoo iloko o ka paia i ka nana aku; ");
INSERT INTO haw1868_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","Alaila e puka aku ke kahuna mawaho o ka hale a i ka puka o ka hale, a e papani i ka hale i na la hiku. ");
INSERT INTO haw1868_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","A e hoi mai ke kahuna i ka hiku o ka la, a e nana; aia hoi, ina ua palahalaha ae ka ino ma na paia o ka hale; ");
INSERT INTO haw1868_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","Alaila e kauoha ke kahuna e lawe aku lakou i na pohaku i pili ai ka ino, a e kiola lakou ia mau mea mawaho o ke kulanakauhale, ma kahi haumia. ");
INSERT INTO haw1868_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","E kepa ae oia ia loko o ka hale a puni, a e ninini aku lakou i ka lepo a lakou i kepa ai, mawaho o ke kulanakauhale ma kahi haumia: ");
INSERT INTO haw1868_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","A e lawe lakou i na pohaku hou a hahao ma kahi o kela mau pohaku; a e lawe oia i ka puna hou e hamo i ka hale. ");
INSERT INTO haw1868_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","A ina e hiki hou mai ka ino, a poha hon mahope iho o ka lawe ana aku o na pohaku, a mahope hoi o kona kepa ana i ka hale, a mahope hoi o kona hamoia'na; ");
INSERT INTO haw1868_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","Alaila e hele mai ke kahuna a e nana, aia hoi, ina ua palahalaha ae ka ino maloko o ka hale, he lepera ia e aai ana iloko o ka hale, he haumia ia. ");
INSERT INTO haw1868_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","A e hoohiolo hoi oia i ka hale, i kona mau pohaku a me kona mau laau, a me ka puna a pau o ka hale; a e halihali oia ia mau mea mawaho o ke kulanakauhale i kahi haumia. ");
INSERT INTO haw1868_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","O ka mea hoi i hele ae iloko o ka hale i kona wa a pau i papaniia'i, e haumia oia a hiki i ke altiahi. ");
INSERT INTO haw1868_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","A o ka mea moe ma ia hale, e holoi oia i kona kapa; a o ka mea ai maloko o ka kale, e holoi oia i kona kapa. ");
INSERT INTO haw1868_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","A ina e komo ke kahuna, a e nana aku ia mea, aia hoi, aole i palahalaha ka mai ino maloko o ka hale mahope iho o ka hamoia'na o ka hale; alaila e olelo ke kahuna pule he maemae ka hale, no ka mea, ua ola ka mai ino. ");
INSERT INTO haw1868_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","A lawe oia e hoomaemae i ka hale, i na manu elua, a me ka laau kedera, a me ka ulaula, a me ka huaopa; ");
INSERT INTO haw1868_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","A e pepehi oia i kekahi o na manu, maloko o ka ipu lepo maluna o ka wai e kahe ana; ");
INSERT INTO haw1868_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","A e lawe oia i ka laau kedera, a me ka husopa, a me ka ulaula, a me ka manu e ola ana, a e hou ia mau mea iloko o ke koko o ka manu i pepehiia, a iloko hoi o ka wai e kahe ana, a e pipi i ka hale, ehiku ka pipi ana. ");
INSERT INTO haw1868_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","A e hoomaemae oia i ka hale me ke koko o ka manu a me ka wai e kahe ana, a me ka manu e ola ana, a me ka laau kedera, a me ka huaopa a me ka ulaula. ");
INSERT INTO haw1868_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Aka, e hookuu aku oia i ka manu e ola ana mawaho ma ke kula, a e hana i kalahala no ka hale; a e maemae no ia. ");
INSERT INTO haw1868_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Oia ke kanawai no ka mai ino o kela lepera keia lepera; ");
INSERT INTO haw1868_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","A no ke kapa lepera, a me ka hale no hoi; ");
INSERT INTO haw1868_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","A no ka pahu ana, a me ka pehupala, a me kahi lilelile: ");
INSERT INTO haw1868_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","E hoakaka'i i ka wa e haumia ai ia, a i ka wa e maemae ai hoi; oia ke kanawai o ka lepera. ");
INSERT INTO haw1868_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","OLELO mai la hoi o Iehova ia Mose a me Aarona, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","E olelo olua i na mamo a Iseraela, e i aku ia lakou, O ke kanaka, he mai kahe mailoko aku o kona io; e haumia no ia, no kona hilo. ");
INSERT INTO haw1868_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","O kona haumia no ia iloko o kono hilo; ina e kahe ana kona io i kona hilo, a ina i paa paha kona io, aole kahe i kona hilo, o kona haumia no ia. ");
INSERT INTO haw1868_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","O kela moe keia moe a ka mea hilo e moe ai maluna iho, e haumia no ia; a o ka mea ana e noho ai maluna iho, e haumia no ia. ");
INSERT INTO haw1868_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","A o ka mea i pai kona moe, e holoi oia i kona mau kapa, a e auau i ka wai, a e haumia a hiki i ke ahiahi. ");
INSERT INTO haw1868_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","O ka mea e noho ma ka mea a ka mea hilo i noho ai, e auau oia i ka wai, a e haumia ia a hiki i ke ahiahi. ");
INSERT INTO haw1868_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","A o ka mea i pa i ka io o ka mea hilo, e holoi oia i kona kapa, a e auau i ka wai, a e haumia a hiki i ke ahiahi. ");
INSERT INTO haw1868_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","A ina e kuha ka mea hilo maluna o ka mea maemae; alaila e holoi oia i kona mau kapa, a e auau i ka wai, a e haumia a hiki i ke ahiahi. ");
INSERT INTO haw1868_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","A o ka noho lio a ka mea hilo e holo ai, e haumia ia. ");
INSERT INTO haw1868_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","A o ka mea i pa i kekahi mea malalo oua, e haumia ia a hiki i ke ahiahi; a o ka mea e hali i kauwahi o ia mau mea, e holoi oia i kona mau kapa, a e auau hoi i ka wai, a e haumia no a hiki i ke ahiahi. ");
INSERT INTO haw1868_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","A o ka mea a ka mea hilo e hoopa aku ai, aole hoi i holoi kona lima i ka wai, e holoi oia i kona mau kapa, a e auau i ka wai, a e haumia hoi ia a hiki i ke ahiahi. ");
INSERT INTO haw1868_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","A o ka ipu lepo a ka mea hilo i pa ai, e wawahiia ia; a o na ipu laau, e holoiia ia i ka wai. ");
INSERT INTO haw1868_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","A i ka wa e maemae ai ka mea hilo i kona hilo, alaila e hela oia nona i na la ehiku no kona hoomaomaeia'na, a e holoi i kona mau kapa, a o hoauau i kona io i ka wai kahe, a e maemae hoi ia. ");
INSERT INTO haw1868_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","A i ka walu o ka la, e lawe oia nona i na kuhukuku elua, a i ole ia, i elua manu nunu opiopio, a e hele mai imua o ke alo o Iehova, ma ka puka o ka halelewa o ke anaina, a e haawi ia mau mea i ke kahuna. ");
INSERT INTO haw1868_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","A e kaumaha aku ke kahuna ia mau mea, hookahi i mohailawehala, a i kekahi i mohaikuni; a e hana ke kahuna i kalahala nona ma ke alo o Iehova, no kona hilo. ");
INSERT INTO haw1868_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","A ina e puka aku ka anoano o ke kanaka mailoko aku ona, alaila e holoi oia i kona kino okoa i ka wai, a e haumia hoi a hiki i ke ahiahi. ");
INSERT INTO haw1868_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","A o ke kapa, a o ka ili, he anoano kanaka maluna iho, e holoiia ia i ka wai, a e haumia hoi a hiki i ke ahiahi. ");
INSERT INTO haw1868_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","A o ka wahine hoi a ke kanaka i moe aku ai, me ka anoano, e auau no laua i ka wai, a e haumia hoi a hiki i ke ahiahi. ");
INSERT INTO haw1868_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","A ina he mai kahe ko ka wahine, a he koko ka mea kahe o kona io, e hookaawaleia'e oia i na la ehiku; a o ka mea i hoopa ia ia, e haumia oia a hiki i ke ahiahi. ");
INSERT INTO haw1868_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","A o ka mea ana e moe ai maluna iho, i kona kaawale ana, e haumia ia; a o ka mea ana e noho ai maluna iho, e haumia no ia. ");
INSERT INTO haw1868_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","O ka mea i pa i kona wahi moe, e holoi oia i kona mau kapa, a e auau i ka wai, a e haumia hoi ia a hiki i ke ahiahi. ");
INSERT INTO haw1868_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","O ka mea hoi i pa i ka mea ana i noho ai maluna iho, e holoi no hoi oia i kona mau kapa, a e auau i ka wai, a e haumia hoi a hiki i ke ahiahi. ");
INSERT INTO haw1868_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Ina hoi he mea maluna o ka moe, a maluna o kahi ana i noho ai maluna iho, aia pa aku ke kanaka ia, e haumia ia a hiki i ke ahiahi. ");
INSERT INTO haw1868_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","A ina e moe ke kanaka me ia a pili kona koko ia ia, a haumia no ia i na la ehiku; a o ka moe a pau a ia kanaka i moe ai maluna iho, e haumia ia. ");
INSERT INTO haw1868_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","A ina he heekoko ko ka wahine i na la he nui mawaho o ka wa o kona kaawale ana, a ina e kahe hou no ia mahope o ka pau ana o kona wa kaawale, e like no hoi na la a pau o kona haumia me na la o kona kaawale ana, e haumia no ia. ");
INSERT INTO haw1868_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","O kela moe keia moe ana e moe ai i na la a pau o kona heekoko ana, e like no ia ia ia me ka moe o kona kaawale ana; a o ka mea ana i noho ai maluna iho, e haumia ia, e like me ka haumia o kona kaawale ana. ");
INSERT INTO haw1868_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","A o ka mea i pa ia mau mea, e haumia no ia, a e holoi i kona mau kapa, a e auau i ka wai, a e haumia hoi a hiki i ke ahiahi. ");
INSERT INTO haw1868_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Aka ina i hoomaemaeia oia i kona heekoko ana, alaila e helu oia nona i na la ehiku, a mahope iho e maemae no ia. ");
INSERT INTO haw1868_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","A i ka walu o ka la, e lawe oia nana i elua kuhukuku, a i ole ia, i elua manu nunu opiopio, a e hali mai i ke kahuna ma ka puka o ka halelewa o ke anaina. ");
INSERT INTO haw1868_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","A e kaumaha aku ke kahuna i kekahi i mohailawehala, a o kekahi i mohaikuni; a e hana ke kahuna i kalahala nona imua o Iehova no kona heekoko haumia. ");
INSERT INTO haw1868_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Pela e hookaawale ai oukou i na mamo a Iseraela mai ko lakou haumia ana, i ole ai lakou e make iloko o ko lakou haumia, i ko lakou hoohaumia ana i kuu halelewa iwaena o lakou. ");
INSERT INTO haw1868_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Oia ke kanawai no ka mea hilo, a no ka mea ua puka mailoko ae ona kona anoano i haumia ai oia; ");
INSERT INTO haw1868_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","A no ka wahine mai heekoko hoi, a me ka mea hilo; o ke kanaka, a o ka wahine, a me ka mea moe me ka wahine haumia. ");
INSERT INTO haw1868_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","OLELO mai la o Iehova ia Mose mahope iho o ka make ana o na keiki elua a Aarona, i ko laua kaumaha ana imua o Iehova a make iho la: ");
INSERT INTO haw1868_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","I mai la hoi o Iehova ia Mose, E olelo ae oe ia Aarona i kou kaikuaana, i ole ai ia e hele mai i na wa a pau iloko o kahi hoano, maloko o ka paku, ma ke alo o ka noho aloha, ka mea maluna o ka pahu, o make ia; no ka mea, e ikea au iloko o ke ao, maluna o ka noho aloha. ");
INSERT INTO haw1868_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Penei e komo ai o Aarona iloko o kahi hoano, me ka bipikane opiopio i mohailawehala, a me ka hipakane i mohaikuni. ");
INSERT INTO haw1868_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","E hookomo oia i kahi kapa komo olona hoano, a o ka lole wawae olona kahi ma kona io, a e kaeiia oia me ke kaei olona, a me ka papale olona oia e kahikoia'i: oia na kapa hoano; nolaila e holoi oia i kona io i ka wai, a pela e hookomo ai ia mau mea. ");
INSERT INTO haw1868_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","E lawe oia i na keiki kao elua o ke anaina o na mamo a Iseraela, i mohailawehala, a i ka hipakane i mohaikuni. ");
INSERT INTO haw1868_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","A e kaumaha o Aarona i kana bipikane he mohailawehala, ka mea nona iho, a e hana i kalahala nona iho, a i kalahala no kona ohana. ");
INSERT INTO haw1868_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","A e lawe oia i ua mau kao la elua, a e hoike hoi ia laua ma ke alo o Iehova, ma ka puka o ka halelewa o ke anaina. ");
INSERT INTO haw1868_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","A e hailona iho o Aarona no na kao elua, o kekahi no Iehova, o kekahi no ke I kao hele. ");
INSERT INTO haw1868_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","A e lawe mai o Aarona i ke kao i lilo no Iehova, a e kaumaha hoi ia i mohailawehala. ");
INSERT INTO haw1868_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Aka o ke kao i lilo i kao hele, oia ke hoike ola ia ma ke alo o Iehova, e hana i kalahala me ia, a e hookuuia'e e hele ia i kao kela iloko o ka waonahele. ");
INSERT INTO haw1868_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","A e lawe mai o Aarona i ka bipikane he mohailawehala, ka mea nona iho, a e hana oia i kalahala nona iho, a no kona ohana, a e pepehi hoi oia i ka bipikane o ka mohailawehala, ka mea nona iho. ");
INSERT INTO haw1868_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","A e lawe oia i hookahi ipu kapuwahi piha i na lanahu ahi e aa ana, mai luna iho o ke kuahu ma ke alo o Iehova, a me ka piha o kona mau lima i ka mea ala i hoowaliia, a e hali ae, iloko ae o ka paku. ");
INSERT INTO haw1868_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","A e kau oia i ka mea ala maluna iho o ke ahi ma ke alo o Iehova, i uhi ae ke ao o ka mea ala, i ka noho aloha maluna o ka berita, i ole ai ia e make. ");
INSERT INTO haw1868_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","E lawe hoi oia i kauwahi o ke koko o ka bipikane, a e pipi ae ia maluna o ka noho aloha, me kona mananianalima, ma ka hikina; a ma ke alo o ka noho aloha oia e pipi ae i ke koko, me kona manamanalima, ehiku ka pipi ana. ");
INSERT INTO haw1868_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Alaila e pepehi oia i ke kao, i ka mohailawehala no na kanaka, a e lawe mai i kona koko maloko o ka paku, a e hana me ia koko e like me kana i hana'i me ke koko o ka bipikane, a e pipi ae ia maluna o ka noho aloha, a ma ke alo o ka noho aloha. ");
INSERT INTO haw1868_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","A e hana oia i kalahala no kahi hoano, no ka haumia o na mamo a Iseraela, a no ko lakou mau hala ma ko lakou hewa a pau; a pela no oia e hana'i no ka halelewa o ke anaina, e waiho ana iwaena o lakou, iwaenakonu o ko lakou haumia. ");
INSERT INTO haw1868_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Aole loa he kanaka maloko o ka halelewa o ke anaina i kona wa e komo ai e hana i kalahala ma kahi hoano, a puka hou ia, a ua hana hoi oia i Kalahala nona iho, a no kona ohana, a no ke anaina a pau o ka Iseraela. ");
INSERT INTO haw1868_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","A e hele ae ia iwaho i ke kuahu, ka mea ma ke alo o Iehova, a e hana i kalahala nona; a e lawe oia i kauwahi o ke koko o ka bipikane, a me kauwahi o ke koko o ke kao, a e kau ma na pepeiaohao o ke kuahu a puni. ");
INSERT INTO haw1868_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","A e pipi oia i kauwahi o ke koko maluna ona, me kona manamanalima, ehiku ka pipi ana; a e hoomaemae ia mea, a e hoano hoi ia mai ka haumia o na mamo a Iseraela. ");
INSERT INTO haw1868_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","A pau kona huikala ana i kahi hoano, a me ka halelewa o ke anaina, a me ke kuahu, alaila e lawe mai oia i ke kao oia: ");
INSERT INTO haw1868_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","A e kau o Aarona i kona mau lima maluna o ke poo o ke kao ola: a e hai ae maluna ona i na hewa a pau o na mamo a Iseraela, a me ko lakou hala a pau, ma ko lakou lawehala ana a pau, e waiho ana ia mau mea ma ko poo o ke kao, a e hookuu aku ia ia ma ka lima o ke kanaka pono, iloko o ka waonahele. ");
INSERT INTO haw1868_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","A e hali aku ke kao i ko lakou hewa a pau maluna ona i ka aina kanaka ole; a e hookuu wale aku oia i ke kao iloko o ka waonahele. ");
INSERT INTO haw1868_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","A e komo o Aarona maloko o ka halelewa o ke anaina, a e hoohemo ae i kona kapa olona, ana i hookomo ai i kona wa i hele ai iloko o kahi hoano, a e waiho iho ia mau mea malaila. ");
INSERT INTO haw1868_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","A e holoi oia i kona io i ka wai, ma kahi hoano, a e hookomo oia i kona mau kapa, a e hele iwaho, a e kaumaha i kona mohaikuni, a me ka mohaikuni o na kanaka, a e hana hoi oia i kalahala nona iho, a no na kanaka. ");
INSERT INTO haw1868_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","A o ke kaikea o ka mohailawehala, oia kana e kuni ai maluna o ke kuahu. ");
INSERT INTO haw1868_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","A o ka mea nana i hookuu i ke kao i ka waoakua, e holoi oia i kona kapa, a e auau i ka wai, a mahope iho e hele mai ia iloko o kahi hoomoana. ");
INSERT INTO haw1868_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","A o ka bipikane, ka mohailawehala, a mo ke kao, ka mohailawehala, ua laweia ko laua koko iloko e hana i kalahala ma kahi hoano, oia ke laweia'e mawaho o kahi hoomoana; a e hoopau lakou i ke ahi i ko laua mau ili, a me ko laua io, a me ko laua lepo. ");
INSERT INTO haw1868_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","A o ka mea i puhi ia mau mea, e holoi oia i kona mau kapa, a e auau i ka wai, a mahope iho e hele mai ia iloko o kahi hoomoana. ");
INSERT INTO haw1868_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Eia hoi ke kanawai e mau ana no oukou; i ka hiku o ka malama, i ka la umi o ka malama, e hookaumaha i ko oukou mau uhane, aole e hana iki i ka hana, o ke kanaka o ko oukou aina iho, a o ka malihini e noho ana iwaena o oukou: ");
INSERT INTO haw1868_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","No ka mea, oia ka la e hana'i i kalahala no oukou, e huikala ai ia oukou i maemae oukou, mai ko oukou hewa a pau, imua o ke alo o Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","E lilo hoi ia i Sabati e maha'i no oukou, a e hookaumaha i ko oukou mau uhane, ma ke kanawai mau loa. ");
INSERT INTO haw1868_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","A o ke kahuna ana e poni ai, a e hoolaa ai, e hana ma ka oihanakahuna ma kahi o kona makuakane, oia ke hana i kalahala, a e hookomo i na kapa olona, i na kapa hoano. ");
INSERT INTO haw1868_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","A e hana oia i kalahala no ke keenakapu hoano, a e hana hoi oia i kalahala no ka halelewa o ke anaina, a me ke kuahu; a e hana hoi i kalahala no na kahuna, a me na kanaka a pau o ke anaina. ");
INSERT INTO haw1868_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","E lilo ia i kanawai mau loa no oukou, e hana i kalahala no na mamo a Iseraela no ko lakou hewa a pau, pakahi i ka makahiki. Hana iho la ia e like me ka Iehova kauoha ia Mose. ");
INSERT INTO haw1868_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","OLELO mai la hoi o Iehova ia Mose, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","E olelo ae oe ia Aarona a me kana mau keiki, a me na mamo a pau a Iseraela, a e i aku ia lakou; Eia ka mea a Iehova i kauoha mai ai, i ka i ana mai, ");
INSERT INTO haw1868_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","O kela kanaka, keia kanaka o ka ohana o Iseraela, nana i pepehi i ka bipikauo, a i ke keikihipa paha, a i ke kao paha, maloko o kahi hoomoana, a i pepehi ae paha ia mawaho o kahi hoomoana, ");
INSERT INTO haw1868_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","Aole hoi i lawe mai ia mea ma ka puka o ka halelewa o ke anaina, e kaumaha i ka mohai ia Iehova, ma ke alo o ka halelewa o Iehova; e hooiliia ke koko maluna o ia kanaka, ua hookahe oia i ke koko; a e okiia'ku ua kanaka la maiwaena aku o kona poe kanaka: ");
INSERT INTO haw1868_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","I mea e lawe mai ai na mamo a Iseraela i ka lakou mau mohai i kaumaha ai lakou ma ke kula, e lawe mai lakou ia mau mea ia Iehova, ma ka puka o ka halelewa o ke anaina, i ke kahuna, a e kaumaha ia mau mea i mau mohaihoomalu no Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","A e pipi ke kahuna i ke koko maluna o ke kuahu o Iehova, ma ka puka o ka halelewa o ke anaina, a e puhi i ke kaikea i mea ala ono no Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Aole e kaumaha hou lakou i ka lakou mau mohai i na daimonio, mamuli o ia mau mea lakou i hele moe kolohe ai. He kanawai e mau ana keia no lakou i ko lakou mau hanauna. ");
INSERT INTO haw1868_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","A e olelo aku oe ia lakou, O kela kanaka keia kanaka o ka ohana o Iseraela, a o na malihini e noho ana iwaena o oukou, o ka mea e kaumaha i mohaikuni a i alanapaha, ");
INSERT INTO haw1868_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","Aole nae e lawe mai ia ma ka puka o ka halelewa o ke anaina e kaumaha no Iehova; e okiia'ku ua kanaka la maiwaena aku o kona poekanaka. ");
INSERT INTO haw1868_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","A o kela kanaka keia kanaka o ka ohana o Iseraela, a o na malihini e noho ana iwaena o oukou, o ka mea e ai i kahi koko, e hooku e au i kuu maka i kela kanaka, a e oki aku au ia ia mai waena aku o kona poe kanaka. ");
INSERT INTO haw1868_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","No ka mea, iloko o ke koko ke ola o ka io, a ua haawi au ia mea ia oukou maluna o ke kuahu i mea e hana i kalahala no ko oukou mau uhane; no ka mea, o ke koko ka i hana i kalahala no ka uhane. ");
INSERT INTO haw1868_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Nolaila i olelo aku ai au i na mamo a Iseraela, Aole kekahi o oukou e ai i ke koko, aole hoi kekahi malihini e noho ana iwaena o oukou e ai i ke koko. ");
INSERT INTO haw1868_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","A o kela kanaka keia kanaka o na mamo a Iseraela, a o na malihini e noho ana iwaena o oukou, e huli ana a e paa ana i ka holoholona a i ka manu paha e pono ke aiia, e ninini oia i kona koko a e hoouhi me ka lepo. ");
INSERT INTO haw1868_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","No ka mea, o ke ola o ka io a pau, o ke koko ke ola nona. Nolaila i olelo aku ai au i na mamo a Iseraela, Aole oukou e ai i ke koko o kela io keia io; no ka mea, o ke koko ke ola o na io a pau: o ka mea e ai ia mea, e okiia'ku no ia. ");
INSERT INTO haw1868_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","A o ke kanaka nana e ai i ka mea make wale, a i ka mea paha i pepehiia e na holoholona, o ka mea o ko oukou aina ponoi, a o ka malihini paha, e holoi oia i kona mau kapa, e auau hoi i ka wai, a e haumia a hiki i ke ahiahi. ");
INSERT INTO haw1868_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Aka ina e holoi ole oia ia mau mea, aole hoi i hoauau i kona io; alaila maluna ona kona hewa. ");
INSERT INTO haw1868_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","OLELO mai la hoi o Iehova ia Mose, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","E olelo aku i na mamo a Iseraela, a e i aku ia lakou, Owau no Iehova ko oukou Akua. ");
INSERT INTO haw1868_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Mamuli o na hana a ka aina o Aigupita, kahi i noho ai oukou, aole oukou e hana aku; a mamuli o na hana a ka aina o Kanaana, kahi e lawe ae ai au ia oukou, aole oukou e hana aku; aole hoi oukou e hele ma ka lakou mau oihana. ");
INSERT INTO haw1868_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","E hana hoi oukou ma ko'u mau kanawai, a e malama i ka'u mau oihana, e hele malaila: owau no Iehova ko oukou Akua. ");
INSERT INTO haw1868_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Nolaila, e malama oukou i ka'u mau kauoha, a me ko'u mau kanawai: ina e hana ke kanaka ia, e ola no oia ia mau mea: owau no Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Aole kekahi o oukou e hookokoke aku i ka io o kona io iho; e wehe i kahi huna: owau no Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","O kahi huna o kou makuakane, a o kahi huna o kou makuwahine, mai wehe oe: o kou makuwahine no ia, mai wehe oe i kahi huna ona. ");
INSERT INTO haw1868_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","O kahi huna o ka wahine a kou makuakane, mai wehe oe: o kahi huna ia o kou makuakane. ");
INSERT INTO haw1868_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","O kahi huna o kou kaikuwahine, o ke kaikamahine a kou makuakane, o ke kaikamahine o kou makuwahine paha, ua hanau ma kou wahi noho paha, ua hanau ma kahi e paha, mai wehe oe i kahi huna o laua. ");
INSERT INTO haw1868_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","O kahi huna o ke kaikamahine a kau keikikane, a me ke kaikamahine a kau kaikamahine, mai wehe oe i kahi huna o laua: no ka mea, o ko laua, o kou wahi huna no ia. ");
INSERT INTO haw1868_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","O kahi huna o ke kaikamahine a ka wahine a kou makuakane, na kou makuakane i hanau, o kou kaikuwahine no ia, mai wehe oe i kona wahi huna. ");
INSERT INTO haw1868_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Mai wehe oe i kahi huna o ke kaikuwahine o kou makuakane, o ka io no ia o kou makuakane. ");
INSERT INTO haw1868_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Mai wehe oe i kahi huna o ka hoahanau wahine o kou makuwahine; no ka mea, o ka io no ia o kou makuwahine. ");
INSERT INTO haw1868_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Mai wehe oe i kahi huna o ka hoahanaukane o kou makuakane, mai hookokoke aku i kana wahine, he makuwahine ia nou. ");
INSERT INTO haw1868_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Mai wehe oe i kahi huna o kau hunonawahine: o ka wahine ia a kau keiki: mai wehe oe i kona wahi huna. ");
INSERT INTO haw1868_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Mai wehe oe i kahi huna o ka wahine a kou hoahanaukane; o kahi huna ia o kou hoahanaukane. ");
INSERT INTO haw1868_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Mai wehe oe i kahi huna o ka wahine a me kana kaikamahine, aole hoi oe e lawe i ke kaikamahine a kana keiki, aole hoi i ke kaikamahine a kana kaikamahine, e wehe i kona wahi huna; o kona io no lakou; he mea hewa ia. ");
INSERT INTO haw1868_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Mai lawe oe i ka wahine me kona hoahanauwahine pu, e hoino ia ia, i ka wehe i kona wahi huna, i ka wa e ola ana kela. ");
INSERT INTO haw1868_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Aole hoi oe e hookokoke aku i ka wahine e wehe i kona wahi huna, i ka wa e hookaawaleia'i ia no kona haumia. ");
INSERT INTO haw1868_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Mai moe oe i ka wahine a kou hoalauna, e hoohaumia iho ia oe iho me ia. ");
INSERT INTO haw1868_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Mai haawi i kahi keiki au e lilo ia Moleka, aole hoi oe e hoino i ka inoa o kou Akua: owau no Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Mai moe i ke kanaka, me he wahine la: he mea ia e inainaia. ");
INSERT INTO haw1868_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Aole hoi oe e moe i ka holoholona, e hoohaumia iho ia oe iho me ia; aole hoi e ku ka wahine imua o ka holoholona e moe iho ia ia; he mea haumia hilahila ia. ");
INSERT INTO haw1868_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Mai hoohaumia oukou ia oukou iho ma kekahi o keia mau mea, no ka mea, ma keia mau mea a pau ua haumia na lahuikanaka a'u e kipaku aku ai mai mua aku o oukou. ");
INSERT INTO haw1868_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Ua haumia ka aina; nolaila, ke hoopai nei au i kona hewa maluna iho ona, a ke luai aku nei no ka aina i kona poe kamaaina. ");
INSERT INTO haw1868_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","No ia mea, e malama oukou i ka'u mau kauoha a me ko'u mau kanawai, aole hoi e hana i kekahi o keia mau mea e inainaia, aole kekahi o ko oukou lahuikauaka, aole hoi o ka malihini e noho ana iwaena o oukou: ");
INSERT INTO haw1868_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","(No ka mea, ua hana na kanaka o ka aina mamua o oukou, i keia mau mea inainaia a pau, a ua haumia ka aina;) ");
INSERT INTO haw1868_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","I ole ai e luai aku ka aina ia oukou kekahi, i ka wa e hoohaumia ai oukou ia ia, e like me kona luai ana'ku i na lahuikanaka, ka poe mamua o oukou. ");
INSERT INTO haw1868_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","No ka mea o ka mea e hana i kekahi o keia mau mea inainaia, o na kanaka e hana, e okiia lakou maiwaena aku o ko lakou poe kanaka. ");
INSERT INTO haw1868_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Nolaila, e malama oukou i ka'u oihana, aole e hana ma keia mau hana inainaia, i hanaia mamua o oukou; aole hoi oukou e hoohaumia ia oukou iho malaila: owau no Iehova ko oukou Akua. ");
INSERT INTO haw1868_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","OLELO mai la hoi o Iehova ia Mose, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","E olelo aku oe i ke anaina a pau o na mamo a Iseraela, a e i aku ia lakou, I hemolele oukou; no ka mea, he hemolele no wau o Iehova ko oukou Akua. ");
INSERT INTO haw1868_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","E weliweli oukou kela kanaka keia kanaka i kona makuwahine a i kona makuakane, a e malama hoi i kuu mau Sabati: owau no Iehova ko oukou Akua. ");
INSERT INTO haw1868_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Mai huli oukou ma na kii, aole hoi e hana i na akua i hooheheeia no oukou: owau no Iehova ko oukou Akua. ");
INSERT INTO haw1868_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","A ina e kaumaha aku oukou i ka alana o na mohai hoomalu, ia Iehova, e kaumaha oukou ia na ko oukou makemake iho. ");
INSERT INTO haw1868_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","E aiia ia i ka la i kaumaha ai oukou ia mea, a ia la aku hoi; a ina e koe kauwahi i ke kolu o ka la, e hoopauia ia i ke ahi. ");
INSERT INTO haw1868_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","A ina e ai iki ia ia i ke kolu o ka la, e hoowahawahaia ia, aole e maliuia. ");
INSERT INTO haw1868_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Nolaila, o ka mea e ai ia, e kau no kona hewa maluna ona, no kana hoino ana i ka mea hoano no Iehova: a e okiia'ku kela kanaka maiwaena aku o kona poe kanaka. ");
INSERT INTO haw1868_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Aia oki oukou i ka ai o ko oukou aina, mai oki loa i na kihi o kau mahinaai aole hoi oe e hoiliili i na haulena o kau ai. ");
INSERT INTO haw1868_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Mai ohi loa i ko kau malawaina, aole hoi oe e hoiliili i na huawaina a pau loa o kau malawaina; e waiho no oe ia mau mea na ka mea ilihune, a me ka malihini: owau no Iehova ko oukou Akua. ");
INSERT INTO haw1868_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Mai aihue oukou, aole hoi e hookamani, aole hoi e hoopunipuni kekahi i kekahi. ");
INSERT INTO haw1868_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Mai hoohiki oukou ma ko'u inoa me ka wahahee, aole hoi oe e hoino i ka inoa o kou Akua; owau no Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Mai alunu oe i kou hoalauna, aole hoi oe e kaili wale: o ka uku o ka mea i hoolimalimaia, mai waiho pu me oe i ka po okoa a kakahiaka ae. ");
INSERT INTO haw1868_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Mai kuamuamu aku oe i ke kuli, aole hoi oe e waiho i ka mea e hina ai mamua o ka makapo, aka e makau oe i kou Akua; owau no Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Mai hana ino oukou ma ka hoopai ana; mai manao oe i ke kino o ka mea ilihune, aole hoi e mahalo i ke kino o ka mea ikaika: aka ma ka pololei e hooponopono ai oe i kou hoalauna. ");
INSERT INTO haw1868_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Mai hele oe io ia nei me he holoholo olelo la iwaena o kou poe kanaka; aole hoi oe e ku e i ke koko o kou hoalauna: owau no Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Mai inaina aku oe i kou hoahanau iloko o kou naau; e ao io aku no oe i kou hoalauna, aole hoi e waiho i ka hewa maluna ona. ");
INSERT INTO haw1868_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Mai hoomaau, mai hoomauhala i na keiki o kou poe kanaka; aka e aloha oe i kou hoalauna e like me oe iho: owau no Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","E malama oukou i ko'u mau kanawai Mai kuu aku oe e hoohanau kau holoholona me ka holoholona ano okoa; aole hoi oe e lulu i kou mahinaai, me na hua ano elua; aole hoi e kau i ke kapa olona me ka hulu hipa i huiia, maluna ou. ");
INSERT INTO haw1868_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","O ka mea moe aku i ka wahine, he kauwawahine, i hoopalauia na ke kane, aole i ukupanaiia, aole i haawiia ia ia ke ku i ka wa; e uhauia'na; aole e hoomakeia laua, no ka mea, aole i kaawale ia wahine. ");
INSERT INTO haw1868_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","A e lawe mai ua kanaka la i ka mohaihala ia Iehova, i ka puka o ka halelewa o ke anaina, he hipakane, i mohaihala. ");
INSERT INTO haw1868_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","A e hana ke kahuna i kalahala nona me ka hipakane mohaihala, ma ke alo o Iehova, no kona hewa ana i hana'i; a e kalaia kona hewa ana i hana'i. ");
INSERT INTO haw1868_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","A komo oukou i ka aina, a kanu i kela laau i keia laau i mea ai, alaila e kapa ae oukou i kona hua he okipoepoe ole ia; ekolu makahiki he okipoepoe ole ia ia ia oukou; aole e aiia. ");
INSERT INTO haw1868_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Aka i ka ha o ka makahiki, e hoano ko na hua a pau, i mea e hoolea ai ia Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","A i ka lima o ka makahiki, e ai oukou i kona hua, e haawi ai oia i kona hua ia oukou: owau no Iehova ko oukou Akua. ");
INSERT INTO haw1868_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Mai ai oukou me ke koko: aole hoi e kuka-moo, aole hoi e nana-ao. ");
INSERT INTO haw1868_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Mai hoopoepoe i na kihi o ko oukou mau poo, aole hoi oe e hoino i na kihi o kou umiumi. ");
INSERT INTO haw1868_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Mai okioki i ko oukou io no ka mea make, aole hoi e kakau kaha ma ko oukou kino: owau no Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Mai hoonoa i kau kaikamahine e hoolilo ia ia i hookamakama; o lilo ka aina i ka moe kolohe, a piha ae la ka aina i ka hewa. ");
INSERT INTO haw1868_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","E malama oukou i ko'u mau Sabati, a e mahalo i ko'u keenakapu: owau no Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Mai manao oukou i na mea ninau-uhane, aole hoi e imi aku i na kupua, e haumia ai oukou ia lakou: owau no Iehova ko oukou Akua. ");
INSERT INTO haw1868_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Ma ke alo o ke poohina, e ku ae ai oe iluna, a e mahalo aku i ke alo o ka elemakule, a e weliweli i kou Akua: owau no Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","A ina e noho ka malihini me oe ma ko oukou aina, mai hooluhihewa ia ia. ");
INSERT INTO haw1868_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Aka o ka malihini e noho ana me oukou, e like auanei ia ia oukou me he kupa la i hanau iwaena o oukou, a e aloha oe ia ia e like me oe iho; no ka mea, he mau malihini no oukou ma ka aina o Aigupita: owau no Iehova ko oukou Akua. ");
INSERT INTO haw1868_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Mai hana kekee oukou i ka hooponopono ana, ma ke ana ana, ma ka paona, a ma ke ana. ");
INSERT INTO haw1868_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","E malama no oukou i paona pololei, i poka pono, i epa pono, i hina pono; owau no Iehova ko oukou Akua nana oukou i lawe mai, mailoko mai o ka aina o Aigupita. ");
INSERT INTO haw1868_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Nolaila, e malama oukou i ka'u mau kauoha a pau, a me ko'u mau kanawai a pau, a e hana ma ia mau mea; owau no Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","OLELO mai la o Iehova ia Mose, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","E olelo hou aku oe i na mamo a Iseraela, O kela kanaka keia kanaka, o na mamo a Iseraela, a o na malihini e noho ana ma ka Iseraela, nana e haawi i kahi keiki ana ia Moleka, e make io no ua kanaka la; na na kanaka o ka aina ia e hailuku aku me na pohaku. ");
INSERT INTO haw1868_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","A e hooku e au i ko'u maka i kela kanaka, a e oki aku hoi au ia ia maiwaena aku o kona poe kanaka, no kona haawi ana i kekahi keiki ana ia Moleka; e hoohaumia i kuu keenakapu, a me ka hoino i ko'u inoa hoano. ");
INSERT INTO haw1868_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","A ina e huna iki na kanaka o ka aina i ko lakou mau maka i na kanaka la, i kona wa e haawi ai i kekahi keiki ana ia Moleka, aole hoi hoomake ia ia; ");
INSERT INTO haw1868_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","Alaila, na'u no e hooku e i kuu maka i ua kanaka la a me kona ohana, a e oki aku au ia ia, a me ka poe a pau e hele moe kolohe mamuli ona, e moe kolohe me Moleka, maiwaena aku o ko lakou poe kanaka. ");
INSERT INTO haw1868_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","A o ke kanaka huli mamuli o na mea ninau-uhane, a mamuli hoi o na kupua, e hele moe kolohe mamuli o lakou, e hooku e au i kuu maka i kela kanaka, a e oki aku hoi au ia ia maiwaena aku o kona poe kanaka. ");
INSERT INTO haw1868_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Nolaila, e huikala oukou ia oukou iho, i hoano hoi oukou: no ka mea, owau no Iehova ko oukou Akua. ");
INSERT INTO haw1868_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","E malama oukou i ko'u mau kanawai, a e hana hoi ma ia mau mea: owau no Iehova nana oukou e hoolaa nei. ");
INSERT INTO haw1868_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","No ka mea, o kela kanaka keia kanaka i kuamuamu i kona makuakane a i kona makuwahine paha, e make io no ia: ua hoino aku oia i kona makuakane, a i kona makuwahine paha; maluna ona kona koko iho. ");
INSERT INTO haw1868_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","O ke kanaka moe kolohe aku i ka wahine a kekahi kanaka, o ka mea moe kolohe i ka wahine a kona hoalauna, e make io no ke kanaka moe kolohe a me ka wahine moe kolohe. ");
INSERT INTO haw1868_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","O ke kanaka moe me ka wahine a kona makuakane, ua wehe ae oia i kahi huna o kona makuakane; e make io no laua pu; maluna o laua ko laua koko iho. ");
INSERT INTO haw1868_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Ina e moe ke kanaka me kana hunonawahine, e make io no laua pu, ua hana laua i ka mea haumia hilahila; maluna o laua ko laua koko iho. ");
INSERT INTO haw1868_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Ina e moe aku ke kanaka i ke kane e like me kona moe aku i ka wahine, ua hana pu laua i ka mea haumia hilahila; e make io no laua pu; maluna o laua ko laua koko. ");
INSERT INTO haw1868_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Ina e mare ke kanaka i ka wahine a me kona makuwahine, he hewa ia: e puhi pu ia lakou i ke ahi, oia pu me laua la; i ole ai he hewa iwaena o oukou. ");
INSERT INTO haw1868_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","A ina e moe ke kanaka i ka holoholona, e make io no ia; a e pepehi oukou ia holoholona. ");
INSERT INTO haw1868_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","A ina e hookokoke aku ka wahine i ka holoholona e moe iho ia ia, e pepehi oe ia wahine, a me ka holoholona: e make io no laua pu; maluna o laua ko laua koko. ");
INSERT INTO haw1868_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","A ina e lawe ke kanaka i kona kaikuwahine, i ke kaikamahine a kona makuakane, a i ke kaikamahine a kona makuwahine paha, a ike aku i kona wahi huna, a ike mai kela i kona wahi huna, he mea hewa io no ia; e okiia laua ma ke alo o ko laua poe kanaka: ua wehe oia i kahi huna o kona kaikuwahine; e kau no kona hewa maluna ona. ");
INSERT INTO haw1868_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","A ina e moe aku ke kanaka i ka wahine i kona mai ana, a wehe ae i kona wahi huna; ua wehe ae ia i kona punawai, a ua wehe ae ia wahine i ke kumu o kona koko, e oki pu ia'ku hoi laua maiwaena aku o ko laua poe kanaka. ");
INSERT INTO haw1868_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Mai wehe oe i kahi huna o ka hoahanauwahine o kou makuwahine, a o ke kaikuwahine a kou makuakane paha; no ka mea, oia ka wehe i kona io iho; e kau no ko laua hewa maluna o laua. ");
INSERT INTO haw1868_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","A ina e moe aku ke kanaka me ka wahine a ka hoahanaukane o kona makuakane, ua wehe ae oia i kahi huna o kela makuakane; e kau no ko laua hewa maluna o laua, e make keiki ole laua. ");
INSERT INTO haw1868_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","A ina e lawe ke kanaka, i ka wahine a kona hoahanaukane, he mea haumia ia; ua wehe ae oia i kahi huna o kona hoahanaukane, aole aku keiki a laua. ");
INSERT INTO haw1868_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","Nolaila, e malama oukou I ka'u mau kauoha a pau, a me ko'u mau kanawai a pau; i ole ai ka aina kahi a'u e lawe aku ai ia oukou e noho malaila, e luai aku ia oukou. ");
INSERT INTO haw1868_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Mai hele oukou ma na oihana a na lahuikanaka, a'u e kiola aku ai imua o oukou: no ka mea, ua hana lakou i keia mau mea a pau, nolaila i hoowahawaha aku ai au ia lakou. ");
INSERT INTO haw1868_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Aka, ua olelo aku au ia oukou, e loaa ia oukou ko lakou aina; na'u ia e haawi aku no oukou ponoi, he aina e kahe ai ka waiu a me ka meli: owau no Iehova ko oukou Akua nana oukou i hookaawale ae mai na lahuikanaka e ae. ");
INSERT INTO haw1868_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Nolaila e hookaawale ae oukou iwaena o na holoholona maemae, a me ka haumia, a mawaena o na manu haumia, a me ka maemae: mai hoohaumia i ko oukou mau uhane ma kahi holoholona, a me kahi manu, a me kahi mea e kolo ana ma ka lepo, na mea a'u i hookaawale ae mai o oukou ae, me he haumia la. ");
INSERT INTO haw1868_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","E hoano hoi oukou no'u; no ka mea, he hoano no wau, o Iehova, a ua hookaawale ae au ia oukou mai na lahuikanaka e i lilo oukou no'u. ");
INSERT INTO haw1868_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","O ke kanaka, a o ka wahine paha, he ninau-uhane, a he kupua paha, e make no ia; e hailuku lakou ia laua me na pohaku; e kau no ko laua koko maluna o laua. ");
INSERT INTO haw1868_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","OLELO mai la hoi o Iehova ia Mose, E olelo aku i na kahuna, i na keiki a Aarona, a e i aku ia lakou, Aohe kanaka e hoohaumiaia no ka make iwaena o kona poe kanaka: ");
INSERT INTO haw1868_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","Aka no kona io iho, no ka mea kokoke mai ia ia, no kona makuwahine, a me kona makuakane a me kana keiki, a me kana kaikamahine, a me kona hoahanaukane, ");
INSERT INTO haw1868_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","A me kona kaikuwahine, he puupaa, i kokoke mai ia ia, aole i loaa la ia ke kane, e hiki no ke hoohaumiaia oia nona. ");
INSERT INTO haw1868_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Aole e hoohaumia oia ia ia iho, he haku iwaena o kona poe kanaka, e hoino ia ia iho. ");
INSERT INTO haw1868_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Aole lakou e hooohule i ko lakou mau poo, aole hoi e kahi i na kihi o ko lakou umiumi, aole hoi e okioki i ko lakou io iho. ");
INSERT INTO haw1868_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","E hoano auanei lakou i ko lakou Akua, aole hoi e hoohaumia i ka inoa o ko lakou Akua; no ka mea, o na mohai o Iehova i kaumahaia ma ke ahi, a me ka berena ua ko lakou Akua, oia ka lakou i kaumaha ai, nolaila, e pono ko hoano lakou. ");
INSERT INTO haw1868_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Aole lakou e lawe i ka wahine hookamakama, a he haumia paha; aole hoi lakou e lawe i ka wahine i hookaawaleia'e mai kana kane ae; no ka mea, he hoano oia i kona Akua. ");
INSERT INTO haw1868_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Nolaila e hoano oe ia ia, no ka mea, o ka berena na kou Akua kana i kaumaha'i; e hoano auanei oia ia oe; no ka mea, he hoano no wau o Iehova kou Akua nana oukou i hoano. ");
INSERT INTO haw1868_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","O ke kaikamahine a ke kahuna pule, ina e hoohaumia oia ia ia iho i ka moe kolohe, ua hoohaumia oia i kona makuakane; e puhiia oia i ke ahi. ");
INSERT INTO haw1868_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","A o ke kahuna nui iwaena o kona poe hoahanau, maluna iho o kona poo i nininiia ka aila poni, a ua hoolaaia e komo i ke kapa, aole hoi e uhae i kona mau kapa; ");
INSERT INTO haw1868_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Aole hoi e komo ae i ka mea i make, aole hoi no kona makuakane, a no kona makuwahine paha, e hoohaumia ai oia ia ia iho. ");
INSERT INTO haw1868_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Aole hoi oia e puka ae iwaho o ke keenakapu, aole hoi e hoohaumia i ke keenakapu o kona Akua; no ka mea, maluna ona ka lei o ka aila poni o kona Akua: owau no Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","E mare no hoi oia i ka wahine i kona puupaa ana. ");
INSERT INTO haw1868_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","O ka wahine kane make, a o ka wahine hemo, a o ka haumia, o ka hookamakama, oia mau mea kaua e lawe ole ai; aka e lawe oia i ka wahine puupaa o kona poe kanaka i wahine. ");
INSERT INTO haw1868_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Aole hoi oia e hoohaumia i kana keiki iwaena o kona poe kanaka; no ka mea, ke hoano nei au o Iehova ia ia. ");
INSERT INTO haw1868_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Olelo mai la hoi o Iehova ia Mose, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","E olelo aku oe ia Aarona, penei, O ka mea o kau mau keiki i ko lakou hanauna, he kina kona, aole ia e hookokoke e kaumaha i ka berena a kona Akua: ");
INSERT INTO haw1868_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","No ka mea, o kela kanaka keia kanaka he kina kona, aole ia e hookokoke mai: o ke kanaka makapo, o ka oona, o ka ihu pepe, a he lala oi aku kona, ");
INSERT INTO haw1868_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","A o ke kanaka ua hai kona wawae, a ua hai kona lima paha, ");
INSERT INTO haw1868_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","A he kuapuu, a he aa, a he kina, ma kona maka, a he puupuu, a he kakio, a he hua pepeia; ");
INSERT INTO haw1868_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","O kela kanaka keia kanaka o na keiki a Aarona he kina kona, aole ia e hookokoke mai e kaumaha i na mohai no Iehova i kaumahaia ma ke ahi; he kina kona, aole ia e hele kokoke mai e kaumaha i ka berena a kona Akua. ");
INSERT INTO haw1868_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","O ka berena a kona Akua, o ka mea hoano loa, a me ka mea hoano, oia kana e ai ai. ");
INSERT INTO haw1868_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Aole hoi ia o komo i ka paku, aole hoi e hookokoke i ke kuahu, no kona kina ana; o hoohaumia oia i kuu mau keenakapu: no ka mea, na'u na Iehova lakou e hoano nei. ");
INSERT INTO haw1868_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","A hai ae la o Mose ia Aarona, a i kana mau keiki, a i na mamo a pau a Iseraela. ");
INSERT INTO haw1868_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","OLELO mai la hoi o Iehova ia Mose, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","E olelo aku ia Aarona, a i kana mau keiki, e hookaawale lakou ia lakou iho mai na mea hoano o na mamo a Iseraela, i ole ai lakou e hoino mai i ko'u inoa hoano i na mea a lakou i hoano mai ai no'u; owau no Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","E olelo aku ia lakou, O ka mea o ka oukou mau keiki a pau iwaena o ko oukou mau hanauna, e hele i na mea hoano a na mamo a Iseraela i hoolaa aku ai ia Iehova, me kona haumia maluna ona, e okiia'ku oia mai ko'u alo aku: owau no Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","O kela kanaka, keia kanaka he keiki a Aarona, he lepero, a he hilo kahe kona; aole ia e ai i na mea hoano a hiki i kona maemae ana. A o ke kanaka hoopa aku i ka mea haumia no ka mea make, a o ke kanaka ua hele aku kona anoano mai ona aku; ");
INSERT INTO haw1868_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","A o ke kanaka hoopa aku i ka mea kolo e haumia ai, a i ke kanaka paha e haumia ai, o kela haumia keia haumia kona; ");
INSERT INTO haw1868_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","O ke kanaka i pa aku i kekahi o ia mau mea, e haumia no ia a hiki i ke ahiahi, aole ia e ai i na mea hoano, ke holoi ole oia i kona io i ka wai. ");
INSERT INTO haw1868_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","A napoo ka la, e maemae no ia, a mahope iho e ai no oia i na mea hoano; no ka mea, o kana ai no ia. ");
INSERT INTO haw1868_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","O ka mea make wale, a o ka mea i nahaeia, aole oia e ai ia, e hoohauraia'i ia ia iho: owau no Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","E malama hoi lakou i ka'u oihana, o hooili lakou i ka hewa maluna ona, a make, ke hoohaumia Iakou ia mea: na'u ua Iehova lakou e hoano nei. ");
INSERT INTO haw1868_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Aole e ai ka malihini i ka mea hoano; o ko ke kahuna mea e noho malihini mai, a o ke kauwa hoolimalima, aole no e ai i ka mea hoano. ");
INSERT INTO haw1868_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Aka ina e kuai ke kahuna i ke kanaka me kana kala, e ai no oia ia, a me ka mea i hanau maloko o kona hale; o lakou ke ai i kana ai. ");
INSERT INTO haw1868_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Ina e mare ke kaikamahine a ke kahuna i ka malihini, aole oia e ai i ka alana o na mea hoano. ");
INSERT INTO haw1868_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Aka ina he wahinekanemake ke kaikamahine a ke kahuna, a ua hemo paha me ke keiki ole, a ua hoi mai i ka hale o kona makuakane, e like me kona wa kamalii, e ai no oia i ka ai a kona makuakane; aka aole ka malihini e ai ia mea. ");
INSERT INTO haw1868_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","A ina e ai ke kanaka i ka mea hoano, me ka ike ole, alaila e hui aku oia i ka hapa lima me ia, a e haawi aku i ke kahuna me ka mea hoano. ");
INSERT INTO haw1868_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Aole lakou e hoohaumia i ka na mamo a Iseraela mau mea hoano a lakou i hoolaa ai ia Iehova: ");
INSERT INTO haw1868_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","Aole hoi e waiho aku maluna o lakou i ka hewa o ka lawehala ana, i ka lakou ai ana i na mea hoano; no ka mea, na'u na Iehova lakou e hoano nei. ");
INSERT INTO haw1868_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Olelo mai la hoi o Iehova ia Mose, penei, ");
INSERT INTO haw1868_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","E olelo aku oe ia Aarona, a i kana mau keiki, a i na mamo a pau a Iseraela, a e i aku ia lakou, O kela kanaka keia kanaka o ka ohana o Iseraela, a o na malihini iloko o ka Iseraela, nana e kaumaha i kona mohai no kona hoohiki ana a pau, a no kana mau alana na kona makemake, ka mea a lakou e kaumaha'i ia Iehova, imohaikuni: ");
INSERT INTO haw1868_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","Na ko oukou makemake iho, i ke kane kina ole o na bipi, o na hipa, a o na kao. ");
INSERT INTO haw1868_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","O ka mea kina, aole oukou e kaumaha ia; no ka mea, aole ia e maliuia no oukou. ");
INSERT INTO haw1868_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","A o ke kanaka nana e kaumaha i ka alana o na mahaihoomalu ia Iehova, e hooko ai i kana i hoohiki ai, a ina he mohai na kona makemake, o na bipi, a o na hipa paha, e hemolele ia e maliuia'i: aole aku kina iloko ona. ");
INSERT INTO haw1868_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","O ka makapaa, o ka oopa, a he puu kona, he puupuu, he kakio, aole oukou e kaumaha ia mau mea ia Iehova, aole hoi e hoolilo ia mau mea i mohai e kaumahaia ma ke ahi maluna o ke kuahu ia Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","O ka bipikane, a o ka hipakeiki, he oi aku ko ka lala ona, he hemahema paha, e hiki no ke kaumaha oe ia i mohai na kou makemake no; aka no ka hoohiki ana aole e maliuia'ku ia. ");
INSERT INTO haw1868_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","O ka mea i pepeia, a i paopaoia, a uhaeia, a i poaia, aole oukou e kaumaha ia mea ia Iehova, aole oukou e hana ma ko oukou aina. ");
INSERT INTO haw1868_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Aole hoi noloko mai a ko ka malihini lima, e kaumaha ai oukou i ka berena a ko oukou Akua, no keia mau mea; no ka mea, iloko o lakou ko lakou popopo, he mau kina iloko o lakou; aole e maliuia no oukou. ");
INSERT INTO haw1868_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Olelo mai la hoi o Iehova ia Mose, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","Aia hanau ka bipikane, a he hipa paha, a he kao paha, alaila e noho ia malalo iho o ka makua, i na la ehiku; a mai ka walu o ka la, a mahope aku e maliuia'i ia i mohai puhi no Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Ina he bipiwahine, a he hipawahine paha, aole oukou e pepehi pu ia mea me kana keiki i ka la hookahi. ");
INSERT INTO haw1868_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Aia kaumaha aku oukou i ka mohai aloha ia Iehova, e kaumaha oukou ia ua ko oukou makemake no. ");
INSERT INTO haw1868_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Ia la hookahi no, e aiia ia, aole e hookoe oukou i kauwahi ona a ao ae: owau no Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Nolaila e malama oukou i ka'u mau kauoha, a e hana ma ia mau mea: owau no Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Aole hoi oukou e hoino i ko'u inoa hoano; e hoanoia no wau iwaena o na mamo a Iseraela; owau no Iehova nana oukou e hoano nei, ");
INSERT INTO haw1868_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Nana hoi oukoa i lawe mai mai ka aina o Aigupita mai i Akua au no oukou: owau no Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","OLELO mai la hoi o Iehova ia Mose, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","E olelo aku i na mamo a Iseraela, a e i aku ia lakou, o na ahaaina a oukou e kala ai he mau houluulu hoano, no'u no ia mau ahaaina. ");
INSERT INTO haw1868_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","I na la eono, e hanaia'i ka hana, aka o ka hiku o ka la, he Sabati e hoomaha'i ia, he houluulu hoano: aole oukou e hana: he Sabati ia no Iehova maloko o ko oukou mau hale a pau. ");
INSERT INTO haw1868_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Eia na ahaaina a Iehova, na houluulu hoano a oukou e kala ai i ko lakou wa pono. ");
INSERT INTO haw1868_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","I ka la umikumamaha o ka malama mua, i ke ahiahi, ilaila ka moliaola a Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","A i ka la umikumamalima o ia malama no, ka ahaaina o ka berena huole, no Iehova; ehiku la e ai ai oukou i ka berena huole. ");
INSERT INTO haw1868_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","I ka la mua, he houluulu hoano ko oukou, aole oukou e hana i ka hana e luhi ai ilaila: ");
INSERT INTO haw1868_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Aka e kaumaha oukou i ka mohai puhi ia Iehova i na la ehiku: a i ka hiku o ka la, he houluulu hoano, aole oukou e hana i ka hana e luhi ai. ");
INSERT INTO haw1868_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Olelo mai la hoi o Iehova ia Mose, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","E olelo aku i na mamo a Iseraela, a e i aku ia lakou, Aia komo oukou i ka aina a'u e haawi aku ai ia oukou, a okioki hoi i ka ai ona, alaila e lawe mai oukou i ka pua hua mua o ka oukou ai i ke kahuna. ");
INSERT INTO haw1868_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","A e hoali ae oia i ka pua imua i ke alo o Iehova, e maliuia'i ia no oukou: i ka la e noa ai ka Sabati, e hoali ai ke kahuna. ");
INSERT INTO haw1868_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","A e kaumaha oukou ia la o oukou i hooluli ai i ka pua, i keikihipakane kina ole o ka makahiki hookahi, i mohaikuni no Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","A o kona mohai ai, elua hapa umi dila o ka palaoa wali i hui pu me ka aila, he mohai puhi no Iehova, i mea ala ono: a o kona mohai inu, he waina, he hapa ha o ka hina. ");
INSERT INTO haw1868_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","A o ka berena, a o ka hua palaoa moa, a o ka hua maka, aole oukou e ai a hiki i ka la i lawe mai ai oukou i ka mohai i ko oukou Akua; he kanawai mau loa ia i ko oukou mau hanauna, iloko o ko oukou mau hale a pau loa, ");
INSERT INTO haw1868_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","A e helu oukou no oukou iho mai ka la e noa ai ka Sabati, mai ka la i lawe mai ai oukou i ka pua i mohai hoali; ehiku Sabati e pau ai. ");
INSERT INTO haw1868_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","A hiki i ka la e noa ai ka Sabati ahiku, e helu ai oukou i na la he kanalima, a e haawi hou i mohaiai hou ia Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","E lawe mai hoi oukou i elua popo berena hooluli elua hapa umi dila, he palaoa wali ia, e hoomoaia ia me ka hu; he mau hua mua ia no Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","A e kaumaha oukou me ka berena, i ehiku keikihipa kina ole o ka makahiki mua, a i hookahi bipikane opiopio, a i elua hipakane: e lilo ia i mohaikuni no Iehova, me ko lakou mohai ai, me ko lakou mohai inu, he alana e kaumahaia ma ke ahi, he mea ala ono no Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Alaila e kaumaha oukou i hookahi keikikao, i mohailawehala, a i elua keikihipa o ka makahiki mua, i alana o ua mohaihoomalu. ");
INSERT INTO haw1868_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","A e hoali ke kahuna ia mau mea me ka berena o na hua mua i mohai hoali ma ke alo o Iehova, me na keikihipa elua: e laa ia no Iehova na ke kahuna. ");
INSERT INTO haw1868_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","E hai aku oukou ia la i'houluulu hoano no oukou: aole oukou e hana i ka hana e luhi ai. He kanawai mau loa iloko o ko oukou mau hale a pau, i ko oukou mau hanauna. ");
INSERT INTO haw1868_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Aia e okioki oukou i ka ai o ko oukou aina, mai oki loa i na kihi o kau mahinaai, i kou oki ana. aole hoi oe e ohi i na haulena o kau ai: e waiho no oe pela na ka poe ilihune, a na ka malihini; owau no Iehova ko oukou Akua. ");
INSERT INTO haw1868_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Olelo mai la hoi o Iehova ia Mose, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","E olelo aku oe i na mamo a Iseraela, penei, I ka hiku o ka malama, i ka la mua o ka malama, he Sabati ko oukou, he la laa e hookani ai i na pu, he houluulu hoano: ");
INSERT INTO haw1868_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Mai hana i ka hana e luhi ai, aka e kaumaha i ka mohai puhi ia Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Olelo mai la hoi o Iehova ia Mose, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","A i ka umi o ka la o ua malama ahiku nei, he la kalahala; he houluulu hoano ia no oukou, a e hookaumaha oukou i ko oukou mau uhane, a e kaumaha i ka mohai puhi ia Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Aole hana a oukou e hana'i i ua la la; no ka mea, he la kalahala ia, e hana'i i kalahala no oukou ma ke alo o Iehova ko oukou Akua. ");
INSERT INTO haw1868_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","O kela uhane keia uhane i hookaumaha ole ia i ua la la, e okiia'ku ia maiwaena aku o kona poe kanaka. ");
INSERT INTO haw1868_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","A o kela kanaka keia kanaka e hana i ka hana i ua la la, o ia kanaka ka'u e hooki aku ai maiwaena aku o kona poe kanaka. ");
INSERT INTO haw1868_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Mai hana iki oukou i ka hana: he kanawai mau loa i ko oukou mau hanauna iloko o ko oukou mau hale a pau. ");
INSERT INTO haw1868_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","E lilo ia i Sabati e hoomaha ai, a e hookaumaha oukou i ko oukou mau uhane; i ka iwa o ka la o ka malama, i ke ahiahi, mai ke ahiahi a hiki i ke ahiahi, e malama ai oukou i ko oukou Sabati. ");
INSERT INTO haw1868_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Olelo mai la hoi o Iehova ia Mose, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","E olelo aku oe i na mamo a Iseraela, penei, I ka la umikumamalima o ua malama ahiku nei, he ahaaipa kauhalelewa i na la ehiku no Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","I ka la mua, he houluulu hoano, mai hana oukou i ka hana e luhi ai. ");
INSERT INTO haw1868_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","I na la ehiku e kaumaha ai oukou i ka mohai puhi ia Iehova: i ka walu o ka la he houluulu hoano ia oukou, a e kaumaha oukou i ka mohai puhi ia Iehova, he anaina hoano, aole hoi oukou e hana i ka hana e luhi ai. ");
INSERT INTO haw1868_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Oia na ahaaina a Iehova, a oukou e hai aku ai he mau houluulu hoano, e kaumaha ai i ka mohai puhi ia Iehova, i ka mohaikuni, i ka mohaiai, i ka alana a me na mohaiinu, kela mea keia mea i kona la iho: ");
INSERT INTO haw1868_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Okoa na Sabati o Iehova; okoa hoi ko oukou mea haawi; okoa hoi ka oukou mau mea hoohiki a pau; okoa hoi ka oukou mau mohai na ka makemake, a oukou e haawi wale ia Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","A i ka la umikumamalima o ka malama ahiku, aia houluulu oukou i ka hua o ka aina, e ahaaina oukou no Iehova i na la ehiku; i ka la mua, he Sabati, a i ka la awalu, he Sabati. ");
INSERT INTO haw1868_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","E lawe hoi oukou no oukou iho i ka la mua i na lala o na laau maikai, i na lala o na laau pama, a me na lala o na laau momona, a me na wilou o ke kahawai; a e hauoli ae oukou ma ke alo o Iehova ko oukou Akua i na la ehiku. ");
INSERT INTO haw1868_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","E malama oukou ia i ahaaina no. Iehova, i na la ehiku o ka makahiki; he kanawai mau loa i ko oukou mau hanauna; i ka hiku o ka malama e ahaaina ai oukou ia. ");
INSERT INTO haw1868_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","E noho oukou iloko o na halelalalaau i na la ehiku; o na mea a pau i hanau he poe Iseraela, e noho no lakou iloko o ua halelalalaau: ");
INSERT INTO haw1868_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","I ike ko oukou mau hanauna, ua hoonoho au i na mamo a Iseraela iloko o na halelalalaan, i ka wa i lawe mai ai au ia lakou mai ka aina mai o Aigupita: owau no Iehova ko oukou Akua. ");
INSERT INTO haw1868_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","A hai aku la o Mose i na ahaaina a Iehova i na mamo a Iseraela. ");
INSERT INTO haw1868_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","OLELO mai la o Iehova ia Mose, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","E kauoha oe i na mamo a Iseraela, e lawe mai ia oe i ka aila oliva maemae i kuiia, i malamalama, e mau ai ka aa ana o na ipukukui. ");
INSERT INTO haw1868_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Mawaho o ka paku o ka mea hoike, iloko o ka halelewa o ke anaina, e hooponopono mau ai o Aarona ia mai ke ahiahi a kakahiaka ma ke alo o Iehova; he kanawai mau ia i ko oukou mau hanauna. ");
INSERT INTO haw1868_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","E hooponopono mau oia i na kukui maluna o ka ipukukui maemae imua o Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","A e lawe oe i ka palaoa wali, a e hoomoa i na popo ona he umikumamalua; elua hapaumi dila iloko o ka popo hookahi. ");
INSERT INTO haw1868_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","A e hoonoho oe ia mau mea ma na lalani elua, eono i ka lalani hookahi, maluna o ka papa maemae, ma ke alo o Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","A e kau aku oe i ka mea ala maemae maluna o na lalani, i kau ia maluna o ka berena i mea hoomanao, he mohai puhi no Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","I kela Sabati keia Sabati e hoonoho mau ai oia ia mea ma ke alo o Iehova, na na mamo mai a Iseraela, ma ka berita mau loa. ");
INSERT INTO haw1868_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","E lilo hoi ia na Aarona a na kana mau keiki, a e ai lakou ia ma kahi hoano; no ka mea, he hoano loa ia nona, no na mohai puhi no Iehova ma ke kanawai mau loa. ");
INSERT INTO haw1868_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","A o ke keiki a ka wahine o ka Iseraela, he kanaka Aigupita kona makuakane, ua hele ae ia iwaena o na mamo a Iseraela: a o keia keiki a ka Iseraela, a me kekahi kanaka Iseraela, ua hakaka pu i kahi hoomoana; ");
INSERT INTO haw1868_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","A ua hoino wale ke keiki a ka wahine Iseraela, i ka Inoa, a ua kuamuamu hoi; a lawe mai lakou ia ia io Mose la: (o Selomita ka inoa o kona makuwahine, ke kaikamahine a Diberi, no ka ohana a Dana:) ");
INSERT INTO haw1868_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Hahao ae la lakou ia ia i kahi e paa ai, i hoikeia mai ka manao o Iehova ia lakou. ");
INSERT INTO haw1868_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Olelo mai la hoi o Iehova ia Mose, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","E lawe ae i ka mea kuamuamu mawaho ae o kahi hoomoana; a o ka poe a pau i lohe, e kau ko lakou mau lima maluna o kona poo, a e hailuku ke anaina a pau ia ia. ");
INSERT INTO haw1868_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","E olelo hoi oe i na mamo a Iseraela, penei, O kela kanaka keia kanaka i kuamuamu i kona Akua, e kau no kona hewa maluna ona iho. ");
INSERT INTO haw1868_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","A o ka mea hoino wale i ka ihoa o Iehova, e make io no ia; e hailuku io aku ke anaina a pau ia ia; o ka malihini, e like pu me ke kamaaina, i ka wa e hoino ai i ka Inoa, e make no ia. ");
INSERT INTO haw1868_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","A o ka mea pepehi i ke kanaka, e make io no ia. ");
INSERT INTO haw1868_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","A o ka mea pepehi i ka holoholona, e hoihoi aku no oia i holoholona no ka holoholona. ");
INSERT INTO haw1868_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Ina haawi ke kanaka i kona hoalauna i kina iloko o kona kino, e like me kana hana ana aku, pela no e hanaia mai ai ia; ");
INSERT INTO haw1868_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","He eha no ka eha, he maka no ka maka, he niho no ka niho: me kana i haawi ai i ke kanaka i kina iloko ona, pela no e hanaia'e ai ia. ");
INSERT INTO haw1868_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","O ka mea pepehi i ka holoholona, e hoihoi no oia ia; a o ka mea pepehi i ke kanaka, e make ia. ");
INSERT INTO haw1868_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","I hookahi kanawai ko oukou no ka malihini, a no ka mea o ko oukou aina iho; no ka mea, owau no Iehova ko oukou Akua. ");
INSERT INTO haw1868_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Olelo ae la o Mose i na mamo a Iseraela, e lawe ae i ka mea kuarauamu iwaho o kahi hoomoana, a e hailuku aku ia ia me na pohaku; hana iho la ua mamo a Iseraela e like me ke kauoha a Iehova ia Mose. ");
INSERT INTO haw1868_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","OLELO mai la hoi o Iehova ia Mose ma ka mauna Sinai, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","E olelo aku oe i na mamo a Iseraela, a e i aku ia lakou, Aia komo oukou i ka aina a'u e haawi aku nei ia oukou, alaila e malama ka aina i ka Sabati no Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","I na makahiki eono e lulu hua ai oe ma kau mahinaai, a i na makahiki eono e paipai ai oe i kou malawaina, a e ohi hoi i kona hua. ");
INSERT INTO haw1868_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Aka o ka hiku o ka makahiki, e lilo ia i Sabati e hoomaha ai no ka aina, i Sabati no Iehova; mai lulu hua oe ma kau mahinaai, aole hoi oe e paipai i kou malawaina, ");
INSERT INTO haw1868_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","O ka mea ulu wale no kau ai, mai okioki oe ia, aole hoi e ohi i na hua waina o kou kumu waina paipai ole ia; he makahiki ia e hoomaha ai no ka aina. ");
INSERT INTO haw1868_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","A o ka Sabati o ka aina he ai na oukou, nau, a na kau kauwa, a na kau kaikamahine, a na kau kauwa hoolimalimaia, a na kou malihini e noho pu ana me oe, ");
INSERT INTO haw1868_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","A na kau mau holoholona, me na holoholona ma kou aina, he ai kona hua a pau, ");
INSERT INTO haw1868_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","A e helu oe i na Sabati makahiki ehiku nou, i ehiku hiku mau makahiki, a o ka wa o na Sabati makahiki ehiku, he kanahakumamaiwa mau makahiki nou. ");
INSERT INTO haw1868_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Alaila e hookani ai oe i ka pu Iubile, i ka la umi o ka malama ahiku, i ka la kalahala, e hookani ai oukou i ka pu ma ko oukou aina a puni. ");
INSERT INTO haw1868_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","A e hoano oukou i ke kanalima o ka makahiki, a e hai aku i ke kuu wale ana a puni ka aina, i ka poe a pau e noho ana ilaila; e lilo ia i Iubile ia oukou, a e hoi oukou kela kanaka keia kanaka i kona aina iho, a e hoi oukou kela kanaka keia kanaka i kona ohana iho. ");
INSERT INTO haw1868_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","He Iubile auanei ia makahiki kanalima ia oukou. Mai lulu hua oukou, aole hoi e okioki i ka mea ulu wale ia makahiki, aole hoi e ohi i ko ke kumuwaina paipai ole ia. ");
INSERT INTO haw1868_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","No ka mea, he Iubile ia, e hoano auanei ia ia oukou; mailoko mai o ka mahinaai, e ai ai oukou i kona hua. ");
INSERT INTO haw1868_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","I ka makahiki o ua Iubile nei, e hoi ai oukou kela kanaka keia kanaka i kona aina iho. ");
INSERT INTO haw1868_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Ina e kuai lilo aku oe i kekahi mea i kou hoalauna, a ina kuai lilo mai oe i kekahi mea mai ka lima mai o kou hoalauna, mai noho oukou a hooluhi hewa kekahi i kekahi. ");
INSERT INTO haw1868_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","E like me ka helu o na makahiki mahope ae o ka Iubile, e kuai lilo mai me kou hoalauna, a e like me ka helu o na makahiki o na hua, a kuai lilo aku oia ia oe. ");
INSERT INTO haw1868_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Mamuli o ka nui o na makahiki e hoonui ai oe i ke kumu kuai o ia mea; a mamuli o ka uuku o na makahiki, e houuku ai i kona kumu kuai; no ka mea, ma ka helu o na makahiki hua, e kuai lilo aku ai oia ia oe. ");
INSERT INTO haw1868_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Nolaila, mai hooluhihewa kekahi i kekahi, aka e weliweli oe i kou Akua: owau no Iehova ko oukou Akua. ");
INSERT INTO haw1868_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","No ka mea, e hana oukou ma ka'u kauoha, a e malama hoi i ko'u mau kanawai, a e hana ma ia mau mea; a e noho no oukou ma ka aina me ka maluhia. ");
INSERT INTO haw1868_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","A e hoohua mai ka aina i kona mau hua, a e ai oukou a maona, a e noho maluhia oukou ilaila. ");
INSERT INTO haw1868_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","A ina olelo oukou, He aha la ka kakou mea e ai ai, i ka hiku o ka makahiki? aia hoi, aole kakou e luluhua, aole hoi e houluulu i ko kakou mau hua; ");
INSERT INTO haw1868_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Alaila e kauoha ai au i ka'u hoomaikai ana mai una o oukou i ke ono o ka makahiki, a e hoohua mai ia i ka hua no na makahiki ekolu; ");
INSERT INTO haw1868_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","A i ka walu o ka makahiki e lulu hua ai oukou, a e ai no i ka hua kahiko, a hiki i ka iwa o ka makahiki; a komo mai na hua ona, e ai no oukou i ka mea kahiko. ");
INSERT INTO haw1868_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Aole e kuai lilo mau ia aku ka aina; no ka mea, no'u no ka aina, no ka mea hoi, he poe malihini oukou, e noho malihini ana me au nei. ");
INSERT INTO haw1868_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","A ma ka aina a pau o oukou, e haawi aku oukou e kuai hou ia ka aina. ");
INSERT INTO haw1868_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Ina i ilihune ae kou hoahanau, a ua kuai lilo aku i kauwahi o kona aina, a hele mai kekahi o kona poe hoahanau, e kuai hou, alaila e kuai lilo mai oia i ka mea a kona hoahanau i kuai lilo aku. ");
INSERT INTO haw1868_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","A ina aole o ke kanaka mea nana e kuai lilo hou mai, a e hiki ia ia iho ke kuai lilo hou mai; ");
INSERT INTO haw1868_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","Alaila e helu oia i na makahiki o kona lilo ana i ke kuaiia, a hoihoi aku i ke koena i ke kanaka ia ia ka aina ana i kuai lilo aku ai; i hoi ai oia i kona aina iho. ");
INSERT INTO haw1868_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Aka ina e hiki ole ia ia ke hoihoi aku ia mea, alaila ka mea i kuai lilo aku e waiho no ia iloko o ka lima o ka mea kuai lilo mai ia mea, a hiki i ka makahiki Iubile; ae hemo ia i ka Iubile, a hoi oia i kona aina iho. ");
INSERT INTO haw1868_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","A ina e kuai lilo aku kekahi kanaka i ka hale noho maloko o ke kulanakauhale paa i ka pa, alaila e hiki ia ia ke kuai lilo hou mai maloko o ia makahiki okoa, mahope iho o ke kuai lilo ana'ku. Ia makahiki a puni e pono ia ia ke kuai lilo hou mai. ");
INSERT INTO haw1868_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","A ina i ole e kuai lilo mai ia iloko o ka wa e puni ai ka makahiki, alaila ka hale iloko o ke kulanakauhale paa i ka pa, e hoomau loa ia i ka mea nana i kuai lilo mai, i kona mau hanauna; aole ia e hemo i ka labile. ");
INSERT INTO haw1868_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Aka o na hale ma na kauhale aole i puni i ka pa, e heluia lakou e like me na mahinaai o ka aina; e hiki no ia lakou ke kuai lilo hou ia mai, a e hemo no i ka lubile. ");
INSERT INTO haw1868_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Aka o na kulanakauhale o ka Levi a me na hale o lakou, e hiki no i na pua a Levi ke kuai lilo hou mai i kela manawa keia manawa, ");
INSERT INTO haw1868_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Ina e kuai lilo mai kekahi i ko na pua a Levi, alaila ka hale i kuai lilo ia aku, a me ke kulanakauhale ona, e hemo no ia i ka lubile; no ka mea, o na hale o na kulanakauhale o ka poe pua a Levi, o ko lakou waiwai no ia iwaena o na mamo a Iseraela. ");
INSERT INTO haw1868_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Aka o ka mahinaai e pili ana i ko lakou kulanakauhale, aole ia i kuai lilo ia'ku: no ka mea, o ko lakou waiwai mau no ia. ");
INSERT INTO haw1868_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","A ina na lilo kou hoahanau i ilihune, a ua nawaliwali ae la kona lima, alaila e kokua oe ia ia; ina hoi he malihini, a he mea noho malihini, i ola pu ia me oe. ");
INSERT INTO haw1868_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Mai lawe oe i ka uku kuala ona, aole hoi i ka mahuahua ana: aka e weliweli oe i kou Akua, i hiki i kou hoahanau ke ola pu me oe. ");
INSERT INTO haw1868_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Aole oe e haawi lilo ole ae i kau moni, no ka uku kuala, aole hoi e haawi i kau ai ia ia no ka hoonui ia. ");
INSERT INTO haw1868_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Owau no o Iehova o ko oukou Akua, ka mea i lawe mai ia oukou mai ka aina mai o Aigupita, e haawi ia oukou i ka aina o Kanaana, i Akua au no oukou. ");
INSERT INTO haw1868_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","A ina i ilihune ae kou hoahanau, e noho kokoke ana me oe, a kuai lilo ia'ku ia nou, aole oe e hoohana ia ia nou me he kauwa paa la: ");
INSERT INTO haw1868_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Aka me he paaua la, a, me he mea noho malihini la, e noho ai oia me oe, a e hookauwa oia nau a hiki i ka makahiki Iubile. ");
INSERT INTO haw1868_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Alaila e hele aku oia, mai ou aku la, oia pu me kana mau keiki me ia, a e hoi aku no i kana ohana, a i ka aina o kona mau makua. ");
INSERT INTO haw1868_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","No ka mea, he mau kauwa na'u lakou, a'u i lawe mai nei mai ka aina mai o Aignpita; aole lakou e kuai lilo ia aku me he mau kauwa paa la. ");
INSERT INTO haw1868_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Aole oe e hoohaku maluna ona me ke oolea, aka e weliweli oe i kou Akua. ");
INSERT INTO haw1868_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","O kau mau kauwa kaue paa, a me kau mau kauwa wahine paa, i lilo ia oe, no na lahuikanaka e puni ana ia oe lakou; no lakou mai e kuai oukou i mau kauwakane paa, a i mau kauwawahine paa. ");
INSERT INTO haw1868_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","A no na keiki a na malihini e noho malihini ana iwaena o oukou, no lakou e kuai ai oukou, a no ko lakou mau ohana me oukou, i loaa ia lakou ma ko oukou aina; a e lilo lakou i waiwai nau. ");
INSERT INTO haw1868_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","A e lawe hoi oukou ia lakou i waiwai na ka oukou mau keiki mahope o oukou, e ili iho i waiwai ua lakou; aet lilo lakou i kauwa mau na oukou; aka, maluna o ko oukou mau hoahanau, na mamo a Iseraela, aole e hoohaku kekahi maluna o kekahi mo ke oolea. ");
INSERT INTO haw1868_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","A ina e waiwai nui ae ka mea noho, a o ka malihini me oe, a e ilihune ae kou hoahanau e noho kokoke ana me ia, a kuai lilo aku oia ia ia iho i ka malihini, a i ka mea noho ma ou la, a i ka pua paha o ka ohana a ka malihini; ");
INSERT INTO haw1868_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","Mahope o kona kuai lilo ia'ku, e hiki ke kuai lilo hou ia mai. E hiki i kekahi o kona mau hoahanau ke kuai lilo hou mai. ");
INSERT INTO haw1868_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","E pono i ka hoahanau o kona makuakane, a me ke keiki a ka hoahanau o kona makuakane, ke kuai lilo hou mai, a e hiki i kekahi o kona io iho, no kona ohana iho, ke kuai lilo hou mai ia ia; a ina e hiki i kona lima iho, he pono no ke kuai hou mai oia ia ia iho. ");
INSERT INTO haw1868_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","A e kuka pu oia me ka mea nana ia i kuai lilo mai, mai ka makahiki mai i kuai lilo ia'ku ai oia ia ia, a hiki i ka makahiki Iubile, a o ke kumu kuai ona e hoolikeia ia me ka helu o na makahiki, e like me ka wa o ka paaua, pela no ia ia. ");
INSERT INTO haw1868_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Ina he nui ua makahiki i koe, e like me ia e haawi ai oia i ke kumu kuai, e kuai lilo hou mai, mailoko mai o ka moni i kuai lilo ia mai ai oia. ");
INSERT INTO haw1868_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","A ina he uuku na makahiki i koe a hiki i ka makahiki lubile, alaila e helu pu me ia, a e like me na makahiki, e haawi hou ai oia ia ia i ke kumu kuai, e kuai lilo hou ia mai ai oia. ");
INSERT INTO haw1868_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Me he paaua la i hoolimalimaia ma ka makahiki e noho ai oia me ia; aole nae e hoohaku maluna ona me ko oolea mamua o kou mau maka. ");
INSERT INTO haw1868_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","A ina i ole e kuai lilo hou ia mai, ma ia mau mea, alaila e hele aku no ia i ka makahiki Iubile, oia pu me kana mau keiki me ia. ");
INSERT INTO haw1868_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","No ka mea, ia'u nei, he poe kauwa na mamo a Iseraela: o ka'u mau kauwa lakou, a'u i lawe mai nei mai ka aina mai o Aigupita: owau no Iehova ko oukou Akua. ");
INSERT INTO haw1868_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","MAI hana oukou i na akuakii, a me na kii kalaiia no oukou; aole hoi e kukulu i kii ku, aole hoi e hooka i kii pohaku ma ko oukou aina e kulou iho ia ia; no ka mea, owau no Iehova ko oukou Akua. ");
INSERT INTO haw1868_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","E malama oukou i ko'u mau Sabati, a e hoano i ko'u keenakapu: owau no Iehova, ");
INSERT INTO haw1868_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Ina e hele oukou ma ko'u mau kanawai, a e malama hoi i ka'u mau kauoha, a e hana hoi ma ia mau mea; ");
INSERT INTO haw1868_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","Alaila e haawi aku ai au i ka ua no oukou i ka wa pono, a e haawi mai ka aina i kona mea ulu, a e hoohua mai na laau i ko lakou hua. ");
INSERT INTO haw1868_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","A o ko oukou wa e hahi ai ana e hiki aku ia i ka wa e ohi hua waina ai, a o ka wa e ohi hua waina ai e hiki aku ia i ka wa e lulu hua ai; a e ai oukou i ka oukou berena a maona, a e noho maluhia oukou ma ko oukou aiua. ");
INSERT INTO haw1868_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","A e haawi aku no wau i ka malu ma ko oukou aina, a e moe iho oukou ilalo, aohe mea nana oukou e hooweliweli; ae hoopau aku au i na holoholona ino mailoko aku o ko oukou aina; aole hoi e hele ae ka pahikaua mawaena ae o ko oukou aina, ");
INSERT INTO haw1868_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","E alualu oukou i ko oukou poe enemi, a e haule lakou i ka pahikaua mamua o oukou. ");
INSERT INTO haw1868_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Elima o oukou e alualu i ka haneri, a he haneri o oukou e hooanhee i na tausani he umi; a e haule ko oukou poe enemi imua o oukou i ka pahikaua. ");
INSERT INTO haw1868_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","No ka mea, e manao aku no au ia oukou, a e hana aku au ia oukou e hua ae, a e hoonui aku au ia oukou, a e hoopaa aku au i kau berita me oukou. ");
INSERT INTO haw1868_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","A e ai oukou i ka mea kahiko, a e lawe mai i ka mea kahiko iwaho, no ka mea hou. ");
INSERT INTO haw1868_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","A e hoonoho au i kuu halelewa iwaena o oukou, aole hoi e hoowahawaha ko'u uhane ia oukou. ");
INSERT INTO haw1868_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","A e hele au iwaena o oukou, a owau no ko oukou Akua, a e noho oukou i kanaka no'u. ");
INSERT INTO haw1868_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Owau no Iehova ko oukou Akua ka mea nana oukou i lawe mai nei, mai ka aina mai o Aigupita, i ole ai oukou e noho kauwa paa no lakou; a ua moku ia'u na mea e paa ai ka oukou auamo, a hookupono ia oukou i ka hele ana. ");
INSERT INTO haw1868_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Aka ina e lohe ole oukou ia'u, aole hoi e hana ma keia mau kauoha a pau; ");
INSERT INTO haw1868_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","A ina e hoowahawaha oukou i ka'u mau kauoha, a e inaina mai ko oukou uhane i ko'u mau kanawai, i ole ai oukou e hana ma ka'u mau kauoha a pau, aka e pale ou kou i ka'u berita; ");
INSERT INTO haw1868_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","Na'u no keia e hana ai ia oukou, e hoomaopopo au maluna o oukou i ka makau, a me ka hokii, a me ka li wela e pau ai na maka, a e ehaeha ai ka naau: a e lulu make hewa oukou i ko oukou hua, no ka mea, na ko oukou mau enemi ia e ai. ");
INSERT INTO haw1868_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","E hooku e hoi au i ko'u maka ia oukou, a e lukuia oukou imua o ko oukou poe enemi: a o ka poe inaina ia oukou e alii ae maluna o oukou, a e auhee oukou i ka alualu ole ai o kekahi ia oukou. ");
INSERT INTO haw1868_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","A ina aole oukou e hoolohe mai ia'u no keia mea, alaila e hoopai pahiku hou aku au ia oukou no ko oukou mau hewa. ");
INSERT INTO haw1868_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","A e wahi aku au i ka haaheo o ko oukou mana; a e hoolilo au i ko oukou lani me he hao la, a i ko oukou honua me he keleawe la. ");
INSERT INTO haw1868_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","A e lilo ko oukou ikaika i ole; no ka mea, aole e haawi mai ko oukou aina i kona mea ulu, aole hoi e hoohua na laau o ka aina i ko lakou mau hua, ");
INSERT INTO haw1868_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","A ina e hele ku e oukou ia'u, aole hoi e hoolohe mai ia'u, e hooili pahiku hou aku au i na mea ino maiuna o oukou, e like me ko oukou mau hewa. ");
INSERT INTO haw1868_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","E hoouna no hoi au i na holoholona hihiu iwaena o oukou e kaili ae i ka oukou mau keiki, a e luku hoi i ko oukou holoholona, a e houuku ia oukou, a e neoneo ae ko oukou mau alanui. ");
INSERT INTO haw1868_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","A ina aole oukou e hooponoia e au ma keia mau mea, aka, e hele ku e no oukou ia'u, ");
INSERT INTO haw1868_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","Alaila e hele ku e aku au ia oukou, a e hoopai pahiku aku au ia oukou no ko oukou mau hewa. ");
INSERT INTO haw1868_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","A e lawe au i ka pahikaua maluna o oukou e hoopai ana no ka berita; a akoakoa oukou iloko o ko oukou mau kulanakauhale, e hoouua aku au i ka mai ahulau iwaena o oukou; a e haawiia'ku oukou i ka lima o ka enemi. ");
INSERT INTO haw1868_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Aia haki ia'u ke kookoo o ka oukou berena, alaila e kahumu na wahine he umi i ka oukou berena ma ka umu hookahi, a e haawi hou lakou i ka oukou berena ia oukou, ma ke kaupaona; a e ai hoi oukou, aole hoi e maona. ");
INSERT INTO haw1868_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","A ina aole oukou e hoolohe mai ia'u no keia, aka, e hele ku e no oukou ia'u; ");
INSERT INTO haw1868_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","Alaila e hele ku e aku au ia oukou, me ka huhu; a na'u, na'u no oukou e hahau pahiku aku no ko oukou hewa, ");
INSERT INTO haw1868_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","A e ai oukou i ka io o ka oukou mau keikikane, a o ka io no o ka oukou mau kaikamahine ka oukou e ai ai. ");
INSERT INTO haw1868_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","A e hoopau aku au i ko oukou mau wahi kiekie, a e kua iho au i ko oukou mau kii, a e hoolei aku wau i ko oukou mau kupapau maluna iho o na kupapau o ko oukou mau kii a e hoowahawaha aku ko'u uhane ia oukou. ");
INSERT INTO haw1868_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","A e hooneoneo aku au i ko oukou mau kulanakauhale, a e hookae no au i ko oukou mau keenakapu, aole hoi au e honi aku i ke ala o ko oukou mea ala. ");
INSERT INTO haw1868_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","A e hooneoneo aku au i ka aina, a, nolaila e ilihia'i ko oukou poe enemi e noho ana malaila. ");
INSERT INTO haw1868_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","A e hooleilei aku au ia oukou iwaena o na lahuikanaka, a e unuhi ae au i ka pahikaua mahope o oukou; a e neoneo ae ko oukou aina, a e noho ole ia ko oukou mau kulanakauhale. ");
INSERT INTO haw1868_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Alaila e loaa i ka aina kona mau Sabati, i kona mau la e neoneo ai, a e noho ai hoi oukou ma ka aina o ko oukou mau enemi; alaila e maha ai ka aina, a e loaa ia ia kona mau Sabati. ");
INSERT INTO haw1868_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","I kona mau la e neoneo ai, e maha no ia; no ka mea, aole ia i maha i ko oukou mau Sabati, ia oukou i noho ai maluna ona. ");
INSERT INTO haw1868_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","A maluna o ko oukou poe e koe ana, e hooili ai au i ka maule ana iloko o ko lakou mau naau, ma na aina o ko lakou mau enemi; a o ka leo o ka lau i puehuia e hooauhee aku ia lakou, a e auhee lakou, me he auhee ana la mai ka pahikaua aku; a haule no lakou i ka wa e ole ai he mea alualu. ");
INSERT INTO haw1868_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","A e hina lakou kekahi maluna o kekahi me he mea la mamua o ka pahikaua, i ka wa e ole ai he mea alualu; aole hoi e hiki iki ia oukou ke ku imua o ko oukou poe enemi. ");
INSERT INTO haw1868_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","A e make oukou mawaena o na lahuikanaka, a e ai no ka aina o ko oukou poe enemi ia oukou. ");
INSERT INTO haw1868_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","A o ke koena o oukou, e mae ae lakou iloko o ko lakou hewa, ma na aina o ko oukou poe enemi; a iloko hoi o ka hewa o ko lakou mau makua lakou e mae pu ai me lakou. ");
INSERT INTO haw1868_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","Ina e hai mai lakou i ko lakou hewa, a me ka hewa o ko lakou mau makua, a me ka lawehala a lakou i hana hewa mai ai ia'u, a ua hele ku e hoi lakou ia'u; ");
INSERT INTO haw1868_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","A hele ku e hoi au ia lakou, a ua lawo ae hoi ia lakou ma ka aina o ko lakou poe enemi; ina hoi e hoohaahaaia ko lakou mau naau okipoepoe ole ia, a ilaila e ae ai lakou i ka hoopai ana i ko lakou hewa; ");
INSERT INTO haw1868_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","Alaila e hoomanao aku au i kuu berita me Iakoba, a me kuu berita hoi me Isaaka, a me kuu berita hoi me Aberahama ka'u e hoomanao ai, a e hoomanao hoi au i ka aina. ");
INSERT INTO haw1868_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","E haaleleia hoi ka aina e lakou, a e loaa ia ia kona mau Sabati, i kona wa e waiho neoneo ai, aole o lakou; a e ae lakou i ka hoopai ana i ko lakou hewa; no keia, o ko lakou hoowahawaha ana i kuu mau kanawai, a no ko lakou inaina ana i kuu mau kauoha. ");
INSERT INTO haw1868_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Oia la, aka i ko lakou noho ana ma ka aina o ko lakou poe enemi, aole au e kiola loa ia lakou, aole hoi au e inaina aku ia lakou, e luku loa ai ia lakou, a e uhaki ai i kuu berita me lakou; no ka mea, owau no Iehova ko lakou Akua. ");
INSERT INTO haw1868_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Aka, no lakou, e hoomanao ai au i ka berita o ko lakou mau kupuna, a'u i lawe mai nei mai ka aina mai o Aigupita imua o na maka o na lahuikanaka, i Akua au no lakou: owau no Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Oia na kapu, a me na kauoha, a me na kanawai a Iehova i haawi mai ai iwaena ona a me na mamo a Iseraela, i ka mauna Sinai, ma ka lima o Mose. ");
INSERT INTO haw1868_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","OLELO mai la hoi o Iehova ia Mose i mai la, ");
INSERT INTO haw1868_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","E olelo aku oe i na mamo a Iseraela, a e i aku ia lakou, Aia hoohiki kekahi kanaka i ka mea hoohiki, alaila, no Iehova na kino mamuli o kou manao ana, ");
INSERT INTO haw1868_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","A penei kou manao ana, no ke kane, mai ka makahiki iwakalua a hiki i ka makahiki kanaono ona, o kou manao ana, he kanalima sekela kala, mamuli o ka sekela o ke keenakapu. ");
INSERT INTO haw1868_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","A ina he wahine, alaila o kou manao ana, he kanakolu sekela. ");
INSERT INTO haw1868_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","A ina mai ka makahiki alima ia a hiki i ka makahiki iwakalua ona, alaila, o kou manao ana, no ke kane he iwakalua sekela, a no ka wahine he umi sekela. ");
INSERT INTO haw1868_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","A ina mai ka malama hookahi ia a hiki i ka makahiki alima, alaila o kou manao ana, no ke kane elima sekela kala, a no ka wahine ekolu sekela kala, ");
INSERT INTO haw1868_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","A ina mai ka makahiki kanaono aku ona, alaila, ina he kane, o kou manao, he umikumamalima aekela, a no ka wahine he umi aekela. ");
INSERT INTO haw1868_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Aka ina i uuku iho kona waiwai i kou mea i manao ai, alaila e hoike oia ia ia iho imua o ke alo o ke kahuna, a e manao ke kahuna ia ia; mamuli o ka mea hiki i kona lima, e manao ai ke kahuna i ka mea i hoohiki. ");
INSERT INTO haw1868_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","A ina he holoholona i lawe mai ai na kanaka i kauwahi ona i mohai ia Iehova, a ko keia i haawiia no Iehova, e laa no ia. ");
INSERT INTO haw1868_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Aole oia e hoololi hou ia, aole hoi e kuai oia ia he mea inaikai no ka mea ino, aole hoi i ka mea ino no ka mea maikai; a ina e kuai oia i kekahi holoholona no kekahi holoholona, alaila e laa pu ia me ka holoholona i loaa mai. ");
INSERT INTO haw1868_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","A ina he holoholona haumia i lawe ole ia mai ai kauwahi i mohai ia Iehova, alaila e hoike oia i ka holoholona imua o ke alo o ke kahuna; ");
INSERT INTO haw1868_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","A e manao ae ke kahuna ia ia, he maikai paha, he ino paha, a e like me ka mea i manao ai oe, o ke kahuna, pela no ia. ");
INSERT INTO haw1868_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Aka ina makemake oia e kuai lilo hou mai ia mea, e hui aku oia i ka hapalima ona me kau mea i manao ai. ");
INSERT INTO haw1868_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","A ina e hoolaa kekahi kanaka i kona hale i hoano ia ia Iehova, alaila e manao ke kahuna ia mea, ina he maikai paha, ina he ino; a e like me ka manao ana o ke kahuna, pela no ia e ku iho ai. ");
INSERT INTO haw1868_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","A ina makemake ka mea nana ia i hoolaa, e kuai lilo hou mai i kona hale, alaila e hui oia me ia i ka hapalima o ka moni au i manao ai, a e lilo ia nona. ");
INSERT INTO haw1868_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","A ina e hoolaa ke kanaka i kauwahi o ka mahinaai o kona aina ia Iehova, alaila, mamuli o kona hua kau e manao ai; he homera hua bale, he kanalima sekela kala. ");
INSERT INTO haw1868_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","A ina mai ka makahiki Iubile i hoolaa ai oia i kana mahinaai, alaila e like me kau mea e manao ai, pela no ia e ku iho ai. ");
INSERT INTO haw1868_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Aka ina i hoolaa oia i kana mahinaai mahope o ka Iubile, alaila e helu ke kahuna i ka moni ia ia e like me na makahiki i koe a hiki i ka makahiki labile, a e laweia'e ia mailoko ae o kau mea i manao ai. ");
INSERT INTO haw1868_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","A ina makemake ka mea nana e hoolaa i ka mahinaai e kuai lilo hou mai ia mea, alaila e hui oia me ia i ka hapalima o ka moni au i manao ai, a e hoomauia ia nona. ");
INSERT INTO haw1868_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Aka ina aole ia e kuai lilo hou mai ia mahinaai, a ina paha i kuai lilo aku oia ia mahinaai i kekahi kanaka, aole e kuai lilo hou ia mai ia. ");
INSERT INTO haw1868_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Aka i ka puka ana ae o ka mahinaai i ka Iubile, e laa no ia no Iehova, me he mahinaai i hoolaaia la; e lilo ia i waiwai no ke kahuna. ");
INSERT INTO haw1868_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","A ina e hoolaa aku ke kanaka ia Iehova i ka mahinaai ana i kuai lilo mai, aole no na mahinaai o ko na aina; ");
INSERT INTO haw1868_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","Alaila e helu aku ke kahuna nona i ka waiwai au i manao ai a hiki i ka makahiki Iubile; a e haawi oia, ia la, i kau mea i manao ai, he mea laa ia Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","I ka makahiki Iubile e hoi aku ka mahinaai i ka mea nona mai ai i ke kuai lilo ia mai, i ka mea nona ka aina mamua. ");
INSERT INTO haw1868_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","A o kou manao ana a pau, ma ke sekela o ke keenakapu ia, iwakalua gera, oia ke sekela. ");
INSERT INTO haw1868_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","O ka hiapo wale no a na holoholona, ka hiapo no Iehova, aohe kanaka nana ia e hoolaa, ina he bipikauo paha, a ina he hipa paha, no Iehova ia. ");
INSERT INTO haw1868_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","A ina o ka ka holoholona haumia, alaila e kuai lilo hou mai oia ia ia, mamuli o kau mea e manao ai, a e hui me ia i ka hapalima ona: a i ole ia e kuai lilo hou ia mai, alaila e kuai lilo ia aku ia mamuli o kau i manao ai. ");
INSERT INTO haw1868_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Aka, o kela mea keia mea laa a ke kanaka i hoolaa ai ia Iehova o kana mau mea a pau, he kanaka, he holoholona, he mahinaai o kona aina, aole ia e kuai lilo ia aku, aole hoi e kuai lilo hou ia mai; o kela mea laa keia mea laa, he hoano loa ia no Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Aole mea laa a kanaka i hoolaa ai, e kuai lilo hou ia mai, aka, e make io no ia. ");
INSERT INTO haw1868_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","A o ka hapaumi a pau o ko ka aina, o ka hua o ka aina, a o ka hua o ka laan, no Iehova ia, he hoano no Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","A ina makemake ke kanaka e kuai lilo hou mai i ke kauwahi o kona mau hapaumi, e hui oia me ia i ka hapalima ona. ");
INSERT INTO haw1868_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","A no ka hapaumi o ka ohana bipi, a o ka ohana hipa, a o na mea e hele ae malalo ae o ke kookoo, e laa no ka hapaumi ia Iehova. ");
INSERT INTO haw1868_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Aole ia e huli he maikai paha, he ino paha; aole hoi e kuai oia ia e loaa mai kekahi: a ina e kuai oia ia mea, alaila e laa ia, a me ka mea i loaa mai; aole e kuai lilo hou ia mai. ");
INSERT INTO haw1868_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Oia na kauoha a Iehova i kauoha mai ai ia Mose no na mamo a Iseraela, ma ka mauna Sinai. ");
INSERT INTO haw1868_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","OLELO mai la o Iehova ia Mose, ma ka waonahele o Sinai, iloko o ka halelewa o ke anaina i ka la mua o ka lua o ka malama, i ka lua o ka makahiki mahope iho o ko lakou hele ana mai, mai ka aina o Aigupita mai, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","E helu olua i ke anaina kanaka a pau o na mamo a Iseraela, ma ko lakou mau ohana, ma ko ka hale o ko lakou mau kupuna, me ka helu ana i ko lakou inoa, ko na kane a pau ma ko lakou poo: ");
INSERT INTO haw1868_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Mai na makahiki he iwakalua a malaila aku, o ka poe a pau iloko o ka Iseraela e pono ke hele i ke kaua; na olua me Aarona lakou e helu ma ko lakou mau poe koa. ");
INSERT INTO haw1868_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","A me olua pu kekani kanaka o kela ohana o keia ohana; o kela mea o keia mea o lakou ka luna no ka ohana a kona poe kupuna, ");
INSERT INTO haw1868_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Eia hoi na inoa o ka poe kanaka e ku pu me olua; no ka Reubena; o Elizura, ke keiki a Sedeura. ");
INSERT INTO haw1868_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","No ka Simeona; o Selumiela, ke keiki a Zurisadai. ");
INSERT INTO haw1868_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","No ka Iuda; o Nahesona, ke keiki a Aminadaba. ");
INSERT INTO haw1868_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","No ka Isakara; o Netaneela, ke keiki a Zuara. ");
INSERT INTO haw1868_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","No ka Zebuluna; o Eliaba ke keiki a Helona. ");
INSERT INTO haw1868_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","No na keiki a Iosepa; no ka Eperaima, o Elisama, ke keiki a Amihuda: no ka Manase, o Gamaliela, ke keiki a Pedazura. ");
INSERT INTO haw1868_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","No ka Beniamina; o Abidana, ke keiki a Gideoni. ");
INSERT INTO haw1868_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","No ka Dana; o Ahiezera, ke keiki a Amiaadai. ");
INSERT INTO haw1868_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","No ka Asera; o Pagiela, ke keiki a Okerana. ");
INSERT INTO haw1868_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","No ka Gada; o Eliasapa, ke keiki a Deuela. ");
INSERT INTO haw1868_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","No ka Napetali; o Ahira, ke keiki a Enana. ");
INSERT INTO haw1868_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","O lakou nei ka poe i kohoia noloko o ke anaina kanaka na alii lakou o na ohana a ko lakou mau kupuna, na luna hoi no na tausani o ka Iseraela. ");
INSERT INTO haw1868_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Lawe ae la o Hose laua o Aarona i keia poe kanaka i hoohikiia ma ko lakou mau inoa: ");
INSERT INTO haw1868_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","A hoouluulu ae la lakou i ke anaina kanaka a pau, i ka la mua o ka lua o ka malama, a hai mai la lakou i ko lakou kuauhau ma ko lakou mau ohana, ma ko ka hale o ko lakou mau kupuna, ma ka helu ana i na inoa, mai ka iwakalua o ko lakou mau makahiki a keu aku, ma ko lakou mau poo. ");
INSERT INTO haw1868_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","E like me ka Iehova i kauoha mai ai ia Mose, pela no oia i helu ai ia lakou ma ka waonahele o Sinai. ");
INSERT INTO haw1868_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","A o na mamo a Reubena, a ka hiapo a Iseraela, ma ko lakou mau hanauna, mamuli o ko lakou mau ohana, ma ko ka hale o ko lakou mau kupuna, e like me ka helu ana i na inoa ma ko lakou mau poo; o na kane a pau ma ka iwakalua o ka makahiki a keu aku, o ka poe a pau i hiki ke hele i ke kaua; ");
INSERT INTO haw1868_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","O ka poe o lakou i heluia, no ka ohana a Reubena, he kanahakumamaono tausani, a me na haneri keu elima. ");
INSERT INTO haw1868_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","A o na mamo a Simeona, ma ko lakou mau hanauna, mamuli o ko lakou mau ohana, ma ko ka hale o ko lakou poe kupuns, o ka poe o lakou i heluia ma ka huina o na inoa, ma ko lakou mau poo, o na kane a pau, mai ka iwakalua o ka makahiki a keu aku, o ka poe a pau e hiki ke hele i ke kaua; ");
INSERT INTO haw1868_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","O ka poe o lakou i heluia, o ka ohana a Simeona, he kanalimakumamaiwa tausani i me na haneri keu ekolu. ");
INSERT INTO haw1868_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","O na mamo a Gada, ma ko lakou mau hanauna, mamuli o ko lakou mau ohana, ma ko ka hale o ko lakou poe kupuna, e like me ka helu ana i na inoa, mai ka iwakalua o ko lakou makahiki a keu aku, o ka poe a pau e hiki ke hele i ke kaua; ");
INSERT INTO haw1868_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","O ka poe o lakou i heluia, a ka ohana a Gada, he kanahakumamalima tausani, aono haneri a me ke kanalima. ");
INSERT INTO haw1868_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","O na mamo a Iuda, ma ko lakou mau hanauna, mamuli o ko lakou mau ohana, ma ko ka bale o ko lakou poe kupuna, e like me ka huina o na inoa, mai ka iwakalua o ka makahiki a keu aku, o ka poe a pau e hiki ke hele i ke kaua; ");
INSERT INTO haw1868_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","O ka poe o lakou i heluia, o ka ohana a Iuda, he kanahikukumamaha tausani, a me na haneri keu eono. ");
INSERT INTO haw1868_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","O na keiki a Isakara, me ko lakou mau hanauna, mamuli o ko lakou mau ohana, ma ko ka hale o ko lakou mau kupuna, e like me ka helu ana i na inoa, mai ka iwakalua o ka makahiki a keu aku, o ka poe a pau e hiki ke hele i ke kaua; ");
INSERT INTO haw1868_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","O ka poe o lakou i heluia, o ka ohana a Isakara, he kanalimakumamaha tausani, a me na haneri keu eha. ");
INSERT INTO haw1868_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","O na keiki a Zebuluna, ma ko lakou mau hanauna, mamuli o ko lakou mau ohana, ma ko ka hale o ko lakou poe kupuna, e like me ka helu ana i na inoa, mai ka iwakalua o ka makahiki a keu aku, o ka poe a pau e hiki ke hele i ke kaua; ");
INSERT INTO haw1868_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","O ka poe o lakou i heluia, o ka ohana a Zebuluna, he kanalimakumamahiku tausani, a me na haneri keu eha. ");
INSERT INTO haw1868_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","O na mamo a losepa, oia o na mamo a Eperaima, ma ko lakou mau hanauna, mamuli o ko lakou mau ohana, ma ko ka hale o ko lakou poe kupuna, e like me ka helu ana i na inoa, mai ka iwakalua o ka makahiki a keu aku, o ka poe a pau e hiki ke hele i ke kaua; ");
INSERT INTO haw1868_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","O ka poe o lakou i heluia, o ka ohana a Eperaima, he kanaha tausani a me na haneri keu elima. ");
INSERT INTO haw1868_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","O na mamo a Manase, ma ko lakou mau hanauna, mamuli o ko lakou mau ohana, ma ko ka hale o ko lakou poe kupuna, e like me ka helu ana I na inoa, mai ka iwakalua o ka makahiki a keu aku, o ka poe a pau e hiki ke hele i ke kaua; ");
INSERT INTO haw1868_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","O ka poe o lakou i heluia, o ka ohana a Manase, he kanakolukumamalua tausani, a me na haneri keu elua. ");
INSERT INTO haw1868_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","O na mamo a Beniamina, ma ko lakou mau hanauna, mamuli o ko lakou mau ohana, ma ko ka hale o ko lakou poe kupuna, e like me ka helu ana i na inoa, mai ka iwakalua o ka makahiki a keu aku, o ka poe a pau e hiki ke hele i ke kaua; ");
INSERT INTO haw1868_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","O ka poe o lakou i heluia, o ka ohana a Beniamina, he kanakolukumamalima tausani a me na haneri eha. ");
INSERT INTO haw1868_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","O na mamo a Dana, ma ko lakou mau hanauna, mamuli o ko lakou mau ohana, ma ka hale o ko lakou poe kupuna, e like me ka helu ana i na inoa, mai ka iwakalua o ka makahiki a keu aku, o ka poe a pau e hiki ke hele i ke kaua; ");
INSERT INTO haw1868_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","O ka poe o lakou i heluia, o ka ohana a Dana, he kanaonokumamalua tausani, me na haneri keu ehiku. ");
INSERT INTO haw1868_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","O na mamo a Asera, ma ko lakou mau banauna, mamuli o ko lakou mau ohana, ma ko ka hale o ko lakou poe kupuna, e like me ka helu ana o na inoa, mai ka iwakalua o ka makahiki a keu aku, o ka poe a pau e hiki ke hele i ke kaua; ");
INSERT INTO haw1868_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","O ka poe o lakou i heluia, o ka ohana a Asera, he kanahakumamakahi tausani, a me na haneri keu elima. ");
INSERT INTO haw1868_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","O na mamo a Napetali, ma ko lakou mau hanauna, mamuli o ko lakou mau ohana, ma ko ka hale o ko lakou poe kupuna e like me ka helu ana i na inoa, mai ka iwakalua o ka makahiki a keu aku, o ka poe a pau e hiki ke hele i ke kaua; ");
INSERT INTO haw1868_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","O ka poe o lakou i heluia, o ka ohana a Napetali, he kanalimakumamakolu tausani, a me na haneri keu eha. ");
INSERT INTO haw1868_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","O lakou nei ka poe i heluia, ka poe a Mose laua o Aarona i helu ai me na luna o ka Iseraela, he umikumamalua na kanaka: o kela mea keia mea no ko ka hale o kona mau kupuna. ");
INSERT INTO haw1868_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Pela i heluia'i lakou a pau o na mamo a Iseraela, ma ko ka hale o ko lakou poe kupuna, mai ka iwakalua o ka makahiki a keu aku, ka poe a pau iloko o ka Iseraela e hiki ke hele i ke kana; ");
INSERT INTO haw1868_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","O ka poe a pau i heluia, eono haneri a me kumamakolu tausani, elima haneri a me ke kanalima. ");
INSERT INTO haw1868_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Aka, o na Levi, mainuli o ka ohana o ko lakou poe kupuna, aole i helu pa ia me lakou. ");
INSERT INTO haw1868_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","No ka mea, ua olelo mai o Iehova ia Mose, penei, ");
INSERT INTO haw1868_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","Mai helu oe i ka ohana a Levi, aole hoi e hookui i ka huina o lakou me na mamo a Iseraela. ");
INSERT INTO haw1868_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Aka, e hoonoho oe i na Levi maluna o ka halelewa o ke kanawai, a maluna hoi o na ipu a pau oloko, a o na mea a pau o ia wahi: e halihali lakou i ka halelewa, a me kana mau ipu a pau; a e lawelawe lakou nana, a e hoomoana lakou a puni ka halelewa. ");
INSERT INTO haw1868_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","A i ka manawa e hele aku ai ka halelewa, alaila na na Levi e wawahi iho ia; a i ka manawa e kukuluia'i ka halelewa, na na Levi ia e kukulu: a o ke kanaka e ke hele mai a kokoke, e make ia. ");
INSERT INTO haw1868_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","A e kukulu hoi na mamo a Iseraela i ko lakou mau halelewa; o kela kanaka keia kanaka ma kona wahi iho e hoomoana ai, o kela kanaka keia kanaka ma kona hae iho, iwaena o ko lakou poe kaua. ");
INSERT INTO haw1868_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Aka, o na Levi, e hoomoana lakou ma ka halelewa o ke kanawai a puni, i kau ole mai ai ka inaina maluna iho o ke anaina kanaka o na mamo a Iseraela; a na na Levi e malama i ka oihana o ka halelewa o ke kanawai. ");
INSERT INTO haw1868_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","A hana iho la na mamo a Iseraela e like me na mea a pau a Iehova i kauoha mai ai ia Mose, pela lakou i hana'i. ");
INSERT INTO haw1868_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","OLELO mai la o Iehova ia Mose a ia Aarona, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","E noho kela kanaka keia kanaka o na mamo a Iseraela ma kona hae iho, me ka hae o ka hale o ko lakou kupuna; e noho kupono ana lakou i ka halelewa o ke anaina. ");
INSERT INTO haw1868_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Ma ka aoao hikina, ma ka puka ana o ka la e noho ai ka poe no ka hae o ka Iuda hoomoana ana, ma ko lakou poe kaua: a o Nahesona ke keiki a Aminadaba, oia ka luna no na mamo a Iuda. ");
INSERT INTO haw1868_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","A o kona poe kaua, a o na mea o lakou i heluia, he kanahikukumamaha tausani, me na haneri ken eono. ");
INSERT INTO haw1868_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","A o ka poe e noho kokoke ia ia, oia ka ohana a Isakara; a o Netaneela ke keiki a Zuara, oia ka luna o na mamo a Isakara. ");
INSERT INTO haw1868_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","A o kona poe kaua, a o ka poe o lakou i heluia, he kanalimakumamaha tausani, me na haneri keu eha. ");
INSERT INTO haw1868_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","O ka ohana hoi a Zebuluna; a o ka luna o na mamo a Zebuluna, oia o Eliaba ke keiki a Helona. ");
INSERT INTO haw1868_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","A o kona poe kana, a o ka poe o lakou i heluia, he kanalimakumamahiku tausani, a me na haneri keu eha. ");
INSERT INTO haw1868_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","O na mea a pau i heluia, ma kahi hoomoana o ka Iuda, hookahi ia haneri a me kanawalukumamaono tausani, a me na haneri keu eha, ma ko lakou poe kaua; o keia poe ke hele mamua. ");
INSERT INTO haw1868_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Ma ka aoao hema ka hae o kahi hoomoana o ka Reubena, ma ko lakou poe kaua; a o ka luna o na mamo a Reubena, oia o Elizura ke keiki a Sedeura. ");
INSERT INTO haw1868_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","A o kona poe kaua, a o na mea o lakou i heluia, he kanahakumamaono tausani, a me na haneri elima. ");
INSERT INTO haw1868_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","A o ka poe e noho kokoke ia ia, o ka ohana a Simeona: a o ka luna o na mamo a Simeona, oia o Selumiela ke keiki a Zurisadai. ");
INSERT INTO haw1868_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","A o kona poe kaua, a o na mea o lakou i heluia, he kanalimakumamaiwa tausani, me na haneri keu ekolu. ");
INSERT INTO haw1868_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Alaila o ka ohana a Gada; a o Eliasapa ke keiki a Reuela, oia ka luna o na mamo a Gada. ");
INSERT INTO haw1868_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","A o kona poe kaua, a o na mea o lakou i heluia, he kanahakumamalima tausani me na haneri eono, a me ke kanalima. ");
INSERT INTO haw1868_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","O ka poe a pau i heluia ma kahi hoomoana o ka Reubena, hookahi ia haneri me kanalimakumamakahi tausani, eha haneri a me kanalima keu, ma ko lakou poe kaua: a o lakou ke hele ma ka lua o ka huakai. ");
INSERT INTO haw1868_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Alaila e neenee aku ka halelowa o ke anaina, me ka poo hoomoana o na Levi, iwaenakonu o ka poe hoomoana: e like me ko lakou hoomoana ana, pela no lakou e neenee aku ai, o kela kanaka keia kanaka ma kona wahi ma ko lakou hae. ");
INSERT INTO haw1868_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Ma ka aoao komohaua ka hae o ka poe hoomoana o ka Eperaima, ma ko lakou poe kana: a o ka luna o na mamo a Eperaima, oia o Elisama ke keiki a Amihuda, ");
INSERT INTO haw1868_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","A o kona poe kaua, a me na mea o lakou i heluia, he kanaha tausani a me na haneri keu elima. ");
INSERT INTO haw1868_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","A e pili ia ia ka ohana a Manage: a o ka luna o na mamo a Manase, oia o Gamaliela ke keiki a Pedazura. ");
INSERT INTO haw1868_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","A o kona poe kaua, a me na mea o lakou i heluia, he kanakolukumamalua tausani a me na haneri keu elua. ");
INSERT INTO haw1868_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Alaila o ka ohana a Beniamina: a o ka luna o na mamo a Beniamina, oia o Abidana ke keiki a Gideoni. ");
INSERT INTO haw1868_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","A o kona poe kaua, a me ka poe o lakou i heluia, he kanakolukumamalima tausani a me na haneri ken eha. ");
INSERT INTO haw1868_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","O ka poe a pau i heluia no kahi hoomoana o ka Eperaima, hookahi ia haneri me kumamawalu tausani me ka haneri hookahi, ma ko lakou mau poe kaua: a e hele aku hoi lakou ma ke kolu o ka huakai. ");
INSERT INTO haw1868_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Ma ka aoao akau ka hae o ka poe hoomoana o ka Dana ma ko lakou poe kaua: a o ka luna o na mamo a Dana, oia o Ahiezera ke keiki a Amisadai. ");
INSERT INTO haw1868_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","A o kona poe kaua, a o na mea o lakou i heluia, he kanaonokumamalua tausani me na haneri keu ehiku. ");
INSERT INTO haw1868_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","A o ka poe hoomoana me ia, oia ka ohana a Asera: a o ka luna o na mamo a Asera, oia o Pagiela ke keiki a Okerana. ");
INSERT INTO haw1868_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","O kona poe kaua, a me na mea o lakou i heluia, he kanahakumamakahi tausani a me na haneri keu elima. ");
INSERT INTO haw1868_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Alaila ka ohana a Napetali: a o ka luna o na mamo a Napetali, oia o Ahira ke keiki a Enana. ");
INSERT INTO haw1868_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","O kona poe kaua, a me na mea o lakou i heluia, he kanalimakumamakolu tausani a me na haneri keu eha. ");
INSERT INTO haw1868_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","O ka poe a pau i heluia ma kahi hoomoana o Dana, hookahi haneri me kanalimakumamahiku tausani a me na haneri keu eono: a o lakou nei ke hele mahope me ko lakou mau hae. ");
INSERT INTO haw1868_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","O keia ka poe i heluia o na mamo a Iseraela, ma ko ka hale o ko lakou poe kupuna: o na mea a pau i heluia o na wahi hoomoana, ma ko lakou mau poe kaua, he aono haneri me ke kumamakolu tausani, me na haneri keu elima a me ke kanalima. ");
INSERT INTO haw1868_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Aka, aole i heluia na Levi me na mamo a Iseraela; e like me ka Iehova i kauoha mai ai ia Mose. ");
INSERT INTO haw1868_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","A hana iho la na mamo a Iseraela e like me na mea a pau a Iehova i kauoha mai ai ia Mose: pela lakou i hoomoana ai ma ko lakou mau hae, a pela hoi lakou i hele aku ai, o kela mea keia mea mamu tili o ko lakou mau ohana, e like me ko ka hale o ko lakou poe kupuna. ");
INSERT INTO haw1868_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","EIA hoi na hanauna o Aarona laua o Mose, i ka la a Iehova i olelo mai ai ia Mose ma ka mauna o Sinai. ");
INSERT INTO haw1868_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Eia hoi na inoa o na keiki a Aarona; o Nadaba ka hiapo, o Abihu, o Eleazara, a o Itamara. ");
INSERT INTO haw1868_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Oia na inoa o na keiki a Aarona, na kahuna i poniia, ana i hoolaa ai e lawelawe ma ka oihana kahuna. ");
INSERT INTO haw1868_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","A make iho la o Nadaba laua o Abihu imua o Iehova, ia laua i kaumaha aku ai i ke ahi e imua o Iehova ma ka waonahele o Sinai, aole hoi a laua keiki: a lawelawe aku la o Eleazara laua o Itamara ma ka oihana kahuna imua o na maka o Aarona o ko laua makuakane. ");
INSERT INTO haw1868_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Olelo mai la o Iehova ia Mose i mai la, ");
INSERT INTO haw1868_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","E hooneenee mai i ka ohana a Levi a kokoke, a e hoonoho ia lakou inula o Aarona ke kahuna, i lawelawe lakou nana. ");
INSERT INTO haw1868_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Na lakou e malama i kana oihana, a me ka ke anainakanaka a pau ma ke alo o ka halelewa o ke anaina, e lawelawe i na mea o ka halelewa. ");
INSERT INTO haw1868_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Na lakou e malama i na mea hana a pau o ka halelewa o ke anaina, a me ka hana a na mamo a Iseraela, e hana'i i ka oihana o ka halelewa. ");
INSERT INTO haw1868_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","E haawi ae oe i na Levi no Aarona a no kana mau keiki: ua haawiia lakou a lilo loa nona, noloko o ka Iseraela. ");
INSERT INTO haw1868_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","E kauoha aku oe ia Aarona a me kana mau keiki, a e lawelawe lakou ma ka ke kahuna oihana; a o ke kanaka e ke hele mai a kokoke, e make ia. ");
INSERT INTO haw1868_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Olelo mai la o Iehova ia Mose, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","Owau nei hoi, ua hookaawale ae nei au i na Levi maiwaena mai o na mamo a Iseraela, i pauai no na hiapo a pau i hanau mua o na mamo a Iseraela; no ia mea, no'u no na Levi. ");
INSERT INTO haw1868_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","No ka mea, no'u no na makahiapo a pau: i ka la a'u i luku ai i na makahiapo a pau ma ka aina o Aigupita, hoolaa iho la hoi au no'u i na makahiapo ma ka Iseraela, i ka na kanaka a me ka na holoholona; no'u no lakou; owau no Iehova. ");
INSERT INTO haw1868_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Olelo mai la o Iehova ia Mose ma ka waonahele o Sinai, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","E helu oe i na mamo o Levi mamuli o ko ka hale a ko lakou poe kupuna, ma ko lakou mau ohana: o na kane a pau mai ka malama hookahi a keu aku kau e helu aku ai. ");
INSERT INTO haw1868_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","A helu iho la o Mose ia lakou mamuli o ka olelo a Iehoia, e like me ia i kauohaia mai ai ");
INSERT INTO haw1868_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Eia hoi na keiki a Levi ma ko lakou mau inoa; o Geresona, o Kohata, a o Merari. ");
INSERT INTO haw1868_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","A eia na inoa o na keiki a Geresona, ma ka laua mau ohana; o Libeni a o Simei. ");
INSERT INTO haw1868_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Eia hoi na keiki a Kohata ma ka lakou mau ohana; o Amerama, o Izehara, o Heberona a o Uziela. ");
INSERT INTO haw1868_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","A o na keiki a Merari, ma ka laua mau ohana; o Maheli a o Musi: oia na ohana o na Levi, ma ko ka hale o ko lakou poe kupuna. ");
INSERT INTO haw1868_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Na Geresona Ka ohana o na Libeni a me na Simei: oia na ohana o na keiki a Geresona. ");
INSERT INTO haw1868_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","O ko lakou poe i heluia ma ka helu ana i na kane a pau, mai ka malama hookahi a keu aku, o ka poe o lakou i heluia, he ehiku tausani a me na haneri keu elima. ");
INSERT INTO haw1868_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","A e hoomoana na ohana o ka Geresona mahope o ka halelewa ma ka aoao komohana. ");
INSERT INTO haw1868_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","A o ka luna ohana o ke kupuna o ka Geresona, oia o Eliasapa ke keiki a Laeia. ");
INSERT INTO haw1868_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","O ka mea a na mamo a Geresona e malama ai ma ka halelewa o ke anaina, oia o ka halelewa maloko, ka halelole a me ka mea uhi maluna, a me ka paku no ka puka o ka halelewa o ke anaina, ");
INSERT INTO haw1868_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","A me na paku o ka pa, a me ka pale no ka puka o ka pa, ka mea e pili ana ma ka halelewa a ma ke kuahu a puni, a me kona mau kaula no na oihana a pau ona. ");
INSERT INTO haw1868_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Na Kohata ka ohana o ka Amerama, me ka ohana o ka Izehara, a me ka ohana o ka Heberona, a me ka ohana o ka Uziela; oia na ohana o ka Kohata. ");
INSERT INTO haw1868_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","I ka helu ana i na kane a pau mai ka malama hookahi a keu aku, he ewalu tausani a me na haneri keu eono, e malama ana i na mea o kahi hoano. ");
INSERT INTO haw1868_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","E hoomoana na ohana a na keiki a Kohata ma ka aoao hema o ka halelewa. ");
INSERT INTO haw1868_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","A o ka luna o ka ohana kupuna o na ohana o ka Kohata, oia o Elizapana ke keiki a Uziela. ");
INSERT INTO haw1868_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","O ka lakou mea e malama ai, oia ka pahu, ka papaaina, ka ipukukui, na kuahu, a me na ipu o ke keenakapu, na mea a lakou e lawelawe ai, a me ka pale a me kana oihana a pau. ");
INSERT INTO haw1868_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","A o Eleazara ke keiki a Aarona ke kahuna, oia ka luna maluna o ka luna o na Levi, a e nana aku ia maluna o ka poe malama i ka oihana o ke keenakapu. ");
INSERT INTO haw1868_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Na Merari ka ohana o ka Maheli a me ka ohana o ka Musi: oia na ohana na Merari. ");
INSERT INTO haw1868_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","O na mea o lakou i heluia, ma ka helu ana i na kane a pau, mai ka malama hookahi a keu aku, eono ia tausani a me na haneri keu elua. ");
INSERT INTO haw1868_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","A o ka luna o ko ka hale o ka makua nana na ohana o Merari, oia o Zuriela ke keiki a Abihaila: e hoomoana lakou ma ka aoao akau o ka halelewa. ");
INSERT INTO haw1868_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","A o ka oihana malama a na keiki a Merari, oia na papa o ka halelewa, me kona mau kaola, a me kona mau pou, a me kona mau kumu, a me kona mau ipu, a me ka oihana a pau ilaila, ");
INSERT INTO haw1868_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","A me na pau o ka pa a puni, a me ko lakou mau kumu, a me ko lakou mau makia, a me ko lakou mau kaula. ");
INSERT INTO haw1868_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Aka, o ka poe hoomoana ma ke alo o ka halelewa, ma ka aoao hikina, imua o ka halelewa anaina ma ka hikina, oia o Mose a me Aarona a me kana mau keiki, i mea e malama ai i ke keenakapu, no ka oihana a na mamo a Iseraela: a o ke kanaka e ke hele mai a kokoke, e make no ia. ");
INSERT INTO haw1868_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","O na Levi a pau i heluia, a Mose laua o Aarona i helu ai mamuli o ke kauoha ana mai a Iehova, ma na ohana o lakou; o na kane a pau mai ka malama hookahi a keu aku, he iwakaluakumamalua tausani. ");
INSERT INTO haw1868_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Olelo mai la o Iehova ia Mose, E helu oe i na makahiapo kane a pau o na mamo a Iseraela, o ka malama hookahi a keu aku, a e helu hoi i na inoa o lakou. ");
INSERT INTO haw1868_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","E lawe oe i na Levi no'u, (owau no Iehova,) i panai no na hiapo a pau iwaena o na mamo a Iseraela; a i na holoholona o ka Levi i panai no na holoholona hiapo o na mamo a Iseraela. ");
INSERT INTO haw1868_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","A helu aku la o Mose i na makahiapo a pau iwaena o na mamo a Iseraela, e like me ka Iehova i kauoha mai ai ia ia. ");
INSERT INTO haw1868_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","O na makahiapo kane a pau, ma ka helu ana i na inoa, o ka poe o lakou i heluia mai ka malama hookahi a keu aku, he iwakaluakumamalua tausani, me na haneri elua a me ke kanahikukumamakolu. ");
INSERT INTO haw1868_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Olelo mai la o Iehova ia Mose, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","E lawe oe i na Levi i panai no na makahiapo a pau iwaena o na mamo a Iseraela, a me na holoholona o na Levi i panai no ko lakou poe holoholona, a no'u no na Levi: owau no Iehova. ");
INSERT INTO haw1868_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","A no ka poe e panaiia he elua haneri me kanahikukumamakolu o na hiapo o na mamo a Iseraela, ka i oi mamua o na Levi, ");
INSERT INTO haw1868_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","E auhau aku oe i na sekela elima no ke poo hookahi; ma ka sekela o ke keenakapu kau e auhau aku ai: (he iwakalua gera, hookahi ia sekela:) ");
INSERT INTO haw1868_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","A e haawi aku oe i ke kala a ka poe keu o lakou i panaiia'i, ia Aarona a me kana mau keikikane. ");
INSERT INTO haw1868_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Lawe ae la o Mose i ke kala panai a ka poe i koe o na mea i panaiia e na Levi. ");
INSERT INTO haw1868_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Lawe ae la oia i ke kala a na hiapo o na mamo a Iseraela; hookahi tausani, ekolu haneri me kanaonokumamalima na sekela, ma ka sekela o ke keenakapu. ");
INSERT INTO haw1868_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","A haawi aku la o Mose i ke kala a ka poe i panaiia, ia Aarona a me kana mau keikikane, e like me ka olelo a Iehova, me ka mea a Iehova i kauoha mai ai ia Mose. ");
INSERT INTO haw1868_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","OLELO mai la o Iehova ia Mose a me Aarona, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","E helu olua i na mamo a Kohata nowaena mai o na mamo a Levi, mamuli o ko lakou mau ohana, ma ko ka hale o ko lakou poe kupuna; ");
INSERT INTO haw1868_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Mai ke kanakolu o ka makahiki a keu aku, a hiki i ke kanalima o ka makahiki, i na mea a pau e komo ana iloko o ka poe nana e; hana i ka oihana ma ka halelewa o ke anaina. ");
INSERT INTO haw1868_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Eia no ka oihana a na mamo a, Kohata iloko o ka halelewa o ke anaina, no na mea hoano loa. ");
INSERT INTO haw1868_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","I ka wa e hele aku ai ka poe hoomoana, e haele mai o Aarona mo kana mau keikikane, a e hookuu ilalo lakou i ka pale uhi, a e hoouhi iho i ka pahu kanawai ia mea; ");
INSERT INTO haw1868_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","A e kau iho maluna olaila i ka uhi ili tahasa, a e hohola maluna i lole paapu i ka uliuli, a e hookomo i kona mau auamo. ");
INSERT INTO haw1868_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","A e hohola lakou i ka lole uliuli maluna o ka papa no ka berena hoike, a e kau maluna olaila i na ipu me na puna a me na bola, a me na kiaha no ka mohaiinu; a maluna iho ka berena hoomauia. ");
INSERT INTO haw1868_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","A e hohola iho lakou maluna o ia mau mea i ka lole ulaula, a e hoouhi ae ia mea i uhi ili tahasa, a e hookomo i kona mau auamo. ");
INSERT INTO haw1868_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","A e lawe lakou i lole uliuli, a e hoouhi i ke kumu kukui malamalama, a me na ipukukui ona, a me na upakoli ona, a me na ipuupakoli, a me kona mau ipu aila a pau, na mea a lakou e lawelawe ai no ia mea. ");
INSERT INTO haw1868_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","E hahao hoi lakou ia me na ipu ona a pau maloko o ka wahi ili tahasa, a e kau aku maluna o ka auamo. ");
INSERT INTO haw1868_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","A maluna o ke kuahu gula e hohola ai lakou i lole uliuli, a e hoouhi lakou ia i uhi ili tahasa, a e hookomo i kona mau auamo. ");
INSERT INTO haw1868_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","E lawe hoi lakou i na ipu a pau o ka oihana a lakou e lawelawe ai iloko o ke keenakapu, a e waiho iloko o ka lole uliuli, a e uhi iho ia mau mea i uhi ili tahasa, a e kau aku maluna o ka laau. ");
INSERT INTO haw1868_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","E lawe hoi lakou i ka lehu mai ke kuahu aku, a e hohola lakou i ka lole makue maluna iho. ");
INSERT INTO haw1868_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","A e kau aku lakou maluna ona i kona mau ipu a pau a lakou e lawelawe ai a puni, i na ipuahi, i na o no ka io, i na mea kope, a me na bola, a me na ipu a pau no ke kuahu; a e hohola lakou maluna i uhi ili tahasa, a e hookomo i kana mau auamo. ");
INSERT INTO haw1868_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","A pau ae la ka uhi ana o Aarona a me kana mau keikikane i ke keenakapu, i na ipu a pau o ke keenakapu, no ka neenee ana aku o ka poe hoomoana: a mahope iho, e hele mai na mamo a Kohata e halihali: aka, aole lakou e hoopa aku i kekahi mea i laa, o make lakou. O keia mau mea ka ukana a ka poe mamo a Kohata ma ka halelewa o ke anaina. ");
INSERT INTO haw1868_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Ua pili hoi i ka oihana a Eleazara ke keiki a Aarona ke kahuna, ka aila no ka malamalama, me ka mea ala oluolu, ka mohai ai i kela la i keia la, a me ka aila poni; ke kiai ana i ka halelewa a pau, a me na mea a pau oloko, iloko hoi o ke keenakapu, a iloko o na ipu ona a pau. ");
INSERT INTO haw1868_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Olelo mai la o Iehova ia Mose a me Aarona, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","Mai hooki aku olua i ka ohana o na hale o ka Kohata maiwaena aku o na Levi. ");
INSERT INTO haw1868_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","O keia ka olua e hana aku ai no lakou, i ola'i lakou, aole hoi e make, i ko lakou hele ana mai a kokoke i na mea hoano loa: na Aarona me kana mau keikikane e komo ae, a e haawi aku i kela kanaka i keia kanaka a pau i kana hana, a me kana ukana. ");
INSERT INTO haw1868_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Aole nae Iakou e komo iloko e nana i ka uhi ana i na mea hoano, o make lakou. ");
INSERT INTO haw1868_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Olelo mai la o Iehova ia Mose, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","E helu hoi oe i na mamo a Geresona, ma na hale a pau o ko lakou poe makuakane, ma na ohana a Iakou; ");
INSERT INTO haw1868_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Mai na makahiki he kanakolu a keu aku, a hiki i ke kanalima o na makahiki kau e helu aku ai ia lakou; i ka poe a pau e komo ae e lawelawe, a e hana i ka hana iloko o ka halelewa anaina. ");
INSERT INTO haw1868_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Eia ka hana a na ohana a ka Geresona e hana'i a e halihali ai: ");
INSERT INTO haw1868_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","E hali lakou i na paku o ka halelewa, a me ka halelewa o ke anaina, a me kona uhi, a me ka uhi ili tahasa maluna iho ona, a me ka pale no ka puka o ka halelewa o ke anaina, ");
INSERT INTO haw1868_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","A me na paku o ka pa, a me ka paku no ka puka o ka pa, ma ka halelewa a ma ke kuahu a puni, a me ko lakou mau kaula, a me na ipu a lakou i lawehana'i, a me na mea a pau i hanaia no ia mau mea; pela no lakou e hana'i. ");
INSERT INTO haw1868_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Ma ke kauoha a Aarona a me kana mau keiki ka hana a pau a na mamo a Geresona, no ka lakou mau ukana a pau, a me ka lakou hana a pau: a e haawi aku oukou i ka lakou ukana a pau na lakou e malama. ");
INSERT INTO haw1868_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Oia ka hana a na ohana mamo a Geresona ma ka halelewa o ke anaina: a o ka lakou hana, malalo ia o ka lima o Itamara ke keiki a Aarona ke kahuna. ");
INSERT INTO haw1868_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","A no na mamo a Merari, e helu oe ia lakou mamuli o ka lakou mau ohana, ma ka hale o ko lakou poe makuakane: ");
INSERT INTO haw1868_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Mai ke kanakolu o na makahiki a keu aku, a hiki i ke kanalima o ka makahiki kau e helu ai ia lakou, o kela mea keia mea e komo aku e lawelawe, a e hana i ka hana o ka halelewa anaina. ");
INSERT INTO haw1868_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Eia hoi ka malama ana o ka lakou ukana, e like me ka lakou hana a pau ma ka halelewa o ke anaina: o na papa o ka halelewa, a me kona mau kaola, a me kona mau kia, a me kona mau kumu, ");
INSERT INTO haw1868_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","A me na pau no ka pa a puni, a me ko lakou mau kumu, a me na makia o ia mau mea, a me ko lakou mau kaula, me na ipu o lakou a pau, a me ka lakou mau hana a pau: ma ka inoa ka oukou e helu ai i na mea i malamaia'i no ka lakou ukana. ");
INSERT INTO haw1868_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Oia ka hana a na ohana mamo a Merari, no ka lakou hana a pau ma ka halelewa o ke anaina, malalo o ka lima o Itamara ke keiki a Aarona ke kahuna. ");
INSERT INTO haw1868_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Helu aku la o Mose me Aarona, a me na luna o ke anaina kanaka, i na mamo a Kohata mamuli o ka lakou mau ohana, a ma ko ka hale o ko lakou poe kupuna; ");
INSERT INTO haw1868_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","Mai ke kanakolu o na makahiki a keu aku, a hiki i ke kanalima, i na mea a pau i komo iloko o ka oihana, no ka hana ma ka halelewa o ke anaina. ");
INSERT INTO haw1868_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","A o na mea o lakou i heluia ma ko lakou mau ohana, he elua tausani me na haneri ehiku a me ke kanalima. ");
INSERT INTO haw1868_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Oia ka poe i heluia no na ohana a Kohata, o na mea a pau e pono ke hana i ka hana ma ka halelewa o ke anaina kanaka, o na mea a Mose laua o Aarona i hehu ai, e like me ke kauoha a Iehova, ma ka lima o Mose. ");
INSERT INTO haw1868_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","A o ka poe mamo a Geresona i heluia, ma ka lakou mau ohana a pau, a ma ko ka hale o ko lakou poe kupuna, ");
INSERT INTO haw1868_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","Mai ke kanakolu o na makahiki a keu aku, a hiki i ke kanalima o na makahiki; o na mea a pau e komo maloko o ka oihana, no ka hana ma ka halelewa o ke anaina; ");
INSERT INTO haw1868_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","O na mea o lakou i heluia, ma ko lakou mau ohana a pau, ma ko ka hale o ko lakou poe kapuna, he elua tausani eono haneri a me ke kanakolu. ");
INSERT INTO haw1868_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Oia na mea i heluia o na ohana mamo a Geresona, o na mea a pau e pono ke hana i ka hana ma ka halelewa o ke anaina, na mea a Mose laua o Aarona i helu ai, mamuli o ke kauoha ana a Iehova. ");
INSERT INTO haw1868_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","A o ka poe i heluia o na ohaua mamo a Merari, ma ko lakou mau ohana, ma ko ka hale o ko lakou poe kupuna, ");
INSERT INTO haw1868_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","Mai ke kanakolu o na makahiki a keu aku, a hiki i ke kanalima o na makahiki, o na mea a pau e komo maloko o ka oihana, no ka hana ma ka halelewa o ke anaina; ");
INSERT INTO haw1868_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","O na mea o lakou i heluia mamuli o ko lakou mau ohana, he ekolu tausani me na haneri elua. ");
INSERT INTO haw1868_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Oia na mea i heluia o na ohana mamo a Merari, ka poe a Mose laua o Aarona i helu ai, mamuli o ka olelo a Iehova ma ka lima o Mose. ");
INSERT INTO haw1868_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","O ka poe a pau o na Levi i heluia, ka poe a Mose me Aarona a me na luna o ka Iseraela i helu ai, ma ko lakou mau ohana, a ma ku ka hale o ko lakou poe kupuna; ");
INSERT INTO haw1868_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","Mai ke kanakolu o na makahiki a keu aku, a hiki i ke kanalima o na makahiki, o na mea a pau i hele mai e hana i ka oihana lawe lawe, a me ka oihana o ka hali ukana ma ka halelewa o ke anaina: ");
INSERT INTO haw1868_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","O na mea o lakou i heluia, he awalu tausani elima haneri a me ke kanawalu. ");
INSERT INTO haw1868_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","E like me ka Iehova i kauoha ai, ua heluia lakou ma ka lima o Mose, o kela kanaka keia kanaka ma kana hana, a ma kana ukana: pela i heluia'i lakou e ia, e like me ka Iehova i kauoha mai ai ia Mose. ");
INSERT INTO haw1868_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","OLELO mai la o Iehova ia Mose, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","E kauoha aku oe i na mamo a Iseraela, e hookuke aku i na lepero a pau iwaho o kahi hoomoana, a me na mea mai puha a pau, a me na mea a pau i haumia i ke kupapau. ");
INSERT INTO haw1868_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","O na kane a me na wahine ka oukou e hookuke aku ai iwaho o kahi hoomoana, i hoohaumia ole ai lakou i ko lakou mau wahi hoomoana, kahi a'u e noho nei iwaena konu. ");
INSERT INTO haw1868_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Pela no i hana'i ka poe mamo a Iseraela, a hookuke aku la ia lakou iwaho o kahi hoomoana: me ka Iehova i olelo mai ai ia Mose, pela no na mamo a Iseraela i hana'i. ");
INSERT INTO haw1868_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Olelo mai la o Iehova ia Mose, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","E olelo aku oe i na mamo a Iseraela, Ina he kane paha he wahine paha, e hana i kekahi hewa, i ka mea a kanaka e hana'i, e lawehala ai ia Iehova, a i hewa ua kanaka la; ");
INSERT INTO haw1868_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Alaila, e hai mai lakou i ka hewa a lakou i hana'i: a e uku aku no ia i kana mea i lawehala ai, ma ke kumu o ia mea, a e hai pu me ia i ka hapalima hou aku o ia mea, a e haawi aku ia na ka mea ia ia kona lawehala ana. ");
INSERT INTO haw1868_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Ina paha aohe hoahanau no ua kanaka la, i ukuia'ku ai nona ka uku o ka hewa, alaila e ukuia'ku ka hewa ia Iehova, i ke kahuna hoi; he okoa ka hipakane kalahala, nana e kalaia'i ka hala nona. ");
INSERT INTO haw1868_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","A o na mohai a pau no na mea laa a pau a ka poe mamo a Iseraeal, na mea a lakou e lawe mai ai i ke kahuna, e lilo ia nana. ");
INSERT INTO haw1868_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Nana no hoi na mea laa a pau a kela kanaka keia kanaka: na mea a kekahi kanaka e haawi mai ai i ke kahuna, e lilo ia nana. ");
INSERT INTO haw1868_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Olelo mai la o Iehova ia Mose, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","E olelo aku oe i na mamo a Iseraela, e i aku ia lakou, A i lalau ka wahine a kekahi kanaka, a e hana aku i ka mea e hewa ai ia ia, ");
INSERT INTO haw1868_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","A moe kolohe kekahi kanaka me ia, a ua hunaia ua mea la mai na maka aku o kana kane, a ua uhiia ia, a ua haumia oia; aohe mea hoike e ku e ia ia, aole hoi i loaa paka oia; ");
INSERT INTO haw1868_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","A i kau mai ka manao lili maluna o ke kane, a lili aku paha ia i kana wahine, a ua haumia kela: ina hoi e kau ka manao lili ia ia, a lili aku no ia i kana wahine, a ua haumia ole paha kela; ");
INSERT INTO haw1868_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","Alaila, e alakai aku ke kane i kana wahine i ke kahuna, a e lawe aku ia i kana mohai nona, i ka hapaumi o ka epa palaoa bale; aole ia e ninini i ka aila maluna, aole hoi e kau iho i ka libano maluna; no ka mea, he mohai ia no ka lili, he mohai hoomanao, e paipai ana e hoomanao i ka hewa. ");
INSERT INTO haw1868_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","A e alakai mai ke kahuna i ka wahine a kokoke, a e hoonoho ia ia imua o Iehova. ");
INSERT INTO haw1868_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","E lawe hoi ke kahuna i wahi wai laa iloko o ka ipu lepo; a e lawe ke kahuna i kekahi lepo o ka papalalo o ka halelewa, a e hahao iho iloko o ua wai la. ");
INSERT INTO haw1868_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","A e hoonoho ke kahuna i ka wahine imua o Iehova, a e wehe i ka pale o ke poo o ua wahine la, a e waiho i ka mohai hoomanao iloko o kona lima, oia ka mohai no ka lili; a e paa ke kahuna i ka wai awaawa e hoopoino ai ma kona lima iho. ");
INSERT INTO haw1868_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","A e kauoha aku ke kahuna ia ia ma ka hoohiki ana, a e elele aku ia i ka wahine, Ina i moe pu ole kekahi kanaka me oe, ina hoi i lalau ole ae oe i ka haumia me ka mea aole o kau kane iho, alaila ua kaawale oe i keia wai awaawa e hoopoino ai. ");
INSERT INTO haw1868_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Aka, ina he oiaio kou lalau ana'e i ka haumia me ka mea aole o kau kane iho, a ina i haumia io oe, a ua moe kekahi kanaka aole o kau kane me oe; ");
INSERT INTO haw1868_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","Alaila, e kauoha aku ke kahuna i ka wahine ma ka olelo hoohiki no ka hoino ana; a e i aku ke kahuna i ua wahine ia, E hoolilo auanei o Iehova ia oe i mea poino, a i mea hoohikl ino ia iwaena o kou poe kanaka, i ka manawa a Iehova e hoowiwi iho ai i kou uha, a e hoopehu ai i kou opu: ");
INSERT INTO haw1868_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","A o keia wai hoopoino, e komo no ia iloko o kou opu i mea e pehu ai ka opu, a e wiwi ai ka uha. Alaila e olelo mai ka wahine, Amene, amene. ");
INSERT INTO haw1868_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","A e palapala ke kahuna i keia mau hoino ana iloko o ka buke, a e holoi iho ia mea i ka wai awaawa. ");
INSERT INTO haw1868_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","A e hooinu oia i ka wahine i ka wai awaawa, i ka mea e hoopoino ai: a o ka wai e hoopoino ai, e komo ia iloko ona, he mea awaawa. ");
INSERT INTO haw1868_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Alaila e lawe ke kahuna i ka mohai no ka lili, mailoko mai o ka lima o ka wahine, a e hoali ae ia i ua mohai la imua o Iehova, a e kaumaha aku maluna o ke kuahu. ");
INSERT INTO haw1868_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","E lawe hoi ke kahuna i kauwahi o ka mohai a piha kona lima, i ka mea paipai manao, a e kuni ia i ke ahi maluna o ke kuahu; a mahope iho, e hooinu oia i ka wahine i ka wai. ");
INSERT INTO haw1868_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","A pau kona hooinu ana ia ia i ka wai, alaila, ina ua haumia ka wahine, a i hana oia i ka mea e hewa ai i kana kane, e komo no ua wai la ka mea e hoopoino ai iloko ona, he mea awaawa; a e pehu mai kona opu, a e wiwi iho kona uha; a e lilo ua wahine la i mea e hoinoia'i iwaena o kona hanauna kanaka. ");
INSERT INTO haw1868_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Ina hoi ua haumia ole ka wahine, he maemae no; alaila ua ola ia, a e hapai ia i na keiki. ");
INSERT INTO haw1868_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Oia ke kanawai no na lili ana, i ka manawa i huli ai ka wahine i ka mea aole o kana kane, a ua haumia oia; ");
INSERT INTO haw1868_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","A i ka manawa paha e kau ai ka manao lili maluna ona, a e lili aku ia i kana wahine, a e hoonoho aku ia ia imua o Iehova, a e hoopili aku ke kahuna i keia kanawai a pau ia ia: ");
INSERT INTO haw1868_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Alaila e kaawale ua kanaka la i ka hewa, a e lawe hoi ka wahine i kona hewa iho. ");
INSERT INTO haw1868_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","OLELO mai la o Iehova ia Mose, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","E olelo aku oe i na mamo a Iseraela, e i aku ia lakou, O ke kanaka, o ka wahine paha ke hoolaa ia ia iho no ka hoohiki i ka hoohiki ana a ka Nazarite, a e hookaawale ia ia iho no Iehova; ");
INSERT INTO haw1868_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","E hookaawale ia ia iho i ka waina, a me ka mea ona, aole ia e inu i ka vinega o ka waina, aole hoi i ka vinega o ka mea ona, aole hoi ia e inu i ka wai i kohu i na huawaina, aole hoi ia e ai i na huawaina maka, aole hoi i na huawaina maloo. ");
INSERT INTO haw1868_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","I na la a pau o kona kaawale ana no Iehova, aole ia e ai i kekahi mea no ke kumuwaina, aole i na anoano, aole hoi i ka ili. ");
INSERT INTO haw1868_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","I na la a pau o kona hoohiki ana e noho kaawale, aole e pili mai ka pahi amu ma kona poo; a pau na la i hookaawaleia'i oia no Iehova, e noho laa ia, a e ulu loa na lauoho o kona poo. ");
INSERT INTO haw1868_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","I na la a pau o kona noho kaawale ana no Iehova, aole ia e hele a pili aku i ke kupapau. ");
INSERT INTO haw1868_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Aole ia e hoohaumia ia ia iho no kona makuakane, aole hoi no kona makuwahine, aole hoi no kona hoahanaukane, aole hoi no ko na hoahanauwahine, ke make lakou; no ka mea, aia no maluna ona ke kapu no kona Akua. ");
INSERT INTO haw1868_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","I na la a pau o kona kaawale ana, ua laa ia no Iehova. ");
INSERT INTO haw1868_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","A ina e make koke kekahi kanaka e pili ana me ia, a haumia ke poo o kona laa ana: alaila e amu ia i kona poo i ka la o kona huikala ana, i ka hiku o ka la e amu ai ia. ");
INSERT INTO haw1868_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","A i ka walu o ka la, e lawe mai oia i elua manu kuhukuku, a i elua manu nunu opiopio paha i ke kahuna, ma ka puka o ka halelewa o ke anaina. ");
INSERT INTO haw1868_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","A e kaumaha aku ke kahuna i kekahi i mohaihala, a i kekahi i mohaikuni, a e hookalahala aku ia nona, no ka mea ana i hewa ai i ke kupapau, a e hoolaa aku ia i kona poo ia la. ");
INSERT INTO haw1868_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","A e hoolaa aku ia no Iehova i na la o kona kaawale ana, a e lawe mai ia i keikihipa o ka makahiki mua i mohaihala: aka e haule wale iho na la mamua, no ka mea, ua haumia kona kaawale ana. ");
INSERT INTO haw1868_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","Eia hoi ke kanawai no ka Nazarite: aia pau na la o kona kaawale ana, e hele mai ia ma ka puka o ka halelewa o ke anaina: ");
INSERT INTO haw1868_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","A e kaumaha aku ia i kana mohai na Iehova, i hookahi keikihipa o ka makahiki mua, i mohaikuni; a i hookahi keikihipa wahine kina ole o ka makahiki mua, i mohaihala; a i hookahi hipakane kina ole i mohaihoomalu; ");
INSERT INTO haw1868_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","A me ka hinai berena hu ole, me na pai palaoa i kawili pu ia me ka aila, a me na wepa palaoa ha ole i kahinuia i ka aila, a me ka lakou mohaiai, a me ka lakou mohaiinu. ");
INSERT INTO haw1868_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","A e lawe mai ke kahuna ia mau mea imua o Iehova, a e kaumaha aku i kana mohaihala a me kana mohaikuni. ");
INSERT INTO haw1868_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","E kaumaha aku hoi ia i ka hipakane i mohai hoomalu no Iehova, me ka hinai berena hu ole: e kaumaha hoi ke kahuna i kana mohaiai a me kana mohaiinu. ");
INSERT INTO haw1868_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","A e amu ka Nazarite i kona poo i hoolaaia ma ka puka o ka halelewa o ke anaina; a e lawe ia i ka lauoho o kona poo i hoolaaia, a e waiho iloko o ke ahi malalo o na mohaihoomalu. ");
INSERT INTO haw1868_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","A e lawe ke kahuna i ka uha mua o ka hipakane i hoolapalapaia, me kekahi pai palaoa hu ole mailoko mai o ka hinai, a me kekahi wepa hu ole, a e kau aku ia mau mea ma na lima o ka Nazarite, mahope iho o kona amu ana i ka mea laa. ");
INSERT INTO haw1868_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","A e hoali ke kahuna ia mau mea i mohaihoali imua o Iehova: oia ka mea laa na ke kahuna, me ka umauma hoali a me ka uha mua i kaikaiia. A mahope e pono no ka Nazarite ke inu i ka waina. ");
INSERT INTO haw1868_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Oia ke kanawai no ka Nazarite hoohiki, a no kana mohai na Iehova no kona hookaawale ana; he okoa ka mea a kona lima i loaa'i: e like me ka hoohiki ana ana i hoohiki ai, pela no oia e hana'i ma ke kanawai o kona kaawale ana. ");
INSERT INTO haw1868_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Olelo mai la o Iehova ia Mose, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","E olelo aku oe ia Aarona a me kana mau keiki, e i aku, Penei oukou e hoomaikai aku ai i na mamo a Iseraela, i ka i ana aku ia lakou, ");
INSERT INTO haw1868_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","Na Iehova oe e hoomaikai mai, a e malama mai; ");
INSERT INTO haw1868_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Na Iehova e kau mai i ka malamalama o kona maka maluna iho ou, a e lokomaikai mai ia oe. ");
INSERT INTO haw1868_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Na Iehova e maliu mai ia oe, a e haawi mai i malu nou. ");
INSERT INTO haw1868_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","A e kau aku lakou i ko'u inoa maluna iho o na mamo a Iseraela, a e hoopomaikai aku au ia lakou. ");
INSERT INTO haw1868_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","EIA hoi, I ka la a Mose i hoopau ai i ke kukulu ana i ka halelewa, a pau ia i ka poniia a me ka hoolaaia, oia a me na mea paahana a pau ona, o ke kuahu a me kona mau ipu a pau, a poni iho oia ia mau mea, a hoolaa hoi; ");
INSERT INTO haw1868_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Alaila kaumaha aku la na luna o ka Iseraela, na luna o ka hale o ko lakou poe kupuna, o lakou na luna ohana, na mea i ku maluna o ka poe i heluia; ");
INSERT INTO haw1868_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Lawe mai la lakou i ka lakou mau mohai imua o Iehova, i eono mau kaa i uhiia, a me na bipikauo he umikumamalua: hookahi kaa a na luna elua, a me ka bipi i pakahiia mai e kela mea keia mea: a lawe mai la lakou ia mau mea imua o ka halelewa. ");
INSERT INTO haw1868_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Olelo mai la o Iehova ia Mose, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","E lawe oe ia mau mea na lakou mai, i lilo ia e hana i ka hana o ka halelewa o ke anaina; a e haawi aku oe ia mau mea no na Levi, i kela kanaka keia kanaka e like me kana e hana'i. ");
INSERT INTO haw1868_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","A lawe ae la o Mose i na kaa a me na bipi, a haawi aku la no na Levi. ");
INSERT INTO haw1868_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Haawi aku la ia i na kaa elua a me na bipi eha no na mamo a Geresona, e like me ka lakou mea e hana'i. ");
INSERT INTO haw1868_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Eha na kaa me na bipi ewalu kana i haawi aku ai no na mamo a Merari, e like me ka lakou mea e hana'i, malalo o ka lima o Itamara ke keiki a Aarona ke kahuna. ");
INSERT INTO haw1868_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Aole ia i haawi aku no na mamo a Kohata, no ka mea, o ka oihana o ke keenakapu i pili ia lakou, he mea ia e amo ai maluna o ko lakou mau poohiwi. ");
INSERT INTO haw1868_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Kaumaha aku la na luna i ka mohai hoolaa i ke kuahu, i ka la i poniia'i ia, a mohai aku la na luna i ka lakou mohai imua o ke kuahu. ");
INSERT INTO haw1868_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Olelo mai la o Iehova ia Mose, E kaumaha lakou i ka lakou mohai, o kela luna keia luna i kona la iho, no ka hoolaa ana i ke kuahu. ");
INSERT INTO haw1868_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","A o ka mea nana i kaumaha aku i kaua mohai i ka la mua, oia o Nahesona ko keiki a Aminadaba, no ka ohana a Iuda: ");
INSERT INTO haw1868_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","A o kana mohai, hookahi ia pa kala, he haneri ia me kanakolu na sekela ma ke kau paona ana; hookahi bola kala, ho kanahiku na sekela, ma ka sekela o ke keenakapu, a ua piha ia mau mea a elua i ka palaoa i kawili pu ia me ka aila, i mohaiai: ");
INSERT INTO haw1868_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","Hookahi puna, he umi sekela gula, ua piha i ka mea ala: ");
INSERT INTO haw1868_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","Hookahi bipikeikikane, hookahi hipakane, hookahi keikihipa o ka makahiki mua, i mohaikuni: ");
INSERT INTO haw1868_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","Hookahi keikikao i mohaihala: ");
INSERT INTO haw1868_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","A no ka mohaihoomalu, elua bipi, elima hipakane, elima kaokane, elima hoi keikihipa o ka makahiki mua. Oia ka mohai a Nahesona ke keiki a Aminadaba. ");
INSERT INTO haw1868_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","I ka lua o ka la, mohai aku la o Netaneela ke keiki a Zuara, ka luna o ka Isakara. ");
INSERT INTO haw1868_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Kaumaha aku la ia i kana mohai, hookahi ia pa kala, he haneri a mo kanakolu na sekela ma ke kau paona ana, hookahi bola kala, he Kanahiku sekela ma ka sekela o ke keenakapu; ua piha ia mau mea a elua i ka palaoa i kawili pu ia me ka aila, i mohaiai: ");
INSERT INTO haw1868_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","Hookahi puna gula, he umi na sekela, ua piha i ka mea ala: ");
INSERT INTO haw1868_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","Hookahi keikibipikane, hookahi hipakane, hookahi keikihipa o ka makahiki mua, i mohaikuni: ");
INSERT INTO haw1868_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","Hookahi keikikao i mohaihala: ");
INSERT INTO haw1868_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","A no ka mohaihoomalu, i elua mau bipi, elima hipakane, elima kaokane, elima keikihipa o ka makahiki mua. Oia ka mohai a Netaneela ke keiki a Zuara. ");
INSERT INTO haw1868_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","I ke kolu o ka la, kaumaha aku la o Eliaba ke keiki a Helona, ka luna o na mamo a Zebuluna. ");
INSERT INTO haw1868_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","O kana mohai, hookahi ia pa kala, he haneri a me kanakolu sekela ma ke kau paona ana, hookahi bola kala, he kanahiku sekela, ma ka sekela o ke keenakapu; ua piha ia mau mea a elua i ka palaoa i kawili pu ia me ka aila, i mohaiai: ");
INSERT INTO haw1868_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","Hookahi puna gula, he umi sekela, ua piha i ka mea ala. ");
INSERT INTO haw1868_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","Hookahi keikibipikane, hookahi hipakane, hookahi keikihipa o ka makahiki mua, i mohaikuni: ");
INSERT INTO haw1868_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","Hookahi keikikao i mohaihala: ");
INSERT INTO haw1868_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","A no ka mohaihoomalu, elua bipikane, elima hipakane, elima kaokane, elima keikihipa o ka makahiki mua Oia ka mohai a Eliaba ke keiki a Helona. ");
INSERT INTO haw1868_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","I ka ha o ka la, kaumaha aku la o Elizura ke keiki a Sedeura, ka luna o na mamo a Reubena. ");
INSERT INTO haw1868_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","O kana mohai, hookahi pa kala, he haneri me ke kanakolu na sekela o ke kau paona ana, hookahi bola, he kanahiku na sekela, ma ka sekela o ke keenakapu; ua piha ia mau mea a elua i ka palaoa i kawili pu ia me ka aila, i mohaiai. ");
INSERT INTO haw1868_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","Hookahi puna gula, he umi na sekela, ua piha i ka mea ala. ");
INSERT INTO haw1868_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","Hookahi keikibipikane, hookahi hipakane, hookahi keikihipa o ka makahiki mua, i mohaikuni; ");
INSERT INTO haw1868_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","Hookahi keikikao i mohaihala: ");
INSERT INTO haw1868_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","A no ka mohaihoomalu, elua bipikane, elima hipakane, elima kaokane, elima keikihipa o ka makahiki mua. Oia ka mohai a Elizura ke keiki a Sedeura. ");
INSERT INTO haw1868_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","I ka lima o ka la, kaumaha aku la o Selumiela ke keiki a Zurisadai, ka luna o na mamo a Simeona. ");
INSERT INTO haw1868_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","O kana mohai, hookahi ia pa kala, he haneri me kanakolu sekela o ke kau paona ana, hookahi bola kala, he kanahiku na sekela, ma ka sekela o ke keenakapu; ua piha ia mau mea a elua i ka palaoa i kawili pu ia me ka aila, i mohaiai. ");
INSERT INTO haw1868_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","Hookahi puna gula, he umi na sekela, ua piha i ka mea ala. ");
INSERT INTO haw1868_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","Hookahi keikibipikane, hookahi hipakane, hookahi keikihipa o ka makahiki mua, i mohaikuni: ");
INSERT INTO haw1868_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","Hookahi kaokeiki i mohaihala: ");
INSERT INTO haw1868_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","A no ka mohaihoomalu, elua bipikane, elima hipakane, elima kaokane, elima keikihipa o ka makahiki mua. Oia ka mohai a Selumiela ke keiki a Zerusadai. ");
INSERT INTO haw1868_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","I ke ono o ka la, kaumaha aku la o Eliasapa ke keiki a Deuela, ka luna o na mamo a Gada. ");
INSERT INTO haw1868_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","O kana mohai, hookahi ia ipu kala, he haneri me ke kanakolu na sekela ma ke kau paona ana, hookahi bola kala he kanahiku na sekela, ma ka sekela o ke keenakapu; ua piha ia mau mea a elua i ka palaoa i kawiliia me ka aila, i mohaiai: ");
INSERT INTO haw1868_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","Hookahi puna gula, he umi na sekela, ua piha i na mea ala: ");
INSERT INTO haw1868_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","Hookahi keikibipikane, hookahi hipakane, hookahi keikihipa o ka makahiki mua, i mohaikuni. ");
INSERT INTO haw1868_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","Hookahi keikikao i mohaihala: ");
INSERT INTO haw1868_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","A no ka mohaihoomalu, elua bipikane, elima hipakane, elima kaokane, elima keikihipa o ka makahiki mua Oia ka mohai a Eliasapa ke keiki a Deuela. ");
INSERT INTO haw1868_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","I ka hiku o ka la, kaumaha aku la o Elisama, ke keiki a Amihuda, ka luna o na mamo a Eperaima. ");
INSERT INTO haw1868_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","O kana mohai, hookahi pa kala, hookahi ia haneri a me ke kanakolu na sekela ma ke kau paona ana, hookahi bola kala, he kanahiku na sekela ma ka sekela o ke keenakapu; ua piha ia mau mea a elua i ka palaoa i kawili pu ia me ka aila, i mohaiai: ");
INSERT INTO haw1868_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","Hookahi puna gula, he umi na sekela, ua piha i ka mea ala: ");
INSERT INTO haw1868_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","Hookahi bipikeikikane, hookahi hipakane, hookahi keikihipa o ka makahiki mua, i mohaikuni: ");
INSERT INTO haw1868_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","Hookahi keikikao i mohaihala: ");
INSERT INTO haw1868_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","A no ka mohaihoomalu, elua bipikane, elima hipakane, elima kaokane, elima keikihipa o ka makahiki mua. Oia ka mohai a Elisama ke keiki a Amihuda. ");
INSERT INTO haw1868_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","I ka walu o ka la, kaumaha aku la o Gamaliela ke keiki a Pedazura, ka luna o na mamo a Manase. ");
INSERT INTO haw1868_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","O kana mohai, hookahi pa kala, hookahi haneri a me kanakolu na sekela o ke kau paona ana, hookahi bola kala, he kanahiku na sekela, ma ka sekela o ke keenakapu, ua piha ia mau mea a elua i ka palaoa i kawili pu ia me ka aila i mohaiai: ");
INSERT INTO haw1868_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","Hookahi puna gula, he umi na sekela, ua piha i ka mea ala: ");
INSERT INTO haw1868_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","Hookahi bipikeikikane, hookahi hipakane, hookahi keikihipa o ka makahiki mua, i mohaikuni: ");
INSERT INTO haw1868_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","Hookahi keikikao i mohaihala: ");
INSERT INTO haw1868_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","A no ka mohaihoomalu, elua bipikane, elima hipakane, elima kaokane, elima keikihipa o ka makahiki mua. Oia ka mohai a Gamaliela ke keiki a Pedazura. ");
INSERT INTO haw1868_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","I ka iwa o ka la, kaumaha aku la o Abidana ke keiki a Gideoni, ka luna o na mamo a Beniamina. ");
INSERT INTO haw1868_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","O kana mohai, hookahi pa kala, hookahi haneri a me ke kanakolu na sekela o ke kau paona ana, hookahi bola, he kanahiku na sekela ma ka sekela o ke keenakapu; ua piha ia mau mea a elua i ka palaoa i kawili pu ia me ka aila, i mohaiai: ");
INSERT INTO haw1868_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","Hookahi puna gula, he umi na sekela, ua piha i ka mea ala: ");
INSERT INTO haw1868_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","Hookahi keikibipikane, hookahi hipakane, hookahi hipakeiki o ka makahiki mua, i mohaikuni: ");
INSERT INTO haw1868_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","Hookahi keikikao i mohaihala: ");
INSERT INTO haw1868_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","A no ka mohaihoomalu, elua bipikane, elima hipakane, elima kaokane, elima keikihipa o ka makahiki mua. Oia ka mohai a Abidana ke keiki a Gideoni. ");
INSERT INTO haw1868_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","I ka umi o ka la, kaumaha aku la o Ahiezera ke keiki a Amisadai, ka luna o na mamo a Dana. ");
INSERT INTO haw1868_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","O kana mohai, hookahi ia pa kala, hookahi haneri a me ke kanakolu na sekela o ke kau paona ana, hookahi bola kala, he kanahiku na sekela, ma ka sekela o ke keenakapu; ua piha ia mau mea a elua i ka palaoa i kawili pu ia me ka aila, i mohaiai: ");
INSERT INTO haw1868_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","Hookahi puna gula, he umi sekela, ua piha i ka mea ala: ");
INSERT INTO haw1868_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","Hookahi bipikeikikane, hookahi hipakane, hookahi keikihipa o ka makahiki mua, i mohaikuni: ");
INSERT INTO haw1868_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","Hookahi keikikao i mohaihala: ");
INSERT INTO haw1868_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","A no ka mohaihoomalu, elua bipikane, elima hipakane, elima kaokane, elima keikihipa o ka makahiki mua. Oia ka mohai a Ahiezera ke keiki a Amisadai. ");
INSERT INTO haw1868_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","I ka umikumamakahi o ka la, i kaumaha aku ai o Pagiela, ke keiki a Okerana, ka luna o na mamo a Asera. ");
INSERT INTO haw1868_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","O kana mohai, hookahi ia pa kala, hookahi haneri a me ke kanakolu na sekela o ke kau paona ana, hookahi bola kala, he kanahiku sekela, ma ka sekela o ke keenakapu; ua piha ia mau mea a elua i ka palaoa i kawili pu ia me ka aila, i mohaiai: ");
INSERT INTO haw1868_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","Hookahi puna gula, he umi na sekela, ua piha i ka mea ala: ");
INSERT INTO haw1868_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","Hookahi keikibipikane, hookahi hipakane, hookahi keikihipa o ka makahiki mua, i mohaikuni: ");
INSERT INTO haw1868_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","Hookahi keikikao i mohaihala: ");
INSERT INTO haw1868_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","A no ka mohaihoomalu, elua bipikane, elima hipakane, elima kaokane, elima keikihipa o ka makahiki mua. Oia ka mohai a Pagiela ke keiki a Okerana. ");
INSERT INTO haw1868_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","I ka umikumamalua o ka la, kaumaha aku la o Ahira ke keiki a Enana, ka luna o na mamo a Napetali. ");
INSERT INTO haw1868_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","O kana mohai, hookahi ia pa kala, hookahi haneri a me kanakolu na sekela o ke kau paona ana, hookahi bola kala, he kanahiku na sekela, ma ka sekela o ke keenakapu; ua piha ia mau mea a elua i ka palaoa i kawili pu ia me ka aila, i mohaiai: ");
INSERT INTO haw1868_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","Hookahi puna gula, he umi sekela, na piha i ka mea ala: ");
INSERT INTO haw1868_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","Hookahi keikibipikane, hookahi hipakane, hookahi keikihipa o ka makahiki mua, i mohaikuni: ");
INSERT INTO haw1868_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","Hookahi keikikao i mohaihala: ");
INSERT INTO haw1868_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","A no ka mohaihoomalu, elua bipikane, elima hipakane, elima kaokane, elima keikihipa o ka makahiki mua. Oia ka mohai a Ahira ke keiki a Enana. ");
INSERT INTO haw1868_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Oia ka hoolaa ana o ke kuahu, i ka la i poniia'i oia e na luna o ka Iseraela; he umikumamalua na pa kala, he umikumamalua na bola kala, he umikumamalua puna gula; ");
INSERT INTO haw1868_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Hookahi haneri a me ke kanakolu na sekela ke kau paona ana o kela ipu kala o keia ipu kala, he kanahiku na sekela o kela bola keia bola: o na ipu kala a pau, he elua tausani eha haneri na sekela, ma ka sekela o ke keenakapu. ");
INSERT INTO haw1868_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","O na puna gula he umikumamalua i piha i ka mea ala, he paumi na sekela, ma ka sekela o ke keenakapu: o ke gula a pau o na puna, he haneri a me ka iwakalua na sekela. ");
INSERT INTO haw1868_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","O na bipikane a pau no ka mohaikuni, he umikumamalua na bipikane, o na hipakane he umikumamalua, o na keikihipa o ka makahiki mua, he umikumamalua, me ka lakou mohaiai: a o na keikikao no ka mohaihala, he umikumamalua. ");
INSERT INTO haw1868_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","A o na bipikane a pau no ka mohaihoomalu, he iwakaluakumamaha na bipikane, he kanaono na hipakane, he kanaono na kaokane, he kanaono na keikihipa o ka makahiki mua. Oia ka hoolaa ana o ke kuahu mahope o kona poniia'na. ");
INSERT INTO haw1868_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","A i ko Mose komo ana iloko o ka halelewa o ke anaina e olelo aku ia ia, alaila lohe ae la ia i ka leo e olelo mai ana ia ia mailuna mai o ka noho aloha, o ka mea maluna o ka pahu kanawai, mawaena o na keruba elua: a i mai la oia ia ia. ");
INSERT INTO haw1868_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","OLELO mai la o Iehova ia Mose, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","E olelo aku oe ia Aarona, a e I aku ia ia, penei, I ka manawa e kuni ai oe i na kukui, e hoomalamalama na ipu ehiku imua o ka ipukukui. ");
INSERT INTO haw1868_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Pela no o Aarona i hana'i; kuni iho la ia i kona mau kukui imua o ka ipukukui, e like me ka Iehova i kauoha mai ai ia Mose. ");
INSERT INTO haw1868_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","A o keia hana o ka ipukukui, he gula i wiliia, mai kona kumu a hiki i kona mau pua, he hana i Wiliia: mamuli o ke kumuhoolike a Iehova i hoike ai ia Mose, pela no ia i hana'i i ka ipukukui. ");
INSERT INTO haw1868_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Olelo mai la o Iehova ia Mose, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","E lawe oe i na Levi maiwaena mai o na mamo a Iseraela, a e huikala ia lakou. ");
INSERT INTO haw1868_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Penei kau hana ana ia lakou, e huikala ai ia lakou: E kapipi i ka wai huikala maluna o lakou, a e amu lakou i ko lakou kino a pau, a e holoi lakou i ko lakou mau aahu, a e huikala ia lakou iho. ");
INSERT INTO haw1868_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Alaila, e lawe lakou i ka bipikeikikane, me kana mohaiai, he palaoa i kawili pu ia me ka aila; a me kekahi bipikeikikane hou e ae i mohaihala. ");
INSERT INTO haw1868_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","A e kai mai oe i na Levi imua o ka halelewa o ke anaina; a e hoakoakoa mai hoi oe i ke anaina kanaka a pau o na mamo a Iseraela. ");
INSERT INTO haw1868_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","A e kai mai oe i na Levi imua o Iehova; a e kau aku na mamo a Iseraela i ko lakou mau lima maluna o na Levi: ");
INSERT INTO haw1868_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","A e hoali aku o Aarona i na Levi io a ia nei, imua o Iehova, i mohaihoali o na mamo a Iseraela, i lilo ai lakou i poe e lawe i ka hana a Iehova. ");
INSERT INTO haw1868_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","A e kau aku na Levi i ko lakou mau lima maluna o na poo o na bipikane: a e kaumaha oe i kekahi i mohaihala, a i kekahi i mohaikuni na Iehova, i mea hookalahala no na Levi ");
INSERT INTO haw1868_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","A e hoonoho oe i na Levi imua o Aarona, a imua o kana mau keiki, a e mohai aku ia lakou i mohai na Iehova. ");
INSERT INTO haw1868_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Pela oe e hookaawale ai i na Levi maiwaena mai o na mamo a Iseraela; a e lilo na Levi no'u. ");
INSERT INTO haw1868_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","A mahope iho, e komo na Levi e hana ma ka halelewa anaina; a e huikala oe ia lakou, a e mohai oe ia lakou i mohai. ");
INSERT INTO haw1868_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","No ka mea, ua lilo loa lakou no'u maiwaena mai o na mamo a Iseraela, i panai no ka poe hanau mua, no na hanau mua a pau o na mamo a Iseraela, ua lawe au ia lakou no'u. ");
INSERT INTO haw1868_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","No ka mea, no'u no na hiapo a pau o na mamo a Iseraela, o ka ke kanaka, a me ka ka holoholona; i ka la a'u i luku ai na hanau mua a pau ma Aigupita, hoolaa iho la au ia lakou nei no'u. ");
INSERT INTO haw1868_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","A ua lawe au i na Levi i panai no na hanau mua a pau o na mamo a Iseraela. ");
INSERT INTO haw1868_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","A ua haawi aku au i na Levi i haawina no Aarona a no kana mau keiki, maiwaena o na mamo a Iseraela, e hana i ka hana a ka poe mamo a Iseraela ma ka halelewa anaina, a e hookalahala no na mamo a Iseraela, i ole e lukuia na mamo a Iseraela, i ka wa e hele mai ai na mamo a Iseraela a kokoke i ke keenakapu. ");
INSERT INTO haw1868_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","A o Mose me Aarona a me ke anaina a pau o na mamo a Iseraela, hana aku la lakou i na Levi e like me na mea a pau a Iehova i kauoha mai ai ia Mose no na Levi; pela no i hana aku ai na mamo a Iseraela ia lakou. ");
INSERT INTO haw1868_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","A ua huikalaia na Levi, a holoi iho la lakou i ko lakou aahu; a hoali aku o Aarona ia lakou i mohaihoali imua o Iehova, a hookalahala aku la o Aarona no lakou, i mea e huikala ai ia lakou. ");
INSERT INTO haw1868_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","A mahope iho, komo aku la na Levi iloko e hana i ka lakou hana ma ka halelewa o ke anaina, imua o Aarona a imua o kana mau keiki: e like me ka Iehova i kauoha mai ai ia Mose no na Levi, pela no lakou i hana aku ai ia lakou. ");
INSERT INTO haw1868_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Olelo mai la o Iehova ia Mose, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","Eia ka mea no na Levi; mai ka iwakalua a me kumamalima o na makahiki a keu aku, e hele lakou iloko e hana i ka hana o ka halelewa o ke anaina: ");
INSERT INTO haw1868_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","A mai ka makahiki he kanalima aku, e hoi lakou mai ka hana aku, aole lakou e hana hou aku. ");
INSERT INTO haw1868_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Aka, e malama lakou me ko lakou poe hoahanau ma ka halelewa anaina, e kiai ana i ka oihana, aole nae lakou e hana. Pela no oe e hana aku ai i na Levi no ka lakou oihana. ");
INSERT INTO haw1868_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","OLELO mai la o Iehova ia Mose ma ka waonahele o Sinai, i ka malama mua o ka lua o ka makahiki, mahope o ko lakou puka ana mailoko mai o ka aina o Aigupita, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","E malama na mamo a Iseraela i ka moliaola i kona manawa i kauohaia'i. ");
INSERT INTO haw1868_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","I ka la umikumamaha o keia malama, i ke ahiahi, e malama oukou ia i kona manawa i kauohaia'i: e like me na kanawai a pau nona, a e like hoi me na oihana a pau nana, ka oukou e malama ai ia. ");
INSERT INTO haw1868_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Olelo aku la hoi o Mose i na mamo a Iseraela, e malama lakou i ka moliaola. ");
INSERT INTO haw1868_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","A malama no lakou i ka moliaola i ka la umikumamaha o ka malama mua, i ke ahiahi, ma ka waonahele o Sinai: e like me na mea a pau a Iehova i kauoha mai ai ia Mose, pela na mamo a Iseraela i hana'i. ");
INSERT INTO haw1868_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","A o kekahi mau kanaka, ua haumia lakou i ke kupapau o ke kanaka, a pono ole ia lakou ke malama i ka moliaola ia la: a hele mai lakou imua o Mose, a imua o Aarona ia la. ");
INSERT INTO haw1868_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","I mai la ua mau kanaka la ia ia, Ua haumia makou i ke kupapau o ke kanaka: no ke aha la i keakeaia'i makou, i ole e kaumaha aku ai makou i mohai na Iehova i kona manawa i kauohaia'i me na mamo a Iseraela! ");
INSERT INTO haw1868_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","I aku la o Mose ia lakou, E ku malie oukou, a lohe au i ka mea a Iehova e kauoha mai ai no oukou. ");
INSERT INTO haw1868_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Olelo mai la o Iehova ia Mose, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","E olelo aku oe i na mamo a Iseraela, i ka i ana, Ina he haumia ko kekahi kanaka o oukou a o ka oukou poe mamo paha, i ke kupapau, a ua moamao aku paha ia i ka hele ana, e malama no hoi ia i ka moliaola no Iehova. ");
INSERT INTO haw1868_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","I ka la umikumamaha, o ka lua o ka malama, i ke ahiahi, e malama lakou ia mea, e ai hoi lakou ia me ka berena hu ole, a me na lau mulea. ");
INSERT INTO haw1868_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Aole lakou e waiho i kanwahi o ia mea, a ao, aole hoi e uhai i kekahi iwi ona: ma na kanawai a pau no ka moliaola ka lakou e malama ai ia. ");
INSERT INTO haw1868_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Aka, o ke kanaka haumia ole, aole hoi i hala i ka hele ana, a ua malama ole i ka moliaola, e hookiia'ku oia mai kona poe kanaka aku; no ka mea, aole ia i lawe mai i ka mohai na Iehova i kona manawa i kauohaia'i; e lawe ia kanaka i kona hewa iho. ");
INSERT INTO haw1868_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Ina hoi e noho ana kekahi malihini me oukou, a ua makemake ia e malama i ka moliaola no Iehova; e like me ke kanawai no ka moliaola, a e like hoi me kona oihana, pela no ia e hana'i: i hookahi no kanawai ia oukou no ka malihini, a no ka mea i hanau ma ka aina. ");
INSERT INTO haw1868_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","I ka la i kukuluia'i, ka halelewa, uhi iho la ke ao maluna o ka halelewa, ma ke keena o ke kanawai; a ahiahi, ua ikea ka mea me he ahi la maluna o ka halelewa a hiki i kakahiaka. ");
INSERT INTO haw1868_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","A pela mau no: uhi mai la keao ia in, a i ka po ua ikea ka mea me he ahi la. ");
INSERT INTO haw1868_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","A i ka manawa i pii ai ke ao mailuna ae o ka halelewa, ma ia hope iho, haele aku la na mamo a Iseraela: a ma kahi i ku malie ai ke ao, malaila na mamo a Iseraela i hoomoana ai. ");
INSERT INTO haw1868_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Ma ke kauoha a Iehova i hele ai na mamo a Iseraela, a ma ke kauoha a Iehova i hoomoaua ai lakou: i na la a pau i ku malie ai ke ao maluna o ka halelewa, noho iho la lakou ma na halelole o lakou. ");
INSERT INTO haw1868_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Aia ku liuliu iho la ke ao maluna o ka halelewa a nui na la, alaila malama na mamo a Iseraela i ka oihana a Iehova, aole no i hele aku. ");
INSERT INTO haw1868_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","A i ka wa i ku malie ai ke ao maluna o ka halelewa a uuku na la; e like me ke kauoha ana a Iehova i noho ai lakou ma ko lakou mau halelole, a e like me ke kauoha ana mai a Iehova i haele ai lakou. ");
INSERT INTO haw1868_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","A i ka wa i noho ai ke ao mai ke ahiahi a hiki i kakahiaka, a pii ae la ke ao i kakahiaka, alaila, haele lakou: ina ma ke ao paha, ma ka po paha i pii ae ke ao, haele no lakou. ");
INSERT INTO haw1868_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Ina hoi i noho ke ao maluna o ka halelewa i na la elua, i ka malama paha, a i ka makahiki paha, e kau ana malaila, noho iho la na mamo a Iseraela iloko o ko lakou mau halelole, aole lakou i hele: aia i ka wa i pii ae ia, hele lakou. ");
INSERT INTO haw1868_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Ma ke kauoha a Iehova i noho ai lakou, iloko o ko lakou mau halelole, a ma ke kauoha ana a Iehova i haele ai lakou: malama no lakou i ka oihana a Iehova ma ke kauoha a Iehova, i ka lima o Mose. ");
INSERT INTO haw1868_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","OLELO mai la o Iehova ia Mose, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","E hana oe i elua pu kala nou; no ka apana kala okoa kau e hana'i ia mau mea, i mea nau e houluulu ae ai i ke anaina kanaka, a no ka hele ana o ka poe hoomoana. ");
INSERT INTO haw1868_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Aia puhi aku lakou ma ia mau mea, alaila e hoakoakoa ae ke anaina kanaka a pau ma ka puka o ka halelewa anaina. ");
INSERT INTO haw1868_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Ina paha e puhi lakou ma ka pu hookahi, alaila o na lii, ka poe luna o na tausani ke houluulu mai i ou la. ");
INSERT INTO haw1868_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Aia puhi oukou i ka puwaikaua, alaila o ka poe hoomoana ma ka aoao hikina ke hele imua. ");
INSERT INTO haw1868_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","A puhi hou oukou i ka puwaikaua, alaila o ka poe hoomoana ma ke kukuluhema ke hele aku: e puhi lakou i ka puwaikaua no ko lakou hele ana. ");
INSERT INTO haw1868_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","A i ka wa e houluuluia'na ke anaina kanaka, e puhi no oukou, aole nae e hookani oukou i ka puwaikaua. ");
INSERT INTO haw1868_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","O na keiki a Aarona, o na kahuna, e puhi lakou i na pu: a he kanawai mau loa ia no oukou a no na hanauna mahope o oukou. ");
INSERT INTO haw1868_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Ina paha e hele oukou i ke kaua ma ko oukou aina, e ku e i ka poe enemi hooluhi mai ia oukou; alaila oukou e puhi ai i ka puwaikaua ma na pu: a e hoomanaoia auanei oukou imua o Iehova o ko oukou Akua, a e hoolaia oukou i ko oukou poe enemi. ");
INSERT INTO haw1868_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Pela hoi i ka la e olioli ai oukou, a me na la houluulu o oukou a me na la mua o ko oukou mau malama, e puhi hoi oukou i na pu maluna o na mohaikuni a oukou, a maluna o na mohaimalu o oukou, i lilo ia mau mea ia oukou i mea e hoomanaoia'i imua o ko oukou Akua: owau no Iehova ko oukou Akua. ");
INSERT INTO haw1868_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","A i ka la iwakalua o ka lua o ka malama, i ka lua o ka makahiki, lei ae la ke ao maluna aku o ka halelewa o ke kanawai. ");
INSERT INTO haw1868_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","A hele aku la ka poe mamo a Iseraela mailoko aku o ka waonahele o Sinai; a ku malie iho la ke ao ma ka waonahele o Parana. ");
INSERT INTO haw1868_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","O ka mua keia o ko lakou hele ana, e like me ka Iehova kauoha ana mai ma ka lima o Mose. ");
INSERT INTO haw1868_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Hele mua aku la ka hae o ka poe hoomoana o na mamo a Iuda, ma ko lakou poe kaua: a o Nahesona ke keiki a Aminadaba, oia no maluna o kona poe kaua. ");
INSERT INTO haw1868_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","A o Nataneela ke keiki a Zuara, oia no maluna o ka poe kaua o ka ohana mamo a Isekara. ");
INSERT INTO haw1868_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","A o Eliaba ke keiki a Helona, oia no maluna o ka poe kaua o ka ohana mamo a Zebuluna. ");
INSERT INTO haw1868_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Ua wawahiia'e ka halelewa: a hele aku la na mamo a Geresona, a me na mamo a Merari, e hali ana i ka halelewa ");
INSERT INTO haw1868_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","A hele aku la ka hae oko Reubena poe hoomoana, ma ko lakou poe kaua: a o Elizura ke keiki a Sedeura, oia no maluna o kona poe kaua. ");
INSERT INTO haw1868_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","A o Selumiela ke keiki a Zurisadai, oia no maluna o ka poe kaua o ka ohana mamo a Simeona. ");
INSERT INTO haw1868_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","A o Eliasapa ke keiki a Deuela, oia maluna o ka poe kaua o ka ohana mamo a Gada. ");
INSERT INTO haw1868_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","A hele aku la ka Kohata, e hali ana i na mea hoano; a na kela poe i kukulu ae i ka halelewa no ka wa i hiki aku ai lakou nei. ");
INSERT INTO haw1868_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Hele aku la hoi ka hae o ka poe hoomoana o na mamo a Eperaima, ma ko lakou mau poe kaua: a o Elisama ke keiki a Amihuda, oia no maluna o kona poe kaua. ");
INSERT INTO haw1868_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","A o Gamaliela ke keiki a Pedazura, oia no maluna o ka poe kaua o ka ohana mamo a Manase. ");
INSERT INTO haw1868_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","A o Abidana ke keiki a Gideoni, oia no maluna o ka poe kaua o ka ohana mamo a Beniamina. ");
INSERT INTO haw1868_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Hele aku la hoi ka hae o ka poe hoomoana o na mamo a Dana, oia no ka hope o na poe hoomoana a pau ma ko lakou poe kaua: a o Ahiezera ke keiki a Amisadai, oia ka luna o kona poe kaua. ");
INSERT INTO haw1868_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","A o Pagiela ke keiki a Okera na, oia no maluna o ka poe kaua o ka ohana mamo a Asera. ");
INSERT INTO haw1868_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Maluna hoi o ka poe kaua o ka ohana mamo a Napetali, o Ahira ke keiki a Enana. ");
INSERT INTO haw1868_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Pela na hele ana o na mamo a Iseraela, ma ko lakou mau poe kaua, i ka wa i hele aku ai lakou. ");
INSERT INTO haw1868_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Olelo aku la o Mose ia Hobaba, i ke keikikane a Reuela ka Midiana, ka makuahonowaikane o Mose, Ke hele aku nei makou i kahi a Iehova i i mai ai, E haawi ana au ia no oukou: e hele pu oe me makou, a e hana aku makou ia oe i ka maikai; no ka mea, ua olelo mai o Iehova i ka maikai no ka Iseraela. ");
INSERT INTO haw1868_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","I mai la kela ia ia, Aole au e hele, e hoi hou ana au i ko'u aina iho, a i ko'u poe hoahanau. ");
INSERT INTO haw1868_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","I aku la ia, Ke noi aku nei au ia oe, mai haalele oe ia makou; no ka mea, ua ike oe e hoomoana iho ana makou ma ka waonahele, a e lilo mai oe i maka no makou. ");
INSERT INTO haw1868_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Eia hoi kekahi, a i hele pu oe me makou, he oiaio no, o ka maikai a Iehova e hana mai ai ia makou, oia ka makou e hana aku ai ia oe. ");
INSERT INTO haw1868_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Haele aku la lakou i ekolu la hele, mai ka mauna o Iehova aku: a hele aku la ka pahu berita o Iehova imua o lakou i ua mau la la i hele ai ekolu, e imi ana i kahi e oioi ai lakou. ");
INSERT INTO haw1868_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Uhi iho la ke ao o Iehova maluna o lakou i ke ao i ko lakou hele ana aku mawaho o kahi hoomoana. ");
INSERT INTO haw1868_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Aia i ka hele ana aku o ka pahu imua, alaila, i aku la o Mose, E ku ae oe iluna, e Iehova; a e hoopuehuia'e kou poe enemi; a e hooauheeia'ku imua ou ka poe inaina ia oe. ");
INSERT INTO haw1868_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","A ku malie iho ia, alaila, i aku la ia, E hoi hou mai oe, e Iehova, i na lehulehu o ka Iseraela. ");
INSERT INTO haw1868_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","I KA ohumu ana a na kanaka, ua hewa ia i na pepeiao o Iehova; lohe ae la o Iehova, a hoaia kona inaina; a aku la ke ahi o Iehova iwaena o lakou, a ai aku la ma ka palena o kahi hoomoana. ");
INSERT INTO haw1868_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Kahea aku la na kanaka ia Mose, a pule aku la o Mose ia Iehova, alaila pio iho la ke ahi. ");
INSERT INTO haw1868_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Kapa aku la ia i ka inoa o ia wahi, o Tabera; no ka mea, ua ai mai ke ahi o Iehova iwaena o lakou. ");
INSERT INTO haw1868_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","A o ka poe e i hui pu ia mai me lakou, kuko nui aku lakou: a uwe hou iho la na mamo a Iseraela, i ae la, Nawai la e haawi mai i ka io na kakou e ai ai? ");
INSERT INTO haw1868_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Ke hoomanao nei makou i ka ia a makou i ai wale iho ai ma Aigupita; i na kaukama me na ipuaimaka, i na leka me na akaakai, a me na galika. ");
INSERT INTO haw1868_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Ano hoi, ua maloo loa ko kakou naau; aohe mea e ae, o ka mane wale no imua o ko kakou maka. ");
INSERT INTO haw1868_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Ua like ka mane me ka hua koriana, a o kona helehelena ua like ia me ka deliuma. ");
INSERT INTO haw1868_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","A hele ae la na kanaka, a hoiliili iho la, a wawahi iho la maloko o na mea wili; a i ole ia, kui iho la lakou iloko o na ipukui, kahu iho la a moa ma na pa, a hana iho la ia i popo. A o ka hoao ana o ia mea, ua like me ka hoao ana i ka aila hou. ");
INSERT INTO haw1868_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Aia haule iho ka hau maluna o kahi hoomoana i ka po, haule pu no hoi ka mane me ia. ");
INSERT INTO haw1868_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Alaila lohe ae la o Mose i na kanaka e uwe ana me ka lakou mau ohana, o kela kanaka keia kanaka ma ka puka o kona halelewa: hoa nui ia ka inaina o Iehova; a ukiuki iho la hoi o Mose. ");
INSERT INTO haw1868_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","I aku la o Mose ia Iehova, No ke aha la oe i hoopilikia mai ai i kau kauwa? no ke aha hoi i loaa ole mai ai ia'u ka lokomaikaiia mai imua o kou maka, i kau mai ai oe maluna o'u i ke kaumaha o keia poe kanaka a pau? ");
INSERT INTO haw1868_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Na'u no anei i hoohapai i keia poe kanaka a pau? Ua hoohanau no anei au ia lakou, i olelo mai ai oe ia'u, E hiipoi oe ia lakou ma kou umauma, e like me ka hali aua a ka makua hanai i ke keiki omo waiu, a hiki aku i ka aina au i hoohiki ai i na kupuna o lakou? ");
INSERT INTO haw1868_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Nohea la e loaa mai ai ia'u ka io e haawi aku ai na keia poe kanaka a pau? No ka mea, ke uwe mai uei lakou ia'u, me ka olelo mai, E haawi mai oe na makou i io, e ai iho ai makou. ");
INSERT INTO haw1868_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Aole e hiki ia'u, owau wale no ke halihali i keia poe kanaka a pau; no ka mea, he mea kaumaha loa ia no'u. ");
INSERT INTO haw1868_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","A i hana mai oe pela ia'u, ea, ke nonoi aku nei au ia oe, e pepehi mai oe ia'u a make, ina paha i loaa ia'u ka lokomaikaiia mai imua o kou mau maka, a ike ole au i kuu popilikia ana. ");
INSERT INTO haw1868_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Olelo mai la o Iehova ia Mose, E houluulu mai oe io'u nei i na kanaka he kanahiku o ka poe kahiko o ka Iseraela, i na mea au e ike ai he poe kahiko o na kanaka, a he poe luna hoi no lakou; a e kai mai oe ia lakou ma ka halelewa o ke anaina i ku ai lakou me oe ilaila. ");
INSERT INTO haw1868_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","A e iho no au ilalo, e kamailio pu me oe ilaila; a e lawe au i ko ka Uhane maluna ou, a e kau aku maluna o lakou; a e amo pu lakou me oe i ke kaumaha o na kanaka, i halihali ole ai oe, o oe wale no, ia mea. ");
INSERT INTO haw1868_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","E olelo aku hoi oe i na kanaka, E huikala oukou ia oukou iho no ka la apopo, a e ai auanei oukou i ka io; no ka mea, ua uwe aku oukou maloko o na pepeiao o Iehova, ua i aku, Nawai la e haawi mai i ka io na kakou e ai ai? Ua pono kakou ma Aigupita: no ia mea, e haawi mai no o Iehova i io na oukou, a e ai iho hoi oukou. ");
INSERT INTO haw1868_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","E ai no oukou, aole i ka la hookahi, aole i na la elua, aole hoi i na la elima, aole no hoi i na la he umi, aole no hoi i na la he iwakalua: ");
INSERT INTO haw1868_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","Aka, he malama okoa, a puka mai ia iwaho ma ko oukou mau puka ihu, a hoopailua oukou ia: no ka mea, ua hoowahawaha oukou ia Iehova e noho ana iwaena o oukou, a ua uwe oukou imua ona, me ka i ana ae, No ke aha la kakou i hele mai ai mai Aigupita mai? ");
INSERT INTO haw1868_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","I aku la o Mose, O ka poe kanaka a'u e noho nei iwaena, he eono haneri tausani lakou, ka poe hele wawae, a ke olelo mai nei oe, E haawi no au i io na lakou e ai ai a pau ka malama okoa. ");
INSERT INTO haw1868_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","E kaluaia anei na pua hipa a me na pua bipi na lakou, i mea e maona ai lakou? E hoiliiliia paha anei na ia a pau o ke kai na lakou, i mea e maona ai lakou? ");
INSERT INTO haw1868_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Olelo mai la o Iehova ia Mose, Ua hoopokoleia anei ko Iehova lima? E ike auanei oe i ka hookoia ana paha o ka'u olelo ia oe, a i ka ole ana paha. ");
INSERT INTO haw1868_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Hele aku la o Mose, a hai aku la i na kanaka i na olelo a Iehova, a houluulu ae la ia i na kanaka, he kanahiku o ka poe lunakahiko no na kanaka, a hooku ae la ia lakou a puni ka halelewa. ");
INSERT INTO haw1868_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Iho mai la o Iehova ma ke ao, a olelo mai la ia ia, a. lawe ae la ia i ko ka Uhane maluna o Mose, a haawi aku la i ka poe lunakahiko he kanahiku: a i ka manawa i kau iho ai ka Uhane maluna o lakou, alaila wanana mai la lakou, aole i hooki. ");
INSERT INTO haw1868_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Elua kanaka i koe aku ma kahi hoomoana, o Eledada, ka inoa o kekahi, a o Medada ka inoa o kekahi. Kau mai la ka Uhane maluna o laua: no ka poe laua i kakauia, aole nae laua i hele aku i ka halelewa, a wanana mai la laua ma kahi hoomoana. ");
INSERT INTO haw1868_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","A holo mai la kekahi kanaka opiopio, a hai mai la ia Mose, i mai la, Ke wanana mai la o Eledada laua o Medada ma kahi hoomoana. ");
INSERT INTO haw1868_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Pane mai la o Iosua ke keiki a Nuna, ke kauwa a Mose, he kanaka opiopio ona, i mai la, E kuu haku, e Mose, e papa aku oe ia laua. ");
INSERT INTO haw1868_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","I aku la o Mose ia ia, Ke huwa nei anei oe no'u? ke ake nei au e lilo ko Iehova poe kanaka a pau i poe kaula, a e kau mai o Iehova i kona Uhane maluna o lakou! ");
INSERT INTO haw1868_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Hoi mai la o Mose i kahi hoomoana, oia a me ka poe lunakahiko o ka Iseraela. ");
INSERT INTO haw1868_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","A huai mai la ka makani mai o Iehova mai, a hoopuka mai la i na selu mai ka moana mai, a hoohaule iho la ia lakou ma kahi hoomoana, e like me kekahi la hele ma keia aoao, a me kela aoao, a puni i kahi hoomoana, elua paha kubita maluna o ka honua. ");
INSERT INTO haw1868_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Ku ae la na kanaka iluna ia la a po, ia po a ao, a ia la aku a po; ohi iho la lakou i na selu: a o ka mea hoiliili hapa, he umi na homera kana i hoiliili ai, a kaulai aku la lakou ia mea no lakou iho a puni kahi hoomoana. ");
INSERT INTO haw1868_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Aia iwaena o ko lakou mau niho ka io, aole ia i nauia, aa mai la ka inaina o Iehova i na kanaka, a pepehi iho la o Iehova i na kanaka, he ahulau nui loa. ");
INSERT INTO haw1868_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","A kapa iho la oia i ka inoa o ia wahi, o Kiberotahataava; no ka mea, malaila i kanu ai lakou i na kanaka kuko. ");
INSERT INTO haw1868_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Hele aku la na kanaka mai Kiberotahataava aku a hiki i Hazerota, a noho iho la lakou i Hazerota. ");
INSERT INTO haw1868_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","O HUMU ae la o Miriama laua o Aarona i ke ku e ia Mose, no ka wahine Aitiopa ana i lawe ai: no ka mea, ua lawe in i wahine no Aitiopa nana. ");
INSERT INTO haw1868_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","I ae la laua, Ma o Mose la wale no anei ka Iehova olelo ana mai? Aole anei ia i olelo ma o kaua nei kekahi? A lohe mai la o Iehova. ");
INSERT INTO haw1868_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","(A o ua kanaka la o Mose, ua oi aku kona akahai mamua o ko na kanaka a pau maluna o ka honua.) ");
INSERT INTO haw1868_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Olelo koke mai la o Iehova ia Mose me Aarona a me Miriama, E hele mai oukou a ekolu i ka halelewa anaina. A hele aku la lakou a ekolu. ");
INSERT INTO haw1868_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Iho iho la o Iehova maloko o ke kia ao, ku mai la ia ma ka puka o ka halelowa, kahea mai la ia Aarona laua o Miriama; a hele aku la laua. ");
INSERT INTO haw1868_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Olelo mai la ia, E hoolohe mai olua i ka'u olelo: A i noho kekahi kaula iwaena o oukou, owau o Iehova e hoike aku ia'u iho ia ia ma ka hihio, a e olelo aku no wau ia ia ma ka moeuhane. ");
INSERT INTO haw1868_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Aole nae pela ka'u kauwa o Mose, ka mea malama pono ma ko'u hale a pau. ");
INSERT INTO haw1868_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","E olelo aku ana au me ia he waha no he waha, ma ka mea akaka, aole ma ka olelonane: a e ike mai no ia i ke aka o Iehova: no ke aha la hoi i makau ole ai olua i ka ohumu aku i kuu kauwa ia Mose? ");
INSERT INTO haw1868_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Hoaia mai la ka inaina o Iehova ia laua, a hoi aku la ia. ");
INSERT INTO haw1868_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","A hoi hou aku la ke ao maluna aku o ka halelewa; aia hoi, ua lepers o Miriama me he hau la: nana aku la o Aarona ia Miriama, aia hoi, ua lepera ia. ");
INSERT INTO haw1868_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","I aku la o Aarona ia Mose, Auwe! e kuu haku, ke nonoi aku nei au ia oe, mai kau mai oe i keia hewa maluna o maua, i kahi a maua i hana lapuwale ai, a ua hana hewa malaila. ");
INSERT INTO haw1868_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Mai waiho wale ia ia me he mea make la, me he mea la i pala kona io i ka wa o kona puka ana mai iwaho o ka opu o kona makuwahine. ");
INSERT INTO haw1868_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Kahea aku la o Mose ia Iehova, i aku la, E ke Akua e, ke noi aku nei au ia oe, e hoola mai oe ia ia. ");
INSERT INTO haw1868_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","I mai la o Iehova ia Mose, Ina paha i kuha wale aku kona makuakane i kona maka, aole anei i hoohilahilaia oia i na la ehiku? E kipakuia oia iwaho o kahi hoomoana i na la ehiku, a mahope iho e hookipaia mai ia iloko. ");
INSERT INTO haw1868_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","A ua kipakuia o Miriama iwaho o kahi hoomoana i na la ehiku; aole ka poe kanaka i hele, a hoi hou mai o Miriama maloko. ");
INSERT INTO haw1868_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","A mahope iho, neenee aku la ka poe kanaka mai Hazerota aku, a kukulu hou iho la ma ka waouahele o Parana. ");
INSERT INTO haw1868_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","OLELO mai la o Iehova ia Mose, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","E hoouna aku oe i na kanaka e makaikai ai i ka aina o Kanaana, kahi a'u e haawi aku nei i na mamo a Iseraela: i hookahi kanaka o kela ohana a o keia ohana a na kupuna o lakou ka oukou e hoouna aku ai, he mau luna kela mea keia mea iwaena o lakou. ");
INSERT INTO haw1868_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","A ma ke kauoha a Iehova i hoouna aku ai o Mose ia lakou, mai ka waonahele o Parana aku: a o ia mau kanaka a pau, he mau luna lakou no na mamo a Iseraela. ");
INSERT INTO haw1868_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Eia na inoa o lakou: no ka ohana o Reubena, o Samua ke keiki a Zakura. ");
INSERT INTO haw1868_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","No ka ohana a Simeona, o Sapata ke keiki a Hori. ");
INSERT INTO haw1868_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","No ka ohana a Iuda, o Kaleba ke keiki a Iepune. ");
INSERT INTO haw1868_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","No ka ohana a Isakara, o Igala ke keiki a Iosepa. ");
INSERT INTO haw1868_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","No ka ohana a Eperaima, o Hosea ke keiki a Nuna. ");
INSERT INTO haw1868_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","No ka ohana a Beniamina, o Paleti ke keiki a Rapu. ");
INSERT INTO haw1868_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","No ka ohana a Zebuluna, o Gadiela ke keiki a Sodi. ");
INSERT INTO haw1868_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","No ka ohana a Iosepa, ka ohana a Manase, o Gadi ke keiki a, Susi. ");
INSERT INTO haw1868_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","No ka ohana a Dana, o Amiela ke keiki a Gemali. ");
INSERT INTO haw1868_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","No ka ohana a Asera, o Setiela ke keiki a Mikaela. ");
INSERT INTO haw1868_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","No ka ohana a Napetali, o Nabi ke keiki a Vopesi. ");
INSERT INTO haw1868_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","No ka ohana a Gada, o Geuela ke keiki a Maki. ");
INSERT INTO haw1868_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Oia na inoa o na kanaka a Mose i hoouna aku ai e makaikai i ka aina. A kapa aku la o Mose ia Hosea ke keiki a Nuna, o Iosua. ");
INSERT INTO haw1868_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Hoouna aku la o Mose ia lakou e makaikai i ka aina o Kanaana, i aku la hoi ia lakou, E haele oukou ma keia aoao kukuluhema, a e pii iluna i ka mauna. ");
INSERT INTO haw1868_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","E nana i ke ano o ka aina, a me na kanaka e noho ana ilaila, he ikaika paha lakou, he nawaliwali paha; he hapa paha lakou, he nui loa paha; ");
INSERT INTO haw1868_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Me ka aina hoi a lakou e noho la, he maikai paha, he ino paha; a me na kulanakauhale a lakou e noho la, ma na halelewa paha, ma na pakaua paha; ");
INSERT INTO haw1868_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","A me ke ano o ka aina, he momona paha, he wi paha; he laau paha ilaila, aole paha: i nui hoi ka ikaika o oukou, a e lawe mai i kekahi hua o ka aina. O ka manawa ia o ka huawaina pala mua. ");
INSERT INTO haw1868_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Pii aku la lakou a makaikai ae la i ka aina, mai ka waonahele o Zina a hiki aku i Rehoba, ma ke ala e hele aku ai i Hamata. ");
INSERT INTO haw1868_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","A pii aku la lakou ma ke kukulu hema, a hiki aku i Heberona, i kahi o Ahimana, o Sesai a me Talemai, na keiki a Anaka. (Ua hookumuia o Heberona ehiku makahiki mamua o Zoana i Aigupita.) ");
INSERT INTO haw1868_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","A hele aku lakou i ke kahawai i Esekola, a old iho la i kekahi lala me ka huiwaina hookahi, a amo mai la maluna o ka mamaka mawaena o na kanaka elua, O na pomeraite kekahi a me na fiku. ");
INSERT INTO haw1868_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Ua kapaia ia wahi ke kahawai o I Esekola, no ka huiwaina a na mamo a Iseraela i oki ai malaila. ");
INSERT INTO haw1868_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","A hala na la he kanaha o ka makaikai ana i ka ama, hoi mai la lakou. ");
INSERT INTO haw1868_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Hele mai la lakou a hiki io Mose la a me Aarona, a me ke anaina kanaka a pau o na mamo a Iseraela, i ka waonahele o Parana, i Kadesa; a hoakaka mai la lakou ia laua, a i ke anaina kanaka a pau, a hoike mai la i ka hua o ka aina. ");
INSERT INTO haw1868_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Olelo mai la lakou ia ia, i mai la, Ua hele aku makou i ka aina au i hoouna aku ai ia makou, a he oiaio no e kahe ana ka waiu a me ka meli ilaila; eia hoi ka hua o ia wahi. ");
INSERT INTO haw1868_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Aka, ua ikaika na kanaka e noho ana ma ia aina; a na paa i na papohaku na kulanakauhale, a nui loa: eia hoi kekahi, ua ike makou i na keiki a Anaka malaila. ");
INSERT INTO haw1868_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","E noho ana ka Ameleka ma ka aina kukuluhema; o ka Heta, me ka Iebusa, a me ka Amora, ua noho lakou ma na mauna; a ua noho ko Kanaana ma ka moana a ma kapa o Ioredane. ");
INSERT INTO haw1868_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Hoomalielie iho o Kaleba i kanaka imua o Mose, i mai la, E hele koke aku kakou, a e komo i ka aina; no ka mea, e hiki pono no ia kakou ke lanakila maluna ona. ");
INSERT INTO haw1868_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Aka, i mai la na kanaka i hele pu me ia, Aole e hiki ia kakou ke hele ku e i ua poe kanaka la; no ka mea, ua oi aku ko lakou ikaika i ko kakou. ");
INSERT INTO haw1868_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","A lawe mai la lakou i ka olelo hoino i ka aina a lakou i makaikai aku ai i na mamo a Iseraela, i mai la, O ka aina kahi a makou i kaahele ai e makaikai aku, he aina ia e hoopau ana i na kanaka e noho ana malaila: a o na kanaka a pau a makou i ike ai malaila, he poe kanaka nunui. ");
INSERT INTO haw1868_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Malaila makou i ike ai i na kanaka nunui, i na keiki a Anaka, na ka poe kanaka nunui mai: ua like makou me na uhini i ko makou maka, a pela hoi makou imua o ko lakou maka. ");
INSERT INTO haw1868_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","HOOKIEKIE ae la ke anaina kanaka a pau i ko lakou leo, a hooho ae la; a uwe iho la na kanaka ia po. ");
INSERT INTO haw1868_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Ohumu ae la na mamo a pau a Iseraela ia Mose a me Aarona: i aku la ke anaina kanaka a pau ia laua, E aho ko makou make ma ka aina o Aigupita! E aho ko makou make ma keia waonahele! ");
INSERT INTO haw1868_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","No ke aha la hoi i lawe mai nei o Iehova ia kakou i keia aina, e make i ka pahikaua, a e lilo at ka kakou mau wahine a me na keiki i i pio? E aho paha e hoi kakou i Aigupita. ");
INSERT INTO haw1868_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","I ae la lakou i kekahi i kekahi, E hoonoho kakou i luna no kakou, a e hoi aku i Aigupita. ");
INSERT INTO haw1868_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Alaila moe iho la o Mose laua o Aarona ilalo ke alo imua o ke anaina kanaka a pau i akoakoa o na mamo a Iseraela. ");
INSERT INTO haw1868_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","A o Iosua ke keiki a Nuna, a o Kaleba ke keiki a Iepune, o laua kekahi o na mea i makaikai i ka aina, haehae ae la laua i ko laua kapa. ");
INSERT INTO haw1868_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Olelo aku la laua i ka poe mamo a pau a Iseraela, i aku la, O ka aina a makou i kaahele ai e makaikai, he aina maikai loa ia. ");
INSERT INTO haw1868_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Ina i oluolu mai o Iehova ia ka kou, alaila e kai aku oia ia kakon i ua aina la, a e haawi mai hoi ia no kakou; he aina e kahe ana ka waiu a me ka meli ");
INSERT INTO haw1868_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Aka, mai kipi aku oukou ia Iehova, mai makau hoi i na kanaka o ka aina; no ka mea, he mea ai lakou na kakou: ua hala aku la ko lakou malu mai o lakou aku la, me kakou no hoi o Iehova; mai makau ia lakou. ");
INSERT INTO haw1868_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Aka. kena ae la ke anaina kanaka a pau e hailuku ia laua i ua pohaku Alaila ikea ae la ka nani o Iehova ma ka halelewa o ke anaina, imua o na mamo a pau a Iseraela. ");
INSERT INTO haw1868_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","I mai la o Iehova ia Mose, Pehea la ka loihi o ka hoonaukiuki ana mai o keia poe kanaka ia'u.? Ahea la hoi lakou e manaoio mai ai ia'u no na mea mana a pau a'u i hoike ai iwaena o lakou? ");
INSERT INTO haw1868_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","E luku aku au ia lakou i ke ahulau, a e pai ia lakou i ka aina hooili; a e hoolilo au ia oe i lahuikanaka e oi aku ana ka nui a me ka ikaika i ko lakou. ");
INSERT INTO haw1868_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Olelo aku la o Mose ia Iehova, Alaila e lohe ai ko Aigupita, (no ka mea, ma kou mana kau i lawe mai ai i keia poe kanaka mawaena mai o lakou,) ");
INSERT INTO haw1868_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","A e hai aku lakou ia i na kanaka o keia aina. Ua lohe lakou, e Iehova, o oe no mo keia poe kanaka, a ua ikeia hoi oe, e Iehova, he maka no he maka; a ua ku hoi kou ao maluna o lakou; a ua hele hoi oe imua o lakou i ko ao ma ke kia ao, a ma ke kia ahi i ka po. ");
INSERT INTO haw1868_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","A i pepehi mai oe i keia poe kanaka e like me ke kanaka hookahi, alaila e olelo mai na lahuikanaka i lohe i kou kaulana ana, i ka i ana, ");
INSERT INTO haw1868_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","No ka hiki ole ia Iehova ke hookomo aku i keia poe kanaka i ka aina ana i hoohiki ai no lakou, nolaila na pepehi oia ia lakou ma ka waouahele. ");
INSERT INTO haw1868_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Ano la, ku nonoi aku nei au ia oe, i nui ka mana o kuu Haku. e like me ka olelo au i olelo mai ai, penei, ");
INSERT INTO haw1868_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","Ua altonui o Iehova, a ua nui kona lokomaikai, e kala ana i ka hew a a me ka lawehala ana, aole loa hoi e hoapono wale ana mai; e hoopai ana nae i ko ka tnakua lawehala maluna o na keiki a hiki aku i ke kuakahi a me ke kualua. ");
INSERT INTO haw1868_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Ke noi aku nei au ia oe, e kala mai oe i ka hala o keia poe kanaka, e like me ka nui o kou lokomaikai; e like hoi me kau i kala mai ai i keia poe kanaka mai Aigupita mai, a hiki i keia manawa. ");
INSERT INTO haw1868_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","I mai la o Iehova, Ua kala aku no wau, e like me kau i olelo mai ai. ");
INSERT INTO haw1868_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Aka, me au e ola nei, e hoopihaia auanei ka honua i ka nani o Iehova. ");
INSERT INTO haw1868_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","No ka men, o kela poe kanaka a pau, ka poe i ike mai i kuu na-ni, a me na mea mana a'u i hana'i ma Aigupita, a ma ka waonahele, a he umi ko lakou aa ana mai ia'u. aole hoi i hooloho mai i kuu leo; ");
INSERT INTO haw1868_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","Aole loa lakou e ike i ka aina a'u i hoohiki ai no ko lakou poe kupuna, aole hoi kekahi o ka poe i hoonaukiuki mai ia'u e ike aku in wahi: ");
INSERT INTO haw1868_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Aka, o ka'u kauwo, o Kaleha, no ka mea, he manao okoa maloko ona, a ua hahai pono mai oia ia'u, oia ka'u e hookomo ai i ka aina ana i hele aku ai; a e loaa i kana poe keiki ia aina. ");
INSERT INTO haw1868_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","(Ua noho no ka Ameleka a me ka Kanaana ma ke awawa.) Apopo, e huli oukou, a e komo aku iloko o ka waonahele, ma ke ala e hiki ai i ke Kaiula. ");
INSERT INTO haw1868_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Olelo mai la o Iehova ia Mose a me Aarona, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","Pehea la ka loihi o ko keia anaina kanaka ino e ohumu mai ai ia'u? Ua lohe no wau i na ohumu ana a na mamo a Iseraela i ohumu mai ai ia'u. ");
INSERT INTO haw1868_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","E hai aku oe ia lakou, Ke i mai nei o Iehova, He oiaio, me ka oukou i olelo mai ai maloko o ko'u mau pepeiao, pela hoi ka'u e hana aku ai ia oukou. ");
INSERT INTO haw1868_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","E hanle no auanei ko oukou kupapau ma keia waonahele; a o ka poe a pau o oukou i heluia, ma ka huiualielu okoa o oukou, mai ka iwakalua o ka makahiki a keu aku, o ka poe i ohumu mai ia'u, ");
INSERT INTO haw1868_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Aole loa oukou e komo aku iloko o ka aina a'u i hoohiki ai e hoonoho ia oukou ilaila; o laua wale no, o Kaleba ke keiki a Iepune, a o Iosua ke keiki a Nuna, ");
INSERT INTO haw1868_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Aka, o ka oukou poe keiki, na mea a oukou i olelo ai e lilo ana lakou i pio, o lakou ka'u e hookomo aku ai iloko, a e ike auanei lakou i ka aina a oukou i hoowahawaha ai. ");
INSERT INTO haw1868_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Aka, o oukou, e haule auanei ko oukou mau kupapau ma ka waonahele. ");
INSERT INTO haw1868_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","A e aea ana ka oukou poe keiki ma ka waonahele i na makahiki he kanaha, a e halihali lakou i ko oukou moekolohe ana, a hiki i ka nalo ana o ko oukou mau kupapau maloko o ka waonahele. ");
INSERT INTO haw1868_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","E like me ka helu ana o na la a oukou i makaikai ai i ka aina, hookahi kanaha la; o kekahi la no ka makahiki hookahi, pela oukou e lawe ai i ko oukou hewa, hookahi kanaha makahiki, a e ike auanei oukou i ko'u haalele ana ia oukou. ");
INSERT INTO haw1868_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Owau o Iehova ka mea i olelo, a he oiaio no, e hana aku no wau ia i keia anaina kanaka ino a pau, i ka poe i akoakoa e ku e ia'u. Ma keia waonahele lakou e hoopauia'i, a ilaila hoi e make ai lakou. ");
INSERT INTO haw1868_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","A o na kanaka a Mose i hoouna aku ai e makaikai i ka aina, a i ka hoi ana mai, hoolilo ae la lakou i ke anaina kanaka a pau i ka ohumu ia ia, i ka lakou olelo alapahi ana i ka aina; ");
INSERT INTO haw1868_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","O ua mau kanaka la, ka poe i olelo hoino i ka aina, make iho la lakou i ke ahnlau imua o Iehova. ");
INSERT INTO haw1868_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Aka, o Iosua ke keiki a Nuna, a o Kaleba ke keiki a Iepune, o laua kekahi mau mea i hele e makaikai i ka aina, ola no laua. ");
INSERT INTO haw1868_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Hai aku la o Mose ia mau olelo i na mamo a Iseraela; a uwe nui iho la na kanaka. ");
INSERT INTO haw1868_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Ala ae la lakou i kakahiaka nui, a pii ae la maluna pono o ka pun, me ka i ana, Eia no kakon, e hele aku hoi kakou i kahi a Iehova i olelo mai ai; no ka mea, ua hana hewa makou. ");
INSERT INTO haw1868_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Olelo aku la o Mose, No ke aha la oukou e hoohala nei i ke kauoha a Iehova? aka aole ia e hiki. ");
INSERT INTO haw1868_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Mai noho a pii aku oukou, aole o Iehova me oukou; o pepehiia auanei oukou imua o ko oukou poe enemi. ");
INSERT INTO haw1868_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","No ka mea, aia no ka Ameleka a me ka Kanaana imua o oukou. a e haule auanei oukou i ka pahikana; no ka mea, ua huli ae oukou mai o Iehova aku; no ia mea, aole o Iehova me oukou. ");
INSERT INTO haw1868_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Aka, ua aa lakou e pii maluna pono o ka puu: aole nae i hele aku ka pahuberita o Iehova a me Mose, iwaho o kahi hoomoana. ");
INSERT INTO haw1868_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Alaila, iho mai la ka Ameleka a me ka Kanaana e noho ana ma ia puu, pepehi iho la ia lakou, a hoopuehu aku la a hiki i Horema. ");
INSERT INTO haw1868_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","OLELO mai la o Iehova ia Mose, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","E olelo aku oe i na mamo a Iseraela, a e i aku ia lakou, Aia komo aku oukou i ka aina o ko oukou noho ana, kahi a'u e haawi aku ai no oukou; ");
INSERT INTO haw1868_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","A e kaumaha aku oukou ma ke ahi i mohai na Iehova, i mohaikuni paha, i mohaihooko i ka hoohiki paha, a i mohaialoha paha, a ma ka oukou mau ahaaina laa paha, i mea e hana'i i ke ala oluolu no Iehova, no na bipi paha, no na hipa paha; ");
INSERT INTO haw1868_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","Alaila o ka mea nana e kaumaha aku kana mohai na Iehova, e lawe mai ia i mohaiai, he hapaumi o ka epa palaoa, i kawili pu ia me ka hapaha o ka hina aila. ");
INSERT INTO haw1868_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","A o ka hapaha o ka hina waina i mohaiinu kau e hoomakaukau ai, me ka mohaikuni, a he mohai maoli paha, no ke keikihipa hookahi. ");
INSERT INTO haw1868_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Ina no kekahi hipakane, e hoomakaukau oe i mohaiai, i elua hapaumi o ka epa palaoa i kawiliia me ka hapakolu o ka hina aila. ");
INSERT INTO haw1868_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","A e kaumaha aku oe i ka hapakolu o ka hina waina, i mohaiinu, i mea ala oluolu no Iehova. ");
INSERT INTO haw1868_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","I ka manawa au e hoomakaukau ai i ka bipikane i mohaikuni, a i mohaihooko i ka hoohiki paha, a i mohaihoomalu paha na Iehova; ");
INSERT INTO haw1868_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","Alaila e lawe pu mai oia me ka bipikane i mohaiai he akolu hapaumi o ka epa palaoa, i kawiliia me ka hapalua o ka hina aila. ");
INSERT INTO haw1868_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","A e lawe mai hoi oe i ka hapalua o ka hina waina i mohaiinu, he mohai i hanaia ma ke ahi, i mea ala oluolu no Iehova. ");
INSERT INTO haw1868_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Pela e hanaia'ku ai no ka bipikane hookahi, a no ka hipakane hookahi, a no ke keikihipa, a no ke keikikao. ");
INSERT INTO haw1868_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","E like me ka nui o na mea a oukou e hoomakaukau ai, pela no oukou e hana aku ai i kela mea keia mea a pau, e like me ka nui o lakou. ");
INSERT INTO haw1868_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","O na mea a pau i hanau ma ka aina, ma keia kumu ka lakou e hana'i ia mau mea, ma ke kaumaha ana aku i ka mohai i hanaia ma ke ahi, he mea ala oluolu no Iehova. ");
INSERT INTO haw1868_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Ina e noho ana ke kanaka e me oukou, a o kela mea keia mea iwaena o oukou, i na hanauna o oukou, a manao ia e kaumaha i ka mohai i hanaia ma ke ahi, he mea ala oluolu no Iehova; e like me ka oukou hana ana, pela hoi oia e hana'i. ");
INSERT INTO haw1868_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Hookahi no kanawai no oukou o ke anaina kanaka, a no ke kanaka e hoi e noho pu ana, he kanawai e mau loa ana no na hanauna o oukou: e like me oukou nei, pela no hoi ka malihini imua o Iehova. ");
INSERT INTO haw1868_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Hookahi no kanawai, a hookahi no kumu hana no oukou, a no ke kanaka e, e noho ana me oukou. ");
INSERT INTO haw1868_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Olelo mai o Iehova ia Mose, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","E olelo aku oe i na marao a Iseraela, a e i aku ia lakou, Aia hiki aku oukou i ka aina kahi a'u e hookomo ai ia oukou: ");
INSERT INTO haw1868_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","A ai iho oukou i ka berena o ia aina, alaila e mohai aku oukou i mohaihoali na Iehova. ");
INSERT INTO haw1868_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","A e lawe mai oukou i ka popo mua o ka oukou palaoa kawili i mohaihoali, e like me ka mohaihoali o kahi hehipalaoa, pela oukou e mohai ai ia. ");
INSERT INTO haw1868_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","No ka mua o ka oukou palaoa kawili ka oukou e haawi aku ia Iehova i mohaihoali ma ko oukou mau hanauna. ");
INSERT INTO haw1868_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","Ina i lalau oukou, aole hoi i malama i keia mau kauoha a pau a Iehova i olelo mai ai ma o Mose la, ");
INSERT INTO haw1868_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","I na mea a pau a Iehova i kauoha mai ai ma ka lima o Mose mai ka la a Iehova i kauoha mai ai, a ma keia hope aku iwaeua o na hanauna o oukou; ");
INSERT INTO haw1868_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","Alaila, ina paha e hana hewa naaupo ia, a ua ike ole ia e ke anaina kanaka, e kaumaha aku no ke anaina kanaka a pau i hookahi bipikane hou i mohaikuni, i mea ala oluolu no Iehova, me kana mohaiai, a me kana mohaiinu, mamuli o ke kanawai; a i hookahi keikikao i mohaihala; ");
INSERT INTO haw1868_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","A na ke kahuna e hookala-hala no ke anaina kanaka a pau o na mamo a Iseraela, a e kalaia ia no lakou; no ka mea, he naaupo ia: a e lawe mai lakou i ka lakou mohai, i mohai i hanaia ma ke ahi na Iehova, a me ka lakou mohailiala imua o Iehova, no ko lakou naaupo ana: ");
INSERT INTO haw1868_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","A e kalaia ia no ke anaina a pau o na mamo a Iseraela, a no ke kanaka e e noho ana iwaena o lakou: no ka mea, iloko o ka naaupo ka poe kanaka a pau. ");
INSERT INTO haw1868_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","A i hana hewa naaupo kekahi kanaka, alaila, e lawe mai ia i kaowahine o ka makahiki mua, i mohaihala. ");
INSERT INTO haw1868_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","A e hookalahala ke kahuna no ke kanaka i hana hewa naaupo, ke hana hewa naaupo ia imua o Iehova, i mea kalaia i ka hala nona; a e kalaia no ia nona. ");
INSERT INTO haw1868_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","I hookahi no kanawai o oukou no ka mea hana hewa naaupo, no ka mea i hanau iwaena o na mamo a Iseraela, a no ke kanaka e e noho ana me oukou. ");
INSERT INTO haw1868_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Aka, o ke kanaka hana hewa me ka hookiekie, o ke keikipapa, a me ke kanaka e, oia ka mea hoino ia Iehova; a e hookiia'ku ua kanaka la maiwaena aku o kona hanauna. ");
INSERT INTO haw1868_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","No ka mea, ua hoowahawaha aku ia i ka olelo a Iehova, ua haihai iho oia i kona kanawai, e hooki loa ia aku oia; maluna iho ona kona hewa. ");
INSERT INTO haw1868_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Maloko o ka waonahele na mamo a Iseraela, a loaa ia lakou he kanaka nana i hoiliili i ka wahie i ka la Sabati. ");
INSERT INTO haw1868_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","A o ka poe i ike ia ia e hoiliili ana i ka wahie, kai mai la lakou ia ia io Mose laua o Aarona la, a i ke anaina kanaka a pau. ");
INSERT INTO haw1868_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Hoonoho iho la lakou ia ia ma kahi paa; no ka mea, aole i hoikeia mai ka mea i hanaia'ku ai ia ia. ");
INSERT INTO haw1868_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Olelo mai la o Iehova ia Mose, He oiaio no, e make ia kanaka: na ke anaina kanaka a pau ia e hailuku aku mawaho o kahi hoomoana. ");
INSERT INTO haw1868_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Kai aku la na kanaka a pau ia ia mawaho o kahi hoomoana, hailuku aku la ia ia a make, me ka Iehova i kauoha mai ai ia Mose. ");
INSERT INTO haw1868_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Olelo mai la o Iehova ia Mose, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","E olelo aku oe i na mamo a Iseraela, e i aku ia lakou, e hana lakou i na pihapiha ma na kihi o ko lakou mau aahu, ma na hanauna o lakou, a e hoopili iho lakou i ke kaula ribina uliuli ma na pihapiha o na kihi. ");
INSERT INTO haw1868_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","A e lilo iho ia no oukou i pihapiha, e nana iho ai, a e hoomanao i na kauoha a pau a Iehova, a e malama hoi ia lakou; i ole ai oukou e imi aku mamuli o ko oukou mau naau, a me ko oukou mau maka; mamuli o ia mau mea ka oukou i hele moekolohe ai: ");
INSERT INTO haw1868_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","I hoomanao ai oukou, a e hana hoi i ka'u mau kauoha a pau, a e lilo oukou i poe laa no ko oukou Akua. ");
INSERT INTO haw1868_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Owau no Iehova o ko oukou Akua, nana oukou i lawe ae mailoko mai o ka aina o Aigupita, i Akua wau no oukou: owau no Iehova o ko oukou Akua. ");
INSERT INTO haw1868_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","A KUKA iho la o Kora, ke keiki a Izekara, ke keiki a Kohata, ke keiki a Levi, a o Datana a me Abirama na keiki a Eliaba, a me Ona ke keiki a Peleta, na keiki a Reubena: ");
INSERT INTO haw1868_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","A ku iluna lakou me kekahi poe mamo a Iseraela imua o Mose, he elua haneri a me kanalima na luna o na kanaka, he poe pookela ma ke anaina kanaka, na kanaka kaulana: ");
INSERT INTO haw1868_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Houluulu ae la lakou e ku e ia Mose a ia Aarona, i mai la ia laua, He nui loa ka olua, no ka mea, ua laa ke anaina kanaka a pau loa, a o Iehova kekahi iwaena o lakou: no ke aha la hoi olua e hookiekie ae nei ia olua iho maluna o ke anaina kanaka o Iehova? ");
INSERT INTO haw1868_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","A lohe ae la o Mose, moe iho la ia ilalo ke alo. ");
INSERT INTO haw1868_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Olelo aku la ia ia Kora, a me kona poe a pau, i aku la, A kakahiaka ae, e hoike mai o Iehova i ka mea nona, a me ka mea laa; a e hookokoke aku ai ia ia io na la; o ka mea ana e koho ai, oia kana e hookokoke aku ai io na la. ");
INSERT INTO haw1868_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","O keia ka oukou e hana'i; E lawe oukou i na ipukuniala, o Kora a me kona mau hoa a pau; ");
INSERT INTO haw1868_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","E hahao i ke ahi maloko, e hahao hoi i ka mea ala maloko imua o Iehova i ka la apopo: a o ka mea a Iehova e wae mai ai, oia ka mea laa: he nui loa ka oukou, e na mamo a Levi. ");
INSERT INTO haw1868_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","I aku la o Mose ia Kora ma, Ke noi aku nei au ia oukou, e hoolohe mai oukou, e na mamo a Levi. ");
INSERT INTO haw1868_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","He mea uuku anei ia oukou, i hookaawale ae ke Akua o ka Iseraela ia oukou mai ke anaina kanaka o ka Iseraela mai, e hookokoke oka ia oukou io na la, e hana i ka hana ma ka halelewa o Iehova, a e ku imua o ko anaina kanaka, e lawelawe na lakou? ");
INSERT INTO haw1868_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","A ua hookokoke mai no oia ia oe a me kou poe hoahanau na mamo a Levi me oe: a ke imi nei anei hoi oukou i ka oihana kahuna? ");
INSERT INTO haw1868_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","No ia mea, ua akoakoa ae nei oe me ou poe a pau e ku e ia Iehova; heaha hoi o Aarona i ohumu aku ai oukou ia ia? ");
INSERT INTO haw1868_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Hoouna aku la o Mose, e kii ia Datana laua o Abirama na keiki a Eliaba: i mai la hoi laua, Aole maua e hele aku. ");
INSERT INTO haw1868_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","He mea liilii anei kou lawe ana mai ia makou mailoko mai o ka aina e kahe ana o ka waiu a me ka meli, e pepehi ia makou ma ka waonahele, ke hiki ole ia oe e hoolilo ia oe iho i alii maluna o makou? ");
INSERT INTO haw1868_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Aole no hoi oe i lawe aku ia makou i ka aina e kahe ana o ka waiu a me ka melt, me ka haawi mai no makou i na kula a me na malawaina. K poalo anei oe i na maka o keia poe kanaka? Aole no maua e hele aku. ");
INSERT INTO haw1868_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Huhu loa iho la o Mose, a i aku la ia Iehova, Mai maliu mai oe i ka lakou mohai: aole au i lawe no'u i kekahi hoki o lakou, aole hoi au i hana eha aku i kekahi o lakou. ");
INSERT INTO haw1868_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","I aku la o Mose ia Kora, Apopo, e hele oe me ou poe a pau imua o Iehova, o oe, o lakou a me Aarona. ");
INSERT INTO haw1868_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","E lawe hoi keia kanaka kela kanaka i kona ipukuniala, e hahao i ka mea ala maloko, a e lawe mai na kanaka o oukou a pau i ko lakou ipukuniala imua o Iehova, i elua haneri a me kanalima na ipukuniala; o oe hoi, a o Aarona, o kela mea keia mea me kona ipukuniala. ");
INSERT INTO haw1868_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","A lawe ae la kela kanaka keia kanaka i kona ipukuniala, hahao iho la i ke ahi maloko, a kau i ka mea ala maluna, a ku ae la ma ka puka o ka halelewa o ke anaina me Mose a me Aarona. ");
INSERT INTO haw1868_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Houluulu ae la o Kora i ke anaina kanaka a pau ma ka puka o ka halelewa e ku e ia laua: a ikea ae la ka nani o Iehova e ke anaina kanaka a pau. ");
INSERT INTO haw1868_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Olelo mai la o Iehova ia Mose a me Aarona, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","K hookaawale ae olua ia olua iho mai keia anaina kanaka aku, i hoopau koke ai au ia lakou. ");
INSERT INTO haw1868_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Moe iho la laua, ilalo ke alo, i aku la, E ke Akua, ke Akua o na uhane o na kanaka a pau, a i hewa ke kanaka hookahi, e inaina mai no anei oe i ke anaina kanaka a pau? ");
INSERT INTO haw1868_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Olelo mai la o Iehova ia Mose, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","E olelo aku oe i ke anaina kanaka, e i aku, E hookaawale ae ia oukou iho mai kela aoao a mai keia aoao aku o ka halelewa o Kora, o Datana a o Abirama. ");
INSERT INTO haw1868_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Ku ae la o Mose, a hele aku la io Datana a me Abirama la, a hahai aku la na lunakahiko o ka Iseraela ia ia. ");
INSERT INTO haw1868_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Olelo aku la ia i ke anaina kanaka, i aku la, E hookaawale aku ia oukou iho mai na halelewa aku o keia mau kanaka hewa, mai hoopa aku i kekahi mea o lakou nei, o make auanei oukou iloko o ko lakou hewa a pau. ");
INSERT INTO haw1868_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Alaila, haalele aku la lakou i ka halelewa o Kora a me Datana a me Abirama mai keia aoao a mai kela aoao aku: a puka mai la o Datana laua o Abirama iwaho, a ku mai la ma ka puka o ko laua mau halelewa, me ka laua mau wahine, me na keikikane a laua, a me ka laua mau keiki uuku. ");
INSERT INTO haw1868_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","I aku la o Mose, Ma keia mea e ike ai oukou, owau no ka Iehova i hoouna mai nei e hana i keia mau hana a pau; no ka mea, aole ia na kuu manao iho. ");
INSERT INTO haw1868_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Ina paha e make keia poe kanaka e like me ka make ana o na kanaka a pau, a i ikeia'ku lakou e like me ka ikeia'na o na kanaka a pau, alaila aole na Iehova wau i hoouna mai. ");
INSERT INTO haw1868_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Aka ina e hana mai o Iehova i ka mea hou, a hamama ae ka honua i kona waha, a moni iho ia lakou nei, me na mea a pau ia lakou, a iho koke lakou ilalo i ka lua; alaila e ike pono oukou, ua hoonaukiuki aku keia mau kanaka ia Iehova. ");
INSERT INTO haw1868_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","A i ka manawa i hooki ai oia i ka olelo ana i keia mau mea a pau, naha'e la ka honua malalo iho o lakou: ");
INSERT INTO haw1868_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","A hamama ae la ka honua i kona waha, ale iho la ia lakou, me ko lakou mau hale, a me na kanaka a pau i pili aku ia Kora, a me ko lakou waiwai a pau. ");
INSERT INTO haw1868_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","O lakou a me ko lakou mea a pau, iho ola iho la iloko o ka lua, a paa hou mai la ka honua maluna o lakou; a make iho la lakou maiwaena aku o ke anaina kanaka. ");
INSERT INTO haw1868_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","A holo aku la ka Iseraela a pau ma kela aoao a ma keia aoao o lakou, i ko lakou hooho ana; i ae la lakou, O ale auanei ka honua ia kakou. ");
INSERT INTO haw1868_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Puka mai la ke ahi mai o Iehova mai, a ai mai la i na kanaka elua haneri me kanalima, o ka poe i mohai aku i ka mea ala. ");
INSERT INTO haw1868_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Olelo mai la o Iehova ia Mose, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","E olelo aku ia Eleazara ke keiki a Aarona, ke kahuna, e lawe ia i na ipukuniala mailoko ae o ke ahi, a e hoolei aku i ke ahi ma o; no ka mea, ua laa ia mau mea. ");
INSERT INTO haw1868_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","O na ipukuniala o keia poe i hana hewa aku i ko lakou mau uhane, e hana lakou ia mau mea i mau pa palahalaha, i uhi no ke kuahu: no ka mea, na kaumaha iho la lakou ia mau mea imua o Iehova, nolaila ua laa; a e lilo lakou i hoailona no na mamo a Iseraela. ");
INSERT INTO haw1868_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","A lawe ae la o Eleazara ke kahuna i na ipukuniala keleawe, i na mea a ka poe pau i ke ahi i mohai aku ai; a ua hanaia ua mau mea la i mau pa palahalaha no ke kuahu: ");
INSERT INTO haw1868_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","I mea hoomanao no na mamo a Iseraela, i ole ai ke kanaka e, ka mea aole na ka hua a Aarona, e hele mai a kokoke e kuni i ka mea ala imua o Iehova, i like ole ai ia me Kora, a me kona poe; me ka Iehova i olelo mai ai ia ia ma ka lima o Mose. ");
INSERT INTO haw1868_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Ia la ae, ohumu ae la ke anaina kanaka a pau o na mamo a Iseraela, ia Mose a ia Aarona, i mai la, Ua make ia olua ko Iehova poe kanaka. ");
INSERT INTO haw1868_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Aia akoakoa ae ke anaina kanaka e ku e ia Mose a ia Aarona, nana ae la lakou i ka halelewa o ke anaina, aia hoi, uhi mai la ke ao, a ikea mai la hoi ka nani o Iehova. ");
INSERT INTO haw1868_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Hele aku la o Mose laua o Aarona imua o ka halelewa o ke anaina. ");
INSERT INTO haw1868_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","Olelo mai la o Iehova ia Mose, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","E hookaawale ae ia olua iho maiwaena ae o keia anaina kanaka, i hoopau koke ai au ia lakou. A moe iho la laua ilalo ke alo. ");
INSERT INTO haw1868_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","I aku la o Mose ia Aarona, E lawe oe i wahi ipukuniala, a e hahao i ke ahi maloko mailuna mai o ke kuahu, e kau hoi i ka mea ala maluna, a e hele koke aku i ke anaina kanaka, a e hookalahala no la kou; no ka mea, ua hele aku la ka inaina mai o Iehova aku; ua hoomakaia ke ahulau. ");
INSERT INTO haw1868_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Lawe aku la o Aarona, e like me ka Mose i kauoha'i, a holo aku la iwaena o ke anaina kanaka; aia hoi, ua hoomakaia ke ahulau iwaena o ka poe kanaka: kau iho la ia i ka mea ala, a hookalahala aku la no ka poe kanaka. ");
INSERT INTO haw1868_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Ku iho la ia iwaena o ka poe make a me ka poe ola; a hookiia iho la ke ahulau. ");
INSERT INTO haw1868_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","A o ka poe i make i ke ahulau, he umikumamaha tausani a me na haneri ehiku; he okoa ka poe i make no ka mea o Kora. ");
INSERT INTO haw1868_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","A hoi hou ae la o Aarona io Mose la, ma ka puka o ka halelewa o ke anaina: a ua hookiia ke ahulau. ");
INSERT INTO haw1868_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","OLELO mai la o Iehova ia Mose, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","E olelo aku oe i na mamo a Iseraela, a e lawe oe i ke kookoo o kela kanaka a i ke kookoo o keia kanaka, no ka ohana o ko lakou poe kupuna, o na luna o lakou a pau, no ka ohana o ko lakou poe kupuna, i na kookoo he umikumamalua; a e kakau oe i ka inoa o kela kanaka keia kanaka maluna o kona kookoo iho. ");
INSERT INTO haw1868_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","E kakau hoi oe i ka inoa o Aarona maluna o ke kookoo no ka Levi: hookahi kookoo, no ka hma ohana o ko lakou mau kupuna ia. ");
INSERT INTO haw1868_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","A e waiho oe ia mau mea ma ka halelewa o ke anaina, imua o ke kanawai, kahi a'u e halawai ai me olua. ");
INSERT INTO haw1868_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","A o ke kookoo o ke kanaka e wae iho ai, e pua no ia; a e hoopaa no wau mai o'u aku nei i na ohnmu ana a ka poe mamo a Iseraela e ohumn aku nei ia olua. ");
INSERT INTO haw1868_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Olelo aku la o Mose i na mamo a Iseraela, a haawi mai la kela luna keia luna i kekahi kookoo ia ia, hookahi luna hookahi kookoo no na ohana o ko lakou poe kupuna, he umikumamalua mau kookoo: a iwaena o ko lakou mau kookoo, ke kookoo o Aarona. ");
INSERT INTO haw1868_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","A waiho aku la o Mose i na kookoo imua o Iehova, maloko o ka halelewa o ke kanawai. ");
INSERT INTO haw1868_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","A ia la ae, komo aku la o Mose iloko o ka halelewa o ke kanawai; aia hoi, ua opuu mai ke kookoo o Aarona no ka ohana a Levi, a ua mohala ae na opuu, ua poa i na pua, a na hua mai i na hua alemona. ");
INSERT INTO haw1868_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Lawe mai la o Mose i na kookoo a pau iwaho, mai ke alo o Iehova mai, a imua o na mamo a pau a Iseraela: nana ae la lakou, a lawe aku la kela kanaka keia kanaka i kona kookoo iho. ");
INSERT INTO haw1868_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","I mai la o Iehova ia Mose, E lawe hou mai i ke kookoo o Aarona imua o ke kanawai, e malamaia'i i hoailona no ka poe kipi; a e lawe lilo loa aku oe i ko lakou ohumu ana mai o'u aku nei, i make ole ai lakou. ");
INSERT INTO haw1868_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","A hana aku la o Mose; e like me ka Iehova i kauoha mai ai ia ia, peia ia i hana'i. ");
INSERT INTO haw1868_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Olelo mai la na mamo a Iseraela ia Mose, i mai la, Aia hoi, ua make makou, ua pau makou, ua pau makou a pau. ");
INSERT INTO haw1868_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","O ka mea hele a kokoke aku i ka halelewa o Iehova, e make ia: e pau loa no anei makou i ka make? ");
INSERT INTO haw1868_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","OLELO mai la o Iehova ia Aarona, Maluna iho ou a mo au mau keiki, a me ka ohana a kou kupuna e ili ai ka hewa o ke keenakapu; a maluna iho ou a me au mau keiki e ili ai ka hewa o ka oihanakahuna. ");
INSERT INTO haw1868_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","A o kou poe hoahanau hoi o ka ohana a Levi, ka ohana a ou kupunakane, o lakou kau e lawe pu ai me oe, i hui pu ia'i me oe, a e lawelawo lakou na'u: aka o oe a me kau mau keiki me oe, imua o ka halelewa o ke kanawai oukou. ");
INSERT INTO haw1868_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","A e malama lakou i kau oihana a me ka oihana o ka halelewa a pau: aole nae lakou e hele mai a kokoke i na ipu o ke keenakapu, a i ke kuahu, i ole ai lakou e make, aole hoi oukou. ");
INSERT INTO haw1868_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","A e hui pu ia lakou me oe, a e malama lakou i ka oihana o ka halelewa o ke anaina, no ka hana a pau o ka halelewa: aole no e hele mai ke kanaka e, a kokoke io oukou la. ");
INSERT INTO haw1868_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","A e malama oukou i ka oihana o ke keenakapu a me ka oihana o ke kuahu; i kau hou ole ai ka inaina maluna o na mamo a Ise-raela, ");
INSERT INTO haw1868_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","A owau nei la, ua lawe no wau i ko oukou poe hoahanau o na Levi, maiwaena mai o na mamo a Iseraela: ua haawiia lakou no oukou, i haawina no Iehova, e lawelawe i ka hana ma ka halelewa o ke anaina. ");
INSERT INTO haw1868_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Nolaila la, e malama oe a me au mau keiki me oe i ka oukou oihanakahuna no na mea a pau o ke kuahu, a maloko o ka paku: a e malama oukou; ua haawi aku au na oukou i ka oihanakahuna i oihana i haawi lokomaikai ia; a o ke kanaka e ae e hele wale mai a kokoke, e make ia. ");
INSERT INTO haw1868_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Olelo mai la o Iehova ia Aarona, Aia hoi, ua haawi aku au ia oe i ka malama i ka'u mau mohaihoali, o na mea laa a pau a na mamo a Iseraela; ua haawi aku au ia mau mea nau, i kuleana nau a na kau mau keiki, ma ke kanawai mau loa. ");
INSERT INTO haw1868_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","O keia no kau no na mea laa loa, mai ke ahi mai: o na mohaimakana a pau a lakou, o na mohaiai a pau a lakou, o na mohaihala a pau a lakou, a o na mohailaweluila a lakou, na mea a lakou e haawi mai ai ia'u, e laa loa ia nau a na kau poe keiki. ");
INSERT INTO haw1868_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Ma kahi hoano loa oe e ai ai ia mea: o na kane a pau e ai iho ia: he mea laa ia nau. ");
INSERT INTO haw1868_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","Oia no nau; o ka mohaikaikai a lakou e haawi mai ai, a me na mohaihoali a pau a na mamo a Iseraela; ua haawi aku au ia mau mea nau, a na kau poe keikikane a me kau poe kaikamahine me oe ma ke kanawai mau loa; o ka poe maemae a pau iloko o kou hale, o lakou ke ai ia mea. ");
INSERT INTO haw1868_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","O kahi momona a pau o ka aila, me kahi momona a pau o ka waina, a o ka palaoa, o na hua mua o ia mau mea, na mea a lakou e mohai iho ai na Iehova, oia mau mea ka'u i haawi aku ai nau. ");
INSERT INTO haw1868_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","O na mea a pau i oo mua ma ka aina, a lakou e lawe mai ai na Iehova, o kau ia; o ka poe a pau i maemae ma kou hale, e ai lakou ia. ");
INSERT INTO haw1868_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","O na mea a pau iloko o ka Iseraela i hoolaaia, nau no ia. ");
INSERT INTO haw1868_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","O kela hiapo keia hiapo a na mea io a pau, a ke kanaka a me ka holoholona, na mea a lakou e lawe mai ai na Iehova, nau no lakou: aka, e panai aku oe i ka hiapo a kanaka, a o ka hanau mua a na holoholona maemae ole kau e panai ai. ");
INSERT INTO haw1868_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","A o na mea e pono ke panai ia, mai ka malama hookahi o ka hanau ana kau e panai ai, ma kou manao ana, e like me na sekela elima, ma ka sekela o ke keenakapu, oia hoi na gera ho iwakalua. ");
INSERT INTO haw1868_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Aka, o ka hiapo a ka bipi, a o ka hiapo a ka hi pa, a o ka hiapo a ke kao paha, mai panai oe, ua laa ia mau mea; e pipi oe i ko lakou koko maluna o ke kuahu, a e puhi i ko lakou momona i mohai ma ke ahi, i mea ala ono no Iehova. ");
INSERT INTO haw1868_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","A o ka io o ia mau mea, nau no ia, e like me ka umauma hoali a me ka uha mua akau, nau no ia. ");
INSERT INTO haw1868_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","O na mohaikaikai a pau no na mea laa, na mea a na mamo a Iseraela e kaumaha ai na Iehova, oia ka'u i haawi aku ai nau, a na kau poe keikikane a me na kaikamahine me oe, ma ke kanawai mau loa: he berita paakai mau loa ia imua o Iehova nou, a no kau hua me oe. ");
INSERT INTO haw1868_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Olelo mai la o Iehova ia Aarona, Aohe ou aina hooilina ma ko lakou aina, aohe hoi kuleana ou iwaena o lakou: owau no kou kuleana a me kou hooilina iwaena o na mamo a Iseraela. ");
INSERT INTO haw1868_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Aia hoi, ua haawi aku no wau no na mamo a Levi i ka hapaumi iloko o ka Iseraela, i hooilina no ka hana a lakou e hana'i, oia ka hana ma ka halelewa o ke anaina kanaka. ");
INSERT INTO haw1868_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Aole hoi e hele mai na mamo a Iseraela a kokoke i ka halelewa o ke anaina ma keia hope aku, o lawehala lakou e make ai. ");
INSERT INTO haw1868_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Aka, e hana na Levi i ka oihana ma ka halelewa o ke anaina, a e lawe lakou i ko lakou hewa iho. He kanawai mau loa ma na hanauna o oukou, aohe o lakou aina hooili iwaena o na mamo a Iseraela. ");
INSERT INTO haw1868_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Aka, o ka hapaumi o ka na mamo a Iseraela, o La mea a lakou e kaumaha ai i mohaikaikai na Iehova, oia ka'u i haawi aku ai ua na Levi i mea hooili: nolaila ka'u i olelo aku ai ia lakou, Aohe o lakou aina hooili iwaena o na mamo a Iseraela. ");
INSERT INTO haw1868_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Olelo mai la o Iehova ia Mose, i mai la. ");
INSERT INTO haw1868_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","Penei e olelo aku ai i na Levi, e i aku ia lakou, Aia lawe oukou i ka hapaumi mai na mamo a Iseraela aku, i ka mea a'u i haawi aku ai na oukou mai o lakou mai, i hooilina no oukou, alaila, e kaumaha aku ai oukou i ka mohaikaikai noloko mai o ia mea, na Iehova, i hookahi hapaumi o ua hapaumi la. ");
INSERT INTO haw1868_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","A e hooliloia ka oukou mohaikaikai no oukou e like me ka palaoa no ke kahua hehi palaoa, a me ka piha ana o ka waihona waina. ");
INSERT INTO haw1868_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Pela no hoi oukou e kanmaha ai i mohaikaikai na Iehova, noloko mai o na hapaumi a pau o oukou, i loaa ia oukou na na mamo a Iseraela mai; a noloko o keia mea ka oukou e haawi ai i ka mohaikaikai a Iehova na Aarona ke kahuna. ");
INSERT INTO haw1868_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Noloko mai o ka oukou mau haawina a pau e kaumaha aku ai oukou i na mohaikaikai a pau a Iehova, noloko mai o kahi momona a pau o ia mea, o kahi laa ona, noloko o ia wahi. ");
INSERT INTO haw1868_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Nolaila, e olelo aku ai oe ia lakou, Aia hookaawale ae oukou i kahi momona ona mai ia mea aku, alaila, e hooliloia no na Levi e like me ka mea i loaa o ke kahua hehi palaoa, a me ka mea i loaa o ka waihona waina. ");
INSERT INTO haw1868_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","A e ai oukou ia mea ma kela wahi keia wahi, o oukou a me ko na hale o oukou, no ka mea, o ka oukou uku keia no ka oukou hana ana ma ka halelewa o ke anaina. ");
INSERT INTO haw1868_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Aole hoi oukou e lawe i ka hewa no ia mea, ia oukou i hookaawale ai i kahi momona o ia mea: aole no hoi oukou e hoohaumia i ua mea laa o na mamo a Iseraela, o make oukou. ");
INSERT INTO haw1868_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","OLELO mai la o Iehova ia Mose a ia Aarona, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","Eia ke kau ana i ke kanawai a Iehova i kauoha mai ai, penei, E olelo aku i na mamo a Iseraela, e lawe mai lakou iou la i bipiwahine hou ulaula maikai kina ole, aole hoi i kau ka auamo maluna ona. ");
INSERT INTO haw1868_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","A e haawi aku olua ia mea ia Eleazara ke kahuna, a e kai aku kela ia ia mawaho o kahi hoomoana, a e pepehiia oia imua o kona maka. ");
INSERT INTO haw1868_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","A e lawe o Eleazara ke kahuna i wahi koko ona ma kona manamanalima, a e kapipi i kona koko ma kahi e ku pono ana i ka halelewa o ke anaina, i ehiku kapipi ana. ");
INSERT INTO haw1868_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","A e puhiia i ke ahi ua bipiwahine hou la imua o kona mau maka, o kona ili, o kona io, me kona koko a me kona lepo kana e puhi ai. ");
INSERT INTO haw1868_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","A e lawe ke kahuna i ka laau kedera, a me ka husopa, a me ka mea ulaula, a e hoolei aku iloko o ke ahi lapalapa o ka bipiwahine. ");
INSERT INTO haw1868_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Alaila e holoi ke kahuna i kona mau kapa, a e auau i kona kino i ka wai, a mahope iho e hele mai ia iloko o kahi hoomoana, a e haumia ke kahuna a hiki i ke ahiahi. ");
INSERT INTO haw1868_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","A o ka mea nana e puhi aku ia, e holoi oia i kona mau kapa i ka wai, a e auau ia i kona kino i ka wai, a e haumia oia a hiki i ke ahiahi. ");
INSERT INTO haw1868_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","A e hoiliili kekahi kanaka maemae i ka lehu o ua bipiwahine la, a e waiho aku ia mea ma kahi maemae mawaho o kahi hoomoana: a e malamaia ia mea no ke anaina kanaka o na mamo a Iseraela, i wai huikala: he mea huikala ia no ka hewa. ");
INSERT INTO haw1868_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","A o ka mea nana e hoiliili i ka lehu o ka bipiwahine, e holoi ia i kona mau kapa, a e haumia oia a hiki i ke ahiahi: a e lilo ia no na mamo a Iseraela, a no ke kanaka e i noho pu ana me lakou, i kanawai mau loa. ");
INSERT INTO haw1868_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","O ka mea hoopa aku i ke kupapau o kekahi kanaka, e haumia oia i na la ehiku. ");
INSERT INTO haw1868_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","E huikala no oia ia ia iho me ia i ke kolu o ka la aku; a i ka hiku o ka la e maemae ia: aka, i ole oia e huikala ia ia iho i ke kolu o ka la, alaila, aole ia e maemae i ka hiku o ka la. ");
INSERT INTO haw1868_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","O kela mea keia mea e hoopa aku i ke kupapau o ke kanaka i make, a i huikala ole oia ia ia iho, ua hoohaumia oia i ka halelewa o Iehova; a e okiia ua kanaka la mai ka Iseraela aku: no ka mea, aole i kapipiia ka wai huikala maluna ona; e haumia no oia, e kau ana no kona haumia maluna ona. ");
INSERT INTO haw1868_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Eia ke kanawai i ka wa e make ai ke kanaka maloko o kekahi halelole: o na mea a pau i komo iloko o ua halelole la, a o na mea a pau oloko o ua halelole la, e haumia no lakou i na la ehiku. ");
INSERT INTO haw1868_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","A o na ipu hamama a pau, o na mea pani ole i haweleia a paa maluna, ua haumia ia. ");
INSERT INTO haw1868_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","A o ka mea hoopa aku i ka mea i pepehiia i ka pahikaua ma ke kula, a i ke kupapau paha, a i ka iwikanaka paha, a i ka hekupapau paha, e haumia no oia i na la ehiku. ");
INSERT INTO haw1868_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","A no ka haumia, e lawe lakou i kekahi lehu o ka bipiwahine i puhiia i ke ahi no ka huikala ana i ka hewa, a e hui pu ia ka wai puna me ia maloko o kekahi ipu. ");
INSERT INTO haw1868_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","A e lawe ke kanaka maemae i ka husopa, a e hou iho iloko o ka wai, a e kapipi ia maluna o ka halelole, a maluna o na ipu a pau, a maluna o na kanaka malaila, a maluna o ka mea nana i hoopa ka iwikanaka, a i ka mea i pepehiia paha, a i ke kupapau paha, a i ka hekupapau paha. ");
INSERT INTO haw1868_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","E kapipi ka mea maemae i ka mea haumia i ke kolu o ka la, a i ka hiku o ka la: a i ka hiku o ka la, e hoomaemae oia ia ia iho, a e holoi oia i kona mau kapa, a e auau ia i ka wai, a i ke ahiahi e huikala ia. ");
INSERT INTO haw1868_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Aka, o ke kanaka haumia, a i huikala ole oia ia ia iho, e hookiia'ku ua kanaka la mai ke anaina aku, no ka mea, ua hoohaumia oia i ke keenakapu o Iehova; aole i kapipiia ka wai huikala maluna ona; ua haumia oia. ");
INSERT INTO haw1868_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","A e lilo ia i kanawai mau loa no lakou; o ka mea nana e kapipi i ka wai huikala, e holoi ia i kona mau kapa; o ka mea hoi nana e hoopa aku i ka wai huikala, e haumia oia a hiki i ke ahiahi. ");
INSERT INTO haw1868_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","O kela mea keia mea a ka mea haumia e hoopa aku ai, e haumia hoi ia mea: a o ke kanaka nana e hoopa aku, e haumia oia a hiki i ke ahiahi. ");
INSERT INTO haw1868_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","A LAILA hele mai la ka poe mamo a Iseraela, o ke anaina kanaka a pau i ka waonahele o Zina, i ka malama mua: a noho iho la na kanaka ma Kadesa; malaila i make ai o Miriama, a ua kanuia iho la ia ma ia wahi. ");
INSERT INTO haw1868_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Aohe wai ilaila no ke anaina kanaka: a hoakoakoa ae la lakou ia lakou iho, a ku e ia Mose laua me Aarona. ");
INSERT INTO haw1868_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Hakaka ae la na kanaka me Mose, olelo ae la lakou penei, E aho ko makou make, i ka manawa i make ai na hoahanau o makou imua o Iehova! ");
INSERT INTO haw1868_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","No ke aha hoi olua i alakai mai nei i ke anaina kanaka o Iehova iloko o keia waonahele i make ai makou me na holoholona a makou? ");
INSERT INTO haw1868_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","No ke aha la olua i hoohele mai nei ia makou mai Aigupita mai, e hookomo ai ia makou iloko o keia wahi ino? Aole keia he wahi no na anoano, aohe fiku, aole kumu waina, aole pomeraite, aole hoi wai e inu ai. ");
INSERT INTO haw1868_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Hele aku la o Mose laua o Aarona mai ke alo o ke anaina kanaka aku a ka puka o ka halelewa o ke anaina, a moe iho la laua ilalo ke alo; a ikea mai la ka nani o Iehova ia laua. ");
INSERT INTO haw1868_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Olelo mai la o Iehova ia Mose, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","E lawe oe i ke kookoo, a e hoakoakoa oe i ke anaina kanaka, o oe a me Aarona kou kaikuaana, a e olelo aku olua i ka pohaku imua o na maka o lakou; a e haawi mai ia i kona wai, a e lawe mai oe i ka wai no lakou mailoko mai o ka pohaku: a pela no oe e hooinu ai i ke anaina kanaka, a me ka lakou poe holoholona. ");
INSERT INTO haw1868_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Lawe aku la o Mose i ke kookoo mai ke alo o Iehova aku, e like me kana i kauoha mai ai ia ia. ");
INSERT INTO haw1868_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Houluulu ae la o Mose laua o Aarona i ke anaina kanaka imua o ka pohaku, i aku la oia ia lakou, E hoolohe mai oukou, e ka poe kipi; pono anei no maua e hookahe iho i ka wai mailoko mai o keia pohaku? ");
INSERT INTO haw1868_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Kaikai ae la o Mose i kona lima iluna, hahau iho la i ka pohaku, me kona kookoo, elua hahau ana; a kahe nui mai la ka wai: inu iho la ke anaina kanaka a me ko lakou poe holoholona. ");
INSERT INTO haw1868_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Olelo mai la o Iehova ia Mose a me Aarona, No ko olua manaoio ole mai ia'u, e hoauo mai ia'u imua o na mamo a Iseraela, nelaila, aole olua e kai aku i keia anaina kanaka i ka aina a'u i haawi aku ai no lakou. ");
INSERT INTO haw1868_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","O keia ka wai no Meriba; no ka mea, ua aaka mai na mamo a Iseraela me Iehova, a ua hoanoia oia ia lakou. ");
INSERT INTO haw1868_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Hoouna aku la o Mose i na elele mai Kadesa aku i ke alii o Edoma, Penei ka ka hoahanau ou, ka Iseraela e olelo aku nei, Ua ike no oe i ka luhi a pau i loaa ia makou; ");
INSERT INTO haw1868_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","I ka iho ana o ko makou poe kupuna ilalo i Aigupita, a he liuliu ko makou noho ana i Aigupita; a hoopilikia mai ko Aigupita ia makou a me ko makou poe kupuna. ");
INSERT INTO haw1868_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","A i a wa i hea aku ai makou ia Iehova, hoolohe mai la oia i ko makou leo, a hoouna mai la i anela, a ua hoopuka mai ia makou iwaho o Aigupita: eia hoi makou ma Kadesa nei, he kulanakauhale ma ke kihi loa o kou palena. ");
INSERT INTO haw1868_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Ke noi aku nei au ia oe, e ae mai oe ia makou e hele aku mawaena o kou aina: aole makou e hele mawaena o na mahinaai, aole hoi mawaena o na pawaina, aole hoi makou e inu i ka wai o na punawai; e hele no makou ma ke alaloa o ke alii, aole makou e kipa ma ka akau, aole hoi ma ka hema, a hala aku makou i na palena ou. ");
INSERT INTO haw1868_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","I mai la o Edoma ia ia, Mai hele ae oe ma o'u nei o hele aku au e ku e ia oe me ka pahikaua. ");
INSERT INTO haw1868_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","I aku la ka poe mamo a Iseraela ia ia, E hele no makou ma ke alaloa, a iua e inu au a me ko'u poe holoholona i kou wai, alaila e uku aku no au ia mea: e hele wale no makou ma ko makou mau wawae, aole e hana i kekahi mea e ae. ");
INSERT INTO haw1868_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","I mai la kela, Aole loa oe e hele mawaena mai. A puka mai la ko Edoma e ku e mai ia ia, me na kanaka he nui loa, a me ka lima ikaika. ");
INSERT INTO haw1868_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Pela no o Edoma i hoole mai ai i ka haawi ana i alanui no ka Iseraela mawaena o kona palena: no ia mea, haliu ae la ka Iseraela mai ona aku la. ");
INSERT INTO haw1868_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Hele aku la na mamo a Iseraela, o ke anaina kanaka a pau, mai Kadesa aku a hiki i ke kuahiwi o Hora. ");
INSERT INTO haw1868_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Olelo mai la o Iehova ia Mose a me Aarona ma ke kuahiwi o Hora, ma ka palena aina o Edoma, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","E hui pu ia'ku o Aarona me kona poe kanaka: aole ia e komo i ka aina a'u i haawi aku ai no na mamo a Iseraela, no ka mea, ua ku e mai olua i ka'u olelo ma ka wai Meriba. ");
INSERT INTO haw1868_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","E lawe oe ia Aarona a me kana keiki o Eleazara, e kai aku ia laua maluna ma ko kuahiwi o Hora. ");
INSERT INTO haw1868_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","E wehe ae i ka aahu o Aarona, a e hookomo i kana keiki ia Eleazara: a e hui pu ia'ku o Aarona, a e make no ia malaila. ");
INSERT INTO haw1868_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Hana iho la o Mose e like me ka Iehova i kauoha mai ai: a pii aku la laua ma ke kuahiwi o Hora imua o ke anaina kanaka a pau. ");
INSERT INTO haw1868_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Wehe ae la o Mose i na aahu o Aarona, a hoaahu ae la maluna o kana keiki o Eleazara: a make iho la o Aarona malaila ma kahi oi o ke kuahiwi: a iho iho la o Mose laua o Eleazara mai ke kuahiwi mai. ");
INSERT INTO haw1868_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","A ike aku la ke anaina kanaka a pau, na make o Aarona, kanikau iho la ka Iseraela a pau ia Aarona i na la he kanakolu. ");
INSERT INTO haw1868_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","A LOHE ae la ke alii o Arada ka Kanaana, e noho ana ma ke kukuluhema, e hele mai ana ka Iseraela ma ke ala e hiki ai i na wahi ona, alaila, kaua mai la ia i ka Iseraela, a lawe pio aku la i kekahi poe o lakou. ");
INSERT INTO haw1868_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Hoohiki aku la ka Iseraela ia Iehova, i aku la, Ina paha e haawi mai oe i keia poe kanaka iloko o ko'u lima, alaila e luku loa aku no au i na kulanakauhale o lakou. ");
INSERT INTO haw1868_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Hoolohe mai la o Iehova i ka leo o ka Iseraela, a hoolilo mai la i ka poe Kanaana: a luku loa aku la lakou ia lakou la, a me na kulanakauhale o lakou; a kapa aku la ia i ka inoa o ia wahi o Horema. ");
INSERT INTO haw1868_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Hele aku la lakou mai ke kuahiwi o Hora aku, ma ke alanui o ke Kaiula, e puni i ka aina o Edoma: a ua pau ke aho o na kanaka no ke alanui. ");
INSERT INTO haw1868_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Olelo ino aku la na kanaka i ke Akua, a ia Mose, No ke aha la olua i kai mai nei ia makou mailoko mai o Aigupita e make ma ka waonahele? no ka mea, aohe berena, aole hoi ho wai; a ke hoopailua nei ko makou naau i keia ai mama. ");
INSERT INTO haw1868_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Hoouna mai la o Iehova i na nahesa wela iwaena o na kanaka, a nahu mai la lakou i na kanaka; a he nui na kanaka o ka Iseraela i make. ");
INSERT INTO haw1868_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","No ia mea, hele mai la na kanaka io Mose la, i mai la, Ua haua hewa makou; no ka mea, ua olelo ino aku makou ia Iehova a ia oe: e pule aku oe ia Iehova, e lawe aku ia i na nahesa mai o makou aku nei. A pule aku la o Mose no na kanaka. ");
INSERT INTO haw1868_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Olelo mai la o Iehova ia Mose, E hana oe nau i nahesa wela, a e kau aku ia maluna o ka laau, a o kela mea keia mea i nahuia, i ka wa e nana aku ai oia ia mea, e ola no ia. ");
INSERT INTO haw1868_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","A hana iho la o Mose i nahesa keleawe, a kau aku la ia maluna o ka laau; a o ke kanaka i nahuia i ka nahesa wela, i ka wa i nana aku ai oia i ka nahesa keleawe, ua ola ia. ");
INSERT INTO haw1868_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","A hele aku la na mamo a Iseraela, a hoomoana iho la ma Obota. ");
INSERT INTO haw1868_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","A hele lakou mai Obota aku, a hoomoana iho la ma Iieabarima, i ka waonahele ma ke alo o Moaba, ma ka hikina o ka la. ");
INSERT INTO haw1868_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Mailaila aku lakou i hele ai, a hoomoana iho la ma ke kahawai o Zareda. ");
INSERT INTO haw1868_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Mailaila aku lakou i hele ai, a hoomoana iho la ma hela aoao o Arenona, ma ka waonahele e hele mai ana mailoko mai o na palena o ka Amora; no ka mea, o Arenona oia ka palena o Moaba, mawaena o Moaba a me ka Amora. ");
INSERT INTO haw1868_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Nolaila, ua olelo ia maloko o ka buke o na kaua a Iehova, ma Vaheba ma Supa, a ma na kahawai o Arenona, ");
INSERT INTO haw1868_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","A ma ke kahe ana o na kahawai, ka mea hele ma ka noho ana o Ara, a moe iho ma ka palena o Moaba. ");
INSERT INTO haw1868_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Mailaila aku lakou a Beera; oia ka punawai kahi a Iehova i olelo mai ai ia Mose, E hoakoakoa i na kanaka, a e haawi aku no wau i wai no lakou. ");
INSERT INTO haw1868_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Alaila mele aku la ka Iseraela i keia mele, E huahuai mai, e ka punawai; E mele aku oukou ia ia: ");
INSERT INTO haw1868_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","O na luna ka i kohi iho i ka punawai, O na'lii o na kanaka i eli iho ia, Mamuli o ka Lunakanawai, me na kookoo o lakou. A mai ka waonahele aku lakou a Matana; ");
INSERT INTO haw1868_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","A mai Matana aku a Nahaliela; a mai Nahaliela aku a Bamota: ");
INSERT INTO haw1868_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","A mai Bamota aku lakou a i ke awawa ma ke kula o Moaba, malalo o ka puu o Pisega, ma ka aoao e huli ana i ka waonahele. ");
INSERT INTO haw1868_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Hoouna aku la ka Iseraela i na elele io Sihona la ke alii o ka Amora, i aku la, ");
INSERT INTO haw1868_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","E ae mai oe e hele aku wau mawaena o kou aina: aole makou e kipa ma na mahinaai, aole hoi ma na pawaina: aole makou e inu i ka wai o ka punawai; e hele aku no makou ma ke alanui o ke alii, a hala aku la makou mai kou mau palena aku. ");
INSERT INTO haw1868_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Aole no i ae mai o Sihona e hele aku ka Iseraela mawaena o kona mau palena: aku, hoakoakoa ae la o Sihona i kona poe kanaka a pau, a hele aku la iloko o ka waonahele e ku e i ka Iseraela: a hele mai la ia i Iahaza, a kaua mai la i ka Iseraela. ");
INSERT INTO haw1868_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Luku aku la ka Iseraela la ia i ka pahikaua, a komo aku la i kona aina mai Arenona a Iaboka, a hiki i na mamo a Amona: no ka mea, ua paa ka palena o na mamo a Amona. ");
INSERT INTO haw1868_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Lawe pio ae la ka Iseraela i keia mau kulanakauhale a pau: a noho iho la ka Iseraela ma na kulanakauhale a pau o ka Amora, i Hesebona, a i na kauhale a pau o ia wahi. ");
INSERT INTO haw1868_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","No ka mea, o Hesebona ke kulanakauhale o Sihona ke alii o ka Amora, nana i kaua aku mamua i ke alii o Moaba, a lawe ae la i kona aina a pau mai kona lima aku, a hiki i Arenona. ");
INSERT INTO haw1868_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","No ia mea, i mai la na hakumele, E hele oukou iloko o Hesebona, e hana hou ia Ke kulanakauhale o Sihona e hookumuia: ");
INSERT INTO haw1868_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","No ka mea, mai Hesebona i hele aku ai ke ahi, He lapalapa ahi ma ke kulanakauhale o Sihona aku: Ua hoopau oia ia Ara o Moaba, A me na haku o na wahi kiekie o Arenona. ");
INSERT INTO haw1868_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Auwe oe, e Moaba! ua make no oe! E na kanaka o Kemosa! Ua haawi aku ia i kana mau keikikane i pakele, A me kana mau kaikamahine, i poe pio No ke alii o ka Amora, no Sihona. ");
INSERT INTO haw1868_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Ua pana pua aku makou ia lakou; Ua lukuia o Hesebona a hiki i Dibona, Ua hooneoneo makou a hiki aku i Nopa, A hiki hoi i Medeba. ");
INSERT INTO haw1868_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","A noho iho la ka Iseraela ma ka aina o ka Amora. ");
INSERT INTO haw1868_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","A hoouna aku la o Mose e makaikai ia Iaazera, a komo lakou i na kulanakauhale o ia wahi, a hookuke aku la i ka Amora malaila. ");
INSERT INTO haw1868_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Haliu ae la lakou, a pii aku la ma ke alanui o Basana: a hele mai la o Oga ke alii o Basana e ku e mai ia lakou, oia a me kona poe kanaka a pau, i ke kaua ma Ederei. ");
INSERT INTO haw1868_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Olelo mai la o Iehova ia Mose, Mai makau oe ia ia; no ka mea, ua haawi aku no wau ia ia iloko o kou lima, me kona kanaka a pau, a me kona aina: a e hana aku oe ia ia me kau i hana aku ai ia Sihona ke alii o ka Amora i noho ma Hesebona. ");
INSERT INTO haw1868_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","A luku aku la lakou ia ia, me kana mau keikikane, a me kona poe kanaka a pau, aole i koe kekahi e ola ana nona: a komo aku la lakou i kona aina. ");
INSERT INTO haw1868_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","HELE aku la na mamo a Iseraela, a hoomoana iho la ma na papu o Moaba, ma keia aoao o Ioredane e ku pono ana i Ieriko. ");
INSERT INTO haw1868_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","A ike aku la o Balaka ke keiki a Zipora i ka mea a pau a ka Iseraela i hana aku ai i ka Amora. ");
INSERT INTO haw1868_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Makau loa iho la o Moaba i ua poe kanaka la, no ka mea, he lehulehu lakou: a ua pilikia o Moaba no na mamo a Iseraela. ");
INSERT INTO haw1868_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Olelo aku la o Moaba i na lunakahiko o Midiana, E pau auanei na mea a pau o kakou i ka paluia e keia poe kanaka, e like me ka palu ana o ka bipi i ka weuweu o ke kula. A o Balaka ke keiki a Zipora ke alii o ka Moaba ia manawa. ");
INSERT INTO haw1868_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","No ia mea, hoouna aku la ia i mau elele io Balaama la ke keiki a Beora i Petora ma ka muliwai o ka aina o na keiki o kona poe kanaka, e kii ia ia, i aku la, Eia hoi, he poe kanaka i hele mai nei mai Aigupita mai: aia hoi, ke uhi paapu nei lakou i ka aina, a e noho ku pono ana lakou io'u nei. ");
INSERT INTO haw1868_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Nolaila la, ke noi aku nei au ia oe, e hele mai oe e olelo hoino aku no'u i keia poe kanaka; no ka mea, ua oi aku ko lakou ikaika i ko'u: malia e loaa paha ia'u ka ikaika e hahau aku ai makou ia lakou, a e kipaku au ia lakou mawaho o ka aina: no ka mea, ua ike no wau, o kau e hoomaikai aku ai, oia ke hoopomaikaiia; a o kau e olelo hoino aku ai, oia ke hoopoinoia. ");
INSERT INTO haw1868_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Hele aku la na lunakahiko o Moaba me na lunakahiko o Midiana, me ka uku no ka anaana ana: a hiki aku la lakou io Balaama la, a hai aku la ia ia i ka olelo a Balaka. ");
INSERT INTO haw1868_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","I mai la oia ia lakou, e moe oukou maanei i keia po, a e hai aku au ia oukou e like me ka Iehova e olelo mai ai ia'u; a noho iho la na luna o Moaba me Balaama. ");
INSERT INTO haw1868_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Hele mai la ke Akua io Balaama la, ninau mai la, Owai keia poe kanaka me oe? ");
INSERT INTO haw1868_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","I aku la o Balaama i ke Akua, O Balaka ke keiki a Zipora, ke alii o Moaba, ua hoouna mai io'u nei, i ka i ana, ");
INSERT INTO haw1868_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","Aia hoi he poe kanaka i hele mai nei mai Aigupita mai, uhi paapu lakou i ka aina: e hele mai hoi oe e olelo hoino aku ia lakou no'u; malia paha e lanakila au i ke kaua ana aku ia lakou, a e kipaku aku ia lakou. ");
INSERT INTO haw1868_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Olelo mai la ke Akua ia Balaama, Mai hele aku oe me lakou: mai olelo hoino aku i ua poe kanaka la; no ka mea, ua hoomaikaiia lakou. ");
INSERT INTO haw1868_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Ala ae la o Balaama i kakahiaka, i aku la i na luna o Balaka, E hoi oukou i ko oukou aina; no ka mea, aole i ae mai o Iehova ia'u e hele me oukou. ");
INSERT INTO haw1868_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Ku ae la na luna o Moaba, a hoi aku la io Balaka la, i aku la, Ua hoole mai o Balaama aole e hele mai me makou. ");
INSERT INTO haw1868_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Hoouna hou aku la o Balaka i na luna, he nui aku, a he oi hoi ko lakou koikoi i ko kela poe. ");
INSERT INTO haw1868_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Hele aku la lakou io Balaama la, i aku ia ia, Penei ka Balaka ka ke keiki a Zipora e olelo mai nei, Ke noi aku nei au ia oe, i keakea ole kekahi mea ia oe i ka hele ana mai io'u nei: ");
INSERT INTO haw1868_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","No ka mea, e hoohanohano loa aku au ia oe, a e hana aku au i na mea a pau au e olelo mai ai ia'u: ke noi aku nei au ia oe, e hele mai hoi, e olelo hoino aku no'u i keia poe kanaka. ");
INSERT INTO haw1868_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Olelo mai la o Balaama, i mai la i na kauwa a Balaka, Ina e haawi mai o Balaka ia'u i ke kala a me ke gula a piha kona hale, aole e hiki ia'u ke hoohala i ka olelo a Iehova a ko'u Akua, i ka hoemi iho, i ka oi aku paha. ");
INSERT INTO haw1868_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","No ia mea, ke noi aku nei au ia oukou, e noho hoi oukou ia nei i keia po, i ike au i ka mea a Iehova e olelo hou mai ai ia'u. ");
INSERT INTO haw1868_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Hele mai la ke Akua io Balaama la ia po iho, i mai la ia ia, Ina paha e hele mai ua mau kanaka la e hea mai ia oe, e ala ae oe e hele pu me lakou; aka, o ka olelo a'u e hai aku ai ia oe, oia kau e hana'i. ");
INSERT INTO haw1868_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Ala ae la o Balaama i kakahiaka, hoee aku la i ka noho maluna o kona hoki, a hele pu aku la me na luna o Moaba. ");
INSERT INTO haw1868_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Ua hoaia ka inaina o ke Akua, no kona hele ana; a ku mai la ka anela o Iehova ma ke alanui, i mea ku e mai ia ia. E holo ana ia maluna o kona hoki, elua ana mau kauwa me ia. ");
INSERT INTO haw1868_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Ike aku la ka hoki i ka anela o Iehova e ku ana ma ke ala, a me kana pahikana i unuhiia ma kona lima; huli ae la ka hoki mawaho o ke ala, a hele aku la ma ke kula; a hahau iho la o Balaama i ka hoki, e hoohuli hou ia ia ma ke ala. ");
INSERT INTO haw1868_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Aka, ku ae la ka anela o Iehova ma ke ala o na pawaina, he papohaku ma kela aoao, a he papohaku ma keia aoao. ");
INSERT INTO haw1868_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","A ike aku la ka hoki i ka anela o Iehova, pipika ae la ia ma ka papohaku, a pepe iho la ka wawae o Balaama i ka papohaku; a hahau hou iho la kela ia ia. ");
INSERT INTO haw1868_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","A hele hou aku la ka anela o Iehova, a ku iho la ma kahi haiki, aole wahi e huli ae ma ka akau, aole hoi ma ka hema. ");
INSERT INTO haw1868_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","A ike aku la ka hoki i ka anela o Iehova, hina iho la ia malalo o Balaama; huhu iho la o Balaama, a hahau iho la ia i ka hoki me ke kookoo. ");
INSERT INTO haw1868_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Wehe ae la o Iehova i ka waha o ka hoki, a i mai la ia ia Balaama, Heaha ka'u i hana aku ai ia oe, i pakolu ai kau hahau ana mai ia'u? ");
INSERT INTO haw1868_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","I aku la o Balaama i ka hoki, No ka mea, na hana ino mai oe ia'u; ina he pahikana ma ko'u lima, ina ua make oe ia'u. ");
INSERT INTO haw1868_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Ninau mai la ka hoki ia Balaama, Aole anei wau o kou hoki, ka mea au i holoholo ai, mai ka manawa i lilo ai au nou, a hiki i neia la? Pela no anei ka'u i hana aku ai ia oe mamua? I aku la kela, Aole. ");
INSERT INTO haw1868_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Alaila hookaakaa ae la o Iehova i na maka o Balaama, a ike aku la ia i ka anela o Iehova e ku ana ma ke alanui me ka pahikaua i unuhiia ma kona lima: kulou iho la ia, a moe iho la ilalo ke alo. ");
INSERT INTO haw1868_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","I mai la ka anela o Iehova ia ia, No ke aha la oe i hahau ai i kou hoki, ekolu hahau ana? Aia hoi, i hele mai nei au e ku e ia oe; no ka mea, ua kekee kou aoao imua o'u. ");
INSERT INTO haw1868_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","A ike mai la ka hoki ia'u, a huli ae la mai o'u aku la, ekolu huli ana: he oiaio, ina aole ia i huli ae, mai o'u aku nei, ina ua make oe ia'u, a ola kela. ");
INSERT INTO haw1868_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","I aku la o Balaama i ka anela o Iehova, Ua hewa wau; aole au i ike ua ku e mai oe ia'u ma ke alanui: ano hoi, a i hewa ia mea ia oe, e hoi hou aku no wau. ");
INSERT INTO haw1868_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","I mai la ka anela o Iehova ia Balaama, E hele pu oe me ia mau kanaka; aka, o ka olelo a'u e hai aku ai ia oe, oia wale no kau e olelo aku ai. A hele aku la o Balaama me na luna o Balaka. ");
INSERT INTO haw1868_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","A lohe ae la o Balaka, ua hiki mai o Balaama, hele aku kela e halawai me ia ma kekahi kulanakauhale o Moaba ma ka palena o Arenona, oia no ka palenamamao loa. ");
INSERT INTO haw1868_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","I mai la o Balaka ia Balaama, Aole anei au i hoouna ikaika aku iou la, e kii ia oe? Heaha hoi kau i hele ole mai ai io'u nei? Aole anei e hiki ia'u ke hoohanohano ia oe? ");
INSERT INTO haw1868_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","I aku la o Balaama ia Balaka, Eia hoi, ua hiki mai nei au iou la: ia'u no anei kekahi pono iki ke hai aku ia oe i kekahi mea? O ka olelo a ke Akua e waiho mai ai iloko o ko'u waha, oia ka'u e olelo aku ai. ");
INSERT INTO haw1868_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Hele pu ae la o Balaama me Balaka, a hiki ae la laua i Kiriatahuzota. ");
INSERT INTO haw1868_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Mohai aku la o Balaka i na bipi a me na hipa, a hoouna aku la io Balaama la, a i na luna me ia. ");
INSERT INTO haw1868_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","A kakahiaka ae la, kono aku la o Balaka ia Balaama, a kai aku la ia ia i kahi kiekie o Baala, i ike aku ai oia ma ia wahi i ka poe kanaka a pau. ");
INSERT INTO haw1868_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","I AKU ia o Balaama ia Balaka, E hana oe no'u maanei i mau kuahu ehiku; e hoomakaukau hoi oe no'u i na bipikane ehiku a me na hipakane ehiku. ");
INSERT INTO haw1868_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Hana iho la o Balaka e like me ka Balaama i olelo aku ai; a mohai aku la o Balaka laua o Balaama ma kela kuahu ma keia kuahu i ka bipikane hookahi a me ka hipakane hookahi. ");
INSERT INTO haw1868_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","I aku la o Balaama ia Balaka, E ku iho oe ma kau mohaikuni, a e hele aku wau; malia paha e hele mai no o Iehova e halawai mo au: a o ka mea ana e hoike mai ai ia'u, oia ka'u o hai aku ai ia oe. A hele aku la ia i kahi kiekie. ");
INSERT INTO haw1868_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","A halawai mai la ke Akua me Balaama; i aku la hoi oia ia ia, Ua hoomakaukau no wau i na kuahu ehiku, ua mohai aku hoi au i ka bipikane a me ka hipakane maluna o kela kuahu o keia kuahu. ");
INSERT INTO haw1868_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Waiho mai la o Iehova i wahi olelo ma ka waha o Balaama, i mai la, O hoi oe io Balaka la, a penei kau e olelo aku ai. ");
INSERT INTO haw1868_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","A hoi hou ae la ia io na la: aia hoi, e ku ana oia ma kana mohaikuni, oia a me na luna a pau o Moaba. ");
INSERT INTO haw1868_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Hapai ae la ia i kana olelonane, i aku la, Na Balaka ke alii o Moaba au i lawe mai nei Mai Arama mai, mai na mauna o ka hikina; E hele mai, e hoino no'u i ka Iakoba, E hele mai, e hoohewa aku i ka Iseraela. ");
INSERT INTO haw1868_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Pehea la au e hoino ai i ka ke Akua i hoino ole ai? Pehea la hoi au e hoohewa ai i ka Iehova i hoohewa ole ai? ");
INSERT INTO haw1868_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","No ka mea, maluna o na pali ka'u e ike aku nei ia ia; Maluna hoi o na puu a'u e nana aku nei ia ia; Aia hoi, e noho kaawale ia poe kanaka, Aole hoi e huiia'ku me na lahuikanaka. ");
INSERT INTO haw1868_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Owai la e hiki ke helu i na hunalepo o Iakoba, A me ka lehulehu o ka hapaha o ka Iseraela? E ake au e make i ka make ana o ka mea pono, I like hoi kuu hope me kona! ");
INSERT INTO haw1868_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","I mai la o Balaka ia Balaama, Heaha keia au i hana mai ai ia'u? Kii aku la no wau ia oe o olelo hoino i kuu poe enemi; aia hoi, ua hoomaikai wale aku oe ia lakou. ");
INSERT INTO haw1868_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Olelo aku la kela, i aku la, Aole anei au e hoomanao e olelo aku i ka mea a Iehova i waiho mai ai iloko o kuu waha? ");
INSERT INTO haw1868_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","I mai la o Balaka ia ia, Ke noi aku nei au ia oe, e hele pu kaua ma kahi e, malaila e ike aku ai oe ia lakou: e ike oe i kela aoao wale no, aole no e ike ia lakou a pau; a malaila oe e hoino ai ia lakou no'u. ");
INSERT INTO haw1868_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Kai aku la kela ia ia i kahi papu o Zopima, maluna pono o Pisega: hana iho la ia i na kuahu ehiku, a mohai aku la i ka bipikane a me ka hipakane ma kela kuahu a ma keia kuahu. ");
INSERT INTO haw1868_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","I aku la ia ia Balaka, E ku oe maanei ma kau mohaikuni, a halawai aku wau me Iehova ma o. ");
INSERT INTO haw1868_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Halawai mai la o Iehova me Balaama, waiho mai la i olelo ma kona waha, i mai la, E hoi hon aku oe io Balaka la, e i aku oe penei. ");
INSERT INTO haw1868_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","A hiki aku la ia io na la, aia hoi, ku iho la ia ma kana mohaikuni, a me ia pu na luna o Moaba; ninau mai la o Balaka ia ia, Heaha ka Iehova i olelo mai ai? ");
INSERT INTO haw1868_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Hai aku la ia i kana olelonane, i aku la, E ku ae oe iluna, e Balaka, e hoolohe mai; E maliu mai oe ia'u, e ke keiki a Zipora, ");
INSERT INTO haw1868_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Aole ke Akua he kanaka, i hoopunipuni mai ai ia; Aole hoi ia he keiki a ke kanaka i mihi ia: Ua i mai no ia, aole anei ia e hana mai no hoi? Ua olelo mai no oia, aole anei ia e hooko? ");
INSERT INTO haw1868_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Aia hoi, ua loaa ia'u ka olelo hoomaikai aku; Ua hoomaikai no oia, aole e hiki ia'u ke hoololi ae. ");
INSERT INTO haw1868_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Aole ia i ike i ka hewa iloko o ka Iakoba, Aole hoi oia i ike i ke kekee iloko o ka Iseraela; Me ia no o Iehova o kona Akua, Iwaena hoi o lakou ka hooho alii. ");
INSERT INTO haw1868_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Na ke Akua lakou i lawe mai, mai Aigupita mai: Ia ia no ka ikaika me he reema la. ");
INSERT INTO haw1868_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","He oiaio, aole no he kilokilo aku i ka Iakoba, Aole hoi he anaana aku i ka Iseraela: Ma ia hope e oleloia mai no ka Iakoba, a no ka Iseraela, Kupaianaha ka hana ana a ke Akua! ");
INSERT INTO haw1868_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Aia hoi, e ala'e keia poe kanaka me he lionawahine la. E ku ae hoi ia e like me ka lionakane; Aole ia e moe hou, a ai iho ia i ke pio, A e inu hoi i ke koko o ka mea i pepehiia. ");
INSERT INTO haw1868_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","I mai la o Balaka ia ia, Mai hoino iki aku ia lakou, aole hoi e hoomaikai iki aku. ");
INSERT INTO haw1868_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Olelo aku la o Balaama ia Balaka, i aku la, Aole anei au i i aku ia oe, O ka mea a pau a Iehova i olelo mai ai ia'u, oia ka'u e hana i? ");
INSERT INTO haw1868_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","I mai la o Balaka ia Balaama, Ke noi aku nei au ia oe, e hele mai, a e kai aku au ia oe i kahi e; malia paha e oluolu ke Akua i hoino aku ai oe ia lakou malaila. ");
INSERT INTO haw1868_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Kai aku la o Balaka ia Balaama maluna pono o Peora, e nana aku ana i Iesimona. ");
INSERT INTO haw1868_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","I aku la o Balaama ia Balaka, E hana oe no'u i ehiku mau kuahu maanei, a e hoomakaukau no'u maanei i ehiku mau bipikane a me na hipakane i ehiku. ");
INSERT INTO haw1868_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Hana iho la o Balaka e like me ka Balaama i olelo ai, a mohai aku la i ka bipikane a me ka hipakane maluna o kela kuahu o keia kuahu. ");
INSERT INTO haw1868_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","A IKE iho la o Balaama, ua lealea o Iehova i ka hoomaikai aku i ka Iseraela, aole ia i hele hou aku e like mamua e imi i na kilokilo ana; aka, haliu ae la ia i kona maka ma ka waonahele. ");
INSERT INTO haw1868_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Alawa ae la na maka o Balaama iluna, ike ae la i ka Iseraela e hoomoana ana ma ko lakou mau ohana; a kau mai la ka Uhane o ke Akua maluna ona. ");
INSERT INTO haw1868_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","Hapai ae la ia i kana olelonane, i aku la, O ka wanana a Balaama a ke keiki a Beora, O ka wanana a ke kanaka i hookaakaaia kona mau maka: ");
INSERT INTO haw1868_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","Ka wanana a ka mea i lohe i na olelo a ke Akua, A ka mea i ike i ka Mea mana ma ka hihio; E moe ana ilalo, a e kaakaa ana kona mau maka: ");
INSERT INTO haw1868_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Nani ka maikai o na halelole ou, e Iakoba! O kou mau halelewa hoi, e Iseraela! ");
INSERT INTO haw1868_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","E like me na awawa ko lakou palahalaha ana, E like hoi me na mahinaai ma kapa muliwai, Me na laau aloe hoi a Iehova i kanu ai, A me na laau kedera ma kapa o na wai. ");
INSERT INTO haw1868_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","E kahe ana ka wai mailoko ae o kona mau bakeke, A ma na wai he nui kona hua kanu; E kiekie ae hoi kona alii maluna o Agaga, A e hookiekieia'e kona aupuni. ");
INSERT INTO haw1868_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Na ke Akua ia i kai mai nei, mai Aigupita mai; Ia ia hoi ka ikaika me he reema la; E ai iho oia i na lahuikanaka i kona poe enemi, A e uhai ia i ko lakou mau iwi, E houia hoi lakou i kana mau pua. ");
INSERT INTO haw1868_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Ua kukuli iho ia, ua moe iho me he lionakane la, A me ka lionawahine; nawai la ia e hoala'e? E pomaikai ka mea hoomaikai ia oe, A e poino ka mea hoino aku ia oe. ");
INSERT INTO haw1868_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Ua hoaia ka inaina o Balaka ia Balaama, a pai pu na lima ona: i mai la o Balaka ia Balaama, Ua kii aku no wau ia oe no ka hoino aku i kuu poe enemi; aia hoi, eia ke kolu o kou hoomaikai wale ana aku. ");
INSERT INTO haw1868_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Nolaila, e holo aku oe i kou wahi: i manao iho la au e hoohanohano loa aku ia oe; aka hoi, o Iehova ka i keakea mai ia oe i loaa ole ai ka hanohano. ");
INSERT INTO haw1868_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Olelo mai la o Balaama ia Balaka, Aole anei au i olelo aku i ka poe elele au i hoouna at io'u la, i ka i ana aku, ");
INSERT INTO haw1868_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","Ina e haawi mai o Balaka i ko kala a me ke gula a piha kona hale, ina aole e hiki ia'u ke hoohala i ka olelo a Iehova, e hana i ka maikai, aole hoi i ka hewa ma kuu manao iho: o ka Iehova e olelo mai ai, oia ka'u e hai aku ai? ");
INSERT INTO haw1868_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Ano hoi, ke hoi aku nei au i ko'u poe kanaka: ea, e hai e aku no au ia oe i ka mea a keia poe kanaka e hana mai ai i kou poe kanaka i na la mahope. ");
INSERT INTO haw1868_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Hapai ae la ia i kana olelonane, i aku la, O ka wanana a Balaama ke keiki a Beora, Ka wanana a ke kanaka i hookaakaaia'e kona maka; ");
INSERT INTO haw1868_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","Ka wanana a ka mea i lohe i ka olelo a ke Akua, A ka mea ike i ka mea ikea o ka Mea kiekie, A ka mea nana i ka mea ikea o ka Mea mana loa, E moe iho ana, a e kaakaa ana kona mau maka: ");
INSERT INTO haw1868_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","E ike auanei au ia ia, aole hoi ano, E nana auanei au ia ia, aole hoi e kokoke: E puka mai auanei he Hoku mai o Iakoba mai, E ku mai ana no hoi he Kookoo mai o Iseraela mai; A e luku aku no ia i na kihi o Moaba, A e pepehi iho ia i na keiki hoohaunaele a pau. ");
INSERT INTO haw1868_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","E lilo o Edoma i wahi E noho ai, A e lilo o Seira i wahi e noho ai no kona poe enemi: A e hana ikaika no o ka Iseraela. ");
INSERT INTO haw1868_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Na Iakoba e puka mai auanei ka mea e alii ana, A e luku iho oia i ke koena o ke kulanakanhale. ");
INSERT INTO haw1868_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Nana aku la hoi oia i ka Ameleka, hai mai la ia i kana olelonane, i mai la, O Ameleka, ke pookela o na lahuikanaka, Aka o kona hope, e make mau loa no oia. ");
INSERT INTO haw1868_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Nana aku la hoi ia i ka Keni, hapai ae la ia i kana olelonane, i mai la, Ua paa kou wahi i noho ai, Ua kau aku oe i kou punana maluna o ka pohaku: ");
INSERT INTO haw1868_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Aka, e laweia'ku ka Keni, ahea la E lawe pio aku o Asuria ia oe? ");
INSERT INTO haw1868_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Hai aku la ia i kana olelonane, i aku la, Auwe! owai la uanei ke ola i ka wa e hana mai ai ke Akua i keia? ");
INSERT INTO haw1868_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Mai kauwahi mai o Kitima mai, na moku, A e hoopilikia lakou i ko Asuria, A e hoopilikia hoi i ka Hebera, A e luku loa ia'ku oia. ");
INSERT INTO haw1868_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Ku ae la o Balaama, hele aku la ia, a hoi aku la i kona wahi; a hele aku la hoi o Balaka i kona aoao. ");
INSERT INTO haw1868_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","NOHO iho la ka Iseraela ma Sitima: a hoomaka iho la, na kanaka e moe kolohe me na kaikamahine a ka Moaba. ");
INSERT INTO haw1868_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Koi mai la lakou i na kanaka e hele aku i na ahaaina hoomana a na akua o lakou: ai iho la na kanaka, a kulou iho la i na akua o lakou. ");
INSERT INTO haw1868_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Hui pu aku la ka Iseraela me Baalapeora: a ua hoaia mai la ka inaina o Iehova i ka Iseraela. ");
INSERT INTO haw1868_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Olelo mai la o Iehova ia Mose, E lawe i na luna a pau o kanaka, e kau aku ia lakou imua o Iehova ma ka la, i hoohuliia'ku ai ka inaina nui o Iehova mai ka Iseraela aku. ");
INSERT INTO haw1868_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Olelo aku la o Mose i na lunakanawai o ka Iseraela, E pepehi oukou a pau i na kanaka o oukou i hui pu ia'ku me Baalapeora. ");
INSERT INTO haw1868_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Aia hoi, hele mai kekahi mamo a Iseraela, a lawe mai la i kekahi wahine no Midiana i na hoahanau ona, imua o na maka o Mose, a imua o na maka o ke anaina kanaka a pau o na mamo a Iseraela, e uwe ana lakou ma ka puka o ka halelewa o ke anaina. ");
INSERT INTO haw1868_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","A ike aku la o Pinehasa ke keiki a Eleazara ke keiki a Aarona ke kahuna, ku ae la ia mawaena o ke anaina kanaka, a lawe ae la ia i ka ihe ma kona lima; ");
INSERT INTO haw1868_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","Hahai aku la ia mamuli o ua kanaka la o ka Iseraela maloko o ka halelewa, a hou iho la ia laua a elua, i ke kanaka o ka Iseraela a me ka wahine ma kona opu. Pela no i paleia'i ke. ahulau mai na mamo a Iseraela aku. ");
INSERT INTO haw1868_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","A o ka poe i make i ke ahulau, he iwakaluakumamaha tausani lakou. ");
INSERT INTO haw1868_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Olelo mai la o Iehova ia Mose, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","O Pinehasa ke keiki a Eleazara, ke keiki a Aarona ke kahuna, ua hoohuli ae ia i kuu inaina mai na mamo a Iseraela aku, no kona lili ana no'u iwaena o lakou; i hoopau ole ai au i na mamo a Iseraela i kuu lili ana. ");
INSERT INTO haw1868_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Nolaila, e i aku oe, Aia hoi, ke haawi aku nei au i kuu berita nona e malu ai. ");
INSERT INTO haw1868_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Nona no ia, a no kana poe mamo mahope ona, o ka berita o ka oihana kahuna mau loa; no ka mea, ua lili oia no kona Akua, a ua hookalahala oia no na mamo a Iseraela. ");
INSERT INTO haw1868_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","O ka inoa o ke kanaka Iseraela i pepehiia, i pepehi pu ia me ka wahine o Midiana, oia o Zimeri ke keiki a Salu, he luna o ka ohana kupuna no ka Simeona. ");
INSERT INTO haw1868_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","A o ka inoa o ka wahine no Midiana i pepehiia, oia o Kosebi, ke kaikamahine a Zura, he luna ia o kekahi poe kanaka, no ka ohana alii ma Midiana. ");
INSERT INTO haw1868_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Olelo mai la o Iehova ia Mose, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","E kaua aku oe i ko Midiana, a e pepehi ia lakou: ");
INSERT INTO haw1868_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","No ka mea, ke hoopilikia mai nei lakou ia oukou, me ka hoowalewale ana a lakou i hoowalewale mai ai ia oukou ma ka mea o Peora, a ma ka mea o Kosebi ke kaikamahine a kekahi alii o Midiana, ko lakou kaikuwahine, o ka mea i pepehiia i ka la o ke ahulau no Peora. ");
INSERT INTO haw1868_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","MAHOPE mai o ke ahulau, olelo mai la o Iehova ia Mose a me Eleazara ke keiki a Aarona ke kahuna, i mai la, ");
INSERT INTO haw1868_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","E helu olua i ke anaina kanaka a pau o na mamo a Iseraela, i na mea o na makahiki he iwakalua a keu aku, ma ka ohana o ko lakou kupuna, i na mea a pau o ka Iseraela e hiki ke hele i ke kaua. ");
INSERT INTO haw1868_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Olelo aku la o Mose laua o Eleazara ke kahuna ia lakou ma na papu o Moaba, ma Ioredane e ku pono ana i Ieriko, i aku la, ");
INSERT INTO haw1868_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","E helu oukou i na kanaka, o na makahiki he iwakalua a keu aku, e like me ka Iehova i kauoha mai ai ia Mose a i na mamo a Iseraela i hele mai mailoko mai o ka aina o Aigupita. ");
INSERT INTO haw1868_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","O Reubena ka makahiapo a Iseraela: o na keiki a Reubena, o Hanoka, nana ka ohana o ka Hanoka: na Palu ka ohana o ka Palu: ");
INSERT INTO haw1868_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","Na Heserona ka ohana o ka Heserona: na Karemi ka ohana o ka Karemi. ");
INSERT INTO haw1868_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Oia na ohana o ka Reubena: a o ka poe o lakou i heluia, he kanahakumamakolu na tausani, ehiku haneri a me kanakolu. ");
INSERT INTO haw1868_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","O na keiki a Palu, o Eliaba. ");
INSERT INTO haw1868_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","A o na keiki a Eliaba, o Nemuela, o Datana a me Abirama: oia ua Datana a me Abirama la, na mea i kaulana iloko o ke anaina kanaka, i na mea i ku e ia Mose a me Aarona iwaena o ko Kora poe, i ka wa a lakou i ku e aku ai ia Iehova: ");
INSERT INTO haw1868_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","A hamama ae la ka honua i kona waha, a ale iho la ia lakou a me Kora, i ka manawa i make ai ua poe la, a i ka wa i ai mai ai ke ahi i elua haneri kanaka a me kanalima: a lilo lakou i hoailona. ");
INSERT INTO haw1868_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Aole nae i make na keiki a Kora. ");
INSERT INTO haw1868_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","O na keiki a Simeona ma ko lakou mau ohana: no Nemuela ka ohana o ka Nemuela: na Iamina ka ohana o ka Iamina: na Iakina ka ohana o ka Iakina: ");
INSERT INTO haw1868_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","Na Zera ka ohana o ka Zera: na Saula ka ohana o ka Saula. ");
INSERT INTO haw1868_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Oia na ohana o ka Simeona, he iwakaluakamamalua tausani, me na haneri keu elua. ");
INSERT INTO haw1868_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","O na keiki a Gada ma ko lakou mau ohana: na Zepora ka ohana o ka Zepora: na Hagi ka ohana o ka Hagi: na Suni ka ohana o ka Suni: ");
INSERT INTO haw1868_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","Na Ozeni ka ohana o ka Ozeni: na Eri ka ohana o ka Eri: ");
INSERT INTO haw1868_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","Na Aroda ka ohana o ka Aroda: na Areli ka ohana o ka Areli. ");
INSERT INTO haw1868_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Oia na ohana o na mamo a Gada, ma ka poe o lakou i heluia, he kanaha tausani a me na haneri elima. ");
INSERT INTO haw1868_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","O na keiki a Iuda, o Era a me Onana: a make iho la o Era laua o Onana ma ka aina o Kanaana. ");
INSERT INTO haw1868_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","A o na keiki a Iuda m