﻿USE sofia;
DROP TABLE IF EXISTS sofia.hav_vpl;
CREATE TABLE hav_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES hav_vpl WRITE;
INSERT INTO hav_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Waliha Teofiile, bantu banene bachihangaanire kuyandika emyaazi ya byooshi byagerere ahagarhi keerhu. ");
INSERT INTO hav_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Abayandikaga, babibalire nk'oku rhwabalirwaga n'abalibibwene ko gurhenga oku ntangiriro, banahinduka bakozi b'eChinwa cha Nnamahanga. ");
INSERT INTO hav_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Nchimala gushonda n'okubaza kw'eyi myaazi yooshi, byansimiisize naani nkubalire yo gurhenga oku ntangiriro ya yo. Bobunoola waliha Teofiile nkuyandikiire yo bwinjabwinja. ");
INSERT INTO hav_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Njirire ntyo y'omenya okuli kw'enyigirizo wayankiriire. ");
INSERT INTO hav_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Amango Heroode aliiri mwami w'eYudeeya, haliiri mudaahwa muguma oyirikwa Zakariya, muguma w'omu badaahwa b'echigusho cha Abiya. Mukaage aliiri muguma w'omu banyere ba Haruuni, ayirikwaga Luzabeeti. ");
INSERT INTO hav_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Oku bali babiri balikwaneene embere za Nnamahanga. Babaaga bakenga bwinja amarhegeko mooshi ma Nnaweerhu n'okujira nk'oku aderhere. ");
INSERT INTO hav_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Aliko, nta mwana baligwerhe, kwenge Luzabeeti aliiri ngumba na kandi eyi booshi babaaga bakola bashaaja. ");
INSERT INTO hav_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Lusiku luguma, Zakariya aliiri akola akaasi kaage k'obudaahwa embere za Nnamahanga, kwenge chaali gihe ch'echigusho chaage. ");
INSERT INTO hav_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Gukulikirana n'emicho y'obudaahwa, alondoolwa kuja omu Nju ya Nnaweerhu gusireeza obubaani. ");
INSERT INTO hav_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Amango Zakariya aliiri gusireeza obubaani, echigusho ch'abemeezi baliiri embuga omu masaala. ");
INSERT INTO hav_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Malahika wa Nnaweerhu amuhulukira, ayimanga emalyo w'entuuliro y'obubaani. ");
INSERT INTO hav_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zakariya abeere amubona, ashalama n'okuyuubaha bweneene. ");
INSERT INTO hav_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Malahika amubwira ntya: «Zakariya, orhayuubahaga, kwenge Nnamahanga ayunviirhe esaala lyawe, na mukaawe Luzabeeti akuburhira omwana w'obuzaana. Nj'omuhe eziino lya Yohaana. ");
INSERT INTO hav_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Nji wagwarha obusiime n'omwishingo. N'abantu banene nji bamogera okuburhwa kwage. ");
INSERT INTO hav_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Kwenge nj'aba mukulu embere za Nnaweerhu. Arhakanywa divaayi changwa amaavu makalihire. Gurhengera omu nda ya nyina, nj'aba ey'ayunjwizwe Muuka-Mutagatiifu. ");
INSERT INTO hav_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Nj'agalula aBaisraheeli banene emwa Nnaweerhu, Nnamahanga waabo. ");
INSERT INTO hav_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Nj'agenda embere za Nnaweerhu haguma n'omurhima n'obuhashe bwa Eliya, y'agalula haguma abaana n'abazeere baabo. Nj'ahindamula abagome yi bagwarha obwenge nk'abakwaneene. Ntyo, arheganyiziza Nnaweerhu olubaga lurheganyizwe bwinja.» ");
INSERT INTO hav_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakariya abaza malahika ntya: «Gichi nji charhuma naamenya oku ebyoola biri by'okuli? Nyoono nkola ndi mushaaja na mukaani akola mugeekulu.» ");
INSERT INTO hav_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Malahika amushubiza ntya: «Nyoono nye Gabriyeeri, nyimanga embere za Nnamahanga, ntumirwe gukubwira n'ogukubalira ogu mwazi mwinja. ");
INSERT INTO hav_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Aliko yunva, waaba nyamugama. Orhakaderha kugera olusiku eyi myaazi nji yaaba okwenge orhayemereere eyi myaazi yaani, nji yaaba omu mango maayo.» ");
INSERT INTO hav_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Mw'ebyo bishanji olo lubaga lwaliiri kulinga Zakariya lwasoomerwa okubona alegamire omu Nju ya Nnamahanga. ");
INSERT INTO hav_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Abeere ahuluka, arhachigalaga kuganiira nabo. Aliiri kubasimira n'ebishushanyo, ayoorha nyamugama. Baava bamenya oku abonekeerwe omu Nju ya Nnamahanga. ");
INSERT INTO hav_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Esiku za Zakariya z'ogukola zabeere zaahwa, agaluka emwage. ");
INSERT INTO hav_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Enyuma w'ezo siku, mukaage Luzabeeti aheeka obukule. Amala myeezi erhaano burhahuluka n'okuderha ntya: ");
INSERT INTO hav_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","«Tala oku Nnaweerhu anjiriire: asimiisizwe kunkuula ko ehyagendaga hyankoza eshoni ahagarhi k'abantu.» ");
INSERT INTO hav_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Obukule bwa Luzabeeti bwabeere buli bwa myeezi ndarhu, malahika Gabriyeeri arhumwa na Nnamahanga omu gishagala ch'eGalilaaya chiyirikwa Nazareeti. ");
INSERT INTO hav_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Amurhuma oku munyere orhazimenya abalume. Oyo munyere ali ashambaazizwe n'omurhabana oyirikwa Yozefu w'omu mulala gwa mwami Daawudi. Eziino ly'oyo munyere lyaliiri Mariya. ");
INSERT INTO hav_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Malahika abeere aja omu mwabo oyo munyere, amubwira ntya: «Nkulamwise, obe n'omwishingo, w'eyunjwire n'omugisho, bulaala Nnaweerhu ali haguma naawe.» ");
INSERT INTO hav_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mariya abeere ayunva echo chinwa, chamushalamya. Achiibaza bichi okulamuswa ntyo kuderhere. ");
INSERT INTO hav_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Malahika amubwira ntya: «Mariya, orhayuubahaga kwenge wabwene omugisho embere za Nnamahanga. ");
INSERT INTO hav_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Tala, waaba bukule. Waburha omuzaana n'eziino lyaage wamuyirika Yeesu. ");
INSERT INTO hav_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Nj'aba mukulu na nj'ahamagalwa Mugala wa Nnamahanga w'Elugulu Bweneene. Nnaweerhu Nnamahanga nj'amuha entebe y'obwami bw'eshekuliza Daawudi. ");
INSERT INTO hav_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Nj'arhegeka enju ya Yakobo esiku n'amango n'obwime bwage burhagahwa.» ");
INSERT INTO hav_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mariya abaza malahika ntya: «Gurhe ebiila nji byagalikana na nta mulume nyinji?» ");
INSERT INTO hav_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Malahika amushubiza ntya: «Muuka-Mutagatiifu nj'akuyandagalira ko n'obuhashe bwa Nnamahanga w'Elugulu Bweneene nji bwagushukulira n'egichuuchu chaabo. Chi nji charhuma n'omwana waaburhwa nj'aba mutagatiifu; nj'ahamagalwa Mugala wa Nnamahanga. ");
INSERT INTO hav_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Tala oku na Luzabeeti w'omu mulala gwawe, naye ali bukule b'omwana w'obuzaana omu bugeekulu bwage. Ola wayirikwaga ngumba, mwezi gwa ndarhu guno ali bukule. ");
INSERT INTO hav_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Kwenge ntaacho girhakagalika emwa Nnamahanga.» ");
INSERT INTO hav_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mariya ava aderha ntya: «Nyoono ndi muja wa Nnaweerhu, byooshi bimbeere nk'oku oderhere.» Ho n'aho malahika amuleka. ");
INSERT INTO hav_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Omu siku zakulikiraga, Mariya agenda jubaajuba, aja omu gishagala chiguma ch'emisozi omu gihugo ch'eYudeeya. ");
INSERT INTO hav_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Aja omu nju ya Zakariya, alamusa Luzabeeti. ");
INSERT INTO hav_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Luzabeeti abeere ayunva endamuso ya Mariya, omwana ashambagarha omu nda yaage. Luzabeeti ayunjuzwa Muuka-Mutagatiifu. ");
INSERT INTO hav_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Aliika omulenge munene elugulu n'okuderha ntya: «Ogishirwe omu bakazi booshi n'omwana oli omu nda yawe agishirwe. ");
INSERT INTO hav_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nyoono ndi nde okuderha mpu nyina wa Nnaweerhu andambagirire? ");
INSERT INTO hav_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Tala okw'amango nayunvaga omulenge g'okulamusa kwawe omu marhwi maani, omwana oli omu nda yaani amashambagarha n'obushagaluke bunene. ");
INSERT INTO hav_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ogishirwe kwenge wayemereere oku Nnaweerhu ajira eby'akulaganyaga.» ");
INSERT INTO hav_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mariya ava aderha ntya: «Omurhima gwani gukuuze Nnaweerhu. ");
INSERT INTO hav_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Na kandi gwayunjwire n'omwishingo elugulu wa Nnamahanga, Muchunguzi waani. ");
INSERT INTO hav_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Kwenge alolere n'olukogo obwirhondesi b'omuja waage. Gurhengera buno abantu ba ngasi gihe bagenda bampamagala mugishwa. ");
INSERT INTO hav_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Kwenge Nnamahanga Ogala Byooshi anjiriire ebintu binja binene. Eziino lyaage liri litagatiifu. ");
INSERT INTO hav_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ngasi mango ajira obubabale oku bamuyuubaha. ");
INSERT INTO hav_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Kugerera emisi y'okuboko kwage, ashandeeze abantu b'omurhima gw'erumerume. ");
INSERT INTO hav_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Akuulire abantu b'emisi oku ntebe zaabo z'obwami, n'okuzamuula abirhondesi. ");
INSERT INTO hav_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Abaliiri nzara abayunjwize n'ebikulo n'abachire abagalwire maboko moomu. ");
INSERT INTO hav_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Agwasize omukozi waage Israheeli: arhayibiriraga kuyeerekana obubabale bwage ");
INSERT INTO hav_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","nk'oku alaganyaga bashookuluza beerhu, Abrahaamu n'omulala gwage esiku n'amango.» ");
INSERT INTO hav_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mariya abeera haguma na Luzabeeti emyeezi yakagera kw'esharhu. Buzinda agaluka emwabo. ");
INSERT INTO hav_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Egihe ch'okuburha cha Luzabeeti chagera ho, aburha omwana w'obuzaana. ");
INSERT INTO hav_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Abatuuranyi na beene baabo Luzabeeti babeere bamenya oku Nnaweerhu amuyerekere obubabale bwage, basiima n'ogushagaluka haguma naye. ");
INSERT INTO hav_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Hagerere siku munaane aburhire, bayinja gukembuula omwana n'ogushonda kumuyirika eziino ly'eshe Zakariya. ");
INSERT INTO hav_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Aliko nyina aderha ntya: «Nanga, ayirikwe Yohaana.» ");
INSERT INTO hav_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Bamubwira ntya: «Oku ntaaye omu mulala gwenyu ogwerhe eri ziino!» ");
INSERT INTO hav_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Baabaza eshe bugamagama ntya: «Gurhe oshondere omwana waawe ayirikwage?» ");
INSERT INTO hav_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zakariya ahema bamuleerhere ehipaho, ayandika ko ntya: «Eziino lyaage ye Yohaana.» Booshi basoomerwa. ");
INSERT INTO hav_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ho n'aho obuunu bwage bwabumbuulwa n'olulimi lwage lwashwekuulwa, arhondera kuderha n'ogukuuza Nnamahanga. ");
INSERT INTO hav_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Abatuuranyi baage booshi bagwarhwa n'obuuba. Eyoola myaazi yooshi yalambagizwa omu misozi yooshi y'egihugo ch'eYudeeya. ");
INSERT INTO hav_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Booshi bayunvaga ogo mwazi baalema bakengeera n'oguchiibaza ntya omu mirhima yaabo: «Leero oyu mwana nj'aba muntu muchi?» Kwenge okuboko kwa Nnaweerhu kwaliiri haguma naye. ");
INSERT INTO hav_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Eshe Zakariya ayunjuzwa Muuka-Mutagatiifu, aleeba ntya: ");
INSERT INTO hav_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«Nnaweerhu agishwe, Nnamahanga w'olubaga lw'eIsraheeli, kwenge ayinjire gurhabaala n'oguchungula olubaga lwage. ");
INSERT INTO hav_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Arhulerheere omuchunguzi w'obuhashe gurhengera omu mulala g'omukozi waage Daawudi, ");
INSERT INTO hav_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","nk'oku anabiderhaga gurhengera miira kugerera abaleebi baage batagatiifu oku ");
INSERT INTO hav_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","arhushwekuula oku banzi beerhu n'ogurhukuula omu maboko m'abarhushomba booshi. ");
INSERT INTO hav_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ayerekeene obubabale bwage oku ba daarha n'okuyibuka egihango chaage gitagatiifu. ");
INSERT INTO hav_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Nnamahanga ajirire ntyo gukulikiza endahiro alahizizaga shookuluza weerhu Abrahaamu. ");
INSERT INTO hav_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Eyo ndahiro yali y'ogurhukuula omu maboko m'bashombanyi beerhu, yi rhumukolera buzira buuba, ");
INSERT INTO hav_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","yi rhuba batagatiifu n'abakwaneene omu meesho maage esiku zooshi z'akalamo keerhu. ");
INSERT INTO hav_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Naawe mwana waani, nji wahamagalwa muleebi wa Nnamahanga w' Elugulu Bweneene, kwenge nji wayinja nka murhumwa wa Nnaweerhu omu gurheganya enjira yaage, ");
INSERT INTO hav_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","yi nj'amenyesa olubaga lwage obuchunguke omu kubabalira ebyaaha byaabo, ");
INSERT INTO hav_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","kugerera obubabale bwa Nnamahanga weerhu. Kugerera obo bubabale, Nnamahanga arhukoleezeza ezuuba gurhengera elugulu, ");
INSERT INTO hav_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","y'akoleezeza abayikeere omu mwizimya n'omu gichuuchu ch'olufu, n'okuyerekeza amagulu meerhu omu njira y'omurhuula.» ");
INSERT INTO hav_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Oyo mwana agendekera gukula n'okugwarha omurhima guzibuhire. Abeera omu mpinga kugera amango m'oguchiyeerekana oku lubaga lw'eIsraheeli. ");
INSERT INTO hav_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Mw'amo mango omwami mukulu w'aBarooma oyirikwa Kayizaari Ogisitu aleerha erhegeko liderhere oku abantu booshi baganjwe omu bihugo byooshi by'obwami bwage. ");
INSERT INTO hav_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Olu luganjo lwambere lwaba amango Kureniyo aliiri murhegesi w'egihugo ch'eSuriya. ");
INSERT INTO hav_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Abantu booshi bagenda guchiyandikiisa ngasi muguma omu gishagala ch'akavukiiro kaage. ");
INSERT INTO hav_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yozefu naye arhenga omu gishagala ch'eNazareeti ch'omu Galilaaya. Achiyeerekeza omu gihugo ch'eYudeeya omu gishagala omwami Daawudi aburhwaga mo chiyirikwa Beteleheemu. Kwenge aliiri w'omu mulala gwa Daawudi. ");
INSERT INTO hav_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Aja yo guchiyandikiisa haguma na Mariya mushambaaza waage. Na Mariya ey'ali bukule. ");
INSERT INTO hav_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Oku bali eBeteleheemu, olusiku lwage l'okuburha lwagera ho. ");
INSERT INTO hav_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Aburha omugala w'efula. Amuyambisa engobi, amulyaamiza omu hikenzi hy'okuliisiza mo ebirhungano, kwenge nta hantu haalichiri ho omu nju y'okuyankirira abahiisi. ");
INSERT INTO hav_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Mw'echo gihugo mwaliiri abangere bagendaga balaala balanga obuso bwabo omu mashwa. ");
INSERT INTO hav_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Malahika wa Nnaweerhu ava ababonekera. Obulangashane bwa Nnaweerhu bwabamolekera. Bayuubaha bweneene. ");
INSERT INTO hav_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Aliko malahika ababwira ntya: «Murhayuubahaga, kwenge mbalerheere oMwazi Mwinja, gwashagalusa bweneene abantu booshi. ");
INSERT INTO hav_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Omu budufu bwa zeene, oMuchunguzi wenyu aburhirwe omu gishagala cha Daawudi: ye Krisitu, Nnaweerhu. ");
INSERT INTO hav_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","N'echimenyeeso cheechi: mwashimaana enjolyaana eyambiiswe engobi, ey'elyamiizwe omu hikenzi hy'okuliisiza mo ebirhungano.» ");
INSERT INTO hav_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ho n'aho, echigusho chinene cha bamalahika gurhenga empingu chabugaana ola malahika, baliiri guharamya Nnamahanga n'okuderha ntya: ");
INSERT INTO hav_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«Obukuuze bunene emwa Nnamahanga omu mpingu z'elugulu bweneene, n'oku gulu, obuholo omu bantu baage asimiiswa nabo!» ");
INSERT INTO hav_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Bamalahika babeere babaleka n'okugaluka empingu, abo bangere babwirana ntya: «Boonabuno, rhuje eBeteleheemu kulola ebyabeere yo, ebi Nnaweerhu arhumenyeesize.» ");
INSERT INTO hav_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Baaja yo jubaajuba. Bashigaana Mariya na Yozefu n'omwana ey'alyaamire omu hikenzi hy'okuliisiza mw'ebirhungano. ");
INSERT INTO hav_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Babeere baabona enjolyaana, baabala ebi malahika abwiraga bo elugulu w'oyo mwana. ");
INSERT INTO hav_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Booshi bayunvaga ebi abangere baderhaga basoomerwa bweneene. ");
INSERT INTO hav_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mariya yeewe aliiri kubiika ebyo byooshi oku murhima gwage n'ogukengeera bichi biderhere. ");
INSERT INTO hav_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Abangere nabo bagaluka eyi bali bakuuza Nnamahanga n'okumuharamya oku byooshi bayunvire n'okubona ko nk'oku balibwirirwe. ");
INSERT INTO hav_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Habeere hagera siku munaane omwana aburhirwe, bamukembuula, bamuyirika Yeesu, ly'eziino malahika ali amuyirikire embere nyina aheeke obukule. ");
INSERT INTO hav_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Amango esiku zayeneraga z'ogucheesibwa nk'oku eRhegeko lya Muusa lyaaliderhere, Yozefu na Mariya baava bazamuukira eYerusaleema kuyeerekana omwana emwa Nnaweerhu. ");
INSERT INTO hav_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Bulaala biyandikirwe ntya omu Rhegeko lya Nnaweerhu: «Ngasi mwana w'obuzaana nji waaburhwa w'olubere, arhuulwe emwa Nnaweerhu.» ");
INSERT INTO hav_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Balikwaneene guhaana entuulo ehemerwe mw'elyo Rhegeko lya Nnaweerhu: «Maguuku mabiri changwa enyunyi ebiri z'entungulu.» ");
INSERT INTO hav_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Haliiri muntu muguma eYerusaleema oyirikwa Simeooni. Aliiri muntu okwaneene embere za Nnamahanga n'okumukenga. Aliiri kulinga owarhulereza Israheeli, na Muuka-Mutagatiifu aliiri haguma naye. ");
INSERT INTO hav_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Muuka-Mutagatiifu ali mubwirire oku arhagafiire arhaza kubona Krisitu wa Nnaweerhu. ");
INSERT INTO hav_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Simeooni ava aja omu Nju ya Nnamahanga eyi ayerekeezwe na Muuka-Mutagatiifu. Amango ababusi ba Yeesu bamuleerhaga kujira eby'eRhegeko lihemere, ");
INSERT INTO hav_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeooni amurhoola omu maboko maage, akuuza Nnamahanga n'okuderha ntya: ");
INSERT INTO hav_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«Nnaweerhu wajirire nk'oku walaganyaga: okola wakaleka omuja waawe afe n'omurhuula nka okw'echinwa chaawe chiderhere. ");
INSERT INTO hav_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Kwenge nachibweneere obuchunguke bwawe n'ameesho maani. ");
INSERT INTO hav_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Obu buchunguke warheganyaga embere za ngasi lubaga, ");
INSERT INTO hav_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","b'obumoleke nji bwakumenyesa oku bapagaani. Na kandi nji bwaba bukuuze bwa Israheeli, lubaga lwawe.» ");
INSERT INTO hav_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Eshe na nyina wa Yeesu basoomerwa n'ebi Simeooni aliiri kuderha elugulu w'omwana. ");
INSERT INTO hav_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeooni abagisha n'okubwira Mariya nyina wa Yeesu ntya: «Oyu mwana ali ho yi bantu banene barhoge n'abandi bayinamuke omu Israheeli. Nj'aba chimenyeeso charhenga emwa Nnamahanga, banene nji bachilahira. ");
INSERT INTO hav_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Na ntyo, nj'abishuula enkengeero zibishirwe omu mirhima ya banene. Naawe Mariya, nji wababala bweneene omu murhima gwawe nk'ogwachumirhirwe n'akeere.» ");
INSERT INTO hav_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Haliiri omuleebi-kazi muguma oyirikwa Haana, mwali wa Fanuweeri, w'omu mulala gwa Haseeri. Oyo Haana abaaga akola mugeekulu wa myaaka minene. Abaaga amalama myaaka mushanvu yonyine n'eba gurhengera ogushabwa kwage, buzinda bwaho eba afa. ");
INSERT INTO hav_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Alibeerere mushumbakazi, guhika amango ageraga omu myaaka makumi gali munaane n'ene. Abaaga arharhenga omu Nju ya Nnamahanga, aliko ey'anakolera Nnamahanga ezuuba n'obudufu omu guchiibuza kulya n'omu kugenda asaliira. ");
INSERT INTO hav_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Naye agera ho mw'ebyo bishanji n'okuva ahwanza gusiimiriza Nnamahanga. Booshi baliiri kulingiriza oguchungulwa kwa Yerusaleema, abalira bo elugulu w'oyo mwana. ");
INSERT INTO hav_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Abazeere ba Yeesu babeere bamala kujira nk'oku eRhegeko lya Nnaweerhu lihemere, bagaluka naye eGalilaaya omu gishagala chaabo ch'eNazareeti. ");
INSERT INTO hav_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Oyo mwana Yeesu aliiri gukula n'okugwarha emisi. Aliyunjwire n'obwenge bunene, n'omugisho gwa Nnamahanga gwaliiri haguma naye. ");
INSERT INTO hav_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ngasi mwaka, abazeere ba Yeesu bagendaga baja eYerusaleema oku lusiku lukulu lwa Paasaka. ");
INSERT INTO hav_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yeesu abeere agwarha myaaka ekumi n'ebiri, bazamuukira yo naye gukulikirana n'emicho y'olusiku lukulu. ");
INSERT INTO hav_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Olusiku lukulu lwa Paasaka lwabeere lwahwa, bafuluka. Aliko omwana Yeesu asigala eYerusaleema. Ababusi baage barhamenyaga chiro. ");
INSERT INTO hav_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Baliiri gukengeera oku nkabaga Yeesu ali haguma n'abandi bantu baliiri nabo omu lugenzi. Balambagira ezuuba lyooshi. Baja barhondera kumushonda ahagarhi ka beene baabo n'abantu babayinji. ");
INSERT INTO hav_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Aliko barhamubonaga. Baava bagaluka eYerusaleema eyi bali bamushonda. ");
INSERT INTO hav_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Buzinda bwa siku esharhu, bamushimaana omu Nju ya Nnamahanga ayikeere ahagarhi k'abigiriza b'eRhegeko lya Nnamahanga. Aliiri kubayunviriza n'okubabaza ebibazo. ");
INSERT INTO hav_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Booshi baliiri kumuyunviriza basoomererwa obwenge bwage n'ebishubizo aliiri guhaana. ");
INSERT INTO hav_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ababusi baage babeere bamubona, baashalama. Nyina amubwira ntya: «Mwana waani, charhumire warhujira ntya? Yisho haguma naani rhwaliiri kugushonda n'obuuba.» ");
INSERT INTO hav_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Yeesu abashubiza ntya: «Gichi charhumaga mwanshonda? Ka murhamenyere oku nkwaneene kuba omu Nju ya Daarha?» ");
INSERT INTO hav_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Aliko barhayunvaga ech'aliiri kubabwira. ");
INSERT INTO hav_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Yeesu achima nabo eNazareeti. Aliiri kubakenga. Nyina aliiri kubiika ebyo binwa byooshi omu murhima gwage. ");
INSERT INTO hav_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yeesu aliiri gukula omu bwenge bunene, omu bule n'omu migisho embere za Nnamahanga n'abantu. ");
INSERT INTO hav_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Omu mwaka gw'ekumi na garhaano g'oburhegesi bw'omwami mukulu w'aBarooma Kayizaari Tiberiyo, Ponsiyo Pilaato aliiri mwimangizi w'egihugo ch'eYudeeya. Na Heroode aliiri mwimangizi w'egihugo ch'eGalilaaya na mwene waabo oyirikwa Firipo omu gihugo ch'eItureya na ech'eTarakoniiti. Lisaniya naye aliiri mwimangizi w'egihugo ch'eHabileeni. ");
INSERT INTO hav_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Hanaasi na Kayaafa bo baliiri bakulu b'abadaahwa. Mwamo mango, echinwa cha Nnamahanga chahikira Yohaana mugala wa Zakariya omu mpinga. ");
INSERT INTO hav_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Yohaana agera omu bihugo byooshi byalitureene n'olwinji lw'eYorodaani. Aliiri kuyaamagaza ntya: «Muleke ebyaaha byenyu, mubatiizwe yi Nnamahanga ababalira.» ");
INSERT INTO hav_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Na ntya byaava byaagera ho eby'omuleebi Isaya ayandikaga omu gitaabu chaage mpu: «Muntu muguma ali ahamagaza omu mpinga: ‹Murheganye enjira ya Nnaweerhu. Mumujirire enjira zilambuukire! ");
INSERT INTO hav_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ngasi lubanda nji lwayunjuzwa, ngasi musozi na ngasi hirhondo nji byalambuulwa, ngasi rukumba lw'enjira nji lwagonyoolwa. Enjira zibiihire nji zalambuulwa. ");
INSERT INTO hav_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Na ngasi muntu nj'abona obuchunguke Nnamahanga ahaana.›» ");
INSERT INTO hav_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Abantu banene bayinja emwa Yohaana mpu ababatiize. Alema ababwira ntya: «Mwe buuko bw'enjoka, nde wabayigiriize guchilanga oku buhane bwayinjire? ");
INSERT INTO hav_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Leero, muleme mwayeerekana kugerera ebijiro binja oku mwalekere ebyaaha byenyu. Murhachibwiraga mpu: ‹Abrahaamu ali shookuluza weerhu.› Kwenge mbabwirire oku Nnamahanga agakoleesa ama mabaale n'okumajira baana ba Abrahaamu! ");
INSERT INTO hav_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Embasha ekola eri hoofu guchiira emirhi oku mizi. Nkaasi murhi gurhayeezeze amalehe menja, gwachiibwa n'ogukabulwa omu muliro.» ");
INSERT INTO hav_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Abantu baliiri kumubaza ntya: «Gichi rhujaage rhwajira?» ");
INSERT INTO hav_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Abashubiza ntya: «Ogwerhe simiisi ebiri agwasizwe guhaana nguma okw'orhayigwerhe. Ogwerhe ech'okulya naye ajire ntyo.» ");
INSERT INTO hav_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ab'ogufurhiisa amakooli nabo bayinja kubatiizwa. Baabaza Yohaana ntya: «Mwigiriza, bichi rhukwaneene kujira?» ");
INSERT INTO hav_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ashubiza bo ntya: «Murhahoreesaga binene kulusha ebi murhegekerwe guhoreesa.» ");
INSERT INTO hav_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Abasoda nabo baamubaza ntya: «Neerhu, bichi rhukwaneene kujira?» Ashubiza bo ntya: «Murhanyagaga omuntu ehyaage changwa gusidaaka omuntu oku bushaabusha. Aliko musimiiswe n'omukamarho gwenyu.» ");
INSERT INTO hav_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Olubaga lwaliiri kulingiriza n'obulangaalire, ngasi muguma aliiri gukengeera omu murhima gwage oku nkabaga Yohaana ye Krisitu. ");
INSERT INTO hav_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yohaana abwira bo ntya: «Nyoono ndi nababatiiza omu menji; aliko owayinja agwerhe obuhashe kundusha. Ntakwaneene chiro gushwekuula omugozi gw'ebiraato byaage. Yeewe nj'ababatiiza na Muuka-Mutagatiifu, n'omu muliro. ");
INSERT INTO hav_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Afarhire omu fune zaage engooko y'okuyeera, abiiza echibuga chaage; ahira amahemba olwage lunda n'emyaavu olwage lunda. Nj'agusha amahemba omu nguli yaage, sy'aliko nj'ayoosa emyaavu omu muliro gurhazima chiro n'ehityu.» ");
INSERT INTO hav_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yohaana ayigiriza olubaga oMwazi Mwinja omu kubaheereza ezindi nyigirizo zinene z'okubaseeza omurhima. ");
INSERT INTO hav_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Aliko Yohaana akalihira Heroode, wali yimire omu gihugo ch'eGalilaaya, kwenge aliyingiire Herodiya muka mwene waabo, n'okwenge abaaga ey'akolere ebindi bijiro binene bibiihire. ");
INSERT INTO hav_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Kw'ebyo byooshi, Heroode ayongeera ko echindi chijiro chibi ch'oguhiriisa Yohaana omu munyororo. ");
INSERT INTO hav_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Abantu booshi babeere bamala kubatiizwa, Yeesu naye abatiizwa. Olo lusiku, oku Yeesu ali gusaliira, empingu yagichinguula, ");
INSERT INTO hav_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Muuka-Mutagatiifu amuyandagalira ko omu shusho ly'eguuku. Omulenge gwayunviikana ntya gurhengera empingu: «Oli Mugala waani muzigirwa; nsimiisizwe nawe bweneene.» ");
INSERT INTO hav_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Amango Yeesu arhonderaga kuyigiriza, aligwerhe emyaaka yakagera ku makumyaasharhu. Abantu baliiri kumurhoola nka mwene Yozefu. Yozefu aliiri Mugala wa Heeli, ");
INSERT INTO hav_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heeli aliiri mugala wa Mataati, Mataati aliiri mugala wa Laawi, Laawi aliiri mugala wa Meleki, Meleki aliiri mugala wa Janaayi, Janaayi aliiri mugala wa Yozefu, ");
INSERT INTO hav_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yozefu aliiri mugala wa Matatiyaasi, Matatiyaasi aliiri mugala wa Amoosi, Amoosi aliiri mugala wa Nahuumu, Nahuumu aliiri mugala wa Esuuli, Esuuli aliiri mugala wa Nagaayi, ");
INSERT INTO hav_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagaayi aliiri Mugala wa Maati, Maati aliiri mugala wa Matatiyaasi, Matatiyaasi aliiri mugala wa Semeyini, Semeyini aliiri mugala wa Yezeechi, Yezeechi aliiri mugala wa Yooda, ");
INSERT INTO hav_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yooda aliiri Mugala wa Yohanaani, Yohanaani aliiri mugala wa Reesa, Reesa aliiri mugala wa Zorobabeeli, Zorobabeeli aliiri mugala wa Shalitiyeeri, Shalitiyeeri aliiri mugala wa Neeri, ");
INSERT INTO hav_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neeri aliiri mugala wa Meleechi, Meleechi aliiri mugala wa Aadi, Aadi aliiri mugala wa Gosaame, Gosaame aliiri mugala wa Elimadaame, Elimadaame aliiri mugala wa Ere, ");
INSERT INTO hav_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ere aliiri mugala wa Yooshuwa, Yooshuwa aliiri mugala wa Eliyezeeri, Eliyezeeri aliiri mugala wa Yoriime, Yoriime aliiri mugala wa Mataati, Mataati aliiri mugala wa Laawi, ");
INSERT INTO hav_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Laawi aliiri mugala wa Simeooni, Simeooni aliiri mugala wa Yuuda, Yuuda aliiri mugala wa Yozefu, Yozefu aliiri mugala wa Yonaami, Yonaami aliiri mugala wa Eliyakiimu, ");
INSERT INTO hav_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliyakiimu aliiri mugala wa Meleeya, Meleeya aliiri mugala wa Meena, Meena aliiri mugala wa Mattata, Mattata aliiri mugala wa Nataamu, Nataamu aliiri mugala wa Daawudi, ");
INSERT INTO hav_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Daawudi aliiri mugala wa Yeese, Yeese aliiri mugala wa Yobeedi, Yobeedi aliiri mugala wa Boazi, Boazi aliiri mugala wa Saala, Saala aliiri mugala wa Nasooni, ");
INSERT INTO hav_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasooni aliiri mugala wa Aminadaabu, Aminadaabu aliiri mugala wa Adimiini, Adimiini aliiri mugala wa Ariini, Ariini aliiri mugala wa Hesiroomi, Hesiroomi aliiri mugala wa Pereesi, Pereesi aliiri mugala wa Yuuda, ");
INSERT INTO hav_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yuuda aliiri mugala wa Yakobo, Yakobo aliiri mugala wa Isaka, Isaka aliiri mugala wa Abrahaamu, Abrahaamu aliiri mugala wa Teera, Teera aliiri mugala wa Nahoori, ");
INSERT INTO hav_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahoori aliiri mugala wa Seruugi, Seruugi aliiri mugala wa Reehu, Reehu aliiri mugala wa Peleegi, Peleegi aliiri mugala wa Hebeeri, Hebeeri aliiri mugala wa Sheela, ");
INSERT INTO hav_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sheela aliiri mugala wa Kenaani, Kenaani aliiri mugala wa Arapakasaadi, Arapakasaadi aliiri mugala wa Seemu, Seemu aliiri mugala wa Noowa, Noowa aliiri mugala wa Lameeki, ");
INSERT INTO hav_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lameeki aliiri mugala wa Matusaleemi, Matusaleemi aliiri mugala wa Henooka, Henooka aliiri mugala wa Yereedi, Yereedi aliiri mugala wa Malaleeli, Malaleeli aliiri mugala wa Kenaani, ");
INSERT INTO hav_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenaani aliiri mugala wa Enoosi, Enoosi aliiri mugala wa Seeti, Seeti aliiri mugala wa Adaamu, Adaamu aliiri mugala wa Nnamahanga. ");
INSERT INTO hav_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yeesu arhenga omu lwinji lw'eYorodaani ey'ayunjwizwe Muuka-Mutagatiifu. Aheekwa na Muuka-Mutagatiifu omu mpinga. ");
INSERT INTO hav_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Omoola mpinga, ageregezwa na Shetaani gihe cha siku makumi mane. Arhalyaaga chintu mw'ezoola siku. Zabeere zaahwa, ayunva enzara. ");
INSERT INTO hav_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Shetaani aja amubwira ntya: «Akaba oli Mugala wa Nnamahanga, bwira eli baale lihinduke mugati.» ");
INSERT INTO hav_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yeesu amushubiza ntya: «Biyandikirwe: ‹Omuntu arhakalama n'omugati gonyine.›» ");
INSERT INTO hav_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Shetaani ava amuheeka elugulu bweneene, amuyeereka omu gashanji kageeke amaami mooshi m'egulu. ");
INSERT INTO hav_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Shetaani amubwira ntya: «Nji naguheereza obuhashe booshi n'obukuuze bw'ama maami mooshi. Nahaabirwe ebyoola byooshi. Naani nakabiheereza eyi nshondere. ");
INSERT INTO hav_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Okamparamya, byooshi byaaba byaawe.» ");
INSERT INTO hav_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yeesu amushubiza ntya: «Biyandikirwe: ‹Oharamye Nnaweerhu, Nnamahanga waawe n'okumukolera yenyine.›» ");
INSERT INTO hav_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Shetaani ashuba kumuheeka eYerusaleema. Amuhira elugulu w'eNju ya Nnamahanga n'okumubwira: «Akaba oli Mugala wa Nnamahanga, chiikabula gurhenga hano kuja eshiishi. ");
INSERT INTO hav_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Kwenge aMandiko Matagatiifu maderhere ntya: ‹Nnamahanga nj'arhegeka bamalahika baage bakulange.› ");
INSERT INTO hav_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Na kandi: ‹Baguheeka omu maboko maabo y'okugulu kwawe nji gurhasiirhalaga oku baale.›» ");
INSERT INTO hav_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yeesu amushubiza ntya: «aMandiko Matagatiifu maderhere ntya: ‹Orhahira okageregeza Nnaweerhu, Nnamahanga waawe.›» ");
INSERT INTO hav_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Abeere amala kugeregeza Yeesu omu ngasi kuntu, Shetaani aja hale naye kugera ekindi gihe. ");
INSERT INTO hav_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yeesu agaluka eGalilaaya eyi ayunjwire obuhashe bwa Muuka-Mutagatiifu. Emyaazi yaage y'amenyikana mwaho hantu hooshi. ");
INSERT INTO hav_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Alema ayigiriza omu masinagoogi na ngasi muntu alema amukuuza. ");
INSERT INTO hav_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yeesu aja eNazareeti, emunda alemberwaga. Olusiku lw'eSaabato, aja omu sinagoogi nk'oku ali komeere. Ayimanga gusoma aMandiko Matagatiifu. ");
INSERT INTO hav_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Bamuheereza egitaabu ch'omuleebi Isaya. Azinguula cho n'okuva abona olukere luyandikirwe ntya: ");
INSERT INTO hav_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«oMuuka gwa Nnaweerhu gundi ko. Kwenge akinshogere mpu ndeme nayigiriza abakene oMwazi Mwinja. Antumire kuyaamagiza ogushwekuulwa kw'abali omu munyororo n'empumi oguhumuulwa ameesho, n'okulikuulwa kw'ababonereerwe, ");
INSERT INTO hav_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","n'okuyaamagaza omwaka Nnaweerhu ayeerekana olukogo lwage.» ");
INSERT INTO hav_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yeesu azinga egitaabu, achigalulira omukozi n'okuyikala. Abantu booshi baliiri omu sinagoogi baliiri kumuseeza kw'ameesho. ");
INSERT INTO hav_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ava ahwanza kubabwira ntya: «Zeene aMandiko Matagatiifu mwayuusa kuyunva mamayeenera.» ");
INSERT INTO hav_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Booshi baalema bamudumiiriza n'ogusoomererwa ebinwa binja aliiri kuderha. Baalema baderha ntya: «K'arhali mugala wa Yozefu oyuula?» ");
INSERT INTO hav_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yeesu abwira bo ntya: «Okuli, mwambwira oguula mugani: ‹Mufumu, ochifumye wenyine.› Na kandi mwambwira: ‹Rhwayunviirhe ebiwajirire byooshi eGaperinaumu. Jira ebiri nk'ebyo kuno mwenyu nako.›» ");
INSERT INTO hav_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ashubi yongeera ntya: «Mbabwirire okuli: nta muleebi oyankirirwa bwinja omu gishagala chaabo ");
INSERT INTO hav_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Okuli, mbabwirire okw'eIsraheeli haliiri abashumbakazi banene amango ma Eliya. Amo mango envula yamala myaaka esharhu na myeezi ndarhu buzira gurhoga. Enzara nene yabonekana omu gihugo chooshi. ");
INSERT INTO hav_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Sy'aliko Eliya arharhumwaga emwa muguma wabo, aliko arhumwa emw'omushumbakazi muguma wali lamire eSarepata omu gihugo ch'Sidoona. ");
INSERT INTO hav_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Haliiri kandi ababenzibenzi banene omu Israheeli amango m'omuleebi Elisha. Na ntaaye omu bo wafumire, aliko oMusuuriya Namaani yenyine.» ");
INSERT INTO hav_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Booshi baliiri omu sinagoogi babeere bayunva ntyo, bakaliha. ");
INSERT INTO hav_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Bayimanga, bakuula Yeesu omu gishagala, bamuheeka elugulu w'omusozi gwaliyumbakirwe ko echo gishagala mpu yi bamushunika omu lubanda. ");
INSERT INTO hav_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Aliko agera ahagarhi kaabo, achigendera. ");
INSERT INTO hav_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Enyuma z'ebi, Yeesu aja ayandagalira omu gishagala ch'eGaperinaumu ch'omu gihugo ch'eGalilaaya. Olusiku lw'eSaabato lwabeere lwahika, agenda kuyigiriza omu sinagoogi. ");
INSERT INTO hav_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Abantu basoomererwa bweneene enyigirizo zaage, kwenge aliiri kuderha n'oburhegesi. ");
INSERT INTO hav_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Omu sinagoogi haliiri omuntu walifarhirwe n'omuzimu. Akankama ntya n'omulenge munene: ");
INSERT INTO hav_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«Yoo! Yeesu w'eNazareeti, gichi warhushonda ko? K'oyinjire gurhumala? Nkuyinji! Oli Mutagatiifu wa Nnamahanga.» ");
INSERT INTO hav_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yeesu akankamira bweneene oyo omuzimu n'okumubwira ntya: «Sira, rhenga m'oyu muntu!» Omuzimu akabula oyo muntu oku budaka ahagarhi k'abantu n'okumurhenga mo buzira kumujira kubi. ");
INSERT INTO hav_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Abantu booshi basoomerwa n'okubwirana ntya: «Byo bich'ibi? Oyu muntu y'arhegeka n'ogukalihira n'emisi abazimu, nabo banahuluka!» ");
INSERT INTO hav_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","N'emyaazi eyerekeere Yeesu yayandaala mw'echo gihugo chooshi. ");
INSERT INTO hav_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yeesu ahuluka omu sinagoogi ayeerekeza emwa Simooni. Nazaala wa Simooni ali libukire n'eshuushira linene. Baahema Yeesu amufumye. ");
INSERT INTO hav_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yeesu amuyegeera, akalihira eshuushira, nalyo lyamuleka. Ho n'aho oyo mukazi ayuumuka n'ogurhondera kubakolera. ");
INSERT INTO hav_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ezuuba lyabeere lyaazika, abantu baligwerhe abalwala ba ngasi ndwala, baleerhera bo Yeesu. Ahira amaboko ku ngasi muguma n'okubafumya. ");
INSERT INTO hav_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Abazimu barhenga omu balwala banene eyi bali babweja ntya: «Oli Mugala wa Nnamahanga!» Aliko Yeesu abakalihira n'okubabuza kuderha. Kwenge boowe baliyinji okw'ali Krisitu. ");
INSERT INTO hav_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Bwabeere bwacha, Yeesu arhenga ahoola, achijiira ahantu harhali bantu. Abantu banene barhondera kumushonda. Babeere bamushimaana, bashonda kumubuza arhabalekaga. ");
INSERT INTO hav_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Aliko Yeesu abwira bo ntya: «Ngwasize kuyigiriza oMwazi Mwinja g'obwime bwa Nnamahanga omu bindi bishagala nabyo. Kwenge echo chicharhumaga Nnamahanga antuma.» ");
INSERT INTO hav_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Alema ayigiriza omu sinagoogi z'egihugo ch'eYudeeya. ");
INSERT INTO hav_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Lusiku luguma, Yeesu aliyimangire ahaburhambi bw'enyanja eyirikwa Genezareeti. Abantu banene balwisa kuja ahaburhambi bwage kuyunviriza eChinwa cha Nnamahanga. ");
INSERT INTO hav_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Abona maarho mabiri mali emushengo. Abashaana eyi barhengere mo bakola bali gushuka emilaga yaabo. ");
INSERT INTO hav_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yeesu ashonera omu bwarho buguma. Bwaliiri bwa Simooni. Yeesu amuhema okw'abushunike hale bugeeke n'emushengo. Yeesu ayikala m'obo bwarho n'ogurhondera guhaana enyigirizo zaage oku bantu. ");
INSERT INTO hav_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Abeere amala kuderha, abwira Simooni ntya: «Shegera hale, ah'amenji maleehere. Wooyo n'abenyu, muhire emilaga yenyu omu menji, murhege.» ");
INSERT INTO hav_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simooni amushubiza ntya: «Mwigiriza, rhwalibukire obudufu booshi, rhwamanahina. Aliko obo wamambwira oku njire ntyo, nahira emilaga omu menji.» ");
INSERT INTO hav_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Babeere baajira ntyo, bayirha efi zinene bweneene, oku bulyo emilaga yaabo yarhondera guchiibera. ");
INSERT INTO hav_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Basimira abaabo baliiri omu bwindi bwarho mpu bayinje babagwase. Aboola bayinja. Booshi haguma bayunjuza amo maarho mabiri, oku bulyo maalema mayika omu menji. ");
INSERT INTO hav_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simooni Petero abeere abona ebyoola, afukama embere za Yeesu n'okuderha ntya: «Orhanyegeeraga, Nnaweerhu, kwenge nyoono ndi muntu w'ebyaaha!» ");
INSERT INTO hav_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simooni n'abaliiri naye, booshi baalisomeerwe ntya elugulu w'efi zinene bayirhaga. ");
INSERT INTO hav_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Yakobo na Yohaana, bagala ba Zebedayo, baliiri gurhega haguma na Simooni, nabo basoomerwa. Aliko Yeesu abwira Simooni ntya: «Orhayuubahaga: gurhengera zeene waaja waloba abantu.» ");
INSERT INTO hav_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Baava basiika amaarho maabo emushengo. Baaleka byooshi, bakulikira Yeesu. ");
INSERT INTO hav_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Amango Yeesu aliiri omu gishagala chiguma ch'omu bishagala by'eGalilaaya, haahulukira omuntu oyunjwire ebibenzi. Abeere abona Yeesu, achikabula embere zaage, amalanga oku budaka n'okumuyinginga ntya: «Nnaweerhu, akaba bigusimiisize, wakancheesa.» ");
INSERT INTO hav_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yeesu alambuula okuboko, amuhuma ko n'okuderha ntya: «Binsimiisize, ocheeswe!» Ho n'aho, ebibenzi by'oyo muntu byaafuma. ");
INSERT INTO hav_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yeesu amurhegeka ntya: «Nta muntu obwirage ebiila. Aliko oje guchiyeerekana emw'omudaahwa, ohaane entuulo y'ogucheeswa nk'oku Muusa ayirhegekaga. K'okuyeereka abantu booshi oku wafumire.» ");
INSERT INTO hav_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Aliko emyaazi eyerekeere Yeesu yayandaala hooshi. Abantu banene baalema bachiigusha mpu bamuyunvirize, anabafumye endwala zaabo. ");
INSERT INTO hav_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Aliko Yeesu alema ayongoloka kuja gusaliira aharhali bantu. ");
INSERT INTO hav_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Lusiku luguma, Yeesu aliiri kuyigiriza. aBafarisaayo n'abigiriza b'amarhegeko bali bayikeere ahoola, bahulukiraga omu bishagala byooshi by'eGalilaaya, by'eYudeeya n'eYerusaleema. N'obuhashe bwa Nnaweerhu bwaliiri haguma naye y'afumya abalwala. ");
INSERT INTO hav_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ho n'aho abantu baguma baagera ho baheekere omuntu ohunzize oku gipoyi. Baliiri gushonda kumuheeka omu nju n'okumurhabika embere za Yeesu. ");
INSERT INTO hav_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Aliko baabula ngahe bakamugezeza elugulu w'abantu banene. Baava bashona oku nju elugulu n'ogukubuula amatebura, bamuchimiza oku gipoyi ahagarhiigarhi k'echigusho ch'abantu embere za Yeesu. ");
INSERT INTO hav_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yeesu abeere abona obwemeezi bw'abo, abwira oyo mulwala ntya: «Mwira waani, ebyaaha byaawe byababaliirwe.» ");
INSERT INTO hav_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Abigiriza b'amarhegeko n'aBafarisaayo barhondera gukengeera ntya: «Oyu mulume ali nde oli kudukanga Nnamahanga? Nde wakagala kubabalira ebyaaha arhali Nnamahanga yenyine?» ");
INSERT INTO hav_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yeesu amenya enkengeero zaabo, ava ababaza ntya: «Chagarhuma mwagwarha enkengeero ziri ntya omu mirhima yenyu? ");
INSERT INTO hav_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Bichi biyoolohere, akaba okuderha ntya: ‹Ebyaaha byaawe byababaliirwe›, changwa okuderha: ‹Yimanga, olambagire?› ");
INSERT INTO hav_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Leero nshondere mumenye oku Mwene oMuntu agwerhe obuhashe b'okubabalira ebyaaha omu gulu.» Ava abwira oyo mulwala ohunzize ntya: «Nkubwirire, yimanga, rhoola egipoyi chaawe, ogaluke emwawe!» ");
INSERT INTO hav_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ho n'aho oyo muntu ayimanga embere z'abantu booshi, ava arhoola egipoyi chaage aliiri kulyaama ko, n'oguchijiira emwage ey'aheerhe akuuza Nnamahanga. ");
INSERT INTO hav_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Booshi basoomerwa, bakuuza Nnamahanga. Bayuubaha n'okuderha ntya: «Zeene rhwabwene oku bintu bisomeezwe!» ");
INSERT INTO hav_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Buzinda bwaho, Yeesu ahuluka, abona omufurhiisa w'amakooli oyirikwa Laawi, ey'ayikeere ahantu bafurhiisiza. Yeesu amubwira ntya: «Nkulikira!» ");
INSERT INTO hav_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Laawi aleka byooshi, ayimanga n'okumukulikira. ");
INSERT INTO hav_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Laawi amujirira esheego nene omu mwage. Abafurhiisa b'amakooli banene n'abandi bantu baliiri gusangira meeza maguma nabo. ");
INSERT INTO hav_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","aBafarisaayo n'abigiriza b'amarhegeko balunduma n'okubwira abigirizwa ba Yeesu ntya: «Chagarhuma mwalya n'okunywa haguma n'abafurhiisa b'amakooli n'abanyabyaaha?» ");
INSERT INTO hav_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yeesu abashubiza ntya: «Arhali abantu bagumaguma bo bakenera omufumu sy'aliko abalwala. ");
INSERT INTO hav_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ntayinjaga guhamagala abakengereere oku bakwaneene sy'aliko abayinji oku bali banyabyaaha yi babileka n'okugalukira Nnamahanga.» ");
INSERT INTO hav_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","aBafarisaayo bamubwira ntya: «Abigirizwa ba Yohaana kuguma n'abeerhu bazigaana guchiibuza kulya banajira n'esaala, aliko ab'emwawe boowe yi bagendeerera kulya n'okunywa.» ");
INSERT INTO hav_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yeesu ashubiza bo ntya: «Ka mwakabuza abeera b'omuhya-mulume kulya n'okunywa n'obo omuhya-mulume achiri haguma nabo? Nangwa! ");
INSERT INTO hav_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Nji hayinja amango banyegwa omuhya mulume, mw'ezo siku nji bachiibuza okulya n'okunywa.» ");
INSERT INTO hav_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Abwira bo kandi guno mugani: «Ntaaye okuula ehisharhe oku mwenda muhyaahya mpu ahihangire oku mwenda gushaajire. Kwenge owajira ntyo, nj'aba aberere omwenda muhyaahya, n'ehisharhe arhoolere hirhakananiira oku gushaajire. ");
INSERT INTO hav_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Na ntaaye ohira edivaayi y'omuhyo omu ndaha zishaajire; okwindi, kuli kuderha oku, edivaayi y'omuhyo enabera endaha, yanabirira n'endaha zanaberekera busha. ");
INSERT INTO hav_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Aliko bihemere guhira edivaayi y'omuhyo omu ndaha zihyaahya. ");
INSERT INTO hav_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Na nta muntu wanywere oku divaayi y'enchulama wagasiima ey'omuhyo, kwenge baderha oku ey'enchulama y'enyinja.» ");
INSERT INTO hav_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Lusiku luguma lw'eSaabato, Yeesu n'abigirizwa baage baliiri kulenga omu mashwa m'engano. Abigirizwa baage bayaagula emihuli y'engano, bayivunga omu fune n'okulya embeke. ");
INSERT INTO hav_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","aBafarisaayo baguma bababaza ntya: «Chagarhuma mwajira ebilahiizwe olusiku lw'eSaabato?» ");
INSERT INTO hav_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yeesu abashubiza ntya: «Ka murhasomaga ebi Daawudi ajiraga n'abaliiri haguma naye eyi bayunviirhe enzara? ");
INSERT INTO hav_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Aja omu Nju ya Nnamahanga, arhoola emigati barhuuliraga Nnamahanga. Ayilya ko, ayiha oku baliiri haguma naye, n'obo eRhegeko lyeerhu liyemereere okw'abadaahwa bonyine bagwasize kulya yo.» ");
INSERT INTO hav_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Kandi Yeesu ababwira ntya: «Mwene oMuntu ye nyina eSaabato.» ");
INSERT INTO hav_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Olwindi lusiku lw'eSaabato, Yeesu aja omu sinagoogi kuyigiriza. Ahoola haliiri omuntu muguma w'okuboko kw'ekulyo guhunzize. ");
INSERT INTO hav_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Abigiriza b'amarhegeko n'aBafarisaayo baliiri kumuloleereza bweneene yi baabona akaba agafumya olusiku lw'eSaabato, kwenge baliiri gushonda echagarhuma bamusidaaka. ");
INSERT INTO hav_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Aliko Yeesu aliyinji enkengeero zaabo. Ava abwira ntya oyo muntu w'okuboko guhunzize: «Yimanga, oje ahagarhi k'abantu booshi.» Ava ayuumuka n'okuja ho. ");
INSERT INTO hav_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Yeesu abwira bo ntya: «Mbabazize ntya: gichi chiyemereerwe olusiku lw'eSaabato? Okujira amenja changwa amabi? Ogufumya omuntu changwa okumuleka afe?» ");
INSERT INTO hav_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Abalola booshi, abwira oyo muntu ntya: «Gonyoola okuboko kwawe.» Oyo muntu akugonyoola n'okuva kwafuma. ");
INSERT INTO hav_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Aliko abigiriza b'amarhegeko n'aBafarisaayo bayunjulwa n'omujinya n'ogurhondera kubazana gurhe bajirage Yeesu. ");
INSERT INTO hav_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Amo mango, Yeesu aja oku musozi kuja gusaliira. Amala k'obudufu booshi ey'ali asaliira Nnamahanga. ");
INSERT INTO hav_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Bwacheere eseezi, ahamagala abigirizwa baage, achishoga mw'ekumi na babiri. Abayirika «Ntumwa.» Ezo ntumwa zeezi: ");
INSERT INTO hav_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simooni oyu Yeesu ahaaga eziino lya Petero, na Ndereya mwene waabo, Yakobo na Yohaana, Firipo na Baritolomaayo, ");
INSERT INTO hav_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matayo na Tomaasi, Yakobo mwene Lufaayo na Simooni waliiri Muzelooti, ");
INSERT INTO hav_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yuuda mwene Yakobo na Yuuda Isikariyooti, ye wahindukaga mulenzi. ");
INSERT INTO hav_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yeesu ayandagala nabo gurhenga oku musozi n'okuyimanga omu kabanda ahaliiri abigirizwa baage banene. Ahoola haliiri n'echigusho chinene ch'abantu: abantu b'eYudeeya, ab'eYerusaleema na ab'echamashinji ch'eTiiro na ech'eSidoona. ");
INSERT INTO hav_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Bayinjaga mpu bamuyunviirize anabafumye endwala zaabo. Abantu baalifarhirwe n'abazimu baafuma. ");
INSERT INTO hav_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ngasi muntu aliiri gushonda amuhume ko, bulaala obuhashe bwa Nnamahanga bwaliiri kumurhenga ko n'okubafumya booshi. ");
INSERT INTO hav_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yeesu aja alola abigirizwa baage n'okuderha ntya: «Mugishirwe, mwe muli bakene, kwenge oBwami bwa Nnamahanga buli bwenyu! ");
INSERT INTO hav_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Mugishirwe, mwe muli nzara buno, kwenge nji mwayuugurha! Mugishirwe, mwe muli kulira buno, kwenge nji mwasheka! ");
INSERT INTO hav_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Mugishirwe, akaba abantu bakabayanga, akaba bakabalahira, bakabadukanga n'okuderha kubi elugulu w'amaziino menyu, kwenge muyemereere Mwene oMuntu. ");
INSERT INTO hav_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Musiime n'ogushagaluka amango ebyoola nji byabahikira, kwenge oluhembo lwenyu luli lunene omu mpingu. Ntyo maani ku bashookuluza baabo baliiri kulibuza abaleebi ba Nnamahanga. ");
INSERT INTO hav_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Aliko buhanya bwenyu mwe bachire! Kwenge mwabo mwahaabirwe olwenyu luhembo! ");
INSERT INTO hav_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Buhanya bwenyu mwe muyugurhire buno! Kwenge nji mwagwarha enzara! Buhanya bwenyu mwe muli gusheka buno! Kwenge nji mwaba omu mishiibo n'omu malira! ");
INSERT INTO hav_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Buhanya bwenyu akaba abantu booshi bali kubaderha bwinja, kwenge ntyo ku bashookuluza baabo baliiri kujirira abaleebi b'obubeeshi!» ");
INSERT INTO hav_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","«Aliko mbabwirire, mwe muli kunyunva: musiime bashombanyi benyu, mujire amenja oku babashombere; ");
INSERT INTO hav_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","mugishe abanabavuma n'ogusaliirira ababadukanga. ");
INSERT INTO hav_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Akaba omuntu agushuurhire oku rhama liguma, omuyeerekeze n'elindi; nk'omuntu akunyagire egorhe lyaawe, omuleke arhoole n'esimiisi yaawe. ");
INSERT INTO hav_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","«Ohe ngasi yeeshi oguhemere echintu, na nk'omuntu agurhoolere ehyaawe, orhagishiibaga wamuhema hyo. ");
INSERT INTO hav_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","«Mujirire abantu nk'oku mushondere abandi babajirirage. ");
INSERT INTO hav_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Nka musiimire aba basiima bonyine, mukengereere oku nji mwahaabwa oluhembo? Nanga! aBanyabyaaha nabo basiima aba basiima! ");
INSERT INTO hav_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","N'akonva mujira amenja oku babajirira amenja bonyine, mukengereere oku nji mwahaabwa oluhembo? Nanga! aBanyabyaaha nabo baajira ntyo. ");
INSERT INTO hav_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","N'akaba muyindika aba mulangaalire oku nabo nji babajuha, mukengereere oku nji mwahaabwa oluhembo? Nanga! aBanyabyaaha nabo bayindika abandi banyabyaaha yi nji babajuha! ");
INSERT INTO hav_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ahuubwe, musiime bashombanyi benyu, mubajirire amenja n'oguhoza buzira kulingiriza kugalulirwa echintu. Ntyo, nji mwahaabwa oluhembo lunene n'okuba beene Nnamahanga w'Elugulu Bweneene, kwenge ali mwinja oku barhasiima n'oku babi. ");
INSERT INTO hav_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","«Mube n'olukogo nk'oku Yisho ali w'olukogo.» ");
INSERT INTO hav_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","«Murhachiiraga muntu olushinja na Nnamahanga naye arhakabachiira lushinja. Murhaderhaga okw'abandi bahanwe na Nnamahanga arhakaderha oku muhanwe. Ahuubwe mubabalire abandi na Nnamahanga nj'abababalira. ");
INSERT INTO hav_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Muhe abandi na Nnamahanga nj'abaha. Nji mwahaabwa omulengo gulengerwe bwinja, gusindagiirwe n'okuyunjuzwa bweneene kugera ogusheeshekala. Bulaala Nnamahanga nj'abalengera n'omulengo mulengera mo abandi.» ");
INSERT INTO hav_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yeesu ashuba kubabwira omugani: «Empumi erhakalambagiza eyindi mpumi, k'arhali ntyo? Akaba ntyo, oku bali babiri booshi banarhogera omu kijokole. ");
INSERT INTO hav_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Omwigirizwa arhaba elugulu w'omwigiriza waage; alik'omwigirizwa oyigiriizwe bwinja anaba kuguma n'omwigiriza waage. ");
INSERT INTO hav_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","«Chagarhuma walola ehirhi hiri omu liisho lya mwene wenyu n'obo orhamenyere egirhi chiri omu liisho lyawe? ");
INSERT INTO hav_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Gurhe wakabwira mwene wenyu ntya: ‹Mwene weerhu, leka ngukuule ehi hirhi hiri omu liisho lyawe›, werhabwene chiro egirhi chiri omu ly'emwawe? We ndyaalya we, rhang'okuule egirhi chiri omu liisho lyawe y'obona bwinja n'ogukuula ehirhi omu liisho lya mwene wenyu.» ");
INSERT INTO hav_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","«Omurhi mwinja gurhayeeza amalehe mabi. N'omurhi gulwere gurhayeeza amalehe menja. ");
INSERT INTO hav_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ngasi murhi gumenyikana oku malehe maago. Barhacha amalehe m'omutiini oku mirhi y'emishaaki n'emizabiibu oku marhovu. ");
INSERT INTO hav_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Omuntu mwinja akuula ebintu binja biri omu murhima gwage n'omuntu mubi naye akuula ebintu bibi biri omu murhima gwage. Kwenge obuunu bwa ngasi muntu buderha ebiyunjwire oku murhima gwage.» ");
INSERT INTO hav_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","«Girhuma mumpamagala ‹Nnaweerhu, Nnaweerhu›, n'obo murhajira ebi mbabwirire? ");
INSERT INTO hav_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","«Omuntu w'okuja emunda ndi, oyunva ebinwa byaani n'okubihira omu bijiro, tala gurhe ashushire: ");
INSERT INTO hav_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","ali nka muntu oli kuyumbaka enju. Ajokwere bweneene omu budaka kugera oku baale, arhonderera ahoola kuyumbaka. Amango emisuuka yayinjaga, amenji m'olwinji machishenya kw'eyo nju, aliko marhagalaga kuyishaganya, kwenge eyo nju yali yumbakirwe bwinja. ");
INSERT INTO hav_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Aliko, oyunviirhe ebinwa byaani buzira kubihira omu bijiro ali nka muntu oyumbakire enju oku budaka buzira kujokola y'arhonderera ahoola kuyumbaka bwinja. Amango emisuuka yagishenyaga kw'eyo nju, yahika yaagwa: yashandaakala looshi.» ");
INSERT INTO hav_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yeesu abeere amamala kubwira olubaga lwaliiri kumuyunviriza ebi binwa byooshi, aja eGaperinaumu. ");
INSERT INTO hav_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Eyoola, omukulu w'abasoda w'ekirooma aligwerhe omuja waage w'akamaro. Oyo muja alilwere bweneene ey'ali bufa. ");
INSERT INTO hav_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Oyo mukulu w'abasoda abeere ayunva yi baderha ebiyerekeere Yeesu, amurhumira abashamuka baguma b'aBayaahudi kumuhema ayinje amufumize oyo omuja waage. ");
INSERT INTO hav_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Babeere baagera emwa Yeesu, barhondera kumuyinginga bweneene n'okuderha ntya: «Oyu mukulu w'abasoda akwaneene gurhabaalwa naawe. ");
INSERT INTO hav_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Kwenge anasiima olubaga lwerhu, yeewe ye wayumbakisaga esinagoogi yeerhu.» ");
INSERT INTO hav_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Nnaweerhu ava agenda nabo. Abeere akola ali hoofu n'enju, oyo mukulu w'abasoda arhuma abeera baage kubwira Yeesu ntya: «Mwigiriza, orhashiibaga wachilibuza. Nyoono ntakwaneene mp'ohike omu mwani. ");
INSERT INTO hav_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Chegirhumire ntayinja nyenyine emunda oli. Aliko oderhe chinwa chiguma chonyine y'omuja waani afuma. ");
INSERT INTO hav_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Kwenge naani ndi eshiishi w'abanrhegekere na kandi ngwerhe abasoda nyimangiire. Nkabwira muguma ntya: ‹Genda!›, anagenda, na nkabwira owindi ntya: ‹Yinja!›, anayinja; na nkabwira omuja waani ntya: ‹Kola echiila!›, anagikola.» ");
INSERT INTO hav_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yeesu abeere ayunva ebyo binwa, asomererwa oyo mukulu w'abasoda. Ahindamuka abwira ntya echigusho ch'abantu bali bamukulikiire: «Mbabwirire oku ntashubiraga kubona obwemeezi buli ntya, nangwa! Chiro n'omu Israheeli.» ");
INSERT INTO hav_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Bala beera omukulu w'abasoda arhumaga, babeere bagaluka bashimaana omuja afumire. ");
INSERT INTO hav_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Enyuma z'aho, Yeesu aja omu gishagala chiguma chiyirikwa Naiina. Abigirizwa baage n'echigusho chinene ch'abantu bamuherekeza. ");
INSERT INTO hav_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Abeere agera hoofu n'omulyango g'olugo lw'echo gishagala, haahulukira abantu baliiri kuja guhamba omufu. Oyo mufu aliiri mwana w'echinege w'omushumbakazi muguma. Abantu banene b'ahoola baliiri haguma n'oyo mushumbakazi. ");
INSERT INTO hav_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Nnaweerhu abeere amubona, amuyunvira obonjo bweneene n'okumubwira ntya: «Orhaliraga!» ");
INSERT INTO hav_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ayegeera n'okuva ahuma oku gipoyi. Abaali giheekere bayimanga. Yeesu aderha ntya: «Musole we, nkubwirire ntya: zuuka!» ");
INSERT INTO hav_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Nyagufa azuuka, ayikala n'ogurhondera kuderha. Yeesu amugalulira nyina. ");
INSERT INTO hav_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Booshi bayuubaha. Bakuuza Nnamahanga omu kuderha ntya: «Rhwabonekeerwe n'omuleebi mukulu!», na kandi: «Nnamahanga ayinjire gurhabaala olubaga lwage!» ");
INSERT INTO hav_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","N'omu Yudeeya yooshi na hoofu nayo hooshi, abantu bamenya ebi Yeesu ali ajirire. ");
INSERT INTO hav_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Abigirizwa ba Yohaana bamubwira byooshi Yeesu aliiri kujira. Yohaana ahamagala babiri omu bo, ");
INSERT INTO hav_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","abarhuma emwa Nnaweerhu kumubaza ntya: «Ka wooyo we Masiiya Nnamahanga alaganyaga changwa rhukwaneene kulinga owindi?» ");
INSERT INTO hav_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Abo bigirizwa babiri babeere baahika hoofu na Yeesu, bamubwira ntya: «Yohaana Mubatiiza arhurhumire gukubaza ntya: ‹Ka wooyo we Masiiya ogwasizwe kuyinja changwa rhukwaneene kulinga owindi?›» ");
INSERT INTO hav_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Mw'akoola gashanji, Yeesu afumya abantu banene endwala zaabo, obulema, n'abazimu, n'okugalulira empumi okubona. ");
INSERT INTO hav_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Yeesu ashubiza abigirizwa ba Yohaana ntya: «Muje kubalira Yohaana ebi mwabwene n'okuyunva: empumi yi zabona, ebirema yi byalambagira, ababenzibenzi yi baafuma, ebihuli yi byayunva, abafu yi bafuuka, n'oMwazi Mwinja yi gwashambaalirwa abakene. ");
INSERT INTO hav_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Agishwe olaala orhakaleka kunyemeera!» ");
INSERT INTO hav_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Abarhumwa ba Yohaana babeere bagenda, Yeesu ava arhondera kubwira ntya olubaga lwali ho elugulu wa Yohaana: «Gichi mwajaagilola omu mpinga? Ka lusheke lushaganyizwe n'omuyaga? ");
INSERT INTO hav_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Kandi, gichi mwajaaga kulola? Ka muntu oyambeere emishangi minja? Aliko abayambala emishangi minja n'okulama omu muhimbo bali omu nju z'abaami. ");
INSERT INTO hav_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Aliko si, gichi mwajaaga mwaja kulola? Omuleebi? Neechi, mbabwirire okw'ali muleebi, na kandi yeewe alushire omuleebi. ");
INSERT INTO hav_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Kwenge Yohaana y'aMandiko Matagatiifu maderhaga ntya elugulu waage: ‹Ntumire omubala mwazi waani agurhange embere, kugurheganyiza enjira.› ");
INSERT INTO hav_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Mbabwirire oku omu booshi baburhirwe n'abakazi, harhashubiraga kuba omukulu kulusha Yohaana. Aliko, omugeeke bweneene omu Bwami bwa Nnamahanga ali mukulu kumulusha.» ");
INSERT INTO hav_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Olubaga looshi n'abafurhiisa b'amakooli bali bamuyunviriize, bayemeera oku Nnamahanga akwaneene, banachibatiziisa emwa Yohaana. ");
INSERT INTO hav_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Aliko aBafarisaayo n'abigiriza b'amarhegeko balahiire eki Nnamahanga ashondaga oku bo n'okuva balahira kubatiizwa na Yohaana. ");
INSERT INTO hav_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yeesu ashuba kuderha ntya: «Abantu bali zeene nakabashushanya na nde? Bashushire nde? ");
INSERT INTO hav_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Bashushire n'abaana bayikeere embuga, eyi baguma yi bahamagala abaabo ntya: ‹Rhwabazihiire omulizi aliko murhazinire! Rhwabayimpiire enyimpo z'emishiibo aliko murhalirire!› ");
INSERT INTO hav_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Amango Yohaana Mubatiiza ayinjaga, arhaliiri kulya emigati n'okunywa edivaayi. Mwamuderha ntya: ‹Agwarhirwe n'omuzimu!› ");
INSERT INTO hav_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Leero Mwene oMuntu amayinja, ali kulya n'okunywa. Kandi mwamamuderha ntya: ‹Tala oyu muntu oganiiza okulya konyine n'okunywa edivaayi. Ali mwira w'abafurhiisa b'amakooli n'abandi banyabyaaha!› ");
INSERT INTO hav_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Aliko, obwenge bunene bwa Nnamahanga buyinjikeene nka b'okuli oku booshi babuyemeera.» ");
INSERT INTO hav_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","oMufarisaayo muguma alaalika Yeesu kulya haguma naye. Aja omu nju yaage, bayikala kulya ebiryo. ");
INSERT INTO hav_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Mw'echo gishagala mwaliiri omukazi w'ebyaaha. Abeere ayunva oku Yeesu y'alya emw'oyo Mufarisaayo, aleerha omukebo gw'amarashi. ");
INSERT INTO hav_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ayimanga enyuma za Yeesu, ahaburhambi bw'amagulu maage. Arhondera kulira n'okulobya amagulu ma Yeesu n'emiziga yaage. Ashangula amagulu ma Yeesu n'enviiri zaage, amahoobera, n'okumashiiga kw'amarashi. ");
INSERT INTO hav_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Oyo Mufarisaayo walaalikaga Yeesu abeere abona ntyo, achibwira ntya omu murhima gwage: «Oyu muntu nk'aliiri muleebi wa Nnamahanga, singa amenyere oyu mukazi wamuhumire ko ali nde, okw'ali munyabyaaha.» ");
INSERT INTO hav_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yeesu abwira oyo Mufarisaayo ntya: «Simooni, ngwerhe echinwa ch'ogukubwira.» Simooni ashubiza ntya: «Derha, Mwigiriza.» ");
INSERT INTO hav_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yeesu aderha ntya: «Bantu babiri baligwerhe omwinda gw'owabayindikaga. Muguma aligwerhe omwinda gw'edinaari magana marhaano n'owindi makumi marhaano. ");
INSERT INTO hav_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Nka kunoola booshi ntaaye waligalire kumujuha, abababalira booshi oku bali babiri. Nde nji wamusiima bweneene mw'aba babiri?» ");
INSERT INTO hav_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simooni amushubiza ntya: «Nkengereere k'olaala ababaliraga walimugwerhe mwinda munene.» Yeesu amubwira ntya: «Waderhere okuli.» ");
INSERT INTO hav_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ashuba guhindamukira emunda oyo mukazi ali n'okubwira Simooni ntya: «K'obwene oyu mukazi? Najiire omu mwawe, chiro orhampeere amenji m'ogushuka amagulu, aliko yeewe anshukire amagulu n'emiziga yaage n'okumashangula n'enviiri zaage. ");
INSERT INTO hav_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Wooyo orhanyankiriire omu kumpoobera, aliko yeewe arhalekere guhoobera amagulu maani gurhengera aha najiriire omu mwawe. ");
INSERT INTO hav_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Wooyo orhashiigire amavurha omu rhwe lyaani, aliko yeewe ashiigire amarashi oku magulu maani. ");
INSERT INTO hav_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Cho girhumire nkubwirire oku obuzigire bunene anyerekere, buyerekeene okw'ebyaaha byaage binene byababaliirwe. Aliko obabaliirwe bugeeke anayeerekana obuzigire bugeeke.» ");
INSERT INTO hav_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Yeesu abwira oyo mukazi ntya: «Ebyaaha byaawe byababaliirwe.» ");
INSERT INTO hav_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Abaliiri kulya oku meeza haguma na Yeesu barhondera guchidedeesa ntya: «Oyu ali nde w'okubabalira n'ebyaaha nabyo?» ");
INSERT INTO hav_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Aliko Yeesu abwira oyo mukazi ntya: «Obwemeezi bwawe bwaguchungwire; ogende n'omurhuula.» ");
INSERT INTO hav_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Buzinda bw'aho, Yeesu alenga omu bishagala bineneenene n'omu bigeekegeeke. Agenda ayaamagaza n'okubala oMwazi Mwinja gw'obwime bwa Nnamahanga. Entumwa zaage ekumi n'ebiri zaliiri haguma naye, ");
INSERT INTO hav_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","n'abakazi baguma Yeesu akuulaga mw' abazimu n'abandi afumyaga endwala: Mariya oyirikwa w'eMagadala, warhengwaga mo bazimu mushanvu, ");
INSERT INTO hav_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Jaani muka Chuuza waliiri mwimangizi w'ebikulo bya Heroode, Suzana, n'abandi bakazi banene barhabaalaga n'ebikulo byaabo akaasi ka Yeesu n'entumwa zaage. ");
INSERT INTO hav_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Abantu banene bayegeera Yeesu, barhengeraga omu ngasi gishagala. Abachiira guno mugani: ");
INSERT INTO hav_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«Haliiri muhinzi muguma, agenda kubyaala emburho yaage. Okw'ali kubyaala, embeke ziguma zarhogera ahaburhambirhambi bw'enjira: zalabarhwa, n'enyunyi z'omu chaalege zalya zo. ");
INSERT INTO hav_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ezindi zarhogera oku mabaale. Zabeere zamera, zayuuma, kwenge zabulaga amenji. ");
INSERT INTO hav_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ezindi zarhogera omu mishaaki; emishaaki yamera haguma nazo n'okuzifundeeza. ");
INSERT INTO hav_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ezindi mbeke zarhogera omu budaka bwinja; zabeere zamera, zayeeza ngasi nguma amagana m'amalehe.» Yeesu abeere amala kuderha ebyoola, ayaamagaza ntya: «Ogwerhe amarhwi m'okuyunva, ayunve!» ");
INSERT INTO hav_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Abigirizwa baage baamubaza ech'ogo mugani gwali guderhere. ");
INSERT INTO hav_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Abashubiza ntya: «Mwabo, mwahaabirwe okumenya ebibishirwe by'obwime bwa Nnamahanga. Aliko oku bandi, bibabwirirwe omu migani, yi ‹nka baabona, ntaacho babonage, na nka bayunviriza, ntaacho bayunvage.›» ");
INSERT INTO hav_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","«Ogu mugani guderhere ntya: emburho zishushanyizwe n'eChinwa cha Nnamahanga. ");
INSERT INTO hav_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Embeke ziri ahaburhambirhambi bw'enjira, zishushanyizwe n'abantu bayunviriza eChinwa cha Nnamahanga. Aliko Shetaani anayinja gukuula eChinwa omu mirhima yaabo yi barhabaaga n'obwemeezi n'oguchungulwa. ");
INSERT INTO hav_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ezarhogeraga oku mabaale, zishushanyizwe n'abanayunviiriza eChinwa cha Nnamahanga n'oguchiyankirira n'obushagaluke. Aliko girhagwarha emizi omu mirhima yaabo, banagwarha obwemeezi omu gashanji kageeke n'amango emirhego yayinjaga banaleka obwemeezi. ");
INSERT INTO hav_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Embeke zarhogeraga omu mishaaki zishushanyizwe n'abantu bayunva eChinwa cha Nnamahanga. Aliko emilago, obuchire n'obuloke bw'akalamo byanabafundeeza, banafundwa kuyeeza amalehe makulire. ");
INSERT INTO hav_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Embeke zarhogeraga omu budaka bwinja, zishushanyizwe n'abayunva eChinwa cha Nnamahanga n'oguchibiika omu murhima mwinja gunakwiriire, n'omu guchihangaana banagwarha amalehe.» ");
INSERT INTO hav_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","«Omuntu arhakamala guchaana etara mpu aliyuubike kw'echintu changwa alihire omu ntalule. Aliko alihanika oku gikondo, y'abaaja omu nju baabona obumoleke. ");
INSERT INTO hav_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Kwenge ntaacho chibishirwe girhakabishuulwa, na ntaacho chijirirwe omu bwibisho girhakamenyikana n'okuleerhwa ahabonekeene. ");
INSERT INTO hav_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Muchilange okuntu muyunviriza; kwenge nji baaha ogwerhe; aliko orhagwerhe nji bamunyega chiro n'ehyakengereere oku agwerhe.» ");
INSERT INTO hav_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Nyina na beene baabo Yeesu bayinja emunda ali, aliko barhakagalire kumuyegeera elugulu w'abantu banene. ");
INSERT INTO hav_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Bantu baguma babwira Yeesu ntya: «Nyoko na beene benyu bayimangire ahambuga, bali bashonda gukulola.» ");
INSERT INTO hav_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Aliko abashubiza ntya: «Nyaama na beene beerhu, bali bantu bayunva eChinwa cha Nnamahanga n'okugihira omu bijiro.» ");
INSERT INTO hav_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Lusiku luguma, Yeesu aja omu bwarho haguma n'abigirizwa baage. Ababwira ntya: «Rhuyambukire eshiiriza w'enyanja.» Baava bagenda. ");
INSERT INTO hav_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Oku bali kugenda, Yeesu alyaama. Omulaba munene gwasuuka omu nyanja, obwarho bwalema bwarhoola amenji. Baliiri hoofu kuzika. ");
INSERT INTO hav_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Baava baja kumuchula, bamubwira ntya: «Mwigiriza, Mwigiriza, rhwafa!» Azuukire, akankamira omulaba n'ebivundu. Byarhuleera. Endeera yaba. ");
INSERT INTO hav_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Yeesu aja ababaza ntya: «Ngahe obwemeezi bwenyu buli?» Bayuubaha n'ogusoomerwa, baalema babwirana ntya: «Oyu ali nde? Y'arhegeka chiro omulaba n'amenji, byanamukenga.» ");
INSERT INTO hav_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Bagendekera n'olugenzi lwabo guhika omu gihugo ch'aBageraasi, chiloleene n'eche Galilaaya. ");
INSERT INTO hav_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yeesu abeere ayoomoka, muntu muguma w'ahoola ayinja embere zaage. Oyo muntu alifarhirwe n'abazimu. Gurhengera miira arhayambalaga emyambalo. Arhanabeeraga omu nju aliko oku mashinda. ");
INSERT INTO hav_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Abeere abona Yeesu, ashuurha olujamu, achikabula embere z'amagulu maage n'okuderha ntya n'omulenge munene: «Yeesu, Mugala wa Nnamahanga w'Elugulu Bweneene, chagarhuma wachiiheba omu byaani? Ngurhebereeze, orhandibuzaga!» ");
INSERT INTO hav_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Aliikaga omulenge ntyo kwenge Yeesu alirhegekere oyo muzimu okw'arhenge m'oyo muntu. Oyo muzimu abaaga anafarha oyo muntu siku zinene. Baliiri kumulanga ey'azirikirwe amaboko n'obulegule n'ebyuuma oku magulu. Aliko agendaga acha ebyo biziriko n'oguheekwa n'oyo muzimu omu mpinga. ");
INSERT INTO hav_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yeesu amubaza ntya: «Eziino lyawe we nde?» Ashubiza ntya: «Nyoono, nye Rhuli banene»; kwenge abazimu banene balimujiire mo. ");
INSERT INTO hav_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Abo bazimu bamuyinginga okw'arhabarhegekaga kuja ekuzimu. ");
INSERT INTO hav_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ahoola haliiri obuso bw'engulube zinene bwaliiri kulagirwa oku musozi. Abo bazimu barhebeereza Yeesu oku abayemereere baje mw'ezo ngulube. Abayemeerera ntyo. ");
INSERT INTO hav_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Bala bazimu barhenga m'oyo muntu, baja omu ngulube, n'obo buso booshi bwachima bwalibirha oku musozi, bwachiiroha omu nyanja n'okuzika. ");
INSERT INTO hav_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Abangere b'ezo ngulube babeere baabona ebyabeere, balibirha n'okuyandaaza ogo mwazi mw'echo gishagala chinene n'omu rhwango rhutureene ho. ");
INSERT INTO hav_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Abantu bayinja kulola ebyabeere. Baahika emunda Yeesu ali, bashigaana oyo muntu abazimu barhengaga mo ayikeere ahaburhambi bw'amagulu ma Yeesu, ey'ayambeere, anakola agwerhe obwenge booshi. Abantu bayuubaha. ");
INSERT INTO hav_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ababonaga ebyabaaga baabalira abandi gurhe oyo muntu waliiri mw'abazimu afumyagwa. ");
INSERT INTO hav_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Abantu booshi b'egihugo ch'aBageraasi baahema Yeesu arhenge emwabo, kwenge bali bafarhirwe n'obuuba bunene. Yeesu ava aja omu bwarho, achigalukira. ");
INSERT INTO hav_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Omuntu warhengagwa mw'abazimu arhebeereza Yeesu okw'agende haguma naye. Aliko Yeesu amulahirira, amubwira ntya: ");
INSERT INTO hav_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","«Ogaluke emwawe n'okubala byooshi Nnamahanga akujiriire.» Agenda, ayaamagaza omu gishagala chinene chooshi ebi Yeesu amujiriire byooshi. ");
INSERT INTO hav_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yeesu abeere agaluka eGalilaaya, ayankiirirwa n'abantu banene, kwenge baliiri kumulinga. ");
INSERT INTO hav_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ho n'aho haahulukira omuntu muguma oyirikwa Yaiiro. Aliiri mukulu w'esinagoogi. Achikabula hoofu n'amagulu ma Yeesu ey'ali kumurhebeereza oku aje emwage, ");
INSERT INTO hav_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","kwenge omwali w'echinege aliiri hoofu h'ogufa. Oyo mwali aligwerhe myaaka ekumi n'ebiri. Amango Yeesu aliiri kuja yo, abantu banene baliiri kumufundeeza bweneene. ");
INSERT INTO hav_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ahoola haliiri omukazi muguma w'alilwere gurhengera myaaka ekumi n'ebiri endwala y'okuva eshagama. Abaaga amalire ebikulo byaage byooshi oku bafumu, aliko ntaaye n'omuguma wagalire kumufumya. ");
INSERT INTO hav_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ayegeera enyuma za Yeesu, n'oguhuma oku mushoojo gw'efulema yaage. Ho n'aho, okuva kwage kw'eshagama kwahwa. ");
INSERT INTO hav_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yeesu abaza ntya: «Nde wampumire ko?» Abantu booshi bahakana. Petero aja amubwira ntya: «Mwigiriza, abantu banene yi bagufundeeza n'okugushunika!» ");
INSERT INTO hav_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Aliko Yeesu aderha ntya: «Hali omuntu wampumire ko. Nyoono menyere bwinja oku hali emisi yantengere ko.» ");
INSERT INTO hav_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Oyo mukazi abeere abona okw'amenyikeene, ayinja adirhimana guchikabula hoofu n'amagulu ma Yeesu. Achirhondoola embere z'abantu booshi echarhumaga amuhuma ko na gurhe afumaga ho n'aho. ");
INSERT INTO hav_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yeesu amubwira ntya: «Mwali waani, obwemeezi bwawe bwagufumize; ogende n'omurhuula.» ");
INSERT INTO hav_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Oku Yeesu achiri aderha, hagera omuntu warhengera emw'ola mukulu w'esinagoogi. Abwira oyoola mukulu ntya: «Mwali waawe afiire, orhagishiibaga walunza oMwigiriza.» ");
INSERT INTO hav_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Aliko Yeesu abeere abiyunva, abwira Yaiiro ntya: «Orhayuubahaga, yemeera konyine, mwali waawe afuma.» ");
INSERT INTO hav_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Yeesu agerere emwa Yaiiro, arhayemeeraga omuntu aja omu nju haguma naye arhali Petero, Yohaana na Yakobo, haguma n'eshe na nyina w'oyo mwana. ");
INSERT INTO hav_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Abantu booshi balemaga balira n'okulumwa elugulu w'oyo munyere. Aliko Yeesu aderha ntya: «Murhaliraga, arhafiire, ahuubwe alyaamire!» ");
INSERT INTO hav_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Boowe bamushekera, eyi bayinji okw'oyo munyere afiire. ");
INSERT INTO hav_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Aliko amufarhira oku kuboko n'okuderha ntya n'omulenge munene: «Mwana waani, zuuka!» ");
INSERT INTO hav_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Omuuka gwage gwagaluka, ho n'aho ayimanga. Yeesu arhegeka oku bamuhe ebiryo. ");
INSERT INTO hav_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Abazeere b'oyo munyere basoomerwa. Aliko Yeesu abarhegeka oku ntaaye babwirage ebyabeere. ");
INSERT INTO hav_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yeesu ahamagala entumwa zaage ekumi n'ebiri aziheereza obuhashe n'oburhegesi b'ogukuula abazimu booshi n'ogufumya endwala. ");
INSERT INTO hav_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Azirhuma kuyigiriza enyigirizo ziyerekeere obwime bwa Nnamahanga n'ogufumya abalwala. ");
INSERT INTO hav_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Abwira ezo ntumwa ntya: «Ntaacho muchiyikirage omu lugenzi lwenyu: ebe nkoni changwa eshaho, bibe biryo changwa efuranga, na ntaaye oheekage simiisi ebiri. ");
INSERT INTO hav_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Enju nji babayankirira mo, muyibeere mo kugera amango nji mwaja ahandi. ");
INSERT INTO hav_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ngasi hantu abantu nji balahira kubayankirira, murhenge omu gishagala chaabo munakunguurhe olujuchu lw'amagulu menyu. Okoola kuli kubayeereka oku Nnamahanga nj'abahana.» ");
INSERT INTO hav_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ezo ntumwa zagenda, zarhondera kulenga omu ngasi gishagala. Zaliiri kuyigiriza oMwazi Mwinja n'ogufumya abalwala ngasi hooshi. ");
INSERT INTO hav_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Heroode, murhegesi w'eGalilaaya, abeere ayunva byooshi biri byaagera, abula olwimango. Kwenge baguma baliiri kuderha mpu Yohaana afuukire gurhenga omu bafu. ");
INSERT INTO hav_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Abandi bantu balemaga baderha mpu Eliya yi wagalukire. Abandi balemaga baderha mpu muguma omu baleebi ba miira yi wafuukire. ");
INSERT INTO hav_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Aliko Heroode aderha ntya: «Nyoono nye naderhaga bache Yohaana erhwe. Ye nde oyu naye ndi nayunva baderha ebintu biri ntya elugulu waage?» Byaarhuma Heroode naye ashonda kubona Yeesu. ");
INSERT INTO hav_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Entumwa zagaluka emunda Yeesu ali zanamubwira byooshi zajiraga. Aziheeka ahantu harhali lwamo oku lunda luyerekeere egishagala ch'eBetesayida. ");
INSERT INTO hav_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Abantu banene babeere bamenya okw'ajiire yo, bamukulikira. Yeesu abayankirira. Alema ababwira ebinwa biyerekeere obwime bwa Nnamahanga, anafumya abantu bali bakeneere ogufuma. ");
INSERT INTO hav_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ezuuba lyarhondeere kuzika, entumwa ekumi n'ebiri zaja zayegeera Yeesu n'okumubwira ntya: «Galula aba bantu yi baja emunda balaala, yi banabona ebiryo omu bishagala n'omu mizi ya hoofu, kwenge rhuli omu mpinga.» ");
INSERT INTO hav_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Aliko Yeesu abwira entumwa zaage ntya: «Mubahe mwenyine ebi baalya!» Entumwa zaderha ntya: «Rhugwerhe migati erhaano yonyine n'efi ebiri. K'oshondere rhwenyine rhuje kugula ebiryo by'aba bantu booshi?» ");
INSERT INTO hav_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","N'obo haliiri hoofu nka balume bihumbi birhaano. Yeesu abwira abigirizwa baage ntya: «Mubayikaze bigusho-bigusho by'abantu makumi marhaano.» ");
INSERT INTO hav_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Abigirizwa baajira ntyo, babayikaza booshi. ");
INSERT INTO hav_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yeesu arhoola ela migati erhaano na zila fi ebiri, ayerekeza ameesho empingu, abigisha. Yeesu ava abichagulanga, anarhondera abiha abigirizwa baage yi babigabira abantu. ");
INSERT INTO hav_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Abantu booshi baalya banayuugurha. Abigirizwa baheeka rhurhanda ekumi na rhubiri rhw'ebichiira byasigalaga. ");
INSERT INTO hav_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Lusiku luguma eyi Yeesu ali asaliira aharhali abantu, eyi n'abigirizwa baage bachigushire haguma naye, Yeesu ababaza ntya: «Abantu bali kuderha oku nye nde?» ");
INSERT INTO hav_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Abigirizwa bashubiza ntya: «Baguma yi baderha oku we Yohaana Mubatiiza; n'abandi mpu we Eliya, abandi mpu oli muguma w'omu baleebi ba miira wafuukire.» ");
INSERT INTO hav_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Yeesu abaza abigirizwa baage ntya: «Aliko si, nenyu muderha oku nye nde?» Petero ashubiza ntya: «Wooyo oli Krisitu wa Nnamahanga.» ");
INSERT INTO hav_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yeesu abuza abigirizwa baage oku ntaaye babwirage ebyoola. ");
INSERT INTO hav_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ashuba kuderha oku bihemere Mwene oMuntu alibuke bweneene, alahirwe n'abashamuka b'aBayaahudi, abakulu b'abadaahwa n'abigiriza b'amarhegeko, ayirhwe n'olusiku lwa gasharhu afuuke. ");
INSERT INTO hav_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Yeesu aja abwira abantu booshi ntya: «Akaba hali oshondere kunkulikira, achilahire yenyine, aheeke omusalaaba gwage ngasi lusiku, anankulikire. ");
INSERT INTO hav_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Bulaala, owashonda guchungula akalamo kaage, agaheza; sy'aliko owaheza akalamo kaage eyi nye ntumire, agachungula. ");
INSERT INTO hav_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Gichi bimaliire omuntu okugwarha ebikulo by'egulu lyooshi, aliko aheze akalamo kaage? Ntaacho! ");
INSERT INTO hav_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Nk'omuntu anyunviire eshoni, anaziyunvire emyaazi yaani, Mwene oMuntu naye nj'amuyunvira eshoni hano nj'agaluka omu bukuuze bwage, bo na bukuuze bw'Eshe na bwa bamalahika batagatiifu. ");
INSERT INTO hav_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Mbabwirire okuli: Baguma omu bali hano barhaafa embere babone obwime bwa Nnamahanga.» ");
INSERT INTO hav_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Enyuma w'esiku zakagera ku munaane Yeesu aderhere ntyo, arhoola Petero, Yohaana na Yakobo; azamuukira oku musozi guhema Nnamahanga. ");
INSERT INTO hav_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Abeere ali ahema, eshusho ly'amalanga maage lyahindamuka, n'emyambalo yaage yaba mweru bweneene n'okubaraganya. ");
INSERT INTO hav_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ho n'aho haboneka bantu babiri bali kuganiira naye: baliiri Muusa na Eliya, ");
INSERT INTO hav_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","babonekana omu bukuuze gurhenga emwa Nnamahanga. Baalema baganiira haguma na Yeesu ebiyerekeere okugenda kwage kwali kwaneene kuyenerera eYerusaleema. ");
INSERT INTO hav_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Mwamo mango, Petero n'abaabo baliiri ero bweneene. Basisimukire, baabona obukuuze bwa Yeesu na bala balume babiri baliyimangire haguma naye. ");
INSERT INTO hav_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Muusa na Eliya babeere bali balekana na Yeesu, Petero amubwira ntya: «Mwigiriza, kuli kwinja rhubeere hano. Rhwayumbaka biraaro bisharhu: chiguma chaawe, echindi cha Muusa n'echindi cha Eliya.» Petero arhalimenyere ebyaliiri kuderha. ");
INSERT INTO hav_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Petero abeere ali aderha ntyo, oluhomo lwayinja lwanabashukulira n'egichuuchu chaalo. Abigirizwa babeere baabona oluhomo lwabashukulira, bayuubaha. ");
INSERT INTO hav_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Omulenge gwayunviikana m'olo luhomo: «Oyuula ye Mugala waani nachishogere. Mumuyunve!» ");
INSERT INTO hav_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Enyuma w'ogo mulenge okuyunviikana, Yeesu obonekana ali yenyine. Abigirizwa baasira, na ntaaye babwirire chintu, mwamo mango, oku bibabonaga ko ahoola. ");
INSERT INTO hav_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Olusiku lwakulikiraga, Yeesu na balaala bigirizwa basharhu aliiri nabo, barhenga oku musozi. Abantu banene bayinja gushigaanana na Yeesu. ");
INSERT INTO hav_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Omuntu muguma ayaamira ntya ahagarhi k'abantu: «Mwigiriza, nkuyingingire, ondolere ono mugala waani, kwenge ali w'echinege. ");
INSERT INTO hav_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Hali omuzimu onamufarha, ho n'aho anamuyamiisa olujamu, anamudirhimanya bweneene, anamukuliisa olufula omu buunu, n'ogurhamurhenga mo juba, n'okumuleka eyi amamuvunangula. ");
INSERT INTO hav_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nayingingire abigirizwa baawe bakuule oyo muzimu, aliko barhagalaga.» ");
INSERT INTO hav_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yeesu aderha ntya: «Mwe gisisi chibi na chizira bwemeezi, kugera mango machi nabeera haguma nenyu n'okubalembera? Leerha mugala waawe hano.» ");
INSERT INTO hav_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Omwana abeere ali ayegeera Yeesu, ola muzimu amubanda ahashi n'ogurhondera kumudirhimanya. Aliko Yeesu akalihira oyo muzimu, afumya omwana n'okumugalulira eshe. ");
INSERT INTO hav_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Abantu booshi basoomererwa obuhashe bunene bwa Nnamahanga. Oku booshi bali basoomererwa byooshi Yeesu ali ajira, abwira abigirizwa baage ntya: ");
INSERT INTO hav_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«Muyunve bwinja ebi nashonda kubabwira: Mwene oMuntu ayinja guhanwa omu fune z'abantu.» ");
INSERT INTO hav_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Aliko abigirizwa barhayunvaga echi chinwa, eby'echi chinwa chiderhere byalibishirhwe y'abigirizwa barhamenyaga echi chiderhere. Baanali bayuubahire kubaza Yeesu ebiyerekeere echi chinwa. ");
INSERT INTO hav_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Haahulukira obuhaka omu bigirizwa b'ogushonda kumenya nde oli mukulu omu bo. ");
INSERT INTO hav_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yeesu walimenyere obukengeere bw'emirhima yaabo, arhoola omwana murho, amuhira eburhambi bwage. ");
INSERT INTO hav_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ababwira ntya: «Oyankiriire oyu mwana oku ziino lyaani anyankiire nyenyine. N'onyankiriire ayankiriire owantumaga. Bulaala oli mudoorho omu mweshi oyo yeeri mukulu kulusha.» ");
INSERT INTO hav_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yohaana ava aderha ntya: «Mwigiriza, rhwabonaga omuntu oli akuula abazimu oku ziino lyaawe. Rhwamubuza bulaala arhagukulikira haguma neerhu.» ");
INSERT INTO hav_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yeesu amushubiza ntya: «Murhamubuzaga, bulaala orhali mushombanyi wenyu ey'ali wenyu.» ");
INSERT INTO hav_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Esiku Yeesu alikwaneene guheekwa omu mpingu zabeere zaaba hoofu, Yeesu ahiga bweneene kuja eYerusaleema. ");
INSERT INTO hav_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Arhuma ab'okubala emyaazi embere zaage. Bagenda n'okuja omu gishagala chiguma ch'aBasamariya kumurheganyiza eby'obulagiirire byooshi. ");
INSERT INTO hav_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Aliko aBasamariya balahira kumuyankirira bulaala aliiri ayerekera eYerusaleema. ");
INSERT INTO hav_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Abigirizwa ba Yeesu, Yakobo na Yohaana babeere bamenya ntyo, baderha ntya: «Nnaweerhu, k'oshondere rhubwire omuliro guchime gurhenga empingu kubasingonyola?» ");
INSERT INTO hav_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Yeesu abahindamukira n'okubakalihira. ");
INSERT INTO hav_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Baava baja omu chindi gishagala. ");
INSERT INTO hav_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Babeere bali omu njira, omuntu muguma abwira Yeesu ntya: «Nagukulikira ngasi hooshi waaja.» ");
INSERT INTO hav_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yeesu amubwira ntya: «Emitereri ejira enkunda n'enyunyi z'omu chaalege zijira enyogo, sy'aliko Mwene oMuntu arhajira ahagahengeka erhwe lyaage.» ");
INSERT INTO hav_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yeesu abwira owindi ntya: «Onkulikire.» Aliko oyo muntu aderha ntya: «Nnaweerhu, onyemereere ntange nje guhamba daarha.» ");
INSERT INTO hav_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yeesu amushubiza ntya: «Oleke abafu bahambe abafu baabo; wooyo ogende, oje kuyaamagaza oBwami bwa Nnamahanga.» ");
INSERT INTO hav_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Owindi muntu abwira Yeesu ntya: «Nnaweerhu, handeke nagukulikira, sy'aliko onyemereere ntange nje guseezera ab'emwani.» ");
INSERT INTO hav_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yeesu amubwira ntya: «Omuntu wamarhondera guhinga akanashuba kulola enyuma, arhakwaneene omu Bwami bwa Nnamahanga.» ");
INSERT INTO hav_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Enyuma w'ebyoola, Nnaweerhu achishoga bandi bigirizwa makumi gali mushanvu na babiri. Abarhuma babiri-babiri bamurhange omu gishagala chooshi na ngasi hooshi alikwaneene kuja. ");
INSERT INTO hav_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Yeesu ababwira ntya: «Emyaaka y'ogushaluula elugire, sy'aliko abakozi bageehere. Leero, muheme nyina emyaaka arhume abakozi kuyishaluula. ");
INSERT INTO hav_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Mugende! Mbarhumire nka byaanabuzi ahagarhi ka banyambwe. ");
INSERT INTO hav_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Murhaheekaga chiro lufuranga, changwa eshaho, changwa ebindi biraato. Na ntaaye mulamusage omu njira. ");
INSERT INTO hav_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Omu ngasi nju nji mwaja mo, murhange muderhe ntya: ‹Omurhuula gube kw'eyi nju!› ");
INSERT INTO hav_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Akaba omoola muli omuntu oshondere omurhuula, ogo murhuula gwenyu gwanamubeera ko; n'akaba nanga, omurhuula gwenyu gwanabagalukira. ");
INSERT INTO hav_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Mubeere mw'eyoola nju, mulye munanywe ebi nji baabaha, kwenge omukozi akwaneene omukamarho gwage. Murhazereeraga omu maju. ");
INSERT INTO hav_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Na ngasi gishagala nji mwaja mo, bakabayankirira, mulye ebi nji baabaha. ");
INSERT INTO hav_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Mufumye abalwala nji baaba mo, munababwire ntya: ‹Obwime bwa Nnamahanga bwabayegereere.› ");
INSERT INTO hav_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Aliko, omu ngasi gishagala nji mwaja mo nji bakalahira kubayankirira, mugende omu njira zaacho munababwire ntya: ");
INSERT INTO hav_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‹Rhubakungurhiire olujuchu lw'egishagala chenyu lwali lunaniirire oku magulu meerhu, lo lubaage buhamiiriza bw'amabi menyu. Aliko mumenye k'obwime bwa Nnamahanga bwabayegereere.› ");
INSERT INTO hav_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Mbabwirire oku m'olo lusiku nji byayoolohera Sodoomo kulusha echoola gishagala.» ");
INSERT INTO hav_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","«Buhanya buchi oku wooyo gishagala ch'eKoraziini! Buhanya buchi oku wooyo gishagala ch'eBetesayida! Akaba ebisomereene byajirikeene emwenyu byakajirikeene eTiiro n'eSidoona, singa hamaagera siku zinene abantu b'eyoola balekere ebyaaha byaabo, singa bayambeere ebigunira n'okuyikala omu luvu! ");
INSERT INTO hav_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Cho charhuma, olusiku l'ogucha olushinja nji byayoolohera Tiiro na Sidoona kubalusha mwabo. ");
INSERT INTO hav_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Nawe gishagala ch'eGaperinaumu, k'omenyere mpu nji wazamuulwa guhika echaalege? Nangwa da! Nji wayandagazwa guhika ekuzimu. ");
INSERT INTO hav_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Obayunviriize eyi nyoono ny'ayunviriize, obalahiire eyi nyoono ny'alahiire, n'ondahiire eyi alahiire owantumaga.» ");
INSERT INTO hav_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Abigirizwa makumi gali mushanvu na babiri bagaluka n'obushagaluke n'okuderha ntya: «Nnaweerhu, n'abazimu nabo yi barhukenga amango rhuli rhwabarhegeka oku ziino lyaawe.» ");
INSERT INTO hav_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yeesu ababwira ntya: «Nabonaga Shetaani arhoga gurhengera omu chaalege nka mubaraganyo. ");
INSERT INTO hav_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Muyunve bwinja: nabaheere oburhegesi b'okulabarha enjoka n'engobe, n'ogusinyongola obuhashe booshi bw'mushombanyi, na ntaacho nji chabajira kubi. ");
INSERT INTO hav_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Sy'aliko murhasiimaga kwenge abazimu bali babayunva; ahuubwe musiime okuba amaziino menyu mayandikirwe omu mpingu.» ");
INSERT INTO hav_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Mw'ako gashanji, Yeesu ayunjuzwa obushagaluke kugerera Muuka-Mutagatiifu, aderha ntya: «Daarha wee, Nnaweerhu w'omu mpingu n'omu gulu, ngusimiriize kwenge ebi bintu wabibishire abanyabwenge n'abahanga, wanabibishuulira abaana badoorho. Neechi Daarha, bulaala ntyo ku walisimiisizwe. ");
INSERT INTO hav_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Daarha ampeere byooshi. Ntaaye onyinji nyoono Mugala nk'arhali Daarha yenyine, na ntaaye oyinji Daarha nk'arhali oMugala na ngasi yeeshi oMugala ashondere amumenye.» ");
INSERT INTO hav_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Yeesu ahindamukira abigirizwa baage, ababwirira ntya eburhambi: «Magishirwe ameesho mali maabona ebi muli mwabona! ");
INSERT INTO hav_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Bulaala, mbabwirire oku, baleebi banene n'abaami banene bali bashondere kubona ebi mwabo muli mwabona, aliko barhabibonaga ko. Bashondere kuyunva ebi mwabo muli mwayunva, aliko barhabiyunvaga ko.» ");
INSERT INTO hav_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Buzinda bw'ebi, mwigiriza muguma w'amarhegeko ayimanga n'okubaza Yeesu ntya omu kumurhega: «Mwigiriza, bichi nkwaneene kujira yi mbona akalamo k'esiku n'amango?» ");
INSERT INTO hav_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yeesu amushubiza ntya: «Bichi biyandikirwe omu Rhegeko? Gurhe oliyunva eyi walisoma?» ");
INSERT INTO hav_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Omwigiriza w'amarhegeko ashubiza ntya: «Osiime Nnaweerhu Nnamahanga waawe n'omurhima gwawe gooshi, n'emisi yaawe yooshi n'obwenge bwawe bwooshi. Kandi: Osiime n'omutuuranyi waawe nka okw'ochisiima wenyine.» ");
INSERT INTO hav_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yeesu aja amubwira ntya: «Washubiize bwinja. Ojire ebyoola oderhere, nji waalama.» ");
INSERT INTO hav_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Aliko yeewe ashonda kuyeerekana okw'akwaneene. Abaza Yeesu ntya: «Omutuuranyi waani ye nde?» ");
INSERT INTO hav_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yeesu ashuba kumubwira ntya: «Haliiri muntu muguma warhengaga eYerusaleema guchimira eYeeriko. Abeere ali omu njira, abugaanana n'ebishumuusi. Byamunyega byooshi aligwerhe, bamushuurha banagenda eyi bamulekere nka mufu. ");
INSERT INTO hav_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Haahulukira omudaahwa muguma wachimaga mw'eyo njira, abeere abona oyo muntu, achigerera oku lwindi lunda lw'enjira, naye achigendera. ");
INSERT INTO hav_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","oMulaawi muguma naye agera ahoola, abona oyo muntu, achigerera oku lwindi lunda lw'enjira, anachigendera. ");
INSERT INTO hav_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Aliko, oMusamariya muguma waliiri lugenzi, ahika hoofu naye. Amubwene, amubeera obonjo. ");
INSERT INTO hav_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ashegera aha ali, amushomoola ebibihulu omu kubisheeshera kw'amavurha n'edivaayi, abirhuba n'ebiraka. Amubarhulira oku ndogomi yaage, amuheeka omu nju y'abagenzi, anamulanga. ");
INSERT INTO hav_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Eseezi ly'aho, oyo Musamariya akuula dinaari ebiri omu shaho yaage, aziheereza nyina enju y'abagenzi n'okuderha ntya: ‹Obuke bwinja oyu muntu. Hano ngaluka, nakujuha nyenyine ebindi byooshi waaba wakoleeseze k'oyu muntu.›» ");
INSERT INTO hav_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yeesu aja abaza ntya ola mwigiriza w'amarhegeko: «Nd'obwene mw'aba bantu basharhu walibeere mutuuranyi w'oyu muntu wabugaananaga n'ebishumuusi?» ");
INSERT INTO hav_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Omwigiriza w'amarhegeko ashubiza ntya: «Ola muntu wamubeeraga obonjo.» Yeesu amubwira ntya: «Genda, nawe ojire ntyo.» ");
INSERT INTO hav_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Oku Yeesu n'abigirizwa baage bali omu njira, Yeesu aja omu gishagala chiguma. Omukazi oyirikwa Marita amuyankirira. ");
INSERT INTO hav_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Oyo Marita aligwerhe mwene waabo oyirikwa Mariya. Oyo Mariya ayikala embere za magulu ma Nnaweerhu, aliiri ayunviriza eChinwa chaage. ");
INSERT INTO hav_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Aliko Marita yeewe aliiri gukola orhwasi rhunene. Ahulukira n'okuderha ntya: «Nnaweerhu, ka birhakulunzize kubona mwene weerhu andekere gukola orhwasi rhooshi nyenyine? Omubwire angwase maani.» ");
INSERT INTO hav_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Nnaweerhu amushubiza ntya: «Marita, Marita, oli wachilunza n'oguchikobola na bintu binene. ");
INSERT INTO hav_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Hali chintu chiguma chonyine ch'obulagiirire. Mariya yeewe achishogere echintu gikwiriire, girhakamunyagwa.» ");
INSERT INTO hav_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Lusiku luguma, Yeesu aliiri hantu haguma ey'ali gusaliira. Abeere amala gusaliira, muguma omu bigirizwa baage amubwira ntya: «Nnaweerhu, orhuyigirize gusaliira nk'oku Yohaana ayigirizaga abigirizwa baage.» ");
INSERT INTO hav_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yeesu ababwira ntya: «Nka mwasaliira, mugende mwaderha ntya: ‹Daarha, eziino lyawe likuuzwe, obwime bwawe buyinje. ");
INSERT INTO hav_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Orhuhe ebiryo byeerhu bya ngasi lusiku. ");
INSERT INTO hav_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Orhubabalire ebyaaha byeerhu, bulaala neerhu rhubabalira abarhujirira amabi. Orhanagenda warhuleka rhwarhogera omu chigeregezo.›» ");
INSERT INTO hav_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Yeesu ashuba kubwira abigirizwa baage ntya: «Nde omu mwabo wakagwarha mwira waage, akaja emwage ahagarhi k'obudufu kumubwira ntya: ‹Mwira waani, ompoze migati esharhu, ");
INSERT INTO hav_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","bulaala muguma omu beera baani ahikire ahamwani gurhengera omu lugenzi na ntaacho ngwerhe namusheegera.› ");
INSERT INTO hav_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Akaba owabo omushubiize ntya ey'anali omu mwage: ‹Leka okumbera erhwe; olunvi lwachingirwe miira, nyoono n'abaana baani, rhwalyaamire. Ntakagala kuzuuka mpu nguhe emigati.› ");
INSERT INTO hav_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Okuli mbabwirire, chiro akaba arhazuukire kumuha emigati bulaala ali mwira waage, azuuka bulaala mwira waage arhaluhire kumuyinginga, anamuha byooshi alagiriire. ");
INSERT INTO hav_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","«Bobunoola nyoono mbabwirire ntya: Muheme, mwanahaabwa; mushonde, mwanabona; mukongoorhe oku lunvi, mwanachinguulirwa. ");
INSERT INTO hav_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Bulaala ohema ahaabwa, oshonda abona n'okongoorha oku lunvi achinguulirwa. ");
INSERT INTO hav_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Nde y'eshe w'omwana omu mwabo nk'omugala amuhemere efi, akamuha enjoka ahaali h'efi? ");
INSERT INTO hav_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Changwa, nk'amuhemere egi, akamuha engobe? ");
INSERT INTO hav_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Akaba mwabo, mwe bantu babi, muyinji guha abaana benyu ebintu binja, gurhe Daarha w'empingu ojira olukogo lunene kulusha agafundwa guhaana Muuka-Mutagatiifu oku bamuhemere ye?» ");
INSERT INTO hav_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Lusiku luguma, Yeesu aliiri gukuula omuzimu wajiraga omuntu muguma kuba nyamugama. Omuzimu abeere ahuluka, nyamugama arhondera kuderha. Abantu banene baliiri ahoola basoomerwa bweneene. ");
INSERT INTO hav_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Aliko bantu baguma baderha ntya: «Yeesu ali akoleesa Belizebuuli, mukulu w'abazimu, omu guhulusa abazimu.» ");
INSERT INTO hav_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Abandi bantu nabo baarhega Yeesu omu kumuhema echimenyeeso ch'ogurhengera empingu. ");
INSERT INTO hav_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Aliko, Yeesu alimenyere enkengeero zaabo, ababwira ntya: «Obwami buchishandeeze bonyine, bujiire ebw'olufu lwabo; enju zaabo zanahenera mo ziguma oku zindi. ");
INSERT INTO hav_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Akaba leero Shetaani ali achilwisa yenyine, gurhe obwami bwage bwakalama, kwenge muli mwaderha mpu nyoono ndi nakoleesa Belizebuuli omu guhulusa abazimu? ");
INSERT INTO hav_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","N'akaba ndi nahulusa abazimu kugerera Belizebuuli, abaana benyu babahulusa kugerera nde? Chi nji charhuma bonyine nji baaba bazuuzi benyu. ");
INSERT INTO hav_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Aliko, akaba ndi nahulusa abazimu kulengera obuhashe bwa Nnamahanga, k'okuderha k'obwime bwage bwabahikiire. ");
INSERT INTO hav_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Omuntu w'emisi ohagarhiire emitwaro yaage, amango ali alanga enju yaage, ebikulo byaage eyi bilangirwe bwinja. ");
INSERT INTO hav_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Aliko, akaba omulushire emisi agahulukira n'okumuhima, akamunyega emitwaro yaage yooshi alilangaliire; na ntyo anagabira abandi bantu ebintu amunyegaga. ");
INSERT INTO hav_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Omuntu orhali haguma naani eyi ali andwisa; n'omuntu orhangwasa kugusha eyi ali ashandaaza.» ");
INSERT INTO hav_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","«Amango omuzimu arhengere omu muntu, anaja omu mpinga gushonda amahumuukiro. Na nk'amabulire, anaderha ntya: ‹Nkola kugaluka omu nju yaani, mula narhengeraga.› ");
INSERT INTO hav_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ey'ayigera mo, anayibugaana ehyagiirwe enarheganyizwe bwinja. ");
INSERT INTO hav_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Leero, anaja agenda gushonda bandi bazimu mushanvu babi kumulusha. Baanaja mo n'okubeera mo. Oboorhere b'oyo muntu bwanaba bubi kulusha obwambere.» ");
INSERT INTO hav_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yeesu abeere ali aderha ntyo, omukazi muguma mw'abo bantu banene aderha n'omulenge munene n'okumubwira ntya: «Enda yaguheekaga egishwe n'amabeere makuyonsaga!» ");
INSERT INTO hav_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Aliko Yeesu ashubiza ntya: «Ahuubwe, bagishirwe abali bayunva eChinwa cha Nnamahanga n'ogukulikira cho.» ");
INSERT INTO hav_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Abantu banene babeere bali bachiigusha, Yeesu arhondera kuderha ntya: «Echi gisisi chiri gisisi chibi: chiri chashonda echimenyeeso. Girhagahaabwa echindi chimenyeeso kuleka echa Yoona. ");
INSERT INTO hav_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Kwenge nka kulaala Yoona abaaga chimenyeeso oku bantu b'eNinaawi, ko n'oko Mwene oMuntu aba chimenyeeso kw'echiila gisisi. ");
INSERT INTO hav_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Olusiku l'ogucha olushinja, omugoli w'egarhongo nj'ahulukira haguma n'abantu b'echi gisisi. Nj'abahaniisa, bulaala alirhengere omu mahanga ma hale kuja kuyunva ebinwa by'obwenge bunene bwa Solomoono. N'obo hanoola hali olushire Solomoono! ");
INSERT INTO hav_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Amango m'ogucha olushinja, abantu b'eNinaawi nabo nji bayimanga haguma n'abantu b'echi gisisi, n'okugihaniisa. Kwenge balekere ebyaaha byaabo amango Yoona ayamagazaga omwazi. Leero hanoola hali olushire Yoona.» ");
INSERT INTO hav_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","«Ntaaye ochaana etara mpu alihire ahabishirwe changwa omu garhanda; ahuubwe analihanika oku gikondo, y'abaaja omu nju baabona obumoleke. ");
INSERT INTO hav_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Eliisho lyawe ly'etara ly'omubiri gwawe. Nk'eliisho lyawe likwiriire, omubiri gwawe gooshi nago gukolezeezwe. Aliko nk'alibiihire, omubiri gwawe nago eyi guli omu mwizimya. ");
INSERT INTO hav_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ochilange obumoleke bukuli mo burhaba mwizimya. ");
INSERT INTO hav_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Akaba leero omubiri gwawe gooshi gukolezeezwe, buzira kugwarha olunda n'oluguma omu mwizimya, omubiri gwawe gooshi nji gwaba gukolezeezwe kuguma n'amango etara likukoleezeza n'obumoleke bwalyo.» ");
INSERT INTO hav_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Oku Yeesu ali aderha, oMufarisaayo muguma amulaalika emwage mpu aje kulya. Yeesu aja omu nju, ayikala n'okulya. ");
INSERT INTO hav_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Oyo Mufarisaayo asoomerwa okubona Yeesu alya buzira gukalaba. ");
INSERT INTO hav_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Aliko Nnaweerhu amubwira ntya: «Mwabo mwe Bafarisaayo muzigaana gucheesa emugongo w'engumbu n'embale, n'obo omu mirhima yenyu muyunjwire obushumuusi n'obubi. ");
INSERT INTO hav_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Mwe binganyi! Owalemaga omubiri g'omuntu k'arhanali ye walemaga omurhima? ");
INSERT INTO hav_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Aliko mwabo, muhaane n'omurhima g'obonjo ebiri omu mirhima yenyu, n'ebindi byooshi byacheeswa emwenyu. ");
INSERT INTO hav_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","«Aliko buhanya buchi emwenyu, mwe Bafarisaayo! Munahaana entuulo y'echigabi chiguma ch'ekumi ch'ebirhi by'obulunge n'echa ngasi buuko bw'eshogo, aliko mwanagenda mwakeneereza kujira ebijiro bikwaneene n'obuzigire bwa Nnamahanga! Ebyoola bimwali mukwaneene kujira, buzira kuleka ebindi. ");
INSERT INTO hav_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","«Buhanya buchi emwenyu, mwe Bafarisaayo! Musiima kuyikala oku bichumbi by'embere omu masinagoogi, munasiima abantu babalamuse n'obukenge omu soko! ");
INSERT INTO hav_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","«Buhanya buchi oku mwabo! Muli nka shinda zirhagwerhe chimenyeeso, abantu banazilambagira ko buzira kumenya!» ");
INSERT INTO hav_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Muguma omu bayigiriza amarhegeko ava aderha ntya: «Mwigiriza, omu kuderha ntyo, orhudukangire neerhu!» ");
INSERT INTO hav_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yeesu amushubiza ntya: «Buhanya buchi oku mwabo nenyu bigiriza b'amarhegeko! Muheesa abantu emizigo ekomeere guheeka, nenyu mwenyine murhakanayihuma ko n'omudoke! ");
INSERT INTO hav_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","«Buhanya buchi oku mwabo! Muyumbaka bwinja eshinda z'abaleebi n'obo bashookuluza benyu bababayirhaga! ");
INSERT INTO hav_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Omu kujira ntyo, muyerekeene oku muyemereere ebijiro bya bashookuluza benyu, bulaala boowe bo bayirhaga abaleebi, nenyu yi mwayumbaka eshinda zaabo! ");
INSERT INTO hav_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Cho girhumire Nnamahanga omu bwenge bwage bunene aderhere ntya: ‹Nabarhumira abaleebi n'entumwa. Bayirha baguma n'okulibuza abandi.› ");
INSERT INTO hav_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Cho girhumire echi gisisi nji chaabazwa eshagama yasheeshwaga y'abaleebi booshi gurhengera okulemwa kw'egulu, ");
INSERT INTO hav_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","gurhengera oku shagama ya Abeeli kugera oku shagama ya Zakariya, wayirhwaga ahagarhi k'entuuliro n'ahantu hatagatiifu. Neechi, mbabwirire byo, echi gisisi nji chabazibwa byooshi. ");
INSERT INTO hav_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","«Buhanya buchi oku mwabo bigiriza b'amarhegeko! Mwakuulire olufunguulo loguchingula omulyango g'okuja omu nju y'okuyigira m'okumenya Nnamahanga. Nenyu mwenyine murhajaaga mo, n'abashondaga kuja mo, mwababuza.» ");
INSERT INTO hav_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yeesu ayuusize gurhenga ahoola, abigiriza b'amarhegeko n'aBafarisaayo barhondera kumulunza bweneene n'okumubaza oku biyerekeere bintu binene, ");
INSERT INTO hav_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","bashonda kumurhega, yi baabona echinwa chagarhuma bamusidaaka. ");
INSERT INTO hav_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Amo mango, abantu banene bachigusha bihumbi n'ebihumbi, oku bulyo baalema baalabarhana. Yeesu arhanga kubwira abigirizwa baage ntya: «Muchilange n'echachu y'aBafarisaayo, k'okuderha obulyaalya. ");
INSERT INTO hav_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","«Ntaacho gishukuliirwe girhagashukuulwa, na ntaacho chibishirwe girhakamenyekana. ");
INSERT INTO hav_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Cho girhumire ngasi byooshi mwaderhere omu mwizimya nji byayunviikana ezuuba lyakola. Echi mwabohereeze omu gurhwi ebusiika, nji chayaamagazizwa oku nju elugulu. ");
INSERT INTO hav_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","«Mwe beera baani, mbabwirire byo: murhayuubahaga abantu bayirha omubiri, na nta chindi bakanachigala kujira enyuma z'aho. ");
INSERT INTO hav_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Nkola nabayeereka nde mukwaneene kuyuubaha. Muyuubahe Nnamahanga, yegwerhe obuhashe b'okuyirha n'ogukabula omu hantu h'amalibuko manene. Neechi, mbabwirire byo, oyoola yi muhemerwe kuyuubaha. ");
INSERT INTO hav_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ka barhaguza nyunyi erhaano z'ebishwa oku bicheri bibiri? Aliko, chiro nta nguma omu zo eyibiriirwe na Nnamahanga. ");
INSERT INTO hav_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","N'enviiri z'amarhwe menyu zooshi ziganjirwe. Leero, murhayuubahaga chiro; mugwerhe akamaro kanene kulusha ebishwa binene.» ");
INSERT INTO hav_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","«Mbabwirire byo: ngasi yeeshi nji wanyemeera embere z'abantu, Mwene oMuntu naye nj'amuyemeera embere za bamalahika ba Nnamahanga. ");
INSERT INTO hav_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Aliko, ola nji wandahira embere z'abantu, naye nj'alahirwa embere za bamalahika ba Nnamahanga. ");
INSERT INTO hav_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","«Na ngasi yeeshi nji waderhera kubi Mwene oMuntu nj'ababalirwa, aliko ola nji wadukanga Muuka-Mutagatiifu arhakababalirwa. ");
INSERT INTO hav_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","«Hano nji babakululira omu masinagoogi, abarhwali n'abarhegesi, murhayuubahiraga obulyo nji mwabuurana, changwa bichi nji mwaderha. ");
INSERT INTO hav_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Bulaala Muuka-Mutagatiifu nj'abayigiriza ho n'aho bichi mukwaneene kuderha.» ");
INSERT INTO hav_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Muntu muguma mw'abo bantu banene abwira Yeesu ntya: «Mwigiriza, bwira mwene weerhu ampe echaani chigabi ch'omwandu gwerhu.» ");
INSERT INTO hav_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yeesu amushubiza ntya: «Muza wee, nde wanjiraga muzuuzi changwa muntu w'okubagabira omwandu gwenyu?» ");
INSERT INTO hav_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ashuba kubabwira ntya: «Muchilange n'okugwarha amahugu ma ngasi buuko, kwenge akalamo k'omuntu garharhengeere omu kanji k'ebikulo byaage.» ");
INSERT INTO hav_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Yeesu ababwira ogu mugani: «Eshwa ly'omugale muguma lyayeeza bweneene. ");
INSERT INTO hav_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Alema akengeera n'oguchiibaza ntya: ‹Bichi njirage? Bulaala ntagwerhe hantu hanene h'ogushaluulira emyaaka yaani.› ");
INSERT INTO hav_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Aderha ntya: ‹Tala oku naajira: nashanda enguli zaani, nayumbaka ezigalihire; nji nalundira mo amahemba maani n'ebindi bikulo.› ");
INSERT INTO hav_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","N'enyuma z'aho, nji nachibwira ntya omu murhima: ‹Ngwerhe ebintu binene bweneene bibiikirwe, bya myaaka minene; nahumuuka, naalya, nanywa, naashagaluka.› ");
INSERT INTO hav_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Aliko Nnamahanga amubwira ntya: ‹Oli muhwinja! M'obu budufu waafa! Ka warheganyize nde nji waaba nyina ebi bintu byooshi wachibikiire?›» ");
INSERT INTO hav_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yeesu ashuba kuderha ntya: «Ntyo ku bibeera omuntu ochihakira ebikulo byaage yenyine, aliko eyi arhali mugale embere za Nnamahanga.» ");
INSERT INTO hav_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yeesu ashubi bwira abigirizwa baage ntya: «Mulolage egirhumire mbabwira oku murhachiganyaga elugulu w'akalamo kenyu, akaba bichi mwalya; changwa elugulu w'omubiri gwenyu, akaba bichi mwayambala. ");
INSERT INTO hav_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Bulaala akalamo kali ka bulagiirire kulusha ebiryo, n'omubiri guli gwabulagiirire kulusha emyambalo. ");
INSERT INTO hav_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Mulole ebihungwe: birhahinga birhanashaluula, birhajira aha bibiikira changwa enguli. Aliko Nnamahanga yebiliisa! Mwabo muli b'akamaro kanene kulusha enyunyi! ");
INSERT INTO hav_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Nde omu mwabo omu guchiiganya, wakagala kuleehya chiro bugeeke akalamo kaage? ");
INSERT INTO hav_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Akaba ntaacho mwagachigalira mw'ebi bintu bigeeke, gichi chagarhuma mwachilunza oku bisigeere? ");
INSERT INTO hav_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Mulole guurhe ebirhi biyaasa: birhakola, birhaluka fulema; aliko, mbabwire oku chiro mwami Solomoono omu bukuuze bwage arhayambalaga nka chiguma omu byo. ");
INSERT INTO hav_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Akaba Nnamahanga ayambisa ntya egirhi chiri omu shwa zeene n'omuseezi banagiheba omu chibeeye, bichi byaagarhuma arhabayambisa nenyu kulusha, mwe bantu b'obwemeezi bugeeke! ");
INSERT INTO hav_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Nenyu, murhagendaga mwashonda gichi mwalya changwa gichi mwanywa, murhanachibuliisaga omurhuula. ");
INSERT INTO hav_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ebyo byooshi by'abapagaani ba lino gulu bashonda buzira kuluha. Yisho wenyu ayinji oku mubikeneere. ");
INSERT INTO hav_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ahuubwe, murhange mushonde obwime bwa Nnamahanga, n'ebyoola bindi naye nj'abaheereza byo. ");
INSERT INTO hav_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Murhayuubahaga, mwe buso bugeeke; kwenge byasimiisize Yisho okubaha oBwami bwage.» ");
INSERT INTO hav_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Yeesu ashuba kuderha ntya: «Muguze ebintu byenyu, muhe abakene efuranga. Muchijirire orhushaho rhw'efuranga rhurhagashaaja, muchibiikire ebikulo birhaagahwa omu mpingu. Eyoola nta mwizi wakayegeera yo na nta mushwa gwakabibiihya. ");
INSERT INTO hav_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Bulaala emunda ebikulo byaawe biri, yi n'omurhima gwawe gwaba guli.» ");
INSERT INTO hav_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Yeesu ashuba kuderha ntya: «Muchirheganye, mube muyambeere emyambalo y'akaasi n'amatara machaanirwe. ");
INSERT INTO hav_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Nenyu mube kuguma n'aba bantu bali balinga nnahamwabo agaluke gurhenga oku buhya, hano akongoorha oku lunvi bagale kumuchinguulira jubaajuba. ");
INSERT INTO hav_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Bagishirwe aba bagaragu nnahamwabo ashimaana bataramire ey'agaluka! Okuli, mbabwirire, naye nj'ayambala emyambalo y'akaasi, nj'abayikaza n'okuyinja kubaha ebiryo. ");
INSERT INTO hav_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Nk'ayinjire omu budufu ahagarhi changwa buyerekeera gucha, akanababugaana bagitaramire, bagishirwe!» ");
INSERT INTO hav_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","«Mumenye bwinja: nyina enju nk'amenyaga aha saa zinga egishambo chigwasize kuyinja, arhakalekere enju yaage eshandwe. ");
INSERT INTO hav_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Nenyu leero muchirheganye, bulaala Mwene oMuntu nj'ayinja omu saa murhaganiizize.» ");
INSERT INTO hav_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Petero abaza Yeesu ntya: «Nnaweerhu, ka rhwewe rh'obwirire ogu mugani changwa abantu booshi?» ");
INSERT INTO hav_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Nnaweerhu ashubiza ntya: «Nde ye mukozi orhahemuka, na munya bwenge, eyi nnahamwabo akajira mwimangizi w'abandi bakozi baage, y'abaheereza ebiryo omu gashanji gahemerwe? ");
INSERT INTO hav_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Agishirwe oyu muja, akaba nnahamwabo hano agaluka, amushimaana ali akola ntyo! ");
INSERT INTO hav_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Okuli mbabwirire: nnahamwabo nj'amujira mwimangizi w'ebikulo byaage byooshi. ");
INSERT INTO hav_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Aliko, nk'oyo muja achibwirire ntya omu murhima gwage: ‹Nnahamwerhu alegamire kuyinja›, agarhondera gukubirha abaabo baja b'abalume n'aba bakazi, agarhondera kulya, kunywa n'okulaluka, ");
INSERT INTO hav_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","nnahamwabo nj'agaluka olusiku oyo muja arhalikengereere, n'esa arhamenyere. Nj'amuhana bweneene n'okumuyikaza haguma n'abahemusi. ");
INSERT INTO hav_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","«Omuja nji waaba amenyere ogushonda kwa nnahamwabo, aliko arharheganyaga n'okujira echintu chiyerekeere oko gushonda, nj'ashuurhwa enkoni zirhankaganjwa. ");
INSERT INTO hav_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Sy'aliko, ola orhamenyaga ogushonda kwa nnahamwabo, n'okuba ajirire ebintu bikwaneene obuhane nj'ashuurhwa nkoni zigeeke. Eyi baheere bintu binene, nji baamubaza binene; eyi babikiisize binene, nji bamuhema binene kulusha.» ");
INSERT INTO hav_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","«Nayinjaga guhira omuliro oku gulu; nagashondere gube gwachaanirwe! ");
INSERT INTO hav_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Nkwaneene kubatiizwa omu malibuko; n'omurhima gwani gurhaviire gwarhuleera kugera birhaza kujirika.» ");
INSERT INTO hav_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","«Ka muganiizize oku nayinjaga kuleerha omurhuula oku gulu? Nangwa, mbabwire okuli, sy'aliko obuhaka. ");
INSERT INTO hav_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Gurhenga bunoola, bantu barhaano balamire omu nju nguma barhakayunviikana, basharhu nji balwisa babiri, na babiri nji balwisa basharhu. ");
INSERT INTO hav_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Omwana n'eshe barhakayunviikana, omunyere na nyina barhakayunviikana, omwazaana na nazaala barhakayunviikana.» ");
INSERT INTO hav_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yeesu ashuba kubwira olubaga lw'abantu ntya: «Eyi mwabona ebichu byahulukira ebuzikiro bw'ezuuba, ho n'aho mwanaderha: ‹Envula yayinjire›, ebyoola byanahika. ");
INSERT INTO hav_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Na nk'omuyaga gw'egarhongo guli kugera, mwanaderha: ‹Echuuka chaaba.› Ebyoola byanahika. ");
INSERT INTO hav_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Mwe ndyaalya! Muyinji kumenya oboorhere bw'egulu n'echaalege. Gurhe mwagafundwa kumenya amango mali bunoola?» ");
INSERT INTO hav_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","«Na girhuma mwenyine murhagala kumenya ebikwaneene? ");
INSERT INTO hav_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Nka waaja kubuurana n'ogusidaakire embere z'omurhegesi, ochihangaane oyunviikane naye omu njira; y'arhaguheeka embere z'omuzuuzi. Omuzuuzi naye akaguhaana omu maboko m'omupoolisi, n'oyo mupoolisi anaguhira omu munyororo. ");
INSERT INTO hav_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Okuli nkubwirire, orhagarhenga omu munyororo orhanahongere olufuranga lw'obuzinda omu zibaguchiire.» ");
INSERT INTO hav_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Amo mango, abantu baguma bayinja kubalira Yeesu gurhe Pilaato ayirhaga aBagalilaaya baguma eyi bali gurhuula entuulo emwa Nnamahanga. ");
INSERT INTO hav_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yeesu ababwira ntya: «Mwabo muganiizize kw'abo Bagalilaaya bayirhwaga ntyo, k'okuderha oku bo baligwerhe ebyaaha binene kulusha abandi Bagalilaaya booshi? ");
INSERT INTO hav_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Mbabwirire oku nangwa. Aliko nka murhalekere ebyaaha byenyu, mweshi nji mwafa kuguma nabo. ");
INSERT INTO hav_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Changwa, aboola bantu ekumi na munaane omunaara gw'eSilowaamu gwarhogeraga ko, gwanabayirha, muganiizize oku boowe bo baliiri babi bweneene kulusha abandi Banyayerusaleema booshi? ");
INSERT INTO hav_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Mbabwirire oku nanga. Nenyu nka murhalekere ebyaaha byenyu, mweshi nji mwafa kuguma nabo.» ");
INSERT INTO hav_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Yeesu ashuba kubabwira guno mugani: «Haliiri muntu muguma waligwerhe omurhi guyirikwa tiini omu shwa lyaage ly'emizabiibu. Aja oku go gushonda amalehe, aliko ntaamo abwene. ");
INSERT INTO hav_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ava abwira omuhinzi w'elyo shwa ntya: ‹Lola! Myaaka esharhu eyi ndi nayinja gushonda amalehe k'oguula murhi eyi ntanamabona. Oguche! Chagarhuma gwabeera bushaabusha omu budaka?› ");
INSERT INTO hav_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Aliko oyo muhinzi anamushubiza ntya: ‹Nnaweerhu, oguleke kandi guno mwaka, mpingire go n'okuguhira kw'emyaavu. ");
INSERT INTO hav_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ntyo, nkabaga nji gwaleerha amalehe omu mwaka gwayinjire, akaba birhabeere ntyo, wanagucha!›» ");
INSERT INTO hav_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Lusiku luguma lw'eSaabato, Yeesu aliiri kuyigiriza omu sinagoogi. ");
INSERT INTO hav_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ahoola haliiri omukazi olwere. Gurhengera myaaka ekumi na munaane, omuzimu alimuyinamize. Arhakagalire chiro kuyinamuka. ");
INSERT INTO hav_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yeesu abeere amubona, amuhamagala n'okumubwira ntya: «Nyaama wee, endwala yawe yafumire!» ");
INSERT INTO hav_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Amuhira ko amaboko, ho n'aho ayinamuka n'okuva arhondera gukuuza Nnamahanga. ");
INSERT INTO hav_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Aliko omukulu w'esinagoogi agaya oku Yeesu afumyize omuntu olusiku lw'eSaabato. Ava abwira echigusho ch'abantu ntya: «Hali siku ndarhu z'ogukola mo akaasi; mw'ezoola siku zimulemage mwayinja mo guchifumiisa, sy'aliko nangwa olusiku lw'eSaabato!» ");
INSERT INTO hav_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Nnaweerhu amushubiza ntya: «Mwe ndyaalya mwe! Nkaasi muguma wenyu ashwekuula enka yaage changwa epunda yaage n'okuyiheeka gushooka olusiku lw'eSaabato, k'arhali ntyo? ");
INSERT INTO hav_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","N'oyuula mukazi w'obuuko bwa Abrahaamu owalizirikirwe na Shetaani myaaka ekumi na munaane, ka birhahemere ashwekuulwe mw'ebyo biziriko byaage olusiku lw'eSaabato?» ");
INSERT INTO hav_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yeesu abeere ali kuderha ntyo, booshi baliiri kumulwisa bayunva eshonyi; aliko echigusho chooshi ch'abantu chamogera ebijiro binja byooshi aliiri kujira. ");
INSERT INTO hav_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yeesu ashuba kuderha ntya: «oBwami bwa Nnamahanga bwagashusha na gichi? Nankabushushanya na gichi? ");
INSERT INTO hav_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Bushusheene n'ehiburho hy'eharadaali muntu muguma arhoolaga anahibyaala omu shwa lyaage. Hyaamera n'ogukula, hyaaba murhi, n'enyunyi z'omu chaalege zayumbaka ebyoogo byaazo omu marhabi maago.» ");
INSERT INTO hav_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yeesu ashuba kuderha ntya: «Gichi nankalinganya n'oBwami bwa Nnamahanga? ");
INSERT INTO hav_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Bulinganeene n'echachu omukazi arhoolaga n'okuyihira omu milengo esharhu y'eshaano y'ogukola emigati, kugera egihe yooshi yarhunda.» ");
INSERT INTO hav_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yeesu aliiri omu njira aja eYerusaleema, alenga omu bishagala bineneenene n'ebigeekegeeke ayigiriza. ");
INSERT INTO hav_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Muntu muguma amubaza ntya: «Nnaweerhu, k'arhali bantu bageeke bonyine nji bachungulwa?» Yeesu ashubiza ntya: ");
INSERT INTO hav_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«Muchihangaane kuja omu Bwami bwa Nnamahanga kugerera omu mulyango gufundereere. Bulaala, yi nababwira, bantu banene nji bashonda kuja mo aliko barhakagala. ");
INSERT INTO hav_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Amango nyina enju nj'aba ayimangire ey'amanachinga omulyango, nji mwaba mwamasigala embuga. Nji mwarhondera gukongoorha oku mulyango n'okuderha ntya: ‹Nnaweerhu, orhuchinguulire.› Nj'abashubiza ntya: ‹Mwabo, ntenji muli ba ngahe.› ");
INSERT INTO hav_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ho n'aho, nji mwamubwira ntya: ‹Rhwaliire rhwananywa haguma naawe, wanagendaga wayigiriza emwerhu!› ");
INSERT INTO hav_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Naye nj'ababwira ntya: ‹Ntenji muli ba ngahe. Muje hale naani, mweshi mwe mukola amabi!› ");
INSERT INTO hav_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Eyoola nji yaaba amalira n'oguhekenya amenyo, amo mango nji mwabona Abrahaamu, Isaka na Yakobo, n'abaleebi booshi omu Bwami bwa Nnamahanga, aliko mwabo nji mwaba mwakabwirwe embuga! ");
INSERT INTO hav_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Abantu nji barhengera ebuhulukiro bw'ezuuba n'ebuzikiro bwalyo, n'abandi gurhengera emalambo n'egarhongo n'okuyikala balye haguma omu Bwami bwa Nnamahanga. ");
INSERT INTO hav_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Mumenye oku hali abazinda nji baaba barhanzi, hali n'abarhanzi nji baaba bazinda.» ");
INSERT INTO hav_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Mw'ebyoola bishanji, aBafarisaayo baguma bayegeera Yeesu n'okumubwira ntya: «Rhenga hano, ochigendere ahandi, bulaala Heroode yashonda gukuyirha.» ");
INSERT INTO hav_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yeesu abashubiza ntya: «Mugende mujibwira ogoola mutereri ntya: ‹Yi nalibisya abazimu n'ogufumya abalwala zeene n'omuseezi. Na lishinjo naamala akaasi kaani.› ");
INSERT INTO hav_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Aliko bihemere ngendekere olugenzi lwani zeene, omuseezi na lishinjo, bulaala birhakwaneene kuyirhira omuleebi ahandi aharhali eYerusaleema.» ");
INSERT INTO hav_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","«Yerusaleema, Yerusaleema, wooyo weyirha abaleebi n'okubanda amabaale abantu Nnamahanga agurhumiraga! Kanga nashondaga guhira haguma abaana baawe nk'oku engoko ehira haguma ebyaanagoko byaayo omu byuubi byaayo! Aliko murhabilonzaga. ");
INSERT INTO hav_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Mumenye okw'enju yenyu yaaba mushaka. Mbabwirire byo: murhagachimbona kugera amango hayinja egihe nji mwaderha ntya: ‹Nnamahanga agishe owayinja oku ziino lya Nnaweerhu!›» ");
INSERT INTO hav_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Lusiku luguma lw'eSaabato, Yeesu aja kulya emwa muguma w'abakulu b'aBafarisaayo. Abaliiri ho booshi baliiri bamuloleereza. ");
INSERT INTO hav_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Omuntu olwere endwala y'ogurhundiisa omubiri aliiri embere za Yeesu. ");
INSERT INTO hav_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yeesu abaza abigiriza b'amarhegeko n'aBafarisaayo ntya: «K'amarhegeko meerhu mayemereere changwa nangwa omuntu ogufumya omulwala olusiku lw'eSaabato?» ");
INSERT INTO hav_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Aliko baasira. Yeesu ava arhoola oyo mulwala, amufumya n'okumuleka agende. ");
INSERT INTO hav_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ashuba kubabaza ntya: «Nde omu mwabo nk'omugala changwa enka yaage egarhogera omu gishimu, ka ho n'aho arhakayikuula mo nachiro luli lusiku lw'eSaabato?» ");
INSERT INTO hav_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Baabula echi bamushubiza. ");
INSERT INTO hav_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yeesu abeere abona gurhe abalaalikirwe yi bachiishoga ebichumbi by'embere, abachiira ogu mugani: ");
INSERT INTO hav_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«Nk'omuntu aguhamageere kuja kulya amango m'obuhya, orhajaaga kuyikala oku gichumbi ch'embere. Bulaala hali amango omuntu okengerwe gukulusha alaalikirwe, ");
INSERT INTO hav_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","owabalaalikaga wooyo n'owenyu akayinja gukubwira ntya: ‹Olekere oyuula muntu egichumbi.› Wanaja wagwarhwa n'eshoni z'okuja kuyikala oku gichumbi ch'enyuma. ");
INSERT INTO hav_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Aliko, amango olaalikirwe, wanaja kuyikala oku gichumbi ch'enyuma, y'amango hano owakulaalikaga ayinja, akubwire ntya: ‹Mwira waani, oje kuyikala oku gichumbi ch'embere!› Ntyo, nji bwakubeera bukenge embere z'abantu booshi nji baaba bayikeere haguma naawe oku meeza. ");
INSERT INTO hav_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Bulaala ngasi yeeshi ochizamwire nj'ayandagazwa, n'ochiyandageeze nj'azamuulwa.» ");
INSERT INTO hav_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Yeesu ashuba kubwira ola wamulaalikaga ntya: «Amango warheganyiza abantu ebiryo by'ezuuba changwa by'egolo, orhalaalikaga abeera baawe, changwa beene benyu, changwa abantu b'omulala gwawe, changwa abatuuranyi baawe b'abachire. Bulaala nabo nji bakayinja gukulaalika, na ntyo wanaba wamajuhwa. ");
INSERT INTO hav_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Aliko amango wahamagala abantu kulya oku lusiku lukulu, olaalike abakeene, ebirema, abahunzize n'empumi. ");
INSERT INTO hav_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ntyo, nji waaba mugishwa, kwenge boowe barhagwerhe echi bagakujuha omu gukugalulira! Aliko, nji waajuhwa amango m'ogufuuka kw'abakwaneene.» ");
INSERT INTO hav_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Muntu muguma omu baliiri baalya haguma na Yeesu abeere ayunva ebyo binwa, aderha ntya: «Agishirwe ola nji waalya omu Bwami bwa Nnamahanga!» ");
INSERT INTO hav_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yeesu amushubiza ntya: «Haliiri muntu muguma warheganyaga biryo binene, analaalika bantu banene. ");
INSERT INTO hav_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Egihe ch'okulya chagerere ho, arhuma omuja waage kubwira abalaalikirwe: ‹Muyinje, byooshi byarheganyizwe.› ");
INSERT INTO hav_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Aliko booshi barhondera kuderha ngasi muguma echaarhuma arhabonekana. Omwambere amubwira ntya: ‹Nagulaga eshwa, bimpemere nje kulirhangula; nguhemere ombabalire.› ");
INSERT INTO hav_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Owindi aderha ntya: ‹Nagulaga enka ekumi z'oguhingiisa, nguhemere ombabalire, naaja kulola akaba zaakola.› ");
INSERT INTO hav_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Owindi aderha ntya: ‹Namayuusa gushaba, chocharhuma ntayinja!› ");
INSERT INTO hav_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Oyo muja agaluka emwa nnahamwabo, amubalira ebyo byooshi. Nnahamwabo akaliha, abwira oyo omuja waage ntya: ‹Genda juba omu njira zineneenene n'omu zigekegeeke z'egishagala, oleerhe hano abakene, ebirema, empumi n'abahunzize.› ");
INSERT INTO hav_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Omuja abeere amala kujira ntyo, aderha ntya: ‹Nnaweerhu, ebi wahemaga byajirirwe, aliko hanachiri ahakayikalwa!› ");
INSERT INTO hav_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Nnahamwabo ava amubwira ntya: ‹Oje omu njira n'omu migenderano y'egishagala, oseeze abantu bayinje kuja omu nju, y'omu mwani muyunjula abantu. ");
INSERT INTO hav_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Kwenge, mbabwirire byo, ntaaye mw'aba bantu bali balaalikirwe nji waalya oku biryo byaani.›» ");
INSERT INTO hav_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Lusiku luguma abantu banene baliiri kulambagira haguma na Yeesu omu njira. Ahindamuka n'okubabwira ntya: ");
INSERT INTO hav_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«Nk'omuntu ankulikiire arhanansiimire kulusha eshe, nyina, mukaage, abaana baage, beene baabo, bali baabo, chiro n'akalamo kaage, arhaakaba mwigirizwa waani. ");
INSERT INTO hav_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","N'omuntu orhaheekere omusalaaba gwage n'okunkulikira, arhaakaba mwigirizwa waani. ");
INSERT INTO hav_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","«Nde omu mwabo, nk'ashondere kuyumbaka enju nene, arharhanga kuyikala aganje engulo y'ebyakoleesa n'okulola akaba agwerhe ebikulo by'okuyiyunjuza? ");
INSERT INTO hav_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Kwenge, nk'arhondeere kuyumbaka n'akaba arhagalire kumala, aba nji baabona ntyo, nji bamushekera. ");
INSERT INTO hav_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Baderha ntya: ‹Oyu muntu arhondeere kuyumbaka, aliko agambirwe kuyunjuza.› ");
INSERT INTO hav_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Changwa mwami ohe, nk'ashondere kulwisa owindi mwami, orharhanga kuyikala n'oguchiibaza akaba oku misi y'abasoda baage bihumbi ekumi, akagala guhima oyo waabo oyinjire na basoda bihumbi makumyaabiri? ");
INSERT INTO hav_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Akaba arhakagala, agarhumira oyo waabo abantu achiri hale b'okumubaza gurhe bakayunviikana n'omurhuula gube ho. ");
INSERT INTO hav_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Nenyu ntyo kubinali! Ngasi yeeshi omu mwabo nk'arhalekere ebikulo byaage byooshi arhaakaba mwigirizwa waani.» ");
INSERT INTO hav_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","«Omunyu chiri chintu gikwiriire. Sy'aliko gugaheza obuloke, gurhe bakagugalulira bo? ");
INSERT INTO hav_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Gurhachiri gwinja oku budaka changwa oku myaavu; banagukabula embuga. Ogwerhe amarhwi m'okuyunva, ayunve!» ");
INSERT INTO hav_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Abafurhiisa b'amakooli n'abanyabyaaha baliiri kuyegeera Yeesu yi bamuyunviriza. ");
INSERT INTO hav_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","aBafarisaayo n'abigiriza b'amarhegeko babeere baabona ntyo, bamuveeba ntya: «Oyu muntu y'ayankirira abanyabyaaha n'okulya nabo!» ");
INSERT INTO hav_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Aliko Yeesu abachiira ogu mugani: ");
INSERT INTO hav_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«Nde omu mwabo, nk'agwerhe ntaama egana, agaheza nguma omu zo, k'arhakaleka zila zindi makumi gali mwenda na mwenda omu mpinga y'aja gushonda ela eherere kugera amango ayibona? ");
INSERT INTO hav_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","N'akayibona, anayihira oku birhugo byaage n'obushagaluke bunene, ");
INSERT INTO hav_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","anagaluka emwage, anahamagala beera baage n'abatuuranyi baage n'okubabwira ntya: ‹Mushagaluke haguma naani, bulaala nabwene entaama yaani yali herere.› ");
INSERT INTO hav_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Na ntyo mbabwirire byo, nji haaba obushagaluke bunene omu mpingu oku munyabyaaha muguma olekere ebyaaha byaage, ahaali h'abantu makumi gali mwenda na mwenda bakwaneene barhakeneere okuleka ebyaaha byaabo.» ");
INSERT INTO hav_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Yeesu ashuba kuderha ntya: «Mukazi muchi, nk'agwerhe bicheri ekumi by'efuranga n'agaheza gicheri kiguma, k'arhagachaana etara, agahyaagira enju n'agashonda bwinjabwinja kugera amango achibona? ");
INSERT INTO hav_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Na hano abona echo gicheri, anahamagala abeerakazi n'abatuuranyi baage n'okuderha ntya: ‹Mushagaluke haguma naani, bulaala nabwene egicheri chaani ch'efuranga nalihezeze!› ");
INSERT INTO hav_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Mbabwirire byo oku ntyo ku bamalahika ba Nnamahanga banashagaluka nk'omunyabyaaha muguma alekere ebyaaha byaage.» ");
INSERT INTO hav_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yeesu ashuba kuderha ntya: «Haliiri muntu muguma waligwerhe bagala babiri. ");
INSERT INTO hav_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Omudoorho abwira eshe ntya: ‹Daarha, ompe echaani chigabi ch'agashambala chikwaneene kuba chaani.› Eshe abagabira bombi. ");
INSERT INTO hav_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Enyuma wa siku zigeeke, omugala mudoorho aguza omwandu gwage n'okugenda omu gihugo cha hale. Mw'echo gihugo ashandaguza ebikulo byaage omu boorhere bubi. ");
INSERT INTO hav_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Amalire kubishandaguza byooshi, enzara nene yaba mw'echo gihugo, arhondera kubula ngasi chintu. ");
INSERT INTO hav_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Aja agenda gukolera omuntu muguma w'echo gihugo. Oyo muntu amurhuma omu mashwa maage kulagira engulube. ");
INSERT INTO hav_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Oyo murhabana alema agifiija kulya oku biryo by'engulube sy'aliko ntaaye wamuheere byo. ");
INSERT INTO hav_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Buzinda agishuba ko, aderha ntya: ‹Abakozi booshi ba daarha bali omu muhimbo, n'obo nyoono hano ndi naafa n'enzara! ");
INSERT INTO hav_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nagaluka emwa daarha, nanamubwira ntya: “Daarha, najirire echaaha embere za Nnamahanga n'embere zaawe. ");
INSERT INTO hav_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ntachikwaneene kuyirikwa mugala waawe. Oje wantoola nka muguma w'omu bakozi baawe.”› ");
INSERT INTO hav_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ava agaluka, aja emw'eshe. «Abeere achiri hale n'aha mwabo, eshe amulangiira, amuyunvira obonjo bunene. Alibirha kumulinga, amuhoobera. ");
INSERT INTO hav_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Omugala aj'amubwira ntya: ‹Daarha, najirire echaaha emwa Nnamahanga n'emwawe, ntachikwaneene guhamagalwa mugala waawe.› ");
INSERT INTO hav_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Aliko eshe abwira abaja baage ntya: ‹Muyanguhe, muleerhe omwambalo gukwiriire bweneene mumuyambise go, mumuyambise olupeta oku mudoke munamuyambise ebiraato. ");
INSERT INTO hav_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Muleerhe enyana eshishire muyibaage; rhujire edinye rhunasiime, ");
INSERT INTO hav_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","bulaala oyu mugala waani abaaga afiire leero afuukire, abaaga aherere leero abonekere.› Banarhondera edinye. ");
INSERT INTO hav_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","«Mw'ako gashanji, omugala w'efula aliiri omu shwa. Abeere agaluka, n'okuyegeera aha mwabo, ayunva abantu bali kuyimpa n'okuzina. ");
INSERT INTO hav_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ahamagala muguma omu bakozi b'eshe, amubaza bichi byabeere. ");
INSERT INTO hav_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Omukozi amubwira ntya: ‹Mudoorho waawe agalukire bobunoola yisho ayirhire enyana eshishire, bulaala amubwene mugumaguma.› ");
INSERT INTO hav_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Oyo mugala w'efula ayunva oburhe, alahira kuja omu nju. Eshe ahuluka kumurhebeereza aje mo. ");
INSERT INTO hav_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Aliko abwira eshe ntya: ‹Tala! Hamaagera myaaka minene bweneene eyi ndi nagukolera. Ntashubiraga kuvuna erhegeko lyaawe chiro n'eliguma. N'obo orhashubiraga kumpa chiro omwana gw'empene yi nshagaluka haguma na beera baani. ");
INSERT INTO hav_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Aliko oyu mugala waawe wahezeze ebikulo byaawe omu bubaraga, abeere agaluka, wamubagiire enyana eshishire!› ");
INSERT INTO hav_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Eshe amubwira ntya: ‹Mwana waani, oli haguma naani esiku zooshi, na byooshi ngwerhe biri byaawe. ");
INSERT INTO hav_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Sy'aliko byaalihemere rhujire edinye n'ogushagaluka, bulaala oyu mwene wenyu abaaga afiire, aliko afuukire; abaaga aherere, aliko abonekere!›» ");
INSERT INTO hav_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yeesu ashuba kubwira abigirizwa baage ntya: «Haliiri omuchire muguma waligwerhe omwimangizi w'ebikulo byaage. Abantu bayinja gusidaaka oyo mwimangizi emwa nnahamwabo oku agwerhe ashandaguza ebikulo byaage. ");
INSERT INTO hav_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Nnahamwabo amuhamagala n'okumubwira ntya: ‹Bichi ndi nayunva baderha elugulu waawe? Nyeerekaga oluganjo lw'ebikulo byaani, bulaala orhagachiba mwimangizi wabyo.› ");
INSERT INTO hav_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Oyo mwimangizi aderha ntya omu murhima gwage: ‹Nnahamwerhu akola kunyaga akaasi kaani. Bichi njirage? Ntaviire nakoomera oguhinga amashwa na kandi nji nagwarha eshoni z'oguhemuuza. ");
INSERT INTO hav_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ahaa! Namaamenya echi naajira, yi haboneka abanyankiirira emwa baabo hano nkuulwa oku kaasi kaani.› ");
INSERT INTO hav_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Aja ahamagala ngasi muguma waligwerhe omwinda gwa nnahamwabo. Abaza omwambere ntya: ‹Mwinda munganachi gwa nnahamwerhu ogwerhe?› ");
INSERT INTO hav_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Amushubiza ntya: ‹Nkunguru egana z'amavurha.› Oyo mwimangizi w'ebikulo amubwira ntya: ‹Rhoola aka karataasi kayandikirwe k'omwinda gwawe; yikala juba oyandike nkunguru makumi marhaano.› ");
INSERT INTO hav_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ashuba kubwira owindi ogwerhe omwinda: ‹Naawe mwinda munganachi gwa nnahamwerhu ogwerhe?› Amushubiza ntya: ‹Bigunira egana by'amahemba.› Omwimangizi w'ebikulo amubwira ntya: ‹Rhoola aka karataasi kayandikirwe k'omwinda gwawe; yikala juba onayandike makumi gali munaane.› ");
INSERT INTO hav_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Nyina ebikulo asiima omwimangizi muhemusi, bulaala akolere n'obwenge. Bulaala, abantu b'eri gulu bayanguha omu bijiro byaabo kulusha abantu b'obumoleke.» ");
INSERT INTO hav_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Yeesu ashuba kuderha ntya: «Nyoono mbabwirire ntya: Muchijirire abeera haguma n'obuchire bubi bw'eri gulu, yi hano muba murhachigwerhe obuchire, abantu babayankiirire omu biikalo by'esiku n'amango. ");
INSERT INTO hav_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","«Omuntu orhali muhemusi omu bintu bigeeke eyi arhanali muhemusi omu bintu binene; n'omuntu muhemusi omu bintu bigeeke eyi anali muhemusi omu bintu binene. ");
INSERT INTO hav_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Akaba leero mwabeere bantu bahemusi omu buchire bw'eri gulu, nde nji wabajira bimangizi b'obuchire bw'okuli? ");
INSERT INTO hav_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","N'akaba mwabeere bantu bahemusi omu bintu byabeene, nde nji wabaheereza ebintu bababikiire? ");
INSERT INTO hav_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","«Nta muja wakagala gukolera ba shoobuja babiri: changwa anagaya muguma n'ogusiima owindi, changwa anagishwekera oku muguma n'okuboneerera owindi. Murhakagala gukolera Nnamahanga, munakolere ebikulo.» ");
INSERT INTO hav_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","aBafarisaayo babeere bayunva ebi binwa byooshi, barhondera gushekera Yeesu, bulaala basiimaga efuranga. ");
INSERT INTO hav_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yeesu ababwira ntya: «Muli bantu bachiyeerekana nka ab'okuli embere z'abantu, aliko Nnamahanga ayinji emirhima yenyu. Bulaala, ech'abantu barhoolere nka gikwaneene, chiba chigayisize Nnamahanga. ");
INSERT INTO hav_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","«Egihe ch'eRhegeko lya Muusa n'ebitaabu by'abaleebi chagendekeere kugera amango ma Yohaana Mubatiiza. Gurhengera amo mango, oMwazi Mwinja g'oBwami bwa Nnamahanga gwayamageezwe na ngasi muntu y'alwisa kuja mo. ");
INSERT INTO hav_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Aliko byakayolohera empingu n'egulu guhirima, ahaali h'ehinwa hityuuli hy'eRhegeko lya Nnamahanga hirhenge. ");
INSERT INTO hav_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","«Ngasi mulume wayegwire mukaage n'agashaba owindi, eyi ajirire obuhushi, n'oshabire omukazi bayegwire, eyi naye ajirire obuhushi.» ");
INSERT INTO hav_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","«Haliiri mulume muguma w'omugale wagendaga ayambala emyambalo edukwire y'engulo nene. Oyo mugale agendaga ajira edinye ngasi lusiku. ");
INSERT INTO hav_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Haliiri n'omukene muguma oyirikwa Lazaaro wabaaga alyaama embere w'omulyango gw'enju yaage. Omubiri gwa Lazaaro gwali guyunjwire ebihulu. ");
INSERT INTO hav_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Lazaaro aliiri guchifiija kulya orhuboole rhw'ebiryo rhwagendaga rhwarhoga oku meeza m'oyo mugale. Na kandi embwa zagenda zayinja kumiima ebihulu byaage. ");
INSERT INTO hav_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Hagera olusiku oyo mukene afa. Bamalahika bamuheeka ahaburhambi bw'Abrahaamu. Ola mugale naye afa, bamuhamba. ");
INSERT INTO hav_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Agerere ekuzimu, alibuka bweneene. Ayinamula ameesho, alangiira Abrahaamu na Lazaaro ali eburhambi bwage. ");
INSERT INTO hav_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ava ayaama ntya: ‹Daarha Abrahaamu, ombeere obonjo; obwire Lazaaro ahire esongi ly'omudoke gwage omu menji, ambobeeze olulimi, bulaala ndi nalibuka bweneene m'ogu muliro.› ");
INSERT INTO hav_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Aliko Abrahaamu amushubiza ntya: ‹Mwana waani, yibuka oku waliyankiriire bintu binja binene omu kalamo kaawe, aliko Lazaaro yeewe aligwerhe malibuko manene. Bunoola, yeewe y'arhuleerezwa, aliko wooyo yi walibuka. ");
INSERT INTO hav_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Na kandi, hali omuhonga guleehere bweneene ahagarhi kenyu neerhu. Cho girhumire, abashondere gurhenga eno kuja emunda muli barhakabigala. Na kandi ntaaye wakagala kugera eno munda rhuli gurhengera eyo munda muli.› ");
INSERT INTO hav_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Omugale aderha ntya: ‹Daarha wee, nguhemere n'obonjo, orhume Lazaaro omu mwerhu; ");
INSERT INTO hav_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","bulaala ngwerhe beene beerhu barhaano, aje kubahanuula yi nji barhayinja nabo hano hantu h'amalibuko.› ");
INSERT INTO hav_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abrahaamu amushubiza ntya: ‹Beene benyu bagwerhe ebitaabu bya Muusa na eby'abaleebi, babiyunve.› ");
INSERT INTO hav_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Omugale aderha ntya: ‹Nangwa, daarha Abrahaamu, aliko nk'omuntu muguma afuukire akaja emunda bali, bakaleka ebyaaha byaabo.› ");
INSERT INTO hav_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Aliko Abrahaamu abwira omugale ntya: ‹Akaba barhashondere kuyunva Muusa n'abaleebi, barhakayemeera chiro omuntu wafuukire gurhenga omu bafu.›» ");
INSERT INTO hav_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yeesu abwira abigirizwa baage ntya: «Ntaako byankaba yi habula ebyaarhuma abantu baajira ebyaaha, aliko buhanya buchi oku omuntu nji waaba mpanvu y'okujira echaaha! ");
INSERT INTO hav_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Kwakabeere kwinja oku yeewe, ashwekerwe olushyo omu gosi, anakabulwe omu nyanja, ahaali h'ogurhuma muguma mw'aba badoorho ajira echaaha. ");
INSERT INTO hav_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Muchilange bwinja mwenyine! «Akaba mwene wenyu akujiriire echaaha, omuhanuule. Akaleka ebyaaha byaage, omubabalire. ");
INSERT INTO hav_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","N'akaba akujiriire echaaha kali mushanvu omu lusiku, n'akayinja emunda oli kali mushanvu gukubwira ntya: ‹Nalekere ebyaaha byaani›, omubabalire.» ");
INSERT INTO hav_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Entumwa zabwira Nnaweerhu ntya: «Orhuyushuulire obwemeezi.» ");
INSERT INTO hav_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Nnaweerhu ashubiza ntya: «Nka mwaligwerhe chiro obwemeezi bugeeke kuguma n'ehiburho hye haradaali, mwakabwirire ogu murhi gw'agafuleesi ntya: ‹Chikundula onaje guchibyaala omu nyanja›, gwakanabakengere.» ");
INSERT INTO hav_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Yeesu ashuba kuderha ntya: «Nka muntu muguma omu mwabo agwerhe omuja ohinga eshwa changwa olagira ebirhungano byaage, hano amubona agaluka gurhenga omu shwa, k'akamubwira ayinje juba alye? ");
INSERT INTO hav_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Nangwa, ahuubwe akamubwira ntya: ‹Nvuyira ebyaani biryo, onayambale bwinja, ompe ndye nanywe; naawe handeke walya onanywe buzinda.› ");
INSERT INTO hav_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Arhagasiimiriza omuja waage okw'ajirire eby'alirhegekerwe kujira, k'arhali ntyo? ");
INSERT INTO hav_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Nenyu ntyo kubinali: hano nji muba mwamakola byooshi bibarhegekerwe, muderhe ntya: ‹Rhuli baja barhagwerhe kamaro, hoshaaho rhwajirire ebi rhwalihemerwe kujira.›» ");
INSERT INTO hav_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yeesu abeere ali omu njira aja eYerusaleema, agera eburhambirhambi b'olubibi lugabire eSamariya n'eGalilaaya. ");
INSERT INTO hav_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Abeere aja omu gishagala chiguma, ababenzibenzi ekumi bayinja kumushimaana. Bayimanga hale naye. ");
INSERT INTO hav_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Barhondera kuyaama ntya: «Yeesu, Mwigiriza, orhubeere obonjo!» ");
INSERT INTO hav_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yeesu abeere ababona, ababwira ntya: «Muje guchiyeerekana emw'abadaahwa.» Babeere bali baaja yo, baava baafuma. ");
INSERT INTO hav_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Muguma omu bo, abeere abona afumire, agaluka akuuza Nnamahanga n'omulenge munene. ");
INSERT INTO hav_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Achikabula embere z'amagulu ma Yeesu, amalanga oku budaka, amubwira kooko. Oyu muntu aliiri Musamariya. ");
INSERT INTO hav_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yeesu ava aderha ntya: «K'arhali booshi ekumi baafumaga? Ngahe bandi mwenda bali? ");
INSERT INTO hav_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ka ntaaye wakengereere kugaluka gukuuza Nnamahanga, kuleka oyu orhali Muyaahudi?» ");
INSERT INTO hav_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Yeesu aja amubwira ntya: «Yimanga ogende, obwemeezi bwawe bwaguchungwire.» ");
INSERT INTO hav_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","aBafarisaayo baabaza Yeesu ntya: «Mango machi oBwami bwa Nnamahanga nji bwayinja?» Yeesu abashubiza ntya: «oBwami bwa Nnamahanga burhayinja bwachitaragaza. ");
INSERT INTO hav_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Abantu barhakaderha ntya: ‹Mulolage! oBwami bwa Nnamahanga buli hano!›, changwa: ‹Buli halira!› Bulaala, mumenyage bwinja, oBwami bwa Nnamahanga buli ahagarhi kenyu.» ");
INSERT INTO hav_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Yeesu ashuba kubwira abigirizwa baage ntya: «Agashanji kayinja nji mwachifiija kubona Mwene oMuntu chiro lusiku luguma, aliko nji murhamubona. ");
INSERT INTO hav_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","«Abantu nji bababwira ntya: ‹Ali haliira!›, changwa: ‹Ali hano!› Murhalibirhiraga yo. ");
INSERT INTO hav_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Nka kula omubaraganyo gubaraganya omu nkuba gurhengera omu luhande luguma guhika omu lwindi, ntyo ku Mwene oMuntu nj'aba omu olusiku lwage. ");
INSERT INTO hav_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Aliko embere Mwene oMuntu agaluke, bihemere alibuke bweneene analahirwe n'echi gisisi. ");
INSERT INTO hav_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","«Nk'oku byabaaga omu siku za Noowa, ku nji byaaba amango Mwene oMuntu nj'agaluka. ");
INSERT INTO hav_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Abantu bagendaga baalya n'okunywa, bagendaga baashaba n'ogushabwa, kugera oku lusiku Noowa ajaaga omu nkuge. Leero emisuuka minene yahulula, yabazisya booshi. ");
INSERT INTO hav_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","«Kandi nji byaaba kuguma n'esiku za Looti: abantu bagendaga baalya n'okunywa, bagendaga baagula n'okuguza, bagendaga bahinga n'okuyumbaka. ");
INSERT INTO hav_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Sy'aliko olusiku Looti arhengaga eSodoomo, omuliro n'ebiseese byarhoga gurengera oku nkuba nka nvula, byayirha abantu booshi. ");
INSERT INTO hav_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Kandi ntyo ku nji byaaba olusiku Mwene oMuntu nj'agaluka. ");
INSERT INTO hav_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","«Olo lusiku, omuntu nji waaba ali oku nju elugulu, arhajaaga omu nju gurhoola ebintu byaage. N'ola muntu nji waaba ali omu shwa lyaage arhachigalukaga emwage. ");
INSERT INTO hav_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Muyibuke ebyahikiraga muka Looti! ");
INSERT INTO hav_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Omuntu nji washonda kulanga akalamo kaage nj'agaheza; aliko omuntu nji washonda kugaheza nj'akalanga. ");
INSERT INTO hav_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","«Mbabwirire, m'obo budufu, bantu babiri nji baaba balyaamire oku buliri buguma: muguma nj'aheekwa, owindi nj'alekwa. ");
INSERT INTO hav_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Bakazi babiri nji baaba bali basyera haguma: muguma nj'aheekwa, owindi nj'alekwa.  ");
INSERT INTO hav_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Bantu babiri nji baaba bali omu shwa: muguma nj'aheekwa, owindi nj'alekwa.» ");
INSERT INTO hav_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Abigirizwa baabaza Yeesu ntya: «Nnaweerhu, ngahe ebyo nji byabeera?» Naye abashubiza ntya: «Ahali omurhumba, ho hagwirira banyunda.» ");
INSERT INTO hav_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yeesu ashuba guchiira abigirizwa baage ogu mugani y'abayeereka oku bakwaneene gusaliira buzira kuluha. ");
INSERT INTO hav_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Aderha ntya: «Omu gishagala chiguma haliiri omuzuuzi muguma orhayuubahaga Nnamahanga na nta muntu akengaga. ");
INSERT INTO hav_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Kandi mw'echo gishagala haliiri omushumbakazi muguma wagendaga aja kubwira oyo muzuuzi ntya: ‹Onchiire bwinja olushinja n'omushombanyi waani!› ");
INSERT INTO hav_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Halenga siku zinene alahiire kumuchiira lo. Aliko buzinda achibwira ntya: ‹Nachiro mpu ntayuubaha Nnamahanga na nta muntu nkenga, ");
INSERT INTO hav_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","aliko bunoola oyu mushumbakazi ali andunza, namuchiira bwinja olushinja lwage, arhayinja kumbera erhwe.›» ");
INSERT INTO hav_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Nnaweerhu aja aderha ntya: «Muyunve bwinja eby'oyu muzuuzi muhemusi aderhere! ");
INSERT INTO hav_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ka Nnamahanga yeewe arhagachiira bwinja olushinja abantu baage achishogere, n'obo bali bamulilira ezuuba n'obudufu? Ka nj'alegama kubarhabaala? ");
INSERT INTO hav_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Mbabwirire oku Nnamahanga nj'abachiira bwinja olushinja jubaajuba. Sy'aliko amango Mwene oMuntu nj'agaluka, ka nj'abugaana obwemeezi omu gulu?» ");
INSERT INTO hav_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yeesu ashuba gucha ogu mugani oku bantu baliiri guchiibona oku bakwaneene n'ogukena abandi bantu: ");
INSERT INTO hav_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","«Lusiku luguma, bantu babiri baja gusaliira omu Nju ya Nnamahanga. Muguma aliiri Mufarisaayo n'owindi aliiri mufurhiisa w'amakooli. ");
INSERT INTO hav_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","oMufarisaayo ayimanga, asaliira ntya omu murhima gwage: ‹Nnamahanga wee, nguheere obukuuze bulaala ntali kuguma n'abandi bantu. Boowe bali bishumuusi, barhakwaneene, bali bahushi. Kandi ntali kuguma n'oyu mufurhiisa w'amakooli. ");
INSERT INTO hav_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nanchiibuza kulya kabiri omu boso, nampaana chigabi chiguma ch'ekumi ch'ebintu mbona.› ");
INSERT INTO hav_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Aliko omufurhiisa w'amakooli yeewe, aliyimangire hale. Chiro arhanagalaga kuyinamula ameesho elugulu, sy'aliko achishuurha egifuba omu kuyeerekana oku arhakwaneene. Aderha ntya: ‹Yoo! Nnamahanga, ombeere obonjo, nye munyabyaaha!› ");
INSERT INTO hav_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yeesu aja aderha ntya: ‹Mbabwirire, oyu mufurhiisa w'amakooli yi wagalukire emwage ey'akwaneene, si arhali ola Mufarisaayo. Kwenge ngasi muntu yeeshi wachizamuula nj'ayandagazwa, aliko ola wachiyandagaza nj'azamuulwa.›» ");
INSERT INTO hav_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Bantu baguma baleerhera Yeesu enjolyaana nazo mpu azigishe omu kuzihira kw'amaboko. Abigirizwa baage babeere baabona ntyo, bakalihira abo bantu. ");
INSERT INTO hav_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Aliko Yeesu arhegeka oku bamuleerhere abo baana n'okuderha ntya: «Muleke abaana bayinje emunda ndi! Murhababuzaga, bulaala oBwami bwa Nnamahanga buli bw'abantu bali kuguma nabo. ");
INSERT INTO hav_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Mbabwirire okuli: omuntu orhayankiriire oBwami bwa Nnamahanga nka mwana mudoorho arhakabuja mo chiro n'ehityu.» ");
INSERT INTO hav_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Omukulu muguma w'aBayaahudi abaza Yeesu ntya: «Mwigiriza mwinja, bichi ngwasize kujira yi mbona akalamo k'esiku n'amango?» ");
INSERT INTO hav_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yeesu amushubiza ntya: «Gurhe wankanyirika mwinja? Nta muntu mwinja, arhali Nnamahanga yenyine. ");
INSERT INTO hav_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Sy'omenyere amarhegeko: ‹Orhahushaga, orhayirhaga, orhazimbaga, orhahamiirizaga obubeeshi, okenge yisho na nyoko.›» ");
INSERT INTO hav_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Oyo mukulu ashubiza ntya: «Ama marhegeko mooshi namakengere gurhenga ndi musole.» ");
INSERT INTO hav_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yeesu abeere ayunva ntyo, amubwira ntya: «Hachikubuliire kandi chintu chiguma: oguze ebintu byooshi ogwerhe, efuranga zarhenga mo ozigabire abakene, nji wanaja wagwarha obuchire omu mpingu. Wanaja wayinja n'okunkulikira.» ");
INSERT INTO hav_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Aliko oyo muntu abeere ayunva ntyo, agaya bweneene, bulaala aliiri muchire bweneene. ");
INSERT INTO hav_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yeesu abwene oku agayire, aderha ntya: «Okuli, bikomereere abachire kuja omu Bwami bwa Nnamahanga! ");
INSERT INTO hav_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Bulaala kuyoloheere bweneene engamiya kugera omu hirhule hy'esindani ahaali h'omugale kuja omu Bwami bwa Nnamahanga.» ");
INSERT INTO hav_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Abantu baliiri bamuyunviriza baderha ntya: «Nde leero wagachungulwa?» ");
INSERT INTO hav_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yeesu ashubiza ntya: «Ebirhakagalika oku bantu byakagalika emwa Nnamahanga.» ");
INSERT INTO hav_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Petero aja aderha ntya: «Tala oku rhwewe rhwalekere ebintu rhwali rhugwerhe yi rhugukulikira.» ");
INSERT INTO hav_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yeesu ababwira ntya: «Mbabwire okuli, nta muntu walekere enju, mukaage, beene baabo, abazeere baage changwa abaana baage elugulu w'obwime bwa Nnamahanga, ");
INSERT INTO hav_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","orhakayankirira ebintu binene mu mano mango, n'omu siku zayinja nj'abona akalamo k'esiku n'amango.» ");
INSERT INTO hav_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Buzinda bw'aho, Yeesu arhoola zila ntumwa zaage ekumi n'ebiri n'okuzibwira ntya: «Tala oku rhwazamuukira eYerusaleema; byooshi byayandikwaga n'abaleebi bilolere Mwene oMuntu byajirika. ");
INSERT INTO hav_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Bulaala nj'ahaanwa oku barhali Bayaahudi. Nji bamushinyagulira, nji bamulibuza, nji bamuchiira ko, ");
INSERT INTO hav_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","nji bamushuurha, nji banamuyirha. N'olusiku lwa gasharhu nj'afuuka.» ");
INSERT INTO hav_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Aliko barhayunvaga eby'echi chinwa chiderhere, bulaala byaali bishirwe. Barhaalimenyere bichi Yeesu ashondaga kuderha. ");
INSERT INTO hav_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Amango Yeesu ayegeeraga egishagala ch'eYeeriko, haliiri empumi nguma yali yikeere eburhambi bw'enjira ey'eri yahemuuza. ");
INSERT INTO hav_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Eyo mpumi yayunva abantu banene yi baagera, yanabaza bichi byabeere. ");
INSERT INTO hav_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Bayishubiza ntya: «Yeesu w'eNazareeti yeeri kulenga.» ");
INSERT INTO hav_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Empumi yaliika omulenge: «Yeesu, Mwene Daawudi, ombeere obonjo!» ");
INSERT INTO hav_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Abaliiri balambagira embere bayikalihira yi bayisizya, aliko yayaama bweneene: «Mwene Daawudi, ombeere obonjo!» ");
INSERT INTO hav_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yeesu ayimanga n'ogurhegeka oku bayileerhere ye. Empumi yabeere yaagera hoofu naye, Yeesu ayibaza ntya: ");
INSERT INTO hav_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«Gichi oshondere nkujirirage?» Yashubiza ntya: «Nnaweerhu, nshube mbone.» ");
INSERT INTO hav_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yeesu ayishubiza ntya: «Shuba kubona; obwemeezi bwawe bwagufumize.» ");
INSERT INTO hav_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ho n'aho yabona n'okumukulikira ey'eri yakuuza Nnamahanga. Olubaga looshi lwabeere lwabona ebyoola, lwarhondera gukuuza Nnamahanga. ");
INSERT INTO hav_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yeesu aliiri abalama kugerera omu gishagala ch'eYeeriko. ");
INSERT INTO hav_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Mw'echo gishagala mwaliiri omuntu muguma oyirikwa Zaakayo. Oyo Zaakayo aliiri mukulu w'abafurhiisa b'amakooli. Aliiri muchire. ");
INSERT INTO hav_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Agendaga ashonda kubona Yeesu ali nde. Aliko, elugulu w'abantu banene arhakamubwene bulaala aliiri muufu. ");
INSERT INTO hav_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Alibirhira embere, anashona oku murhi g'omukuyu y'abona Yeesu, kwenge alikwaneene kulenga ahoola. ");
INSERT INTO hav_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yeesu abeere agera ahoola, ayinamula ameesho anamubwira ntya: «Zaakayo, shonooka juba; bulaala bimpemere ndyaame emwawe zeene.» ");
INSERT INTO hav_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zaakayo ashonooka juba, ayankirira Yeesu n'obushagaluke bunene. ");
INSERT INTO hav_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Abantu booshi baabonaga ebyoola, balunduma n'okuderha ntya: «Mulolage! Oyu muntu ajiire kulyaama emw'omunyabyaaha!» ");
INSERT INTO hav_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Aliko Zaakayo ayimanga, abwira Nnaweerhu ntya: «Nnaweerhu! Naaha abakene oluhande lw'ebintu byaani, n'akaba hali eyi nalengenye echintu chaage, namugalulira cho eyi nkubire cho kane.» ");
INSERT INTO hav_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yeesu amubwira ntya: «Zeene obuchunguke bwahikire mw'eyila nju, bulaala oyu naye ali mugala w'Abrahaamu. ");
INSERT INTO hav_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Kwenge Mwene oMuntu ayinjire gushonda n'oguchungula abaherere.» ");
INSERT INTO hav_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Abantu babeere bayunva ebyoola, bakengeera okw'obwime bwa Nnamahanga bukola kubonekana ho n'aho, bulaala Yeesu aliiri hoofu n'eYerusaleema. Aja ashuba kubachiira ogu mugani. ");
INSERT INTO hav_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Aderha ntya: «Haliiri murhwali muguma wajaaga omu gihugo cha hale mpu aje kuyimikirwa yo, buzinda agaluke kuyima omu gihugo chaage. ");
INSERT INTO hav_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ahamagala bantu ekumi omu baja baage, abaha bicheri ekumi n'okubabwira ntya: ‹Murhimbuule n'ezi furanga kugera amango nagaluka.› ");
INSERT INTO hav_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Aliko abantu b'egihugo chaage babaaga bamugayire. Baarhuma abantu enyuma zaage kuderha ntya: ‹Rhurhashonda oyu muntu abe mwami weerhu.› ");
INSERT INTO hav_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","«Abeere ayimikirwe, agaluka, ahamagaza bala baja ahaaga efuranga, mpu amenye enyungu nchi babwene omu burhimbuuzi. ");
INSERT INTO hav_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Omuja mwambere achimoleka n'okuderha ntya: ‹Waliha, egicheri chaawe chayungukire bindi ekumi.› ");
INSERT INTO hav_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Mwami amubwira ntya: ‹Kooko, oli muja mwinja; bulaala orhabeere muhemusi omu bintu bigeeke, wagwarha oburhegesi oku bishagala ekumi.› ");
INSERT INTO hav_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Omuja wakabiri ayinja n'okuderha ntya: ‹Waliha, egicheri chaawe chayungukire bindi birhaano.› ");
INSERT INTO hav_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Mwami amubwira ntya: ‹Naawe waaba murhegesi wa bishagala birhaano.› ");
INSERT INTO hav_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Owindi muja ayinja n'okuderha ntya: ‹Waliha, tala egicheri chaawe, nalichibiikire omu gitambara, ");
INSERT INTO hav_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","kwenge nali nkuyuubahire, bulaala oba muntu mudaarhi bweneene. Wooyo onarhoola eby'orhabiikaga, n'ogushaluula eby'orhahingaga.› ");
INSERT INTO hav_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Mwami amubwira ntya: ‹Wooyo oli muja mubi, naguchiira olushinja gukulikirana n'ebinwa byaawe. Akaba waliyinji oku mba mudaarhi, oku ntoola ebi ntabiikaga n'oku nshaluula ebi ntahingaga, ");
INSERT INTO hav_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","bichi byarhumaga orhahira efuranga zaani omu banke? Omu kugaluka kwani, nakazirhoolere n'enyungu!› ");
INSERT INTO hav_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Mwami aja abwira abantu baliiri ho ntya: ‹Mumunyage echo gicheri mugihe olaala ogwerhe bicheri ekumi.› ");
INSERT INTO hav_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Babwira mwami ntya: ‹Waliha, oyoola akola agwerhe bicheri ekumi!› ");
INSERT INTO hav_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Abashubiza ntya: ‹Mbabwirire oku ogwerhe akantu yi nji baheereza akandi, aliko orhagwerhe kantu nji bamunyaga n'ehintu hityuuli agwerhe. ");
INSERT INTO hav_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","N'bashombanyi baani boowe, barhalishondere oku mbe mwami waabo, mubaleerhe hano munabayirhire embere zaani.›» ");
INSERT INTO hav_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yeesu abeere amala kuderha ntyo, aja embere z'abantu eyi bali bayeerekera eYerusaleema. ");
INSERT INTO hav_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Abeere agera hoofu n'egishagala ch'eBetefaage n'eche Betaniiya, hoofu n'omusozi gw'eMizeyituuni, arhuma bigirizwa baage babiri, ");
INSERT INTO hav_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ababwira ntya: «Muje omu gishagala chiri embere zenyu. Hano muchigera mo, mwashimaana omwana gw'epunda gushwekerwe, nta muntu oshubiraga yikala oku go. Mugishwekuule munachileerhe. ");
INSERT INTO hav_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Nka hali omuntu obabazize ntya: ‹Gichi girhumire muli mwagishwekuula?› Mumushubize oku Nnaweerhu achilagire ko.» ");
INSERT INTO hav_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Abo bigirizwa barhumwaga bagenda, banabugaana byooshi nk'oku Yeesu ababwiraga. ");
INSERT INTO hav_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Babeere bali bashwekuula omwana gw'epunda, banyina go bababaza ntya: «Gichi girhumire muli mwashwekuula ogu mwana gw'epunda?» ");
INSERT INTO hav_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Baashubiza ntya: «Nnaweerhu agulagire ko.» ");
INSERT INTO hav_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Baja baguleerhera Yeesu. Baava baasasa ko emyambalo n'okumuyikaza ko. ");
INSERT INTO hav_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Okw'ali agenda, abantu baalema baasasa emyambalo yaabo omu njira. ");
INSERT INTO hav_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Yeesu abeere ali ayegeera hoofu n'omwandagalo gw'omusozi gw'eMizeyituuni, echigusho chooshi ch'abigirizwa baage, babaaga bali kugenda baamoga. Babaaga bali bakuuza Nnamahanga n'omulenge munene, elugulu w'ebisomereene byooshi bali babwene ko. ");
INSERT INTO hav_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Baliiri kuderha ntya: «Agishwe, oMwami wayinjire, oku ziino lya Nnaweerhu! Omurhuula gube omu mpingu n'obulangashane emwa Nnamahanga!» ");
INSERT INTO hav_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","aBafarisaayo baguma, baliiri omu lubaga lw'abantu, babwira Yeesu ntya: «Mwigiriza, okalihire abigirizwa baawe basire.» ");
INSERT INTO hav_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yeesu abashubiza ntya: «Mbabwirire byo, bagasira, amabaale mo mayaama!» ");
INSERT INTO hav_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Amango Yeesu ageraga hoofu n'egishagala ch'eYerusaleema, abeere abona cho, alakira cho. ");
INSERT INTO hav_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Aderha ntya: «Nka naawe wamenyaga zeene ebyagakuleerhera omurhuula! Aliko bunoola bibishirwe, orhakabibona. ");
INSERT INTO hav_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Kwenge esiku zakuyinjira amango bashombanyi baawe bakuzirhira ko olugurhu, bakugorha n'okugufundeeza enyunda zooshi. ");
INSERT INTO hav_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Baguhomboola looshi, wooyo n'abantu baawe. Barhagakulekera baale oku lindi, bulaala orhamenyaga egihe Nnamahanga ayinjaga gukulwira ko!» ");
INSERT INTO hav_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yeesu abeere aja omu Nju ya Nnamahanga, arhondera kulibisya abarhimbuuzi. ");
INSERT INTO hav_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ava ababwira ntya: «Biyandikirwe: ‹Enju yaani nji yaaba nju y'amasaala.› Aliko mwabo mwayijirire lukunda lw'abeezi!» ");
INSERT INTO hav_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yeesu agendaga ayigiriza esiku zooshi omu Nju ya Nnamahanga. Abakulu b'abadaahwa, abigiriza b'amarhegeko n'abashamuka b'aBayaahudi balemaga bashonda kumuyirha. ");
INSERT INTO hav_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Aliko bafundwa, bulaala abantu booshi baliiri bamuyunviriza bwinja buzira kuluha. ");
INSERT INTO hav_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Lusiku luguma, oku Yeesu ali ayigiriza abantu omu Nju ya Nnamahanga n'okubala oMwanzi Mwinja, ho n'aho abakulu b'abadaahwa n'abigiriza b'amarhegeko, haguma n'abashamuka b'aBayaahudi baahulukira. ");
INSERT INTO hav_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Baava baamubaza ntya: «Orhubwire oku burhegesi bwa nde oli waajira ebi bintu. Nde ye waguhaaga obu burhegesi?» ");
INSERT INTO hav_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yeesu abashubiza ntya: «Naani, nababaza echibazo chiguma, munshubize: ");
INSERT INTO hav_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","‹Obubatiizo bwa Yohaana ka bwarhengeraga empingu changwa emw'abantu?›» ");
INSERT INTO hav_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Babwirana ntya bonyine oku bonyine: «Rhukaderha okw'empingu, arhubaza gichi charhumaga rhurhamuyemeera. ");
INSERT INTO hav_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Kandi rhugashubiza oku emw'abantu, olubaga looshi lwarhuyirhiisa amabaale, kwenge lwali luyemereere oku Yohaana aliiri muleebi.» ");
INSERT INTO hav_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ntyo ku bamushubiize oku barhenji ngahe bwarhengeraga. ");
INSERT INTO hav_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yeesu aja ababwira ntya: «Ko n'oko naani, ntababwira oku burhegesi bwa nde njira ebi bintu.» ");
INSERT INTO hav_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Kandi Yeesu ashuba kubachiira guno mugani: «Haliiri muntu muguma wahingaga eshwa ly'emizabiibu, aliyadiisa abahinzi n'okubalama siku zinene. ");
INSERT INTO hav_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Egihe ch'ogushaluula chabeere chagera ho, arhuma omuja waage emwa bala bahinzi mpu bamuheerezage amaage malehe m'eshwa. Aliko abo bahinzi bashuurha oyo muja n'okumugalula maboko moomu. ");
INSERT INTO hav_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Nyina eshwa ashuba gurhuma owindi muja. Naye bamushuurha, bamudukanga, banamugalula maboko moomu. ");
INSERT INTO hav_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ashuba gurhuma omuja wa gasharhu. Bamukoromesa, banamukabula embuga. ");
INSERT INTO hav_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Nyina eshwa aderha ntya: ‹Gurhe naaja naajira? Naaja narhuma mugala waani muzigirwa, nkabaga yeewe bamukenga.› ");
INSERT INTO hav_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Aliko balaala bahinzi babeere bamulangiira, babwirana ntya: ‹Tala, oyuula yi waaba nyina agashambala! Rhumuyirhe, y'agashambala kaba keerhu.› ");
INSERT INTO hav_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Bamukuula omu shwa, banamuyirha.» Yeesu aja abaza abantu ntya: «Nyina eshwa gurhe nj'ajira aboola bahinzi? ");
INSERT INTO hav_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Nj'agaluka, nj'anayirha aboola bahinzi, nj'anaheereza abandi eshwa.» Abantu babeere bayunva ntyo, baaderha ntya: «Ebiri ntya birhahira bikaba!» ");
INSERT INTO hav_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Aliko Yeesu abaloleereza, aderha ntya: «Echi chinwa chiyandikirwe gurhe chiderhere? Ebaale ab'okuyumbaka balahiraga, lyo lyahindukire ly'engenzi, ly'okuyumbakira ko. ");
INSERT INTO hav_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ngasi muntu nji wakumbagala kw'eryo baale nj'avunagulika; n'eyi nji lyarhogera ko nji lyamuhomboola.» ");
INSERT INTO hav_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ho n'aho, abigiriza b'amarhegeko n'abakulu b'abadaahwa bashonda ogushweka Yeesu, bulaala bali bayinji oku bo baderherwe mw'ogu mugani. Aliko bayuubaha abantu. ");
INSERT INTO hav_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Abo bakulu b'aBayaahudi barhondera guhenguuza Yeesu. Baamurhumira abantu b'okumuneeka, baliiri kubonekana nka bali b'okuli yi bamufarhira omu nderho, n'okulengera eyo njira bagale kumuhaana omu maboko m'omurhegesi w'egihugo. ");
INSERT INTO hav_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Aba bantu baabaza Yeesu ntya: «Mwigiriza, rhuyinji oku oderha n'okuyigiriza bwinja; orhajira kaboolo, aliko oyigiriza enjira ya Nnamahanga gukulikirana n'okuli. ");
INSERT INTO hav_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Orhubwirage leero, k'amarhegeko meerhu mayemereere changwa malahiire gufurha ekooli emwa Kayizaari?» ");
INSERT INTO hav_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Aliko Yeesu amenya obulyaalya bwabo, ababaza ntya: ");
INSERT INTO hav_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«Munyereke egicheri chiguma ch'edinaari. Giheekere eshusho n'eziino lya nde?» Baashubiza ntya: «Biri bya Kayizaari.» ");
INSERT INTO hav_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Yeesu aja ababwira ntya: «Mugende mwaheereza Kayizaari ebiri byaage, na Nnamahanga naye ebiri byaage.» ");
INSERT INTO hav_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Bafundwa kumufarhira oku chiguma omu binwa byaage embere z'olubaga. Basoomererwa egishubizo chaage, baava baasira. ");
INSERT INTO hav_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Buzinda bw'aho, aBasadukaayo baguma baaja emwa Yeesu. aBasadukaayo bo barhayemeeraga obufuuke bw'abafu. Bayinja kubaza Yeesu ntya: ");
INSERT INTO hav_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","«Mwigiriza, tala oku Muusa arhuyandikiire ntya: ‹Nk'omulume aligwerhe omukazi, aliko agafa buzira mwana, mwene waabo anarhoola oyo mukazi n'okuburhira nyagufa abaana.› ");
INSERT INTO hav_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Leero haliiri bazaana mushanvu ba nda nguma. Omwambere ashaba n'ogufa buzira mwana. ");
INSERT INTO hav_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Owakabiri naye ayingira ola mukazi, naye afa buzira mwana. ");
INSERT INTO hav_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","N'owagasharhu naye ko n'oko. Byaaba ntyo oku booshi mushanvu, baafa buzira kuleka abaana. ");
INSERT INTO hav_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Aha buzinda, ola mukazi naye afa. ");
INSERT INTO hav_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Leero amango m'ogufuuka, oyo mukazi nj'aba wa nde? Bulaala aliiri mukaabo booshi oku bali mushanvu!» ");
INSERT INTO hav_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yeesu abashubiza ntya: «Mu lino gulu, abalume n'abakazi yi bashabana. ");
INSERT INTO hav_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Aliko abaganjirwe kulama mw'elyo gulu lyayinja n'ogufuuka gurhenga omu bafu nji barhaashaba changwa gushabwa. ");
INSERT INTO hav_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Barhaakanafa, bulaala bali kuguma na bamalahika, bali bagala ba Nnamahanga kwenge bafuukire. ");
INSERT INTO hav_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Muusa ayerekeene bwinjabwinja oku abafu nji bafuuka. Omu mandiko maage aderhere elugulu w'egishaka chagulumiraga. Yeewe aderhere oku Nnaweerhu ali ‹Nnamahanga wa Abrahaamu, Nnamahanga wa Isaka na Nnamahanga wa Yakobo.›» ");
INSERT INTO hav_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Yeesu ashuba kuderha ntya: «Nnamahanga arhali w'abafu, aliko w'abalamire; kwenge oku yeewe booshi balamire.» ");
INSERT INTO hav_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Abigiriza baguma b'amarhegeko bashubiza ntya: «Mwigiriza, waderhere bwinja.» ");
INSERT INTO hav_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Barhagishubiraga chiro kubaza liguma. ");
INSERT INTO hav_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yeesu abaza abantu baliiri ahoola ntya: «Gurhe abantu bakaderha mpu Krisitu ali mugala wa Daawudi? ");
INSERT INTO hav_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Daawudi yenyine aderhere ntya omu gitaabu ch'eNanga: ‹Nnaweerhu Nnamahanga abwirire Nnaweerhu ntya: “Yikale ekulyo kwani, ");
INSERT INTO hav_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","guhika amango nji naajira bashombanyi baawe ndabarhiro yaawe.”› ");
INSERT INTO hav_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Leero akonva Daawudi amuyirikire Nnaweerhu, gurhe akaja aba mugala waage?» ");
INSERT INTO hav_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Abantu booshi babeere bali bayunviriza Yeesu, abwira abigirizwa baage ntya: ");
INSERT INTO hav_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«Muchilange oku bigiriza b'amarhegeko. Basiima guchilambagiza n'efulema zileehere, n'okulamuswa n'obukenge ah'abantu banene bali, okuyikala oku ntebe z'embere omu masinagoogi n'omu madinye. ");
INSERT INTO hav_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Bananyaga abashumbakazi ebintu byaabo byooshi. N'omu guchisiisa, banajira amasaala maleehere. Abo bantu, nji baahanwa bweneene.» ");
INSERT INTO hav_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yeesu ayinamula ameesho, abona abagale bali bahira entuulo zaabo omu gasanduku k'entuulo k'omu Nju ya Nnamahanga. ");
INSERT INTO hav_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Abona omushumbakazi muguma w'omukene naye ahira mo rhucheri rhubiri rhw'efuranga. ");
INSERT INTO hav_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Yeesu ava aderha ntya: «Okuli mbabwirire, oyu mushumbakazi w'omukene arhuulire kulusha abandi booshi; ");
INSERT INTO hav_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","kwenge abandi bantu booshi barhuulire nka ntuulo efuranga barhaalichilagire ko. Aliko yeewe, omu bukene bwage, arhuulire byooshi aligwerhe by'okulama nabyo.» ");
INSERT INTO hav_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Bantu baguma babeere bali baderha okw'eNju ya Nnamahanga eyumbakirwe n'amabaale menja, na kandi epambirwe n'ebintu abantu barhuuliraga Nnamahanga, Yeesu aderha ntya: ");
INSERT INTO hav_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","«Hayinja esiku, ebiila muli kubona ko, harhagasigala baale oku lindi lirhagahiningulwa.» ");
INSERT INTO hav_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Abo bantu baabaza Yeesu ntya: «Mwigiriza, lyaali ebyoola nji byaahika? Kimenyeeso gichi nji chayeerekana oku byashonda kujirika?» ");
INSERT INTO hav_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yeesu ashubiza ntya: «Muchilange, mumenye mwagahera. Bantu banene nji bayinja omu gukoleesa eziino lyaani n'okuderha ntya: ‹Nye Masiiya!›, na kandi: ‹Egihe chayeneere!› Aliko murhabakulikiraga. ");
INSERT INTO hav_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Amango nji mwayunva badeerha emyaazi y'ebiirha na ey'okulwisa abarhegesi, murhayuubahaga. Kwenge ebyoola bikwaneene gurhanga kujirika. Aliko eyi burhaza kuba b'obuzinda bwa lino gulu.» ");
INSERT INTO hav_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Yeesu aja alema ababwira ntya: «Egihugo nji chalwisa echindi gihugo, n'obwami nji bwalwisa obwindi bwami. ");
INSERT INTO hav_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Nji haaba emisisi mineneenene, n'omu hantu hanene, nji haaba enzara n'endwala zinene z'okuyaahukira. Nji haaba kandi ebigiriginjo biyuubahize n'ebimenyeeso by'arhengera omu nkuba.» ");
INSERT INTO hav_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","«Aliko, embere z'ebi byooshi, abantu nji babagwarha n'okubalibuza. Nji babahaana omu masinagoogi, nji banabahira omu munyororo. Ko n'oko, nji babasidaakira embere z'abaami n'abakulu b'egihugo elugulu w'eziino lyaani. ");
INSERT INTO hav_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ebyoola nji byaarhuma mwahamiiriza ebi munyinji ko. ");
INSERT INTO hav_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Mumenye bwinja omu mirhima yenyu oku murhakwaneene gurheganya gurhe mwabuurana. ");
INSERT INTO hav_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Bulaala nyoono, nji naabaha nyenyine echinwa n'obwenge bunene, oku bulyo bashombanyi benyu barhakagala kubahima changwa kulahira ebi mwaderhere. ");
INSERT INTO hav_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Nji mwalenganywa n'abazeere benyu, na beene benyu, na ab'omulala gwenyu, na beera benyu. Na baguma omu mwabo nji bayirhwa. ");
INSERT INTO hav_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","«Abantu booshi nji babashomba elugulu w'eziino lyaani. ");
INSERT INTO hav_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Aliko nta luviiri luguma l'oku rhwe lyenyu nji lwahera. ");
INSERT INTO hav_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Omu guchihangaana kwenyu, mwachungula akalamo kenyu.» ");
INSERT INTO hav_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","«Hano nji mubona egishagala ch'eYerusaleema chagorherwe n'ebigusho by'abasoda, mwanaja mwamenya oku ogushandaazwa kwacho kwagerere hoofu. ");
INSERT INTO hav_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Leero, abantu nji baaba bali eYudeeya balibirhire omu misozi. N'aba nji baaba bali omu gishagala ch'eYerusaleema barhenge mo, n'aba nji baaba bali omu rhwango barhajaaga eYerusaleema. ");
INSERT INTO hav_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Kwenge nji zaaba siku z'oguhanwa kw'abantu, yi byooshi biyandikirwe bijirika. ");
INSERT INTO hav_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Buhanya buchi oku bakazi nji baaba bali bukule n'oku balaala nji baaba bali kuyonsa mw'ezoola siku! Nji haaba amalibuko manene omu gihugo, n'oburhe bwa Nnamahanga nji bwaba kw'olu lubaga. ");
INSERT INTO hav_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Baguma nji bayirhwa n'engoorho, abandi nji baheekwa buja omu bihugo byooshi, na Yerusaleema nj'alabarhwa n'abapagaani, kugera amango egihe chaabo nji chayeenera.» ");
INSERT INTO hav_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","«Nji haaba ebimenyeeso omu zuuba, omu gahembi n'omu nyenyeezi. Na hano oku gulu nako, embaga nji zaaba omu malibuko n'ogufarhwa n'obuuba elugulu w'olwamo n'emilaba y'enyanja. ");
INSERT INTO hav_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Abantu nji baalaba n'obuuba bunene omu kulinga ebi nji byayinjira egulu, kwenge byooshi bigwerhe obuhashe omu chaalege nji byashaganywa. ");
INSERT INTO hav_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Nji baaja baabona Mwene oMuntu ayinjire omu bichu haguma n'obuhashe n'obukuuze bunene. ");
INSERT INTO hav_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Hano ebyoola nji birhondera kuyinja, muyimange bwinjabwinja murhanayuubahaga, bulaala obuchunguke bwenyu bwayegereere.» ");
INSERT INTO hav_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Buzinda bw'aho, Yeesu abachiira guno mugani: «Mulole omurhi gw'omutiini n'eyindi mirhi yooshi. ");
INSERT INTO hav_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Eyi mubona yaashoga, munamenya mwenyine okw'echanda chiri hoofu. ");
INSERT INTO hav_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ko n'oko kandi, amango nji mwabona ebyoola byayinja, mumenye okw'obwime bwa Nnamahanga buli hoofu. ");
INSERT INTO hav_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Okuli, mbabwirire, echi gisisi girhakagera ebyoola byooshi birhanaza kuyinja. ");
INSERT INTO hav_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Empingu n'egulu nji byaahirima, aliko ebinwa byaani birhagahirima.» ");
INSERT INTO hav_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Yeesu ashuba kuderha ntya: «Muchilange, emirhima yenyu yakayinja zikira omu budambi, omu bulalu, n'enyifinjo z'akalamo, y'olusiku luzinda lwakayinja kubagera ko buzira kumenya, ");
INSERT INTO hav_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","kula omurhego gushuuduka. Kwenge nji lwayinjira abantu booshi balamire oku gulu. ");
INSERT INTO hav_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Mutarame, munasaliire ngasi gashanji, yi mugwarha emisi y'ogufuma byooshi byayinja, n'okugala kuyimanga embere za Mwene oMuntu.» ");
INSERT INTO hav_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Mw'ezoola siku, Yeesu agendaga ayigiriza omu Nju ya Nnamahanga ezuuba. N'obudufu, agendaga aja kulyaama oku musozi gw'eMizeyituuni. ");
INSERT INTO hav_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Olubaga looshi lwagendaga lwaja emunda ali omu Nju ya Nnamahanga eseeziseezi kumuyunviriza. ");
INSERT INTO hav_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Olusiku lukulu lw'emigati nzira chachu, luyirikwa Paasaka, lwabaaga luli hoofu. ");
INSERT INTO hav_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Abakulu b'abadaahwa n'abigiriza b'amarhegeko baliiri bashonda gurhe bakayirhiisa Yeesu. Aliko baliiri bayuubaha olubaga. ");
INSERT INTO hav_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Shetaani aja aja mu Yuuda, ola bayirikaga Isikariyooti, waliiri muguma w'omu zila ntumwa ekumi n'ebiri. ");
INSERT INTO hav_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yuuda aja kuganiira haguma n'abakulu b'abadaahwa n'abakulu b'abalanzi b'eNju ya Nnamahanga gurhe akalenganya Yeesu emunda bali. ");
INSERT INTO hav_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Basiima n'okulagaanana okumuha efuranga. ");
INSERT INTO hav_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yuuda ayemeera n'ogurhondera kulonza agashanji gakwiriire k'okumuha bo buzira abantu kumenya. ");
INSERT INTO hav_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Olusiku lukulu lw'emigati nzira chachu lwahika. Olo lusiku, y'aBayaahudi balikwaneene kubaaga omwanabuzi gw'ePaasaka. ");
INSERT INTO hav_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yeesu arhuma Petero na Yohaana ntya: «Muje gurhurheganyiza ebiryo by'ePaasaka, rhuyinje kubisangira.» ");
INSERT INTO hav_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Baamubaza ntya: «Ngahe osiimire rhubirheganyizage?» ");
INSERT INTO hav_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Abashubiza ntya: «Muyunvirize, hanoola muhika omu gishagala, mwashimaana omulume oheekere endaha y'amenji. Mumukulikire omu nju ayinja kuja mo. ");
INSERT INTO hav_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Mwakabwira nyina enju ntya: ‹Mwigiriza abazize mpu ngahe echumbi liri aliira mw'ebiryo by'ePaasaka haguma n'abigirizwa baage.› ");
INSERT INTO hav_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Abayeereka echumbi linene lirheganyizwe omu gorofa, omoola mu mwarheganyiza ebiryo.» ");
INSERT INTO hav_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Bagenda, bashimaana ebintu byooshi kulaala Yeesu ababwiraga. Baaja barheganya ebiryo by'ePaasaka. ");
INSERT INTO hav_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ebishanji by'okulya byabeere byaahika, Yeesu ayikala kulya haguma n'entumwa zaage. ");
INSERT INTO hav_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Azibwira ntya: «Nachifiijaga bweneene kulya haguma nenyu eyi Paasaka embere ndibuke. ");
INSERT INTO hav_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Kwenge, mbabwirire okuli, ntagachiyirya kugera amango nji yayeenera omu Bwami bwa Nnamahanga.» ");
INSERT INTO hav_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Arhoola engumbu y'edivaayi, akuuza Nnamahanga n'okuderha ntya: «Murhoole eyi ngumbu, ngasi muguma anywe ko. ");
INSERT INTO hav_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Kwenge mbabwirire okuli, ntagachinywa chiro oku divaayi y'omuzabiibu kugera amango Nnamahanga nji ayimanza obwime bwage.» ");
INSERT INTO hav_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ashuba gurhoola omugati. Abeere amala gukuuza Nnamahanga, agucha mo, abaheereza go n'okuderha ntya: «Oguula guli mubiri gwani, guhaanirwe elugulu wenyu. Mugende mwajira ntya omu kunyibuka.» ");
INSERT INTO hav_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ko n'oko enyuma z'okulya, arhoola engumbu, aderha ntya: «Eyi ngumbu eri gihango gihyaahya cha Nnamahanga haguma n'abantu baage kulengera eshagama yaani yasheeshekala elugulu wenyu.» ");
INSERT INTO hav_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","«Aliko tala k'owampaana ali kulya haguma naani. ");
INSERT INTO hav_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Mwene oMuntu aja gufa nk'oku Nnamahanga arheganyaga. Aliko, buhanya buchi oku muntu wamuhaana!» ");
INSERT INTO hav_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Abigirizwa baava barhondera kubazana nde omu boowe waajira echi chintu. ");
INSERT INTO hav_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Buzinda, haahulukira entonganyi ahagarhi k'abigirizwa ba Yeesu, mpu nde wakaba mukulu ahagarhi kaabo. ");
INSERT INTO hav_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yeesu abwira bo ntya: «Abaami b'abapagaani banabarhegeka nka baja, n'abagwerhe obuhashe oku bantu bachiyirika ‹banyamenja.› ");
INSERT INTO hav_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Aliko mwabo, birhabaaga ntyo. Ahuubwe, oli mukulu omu mwabo ahinduke nka ye mudoorho, n'orhambwire, abe nka ye mukozi. ");
INSERT INTO hav_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Leero, nde y'eri mukulu oku windi: oyikeere n'okulya changwa oli kumuyuuhulira? K'arhali olaala oyikeere n'okulya? Ahuubwe, nyoono ndi ahagarhi kenyu nka mukozi. ");
INSERT INTO hav_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","«Mwewe mwachihangaanire kubeera haguma naani omu bigeregezo byaani. ");
INSERT INTO hav_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Cho girhumire mbarheganyiize obwami nk'oku naani Daarha abunrheganyizaga, ");
INSERT INTO hav_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","yi mulya n'okunywa oku meeza maani, omu Bwami bwani. Kandi muyikale oku ntebe z'obwami yi muchiira olushinja emilala ekumi n'ebiri y'eIsraheeli.» ");
INSERT INTO hav_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yeesu ashuba kuderha ntya: «Simooni, Simooni, Shetaani abahemere oku mugere omu bigeregezo kuguma n'oku bayeera amahemba. ");
INSERT INTO hav_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Aliko nagusaliriire wooyo Simooni, y'obwemeezi bwawe burhaheraga looshi. Na hanoola ongalukira, okomeze beene benyu.» ");
INSERT INTO hav_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Petero amubwira ntya: «Nnaweerhu, nayemereere kugenda naawe nachiro akaba omu munyororo changwa omu lufu.» ");
INSERT INTO hav_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yeesu amushubiza ntya: «Petero, nkubwirire okuli, embere oluhazi lubike zeene, waaba eyi wamampakana gasharhu oku orhanyinji.» ");
INSERT INTO hav_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Yeesu ashuba kubabaza ntya: «Amango nabarhumaga buzira shaho, buzira chigunira n'ebiraato, ka mwalibulire chintu?» Bamushubiza ntya: «Ntaacho.» ");
INSERT INTO hav_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Yeesu ababwira ntya: «Ahuubwe leero, ogwerhe eshaho n'echigunira abirhoole. N'orhagwerhe engoorho aguze efulema yaage y'agula nguma. ");
INSERT INTO hav_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Kwenge mbabwirire okuli, bihemere ebiyandikirwe binjirike ko: ‹Bamuganjire omu bajira amabi.› Leero, ebiyandikirwe elugulu waani bikola kujirika.» ");
INSERT INTO hav_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Abigirizwa bamubwira ntya: «Nnaweerhu, tala ngoorho ebiri.» Naye ababwira ntya: «Mulekere ahoola!» ");
INSERT INTO hav_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yeesu arhenga mw'echo gishagala, aja oku musozi gw'eMizeyituuni nka okw'azigaanaga. Abigirizwa baage bamukulikira. ");
INSERT INTO hav_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Agerere ahoola, ababwira ntya: «Musaliire, yi murhaja omu bigeregezo.» ");
INSERT INTO hav_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ava achikuula haguma nabo, aja oku bule nka ah'omuntu akagala kulekera ebaale, afukama, asaliira Nnamahanga ntya: ");
INSERT INTO hav_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","«Daarha, akaba ntya b'obulonza bwawe, ohire hale naani eyi ngumbu y'amalibuko. Aliko, burhabaaga bulonza bwani bo bujirikage, sy'obulonza bwawe.»  ");
INSERT INTO hav_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ho n'aho, malahika amubonekera gurhenga empingu gushuba kumuheereza emisi. ");
INSERT INTO hav_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yeesu abeere ababeere bweneene, ashuba gusaliira n'obushiru kulusha. Entuubano yaage yaba nka mirhonyi y'eshagama eri gurhoga oku budaka. ");
INSERT INTO hav_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Amalire gusaliira, ayimanga n'okuja emunda abigirizwa bali. Ashimaana balyaamire elugulu w'amaganya manene. ");
INSERT INTO hav_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Abaza bo ntya: «Charhumire mwalyaama? Muzuuke munasaliire, yi murhaja omu bigeregezo.» ");
INSERT INTO hav_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yeesu abeere achiri aderha, ho n'aho abantu banene baahika. Yuuda, ola muguma w'omu zila ntumwa ekumi n'ebiri, aliiri kulambagira embere zaabo. Ashegera hoofu na Yeesu y'amuhoobera. ");
INSERT INTO hav_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Yeesu amubaza ntya: «Yuuda, omu kumuhoobera mu wamalenganya Mwene oMuntu?» ");
INSERT INTO hav_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Abigirizwa baliiri haguma na Yeesu babeere baabona ebyaja kuba, baamubaza ntya: «Nnaweerhu, ka rhubashogoorhe n'engoorho?» ");
INSERT INTO hav_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ho n'aho, mwigirizwa muguma ashinjibula ogurhwi kw'emalyo k'omuja w'omudaahwa mukulu. ");
INSERT INTO hav_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Aliko Yeesu aderha ntya: «Lekera aho!» Ava ahuma oku gurhwi k'oyo mulume n'okugufumya. ");
INSERT INTO hav_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Omu bayinjaga gufarha Yeesu mwaliiri abakulu b'abadaahwa, abimangizi b'abalanzi b'eNju ya Nnamahanga n'abashamuka b'aBayaahudi. Yeesu ababwira ntya: «Mwayinjire n'engoorho n'enkoni, owamenya mpu ndi gishumuusi! ");
INSERT INTO hav_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Esiku zooshi, naliiri haguma nenyu omu Nju ya Nnamahanga, murhayinjaga kunfarha. Aliko chinoola gihe gikola chenyu na ech'obuhashe b'omwizimya.» ");
INSERT INTO hav_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Abo bantu baafarha Yeesu, bamuheeka omu nju y'omudaahwa mukulu. Petero abakulikira buzira kubayegeera. ");
INSERT INTO hav_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Bachaana omuliro ahagarhi k'embuga, bayikala. Petero naye ayikala ahagarhi kaabo. ");
INSERT INTO hav_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Elugulu w'obumoleke b'omuliro, omuja muguma w'omukazi abona Petero ayikeere. Amuloleereza n'okuderha ntya: «Oyuula naye aliiri haguma n'ola muntu.» ");
INSERT INTO hav_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Aliko Petero ahakana, aderha ntya: «Ego mukazi, nyoono ntamuyinji!» ");
INSERT INTO hav_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Hagerere hishanji higeeke, owindi muntu amubona n'okuderha ntya: «Naawe, oli muguma wabo.» Petero naye aderha ntya: «Nangwa maani, ntali muguma wabo!» ");
INSERT INTO hav_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Hagerere nka saa nguma, kandi owindi muntu ayemeereza ntya: «Okuli, oyu mulume aliiri haguma na Yeesu, kwenge naye ali Mugalilaaya.» ");
INSERT INTO hav_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Petero ashubiza ntya: «Muza wee, ntamenyere ebi washonda kuderha!» Ho n'aho, oku achiri aderha, oluhazi lwabika. ");
INSERT INTO hav_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Nnaweerhu ava ahindamuka n'okulola Petero. Petero ayibuka echinwa Nnaweerhu amubwiraga oku: «Embere oluhazi lubike zeene, waaba eyi wamampakana gasharhu.» ");
INSERT INTO hav_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Petero ahuluka, alira bweneene. ");
INSERT INTO hav_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Abantu bali bafarhire Yeesu, baalema bamushuuka n'okumushuurha. ");
INSERT INTO hav_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Baamuhubya ameesho n'okulema bamubwira ntya: «Leeba! Orhubwire nde wamagushuurha!» ");
INSERT INTO hav_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Baashuba kulema bamudukanga ebindi bidusi binene. ");
INSERT INTO hav_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Bwabeere bwacha, abashamuka b'aBayaahudi, abakulu b'abadaahwa n'abigiriza b'amarhegeko bachiigusha haguma. Baheeka Yeesu omu kabuga kaabo. ");
INSERT INTO hav_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Bamubwira ntya: «Akaba wooyo we Krisitu, orhubwirage.» Naye abashubiza ntya: «Nkababwira ko murhakayemeera! ");
INSERT INTO hav_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Naani nkola nababaza, murhanshubiza. ");
INSERT INTO hav_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Aliko gurhengera buno, Mwene oMuntu aba ayikeere emalyo ma Nnamahanga w'obuhashe.» ");
INSERT INTO hav_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Booshi baabaza ntya: «Ka gasi wooyo we Mwene Nnamahanga?» Abashubiza ntya: «Mwewe mwe muderhere oku ndi ye.» ");
INSERT INTO hav_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Baava baaderha ntya: «Bwindi buhamiiriza buchi rhulagire ko? Rhwayunviirhe rhwenyine eby'aderhere!» ");
INSERT INTO hav_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Bala bantu booshi babaaga bali omu kabuga k'aBayaahudi bayimanga, baheeka Yeesu embere z'omwimangizi Pilaato. ");
INSERT INTO hav_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Barhondera kumusidaaka, baderha ntya: «Rhwabugaanire oyu muntu ali ararusa olubaga lwerhu; ali abuza guhaana ekooli emwa mwami mukulu Kayizaari, anali achiiderha yenyine oku ali Krisitu, k'okuderha mwami.» ");
INSERT INTO hav_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilaato amubaza ntya: «Ka wooyo oli mwami w'aBayaahudi?» Yeesu amushubiza ntya: «Wooyo, we waderhere ntyo.» ");
INSERT INTO hav_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilaato abwira abakulu b'abadaahwa n'olubaga lw'abantu ntya: «Ntaacho nabwene emw'oyu muntu chagarhuma ahanwa.» ");
INSERT INTO hav_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Aliko, baharhiiriza n'okuderha ntya: «Enyigirizo zaage yi zaarhuma abantu balwisa abakulu omu Yudeeya yooshi. Arhangiriraga eGalilaaya, leero ali kuno.» ");
INSERT INTO hav_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilaato abeere ayunva ebyoola, abaza akaba oyu muntu aliiri Mugalilaaya. ");
INSERT INTO hav_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Abeere amenya oku Yeesu arhengera omu gihugo girhegekerwe na Heroode, amurhuma emwa Heroode, kwenge naye aliiri eYerusaleema mw'ezoola siku. ");
INSERT INTO hav_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Heroode abeere abona Yeesu, ashagaluka bweneene. Gurhengera miira, aliiri ashonda kumubona kwenge abaaga ayunviirhe emyaazi yaage. Na kandi, aliiri alangaalira okubona Yeesu ajira egisomereene. ");
INSERT INTO hav_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Heroode amubaziiriza, aliko Yeesu ntaacho amushubize. ");
INSERT INTO hav_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Abakulu b'abadaahwa n'abigiriza b'amarhegeko baliiri ahoola, bamusidaaka n'obukali bunene. ");
INSERT INTO hav_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Heroode naye, haguma n'abasoda baage, bashekera Yeesu n'okumukena. Bamalire kumushekera n'okumuyambisa omwambalo gukwiriire bweneene, ashuba kugalula Yeesu emwa Pilaato. ");
INSERT INTO hav_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Olo lusiku, Heroode na Pilaato baaba beera, n'obo embere baliiri banzi. ");
INSERT INTO hav_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilaato ahamagaza abakulu b'abadaahwa, abimangizi b'aBayaahudi n'abandi bantu. ");
INSERT INTO hav_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ababwira ntya: «Mwandeerheraga oyu muntu bulaala mwaderhaga oku aliiri gurarusa olubaga. Namubazize embere zenyu aliko nyoono ntaacho namubwene ko chagarhuma ahanwa omu byooshi mwamusidakiire. ");
INSERT INTO hav_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Heroode naye ntaacho amubwene ko, kwenge arhugaluliire ye. Ntaacho omu by'ajirire chagarhuma ayirhwa. ");
INSERT INTO hav_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Boboola enyuma z'okumushuurha, namulikuula.»  ");
INSERT INTO hav_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ngasi lusiku lukulu lw'ePaasaka, Pilaato alikwaneene kubalikuulira omuntu muguma oli omu munyororo. ");
INSERT INTO hav_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Abantu booshi bayaamira chaligumira ntya: «Oyirhe oyu muntu! Orhulikuulire Baraaba!» ");
INSERT INTO hav_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Baraaba abaaga ashwekerwe elugulu w'entambala yabaaga omu gishagala n'okuyirha omuntu. ");
INSERT INTO hav_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilaato ashuba kuderha nabo, kwenge alishondere alikuule Yeesu. ");
INSERT INTO hav_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Aliko boowe baalema bayaama ntya: «Omubambe oku musalaaba! Omubambe oku musalaaba!» ");
INSERT INTO hav_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilaato ababwira ntya obwa gasharhu: «Bubi buchi ajirire? Ntaacho namubwene ko chagarhuma ayirhwa. Enyuma z'okumushuurha, namulikuula.» ");
INSERT INTO hav_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Aliko bachihanda n'olwamo lunene, omu guhema abambwe oku musalaaba. Olwamo lwabo lunene lwahimana. ");
INSERT INTO hav_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Buzinda, Pilaato arhegeka oku bibe nk'oku abantu baahemaga. ");
INSERT INTO hav_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Alikuula ola bashondaga, wali wahirirwe omu munyororo elugulu w'obugome n'okuyirha omuntu; abaheereza Yeesu, bamujire nk'oku balonzaga. ");
INSERT INTO hav_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Abasoda b'aBarooma babeere bali baheeka Yeesu emunda bamuyirhira, bashimaanana n'omuntu muguma oyirikwa Simooni, w'egishagala ch'eKureene, waliiri gurhenga omu shwa. Baava bamurhoola n'okumuheesa omusalaaba mpu aguheeke enyuma za Yeesu. ");
INSERT INTO hav_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Olubaga lunene lw'abantu lwali kulikiire Yeesu. Ahagarhi kaabo haliiri abakazi baliiri balira n'oguchiniguula elugulu waage. ");
INSERT INTO hav_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yeesu abahindamukira n'okubabwira ntya: «Mwe bakazi b'eYerusaleema, murhandiriraga. Aliko muchiilirire n'abaana benyu. ");
INSERT INTO hav_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Kwenge esiku zayinjire abantu nji baderha ntya: ‹Bagishirwe abakazi b'engumba, zigishirwe enda zirhashubiraga kuburha n'amabeere marhashubiraga kuyonsa!› ");
INSERT INTO hav_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Amo mango, abantu nji barhondera okubwira emisozi ntya: ‹Murhurhogere ko!›, n'okubwira orhusozi ntya: ‹Murhuhambe!› ");
INSERT INTO hav_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Bulaala eyi bankajira ebyoola oku murhi mubishi, bichi nji byajirirwa omurhi guyuumire?» ");
INSERT INTO hav_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Kandi, abasoda bali baheekere ebishumuusi bibiri, byaali byaaja kuyirhwa haguma na Yeesu. ");
INSERT INTO hav_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Babeere baagera ahantu hayirikwa Mpanga, bamubambira ahoola oku musalaaba, na bila bishumuusi bibiri, chiguma ekulyo n'echindi ekulembe. ");
INSERT INTO hav_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yeesu aderha ntya: «Daarha, obababalire, kwenge barhamenyere echi bali baajira.» Abasoda bagabaana emyambalo yaage omu kuyeesha esimbi. ");
INSERT INTO hav_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Abantu baliyimangire ahoola, baanali baalola. Abarhegesi b'aBayaahudi boowe, bashinyagulira Yeesu, baderha ntya: «Achungwire abandi; agichungule yenyine, akaba ali Krisitu, ola Nnamahanga agishogere!» ");
INSERT INTO hav_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Abasoda nabo baliiri bamushekera. Bayinja kumuha edivaayi y'enkala, ");
INSERT INTO hav_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","n'okumubwira ntya: «Akaba oli mwami w'aBayaahudi, ogifumye wenyine!» ");
INSERT INTO hav_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Haliiri kandi elugulu waage ogu mwandiko: «Oyu ye Mwami w'aBayaahudi.» ");
INSERT INTO hav_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Muguma omu bishumuusi bibambirwe oku musalaaba amudukanga ntya: «K'orhali we Krisitu? Ochifumye wenyine onarhufumye!» ");
INSERT INTO hav_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Aliko echindi gishumuusi chakalihira echaabo ntya: «K'orhagwerhe chiro obuuba bwa Nnamahanga, wooyo weeri waahanwa kuguma naye? ");
INSERT INTO hav_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Oku rhwewe, obuhane burhukwaneene, kwenge rhuli rhwayankirira egikwaneene ebijiro byeerhu. Aliko oyuula nta chibi n'echiguma ajirire.» ");
INSERT INTO hav_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ashuba kuderha ntya: «Yeesu, onyibuke hano nj'oja omu Bwami bwawe.» ");
INSERT INTO hav_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yeesu amushubiza ntya: «Okuli, nkubwirire, zeene waaba haguma naani omu Paradizo.» ");
INSERT INTO hav_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Zaali zikola zashonda kuba saa ndarhu; haaba omwizimya oku gihugo chooshi kugera aha saa mwenda, ");
INSERT INTO hav_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","kwenge ezuuba lyalihirimire. N'omwenda gw'omu Nju ya Nnamahanga gwachisharhula ahagarhi. ");
INSERT INTO hav_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yeesu ayaama ntya: «Daarha, mpirire omurhima gwani omu fune zaawe.» Amalire kuderha ebyoola, asimuuka. ");
INSERT INTO hav_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Omukulu w'abasoda abeere abona ebyabeere, akuuza Nnamahanga n'okuderha ntya: «Okuli, oyu muntu aliiri okwaneene!» ");
INSERT INTO hav_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Abantu booshi balichigushire ahoola kulola kw'eyo myaazi, babwene ebyabeere, bagaluka emwabo n'amaganya manene. ");
INSERT INTO hav_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Booshi baliyinji Yeesu, n'abakazi baliiri bamuherekeeze gurhengera eGalilaaya, bayimanga hale, baalola ebiri byaaba. ");
INSERT INTO hav_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Haliiri mulume muguma oyirikwa Yozefu wahulukiraga eHarimateya, gishagala chiguma ch'aBayaahudi. Aliiri muntu mwinja onakwaneene, anagendaga alinga obwime bwa Nnamahanga. Aliiri muguma w'akabuga k'aBayaahudi, aliko arhaali yemereere omuhigo n'ebijiro byaabo by'okuyirha Yeesu. ");
INSERT INTO hav_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Aja emwa Pilaato, ahema omubiri gwa Yeesu. ");
INSERT INTO hav_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Aguyandagaza oku musalaaba, aguzingira kw'edaraape, aguhira omu shinda yajokolwaga omu baale. Mweyo shinda, mwabaaga murhashubiraga guhaabwa muntu. ");
INSERT INTO hav_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Olo lusiku, lwaliiri lwagarhaano, lo lwanaliiri lusiku l'ogurheganya eSaabato, n'eSaabato yali kola gurhondera. ");
INSERT INTO hav_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Balaala bakazi baliiri barhengeere eGalilaaya haguma na Yeesu, bakulikira Yozefu. Baabona eshinda n'obulyo bahiraga mo omubiri gwa Yeesu. ");
INSERT INTO hav_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Bagaluka gurheganya amavurha n'amarashi. Olusiku lw'eSaabato, bahumuuka, gukulikirana n'eRhegeko lya Nnamahanga. ");
INSERT INTO hav_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Olusiku lwakulikiraga eSaabato, bala bakazi baja ebwa shinda eseeziseezi, eyi baheekere amavurha m'amarashi bali barheganyize. ");
INSERT INTO hav_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Bashimaana ebaale lyalichingire eshinda lyahirikirwe eburhambi. ");
INSERT INTO hav_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Baja mo, aliko barhabonaga omubiri gwa Nnaweerhu Yeesu. ");
INSERT INTO hav_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Babeere bali basoomerwa elugulu w'ebyabeere, ho n'aho balume babiri bayambeere emyambalo ebaraganyize babonekana embere zaabo. ");
INSERT INTO hav_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Aboola bakazi bayuubaha bweneene, bayeerekeza amalanga maabo oku daho. Aliko aboola balume bababwira ntya: «Girhumire mwashondera ozeene omu bafu? ");
INSERT INTO hav_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Arhali hano, afuukire! Muyibuke ebi ababwiraga amango alichiri eGalilaaya oku: ");
INSERT INTO hav_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‹Bihemere Mwene oMuntu ahaanwe oku banyabyaaha, abambwe oku musalaaba, anafuuke olusiku lwa gasharhu.›» ");
INSERT INTO hav_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Abo bakazi baava bayibuka ebinwa byaage. ");
INSERT INTO hav_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Bagaluka gurhenga ebwa shinda, n'ebyoola byooshi babibalira entumwa ekumi na nguma n'abandi bigirizwa. ");
INSERT INTO hav_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Aboola bakazi babibaliraga entumwa baliiri: Mariya w'eMagadala, Jaani, Mariya nyina wa Yakobo n'abandi baliiri haguma nabo. ");
INSERT INTO hav_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Aliko ebi binwa byabonekana oku meesho m'entumwa nka ntaacho bimalire, barhanabiyemeeraga. ");
INSERT INTO hav_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Aliko Petero yeewe ayimanga, alibirhira ebwa shinda. Ayunamire, abona emyenda alizingirwe mo yonyine. Ava achigalukira emwage, eyi asomereerwe ebyabeere. ");
INSERT INTO hav_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Olo lusiku lo n'olo, babiri omu bigirizwa ba Yeesu baliiri baaja omu gishagala chiyirikwa Emawu. Chaliiri oku bilomeetere byakagera kw'ekumi na chiguma n'eYerusaleema. ");
INSERT INTO hav_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Baliiri baganiira oku byooshi byazindaga kugera. ");
INSERT INTO hav_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Babeere bali baganiira n'okubazana, Yeesu yenyine abayegeera n'okugenda haguma nabo. ");
INSERT INTO hav_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Aliko ameesho maabo maalihubizwe yi barhamumenya. ");
INSERT INTO hav_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yeesu ababaza ntya: «Binwa bichi muli mwaganiira muli kulambagira?» Bayimanga eyi bagwerhe amaganya manene. ");
INSERT INTO hav_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Muguma omu bo, oyirikwa Keleopaasi, amubaza ntya: «Ka wooyo wenyine omu balama eYerusaleema werhamenyere ebyabeere mw'ezi siku?» ");
INSERT INTO hav_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yeesu naye abaza bo ntya: «Bichi ebyo?» Bamushubiza ntya: «Ebiyerekeere Yeesu w'eNazareeti, ola waliiri muleebi w'obuhashe omu bijiro n'enderho embere za Nnamahanga n'embere z'olubaga looshi. ");
INSERT INTO hav_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Leero, abakulu b'abadaahwa n'abarhegesi beerhu nji bamuhaanire mpu ahanirwe olufu anabambwe oku musalaaba. ");
INSERT INTO hav_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Rhwalinihiire oku yeewe ye wali wachungula Israheeli. Aliko leero haguma n'ebyo byooshi, zeene l'olusiku lwa gasharhu gurhenga ebyo bibeere. ");
INSERT INTO hav_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Aliko kandi, abakazi baguma nabo b'echigusho cheerhu bali barhushalamize. Bali balamukiire zeene eseeziseezi oku shinda, ");
INSERT INTO hav_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","aliko barhaali babwene omubiri gwage. Bamaava bayinja kuderha oku babonekeerwe na bamalahika. Abo bamalahika bababwirire oku Yeesu ali mugumaguma. ");
INSERT INTO hav_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Beerhu baguma balijiire oku shinda, banabugaanire ebintu nka okw'abakazi babiderhaga. Aliko yeewe, barhamubwene.» ");
INSERT INTO hav_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Yeesu aja ababwira ntya: «Mwe bihwinja mwe! N'emirhima yenyu erhayemeerera ho byooshi abaleebi baderhaga! ");
INSERT INTO hav_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ka Krisitu arhaalikwaneene alibuke ntyo y'aja omu bukuuze bwage?» ");
INSERT INTO hav_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Yeesu ava abahuguula oku biri omu Mandiko Matagatiifu mooshi elugulu waage, gurhonderera oku bitaabu bya Muusa n'ebyabaleebi booshi. ");
INSERT INTO hav_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Babeere bayegeera egishagala baliiri baaja mo, Yeesu abonekana nk'owagendeerera n'olugenzi. ");
INSERT INTO hav_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Aliko bamurhebeereza omu kuderha ntya: «Obeere haguma neerhu, kwenge bwayirire.» Ntyo ku Yeesu ajiire omu nju kubeera haguma nabo. ");
INSERT INTO hav_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Abeere ayikala kulya haguma nabo, arhoola omugati n'okugugisha, aguchagulanga n'okuguheereza bo. ");
INSERT INTO hav_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ameesho maabo maaja mahumuulwa bwinja, baanaja bamumenya. Aliko ahirima embere zaabo. ");
INSERT INTO hav_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Baabazana ntya: «K'emirhima yeerhu erhaliyunviirhe obushagaluke bunene amango aliiri aganiira neerhu omu njira n'ogurhuhuguulira eby'aMandiko Matagatiifu maderhere?» ");
INSERT INTO hav_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ho n'aho bayuumuka, bagaluka eYerusaleema. Babugaana zilaala ntumwa ekumi na nguma zichigushire haguma n'abandi bigirizwa. ");
INSERT INTO hav_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Abo booshi, babwira bala bigirizwa babiri ntya: «Okuli Nnaweerhu afuukire, anabonekeere Simooni!» ");
INSERT INTO hav_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Bala bigirizwa babiri baabala ebyaali bibahikiire omu njira, na gurhe barhegeeraga Yeesu amango achagulangaga omugati. ");
INSERT INTO hav_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Bala bigirizwa babiri babeere bali baderha ebyoola, Yeesu yenyine achiyeerekana ahagarhi kaabo n'okubabwira ntya: «Omurhuula gube haguma nenyu!» ");
INSERT INTO hav_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Abigirizwa baashalama n'okuyuubaha bweneene, eyi bakengereere mpu babwene omuzimu. ");
INSERT INTO hav_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Aliko Yeesu ababwira ntya: «Bichi birhumire mwayuubaha? Bichi birhumire mwaganganwa omu mirhima yenyu? ");
INSERT INTO hav_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Mulole amaboko maani n'amagulu maani, okuli nyoono! Munmamaarhe munaloleereze. Omuzimu arhajira munyofu changwa egufa, nka kunoola mubwene mbigwerhe.» ");
INSERT INTO hav_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Omu kuderha ebyoola, abayeereka amaboko maage n'amagulu maage. ");
INSERT INTO hav_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Abigirizwa basoomerwa n'ogushagaluka bweneene, n'obo babaaga barhaza kuyemeera echi babwene. Yeesu aja ababaza ntya: «Ka mugwerhe hano echintu ch'okulya?» ");
INSERT INTO hav_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Baamuha egichiira ch'efi eyoosezwe. ");
INSERT INTO hav_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Agirhoola n'oguchilya embere zaabo. ");
INSERT INTO hav_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Aja ababwira ntya: «Ebiila binababwiraga amango nali nchiri haguma nenyu. Byaalihemere bijirike byooshi byaali biyandikirwe elugulu waani omu Rhegeko lya Muusa, omu bitaabu abaleebi bayandikaga n'omu gitaabu ch'eNanga.» ");
INSERT INTO hav_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ho n'aho, Yeesu abahunuula obwenge b'okuyunva aMandiko Matagatiifu. ");
INSERT INTO hav_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ava ababwira ntya: «Biyandikirwe oku Krisitu alibuka, n'oku afuuka omu bafu olusiku lwa gasharhu. ");
INSERT INTO hav_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Kandi, omu ziino lyaage, abantu b'ebihugo byooshi gurhangirira eYerusaleema nji baabalirwa oku baleke ebyaaha byaabo yi bababalirwa. ");
INSERT INTO hav_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Muli bahamiiriza b'ebyoola byooshi. ");
INSERT INTO hav_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Nyoono, nabarhumira echi Daarha alaganyaga. Mwabo, mubeere hanoola Yerusaleema kugera amango mwayankirira obuhashe b'ogurhengera empingu.» ");
INSERT INTO hav_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Yeesu aheeka abigirizwa baage kugera hoofu n'egishagala ch'eBetaniiya. Ayinamula amaboko elugulu, abagisha. ");
INSERT INTO hav_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Abeere ali abagisha, achikuula haguma nabo, aheekwa empingu. ");
INSERT INTO hav_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Abigirizwa boowe, bamalire kumuharamya, bagaluka eYerusaleema n'obushagaluke bunene. ");
INSERT INTO hav_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ngasi mango, baliiri omu Nju ya Nnamahanga eyi banali bamukuuza.");
INSERT INTO hav_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Muzigirwa Teofiile, Omu gitaabu girhanzi nayandikaga, naderhere elugulu wa byooshi Yeesu arhonderaga kujira n'okuyigiriza, ");
INSERT INTO hav_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","guhika olusiku aheekwaga empingu. Embere aheekwe yo, aheereza eNtumwa zaage abaaga agishogere amarhegeko kugerera Muuka-Mutagatiifu. ");
INSERT INTO hav_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Enyuma z'ogufa kwage, ezo ntumwa z'achiyerekanaga ko kugerera ebimenyeeso binene yi zimenya okw'ali mugumaguma. Aliiri ababonekera omu gihe cha siku makumi mane, eyi ali abayigiriza emyaazi eyerekeere obwime bwa Nnamahanga. ");
INSERT INTO hav_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Lusiku luguma mw'amo mango, Yeesu abeere ali haguma nabo, abarhegeka ntya: «Murharhengaga eYerusaleema, aliko mulingire yo echilagaane cha Daarha nababwiraga. ");
INSERT INTO hav_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yohaana abatiizaga omu menji, aliko mwabo omu siku zigeeke mwabatiizwa na Muuka-Mutagatiifu.» ");
INSERT INTO hav_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Amango eNtumwa zalichigushire haguma na Yeesu zamubaza ntya: «Nnaweerhu, ka mu chino gihe y'okola kugalulira aBaisraheeli obwami bwabo?» ");
INSERT INTO hav_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Abashubiza ntya: «Birhabalolere okumenya egihe n'ebishanji Daarha afundikire omu burhegesi bwage yenyine. ");
INSERT INTO hav_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Aliko, mwayankiirira obuhashe hano Muuka-Mutagatiifu ayinja elugulu wenyu, mwanaba bahamiiriza baani eYerusaleema, eYudeeya yooshi n'eSamariya, n'omu gulu lyooshi.» ");
INSERT INTO hav_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Yeesu abeere ayuusa kuderha ebyoola binwa, eyi bachiri bamulola, aheekwa empingu n'egichu chamubisha, barhanachimubonaga ko. ");
INSERT INTO hav_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Babeere bachiri baheneera elugulu eyi ali agenda, ho n'aho balume babiri bayambeere emyambalo myeeru bayimanga embere zaabo. ");
INSERT INTO hav_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Baabaza eNtumwa ntya: «Mwe bantu b'eGalilaaya, girhumire mwabeera ahoola eyi muli mwalola elugulu? Oyu Yeesu wamakuulwa ahagarhi kenyu guheekwa empingu, nj'agaluka nk'oku mwabwene aja yo.» ");
INSERT INTO hav_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Enyuma z'aho, eNtumwa zagaluka eYerusaleema gurhengera oku musozi gw'eMizeyituuni. Ogo musozi guba hoofu n'eYerusaleema, lugenzi luyemereerwe kulambagirwa olusiku lw'eSaabato. ");
INSERT INTO hav_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Babeere bagaluka omu gishagala, bazamuukira omu gorofa ebusiika. Omoola mu bagendaga babeera. Mwaliiri Petero, Yohaana, Yakobo na Ndereya, Firipo na Tomaasi, Baritolomaayo na Matayo, Yakobo mugala wa Lufaayo, Simooni w'omu chigusho ch'aBazelooti na Yuuda mugala wa Yakobo. ");
INSERT INTO hav_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Abaala booshi bagendaga basaliira n'omurhima muguma, haguma na Mariya nyina wa Yeesu, n'abandi bakazi, na beene baabo Yeesu. ");
INSERT INTO hav_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Lusiku luguma, oluganjo lw'abemeezi balichigushire lwaliiri hoofu egana na makumyaabiri. Petero ayimanga ahagarhi kaabo n'okuderha ntya: ");
INSERT INTO hav_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","«Beene beerhu, byaalihemere aMandiko mayeenere, mala Muuka-Mutagatiifu abaaga aderhere kugerera obuunu bwa Daawudi elugulu wa Yuuda. Oyuula Yuuda yi walongoolaga abafarhaga Yeesu. ");
INSERT INTO hav_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Aliiri muguma omu rhwewe, analigwerhe echigabi oku kaasi keerhu.» ");
INSERT INTO hav_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Enyuma z'okugula eshwa n'efuranga z'obuhemusi, arhoga buchuli, enda yaage yabereka n'amala maage masheeshekalira ahashi. ");
INSERT INTO hav_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Abantu booshi b'eYerusaleema bamenya ogo mwazi, oku bulyo elyo shwa lyayirikwa omu lulimi lwaabo mpu lyo «Hakeledama», kw'okuderha «Eshwa ly'eshagama.» ");
INSERT INTO hav_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","«Kwenge biyandikirwe ntya omu gitaabu ch'eNanga: ‹Enju yaage ebe mushaka, na nta muntu oyilamage mo! N'owundi arhoole akaasi kaage!›» ");
INSERT INTO hav_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","«Bihemere leero, rhugishoge owindi muntu muguma w'ogurhoola akaasi kaage. Oyu muntu abe muguma w'omu bala bagendaga barhuherekeza ngasi bishanji byooshi Nnaweerhu Yeesu aliiri abalama haguma neerhu. Aba bantu baliiri haguma neerhu gurhengera amango Yohaana abatiizaga Nnaweerhu guhika olusiku aheekwaga gurhenga ahagarhi keerhu. Bihemere oyu muntu rhwachishoga abe haguma neerhu omu guhamiiriza obufuuke bwa Nnaweerhu.» ");
INSERT INTO hav_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","eNtumwa zaaja zamoleka bantu babiri: Yozefu oyirikwa Barisaba wanashembulwaga Yusto, na Matiyaasi. ");
INSERT INTO hav_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Baaja basaliira ntya: «Nnaweerhu, weyinji emirhima y'abantu booshi, oyeerekane nde ochishogere mw'abaala babiri, ");
INSERT INTO hav_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","y'aja ahaali ha Yuuda mw'akaala kaasi k'eNtumwa alekaga omu kuja ahantu hamukwaneene.» ");
INSERT INTO hav_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Bashaarha esimbi, nazo zarhoola Matiyaasi wayongeerwaga mu zila ntumwa ekumi na nguma. ");
INSERT INTO hav_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Olusiku lw'ePendekosite lwabeere lwahika, abigirizwa booshi babaaga babuganeene hantu haguma. ");
INSERT INTO hav_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ho n'aho bayunva olwamo gurhengera empingu luli nka lw'empuusi ekalihire, enali yahuusahuusa. Olo lwamo lwayunviikana omu nju yooshi baliyikeere mo. ");
INSERT INTO hav_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Haabonekana n'ebiri nka birimi by'omuliro, byachigaba; byanaja oku ngasi muguma wabo. ");
INSERT INTO hav_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Abo bigirizwa booshi bayunjuzwa Muuka-Mutagatiifu, banarhondera kuderha omu zindi ndimi, gukulikirana n'oku Muuka-Mutagatiifu abahaaga obuhashe b'okuderha. ");
INSERT INTO hav_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Mw'amo mango, eYerusaleema haliiri aBayaahudi baguma bakengaga Nnamahanga, bahulukiraga omu bihugo byooshi by'egulu. ");
INSERT INTO hav_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Oloola lwamo lwabeere lwayunviikana, abantu banene bachiigusha, basoomerwa bweneene bulaala ngasi muguma aliiri abayunva baaderha omu lulimi lwage lw'akaburhano. ");
INSERT INTO hav_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Booshi basoomerwa, banayuumirwa, baalema baabazana ntya: «Abaala bantu bali baderha, ka booshi barhali Bagalilaaya? ");
INSERT INTO hav_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Gurhe ngasi muguma weerhu y'abayunva omu lulimi lwage lw'akaburhano? ");
INSERT INTO hav_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Omu rhwewe hali abarhengeere omu gihugo ch'aBapariti, ech'aBameedi na ech'aBaelaamu. Hali abalama omu gihugo ch'eMezopotamiya, ech'eYudeeya na ech'eGapadokiya, ech'ePonto na ech'eAziya, ");
INSERT INTO hav_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ech'eFurigiya na ech'ePamfiliya, ech'eMiisiri n'oluhande lwa ech'eLibiya luli hoofu n'egishagala ch'eKureene. Kandi omu rhwewe hali abahiisi b'ogurhengera eRooma, ");
INSERT INTO hav_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","hali aBayaahudi n'abandi bayemeeraga edini ly'ekiyaahudi, aBakereeti n'aBaharaabu. Aliko rhweshi rhuli rhwabayunva baaderha omu ndimi zeerhu ebijiro by'obuhashe Nnamahanga ajirire!» ");
INSERT INTO hav_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Booshi baali basomeerwe bweneene n'okuyuumirwa, baabazana ntya: «Bichi ebiila biderhere?» ");
INSERT INTO hav_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Aliko baguma omu bo bashekera abigirizwa n'okuderha ntya: «Barhamiriire edivaayi y'omuhyo!» ");
INSERT INTO hav_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Petero aja ayimanga haguma na zila ntumwa ekumi na nguma, aderha ntya n'omulenge munene: «Mwe bantu b'eYudeeya nenyu mweshi mwe mulamire eYerusaleema, munyunvirize, munamenye bwinja ebi binwa nashonda kubabwira! ");
INSERT INTO hav_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Abaala bantu barharhamiriire nk'oku mukengereere, kwenge zichiri saa esharhu z'eseezi. ");
INSERT INTO hav_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Aliko ebiila bi Nnamahanga aderhaga kugerera omuleebi Yoweeri mpu: ");
INSERT INTO hav_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‹Omu siku zizinda, nji nayandaaza oMuuka gwani oku bantu booshi; bagala benyu n'abanyere benyu nji baleeba, emisole yenyu nji yabonekerwa, n'abashaaja benyu nji baloorha. ");
INSERT INTO hav_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Neechi, mw'ezo siku, abaja baani, abalume n'abakazi, nji nabayandaaza k'oMuuka gwani, nji banaleeba. ");
INSERT INTO hav_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Nji najira ebigiriginjo gurhengera elugulu omu mpingu n'ebimenyeeso eshiishi omu gulu, nji haaba eshagama, omuliro n'oluhomo l'omuusi. ");
INSERT INTO hav_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ezuuba nji lyahindulwa mwizimya n'omwezi nji gwahindulwa shagama, embere olusiku lwa Nnaweerhu luyinje, olo lusiku lunene, kandi l'obukuuze. ");
INSERT INTO hav_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Mw'amo mango, ngasi yeeshi nji wahema oburhabaale oku ziino lya Nnaweerhu nj'achungulwa.› ");
INSERT INTO hav_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","«Mwe bantu b'eIsraheeli, muyunve ebi binwa! Nnamahanga abayeerekere bwinjabwinja oku Yeesu w'eNazareeti ali muntu arhumaga embere zenyu kugerera ebijiro by'obuhashe, ebigiriginjo n'ebimenyeeso. Nnamahanga ajiraga ebyo booshi ahagarhi kenyu kugerera Yeesu, nk'oku mubiyinji mwenyine. ");
INSERT INTO hav_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Oyu Yeesu ahirwaga omu maboko menyu, nk'oku Nnamahanga ashondaga, na nka okw'amenyaga yenyine gurhengera miira. Nenyu mwamuyirhire omu kumubamba oku musalaaba, kugerera abantu babi. ");
INSERT INTO hav_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Aliko, Nnamahanga nj'amufuulire omu kumulikuula omu malumwa m'olufu, bulaala birhakagalikeene ashwekwe na lo. ");
INSERT INTO hav_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Kwenge Daawudi aderhere ntya elugulu wa Yeesu: ‹Naliiri nabona Nnaweerhu embere zaani ngasi mango, bulaala ali ekulyo kwani yi ntashaganywa. ");
INSERT INTO hav_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Cho girhumire omurhima gwani gusiimire n'olulimi lwani lushagalukire; kandi omubiri gwani nago nji gwahuumukira omu bulangaalire, ");
INSERT INTO hav_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","kwenge orhakandekeerera kubeera ekuzimu; orhakanaleka oMutagatiifu waawe abola. ");
INSERT INTO hav_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Wanyeerekere enjira z'akalamo, nji wanyunjuza obushagaluke embere zaawe.›» ");
INSERT INTO hav_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Petero ashuba kuderha ntya: «Beene beerhu, bihemere mbabwire bwinjabwinja ebilolere shookuluza weerhu Daawudi: afiire, ahambwa n'eshinda yaage echiba eno mwerhu kugera zeene. ");
INSERT INTO hav_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","N'obuula aliiri muleebi, aliyinji oku Nnamahanga amulahizizaga endahiro oku nj'ayikaza muguma omu baburhwa baage oku ntebe yaage y'obwami. ");
INSERT INTO hav_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Daawudi alibwene embere obufuuke bwa Krisitu, anabuderha ko ntya: ‹Arhalekeererwaga kubeera ekuzimu, n'omubiri gwage gurhabolaga.› ");
INSERT INTO hav_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Nnamahanga afuulire oyo Yeesu, rhweshi rhunali bahamiiriza boboola bufuuke. ");
INSERT INTO hav_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Abeere azamuulwa ekulyo kwa Nnamahanga, Eshe amuha Muuka-Mutagatiifu walilaganyizwe. Naye arhuyandaazize ye, nk'okuula muli mwabona, munali mwayunva. ");
INSERT INTO hav_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Kwenge arhali Daawudi wazamuukiraga empingu, aliko yeewe yenyine aderhere ntya: ‹Nnaweerhu Nnamahanga abwirire Nnaweerhu ntya: “Yikala ekulyo kwani, ");
INSERT INTO hav_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","guhika amango nji naajira abanzi baawe ndabarhiro yaawe.”› ");
INSERT INTO hav_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Leero, bihemere olubaga looshi lw'eIsraheeli lumenye bwinja oku ola Yeesu mwabambaga oku musalaaba, Nnamahanga amujirire kuba Nnaweerhu na Krisitu!» ");
INSERT INTO hav_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Enyuma z'okuyunva ebyoola binwa, abantu baababazwa bweneene omu mirhima yaabo n'okuva baabaza Petero n'ezindi ntumwa ntya: «Beene beerhu, gurhe rhujirage?» ");
INSERT INTO hav_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Petero abashubiza ntya: «Muleke ebyaaha byenyu, na ngasi muguma omu mwabo abatiizwe oku ziino lya Yeesu Krisitu yi mubabalirwa ebyaaha byenyu. Na ntyo, mwanayankiirira Muuka-Mutagatiifu nka luhembo. ");
INSERT INTO hav_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Kwenge echilagaane cha Nnamahanga chiri chenyu, ch'abaana benyu n'abantu booshi balamire hale; k'okuderha oku chiri ch'abantu booshi Nnaweerhu Nnamahanga nj'ahamagala.» ");
INSERT INTO hav_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Petero ashuba kubabwira ebindi binwa binene by'okubayinginga n'okubayunviisa. Alema aderha ntya: «Mugichungule gurhenga mw'echi gisisi ch'ebyaaha!» ");
INSERT INTO hav_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Abayankiiriraga ebinwa byaage babatiizwa. Oloola lusiku, hoofu bantu bihumbi bisharhu bayongeereka omu chigusho ch'abemeezi. ");
INSERT INTO hav_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Abemeezi bagendekera gukulikira enyigirizo z'eNtumwa, kulama echinyabuguma, kugabaana omugati haguma n'ogusaliira. ");
INSERT INTO hav_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ebigiriginjo n'ebimenyeeso binene byaliiri kujirika n'eNtumwa oku bulyo ngasi muguma alema ayunva obuuba. ");
INSERT INTO hav_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Abemeezi booshi baliiri haguma n'ogushangiira byooshi baligwerhe. ");
INSERT INTO hav_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Baliiri baguza amashwa maabo n'ebintu byaabo, n'efuranga zarhengaga mo baliiri bazigabana gukulikirana n'obulagiirire bwa ngasi muguma. ");
INSERT INTO hav_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ngasi lusiku, omu bunviikane, baliiri baaja omu Nju ya Nnamahanga. Baliiri bagabaana omugati n'ogusangira ebiryo byaabo omu nju zaabo n'obushagaluke haguma n'omurhima mwinja. ");
INSERT INTO hav_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Baliiri bakuuza Nnamahanga n'abantu booshi bali basiimire bo. Na ngasi lusiku, Nnaweerhu aliiri ayongeera abachungwirwe oku chigusho ch'abemeezi. ");
INSERT INTO hav_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Lusiku luguma, Petero na Yohaana baliiri bazamuukira omu Nju ya Nnamahanga aha saa mwenda z'ezuuba, cho chaliiri gihe ch'ogusaliira. ");
INSERT INTO hav_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Mw'ebyo bishanji, abantu baliiri baheeka omulume waburhwaga eyi chirema. Abo bantu bagendaga bamuhira ngasi lusiku hoofu n'omulyango gw'eNju ya Nnamahanga guyirikwa «Mulyango Gukwiriire» y'ahemuuze oburhabaale oku baliiri baaja mo. ");
INSERT INTO hav_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Abwene Petero na Yohaana bakola baaja omu Nju ya Nnamahanga, arhondera kubahema oburhabaale. ");
INSERT INTO hav_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Petero na Yohaana bamuloleereza, naye Petero amubwira ntya: «Orhulole!» ");
INSERT INTO hav_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Naye abalola, kwenge alilangaliire oku hali echi bamuha. ");
INSERT INTO hav_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Aliko Petero amubwira ntya: «Ntagwerhe furanga changwa oro, aliko echi ngwerhe, nguheere cho: omu ziino lya Yeesu Krisitu w'eNazareeti, yimanga onalambagire!» ");
INSERT INTO hav_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Amufarhira oku kuboko kw'ekulyo, amuyimanza. Ho n'aho, ebishando byaage n'orhuzirabulongo rhwage byakomera. ");
INSERT INTO hav_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ayuumuka oku liguma, ayimanga n'ogurhondera kulambagira. Aja haguma nabo omu Nju ya Nnamahanga eyi ali alambagira, abalalabalala n'ogukuuza Nnamahanga. ");
INSERT INTO hav_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Abantu booshi bamubona ali alambagira n'ogukuuza Nnamahanga. ");
INSERT INTO hav_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Bamurhegeera oku y'olaala wagendaga ayikala halaala «Mulyango Gukwiriire» gw'eNju ya Nnamahanga guhema oburhabaale. Basoomerwa banahwerwa n'ebyamubereere. ");
INSERT INTO hav_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Oyo muntu abeere arhagirhengere ku Petero na Yohaana, abantu basoomerwa, balibirhira emunda bali, hoofu n'embaraza y'eNju ya Nnamahanga eyirikwa «Mbaraza ya Solomoono.» ");
INSERT INTO hav_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Petero abwene ebyoola, abaza olubaga ntya: «Mwe bantu b'eIsraheeli, girhumire mwasoomerera ogufuma kw'oyu muntu? Girhumire mwarhuloleereza nka rhwewe rhwe rhwalambagiriisaga ye oku buhashe bwerhu rhwenyine changwa elugulu w'ogukwanana kwerhu embere za Nnamahanga? ");
INSERT INTO hav_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Nnamahanga w'Abrahaamu, Isaka na Yakobo, Nnamahanga wa bashookuluza beerhu, akuuzize omukozi waage Yeesu. Oyu Yeesu yi mwabo mwahaanaga mwanamulahira embere za Pilaato, n'obo yeewe abaaga amahiga kumulikuula. ");
INSERT INTO hav_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Mwewe, mwalahira oMutagatiifu na Okwaneene, mwanahema babalikuulire omwisi w'abantu. ");
INSERT INTO hav_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Mwayirha ohaana akalamo, aliko yeewe Nnamahanga amufuulire omu bafu; neerhu rhuli bahamiiriza bw'obo bufuuke. ");
INSERT INTO hav_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Oyu muntu muli mwabona munamuyinji, eziino lya Yeesu n'obwemeezi kw'elyo ziino byo byamukomeeze. N'obwemeezi kugerera Yeesu bo bwaheere oyu muntu amagala makwiriire nk'oku mubwene. ");
INSERT INTO hav_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","«Na bunoola, beene beerhu, nyinji oku mwabo n'abakulu benyu mwajiriraga Yeesu ebyoola omu buhwinja. ");
INSERT INTO hav_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Na Nnamahanga ayeneeze ntya eby'abalaganyaga embere kugerera ebinwa by'abaleebi booshi oku Krisitu waage alibuzwa. ");
INSERT INTO hav_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Mujaage mwaleka ebyaaha byenyu, munagalukire Nnamahanga y'ebyaaha byenyu bibabalirwa. ");
INSERT INTO hav_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Na ntyo, Nnaweerhu abahumuusa, n'okubarhumira Krisitu, ye Yeesu, olaala achishogaga embere elugulu wenyu. ");
INSERT INTO hav_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Alikwaneene gurhanga kubeera empingu guhika amango ebintu byooshi byayeenera nk'oku Nnamahanga aderhaga miira kulengera abaleebi baage batagatiifu. ");
INSERT INTO hav_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Muusa aliderhere ntya: ‹Nnaweerhu, Nnamahanga wenyu, nj'abaha omuleebi warhengera omu beene benyu oli nka nyoono. Nji mwamuyunva omu byooshi nj'ababwira. ");
INSERT INTO hav_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Aliko ngasi yeeshi nj'orhayunva oyo muleebi nj'achiibwa looshi omu lubaga n'okuyirhwa.› ");
INSERT INTO hav_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","N'abaleebi booshi, gurhengera ku Samweri n'abamukulikiraga, nabo baderhere, banabala elugulu w'emyaazi y'eziila siku rhulamire zeene. ");
INSERT INTO hav_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Mwabo, muli bagala b'abaleebi n'egihango Nnamahanga ajiraga na bashookuluza benyu chiri chenyu. Kwenge Nnamahanga ajiraga cho omu kubwira Abrahaamu ntya: ‹Emilala yooshi y'egulu nji yaagishwa omu gisisi chaawe.› ");
INSERT INTO hav_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Amango Nnamahanga ahaanaga omukozi waage, arhanga kumurhuma emwenyu kubagisha, omu gukuula ngasi muguma wenyu omu mabi maage.» ");
INSERT INTO hav_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Petero na Yohaana babeere bachiri bayigiriza olubaga, abadaahwa, omukulu w'abalanzi b'eNju ya Nnamahanga, n'aBasadukaayo baahulukira. ");
INSERT INTO hav_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Abo bakulu bali bakalihire okubona Petero na Yohaana bali bayigiriza olubaga n'okubala oku obufuuke gurhenga omu bafu bubonekana kugerera Yeesu. ");
INSERT INTO hav_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Babashweka n'okubahira omu munyororo kugera olusiku lwakulikiraga kwenge lyaliiri likola golo. ");
INSERT INTO hav_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Aliko banene omu bayunvaga ezo nyigirizo bayemeera Yeesu. Oluganjo lw'abemeezi lwahikiira hoofu balume bihumbi birhaano. ");
INSERT INTO hav_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Bwacheere eseezi, abakulu n'abashamuka b'aBayaahudi, n'abigiriza b'amarhegeko bachigusha eYerusaleema. ");
INSERT INTO hav_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Baliiri haguma n'omudaahwa mukulu Hanaasi, Kayaafa, Yohaana, Alegizandere n'abandi bantu booshi baliiri b'omu mulala gw'omudaahwa mukulu. ");
INSERT INTO hav_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Bamalire kuyimanza Petero na Yohaana ahagarhi kaabo, bababaza ntya: «Oku buhashe buchi changwa oku ziino lya nde mwajiraga ebyoola?» ");
INSERT INTO hav_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Petero eyi ayunjwizwe Muuka-Mutagatiifu, ababwira ntya: «Ego mwe bakulu b'olubaga nenyu mwe bashamuka b'aBayaahudi, ");
INSERT INTO hav_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","rhubazizwe zeene elugulu w'amenja rhwajiriire echirema n'oku bulyo chafumyagwa. ");
INSERT INTO hav_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Leero mwabo mweshi, n'olubaga looshi lw'eIsraheeli, mumenye bwinja: oyu muntu ayimangire embere zenyu n'amagala makwiriire oku ziino lya Yeesu Krisitu w'eNazareeti, olaala mwabambaga oku musalaaba, aliko Nnamahanga amufuula omu bafu. ");
INSERT INTO hav_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yeewe y'aMandiko Matagatiifu maderhere ko ntya: ‹Ebaale mwabo mwe muyumbaka mwalahiraga, lyo lyahindukire ly'engenzi, ly'okuyumbakira ko.› ");
INSERT INTO hav_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Obuchunguke burhali omu windi muntu, kwenge nta lindi ziino omu gulu abantu bahaabirwe, lyagarhuchungwire.» ");
INSERT INTO hav_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Abantu b'akabuga k'aBayaahudi babeere baabona Petero na Yohaana baderha n'oobushiru, basoomerwa, kwenge bali bayinji oku baliiri bantu konyine barhasomaga. Baanalimenyere oku boowe bo baliiri haguma na Yeesu. ");
INSERT INTO hav_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Aliko, nk'okuula bali babwene olaala muntu bafumyaga ayimangire eburhambi bwabo, baabula echi bagashuba kuderha. ");
INSERT INTO hav_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Baava babarhegeka oku barhange barhenge mw'ako kabuga. Bala bakulu boowe basigala omu mahwe. ");
INSERT INTO hav_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Baabazana ntya: «Gurhe rhujirage abaala bantu? Bulaala abantu booshi b'eYerusaleema bayinji bwinja okw'echimenyeeso chabeere kugerera bo. Rhurhakanagala kugihakana. ");
INSERT INTO hav_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Aliko y'omwazi gw'echoola chimenyeeso gurhayandaala bweneene omu lubaga, rhubakalihire oku barhachiderhaga n'omuntu n'omuguma elugulu w'eziino lya Yeesu.» ");
INSERT INTO hav_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Baaja bahamagala Petero na Yohaana, banabarhegeka mpu barhachiderhaga changwa okuyigiriza chiro n'eliguma oku ziino lya Yeesu. ");
INSERT INTO hav_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Aliko Petero na Yohaana babashubiza ntya: «Ka bikwaneene embere za Nnamahanga oku rhubakenge ahaali haage? Mugishogage, ");
INSERT INTO hav_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","kwenge rhwabo rhurhakagala kuleka kuderha ebintu rhwabwene ko rhwanayunva.» ");
INSERT INTO hav_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Abantu b'akabuga k'aBayaahudi baashuba kubakalihira, banaja babalikuula. Barhaali babwene enjira y'okubahana, bulaala olubaga looshi lwaliiri lwakuuza Nnamahanga oku byooshi byabaaga. ");
INSERT INTO hav_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Oyo muntu bajiriraga echoola kimenyeeso ch'ogufuma, aligwerhe myaaka minene ku makumi mane. ");
INSERT INTO hav_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Babeere balikuulwa, Petero na Yohaana baaja kubalira abaabo byooshi abakulu b'abadaahwa n'abashamuka b'aBayaahudi bababwirire. ");
INSERT INTO hav_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Bamalire kuyunva eyo myaazi, booshi basaliira Nnamahanga n'omurhima muguma. Baaderha ntya: «Nnaweerhu, wooyo we wajiraga echaalege, egulu n'enyanja, na byooshi biba omu byo. ");
INSERT INTO hav_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Wooyo we waderhaga ntya kugerera Muuka-Mutagatiifu, omu buunu bwa shookuluza weerhu Daawudi, mukozi waawe: ‹Charhumire abarhali Bayaahudi baruukura n'embaga zagwarha emihigo erhagwerhe kamaro? ");
INSERT INTO hav_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Abaami b'egulu bachikerekere n'abakulu bachigushire haguma yi balwisa Nnaweerhu Nnamahanga na Krisitu waage.› ");
INSERT INTO hav_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Kwenge biri by'okuli oku Heroode na Ponsiyo Pilaato bayunvikeene muno gishagala haguma n'abarhali Bayaahudi n'olubaga lw'eIsraheeli kulahira Yeesu, omukozi waawe mutagatiifu, olaala wagishogaga. ");
INSERT INTO hav_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Bajiraga ntyo, yi bayeeneza byooshi wabaaga warheganyize gurhenga miira oku buhashe bwawe n'emihigo yaawe. ");
INSERT INTO hav_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Leero Nnaweerhu, olole bwinja obuhambaazi bwabo, ogaliise abaja baawe okubala eChinwa chaawe buzira buuba. ");
INSERT INTO hav_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ojaage walambuula okuboko kwawe y'abantu bafume, ebimenyeeso n'ebigiriginjo bibe kugerera eziino lya Yeesu, mukozi waawe mutagatiifu.» ");
INSERT INTO hav_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Bamalire gusaliira, ahantu bali bachigushire hadirhimana bweneene, booshi bayunjula Muuka-Mutagatiifu. Barhondera kubala eChinwa cha Nnamahanga buzira buuba. ");
INSERT INTO hav_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Abemeezi booshi baligwerhe omurhima muguma n'enkengeero nguma. Ntaaye waderhaga oku ebikulo byaage biri byaage yenyine, aliko bagendaga bashangiira byooshi bali bagwerhe. ");
INSERT INTO hav_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Entumwa zaliiri zahamiiriza n'obuhashe bunene obufuuke bwa Nnaweerhu Yeesu, n'omugisho munene gwaliiri oku bo booshi. ");
INSERT INTO hav_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Nta muguma omu bo walikeneere echintu, kwenge booshi bali bagwerhe amashwa changwa enju, bagendaga babiguza, banaleerha efuranga babiguzaga. ");
INSERT INTO hav_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Bagendaga bahira zo embere z'eNtumwa, n'enyuma zanagabirwa ngasi muguma gukulikirana n'obulagiirire bwage. ");
INSERT INTO hav_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Haliiri oMulaawi muguma oyirikwa Yozefu, aliiri muburhwa w'oku chizimba ch'eGipuro. Entumwa zamushembula eziino lya Baranaaba, kw'okuderha «Muntu okomeza abandi omurhima.» ");
INSERT INTO hav_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Aguza eshwa aligwerhe, aleerha efuranga anazihira embere z'eNtumwa. ");
INSERT INTO hav_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Haliiri mulume muguma oyirikwa Hananiya haguma na mukaage Safira. Baguza eshwa lyaabo. ");
INSERT INTO hav_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Omu bunviikane, yeewe na mukaage baabisha muhango muguma oku furanga baliguzaga. Ezasigalaga, aziheeka anazihira embere z'eNtumwa. ");
INSERT INTO hav_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Petero amubaza ntya: «Ego Hananiya, charhumire Shetaani aja omu murhima gwawe, guhika okubeehya Muuka-Mutagatiifu omu kubisha furanga ziguma waguzaga eshwa? ");
INSERT INTO hav_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Egihe eliila shwa lyalichiri lyaawe, ka lirhaliiri bikulo byaawe? Na chiro egihe lyaguzwaga, k'efuranga orhakazikoleeseze okw'oshondere? Chajaaga charhuma wakengera omu murhima gwawe echijiro chiri ntya? Arhali bantu warhebekere, sy'aliko Nnamahanga!» ");
INSERT INTO hav_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Hananiya abeere ayunva ebyoola binwa, ahena n'okuva afa. Booshi bayunvaga ogo mwazi bagwarhwa n'obuuba bunene. ");
INSERT INTO hav_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Emisole yaliiri ahoola yayimanga, yarhuba omubiri gwage, yaguheeka embuga, yanaguhamba. ");
INSERT INTO hav_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Hagerere hoofu saa esharhu, mukaage aja mw'eyo nju buzira kumenya ebyabeere. ");
INSERT INTO hav_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Petero amubaza ntya: «Ombwirage bwinja, ka kw'eyi ngulo ku mwaguzaga eshwa?» Ashubiza ntya: «Neechi, kw'eyoola ngulo.» ");
INSERT INTO hav_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Petero ashuba kumubaza ntya: «Gurhe mwagalaga kuyunviikana yi mugeregeza Muuka-Mutagatiifu wa Nnaweerhu? Ololage! Amagulu m'abahambaga balo mo mano oku mulyango. Naawe baguheeka!» ");
INSERT INTO hav_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ho n'aho ahena embere z'amagulu ma Petero n'ogufa. Elaala misole yajiire omu nju, y'abugaana afiire. Yaheeka omubiri gwage yanaguhamba eburhambi bw'eba. ");
INSERT INTO hav_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Echigusho chooshi ch'abemeezi na booshi bayunvaga ogoola mwazi bagwarhwa n'obuuba bunene. ");
INSERT INTO hav_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ebimenyeeso n'ebigiriginjo binene byaliiri kujirika omu bantu kulengera eNtumwa. Abemeezi baliiri gushimaanana booshi omu Mbaraza ya Solomoono. ");
INSERT INTO hav_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Nta muntu n'omuguma orhali mwemeezi wagendaga abayegeera, aliko olubaga lwabakenga bweneene. ");
INSERT INTO hav_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Abantu banene, abalume n'abakazi, baliiri bayemeera Nnaweerhu. Bagendekera kuluga bweneene. ");
INSERT INTO hav_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Baliiri baleerha abalwala oku njira zigalihire, banabalyaamiza oku bishanja n'oku bipoyi, yi hano Petero agera, chiro egichuuchu chaage chigale gushukulira baguma omu bo. ");
INSERT INTO hav_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Abantu banene bagendaga barhenga n'omu bishagala bitureene n'eYerusaleema eyi baheekere abalwala n'abantu bafarhirwe n'abazimu. Booshi baliiri baafumywa. ");
INSERT INTO hav_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Omudaahwa mukulu n'abantu baage booshi, k'okuderha abantu b'echigusho ch'aBasadukaayo, baaja bayunvira eNtumwa obongwa. ");
INSERT INTO hav_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Bazifarha n'okuzihira omu munyororo gw'abantu booshi. ");
INSERT INTO hav_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Aliko obudufu, malahika wa Nnaweerhu achinguula emilyango y'omunyororo. Akuula mo zila ntumwa n'okuzibwira ntya: ");
INSERT INTO hav_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","«Mugende, muje omu Nju ya Nnamahanga, munabalire olubaga byooshi biyerekeere kano kalamo gahyaahya.» ");
INSERT INTO hav_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ezo ntumwa zabeere zayunva ebyoola binwa, zalamukira eseeziseezi omu Nju ya Nnamahanga, zanarhondera kuyigiriza. Omudaahwa mukulu n'abantu baage baahika. Bahamagaza akabuga k'aBayaahudi n'enshimaanano yooshi y'abashamuka b'aBaisraheeli. Banarhuma abalanzi kuja omu munyororo kuleerha eNtumwa. ");
INSERT INTO hav_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Aliko abalanzi bagerere omu munyororo, barhababugaana mo. Baaja bagaluka n'okuja kubwira abakulu ntya: ");
INSERT INTO hav_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","«Rhwabugaanire omunyororo guchingirwe bwinja n'abalanzi bayimangire embere z'emilyango. Aliko rhwabeere rhwachinguula, ntaaye rhwabugaanire mo!» ");
INSERT INTO hav_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Egihe omukulu w'abalanzi b'eNju ya Nnamahanga n'abakulu b'abadaahwa bayunvaga ebyoola binwa, bayuumirwa, banachiibaza akaba bichi byahikiire eNtumwa. ");
INSERT INTO hav_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Muntu muguma aja ayinja kubabalira ntya: «Tala okw'abantu mwahiraga omu munyororo bayimangire omu Nju ya Nnamahanga, banali bayigiriza olubaga!» ");
INSERT INTO hav_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Omukulu w'abalanzi n'abantu baage baava baaja kubaleerha. Babaleerha buzira kubalibuza, kwenge baliyuubahire olubaga lwakababanda amabaale. ");
INSERT INTO hav_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Bayuusize kubaleerha, babaheeka embere w'akabuga k'aBayaahudi. Omudaahwa mukulu ababaza ntya: ");
INSERT INTO hav_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","«Ka rhurhalibabuzize bweneene ogurhachiyigiriza mw'eryoola ziino? Tala oku mwayunjwize eYerusaleema n'enyigirizo zenyu! Munashondere gurhuheesa eshagama y'oyu muntu!» ");
INSERT INTO hav_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Petero n'ezindi ntumwa bashubiza ntya: «Bihemere ogukenga Nnamahanga ahaali h'abantu. ");
INSERT INTO hav_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Nnamahanga wa bashookuluza beerhu, afuulire Yeesu mwayirhaga omu kumubamba oku musalaaba. ");
INSERT INTO hav_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Anamuzamwire ekulyo kwage nka Mukulu na Muchunguzi, y'aha aBaisraheeli obulyo b'okuleka ebyaaha na Nnamahanga ababalire ebyaaha byaabo. ");
INSERT INTO hav_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Rhuli bahamiiriza b'ebyoola byooshi haguma na Muuka-Mutagatiifu Nnamahanga aheere abamukenga.» ");
INSERT INTO hav_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Abantu b'akabuga k'aBayaahudi baaja bakaliha looshi omu kuyunva ebyoola binwa, banashonda kuyirha eNtumwa. ");
INSERT INTO hav_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Aliko haliiri omu bo oMufarisaayo oyirikwa Gamaliyeeri. Aliiri mwigiriza w'amarhegeko okengerwe n'olubaga looshi. Ayimanga ahagarhi k'akabuga k'aBayaahudi n'ogurhegeka barhange bahuluse eNtumwa hityu. ");
INSERT INTO hav_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Enyuma, aderha ntya: «Bantu b'eIsraheeli, muchilange oku bimukola kujirira abaala bantu. ");
INSERT INTO hav_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Embere za bino bihe, hahulukiire muntu muguma oyirikwa Teuda. Aliiri achiderha oku ali muntu mukulu, n'abantu hoofu magana mane bamukulikira. Aliko ayirhwa, booshi bamukulikiraga balibirha n'echigusho chaage chaafa. ");
INSERT INTO hav_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Enyuma zaage, omu gihe ch'oluganjo lw'abantu, haahulukira Mugalilaaya muguma oyirikwa Yuuda, arhuma abantu bamukulikira. Naye ayirhwa, na booshi bamukulikiraga bashandaazwa. ");
INSERT INTO hav_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Leero bunoola mbabwirire oku murhakulikiraga abaala bantu, munabaleke bagende. Bulaala, akaba ebi bali kujira guli muhigo changwa kaasi k'abantu, byaafa. ");
INSERT INTO hav_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Aliko akaba ebyoola birhengeere emwa Nnamahanga, murhakagala kubahanza. Muchilange mwangahengeera eyi muli mwalwisa Nnamahanga!» Abantu b'akabuga k'aBayaahudi bayunva amahano ma Gamaliyeeri. ");
INSERT INTO hav_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Bahamagala eNtumwa, bazishurhiisa, banazirhegeka oku zirhachiyigirizaga oku ziino lya Yeesu. Buzinda, bazilikuula. ");
INSERT INTO hav_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Entumwa zarhenga omu kabuga k'aBayaahudi eyi zishagalukire okubona zaganjirwe oku zikwaneene gukeneerezwa elugulu w'eziino lya Yeesu. ");
INSERT INTO hav_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Bagendeerera ngasi lusiku kuyigiriza omu Nju ya Nnamahanga n'omu nju z'abantu, n'okubala oMwazi Mwinja gwa Yeesu, ye Krisitu. ");
INSERT INTO hav_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Mw'ezoola siku, oluganjo lw'abemeezi lwaliiri lwayushuuka. aBayaahudi baliiri kuderha olulimi lw'eKigiriki barhondera kulundumira aBayaahudi baliiri kuderha olulimi lw'eGiheburaniya, bulaala abashumbakazi baabo baali babonereerwe egihe ch'okugaba ebiryo ngasi lusiku. ");
INSERT INTO hav_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Zilaala ntumwa ekumi n'ebiri zagusha abemeezi booshi, zanababwira ntya: «Birhakwaneene rhulekeerere kuyigiriza eChinwa cha Nnamahanga mpu rhubeere rhuli rhwagaba ebiryo. ");
INSERT INTO hav_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Cho girhumire, beene beerhu, mushonde ahagarhi kenyu bantu mushanvu bahamiriizwe bwinja n'abantu, bayunjwire Muuka-Mutagatiifu n'obwenge bunene. Boowe, barhwaheereza akoola kaasi. ");
INSERT INTO hav_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ntyo neerhu, rhwakomeza gusaliira n'okuyigiriza eChinwa cha Nnamahanga.» ");
INSERT INTO hav_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Abemeezi booshi bali chigushire ahoola basiima eyoola myaazi. Bachishoga Sitefaano, muntu w'obwemeezi bunene onayunjwire Muuka-Mutagatiifu, Firipo, Porokoro, Nikanori, Timooni, Parimena na Nikola w'eAntiyokiya wayemeeraga edini ly'eKiyaahudi. ");
INSERT INTO hav_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Bamoleka bo eNtumwa, nazo zabasaliirira eyi zibalambuliire kw'amaboko. ");
INSERT INTO hav_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Echinwa cha Nnamahanga chaliiri kuyaalagala omu bantu, oluganjo lw'abemeezi lwaliiri kuyushuuka bweneene eYerusaleema, n'echigusho chinene ch'abadaahwa chayemeera Yeesu. ");
INSERT INTO hav_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Sitefaano aliyunjwire emigisho n'obuhashe bunene. Byaarhuma agenda ajira ebigiriginjo n'ebimenyeeso binene omu lubaga. ");
INSERT INTO hav_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Aliko bantu baguma, barhondera obuhaka na Sitefaano. Abo bantu bahulikiraga omu sinagoogi ederhwa y'«aBantu Barhengaga omu Buja», barhengaga omu gishagala ch'eKureene n'eche Alegizanduriya. Abandi bahulukiraga omu gihugo ch'eKilikiya n'eche Aziya. ");
INSERT INTO hav_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Aliko barhagalaga guhima Sitefaano kwenge aligwerhe bwenge bunene, na Muuka-Mutagatiifu aliiri kumuha ebinwa by'okuderha. ");
INSERT INTO hav_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Baaja baaha abantu efuranga yi baderha oku: «Rhwamuyunvaga ali aderha ebinwa by'okudukanga Muusa na Nnamahanga.» ");
INSERT INTO hav_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Bararusa olubaga n'abashamuka b'aBayaahudi haguma n'abigiriza b'amarhegeko. Bayegeera Sitefaano, bamurhoola, banamuheeka omu kabuga k'aBayaahudi. ");
INSERT INTO hav_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Baleerha abahamiiriza b'obubeeshi baliiri baderha ntya: «Oyu muntu arhali aleka kuderha ebinwa bibi elugulu w'eNju ntagatiifu ya Nnamahanga n'eRhegeko lya Muusa. ");
INSERT INTO hav_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Kwenge rhwamuyunvaga aderha oku Yeesu w'eNazareeti ashanda eyi Nju ya Nnamahanga, anahindamula n'emicho Muusa arhulekeraga.» ");
INSERT INTO hav_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Abantu booshi baliiri mw'akoola kabuga k'aBayaahudi babeere bali baheneereza Sitefaano, baava baabona amalanga maage makola mashushire nk'ama malahika. ");
INSERT INTO hav_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Omudaahwa mukulu aja abaza Sitefaano ntya: «K'ebi bali bakuderha ko biri by'okuli?» ");
INSERT INTO hav_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Sitefaano ashubiza ntya: «Ba daarha na beene beerhu, munyunvirize! Nnamahanga w'obukuuze abonekeraga Abrahaamu, shookuluza weerhu, egihe aliiri omu gihugo ch'eMezopotamiya, embere alame omu gishagala ch'eHaraani. ");
INSERT INTO hav_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Anamubwira ntya: ‹Rhenga omu gihugo chaawe n'omu mulala gwawe, oje omu gihugo nji nakuyeereka.› ");
INSERT INTO hav_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Abrahaamu aja arhenga omu gihugo ch'aBakalidayo aja kulama omu gishagala ch'eHaraani. Enyuma w'olufu lw'eshe, Nnamahanga amubungiisa kandi gurhenga eHaraani, ayinja kulama mu chinoola gihugo mulamire mo bunoola. ");
INSERT INTO hav_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Nnamahanga arhamuhaaga agashambala mu chinoola gihugo, arhamuhaaga chiro ahantu agahira okugulu. Aliko amulaganya okumuheereza cho n'ababurhwa baage nachiro nta mwana abaga aza kugwarha. ");
INSERT INTO hav_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Nnamahanga amubwira ntya: ‹Ababurhwa baawe nji baalama nka bahiisi omu gihugo chabeene, nji babajira baja, nji banabalibuza myaaka magana mane. ");
INSERT INTO hav_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Aliko egihugo nji baaba babeere mo baja, nyoono nye nji nagihana. Buzinda bw'aho nji babunguluka n'okumparamya hanoola.› ");
INSERT INTO hav_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ntyo, Nnamahanga aja ajira endaganyo haguma n'Abrahaamu. Echimenyeso chaayo kwali gukembuulwa. Aja aburha Isaka anamukembuula olusiku lwa munaane enyuma z'okuburhwa. Isaka naye akembuula omugala Yakobo, na Yakobo akembuula bashookuluza beerhu, bo balaala bagala baage ekumi na babiri. ");
INSERT INTO hav_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","«Bashookuluza bagwarha obongwa ku Yozefu, bamuguza y'aheekwa omu gihugo ch' eMiisiri nka muja. Aliko Nnamahanga aliiri haguma naye, ");
INSERT INTO hav_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","anamukuula omu malibuko maage mooshi. Amuha obwenge bunene n'okuyemeerwa embere za Farao, mwami w'egihugo ch'eMiisiri. Farao naye amujira mwimangizi w'echo gihugo n'enju yaage yooshi. ");
INSERT INTO hav_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Enyuma z'aho, enzara nene yaba omu gihugo chooshi ch'eMiisiri n'omu gihugo ch'eKanaana. Amalibuko maliiri manene bweneene. Bashookuluza beerhu barhaalichiri baabona echi baalya. ");
INSERT INTO hav_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Yakobo abeere ayunva oku hali engano omu gihugo ch'eMiisiri, arhuma yo bashookuluza beerhu oku burhanzi. ");
INSERT INTO hav_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Bajiire y'obwakabiri, Yozefu achimenyeesa oku beene baabo, na Farao aja amenya omulala gwa Yozefu. ");
INSERT INTO hav_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Enyuma, Yozefu arhuma baje guhamagala eshe Yakobo n'omulala gwage gooshi. Abantu b'omulala gwage baliiri makumi gali mushanvu na barhaano. ");
INSERT INTO hav_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Yakobo aja eMiisiri, afiira yo n'abandi bashookuluza beerhu. ");
INSERT INTO hav_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Babaheeka eShekemu, banabahamba omu shinda Abrahaamu agulaga emwa beene Hamoori oku gichiiro ch'efuranga. ");
INSERT INTO hav_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","«Egihe chabeere chiri hoofu Nnamahanga alikwaneene kuyeeneza mo echilagaane ahaaga Abrahaamu, olubaga lwerhu lwaluga, lwanaba lunene omu gihugo ch'eMiisiri. ");
INSERT INTO hav_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Omwami muhyaahya orhaliyinji Yozefu ava ayima oku gihugo ch'eMiisiri. ");
INSERT INTO hav_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Oyoola mwami arhebeka olubaga lwerhu, alibuza bashookuluza beerhu, abalekeesa enjolyaana zaabo yi zifa. ");
INSERT INTO hav_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","«Mw'amo mango, Muusa aburhwa. Aliiri mwinja omu meesho ma Nnamahanga. Alilemberwe myeezi esharhu omu nju y'eshe. ");
INSERT INTO hav_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Abeere abishwa embuga, mwali wa Farao amubugula, anamulemba nka mugala waage. ");
INSERT INTO hav_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Muusa ayigirizwa omu bwenge bunene booshi bw'aBanyamiisiri, anaba muntu w'obuhashe omu binwa byaage n'omu bijiro byaage. ");
INSERT INTO hav_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","«Egihe ayeenezaga myaaka makumi mane, ahiga kuja kulambagirira beene baabo, b'aBaisraheeli. ");
INSERT INTO hav_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ava abona mwene waabo muguma oli alibuzwa n'oMunyamiisiri. Amulwira, anamuhoolera omu kuyirha oyoola Munyamiisiri. ");
INSERT INTO hav_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Alikengereere oku beene baabo bakamenyere oku kugerera ye Nnamahanga abakuula omu buja. Aliko barhabimenyaga. ");
INSERT INTO hav_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Olusiku lwakulikiraga, Muusa abugaana aBaisraheeli babiri bali baalwa. Omu gushonda abayunvisanye yi bagwarha omurhuula, ababwira ntya: ‹Ego baza wee, oku muli baguma! Chagarhuma mwalibuzanya?› ");
INSERT INTO hav_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Aliko olaala waliiri alibuza owaabo ashunika Muusa n'okubaza ntya: ‹Nde wakujiraga mukulu na muzuuzi weerhu? ");
INSERT INTO hav_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ka wooyo oshondere kunyirha nk'oku nji wayirhaga olaala Munyamiisiri mulaagolo?› ");
INSERT INTO hav_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Muusa ayunviirhe echoola chinwa, alibirha n'okuva abungira omu gihugo ch'eMidiyaani. Aburhira eyoola munda bagala babiri. ");
INSERT INTO hav_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","«Myaaka makumi mane yabeere yayeenera, malahika amubonekera omu mpinga y'omusozi gw'eSinaayi omu birimi by'omuliro byaliiri byagulumira omu gishaka. ");
INSERT INTO hav_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Muusa abwene ebyoola, asoomererwa okoola kubonekerwa. Aliko egihe abaaga ali ayegeera y'achirhegeereza, ava ayunva omulenge gwa Nnaweerhu gwaderha ntya: ");
INSERT INTO hav_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‹Nyoono nye Nnamahanga wa bashookuluza baawe, Nnamahanga w'Abrahaamu, Isaka na Yakobo!› Muusa ahinda omusisi, arhanagishubiiraga kugendeerera kulola. ");
INSERT INTO hav_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Nnaweerhu amubwira ntya: ‹Hogola ebiraato byaawe, kwenge hanoola oyimangire hali hantu hatagatiifu. ");
INSERT INTO hav_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nabwene bwinja amalibuko m'olubaga lwani luli omu gihugo ch'eMiisiri, nayunviirhe amalira maabo. Bo bunoola nayandageere kubalikuuza. Jaaga wayinja, nagurhuma eMiisiri.› ");
INSERT INTO hav_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","«Oyo Muusa y'aBaisraheeli balahiraga omu kuderha ntya: ‹Nde wakujiraga mukulu na muzuuzi weerhu?›, yeewe ye Nnamahanga arhumire nka mukulu na murhabaazi, kugerera oburhabaale bwa malahika wamubonekeraga omu gishaka. ");
INSERT INTO hav_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Yeewe ye wakuulaga aBaisraheeli omu gihugo ch'eMiisiri omu kujira ebigiriginjo n'ebimenyeeso mw'echo gihugo, omu nyanja Ndukula n'omu mpinga mu myaaka makumi mane. ");
INSERT INTO hav_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Kandi Muusa ye wabwiraga aBaisraheeli ntya: ‹Nnamahanga nj'abaha omuleebi oli nka nyoono gurhenga omu beene benyu.› ");
INSERT INTO hav_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Egihe olubaga lw'eIsraheeli lwaliiri omu mpinga, oyo Muusa ye waliiri ahagarhi ka bashookuluza beerhu, na malahika waliiri amuganiiza oku musozi gw'eSinaayi. Yeewe ye wayankiiriraga ebinwa by'akalamo y'arhuha byo. ");
INSERT INTO hav_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Aliko bashookuluza beerhu barhashondaga kumukenga, si bamulahira. Bachifiija omu mirhima yaabo mpu bagaluke eMiisiri. ");
INSERT INTO hav_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Babwira Haruuni ntya: ‹Orhujirire emaana z'okulambagira embere zeerhu, kwenge rhurhamenyere ebyabereere oyo Muusa warhukuulaga omu gihugo ch'eMiisiri.› ");
INSERT INTO hav_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Mw'ezoola siku, bachijirira egishushanyo ch'ekimasha. Barhuulira cho entuulo y'ogusireeza, banajirira edinye echintu enfune zaabo zajiraga. ");
INSERT INTO hav_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Nnamahanga aja arhenga ahagarhi kaabo, anabaleka baharamye ezuuba, omwezi n'enyenyeezi nk'oku biyandikirwe ntya omu gitaabu ch'abaleebi: ‹Ego bantu b'eIsraheeli, ka nyoono nye mwarhuuliraga ebirhungano n'ezindi ntuulo z'ogusirezwa omu myaaka makumi mane omu mpinga? ");
INSERT INTO hav_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Nangwa, aliko mwaliheekere ehema ly'emaana yenyu eyirikwa Moloki n'enyenyeezi y'emaana yenyu eyirikwa Refaani, ebyoola bishushanyo mwajiraga yi mubiharamya! Elugulu w'ebyoola nabarhuma buja gurhaluka eBabilooni.› ");
INSERT INTO hav_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","«Bashookuluza beerhu bali bagwerhe omu mpinga ehema ly'obuhamiriza. Bakwizaga elyoola hema nk'oku Nnamahanga arhegekaga Muusa gukulikirana n'eshusho abonaga. ");
INSERT INTO hav_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Enyuma z'okuyankiirira elyo hema, bashookuluza beerhu haguma na Yoshuwa baliheeka omu gihugo barhoolaga eyi Nnamahanga amalibisya embaga zaacho embere zaabo. Lyabeera mw'echo gihugo kugera amango ma Daawudi. ");
INSERT INTO hav_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Daawudi ayemeerwa na Nnamahanga, ava amuhema ntya: ‹Nnamahanga wa Yakobo, onyemeerere nkuyumbakire eNju.› ");
INSERT INTO hav_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Aliko Solomoono ye wamuyumbakiire eNju. ");
INSERT INTO hav_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Chiro akaba ntyo, Nnamahanga w'Elugulu Bweneene arhalama omu bintu byajirirwe n'efune z'abantu, nk'oku omuleebi aderhere: ");
INSERT INTO hav_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‹Nnaweerhu aderhere ntya: “Empingu yo ntebe yaani, n'egulu yo ndabarhiro yaani. Nju nchi nji mwanyumbakira, hayi nji haaba hantu haani h'oguhumuukira? ");
INSERT INTO hav_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","K'arhali fune yaani yajiraga ebyoola byooshi?”› ");
INSERT INTO hav_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","«Ego mwe bantu bazibu! Emirhima yenyu n'amarhwi menyu biri by'abantu barhayemereere Nnamahanga, muli kuguma na bashookuluza benyu. Ngasi mango munalahira kuyunva omulenge gwa Muuka-Mutagatiifu. ");
INSERT INTO hav_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Nde omu baleebi orhalibuzwaga na bashookuluza benyu? Bayirhaga balaala babalaga embere okuyinja kw'Okwaneene. Y'olaala mwabo nji mwalenganyaga, mwanamuyirha. ");
INSERT INTO hav_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Mwewe, mwe mwayankiriraga Erhegekobamalahika babalaga, aliko murhalikulikiraga!» ");
INSERT INTO hav_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Abantu b'akabuga k'aBayaahudi bayunvire ebyoola binwa byooshi bakaliha bweneene, banarhondera kumugugurhira amenyo. ");
INSERT INTO hav_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Aliko Sitefaano alola empingu eyi ayunjwire Muuka-Mutagatiifu, abona obukuuze bwa Nnamahanga na Yeesu eyi ayimangire ekulyo kwa Nnamahanga. ");
INSERT INTO hav_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Aderha ntya: «Mbwene empingu zichinguukire na Mwene oMuntu ayimangire ekulyo kwa Nnamahanga!» ");
INSERT INTO hav_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Baaja bayaama bweneene eyi bafukire amarhwi maabo. Booshi haguma bamubalalira ko. ");
INSERT INTO hav_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Bamukuula omu gishagala, banamubanda amabaale. Abantu bamusidaakaga babikiisa omuzaana wayirikwaga Saawulo emyambalo yaabo. ");
INSERT INTO hav_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Babeere bali bamubanda amabaale, Sitefaano asaliira ntya: «Nnaweerhu Yeesu, yankirira omuuka gwani!» ");
INSERT INTO hav_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Afukama, n'okuva ayaama ntya n'omulenge munene: «Nnaweerhu, orhabahaniraga echiila chaaha!» Ayuusize kuderha ebyoola binwa, afa. ");
INSERT INTO hav_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saawulo aliyemereere olufu lwa Sitefaano. Oloola lusiku, echigusho ch'abemeezi ch'eYerusaleema charhondera kulibuzwa bweneene. Booshi, kuleka entumwa, bayandaala omu gihugo ch'eYudeeya n'omu ch'eSamariya. ");
INSERT INTO hav_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Aliko abantu bakengaga Nnamahanga bahamba Sitefaano, banamulakira bweneene. ");
INSERT INTO hav_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Saawulo yeewe, aliiri kulibuza echigusho ch'abemeezi. Aliiri kuja omu maju, anakuula mw'abalume n'abakazi, anabaheeka omu munyororo. ");
INSERT INTO hav_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Aliko emunda balaala bashandaalaga baliiri balenga, baliiri babala oMwazi Mwinja. ");
INSERT INTO hav_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Firipo ayandagalira omu gishagala chinene ch'egihugo ch'eSamariya, arhondera kubalira abantu elugulu wa Krisitu. ");
INSERT INTO hav_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Abantu banene baliiri bayunviriza bwinjabwinja haguma enyigirizo za Firipo, n'okubona ebimenyeeso aliiri ajira. ");
INSERT INTO hav_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Abazimu baliiri barhenga omu bantu banene eyi bali bayaama bweneene. Bantu banene bahunzize n'ebirema baafuma. ");
INSERT INTO hav_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Habonekana obushagaluke bunene mw'echoola gishagala. ");
INSERT INTO hav_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Muntu muguma oyirikwa Simooni abaaga arhuula mw'echoola gishagala. Aliiri ajirira m'obukurungu n'ogusoomeza aBasamariya. Aliiri guchiihala oku ye ntabalalwa. ");
INSERT INTO hav_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Booshi, gurhengera oku mudoorho guhika oku mukulu, baliiri bamuyunviriza n'okuderha ntya: «Oyoola muntu ali buhashe bwa Nnamahanga, bulaala buderhwa ‹Buhashe Bunene.›» ");
INSERT INTO hav_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Baliiri bamuyunviriza, bulaala haliiri hamaagera esiku zinene ey'abasomeeze n'obukurungu bwage. ");
INSERT INTO hav_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Babeere bayemeera Firipo waliiri abalira bo oMwazi Mwinja gw'obwime bwa Nnamahanga n'eziino lya Yeesu Krisitu, abalume n'abakazi babatiizwa. ");
INSERT INTO hav_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simooni naye yenyine ayemeera Yeesu, anabatiizwa. Arhagirhengaga ku Firipo, anasoomererwa ebimenyeeso n'ebijiro by'obuhashe binene byaliiri byajirika. ");
INSERT INTO hav_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Entumwa zaliiri eYerusaleema zabeere zayunva okw'abantu b'eSamariya bayankiriire eChinwa cha Nnamahanga, zabarhumira Petero na Yohaana. ");
INSERT INTO hav_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Bombi babeere baagera eSamariya, basaliirira abemeezi yi bayankirira Muuka-Mutagatiifu, ");
INSERT INTO hav_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","kwenge abaga arhaza yandagalira chiro oku muguma wabo. Babaaga babatiizizwe konyine oku ziino lya Nnaweerhu Yeesu. ");
INSERT INTO hav_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Petero na Yohaana baaja babalambuulira kw'amaboko, banayankirira Muuka-Mutagatiifu. ");
INSERT INTO hav_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Egihe Simooni abonaga oku bayankiriire Muuka-Mutagatiifu kugerera eNtumwa omu kubalambuulira kw'amaboko, abaheekera efuranga, anababwira ntya: ");
INSERT INTO hav_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","«Mumpaage naani obuula buhashe yi ngasi muntu naani nalambuulira kw'amaboko ayankirire Muuka-Mutagatiifu.» ");
INSERT INTO hav_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Aliko Petero amubwira ntya: «Efuranga zaawe zihere haguma naawe, bulaala waliganiizize kugula empaano ya Nnamahanga kugerera efuranga! ");
INSERT INTO hav_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Orhagwerhe chigabi chiro n'egityu mw'aka kaasi, kwenge omurhima gwawe gurhakwaneene embere za Nnamahanga. ");
INSERT INTO hav_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Jaaga waleka ebyaaha byaawe by'oguchifiija, onasaliire Nnaweerhu yi nkabaga ababalire enganiiza y'omurhima gwawe. ");
INSERT INTO hav_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Kwenge mbwene oku oyunjwire obongwa nka kalulwe k'endulwe, onashwekerwe n'ebyaaha.» ");
INSERT INTO hav_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simooni ashubiza ntya: «Mwenyine munsaliirire Nnaweerhu, yi ntaacho chimbeerage omu bi mwaderhere.» ");
INSERT INTO hav_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Petero na Yohaana bamalire guhaana obuhamiriza bwabo n'okuyigiriza eChinwa cha Nnaweerhu, bagaluka eYerusaleema. Bagenda bali baabala oMwazi Mwinja omu bishagala binene by'aBasamariya. ");
INSERT INTO hav_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Malahika wa Nnaweerhu abwira Firipo ntya: «Yimanga, onagende omu njira ejiire egarhongo, elaala erhengeere eYerusaleema guhika eGaza.» Eyoola njira egerere omu mpinga. ");
INSERT INTO hav_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Ava ayimanga, agenda. Na mw'eyoola njira, mwaliiri oMunyaetiyopiya muguma w'entazi. Aliiri mukozi mukulu wa Kandake mwamikazi w'Etiyopiya, na murhegesi w'ebikulo byaage byooshi. Alijiire eYerusaleema guharamya Nnamahanga. ");
INSERT INTO hav_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Abeere ali arhenga yo ey'ayikeere omu mudugaari gwage, eyi anali asoma n'omulenge munene egitaabu ch'omuleebi Isaya. ");
INSERT INTO hav_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Muuka-Mutagatiifu abwira Firipo ntya: «Gendeerera, oshimaane guliira mudugaari.» ");
INSERT INTO hav_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Firipo alibirhira go, ayunva oMunyaetiyopiya ali asoma egitaabu ch'omuleebi Isaya. Firipo amubaza ntya: «K'oyunviirhe eby'oli wasoma?» ");
INSERT INTO hav_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ashubiza ntya: «Gurhe nakabiyunva, akonva ntaaye oli ampuguulira?» Ava ayinginga Firipo ashone, ayikale haguma naye omu mudugaari. ");
INSERT INTO hav_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","aMandiko Matagatiifu aliiri asoma maderhere ntya: «Aliheekerwe nka ntaama baaja kubaaga. Nka mwanabuzi osirire embere z'oli wamucha amooya, arhabumbuulaga obuunu bwage. ");
INSERT INTO hav_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Omu guchirhonda kwage, barhamuchiiraga bwinja olushinja lwage. Nde nji waabala emyaazi y'egisisi chaage? Kwenge bakuulire akalamo kaage omu gulu.» ");
INSERT INTO hav_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Oyoola Munyaetiyopiya abaza Firipo ntya: «Nkuyingingire, ombwire nde y'omuleebi aderhere ko ebyoola? Ali achiiderha oku byo changwa oku windi?» ");
INSERT INTO hav_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Firipo aja arhonderera oku malaala Mandiko Matagatiifu oMunyaetiyopiya aliiri asoma, amubalira oMwazi Mwinja gwa Yeesu. ");
INSERT INTO hav_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Babeere bachiri bagenda, baagera aha amenji mali. Oyoola Munyaetiyopiya abaza ntya: «Tala amenji! Bichi bimbuzize kubatiizwa?» ");
INSERT INTO hav_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Firipo amushubiza ntya: «Akonva oyemeerere Yeesu n'omurhima gwawe gooshi, wakabatiizwa.» Naye aderha ntya: «Neechi! Nayemereere oku Yeesu Krisitu ali Mwene Nnamahanga.» ");
INSERT INTO hav_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Oyoola Munyaetiyopiya ava ayimanza omudugaari. Bombi bayandagalira omu menji, Firipo n'olaala Munyaetiyopiya. Firipo ava amubatiiza. ");
INSERT INTO hav_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Babeere barhenga omu menji, oMuuka gwa Nnaweerhu gwaheeka Firipo. Oyoola Munyaetiyopiya arhachimubonaga, aliko agendeerera olugenzi, eyi ashagalukire. ");
INSERT INTO hav_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Firipo yeewe, ahengeera akola ali omu gishagala che Azoto. Alema abala yo oMwazi Mwinja omu bishagala byooshi aliiri agera mo, guhika okugera kwage omu gishagala ch'eKayizariya. ");
INSERT INTO hav_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Mw'ezoola siku, Saawulo alichiri aderha okw'ayirha abemeezi ba Nnaweerhu. Aja emw'omudaahwa mukulu, ");
INSERT INTO hav_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","anamuhema amaruba m'okuja omu masinagoogi m'omu gishagala ch'eDamasiki, y'akabugaana yo abalume changwa abakazi bakulikiire eNjira ya Nnaweerhu, abashweke, anabaleerhe eYerusaleema. ");
INSERT INTO hav_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Abeere ali omu njira hoofu ahike eDamasiki, ho n'aho, obumoleke bwarhenga empingu bwamugorha. ");
INSERT INTO hav_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ahenera ahashi, anava ayunva omulenge gwamubaza ntya: «Saawulo, Saawulo, girhumire wandibuza?» ");
INSERT INTO hav_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ashubiza ntya: «Nnaweerhu, wooyo oli nde?» Omulenge gwashubiza ntya: «Nyoono, ndi Yeesu, oli walibuza. ");
INSERT INTO hav_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Aliko oyimange, oje omu gishagala. Omoola, bakubwira ech'okwaneene kujira.» ");
INSERT INTO hav_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Abantu baliiri babalama haguma na Saawulo bayimanga buzira kuderha elugulu w'ogusoomerwa. Baliiri bayunva omulenge, aliko ntaaye baliiri baabona. ");
INSERT INTO hav_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saawulo ayimanga, azibuula ameesho, aliko ntaacho aliiri abona. Baava bamufarhira oku kuboko, bamuheeka eDamasiki. ");
INSERT INTO hav_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ajira siku esharhu buzira kubona, na buzira kulya changwa kunywa. ");
INSERT INTO hav_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","eDamasiki yaliiri omwemeezi oyirikwa Hananiya. Nnaweerhu amubonekera, amuhamagala: «Hananiya!» Naye ashubiza ntya: «Nyoono oyu, Nnaweerhu!» ");
INSERT INTO hav_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Nnaweerhu amubwira ntya: «Yimanga, ogende omu njira eyirikwa ‹Elambuukire›, obaze omu nju ya Yuuda omuntu oyirikwa Saawulo w'eTariso. Ali asaliira mu kino gihe. ");
INSERT INTO hav_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Omu kubonekerwa, abwene omuntu oyirikwa Hananiya aja omu nju, amanamulambuulira kw'amaboko y'ashube kubona.» ");
INSERT INTO hav_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Hananiya ashubiza ntya: «Nnaweerhu, nayunvire bantu banene baderha obubi booshi oyoola muntu ajiriire abemeezi baawe eYerusaleema. ");
INSERT INTO hav_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Chiro na hanoola, abakulu b'abadaahwa bamuheere obuhashe bw'ogushweka abantu booshi basaliira oku ziino lyaawe.» ");
INSERT INTO hav_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Aliko Nnaweerhu abwira Hananiya ntya: «Genda, kwenge oyoola mulume ali gikoleeso nachishogere ch'okubala eziino lyaani embere z'abarhali Bayaahudi n'abaami baabo, n'embere z'aBaisraheeli. ");
INSERT INTO hav_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Namuyeereka nyoono nyenyine amalibuko mooshi akwaneene kulibuka elugulu waani.» ");
INSERT INTO hav_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Hananiya aja agenda. Abeere agera omu nju, alambuulira Saawulo kw'amaboko, anamubwira ntya: «Saawulo, mwene weerhu, Nnaweerhu Yeesu wakubonekeraga omu njira embere oyinje hano, antumire y'oshube kubona, onayunjule Muuka-Mutagatiifu.» ");
INSERT INTO hav_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ho n'aho, ameesho maage maarhoga kw'ebiri nk'amagamba, anashuba kubona. Ayimanga, anabatiizwa. ");
INSERT INTO hav_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Aja alya ebiryo, anashuba kugwarha emisi. Saawulo abeera siku zigeeke haguma n'abemeezi baliiri eDamasiki. ");
INSERT INTO hav_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ava arhondera kubala omu masinagoogi oku Yeesu ali Mwene Nnamahanga. ");
INSERT INTO hav_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Booshi baliiri bamuyunva, basoomerwa; banalema babazana ntya: «K'arhali oyuula ye waliiri alibuza bweneene abasaliira eYerusaleema oku ziino lya Yeesu? K'arhanayinjaga hanoola kubashweka n'okubaheeka embere z'abakulu b'abadaahwa?» ");
INSERT INTO hav_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Aliko obuhashe bwa Saawulo bwaliiri bwayuushuka omu gusoomeza aBayaahudi balilamire eDamasiki, omu kuyeereka bwinjabwinja oku Yeesu ye Krisitu. ");
INSERT INTO hav_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Enyuma w'esiku zinene, aBayaahudi bahiga kuyirha Saawulo. ");
INSERT INTO hav_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Aliko naye amenya ogo muhigo. Baliiri balanga emilyango y'egishagala ezuuba n'obudufu yi bamuyirhe. ");
INSERT INTO hav_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Aliko obudufu, abigirizwa ba Saawulo bamurhoola, banamuyandagaza omu garhanda embuga w'olugurhu lw'egishagala. ");
INSERT INTO hav_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Saawulo agenda eYerusaleema. Abeere ahika yo, ashonda gurhe agachigusha haguma n'abemeezi, aliko booshi baliiri bamuyuubahire, kwenge barhaliyemereere oku abeere mwemeezi. ");
INSERT INTO hav_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Baranaaba aja amurhoola, amuheekera eNtumwa. Abashambaalira gurhe Saawulo alibwene Nnaweerhu omu njira na gurhe Nnaweerhu ashambaalaga naye. Ashuba kubashambaalira gurhe Saawulo ayigirizaga buzira buuba eDamasiki oku ziino lya Yeesu. ");
INSERT INTO hav_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Gurhengera echoola gihe, Saawulo alema alama haguma n'eNtumwa, alambagira haguma nabo omu Yerusaleema, analiiri ayigiriza buzira buuba oku ziino lya Nnaweerhu. ");
INSERT INTO hav_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Aliiri ashambaala n'oguhatana n'aBayaahudi b'olulimi lw'eKigiriki. Aliko aboola bantu baliiri bashonda kumuyirha. ");
INSERT INTO hav_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Abaabo babeere bamenya ogoola mwazi, baheeka Saawulo omu gishagala ch'eKayizariya, banamurhuma omu gishagala ch'eTariso. ");
INSERT INTO hav_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Mw'echoola gihe, echigusho ch'abemeezi chaliiri omu murhuula omu Yudeeya yooshi, eGalilaaya n'eSamariya. Chaliiri chagwarha emisi, chalama omu kuyuubaha Nnaweerhu, n'okuyuushuka kugerera oburhabaale bwa Muuka-Mutagatiifu. ");
INSERT INTO hav_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Petero abeere ali agera ngasi hantu, ayandagalira emwa abemeezi baliiri balamire omu gishagala ch'eLuuda. ");
INSERT INTO hav_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Abugaana y'omuntu oyirikwa Ayineya walihunzize. Alilyaamire oku gishanja gurhenga myaaka munaane. ");
INSERT INTO hav_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Petero ava amubwira ntya: «Ayineya, Yeesu Krisitu amagufumya. Yimanga onazinge egishanja chaawe!» Ho n'aho ayimanga. ");
INSERT INTO hav_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Abantu booshi b'eLuuda na b'omu bulambo bw'eSaroni babeere baabona Ayineya, bayemeera Nnaweerhu. ");
INSERT INTO hav_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Omu gishagala ch'eYopa mwaliiri omukazi muguma mwemeezi wayirikwaga Tabita. Omu lulimi lw'eKigiriki ye Dorika. Agendaga ajira ebijiro binene binja n'ebyo bubabale. ");
INSERT INTO hav_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Mw'ezoola siku, alwala, anava afa. Bamuyooza, bamuheeka omu gorofa ebusiika. ");
INSERT INTO hav_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Abemeezi babeere bayunva oku Petero ali eLuuda, hoofu n'eYopa, baarhuma balume babiri kumuyinginga ntya: «Rhuguhemere, yinja emwerhu buzira kulegama.» ");
INSERT INTO hav_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Petero ayimanga, anava agenda haguma nabo. Bagerere yo, bamuheeka omu gorofa ebusiika. Abashumbakazi booshi baliiri ahoola bayegeera Petero eyi bali baalira. Baliiri bamuyeereka amalopo n'eyindi myambalo Dorika abahangiraga egihe aliiri mugumaguma. ");
INSERT INTO hav_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Petero ahulusa abantu booshi, aja afukama, asaliira. Enyuma ahindamukira emunda omubiri gwaliiri, aderha ntya: «Tabita, yimanga!» Tabita aja azibuula ameesho. Abwene Petero, ayikala. ");
INSERT INTO hav_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Petero amufarhira oku kuboko, amurhabaala kuyimanga. Aja ahamagala abashumbakazi n'abandi bemeezi, anabamoleka ye, eyi ali mugumaguma. ");
INSERT INTO hav_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Eyoola myaazi yamenyeekana omu gishagala chooshi ch'eYopa n'abantu banene bayemeera Nnaweerhu. ");
INSERT INTO hav_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Petero abeera eYopa siku zinene emw'omulume oyirikwa Simooni waliiri muhanga omu gukwiza empu. ");
INSERT INTO hav_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Omu gishagala ch'eKayizariya haliiri muntu muguma wayirikwaga Korineliyo. Aliiri mukulu w'echigusho ch'abasoda chayirikwaga «Chigusho ch'aBaitaliyana.» ");
INSERT INTO hav_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Yeewe n'abantu booshi b'omu mwage, bakengaga Nnamahanga n'okumuyuubaha. Agendaga arhabaala abakene bweneene, anazigaanaga gusaliira Nnamahanga ngasi mango. ");
INSERT INTO hav_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Hoofu n'esaa mwenda z'ezuuba, abonekerwa, abona malahika wa Nnamahanga aja omu mwage n'okumuhamagala ntya: «Ego Korineliyo!» ");
INSERT INTO hav_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Abeere amuloleereza, ayuubaha, anamubaza ntya: «Nnaweerhu, bichi byabeere?» Malahika amushubiza ntya: «Nnamahanga ayunviirhe amasaala maawe n'oburhabaale bwawe oku bakene anabuyibukire. ");
INSERT INTO hav_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Ojaage warhuma abantu eYopa baleerhe Simooni washembulwaga Petero. ");
INSERT INTO hav_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ahandire emw'owundi Simooni w'omulenga omu gukwiza empu, n'enju yaage eri eburhambi bw'enyanja.» ");
INSERT INTO hav_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Malahika wamuganiizaga abeere agenda, Korineliyo ahamagala abakozi baage babiri b'akaasi k'omu nju, n'omusoda muguma omu balaala balemaga bamulanga, okenga Nnamahanga. ");
INSERT INTO hav_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Amalire kubalira bo byooshi byabeere, abarhuma eYopa. ");
INSERT INTO hav_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Olusiku lwakulikiraga, aboola bantu basharhu babeere bachiri omu njira banakola bali bayegeera egishagala, Petero azamuukira elugulu oku nju gusaliira ey'emidi eri hoofu. ");
INSERT INTO hav_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ayunva enzara, anagifiija kulya. Babeere bali bamuvuyira ebiryo, abonekerwa. ");
INSERT INTO hav_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Abona empingu echingwirwe n'echintu gishushire n'omwenda munene gifarhiriirwe oku bishimbiri bine chiri charhenga omu chanya n'okuyandagazwa oku daho. ");
INSERT INTO hav_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Kw'echoola chintu kwaliiri ngasi buuko bw'enyama z'amagulu mane, enyama zibululuka oku daho, n'enyunyi zibalala omu chaalege. ");
INSERT INTO hav_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Omulenge muguma gwava gwamubwira ntya: «Petero, yimanga, baaga onalye.» ");
INSERT INTO hav_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Petero ashubiza ntya: «Nangwa Nnaweerhu! Ntashubiraga kulya echintu girhakwaneene kuliibwa, girhanacheesezwe!» ");
INSERT INTO hav_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Obwakabiri omulenge gwamubwira ntya: «Echi Nnamahanga acheeseze, wooyo orhagirhoolaga oku girhakwaneene kuliibwa!» ");
INSERT INTO hav_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ebyoola byaaba gasharhu, n'enyuma echoola chintu chaava chazamuulirwa empingu. ");
INSERT INTO hav_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Petero abeere achiri achibaza bichi okola kubonekerwa abonaga kuderhere, abantu Korineliyo arhumaga baaja baahika oku mulyango g'okuja omu nju. Babaaga babaziriize embere bamenye enju ya Simooni. ");
INSERT INTO hav_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Balegereza, banabaza akonva ahoola ha Simooni washembulwaga Petero ahandire. ");
INSERT INTO hav_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Petero abeere ali aganiiza kw'okola kubonekerwa, Muuka-Mutagatiifu amubwira ntya: «Haliira hali balume basharhu bali bagushonda. ");
INSERT INTO hav_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Yandagala, onagende haguma nabo buzira kuganganwa, kwenge nyoono nye nabarhumaga.» ");
INSERT INTO hav_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Petero ava ayandagala n'okubwira aboola balume ntya: «Nyoono nye muli mwashonda. Bichi birhumire muli hanoola?» ");
INSERT INTO hav_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Baashubiza ntya: «Omukulu w'abasoda oyirikwa Korineliyo ye rhurhumire. Ali muntu okwaneene, oyuubaha Nnamahanga, n'aBayaahudi booshi bamuhamiiriza bwinja. Malahika Mutagatiifu amurhegekere oku rhukuleerhe emwage akuyunvirize.» ");
INSERT INTO hav_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Petero aja abayankirira omu nju, anabaha aha balaala. Bwacheere eseezi, Petero azuuka, anagenda haguma nabo. Abemeezi baguma b'eYopa bamuherekeza. ");
INSERT INTO hav_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Olusiku lwakulikiraga, baagera eKayizariya. Korineliyo aliiri abalinga eyi analaalikire emwage abantu b'omulala gwage, n'abeera baage b'oku murhima. ");
INSERT INTO hav_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Petero abeere ahika emwa Korineliyo, Korineliyo aja kumuyankirira, afukama, anayuunama embere zaage omu kumukuuza. ");
INSERT INTO hav_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Aliko Petero amuyimanza, anamubwira ntya: «Yimanga, kwenge naani ndi muntu kuguma naawe.» ");
INSERT INTO hav_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Petero aja omu nju haguma naye eyi bali baganiira, anabugaana mo abantu banene bachigushire. ");
INSERT INTO hav_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ababwira ntya: «Muyinji mwenyine okw'oMuyaahudi alahiizwe kugwarha obwira n'orhali Muyaahudi changwa okuja omu mwage. Aliko Nnamahanga anyerekere oku birhahemere ogurhoola omuntu nk'orhacheere changwa nk'arhakwaneene kuyegeerwa. ");
INSERT INTO hav_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Cho girhumire, egihe mwantumiraga abantu kunshonda, namayinja buzira kuganganwa. Mbahemere muje mwambwira bichi byarhumaga mwampamagala.» ");
INSERT INTO hav_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Korineliyo ashubiza ntya: «Hamaagera bunoola siku esharhu, naliiri nasaliira omu mwani, oku gihe nka kinoola ch'esaa mwenda. Ho n'aho omuntu oyambeere emyambalo eri yabaraganya ayimanga embere zaani. ");
INSERT INTO hav_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Aderha ntya: ‹Korineliyo, Nnamahanga ayunviirhe amasaala maawe, anayibukire oburhabaale bwawe oku bakene. ");
INSERT INTO hav_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Jaaga warhuma abantu eYopa, baje guhamagala Simooni washembulwaga Petero. Ahandire ahaburhambi bw'enyanja, omu nju ya Simooni muhanga w'ogukwiza empu.› ");
INSERT INTO hav_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ho n'aho nava nagurhumira abantu kugushonda, naawe wajirire bwinja okuyinja. Leero rhweshi rhuli hanoola mw'eno saa embere za Nnamahanga yi rhuyunva byooshi Nnaweerhu agurhegekere gurhubwira.» ");
INSERT INTO hav_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Petero aj'aderha ntya: «Okuli bunoola namaamenya oku Nnamahanga arhajira kalondoole. ");
INSERT INTO hav_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Aliko omu ngasi lubaga, ngasi yeeshi omuyuubaha n'okujira ebikwaneene, Nnamahanga anamuyankirira. ");
INSERT INTO hav_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Arhumaga echinwa oku Baisraheeli omu kubabalira oMwazi Mwinja gw'omurhuula kugerera Yeesu Krisitu. Yeewe ye Nnaweerhu w'abantu booshi. ");
INSERT INTO hav_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Mwewe, muyinji echizinda kuba omu Yudeeya yooshi gurhonderera eGalilaaya, enyuma za Yohaana kubala okw'abantu babatiizwe. ");
INSERT INTO hav_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Muyinji gurhe Nnamahanga agishogaga Yeesu w'eNazareeti gukola akaasi kaage, anamuha Muuka-Mutagatiifu n'obuhashe. Hooshi aliiri agera, aliiri ajira amenja n'ogufumya abantu booshi baliiri omu buja bwa Shetaani. Kwenge Nnamahanga aliiri haguma naye. ");
INSERT INTO hav_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Rhuli bahamiiriza ba byooshi ajiraga omu gihugo ch'aBayaahudi n'eYerusaleema. Olaala bayirhaga omu kumubamba oku musalaaba, ");
INSERT INTO hav_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","aliko Nnamahanga amufuulire olusiku lwa gasharhu. Amuyeerekana oku bantu, ");
INSERT INTO hav_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","arhali oku lubaga looshi, aliko oku bahamiiriza Nnamahanga abaaga agishogere, oku rhwewe rhwe rhwalyaaga, rhwananywa haguma naye enyuma w'ogufuuka kwage omu bafu. ");
INSERT INTO hav_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Arhurhegekere okubalira olubaga n'okuyeerekena oku yeewe ye Nnamahanga ajirire muzuuzi w'abazeene n'abafiire. ");
INSERT INTO hav_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Abaleebi booshi bamuha obuula buhamiiriza: ngasi yeeshi omuyemeera, ebyaaha byaage binababalirwa kugerera eziino lyaage.» ");
INSERT INTO hav_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Petero abeere achiri aderha ebyo binwa, Muuka-Mutagatiifu ayandagalira oku booshi baliiri babiyunviriza. ");
INSERT INTO hav_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Abemeezi booshi b'aBayaahudi bayinjaga haguma na Petero basoomerwa okubona abarhali Bayaahudi nabo bayandaazwa kw'empaano ya Muuka-Mutagatiifu. ");
INSERT INTO hav_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Kwenge baliiri babayunva baderha omu ndimi n'ogukuuza Nnamahanga. Petero aja aderha ntya: ");
INSERT INTO hav_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","«Abaala bantu bayankirire Muuka-Mutagatiifu kuguma neerhu. Ka hali omuntu wakabalahirira kubatiizibwa omu menji?» ");
INSERT INTO hav_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ava arhegeka oku babatiizwe oku ziino lya Yeesu Krisitu. Baaja bahema Petero abeere haguma nabo siku zigeeke. ");
INSERT INTO hav_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Entumwa n'abemeezi baliiri eYudeeya bayunva okw'abarhali Bayaahudi nabo bayankiriire eChinwa cha Nnamahanga. ");
INSERT INTO hav_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Amango Petero azamuukiraga eYerusaleema, abemeezi b'aBayaahudi bamurhonganya, ");
INSERT INTO hav_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","bamubwira ntya: «Ego muza we! Gurhe wajiire omu nju z'abarhali Bayaahudi wamanalya nabo!» ");
INSERT INTO hav_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Petero aja arhondera kubalira bo byooshi gurhe byalibeere. Ababwira ntya mwazi oku gwindi: ");
INSERT INTO hav_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","«Nyoono naliiri omu gishagala ch'eYopa. Oku ndi nasaliira, nabonekerwa: chintu chiguma chiri nka mwenda munene gifarhirwe hantu hane, chachima gurhengera omu chaalege, chayandagazwa emunda ndi. ");
INSERT INTO hav_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Nabeere nasuuzuma cho, nabona chiri mo enyama z'amagulu mane, enyama z'elubala, ezibululuka n'enyunyi zibalala omu chaalege. ");
INSERT INTO hav_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Nayunva omulenge gwambwira ntya: ‹Yimanga Petero, baaga, onalye.› ");
INSERT INTO hav_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Aliko nashubiza ntya: ‹Nangwa Nnaweerhu! Echintu girhacheesezwe girhanakwaneene kuliibwa girhashubiraga kuja omu buunu bwani!› ");
INSERT INTO hav_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Oku bwakabiri, omulenge gwashubiza ntya gurhengera empingu: ‹Echi Nnamahanga acheeseze, wooyo orhagirhoolaga oku girhakwaneene kuliibwa!› ");
INSERT INTO hav_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ebyoola byabeere byamajirika gasharhu, byooshi byaava byazamuulwa omu mpingu. ");
INSERT INTO hav_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Ho n'aho, bantu basharhu balintumiirwe gurhengera eKayizariya baahika omu nju rhwaliiri mo. ");
INSERT INTO hav_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Muuka-Mutagatiifu ambwira mpu ngende nabo buzira kuganganwa. Aba beerhu ndarhu mubwene, bali mperekeeze, rhwanaja omu nju y'omuntu oyirikwa Korineliyo. ");
INSERT INTO hav_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Oyoola Korineliyo arhubalira gurhe alibwene malahika ayimanga omu nju yaage n'okumubwira ntya: ‹Rhuma abantu eYopa baje gushonda Simooni washembulwaga Petero. ");
INSERT INTO hav_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Yeewe ye wakubwira ebinwa byakuleerhera obuchunguke, wooyo n'abantu b'omu nju yaawe booshi.› ");
INSERT INTO hav_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Nabeere narhondera kuderha, Muuka-Mutagatiifu ayandagalira oku bo nk'oku arhuyandagaliraga ko neerhu oku murhondero. ");
INSERT INTO hav_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Nava nayibuka echiila chinwa Nnaweerhu aderhaga ntya: ‹Yohaana abatiizaga omu menji, aliko mwabo nji mwabatiizwa na Muuka-Mutagatiifu.› ");
INSERT INTO hav_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Akaba leero Nnamahanga abaheere empaano nguma n'elaala arhuhaaga neerhu amango rhwayemeeraga Nnaweerhu Yeesu-Krisitu, naliiri nde, nyoono, mpu ngale kulwisa Nnamahanga?» ");
INSERT INTO hav_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Abemeezi b'aBayaahudi bamalire kuyunva ebyoola, barhuleera, banakuuza Nnamahanga n'oku derha ntya: «Gasi Nnamahanga aheere abarhali Bayaahudi nabo enjira y'okuleka ebyaaha byaabo yi baabona akalamo k'esiku n'amango!» ");
INSERT INTO hav_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Balaala bemeezi bashandaazwaga elugulu w'okuyirhwa kwa Sitefaano, baguma omu bo bagenda guhika omu gihugo ch'eFoyinikiya. Abandi baaja oku chizimba ch'eGipuro, n'abandi baahika omu gishagala ch'eAntiyokiya. Ntaaye bayigiriize eChinwa cha Nnamahanga arhali aBayaahudi bonyine. ");
INSERT INTO hav_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Aliko ahagarhi kaabo haaba bantu baguma b'eGipuro na ab'omu gishagala ch'eKureene bayinjaga eAntiyokiya, nabo baganiira n'abarhali Bayaahudi n'okubalira bo oMwazi Mwinja gwa Nnaweerhu Yeesu. ");
INSERT INTO hav_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Obuhashe bwa Nnaweerhu bwaliiri haguma nabo, n'abantu banene bahindamukira Nnaweerhu, baanaba bemeezi. ");
INSERT INTO hav_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Echigusho ch'abemeezi b'eYerusaleema babeere bayunva ogo mwazi, baarhuma Baranaaba agende eAntiyokiya. ");
INSERT INTO hav_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Abeere ahika yo, agishwa na Nnamahanga, asiima, n'okuyinginga abemeezi bagendekere guseera ku Nnaweerhu omu mirhima yaabo yooshi. ");
INSERT INTO hav_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Baranaaba aliiri muntu mwinja, oyunjwizwe Muuka-Mutagatiifu n'obwemeezi. Abantu banene bakulikira Nnaweerhu. ");
INSERT INTO hav_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Buzinda, Baranaaba aja eTariso gushonda Saawulo. ");
INSERT INTO hav_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Abeere amubona, amuheeka eAntiyokiya. Baranaaba na Saawulo bamala omwaka gooshi eyi bali bachigusha haguma n'echigusho ch'abemeezi. Banayigiriza abantu banene. Mw'echi gishagala ch'eAntiyokiya mw'abemeezi bahamagalwaga «Bakrisitu» oku burhanzi. ");
INSERT INTO hav_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Mwamo mango, baleebi baguma bachima gurhenga eYerusaleema kuja eAntiyokiya. ");
INSERT INTO hav_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Muguma omu bo, oyirikwa Hagabo, ayimanga n'ogurhondera kuleeba n'obuhashe bwa Muuka-Mutagatiifu okw'enzara nene yaaba omu gulu lyooshi. Eyo nzara yava yaaba amango mw'omwami mukulu Kuloode w'eRooma. ");
INSERT INTO hav_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Abemeezi b'eAntiyokiya baava bahiga gurhumira abemeezi bali balamire eYudeeya oburhabaale, ngasi muguma gukulikirana na okw'agalire. ");
INSERT INTO hav_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Baagusha esholoolo haguma, bayirhumira abashamuka b'echigusho ch'abemeezi b'eYerusaleema kulengera Baranaaba na Saawulo. ");
INSERT INTO hav_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Mw'amo mango, mwami Heroode arhondera kulibuza bantu baguma b'echigusho ch'abemeezi. ");
INSERT INTO hav_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Anayirha Yakobo mwene waabo Yohaana n'engoorho. ");
INSERT INTO hav_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Abeere abona okw'ebyo byasimiisize aBayaahudi, aderha oku bafarhe Petero naye. Ebyoola byajirikaga amango m'edinye y'emigati nzira chachu. ");
INSERT INTO hav_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Abeere amafarha Petero n'okumuhira omu munyororo, amuhira omu bulanzi bw'ebigusho bine by'abasoda baneebane eyi bali guhinguulirana. Ajira ntyo ey'ali gukengeera okw'amuburaniisa embere w'olubaga enyuma w'ePaasaka. ");
INSERT INTO hav_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Oku Petero alangirwe omu munyororo, echigusho ch'abemeezi boowe baliiri bakomeza kumusaliirira bweneene emwa Nnamahanga. ");
INSERT INTO hav_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Obudufu b'olo lusiku Heroode akaburanyize Petero, Petero alilyaamire ahagarhi k'abasoda babiri ey'anashwekerwe n'amalegule mabiri. N'abalanzi baliiri embere z'omulyango eyi bali balanga omunyororo. ");
INSERT INTO hav_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ho n'aho malahika wa Nnaweerhu ahulukira n'obumoleke bwayunjula omu busiika b'ogo munyororo. Malahika abanda ku Petero omu mbavu, amuchula n'okumubwira ntya: «Yimanga juba!» Amalegule malishwekere amaboko maage machishwekuula, marhogera ahashi. ");
INSERT INTO hav_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Malahika ava amubwira ntya: «Yambala omukaba gwawe n'ebiraato byaawe.» Naye ajira ntyo. Kandi, malahika amubwira ntya: «Yambala egorhe lyawe, onankulikire.» ");
INSERT INTO hav_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Petero ahuluka eyi anamukulikiire, aliko arhamenyaga kw'echijiro cha malahika chiri ch'okuli: alikengereere okw'abonekeerwe. ");
INSERT INTO hav_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Babeere bamarhaluka echigusho girhanzi ch'abalanzi n'echakabiri, baahika oku mulyango gw'echuuma guyerekeere omu gishagala. Ogo mulyango gwachichinguula gonyine embere zaabo. Nabo bahuluka n'ogukomeza kugenda omu njira. Ho n'aho oyo malahika amuleka. ");
INSERT INTO hav_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Petero abeere arhegeera okw'ebyabeere biri by'okuli, ava aderha ntya: «Bunoola namaaja naamenya oku Nnaweerhu arhumaga malahika waage, anankuulire omu maboko ma Heroode n'omu mabi mooshi aBayaahudi balilangaliire okw'ankolera.» ");
INSERT INTO hav_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Petero abeere amenya bwinja ebyabeere, agenda emwa Mariya, nyina wa Yohaana. Oyo Yohaana ye washembulwaga Mariko. Omu mwage mu bantu banene balichigushire n'ogusaliira Nnamahanga. ");
INSERT INTO hav_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Petero abeere akongoorha oku lunvi lw'embuga, omukozi muguma w'omunyere oyirikwa Rooda ayegeera omulyango kubaza nde oli akongoorha. ");
INSERT INTO hav_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Arhegeera omulenge gwa Petero, aliko ahaali h'okumuchinguulira, alibirha n'obushaguluke kuja kubwira abaabo oku Petero ali oku mulyango gw'embuga. ");
INSERT INTO hav_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Nabo bamubwira ntya: «Ego munyere! Wasirehere!» Aliko Rooda agendekera kuderha ntya: «Neechi, yeewe maani!» Boowe baliiri bakomeza kuderha ntya: «Oyoola, ali malahika waage.» ");
INSERT INTO hav_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Aliko Petero agendekera gukongoorha oku lunvi. Baava bachinguula, banasoomerwa bweneene kumubona. ");
INSERT INTO hav_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Abasimira n'okuboko mpu basire. Ababalira gurhe Nnaweerhu amukuulire omu munyororo n'okubabwira ntya: «Mubibalire Yakobo na beene beerhu.» Petero ava ahuluka n'okuja ahandi hantu. ");
INSERT INTO hav_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Bwacheere eseezi, abasoda bagwarha obuuba bunene n'okubazana ntya: «Bichi byahikiire Petero?» ");
INSERT INTO hav_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Heroode arhuma abantu mpu bamushonde, aliko barhamubonaga. Asambiisa abalanzi, anarhegeka oku bayirhwe. Oku buzinda, Heroode arhenga eYudeeya ayandagalira omu gishagala ch'eKayizariya gurhanga kubeera yo. ");
INSERT INTO hav_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Amo mango, haliiri obushombanyi ahagarhi ka Heroode n'abantu b'egishagala ch'eTiiro n'abe ch'eSidoona. Aliko, abo bantu bachihira haguma, baaja kumulola. Barhanga kuyunviikana na Balasito waliyimangiire enju ya mwami, baaja bahema omurhuula emwa mwami Heroode. Bulaala ebiryo bagendaga balya omu gihugo chaabo, byabaaga birhenga omu gihugo ch'oyo mwami. ");
INSERT INTO hav_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Olusiku bayunvikanaga lwabeere lwahika, Heroode ayambala emyambalo y'echaami, ayikala oku ntebe yaage y'obwami ekarubanda, arhondera kuderha embere z'abantu. ");
INSERT INTO hav_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","N'abantu nabo baalema baderha ntya n'omulenge munene: «Gurhali mulenge g'omuntu ogu, sy'aliko guli gw'emaana!» ");
INSERT INTO hav_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ho n'aho, malahika wa Nnaweerhu ahaana Heroode, bulaala arhakuuzaga Nnamahanga, sy'achikuuza yenyine. Enzoka z'omu nda zamuluma bweneene, ava afa. ");
INSERT INTO hav_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Aliko, eChinwa cha Nnamahanga chagendeerera kuja embere n'okuyandaala ahantu hanene. ");
INSERT INTO hav_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Baranaaba na Saawulo babeere bamaamala akaasi kaabo eYerusaleema, bagaluka eAntiyokiya eyi bali haguma na Yohaana washembulwaga Mariko. ");
INSERT INTO hav_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Omu chigusho ch'abemeezi b'eAntiyokiya, mwaliiri abaleebi n'abigiriza: Baranaaba, Simeooni oyirikwa Mwiragula, Lukiyo w'eKureene, Manaheni walembwaga haguma na mwami Heroode, na Saawulo. ");
INSERT INTO hav_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Lusiku luguma, oku bali baharamya Nnaweerhu n'oguchiibuza kulya, Muuka-Mutagatiifu aderha ntya: «Mumpirire eburhambi Baranaaba na Saawulo gukulikirana n'akaasi nabahamagaliire.» ");
INSERT INTO hav_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Bayuusize guchiibuza kulya, basaliira, babalambuulira kw'amaboko, banabarhuma bagende gukolera Nnamahanga. ");
INSERT INTO hav_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Muuka-Mutagatiifu abeere arhuma Baranaaba na Saawulo, bayandagalira omu gishagala ch'eSelukiya. Mw'echo gishagala, barhoola echombo, babalamira oku chizimba ch'eGipuro. ");
INSERT INTO hav_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Babeere baahika omu gishagala ch'eSalami, baabala omwazi gwa Nnamahanga omu masinagoogi m'aBayaahudi. Baliiri haguma na Yohaana oyirikwa Mariko nka murhabaazi waabo. ");
INSERT INTO hav_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Babeere bamazungula omu chizimba chooshi guhika omu gishagala ch'ePafo, babugaana mo mukurungu muguma w'oMuyaahudi. Oyoola mukurungu aliiri muleebi w'obubeeshi oyirikwa Bara-Yeesu. ");
INSERT INTO hav_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Aliiri murhabaazi wa Serugiyo Paawulo, munyabwenge na murhegesi w'eGipuro. Oyu murhegesi ahamagala Baranaaba na Saawulo baje emwage bulaala alishondere kuyunva eChinwa cha Nnamahanga. ");
INSERT INTO hav_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Aliko olaala mukurungu Bara-Yeesu, oyirikwa Elima omu Kigiriki, arhonganya Baranaaba na Saawulo, n'ogushonda kubuza oyo murhegesi arhayemeeraga Yeesu. ");
INSERT INTO hav_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Aliko Saawulo, oyirikwa kandi Paawulo, eyi ayunjwizwe Muuka-Mutagatiifu, ava amulola n'ameesho makalihire. ");
INSERT INTO hav_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Amubwira ntya: «Ego mugala wa Shetaani, mwanzi wa byooshi bikwaneene! Wooyo oyunjwire na ngasi buuko b'obulyaalya n'obubeeshi. K'orhaluha kulema walenganya oMwazi g'okuli gwa Nnaweerhu? ");
INSERT INTO hav_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Leero Nnaweerhu akola aguhana. Waaba mpumi, wanamala siku zilebe buzira kulola obumoleke bw'ezuuba.» Ho n'aho oluhomo n'omwizimya byaaja omu meesho maage. Arhondera kumamaarha omu gushonda omuntu w'okumufarha okuboko y'amuyeereka enjira. ");
INSERT INTO hav_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Ola murhegesi abeere abona ebyamajirika, asoomererwa enyigirizo za Nnaweerhu, anamuyemeera. ");
INSERT INTO hav_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Paawulo n'abaliiri nabo baaja omu chombo, barhenga ePafo, baaja omu gishagala ch'ePeriga omu gihugo ch'ePamfiliya. Babeere baagera yo, Yohaana oyirikwa Mariko abaleka, anagaluka eYerusaleema. ");
INSERT INTO hav_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Aliko boowe, Gurhengera ePeriga bakomeza olugenzi lwabo, banahika omu gishagala ch'eAntiyokiya omu gihugo ch'ePisidiya. Olusiku lw'eSaabato baaja omu sinagoogi, banayikala mo. ");
INSERT INTO hav_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Enyuma w'ogusomwa kw'ebitaabu by'eRhegeko na eby'abaleebi, abakulu b'esinagoogi babarhumira omuntu ababwire ntya: «Beene beerhu, akonva mugwerhe echinwa ch'ogukomeza abantu omurhima, mujage mwaderha.» ");
INSERT INTO hav_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Paawulo aja ayumanga, abasimira n'okuboko mpu basire, n'okubabwira ntya: «Munyunvirize, bantu b'eIsraheeli nenyu mwe bandi muyuubaha Nnamahanga! ");
INSERT INTO hav_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Nnamahanga w'olu lubaga lw'eIsraheeli, agishogere bashookuluza beerhu. Abajira kuba lubaga lunene amango balibungiire omu gihugo ch'eMiisiri. Buzinda abakuula yo omu buhashe bwage bunene. ");
INSERT INTO hav_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Aliiri kulembera engeso zaabo zibi amango baliiri omu mpinga hoofu myaaka makumi mane. ");
INSERT INTO hav_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Abeere amahima embaga mushanvu z'egihugo ch'eKanaana, abaheereza echo gihugo kuba gashambala kaabo. ");
INSERT INTO hav_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Ebyoola byooshi byamala hoofu myaaka magana mane na makumi marhaano. «Buzinda bw'aho, abaha abazuuzi, guhika oku muleebi Samweri. ");
INSERT INTO hav_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Oku buzinda bahema omwami. Nnamahanga abaha Saawulo, mugala wa Kiisi, w'omu buuko bwa Benjamina, abarhegeke myaaka makumi mane. ");
INSERT INTO hav_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Nnamahanga abeere amakuula Saawulo oku bwami, ayimika Daawudi. Oyu Daawudi ye Nnamahanga ahamiirizaga ko ntya: ‹Nabwene Daawudi, mugala wa Yeese, ali muntu omurhima gwani gusiimire; nj'ajira byooshi nshondere ajire.› ");
INSERT INTO hav_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Gurhengera omu mulala gw'oyo Daawudi mu Nnamahanga akuulaga Yeesu kuba Muchunguzi wa Israheeli, gukulikirana n'echilagaane chaage. ");
INSERT INTO hav_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Embere z'oguhika kwage, Yohaana abwira abantu b'olubaga looshi lw'eIsraheeli baleke ebyaaha, banabatiizwe. ");
INSERT INTO hav_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Amango Yohaana abeere akola hoofu kuyuusa omulimo gwage, aliiri aderha ntya: ‹Mukengereere oku nyoono ndi nde? Nyoono ntali oyo muli mwalinga! Aliko ayinjire enyuma zaani, eyi nyoono ntakwaneene chiro gushwekuula emigozi y'ebiraato byaage.› ");
INSERT INTO hav_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","«Beene beerhu, bantu b'omu mulala gwa Abrahaamu nenyu mweshi b'ezindi mbaga muyuubaha Nnamahanga, echi Chinwa ch'obuchunguke girhumirwe emwerhu. ");
INSERT INTO hav_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Kwenge aBanyayerusaleema n'abarhegesi baabo barharhegeeraga Yeesu ali nde. Barhamenyaga ebinwa by'abaleebi bisomwa ngasi lusiku lw'eSaabato. Aliko omu kumuhana baajira nka kulaala aMandiko mali maderhere. ");
INSERT INTO hav_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Buzira kubona echagarhumire ahanirwa ogufa, bahema Pilaato amuyirhe. ");
INSERT INTO hav_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Babeere baamala kujira byooshi byaliyandikirwe elugulu waage, bamuyandagaza oku musalaaba, banamuhira omu shinda. ");
INSERT INTO hav_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Aliko Nnamahanga amufuulire omu bafu. ");
INSERT INTO hav_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Abonekeene siku zinene oku bantu bazamuukaga naye gurhenga eGalilaaya kuja eYerusaleema, na bunoola, bo bali bahamiiriza baage oku lubaga lw'eIsraheeli. ");
INSERT INTO hav_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Neerhu, rhubabaliire ogu Mwazi Mwinja, oku echilagaane Nnamahanga ahaaga bashookuluza beerhu, ");
INSERT INTO hav_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","arhujiriire cho rhwe baana baabo, omu gufuula Yeesu. Ogu mwazi guyandikirwe ntya omu chigabi cha kabiri ch'eNanga: ‹Wooyo oli Mugala waani, Nyoono nye nkuburhire zeene.› ");
INSERT INTO hav_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","N'elugulu w'ogufuuka kwa Yeesu, y'arhabola, Nnamahanga aderha ntya: ‹Naguha emigisho ntagatiifu nalaganyaga Daawudi, emigisho y'okuli.› ");
INSERT INTO hav_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Cho girhumire aderhere ntya omu chindi chigabi ch'aMandiko Matagatiifu: ‹Orhaaleka oMutagatiifu waawe abole.› ");
INSERT INTO hav_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Daawudi yeewe, abeere amamala gukola gukulikirana n'oku Nnamahanga alirheganyize omu kalamo kaage, afa. Ahambwa ahaburhambi bw'eshinda za b'esheekuluza, anabola. ");
INSERT INTO hav_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Aliko olaala Nnamahanga afuulaga, yeewe arhabolaga. ");
INSERT INTO hav_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","«Beene beerhu, mukwaneene kumenya oku kugerera yeewe, omwazi g'obubabale bw'ebyaaha gwabalirwe emwenyu. Kugerera oyu Yeesu, ngaasi yeeshi omuyemeerere ababalirwa ebyaaha, aliko murhakababalirwe kugerera amarhegeko ma Muusa. ");
INSERT INTO hav_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Boboola muchilange y'ebiyandikirwe ntya omu bitaabu by'abaleebi birhabahikira: ");
INSERT INTO hav_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‹Mulole, mwe mugwerhe agakeno, musoomerwe munahirime, kwenge nyoono, najira ekijiro omu gihe chenyu, ekijiro murhakayemereere nachiro akaba bakababwirire cho.›» ");
INSERT INTO hav_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Paawulo na Baranaaba babeere bahuluka omu sinagoogi, abantu babayinginga bashube kuyinja kubabalira eyo myaazi olusiku lw'eSaabato yakulikira. ");
INSERT INTO hav_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Enyuma z'enshimaanano, aBayaahudi banene n'abandi bantu b'ezindi mbaga bayemeeraga edini ly'ekiyaahudi n'ogukuuza Nnamahanga, bakulikira Paawulo na Baranaaba. Abo bombi baganiira haguma n'abo bantu, banagendekera gukomeza bo, yi barhaleka guseera omu lukogo lwa Nnamahanga. ");
INSERT INTO hav_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Olusiku lw'eSaabato yakulikiraga, hoofu abantu booshi b'egishagala bachigusha haguma kuyunva eChinwa cha Nnaweerhu. ");
INSERT INTO hav_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","aBayaahudi babeere baabona echo chigusho ch'abantu, bafarhwa n'obongwa bunene. Balahira ebinwa bya Paawulo, banamuhamiiriza obubeeshi. ");
INSERT INTO hav_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Paawulo na Baranaaba baaja bababwira ntya buzira buuba: «Byaliiri bya bulagiirire mwabo mwe murhangage mubalirwe eChinwa cha Nnamahanga. Aliko oboola yi mwalahira cho, munali mwachiganja nka mwabo murhakwaneene akalamo k'esiku n'amango, rhwabo rhwayerekera emwa b'abarhali Bayaahudi. ");
INSERT INTO hav_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Kwenge Nnaweerhu arhurhegekere ntya: ‹Nakujirire bumoleke bw'abarhali Bayaahudi, y'oheeka obuchunguke omu gulu lyooshi.›» ");
INSERT INTO hav_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Abarhali Bayaahudi babeere bayunva eyo myaazi, bamoga. Bakuuza eChinwa cha Nnaweerhu. Na booshi balirheganyizwe akalamo k'esiku n'amango bayemeera Yeesu. ");
INSERT INTO hav_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Echinwa cha Nnaweerhu chagenda chayandaala omu gihugo chooshi. ");
INSERT INTO hav_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Aliko aBayaahudi bayoohya abakazi bakengerwe, banasiima guharamya Nnamahanga, haguma n'abashamuka b'egishagala. Barhondera kulibuza Paawulo na Baranaaba, banabalibisya omu gihugo chaabo. ");
INSERT INTO hav_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Paawulo na Baranaaba babakungurhira k'olujuchu lw'oku magulu maabo, banachijiira omu gishagala ch'eIkoniyo. ");
INSERT INTO hav_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Aliko abemeezi boowe baliyunjwire obushagaluke n'oMuuka-Mutagatiifu. ");
INSERT INTO hav_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Babeere bali eIkoniyo, Paawulo na Baranaaba, baja omu sinagoogi y'aBayaahudi nk'oku bazigaanaga. Bayigiriza, oku bulyo aBayaahudi n'aBagiriki banene bahinduka bemeezi. ");
INSERT INTO hav_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Aliko aBayaahudi barhayemeeraga Krisitu, bayoohya abarhali Bayaahudi mpu bashombe abemeezi. ");
INSERT INTO hav_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Aliko, Paawulo na Baranaaba bajira siku zinene eIkoniyo. Baliiri bayigiriza elugulu wa Nnaweerhu buzira buuba. Na Nnaweerhu naye aliiri abagaliisa kujira ebimenyeeso n'ebigiriginjo, omu guhamiiriza okw'omwazi gwage g'olukogo guli g'okuli. ");
INSERT INTO hav_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Omu gishagala che Ikoniyo, abantu bachigaba kabiri. Baguma baaja oku lunda lw'aBayaahudi, n'abandi oku lunda lw'eNtumwa. ");
INSERT INTO hav_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Aliko, aBayaahudi n'abarhali Bayaahudi haguma n'abarhegesi baabo, baaja kaligi kw'okulibuza n'okuyirha Paawulo na Baranaaba omu kubabanda amabaale. ");
INSERT INTO hav_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Nabo babeere babimenya, balibirhira omu bishagala by'eLisitira n'eDerebe, by'omu gihugo ch'eLikaoniya; n'omu hantu hatureene byo. ");
INSERT INTO hav_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Eyoola munda, bagendekera kubala oMwazi Mwinja. ");
INSERT INTO hav_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Omu gishagala ch'eLisitira, haliiri muntu muguma w'echirema. Arhalambagiraga chiro n'olusiku luguma, bulaala aburhwaga eyi ali chirema ch'amagulu. ");
INSERT INTO hav_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Lusiku luguma, ey'ayikeere, ayunviriza enyigirizo za Paawulo. Paawulo amulolereza n'okubona okw'agwerhe obwemeezi bwagarhuma afumiiswa. ");
INSERT INTO hav_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Ava amubwira ntya n'omulenge munene: «Yuumuka, yimangira oku magulu maawe!» Oyo muntu ayimanga ho n'aho, anarhondera kulambagira. ");
INSERT INTO hav_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Abantu banene balichigushire, babeere baabona ebi Paawulo ajirire, baliika omulenge n'okuderha ntya omu lulimi lw'eKilikaoniya: «Emaana zachihindwire nk'abantu, zanayandagaliire eno mwerhu!» ");
INSERT INTO hav_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Baliiri bayirika Baranaaba eziino ly'emaana Zeusi, Paawulo naye bamuyirika eziino ly'emaana Herime, kwenge ye waliiri w'okuderha. ");
INSERT INTO hav_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Omudaahwa w'omu kajumiro k'emaana Zeusi kaliiri embere z'egishagala, aleerha oku milyango y'egishagala empanzi n'emikalaba elukiirwe k'obwaso. Abileerhaga bulaala yeewe haguma n'echo chigusho ch'abantu balishondere gurhuula entuulo. ");
INSERT INTO hav_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Aliko Baranaaba na Paawulo babeere bayunva ogo mwazi, babera emishangi yaabo omu kuyeerekana oku bagayire, n'okuva balibirha omu bantu eyi bali baderha ntya n'omulenge munene: ");
INSERT INTO hav_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","«Beera baani, gichi girhumire mwajira ntyo? Neerhu, rhuli bantu kuguma nenyu! Akaba yi rhwababalira oMwazi Mwinja, kuli gushonda muleke ebi bintu bya bushaabusha, munahindamukire Nnamahanga olamire. Yeewe ye walemaga echaalege, egulu n'enyanja, na byooshi biri omu byo. ");
INSERT INTO hav_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Omu siku zageraga, Nnamahaanga alilekere abarhali Bayaahudi booshi bakulikiire enjira zaabo. ");
INSERT INTO hav_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Nachiro ntyo, arhalekaga guchihamiiriza kugerera ebijiro binja. Abaha mwabo gurhengera omu chaalege envula n'ebihe biyeeza, anabayuugusya ebiryo n'okuyunjuza emirhima yenyu n'obushagaluke bunene.» ");
INSERT INTO hav_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Nachiro mpu Paawulo na Baranaaba baliderhere ebiila byooshi, birhali biyoolohere kubuza abantu barharhuuliraga bo entuulo. ");
INSERT INTO hav_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Enyuma w'ebyoola, aBayaahudi baguma baahika gurhengera omu gishagala ch'eAntiyokiya n'eche Ikoniyo. Bayoohya abantu, babanda Paawulo amabaale, banamukululira embuga w'egishagala eyi bakengereere okw'afiire. ");
INSERT INTO hav_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Aliko abemeezi babeere bamugorha, ayuumuka, agaluka mw'echo gishagala ch'eLisitira. Olusiku lwakulikiraga, aja omu gishagala ch'eDerebe haguma na Baranaaba. ");
INSERT INTO hav_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Oku bali eDerebe, baalema baabala oMwazi Mwinja, abantu banene bayemeera Yeesu. Buzinda, bagaluka, baaja eLisitira, eIkoniyo n'eAntiyokiya y'ePisidiya. ");
INSERT INTO hav_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Eyo munda, baliiri bakomeza abemeezi omurhima n'okubahanuula baseere omu bwemeezi. Baliiri bababwira ntya: «Rhukwaneene kugera omu malibuko manene yi rhuja omu Bwami bwa Nnamahanga.» ");
INSERT INTO hav_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","N'omu ngasi chigusho ch'abemeezi, Paawulo na Baranaaba bachishoga mo abashamuka b'okubiyimangira. Babeere bamasaliira n'oguchiibuza kulya, babahira omu maboko ma Nnaweerhu, ye bali bayemereere. ");
INSERT INTO hav_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Enyuma z'aho, bagerera omu gihugo ch'ePisidiya, banahika omu ch'ePamfiliya. ");
INSERT INTO hav_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Bamalire kuyigiriza eChinwa cha Nnamahanga oku bantu b'omu gishagala ch'ePeriga, bachimira omu siiko y'eAtaliya. ");
INSERT INTO hav_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Gurhengera eyoola, basuuka n'echombo kuja eAntiyokiya y'eSuriya. Eyoola yi bahemeraga bo omugisho gwa Nnamahanga kw'aka kaasi bamakola. ");
INSERT INTO hav_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Babeere baahika, bagusha echigusho ch'abemeezi, banashambaalira bo byooshi Nnamahanga ali ajirire haguma nabo, na gurhe achinguuliraga abarhali Bayaahudi omulyango g'obwemeezi. ");
INSERT INTO hav_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Paawulo na Baranaaba babeera eyoola siku zinene haguma n'abemeezi. ");
INSERT INTO hav_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Mw'ezoola siku, bantu baguma bachimira eAntiyokiya gurhengera eYudeeya. Barhondera kuyigiriza abemeezi ntya: «Akaba murhakembwirwe gukulikirana n'emigenzo ya Muusa, murhagachungulwa.» ");
INSERT INTO hav_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Paawulo na Baranaaba babalahirira, banajira obuhaka bunene haguma nabo elugulu w'oguula mwazi. Abemeezi baahiga oku Paawulo na Baranaaba haguma n'abandi baguma omu bo bazamukire eYerusaleema kuganiira kw'echo chibazo embere z'eNtumwa n'abashamuka b'echigusho ch'abemeezi. ");
INSERT INTO hav_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Echigusho ch'abemeezi chabaheereza ebintu byooshi by'olugenzi balilagire ko. Baagera omu gihugo ch'eFoyinikiya na ech'eSamariya, baliiri baabala gurhe abarhali Bayaahudi bayemereere kuba bemeezi. Ogu mwazi gwaliiri gwasimiisa bweneene abemeezi booshi. ");
INSERT INTO hav_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Bahikire eYerusaleema, bayankirirwa n'eNtumwa, n'echigusho ch'abemeezi haguma n'abashamuka baacho. Babala byooshi Nnamahanga ajirire kugerera bo. ");
INSERT INTO hav_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Aliko, bantu baguma b'omu chigusho ch'aBafarisaayo bahindukaga bemeezi, bayimanga n'okuderha ntya: «Bihemere gukembuula abarhali Bayaahudi n'okubarhegeka ogukenga eRhegeko lya Muusa.» ");
INSERT INTO hav_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Entumwa n'abashamuka b'echigusho ch'abemeezi bajira enaama elugulu w'echo chibazo. ");
INSERT INTO hav_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Enyuma z'obuhaka bunene, Petero ayimanga n'okubabwira ntya: «Beene beerhu, muyinji bwinja oku gurhengera miira Nnamahanga andondwere ahagarhi kenyu yi kugerera obuunu bwani, abarhali Bayaahudi bayunve oMwazi Mwinja, banayemeere Yeesu. ");
INSERT INTO hav_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Na Nnamahanga oyinji emirhima y'abantu, aliyerekeene oku ayemereere abarhali Bayaahudi nabo omu guha bo Muuka-Mutagatiifu kuguma neerhu. ");
INSERT INTO hav_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Nta kalondoole ajirire ahagarhi keerhu nabo, bulaala acheeseze emirhima yaabo kugerera obwemeezi. ");
INSERT INTO hav_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Chagarhuma bunoola mwageregeza Nnamahanga omu guheesa abemeezi ogu muzigo, abe bashookuluza beerhu, abe neerhu rhwenyine rhurhagalaga guheeka? ");
INSERT INTO hav_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Maani neerhu, rhuyinji oku rhwachungwirwe elugulu w'olukogo lwa Nnaweerhu Yeesu, nk'oku nabo bachungwirwe.» ");
INSERT INTO hav_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Abantu booshi balichigushire baasira. Bayunviriza oku Paawulo na Baranaaba baabala emyaazi elugulu w'ebimenyeeso n'ebigiriginjo byooshi Nnamahanga ajirire kugerera bo ahagarhi k'abarhali Bayaahudi. ");
INSERT INTO hav_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Babeere baasira, Yakobo naye aderha ntya: «Beene beerhu, munyunvirize! ");
INSERT INTO hav_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simooni Petero arhubaliire gurhe Nnamahanga achiyerekeene oku barhali Bayaahudi oku burhanzi y'achishoga baguma omu bo babe bantu baage. ");
INSERT INTO hav_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Eyi myaazi eri kuguma n'ebinwa by'abaleebi nk'okubiyandikirwe ntya: ");
INSERT INTO hav_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‹Buzinda bw'aho, nji naagaluka n'ogushuba kuyumbaka enju ya Daawudi yashandeere. Nji nashuba kuyumbaka ebiguuka byaayo n'okuyiyumanza, ");
INSERT INTO hav_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","y'abandi bantu booshi bashonde Nnaweerhu, neechi, abantu b'embaga zooshi nahamageere babe baani. Ntyo ku Nnaweerhu aderhere, yi wajiraga ebyo bintu ");
INSERT INTO hav_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","biyinjikeene gurhengera miira.› ");
INSERT INTO hav_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Cho girhumire, nyoono, mbwene oku rhurhalibuzaga abarhali Bayaahudi bali bayemeera Nnamahanga. ");
INSERT INTO hav_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Aliko, rhubayandikire oku barhalyaaga ebiryo byarhuulirwaga emaana, banachilange n'obuhushi. Barhanalemaga baalya enyama zakanulwaga changwa omulegano. ");
INSERT INTO hav_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Bulaala gurhengera miira, eRhegeko lya Muusa linayigirizwa omu ngasi gishagala, linasomwa omu masinagoogi m'aBayaahudi ngasi lusiku lw'eSaabato.» ");
INSERT INTO hav_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Enyuma z'aho, eNtumwa, abashamuka n'echigusho chooshi ch'abemeezi ch'eYerusaleema, babona oku bakwaneene bachishoge ahagarhi kaabo bantu baguma, banabarhume eAntiyokiya haguma na Paawulo na Baranaaba. Baava bagishoga Yuuda oyirikwa kandi Barisaba na Siila. Abo bantu oku bali babiri balikengerwe bweneene embere z'abaabo bemeezi. ");
INSERT INTO hav_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Babarhuma n'amaruba maliyandikirwe mo ntya: «Rhwabo, eNtumwa n'abashamuka b'echigusho ch'abemeezi, rhwabo benyu bemeezi, rhwabalamwise mwabo bemeezi murhali Bayaahudi muli omu gishagala ch'eAntiyokiya, n'omu gihugo ch'eSuriya na ech'eKilikiya. ");
INSERT INTO hav_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Rhwayunviirhe oku bantu baguma barhengeraga eno mwerhu, bababwirire emyaazi y'okubalibuza n'okubahahaaza emirhima. Aliko rhurhabarhumaga. ");
INSERT INTO hav_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Boboola, oku rhuli rhweshi haguma, rhwayunvikeene gugishoga bantu baguma, rhwamabarhuma emwenyu, bayinje haguma n'abazigirwa beerhu Baranaaba na Paawulo. ");
INSERT INTO hav_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Abo bombi, bayemereere guhaana akalamo kaabo omu gukolera Nnaweerhu Yeesu Krisitu. ");
INSERT INTO hav_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Ntyo ku rhwamabarhumira Yuuda na Siila. Nabo, bababwira buunu oku bwindi ebinwa rhubayandikiire. ");
INSERT INTO hav_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Kandi, kuli kwinja emwa Muuka-Mutagatiifu n'emwerhu ogurhabahekesa ogwindi muzigo kuleka ebiri by'akamaro: ");
INSERT INTO hav_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","murhalyaaga enyama barhuuliraga emaana n'omulegano changwa enyama zakanulwaga, munachilange n'obuhushi. Mugachilanga kw'ebi, mwaba mwajirire bwinja. Buchaage!» ");
INSERT INTO hav_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Bamalire guseezerana, abo barhumagwa bagenda n'okuyandagalira eAntiyokiya. Bagerere eyo, bagusha abemeezi booshi, banabahereza amo maruba. ");
INSERT INTO hav_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Nabo, babeere bamamasoma, basiima elugulu w'ebinwa by'okubaseeza omurhima byabaaga biyandikirwe mo. ");
INSERT INTO hav_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Gukulikirana n'oku Yuuda na Siila baliiri baleebi, babwira abaabo bemeezi binwa binene by'okubaseeza omurhima n'okubakomeza. ");
INSERT INTO hav_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Babeere bamamala yo siku, abemeezi babaseezera, banababwira bagaluke n'obuholo yi bashigaane ababarhumaga. ");
INSERT INTO hav_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Aliko Siila yeewe abona bwinja ayoorhe eyo munda. ");
INSERT INTO hav_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Paawulo na Baranaaba nabo bayoorha eyo Antiyokiya. Boowe haguma n'abandi bantu banene, baalema bayigiriza n'okuyamagaza oMwazi Mwinja guyerekeere Nnaweerhu. ");
INSERT INTO hav_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Enyuma w'esiku zigeeke, Paawulo abwira Baranaaba ntya: «Rhugaluke rhuje kulola beene beerhu bemeezi omu bishagala byooshi rhwayigirizaga m'oMwazi gwa Nnaweerhu, rhumenye gurhe yi baalama.» ");
INSERT INTO hav_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Baranaaba alishondere Yohaana oyirikwa Mariko agende haguma nabo. ");
INSERT INTO hav_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Aliko Paawulo abona oku birhakwiriire, kwenge Mariko abaaga abalekere omu gihugo ch'ePamfiliya, analilahiire kugendekeza gukola haguma nabo. ");
INSERT INTO hav_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Haja haahulukira obuhaka bunene bwarhuma balekana. Baranaaba agenda aherekezwe na Mariko, baja omu chombo, bayambukira oku chizimba ch'eGipuro. ");
INSERT INTO hav_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Paawulo achishoga Siila. Abemeezi bamalire kumuhemera olukogo lwa Nnaweerhu, agenda. ");
INSERT INTO hav_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Agerera omu gihugo ch'eSuriya n'eche Kilikiya ey'ali akomeza ebigusho by'abemeezi. ");
INSERT INTO hav_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Paawulo ahika omu gishagala ch'eDerebe n'eche Lisitira. Eyo munda yaliiri omwemeezi muguma oyirikwa Timoteyo. Nyina aliiri Muyaahudi-kazi oyemeerere Yeesu, n'eshe aliiri Mugiriki. ");
INSERT INTO hav_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Abemeezi b'egishala ch'eLisitira n'eche Ikoniyo baliiri bahamiiriza bwinja oyo Timoteyo. ");
INSERT INTO hav_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paawulo alishondere Timoteyo amuherekeze. Aliko, aBayaahudi balilamire eyo munda, booshi baliyinji okw'eshe aliiri Mugiriki. Charhuma Paawulo amukembuula yi bamuyemeera. ");
INSERT INTO hav_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Omu bishagala baliiri balenga mo, baalema baabalira abemeezi amarhegeko eNtumwa n'abashamuka b'echigusho ch'abemeezi b'eYerusaleema bahaaga bo n'okubahema bamakulikire. ");
INSERT INTO hav_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Na ntyo, ebigusho by'abemeezi byakomera omu bwemeezi n'oluganjo lw'abemeezi lwagendekera kuyuushuka ngasi lusiku. ");
INSERT INTO hav_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Paawulo n'abalimuherekeeze baagera omu gihugo ch'eFurigiya na ech'eGalatiya bulaala Muuka-Mutagatiifu alibabuzize kubala eChinwa cha Nnamahanga omu gihugo ch'eAziya. ");
INSERT INTO hav_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Babeere baahika hoofu n'egihugo ch'eMisiya bahiga kuja omu gihugo ch'eBitiniya, aliko Muuka gwa Yeesu arhabayemeereraga. ");
INSERT INTO hav_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Baaja baagera eburhambi bw'eMisiya, bayandagalira omu gishagala ch'eTorowa. ");
INSERT INTO hav_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Omu budufu, Paawulo abonekerwa. Abona mulume muguma w'eMakedoniya waliyimangire embere zage, amuyinginga ntya: «Oyambukire eMakedoniya, oyinje orhurhabaale.» ");
INSERT INTO hav_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Ho n'aho, enyuma z'okoola kubonekerwa, rhwachirheganya kuja eMakedoniya, bulaala rhwalibwene oku Nnamahanga arhuhamageere kubala eyoola munda oMwazi Mwinja. ");
INSERT INTO hav_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Gurhenga eTorowa rhwabalama n'echombo, rhwabera omuhengere kuja eSamotirake. Olusiku lwakulikiraga, rhwahika eNeyapoli. ");
INSERT INTO hav_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Rhwarhenga eNeyapoli, rhwahika eFiripi, gishagala gikulu ch'egihugo ch'eMakedoniya. Echo gishagala chaliiri omu buja bw'aBarooma. Rhwabeera mo siku zigeeke. ");
INSERT INTO hav_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Olusiku lw'eSaabato, rhwarhenga mw'echo gishagala, rhwaja hoofu n'olwinji, bulaala rhwalikengerere oku ho hantu hajirirwa amasaala. Rhwabere rhwahika, rhwayikala n'ogushambala n'abakazi baliiri bachigushire ho. ");
INSERT INTO hav_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Muguma mubo, oyirikwa Ludiya, aliiri murhimbuuzi w'ebiraka bidukula by'agachiiro. Aliiri w'egishagala ch'eTuwatera, analemaga aharamya Nnamahanga. Aliiri ayunviriza, na Nnaweerhu amuheereza omurhima g'ogukulikira oMwazi Mwinja Paawulo aliiri aderha. ");
INSERT INTO hav_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Ludiya abeere amabatiizwa haguma n'abantu bw'omu mwage, arhulaalika omu kuderha ntya: «Akaba mubwene oku nyemereere Nnaweerhu, muyinje emwani munahande yo.» Arhuseeza rhuyemeere. ");
INSERT INTO hav_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Lusiku luguma, rhwabeere rhulirhwaja ahantu ha masaala, rhwabugaanana n'omukozi w'omunyere. Oyo mukozi aligwerhe omuzimu w'obulaguzi. N'elugulu w'oboola bulaguzi alemaga achiza bannahamwabo. ");
INSERT INTO hav_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Arhukulikira, rhwabo na Paawulo. Aliiri ayamuuza ntya: «Aba bantu bali baja ba Nnamahanga w'Elugulu Bweneene. Bali babashambaalira enjira y'obuchunguke.» ");
INSERT INTO hav_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Alema ajira ntyo siku zinene. Paawulo agwarha oburhe elugulu waage, ahindamuka n'okubwira oyo muzimu ntya: «Ngurhegekere oku ziino lya Yeesu Krisitu, orhenge mw'oyu munyere!» Ho n'aho oyo muzimu amurhenga mo. ");
INSERT INTO hav_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Bannahamwabo oyo mukozi w'omunyere babeere baabona okw'obulangaalire b'obuchire bwamahwa oku ye, bafarha Paawulo na Siila, babakululira omu kabuga embere z'abarhegesi b'egishagala. ");
INSERT INTO hav_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Babeere bahisa bo embere z'abo barhegesi, baderha ntya: «Aba bantu bali Bayaahudi, yi bararusa abantu omu gishagala cheerhu. ");
INSERT INTO hav_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Yi bayigiriza emicho rhwe Barooma rhulahiizwe kuyemeera changwa gukulikira.» ");
INSERT INTO hav_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Echigusho ch'abantu nacho chagwira oku bo. Abazuuzi b'egishagala barhegeka oku babakuule emyambalo n'okubashurha enkoni. ");
INSERT INTO hav_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Enyuma z'okubashuurha bweneene, babahira omu munyororo n'ogurhegeka okw'omulanzi abalange bwinja. ");
INSERT INTO hav_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Babeere bamamurhegeka ntyo, oyo mulanzi abahira omu busiika b'omunyororo n'ogushwekera amagulu maabo oku bihirho by'emirhi. ");
INSERT INTO hav_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Ahagarhi kw'obudufu, Paawulo na Siila baliiri basaliira n'okuyimpa enyimpo z'obukuuze emwa Nnamahanga. N'abandi balishwekerwe baliiri babayunva. ");
INSERT INTO hav_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Ho n'aho haaba omusisi gunene, gwadirhimanya enkingi z'omunyororo. Emilyango yooshi yava yagichinguula n'amalegule mooshi maliiri mabashwekere magishwekuula. ");
INSERT INTO hav_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Omulanzi abeere amazuuka, abona emilyango echingwirwe, ahulusa engoorho yaage omu luhugurhu mpu achiyirhe, bulaala alikengereere oku abaliiri omu munyororo balibirhire. ");
INSERT INTO hav_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Aliko Paawulo ayaama bweneene n'okumubwira ntya: «Orhachiyirhaga, bulaala rhweshi rhuli hano!» ");
INSERT INTO hav_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Oyo mulanzi ahema bamulerhere echimole. Ho n'aho achikabula omu munyororo n'okugwa embere za Paawulo na Siila, eyi ali adirhimana. ");
INSERT INTO hav_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Buzinda, abaheeka embuga anababaza ntya: «Bannaweerhu, bichi nkwaneene kujira yi nchunguka?» ");
INSERT INTO hav_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Bamushubiza ntya: «Oyemeere Nnaweerhu Yeesu na ntyo wachungulwa, wooyo n'abantu booshi b'omu mwawe.» ");
INSERT INTO hav_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Bamubalira eChinwa cha Nnaweerhu haguma n'abantu b'omu mwage booshi. ");
INSERT INTO hav_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Mw'obo budufu, oyo mulanzi arhoola Paawulo na Siila, abashuka ebihulu. Ho n'aho anabatiizwa, yeewe n'abantu baage booshi. ");
INSERT INTO hav_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Abeere abaheeka omu mwage, abasheegera. Anasiima bweneene haguma n'abantu bw'omu mwage, kwenge bayemereere Nnamahanga. ");
INSERT INTO hav_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Bwabeere bwacha, abazuuzi b'egishagala barhumira oyo mulanzi abasoda baabo mpu: «Alikuule abo bantu.» ");
INSERT INTO hav_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Oyo mulanzi abalira Paawulo eyo myaazi n'okuderha ntya: «Abazuuzi baderhere oku mushwekuulwe, boboola muhuluke, munagende n'omurhuula.» ");
INSERT INTO hav_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Aliko Paawulo abwira abo basooda ntya: «Enyuma z'ogurhushuurhira omu kabuga buzira gurhuchiira olushinja noobo rhuli Barooma, oku buzinda bamarhukabula omu munyororo. Leero gurhe bashonda gurhushwekuula omu bwibisho? Birhagalikeene! Bahike bonyine gurhushwekuula!» ");
INSERT INTO hav_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Abo basooda bagaluka n'okubalira abazuuzi b'egishagala ogo mwazi. Babeere bayunva oku Paawulo na Siila baali Barooma, bayuubaha bweneene. ");
INSERT INTO hav_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Okoola kwarhuma baaja kubarhebereza, banabaheeka embuga y'omunyororo n'oku bahema barhenge mw'echo gishagala. ");
INSERT INTO hav_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Babeere bamarhenga omu munyororo, baaja emwa Ludiya. Enyuma z'okubonana n'abemeezi n'okubakomeza omurhima, bagenda. ");
INSERT INTO hav_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Paawulo na Siila babeere bagendekera n'olugenzi lwabo, balenga omu gishagala ch'eAmfipoli na ech'eApoloniya, banahika omu ch'eTesalonika. Eyoola yaliiri esinagoogi y'aBayaahudi. ");
INSERT INTO hav_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Paawulo aja mw'eyo sinagoogi gukulikirana n'oku akoomeraga. Omu Saabato esharhu zikulikireene, ashambaala n'abantu elugulu w'aMandiko Matagatiifu. ");
INSERT INTO hav_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Abalira bo anabayereka oku Krisitu alikwaneene kulibuka n'ogufuuka ahagarhi k'abaafu. Aliiri ababwira ntya: «Oyu Yeesu ndi nabashambaalira ye Krisitu.» ");
INSERT INTO hav_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Baguma mw'abo Bayaahudi bayemeera, baaja oku lunda lwa Paawulo na Siila. N'aBagiriki banene balemaga baharamya Nnamahanga haguma n'abakazi banene bw'olukengo, nabo bayemeera. ");
INSERT INTO hav_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Aliko Bayaahudi baguma bayongwa. Bahamagala bishumuusi biguma byaliiri omu soko, byagusha abantu banene omu gishagala omu gushonda kubararusa. Baja emwa Yasoni gushonda Paawulo na Siila mpu babaheke embere z'abantu. ");
INSERT INTO hav_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Babeere babula bo, bakululira Yasoni n'abemeezi baguma embere za barhegesi b'egishala. Baderha n'omulenge munene ntya: «Abaala, bo baliiri bararusa abantu omu gulu lyooshi, leero bahikire hanoola naho. ");
INSERT INTO hav_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Oyu Yasoni abayankirire emwage. Booshi barhali bakulikira amarhegeko m'omwami mukulu Kayizaari, omu kuderha oku hali windi mwami mpu ye Yeesu.» ");
INSERT INTO hav_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Abarhegesi b'egishagala haguma n'olubaga babeere bayunva eyo myaazi, bahahaala. ");
INSERT INTO hav_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Babaseeza, Yasoni n'abaabo bahane egikinja ch'efuranga oku barhachirarusa abantu, balikula bo bagenda. ");
INSERT INTO hav_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Bwabeere bwaba budufu, abemeezi baava babwira Paawulo na Siila bagende omu gishagala ch'eBeroya. Babeere baahika yo, baja omu sinagoogi y'aBayaahudi. ");
INSERT INTO hav_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Abantu b'eBeroya baliyemereere kuyunviriza eChinwa cha Nnamahanga kulusha ab'eTesalonika. Baliyankirire cho n'obushiru. Ngasi lusiku balemaga basoma aMandiko Matagatiifu omu kulola akonva ebi Paawulo aliiri aderha byaliiri by'okuli. ");
INSERT INTO hav_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","aBayaahudi banene ahagarhi kaabo haguma n'aBagiriki, bayemeera Yeesu. Mw'abo Bagiriki, mwaliiri abakazi bw'olukengo n'abalume banene. ");
INSERT INTO hav_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Aliko aBayaahudi b'eTesalonika babeere bayunva oku Paawulo y'abala eChinwa cha Nnamahanga eBeroya nayo, baaja yo gurarusa n'ogukalihya abantu. ");
INSERT INTO hav_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Ho n'aho abemeezi baherekeza Paawulo guhika oku siiko. Aliko Siila na Timoteyo bayoorha eBeroya. ");
INSERT INTO hav_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Abaherekezaga Paawulo bamugeza omu gishagala ch'eAteene. Babeere bagaluka eBeroya, Paawulo abarhegeka oku babwire Siila na Timoteyo bamubugane juba. ");
INSERT INTO hav_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Paawulo abeere ali alinga Siila na Timoteyo eAteene, omurhima gwamuluma, kubona oku mw'echo gishagala mwaliyunjwire ebishushanyo by'emaana. ");
INSERT INTO hav_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Paawulo aliiri ashambaala omu sinagoogi haguma n'aBayaahudi n'abanaharamya Nnamahanga barhali Bayaahudi. Na ngasi lusiku aliiri ashambaala n'abantu alemaga abugaana omu soko. ");
INSERT INTO hav_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Kandi, Paawulo alema ashiganana n'abigiriza baguma b'echigusho ch'aBaepikuriyo na ech'aBastoyiko. Aba bigiriza barhondera obuhaka haguma naye. Baguma omu bo babaza ntya: «Oyu shakaderha, bichi ashonda kuderha?» N'abandi baderha ntya: «Bibonekeene oku y'ashambaala elugulu y'emaana z'amandi mahanga.» Baderhaga ntyo, kwenge Paawulo aliiri abala oMwazi Mwinja gwa Yeesu n'obufuuke bw'abafu. ");
INSERT INTO hav_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Baava baheka Paawulo omu kabuga kayirikirwe Areyopago. Baamubaza ntya: «Ka wakagala rhumenyesa ezi nyigirizo zihyahya oli wayigiriza? ");
INSERT INTO hav_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Bulaala yi warhushambaalira ebintu bihyahya. Boboola rhushondere kumenya bichi biderhere.» ");
INSERT INTO hav_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Byabaaga ntyo kwenge abantu b'eAteene haguma n'abahiisi bali balamire ahagarhi kaabo, balemaga bageza ebishanji byabo byooshi omu kubala n'okuyunviriza ebinwa bihyahyahyahya. ");
INSERT INTO hav_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Paawulo aja ayimanga ahagarhi k'eAreyopago n'okuderha ntya: «Bantu b'eAteene, mbwene oku muli bantu basimire bweneene emyaazi y'edini. ");
INSERT INTO hav_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Kwenge nabeere ndi nagera omu gishagala chenyu, namabona ebishushanyo by'emaana zenyu munaharamya, namanabona n'entuliro nguma egwerhe emyandiko ederhere ntya: ‹Oku mana erhamenyikene.› Leero, oyu mulimwaharamya buzira kumumenya, yi ndi nabashambaalira. ");
INSERT INTO hav_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","«Nnamahanga walemaga egulu n'ebintu byooshi biba mo, yeewe ye Nyina empingu n'egulu. Arhalama omu nju abantu bamuyumbakiraga n'amaboko maabo. ");
INSERT INTO hav_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Yeewe arharhabalwa n'abantu nk'olagiriire oku kantu. Yeewe ye heereza booshi omuuka gw'akalamo n'ebintu byooshi bakenere. ");
INSERT INTO hav_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Alemaga embaga zooshi gurhengera muntu muguma yi balama omu gulu lyooshi. Abajirira ebihe n'okubachiira embibi z'ebihugo bakwaneene kulama mo. ");
INSERT INTO hav_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Nnamahanga alijirire ntyo, kwenge alishondere abantu bamushonde, nkabaga omu kumamarha bagale kumubona. Okuli, arhali hale na ngasi muguma weerhu. ");
INSERT INTO hav_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Kwenge oku buhashe bwage rhulamire, yi rhwalambagira yi rhwanayisa. Ebyoola biri kuguma na kulaala baguma omu bandiisi benyu baderhaga ntya: ‹Neerhu, rhuli bana baage.› ");
INSERT INTO hav_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Bulaala rhuli beene Nnamahanga, birhahemeere rhukengeere oku ali nk'emaana ze oro, z'echuuma chibaragenye changwa amandi mabaale machulwaga oku bulenga n'enkengeero z'abantu. ");
INSERT INTO hav_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","«Nnamahanga arhachiganja ebyo bihe abantu baliiri omu buhwinja. Aliko bunoola arhegekere abantu booshi ba ngasi hantu oku baleke ebyaaha. ");
INSERT INTO hav_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Bulaala achishogere olusiku nj'achiira abantu b'egulu lyooshi olushinja omu kuntu gukwaneene kugerera muntu muguma, oy'alondwere kw'ako kaasi. Ayerekeene oku booshi okuli kw'eyi myaazi omu gufuula oyo muntu gurhenga omu bafu.» ");
INSERT INTO hav_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Babeere bayunva Paawulo aderha elugulu w'obufuke bw'abafu, baguma bamushekera aliko abandi baderha ntya: «Nji rhwakuyunviriza kandi olwindi lusiku waderha elugulu w'eyi myaazi.» ");
INSERT INTO hav_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Oku buzinda Paawulo alekana nabo. ");
INSERT INTO hav_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Aliko bantu baguma baja okulunda lwage, baaba bemeezi. Ahagarhi kaabo haliiri muntu muguma w'omu kabuga k'eAreyopago oyirikwa Diyonisiyo na mukazi muguma oyirikwa Damari, n'abandi. ");
INSERT INTO hav_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Enyuma w'ebyo, Paawulo arhenga omu gishagala ch'eAteene, aja omu ch'eKorinto. ");
INSERT INTO hav_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ashimaana yo oMuyaahudi muguma oyirikwa Akila, oburhwa omu gihugo ch'ePonto. Oyo Akila na mukaage Prisila babaaga barhaza kulegama barhengere omu gishagala ch'eRooma omu gihugo ch'eItaliya, bulaala mw'ezo siku mwami mukulu Kayizaari Kuloode alirhegekere oku aBayaahudi booshi barhenge mw'echo gishagala. Paawulo aja kubarhangula, ");
INSERT INTO hav_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","abeera nabo, analiiri akola nabo, kwenge baliiri bakola kaasi kaguma naye kw'ogukwiza amahema. ");
INSERT INTO hav_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Ngasi lusiku lw'eSaabato, Paawulo alemaga ashambaala n'abantu omu sinagoogi. Aliiri ashonda ayemeeze aBayaahudi n'aBagiriki babe bemeezi. ");
INSERT INTO hav_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Aliko Siila na Timoteyo babeere baahika gurhenga eMakedoniya, Paawulo alema ageza ebishanji byaage byooshi omu kuyigiriza eChinwa cha Nnamahanga n'omu kuyeereka aBayaahudi oku Yeesu ye Krisitu. ");
INSERT INTO hav_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Babeere balahira Paawulo n'okumudukanga, abakunguurhira emyambalo yaage anababwira ntya: «Eshagama yenyu ebe oku marhwe menyu! Nyoono, nta mwinda gwa muntu ngwerhe. Gurhengera zeene, naaja emw'abarhali Bayaahudi.» ");
INSERT INTO hav_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Paawulo ahuluka mw'eyo sinagoogi, aja omu nju yaliiri aha burhambi. Eyo nju yaliiri y'omuntu oyirikwa Tiito Yusito. Arhaliiri Muyaahudi, aliko alemaga aharamya Nnamahanga. ");
INSERT INTO hav_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Aliko omukulu w'esinagoogi oyirikwa Krisipo ayemeera Nnaweerhu, yeewe n'abantu booshi b'omu nju yaage. aBakorinto banene baliiri bayunviriza Paawulo nabo bayemeera Yeesu, babatiizwa. ");
INSERT INTO hav_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Lusiku luguma obudufu, Nnaweerhu abonekera Paawulo, anamubwira ntya: «Orhayuubahaga! Gendekera kuderha, orhasiraga, ");
INSERT INTO hav_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","kwenge nyoono ndi haguma naawe. Ntaaye waguhira ko okuboko mpu akujire kubi, bulaala mpeerhe olubaga lunene mw'echiila gishagala.» ");
INSERT INTO hav_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Paawulo abeera mwaka muguma na myeezi ndarhu eKorinto eyi ali ayigiriza eChinwa cha Nnamahanga. ");
INSERT INTO hav_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Amango Galiyo aliiri murhegesi w'egihugo ch'eAkaya, aBayaahudi bachihira haguma omu kulwisa Paawulo, banamuheeka omu kabuga. ");
INSERT INTO hav_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Baderha ntya: «Oyu muntu ali ayemeeza abantu oguharamya Nnamahanga nk'oku eRhegeko lyeerhu lirhahemere.» ");
INSERT INTO hav_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Paawulo abeere ashonda kuderha, Galiyo abashubiza ntya: «Mwabo Bayaahudi, akaba mwagasidaka oyu muntu mpu akolere chibi chirebe changwa mpu ajirire omwazi mubi guzidohere, ahoola nakabayunvire nk'oku bihemere. ");
INSERT INTO hav_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Sy'aliko okubona oku obuhaka bwenyu buyerekeere ebinwa, amaziino n'eRhegeko lyenyu, eyo myaazi ebalolere mwenyine. Nyoono ntashonda gucha olushinja luli nk'oluula.» ");
INSERT INTO hav_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Ho n'aho, Galiyo abalibisya barhenge mw'ako kabuga. ");
INSERT INTO hav_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Booshi baava bafarha omukulu w'esinagoogi oyirikwa Sositeeni, barhondera kumushuurha enkoni embere z'akabuga, aliko Galiyo arhalagaga kw'echo chijiro. ");
INSERT INTO hav_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Paawulo ashuba kubeera zindi siku zinene omu gishagala ch'eKorinto. Oku buzinda aseezerana n'abaabo bemeezi n'okuja omu siiko y'eKenkereya. Embere aje omu chombo, arhanga kugembeesa enviiri zaage, kwenge aliiri amalire echilagaane ajiraga emwa Nnamahanga. Aja omu chombo yeewe, Prisila na Akila, bagenda omu gihugo ch'eSuriya. ");
INSERT INTO hav_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Babeere baahika omu gishagala ch'eEfeeso, Paawulo aleka yo Prisila na Akila. Naye aja omu sinagoogi, ashambaala n'aBayaahudi. ");
INSERT INTO hav_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Abo Bayaahudi bamuhema abeere nabo siku zinene, aliko alahira. ");
INSERT INTO hav_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Oku ali abaseezera, ababwira ntya: «Nnamahanga agasiima, nji nashuba kugaluka eno mwenyu.» Oku buzinda aja omu chombo, arhenga eEfeeso. ");
INSERT INTO hav_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Abeere ahika omu gishagala ch'eKayizariya, azamuukira eYerusaleema kulamusa echigusho ch'abemeezi. Oku buzinda ayandagalira omu gishagala ch'eAntiyokiya. ");
INSERT INTO hav_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Abeere amamala yo siku zigeeke, agendekera n'olugenzi. Alenga omu gihugo ch'eGalatiya na ech'eFurigiya omu gukomeza abemeezi booshi. ");
INSERT INTO hav_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Amo mango, Muyaahudi muguma oyirikwa Apolo, muburhwa w'omu gishagala ch'eAlegizanduriya, ahika omu gishagala ch'eEfeeso. Oyo muntu aliiri w'okuderha n'obwenge bunene, analiyinji bweneene aMandiko Matagatiifu. ");
INSERT INTO hav_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Aliiri ayigiriizwe eNjira ya Nnaweerhu. Analigwerhe obushiru omu kuderha n'okuyigiriza emyaazi ya Yeesu omu kuli. Aliko aliyinji obubatiizo bwa Yohaana bwonyine. ");
INSERT INTO hav_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Aja omu sinagoogi, arhondera kuyigiriza buzira buuba. Prisila na Akila babeere bamuyunviriza y'aderha, bamuheeka emwabo, bamuhuguula bwinjabwinja eNjira ya Nnamahanga. ");
INSERT INTO hav_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Buzinda bw'aho, Apolo abeere ashonda kuja eAkaya, abemeezi b'eEfeeso bamukomeza omurhima n'okuyandikira abemeezi b'eAkaya amaruba m'okumuyankirira bwinja. Abeere ahika yo, arhabaala bweneene abaliyemereere Yeesu kugerera olukogo lwa Nnamahanga, ");
INSERT INTO hav_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","bulaala omu buhaka n'aBayaahudi, alemaga abahima embere z'abantu, omu kubayeereka kulengera aMandiko Matagatiifu oku Yeesu ye Krisitu. ");
INSERT INTO hav_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Amango Apolo abeere ali omu gishagala ch'eKorinto, Paawulo naye aliiri alenga omu gihugo ch'emisozi ch'eAziya, anayandagalira omu gishagala ch'eEfeeso. Ashimaana yo abemeezi baguma, ");
INSERT INTO hav_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","ababaza ntya: «Ka mwaliyankiriire Muuka-Mutagatiifu amango mwayemeeraga Yeesu?» Bamushubiza ntya: «Nangwa, chiro rhurhashubiraga kuyunva baderha oku haaba Muuka-Mutagatiifu.» ");
INSERT INTO hav_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Ashuba kubabaza ntya: «Bubatiizo buchi mwayankiriire?» Bamushubiza ntya: «Bubatiizo bwa Yohaana.» ");
INSERT INTO hav_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Paawulo aja ababwira ntya: «Obubatiizo bwa Yohaana bwaliiri bw'okuyeerekana oku abantu balekere ebyaaha byaabo. Anababwira bayemeere olaala wayinja enyuma zaage, n'oyo ye Yeesu.» ");
INSERT INTO hav_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Babeere bayunva eyi myaazi, babatiizwa oku ziino lya Nnaweerhu Yeesu. ");
INSERT INTO hav_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Paawulo aja abalambuulira kw'amaboko, na Muuka-Mutagatiifu abayandagalira ko. Barhondera kuderha omu zindi ndimi n'okuleeba. ");
INSERT INTO hav_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Abo bantu, baliiri hoofu balume ekumi na babiri. ");
INSERT INTO hav_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Omu myeezi esharhu, Paawulo aliiri aja omu sinagoogi y'aBayaahudi, aliiri ashambaala buzira buuba emyaazi y'obwime bwa Nnamahanga omu gushonda abantu bayemeere. ");
INSERT INTO hav_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Aliko baguma omu bo baaba bazibu b'emirhima banalahira kuyemeera. Barhondera kuderha kubi elugulu w'eNjira ya Nnaweerhu embere z'echigusho ch'abantu. Paawulo aja abaleka. Aheeka abemeezi bonyine, na ngasi lusiku, aliiri aganiira nabo omu masomo m'omulume muguma oyirikwa Tiraano. ");
INSERT INTO hav_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Agendekera ntyo guhika myaaka ebiri, oku bulyo abantu booshi, aBayaahudi n'aBagiriki balilamire omu gihugo ch'eAziya, bayunva eChinwa cha Nnaweerhu. ");
INSERT INTO hav_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Nnamahanga aliiri ajira ebisomereene kugerera Paawulo. ");
INSERT INTO hav_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Abantu baliiri barhoola ebitambara changwa emyambalo yabaaga yahumire oku mubiri gwage, baliiri bayihira oku balwala, nabo baalema bafuma amalwala maabo, na abalifarhirwe n'abazimu, baliiri babarhenga mo. ");
INSERT INTO hav_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Haliiri Bayaahudi baguma baliiri balenga ngasi hooshi yi balibisye abazimu barhenge omu bantu. Nabo bashonda gukolesa eziino lya Nnaweerhu Yeesu, omu kuderha ntya: «Mbarhegekere oku ziino lya Yeesu, ola Paawulo ali ayigiriza, muhuluke mw'oyu muntu!» ");
INSERT INTO hav_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Omu baliiri bajira ntyo, haliiri bagala mushanvu b'omudaahwa mukulu w'aBayaahudi oyirikwa Sikewa. ");
INSERT INTO hav_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Lusiku luguma, omuzimu ababwira ntya: «Nyinji Yeesu, nyinji na Paawulo. Aliko mwabo muli bande?» ");
INSERT INTO hav_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Ho n'aho omuntu walifarhirwe n'omuzimu achikabula kubo, abalwisa anabahima booshi. Bahuluka mw'eyo nju balibirha, bali butambara eyi banayunjwire ebihulu. ");
INSERT INTO hav_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Eyo myaazi yamenyikana oku booshi balilamire omu gishagala ch'eEfeeso, aBayaahudi n'aBagiriki. Bagwarha obuuba, bakuza eziino lya Nnaweerhu Yeesu. ");
INSERT INTO hav_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Banene omu bayemeeraga Yeesu, bayinja n'okuyeemera amabi maabo mooshi embere z'abantu. ");
INSERT INTO hav_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Baguma omu bo baliiri bajira obukurungu bagusha ebitabu baliiri bakoleesa, babiyosa embere z'abantu booshi. Egichiro ch'ebyo bitabu chaliiri ch'efuranga zinene, bicheri bihumbi makumi marhaano. ");
INSERT INTO hav_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Na ntyo, kulengera obuhashe bwa Nnaweerhu, eChinwa chaage chayandaala hooshi n'okuba n'emisi. ");
INSERT INTO hav_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Enyuma z'ebyo, Paawulo ahiga okuja eYerusaleema kugerera omu gihugo ch'eMakedoniya n'eche Akaya. Aderha ntya: «Hano ngera eYerusaleema, byampema ngere n'eRooma.» ");
INSERT INTO hav_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Ntyo, arhuma bantu babiri bw'omu barhabazi baage, Timoteyo na Erasito, bamurhange eMakedoniya. Aliko yeewe abeera siku zigeeke mw'echo gihugo ch'eAziya. ");
INSERT INTO hav_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Mwamo mango, haahulukira entonganyi nene omu gishagala ch'eEfeeso elugulu w'enyigirizo z'eNjira ya Nnaweerhu. ");
INSERT INTO hav_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Eyo yaliiri omuchuzi oyirikwa Dimetriyo. Aligwerhe akaasi kw'ogukola ebishushanyo bigekegeke by'akajumiro k'emaana y'echikazi eyirikwa Aritemi, kulengera echuuma chibaragenye. Akala kaasi kaliiri kaleerhera abaabo abachuzi enyungu nene. ");
INSERT INTO hav_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Lusiku luguma, oyo Dimetriyo agusha baabo bachuzi haguma n'abandi bakozi baliiri bakola akola kaasi. Ababwira ntya: «Beera baani, muyinji oku rhunayunguka furanga zinene kulengera akala kaasi. ");
INSERT INTO hav_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Aliko nk'oku mwabwene n'okuyunva, oyu Paawulo ali ayemeeza n'ogurhebeka abantu banene. Arhali hano Efeeso honyine si na ngasi hooshi omu gihugo ch'eAziya. Ali aderha oku emaana zajiragwa n'amaboko m'abantu, zirhali maana z'okuli. ");
INSERT INTO hav_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Leero, rhuyubahire eyi myaazi bulaala arhali akaasi keerhu konyine gakenwa, sy'aliko n'akajumiro k'emaana yerhu nkulu Aritemi kaba kabushabusha. N'emaana yeerhu abantu bali baharamya omu gihugo chooshi ch'eAziya n'omu gulu lyooshi, yaheza obukuuze.» ");
INSERT INTO hav_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Abo bachuzi n'abakozi babeere bayunva eyo myaazi, bagwarhwa n'oburhe, barhondera okuyaama omu kuderha ntya: «Aritemi w'aBaefeeso ye mukulu!» ");
INSERT INTO hav_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Egishagala chooshi chayunjula olwamo. Abantu bachikabula oku Gayo na Arisitariko, baburhwa b'eMakedoniya baliiri babalama haguma na Paawulo. Booshi balibirhira jubaajuba ahantu hanene h'enshimaanano eyi bali bababululira ho. ");
INSERT INTO hav_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Paawulo ashonda oguchimoleka embere z'olola lubaga, aliko abemeezi bamubuza. ");
INSERT INTO hav_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Chiro n'abarhegesi baguma b'egihugo ch'eAziya baliiri beera ba Paawulo, nabo bamurhumira entumwa y'okumuyinginga oku arhajaga aho hantu. ");
INSERT INTO hav_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Mw'ebyo bishanji, echigusho chooshi chaligwerhe olwamo, baguma baliiri baderha ntya n'abandi ntya. Chiro banene omu bo barhamenyaga echarhumaga bachigusha. ");
INSERT INTO hav_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","aBayaahudi bayimanza muntu muguma oyirikwa Alegizandere n'okumushunikira embere z'echigusho. Bantu baguma bamubwira ebinwa aderha. Naye asimira echigusho chooshi n'okuboko oku basire y'abuurane embere zaabo. ");
INSERT INTO hav_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Babeere bamenya okw'ali Muyaahudi, booshi bajira olwamo haguma hoofu saa ebiri, eyi bali baderha ntya: «Aritemi w'aBaefeeso ye mukulu!» ");
INSERT INTO hav_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Oku buzinda, karani w'egishagala abasiza n'okuderha ntya: «Mwe bantu b'eEfeeso, abantu booshi b'omugulu bayinji oku egishagala ch'eEfeeso chiri ch'okulanga akajumiro k'emaana nkulu Aritemi n'egishushanyo chaage charhogaga gurhengera empingu. ");
INSERT INTO hav_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Nta muntu wakaja buhaka elugulu w'ebyo. Cho girhumire murhuleere, na ntaacho mujirage buzira gukengera. ");
INSERT INTO hav_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Aba bantu mwalerhere hano, ntaacho bazimbire ch'omu kajumiro k'emaana yeerhu changwa barhaza kuyidukanga. ");
INSERT INTO hav_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Akaba Dimetriyo n'abaabo bachuzi bagwerhe olushinja n'omuntu, rhugwerhe akabuga n'abazuzi. Eyo munda yi bakwaneene kuja kusidaakira. ");
INSERT INTO hav_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","N'akaba mugwerhe obwindi buhaka, bwahwera omu nshimaanano eyemeererwe n'erhegeko. ");
INSERT INTO hav_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Bulaala ebi rhuli rhwajira zeene, byagarhuma rhwasidaakwa oku rhwajirire olwamo. Na nka barhubazize elugulu w'eyi nshimaanano, rhurhakabona ech'ogushubiza.» ");
INSERT INTO hav_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Abeere amala kuderha eyi myaazi, abwira olubaga lufuluke. ");
INSERT INTO hav_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Entambala yabeere yaahwa eyo eEfeeso, Paawulo agusha abemeezi haguma, anabaseeza omurhima. Abaseezera, ava aja omu gihugo ch'eMakedoniya. ");
INSERT INTO hav_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Alenga mw'echo gihugo, abwira abemeezi ebinwa binene by'okubakomeza omurhima. Buzinda aja omu gihugo ch'eBugiriki. ");
INSERT INTO hav_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Amala yo myeezi esharhu. Abeere akola aja omu chombo ch'okuja omu gihugo ch'eSuriya, ayunva omwazi okw'aBayaahudi bamujiriire kaligi. Kwarhuma ahiga kugaluka kugerera omu gihugo ch'eMakedoniya. ");
INSERT INTO hav_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Abaherekezaga Paawulo baliiri Sopateeri mugala wa Piiro, w'eBeroya; Arisitariko na Sekundo b'eTesalonika; Gaayo w'eDerebe; Timoteyo, Tikiko na Torofimo baliiri b'eAziya. ");
INSERT INTO hav_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Abo bantu barhurhanga embere gurhulingira eTorowa. ");
INSERT INTO hav_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Rhwabo neerhu, enyuma z'esiku z'edinye y'emigati nzira chachu, rhwaja omu chombo gurhenga eFiripi. Siku erhaano zabeere zahwa, rhwabashimaana eTorowa. Rhwabeera yo siku mushanvu. ");
INSERT INTO hav_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Egolo ly'olusiku lw'eSaabato, rhwashigaanana kugabaana omugati, na Paawulo ayigiriza abantu. Agendeerera kuganiira n'abantu guhika ahagarhi k'obudufu, kwenge ali kwaneene kugenda olusiku lwakulikiraga. ");
INSERT INTO hav_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Rhwalemaga rhwabugaanana omu gorofa ebusiika. Omoola mwaliiri amatara manene. ");
INSERT INTO hav_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Muzaana muguma oyirikwa Eutiko, aliiri ayikeere oku dirisha. Paawulo aliiri eyi amaleehya enyigirizo zaage, oyo muzaana arhoolwa n'ero linene. Ero lyarhuma oyo muzaana arhoga gurhengera oku gorofa lya gasharhu. Babeere bashonda kumuyinamula, bashimaana afiire. ");
INSERT INTO hav_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Paawulo ava achima, achikabula oku ye n'okumubagalira. Ababwira ntya: «Murhayuubahaga, bulaala azeene!» ");
INSERT INTO hav_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Enyuma w'ebyo, Paawulo ashuba kuzamuukira omu gorofa. Achagulanga omugati anagulya ko, agendeerera kuganiira bweneene, kugera emiseke. Ayuusize, agenda. ");
INSERT INTO hav_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Abantu baherekeza oyo muzaana emwabo eyi ali mugumaguma. Baseezwa omurhima bweneene. ");
INSERT INTO hav_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Rhwabo, rhwarhanga kuja omu gishagala ch'eHasoosi n'echombo. Eyo munda, rhwali rhukwaneene gurhoola Paawulo, bulaala alishondere kuja yo n'amagulu. ");
INSERT INTO hav_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Abeere arhushigaana eHasoosi, rhwamuhira omu chombo, n'okuja eMitileeni. ");
INSERT INTO hav_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Olusiku lwakulikiraga, rhwarhenga yo, rhwagendekera oku nyanja, rhwagera embere z'echizimba ch'eKiyo. Olusiku lwa gasharhu, rhwahika oku chizimba ch'eSamoosi. N'olusiku luzinda, rhwahika eMileto. ");
INSERT INTO hav_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Paawulo arhashondaga kuyimanga eEfeeso omu gihugo ch'eAziya, y'arhaheza ebishanji. Aliiri abangula y'aba eYerusaleema olusiku lw'edinye y'ePendekosite akaba byagalikeene. ");
INSERT INTO hav_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Paawulo abeere ali eMileto, arhuma abantu eEfeeso guhamagala abashamuka b'echigusho ch'abemeezi. ");
INSERT INTO hav_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Babeere baahika aha ali, ababwira ntya: «Mwabo muyinji gurhe nalamire haguma nenyu, amango nahikaga muno gihugo ch'eAziya, gurhengera olusiku lurhanzi. ");
INSERT INTO hav_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Nakoleere Nnaweerhu omu bwirhonzi booshi, omu miziga, n'ahagarhi k'ebigeregezo byampikiraga elugulu wa kaligi k'aBayaahudi. ");
INSERT INTO hav_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Muyinji oku nta mwazi nababishire. Aliko, nabayamagaziize n'okubayigiriza ngasi chintu chaliiri ch'obulagiirire, omu nshimaanano z'abantu n'omu nju zenyu. ");
INSERT INTO hav_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Babe Bayaahudi, babe Bagiriki, naliiri nababwira oku baleke ebyaaha, bahindamukire Nnamahanga, banayemeere Nnaweerhu Yeesu Krisitu. ");
INSERT INTO hav_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Leero nyoono, okubona oku nshwekerwe na Muuka-Mutagatiifu, naaja eYerusaleema, buzira kumenya echampikira yo. ");
INSERT INTO hav_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Aliko, nyinji konyine oku, omu ngasi gishagala nagerere mo, Muuka-Mutagatiifu aliiri anyeereka oku eminyororo n'amalibuko bindingire. ");
INSERT INTO hav_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Sy'aliko ntaganja akalamo kaani nka chintu ch'akamaro emwani. Echinashonda chonyine, kuli kumala bwinja olugenzi lwani n'akaasi Nnaweerhu Yeesu ampaaga k'oguhamiiriza oMwazi Mwinja g'olukogo lwa Nnamahanga. ");
INSERT INTO hav_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","«Naliiri nazungula ahagarhi kenyu mweshi eyi ndi nayaamagaza obwime bwa Nnamahanga. Aliko bunoola, nyoono nyinji oku nta muguma wenyu wachimbona ko. ");
INSERT INTO hav_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Cho girhumire nababwira byo zeene oku eshagama yenyu erhachindi ko, ");
INSERT INTO hav_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","kwenge nababaliire byooshi Nnamahanga ashondere, buzira kubabisha echintu. ");
INSERT INTO hav_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Mujaage mwachilanga mwenyine haguma n'echigusho chooshi Muuka-Mutagatiifu abaheere mube bimangizi baacho. Ntyo, mulange echo chigusho ch'abemeezi ba Nnamahanga echi achiheere omu gusheesha eshagama y'oMugala. ");
INSERT INTO hav_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Nyoono nyinji oku hano mala kugenda, banyambwe bakalihire baja ahagarhi kenyu, barhanafiira echigusho ch'abemeezi obonjo. ");
INSERT INTO hav_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Na kandi, ahagarhi kenyu harhengerera abantu baderha ebinwa birhali by'okuli yi baarhuma abemeezi babakulikira. ");
INSERT INTO hav_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Boboola, muchilange eyi munali mwayibuka oku namalire myaaka esharhu, obudufu n'ezuuba ntaluhaga guhanuula omu miziga ngasi muguma wenyu. ");
INSERT INTO hav_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","«Na bunoola, namabahira omu maboko ma Nnamahanga n'omu bulanzi bw'omwazi g'olukogo lwage, gugwerhe obuhashe b'okubakuza n'okubaha agashambala haguma n'abantu baage booshi agishogere. ");
INSERT INTO hav_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Ntagifiijaga efuranga changwa ehooro, abe myambalo y'omuntu. ");
INSERT INTO hav_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Muyinji mwenyine oku nakolaga n'amaboko maani nyenyine yi mbona ebi rhwalilagire ko, nyoono n'abalimperekeeze. ");
INSERT INTO hav_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Mw'ebyo byooshi najiraga, nalibayeerekere oku bihemere gukola n'obushiru ntya yi rhurhabaale abarhagwerhe misi, omu kuyibuka ebinwa bya Nnaweerhu Yeesu. Aderhaga yenyine ntya: ‹Hali mugisho munene omu guhaana kulusha okuyankirira.›» ");
INSERT INTO hav_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Paawulo abeere amala kuderha ebyoola, afukama haguma nabo booshi, asaliira. ");
INSERT INTO hav_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Booshi baaja barhondera kulaka bweneene, bamuhoobera n'okumuseezera. ");
INSERT INTO hav_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Balibabeezwe bweneene, bulaala aliderhere oku barhagachimubona ko. Baava bamuherekeza guhika aha echombo chaliiri. ");
INSERT INTO hav_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Rhwabeere rhwalekana n'abashamuka b'echigusho ch'abemeezi b'eEfeeso, rhwabalama n'echombo guhika oku chizimba ch'eKoosi. Olusiku lwakulikiraga, rhwagendekera oku chizimba ch'eRodo, na gurhengera eyoola, rhwaja omu gishagala ch'ePaatara. ");
INSERT INTO hav_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Rhwabona mw'echo gishagala echindi chombo chaliiri chaja eFoyinikiya. Rhwaja mo n'ogusuuka. ");
INSERT INTO hav_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Rhwabeere rhukola rhuli rhwalangiira echizimba ch'eGipuro, rhwaleka cho ekulembe, n'okuyerekera eSuriya. Rhwasiika omu gishagala ch'eTiiro emunda echombo chalikwaneene kuleka emizigo. ");
INSERT INTO hav_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Rhwabeere rhwabugaanana n'abemeezi b'eyoola, rhwabeera yo siku mushanvu. Abo bemeezi baliiri babwira Paawulo kulengera obuhashe bwa Muuka-Mutagatiifu oku arhazamukiraga eYerusaleema. ");
INSERT INTO hav_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Aliko ezoola siku zabeere zahika oku buzinda, rhwagenda. Abemeezi booshi barhuherekeza, abalume na bakaabo haguma n'abaana baabo, barhukuula omu gishagala. Rhwafukama emushengo, rhwanasaliira. ");
INSERT INTO hav_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Rhwabeere rhwamala guseezerana, rhwaja omu chombo, nabo bagaluka emwabo. ");
INSERT INTO hav_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Rhwarhenga eTiiro, rhwagendeerera kubalama guhika omu gishagala ch'eTolemaayi. Eyo munda, rhwalamusa abemeezi, rhwanabeera emwabo lusiku luguma. ");
INSERT INTO hav_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Olusiku lwakulikiraga, rhwarhenga ahoola, rhwahika omu gishagala ch'eKayizariya. Eyo munda rhwaja kubeera omu nju ya Firipo. Aliiri mwigiriza w'oMwazi Mwinja, analiiri muguma mu balaala mushanvu balondoolagwa eYerusaleema. ");
INSERT INTO hav_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Aligwerhe banyere bane barhaliiza kumenya abalume. Baliiri baleebi-kazi. ");
INSERT INTO hav_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Rhwabeere rhwamala aha mwage siku zinene, omuleebi muguma oyirikwa Hagabo ahika gurhengera omu gihugo ch'eYudeeya. ");
INSERT INTO hav_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Ayinja emunda rhwaliiri, arhoola omukaba gwa Paawulo n'oguchishweka nago amagulu n'amaboko. N'okuva aderha ntya: «Muuka-Mutagatiifu aderhere ntya: ‹aBayaahudi b'eYerusaleema nji bashweka ntya nyina ogu mukaba n'okumuhaana omu maboko m'abarhali Bayaahudi.›» ");
INSERT INTO hav_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Enyuma z'okuyunva ebyo binwa, rhwabo haguma n'abemeezi b'eKayizariya, rhwayinginga Paawulo oku arhazamuukiraga eYerusaleema. ");
INSERT INTO hav_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Paawulo ava shubiza ntya: «Chagarhuma mwalira n'ogushonda kuncha omurhima? Nyoono, namalire guchirheganya, arhali ogushwekwa konyine, sy'aliko kandi n'ogufiira eYerusaleema elugulu w'eziino lya Nnaweerhu Yeesu.» ");
INSERT INTO hav_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Rhwabwene okw'arhayunviirhe, rhwasira. Oku buzinda, rhwaderha ntya: «Bihemere obulonza bwa Nnaweerhu bujirike.» ");
INSERT INTO hav_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Enyuma w'ezoola siku, rhwachirheganya, rhwazamukira eYerusaleema. ");
INSERT INTO hav_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Abemeezi baguma b'eKayizariya barhuherekeza, banarhuhisa emwa mulume muguma oyirikwa Munasoni w'oku chizimba ch'eGipuro. Ahamwage ha rhwalikwaneene guchumbika. Oyu mulume aliiri mwemeezi gurhengera miira. ");
INSERT INTO hav_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Rhwabeere rhwahika eYerusaleema, abemeezi barhuyankirira n'obushagaluke bunene. ");
INSERT INTO hav_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Olusiku lwakulikiraga, rhwagenda haguma na Paawulo emwa Yakobo. Abashamuka b'echigusho ch'abemeezi nabo balichigushire booshi ahoola. ");
INSERT INTO hav_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Paawulo abalamusa, anarhondera kubala oku bule ebi Nnamahanga ajirire kulengera akaasi kaage ahagarhi k'abarhali Bayaahudi. ");
INSERT INTO hav_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Babeere baamala kumuyunviiriza, bakuuza Nnamahanga. Babwiira Paawulo ntya: «Mwene weerhu, obwene ebihumbi bingana by'aBayaahudi bayemereere Yeesu, na booshi, bagwerhe obushiru oku Rhegeko lya Muusa. ");
INSERT INTO hav_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Aliko leero, babwirirwe okw'oli wayigiriza aBayaahudi booshi balamire ahagarhi k'abarhali Bayaahudi kuleka eRhegeko lya Muusa. Bayunviirhe okw'oli wababwira mpu barhagikembuulaga abaana baabo, barhanagikulikiraga emicho y'aBayaahudi. ");
INSERT INTO hav_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Gurhe rhujaage rhwajira? Kwenge barhabula kumenya oku wahikire. ");
INSERT INTO hav_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Ojire oku rhwakubwira. Rhugwerhe balume bane bajirire echilagaane emwa Nnamahanga. ");
INSERT INTO hav_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Genda n'aba bantu, omu micho y'oguchicheesa, onahaane byooshi bahemwa yi bagembwa enviiri. aBantu booshi baaja bamenya okw'ebinwa bayunvaga bali bakuderha ko biri by'obubeeshi. Banamenya oku wooyo onakenga eRhegeko lya Muusa omu kalamo kaawe. ");
INSERT INTO hav_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Abarhali Bayaahudi bahindukire bemeezi, boowe rhwabayandikiire miira ebi rhubarhegekere bachilange ko. Rhwabarhegekere oku barhalyaaga enyama barhuuliraga emaana n'omulegano changwa enyama zakanulwaga, banachilange n'obuhushi.» ");
INSERT INTO hav_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Olusiku lwakulikiraga, Paawulo agenda nabo balume bane, banagicheesa haguma naye. Ava aja omu Nju ya Nnamahanga n'okubala mango machi esiku zaabo z'ogugicheesa zahwa n'entuulo yahanwa oku ngasi muguma waabo. ");
INSERT INTO hav_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Siku mushanvu z'okugicheesa zabeere ziri hoofu guhwa, aBayaahudi baguma barhengaga omu gihugo ch'eAziya babona Paawulo omu Nju ya Nnamahanga. Bararusa olubaga looshi, banamufarha. ");
INSERT INTO hav_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Baalema babanda akalulu n'okuderha ntya: «Mwe balume b'eIsraheeli, muyinje murhugwase! Y'onoola, ola muntu oyigiriza abantu booshi na ngasi hooshi okuboneerera olubaga lwerhu, eRhegeko lya Muusa n'eyi Nju ya Nnamahanga! N'ahanene, ahirire abarhali Bayaahudi omu Nju ya Nnamahanga, amanazingiisa aha hantu hatagatiifu!» ");
INSERT INTO hav_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Baderhaga ntyo, kwenge babaaga babwene omu gishagala Paawulo haguma na Torofimo muburhwa w'eEfeeso. Bali bakengereere oku Paawulo ali muheekere omu Nju ya Nnamahanga. ");
INSERT INTO hav_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Akaluulu kayunjula omu gishagala chooshi, n'abantu bayinja balibirha gurhengera ngasi lunda. Baafarha Paawulo, bamukululira embuga w'eNju ya Nnamahanga, n'okuva bachinga emilyango. ");
INSERT INTO hav_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Babeere bali bashonda kumuyirha, omukulu w'engabo y'abasoda b'ekirooma ayunva omwazi okw'akalulu kayandeere hooshi omu Yerusaleema. ");
INSERT INTO hav_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Ho n'aho arhoola abasoda n'abakulu baabo, n'oguchima alibirhira yo. Babeere bamubona n'abasoda baage, baaleka gushuurha Paawulo. ");
INSERT INTO hav_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Oyu mukulu w'engabo y'abasoda ava ashegera hoofu na Paawulo, amufarha, anarhegeka oku bamushweke na malegule mabiri. Enyuma abaza akaba ali nde na gichi ajirire. ");
INSERT INTO hav_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Aliko omu chigusho, baguma baliiri bayaama ntya n'abandi ntya. Abeere afundwa kumenya echaleerhere akalulu, arhegeka baheeke Paawulo omu kampi k'abasoda. ");
INSERT INTO hav_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Paawulo abeere ali ashonda kuja omu nju y'abasoda, abasoda bamubarhula bulaala olubaga lwaliiri lukalihire bweneene. ");
INSERT INTO hav_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Abantu booshi baliiri bamukulikiire eyi bali bayaama ntya: «Ayirhwe!» ");
INSERT INTO hav_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Abasoda babeere bashonda guhira Paawulo omu kampi kaabo, abaza omukulu waabo ntya: «K'onyemereere nkubwire echinwa chiguma?» Naye amushubiza ntya: «K'oyinji kuderha eKigiriki? ");
INSERT INTO hav_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","K'arhali wooyo w'olaala Mumiisiri nji wazindaga gurarusa abantu n'oguheeka omu mpinga echigusho ch'ebishumuusi bihumbi bine bigwerhe emitwaro?» ");
INSERT INTO hav_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Paawulo ashubiza ntya: «Nyoono, ndi Muyaahudi, muburhwa w'omu gishagala ch'eTariso omu gihugo ch'eKilikiya. Echo gishagala chiyinjikeene bwinjabwinja. Nguhemere waliha, onyemeerere gushambaala n'olubaga.» ");
INSERT INTO hav_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Oyo mukulu w'engabo y'abasoda ava amuyemeerera. Paawulo ayimanga ahalengereere, asimira abantu n'okuboko mpu basire. Babeere bamaasira, ababwira omu lulimi lw'eGiheburaniya ntya: ");
INSERT INTO hav_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","«Badaarha na beene beerhu, munyuvirize! Bunoola nashonda kuderha elugulu waani nyenyine embere zenyu.» ");
INSERT INTO hav_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Babeere bayunva oku Paawulo ali aderha nabo omu lulimi lw'eGiheburaniya, basira bweneene. Aja ababwira ntya: ");
INSERT INTO hav_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","«Nyoono, ndi Muyaahudi, oburhwa eTariso omu gihugo ch'eKilikiya. Aliko nalemberwaga mu chinoola gishagala ch'eYerusaleema. Naliiri mwigirizwa wa Gamaliyeeri, analinyigirize gurhe nagakulikira bwinjabwinja eRhegeko lya bashookuluza. Nagihaanire looshi gukolera Nnamahanga nk'okumulimwajira mweshi zeene. ");
INSERT INTO hav_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Naliiri nalibuza bweneene abantu balikulikiire eNjira ya Nnaweerhu chiro n'okuyirha baguma omu bo. Nagendaga nashweka abalume n'abakazi n'okubahira omu munyororo. ");
INSERT INTO hav_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Omudaahwa mukulu n'akabuga k'abashamuka b'aBayaahudi bagahamiiriza oku ebindi naderha biri by'okuli. Nayankiriire emwabo amaruba mayerekeere abeerhu Bayaahudi b'omu gishagala ch'eDamasiki. Naja eyo munda yi nshweka abemeezi baliiri yo n'okubaleerha bahanirwe eYerusaleema.» ");
INSERT INTO hav_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Paawulo ashuba kuderha ntya: «Lusiku luguma, naliiri omu njira, eyi ndi nashonda guhika eDamasiki. Hoofu n'emidi, obumoleke bubaragenye bweneene bwava bwahulukira omu mpingu, bwangorha. ");
INSERT INTO hav_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Nagwa ahashi, nayunva omulenge guli gwambwira ntya: ‹Saawulo, Saawulo, girhumire wandibuza?› ");
INSERT INTO hav_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Nashubiza ntya: ‹Nnaweerhu, wooyo oli nde?› Naye anshubiza ntya: ‹Nyoono ndi Yeesu w'eNazareeti, oli walibuza.› ");
INSERT INTO hav_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Abaliiri haguma naani baali babwene bwinja obo bumoleke, aliko barhaliyunvirhe omulenge g'owaliiri anshambaalira. ");
INSERT INTO hav_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Naja naaderha ntya: ‹Nnaweerhu, gurhe nkwaneene kujira?› Nnaweerhu anshubiza ntya: ‹Yimanga, oje eDamasiki, n'eyoola munda bakubwira ngasi chooshi Nnamahanga agurhegekere ojire.› ");
INSERT INTO hav_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Abaliiri haguma naani bampeeka eyi banfarhire okuboko, banampisa eDamasiki, bulaala ntaacho nakagalire kubona elugulu w'obumoleke bwalimpumize. ");
INSERT INTO hav_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","«Na muntu muguma oyirikwa Hananiya walilamire ahola Damasiki ayinja kuntangula. Aliiri muntu wakengaga Nnamahanga omu gukulikira eRhegeko lya Muusa. Analikengerwe bweneene n'aBayaahudi booshi balilamire eyo munda. ");
INSERT INTO hav_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Ayinjire, ayimanga hoofu nani, anambwira ntya: ‹Mwene weerhu Saawulo, shuba obone!› Ho n'aho ameesho maani mahumuulwa, naava namubona. ");
INSERT INTO hav_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Ambwira ntya: ‹Nnamahanga wa bashookuluza beerhu akulondwere y'omenya obulonza bwage, onabone Okwaneene. Kandi, akulondwere y'omuyunve aderha n'obunu bwage yenyine. ");
INSERT INTO hav_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Kwenge waaba muhamiiriza waage embere z'abantu booshi, waderha elugulu w'ebi wabwene n'okuyunva ko. ");
INSERT INTO hav_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Na bunoola, bichi ochiri walinga? Yimanga, obatiizwe, onahamagale Nnaweerhu y'ocheeswa gurhenga omu byaaha byaawe.›» ");
INSERT INTO hav_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Paawulo ashuba kuderha ntya: «Nabeere nagaluka eYerusaleema, oku ndi nasaliira omu Nju ya Nnamahanga, nava nabonekerwa. ");
INSERT INTO hav_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Mw'oko kubonekerwa, nabona Nnaweerhu, anambwira ntya: ‹Orhenge jubaajuba mu chino gishagala ch'eYerusaleema, bulaala abantu barhayankirira obuhamiriza waderha elugulu waani.› ");
INSERT INTO hav_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Nyoono naderha ntya: ‹Nnaweerhu, bayinji bonyine oku naliiri nagera esinagoogi oku yindi gushweka n'ogushurha abakuyemereere. ");
INSERT INTO hav_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","N'amango basheeshaga eshagama y'omuhamiiriza waawe Sitefaano, nyenyine naliiri ho. Naani, naliyemeere okw'ayirhwe, naliiri nalanga n'emyambalo y'abamuyirhaga.› ");
INSERT INTO hav_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Nnaweerhu aja ambwira ntya: ‹Genda, bulaala nyoono nagurhuma hale, emwa abarhali Bayaahudi.›» ");
INSERT INTO hav_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Abantu baliiri bayunviriza Paawulo kubuyabuya. Aliko abeere ahika kw'echiila chinwa chizinda, baliika omulenge munene n'okuderha ntya: «Mumuyirhe! Arhakwaneene kulama oku lino gulu!» ");
INSERT INTO hav_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Babanda akaluulu, bakuula emyambalo yaabo, banakabula olujuchu omu chanya. ");
INSERT INTO hav_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Omukulu w'engabo y'abasoda b'ekirooma, arhegeka oku bahire Paawulo omu kampi kaabo, bamushurhe amataraki banamubaziirize yi bamenya egirhumire abantu babanda akaluulu elugulu waage. ");
INSERT INTO hav_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Oku bali bamumina n'emigozi yi bamushuurhe, Paawulo abaza omukulu w'abasoda waliiri ahoola ntya: «Ka muyemereerwe gushuurha oMurooma orhachiriirwe olushinja?» ");
INSERT INTO hav_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Abeere ayunva ntyo, agenda kubwira omukulu w'engabo y'abasoda ntya: «Waliha, gasi oyu muntu ali Murooma! Gurhe waaja wamujira?» ");
INSERT INTO hav_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Oyu mukulu w'engabo abeere ayunva ntyo, aja emunda Paawulo ali anamubaza ntya: «Mbwira bwinja, k'onali Murooma?» Naye ashubiza ntya: «Neechi, ndi Murooma.» ");
INSERT INTO hav_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Oyoola mukulu ashuba kuderha ntya: «Nyoono, nahezaga efuranga zinene yi mba Murooma!» Paawulo naye aderha ntya: «Nyoono ndi Murooma w'akaburhano.» ");
INSERT INTO hav_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Ho n'aho, balaala bashondaga kumubaziiriza bamuleka. oMukulu w'engabo abeere amenya oku Murooma y'ashwekere, afarhwa n'obuuba. ");
INSERT INTO hav_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Olusiku lwakulikiraga, omukulu w'engabo y'abasoda ashonda kumenya ech'aBayaahudi basidakiire Paawulo. Echoola charhuma amushwekuula, anarhegeka abakulu b'abadaahwa n'akabuga kooshi k'aBayaahudi mpu babugaanane. Aja achimya Paawulo n'okumuyimanza embere zaabo. ");
INSERT INTO hav_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Paawulo aloleereza abo bashamuka b'akabuga k'aBayaahudi, ababwira ntya: «Beene beerhu, guhika zeene, nyoono nta chibi mbwene omu murhima gwani elugulu w'oboorhere bwani embere za Nnamahanga.» ");
INSERT INTO hav_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Omudaahwa mukulu oyirikwa Hananiya arhegeka abantu baliiri hoofu na Paawulo mpu bamushuurhe oku buunu. ");
INSERT INTO hav_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Paawulo ava amubwira ntya: «Nnamahanga ye nji wagushuurha wooyo weeri nka chibambaazi gishigirwe ko eshwagara! Wooyo oyikeere ahoola y'onchiira olushinja gukulikirana n'eRhegeko. Aliko, nawe wenyine orhalikengere omu gurhegeka mpu banshuurhe!» ");
INSERT INTO hav_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Abantu baliiri ahoola baamubaza ntya: «Gurhe wakadukanga omudaahwa mukulu wa Nnamahanga?» ");
INSERT INTO hav_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Paawulo ashubiza ntya: «Beene beerhu! Ntaliyinji okw'ali mudaahwa mukulu. Kwenge biyandikirwe ntya: ‹Orhaderhaga kubi omukulu w'olubaga lwawe.›» ");
INSERT INTO hav_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Paawulo abaaga ayinji oku abashamuka baguma omu kabuga bali Basadukaayo n'abandi Bafarisaayo. Echo charhuma aderha n'omulenge munene ntya: «Beene beerhu, nyoono ndi Mufarisaayo na mugala w'aBafarisaayo. Mpirirwe zeene embere z'akabuga elugulu y'obulangaalire bwani bw'obufuuke bw'abafu.» ");
INSERT INTO hav_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Paawulo abeere amala kuderha ebyoola, haahulukira obuhaka ahagarhi k'aBafarisaayo n'aBasadukaayo. Abantu balichigushire ahoola, bachigaba mo kabiri. ");
INSERT INTO hav_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Byabaaga ntyo bulaala aBasadukaayo banaderha mpu nta bufuuke, nta malahika, na nta muzimu. aBafarisaayo boowe banayemeera ebyo byooshi. ");
INSERT INTO hav_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Haaba olwamo lunene, n'abigiriza b'amarhegeko baguma b'echigusho ch'aBafarisaayo bayimanga n'okuderha n'omulenge munene ntya: «Nta chibi n'echiguma rhwabwene k'oyu muntu. Nkabaga omuzimu changwa malahika aderhere naye!» ");
INSERT INTO hav_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Entonganyi yabeere yaluga, omukulu w'engabo y'abasoda ayuubaha oku abo bashamuka b'akabuga bashenyagula Paawulo. Arhegeka abasoda baje kumukuula ahagarhi kaabo n'okumuheeka omu kampi. ");
INSERT INTO hav_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Bwabeere budufu, Nnaweerhu ahulukira embere za Paawulo n'okuderha ntya: «Seeza omurhima! Nka kulaala wampamiirizaga eYerusaleema, ntyo k'okwaneene kandi kumpamiiriza eRooma.» ");
INSERT INTO hav_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Bwabeere bwacha, aBayaahudi baguma baja kaligi n'okujira endahiro oku barhaalya barhananywa barhanaza kuyirha Paawulo. ");
INSERT INTO hav_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Abamujiraga kaligi baliiri banene oku bantu makumi mane. ");
INSERT INTO hav_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Baaja gushonda abakulu b'abadaahwa n'abashamuka b'aBayaahudi, bababwira ntya: «Rhwajirire endahiro oku rhurhaalya, rhurhananywa rhurhanaza kuyirha Paawulo. ");
INSERT INTO hav_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Leero bunoola, mwabo haguma n'akabuga k'aBayaahudi, muheme omukulu w'engabo y'abasoda balerhe Paawulo embere zenyu. Mumubwire oku muli mwashonda kumenya bwinjabwinja emyaazi bamusidakiire. Neerhu, rhwagirheganyize kumuyirhira omu njira arhaza gera hano.» ");
INSERT INTO hav_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Aliko mwihwa wa Paawulo ayunva ako kaligi, anaja omu kampi k'abasoda, abalira Paawulo eyo myaazi. ");
INSERT INTO hav_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Paawulo ava ahamagala muguma omu bakulu b'abasoda n'okumubwira ntya: «Heka oyu murhabana emw'omukulu w'engabo y'abasoda, kwenge agwerhe omwazi amubalira.» ");
INSERT INTO hav_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Oyo mukulu agenda haguma naye emwa nnahamwabo, n'okumubwira ntya: «Ola mushwekwa Paawulo alimpamagere n'okumpema mpu nkulerhere ono murhabana, agwerhe omwazi akubwira.» ");
INSERT INTO hav_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Oyo mukulu w'engabo afarha oyo murhabana oku kuboko, amuheka eburhambi, anamubaza ntya: «Mwazi muchi ogwerhe g'okumbalira?» ");
INSERT INTO hav_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Oyo murhabana naye amushubiza ntya: «aBayaahudi bayunvikeene kuguhema olerhe Paawulo omuseezi embere z'akabuga kaabo. Bachijira nk'abashonda kumenya bwinjabwinja emyaazi asidakirwe ko. ");
INSERT INTO hav_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Aliko waliha, orhayemeeraga, bulaala balume balenzeze makumi mane omu bo bachibishire banalingire kumuyirha. Banajirire endahiro oku barhaalya n'okunywa barhanaza kumuyirha. Bunoola bamalire guchirheganya. Yi balinga echinwa chaawe chonyine.» ");
INSERT INTO hav_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Oyu mukulu w'engabo agalula oyo murhabana n'okumubwira ntya: «Ntaaye obwirage oku wanshambaliire eyi myaazi.» ");
INSERT INTO hav_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Oku buzinda, oyo mukulu w'engabo y'abasoda ahamagala abakulu babiri b'abasoda alirhegekere. Ababwira ntya: «Murhoole basoda magana mabiri balambagira n'amagulu, haguma n'abasoda makumi gali mushanvu balambagira n'endogomi, n'abandi magana mabiri balwisa n'echumu. Booshi bagende omu gishagala ch'eKayizariya aha saa esharhu z'obudufu. ");
INSERT INTO hav_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Murheganye endogomi zaheka Paawulo y'ahika bwinja emw'omurhegesi Feliiki.» ");
INSERT INTO hav_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Oyo mukulu w'engabo y'abasoda ayandika maruba maderhere ntya: ");
INSERT INTO hav_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","«Nyoono Kuloode Lusiya, nkulamwise waliha Feliiki, murhegesi w'egihugo ch'eYudeeya. ");
INSERT INTO hav_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Oyu muntu, aBayaahudi balimufarhire n'ogushonda kumuyirha. Naani nabeere nayunva okw'ali Murooma, nyono haguma n'echigusho chaani ch'abasoda rhwagenda kumurhabaala. ");
INSERT INTO hav_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Namuyandagaza embere z'akabuga k'aBayaahudi eyi nshondere kumenya bichi bamusidakiire. ");
INSERT INTO hav_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Nava namenya oku alisidaakirwe elugulu w'ebiyerekeere eRhegeko lyaabo. Aliko, omu byooshi alisidaakirwe, ntaacho chagarhumire ahanirwa ogufa changwa kuja omu munyororo. ");
INSERT INTO hav_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","N'amango nayunvaga omwazi oku aBayaahudi bamujiriire kaligi k'okumuyirha, ho n'aho namurhuma emwawe. Nabwira abamusidakire oku baheke olushinja embere zaawe.» ");
INSERT INTO hav_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Abo basoda baja barhoola Paawulo gukulikirana n'oku balirhegekerwe. Banamuheeka, na mw'obo budufu bamugeza omu gishagala ch'eAntipatiri. ");
INSERT INTO hav_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Olusiku lwakulikiraga, abasoda baliiri balambagira n'amagulu bagaluka omu kampi kaabo. Baaleka abaabo baliiri bagenda oku ndogomi bagendereere n'olugenzi haguma na Paawulo. ");
INSERT INTO hav_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Bagerere omu gishagala ch'eKayizariya, baava baheereza omurhegesi Feliiki mala maruba bahaaga bo n'okumumoleka Paawulo. ");
INSERT INTO hav_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Oyu murhegesi abeere amala gusoma amo maruba, abaza Paawulo ntya: «Oli muntu w'omu gihugo gihe?» Abeere amenya okw'ali w'eKilikiya, ");
INSERT INTO hav_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","amubwira ntya: «Nayinja gukubuuranya hano abagusidakaga bahika.» Anava arhegeka oku bamulange omu nju y'echami yayumbakwaga na Heroode. ");
INSERT INTO hav_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Enyuma w'esiku erhaano, omudaahwa mukulu oyirikwa Hananiya aja eKayizariya haguma n'abashamuka baguma b'aBayaahudi n'omuntu w'okubabuuranira oyirikwa Teritulo. Nabo bahika embere z'omurhegesi Feliiki, basidaka Paawulo. ");
INSERT INTO hav_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Babeere bahamagala Paawulo, Teritulo arhondera kumusidaka n'okuderha ntya: «Mukengwa Feliiki, werhumire rhwabwona omurhuula munene n'oburhegesi bwawe bukwiriire bwarhumire ebintu binene byaba binja mw'echi gihugo. ");
INSERT INTO hav_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Kooko waliha Feliiki, rhurhakayibirira ebi byooshi ngasi hooshi na ngasi gihe. ");
INSERT INTO hav_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Aliko, ogurhaguhezeza ebishanji, nguhemere oyunviirize omu bwinja bwawe ebinwa rhwashonda kuderha oku bugeeke. ");
INSERT INTO hav_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Rhwabwene oku oyu muntu ali mudaarhi bweneene. Y'ararusa aBayaahudi booshi omu gulu lyooshi. Kandi, yeewe ye mukulu w'edini ly'obubeeshi ly'aBanazareeti. ");
INSERT INTO hav_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Abaaga ashondere guhumaanya eNju ya Nnamahanga, aliko rhwamamufarha. Rhwashondaga kumuhana gukulikarana n'eRhegeko lyeerhu, ");
INSERT INTO hav_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","aliko Lusiya, mukulu w'engabo y'abasoda, amayinja gurhunyugushula ye. ");
INSERT INTO hav_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Anabwira abo basidaakire Paawulo oku bayinje eno mwawe. Wooyo wenyine wakamubuuranya y'omenya bwinjabwinja ebi byooshi rhumusidakiire.» ");
INSERT INTO hav_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","aBayaahudi baliiri aho, bahamiriza okw'eyo myaazi yooshi ya Teritulo eri y'okuli. ");
INSERT INTO hav_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Oku buzinda, omurhegesi Feliiki asimira Paawulo mpu naye aderhe. Paawulo aderha ntya: «Waliha Feliiki, nyinji oku gurhengera myaaka minene oli muzuuzi w'olu lubaga. Boboola, nta buuba ngwerhe b'okubuuranira embere zaawe. ");
INSERT INTO hav_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Wenyine wakanabaza, banakubwira oku harhazigera siku ekumi n'ebiri njire eYerusaleema guharamya Nnamahanga. ");
INSERT INTO hav_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Aba bantu bansidaakire, nta muguma wabo wanshimaanire omu Nju ya Nnamahanga changwa omu masinagoogi maabo, changwa ahandi ahantu omu gishagala ndi najira obuhaka n'omuntu changwa ndi nararusa olubaga. ");
INSERT INTO hav_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Kandi, barhakagala gukuyeereka bwinjabwinja elugulu w'ebi bansidaakire ko bunoola. ");
INSERT INTO hav_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Aliko nyemereere embere zaawe oku ndi nakolera Nnamahanga wa bashookuluza beerhu omu gukulikira eNjira ya Nnaweerhu. Yi banaderha okw'eri y'obubeeshi. Si nyoono, nyemereere byooshi biyandikirwe omu bitaabu by'eRhegeko n'omu by'abaleebi. ");
INSERT INTO hav_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Ngwerhe obulangaalire kuguma nabo emwa Nnamahanga oku nj'afuula abantu booshi, abakwaneene n'ababi. ");
INSERT INTO hav_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Cho girhumire ndi nagihangaana esiku zooshi kuba n'oboorhere bwinja embere za Nnamahanga n'embere z'abantu. ");
INSERT INTO hav_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","«Nabeere najira myaaka minene ntali eYerusaleema, nagaluka yo. Naliiri naaja guhekera abakene bali omu lubaga lwani oburhabaale n'ogurhuulira Nnamahanga entuulo. ");
INSERT INTO hav_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Egihe naliiri narhula entuulo eyi nagicheeseze, aba bantu banshimaana omu Nju ya Nnamahanga. Nta rarusaga abantu na nta chigusho ch'abantu naliiri nacho. ");
INSERT INTO hav_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Aliko, Bayaahudi baguma barhengeraga omu gihugo ch'eAziya baliiri aho. Abo babakayinjire embere zaawe kunsidaaka, akaba bagwerhe echinwa elugulu waani. ");
INSERT INTO hav_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Changwa, aba bantu baderhe chibi gichi bambwene ko amango bansidaakaga embere z'akabuga k'aBayaahudi. ");
INSERT INTO hav_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Nkabaga echibi chiguma najirire, nayaamaga embere zaabo ntya: ‹Mumpanire ntya zeene kwenge ngwerhe obulangaalire okw'abafu nji bafuuka.›» ");
INSERT INTO hav_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Feliiki waliyinji bwinjabwinja ebiyerekeere eNjira ya Nnaweerhu, abwira abalisidakire Paawulo ntya: «Olu lushinja lwenyu nji nalucha amango Lusiya, omukulu w'engabo y'abasoda nj'ahika hano.» ");
INSERT INTO hav_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Oku buzinda, arhegeka omukulu w'abasoda ahire Paawulo omu munyororo, aliko amulekere ebishanji by'okujira ebyashondere, analeke abeera baage baleme bamurhabaala. ");
INSERT INTO hav_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Enyuma wa siku zigeeke, Feliiki ahika haguma na mukaage Durusila, waliiri Muyaahudi-kazi. Arhegeka balerhe Paawulo, naye ayunviriza ebinwa aliiri aderha elugulu w'obwemeezi omu Yeesu Krisitu. ");
INSERT INTO hav_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Aliko Feliiki abeere ayunva Paawulo ashambaala elugulu wa byooshi bikwaneene embere za Nnamahanga, elugulu w'oguchilanga n'amabi, n'elugulu w'olusiku Nnamahanga nj'achiira abantu olushinja, ayuubaha. Abwira Paawulo ntya: «Bunoola okola wakagenda. Nji nashuba kuguhamagala amango nabona ebishanji.» ");
INSERT INTO hav_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Aliiri alangalire oku Paawulo amuha efuranga. Elugulu w'echo, alema ahamagala Paawulo ngasi mango oku baganiire haguma. ");
INSERT INTO hav_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Habeere hagera myaaka ebiri, Porikiyo Fesito ayima ahali ha Feliiki. Aliko Feliiki aleka Paawulo omu munyororo kwenge alishondere gusimiisa aBayaahudi. ");
INSERT INTO hav_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Fesito abeere amajira siku esharhu ahikire mw'echo gihugo ch'eYudeeya, arhenga omu gishagala ch'eKayizariya, azamuukira omu gishagala ch'eYerusaleema. ");
INSERT INTO hav_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Abeere ali eyoola, abakulu b'abadaahwa n'abandi bakulu b'aBayaahudi baaja emwage gusidaaka Paawulo. ");
INSERT INTO hav_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Bamuyinginga oku abarhabaale, agalule Paawulo eYerusaleema, bulaala bali bamujiriire akaligi k'okumuyirhira omu njira. ");
INSERT INTO hav_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Fesito abashubiza ntya: «Paawulo alangirwe omu munyororo eKayizariya, naani nyenyine ndi hoofu kugaluka yo. ");
INSERT INTO hav_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Muleke abakulu benyu baguma bagende haguma naani. N'akaba oyuula muntu hali echintu chibi ajiriire, bamusidaakire yo.» ");
INSERT INTO hav_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Fesito abeere amala haguma nabo esiku zagahika ku munaane changwa ekumi, agaluka eKayizariya. Olusiku lwakulikiraga, ayikala oku ntebe yaage y'oguchiira eshinja, n'ogurhegeka baleerhe Paawulo. ");
INSERT INTO hav_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Paawulo abeere ahika, aBayaahudi barhengaga eYerusaleema, bamuzunguluka n'okumusidakira mabi malemereere manene. Aliko bagambwa kuyeerekana oku mali m'okuli. ");
INSERT INTO hav_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Paawulo aja abuurana n'okuderha ntya: «Nyoono, nta chibi najirire elugulu w'eRhegeko ly'aBayaahudi changwa elugulu w'eNju ya Nnamahanga, changwa n'elugulu wa mwami mukulu Kayizaari.» ");
INSERT INTO hav_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Fesito ashonda gusimiisa aBayaahudi, abaza Paawulo ntya: «K'oshondere oje eYerusaleema, ochiirwe yo olushinja embere zaani kw'ebyoola byooshi?» ");
INSERT INTO hav_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Paawulo ashubiza ntya: «Nyimangire omu kabuga ka mwami mukulu Kayizaari na hanoola ha nkwaneene guchiirwa olushinja. Nta chibi n'echiguma najiriire aBayaahudi nk'okuula wooyo wenyine obiyinji bwinja. ");
INSERT INTO hav_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Akaba najirire echijiro girhakwaneene, gihemere oku nyirhwe, nyemereere ogufa. Aliko akaba ebinwa aBayaahudi bansidakiire birhali by'okuli, ntaaye ogwerhe obuhashe b'okumpira omu maboko maabo. Nyoono, nahema olushinja lwani luchiibwe na mwami mukulu Kayizaari.» ");
INSERT INTO hav_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Fesito ayuusize kuja mahwe n'abashamuka baage, aja ashubiza Paawulo ntya: «Wahemere oku olushinja lwawe luchiibwe na mwami mukulu Kayizaari, waaja guchiirwa lo naye.» ");
INSERT INTO hav_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Hagereere siku zigeeke, mwami Agiripa haguma na mwali waabo oyirikwa Berenike, baahika eKayizariya kulamusa Fesito. ");
INSERT INTO hav_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Babeere bajira yo siku zinene, Fesito abalira mwami Agiripa emyaazi y'olushinja lwa Paawulo. Amubwira ntya: «Hanoola, hali mulume muguma Feliiki alekere omu munyororo. ");
INSERT INTO hav_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Amango najaaga eYerusaleema, abakulu b'abadaahwa n'abashamuka b'aBayaahudi bamusidaaka, banampema oku muhaane. ");
INSERT INTO hav_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Naani nabashubiza oku omu migenzo y'aBarooma, omuntu arhahanwa embere z'okubuurana n'abantu bamusidaakire, n'okubuurana yenyine elugulu w'ebyasidakiirwe. ");
INSERT INTO hav_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Baaja bayinja hano haguma naani. Olusiku lwakulikiraga, buzira guheza ebishanji, nayikala oku ntebe y'oguchiira ko olushinja n'ogurhegeka baleerhe oyoola mulume. ");
INSERT INTO hav_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Babeere bamuleerha, abamusidaakire bayimanga n'ogurhondera kumulega. Aliko nta chijiro chiguma chibi bamulegere ko, nk'oku nalikengeerere. ");
INSERT INTO hav_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Aliko baliiri bajira obuhaka haguma naye elugulu w'edini lyaabo lyonyine, n'elugulu w'omuntu muguma wafiire oyirikwa Yeesu. Paawulo yeewe aliiri aderha oku oyoola muntu afuukire. ");
INSERT INTO hav_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Oku bwani, ntamenyaga gurhe nagacha olushinja luli nk'olu. Naja nabaza Paawulo akaba ashondere kuja eYerusaleema y'olushinja lwage luchiirwe yo. ");
INSERT INTO hav_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Aliko Paawulo ahemere oku olushinja lwage luchiibwe na mwami mukulu Kayizaari. Naja narhegeka oku bamulange omu munyororo guhika amango nji namurhuma emwa Kayizaari.» ");
INSERT INTO hav_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Mwami Agiripa abwira Fesito ntya: «Naani nagashondere nyunviirize oyoola mulume.» Fesito amushubiza ntya: «Wamuyunviiriza omuseezi.» ");
INSERT INTO hav_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Olusiku lwakulikiraga, Agiripa na Berenike bayinja n'obukuuze bunene. Baaja omu nju bachiira mo eshinja haguma n'abakulu b'engabo z'abasoda, n'abandi balume bakengwa b'omu gishagala. Fesito arhegeka oku baleerhe Paawulo. ");
INSERT INTO hav_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Fesito aja aderha ntya: «Mwami Agiripa nenyu mweshi mwe muli haguma neerhu hanoola, mubwene oyuula mulume! aBayaahudi booshi bamusidakiire emwani, eYerusaleema na hano Kayizariya. Baliiri baderha n'omulenge munene oku arhagikwaneene kulama. ");
INSERT INTO hav_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Si nyoono, nabona oku ntaacho ajirire gikwaneene olufu. Aliko yeewe ahema oku olushinja lwage luje guchiibwa na mwami mukulu Kayizaari eyo Rooma. Naja nahiga kumurhumira ye. ");
INSERT INTO hav_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Aliko naani nyenyine, nta chinwa ngwerhe ch'okuli nakayandikira mwami mukulu. Cho girhumire namuleerha embere zenyu na bweneene embere zaawe mwami Agiripa. Leero hano rhuyuusa kumubuuranya, nkaba nabona echinwa nayandika elugulu waage. ");
INSERT INTO hav_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Kwenge nyoono mbwene oku gurhali kwinja ogurhuma omushwekwa eRooma buzira kuyeerekana bwinjabwinja ebirhumire asidaakwa.» ");
INSERT INTO hav_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Mwami Agiripa abwira Paawulo ntya: «Oyemeererwe guchibuuranira.» Paawulo alambuula okuboko, n'ogurhondera kubuurana ntya: ");
INSERT INTO hav_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","«Mwami Agiripa, nshagalukire bweneene zeene, okubona nyimangire embere zaawe yi nchibuuranire elugulu w'ebinwa byooshi aBayaahudi bansidaakire ko. ");
INSERT INTO hav_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Kwenge waliha, wooyo wenyine oyinji bwinja emigenzo yooshi y'aBayaahudi n'obuhaka bwabo booshi. Nkuyingingire waliha, onyunviirize buzira kuluha. ");
INSERT INTO hav_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","«aBayaahudi booshi bayinji gurhe nalamire akalamo kaani gurhengera ndi mwana omu gihugo chaani n'omu gishagala ch'eYerusaleema. ");
INSERT INTO hav_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Banyinji gurhengera miira, n'akaba bashondere, bakanahamiiriza oku nakulikiraga emigenzo yooshi y'echigusho ch'aBafarisaayo. Abo Bafarisaayo bo banagihangaana looshi gukulikira amarhegeko mooshi m'edini ly'ekiyaahudi, kulusha abandi booshi. ");
INSERT INTO hav_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Leero zeene ndi nachiirwa olushinja, bulaala nahirire obulangaalire bwani omu chilagaane Nnamahanga alaganyaga bashookuluza beerhu. ");
INSERT INTO hav_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Chiro n'abantu b'emilala yeerhu ekumi n'ebiri, nabo balangaliire oku Nnamahanga abayeenezeza echiila chilagaane. Cho girhumire bali bamukolera n'obushiru obudufu n'ezuuba. Waliha mwami, oboola bulangaalire bo burhumire aBayaahudi bansidaka zeene! ");
INSERT INTO hav_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Girhumire mwabo mwakengeera oku birhagalikeene Nnamahanga afuule abafu? ");
INSERT INTO hav_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","«Chiro naani nyenyine, nankengeera oku bimpemere nkoleese enjira zooshi, omu kulwisa eziino lya Yeesu w'eNazareeti. ");
INSERT INTO hav_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Ebyoola binajiraga eYerusaleema. Nabeere nahabwa obuhashe gurhenga emw'abakulu b'abadaahwa, nahira abemeezi banene omu munyororo. N'amango babayirhaga, naani naliyemeere oku balikwaneene kuyirhwa. ");
INSERT INTO hav_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Nalemaga naaja omu masinagoogi mooshi kubahana n'okubaseeza badukange eziino lya Yeesu. N'elugulu w'ogukaliha bweneene, nagendaga naaja kubalibuza n'omu bindi bishagala bya hale.» ");
INSERT INTO hav_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Paawulo ashuba kuderha ntya: «Lusiku luguma naliiri omu njira, eyi ndi naaja kulibuza abemeezi omu gishagala ch'eDamasiki, gukulikirana n'obuhashe n'amarhegeko m'abakulu b'abadaahwa. ");
INSERT INTO hav_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Waliha mwami, yabeere midi eyi ndi mw'eyoola njira, nabona obumoleke bwarhenga empingu. Bwali bumolekere kulusha obw'ezuuba. Bwanangorha n'abeerhu baliiri haguma naani omu lungenzi. ");
INSERT INTO hav_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Rhweshi rhwahenera ahashi. Nayunva omulenge omu lulimi lw'eGiheburaniya gwambwira ntya: ‹Saawulo, Saawulo, girhumire wandibuza? Oli wachiilibuza busha kulaala enka eshuurhanga olubaale oku songi ly'enkoni y'omungere wa yo!› ");
INSERT INTO hav_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Naja nabaza ntya: ‹Nnaweerhu, wooyo oli nde?› Naye ashubiza ntya: ‹Nyoono, ndi Yeesu, oli walibuza. ");
INSERT INTO hav_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Aliko yuumuka, oyimange! Nakubonekeere bulaala nashonda nkujire obe mukozi waani, onagende wahamiiriza ebi wabwene ko zeene n'ebindi nashuba gukuyeereka. ");
INSERT INTO hav_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Nalema nagukuula omu maboko m'abenyu Bayaahudi, n'omu m'abantu barhali Bayaahudi. Nagurhuma oku bo, ");
INSERT INTO hav_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","y'ozibuula ameesho maabo, barhenge omu mwizimya n'okuja omu bumoleke, banarhenge omu buhashe bwa Shetaani, n'oguhindamukira Nnamahanga. Omu kunyemeera, bababalirwa ebyaaha byaabo n'okuba haguma n'abandi booshi achishogere.›» ");
INSERT INTO hav_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Paawulo ashuba kuderha ntya: «Cho girhumire, waliha mwami Agiripa, ntalekaga gukenga ebi nabonekerwaga gurhenga empingu. ");
INSERT INTO hav_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Aliko, narhanga kubalira abantu b'eDamasiki oku baleke ebyaaha byaabo, banahindamukire Nnamahanga omu kujira ebijiro biyerekeene oku balekere ebyaaha byaabo. Enyuma nashuba kubalira abantu b'egishala ch'eYerusaleema, n'abantu b'ebindi bishagala byooshi by'eYudeeya n'abarhali Bayaahudi ezoola nyigirizo. ");
INSERT INTO hav_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Ebyoola byo byarhumaga aBayaahudi banfarhira omu Nju ya Nnamahanga, n'ogushonda kunyirha. ");
INSERT INTO hav_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Aliko Nnamahanga andangire guhika oku lusiku lwa zeene. Echoola cho girhumire nahamiiriza embere z'abantu bakulu n'abadoorho. Nta yindi myaazi naderhere erhali elaala abaleebi na Muusa baabalaga oku nji yaaba. ");
INSERT INTO hav_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Aba booshi, baderhere oku Krisitu alikwaneene alibuke, anabe murhanzi gufuuka omu bafu. Ntyo, nj'abala enjira y'obuchunguke oku lubaga lw'aBayaahudi n'oku barhali Bayaahudi, bagale kulama omu bumoleke.» ");
INSERT INTO hav_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Amango Paawulo abaaga achiri abuurana, Fesito amubwira ntya n'omulenge munene: «Paawulo, wasirehere! Amasomo manene wasomere makujirire musire!» ");
INSERT INTO hav_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Paawulo amushubiza ntya: «Waliha Fesito, ntali musire. Emyaazi ndi naaderha eri y'okuli enali y'akamaro. ");
INSERT INTO hav_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Chiro mwami Agiripa ayinji bwinja eyoola myaazi yooshi. Cho girhumire namubwira yo buzira buuba, bulaala menyere bwinja oku nta mwazi n'omuguma arhenji omu yo. Ebyoola byooshi birhajirikaga omu bwibisho. ");
INSERT INTO hav_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Mwami Agiripa, k'onayemeera ebinwa by'abaleebi? Nyinji bwinja oku onabiyemeera!» ");
INSERT INTO hav_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agiripa abwira Paawulo ntya: «Okengereere oku wanyemeeza kuba mukrisitu omu bishanji bigeeke!» ");
INSERT INTO hav_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Paawulo ashubiza ntya: «Bibe bigeeke, bibe binene, mpemere Nnamahanga, wooyo n'abenyu booshi bali banyunviiriza zeene, mube nka kunoola nyoono ndi, aliko buzira gushwekwa n'amaala malegule!» ");
INSERT INTO hav_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Abeere aderha ntyo, mwami Agiripa, omurhegesi Fesito, Berenike na booshi baliiri ahoola, bayimanga. ");
INSERT INTO hav_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Baaja mahwe n'ogurhondera kubwirana ntya: «Oyuula muntu ntaacho ajirire chagarhuma ahanirwa olufu changwa ogushwekwa omu munyororo.» ");
INSERT INTO hav_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Mwami Agiripa abwira omurhegesi Fesito ntya: «Byagahemere oyuula mulume ashwekuulwe nk'arhahemaga oku olushinja lwage luchiibwe na mwami mukulu Kayizaari.» ");
INSERT INTO hav_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Babeere barhoola omuhigo g'ogurhuheeka eItaliya omu chombo, bahira Paawulo haguma n'abandi bashwekwa omu bulanzi b'omukulu w'abasoda oyirikwa Yuliyo. Aliiri w'omu chigusho chiyirikwa «Chigusho ch'abasoda ba mwami mukulu Kayizaari.» ");
INSERT INTO hav_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Rhwava rhwaja omu chombo chaliiri charhenga omu gishagala ch'eAdiramiti, rhwasuka. Rhwaliiri rhwabalama haguma n'omuburhwa muguma w'omu gihugo ch'eMakedoniya oyirikwa Arisitariko, w'omu gishagala ch'eTesalonika. Echo chombo, chaliiri chaja omu bishangala by'egihugo ch'eAziya biri eburhambi bw'enyanja. ");
INSERT INTO hav_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Olusiku lwakulikiraga, rhwasiika omu gishagala ch'eSidoona. Yuliyo waliiri ajirira Paawulo amenja, amuyemeerera aje kubonana n'abeera baage yi bamuheereza byooshi alagire ko. ");
INSERT INTO hav_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Omu gurhenga eSidoona, rhwabarabanya oku chizimba ch'eGipuro, emunda omulaba gurhalikalihire, bulaala gwaliiri gwahulukira embere zerhu. ");
INSERT INTO hav_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Rhwayambuka enyanja oku lunda lw'egihugo ch'eKilikiya n'eche Pamfiliya. Rhwanahika omu gishagala ch'eMira ch'omu gihugo ch'eLikiya. ");
INSERT INTO hav_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Eyo munda, oyo mukulu w'abasoda abona echombo chaliiri charhenga omu gishagala ch'eAlegizanduriya, eyi chiri chaaja omu gihugo ch'eItaliya. Arhushoneza mo rhweshi. ");
INSERT INTO hav_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Rhwamala siku zinene oku nyanja, kwenge rhwaliiri rhwagenda kubuyaabuya. Enyuma z'amalibuko maneene, rhwahika hoofu n'egishagala ch'eKinido. Omu gurhenga eyo, rhwayeerekeza eSalimone. Rhwagera olunda lw'egarhongo k'echizimba ch'eKerete, bulaala omulaba gwaliiri gwarhuhuluka embere. ");
INSERT INTO hav_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Rhwagendeerera kugera eburhambirhambi bw'echo chizimba omu malibuko manene. Rhwahika hantu haguma hayirikwa «Siiko Zinja», hoofu n'egishagala ch'eLaseya. ");
INSERT INTO hav_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Elugulu w'okumala siku zinene oku nyanja, rhwahika omu gihe chidarhabeere n'olusiku l'oguchibuza kulya lwaliiri lwagerere. Paawulo ava arhuhanuula omu kuderha ntya: ");
INSERT INTO hav_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","«Beene beerhu, mbwene oku luno lugenzi lwadarhabaala. Rhwaheza binene, arhali mizigo yonyine sy'aliko n'echombo, chiro n'akalamo keerhu.» ");
INSERT INTO hav_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Aliko oyo mukulu w'abasoda akulikira ebinwa bya kapiteeni n'ebya nyina echombo, sy'arhakulikiraga ebinwa bya Paawulo. ");
INSERT INTO hav_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Okubona okw'eyo siiko erhaliiri nyinja amango m'emboho ekalihire, abantu banene omu chombo bayunviikana oku barhenge eyo munda, balole akaba byagalika bahike oku siiko eyirikwa Foyiniki n'okugeza ebishanji by'emboho ekalihire eyo munda. Eyoola siiko y'eFoyiniki erhuula oku chizimba ch'eKerete, eyerekeere olunda lw'ebuzikiro bw'ezuuba. ");
INSERT INTO hav_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Enyuma z'aho agahuusi gahuusahuusa gurhengerera egarhongo. Banyina echombo bakengera oku bamabona enjira y'okugendeerera n'olugenzi lwabo nk'oku balirheganyize. Bakulula enanga, babarabanya oku chizimba ch'eKerete. ");
INSERT INTO hav_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Enyuma w'ebishanji bigeeke, mw'echo chizimba mwahulukira omuyaga munene g'omulaba gukalihire guyirikwa Ehurakilo. ");
INSERT INTO hav_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Ogo muyaga gwaheka echombo, nacho chirhagalaga kugulwiisa. Rhwava rhwachileka chihekwe n'omulaba oku muhengere emunda gushondere. ");
INSERT INTO hav_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Rhwagera olunda lw'egarhongo k'echizimba chigeeke chiyiirikirwe Kauda, charhulanga bugeeke kw'ogola muyaga. Oku malibuko manene, rhwashweka bweneene obwarho oku chombo yi burhahehwa. ");
INSERT INTO hav_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Abakozi b'omu chombo babeere barhalulira obo bwarho omu chombo, baseza echombo omu kugishweka n'emikaba. Na kwenge baliyubahire oku echombo chagarhaliira omu mushenyi gw'eSiriti, barhoza egihirho chiyimanza bugeeke echombo, banaleka echombo gihehwe. ");
INSERT INTO hav_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Olusiku lwakulikiraga, omulaba gwagendeerera gushuurhashuurha bweneene echombo. Echo charhuma abo bakozi barhondera kuroha emizigo omu nyanja. ");
INSERT INTO hav_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Olusiku lwa gasharhu, bakabulanga bonyine ebikoleso by'echombo. ");
INSERT INTO hav_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Esiku zinene zagera buzira kubona ezuuba changwa enyenyeezi. Omulaba nago gwagendeerera bweneene. Oku buzinda, rhwaheza obulangaalire bw'okulama. ");
INSERT INTO hav_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Abantu babaaga bamaamala siku zinene buzira kulya kantu. Paawulo ava ayimanga ahagarhi kaabo n'okubabwira ntya: «Beera baani, nka mwakulikiraga ehano lyaani ly'ogurharhenga eKerete, rhurhakabwene ama malibuko mooshi changwa guheza ebi bintu. ");
INSERT INTO hav_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Aliko bunoola, mbahemere museeze emirhima, bulaala ntaaye ahagarhi kenyu waafa, sy'aliko echombo chonyine chashenyagulika. ");
INSERT INTO hav_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Nderhere ntya, kwenge malahika wa Nnamahanga, ola nyoono ndi waage n'ola nkolera, alimbonekere omu budufu bwa zeene. ");
INSERT INTO hav_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Amanambwira ntya: ‹Orhayubahaga Paawulo! Bihemeere obuurane embere za mwami mukulu Kayizaari. Na kandi, byasimiisize Nnamahanga kugukolera amenja. Yeewe achungula akalamo k'abaala bantu booshi bali babalama haguma naawe.› ");
INSERT INTO hav_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Cho girhumire beera baani, museeze omurhima, bulaala ndangaliire oku byajirika nk'oku Nnamahanga ambwiraga. ");
INSERT INTO hav_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Aliko, bihemere echombo chije gurhaliira oku chizimba chiguma.» ");
INSERT INTO hav_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Rhwamala siku ekumi n'ene, rhuli rhwaheekwa eyi n'eyi n'omulaba oku nyanja y'eAdiriya. Ahagarhi kw'obudufu, abakozi b'omu chombo bakengera oku rhuli hoofu n'emushengo. ");
INSERT INTO hav_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Bachimiza olugero omu menji. Gurhenga enyanya guhika oku nege, baabona metere makumi mane. Rhwabeere rhwashegera ahambere bugeeke, baashuba guchimya olugero omu menji, baabona metere makumi masharhu. ");
INSERT INTO hav_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Barhoza enanga ene z'ebwerekeza omu guchifiija obudufu buche, kwenge baliiri bayuubaha oku echombo chagarhaliira oku ntaza. ");
INSERT INTO hav_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Abakozi b'omu chombo bashonda kuyongoloka. Kw'arhuma baja bayandagaziza obwarho omu menji. Banachijirisa nka bali bashweka enanga z'emulemo. ");
INSERT INTO hav_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Paawulo aja abwira ola mukulu w'abasoda haguma n'abasoda baage ntya: «Aba bantu bagarhenga mu chino chombo, mumenye oku nenyu murhagafuma kuzika!» ");
INSERT INTO hav_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Okoola kw'arhuma abasoda bacha emikaba yalishwekere obo bwarho, banabuleka buhehwe oku nyanja. ");
INSERT INTO hav_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Yabeere emiseke, Paawulo ayinginga abantu booshi balye ebiryo. Ababwira ntya: «Zeene, siku ekumi n'ene zamagera eyi mugwerhe obuuba, na buzira kulya kantu. ");
INSERT INTO hav_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Leero mbayingingire mulye ebiryo yi murhafa n'enzara. Kwenge ntaaye ahagarhi kenyu waheza chiro n'oluviiri luguma l'oku rhwe lyaage.» ");
INSERT INTO hav_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Enyuma z'okuderha ebyo binwa, Paawulo arhoola omugati, akuuza Nnamahanga embere zaabo booshi. Aguchagulanga n'ogurhondera kulya. ");
INSERT INTO hav_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Booshi baava bachiseeza omurhima, banarhondera kulya ebiryo. ");
INSERT INTO hav_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Mw'echo chombo, rhwaliiri mo bantu magana mabiri na makumi gali mushanvu na ndarhu. ");
INSERT INTO hav_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Abantu booshi babeere bayuugurha, baroha emizigo y'engano omu nyanja omu kuyanguhya echombo. ");
INSERT INTO hav_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Bwabeere bwacha, abakozi b'omu chombo balangira eshi, aliko barharhegeeraga echo gihugo. Babona akagobe kali k'omushenyi. Baava bahiga kuja gurhaliiriza yo echombo, akaba byakagalika. ");
INSERT INTO hav_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Baacha emigozi yalishwekere enanga, banazileka zizike omu nyanja. Banashunula emigozi yalishwekere ziiri nka ngasi zizibuuzibu zaliiri zayeerekeza echombo. Oku buzinda, bazamuula omwenda gw'embere y'omuhuusi guheeke echombo, banayeerekera mw'ogo mushengo g'omushenyi. ");
INSERT INTO hav_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Aliko babeere bayegeera ahambere bugeeke, echombo charhaliira omu chilundo ch'omushenyi, girhagachigalire guchishaganya. Omulemo gwazikira mo, n'ebivundu by'omulaba byashenyagula obwerekeza. ");
INSERT INTO hav_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Abasoda bahiga kuyirha abashwekwa booshi, yi ntaaye n'omuguma mubo oyongolokage omu kuyooga. ");
INSERT INTO hav_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Aliko, omukulu w'abasoda alishondere kufumya Paawulo. Abuza abasoda barhajiraga ntyo. Arhegeka oku abayinji kuyooga, babe barhanzi guchikabula omu nyanja, bayooge banayoomokere emushengo. ");
INSERT INTO hav_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","N'abandi babakulikire, eyi bagwarhiriize oku mpaho changwa oku bisharhe by'echombo. Ntyo kw'abantu booshi bahikaga emushengo eyi bali bagumaguma. ");
INSERT INTO hav_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Rhwabeere rhwafuma olufu, rhwaja rhwamenya okw'echo chizimba rhwaliiri ko, chiyirikirwe Melita. ");
INSERT INTO hav_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Abantu b'eyo, barhujirira amenja manene. Barhuchaanira omuliro banarhuyegeereza rhweshi oku rhukaluuke, bulaala emboho yaliiri n'envula yabaaga eri yarhoga. ");
INSERT INTO hav_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Paawulo arhoola eshaali. Abeere ali azihira omu ziiko, enjoka yarhenga mu zila shaali elugulu w'egikangiira, yachizingira oku kuboko kwage. ");
INSERT INTO hav_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Abantu b'echo chizimba babeere baabona eyoola njoka yananaabire oku kuboko kwage, babwirana ntya: «Okuli oyu muntu ali mwisi w'abantu. Chiro akaba afumire olufu lw'enyanja, emaana yeerhu eyirikwa Okuli erhamuleka alame.» ");
INSERT INTO hav_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Aliko Paawulo akunguurhira eyo njoka omu lila ziiko, na ntaako abeere. ");
INSERT INTO hav_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Abo bantu, baloleereza akaba Paawulo arhunda omubiri changwa akumbagala n'ogufa ho n'aho. Balingiriza bishanji binene. Babeere baabona oku ntaako abeere, bahindamula emiganiize yaabo, banarhondera kuderha oku ali muguma w'omu maana. ");
INSERT INTO hav_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Hoofu n'ahoola, haliiri amashwa m'omukulu w'echo chizimba oyirikwa Pubuliyo. Oyo mukulu arhuyankirira bwinja omu mwage, rhwamala mo siku esharhu. ");
INSERT INTO hav_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Amo mango, eshe wa Pubuliyo alilyaamire oku buliri kwenge alilwere endwala y'eshuushira n'omukunguru. Paawulo aja kumulola, amusaliirira, anamulambuulira kw'amaboko, naye amufumya. ");
INSERT INTO hav_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Echo charuma abandi balwala booshi baliiri kw'echo chizimba, baalema bashimba Paawulo, naye alema abafumya. ");
INSERT INTO hav_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Abantu b'ahoola barhukenga bweneene. Rhwabeere rhuli hoofu kugendeerera n'olugenzi oku nyanja, barhuha ebintu byooshi rhwalikeneere. ");
INSERT INTO hav_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Rhwabeere rhwamala myeezi esharhu oku chizimba ch'eMelita, rhwabalama n'echombo chiguma chalisikiire kw'echo chizimba. Chaliiri chalinga esiku z'emboho zirhange zigere. Echo chombo, charhengereraga eAlegizanduriya. Babaaga bachapire ko ebishushanyo by'emaana z'amahasha. ");
INSERT INTO hav_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Rhwahikire omu gishagala ch'eSirakuse, rhwabeera mo siku esharhu. ");
INSERT INTO hav_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Omu gurhenga mw'echo gishagala, rhwasuka n'okugenda rhwabarabanya guhika omu gishagala ch'eRegiyo. Olusiku lwakulikiraga, omuyaga g'ogurhengerera egarhongo gwaja omu nyanja. Olwindi lusiku lwakulikiraga, rhwahika omu gishagala ch'ePuteyoli. ");
INSERT INTO hav_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Rhwahikire yo, rhwabugana abemeezi, nabo barhuyinginga mpu rhubeere nabo siku mushanvu. Ntyo ku rhwajiire eRooma. ");
INSERT INTO hav_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Abemeezi b'eRooma babeere bayunva oku rhuli omu njira y'okuja emwabo, baguma bayinja gurhulingira omu gishagala chiyirikwa Soko ly'eApiyo, n'abandi omu gishagala chiyirikwa Nju eSharhu z'aBahiisi. Paawulo abeere ababona, akuuza Nnamahanga, buzinda anashuba guseezwa omurhima. ");
INSERT INTO hav_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Rhwabeere rhwahika eRooma, bayemeerera Paawulo ahande yenyine. Banamuha omusoda w'okumulanga. ");
INSERT INTO hav_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Hagerere siku esharhu, Paawulo ahamagaza abakulu b'aBayaahudi balilamire eyo munda. Babeere babugaanana, ababwira ntya: «Bene beerhu, nyoono nalishwekerwe eYerusaleema, nanahirwa omu maboko m'aBarooma noobo nta chibi najiriire olubaga lwerhu changwa okuvuna emicho yabashookuluza beerhu. ");
INSERT INTO hav_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Abo Barooma babeere bambuuranya, bashonda kunshwekuula bulaala barhambonaga ko obubi bwalihemerwe nyirhwe. ");
INSERT INTO hav_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Aliko okubona aBayaahudi barhayemeeraga mpu ndikulwe, kw'arhuma nahema kuja eno Rooma, kubuuranira embere za mwami mukulu Kayizaari. Na mw'ebi byooshi, nta chintu naligwerhe ch'ogusidaaka olubaga lwani. ");
INSERT INTO hav_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Echoola, cho girhumire mbahamageere, rhubonane rhunaganiire haguma. Mumenye oku nyoono nshwekeerwe hano, bulaala nyemereere obulangaalire bw'aBaisraheeli booshi.» ");
INSERT INTO hav_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Abo bakulu b'aBayaahudi baava bamubwira ntya: «Rhwabo nta maruba rhwayankirire gurhengera eYudeeya, changwa omwemeezi gurhenga eyo, wahikire eno gurhubalira n'okuderha omwazi mubi elugulu waawe. ");
INSERT INTO hav_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Aliko, neerhu rhwagasiimire kuyunviiriza emiganiize yaawe, bulaala rhuyinji oku ngasi hooshi, abantu banaderha kubi eli dini lyaawe okulikiire.» ");
INSERT INTO hav_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Abo bakulu baava bayunviikana na Paawulo olusiku baashuba gushimaanana. N'oloola lusiku, bantu banene bweneene bahika aha Paawulo alihandire. Gurhengera eseezi guhika egolo, ayigiriza ebinwa binene n'okubabalira obuhamiriza elugulu w'obwime bwa Nnamahanga. Paawulo alishondere bayemeere Yeesu. Aliiri kubayeereka emyaazi ederhere elugulu wa Yeesu, eyandikirwe omu Rhegeko lya Muusa n'ebitaabu by'abaleebi. ");
INSERT INTO hav_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Eyoola myaazi Paawulo aderhaga, baguma bayiyemeera, aliko abandi barhayiyemeeraga. ");
INSERT INTO hav_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Babeere barhayunvikene, bashonda bagaluke. Paawulo ashuba kubabwira chino chinwa chiguma: «Muuka-Mutagatiifu aliderhere okuli oku bashokuluuza benyu kugerera omuleebi Isaya. ");
INSERT INTO hav_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Kwenge alimubwirire ntya: ‹Ogende emw'aba bantu, onababwire ntya: “Okuyunva mwayunva, aliko murhaamenya. Okulola mwalola, aliko murharhegeera.” ");
INSERT INTO hav_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Bulaala emirhima y'aba bantu yabeere mizibu. Bafukire amarhwi maabo, banazibize ameesho maabo. Nk'arhaliiri ntyo, ameesho maabo makabwene, n'amarhwi maabo, makayunviirhe, n'emirhima yaabo, yagarhegereere, bakanahindamukire emwani, naani nakabafumize.›» ");
INSERT INTO hav_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Paawulo ashuba kubabwira ntya: «Leero, mumenyage oku emyaazi y'obu buchunguke bwa Nnamahanga, yamayaalagazwa oku barhali Bayaahudi. Boowe, bayiyunviiriza!»  ");
INSERT INTO hav_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Abeere amala kuderha eyi myaazi, abo Bayaahudi bagenda eyi bali bajiriisanya obuhaka bunene. ");
INSERT INTO hav_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Paawulo ahanda myaaka ebiri mw'eyoola nju ahaanaga kw'efuranga yenyine. Aliiri ayankirira abahiisi booshi baliiri bayinja kumulola. ");
INSERT INTO hav_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Aliiri abala emyaazi y'obwami bwa Nnamahanga, n'okuyigiriza abantu elugulu wa Nnaweerhu Yeesu Krisitu buzira buuba na buzira kubuzwa.");
ALTER TABLE hav_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
