﻿USE sofia;
DROP TABLE IF EXISTS sofia.hauulb_vpl;
CREATE TABLE hauulb_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES hauulb_vpl WRITE;
INSERT INTO hauulb_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Littafin asalin Yesu Almasihu Dan Dauda, Dan Ibrahim. ");
INSERT INTO hauulb_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ibrahim shine mahaifin Ishaku, Ishaku shine mahaifin Yakubu, Yakubu shine mahaifin Yahuza da 'yan'uwansa. ");
INSERT INTO hauulb_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yahuza shine mahaifin Farisa da Zera, ta wurin Tamar. Farisa kuma shine mahaifin Hasruna, Hasruna kuma shine mahaifin Aram. ");
INSERT INTO hauulb_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram shine mahaifin Amminadab, Amminadab shine mahaifin Nashon, Nashon shine mahaifin Salmon. ");
INSERT INTO hauulb_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon shine mahaifin Bo'aza ta wurin Rahab, Bo'aza shine mahaifin Obida ta wurin Rut. Obida shine mahaifin Yesse, ");
INSERT INTO hauulb_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yesse shine mahaifin sarki Dauda. Sarki Dauda shine mahaifin Sulaimanu ta wurin matar Uriya. ");
INSERT INTO hauulb_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Sulaimanu shine mahaifin Rehobo'am, Rehobo'am shine mahaifin Abija, Abija shine mahaifin Asa. ");
INSERT INTO hauulb_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa shine mahaifin Yehoshafat, Yehoshafat shine mahaifin Yoram, Yoram kuma shine mahaifin Uziya. ");
INSERT INTO hauulb_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uziya shine mahaifin Yotam, Yotam shine mahaifin Ahaz, Ahaz shine mahaifin Hezekiya. ");
INSERT INTO hauulb_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hezekiya shine mahaifin Manassa, Manassa shine mahaifin Amon, sannan Amon shine mahaifin Yosiya. ");
INSERT INTO hauulb_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosiya shine mahaifin Yekoniya da 'yan'uwansa, dai dai locacin da aka kwashe su zuwa kasar Babila. ");
INSERT INTO hauulb_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Bayan kwasar su zuwa kasar Babila, Yekoniya shine mahaifin Sheyaltiyel, Sheyaltiyel shine mahaifin Zarubabel. ");
INSERT INTO hauulb_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zarubabel shine mahaifin Abihudu, Abihudu shine mahaifin Eliyakim, sannan Eliyakim shine mahaifin Azuru. ");
INSERT INTO hauulb_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azuru shine mahaifin Saduku. Saduku shine mahaifin Akimu, sannan Akimu shine mahaifin Aliyudu ");
INSERT INTO hauulb_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Aliyudu shine mahaifin Ali'azara, Ali'azara shine mahaifin Matana, sannan Matana shine mahaifin Yakubu. ");
INSERT INTO hauulb_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakubu shine mahaifin Yusufu maigidan Maryamu, wadda ta wurin ta ne aka haifi Yesu, wanda ake ce da shi Almasihu. ");
INSERT INTO hauulb_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Tun daga Ibrahim zuwa Dauda, an yi tsara goma sha hudu ne, daga Dauda zuwa lokacin da aka kwashe su zuwa Babila, tsara goma sha hudu ne, sannan daga lokacin da aka kwashe su zuwa Babila zuwa Almasihu tsara goma sha hudu ne ");
INSERT INTO hauulb_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ga yadda haihuwar Yesu Almasihu ta kasance. Mahaifiyarsa, Maryamu, tana tashi da Yusufu, amma kafin su yi aure, sai aka same ta da juna biyu ta wurin Ruhu Mai Tsarki. ");
INSERT INTO hauulb_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Mijinta, Yusufu, adalin mutum ne, amma ba ya so ya kunyatar da ita a sarari. Sai ya yi shawara ya sake ta a asirce. ");
INSERT INTO hauulb_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Yana cikin tunanin wadannan al'amura, sai mala'ikan Ubangiji ya bayyana gareshi a mafarki, ya ce masa, “Yusufu, dan Dauda, kada ka ji tsoron daukar Maryamu a matsayin matarka. Gama abinda ke cikinta, ta wurin Ruhu Mai Tsarki aka same shi. ");
INSERT INTO hauulb_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Za ta haifi Da, za ka kira sunansa Yesu, domin za ya ceci mutanensa daga zunubansu.” ");
INSERT INTO hauulb_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Duk wannan ya faru ne domin a cika abinda aka fada ta bakin annabin, cewa, ");
INSERT INTO hauulb_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Duba, budurwa za ta sami juna biyu sannan za ta haifi da, za su kira sunansa Immanuel”-ma'ana, “Allah tare da mu.” ");
INSERT INTO hauulb_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yusufu ya farka daga barci, ya yi kamar yadda mala'ikan Ubangiji ya umarce shi, sai ya dauke ta a matsayin matarsa. ");
INSERT INTO hauulb_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Amma Yusufu bai sadu da ita ba sai bayan da ta haifi da. Ya kira sunansa Yesu. ");
INSERT INTO hauulb_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Bayanda aka haifi Yesu a Baitalami ta kasar Yahudiya, a zamanin sarki Hirudus, sai ga wadansu masana daga gabas suka zo Urushalima, suna cewa, ");
INSERT INTO hauulb_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","''Ina wanda aka haifa sarkin Yahudawa? Mun ga tauraronsa a gabas mun kuma zo mu yi masa sujada.'' ");
INSERT INTO hauulb_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Da sarki Hirudus ya ji haka, sai ya damu kwarai, haka kuma dukan mutanen Urushalima. ");
INSERT INTO hauulb_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Hirudus ya tara dukan manyan firistoci da marubuta na jama'a, ya tambaye su, “Ina za a haifi Almasihun?” ");
INSERT INTO hauulb_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Suka ce masa, ''A Baitalami ne ta kasar Yahudiya, domin haka annabin ya rubuta, ");
INSERT INTO hauulb_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","'Ke kuma, Baitalami, ta kasar Yahudiya, ba ke ce mafi kankanta ba a cikin shugabanin Yahudiya, domin daga cikin ki mai mulki zai fito wanda zai zama makiyayin jama'a ta Isra'ila.''' ");
INSERT INTO hauulb_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Sai Hirudus ya kira masanan a asirce ya tambaye su aininhin lokacin da tauraron ya bayyana. ");
INSERT INTO hauulb_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ya aike su Baitalami, ya ce, ''Ku je ku binciko mani dan yaron da kyau. Idan kun same shi, ku kawo mani labari, don ni ma in je in yi masa sujada.” ");
INSERT INTO hauulb_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Bayan sun ji maganar sarkin, sai suka yi tafiyar su, ga shi kuwa, tauraron da suka gani a gabas yana tafe a gaban su, har ya zo ya tsaya bisa inda dan yaron nan yake. ");
INSERT INTO hauulb_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Da suka ga tauraron, sai suka yi matukar farin ciki. ");
INSERT INTO hauulb_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Sai suka shiga gidan, suka ga dan yaron tare da mahaifiyarsa Maryamu. Suka rusuna gabansa suka yi masa sujada. Sa'an nan suka kwance kayansu, suka mika masa kyautar su ta zinariya da lubban, da mur. ");
INSERT INTO hauulb_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Allah kuma ya gargade su a mafarki kada su koma wurin Hirudus, sai suka koma kasarsu ta wata hanya dabam. ");
INSERT INTO hauulb_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Bayan sun tashi, sai ga wani mala'ikan Ubangiji ya bayyana ga Yusufu a mafarki, ya ce, ''Tashi, ka dauki dan yaron da mahaifiyarsa, ka gudu zuwa kasar Masar, ka zauna a can sai na fada maka, don Hirudus yana shirin binciko dan yaron ya hallaka shi.” ");
INSERT INTO hauulb_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","A wannan dare fa Yusufu ya tashi ya dauki dan yaron da mahafiyarsa ya tafi Masar. ");
INSERT INTO hauulb_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ya zauna a can har mutuwar Hirudus. Wannan kuwa domin a cika abin da Ubangiji ya fada ne ta bakin annabin, ''Daga Masar na kirawo Da na.'' ");
INSERT INTO hauulb_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Da Hirudus ya ga masanan nan sun shashantar da shi, sai ya hasala kwarai, ya aika a karkashe dukan 'yan yara maza da suke Baitalami da kewayenta, daga masu shekara biyu zuwa kasa, gwargwadon lokacin da ya tabbatar a gun masanan. ");
INSERT INTO hauulb_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","A lokacin ne aka cika fadar Annabi Irmiya, ");
INSERT INTO hauulb_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","''An ji wata murya a Rama, tana kuka da bakin ciki mai zafi, Rahila ce take kuka saboda 'ya'yanta, kuma ta ki ta ta'azantu, domin ba su. ");
INSERT INTO hauulb_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Sa'adda Hirudus ya mutu, sai ga mala'ikan Ubangiji ya bayyana ga Yusufu a mafarki a Masar ya ce, ");
INSERT INTO hauulb_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","''Tashi ka dauki dan yaron da mahaifiyarsa, ka tafi kasar Isra'ila, domin masu neman ran dan yaron sun mutu.'' ");
INSERT INTO hauulb_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Yusufu ya tashi, ya dauki dan yaron da mahaifiyarsa, ya zo kasar Isra'ila. ");
INSERT INTO hauulb_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Amma da ya ji Arkilayus ya gaji mahaifinsa Hirudus, yana mulkin kasar Yahudiya, sai ya ji tsoron isa can. Bayan da Allah ya yi masa gargadi a mafarki, sai ya ratse zuwa kasar Galili ");
INSERT INTO hauulb_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","sai ya je ya zauna a wani gari da ake kira Nazarat. Wannan ya cika abin da aka fada ta bakin annabawa, cewa, za a kira shi Banazare. ");
INSERT INTO hauulb_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","A kwanakin nan Yahaya Mai baftisma ya zo, yana wa'azi a jejin Yahudiya yana cewa, ");
INSERT INTO hauulb_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Ku tuba, domin mulkin sama ya kusa.” ");
INSERT INTO hauulb_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Wannan shine wanda annabi Ishaya ya yi maganarsa, ya ce, “Muryar wani mai kira a jeji yana cewa, 'Ku shirya wa Ubangiji hanyarsa, ku daidaita tafarkunsa.'' ");
INSERT INTO hauulb_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yahaya kuwa yana sanye da tufa ta gashin rakumi, yana kuma daure da damarar fata, abincinsa kuwa fara ne da zuman jeji. ");
INSERT INTO hauulb_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Sai mutanen Urushalima, da na dukan Yahudiya, da na duk kasashen bakin Kogin Urdun, suka yi ta zuwa wurin sa. ");
INSERT INTO hauulb_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ya yi masu baftisma a Kogin Urdun, yayinda suke furta zunubansu. ");
INSERT INTO hauulb_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Amma da ya ga Farisawa da Sadukiyawa da yawa, suna fitowa domin a yi masu baftisma, sai ya ce masu, “Ku 'ya'yan macizai masu dafi, wa ya gargade ku ku guje wa fushi mai zuwa? ");
INSERT INTO hauulb_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ku ba da 'ya'ya da za su nuna tubanku. ");
INSERT INTO hauulb_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Kada kuwa ku dauka a ranku cewa, 'Ibrahim ne ubanmu.' Domin ina gaya maku, Allah yana da iko ya ta da wa Ibrahim 'ya'ya daga cikin duwatsun nan. ");
INSERT INTO hauulb_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ko yanzu ma an sa gatari a gindin bishiyoyin. Saboda haka duk bishiyar da ba ta ba da 'ya'ya masu kyau ba, sai a sare ta a jefa a wuta. ");
INSERT INTO hauulb_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Na yi maku baftisma da ruwa, zuwa tuba. Amma mai zuwa baya na, ya fi ni girma, wanda ko takalmansa ma ban isa in dauka ba. Shi ne zai yi maku baftisma da Ruhu Mai Tsarki, da kuma wuta. ");
INSERT INTO hauulb_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Kwaryar shikarsa na hannunsa, zai kuwa share masussukarsa sarai, ya tara alkamarsa ya sa a rumbunsa, amma zai kona buntun da wutar da ba za a iya kashewa ba.” ");
INSERT INTO hauulb_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Sai Yesu ya zo daga kasar Galili, ya je Kogin Urdun wurin Yahaya, domin ya yi masa baftisma. ");
INSERT INTO hauulb_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Amma Yahaya ya yi ta kokarin ya hana shi, yana cewa, “Ni da nake bukatar ka yi mani baftisma, ka zo gare ni?” ");
INSERT INTO hauulb_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yesu ya amsa masa ya ce, “Bari ya zama haka a yanzu, domin a cika dukan adalci.” Sai Yahaya ya yarje masa. ");
INSERT INTO hauulb_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Bayan da aka yi masa baftisma, Yesu ya fito nan da nan daga cikin ruwan, sai kuma sammai suka bude masa. Ya ga Ruhun Allah yana saukowa kamar kurciya, ya sauko a kansa. ");
INSERT INTO hauulb_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Duba, wata murya daga sammai tana cewa, ''Wannan shi ne kaunataccen Da na. Wanda ya gamshe ni sosai.'' ");
INSERT INTO hauulb_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Sa'an nan Ruhu ya bi da Yesu zuwa cikin jeji, domin Ibilis ya gwada shi. ");
INSERT INTO hauulb_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Da ya yi azumi kwana arba'in dare da rana, daga baya yunwa ta kama shi. ");
INSERT INTO hauulb_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Sai mai jarabtar nan ya zo, ya ce masa, “Idan kai Dan Allah ne, ka umarci duwatsun nan su zama gurasa.” ");
INSERT INTO hauulb_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Amma Yesu ya amsa ya ce masa, “A rubuce yake cewa, 'Ba da gurasa kadai mutum zai rayu ba, sai dai da kowace magana da ta ke fitowa daga wurin Allah.''' ");
INSERT INTO hauulb_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Sa'an nan Ibilis ya kai shi tsattsarkan birni ya dora shi can kan kololuwar ginin haikali, ");
INSERT INTO hauulb_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ya ce masa, “In kai Dan Allah ne, to dira kasa. Domin a rubuce yake cewa, 'Zai ba mala'ikunsa umarni game da kai,' kuma, 'Za su daga ka da hannuwansu, domin kada ka yi tuntube da dutse.''' ");
INSERT INTO hauulb_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesu ya ce masa, “kuma a rubuce yake, 'Kada ka gwada Ubangiji Allahnka.''' ");
INSERT INTO hauulb_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Kuma, sai Ibilis ya kai shi kan wani dutse mai tsawo kwarai, ya nuna masa dukan mulkokin duniya da darajarsu. ");
INSERT INTO hauulb_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ya ce masa, “Dukan wadannan zan baka idan ka rusuna ka yi mani sujada.'' ");
INSERT INTO hauulb_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Sai Yesu ya ce masa, “Tafi daga nan, Shaidan! Domin a rubuce yake, 'Ka yi wa Ubangiji Allahnka sujada, shi kadai za ka bauta wa.''' ");
INSERT INTO hauulb_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Sa'an nan Ibilis ya rabu da shi, sai kuma mala'iku suka zo suka yi masa hidima. ");
INSERT INTO hauulb_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","To, da Yesu ya ji an kama Yahaya, sai ya tashi zuwa kasar Galili. ");
INSERT INTO hauulb_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ya bar Nazarat, ya koma Kafarnahum da zama, can bakin tekun Galili, kan iyakar kasar Zabaluna da Naftali. ");
INSERT INTO hauulb_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Wannan ya faru domin a cika fadar annabi Ishaya cewa, ");
INSERT INTO hauulb_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Kasar Zabaluna da kasar Naftali, ta bakin teku, da hayin Kogin Urdun, Galili ta al'ummai! ");
INSERT INTO hauulb_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Mutane mazauna duhu suka ga babban haske, sannan ga wadanda ke zaune a yankin da inuwar mutuwa, haske ya keto masu.” ");
INSERT INTO hauulb_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Daga lokacin nan, Yesu ya fara wa'azi, yana cewa, “Ku tuba domin mulkin sama ya kusa.” ");
INSERT INTO hauulb_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yana tafiya a bakin tekun Galili, sai ya ga wadansu 'yan'uwa biyu, Saminu da ake kira Bitrus, da dan'uwansa Andarawas, suna jefa taru a teku, domin su masunta ne. ");
INSERT INTO hauulb_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesu ya ce masu, “Ku zo, ku biyo ni, zan mai da ku masuntan mutane.” ");
INSERT INTO hauulb_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Nan da nan sai suka bar tarunsu, suka bi shi. ");
INSERT INTO hauulb_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Da Yesu ya ci gaba da tafiya, sai ya ga wadansu mutum biyu, su kuma 'yan'uwa ne, Yakubu dan Zabadi, da dan'uwansa Yahaya, suna cikin jirgi tare da mahaifinsu Zabadi, suna gyaran tarunsu. Sai ya kira su. ");
INSERT INTO hauulb_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Nan take suka bar mahaifinsu da jirgin, suka bi shi. ");
INSERT INTO hauulb_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu ya zazzaga dukan kasar Galili, yana koyarwa a majami'unsu, yana shelar bisharar mulkin, yana kuma warkar da kowace cuta da rashin lafiya a cikin mutane. ");
INSERT INTO hauulb_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Labarinsa ya bazu a cikin dukan kasar Suriya, kuma mutanen suka kakkawo masa dukan marasa lafiya, masu fama da cuta iri iri, da masu shan azaba, da kuma masu aljannu, da masu farfadiya, da shanyayyu. Yesu ya warkar da su. ");
INSERT INTO hauulb_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Taro masu yawa suka bi shi daga kasar Galili, da Dikafolis, da Urushalima, da kasar Yahudiya, har ma daga hayin Urdun. ");
INSERT INTO hauulb_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Da Yesu ya ga taron jama'ar, sai ya hau saman dutse. Sa'adda ya zauna, almajiransa suka zo wurinsa. ");
INSERT INTO hauulb_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ya bude bakinsa kuma ya koyar da su, yana cewa, ");
INSERT INTO hauulb_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Albarka ta tabbata ga masu talauci a ruhu, domin mulkin sama nasu ne. ");
INSERT INTO hauulb_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Albarka ta tabbata ga masu makoki, domin za a ta'azantar da su. ");
INSERT INTO hauulb_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Albarka ta tabbata ga masu tawali'u, domin za su gaji duniya. ");
INSERT INTO hauulb_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Albarka ta tabbata ga masu yunwa da kishin adalci, domin za a kosar da su. ");
INSERT INTO hauulb_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Albarka ta tabbata ga masu jinkai, domin za su samu jinkai. ");
INSERT INTO hauulb_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Albarka ta tabbata ga masu tsabtar zuciya, domin za su ga Allah. ");
INSERT INTO hauulb_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Albarka ta tabbata ga masu kawo salama, domin za a ce da su 'ya'yan Allah. ");
INSERT INTO hauulb_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Albarka ta tabbata ga wadanda ake tsananta masu saboda adalci, domin mulkin sama nasu ne. ");
INSERT INTO hauulb_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Masu albarka ne ku sa'adda mutane suka zage ku, suka kuma tsananta maku, ko kuwa suka zarge ku da dukan miyagun abubuwa iri iri na karya, saboda ni. ");
INSERT INTO hauulb_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ku yi murna da matukar farin ciki, domin sakamakonku mai yawan gaske ne a sama. Ta haka ne mutane suka tsananta wa annabawa da suka yi rayuwa kafin ku. ");
INSERT INTO hauulb_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Ku ne gishirin duniya, amma idan gishiri ya sane yaya za a mai da dandanonsa? Ba zai kara anfani ga komai ba, sai ko a zubar da shi, a tattake a karkashin kafafun mutane. ");
INSERT INTO hauulb_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ku ne hasken duniya, birnin da ke kan tudu ba shi boyuwa. ");
INSERT INTO hauulb_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Mutane ba za su kunna fitila su sa ta karkashin kwando ba, sai ko a dora ta a mazaunin ta, domin ta ba da haske ga kowa da ke gidan. ");
INSERT INTO hauulb_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Bari hasken ku ya haskaka gaban mutane yadda za su ga kyawawan ayyukanku su kuma yabi Ubanku da ke cikin sama. ");
INSERT INTO hauulb_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Kada ku yi tsammanin na zo ne domin in rushe shari'a ko annabawa. Ban zo domin in rushe su ba, amma domin in cika su. ");
INSERT INTO hauulb_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Domin gaskiya ina gaya maku, har sama da kasa su shude, amma digo ko wasali daya ba za ya shude ba a cikin shari'ar, sai an cika dukan al'amura. ");
INSERT INTO hauulb_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Saboda haka duk wanda ya karya mafi kankanta daga cikin dokokin nan ko kuwa ya koya wa wasu su yi haka, za a kira shi mafi kankanta a cikin mulkin sama. Amma dukan wanda ya kiyaye su ko kuwa ya koyar da su, za a kira shi mafi girma a cikin mulkin sama. ");
INSERT INTO hauulb_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Gama ina gaya maku cewa idan adalcin ku bai zarce adalcin marubuta da Farisawa ba, babu yadda za ku shiga mulkin sama. ");
INSERT INTO hauulb_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Kun ji dai an ce wa mutanen da, 'Kada ka yi kisan kai,' kuma 'Duk wanda ya yi kisan kai yana cikin hatsarin hukunci.' ");
INSERT INTO hauulb_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Amma ina gaya muku, duk wanda ya yi fushi da dan'uwansa, yana cikin hatsarin hukunci. Kuma duk wanda ya ce da dan'uwansa, 'Kai mutumin banza!' yana cikin hatsarin tsayawa gaban majalisa, kowa kuma ya ce da dan'uwan sa 'Kai wawa!' yana cikin hatsarin shiga wutar jahannama. ");
INSERT INTO hauulb_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Saboda haka idan za ka yi baiko a bagadi sai ka tuna cewa dan'uwanka yana da damuwa da kai, ");
INSERT INTO hauulb_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ka bar baikon ka a gaban bagadin, ka yi tafiyarka. Da farko dai, ka sasanta da dan'uwanka kafin ka zo ka mika baikon. ");
INSERT INTO hauulb_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Ka yi sulhu da mai karar ka tun kana hanyar zuwa gaban shari'a, domin kada mai karar ka ya mika ka ga alkali, alkali kuwa ya mika ka ga dogarai, za a kuwa jefa ka a kurkuku. ");
INSERT INTO hauulb_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Gaskiya ina gaya maka, ba za ka taba fita daga can ba sai ko ka biya dukan kudin da ya ke binka. ");
INSERT INTO hauulb_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Kun dai ji an ce, 'Kada ka yi zina'. ");
INSERT INTO hauulb_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Amma ina gaya maku, duk wanda ya dubi mace, da muguwar sha'awa, ya riga ya yi zina da ita a zuciyarsa. ");
INSERT INTO hauulb_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Idan idonka na dama zai sa ka tuntube, kwakule shi ka jefar daga gareka. Don gara daya daga cikin gabobinka ya halaka, da a jefa dukan jikin ka a jahannama. ");
INSERT INTO hauulb_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ko kuwa idan hannunka na dama zai sa ka tuntube, ka yanke shi ka jefar daga gare ka. Domin gara daya daga cikin gabobin ka ya halaka, da a jefa dukan jikinka a jahannama. ");
INSERT INTO hauulb_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","An sake fada, 'Duk wanda ya kori matarsa, sai ya ba ta takaddar saki.' ");
INSERT INTO hauulb_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Amma ina gaya maku ko wa ya saki matarsa, idan ba a kan laifin lalata ba, ya mai da ita mazinaciya kenan. Kuma duk wanda ya aure ta bayan sakin, ya yi zina kenan. ");
INSERT INTO hauulb_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Kun sake ji an ce wa wadan da suke a zamanin da, 'Kada ku yi rantsuwar karya, amma ku yi rantsuwar ku ga Ubangiji.' ");
INSERT INTO hauulb_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Amma ina gaya maku, kada ku yi rantsuwa sam, ko da sama domin kursuyin Allah ne; ");
INSERT INTO hauulb_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ko kuwa da duniya, domin mazaunin kafafunsa ne, ko da Urushalima, domin birnin babban sarki ne. ");
INSERT INTO hauulb_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ko ma ace ku yi rantsuwa da kanku, domin ba za ku iya mai da gashin kanku baki ko fari ba. ");
INSERT INTO hauulb_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Amma bari maganarku ta zama 'I, I', ko kuwa 'A'a, a'a.' Duk abin da ya wuce wannan, daga mugun yake. ");
INSERT INTO hauulb_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Kun dai ji an ce, “Ido a maimakon ido, hakori kuma a maimakon hakori.' ");
INSERT INTO hauulb_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Amma ina gaya maku, kada ku yi jayayya da wanda ke mugu, a maimakon haka, ko wa ya mare ku a kuncin dama, ku juya masa dayan ma. ");
INSERT INTO hauulb_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Idan wani yana da niyyar kai kararku gaban shari'a saboda ya karbi rigarku, ku ba wannan mutumin mayafinku ma. ");
INSERT INTO hauulb_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Duk wanda ya tilasta ku ga tafiyar mil daya, ku je da shi biyu. ");
INSERT INTO hauulb_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ku ba kowa da ya tambaye ku, kuma kada ku hana kowa da ke neman rance a wurinku. ");
INSERT INTO hauulb_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Kun ji abin da aka fada, 'Za ka kaunaci makwabcin ka ka ki magabcin ka.' ");
INSERT INTO hauulb_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Amma ina gaya maku, ku kaunaci magabtan ku, ku yi addu'a domin masu tsananta maku, ku albarkaci wadanda suka la'ance ku, ku yi alheri ga wadanda suke kin ku, ");
INSERT INTO hauulb_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","domin ku zama 'ya'yan Ubanku da ke cikin sama. Domin yakan sa rana ta haskaka wa mugu da mutumin kirki, kuma yakan aiko da ruwan sama ga adali da azzalumi. ");
INSERT INTO hauulb_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Domin idan kuna kaunar wadanda suke kaunarku, wanne lada kuka samu? Ba haka masu karban haraji ma suke yi ba? ");
INSERT INTO hauulb_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Kuma in kun gaida 'yan'uwanku kadai, me kuke yi fiye da sauran? Ba hakanan al'ummai ma suke yi ba? ");
INSERT INTO hauulb_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Saboda haka, lalle ne ku zama cikakku, kamar yadda Ubanku na sama yake cikakke. ");
INSERT INTO hauulb_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Ku yi hankali kada ku yi ayyukan adalcinku gaban mutane domin su ganku, idan kun yi haka, ba za ku sami sakamako a wurin Ubanku da yake sama ba. ");
INSERT INTO hauulb_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Saboda haka, in za ku yi sadaka, kada ku busa kaho yadda munafukai suke yi a majami'u da kuma akan tituna domin mutane su yabesu. Gaskiya ina gaya maku, sun samu ladansu. ");
INSERT INTO hauulb_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Amma in za ku yi sadaka, kada hannunku na hagu ya san abin da hannunku na dama yake yi, ");
INSERT INTO hauulb_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","domin sadakarku ta zama a asirce. Ubanku kuwa da yake ganin abin da ake yi a asirce, zai saka maku. ");
INSERT INTO hauulb_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Sa'adda za ku yi addu'a kuma, kada ku zama kamar munafukai, domin sun cika son yin addu'a a tsaye a majami'unsu da kuma a gefen tituna, domin mutane su gansu. Gaskiya ina gaya maku, sun sami ladarsu kenan. ");
INSERT INTO hauulb_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Amma ku, idan za ku yi addu'a, sai ku shiga cikin daki. Ku rufe kofa, ku yi addu'a ga Ubanku wanda yake a asirce, Ubanku kuwa da ke ganin abin da ake yi a asirce, zai saka maku. ");
INSERT INTO hauulb_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Idan za ku yi addu'a, kada ku yi ta maimaici marar anfani, kamar yadda al'ummai suke yi, domin a tunanin su za a saurare su saboda yawan maganganunsu. ");
INSERT INTO hauulb_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Domin haka, kada ku zama kamarsu, domin Ubanku ya san bukatar ku tun kafin ku roke shi. ");
INSERT INTO hauulb_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Saboda haka sai ku yi addu'a kamar haka: 'Ubanmu da ke sama, bari a tsarkake sunanka. ");
INSERT INTO hauulb_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Bari mulkinka shi zo. Bari nufinka ya yiwu a duniya kamar yadda ake yi a sama. ");
INSERT INTO hauulb_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ka ba mu yau abincinmu na kullum. ");
INSERT INTO hauulb_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ka gafarta mana basussukanmu, kamar yadda mu ma muke gafarta ma wadanda muke bi bashi. ");
INSERT INTO hauulb_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Kuma kada ka kawo mu cikin jaraba, amma ka kubutar da mu daga Mugun.' Gama mulki da iko da daukaka naka ne har abada. Amin ");
INSERT INTO hauulb_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Domin in kun yafe wa mutane laifuffukansu, Ubanku na Sama shima zai yafe maku. ");
INSERT INTO hauulb_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","In kuwa ba ku yafe wa mutane laifuffukansu ba, Ubanku ma ba zai yafe muku laifuffukanku ba.” ");
INSERT INTO hauulb_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Haka kuma, in za ku yi azumi, kada ku zama da fuska kamar masu makoki yadda munafukai ke yi, domin sukan yankwane fuskokinsu, domin su bayyana ga mutane kamar suna azumi. Gaskiya, ina gaya maku, sun sami ladansu ke nan. ");
INSERT INTO hauulb_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Amma in kuna azumi, ku shafa mai a ka, ku kuma wanke fuska, ");
INSERT INTO hauulb_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","don kada mutane su gane kuna azumi, sai dai Ubanku da yake a asirce. Kuma Ubanku da ke ganin abinda ke a asirce, zai saka maku.” ");
INSERT INTO hauulb_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Kada ku tara wa kanku dukiya a duniya, inda asu da tsatsa ke batawa, inda barayi kuma ke fasawa su yi sata. ");
INSERT INTO hauulb_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Maimakon haka, ku tara wa kanku dukiya a sama, inda babu asu da tsatsa da za su bata, inda kuma ba barayi da za su fasa su yi sata. ");
INSERT INTO hauulb_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Domin inda dukiyar ka take, a nan zuciyar ka ma take. ");
INSERT INTO hauulb_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Ido shi ne fitilar jiki. Saboda haka, idan idonka na da kyau, dukan jiki na cike da haske. ");
INSERT INTO hauulb_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Amma in idonka na da lahani, dukan jiki na cike da duhu. Saboda haka, in hasken da yake cikinka duhu ne, ina misalin yawan duhun! ");
INSERT INTO hauulb_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Ba mai iya bauta wa iyayengiji biyu, ko dai ya ki daya, ya so daya, ko kuma ya amince wa dayan ya raina dayan. Ba dama ku bauta wa Allah da kuma dukiya. ");
INSERT INTO hauulb_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Saboda haka ina gaya maku, kada ku damu a kan rayuwarku, game da abin da za ku ci, da abin da za ku sha- ko kuwa jikinku, abin da za ku yi tufafi da shi. Ashe rai bai fi abinci ba, jiki kuma bai fi tufafi ba? ");
INSERT INTO hauulb_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ku dubi tsuntsayen da ke sararin sama. Ai, ba su shuka, balle girbi, ba su kuma tarawa a cikin rumbuna, amma Ubanku na Sama na ciyar da su. Ashe, ba ku fi su martaba ba? ");
INSERT INTO hauulb_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Kuma wanene a cikinku, don damuwarsa, zai iya kara ko taki ga tsawon rayuwarsa? ");
INSERT INTO hauulb_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","To, don me kuke damuwa a kan tufafi? Ku dubi furannin jeji, yadda suke girma. Ba su aiki, kuma ba su sakar kaya. ");
INSERT INTO hauulb_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Duk da haka ina gaya maku, ko Sulaimanu ma, cikin dukan daukakar sa bai yi ado kamar daya daga cikin wadannan ba. ");
INSERT INTO hauulb_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Idan Allah yayi wa ciyawar jeji ado, wadda yau tana wanzuwa, gobe kuwa a jefa ta cikin murhu, ina misalin adon da za ya yi maku, ya ku masu karancin bangaskiya? ");
INSERT INTO hauulb_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Don haka kada ku damu, kuna cewa, 'Me za mu ci? ko, Me za mu sha?' ko kuwa, 'Wadanne tufafi za mu sa?' ");
INSERT INTO hauulb_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ai, al'ummai ma suna neman dukan irin wadannan abubuwa, Ubanku na sama kuwa ya san kuna bukatarsu. ");
INSERT INTO hauulb_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Amma ku nemi mulkinsa da farko da adalcinsa, kuma dukan wadannan abubuwa za a baku. ");
INSERT INTO hauulb_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","“Saboda haka kada ku damu don gobe, ai, gobe za ta damu da kanta. Kowace rana ta na cike da wahalarta”. ");
INSERT INTO hauulb_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Kada ku yi hukunci, domin ku ma kada a hukunta ku. Domin da irin hukuncin da ku kan hukunta da shi za a hukunta ku. ");
INSERT INTO hauulb_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Mudun da kukan auna, da shi za a auna maku. ");
INSERT INTO hauulb_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Don me kake duban dan hakin da ke idon dan'uwanka, amma ba ka kula da gungumen da ke naka idon ba? ");
INSERT INTO hauulb_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ko kuwa yaya za ka iya ce wa dan'uwanka, 'Bari in cire maka dan hakin da ke idon ka,' alhali ga gungume a cikin naka idon? ");
INSERT INTO hauulb_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Kai munafiki! Ka fara cire gungumen da ke idonka, sa'annan za ka iya gani sosai yadda za ka cire dan hakin da ke idon dan'uwanka. ");
INSERT INTO hauulb_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Kada ku ba karnuka abin da ke tsattsarka. Kada kuma ku jefa wa aladu, lu'u lu'anku. Idan ba haka ba za su tattake su a karkashin sawunsu, su kuma juyo su kekketa ku. ");
INSERT INTO hauulb_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Roka, kuma za a ba ku. Nema, kuma za ku samu. Kwankwasa kuma za a bude maku. ");
INSERT INTO hauulb_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ai duk wanda ya roka, zai karba, kuma duk wanda ya nema zai samu, wanda ya kwankwasa kuma za a bude masa. ");
INSERT INTO hauulb_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ko, kuwa wane mutum ne a cikin ku, dan sa zai roke shi gurasa, ya ba shi dutse? ");
INSERT INTO hauulb_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ko kuwa in ya roke shi kifi, zai ba shi maciji? ");
INSERT INTO hauulb_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Saboda haka, idan ku da ku ke miyagu, kun san yadda za ku ba da kyautai masu kyau ga 'ya'yanku, ina kimanin yadda Ubanku na sama zai ba da abubuwa masu kyau ga duk wadanda suke rokon sa? ");
INSERT INTO hauulb_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Saboda haka, duk abinda ku ke so mutane su yi maku, ku ma sai ku yi masu, domin wannan shi ne dukan shari'a da koyarwar annabawa. ");
INSERT INTO hauulb_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Ku shiga ta matsattsiyar kofa, don kofar zuwa hallaka na da fadi, hanyar ta mai saukin bi ce, masu shiga ta cikin ta suna da yawa. ");
INSERT INTO hauulb_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Domin kofar zuwa rai matsattsiya ce, hanyar ta mai wuyar bi ce, masu samun ta kuwa kadan ne. ");
INSERT INTO hauulb_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Ku kula da annabawan karya, wadanda su kan zo maku da siffar tumaki, amma a gaskiya kyarketai ne masu warwashewa. ");
INSERT INTO hauulb_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Za ku gane su ta irin ''ya'yansu. Mutane na cirar inabi a jikin kaya, ko kuwa baure a jikin sarkakkiya? ");
INSERT INTO hauulb_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Haka kowanne itace mai kyau yakan haifi kyawawan 'ya'ya, amma mummunan itace kuwa yakan haifi munanan 'ya'ya. ");
INSERT INTO hauulb_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Kyakkyawan itace ba zai taba haifar da munanan 'ya'ya ba, haka kuma mummunan itace ba zai taba haifar da kyawawan 'ya'ya ba. ");
INSERT INTO hauulb_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Duk itacen da ba ya ba da 'ya'ya masu kyau, sai a sare shi a jefa a wuta. ");
INSERT INTO hauulb_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Domin haka, ta irin 'ya'yansu za a gane su. ");
INSERT INTO hauulb_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Ba duk mai ce mani, 'Ubangiji, Ubangiji,' ne, zai shiga mulkin sama ba, sai dai wanda ya yi nufin Ubana da yake cikin sama. ");
INSERT INTO hauulb_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","A ranar nan da yawa za su ce mani, 'Ubangiji, Ubangiji,' ashe ba mu yi annabci da sunanka ba, ba mu fitar da aljanu da sunanka ba, ba mu kuma yi manyan ayyuka masu yawa da sunanka ba?' ");
INSERT INTO hauulb_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Sa'annan zan ce masu 'Ni ban taba saninku ba! Ku rabu da ni, ku masu aikata mugunta!' ");
INSERT INTO hauulb_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Saboda haka, dukan wanda yake jin maganata, yake kuma aikata ta, za a kwatanta shi da mutum mai hikima, wanda ya gina gidan sa a bisa dutse. ");
INSERT INTO hauulb_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Da ruwa ya sauko, ambaliyar ruwa ta zo, iska ta taso ta buga gidan, amma bai fadi ba, domin an gina shi bisa dutse. ");
INSERT INTO hauulb_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Amma duk wanda ya ji maganar nan tawa, bai aikata ta ba, za a misalta shi da wawan mutum da ya gina gidansa a kan rairayi. ");
INSERT INTO hauulb_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ruwa ya sauko, ambaliyar ruwa ta zo, sai iska ta taso ta buga gidan. Sai kuma ya rushe, ya kuwa yi cikakkiyar ragargajewa.'' ");
INSERT INTO hauulb_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ya zama sa'adda Yesu ya gama fadin wadannan maganganu, sai taro suka yi mamakin koyarwarsa, ");
INSERT INTO hauulb_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Domin yana koya masu da iko, ba kamar marubuta ba. ");
INSERT INTO hauulb_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Da Yesu ya sauko daga dutsen, sai taro masu yawa suka bi shi. ");
INSERT INTO hauulb_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Sai wani kuturu ya zo gunsa ya yi masa sujada, ya ce, “Ubangiji, in dai ka yarda, za ka iya tsarkake ni.” ");
INSERT INTO hauulb_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesu ya mika hannunsa ya taba shi, ya ce, “Na yarda, ka tsarkaka.” Nan da nan aka tsarkake shi daga kuturtarsa. ");
INSERT INTO hauulb_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yesu ya ce masa, 'Ka tabbata, ba ka gaya wa kowa komai ba. Sai dai ka je ka nuna kan ka ga firist, ka kuma bayar da baiko da Musa ya umarta domin shaida garesu? ");
INSERT INTO hauulb_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Da Yesu ya shiga kafarnahum, sai wani hafsa ya zo gunsa ya roke shi, ");
INSERT INTO hauulb_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Ya ce, Ubangiji, bawana na kwance shanyayye a gida, yana shan azaba kwarai.” ");
INSERT INTO hauulb_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesu ya ce masa, “Zan zo in warkar da shi.” ");
INSERT INTO hauulb_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Sai hafsan, ya ce, “Ubangiji, ban isa har ka zo gida na ba, amma sai ka yi magana kawai, bawana kuwa zai warke. ");
INSERT INTO hauulb_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Domin ni ma ina karkashin ikon wani ne, ina kuma da sojoji a karkashina, sai in ce wa wannan, 'je ka,' sai ya je, wani kuma in ce masa, 'zo,' sai ya zo, in ce wa bawa na, 'yi abu kaza,' sai ya yi,” ");
INSERT INTO hauulb_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Da Yesu ya ji haka, sai ya yi mamaki, har ya ce wa mabiyansa, “Gaskiya, ina gaya maku, ko a cikin isra'ila ban taba samun bangaskiya mai karfi irin wannan ba. ");
INSERT INTO hauulb_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Na gaya maku, da yawa za su zo daga gabas da yamma, su zauna cin abinci tare da Ibrahim da Ishaku, da Yakubu a cikin mulkin sama. ");
INSERT INTO hauulb_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Amma 'ya'yan mulkin kuwa sai a jefa su cikin matsanancin duhu. Can za su yi kuka da cizon hakora.” ");
INSERT INTO hauulb_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yesu ya ce wa hafsan, “Je ka! Bari ya zamar maka gwargwadon bangaskiyar da ka yi,” A daidai wannan sa'a bawansa ya warke. ");
INSERT INTO hauulb_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Da Yesu ya shiga gidan Btrus, sai ya ga surukar Bitrus tana kwance da zazzabi. ");
INSERT INTO hauulb_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yesu ya taba hannunta, zazzabin ya sake ta, ta kuma tashi ta fara yi masa hidima. ");
INSERT INTO hauulb_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Da maraice ya yi, sai mutanen suka kakkawo wa Yesu masu aljanu da yawa. Da magana kawai ya fitar da aljanun, ya kuma warkar da dukan marasa lafiya. ");
INSERT INTO hauulb_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ta haka kuwa maganar annabi Ishaya ta samu cika cewa, “Shi da kansa ya debe rashin lafiyar mu, ya dauke cututtukan mu.” ");
INSERT INTO hauulb_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Sa'adda Yesu ya ga taro masu yawa kewaye da shi, sai ya ba da umarni su tafi su koma wancan hayi na tekun Galili. ");
INSERT INTO hauulb_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Sai wani marubuci ya zo ya ce masa, “Malam, zan bi ka duk inda za ka je.” ");
INSERT INTO hauulb_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesu ya ce masa, “Yanyawa suna da ramukansu, tsuntsayen sama kuma da shekunan su, amma Dan mutum ba shi da wurin da zai kwanta.” ");
INSERT INTO hauulb_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Wani cikin almajiran ya ce masa, “Ubangiji, ka bar ni tukuna in je in binne mahaifina.” ");
INSERT INTO hauulb_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Amma Yesu ya ce masa, “Bari matattu su binne matattunsu.” ");
INSERT INTO hauulb_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Da Yesu ya shiga jirgi, almajiransa suka bi shi. ");
INSERT INTO hauulb_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Sai ga wata babbar iska ta taso a tekun, har rakuman ruwa suka fara shan kan jirgin. Amma Yesu yana barci. ");
INSERT INTO hauulb_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Sai almajiran sa suka je suka tashe shi, suka ce, “Ubangiji, ka cece mu, za mu hallaka!” ");
INSERT INTO hauulb_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yesu ya ce masu, “Don me kuka firgita haka, ya ku masu karancin bangaskiya?” Sa'annan ya tashi, ya tsauta wa iskar da tekun. Sai wurin gaba daya ya yi tsit. ");
INSERT INTO hauulb_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Mutanen suka yi al'ajibi, suka ce, “Wanne irin mutum ne wannan, wanda har iska da teku ma suke masa biyayya?”. ");
INSERT INTO hauulb_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Da Yesu ya zo daga wancan hayin a kasar Garasinawa, mutane biyu masu al'janu suka fito suka same shi. Suna fitowa daga makabarta kuma suna da fada sosai, har ma ba mai iya bin ta wannan hanya. ");
INSERT INTO hauulb_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Sai suka kwala ihu suka ce, “Ina ruwanka da mu, kai dan Allah? Ka zo nan ne ka yi mana azaba tun kafin lokaci ya yi?” ");
INSERT INTO hauulb_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","To akwai wani garken aladu masu yawa na kiwo, babu nisa da su. ");
INSERT INTO hauulb_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Sai al'janun suka roki Yesu suka ce, “In ka fitar da mu, tura mu cikin garken aladun nan.” ");
INSERT INTO hauulb_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","“Yesu ya ce masu, “To, ku je.” Sai aljanun suka fita, suka shiga cikin aladun. Sai kuwa duk garken suka rugungunta ta gangaren, suka fada cikin tekun, suka hallaka a ruwa. ");
INSERT INTO hauulb_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Mutanen masu kiwon aladun suka gudu, suka shiga gari, suka yi ta ba da labarin komai da komai, musamman abin da ya faru da masu al'janun. ");
INSERT INTO hauulb_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Sai duk jama'ar gari suka fito su sami Yesu. Da suka gan shi, suka roke shi ya bar kasarsu. ");
INSERT INTO hauulb_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesu ya shiga jirgi ya haye ya je birninsa. ");
INSERT INTO hauulb_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Sai gashi, sun kawo masa wani mutum shanyayye kwance a tabarma. Da Yesu ya ga bangaskiyarsu, sai ya ce wa shanyayyen, ''Da, ka yi farin ciki. An gafarta maka zunuban ka.'' ");
INSERT INTO hauulb_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Sai wadansu marubuta suka ce a tsakaninsu, ''Wannan mutum sabo yake yi.'' ");
INSERT INTO hauulb_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesu kuwa da yake ya san tunaninsu, yace, ''Don me kuke mugun tunani a zuciyarku? ");
INSERT INTO hauulb_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Wanne ya fi sauki, a ce, 'An gafarta maka zunubanka,' ko kuwa a ce, 'Tashi ka yi tafiya'? ");
INSERT INTO hauulb_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Amma domin ku sani Dan mutum yana da ikon gafarta zunubai a duniya...'' Sai ya ce wa shanyayyen, ''Tashi, ka dauki shimfidarka ka tafi gida.'' ");
INSERT INTO hauulb_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Mutumin kuwa ya tashi ya tafi gida. ");
INSERT INTO hauulb_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Da taron suka ga haka sai suka yi mamaki, suka daukaka Allah, wanda ya ba mutane irin wannan iko. ");
INSERT INTO hauulb_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Da Yesu ya yi gaba, ya ga wani mutum mai suna Matiyu a zaune, yana aiki a wurin karbar haraji. Yace masa, ''Ka biyo ni.'' Ya tashi ya bi shi. ");
INSERT INTO hauulb_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Sa'adda kuma Yesu yake cin abinci a gida, sai ga masu karbar haraji da masu zunubi da yawa sun zo, sun zauna tare da shi da almajiransa. ");
INSERT INTO hauulb_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Da Farisawa suka ga haka, sai suka ce wa almajiransa, ''Don me malamin ku ya ke ci tare da masu karbar haraji da masu zunubi?'' ");
INSERT INTO hauulb_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Amma da Yesu ya ji haka ya ce, ''Ai, lafiyayyu ba ruwansu da likita, sai dai marasa lafiya. ");
INSERT INTO hauulb_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Sai ku fahimci ma'anar wannan tukuna, 'Ni kam, ina bukatar jinkai ba hadaya ba.' Ba domin in kira masu adalci su tuba na zo ba, sai dai masu zunubi. ");
INSERT INTO hauulb_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Sai almajiran Yahaya suka zo wurinsa, suka ce, ''Don me mu da Farisawa mu kan yi azumi a kai a kai, amma naka almajiran ba su yi?'' ");
INSERT INTO hauulb_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Sai Yesu ya ce masu, ''Masu hidimar buki za su yi bakin ciki tun ango yana tare da su? Ai, lokaci yana zuwa da za a dauke masu angon. A sa'annan ne fa za su yi azumi.'' ");
INSERT INTO hauulb_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Babu mutumin da zai sa sabon kyalle a kan tsohuwar tufa, domin kyallen zai yage daga tufar, har ma yagewar ta fi ta da. ");
INSERT INTO hauulb_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Mutane kuma ba su dura sabon ruwan inabi a tsofaffin salkuna. Idan sun yi haka, sai salkunan kuma su fashe inabin ya tsiyaye, sai salkunan su lalace. A maimakon haka, ana sa sabon inabi cikin sababbin salkuna, ta haka an tsirar da duka biyun kenan.'' ");
INSERT INTO hauulb_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesu kuwa yana cikin yi masu magana sai ga wani shugaban jama'a ya zo ya yi masa sujada, ya ce, ''Yanzun nan 'yata ta rasu, amma ka zo ka dora mata hannu, za ta rayu.'' ");
INSERT INTO hauulb_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Sai Yesu ya tashi ya bi shi tare da almajiransa. ");
INSERT INTO hauulb_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Sai ga kuma wata mace wadda ta yi shakaru goma sha biyu tana zubar da jini sosai, ta rabo ta bayan Yesu, ta taba gezar mayafinsa. ");
INSERT INTO hauulb_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Domin ta ce a ran ta, ''Ko da mayafinsa ma na taba, sai in warke.'' ");
INSERT INTO hauulb_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Sai Yesu ya juya, ya gan ta ya ce, '''Yata, ki karfafa. Bangaskiyarki ta warkar da ke.'' Nan take matar ta warke. ");
INSERT INTO hauulb_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Da Yesu ya isa gidan shugaban jama'ar, ya kuma ga masu busar sarewa da taro suna ta hayaniya sosai. ");
INSERT INTO hauulb_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Sai ya ce, ''Ku ba da wuri, ai, yarinyar ba matacciya take ba, barci ta ke yi.'' Sai suka yi masa dariyar raini. ");
INSERT INTO hauulb_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Sa'adda aka fitar da taron waje, ya shiga ya kama hannunta, sai kuwa yarinyar ta shi. ");
INSERT INTO hauulb_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Labarin kuwa ya bazu a duk yankin. ");
INSERT INTO hauulb_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Da Yesu ya yi gaba daga nan, sai wadansu makafi biyu suka bi shi, suna daga murya suna cewa, ''Ya Dan Dauda, ka ji tausayinmu.'' ");
INSERT INTO hauulb_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Da Yesu ya shiga wani gida sai makafin suka zo gareshi. Yesu ya ce masu, “Kun gaskata ina da ikon yin haka?'' Sai suka ce masa. ''I, ya Ubangiji.'' ");
INSERT INTO hauulb_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Sai Yesu ya taba idanunsu, ya ce, ''Ya zama maku gwargwadon bangaskiyarku.'' ");
INSERT INTO hauulb_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Sai idanunsu suka bude. Amma Yesu ya umarce su kwarai, ya ce, ''Kada fa kowa ya ji labarin nan.'' ");
INSERT INTO hauulb_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Amma suka tafi suka yi ta baza labarinsa a duk yankin. ");
INSERT INTO hauulb_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Da makafin biyu suka tafi, sai aka kawo wa Yesu wani bebe mai aljani. ");
INSERT INTO hauulb_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Bayan da an fitar da aljanin, sai beben ya yi magana, taron kuwa suka yi mamaki, su ka ce, ''Kai, ba a taba ganin irin wannan a cikin Isra'ila ba!'' ");
INSERT INTO hauulb_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Amma sai Farisawa suka ce, ''Ai, da ikon sarkin aljanu ya ke fitar da aljanu.'' ");
INSERT INTO hauulb_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Sai Yesu ya zazzaga dukan garuruwa da kauyuka, yana koyarwa a majami'unsu, yana yin bisharar mulkin Allah, yana kuma warkar da kowace irin cuta da rashin lafiya. ");
INSERT INTO hauulb_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Amma da ya ga taro masu yawa sai ya ji tausayinsu, domin suna shan wahala kuma sun karaya. Suna nan kamar tumaki da babu makiyayi. ");
INSERT INTO hauulb_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Sai ya ce wa almajiransa, ''Girbin yana da yawa, amma ma'aikatan kadan ne. ");
INSERT INTO hauulb_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Saboda haka sai ku yi sauri ku roki Ubangijin girbin ya turo ma'aikata cikin girbinsa.'' ");
INSERT INTO hauulb_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesu ya kira almajiransa goma sha biyu, ya kuma ba su ikon fitar da kazaman ruhohi, su warkar da kowacce irin cuta da rashin lafiya. ");
INSERT INTO hauulb_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","To yanzu ga sunayen manzanin nan goma sha biyu. Na farkon shine, Saminu, wanda ake kira Bitrus, da dan'uwansa Andarawas, da Yakubu dan Zabadi, da dan'uwansa Yahaya; ");
INSERT INTO hauulb_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filibus, da Bartalamawus, da Toma da Matiyu mai karbar haraji da Yakubu dan Halfa, da Taddawus; ");
INSERT INTO hauulb_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Saminu Bakairawane, da kuma Yahuza Iskariyoti wanda ya bashe shi. ");
INSERT INTO hauulb_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Sha biyun nan su ne Yesu ya aika, ya yi masu umarni ya ce, ''Kada ku shiga wajen al'ummai, ko kuma kowane garin Samariyawa. ");
INSERT INTO hauulb_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Sai dai ku je wurin batattun tumaki na gidan Isra'ila. ");
INSERT INTO hauulb_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Sa'adda kuna tafiya, kuna wa'azi, kuna cewa, 'Mulkin Sama ya kusato'. ");
INSERT INTO hauulb_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ku warkar da marasa lafiya, ku tada matattu, ku tsarkake kutare, ku kuma fitar da aljanu. Kyauta kuka samu ku ma ku bayar kyauta. ");
INSERT INTO hauulb_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Kada ku rike zinariya, ko azurfa, ko tagulla a jakarku. ");
INSERT INTO hauulb_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Kada kuma ku dauki zabira a tafiyarku, ko taguwa biyu, ko takalma, ko sanda, don ma'aikaci ya cancanci abincin sa. ");
INSERT INTO hauulb_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Kowanne birni, ko kauyen da kuka shiga, ku nemi mai mutunci a cikinsa, ku kuma zauna a wurin har lokacin da za ku tashi. ");
INSERT INTO hauulb_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","In za ku shiga gida ku ce, salama a gareku. ");
INSERT INTO hauulb_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Idan gidan akwai dan salama, salamarku za ta ta tabbata a gare shi. Idan kuwa babu, salamarku za ta komo maku. ");
INSERT INTO hauulb_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ga wadanda su ka ki karbar ku ko sauraron ku, idan za ku fita garin ko gidan, sai ku karkade kurar kafafunku. ");
INSERT INTO hauulb_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Hakika, ina gaya maku, a ranar shari'a za a fi rangwanta wa kasar Saduma da ta Gwamrata a kan wannan birni. ");
INSERT INTO hauulb_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","''Duba, na aike ku kamar tumaki a tsakiyar kyarketai, don haka sai ku zama masu wayo kamar macizai, da kuma marasa barna kamar kurciyoyi. ");
INSERT INTO hauulb_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ku yi hankali da mutane, don za su kai ku gaban majalisa, su kuma yi maku bulala a majami'unsu. ");
INSERT INTO hauulb_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Za su kuma kai ku gaban mahukunta da sarakuna saboda ni, domin ku bada shaida a gabansu, da kuma gaban al'ummai. ");
INSERT INTO hauulb_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Idan har sun bada ku, kada ku damu da yadda za ku yi magana, ko kuwa abin da za ku fada, domin za a ba ku abin da za ku fada a lokacin. ");
INSERT INTO hauulb_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Domin ba ku ne kuke magana ba, Ruhun Ubanku ne yake magana ta bakinku. ");
INSERT INTO hauulb_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Dan'uwa zai ba da dan'uwansa a kashe shi, uba kuwa dansa. 'Ya'ya kuma za su tayarwa iyayensu, har su sa a kashe su. ");
INSERT INTO hauulb_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Kowa kuma zai ki ku saboda sunana. Amma duk wanda ya jure har karshe, zai tsira. ");
INSERT INTO hauulb_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","In sun tsananta maku a wannan gari, ku gudu zuwa na gaba. Hakika ina gaya maku, kafin ku gama zazzaga dukan garuruwan Isra'ila, Dan Mutum zai zo. ");
INSERT INTO hauulb_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Almajiri ba ya fin malaminsa, bawa kuma ba yafin ubangijinsa. ");
INSERT INTO hauulb_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Dai dai ne almajiri ya zama kamar malaminsa, bawa kuma kamar ubangijinsa. In har sun kira mai gida Ba'alzabuba, za su kuma bata mutanen gidansa! ");
INSERT INTO hauulb_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Don haka kada kuji tsoron su, domin ba abin da yake boye da ba za a bayyana ba. ");
INSERT INTO hauulb_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Abin da nake fada maku a asirce, ku fada a sarari. Abin da kuma kuka ji a cikin rada, ku yi shelarsa daga kan soraye. ");
INSERT INTO hauulb_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Kada ku ji tsoron masu kisan jikin mutum, amma ba sa iya kashe rai. Sai dai ku ji tsoron wannan da yake da ikon kashe jiki ya kuma jefa rai cikin jahannama. ");
INSERT INTO hauulb_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ba 'yan tsuntsaye biyu ake sayarwa akan kobo ba? Ba ko daya a cikin su da zai fadi kasa ba tare da yardar Ubanku ba. ");
INSERT INTO hauulb_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ai, ko da gashin kan ku ma duk a kidaye yake. ");
INSERT INTO hauulb_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Kada ku ji tsoro. Gama darajarku ta fi ta tsuntsaye masu yawa. ");
INSERT INTO hauulb_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","''Saboda haka duk wanda ya shaida ni a gaban mutane, ni ma zan yi shaidar sa a gaban Ubana wanda ya ke cikin Sama. ");
INSERT INTO hauulb_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Amma duk wanda ya yi musun sani na a gaban mutane, ni ma zan yi musun sanin sa a gaban Ubana da yake cikin Sama.'' ");
INSERT INTO hauulb_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","''Kada ku zaci na zo ne in kawo salama a duniya. Ban zo domin in kawo salama ba, sai dai takobi. ");
INSERT INTO hauulb_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Domin na zo ne in hada mutum da ubansa gaba, 'ya da uwatarta, mata da kuma surukarta. ");
INSERT INTO hauulb_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Zai zama na kuma magabtan mutum su ne mutanen gidansa. ");
INSERT INTO hauulb_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Dukan wanda ya fi son mahaifinsa ko mahaifayarsa fiye da ni, bai cancanci zama nawa ba. Wanda kuma ya fi son dansa ko 'yarsa fiye da ni, bai cancanci zama nawa ba. ");
INSERT INTO hauulb_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Wanda kuma bai dauki gicciyensa ya biyo ni ba, bai cancanci zama nawa ba. ");
INSERT INTO hauulb_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Dukan mai son ya ceci ransa, zai rasa shi. Duk kuwa wanda ya rasa ransa saboda ni, yana ceton sa ne. ");
INSERT INTO hauulb_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","''Wanda ya marabce ku, ya marabce ni ke nan. ");
INSERT INTO hauulb_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Wanda ya marabce ni kuwa, ya marabci wanda ya aiko ni. Wanda ya marabci annabi domin shi annabi ne, zai karbi lada kamar na annabi. Wanda kuma ya marabci mai adalci saboda shi mai adalci ne, zai sami lada kamar na mai adalci. ");
INSERT INTO hauulb_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Kowa ya ba daya daga cikin 'yan kananan nan, ko da kofin ruwan sanyi ya sha, domin shi almajirina ne, hakika, Ina gaya maku, ba zai rasa ladarsa ba.'' ");
INSERT INTO hauulb_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Bayan Yesu ya gama yi wa almajiransa gargadi, sai ya bar wannan wuri, ya tafi biranensu domin yayi koyorwa, da wa'azi. ");
INSERT INTO hauulb_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Da Yahaya mai baftisma ya ji daga kurkuku irin ayyukan da Yesu ke yi, sai ya aika sako ta wurin almajiransa. ");
INSERT INTO hauulb_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ya ce masa. “Kai ne mai zuwa”? ko mu sa ido ga wani. ");
INSERT INTO hauulb_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesu ya amsa ya ce masu, “Ku je ku gaya wa Yahaya abin da ku ka gani da abin da ku ka ji. ");
INSERT INTO hauulb_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Makafi suna samun ganin gari, guragu na tafiya, ana tsarkake kutare, kurame na jin magana kuma, ana tada matattu, mabukata kuma ana ba su bishara. ");
INSERT INTO hauulb_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Kuma mai albarka ne wanda baya tuntube sabili da ni. ");
INSERT INTO hauulb_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Bayan wadannan sun tafi, sai Yesu ya fara wa jama'a jawabi game da Yahaya mai baftisma, yana cewa, “Me ake zuwa gani a jeji - ciyawa ce da iska ke busawa? ");
INSERT INTO hauulb_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Shin menene kuke zuwa gani a jeji - mutum mai sanye da tufafi masu laushi? Hakika, masu sa tufafi masu laushi suna zaune ne a fadar sarakuna. ");
INSERT INTO hauulb_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Amma me ku ke zuwa gani, annabi? Hakika ina fada maku, fiye ma da annabi. ");
INSERT INTO hauulb_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Wannan shine wanda aka rubuta game da shi, 'Duba, ina aika manzona, wanda za ya tafi gabanka domin ya shirya maka hanya inda za ka bi'. ");
INSERT INTO hauulb_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ina gaya maku gaskiya, cikin wadanda mata suka haifa, babu mai girma kamar Yahaya mai baftisma. Amma mafi kankanta a mulkin sama ya fi shi girma. ");
INSERT INTO hauulb_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Tun daga kwanakin Yahaya mai baftisma zuwa yanzu, mulkin sama yana shan gwagwarmaya, masu husuma kuma su kan kwace shi da karfi. ");
INSERT INTO hauulb_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Gama dukan annabawa da shari'a sun yi annabci har zuwa lokacin Yahaya. ");
INSERT INTO hauulb_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","kuma in zaku karba, wannan shine Iliya wanda za ya zo. ");
INSERT INTO hauulb_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Wanda ke da kunnuwan ji, ya ji. ");
INSERT INTO hauulb_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Da me zan kwatanta wannan zamani? Ya na kamar yara masu wasa a kasuwa, sun zauna suna kiran juna ");
INSERT INTO hauulb_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","suna cewa mun busa maku sarewa baku yi rawa ba, mun yi makoki, baku yi kuka ba. ");
INSERT INTO hauulb_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Gama Yahaya ya zo, baya cin gurasa ko shan ruwan inabi, sai aka ce, “Yana da aljannu”. ");
INSERT INTO hauulb_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Dan mutum ya zo yana ci yana sha, sai aka ce, 'Duba, ga mai hadama, mashayi kuma, abokin masu karbar haraji da masu zunubi!' Amma hikima, ta wurin aikin ta ake tabbatar da ita. ");
INSERT INTO hauulb_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Sannan Yesu ya fara tsautawa biranen nan inda ya yi yawancin ayukansa, domin ba su tuba ba. ");
INSERT INTO hauulb_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Kaiton ki Korasinu, kaiton ki Batsaida! In da an yi irin ayuka masu ban mamaki a Taya da Sidon! Yadda aka yi a cikinku, da tuni sun tuba suna sanye da tsumma da yafa toka. ");
INSERT INTO hauulb_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Amma zai zama da sauki a kan Taya da Sidon a ranar shari'a fiye da ku. ");
INSERT INTO hauulb_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ke kafarnahum, kina tsammani za a daukaka ki har zuwa sama? A'a za a saukar da ke kasa zuwa hades. Gama in da an yi irin al'ajiban da aka yi a cikin ki a Sodom, da tana nan har yanzu. ");
INSERT INTO hauulb_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Amma ina ce maku, za a saukaka wa Sodom a ranar shari'a fiye da ku.” ");
INSERT INTO hauulb_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","A wannan lokaci Yesu ya ce, “Ina yabon ka, ya Uba, Ubangijin sama da kasa, domin ka boye wa masu hikima da fahimta wadannan abubuwa, ka bayyana wa marasa sani, kamar kananan yara. ");
INSERT INTO hauulb_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","I, ya Uba gama wannan shine ya yi daidai a gare ka. ");
INSERT INTO hauulb_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","An mallaka mani dukan abu daga wurin Ubana. Sannan babu wanda ya san Dan, sai Uban, babu kuma wanda ya san Uban, sai Dan, da duk wanda ya so ya bayyana masa. ");
INSERT INTO hauulb_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ku zo gare ni, dukanku masu wahala da fama da nauyin kaya, ni kuma zan ba ku hutawa. ");
INSERT INTO hauulb_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ku dauki karkiya ta ku koya daga gare ni, gama ni mai tawali'u ne da saukin hali a zuciya, sannan zaku sami hutawa ga rayukanku. ");
INSERT INTO hauulb_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Gama karkiyata mai sauki ce, kaya na kuma ba shi da nauyi.” ");
INSERT INTO hauulb_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","A wannan lokaci, Yesu ya tafi a ranar Asabaci, ya bi cikin gonar hatsi. Almajiransa na jin yunwa, sai suka fara zagar hatsi suna ci. ");
INSERT INTO hauulb_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Amma da Farisawa suka gan su, sai su ka ce wa Yesu. “Duba, almajiranka su na yin abin da doka ta haramta a ranar Asabaci.” ");
INSERT INTO hauulb_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Amma Yesu ya ce masu, “Baku karanta abin da Dauda ya yi ba, lokacin da ya ke jin yunwa, tare da mazan da ke tare da shi? ");
INSERT INTO hauulb_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Yadda ya shiga gidan Allah, ya ci gurasar alfarwa da doka ta hana shi ko mazan da ke tare da shi su ci, sai dai Firistoci ne kawai doka ta basu damar ci? ");
INSERT INTO hauulb_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Sa'annan ba ku karanta cikin shari'a cewa, a ranar Asabaci, Firistoci da ke cikin haikali na sabawa ranar Asabaci, amma kamar ba su yi laifi ba? ");
INSERT INTO hauulb_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Amma ina tabbatar maku da cewa, wani wanda ya fi haikali girma yana nan. ");
INSERT INTO hauulb_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","In da kun san ma'anar wannan 'Na fi son jinkai fiye da hadaya,' da baku shari'anta wa marar laifi ba. ");
INSERT INTO hauulb_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Gama Dan mutum shine Ubangijin Asabaci.” ");
INSERT INTO hauulb_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Sa'annan Yesu ya bar wannan wuri, ya shiga majami'ar su. ");
INSERT INTO hauulb_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Sai ga wani mutum wanda hannun sa ya shanye, sai Farisawa suka tambayi Yesu, cewa, “Doka ta halarta a yi warkarwa a ranar Asabaci?” Domin su zarge shi a kan zunubi. ");
INSERT INTO hauulb_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yesu ya ce masu, “Wanene a cikin ku, wanda idan ya na da tunkiya guda, sa'annan tunkiyar nan ta fada a rami mai zurfi a ranar Asabaci ba zai kamo ta ya fitar da ita ba? ");
INSERT INTO hauulb_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Yaya za a kwatanta darajar mutum da tunkiya! Saboda haka ya halarta a yi alheri ranar Asabaci.” ");
INSERT INTO hauulb_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Sai Yesu ya ce wa mutumin nan “Mika hannun ka.” Ya mike hannunsa, sai hannun nan ya dawo lafiyaye kamar dayan hannunsa. ");
INSERT INTO hauulb_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Amma Farisawa su ka fita waje su ka fara mugun shiri domin sa. Su na neman hanyar da za su kashe shi. ");
INSERT INTO hauulb_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Da Yesu ya fahimci wannan, sai ya janye kan sa daga nan. Mutane da dama su ka bi shi, ya warkar da su duka. ");
INSERT INTO hauulb_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ya dokace su da kada su bayyana shi ga kowa, ");
INSERT INTO hauulb_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","domin ya zama gaskiyar abin da aka fada ta wurin annabi Ishaya, cewa, ");
INSERT INTO hauulb_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Dubi, bawa na zababbe; kaunatacce na, wanda ya ke faranta mani raina sosai. Zan sa Ruhu na bisan sa, za ya furta hukunci zuwa al'ummai. ");
INSERT INTO hauulb_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ba za ya yi jayayya ko tada murya ba, babu wanda za ya ji muryar sa a karabku. ");
INSERT INTO hauulb_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ba zai karya kara da ya tankwashe ba; ba zai kashe fitilar da ta kusa mutuwa ba; sai ya kawo hukunci ga nasara. ");
INSERT INTO hauulb_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Sa'annan al'ummai za su dogara a ga sunansa. ");
INSERT INTO hauulb_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Sa'annan wani mutum, makaho ne, kurma kuma, aljannu kuma na cikinsa, an kawo shi wurin Yesu. Ya warkar da shi, ya sami ganin gari ya kuma yi magana. ");
INSERT INTO hauulb_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Jama'a su ka yi mamaki kwarai, su na cewa, “Ko wannan ne Dan Dawuda?” ");
INSERT INTO hauulb_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Amma da Farisawa su ka ji wannan al'ajibi, sai su ka ce, “Mutumin nan yana fitar da aljannu ta wurin Bahalzabuba sarkin aljannu ne.” ");
INSERT INTO hauulb_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Amma Yesu ya san tunanin su, sai ya ce. “Duk mulkin da ya rabu gaba da kan sa, ba zaya tsaya ba, duk wani birni da ya rabu ba zai tsaya ba, ko gida da ya tsage, za ya rushe. ");
INSERT INTO hauulb_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Idan Shaidan ya fitar da Shaidan, ya rabu gaba da kansa. Yaya mulkin sa za ya tsaya? ");
INSERT INTO hauulb_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Idan Ina fitar da aljannu da ikon Ba'alzabuba, ta wurin wa masu bin ku su ke fitar da su? Saboda haka, su za su shari'anta ku. ");
INSERT INTO hauulb_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Amma idan ina fitar da aljannu da Ruhun Allah ne, hakika mulkin Allah ya zo gare ku. ");
INSERT INTO hauulb_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Kuma ta yaya mutum za ya shiga gidan mai karfi ya kwashe masa kaya ba tare da ya fara daure shi ba? Sa'annan ne za ya iya satar masa kaya daga gidansa. ");
INSERT INTO hauulb_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Wanda baya tare da ni yana gaba da ni ke nan, wanda kuma baya tarawa tare da ni, yana watsarwa ne. ");
INSERT INTO hauulb_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Saboda haka ina ce maku, kowanne zunubi da sabo, za a gafarta wa mutum, amma sabon Ruhu Mai Tsarki, ba za a gafarta shi ba. ");
INSERT INTO hauulb_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Duk wanda yayi batanci ga Dan Mutum, za a gafarta masa. Amma duk wanda yayi batanci game da Ruhu Mai Tsarki ba za a gafarta masa ba, a nan duniya da har abada. ");
INSERT INTO hauulb_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ko dai a mai da itace mai kyau 'ya'yansa kuma su yi kyau, ko a mai da itace marar kyau 'ya'yansa kuma marasa kyau, gama ana sanin itace ta wurin 'ya'yansa. ");
INSERT INTO hauulb_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ku 'ya'yan macizai, tun da ku miyagu ne, yaya za ku iya fadin abubuwa nagari? Gama daga cikar zuciya baki ke magana. ");
INSERT INTO hauulb_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Mutumin kirki daga ajiyar zuciyarsa ya kan fitar da abubuwa masu kyau, mugun mutum kuma daga mummunar ajiyar zuciyarsa ya kan fitar da abubuwan mugunta. ");
INSERT INTO hauulb_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Sa'annan ina ce maku a ranar shari'a, mutane za su bada lissafin abubuwan banza da su ka fadi. ");
INSERT INTO hauulb_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Gama ta wurin maganganun ku, za a 'yantar da ku, ta wurin maganganun ku kuma za a kashe ku.” ");
INSERT INTO hauulb_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Sa'annan wadansu Malaman Attaura, da Farisawa suka amsa suka ce wa Yesu, “Mallam, muna so mu ga wata alama daga gare ka.” ");
INSERT INTO hauulb_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Amma Yesu ya amsa ya ce masu, “Mugun zamani da mazinaciyar tsara, su na bukutar alama. Amma babu alamar da za a ba su, sai dai alamar annabi Yunusa. ");
INSERT INTO hauulb_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Gama yadda Yunusa ya yi kwana uku da dare uku a cikin babban kifi, haka ma Dan Mutum zaya yi kwana uku da dare uku a cikin zuciyar kasa. ");
INSERT INTO hauulb_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Mutanen Nineba za su tsaya a ranar shari'a da wannan zamani sannan su kashe su. Domin sun tuba da suka ji wa'azin Yunusa, amma duba wanda ya fi Yunusa yana nan. ");
INSERT INTO hauulb_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Sarauniyar Kudu za ta tashi da mutanen wannan zamani ta kuma kashe su. Ta zo daga karshen duniya domin ta ji hikimar Sulaimanu, kuma duba, wanda ya fi Sulaimanu yana nan. ");
INSERT INTO hauulb_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Idan kazamin ruhu ya rabu da mutum, ya kan wuce ya nemi wuraren da ruwa yake domin ya huta, amma bai samu ba. ");
INSERT INTO hauulb_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Sai ya ce, 'zan koma gidana inda na fito'. Bayan ya dawo, sai ya tarar da gidan nan an share shi ya zama da tsabta. ");
INSERT INTO hauulb_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Sai ya koma ya kawo wadansu ruhohi guda bakwai, wadanda su ka fi shi mugunta, sa'annan dukan su su zo su zauna a nan. Sa'annan yanayin mutumin nan na karshe ya fi na farko muni. Haka zaya kasance ga wannan mugun zamani. ");
INSERT INTO hauulb_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Sa'adda Yesu ya ke yi wa Jama'a jawabi, sai mahaifiyarsa da 'yan'uwansa su ka zo su ka tsaya a waje, suna neman su yi magana da shi. ");
INSERT INTO hauulb_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Sai wani ya ce masa, “Duba, mahaifiyarka da 'yan'uwanka suna tsaye a waje, suna so su yi magana da kai”. ");
INSERT INTO hauulb_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Amma Yesu ya amsa ya ce wa shi wanda ya gaya masa, “Wacece mahaifiyata? Kuma su wanene 'yan'uwana?” ");
INSERT INTO hauulb_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Sai ya mika hannu ya nuna almajiransa ya ce, “Duba, ga mahaifiyata da 'yan'uwana! ");
INSERT INTO hauulb_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Gama duk wanda yake aikata nufin Ubana wanda ya ke cikin sama, shine dan'uwana, da 'yar'uwata da mahaifiyata.” ");
INSERT INTO hauulb_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","A waccan rana Yesu ya fito daga gida ya zauna a gefen teku. ");
INSERT INTO hauulb_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Taro mai yawan gaske kuwa suka kewaye shi, sai ya shiga cikin kwalekwale ya zauna. Dukan taron kuwa na tsaye a bakin tekun. ");
INSERT INTO hauulb_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Sai Yesu ya fada masu abubuwa da yawa cikin misalai. Ya ce, “Wani mai shuka, ya tafi yayi shuka. ");
INSERT INTO hauulb_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Da yayi shukar, wadansu irin suka fadi a kan hanya, sai tsunsaye suka zo suka cinye su. ");
INSERT INTO hauulb_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Wadansu irin kuwa suka fadi a kan duwatsu, wurin da babu kasa. Nan da nan sai suka tsira, domin kasar babu zurfi. ");
INSERT INTO hauulb_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Amma da rana ta taso, sai suka yankwane domin ba su yi saiwa ba, suka kuwa bushe suka zube. ");
INSERT INTO hauulb_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Wasu irin kuwa suka fada a cikin kayayuwa. Kayayuwan kuwa suka shake su. ");
INSERT INTO hauulb_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Wasu irin kuwa suka fada a wuri mai kyau suka ba da tsaba, wani ya ba da dari, wasu sitin, wasu kuma talatin. ");
INSERT INTO hauulb_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Duk mai kunnen ji, bari ya ji. ");
INSERT INTO hauulb_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Almajiran suka zo suka ce ma Yesu, “Don me ka ke yi wa taron magana da misali?” ");
INSERT INTO hauulb_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yesu ya amsa ya ce masu, “An baku 'yanci ku fahimci asiran mulkin sama, amma gare su ba a bayar ba. ");
INSERT INTO hauulb_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Domin wanda yake da shi, za a kara masa, zai kuma samu dayawan gaske. Amma duk wanda ba shi da shi, sai a dauke har ma abin da yake dashi. ");
INSERT INTO hauulb_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Saboda haka na yi masu magana cikin misalai, amma ko da ya ke sun gani, duk da haka ba su gani ba. Kuma ko da yake sun ji, hakika ba su ji ba, balle ma su fahimta. ");
INSERT INTO hauulb_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","A gare su ne annabcin Ishaya ya cika, wanda yake cewa, “Game da sauraro zaku saurara, amma ba za ku fahimta ba. Game da gani kuma za ku kalla, amma ba za ku gane ba. ");
INSERT INTO hauulb_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Domin zuciyar mutanen nan ta duhunta, sun taurare ga saurare, kuma sun rufe idanunsu domin kada su gani da idanunsu, ko kuwa su ji da kunnuwansu, ko kuwa su fahimta da zukatansu, saboda su juyo kuma in warkar da su'. ");
INSERT INTO hauulb_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Amma idanunku masu albarka ne, domin sun gani, haka ma kunnuwanku, domin sun ji. ");
INSERT INTO hauulb_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Hakika ina gaya muku, annabawa da mutane dayawa masu aldalci sun yi marmarin ganin abin da kuka gani, amma ba su sami ganin su ba. Sun yi marmarin jin abin da kuka ji, ba su kuwa ji su ba. ");
INSERT INTO hauulb_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Ku saurari misalin nan na mai shuka. ");
INSERT INTO hauulb_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Idan wani ya ji maganar mulkin sama amma bai fahimce ta ba, sai mugun nan ya zo ya kwace abinda aka shuka a zuciyarsa. Wannan shine irin da aka shuka a kan hanya. ");
INSERT INTO hauulb_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Shi wanda aka shuka akan duwatsu, shine wanda ya ji maganar ya kuma karbe ta da murna nan da nan. ");
INSERT INTO hauulb_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Duk da haka, bai yi karfi cikin ta ba kuma nan ba da dadaiwa ba. Da wahala da tsanani suka taso saboda maganar, sai ya yi tuntube nan da nan. ");
INSERT INTO hauulb_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Shi wanda aka shuka a cikin kayayuwa wannan shine wanda ya ji maganar, amma dawainiyar duniya da kuma yaudarar dukiya suka shake maganar, sai ya kasa ba da 'ya'ya. ");
INSERT INTO hauulb_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Shi wanda aka shuka a kasa mai kyau, wannan shine wanda ya ji maganar, ya kuma fahimce ta. Wannan shine wanda ba da 'ya'ya da gaske; wadansu ribi dari, wadansu sittin, wasu kuma talatin.” ");
INSERT INTO hauulb_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesu ya sake ba su wani misali, yana cewa “Za a kwatanta mulkin sama da wani mutum wanda ya shuka iri mai kyau a gona. ");
INSERT INTO hauulb_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Amma da mutane suka yi barci, magabcin sa ya zo ya shuka ciyayi a cikin alkamar, ya kuwa yi tafiyarsa. ");
INSERT INTO hauulb_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Sa'adda suka yi toho suka kuma ba da tsaba, sai ciyayin suka bayyana. ");
INSERT INTO hauulb_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Bayin mai gonar kuwa suka zo suka ce masa, maigida, ashe ba iri mai kyau ka shuka a gonarka ba? ya ya aka yi ta kasance da ciyayi? ");
INSERT INTO hauulb_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ya ce masu, “Magabci ne ya yi wannan”. Sai bayin suka ce masa, 'kana so mu je mu tuge su ne?' ");
INSERT INTO hauulb_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Mai gonar ya ce, 'A'a, kada a garin tuge ciyayin, ku tuge tare da alkamar. ");
INSERT INTO hauulb_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Bari dukan su su girma tare har lokacin girbi, a lokacin girbin zan gaya wa masu girbin, “Ku tuge ciyayin da farko a daura su dami dami sai a kona su, amma a tara alkamar a kai rumbunana.'” ");
INSERT INTO hauulb_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Sai Yesu ya sake yin magana da su cikin misalai, yana cewa “Za a kwatanta mulkin sama da kwayar mustad, wanda wani mutum ya shuka a lambunsa. ");
INSERT INTO hauulb_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Wannan iri shine mafi kankanta cikin dukan iri. Amma bayan ya yi girma, sai ya fi dukan ganyaye dake lambun. Ya zama itace, har ma tsuntsayen sama su yi sheka a rassansa.” ");
INSERT INTO hauulb_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesu ya sake fada masu wani misali. “Za a kwatanta mulkin sama da yisti da mace takan dauka ta kwaba gari da shi mudu uku har sai ya yi kumburi.” ");
INSERT INTO hauulb_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Duk wadannan abubuwa Yesu ya fada wa taron cikin misalai. Babu abinda ya fada masu da ba a cikin misali ba. ");
INSERT INTO hauulb_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Wannan ya kasance ne domin abinda annabin ya fada ya zama gaskiya, da ya ce, “Zan buda bakina da misali. In fadi abubuwan da ke boye tun daga halittar duniya.” ");
INSERT INTO hauulb_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Sai Yesu ya bar taron ya shiga cikin gida. Amajiransa suka zo wurin sa suka ce, “Ka fasarta mana misalan nan a kan ciyayin da ke gonar” ");
INSERT INTO hauulb_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yesu ya amsa kuma ya ce, “Shi wanda ya shuka iri mai kyau Dan Mutum ne. ");
INSERT INTO hauulb_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Gonar kuwa duniya ce; iri mai kyau kuma sune 'ya'yan mulkin. Ciyayin kuma sune 'ya'yan mugun, ");
INSERT INTO hauulb_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","magabcin da ya shuka su kuma shaidan ne. Girbin shine karshen duniya, kuma masu girbin sune mala'iku. ");
INSERT INTO hauulb_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Saboda haka, kamar yadda aka tara ciyayin aka kona su da wuta, haka ma zai faru a karshen duniya. ");
INSERT INTO hauulb_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Dan Mutum zai aiki mala'ikunsa, kuma su tara dukan abubuwan da ke sa zunubi daga cikin mulkinsa, da kuma wadanda su ka yi aikin mugunta. ");
INSERT INTO hauulb_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Za su jefa su cikin korama ta wuta, inda za a yi kuka da cizon hakora. ");
INSERT INTO hauulb_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Sa'an nan ne mutane masu adalci za su haskaka kamar rana a mulkin Ubansu. Bari mai kunnen ji, ya ji. ");
INSERT INTO hauulb_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Mulkin sama kamar dukiya ce da ke boye a gona. Mutum ya samu sai ya boye ta, ya tafi cikin murna, ya sayar da mallakarsa kuma ya sayi filin. ");
INSERT INTO hauulb_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Haka ma za a kwatanta mulkin sama da wani attajiri mai neman Lu'ulu'ai masu daraja. ");
INSERT INTO hauulb_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Da ya sami lu'ulu'u daya mai darajar gaske, ya je ya sayar da dukan mallakarsa ya kuma saye shi. ");
INSERT INTO hauulb_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Haka kuma, za a kwatanta mulkin sama da taru da aka jefa cikin teku, ya kuwa tara hallitu iri-iri. ");
INSERT INTO hauulb_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Da ya cika, sai masuntan suka jawo shi bakin tekun. Sai suka zauna suka tara kyawawan abubuwan a taska, amma munanan abubuwan, suka watsar da su. ");
INSERT INTO hauulb_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Haka zai kasance a karshen duniya. Mala'iku za su zo su ware miyagu daga cikin masu adalci. ");
INSERT INTO hauulb_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Za su jefa su cikin korama ta wuta, inda za a yi kuka da cizon hakora. ");
INSERT INTO hauulb_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Kun fahimci dukan wadannan abubuwa? Amajiran suka ce da shi, “I”. ");
INSERT INTO hauulb_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Sai Yesu ya ce masu, “Saboda haka kowane malamin attaura da ya zama almajirin mulkin sama, yana kamar mutum mai gida wanda ya zaro tsoho da sobon abu daga taskarsa.” ");
INSERT INTO hauulb_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Daga nan, sa'adda Yesu ya kammala ba da wadanan misalai, sai ya tafi ya bar wurin. ");
INSERT INTO hauulb_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Sai Yesu ya shiga yankinsa ya koyar da mutane a masujadarsu. Saboda haka suka yi mamaki suna cewa, “Daga ina wannan mutumin ya sami hikimarsa da al'ajibai? ");
INSERT INTO hauulb_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Wannan mutumin ba dan masassakin nan ba ne? Ba kuma sunan mahaifiyarsa Maryamu ba? Ba Kuma 'yan'uwansa sune, Yakubu da Yusufu da Saminu da kuma Yahuza ba? ");
INSERT INTO hauulb_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ba 'yan'uwansa mata na tare da mu ba? To daga ina wannan mutumin ya sami dukan wadannnan abubuwa? ");
INSERT INTO hauulb_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Suka bata rai saboda shi. Amma Yesu ya ce masu, “Ai annabi bai rasa daraja sai dai ko a garinsa da kuma cikin iyalinsa. ");
INSERT INTO hauulb_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Kuma bai yi al'ajibai dayawa a can ba saboda rashin bangaskiyarsu. ");
INSERT INTO hauulb_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","A lokacin nan ne, Hiridus mai mulki ya ji labarin Yesu. ");
INSERT INTO hauulb_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ya ce wa barorinsa, “Wannan Yahaya mai baftisma ne; ya tashi daga matattu. Saboda haka wadannan ikoki na aiki a cikinsa”. ");
INSERT INTO hauulb_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Domin Hiridus ya kama Yahaya, ya daure shi, kuma ya jefa shi a kurkuku saboda Hirudiya, matar dan'uwansa Filibus. ");
INSERT INTO hauulb_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Ya ce masa, “Bai kamata ka dauke ta a matsayin matarka ba.” ");
INSERT INTO hauulb_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Da Hirudus ya kashe shi, amma yana tsoron jama'a, domin sun dauke shi a matsayin annabi. ");
INSERT INTO hauulb_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Amma da ranar bikin haihuwar Hirudus ta kewayo, diyar Hirudiya tayi rawa a lokacin har ta burge Hirudus. ");
INSERT INTO hauulb_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Sai ya yi mata alkawari har da rantsuwa cewa ta roki komenene ta ke so, zai ba ta. ");
INSERT INTO hauulb_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Bayan ta amshi umurni daga wurin mahaifiyarta, ta ce, “Ka bani kan Yahaya mai baptisma a kan tire. ");
INSERT INTO hauulb_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Sarki ya husata da rokonta, amma domin rantsuwar da ya yi kuma domin mutanen da ke a wurin bukin tare da shi, sai ya umurta a yi haka. ");
INSERT INTO hauulb_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ya aika aka yanke kan Yahaya acikin kurkuku. ");
INSERT INTO hauulb_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Sai aka kawo kansa bisa tire, aka mika wa yarinyar, ta kuwa kai wa mahaifiyarta. ");
INSERT INTO hauulb_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Sai almajiransa suka zo, su ka dauki gawar su ka je su ka yi jana'iza. Bayan haka, su ka je su ka fada wa Yesu. ");
INSERT INTO hauulb_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Sa'adda da Yesu ya ji haka, ya fita daga cikin kwale-kwale zuwa wani kebabben wuri. Da taron suka ji haka, suka bi shi da kafa daga biranen. ");
INSERT INTO hauulb_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Sai Yesu ya zo gabansu, ya kuma ga babban taron. Ya tausaya masu ya kuwa warkar da marasa lafiya dake cikinsu. ");
INSERT INTO hauulb_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Da maraice ya yi, almajiransa su ka zo su ka ce masa, “Wannan wuri jeji ne, dare kuwa ya riga ya yi. Ka sallami taron domin su je cikin kauyukan nan, su sayo wa kansu abinci.” ");
INSERT INTO hauulb_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Amma Yesu ya ce masu, “Babu amfanin tafiyar su, ku basu abin da za su ci.” ");
INSERT INTO hauulb_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Suka ce masa, “Muna da gurasa guda biyar da kifi biyu ne kawai.” ");
INSERT INTO hauulb_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yesu ya ce, “Ku kawo mani su.” ");
INSERT INTO hauulb_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Sai Yesu ya umarci taron su zauna akan ciyawa. Ya dauki gurasa biyar da kifi biyun. Ya dubi sama, ya sa albarka ya gutsuttsura ya kuma ba almajiran. Almajiran suka ba taron. ");
INSERT INTO hauulb_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Dukansu suka ci suka koshi. Sai suka dauki gutsattsarin gurasa da kifin, kwanduna goma sha biyu cike. ");
INSERT INTO hauulb_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Wadanda su ka ci kuwa kimanin maza dubu biyar ne, ban da mata da yara. ");
INSERT INTO hauulb_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Nan take sai ya sa almajiran suka shiga kwale-kwalen su haye zuwa dayan gefen kafin shi, domin ya sallami taron. ");
INSERT INTO hauulb_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Bayan ya sallami taron sun tafi, sai ya haura kan dutse domin yayi addu'a. Da dare yayi, yana can shi kadai. ");
INSERT INTO hauulb_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Amma yanzu fa kwale-kwalen na tsakiyar tekun, kuma da wuyar sarrafawa saboda rakuman ruwa da iska na gaba da su. ");
INSERT INTO hauulb_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Da asuba (wajen karfe uku na dare) Yesu ya nufo su yana tafiya akan teku. ");
INSERT INTO hauulb_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Da almajiran suka ganshi yana tafiya akan tekun, sai suka firgita suna cewa, “Fatalwa ce,” suka yi kururuwa cikin tsoro. ");
INSERT INTO hauulb_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Amma Yesu yayi magana da su nan da nan yace, “Ku yi karfin hali! Ni ne! Kada ku ji tsoro.” ");
INSERT INTO hauulb_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Bitrus ya amsa masa cewa, “Ubangiji, idan kai ne, ka umarce ni in zo wurin ka bisa ruwan.” ");
INSERT INTO hauulb_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yesu yace, “Zo” Sai Bitrus ya fita daga jirgin yana tafiya akan ruwan zuwa wurin Yesu. ");
INSERT INTO hauulb_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Amma da Bitrus ya ga iska, sai ya tsorata. Yayin da ya fara nutsewa, sai ya tada murya ya ce, “Ubangiji, ka cece ni!” ");
INSERT INTO hauulb_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Nan take Yesu ya mika hannunsa, ya kama Bitrus ya ce masa, “Kai mai karancin bangaskiya, meyasa ka yi shakka?” ");
INSERT INTO hauulb_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Bayan da Yesu da Bitrus suka shiga cikin kwale-kwalen, sai iska ta daina kadawa. ");
INSERT INTO hauulb_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Sai almajiran dake cikin kwale-kwalen su ka yi wa Yesu sujada suna cewa, “Hakika kai Dan Allah ne.” ");
INSERT INTO hauulb_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Da suka haye, sun iso kasar Janisarata. ");
INSERT INTO hauulb_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Da mutanen wurin suka gane Yesu, sai suka aika da sako zuwa dukan yankin, kuma suka kawo masa dukan marasa lafiya. ");
INSERT INTO hauulb_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Suka roke shi don su taba gezar rigarsa, kuma dukan wadanda suka taba shi sun warke. ");
INSERT INTO hauulb_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Sai wadansu Farisawa da malamai suka zo wurin Yesu daga Urushalima. Su ka ce, ");
INSERT INTO hauulb_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Meyasa almajiranka suke karya al'adar dattawa? Don ba su wanke hannayen su kafin su ci abinci.” ");
INSERT INTO hauulb_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesu ya amsa masu ya ce, “Kuma don me ku ke karya dokar Allah saboda al'adunku? ");
INSERT INTO hauulb_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Domin Allah ya ce, 'Ka girmama mahaifinka da mahaifiyarka; 'Shi wanda ya yi muguwar magana ga mahaifinsa ko mahaifiyarsa, lallai zai mutu. ");
INSERT INTO hauulb_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Amma kun ce, “Duk wanda ya ce wa mahaifinsa ko mahaifiyarsa, “Kowanne taimako da za ka samu daga gare ni yanzu baiko ne ga Allah,'” ");
INSERT INTO hauulb_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","wannan mutum ba ya bukatar ya girmama mahaifinsa. Ta wannan hanya kun maida maganar Allah wofi saboda al'adunku. ");
INSERT INTO hauulb_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ku munafukai, daidai ne Ishaya ya yi annabci akan ku da ya ce, ");
INSERT INTO hauulb_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“ Wadannan mutane girmama ni da baki kawai suke yi, amma zukatansu nesa suke da ni. ");
INSERT INTO hauulb_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Suna mani sujada a banza, domin suna koyar da dokokin mutane a matsayin rukunansu.” ");
INSERT INTO hauulb_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Sai ya kira taron mutane zuwa gare shi ya ce masu, “Ku saurara ku fahimta, ");
INSERT INTO hauulb_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","ba abin da ke shiga baki ke kazantar da mutum ba. Sai dai, abin da ke fitowa daga baki, wannan shi ya ke kazantar da mutum.” ");
INSERT INTO hauulb_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Sai al'majiran suka zo suka ce masa, “Ka san Farisawa ba su ji dadi ba da suka ji maganan nan?” ");
INSERT INTO hauulb_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yesu ya amsa ya ce, “Kowace shuka wadda ba Ubana na sama ya shuka ba za a tuge ta. ");
INSERT INTO hauulb_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ku kyale su kawai, su makafin jagora ne. In makaho ya ja wa wani makaho gora dukan su za su fada rami.” ");
INSERT INTO hauulb_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Bitrus ya amsa ya ce wa Yesu, “Ka bayyana wannan misali a garemu,” ");
INSERT INTO hauulb_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesu ya ce, “Ku ma har yanzu ba ku da fahimta? ");
INSERT INTO hauulb_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ko baku gani ba duk abin da ke shiga baki zuwa ciki ta haka yake fita zuwa salga? ");
INSERT INTO hauulb_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Amma abubuwan da ke fita daga baki suna fitowa ne daga zuciya. Su ne abubuwan da ke kazantar da mutum. ");
INSERT INTO hauulb_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Domin daga zuciya mugayen tunani suke fitowa, kisan kai, zina, fasikanci, sata, shaidar zur, da zage-zage. ");
INSERT INTO hauulb_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Wadannan su ne abubuwan da ke kazantar da mutum. Amma ci da rashin wanke hannu baya kazantar da mutum.” ");
INSERT INTO hauulb_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Sai Yesu ya tafi daga nan ya nufi yankin biranen Taya da Sidon. ");
INSERT INTO hauulb_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Sai wata mace Bakan'aniya ta zo daga wannan yanki. Ta daga murya ta ce,” Ka yi mani jinkai, Ubangiji, Dan Dauda; 'yata tana cikin bakar azaba da aljani.” ");
INSERT INTO hauulb_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Amma Yesu bai ce mata kome ba. Almajiransa suka zo suka roke shi, suna cewa, “Ka sallame ta, domin tana bin mu da ihu.” ");
INSERT INTO hauulb_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Amma Yesu ya amsa ya ce, “Ba a aike ni gun kowa ba sai dai ga batattun tumakin gidan Isra'ila.” ");
INSERT INTO hauulb_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Amma ta zo ta durkusa a gabansa, tana cewa, “Ubangiji ka taimake ni.” ");
INSERT INTO hauulb_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ya amsa ya ce, “Ba daidai bane a dauki gurasar yara a jefa wa kananan karnuka. ");
INSERT INTO hauulb_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ta ce, “I, Ubangiji, amma ko kananan karnuka suna cin barbashin da ke fadowa daga teburin maigida.” ");
INSERT INTO hauulb_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Sai Yesu ya amsa ya ce mata, “Mace, bangaskiyarki tana da girma. Bari ya zamar maki yadda ki ke so.”'Yarta ta warke a lokacin. ");
INSERT INTO hauulb_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu ya bar wurin ya tafi kusa da tekun Galili. Sai ya hau tudu ya zauna a can. ");
INSERT INTO hauulb_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Taro mai yawa suka zo gunsa. Suka kawo masa guragu, makafi, bebaye da nakasassun mutane da yawa, da wadansu marasa lafiya. Suka kawo su gaban Yesu, sai ya warkar da su. ");
INSERT INTO hauulb_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Don haka mutane da yawa suka yi mamaki a lokacin da suka ga bebaye suna magana, nakasassu sun warke, guragu suna tafiya, makafi suna gani. Sai suka daukaka Allah na Isra'ila. ");
INSERT INTO hauulb_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesu ya kira almajiransa zuwa gun sa sai ya ce, “Ina jin tausayin taron, sun kasance tare da ni kwana uku ke nan kuma ba su da abin da za su ci. Bana so in sallame su ba tare da sun ci abinci ba, domin kada su suma a hanya.” ");
INSERT INTO hauulb_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Almajiran suka ce masa, “A ina zamu sami isasshiyar gurasa a wannan wuri da babu kowa har ta ishi babban taron nan.” ");
INSERT INTO hauulb_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesu ya ce masu, “Gurasa nawa ku ke da ita?” Suka ce, “Bakwai da 'yan kifi marasa yawa.” ");
INSERT INTO hauulb_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Sai Yesu ya umarci taron su zauna a kasa. ");
INSERT INTO hauulb_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ya dauki gurasar nan bakwai da kifin, bayan ya yi godiya, ya kakkarya gurasar ya bada ita ga almajiran Sai almajiran suka ba taron. ");
INSERT INTO hauulb_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Jama'a duka suka ci suka koshi. Suka tattara gutsattsarin abincin da ya rage, kwando bakwai cike. ");
INSERT INTO hauulb_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Wadanda suka ci su dubu hudu ne maza, banda mata da yara. ");
INSERT INTO hauulb_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Sai Yesu ya sallami taron ya shiga cikin jirgin ruwa ya tafi yankin Magadan. ");
INSERT INTO hauulb_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Sai Farisawa da Sadukiyawa suka zo su gwada shi suka roke shi ya nuna masu alama daga sama. ");
INSERT INTO hauulb_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Amma ya amsa ya ce masu, “Lokacin da yamma ta yi, sai ku ce, 'Za a yi yanayi mai kyau, domin sama ta yi ja,' ");
INSERT INTO hauulb_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Kuma da safe ku ce, 'Zai zama yanayi mara kyau a yau, domin sama ta yi ja ta kuma gama gari, kun san yadda za ku bayyana kammanin sararin sama, amma ba ku iya bayyana alamun lokaci ba. ");
INSERT INTO hauulb_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Mugun zamani, maciya amana suna neman alama, amma babu wata alama da za a nuna sai ta Yunusa.” Daga nan sai Yesu ya tafi. ");
INSERT INTO hauulb_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Almajiran suka zo daga wancan gefe, amma sun manta su dauki gurasa, ");
INSERT INTO hauulb_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesu ya ce masu, “Ku kula ku kuma mai da hankali da yisti na Farisawa da Sadukiyawa.” ");
INSERT INTO hauulb_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Sai almajiran suka fara magana da junansu suka ce, “Ko saboda bamu kawo gurasa bane.” ");
INSERT INTO hauulb_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yesu yana sane da wannan sai ya ce, “Ku masu karancin bangaskiya, don me ku ke magana a tsakaninku cewa ko don bamu kawo gurasa bane? ");
INSERT INTO hauulb_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ba ku gane ko tuna da gurasa guda biyar da aka ciyar da mutum dubu biyar, kuma kwando nawa kuka tara ba? ");
INSERT INTO hauulb_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ko gurasa bakwai ga mutum dubu hudu, da kuma kwanduna nawa kuka dauka ba? ");
INSERT INTO hauulb_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Yaya kuka kasa fahimta cewa ba game da gurasa nake yi maku magana ba? Ku yi hankali ku kuma lura da yistin Farisawa da Sadukiyawa.” ");
INSERT INTO hauulb_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Sa'annan suka fahimta cewa ba yana gaya masu su yi hankali da yistin da ke cikin gurasa ba ne, amma sai dai su yi lura da koyarwar Farisawa da Sadukiyawa. ");
INSERT INTO hauulb_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","A lokacin da Yesu ya zo yankin Kaisariya Filibbi, ya tambayi almajiransa, cewa, “Wa mutane ke cewa Dan Mutum yake? ");
INSERT INTO hauulb_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Suka ce, “Wadansu suna cewa Yahaya mai baftisma; wadansu Iliya, saura suna cewa Irmiya, ko daya daga cikin annabawa.” ");
INSERT INTO hauulb_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ya ce masu, “Amma ku wa kuke ce da ni?” ");
INSERT INTO hauulb_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Sai Saminu Bitrus ya amsa ya ce, “Kai ne Almasihu, Dan Allah mai rai.” ");
INSERT INTO hauulb_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yesu ya amsa ya ce masa, “Mai albarka ne kai, Saminu dan Yunusa, don ba nama da jini ba ne ya bayyana maka wannan, amma Ubana wanda ke cikin sama. ");
INSERT INTO hauulb_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ina kuma gaya maka cewa kai ne Bitrus, a kan wannan dutse zan gina ikilisiya ta. Kofofin hades ba za su yi nasara da ita ba. ");
INSERT INTO hauulb_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Zan ba ka mabudan mulkin sama. Duk abin da ka kulla a duniya zai zama abin da an kulla a cikin sama, kuma duk abinda ka warware a duniya a warware yake cikin sama,” ");
INSERT INTO hauulb_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Sai Yesu ya umarci almajiransa kada su gaya wa kowa cewa shi ne Almasihu. ");
INSERT INTO hauulb_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Daga lokacin nan Yesu ya fara gaya wa almajiransa cewa dole ne ya tafi Urushalima, ya sha wahala mai yawa a hannun dattawa, da manyan firistoci da malaman attaura, a kashe shi, a tashe shi zuwa rai a rana ta uku. ");
INSERT INTO hauulb_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Sai Bitrus ya kai shi a gefe ya tsauta masa, cewa, “Wannan ya yi nesa da kai, Ubangiji; wannan ba zai taba faruwa da kai ba.” ");
INSERT INTO hauulb_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Amma Yesu ya juya ya ce wa Bitrus, “Ka koma bayana, Shaidan! Kai sanadin tuntube ne gare ni, domin ba ka damuwa da abubuwan da suke na Allah, amma sai abubuwan mutane.” ");
INSERT INTO hauulb_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Sa'annan Yesu ya ce wa almajiransa, “Duk wanda yake so ya bi ni, lallai ne ya ki kansa, ya dauki gicciyensa, ya bi ni. ");
INSERT INTO hauulb_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Domin duk wanda yake so ya ceci ransa zai rasa shi. Duk wanda ya rasa ransa domina zai same shi. ");
INSERT INTO hauulb_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Domin wace riba mutum zai samu in ya sami dukan duniya ya rasa ransa? Me mutum zai iya bayarwa a maimakon ransa? ");
INSERT INTO hauulb_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Domin Dan Mutum zai zo ne cikin daukakar Ubansa tare da mala'ikunsa. Sa'annan ne zaya biya kowane mutum bisa ga ayyukansa. ");
INSERT INTO hauulb_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Gaskiya ina gaya maku, akwai wadansun ku da ke tsaye a nan, da ba za su dandana mutuwa ba sai sun ga Dan Mutum na zuwa cikin mulkinsa.” ");
INSERT INTO hauulb_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Bayan kwana shida Yesu ya dauki Bitrus da Yakubu, da Yahaya dan'uwansa, ya kai su kan wani dutse mai tsawo su kadai. ");
INSERT INTO hauulb_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Kamanninsa ya canja a gabansu. Fuskarsa ta haskaka kamar rana, kuma rigunansa suka yi kyalli fal. ");
INSERT INTO hauulb_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Sai ga Musa da Iliya sun bayyana garesu suna magana da shi. ");
INSERT INTO hauulb_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Bitrus ya amsa ya ce wa Yesu, “Ubangiji, ya yi kyau da muke a wurin nan. In kana so, zan yi bukkoki uku daya dominka, daya domin Musa, daya domin Iliya.” ");
INSERT INTO hauulb_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Sa'adda yake cikin magana, sai, girgije mai haske ya rufe su, sai murya daga girgijen, tana cewa, “Wannan kaunattacen Dana ne, shi ne wanda yake faranta mani zuciya. Ku saurare shi.” ");
INSERT INTO hauulb_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Da almajiran suka ji haka, suka fadi da fuskokinsu a kasa, saboda sun tsorata. ");
INSERT INTO hauulb_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Sai Yesu ya zo ya taba su ya ce, “Ku tashi, kada ku ji tsoro.” ");
INSERT INTO hauulb_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Amma da suka daga kai ba su ga kowa ba sai Yesu kadai. ");
INSERT INTO hauulb_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Yayin da suke saukowa daga dutsen, Yesu ya umarce su, ya ce, “Kada ku fadawa kowa wannan wahayin, sai Dan Mutum ya tashi daga matattu.” ");
INSERT INTO hauulb_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Almajiransa suka tambaye shi, suka ce, “Don me marubuta ke cewa lallai ne Iliya ya fara zuwa?” ");
INSERT INTO hauulb_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesu ya amsa ya ce, “Hakika, Iliya zai zo ya maido da dukan abubuwa. ");
INSERT INTO hauulb_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Amma ina gaya maku, Iliya ya riga ya zo, amma ba su gane shi ba. A maimakon haka, suka yi masa abin da suka ga dama. Ta irin wanan hanya, Dan Mutum kuma zai sha wuya a hannunsu. ");
INSERT INTO hauulb_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Sa'annan almajiransa suka fahimci cewa yana yi masu magana a kan Yahaya mai Baftisma ne. ");
INSERT INTO hauulb_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Da suka iso wurin taron, wani mutum ya zo gunsa, ya durkusa a gaban sa, ya ce, ");
INSERT INTO hauulb_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Ubangiji, ka ji tausayin yarona, domin yana da farfadiya, kuma yana shan wuya kwarai, domin sau da yawa yana fadawa cikin wuta ko ruwa. ");
INSERT INTO hauulb_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Na kawo shi wurin almajiran ka, amma ba su iya su warkar da shi ba.” ");
INSERT INTO hauulb_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesu ya amsa ya ce, “Marasa bangaskiya da karkataccen zamani, har yaushe zan kasance tare da ku? Har yaushe zan jure da ku? Ku kawo shi nan a wurina.” ");
INSERT INTO hauulb_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yesu ya tsauta masa, sai aljanin ya fita daga cikinsa. Yaron ya warke nan take. ");
INSERT INTO hauulb_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Sai almajiran suka zo wurin Yesu a asirce suka ce, “Me ya sa muka kasa fitar da shi?” ");
INSERT INTO hauulb_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesu ya ce masu, “Saboda karancin bangaskiyarku. Domin hakika, ina gaya maku, in kuna da bangaskiya ko da kamar kwayar mastad, za ku ce wa wannan dutse, 'Matsa daga nan ka koma can,' zai kuwa matsa kuma ba abin da zai gagare ku. ");
INSERT INTO hauulb_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Irin wannan aljanin bashi fita sai tare da addu'a da azumi. ");
INSERT INTO hauulb_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Suna zaune a Galili, Yesu ya ce wa almajiransa, “Za a bada Dan Mutum ga hannun mutane. ");
INSERT INTO hauulb_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Kuma za su kashe shi, a rana ta uku zai tashi.” Sai almajiransa suka yi bakin ciki kwarai. ");
INSERT INTO hauulb_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Da suka iso Kafarnahum, mutane masu karbar haraji na rabin shekel suka zo wurin Bitrus suka ce, “Malaminku na ba da rabin shekel na haraji?” ");
INSERT INTO hauulb_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Sai ya ce, “I.” Amma da Bitrus ya shiga cikin gida, Yesu ya fara magana da shi yace, “Menene tunaninka Saminu? Sarakunan duniya, daga wurin wa suke karbar haraji ko kudin fito? Daga talakawansu ko daga wurin baki?” ");
INSERT INTO hauulb_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Sai Bitrus ya ce, “Daga wurin baki,” Yesu ya ce masa, “Wato an dauke wa talakawansu biya kenan. ");
INSERT INTO hauulb_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Amma don kada mu sa masu karbar harajin su yi zunubi, ka je teku, ka jefa kugiya, ka cire kifin da ya fara zuwa. Idan ka bude bakinsa, za ka sami shekel. Ka dauke shi ka ba masu karbar harajin nawa da naka. ");
INSERT INTO hauulb_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Daidai wannan lokacin, almajiran suka zo wurin Yesu suka ce, ''Wanene mafi girma a mulkin sama?'' ");
INSERT INTO hauulb_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Sai Yesu ya kira karamin yaro gunsa, ya sa shi a tsakaninsu, ");
INSERT INTO hauulb_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ya ce, ''Hakika ina gaya maku, idan baku juya kun zama kamar kananan yara ba, babu yadda zaku shiga mulkin sama. ");
INSERT INTO hauulb_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Saboda haka, duk wanda ya kaskantar da kansa kamar karamin yaron nan, shi ne mafi girma a mulkin sama. ");
INSERT INTO hauulb_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Duk wanda ya karbi karamin yaro a suna na, ya karbe ni. ");
INSERT INTO hauulb_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Amma duk wanda ya sa daya daga cikin 'yan yaran nan da suka gaskanta da ni zunubi, gwamma a rataya dutsen nika a wuyansa a jefa shi cikin zurfin teku. ");
INSERT INTO hauulb_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Kaiton duniya saboda lokacin tuntube! Lallai ne wadannan lokuta su zo, amma kaiton mutumin da ta wurinsa ne wadannan lokutan za su zo! ");
INSERT INTO hauulb_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Idan hannunka ko kafarka ce za ta sa ka tuntube, ka yanke ta, ka yar daga gare ka. Zai fi maka kyau ka shiga rai da nakasa ko gurguntaka, da a jefa ka cikin madawwamiyar wuta tare da hannayenka ko kafafunka. ");
INSERT INTO hauulb_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Idan idonka zai sa ka tuntube, ka kwakule shi, ka yar. Zai fi maka kyau ka shiga rai da ido daya, da a jefa ka cikin madawwamiyar wuta da idanu biyu. ");
INSERT INTO hauulb_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Ku kula fa kada ku rena kananan nan. Domin koyaushe a sama, mala'ikunsu na duban fuskar Ubana da ke sama. ");
INSERT INTO hauulb_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Dan Mutum ya zo ya ceci abinda ya bata. ");
INSERT INTO hauulb_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Menene tunaninku? Idan mutum na da tumaki dari, sa'annan daya ta bata, ashe ba zai bar tassa'in da tara a gefen tudu ya tafi neman wadda ta bata ba? ");
INSERT INTO hauulb_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","In ya same ta, hakika ina gaya maku, farin cikinsa na samun dayan nan da ta bace, zai fi na tassa'in da taran nan da basu bata ba. ");
INSERT INTO hauulb_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Hakanan fa, ba nufin Ubanku dake sama ba ne da ya daga cikin wadannan kananan ya hallaka. ");
INSERT INTO hauulb_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Idan dan'uwanka yayi maka laifi, fada masa tsakaninku, kai da shi kadai. Idan ya saurare ka, ka maido da dan'uwanka kenan. ");
INSERT INTO hauulb_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Amma in ya ki ya saurare ka, ka je da 'yan'uwa biyu ko uku su zama shaidu, don ta wurin shaidu biyu ko uku ake tabbatar da kowacce kalma. ");
INSERT INTO hauulb_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","In kuma ya ki ya saurare su, ka kai lamarin ga ikklisiya. Idan ya ki ya saurari ikklisiya, ka maishe shi ba'al'umme da mai karbar haraji. ");
INSERT INTO hauulb_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Hakika ina gaya maku, duk abin da kuka daure a duniya, a daure yake a sama. Abin da kuka kwance kuma, a kwance yake a sama. ");
INSERT INTO hauulb_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Kuma ina gaya maku, idan mutum ku biyu zaku yarda akan duk abin da zaku roka, Ubana wanda ke a sama zai yi maku shi. ");
INSERT INTO hauulb_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Wurin da mutum biyu ko uku suka taru a cikin sunana, zan kasance tare da su.'' ");
INSERT INTO hauulb_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Bitrus ya zo ya ce wa Yesu, ''Ubangiji, sau nawa ne dan'uwana zai yi mani laifi in gafarta masa? Har sai ya kai sau bakwai?'' ");
INSERT INTO hauulb_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesu ya amsa ya ce masa, ''Ban gaya maka sau bakwai ba, amma bakwai din ma har sau saba'in. ");
INSERT INTO hauulb_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Saboda haka, za a kwatanta mulkin sama da wani sarki da yake so ya lisafta dukiyarsa dake a hannun barorinsa. ");
INSERT INTO hauulb_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Da ya fara yin haka, sai aka kawo masa daya daga cikin barorinsa da yake binsa talanti dubu goma. ");
INSERT INTO hauulb_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Amma tunda ba shi da abin biya, ubangidansa ya bada umurni a sayar da shi, tare da matarsa da 'ya'yansa da duk mallakarsa, domin a biya. ");
INSERT INTO hauulb_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Sai baran ya fadi kasa, ya rusuna a gaban ubangidansa ya ce, “Maigida, kayi mani hakuri, zan biya duk abin da na karba.” ");
INSERT INTO hauulb_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Don haka ubangidansa yayi juyayi, sai ya ce, ya yafe bashin, a saki baran. ");
INSERT INTO hauulb_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Amma bayan an saki wannan baran, ya je ya sami wani baran kamar sa da yake bi bashin dinari dari. Ya cafke shi, ya shake shi a wuya, ya ce, 'Ka biya bashin da nake bin ka.' ");
INSERT INTO hauulb_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Amma dan'uwansa bara ya roke shi ya ce, kayi mani hakuri, zan biya ka duk abinda na karba.' ");
INSERT INTO hauulb_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Amma baran nan na farko ya ki. A maimakon haka, ya sa aka jefa dan'uwansa bara a kurkuku sai ya biya bashin nan. ");
INSERT INTO hauulb_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Da sauran barori suka ga abin da ya faru, suka damu kwarai. Sai suka je suka fada wa ubangidansu yadda abin ya faru duka. ");
INSERT INTO hauulb_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Sai ubangidansa ya kirawo shi, ya ce masa, ''Kai mugun bawa, na gafarta maka bashin nan duka, domin ka roke ni. ");
INSERT INTO hauulb_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ashe, bai kamata kaima ka nuna jinkai ga dan'uwanka bara kamar yadda na nuna maka jinkai ba?' ");
INSERT INTO hauulb_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ubangidansa yayi fushi, ya danka shi ga masu azabtarwa, har sai ya gama biyan dukan bashin da ake binsa. ");
INSERT INTO hauulb_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Hakanan Ubana dake a sama zai yi maku, idan kowannenku bai gafarta wa dan'uwansa daga zuciya ba.'' ");
INSERT INTO hauulb_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Sai ya zama sa'adda Yesu ya gama wadannan maganganu, sai ya bar Galili ya zo kan iyakokin Yahudiya, ketaren kogin Urdun. ");
INSERT INTO hauulb_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Taro mai yawa suka bi shi, ya kuma warkar da su a wurin. ");
INSERT INTO hauulb_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Farisawa suka zo wurinsa, suna gwada shi, suka ce masa, ''Ya hallata bisa ga doka mutum ya saki matarsa don kowanne dalili?'' ");
INSERT INTO hauulb_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesu ya amsa ya ce, ''Baku karanta ba, cewa shi wanda ya yi su tun farko ya yi su miji da mace? ");
INSERT INTO hauulb_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Shi wanda ya yi su kuma ya ce, “Saboda wannan dalilin, mutum zai rabu da mahaifinsa da mahaifiyarsa ya hade da matarsa, su biyun su zama jiki daya?” ");
INSERT INTO hauulb_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Su ba biyu ba ne kuma, amma jiki daya. Don haka, duk abin da Allah ya hada, kada wani ya raba.'' ");
INSERT INTO hauulb_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Sai suka ce masa, ''To me yasa Musa ya umarcemu mu bada takardar saki, mu kuma kore ta?'' ");
INSERT INTO hauulb_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Sai ya ce masu, ''Saboda taurin zuciyarku, shi yasa Musa ya yarda maku ku saki matanku, amma da farko ba haka yake ba. ");
INSERT INTO hauulb_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ina gaya maku, duk wanda ya saki matarsa in ba saboda zina ba, ya kuma auri wata, yana zina kenan. Wanda kuma ya auri macen da aka saka, yana aikata zina.'' ");
INSERT INTO hauulb_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Almajiran suka ce wa Yesu, ''Idan haka yake game da mutum da matarsa, ba kyau ayi aure ba.'' ");
INSERT INTO hauulb_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Amma Yesu yace masu, ''Ba kowa ne zai karbi wannan koyarwa ba, amma sai wadanda an yardar masu su karbe ta. ");
INSERT INTO hauulb_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Akwai wadanda aka haife su babanni. Akwai wadanda mutane ne suka maida su babanni. Sa'annan akwai wadanda sun mayar da kansu babanni saboda mulkin sama. Duk wanda zai iya karbar wannan koyarwa, ya karba.'' ");
INSERT INTO hauulb_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Sai aka kawo masa yara kanana don ya dibiya hannuwansa akansu, yayi masu addu'a, amma almajiran suka kwabe su. ");
INSERT INTO hauulb_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Amma Yesu ya ce masu, ''Ku bar yara kanana, kada ku hana su zuwa wuri na, domin mulkin sama na irinsu ne.'' ");
INSERT INTO hauulb_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ya sa hannuwa akan su, sa'annan ya bar wurin. ");
INSERT INTO hauulb_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Sai wani mutum ya zo wurin Yesu, ya ce, ''Malam, wanne ayyuka nagari ne zan yi domin in sami rai madawwami?'' ");
INSERT INTO hauulb_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesu ya ce masa, ''Me yasa kake tambaya ta game da abin da ke nagari? Daya ne kawai ke nagari, amma idan kana so ka shiga cikin rai, ka kiyaye dokokin.'' ");
INSERT INTO hauulb_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Mutumin ya ce masa, ''Wadanne dokokin?'' Yesu ya ce masa, ''Kada kayi kisa, kada kayi zina, kada kayi sata, kada kayi shaidar zur, ");
INSERT INTO hauulb_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ka girmama mahaifinka da mahaifiyarka, kuma ka kaunaci makwabcinka kamar kanka.'' ");
INSERT INTO hauulb_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Saurayin nan ya ce masa, ''Ai na kiyaye duk wadannan. Me nake bukata kuma?'' ");
INSERT INTO hauulb_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesu ya ce masa, ''Idan kana so ka zama cikakke, ka tafi ka sayar da mallakarka, ka kuma ba matalauta, zaka sami dukiya a sama. Sa'annan ka zo ka biyo ni.'' ");
INSERT INTO hauulb_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Amma da saurayin nan ya ji abin da Yesu ya fada, ya koma da bakin ciki, domin shi mai arziki ne kwarai. ");
INSERT INTO hauulb_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Yesu ya ce wa almajiransa, ''Hakika ina gaya maku, zai zama da wuya mai arziki ya shiga mulkin sama. ");
INSERT INTO hauulb_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ina sake gaya maku, zai fi wa rakumi sauki ya shiga ta kafar allura, da mai arziki ya shiga mulkin Allah.'' ");
INSERT INTO hauulb_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Da almajiran sun ji haka, suka yi mamaki kwarai da gaske, suka ce, ''Wanene zai sami ceto?'' ");
INSERT INTO hauulb_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesu ya dube su, ya ce, ''A wurin mutane wannan ba zai yiwu ba, amma a wurin Allah, kome mai yiwuwa ne.'' ");
INSERT INTO hauulb_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Sai Bitrus ya amsa ya ce masa, ''Duba, mun bar kome da kome mun bi ka. To me za mu samu?'' ");
INSERT INTO hauulb_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesu ya ce masu, ''Hakika ina gaya maku, ku da kuka bi ni, a sabuwar haihuwa, lokacin da Dan Mutum ya zauna a kursiyin daukakarsa, ku ma zaku zauna a kursiyoyi goma sha biyu, kuna shari'anta kabilu goma sha biyu na Isra'ila. ");
INSERT INTO hauulb_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Duk wanda ya bar gidaje, 'yan'uwa maza, 'yan'uwa mata, mahaifi, mahaifiya, 'ya'ya, ko gonaki, saboda sunana, zai sami ninkin su dari, ya kuma gaji rai madawwami. ");
INSERT INTO hauulb_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Amma dayawa dake farko yanzu, za su zama na karshe, dayawa dake karshe kuma, su zama na farko. ");
INSERT INTO hauulb_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Gama mulkin sama yana kama da wani mai gona, wanda ya fita da asuba ya nemi 'yan kwadago da za su yi aiki a gonarsa. ");
INSERT INTO hauulb_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Bayan sun shirya kudin da zai biya ma'aikata kimanin dinari daya a kowanne yini, sai ya aike su gonarsa suyi aiki. ");
INSERT INTO hauulb_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Misalin sa'a ta uku sai ya sake fita, sai ya ga wasu ma'aikata suna tsaye a bakin kasuwa, babu aiki. ");
INSERT INTO hauulb_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Sai ya ce masu, 'Kuzo kuyi aiki a gonar, duk abinda ya wajaba, zan ba ku,' Sai suka tafi su yi aikin. ");
INSERT INTO hauulb_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Sai ya sake fita a sa'a ta shida ya kuma sake fita a sa'a ta tara, ya sake yin hakan din. ");
INSERT INTO hauulb_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ya kuma sake yin haka a sa'a ta sha daya, da ya fita sai ya ga wasu a tsaye da ba sa yin kome. Sai ya ce masu, 'Me yasa kuke tsaye ba ku yin kome dukan yini?' ");
INSERT INTO hauulb_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Sai suka ce masa, 'Ai babu wanda ya dauke mu aiki, shi yasa.' Sai ya ce masu, 'ku ma, kuje cikin gonar. ");
INSERT INTO hauulb_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Da yamma ta yi, sai mai gonar ya ce wa manajansa, 'Ka kira ma'aikatan nan ka biya su hakkin su, amma ka fara da wadanda suka zo a karshe, zuwa na farkon.' ");
INSERT INTO hauulb_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Sa'adda wadanda suka fara aiki da yamma suka zo, an biya su daidai yadda ake biya a yini. ");
INSERT INTO hauulb_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Da wadanda suka fara aiki tun safe suka zo, suna tsammani za a ba su fiye da wadanda sun zo daga baya, amma aka ba kowannensu dinari daya. ");
INSERT INTO hauulb_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Da suka karbi hakkinsu, suka yi gunaguni game da mai gonar. ");
INSERT INTO hauulb_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Suka ce, 'Wadannan da suka zo a karshe, sa'a guda ce kadai suka yi aiki, amma ka ba su daidai da mu, mu da muka yi fama da aiki cikin zafin rana.' ");
INSERT INTO hauulb_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Amma mai gonar ya amsa wa daya daga cikin su, ya ce, 'Aboki na, ban yi maku laifi ba. Ai mun shirya zan biya ku yadda ake biya a yini, ko ba haka ba? ");
INSERT INTO hauulb_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ku karbi abin da ke na ku, ku tafi. Ganin dama ta ne, in ba wadannan da suka zo a karshe daidai da ku. ");
INSERT INTO hauulb_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ashe, ba daidai bane a gare ni, in yi abin da na ga dama da mallaka ta? Ko kishi ne kuke yi saboda kirki na?' ");
INSERT INTO hauulb_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Haka yake, na karshe za su zama na farko, na farko kuma su zama na karshe.'' An kira dayawa, amma kadan ne zababbu. ");
INSERT INTO hauulb_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Da Yesu zai tafi Urushalima, ya dauki sha-biyun nan a gefe, yayin da suke tafiya, sai ya ce masu, ");
INSERT INTO hauulb_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Ku duba fa, zamu tafi Urushalima, kuma za a bada Dan Mutum ga manyan firistoci da marubuta. Za su kuma yanke masa hukuncin kisa, ");
INSERT INTO hauulb_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","za su kuma bada shi ga al'ummai don suyi masa ba'a, su bulale shi, su kuma gicciye shi. Amma a rana ta uku, za a tada shi.'' ");
INSERT INTO hauulb_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Sai uwar 'ya'yan Zabadi ta zo wurin Yesu tare da 'ya'yanta. Ta rusuna a gabansa tana neman alfarma a wurinsa. ");
INSERT INTO hauulb_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesu ya ce mata, Me kike so in yi maki?'' Sai ta ce masa, ''Ina so ka ba 'ya'yana izinin zama a mulkinka, daya a hannun damanka, daya kuma a hannun hagunka. ");
INSERT INTO hauulb_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Amma Yesu ya amsa, ya ce, ''Baku san abin da kuke roko ba. Ko zaku iya sha daga cikin kokon da zan sha bada dadewa ba?'' Sai suka ce masa, ''Zamu iya.'' ");
INSERT INTO hauulb_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Sai ya ce masu, ''In dai kokon nan da zan sha ne, lallai zaku sha. Amma, zama a hannun dama na da kuma hannun hagu na, ba ni ne mai bayarwa ba, amma na wadanda Uba na ya shirya domin su ne.'' ");
INSERT INTO hauulb_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Sa'anda sauran almajirai goma suka ji haka, sun yi bacin rai da 'yan'uwan nan biyu. ");
INSERT INTO hauulb_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Amma Yesu ya kira su wurin sa, ya ce, ''Kuna sane da cewa, sarakunan al'ummai suna gwada masu mulki, manyan-gari kuma na nuna masu iko. ");
INSERT INTO hauulb_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ba zai kasance haka a tsakanin ku ba. A maimakon haka, duk wanda ke da marmari ya zama da girma a tsakanin ku, ya zama baran ku. ");
INSERT INTO hauulb_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Wanda kuma ke da marmari ya zama na farko a cikin ku, ya zama baran ku. ");
INSERT INTO hauulb_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Kamar dai yadda Dan mutum bai zo don a bauta masa ba, amma yayi bauta, ya kuma bada ransa fansa domin mutane dayawa.'' ");
INSERT INTO hauulb_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Da suka fita daga Yariko, babban taro suka bi shi. ");
INSERT INTO hauulb_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Suka kuma ga makafi biyu zaune a bakin hanya. Da makafin suka ji cewa Yesu ne ke wucewa, sai suka tada murya suna cewa, ''Ya Ubangiji, Dan Dauda, kayi mana jinkai.'' ");
INSERT INTO hauulb_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Amma jama'ar suka tsauta masu, suka ce suyi shiru. Duk da haka, makafin suka kara tada murya fiye da na da, suka ce, ''Ya Ubangiji, Dan Dauda, kayi mana jinkai.'' ");
INSERT INTO hauulb_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Sai Yesu ya tsaya cik, ya sa aka kira su, sai ya ce masu, ''Me kuke so in yi maku?'' ");
INSERT INTO hauulb_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Sai suka ce masa, Ya Ubangiji, muna so mu sami ganin gari.'' ");
INSERT INTO hauulb_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Sai Yesu yayi juyayi a cikin sa, ya taba idanunsu. Nan da nan, suka sami ganin gari, suka kuma bi shi. ");
INSERT INTO hauulb_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yayinda Yesu da almajiransa suka kusato Urushalima sai suka zo Betafaji wajen dutsen zaitun, sai Yesu ya aiki almajiransa guda biyu, ");
INSERT INTO hauulb_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","yace masu, “Ku shiga kauyen da yake gaban ku zaku iske wata jaka da aholaki tara da ita. Ku kwance su ku kawo mani su. ");
INSERT INTO hauulb_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Idan wani ya gaya maku wani abu game da haka, sai ku ce, 'Ubangiji ne yake bukatarsu,' mutumin kuwa zai aiko ku da su nan da nan.” ");
INSERT INTO hauulb_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Anyi wannan kuwa domin a cika annabcin anabin. Yace, ");
INSERT INTO hauulb_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Ku cewa diyar Sihiyona, duba, ga sarkinki na zuwa wurin ki, mai tawali'u ne, kuma akan jaki wanda aholaki ne.” ");
INSERT INTO hauulb_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Sai almajiran suka tafi suka yi kamar yadda Yesu ya umarce su. ");
INSERT INTO hauulb_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Suka kawo jakar da dan aholakin, suka sa tufafinsu akai, Yesu kuwa ya zauna akan tufafin. ");
INSERT INTO hauulb_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Yawancin jama'a kuwa suka baza tufafinsu akan hanya, wasu kuma suka yanko ganye daga bishiyoyi suka shimfida su a hanya. ");
INSERT INTO hauulb_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Taron jama'a da suke gabansa da wadanda suke bayansa, suka ta da murya suna cewa, “Hossana ga dan Dauda! mai albarka ne shi wanda ke zuwa cikin sunan Ubangiji. Hossana ga Ubangiji!” ");
INSERT INTO hauulb_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Sa'adda Yesu ya shiga Urushalima sai doki ya cika birnin ana cewa, “Wanene wannan?” ");
INSERT INTO hauulb_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Sai jama'a suka amsa, “Wannan shine Yesu annabi, daga Nazaret ta Galili.” ");
INSERT INTO hauulb_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Sai Yesu ya shiga haikalin. Ya kori duk wadanda ke saye da sayarwa a cikin ikiilisiya. Ya birkice teburan masu canjin kudi da kujerun masu sayar da tantabaru. ");
INSERT INTO hauulb_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ya ce masu, “A rubuce yake, 'Za a kira gidana gidan addu'a,' amma kun mayar dashi kogon 'yan fashi.” ");
INSERT INTO hauulb_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Sai makafi da guragu suka zo wurin sa a haikalin, ya warkar da su. ");
INSERT INTO hauulb_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Amma da manyan firistoci da malaman attaura suka ga abubuwan banmamaki da yayi, kuma sa'adda suka ji yara suna tada murya a cikin haikalin suna cewa, “Hossana ga dan Dauda,” sai suka ji haushi. ");
INSERT INTO hauulb_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Suka ce masa, kana jin abinda wadannan mutanen ke fadi?'' Yesu ya ce masu, “I! Amma ba ku taba karantawa ba, 'daga bakin jarirai da masu shan mama ka sa yabo'?” ");
INSERT INTO hauulb_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Sai Yesu ya bar su, ya fice daga birnin zuwa Betaniya ya kwana a wurin. ");
INSERT INTO hauulb_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Washegari da safe yayin da yake komawa birnin, sai yaji yunwa. ");
INSERT INTO hauulb_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Da ya ga bishiyar baure a bakin hanya, sai yaje wurin amma bai sami kome ba sai dai ganye. Sai ya ce mata, “Kada ki kara yin 'ya'ya har abada.” Sai nan take bishiyar bauren ta bushe. ");
INSERT INTO hauulb_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Da almajiran suka ga haka, sai suka yi mamaki suka ce, “Kaka bishiyar bauren ta bushe nan da nan?” ");
INSERT INTO hauulb_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesu ya amsa yace masu, “Hakika ina ce maku, in dai kuna da bangaskiya ba ku yi shakka ba, ba abinda aka yi wa bauren nan kadai za kuyi ba har ma za ku cewa tsaunin nan, “Ka ciru ka fada teku,' sai kuwa haka ta kasance. ");
INSERT INTO hauulb_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Kome kuka roka cikin addu'a, in dai kun gaskanta, za ku samu.” ");
INSERT INTO hauulb_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Sa'adda Yesu ya shiga haikalin, sai manyan fristocin da shugabannin jama'a suka zo suka same shi yayin da yake koyarwa, suka ce, “Da wane iko kake yin wadannan abubuwa?” ");
INSERT INTO hauulb_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesu ya amsa yace masu, “Ni ma zan yi maku tambaya daya. In kun fada mani, ni ma zan fada maku ko da wane iko nake yin wadannan abubuwa. ");
INSERT INTO hauulb_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Daga ina baftismar Yahaya ta fito, daga sama ko kuma daga mutune?” Sai suka yi shawara a tsakanin su, suka ce, “In munce, 'daga sama,' zai ce mana, 'don me bamu gaskanta dashi ba?' ");
INSERT INTO hauulb_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Amma in munce, ' daga mutune,' muna tsoron jama'a, saboda sun san Yahaya annabi ne.” ");
INSERT INTO hauulb_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Sai suka amsa ma Yesu suka ce, ''Bamu sani ba.” Shi ma yace masu, “Nima bazan gaya maku ko da wane iko nake yin abubuwan nan ba. ");
INSERT INTO hauulb_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Amma me kuke tunani? Wani mutum yana da 'ya'ya biyu. Ya je wurin na farkon yace, 'Da, je ka kayi aiki yau a cikin gona.' ");
INSERT INTO hauulb_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Yaron ya amsa yace, 'bazan yi ba,' amma daga baya ya canza tunaninsa ya tafi. ");
INSERT INTO hauulb_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Sai mutumin ya je wurin da na biyun ya fada masa abu guda. Wannan dan ya amsa ya ce, 'zanje, baba,' amma bai je ba. ");
INSERT INTO hauulb_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Wanene a cikin 'ya'ya biyun nan yayi nufin ubansa?” Suka ce, “na farkon.” Yesu ya ce masu, “Hakika ina gaya maku, masu karbar haraji da karuwai za su shiga mulkin Allah kafin ku. ");
INSERT INTO hauulb_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Gama Yahaya ya zo maku a hanyar adalci, amma ba ku gaskata da shi ba, a yayinda masu karbar haraji da karuwai suka gaskata da shi. Ku kuwa, bayan kun ga abin da ya faru, baku ma tuba daga baya ba don ku gaskata da shi. ");
INSERT INTO hauulb_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ku saurari wani misalin. Anyi wani mutum, mai gona. Yayi shuka a gonar, ya shinge ta, ya gina ramin matse inabi a cikin gonar, ya kuma gina wata hasumiyar tsaro, sai ya bada hayar gonar ga wadansu manoma. Sai ya tafi wata kasa. ");
INSERT INTO hauulb_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Da kakar inabi ta yi, sai ya aiki wadansu bayi su karbo masa amfanin gonar. ");
INSERT INTO hauulb_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Amma manoman suka kama bayin, suka doddoki dayan, suka kashe dayan, suka jejjefe dayan da duwatsu. ");
INSERT INTO hauulb_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Sai mai gonar ya sake aika wadansu bayinsa da suka fi na farko, amma manoman suka yi masu kamar yadda suka yi wa sauran. ");
INSERT INTO hauulb_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Bayan wannnan, sai mai gonar ya aika da dansa wurin su yana cewa, 'za su yi wa dana biyayya.' ");
INSERT INTO hauulb_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Amma da manoman suka ga dan, sai suka ce a tsakanin su, 'wannan shine magajin. Kuzo, mu kashe shi mu gaji gonar.' ");
INSERT INTO hauulb_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Sai suka dauke shi, suka jefar da shi daga cikin gonar, suka kashe shi. ");
INSERT INTO hauulb_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","To idan me gonar ya zo, me zai yiwa manoman? ");
INSERT INTO hauulb_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Suka ce masa, “Zai hallaka mugayen manoman nan ta hanya mai tsanani, zai kuma bada gonar haya ga wadansu manoman, mutanen da za su biya, lokacin da inabin ya nuna.” ");
INSERT INTO hauulb_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yesu yace masu, “Baku taba karantawa a nassi ba,'' 'Dutsen da magina suka ki ya zama dutse mafi amfani. Wannan daga Ubangijine, kuma abin mamaki ne a idanunmu?' ");
INSERT INTO hauulb_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Saboda haka ina gaya maku, za a karbe mulkin Allah daga wurin ku a ba wata al'umma da zata bada amfaninsa. ");
INSERT INTO hauulb_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Duk wanda ya fadi akan dutsen nan zai ragargaje. Amma duk wanda dutsen ya fadawa, zai nike.” ");
INSERT INTO hauulb_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Da manyan firistocin da farisawan suka ji wannan misalin, sai suka gane da su yake. ");
INSERT INTO hauulb_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Da suka nemi kama shi, sai suka ji tsoron taron, saboda mutanen sun dauke shi annabi. ");
INSERT INTO hauulb_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesu ya sake yi masu magana da misalai, yace, ");
INSERT INTO hauulb_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Mulkin sama yana kama da wani sarki wanda ya shirya wa dansa liyafar aure. ");
INSERT INTO hauulb_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ya aiki bayinsa su kira wadanda aka gayyata su zo liyafar auren, amma suka ki zuwa. ");
INSERT INTO hauulb_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Sai sarkin ya sake aiken wasu bayin, yace, “Ku gaya wa wadanda aka gayyata, “Duba, na shirya liyafata. An yanka bajimaina da kosassun 'yanmarukana, an gama shirya komai. Ku zo wurin bikin auren.” ");
INSERT INTO hauulb_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Amma mutanen ba su dauki sakon da mahimmanci ba kuma suka yi tafiyarsu. Wani ga gonarsa, wani ga kasuwancinsa. ");
INSERT INTO hauulb_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Sauran kuma suka kama bayin sarkin, suka wulakanta su, suka kuma kashe su. ");
INSERT INTO hauulb_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Amma sarkin ya ji haushi. Ya aika sojojinsa, ku kashe masu kisan kan nan, ku kuma kone birnin su. ");
INSERT INTO hauulb_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Sai ya ce wa bayinsa, 'An gama shirya bikin, amma wadanda aka gayyata ba su cancanta ba. ");
INSERT INTO hauulb_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Saboda haka ku je bakin hanya ku gayyaci iyakar yawan mutanen da za ku samu zuwa bukin auren.' ");
INSERT INTO hauulb_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Bayin suka tafi hanya suka tattaro dukan mutanen da suka samu, da masu kyau da marassa kyau. Zauren auren kuwa ya cika makil da baki. ");
INSERT INTO hauulb_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Amma da sarkin ya zo don ya ga bakin, sai ya ga wani wanda bai sa kayan aure ba. ");
INSERT INTO hauulb_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Sai sarkin ya ce masa, 'Aboki, ta yaya ka shigo nan ba tare da kayan aure ba?' Mutumin kuwa ya rasa ta cewa. ");
INSERT INTO hauulb_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Sai sarkin ya ce wa bayinsa, 'Ku daure mutumin nan hannu da kafa, ku jefa shi cikin duhun, inda za ayi kuka da cizon hakora.' ");
INSERT INTO hauulb_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Gama mutane dayawa aka kira, amma kadan aka zaba.”' ");
INSERT INTO hauulb_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Sai Farisawan suka tafi suka shirya makirci akan yadda zasu kama shi ta maganarsa. ");
INSERT INTO hauulb_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Suka tura masa almajiransu, da Hirudiyawa. Suka ce ma Yesu, “Mallam, mun san kai mai gaskiya ne, kuma kana koyar da hanyar Ubangiji da gaskiya. Ba ka damu da ra'ayin kowa ba, kuma ba ka nuna bambanci a tsakanin mutane. ");
INSERT INTO hauulb_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","To gaya mana, menene tunaninka? Ya halarta a biya haraji ga Kaisar ko a'a?” ");
INSERT INTO hauulb_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Amma Yesu ya gane muguntarsu yace, “Don me kuke gwada ni, ku munafukai? ");
INSERT INTO hauulb_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ku nuna mani sulen harajin.” Sai suka kawo masa sulen. ");
INSERT INTO hauulb_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Yesu yace masu, “Hoto da sunan wanene wadannan?” ");
INSERT INTO hauulb_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Suka ce masa, “Na Kaisar.” Sai Yesu ya ce masu, “To ku ba Kaisar abubuwan dake na Kaisar, Allah kuma abubuwan dake na Allah.” ");
INSERT INTO hauulb_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Da suka ji haka, suka yi mamaki. Sai suka bar shi suka tafi. ");
INSERT INTO hauulb_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","A ran nan sai wadansu Sadukiyawa, wadanda suka ce ba tashin matattu, suka zo wurinsa. Suka tambaye shi, ");
INSERT INTO hauulb_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","cewa, “Mallam, Musa yace, 'Idan mutum ya mutu, bashi da 'ya'ya, dole dan'uwansa ya auri matarsa ya kuwa haifawa dan'uwansa 'ya'ya. ");
INSERT INTO hauulb_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Akwai wasu 'yan'uwa bakwai. Na farkon yayi aure sai ya mutu. Da shike bai bar 'ya'ya ba. Ya bar wa dan'uwansa matarsa. ");
INSERT INTO hauulb_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Sai dan'uwansa na biyu shi ma yayi haka, haka kuma na ukun, har zuwa dan'uwan na bakwai. ");
INSERT INTO hauulb_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Bayan dukansu, sai matar ta mutu. ");
INSERT INTO hauulb_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","To a tashin matattu, matar wa zata zama a cikin su bakwai din? Don duk sun aure ta.” ");
INSERT INTO hauulb_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Amma Yesu ya amsa yace masu, “Kun bata, domin ba ku san litattafai ko ikon Allah ba. ");
INSERT INTO hauulb_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Domin a tashin matattu basu aure, ba kuma a bada su aure. Maimaikon haka, suna kama da mala'ikun sama. ");
INSERT INTO hauulb_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Amma game da tashin matattu, ba ku karanta abinda Allah ya fada maku ba, cewa, ");
INSERT INTO hauulb_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","'Nine Allah na Ibrahim, Allah na Ishaku, da Allah na Yakubu'? Allah ba Allah na matattu bane, amma na rayayyu.” ");
INSERT INTO hauulb_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Da taron suka ji haka, sai suka yi mamakin koyarwarsa. ");
INSERT INTO hauulb_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Amma da Farisawan suka ji cewa Yesu ya kure Sadukiyawa, sai suka tattara kansu. ");
INSERT INTO hauulb_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Daya daga cikinsu, masanin shari'a, yayi masa tambaya, yana gwada shi- ");
INSERT INTO hauulb_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Mallam, wace doka ce mafi girma a cikin shari'a?” ");
INSERT INTO hauulb_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesu yace masa, “Ka kaunaci Ubangiji Allahnka da dukkan zuciyarka, da dukkan ranka, da dukkan hankalinka.' ");
INSERT INTO hauulb_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Wannan itace babbar doka ta farko. ");
INSERT INTO hauulb_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Doka ta biyu kuma kamar ta take- 'Ka kaunaci makwabcinka kamar kanka.' ");
INSERT INTO hauulb_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Akan wadannan dokoki ne dukkan shari'a da annabawa suka rataya.” ");
INSERT INTO hauulb_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Yayin da Farisawa suke tattare wuri daya, Yesu yayi masu tambaya. ");
INSERT INTO hauulb_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Yace, “Me kuke tunani game da Almasihu? Shi dan wanene?” Suka ce masa, ''Dan Dauda ne.” ");
INSERT INTO hauulb_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yesu yace masu, “To ta yaya kuma Dauda cikin Ruhu ya kira shi Ubangiji, yana cewa, ");
INSERT INTO hauulb_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Ubangiji ya cewa wa Ubangijina, zauna a hannun damana, har sai na mai da makiyanka matakin sawayenka.” ");
INSERT INTO hauulb_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Idan Dauda ya kira Almasihu 'Ubangiji,' ta yaya ya zama dan Dauda?” ");
INSERT INTO hauulb_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ba wanda ya iya bashi amsa, ba kuma wanda ya kara yi masa tambayoyi tun daga wannan rana. ");
INSERT INTO hauulb_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Sai Yesu yayi wa taron da alamajiransa magana. ");
INSERT INTO hauulb_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Ya ce, “Marubuta da Farisawa suna zaune a mazaunin Musa. ");
INSERT INTO hauulb_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Don haka, duk abinda suka umarceku kuyi, kuyi wadannan abubuwa ku kuma kiyaye su. Amma kada kuyi koyi da ayyukansu, gama suna fadar abubuwa amma kuma ba su aikata su. ");
INSERT INTO hauulb_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","I, sukan daura kaya masu nauyi, masu wuyar dauka, daga nan su dauka su jibga wa mutane a kafada. Amma su kan su baza su mika danyatsa ba su dauka. ");
INSERT INTO hauulb_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Duk ayyukan su suna yi ne don mutane su gani, suna dinka aljihunan nassinsu da fadi, suna fadada iyakokin rigunansu. ");
INSERT INTO hauulb_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Su na son mafifitan wuraren zama a gidan biki, da mafifitan wuraren zama a majami'u, ");
INSERT INTO hauulb_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","da kuma gaisuwar musamman a wuraren kasuwanci, a kuma rika ce da su 'mallam.' ");
INSERT INTO hauulb_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Amma ba sai an kira ku 'mallam, ba' domin malami daya kuke da shi, ku duka kuwa 'yan'uwan juna ne. ");
INSERT INTO hauulb_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Kada ku kira kowa 'Ubanku' a duniya, domin Uba daya ne ku ke da shi, kuma yana sama. ");
INSERT INTO hauulb_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Kada kuma a kira ku malamai, saboda malamin ku daya ne, shi ne Almasihu. ");
INSERT INTO hauulb_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Amma wanda yake babba a cikin ku zaya zama bawanku. ");
INSERT INTO hauulb_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Duk wanda ya daukaka kansa za a kaskantar dashi. Duk wanda ya kaskantar da kansa kuma za a daukaka shi. ");
INSERT INTO hauulb_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Amma kaiton ku marubuta da Farisawa, munafukai! Kun toshewa mutane kofar mulkin sama. Baku shiga ba, kuma ba ku bar wadanda suke so su sami shiga ba. ");
INSERT INTO hauulb_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","kaiton ku marubuta da Farisawa, domin kuna hallaka gwauraya - ");
INSERT INTO hauulb_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Kaiton ku marubuta da Farisawa, munafukai! Kuna tafiya ketaren tekuna da kasashe domin samun almajiri daya tak, in kwa kun samu kukan mai da shi biyunku danwuta. ");
INSERT INTO hauulb_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Kaiton ku, makafin jagora, kuda kuke cewa, Kowa ya rantse da Haikali, ba komai. Amma duk wanda ya rantse da zinariyar Haikalin, rantsuwarsa ta daure shi.' ");
INSERT INTO hauulb_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ku wawayen makafi! wanene yafi girma, zinariyar ko kuwa Haikalin da yake tsarkake zinariyar? ");
INSERT INTO hauulb_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Kuma, 'Kowa ya rantse da bagadi, ba komai bane. Amma duk wanda ya rantse da baikon da aka dora a kai, sai rantsuwarsa ta kama shi.' ");
INSERT INTO hauulb_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ku makafi! Wanene yafi girma, baikon ko kuwa bagadin da yake kebe baikon ga Allah? ");
INSERT INTO hauulb_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Saboda haka, duk wanda ya rantse da bagadi, ya rantse da shi da duk abinda ke kansa. ");
INSERT INTO hauulb_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Kuma duk wanda ya rantse da Haikali ya rantse dashi da kuma wanda yake cikin sa. ");
INSERT INTO hauulb_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Kuma duk wanda ya rantse da sama, ya rantse da kursiyin Allah da kuma wanda yake zaune akai. ");
INSERT INTO hauulb_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Kaiton ku Farisawa da marubuta, munafukai! Kukan fitar da zakkar doddoya, da karkashi, da lamsur, amma kun yar da al'amuran attaura mafi nauyi-, wato, hukunci, da jinkai da bangaskiya. Wadannan ne ya kamata kuyi, ba tare da kunyi watsi da sauran ba. ");
INSERT INTO hauulb_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Makafin jagora, ku kan burtsar da kwaro dan mitsil, amma kukan hadiye rakumi! ");
INSERT INTO hauulb_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Kaiton ku marubuta da Farisawa, munafukai! kuna wanke bayan moda da kwano, amma aciki cike suke da zalunci da keta. ");
INSERT INTO hauulb_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Kai makahon Bafarise! Sai ka fara tsarkake cikin modar da kwanon domin bayansu ma su tsarkaka. ");
INSERT INTO hauulb_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Kaiton ku marubuta da Farisawa, munafukai! Kamar kaburburan da aka shafa wa farar kasa kuke, masu kyaun gani daga waje, daga ciki kuwa sai kasusuwan matattu da kazanta iri iri. ");
INSERT INTO hauulb_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Haka nan kuke a idanun mutane ku adalai ne, amma a ciki sai munafunci da mugun aiki. ");
INSERT INTO hauulb_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Kaiton ku marubuta da Farisawa, munafukai! Ku kan gina kaburburan annabawa, kuna kuma kawata kaburburan adalai. ");
INSERT INTO hauulb_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Kuna cewa, 'Da muna nan a zamanin Ubanninmu, da bamu basu goyon baya ba wajen zubar da jinin annabawa.' ");
INSERT INTO hauulb_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Domin haka kun shaida kanku ku ne 'ya'yan masu kisan annabawa. ");
INSERT INTO hauulb_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Sai kuma kuka cika ma'aunin ubanninku! ");
INSERT INTO hauulb_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","macizai, Ku 'ya'yan ganshekai, Yaya zaku tsere wa hukuncin Gidan wuta? ");
INSERT INTO hauulb_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Saboda haka, duba, ina aiko maku da annabawa, da masu hikima da marubuta. Za ku kashe wadansun su kuma ku gicciye su. Zaku yiwa wasu bulala a majami'un ku, kuna bin su gari gari. ");
INSERT INTO hauulb_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Sakamakon hakan alhakin jinin dukkan adalai da aka zubar a duniya ya komo a kan ku, tun daga jinin Habila adali har ya zuwa na Zakariya dan Barakiya, wanda kuka kashe a tsakanin Haikali da bagadi. ");
INSERT INTO hauulb_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Hakika, Ina gaya maku, duk wannan zai auko wa mutanen wannan zamani. ");
INSERT INTO hauulb_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Urushalima, Urushalima, keda kika kashe annabawa kika kuma jejjefi wadanda aka turo maki da duwatsu! Sau nawa ne naso in tattaro ki kamar yadda kaza take tattara 'yan tsakinta cikin fukafukanta, amma kin ki. ");
INSERT INTO hauulb_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ga shi an bar maku gidan ku a yashe! ");
INSERT INTO hauulb_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ina dai gaya maku, ba za ku kara gani na ba, sai ran da kuka ce, 'Albarka ta tabbata ga mai zuwa cikin sunan Ubangiji.”' ");
INSERT INTO hauulb_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu ya fita daga cikin haikalin ya kama hanyar sa. Almajiran sa suka zo suna nuna masa ginin haikali. ");
INSERT INTO hauulb_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Amma ya amsa masu yace, “kun ga dukkan wadannan abubuwan? Ina gaya maku gaskiya, ba ko dutse daya da za'a bari akan dan'uwansa wanda ba za'a rushe shi ba.” ");
INSERT INTO hauulb_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yayin da ya zauna a kan dutsen zaitun, almajiran sa suka zo wurin sa a boye suka ce, “me zai zama alamar zuwanka da kuma na karshen duniya?” ");
INSERT INTO hauulb_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesu ya amsa yace dasu, “Ku kula kada wani yasa ku kauce.” ");
INSERT INTO hauulb_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Gama da yawa za su zo da sunana. Za su ce, “ni ne almasihu,” kuma za su sa da yawa su kauce. ");
INSERT INTO hauulb_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Za ku ji labarin yake-yake da kuma shelar yake-yake. Ku kula kar ku tsorata, domin dole abubuwan nan su faru; amma karshen dai tukunna. ");
INSERT INTO hauulb_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Gama al'umma zata tayarwa al'umma, kuma mulki zai tayarwa mulki. Za'a yi yunwa da girgizar kasa a wurare dabam dabam. ");
INSERT INTO hauulb_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Amma dukkan wadannan farkon ciwon haihuwa ne kawai. ");
INSERT INTO hauulb_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Bayan haka za'a bada ku ga tsanani a kuma kashe ku. Dukkan al'ummai za su tsane ku saboda sunana. ");
INSERT INTO hauulb_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Daga nan da yawa za su yi tuntube, kuma su ci amanar juna, su kuma tsani juna. ");
INSERT INTO hauulb_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Annabawan karya da yawa za su taso kuma susa da yawa su kauce. ");
INSERT INTO hauulb_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Domin mugunta zata ribambanya, kaunar masu yawa zata yi sanyi. ");
INSERT INTO hauulb_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Amma duk wanda ya jure har karshe, zai sami ceto. ");
INSERT INTO hauulb_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Za'a yi wa'azin wannan bisharar mulkin a dukkan duniya don ya zama shaida akan dukkan al'ummai. Daganan karshen zai zo. ");
INSERT INTO hauulb_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Don haka, idan kun ga abin kyama mai lalatarwa, wanda Annabi Daniyel ya yi maganar sa, Ya tsaya a wuri mai tsarki (bari mai karatu ya fahimta), ");
INSERT INTO hauulb_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","bari wadanda ke yahudiya su gudu zuwa kan duwatsu, ");
INSERT INTO hauulb_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Bari wanda yake kan bene kada ya sauko don daukar wani abu a cikin gidansa, ");
INSERT INTO hauulb_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","kuma wanda yake gona kar ya dawo gida domin daukar babbar rigarsa. ");
INSERT INTO hauulb_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Amma kaito ga wadanda suke dauke da yaro, ko masu shayarwa a wannan kwanakin! ");
INSERT INTO hauulb_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ku yi addu'a kada gudun ku ya zama lokacin hunturu, ko ranan asabaci. ");
INSERT INTO hauulb_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Domin za'ayi tsanani mai girma, wanda ba'a taba yin irin shi ba, tun farkon duniya har ya zuwa yau, a'a ba za ayi irin shi ba kuma. ");
INSERT INTO hauulb_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","In ba don an rage kwanakin ba, da ba mahalukin da zai tsira. Amma albarkacin zababbun, za a rage kwanakin. ");
INSERT INTO hauulb_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Sa'annan idan wani yace maku, duba, “ga Almasihu a nan!” ko, “ga Almasihu a can!” kar ku gaskata. ");
INSERT INTO hauulb_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Gama annabawan karya da almasihan karya za su zo suna nuna alamu da al'ajibai, don su yaudari masu yawa zuwa ga bata, in ya yiwuma har da zababbun. ");
INSERT INTO hauulb_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Kun gani, na gaya maku kafin lokacin ya zo. ");
INSERT INTO hauulb_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Saboda haka, idan suka ce maku, “ga shi a jeji,” kar ku je jejin. Ko, “ga shi a can cikin kuryar daki,” kar ku gaskata. ");
INSERT INTO hauulb_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Yadda walkiya ke haskakawa daga gabas zuwa yamma, haka nan zuwan Dan mutum zai zama. ");
INSERT INTO hauulb_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Duk inda mushe yake, nan ungulai suke taruwa. ");
INSERT INTO hauulb_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Amma nan da nan bayan kwanakin tsananin nan, rana za ta duhunta, wata kuma ba zai ba da haskensa ba, taurari kuma za su fado daga sama, ikokin sammai za su girgiza. ");
INSERT INTO hauulb_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Sa'annan alamar Dan Mutum za ta bayyana a sararin sama, kuma dukkan kabilun duniya za su yi bakin ciki. Za su ga Dan Mutun na zuwa a gajimarai da iko da daukaka mai girma. ");
INSERT INTO hauulb_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Zai aiki mala'ikunsa, da karar kaho mai karfi, kuma za su tattara dukkan zababbu daga dukkan kusurwoyi hudu, daga karshen sararin sama har zuwa wani karshen. ");
INSERT INTO hauulb_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Kuyi koyi da itacen baure. Da zaran reshen sa ya yi toho ya fara bada ganye, za ku sani bazara ta kusa. ");
INSERT INTO hauulb_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Haka kuma, idan kun ga dukkan wadannan abubuwa, ya kamata ku sani, Ya yi kusa, ya na bakin kofa. ");
INSERT INTO hauulb_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ina gaya maku gaskiya, wannan zamanin ba zai wuce ba, sai dukkan wadannan abubuwan sun faru. ");
INSERT INTO hauulb_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Sama da kasa za su shude, amma kalmomina ba za su shude ba. ");
INSERT INTO hauulb_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Amma game da ranan nan ko sa'a ba wanda ya sani, ko mala'ikun sama, ko Dan, sai Uban kadai. ");
INSERT INTO hauulb_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Kamar yadda kwanakin Nuhu suke, haka zai zama game da zuwan Dan Mutum. ");
INSERT INTO hauulb_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","A wadannan kwankin kafin zuwan ruwan tsufana suna ci suna sha, suna aure suna aurarwa har ranar da Nuhu ya shiga jirgin, ");
INSERT INTO hauulb_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","ba su san kome ba har ruwan ya zo ya cinye su_ haka ma zuwan Dan Mutun zai zama. ");
INSERT INTO hauulb_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Sa'annan mutane biyu zasu kasance a gona za a dauke daya, a bar daya a baya. ");
INSERT INTO hauulb_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Mata biyu na nika a manika za a dauke daya, za a bar dayar. ");
INSERT INTO hauulb_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Don haka sai ku yi zaman tsaro, domin baku san ranar da Ubangijinku zai zo ba. ");
INSERT INTO hauulb_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Amma ku san wannan, idan maigida ya san lokacin da barawo zai zo, zai zauna a shirye ba zai bar gidan sa har a balle a shiga ba. ");
INSERT INTO hauulb_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Don haka sai ku shirya, domin Dan Mutum zai zo a sa'ar da ba ku yi zato ba. ");
INSERT INTO hauulb_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","To wanene amintaccen bawannan mai hikima, wanda maigidan sa ya sa ya kula mar da gida, domin ya ba su abinci a kan lokaci? ");
INSERT INTO hauulb_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Mai albarka ne bawan, da mai gidan zai same shi a kan aikin sa a lokacin da ya dawo. ");
INSERT INTO hauulb_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ina gaya maku gaskiya mai gidan zai dora shi a kan dukkan a binda yake da shi. ");
INSERT INTO hauulb_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Amma idan mugun bawa ya ce a zuciyarsa, “maigida na ya yi jinkiri,” ");
INSERT INTO hauulb_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","sai ya fara dukan sauran barorin, ya yi ta ci da sha tare da mashaya, ");
INSERT INTO hauulb_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","uban gidan bawan zai dawo a ranar da bawan bai zata ba, a lokacin da bai sani ba. ");
INSERT INTO hauulb_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Uban gidansa zai datsa shi biyu, karshen sa zai zama daidai da na munafukai, za a sashi inda a ke kuka da cizon hakora. ");
INSERT INTO hauulb_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Sa'annan mulkin sama zai zama kamar budurwai goma da suka dauki fitilunsu domin su taryi ango. ");
INSERT INTO hauulb_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Biyar daga cikin su masu hikima ne biyar kuma wawaye. ");
INSERT INTO hauulb_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Sa'adda wawayen budurwai suka dauki fitilunsu, ba su dauki karin mai ba. ");
INSERT INTO hauulb_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Amma budurwai masu hikimar suka dauki gorar mai tare da fitilunsu. ");
INSERT INTO hauulb_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","To da angon ya makara, dukkan su sai suka fara gyangyadi sai barci ya dauke su. ");
INSERT INTO hauulb_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Amma da tsakkar dare sai aka yi shela, 'Ga ango ya iso! Ku fito taryensa. ");
INSERT INTO hauulb_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Sai dukka budurwan nan suka tashi suka gyaggyara fitilunsu. ");
INSERT INTO hauulb_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Wawayen su ka ce da masu hikimar, 'Ku sammana kadan daga manku gama fitilunmu su na mutuwa.' ");
INSERT INTO hauulb_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Amma masu hikimar suka ce 'Tun da man ba zai ishe mu tare da ku ba, sai ku je gun ma su sayarwa ku sayo wa kanku. ");
INSERT INTO hauulb_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Sa'adda suka tafi sayan man, sai angon ya shigo, kuma wadanda suke a shirye su ka shiga tare da shi bukin auren, sai aka rufe kofar. ");
INSERT INTO hauulb_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Bayan dan lokaci kadan sauran budurwan suka dawo suna cewa, 'Mai gida, mai gida, bude mana kofar.' ");
INSERT INTO hauulb_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Amma ya amsa ya ce, 'A gaskiya ina gaya maku, ni ban san ku ba.' ");
INSERT INTO hauulb_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Don haka sai ku lura, don baku san rana ko sa'a ba. ");
INSERT INTO hauulb_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Domin yana kama da wani mutum da zai tafi wata kasa. Ya kira barorinsa ya ba su dukiyar sa. ");
INSERT INTO hauulb_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ga wani ya ba shi talanti biyar, ga wani ya ba shi biyu, ga wani kuma ya ba shi talanti daya. kowa an bashi gwargwadon iyawarsa, sai wannan mutum ya yi tafiyar sa ");
INSERT INTO hauulb_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","nan da nan sai wanda ya karbi talanti biyar ya sa nasa a jari, ya sami ribar wasu talanti biyar. ");
INSERT INTO hauulb_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Haka ma wanda ya karbi talanti biyu ya sami ribar wasu biyu. ");
INSERT INTO hauulb_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Amma bawan da ya karbi talanti dayan ya yi tafiyar sa, ya haka rami, ya binne kudin mai gidansa. ");
INSERT INTO hauulb_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","To bayan tsawon lokaci sai ubangidan barorin nan ya dawo, domin yayi lissafin kudinsu. ");
INSERT INTO hauulb_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Bawan da ya karbi talanti biyar, ya kawo nasa da ribar wasu biyar. Yace, 'Maigida, ka bani talanti biyar, gashi na samo ribar karin talanti biyar.' ");
INSERT INTO hauulb_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Maigidansa yace masa, 'Madalla, bawa na gari mai aminci! Ka yi aminci akan abu kadan. Zan sa ka akan abubuwa masu yawa. Ka shiga cikin farincikin maigidanka.' ");
INSERT INTO hauulb_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Bawan da ya karbi talanti biyun, ya zo yace, 'Maigida, ka ba ni talanti biyu. Gashi kuwa na sami karin ribar wasu biyun.' ");
INSERT INTO hauulb_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ubangidansa yace masa, 'Madalla, kai bawa na gari mai aminci! Ka yi aminci akan abubuwa kadan. Zan saka akan abubuwa masu yawa. Ka shiga cikin farincikin maigidanka.' ");
INSERT INTO hauulb_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Sai bawan da ya karbi talanti daya ya zo yace, 'Maigida, na san kai mai tsanani ne. Kana girbi inda baka yi shuka ba, kuma kana tattarawa inda ba ka watsa ba. ");
INSERT INTO hauulb_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Na ji tsoro, don haka sai na je na boye talantinka a rami. Duba, ga abinda yake naka.' ");
INSERT INTO hauulb_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Amma ubangidansa ya amsa yace, kai mugu malalacin bawa, ka san cewa ni mai girbi ne inda ban shuka ba kuma ina tattarawa inda ban zuba ba. ");
INSERT INTO hauulb_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","To da ba sai ka kai kudina a banki ba, da bayan na dawo da sai in karbi abina da riba. ");
INSERT INTO hauulb_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Saboda haka ku kwace talantin daga gare shi ku baiwa mai talanti goman nan. ");
INSERT INTO hauulb_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Gama ga wanda yake da shi za'a kara masa har ma a yalwace za'a kara bashi. Amma ga wanda bashi da komai abinda ke nasa ma za'a kwace. ");
INSERT INTO hauulb_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ku jefa wannan mugun bawan marar amfani, cikin duhu mai zurfi, inda ake kuka da cizon hakora.' ");
INSERT INTO hauulb_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Sa'adda Dan mutum zai zo cikin daukakarsa da dukan Mala'iku tare da shi, sa'annan zai zauna kursiyinsa na daukaka. ");
INSERT INTO hauulb_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","A gabansa za'a tattara dukkan al'ummai, zai rarraba mutanen daya'daya, kamar yadda makiyayi yake rarraba tumaki daga awaki. ");
INSERT INTO hauulb_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Zai sa tumakin a hannunsa na dama, amma awakin a hannunsa na hagu. ");
INSERT INTO hauulb_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Sa'annan sarkin zai ce wa na hannun damarsa, 'Ku zo ku da Ubana ya albarkata, ku gaji mulkin da aka shirya maku kafin a kafa duniya. ");
INSERT INTO hauulb_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Gama na ji yunwa kuka bani abinci; Na ji kishi kuka bani ruwa; Na yi bakunci kun bani masauki; ");
INSERT INTO hauulb_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Na yi huntanci kuka tufasar dani; Na yi ciwo kuka kula dani; Ina kurkuku kuka ziyarceni.' ");
INSERT INTO hauulb_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Sa'annan masu adalcin za su amsa su ce, 'Ubangiji, yaushe muka ganka kana jin yunwa muka baka abinci? Ko kana jin kishi muka baka ruwan sha? ");
INSERT INTO hauulb_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Kuma yaushe muka ganka kana bakunci har muka baka masauki? Ko kuma kana huntanci da muka tufatar da kai? ");
INSERT INTO hauulb_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Yaushe kuma muka ganka kana ciwo ko a kurkuku har muka ziyarce ka?' ");
INSERT INTO hauulb_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Sa'annan Sarkin zai amsa masu yace, 'Hakika Ina gaya maku, duk abinda kuka yi wa daya mafi kakanta daga cikin 'yan'uwana a nan ni kuka yi wa.' ");
INSERT INTO hauulb_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Sa'annan zai cewa wadanda suke hannunsa na hagu, 'Ku rabu da ni, ku la'anannu, ku tafi cikin wutar jahannama da aka shirya wa Shaidan da aljannunsa, ");
INSERT INTO hauulb_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","domin ina jin yunwa baku bani abinci ba; ina jin kishi ba ku bani ruwa ba; ");
INSERT INTO hauulb_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ina bakunci amma baku bani masauki ba; ina huntanci, baku tufasar da ni ba; ina ciwo kuma ina kurkuku, baku kula da ni ba.' ");
INSERT INTO hauulb_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Sa'annan suma zasu amsa su ce, 'Ubangiji, yaushe muka ganka kana jin yunwa, ko kishin ruwa, ko kana bakunci, ko kana huntanci, ko ciwo, kuma a kurkuku, da bamu yi maka hidima ba?' ");
INSERT INTO hauulb_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Sa'annan zai amsa ya ce masu, 'Ina gaya maku hakika abin da baku iya yiwa mafi karanta daga cikin wadannan ba, ba ku yi mani ba.' ");
INSERT INTO hauulb_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Wadannan kuwa zasu tafi cikin madawwamiyar azaba amma adalai zuwa rai madawwami.” ");
INSERT INTO hauulb_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yayin da Yesu ya gama fadi masu wadannan maganganu, sai ya cewa almajiransa, ");
INSERT INTO hauulb_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Kun sani sauran kwana biyu idin ketarewa ya zo, kuma za'a bada Dan mutum domin a gicciye shi. ");
INSERT INTO hauulb_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Sa'annan manyan firistoci da dattawan jama'a suka taru a fadar babban firist, mai suna Kayafa. ");
INSERT INTO hauulb_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Suka shirya yadda zasu kama Yesu a boye su kuma kashe shi. ");
INSERT INTO hauulb_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Amma suna cewa, “Ba a lokacin idin ba, domin kada tarzoma ta tashi daga cikin mutane.” ");
INSERT INTO hauulb_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Sa'adda Yesu yake Baita'anya a gidan Saminu Kuturu, ");
INSERT INTO hauulb_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","daidai lokacin da ya zauna a gefen teburin cin abinci, sai wata mata ta shigo da kwalbar mai, mai tsada, ta zuba wa Yesu a kansa. ");
INSERT INTO hauulb_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Amma da almajiransa suka ga haka, sai suka ji haushi suka ce, “Ina dalilin yin irin wannan asara? ");
INSERT INTO hauulb_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ai da an sayar da wannan mai da kudi mai yawa a rabawa talakawa.” ");
INSERT INTO hauulb_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Amma da yake Yesu ya san tunaninsu, sai yace masu, “Don me kuke damun matar nan? Ta yi abu mai kyau domina. ");
INSERT INTO hauulb_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Kuna da talakawa tare da ku koyaushe, amma ni ba zan kasance da ku ba koyaushe. ");
INSERT INTO hauulb_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Don a sa'adda ta zuba man nan a jikina, ta yi haka ne don jana'iza ta. ");
INSERT INTO hauulb_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Hakika Ina gaya maku, duk inda za ayi wannan bishara a dukan duniya, abin da matar nan tayi za'a rika ambatar da shi don tunawa da ita.” ");
INSERT INTO hauulb_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Sai daya daga cikin sha biyun, mai suna Yahuza Iskariyoti, ya tafi wurin manyan firistocin, ");
INSERT INTO hauulb_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","yace, ''Me kuke da niyyar bani idan na mika maku shi?” Suka auna masa azurfa talatin. ");
INSERT INTO hauulb_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Daga wannan lokacin yayi ta neman zarafi da zai bada shi a wurinsu. ");
INSERT INTO hauulb_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","To a rana ta fari na idin ketarewa almajiran suka zo wurin Yesu suka ce, ''Ina kake so mu shirya maka da zaka ci abincin idin ketarewa?” ");
INSERT INTO hauulb_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yace, “Ku shiga cikin birnin zaku sami wani mutum sai kuce masa, 'Mallam yace, “lokaci na ya kusa. Zan ci idin ketarewa a gidanka, da almajiraina.”''' ");
INSERT INTO hauulb_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Almajiran suka yi kamar yadda Yesu ya umarce su, suka shirya abincin idin ketarewar. ");
INSERT INTO hauulb_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Da yamma ta yi, sai ya zauna domin ya ci tare da almajiransa goma sha biyu. ");
INSERT INTO hauulb_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Sa'adda suke ci, yace, “Hakika ina gaya maku, daya daga cikin ku zai bada ni.” ");
INSERT INTO hauulb_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Suka yi bakin ciki, suka fara tambayarsa daya bayan daya, ''Na tabbata ba ni bane ko, Ubangiji?” ");
INSERT INTO hauulb_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Sai ya amsa, “Wanda ke sa hannu tare da ni cikin kwano daya shi ne zai bada ni. ");
INSERT INTO hauulb_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Dan mutum zai tafi, kamar yadda aka rubuta akan sa. Amma kaiton mutumin da ta wurin sa za'a bada Dan mutum! Gwamma da ba'a haifi mutumin nan ba.” ");
INSERT INTO hauulb_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yahuza da zai bada shi yace, “Mallam ko ni ne?” Yace masa, “Ka fada da kanka.” ");
INSERT INTO hauulb_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Yayin da suke ci, sai Yesu ya dauki gurasa, ya sa albarka, ya karya. Ya ba almajiran yace, “Ku karba, ku ci, wannan jiki nane.” ");
INSERT INTO hauulb_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Sai ya dauki kokon yayi godiya, Ya ba su yace, “Ku sha, dukanku. ");
INSERT INTO hauulb_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","“Gama wannan jinina ne na alkawari wanda aka zubar domin gafarar zunuban mutane da yawa. ");
INSERT INTO hauulb_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Amma ina gaya maku, ba zan kara shan ruwan inabin nan ba, sai ranar da zan sha shi sabo tare da ku a cikin mulkin Ubana.” ");
INSERT INTO hauulb_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Da suka raira waka, sai suka ka tafi dutsen zaitun. ");
INSERT INTO hauulb_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Sai Yesu yace masu, “Dukan ku zaku yi tuntube a wannan dare sabili da ni, gama a rubuce yake, ''Zan bugi makiyayin, garken tumakin kuma za su watse.' ");
INSERT INTO hauulb_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Amma bayan an tashe ni, zan riga ku zuwa Galili.” ");
INSERT INTO hauulb_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Amma Bitrus yace masa, “Ko dama duka zasu fadi sabili da kai, ni kam bazan fadi ba.” ");
INSERT INTO hauulb_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesu yace masa, ''Hakika ina gaya maka, a wannan daren kafin carar zakara, za ka yi musun sani na sau uku.” ");
INSERT INTO hauulb_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Bitrus yace masa, koda zan mutu tare da kai, bazan yi musunka ba.” Sai sauran almajiran suma suka fadi haka. ");
INSERT INTO hauulb_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Sa'anna Yesu ya tafi tare da su, wurin da ake kira Getsaimani sai yace wa almajiransa, ''Ku zauna a nan ni kuma zan je gaba in yi addu'a.” ");
INSERT INTO hauulb_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ya dauki Bitrus da kuma 'ya'ya biyu na Zabadi tare da shi, sai ya fara damuwa da juyayi. ");
INSERT INTO hauulb_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Sai yace masu, “Raina na cikin damuwa sosai har ga mutuwa. Ku kasance anan kuna tsaro tare da ni.” ");
INSERT INTO hauulb_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ya dan taka zuwa gaba kadan, sai ya fadi a fuskarsa, yayi addu'a. Yace, “Ya Ubana, in zai yiwu, bari kokon nan ya wuce ni. Duk da haka, ba nufina za'a bi ba, amma naka nufin.” ");
INSERT INTO hauulb_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ya koma wurin almajiran ya same su suna barci, sai ya cewa Bitrus, “Kai, ba zaku yi tsaro tare da ni ba koda sa'a daya? ");
INSERT INTO hauulb_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ku yi tsaro kuma, kuyi addu'a domin kada ku fada cikin jaraba. Ruhu dai ya yarda amma, jiki ba karfi.” ");
INSERT INTO hauulb_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Sai ya koma karo na biyu yayi addu'a, Yace, “Ya Ubana, in wannan kokon ba zai wuce ba sai na sha shi, bari nufinka ya kasance.” ");
INSERT INTO hauulb_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ya sake dawowa, ya same su suna barci, domin idanunsu sun yi nauyi. ");
INSERT INTO hauulb_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Sai ya sake barinsu ya tafi. Ya koma karo na uku yana addu'a yana fadin kalmomi iri daya. ");
INSERT INTO hauulb_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Sai Yesu ya koma wurin almajiran yace masu, “Har yanzu barci kuke kuna hutawa? Duba, lokaci ya kusato, kuma an bada Dan mutum ga hannun masu zunubi. ");
INSERT INTO hauulb_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ku tashi mu tafi. Duba, wanda zai badani ya kusato.” ");
INSERT INTO hauulb_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Sa'adda yana cikin magana Yahuza, daya daga cikin sha biyun, ya zo. Babban taro ya zo tare da shi daga wurin manyan firistoci da dattawan jama'a. Suna rike da takubba da kulake. ");
INSERT INTO hauulb_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","To mutumin da zai bada Yesu ya rigaya ya basu alama, cewa, ''Duk wanda na sumbata, shine. Ku kama shi.'' ");
INSERT INTO hauulb_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Nan da nan ya kaiga Yesu ya ce, “Gaisuwa, Mallam!” sai ya sumbace shi. ");
INSERT INTO hauulb_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesu kuwa yace masa, “Aboki, kayi abin da ya kawo ka.” Sai suka iso suka sa hannuwansu kan Yesu suka kama shi. ");
INSERT INTO hauulb_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Nan take, daya daga cikin wadanda suke tare da Yesu ya mika hannunsa, ya zare takobinsa, ya sare wa bawan babban firist din kunne. ");
INSERT INTO hauulb_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Sai Yesu yace, masa, “Ka maida takobinka cikin kubensa, domin duk wadanda suka dauki takobi su ma ta wurin takobi za su hallaka. ");
INSERT INTO hauulb_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ko kana tunanin ba zan iya kiran Ubana ba, ya kuma aiko da rundunar Mala'iku fiye da goma sha biyu? ");
INSERT INTO hauulb_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Amma to tayaya za'a cika nassi, cewa dole wannan ya faru?'' ");
INSERT INTO hauulb_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","A wannan lokacin Yesu yace wa taron, “Kun zo da takubba da kulake ku kama ni kamar dan fashi? Ina zaune kowace rana a haikali ina koyarwa, amma baku kama ni ba. ");
INSERT INTO hauulb_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Amma duk wannan ya faru ne don a cika abinda annabawa suka rubuta.” Bayan haka sai dukkan almajiran suka bar shi suka gudu. ");
INSERT INTO hauulb_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Wadanda suka kama Yesu, suka kai shi wurin Kayafa babban firist, inda marubuta da duttawan jama'a suka taru. ");
INSERT INTO hauulb_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Amma Bitrus ya bi shi daga nesa, har zuwa farfajiyar babban firist din. Ya shiga ya zauna da masu tsaro domin ya ga abinda zai faru. ");
INSERT INTO hauulb_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","A wannan lokaci manyan firistoci da duk 'yan majalisar suka fara neman shaidar karya akan Yesu, domin su samu su kashe shi. ");
INSERT INTO hauulb_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Amma ba su samu ko daya ba, ko dayake an samu shaidun karya dayawa da suka gabata. Amma daga baya sai wasu su biyu suka fito ");
INSERT INTO hauulb_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","sukace ''Wannan mutum yace zan iya rushe haikalin Allah, in kuma gina shi cikin kwana uku.''' ");
INSERT INTO hauulb_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Babban Firist din ya tashi tsaye yace masa, “Ba zaka ce komai ba? Wace irin shaida ce ake yi akanka?” ");
INSERT INTO hauulb_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Amma Yesu yayi shiru. Babban Firist ya ce, “Na umarce ka da sunan Allah mai rai, ka gaya mana ko kai Almasihu ne, Dan Allah.'' ");
INSERT INTO hauulb_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesu ya amsa masa, “ Ka fada da bakin ka. Amma ina gaya maka, daga yanzu zaka ga Dan mutun na zaune a hannun dama na iko, ya na zuwa akan gizagizai na sama.” ");
INSERT INTO hauulb_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Sai babban firist din ya yayyaga rigarsa, yana cewa, “Yayi sabo! don me ku ke neman wata shaida kuma? Duba, yanzu kun ji sabon. ");
INSERT INTO hauulb_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Menene tunaninku?” Suka amsa sukace, “Ya cancanci mutuwa.” ");
INSERT INTO hauulb_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Sai suka tofa masa yawu a fuska, suka kuma yi masa duka, suka kuma mammare shi da tafin hannuwansu, ");
INSERT INTO hauulb_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","sukace, ''Ka yi mana anabci, kai Almasihu. Wanene wanda ya dokeka. ");
INSERT INTO hauulb_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","To Bitrus kuwa na zaune a farfajiyar, sai wata yarinya baiwa ta zo wurinsa tana cewa, “Kaima kana tare da Yesu na Galili.” ");
INSERT INTO hauulb_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Amma ya yi musun haka a gaban su duka, yace, “Ban ma san abinda kike magana akai ba.” ");
INSERT INTO hauulb_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Da ya fita zuwa bakin kofa, nan ma wata yarinyar baiwa ta gan shi tace wa wadanda suke wurin, “Wannan mutumin ma yana tare da Yesu Banazare.” ");
INSERT INTO hauulb_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Sai yayi musun haka kuma, har da rantsuwa, yace, “Ban san mutumin nan ba.” ");
INSERT INTO hauulb_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Bayan dan lokaci kadan wadanda suke a tsaye suka zo wurin Bitrus suka ce masa, “Hakika kai daya daga cikin su ne, gama harshen ka ya tonaka.” ");
INSERT INTO hauulb_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Sai ya fara rantsuwa irin ta la'ana, yana cewa, ''Ban san wannan mutumin ba,” nan da nan zakara yayi cara. ");
INSERT INTO hauulb_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Bitrus ya tuna da maganar da Yesu ya fada, “Kafin carar zakara zaka yi musun sani na sau uku.” Sai ya fita waje yayi kuka mai zafi.'' ");
INSERT INTO hauulb_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Da gari ya waye, duk manyan firistoci da dattawan jama'a suka shirya yadda zasu kulla makirci domin su kashe shi. ");
INSERT INTO hauulb_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Suka daure shi, suka mika shi ga gwamna Bilatus. ");
INSERT INTO hauulb_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Sa'adda Yahuza, wanda ya bashe shi, ya ga an zartarwa Yesu hukuncin kisa, ya nemi tuba ya kuma mayar da azurfar talatin ga manyan firistocin da dattawan, ");
INSERT INTO hauulb_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","yace, “Na yi zunubi ta wurin cin amanar mara laifi.” Amma sukace, “Ina ruwan mu? Ka ji da shi da kanka?” ");
INSERT INTO hauulb_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Sai ya jefar da kwandalolin azurfar a kasa cikin haikalin ya kuma bar su, ya tafi ya rataye kansa. ");
INSERT INTO hauulb_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Sai babban firist ya dauki kwandalolin azurfar ya ce, “Ba daidai bane bisa ga shari'a musa wannan cikin ma'aji, saboda kudin jini ne.” ");
INSERT INTO hauulb_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Sai suka tattauna al'amarin a tsakanin su, kudin kuma suka sayi filin maginin tukwane domin makabatar baki. ");
INSERT INTO hauulb_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Dalilin wannan ne ake kiran wurin, “Filin jini” har yau. ");
INSERT INTO hauulb_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Sai abin da aka fada ta bakin annabi Irmiya ya cika, cewa, “Suka dauki tsabar azurfa talatin na farashin da mutanen Isra'ila suka sa a kansa, ");
INSERT INTO hauulb_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","suka bayar domin sayen filin mai tukwane, kamar yadda Ubangiji ya umarce ni.” ");
INSERT INTO hauulb_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Sai Yesu ya tsaya a gaban gwamna, gwamna ya kuma tambaye shi, “Kai sarkin Yahudawa ne?” Yesu ya amsa, “Haka ka fada.” ");
INSERT INTO hauulb_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Amma da manyan firistocin da dattawan suka zarge shi, bai ce komai ba. ");
INSERT INTO hauulb_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Sai Bilatus yace masa, “Baka ji dukan zarge-zargen da ake yi maka ba?” ");
INSERT INTO hauulb_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Amma bai ce masa ko kalma guda ba, sai gwamna yayi matukar mamaki. ");
INSERT INTO hauulb_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","To lokacin bikin idi, al'adar gwamna ne ya saki mutum guda wanda jama'a suka zaba. ");
INSERT INTO hauulb_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","A wannan lokacin suna da wani sanannen dan kurkuku mai suna Barabbas. ");
INSERT INTO hauulb_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","To da suka tattaru, sai Bilatus yace masu, “Wa kuke so a sakar maku? Barabbas, ko Yesu wanda ake kira Almasihu?” ");
INSERT INTO hauulb_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Saboda ya san sun kawo shi ne domin kishi. ");
INSERT INTO hauulb_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Da yake zaune a kujerar shari'a, matarsa ta aika masa cewa, “Ka fita sha'anin mutumin nan marar laifi. Saboda na sha wahala sosai a yau cikin mafarki saboda shi.” ");
INSERT INTO hauulb_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","A lokacin nan manyan firistoci da dattawa suka rinjayi ra'ayin jama'a suce a sakar masu da Barabbas, a kashe Yesu. ");
INSERT INTO hauulb_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Sai gwamna ya tambayesu, “Wa kuke so a sakar maku?” Sukace, “Barabbas.” ");
INSERT INTO hauulb_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Bilatus yace masu, “Me zan yi da Yesu wanda ake kira Almasihu?” Sai duka suka amsa, “A gicciye shi.” ");
INSERT INTO hauulb_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Sai yace, “Don me, wane laifi ya aikata?” Amma suka amsa da babbar murya, “A gicciye shi” ");
INSERT INTO hauulb_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Amma da Bilatus ya ga ba zai iya komai ba don hargitsi zai iya barkewa, ya dauki ruwa ya wanke hannuwansa a gaban jama'a, yace, “Ba ni da laifi ga jinin mutumin nan marar laifi. Ku yi abin da kuka ga dama.” ");
INSERT INTO hauulb_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Duka mutanen sukace, “Bari jininsa ya kasance a kan mu da 'ya'yan mu.” ");
INSERT INTO hauulb_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Sai ya sakar masu da Barabbas amma yayi wa Yesu bulala ya mika shi garesu domin su gicciye shi. ");
INSERT INTO hauulb_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Sai sojojin gwamna suka dauki Yesu zuwa farfajiya suka kuma tara dukan rundunar sojoji. ");
INSERT INTO hauulb_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Suka yi masa tumbur sa'annan suka sa masa jar alkyabba. ");
INSERT INTO hauulb_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Sai suka yi masa rawanin kaya suka sa a kansa, suka kuma bashi sanda a hannunsa na dama. Suka rusuna a gabansa suna masa ba'a, suna cewa, “Ranka ya dade, Sarkin Yahudawa!” ");
INSERT INTO hauulb_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Suka kuma tofa masa yawu, suka kwace sandar suka buga masa a ka. ");
INSERT INTO hauulb_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Bayan sun gama masa ba'a, suka cire masa alkyabbar suka sa masa kayansa, suka jagorance shi zuwa wurin da za a gicciye shi. ");
INSERT INTO hauulb_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Da suka fito waje, sai suka iske wani Bakurame mai suna Saminu, wanda suka tilasta ya tafi tare dasu domin ya dauki gicciyen. ");
INSERT INTO hauulb_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Suka iso wani wuri da ake kira Golgotta, wanda ke nufin,”Wurin kwalluwa.” ");
INSERT INTO hauulb_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Suka bashi ruwan inabi da aka gauraya da wani abu mai daci. Amma da ya 'dan-'dana shi sai ya ki sha. ");
INSERT INTO hauulb_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Bayan da suka gicciye shi, suka kada kuri'a a kan rigarsa. ");
INSERT INTO hauulb_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Suka kuma zauna suna kallonsa. ");
INSERT INTO hauulb_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","A sama da kansa suka sa abinda ake tuhumarsa da ita a rubuce, “Wannan shine sarkin Yahudawa.” ");
INSERT INTO hauulb_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","An gicciye shi da 'yanfashi guda biyu, daya ta damansa dayan kuma ta hagunsa. ");
INSERT INTO hauulb_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Wadanda suke wucewa suna zaginsa, suna girgiza kai, ");
INSERT INTO hauulb_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","suna kuma cewa, “Kai da kace zaka rushe haikali ka kuma gina shi a kwana uku, ka ceci kanka mana! In dai kai Dan Allah ne, ka sauko daga gicciyen!” ");
INSERT INTO hauulb_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ta haka ma manyan firistocin suka rika yi masa ba'a, tare da marubuta da shugabannin, suna cewa, ");
INSERT INTO hauulb_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Ya ceci wasu amma ya kasa ceton kansa. Shi ne sarkin Isra'ila. Ya sauko mana daga kan gicciyen, sai mu ba da gaskiya gareshi. ");
INSERT INTO hauulb_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Tun da ya yarda da Allah. Bari Allahn ya cece shi mana, saboda yace, “Ni dan Allah ne.” ");
INSERT INTO hauulb_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Hakan nan ma 'yanfashin guda biyu da aka gicciye su tare suka zage shi. ");
INSERT INTO hauulb_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","To tun da tsakar rana sai duhu ya rufe kasar gaba daya har karfe uku na yamma. ");
INSERT INTO hauulb_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Wajen karfe uku, Yesu ya tada murya mai karfi yace, “Eli, Eli lama sabaktani?” wanda ke nufin, “Allahna, Allahna, don me ka yashe ni?” ");
INSERT INTO hauulb_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Da wadanda suke tsaye kusa suka ji haka, sai sukace, “Yana kiran Iliya.” ");
INSERT INTO hauulb_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Nan take wani ya ruga da gudu ya dauki soso ya tsoma cikin ruwan inabi mai tsami ya soka kan sandar kara ya mika masa ya sha. ");
INSERT INTO hauulb_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Sai sauran sukace, “Rabu da shi mu gani ko Iliya zai zo ya cece shi.” ");
INSERT INTO hauulb_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Sai Yesu ya ta da murya mai karfi yayi kuka sai ya saki ruhunsa. ");
INSERT INTO hauulb_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Sai labullen haikali ya yage gida biyu daga sama zuwa kasa. Kasa kuma ta girgiza, duwatsu suka farfashe. ");
INSERT INTO hauulb_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Kaburbura suka bude, tsarkaka kuwa wadanda suke barci da yawa suka tashi. ");
INSERT INTO hauulb_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Suka fito daga kaburbura bayan tashinsa, suka shiga birni mai tsarki suka bayyana ga mutane da yawa. ");
INSERT INTO hauulb_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Da hafsan sojan da wadanda suke kallon Yesu suka ga girgizar kasar da abinda ya faru, suka ji tsoro kwarai sukace, “Hakika wannan Dan Allah ne” ");
INSERT INTO hauulb_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Mata dayawa da suka bi Yesu daga Galili domin su lura da shi suka tsaya suna kallo daga nesa. ");
INSERT INTO hauulb_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","A cikin su akwai Maryamu Magadaliya, Maryamu uwar Yesu da Yusufu, da uwar 'ya'yan Zabadi. ");
INSERT INTO hauulb_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Da yamma sai wani attajiri mutumin Armatiya ya zo, mai suna Yusufu wanda shi ma almajirin Yesu ne. ");
INSERT INTO hauulb_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ya je wurin Bilatus ya roka a bashi jikin Yesu. Sai Bilatus ya umarta a bashi. ");
INSERT INTO hauulb_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yusufu ya dauki jikin, ya rufe shi da likafani mai tsabta, ");
INSERT INTO hauulb_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","sai ya sa shi a cikin sabon kabarinsa da ya sassaka cikin dutse. Sai ya mirgina babban dutse a bakin kofar kabarin ya tafi. ");
INSERT INTO hauulb_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maryamu Magadaliya da dayan Maryamun suna nan zaune akasin kabarin. ");
INSERT INTO hauulb_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Washegari, wato bayan ranar Shiri, Sai manyan firistoci da Farisawa suka taru tare da Bilatus. ");
INSERT INTO hauulb_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Sukace, “Mai gida, mun tuna lokacin da mayaudarin nan yake da rai, yace, “Bayan kwana uku zan tashi.” ");
INSERT INTO hauulb_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Saboda haka, ka bada umarni a tsare kabarin na kwana uku. In ba haka ba almajiransa zasu zo su sace shi, kuma su ce wa mutane, “Ya tashi daga mattatu.” Kuma yaudarar karshe zata fi ta farko muni.” ");
INSERT INTO hauulb_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Bilatus yace masu, “Ku dauki masu tsaro. Kuyi tsaro iyakar karfin ku.” ");
INSERT INTO hauulb_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Sai suka tafi suka tsare kabarin, suka hatimce dutsen, suka sa masu tsaro. ");
INSERT INTO hauulb_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Da daddare ranar Asabaci, rana ta fari ga mako ta fara gabatowa, Maryamu Magadaliya da daya Maryamun suka zo don su ziyarci kabarin. ");
INSERT INTO hauulb_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Sai aka yi girgizar kasa mai karfi, saboda mala'ikan Ubangiji ya sauko daga sama ya kuma murgine dutsen ya zauna a kai. ");
INSERT INTO hauulb_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Kamanninsa kamar walkiya, tufafinsa kuma fari fat kamar suno. ");
INSERT INTO hauulb_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Masu tsaron suka razana don tsoro suka zama kamar matattun mutane. ");
INSERT INTO hauulb_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Mala'ikan ya yi wa matan magana cewa, “Kada ku ji tsoro, nasan kuna neman Yesu wanda aka gicciye. ");
INSERT INTO hauulb_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Baya nan, amma ya tashi kamar yadda ya fada. Ku zo ku ga wurin da aka kwantar da shi. ");
INSERT INTO hauulb_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ku hanzarta ku gaya wa almajiransa, 'Ya tashi daga matattu. Duba, ya tafi Galili, can zaku same shi.' Gashi ni kuwa na fada maku.” ");
INSERT INTO hauulb_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Matan suka yi hanzari suka bar kabarin da tsoro da murna, suka ruga domin su sanar wa almajiransa. ");
INSERT INTO hauulb_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Sai ga Yesu ya tare su, yace masu, “A gaishe ku.” Sai matan suka kama kafar sa, suka kuma yi masa sujada. ");
INSERT INTO hauulb_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Sai Yesu yace masu, “Kada ku ji tsoro. Ku je ku fada wa 'yan'uwana su je Galili. Can zasu ganni.” ");
INSERT INTO hauulb_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Sa'adda matan suke tafiya, sai wadansu masu tsaro suka shiga gari suka fada wa Shugabanin Firistoci dukan abin da ya faru. ");
INSERT INTO hauulb_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Firistocin suka hadu da dattawa suka tattauna al'amarin, sai suka bada kudi masu yawa ga sojojin ");
INSERT INTO hauulb_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Sukace masu, “Ku gaya wa sauran cewa, “Almajiran Yesu sun zo da daddare sun sace gangar jikinsa lokacin da muke barci.” ");
INSERT INTO hauulb_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Idan wannan rahoto ya isa wurin gwamna, za mu lallashe shi mu ja hankalinsa mu raba ku da damuwa.” ");
INSERT INTO hauulb_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Sai sojojin suka karbi kudin suka yi abinda aka umarcesu. Wannan rahoto ya bazu a tsakanin Yahudawa, ya ci gaba har zuwa yau. ");
INSERT INTO hauulb_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Amma almajiran sha daya suka tafi Galili, kan dutsen da Yesu ya umarcesu. ");
INSERT INTO hauulb_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Da suka gan shi, suka yi masa sujada, amma wadansu suka yi shakka. ");
INSERT INTO hauulb_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesu ya zo wurin su ya yi masu magana, yace, “Dukan iko dake sama da kasa an ba ni. ");
INSERT INTO hauulb_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Sai kuje ku almajirantar da dukan al'ummai. Kuna yi masu baftisma cikin sunan Uba da na Da da na Ruhu Mai Tsarki. ");
INSERT INTO hauulb_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ku koya masu su kiyaye dukan abin da na umarce ku. Duba, ni kuma kullum ina tare da ku har karshen zamani.” ");
INSERT INTO hauulb_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Wannan itace farkon bisharar Yesu Almasihu, Dan Allah. ");
INSERT INTO hauulb_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","kamar yadda aka rubuta cikin littafin annabi Ishaya. Duba, ina aika manzona, a gabanka, wanda zai shirya maka hanya. ");
INSERT INTO hauulb_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Akwai murya mai kira a jeji, tana cewa ka shirya hanyar Ubangiji. ka daidaita ta. ");
INSERT INTO hauulb_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Yahaya ya zo, yana baptisma acikin jeji yana wa'azin tuba, domin gafarar zunubai. ");
INSERT INTO hauulb_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Dukan kasar Yahudiya da mutanen Urshalima suka zo wurin sa, a ka kuma yi masu baptisma a kogin urdun. suna furta zunubansu. ");
INSERT INTO hauulb_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yahaya yana saye da tufa ta gashin rakumi, yana kuma da damara ta fata a kugunsa, abincinsa fara ce da zuma. ");
INSERT INTO hauulb_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Yana wa'azi, ya ce “akwai mai zuwa a bayana wanda ya ke da iko fiye da ni. wanda ko maballin takalminsa ban isa in kwance ba. ");
INSERT INTO hauulb_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ni ina yi maku baptisma da ruwa, amma mai zuwa a bayana zai yi maku baptisma da Ruhu Mai Tsarki''. ");
INSERT INTO hauulb_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Sai ya kasance a kwanakin nan Yesu ya zo daga Nazarat ta Galili, sai Yahaya ya yi masa baptisma a kogin urdun. ");
INSERT INTO hauulb_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Sa'adda Yesu ya fito daga ruwan, sai sama ta bude, sai Ruhu ya sauko a bisansa da kamanin kurciya. ");
INSERT INTO hauulb_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Sai wata murya ta zo daga sama, tana cewa, “Kai kaunataccen Dana ne. zuciyata ta na murna da kai kwarai''. ");
INSERT INTO hauulb_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Sai Ruhu ya iza shi zuwa jeji. ");
INSERT INTO hauulb_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Yana a jeji kwana arba'in, Shaidan yana jarabtar sa. Yana cikin jeji da dabobi, sai malaiku su ka yi masa hidima. ");
INSERT INTO hauulb_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Bayan da aka kama Yahaya, Yesu ya shiga kasar Galili yana wa'azin bisharar Allah. ");
INSERT INTO hauulb_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Yana cewa, “Lokaci ya yi, gama mulkin Allah ya kusato. Ku tuba ku bada gaskiya ga bishara”. ");
INSERT INTO hauulb_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Sa'adda ya ke wucewa a gefen takun Galili, sai ya ga Saminu da Andarawus, dan'uwansa suna jefa taru a teku, domin su masunta ne. ");
INSERT INTO hauulb_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesu ya ce masu ku zo, ku biyo ni, ni kuwa sai in maisheku masuntan mutane”. ");
INSERT INTO hauulb_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Nan da nan suka bar tarun su, suka bi shi. ");
INSERT INTO hauulb_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Sa'adda Yesu ya yi tafiya kadan, sai ya ga Yakubu dan Zabadi da Yahaya dan'uwansa; suna gyaran tarunsu a jirgin ruwa. ");
INSERT INTO hauulb_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Sai ya kira su, su kuwa suka bar mahaifinsu Zabadi a jirgin ruwan da ma'aikatansu, sai su ka bi shi. ");
INSERT INTO hauulb_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Da su ka shigo cikin kafanahum, a ranar asabar, Yesu ya shiga majami'a ya koya masu. ");
INSERT INTO hauulb_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Su ka yi mamakin koyarwarsa, domin ya na koya masu da iko ba kamar marubuta ba. ");
INSERT INTO hauulb_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","A nan cikin majami'a akwai wani mutum mai kazamin ruhu, sai ya yi ihu da karfi. ");
INSERT INTO hauulb_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Yana cewa Ina ruwan mu da kai, Yesu Banazarat? Ka zo ne domin ka halakar da mu? Na san wanene kai. Kai ne Mai Tsarki na Allah”. ");
INSERT INTO hauulb_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Sai Yesu ya tsauta wa kazamin ruhun ya ce, “Ka yi shiru ka fita daga cikinsa”. ");
INSERT INTO hauulb_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Bayan da kazamin ruhun ya buga shi kasa, sai kazamin ruhun ya yi ihu sa'annan ya fita daga jikinsa. ");
INSERT INTO hauulb_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Sai dukan mutanen su ka yi mamaki kwarai, suna tambayar junansu menene wannan? wace sabuwar koyarwa ce da iko haka? har yana umartar kazaman ruhohi suna kuwa yi masa biyayya!” ");
INSERT INTO hauulb_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Nan da nan labarinsa ya bazu ko'ina a dukkan kewayen kasar Galili. ");
INSERT INTO hauulb_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Bayan da suka bar majami'a, sai su ka shiga gidan Saminu da Andarawus, suna kuma tare da Yakubu da Yahaya. ");
INSERT INTO hauulb_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Surikar Saminu tana kwance ba lafiya tana fama da zazzabi. Sai suka gaya wa Yesu game da ita. ");
INSERT INTO hauulb_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Sai ya zo, ya kama hannunta, ya daga ta, sai zazzabin ya sake ta, ta fara yi masu hidima. ");
INSERT INTO hauulb_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Da yamman nan, bayan da rana ta fadi, sai su ka kawo masa dukan marasa lafiya da masu fama da aljanu. ");
INSERT INTO hauulb_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Dukan mutanen garin su ka taru a bakin kofa. ");
INSERT INTO hauulb_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","ya warkar da masu ciwo da yawa da masu chututtuka iri-iri, ya kuma fitar da bakaken aljanu, amma bai yarda aljanun su yi magana ba domin sun san shi. ");
INSERT INTO hauulb_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ya tashi da sassafe, tun da sauran dare, ya tafi wurin da ba kowa, a can ya yi add'ua. ");
INSERT INTO hauulb_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Saminu da wandanda suke tare da shi suka neme shi. ");
INSERT INTO hauulb_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Suka sa me shi, sai su ka ce masa, “kowa yana nemanka”. ");
INSERT INTO hauulb_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ya ce, bari mu tafi wani wuri, zuwa wadansu garuruwan da ke kewaye, Saboda in yi wa'azi a can kuma. Wannan shi yasa na zo nan''. ");
INSERT INTO hauulb_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ya tafi dukan kasar Galili, yana wa'azi a majimi'un su yana kuma fitar da aljanu. ");
INSERT INTO hauulb_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Wani kuturu ya zo wurinsa. Yana rokonsa, ya durkusa. Ya ce masa, “in ka yarda kana iya warkar da ni. ");
INSERT INTO hauulb_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Sai ya yi juyayi, Yesu ya mi ka hannun sa ya ta ba shi ya na ce masa “Na yarda. Ka sarkaka”. ");
INSERT INTO hauulb_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Nan da nan kuturtar ta barshi, ya kuma sa mu tsarkakewa. ");
INSERT INTO hauulb_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Yesu ya yi masa gargadi sosai, ya salame shi. ");
INSERT INTO hauulb_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Ya ce masa “ka tabbata fa kada ka gayawa kowa, amma ka tafi ka nuna kanka ga firist, sai ka je ka yi hadaya domin tsarkakewa kamar yadda Musa ya umurta, domin shaida. ");
INSERT INTO hauulb_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Amma da ya fita sai ya fara gaya wa kowa, ya baza maganar a ko'ina, har Yesu bai iya tafiya a sake a garin ba. Ya tafi ya tsaya a wuraren da ba kowa, mutane kuwa su ka zo wurinsa daga ko'ina. ");
INSERT INTO hauulb_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Da ya dawo Kafarnahum bayan yan kwanaki kadan, aka ji cewa yana gida. ");
INSERT INTO hauulb_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Da yawa suka taru a can, ba wuri har kofa, sai Yesu ya yi masu magana. ");
INSERT INTO hauulb_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Sai wadansu mutane su ka zo wurinsa dauke da wuni mutum shanyayye, mutane hudu na dauke da shi. ");
INSERT INTO hauulb_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Lokacin da ba su iya zuwa kusa da shi ba domin yawan jama'a, sai su ka daye jinkar dakin daidai da inda ya ke. Bayan da suka huda ramin suka saukar da gado wanda shanyayyen ke kwance a kai. ");
INSERT INTO hauulb_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Da ganin bangaskiyarsu, Yesu ya ce wa shanyayyen mutumin, “Da, an gafarta maka zunuban ka”. ");
INSERT INTO hauulb_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Amma wadansu marubuta da ke zaune a nan, suka yi tunani aransu. ");
INSERT INTO hauulb_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Yaya wannan mutum zai yi magana haka? Ya yi sabo! wa ke iya gafarta zunubi “sai Allah kadai?” ");
INSERT INTO hauulb_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Nan da nan Yesu ya sani a ruhunsa, abinda suke tunani a tsakaninsu. Ya ce masu, “Me ya sa kuke tunanin wannan a zuciyarku? ");
INSERT INTO hauulb_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Me yafi sauki a cewa shanyayyen mutumin, 'An gafarta maka zunuban ka' ko kwa a ce masa, 'tashi, ka dauki shinfidarka, ka yi tafiyarka'? ");
INSERT INTO hauulb_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Amma domin ku san cewa Dan mutum na da ikon gafarta zunubi a duniya, ya ce wa shanyayyen, ");
INSERT INTO hauulb_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","''Na ce maka, tashi, dauki tabarmanka, ka tafi gidan ka.” ");
INSERT INTO hauulb_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Sai nan da nan ya tashi ya dauki tabarmarsa, ya fita gidan a gabansu, dukansu su ka yi mamaki, su ka girmama Allah, ''suka ce ba mu taba ganin abu irin wannan ba.” ");
INSERT INTO hauulb_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ya sake fita gefen tafki, dukan taron jama'a suka zo wurinsa, sai ya koya masu. ");
INSERT INTO hauulb_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Sa'adda ya na wucewa, ya ga Levi dan Halfa yana zaune a wurin karbar haraji, sai ya ce masa, “Ka biyo ni.” Ya tashi, ya bi shi. ");
INSERT INTO hauulb_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Sa'adda Yesu ya shiga gidan Levi yana cin abinci, masu karbar haraji da masu zunubi da yawa su ka zo wurinsa da almajiransa, jama'a masu yawan gaske suka ka bi shi. ");
INSERT INTO hauulb_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Da Marubuta wadanda su ke Farisawa, sun ga cewa Yesu na cin abinci da masu zunubi da masu karbar haraji, sai su ka ce wa almajiransa, “Me ya sa ya ke ci da masu karbar haraji da mutane masu zunubi?” ");
INSERT INTO hauulb_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Da Yesu ya ji wannan ya ce masu, “Mutane wadanda ke da lafiya a jiki ba su bukatar likita; sai dai ko marasa lafiya ke bukatarsa. Ban zo domin in kira mutane masu a dalci ba, amma mutane masu zunubi.” ");
INSERT INTO hauulb_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Almajiran Yahaya da Farisawa suna azumi, sai wadansu mutane suka zo suka ce, “Don me almajiran Yahaya da almajiran Farisawa na azumi amma na ka almajiran ba su yi?” ");
INSERT INTO hauulb_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Sai Yesu yace masu, “Abokan ango, za su yi azumi sa'adda ango yake tare da su? muddin suna tare da ango ba za su yi azumi ba. ");
INSERT INTO hauulb_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Amma kwanaki za su zo da za a dauki angon daga gare su, a wadancan kwanakin ne, za su yi azumi. ");
INSERT INTO hauulb_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Babu wanda zai dinka sabuwar riga ya hada ta da tsohuwar riga, sai rigar ta yage, kuma ta yi mummunar yagewa. ");
INSERT INTO hauulb_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Babu wanda zai sa sabon ruwan inabi a cikin tsohuwar salka, ai sai salkar ta fashe kuma ruwan inabin ya zube. duka biyu ruwan inabin da salkar arasa su. A maimakon haka, sai ka sanya sabon ruwan inabi cikin sabuwar salka.” ");
INSERT INTO hauulb_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","A ranar asabar Yesu ya tafi cikin gonakin hatsi, sai almajiransa su ka fara zagar hatsi, ");
INSERT INTO hauulb_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Sai Farisawa su ka ce masa, “Duba, don me suke yin abin da bai dace a yi ranar Asabar ba?” ");
INSERT INTO hauulb_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yace masu, Ba ku karanta ba abinda Dauda ya yi sa'adda yake jin yunwa, shi da mutanen da ke tare da shi? ");
INSERT INTO hauulb_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Yadda ya shiga gidan Ubangiji, sa'adda Abiyata ya ke babban firist, ya ci gurasa da ke ta firist wadda bai dace wani ya ci ba sai Firistoci. Har kuma ya ba wadanda ke tare da shi.” ");
INSERT INTO hauulb_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yesu yace, “Asabar an yi ta don mutum ne, ba a yi mutum don Asabar ba. ");
INSERT INTO hauulb_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Saboda haka, Dan Mutum Ubangiji ne, har da na Asabar.” ");
INSERT INTO hauulb_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Sai kuma ya sake tafiya cikin Majami'a sai ga wani Mutum mai shanyayyen hannu. ");
INSERT INTO hauulb_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Wadansu mutane suna kallonsa sosai, su gani ko zai warkar da shi a ranar Asabar. don su zarge shi. ");
INSERT INTO hauulb_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesu ya ce wa mai shanyayyen hanun “ Ka tashi ka tsaya a tsakiyar kowa.” ");
INSERT INTO hauulb_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Sai ya ce wa mutane, “Ya dace a yi abu mai kyau aranar Asabar ko a yi mugunta; a ceci rai, ko a yi kisa? “Amma suka yi shiru. ");
INSERT INTO hauulb_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Sai ya dube su cikin fushi, yana bakin ciki da taurin zuciyar su, ya ce wa mutumin ka mikar da hanunka, sai ya mikar da hanunsa Yesu kuwa ya warkar da shi. ");
INSERT INTO hauulb_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Sai Farisiyawa suka fita da sauri zuwa wurin mutanen Hirudus suka shirya yadda za su kashe shi. ");
INSERT INTO hauulb_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Sai Yesu da almajiransa, suka tafi bakin teku. sai mutane dayawa suka bi shi, daga Galili da Yahudiya ");
INSERT INTO hauulb_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Daga Urushalima da Edom gaba da Urdun da kewayan Taya da Sidon, da baban taro, ya ji abinda yake yi. suka zo wurinsa. ");
INSERT INTO hauulb_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ya tambayi almajiransa su shirya masa karamin jirgin ruwa domin yawan mutane, domin kada su murkushe shi. ");
INSERT INTO hauulb_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ya warkar da mutane da yawa, yadda duk wadanda suke da cuttutuka suna kokari su taba shi. ");
INSERT INTO hauulb_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Duk sa'adda kazaman ruhohin suka ganshi, sai su durkusa a gabansa su yi ihu da karfi su ce, kai Dan Allah ne.” ");
INSERT INTO hauulb_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ya umarce su da karfi kada su sa a san shi. ");
INSERT INTO hauulb_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ya hau saman dutsen, ya kira wadanda yake bukar su, su zo wurinsa. ");
INSERT INTO hauulb_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ya zabi guda goma sha biyu (ya kira su manzanni). Wadanda zasu kasance tare da shi, ya kuma aike su, su yi wa, azi, ");
INSERT INTO hauulb_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ya kuma basu Ikon fitar da aljanu. ");
INSERT INTO hauulb_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ya zabi guda goma sha biyu wato Saminu kuma yaba shi suna Bitrus. ");
INSERT INTO hauulb_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yakubu dan Zabadi da Yahaya dan-uwan Yakubu wanda ya basu sunan Buwanarjis watau 'ya'yan tsawa, ");
INSERT INTO hauulb_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","da Andarawus da Filibus da Bartalamawus da Matta da Toma da Yakubu dan Halfa, da Taddawus da Saminu Ba-kananiye, ");
INSERT INTO hauulb_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","da Yahuza Iskariyoti wanda zai bashe shi. ");
INSERT INTO hauulb_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Sa'adda ya shiga gida, Taron kuwa ya sake haduwa, har ya hana su cin abinci, ");
INSERT INTO hauulb_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Da iyalansa suka ji haka, sai suka fito sun kamo shi, saboda sun ce, “Ai, baya cikin hankalinsa “ ");
INSERT INTO hauulb_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Marubutan da suka zo daga Urushalima suka ce “Ai Ba'alzabuba ne ya hau shi, da ikon sarkin aljannu kuma yake fitar da aljannu.” ");
INSERT INTO hauulb_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yesu ya kirawo su wurinsa ya ce da su cikin misalai, “Yaya shaidan zai iya fitar da shaidan? ");
INSERT INTO hauulb_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","idan mulki ya rabu gida biyu ba zai tsayawa ba. ");
INSERT INTO hauulb_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Haka in gida ya rabu kashi biyu, gaba da kansa bai zai tsaya ba. ");
INSERT INTO hauulb_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Shaidan kuma in ya tayar wa kansa ya rabu, ba zai iya tsayawa ba, gama karshen sa ya zo kenan. ");
INSERT INTO hauulb_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Amma ba mai iya shiga gidan kakkarfan mutum ya kwace kayansa, ba tare da ya fara daure kakkarfan mutumin ba, sa'an nan kuma ya kwashe kayan gidansa. ");
INSERT INTO hauulb_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Hakika, ina gaya maku, dukan zunuban da mutane suka yi za a gafarta masu, da kowane irin sabon da suka furta, ");
INSERT INTO hauulb_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","amma fa duk wanda yayi sabon Ruhun Mai Tsarki baza a gafarta masa ba ko kadan, ya zama mai zunubi har abada.” ");
INSERT INTO hauulb_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","“Yesu ya fadi wadannan abubuwa domin suna cewa yana da ba kazamin ruhu,” ");
INSERT INTO hauulb_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Sa'an nan uwatasa, da “Yan'uwansa suka zo suna tsaye a waje. sai suka aika masa, suna kuma umurtar sa ya zo. ");
INSERT INTO hauulb_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Taro kuwa na zaune kewaye da shi, sai suka yi magana da shi da cewa, ga uwarka da yan-uwanka suna nan a waje, suna nemanka.” ");
INSERT INTO hauulb_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ya amsa masu, “Dacewa su wanene uwa-ta da “yan'uwa na? “ ");
INSERT INTO hauulb_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Sai ya waiwayi wadanda suke zaune kewaye da shi, yace, “Ga uwa-ta da yan-uwana anan! ");
INSERT INTO hauulb_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Gama duk wanda ke yin abin da Allah yake so, shine dan'uwana da yar, uwata, da kuma uwa-ta.” ");
INSERT INTO hauulb_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ya kuma fara koyarwa a bakin teku. Akwai babban taro kewaye da shi, sai ya shiga cikin jirgin ruwa a cikin tekun, ya kuwa zauna. Duk taron kuwa na kan tudu a bakin tekun. ");
INSERT INTO hauulb_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ya koya masu abubuwa da yawa da misalai, a cikin koyawarsa ya ce masu, ");
INSERT INTO hauulb_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“ku saurara! wani mai shuka ya tafi shuka. ");
INSERT INTO hauulb_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Yana cikin yafa iri, sai wadansu iri suka fadi a kan hanya, tsuntsaye kuma suka zo suka tsince su. ");
INSERT INTO hauulb_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Wadansu kuma suka fadi a kan dutse inda ba kasa dayawa. Nan da nan kuwa suka tsiro saboda rashin zurfin kasa. ");
INSERT INTO hauulb_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Da rana fa ta daga, sai suka yankwane da yake ba su da saiwa sosai, sai suka bushe. ");
INSERT INTO hauulb_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Wadansu kuma suka fadi cikin kayayuwa su ka yi girma sai kayayuwan suka shake su, ba su yi tsaba ba. ");
INSERT INTO hauulb_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Wadansu kuma suka fadi a kasa mai kyau, suka yi yabanya, suka yi tsaba, suka yi girma, wadansu ribi talattin wadansu sittin, wadansu kuma dari”. ");
INSERT INTO hauulb_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Sai ya ce, Duk mai kunnen ji, ya ji,” ");
INSERT INTO hauulb_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Sa'adda Yesu yake shi kadai, wadanda suke kusa dashi tare da sha biyun suka tambaye shi ma'anar misalan. ");
INSERT INTO hauulb_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Sai ya ce masu, “ku an yardar maku, ku san asirin mulkin Allah, amma ga wadanda ba su cikinku, komai sai a cikin Misalai, ");
INSERT INTO hauulb_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","don gani da ido sun gani, amma ba su gane ba. ji kuma, sun ji, amma ba su fahimta ba, don kada su juyo a gafarta masu,” ");
INSERT INTO hauulb_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ya ce masu, “Ashe, ba ku fahimci wannan misalin ba? yaushe za ku fahimci sauran? ");
INSERT INTO hauulb_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Mai shukan nan fa maganar Allah yake shukawa. ");
INSERT INTO hauulb_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Wadanda suka fadi a hanyar kuwa, su ne kwatancin wadanda. a aka shuka mganar a zuciyarsu, Da suka ji, nan da nan sai shaidan ya zo ya dauke Maganar da aka shuka a zuciyarsu. ");
INSERT INTO hauulb_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Haka kuma wadanda aka shuka a wuri mai duwatsu, sune wadanda da zarar sun ji Maganar sai su karba da farin ciki. ");
INSERT INTO hauulb_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Su kuwa basu da tushe, ba su da karfi, idan kunci ko tsanani ya zo saboda kalmar, nan da nan sai su yi tuntube. ");
INSERT INTO hauulb_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Wadansu kuma su ne kwatacin wadanda suka fadi cikin kayayuwa, sune wadanda suka ji Maganar, ");
INSERT INTO hauulb_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","amma abubuwan duniya, da rudin dukiya da kuma kwadayin wadansu abubuwa, sukan shiga su shake Maganar, har ta zama marar amfani. ");
INSERT INTO hauulb_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Wadanda aka shuka a kasa mai kyau kuwa, sune kwatancin wadanda suke jin Maganar, su karba, su kuma yin amfani da ita wadansu ribi talatin, wadansu sittin, wadansu dari.” ");
INSERT INTO hauulb_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","ya ce masu, “Shin, ana kawo fitila a cikin gida don a rufe ta da kwando ko a ajiye ta a karkashin gado? ku kan kawo ta ne don ku dora ta a kan madorinta. ");
INSERT INTO hauulb_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ba abin da yake boye, da baza a sani ba ko kuma ba abinda ke asirce da bazaya bayyana a fili ba. ");
INSERT INTO hauulb_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Bari mai kunnen ji, ya ji!'' ");
INSERT INTO hauulb_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Sai ya ce masu, ku mai da hankali a kan abin da kuka ji, Mudun da ka auna, da shi za a auna maka, har ma a kara maka. ");
INSERT INTO hauulb_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Domin mai abu akan karawa, marar abu kuma za a karba daga wurinsa a kuma karawa mai shi.” ");
INSERT INTO hauulb_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Sai ya ce, “Mulkin Allah kamar mutum yake mai yafa iri a kasa. ");
INSERT INTO hauulb_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","A kwana a tashi har irin ya tsiro, ya girma bai kuwa san ta yaya aka yi ba. ");
INSERT INTO hauulb_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Kasa da kanta, takan ba da amfani, tsiro shine ne na farko, ");
INSERT INTO hauulb_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Sai kai, sa'anan sai kwaya mai kwari. Sa, adda amfani ya nuna, sai ya sa lauje ya yanke nan da nan, wato kaka ta yi kenan.” ");
INSERT INTO hauulb_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ya kuma ce, “Da me za mu kwatanta Mulki Allah? ko kuwa da wane misali za mu misalta shi? ");
INSERT INTO hauulb_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Kamar kwayar zarra yake wadda, in an shuka ta, ko da yake ita ce mafi kankanta cikin kwayoyi a duniya. ");
INSERT INTO hauulb_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Duk da haka in an shuka ta, sai ta yi girma fiye da duk sauran ita-tuwan da ke a jeji tayi manyan rassa, har tsuntsaye su iya yin sheka arassanta.” ");
INSERT INTO hauulb_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Da misalai da yawa, irin wadannan ya yi masu Magana, dadai gwargwadon ganewarsu, ");
INSERT INTO hauulb_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","ba ya fada masu kome sai da misali, amma a kebe, yakan bayyana wa almajiransa dukan abu. ");
INSERT INTO hauulb_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","A ranan nan da yama ta yi yace masu “Mu haye wancan ketaren.” ");
INSERT INTO hauulb_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Sai suka bar taron, suka tafi tare da shi acikin cikin jirgin. wadansu jirage kuma na tare da shi. ");
INSERT INTO hauulb_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Sai babban hadari da iska mai karfi ya taso, rakuman ruwa kuma na ta girgizawa cikin jirgin, har jirgin ya cika. ");
INSERT INTO hauulb_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yesu kuwa na daga karshen bayan jirgin a kan kujera, yana barci, sai suka tashe shi, suka ce masa “Malam za mu hallaka ba ka kula ba?” ");
INSERT INTO hauulb_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Sai ya farka, ya tsawata wa Iskar. Ya kuma ce wa ruwan tekun, “Ka natsu! ka yi shiru!” Sai Iskar ta kwanta, wurin duk ya yi shiru. ");
INSERT INTO hauulb_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ya ce masu, “Don me kuka firgita haka? Har yanzu baku da bangaskiya ne?” ");
INSERT INTO hauulb_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Sai suka tsorata kwarai suka ce wa juna, “wanene wannan kuma, wanda har Iska da teku ma suke yi masa biyayya?” ");
INSERT INTO hauulb_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Da su ka zo daya ketaren tekun, wanda ya ke cikin yankin Garasinawa. ");
INSERT INTO hauulb_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Sa'adda Yesu ya sauko daga cikin jirgin ruwan sai wani mutum mai aljanu ya fito daga cikin kaburbura ya tarbe shi. ");
INSERT INTO hauulb_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Mutumin yana zama a cikin kaburbura. An daure shi da sarkoki da mari ");
INSERT INTO hauulb_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","An daure shi da sarkoki da mari sau da yawa, amma ya tsuntsunke sarkoki da marin. har ma ba wanda zai iya daure shi kuma. ");
INSERT INTO hauulb_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Dare da rana a cikin kabarbarun da duwatsu mutumin ya na ihu ya na yaiyage jikinsa da duwatsu masu kaifi. ");
INSERT INTO hauulb_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Sa'adda ya hango Yesu daga nesa, sai ya tarbi Yesu ya durkusa a gabansa. ");
INSERT INTO hauulb_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ya tada muryarsa da karfi ya ce, ina ruwa na da kai? Yesu Dan Allah Madaukaki Ina rokon ka da sunan Allah kada ka bani wahala, ");
INSERT INTO hauulb_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Gama Yesu ya ce masa kai aljani ka fito daga cikinsa.” ");
INSERT INTO hauulb_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ya tambaye shi, “Yaya sunanka? Ya ce suna na tari gama muna da yawa. ");
INSERT INTO hauulb_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ya yi ta rokonsa kada ya raba su da wannan yankin kasar. ");
INSERT INTO hauulb_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Akwai babban garken aladu a wurin suna kiwo a gindin tsauni. ");
INSERT INTO hauulb_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Sai suka roke shi ya bar su su shiga cikin wadannan aladun. ");
INSERT INTO hauulb_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Shi kuma ya yardar masu. Aljanun suka fita suka shiga cikin aladun su kimanin dubu biyu. Aladun dubu biyu suka gangaro daga gindin tsaunin suka fada cikin ruwa. ");
INSERT INTO hauulb_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Mutanen da ke kiwon aladun su ka shiga cikin gari da kewaye suka bada labarin abin da ya faru. Mutane da yawa suka je su ga abin da ya faru ");
INSERT INTO hauulb_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Sai suka zo wurin Yesu suka ga mutumin mai aljanun a zaune, cikin hankalinsa, saye da tufafi, sai suka tsorata. ");
INSERT INTO hauulb_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Wadanda suka zo su ka ga abin da ya faru da mutumin mai aljanun, suka je suka fada wa mutane abin da suka gani game da aladun. ");
INSERT INTO hauulb_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Mutanen suka roke shi ya fita daga yankin kasarsu. ");
INSERT INTO hauulb_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Shi mutumin da aljanu ke iko da shi, sa'adda ya ga Yesu zai shiga cikin jirgin ruwa ya tafi, ya roki Yesu da ya bi shi. ");
INSERT INTO hauulb_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Amma Yesu bai yarda masa ba. Ya ce masa ka tafi gidanku, wurin mutanenka ka gaya ma su alherin da Ubangiji ya yi maka. ");
INSERT INTO hauulb_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Mutumin ya shiga cikin Dikafolis yana shaidar babban abin da Yesu ya yi masa, dukansu suka cika da mamaki. ");
INSERT INTO hauulb_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Sa'adda Yesu ya sake ketaren kogin zuwa daya gefen, acikin jirgin, sai taron jama'a suka keweye shi, a gefen tekun. ");
INSERT INTO hauulb_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Sai wani daya daga cikin shugabannin Majami'a mai suna Yayirus, ya zo, wurinsa sa'adda ya ganshi ya durkusa a gabansa. ");
INSERT INTO hauulb_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ya yi ta rokonsa, yana cewa, “Diya ta ba ta da lafiya har ma ta kusa mutuwa. Ina rokonka mu je gida na ka dora ma ta hannu domin ta warke. ta rayu.” ");
INSERT INTO hauulb_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Sai ya tafi tare da shi, babban taro suka biyo shi har ma suna matse shi. ");
INSERT INTO hauulb_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Akwai wata mace wadda ta ke zubar jini ta kai tsawon shekara goma sha biyu. ");
INSERT INTO hauulb_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ta sha wahala kwarai da gaske ta je wurin likitoci da yawa ta kashe kudi sosai, amma ba ta warke ba abin ma sai karuwa ya ke yi. ");
INSERT INTO hauulb_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ta ji labarin Yesu. Sai ta biyo bayansa yana tafiya cikin taro, ta taba habar rigarsa. ");
INSERT INTO hauulb_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Domin ta ce “Idan dai na taba ko da habar rigarsa zan warke.” ");
INSERT INTO hauulb_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Da dai ta taba shi sai zubar jinin ta ta tsaya, ta ji a jikin ta ta warke, daga damuwarta. ");
INSERT INTO hauulb_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Nan da nan, Yesu ya ji iko ya fita daga gare shi sai ya ce “wanene ya taba rigata?” ");
INSERT INTO hauulb_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Almajiransa suka ce, “ a cikin wannan taron mutane da yawa ka ce wanene ya taba ni?” ");
INSERT INTO hauulb_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Amma Yesu ya waiga ya ga ko wanene ya taba shi. ");
INSERT INTO hauulb_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Matar ta san abin da ya faru sai ta zo cikin tsoro da rawar jiki ta durkusa a gaban Yesu ta fada masa gaskiya. ");
INSERT INTO hauulb_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Sai ya ce da ita, “Diya bangaskiyarki ta warkar da ke, ki tafi lafiya kin sami warkewa daga cutarki”. ");
INSERT INTO hauulb_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Sa'adda ya ke magana da ita sai ga mutane daga gidan shugaban majami'a suka ce “Diyarka ta mutu me ya sa za ka dami malam?” ");
INSERT INTO hauulb_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Amma sa'adda Yesu ya ji abin da suka ce, sai ya ce da shugaban majami'ar, “kada ka ji tsoro ka ba da gaskiya kawai.” ");
INSERT INTO hauulb_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Bai bari kowa ya kasance tare da shi ba sai Bitrus da Yakubu da Yahaya dan'uwan Yakubu. ");
INSERT INTO hauulb_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Suka zo gidan shugaban majami'ar ya ga mutane suna bakin ciki, suna kuka sosai. ");
INSERT INTO hauulb_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Sa'adda ya shiga gidan ya ce da mutane “Me ya sa kuke damuwa da kuka?” Yarinyar ba ta mutu ba barci ta ke yi. ");
INSERT INTO hauulb_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Sai su kayi masa dariya. Amma ya fitar da su waje su duka. Ya kira baban yarinyar da mamar ta da wadansu da ke tare da shi su ka shiga wurin da yarinyar ta ke. ");
INSERT INTO hauulb_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ya kama hannun yarinyar ya ce da ita “Tilatha koum” wato yarinya na ce ki tashi” ");
INSERT INTO hauulb_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Nan da nan yarinyar ta tashi ta yi tafiya gama shekarun ta sun kai goma sha biyu. Nan da nan mutanen suka yi mamaki kwarai da gaske. ");
INSERT INTO hauulb_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ya ummurce su da gaske kada kowa ya sani. Ya ce da su su ba ta abinci ta ci. ");
INSERT INTO hauulb_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ya bar su ya zo garinsu, almajiransa su ka biyo shi. ");
INSERT INTO hauulb_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sa'adda ranar Asabar tazo ya shiga cikin masujada ya yi koyarwa. Mutane da yawa da su ka ji koyarwarsa su ka yi mamaki, suka ce daga ina ya sami irin wannan koyarwar? Wacce irin hikima ce Allah ya ba shi haka? Wadanne irin ayyukan al'ajibi ya ke yi da hannuwansa? ");
INSERT INTO hauulb_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Wannan ba kafintan nan ba ne dan Maryamu, dan'uwan Yakubu da Yosi da Yahuza da Saminu? Ba ga 'yan'uwan sa 'yan mata mu na tare da su ba? Ba su ji dadi ba a ransu saboda Yesu. ");
INSERT INTO hauulb_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yesu ya ce, “Annabi ba ya rasa daraja sai a gidansa da garinsa da cikin danginsa.” ");
INSERT INTO hauulb_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Bai iya yin wani aikin al'ajibi a wurin ba sai dai mutane kadan marasa lafiya ya dorawa hannu ya warkar da su. ");
INSERT INTO hauulb_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Rashin bangaskiyarsu ya ba shi mamaki. Sai ya tafi cikin kauyuka na kewaye da su ya yi ta koyarwa. ");
INSERT INTO hauulb_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ya kira almajiransa su goma sha biyu, ya aike su biyu-biyu, ya ba su iko a kan aljanu, ");
INSERT INTO hauulb_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","ya dokace su kada su dauki komai tare da su domin wannan tafiya, sai dai sanda kadai. Kada su dauki abinci ko jaka ko kudi a cikin aljihunsu, ");
INSERT INTO hauulb_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","sai dai su sa takalmi kadai, kada su sa taguwa biyu a jikinsu. ");
INSERT INTO hauulb_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ya ce da su, idan ku ka shiga wani gida sai ku zauna a gidan har lokacin da za ku tashi. ");
INSERT INTO hauulb_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Idan ku ka je wani gari aka ki karbar ku, ku karkabe kurar da ke kafufunku ta zama shaida kan mutanen garin. ");
INSERT INTO hauulb_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Sai suka tafi suka yi ta shela ga mutane cewa su tuba daga zunubansu. ");
INSERT INTO hauulb_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Sun fitar da aljanu da yawa, suka shafawa mutane da yawa mai suka warkar da su. ");
INSERT INTO hauulb_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Sarki Hirudus ya ji wannan, gama sunan Yesu ya zama sananne a wurin kowa da kowa. Wadansu suna cewa Yahaya mai yin baftisma ne ya tashi daga matattu shi ya sa ake yin wadannan ayyukan al'ajibi ta wurinsa. ");
INSERT INTO hauulb_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Wadansu kuma suna cewa, “Iliya,” Har yanzu wadansu suna cewa daya “daga cikin annabawa ne na da can.” ");
INSERT INTO hauulb_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Sa'adda Hirudus ya ji wannan sai ya ce, “Yahaya wanda na fillewa kai shine ya tashi.” ");
INSERT INTO hauulb_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Saboda Hirudus ne ya sa aka kama Yahaya aka kulle shi a kurkuku saboda Hirodiya( matar Filibus dan'uwansa), domin ya aure ta. ");
INSERT INTO hauulb_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Saboda Yahaya ya gaya wa Hirudus cewa bai halarta ya auri matar dan'uwansa ba. ");
INSERT INTO hauulb_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Sai ita Hirodiya ta yi kudurin ta kashe Yahaya amma bai yiwu ba. ");
INSERT INTO hauulb_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Domin Hirudus yana jin tsoron Yahaya, domin ya sani shi mai adalci ce, mai tsarki kuma. Domin haka Hirudus bai so wani abu ya faru da Yahaya ba, amma ya kan fusata idan ya ji wa'azin yahaya. Duk da haka da fari ciki yakan saurare shi. ");
INSERT INTO hauulb_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Amma sai dama ta samu inda Hirodiya za ta iya yin abin da ta ke so ta yi. A lokacin kewayowar ranar haihuwar sa, sai Hirudus ya shirya liyafa domin manyan da ke aiki tare da shi a cikin gwamnatin sa, da shugabannin da ke cikin Galili. ");
INSERT INTO hauulb_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Diyar Hirodiya ta zo ta yi masu rawa, rawarta kuwa tagamshi Hirudus da bakinsa. Sarki ya ce da yarinyar, “ki tambayi duk abin da ki ke so ni kuwa zan ba ki shi”. ");
INSERT INTO hauulb_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ya rantse mata da cewa”Ko menene ki ka ce ki na so, ko da rabin mulkina ne” ");
INSERT INTO hauulb_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Sai ta fita ta je ta tambayi mamarta, “ me zan ce ya bani?” Sai ta ce kan Yahaya Mai Yin Baftisma. ");
INSERT INTO hauulb_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Sai ta dawo da sauri cikin dakin taro wurin sarki ta ce da shi, “Ina so ka ba ni kan Yahaya Mai Yin Baftisma a cikin tire.” ");
INSERT INTO hauulb_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Sarki ya damu kwarai, amma saboda ya yi alkawari ga kuma ofisoshinsa, ba dama ya ce a'a. ");
INSERT INTO hauulb_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Sai sarki ya aiki wani soja ya ba shi ummurni ya je ya kawo kan Yahaya. Sojan ya je ya fillo kan sa daga cikin kurkuku. ");
INSERT INTO hauulb_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ya kawo kan a cikin tire ya ba yarinyar, yarinyar kuma ta kai wa mamarta. ");
INSERT INTO hauulb_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Da almajiran su ka ji labari, suka zo suka dauki gawarsa suka rufe a cikin kabari. ");
INSERT INTO hauulb_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Almajiran suka zo wurin Yesu, suka fada masa dukkan abin da suka yi da abin da suka koyar. ");
INSERT INTO hauulb_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Sai ya ce da su “ku je cikin kebabben wuri domin ku huta kadan,” domin mutane suna ta kaiwa da komowa, ba su sami damar hutawa ba balle su ci abinci ");
INSERT INTO hauulb_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Sai suka tafi kebabben wuri a cikin jirgin ruwa su kadai. ");
INSERT INTO hauulb_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Amma mutane da yawa sun gansu suna tafiya sun kuma gane su, sai suka fito daga cikin dukan garuruwa da gudu har su ka kai wurin kafin su zo. ");
INSERT INTO hauulb_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Sa'adda suka zo bakin gaba Yesu ya ga taron mutane da yawa sai ya ji tausayinsu domin sun yi kamar tumakin da ba da mai kiwo. Sai ya cigaba da koya masu abubuwa da yawa. ");
INSERT INTO hauulb_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Sa'adda yamma ta yi, almajiran sa suka zo suka ce da shi, “wurinnan kebabben wuri ne kuma ga lokaci ya tafi. ");
INSERT INTO hauulb_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ka sallami mutanen nan domin su shiga cikin garuruwa da kauyuka da ke kusa domin su sayi abin da zasu ci. ");
INSERT INTO hauulb_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Amma sai ya ba su amsa ya ce,”Ku ku basu abinci su ci mana”. Sai suka ce da shi, “ma iya zuwa mu sawo gurasa ta sule dari biyu mu basu su ci?” ");
INSERT INTO hauulb_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Sai ya ce dasu, “Dunkulen gurasa guda nawa kuke dasu? Kuje ku gani.” Dasuka gano sai suka ce da shi, dunkule biyar ne da kifi guda biyu.” ");
INSERT INTO hauulb_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Sai ya ba da umarni mutanen su dukka su zauna a kan danyar ciyawa. ");
INSERT INTO hauulb_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Suka zauna kungiya kungiya wadansu su dari wadansu hamsin. ");
INSERT INTO hauulb_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Sai ya dauki dunkulen gurasa guda biyar da kifi guda biyu, ya ta da kansa sama, yasa albarka, ya kakkarya dunkulen gurasan, ya ba almajiran domin su rabawa taron jama'a duka. ");
INSERT INTO hauulb_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Dukansu suka ci suka koshi. ");
INSERT INTO hauulb_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Suka tattara gutsattsarin gurasar suka cika kwanduna guda goma sha biyu da gutsattsarin da kuma gutsattsarin kifin. ");
INSERT INTO hauulb_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Mutanen da suka ci gurasar sun kai mutum dubu biyar. ");
INSERT INTO hauulb_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Nan da nan ya ce almajiran sa su hau jirgin ruwa su yi gaba kafin ya zo, su je Baitsaida. Shi kuma ya tsaya domin ya sallami taron mutanen. ");
INSERT INTO hauulb_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Bayan da suka tafi shi kuma ya hau kan dutse domin ya yi addu'a. ");
INSERT INTO hauulb_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Har yamma ta yi jirgin ruwan ya na tsakiyar rafi shi kuma yana kan tudu shi kadai. ");
INSERT INTO hauulb_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ya gansu suna wahala gama iska ta hana su tafiya. Wajan karfe hudu na asuba sai ya tawo wurin su yana tafiya a kan ruwa, yana so ya wuce gaban su. ");
INSERT INTO hauulb_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Sa'adda suka gan shi ya na tafiya a kan ruwa suka yi tsammani fatalwa ce, suka yi ihu, ");
INSERT INTO hauulb_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","gama su duka sun gan shi, tsoro ya kama su. Sai nan da nan ya yi magana dasu ya ce, “Ku karfafa ni ne! kada ku ji tsoro!'' ");
INSERT INTO hauulb_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ya shiga cikin jirgin ruwan tare dasu, sai iska ta dena bugawa. Sai suka yi mamaki kwarai. ");
INSERT INTO hauulb_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Gama basu gane batun dunkulen ba. Maimakon haka, sai zukatansu suka taurare. ");
INSERT INTO hauulb_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Sa'adda suka haye su zo kasar Janisarita suka sa wa jirgin sarka. ");
INSERT INTO hauulb_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Su na fitowa daga cikin jirgin kenan, mutane suka gane cewa Yesu ne. ");
INSERT INTO hauulb_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Mutane suka ruga cikin yankin su, suka kawo marasa lafiya a bisa shinfidun su zuwa wurinsa, dukan inda suka ji yana zuwa. ");
INSERT INTO hauulb_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ko ina ya shiga birni da kauye, ko a cikin kasar sukan kawo marasa lafiya a kasuwanni suna rokonsa su taba ko da habar rigarsa, dukan wadanda suka taba kuwa suka warke. ");
INSERT INTO hauulb_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Farisawa suka taru wurin Yesu tare da wadansu marubuta wadda suka zo daga Urushalima. ");
INSERT INTO hauulb_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Sun ga cewa wasu daga cikin almajiransa sun ci gurasa da hannuwa marasa tsabta, wato, basu wanke hannu ba, ");
INSERT INTO hauulb_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Domin Farisawa da dukan Yahudawa ba su cin abinci sai dole sun wanke hannu da kyau domin suna kiyaye al'adun dattawa. ");
INSERT INTO hauulb_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Idan Farisawa suka dawo daga kasuwa, wajibi ne su yi wanka kamin su ci abinci. Akwai sauran al'adun da suke kiyayewa, kamar wanke moda, tukwane, da wasu santula na dalma, har da dakin cin abinci.) ");
INSERT INTO hauulb_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Farisawa da Marubuta suka tambaye Yesu, “Don me almajiran ka basu kiyaye al'adun dattawa, domin suna cin abinci ba tare da sun wanke hannu ba?” ");
INSERT INTO hauulb_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Amma ya amsa masu cewa, “Ishaya ya yi anabci akan ku masu bautan ganin ido, da ya rubuta cewa 'wadanan mutane suna girmama ni a baka amma zuciyar su tana nesa da ni. ");
INSERT INTO hauulb_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Sujadar wofi suke mani suna koyar da ka'idodi na mutane a matsayin rukunansu'”. ");
INSERT INTO hauulb_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Kun watsar da dokar Allah sai kuka rungumi al'adun mutane. ");
INSERT INTO hauulb_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Sai yace masu, kun yi nasara wurin kau da dokokin Allah domin ku kiyaye al'adun ku na mutane. ");
INSERT INTO hauulb_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Koda shike Musa ya rubuta cewa, “ka girmama Ubanka da Uwarka”, kuma, “duk wanda ya zagi Ubansa ko Uwatasa, ya cancanci mutuwa nan take”. ");
INSERT INTO hauulb_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Amma kun ce, 'idan mutum ya ce wa iyayensa, “duk taimakon da ya cacanci ku samu daga guna ya zama kebabbe (wato, 'na mika wa Allah)”'. ");
INSERT INTO hauulb_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Sabo da haka, kun ba shi izini kada ya yi wa Ubansa ko Uwatasa wani abu. ");
INSERT INTO hauulb_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Kuna mayar da dokan Allah abin banza, sabili da al'adun ku da kuka mika masu. Wannan, da wasu abubuwa kamar haka kuke yi.” ");
INSERT INTO hauulb_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ya kara kiran taron jama'ar yace masu, “ku kasa kunne gareni, kuma ku gane. ");
INSERT INTO hauulb_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Babu wani abu daga wajen mutum da zai iya gurbatar da shi har idan ya shiga cikinsa. Amma, abinda ya fita daga cikinsa shike gurbatar da shi” ");
INSERT INTO hauulb_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Bari mai kunnen ji, ya ji. ");
INSERT INTO hauulb_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Da Yesu ya bar taron jama'ar, ya shiga gida, sai almajiransa suka tambaye shi ma'anar wannan misali. ");
INSERT INTO hauulb_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Sai Yesu yace, 'ashe baku da ganewa? ko baku sani cewa abin da ya shiga cikin mutum daga waje ba zai iya gurbatar da shi ba, ");
INSERT INTO hauulb_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","domin ba zai iya kai wa cikin zuciyarsa ba, sai dai ya shiga cikin sa ya kuma fita a matsayin bayan gari a salga”. Da wannan magana, Yesu ya mayar da dukan abinci ya zama da tsabta. ");
INSERT INTO hauulb_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ya ce, abinda ke cikin mutum shike gurbatar da shi ");
INSERT INTO hauulb_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Domin daga cikin mutum, kuma daga cikin zuciyarsa ne, mugun tunani, lalata, sata, kisa, ");
INSERT INTO hauulb_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","zina, kwadayi, mugunta, hai'inci, mugun guri, kishi, zargi, girmankai, wawanci. ");
INSERT INTO hauulb_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Duk wadannan miyagun abubuwa suna fitowa ne daga cikin mutum, kuma suke gurbatar da shi.” ");
INSERT INTO hauulb_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ya tashi daga nan ya tafi shiyyar Sur da Sida. Ya shiga wani gida don baya son wani ya sani cewa yana nan, amma bai iya boyuwa ba. ");
INSERT INTO hauulb_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Amma nan da nan wata mace, wadda diyarta ke da mugun ruhu-wannan mace kuwa ta ji game da Yesu sai ta zo ta durkusa a gabansa. ");
INSERT INTO hauulb_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Matar yar kasar Girka ce, kuma asalinta daga Fonishiya take. Ta roke shi da ya fitar da mugun ruhun nan daga diyarta. ");
INSERT INTO hauulb_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Sai ya ce mata, “Bari a ciyar da 'ya'ya tukuna. Domin bai kamata a dauki abincin yaya a ba karnuka ba”. ");
INSERT INTO hauulb_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Sai ta amsa masa cewa, “I, Ubangiji, Karnukan ma sukan ci abincin da ke fadowa daga teburin 'ya'yan.” ");
INSERT INTO hauulb_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ya ce mata, “domin kin fadi haka, kina iya ki tafi domin aljani ya fita daga diyarki.” ");
INSERT INTO hauulb_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ta koma gida sai ta iske diyarta na kwance akan gado, aljanin ya fice daga jikinta. ");
INSERT INTO hauulb_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ya sake fita daga shiyar Sur, ya biyo ta Sidon, har zuwa tekun Galili a shiyar Dikafolis. ");
INSERT INTO hauulb_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Sun kawo masa wani kurma, kuma bebe ne shi, suna rokansa ya dora hanuwansa a bisansa. ");
INSERT INTO hauulb_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Sai ya jawo shi daga taron jama'ar, zuwa gefe, sai ya sa hanunsa a kunuwan beben bayan ya tufa yawunsa, sannan ya taba harshensa. ");
INSERT INTO hauulb_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ya dubi sama, ya ja numfashi ya ce masa, “Ifatha”, wato, “bude!” ");
INSERT INTO hauulb_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Nan da nan ya mayar masa da jinsa. abinda ya daure harshensa ya sake shi, sai ya fara magana da kyau. ");
INSERT INTO hauulb_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ya umarce su da kada su gaya wa wani. Amma duk da umarnin da yake basu, suna ta shaida shi ko'ina. ");
INSERT INTO hauulb_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","kuma suna ta mamaki cewa, “Yayi kowanne abu da kyau, har ya sa kurame suna jin magana, da kuma bebaye na magana.” ");
INSERT INTO hauulb_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","A kwanakin nan, akwai wani gagaruman taron mutane, kuma basu da abincin ci. Yesu ya kirawo almajiransa yace masu, ");
INSERT INTO hauulb_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ina tausayin taron mutanen nan domin kwana uku kenan suna nan tare da ni babu abinci. ");
INSERT INTO hauulb_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Idan na salame su su koma gidajensu ba tare da sun ci abinci ba, za su galabaita a hanya domin gidajensu na da nisa.” ");
INSERT INTO hauulb_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Almajiransa suka amsa masa cewa, “A ina za mu iya samu gurasa a wannan jeji da zai ishi wadannan mutane haka?” ");
INSERT INTO hauulb_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ya tambaye su, “gurasa nawa kuke da su?” Sai suka ce, “Bakwai.” ");
INSERT INTO hauulb_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ya umarci mutanen da su zauna. Ya dauki gurasar bakwai, bayan da ya yi godiya, ya kakarya gurasar, sa'annan ya umarci almajiransa da su raba wa mutanen. Su kuwa suka raba masu. ");
INSERT INTO hauulb_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Suna kuma da kananan kifaye kadan. Bayan da ya yi godiya akan su, ya umurci almajiran su rabawa mutanen. ");
INSERT INTO hauulb_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Sun ci sun koshi. Suka tattara ragowar, har sun cika kwanduna bakwai. ");
INSERT INTO hauulb_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Akwai maza kimanin dubu hudu a wurin. Yesu ya sallame su. ");
INSERT INTO hauulb_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Nan take, ya shiga jirgin ruwa da almajiransa zuwa shiyyar Dalmanuta. ");
INSERT INTO hauulb_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Sai Farisawa suka zo suka fara gardama da shi. Suna nema ya nuna masu alama daga sama, domin su gwada shi. ");
INSERT INTO hauulb_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ya ja numfashi a ruhunsa yana cewa, “Don me wannan tsarar tana neman alama. Hakika ina gaya maku, babu wata alama da za a ba wannan tsarar.” ");
INSERT INTO hauulb_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Sai ya bar su ya sake shiga jirgin zuwa hayin tafkin. ");
INSERT INTO hauulb_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","A lokacin nan, almajiransa sun manta su dauki gurasa. Domin gurasa daya ce tak a garesu cikin jirgin ruwan. ");
INSERT INTO hauulb_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ya gargade su, “ku yi hattara da yisti na Farisawa da Yisti na Hirudus.” ");
INSERT INTO hauulb_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Almajiran suka fara tattaunawa a tsakaninsu, “Saboda ba mu da gurasa ne.” ");
INSERT INTO hauulb_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesu yana sane da wannan, sa'annan ya ce masu, “Don me kuke tattaunawa akan rashin gurasa? Har yanzu baku gane ba? Har yanzu ba ku da sane? Ko zuciyar ku ta duhunta ne?” ");
INSERT INTO hauulb_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Kuna da idanu, ba ku gani? Kuna da kunnuwa, ba ku ji? Ba ku tuna ba? ");
INSERT INTO hauulb_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Da na kakkarya gurasar a cikin mutane dubu biyar, kwanduna nawa kuka samu ragowa? Suka ce masa, “Goma sha biyu.” ");
INSERT INTO hauulb_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Kuma da na kakarya gurasa bakwai a cikin mutane dubu hudu, kwanduna nawa kuka dauka cike da ragowar? Suka ce masa, “bakwai.” ");
INSERT INTO hauulb_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ya ce masu, “har yanzu baku gane ba?” ");
INSERT INTO hauulb_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Sun zo Baitsaida. Mutanen wurin suka kawo masa wani makaho, sai suka roke shi ya taba shi. ");
INSERT INTO hauulb_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesu ya rike hanun makahon, ya jagorance shi zuwa bayan kauyen. Da ya tofa yawunsa a idon mutumin, kuma ya dora hanunsa akan mutumin, sai ya tambaye shi “kana ganin wani abu kuwa?” ");
INSERT INTO hauulb_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ya daga ido sai ya ce, “ina ganin mutane na tafiya kamar itatuwa.” ");
INSERT INTO hauulb_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ya sake dora masa hannu a idanuwansa, mutumin ya bude idanuwansa, sai ya fara ganin gari da kyau. ");
INSERT INTO hauulb_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yesu ya sallame shi zuwa gidansa nan take, ya ce masa, “kada ka shiga cikin garin” ");
INSERT INTO hauulb_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesu da almajiransa sun shiga kauyukan kaisariya ta Filibi. Da suke kan hanya, sai ya tambaye su, “Shin wanene mutane ke ce da ni?” ");
INSERT INTO hauulb_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Suka amsa masa suka ce, Yahaya mai Baftisma. Wasu suka ce, “Iliya”. wadansu kuma, 'Daya daga cikin anabawa”. ");
INSERT INTO hauulb_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ya tambaye su, “Amma me ku ke ce da ni?” Bitrus ya ce, “Kai ne Almasihu.” ");
INSERT INTO hauulb_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yesu ya umarce su kada su gaya wa kowa game da shi. ");
INSERT INTO hauulb_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Sai ya fara koya masu cewa, dole ne Dan Mutum ya sha wahala, dattawa da marubuta da manyan Firistoci zasu ki shi, a kuma kashe shi. Bayan kwana uku, zai tashi daga matattu. ");
INSERT INTO hauulb_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ya fadi wannan afili. Sai Birus ya ja shi gefe ya fara tsauta masa. ");
INSERT INTO hauulb_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Amma Yesu ya juya ya dubi almajiransa sa'annan ya tsautawa Bitrus yana cewa, “Ka koma bayana Shaidan, domin kana kula da abubuwan mutane ne kawai, ba na Allah ba.” ");
INSERT INTO hauulb_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Sai ya kira taron jama'ar da almajiransa a wuri daya, ya ce masu, “Duk wanda yake so ya bini, dole ne ya musunci kansa, ya dauki giciyensa ya biyo ni. ");
INSERT INTO hauulb_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Domin duk wanda yake so ya ceci ransa zai rasa shi, amma duk wadda ya rasa ransa domina da kuma bishara zai cece shi. ");
INSERT INTO hauulb_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Me zai amfani mutum idan ya sami dukan duniya sannan ya rasa ransa. ");
INSERT INTO hauulb_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Me mutum zai bayar amaimakon ransa? ");
INSERT INTO hauulb_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Duk wanda ke jin kunyata ko maganata a wannan mazinaciyar tsara mai zunubi, Dan Mutum ma zai ji kunyarsa a lokacin da ya dawo cikin daukakar Ubansa da Malaiku masu tsarki.” ");
INSERT INTO hauulb_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Sai ya ce masu, “Hakika, ina gaya maku, akwai wasun ku anan da ba za su mutu ba, sai sun ga mulkin Allah ya bayyana da iko.” ");
INSERT INTO hauulb_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Bayan kwana shida Yesu ya dauki Bitrus, da Yakubu, da Yahaya, ya kai su kan wani dutse mai tsawo, su kadai. Sai kamaninsa ya sake a gabansu. ");
INSERT INTO hauulb_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Sai tufafinsa ya zama fari fat, yadda ba mai rinin da zai iya rininsa haka a duniya. ");
INSERT INTO hauulb_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Sai Iliya da Musa suka bayyana gare su, suna magana da Yesu. ");
INSERT INTO hauulb_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Sai Bitrus ya amsa ya ce, malam, bari mu da muke anan mu kafa bukka uku, daya ta ka, daya ta Musa, da ta Iliya, ");
INSERT INTO hauulb_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ya rasa abin da zai fada ne, don sun tsorota kwarai.) ");
INSERT INTO hauulb_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Sai ga wani gajimare ya zo ya rufe su, aka kuma ji wata murya daga gajimaren, “ta ce Wannan shine kaunataccen Dana, Ku saurare shi. ");
INSERT INTO hauulb_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Nan take da suka duba, ba su ga kowa ba, sai Yesu shi kadai. ");
INSERT INTO hauulb_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Suna cikin gangarowa daga dutsen, sai ya kwabe su kada su gaya wa kowa abin da suka gani, sai bayan da Dan Mutum ya tashi daga mattatu. ");
INSERT INTO hauulb_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Sai suka bar zancen a tsakaninsu, amma suka tamabayi junansu “mene ne tashin matattu” ke nufi. ");
INSERT INTO hauulb_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Suka tambaye shi yaya malaman attaura suka ce Iliya zai fara zuwa?” ");
INSERT INTO hauulb_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ya ce masu, laile ne Iliya ya fara zuwa ya raya dukan abubuwan. Don me a ka rubuta cewa Dan Mutum, zai sha wuya iri iri a kuma ki shi? ");
INSERT INTO hauulb_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Amma ina gaya muku Iliya ya riga, ya zo, amma sun yi masa abin da suke so su yi kamar yadda littatafai suka yi magana a kansa.” ");
INSERT INTO hauulb_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Sa'adda suka dawo wurin sauran almajiran, suka ga taron jama'a masu yawa suna ta muhawara tare da manyan malaman attaura. ");
INSERT INTO hauulb_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Da ganin sa, sai dukan taron yayi mamaki kwarai da gaske, suka dungumo wurinsa a guje, suna gaishe shi. ");
INSERT INTO hauulb_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ya tambayi almajiransa, “ Wacce muhawara ce kuke yi da su?” ");
INSERT INTO hauulb_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Daya daga cikin taron ya amsa masa”malam, ga shi na kawo maka dana don yana da beben aljani. ");
INSERT INTO hauulb_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Duk lokacin da ya tasar masa yakan buga shi har kasa, na kuma yi wa almajiranka magana su fitar sun kasa. ");
INSERT INTO hauulb_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ya amsa masu ya ce ya ku mutanen zamaninnan marasa bangaskiya, har yaushe zan kasance tare da ku ina jimrewa? ku dai kawo mini shi. ");
INSERT INTO hauulb_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Sai suka kawo masa yaron. Da ruhun ya ga Yesu, nan da nan ya buge yaron jikinsa na rawa. Sai yaron ya fadi yana ta birgima, bakinsa yana kumfa. ");
INSERT INTO hauulb_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesu ya tambayi mahaifin yaron, Tun yaushe wannan abu ya same shi? Mahaifin yaron ya ce tun yana karami. ");
INSERT INTO hauulb_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ya kuwa sha jefa shi a ruwa da wuta, don ya halakar da shi. Idan zaka iya yin wani abu, ka ji tausayinmu ka taimakemu. ");
INSERT INTO hauulb_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesu ya ce masa, “In zan iya? Ai dukan abu mai yiwuwa ne, ga duk wanda ya gaskata. ");
INSERT INTO hauulb_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Nan da nan mahaifin yaron ya daga murya ya ce, Na ba da gaskiya. A kore mini rashin bangaskiyata. ");
INSERT INTO hauulb_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Da Yesu ya ga taron na dungumowa a guje, sai ya tsawata wa bakin aljanin ya ce masa, “kai, beben aljani na umarce ka, ka fita daga wannan yaron kar ka sake shigar sa. ");
INSERT INTO hauulb_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Sai wannan aljanin ya daga murya ya fita ya rabu da wannan yaron. Sai yaro ya zama kamar mattacce, sai sauran mutanen suka ce, “Ai, yaron ya mutu. ");
INSERT INTO hauulb_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Yesu ya kama hannunsa, ya daga shi, sai yaron ya mike tsaye. ");
INSERT INTO hauulb_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Da Yesu ya shiga gida, sai almajiransa suka tambaye shi a kadaice, me ya sa muka kasa fitar da shi?” ");
INSERT INTO hauulb_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ya ce masu, “Ai, irin wannan ba ya fita sai da addu'a.” ");
INSERT INTO hauulb_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Sai suka ratsa cikin Galili, amma ba ya son kowa ya san inda suke. ");
INSERT INTO hauulb_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Da yake koyar da almajiransa, ya ce masu lokaci na zuwa da za'a ba da Dan mutum a hannun mutane, za su kuwa kashe shi, sa'adda aka kashe shi kuma, bayan kwana uku zai tashi. ");
INSERT INTO hauulb_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Amma fa ba su fahimci maganar ba, suna kuma jin tsoron tambayarsa. ");
INSERT INTO hauulb_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Sai suka zo kafarnahum. A lokacin da ya ke cikin gida, ya tambayi Al'majiransa, Menene ku ke magana a kansa a hanya? ");
INSERT INTO hauulb_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Amma suka yi shiru. don suna gardama da junansu akan hanya, a kan wane ne mafi girma. ");
INSERT INTO hauulb_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Sai ya zauna, ya kira al'majiransa goma sha biyu, yace masu duk wanda ya ke so ya zama na fari, dole ya kankantar da kansa, sa'annan ya bautawa sauran duka. ");
INSERT INTO hauulb_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Sai ya dauko karamin yaro a hannunsa ya sa shi a tsakiyarsu. Ya rumgome shi a kafadarsa ya ce masu. ");
INSERT INTO hauulb_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Dukan wanda ya karbi dan karamin yaron nan a cikin sunana ni ya karba, kuma dukan wanda ya karbi wani, ni ya karba, bai kuma karbeni ni kadai ba, duk da wanda ya aiko ni.” ");
INSERT INTO hauulb_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Sai Yahaya ya ce masa, Malam mun ga wani yana fitar da aljanu da sunanka mun yi kokari mu hana shi domin ba ya tare da mu. ");
INSERT INTO hauulb_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Sai Yesu ya ce masu ku kyale shi domin babu wanda zai yi irin wannan babban aikin, sa'annan ya fadi wasu maganganu mara sa kyau a kanmu. ");
INSERT INTO hauulb_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Duk wanda ba ya gaba da mu, na mu ne. ");
INSERT INTO hauulb_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Duk wanda ya ba ku ruwa ku sha domin kuna na Almasihu, gaskiya nake fada maku ba za ya rasa ladansa ba. ");
INSERT INTO hauulb_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Amma duk wanda ya sa kananan nan tuntube, ya fi kyau a rataya masa dutsen nika a jefa shi a cikin teku. ");
INSERT INTO hauulb_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Idan har hannun ka zai sa ka yi tuntube, zai fi kyau ka yanke shi. Domin zai fi kyau ka shiga aljanna da hannu daya da ka shiga jahannama da hannu biyu. ");
INSERT INTO hauulb_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","(Inda tsutsotsi basu mutuwa, wutar kuma bata mutuwa). ");
INSERT INTO hauulb_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Idan kafarka za ta sa ka yi tuntube, ka yanke ta ka yar. Zai fi kyau ka shiga aljanna da kafa daya da ka shiga jahannama da kafa biyu. ");
INSERT INTO hauulb_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","(Inda tsutsotsi basu mutuwa, wutar kuma bata mutuwa). ");
INSERT INTO hauulb_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Idan idonka zai sa ka yi tuntube, ka kwakule shi ka yar, domin gwamma ka shiga mulkin Allah da ido daya, da a jefa ka cikin wuta da idanu biyu. ");
INSERT INTO hauulb_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Inda tsutsotsi basu mutuwa, wutar kuma bata mutuwa. ");
INSERT INTO hauulb_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Domin da wuta za a tsarkake kowa. ");
INSERT INTO hauulb_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Gishiri yana da kyau, amma idan ya rasa zakinsa, ta ya ya za ka sa shi yayi zaki kuma? Ku kasance da zaki, kuma ku yi zaman lafiya da kowa. ");
INSERT INTO hauulb_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu ya bar wannan wurin, ya tafi yankin Yahudiya, wajen hayin kogin Urdun. Sai jama'a suka je wurinsa. Ya ci gaba da koya masu, kamar yadda ya zama al'adarsa. ");
INSERT INTO hauulb_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Sai Farisawa su ka zo wurinsa, su ka ce, '' dai dai ne mutum ya saki matarsa?'' Wannan tambaya sun yi ta ne domin su gwada shi. ");
INSERT INTO hauulb_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ya amsa ya ce, menene Musa ya umarce ku? ");
INSERT INTO hauulb_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Suka ce, ''Musa ya yarda mutum ya rubuta takardar saki ga matarsa, ya sallameta ta fita.'' ");
INSERT INTO hauulb_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","“Domin taurin zuciyarku ne ya rubuta maku wannan dokar,” Yesu ya ce masu. ");
INSERT INTO hauulb_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Amman tun daga farkon halitta, 'Allah ya halicci namiji da ta mata.' ");
INSERT INTO hauulb_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Domin wannan dalilin ne mutum zai rabu mahaifinsa da mahaifiyarsa ya mannewa matarsa. ");
INSERT INTO hauulb_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Su biyu kuwa sun zama jiki daya, ba biyu ba, ");
INSERT INTO hauulb_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Saboda haka abinda Allah ya hada kada mutum ya raba.” ");
INSERT INTO hauulb_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Lokacin da suke cikin gida, sai almajiransa suka sake tambayarsa akan wannan magana. ");
INSERT INTO hauulb_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ya ce da su. Dukan wanda ya saki matarsa ya kuma auro wata matar yayi zina da ita kenan. ");
INSERT INTO hauulb_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Haka nan duk matar da ta saki mijinta ta auri wani ta yi zina da shi kenan.” ");
INSERT INTO hauulb_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Mutane suka kawo masa 'ya'yansu kanana don ya taba su, sai almajiransa suka kwabe su. ");
INSERT INTO hauulb_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Da Yesu ya gani, ya ji haushi, ya ce masu. Ku bar yara kanana su zo wurina, kada ku hana su domin mulkin Allah na irinsu ne. ");
INSERT INTO hauulb_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Gaskiya na ke fada maku duk mutumin da bai karbi mulkin Allah kamar karamin yaro ba, babu shakka ba zai shiga mulkin Allah ba. ");
INSERT INTO hauulb_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Sai ya rungume su ya sa masu albarka. ");
INSERT INTO hauulb_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Lokacin da ya fara tafiya, sai wani mutum ya rugo wurinsa, ya durkusa a gabansa. Ya tambaye shi, yace ya ''Malam managarci, me zan yi domin in sami rai na har abada?'' ");
INSERT INTO hauulb_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Amma Yesu ya ce masa. Don me ka ke kira na managarci? Babu wani managarci sai dai Allah kadai. ");
INSERT INTO hauulb_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Kasan dokokin. Kada ka yi kisan kai, kada ka yi zina, kada ka yi sata, kada ka yi shaidar zur, kada ka yi zamba, ka girmama mahaifinka da mahaifiyarka.” ");
INSERT INTO hauulb_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Sai mutumin ya ce masa Malam ai na kiyayye duk wadannan abubuwa tun ina yaro. ");
INSERT INTO hauulb_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesu ya dube shi duban kauna ya ce masa. Abu daya ka rasa. Shi ne ka je ka sayar da duk mallakarka ka ba mabukata, za ka sami wadata a sama. Sa'annan ka zo ka bi ni. ");
INSERT INTO hauulb_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Da ya ji haka sai ransa ya baci, ya tafi yana bakin ciki, don shi mai arziki ne kwarai. ");
INSERT INTO hauulb_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesu ya dubi almajiransa ya ce. ''Yana da wuya masu arziki su shiga mulkin Allah!'' ");
INSERT INTO hauulb_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Almajiransa suka yi mamakin maganarsa. Sai Yesu ce masu, ya ku ya'ya'na yana da wuya kamar me a shiga mulkin Allah. ");
INSERT INTO hauulb_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Zai zama da sauki ga rakumi yabi ta kafar allura da mai arziki ya shiga mulkin Allah. ");
INSERT INTO hauulb_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Sai suka cika da mamaki sosai, su kace wa juna, ''to idan haka ne wanene zai iya tsira kenan?'' ");
INSERT INTO hauulb_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesu ya dube su ya ce masu. Ga mutane a bu ne mai wuyar gaske, amma a wurin Allah komai yiwuwa ne. ");
INSERT INTO hauulb_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Bitrus ya ce masa, ''to gashi mu mun bar kome, mun bika''. ");
INSERT INTO hauulb_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesu ya ce. Gaskiya na ke fada maku, babu wanda zai bar gidansa, da yan'uwansa maza da mata, da mahaifiya ko mahaifi, ko 'ya'ya ko gona, saboda da ni da kuma bishara, ");
INSERT INTO hauulb_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","sa'annan ya rasa samun nikinsu dari a zamanin yanzu, na gidaje, da yan'uwa mata da maza' da iyaye mata da 'ya'ya da gonaki, game da tsanani, a duniya mai zuw kuma ya sami rai madawwami. ");
INSERT INTO hauulb_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Da yawa wadanda suke na farko za su koma na karshe, na karshe kuma za su zama na farko. ");
INSERT INTO hauulb_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Suna tafiya Urushalima, Yesu kuwa na gabansu. Almajiransa sun yi mamaki, mutane da ke biye da su kuwa sun tsorata. Yesu kuwa ya sake kebe sha biyun nan, ya fara fada masu abin da zai same shi. ");
INSERT INTO hauulb_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Kun ga, za mu Urushalima za a bada Dan mutum ga manyan Firistoci da malan Attaura, za su kuma yi masa hukuncin kisa su kuma bada shi ga al'ummai. ");
INSERT INTO hauulb_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Za su yi masa ba a, su tofa masa yau, su yi masa bulala, su kashe shi, bayan kwana uku kuwa zai tashi.” ");
INSERT INTO hauulb_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Yakubu da Yahaya, 'ya'yan Zabadi, suka zo wurin sa, suka ce, ''Malam muna so kayi mana duk abin da mu ka roke ka'' ");
INSERT INTO hauulb_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ya ce masu. ''Me ku ke so in yi maku?'' ");
INSERT INTO hauulb_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Suka ce, ''ka yardar mana, a ranar daukakarka, mu zauna daya a damanka, daya kuma a hagunka.'' ");
INSERT INTO hauulb_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yesu ya ce masu. ''Ba ku san abinda ku ke roka ba. Kwa iya sha daga kokon da zan sha? Ko kuma za a yi maku baftismar da za a yi mani?'' ");
INSERT INTO hauulb_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Suka fada masa, ''Zamu iya.'' Yesu ya ce masu, '' kokon da zan sha, da shi zaku sha, baftismar da za ayi mani kuma da ita za a yi maku.'' ");
INSERT INTO hauulb_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Amma zama a damata, ko a haguna, ba na wa ba ne da zan bayar, ai na wadanda a ka shiryawa ne.” ");
INSERT INTO hauulb_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Da sauran almajiran nan goma suka ji, suka fara jin haushin Yakubu da Yahaya. ");
INSERT INTO hauulb_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yesu kuma ya kira su wurinsa ya ce masu, '' kun sani wadanda aka san su da mulkin al'ummai sukan nuna masu iko, hakimansu kuma sukan gasa masu iko. ");
INSERT INTO hauulb_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Amma ba haka zai kasance a tsakaninku ba. Duk wanda ya ke son zama babba a cikinku, lalle ne ya zama baranku. ");
INSERT INTO hauulb_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Duk wanda ya ke so ya shugabance ku lalle ne ya zama bawan kowa. ");
INSERT INTO hauulb_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Saboda haka ne Dan mutum ya zo ba domin a bauta masa ba, sai dai domin shi yayi bautar, ya kuma ba da ransa fansa saboda da mutane da yawa.” ");
INSERT INTO hauulb_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Sa'adda suka iso Yariko, yana fita daga Yariko kenan, shi da almajiransa, da wani babban taro, sai ga wani makaho mai bara, mai suna Bartimawas dan Timawas yana zaune a gefen hanya. ");
INSERT INTO hauulb_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Da ya ji Yesu Banazare ne, ya fara daga murya yana cewa, ''Ya Yesu, Dan Dauda, kaji tausayina'' ");
INSERT INTO hauulb_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Mutane da yawa suka kwabe shi, cewa yayi shiru. Sai ya kara daga murya kwarai da gaske, yana cewa, Ya Dan Dauda ka yi mani jinkai, ka ji tausayina!” ");
INSERT INTO hauulb_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesu ya tsaya ya ce, ku kirawo shi. Su kuwa suka kirawo makahon suka ce masa. ''Albishrinka, ta so! Yana kiranka.'' ");
INSERT INTO hauulb_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Makahon ya yar da mayafinsa, ya zaburo wurin Yesu. ");
INSERT INTO hauulb_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesu ya tambaye shi, ya ce, '' me ka ke so in yi maka?'' Makahon ya ce, ''Malam in sami gani.'' ");
INSERT INTO hauulb_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesu ya ce masa. ''Yi tafiyarka, bangaskiyarka ta warkar da kai.'' Nan take idanunsa suka bude, ya bi Yesu, suka tafi tare. ");
INSERT INTO hauulb_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Da suka kusa Urushalima, kusa da Betafaji, da Betanya, wajen dutsen zaitun, sai Yesu ya aiki almajiransa biyu ");
INSERT INTO hauulb_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ya ce masu, “ ku shiga kauyen can kusa da mu. Da zarar kun shiga za ku ga aholaki a daure, wanda ba a taba hawa ba. Ku kwance shi, ku kawo mani. ");
INSERT INTO hauulb_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","In wani ya ce maku, “Don me kuke haka? ku ce, 'Ubangiji ne yake bukatarsa, zai kuma komo da shi nan da nan.”' ");
INSERT INTO hauulb_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Sai suka tafi, suka tadda aholakin a daure a kofar gida a bakin hanya, suka kwance shi. ");
INSERT INTO hauulb_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","sai wadanda suke tsaye a gun suka ce masu, “Don me kuke kwance aholakin nan? ");
INSERT INTO hauulb_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Suka fada masu abinda Yesu yace, sai suka kyale su suka tafi. ");
INSERT INTO hauulb_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Almajiran nan biyu suka kawo wa Yesu aholakin, suka shimfida mayafansu a kai, sai ya hau. ");
INSERT INTO hauulb_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Sai mutane da yawa suka shimfida mayafansu a hanya, wadansu kuma suka baza ganyen da suka yanko daga filayen. ");
INSERT INTO hauulb_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Wadanda suke gaba da shi da wadanda ke bin bayansa suka yi sowa suna cewa, “Hosanna! Albarka ta tabbata ga mai zuwa cikin sunan Ubangiji. ");
INSERT INTO hauulb_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Albarka ta tabbata ga mulkin nan mai zuwa na Ubanmu Dawuda! Dukaka a cikin sama!” ");
INSERT INTO hauulb_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","San nan Yesu ya shiga Urushalima, ya shiga Haikalin. Sai ya dudduba komai, da magariba ta yi, ya fita ya tafi Betanya tare da goma sha biyu nan. ");
INSERT INTO hauulb_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Kashe gari, suka tashi daga Betanya, sai ya ji yunwa. ");
INSERT INTO hauulb_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Da ya hango itacen baure mai ganye daga nesa sai ya je ya ga ko za sami 'ya'ya. Da ya iso wurinsa bai ga komai ba sai ganye, don ba lokacin 'ya'yan baure ba ne. ");
INSERT INTO hauulb_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Sai ya ce wa bauren, “Kada kowa ya kara cin ''ya'yanka har abada!” Almajiransa kuwa sun ji maganar. ");
INSERT INTO hauulb_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Suka iso Urushalima, da shigar su, ya kori masu saye da sayarwa, ya watsar da taburan 'yan canjin kudi, da kujerun masu sayar da tantabaru. ");
INSERT INTO hauulb_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ya hana kowa ya dauki wani abu da za a i ya sayarwa a cikin haikalin. ");
INSERT INTO hauulb_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Sai ya koyar da su cewa, “Ashe ba rubuce yake ba, “ Za a kira gidana gidan addu'a na dukan al'ummai? Amma ku kun mayar da shi kogon yan fashi”. ");
INSERT INTO hauulb_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Da mayan Faristoci da marubutan attaura suka ji maganar da ya yi, sai suka nami hanyar da za su kashe shi. Amma suka ji tsoronsa domin dukkan taron na mamakin koyarwarsa. ");
INSERT INTO hauulb_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Kowace yamma kuma, sukan fita gari. ");
INSERT INTO hauulb_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Da safe suna wucewa, sai suka ga bauren nan ya bushe. ");
INSERT INTO hauulb_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Bitrus kuwa ya tuna ya ce “Malam, dubi! Baurenan da ka la'anta ya bushe.” ");
INSERT INTO hauulb_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesu ya amsa masu ya ce, “ ku gaskata da Allah.” ");
INSERT INTO hauulb_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Hakika, ina gaya maku, duk wanda ya ce wa dutsen nan tashi ka fada cikin tekun', bai kuwa yi shakka a zuciyarsa ba, amma ya gaskata haka kuwa zai faru, haka kuwa Allah zai yi. ");
INSERT INTO hauulb_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Saboda haka ina dai gaya maku, komai kuka yi addu'a kuka roka, ku gaskata cewa samamme ne, zai kuma zama naku. ");
INSERT INTO hauulb_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Duk sa'add da kuke addu'a ku gafarta wa wadanda suka yi maku laifi, domin Ubanku shima zai gafarta maku naku laifi.” ");
INSERT INTO hauulb_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","(Amma in baku gafartawa mutane laifofinsu ba, Ubanku ma da ke sama ba zai gafarta maku ba.) ");
INSERT INTO hauulb_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Da suka sake dawowa Urushalima. Yasu na tafiya cikin haikali, sai manyan firistoci, da marubuta, da dattawa suka zo wurinsa, ");
INSERT INTO hauulb_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","suka ce masa, “Da wanne iko kake yin wadanan abubuwa? Ko kuwa wa ya ba ka ikon yinsu? “ ");
INSERT INTO hauulb_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Sai Yesu ya ce masu, “Zan yi maku wata tambaya. ku ba ni amsa, ni kuwa zan gaya maku ko da wanne iko ne nake yin wadannan abubuwan. ");
INSERT INTO hauulb_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Baftismar da Yahaya yayi, daga sama take ko kuwa daga mutum take? ku bani amsa”. ");
INSERT INTO hauulb_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Sai suka yi mahuwara da juna, suka ce, “in kuwa muka ce, 'daga sama take,' za ya ce, “To, don me ba ku gaskata shi ba? ");
INSERT INTO hauulb_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","In kuwa muka ce, “ amma in muka ce ta mutum ce zasu jejjefemu domi suna jin tsoron jama'a, don duk kowa ya tabbata, cewa Yahaya annabi ne. ");
INSERT INTO hauulb_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Sai suka amsa wa Yesu suka ce, “Ba mu sani ba” Yesu ya ce masu, “Haka ni kuma ba zan fada muku ko da wanne iko nake yin abubuwan nan ba.” ");
INSERT INTO hauulb_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Sai Yesu ya fara koyar da su da misalai. “Wani mutum ne ya yi gonar inabi ya shingen ta, ya haka ramin matse inabin, ya kuwa gina hasumayar tsaro. Ya ba wandansu manoma jinginar gonar, sa'an nan ya tafi wata kasa mai nisa. ");
INSERT INTO hauulb_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Da lokaci ya yi, sai ya aika masu wani bawansa domin ya karbi wadansu daga cikin amfanin gonar. ");
INSERT INTO hauulb_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Amma manoman suka kama shi, suka yin masa duka, suka kore shi hannu banza. ");
INSERT INTO hauulb_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ya sake aikar wani bawan. Shi kuma suka raunata shi aka, suka wulakanta shi. ");
INSERT INTO hauulb_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ya sake aiken wani. Shi kam, suka kashe shi. Haka fa aka yi ta yi da wadansu da yawa, sun dodoki wadansu, suka kuma kashe wadansu. ");
INSERT INTO hauulb_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Yanzu dai yana da sauran daya tak, shine kaunatacen dansa. Daga karshe ya aike shi wurinsu, yana cewa, ai za su bashi girma. ");
INSERT INTO hauulb_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Amma manoman nan suka ce wa juna, “ai, wannan shine magajinsa, 'ku zo mu kashe shi, gadon ya zama namu.” ");
INSERT INTO hauulb_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Sai suka kamo shi, suka kashe shi, suka jefar da shi bayan shinge. ");
INSERT INTO hauulb_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","To, me mai gonar inabin zai yi? Sai ya zo ya hallaka manoman nan, ya ba wadansu gonar. ");
INSERT INTO hauulb_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ashe, ba ku karanta wannan nassi ba? cewa, ' Dutsen da magina suka ki, shi ne ya zama mafi mahmimanci. ");
INSERT INTO hauulb_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Wannan daga Ubangiji ne, kuma ya yi dai dai a idanunmu.”' ");
INSERT INTO hauulb_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Sai suka nemi su kama shi, don sun lura a kansu ne ya yi masalin, amma suka ji tsoron jama'a. Don haka suka kyele shi, suka tafi. ");
INSERT INTO hauulb_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Suka aika masa da wadansu farisiyawa da Heridiyawa, don su sa masa tarko da kalamai cikin maganarsa. ");
INSERT INTO hauulb_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Da suka zo, suka ce masa, “Malam, gaskiya kana koyar da maganar Allah sosai, ba ka nuna bambanci tsakani mutane, sai koyar da tafarkin Allah kake yi sosai. “Shin, mu biya haraji ga Kaisar, ko a a?” ");
INSERT INTO hauulb_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","AmmaYesu ya gane munafuncinsu, ya ce masu, “Don me kuke gwada ni? ku kawo mani dinarin in gani.” ");
INSERT INTO hauulb_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Suka kawowa Yesu daya. Ya ce masu, “ Kamar waye da kuma rubutun wanene? suka ce masa, “Na Kaisar ne.” ");
INSERT INTO hauulb_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Yesu ya ce, “to, ku ba Kaisar abinda yake na Kaisar, ku kuma ba Allah abin da yake na Allah. Sai suka yi mamakinsa kwarai. ");
INSERT INTO hauulb_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sai Sadukiyawa suka zo wurinsa, su dake cewa babu tashin matattu. Suka tambaya shi suka ce, ");
INSERT INTO hauulb_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Malam, Musa dai ya rubuta mana, cewa idan dan'uwan mutum ya mutu, ya bar matarsa ba da, lallai ne dan'uwan mutumin ya auri matar, ya haifa wa dan'uwansa 'ya'ya.' ");
INSERT INTO hauulb_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","To an yi wadansu 'yan'uwa maza guda bakwai, na farko ya yi aure, ya mutu bai bar 'ya'ya ba. ");
INSERT INTO hauulb_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Na biyu kuma ya aure ta, shi ma ya mutu, ba 'ya'ya. Na ukun ma haka. ");
INSERT INTO hauulb_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Haka dai duk bakwai din, ba wanda ya bar 'ya'ya. A karshe kuma ita matar ta mutu. ");
INSERT INTO hauulb_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","To, a tashin matattu, matar wa za ta zama a cikinsu? Don duk bakwai din nan sun aure ta”. ");
INSERT INTO hauulb_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Sai Yesu ya ce, “Ba saboda wannan dalili ne kuka yi kuskure ba, wato don ba ku san littafin ba, kuma ba ku san ikon Allah ba? ");
INSERT INTO hauulb_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Domin in an tashin daga matattu, ba a aure, ba a auraswa, amma sun zama kamar malaiku a sama. ");
INSERT INTO hauulb_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Amma game da mattattun da suka tashi, ashe, ba ku taba karantawa a littafin Musa ba, yadda Allah ya ce masa? “Ni ne Allah na Ibrahim, da Ishaku, da kuma Yakubu'? ");
INSERT INTO hauulb_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ai, shi ba Allahn mattatu bane, amma na rayyayu ne. Hakika kun yi kuskure “. ");
INSERT INTO hauulb_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Sai wani malamin attuara ya zo ya ji suna muhawara da juna. Da dai ya ga Yesu yana ba su kyakkyawar amsa, sai ya tambaye shi, “Wanne Umarni ne mafi girma dukka?” ");
INSERT INTO hauulb_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesu ya amsa yace, “ mafi girma shine, 'ku saurara ya Isra'ila, Ubangiji Allahnmu, Ubangiji daya ne. ");
INSERT INTO hauulb_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Sai ka kaunaci Ubangiji Allah da dukkan zuciyarka, da dukkan ranka da dukkan tunaninka, da dukkan karfinka. ");
INSERT INTO hauulb_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","ta biyu itace, 'ka kaunaci makwabcinka kamar kanka, Ba wata doka da ta fi wadannan.'' ");
INSERT INTO hauulb_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Sai malamin attaura ya ce masa, “Hakika gaskiyarka malam, Allah daya ne, ba kuma wani sai shi. ");
INSERT INTO hauulb_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","A kaunace shi kuma da dukkan zuciya, da dukkan hankali, da dukkan karfi, a kuma kaunaci makwabci kamar kanka, ai ya fi dukkan hadayu na konawa.” ");
INSERT INTO hauulb_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Da Yesu ya ga ya yi masa magana da hikima, sai ya ce masa, “Ba ka nesa da mulkin Allah.” Bayan wannan kuma ba wanda ya sake tambayarsa wani abu. ");
INSERT INTO hauulb_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesu ya amsa a lokacin da yake koyarwa a Haikali, ya ce “Yaya malaman attaura suke ce wa Kristi dan Dauda ne? ");
INSERT INTO hauulb_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Domin Dauda kansa, ta ikon Ruhu Mai Tsarki ya ce, “Ubangiji ya ce wa Ubangijina, zauna a hannun damana, har sai na kaskantar da makiyanka'. ");
INSERT INTO hauulb_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dauda da kansa ya kira shi 'Ubangiji; To, ta yaya ya Almasihu zai zama Dan Dauda?” Babban taron jama'ar suka saurare shi da murna. ");
INSERT INTO hauulb_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","A koyarwa sa Yasu ya ce, “ku yi hankali da malaman attaura, masu son yawo da manyan riguna, suna so a gaishesu a kasuwa, ");
INSERT INTO hauulb_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","da kuma son wuraren zama masu daraja a haikali, da wurin bukukuwa. ");
INSERT INTO hauulb_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Sun kuma kwace gidajen gwauraye, da yin doguwar addu'a, don mutane su gani. Wadanan mutanen zasu sami hukunci mai tsanani.” ");
INSERT INTO hauulb_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Sai ya zauna a gaban akwatin baiko a Haikalin, yana duban yadda jama'a suke zuba kudi a ciki. ");
INSERT INTO hauulb_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Wadansu masu arziki da yawa suna zuba kudi masu tsoka. Sai gwauruwa mara abin hanu ta saka anini biyu a ciki akwatin baikon. ");
INSERT INTO hauulb_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ya kira almajiransa, ya ce masu, “Hakika, ina gaya maku, abinda gwauruwa nan ta saka a akwatin baikon nan ya fi na sauran dukka. ");
INSERT INTO hauulb_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Su duk sun bayar daga yalwa tasu ne, ita kuwa daga cikin rashinta ta bada duk abinda take da shi.” ");
INSERT INTO hauulb_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","da Yesu ke fita daga Haikalin, sai daya daga cikin almajirnsa ya ce masa “malam, dubi kyawawan duwatsunnan da kyawawan gine-ginnenan!” ");
INSERT INTO hauulb_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ya ce masa, ka ga wadannan kyawawan gine- ginen? babu wani dutsen da za a bar shi akan dan'uwansa, da ba za a rushe shi ba.” ");
INSERT INTO hauulb_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yana zaune a kan dutsen zaitun wanda yake kusa da Haikali, sai Bitrus, da Yakubu, da Yahaya, da Andarawus suka tambaye shi a asirce, suka ce. ");
INSERT INTO hauulb_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Gaya mana yaushe za a yi wadannan abubuwa? mecece zata zama alamar faruwar wadanna abubuwa da zasu faru?'' ");
INSERT INTO hauulb_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesu ya ce masu, “ku kula, kada kowa ya rudeku. ");
INSERT INTO hauulb_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Da yawa za su zo da sunana, suna cewa nine shi, har su bad da mutane da yawa. ");
INSERT INTO hauulb_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","In kuka ji labarin yake- yake, da jita-jitarsu kada ku damu, wannan zai faru, amma karshen duniya bai gabato ba. ");
INSERT INTO hauulb_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Al'umma za ta tasarwa al'umma, mulki ya tasarwa mulki. Za a yi girgizar kasa awurare dabam-dabam, da kuma yunwa, amma fa dukkan wadanna abubuwan mafarin azaba ne. ");
INSERT INTO hauulb_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Amma, ku zauna a fadake. Don za su kai ku gaban majalisa. za a yi maku duka a cikin majami'u. Su kuma kai ku gaban masu mulki da sarakuna, saboda sunana, domin ku ba da shaida a gare su. ");
INSERT INTO hauulb_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Amma lallai sai an fara yi wa dukkan al, ummai bishara. ");
INSERT INTO hauulb_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Sa'ad da suka kai ku gaban shari'a suka mika ku, kada ku damu a wannan lokacin, za a baku abin da zaku fada, Amma duk abin da aka yi muku a wannn lokacin, shi za ku fada, domin ba ku ne kuke magana ba, Ruhu mai tsarki ne. ");
INSERT INTO hauulb_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Dan'uwa zai bada dan'uwarsa akashe shi, uba kuwa dansa. Yara kuma zasu tayar wa iyayensu har su sa akashe su. ");
INSERT INTO hauulb_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Za a ki ku saboda sunana, amma duk wanda ya jumre har karshe zai cetu. ");
INSERT INTO hauulb_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Sa'adda kuka ga an kafa mummunan aikin sabo mai ban kyama a wurin da bai kamata ba (bari mai karatu ya fahimta), to, bari wadanda suke kasar Yahudiya, su gudu zuwa dutse. ");
INSERT INTO hauulb_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Wanda yake tudu kuma kada ya sauko ya shiga gida garin daukar wani abu. ");
INSERT INTO hauulb_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Wanda yake gona kuma kada ya koma garin daukar mayafinsa. ");
INSERT INTO hauulb_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Amma, kaiton masu juna biyu da masu goyo a wannan lokacin. ");
INSERT INTO hauulb_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ku yi addu, a kada abin ya faru da damina. ");
INSERT INTO hauulb_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","A lokacin za ayi wata matsanaciyar wahala, wadda bata taba faruwa ba, tun farkon halittar da Allah ya yi har zuwa yau, ba kuwa za a taba yi ba har abada. ");
INSERT INTO hauulb_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","In da ba ubangiji ya rage kwanakin nan ba, da ba Dan adam din zai tsira. Amma saboda zabbabunan da ya zaba, ya rage kwanakin. ");
INSERT INTO hauulb_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","To, in wani ya ce maku, kun ga Almasihu nan!' ko, 'kun gan shi can, kada ku gaskata. ");
INSERT INTO hauulb_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Gama almasihan karya, da annabawan karya zasu bayyana kuma, zasu yi abubuwan al'ajibai masu ban mamaki. ");
INSERT INTO hauulb_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Amma ku zauna a fadake, Na dai fada maku wadannan abubuwan kafin lokacin. ");
INSERT INTO hauulb_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Amma, bayan matsanaciyar wahalannan, rana zata duhunta, wata kuma ba zai bada haske ba. ");
INSERT INTO hauulb_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Taurari za su fado daga sararin sama, za a kuma girgiza manyan abubuwan da suke a sararin sama. ");
INSERT INTO hauulb_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Sa' annan zasu ga Dan mutum na zuwa a cikin gajimare, da iko mai girma da daukaka. ");
INSERT INTO hauulb_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Zai aiko da mala'ikunsa su tattaro zabbabunsa daga kusuwoyi hudu na duniya(watau Gabas da Yamma, kudu da Arewa) har zuwa karshen sama. ");
INSERT INTO hauulb_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Ku yi koyi da itacen baure. Da zarar rassansa sun fara taushi yana kuma fitar da toho, kun san damina ta yi kusa ke nan. ");
INSERT INTO hauulb_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Sa'adda kuka ga wadannan abubuwa suna faruwa, ku dai sani ya kusato, a bakin kofa ma ya ke. ");
INSERT INTO hauulb_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Hakika ina gaya maku, zamanin nan ba zai shude ba sai dukan abubuwan nan sun faru. ");
INSERT INTO hauulb_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Sararin sama da kasa za su shude, amma maganata ba za ta shude ba. ");
INSERT INTO hauulb_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Amma wannan rana ko sa'a ba wanda ya sani, ko mala'ikun sama, ko Dan, sai dai Uban kadai. ");
INSERT INTO hauulb_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ku kula, ku zauna a fadake, kuna addu'a don baku san ranar da lokacin zai yi ba. ");
INSERT INTO hauulb_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Kamar yadda mutum mai tafiya, in ya bar gida ya wakilta bayinsa kan gidansa, kowanne da aikinsa, ya kuma umarci mai gadi ya zauna a fadake. ");
INSERT INTO hauulb_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","To, ku zauna a fadake don ba ku san lokacin da maigidan zai zo ba, ko da yamma ne, ko da tsakar dare ne, ko da carar zakara ne, ko da safe ne. ");
INSERT INTO hauulb_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Kada ya zo ba zato, ya samu kuna barci. ");
INSERT INTO hauulb_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Abinda na gaya maku, ina gaya wa kowa, shine ku zauna a fadake!” ");
INSERT INTO hauulb_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Idin Ketarewa da bukin gurasa mara yisti sauran kwana biyu kenan, sai shugabanin firistoci da malaman attaura suka nemi yadda zasu kama Yesu a asirce domin su kashe shi. ");
INSERT INTO hauulb_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Suna cewa amma “Ba a lokacin idin ba, domin kada su haddasa hargitsi a tsakanin mutane”. ");
INSERT INTO hauulb_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesu yana Betanya a gidan Saminu kuturu, yana shirin liyafa kenan sai ga wata mace dauke da kwalbar turare mai tamanin kwarai, ta shafa masa a kansa. ");
INSERT INTO hauulb_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","wasu dake tare da Yesu suka husata, suna kwalbarta da cewa ");
INSERT INTO hauulb_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","“Ai wannan turare ne mai tsada, ina laifin a sayar a raba wa talakawa kudin? ina dalilin wannan almubazaranci? ");
INSERT INTO hauulb_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Sai Yesu yace masu “Ku kyaleta, don me kuke tsauta mata, ");
INSERT INTO hauulb_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","ai Idan kuna da niyyar taimakon talakawa ko matalauta, suna nan tare da ku ko a yaushe amma ni bazan kasance da ku kullum ba. ");
INSERT INTO hauulb_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Macen nan tayi aiki nagari domin shirya jikina ga jana'iza. ");
INSERT INTO hauulb_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","hakika, Ina gaya maku, duk inda za'a yi bishara a duniya baza a mance da matan nan da hidimar da ta tayi mini ba.” ");
INSERT INTO hauulb_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Da jin haka sai Yahuza Iskariyoti, daya daga cikin manzannin ya ruga zuwa wurin baban firist domin ya bashe shi a garesu, ");
INSERT INTO hauulb_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Da mayan firistoci suka ji haka suka yi murna matuka tare da alkawarin kudi ga Yahuza, shi kuwa sai ya fara neman zarafin da zai mika Yesu a gare su. ");
INSERT INTO hauulb_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","A ranar farko ta bukin gurasa marar yisti da kuma hadayar ragon Idin ketarewa, almajiransa suka ce masa “Ina zamu shirya liyafar domin idin ketarewa? ");
INSERT INTO hauulb_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ya aiki biyu daga cikin almajiransa da cewa “Ku shiga cikin birnin, zaku tarar da wani mutum dauke da tullun ruwa. ");
INSERT INTO hauulb_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Duk gidan da ya shiga ku bishi, sai ku cewa mai gidan, malam yace “ina bukatar masauki domin hidimar idin ketarewa tare da almajiraina?”' ");
INSERT INTO hauulb_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Zai kuwa nuna maku babban bene gyararre. Sai ku yi mana shiri a can.” ");
INSERT INTO hauulb_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Da shigar almajiran cikin birnin, sai kome ya kasance yadda ya fada, su kuwa suka yi shirye shiryen idin ketarewar. ");
INSERT INTO hauulb_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Da maraice ta yi, sai ya tare da sha biyun. ");
INSERT INTO hauulb_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Yayin da suke zazzaune a teburin suna cin abincin, sai Yesu ya ce “Hakika ina gaya maku wani da ke ci tare da ni a nan zai bashe ni”. ");
INSERT INTO hauulb_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Sai suka damu suka tambaye shi daya bayan daya suna cewa “Hakika bani bane ko?” ");
INSERT INTO hauulb_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesu ya amsa masu da cewa “Daya daga cikin sha biyu ne, wanda ke sa hannu tare da ni yanzu cikin tasar”. ");
INSERT INTO hauulb_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Dan Mutum zai tafi ne yadda nassi ya umarta game da shi amma kaiton wanda zai bashe shi! “zai, fiye masa, dama ba a haife shi ba”. ");
INSERT INTO hauulb_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Lokacin da suke cin abincin, Yesu ya dauki gurasa ya sa albarka, ya gutsuttsura ta, sai ya basu yana cewa “Wannan jikinana ne”. ");
INSERT INTO hauulb_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ya kuma dauki koko, yayi godiya, ya basu, su kuwa suka sha daga kokon. ");
INSERT INTO hauulb_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ya ce “Wannan jinina ne na alkawari da an zubar ga yawancin mutane”. ");
INSERT INTO hauulb_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Hakika, bazan kara sha daga wannan ruwan inabi ba sai a ranar da zan sha sabo cikin mulkin Allah.” ");
INSERT INTO hauulb_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Bayan sun raira wakar yabo ga Allah, sai suka tafi wurin dutsen zaitun. ");
INSERT INTO hauulb_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesu ya ce masu dukkan ku zaku yi tuntube harma ku fadi saboda ni gama rubuce take cewa “Zan buge makiyayin, tumakin kuwa za su watse; ");
INSERT INTO hauulb_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Amma bayan tashina, zai yi gaba in riga ku zuwa Galili. ");
INSERT INTO hauulb_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Bitrus ya ce masa “ko dukkansu sun fadi, faufau banda ni”. ");
INSERT INTO hauulb_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesu yace masa “Hakika ina gaya maka, cikin wannan dare kafin carar zakara ta biyu zaka yi musun sani na sau uku”. ");
INSERT INTO hauulb_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Amma Bitrus ya sake cewa “Koda za'a kasheni tare da kai ba zan yi musun sanin ka ba”. Dukkan su kuwa suka yi wannan Alkawari. ");
INSERT INTO hauulb_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Suka isa wani wuri da ake kira Getsamani, sai Yesu ya ce wa almajiransa “Ku dakata anan domin zan je inyi addu'a”. ");
INSERT INTO hauulb_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Sai ya dauki Bitrus, da Yakubu, da Yahaya. Ya fara jin wahala mutuka tare da damuwa kwarai. ");
INSERT INTO hauulb_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Sai ya ce masu “Raina na shan wahala harma kamar in mutu. Ku dakata a nan, ku zauna a fadake”. ");
INSERT INTO hauulb_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Da Yesu yayi gaba kadan, sai ya fadi kasa yayi addu'a yana cewa idan mai yiwuwa ne “A dauke masa wannan sa'a daga gare shi. ");
INSERT INTO hauulb_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ya ce “Ya Abba Uba, kome mai yuwane gare ka, ka dauke mini kokon wahalan nan, duk da haka ba nufina ba sai dai naka”. ");
INSERT INTO hauulb_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Da komowarsa ya same su suna barci, sai ya ce wa Bitrus, Siman barci kake? Ashe, ba za ka iya zama a fadake ko da sa'a daya ba? ");
INSERT INTO hauulb_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ku zauna a fadake, kuyi addu'a kada ku fada cikin jaraba. Lalle ruhu na da niyya amma jiki raunana ne. ");
INSERT INTO hauulb_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Sai ya sake komawa, yayi addu'a, yana maimaita kalmominsa na farko. ");
INSERT INTO hauulb_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Har wa yau kuma ya sake dawowa, ya same su suna barci don barci ya cika masu idanu kwarai, sun kuwa kasa ce masa kome. ");
INSERT INTO hauulb_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ya sake komowa karo na uku yace masu “har yanzu barci kuke yi kuna hutawa? Ya isa haka! Lokaci yayi, an bada Dan Mutum ga masu zunubi”. ");
INSERT INTO hauulb_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ku tashi mutafi kun ga, ga mai bashe ni nan ya kusato.” ");
INSERT INTO hauulb_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Nan da nan, kafin ya rufe baki sai ga Yahuza, daya daga cikin sha biyun da taron jama'a rike da takkuba da kulake. Manyan firistoci da malaman attaura da shugabanni suka turo su. ");
INSERT INTO hauulb_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Mai bashe shi din nan ya riga ya kulla da su cewa “Wanda zan yi wa sumba shine mutumin, ku kama shi ku tafi da shi a tsare. ");
INSERT INTO hauulb_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Da isowarsa kuwa, sai ya zo wurin Yesu ya ce “Ya malam!”. Sai ya sumbace shi. ");
INSERT INTO hauulb_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Su kuwa suka kama shi, suka tafi da shi. ");
INSERT INTO hauulb_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Amma daya daga cikin na tsaye ya zaro takobinsa ya kai wa bawan babban firist sara, ya yanke masa kunne. ");
INSERT INTO hauulb_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Sai Yesu ya ce “kun fito kamar masu kama yan fashi da takkuba da kulake, domin ku kama ni? ");
INSERT INTO hauulb_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Lokacin da nake koyarwa a Haikali, kowace rana da ku, baku kama ni ba. Amma anyi haka ne domin a cika abinda Nassi ya fada.” ");
INSERT INTO hauulb_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Daga nan duk wadanda suke tare da Yesu suka yashe shi, suka tsere. ");
INSERT INTO hauulb_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Wani saurayi, daga shi sai mayafi ya bi shi, suka kai masa cafka. ");
INSERT INTO hauulb_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Shi kuwa ya bar masu mayafin ya gudu tsirara. ");
INSERT INTO hauulb_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Daga nan suka tafi da Yesu wurin babban firist. a can suka tara dattawa duk da manyan firistoci da shugabanni da marubuta, suka taru a wurinsa. ");
INSERT INTO hauulb_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Bitrus kuwa ya bi shi daga nesa har cikin gidan babban firist. Ya zauna tare da dogaran Haikalin, yana jin dumin wuta. ");
INSERT INTO hauulb_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Sai, manyan firistoci da duk 'yan majalisa Yahudawa suka nemi shaidar da za a tabbatar a kan Yesu, don su samu su kashe shi. Amma basu samu ba. ");
INSERT INTO hauulb_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Da yawa kuma suka yi masa shaidar Zur (Karya), amma bakin su bai zama daya ba. ");
INSERT INTO hauulb_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Sai wadansu kuma suka taso suka yi masa shaidar zur (karya) suka ce. ");
INSERT INTO hauulb_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Mun ji ya ce, wai zai rushe haikalin nan da mutane suka gina, ya sake gina wani cikin kwana uku, ba kuwa ginin mutum ba”. ");
INSERT INTO hauulb_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Duk da haka, sai shaidar tasu bata zo daya ba. ");
INSERT INTO hauulb_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Sai babban firist ya mike a tsakanin su, ya tambayi Yesu yace “Ba ka da wata amsa game da shaidar da mutanen nan suke yi a kanka? ");
INSERT INTO hauulb_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Amma yayi shiru abinsa, bai ce kome ba. Sai babban firist din ya sake tambayarsa “To, ashe kai ne Allmasihu Dan Madaukaki? ");
INSERT INTO hauulb_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesu ya ce “Nine. Za ku kuwa ga Dan Mutum zaune dama ga mai iko, yana kuma zuwa cikin gajimare”. ");
INSERT INTO hauulb_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Sai babban firist ya kyakketa tufafinsa yace “Wacce shaida kuma zamu nema? ");
INSERT INTO hauulb_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Kun dai ji sabon da yayi! Me kuka gani? Duk suka yanke masa hukunci akan ya cancanci kisa. ");
INSERT INTO hauulb_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Wadansu ma suka fara tottofa masa yau, suka daure masa idanu, suka bubbuge shi suna cewa “Yi annabci” Dogaran kuma suka yi ta marinsa. ");
INSERT INTO hauulb_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Bitrus kuwa na kasa a filin gida, sai wata baranyar babban firist ta zo. ");
INSERT INTO hauulb_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Da ta ga Bitrus na jin dumi, ta yi masa kallon gaske ta ce “Kaima ai tare kake da banazaren nan Yesu”. ");
INSERT INTO hauulb_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Amma ya musa ya ce “Ni ban ma san abinda kike fada ba balle in fahimta”. Sai ya fito zaure. Sai zakara yayi cara. ");
INSERT INTO hauulb_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Sai baranyar ta ganshi, ta sake ce wa wadanda ke tsaitsaye a wurin, “Wannan ma daya daga cikinsu ne”. ");
INSERT INTO hauulb_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Amma ya sake musawa, jim kadan sai na tsaitsayen suka ce wa Bitrus “Lalle kai ma dayansu ne don ba Galile ne kai”. ");
INSERT INTO hauulb_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Sai ya fara la'anta kansa yana ta rantsuwa yana ce wa “Ban ma san mutumin nan da kuke fada ba”. ");
INSERT INTO hauulb_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Nan da nan sai zakara ya yi cara ta biyu, Bitrus kuwa ya tuna da maganar Yesu a gare shi cewa “Kafin zakara ya yi cara ta biyu, za ka yi musun sani na sau uku”. Da ya tuno haka, sai ya fashe da kuka. ");
INSERT INTO hauulb_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Da sassafe, sai manyan firistoci suka hadu da dattawa da manyan malamai, da majalisa suka daure Yesu, suka sa shi gaba suka mika shi ga Bilatus. ");
INSERT INTO hauulb_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Bilatus ya tambaye shi, kaine sarkin Yahudawa? ya amsa ya ce “haka ka ce” ");
INSERT INTO hauulb_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Sai manyan firistochi suka kawo zargi iri iri a kan Yesu. ");
INSERT INTO hauulb_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Bilatus ya sake tambayarsa, ba ka da abin cewa? ka lura da yawan zargi da ake yi maka. ");
INSERT INTO hauulb_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Amma Yesu baya sake yi masa magana ba. wannan ya ba shi mamaki. ");
INSERT INTO hauulb_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","A lokacin idi, Bilatus ya kan sakar masu da dan bursuna wanda jama'a suka bukaci a saka, ");
INSERT INTO hauulb_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","A cikin gidan yari, in da aka tsare wadansu yan tawaye, da masu kisan kai, akwai wani mai kisan kai, ana ce da shi Barrabbas. ");
INSERT INTO hauulb_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Sai Jama'a suka zo wurin Bilatus ya yi masu kamar yadda ya saba yi. ");
INSERT INTO hauulb_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Bilatus ya amsa masu ya ce, kuna so in sakar maku sarkin Yahudawa? ");
INSERT INTO hauulb_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Yayi wannan domin ya sani cewa Firistoci sun bada shi ne domin suna kishin sa, ");
INSERT INTO hauulb_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Sai Firistochi suka zuga jama'a, sai suka yi kuwwa suna cewa, a sakar masu Barrabbas amaimakon Yesu. ");
INSERT INTO hauulb_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Bilatus ya sake yi masu tambaya “Yaya zan yi da Sarkin Yahudawa?” ");
INSERT INTO hauulb_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","sai suka amsa da kuwwa” a “giciye shi!” ");
INSERT INTO hauulb_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Bilatus ya ce masu menene laifinsa sai suka kara ihu, “a giciye shi.” ");
INSERT INTO hauulb_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Bilatus don yana son ya farantawa jama'a zuciya sai ya sakar masu da Barrabbas sai ya yi wa Yesu bulala, sannan ya mika shi a giciye shi. ");
INSERT INTO hauulb_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Sojoji suka kai shi cikin kagara, suka tara rundunan soja, ");
INSERT INTO hauulb_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Suka sa masa tufafin shulaiya suka nada masa rawanin kaya, ");
INSERT INTO hauulb_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Suna masa kirari na ba'a suna cewa, “A gaida sarkin Yahudawa!” ");
INSERT INTO hauulb_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Sai suka buge shi a kai da kulki suka kuma tofa masa yau a fuska, suka kuma durkusa suna yi masa sujadar ba'a. ");
INSERT INTO hauulb_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Bayan sun gama yi masa ba'a sai suka cire masa tufafin shunnaiya, sai suka maida masa tasa tufafinsa, sai suka fitar dashi don su giciye shi. ");
INSERT INTO hauulb_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Suna cikin tafiya sai suka hadu da wani, mai suna Saminu Bakairawani (wato uban Alizanda da Rufus); suka tillasta shi ya dauki gijiyen Yesu. ");
INSERT INTO hauulb_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Sojojin suka kawo Yesu wurin da ake kira Golgota (wato kokon kai) ");
INSERT INTO hauulb_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Suka bashi ruwan inabi hade da mur, amma ya ki ya sha. ");
INSERT INTO hauulb_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Sai suka giciye shi, suka kuma raba tufafinsa suka kuma jefa kuri'a domin kowanne soja ya sami rabonsa. ");
INSERT INTO hauulb_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","A sa'a ta uku aka giciye shi. ");
INSERT INTO hauulb_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Sai aka rubuta alamar zargi da take cewa “Ga Sarkin Yahudawa” ");
INSERT INTO hauulb_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Suka kuma giciye shi tare da wadansu yan fashi guda biyu. ");
INSERT INTO hauulb_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Daya a hannun damansa daya a hannun hagunsa. Domin a cika abinda nassi ya fada. ");
INSERT INTO hauulb_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","suke wucewa suna zaginsa suna kada kai suna cewa, “Aha! kai da zaka rushe haikali ka kuma gina shi cikin kwana uku, ");
INSERT INTO hauulb_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","ka ceci kanka mana, ka sauka daga giciye!” ");
INSERT INTO hauulb_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Haka ma manyan firistoci da malamai, suka yi masa ba'a suna cewa “Ya ceci wadansu amma bai iya ceci kansa ba” ");
INSERT INTO hauulb_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Bari Almasihu Sarkin Yahudawa ya sauka daga giciye. Domin mu gaskata shi, sai wadanda aka giciye shi tare dasu, suma suka yi masa ba'a. ");
INSERT INTO hauulb_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","sa'a ta shida zuwa sa'a ta tara, duhu ya rufe ko'ina, ");
INSERT INTO hauulb_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","A sa'a ta tara, Yesu ya tada murya da karfi ya ce Eloi, Eloi lamathsabathani?” Ma'ana Ya Allahna Ya Allahna, me ya sa ka yashe ni?” ");
INSERT INTO hauulb_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Wasu daga cikin na tsaye, da suka ji shi, sai suka ce, “Duba, yana kiran Iliya.” ");
INSERT INTO hauulb_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Sai wani ya hanzarta, ya dauki soso ya tsoma a ruwan inabi mai tsami, ya soka agora ya mika masa don yasha. Mutumin yace bari mu gani ko Iliya zai zo ya saukar da shi. ");
INSERT INTO hauulb_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Sai Yesu yayi kuka da babban murya da karfi sannan ya rasu. ");
INSERT INTO hauulb_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Sai labulen haikalin ya rabu kashi biyu daga sama har kasa. ");
INSERT INTO hauulb_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Sa'adda da jarumin sojan da ke tsaye yana fuskantar Yesu ya ga yadda ya mutum, Sai ya ce “hakika, wannan mutum Dan Allah ne.” ");
INSERT INTO hauulb_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Akwai kuma mata wadanda ke dubawa daga nesa. Daga cikinsu akwai Maryamu Magadala, da Maryamu( Uwar Yakubu da Yusufu) da Salome. ");
INSERT INTO hauulb_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Wadannan matan sune suka bishi sa'adda da yake Galilee suna yi masa hidima. Da wadansu mata da yawa suka zo Urushalima tare da shi. ");
INSERT INTO hauulb_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Da maraice an shiga shirye shirye domin kashe gari asabbaci ce. ");
INSERT INTO hauulb_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Sai Yusufu daga garin Arimatiya ya zo, mutumin kirki, mai girma kuma dan majalisar dattawa, mai sauraron mulkin Allah, da gaba gadi ya tafi wurin Bilatus ya bukaci a bashi jikin Yesu. ");
INSERT INTO hauulb_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Bilatus ya yi mamakin mutuwar Yesu cikin lokaci kadan, sai ya kira jarumin ya tabbattar koYesu ya mutu. ");
INSERT INTO hauulb_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Bayan ya tabbattar daga wurin jarumin soja cewa Yesu ya mutu, sai ya bada jikin ga Yusufu. ");
INSERT INTO hauulb_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yusufu ya sayo likafani. ya saukar da shi daga giciye, ya kawo likafanin nan ya lulube jikin Yesu dashi. Ya kai shi kabarin da aka sassaka da dutse, wadda ya shirya shi domin kansa. Ya kawo dutse ya rufe bakin kabarin da shi. ");
INSERT INTO hauulb_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maryamu Magadaliya da Maryamu Uwar Yusufu sun ga wurin da aka yi jana'izar Yesu. ");
INSERT INTO hauulb_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Bayan ranar assabaci, Maryamu Magadaliya da Maryamu uwar Yakubu da Salomi, suka sayo man shafawa mai kamshi domin shafe jikin Yesu saboda jana'iza. ");
INSERT INTO hauulb_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Da safiyar ranar farko ta mako sai suka tafi kabarin a dai dai fitowar rana. ");
INSERT INTO hauulb_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Suna magana a tsakaninsu suna cewa, wanene zai gangarar da dutsen da aka rufe bakin kabarin da shi?” ");
INSERT INTO hauulb_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Da suka daga ido, sai suka ga an riga an gangarar da dutsen, domin yana da girma. ");
INSERT INTO hauulb_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Da suka shiga cikin kabarin sai ga wani saurayi saye da farar tufa, yana zaune a hannun dama, suna mamaki. ");
INSERT INTO hauulb_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Sai ya ce masu, “Kada ku ji tsoro. Kuna neman Yesu banazare, wanda aka giciye. Ya tashi! Baya nan. Ku duba wurin da aka kwantar dashi. ");
INSERT INTO hauulb_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Sai ku je, ku gaya wa almajiransa da Bitrus cewa ya rigaya ya yi gabanku zuwa Galili. A can zaku ganshi, kamar yadda ya fada maku.” ");
INSERT INTO hauulb_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Suka fita daga cikin kabarin da gudu suna rawar jiki da mamaki, ba su cewa kowa komai ba domin suna jin tsoro. ");
INSERT INTO hauulb_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Da safiyar ranar farko ta mako ya fara bayyana kansa ga Maryamu Magadaliya wadda ya kori aljannu guda bakwai daga cikinta. ");
INSERT INTO hauulb_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Sai ta tafi ta shaida wadanda suke tare da shi suke makoki da kuka. ");
INSERT INTO hauulb_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Sai suka ji cewa ya tashi kuma ta ganshi, amma basu gaskata ba. ");
INSERT INTO hauulb_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Bayan wadannan al'amura ya bayana kansa ta wata siffa ga mutum biyu sa'ilin da suke tafiya akan hanya. ");
INSERT INTO hauulb_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Sai suka tafi suka gaya wa sauran almajiransa, duk da haka basu gaskata ba. ");
INSERT INTO hauulb_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Bayan wani lokaci, Yesu ya bayyana kansa ga almajiransa su goma sha daya, ya tsauta masu saboda rashin gaskatawa da taurin zuciya, bayansun ji daga wadanda suka ganshi bayan ya tashi daga matattu. ");
INSERT INTO hauulb_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Sai ya umarcesu cewa “Ku tafi cikin duniya ku yi bishara ga dukan halitta. ");
INSERT INTO hauulb_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Wanda ya ba da gaskiya aka kuma yi masa baftisma, zaya sami ceto, wanda baya bada gaskiya ba za ya hallaka. ");
INSERT INTO hauulb_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Wadannan alamu za su kasance da wadanda suka gaskata; a cikin sunana, za su fidda aljannu, za su yi magana da sabbin harsuna. ");
INSERT INTO hauulb_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Za su dauki macizai da hannayesu, idan sun sha guba ba ta cutar dasu ba, za su dibiya hannayensu ga marasa lafiya, za su sami warkaswa.” ");
INSERT INTO hauulb_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Bayan Ubangiji ya gama magana da su, sai aka dauke shi zuwa sama in da zai zauna a hannun dama na Allah. ");
INSERT INTO hauulb_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Almajiransa kuma suka tafi ko'ina suna sheilar bishara. Ubangiji kuma yayi aiki tare da su, yana tabbatar da kalma ta wurin ayukan al'ajiba tare da su. ");
INSERT INTO hauulb_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Mutane da dayawa sun yi kokarin rubutu akan abubuwan da suka cika a tsakaninmu, ");
INSERT INTO hauulb_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","kamar yanda suka danka mana su, wadanda tun daga farko suka zama shaidu da idanunsu kuma manzanni ne na sakon. ");
INSERT INTO hauulb_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Sabili da haka, ni ma, bayan da na yi bincike da kyau akan yanayin wadannan abubuwa tun da farko na ga ya yi kyau in rubuta wadannan abubuwa bi da bi ya mafi girmaTiyofilas. ");
INSERT INTO hauulb_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ya zama haka domin ka san gaskiyar abin da aka koya maka ne. ");
INSERT INTO hauulb_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","A cikin zamanin Hirudus, Sarkin Yahudiya, akwai wani firist mai suna Zakariya, daga yankin Abija. Matarsa daga cikin yaya mata na zuriyar Haruna ce, kuma sunan ta Alisabatu ne. ");
INSERT INTO hauulb_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Dukan su biyu masu adalci ne a gaban Allah; marasa zargi a tafiyarsu cikin dukan dokoki da farilan Ubangiji. ");
INSERT INTO hauulb_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Amma ba su da da, domin Alisabatu ba ta haihuwa, kuma a wannan lokacin dukansu sun tsufa kwarai. ");
INSERT INTO hauulb_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ya zama kuma a lokacin da Zakariya yana gaban Allah, yana yin hidimar sa ta firist bisa ga tsari da ka'idar aikinsa. ");
INSERT INTO hauulb_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Bisa ga al'adar zaben firist da zai yi hidima, an zabe shi ta wurin kuri'a ya shiga cikin haikalin Ubangiji domin ya kona turare. ");
INSERT INTO hauulb_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Dukan taron Jama'a suna addu'a a waje a sa'adda ake kona turaren. ");
INSERT INTO hauulb_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","A lokacin, mala'ikan Ubangiji ya bayana a gare shi yana tsaye a gefen daman bagadi na turaren. ");
INSERT INTO hauulb_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zakariya ya firgita sa'adda ya gan shi; tsoro ya kama shi. ");
INSERT INTO hauulb_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Amma mala'ikan ya ce masa, “Kada ka ji tsoro, Zakariya, domin an ji addu'ar ka. Matar ka Alisabatu za ta haifa maka da. Za ka kira sunansa Yahaya. ");
INSERT INTO hauulb_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Za ka yi murna da farin ciki, kuma da yawa za su yi murna da haifuwarsa. ");
INSERT INTO hauulb_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Domin zai zama mai girma a gaban Ubangiji. Ba zai sha ruwan inabi ba ko wani abu mai sa maye, kuma zai cika da Ruhu Mai Tsarki tun daga cikin cikin mahaifiyarsa. ");
INSERT INTO hauulb_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Kuma mutanen Isra'ila da yawa za su juya zuwa ga Ubangiji Allahnsu. ");
INSERT INTO hauulb_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Zai yi tafiya a gaban Unbangiji a cikin ruhu da ikon Iliya. Zai yi haka domin ya juya zuciyar Ubanni zuwa ga 'ya'yansu, domin marasa biyayya su yi tafiya a cikin tafarkin adalai. Don ya shirya wa Ubangiji mutanen da aka shirya dominsa.” ");
INSERT INTO hauulb_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakariya ya ce wa mala'ikan, “Ta yaya zan san wannan? Ga shi na tsufa kuma matata tana da shekaru da yawa.” ");
INSERT INTO hauulb_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Mala'ikan ya amsa ya ce masa, “Nine Jibra'ilu, wanda ke tsaye a gaban Allah. An aiko ni in gaya maka wannan labari mai dadi. ");
INSERT INTO hauulb_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Kuma duba, za ka zama bebe, ba za ka iya magana ba, sai ran da wadannan abubuwa suka cika. Ya zama haka domin ba ka gaskanta da kalmomina ba, wadanda za su cika a daidai lokacin.” ");
INSERT INTO hauulb_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Sa'adda mutane suke jiran Zakariya. Sun yi mamaki yadda ya dauki lokaci sosai a cikin haikali. ");
INSERT INTO hauulb_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Amma da ya fita, bai iya yin magana da su ba. Sun gane da cewa ya ga wahayi lokacin da yake cikin haikali. Ya ci gaba da yi masu alamu, ba ya magana. ");
INSERT INTO hauulb_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ya zama bayan da kwanakin hidimarsa suka kare, ya tafi gidansa. ");
INSERT INTO hauulb_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Bayan kwanakin nan, matarsa Alisabatu ta samu juna biyu. Ta boye kanta har na watani biyar. Ta ce, ");
INSERT INTO hauulb_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Wannan shi ne abin da Allah ya yi mani da ya dube ni domin ya dauke kunyata a gaban jama'a.” ");
INSERT INTO hauulb_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","A cikin watan ta na shidda, an aiki Mala'ika Jibra'ilu daga wurin Allah zuwa wani birni a Galili mai suna Nazarat, ");
INSERT INTO hauulb_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","zuwa ga wata budurwa wanda aka ba da ita ga wani mutum mai suna Yusufu. Shi dan zuriyar Dauda ne, kuma ana kiran budurwar Maryamu. ");
INSERT INTO hauulb_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ya zo wurin ta ya ce, “A gaishe ki, ke da ki ke da tagomashi sosai! Ubangiji yana tare da ke. ");
INSERT INTO hauulb_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Amma ta damu kwarai da wadannan kalmomi sai ta yi tunani ko wacce irin gaisuwa ce wannan. ");
INSERT INTO hauulb_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Mala'ikan ya ce mata, “Kada ki ji tsoro, Maryamu, domin kin samu tagomashi a wurin Allah. ");
INSERT INTO hauulb_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Duba, za ki sami juna biyu, za ki haifi da. Za ki kira sunansa 'Yesu'. ");
INSERT INTO hauulb_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Zai zama mai girma, kuma za a ce da shi Dan Allah Madaukaki. Ubangiji Allah zai ba shi kursiyin ubansa Dauda. ");
INSERT INTO hauulb_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Zai yi mulkin dukkan gidan Yakubu har abada, kuma mulkinsa ba shi da iyaka.” ");
INSERT INTO hauulb_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maryamu ta ce wa mala'ikan, “Yaya wannan zai faru, tun da shike ni ban san namiji ba?” ");
INSERT INTO hauulb_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Mala'ikan ya amsa ya ce mata, “Ruhu Mai-tsarki zai sauko a kan ki, kuma ikon Madaukaki zai lullube ki. Sabili da haka, za a kira mai tsarkin da za ki haifa Dan Allah. ");
INSERT INTO hauulb_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ki kuma duba, ga 'yar'uwarki Alisabatu ta samu juna biyu a tsufanta. Watannin ta shida kenan, ita wadda aka kira ta bakarariya. ");
INSERT INTO hauulb_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Gama babu abin da ba shi yiwuwa a wurin Allah.” ");
INSERT INTO hauulb_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maryamu ta ce, “To, ni baiwar Ubangiji ce. Bari ya faru da ni bisa ga sakonka.” Sai mala'ikan ya bar ta. ");
INSERT INTO hauulb_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Sai Maryamu ta tashi da sauri a cikin kwanakin nan, zuwa kasa mai duwatsu, zuwa wani birni a Yahudiya. ");
INSERT INTO hauulb_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ta shiga gidan Zakariya ta kuma gai da Alisabatu. ");
INSERT INTO hauulb_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ya zama sa'adda Alisabatu ta ji gaisuwar Maryamu, sai dan da ke cikinta ya yi tsalle, an cika Alisabatu kuma da Ruhu Mai Tsarki. ");
INSERT INTO hauulb_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ta daga murya, ta ce, “Mai albarka kike a cikin mata, kuma mai albarka ne dan cikinki. ");
INSERT INTO hauulb_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Kuma don me ya faru da ni da uwar Ubangijina ta ziyarce ni? ");
INSERT INTO hauulb_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Kuma duba, da na ji karar gaisuwan ki sai dan ciki na ya yi tsalle domin murna. ");
INSERT INTO hauulb_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Kuma mai albarka ce wadda ta gaskanta cewa abubuwan da aka alkawarta mata daga wurin Ubangiji za su cika. ");
INSERT INTO hauulb_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maryamu ta ce, “Zuciyata ta yabi Ubangiji, ");
INSERT INTO hauulb_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","kuma ruhu na ya yi murna da Allah mai ceto na.” ");
INSERT INTO hauulb_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Domin ya dubi kaskancin baiwarsa. Duba, daga yanzu, dukkan tsararraki za su ce da ni mai albarka. ");
INSERT INTO hauulb_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Domin shi madaukaki ya yi mani manyan abubuwa, kuma sunansa Mai Tsarki ne. ");
INSERT INTO hauulb_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Jinkansa ya tabbata daga tsara zuwa tsara wadanda suke girmama shi. ");
INSERT INTO hauulb_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ya nuna karfinsa da hannuwansa; ya warwatsa ma su girman kai game da tunanin zuciyarsu. ");
INSERT INTO hauulb_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ya nakasar da magada daga kursiyoyinsu, ya kuma fifita nakasassu. ");
INSERT INTO hauulb_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ya ciyar da mayunwata da abubuwa masu kyau, amma ya aiki attajirai wofi. ");
INSERT INTO hauulb_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ya ba da taimako ga bawan sa Isra'ila, domin ya tuna ya kuma nuna jinkai ");
INSERT INTO hauulb_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","(kamar yanda ya fada wa ubaninmu) ga Ibrahim da zuriyarsa har abada.” ");
INSERT INTO hauulb_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maryamu ta zauna da Alisabatu tsawon watanni uku sai ta koma gidanta. ");
INSERT INTO hauulb_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Da lokaci yayi da Alisabatu za ta haifi danta, ta kuma haifi da namiji. ");
INSERT INTO hauulb_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Makwabtanta da 'yan'uwanta sun ji cewa Ubangiji ya ribanbanya jinkansa akanta, sai suka yi murna tare da ita ");
INSERT INTO hauulb_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ya zama akan rana ta takwas, sun zo domin a yi wa yaron kaciya. Da sun kira sunansa “Zakariya” kamar sunan ubansa, ");
INSERT INTO hauulb_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","amma mahaifiyarsa ta amsa ta ce, “A'a, za a kira shi Yahaya.” ");
INSERT INTO hauulb_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Suka ce mata, “Babu wani a cikin danginku wanda ake kira da wannan suna.” ");
INSERT INTO hauulb_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Sun nuna alama ga ubansa bisa ga yanda ya ke so a rada masa suna. ");
INSERT INTO hauulb_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ubansa ya nemi a ba shi allon rubutu, sai ya rubuta, “Sunansa Yahaya.” Dukan su suka yi mamaki kwarai da wannan. ");
INSERT INTO hauulb_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Nan take, sai bakinsa ya bude kuma harshensa ya saki. Ya yi magana ya kuma yabi Allah. ");
INSERT INTO hauulb_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Tsoro ya kama dukan wadanda suke zama kewaye da su. Sai labarin ya bazu cikin dukan kasar duwatsu ta Yahudiya. ");
INSERT INTO hauulb_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Kuma dukan wadanda suka ji su, sun ajiye su a cikin zuciyarsu, suna cewa, “To me wannan yaro zai zama ne?” Domin hannun Ubangiji yana nan tare da shi. ");
INSERT INTO hauulb_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ruhu Mai-tsarki ya cika mahaifinsa Zakariya sai ya yi anabci cewa, ");
INSERT INTO hauulb_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Yabo ga Ubangiji, Allah na Isra'ila domin ya zo ya taimaki mutanen sa kuma ya yi aikin ceto domin su.” ");
INSERT INTO hauulb_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ya ta da kahon ceto dominmu daga gidan bawansa Dauda, daga zuriyar Dauda bawansa, ");
INSERT INTO hauulb_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","kamar yadda ya fada ta bakin annabawansa tsarkaka tun zamanin zamanai. ");
INSERT INTO hauulb_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Zai kawo mana ceto daga magabtan mu da kuma daga hannun makiyanmu. ");
INSERT INTO hauulb_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Zai yi haka domin ya nuna jinkai ga ubaninmu ya kuma tuna da alkawarinsa mai tsarki, ");
INSERT INTO hauulb_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","rantsuwar da ya fada wa ubanmu Ibrahim. ");
INSERT INTO hauulb_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Ya rantse zai yardar mana, bayan da an kubutar da mu daga hannun makiyanmu, mu bauta masa ba tare da tsoro ba, ");
INSERT INTO hauulb_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","a cikin tsarki da adalci a gabansa dukan kwanakin ranmu. ");
INSERT INTO hauulb_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","I, kai kuma, yaro, za a kira ka annabi na Madaukaki, domin za ka tafi gaban fuskar Ubangiji ka shirya hanyoyinsa, ka shirya mutane domin zuwansa, ");
INSERT INTO hauulb_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","domin ba mutanensa ilimin ceto ta wurin gafarar zunubansu. ");
INSERT INTO hauulb_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Wannan zai faru ne domin girman jinkan Allahnmu, sabili da hasken rana daga bisa za ya zo wurinmu, ");
INSERT INTO hauulb_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","domin haskakawa akan wadanda ke zaune a cikin duhu da kuma cikin inuwar mutuwa. Zai yi hakan nan domin ya kiyaye kafafunmu zuwa hanyar salama. ");
INSERT INTO hauulb_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Yaron ya yi girma ya kuma zama kakkarfa a cikin ruhu, yana kuma cikin jeji sai ranar bayyanuwarsa ga Isra'ila. ");
INSERT INTO hauulb_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ananan cikin kwanakin, sai Kaisar Augustas ya yi shela ya umarta a kidaya dukan mutane da ke zaune a cikin duniya. ");
INSERT INTO hauulb_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Wannan itace kidaya ta farko da aka yi lokacin da Kiriniyus yake mulkin Suriya. ");
INSERT INTO hauulb_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Sabili da haka, kowa ya koma garinsa domin a yi masa rijista domin kidayan. ");
INSERT INTO hauulb_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yusufu kuma ya tashi ya bar birnin Nazarat zuwa garin Baitalami da ke Yahudiya, wanda ake kuma kira birnin Dauda, domin shi daga zuriyar iyalin Dauda ne. ");
INSERT INTO hauulb_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ya je can ya yi rijista tare da Maryamu, wadda yake tashi tana kuma da juna biyu. ");
INSERT INTO hauulb_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ya zama sa'adda suke can, lokaci ya yi da za ta haifi danta. ");
INSERT INTO hauulb_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ta haifi da, dan farinta kuwa, ta nade shi da kyau da 'yan tsummoki. Ta sa shi cikin wani kwami na dabbobi, gama babu daki dominsu a masaukin. ");
INSERT INTO hauulb_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","A cikin wannan yankin, akwai makiyaya wadanda suke zama a sarari suna tsaron garken tumakinsu da dare. ");
INSERT INTO hauulb_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Nan da nan, sai mala'ikan Ubangiji ya bayyana gare su, daukakar Ubangiji kuma ta haskaka kewaye da su, sai suka figita kwarai. ");
INSERT INTO hauulb_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Sai mala'ikan ya ce masu, “Kada ku ji tsoro, domin na kawo maku labari mai dadi da zai kawo murna da yawa ga dukan mutane. ");
INSERT INTO hauulb_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Yau an haifi maku mai ceto a cikin birnin Dauda! Shine Almasihu Ubangiji! ");
INSERT INTO hauulb_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Wannan itace alama da za a ba ku. Za ku ga dan jariri nade cikin 'yan tsummoki kwance cikin kwamin dabbobi.” ");
INSERT INTO hauulb_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Nan take, sai ga babban taro daga sama tare da mala'ikan suna yabon Allah, suna cewa, ");
INSERT INTO hauulb_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Daukaka ga Allah daga bisa, bari salama ta kasance a duniya tsakanin mutanen da ya ke jin dadinsu.” ");
INSERT INTO hauulb_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ya zama sa'adda mala'iku suka bar su zuwa cikin sama, sai makiyayan su ka ce wa junansu, “Bari mu je Baitalami mu ga wannan abin da ya faru, wanda Ubangiji ya nuna mana.” ");
INSERT INTO hauulb_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Su ka yi hamzari suka tafi can sun iske Maryamu da Yusufu, suka ga jaririn kuwa kwance a cikin kwamin dabbobin. ");
INSERT INTO hauulb_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Bayan da sun ga wannan, suka gaya wa mutane abinda aka gaya masu game da wannan yaro. ");
INSERT INTO hauulb_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Dukan wadanda su ka ji, su ka yi mamaki kwarai game da abin da makiyayan su ka gaya masu. ");
INSERT INTO hauulb_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Amma ita Maryamu ta ci gaba da tunani akan wadanan abubuwa da ta ji, tana tunani mai zurfi a cikin zuciyarta. ");
INSERT INTO hauulb_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Makiyayan suka koma suna ta daukaka da yabon Allah domin dukan abubuwan da suka ji, suka kuma gani, dadai da yadda aka gaya masu. ");
INSERT INTO hauulb_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Da ya kai kwana takwas, lokacin da za a yi wa jaririn kaciya, sai aka rada masa suna Yesu, sunan da mala'ikan ya bashi kamin a yi cikinsa. ");
INSERT INTO hauulb_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Da kwanakin tsarkakewar su ya wuce bisa ga shari'ar Musa, Yusufu da Maryamu suka kawo shi cikin haikali a Urushalima dominsu mika shi ga Ubangiji. ");
INSERT INTO hauulb_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Kamar yadda aka rubuta a dokokin Ubangiji, “Za a kira duk da na fari kebabbe ga Ubangiji.” ");
INSERT INTO hauulb_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Suka kuma zo su mika hadaya bisa ga yadda aka fada a shari'ar Ubangiji, “Kurciyoyi biyu ko 'yan tantabaru biyu.” ");
INSERT INTO hauulb_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ga shi akwai wani mutum a Ushalima mai suna Siman. Wannan mutum adali ne kuma mai ibada. Yana jiran mai ta'aziyar Isra'ila, kuma Ruhu Mai-sarki na bisansa. ");
INSERT INTO hauulb_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","An kuma bayyana masa ta wurin Ruhu Mai-tsarki cewa ba zai mutu ba sai ya ga Kristi na Ubangiji. ");
INSERT INTO hauulb_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Wata rana Siman ya zo cikin haikali ta wurin jagorar Ruhu Mai-tsarki. Da iyayen suka kawo yaron ciki, wato Yesu, domin su cika sharudan da shari'ar ke bukata, ");
INSERT INTO hauulb_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","sai Siman ya karbe shi cikin hanuwansa, ya yabi Allah ya ce, ");
INSERT INTO hauulb_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Yanzu bari bawanka ya tafi da salama, Ubangiji, bisa ga kalmarka. ");
INSERT INTO hauulb_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Domin idanuna sun ga cetonka, ");
INSERT INTO hauulb_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","wanda ka shirya a gaban dukan mutane: ");
INSERT INTO hauulb_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Haske ne na wahayi ga al'ummai, kuma daukakar mutanenka Isra'ila.” ");
INSERT INTO hauulb_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Mahaifin yaron da Mahaifiyarsa, sun yi mamaki kwarai domin abubuwan da aka fada akansa. ");
INSERT INTO hauulb_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Sai Siman ya albarkace su ya ce wa uwatasa Maryamu, “Ki ji da kyau, wannan yaro zai zama sanadiyar faduwa da tashin mutane dayawa a Isra'ila, kuma alama wadda ake kushen ta. ");
INSERT INTO hauulb_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Kuma takobi zai tsaga zuciyar ki yadda tunanin mutane za ya bayyana.” ");
INSERT INTO hauulb_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Wata annabiya mai suna Annatu ta na nan wurin. Ita diyar Fanuyila ce daga kabilar Ashiru. Ta riga ta manyanta a shekaru sosai. Ta kasance da maigidanta shekaru bakwai bayan auren ta, ");
INSERT INTO hauulb_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","sannan ta yi zama gwambranci na shekaru tamanin da hudu. Ba ta taba barin haikali ba, tana ci gaba da yi wa Ubangiji sujada, dare da rana. ");
INSERT INTO hauulb_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","A dadai lokacin nan, ta hau zuwa wurinsu ta fara yi wa Allah godiya. Ta gaya wa dukan wadanda ke jiran fansar Urushalima. ");
INSERT INTO hauulb_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Da su ka gama komai da aka bukace su suyi bisa ga tafarkin shari'ar Ubangiji, sai suka koma Galili, zuwa birninsu, Nazarat. ");
INSERT INTO hauulb_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Yaron kuma ya yi girma ya zama da karfi, yana karuwa da hikima, alherin Ubangiji kuma yana kansa. ");
INSERT INTO hauulb_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Iyayensa sukan tafi Urushalima kowacce shekara domin idin ketarewa. ");
INSERT INTO hauulb_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Da yana shekara goma sha biyu, suka sake haurawa daidai lokacin idin a al'adance. ");
INSERT INTO hauulb_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Bayan da sun cika dukan kwanakin idin, sun fara dawowa gida. Amma dan yaron Yesu ya jinkirta ya zauna a Urushalima, kuma iyayensa basu sani ba. ");
INSERT INTO hauulb_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Suna tsammani yana tare da sauran mutane da suke tafiya tare, sai suka yi tafiya na kwana daya. Suka fara neman sa a cikin danginsu da abokansu. ");
INSERT INTO hauulb_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Da ba su gan shi ba, sai suka koma Urushalima suna cigiyar sa a can. ");
INSERT INTO hauulb_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ya zama bayan kwanaki uku, su ka same shi a cikin haikali, yana zama a tsakiyar malamai, yana sauraron su yana kuma yi masu tambayoyi. ");
INSERT INTO hauulb_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Dukan wadanda suka ji shi suna ta mamakin fahimtar sa da amsoshin sa. ");
INSERT INTO hauulb_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Da suka gan shi, suka yi mamaki kwarai. Mahaifiyarsa ta ce masa, “Da na, don me ka yi mana haka? Ka ji, mahaifinka da ni muna ta neman ka rai a bace.” ");
INSERT INTO hauulb_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ya ce masu, “Don me kuke nema na? Ba ku sani cewa dole in kasance a gidan Ubana ba?” ");
INSERT INTO hauulb_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Amma ba su gane abin da yake nufi da kalmomin nan ba. ");
INSERT INTO hauulb_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Sa'annan ya koma gida tare da su zuwa Nazarat yana kuma masu biyayya. Mahaifiayarsa kuma ta ajiye dukan wadannan abubuwa a zuciyarta tana yin tunani akansu. ");
INSERT INTO hauulb_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Amma Yesu ya ci gaba da hikima da girma, ya kuma karu da tagomashi wurin Allah da mutane. ");
INSERT INTO hauulb_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","A cikin shekara ta goma sha biyar da Tibariyus Kaisar ke mulki, Bilatus Babunti kuma ke jagorar Yahudiya, Hirudus yana sarautar Galili, dan'uwansa Filibus yana sarautar yankin Ituriya da Tirakonitis, Lisaniyas kuma na sarautar yankin Abiliya, ");
INSERT INTO hauulb_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","kuma zamanin da Hanana da Kayafa suke manyan firistoci, maganar Allah ta zo wurin Yahaya dan Zakariya, a cikin jeji. ");
INSERT INTO hauulb_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ya yi tafiya cikin dukan yankuna da ke kewaye da Kogin Urdun, yana wa'azin baftismar tuba domin gafarar zunubai. ");
INSERT INTO hauulb_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Kamar yadda aka rubuta a cikin littafin annabi Ishaya, “Ga muryan wani yana kira a cikin jeji, 'Shirya hanyar Ubangiji, ka daidaita tafarkunsa! ");
INSERT INTO hauulb_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Za a cika kowani kwari, za a fasa kowani dutse a kuma baje kowani tudu, za a mike karkatattun hanyoyi, za a cike hanyoyi masu gargada, ");
INSERT INTO hauulb_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","kuma dukan mutane za su ga ceton Allah.” ");
INSERT INTO hauulb_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Sai Yahaya ya kara fada wa taron jama'ar da ke zuwa domin ya yi masu baftisma, “Ku 'ya'yan macizai masu dafi, wa ya gargadeku ku guje wa fushin nan mai zuwa? ");
INSERT INTO hauulb_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ku ba da 'ya'ya da sun cancanci tuba, kada ku kuma fara cewa a cikinku, 'Muna da Ibrahim a matsayin Ubanmu', domin ina gaya maku, Allah yana iya ta da wa Ibrahim 'ya'ya daga cikin wadannan duwatsu. ");
INSERT INTO hauulb_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Yanzu kuwa, an rigaya an sa gatari a gindin itatuwa. Sabili da haka, duk itacen da bai ba da 'ya'ya masu kyau ba za a sare shi kasa a kuma jefa shi cikin wuta.” ");
INSERT INTO hauulb_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Sai mutanen da ke cikin taron jama'ar suka tambaye shi cewa, “To me za mu yi?” ");
INSERT INTO hauulb_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ya amsa ya ce masu, “Idan wani yana da taguwa biyu, sai ya ba wanda bashi da ita daya, kuma wanda yake da abinci ya yi haka nan.” ");
INSERT INTO hauulb_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Masu karban haraji ma suka zo domin a yi masu baftisma, suka ce masa, “Malam, me za mu yi?” ");
INSERT INTO hauulb_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ya ce masu, “Kada ku karba kudi fiye da yadda aka umarce ku.” ");
INSERT INTO hauulb_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Wasu sojoji ma suka tambaye shi cewa, “To, mu fa? Yaya za mu yi?” Ya ce masu, “Kada ku kwace wa wani kudi, kada ku kuma yi wa wani zargin karya. Ku dogara ga albashinku.” ");
INSERT INTO hauulb_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ana nan da mutane ke sauraron zuwan Almasihu, kowa yana ta tunani a zuciyar sa game da Yahaya, ko shi ne Almasihu. ");
INSERT INTO hauulb_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yahaya ya amsa ya ce masu duka, “Game da ni dai, na yi maku baftisma da ruwa, amma akwai wani tafiye wanda ya fi ni iko, ban ma isa in kwance maballin takalmansa ba. Shi zai yi maku baftisma da Ruhu Mai Tsarki da kuma wuta. ");
INSERT INTO hauulb_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Kwaryar shikarsa na hanun sa domin ya share masussukarsa da kyau ya kuma tara alkama a cikin rumbunsa. Amma zai kona buntun da wuta marar mutuwa. ");
INSERT INTO hauulb_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Da gargadi masu yawa ya yi wa mutanen wa'azin bishara. ");
INSERT INTO hauulb_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Yahaya kuma ya tsauta wa sarki Hirudus domin ya auri matar dan'uwansa, Hiruduya, da kuma sauran abubuwan da Hirudus ya yi. ");
INSERT INTO hauulb_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Amma Hirudus ya kara yin wani mugun abu. Ya sa an kulle Yahaya a cikin kurkuku. ");
INSERT INTO hauulb_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ana nan, lokacin da ake yiwa dukan mutane baftisma, aka yiwa Yesu mai baftisma. Lokacin da yake yin addu'a, sai sama ta bude, ");
INSERT INTO hauulb_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","kuma Ruhu Mai Tsarki ya sauko masa a kamanin kurciya, sai wata murya ta fito daga sama, “Kai ne kaunataccen Da na. Ina jin dadin ka.” ");
INSERT INTO hauulb_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ana nan Yesu da kansa, da ya fara, yana kimanin shekara talatin. Shi dan (kamar yadda ake tsammani) Yusufu ne, dan Heli, ");
INSERT INTO hauulb_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","dan Matat, dan Lawi, dan Malki, dan Yanna, dan Yusufu, ");
INSERT INTO hauulb_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","dan Matatiya, dan Amos, dan Nahum, dan Hasli, dan Najjaya, ");
INSERT INTO hauulb_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","dan Ma'ata, dan Matatiya, dan Shimeya, dan Yuseka, dan Yoda, ");
INSERT INTO hauulb_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","dan Yowana, dan Resa, dan Zarubabila, dan Shiyaltiyel, dan Niri, ");
INSERT INTO hauulb_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","dan Malki, dan Addi, dan Kosama, dan Almadama, dan Er, ");
INSERT INTO hauulb_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","dan Yosi, dan Aliyeza, dan Yorima, dan Matat, dan Lawi, ");
INSERT INTO hauulb_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","dan Saminu, dan Yahuda, dan Yusufu, dan Yonana, dan Aliyakima, ");
INSERT INTO hauulb_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","dan Malaya, dan Mainana, dan Matata, dan Natan, dan Dauda, ");
INSERT INTO hauulb_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","dan Yesse, dan Obida, dan Bu'aza, dan Salmon, dan Nashon, ");
INSERT INTO hauulb_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","dan Amminadab, dan Adimi, dan Arama, dan Hezruna, dan Feresa, dan Yahuda, ");
INSERT INTO hauulb_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","dan Yakubu, dan Ishaku, dan Ibrahim, dan Tera, dan Nahor, ");
INSERT INTO hauulb_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","dan Serug, dan Reyu, dan Feleg, dan Abiru, dan Shela, ");
INSERT INTO hauulb_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","dan Kainana, dan Arfakshada, dan Shem, dan Nuhu, dan Lamek, ");
INSERT INTO hauulb_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","dan Metusela, dan Anuhu, dan Yaret, dan Mahalel, dan Kainana, ");
INSERT INTO hauulb_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","dan Enosh, dan Shitu, dan Adamu, dan Allah. ");
INSERT INTO hauulb_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Sai Yesu, cike da Ruhu Mai Tsarki, ya dawo daga kogin Urdun, sai Ruhu Mai Tsarki ya bishe shi zuwa cikin jeji ");
INSERT INTO hauulb_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","kwana arba'in, shaidan kuma ya jarabce shi. A kwanakin nan, bai ci abinci ba, kuma yunwa ta kama shi bayan karshen lokacin. ");
INSERT INTO hauulb_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Shaidan ya ce masa, “Idan kai Dan Allah ne, ka umarci wannan dutse ya zama gurasa.” ");
INSERT INTO hauulb_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yesu ya amsa masa, “A rubuce yake, 'Ba da gurasa kadai Mutum zai rayu ba.'” ");
INSERT INTO hauulb_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Sai shaidan ya kai shi zuwa wani tudu mai tsawo, ya kuma nuna masa dukan mulkokin duniyan nan a dan lokaci. ");
INSERT INTO hauulb_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Shaidan ya ce masa, “Zan ba ka iko ka yi mulkin dukan wadannan, da dukan daukakarsu. Zan yi haka domin an ba ni su duka in yi mulkinsu, kuma ina da yanci in ba dukan wanda na ga dama. ");
INSERT INTO hauulb_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Saboda da haka, idan ka rusuna ka yi mani sujada, dukansu za su zama naka.” ");
INSERT INTO hauulb_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Amma Yesu ya amsa ya ce masa, “A rubuce yake, 'Dole ne Ubangiji Allahnka za ka yi wa sujada, shi kadai kuma za ka bauta wa.” ");
INSERT INTO hauulb_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Sai shaidan ya kai Yesu Urushalima, ya tsayadda shi a bisan kololuwar haikali, kuma ya ce masa, “Idan kai Dan Allah ne, ka jefas da kanka kasa daga nan. ");
INSERT INTO hauulb_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Domin a rubuce yake, 'Zai ba mala'ikunsa umarni su kiyaye ka, su kuma tsare ka,' ");
INSERT INTO hauulb_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","kuma, 'Za su daga ka sama a hannunsu, don kada ka yi tuntube a kan dutse.” ");
INSERT INTO hauulb_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yesu ya amsa masa cewa, “An fadi, 'Kada ka gwada Ubangiji Allahnka.'” ");
INSERT INTO hauulb_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Da shaidan ya gama yi wa Yesu gwaji, sai ya kyale shi sai wani lokaci. ");
INSERT INTO hauulb_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Sai Yesu ya koma Galili cike da ikon Ruhu, kuma labarinsa ya bazu cikin dukan wuraren dake wannan yankin. ");
INSERT INTO hauulb_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ya yi ta koyarwa a cikin majami'unsu, sai kowa na ta yabon sa. ");
INSERT INTO hauulb_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Wata rana ya zo Nazarat, birnin da aka rene shi. Kamar yadda ya saba yi, ya shiga cikin majami'a a nan ranar Asabaci, ya kuma tashi tsaye domin ya karanta Nassi. ");
INSERT INTO hauulb_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","An mika masa littafin anabi Ishaya, ya bude littafin ya kuma ga inda an rubuta, ");
INSERT INTO hauulb_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Ruhun Ubangiji yana kai na, domin ya shafe ni in yi wa'azin Bishara ga matalauta. Ya aike ni in yi shelar yanci ga daurarru, da kuma budewar idanu ga makafi, in 'yantar da wadanda su ke cikin kunci, ");
INSERT INTO hauulb_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","in kuma yi shelar shekarar tagomashi na Ubangiji.” ");
INSERT INTO hauulb_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Sai ya rufe littafin, ya mai da shi ga ma'aikacin majami'ar, sai ya zauna. Dukan wadanda suke cikin majami'ar suka zura Idanuwansu a kansa. ");
INSERT INTO hauulb_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Sai ya fara masu magana, “Yau wannan Nassi ya cika a kunuwanku.” ");
INSERT INTO hauulb_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Dukan wadanda ke wurin sun shaida abin da ya fadi kuma dukansu sun yi ta mamakin kalmomin alheri da suke fitowa daga bakinsa. Suna cewa, “Wannan ai dan Yusufu ne kawai, ko ba haka ba?” ");
INSERT INTO hauulb_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yesu ya ce masu, “Lallai za ku fada mani wannan karin magana, 'Likita, ka warkar da kanka. Duk abin da mun ji wai ka yi a Kafarnahum, ka yi shi a nan garinka ma.'” ");
INSERT INTO hauulb_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ya sake cewa, “Hakika na fada maku, annabi baya samun karbuwa a garinsa. ");
INSERT INTO hauulb_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Amma na gaya maku gaskiya akwai gwauraye da yawa cikin Isra'ila a zamanin Iliya, lokacin da an rufe sammai shekaru uku da rabi babu ruwa, lokacin da anyi gagarumar yunwa a duk fadin kasar. ");
INSERT INTO hauulb_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Amma ba a aiki Iliya zuwa wurin waninsu ba, sai wurin gwauruwa da ke a Zarifat can kusa da Sidon. ");
INSERT INTO hauulb_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Akwai kutare da yawa kuma a Isa'ila a zamanin anabi Elisha, amma babu wanda aka warkar sai dai Na'aman mutumin Suriya kadai. ");
INSERT INTO hauulb_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Dukan mutanen da ke cikin majami'a suka fusata kwarai sa'adda suka ji wadannan zantattuka. ");
INSERT INTO hauulb_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Suka tashi suka tura shi zuwa wajen birnin, suka kai shi bakin dutsen da aka gina garinsu a kai dominsu jefar da shi kasa. ");
INSERT INTO hauulb_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Amma ya ratsa tsakaninsu ya yi gabansa. ");
INSERT INTO hauulb_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Sannan ya gangara zuwa Kafarnahum, wani birni a Galili. Wata Asabaci yana koya wa mutane a cikin majami'a. ");
INSERT INTO hauulb_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Sun yi mamaki kwarai da koyarwan sa, domin maganarsa na da iko. ");
INSERT INTO hauulb_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","A wannan lokacin akwai wani mutum a cikin majami'a mai kazamin ruhu, sai ya yi kara da babbar murya, ");
INSERT INTO hauulb_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ina ruwan mu da kai, Yesu Banazarat? Ka zo domin ka hallaka mu ne? Na san ko kai wanene! Kai ne Mai Tsarki na Allah!” ");
INSERT INTO hauulb_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yesu ya tsauta wa aljanin yana cewa, “Yi shiru ka fita daga cikinsa!” Da aljanin ya jefar da mutumin kasa a tsakiyarsu, ya fita daga cikinsa ba tare da yi masa rauni ba. ");
INSERT INTO hauulb_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Dukan mutanen suka yi mamaki, kuma suna ta zancen wannan abu a tsakaninsu. Sun ce, “Wanda irin maganganu kenan? Ya umarce kazaman ruhohin da karfi da iko kuma sun fita.” ");
INSERT INTO hauulb_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Saboda da haka, an fara yada labarinsa zuwa dukan kewayen yankin. ");
INSERT INTO hauulb_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Sai Yesu ya bar majami'ar ya shiga gidan Siman. A wannan lokacin, surukar Siman tana fama da zazzabi mai zafi, sai suka roke shi dominta. ");
INSERT INTO hauulb_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Sai ya tsaya a kanta, ya tsautawa zazzabin, kuma ya rabu da ita. Nan take, ta tashi ta fara yi masu hidima. ");
INSERT INTO hauulb_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Da faduwar rana, mutane suka kawo wa Yesu dukan wadanda suke ciwo da cuttuttuka dabam dabam. Ya dora masu hannuwansa ya warkar da su. ");
INSERT INTO hauulb_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Aljanu kuma sun fita daga wadasunsu da dama, suna kuka cewa, “Kai ne Dan Allah!” Yesu ya tsauta wa aljannun ya kuma hana su magana, domin sun sani cewa shine Almasihu. ");
INSERT INTO hauulb_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Da safiya ta yi, ya kebe kansa zuwa wani wurin da babu kowa. Jama'a da dama suna neman sa suka zo inda yake. Sun yi kokari su hana shi barin su. ");
INSERT INTO hauulb_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Amma ya ce masu, “Dole in yi bisharar Allah a wasu birane da dama, domin dalilin da aka aiko ni nan kenan.” ");
INSERT INTO hauulb_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Sai ya ci gaba da wa'azi cikin majami'u dukan fadin Yahudiya. ");
INSERT INTO hauulb_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ya zama sa'adda mutane sun taru a wurin Yesu suna sauraron maganar Allah, yana kuma yana tsaye a bakin tabkin Janisarata. ");
INSERT INTO hauulb_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ya ga jiragen ruwa biyu tsaye a bakin tabkin. Masu kamun kifin kuwa sun fita daga cikin jiragen suna wanke tarunsu. ");
INSERT INTO hauulb_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yesu ya shiga daya daga cikn jiragen wanda shike na Bitrus ne, sai ya umarce shi ya dan zakuda da jirgin daga bakin tabkin kadan zuwa cikin ruwa. Sai ya zauna ya kuma koya wa mutane daga cikin jirgin. ");
INSERT INTO hauulb_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Da ya gama magana, ya ce wa Siman, “Zakuda jirgin zuwa wuri mai zurfi sa'annan ka zuba tarunka domin kamu.” ");
INSERT INTO hauulb_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Siman ya amsa ya ce, “Ubangiji, mun yi aiki dukan dare bamu kama komai ba, amma bisa ga maganarka, zan jefa tarun.” ");
INSERT INTO hauulb_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Da sun yi haka, suka kama kifaye da yawan gaske, har tarunsu suna yagewa. ");
INSERT INTO hauulb_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Sai suka roki abokan aikinsu da ke a dayan jirgin su zo su taimake su. Suka zo sun cika jiragen biyu da kifaye, har suka fara nutsewa. ");
INSERT INTO hauulb_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Amma Siman Bitrus, da ya ga haka, ya russuna a gaban Yesu, yana cewa, “Ka rabu da ni Ubangiji, gama ni mai zunubi ne.” ");
INSERT INTO hauulb_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Domin ya yi mamaki, da dukan wadanda suke tare da shi, sabili da yawan kifaye da suka kama. ");
INSERT INTO hauulb_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Wannan ya hada da Yakubu da Yahaya 'ya'yan Zabadi abokan aikin Siman. Sai Yesu ya ce wa Siman, “Kada ka ji tsoro, domin daga yanzu, za ka kama mutane.” ");
INSERT INTO hauulb_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Da sun kawo jiragensu waje kan kasa, suka bar komai suka kuma bi shi. ");
INSERT INTO hauulb_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Sa'adda yana daya daga cikin biranen, wani mutum dauke da kuturta yana nan wurin. Da ya ga Yesu, ya fadi bisa fuskarsa kasa yana rokansa, yana cewa, “Ubangji, idan ka yarda, za ka iya tsarkake ni.” ");
INSERT INTO hauulb_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesu ya mika hanunsa ya taba shi, yana cewa, “Na yarda. Ka tsarkaka.” Sai nan da nan, kuturtar ta rabu da shi. ");
INSERT INTO hauulb_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ya umarce shi kada ya gaya wa kowa, amma ya ce ma sa, “Tafi ka nuna kanka ga firist sa'annan ka mika hadaya domin tsarkakewarka, kamar yadda Musa ya umarta, a matsayin shaida a garesu.” ");
INSERT INTO hauulb_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Amma labarinsa ya bazu nesa, taron mutane da yawa kuma suka zo wurinsa domin su ji shi, su kuma samu warkarwa daga cututtukansu. ");
INSERT INTO hauulb_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Amma ya kan janye zuwa wuraren da babu kowa ya yi addu'a. ");
INSERT INTO hauulb_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ya zama daya a cikin kwanakin da yake koyarwa, akwai Farisawa da malaman attaura da ke zaune a wurin wandanda suka zo daga kauyukan da suke kewaye da Galili da Yahudiya da kuma birnin Urushalima. Ikon Ubangiji yana tare da shi domin warkarwa. ");
INSERT INTO hauulb_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","A lokacin nan, wasu mutane suka zo dauke da wani mutum shanyayye a kan tabarma, suka kuma nemi yadda za su shigar da shi ciki, su kwantar da shi a gaban Yesu. ");
INSERT INTO hauulb_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ba su iya samun hanyar da za su shigar da shi ba saboda taron, sai suka hau saman gidan, suka saukar da shi daga rufin, a kan tabarman sa, zuwa tsakiyar mutanen, dai dai a gaban Yesu. ");
INSERT INTO hauulb_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Da ya ga bangaskiyarsu, Yesu ya ce, “Maigida, an gafarta zunubanka.” ");
INSERT INTO hauulb_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Marubuta da Farisawa suka fara sukar wannan, suna cewa, “Wanene wannan da ke sabo? Wa zai iya gafarta zunubi, idan ba Allah kadai ba?” ");
INSERT INTO hauulb_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Amma da Yesu ya fahimci abin da suke tunani, sai ya amsa ya ce masu, “Don me kuke sukar wannan a zuciyarku? ");
INSERT INTO hauulb_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Wanne ne ya fi sauki a ce, 'An yafe zunubanka' ko kuwa a ce, 'Tashi ka yi tafiya?” ");
INSERT INTO hauulb_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Amma domin ku sani cewa Dan Mutum yana da yancin gafarta zunubai a duniya, na ce maka, 'Tashi, dauki tabarmanka, ka tafi gidanka.'” ");
INSERT INTO hauulb_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Nan take, ya tashi a gabansu ya dauki tabarma da yake kwance; sai ya koma gidansa, yana daukaka Allah. ");
INSERT INTO hauulb_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Kowa yana ta mamaki kuma suka daukaka Allah. Suna cike da tsoro, suna cewa, “Yau mun ga abubuwan al'ajibi.” ");
INSERT INTO hauulb_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Bayan wadannan abubuwa sun faru, Yesu ya fito daga can sai ya ga wani mai karban haraji mai suna Lawi yana zama a wurin karban haraji. Ya ce masa, “Ka biyo ni.” ");
INSERT INTO hauulb_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Sai Lawi ya bar komai, ya tashi, ya bi shi. ");
INSERT INTO hauulb_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Lawi kuma ya shirya gagarumar liyafa a gidansa, kuma akwai masu karban haraji da yawa a nan, da wasu mutane da ke zama a gaban teburin liyafar suna cin abinci tare da su. ");
INSERT INTO hauulb_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Amma Farisawa da Marubuta suka fara korafi ga almajiransa, suna cewa, “Don menene kuna ci da sha tare da masu karban haraji da mutane masu zunubi?” ");
INSERT INTO hauulb_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesu ya amsa masu, “Masu lafiya basu bukatar likita, wadanda ke marasa lafiya kadai ke bukatar likita. ");
INSERT INTO hauulb_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ban zo domin kiran masu adalci ba, amma na zo ne domin kiran masu zunubi zuwa ga tuba.” ");
INSERT INTO hauulb_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Sun ce masa, “Almajiran Yahaya sukan yi azumi da addu'a, kuma almajiran Farisawa ma sukan yi haka. Amma almajiranka suna ci suna sha?” ");
INSERT INTO hauulb_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesu ya ce masu, “Akwai wanda zai sa abokan ango su yi azumi, a lokacin da shi ango yana tare da su? ");
INSERT INTO hauulb_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Amma kwanaki na zuwa wadanda za a dauke ango daga wurinsu, a kwanakin za su yi azumi.” ");
INSERT INTO hauulb_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Sai Yesu ya sake fada masu wani misali. “Babu wanda zai yage kyalle daga sabuwar tufa, ya kuma yi amfani da ita ya dinka tsohuwar tufa. Idan ya yi hakannan, zai yage sabuwar tufar, kuma kyallen daga sabuwar tufar ba zai dace da kyallen tsohuwar tufar ba. ");
INSERT INTO hauulb_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Kuma, babu mutum da zai sa sabon ruwan inabi a cikin tsofafin salkuna. Idan ya yi haka, sabon ruwan inabin zai fasa salkunan, kuma ruwan inabin din zai zube, salkunan kuma za su lallace. ");
INSERT INTO hauulb_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Amma dole ne a sa sabon ruwan inabi a sabobin salkuna. ");
INSERT INTO hauulb_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Babu wanda zai yi marmarin sabon ruwan inabi bayan da ya sha tsohon, gama zai ce, “Tsohon ya fi sabon.” ");
INSERT INTO hauulb_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ana nan wata Asabaci Yesu yana ratsawa cikin gonar hatsi, almajiransa kuma na karyar zangarkun hatsin, suna murtsukawa a hanayensu suna ci. ");
INSERT INTO hauulb_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Amma wasu daga cikin Farisawa suka ce, “Saboda me kuke yin abin da bai halatta a yi a ranar Asabaci ba?” ");
INSERT INTO hauulb_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesu ya amsa masu, ya ce, “Ba ku karanta abin da Dauda ya yi a lokacin da yake jin yunwa ba, shi da mutanen da ke tare da shi? ");
INSERT INTO hauulb_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ya je cikin gidan Allah, ya dauki gurasar alfarwa ya kuma ci daga ciki, ya kuma ba mazajen da ke tare da shi su ci, ko da shike ya halarta ga Firistoci ne kadai su ci.” ");
INSERT INTO hauulb_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Sai ya ce masu, “Dan Mutum shi ne Ubangijin asabaci.” ");
INSERT INTO hauulb_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ya kasance a wata ranar Asabaci ya shiga cikin majami'a ya kuma koya wa mutane a can. Wani mutum na can wurin wanda hannun damansa ya shanye. ");
INSERT INTO hauulb_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Marubuta da Farisawa na kallonsa su ga ko zai warkar da wani a ranar Asabaci, domin su samu dalilin zarginsa da yin abin da bai cancanta ba. ");
INSERT INTO hauulb_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Amma ya san abin da suke tunani, sai ya ce wa mai shanyeyen hannun, “Tashi, ka tsaya a nan tsakiyar jama'a.” Sai mutumin ya tashi ya tsaya a nan. ");
INSERT INTO hauulb_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Yesu ya ce masu, “Ina tambayar ku, ya halatta a ranar Asabaci a yi nagarta ko mugunta, a ceci rai ko a hallaka shi? ");
INSERT INTO hauulb_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Sai ya dube su duka, ya kuma ce wa mutumin, “Mika hannunka.” Ya yi haka, sai hannunsa ya koma lafiyayye. ");
INSERT INTO hauulb_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Amma suka fusata kwarai, suka yi shawara da junansu game da abin da za su yi da Yesu. ");
INSERT INTO hauulb_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ya zama a kwanakin nan, ya hawo bisan dutse domin ya yi addu'a. Ya ci gaba dukan dare yana addua'a ga Allah. ");
INSERT INTO hauulb_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Da safiya ta yi, ya kira almajiransa zuwa wurinsa, ya kuma zabi goma sha biyu daga cikinsu, wadanda ya kira su “Manzanni.” ");
INSERT INTO hauulb_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Sunayen Manzannin sune Siman (wanda ya kuma kira Bitrus) da dan'uwansa, Andrawus, Yakubu, Yahaya, Filibus, Bartalamawus, ");
INSERT INTO hauulb_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matta, Toma, Yakubu dan Halfa, Siman, wanda ake kira Zaloti, Yahuda dan Yakubu, ");
INSERT INTO hauulb_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","da Yahuda dan Iskariyoti, wanda ya zama maci amana. ");
INSERT INTO hauulb_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Sai Yesu ya gangaro daga dutsen tare da su, suka kuma tsaya a sarari. Almajiransa da yawa na nan a wurin, tare da mutane da yawa daga Yahudiya da Urushalima, da kuma bakin tekun Taya da Sidon. ");
INSERT INTO hauulb_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Sun zo domin su ji shi, da kuma su sami warkarwa daga dukan cututukansu. Mutane waddan da ke fama da kazaman ruhohi ma sun sami warkarwa. ");
INSERT INTO hauulb_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Dukan taron jama'ar suna kokarin su taba shi domin ikon warkarwa yana fitowa daga wurinsa, ya kuma warkar da su duka. ");
INSERT INTO hauulb_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Sai ya dubi almajiransa ya ce, “Masu albarka ne ku matalauta, gama Mulkin Allah naku ne. ");
INSERT INTO hauulb_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Masu albarka ne ku masu yunwa yanzu, domin za a kosar da ku. Masu albarka ne ku masu kuka a yanzu, domin za ku yi dariya. ");
INSERT INTO hauulb_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Masu albarka ne ku idan mutane sun ki ku, suka nuna maku wariya suna mai da sunayen ku na mugunta, domin Dan Mutum. ");
INSERT INTO hauulb_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Za ku yi farin ciki a ranan nan kuna tsalle domin murna, domin hakika za ku samu lada mai girma a sama, domin haka kakannin-kakannin su suka yi wa annabawa. ");
INSERT INTO hauulb_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Amma kaitonku mawadata! Domin kun rigaya kun samu ta'aziyar ku. ");
INSERT INTO hauulb_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Kaitonku kosassu a yanzu! Domin za ku ji yunwa nan gaba. Kaitonku masu dariya yanzu! Domin za ku yi makoki kuna kuka nan gaba. ");
INSERT INTO hauulb_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Kaiton ku idan kowadanne mutane suna yabon ku! Domin haka kakannin-kakanninsu suka yi wa annabawan karya. ");
INSERT INTO hauulb_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Amma ina ce maku ku masu saurare na, ku kaunaci magabtanku, ku kuma aikata nagarta ga wadanda suke kinku. ");
INSERT INTO hauulb_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ku albarkaci masu zaginku, ku kuma yi addu'a ga wadanda suke wulakanta ku. ");
INSERT INTO hauulb_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Wanda ya mare ku a wannan kunci, ku juya masa dayan. Idan wani ya dauki mayafinka, kada ka hana masa taguwarka. ");
INSERT INTO hauulb_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ku bayar ga duk wanda ya roke ku. Idan wani ya dauki wani abu da ke naku, kada ku bidi ya mayar da shi. ");
INSERT INTO hauulb_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Duk abin da kake so mutane su yi maka, ka yi masu hakan nan. ");
INSERT INTO hauulb_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Idan ka kaunaci masoyan ka ne kadai, me wannan zai amfane ka? Ko masu zunubi ma na kaunar masoyan su. ");
INSERT INTO hauulb_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Idan kuna nuna alheri ga wadan da ke maku alheri kadai, menene ladan ku a nan? Ko masu zunubi ma na yin hakan nan. ");
INSERT INTO hauulb_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Idan kun ba da rancen abubuwa ga mutanen da kuna sa zuciya zasu mayar maku ne kadai, menene ribar ku a nan? Ko masu zunubi suna ba masu zunubi rance, suna kuma sa zuciya a mayar masu dadai gwargwado. ");
INSERT INTO hauulb_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Amma ku kaunaci magabtan ku, ku kuma nuna masu alheri. Ku basu rance, kada ku sa zuciya a maido maku, kuma sakamakon ku zai zama da girma. Za ku zama yayan Mafifici, domin shi da kansa yana nuna jinkai ga marasa godiya da miyagun mutane. ");
INSERT INTO hauulb_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ku zama masu jinkai, domin Ubanku mai jinkai ne. ");
INSERT INTO hauulb_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Kada ku shari'anta, kuma ba za a shari'anta ku ba. Kada ku kayar, ku ma ba za a kashe ku ba. Ku yafe wa wasu, kuma za a yafe maku. ");
INSERT INTO hauulb_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ku bayar ga wasu, ku ma za a ba ku da yawa. Magwaji dankararre, girgizajje har ya cika yana zuba, za su zuba har cinyarku. Domin duk ma'aunin da ku ka yi amfani da shi, da shi za a auna maku. ");
INSERT INTO hauulb_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Sai ya sake basu wani misali, “Makaho yana iya yi wa makaho jagora? Idan ya yi haka, dukansu biyu za su fada cikin rami, ko ba haka ba? ");
INSERT INTO hauulb_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Almajiri baya fin Malaminsa, amma duk wanda ya samu horo sosai zai zama kamar malaminsa. ");
INSERT INTO hauulb_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Don me kake duba dan hakin da ke a idon dan'uwanka, amma ba ka iya ganin gungumen da ke a idonka ba? ");
INSERT INTO hauulb_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Don me za ka ce wa dan'uwanka, 'Dan'uwa, bari in cire dan hakin da ke a idonka', bayan kai da kanka ba ka iya ganin gungumen da ke a idonka ba? Kai munafuki! Ka fara cire gungumen da ke a idonka, sa'annan za ka gani da kyau yadda zaka cire hakin da ke a idon dan'uwanka. ");
INSERT INTO hauulb_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Domin babu itace mai kyau da ke haifar rubabbun 'ya'ya, ko rubabben itace da zai haifi kyawawan 'ya'ya. ");
INSERT INTO hauulb_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Domin ana iya sanin ko wani itace ta wurin 'ya'yan da yake bayarwa. Domin mutane basu kan tsinki 'ya'yan baure a jikin kaya, ko kuwa su dibi inabi daga jikin sarkakkiya. ");
INSERT INTO hauulb_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Mutumin kirki, daga wadatar zuciyarsa ya kan ba da yaya masu kyau, kuma mugu daga cikin muguwar ajiyar zuciyarsa yake aikata mugunta. Domin daga cikar zuciyarsa ne bakinsa yakan yi magana. ");
INSERT INTO hauulb_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Don me kuke ce da ni, 'Ubangiji, Ubangiji', amma ba ku yin biyayya da magana ta? ");
INSERT INTO hauulb_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Duk wanda ya zo wurina ya ji kalmomina ya kuma yi biyayya da su, zan gaya maku yadda yake. ");
INSERT INTO hauulb_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Yana kama da mutum da ke gina gida, wanda ya haka da zurfi zuwa cikin kasa ya kuma gina harshashin gidan sa a kan dutse. Da rigyawa ta zo, sai ruwa ya buga gidan, amma bai iya girgiza shi ba, domin an gina shi da kyau. ");
INSERT INTO hauulb_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Amma duk mutumin da ya ji kalmomina ya kuma ki biyayya da su, yana kamar mutum wanda ya gina gidansa a kan kasa, babu harshashi. Amma da ambaliyan ruwa ta buga gidan, nan take ya rushe, ragargajewar gidan kuma da girma take. ");
INSERT INTO hauulb_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Bayan da Yesu ya gama fadar dukan abubuwan da zai fadi a jin kunnen dukan mutanen, sai ya shiga Kafarnahum. ");
INSERT INTO hauulb_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Bawan wani jarumi, wanda yake kauna, ba shi da lafiya har ma ya kusa mutuwa. ");
INSERT INTO hauulb_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Amma da ya ji labarin Yesu, jarumin ya aiki wadansu dattawan Yahudawa, ya ce a roki Yesu ya zo ya ceci bawansa daga mutuwa. ");
INSERT INTO hauulb_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Sa'adda su ka zo kusa da Yesu, su ka roke shi da gaske, cewa, “Wannan ya isa ka yi masa haka, ");
INSERT INTO hauulb_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","saboda shi mai kaunar kasar mu ne, kuma shi ne ya gina mana majami'a. ");
INSERT INTO hauulb_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Sai Yesu ya tafi tare da su. Amma sa'adda ya zo kusa da gidan mutumin, jarumin ya aiki abokansa su ka ce da shi, “Ubangiji kada ka damu domin ni ban isa ka zo gida na ba. ");
INSERT INTO hauulb_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Shi ya sa na ga ban isa in zo wurinka ba, ka yi magana kadai bawa na kuwa zai warke. ");
INSERT INTO hauulb_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Gama ni ma mutum ne mai iko, ina da sojoji karkashina. Ina iya cewa da wannan, 'Ka je' sai ya tafi, in kuma ce da wani 'ka zo' sai ya zo, in kuma ce da bawa na, 'Yi kaza,' sai ya yi.” ");
INSERT INTO hauulb_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Sa'adda Yesu ya ji haka, ya yi mamakin mutumin, ya juya wajen taron da su ke biye da shi, ya ce, “Na gaya maku, ko a cikin Isra'ila ban sami wani mai bangaskiya irin wannan ba” ");
INSERT INTO hauulb_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Daga nan wadanda a ka aika, suka dawo gida suka tarar da bawan cikin koshin lafiya. ");
INSERT INTO hauulb_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Wani lokaci bayan wannan, ya zama Yesu yana tafiya wani gari da ake kira Na'im. Almajiransa su na tare da shi, da kuma taron mutane masu yawa. ");
INSERT INTO hauulb_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Sa'adda ya kusa da kofar garin, sai ga wani matacce ana dauke da shi. Kuma shi kadai ne da a wurin mahaifiyarsa. Ita kuwa gwauruwa ce, mutane da dama daga cikin gari suna tare da ita. ");
INSERT INTO hauulb_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Da ganin ta, sai Ubangiji ya cika da tausayi a game da ita ya ce da ita, “Kada ki yi kuka.” ");
INSERT INTO hauulb_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Sai ya zo ya taba makarar, sai masu dauke da shi su ka tsaya. Ya ce 'Saurayi na ce ma ka ka tashi.” ");
INSERT INTO hauulb_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Sai mataccen ya tashi ya fara yin magana. Sai Yesu ya ba mahaifiyar danta. ");
INSERT INTO hauulb_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Sai tsoro ya kama su duka. Su ka kama yabon Allah, su na cewa, “An ta da wani annabi mai girma a cikinmu” kuma “Allah ya dubi mutanensa.” ");
INSERT INTO hauulb_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Wannan labari na Yesu, ya ba zu a cikin dukan Yahudiya da yankuna da su ke kewaye. ");
INSERT INTO hauulb_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Almajiran Yahaya suka gaya masa dukan wadannan abubuwa. ");
INSERT INTO hauulb_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Sai Yahaya ya kira biyu daga cikin almajiransa, ya aike su wurin Ubangiji, suka ce da shi, “Kai ne mai zuwan nan, ko akwai wani wanda za mu saurari zuwansa?” ");
INSERT INTO hauulb_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Sa'adda suka zo kusa da Yesu, sai mutanen suka ce, “Yahaya Mai Baftisma, ya aiko mu, mu tambaya, “Kai ne mai zuwan nan, ko akwai wani wanda za mu saurari zuwansa?” ");
INSERT INTO hauulb_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","A cikin wannan lokaci, ya warkar da mutane da yawa daga cututtuka da matsaloli da miyagun ruhohi. Makafi da yawa sun sami ganin gari. ");
INSERT INTO hauulb_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Yesu, ya amsa ya ce masu, “Bayan kun tafi, ku ba Yohanna rahoton abin da ku ka ji da abin da ku ka gani. Makafi suna ganin gari, guragu suna tafiya, ana kuma tsarkake kutare. Kurame suna ji, ana tayar da matattu, ana gaya wa matalauta labari mai dadi. ");
INSERT INTO hauulb_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Mai albarka ne mutumin da ya tsaya a kan ba da gaskiya gare ni saboda ayukan da na ke yi.” ");
INSERT INTO hauulb_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Bayan da mutanen da Yahaya ya aiko suka tafi, Yesu ya fara yi wa taron magana game da Yahaya. “Me ku ka tafi ku gani a cikin hamada, ciyawa wadda iska ta ke girgizawa? ");
INSERT INTO hauulb_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Amma me ku ka tafi domin ku gani, mutum mai saye da tufafi masu taushi? Duba mutanen da su ke saye da tufafi masu daraja, kuma suna rayuwa cikin jin dadi suna fadar sarakuna. ");
INSERT INTO hauulb_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Amma me ku ka tafi domin ku gani, annabi ne? I, ina gaya ma ku, ya ma fi annabi. ");
INSERT INTO hauulb_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Wannan shine wanda aka rubuta a kansa, “Duba, ina aika manzo na a gabanka, wanda za ya shirya maka hanya a gabanka. ");
INSERT INTO hauulb_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ina gaya maku, a cikin wadanda mata suka haifa, ba wanda ya fi Yahaya girma. Duk da haka, wanda ya fi kankanta a mulkin Allah, ya fi shi girma. ");
INSERT INTO hauulb_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Sa'anda dukan mutane suka ji haka, har da ma su karbar haraji, suka shaida Allah mai adalci ne. Su na cikin wadanda Yahaya ya yi wa baftisma. ");
INSERT INTO hauulb_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Amma Farisawa da wadanda su ke kwararru a cikin shari'ar Yahudawa, wadanda ba shi ne ya yi masu baftisma ba, suka yi watsi da hikimar Allah don kansu. ");
INSERT INTO hauulb_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Sa'annan Yesu ya ce, “Da me zan kamanta mutanen wannan zamani? Da me suka yi kama? ");
INSERT INTO hauulb_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Suna kama da yaran da suke wasa a kasuwa, wadanda suke magana da junansu suna cewa, “Mun yi maku busa, ba ku yi rawa ba. Mun yi makoki, ba ku yi kuka ba.” ");
INSERT INTO hauulb_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Haka, Yahaya ya zo, bai ci gurasa ba, bai sha ruwan inabi ba, amma ku ka ce, 'Aljani ne yake mulkinsa. ");
INSERT INTO hauulb_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Dan Mutum, ya zo, yana ci, yana sha, amma, kuka ki shi, kuna cewa dubi mutum mai hadama, mai shan ruwan inabi da yawa, abokin masu karbar haraji da masu zunubi! ");
INSERT INTO hauulb_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Amma hikimar Allah tana shaidar dukan 'yayanta.” ");
INSERT INTO hauulb_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Wata rana wani Bafarise, ya roki Yesu ya je ya ci abinci tare da shi. Bayan da Yesu ya shiga gidan Bafarisen, ya zauna a teburi domin ya ci abinci. ");
INSERT INTO hauulb_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Sai ga wata mace mai zunubi, ta fito daga cikin birni. Sa'anda ta ji labari Yesu yana gidan Bafarisen, domin ya ci abinci. Ta dauki tandun mai na alabastar mai kamshi. ");
INSERT INTO hauulb_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ta tsaya kusa da Yesu tana kuka. Ta fara jika kafafunsa da hawayenta, tana shafe kafafunsa da gashin kanta. Tana yi wa kafafunsa sumba, tana shafe su da turare. ");
INSERT INTO hauulb_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Sa'anda Bafarisen da ya gaiyaci Yesu, ya ga haka, sai ya yi tunani a cikin ransa, da cewa, “In da wannan mutum annabi ne, da ya gane ko wacce irin mace ce, wannan da take taba shi, ita mai zunubi ce.” ");
INSERT INTO hauulb_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesu ya amsa ya ce masa, “Siman, ina so in gaya maka wani abu.” Ya ce, “malam sai ka fadi!” ");
INSERT INTO hauulb_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yesu ya ce, “wani mutum mai ba da bashi yana bin wadansu mutane su biyu kudi, yana bin dayan sule dari, dayan kuma yana bin sa sule hamsin. ");
INSERT INTO hauulb_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Da yake ba su da kudin da za su iya biyan sa, sai ya yafe masu, su duka biyu. A cikin su biyu, wanne ne zai fi nuna kauna ga wannan mutum?” ");
INSERT INTO hauulb_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Siman ya amsa ya ce, “Ina tsammani wanda ya yafe wa kudi da yawa.” Yesu ya amsa ya ce masa, “Ka shari'anta dai dai.” ");
INSERT INTO hauulb_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Yesu ya juya wajen matar, ya ce da Siman, “Ka ga matan nan. Na shiga gidanka. Ba ka ba ni ruwa domin kafafuna ba, amma ita ta ba ni, da hawayenta ta wanke kafafuna, ta kuma shafe su da gashin kanta. ");
INSERT INTO hauulb_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Kai ba ka yi ma ni sumba ba, amma ita ta yi, tun sa'adda na shigo nan ba ta dena sumbatar kafafuna ba. ");
INSERT INTO hauulb_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Kai ba ka shafe kai na da mai ba, amma ita ta shafe kafafuna da turare. ");
INSERT INTO hauulb_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Saboda haka, ita wadda ta ke da zunubi da yawa ta bayar da mai yawa, ta kuma nuna kauna mai yawa. Amma shi wanda aka gafarta wa kadan, ya kuma nuna kauna kadan.” ");
INSERT INTO hauulb_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Daga nan sai ya ce mata, “An gafarta zunubanki.” ");
INSERT INTO hauulb_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Wadanda su ke a nan zaune tare da shi suka fara magana da junansu, “Wanene wannan wanda har yake gafarta zunubai? ");
INSERT INTO hauulb_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Sai Yesu ya ce da matar, “Bangaskiyarki ta cece ki. Ki tafi da salama.” ");
INSERT INTO hauulb_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Bayan haka, Yesu da almajiransa goma sha biyu, su ka zagaya cikin birane da kauyuka dabam dabam, suna wa'azi da shelar labari mai dadi game da mulkin Allah, ");
INSERT INTO hauulb_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","mata da yawa wadanda Yesu ya warkar daga aljanu da cututtuka iri iri suna tafiya tare da su. A cikinsu akwai Maryamu wadda a ke ce da ita Magadaliya, wadda ya fitar da aljanu bakwai daga cikinta, ");
INSERT INTO hauulb_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","da Yuwana matar Kuza wakilin Hirudus, da Suzanatu da kuma wasu mata da yawa. Daga abin hannunsu suka tanada masu. ");
INSERT INTO hauulb_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Wata rana aka tara taron mutane da yawa, saboda mutane su na zuwa daga birane da yawa domin su ga Yesu. Ya yi magana dasu cikin misali. ");
INSERT INTO hauulb_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Wani mai shuka ya tafi domin ya shuka iri. Sa'adda ya ke yafa iri, wadansu iri suka fada a kan hanya. Sai mutane suka tattake su, tsuntsaye kuma suka tsince wadansu suka cinye. ");
INSERT INTO hauulb_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Wadansu kuma suka fada a kan duwatsu inda babu kasa da yawa. Da suka tsaro suka fara girma, sai nan da nan suka bushe saboda babu laima a wurin. ");
INSERT INTO hauulb_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Wadansu irin kuma suka fada inda yake da kayayuwa. Tsiretsiren kayayuwan suka fito tare da irin da aka shuka, suka shake su yadda basu iya yin girma ba. ");
INSERT INTO hauulb_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Amma wadansu irin suka fada a kan kasa mai kyau, suka yi girma sosai suka ba da anfani da yawa, har rubi dari.” Bayan da Yesu ya fadi wadannan abubuwan, sai ya yi kira gare su, “Duk mai kunnen ji, bari ya ji.” ");
INSERT INTO hauulb_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Sai almajiran Yesu suka tambaye shi ya gaya ma su ma'anar labarin. ");
INSERT INTO hauulb_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","ya ce da su, “Ku aka ba dama ku gane boyayyun abubuwa, na mulkin Allah. Amma ga sauran mutane ina yi masu magana cikin misalai, 'Domin ko da sun gani ba za su gane ba, kuma ko da sun ji ba za su fahimta ba.” ");
INSERT INTO hauulb_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","To ga ma'anar misalin. Irin shi ne maganar Allah. ");
INSERT INTO hauulb_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Irin da ya fada a kan hanya sune mutanen da suka ji maganar Allah amma daga baya sai shedan ya zo ya dauke maganar daga cikin hankulansu, domin kada su bada gaskiya su tsira. ");
INSERT INTO hauulb_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Sa'annan, wadanda suka fada kan duwatsu sune mutanen da, da zarar sun ji maganar, sukan karbe ta da murna, amma ba su da sauyu; su kan bada gaskiya na dan lokaci kadan kawai, da zaran gwaji ya same su sai su ridda. ");
INSERT INTO hauulb_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Irin da suka fada cikin kayayuwa, sune mutanen da suka ji maganar, amma da suka ci gaba da rayuwa, sai suka bari matsalolin rayuwa kamar dukiya da jin dadin rayuwa suka fi karfinsu, sai ya zama ba su iya bada 'ya'yan da suka yi girma ba. ");
INSERT INTO hauulb_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Amma irin da suka fada a kan kasa mai kyau, wadannan sune mutanen da suka ji maganar, suka karbe ta da gaskiya da zuciya daya, sun rike ta kam-kam, suna jimrewa wurin ba da 'ya'ya. ");
INSERT INTO hauulb_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ba mai kunna fitila, ya rufe ta da kasko, ko su sa ta a karkashin gado. Amma sai a sa ta a wurin zaman ta domin duk wanda ya shigo ya iya ganin hasken ta. ");
INSERT INTO hauulb_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Babu abin da yake a boye wanda ba za a tone shi ba, ko wani asiri da ba za ya fito fili a san shi ba. ");
INSERT INTO hauulb_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ku yi hankali da yadda kuke ji, domin duk mai abu, shi za a kara wa, kuma duk mara abu, dan kadan da yake tunani yana da shi ma, za a dauke.” ");
INSERT INTO hauulb_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Sai mahafiyar Yesu da 'yan'uwansa, su ka zo wurinsa, amma ba su iya zuwa ko kusa da shi ba saboda taron jama'a. ");
INSERT INTO hauulb_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Sai wani ya gaya masa, “Ga mahaifiyarka da 'yan'uwanka, su na tsayuwa a waje, su na son ganin ka.” ");
INSERT INTO hauulb_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Amma Yesu ya amsa ya ce ma su, “Mahaifiyata da 'yan'uwana sune wadanda suke jin maganar Allah, suke yin biyayya da ita.” ");
INSERT INTO hauulb_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Wata rana kuma Yesu ya shiga cikin jirgin ruwa, shi da almajiransa. Ya ce masu, “Ina so mu je dayan ketaren tafkin.” Sai su ka fara tafiya domin su ketare tafkin. ");
INSERT INTO hauulb_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Amma sa'adda su ke tafiya sai Yesu ya yi barci, sai wata iska mai karfi ta taso cikin tafkin, nan da nan sai jirgin ya fara cika da ruwa, kuma su na cikin hatsari. ");
INSERT INTO hauulb_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Sai almajiran Yesu su ka zo su ka tashe shi daga barci. Suka ce da shi, “Ya Shugaba! Ya Shugaba! Za mu mutu!” Sai ya tashi ya umarci iskar, sai iskar mai hauka da tumbatsar ruwan sun tsaya tsit. ");
INSERT INTO hauulb_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Daga nan sai ya ce da su, “Ina bangaskiyar ku?” Almajiran suka tsorata suka yi mamakin abin da ya faru nan take. Suka ce wa junansu, “Wanene wannan wanda har zai ba iska da ruwa umarni kuma su yi masa biyayya?” ");
INSERT INTO hauulb_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Suka zo yankin Garasinawa, wanda ke kusa da Gallili. ");
INSERT INTO hauulb_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Sa'adda Yesu ya sauka kasa, sai wani mutum daga wannan yankin ya tarbe shi. Wannan mutum kuwa yana da aljanu. Mutumin ya dade ba ya sa tufafi, kuma ba ya zama a gida. Maimakon haka, sai a cikin kabarbura ya ke zama. ");
INSERT INTO hauulb_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Sa'adda ya ga Yesu, mutumin ya yi ihu da karfi, ya rusuna a gabansa da babban murya ya ce, “Me zan yi da kai, Yesu, Dan Allah Madaukaki? Ina rokonka, kada ka ba ni azaba!” ");
INSERT INTO hauulb_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Domin Yesu ya umarci aljanun su fita daga cikinsa, domin sau da dama aljanun sukan kama shi. Ko an daure mutumin da sarkoki an kuma tsare shi, yakan tsuttsunke su, kazaman ruhohin sukan kora shi cikin jeji. ");
INSERT INTO hauulb_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Sa'annan Yesu ya tambaye shi, “Yaya sunanka?” Sai ya ba da amsa, “Suna na dubbai.” Ya ce haka ne domin aljanu da yawa sun shiga wannan mutum. ");
INSERT INTO hauulb_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Aljanun suka yi ta rokon Yesu kada ya ummarce su su shiga cikin rami mai zurfi. ");
INSERT INTO hauulb_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Akwai babban garken aladu su na kiwo a kan tsauni kusa da wurin. Aljanun suka roki Yesu da ya barsu su shiga cikin aladun, shi kuwa ya yarda masu. ");
INSERT INTO hauulb_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Aljanun suka bar mutumin suka shiga cikin aladun, sai garken aladun suka gangara kwari suka fada cikin tafkin, suka nutse. ");
INSERT INTO hauulb_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Lokacin da mutanen da su ke kiwon aladun suka ga abin da ya faru, sai suka gudu! Suka ba da rahoton abin da ya faru ga mutanen cikin gari da na wannan kewayen. ");
INSERT INTO hauulb_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Don haka, mutanen da suka ji haka suka tafi domin su ga abin da ya faru, suka zo wurin da Yesu yake, suka ga mutumin wanda aljanu suka fita daga cikinsa. Suka ga ya na sanye da tufafi, kuma ya na cikin hankalinsa, sai tsoro ya kama su. ");
INSERT INTO hauulb_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Mutanen da suka ga abin da ya faru, suka gaya wa wadansu yadda aka warkar da mutumin da aljanu suke iko da shi. ");
INSERT INTO hauulb_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Sai dukan mutane wadanda suke cikin yankin Garasinawa da wadanda suke kewaye, suka roki Yesu da ya fita daga cikin yankin kasarsu domin sun ji tsoro kwarai da gaske. Daga nan Yesu da almajiransa suka shiga cikin jirgin ruwa suka koma. ");
INSERT INTO hauulb_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Mutumin wanda aljanu suka fita daga cikinsa, ya roki Yesu cewa, “Ka barni in tafi tare da kai!” Amma Yesu ya sallame shi cewa, ");
INSERT INTO hauulb_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Ka koma gida ka gaya wa mutanen ka abubuwa masu girma wadanda Allah ya yi maka.” Daga nan sai mutumin ya tafi yana ta gayawa dukan mutanen birnin game da abubuwan da Yesu ya yi masa. ");
INSERT INTO hauulb_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Sa'adda Yesu ya dawo, mutanen suka marabce shi, gama, dukansu suna jiransa. ");
INSERT INTO hauulb_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Sai ga wani mutum mai suna Yayirus, daya daga cikin shugabannin majami'a, ya zo kusa da Yesu ya rusuna da kansa a kasa. Ya roke shi domin ya zo gidansa, ");
INSERT INTO hauulb_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","saboda diyarsa mai kimanin shekara goma sha biyu ta na bakin mutuwa, kuma ita kadai ce diya a gare shi. Amma sa'adda yake tafiya, taron mutane da yawa suna matsa shi. ");
INSERT INTO hauulb_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Akwai wata mace a nan wadda take zubar jini har shekara goma sha biyu. Ta kashe kudinta duka a wurin likitoci, domin su warkar da ita amma ba wanda ya iya warkar da ita. ");
INSERT INTO hauulb_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Sai ta biyo ta bayan Yesu ta taba habar rigarsa. Nan take sai zubar jinin ya tsaya. ");
INSERT INTO hauulb_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yesu ya ce, “Wanene ya taba ni?” Wadanda suke kewaye da shi, kowa ya ce bai taba shi ba, Bitrus ya ce, “Shugaba, mutane da yawa suna ta taruwa kewaye da kai suna ta matsowa kusa da kai.” ");
INSERT INTO hauulb_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Amma Yesu ya ce, “Na sani, wani ya taba ni, domin iko ya fita daga wurina.” ");
INSERT INTO hauulb_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Sa'adda matar ta gane cewa ba za ta iya boyewa ba, sai ta zo wurinsa cikin tsoro. Ta durkusa a gaban Yesu, ta fada a gaban dukan jama'a dalilin da ya sa ta taba shi kuma nan da nan ta warke. ");
INSERT INTO hauulb_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Sai ya ce da ita, “Diya, bangaskiyarki ta warkar da ke. Tafi cikin salama.” ");
INSERT INTO hauulb_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yana cikin yin magana, wani daga cikin gidan shugaban majami'ar ya zo, ya ce, “Diyarka ta riga ta mutu, kada ka dami malam.” ");
INSERT INTO hauulb_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Amma sa'adda Yesu ya ji haka, sai ya ce da shi, “Kada ka ji tsoro. Ka bada gaskiya za ta rayu.” ");
INSERT INTO hauulb_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Sa'adda ya zo gidan, bai bar kowa ya shiga gidan tare da shi ba sai Bitrus da Yahaya da Yakubu, da mahaifiyar yarinyar da babanta. ");
INSERT INTO hauulb_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Dukan mutane a wurin, suna ta kuka da karfi saboda sun damu da yarinyar ta mutu. Amma Yesu ya ce da su, “Ku dena kuka! Ba mutuwa ta yi ba! Barci ta ke yi kawai!” ");
INSERT INTO hauulb_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Mutanen suka yi ma sa dariyan reni, saboda sun sani yarinyar ta mutu. ");
INSERT INTO hauulb_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Amma ya kama hannun ta yayi kira cewa, “Yarinya, na ce ki tashi!” ");
INSERT INTO hauulb_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Nan da nan ruhun ta ya dawo jikin ta sai ta tashi. Ya ce masu su ba ta wani abu ta ci. ");
INSERT INTO hauulb_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Iyayenta suka yi mamaki, amma Yesu ya ce da iyayen kada su gaya wa kowa abin da ya faru. ");
INSERT INTO hauulb_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ya kira almajiransa goma sha biyu, ya ba su iko su fitar da kowanne irin aljani, su kuma warkar da cututtuka daga mutane. ");
INSERT INTO hauulb_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ya aike su, su yi wa'azin mulkin Allah, su kuma warkar da marasa lafiya. ");
INSERT INTO hauulb_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ya ce masu, “Kada ku dauki komi tare da ku domin wannan tafiya. Kada ku dauki sanda, ko jakar matafiyi, ko gurasa, ko kudi - Kada ma ku dauki taguwa biyu. ");
INSERT INTO hauulb_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Dukan gidan da ku ka shiga, ku zauna a gidan har zuwa lokacin da za ku tafi daga wannan yankin. ");
INSERT INTO hauulb_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Dukan wadanda ba su marabce ku ba, sa'adda ku ke barin wannan gari, ku karkabe kurar kafufunku a matsayin shaida a kansu.” ");
INSERT INTO hauulb_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Daga nan sai almajiran suka tafi zuwa cikin kauyuka, suka yi ta shelar bishara, su na warkar da mutane a ko'ina. ");
INSERT INTO hauulb_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ana nan Hirudus, mai mulki, ya ji labarin dukan abubuwan da su ke faruwa. Ya yi mamaki saboda wadansu mutane suna cewa Yahaya mai yin Baftisma ne ya sake dawowa da ransa. ");
INSERT INTO hauulb_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Wadansu kuma suna cewa, annabi Iliya ne ya sake bayyana, wadansu kuma suna cewa daya daga cikin annabawa na da can ne ya sake bayyana da rai. ");
INSERT INTO hauulb_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Hirudus ya ce, “Ba zai yiwu Yahaya ne ba, domin na datse masa kai. To, wanene wannan da ni ke jin wadannan abubuwa a kansa?” Daga nan sai ya cigaba da neman hanyar da zai ga Yesu. ");
INSERT INTO hauulb_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Sa'adda manzannin suka dawo daga tafiyarsu, suka gaya wa Yesu dukan abubuwan da suka yi. Daga nan sai ya dauke su domin su tafi tare da shi zuwa garin Baitsaida. ");
INSERT INTO hauulb_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Amma sa'adda taron suka ji inda Yesu ya tafi, sai suka bi shi can. Ya marabce su ya yi masu jawabi a kan mulkin Allah, kuma ya warkar da wadanda su ke bukatar warkarwa. ");
INSERT INTO hauulb_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Da yake yamma ta fara yi, sai almajiransa goma sha biyu suka zo suka ce da shi, “Idan ka yarda ka sallami wannan babban taron mutane dominsu shiga cikin kauyuka, da ke kewaye da gonaki, dominsu sami abinci da wuraren da za su kwana, da yake mu na nan a wurin da ba kowa.” ");
INSERT INTO hauulb_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Amma sai ya ce da su, “Ku ba su abin da za su ci.” Suka amsa masa, “Dukan abin da muke da shi shine, 'Yan dunkulen gurasa biyar da 'yan kifaye guda biyu, ba za mu iya zuwa mu sawo abincin da zai ishi mutanen nan su duka ba.” ");
INSERT INTO hauulb_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Mutanen da suke wurin sun kai kimanin mazaje dubu biyar. Sai Yesu ya ce da almajiran, “Ku ce da mutanen su zauna kungiya-kungiya, mutane hamsin a kowacce kungiya.” ");
INSERT INTO hauulb_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Sai almajiran suka yi haka, dukan mutanen suka zauna. ");
INSERT INTO hauulb_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ya dauki dunkulen gurasan guda biyar, da kifin guda biyu, yana dubawa zuwa sama ya albakarce su, sa'annan ya gutsuttsura, ya ba almajiran domin su rarraba wa mutane. ");
INSERT INTO hauulb_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Dukansu suka ci kowa ya koshi. Daga nan almajiran suka tattara sauran abin da ya rage, har kwanduna goma sha biyu suka cika! ");
INSERT INTO hauulb_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Wata rana Yesu yana yin addu'a shi kadai, sai almajiransa suka zo sai ya tambaye su, “Wa mutane suke cewa da ni?” ");
INSERT INTO hauulb_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Suka amsa, “Wadansu suna cewa, Yahaya mai yin Baftisma, wadansu suna cewa kai annabi Iliya ne, har yanzu wadansu suna cewa kai wani cikin annabawa na da can ne ya dawo da rai.” ");
INSERT INTO hauulb_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ya tambaye su, “Ku fa? Wa kuke cewa da ni?” Bitrus ya amsa, “Kai Almasihu ne wanda ya zo daga wurin Allah.” ");
INSERT INTO hauulb_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Sai Yesu ya gargade su da karfi, kada su gayawa kowa haka tukuna. ");
INSERT INTO hauulb_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Sa'annan ya ce, “Dan Mutum dole ya sha wahalar abubuwa da yawa; dattawa za su ki shi da manyan fristoci da marubuta, sa'annan za a kashe shi. Bayan kwana uku, za a tashe shi da rai.” ");
INSERT INTO hauulb_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Sai ya ce da su duka, “Dukan wanda ya ke so ya biyo ni, dole ne ya yi musun kansa, ya dauki gicciyen sa kulluyomin, ya biyo ni. ");
INSERT INTO hauulb_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Dukan wanda yake so ya ceci ransa, za ya rasa shi, amma dukan wanda ya ba da ransa domina, za ya cece shi. ");
INSERT INTO hauulb_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Wacce riba mutum zai samu idan ya sami duniya duka, amma ya rasa ransa? ");
INSERT INTO hauulb_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Dukan wanda yake jin kunya ta da magana ta, Dan Mutum ma zai ji kunyarsa, sa'adda ya dawo cikin darajarsa da darajar Uba da ta mala'iku masu tsarki. ");
INSERT INTO hauulb_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Amma ina gaya maku wannan tabbas, wadansu cikinku da ke nan tsaye, ba za su mutu ba sai sun ga mulkin Allah.” ");
INSERT INTO hauulb_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Kwana takwas bayan Yesu ya fadi wadannan kalmomi, sai ya dauki Bitrus da Yahaya da Yakubu, ya hau kan dutse domin ya yi addu'a a can. ");
INSERT INTO hauulb_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Sa'anda ya ke yin addu'a sai yanayin fuskar sa ya canza sosai, tufafinsa kuma suka yi sheki da haske kamar walkiya. ");
INSERT INTO hauulb_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Nan da nan sai ga mutane biyu suna magana da shi, wato Musa da Iliya. ");
INSERT INTO hauulb_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Suka bayyana da daraja kewaye da su, suka yi magana da Yesu a kan tafiyarsa wadda za ta zo ba da dadewa ba a cikin Urushalima. ");
INSERT INTO hauulb_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Bitrus da almajiran da suke tare da shi barci mai nauyi ya dauke su. Sa'adda suka farka sai su suka ga daukakar Yesu; kuma suka ga mutanen su biyu da ke tsaye tare da shi. ");
INSERT INTO hauulb_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Sa'adda Musa da Iliya suke shirin su bar wurin Yesu, sai Bitrus ya ce, “Ya shugaba, ya yi kyau da muke a nan. Zai yi kyau mu yi runfuna uku, daya dominka, daya domin Musa, daya kuma domin Iliya.” Amma hakika bai san abin da ya ke fadi ba. ");
INSERT INTO hauulb_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Sa'adda yake fadin haka sai wani girgije ya zo ya rufe su. Sai suka ji tsoro sa'adda girgijen ya kewaye su. ");
INSERT INTO hauulb_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Sai ga wata murya daga cikin girgijen tana cewa, “Wannan Dana ne wanda na zaba, ku ji shi.” ");
INSERT INTO hauulb_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Sa'adda muryar ta gama magana, Yesu yana nan shi kadai. Suka yi shiru ba su iya cewa kome ba a kan abin da suka gani a kwanakin nan. ");
INSERT INTO hauulb_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Washe gari, da suka sauko daga kan dutsen, sai taron mutane da yawa suka zo wurinsa. ");
INSERT INTO hauulb_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Nan da nan, wani mutum daga cikin taron mutanen ya yi magana da karfi, “Mallam, kayi wani abu dominka taimaki da na, shi kadai ne gare ni. ");
INSERT INTO hauulb_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Mugun ruhu ya kan hau kansa, ya sa shi ya yi ta magowa. Ya kan girjiza shi da karfi ya sa bakinsa ya yi ta kumfa. Da kyar ya ke rabuwa da shi, kuma ya kan ji masa ciwo ba kadan ba bayan da ya bar shi. ");
INSERT INTO hauulb_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Na roki almajiran ka su umurci mugun ruhun ya fita daga cikinsa, amma ba su iya ba!” ");
INSERT INTO hauulb_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesu, ya amsa, ya ce, “Ku karkatattun tsara marasa bangaskiya, har yaushe zan zauna da ku ina jimrewa da ku? “Kawo yaronka anan.” ");
INSERT INTO hauulb_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Sa'adda yaron yake zuwa, sai mugun ruhun ya fyada yaron a kasa, ya jijjiga shi sosai. Amma Yesu ya tsauta wa mugun ruhun, ya warkar da yaron. Sa'annan ya mika yaron wurin mahaifinsa. ");
INSERT INTO hauulb_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Dukansu suka yi mamaki da girman ikon Allah. Amma sa'anda suke ta yin mamaki a kan dukan al'ajiban da ya yi, ya ce da almajiransa, ");
INSERT INTO hauulb_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Ku saurara da kyau a kan abin da zan gaya maku, ba da dadewa ba za a bada Dan Mutum ga mutane.” ");
INSERT INTO hauulb_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Amma almajiran ba su gane abin da yake nufi da haka ba, an hana su fahimta, domin kada su gane abin da ya ke nufi tukuna, kuma suna jin tsoron su tambaye shi. ");
INSERT INTO hauulb_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Wani lokaci, almajiran suka fara gardama a tsakaninsu game da wanene za ya zama mafi girma a cikinsu. ");
INSERT INTO hauulb_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Amma Yesu ya san abin da suke tunani a zuciyarsu, sai ya kawo dan karamin yaro ya tsaya a kusa da shi, ");
INSERT INTO hauulb_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","sai ya ce da su, “Idan wani ya karbi dan karamin yaro kamar wannan saboda ni, dai dai yake da ya karbe ni. Idan kuma wani ya karbe ni, ya karbi wanda ya aiko ni kenan. Wanda yake mafi kankanta a cikinku, shi ne mafi mahimmanci.” ");
INSERT INTO hauulb_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yahaya ya amsa yace, “Ya shugaba, mun ga wani mutum yana ba miyagun ruhohi umarni su fita daga cikin mutane da sunanka. Sai muka ce da shi ya dena yin haka saboda baya tare da mu.” ");
INSERT INTO hauulb_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Amma Yesu ya ce, “Kada ku hana shi yin haka, domin dukan wanda ba ya gaba da ku, yana tare da ku.” ");
INSERT INTO hauulb_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Sa'adda rana ta kusato da zai hawo zuwa sama, ya kudurta sosai zai tafi Urushalima. ");
INSERT INTO hauulb_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ya aiki wadansu manzanni su shirya wuri dominsa kafin ya zo. Suka shiga wani kauye a cikin kauyen Samariya domin su shirya masa wuri a can. ");
INSERT INTO hauulb_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Amma mutanen can ba su karbe shi ba tun da ya ke Urushalima zai tafi. ");
INSERT INTO hauulb_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Sa'adda biyu daga cikin almajiransa, wato Yakubu da Yahaya suka ga haka, suka ce, “Ubangiji, kana so mu umarci wuta ta sauko daga sama, ta hallaka su?” ");
INSERT INTO hauulb_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Amma, ya juya ya tsauta masu. ");
INSERT INTO hauulb_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Sai suka tafi wani kauye dabam. ");
INSERT INTO hauulb_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Da suna cikin tafiya a kan hanya, sai wani mutum ya ce da shi, “Zan bi ka dukan inda za ka tafi.” ");
INSERT INTO hauulb_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesu ya amsa masa, “Dila suna da ramuka a kasa inda za su shiga, tsuntsaye kuma suna da sheka, amma Dan Mutum ba shi da inda zai kwanta.” ");
INSERT INTO hauulb_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yesu, ya ce da wani mutumin kuma, “Ka biyo ni.” Amma mutumin ya ce, “Ubangiji, ka bari in koma gida in bizine mahaifina tukuna.” ");
INSERT INTO hauulb_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Amma Yesu ya ce masa, “Ka bar matattu su bizine matattunsu; amma kai ka tafi ka yi wa mutane shelar mulkin Allah a ko'ina.” ");
INSERT INTO hauulb_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Wani kuma ya ce, “Ubangiji zan tafi tare da kai, amma bari in je gida inyi ban kwana da mutanena tukuna.” ");
INSERT INTO hauulb_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yesu ya ce da shi, “Dukan wanda ya fara huda a gonarsa idan ya dubi baya, bai isa ya shiga mulkin Allah ba.” ");
INSERT INTO hauulb_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Bayan wadannan abubuwa, Ubangiji ya sake nada wadansu saba'in ya aike su biyu biyu, domin su tafi kowanne birni da wurin da yake niyyan zuwa. ");
INSERT INTO hauulb_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ya ce da su, “Girbin yana da yawa, amma ma'aikatan sun yi kadan. Saboda haka kuyi addu'a sosai ga Ubangijin girbin, domin ya aiko da ma'aikata cikin gonarsa. ");
INSERT INTO hauulb_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ku tafi, duba na aike ku kamar 'yan raguna cikin kyarkyetai. ");
INSERT INTO hauulb_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Kada ku dauki jakan kudi, ko jakar matafiyi, ko takalma, kada ku gai da kowa a kan hanya. ");
INSERT INTO hauulb_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Dukan gidan da ku ka shiga, ku fara cewa, 'Bari salama ta kasance a wannan gida.' ");
INSERT INTO hauulb_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Idan akwai mutum mai salama a gidan, salamar ku za ta kasance a kansa, amma idan babu, salamar ku za ta dawo wurinku. ");
INSERT INTO hauulb_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ku zauna a wannan gidan, ku ci ku sha abin da suka tanada maku. Gama ma'aikaci ya wajibci ladansa. Kada ku bi gida gida. ");
INSERT INTO hauulb_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Dukan birnin da ku ka shiga kuma sun karbe ku, ku ci abin da suka sa a gabanku. ");
INSERT INTO hauulb_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ku warkar da marasa lafiyar da ke wurin. Ku ce da su, 'Mulkin Allah ya zo kusa da ku.' ");
INSERT INTO hauulb_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Amma dukan birnin da ku ka shiga, idan ba su karbe ku ba, ku tafi cikin titunansu, ku ce, ");
INSERT INTO hauulb_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","'Ko kurar birninku da ta like a kafafunmu, mun karkabe maku ita a matsayin shaida a kanku! Amma ku sani mulkin Allah ya zo kusa da ku.' ");
INSERT INTO hauulb_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Na gaya maku, a ranar shari'a Saduma za ta fi wannan birni samun sauki. ");
INSERT INTO hauulb_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Kaiton ki, Korasinu! Kaiton ki, Baitsaida! Ayyuka masu girma da aka yi a cikinku, da an yi su a cikin Taya da Sidon, da sun tuba tuntuni a zaune cikin toka da tufafin makoki. ");
INSERT INTO hauulb_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Amma a ranar shari'a Taya da Sidon za su fi ku samun sauki. ");
INSERT INTO hauulb_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ke kuma Kafarnahum, kina tsammani har zuwa sama za a daukaka ki? Babu, za a gangarar dake har zuwa hadas. ");
INSERT INTO hauulb_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Wanda ya saurare ku ya saurare ni, wanda ya ki ku, ya ki ni, kuma wanda ya ki ni, ya ki wanda ya aiko ni.” ");
INSERT INTO hauulb_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Su saba'in din suka dawo da murna, suna cewa, “Ubangiji, har ma aljanu suna yi mana biyayya, a cikin sunanka.” ");
INSERT INTO hauulb_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Sai Yesu ya ce masu, “Na ga Shaidan yana fadowa daga sama kamar walkiya. ");
INSERT INTO hauulb_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Duba, na ba ku iko ku taka macizai da kunamai, da kuma kan dukan ikon magabci, kuma ba zai iya yin illa a gareku ba ko kadan. ");
INSERT INTO hauulb_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Amma duk da haka kada ku yi murna a kan wannan kadai cewa ruhohi suna yi maku biyayya, amma ku yi murna domin an rubuta sunayenku a cikin sama.” ");
INSERT INTO hauulb_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Cikin wannan lokacin, ya yi farin ciki kwarai cikin Ruhu Mai Tsarki, ya ce, “Na ba ka girma, ya Uba, Ubangijin sama da kasa. Domin ka rufe wadannan abubuwa daga masu hikima da ganewa, ka bayyana su ga wadanda ba koyayyu ba ne, kamar kananan yara. I, Uba gama haka ne ya gamshe ka.” ");
INSERT INTO hauulb_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Dukan abu, Ubana ya damka su gare ni, kuma babu wanda ya san Dan, sai Uban, kuma ba wanda ya san Uban, sai Dan. Sai kuma wanda Dan ya yi niyyar ya bayyana Uban a gareshi.” ");
INSERT INTO hauulb_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ya juya wajen almajiran, ya ce da su a kadaice, “Masu albarka ne su wadanda suka ga abin da kuke gani. ");
INSERT INTO hauulb_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Na fada maku, annabawa da yawa, da sarakuna da yawa sun so da sun ga abubuwan da kuke gani, amma ba su gani ba. Kuma sun so da sun ji abubuwan da kuke ji, amma ba su ji su ba.” ");
INSERT INTO hauulb_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Sai ga wani malamin shari'ar Yahudawa, ya zo ya gwada shi da cewa, “Malam, me zan yi domin in gaji rai na har abada?” ");
INSERT INTO hauulb_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Sai Yesu ya ce masa, “Yaya kake karanta abin da aka rubuta cikin shari'a?” ");
INSERT INTO hauulb_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ya amsa ya ce,”Dole ne ka kaunaci Ubangiji Allah da dukan zuciyarka, da dukan ranka da dukan karfinka, da dukan lamirinka. Ka kuma kaunaci makwabcinka kamar kanka.” ");
INSERT INTO hauulb_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesu ya ce ma sa, “Ka amsa daidai, idan ka yi haka za ka rayu.” ");
INSERT INTO hauulb_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Amma, malamin ya na so ya 'yantar da kansa, sai ya ce da Yesu, “To, wanene makwabcina?” ");
INSERT INTO hauulb_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ya amsa ya ce, “Wani mutum yana tafiya daga Urushalima za shi Yariko. Sai ya fada hannun mafasa, suka tube shi, suka kwace dukan abin da ya ke da shi, suka yi masa duka, suka bar shi kamar matacce. ");
INSERT INTO hauulb_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ya zama sai ga wani firist ya na bin wannan hanya, da ya gan shi sai ya bi ta gefe daya ya wuce. ");
INSERT INTO hauulb_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Haka kuma sai ga wani Balawi, sa'adda ya zo wurin, ya gan shi sai ya bi ta wani gefe ya wuce shi. ");
INSERT INTO hauulb_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Amma wani Basamariye, ya na tafiya sa'adda ya zo wurin da mutumin yake, sa'adda ya ga mutumin sai tausayi ya kama shi. ");
INSERT INTO hauulb_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ya zo inda mutumin yake, ya daure masa raunukan da aka ji masa, yana shafa masu mai da ruwan inabi. Ya dora shi a kan dabbarsa ya kawo shi wurin kwana, ya kula da shi ");
INSERT INTO hauulb_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Washegari ya kawo dinari biyu, ya ba mai wurin kwanan ya ce 'Ka kula da shi, idan ma ka kashe fiye da haka, idan na dawo zan biya ka.' ");
INSERT INTO hauulb_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","A cikinsu ukun nan, wanene kake tsammani makwabcin wannan mutum da ya fada hannun 'yan fashi?” ");
INSERT INTO hauulb_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Sai malamin ya ce, “Wannan da ya nuna masa jinkai” Sai Yesu yace masa, “Ka je kai ma ka yi haka.” ");
INSERT INTO hauulb_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Sa'adda suke tafiya, sai ya shiga cikin wani kauye, sai wata mata mai suna Marta ta marabce shi a gidanta. ");
INSERT INTO hauulb_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Tana da 'yar'uwa mai suna Maryamu, wadda ta zauna a kafafun Ubangiji tana jin abin da yake fadi. ");
INSERT INTO hauulb_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Amma ita Marta ta na ta kokari ta shirya abinci. Sai ta zo wurin Yesu ta ce, “Ubangiji, ba ka damu ba 'yar'uwata ta bar ni ina ta yin aiki ni kadai? Ka ce da ita ta taya ni.” ");
INSERT INTO hauulb_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Amma Ubangiji ya amsa ya ce da ita, “Marta, Marta, kin damu a kan abubuwa da yawa, ");
INSERT INTO hauulb_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","amma abu daya ne ya zama dole. Maryamu ta zabi abu mafi kyau, wanda ba za a iya kwace mata ba.” ");
INSERT INTO hauulb_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Wani lokaci, Yesu yana yin addu'a a wani wuri, sai daya daga cikin almajiransa yace da shi, “Ubangiji, ka koya mana yin addu'a kamar yadda Yahaya ya koya wa almajiransa.” ");
INSERT INTO hauulb_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yesu ya ce ma su, “Sa'anda ku ke yin addu'a ku ce, 'Uba a tsarkake sunanka. Mulkin ka ya zo. ");
INSERT INTO hauulb_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ka ba mu abin da za mu ci a kowacce rana. ");
INSERT INTO hauulb_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Gafarta mana zunubanmu, kamar yadda muke gafarta ma wadanda suke mana laifi. Kada ka kai mu cikin jaraba.'” ");
INSERT INTO hauulb_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Yesu ya ce masu, “Wanene a cikinku idan yana da aboki, za ya je wurinsa da tsakar dare ya ce masa, ''Aboki, ka ba ni rancen dunkulen gurasa guda uku, ");
INSERT INTO hauulb_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","da ya ke wani abokina ya iso yanzu daga tafiya, kuma ba ni da abin da zan ba shi ya ci,' ");
INSERT INTO hauulb_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Sai wanda yake ciki, ya amsa, ya ce, 'Kada ka dame ni. Na riga na rufe kofa ta, kuma ni da yarana mun riga mun kwanta. Ba zan iya tashi in ba ka gurasa ba.' ");
INSERT INTO hauulb_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Na fada maku, ko da bai tashi ya ba ka gurasar ba, a matsayin abokinsa, ba ka ji kunya ba, ka nace da rokonsa, za ya tashi ya ba ka dukan yawan gurasar da kake bukata. ");
INSERT INTO hauulb_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ni kuma ina ce maku, ku roka za a ba ku; ku nema za ku samu; ku kwankwasa za a bude maku. ");
INSERT INTO hauulb_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Domin dukan wanda yake roko ya na karba; dukan wanda ya ke nema kuma yana samu; kuma wanda yake kwankwasawa, za a bude masa. ");
INSERT INTO hauulb_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Wanne uba ne a cikinku, idan dansa ya tambaye shi kifi, zai ba shi maciji a maimakon kifi? ");
INSERT INTO hauulb_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ko kuwa idan ya tambaye shi kwai, za ya ba shi kunama? ");
INSERT INTO hauulb_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","To, da yake ku da kuke masu mugunta kun san ku ba 'yanyan ku abu mai kyau. Yaya fa ga Ubanku wanda yake cikin sama, za ya ba da Ruhu Mai Tsarki ga wadanda suka roke shi?” ");
INSERT INTO hauulb_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Wani lokaci, Yesu yana fitar da wani beben aljani. Sa'adda aljanin ya fita, sai mutumin da yake bebe ya yi magana. Sai taron mutanen suka yi mamaki! ");
INSERT INTO hauulb_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Amma, wadansu daga cikin mutanen suka ce, “Da ikon Ba'alzabuba sarkin aljanu ne yake fitar da aljanu.” ");
INSERT INTO hauulb_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Wadansu suka gwada shi, suka nemi ya nuna masu wata alama daga sama. ");
INSERT INTO hauulb_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Amma Yesu da yake ya san tunaninsu, ya ce da su, “Dukan mulkin da ya rabu biyu, gaba da kansa, ya rushe kenan, kuma idan gida ya rabu biyu, gaba da kansa za ya fadi. ");
INSERT INTO hauulb_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Idan Shaidan ya rabu biyu gaba da kansa, ta yaya mulkinsa zai iya tsayawa? Gama kun ce ina fitar da aljanu ta wurin Ba'alzabuba. ");
INSERT INTO hauulb_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Idan ni na fitar da aljanu ta wurin Ba'alzabuba, ta wurin wa wadanda suke bin ku suke fitar da aljanu? Saboda haka, su ne zasu zama masu yi maku shari'a. ");
INSERT INTO hauulb_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Amma idan daga wurin Allah na ke fitar da aljanu, to, ya zama ke nan mulkin Allah ya zo wurinku. ");
INSERT INTO hauulb_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Idan mutum mai karfi, mai kayan fada ya tsare gidansa, kayansa za su tsira. ");
INSERT INTO hauulb_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Amma idan wani mutum wanda ya fi shi karfi ya zo ya ci nasara a kansa, zai dauke kayan fadan daga wurin mutumin, kuma ya kwashe kayansa. ");
INSERT INTO hauulb_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Wanda ba ya tare da ni, gaba da ni ya ke yi, kuma wanda ba ya tattarawa tare da ni, watsarwa yake yi. ");
INSERT INTO hauulb_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Idan kazamin ruhu ya fita daga cikin mutum, ya kan bi ta wurin busassun wurare yana neman wurin da zai huta. Idan bai samu ba sai ya ce, 'Bari in koma gidana inda na baro. ");
INSERT INTO hauulb_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Sa'adda ya dawo, ya tarar an share gidan, an kuma gyara shi tsaf. ");
INSERT INTO hauulb_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Sai ya je ya dauko wadansu aljanu guda bakwai wadanda su ka fi shi mugunta, su zo su zauna a wurin. Sai karshen mutumin nan ya fi farkonsa muni.” ");
INSERT INTO hauulb_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ya zama, lokacin da ya ke fadin wadannan abubuwa, wata mace ta tada muryarta a cikin taron mutanen ta ce da shi, “Mai albarka ne cikin da ya haife ka, da maman da ka sha.” ");
INSERT INTO hauulb_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Sai shi kuma ya ce, “Masu albarka ne wadanda suke jin maganar Allah suke yin biyayya da ita.” ");
INSERT INTO hauulb_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Lokacin da mutane suke kara taruwa, sai ya fara cewa, “Wannan tsara, muguwar tsara ce. Ta na neman alama, Ko da yake ba wata alamar da za a bata sai irin ta Yunusa. ");
INSERT INTO hauulb_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Domin kamar yadda Yunusa ya zama alama ga mutanen Neneba, haka kuma Dan Mutum za ya zama alama ga wannan tsara. ");
INSERT INTO hauulb_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Sarauniyar Kudu, za ta tsaya ta yi shari'a da mutanen wannan tsara, kuma za ta kashe su, gama ta zo daga wuri mai nisa domin ta saurari hikimar Sulaimanu. Kuma ga wani wanda ya fi Sulaimanu a nan. ");
INSERT INTO hauulb_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Mutanen Neneba, za su tsaya shari'a da matanen wannan tsara, kuma za su kashe su. Gama sun ji wa'azin Yunusa sun tuba. Kuma ga wani wanda ya fi Yunusa a nan. ");
INSERT INTO hauulb_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ba wanda zai kunna fitila ya boye ta, ko kuwa ya sa ta a karkashin kasko, amma zai sa ta a mazaunin ta domin dukan wanda ya shiga dakin ya ga haske. ");
INSERT INTO hauulb_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Idon ku shine fitilar jikinku. Idan idonku yana gani sosai, jikinku zai cika da haske. Amma idan idonku ba ya gani sosai, jikinku zai cika da duhu. ");
INSERT INTO hauulb_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ku yi hankali fa, domin kada hasken da ya ke wurinku ya zama duhu. ");
INSERT INTO hauulb_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Idan dukan jikinku yana cike da haske, babu duhu ko kadan, to sai dukan jikinku ya zama kamar fitilar da take bada haskenta a bisanku.” ");
INSERT INTO hauulb_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Sa'adda ya gama jawabi, sai wani Bafarise ya ce da shi ya zo gidansa ya ci abinci, sai Yesu ya shiga ya zauna. ");
INSERT INTO hauulb_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Sai Bafarisen ya yi mamaki da ganin bai wanke hannu kafin ya ci abinci ba. ");
INSERT INTO hauulb_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Amma sai Ubangiji ya ce da shi, “Ku Farisawa kuna tsabtace bayan kofi da bangaji, amma cikin yana cike da kazamta da mugunta. ");
INSERT INTO hauulb_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ku mutane marasa tunani, wanda ya yi wajen, ba shine ya yi cikin ba? ");
INSERT INTO hauulb_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ku bayar da abin da ke ciki ga matalauta, kuma dukan abu zai zamar maku da tsafta. ");
INSERT INTO hauulb_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Amma kaitonku Farisawa, gama kuna karbar zakka da daddoya da karkashi da kowanne irin ganye na lambu, amma kun watsar da adalci da kaunar Allah. Dole ne a yi adalci, a kaunaci Allah, a yi sauran abubuwan kuma. ");
INSERT INTO hauulb_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Kaitonku Farisawa, domin kuna so a ba ku wuraren zama masu kyau a cikin masujadai, a kuma yi maku gaisuwar bangirma a cikin kasuwanni. ");
INSERT INTO hauulb_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Kaiton ku, gama kuna kama da kabarbarun da ba yi masu shaida ba, mutane kuwa suna tafiya akansu ba tare da saninsu ba.” ");
INSERT INTO hauulb_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Wani malami a cikin shari'ar Yahudawa ya amsa masa ya ce, “Malam, abin da ka ce ya bata mana rai mu ma.” ");
INSERT INTO hauulb_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Sai Yesu ya ce, “Kaitonku malaman shari'a! Gama kun dora wa mutane kaya mai nauyi wanda ya fi karfinsu dauka. Amma ku, ko da dan yatsa ba ku taba kayan ba. ");
INSERT INTO hauulb_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Kaiton ku, gama kuna gina abubuwan tunawa a kabuburan annabawa, alhali kuwa kakanni-kakanninku ne suka kashe su. ");
INSERT INTO hauulb_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ya zama kenan kuna sane da ayyukan kakanni-kakanninku, domin sune suka kashe annabawan da kuke tunawa da su. ");
INSERT INTO hauulb_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Saboda wannan daliline hikimar Allah ta ce, ''Zan aika manzanni da annabawa a wurinsu, kuma za su tsananta masu har ma za su kashe wadansu daga cikinsu.' ");
INSERT INTO hauulb_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Wannan tsarar, za ta dauki alhakin jinin dukan annabawan da aka kashe tun kafuwar duniya. ");
INSERT INTO hauulb_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Tun daga jinin Habila, har zuwa jinin Zakariya wanda aka kashe tsakanin bagadi da wuri mai tsarki. I, na gaya ma ku za a nemi hakin su a wurin wannan tsarar ");
INSERT INTO hauulb_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Kaitonku malaman shari'a na Yahudawa, domin kun dauke mabudin sani, ku da kanku ba ku shiga ba, kuma kun hana masu shiga su shiga.” ");
INSERT INTO hauulb_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Bayan da Yesu ya bar nan wurin, Marubuta da Farisawa suka yi gaba da shi, suka yi jayayya da shi a kan abubuwa da yawa, ");
INSERT INTO hauulb_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","suna kokari su kafa masa tarko domin su kama shi a cikin kalmomin da yake fadi. ");
INSERT INTO hauulb_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Da jimawa kadan, bayan da mutane da yawa suka taru kwarai har suna tattaka junansu. Sai ya fara yin magana da almajiransa. “Ku yi lura da yisti na Farisawa, wanda shine manufunci. ");
INSERT INTO hauulb_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Amma ba abin da ke rufe wanda ba za a tone ba, ba kuma abin da ke boye wanda ba za a sani ba. ");
INSERT INTO hauulb_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Saboda haka ba abin da za ku fadi a asirce wanda ba za a ji shi a cikin sarari ba. Abin da ku ka fadi da rada cikin lungu, za a yi shelarsa a ko'ina. ");
INSERT INTO hauulb_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ina gaya maku abokaina, kada ku ji tsoron wanda da za su kashe jiki. Bayan haka kuma ba abin da za su iya yi. ");
INSERT INTO hauulb_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Bari in gargade ku a kan wanda za ku ji tsoronsa. Ku ji tsoron shi wanda bayan ya kashe zai iya jefa ku cikin jahannama. I, ina ce maku ku ji tsoronsa. ");
INSERT INTO hauulb_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ba a kan sayar da 'yan tsuntsaye biyar a kan anini biyu ba? Duk da haka, Allah ba zai manta da ko daya daga cikinsu ba. ");
INSERT INTO hauulb_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Har ma gashin da ke kan ku ya san yawan su. Kada ku ji tsoro, ku kun fi tsuntsaye daraja a wurinsa. ");
INSERT INTO hauulb_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ina gaya maku, dukan wanda za ya shaida ni a gaban mutane, Dan Mutum kuma za ya shaida shi a gaban mala'kun Allah. ");
INSERT INTO hauulb_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Kuma dukan wanda ya ki ni a gaban mutane, za a ki shi a gaban mala'ikun Allah. ");
INSERT INTO hauulb_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Dukan wanda ya yi magana gaba da Dan Mutum, za a gafarta masa. Amma shi wanda ya yi sabon Ruhu Mai Tsarki, ba za a gafarta masa ba. ");
INSERT INTO hauulb_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Idan suka kawo ku gaban majami'a, ko gaban masu shari'a, ko gaban masu iko, kada ku damu da abin da za ku fada domin ku kare kanku. Ko kuwa abin da za ku ce. ");
INSERT INTO hauulb_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Gama Ruhu Mai Tsarki zai koya maku abin da za ku fadi a wannan lokaci.” ");
INSERT INTO hauulb_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Sai wani a cikin taron ya ce masa, “Malam, ka yi wa dan'uwana magana ya raba gado da ni ");
INSERT INTO hauulb_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yesu ya ce masa, “Kai, wanene ya sa ni in zama alkali, ko matsakanci a kanku?” ");
INSERT INTO hauulb_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Sai kuma ya ce masu, “Ku yi lura kada ku zama masu hadama, gama ba abin da mutum ya mallaka ne ya fi mahimmanci a cikin rayuwar sa ba.” ");
INSERT INTO hauulb_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Sa'annan Yesu ya fada masu wani misali, ya ce, “Gonar wani mutum ta bada amfani sosai, ");
INSERT INTO hauulb_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","ya yi tunani, ya ce, 'Me zan yi, domin ba ni da wurin da zan iya ajjiye amfanin gonata?' ");
INSERT INTO hauulb_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Sai ya ce, na san abin da zan yi. Zan rushe rumbuna na in gina wadansu manya-manya, a nan zan ajjiye hatsi na da dukan abubuwa. ");
INSERT INTO hauulb_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Sai in ce da raina, “Ya raina, kana da abu da yawa da aka ajjiye dominka, sai ka huta, ka ci, ka sha, ka yi murna.” ");
INSERT INTO hauulb_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Amma sai Allah ya ce da shi, 'Wawan mutum, a cikin daren nan ana son ranka daga wurinka. Kayan da ka tara ka shirya wa kanka, na wa za su zama?' ");
INSERT INTO hauulb_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Haka wanda ya tara wa kansa dukiya yake, idan ba shi da dukiya a wurin Allah.” ");
INSERT INTO hauulb_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yesu, ya ce da almajiransa, “Saboda haka ina cewa da ku, kada ku damu da rayuwarku, wato, abin da za ku ci, ko abin da za ku sa a jikinku. ");
INSERT INTO hauulb_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Gama rai ya fi abinci, jiki kuma ya fi tufafi. ");
INSERT INTO hauulb_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ku dubi hankaki wadanda ba sa yin shuka, ba sa yin girbi. Ba su da rumbuna ko dakunan ajjiya, amma Allah ya na ciyar da su. Ku fa kun fi tsuntsaye daraja! ");
INSERT INTO hauulb_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Wanene a cikinku ta wurin sha'awarsa za ya iya karawa kansa kwanaki? ");
INSERT INTO hauulb_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Idan ba ku iya yi wa kanku dan karamin abu ba, me ya sa za ku damu da sauran abubuwa? ");
INSERT INTO hauulb_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ku dubi furanni a daji - yadda suke yin girma. Ba su kan yi aiki ba, ba su kan yi kadi ba. Ina gaya maku, ko Sulaimanu, a cikin darajarsa, bai sa tufafin da suka fi nasu kyau ba. ");
INSERT INTO hauulb_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Idan Allah ya sa wa ciyawa tufafi masu kyau haka, wadda yau tana nan, gobe kuma a sa ta a wuta, ta yaya zai kasa sa maku tufafi, ku masu kankantar bangaskiya! ");
INSERT INTO hauulb_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Kada ku damu da abin da za ku ci, ko abin da za ku sha, kuma kada ku yi alhini. ");
INSERT INTO hauulb_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Gama dukan al'umman duniya suna neman wadannan abubuwa, kuma Ubanku ya san kuna bukatar wada nan abubuwan. ");
INSERT INTO hauulb_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Amma ku bidi mulkinsa, wadannan abubuwa kuma za a kara maku su. ");
INSERT INTO hauulb_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Kada ku ji tsoro, ku 'yan kanana, domin da murna Ubanku zai ba ku mulkin. ");
INSERT INTO hauulb_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ku sayar da abin da ku ke da shi ku ba matalauta. Kuyi wa kanku jakukkuna wadanda ba za su lalace ba, ku yi ajjiya cikin sama inda abin ba ya karewa, inda barayi ba za su iya zuwa ba, kwari kuma ba za su iya lalatawa ba. ");
INSERT INTO hauulb_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Domin inda dukiyarka take, can zuciyarka za ta kasance kuma. ");
INSERT INTO hauulb_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Ku rage tsawon tufafinku, ku yi dammara, ya zama fitilarku tana ci koyaushe, ");
INSERT INTO hauulb_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","ku kuma zama kamar wadanda suke jiran mai gidansu ya dawo daga gidan buki, domin duk sa'adda ya zo ya kwankwasa kofa, nan da nan za su bude masa. ");
INSERT INTO hauulb_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Masu albarka ne wadannan bayi, wadanda ubangijinsu za ya tarar suna jiran dawowar sa. Gaskiya ni ke gaya ma ku, zai yi dammara yasa su zazzauna ya ba su abinci shi da kansa. ");
INSERT INTO hauulb_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ko da ubangijinsu ya zo da dare, ko da tsakar dare, ya tarar da su a shirye suna jiransa. Masu albarka ne wadannan bayi. ");
INSERT INTO hauulb_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Kuma ku san wannan, da mai gida ya san lokacin da barawo zai zo, ba zai bari a fasa masa gida a shiga ba. ");
INSERT INTO hauulb_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Sai ku zauna da shiri fa domin ba ku san lokacin da Dan Mutum zai dawo ba.” ");
INSERT INTO hauulb_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Sai Bitrus ya ce masa, “Ubangiji, mu ka ke fadawa wannan misali, ko ga kowa da kowa ne?” ");
INSERT INTO hauulb_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Sai Ubangiji ya ce, “Wanne shugaba ne, mai aminci, mai hikima kuma wanda ubangijinsa za ya damka bayinsa a hannunsa, domin ya kula da su, ya ba su abincinsu a kan lokaci? ");
INSERT INTO hauulb_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Mai albarka ne wannan bawa, wanda ubangijinsa za ya tarar da shi yana yin abin da aka sa shi ya yi. ");
INSERT INTO hauulb_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Hakika, ina gaya maku, zai danka dukan malakarsa a gareshi. ");
INSERT INTO hauulb_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Amma idan wannan bawa, ya ce a cikin zuciyarsa, 'Ubangiji na yayi jinkirin dawowa,' sai ya fara dukan bayin, maza da mata abokan bautarsa, ya ci ya sha, ya bugu, ");
INSERT INTO hauulb_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ubangijin bawan nan zai dawo a lokacin da bawan bai sa tsammani ba, kuma a cikin lokacin da bai sani ba, ya daddatsa shi gunduwa-gunduwa, ya kuma hada shi da marasa aminci. ");
INSERT INTO hauulb_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Bawan nan, ya san halin ubagijinsa, amma bai shirya yayi abin da ubangijinsa yake so ba. Zai sha duka da bulala da yawa. ");
INSERT INTO hauulb_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Amma shi wanda bai sani ba, kuma yayi abin da ba daidai ba, ba zai sha duka da bulala da yawa ba. Dukan wanda aka ba abu da yawa, za a kuma nemi abu da yawa daga wurinsa. Kuma ga wanda aka ba abu da yawa amana, za a nemi abu mafi yawa daga gareshi. ");
INSERT INTO hauulb_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Na zo domin in sa wuta a duniya, na so da ta riga ta kama. ");
INSERT INTO hauulb_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Amma ni, ina da baftisma wadda za a yi mani baftisma da ita, kuma na kagara, da an riga an yi ta! ");
INSERT INTO hauulb_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Kuna zaton na zo duniya domin in kawo salama? Na ce maku a'a, amma tsattsaguwa. ");
INSERT INTO hauulb_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Daga yanzu za a sami mutane biyar a cikin gida daya, kuma za su rarrabu, mutane uku suna gaba da biyu, biyun kuma suna gaba da ukun. ");
INSERT INTO hauulb_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Da da mahaifi za su yi gaba da juna, dan zai yi gaba da mahaifinsa. Mahaifiya za ta yi gaba da diyarta, diya kuma gaba da mahafiyarta; uwar miji za ta yi gaba da matar danta, matar da kuma gaba da uwar mijinta.” ");
INSERT INTO hauulb_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesu, ya kuma gaya wa taron, “Da kun ga hadari ya taso daga yamma, nan da nan sai ku ce za a yi ruwa, haka kuwa ya kan zama. ");
INSERT INTO hauulb_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Idan iska tana busowa daga kudu sai ku ce za a yi zafi mai tsanani, haka kuwa ya kan faru. ");
INSERT INTO hauulb_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Munafukai, kun iya fasarta yanayin kasa da sama, amma baku iya fasarta abin da yake faruwa yanzu ba? ");
INSERT INTO hauulb_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Me ya sa ba ku iya gane abin da zai tamake ku? ");
INSERT INTO hauulb_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Idan kuna tafiya wurin shari'a da abokin husumarka, ka yi kokari ku daidaita tun a kan hanya domin kada ya kai ka wurin mai shari'a. Domin kada mai shari'a ya mika ka ga mai tsaron kurkuku, shi kuwa mai tsaron kurkuku ba zai nuna maka sani a cikin kurkuku ba. ");
INSERT INTO hauulb_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Na gaya maka, ba za ka iya fitowa ba sai ka biya dukan kudin da a ke binka? ");
INSERT INTO hauulb_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","A lokacin, wadansu mutane suka gaya masa game da galilawa wadanda Bilatus ya gauraye jininsu da hadayunsu. ");
INSERT INTO hauulb_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Sai Yesu ya amsa masu yace “Kuna tsammani wadannan Galilawa sun fi duk sauran Galilawan zunubi ne, da suka sha azaba haka? ");
INSERT INTO hauulb_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","A'a, ina gaya maku. In ba ku tuba ba, dukanku za ku halaka kamarsu. ");
INSERT INTO hauulb_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ko kuwa mutane goma sha takwas din nan da suna Siluwam wadanda hasumiya ta fado a kansu ta kashe su, kuna tsamani sun fi duk sauran mutanen Urushalima laifi ne? ");
INSERT INTO hauulb_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ina gaya maku ba haka bane. Amma duk wanda ya ki tuba, dukanku za su hallaka” ");
INSERT INTO hauulb_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Yesu ya fada wannan misali, “Wani mutum yana da baure wanda ya shuka a garkar inabinsa sai ya zo neman 'ya'yan itacen amma bai samu ba. ");
INSERT INTO hauulb_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Sai mutumin ya ce wa mai kula da garkar, “ka ga, shekara uku kenan nake zuwa neman 'ya'yan wannan baure, amma ban samu ba. A sare shi. Yaya za a bar shi ya tsare wurin a banza? ");
INSERT INTO hauulb_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Sai mai lura da garkar ya amsa yace, 'Ka dan ba shi lokaci kadan in yi masa kaftu in zuba masa taki. ");
INSERT INTO hauulb_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","In yayi 'ya'ya shekara mai zuwa to, amma in bai yi 'ya'ya ba sai a sare shi!”' ");
INSERT INTO hauulb_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Wata rana Yesu yana koyarwa a wata majami' a ran Asabaci. ");
INSERT INTO hauulb_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Sai, ga wata mace a wurin shekarunta goma sha takwas tana da mugun ruhu, duk ta tankware, ba ta iya mikewa. ");
INSERT INTO hauulb_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Da Yesu ya gan ta, sai ya kira ta ya ce mata, an warkar da ke daga wannan cuta.” ");
INSERT INTO hauulb_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Sai Yesu ya dora hannunsa a kanta, nan da nan sai ta mike a tsaye ta fara daukaka Allah. ");
INSERT INTO hauulb_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Amma shugaban majami'a yayi fushi domin Yesu yayi warkarwa a ranar Asabaci. Sai shugaban ya amsa yace wa jama'a, “Akwai ranaku shida da ya kamata a yi aiki. Ku zo domin a warkar da ku amma ba ranar Asabaci ba.” ");
INSERT INTO hauulb_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Amma Ubangiji ya amsa masa ya ce, “Munafukai! Ashe kowannenku ba ya kwance Jakinsa ko Sa daga turkensa ya kai shi banruwa ran Asabaci? ");
INSERT INTO hauulb_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ashe wannan 'yar gidan Ibrahim, wanda shaidan ya daure ta shekara goma sha takwas, wato ba za a iya kwance ta a ranar Asabaci kenan ba? ");
INSERT INTO hauulb_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Da ya fada wadannan abubuwa, dukansu da suka yi adawa da shi suka kunyata, duk taron kuwa suka yi ta farin ciki da abubuwa masu daraja da yayi. ");
INSERT INTO hauulb_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Sai Yesu ya ce, “Yaya za a misalta mulkin Allah, kuma da me zan kwatanta shi? ");
INSERT INTO hauulb_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Yananan kamar kwayar mastad, wanda wani mutum ya dauka ya jefa ta a lambunsa, ta kuma yi girma ta zama gagarumin itace, har tsuntsaye suka yi shekarsu a rassanta.” ");
INSERT INTO hauulb_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ya sake cewa, “Da me zan kwatanta mulkin Allah? ");
INSERT INTO hauulb_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Yana kamar yisti wanda wata mace ta dauka ta cuda da mudu uku na garin alkama don ya kumburar da shi.” ");
INSERT INTO hauulb_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesu ya ziyarci kowanne birni da kauye, a hanyar sa ta zuwa Urushalima yana koyar da su. ");
INSERT INTO hauulb_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Sai wani ya ce masa, “Ubangiji, wadanda za su sami ceto kadan ne?” Sai ya ce masu, ");
INSERT INTO hauulb_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Ku yi kokari ku shiga ta matsatsiyar kofa, domin na ce maku, mutane dayawa za su nemi shiga amma ba za su iya shiga ba. ");
INSERT INTO hauulb_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","In dai maigida ya riga ya tashi ya rufe kofa, sannan za ku tsaya a waje kuna kwankwasa kofar kuna cewa, 'Ubangiji, Ubangiji, bari mu shiga ciki'. Sai ya amsa yace maku, 'Ni ban san ku ba ko daga ina ku ka fito.' ");
INSERT INTO hauulb_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Sannan za ku ce, 'Mun ci mun sha a gabanka, ka kuma yi koyarwa a kan titunanmu.' ");
INSERT INTO hauulb_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Amma zai amsa ya ce, “Ina gaya maku, ban san ko daga ina ku ka fito ba, ku tafi daga wurina, dukanku masu aikata mugunta!' ");
INSERT INTO hauulb_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Za a yi kuka da cizon hakora a lokacin da kun ga Ibrahim, da Ishaku, da Yakubu da dukan annabawa a mulkin Allah amma ku-za a jefar da ku waje. ");
INSERT INTO hauulb_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Za su zo daga gabas, yamma, kudu, da arewa, za su ci a teburin abinci a mulkin Allah. ");
INSERT INTO hauulb_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ku san da wannan, na karshe za su zama na farko, na farko kuma za su zama na karshe.” ");
INSERT INTO hauulb_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Nan take, wadansu farisiyawa suka zo suka ce masa, “Ka tafi daga nan domin Hirudus yana so ya kashe ka.” ");
INSERT INTO hauulb_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yesu ya ce, “Ku tafi ku gaya wa dilan nan cewa, 'Duba, na fitar da aljanu, ina warkarwa yau da gobe, kuma a rana ta uku kuwa zan gama aiki na.' ");
INSERT INTO hauulb_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ko da kaka, dole ne in ci gaba da tafiyata yau, da gobe, da kuma jibi, don bai dace a kashe annabi nesa da Urushalima ba. ");
INSERT INTO hauulb_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Urushalima, Urushalima masu kisan annabawa, masu jifan wadanda aka aiko gare ku. Sau nawa ne ina so in tattara 'ya'yanki kamar yadda kaza take tattara 'ya'yanta a cikin fukafukanta, amma ba ki so wannan ba. ");
INSERT INTO hauulb_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Duba, an yashe gidanki. Ina kwa gaya maku ba za ku kara ganina ba sai ran da kuka ce, 'Albarka ta tabbata ga mai zuwa da sunan Ubangiji.'” ");
INSERT INTO hauulb_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Wata ranar Asabaci, ya shiga gidan wani daya daga cikin shugabanin Farisawa domin cin abinci, mutane kuwa suna sa masa idanu. ");
INSERT INTO hauulb_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Sai ga wani a gabansa mai ciwon fara. ");
INSERT INTO hauulb_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesu ya tambaye masanan attaura da Farisawa, “Ya halata a wakar a ranan Asabaci, ko a'a?” ");
INSERT INTO hauulb_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Amma suka yi shiru. Yesu kuwa ya kama shi, ya warkar da shi, ya kuma sallame shi. ");
INSERT INTO hauulb_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Sai yace masu, “Wanene a cikinku in yana da jaki ko takarkari ya fadi a rijiya ran Asabaci, ba zai fitar da shi nan da nan ba?” ");
INSERT INTO hauulb_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Sai suka kasa ba da amsar wadannan abubuwa. ");
INSERT INTO hauulb_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Sa'adda Yesu ya lura da yadda wadanda aka gayyato sun zabi mazaunan alfarma, sai ya ba su misali yana ce masu, ");
INSERT INTO hauulb_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Sa'adda wani ya gayyace ka zuwa bikin aure, kada ka zauna a wuri mai daraja, domin yana yiwuwa an gayyaci wani wanda ya fi ka daraja. ");
INSERT INTO hauulb_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Sa'adda wanda ya gayyace ku duka biyu ya zo, zai ce maka, 'Ka ba mutumin nan wurinka,' sa'annan a kunyace za ka koma mazauni mafi kaskanci. ");
INSERT INTO hauulb_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Amma idan an gayyace ka biki, sai ka je ka zauna a wuri mafi kaskanci, domin idan wanda ya gayyace ka ya zo, yana iya ce maka, 'Aboki, hawo nan mana'. Sannan za ka sami girma kenan a gaban dukan wadanda kuke zaune tare a kan teburi. ");
INSERT INTO hauulb_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Duk wanda ya daukaka kansa, za a kaskantar da shi, wanda ya kaskantar da kansa, kuma daukaka shi za a yi”. ");
INSERT INTO hauulb_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Yesu ya ce wa mutumin da ya gayyace shi, “Idan za ka gayyaci mutum cin abinci ko biki, kada ka gayyaci abokanka, ko 'yan'uwanka, ko danginka, ko makwabtanka masu arziki, kamar yadda suna iya gayyatar ka, sai ya zama an maida maka. ");
INSERT INTO hauulb_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Amma idan za ka kira biki sai ka gayyace matalauta, da nakasassu, da guragu, da makafi, ");
INSERT INTO hauulb_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","za ka kuwa sami albarka da yake ba su da hanyar saka maka. Gama za a saka maka a ranar tashin masu adalci.” ");
INSERT INTO hauulb_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Da daya daga cikin wadanda ke zama akan teburi da Yesu ya ji wadannan abubuwa, sai ya ce masa, “Albarka ta tabbata ga wanda zai ci abinci a mulkin Allah!” ");
INSERT INTO hauulb_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Amma Yesu ya ce masa, “Wani mutum ne ya shirya babban biki ya gayyaci mutane da yawa. ");
INSERT INTO hauulb_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Da lokacin biki ya yi, sai ya aiki bawansa ya ce wa wadanda aka gayyata, “Ku zo, duk an shirya kome.” ");
INSERT INTO hauulb_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Sai dukansu, suka fara kawo dalilai. Na farko ya ce masa, 'Na sayi gona, lalle ne in je in gan ta. Ina rokonka ka dauke mani.' ");
INSERT INTO hauulb_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Sai wani ya ce, 'Na sayi shanu garma biyar, ina so in gwada su. Ina ronkan ka, ka dauke mani.' ");
INSERT INTO hauulb_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Wani mutum kuma ya ce, 'Na yi aure, don haka ba zan iya zuwa ba.' ");
INSERT INTO hauulb_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Da bawan ya zo ya fadi wa maigidansa wadannan abubuwa, sai maigidan yayi fushi, ya ce wa bawansa, jeka da sauri ka bi cikin titunan birni da kwararo-kwararo, ka kawo gajiyayyu, da nakasassu, da makafi, da guragu.' ");
INSERT INTO hauulb_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Sai bawan ya ce, 'Maigida, abin da ka umarta an gama, amma har yanzu da sauran wuri.” ");
INSERT INTO hauulb_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Sai maigidan ya ce wa bawan, 'Jeka, ka bi kwararo-kwararo da hanyoyin karkara, ka rinjayi mutane su shigo, don a cika gidana. ");
INSERT INTO hauulb_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Gama ina gaya maku, babu ko daya daga cikin mutanen da na gayyata da farko da zai dandana bikina.” ");
INSERT INTO hauulb_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ana nan, taron suna tafiya tare da shi, sai ya juya ya ce masu, ");
INSERT INTO hauulb_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Duk mai zuwa wurina amma bai ki mahaifinsa da mahaifiyarsa, da matarsa, da 'ya'yansa, da 'yan'uwansa maza da mata ba - I, har da ransa ma, ba zai iya zama almajirina ba. ");
INSERT INTO hauulb_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Duk wanda bai dauki gijiyensa ya biyo ni ba, ba zai iya zama almajirina ba. ");
INSERT INTO hauulb_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Wanene a cikinku wanda yake niyyar gina bene, da ba zai zauna ya yi lissafin abin da zai kashe ba tun da farko, ko yana da ishashen kudi da zai iya kare aikin? ");
INSERT INTO hauulb_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Kada ya zama bayan da ya sa harsashin ginin, ya kasa gamawa, har duk wadanda suka gani su fara yi masa ba'a, ");
INSERT INTO hauulb_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","su rika cewa, ga mutumin nan ya fara gini amma ya kasa gamawa.' ");
INSERT INTO hauulb_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ko kuwa wanne sarki ne, in za shi je yaki da wani sarki, da ba zai zauna da farko ya yi shawara ya ga ko shi mai jarumawa dubu goma zai iya karawa da dayan sarkin mai jarumawa dubu ashirin ba? ");
INSERT INTO hauulb_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","In kuwa ba zai iya ba, to tun wancan yana nesa, sai ya aiki wakili ya kuma tambayo sharudan salama. ");
INSERT INTO hauulb_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Haka ma, ba wani a cikinku wanda bai rabu da duk abin da ya mallaka ba, da zai iya zama almajirina.” ");
INSERT INTO hauulb_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Gishiri abu ne mai kyau, amma idan gishiri ya sane, da me za a dadada shi? ");
INSERT INTO hauulb_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ba shi da wani anfani a kasa, ko ya zama taki. Sai dai a zubar kawai. Duk mai kunnen ji, ya ji.” ");
INSERT INTO hauulb_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","To sai duk masu karbar haraji da masu zunubi suna ta zuwa wurin Yesu suna sauraronsa. ");
INSERT INTO hauulb_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Dukan Farisawa da Marubuta suna ta gunaguni da junansu, cewa, “Wannan mutum yana karbar masu zunubi, har ma tare suke cin abinci.” ");
INSERT INTO hauulb_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Yesu ya fadi wannan misali, ya ce, ");
INSERT INTO hauulb_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Idan waninku yana da tumaki dari, sai dayarsu ta bace, wato ba zai bar tasa'in da taran nan a makiyaya, ya bi sawun wadda ta bata gudan nan har sai ya same shi ba? ");
INSERT INTO hauulb_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Idan kuwa ya same ta, sai ya dauke ta a kafadarsa yana farin ciki. ");
INSERT INTO hauulb_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","In ya dawo gida, sai ya kira abokansa da makwabta, yace masu, 'Ku taya ni murna don na samo tunkiyata da ta bata.' ");
INSERT INTO hauulb_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ina gaya maku, haka kuma za a yi farin ciki a sama, a kan mai zunubi guda da ya tuba, fiye da kan masu adalci tassa'in da tara wadanda ba su bukatar tuba. ");
INSERT INTO hauulb_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ko kuwa wacce mace ce, in tana da kudi azurfa guda goma, in ta batar da daya, ba za ta kunna fitila ta share gidan, ta yi ta neman shi har sai ta same shi ba? ");
INSERT INTO hauulb_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","In kuwa ta same shi sai ta tara kawayenta da makwabtanta, ta ce, 'Ku taya ni farin ciki don na sami kudin nan nawa da ya bace.' ");
INSERT INTO hauulb_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Haka nake gaya maku, abin farin ciki ne ga mala'ikun Allah idan mai zunubi guda ya tuba.” ");
INSERT INTO hauulb_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Sai Yesu ya ce, “Akwai wani mutum mai 'ya'ya biyu maza, ");
INSERT INTO hauulb_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","sai karamin ya ce wa mahaifinsa, 'Baba, bani rabona daga cikin dukiyarka.' Sai mahaifinsa ya raba masu dukiyarsa tsakaninsu. ");
INSERT INTO hauulb_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Bayan 'yan kwanaki kadan, sai karamin dan ya tattara duk mallakarsa, ya kama hanya zuwa wata kasa mai nisa. A can ya batas da kudinsa, yana sayan abubuwan da ba ya bukata, ya kuma batas da kudinsa a wajen masha'a. ");
INSERT INTO hauulb_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Bayan da ya batas da duk abin da ya ke da shi, sai aka yi babbar yunwa a kasar, sai ya shiga fatara. ");
INSERT INTO hauulb_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ya je ya mika kansa domin aiki ga wani dan kasar, sai ya aike shi cikin gonakinsa domin ya rika ba aladu abinci. ");
INSERT INTO hauulb_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Har yayi marmarin ya ci daga cikin barbashin da aladu suke ci, domin babu wanda yake ba shi wani abu ya ci. ");
INSERT INTO hauulb_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Amma da hankalinsa ya dawo, ya ce, 'Barorin mahaifina su nawa ne da suke da abinci isasshe, amma ina nan a nan, ina mutuwa sabili da yunwa! ");
INSERT INTO hauulb_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Zan tashi, in tafi gun mahaifina, in ce masa, “Baba, na yi wa sama zunubi, na kuma saba maka. ");
INSERT INTO hauulb_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ban cancanci a kara kira na danka ba; ka mai da ni kamar daya daga cikin barorinka.'” ");
INSERT INTO hauulb_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Sai ya tashi, ya taho wurin mahaifinsa. Amma tun yana daga nesa, sai mahaifinsa ya hango shi tausayi ya kama shi, ya ruga a guje, ya rungume shi, ya yi ta sumbatar sa. ");
INSERT INTO hauulb_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Dan kuma ya ce masa, 'Baba, na yi wa sama zunubi, na kuma saba maka. Ban isa a kara kira na danka ba.' ");
INSERT INTO hauulb_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Amma mahaifinsa ya ce wa bayinsa, 'Ku yi hamzari ku kawo riga mafi kyau, ku yafa masa. Ku sa masa zobe a hanunsa da takalma a kafafunsa. ");
INSERT INTO hauulb_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Sa'annan a kawo kiwataccen marakin nan, a yanka. Mu yi buki! ");
INSERT INTO hauulb_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Gama da na ya mutu a da, amma yanzu yana a raye. Ya bata a da, amma a yanzu an same shi.' Sai suka fara liyafa. ");
INSERT INTO hauulb_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","A wannan lokacin, babban dansa yana gona. Da ya kai kusa da gida, ya ji ana kade-kade da raye-raye. ");
INSERT INTO hauulb_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Sai ya kira wani bawan gidan, ya tambayi manufar wadannan abubuwa. ");
INSERT INTO hauulb_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Bawan ya ce masa, 'Dan'uwanka ne ya dawo gida, mahaifinka kuma ya yanka kiwataccen marakin nan, saboda ya dawo gida lafiya.' ");
INSERT INTO hauulb_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Amma dan'uwan ya yi fushi, ya ki ya shiga ciki, mahaifinsa kuwa ya fito, ya roke shi. ");
INSERT INTO hauulb_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Amma babban dan ya amsa wa ubansa ya ce, 'Duba, duk yawan shekarun nan da nake bauta maka, ban taba karya umarnin ka ba, duk da haka ba ka taba bani ko dan taure da zan yi shagali tare da abokaina ba, ");
INSERT INTO hauulb_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","amma da dan nan naka ya zo wanda ya fallasar da dukiyarka a kan karuwai, ka yanka masa kiwataccen marakin nan. ");
INSERT INTO hauulb_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Sai mahaifin ya ce masa, 'Dana, ai kullum kana tare da ni, duk abin da yake nawa naka ne. ");
INSERT INTO hauulb_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Amma, daidai ne a yi murna da farinciki, don dan'uwan nan naka da ya mutu, amma yanzu yana da rai, da ya bata, amma yanzu an same shi.'” ");
INSERT INTO hauulb_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesu ya kuma ce wa almajiransa, “Akwai wani mai arziki da yake da wakili, sai aka yi karan sa da cewa wannan wakili yana fallasar masa da dukiya. ");
INSERT INTO hauulb_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Sai mai arziki ya kira shi ya ce masa, 'Labarin me nake ji game da kai? Kawo lissafin wakilcin ka, don ba za ka sake zama wakili na ba.' ");
INSERT INTO hauulb_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Sai wakilin ya ce a ransa, 'Kaka zan yi, da yake maigida na zai karbe wakilci daga hannuna? Gashi, ba ni da karfin noma ina kuwa jin kunya in yi roko. ");
INSERT INTO hauulb_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Na san abin da zan yi domin idan an fitar da ni daga wakilcin, mutane su karbe ni a gidajensu. ");
INSERT INTO hauulb_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Sai wakilin ya kira kowanne daya da maigidansa ke bi bashi, yace wa na farkon, 'Nawa maigida na yake bin ka?' ");
INSERT INTO hauulb_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ya ce, 'Garwan mai dari.' Sai ya ce masa, 'Ga takardarka, maza ka zauna, ka rubuta hamsin.' ");
INSERT INTO hauulb_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ya kuma ce wa wani, 'Nawa ake binka?' Ya ce, 'Buhu dari na alkama.' Ya ce masa, 'Ga tarkardarka, ka rubuta tamanin.' ");
INSERT INTO hauulb_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Sai maigida ya yaba wa wakilin nan marar gaskiya saboda wayonsa. Gama 'ya'yan zamanin nan a ma'ammalar su da mutanen zamaninsu sun fi 'ya'yan haske wayo. ");
INSERT INTO hauulb_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ina gaya maku ku yi abuta ta dukiya ta rashin gaskiya, saboda idan ya kare, su karbe ku a gidaje masu dauwama. ");
INSERT INTO hauulb_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Wanda yake da aminci a karamin abu, mai aminci ne a babban abu, wanda yake marar gaskiya a karamin abu, marar gaskiya ne a babban abu. ");
INSERT INTO hauulb_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Idan fa ba ku yi aminci da dukiya mara adalci ba, wa zai amince maku da dukiya ta gaskiya? ");
INSERT INTO hauulb_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Idan kuma ba ku yi aminci da kudin wani ba, wa zai ba ku kudin da ke naku? ");
INSERT INTO hauulb_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ba bawan da zai iya bauta wa iyayengiji biyu, ko dai ya ki daya, ya so daya ko kuwa ya amince wa dayan, ya raina dayan. Ba za ku iya bauta wa Allah ku kuma bauta wa dukiya ba.” ");
INSERT INTO hauulb_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Da Farisawa da ke da kaunar kudi suka ji dukan wadannan abubuwa, suka yi masa ba'a. ");
INSERT INTO hauulb_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Sai ya ce masu, “Ku ne masu baratar da kanku a gaban mutane, amma Allah ya san zuciyarku. Abin da mutane suke girmamawa kwarai abin kyama ne a gun Allah. ");
INSERT INTO hauulb_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Attaura da litattafan annabawa suna nan har zuwan Yahaya. Tun daga lokacin nan ake yin bisharar mulkin Allah, kowa kuma yana kokarin kutsawa zuwa cikinta. ");
INSERT INTO hauulb_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Duk da haka, zai fi sauki sama da kasa su shude, da ko digo daya na attaura ya shude. ");
INSERT INTO hauulb_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Duk wanda ya saki matansa ya auri wata ya aikata zina, kuma wanda ma ya auri sakakkiya ya aikata zina. ");
INSERT INTO hauulb_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Akwai wani mai arziki, mai sa tufafi na alfarma masu tsada yana shagalin sa kowace rana. ");
INSERT INTO hauulb_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Aka ajiye wani gajiyayye a kofarsa, mai suna liazaru wanda duk jikinsa miki ne, ");
INSERT INTO hauulb_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Shi kuwa yana marmarin ya koshi da barbashin da ke fadowa daga teburin mai arzikin nan har ma karnuka sukan zo suna lasar mikinsa. ");
INSERT INTO hauulb_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ana nan sai gajiyayyen nan ya mutu, malaiku kuma suka dauke shi suka kai shi wurin Ibrahim. Mai arzikin ma ya mutu, aka kuma binne shi, ");
INSERT INTO hauulb_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","yana cikin hades yana shan azaba, sai ya daga kai ya hangi Ibrahim daga nesa, da Li'azaru a kirjinsa. ");
INSERT INTO hauulb_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Sai ya yi kira ya ce, 'Baba Ibrahim, ka ji tausayi na, ka aiko Li'azaru ya tsoma dan yatsansa a ruwa ya sanyaya harshena, don azaba nake sha a cikin wannan wuta.' ");
INSERT INTO hauulb_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Amma Ibrahim ya ce, 'Yaro, ka tuna fa a zamanka na duniya ka sha duniyarka, ka kuma karba abubuwa masu kyau, amma Li'azaru kuma sai wahala. Amma yanzu dadi ake bashi a nan, kai kuwa kana shan azaba. ");
INSERT INTO hauulb_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Banda haka ma, akwai rami mai zurfi, domin wadanda suke son ketarewa zuwa wurinku kada su iya, kada kuma kowa ya ketaro zuwa wurinmu daga can.' ");
INSERT INTO hauulb_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Sai mai arziki ya ce, 'To ina rokonka, Baba Ibrahim, ka aike shi zuwa gidan mahaifina - ");
INSERT INTO hauulb_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","domin ina da 'yan'uwa maza biyar, ya je ya yi masu gargadi kada su ma su zo wurin azaban nan.' ");
INSERT INTO hauulb_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Amma Ibrahim ya ce, 'Suna da Musa da annabawa; bari su saurare su.' ");
INSERT INTO hauulb_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Sai mai arziki ya amsa, 'A'a, Baba Ibrahim, idan wani daga cikin matattu ya je wurinsu, zasu tuba.' ");
INSERT INTO hauulb_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Amma Ibrahim ya ce masa, 'In dai har basu saurari Musa da na annabawa ba, ko da wani ya tashi daga matattu ma, ba za su rinjayu ba.'” ");
INSERT INTO hauulb_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Sai Yesu ya ce wa almajiransa, 'Babu shakka akwai sanadodin tuntube da za su sa mu yin zunubi amma kaiton wanda shine sanadin su! ");
INSERT INTO hauulb_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Zai gwammaci a rataya masa dutsen nika a wuyansa, a jefar da shi a cikin teku fiye da wanda zai zama sanadiyar tuntube ga wadannan kananan. ");
INSERT INTO hauulb_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ku kula da kanku. Idan dan'uwanka ya yi laifi, ka tsauta masa, in kuwa ya tuba ka yafe masa. ");
INSERT INTO hauulb_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Idan ya yi maka laifi sau bakwai a rana daya sa'annan ya juyo wurinka sau bakwai ya ce, 'Na tuba,' ya wajabta ka yafe masa!” ");
INSERT INTO hauulb_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Sai Manzannin suka ce wa Ubangiji, 'Ka kara mana bangaskiya.' ");
INSERT INTO hauulb_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ubangiji kuwa ya ce, “In kuna da bangaskiya kamar kwayar mastad, za ku ce wa wannan durumin, 'Ka tuge, ka kuma dasu a cikin teku,' zai yi biyayya da ku. ");
INSERT INTO hauulb_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Amma wanene a cikinku, idan yana da bawa mai yin masa noma ko kiwon tumaki, da zarar ya dawo daga jeji, zai ce masa, 'Maza zo ka zauna ka ci abinci'? ");
INSERT INTO hauulb_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ba zai ce masa, 'Ka shirya mani wani abu domin in ci ka kuma yi damara, ka yi mini hidima har in gama ci da sha. Bayan haka sai ka ci ka sha'? ");
INSERT INTO hauulb_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ba zai yi wa bawan nan godiya ba domin ya yi biyayya da abubuwan da aka umarce shi ya yi, ko zai yi haka? ");
INSERT INTO hauulb_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Haka kuma, idan kuka bi duk abin da aka umarce ku, sai ku ce, 'Mu bayi ne marasa amfani. Mun dai yi abin da yake wajibi ne kurum.'” ");
INSERT INTO hauulb_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Wata rana yana tafiya zuwa Urushalima, sai ya bi iyakar kasar Samariya da Galili. ");
INSERT INTO hauulb_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Yayin da yana shiga wani kauye kenan, sai wadansu kutare maza guda goma suka tarye shi suna tsaye daga nesa da shi ");
INSERT INTO hauulb_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","sai suka daga murya suka ce, “Yesu, Ubangiji, ka yi mana jinkai.” ");
INSERT INTO hauulb_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Da ya gan su, ya ce masu, “Ku je ku nuna kanku a wurin firistoci.” Ya zama sa'adda suke tafiya, sai suka tsarkaka. ");
INSERT INTO hauulb_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Daya daga cikinsu da ya ga an warkar da shi, ya koma, yana ta daukaka Allah da murya mai karfi. ");
INSERT INTO hauulb_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ya fadi a gaban Yesu, yana masa godiya. Shi kuwa Basamariye ne. ");
INSERT INTO hauulb_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yesu ya amsa ya ce, “Ba goma ne aka tsarkake ba? Ina sauran taran? ");
INSERT INTO hauulb_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Babu wani da ya dawo ya girmama Allah sai wannan bakon kadai?” ");
INSERT INTO hauulb_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Sai ya ce masa, “Tashi, kayi tafiyarka. Bangaskiyarka ta warkar da kai.” ");
INSERT INTO hauulb_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Da Farisawa suka tambaye shi lokacin da mulkin Allah zai bayyana, Yesu ya amsa masu ya ce, “Mulkin Allah ba lura ake yi da shi ba. ");
INSERT INTO hauulb_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ba kuwa za a ce, 'Gashi nan!' Ko kuwa, 'Ga shi can ba!' domin mulkin Allah yana tsaknaninku.” ");
INSERT INTO hauulb_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Yesu ya ce wa almajiran, “Kwanaki na zuwa da za ku yi begen ganin rana daya cikin ranakun Dan Mutum, amma ba zaku gani ba. ");
INSERT INTO hauulb_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Za su ce maku, 'Duba can! 'Duba nan!' Amma kada ku je kuna dubawa, ko kuwa ku bi su. ");
INSERT INTO hauulb_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Kamar yadda walkiya take haskakawa daga wannan bangaren sararin sama zuwa wancan bangaren, haka ma dan mutum zai zama a ranar bayyanuwarsa. ");
INSERT INTO hauulb_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Amma lalle sai ya sha wahaloli dabam dabam tukuna, mutanen zamanin nan kuma su ki shi. ");
INSERT INTO hauulb_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Kamar yadda ya faru a zamanin Nuhu, haka kuma zai faru a lokacin bayyanar Dan Mutum. ");
INSERT INTO hauulb_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ana ci, ana sha, ana aure, ana aurarwa, har zuwa ga ranar da Nuhu ya shiga jirgi - ruwan tufana kuma ya zo, ya hallaka su duka. ");
INSERT INTO hauulb_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Haka ma aka yi a zamanin Lutu, ana ci, ana sha, ana saye, ana sayarwa, ana shuke-shuke da gine-gine. ");
INSERT INTO hauulb_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Amma a ranar da Lutu, ya fita daga Saduma, aka zubo wuta da kibiritu daga sama, aka hallaka su duka. ");
INSERT INTO hauulb_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Haka kuma zai zama a ranar bayyanuwar Dan Mutum. ");
INSERT INTO hauulb_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","A ranar nan fa, wanda yake kan soro kada ya sauka domin daukan kayansa daga cikin gida. Haka kuma wanda yake gona kada ya dawo. ");
INSERT INTO hauulb_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ku tuna fa da matar Lutu. ");
INSERT INTO hauulb_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Duk mai son ransa, zai rasa shi, amma duk wanda ya rasa ransa, zai same shi. ");
INSERT INTO hauulb_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ina gaya maku, a wannan dare za a sami mutum biyu a gado daya. Za a dauka daya, a kuma bar dayan. ");
INSERT INTO hauulb_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Za a sami mata biyu suna nika tare. Za a dauka daya a bar daya.” ");
INSERT INTO hauulb_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","“Za a ga mutum biyu a gona. Za a dauki daya a bar daya.” ");
INSERT INTO hauulb_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Sai suka tambaye shi, “Ina, Ubangiji?” Sai ya ce masu, “Duk in da gangar jiki yake, a nan ungulai sukan taru.” ");
INSERT INTO hauulb_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ya kuma ba su wani misali cewa ya kamata kullum su yi addu'a kada kuma su karaya, ");
INSERT INTO hauulb_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","yace, “A wani gari an yi wani alkali mara tsoron Allah, kuma baya ganin darajan mutane. ");
INSERT INTO hauulb_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Akwai wata mace gwauruwa a wannan garin, wadda ta rika zuwa wurinsa, tana ce masa, 'Ka taimake ni yanda zan sami adalci a kan abokin gaba na.' ");
INSERT INTO hauulb_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","An dade bai so ya taimaka mata, amma daga baya sai ya ce a ransa, 'ko da yake ba na tsoron Allah, ba na kuma darajanta mutane, ");
INSERT INTO hauulb_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","duk da haka saboda gwauruwar nan ta dame ni, zan taimake ta domin ta sami adalci, yadda ba za ta gajiyar da ni da zuwanta wurina ba.'” ");
INSERT INTO hauulb_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Sai Ubangiji ya ce, “Ku ji fa abin da alkalin nan marar gaskiya ya fada. ");
INSERT INTO hauulb_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","A yanzu Allah ba zai biya wa zababbunsa da suke yi masa kuka dare da rana hakkinsu ba? Zai yi jinkiri a wajen taimakonsu ne? ");
INSERT INTO hauulb_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ina gaya maku, zai biya masu hakkin su da wuri. Amma sa'adda Dan Mutum ya zo, zai tarar da bangaskiya a duniya?” ");
INSERT INTO hauulb_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ya sake ba da misalin nan ga wadansu masu amincewa da kansu, wai su masu adalci ne, har suna raina sauran mutane, ");
INSERT INTO hauulb_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Wadansu mutane biyu suka shiga haikali domin yin addu'a - daya Bafarise, dayan kuma mai karbar haraji ne. ");
INSERT INTO hauulb_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Sai Bafarisen ya mike, ya yi addu'a a kan wadannan abubuwa game da kansa, 'Allah, na gode maka, da cewa ni ba kamar sauran mutane dake mazambata ba, ko marasa adalci, ko mazinata, ko kamar wannan mai karbar harajin. ");
INSERT INTO hauulb_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Duk mako ina azumi sau biyu. Nakan bayar da zakkar dukan abin da na samu.' ");
INSERT INTO hauulb_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Amma mai karbar harajin kuwa yana tsaye daga can nesa, bai yarda ya daga kai sama ba, sai dai yana bugun kirjin sa, yana cewa, 'Allah, ka yi mini jinkai, ni mai zunubi.' ");
INSERT INTO hauulb_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ina gaya maku, wannan mutum ya koma gidansa baratacce, ba kamar dayan ba, domin dukan wanda ya daukaka kansa, za a kaskantar da shi, amma duk wanda kaskantar da kansa kuwa daukaka shi za a yi.” ");
INSERT INTO hauulb_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Sai mutanen suka kawo masa jariransu, domin ya taba su, da almajiransa suka ga haka, sai suka kwabe su. ");
INSERT INTO hauulb_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Amma Yesu ya kira su wurinsa, ya ce, “Ku bar yara kanana su zo wurina, kada ku hana su. Ai mulkin Allah na irin su ne. ");
INSERT INTO hauulb_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Gaskiya ina gaya maku, duk wanda bai karbi mulkin Allah kamar karamin yaro ba, lallai ba zai shige shi ba.” ");
INSERT INTO hauulb_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Wani shugaban jama'a ya tambaye shi ya ce “Malam managarci, me zan yi in gaji rai Madawwami?” ");
INSERT INTO hauulb_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesu ya ce masa, “Don me ka kira ni managarci? Babu wani managarci sai Allah kadai. ");
INSERT INTO hauulb_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ka dai san dokokin - kada ka yi zina, kada ka yi kisankai, kada ka yi sata, kada ka yi shaidar karya, ka girmama mahaifinka da mahaifiyarka.” ");
INSERT INTO hauulb_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Sai shugaban ya ce, “Dukan wadannan abubuwa na kiyaye su tun a kuruciya ta.” ");
INSERT INTO hauulb_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Da Yesu ya ji haka, ya ce masa, “Abu daya ne kadai ya rage maka. Dole ne ka sayar da dukan mallakarka, ka rarraba wa gajiyayyu, za ka kuma sami wadata a sama - sa'annan ka zo ka biyoni.” ");
INSERT INTO hauulb_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Amma da mai arzikin ya ji wadannan abubuwa, sai yayi bakin ciki kwarai, don shi mai arziki ne sosai. ");
INSERT INTO hauulb_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesu kuwa, da ya ga ransa ya baci, sai ya ce, “Yana da wuya masu dukiya su shiga mulkin Allah! ");
INSERT INTO hauulb_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Zai zama da sauki rakumi ya shiga kafar allura, da mai arziki ya shiga mulkin Allah.” ");
INSERT INTO hauulb_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Wadanda suka ji wannan magana suka ce, “Idan hakane wa zai sami ceto kenan?” ");
INSERT INTO hauulb_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesu ya amsa, “Abin da ya fi karfin mutum, mai yiwuwa ne a gun Allah.” ");
INSERT INTO hauulb_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Sai Bitrus ya ce, “To, ga shi mun bar mallakarmu, mun bi ka.” ");
INSERT INTO hauulb_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesu ya ce masu, “Hakika, ina gaya maku, ba wanda zai bar gida, ko matarsa, ko 'yan'uwansa, ko iyayensa, ko kuma 'ya'yansa, saboda mulkin Allah, ");
INSERT INTO hauulb_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","sa'annan ya kasa samun ninkin ba ninkin a duniyan nan, da rai na har abada a duniya mai zuwa.” ");
INSERT INTO hauulb_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Bayan da ya tara su goma sha biyun nan, ya ce masu, “Ga shi, muna tafiya zuwa Urushalima, duk abubuwan da aka rubuta game da Dan Mutum ta hannun annabawa zasu tabbata. ");
INSERT INTO hauulb_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Gama za a bashe shi ga al'ummai, a yi masa ba'a, a wulakanta shi, a kuma tofa masa miyau. ");
INSERT INTO hauulb_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Za su yi masa bulala, su kashe shi, a rana ta uku kuma zai tashi.” ");
INSERT INTO hauulb_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Amma ba su fahimci ko daya daga cikin wadannan abubuwa ba, domin zancen nan a boye yake daga garesu, ba su ma gane abin da aka fada ba. ");
INSERT INTO hauulb_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Da ya kusato Yariko, ga wani makaho zaune a gefen hanya, yana bara, ");
INSERT INTO hauulb_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","da ya ji taro na wucewa, sai ya tambaya ko menene. ");
INSERT INTO hauulb_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Suka ce masa Yesu Banazarat ne yake wucewa. ");
INSERT INTO hauulb_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Sai makahon ya ta da murya mai karfi, ya ce, “Yesu, Dan Dauda, ka yi mani jinkai.” ");
INSERT INTO hauulb_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Sai wadanda suke gaba suka kwabe shi, suna gaya masa ya yi shiru. Amma ya kara daga murya kwarai da gaske, yana cewa, “Dan Dauda, ka yi mani jinkai.” ");
INSERT INTO hauulb_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Sai Yesu ya tsaya, ya umarta a kawo shi wurinsa. Da makahon ya zo kusa, sai Yesu ya tambaye shi, ");
INSERT INTO hauulb_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Me kake so in yi maka?” Ya ce, “Ubangiji, ina so in samu gani.” ");
INSERT INTO hauulb_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesu ya ce masa, “Karbi ganin gari, bangaskiyarka ta warkar da kai.” ");
INSERT INTO hauulb_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Nan take ya samu gani, ya bi Yesu, yana daukaka Allah. Ganin haka, sai duk jama'a suka yabi Allah. ");
INSERT INTO hauulb_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu ya shiga Yariko ya na wucewa cikinta. ");
INSERT INTO hauulb_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Sai ga wani mutum a wurin mai suna Zakka. Shugaba ne na masu karban haraji, kuma mai arziki ne. ");
INSERT INTO hauulb_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Yana kokarin ya ga ko wanene Yesu, amma bai iya gani ba sabo da yawan jama'a, domin shi gajere ne. ");
INSERT INTO hauulb_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Sai ya ruga gaba ya hau itacen baure domin ya gan shi, saboda Yesu zai wuce ta wannan hanya. ");
INSERT INTO hauulb_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Sa'adda Yesu ya zo wurin, ya kalli sama sai ya ce masa, “Zakka, ka sauko da sauri, domin yau dole in sauka a gidanka.” ");
INSERT INTO hauulb_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Sai ya sauko da sauri, ya karbe shi da farin ciki. ");
INSERT INTO hauulb_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Sa'adda dukansu suka ga wannan, sai suka yi gunaguni, cewa, “Ya ziyarci mutum mai zunubi.” ");
INSERT INTO hauulb_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zakka ya tsaya ya ce wa Ubangiji, “Duba, Ubangiji, zan ba matalauta rabin arzikina, idan kuma na cuci wani a kome, zan mai da adadinsa sau hudu.” ");
INSERT INTO hauulb_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesu ya ce masa, “Yau ceto ya shigo wannan gida, domin shi ma dan Ibrahim ne. ");
INSERT INTO hauulb_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Gama Dan Mutum ya zo ne domin ya nemi, ya kuma ceci batattun mutane.” ");
INSERT INTO hauulb_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Da suka ji wadannan abubuwan, ya cigaba da magana, sannan ya fada masu wani misali, domin yana kusa da Urushalima, sai suka yi tsamani mulkin Allah za ya bayyana nan da nan. ");
INSERT INTO hauulb_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Sai ya ce, “Akwai wani mutum mai sarauta wanda ya tafi wata kasa mai nisa domin ya karba wa kansa mulki sa'annan ya dawo. ");
INSERT INTO hauulb_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Sai ya kira bayinsa guda goma, ya ba su fam goma, sai ya ce masu, 'Ku yi kasuwanci da wannan har sai na dawo.' ");
INSERT INTO hauulb_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Amma mutanensa suka ki shi sai suka aiki jakadu bayansa, cewa, 'Ba za mu yarda wannan mutum ya yi mulki a kanmu ba.' ");
INSERT INTO hauulb_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Anan nan sa'adda ya koma kuma, bayan da ya sami mulkin, sai ya ba da umarni a kira masa bayin da ya basu kudi, domin ya san ribar da suka samu wajen kasuwancin da suka yi. ");
INSERT INTO hauulb_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Na farkon ya zo wurinsa, cewa, 'Ubangiji, fam nan na ka ya yi riban fam goma.' ");
INSERT INTO hauulb_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Masaraucin ya ce masa, 'Madalla, bawan kirki. Domin ka yi aminci a karamin abu, za a baka iko kan birane goma.' ");
INSERT INTO hauulb_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Na biyun ya zo, yana cewa, 'Fam na ka, Ubangiji, ya yi ribar fam biyar.' ");
INSERT INTO hauulb_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Sai masarauncin yace masa, 'Ka dauki mulkin birane biyar.' ");
INSERT INTO hauulb_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Wani kuma ya zo, yana cewa, 'Ubangiji, ga fam naka da na ajjiye shi da kyau cikin kaya, ");
INSERT INTO hauulb_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","gama na ji tsoronka, domin kai mutum mai tsanani ne. Kana daukar abu da baka ajiye ba, kana kuma girbin abin da ba ka shuka ba.' ");
INSERT INTO hauulb_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Masarauncin ya ce masa, 'Da kalmominka zan shari'antaka, kai mugun bawa. Ka sani cewa ni mutum mai tsanani ne, ina daukan abinda ban ajiye ba, ina kuma girbin abinda ban shuka ba. ");
INSERT INTO hauulb_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","To don me ba ka kai kudi na wurin masu banki ba, saboda bayan da na dawo zan karbe shi da riba?' ");
INSERT INTO hauulb_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Masaraucin ya ce wa wadanda suke a tsaye a wurin, 'Ku karba fam da ke a wurinsa, ku ba mai fam goman nan.' ");
INSERT INTO hauulb_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Suka ce masa, 'Ubangiji, yana da fam goma.' ");
INSERT INTO hauulb_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","'Ina ce maku, duk wanda yake da abu za a kara masa, amma wadda bai da shi, za a karba sauran da ke wurinsa. ");
INSERT INTO hauulb_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Amma wadannan abokan gabana, wadanda ba sa so in yi mulki bisansu, a kawo su nan a kashe su a gaba na.' ");
INSERT INTO hauulb_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Da ya fadi wadannan abubuwan, sai ya yi gaba, yana tafiya zuwa Urushalima. ");
INSERT INTO hauulb_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ananan sa'adda ya zo kusa da Baitfaji da Baitanya, a kan tudu da a ke kira Zaitun, sai ya aiki almajiransa guda biyu, cewa, ");
INSERT INTO hauulb_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","cewa, “Ku tafi cikin kauye da ke gabanku. Sa'adda ku ka shiga, za ku same dan aholaki da ba a taba hawansa ba. Ku kwance sai ku kawo mani shi. ");
INSERT INTO hauulb_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Idan wani ya tambaye ku, 'Don me ku ke kwance shi?' Ku ce, 'Ubangiji ne ke bukatarsa.” ");
INSERT INTO hauulb_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Wadanda aka aike su suka je sun sami aholakin kamar yadda Yesu ya gaya masu. ");
INSERT INTO hauulb_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Sa'adda suna kwance aholakin, sai masu shi suka ce masu, “Don me ku ke kwance aholakin?” ");
INSERT INTO hauulb_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Suka ce, “Ubangiji yana bukatar sa.” ");
INSERT INTO hauulb_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Suka kawo wa Yesu, suka shimfida tufafinsu akan aholakin sai suka dora Yesu akansa. ");
INSERT INTO hauulb_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Da yana cikin tafiya, suka shimfida tufafinsu akan hanya. ");
INSERT INTO hauulb_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Da ya yi kusa da gangaren tudun Zaitun, sai dukan taron almajiransa suka fara yin murna suna kuma yabon Allah da murya mai karfi domin dukan ayukan al'ajibi da suka gani, ");
INSERT INTO hauulb_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","cewa, “Albarka ta tabbata ga sarki da ke zuwa cikin sunan Uba! Salama a sama da daraja mafi daukaka kuma!” ");
INSERT INTO hauulb_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Wadansu Farisawa daga cikin taron jama'a suka ce masa, “Malam, ka tsauta wa almajiranka.” ");
INSERT INTO hauulb_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yesu ya amsa ya ce, “Ina gaya maku gaskiya, in wadannan sun yi shiru, duwatsu za su yi shewa.” ");
INSERT INTO hauulb_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Sa'adda Yesu yana kusatowa, sai ya yi kuka akan birnin, ");
INSERT INTO hauulb_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","cewa, “Da kun san wannan rana, ko ku ma, abubuwan da ke kawo maku salama! Amma yanzu an boye su daga idanunku. ");
INSERT INTO hauulb_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Gama rana zata ta zo a gareki, da makiyan ki zasu gina ganuwa a kewaye da ke, su kuma fada maki daga kowace gefe. ");
INSERT INTO hauulb_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Za su sare ki kasa tare da 'ya'yanki. Ba za su bar wani dutse akan dan'uwansa ba, domin ba ki lura da lokacin da Allah ya na kokarin ceton ki ba.” ");
INSERT INTO hauulb_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yesu ya shiga Haikalin sai ya fara korar masu sayarwa, ");
INSERT INTO hauulb_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ya na ce masu, “A rubuce yake, 'Gida na zai zama wurin addu'a,' amma kun mayar da shi kogon mafasa.” ");
INSERT INTO hauulb_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yesu yana nan yana koyarwa kowace rana a cikin haikali. Amma manyan firistoci da marubuta da shugabanin jama'a suna so su kashe shi, ");
INSERT INTO hauulb_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","amma ba su sami hanyar yin wannan ba, domin mutane suna sauraron sa sosai. ");
INSERT INTO hauulb_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ana nan wata rana, Yesu yana kan koyarwa a haikali da wa'azin bishara, sai shugaban firistoci da marubuta suka zo wurinsa da dattawa. ");
INSERT INTO hauulb_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Suka yi magana, su na ce masa, “Gaya mana da wanne iko ne ka ke yin wadannan abubuwan? Ko wanene ya baka wannan ikon?” ");
INSERT INTO hauulb_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ya amsa sai ya ce masu, “Ni ma zan yi maku tambaya. Gaya mani game ");
INSERT INTO hauulb_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","da baptisman Yahaya. Daga sama take ko kuwa daga mutane ne?” ");
INSERT INTO hauulb_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Sai suka yi mahawara da junansu, suna cewa, “In mun ce, 'Daga sama,' zai ce, 'To don me ba ku ba da gaskiya gareshi ba?' ");
INSERT INTO hauulb_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Amma in mun ce, 'Daga mutane ne,' dukan mutane za su jejjefe mu da duwatsu, domin sun tabbata a ransu Yahaya annabi ne.” ");
INSERT INTO hauulb_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Sai suka amsa cewa ba su san ko daga ina ne take ba. ");
INSERT INTO hauulb_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yesu yace masu, “To haka ni ma ba zan gaya maku ko da wanne iko nake yin wadannan abubuwan ba.” ");
INSERT INTO hauulb_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ya gaya wa mutane wannan misali, “Wani mutum ya dasa gonar inabi, ya ba wadansu manoma jinginarta, sai ya tafi wata kasa har ya dade. ");
INSERT INTO hauulb_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Da lokacin girbi ya yi sai ya aiki wani bawansa zuwa wurin manoman, saboda su bashi daga cikin anfanin gonar. Amma manoman suka doke shi, sai suka kore shi hannu wofi. ");
INSERT INTO hauulb_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ya aike wani bawa kuma sai suka daddoke shi, suka kunyatar da shi, suka kore shi hannu wofi. ");
INSERT INTO hauulb_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ya kuma sake aike na uku suka yi masa rauni, suka jefar da shi a waje. ");
INSERT INTO hauulb_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Sai mai gonar inabin ya ce, 'Me zan yi? Zan aiki kaunattacen dana. Watakila zasu ba shi daraja.' ");
INSERT INTO hauulb_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Amma sa'adda manoman suka gan shi, suka yi shawara a tsakaninsu, cewa, 'Wannan ne magajin. Bari mu kashe shi, saboda gadon ya zama namu.' ");
INSERT INTO hauulb_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Suka jefar da shi waje daga gonar, suka kashe shi. Menene ubangijin gonar inabin zai yi da su? ");
INSERT INTO hauulb_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Zai zo ya halakar da wadannan manoma, sai ya ba wadansu gonar.” Da suka ji wannan, suka ce, “Allah ya sawake!” ");
INSERT INTO hauulb_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Amma Yesu ya kalle su, sai yace, “Menene ma'anar wannan nassi? 'Dutsen da magina suka ki, an mayar da shi kan kusurwa'? ");
INSERT INTO hauulb_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Duk wanda ya fadi kan dutsen zai farfashe. Amma duk wanda dutsen ya fadi a kansa, zai rugurguza shi.” ");
INSERT INTO hauulb_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Sai marubutan da manyan firistocin suka so su kama shi a wannan sa'a, domin sun sani ya yi wannan misali a kansu ne. Amma sun ji tsoron mutane. ");
INSERT INTO hauulb_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Suna fakonsa, suka aiki magewaya, wadanda suke kamar masu adalci, saboda su sami kuskure cikin maganarsa, don su mika shi ga hukumci da kuma ikon gwamna. ");
INSERT INTO hauulb_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Suka tambaye shi, cewa, “Malam, mun sani da cewa kana fada da koyar da abin ke daidai, kuma ba wanda yake cusa maka ra'ayi, amma kana koyar da gaskiya game da hanyar Allah. ");
INSERT INTO hauulb_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Wai shin doka ne mu biya haraji ga Kaisar, ko babu?” ");
INSERT INTO hauulb_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Amma Yesu ya gane makircinsu, sai ya ce masu, ");
INSERT INTO hauulb_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Nuna mani dinari. Sifar wanene da kuma rubutun wanene akan sa?” Suka ce, “Na Kaisar ne.” ");
INSERT INTO hauulb_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Sai ya ce masu, “To sai ku ba Kaisar abin da ke na Kaisar, ku kuma ba Allah, abin da ke na Allah.” ");
INSERT INTO hauulb_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Marubutan da manyan firistocin ba su sami abin zargi cikin maganarsa, a gaban mutane ba. Suka yi mamakin amsar sa, ba su kuma ce komai ba. ");
INSERT INTO hauulb_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sa'adda wadansu Sadukiyawa suka zo wurinsa, wadan da suka ce babu tashin mattatu, ");
INSERT INTO hauulb_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","suka tambaye shi, cewa, “Malam, Musa ya rubuta mana cewa idan dan'uwan mutum ya mutu, mai mace kuma ba shi da yaro, sai dan'uwansa ya auri matar, ya samar wa dan'uwansa yaro. ");
INSERT INTO hauulb_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Akwai 'yan'uwa guda bakwai kuma na farin ya yi aure, sai ya mutu babu da, ");
INSERT INTO hauulb_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","haka ma na biyun. ");
INSERT INTO hauulb_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Na ukun ya aure ta, haka nan na bakwai ma bai bar yaya ba, har suka mutu. ");
INSERT INTO hauulb_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Daga baya sai matar ma ta mutu. ");
INSERT INTO hauulb_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","To a ranar tashin mattatu, matar wa za ta zama? Domin duka bakwai din sun aure ta.” ");
INSERT INTO hauulb_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesu ya ce masu, “'Ya'yan duniyan nan suna aure, ana kuma ba da su ga aure. ");
INSERT INTO hauulb_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Amma wadanda aka ga cancantarsu a waccan tsara, sun isa su sami tashin mattatu, ba za suyi aure ko a aurar da su ba. ");
INSERT INTO hauulb_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Gama ba za su mutu kuma ba, domin suna daidai da mala'iku kuma su 'ya'yan Allah ne, da shike su 'ya'yan tashin matattu ne. ");
INSERT INTO hauulb_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Amma batun tashi matattu, ko Musa ma ya nuna wannan, a cikin jeji, inda ya kira Ubangiji, Allah na Ibrahim da kuma Allah na Ishaku da Allah na Yakubu. ");
INSERT INTO hauulb_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Yanzu shi ba Allahn matattu ba ne, amma na masu rai, saboda duka suna raye a wurinsa.” ");
INSERT INTO hauulb_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Wadansu marubuta suka amsa, “Malam, ka amsa da kyau.” ");
INSERT INTO hauulb_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Gama ba su sake yi masa wadansu tambayoyi ba. ");
INSERT INTO hauulb_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yesu ya ce masu, “Yaya suke cewa Almasihu dan Dauda ne? ");
INSERT INTO hauulb_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Gama Dauda da kansa ya ce a cikin littafin Zabura, Ubangiji ya ce wa Ubangiji na, 'Zauna a hannun dama na, ");
INSERT INTO hauulb_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","sai na maida makiyanka a karkashin tafin sawunka.' ");
INSERT INTO hauulb_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Dauda ya kira Kristi 'Ubangiji', to ta yaya ya zama dan Dauda?” ");
INSERT INTO hauulb_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Dukan mutane suna ji ya ce wa almajiransa, ");
INSERT INTO hauulb_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Ku yi hankali da marubuta, wadanda suna son tafiya da manyan riguna, suna kuma son a gaishe su a cikin kasuwanni, da mayan wuraren zama a cikin majami'u, da kuma manyan wurare a wurin bukukkuwa. ");
INSERT INTO hauulb_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Suna kuma kwace wa gwamraye gidaje, suna kuma badda kama ta wurin yin doguwar addu'a. Wadannan za su sha hukumci mai girma.” ");
INSERT INTO hauulb_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesu ya tada ido sai ya ga mutane masu arziki wadanda suke saka baikonsu a cikin ma'aji. ");
INSERT INTO hauulb_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ya ga wata gwauruwa matalauciya tana saka anini biyu a ciki. ");
INSERT INTO hauulb_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Sai ya ce, “Gaskiya ina gaya maku, wannan matalauciyar gwauruwa ta saka fiye da dukansu. ");
INSERT INTO hauulb_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Duka wadannan sun bayar da baikonsu daga cikin yalwarsu. Amma wannan gwauruwan, daga cikin talaucin ta, ta saka dukan iyakar kudinta na zaman gari da take da shi.” ");
INSERT INTO hauulb_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Kamar yadda wadansu suke maganan haikali, yadda aka yi masa ado da duwatsu masu daraja da bayebaye, ya ce, ");
INSERT INTO hauulb_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Game da wadannan abubuwa da ku ke gani, rana tana zuwa da ba dutse ko daya da zai zauna kan dan'uwansa da ba za a rushe kasa ba.” ");
INSERT INTO hauulb_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Sai suka yi masa tambaya, cewa, “Malam, yaushe ne wadannan abubuwan zasu faru? Menene kuma zai zama alama sa'adda wadannan abubuwa suna shirin faruwa?” ");
INSERT INTO hauulb_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yesu ya amsa, “Ku yi hankali kada a rude ku. Gama dayawa zasu zo a cikin sunana, suna cewa, 'Ni ne shi,' kuma, 'Lokaci ya yi kusa.' Kada ku bi su. ");
INSERT INTO hauulb_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Sa'adda ku ka ji game da yakoki da hargitsi, kada ku firgita, dole ne wadannan abubuwa su faru tukuna, amma karshe ba zai faru nan da nan ba.” ");
INSERT INTO hauulb_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Sa'annan ya ce masu, “Al'umma za ta tasar ma al'umma, mulki kuma za ya tasar wa mulki. ");
INSERT INTO hauulb_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Za a yi babbar girgizan kasa, a wurare dabam dabam kuma za a yi yunwa da annoba. Za a yi al'amura masu ban tsoro da manyan alamu daga sama. ");
INSERT INTO hauulb_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Amma kafin abubuwan nan duka, za su kama ku, su kuma tsananta maku, suna mika ku ga majami'u da kuma gidajen kurkuku, za su kawo ku gaban sarakuna da gwamnoni saboda sunana. ");
INSERT INTO hauulb_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Zai zamar maku zarafin shaida. ");
INSERT INTO hauulb_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Saboda haka ku kudurta a ranku kada ku shirya yadda za ku amsa, ");
INSERT INTO hauulb_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","gama ni zan ba ku kalmomi da hikima, wadda dukan makiyanku ba za su yi tsayayya ko su karyata ku ba. ");
INSERT INTO hauulb_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Amma har da mahaifa da 'yan'uwa da dangi da abokai za su bashe ku, su kuma kashe wadansun ku. ");
INSERT INTO hauulb_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Kowa zai ki ku saboda sunana. ");
INSERT INTO hauulb_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Amma ba ko gashin kanku da zai hallaka. ");
INSERT INTO hauulb_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","A cikin hankurin ku za ku ribato rayukanku. ");
INSERT INTO hauulb_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Sa'adda ku ka ga Urushalima tana kewaye da sojoji, sai ku sani da cewa faduwarta ta yi kusa. ");
INSERT INTO hauulb_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Sai wadanda su ke Yahudiya su gudu zuwa kan tuddai, wadanda suke tsakiyar gari kuma su tafi, kada su bar wadanda suke kauyuka su shigo ciki. ");
INSERT INTO hauulb_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Gama wadannan ranakun ramako ne, saboda duka abubuwan da aka rubuta su cika. ");
INSERT INTO hauulb_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Kaiton wadanda suke da juna biyu da masu ba da mama a wannan kwanakin! Gama za a sha kunci mai girma a kasan, da fushi kuma zuwa ga mutanen nan. ");
INSERT INTO hauulb_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Za su fadi ta kaifin takobi kuma za a kai su cikin bauta ga dukan kasashe, al'ummai za su tattake Urushalima, har ya zuwa lokacin al'ummai ya cika. ");
INSERT INTO hauulb_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Za a ga alamomi cikin rana da wata da kuma taurari. A duniya kuma, al'ummai za su sha kunci, za su rude saboda rurin teku da rakuman ruwa. ");
INSERT INTO hauulb_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Mutane za su suma da tsoro da kuma da tunanin abubuwa da za su abko wa duniya. Gama za a girgiza ikokin sammai. ");
INSERT INTO hauulb_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Sa'annan za su ga Dan Mutum yana zuwa a cikin gajimarai da iko da daukaka mai girma. ");
INSERT INTO hauulb_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Amma sa'adda wadannan abubuwa suka fara faruwa, tashi saye, sai ku daga kanku sama, saboda ceton ku ya kusato.” ");
INSERT INTO hauulb_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yesu ya bada misali, “Duba itacen baure, da duka itatuwa. ");
INSERT INTO hauulb_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Sa'adda su ke fitar da ganye, za ku gani da kanku cewa bazara ta yi kusa kuma. ");
INSERT INTO hauulb_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Haka kuma, sa'adda ku ka ga wadannan abubuwa suna faruwa, ku sani cewa mulkin Allah ya yi kusa. ");
INSERT INTO hauulb_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Gaskiya, na ke gaya maku, wannan zamani ba za ya shude ba, sai duka abubuwan nan sun faru. ");
INSERT INTO hauulb_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Sama da kasa za su shude, amma maganata ba za ta shude ba. ");
INSERT INTO hauulb_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Amma ku lura da kanku, domin kada ku nawaita zuciyarku da tararradin duniya da shayeshaye da damuwa ta rayuwa. Gama ranar za ta zo babu shiri ");
INSERT INTO hauulb_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","kamar tarko. Gama zai zo akan kowa da ke rayuwa a fuskar dukan duniya. ");
INSERT INTO hauulb_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Amma ku zama a fadake kowanne lokaci, kuna addu'a domin ku iya samun karfin tserewa dukan wadannan abubuwa da za su faru, da kuma yadda za ku tsaya a gaban Dan Mutum.” ");
INSERT INTO hauulb_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Da rana yana koyarwa a cikin haikali, dukan dare kuma yakan tafi dutsen da a ke kira zaitun. ");
INSERT INTO hauulb_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Dukan mutane suka rika zuwa wurinsa da sassafe domin su ji shi a haikali. ");
INSERT INTO hauulb_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Anan nan idin gurasa mara yisti ya yi kusa, wanda a ke kira Idin ketarewa. ");
INSERT INTO hauulb_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Manyan firistoci da marubuta suka yi shawara yadda za su kashe Yesu, gama suna jin tsoron mutane. ");
INSERT INTO hauulb_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Shaidan ya shiga Yahuza Iskariyoti, daya daga cikin goma sha biyun. ");
INSERT INTO hauulb_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yahuza ya je ya yi shawara da manyan firistoci da Jarumawa yadda zai ba da Yesu a garesu. ");
INSERT INTO hauulb_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Suka yi farin ciki, suka yarda su ba shi kudi. ");
INSERT INTO hauulb_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Sai ya yarda, sai ya nimi dama yadda zai ba da shi garesu a lokacin da babu taro. ");
INSERT INTO hauulb_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ranar idin gurasa mara yisti ya yi, da dole za a yi hadayan rago na Idin ketarewa. ");
INSERT INTO hauulb_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yesu ya aiki Bitrus da Yahaya, ya ce masu, “Ku je ku shirya mana abincin Idin ketarewa, domin mu ci.” ");
INSERT INTO hauulb_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Suka tambaye shi, “A ina ka ke so mu shirya?” ");
INSERT INTO hauulb_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ya amsa masu, “Ku ji, sa'adda ku ka shiga birnin, wani mutum mai dauke da tulun ruwa zai same ku. Ku bishi zuwa cikin gidan da za ya shiga. ");
INSERT INTO hauulb_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Sai ku gaya wa mai gidan, 'Malam ya ce, “Ina dakin baki, inda zan ci abincin Idin ketarewa da almajirai na?'” ");
INSERT INTO hauulb_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Zai nuna maku babban bene wanda yake a shirye. Ku shirya a can.” ");
INSERT INTO hauulb_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Sai suka tafi, suka sami komai kamar yadda ya gaya masu. Sai suka shirya abincin Idin ketarewan. ");
INSERT INTO hauulb_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Sa'adda lokacin ya yi, ya zauna da almajiran. ");
INSERT INTO hauulb_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Sai ya ce masu, “Ina da marmari matuka in ci wannan abincin Idin ketarewa da ku kamin in sha wahala. ");
INSERT INTO hauulb_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Gama na ce maku, ba zan ci shi kuma ba, sai dai an cika shi a mulkin Allah.” ");
INSERT INTO hauulb_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Sai Yesu ya dauki koko, sa'adda ya yi godiya, sai yace, “Karba wannan, ku rarraba a tsakaninku. ");
INSERT INTO hauulb_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Gama ina ce maku, ba zan sha wannan ruwan inabi kuma ba, sai dai mulkin Allah ya zo.” ");
INSERT INTO hauulb_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Sai ya dauki gurasa, sa'adda ya yi godiya, ya kakkarya shi, sai ya ba su, cewa, “Wannan jikina ne wanda aka bayar dominku. Ku yi wannan domin tunawa da ni.” ");
INSERT INTO hauulb_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Sai ya dauki kokon kuma bayan jibi, cewa, “Wannan koko sabon alkawari ne cikin jinina, wanda aka zubar dominku. ");
INSERT INTO hauulb_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Amma ku yi lura. Wanda zai bashe ni yana tare da ni a teburi. ");
INSERT INTO hauulb_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Gama Dan Mutum zai tafi lallai kamar yadda aka kaddara. Amma kaiton wannan mutum da shine za ya bashe shi!” ");
INSERT INTO hauulb_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Sai suka fara tambaya a tsakaninsu, wanene a cikinmu da zai yi wannan abu. ");
INSERT INTO hauulb_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Sai gardama ta tashi a tsakaninsu game da wanene mafi girma. ");
INSERT INTO hauulb_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ya ce masu, “Sarakunan al'ummai suna nuna iko akansu, kuma wadanda suke da iko a kansu ana ce da su masu mulki da daraja. ");
INSERT INTO hauulb_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Amma kada ya zama haka da ku. A maimakon haka, bari wanda ya ke mafi girma a cikinku ya zama mafi kankanta. Bari wanda yafi muhimmanci kuma ya zama kamar mai hidima. ");
INSERT INTO hauulb_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Gama wanene yafi girma, wanda ya zauna a teburi, ko kuwa wanda yake yin hidima? Ba wanda ya zauna a teburi ba? Duk da haka ina kamar mai hidima a tsakaninku. ");
INSERT INTO hauulb_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Amma ku ne wadanda ku ke tare da ni a cikin jarabobina. ");
INSERT INTO hauulb_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Na baku mulki, kamar yadda Ubana ya ba ni mulki, ");
INSERT INTO hauulb_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","domin ku ci ku kuma sha a teburi na mulkina. Za ku zauna a kan kursiyai kuna shari'anta kabilun nan goma sha biyu na Israila. ");
INSERT INTO hauulb_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Siman, Siman, ka yi hankali, shaidan ya nemi izini a bada kai domin ya tankade ka kamar alkama. ");
INSERT INTO hauulb_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Amma na yi maka addu'a, saboda kada bangaskiyarka ta fadi. Bayan da ka juyo kuma, ka karfafa 'yan'uwanka.” ");
INSERT INTO hauulb_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Bitrus ya ce masa, “Ubangiji, ina shirye in tafi tare da kai zuwa cikin kurkuku da zuwa mutuwa.” ");
INSERT INTO hauulb_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesu ya amsa masa, “Ina gaya maka, Bitrus, kamin caran zakara a yau, za ka yi musu na sau uku cewa ba ka sanni ba.” ");
INSERT INTO hauulb_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Sa'annan Yesu ya ce masu, “Lokacin da na aike ku babu jaka, ko burgami ko takalma, ko kun rasa wani abu? Sai suka amsa, “Babu.” ");
INSERT INTO hauulb_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ya kuma ce masu, “Amma yanzu, wanda ya ke da jaka, bari ya dauka, da kuma burgami. Wanda ba shi da takobi sai ya sayar da taguwarsa ya sayi guda. ");
INSERT INTO hauulb_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Gama ina ce maku, abin da aka rubuta game da ni dole sai ya cika, 'An lisafta shi kamar daya daga cikin masu karya doka.' Gama abinda aka fada akaina ya cika.” ");
INSERT INTO hauulb_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Sai suka ce, “Ubangiji, duba! Ga takuba biyu.” Sai ya ce masu, “Ya isa.” ");
INSERT INTO hauulb_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Bayan cin abincin yamma, Yesu ya tafi, kamar yadda ya saba yi, zuwa dutsen Zaitun, sai almajiran suka bi shi. ");
INSERT INTO hauulb_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Sa'adda suka iso, ya ce masu, “Ku yi addu'a domin kada ku shiga cikin jaraba.” ");
INSERT INTO hauulb_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ya rabu da su misalin nisan jifa, sai ya durkusa kasa ya yi addu'a, ");
INSERT INTO hauulb_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","yana cewa “Uba, in ka yarda, ka dauke wannan kokon daga gareni. Ko da yake ba nufina ba, amma bari naka nufin ya kasance.” ");
INSERT INTO hauulb_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Sai mala'ika daga sama ya bayyana a wurinsa, yana karfafa shi. ");
INSERT INTO hauulb_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yana cikin wahala sosai, sai ya dukufa cikin addu'a, har zufarsa kuma tana diga a kasa kamar gudajen jini. ");
INSERT INTO hauulb_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Sa'adda ya tashi daga addu'arsa, sai ya zo wurin almajiran, ya same su suna barci domin bakin cikinsu, ");
INSERT INTO hauulb_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","sai ya tambaye su, “Don me kuke barci? Tashi ku yi addu'a, saboda kada ku shiga cikin jaraba.” ");
INSERT INTO hauulb_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Sa'adda yana cikin magana, sai, ga taron jama'a suka bayana, tare da Yahuza, daya daga cikin sha biyun, ya na jagabansu. Sai ya zo kusa da Yesu domin ya yi masa sumba, ");
INSERT INTO hauulb_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","amma Yesu ya ce masa, “Yahuza, za ka ba da Dan Mutum da sumba?” ");
INSERT INTO hauulb_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Sa'adda wadanda suke kewaye da Yesu suka ga abin da yake faruwa, sai suka ce, “Ubangiji, mu yi sara da takobi ne?” ");
INSERT INTO hauulb_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Sai daya daga cikinsu ya kai wa bawan babban firist sara a kunne, sai ya yanke masa kunnensa na dama. ");
INSERT INTO hauulb_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Yesu ya ce, “Ya isa haka.” Sai ya taba kunnensa, sai ya warkar da shi. ");
INSERT INTO hauulb_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Yesu yace wa manyan firistoci, da masu tsaron haikali, da dattawa wadanda suke gaba da shi, “Kun fito kamar za ku kama dan fashi, da takuba da sanduna? ");
INSERT INTO hauulb_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Sa'adda nake tare da ku kowace rana a haikali, ba ku kama ni ba. Amma wannan shine lokacinku, da kuma ikon duhu.” ");
INSERT INTO hauulb_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Suka kama shi, sai suka tafi da shi, suka kawo shi cikin gidan babban firist. Amma Bitrus yana binsa daga nesa. ");
INSERT INTO hauulb_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Bayan da suka hura wuta a tsakiyar gidan da suka zazzauna tare, Bitrus ya zaune a tsakaninsu. ");
INSERT INTO hauulb_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Sai wata baranya ta ganshi ya zauna a hasken wuta, sai ta zura masa ido ta ce, “Wannan mutum ma yana tare da shi.” ");
INSERT INTO hauulb_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Amma Bitrus ya yi musu, yana cewa, “Mace, ban san shi ba.” ");
INSERT INTO hauulb_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Bayan dan karamin lokaci sai wani mutum ya gan shi, sai ya ce, “Kaima kana daya daga cikinsu.” Amma Bitrus ya ce, “Mutumin, ba ni ba ne.” ");
INSERT INTO hauulb_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Bayan sa'a daya sai wani mutum ya nace da cewa, “Gaskiya wannan mutum yana tare da shi, gama shi dan Galili ne.” ");
INSERT INTO hauulb_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Amma Bitrus ya ce, “Mutumin, ban san abin da kake fada ba.” Sai nan da nan, da yana cikin magana, sai zakara ta yi cara. ");
INSERT INTO hauulb_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Yana juyawa, sai Ubangiji ya dubi Bitrus. Sai Bitrus ya tuna kalmar Ubangiji, sa'adda ya ce masa, “Kafin zakara ya yi cara yau za ka musunce ni sau uku.” ");
INSERT INTO hauulb_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Da fitowarsa waje, Bitrus ya yi kuka mai zafi. ");
INSERT INTO hauulb_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Sai mutanen da ke tsare da Yesu suka yi masa ba'a da bulala kuma. ");
INSERT INTO hauulb_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Bayan da suka rufe masa idanu, suka tambaye shi, cewa, “Ka yi annabci! Wa ya buge ka?” ");
INSERT INTO hauulb_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Suka yi wadansu miyagun maganganu na sabo game da Yesu. ");
INSERT INTO hauulb_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Da gari ya waye, sai dattawa suka hadu tare, da manyan firistoci da marubuta. Sai suka kai shi cikin majalisa ");
INSERT INTO hauulb_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","suka ce, “Gaya mana, in kai ne Almasihu.” Amma yace masu, “Idan na gaya maku, ba za ku gaskanta ba, ");
INSERT INTO hauulb_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","idan na yi maku tambaya, ba za ku amsa ba. ");
INSERT INTO hauulb_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Amma nan gaba, Dan Mutum zai zauna a hannun dama na ikon Allah.” ");
INSERT INTO hauulb_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Suka ce masa, “Ashe kai Dan Allah ne?” Sai Yesu ya ce masu, “Haka kuka ce, nine.” ");
INSERT INTO hauulb_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Suka ce, “Don me muke neman shaida? Gama mu da kanmu munji daga bakinsa.” ");
INSERT INTO hauulb_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Sai duk taron suka tashi, suka kawo Yesu gaban Bilatus. ");
INSERT INTO hauulb_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Suka fara saransa, cewa “Mun same wannan mutum yana ruda kasarmu, ya haramta a ba Kaisar haraji, yana kuma cewa shi da kansa ne Almasihu, sarki.” ");
INSERT INTO hauulb_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Bilatus ya tambaye shi, cewa “Shin kaine Sarkin Yahudawa?” Sai Yesu ya amsa masa ya ce, “Haka ka ce.” ");
INSERT INTO hauulb_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Sai Bilatus ya ce wa manyan firistocin da taro mai yawa, “Ban samu ko laifi daya game da wannan mutumin ba.” ");
INSERT INTO hauulb_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Amma suka yi ta cewa, “Yana ta da hankalin mutane da koyarwa a dukan Yahudiya, ya fara daga Galili har zuwa ga wannan wuri.” ");
INSERT INTO hauulb_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Sa'adda Bilatus ya ji wannan, sai ya tambaya ko mutumin daga Galiline. ");
INSERT INTO hauulb_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Sa'adda ya gane cewa yana karkashin mulkin Hirudus, sai ya tura Yesu wurin Hirudus, wanda shi da kansa yana Urushalima a wadannan kwanakin. ");
INSERT INTO hauulb_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Sa'adda Hirudus ya ga Yesu, sai ya cika da farin ciki sosai, saboda ya so ganinsa tunda dadewa. Tun can ya ji game da shi sai ya yi begen ganin wadansu al'ajibai da zai yi. ");
INSERT INTO hauulb_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Hirudus ya tambaye Yesu cikin kalmomi masu yawa, amma Yesu bai amsa masa da komai ba. ");
INSERT INTO hauulb_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Sai manyan firistoci da marubuta suka tsaya, suna ta yi masa zargi mai zafi. ");
INSERT INTO hauulb_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Hirudus da sojojinsa suka zarge shi, suka kuma yi masa ba'a, suka sa masa tufafi masu kyau, sa'annan ya sake aika Yesu zuwa wurin Bilatus. ");
INSERT INTO hauulb_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Sai Hirudus da Bilatus suka zama abokai a wannan rana (da ma su abokai gaba ne). ");
INSERT INTO hauulb_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Bilatus ya kira manyan firistoci tare da masu mulki da kuma taron jama'ar, ");
INSERT INTO hauulb_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","sai ya ce masu, “Kun kawo mani wannan mutum kamar wanda yake jagorar mutane ga munanan ayyuka, ku kuma gani, Ni, na tuhume shi a gabanku, ban sami ko kuskure daya daga mutumin nan game da abinda ku ke zarginsa da shi ba. ");
INSERT INTO hauulb_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Babu, ko Hirudus ma, ya sake komar mana da shi, kun gani, babu wani abu wanda ya yi da ya cancanci mutuwa, ");
INSERT INTO hauulb_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","saboda haka zan yi masa horo sa'annan in sake shi.” ");
INSERT INTO hauulb_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ya zama dole Bilatus ya sakar wa Yahudawa wani daurarre guda daya lokacin idin. ");
INSERT INTO hauulb_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Amma dukansu suka yi ihu tare, cewa, “A tafi da wannan mutumin, sai a sako mana Barabbas!” ");
INSERT INTO hauulb_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabbas mutum ne wanda aka sa a cikin kurkuku saboda wani tada hankali a cikin birni da kuma kisankai. ");
INSERT INTO hauulb_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Bilatus ya sake yi masu magana, yana so ya saki Yesu. ");
INSERT INTO hauulb_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Amma suka yi ihu, cewa, “A giciye shi, a giciye shi.” ");
INSERT INTO hauulb_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Sai ya sake ce masu sau na uku, “Don me, wace magunta wannan mutum ya yi? Ban sami wani abu da ya isa sanadin mutuwa game da shi ba. Saboda haka bayan na hore shi, zan sake shi.” ");
INSERT INTO hauulb_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Amma suka nace da murya mai karfi, suna so a giciye shi, sai muryarsu ta rinjayi Bilatus. ");
INSERT INTO hauulb_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Sai Bilatus ya yarda ya yi masu bisa ga abin da suke so. ");
INSERT INTO hauulb_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ya sako masu wanda suka tambaya ya ba su wanda aka sa a kurkuku domin tada hankali da kuma kisankai. Amma ya ba da Yesu bisa nufinsu. ");
INSERT INTO hauulb_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Da suka tafi da shi, sai suka kama wani mai suna siman Bakurane, yana zuwa daga karkara, sai suka daura masa giciyen ya dauka, yana biye da Yesu. ");
INSERT INTO hauulb_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Babban taron jama'a, da na mata da suke makoki da kuka dominsa, suna binsa. ");
INSERT INTO hauulb_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Amma da ya juya wurinsu, Yesu yace, “Yan matan Urushalima, kada ku yi kuka domina, amma ku yi kuka domin kanku da 'ya'yanku. ");
INSERT INTO hauulb_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Gama ku gani, kwanaki suna zuwa da za su ce, 'Albarka ta tabbata ga bakararru da wadanda basu taba haihuwa ba da kuma wadanda ba a taba shan mamansu ba.' ");
INSERT INTO hauulb_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Sa'annan za su fara ce wa duwatsu, 'Ku fado bisanmu,' da tuddai ma, 'Ku rufe mu.' ");
INSERT INTO hauulb_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Gama idan sun yi wadannan abubuwan lokacin da itace yana danye, me zai faru sa'adda ya bushe?” ");
INSERT INTO hauulb_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Aka kai wadansu mutum biyu masu laifi, domin a kashe shi tare da su. ");
INSERT INTO hauulb_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Sa'adda suka zo wurin da a ke kira kwalluwa, nan suka giciye shi da barayin, daya daga hannun damansa dayan kuma daga hannun hagu. ");
INSERT INTO hauulb_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yesu yace, “Uba, ka yafe masu, gama basu san abin da suke yi ba.” Sai suka jefa kuri'a, suka rarraba tufafinsa. ");
INSERT INTO hauulb_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Mutane sun tsaya suna kallo sa'annan masu mulki suna ta yin masa ba'a, cewa, “Ya ceci wadansu. Bari ya ceci kansa, idan shine Almasihu na Allah, zababben nan.” ");
INSERT INTO hauulb_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Sojojin ma suka yi masa dariya, suna zuwa wurinsa, suna mika masa ruwan tsami, ");
INSERT INTO hauulb_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","suna cewa, “Idan kai Sarkin Yahudawa ne, ceci kanka.” ");
INSERT INTO hauulb_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Akwai wata alama bisansa, “Wannan shine Sarkin Yahudawa.” ");
INSERT INTO hauulb_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Daya daga cikin barayi wanda aka giciye, ya zage shi, cewa, “Ba kai ne Almasihu ba? Ka ceci kanka da mu.” ");
INSERT INTO hauulb_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Amma dayan ya amsa, ya tsauta masa cewa, “Ba ka tsoron Allah, da yake shari'arka daya ne da nasa? ");
INSERT INTO hauulb_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Mu kam an yi ma na daidai, gama mun samu bisa ga abin da muka yi. Amma wannan mutum bai yi wani abu mara kyau ba.” ");
INSERT INTO hauulb_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Sai ya kara, “Yesu, ka tuna da ni sa'adda ka shiga mulkinka.” ");
INSERT INTO hauulb_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesu ya ce masa, “Gaskiya ina ce maka, yau za ka kasance tare da ni a firdausi.” ");
INSERT INTO hauulb_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Anan nan a wajen sa'a na shida, sai duhu ya mamaye kasar duka har zuwa sa'a na tara ");
INSERT INTO hauulb_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","sa'adda rana ya fadi. Sai labulen haikalin ya rabu a tsakiya zuwa kasa. ");
INSERT INTO hauulb_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Da kuka da murya mai karfi, Yesu yace, “Uba, na mika Ruhu na a hannunka.” Bayan da ya fadi wannan, sai ya mutu. ");
INSERT INTO hauulb_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Sa'adda jarumin ya ga abin da ya faru, ya daukaka Allah, cewa, “Lallai wannan mutumin mai adalci ne.” ");
INSERT INTO hauulb_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Sa'adda dukan taro mai yawa wadanda suka zo tare domin su shaida da idanunsu suka ga abubuwan da suka faru, suka koma suna bugan kirjinsu. ");
INSERT INTO hauulb_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Amma duk idon sani, da kuma matan da suka bi shi tun daga Galili, suka tsaya daga nesa, suna duban wadannan abubuwa. ");
INSERT INTO hauulb_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ga shi kuwa, wani mutum mai suna Yusufu, shi dan majalisa ne, nagari ne kuma mutum mai adalci ne ");
INSERT INTO hauulb_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","(bai yarda da shawarar da kuma abin da suka aikata ba), daga Arimatiya a kasar Yahudiya, wanda yake jiran mulkin Allah. ");
INSERT INTO hauulb_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Wannan mutum, ya sami Bilatus, ya tambaya a bashi jikin Yesu. ");
INSERT INTO hauulb_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ya saukar da shi kasa, sai ya nade shi cikin likafani na linin mai kyau, ya kwantar da shi cikin kabari da aka sassaka shi daga dutse, inda ba a taba binne wani ba. ");
INSERT INTO hauulb_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ranar kuwa, ranar shiri ce, Asabaci kuma ta kusato. ");
INSERT INTO hauulb_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Matan da suka taho da shi tun daga Galili, suka biyo baya, su ga kabarin da inda aka ajiye shi. ");
INSERT INTO hauulb_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Suka koma, sai suka shirya kayan kamshi da mai. Suka kuma huta a ranar Asabaci bisa ga doka. ");
INSERT INTO hauulb_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Da sassafe a ranar farko ta mako, suka zo kabarin, suka kawo kayan kamshi wadda suka shirya. ");
INSERT INTO hauulb_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Sai suka samu dutsen a mirgine shi daga kabarin. ");
INSERT INTO hauulb_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Suka shiga ciki, amma ba su sami jikin Ubangiji Yesu ba. ");
INSERT INTO hauulb_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ya faru kuwa, yayin da suke a rikice game da wannan, ba zato, mutane guda biyu suka tsaya a gabansu da tufafi masu walkiya. ");
INSERT INTO hauulb_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Sa'adda matan suka sunkuyar da kansu kasa domin tsoro, suka ce wa matan, “Don me kuke neman mai rai ciki matattatu? ");
INSERT INTO hauulb_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Baya nan, amma ya tashi! Ku tuna fa yadda ya yi maku magana tun sa'adda ya ke Galili, ");
INSERT INTO hauulb_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","cewa za a ba da Dan Mutum ga mutane masu zunubi su kuma giciye shi, a rana ta uku, zai tashi kuma” ");
INSERT INTO hauulb_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Sai matan suka tuna da kalmominsa, ");
INSERT INTO hauulb_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","suka koma daga kabarin sai suka gaya wa sha dayan wadannan abubuwan da dukan sauran. ");
INSERT INTO hauulb_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Su Maryamu Magadaliya, Yuwana, Maryamu uwar Yakubu, da sauran matan da ke tare da su suka ba manzanni rohoton wadannan abubuwan. ");
INSERT INTO hauulb_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Amma manzannin suka dauki maganar kamar ba ta da amfani, kuma ba su bada gaskiya ga matan ba. ");
INSERT INTO hauulb_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Duk da haka Bitrus ya tashi, sai ya gudu zuwa kabarin, ya sunkuya yana kallon ciki, sai ya gan likaftani linin kadai. Sa'annan Bitrus ya tafi gidansa, yana ta mamakin abinda ya faru. ");
INSERT INTO hauulb_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","A ranan nan, sai ga biyu daga cikinsu suna tafiya zuwa wani kauye suna Imawus, wanda nisansa kimanin mil ne daga Urushalima. ");
INSERT INTO hauulb_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Suna tattaunawa da junansu game da dukan abubuwan da suka faru. ");
INSERT INTO hauulb_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Sai ya zama da cewa, sa'adda su ke tattaunawa tare da tambayoyi, sai Yesu da kansa ya matsa kusa yana tafiya tare da su. ");
INSERT INTO hauulb_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Amma idanunsu basu iya ganewa da shi ba. ");
INSERT INTO hauulb_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yesu ya ce masu, “Menene ku ke magana akai sa'adda ku ke tafiya?” Suka tsaya a wurin suna bakin ciki. ");
INSERT INTO hauulb_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Daya daga cikinsu, mai suna Kiliyobas, ya amsa masa, “Kai ne kadai mutumin da ke Urushalima wanda bai san abubuwan da suka faru a can a wannan kwanakin ba?” ");
INSERT INTO hauulb_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yesu ya ce masu, “Wadanne abubuwa?” Suka amsa masa, “Abubuwa game da Yesu ba Nazarat, wanda ya ke annabi ne, mai manyan ayuka da kalmomi daga Allah da kuma mutane. ");
INSERT INTO hauulb_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Da yadda manyan firistoci da masu mulkinmu suka bada shi domin a hukunta shi ga mutuwa a kuma giciye shi. ");
INSERT INTO hauulb_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Amma mun yi begen cewa shine wanda za ya yantar da Isra'ila. I, bayan wannan kuma, yanzu kwana uku kenan tunda wadannan abubuwan suka faru. ");
INSERT INTO hauulb_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Amma har'ila yau, wadansu mata da ke tare da mu sun yi mana abin al'ajabi, da suka kasance a kabarin tunda sassafe. ");
INSERT INTO hauulb_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Sa'adda ba su sami jikinsa ba, suka zo, da cewa su ma sun ga wahayin mala'iku wadanda suka ce masu ya na da rai. ");
INSERT INTO hauulb_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Wasu maza wadanda ke tare da mu suka tafi kabarin, suka tarar da shi kamar yadda matan suka fada. Amma ba su ganshi ba.” ");
INSERT INTO hauulb_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Yesu ya ce masu, “Ku mutane masu wauta da marasa ba da gaskiya ga abin da annabawa suka fada! ");
INSERT INTO hauulb_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Bai zama dole ne Almasihu ya sha wahalan wadannan abubuwan ba, ya kuma shiga cikin daukakarsa?” ");
INSERT INTO hauulb_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Sa'annan da farko daga Musa da har zuwa dukan annabawa, Yesu ya fasara masu duka abubuwa da ke game da kansa a dukan littattafai. ");
INSERT INTO hauulb_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Da suka yi kusa da kauyen, inda suke tafiya, ko da yake Yesu ya yi kamar zai wuce su. ");
INSERT INTO hauulb_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Amma suka tilasta shi, cewa, “Ka zauna da mu, gama yamma ta yi kusa rana kuma ta kusa karewa.” Sai Yesu ya tafi ya zauna da su. ");
INSERT INTO hauulb_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ya faru cewa, sa'adda ya zauna tare da su domin ya ci abinci, sai ya dauki gurasan, ya albarkace shi, ya kakkarya, sai ya ba su. ");
INSERT INTO hauulb_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Sa'annan idanunsu suka bude, da suka gane shi, sai ya bace daga garesu, ");
INSERT INTO hauulb_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Suka ce wa junansu, ashe zuciyarmu ba ta yi kuna a cikinmu ba, sa'adda yake magana da mu a hanya, sa'adda ya bude mana littattafai?” ");
INSERT INTO hauulb_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Suka tashi a wancan sa'a, sai suka koma Urushalima. Suka sami sha dayan nan tare, da wadanda suke tare da su, ");
INSERT INTO hauulb_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","cewa, “Lalle ne Ubangiji ya tashi, ya kuma bayyana ga Siman.” ");
INSERT INTO hauulb_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Sai suka fadi abubuwan da suka faru a hanya, da yadda aka bayyana masu Yesu sa'adda ya kakkarya gurasa. ");
INSERT INTO hauulb_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Sa'adda suke fadin wadannan abubuwan, sai Yesu ya tsaya a sakaninsu, sai ya ce masu, “Salama a gareku.” ");
INSERT INTO hauulb_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Amma suka firgita suna cike da tsoro, suna tsammani sun ga fatalwa. ");
INSERT INTO hauulb_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Yesu ya ce masu, don me ku ke damuwa? Don me tambayoyi ke tasowa a zuciyarku? ");
INSERT INTO hauulb_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Duba hannayena da kafafuna, cewa nine da kaina. Taba ni ku gani. Gama ruhu ba shi da jiki da kashi, kamar yadda ku ka ga nake da su.” ");
INSERT INTO hauulb_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Bayan da ya fadi wannan, sai ya nuna masu hannayensa da kafafunsa. ");
INSERT INTO hauulb_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Sa'adda suke cike da farin ciki, da mamaki, Yesu ya ce masu, “Kuna da wani abinci?” ");
INSERT INTO hauulb_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Sai suka bashi gasasshen kifi. ");
INSERT INTO hauulb_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Yesu ya karba, ya ci a gabansu. ");
INSERT INTO hauulb_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Sai ya ce masu, “Sa'adda nake tare da ku na gaya maku cewa duka abin da aka rubuta a cikin dokokin Musa da na annabawa da Zabura dole su cika.” ");
INSERT INTO hauulb_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Sai ya bude hankalinsu, saboda su gane littattafai. ");
INSERT INTO hauulb_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ya ce masu, “A rubuce yake, cewa Almasihu za ya sha wuya, zai tashi kuma daga matattu a rana ta uku. ");
INSERT INTO hauulb_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ku yi wa'azin tuba da gafarar zunubai a cikin sunansa ga dukan al'ummai, ku fara daga Urushalima. ");
INSERT INTO hauulb_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ku shaidu ne ga wadannan abubuwan. ");
INSERT INTO hauulb_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Duba, ina aiko da alkawarin Ubana a kanku. Amma ku jira a birni, sai an suturta ku da iko daga sama.” ");
INSERT INTO hauulb_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Sa'annan Yesu ya tafi tare da su har sai da suka kai kusa da Betanya. Sai ya daga hannunsa ya albarkace su. ");
INSERT INTO hauulb_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ya zama sa'adda yake sa masu albarka, ya bar su sai aka dauke shi zuwa cikin sama. ");
INSERT INTO hauulb_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Sai suka yi masa sujada, suka komo Urushalima da murna mai yawa. ");
INSERT INTO hauulb_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Kullayaumin suna cikin haikali, suna albarkatar Allah. ");
INSERT INTO hauulb_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","A cikin farko akwai Kalma, Kalmar kuma tana tare da Allah, wannan Kalma kuwa Allah ne. ");
INSERT INTO hauulb_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Shi kuwa tare da Allah yake tun farko. ");
INSERT INTO hauulb_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Dukan abu ta wurinsa aka yi su, babu abin da aka halitta sai ta wurin sa. ");
INSERT INTO hauulb_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","A cikinsa rai ya ke, kuma wannan rai ya zama haske ga dukan mutane. ");
INSERT INTO hauulb_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Hasken ya haskaka a cikin duhu, kuma duhun bai rinjaye shi ba. ");
INSERT INTO hauulb_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Akwai wani mutum wanda Allah ya aiko, mai suna Yahaya. ");
INSERT INTO hauulb_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ya zo a matsayin mai ba da shaida game da hasken, domin kowa ya ba da gaskiya ta wurinsa. ");
INSERT INTO hauulb_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ba Yahaya ne hasken ba, amma ya zo ne domin ya shaida hasken. ");
INSERT INTO hauulb_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Wannan shine haske na gaskiya mai ba da haske ga dukan mutane, da ke zuwa cikin duniya. ");
INSERT INTO hauulb_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Yana cikin duniya, kuma an halicci duniya ta wurinsa, amma duniya bata san shi ba. ");
INSERT INTO hauulb_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ya zo wurin nasa, amma nasa basu karbe shi ba. ");
INSERT INTO hauulb_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Amma duk iyakar wadanda suka karbe shi, suka kuma ba da gaskiya ga sunansa, ya ba su 'yanci su zama 'ya'yan Allah. ");
INSERT INTO hauulb_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Wadanda aka haife su ba ta wurin jini ba, ko ta wurin nufin jiki, ko nufin mutum, amma ta wurin Allah. ");
INSERT INTO hauulb_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Kalmar kuma ya zama jiki ya zauna cikin mu. Mun ga daukakarsa, daukaka irin ta makadaici shi kadai wanda ya zo daga Uban, cike da alheri da gaskiya. ");
INSERT INTO hauulb_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yahaya ya yi shaida akansa yana kira da karfi, cewa, “Wannan shine wanda na yi magana a kansa cewa, 'Shi wanda ke zuwa bayana, ya fi ni, domin ya kasance kafin ni.'” ");
INSERT INTO hauulb_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Domin daga cikarsa ne muka karbi alheri akan alheri. ");
INSERT INTO hauulb_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Gama shari'a ta zo daga wurin Musa. Alheri da gaskiya sun zo ta wurin Yesu Almasihu. ");
INSERT INTO hauulb_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Babu lokacin da wani ya taba ganin Allah, shi wanda shi kadai ne Allah, wanda ke jingine da kirjin Uba, shi ya bayyana shi. ");
INSERT INTO hauulb_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Wannan ita ce shaidar Yahaya sa'adda Yahudawa suka aika da Firistoci da Lawiyawa zuwa gareshi don su tambaye shi, “Wanene kai?” ");
INSERT INTO hauulb_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ya fada dalla dalla, kuma bai musunta ba, yana amsa masu cewa, “ba nine Almasihu ba.” ");
INSERT INTO hauulb_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Sai suka tambaye shi, “To kai wanene? Kai Iliya ne?” Yace, “Ba ni ba ne.” Suka ce, “Kai ne anabin?” Ya amsa, “A'a”. ");
INSERT INTO hauulb_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Sai suka ce masa, “Kai wanene, domin mu bada amsa ga wadanda suka aiko mu? Me kake fadi game da kanka?” ");
INSERT INTO hauulb_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yace, “Ni murya ne, da ke kira cikin jeji, 'Ku daidaita hanyar Ubangiji,' kamar yadda annabi Ishaya ya fada.” ");
INSERT INTO hauulb_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Su wadanda aka aika daga wurin Farisawa suke. Sai suka tambaye shi cewa, ");
INSERT INTO hauulb_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","“To don me kake baftisma idan kai ba Almasihu bane, ko Iliya, ko annabin?”. ");
INSERT INTO hauulb_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yahaya ya amsa masu, cewa, “Ina baftisma ne da ruwa. Amma a cikinku akwai wani tsaye wanda ba ku sani ba, ");
INSERT INTO hauulb_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","shi wanda ke zuwa bayana, wanda ko igiyar takalminsa ban isa in kwance ba.” ");
INSERT INTO hauulb_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Wadannan abubuwa sun faru ne a Baitanya, a dayan ketaren Urdun, a wurin da Yahaya ke Baftisma. ");
INSERT INTO hauulb_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Washegari, Yahaya ya ga Yesu yana zuwa wurinsa ya ce, “Duba, ga Dan Ragon Allah wanda ke dauke zunubin duniya! ");
INSERT INTO hauulb_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Wannan shine wanda na fada maku cewa, “Shi wanda ke zuwa bayana ya fi ni, domin ya kasance kafin ni.' ");
INSERT INTO hauulb_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ban san shi ba, amma saboda a bayyana shi ga Isra'ila ne nazo ina baftisma da ruwa. “ ");
INSERT INTO hauulb_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Yahaya ya shaida, cewa, “Na ga Ruhu yana saukowa kamar kurciya daga sama, ya kuma zauna a kansa. ");
INSERT INTO hauulb_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ban gane shi ba, amma shi wanda ya aiko ni in yi baftisma cikin ruwa ya fada mani cewa, 'duk wanda ka ga Ruhun ya sauka kuma ya zauna a kansa, shine wanda ke yin baftisma cikin Ruhu mai tsarki.' ");
INSERT INTO hauulb_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Na gani, na kuma shaida cewa wannan shine Dan Allah.” ");
INSERT INTO hauulb_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Kuma, washegari, da Yahaya na tsaye da biyu daga cikin almajiransa, ");
INSERT INTO hauulb_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","suka ga Yesu na wucewa, sai Yahaya ya ce, “Duba, ga Dan rago na Allah!” ");
INSERT INTO hauulb_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Sai almajiransa biyu suka ji ya fadi haka, suka kuwa bi Yesu. ");
INSERT INTO hauulb_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Da Yesu ya waiwaya ya gan su suna bin sa, sai ya ce masu, “Me kuke so?” Suka amsa, “ Rabbi (wato 'Mallam'), ina kake da zama?” ");
INSERT INTO hauulb_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yace masu, “Zo ku gani.” Sai suka zo suka ga inda yake zama; suka zauna da shi ranan nan, gama wajen sa'a ta goma ne. ");
INSERT INTO hauulb_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Daya daga cikin wadanda suka ji maganar Yahaya suka kuma bi Yesu shine Andarawus, dan'uwan Siman Bitrus. ");
INSERT INTO hauulb_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ya fara neman dan'uwansa Siman yace masa, “Mun sami Almasihu” (wanda ake kira 'Kristi'). ");
INSERT INTO hauulb_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ya kawo shi wurin Yesu. Yesu ya dube shi yace, “Kai ne Siman dan Yahaya. Za a kira ka Kefas,” (ma'ana, 'Bitrus'). ");
INSERT INTO hauulb_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Washegari, da Yesu yana shirin tafiya zuwa Galili, sai ya sami Filibus, ya ce masa, “ka biyo ni.” ");
INSERT INTO hauulb_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filibus dan asalin Baitsaida ne, garin Andarawus da Bitrus. ");
INSERT INTO hauulb_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filibus ya sami Natana'ilu yace masa, “Mun same shi, shi wanda Musa ya rubuta shi a cikin attaura, da annabawa: Yesu Dan Yusufu, Ba-Nazarat.” ");
INSERT INTO hauulb_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natana'ilu ya ce masa, “za a iya samun wani abu nagari a Nazarat?” Filibus yace masa, “Zo ka gani.” ");
INSERT INTO hauulb_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yesu ya ga Natana'ilu yana zuwa wurinsa sai yayi magana game da shi, “Duba, Ba-Isra'ile na hakika wanda babu yaudara a cikinsa.” ");
INSERT INTO hauulb_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natana'ilu yace masa, “Ta yaya ka san ni?” Sai Yesu ya amsa masa yace, “Tun kafin Filibus ya kira ka, sa'adda kake a gindin baure, na gan ka.” ");
INSERT INTO hauulb_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natana'ilu ya amsa, “Rabbi, Kai Dan Allah ne! Kai Sarkin Isra'ila ne!” ");
INSERT INTO hauulb_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesu ya amsa masa yace, “Don na ce maka, 'Na gan ka a gindin Baure', ka gaskanta? Za ka ga abubuwa da suka fi wannan girma.” ");
INSERT INTO hauulb_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Sai yace, 'Hakika, hakika ina gaya maka, zaka ga sammai a bude, mala'ikun Allah kuma suna hawa suna sauka akan Dan Mutum.” ");
INSERT INTO hauulb_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Bayan kwana uku, akwai aure a Kana ta Galili, mahaifiyar Yesu kuma tana wurin. ");
INSERT INTO hauulb_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","An gayyaci Yesu da almajiransa zuwa auren. ");
INSERT INTO hauulb_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Da ruwan inabin ya kare, maihafiyar Yasu tace masa, “basu da ruwan inabi.” ");
INSERT INTO hauulb_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yesu yace mata, “Mace, me yasa kika zo wurina? Lokaci na bai yi ba tukuna”. ");
INSERT INTO hauulb_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Maihafiyarsa tace wa ma'aikatan, “Ku yi duk abin da yace maku.” ");
INSERT INTO hauulb_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","To akwai randunan ruwa na dutse guda shidda a wurin wadanda Yahudawa ke amfani da su domin al'adansu na tsarkakewa, kowace zata iya daukar durom guda. ");
INSERT INTO hauulb_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesu yace masu, “Cika randunan da ruwa”. Sai suka cika randunan makil. ");
INSERT INTO hauulb_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Sai yace wa ma'aikatan, “Ku diba daga ciki ku kai wa shugaban biki.” Sai suka yi hakannan. ");
INSERT INTO hauulb_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Shugaban bikin ya dandana ruwan da ya zama ruwan inabin, amma bai san inda ya fito ba (amma ma'aikatan wadanda suka jawo ruwan sun sani). Sai ya kira ango ");
INSERT INTO hauulb_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","yace masa, “Kowane mutum yakan raba ruwan inabi mai kyau da farko, kafin mai arhar bayan an shanye mai kyaun. Amma kai ka ajiye mai kyaun sai yanzu.” ");
INSERT INTO hauulb_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Wannan alama ta farko ce da Yesu yayi a Kana ta Galili, ya kuma bayyana daukakarsa, almajiransa kuma suka gaskata da shi. ");
INSERT INTO hauulb_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Bayan wannan, Yesu, da mahaifiyarsa, da 'yan'uwansa da almajiransa suka tafi Kafarnahum, kuma suka zauna can wasu 'yan kwanaki. ");
INSERT INTO hauulb_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","To idin ketarewa na Yahudawa ya kusato, Yesu kuwa ya wuce zuwa Urushalima. ");
INSERT INTO hauulb_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ya iske wadanda suke sayar da shanu da tumaki da tantabaru, masu canjin kudi kuma na zaune a wurin. ");
INSERT INTO hauulb_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Sai yayi tsumingiya da igiyoyi ya kore su duka daga cikin haikalin, duk da tumakin da shanun. Sai ya watsar da sulallan masu canjin kudin ya birkitar da teburansu. ");
INSERT INTO hauulb_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Yace wa masu sayar da tantabaru, “Ku fitar da wadannan abubuwa daga nan. Ku daina maida gidan Ubana wurin kasuwanci.” ");
INSERT INTO hauulb_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Almajiransa suka tuna a rubuce yake, “Himma domin gidanka za ta cinye ni.” ");
INSERT INTO hauulb_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Sai shugabannin Yahudawa suka amsa suka ce masa, “Wace alama za ka nuna mana, da shike kana yin wadannan abubuwan?” ");
INSERT INTO hauulb_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesu ya amsa, “Ku rushe wannan haikali, kuma a cikin kwana uku zan gina shi.” ");
INSERT INTO hauulb_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Sai shugabanin Yahudawa suka ce, “An dauki shekaru arba'in da shidda kamin a gama gina wannan haikalin, za ka dau kwanaki uku kadai wajen gina shi?” ");
INSERT INTO hauulb_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Amma yana nufin haikali na jikinsa ne. ");
INSERT INTO hauulb_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Bayan da aka tashe shi daga matattu, sai almajiransa suka tuna ya fadi haka, suka kuma ba da gaskiya ga nassi da wannan kalami da Yesu ya fada. ");
INSERT INTO hauulb_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Kuma, da yana Urushalima a idin ketarewa, a lokacin idin, mutane da yawa suka gaskata ga sunansa, sa'adda suka ga alamun da ya yi. ");
INSERT INTO hauulb_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Amma Yesu bai yadda da su ba domin ya san su duka, ");
INSERT INTO hauulb_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","saboda baya bukatar wani ya shaida masa game da mutum, domin ya san abinda ke cikin sa. ");
INSERT INTO hauulb_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","akwai wani Bafarise da ake kira Nikodimu, shugaba a cikin Yahudawa. ");
INSERT INTO hauulb_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Wannan mutum ya zo wurin Yesu da dare ya ce masa, “Rabbi, mun sani cewa kai malami ne da kazo daga wurin Allah, gama ba wanda zai iya yin wadannan alamu da kake yi sai idan Allah na tare da shi.” ");
INSERT INTO hauulb_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesu ya amsa masa, “Hakika, hakika, idan ba a sake haifuwar mutum ba, ba zai iya ganin mulkin Allah ba.” ");
INSERT INTO hauulb_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodimu ya ce masa, “Yaya za a sake haifuwar mutum bayan ya tsufa? Ba zai iya sake shiga cikin cikin uwarsa kuma a haife shi ba, zai iya?” ");
INSERT INTO hauulb_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesu ya amsa, “Hakika, hakika, idan ba a haifi mutum da ruwa da kuma Ruhu ba, ba zai iya shiga cikin mulkin Allah ba. ");
INSERT INTO hauulb_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Abin da aka haifa ta wurin jiki, jiki ne, kuma abin da aka haifa ta wurin Ruhu, Ruhu ne. ");
INSERT INTO hauulb_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Kada ka yi mamaki don na ce maka, 'dole a maya haifuwar ka.' ");
INSERT INTO hauulb_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Iska takan hura duk inda ta ga dama. Ka kan ji motsin ta, amma ba ka san inda ta fito ko inda za ta tafi ba. Haka duk wanda aka haifa daga Ruhu.” ");
INSERT INTO hauulb_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodimu ya amsa yace masa, “Yaya wannan zai yiwu?” ");
INSERT INTO hauulb_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesu ya amsa yace masa, “Kai malami ne a Israila amma ba ka san wadannan al'amura ba? ");
INSERT INTO hauulb_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Hakika, hakika, ina gaya maka, muna fadin abubuwan da muka sani, kuma muna shaida abubuwan da muka gani. Duk da haka ba ku karbi shaidar mu ba. ");
INSERT INTO hauulb_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Idan na gaya maka abubuwan da ke na duniya amma baka gaskata ba, to yaya zaka gaskata idan na gaya maka abubuwa na sama? ");
INSERT INTO hauulb_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Babu wanda ya taba hawa zuwa sama sai dai shi wanda ya sauko daga sama: wato Dan Mutum. ");
INSERT INTO hauulb_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Kamar yadda Musa ya ta da maciji a jeji, haka ma dole a ta da Dan Mutum ");
INSERT INTO hauulb_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","domin dukan wadanda suka bada gaskiya gareshi su sami rai na har abada. ");
INSERT INTO hauulb_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Gama Allah ya kaunaci duniya sosai, har ya ba da makadaicin Dansa, domin duk wanda ya bada gaskiya gareshi, kada ya mutu, amma ya samu rai madawwami. ");
INSERT INTO hauulb_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Gama Allah bai aiko da Dansa cikin duniya domin ya kayar da duniya ba, amma domin a ceci duniya ta wurin sa. ");
INSERT INTO hauulb_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Duk wanda ya bada gaskiya gare shi ba a kayar da shi ba, amma duk wanda bai bada gaskiya gare shi ba an riga an kayar da shi, domin bai bada gaskiya ga sunan wannan da shi kadai ne Dan Allah ba. ");
INSERT INTO hauulb_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Wannan shi ne dalilin shari'ar, domin haske ya zo duniya, amma mutane suka kaunaci duhu fiye da hasken, sabili da ayyukan su na mugunta ne. ");
INSERT INTO hauulb_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Domin duk wanda ke mugayen ayyuka ya ki haske, kuma baya zuwa wurin hasken domin kada ayyukansa su bayyanu. ");
INSERT INTO hauulb_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Sai dai duk wanda yake aikata gaskiya kan zo wurin hasken domin ayyukansa, da ake aiwatarwa ga Allah, su bayyanu. ");
INSERT INTO hauulb_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Bayan wannan, Yesu da almajiransa suka tafi kasar Yahudiya. A can ya dan zauna tare da su ya kuma yi Baftisma. ");
INSERT INTO hauulb_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Yahaya ma yana Baftisma a Ainon kusa da Salim domin akwai ruwa da yawa a can. Mutane na zuwa wurin sa yana masu Baftisma, ");
INSERT INTO hauulb_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","domin a lokacin ba a jefa Yahaya a kurkuku ba tukuna. ");
INSERT INTO hauulb_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Sai gardama ta taso tsakanin almajiran Yahaya da wani Bayahude akan al'adun tsarkakewa. ");
INSERT INTO hauulb_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Suka je wurin Yahaya suka ce, “Rabbi, wanda yake tare da kai a dayan ketaren kogin Urdun, kuma ka shaida shi, duba, yana baftisma, kuma mutane duka suna zuwa wurin sa.” ");
INSERT INTO hauulb_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yahaya ya amsa, “Mutum ba zai iya samun wani abu ba sai an ba shi daga sama. ");
INSERT INTO hauulb_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ku da kanku zaku shaida na ce, 'Ba ni ne Almasihu ba' amma amaimakon haka, 'an aiko ni kafin shi.' ");
INSERT INTO hauulb_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Amaryar ta angon ce. Yanzu abokin angon, wanda ke tsaye yana saurarensa, yana murna sosai saboda muryan angon. Murnata ta cika domin wannan. ");
INSERT INTO hauulb_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Dole shi ya karu, ni kuma in ragu. ");
INSERT INTO hauulb_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Shi wanda ya fito daga sama ya fi kowa. Shi Wanda ya zo daga duniya, na duniya ne, kuma game da duniya yake magana. Shi wanda ya fito daga sama yana saman kowa. ");
INSERT INTO hauulb_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ya shaida abubuwan da ya ji ya kuma gani, amma babu wanda ya karbi shaidarsa. ");
INSERT INTO hauulb_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Duk wanda ya karbi shaidarsa ya tabbatar Allah gaskiya ne. ");
INSERT INTO hauulb_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Domin duk wanda Allah ya aika kan yi magana da kalmomin Allah. Domin bai bada Ruhun da ma'auni ba. ");
INSERT INTO hauulb_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Uban ya kaunaci Dan, ya kuma ba da dukan komai a hanunsa. ");
INSERT INTO hauulb_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Shi wanda ya bada gaskiya ga Dan ya na da rai madawwami, amma wanda ya ki yiwa Dan biyayya ba zai ga rai ba, amma fushin Allah na kansa. ");
INSERT INTO hauulb_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Da Yesu ya sani cewa Farisawa sun ji cewa yana samun almajirai yana kuma yi masu baftisma fiye da Yahaya ");
INSERT INTO hauulb_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(ko da shike ba Yesu da kansa ke yin baftismar ba, amma almajiransa ne), ");
INSERT INTO hauulb_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","ya bar Yahudiya ya koma Galili. ");
INSERT INTO hauulb_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Amma ya zamar masa dole ya ratsa ta Samariya. ");
INSERT INTO hauulb_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ya zo wani birnin Samariya, mai suna Sika, kusa da filin da Yakubu ya ba dansa Yusufu. ");
INSERT INTO hauulb_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Rijiyar Yakubu na wurin. Da Yesu ya gaji da tafiyarsa sai ya zauna gefen rijiyar. Kusan karfe goma sha biyu na rana ne. ");
INSERT INTO hauulb_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Wata mace, Ba-Samariya ta zo domin ta dibi ruwa, sai Yesu ya ce mata, “Ba ni ruwa in sha.” ");
INSERT INTO hauulb_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Gama almajiransa sun tafi cikin gari don sayen abinci. ");
INSERT INTO hauulb_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Sai ba-Samariyar tace masa, “Yaya kai da kake Bayahude kake tambaya ta ruwan sha, ni da nike 'yar Samariya?” Domin Yahudawa ba su harka da Samariyawa. ");
INSERT INTO hauulb_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Sai Yesu ya amsa yace mata, “In da kin san kyautar Allah, da shi wanda yake ce da ke, 'Ba ni ruwan sha,' da kin roke shi, sai kuma ya ba ki ruwan rai.” ");
INSERT INTO hauulb_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Matar tace masa, “Mallam, ga shi ba ka da guga, kuma rijiyar tana da zurfi. Ina za ka samu ruwan rai? ");
INSERT INTO hauulb_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ai ba ka fi Ubanmu Yakubu ba, ko ka fi shi, shi wanda ya ba mu rijiyar, shi kansa kuma ya sha daga cikin ta, haka kuma 'ya'yansa da shanunsa?” ");
INSERT INTO hauulb_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesu ya amsa yace mata, “duk wanda ya sha daga wannan ruwan zai sake jin kishi, ");
INSERT INTO hauulb_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","amma duk wanda ya sha daga ruwa da zan ba shi ba zai sake jin kishi ba. Maimakon haka, ruwan da zan bashi zai zama mabulbular ruwa a cikinsa wanda ke bulbula zuwa rai madawwami.” ");
INSERT INTO hauulb_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Matar tace masa, “Mallam, ka ba ni wannan ruwa yadda ba zan kara jin kishi ba ba kuma sai na zo nan don in dibi ruwa ba.” ");
INSERT INTO hauulb_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yesu ya ce mata, “Je, ki kira maigidanki ku zo nan tare.” ");
INSERT INTO hauulb_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Matar ta amsa tace masa, “Ba ni da miji.” Yesu yace, “Kin fadi daidai da kika ce, 'ba ni da miji,' ");
INSERT INTO hauulb_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","domin kin auri mazaje har biyar, kuma wanda kike da shi yanzu ba mijin ki bane. Abinda kika fada gaskiya ne.” ");
INSERT INTO hauulb_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Matar tace masa, “Mallam, Na ga kai annabi ne. ");
INSERT INTO hauulb_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ubaninmu sun yi sujada a wannan dutse, amma kun ce Urushalima ce wurin da ya kamata mutane su yi sujada.” ");
INSERT INTO hauulb_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesu ya ce mata, “Mace, ki gaskata ni, cewa lokaci na zuwa wanda ba za ku yi wa Uban sujada ba ko akan wannan dutse ko a Urushalima. ");
INSERT INTO hauulb_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ku kuna bauta wa abinda ba ku sani ba. Mu muna bauta wa abinda muka sani, gama ceto daga Yahudawa yake. ");
INSERT INTO hauulb_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Sai dai, sa'a tana zuwa, har ma ta yi, wadda masu sujada na gaskiya za su yi wa Uba sujada a cikin ruhu da gaskiya, domin irin wadannan ne Uban ke nema su zama masu yi masa sujada. ");
INSERT INTO hauulb_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Allah Ruhu ne, kuma mutanen da ke yi masa sujada, dole su yi sujada cikin ruhu da gaskiya.” ");
INSERT INTO hauulb_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Matar ta ce masa, “Na san Almasihu na zuwa (wanda ake kira Kristi). Sa'adda ya zo, zai bayyana mana kowane abu. ");
INSERT INTO hauulb_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yesu ya ce mata, “Ni ne shi, wanda ke yi maki magana.” ");
INSERT INTO hauulb_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","A daidai wannan lokaci, almajiransa suka dawo. Suna ta mamakin dalilin da yasa yake magana da mace, amma babu wanda yace, “Me kake so?” Ko kuma, “Don me ka ke magana da ita?” ");
INSERT INTO hauulb_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Sai matar ta bar tulunta, ta koma cikin gari, tace wa mutanen, ");
INSERT INTO hauulb_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Ku zo ku ga wani mutum wanda ya gaya mani duk wani abu da na taba yi. Wannan dai ba Almasihun bane, ko kuwa?” ");
INSERT INTO hauulb_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Suka bar garin suka zo wurinsa. ");
INSERT INTO hauulb_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","A wannan lokacin, almajiransa suna rokansa, cewa, “Mallam, ka ci.” ");
INSERT INTO hauulb_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Amma ya ce masu, “ina da abinci da ba ku san komai akai ba.” ");
INSERT INTO hauulb_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Sai almajiran suka ce da junansu, “Babu wanda ya kawo masa wani abu ya ci, ko akwai ne?” ");
INSERT INTO hauulb_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yesu ya ce masu, “Abincina shine in yi nufin wanda ya aiko ni, in kuma cika aikinsa. ");
INSERT INTO hauulb_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ba ku kan ce, 'akwai wata hudu tukuna kafin girbi ya zo ba?' Ina gaya maku, daga idanunku ku ga gonakin, sun rigaya sun isa girbi. ");
INSERT INTO hauulb_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Shi wanda ke girbi yakan karbi sakamako ya kuma tattara amfanin gona zuwa rai na har abada, ta haka shi mai shuka da shi mai girbi za su yi farinciki tare. ");
INSERT INTO hauulb_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Gama cikin wannan maganar take, 'Wani na shuka, wani kuma na girbi.' ");
INSERT INTO hauulb_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Na aike ku ku yi girbin abinda ba ku yi aiki a kai ba. Wandansu sun yi aiki, ku kuma kun shiga cikin wahalarsu. ");
INSERT INTO hauulb_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Yawancin Samariyawan da ke wannan birni suka gaskata da shi sabili da labarin matar data bada shaida, “Ya gaya mani duk abinda na taba yi.” ");
INSERT INTO hauulb_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","To sa'adda Samariyawa suka zo wurinsa, sai suka roke shi ya zauna tare da su, ya kuwa zauna wurin kwana biyu. ");
INSERT INTO hauulb_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Wasu da dama kuma suka gaskata domin maganarsa. ");
INSERT INTO hauulb_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Suka cewa matar, “Mun bada gaskiya, ba saboda maganar ki kadai ba, amma mu kanmu munji, yanzu kuma mun sani cewa wannan lallai shine mai ceton duniya.” ");
INSERT INTO hauulb_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Bayan wadannan kwana biyu, ya bar wurin zuwa Galili. ");
INSERT INTO hauulb_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Domin Yesu da kansa yace, ba a girmama annabi a kasarsa. ");
INSERT INTO hauulb_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Da ya zo Galili, Galiliyawan suka marabce shi. Sun ga dukan abubuwan da ya yi a Urushalima wurin idin, domin su ma sun je idin. ");
INSERT INTO hauulb_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Kuma ya koma Kana ta Galili inda ya mayar da ruwa zuwa ruwan inabi. Akwai wani ma'aikacin fada wanda dansa na rashin lafiya a Kafarnahum. ");
INSERT INTO hauulb_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Da ya ji cewa Yesu ya bar Yahudiya ya koma Galili, sai ya tafi wurin Yesu ya roke shi ya sauko ya warka da dansa wanda ke bakin mutuwa. ");
INSERT INTO hauulb_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yesu yace masa, “Idan ba ku ga alamu da mu'ujizai ba, ba za ku gaskata ba.” ");
INSERT INTO hauulb_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ma'aikacin ya ce masa, “Mallam, ka sauko kafin da na ya mutu.” ");
INSERT INTO hauulb_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yesu yace masa, “Je ka. Dan ka ya rayu.” Mutumin ya gaskata maganar da Yesu ya gaya masa, Sai yayi tafiyarsa. ");
INSERT INTO hauulb_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Yayin da yake sauka kasa, bayinsa suka same shi, suna cewa, danka yana raye. ");
INSERT INTO hauulb_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Sai ya tambaye su sa'ar da ya fara samun sauki. Suka amsa masa, “Jiya a sa'a ta bakwai zazabin ya bar shi.” ");
INSERT INTO hauulb_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Sai Uban ya gane cewa wannan sa'a ce Yesu ya ce masa, “Jeka, danka na raye.” Sabili da haka, shi da dukan gidansa suka bada gaskiya. ");
INSERT INTO hauulb_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Wannan ce alama ta biyu da Yesu ya yi bayan da ya bar Yahudiya zuwa Galili. ");
INSERT INTO hauulb_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Bayan haka akwai idi na yahudawa, kuma Yesu ya tafi Urashalima. ");
INSERT INTO hauulb_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","To a cikin Urashilima kusa da kofar tumaki akwai tabki, wanda ake kira Baitasda da harshen Ibraniyanci, yana da shirayi biyar. ");
INSERT INTO hauulb_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Taron mutane dayawa masu ciwo da, makafi da guragu da shanyayyu suna kwance a wurin suna jira a dama ruwan. ");
INSERT INTO hauulb_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Gama mala'ikan Ubangiji kan sabko a cikin tabkin ya dama ruwan, wanda ya fara taba ruwan sai ya warke komai cutar da yake da ita. ");
INSERT INTO hauulb_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Akwai wani mutum a bakin tabki yana kwance yana da rashin lafiya har shekara talatin da takwas. ");
INSERT INTO hauulb_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Da Yesu ya gan shi yana kwance a wurin sai ya gane ya dade a wurin, sai ya ce masa, “ Ko kana so ka warke?” ");
INSERT INTO hauulb_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Sai mai rashin lafiyar ya amsa ya ce, “Malam, bani da kowa da zai sa ni a cikin tabkin idan ruwan ya motsa. Yayinda na ke kokari sai wani ya riga ni.” ");
INSERT INTO hauulb_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yesu ya ce masa,” Ka tashi ka dauki shimfidarka ka tafi.” ");
INSERT INTO hauulb_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Nan dan nan Mutumin ya warke, ya dauki shimfidarsa ya tafi. Ranar kuwa Asabar ce. ");
INSERT INTO hauulb_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Sai Yahudawa suka ce da wanda aka warkar din, “Ai, Asabar ce, bai kuwa halatta ka dauki shimfidarka ba.” ");
INSERT INTO hauulb_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Sai ya amsa ya ce, “Ai wanda ya warkar da ni, shine ya ce mani 'Dauki shimfidarka, ka tafi.” ");
INSERT INTO hauulb_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Suka tambaye shi, “wane mutum ne ya ce maka, 'Dauki shimfidar ka yi tafiya'?” ");
INSERT INTO hauulb_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Sai dai, shi wanda aka warka din, ba san ko wanene ya warkar da shi ba, domin Yesu ya riga ya tafi aboye, saboda akwai taro a wurin. ");
INSERT INTO hauulb_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Bayan haka, Yesu ya same shi a Haikalin, ya ce masa, “ka ga fa, ka warke. To, kada ka kara yin zunubi don kada wani abu da ya fi wannan muni ya same ka.” ");
INSERT INTO hauulb_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Sai mutumin ya tafi ya gaya wa Yahuduwa cewa Yesu ne ya warkar da shi. ");
INSERT INTO hauulb_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","To saboda haka Yahudawa suka fara tsanantawa Yesu, don ya yi wadannan abubuwa ran Asabar. ");
INSERT INTO hauulb_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yesu kuwa ya amsa masu ya ce, “Ubana yana aiki har yanzu, ni ma ina aiki.” ");
INSERT INTO hauulb_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Saboda haka, Yahudawa suka kara nema su kashe shi ba don ya keta Asabar kadai ba, amma kuma domin ya ce Allah Ubansa ne, wato yana maida kansa dai-dai da Allah. ");
INSERT INTO hauulb_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yesu ya amsa masu ya ce, hakika hakika, ina gaya maku, Dan ba ya yin kome shi kadai, sai abin da ya ga Uba yana yi. ");
INSERT INTO hauulb_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Domin Uban na kaunar Dan, yana kuma nuna masa dukan abinda shi da kansa yake yi, kuma zai nuna masa abubuwan da suka fi wadannan, domin ku yi mamaki. ");
INSERT INTO hauulb_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Gama kamar yadda Uba yakan tada matattu ya kuma basu rai, haka Dan ma yake bada rai ga duk wanda ya nufa. ");
INSERT INTO hauulb_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Gama Uban ba ya hukunta kowa, sai dai ya damka dukan hukunci ga Dan, ");
INSERT INTO hauulb_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","domin kowa ya girmama Dan, kamar yadda suke girmama Uban. Shi wanda ba ya girmama Dan, ba ya girmama Uban da ya aiko shi. ");
INSERT INTO hauulb_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Hakika, hakika, duk mai jin Maganata, yana kuma gaskata wanda ya aiko ni, yana da rai madawwami ba kuma za a kashe shi ba, domin ya ratse daga mutuwa zuwa rai. ");
INSERT INTO hauulb_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Hakika hakika, ina gaya maku, lokaci na zuwa, har ma ya yi da matattatu za su ji muryar Dan Allah, wadanda suka ji kuwa za su rayu. ");
INSERT INTO hauulb_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Kammar yada Uba ya ke da rai a cikinsa, haka ya ba Dan don ya zama da rai cikin kansa. ");
INSERT INTO hauulb_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Uban ya kuma ba Dan ikon zartar da hukunci, saboda shi ne Dan Mutum. ");
INSERT INTO hauulb_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Kada ku yi mamakin wannan, domin lokaci na zuwa da duk wadanda suke kaburbura za su ji muryarsa, ");
INSERT INTO hauulb_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","su kuma fito: wadanda suka aikata nagarta zawa tashi na rai, wadanda suka aikata mugunta kuwa zuwa tashi na hukunci. ");
INSERT INTO hauulb_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ba na iya yin kome ni da kai na. Yadda na ke ji, haka nake yin hukunci, Hukunci na kuwa na adalci ne, domin ba nufin kaina nake bi ba, sai dai nufin wanda ya aiko ni. ");
INSERT INTO hauulb_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Idan zan yi shaida game da kaina, shaidata baza ta zama gaskiya ba. ");
INSERT INTO hauulb_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Akwai wani wanda ya ke bada shaida game da ni, na kuwa sani shaidar da yake bayarwa game da ni gaskiya ce. ");
INSERT INTO hauulb_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Kun aika zuwa wurin Yahaya, shi kuma ya yi shaidar gaskiya. ");
INSERT INTO hauulb_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Duk da haka shaidar da na karba bata mutum bace. Na fadi wadanan abubuwa domin ku sami ceto. ");
INSERT INTO hauulb_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yahaya fitila ne mai ci, mai haske ne kuma, kun yarda ku yi farinciki da haskensa dan lokaci kadan. ");
INSERT INTO hauulb_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Amma shaidar da ni ke da ita ta fi ta Yahaya karfi. Domin ayyukan da Uba ya bani ni in yi, wato ainihin ayyukan da nake yi, su ne suke shaida ta cewa, Uba ne ya aiko ni. ");
INSERT INTO hauulb_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Uba wanda ya aiko ni, shi da kansa ya shaide ni. Ba ku taba jin muryar sa ba, ko ganin kamanninsa. ");
INSERT INTO hauulb_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Maganarsa kuwa ba ta zaune a zuciyarku, domin baku gaskata da wanda ya aiko ni ba. ");
INSERT INTO hauulb_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Kuna nazarin littattafai, don a tsammaninku a cikinsu za ku sami rai Madawwami, alhali kuwa su ne suke shaidata. ");
INSERT INTO hauulb_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","kuma baku niyyar zuwa wurina domin ku sami rai. ");
INSERT INTO hauulb_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Ba na karbar yabo daga wurin mutane, ");
INSERT INTO hauulb_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","amma na sani baku da kaunar Allah a zuciyarku. ");
INSERT INTO hauulb_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Na zo a cikin sunan Ubana, amma ba ku karbe ni ba. Idan wani ya zo da sunan kansa, za ku karbe shi. ");
INSERT INTO hauulb_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ta yaya za ku ba da gaskiya, ku da kuke karban yabo daga junanku, amma ba ku neman yabon dake zuwa daga wurin Allah? ");
INSERT INTO hauulb_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Kada ku yi tunani zan zarge ku a wurin Uba. Mai zargin ku shine Musa, wanda kuka sa begenku a cikin sa. ");
INSERT INTO hauulb_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Inda kun gaskata Musa, da kun gaskata da ni domin ya yi rubutu game da ni. ");
INSERT INTO hauulb_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Idan kuwa ba ku gaskata abin da ya rubuta ba, ta yaya za ku gaskata maganata?” ");
INSERT INTO hauulb_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Bayan waddannan abubuwa, Yesu ya ketare tekun Galili, wanda a ke kira tekun Tibariya. ");
INSERT INTO hauulb_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Sai taro mai yawa suka bi shi domin suna ganin alamu da yake yi akan marasa lafiya. ");
INSERT INTO hauulb_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Sai Yesu ya hau dutse ya zauna a can tare da almajiransa. ");
INSERT INTO hauulb_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","(Kuma da idin Ketarewa, wato idin Yahudawa, ya kusato.) ");
INSERT INTO hauulb_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Da Yesu ya daga kai sai ya ga babban taro yana zuwa wurinsa, sai ya ce ma Filibus, “Ina za mu sayi gurasar da Mutanen nan za su ci?” ");
INSERT INTO hauulb_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","( Ya fadi haka ne domin ya gwada shi, saboda shi kansa ya san abin da zai yi.) ");
INSERT INTO hauulb_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filibus ya amsa masa, “gurasar dinari biyu ma ba zata ishi kowannensu ya samu ko kadan ba.” ");
INSERT INTO hauulb_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Daya daga cikin almajiransa, wato Andarawus, dan'uwan Siman Bitrus, ya ce masa, ");
INSERT INTO hauulb_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Ga wani dan yaro nan da dunkule biyar na sha'ir, da kifi biyu. Amma menene wadannan za su yi wa mutane masu yawa?” ");
INSERT INTO hauulb_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yesu ya ce, “ku sa mutane su zauna.”( wurin kuwa akwai ciyawa.) Sai mazajen suka zauna, sun kai wajen dubu biyar. ");
INSERT INTO hauulb_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Sai Yesu ya dauki gurasar, bayan da ya yi godiya, sai ya rarraba wa wadanda suke zaune. Haka kuma ya rarraba kifin gwargwadon abin da zai ishe su. ");
INSERT INTO hauulb_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Da Mutanen suka ci suka kuma koshi, sai ya ce wa almajiransa, ku tattara gutsattsarin da suka rage, kada ya zama asara.” ");
INSERT INTO hauulb_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Sai suka cika kwanduna goma sha biyu da gutsattsarin gurasar nan biyar da ya rage bayan da kowa ya ci. ");
INSERT INTO hauulb_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Da jama'a suka ga alamar da ya yi, sai suka ce, “ Hakika wannan shi ne annabin nan mai zuwa cikin duniya. ");
INSERT INTO hauulb_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","“Da Yesu ya gane suna shirin zuwa su dauke shi da karfi da yaji su nada shi sarki, sai ya sake komawa kan dutsen da kansa. ");
INSERT INTO hauulb_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Da yamma ta yi, sai almajiransa suka gangara teku. ");
INSERT INTO hauulb_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Suka shiga cikin jirgi, suka haye teku zuwa kafarnahum. (A lokacin duhu ya yi, Yesu kuwa bai riga ya iso wurinsu ba tukuna.) ");
INSERT INTO hauulb_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Iska mai karfin gaske tana kadawa, kuma tekun yana hargowa. ");
INSERT INTO hauulb_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Bayan da almajiran suka yi tuki na wajen kimanin mil ashirin da biyar ko talatin, sai suka hango Yesu yana tafiya a kan teku ya kuma kusa da jirgin, sai suka firgita. ");
INSERT INTO hauulb_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Amma ya ce masu, “Ni ne! kada ku firgita.” ");
INSERT INTO hauulb_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Sa'an nan suka yarda suka karbe shi a cikin jirgin, kuma nan da nan jirgin ya kai gacci. ");
INSERT INTO hauulb_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Kashe gari, sauran taron da suke tsaye a dayan hayin tekun suka ga cewa babu wani jirgi a wajen sai dayan, Yesu kuma bai shiga ciki da almajiransa ba, amma almajiransa suka tafi su kadai. ");
INSERT INTO hauulb_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Sai dai, akwai wadansu jirage da suka zo daga Tibariya kusa da wurin da taron suka ci gurasa bayan da Ubangiji ya yi godiya. ");
INSERT INTO hauulb_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Sa'anda taron suka gane cewa Yesu da almajiransa ba su wurin, su da kansu su ka shiga cikin jiragen suka tafi Kafarnahum neman Yesu. ");
INSERT INTO hauulb_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Da suka same shi a hayin tekun, suka ce masa, “Mallam, yaushe ka zo nan?” ");
INSERT INTO hauulb_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesu ya amsa masu, da cewa, “ hakika, kuna nema na ne, ba don kun ga alamu ba, amma domin kun ci gurasar nan kun koshi. ");
INSERT INTO hauulb_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ku daina yin wahala a kan neman abinci mai lalacewa, sai dai a kan abinci mai dawwama wanda zai kaiku ga rai madawwami wanda Dan Mutum zai ba ku, domin Ubangiji Allah ya sa hatiminsa a kansa.” ");
INSERT INTO hauulb_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Sai suka ce Masa, “Me za mu yi, domin mu aikata ayyukan Allah? ");
INSERT INTO hauulb_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesu ya amsa, “Wannan shi ne aikin Allah: wato ku gaskata da wanda ya aiko.” ");
INSERT INTO hauulb_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Sai suka ce masa, “To wace alama za ka yi, don mu gani mu gaskata ka? ");
INSERT INTO hauulb_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Me za ka yi? Kakanninmu sun ci manna a jeji, kamar yadda aka rubuta, “Ya ba su gurasa daga sama su ci.” ");
INSERT INTO hauulb_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Sa'an nan Yesu ya ce masu, “hakika, hakika, ina gaya maku ba Musa ne ya ba ku gurasa nan daga sama ba, amma Ubana ne ya baku gurasa ta gaskiya daga sama. ");
INSERT INTO hauulb_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Gurasar Allah itace mai saukowa daga sama mai kuma bada rai ga duniya,” ");
INSERT INTO hauulb_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Sai suka ce masa, “Mallam, ka rika ba mu irin wannan gurasa kodayaushe.” ");
INSERT INTO hauulb_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yesu ya ce masu, “Ni ne gurasa mai ba da rai. Wanda ya zo wurina ba zai ji yunwa ba, wanda kuma ya gaskanta da ni ba zai kara jin kishi ba. ");
INSERT INTO hauulb_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Amma na gaya maku cewa, hakika kun gan ni, duk da haka ba ku ba da gaskiya ba. ");
INSERT INTO hauulb_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Duk wanda Uba ya bani zai zo gare ni, wanda kuwa ya zo gare ni ba zan kore shi ba ko kadan. ");
INSERT INTO hauulb_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Gama na sauko daga sama, ba domin in bi nufin kaina ba, sai dai nufin wanda ya aiko ni. ");
INSERT INTO hauulb_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Wannan shi ne nufin wanda ya aiko ni, kada in rasa ko daya daga cikin wadannan da ya bani, sai dai in tashe su a ranar karshe. ");
INSERT INTO hauulb_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Gama wannan shi ne nufin Ubana, duk wanda yake ganin Dan ya kuma gaskata da shi zai sami rai madawwami, ni kuma zan tashe shi a ranar karshe. ");
INSERT INTO hauulb_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Sai Yahudawa suka yi gunaguni akansa, domin ya ce, “Nine Gurasar da ta sauko daga sama.” ");
INSERT INTO hauulb_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Suka ce, “Ba wannan ne Yesu Dan Yusufu, wanda Ubansa da Uwarsa mun san su ba? Ta yaya yanzu zai ce, 'Na ya sauko daga sama'? ");
INSERT INTO hauulb_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yesu ya amsa, ya ce masu, “Kada ku yi gunaguni a junanku. ");
INSERT INTO hauulb_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ba mai iya zuwa wurina sai dai in Uba wanda ya aiko ni ya jawo shi, ni kuwa zan tashe shi a rana ta karshe. ");
INSERT INTO hauulb_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","A rubuce yake cikin litattafan anabawa cewa, 'Dukkansu Allah zai koya masu'. Duk wanda ya ji ya kuma koya daga wurin Uba, ya kan zo gare ni. ");
INSERT INTO hauulb_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ba cewa wani ya taba ganin Uban ba, sai shi wanda yake daga wurin Allah - shine ya ga Uban. ");
INSERT INTO hauulb_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Hakika, hakika, wanda ya bada gaskiya, yana da rai Madawwami. ");
INSERT INTO hauulb_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ni ne Gurasa ta rai. ");
INSERT INTO hauulb_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ubanninku sun ci manna cikin jeji, suka kuma mutu. ");
INSERT INTO hauulb_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ga gurasa da ta sauko daga sama, domin mutum ya ci daga cikinta ba kuwa zai mutu ba. ");
INSERT INTO hauulb_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ni ne gurasa mai rai da ya sauko daga sama. Duk wanda ya ci daga gurasar, zai rayu har abada. Wannan gurasar da zan bayar jiki na ne don ceton duniya.” ");
INSERT INTO hauulb_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Sai Yahudawa suka fusata a tsakanin junansu suka kuma fara gardama, cewa, “Yaya mutumin nan zai iya bamu naman jikinsa mu ci? ");
INSERT INTO hauulb_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Sai Yesu ya ce masu, “ hakika, hakika, in ba ku ci naman jikin Dan mutum ba, ba ku kuma sha jininsa ba, ba za ku sami rai a cikin ku ba. ");
INSERT INTO hauulb_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Dukan wanda ya ci nama na ya kuma sha jinina yana da rai Madawwami, ni kuwa zan tashe shi a ranar karshe. ");
INSERT INTO hauulb_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Domin namana abinci ne na gaske, jinina kuma abin sha ne na gaskiya. ");
INSERT INTO hauulb_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Duk wanda ya ci namana, ya kuma sha jinina yana zamne a ciki na, ni kuma a cikinsa. ");
INSERT INTO hauulb_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Kamar yadda rayayyen Uba ya aiko ni, nake kuma rayuwa saboda Uban, haka ma wanda ya ci namana, zai rayu sabo da ni. ");
INSERT INTO hauulb_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Wannan itace gurasar da ta sauko daga sama, ba irin wadda Ubanninku suka ci suka mutu ba. Dukan wanda ya ci gurasar zai rayu har abada.” ");
INSERT INTO hauulb_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesu ya fadi wadan nan abubuwa a cikin majami'a sa'ad da yake koyarwa a Kafarnahum. ");
INSERT INTO hauulb_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Da jin haka, da yawa daga cikin almajiransa suka ce, “Wannan Magana yana da karfi, wa zai iya jinta?” ");
INSERT INTO hauulb_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yesu, kuwa da yake ya sani a ransa da cewa almajiransa suna gunagunin wannan, sai ya ce masu, “Wannan ya zamar maku laifi? ");
INSERT INTO hauulb_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Yaya Ke nan in kun ga Dan Mutum yana hawa inda yake a da? ");
INSERT INTO hauulb_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ruhu shine mai bayar da rai; Jiki ba ya amfana komai. Kalmomin da na fada maku ruhu ne, da kuma rai. ");
INSERT INTO hauulb_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Amma fa akwai wadansun ku da ba su ba da gaskiya ba. Domin tun farko Yesu ya san wadanda ba su ba da gaskiya ba, da kuma wanda zai bashe shi. ");
INSERT INTO hauulb_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ya fada cewa, “shiyasa na gaya maku, ba mai iya zuwa wurina, sai ta wurin Uban.” ");
INSERT INTO hauulb_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Bayan haka, da yawa daga cikin almajiransa suka koma da baya, ba su kara tafiya tare da shi ba. ");
INSERT INTO hauulb_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Sai Yesu ya ce wa goma sha biyun, “ku ba kwa so ku tafi, ko ba haka ba? ");
INSERT INTO hauulb_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Bitrus ya amsa masa ya ce, “Ya Ubangiji, gun wa za mu je? kai kake da maganar rai madawwami. ");
INSERT INTO hauulb_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Mu kwa mun gaskata mun kuma sani kai ne mai tsarkin nan na Allah.” ");
INSERT INTO hauulb_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yesu ya ce masu, “Ba ni na zabe ku, goma sha biyu ba, amma dayanku Iblis ne?” ");
INSERT INTO hauulb_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Wato yana magana akan Yahuda dan Siman Iskariyoti, shi kuwa daya daga cikin sha-biyun ne, wanda zai ba da Yesu. ");
INSERT INTO hauulb_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Bayan wadannan abubuwa Yesu ya zagaya cikin Gallili, saboda baya so ya shiga cikin Yahudiya domin Yahudawa suna shirin su kashe shi. ");
INSERT INTO hauulb_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","To Idin Bukkoki na Yahudawa ya kusa. ");
INSERT INTO hauulb_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Sai 'yan'uwansa suka ce da shi, “ka tashi ka tafi Yahudiya, domin almajiranka su ga ayyukan da kake yi su ma. ");
INSERT INTO hauulb_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ba wanda ya ke yin wani abu a boye idan dai yana so kowa da kowa ya san shi. Da yake ka na yin wadannan abubuwa sai ka nuna kan ka a fili ga duniya. ");
INSERT INTO hauulb_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Domin ko 'yan'uwansa ma basu bada gaskiya gare shi ba. ");
INSERT INTO hauulb_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yesu ya ce dasu, “lokaci na bai yi ba tukuna, amma ku koyaushe lokacin ku ne. ");
INSERT INTO hauulb_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Duniya baza ta iya kin ku ba, amma ta ki ni saboda ina fadin cewa ayyukanta ba su da kyau. ");
INSERT INTO hauulb_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ku ku je wurin idin, ni ba zan je wurin idin ba domin lokacina bai yi ba tukuna. ");
INSERT INTO hauulb_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Bayan da ya gaya masu wadannan abubuwa, ya tsaya a cikin Gallili. ");
INSERT INTO hauulb_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Amma bayan da 'yan'uwansa su ka tafi wurin idin shi ma ya tafi, amma a asirce ba a fili ba. ");
INSERT INTO hauulb_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Saboda Yahudawa suna neman sa a wurin idin, su na cewa “Ina yake?” ");
INSERT INTO hauulb_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Akwai maganganu dayawa a kansa cikin taron. Wadansu suna cewa, “shi mutumin kirki ne.” Wadansu kuma suna cewa,”A'a yana karkatar da hankalin jama'a.” ");
INSERT INTO hauulb_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Amma duk da haka ba wanda ya yi magana a fili a kansa saboda suna jin tsoron Yahudawa. ");
INSERT INTO hauulb_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Sa'anda aka kai rabin idin, sai Yesu ya shiga cikin haikali ya fara koyarwa. ");
INSERT INTO hauulb_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Yahudawa suna mamaki suna cewa,”Yaya aka yi wannan mutum ya sami ilimi dayawa haka? Shi kuwa bai je makaranta ba.” ");
INSERT INTO hauulb_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yesu ya ba su amsa ya ce,”Koyarwata ba tawa ba ce, amma ta wanda ya aiko ni ce.” ");
INSERT INTO hauulb_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Idan wani yana so ya yi nufinsa, za ya gane koyarwannan ko daga wurin Allah ta zo, ko ko tawa ce ta kaina. ");
INSERT INTO hauulb_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ko wanene yake maganar kansa, yana neman darajar kansa kenan, amma ko wanene ya nemi darajar wanda ya aiko ni, wannan mutum mai gaskiya ne, babu rashin adalci a cikin sa. ");
INSERT INTO hauulb_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Ba Musa ya baku dokoki ba? Amma duk da haka ba mai aikata dokokin. Me yasa ku ke so ku kashe ni? ");
INSERT INTO hauulb_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Taron suka ba shi amsa, “Ka na da aljani. Wanene yake so ya kashe ka?” ");
INSERT INTO hauulb_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesu ya amsa ya ce masu, “Nayi aiki daya, dukan ku kuna mamaki da shi. ");
INSERT INTO hauulb_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Musa ya baku kaciya, {ba kuwa daga Musa take ba, amma daga kakannin kakanni ta ke}, kuma a ranar Asabar kukan yi wa mutum kaciya. ");
INSERT INTO hauulb_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Idan mutum ya karbi kaciya ranar Asabar, domin kada a karya dokar Musa, don me kuka ji haushi na saboda na mai da mutum lafiyayye sarai ranar Asabar? ");
INSERT INTO hauulb_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Kada ku yi shari'a ta ganin ido, amma ku yi shari'a mai adalci.” ");
INSERT INTO hauulb_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Wadansun su daga Urushalima suka ce, “wannan ba shine wannan da suke nema su kashe ba?” ");
INSERT INTO hauulb_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Kuma duba, yana magana a fili, sannan ba wanda ya ce da shi komai. Ba zai yiwu ba mahukunta su sani cewa wannan Kristi ne, ko ba haka ba? ");
INSERT INTO hauulb_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","da haka, mun san inda wannan mutum ya fito. Amma sa'anda Kristi za ya zo, ba wanda zai san inda ya fito.” ");
INSERT INTO hauulb_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yesu yayi magana da karfi a haikali, yana koyarwa ya na cewa, “Kun san ni kuma kun san inda na fito. Ban zo domin kaina ba, amma wanda ya aiko ni mai gaskiya ne, ku kuwa baku san shi ba. ");
INSERT INTO hauulb_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ni na san shi domin daga wurinsa na fito, kuma shine ya aiko ni.” ");
INSERT INTO hauulb_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Suna kokari su kama shi, amma ba wanda ya iya sa masa hannu domin sa'arsa ba ta yi ba tukuna. ");
INSERT INTO hauulb_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Duk da haka wadansu dayawa a cikin taron suka bada gaskiya gare shi suka ce,”Sa'anda Kristi ya zo, zai yi alamu fiye da wadanda wannan mutum ya yi?” ");
INSERT INTO hauulb_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Farisawa suka ji tattarmukan suna yin rada a kan wadannan abubuwa game da Yesu, Sai manyan malamai da Farisawa su ka aika jami'ai su kama shi. ");
INSERT INTO hauulb_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Sa'annan Yesu yace ma su,” jimawa kadan ina tare ku, sa'annan in tafi wurin wanda ya aiko ni. ");
INSERT INTO hauulb_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Za ku neme ni ba za ku same ni ba; inda na tafi, ba za ku iya zuwa ba.” ");
INSERT INTO hauulb_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Yahudawa fa su ka cewa junan su, “Ina wannan mutum zai je inda ba za mu iya samun sa ba? Ko za ya tafi wurin Helinawa na warwatsuwa ya koyawa Helinawa? ");
INSERT INTO hauulb_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Wace kalma ya ke fadi haka, 'za ku neme ni amma ba za ku same ni ba; inda na tafi, ba za ku iya zuwa ba'?” ");
INSERT INTO hauulb_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","To a rana ta karshe, babbar rana ta idin, Yesu ya mike ya yi magana da karfi cewa, “Idan kowa yana jin kishi, ya zo wuri na ya sha. ");
INSERT INTO hauulb_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Shi wanda ya bada gaskiya gare ni kamar yadda nassi ya fadi, daga cikin sa rafukan ruwa na rai za su bulbulo.” ");
INSERT INTO hauulb_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Amma ya fadi haka a kan Ruhu, wanda wadanda suka bada gaskiya gare shi za su karba; ba a ba da Ruhun ba tukuna, saboda ba a rigaya an daukaka Yesu ba. ");
INSERT INTO hauulb_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Wadansu a cikin taron, sa'anda suka ji wadannan kalmomi, suka ce, “Wannan lallai annabi ne.” ");
INSERT INTO hauulb_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Wadansu suka ce, “Wannan Almasihu ne.” Amma wadansu suka ce, “Almasihu zai fito daga Gallili ne.? ");
INSERT INTO hauulb_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ba nassi ya ce Almasihu zai fito daga cikin dangin Dauda daga Baitalami ba, daga kauyen da Dauda ya fito?” ");
INSERT INTO hauulb_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Sai aka sami rabuwa a cikin taron saboda shi. ");
INSERT INTO hauulb_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Da wadansun su sun kama shi, amma ba wanda ya sa masa hannu. ");
INSERT INTO hauulb_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Sa'annan jami'an suka dawo wurin manyan Fristoci da Farisawa, wadanda suka ce,” me yasa ba ku kawo shi ba?” ");
INSERT INTO hauulb_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Jami'an su ka amsa, “Ba mutumin da ya taba yin magana kamar haka.” ");
INSERT INTO hauulb_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Farisawa suka amsa masu, “kuma an karkatar da ku? ");
INSERT INTO hauulb_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ko wani daga cikin mahukunta ya bada gaskiya gare shi, ko kuwa daga cikin Farisawa? ");
INSERT INTO hauulb_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Amma wannan taro da basu san shari'a ba, la'anannu ne.” ");
INSERT INTO hauulb_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodimus ya ce masu, (shi wanda ya zo wurin Yesu da, daya daga cikin Farisawa), ");
INSERT INTO hauulb_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“ Ko shari'armu bata hana hukunta mutum ba, sai ta ji daga gare shi ta kuma san abin da ya aikata ba?” ");
INSERT INTO hauulb_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Suka amsa masa suka ce,”kai ma daga Galili ka fito? Ka yi bincike ka gani ba annanbin da zai fito daga Galili.” ");
INSERT INTO hauulb_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Daga nan sai kowa ya tafi gidansa. ");
INSERT INTO hauulb_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Yesu ya je Dutsen Zaitun. ");
INSERT INTO hauulb_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Da sassafe ya dawo Haikali, dukan mutane kuma suka zo wurin sa; yazauna koya masu. ");
INSERT INTO hauulb_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Sai marubuta da Farisawa suka kawo mace wadda aka kama ta tana zina. Su ka sa ta a tsakiya. ");
INSERT INTO hauulb_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Sai su ka ce da shi, “Malam, wannan mace an kama ta tana cikin yin zina. ");
INSERT INTO hauulb_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","A cikin shari'a, Musa ya bamu umurni mu jejjefe irin wandannan mutume, kai me ka ce game da ita?” ");
INSERT INTO hauulb_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Sun fadi haka ne domin su gwada shi su sami abinda za su zarge shi da shi, amma Yesu ya sunkuya yayi rubutu da yatsansa a kasa. ");
INSERT INTO hauulb_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Sa'adda suka cigaba da tambayar sa, ya mike tsaye yace masu, “shi wanda ba shi da zunubi a cikin ku, ya fara jifar ta da dutse.” ");
INSERT INTO hauulb_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ya sake sunkuyawa, ya yi rubutu da yatsansa a kasa. ");
INSERT INTO hauulb_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Da suka ji haka, sai suka fita dai-dai da dai-dai, kama daga babbansu. A karshe dai aka bar Yesu shi kadai, tare da matar wadda ta ke a tsakiyar su. ");
INSERT INTO hauulb_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yesu ya tashi tsaye ya ce da ita, “mace, ina masu zargin ki? Ba wanda ya kashe ki? ");
INSERT INTO hauulb_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ta ce, “Ba kowa, Ubangiji” Yesu ya ce, “Ni ma ban kashe ki ba. Ki yi tafiyar ki, daga yanzu kada ki kara yin zunubi.” ");
INSERT INTO hauulb_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yesu ya kara yin magana da mutanen cewa, “Ni ne hasken duniya, shi wanda ya biyo ni, ba zai yi tafiya cikin duhu ba, amma za ya sami hasken rai. ");
INSERT INTO hauulb_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Farisawa suka ce masa, “Kana bada shaida a kan ka, shaidarka ba gaskiya ba ce.” ");
INSERT INTO hauulb_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesu ya amsa ya ce masu, “Ko ma na bada shaida a kai na, shaidata gaskiya ce, na san daga inda na fito da inda zan tafi, amma ku baku san daga inda na fito ba, baku kuma san inda zan tafi ba. ");
INSERT INTO hauulb_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Kuna shari'a ta son kai, ni ko ban yi wa kowa shari'a ba. ");
INSERT INTO hauulb_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ko ma da na yi shari'a, shari'ata gaskiya ce domin ba ni kadai ba ne, amma ina tare da Uba wanda ya aiko ni. ");
INSERT INTO hauulb_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","I, a cikin dokarku an rubuta cewa shaidar mutum biyu gaskiya ce. ");
INSERT INTO hauulb_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ni ne ni ke shaidar kaina, kuma Uba wanda ya aiko ni ya na shaida ta. ");
INSERT INTO hauulb_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Su ka ce da shi, “Ina ubanka?” Yesu ya amsa ma su ya ce, “baku san ni ba balle Ubana, in da kun san ni da kun san Uba na kuma. “ ");
INSERT INTO hauulb_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ya fadi wadannan kalmomi a kusa da wurin ajiya sa'adda ya ke koyarwa a cikin haikali, kuma ba wanda ya kama shi saboda sa'arsa bata yi ba tukuna. ");
INSERT INTO hauulb_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ya kara cewa da su,”Zan tafi, za ku neme ni ba za ku same ni ba, za ku mutu cikin zunubinku. Inda ni ke tafiya, ba za ku iya zuwa ba”. ");
INSERT INTO hauulb_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Yahudawa su ka ce,”Zai kashe kansa ne, da ya ce inda ni ke tafiya ba za ku iya zuwa ba?” ");
INSERT INTO hauulb_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yesu ya ce masu ku daga kasa kuke, Ni kuwa daga bisa ni ke. Ku na wannan duniya ne, Ni kuwa ba na wannan duniya ba ne. ");
INSERT INTO hauulb_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Shiyasa na ce maku za ku mutu cikin zunubanku. In ba kun bada gaskiya NI NE ba, za ku mutu cikin zunubanku. ");
INSERT INTO hauulb_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Sai kuma suka ce da shi,”Wanene kai?” Yesu ya ce masu, “Abin da na gaya maku tun daga farko. ");
INSERT INTO hauulb_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ina da a bubuwa da yawa da zan gaya maku, in kuma hukunta ku a kai. Duk da haka, wanda ya aiko ni, mai gaskiya ne, abubuwan da naji daga wurin sa, wadannan abubuwan su ni ke gaya wa duniya.” ");
INSERT INTO hauulb_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ba su gane ba yana yi masu magana a kan Uban. ");
INSERT INTO hauulb_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Yesu ya ce, “Sa'adda kuka tada Dan Mutum sama sa'annan za ku gane NI NE, kuma ban yi komi domin kaina ba. Kamar yadda Uba ya koya mani, haka nike fadin wadannan abubuwa. ");
INSERT INTO hauulb_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Shi wanda ya aiko ni, yana tare da ni kuma bai bar ni ni kadai ba, domin kullum ina yin abubuwan da suke faranta masa rai.” ");
INSERT INTO hauulb_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Sa'adda Yesu ya ke fadin wadannan abubuwa, dayawa suka bada gaskiya gare shi. ");
INSERT INTO hauulb_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yesu ya gayawa wadancan Yahudawa da suka bada gaskiya gare shi, “Idan kun tsaya a cikin magana ta ku almajiraina ne na gaskiya, ");
INSERT INTO hauulb_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Kuma za ku san gaskiya, gaskiya kuwa zata 'yantar da ku.” ");
INSERT INTO hauulb_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Suka amsa masa, “ Mu zuriyar Ibrahim ne kuma bamu taba yin bauta wurin kowa ba, yaya za ka ce, 'Za a 'yantar da ku'?” ");
INSERT INTO hauulb_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesu ya ce masu, “Hakika, hakika, ina ce maku, dukan wanda ya ke aika zunubi bawan zunubi ne. ");
INSERT INTO hauulb_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Bawa kuwa, ba ya zama a gida dindindin, da yana zama dindindin. ");
INSERT INTO hauulb_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Saboda haka, idan Dan ya 'yantar da ku zaku zama 'yantattu sosai. ");
INSERT INTO hauulb_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Na san ku zuriyar Ibrahim ne, kuna so ku kashe ni saboda kalma ta bata da wurin zama a cikin ku. ");
INSERT INTO hauulb_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Na fadi abubuwan da na gani a wurin Ubana, ku kuma kuna yin abubuwan da kuka ji daga wurin ubanku.” ");
INSERT INTO hauulb_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Suka amsa suka ce masa, “Ibrahim ne ubanmu” Yesu ya ce masu, “Da ku 'yayan Ibrahim ne da kun yi ayukan da Ibrahim ya yi. ");
INSERT INTO hauulb_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Amma, yanzu kuna so ku kashe ni, mutumin da ya gaya maku gaskiyar da ya ji daga wurin Allah. Ibrahim bai yi haka ba. ");
INSERT INTO hauulb_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Kuna yin ayyukan ubanku. Suka ce masa, “mu ba a haife mu cikin fasikanci ba, muna da Uba daya: Allah.” ");
INSERT INTO hauulb_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesu ya ce masu, “Inda Allah Ubanku ne, da kun kaunace ni, gama na zo daga wurin Allah kuma ga ni anan, gama ba domin kaina nazo ba, shine ya aiko ni. ");
INSERT INTO hauulb_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Meyasa baku gane magana ta ba? Ai saboda ba za ku iya jin maganata ba ne. ");
INSERT INTO hauulb_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ku na ubanku, shaidan ne, kuma kuna so ku yi nufe-nufe na ubanku. Shi mai kisan kai ne tun daga farko kuma ba ya tsayawa gaskiya saboda da babu gaskiya a cikin sa. Sa'anda yake fadin karya, yana maganar halinsa ne domin shi dama makaryaci ne da uban karya kuma. ");
INSERT INTO hauulb_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Dayake ina fadin gaskiya baku bada gaskiya gare ni ba. ");
INSERT INTO hauulb_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Wanene a cikin ku ya kama ni da zunubi? Idan na fadi gaskiya don me ba ku gaskanta ni ba? ");
INSERT INTO hauulb_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Shi wanda yake na Allah ya kan ji maganar Allah, ku ba kwa jin maganar Allah da yake ku ba na Allah bane,” ");
INSERT INTO hauulb_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Yahudawa suka amsa suka ce masa, “Bamu fadi gaskiya ba da muka ce kai Basamariye ne kuma kana da aljan?” ");
INSERT INTO hauulb_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesu ya amsa, “Ni ba ni da aljan, ina girmama Ubana, ku kuma ba kwa girmama ni.” ");
INSERT INTO hauulb_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ba na neman daraja domin kaina, akwai wanda ke nema yana kuma hukuntawa. ");
INSERT INTO hauulb_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Hakika, hakika, iIna ce maku, dukan wanda ya kiyaye maganata, ba za ya ga mutuwa ba.” ");
INSERT INTO hauulb_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Sai Yahudawa su ka ce masa, Yanzu mun sani kana da aljan. Ibrahim da annabawa sun mutu, amma kai ka ce, 'dukan wanda ya yi biyayya da maganata ba zai dandana mutuwa ba'. ");
INSERT INTO hauulb_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ai baka fi ubanmu Ibrahim girma ba wanda ya mutu, ko ka fi shi? Annabawa kuma sun mutu. Wa kake daukar kanka ne?” ");
INSERT INTO hauulb_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesu ya amsa, “Idan na daukaka kaina, daukaka ta banza ce, Ubana ne ya daukaka ni. Wanda kuka ce shi ne Allahnku. ");
INSERT INTO hauulb_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ku kuwa ba ku san shi ba, amma ni na san shi. Idan na ce ban san shi ba, na zama kamar ku kenan, makaryaci. Sai dai, Ni na san shi ina kiyaye maganarsa. ");
INSERT INTO hauulb_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ubanku Ibrahim ya yi farinciki da ganin rana ta; ya gan ta kuma ya yi murna.” ");
INSERT INTO hauulb_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Yahudawa su ka ce masa, “Baka kai shekara hamsin ba tukuna, ka taba ganin Ibrahim?” ");
INSERT INTO hauulb_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesu ya ce masu, “Hakika, hakika, ina ce maku, kafin a haifi Ibrahim, NI NE.” ");
INSERT INTO hauulb_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Suka dauki duwatsu za su jefe shi, amma Yesu ya boye kansa, ya fita daga haikali. ");
INSERT INTO hauulb_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Da Yesu yana wucewa, sai ya ga wani mutum makaho tun daga haihuwa. ");
INSERT INTO hauulb_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Sai almajiransa suka tambaye shi, “Mallam, wa yayi zunubi, mutumin ne ko iyayensa, har aka haife shi makaho?” ");
INSERT INTO hauulb_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesu ya amsa, Ba mutumin ne ko iyayensa suka yi zunubi ba, amma domin aikin Allah ya bayyana a cikinsa. ");
INSERT INTO hauulb_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Dole mu yi aikin wanda ya aiko ni tunda rana. Dare na zuwa inda ba mai iya yin aiki. ");
INSERT INTO hauulb_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Yayinda ina duniya, ni ne hasken duniya.” ");
INSERT INTO hauulb_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Bayan da Yesu ya fadi wadannan abubuwan, ya tofa yawu a kasa, ya kwaba kasar da yawunsa, sai ya shafe idanun mutumin da kasar. ");
INSERT INTO hauulb_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ya ce masa, tafi, ka wanke a tafkin Siloam (ma'anarsa: aike).” Sai mutumin ya tafi, ya wanke, ya dawo yana gani. ");
INSERT INTO hauulb_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Sai makwabtansa da mutanen da da suka gan shi tun can yana roko suka ce, “ Ba wannan mutum ne wanda ya ke zaune yana roko ba?” ");
INSERT INTO hauulb_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Wadansu suka ce, “shi ne.” Wadansu suka ce, “A'a, amma yana kama da shi.” Amma shi ya ce, “Ni ne wannan mutum.” ");
INSERT INTO hauulb_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Suka ce masa, “ To yaya aka bude maka idanu?” ");
INSERT INTO hauulb_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Sai ya amsa, “Mutumin da ake ce da shi Yesu shi ya kwaba kasa ya shafa mani a idanuna ya ce mani, 'je ka kogin Siluwam ka wanke.' Sai naje na wanke, sannan na samu gani.” ");
INSERT INTO hauulb_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Suka ce masa, “Ina yake?” Ya amsa, “Ban sani ba.” ");
INSERT INTO hauulb_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Suka kawo mutumnin da yake makaho a da wurin farisawa. ");
INSERT INTO hauulb_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","A ranar asabar ne kwa Yesu ya kwaba kasa ya bude masa idanu. ");
INSERT INTO hauulb_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Har yanzu farisawan suka tambaye shi yadda ya sami ganin gari. Ya ce masu, “Ya sa mani kasa a idanuna, na wanke, kuma yanzu ina gani.” ");
INSERT INTO hauulb_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Wadansu daga cikin farisawa suka ce, “Wannan mutum ba daga Allah yake ba domin ba ya kiyaye ranar Asabar. “Wadansu suka ce, “Yaya mai zunubi zai yi irin wadannan alamu?” Sai rabuwa ta shiga tsakanin su. ");
INSERT INTO hauulb_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Sai suka tambayi makahon kuma, “Me kake cewa game da shi dashike ya bude maka idanu?” Makahon ya ce, “ shi annabi ne.” ");
INSERT INTO hauulb_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Har yanzu kam Yahudawan basu yarda da makantarsa ba da ganin gari da ya samu, sai da suka kirayo iyayen shi wanda ya sami ganin garin. ");
INSERT INTO hauulb_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Su ka tambayi iyayen, “Wannan shine yaronku da kuka ce an haife shi makaho? Yaya yanzu ya ke iya gani?” ");
INSERT INTO hauulb_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Sai iyayen suka amsa masu, “Mun san wannan yaronmu ne kuma a makaho aka haife shi. ");
INSERT INTO hauulb_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Yadda ya ke gani yanzu, bamu sani ba, kuma wanda ya bude masa idanu, bamu sani ba. Ku tambaye shi, ba yaro ba ne. Zai iya magana don kansa.” ");
INSERT INTO hauulb_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Iyayensa sun fadi wadannan abubuwan, domin suna ji tsoron Yahudawan. Gama Yahudiyawan sun rigaya sun yarda duk wanda yace Yesu Almasihu ne, za a fitar dashi daga majami'a. ");
INSERT INTO hauulb_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Domin wannan ne, iyayensa suka ce, “Ai shi ba yaro ba ne, ku tambaye shi.” ");
INSERT INTO hauulb_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Suka sake kiran mutumin dake makaho karo na biyu, suka ce masa, “Ka girmama Allah. Mu kam mun sani wannan mutum mai zunubi ne.” ");
INSERT INTO hauulb_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Sai wannan mutum ya amsa, “ Ban sani ba ko shi mai zunubi ne. Abu guda daya na sani: da Ni makaho ne, amma yanzu ina gani.” ");
INSERT INTO hauulb_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Sai su ka ce masa, “Me ya yi maka? Ta yaya ya bude idanunka?” ");
INSERT INTO hauulb_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ya amsa, “ Na rigaya na gaya maku, amma ba ku ji ba! Don me kuke so ku sake ji? Ko kuma kuna so ku zama almajiransa, haka ne? ");
INSERT INTO hauulb_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Sai suka kwabe shi suka ce, “kai ne almajirinsa, amma mu almajiran Musa ne. ");
INSERT INTO hauulb_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Mun sani Allah ya yi magana da Musa, amma wannan mutum, bamu san ko daga ina ne ya zo ba.” ");
INSERT INTO hauulb_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Mutumin ya amsa masu ya ce, “ Tirkashi, baku san inda ya fito ba, duk da haka shi ya bude mani idanu. ");
INSERT INTO hauulb_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Mun san da cewa Allah baya jin masu zunubi, amma idan wani mai ibada ne yana kuma yin nufinsa, to yana jin sa. ");
INSERT INTO hauulb_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Tunda duniya ta fara ba a taba jin cewa wani ya bude idanun wanda aka haifa makaho ba. ");
INSERT INTO hauulb_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","In mutumin nan ba daga Allah yake ba, ba zai iya yin komai ba.” ");
INSERT INTO hauulb_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Suka amsa suka ce masa, “an haife ka cikin zunubai, yanzu kana so ka yi mana koyarwa?” Sai suka fitar da shi. ");
INSERT INTO hauulb_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesu ya ji cewa sun fitar da shi daga majami'a. Da ya same shi sai ya ce masa, “Kana bada gaskiya ga Dan Allah?” ");
INSERT INTO hauulb_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Sai ya amsa masa yace, “Wanene shi, Ubangiji, da zan bada gaskiya gare shi?” ");
INSERT INTO hauulb_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yesu yace masa, “Ai ka gan shi, shine wanda yake magana da kai.” ");
INSERT INTO hauulb_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Mutumin ya ce, “Ubangiji, Na bada gaskiya.” Sai ya yi masa sujada. ");
INSERT INTO hauulb_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yesu ya ce, “ Don hukunci na zo wannan duniya domin wadanda ba su gani su gani, saboda kuma wadanda suke gani su zama makafi.” ");
INSERT INTO hauulb_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Wadansu Farisawa wadanda suke tare da shi suka ji wadannan abubuwan, suka tambaye shi, “Muma makafi ne?” ");
INSERT INTO hauulb_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesu ya ce masu, “ Inda ku makafi ne, da ba ku da zunubi, amma yanzu kun ce, 'Muna gani', don haka zunubinku ya tabbata. ");
INSERT INTO hauulb_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Hakika, Hakika, ina ce maku, wanda bai shiga ta kofa zuwa garken tumaki ba, amma ya haura ta wata hanya, wannan mutum barawo ne da dan fashi. ");
INSERT INTO hauulb_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Wanda ya shiga ta kofa shine makiyayin tumakin. ");
INSERT INTO hauulb_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Mai gadin kofar zai bude masa. Tumakin suna jin muryarsa, ya na kuma kiran tumakinsa da sunayensu, ya kuma kai su waje. ");
INSERT INTO hauulb_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Bayanda ya kawo su duka a waje, yana tafiya a gabansu, sai tumakin su bi shi, domin sun san muryarsa. ");
INSERT INTO hauulb_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ba za su bi bako ba amma sai dai su guje shi, domin basu san muryar baki ba.” ");
INSERT INTO hauulb_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu ya yi masu magana da wannan misali, amma basu gane wadannan abubuwa da yake gaya masu ba. ");
INSERT INTO hauulb_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Sai Yesu ya ce masu kuma, “Hakika, Hakika, Ina ce maku, Ni ne kofar tumaki. ");
INSERT INTO hauulb_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Dukan wadanda suka zo kamin ni barayi ne da yan fashi, amma tumakin ba su ji su ba. ");
INSERT INTO hauulb_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ni ne kofa, In kowa ya shiga ta wurina, zai sami ceto, zai shiga ya fita ya kuma sami wurin kiwo. ");
INSERT INTO hauulb_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Barawo ba ya zuwa sai don ya yi sata, ya kashe, ya kuma hallakar. Na zo ne domin su sami rai su kuma same shi a yalwace. ");
INSERT INTO hauulb_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ni ne makiyayi mai kyau. Makiyayi mai kyau yana bada ransa domin tumakinsa. ");
INSERT INTO hauulb_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Wanda yake dan sako kuma, ba makiyayi ba, wanda ba shine mai tumakin ba, in ya ga kyarkeci na zuwa sai ya saki tumakin ya gudu. Sai kyarkecin ya dauke su ya kuma warwatsa su. ");
INSERT INTO hauulb_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ya gudu domin shi mai aikin kudi ne kuma bai damu da tumakin ba. ");
INSERT INTO hauulb_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Nine makiyayi mai kyau, na kuma san nawa, nawa kuma sun san ni. ");
INSERT INTO hauulb_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Uban ya san ni, ni ma na san Uban, na kuma bada raina domin tumakin. ");
INSERT INTO hauulb_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ina da wadansu tumaki wadanda ba na wannan garken ba. Wadannan, kuma, dole in kawo su, su ma za su ji muryata saboda za su zama garke daya da makiyayi daya. ");
INSERT INTO hauulb_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Domin wannan ne Uban yake kauna ta: Na bada raina domin in same shi kuma. ");
INSERT INTO hauulb_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Babu wanda zai dauke shi daga wurina, amma ina bayar da shi da kaina. Ina da ikon bada shi, ina da iko in dauke shi kuma. Na karbi wannan umarnin daga wurin Ubana.” ");
INSERT INTO hauulb_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Tsattsaguwa ta sake tashi tsakanin Yahudawa domin wadannan kalmomin. ");
INSERT INTO hauulb_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Dayawa a cikinsu suka ce, yana da aljani, kuma mahaukaci ne. Don me ku ke sauraronsa?” ");
INSERT INTO hauulb_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Wadansu suka ce, wadannan ba kalmomin wanda yake da aljani ba ne. Ko mai aljani zai iya bude idanun makaho?” ");
INSERT INTO hauulb_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Sai lokacin idin Tsarkakewa a Urushalima ya zo. ");
INSERT INTO hauulb_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","A lokacin damuna ne, Yesu kuwa yana tafiya a shirayi cikin haikalin Sulaimanu. ");
INSERT INTO hauulb_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Sai Yahudawa suka zagaye shi suka ce masa, “Har yaushe ne za ka bar mu cikin shakka? In kai ne Almasihun, ka gaya mana dalla-dalla.” ");
INSERT INTO hauulb_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesu ya ce masu, “Na gaya maku, amma baku gaskata ba. Ayyukan da nake yi a cikin sunan Ubana, su ke yin shaida a kaina. ");
INSERT INTO hauulb_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Duk da haka baku gaskata ba domin ku ba tumakina ba ne. ");
INSERT INTO hauulb_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Tumakina suna jin murya ta; Na san su, suna kuma bi na. ");
INSERT INTO hauulb_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ina ba su rai na har abada; ba za su taba mutuwa ba, babu wanda zai kwace su daga hannu na. ");
INSERT INTO hauulb_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ubana, wanda ya bani su, ya fi kowa girma, kuma ba mai iya kwace su daga hannun Uban. ");
INSERT INTO hauulb_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ni da Uban daya ne.” ");
INSERT INTO hauulb_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Sai Yahudawa suka dauki duwatsu kuma domin su jajjefe shi. ");
INSERT INTO hauulb_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yesu ya amsa masu, “Na nuna maku kyawawan ayyuka masu yawa daga wurin Uban. Saboda wane daga cikin wadannan ayyukan kuke jefe ni?” ");
INSERT INTO hauulb_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Sai Yahudawa suka amsa masa, “ba don wani aiki mai kyau muke son mu jefe ka ba, amma don sabo, domin kai, mutum ne, amma kana mayar da kanka Allah.” ");
INSERT INTO hauulb_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yesu ya amsa masu, “Ba a rubuce yake a shari'arku ba, 'Na ce, “ku alloli ne”'?” ");
INSERT INTO hauulb_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","In ya kira su alloli, su wadanda maganar Allah ta zo gare su (kuma ba za a iya karya nassi ba), ");
INSERT INTO hauulb_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","kuna gaya wa wanda Uban ya kebe ya kuma aiko cikin duniya, 'Kana sabo', domin Na ce, 'Ni dan Allah ne'? ");
INSERT INTO hauulb_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","In ba na aikin Ubana, kada ku gaskata ni. ");
INSERT INTO hauulb_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Amma, idan ina yin su, ko ba ku gaskata da ni ba, ku gaskata da ayyukan saboda ku sani, ku kuma gane cewa Uban yana ciki na, ni kuma ina cikin Uban.” ");
INSERT INTO hauulb_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Suka sake kokarin kama shi, amma ya yi tafiyarsa, ya fita daga hannunsu. ");
INSERT INTO hauulb_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ya yi tafiyarsa kuma har gaba da kogin Urdun zuwa inda Yahaya ke yin baftisma ada, ya kuma zauna a wurin. ");
INSERT INTO hauulb_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Mutane masu yawa suka zo wurinsa, suka ce,”Hakika Yahaya bai yi wasu alamu ba, amma dukan abubuwan da Yahaya ya ce game da wannan mutum gaskiya ne.” ");
INSERT INTO hauulb_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Mutane dayawa suka bada gaskiya gare shi a wurin. ");
INSERT INTO hauulb_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","To wani mutum mai suna Li'azaru, yayi rashin lafiya. Shi mutumin Baitanya ne, wato kauyen su Maryamu da 'yar'uwarta Matta. ");
INSERT INTO hauulb_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Wato wannan Maryamu da ta shafe Ubangiji da mur ta kuma share masa kafafunsa da gashin kanta, wadda dan'uwanta Li'azaru ke rashin lafiya. ");
INSERT INTO hauulb_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","'Yan'uwannan mata suka aika sako wurin yesu, cewa, “Ubangiji, duba, shi wanda kake kauna yana rashin lafiya”. ");
INSERT INTO hauulb_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Da Yesu ya ji, sai ya ce “Wannan ciwo ba zai kai ga mutuwa ba, amma domin daukakar Allah ne, domin Dan Allah ya sami daukaka tawurin ta”. ");
INSERT INTO hauulb_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesu yana kaunar Matta, da 'yar'uwarta da Li'azaru. ");
INSERT INTO hauulb_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Da yaji cewa Li'azaru na rashin lafiya, sai ya tsaya kwana biyu a inda ya ke. ");
INSERT INTO hauulb_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Bayan haka, sai ya ce wa almajiransa, “Bari mu je Yahudiya kuma.” ");
INSERT INTO hauulb_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Sai almajiransa suka ce masa, “Mallam, harwayau Yahudaya na neman ka domin su jefe ka da duwatsu, kuma kana son komawa can?” ");
INSERT INTO hauulb_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yesu ya amsa, “Ba sa'a goma sha biyu ce ta haske a rana guda ba? Idan mutum ya yi tafiya da rana, ba za ya yi tuntube ba, domin yana gani ta wurin hasken wannan duniya. ");
INSERT INTO hauulb_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Amma idan mutum ya yi tafiya chikin dare, za ya yi tuntube domin haske ba ya tare da shi. ");
INSERT INTO hauulb_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ya fadi wadannan al'amura, kuma bayan wadannan abubuwa, sai ya ce masu, “Abokinmu Li'azaru ya yi barci, amma zan je don In tashe shi daga barci”. ");
INSERT INTO hauulb_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Sai almajirai suka ce masa, “Ubangiji, idan barci yake yi, ai za ya farka.” ");
INSERT INTO hauulb_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yesu kuwa ya yi maganar mutuwar Li'azaru ne, amma su suna tsammani yana magana akan barci ne na hutu. ");
INSERT INTO hauulb_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Sai Yesu ya yi masu bayani cewa, “Li'azaru ya mutu. ");
INSERT INTO hauulb_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ina farinchiki domin ku, da bani a wurin domin ku gaskata. Bari mu je wurinsa.” ");
INSERT INTO hauulb_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Toma wanda ake kira Dan tagwaye, ya ce wa sauran almajirai, “Bari mu tafi domin mu mutu tare da Yesu.” ");
INSERT INTO hauulb_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Da Yesu ya iso, sai ya tarar cewa Li'azaru ya rigaya ya yi kwana hudu a kabari. ");
INSERT INTO hauulb_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Baitanya kuma tana kusa da Urushalima, 'yar tafiya marar nisa ce a tsakanin su. ");
INSERT INTO hauulb_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Yahudawa dayawa sun zo wurin Maryamu da Matta domin su yi masu ta'aziyar mutuwar dan'uwansu. ");
INSERT INTO hauulb_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Da Matta ta ji cewa Yesu na zuwa, sai ta tafi domin ta same shi, amma Maryamu na zamne a cikin gida. ");
INSERT INTO hauulb_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Matta ta ce wa Yesu, “Ubangiji, da kana nan tare da mu, da dan'uwana baya mutu ba”. ");
INSERT INTO hauulb_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ko yanzu na san cewa duk abinda ka roka a wurin Allah, za ya ba ka. ");
INSERT INTO hauulb_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yesu ya ce mata, “Dan'uwanki za ya rayu kuma. ");
INSERT INTO hauulb_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Sai Matta ta ce masa, “Na san zaya rayu kuma a tashin mattatu na ranar karshe.” ");
INSERT INTO hauulb_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yesu ya ce mata, “Ni ne tashin matattu, ni ne kuma rai; wanda ya bada gaskiya gare ni, ko ya mutu, za ya rayu; ");
INSERT INTO hauulb_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Kuma duk wanda yake raye, ya kuma bada gaskiya gare ni, ba zai mutu ba dadai. Kin gaskata da wannan?” ");
INSERT INTO hauulb_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Sai ta ce masa, “I, Ubangiji, Na gaskata cewa kaine Almasihu, Dan Allah, wanda ke zuwa duniya. ");
INSERT INTO hauulb_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Sa'adda ta fadi haka, sai ta koma ta kira yar'uwarta Maryamu gefe guda. Ta ce, “mallam ya iso, kuma yana kiran ki.” ");
INSERT INTO hauulb_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Da ta ji haka, sai ta tashi da sauri ta tafi wurin sa. ");
INSERT INTO hauulb_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yesu bai rigaya ya shiga kauyen ba, yana nan inda Matta ta zo ta same shi. ");
INSERT INTO hauulb_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Da Yahudawan nan dake tare da Maryamu, wato wadannan da suka zo mata ta'aziya, suka ga ta fita daga chikin gida da sauri, sai suka bi ta, suna tsammanin cewa ta tafi ta yi kuka ne a kabari. ");
INSERT INTO hauulb_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Da Maryamu ta kai inda Yesu ya ke, sai ta fadi gaban sawayensa, ta ce, “Ubangiji, inda kana tare da mu, da dan'uwana bai mutu ba”. ");
INSERT INTO hauulb_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Da Yesu ya gan ta tana kuka, da wadannan Yahudawa da suka bi ta, sai ya yi juyayi a ruhu ya damu kuma; ");
INSERT INTO hauulb_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","sai ya ce, “A ina kuka kwantar da shi?” Sai suka ce masa, “Ubangiji, zo ka gani.” ");
INSERT INTO hauulb_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yesu ya yi kuka. ");
INSERT INTO hauulb_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Sai Yahudawa suka ce, “Dubi yadda yake kaunar Li'azaru!” ");
INSERT INTO hauulb_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Amma wadansun su suka ce, “Shi wannan mutum da ya iya ba makaho ganin gari, da bai iya hana wannan mutum mutuwa ba? ");
INSERT INTO hauulb_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yesu yana cikin juyayi kuma a cikin kansa, sai ya tafi kabarin. Kabarin a kogo ne an kuma rufe bakinsa da dutse. ");
INSERT INTO hauulb_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Sai Yesu ya ce, “A kawar da dutsen.” Matta yar'uwar Li'azaru wanda ya mutu, ta ce wa Yesu, “Ubangiji, Yanzu jikin ya ruba domin ya kai kwana hudu da mutuwa”. ");
INSERT INTO hauulb_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yesu ya ce mata, “Ba na ce maki idan kin gaskata za ki ga daukakar Allah ba?” ");
INSERT INTO hauulb_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Sai suka kawar da dutsen. Yesu ya daga idanunsa ya ce, “Uba, na gode maka domin kana ji na.” ");
INSERT INTO hauulb_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Na san kana ji na a kowane lokaci, amma domin wannan taro da ke tsaye kewaye da ni nike wannan magana, domin su bada gaskiya cewa kaine ka aiko ni.” ");
INSERT INTO hauulb_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Bayan ya yi wannan magana, sai ya daga murya ya ce, “Li'azaru, ka fito!” ");
INSERT INTO hauulb_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Sai mataccen ya fito; kafafunsa da hannayensa na daure da likkafani, fuskarsa kuma na lullube da tsumma. Yesu ya ce masu, “Ku kwance shi, ya tafi”. ");
INSERT INTO hauulb_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","To dayawa daga cikin yahudawan da suka zo wurin Maryamu suka kuma ga abinda Yesu ya yi, suka gaskata da shi; ");
INSERT INTO hauulb_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","amma wadansu suka koma wurin farisawa suka fada masu abubuwan da Yesu ya yi. ");
INSERT INTO hauulb_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Sai manyan firistoci da farisawa suka tara majalisa wuri guda, suka ce, “menene za mu yi?” Mutumin nan yana alamu masu yawa. ");
INSERT INTO hauulb_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Idan mun kyale shi haka, duka za su gaskata da shi; Romawa za su zo su kwace wurinmu da al'ummar mu. ");
INSERT INTO hauulb_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Duk da haka, wani daga cikin su wato, Kayafas wanda shine babban firist a wannan shekara, ya ce da su, “baku san komai ba”. ");
INSERT INTO hauulb_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ba ku lura cewa ya fi maku kyau mutum daya ya mutu domin mutane, a maimakon dukan al'umma ta hallaka.” ");
INSERT INTO hauulb_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ya fadi wannan ne ba don kansa ba, amma sabo da shine babban firist, ya yi anabci ne cewa ya kamata Yesu ya mutu domin al'ummar; ");
INSERT INTO hauulb_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","kuma ba don alummar kawai ba, amma domin a tattara 'ya'yan Allah da suke warwatse ko'ina wuri daya. ");
INSERT INTO hauulb_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Tun daga wannan rana suka fara neman hanyar da za su kashe Yesu. ");
INSERT INTO hauulb_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Tun daga nan Yesu ya dena tafiya a sarari chikin Yahudawa, amma sai ya koma wani yanki kusa da jeji a wani gari da ake kira Ifraimu. A can kuma ya zamna da almajiransa. ");
INSERT INTO hauulb_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Idin ketarewa na Yahudawa ya yi kusa, da yawa sun tafi Urushalima daga yankin kasar kamin ranar idi domin su tsarkake kan su. ");
INSERT INTO hauulb_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Suka shiga neman Yesu, suna magana da junan su yayin da suke tsaitsaye a haikali, cewa “me kuke tunani? Ba za ya zo idin bane?” ");
INSERT INTO hauulb_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Babban firist da farisawa sun rigaya sun ba da umurni cewa duk inda aka ga Yesu a zo a shaida domin su kama shi. ");
INSERT INTO hauulb_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Kwana shidda kafin idin ketarewa, Yesu ya zo Baitanya inda Li'azaru yake, wato wannan da Yesu ya tada daga matattu. ");
INSERT INTO hauulb_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Sai suka shirya masa abinci a wurin kuma Matta ce ke hidima, Li'azaru kuwa ya kasance cikin wadanda ke kan tebiri tare da Yesu. ");
INSERT INTO hauulb_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Sai Maryamu ta dauki wani turare da aka yi da man nard, ta shafe kafafun Yesu da shi, ta kuma share kafafun nasa da gashin kanta. Sai gida ya cika da kamshin turaren. ");
INSERT INTO hauulb_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Yahuza Iskariyoti, daya daga cikin almajiransa, wanda zai bashe shi, ya ce, “ ");
INSERT INTO hauulb_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Me yasa ba a sayar da wannan turare dinari dari uku a ba gajiyayyu ba?” ");
INSERT INTO hauulb_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ya fadi haka ba don ya damu da gajiyayyu ba, amma domin shi barawo ne: shi ne ma'aji, kuma yana sata daga jakkar kudi. ");
INSERT INTO hauulb_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yesu ya ce, “Ku kyale ta ta ajiye abinda ta tanada domin jana'iza ta. ");
INSERT INTO hauulb_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Gajiyayyu suna tare da ku a koyaushe, ni kuwa ba zan kasance da ku koyaushe ba. ");
INSERT INTO hauulb_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","To babban taron Yahudawa sun ji cewa Yesu yana wurin, sai suka zo, ba don Yesu kawai ba amma domin su ga Li'azaru, wanda Yesu ya tada daga matattu. ");
INSERT INTO hauulb_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Sai manyan firistoci suka kulla makirci akan yadda za su kashe Li'azaru shima; ");
INSERT INTO hauulb_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","domin saboda shi ne yahudawa dayawa suka je suka bada gaskiya ga Yesu. ");
INSERT INTO hauulb_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Kashegari, babban taro suka zo idin. Da suka ji cewa Yesu na zuwa Urushalima, ");
INSERT INTO hauulb_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Sai suka dauki ganyen dabino suka fita gari suka tare shi da kira mai karfi suna cewa, “Hosanna! Mai albarka ne wanda yake zuwa cikin sunan Ubangiji, Sarkin Isra'ila. ");
INSERT INTO hauulb_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesu ya sami wani Aholakin jaki, ya hau kansa; kamar yadda aka rubuta, ");
INSERT INTO hauulb_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Kada ki ji tsoro ke 'yar Sihiyona; duba, ga Sarkinki na zuwa, zaune a kan danJaki”. ");
INSERT INTO hauulb_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Almajiransa basu fahimci wannan al'amari ba da farko, amma bayan da aka daukaka Yesu, sai suka tuna cewa an rubuta wadannan abubuwa game da shi, kuma sun yi masa wadannan abubuwa. ");
INSERT INTO hauulb_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Sai taron da ke tare da Yesu a ranar da ya kira Li'azaru daga kabari ya kuma tashe shi daga matattu, suka bada shaida. ");
INSERT INTO hauulb_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Domin wannan ne kuma taron suka zo domin su sadu da shi saboda sun ji cewa ya yi wannan alama. ");
INSERT INTO hauulb_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Don haka, sai farisawa suka shiga magana a tsakanin su suna cewa “Duba, babu abinda zaku iya yi; kun ga, duniya ta gama bin sa. ");
INSERT INTO hauulb_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Akwai wadansu Helinawa cikin wadanda suka je sujada a idin. ");
INSERT INTO hauulb_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Wadannan suka tafi wurin filibus, mutumin Betsaida da ke Galili, suka ce masa, “Mallam, muna so mu ga Yesu. ");
INSERT INTO hauulb_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filibus ya tafi ya fadawa Andrawus; sai Andrawus ya tafi tare da Filibus, suka kuwa gaya wa Yesu. ");
INSERT INTO hauulb_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yesu ya amsa masu ya ce, “sa'a ta zo da za'a daukaka Dan mutum. ");
INSERT INTO hauulb_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Hakika, hakika, Ina ce maku, in ba kwayar alkama ta fadi kasa ba ta mutu, za ta kasance ita kadai; amma idan ta mutu, za ta bada 'ya'ya masu yawa. ");
INSERT INTO hauulb_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Duk wanda yake son ransa, zai rasa shi; amma wanda ba ya son ransa a duniyan nan za ya kiyaye shi domin rayuwa ta har abada. ");
INSERT INTO hauulb_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Idan wani na bauta mani, to bari ya biyo ni; kuma duk inda nike, a can bawana zai kasance kuma. Duk wanda ke bauta mani, Uban zai girmama shi. ");
INSERT INTO hauulb_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Yanzu raina na cikin damuwa, to me zan ce? 'Uba, ka cece ni daga wannan sa'a? Amma Saboda wannan dalili ne na zo wannan sa'a. ");
INSERT INTO hauulb_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Uba, ka daukaka sunanka”. Sai wata murya daga sama ta ce, “Na daukaka shi, zan kuma sake daukaka shi. ");
INSERT INTO hauulb_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Daganan sai taron dake tsaye kuma suka ji muryar, suka ce an yi tsawa. Wasu suka ce, “Mala'ika ya yi magana da shi”. ");
INSERT INTO hauulb_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Yesu ya amsa ya ce, “wannnan murya ta zo ba saboda ni ba, amma domin ku.” ");
INSERT INTO hauulb_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Yanzu za'a shar'anta duniya. Yanzu za'a kori mai mulkin duniyan nan. ");
INSERT INTO hauulb_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Sa, annan ni, idan an daga ni daga duniya, zan jawo dukan mutane zuwa gare ni”. ");
INSERT INTO hauulb_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ya fadi wannan ne domin ya nuna irin mutuwar da za ya yi. ");
INSERT INTO hauulb_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Taro suka amsa masa cewa, “Mun ji a cikin shari'a cewa Almasihu za ya kasance har abada. Yaya za ka ce, 'za'a daga dan mutum'? Wanene wannan dan mutum?” ");
INSERT INTO hauulb_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yesu ya ce masu, “Nan da lokaci kadan za ku kasance da haske, ku yi tafiya tun haske na tare da ku, kada duhu ya mamaye ku. Wanda ke tafiya cikin duhu, bai san inda za shi ba. ");
INSERT INTO hauulb_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ku gaskata ga haske tun yana tare da ku domin ku zama yayan haske”. Yesu ya fadi wadannan abubuwa sannan ya tafi ya boye masu. ");
INSERT INTO hauulb_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Kodashike Yesu ya yi alamu da dama a gabansu, duk da haka ba su gaskata shi ba. ");
INSERT INTO hauulb_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Saboda maganar annabi Ishaya ta cika, wadda ya ce, “ Ubangiji, wa ya gaskata rahoton mu? Ga wa kuma hannun Ubangiji ya bayyana? ");
INSERT INTO hauulb_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Saboda wannan dalili basu gaskata ba, gama Ishaya ya sake cewa, ");
INSERT INTO hauulb_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","ya makantar da su, ya kuma taurare zuciyarsu, saboda kada su gani da idanunsu, su kuma sami fahimta da zuciyarsu, su juyo wurina in warkar da su. ");
INSERT INTO hauulb_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ishaya ya fadi wadannan abubuwa ne domin ya hangi daukakar Yesu ya kuma yi magana game da shi. ");
INSERT INTO hauulb_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Amma duk da haka, dayawa cikin shugabanni suka gaskata Yesu. Amma saboda farisawa, basu shaida shi a sarari ba, domin kada a kore su daga majami'a. ");
INSERT INTO hauulb_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Suna son yabo daga mutane fiye da yabon dake zuwa daga Allah. ");
INSERT INTO hauulb_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yesu ya yi magana da babbar murya, ya ce, “Wanda ya gaskata ni, ba ni yake gaskatawa kadai ba, amma kuma yana gaskata wanda ya aiko ni, ");
INSERT INTO hauulb_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","kuma wanda ke gani na, yana ganin shi wanda ya aiko ni. ");
INSERT INTO hauulb_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Na zo ne a matsayin haske a duniya, saboda duk wanda ya gaskata da ni ba za ya yi tafiya cikin duhu ba. ");
INSERT INTO hauulb_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Duk wanda ya ji maganata baya gaskata ba, ba ni hukunta shi; gama ban zo in yi wa duniya hukunci ba, amma don in ceci duniya. ");
INSERT INTO hauulb_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Wanda ya ki ni, ya kuma ki ya karbi magana ta, akwai wanda za ya yi masa hukunci. Kalmar da na fada, ita ce za ta yi masa hukunci a rana ta karshe. ");
INSERT INTO hauulb_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Maganar da ni ke yi, ba ra'ayina ba ne. Amma Uba wanda ya aiko ni shi ke bani umarni game da abin da zan ce da abin da zan fadi. ");
INSERT INTO hauulb_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Na san umarninsa rai ne madawwami, don haka na ce - kamar yadda Uba ya fada, haka ni ma nake fadi.” ");
INSERT INTO hauulb_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Kamin bukin idin ketarewa, sa'adda Yesu ya san lokaci ya yi da zai tashi daga wannan duniya zuwa wurin Uba, da yake ya kaunaci nasa wadanda ke duniya- ya kaunace su har karshe. ");
INSERT INTO hauulb_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Iblis ya rigaya ya sa a zuciyar Yahuza Iskariyoti dan Saminu, ya bashe da Yesu. ");
INSERT INTO hauulb_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ya san cewa Uba ya bada kome a hannunsa, kuma ya zo daga wurin Allah, kuma zai koma wurin Allah. ");
INSERT INTO hauulb_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ya tashi daga cin abincin, ya tube tufafinsa, ya dauki tawul ya lullube kansa da shi. ");
INSERT INTO hauulb_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Sa'an nan ya zuba ruwa a bangaji, ya fara wanke kafafun almajiran, yana shafe su da tawul din da ya lullube jikinsa da shi. ");
INSERT INTO hauulb_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ya zo wurin Bitrus Saminu, sai Bitrus ya ce masa,”Ubangiji, za ka wanke mani kafa?” ");
INSERT INTO hauulb_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yesu ya amsa ya ce, “Abin da nake yi ba za ka fahimce shi yanzu ba, amma daga baya za ka fahimta.” ");
INSERT INTO hauulb_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Bitrus ya ce masa, “Ba za ka taba wanke mani kafa ba.” Yesu ya amsa masa ya ce, “In ban wanke maka ba, ba ka da rabo da ni”. ");
INSERT INTO hauulb_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Bitrus ya ce masa, “Ubangiji, ba kafafuna kadai za ka wanke ba, amma da hannayena da kaina.” ");
INSERT INTO hauulb_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesu ya ce masa, “Duk wanda ya yi wanka ba ya da bukata, sai dai a wanke kafafunsa, amma shi tsarkakakke ne baidaya; ku tsarkakakku ne, amma ba dukanku ba.” ");
INSERT INTO hauulb_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","(Don Yesu ya san wanda zai bashe shi, shiyasa ya ce, “Ba dukanku ne ke da tsarki ba.”) ");
INSERT INTO hauulb_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Bayan Yesu ya wanke masu kafafu, ya dauki tufafinsa ya zauna kuma, ya ce masu, “Kun san abin da na yi muku? ");
INSERT INTO hauulb_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","kuna kirana, 'Malam, da Ubangiji,' kun fadi daidai, don haka Nake. ");
INSERT INTO hauulb_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Idan ni Ubangiji da kuma mallam, na wanke maku kafafu, ya kamata kuma ku wanke wa junan ku kafafu. ");
INSERT INTO hauulb_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Gama na baku misali, saboda ku yi yadda na yi maku. ");
INSERT INTO hauulb_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Lalle hakika ina gaya muku, bawa ba ya fi mai gidansa girma ba; dan aike kuma ba ya fi wanda ya aiko shi girma ba. ");
INSERT INTO hauulb_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Idan kun san wadannan abubuwa, ku masu albarka ne idan kun aikata su. ");
INSERT INTO hauulb_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Ba ina magana akan dukanku ba; Na san wadanda na zaba. Amma domin Nassi ya cika: 'Shi Wanda ya ci gurasata, ya tayar mani'. ");
INSERT INTO hauulb_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ina fada maku wannan yanzu tun kafin haka ta faru domin sa'adda ta faru, ku gaskata Ni ne. ");
INSERT INTO hauulb_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Hakika, hakika, Ina gaya maku, wanda ya karbi wanda na aiko, Ni ya karba, wanda kuma ya karbe ni, ya karbi wanda ya aiko ni. ");
INSERT INTO hauulb_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Bayan Yesu ya fadi haka, ya damu a ruhu, ya yi shaida ya ce, “Lalle hakika, ina gaya muku cewa daya daga cikinku zai bashe ni.” ");
INSERT INTO hauulb_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Almajiran suka kalli juna, suna juyayin ko akan wa yake magana. ");
INSERT INTO hauulb_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Daya daga cikin almajiransa, wanda Yesu yake kauna, yana a teburi, jingine a kirjin Yesu. ");
INSERT INTO hauulb_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Siman Bitrus ya ce wa almajirin, “ka fada mana ko akan wa ya ke magana.” ");
INSERT INTO hauulb_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Sai ya sake jingina a kirjin Yesu, ya ce masa, “Ubangiji, wanene?” ");
INSERT INTO hauulb_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Sannan Yesu ya amsa, “Shine wanda zan tsoma gutsuren gurasa in ba shi.” Sannan bayan ya tsoma gurasar, sai ya ba Yahuza Dan Siman Iskariyoti. ");
INSERT INTO hauulb_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","To bayan gurasar, sai shaidan ya shige shi, sai Yesu ya ce masa, “ Abinda kake yi, ka yi shi da sauri.” ");
INSERT INTO hauulb_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Babu wani a teburin da ya san dalilin dayasa ya fada masa wannan. ");
INSERT INTO hauulb_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Wadansu sun yi tsamanin cewa, tun da Yahuza ne ke rike da jakkar kudi, Yesu ya ce masa, “Ka sayi abinda muke bukata don idin”, ko kuma ya bada wani abu domin gajiyayyu. ");
INSERT INTO hauulb_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Bayan Yahuza ya karbi gurasar, sai ya fita nan da nan. Da daddare ne kuwa. ");
INSERT INTO hauulb_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Bayan Yahuza ya tafi, Yesu ya ce, “Yanzu an daukaka Dan mutum, kuma an daukaka Allah a cikinsa. ");
INSERT INTO hauulb_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Allah zai daukaka shi a cikin kansa, kuma zai daukaka shi nan da nan. ");
INSERT INTO hauulb_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","'Ya'ya kanana, ina tare da ku na wani gajeren lokaci. Zaku neme ni, kuma kamar yadda na fadawa Yahudawa, 'in da zan tafi ba za ku iya zuwa ba.' Yanzu kuma na fada maku wannan. ");
INSERT INTO hauulb_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ina baku sabuwar doka, ku kaunaci juna; kamar yadda na kaunace ku, haka kuma ku kaunaci juna. ");
INSERT INTO hauulb_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ta haka kowa zai san ku almajiraina ne, idan kuna kaunar juna.” ");
INSERT INTO hauulb_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Siman Bitrus ya ce masa, “Ubangiji, ina za ka?” Yesu ya amsa ya ce, “Inda za ni, ba zaka iya bi na ba yanzu, amma zaka bini daga baya.” ");
INSERT INTO hauulb_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Bitrus ya ce masa, “Ubangiji, don me ba zan iya binka a yanzu ba? Zan bada raina domin ka.” ");
INSERT INTO hauulb_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yesu ya amsa ya ce, “ Za ka bada ranka domina? Lalle hakika, ina gaya maka, kafin zakara ya yi cara zaka yi musu na sau uku.” ");
INSERT INTO hauulb_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Kada zuciyarku ta bachi. Kun gaskata da Allah, sai kuma ku gaskata da ni. ");
INSERT INTO hauulb_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","A gidan Ubana akwai wurin zama dayawa. Da ba haka ba, da na fada maku, domin zan tafi in shirya maku wuri. ");
INSERT INTO hauulb_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","In kuwa na je na shirya maku wuri, zan dawo in karbe ku zuwa wurina domin inda nake kuma ku kasance. ");
INSERT INTO hauulb_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Kun san hanya inda zan tafi.” ");
INSERT INTO hauulb_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Toma ya ce wa Yesu, “Ubangiji, bamu san inda za ka tafi ba, yaya za mu san hanyar?” ");
INSERT INTO hauulb_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesu ya ce masa, “Ni ne hanya, ni ne gaskiya, ni ne rai; Ba mai zuwa wurin Uba sai ta wurina. ");
INSERT INTO hauulb_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Da kun san ni, da kun san Ubana kuma. Amma daga yanzu kun san shi, kuma kun gan shi.” ");
INSERT INTO hauulb_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filibus ya ce wa Yesu, “Ubangiji, ka nuna mana Uban, wannan za ya ishe mu.” ");
INSERT INTO hauulb_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yesu ya ce masa, “Ina tare da ku da dadewa, amma har yanzu baka san ni ba, Filibus? Duk wanda ya gan ni, ya ga Uban. Yaya za ka ce, 'Nuna mana Uban'? ");
INSERT INTO hauulb_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Baka gaskata cewa Ina cikin Uban, Uban kuma yana ciki na ba? Maganganun da nake fada maku, ba da ikona nake fadi ba, amma Uban ne da yake zaune a ciki na yake yin ayyukansa. ");
INSERT INTO hauulb_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ku gaskata ni cewa ina cikin Uban, Uban kuma na ciki na, ko kuwa ku bada gaskiya domin ayyukan kansu. ");
INSERT INTO hauulb_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“Lalle hakika, ina gaya maku, duk wanda ya gaskata ni zai yi ayyukan da nake yi, kuma zai yi ayyuka fiye da wadannan, domin zan tafi wurin Uba. ");
INSERT INTO hauulb_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Duk abinda kuka roka da sunana, zan yi shi domin a daukaka Uban cikin Dan. ");
INSERT INTO hauulb_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Idan kuka roke ni komai cikin sunana, zan yi shi. ");
INSERT INTO hauulb_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Idan kuna kaunata, za ku kiyaye dokokina. ");
INSERT INTO hauulb_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Sa, annan zan yi addu'a ga Uba, zai kuwa baku wani mai ta'aziya domin ya kasance tare daku har abada. ");
INSERT INTO hauulb_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ruhun gaskiya. Wanda duniya ba zata iya karba ba, domin bata gan shi ba, ko ta san shi. Amma ku kun san shi, domin yana tare da ku, zai kuma kasance a cikin ku. ");
INSERT INTO hauulb_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ba zan barku ku kadai ba; zan dawo wurin ku. ");
INSERT INTO hauulb_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Sauran dan gajeren lokaci, duniya kuma ba zata ka ra gani na ba, amma ku kuna gani na. Saboda ina raye, kuma zaku rayu. ");
INSERT INTO hauulb_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","A wannan rana zaku sani ina cikin Ubana, ku kuma kuna ciki na, ni ma ina cikin ku. ");
INSERT INTO hauulb_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Shi wanda yake da dokokina yake kuma bin su, shine ke kauna ta, kuma shi wanda ke kauna ta Ubana zai kaunace shi, Ni ma kuma zan kaunace shi in kuma bayyana kaina gare shi.” ");
INSERT INTO hauulb_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yahuza (ba Iskariyoti ba) ya ce ma Yesu, “Ubangiji, meyasa za ka bayyana kanka a gare mu, ba ga duniya ba?” ");
INSERT INTO hauulb_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yesu ya amsa ya ce masa,”Kowa yake kauna ta, zai kiyaye maganata. Ubana kuwa zai kaunace shi, za mu zo wurinsa mu zauna tare da shi. ");
INSERT INTO hauulb_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Shi wanda baya kauna ta, ba ya kiyaye maganganuna. Maganar da kuke ji ba daga gareni take ba, amma daga Uba wanda ya aiko ni take. ");
INSERT INTO hauulb_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Na fada maku wadannan abubuwa, sa'adda nake tare da ku. ");
INSERT INTO hauulb_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Saidai, mai ta'aziyar- Ruhu Mai Tsarki wanda Uba zai aiko cikin sunana, zai koya maku kome, kuma zai tunashe ku dukan abinda na fada maku. ");
INSERT INTO hauulb_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Na bar ku da salama; ina ba ku salamata. Ba kamar yadda duniya ke bayarwa Nake bayarwa ba. Kada zuciyarku ta baci, kuma kada ku tsorata. ");
INSERT INTO hauulb_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Kun ji dai na fada maku, 'zan tafi, kuma Zan dawo gare ku'. Idan kuna kaunata, za ku yi farinciki domin za ni wurin Uban, gama Uban ya fi ni girma. ");
INSERT INTO hauulb_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Yanzu na fada maku kafin ya faru, domin idan ya faru, ku gaskata. ");
INSERT INTO hauulb_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ba zan kara magana mai yawa da ku ba, domin mai mulkin duniyan nan yana zuwa. Bashi da iko a kai na, ");
INSERT INTO hauulb_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","amma domin duniya ta san cewa ina kaunar Uban, Ina yin daidai abinda Uban ya Umarce ni. Mu tashi mu tafi daga nan. ");
INSERT INTO hauulb_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Nine itacen inabi na hakika, Ubana kuwa shi ne manomin. ");
INSERT INTO hauulb_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Yakan cire duk wani rashe a cikina da ba ya bada 'ya'ya, mai bada 'ya'ya kuwa ya kan gyara shi domin ya kara bada 'ya'ya. ");
INSERT INTO hauulb_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Kun rigaya kun tsarkaka saboda maganar da na yi muku. ");
INSERT INTO hauulb_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ku zauna ciki na, Ni kuma cikin ku. Kamar yadda reshe ba ya iya bada 'ya'ya shi kadai sai ya zauna cikin itacen, haka kuma ba za ku iya ba, sai kun zauna ciki na. ");
INSERT INTO hauulb_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Ni ne itacen inabi, ku ne rassan. Wanda ya zauna ciki na, ni kuma cikin sa, yana bada 'ya'ya dayawa, gama in ba tare da ni ba, ba za ku iya yin kome ba. ");
INSERT INTO hauulb_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Wanda kuma bai zauna a ciki na ba, akan jefar da shi kamar reshe, ya bushe, kuma sukan tattara rassan su jefa a wuta, su kone. ");
INSERT INTO hauulb_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","In kun zauna a ciki na, maganata kuma ta zauna a cikin ku, sai ku roki duk abinda kuke so, za a kuwa yi maku. ");
INSERT INTO hauulb_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ta haka ake daukaka Ubana: cewa ku bada 'ya'ya dayawa, kuma cewa ku almajiraina ne. ");
INSERT INTO hauulb_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Kamar yadda Ubana ya kaunace ni, haka Ni ma na kaunace ku; Ku zauna cikin kaunata. ");
INSERT INTO hauulb_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Idan kun kiyaye dokokina, za ku zauna cikin kaunata kamar yadda Na kiyaye dokokin Ubana, na kuma zauna cikin kaunarsa. ");
INSERT INTO hauulb_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ina gaya maku wadannan al'amura domin farincikina ya kasance a cikin ku, kuma domin farincikinku ya zama cikakke. ");
INSERT INTO hauulb_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","“Wannan shine umarnina, cewa ku kaunaci juna kamar yadda na kaunace ku. ");
INSERT INTO hauulb_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Babu wanda ke da kaunar da tafi haka, wato ya bada ransa domin abokansa. ");
INSERT INTO hauulb_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ku abokaina ne idan kuna yin abubuwan da na umarce ku. ");
INSERT INTO hauulb_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Nan gaba ba zan kara ce da ku bayi ba, don bawa bai san abinda Ubangijinsa ke yi ba. Na kira ku abokaina, domin na sanar da ku duk abinda na ji daga wurin Ubana. ");
INSERT INTO hauulb_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ba ku kuka zabe ni ba, amma Ni ne na zabe ku, na aike ku don ku je ku bada 'ya'ya, 'ya'yanku kuma su tabbata. Wannan ya zama domin duk abinda kuka roki Uba a cikin sunana, zai baku. ");
INSERT INTO hauulb_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Na baku wannan umarni: domin ku kaunaci juna. ");
INSERT INTO hauulb_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","In duniya ta ki ku, ku sani cewa ta kini kafin ta ki ku. ");
INSERT INTO hauulb_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Da ku na duniya ne, da duniya ta kaunace ku kamar nata. Amma saboda ku ba na duniya bane, na kuma zabe ku daga duniya, don haka duniya take kin ku. ");
INSERT INTO hauulb_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ku tuna da maganar da na yi muku, 'Bawa ba ya fi Ubangijinsa girma ba.' Idan sun tsananta mani, ku ma za su tsananta maku; Idan sun kiyaye maganata, za su kuma kiyaye maganarku. ");
INSERT INTO hauulb_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Za su yi maku duk wadannan abubuwa saboda sunana, don basu san wanda ya aiko ni ba. ");
INSERT INTO hauulb_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Da ban zo na yi masu magana ba, da basu da zunubi, amma yanzu, basu da wata hujja don zunubinsu. ");
INSERT INTO hauulb_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Duk wanda ya ki ni ya ki Ubana. ");
INSERT INTO hauulb_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Da ban yi ayyukan da babu wanda ya taba yinsu a cikin su ba, da basu da zunubi, amma yanzu sun gani, sun kuma ki ni da Ubana duka. ");
INSERT INTO hauulb_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","An yi wannan kuwa domin a cika maganar da ke rubuce a cikin shari'arsu, ' Sun ki ni ba dalili.' ");
INSERT INTO hauulb_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Sa'adda Mai Ta'aziya- wanda zan aiko maku daga wurin Uban, wato, Ruhun gaskiya, wanda ke fita daga wurin Uban-ya zo, zai bada shaida a kai na. ");
INSERT INTO hauulb_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ku ma kuna bada shaida saboda kuna tare da ni tun daga farko. ");
INSERT INTO hauulb_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Na fada maku wannan ne domin kada kuyi tuntube. ");
INSERT INTO hauulb_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Zasu fitar da ku daga majami'u. Amma, sa'a tana zuwa, wadda idan wani ya kasheku, zai yi zaton aikin Allah yake yi. ");
INSERT INTO hauulb_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Za suyi haka ne kuwa domin ba su san Uban ko ni ba. ");
INSERT INTO hauulb_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Na fada maku wadannan abubuwa ne domin in lokacin da zasu faru yayi, ku tuna na fada maku.” Ban fada maku wadannan abubuwa ba tun da farko, domin ina tare da ku. ");
INSERT INTO hauulb_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Yanzu kuwa za ni wurin wanda ya aiko ni, duk da haka a cikinku, ba wanda ya tambaye ni, 'Ina za ka?' ");
INSERT INTO hauulb_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Amma saboda na fada maku wadannan abubuwa, bakin ciki ya cika zuciyarku. ");
INSERT INTO hauulb_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Amma ina gaya maku gaskiya: zai fi ye maku in na tafi. Domin in ban tafi ba, Mai Ta'aziyya ba zai zo gare ku ba, in kuwa na tafi, zan aiko shi gare ku. ");
INSERT INTO hauulb_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Idan kuwa ya zo, Mai Ta'aziyyar zai fadarkar da duniya a kan zunubi, da adalci, da kuma hukunci. ");
INSERT INTO hauulb_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Game da zunubi, domin basu gaskata da ni ba, ");
INSERT INTO hauulb_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Game da adalci, domin za ni wurin Uba, kuma ba za ku sake ganina ba, ");
INSERT INTO hauulb_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","game da hukunci kuma, domin an yanke wa mai mulki duniyan nan hukunci. ");
INSERT INTO hauulb_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Akwai abubuwa da yawa da zan gaya maku, amma ba za ku iya fahimta a yanzu ba. ");
INSERT INTO hauulb_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Saboda haka, sa'adda Ruhu na gaskiya ya zo, zai bishe ku a cikin dukan gaskiyar, domin ba zai yi magana don kansa ba, sai dai duk abin da ya ji, shi zai fada, zai kuma sanar da ku al'amuran da zasu faru. ");
INSERT INTO hauulb_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Zai daukaka ni, domin zai dauko abubuwa dake nawa ya sanar da ku. ");
INSERT INTO hauulb_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Duk abinda Uba yake da shi, nawa ne. Domin wannan ne nace zai dauko abubuwa da yake nawa ya sanar da ku. ");
INSERT INTO hauulb_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Bayan dan lokaci kadan, ba zaku kara ganina kuma ba. bayan dan lokaci kadan kuma, zaku gan ni.” ");
INSERT INTO hauulb_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Sai wadansu almajiransa sukace wa juna, “Me nene wannan da yake fadi mana, 'Bayan dan lokaci kadan ba zaku gan ni ba, bayan dan lokaci kadan kuma zaku gan ni?' da kuma, ' zan tafi wurin Uba'?” ");
INSERT INTO hauulb_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Saboda haka sukace, “Me nene wannan da yake fada, 'Bayan dan lokaci kadan'? Bamu san abinda yake fada mana ba.” ");
INSERT INTO hauulb_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesu kuwa ya ga suna so su tambaye shi, sai ya ce masu, “Wato kuna tambayar juna ne abinda nake nufi da cewa, “Bayan dan lokaci kadan ba zaku gan ni ba, bayan dan lokaci kadan kuma zaku gan ni'? ");
INSERT INTO hauulb_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Hakika, hakika, ina gaya maku, zaku yi kuka da makoki, amma duniya za ta yi farin ciki, zaku cika da bakin ciki, amma bakin cikinku zai koma farin ciki. ");
INSERT INTO hauulb_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Mace takan ji zafi lokacin da take nakuda don lokacin haihuwa ya zo. Amma da zarar ta haifi jinjirin nan, ba ta kara tunawa da zafin, domin ta na fariciki an haifi mutum a duniya. ");
INSERT INTO hauulb_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","To yanzu dai kuna bakin ciki, amma zan sake ganinku, kuma ba wanda zai iya kwace maku wannan farin ciki. ");
INSERT INTO hauulb_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","A rannan, ba zaku tambaye ni komai ba. Hakika hakika, ina gaya maku, komai kuka roki Uba a cikin sunana zai ba ku shi. ");
INSERT INTO hauulb_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Harwa yau, ba ku roki komai cikin sunana ba. Ku roka, zaku karba, domin farin cikin ku ya zama cikakke.” ");
INSERT INTO hauulb_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Na fada maku wadannan abubuwa cikin karin magana. Amma sa'a tana zuwa da ba zan kara fada maku komai ba cikin karin magana, amaimakon haka zan gaya maku komai a sarari game da Uba. ");
INSERT INTO hauulb_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","A ranar nan, zaku yi roko a cikin sunana kuma bance maku zan yi addu'a ga Uba a madadinku ba, ");
INSERT INTO hauulb_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","domin Uba da kansa yana kaunarku, domin kun kaunace ni, kun kuma gaskata daga wurin Uban na fito. ");
INSERT INTO hauulb_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Daga wurin Uban na fito, kuma na shigo duniya. Har wa yau, kuma zan bar duniya in koma wurin Uba.” ");
INSERT INTO hauulb_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Almajiransa sukace, duba, “Yanzu kake magana a sarari, ba cikin karin magana ba! ");
INSERT INTO hauulb_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Yanzu mun sani ka san komai, ba sai wani ya tambaye ka ba. Ta haka muka gaskata daga wurin Allah ka fito.” ");
INSERT INTO hauulb_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yesu ya amsa masu yace, “Ashe, yanzu kun gaskata? ");
INSERT INTO hauulb_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Duba, sa'a na zuwa, I, sa'ar ta yi, da za a warwatsa ku, kowa ya koma gidansa, kuma ku bar ni ni kadai. Duk da haka kuwa ba ni kadai nake ba, domin Ubana yana tare da ni. ");
INSERT INTO hauulb_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Na fada maku wannan ne domin a ciki na ku sami salama. A duniya kuna shan tsanani, amma ku karfafa: na yi nasara da duniya,” ");
INSERT INTO hauulb_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Da Yesu ya fadi wandannan abubuwa, sai ya tada idanunsa sama ya ce, ya Uba, sa'a ta zo; ka daukaka Danka, domin Dan shi ya daukaka ka, ");
INSERT INTO hauulb_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","kamar yadda ka ba shi iko akan dukkan 'yan adam, ya ba da rai madawwami ga duk wanda ka ba shi. ");
INSERT INTO hauulb_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Wannan ne rai madawwami: wato su san ka, Allah makadaici na gaskiya, da shi kuma wanda ka aiko, Yesu Almasihu. ");
INSERT INTO hauulb_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Na daukaka ka a duniya, na gama aikin da ka ba ni in yi. ");
INSERT INTO hauulb_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Yanzu, ya Uba, ka daukaka ni tare da kai da daukaka wadda ni ke da ita tare da kai tun kafin duniya ta kasanci. ");
INSERT INTO hauulb_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Na bayyana sunanka ga mutunen da ka ba ni acikin duniya. Na ka suke, ka ba ni su, sun kuwa kiyaye maganarka. ");
INSERT INTO hauulb_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Yanzu kuwa sun san duk iyakar abinda ka ba ni daga gare ka yake, ");
INSERT INTO hauulb_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","don kuwa maganganun da ka fada mani. Na fada masu, sun kuma karba, sun sani kuwa hakika na fito daga gareka ne, kuma sun gaskata kai ne ka aiko ni. ");
INSERT INTO hauulb_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ina yi masu addu'a. Ba domin duniya ni ke yin addu'a ba, amma domin wadanda ka bani gama na ka ne. ");
INSERT INTO hauulb_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Gama dukan abinda ke nawa na ka ne, naka kuwa nawa ne, an kuma daukaka ni a cikinsu. ");
INSERT INTO hauulb_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ba na cikin duniya kuma, amma wadannan mutane suna cikin duniya, ni kuwa ina zuwa wurin ka. Ya Uba mai Tsarki, ka adanasu cikin sunanka da ka ba ni domin su zama daya, kamar dai yadda muke daya. ");
INSERT INTO hauulb_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Lokacin da ina tare da su, na adanasu acikin sunanka da ka ba ni. Na kiyaye su, kuma ko daya kuwa daga cikinsu ba ya bace ba, sai dai dan hallakar nan, domin Nassi ya cika. ");
INSERT INTO hauulb_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Amma yanzu ina zuwa wurinka, Ina fadar wadannan abubuwa tun ina duniya, domin farin cikina ya zama cikakke a zukatansu. ");
INSERT INTO hauulb_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Na ba su maganarka, kuma duniya ta tsane su domin su ba na duniya ba ne, kamar yadda ni ba na duniya ba ne. ");
INSERT INTO hauulb_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ba ina roko ka dauke su daga cikin duniya ba, amma domin ka tsare su daga mugun nan. ");
INSERT INTO hauulb_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Su ba na duniya ba ne, kamar yadda ni ba na duniya ba ne. ");
INSERT INTO hauulb_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ka kebe su domin kanka cikin gaskiya. maganarka gaskiya ce. ");
INSERT INTO hauulb_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Kamar dai yadda ka aiko ni cikin duniya, haka kuma na aike su cikin duniya. ");
INSERT INTO hauulb_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Na kebe kaina gareka sabili da su, domin su ma kansu a kebe su gareka cikin gaskiya. ");
INSERT INTO hauulb_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Ina addu'a ba domin wadannan kadai ba, amma har da wadanda zasu gaskata da ni ta wurin maganarsu, ");
INSERT INTO hauulb_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Domin su zama daya dukansu, kamar yadda kai, ya Uba, ka ke ciki na, ni kuma na ke cikin ka. Ina roko suma su kasance a cikinmu, domin duniya ta gaskata cewa ka aiko ni ");
INSERT INTO hauulb_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Daukakar da ka bani, ita nake basu, domin su zama daya, kamar yadda mu ke daya; ");
INSERT INTO hauulb_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","ni a cikinsu, kai kuma a ciki na. Domin su kammalu cikin zama daya, domin duniya ta sani cewa ka aiko ni, kuma ka kaunace su, kamar yadda ka kaunace ni. ");
INSERT INTO hauulb_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Ya Uba, ina so wadanda ka ba ni, su ma su kasance tare da ni inda nake, domin su dubi daukakata da ka yi mani. Domin ka kaunace ni tun kafin halittar duniya. ");
INSERT INTO hauulb_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ya Uba mai adalci, duniya kam, ba ta sanka ba, amma ni na sanka; kuma wadannan sun sani kai ne ka aiko ni. ");
INSERT INTO hauulb_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Na sanar masu da sunanka, zan kuma sanar da shi domin kaunar da ka yi mani ta kasance a cikinsu, ni kuma in kasance a cikinsu, ");
INSERT INTO hauulb_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Bayan Yesu ya fadi wadannan maganganu, ya fita shi da almajiransa zuwa daya barayin kwarin Kidiron, inda wani lambu ya ke, ya kuma shiga da almajiransa. ");
INSERT INTO hauulb_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yahuza ma wanda zai bashe shi ya san wurin, domin Yesu ya saba zuwa wurin da almajiransa. ");
INSERT INTO hauulb_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Yahuza kuwa, bayan ya dauko kungiyar soja daga manyan firistoci, da Farisawa, da 'yan majalisa, suka zo wurin, rike da fitilu, da cociloli, da makamai. ");
INSERT INTO hauulb_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Sai Yesu, da ya san duk abinda ke faruwa da shi, yayiwo gaba, yace masu, ''Wa kuke nema'' ");
INSERT INTO hauulb_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Suka amsa masa su ka ce, ''Yesu Banazare'' Yesu yace masu, Ni ne'' Yahuza kuma, wanda ya bashe shi, yana tsaye tare da sojojin. ");
INSERT INTO hauulb_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Sa'adda ya ce masu, ''Ni ne'', suka koma da baya, suka fadi a kasa. ");
INSERT INTO hauulb_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ya sake tambayarsu kuma, ''Wa ku ke nema?'' su ka ce, ''Yesu Banazare.'' ");
INSERT INTO hauulb_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yesu ya amsa, ''Ai, na gaya maku cewa, Ni ne. In kuwa ni ku ke nema, ku bar wadannan su tafi abinsu;'' ");
INSERT INTO hauulb_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Wannan kuwa domin maganar daya fada ta cika, ''Daga cikin wadanda ka ba ni, ko daya bai bace mani ba.'' ");
INSERT INTO hauulb_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Saminu Bitrus kuwa, da ya ke yana da takobi, ya zaro ya kai wa bawan babban firist sara, ya dauke masa kunnensa na dama, sunan bawan Malkus ne. ");
INSERT INTO hauulb_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yesu ya ce wa Bitrus, ''Mai da takobin ka kubenta. Ba zan sha kokon da Uba ya ba ni ba.'? ");
INSERT INTO hauulb_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Sai sojojin da hafsan, da 'yan majalisar Yahudawa, suka kama Yesu, suka daure shi. ");
INSERT INTO hauulb_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Da fari suka tafi da shi wurin Hanana, don shi surukin Kayafa ne, wanda ya ke shi ne babban firist a shekaran nan. ");
INSERT INTO hauulb_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kayafa kuma shi ne ya ba Yahudawa shawara, cewa ya fiye masu mutum daya ya mutu domin mutane. ");
INSERT INTO hauulb_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Saminu bitrus ya bi bayan Yesu, haka kuma wani almajirin yayi. Almajirin nan kuwa sananne ne ga babban firist, sai ya shiga har farfajiyar babban firist din tara da Yesu; ");
INSERT INTO hauulb_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Amma bitrus kuwa ya tsaya a bakin kofa daga waje. Sai daya almajirin da ya ke sananne ga babban firist ya fita, yayi magana da macen da ta ke tsaron kofar, sa'an nan ya shigo da Bitrus. ");
INSERT INTO hauulb_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Sai yarinyar mai tsaron kofar ta ce wa Bitrus, ''kai ma ba kana cikin almajiran mutumin nan ba?'' Yace ''bani ba.'' ");
INSERT INTO hauulb_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","To, barorin da dogaran Haikali suna tsaye a wurin, sun kuwa hura wutar gawayi, suna jin dumi, gama ana sanyi. Bitrus ma yana tsaye tare da su yana jin dumin. ");
INSERT INTO hauulb_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","babban firist ya tambayi Yesu game da almajiransa da koyarwarsa kuma. ");
INSERT INTO hauulb_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yesu ya amsa masa, Ai, na yi wa duniya magana a bayyane. Na kuma sha koyarwa a majami'u da Haikali in da Yahudawa duka sukan taru. Ban fadi komai a boye ba. ");
INSERT INTO hauulb_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Don me kake tambaya ta? Ka tambayi wadanda suka saurare ni a kan abinda na fada, ai, sun san abinda na fada. ");
INSERT INTO hauulb_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Sa'adda Yesu ya fadi wannan, wani daga cikin 'yan majalisar da ke tsaye a wurin ya nushi Yesu, yace, ''Kana amsa wa babban firist haka.'' ");
INSERT INTO hauulb_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yesu ya amsa masa yace, ''Idan na fadi mugun abu to, ka bada shaida kan hakan. In kuwa dai dai na fada, to, dan me za ka nushe ni?'' ");
INSERT INTO hauulb_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Sai Hanana ya aika daYesu a daure wurin Kayafa, babban firist. ");
INSERT INTO hauulb_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","To Saminu Bitrus yana tsaye yana jin dumin. Mutanen kuwa suka ce masa, ''Anya kai ma ba cikin almajiransa ka ke ba?'' Sai yayi musu yace, ''A'a, ba na ciki.'' ");
INSERT INTO hauulb_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Sai wani daga cikin bayin babban firist, wato dan'uwan wanda Bitrus ya fillewa kunne, yace, ''Ashe, ban gan ka tare da shi a lambun ba? ");
INSERT INTO hauulb_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Bitrus ya sake yin musu, nan da nan kuwa zakara yayi cara. ");
INSERT INTO hauulb_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Daga wurin Kayafa kuma suka kai Yesu fadar Gwamna. Da asuba ne kuwa, su kansu ba su shiga fadar Gwamnan ba, wai don kada su kazantu su kasa cin jibin Ketarewa. ");
INSERT INTO hauulb_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Sai bilatus fa ya fita zuwa wurinsu, yace, 'Wane zargi ku ke kawowa akan mutumin nan?' ");
INSERT INTO hauulb_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","''Sai suka amsa suka ce, ''idan da mutumin nan bai yi mugun abu ba, me zai sa mu yi kararsa a wurin ka'' ");
INSERT INTO hauulb_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","bilatus yace masu, ''Ku tafi da shi da kan ku mana, ku hukunta shi bisa ga shari'arku!'' Sai Yahudawa su kace masa, ''Ai, ba mu da ikon zartar da hukuncin kisa akan kowa.'' ");
INSERT INTO hauulb_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Sun fadi Wannan ne don a cika maganar da Yesu yayi, wadda ta kwatanta irin mutuwar da zai yi. ");
INSERT INTO hauulb_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Sai bilatus ya sake shiga cikin fadar Gwamnan, ya kira Yesu ya ce masa, ''kai sarkin Yahudawa ne?'' ");
INSERT INTO hauulb_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesu ya amsa, '' wannan fadarka ce, ko kuwa wadansu ne suka ce da ni haka a wurinka?'' ");
INSERT INTO hauulb_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Bilatus ya amsa “Ni ba Bayahude bane, ko kuwa?'' Ai, jama'arka ne da manyan firistoci suka bashe ka gareni. ''Me ka yi?'' ");
INSERT INTO hauulb_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yesu ya amsa, ''Mulkina ba na duniya nan ba ne. Da mulkina na duniyan nan ne da barorina za su yi yaki kada a bashe ni ga Yahudawa. To, mulkina ba daga nan ya ke ba.'' ");
INSERT INTO hauulb_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Sai Bilatus yace masa, ''Wato ashe, sarki ne kai?'' Yesu ya amsa, ''Yadda ka fada, ni sarki ne. Domin wannan dalili aka haife ni, domin kuma wannan dalili na zo cikin duniya, don in bada shaida game da gaskiya. Kowane mai kaunar gaskiya kuma yakan saurari muryata.'' ");
INSERT INTO hauulb_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Bilatus yace masa, ''Menene gaskiya?'' Bayan da ya fadi haka, ya sake fitowa wurin Yahudawa, yace masu, ''Ni kam, ban sami mutumin nan da wani laifi ba. ");
INSERT INTO hauulb_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Amma dai kuna da wata al'ada, in Idin Ketarewa ya yi, na kan sakar maku mutum daya. To, kuna so in sakar maku sarkin Yahudawa?'' ");
INSERT INTO hauulb_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Sai suka sake daukar kururuwa suna cewa, ''A; a, ba wannan mutum ba, sai dai Barabbas.'' Barabbas din nan kuwa dan fashi ne. ");
INSERT INTO hauulb_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Sai Bilatus yayi wa Yesu bulala. ");
INSERT INTO hauulb_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Sojojin kuwa suka saka rawanin kaya. Suka kuwa dora wa Yesu a kai suka sa mashi kaya irin na saurata. ");
INSERT INTO hauulb_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Suka zo wurin sa sukace, “Ranka ya dade, sarkin Yahudawa! sai suka nushe shi. ");
INSERT INTO hauulb_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Sai Bilatus ya sake fita waje yace masu, “Dubi, zan kawo maku mutumin domin ku sani ban same shi da wani laifi ba”, ");
INSERT INTO hauulb_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Yesu kuwa ya fito, da rawanin kaya da kaya irin na sarauta. Sai Bilatus yace “Ga mutumin nan”. ");
INSERT INTO hauulb_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Da manyan firistocin tare da yan majalisar suka ga Yesu, sai suka yi ta ihu suna cewa “A gicciye shi, A gicciye shi” Sai Bilatus yace masu, “ku dauke shi ku gicciye shi, ni kam ban same shi da wani laifi ba”. ");
INSERT INTO hauulb_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Sai Yahudawan sukace mashi, “Ai muna da shari'a, kuma bisa ga shari'ar ya cancanci mutuwa domin ya mai da kansa Dan Allah”. ");
INSERT INTO hauulb_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Da Bilatus ya ji wannan zance sai ya tsorata kwarai. ");
INSERT INTO hauulb_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Sai ya sake shiga fadar Gwamna, yace wa Yesu, “Daga ina ka fito?” amma Yesu bai amsa mashi ba. ");
INSERT INTO hauulb_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Sai Bilatus yace masa “Ba zaka yi mani magana ba? Baka san ina da iko in sake ka ba, kuma in gicciye ka? ");
INSERT INTO hauulb_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yesu ya amsa masa, “Ai ba ka da iko a kaina sai dai in an baka daga sama, Saboda haka, wanda ya mika ni a gare ka shine mafi zunubi”. ");
INSERT INTO hauulb_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Da jin haka, sai Bilatus yayi kokari a sake shi, amma sai Yahudawa suka tada murya sukace, “In ka saki mutumin nan, kai ba abokin Kaisar bane, duk wanda ya maida kansa sarki, ya sabawa Kaisar”. ");
INSERT INTO hauulb_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Da Bilatus ya ji irin maganganunsu sai ya fito da Yesu waje ya kuma zauna akan kujeransa a inda ake kira “Dakalin shari'a,” a Yahudanci kuma, “Gabbata.” ");
INSERT INTO hauulb_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","To a ran nan ana shirye shiryen idin ketarewa, da misalin sa'a ta shidda kenan, wato tsakar rana, Bilatus yace wa Yahudawan “Ga sarkin ku!” ");
INSERT INTO hauulb_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Su kuwa suka yi ihu, a tafi da shi, a tafi da shi, a gicciye shi, Bilatus yace masu “In gicciye sarkin ku? Sai manyan firistocin sukace “Ba mu da wani sarki sai Kaisar”. ");
INSERT INTO hauulb_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Sai Bilatus ya mika Yesu domin su gicciye shi. ");
INSERT INTO hauulb_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Sai suka tafi da Yesu, ya fito yana dauke da gicciyen zuwa wurin da ake kira “Wurin kwalluwa” da Yahudanci kuma “Golgota”. ");
INSERT INTO hauulb_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Suka gicciye Yesu a wurin, tare da wasu mutum biyu, daya a kowane gefe, Yesu kuwa na tsikiya. ");
INSERT INTO hauulb_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Bilatus kuwa ya rubuta wata alama a kan gicciyen, “YESU BANAZARE, SARKIN YAHUDAWA”. ");
INSERT INTO hauulb_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Yahudawa da yawa kuwa suka karanta wannan alama domin wurin da aka gicciye Yesu yana kusa da Birnin. Alamar kuwa an rubuta ta da Yahudanci, da Romanci, da Helenanci. ");
INSERT INTO hauulb_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Sai manyan firistocin yahudawa sukace wa Bilatus, kada ka rubuta sarkin Yahudawa, amma kace, 'wannan yace “Ni ne sarkin Yahudawa”'. ");
INSERT INTO hauulb_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Bilatus kuwa ya amsa, “Abinda na rubuta na rubuta kenan.” ");
INSERT INTO hauulb_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Bayan da sojojin suka gicciye Yesu, sai suka yayyaga rigarsa kashi hudu, kowane soja da nasa, kashin, sai kuma alkyabbar. Alkyabbar kuwa bata da dinki an saka tane daga sama har kasa. ");
INSERT INTO hauulb_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Sai sukace wa junansu, “Kada mu yaga alkyabbar, amma kuzo mu jefa kuri'a a kan ta mu gani ko wanene zai dauke ta, anyi haka ne domin a cika nassi cewa “Sun raba rigata a tsakaninsu, sun kuwa jefa kuri'a domin alkyabbata. ");
INSERT INTO hauulb_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Sojojin suka yi wadannan abubuwa. Uwar Yesu, da 'yar'uwarta, da Maryamu matar Kilofas, da kuma Maryamu Magadaliya. Wadannan mataye suna tsaye kusa da gicciyen Yesu. ");
INSERT INTO hauulb_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Da Yesu ya ga mahaifiyarsa da almajirin nan da yake kauna tsaye kusa da juna, yace, “Mace, dubi, dan ki!” ");
INSERT INTO hauulb_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Sai yace wa almajirin, “Dubi, mahaifiyarka!” Daga wannan sa'a almajirin ya dauke ta zuwa gidansa. ");
INSERT INTO hauulb_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Bayan wannan Yesu, saboda ya san yanzu komai ya kammala, domin a cika nassin, sai yace “Ina jin kishi. ");
INSERT INTO hauulb_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","A gefensu kuma akwai gora cike da ruwan inabi mai tsami, sai suka tsoma soso a cikin ruwan inabin mai tsami suka daura a wata sanda sai suka mika masa a baki. ");
INSERT INTO hauulb_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Da Yesu ya tsotsi ruwan tsamin, sai yace “An gama” Sai ya sunkuyar da kansa ya kuwa saki ruhunsa. ");
INSERT INTO hauulb_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Sai Yahudawan, domin ranar shirye shirye ne, domin kada a bar jikunansu akan gicciye har ranar asabacin (domin asabacin rana ce mai muhimmanci), suka roki Bilatus ya kakkarye kafafunsu kuma ya saukar da su. ");
INSERT INTO hauulb_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Sai sojojin suka zo suka karya kafafun mutum na farko da kuma mutum na biyun wadanda aka gicciye tare da Yesu. ");
INSERT INTO hauulb_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Da suka iso kan Yesu sai suka tarar ya riga ya mutu, sai basu kuwa karya kafafunsa ba. ");
INSERT INTO hauulb_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Duk da haka daya daga cikin sojojin ya soki kuibin shi da mashi, nan da nan sai jini da ruwa suka fito. ");
INSERT INTO hauulb_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Wanda ya ga wannan, shi ya zama shaida, shaidarsa kuwa gaskiya ce. Ya sani cewa abinda ya fada gaskiya ne saboda ku ma ku gaskata. ");
INSERT INTO hauulb_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Wadannan sun faru ne domin a cika nassi, “Babu ko daya daga cikin kasusuwansa da za'a karya”. ");
INSERT INTO hauulb_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Kuma wani nassin yace, “Zasu dube shi wanda suka soka.” ");
INSERT INTO hauulb_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Bayan wadannan abubuwa, Yusufu mutumin Arimatiya, wanda yake almajirin Yesu ne (amma a boye saboda tsoron Yahudawa) ya roki Bilatus izini domin ya dauke jikin Yesu. Bilatus kuwa ya bashi izini, sai Yusufu yazo ya dauki jikin. ");
INSERT INTO hauulb_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodimu ma ya zo, wanda da farko ya zo wurin Yesu da daddare, ya kawo hadin man kamshi na mur da al'ul wajen nauyin awo dari. ");
INSERT INTO hauulb_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Sai suka dauki jikin Yesu suka sa shi a likkafanin lillin tare da kayan kamshin nan, domin jana'iza bisa ga al'adar Yahudawa. ");
INSERT INTO hauulb_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","To a wurin da aka gicciye shi kuwa akwai wani lambu, a cikin lambun kuma akwai sabon kabari wanda ba'a taba sa kowa ba. ");
INSERT INTO hauulb_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Da yake ranar shirye shirye ce ta Yahudawa, kabarin kuwa na kusa, sai suka sa Yesu a ciki. ");
INSERT INTO hauulb_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","To da sassafe ranar farko ta mako, da sauran duhu, Maryamu Magadaliya ta zo kabarin, ta tarar an kawar da dutsen daga kabarin. ");
INSERT INTO hauulb_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Sai ta ruga da gudu zuwa wurin Saminu Bitrus tare da almajirin nan da Yesu ke kauna, tace masu, “Sun dauke Ubangiji daga kabarin, bamu kuwa san inda aka sa shi ba.” ");
INSERT INTO hauulb_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Sai Bitrus tare da almajirin nan suka fita, kuma suka tafi kabarin, ");
INSERT INTO hauulb_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","dukansu suka ruga da gudu tare, amma daya almajirin ya riga Bitrus isowa kabarin, ");
INSERT INTO hauulb_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Sai ya sunkuya ya leka ciki, ya ga likkafanin lillin a wurin, amma fa bai shiga ciki ba. ");
INSERT INTO hauulb_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Sai Saminu Bitrus ya iso daga bayansa sai ya shiga kabarin, ya tarar da likkafanin lillin a ajiye. ");
INSERT INTO hauulb_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","sai fallen kuma da yake kansa. Ba'a ajiye tare da likkafanin ba amma aka linkeshi aka ajiye shi daban. ");
INSERT INTO hauulb_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Sai almajirin nan da ya riga isa kabarin shi ma ya shiga ya gani, sai ya ba da gaskiya. ");
INSERT INTO hauulb_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Har ya zuwa wannan lokacin basu san nassin daya ce zai tashi daga matattu ba. ");
INSERT INTO hauulb_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Sai almajiran suka sake komawa gida kuma. ");
INSERT INTO hauulb_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Amma Maryamu tana tsaye a bakin kabarin tana kuka. Yayin da take kuka, sai ta sunkuya ta leka cikin kabarin. ");
INSERT INTO hauulb_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Sai ta ga mala'iku guda biyu cikin fararen kaya zaune, daya ta wurin kai daya kuma ta wurin kafafu inda aka kwantar da Yesu. ");
INSERT INTO hauulb_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Sukace mata, “Uwargida don me kike kuka? Sai tace masu, “Domin sun dauke Ubangijina, ban kuwa san inda suka ajiye shi ba. ");
INSERT INTO hauulb_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Bayan ta fadi haka, ta juya sai ta ga Yesu tsaye a wurin. Amma bata san cewa Yesu bane, ");
INSERT INTO hauulb_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yesu yace mata, “Uwargida, me yasa kike kuka? Wa kuma kike nema? Domin tana zaton shine mai kula da lambun, sai tace masa, “Maigida in kaine ka dauke shi, gaya mani inda ka sa shi, ni kuwa in dauke shi.” ");
INSERT INTO hauulb_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesu yace mata, “Maryamu”. Sai ta juya, tace masa da Armaniyanci “Rabboni!” wato mallam. ");
INSERT INTO hauulb_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesu yace mata, kada ki taba ni, domin har yanzu ban hau wurin Uba ba tukuna, amma kije wurin 'yan'uwana kice masu, zan je wurin Ubana da Ubanku, Allahna da kuma Allahnku”. ");
INSERT INTO hauulb_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Maryamu Magadaliya ta je tace wa almajiran, “Na ga Ubangiji” Ta kuma ce ya fada mata wadannan abubuwa. ");
INSERT INTO hauulb_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Da yamma a wannan rana, a rana ta farko ta mako, almajiran suna kulle a daki saboda tsoron Yahudawa, Yesu yazo ya tsaya a tsakaninsu, yace “Salama Agareku”. ");
INSERT INTO hauulb_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Bayan ya fadi haka, sai ya nuna masu hannuwansa da kuibinsa. Da almajiran suka ga Ubangiji, sai suka yi farin ciki. ");
INSERT INTO hauulb_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yesu ya sake ce masu, “salama agareku. “Kamar yadda Uba ya aiko ni, haka Ni ma na aike ku”. ");
INSERT INTO hauulb_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Da Yesu ya fadi haka, sai ya hura masu lumfashinsa, yace masu, “Ku karbi Ruhu Mai Tsarki. ");
INSERT INTO hauulb_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Duk wanda kuka gafarta wa zunubai, an gafarta masa; kowa kuka rike zunubansa, an rikesu.” ");
INSERT INTO hauulb_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Toma, daya daga cikin sha biyun, wanda ake kira Dan Tagwai, baya tare dasu lokacin da Yesu ya bayyana. ");
INSERT INTO hauulb_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Sauran almajiran sukace masa “Mun ga Ubangiji”. Sai yace masu, “In ban ga gurbin kusoshi a hannuwansa ba, in sa yatsana a gurbin kusoshin ba, in kuma sa hannuna cikin kuibinsa ba, ba zan bada gaskiya ba. ");
INSERT INTO hauulb_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Bayan kwana takwas har wa yau almajiran na cikin gida, Toma ma na tare dasu, kofofin suna kulle, sai ga Yesu a tsakaninsu yace, “Salama agareku”. ");
INSERT INTO hauulb_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Sa'an nan yace wa Toma, “Iso nan da yatsanka, dubi hannuwana. Miko hannunka kuma kasa a kuibina, kada ka zama marar bada gaskiya, sai dai, mai bada gaskiya”. ");
INSERT INTO hauulb_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Toma ya amsa yace “Ya Ubangijina da Allahna!” ");
INSERT INTO hauulb_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yesu yace masa, “Wato saboda ka gan ni, ka bada gaskiya? Albarka ta tabbata ga wadanda basu gani ba, amma kuwa sun bada gaskiya. ");
INSERT INTO hauulb_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesu yayi wadansu alamu da yawa dabam dabam a gaban almajiransa, wadanda ba'a rubuta a littafin nan ba. ");
INSERT INTO hauulb_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Amma an rubuta wadannan ne, domin ku bada gaskiya Yesu shine Almasihu, Dan Allah, ta wurin gaskatawa kuma ku sami rai cikin sunansa. ");
INSERT INTO hauulb_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Bayan wadannan abubuwa, Yesu ya sake bayyana kansa ga almajiran a bakin tekun Tibariya. Ga yadda ya bayyana kansa: ");
INSERT INTO hauulb_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Saminu Bitrus na tare da Toma wanda ake kira Dan Tagwai, da Natana'ilu daga Kana ta kasar Galili, da 'ya'yan nan na Zabadi, da kuma wadansu almajiran Yesu biyu. ");
INSERT INTO hauulb_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Saminu Bitrus yace masu, “Zani su.” sukace masa “Mu ma za mu je tare da kai.” Sai suka fita suka shiga jirgi, amma a daren nan basu kama komai ba. ");
INSERT INTO hauulb_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","To, gari na wayewa, sai ga Yesu tsaye a bakin gaci, amma almajiran basu gane cewa Yesu bane. ");
INSERT INTO hauulb_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Sai Yesu yace masu, “Samari, kuna da wani abinda za a ci?” Suka amsa masa sukace “A'a”. ");
INSERT INTO hauulb_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Yace masu, “Ku jefa taru dama da jirgin zaku samu wasu.” Suka jefa tarunsu har suka kasa jawo shi don yawan kifin. ");
INSERT INTO hauulb_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Sai almajirin nan da Yesu yake kauna yace wa Bitrus, “Ubangiji ne fa!” Da Saminu Bitrus yaji, Ashe, Ubangiji ne, yayi damara da taguwarsa, (don a tube yake), ya fada a tekun. ");
INSERT INTO hauulb_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Sauran almajiran kuwa suka zo a cikin karamin jirgi, (domin basu da nisa da kasa, kamar kamu dari biyu zuwa sama), janye da tarun cike da kifi. ");
INSERT INTO hauulb_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Da isowarsu gaci, sai suka ga garwashin wuta a wurin da kifi akai, da kuma gurasa. ");
INSERT INTO hauulb_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yesu ya ce masu “Ku kawo wandansu daga cikin kifin da kuka kama yanzu”. ");
INSERT INTO hauulb_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Sai Saminu Bitrus ya hau, ya jawo tarun gaci, cike da manyan kifaye dari da hamsin da uku (153). Amma duk da yawansu, tarun bai tsage ba. ");
INSERT INTO hauulb_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesu yace masu, “Ku zo ku karya kumallo”. Daga cikin almajiran kuwa babu wanda yayi karfin halin tambayarsa “Ko shi wanene?” Domin sunsani Ubangiji ne. ");
INSERT INTO hauulb_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yesu zo ya dauki gurasar ya ba su, haka kuma kifin. ");
INSERT INTO hauulb_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Wannan shine karo na uku da Yesu ya bayyana ga almajiransa bayan tashinsa daga matattu. ");
INSERT INTO hauulb_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Da suka karya kumallon, Yesu yace wa Saminu Bitrus, “Bitrus dan Yahaya, kana kaunata fiye da wadannan?” Bitrus yace masa “I ya Ubangiji, ka sani ina kaunarka” Yesu yace masa “Ka ciyar da 'ya'yan tumakina”. ");
INSERT INTO hauulb_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ya sake fada masa karo na biyu, “Saminu Dan Yahaya, kana kaunata?” Bitrus Yace masa “I ya Ubangiji, ka sani ina kaunarka”. Yesu yace masa, “Ka lura da Tumakina”. ");
INSERT INTO hauulb_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ya sake fada masa, karo na uku, “Bitrus Dan Yahaya, kana kaunata? Sai Bitrus bai ji dadi ba domin Yesu ya fada masa karo na uku, “Kana kaunata” Yace masa, “Ubangiji ka san komai duka, ka sani ina kaunarka.” Yesu yace masa “Ka ciyar da tumaki na. ");
INSERT INTO hauulb_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Hakika, hakika, Ina gaya maka, lokacin da kake kuruciyarka, kakan yi wa kanka damara, ka tafi inda ka ga dama. amma in ka tsufa, zaka mike hannuwanka wani yayi maka damara, ya kai ka inda baka nufa ba.” ");
INSERT INTO hauulb_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","To Yesu ya fadi haka ne domin ya nuna irin mutuwar da Bitrus zai yi ga daukakar Allah. Bayan ya fadi haka, sai yace wa Bitrus, ka biyo ni. ");
INSERT INTO hauulb_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Bitrus ya juya sai ya ga almajirin da Yesu yake kauna yana biye dasu; wanda ya jingina a kirgin Yesu lokacin cin jibin nan da yace “Ya Ubangiji, wanene zai bashe ka?” ");
INSERT INTO hauulb_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Da Bitrus ya gan shi, yace wa Yesu “Ya Ubangiji, Me mutumin nan zai yi?” ");
INSERT INTO hauulb_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesu yace masa, “Idan ina so ya zauna har in dawo ina ruwanka? Ka biyo ni.” ");
INSERT INTO hauulb_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Wannan zance ya yadu cikin 'yan'uwa cewa, wannan almajirin ba zai mutu ba. Alhali Yesu bai cewa Bitrus, wannan almajirin ba zai mutu ba, Amma “Idan ina so ya zauna har in dawo ina ruwanka?” ");
INSERT INTO hauulb_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Wannan shine almajirin da yake shaida wadannan abubuwa, wanda ya rubuta su, kuma mun tabbata shaidarsa gaskiya ne. ");
INSERT INTO hauulb_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Akwai kuma sauran abubuwa da yawa wanda Yesu yayi. Idan da an rubuta kowannensu daya bayan daya, ina gaya maku, ko duniya bazata iya daukar litattafan da za a rubuta ba. ");
INSERT INTO hauulb_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Littafin da na rubuta da farko, Tiyofilos, ya fadi abubuwan da Yesu ya fara yi ya kuma koyar, ");
INSERT INTO hauulb_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","har zuwa ranar da aka karbe shi zuwa sama. Wannan kuwa bayan da ya ba da umarni ga zababbun manzanninsa ta wurin Ruhu Mai Tsarki. ");
INSERT INTO hauulb_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Bayan ya sha wahala, ya bayyana kan sa da rai a garesu, da alamu da dama masu gamsarwa. Kwana arba'in ya baiyana kansa a garesu yana yi masu magana game da mulkin Allah. ");
INSERT INTO hauulb_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Yayin da yana zaune tare da su ya basu umarni cewa kada su bar Urushalima, amma su jira alkawarin Uban, wanda ya ce, ''Kun ji daga gare ni, ");
INSERT INTO hauulb_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","cewa Yahaya babu shakka ya yi baftisma da ruwa, amma ku za a yi maku baftisma da Ruhu Mai Tsarki nan da kwanaki kadan.'' ");
INSERT INTO hauulb_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Sa'adda suna tare suka tambaye shi, ''Ubangiji, a wannan lokaci ne za ka maido da mulki ga Isra'ila?” ");
INSERT INTO hauulb_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ya ce masu, ''Ba naku bane ku san lokaci ko sa'a wanda Uba ya shirya ta wurin ikonsa. ");
INSERT INTO hauulb_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Amma za ku karbi iko, idan Ruhu Mai Tsarki ya zo bisanku, sa'annan za ku zama shaidu na cikin Urushalima da kuma cikin dukan Yahudiya da Samariya, har ya zuwa karshen duniya.” ");
INSERT INTO hauulb_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Lokacin da Ubangiji Yesu ya fadi wadannan abubuwa, yayin da suna kallon sama, sai aka dauke shi zuwa sama, kuma girgije ya boye shi daga idanunsu. ");
INSERT INTO hauulb_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Da suka dinga kallon sama yayin da ya tafi, nan da nan, mazaje biyu suka tsaya a gabansu cikin fararen tufafi. ");
INSERT INTO hauulb_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Suka ce, ''Ku mazajen Galili me yasa ku ke tsaye a nan kuna kallon sama? Wannan Yesu wanda ya hau zuwa sama zai dawo kamar yadda kuka gan shi yana tafiya zuwa sama.'' ");
INSERT INTO hauulb_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Da suka dawo Urushalima daga dutsen Zaitun, wanda ke kusa da Urushalima, tafiyar Asabaci daya ne. ");
INSERT INTO hauulb_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Da suka iso, sai suka haye zuwa cikin bene inda suke da zama. Sune su Bitrus, Yahaya, Yakubu, Andarawus, Filibus, Toma, Bartalamawus, Matiyu, Yakubu dan Alfa, Siman mai tsattsauran ra'ayi, kuma da Yahuza dan Yakubu. ");
INSERT INTO hauulb_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Dukansu kuwa suka hada kai gaba daya, yayin da suka ci gaba da naciya cikin addu'a. Tare da su kuma akwai mata, Maryamu mahaifiyar Yesu, da kuma 'yan'uwansa. ");
INSERT INTO hauulb_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","A cikin wadannan kwanaki Bitrus ya tashi tsaye a tsakiyar 'yan'uwa, kimanin mutane dari da ashirin, ya ce, ");
INSERT INTO hauulb_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","'' 'Yan'uwa, akwai bukatar Nassi ya cika, wanda Ruhu Mai Tsarki ya fada a baya ta bakin Dauda game da Yahuza, wanda ya jagoranci wadanda suka kama Yesu ");
INSERT INTO hauulb_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Domin yana daya daga cikinmu kuma ya karbi rabonsa na ladan wannan hidima,” ");
INSERT INTO hauulb_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Wannan mutum fa ya sai wa kansa fili da cinikin da ya yi na muguntarsa, kuma a nan ya fado da ka, cikinsa ya fashe, hanjinsa suka zubo waje. ");
INSERT INTO hauulb_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Duka mazaunan Urushalima suka ji wannan, saboda haka suka kira wannan fili da harshensu “Akeldama'' wato, “Filin Jini.”) ");
INSERT INTO hauulb_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Domin an rubuta a littafin Zabura, 'Bari filinsa ya zama kufai, kada a bar kowa ya zauna wurin,'kuma, 'Bari wani ya dauki matsayinsa na shugabanci.' ");
INSERT INTO hauulb_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Saboda haka ya zama dole, daya daga cikin wadanda suke tare da mu tun lokacin da Ubangiji Yesu yana shiga da fita, a tsakaninmu, ");
INSERT INTO hauulb_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","farawa daga baftismar yahaya har zuwa ranar da aka dauke shi daga wurinmu zuwa sama, ya zama daya daga cikin mu wurin shaidar tashinsa.” ");
INSERT INTO hauulb_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Suka gabatar da mutum biyu, Yusufu wanda ake kira Barsabbas, wanda kuma aka yiwa suna Justus, da kuma Matayas. ");
INSERT INTO hauulb_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Su ka yi addu'a suka ce, ''Ubangiji, kai ka san zuciyar dukan mutane, ka bayyana mana wanda ka zaba cikin su biyun nan ");
INSERT INTO hauulb_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Domin ya dauki gurbin da kuma manzancin daga inda Yahuza ya kauce zuwa nashi waje'' ");
INSERT INTO hauulb_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","suka jefa kuri'a a kansu; zabe ya fada kan Matayas kuma suka lissafta shi tare da manzanni sha dayan. ");
INSERT INTO hauulb_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Da ranar Fentikos ta zo, dukansu suna tare wuri daya. ");
INSERT INTO hauulb_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Nan da nan sai ga wata kara daga sama kamar ta babbar iska, kuma ta sauko ta cika duka gidan inda suke zaune. ");
INSERT INTO hauulb_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Sai ga wasu harsuna kamar na wuta sun bayyana a garesu aka rarraba su, kuma suka zauna bisa kowannensu. ");
INSERT INTO hauulb_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Dukansu suka cika da Ruhu Mai Tsarki suka fara magana da wadansu harsuna, yadda Ruhu ya ba su iko su yi magana. ");
INSERT INTO hauulb_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","A lokacin akwai Yahudawa dake zaune a Urushalima, mutanen Allah, daga kowace kasa karkashin sama. ");
INSERT INTO hauulb_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Da suka ji wannan kara jama'a duk suka taru suka rude saboda kowannensu ya ji suna magana da harshensa. ");
INSERT INTO hauulb_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Suka yi mamaki matuka; suka ce, ''Lallai, wadannan duka ba Galiliyawa ba ne? ");
INSERT INTO hauulb_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Yaya mu ke jinsu duka, kowannensu na magana a cikin harshen da aka haife mu? ");
INSERT INTO hauulb_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Fisiyawa da Mediyawa da Elimawa, da Yahudawa da Kafadokiya, cikin Fontus da Asiya, ");
INSERT INTO hauulb_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","cikin Firgia da Bamfiliya, cikin Masar da yankunan Libiya ta wajen Sur, da baki daga Roma, ");
INSERT INTO hauulb_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Yahudawa da tubabbun cikin Yahudanci, Kiretawa da Larabawa, duk munji su suna fadi a harshenmu game da manyan ayyukan Allah.'' ");
INSERT INTO hauulb_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Dukansu suka yi mamaki suka rikice; suka ce da junansu, ''Menene ma'anar wannan?'' ");
INSERT INTO hauulb_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Amma wasu suka yi ba'a suka ce, ''Sun bugu ne da sabon ruwan inabi.'' ");
INSERT INTO hauulb_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Amma Bitrus ya tashi tare da sha dayan, ya daga murya ya ce da su, ''Mutanen Yahuda da dukanku dake zaune a Urushalima, bari ku san wannan; ku saurari maganata. ");
INSERT INTO hauulb_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Domin wadannan mutanen ba buguwa suka yi ba yadda kuke zato, domin yanzu karfe tara ne na safe kawai. ");
INSERT INTO hauulb_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Amma wannan shine abinda aka fada ta wurin annabi Yowel. ");
INSERT INTO hauulb_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Allah ya ce, 'Haka zai kasance a kwanakin karshe, zan zubo Ruhuna a kan dukan mutane, 'ya'yanku maza da mata za su yi anabci, kuma samarinku za su ga wahayoyi, kuma tsofaffinku za su yi mafarkai. ");
INSERT INTO hauulb_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Haka kuma a bisa bayi na maza da mata, a kwanakin nan zan zubo da Ruhuna, kuma za su yi anabci. ");
INSERT INTO hauulb_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Zan nuna al'ajibai a sararin sama da kuma alamu a bisa duniya, jini da wuta, da girgije. ");
INSERT INTO hauulb_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Rana zata juya ta koma duhu kuma wata ya koma jini, kafin Babbar ranan nan ta Ubangiji ta zo. ");
INSERT INTO hauulb_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Zai kuma zama dukan wanda ya kira ga sunan Ubangiji zai sami ceto. ");
INSERT INTO hauulb_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Mutanen Isra'ila, ku saurari wadannan magana. Yesu Banazare, mutumin da Allah ya tabbatar da shi gareku ta wurin manyan ayyuka da ban mamaki da alamu da Allah ya yi ta wurinsa a tsakiyarku, kamar yadda ku da kanku kuka sani. ");
INSERT INTO hauulb_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Saboda tabbataccen shiri da riga sani na Allah, aka bayar dashi, ku kuma, ta hannun mutane 'yan tawaye, kuka gicciye shi kuma kuka kashe shi. ");
INSERT INTO hauulb_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Wanda Allah ya tayar, bayan ya cire zafin mutuwa daga gareshi, saboda ba zai yiwu ba ta rike shi. ");
INSERT INTO hauulb_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Gama, game da shi, 'Ina ganin Ubangiji a gabana ko yaushe, domin yana gefen hannun damana saboda kada in firgita. ");
INSERT INTO hauulb_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Saboda haka zuciyata na farin ciki harshena yana yin murna. Kuma, jikina zai zauna gabagadi. ");
INSERT INTO hauulb_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Gama ba za ka watsar da raina a lahira ba, ba kuwa za ka bar Mai Tsarkinka ya ga ruba ba. ");
INSERT INTO hauulb_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ka bayyana mani hanyar rai; da fuskarka zaka cika ni da farin ciki. ");
INSERT INTO hauulb_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","'Yan'uwa, zan yi magana da ku gabagadi game da baba Dauda: ya mutu kuma aka bizne shi, kuma kabarinsa na nan tare da mu har yau. ");
INSERT INTO hauulb_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Domin haka, don shi annabi ne kuma ya san Allah ya yi masa alkawari da rantsuwa cewa daga cikin zuriyarsa zai sanya wani bisa kursiyinsa. ");
INSERT INTO hauulb_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ya hango wannan al'amari kuma ya yi magana game da tashin Almasihu, 'Ba ayi watsi da shi ba a lahira, kuma jikinsa bai ga rubewa ba.' ");
INSERT INTO hauulb_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Wannan Yesun - Allah ya tashe shi, wanda dukanmu shaidu ne. ");
INSERT INTO hauulb_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Saboda haka yadda aka tashe shi zuwa hannun dama na Allah kuma ya karbi alkawarin Ruhu Mai Tsarki daga wurin Uba, shine ya zubo mana wannan da kuke gani kuma kuke ji. ");
INSERT INTO hauulb_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Dauda bai hau zuwa sama ba, amma ya ce, ''Ubangiji ya ce wa Ubangijina, “Zauna hannun dama na, ");
INSERT INTO hauulb_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","har sai na maida makiyanka abin takawar sawunka.''' ");
INSERT INTO hauulb_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Saboda haka, bari gidan Isra'ila su sani tabbas wannan Yesun wanda kuka gicciye, Allah ya maishe shi Ubangiji da kuma Almasihu. ");
INSERT INTO hauulb_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Da suka ji haka sai suka soku a zukatansu, suka cewa Bitrus da sauran manzanni, '''Yan'uwa me za mu yi?'' ");
INSERT INTO hauulb_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Sai Bitrus ya ce masu, ''Ku tuba ayi wa kowannenku baftisma, cikin sunan Yesu Almasihu domin gafarar zunubanku, kuma za ku karbi baiwar Ruhu Mai Tsarki. ");
INSERT INTO hauulb_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Domin alkawarin a gareku ne da 'ya'yanku da duk wadanda ke nesa, dukan iyakar mutanen da Ubangiji Allahnmu zai kira.'' ");
INSERT INTO hauulb_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Da maganganu da yawa ya ba da shaida kuma ya karfafa su; ya ce, ''Ku ceci kan ku daga wannan muguwar tsara.'' ");
INSERT INTO hauulb_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Sai suka karbi maganar sa kuma aka yi ma su baftisma, a wannan rana kuma aka sami karin rayuka wajen dubu uku. ");
INSERT INTO hauulb_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Su ka cigaba cikin koyarwar manzanni da zumunta, cikin kakkaryawar gurasa da kuma cikin addu'o'i. ");
INSERT INTO hauulb_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Tsoro ya sauko bisa kowane rai, kuma aka yi abubuwan ban mamaki da alamu da yawa ta wurin manzannin. ");
INSERT INTO hauulb_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Duka wadanda suka ba da gaskiya suna tare kuma komai nasu na kowanensu ne, ");
INSERT INTO hauulb_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","kuma suka saida kadarorinsu da mallakarsu kuma suka rarrabawa kowa, bisa ga irin bukatar da kowannensu yake da ita. ");
INSERT INTO hauulb_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","A kowace rana suka cigaba tare da nufi daya a cikin haikali, suna kakkarya gurasa a gidaje, kuma suna raba abinci tsakaninsu cikin farin ciki da tawali'u a zuciya; ");
INSERT INTO hauulb_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Suna yabon Allah kuma suna da tagomashi a gaban dukan mutane. Ubangiji kuma kullum yana kara masu wadanda suke samun ceto. ");
INSERT INTO hauulb_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Sa'adda Bitrus da Yahaya suna hanya zuwa haikali a lokacin addu'ar karfe uku. ");
INSERT INTO hauulb_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Wani mutum, gurgu ne tun daga haihuwa, ana daukar sa kulluyomi zuwa kofar haikali da ake kira Kyakkyawa, domin bara gun mutanen da ke shiga haikalin. ");
INSERT INTO hauulb_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Da ya ga Bitrus da Yahaya suna shiga haikalin, sai ya roke su sadaka. ");
INSERT INTO hauulb_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Bitrus da Yahaya kuwa suka zuba masa ido, Bitrus ya ce, ''Ka dube mu.'' ");
INSERT INTO hauulb_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Gurgun nan kuwa ya dube su, yana tsammanin zai sami wani abu a wurin su. ");
INSERT INTO hauulb_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Amma Bitrus ya ce, “Azurfa da Zinariya ba ni da su, amma abin da nake da shi, zan baka. A cikin sunan Yesu Almasihu Banazare, Yi tafiya'' ");
INSERT INTO hauulb_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Bitrus ya kama hannun damarsa, ya daga shi; nan da nan kafafunsa da kashin idon sawayensa suka samu karfi. ");
INSERT INTO hauulb_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Da gurgun ya yunkura, ya mike tsaye sai ya fara takawa; ya shiga haikali tare da Bitrus da Yahaya, yana takawa, yana tsalle, yana kuma girmama Allah. ");
INSERT INTO hauulb_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Dukan mutane suka gan shi yana tafiya yana kuma yabon Allah. ");
INSERT INTO hauulb_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Sun lura cewa, shine mutumin da ke zama yana bara a Kyakyawar kofar haikali; sai suka cika da mamaki domin abin da ya faru. ");
INSERT INTO hauulb_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Yayin da yake rike da Bitrus da Yahaya, dukan jama'a suka matso wurinsu, a gefen dakalin Sulaimanu, suna ta mamaki kwarai. ");
INSERT INTO hauulb_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Da Bitrus ya ga haka ya amsa wa jama'ar, “Ya ku mutanen Isra'ila, don me ku ke mamaki?” Don me ku ka zura mana ido, kamar mu ne muka sa shi ya yi tafiya da ikon kanmu ko adalcin mu? ");
INSERT INTO hauulb_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Allah na Ibrahim, da Ishaku, da Yakubu, Allah na iyayenmu ya girmama bawansa Yesu. Shi kuka ki kun kuma bashe shi a gaban Bilatus da ya so ya sake shi. ");
INSERT INTO hauulb_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Kuka ki Mai Tsarkin nan, Mai Adalcin, maimakon haka kuka ce a sakkar maku mai kisan kai. ");
INSERT INTO hauulb_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Kun kashe mai ba da rai, wanda Allah ya tayar daga matattu, mu kuwa shaidu ne ga wannan al'amari. ");
INSERT INTO hauulb_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Yanzu, ta bangaskiya ga sunansa - wannan mutum da kuke gani kuma kun san shi - ta wurin wannan sunan ne ya sami karfi. Bangaskiya cikin Yesu ta ba shi cikakkiyar lafiya, a gabanku duka. ");
INSERT INTO hauulb_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Ya ku 'yan'uwa, na san kun yi haka ne cikin rashin sani, yadda shugabaninku suka yi. ");
INSERT INTO hauulb_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Amma duk abubuwan da Allah ya fada ta bakin dukan anabawansa, cewa Almasihunsa zai sha wahala, yanzu ya cika. ");
INSERT INTO hauulb_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Saboda haka, Ku tuba, ku juyo, domin a shafe zunubanku, domin lokacin sabuntuwa daga wurin Ubangiji ya zo; ");
INSERT INTO hauulb_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","domin a aiko maku da Almasihu wanda aka kaddara wato, Yesu. ");
INSERT INTO hauulb_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Shine wanda dole sama ta karbe shi har zuwa lokacin komo da dukan abubuwa, game da abubuwan da Allah ya fada tun da ta bakin annabawansa tsarkaka. ");
INSERT INTO hauulb_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Musa hakika ya ce, 'Ubangiji Allah zai tayar maku da wani annabi kamar ni daga cikin, 'yan'uwanku. Za ku saurari dukan abin da zai fada maku. ");
INSERT INTO hauulb_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Zai kasance kowanne mutum da bai saurari annabin nan ba za a kau da shi gabadaya daga cikin mutanensa.' ");
INSERT INTO hauulb_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","I, dukan annabawa tun daga Sama'ila da wadanda suka zo bayansa, sun yi magana sun ambaci wadannan kwanaki. ");
INSERT INTO hauulb_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Kune 'ya'yan annabawa da na alkawari wanda Allah ya yi da kakanninku, yadda ya ce wa Ibrahim, 'Daga zuriyarka dukan al'uman duniya za su sami albarka.' ");
INSERT INTO hauulb_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Bayan da Allah ya ta da bawansa, a gareku ne ya fara aiko shi, domin ya albarkace ku tawurin juyadda kowannenku daga muguntarsa.” ");
INSERT INTO hauulb_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Yayin da Bitrus da Yahaya suna kan magana da mutanen, sai firistoci da shugaban masu tsaron Haikali da kuma Sadukiyawa suka afko masu. ");
INSERT INTO hauulb_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Sun damu sosai domin Bitrus da Yahaya suna koyar da mutane game da Yesu kuma suna shelar tashinsa daga matattu. ");
INSERT INTO hauulb_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Suka kama su suka jefa kurkuku sai washegari, domin yamma ta riga ta yi. ");
INSERT INTO hauulb_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Amma mutane da yawa da suka ji sakon suka ba da gaskiya; kimanin mazaje dubu biyar ne kuwa suka ba da gaskiya. ");
INSERT INTO hauulb_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Washegari, da shugabaninsu, da dattawansu, da Marubuta suka taru a Urushalima. ");
INSERT INTO hauulb_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Anas babban firist, yana nan, da Kayafa, da Yahaya da Iskandari, da dukan dangin babban firist ");
INSERT INTO hauulb_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Da suka kawo Bitrus da Yahaya a tsakiyarsu sai suka tambaye su, “Da wanne iko, ko cikin wanne suna k ka yi haka?” ");
INSERT INTO hauulb_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Sai Bitrus, cike da Ruhu Mai Tsarki, ya ce, “Ku shugabanni da dattawan jama'a, ");
INSERT INTO hauulb_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","idan mu yau ana tuhumarmu saboda aikin kirki da aka yi ga wannan mara lafiya - ta yaya wannan mutum ya sami lafiya? ");
INSERT INTO hauulb_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Bari ku da dukan mutanen Isra'ila, ku san wannan, cikin sunan Yesu Almasihu Banazare, wanda kuka giciye, wanda Allah ya tayar daga matattu ta dalilinsa ne wannan mutumin yake tsaye a gaban ku lafiyayye. ");
INSERT INTO hauulb_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yesu Almasihu ne dutsen da ku magina kuka ki, amma an mai da shi kan gini. ");
INSERT INTO hauulb_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Babu ceto daga kowanne mutum, domin babu wani suna da aka bayar karkashin sama, a cikin mutane wanda ta wurinsa za a iya samu ceto.'' ");
INSERT INTO hauulb_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Sa'adda, suka ga karfin halin Bitrus da Yahaya, suka gane mutane ne talakawa marasa ilimi, sai suka yi mamaki, suka kuma lura suka gane Bitrus da Yahaya sun kasance tare da Yesu. ");
INSERT INTO hauulb_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Da yake suna ganin mutumin nan da aka warkar tare da su, sai suka rasa abin yi. ");
INSERT INTO hauulb_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Amma bayan sun fitar da manzannin daga majalisa sai suka tattauna a tsakaninsu. ");
INSERT INTO hauulb_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Suka ce, “Yaya za mu yi da wadannan mutane? Babu shakka aikin al'ajibi ya faru ta wurinsu, kuma sananne ne ga dukan mazauna Urushalima, kuma ba mu da iko mu musanci haka. ");
INSERT INTO hauulb_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Amma saboda kada ya cigaba da yaduwa cikin mutane, bari mu yi masu kashedi kada su kara magana da kowa cikin wannan suna.'' ");
INSERT INTO hauulb_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Suka kira Bitrus da Yahaya suka dokace su kada su kara magana ko kuma koyarwa ko kadan a cikin sunan Yesu. ");
INSERT INTO hauulb_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Amma Bitrus da Yahaya suka amsa suka ce, ''Ko ya yi daidai a gaban Allah mu yi maku biyayya fiye da shi, ku hukunta. ");
INSERT INTO hauulb_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Baza mu iya daina magana game da abubuwan da muka ji kuma muka gani ba.'' ");
INSERT INTO hauulb_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Bayan sun sake yi wa Bitrus da yahaya kashedi, sai suka sake su, su tafi. Domin ba su iya samu wata hujja da za su hore su a kai ba, domin dukan mutane suna yabon Allah saboda abin da ya faru. ");
INSERT INTO hauulb_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Mutumin da ya sami wannan al'ajibi na warkarwa yana sama da shekara arba'in. ");
INSERT INTO hauulb_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Bayan an sake su, Bitrus da Yahaya suka zo cikin mutanensu suka ba da rahoton duk abin da manyan firistoci da dattawa suka fada masu. ");
INSERT INTO hauulb_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Da suka ji haka, suka daga muryarsu tare ga Allah suka ce, ''Ubangiji, kai da ka yi sama da duniya da teku da duk abin da ke cikinsu, ");
INSERT INTO hauulb_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","kai wanda ta wurin Ruhu Mai Tsarki ta bakin ubanmu Dauda bawanka, ya ce, 'Me ya sa al'ummai suka tunzura, kuma mutane suke tunanin abubuwan banza? ");
INSERT INTO hauulb_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Sarakunan duniya sun hada kansu tare, kuma shugabanninsu sun taru don su yi gaba da Ubangiji, da kuma Almasihunsa.' ");
INSERT INTO hauulb_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Hakika, Hiridus da Buntus Bilatus, tare da al'ummai da mutanen Isra'ila, sun taru a wannan birni domin su yi jayayya da bawanka mai tsarki Yesu, shafaffe. ");
INSERT INTO hauulb_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Sun taru domin su aiwatar da dukan abin da hannunka da nufinka ya shirya zai faru. ");
INSERT INTO hauulb_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Yanzu, Ya Ubangiji ka dubi kashedin su, ka ba bayin ka ikon furta maganar ka gabagadi. ");
INSERT INTO hauulb_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Sa'adda ka mika hannunka domin warkarwa, alamu da al'ajibai su faru ta wurin sunan bawanka mai tsarki Yesu.” ");
INSERT INTO hauulb_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Bayan sun gama addu'a, wurin da suka taru ya girgiza, suka cika da Ruhu Mai Tsarki, suka furta maganar Allah gabagadi. ");
INSERT INTO hauulb_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Babban taron da suka ba da gaskiya kansu hade yake; kuma ba wanda ya ce da abinda ya mallaka nasa ne; maimakon haka, komai na su daya ne. ");
INSERT INTO hauulb_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Da iko mai karfi manzannin suka yi shelar shaidarsu game da tashin Yesu Ubangiji daga matattu, babban alheri kuma na bisansu. ");
INSERT INTO hauulb_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Babu wani a cikinsu wanda ya rasa komai, domin masu filaye da gidaje suka sayar suka kawo kudin abin da suka sayar ");
INSERT INTO hauulb_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","sai suka kawo kudin gaban manzanni. Aka rarraba wa kowanne mutum bisa ga bukatarsa. ");
INSERT INTO hauulb_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Yusufu, Balawi, mutumin tsibirin Kubrus, wanda manzannisu ka yi wa lakani da suna Barnaba. (wato, mai karfafa zuciya). ");
INSERT INTO hauulb_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Yana da fili sai ya sayar da shi ya kawo kudin gaban manzanni. ");
INSERT INTO hauulb_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Sai wani mai suna Hananiya da matarsa Safiratu, suka sayar da filinsu, ");
INSERT INTO hauulb_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Hananiya kuwa ya boye wasu daga cikin kudin filin, (kuma da sanin matarsa), sa'annan suka kawo ragowar kudin a gaban manzannin. ");
INSERT INTO hauulb_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Amma Bitrus ya ce, ''Hananiya don me shaidan ya cika zuciyarka, har ka yi wa Ruhu Mai Tsarki karya? Har ka boye wasu daga kudin filin? ");
INSERT INTO hauulb_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Sa'adda ba ka sayar da filin ba, ba mallakarka bane? Bayan da ka sayar ma, ba naka bane? Don me kayi irin wannan tunanin a zuciyarka? To ba mutane ka yi wa karya ba, Allah ka yi wa.” ");
INSERT INTO hauulb_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Nan take da jin haka, Hananiya ya fadi ya ja numfashinsa na karshe. Dukan mutanen da suka ji labarin kuwa tsoro mai girma ya afko masu ");
INSERT INTO hauulb_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Matasa suka zo suka nannade gawarsa, suka fitar da shi waje suka binne shi. ");
INSERT INTO hauulb_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Bayan wajen sa'a uku, sai matarsa ta iso, ba tare da sanin abin da ya faru ba. ");
INSERT INTO hauulb_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Sai Bitrus ya ce mata, ''ki gaya mini ko nawa kuka sayar da filin?'' Sai ta amsa, ''ta ce kaza ne.” ");
INSERT INTO hauulb_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Sa'annan Bitrus ya ce mata, ''Don me kuka shirya wannan makidar tare da mijinki don ku gwada Ruhun Ubangiji? Kiji tafiyar wadanda suka bizne mijinki a bakin kofa, kuma za su dauke ki yanzu.'' ");
INSERT INTO hauulb_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Nan take sai ta fadi a gabansa, ta ja numfashinta na karshe, matasan kuwa suka zo suka same ta ta mutu; sai suka dauki gawarta suka kai waje suka kuma bizne ta kusa da mijinta. ");
INSERT INTO hauulb_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Tsoro mai girma kuwa ya afko wa iklisiyar gaba daya da dakan wadanda suka ji wadan nan al'amura. ");
INSERT INTO hauulb_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ayyukan alamu da ban mamaki masu yawa kuwa sun faru ga mutane, ta hannun manzannin. Dukansu kuma suna nan tare a dakalin Sulaimanu, ");
INSERT INTO hauulb_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Sai dai babu mai karfin halin ya hada kai tare dasu; amma suna da kwarjini sosai a gaban jama'a. ");
INSERT INTO hauulb_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Har wa yau aka rika samun karin masu ba da gaskiya, dinbin jama'a, maza da mata, ");
INSERT INTO hauulb_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","har sukan dauki marasa lafiya su kai su bakin titi, suna kwantar da su a bisa gadaje da shinfidu, domin idan Bitrus ya zo wucewa ko da inuwarsa ma ta taba wasunsu. ");
INSERT INTO hauulb_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Mutane dayawa kuwa sukan zo daga garuruwan da ke kewaye da Urushalima, suna kuma kawo masu rashin lafiya, da wadanda aljannu ke damunsu, aka kuma warkar da su duka. ");
INSERT INTO hauulb_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Amma babban firist ya taso tare da duk wadanda ke tare da shi (wato 'yan darikar Sadukiyawa); suka cika da kishi matuka ");
INSERT INTO hauulb_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","suka kama manzannin suka kuma jefasu a kurkuku. ");
INSERT INTO hauulb_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","A cikin dare sai mala'ikan Ubangiji ya bude kofofin kurkukun ya kuma fito da su waje, ya ce, ");
INSERT INTO hauulb_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Kuje ku tsaya a gaban haikali ku kuma gaya wa mutane maganar wannan rai.” ");
INSERT INTO hauulb_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Sa'adda suka ji haka, sai suka tafi haikalin da wayewar gari suka yi koyarwa. Amma babban firist da jama'arsa suka zo suka kuma kira taro da kuma dukan yan majalisa, da dattawan jama'ar Isra'ilawa suka fito suka kuma ba da umarni, a fito masu da manzannin. ");
INSERT INTO hauulb_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Amma ma'aikatan da suka je kurkukun basu sami kowa, a kurkukunba, sai suka dawo suka ba da rahoto, ");
INSERT INTO hauulb_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Su ka ce kurkukun a rufe gam da masu gadi suna nan a tsaye a bakin kofar amma da muka shiga, bamu sami kowa a ciki ba. ");
INSERT INTO hauulb_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Yanzu sa'adda shugaban haikalin da manyan firistoci suka ji wadannan kalamai, sai suka rikice sosai game da su, suka ce yanzu me wannan zai haifar. ");
INSERT INTO hauulb_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Sai wani ya zo ya ce masu, ''Wadannan mutanen da kuka jefa a kurkuku suna can a cikin haikali suna koyar da jama'a.'' ");
INSERT INTO hauulb_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Sai shugaban haikalin ya je da ma'aikatansa suka kawosu, ba tare da tashin hankali ba, domin gudun kada jama'a su jejjefesu. ");
INSERT INTO hauulb_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Da suka kawo su, sai suka gabatar da su gaban majalisa, babban firist kuwa ya tuhume su, ");
INSERT INTO hauulb_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","cewa ''Ba mun yi maku kashedi da karfi kada ku yi koyarwa cikin wannan sunan ba? Amma ga shi duk kun cika Urushalima da koyarwarku, kuna kuma neman kusa jinin mutumin nan ya sauko kanmu.” ");
INSERT INTO hauulb_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Amma Bitrus da manzannin suka amsa suka ce, ''Dole mu yi wa Allah biyayya ba mutane ba. ");
INSERT INTO hauulb_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Allah na ubanenmu ya ta da Yesu, wanda kuka kashe, ta wurin rateye shi a bisa itace, ");
INSERT INTO hauulb_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Allah kuwa ya daukaka shi a hannun damarsa, domin ya zama sarki da kuma mai ceto, ya ba Isra'ila tuba da gafarar zunubai. ");
INSERT INTO hauulb_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Mu kuwa shaidu ne ga wadannan al'amura, haka ma Ruhu Mai Tarki, wanda Allah ya bayar ga dukan wadanda suka yi biyayya a gareshi.'' ");
INSERT INTO hauulb_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Da yan majalisa suka ji haka sai suka fusata kwarai da gaske, har suka nemi su kashe manzannin. ");
INSERT INTO hauulb_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Amma wani Bafarise mai suna Gamaliel, malami ne kuma na attaura wanda dukan jama'a suna martabawa, sai ya mike ya ba da umarni cewa a fid da manzannin waje na dan lokaci. ");
INSERT INTO hauulb_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Sai ya ce masu ''Ya ku mutanen Isra'ila, ku lura sosai da a binda kuke niyyar yi wa mutanen nan, ");
INSERT INTO hauulb_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","A kwanakin baya wani ya zo mai suna Tudas ya dauki kansa wani abu, kimanin mutane dari hudu ne suka bishi, amma da aka kashe shi jama'arsa baki daya sai suka watse, ba wanda ya kara jin labarinsu. ");
INSERT INTO hauulb_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Bayansa kuma, aka yi wani mai suna Yahuza na Galili wanda a kwanakin kidaya, ya zo ya rinjayi mutane da yawa, shima ya lalace, duk wadanda suka bi shi kuwa suka watse. ");
INSERT INTO hauulb_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Don haka ina gaya maku ku rabu da mutanen nan, domin idan shirinsu ko kuma ayyukansu na mutane ne za su lalace. ");
INSERT INTO hauulb_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Amnma idan abin nan daga Allah yake baza ku iya lalata su ba; kada ya zama kuna gaba da Allah.'' Sai suka rinjayu. ");
INSERT INTO hauulb_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Da suka kira manzannin ciki suka yi masu duka, sai suka umarce su da cewa kada su sake koyarwa a cikin sunan Yesu, sai suka barsu suka tafi. ");
INSERT INTO hauulb_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Suka fita daga cikin majalisar, suna murna domin sun cancanta su sha wulakanci saboda sunan. ");
INSERT INTO hauulb_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Bayan haka kullayomin suna zuwa haikali, suna bi gida gida, suna wa'azi, suna kuma koyarwa ba fasawa cewa Yesu shine Almasihu. ");
INSERT INTO hauulb_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","A wadannan kwanaki, yawan almajiran ya ci gaba da ribanbanya, sai Yahudawan da suke zama a kasar Helanawa suka fara gunaguni game da Yahudawan Isra'ila, domin basu damu da gwamrayensu, wajen raba abinci da ake yi kullum. ");
INSERT INTO hauulb_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Manzannin nan sha biyu suka kira taron almajiran suka ce masu, ''Bai kamata mu bar maganar Allah mu shiga hidimar rabon abinci ba. ");
INSERT INTO hauulb_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Don haka ku zabi 'yan'uwa maza daga cikinku, mutane bakwai wadanda a ke ganin su da daraja, cike da Ruhu da kuma hikima, wadanda za mu zaba suyi wannan hidima. ");
INSERT INTO hauulb_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Mu kuwa mu ci gaba da da addu'a da kuma hidimar kalmar.'' ");
INSERT INTO hauulb_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Maganar su kuwa ta farantawa dukan jama'a rai sosai. Sai suka zabi Istifanus, shi kuwa mutum ne cike da bangaskiya kuma da Ruhu Mai Tsarki da Filibus, da Birokoros, da Nikanar, da Timan, da Barminas, da kuma Nikolas, mutmin Antakiya wanda ya yi tuban Yahudanci. ");
INSERT INTO hauulb_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Masu bin kuwa suka gabatar da wadannan mutanen a gaban manzannin, su kuwa suka yi masu addu'a suka kuma dora hannuwansu a kansu. ");
INSERT INTO hauulb_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Sai maganar Allah ta yawaita; yawan almajiran kuwa ya rubanbanya matuka a Urushalima; firistoci da yawa na Yahudawa suka bada gaskiya. ");
INSERT INTO hauulb_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Sai Istifanus, cike da alheri da iko, ya rika yin ayyukan ban mamaki da alamu a cikin jama'a. ");
INSERT INTO hauulb_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Amma sai ga wadansu mutane daga wata majami'a da ake kira majami'ar Yantattu, wato su Kuramiyawa da Iskandariyawa, da kuma wasu daga kasar Kilikiya da Asiya. Wadannan mutanen kuwa suna muhawara da Istifanus. ");
INSERT INTO hauulb_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Amma suka kasa yin tsayayya da Istifanus, saboda irin hikima da Ruhun da Istifanus ya ke magana da shi. ");
INSERT INTO hauulb_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Sai a asirce suka zuga wasu mutane su je su ce, ''Ai munji Istifanus yana maganganun sabo game da Musa da kuma Allah.'' ");
INSERT INTO hauulb_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Sai suka zuga mutanen, har da dattawa da marubuta suka tunkari Istifanus, suka kama shi, suka kawo shi gaban majalisa. ");
INSERT INTO hauulb_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Suka kawo masu shaidar karya suka ce, ''Wannan mutumin har yanzu bai dena maganganun gaba akan wannan wuri mai tsarki da kuma shari'a ba. ");
INSERT INTO hauulb_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Domin kuwa mun ji shi, yana cewa wannan Yesu Banazarat zai rushe wannan wuri zai kuma canza al'adun da muka gada daga wurin Musa.'' ");
INSERT INTO hauulb_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Dukan wadanda suke zaune a majalisar suka zuba masa ido, sai suka ga fuskarsa kamar ta mala'ika. ");
INSERT INTO hauulb_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Sai babban firist ya ce, ''Wadannan al'amura gaskiya ne?'' ");
INSERT INTO hauulb_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Sai Istifanus ya amsa ya ce, ''Ya 'yan'uwa da ubanni, ku saurare ni, Allah Madaukaki ya bayyana ga ubanmu Ibrahim tun yana can kasar Mesofotamiya, kafin ma ya zauna a kasar Haran; ");
INSERT INTO hauulb_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","ya ce masa, 'Ka bar kasarka da danginka, ka tafi kasar da zan nuna maka.' ");
INSERT INTO hauulb_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Sa'annan ya bar kasar Kaldiyawa ya zo ya zauna a Haran; daga can, bayan rasuwar mahaifinsa, sai Allah ya kira shi zuwa wannan kasa da kuke ciki. ");
INSERT INTO hauulb_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Amma Allah bai ba shi kasar gado ba tukuna, ko da misalin tafin sawunsa. Amma ya alkawarta - ko da yake bai riga ya haifi da ba tukuna - wanda zai ba shi kasar gado, shi da zuriyarsa, a bayansa. ");
INSERT INTO hauulb_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Allah ya yi magana da shi kamar haka, cewa zuriyarsa za su yi bakonci a wata kasa wadda ba tasu ba, mutanen wannan kasar kuwa za su gwada masu bakar azaba su kuma bautar da su har shekaru dari hudu. ");
INSERT INTO hauulb_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","'Kuma zan hukunta wannan al'umma da ta bautar da su,' Allah ya ce, 'Bayan haka za su fito daga wannan kasa su bauta mini a wannan wuri.' ");
INSERT INTO hauulb_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Allah ya ba Ibrahim alkawarin kaciya, sai Ibrahim ya haifi Ishaku ya yi masa kaciya a rana ta takwas; Ishaku ya haifi Yakubu, Yakubu kuma ya haifi ubanni Isra'ila su goma sha biyu. ");
INSERT INTO hauulb_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Wadannan 'yan'uwa suka yi kyashin danuwansu Yusifu suka sayar da shi bauta zuwa Masar. Amma Allah na tare da shi. ");
INSERT INTO hauulb_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Ya kuwa cece shi daga dukan sharin da yan uwansa suka kulla masa, Allah kuwa ya ba shi tagomashi da hikima a gaban Fir'auna, sarkin Masar. Fir'auna kuwa ya mai da shi mai mulki a dukan kasar Masar da kuma dukan mallakarsa. ");
INSERT INTO hauulb_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Sai aka yi babbar yunwa a dukan kasar Masar da ta Kan'ana, iyayenmu suka sha wuya saboda rashin abinci. ");
INSERT INTO hauulb_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Amma lokacin da Yakubu ya ji akwai hatsi a kasar Masar, sai ya aiki ubannimu a karo na farko. ");
INSERT INTO hauulb_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Da suka je a karo na biyu, sai Yusifu ya bayyana kansa ga yanuwansa; a wannan lokaci ne Fir'auna ya gane da yanuwan Yusufu. ");
INSERT INTO hauulb_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Yusufu ya aiki yanuwansa su kawo Yakubu ubansu da dukan mallakarsu da iyalansu zuwa Masar, Dukansu mutane saba'in da biyar ne. ");
INSERT INTO hauulb_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Yakubu ya tafi ya zauna a Masar; shi da zuriyarsa har mutuwar su. ");
INSERT INTO hauulb_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Aka dauke su zuwa Shekem aka binne su a kabarin da Ibrahim ya saya da kudin azurfa daga hannun yayan Hamor a Shekem. ");
INSERT INTO hauulb_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Yayin da alkawarin Allah ya kusato wanda Allah ya fada wa Ibrahim, mutanen suka karu suka hayayyafa kwarai a Masar, ");
INSERT INTO hauulb_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Sai a ka yi wani sarki a Masar wanda bai san Yusifu ba, ");
INSERT INTO hauulb_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Wannan sarki ya yaudari kakkaninmu ya yi masu mugunta kwarai da gaske, har ma ya kai ga suna barin jariransu cikin hasari don su ceci rayukansu. ");
INSERT INTO hauulb_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","A wannan lokaci ne aka haifi Musa, kuma kyakkyawan yaro ne sai aka yi renon sa tsawon wata uku a gidan mahaifinsa a asirce. ");
INSERT INTO hauulb_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Yayin da aka jefar da shi, sai diyar Fir'auna ta dauke shi ta rene shi kamar danta. ");
INSERT INTO hauulb_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Aka ilimantar da Musa da dukan ilimi irin na Masar; kuma ya shahara cikin fasahar magana da kuma ayyukansa. ");
INSERT INTO hauulb_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Amma lokacin da yakai shekara arba'in, sai ya yi niyyar ya ziyarci 'yan'uwansa, Isra'ilawa. ");
INSERT INTO hauulb_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Sai ya ga wani na cin zalin Ba Isra'ile, Musa kuwa ya taimaki wanda ake kwara ta wurin murkushe Bamasaren: ");
INSERT INTO hauulb_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","zaton Musa 'yan'uwansa za su fahimci taimakon Allah ne ya zo masu amma ina! Basu gane ba. ");
INSERT INTO hauulb_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Washegari ya ga wasu Isra'ilawa na fada da junansu; ya yi kokari ya raba su; sai ya ce masu, 'Malamai, ku 'yan'uwan juna ne; don me kuke fada da junanku?' ");
INSERT INTO hauulb_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Amma shi wanda ake kwarar makwabcinsa ya ture Musa a gefe guda, ya ce, 'Wa ya nada ka shugaba ko alkali akanmu? ");
INSERT INTO hauulb_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Kana so ka kashe ni ne, kamar yadda ka kashe Bamasaren nan jiya?' ");
INSERT INTO hauulb_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Da jin haka sai Musa ya gudu, zuwa kasar Midinawa, a matsayin dan gudun hijira. Anan ya haifi ''ya'ya biyu maza. ");
INSERT INTO hauulb_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Bayan da shekaru arba'in suka wuce, sai mala'ika ya bayyana gare shi a jeji, kusa da dutsen Sinai, a cikin harshen wuta a cikin jeji. ");
INSERT INTO hauulb_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Sa'adda Musa ya ga wutar, mamaki ya kama shi; sai ya maso kusa don ya kara dubawa, sai ya ji muryar Ubangiji na cewa, ");
INSERT INTO hauulb_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","'Nine Allah na ubanninka, Ibrahim, da na Ishaku, da na Yakubu.' Musa ya razana har ma bai sake daga kai ya duba ba. ");
INSERT INTO hauulb_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ubangiji ya ce masa, 'Tube takalminka, domin in da kake tsaye wuri mai tsarki ne. ");
INSERT INTO hauulb_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ba shakka na ga wahalar da mutane na ke sha a Masar, kuma na ji nishinsu, don haka na zo in cece su, yanzu fa sai ka zo, in aike ka zuwa Masar.' ");
INSERT INTO hauulb_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Wannan fa shine Musan da suka ki, harma da cewa, 'Wanene ya nada ka alkali ko shugaba a kanmu?' Shine kuma wanda Allah ya aiko masu a matsayin shugaba da kuma mai ceto. Allah ya aiko shi ta hannun mala'ikan da ya gani a daji. ");
INSERT INTO hauulb_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Bayan alamu da al'ajibai iri-iri a Masar da kuma Baharmaliya, Musa ya fito da su daga Masar da kuma cikin jeji, a lokacin da suka yi tafiya shekara arbain. ");
INSERT INTO hauulb_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Wannan shine Musan da ya cewa Isra'ilawa, 'Ubangiji zai tayar maku da wani annabi kamar ni daga cikin Yan'uwan ku.' ");
INSERT INTO hauulb_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Wannan shine mutumin da ke tare da mutane a jeji. Karkashin jagorancin mala'ikan da ya yi magana da shi a dutsen Sinai. Wannan ne mutumin da ke tare da ubannen mu, wannan shi ne mutumin da ya ba mu maganar Allah mai rai. ");
INSERT INTO hauulb_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Wannan shine mutumin da ubannenmu suka ki su yi masa biyayya; su ka fitar da shi daga cikinsu, suka kudurta a zuciyarsu za su koma masar. ");
INSERT INTO hauulb_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","A lokacin ne suka cewa Haruna, 'ya yi masu allolin da za su jagorance su zuwa masar. Domin kuwa ga zancen Musan nan da ya fito da mu daga Masar, ba mu san abin da ya faru da shi ba.' ");
INSERT INTO hauulb_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Sai suka kera dan maraki suka kawo wa gunkin hadaya, suka yi murna da abin da hannayensu suka kera. ");
INSERT INTO hauulb_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Allah ya bashe su su bauta wa tauraran sama, kamar yadda yake a rubuce cikin littattafafan annabawa, 'Kun mika mani hadayu na yankakkun dabbobi a jeji ne a shekaru arba'in din nan ya ku Isra'ilawa?' ");
INSERT INTO hauulb_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Kun yarda da haikalin Molek da kuma tauraron allahn nan Rafem, da kuma siffofin nan da kuka kera don ku yi masu sujada; don haka zan kai ku bauta har gaba da Babila.' ");
INSERT INTO hauulb_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Kakkaninmu suna da alfarwa ta sujada domin shaida a cikin jeji, kamar yadda Allah ya umarta yayin da ya yi magana da Musa, cewa ya yi shi bisa ga salon da aka nuna mashi. ");
INSERT INTO hauulb_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Wannan shine Alfarwar da kakkaninmu suka zo da shi, a lokacin Joshuwa. Wannan ya faru ne yayin da suka mallaki wannan kasa ta al'ummai da Allah ya kora a gaban kakkaninmu. Haka abin yake har ya zuwa zamanin Dauda, ");
INSERT INTO hauulb_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","wanda ya sami tagomashi a wurin Allah; don ya gina masujada domin Allah na Yakubu. ");
INSERT INTO hauulb_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Amma Sulaimanu ne ya gina Gidan Allah. ");
INSERT INTO hauulb_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Sai dai Madaukaki ba yakan zauna a gidan da hannaye suka gina ba, kamar yadda annabin ya ce, ");
INSERT INTO hauulb_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","'Sama kursiyina ce, duniya kuwa wurin ajjiye sawayena ne. To wane irin gida za ku gina mani? inji Ubangiji: ko kuwa ina ne wurin da zan huta? ");
INSERT INTO hauulb_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ko ba hannayena ne suka yi dukan wadannan ba?' ");
INSERT INTO hauulb_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Ku mutane masu taurin kai masu zuciya mara kaciya da kunnuwa marasa ji, kullum kuna gaba da Ruhu Mai Tsarki, kuna aikata abin da kakkaninku suka aikata. ");
INSERT INTO hauulb_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Wane annabi ne kakkaninku ba su tsanantawa ba? Sun kashe annabawan da suka rigayi zuwan Mai Adalcin nan, kuma kun zama wadanda suka kasance masu bashe shi da masu kashe shi, ");
INSERT INTO hauulb_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","kune mutanen da kuka karbi shari'a wadda mala'iku suka bayar, amma ba ku kiyaye ta ba”. ");
INSERT INTO hauulb_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Yayin da majalisar suka ji wannan, sai ransu ya baci kwarai, har suna cizon hakoransu don gaba da Istifanus. ");
INSERT INTO hauulb_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Amma shi, cike da Ruhu Mai Tsarki, sai ya daga idonsa sama, ya ga daukakar Allah; ya kuma hango Yesu na tsaye a hannun daman Allah. ");
INSERT INTO hauulb_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Istifanus ya ce, “Duba, ina ganin sama ta bude, ga Dan Mutum na tsaye a hannun dama na Allah.” ");
INSERT INTO hauulb_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Amma yan majalisar suka daga murya da karfi, suka yi ihu, suka kuma toshe kunnuwansu, gaba dayansu suka afka masa; ");
INSERT INTO hauulb_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","suka fitar da shi bayan gari, suka jejjefe shi da duwatsu, don shaida sai suka tube manyan rigunansu suka ajiye a gaban wani matashi da ake ce da shi Shawulu. ");
INSERT INTO hauulb_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Lokacin da suke kan jifan Istifanus, ya dinga kira yana cewa, ''Ya Ubangiji Yesu, ka karbi ruhu na.” ");
INSERT INTO hauulb_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ya durkusa ya daga murya da karfi, ya ce, “Ya Ubangiji, kada ka rike wannan zunubi a kansu.” Yayin da ya fadi wannan, sai ya yi barci. ");
INSERT INTO hauulb_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Bulus ya amince da mutuwarsa. A wannan rana tsanani mai zafi ya fara tasowa akan Iklisiya da take a Urushalima, sai masu bangaskiya duka suka bazu ko ina a cikin garuruwan Yahudiya da Samariya, sai manzannin kadai aka bari. ");
INSERT INTO hauulb_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Amintattun mutane suka bizne Istifanus suka yi babban makoki game da shi. ");
INSERT INTO hauulb_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Amma Shawulu ya yi wa Iklisiya mugunta kwarai, ya dinga shiga gida gida yana jawo mutane maza da mata, kuma yana kulle su cikin kurkuku. ");
INSERT INTO hauulb_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Duk da haka masu bangaskiyar nan da suka warwatsu suka tafi suka dinga yada wa'azin maganar. ");
INSERT INTO hauulb_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filibus ya tafi can Samariya ya yi shelar Almasihu. ");
INSERT INTO hauulb_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Da taron mutane suka ji kuma suka ga alamun da Filibus yake yi, sai suka mai da hankali dukansu domin su ji abinda yake fadi. ");
INSERT INTO hauulb_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Domin kazaman ruhohi sun fito daga cikin mutane da yawa da suka saurare shi suna kuka da kururuwa; nakasassun mutane dayawa da guragu suka warke. ");
INSERT INTO hauulb_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Kuma aka yi farin ciki mai girma a birnin. ");
INSERT INTO hauulb_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Amma akwai wani mutum a cikin birnin da ake kira Siman, wanda tun farko shi masafi ne da kuma dan dabo, yana yi wa mutanen Samariya abubuwan ban mamaki, yayin da yake kiran kansa wani mai muhimmanci. ");
INSERT INTO hauulb_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Dukan Samariyawa, manya da yara, suna sauraronsa, su kan ce, ''Wannan mutum shine ikon Allahn nan wanda ake kira mai girma.'' ");
INSERT INTO hauulb_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Suna sauraron sa, domin ya dade yana yi masu abubuwan mamaki da tsafe-tsafensa. ");
INSERT INTO hauulb_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Amma da suka yi bangaskiya da wa'azin bisharar da Filibus yake yi game da mulkin Allah da sunan Yesu Almasihu, sai aka yi masu Baftisma dukansu maza da mata. ");
INSERT INTO hauulb_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Har shima Siman da kansa ya ba da gaskiya. Bayan an yi masa Baftisma ya cigaba da bin Filibus, da ya ga ana nuna alamu da manyan ayyuka, sai ya yi mamaki. ");
INSERT INTO hauulb_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Da manzannin da ke Urushalima suka ji labarin Samariya ta karbi maganar Allah, sai suka aika masu Bitrus da Yahaya. ");
INSERT INTO hauulb_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Da suka iso, suka yi masu addu'a, domin su karbi Ruhu Mai Tsarki. ");
INSERT INTO hauulb_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Domin har wannan lokaci, Ruhu Mai Tsarki bai sauko kan kowannensu ba; an dai yi masu baftisma ne kadai cikin sunan Ubangiji Yesu. ");
INSERT INTO hauulb_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Sai Bitrus da Yahaya suka dora masu hannuwansu, sai suka karbi Ruhu Mai Tsarki. ");
INSERT INTO hauulb_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Sa'adda Siman yaga ana bayar da Ruhu Mai Tsarki ta wurin dorawar hannuwan manzanni, ya basu kudi. ");
INSERT INTO hauulb_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Ya ce, “Ku bani wannan iko, ni ma, don duk wanda na dora wa hannu ya karbi Ruhu Mai Tsarki.'' ");
INSERT INTO hauulb_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Amma Bitrus yace masa, ''Azurfarka ta lalace tare da kai, saboda kana tunanin za ka malaki baiwar Ubangiji da kudi. ");
INSERT INTO hauulb_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Baka da wani rabo a wannan al'amari, domin zuciyarka ba daidai take da Allah ba. ");
INSERT INTO hauulb_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Saboda haka ka tuba daga wannan muguntarka, ka kuma yi addu'a ga Ubangiji, domin mai yiwuwa ya gafarta maka game da manufar zuciyarka. ");
INSERT INTO hauulb_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Domin na gane kana cikin bacin rai da kuma cikin daurin zunubi.'' ");
INSERT INTO hauulb_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Siman ya amsa ya ce, ''Kayi addu'a ga Ubangiji domina, kada wani daga cikin abubuwan nan da ka fada ya faru da ni.'' ");
INSERT INTO hauulb_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Sa'anda Bitrus da Yahaya suka bada shaida kuma suka fadi maganar Ubangiji, sun koma Urushalima; akan hanya, suka yi wa'azin bishara a kauyukan samariyawa da yawa. ");
INSERT INTO hauulb_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Yanzu kuwa Mala'ikan Ubangiji ya yi wa Filibus magana cewa, ''Tashi ka tafi ta kudu da hanyar da ta yi kasa daga Urushalima zuwa Gaza'' (wannan hanyar yana cikin hamada.) ");
INSERT INTO hauulb_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Ya kuwa tashi ya tafi. Sai ga wani mutum daga Habasha, baba ne mai babban matsayi a karkashin Kandakatu, sarauniyar Habasha. Shine yake mulkin dukan dukiyarta. Ya zo Urushalima domin ya yi ibada. ");
INSERT INTO hauulb_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Yana komawa zaune cikin karussarsa, kuma yana karanta Littafin annabi Ishaya. ");
INSERT INTO hauulb_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ruhun ya ce wa Filibus, ''Ka je kusa da karussar nan.'' ");
INSERT INTO hauulb_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Sai Filibus ya gudu ya same shi, kuma ya ji shi yana karanta littafin annabi Ishaya, sai ya ce, ''Ka fahimci abin da kake karantawa?'' ");
INSERT INTO hauulb_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Bahabashen ya ce. ''Yaya zan iya, idan ba wani ya bishe ni ba?'' Ya roki Filibus ya shigo cikin karussar ya zauna tare da shi. ");
INSERT INTO hauulb_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Wannan kuwa shine nassin da Bahabashen yake karantawa, ''An kai shi kamar tunkiya zuwa mayanka; shiru kuma, kamar dan rago a hannun masu sosayarsa, bai bude baki ba. ");
INSERT INTO hauulb_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Cikin kaskancinsa aka yi masa shari'a da rashin adalci: Wa zai bada tarihin tsararsa? Domin an dauke ransa daga duniya.'' ");
INSERT INTO hauulb_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Sai baban ya tambayi Filibus, ya ce, ''Na roke ka, gaya mani, game da wa annabin yake magana? Da kansa, ko kuwa wani mutum dabam?'' ");
INSERT INTO hauulb_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Filibus ya fara magana; akan littafin Ishaya, ya kuwa yi masa wa'azi akan Yesu. ");
INSERT INTO hauulb_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Yayin da suke tafiya akan hanya, sai suka iso bakin wani kogi; Baban ya ce, “Duba, ga ruwa anan; me zai hana ayi mani baftisma?” ");
INSERT INTO hauulb_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filibus ya ce,” Idan ka gaskanta da zuciya daya, ana iya yi maka baftisma.” Sai Bahabashen ya ce, “Na gaskata Yesu Almasihu shine Dan Allah.” ");
INSERT INTO hauulb_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Sai Bahabashen ya umarta a tsai da karussar. Sai suka zo wurin ruwa dukan su biyu, Filibus da baban, Filibus kuwa yayi masa baftisma. ");
INSERT INTO hauulb_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Yayin da suka fito daga cikin ruwan, Ruhun Ubangiji ya dauke Filibus; baban bai sake ganin shi ba, sai ya ci gaba da tafiyar sa yana murna. ");
INSERT INTO hauulb_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Amma Filibus ya bayyana a Azotus. Ya ratsa wannan yankin yana wa'azin bishara a dukan garuruwan, har sa'anda ya iso Kaisariya. ");
INSERT INTO hauulb_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Amma Shawulu, ya cigaba da maganganun tsoratarwa har ma da na kisa ga almajiran Ubangiji, ya tafi wurin babban firist ");
INSERT INTO hauulb_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","kuma ya roke shi wasiku zuwaga majami'un da ke Dimashku, domin idan ya sami wani da ke na wannan hanya, maza ko mata, ya kawo su Urushalima a daure. ");
INSERT INTO hauulb_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Yayin da yana tafiya, ya kasance da ya iso kusa da Dimashku, nan da nan sai ga wani haske daga sama ya haskaka kewaye da shi; ");
INSERT INTO hauulb_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Sai ya fadi a kasa kuma yaji wata murya na ce da shi, ''Shawulu, Shawulu, me yasa kake tsananta mani?'' ");
INSERT INTO hauulb_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Shawulu ya amsa, ''Wanene kai, Ubangiji?'' Ubangiji ya ce, ''Nine Yesu wanda kake tsanantawa; ");
INSERT INTO hauulb_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","amma ka tashi, ka shiga cikin birnin, kuma za a gaya maka abinda lallai ne kayi. ");
INSERT INTO hauulb_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Mutanen da ke tafiya tare da Shawulu suka tsaya shiru sun rasa abin fada, suna sauraron muryar, amma ba su ga kowa ba. ");
INSERT INTO hauulb_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Shawulu ya tashi daga kasa, kuma daga ya bude idanunsa, baya ganin komai; sai suka kama hannuwansa suka yi masa jagora suka kawo shi cikin birnin Dimashku. ");
INSERT INTO hauulb_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Har kwana uku ba ya kallo, kuma ba ya ci balle sha. ");
INSERT INTO hauulb_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Akwai wani almajiri a Dimashku mai suna Hananiya; sai Ubangiji ya yi magana da shi cikin wahayi, ya ce, ''Hananiya.'' Sai ya ce, ''Duba, gani nan Ubangiji.'' ");
INSERT INTO hauulb_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ubangiji ya ce masa, ''Tashi, ka tafi titin da ake kira Mikakke, kuma a gidan wani mai suna Yahuza ka tambaya mutum daga Tarsus mai suna Shawulu; gama yana addu'a; ");
INSERT INTO hauulb_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","kuma ya gani cikin wahayi mutum mai suna Hananiya na shigowa kuma ya daura masa hannu, domin idanunsa su bude.'' ");
INSERT INTO hauulb_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Amma Hananiya ya amsa, ''Ubangiji, na ji labari daga wurin mutane da yawa game da mutumin nan, da irin muguntar da ya aikata ga tsarkakan mutanenka da ke Urushalima. ");
INSERT INTO hauulb_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","An bashi izini daga babban firist domin ya kama dukan wanda ke kira bisa sunanka.'' ");
INSERT INTO hauulb_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Amma Ubangiji ya ce masa, ''Jeka, gama shi zababben kayan aiki na ne, wanda zai yada sunana ga al'ummai da sarakuna da 'ya'yan Isra'ila; ");
INSERT INTO hauulb_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Domin zan nuna masa irin wahalar da zai sha sabo da sunana.'' ");
INSERT INTO hauulb_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Sai Hananiya ya tafi, ya shiga gidan. Ya dora masa hannu a kai, ya ce, ''Dan'uwa Shawulu, Ubangiji Yesu, wanda ya bayyana a gareka a hanya sa'adda kake zuwa, ya aiko ni domin ka sami ganin gari ka kuma cika da Ruhu Mai Tsarki.'' ");
INSERT INTO hauulb_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Nan take wani abu kamar bawo ya fado daga idanun Shawulu, kuma ya sami ganin gari; ya tashi aka yi masa baftisma; ");
INSERT INTO hauulb_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","kuma ya ci abinci sai aka karfafa shi. Ya zauna tare da almajirai a Dimashku kwanaki da yawa. ");
INSERT INTO hauulb_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Nan take ya fara shellar Yesu cikin haikali, yana cewa shine dan Allah. ");
INSERT INTO hauulb_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Dukan wadanda suka saurare shi suka yi mamaki suka ce ''Ba wannan mutumin ne yake hallaka mutanen Urushalima da ke kira bisa ga wannan suna ba? Ya kuma zo nan domin ya ba da su a daure ga manyan firistoci.'' ");
INSERT INTO hauulb_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Amma Shawulu kuwa ya sami iko sosai, kuma yana haddasa damuwa tare da rinjaya tsakanin Yahudawan dake zama a Dimashku ta wurin tabbatar da Yesu shine Almasihu. ");
INSERT INTO hauulb_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Bayan kwanaki da yawa, sai Yahudawan suka yi shiri domin su kashe shi. ");
INSERT INTO hauulb_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Amma shirin su ya zama sananne ga Shawulu. Suna fakkon sa ta wurin tsaron kofar birnin dare da rana domin su kashe shi. ");
INSERT INTO hauulb_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Amma da tsakar dare almajiransa suka daukeshi a kwando, suka zurara shi ta katanga. ");
INSERT INTO hauulb_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sa'adda ya zo Urushalima, Shawulu ya yi niyyar hada kai da almajirai, amma dukansu suna tsoronsa, domin ba su yarda cewa shima ya zama almajiri ba. ");
INSERT INTO hauulb_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Amma Barnaba ya dauke shi ya kawo shi wurin manzannin. Ya kuwa gaya musu yadda Shawulu ya sadu da Ubangiji a hanya, har Ubangiji ya yi magana da shi, kuma yadda Shawulu ya yi wa'azi cikin sunan Yesu gabagadi a Dimashku. ");
INSERT INTO hauulb_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ya sadu da su lokacin shigar su da fitar su a Urushalima. Ya yi wa'azi gabagadi cikin sunan Ubangiji Yesu ");
INSERT INTO hauulb_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","kuma yana muhawara da Yahudawan Helenanci; amma sun ci gaba da kokarin kashe shi. ");
INSERT INTO hauulb_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Da 'yan'uwa suka gane haka, sai suka kawo shi Kaisariya, suka kuwa tura shi zuwa Tarsus. ");
INSERT INTO hauulb_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Sa'annan iklisiya dake dukan kasar Yahudiya, Galili da kuma Samariya suka sami salama da kuma ginuwa; suka kuwa ci gaba da tafiya cikin tsoron Ubangiji, da kuma ta'aziyar Ruhu Mai Tsarki, iklisiyar kuwa ta karu da yawan mutane. ");
INSERT INTO hauulb_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Har ta kai, yayin da Bitrus ya zaga dukan yankin kasar, ya dawo wurin masu bi dake zama a garin Lidda. ");
INSERT INTO hauulb_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","A can kuwa ya sami wani mutum mai suna Iniyasu, wanda yake shanyayye ne, yana kwance har tsawon shekara takwas a kan gado. ");
INSERT INTO hauulb_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Bitrus ya ce masa, ''Iniyasu, Yesu Almasihu ya warkar da kai. Tashi ka nade shimfidarka.'' Nan take sai ya mike. ");
INSERT INTO hauulb_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Sai duk mazauna kasar Lidda da kasar Sarona suka ga mutumin, suka kuma juyo ga Ubangiji. ");
INSERT INTO hauulb_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Yanzu kuwa a Yafa akwai wata almajira, mai suna Tabita, ma'ana ''Dokas.'' Wannan matar kuwa tana chike da ayyukan nagarta da halin tausayi da take yi ga mabukata. ");
INSERT INTO hauulb_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ya kai ga cewa a kwanakin can ta yi rashin lafiya har ta mutu; da suka wanke gawar ta suka kwantar da ita a bene. ");
INSERT INTO hauulb_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Da shike Lidda na kusa da Yafa, almajiran kuma sun ji cewa Bitrus yana can, suka aika mutane biyu wurinsa. Suna rokansa, ''Ka zo garemu ba tare da jinkiri ba.'' ");
INSERT INTO hauulb_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Bitrus ya tashi ya tafi da su, da isowar sa, suka kai shi benen. Sai dukan gwamrayen suka tsaya kusa da shi suna kuka, sai suka dauko riguna da sutura da Dokas ta dinka lokacin da take tare da su. ");
INSERT INTO hauulb_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Bitrus ya fitar da su duka daga cikin dakin, ya durkusa, ya yi addu'a; sai, ya juya wurin gawar, ya ce, ''Tabita, tashi.'' Ta bude idanunta, da ta ga Bitrus ta zauna, ");
INSERT INTO hauulb_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Bitrus kuwa ya mika hannunsa ya tashe ta; sa'annan ya kira masu bi da gwamrayen, ya mika ta a raye garesu. ");
INSERT INTO hauulb_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Wannan al'amari ya zama sananne cikin dukan Yafa, kuma mutane da yawa suka bada gaskiya ga Ubangiji. ");
INSERT INTO hauulb_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ya kasance, cewa, Bitrus ya zauna kwanaki da dama a Yafa tare da wani mutum mai suna Saminu, majemi. ");
INSERT INTO hauulb_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","An yi wani Mutum a birnin Kaisariya, mai suna Karniliyas, shugaban sojoji ne na kungiyar da ake kira Italiya. ");
INSERT INTO hauulb_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Mutum ne mai ibada, wanda ya mika kansa da iyalinsa ga bautar Allah; ya kan bada taimakon kudi mai yawa ga Yahudawa, kuma yana addu'a ko yaushe ga Allah. ");
INSERT INTO hauulb_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Wajen sa'a ta tara ga yini, an bayyana masa cikin wahayi mala'kan Ubangiji na zuwa gare shi sai mala'ikan ya ce masa, ''Karniliyas!'' ");
INSERT INTO hauulb_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Karniliyas ya zuba wa mala'ikan ido a tsorace ya ce ''Menene, mai gida?'' mala'ikan ya ce masa, ''Addu'ar ka da taimakon ka ga talakawa ya kai sama matsayin sadaka abin tunawa a gaban Allah, ");
INSERT INTO hauulb_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","''Yanzu ka aika mutane zuwa birnin Yafa su kawo mutum mai suna Saminu wanda ake kira Bitrus. ");
INSERT INTO hauulb_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Yana zama tare da Saminu majemi, wanda gidansa ke bakin teku. ");
INSERT INTO hauulb_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Da mala'ikan da ya yi magana da shi ya tafi, Karniliyas ya kira biyu daga barorin gidansa, da kuma soja guda mai bautar Allah daga cikin sojojin da suke masa hidima. ");
INSERT INTO hauulb_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Karniliyas ya fada masu dukan abin ya faru sai ya aike su Yafa. ");
INSERT INTO hauulb_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Washe gari wajen sa'a ta shida (tsakar rana) suna cikin tafiya da suka yi kusa da birni, Bitrus ya hau kan bene don ya yi addu'a. ");
INSERT INTO hauulb_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Sai ya ji yunwa kuma yana bukatar wani abinda da zai ci, amma a yayin da mutanen na dafa abinci, sai ya ga wahayi. ");
INSERT INTO hauulb_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Sai ya ga sararin sama ya bude kuma wani tasa na saukowa, wani abu kamar babban mayafi yana saukowa zuwa duniya, ana zuro shi ta kusuryoyinsa hudu. ");
INSERT INTO hauulb_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","A cikinsu kuwa akwai dukan halitun dabbobi masu kafa hudu da kuma masu rarrafe a duniya da tsunstayen sama. ");
INSERT INTO hauulb_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Sai murya ta yi magana da shi; “Tashi, Bitrus, yanka ka ci '' ");
INSERT INTO hauulb_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Amma Bitrus ya ce ''Ba haka ba, Ubangiji, gama ban taba cin abu mara tsarki ko mai kazanta ba.” ");
INSERT INTO hauulb_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Amma muryar ta sake zuwa masa karo na biyu kuma; “Abinda Allah ya tsarkake, kada ka kira shi kazantacce.” ");
INSERT INTO hauulb_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Wannan ya faru sau uku; nan da nan sai aka dauki tasar zuwa sama. ");
INSERT INTO hauulb_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","A yayin da Bitrus na cikin rudani game da ma'anar wahayin da ya gani, sai ga mutanen da Karniliyas ya aika suna tsaye a bakin kofar gidan, bayan sun tambayi hanyar zuwa gidan, ");
INSERT INTO hauulb_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Kuma suka yi sallama suna tambaya ko Saminu wanda ake kira Bitrus ya sauka a nan. ");
INSERT INTO hauulb_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","A yayin da Bitrus yana kan tunani akan wahayin, Ruhu ya ce masa, “Duba, mutane uku na neman ka.” ");
INSERT INTO hauulb_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Tashi ka sauka ka tafi tare da su. Kada ka yi jinkirin tafiya tare da su, domin Nine na aike su.” ");
INSERT INTO hauulb_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Bitrus kuwa ya sauko wurin mutanen ya ce, “Ni ne wanda kuke nema. Me ya sa kuka zo?” ");
INSERT INTO hauulb_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Suka ce, “Shugaban soja mai suna Karniliyas, adalin mutum kuma mai bautar Allah, yana da kyakkyawar shaida a dukan al'umman Yahudawa, shi ne wanda mala'ika mai tsarki na Allah ya aika domin ka zo gidansa, ya ji sako daga wurinka.” ");
INSERT INTO hauulb_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Sai Bitrus ya gayyace su su zo ciki kuma su zauna tare da shi. Washegari sai ya tafi tare da su, kuma wadansu 'yan'uwa daga Yafa suka raka shi. ");
INSERT INTO hauulb_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Kashegari suka shiga Kaisariya, Karniliyas kuwa yana jiran su; har ma ya gayyaci 'yan'uwansa da kuma abokansa na kusa. ");
INSERT INTO hauulb_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Ya kasance sa'adda Bitrus ya shiga, Karniliyas ya sadu da shi kuma ya durkusa ya yi masa sujada. ");
INSERT INTO hauulb_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Amma Bitrus ya tashe shi yana cewa, “Tashi tsaye! Ni ma mutum ne.” ");
INSERT INTO hauulb_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","A lokacin da Bitrus yake magana da shi, ya shiga ciki sai ya tarar da mutane da yawa sun taru a wuri daya. ");
INSERT INTO hauulb_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ya ce masu, “Ku da kanku kun sani bai dace Bayahuden mutum ya yi ma'amulla ko ya ziyarci wani ko wata kabila ba. Amma Allah ya ce da ni kada in ce da kowa mara tsarki ko kazantacce. ");
INSERT INTO hauulb_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Wannan shine yasa na zo ba tare da musu ba, a lokacin da kuka kira ni. Don haka na tambaye ku me ya sa kuka aika in zo.” ");
INSERT INTO hauulb_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Karniliyas ya ce “Kwanaki hudu da sun wuce a daidai wannan lokaci, ina addu'a da cikin sa'a na tara (karfe uku) a gidana, sai na ga mutum tsaye a gabana da tufafi mai haske. ");
INSERT INTO hauulb_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Ya ce, “Karniliyas, Allah ya ji addu'ar ka, kuma taimakon ka ga talakawa ya tuna ma Allah da kai. ");
INSERT INTO hauulb_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Saboda haka ka aika da wani Yafa, ya kira maka mutum mai suna Saminu wanda ake kira Bitrus. Yana zama a gidan Saminu majemi, da ke bakin teku. ");
INSERT INTO hauulb_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Idan ya zo, zai yi magana da kai. ");
INSERT INTO hauulb_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Sai Bitrus ya bude bakinsa ya ce, “Gaskiya, na fahimci Allah baya nuna bambanci. ");
INSERT INTO hauulb_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Maimakon haka, cikin kowace al'umma duk mai ibada kuma mai aikata adalci karbabbe ne a gare shi. ");
INSERT INTO hauulb_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ku kun san sakon da ya aika wa mutanen Isra'ila, a lokacin da ya sanar da labarin mai kyau na salama ta wurin Yesu Kristi, wanda shine Ubangiji na duka. ");
INSERT INTO hauulb_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Ku da kanku kun san al'amuran da suka kasance, wanda ya faru cikin Yahudiya, farawa daga Galili, bayan sanarwar baftismar da Yahaya ya yi. ");
INSERT INTO hauulb_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Al'amura game da Yesu Banazare, yadda Allah ya kebe shi da Ruhu Mai Tsarki da iko kuma. Ya kuma ci gaba da aikin alheri da warkarwa ga dukan wadanda shaidan ya daure, domin Allah yana tare da shi. ");
INSERT INTO hauulb_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Mu shaidu ne ga dukan abubuwan da ya yi a kasar Yahudawa da cikn Urushalima, wannan Yesu wanda suka kashe, ta wurin giciye shi a akan itace. ");
INSERT INTO hauulb_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Wannan mutumin, Allah ya ta da shi rana ta uku ya kuma maishe shi sananne, ");
INSERT INTO hauulb_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","ba ga dukan mutane ba, amma ga shaidun da Allah ya zaba tun da farko - mu kanmu, wadanda muka ci muka sha tare da shi bayan tashin sa daga matattu, ");
INSERT INTO hauulb_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ya umarce mu mu yi wa mutane wa'azi mu kuma tabbatar cewa shine wanda Allah ya zaba ya yi shariya bisa masu rai da matattu. ");
INSERT INTO hauulb_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Gareshi ne dukan annabawa suka yi shaida, domin dukan wanda ya bada gaskiya gareshi ya sami gafarar zunubai ta wurin sunansa.` ");
INSERT INTO hauulb_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Sa'adda Bitrus yana kan magana game da wadannan abubuwa, Ruhu Mai Tsarki ya sauko a kan dukan wadanda suke sauraron wa'azin sa. ");
INSERT INTO hauulb_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Mutanen da ke kungiyar masu bi da suka yarda da kaciya, dukan wadanda suka zo tare da Bitrus suka yi mamaki, domin baiwar Ruhu Mai Tsarki ya sauko a kan al'ummai. ");
INSERT INTO hauulb_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Domin sun ji al'umman nan suna magana da wasu harsuna suna yabon Allah. Sai Bitrus ya amsa, ");
INSERT INTO hauulb_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Ko akwai wanda zai hana wa wadannan baftisma ta ruwa, da shike suma sun karbi Ruhu Mai Tsarki kamar mu?” ");
INSERT INTO hauulb_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Sai ya ba da umarni a yi masu baftisma cikin sunan Yesu Kristi. Sai suka roke shi ya kasance da su na wasu kwanaki. ");
INSERT INTO hauulb_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Yanzu Manzani da 'yan'uwa wadanda suke cikin Yahudiya suka ji cewa al'ummai ma sun karbi maganar Allah ");
INSERT INTO hauulb_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Lokacin da Bitrus ya je Urushalima, wadanda suke na kaciya suka zarge shi; ");
INSERT INTO hauulb_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","suka ce, “Ka hada kai tare da mutane marasa kaciya kana ci tare da su!” ");
INSERT INTO hauulb_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Amma Bitrus ya fara bayyana masu dalla-dalla; ya ce, ");
INSERT INTO hauulb_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Ina addu'a a cikin birnin Yafa, sai na ga wahayi game da taska yana saukowa, kamar babban mayafi da aka saukar daga sama ta kusurwan nan hudu. Ya sauko gabana. ");
INSERT INTO hauulb_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Na zura masa ido kuma na yi tunani a kansa, na ga dabbobi masu kafa hudu na duniya, miyagun dabbobi, da masu rarrafe, da tsuntsayen sama. ");
INSERT INTO hauulb_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Sai na ji murya tana ce da ni, “Tashi, Bitrus, yanka ka ci.” ");
INSERT INTO hauulb_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Na ce, “Ba haka ba, Ubangiji: gama babu abu mara tsarki ko mai kazanta da ya taba shiga bakina.” ");
INSERT INTO hauulb_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Amma murya ta amsa kuma daga sama cewa, “Abin da Allah ya kira mai tsarki, kada ka kira shi mara tsarki.” ");
INSERT INTO hauulb_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Wannan ya faru sau uku, sai dukan komai ya koma sama. ");
INSERT INTO hauulb_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Nan da nan sai ga mutane uku tsaye a gaban gidan da muke; an aike su daga Kaisariya zuwa gare ni. ");
INSERT INTO hauulb_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ruhun ya umurce ni in tafi tare da su, ba tare da nuna banbanci game da su ba. Yan'uwan nan shida sun tafi tare da ni, sai muka shiga gidan mutumin. ");
INSERT INTO hauulb_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ya fada mana yadda ya ga mala'ika tsaye a cikin gidansa yana cewa “Aiki mutane zuwa Yafa, su kirawo Saminu wanda ake kira Bitrus. ");
INSERT INTO hauulb_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Zai gaya maku sakon da za ku sami ceto kai da dukan gidanka.” ");
INSERT INTO hauulb_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Da na fara magana da su, Ruhu Mai Tsarki ya sauko akansu kamar yadda ya sauko mana tun da farko. ");
INSERT INTO hauulb_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Sai na tuna da maganar Ubangiji, yadda ya ce,”Hakika Yahaya ya yi baptisma da ruwa, amma ku za a yi maku baptisma da Ruhu Mai Tsarki.” ");
INSERT INTO hauulb_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","To, idan Allah ya yi masu baiwa kamar yadda ya yi mana yayin da muka bada gaskiya ga Ubangiji Yesu Almasihu, wane ni da zan yi jayayya da Allah? ");
INSERT INTO hauulb_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Da suka ji wadannan abubuwa, suka rasa ta cewa, amma suka daukaka Allah suka ce “Ga al'ummai ma Allah ya basu tuba zuwa rai.” ");
INSERT INTO hauulb_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Sai wadanda suka warwatsu saboda tsananin da ya bi bayan mutuwan Istifanas, suka yadu har zuwa Finikiya, Kuburus da Antakiya, amma suka yi wa'azin Yesu ga Yahudawa kadai. ");
INSERT INTO hauulb_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Amma wadan sunsu, mutane daga Kuburus da Kurane, suka zo Antakiya suka yi magana da hellenawa, suna yi masu wa'azin Ubangiji Yesu. ");
INSERT INTO hauulb_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Kuma ikon Ubangiji yana tare da su, har mutane da yawa suka gaskata kuma suka juyo wurin Ubangiji. ");
INSERT INTO hauulb_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Labari game da su ya iso kunnen ikilisiya da ke Urushalima: sai suka aika da Barnaba zuwa can Antakiya. ");
INSERT INTO hauulb_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Da ya iso kuma ya ga kyautar Allah, sai ya yi farinciki; ya karfafa su dukka su kafu cikin Ubangiji da dukan zuciyar su. ");
INSERT INTO hauulb_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Domin shi mutumin kirki ne, cike kuma da Ruhu Mai Tsarki da bangaskiya, sai mutane da yawa suka karu ga Ubangiji. ");
INSERT INTO hauulb_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Sai Barnaba ya tafi Tarsus domin ya nemi Shawulu. ");
INSERT INTO hauulb_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Da ya same shi, ya kawo shi Antakiya. Ya kasance, shekara guda suna taruwa tare da ikilisiya suka koyar da mutane da yawa. A Antakiya ne aka fara kiran almajiran Krista. ");
INSERT INTO hauulb_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","A cikin kwanakin nan wadansu annabawa daga Urushalima suka zo Antakiya. ");
INSERT INTO hauulb_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Daya daga cikinsu, mai suna Agabas ya mike tsaye yayi magana da ikon Ruhu cewa za a yi tsanani fari ko'ina a duniya. Wannan ya faru ne a zamanin Kalaudiya. ");
INSERT INTO hauulb_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Sai, almajiran, suka dau niyya kowa gwargwadon karfinsa, su aika wa 'yan'uwa da ke Yahudiya da taimako. ");
INSERT INTO hauulb_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Suka yi haka; sun aika wa dattawa da kudi ta hanun Barnaba da Shawulu. ");
INSERT INTO hauulb_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","A lokacin nan Sarki Hiridus ya sa wa wasu masu bi hannu domin ya musguna masu. ");
INSERT INTO hauulb_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ya kashe Yakubu dan'uwan Yahaya da takobi. ");
INSERT INTO hauulb_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Bayan da ya ga hakan ya gamshi Yahudawa, sai ya kama Bitrus ma. ");
INSERT INTO hauulb_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Bayan ya kama shi, sai ya tsare shi a kurkuku ya kuwa sa sojoji hudu su dinga tsaron sa; yana niyyar kawo shi gaban mutanen a bayan Idin katarewa. ");
INSERT INTO hauulb_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","To, Bitrus na tsare a kurkuku, amma 'yan'uwa na iklisiya suna yin addu'a ga Allah sosai domin sa. ");
INSERT INTO hauulb_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ana kamar gobe Hiridus zai fitar da shi, a wannan daren, Bitrus yana barci a tsakanin sojoji biyu, daure da sarkoki biyu; sojoji kuma na gadi a bakin kurkukun. ");
INSERT INTO hauulb_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ba zato, sai ga mala'ikan Ubangiji ya bayyana a gareshi, haske ya haskaka dakin. Ya taba Bitrus a gefe ya tashe shi kuma ya ce, “Tashi da sauri.” Sai ga sarkokin suka zube daga hannunsa. ");
INSERT INTO hauulb_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Mala'ikan ya ce masa, “Yi damara ka sa takalmanka.” Bitrus kuwa yayi haka. Mala'ikan ce ma sa, “Yafa mayafinka, ka biyo ni.” ");
INSERT INTO hauulb_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Bitrus kuwa ya bi mala'ikan suka fita waje. Bai gane abin da mala'ikan ke yi zahiri ne ba. Yana zaton ko yana ganin wahayi ne. ");
INSERT INTO hauulb_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Bayan da suka wuce masu tsaron fari da na biyu, sun kai kofar da aka yi da karfe wadda ta mike zuwa cikin gari; ta bude masu da kanta. Suka fita sun bi titin, kuma nan take kuma sai mala'ikan ya bar shi. ");
INSERT INTO hauulb_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Da Bitrus ya komo hayyacin sa, ya ce, “Hakika yanzu na gane Ubangiji ya aiko da mala'ikansa don ya kubutar da ni daga hannun Hiridus da abin da Yahudawa suke zato.” ");
INSERT INTO hauulb_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Da ya gane haka, ya zo gidan Maryamu mahaifiyar Yahaya wanda sunan mahaifinsa Markus; masu bi da yawa sun taru a can suna addu'a. ");
INSERT INTO hauulb_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Da ya kwankwasa kofar gidan, sai baiwar gidan mai suna Roda ta zo don ta bude kofar. ");
INSERT INTO hauulb_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Da ta gane muryar Bitrus, don farin ciki ta kasa bude kofar; maimakon haka, ta koma daki a guje, don ta basu labari Bitrus na tsaye a bakin kofa. ");
INSERT INTO hauulb_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Suka ce mata, “Kin haukace.” Amma ta nace da cewa haka ne. Suka ce, “Mala'ikansa ne.” ");
INSERT INTO hauulb_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Amma Bitrus ya ci gaba da kwankwasawa, da suka bude kofar, sai suka ga ai shine, suka sha mamaki kwarai. ");
INSERT INTO hauulb_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Bitrus kuwa ya yi masu hannu yana, masu alama su yi shuru. Sai ya gaya masu labarin yadda Ubangiji ya kubutar da shi daga kurkukun. Ya ce, “Ku gaya wa Yakubu da dukan 'yan'uwa abin da ya faru.” Sai ya bar su, ya tafi wani wuri. ");
INSERT INTO hauulb_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Sa'anda gari ya waye ba karamar hargowa ce ta tashi a cikin sojojin ba, game da abin da ya faru da Bitrus. ");
INSERT INTO hauulb_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Bayan da Hiridus ya neme shi kuma bai same shi ba, sai ya tambayi masu tsaron kuma ya bada umarni a kashe su. Sai ya gangara daga Yahudiya zuwa Kaisariya ya yi zamansa a can. ");
INSERT INTO hauulb_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Yanzu kuwa Hiridus ya yi fushi sosai da mutanen Taya da Sidon. Suka tafi wurinsa tare. Suka roki Bilastasa, mataimakin sarkin, ya taimake su. Sai suka nemi sasantawa don suna samun abinci daga kasarsa ne. ");
INSERT INTO hauulb_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","A ranan da aka kayyade, Hirudus ya sha damara da kayan saurata kuma ya zauna akan kursiyi; ya yi masu jawabi. ");
INSERT INTO hauulb_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Mutanen suka yi ihu, “Wannan muryar allahce, ba ta mutum ba!” ");
INSERT INTO hauulb_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Nan take mala'ika Ubangiji ya buge shi don bai ba Allah daukaka ba, nan take tsutsotsi suka cinye shi har ya mutu. ");
INSERT INTO hauulb_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Maganar Allah ta yadu tana ta ribabbanya. ");
INSERT INTO hauulb_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Bayan Barnaba da Shawulu sun gama aikin su a Urushalima. Suna dawowa, suka zo tare da Yahaya wanda sunan mahaifinsa Markus ne. Barnaba da Shawulu suka koma Urushalima. ");
INSERT INTO hauulb_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","A cikin iklisiyar da take Antakiya, akwai annabawa da malamai. Sune su Barnabas, Saminu (wadda ake kira Baki) da Lukiya Bakurame da Manayin (wanda aka yi renon su tare da sarki Hiridus mai mulki) da Shawulu. ");
INSERT INTO hauulb_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Sa'adda suke bauta wa Allah tare da azumi, sai Ruhu Mai Tsarki ya ce, “Ku kebe mani Barnaba da Shawulu domin aikin da na kiraye su”. ");
INSERT INTO hauulb_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Bayan taron sun yi addu'a da azumi, sai suka sa masu hannu, su suka sallame su. ");
INSERT INTO hauulb_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Sai Shawulu da Barnabas suka yi biyayya da Ruhu Mai Tsarki suka tafi Sulukiya; daga nan suka ketare zuwa tsibirin Kuburus. ");
INSERT INTO hauulb_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Sa'adda suke garin Salami, suka koyar da maganar Ubangiji a majami'un Yahudawa, suna kuma tare da Yahaya Markus mai taimakonsu. ");
INSERT INTO hauulb_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Bayan sun zaga tsibirin duka har Bafusa, nan suka iske wani Bayahude mai suna Bar-yeshua mai tsafi kuma annabin karya. ");
INSERT INTO hauulb_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Wannan mai tsafin wanda ke tare da Makaddas, shi Sarjus Bulus mutum mai basira ne. Wannan kuwa ya kira Shawulu da Barnaba domin yana so ya ji maganar Allah. ");
INSERT INTO hauulb_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Amma Elimas “mai tsafi” (fasarar sunansa kenan) ya yi adawa da su; yana so ya baudar da Makaddashin daga bangaskiya. ");
INSERT INTO hauulb_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Amma Shawulu wanda ake ce da shi Bulus yana cike da Ruhu Mai Tsarki ya kafa masa ido. ");
INSERT INTO hauulb_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Sai ya ce, “Kai dan iblis, kana cike da kowace irin yaudara da mugunta. Kai abokin gabar kowanne irin adalci ne. Ba za ka daina karkata mikakkakun hanyoyin Ubangiji ba? ");
INSERT INTO hauulb_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Yanzu ga hannun Ubangiji bisa kanka, zaka zama makaho. Ba za ka ga rana ba nan da dan lokaci.” Nan take kuwa sai wani hazo da duhu suka rufe shi ya fara yawo yana neman mutane su yi masa jagora. ");
INSERT INTO hauulb_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Bayan da Makaddashin ya ga abin da ya faru ya ba da gaskiya saboda ya yi mamakin koyarwa game da Ubangiji. ");
INSERT INTO hauulb_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Bulus da abokansa suka shirya suka ketare a jirgin ruwa daga Bafusa zuwa Firjiya a Bamfiliya. Amma Yahaya ya bar su ya koma Urushalima. ");
INSERT INTO hauulb_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Bulus da abokansa suka tafi daga Firjiya zuwa Antakiya na kasar Bisidiya. Nan suka shiga majami'a ran Asabaci suka zauna. ");
INSERT INTO hauulb_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Bayan karatun dokoki da annabawa, shugabanin iklisiyar suka tura sako cewa, “'Yan'uwa, idan kuna da wani sakon karfafawa ga jama'a ku fadi.” ");
INSERT INTO hauulb_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Bulus kuwa ya tashi ya yi alama da hannunsa ya ce, “Mutanen Isra'ila da ku wadanda kuke girmama Allah, ku ji. ");
INSERT INTO hauulb_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Allahn Isar'ila ya zabi kakkaninmu ya kuma ribabbanya su sa'adda suke kasar Masar da kuma madaukakin iko ya fito da su daga cikinta. ");
INSERT INTO hauulb_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ya yi hakuri da su a jeji har na tsawon shekara arba'in. ");
INSERT INTO hauulb_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Bayan ya hallaka kasashe bakwai a kasar Kan'ana, ya ba kakkaninmu kasar nan gado. ");
INSERT INTO hauulb_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Duk wadanan abubuwan sun faru shekaru dari hudu da hamsin da suka wuce. Bayan wadannan, Allah ya ba su alkalai har sai da annabi Sama'ila ya zo. ");
INSERT INTO hauulb_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Sai jama'a suka roka a ba su sarki, Allah kuwa ya ba su Saul dan Kish, mutumin kabilar Binyamin ya zama sarki har na tsawon shekara arba'in. ");
INSERT INTO hauulb_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Allah kuwa ya cire shi daga kan kujerar sarauta, ya daga Dauda ya zama sarkinsu. A kan Dauda ne Allah ya ce, 'Na sami Dauda dan Yessi, mutumin da zuciyata ke so; zai yi duk abin da nake so'. ");
INSERT INTO hauulb_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Daga zuriyar mutumin nan Allah ya fito da mai ceto, Yesu, kamar yadda aka alkawarta zai yi. ");
INSERT INTO hauulb_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Wannan ya faru kafin Yesu ya zo, Yahaya ya yi shelar baftimar tuba ga jamma'ar Isra'ila. ");
INSERT INTO hauulb_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Sa'adda Yahaya ya gama aikin sa, sai ya ce, 'Wanene ni a tsamanin ku? Ba nine shi ba. Amma ku saurara, akwai wani mai zuwa bayana wanda maballin takalminsa ban isa in kwance ba.' ");
INSERT INTO hauulb_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Yan'uwa 'ya'ya daga zuriyar Ibrahim, da wadanda ke bautar Allah a cikinku, saboda mune aka turo sakon ceto. ");
INSERT INTO hauulb_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Saboda wadanda ke zaune cikin Urushalima, da masu mulkinsu, ba su gane shi ba, kuma sun cika fadin annabawa da a ke karantawa kowace ranar Asabaci ta wurin kashe shi. ");
INSERT INTO hauulb_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Duk da cewa ba su sami dalilin mutuwa a kansa ba, suka roki Bilatus ya kashe shi. ");
INSERT INTO hauulb_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Bayan sun gama duk abin da aka rubuta game da shi, sai suka sauke shi daga giciye suka sa shi a cikin kabari. ");
INSERT INTO hauulb_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Amma Allah ya tashe shi daga matattu. ");
INSERT INTO hauulb_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Mutanen da suka zo tare da shi daga Galili da Urushalima kuwa suka yi ta ganinsa har kwanaki da yawa. Wadanan mutane kuma sune shaidunsa ga jama'a a yanzu. ");
INSERT INTO hauulb_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Mun kawo maku labari mai dadi game da alkawaran da aka yi wa kakkaninmu. ");
INSERT INTO hauulb_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Ubangiji ya bar mana alkawaran. Don haka ya ta da Yesu daga matattu. Kamar yadda ya ke a littafin zabura ta biyu: ''Kai da na ne yau na zama mahaifinka.'' ");
INSERT INTO hauulb_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Kuma dalilin tayar da shi daga matattu shine saboda kada jikinsa ya rube, ya yi magana kamar haka: ''Zan baku albarkun Dauda masu tsarki tabatattu.'' ");
INSERT INTO hauulb_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Wannan shine dalilin da ya yi magana kuma a wata Zabura, 'Ba za ka bar Mai Tsarkinka ya rube ba.' ");
INSERT INTO hauulb_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Bayan Dawuda ya yi wa Allah bauta a cikin zuciyarsa da kuma abin da Allah yake so, ya mutu, aka binne shi tare da kakkaninsa, ya kuma ruba, ");
INSERT INTO hauulb_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","amma wanda Allah ya tayar bai ga ruba ba. ");
INSERT INTO hauulb_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","'Yan'uwa, ku sani cewa ta wurin mutumin nan aka yi maku wa'azin gafarar zunubai. ");
INSERT INTO hauulb_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Ta wurinsa ne duk wanda ya ba da gaskiya zai kubuta daga dukan abin da dokar Musa bata 'yantar da ku a kai ba. ");
INSERT INTO hauulb_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Saboda haka ku yi hankali da abubuwan da annabawa suka fada kada su faru a kanku: ");
INSERT INTO hauulb_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","'Ku masu reni, za ku rude don mamaki, ku kuma shude; saboda ina aiki a cikin kwananakinku, aikin da ba za ku yarda ba ko da wani ya gaya maku.” ");
INSERT INTO hauulb_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Da Bulus da Barnaba suna fita kenan, sai jama'a suka rokesu, su sake yin irin wannan magana ranar Assabaci mai zuwa. ");
INSERT INTO hauulb_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Bayan da sujadar ta kare, Yahudawa da yawa da kuma wadanda suka shiga addinin Yahudanci suka bi Bulus da Barnaba, sai suka gargade su da su cigaba da aikin alherin Allah. ");
INSERT INTO hauulb_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Da Asabaci ta kewayo, kusan dukan garin suka taru domin su ji maganar Ubangiji. ");
INSERT INTO hauulb_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Sa'adda Yahudawa suka ga taron jama'a, sai suka cika da kishi suna karyata abubuwan da Bulus ya fada suka kuma aibata shi. ");
INSERT INTO hauulb_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Amma Bulus da Barnaba sun yi magana gabagadi suka ce, “Dole ne a fara fada maku maganar Allah. Amma da yake kun ture ta, kun nuna baku cancanci rai madawwami ba soboda haka zamu juya ga al'ummai. ");
INSERT INTO hauulb_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Don haka Ubangiji ya umarce mu, cewa, 'Na sa ku haske ga al'ummai, saboda ku kawo ceto ga iyakar duniya.'” ");
INSERT INTO hauulb_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Da al'ummai suka ji haka, sai suka yi murna suka kuma yabi kalmar Ubangiji. Dukan wadanda aka kaddarawa samin rai madawwami suka tuba. ");
INSERT INTO hauulb_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Kalmar Ubangiji kuwa ta bazu a kowanne bangaren yankin. ");
INSERT INTO hauulb_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Amma Yahudawan suka zuga wadansu mata masu sujada, masu daraja da kuma shugabannin mazan garin. Wannan ya tayar da tsanani ga Bulus da Barnaba har suka fitar da su daga iyakar garinsu. ");
INSERT INTO hauulb_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Amma Bulus da Barnaba suka kade masu kurar kafarsu. Suka tafi garin Ikoniya. ");
INSERT INTO hauulb_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Amma almajiran suka cika da farin ciki da kuma Ruhu Mai Tsarki. ");
INSERT INTO hauulb_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","A lokacin da Bulus da Barnaba sun shiga garin Ikoniya suka shiga majami'an Yahudawa suka yi wa'azi yadda har mutane da yawa daga cikin Yahudawa da Hellinawa suka ba da gaskiya. ");
INSERT INTO hauulb_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Amma Yahudawa da basu yi biyayya ba, suka zuga al'umman har suka yi fushi da 'yan'uwan. ");
INSERT INTO hauulb_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Suka zauna a wurin na tsawon lokaci, suna yni maganarsu gabagadi da ikon Ubangiji, yana kuma shaidar sakon alherinsa. Ya yi wannan ta wurin alamu da al'ajibai ta hannun Bulus da Barnaba. ");
INSERT INTO hauulb_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Saboda haka mutanen garin sun rabu: wadansun su suka bi ra'ayin Yahudawa, wasu kuwa sun bi manzannin. ");
INSERT INTO hauulb_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Al'umman garin da Yahudawa sun nemi jan hankali shugabanninsu, don su wulakanta Bulus da Barnaba, su jajjefe su, ");
INSERT INTO hauulb_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","da suka gane haka suka gudu zuwa biranen Likoniya, Listira da Darbe, da garuruwa wadanda ke kewaye da su, ");
INSERT INTO hauulb_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","a can suka yi wa'azin bishara. ");
INSERT INTO hauulb_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","A Listira akwai wani wanda ke zaune bai taba tashi da kafafunsa ba, don shi gurgu ne tun daga haihuwa. ");
INSERT INTO hauulb_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Wannan mutumin ya ji Bulus yana magana. Bulus ya kafa masa ido, ya gane mutumin na da bangaskiya da za a warkar da shi. Sai ya ce masa da murya mai karfi, “Tashi ka tsaya akan kafafunka” ");
INSERT INTO hauulb_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Sai mutumin ya yi tsalle ya fara tafiya da kafafunsa, yana yawo. ");
INSERT INTO hauulb_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Da jama'an garin sun ga abin da Bulus ya yi, suka tada muryarsu suna cewa da Likoniyanci, “Ai alloli sun ziyarce mu daga sama, da kamanin mutane.” ");
INSERT INTO hauulb_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Suna kiran Barnaba da sunan “Zafsa,” Bulus kuwa suka kira shi da sunan “Hamisa” domin shine yafi yin magana. ");
INSERT INTO hauulb_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Sai firist din zafsa wanda dakin yin masa sujada na kofar birni; ya kawo bijimai biyu da furannin da aka saka su kamar gammo; shi da jama'arsa suna so su yi masa hadaya. ");
INSERT INTO hauulb_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Amma da manzannin, wato Barnaba da Bulus, su ka ji labarin, suka yage rigunansu, suka hanzarta zuwa gun taron mutanen. ");
INSERT INTO hauulb_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","Suna ta cewa, “Kuji! Ku mutane don me kuke wannan abin? Mu fa mutane ne kamarku. Mun kawo maku labari mai dadi ne, da cewa, ku rabu da abubuwa marar amfani, ku koma ga Allah mai rai, wanda ya hallici sama da kasa da teku da dukan abubuwa da ke cikinsu. ");
INSERT INTO hauulb_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","A da dai ya bar mutane su yi abinda suka ga dama. ");
INSERT INTO hauulb_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Duk da haka, bai bar kansa ba tare da shaida ba, don yana bada abubuwa masu kyau, yana ba ku ruwan sama, lokatai masu albarka, ya cika ranku da abinci da farin ciki.” ");
INSERT INTO hauulb_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Duk da wadannan kalmomin da kyar, Bulus da Barnaba suka iya tsayar da su daga yi masu hadaya. ");
INSERT INTO hauulb_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Amma wasu Yahudawa daga Antakiya da wasunsu daga Ikoniya suka rinjayi tarun jama'ar. Suka jajjefi Bulus suka ja shi zuwa wajen garin, suna ganin kamar ya mutu. ");
INSERT INTO hauulb_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Duk da haka da almajirai suka kewaye shi a tsaitsaye, sai ya tashi ya koma cikin garin. Washegari, ya tafi Darba tare Barnaba. ");
INSERT INTO hauulb_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Bayan sun yi wa'azin bishara a wannan birnin suka kuma sami almajirai da yawa, suka dawo Listira, da Ikoniya da Antikiya. ");
INSERT INTO hauulb_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Suna karfafa zuciyar almajiran su rike bangaskiyarsu, su ci gaba da ita, suna ce masu, “Ta wurin jimrewa mai yawa zamu shiga mulkin Allah, don haka dole ne mu sha wahala.” ");
INSERT INTO hauulb_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Da suka zabar masu dattawa a kowace iklisiya, sai suka yi addu'oi da azumi, suka mika su ga Ubangiji, ga wanda suka gaskanta a gareshi. ");
INSERT INTO hauulb_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Sa'annan sun bi ta Bisidiya suka kai Bamfiliya. ");
INSERT INTO hauulb_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Da suka yi maganarsu a Biriya, sun wuce zuwa har Italiya. ");
INSERT INTO hauulb_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ta jirgin ruwa zuwa Antakiya, a nan ne aka mika su ga alherin Allah don aikin da suka gama a yanzu. ");
INSERT INTO hauulb_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Da isowarsu Antakiya sun tara 'yan iklisiya a wuri daya, sun ba da labarin dukan abin da Allah ya yi ta wurinsu. Da yadda Ya bude kofa a wurin al'ummai ta bangaskiya. ");
INSERT INTO hauulb_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Sun zauna tare da almajiran na tsawon lokaci. ");
INSERT INTO hauulb_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Wadansu mutane suka zo daga Yahudiya suka koyar da 'yan'uwa, cewa, “Idan ba yi maku kaciya bisa ga al'addar Musa ba, ba za ku sami ceto ba.” ");
INSERT INTO hauulb_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Da Bulus da Barnaba suka tunkare su da mahawara, sai 'yan'uwa suka yanke shawara Bulus da Barnaba da wasu su je Urushalima wurin manzanni da dattawa a kan wannan magana. ");
INSERT INTO hauulb_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Da shike iklisiya ce ta aike su, sai suka bi ta Finikiya da ta Samariya suka sanar da tuban al'ummai. Ya kawo murna mai yawa a wurin 'yan'uwa. ");
INSERT INTO hauulb_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Bayan sun zo Urushalima, sai iklisiya da manzanni da dattawa, suka marabce su, sai suka fada masu abin da Allah ya yi ta wurinsu. ");
INSERT INTO hauulb_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Amma wadansu mutane wadanda suka ba da gaskiya daga cikin Farisawa, suka tashi suka ce, “Dole ne a yi masu kaciya a kuma umarce su su kiyaye dokar Musa.” ");
INSERT INTO hauulb_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Sai manzanin da dattawan suka taru don su duba wannan lamari. ");
INSERT INTO hauulb_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Bayan mahawara mai tsanani, sai Bitrus ya tashi ya ce masu, “'Yan'uwa, kun san lokacin baya da ya wuce, Allah ya yi zabi a cikinku, cewa ta bakina ne al'ummai za su ji bishara, su kuma ba da gaskiya. ");
INSERT INTO hauulb_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Allah, wanda ya san zuciya, ya yi masu shaida, ya kuma basu Ruhu Mai Tsarki kamar yadda ya yi mana; ");
INSERT INTO hauulb_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","kuma bai bambanta mu da su ba, ya tsabtace zuciyarsu ta wurin bangaskiya. ");
INSERT INTO hauulb_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","To, saboda haka don me kuke gwada Allah, kuna sa wa almajirai nauyi a wuya wanda ubanninmu duk da mu ba mu iya dauka ba? ");
INSERT INTO hauulb_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Amma mun gaskanta za mu samu ceto ta wurin alherin Ubangiji Yesu, kamar yadda suke.” ");
INSERT INTO hauulb_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Dukan taron jama'ar suka yi shiru sa'adda suke sauraron sakon shaidar da mamakin abin da Allah ya yi ta wurin Bulus da Barnaba a cikin al'ummai. ");
INSERT INTO hauulb_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Bayan sun gama magana, Yakubu ya amsa, ya ce, “'Yan'uwa, ku ji ni. ");
INSERT INTO hauulb_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Saminu ya fada yadda Allah ya fara nuna jinkai ga al'ummai domin ya dauke jama'a daga cikinsu domin sunansa. ");
INSERT INTO hauulb_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Maganar annabawa ta yarda da wannan, kamar yadda yake a rubuce, ");
INSERT INTO hauulb_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","'Bayan wadannan abubuwa zan dawo, zan gina gidan Dauda wanda ya fadi kasa; in sake gina bangonsa, in tsayar da shi, ");
INSERT INTO hauulb_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","saboda sauran jama'a su nemi fuskar Ubangiji, har da al'ummai da ake kira da sunana. ");
INSERT INTO hauulb_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Wannan shine abin da Ubangiji ya fadi, shi wanda ya yi wadannan abubuwa da aka sani tun zamanin da. ");
INSERT INTO hauulb_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Saboda haka, a gani na kada mu matsa wa al'umman da suka juyo gun Allah; ");
INSERT INTO hauulb_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","amma zamu rubuta masu da cewa, su guje wa gumaka da zina da faskanci da maye da cin mushe. ");
INSERT INTO hauulb_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Tun zamanin da akwai mutane a kowanne birni wadanda suke wa'azi da karatun Musa a majami'u kowanne Asabaci.” ");
INSERT INTO hauulb_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Sai ya yi wa manzanin kyau su da dattawa da dukan iklisiyar su zabi Yahuza da Barnaba da Sila da dattawan iklisiya a tura su Antakiya tare da Bulus da Barnaba. ");
INSERT INTO hauulb_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Sai suka rubuta wasika, “Manzani da dattawa da 'yan'uwa zuwa ga al'ummai 'yan'uwa a Antakiya da Suriya da Kilikiya, gaisuwa mai yawa. ");
INSERT INTO hauulb_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Mun ji cewa wasu mutane daga cikinmu wadanda ba mu umarce su ba, sun fita daga cikinmu sun yi maku koyarwar da ta daga maku hankali. ");
INSERT INTO hauulb_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Ya yi kyau da dukanmu, muka amince mu zabi wadansu mutane mu tura su wurinku tare da Bulus da Barnaba, ");
INSERT INTO hauulb_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","mutane wadanda suka sadaukar da ransu domin sunan Ubangiji Yesu Almasihu. ");
INSERT INTO hauulb_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Mun aika Yahuza da Sila su gaya maku wadannan abubuwa. ");
INSERT INTO hauulb_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Saboda haka ya yi kyau Ruhu Mai Tsarki da mu, kada mu sa maku nauyi fiye da wadannan abubuwan: ");
INSERT INTO hauulb_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","ku bar yi wa gumaka hadaya, ku bar cin mushe da shan kayan maye da zina da faskanci, in kun kiyaye wadannan abubuwa za ku zauna lafiya. Ku huta lafiya.” ");
INSERT INTO hauulb_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Da aka sallame su, sai suka je Antakiya. Bayan sun tara jama'a sai suka ba su wasikar. ");
INSERT INTO hauulb_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Bayan da suka karanta ta, sai suka yi murna sosai saboda karfafawa. ");
INSERT INTO hauulb_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yahuza da Sila, da shike su annabawa ne, suka karfafa 'yan'uwa da kalmomi masu yawa. ");
INSERT INTO hauulb_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Bayan sun yi kwananki a wurin, sai aka sallame su zuwa wurin 'yan'uwa wadanda suka aiko su. ");
INSERT INTO hauulb_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Amma ya gamshe Sila ya zauna a wurin. ");
INSERT INTO hauulb_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Amma Bulus da Barnaba suka tsaya a Antakiya da sauran 'yan'uwa, suna koyar da maganar Ubangiji. ");
INSERT INTO hauulb_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Bayan kwanaki kadan Bulus ya ce ma Barnaba, “Mu koma yanzu mu ziyarci dukan 'yan'uwa da muka yi masu bisharar Ubangiji, mu ga yadda suke. ");
INSERT INTO hauulb_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnaba yana so su dauki Yahaya wanda kuma ake kira Markus. ");
INSERT INTO hauulb_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Amma Bulus ya yi tunanin bai kamata a tafi da Markus ba, tun da ya bar su a Bamfiliya bai ci gaba da su ba. ");
INSERT INTO hauulb_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Nan jayayya ta tashi tsakaninsu, har suka rabu da juna sai Barnaba ya tafi tare da Markus suka ketare zuwa Kuburus. ");
INSERT INTO hauulb_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Amma Bulus ya zabi Sila suka tafi, bayan 'yan'uwa sun yi masu addu'ar alherin Allah ya kiyaye su. ");
INSERT INTO hauulb_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Bulus ya tafi ya zazzaga Suriya da Kilikiya yana ta karfafa iklisiyoyin. ");
INSERT INTO hauulb_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Bulus ya kuma isa Darbe da Listira, in da akwai wani almajiri mai suna Timoti a wurin, dan wata Bayahudiya wadda ta ba da gaskiya; ubansa kuwa Baheline ne. ");
INSERT INTO hauulb_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Ana maganar kirki a kansa ta bakin 'yan'uwa da ke Listira da Ikoniyan. ");
INSERT INTO hauulb_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Bulus ya yi wa Timoti kaciya, domin yana so su yi tafiya tare, domin kuma saboda Yahudawan da ke wurin, sun san cewa ubansa Baheline ne. ");
INSERT INTO hauulb_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Suna shiga cikin biranen, suna yi wa iklisiyoyi gargadi da su yi biyayya da umurnan da Manzanni da dattawa suka rubuta a Urushalima. ");
INSERT INTO hauulb_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Bangaskiyar iklisiyoyi kuwa ta karu, ana kuma samun karuwa na wadanda suke ba da gaskiya kowace rana. ");
INSERT INTO hauulb_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Bulus da abokan aikin sa sun shiga cikin lardin Firigiya da Galatiya, tun da Ruhu Mai Tsarki ya hana su wa'azin kalmar a cikin yankin Asiya. ");
INSERT INTO hauulb_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Sun zo kusa da Misiya, da nufin shiga cikin Bitiniya, Ruhun Yesu ya hana su. ");
INSERT INTO hauulb_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Da suka ratse ta cikin Misiya, sai suka shiga birnin Taruwasa. ");
INSERT INTO hauulb_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Bulus ya ga wahayi cikin dare, wani mutumin Makidoniya na kiransa, yana cewa. ''Ka zo Makidoniya ka taimake mu''. ");
INSERT INTO hauulb_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Bulus, da ganin haka, ya kama hanya zuwa Makidoniya, da tunanin Allah ne ya ke so su kai wa mutanen Makidoniya bishara. ");
INSERT INTO hauulb_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Da barin Taruwasa, Bulus da kungiyarsa sun shiga jirgin ruwa zuwa Samutaraki, da gari ya waye kuma sun tafi Niyafolis; ");
INSERT INTO hauulb_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Daga nan kuma suka tafi Filibi, birni na Makidoniya, mai muhimmanci ne a yankin Roma, in da mun yi zango kwanaki da dama. ");
INSERT INTO hauulb_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Ranar Asabaci mun je kofar gari, gefen rafi, da tunanin samun wurin addu'a. Mun zauna mun kuma yi magana da matan da sun taru a wurin. ");
INSERT INTO hauulb_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Wata mace mai suna Lidiya, 'yar kasuwa ce a birnin Tiyatira, mai bautar Allah ce, ta saurare mu. Ubangiji ya bude zuciyarta, ta mai da hankali ga maganar da Bulus ke fadi. ");
INSERT INTO hauulb_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Sa'anda da aka yi mata Baftisma tare da mutanen gidanta, ta ce da mu, “Idan kun dauke ni mai bautar Allah, ku zo gidana ku zauna.” Sai ta rinjaye mu. ");
INSERT INTO hauulb_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","A daidai wannan lokaci, muna tafiya wurin addu'a, wata yarinya mai ruhun duba ta hadu da mu. Iyayen gijinta na arziki da ita sosai. ");
INSERT INTO hauulb_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Tana bin Bulus, tare da mu, tana fadi da murya mai karfi cewa, ''Wadannan mutanen, bayin Allah mafi daukaka ne, suna sanar maku hanyar ceto ne''. ");
INSERT INTO hauulb_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ta dauki kwanaki tana haka. Amma Bulus ya yi fushi da ita ainun, ya juya ya umarci ruhun, ya ce, ''Na umarce ka, ka rabu da ita a cikin sunan Yesu Almasihu''. Ruhun ya yi biyayya ya rabu da ita nan take. ");
INSERT INTO hauulb_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Da iyayengijinta suka ga cewa hanyar shigar kudinsu ta toshe, sai suka kama Bulus da Sila, suka ja su cikin kasuwa suka kai su gaban mahunkunta. ");
INSERT INTO hauulb_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Da suka kai su Kotu, suka ce, ''Wadannan mutane Yahudawa ne, suna kawo tashin hankali a birninmu. ");
INSERT INTO hauulb_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Suna koyar da abubuwa da ba su karbuwa a gare mu, balle mu aikata, a matsayinmu na Romawa.” ");
INSERT INTO hauulb_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Sai jama'a gaba daya sun tayar wa Bulus da Sila; alkalan kuma sun yage rigunansu, sun ba da umarni a duki Bulus da Sila da bulala. ");
INSERT INTO hauulb_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Bayan dukan, an jefa su Bulus a kurkuku, an ba mai tsaron kurkukun umurni ya kulle su da kyau, kada su gudu. ");
INSERT INTO hauulb_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Shi kuma ya yi hakanan, ya sa masu sarkoki a kafafun su, kamar yadda aka umurce shi. ");
INSERT INTO hauulb_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Da tsakar dare, Bulus da Sila suna yin adu'a, su na raira wakoki ga Allah, sauran 'yan sarkar su na jin su. ");
INSERT INTO hauulb_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Nan da nan sai ga wata girgizar kasa, wadda ta sa ginshikan kurkukun sun kadu, nan da nan kofofin kurkukun sun bude, 'yan sarka kuma, sarkokin su sun karkatse. ");
INSERT INTO hauulb_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Mai tsaron kurkukun ya tashi daga barci ya ga kofofin kurkukun a bude, ya zaro takobi, zai kashe kan sa, a tunanin sa, 'yan sarkar sun gudu. ");
INSERT INTO hauulb_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Amma Bulus ya ta da murya da karfi, ya ce, ''kada kayi wa kanka barna, domin dukan mu muna nan''. ");
INSERT INTO hauulb_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Mai tsaron kurkukun ya aika a kawo fitila, ya shiga ciki a gurguje da rawan jiki, ya fadi a gaban Bulus da Sila, ");
INSERT INTO hauulb_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","ya fitar da su waje ya ce, ''Shugabanni, me ya kamata in yi domin in tsira?'' ");
INSERT INTO hauulb_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Sun ce masa, ''ka ba da gaskiya ga Yesu Ubangiji, da kai da gidan ka, za ku sami tsira''. ");
INSERT INTO hauulb_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Bulus da Sila suka fada masa maganar Ubangiji, tare da iyalinsa. ");
INSERT INTO hauulb_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Shi mai tsaron kurkukun ya dauke su cikin daren, ya wanke raunukansu, an kuma yi masa Baftisma nan da nan tare da iyalinsa. ");
INSERT INTO hauulb_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Ya kai Bulus da Sila gidansa, ya ba su abinci. Murna ta cika gidan mai tsaron kurkukun, domin iyalin sa duka sun ba da gaskiya ga Allah. ");
INSERT INTO hauulb_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Da gari ya waye, alkalai sun ba da sako a saki Bulus da Sila. ");
INSERT INTO hauulb_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Mai tsaron kurkukun kuwa ya sanar wa Bulus wannan magana ta alkalan, saboda haka ya ce wa Bulus, ''Ku tafi cikin salama''. ");
INSERT INTO hauulb_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Amma Bulus ya ce masu, “Sun yi mana duka a fili a gaban mutane mu da muke Romawa, ba a kashe mu ba, sun kuma sa mu a kurkuku; suna koran mu a asirce? Su zo da kansu su fitar da mu. ");
INSERT INTO hauulb_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Masu tsaron kurkuku sun mayar da maganar Bulus ga alkalan, wanda ya sa sun firgita, da jin cewa Bulus da Sila Romawa ne. ");
INSERT INTO hauulb_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Alkalai da kansu sun zo sun roki Bulus da Sila; da suka fitar da su daga kurkukun, sun ce wa Bulus da Sila su bar birnin. ");
INSERT INTO hauulb_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Da hakanan ne Bulus da Sila suka fita daga kurkuku, sun je gidan Lidiya. Da Bulus da Sila sun ga 'yan'uwa, sun karfafa su, sa'annan suka bar birnin. ");
INSERT INTO hauulb_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Bayan sun wuce biranen Amfibolis da Aboloniya, sun iso birnin Tasalunika, in da akwai wata majami'ar Yahudawa a wurin. ");
INSERT INTO hauulb_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Bulus, kamar yadda ya saba, ya nufi wurinsu, yana tattaunawa da su har Asabaci uku, daga cikin littattafai. ");
INSERT INTO hauulb_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Bulus ya bude littattafai yana bayyana masu cewa, dole ne Almasihu ya sha wahala, ya kuma tashi daga matattu. Ya ce, ''Wannan Yesu kuwa da nake sanar maku, shine Almasihu''. ");
INSERT INTO hauulb_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Wasu Yahudawa sun yarda, sun bi Bulus da Sila, da wadansu Helenawa, da Shugabannin Mata da jama'a da yawa. ");
INSERT INTO hauulb_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Yahudawan da basu ba da gaskiya ba suka cika da kishi, suka dauki wadansu 'yan ta'adda daga cikin kasuwa, suka tada tarzoma cikin birnin, mutane da yawa na bin su. Sun kai hari a gidan Yason, da niyyar fitar da Bulus da Sila a gaban jama'a. ");
INSERT INTO hauulb_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Amma da ba su ga Bulus da Sila ba, suka ja Yason da wasu 'yan'uwa masu bi zuwa gaban mahukuntar birnin, suna cewa, ''Wadannan ne fa masu ta da zaune tsaye, gashi sun zo mana. ");
INSERT INTO hauulb_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Wadannan mutane da Yason ya marabta, sun saba wa dokokin Kaisar; Suna cewa akwai wani sarki mai suna - Yesu.'' ");
INSERT INTO hauulb_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Da taron jama'a, da mahukuntan birnin suka ji haka, sun damu. ");
INSERT INTO hauulb_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Bayan da sun amshi kudi daga wurin Yason da sauran 'yan'uwan, sai suka sake su. ");
INSERT INTO hauulb_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","A wannan daren, 'yan'uwa masu bi suka fitar da Bulus da Sila, suka aike su garin Biriya. Da isar su can, su ka nufa majami'ar Yahudawa. ");
INSERT INTO hauulb_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Mutanen Biriya daban suke da na Tasalunika, sun yarda da sakon Bulus da zuciya daya, suna kuma binciken littattafai kowace rana domin su tabbatar da sakon Bulus, ko gaskiya ne. ");
INSERT INTO hauulb_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Saboda haka mutane da yawa cikin su sun ba da gaskiya, tare da wadansu sannanun mata Helenawa da maza da yawa. ");
INSERT INTO hauulb_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Amma da Yahudawan Tasalunika suka ji cewa Bulus yana wa'azin kalmar Allah a Biriya, sun haura can, sun tada hankulan jama'a. ");
INSERT INTO hauulb_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Nan da nan, masu bi na Biriya sun dauki Bulus sun aika shi zuwa teku, an bar Sila da Timoti a Biriya tukuna. ");
INSERT INTO hauulb_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Wadanda sun fitar da Bulus, sun kai shi har zuwa birnin Atina. Bulus ya ba su sako, su fada wa Sila da Timoti suyi hanzari su same shi. ");
INSERT INTO hauulb_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Sa'anda Bulus yana jiran zuwan Sila da Timoti a Atina, ya yi fushi a ransa, da ya ga birnin cike da gumakai. ");
INSERT INTO hauulb_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Ya tattauna da Yahudawa a cikin majami'a tare da masu yin sujada ga Allah, da kuma wadanda yake samu a kowace rana, a kasuwa. ");
INSERT INTO hauulb_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Amma wadan su Abikuriyawa da masana sun yi karo da shi. Wadansun su na cewa, ''Menene wannan sakaren ke cewa?'' Wadansu kuma sun ce, ''Da alama mai wa'azi ne na wasu alloli dabam,'' domin yana wa'azin Yesu da tashin sa daga matattu. ");
INSERT INTO hauulb_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Suka dauki Bulus zuwa Tudun Arasa, suna cewa, ''Ko za ka sanar mana da wannan sabuwar koyaswar taka? ");
INSERT INTO hauulb_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Abubbuwan da kake fadi, baki ne a gare mu. Muna so mu san ma'anar su.'' ");
INSERT INTO hauulb_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Atiniyawa da bakin da ke cikinsu, suna ba da lokacin su ga fadin sabobbin abubuwa da sauraron su). ");
INSERT INTO hauulb_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Bulus ya tsaya a tsakiyar Tudun Arasa ya ce, ''Ku mutanen Atiniya na lura masu kwazon addini ne ku. ");
INSERT INTO hauulb_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Na lura da abubuwan sujadar ku yayin da nake zagawa, amma na ga wani bagadi da rubutu a kansa mai cewa, ''Ga Allah wanda ba a sani ba.” Abin da kuke bauta wa cikin rashin sani, shi nake sanar maku. ");
INSERT INTO hauulb_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Allahn da ya yi duniya da kome da ke cikinta, tun da ya ke shine Ubangijin sama da kasa, ba ya zama a haikalin da mutane suka gina da hannu. ");
INSERT INTO hauulb_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Ba ya neman taimakon kowa, babu kuma wanda ya isa ya ba shi. Shine ke ba da rai, da numfashi da kowanne abu. ");
INSERT INTO hauulb_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Daga mutum daya ya hallici dukan al'umman duniya, ya rarraba, ya kuma sanya kowa a inda ya shirya masa. ");
INSERT INTO hauulb_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Domin su nemi Allah ko za su iya kaiwa zuwa gareshi su same shi, ga shi kuwa ba ya nesa da kowannenmu. ");
INSERT INTO hauulb_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","A cikinsa muke rayuwa, muna walwala, kamar yadda wani daga cikin masananku yace, 'Mu 'ya'yansa ne'. ");
INSERT INTO hauulb_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Idan mu 'ya'yan Allah ne, bai kamata mu danganta Allah da zinariya ko azurfa, ko kuma duwatsu da itatuwa da an sassaka ba. ");
INSERT INTO hauulb_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Saboda haka ne, Allah ya kawar da kwanakin jahilci, amma ya ba da umarni kowa a ko'ina ya tuba. ");
INSERT INTO hauulb_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Akwai ranar da ya shirya zai yi wa duniya shari'a cikin adalci, ta wurin mutumin da ya zaba. Allah ya nuna wannan mutumin, ta wurin ta da shi daga matattu''. ");
INSERT INTO hauulb_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Da mutanen Atina sun ji batun tashi daga matattu, wadansu suka yi wa Bulus ba'a; amma wadansu kuma sun ce, ''Za mu saurare ka kuma, a kan wannan maganar.'' ");
INSERT INTO hauulb_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Bayan haka, Bulus ya bar su. ");
INSERT INTO hauulb_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Amma wasu maza a cikinsu sun yarda da bisharar, sun ba da gaskiya, hade da Diyonisiyus dan Majalisar Tudun Arasa da wata mace mai suna Damaris, da wadansu tare da su. ");
INSERT INTO hauulb_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Bayan haka sai Bulus ya tafi Antakiya daga nan, ya wuce Korinti. ");
INSERT INTO hauulb_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","A can ya sadu da wani Bayahude mai sunan Akila, dan kasar Buntus ne; bai dade da zuwa garin ba, daga Italiya ya zo da matarsa mai suna Balkisu, saboda Kalaudiyas ya ba da umarni dukan Yahudawa su bar Roma; sai Bulus ya je wurinsu. ");
INSERT INTO hauulb_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Bulus ya zauna a gidansu don sana'arsu daya ce, wato, masu aikin Tanti ne. ");
INSERT INTO hauulb_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Saboda haka Bulus na zuwa majami'a, yana yin nazari tare da su a kowace Asabaci. Yana kokari ya rinjayi Yahudawa da Helinawa. ");
INSERT INTO hauulb_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Amma a lokacin da Sila da Timoti suka iso Makidoniya, Ruhu ya matsa Bulus ya shaida wa Yahudawa cewa Yesu Almasihu ne. ");
INSERT INTO hauulb_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Lokacin da Yahudawa suka tayar masa suna zarginsa. Bulus ya kakkabe rigansa a gabansu yana cewa, “Alhakin jininku yana kanku; daga yanzu zan koma wurin al'ummai.” ");
INSERT INTO hauulb_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Da ya bar wurinsu, ya tafi gidan Taitus Yustus mai wa Allah sujada. Gidansa na kusa da majami'a. ");
INSERT INTO hauulb_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Kiristus shine shugaban majami'a, sai shi da dukan iyalin gidansa sun ba da gaskiya ga Ubangiji. Korantiyawa da yawa suka ji jawabin Bulus suka ba da gaskiya, aka yi masu Baftisma. ");
INSERT INTO hauulb_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Da dare Ubangiji ya ce wa Bulus a cikin wahayi, “Kada ka ji tsoro, amma ka yi magana kada kuma ka yi shuru. ");
INSERT INTO hauulb_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Gama ina tare da kai, ba wanda zai cutar da kai, gama ina da mutane anan garin.” ");
INSERT INTO hauulb_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Bulus ya zauna a nan tsawon shekara daya da wata shida, yana koyar masu da maganar Allah. ");
INSERT INTO hauulb_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Amma da Galiyo ya samu zaman gwamnan Akaya, sai Yahudawa suka tayar wa Bulus har suka kai shi gaban dakalin shari'a. ");
INSERT INTO hauulb_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Suna cewa, “Wannan mutumin yana kokarin rinjayar mutane su yi sujadar da ta saba wa dokarmu.” ");
INSERT INTO hauulb_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Duk da haka kafin Bulus ya yi magana, Galiyo ya ce wa Yahudawa, “Ku Yahudawa in da karar ku ta wani babban laifi ce wanda ya aikata, da sai in hukunta. ");
INSERT INTO hauulb_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Amma tun da ya ke akan al'amurar, kalmomi ne, da ta sunaye da dokokin ku, ku je ku sasanta al'amuran ku.” ");
INSERT INTO hauulb_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Galiyo ya kore su daga dakalin shari'a. ");
INSERT INTO hauulb_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Saboda haka sai suka kama Sastanisu, suka yi masa duka sosai a gaban dakalin shari'a. Amma Galiyo bai damu da yadda suka karasa ba. ");
INSERT INTO hauulb_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Bulus kuwa, bayan ya zauna tare da su na wasu kwanaki masu yawa, ya bar 'yan'uwan zuwa Suriya ta jirgin ruwa, tare da Balkisu da Akila. Kafin ya bar tashar jiragen ruwa da ke a Sankuriya, ya tafi saboda ya aske kansa, domin ya dauki alkawarin Banazare. ");
INSERT INTO hauulb_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Da suka iso Afisa, Bulus ya bar Balkisu da Akila anan. Shi kuwa ya shiga majami'ar Yahudawa yana nazari tare da su. ");
INSERT INTO hauulb_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Da suka roki Bulus ya zauna da su na tsawon lokaci, bai yarda ba. ");
INSERT INTO hauulb_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Ya kama hanyarsa ya bar su ya ce, “In Allah ya yardar mani zan dawo wurinku wata rana.” Sai ya shiga jirgin ruwa daga Afisa. ");
INSERT INTO hauulb_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Daga saukar su a Kaisariya, sai ya haura zuwa Urushalima ya gai da iklisiya daga nan ya tafi Antakiya. ");
INSERT INTO hauulb_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Bayan ya zauna na dan lokaci a wurin, Bulus ya kama hanyarsa zuwa yakin Galatiya da Firjiya anan ya karfafa almajirai. ");
INSERT INTO hauulb_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","A nan dai akwai wani Bayahude mai suna Afolos, dan asalin Iskandariya ne da haihuwa, ya zo Afisa. Shi masani ne a maganar Allah. ");
INSERT INTO hauulb_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Afolos dai ya sami horo daga maganar Ubangiji. Shi mai kokari ne a ruhu, yana wa'azi da koyarwa daidai game da Yesu. Amma ya san da Baftismar Yahaya ne kadai. ");
INSERT INTO hauulb_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Afolos ya fara wa'azinsa da gabagadi a cikin majami'a. Da Balkisu da Akila suka ji shi sai suka yi abokantaka da shi, suka kara bayyana masa game da labarin hanyar Allah mafi daidai. ");
INSERT INTO hauulb_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Da ya so ya wuce zuwa cikin Akaya 'yan'uwa suka karfafa shi, sun rubuta wa almajiran da ke a Akaya, don su karbe shi da hannu biyu. Da ya iso wurinsu, ya kuwa karfafa 'yan'uwa da sun ba da gaskiya ta wurin alheri. ");
INSERT INTO hauulb_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Afolos ya ba Yahudawa mamaki da irin ikon da yake da shi da gwanintarsa, yadda yake nunawa daga nassoshi cewa Yesu shine Almasihu. ");
INSERT INTO hauulb_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Sa'adda Afolos yake a Koranti, Bulus ya zagaya kasar tudu ya zo birnin Afisa, a nan kuma ya sami wadansu almajirai. ");
INSERT INTO hauulb_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Bulus ya ce masu, “Ko kun karbi Ruhu Mai Tsarki sa'anda kuka ba da gaskiya?” Suka amsa, “A'a bamu taba jin labarin Ruhu Mai Tsarki ba. ");
INSERT INTO hauulb_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Bulus ya ce, “Wacce irin baftisma aka yi maku?” Suka ce, “Baftismar Yahaya” ");
INSERT INTO hauulb_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Bulus ya amsa ya ce, “Yahaya ya yi wa mutane baftismar tuba, ya ce su ba da gaskiya wanda zai zo bayansa, wato, Yesu kenan.” ");
INSERT INTO hauulb_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Da mutanen suka ji haka, sai aka yi masu baftisma cikin sunan Ubangiji Yesu. ");
INSERT INTO hauulb_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Sa'adda Bulus ya dibiya hannu a kansu, Ruhu Mai Tsarki kuma ya sauka a kansu suka yi magana da harsuna da kuma annabci. ");
INSERT INTO hauulb_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Su wajen mutum goma sha biyu ne. ");
INSERT INTO hauulb_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Bulus ya shiga majami'a ya yi ta koyarwa gabagadi misalin tsawon wata uku. Yana bi da su cikin nazarin maganar yana fahimtar da mutane su gaskanta game da abubuwa da suka shafi mulkin Allah. ");
INSERT INTO hauulb_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Amma sa'adda wadansu Yahudawa suka taurare, suka ki yin biyayya, sai suka fara bata hanyar Almasihu a gaban taron. Saboda haka sai Bulus ya janye daga wurinsu tare da wadanda suka ba da gaskiya. Ya fara koyarwa a makarantar Tiranus. ");
INSERT INTO hauulb_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Haka ya cigaba shekaru biyu har duk mazaunan Asiya suka ji maganar Ubangiji, Yahudawa da Helenawa. ");
INSERT INTO hauulb_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Allah ya yi manyan al'ajibai ta hannun Bulus, ");
INSERT INTO hauulb_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","har marasa lafiya suka warke, mugayen ruhohi suka fito daga cikin mutane, sa'adda suka karbi kyallaye da mayafai daga jikin Bulus. ");
INSERT INTO hauulb_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Amma akwai Yahudawa masu tsubu da suka biyo ta wajen, suka dauka wa kansu su yi amfani da sunan Yesu. Suka ce, “Mun dokace ku cikin sunan Yesu wanda Bulus yake wa'azinsa, ku fita.” ");
INSERT INTO hauulb_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Wadanda suka yi wannan su bakwai ne 'ya'yan wani babban firist Bayahude mai suna Siba. ");
INSERT INTO hauulb_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Mugun ruhun ya amsa ya ce, “Na san Yesu, na san Bulus, amma ku, su wanene?” ");
INSERT INTO hauulb_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Sai mugun ruhun da ke cikin mutumin ya fada a kan matsubatan ya fi karfinsu ya kuma bubuge su. Suka runtuma da gudu suka fice daga dakin tsirara da raunuka. ");
INSERT INTO hauulb_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Wannan ya zama sanannen abu ga dukan mutane, Yahudawa da Helenawa mazaunan Afisa. Suka ji tsoro kwarai, sunan Ubangiji Yesu ya sami daukaka. ");
INSERT INTO hauulb_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Masu bi da yawa kuma, suka zo suka furta mugayen ayyukan da suka aikata. ");
INSERT INTO hauulb_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Masu sihiri suka kawo littattafansu suka kona a gaban mutane. Da aka yi jimilar tamaninsu, aka samu sun kai dubu hamsin na azurfa. ");
INSERT INTO hauulb_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Sai maganar Ubangiji ta yadu da iko ta hanyoyi da yawa. ");
INSERT INTO hauulb_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Da Bulus ya kammala aikinsa na bishara a Afisa, Ruhu ya bishe shi sai ya bi ta Makidoniya da Akiya a kan hanyarsa zuwa Urushalima. Ya ce, “Bayan na je can, dole in je Roma.” ");
INSERT INTO hauulb_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Bulus ya aiki almajiransa biyu Timoti da Irastus zuwa Makidoniya, wadanda suka taimake shi. Amma shi da kansa ya jira a Asiya na dan lokaci. ");
INSERT INTO hauulb_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","A wannan lokacin sai aka yi babban tashin hankali a Afisa game da wannan Hanyar. ");
INSERT INTO hauulb_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Wani Makeri mai suna Damatrayus wanda ke kera sifoffin gunkin azurfa na Dayana, wanda sana'a ce mai kawo wa makera riba sosai. ");
INSERT INTO hauulb_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Ya tattara makera ya ce da su, “Kun sa ni da wanan sana'a ne muke samun kudi mai yawa. ");
INSERT INTO hauulb_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Kun gani kun kuma ji cewa, ba a Afisa kadai ba, amma har da fadin kasar Asiya wannan Bulus ya rinjayi mutane da yawa. Yana cewa babu alloli da ake kerawa da hannu. ");
INSERT INTO hauulb_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Ba sana'ar mu kadai ke cikin hatsari ba, amma har da haikalin allahnmu Dayana babba zai zama mara amfani. Ta haka za ta rasa girmanta, ita da dukan kasar Asiya da duniya ke wa sujada.” ");
INSERT INTO hauulb_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Da suka ji haka sai suka fusata kwarai, suka yi kira mai karfi suna cewa “Mai girma ce Dayana ta Afisa.” ");
INSERT INTO hauulb_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Gari gaba daya ya rude, jama'a kuma sun hanzarta zuwa wurin taron. Kafin wannan lokaci, sun riga sun kama abokan tafiyar Bulus, wato Gayus da Aristakas wadanda suka zo daga Makidoniya. ");
INSERT INTO hauulb_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Bulus ya yi niyya ya shiga cikin taron jama'ar, amma almajiran suka hana shi. ");
INSERT INTO hauulb_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Haka nan ma wadansu abokan Bulus da ke shugabanin yankin al'umma Asiya sun aika masa da roko mai karfi kada ya shiga dandalin. ");
INSERT INTO hauulb_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Wadansu mutane na kirarin wani abu, wadansu kuma na kirarin wani abu dabam, domin jama'a sun rude. Da yawa daga cikinsu ma ba su san dalilin taruwarsu ba. ");
INSERT INTO hauulb_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Yahudawa suka kawo Iskandari ya tsaya a gaban taruwan jama'a. Iskandari ya mika hannunsa sama domin ya yi bayani ga jama'a. ");
INSERT INTO hauulb_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Amma da suka gane shi Bayahude ne, sai dukansu suka kwala ihu wajen sa'a biyu, “Mai girma ce Dayana ta Afisa.” ");
INSERT INTO hauulb_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Da magatakardar garin ya sha kan jama'a, sai ya ce, “Ya ku mutanen Afisa, wanene bai san cewa birnin Afisa cibiya ce na allahn nan Dayana mai girma da na sifar da ta fado daga sama ba? ");
INSERT INTO hauulb_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Tun da ba a karyata wadannan abubuwa ba, ya kamata ku yi shuru don kada ku yi wani abu a gaggauce. ");
INSERT INTO hauulb_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Gama kun kawo wadannan mutane a wannan dakin sharia ba a kan su mafasa ne na haikali ba ko kuma masu sabo ga allahnmu ba. ");
INSERT INTO hauulb_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Saboda haka idan Damatrayas da makeran da ke tare da su na da wata tuhuma a kan wani, kotuna suna nan a bude masu shari'a kuma suna nan. Ba ri su kai karar junansu. ");
INSERT INTO hauulb_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Amma idan akwai maganganu na dubawa, za a daidaita su a taronmu na lokaci lokaci. ");
INSERT INTO hauulb_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Domin hakika muna cikin hatsarin zargi game da hargitsin yau. Babu dalilin wanan yamutsi domin ba mu da bayani a kansa.” ");
INSERT INTO hauulb_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Da ya fadi haka, sai ya sallami taron. ");
INSERT INTO hauulb_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Bayan da rikici ya kare, Bulus ya aika a kira al'majiran, ya karfafa su. Sa'annan ya yi bankwana da su, ya tashi zai tafi Makidoniya. ");
INSERT INTO hauulb_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Bayan ya ratsa cikin lardunan yana yi wa masu bi gargadi sosai, sai ya zo kasar Helenawa. ");
INSERT INTO hauulb_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Sa'adda ya yi wata uku a wurin, Yahudawa suka kulla masa makirci, yayin da yake shirin hawa Jirgi zuwa Suriya, sai ya canza ra'ayi ya koma ta Makidoniya. ");
INSERT INTO hauulb_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Masu yi wa Bulus rakiyar zuwa yankin Asiya sun hada da Sobatarus dan Burus daga Biriya; Gayus mutumin Derbe; Timoti da Aristakus da Sakundus, dukansu masu bi ne daga Tasalonika; da Tikikus da Trofimus daga Asiya. ");
INSERT INTO hauulb_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Amma wadansu har suka rigaye mu, suka jira mu a Taruwasa. ");
INSERT INTO hauulb_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Da muka shiga Jirgi daga Filibi bayan kwanakin Gurasa mara yisti; bayan kwanaki biyar muka iske su a Taruwasa; kwananmu bakwai a wurin. ");
INSERT INTO hauulb_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","A rana ta fari ga mako, da muka taru domin karya gurasa. Bulus ya yi wa masubi jawabi, don ya yi niyyar ya tafi da wayewar gari; jawabinsa ya kai har tsakar dare. ");
INSERT INTO hauulb_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","A benen da suka taru akwai fitilu da yawa. ");
INSERT INTO hauulb_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Wani matashi mai suna Aftikos yana zaune a kan taga, barci mai nauyi ya dauke shi; da shike Bulus ya tsawaita jawabinsa, saurayin da shike barci mai nauyi ya dauke shi sai ya fado daga kan bene na uku aka dauke shi matacce. ");
INSERT INTO hauulb_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Sai Bulus ya sauka ya mike a bisansa ya rungume shi, sa'annan ya ce, “Kada kowa ya damu; domin yana darai bai mutu ba.” ");
INSERT INTO hauulb_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Sa'annan ya hawo kan bene domin cin gurasa tare da su, ya yi magana da su har gari ya waye daga nan ya bar su. ");
INSERT INTO hauulb_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Suka kawo saurayin da rai, sun sami ta'aziya ba kadan ba. ");
INSERT INTO hauulb_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Amma mu, da muka riga Bulus zuwa gun Jirgin, muka shiga zuwa Asos, mun shirya mu dauki Bulus a jirgi amma shi ya kudurta ya yi tafiya a kasa. ");
INSERT INTO hauulb_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Da muka sadu a Asos, mun dauke shi a Jirgin ruwa zuwa Mitilitus. ");
INSERT INTO hauulb_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Bayan tashin mu daga can, washegari muka zo tsibirin Kiyos. Washegari kuma muka zo birnin Militus. ");
INSERT INTO hauulb_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Amma Bulus ya kudurta wucewa Afisa a Jirgi, don kada ya bata lokaci a Asiya, don yana sauri in ya yiwu ranar Fentekos ta same shi a Urushalima. ");
INSERT INTO hauulb_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Daga Militus ya aika a kira masa dattawan iklisiyar Afisa. ");
INSERT INTO hauulb_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Da suka zo wurinsa sai ya ce masu, “Ku da kanku kun san tun daga ranar da na sa kafata a Asiya, irin zaman da muka yi da kasancewar mu tare. ");
INSERT INTO hauulb_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Na bauta wa Ubangiji da tawaliu har da hawaye, da wahalun da na sha saboda makircin Yahudawa. ");
INSERT INTO hauulb_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Kun sani ban ji nauyin sanar da ku kowanne abu mai amfani ba, na bi ku gida gida ina koyar da ku abubuwa a sarari. ");
INSERT INTO hauulb_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Kunsan yadda na gargadi Yahudawa da Hellenawa game da tuba ga Allah da bangaskiya ga Ubangiji Yesu. ");
INSERT INTO hauulb_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Yanzu fa, gashi, zan tafi Urushalima, Ruhu Mai Tsarki ya nuna mani a fili dole in je, ban san abin da zai faru da ni a can ba. ");
INSERT INTO hauulb_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Sai dai Ruhu Mai Tsarki ya nuna mani a kowanne gari cewa, sarkoki da wahalu suna jira na. ");
INSERT INTO hauulb_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Amma ban dauka cewa raina yana da wani amfani gare ni ba, domin in cika tsere da hidimar da na karba daga wurin Ubangiji Yesu, ta shaidar bisharan alherin Allah. ");
INSERT INTO hauulb_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Yanzu fa, duba, na san dukanku, wadanda na yi wa wa'azin mulkin Allah, ba za ku kara gani na ba. ");
INSERT INTO hauulb_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Don haka na shaida maku a wannan rana, ba ni da alhakin jinin kowanne mutum. ");
INSERT INTO hauulb_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Don banji nauyin sanar maku da dukan nufin Allah a gare ku ba. ");
INSERT INTO hauulb_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Saboda haka ku kula da kanku, da masubi da Ruhu Mai Tsarki ya sanya ku shugabanni. Ku kula ku yi kiwon iklisiyar Allah, wadda ya saya da jininsa. ");
INSERT INTO hauulb_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Na sani cewa bayan tafiyata, kyarketai masu zafi za su shiga tsakaninku, kuma baza su rangwanta wa masubi ba. ");
INSERT INTO hauulb_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Na sani har daga cikinku wadansu mazaje za su zo su fadi gurbattatun zantattuka, domin su janye almajirai zuwa gare su. ");
INSERT INTO hauulb_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Saboda haka ku yi lura. Ku tuna da cewa shekara uku ban fasa yi wa kowannenku gargadi da hawaye dare da rana ba. ");
INSERT INTO hauulb_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Yanzu ina mika ku ga Allah, da maganar Alherinsa, wadda take da ikon gina ku ta kuma ba ku gado tare da dukan wadanda ke cikin kebabbu na Allah. ");
INSERT INTO hauulb_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Ban yi kyashin azurfa, ko zinariya, ko tufafin wani ba. ");
INSERT INTO hauulb_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Ku da kanku kun sani na yi aiki da hannuwana, na biya bukatu na da na wadanda ke tare da ni. ");
INSERT INTO hauulb_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Na zama maku abin koyi a kowace hanya game da yadda za ku taimaka wa nakasassu ta wurin aiki, da yadda za ku tuna da maganar Ubangiji Yesu, maganar da shi da kansa ya ce: ''Bayarwa tafi karba albarka.'' ");
INSERT INTO hauulb_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Bayan da ya yi magana haka, ya durkusa ya yi addu'a tare da su duka. ");
INSERT INTO hauulb_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Dukansu kuwa suka yi kuka mai tsannani, suka rungume shi kuma suka sunbace shi. ");
INSERT INTO hauulb_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Suka yi bakin ciki musamman domin abin da ya ce masu, ba za su kara ganinsa ba. Sai dukansu suka yi masa rakiya zuwa wurin jirgin ruwa. ");
INSERT INTO hauulb_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Da muka rabu da su, muka shiga jirgin ruwa muka mike hanya zuwa birnin Kos, washegari sai birnin Rodusa, daga nan sai kuma zuwa birnin Batara. ");
INSERT INTO hauulb_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Da muka sami jirgi mai hayewa zuwa Fonisiya sai muka shiga. ");
INSERT INTO hauulb_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Da muka hango tsibirin Kubrus muka bar shi a hagun mu muka nufi Suriya, muka sauka a birnin Taya domin a nan ne jirgin ruwan zai sauke kayansa. ");
INSERT INTO hauulb_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Bayan mun sami almajirai sai muka zauna can kwana bakwai. Al'majiran suka ce ma Bulus, ta wurin Ruhu, kada ma ya je Urushalima. ");
INSERT INTO hauulb_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Bayan 'yan kwanaki muka cigaba da tafiyarmu. Dukansu da matansu da 'ya'yansu suka raka mu har bayan birnin. Sa'annan muka durkusa a bakin gacci muka yi addu'a muka yi sallama da juna. ");
INSERT INTO hauulb_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Sai muka shiga jirgin ruwa, su kuma suka koma gida. ");
INSERT INTO hauulb_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Da muka gama tafiyarmu a Taya muka iso Talamayas. A nan ne muka gaisa da 'yan'uwa, muka zamna kwana daya da su. ");
INSERT INTO hauulb_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Washegari muka tashi muka tafi Kaisariya. Muka shiga gidan Filibus mai shaida bishara, daya daga cikin bakwai din, muka zauna da shi. ");
INSERT INTO hauulb_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Wannan mutum yana da 'ya'ya hudu mata, budurwai masu yin annabci. ");
INSERT INTO hauulb_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Sa'anda muka zauna can 'yan kwanaki, wani annabi ya zo daga Yahudiya mai suna Agabus. ");
INSERT INTO hauulb_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Ya zo wurinmu ya dauki damarar Bulus ya daure tasa kafar da hannayensa ya ce, “Ruhu Mai Tsarki ya ce, 'Haka Yahudawa za su daure mai wannan damarar, zasu kuma bashe shi ga al'ummai.'” ");
INSERT INTO hauulb_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Da muka ji wannan sakon, sai dukanmu da mazaunan wurin muka roki Bulus kada ya tafi Urushalima. ");
INSERT INTO hauulb_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Sai Bulus ya amsa ya ce, “Me kuke yi, kuna kuka kuna karya mani zuciya? Bama a shirye don dauri kadai nake ba har ma da mutuwa a Urushalima, sabili da sunan Ubangiji Yesu.” ");
INSERT INTO hauulb_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Tun da Bulus bashi da niyyar a rinjaye shi, muka daina kuka muka ce, “Bari nufin Ubangiji ya tabbata.” ");
INSERT INTO hauulb_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Bayan wadannan kwanaki, muka dauki jakkunanmu muka haura Urushalima. ");
INSERT INTO hauulb_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Wadansu almjirai daga Kaisariya suka bi mu. Sun zo ne tare da wani ana ce da shi Manason, mutumin Kuburus mai bi na farko, wanda za mu zauna da shi. ");
INSERT INTO hauulb_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Da muka isa Urushalima, 'yan'uwa suka marabce mu da farin ciki. ");
INSERT INTO hauulb_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Washegari Bulus ya tafi tare da mu zuwa wurin Bitrus, dukan dattawa kuma suna nan. ");
INSERT INTO hauulb_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Bayan ya gaishe su, sai ya shaida masu daya bayan daya abubuwan da Allah ya yi cikin al'ummai ta wurin hidimarsa. ");
INSERT INTO hauulb_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Da suka ji haka, suka yabi Ubangiji suka ce masa, “Ka gani, dan'uwa, dubban Yahudawa sun bada gaskiya suna kuma da niyyar kiyaye shari'a. ");
INSERT INTO hauulb_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","An kuma gaya masu a kanka cewa, kana koya wa Yahudawan da suke zaune cikin al'ummai su yi watsi da Musa. Kana koya masu kada su yi wa 'ya'yansu kaciya, kada kuma su bi tsofaffin al'adu. ");
INSERT INTO hauulb_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Me ya kamata mu yi? Hakika za su ji ka zo. ");
INSERT INTO hauulb_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Sabo da haka ka yi abin da muka fada maka yanzu. Muna da maza hudu da suka dauki wa'adi. ");
INSERT INTO hauulb_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Tafi da wadannan ka tsarkake kanka tare da su, ka dauki dukan dawainiyar su dana askin kai. Ta haka kowanne mutum zai sani abubuwan da ake fadi a kanka karya ne. Za su sani cewa kai mai kiyaye shari'a ne. ");
INSERT INTO hauulb_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Game da al'umman da suka bada gaskiya mun yi masu wasika, mun bada umarni su kaurace kansu daga sadakokin da aka mika wa gumaku, da jini, da abin da aka makare da kuma fasikanci. ");
INSERT INTO hauulb_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Sai Bulus ya dauki mazannan, washegari ya tsarkake kansa tare da su, suka shiga haikali, domin ya sanar da cikar ranakun tsarkakewarsu, wato ranar ba da sadaka domin kowanne dayansu. ");
INSERT INTO hauulb_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Da kwanakin nan bakwai suka yi gab da cika, wadansu Yahudawa daga Asiya suka ga Bulus a haikali, sai suka zuga taro, suka danke shi. ");
INSERT INTO hauulb_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Suna ta kururuwa, “Mutanen Isra'ila ku taimaka mana. Wannan shine mutumin da ke koya wa dukan mutane ko'ina abubuwa gaba da mutane, da shari'a da kuma wannan wurin. Banda haka ya kawo Helenawa cikin haikalin nan ya kazantar da wannan wuri tsatsarka.” ");
INSERT INTO hauulb_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Domin dama sun ga Tarofimas mutumin Afisa tare da Bulus cikin birni, suka yi zaton ya kawo shi cikin haikali. ");
INSERT INTO hauulb_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Sai duk gari ya rude, mutane suka runtuma suka danke Bulus. Suka ja shi waje daga cikin haikalin, nan da nan aka rufe kofofin. ");
INSERT INTO hauulb_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Suna kokarin kashe shi kenan, sai labari ya kai wurin hafsan sojoji cewa Urushalima duk ta yamutse da tarzoma. ");
INSERT INTO hauulb_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Nan take ya dauki mayaka da jarumawa, suka sheka da gudu wurin taron. Da mutane suka ga hafsan sojoji da rundunansa sai suka daina dukan Bulus. ");
INSERT INTO hauulb_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Sai hafsan ya tafi ya danke Bulus ya sa aka daure shi da sarkoki biyu. Ya tambaya ko shi wanene da kuma laifinsa. ");
INSERT INTO hauulb_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Wadansu cikin taron suna ta kururuwa wadansu su ce wannan, wadansu su ce, wancan. Tunda hafsan bai fahimci abin da suke fadi ba, sabo da ihunsu, ya dokaci a shigar da Bulus farfajiyar sojoji. ");
INSERT INTO hauulb_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Da suka kai matakala, sojoji suka dauki Bulus sabo da tsananin husatar taron jama'a. ");
INSERT INTO hauulb_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Domin taron suka biyo baya suna ihu suna cewa, “A kashe shi.” ");
INSERT INTO hauulb_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","An kusa shigar da shi farfajiyan kenan sai Bulus ya ce wa babban hafsan, “Ko ka yarda inyi magana da kai?” Hafsan ya ce, “Ka iya Helenanci? ");
INSERT INTO hauulb_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Ashe ba kai ne Bamasaren nan da kwanakin baya ka haddasa tawaye, ka dauki 'yan ta'adda dubu hudu ka kai su jeji ba?” ");
INSERT INTO hauulb_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Bulus ya ce, “Ni Ba'ibrane ne daga birnin Tarsus a Kilikiya. Ni dan kasar babban birni ne. Ka amince mani in yi magana da mutanen.” ");
INSERT INTO hauulb_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Da hafsan ya bashi izni, Bulus ya mike a kan matakala ya daga hannayensa sama ya yi nuni su yi shuru. Da wuri ya yi tsit, Bulus ya yi masu magana da Ibraniyanci. Ya ce, ");
INSERT INTO hauulb_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Yanuwa da Ubanni, ku saurari kariya ta zuwa gare ku yanzu.” ");
INSERT INTO hauulb_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Da taron sun ji Bulus na magana a harshen Ibraniyawa sai sun yi tsit. Ya ce, ");
INSERT INTO hauulb_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","Ni Bayahude ne daga garin Tarwasa na Kilikiya, amma a karkashin Gamaliyal aka ilimantar da ni. An horar da ni sosai bisa ga bin hanyar dokokin kakkaninmu. Ina da himma ga bin Allah kamar yadda ku ma kuna da ita. ");
INSERT INTO hauulb_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Na tsananta wa wannan Hanyan har ga mutuwa; na daure maza da mata sa'annan na jefa su cikin gidan yari. ");
INSERT INTO hauulb_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Hakannan ma babban firist da dukan dattawa za su ba da shaida cewa na karbi izini daga wurinsu domin 'yan'uwa da ke a Dimashku, saboda in tafi can. Haki na shine in daure mabiyan Hanyan nan, in kawo su Urushalima domin a hukunta su. ");
INSERT INTO hauulb_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Sa'anda ina cikin tafiya, ina kuma kusa da Dimashku, da tsakar rana sai farat daya ga babban haske daga sama ya haskaka kewaye dani. ");
INSERT INTO hauulb_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Na fadi kasa sa'anan na ji murya na ce da ni, 'Shawulu, Shawulu, don me kake tsananta mani?' ");
INSERT INTO hauulb_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Na amsa, 'Wanene kai, Ubangiji?' Ya ce mani, 'Nine Yesu Banazarat wanda kake tsananta wa.' ");
INSERT INTO hauulb_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Wadanda ke tare da ni sun ga hasken, amma ba su gane muryar wanda ya yi magana da ni ba. ");
INSERT INTO hauulb_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Na ce, 'Me zan yi ya Ubangiji?” Ubangiji ya ce mani, 'Tashi ka tafi cikin Dimashku, a can za a fada maka abinda wajibi ne ka yi. ");
INSERT INTO hauulb_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Ban iya ganin wuri ba domin walkiyar hasken, sai na tafi cikin Dimashku ta wurin jagorancin wadanda ke tare da ni. ");
INSERT INTO hauulb_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","A can na sami wani mai suna Ananiya, mai tsoron Allah bisa ga sharia, da kyakyawan suna kuma a gaban Yahudawa da ke zama a can. ");
INSERT INTO hauulb_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Ya zo gare ni ya ce, 'Dan'uwa Shawulu, karbi ganin gari.' A daidai wannan sa'a na gan shi. ");
INSERT INTO hauulb_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Sa'annan ya ce, 'Allah na kakkaninmu ya zabe ka ka san nufinsa, ka ga Mai Adalcin nan, ka kuma ji muryar da ke fitowa daga bakinsa. ");
INSERT INTO hauulb_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Gama za ka zama mashaidinsa ga dukan mutane game da abinda ka gani da wanda ka ji. ");
INSERT INTO hauulb_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","A yanzu me ka ke jira? 'Tashi a yi maka baftisma a wanke zunubanka, kana kira bisa sunansa.' ");
INSERT INTO hauulb_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Bayan da na dawo Urushalima, sa'anda ina addu'a a cikin haikali, sai na karbi wahayi. ");
INSERT INTO hauulb_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Na gan shi ya ce mani, 'Gaggauta ka bar Urushalima yanzu, domin ba za su yarda da shaidarka game da ni ba.' ");
INSERT INTO hauulb_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Na ce, 'Ubangiji, su da kansu sun san yadda na sa su a kurkuku na kuma doddoke wadanda suka gaskanta da kai a kowacce masujada. ");
INSERT INTO hauulb_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","A sa'anda a ke zubar da jinin mashaidinka Istifanus, ina nan tsaye ina goyon baya, ina kuma lura da rigunan wadanda suka kashe shi.' ");
INSERT INTO hauulb_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Amma ya ce mani, 'Tafi, domin zan aike ka can wurin Al'ummai.' ");
INSERT INTO hauulb_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Mutanen sun bar shi yayi magana har zuwa ga wannan lokacin. Amma sai suka ta da murya suna cewa, 'A kawar da wannan dan taliki daga duniya: don bai kamata ya rayu ba.' ");
INSERT INTO hauulb_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Sa'anda suke tadda muryarsu, suna jefar da tufafinsu da kuma baza kura a iska, ");
INSERT INTO hauulb_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","babban hafsan ya umarta a kawo Bulus a farfajiyan. Ya umarta da cewa a bincike shi da bulala, domin ya san dalilin da suka ta da ihu gaba da shi haka. ");
INSERT INTO hauulb_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Bayan da suka daure shi da tsirkiya, Bulus ya ce wa Jarumin da ke kusa da shi, “Ko daidai ne bisa ga doka a yi wa Barome wanda ma sharia ba ta kashe shi ba bulala?” ");
INSERT INTO hauulb_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Da Jarumin ya ji haka, ya tafi wurin babban hafsan, yana cewa, “Me kake so ka yi? Gama wanan mutumin dan asalin Roma ne.” ");
INSERT INTO hauulb_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Babban hafsa ya zo ya ce masa, “Gaya mani, kai dan asalin Roma ne?” Bulus ya ce, “Haka ne.” ");
INSERT INTO hauulb_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Babban hafsan ya amsa masa, “Da kudi masu yawa na sayi yancin zama dan kasa.” Amma Bulus ya ce, “An haife ni dan kasar Roma. ");
INSERT INTO hauulb_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","“Sai mutanen da sun zo su tuhume shi sun bar shi nan da nan. Babban hafsa shi ma ya tsorata da ya gane Bulus dan asalin Roma ne, domin ya riga ya daure shi. ");
INSERT INTO hauulb_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Washegari, babban hafsan ya so ya san gaskiyar tuhuma da Yahudawa suke yi a kan Bulus. Sai ya kwance shi daga sarka, ya kuma umarci babban firist da dukan majalisa su sadu. Sai ya kawo Bulus ya sa shi a tsakiyarsu. ");
INSERT INTO hauulb_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Bulus ya kura wa yan majalisa ido yace, '''Yan'uwa, na yi rayuwa tare da Allah da lamiri mai kyau har wannan ranan.'' ");
INSERT INTO hauulb_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Babban firist Hannaniya ya ba wandanda suke tsaye tare da shi urmarni su buge bakinsa. ");
INSERT INTO hauulb_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Bulus ya ce, “Allah zai buge ka, kai munafiki. Kana zama domin ka shari'anta ni da shari'a, kuma ka umarce a buge ni, gaba da sharia?'' ");
INSERT INTO hauulb_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Wanda suka tsaya a gefe suka ce, ''Kada ka zage babban firis na Allah.'' Bulus yace, ''Ban sani ba, 'yan'uwa, cewa shi babban firis ne. ");
INSERT INTO hauulb_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Domin a rubuce yake, Ba za ku zargi shugaban mutanenku ba.'' ");
INSERT INTO hauulb_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Da Bulus ya ga cewa, daya bangaren Sadukiyawa ne dayan kuma Farisawa, ya yi magana da karfi a majalisa, '''Yan'uwa, ni Bafarise ne, dan Farisawa. Don tabbacin tashin matattu ne kuna shari'anta ni.'' ");
INSERT INTO hauulb_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Daya fadi haka, mahawara ta fara a tsakanin Farisawa da Sadukiyawa, sai taron ya rabu kashi biyu. ");
INSERT INTO hauulb_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Don Sadukiyawa suka ce babu tashin matattu, babu mala'iku, babu kuma ruhohi, amma Farisawa suka ce dukan abubuwan nan sun kasance. ");
INSERT INTO hauulb_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Sai mahawara ta tashi, wadansu marubutan Farisawa suka tashi da mahawara cewa, ''Ba mu same mutumin nan da laifi ba sam. Ko mala'iku da ruhohi ne suka yi masa magana?'' ");
INSERT INTO hauulb_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Da jayayya ta tashi, babban hafsa ya ji tsoro kada su yayaga Bulus, sai ya umarce sojoji suje su kwato shi da karfi daga 'yan majalisa, su tafi da shi farfajiya. ");
INSERT INTO hauulb_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Da dare Ubangiji ya tsaya kusa da shi yace, ''Kada ka ji tsoro, kamar yadda ka ba da shaida game da ni a Urushalima, dole zaka sake zama shaida a Roma.'' ");
INSERT INTO hauulb_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Da gari ya waye, wadansu Yahudawa sun yi yarjejeniya suka dauka wa kansu la'ana: suka ce ba za su ci ba ba za su sha ba sai sun kashe Bulus. ");
INSERT INTO hauulb_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Mutane fiye da arba'in suka kulla wannan makirci. ");
INSERT INTO hauulb_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Suka je wurin manyan firistoci da dattawa suka ce, ''Mun sa wa kanmu la'ana, ba za mu ci ba, ba za mu sha ba sai mun kashe Bulus. ");
INSERT INTO hauulb_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Yanzu, bari majalisa ta ba wa babban hafsa izini a kawo shi a gaba, kamar zai yanke hukunci. Mu kam, a shirye muke mu kashe shi kafin ya iso nan. ");
INSERT INTO hauulb_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Amma dan yar'uwan Bulus ya ji suna labe, sai ya tafi ya shiga farfajiyar ya fada wa Bulus. ");
INSERT INTO hauulb_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Bulus ya kira daya daga cikin jarumai yace, ''Dauki saurayin nan ka kai shi wurin babban hafsa, don yana da abin da zai fada masa.'' ");
INSERT INTO hauulb_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Jarumin ya dauke saurayin ya kai shi wurin babban hafsa yace, ''Bulus dan sarka ne yace in kawo saurayin nan a gaban ka. Yana da abin da zai fada maka.'' ");
INSERT INTO hauulb_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Babban hafsa ya kai shi wani lungu, sai ya tambaye shi, “Menene kake so ka fada mani?'' ");
INSERT INTO hauulb_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Saurayin yace, ''Yahudawa sun yarda su roke ka ka kawo Bulus gobe a majalisa, kamar zasu kara bincike a kan al'amarin. ");
INSERT INTO hauulb_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Amma kada ka yarda da su, mutane fiye da arba'in suna jiransa. Sun sa wa kansu la'anna, ba za su ci ba ba za su sha ba sai dai sun kashe shi. Yanzu a shirye suke; suna jira ka ba su izini.'' ");
INSERT INTO hauulb_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Sai babban hafsa yace wa saurayin ya tafi, da ya gama masa magana, ''Kar ka fada wa wani al'amuran.'' ");
INSERT INTO hauulb_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Sai ya kira jarumai biyu yace, ''Ku shirya sojoji dari biyu, yan dawakai saba'in, masu daukar mashi dari biyu su tafi kaisariya karfe uku na dare.'' ");
INSERT INTO hauulb_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Ya umarta a shirya dabbobin da Bulus zai hawo da zasu kai shi lafiya wurin Filikus gwamna. ");
INSERT INTO hauulb_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Sai ya rubuta wasika a misalin haka: ");
INSERT INTO hauulb_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Gaisuwa zuwa Kuludiyas Lisiyas zuwa ga mai martaba gwamna Filikus. ");
INSERT INTO hauulb_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Yahudawa sun kama wannan mutumin suna shirin kashe shi, na abko masu da sojoji na kwace shi, bayan da na ji shi Barome ne. ");
INSERT INTO hauulb_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Inna son sani dalilin zarginsa, sai na kai shi majalisa. ");
INSERT INTO hauulb_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Na gane cewa ana zarginsa ne a kan tambayoyi game da shari'ansu, amma ba wani zargi da ya cancanci dauri ko mutuwa. ");
INSERT INTO hauulb_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Da aka sanar da ni shirin makircin, sai na tura shi wurinka ba da bata lokaci ba, na umarce masu zarginsa su kawo zarginsu wurinka. Huta lafiya.” ");
INSERT INTO hauulb_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Sai sojoji suka yi biyayya da umarni da aka basu: suka dauki Bulus suka kawo shi dadare a wurin Antibatris. ");
INSERT INTO hauulb_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Da gari ya yawe, yan dawakai suka tafi tare da shi kuma sauran sojoji suka koma farfajiya. ");
INSERT INTO hauulb_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Bayan da yandawakan suka isa Kaisiririya sun mika wasika ga gwamna, suka kuma danka Bulus a hanunsa. ");
INSERT INTO hauulb_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Da gwamna ya karanta wasikar, sai ya tambaye su daga wani yanki ne Bulus ya fito; da ya ji daga yankin kilikiya ne, ");
INSERT INTO hauulb_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Yace zan saurare ka sosai lokacin da masu zargin ka sun zo. Sai ya umarta a tsare shi a fadar Hiridus. ");
INSERT INTO hauulb_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Bayan kwanaki biyar, sai Ananiyas babban firist, Wasu dattawa da wani masanin shari'a mai suna Tartilus, sun tafi can. Suka kai karar Bulus gaban gwamna. ");
INSERT INTO hauulb_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Lokacin da Bulus ya tsaya gaban gwamna, Tartilus ya fara zarginsa yace wa gwamnan, “Saboda kai mun sami zaman lafiya; sa'annan hangen gabanka ya kawo gyara a kasarmu; ");
INSERT INTO hauulb_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","don haka duk abin da ka yi mun karba da godiya, ya mai girma Filikus. ");
INSERT INTO hauulb_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Domin kada in wahalsheka, ina roko a yi mani nasiha don in yi magana kadan. ");
INSERT INTO hauulb_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","An iske mutumin nan yana barna irir iri, yana kuma zuga jama'ar Yahudawa a dukan duniya su yi tayarwa. ");
INSERT INTO hauulb_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Har ma ya yi kokarin kazantar da haikali; saboda haka muka kama shi. Mun so mu shari'anta masa bisa ga dokarmu. ");
INSERT INTO hauulb_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Amma Lisiyas jami'i ya zo ya kwace shi da karfi daga hannunmu. ");
INSERT INTO hauulb_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Idan ka binciki Bulus game da wadannan al'amura, kai ma, zai tabbatar maka abin da muke zarginsa a kai. ");
INSERT INTO hauulb_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Dukan Yahudawa suna zargin Bulus cewa wadannan abubuwa gaskiya ne. ");
INSERT INTO hauulb_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","lokacin da gwamnan ya alamta wa Bulus ya yi magana sai yace, “Yanzu na fahimci cewar da dadewa kana mulkin kasarnan, don haka da farin ciki zan yi maka bayani. ");
INSERT INTO hauulb_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Zaka iya tabbatarwa cewa bai kai kwana sha biyu ba tun da nake zuwa Urushalima don yin sujada. ");
INSERT INTO hauulb_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Da suka same ni a haikali, ban yi jayayya ko kawo rudami a tsakanin jama'a ba. ");
INSERT INTO hauulb_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Don haka ba su da tabbas akan abinda suke zargina a kansa yau. ");
INSERT INTO hauulb_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Amma na sanar da kai, bisa ga abin da suke kira darika, haka ni ma nake bautawa Allah na kakanninmu. Na yi aminci wajen kiyaye dukan abin da ke a rubuce a Attaurat da litattafan annabawa. ");
INSERT INTO hauulb_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Ina sa bege ga Allah, kamar yadda za a yi tashin matattu, masu adalci da miyagu; ");
INSERT INTO hauulb_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","a kan haka kuma, nake kokarin zama mara abin zargi a gaban Allah da mutane ina yin haka cikin dukan al'amura. ");
INSERT INTO hauulb_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Bayan wadansu shekaru na zo in kawo wasu sadakoki da baikon yardar rai. ");
INSERT INTO hauulb_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Cikin kudurin yin haka, sai wasu Yahudawa daga kasar Asiya suka iske ni a cikin ka'idodin tsarkakewa a haikali, ba da taro ko ta da hargitsi ba. ");
INSERT INTO hauulb_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Yakamata wadannan mutanen su zo gabarka a yau, har idan suna da wani zargi a kai na. ");
INSERT INTO hauulb_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","In kuwa ba haka ba bari mutanennan su fada in sun taba iske ni da wani aibu a duk lokacin da na gurfana a gaban majalisar Yahudawa; ");
INSERT INTO hauulb_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","sai dai ko a kan abu daya da na fada da babbar murya sa'adda na tsaya a gabansu, 'Wato batun tashin matattu wanda ake tuhumata ake neman yi mani hukunci yau.'” ");
INSERT INTO hauulb_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Filikus yana da cikakken sanin tafarkin Hanyar, shi yasa ya daga shari'ar. Yace da su, “Duk sa'anda Lisiyas mai ba da umarni ya zo daga Urushalima, zan yanke hukunci.” ");
INSERT INTO hauulb_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Sa'annan ya umarci jarumin ya lura da Bulus, amma ya yi sassauci, kada ya hana abokansa su ziyarce shi ko su taimake shi. ");
INSERT INTO hauulb_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Bayan wadansu kwanaki, Filikus da mai dakinsa Druskila, ita Bayahudiya ce, ya kuma aika a kira Bulus ya saurare shi game da bangaskiya cikin Kristi Yesu. ");
INSERT INTO hauulb_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Amma sa'adda Bulus yake bayyana zancen adalci, kamunkai, da hukunci mai zuwa, Filikus ya firgita ya ce, “Yanzu ka tafi. Amma idan na sami zarafi an jima, zan sake neman ka.” ");
INSERT INTO hauulb_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","A wannan lokacin, yasa zuciya Bulus zai bashi kudi, yayi ta nemansa akai-akai domin yayi magana da shi. ");
INSERT INTO hauulb_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Bayan shekaru biyu, Borkiyas Festas ya zama gwamna bayan Filikus, domin neman farin jini a wurin Yahudawa, ya ci gaba da tsaron Bulus a gidan yari. ");
INSERT INTO hauulb_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Da Festas ya shiga lardin, kuma bayan kwana uku, ya tashi daga Kaisariya ya tafi Urushalima. ");
INSERT INTO hauulb_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Sai babban firist da manyan Yahudawa suka kawo wa Festas sara a kan Bulus. ");
INSERT INTO hauulb_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Suka roki tagomashi wurin Festas ya kira Bulus zuwa Urushalima domin su kashe shi a hanya. ");
INSERT INTO hauulb_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Amma Festas ya amsa masu cewa, Bulus dan sarka ne a Kaisariya, kuma ba da dadewa ba shi da kansa zai koma can. ");
INSERT INTO hauulb_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","“Saboda haka duk wadanda za su iya, su biyo mu. Idan akwai wani laifi game da mutumin, sai ku zarge shi.” ");
INSERT INTO hauulb_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Bayan kwana takwas ko goma, sai ya gangara zuwa Kaisariya. Washegari ya zauna bisa kursiyin shari'a ya bada umarni a kawo Bulus a gabansa. ");
INSERT INTO hauulb_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Da Bulus ya iso, Yahudawa daga Urushalima suka tsaya kusa, suka yi ta kawo kararraki, amma basu iya tabbatar da su ba. ");
INSERT INTO hauulb_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Bulus ya kare kansa ya ce, “Ban yi wa kowa laifi ba, ko Yahudawa, ko haikali, ko kuma Kaisar.” ");
INSERT INTO hauulb_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Amma Festas yana neman farin jini wajen Yahudawa, sabo da haka ya tambayi Bulus ya ce, “Kana so ka je Urushalima in shari'anta ka a can game da wadannan abubuwa?” ");
INSERT INTO hauulb_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Bulus ya ce, “Ina tsaye a Ddakalin Shari'ar Kaisar inda dole a shari'anta ni. Ban yi wa Yahudawa laifi ba, kamar yadda ka sani sosai. ");
INSERT INTO hauulb_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Idan lallai na yi laifi kuma na yi abin da ya chanchanci mutuwa, ban ki ba in mutu. Amma idan zarginsu karya ne, kada kowa ya bashe ni gare su. Ina daukaka kara zuwa ga Kaisar.” ");
INSERT INTO hauulb_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Bayan Festas ya tattauna da majalisa ya amsa ya ce, “Kana kira ga Kaisar; za ka tafi wurin Kaisar.” ");
INSERT INTO hauulb_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Bayan wadansu kwanaki, sarki Agaribas da Barniki suka iso Kaisariya domin su ziyarci Festas. ");
INSERT INTO hauulb_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Da ya kasance kwanaki da yawa, Festas ya fada wa sarki labarin Bulus ya ce, “Akwai wani mutum dan sarka da Filikus ya bari a kurkuku. ");
INSERT INTO hauulb_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Sa'anda nake a Urushalima, babban firist da dattawan Yahudawa suka kawo kararsa gare ni, suka roka a kashe shi. ");
INSERT INTO hauulb_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Game da wannan na amsa na ce masu, ba al'adar Romawa ba ce a ba da mutum tagomashi; sai wanda ake kararsa an bashi zarafi ya kare kansa a gaban masu kararsa, ya kuma bada hujjojinsa game da kararakin. ");
INSERT INTO hauulb_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Saboda haka, da duk suka taru ban bata lokaci ba, washegari na zauna a kujerar shari'a, na ba da umarni a kawo mutumin. ");
INSERT INTO hauulb_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Da masu karar suka fadi kararsu, sai na fahimci karar ba wani muhimmin abu a cikinta. ");
INSERT INTO hauulb_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Sai dai na ga cewa jayayya ce tsakanin su ta addini a kan wani Yesu da ya mutu, wanda Bulus ya ce yana da rai. ");
INSERT INTO hauulb_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Na rasa yadda zan bincike wannan al'amarin, sai na tambaye shi ko zai je Urushalima a shari'anta shi kan wadannan abubuwa. ");
INSERT INTO hauulb_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Amma da Bulus ya nemi a lura da shi, Kaisar ya shari'anta shi, sai na ba da umarni a ajiye shi har sai na aika shi wurin Kaisar.” ");
INSERT INTO hauulb_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Agaribas yace wa Festas. “Zan so ni ma in saurari mutumin nan.” “Gobe za ka ji shi,” in ji Fostus. ");
INSERT INTO hauulb_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Washegari Agaribas da Barniki suka zo tare da kasaitaccen taro suka shiga dakin taro tare da hafsoshi da shugabanin gari. Da Festas ya ba da umarni, aka fito da Bulus wurinsu. ");
INSERT INTO hauulb_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Festas ya ce, “Sarki Agaribas da dukanku da kuke tare da mu a nan, kun ga mutumin nan, dukan Yahudawa sun gana da ni a Urushalima da nan kuma. Suna mani ihu cewa, bai chanchanta a bar shi da rai ba. ");
INSERT INTO hauulb_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Na gane bai yi wani abin da ya chanchanci mutuwa ba; amma saboda ya daukaka kara zuwa Kaisar, na yanke shawara in aika shi. ");
INSERT INTO hauulb_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Amma ba ni da wani dalili na musamman da zan rubuta wasika ga Kaisar. Saboda wannan dalili na kawo shi gabanku, masamman kai ya sarki Agaribas. Domin in sami karin abin da zan rubuta game da shi. ");
INSERT INTO hauulb_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Gama a ganina wauta ce in aika dan sarka ba tare da na rubuta laifi a kansa ba.” ");
INSERT INTO hauulb_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Sai Agaribas ya ce wa Bulus, “Za ka iya kare kan ka.” Sai Bulus ya daga hannunsa ya fara kare kansa. ");
INSERT INTO hauulb_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Ina farinciki, ya sarki Agaribas, game da saran da Yahudawa ke kawowa a kaina yau; ");
INSERT INTO hauulb_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","musamman ma don kai masani ne game da al'adun Yahudawa da al'amuransu. Don haka, ina rokanka ka yi hakuri ka saurare ni. ");
INSERT INTO hauulb_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Hakika, dukan Yahudawa sun san yadda na yi rayuwa ta daga kurciyata a kasa ta, da kuma Urushalima. ");
INSERT INTO hauulb_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Sun san ni tun farko, kuma yakamata su yarda cewa na yi rayuwa kamar Bafarase, darikan nan mai tsatsauran ra'ayi ta addininmu. ");
INSERT INTO hauulb_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Yanzu ina tsaye a nan dominn a shari'anta ni, saboda alkawalin da Allah ya yi wa ubanninmu. ");
INSERT INTO hauulb_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Domin wannan shine alkawalin da kabilunmu goma sha biyu suka sa zuciya su karba, yayin da suke yin sujada da himma ga Allah dare da rana. Saboda wanan bege, Sarki Agaribas, Yahudawa ke tuhuma ta. ");
INSERT INTO hauulb_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Me ya sa wani zai yi tunani cewa abin mamaki ne Allah ya ta da mattatu? ");
INSERT INTO hauulb_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Da, na yi tunanin yin abubuwa gaba da sunan Yesu Banazarat. ");
INSERT INTO hauulb_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Na yi wadanan a Urshalima. Na kulle masu bi da yawa a kurkuku, sanadiyar iko da na samu daga wurin manyan firistoci, kuma da ake kashe su ma, ina ba da goyon baya. ");
INSERT INTO hauulb_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Na wahalshe su sau dayawa a cikin dukan majamiu ina kuma yin kokari in tilasta masu su yi sabo. Na yi gaba mai zafi da su kuma na tsananta masu har zuwa birane na wadansu kasashe. ");
INSERT INTO hauulb_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","A sa'anda nake yin wannan, na tafi Dimashku da izinin manyan firistoci; ");
INSERT INTO hauulb_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","a cikin tafiyata kuma, da tsakar rana, ya sarki, na ga haske daga sama da ya fi rana sheki, ya haskaka kewaye da ni da kuma wadanda ke tafiya tare da ni. ");
INSERT INTO hauulb_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Da dukanmu muka fadi kasa, na ji wata murya na magana da ni a harshen Ibraniyawa tana cewa, 'Shawulu, Shawulu, don me kake tsananta mani? Yana da wuya ka hauri abin da ke mai tsini.' ");
INSERT INTO hauulb_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Sai na ce, 'Wanene kai ya Ubangiji?' Ubangiji ya amsa, 'Ni ne Yesu wanda kake tsanantawa. ");
INSERT INTO hauulb_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Yanzu ka tashi tsaye domin saboda wannan dalili ne na bayyana gare ka in sanya ka, ka zama bawa da mashaidi na game da abubuwan da ka sani a kaina yanzu da wadanda zan bayyana maka daga bisani; ");
INSERT INTO hauulb_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Zan kubutar da kai daga wurin mutane da kuma al'ummai da zan aike ka wurinsu, ");
INSERT INTO hauulb_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","domin ka bude idanunsu ka juyo su daga duhu zuwa haske da daga ikon Shaidan zuwa ga Allah, domin su karbi gafarar zunubai da gado da zan ba wadanda na kebe wa kaina ta wurin bangaskiya gare ni.' ");
INSERT INTO hauulb_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Saboda haka, sarki Agaribas, ban yi rashin biyayya da wahayin da na gani daga sama ba; ");
INSERT INTO hauulb_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","amma, da farko ga wadanda ke a Dimashku, sa'annan a Urushalima da kasar Yahudiya gaba daya, da dukan Al'ummai, na yi wa'azi domin su tuba su kuma juyo ga Allah, su yi ayyukan da suka chanchanci tuba. ");
INSERT INTO hauulb_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Domin wannan dalili ne Yahudawa suka kama ni a cikin haikali kuma suke kokari su kashe ni. ");
INSERT INTO hauulb_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Allah ya taimake ni har wa yau, domin in iya tsayawa gaban mutane kanana da manya, in bada shaida game da iyakar abin da annabawa da Musa suka fada zai faru; ");
INSERT INTO hauulb_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","wato lallai Almasihu zai sha wahala, ya kuma zama na farko da za'a rayar daga matattu ya kuma yi shelar haske zuwa ga mutanen Yahudawa da Al'ummai.” ");
INSERT INTO hauulb_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Da Bulus ya gama kare kansa, Festas ya yi magana da babban murya, “Bulus, kana hauka; yawan iliminka yasa ka hauka.” ");
INSERT INTO hauulb_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Amma Bulus ya ce, “Ba na hauka, ya mai girma Festas; amma da karfin zuciya nake fadi kalmomin gaskiya da na natsuwa. ");
INSERT INTO hauulb_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Saboda sarkin ya san wadannan abubuwa duka; shi ya sa nake magana gabagadi, don na hakikance cewa, ba abin da ke a boye gare shi; gama ba a yi wadannan abubuwa a boye ba. ");
INSERT INTO hauulb_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Ko ka gaskanta da annabawa, Sarki Agaribas? Na sani ka gaskanta.” ");
INSERT INTO hauulb_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agaribas ya ce wa Bulus, “A cikin karamin lokaci kana so ka rinjaye ni ka mai da ni Krista?” ");
INSERT INTO hauulb_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Bulus ya ce, “Ina roko ga Allah, domin ko a karamin lokaci ko a dogon lokaci, ba kai kadai ba, amma har da wadanda ke sauraro na yau su zama kamar ni, amma ban da wadannan sarkokin.” ");
INSERT INTO hauulb_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Sai sarki ya tashi tsaye tare da gwamna da Barniki da dukan wadanda ke zaune tare da su; ");
INSERT INTO hauulb_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","da suka bar dakin taron, suka ci gaba da magana da juna suna cewa, “Wannan mutum bai yi wani abin da ya chanchanci mutuwa ko kuma dauri ba.” ");
INSERT INTO hauulb_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agaribas ya ce wa Fastos, “Da mutumin nan bai daukaka kara zuwa ga Kaisar ba da an sake shi.” ");
INSERT INTO hauulb_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Bayan da aka amince zamu tafi Italiya, sun mika Bulus tare da wadansu daurarru a hanun wani jarumi mai suna Yuliyas, daga batalian Agustas. ");
INSERT INTO hauulb_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Muka shiga Jirgin ruwa daga Adramatiya, wanda ke shirin tashi zuwa kusa da gefen tekun Asiya. Sai muka je teku. Aristakus mutumin Tasalonika a Makidoniya ya tafi tare damu. ");
INSERT INTO hauulb_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Washegari muka sauka birnin Sidon, inda Yuliyas ya nuna wa Bulus karamci ya kuma yarda abokansa su bi shi don ya kula da su. ");
INSERT INTO hauulb_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Daga wurin, muka bi teku muka tafi ta Tsibirin Kubrus, domin matsananciyar iska da ke gaba damu. ");
INSERT INTO hauulb_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Sa'adda muka ketare ruwa zuwa sassan Kilikiya da Bamfiliya, muka zo Mira ta birnin Lisiya. ");
INSERT INTO hauulb_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Anan, jarumin ya sami jirgin ruwa daga Iskandariya wanda za shi Italiya. Ya samu cikinsa. ");
INSERT INTO hauulb_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Kwana da kwanaki muna tafiya a hankali a karshe da kyar muka sauka kusa da Sinidus, iska ta hana mu tafiya, sai muka ratsa ta Karita, kusa da Salmina. ");
INSERT INTO hauulb_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Da wahala muka bi ta makurda har muka zo wani wuri da ake kira Mafaka Mai Kyau wanda ke kusa da birnin Lasiya. ");
INSERT INTO hauulb_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Yanzu mun dauki dogon lokaci, gashi lokacin azumin Yahudawa ya wuce, tafiyar kuma ta zama da hatsari. Bulus ya gargade su, ");
INSERT INTO hauulb_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","ya ce, “Jama'a, na gane tafiyarmu zata zamar mana da barna da asara mai yawa, ba ga kaya da jirgin kadai ba amma har da rayukan mu.” ");
INSERT INTO hauulb_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Amma jarumin ya fi mai da hankali ga maganar shugabansa da mai jirgin ruwan, fiye da abubuwan da Bulus ya fadi. ");
INSERT INTO hauulb_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Da shike tashar ba za ta yi dadin zama da hunturu ba, mafi yawa sun ba da shawara a bar wurin, in maiyiwuwa ne muga mun kai birnin Finikiya, don mu yi hunturu a can. Finikiya tashar jirgin ruwa ce a Karita, tana fuskantar arewa maso gabas da kudu maso gabas. ");
INSERT INTO hauulb_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Sa'adda iska daga kudu ta huro a hankali, sun tsammaci bukatarsu ta biya. Sai suka janye linzamin jirgin ruwan sukabi ta Karita kusa da gaba. ");
INSERT INTO hauulb_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Amma bayan wani dan lokaci sai iska mai karfi da ake kira Yurokilidon, ta fara bugun mu daga tsibirin. ");
INSERT INTO hauulb_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Sa'adda Jirgin ruwan ya kasa fuskantar iskar, sai muka bi inda iskar ta nufa. ");
INSERT INTO hauulb_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Sai muka bi ta inda muka sami kariya kusa da wani dan tsibiri wanda ake kira Kauda; kuma da wahala muka daure karamin jirgin a jikin babban. ");
INSERT INTO hauulb_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Bayanda suka daga shi, sun yi amfani da igiyoyi don su daure jirgin don gudun fadawa kan yashin Sirtis, suka bar jirgin yana ta korarsu. ");
INSERT INTO hauulb_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Mun yi ta fama da hadari ba kadan ba, da gari ya waye ma'aikatan jirgin suka fara zubar da kaya daga jirgin. ");
INSERT INTO hauulb_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","A rana ta uku, ma'aikatan jirgi suka jefar da kaya daga cikin jirgin da hannuwansu. ");
INSERT INTO hauulb_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Kwanaki dayawa ba mu ga hasken rana da taurari a bisan mu ba. Babban hadari kadai ke dukanmu, duk mun fidda zuciya zamu tsira. ");
INSERT INTO hauulb_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Sa'adda sun dade basu ci abinci ba, sai Bulus ya tashi a gaban ma'aikatan jirgi yace, “Jama'a, da kun saurare ni, da bamu tashi daga Karita ba, balle mu fuskanci wannan barna da asarar. ");
INSERT INTO hauulb_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Yanzu fa ina karfafa ku kuyi karfin hali, domin ba wanda zai rasa ransa a cikinku, sai dai jirgin kadai za a rasa. ");
INSERT INTO hauulb_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Domin daren da ya gabata mala'ikan Allah wanda ni nasa ne, wanda kuma nake bautawa -mala'ikansa ya tsaya kusa dani ");
INSERT INTO hauulb_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","ya ce, “Kada ka ji tsoro, Bulus, dole ka tsaya gaban Kaisar, duba kuma, Allah cikin jinkansa ya baka dukan wadannan da ke tafiya tare da kai. ");
INSERT INTO hauulb_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Domin haka, jama'a, kuyi karfin hali, domin na gaskanta da Allah, kamar yadda aka fada mani haka zai faru. ");
INSERT INTO hauulb_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Amma lallai dole ne a jefa mu kan wani tsibiri”. ");
INSERT INTO hauulb_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Sa'adda dare na goma sha hudu ya yi, ana ta tura mu nan da can a cikin tekun Adriyat, wajen tsakar dare, ma'aikatan jirgin sun tsammaci sun kusanci wata kasa. ");
INSERT INTO hauulb_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Da suka gwada sai suka iske kamu ashirin; bayan dan lokaci kadan, sun sake aunawa sai suka iske kamu sha biyar ne. ");
INSERT INTO hauulb_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Tsoro ya kama su ko watakila a jefar da mu kan duwatsu, sai suka jefa linzami hudu daga karshen jirgin suka yi addu'a don gari ya waye da sauri. ");
INSERT INTO hauulb_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Ma'aikatan jirgin ruwan suna neman hanyar da za su rabu da jirgin kuma sun jefa karamin jirgin a cikin teku. Suka yi kamar zasu jefa wasu linzamai daga gaban jirgin. ");
INSERT INTO hauulb_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Amma Bulus ya ce ma jarumi da sojojin, “Idan mutanen nan ba zasu tsaya cikin jirgin ba, ba zaku tsira ba”. ");
INSERT INTO hauulb_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Sai sojojin suka yanke igiyoyin jirgin suka kuma barshi ya fadi. ");
INSERT INTO hauulb_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Da gari ya fara wayewa, Bulus ya roke su duka su dan ci abinci, ya ce, “Yau kwana goma sha hudu kenan ba ku ci kome ba. ");
INSERT INTO hauulb_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Saboda haka na roke ku ku ci abinci, domin wannan saboda lafiyarku ne; kuma ko gashin kanku daya baza ku rasa ba”. ");
INSERT INTO hauulb_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Da ya fadi haka sai ya dauki gurasa ya yi godiya ga Allah a idanun kowa. Sai ya gutsutsura gurasa ya fara ci. ");
INSERT INTO hauulb_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Sai dukansu suka karfafu suka kuma ci abinci. ");
INSERT INTO hauulb_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Mu mutane 276 (dari biyu da saba'in da shida) ne cikin jirgin. ");
INSERT INTO hauulb_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Da suka ci suka koshi, suka zubar da alkamar cikin teku domin su rage nauyin jirgin. ");
INSERT INTO hauulb_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Da gari ya waye, basu fahimci kasar ba, amma suka hangi wani lungu a gacci, sai suka yi shawara tsakaninsu ko su tuka jirgin zuwa cikin lungun. ");
INSERT INTO hauulb_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Sai suka yanke linzaman suka bar su cikin tekun. Cikin lokaci guda suka kwance igiyoyin da ke juya jirgin, suka saki filafilan goshin jirgi suka nufi gabar tekun. ");
INSERT INTO hauulb_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Da suka iso inda ruwa biyu suka hadu, sai jirgin ya tsaya kasa. Gaban jirgin ya kafe a nan, ba damar matsawa, sai kuma kurar jirgin ta fara kakkaryewa saboda haukan rakuman ruwa. ");
INSERT INTO hauulb_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Shirin sojojin ne su kashe 'yan kurkukun domin kada su yi iyo su tsere. ");
INSERT INTO hauulb_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Amma shi hafsan ya so ya ceci Bulus, sai ya tsai da shirin su, ya ba da umarni, duk masu iya iyo su yi tsalle su fada ruwa su kai gacci. ");
INSERT INTO hauulb_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Sa'annan sauran mazajen su biyo baya, wadansu a kan karyayyun katakai, wadansu akan abubuwan da ke a jirgin. Ta haka ne dukanmu muka kai gacci lafiya. ");
INSERT INTO hauulb_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Sa'adda muka sauka lafiya, sai muka ji cewa sunan tsibirin Malita. ");
INSERT INTO hauulb_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Mutanen garin sun nuna mana alheri matuka don sun hura wuta don mu ji dimi, saboda ruwan sama da sanyin da ake yi. ");
INSERT INTO hauulb_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Amma sa'adda Bulus ya tara kiraruwa don hura wuta, sai maciji saboda zafin wuta, ya fito ya nade hannuwansa. ");
INSERT INTO hauulb_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Da mazaunan garin suka ga maciji ya nade hannuwansa, sai suka cema junansu, “Ba shakka wannan mutumin mai kisan kai ne, koda shike ya tsira daga Teku, sharia baza ta barshi da rai ba”. ");
INSERT INTO hauulb_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Amma ya karkade macijin cikin wuta ba tare da ya cutar da shi ba. ");
INSERT INTO hauulb_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Sun saurara su gani ko zai kumbura ko ya fadi matacce. Amma da suka jira dan lokaci basu ga wata matsala ta same shi ba sai suka canza tunaninsu sukace shi wani allah ne. ");
INSERT INTO hauulb_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","A kusa da wannan wurin tsibirin akwai wasu gonakin wani babban mutumin tsibirin, mai suna Babiliyas. Ya karbe mu ya biya bukatun mu har kwana uku. ");
INSERT INTO hauulb_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Ana nan ashe mahaifin Babiliyas yana fama da zazzabi da atuni. Bulus ya shiga, yayi masa addu'a, ya dibiya masa hannu, ya sami warkarwa. ");
INSERT INTO hauulb_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Sa'adda wannan ya faru, sauran marasa lafiya da ke tsibirin sun zo sun sami warkarwa. ");
INSERT INTO hauulb_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Mutanen sun mutunta mu kwarai. Yayin da muke shirin tafiya, sun bamu duk abinda muke bukata. ");
INSERT INTO hauulb_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Bayan watanni uku, mun shiga jirgin Iskandariya wanda tun da hunturu yake a tsibirin mai zane kamannin Tagwaye Maza. ");
INSERT INTO hauulb_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Bayan saukar mu a birnin Sirakus, mun yi kwana uku a wurin. ");
INSERT INTO hauulb_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Daga nan sai muka tafi, har muka zo birnin Rigiyum. Bayan kwana daya iska mai karfi daga kudu ta taso, a cikin kwana biyu muka iso Butiyoli. ");
INSERT INTO hauulb_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","A can muka iske wasu 'yan'uwa suka roke mu mu zauna tare da su har kwana bakwai. Ta wannan hanyar ce muka zo Roma. ");
INSERT INTO hauulb_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Daga can da 'yan'uwa suka ji labarin mu, suka fito don su tarbe mu tun daga Kasuwar Abiyas da kuma Rumfuna Uku. Da Bulus ya gan su, ya yi wa Allah godiya ya kuma sami karfafawa. ");
INSERT INTO hauulb_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Sa'adda muka shiga Roma, aka yardar wa Bulus ya zauna shi kadai tare da sojan da ke tsaronsa. ");
INSERT INTO hauulb_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Ana nan bayan kwana uku, Bulus ya kira shugabannin Yahudawa. Bayan da suka taru, sai ya ce masu, “Yan'uwa, ko da shike ban yi wa kowa laifi ko keta al'adun Ubanninmu ba, duk da haka an bashe ni daurarre tun daga Urushalima zuwa ga hannunwan mutanen Roma. ");
INSERT INTO hauulb_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Bayan tuhumata, sun yi kudirin saki na, domin ban yi laifin da ya cancanci mutuwa ba. ");
INSERT INTO hauulb_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Amma da Yahudawa suka tsaya a kan ra'ayin su, ya zama dole in daukaka kara zuwa ga Kaisar, ba domin ina da wani dalilin da zan yi karar al'ummata ba ne. ");
INSERT INTO hauulb_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Saboda wannan ne na bukaci ganinku in yi magana da ku. Saboda begen da Isra'ila suke da shi ya sa nake daure da wannan sarkar”. ");
INSERT INTO hauulb_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Sai suka ce masa, “Bamu karbi wasiku daga Yahudiya game da kai ba, babu kuma wani daga cikin 'yan'uwa wanda ya kawo mana wani rahoto ko wata magana game da kai. ");
INSERT INTO hauulb_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Amma muna so mu ji daga gare ka abin da kayi tunani ka kuma gani game da wannan darikar, gama mun sani ana kushenta a ko'ina.” ");
INSERT INTO hauulb_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Sa'adda suka sa masa rana, mutane da dama suka same shi a masaukinsa. Ya gabatarda zantattukan a gare su, yana tabbatar da bayyanuwar mulkin Allah. Har ya nemi ya rinjaye su a kan zancen Yesu, tun daga attaurat ta Musa zuwa litattafan annabawa, ya yi wannan tun daga safiya har yamma. ");
INSERT INTO hauulb_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Wasu sun kawar da shakkar abin da aka fada, amma wadansu basu gaskanta ba. ");
INSERT INTO hauulb_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Da shike ba su yarda da junansu ba, sai suka tafi bayan da Bulus ya fadi kalma daya, “Ruhu Mai Tsarki ya yi magana ta bakin annabi Ishaya zuwa ga kakanninku. ");
INSERT INTO hauulb_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Ya ce, 'Jeka wurin al'umman nan ka ce, cikin ji zaku ji amma ba zaku fahimta ba; zaku gani amma ba zaku gane ba. ");
INSERT INTO hauulb_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Amma zuciyar mutanen nan ta yi kanta, kunnuwansu sun ji da kyar, sun rufe idanunsu; don kada su gani su gane, su kuma ji da kunuwansu, kuma su fahimta da zuciyarsu, domin su juyo ni kuma in warkar da su.” ");
INSERT INTO hauulb_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Saboda haka, sai ku sani cewa wannan ceto na Allah an aikar da shi zuwa ga Al'ummai, za su kuma saurara.” ");
INSERT INTO hauulb_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Sa'adda ya fadi wannan zantattuka, Yahudawa suka tashi, suna gardama da junansu. ");
INSERT INTO hauulb_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Bulus ya zauna shekaru biyu a cikin gidan hayarsa, yana marabtar duk wadanda suka zo wurinsa. ");
INSERT INTO hauulb_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Yana wa'azin mulkin Allah, yana koyarwa da al'amuran Ubangiji Yesu Kristi gaba gadi. Ba wanda ya hana shi. ");
INSERT INTO hauulb_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Bulus, bawan Yesu Almasihu, kirayayye ya zama manzo, kuma kebabbe domin bisharar Allah. ");
INSERT INTO hauulb_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Wannan itace bisharar da ya alkawarta tuntuni ta wurin annabawansa ta wurin tsarkakakkun littattafan sa. ");
INSERT INTO hauulb_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Game da Dansa ne, haifaffe daga zuriyar Dauda ga zancen jiki. ");
INSERT INTO hauulb_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Ta wurin tashinsa daga mattatu aka aiyana shi ya zama Dan Allah ta wurin ikon Ruhu na tsarkakewa. Yesu Almasihu Ubangijimu. ");
INSERT INTO hauulb_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Ta wurinsa muka karbi alheri da manzanci sabo da biyayyar imani a cikin dukkan al'ummai, domin darajar sunansa. ");
INSERT INTO hauulb_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","cikin wadannan al'ummai kwa, ku ma an kiraku ku zama na Yesu Almasihu. ");
INSERT INTO hauulb_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Wannan wasika ga dukkanku ne da kuke cikin Roma, kaunatattu na Allah, kirayayyun mutane tsarkakakku. Bari alheri ya kasance tare daku, da salama daga Allah Ubanmu, da kuma Ubangiji Yesu Almasihu. ");
INSERT INTO hauulb_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Abu na farko dai ina yi wa Allah na godiya ta wurin Yesu Almasihu domin ku duka, domin kuwa ana labarta bangaskiyarku ko ina a cikin dukkan duniya. ");
INSERT INTO hauulb_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Domin kuwa Allah shi ne shaida ta, wanda nake bautawa a cikin ruhuna a cikin bisharar Dansa, yadda a koyaushe na ke ambaton ku. ");
INSERT INTO hauulb_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","A kullum ina roko cikin addu'o'ina domin ta kowanne hali in yi nasarar zuwa gare ku da izinin Allah. ");
INSERT INTO hauulb_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Gama ina marmarin ganin ku, domin in baku wata baiwa ta ruhaniya, domin in karfafa ku. ");
INSERT INTO hauulb_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Wato ina dokin in sami cikakkiyar karfafawa a cikin ku, ta wurin bangaskiyar junanmu, wato tawa da taku. ");
INSERT INTO hauulb_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Yanzu fa bana so ku rasa sani, yan'uwa, sau da yawa nake yin niyyar zuwa wurinku, amma har yanzu hakan din bata samu ba. Na so yin hakan din ne don in sami 'ya'ya na ruhu a cikinku kamar dai yadda ya ke a sauran Al'ummai. ");
INSERT INTO hauulb_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Ina dauke da nawayar Hellinawa da ta sauran jama'a, masu hikima da marasa hikima. ");
INSERT INTO hauulb_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Don a shirye na ke in sanar da bishara a gare ku, ku da kuke cikin Roma. ");
INSERT INTO hauulb_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Don kuwa ni ba na jin kunyar yin bishara, don ita ce ikon Allah don samun ceto ga duk wanda ya gaskata, da farko dai Yahudawa kana kuma Hellinawa, ");
INSERT INTO hauulb_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Domin a cikin ta adalcin Allah ya bayyana daga bangaskiy zuwa bangaskiya, kamar yadda yake a rubuce, “Mai adalci zai rayu ne tawurin bangaskiya.” ");
INSERT INTO hauulb_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Domin fushin Allah ya bayyana ne daga sama gaba da rashin ibada da rashin adalci na yan'adam, wadanda suke danne gaskiya ta wurin rashin adalcin su. ");
INSERT INTO hauulb_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Dalili kuwa abinda yakamata a sani game da Allah a bayyane ya ke a gare su. Domin kuwa Allah ya bayyana masu shi a zahiri. ");
INSERT INTO hauulb_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Domin al'amuransa da ba'a iya gani a bayyane suke tun halittar duniya. A na iya gane su ta wurin halitatattun abubuwa. Wadannan al'amura kuwa sune madawwamin ikonsa da Allahntakarsa. Sakamakon haka, wadannan mutane ba su da hujja. ");
INSERT INTO hauulb_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Dalili kuwa, koda suna jin sun san Allah, amma basu darajanta shi a matsayin Allah ba, ko kuma su nuna masa godiya. Maimakon haka, suka zama wawaye a cikin tunaninsu, zukatansu marasa tunani sun duhunta. ");
INSERT INTO hauulb_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Suna daukar kansu akan masu hikima ne su, amma sai ga su sun zama wawaye. ");
INSERT INTO hauulb_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Sun musanya daukakar Allah madawwami da ta kamannin abubuwan da basa dawwama, kamar mutum, da tsuntsaye, da dabbobi masu kafafu hurhudu, da masu jan ciki. ");
INSERT INTO hauulb_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Saboda haka Allah ya bashe su ga sha'awoyin kazantar zukatansu, su wulakantar da jukunansu a junansu. ");
INSERT INTO hauulb_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Sune suka musanya gaskiyar Allah da karya, Kuma suke sujada da bauta ga halittaccen abu, maimakon Mahaliccin, Wanda yake abin yabo har abada. Amin. ");
INSERT INTO hauulb_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Saboda haka Allah ya bashe su, ga sha'awowin su na lalata da wulakanci, har matansu suka canza ka'idar jima'i da aka saba zuwa madigo mace da mace. ");
INSERT INTO hauulb_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Mazajensu ma suka sauya ka'idar jima'i tsakanin mace da miji zuwa namiji da namiji suna yin aikin lalata. Maza su na kwana da maza suna aikata aikin ban kyama, suna kuwa girbe sakamakon aiknsu na ban kyama. ");
INSERT INTO hauulb_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Tunda shike ba su amince da Allah a cikkin al'amuransu ba, Allah ya bashe su ga bataccen hankalinsu, su aikata wadannan munanan abubuwa. ");
INSERT INTO hauulb_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Suna cike da dukkan rashin adalci, mugunta, kyashi, keta, kuma cike da kishi, kisan kai, tarzoma, makirci, da kuma munanan manufafofi. ");
INSERT INTO hauulb_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","Masu gulma da kage, makiyan Allah. Masu tada zaune tsaye, masu taurin kai, da ruba, masu kaga kowadanne miyagun abubuwa, kuma masu kin yin biyayya ga iyayensu. ");
INSERT INTO hauulb_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Masu duhun zuciya; masu cin amana, marasa soyayya, da kuma rashin tausayi. ");
INSERT INTO hauulb_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Suna sane da tsarin Allah cewa masu yin irin wadannan al'amura sun cancanci hukuncin mutuwa. Ba kuwa yin wadannan abubuwan ka dai suke yi ba, harma goyon bayan masu yinsu suke yi. ");
INSERT INTO hauulb_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Saboda da haka baka da hujja, kai mutum, kai mai shara'antawa, domin kuwa abinda kake shara'antawa akan wasu kana kada kanka da kanka. Domin kuwa kai mai shar'antaawa kana aikata wadannan abubuwa. ");
INSERT INTO hauulb_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Amma mun san cewa shari'ar Allah ta gaskiya ce sa'adda zata fado wa masu aikata wadannan irin abubuwa. ");
INSERT INTO hauulb_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Amma ka lura da wannan, ya kai mutum, mai shara'anta masu aikata wadannan ababuwa. Duk da shike kaima kana aikatawa. Kana jin zaka kubucewa hukuncin Allah? ");
INSERT INTO hauulb_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Ko kana raina falalar alheransa da yake yi ta wajen jinkirin hukuncinsa, da hakurinsa? Baka san cewa alheransa musanman domin su kai ka ga tuba bane? ");
INSERT INTO hauulb_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Amma saboda taurin kanka da zuciyarka marar tuba, kana tanadarwa kanka fushi, a ranar fushi, wato ranar bayyanuwar shari'ar adalci ta Allah. ");
INSERT INTO hauulb_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Zai baiwa kowanne mutum daidai sakamakon ayyukansa: ");
INSERT INTO hauulb_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Ga wadanda kuma suka nace da yin ayyukan alheri ba fasawa, sun samarwa kansu, yabo da daraja, da rai na har'abada. ");
INSERT INTO hauulb_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Amma ga masu son kai, wadanda suka ki yin biyayya ga gaskiya, suka yiwa rashin adalci biyayya, fushi da hasala mai zafi zai afko masu. ");
INSERT INTO hauulb_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Allah kuma zai sauko da bala'i da bakin ciki ga dukkan rayukan da suka aikata mugunta, ga Yahudawa da fari, sannan kuma Hellinawa. ");
INSERT INTO hauulb_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Amma yabo daraja da salama zasu kasance ga dukkan wadanda suka aikata ayukan alheri, ga Yahudawa da fari sannan Hellanawa. ");
INSERT INTO hauulb_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Domin kuwa Allah ba mai tara bane. ");
INSERT INTO hauulb_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Ga wadanda suka yi zunubi batare da shari'aba, zasu hallaka ba tare da shari'a ba, ga wadanda suka yi zunubi cikin shari'a kuma za'a hukunta su bisa ga shari'a. ");
INSERT INTO hauulb_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Domin kuwa ba masu jin shari'ar ne masu adalci agaban Allah ba, amma masu aikatawa ne zasu samu barata. ");
INSERT INTO hauulb_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Gama al'umai da basu san shari'a ba, bisa ga dabi'a sun yi abinda ke na shari'a, sun kuma zame wa kansu shari'a, koda shike basu da shari'ar. ");
INSERT INTO hauulb_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Dalilin haka kuwa sun nuna cewa ayukan da shari'a take bukata na nan a rubuce a zuciyarsu. lamirinsu kuma na yi masu shaida, tunanainsu kuma, ko dai yana kashe su, ko kuma yana karesu. ");
INSERT INTO hauulb_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","hakanan kuma ga Allah. Wannan zai faru ranar da Allah zai shara'anta asiran boye na dukkan mutane, bisa ga bishara ta cikin Yesu Almasihu. ");
INSERT INTO hauulb_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Da shike kana kiran kanka Bayahude, kana zaune akan shari'a, kana alfahari cikin Allah, ");
INSERT INTO hauulb_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","ka san nufinsa, ka kuma san abubuwan da suka bambanta da hakan, ka kuma sami koyarwa cikin shari'ar. ");
INSERT INTO hauulb_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Da shike kana da gabagadi akan cewa kai jagora ne ga makafi, haske ga wadanda suke cikin duhu, ");
INSERT INTO hauulb_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","mai horo ga marasa hikima, mai koyar da jarirai, kuma a cikin shari'ar kana da abin da ya shafi sani da kuma gaskiya. ");
INSERT INTO hauulb_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","ku da kuke koyar da wadansu, ba ku koyar da kanku? ku da kuke wa'azi kada ayi sata, ba ku yin sata? ");
INSERT INTO hauulb_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Ku da ke wa'azi kada ayi zina, ba ku yin zina? ku da ke hana bautar gumaka, ba ku yin sata a haikali? ");
INSERT INTO hauulb_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","ku masu murna da tinkaho cikin shari'ar, ba kwa wulakanta Allah cikin kurakuranku na rashin bin shari'a? ");
INSERT INTO hauulb_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","''Domin kuwa an wulakanta sunan Allah cikin Al'umai sabili da ku,'' kamar yadda aka riga aka rubuta. ");
INSERT INTO hauulb_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Lallai kuwa kaciya tana da riba a gare ku, idan kuka kiyaye doka, amma idan ku marasa bin doka ne kaciyarku ta zama rashin kaciya. ");
INSERT INTO hauulb_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","domin kuwa idan mutum marar kaciya zai kiyaye dukkan bukatun doka, baza'a iya daukan rashin kaciyarsa a matsayin mai kaciya ba? ");
INSERT INTO hauulb_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Sannan idan mutum marar kaciya ta jini zai kiyaye dukkan dokoki, ba zai iya shara'anta ku masu kaciya ta shari'a ba? Haka kuma ya kasance ne domin kuna da shari'a a rubuce da kuma kaciya amma ba kwa bin doka! ");
INSERT INTO hauulb_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Domin shi kuwa ba Bayahude bane a waje; ba kuwa mai kaciyar da aka tsaga fata ba. ");
INSERT INTO hauulb_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Amma Bayahude ne ta ciki, sanna kuma mai kaciyar zuciya da kuma ruhu ba wasika ba, irin wanna mutumin yabonsa ba daga wurin mutane yake zuwa ba, amma daga Allah. ");
INSERT INTO hauulb_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","To ina fifikon da bayahude yake dashi? Kuma ina ribar kaciya? ");
INSERT INTO hauulb_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Akwai muhimmancinsu ta kowacce hanya. Tun farko dai, yahudawa ne aka dankawa wahayi daga Allah. ");
INSERT INTO hauulb_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Idan wasu yahudawa basu bada gaskiya ba fa? Rashin bangaskiyarsu zai hana amincin Allah aiki? ");
INSERT INTO hauulb_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Bazai taba zama haka ba. Maimakon haka, bari Allah ya zama mai gaskiya, ko da kowanne mutum makaryaci ne. Kamar yadda aka rubuta, “Domin a nuna kai mai adalci cikin maganganunka, kuma kayi nasara a lokacin da aka kawo ka gaban shari'a.” ");
INSERT INTO hauulb_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Amma idan rashin adalcinmu ya nuna adalcin Allah, to me zamu ce? Allah ba marar adalci ba ne, wanda ke aiwatar da fushinsa, ko kuwa? Ina magana bisa ga tunanin mutuntaka. ");
INSERT INTO hauulb_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Bazai taba zama haka ba. Domin idan haka ne ta yaya Allah zai shar'anta duniya? ");
INSERT INTO hauulb_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Amma idan gaskiyar Allah ta wurin karyata ta habaka yabonsa, To me yasa ake shar'anta ni a matsayin mai zunubi? ");
INSERT INTO hauulb_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","To me zai hana ace kamar yadda ake fadin zancen karya a kanmu, wasu kuma sun dauka cewa mun fadi hakan, “Bari muyi mugunta, domin nagarta tazo?” Hukuncin su halal ne. ");
INSERT INTO hauulb_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","To me kenan? Zamu ba kanmu hujja ne? ko kadan. Domin mun riga munyi zargin yahudawa da hellinawa, da cewar dukkansu, suna karkashin zunubi. ");
INSERT INTO hauulb_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Kamar yadda aka rubuta, babu wani mai adalci, babu ko daya. ");
INSERT INTO hauulb_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Babu wani mai fahimta. Babu wani mai neman Allah. ");
INSERT INTO hauulb_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Dukansu sun kauce hanya, dukansu gaba daya sun zama marasa amfani. Babu mai aikin nagarta, a'a, babu ko da guda daya. ");
INSERT INTO hauulb_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Makogwaronsu a bude yake kamar kabari. Harsunansu na dauke da cuta. Dafin macizai na karkashin lebunansu. ");
INSERT INTO hauulb_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Bakunansu cike suke da la'ana da daci. ");
INSERT INTO hauulb_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Sawayensu na saurin zuwa zubar da jini. ");
INSERT INTO hauulb_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Tafarkinsu wahala ce da lalacewa. ");
INSERT INTO hauulb_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Wadannan mutane basu san hanyar salama ba. ");
INSERT INTO hauulb_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Babu tsoron Allah a idanunsu.” ");
INSERT INTO hauulb_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","To mun san dai duk abin da shari'a tace, shari'a na magana ne da wadanda ke karkashinta, domin a rufe kowanne baki, domin dukan duniya ta bada amsa a gaban Allah. ");
INSERT INTO hauulb_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Domin a gabansa babu wanda zai barata ta wurin ayukan shari'a. Domin ta wurin shari'a ne sanin zunubi yazo. ");
INSERT INTO hauulb_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Amma yanzu ba tare da shari'a ba an bayyana sanin adalcin Allah, wanda shari'a da annabawa suke shaidawa. ");
INSERT INTO hauulb_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Wato, adalcin Allah ta wurin bangaskiya cikin Yesu Almasihu ga dukkan wadanda ke bada gaskiya. Domin babu bambanci: ");
INSERT INTO hauulb_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Domin duk sun yi zunubi sun kuma kasa kaiwa ga darajar Allah, ");
INSERT INTO hauulb_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Da alherinsa an baratar da mu ta wurin fansar dake cikin Yesu Almasihu. ");
INSERT INTO hauulb_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Amma Allah ya bayar da Yesu Almasihu wanda yake hadayar fansa ta wurin bangaskiya cikin jininsa. Ya mika Almasihu a matsayin tabbacin hukuncinsa, sabo da kuma ketarewar zunubanmu na baya ");
INSERT INTO hauulb_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","cikin hakurinsa. Duk wannan ya faru ne domin a bayyana adalcinsa cikin wannan zamani, domin ya tabbatar da kansa mai hukunci, kuma ya nuna shine mai baratar da kowa saboda bangaskiya cikin Yesu. ");
INSERT INTO hauulb_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","To ina fahariya? An fitar da ita. A kan wane dalilin? Don ayyuka? A'a, amma ta dalilin bangaskiya. ");
INSERT INTO hauulb_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Domin wannan muka kammala cewar ana baratar da mutum ta wurin bangaskiya ba tare da ayyukan shari'a ba. ");
INSERT INTO hauulb_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Ko kuwa Allah Allahn yahudawa ne kadai? Shi ba Allahn al'ummai bane? I, na al'ummai ne kuma. ");
INSERT INTO hauulb_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Idan dai lallai Allah daya ne, zai baratar da mai kaciya ta wurin bangaskiya, da marar kaciya kuma ta wurin bangaskiya. ");
INSERT INTO hauulb_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Mun kawar da shari'a kenan ta wurin bangaskiya? ba zai taba kasancewa haka ba. Maimako ma, muna inganta shari'a kenan. ");
INSERT INTO hauulb_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Me kenan zamu ce game da Ibrahim, kakanmu a jiki, me ya samu? ");
INSERT INTO hauulb_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Domin idan Ibrahim ya sami kubutarwa ta wurin ayuka, ai da ya sami dalilin fahariya, amma ba a gaban Allah ba. ");
INSERT INTO hauulb_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Kuma fa me nassi ke fadi? “Ibrahim ya bada gaskiya ga Allah, sai aka lisafta ta adalci gare shi.” ");
INSERT INTO hauulb_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Yanzu fa shi dake yin ayyuka, ladansa ba a lisafta shi alheri ba ne, amma abun da ke nasa. ");
INSERT INTO hauulb_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Amma kuma shi da bai da ayyuka kuma maimakon haka ya gaskanta ga wanda ke kubutar da masu zunubai, bangaskiyarsa an lisafta ta a misalin adalci. ");
INSERT INTO hauulb_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Dauda ya yi furcin albarka bisa mutumin da Allah ya lisafta mai adalci da rashin ayyuka. ");
INSERT INTO hauulb_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","Sai ya ce, “Masu albarka ne wadanda aka yafe laifofinsu, kuma wadanda zunubansu a rufe suke. ");
INSERT INTO hauulb_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Mai albarka ne mutumin da ko kadan Ubangiji ba zaya lisafta zunubin sa ba.” ");
INSERT INTO hauulb_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","To albarkar da aka fadi ko a bisansu wadanda aka yi wa kaciya ne kadai, ko kuwa a bisan su ma marasa kaciya? Domin mun yi furcin, “Bangaskiyar Ibrahim an lisafta ta adalci ce agare shi.” ");
INSERT INTO hauulb_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Yaya aka lisafta ta? Bayan Ibrahim ya yi kaciya, ko kuwa a rashin kaciya? Ba a cikin kaciya ba, amma a rashin kaciya. ");
INSERT INTO hauulb_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Ibrahim ya amshi alamar kaciya. Wannan shi ne hatimin adalcin bangaskiyar da ya ke da ita tun cikin rashin kaciyarsa. Albarkacin wannan alama ce, ta sa shi ya zama uban dukkan wadanda suka badagaskiya, ko da shike ba su da kaciya. Wato ma'ana, adalci za a lisafta masu. ");
INSERT INTO hauulb_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Wannan kuma yana da ma'anar cewa Ibrahim ya zama uban kaciya ga wadanda suka fito ba domin masu kaciya kadai ba, amma kuma domin wadanda ke biyo matakin ubanmu Ibrahim. Kuma wannan itace bangaskiyar da ya ke da ita a rashin kaciya. ");
INSERT INTO hauulb_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Domin ba ta wurin shari'a aka bada alkawarin nan da aka yi wa Ibrahim da zuriyarsa ba, wannan alkawarin da ya ce zasu gaji duniya. Maimako, a ta wurin adalcin bangaskiya ne. ");
INSERT INTO hauulb_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Domin idan su da ke na shari'a magada ne, bangaskiya bata da komai, kuma alkawarin an wofintar da shi kenan. ");
INSERT INTO hauulb_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Domin shari'a ta kan jawo fushi, amma ta wurin rashin shari'a, babu karya umarni. ");
INSERT INTO hauulb_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Saboda wannan dalili haka ta faru ta wurin bangaskiya, domin ya zama bisa ga alheri. Kamar haka, alkawarin ya tabbata ga dukkan zuriya. Kuma wannan zuriya ba zata kunshi wadanda suke da sanin shari'a ba kadai, har ma da wadanda ke daga bangaskiyar Ibrahim. Saboda shi ne uban dukkan kowa, ");
INSERT INTO hauulb_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","kamar yadda aka rubuta, “Na maishe ka uba ga kasashe masu yawa.” Ibrahim na gaban aminin sa, wato, Allah, mai bada rai ga mattatu kuma ya kan kira abubuwan da basu da rai su kuma kasance. ");
INSERT INTO hauulb_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Duk da halin da ke a bayyane, Ibrahim ya gaskata ga Allah kai tsaye game da abubuwan da ke nan gaba. Sai ya zama uba ga kasashe masu yawa, kamar yadda aka ambata, “... Haka zuriyarka zata kasance.” ");
INSERT INTO hauulb_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Ba ya karaya a bangaskiya ba. Ibrahim ya yarda da cewa jikinsa ya rigaya ya tsufa (shekarun sa na misalin dari). Ya kuma yarda da cewa mahaifar Saratu bata iya bada 'ya'ya ba. ");
INSERT INTO hauulb_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Amma domin alkawarin Allah, Ibrahim bai ji nauyin rashin bangaskiya ba. Maimakon haka, ya sami karfafawa a bangaskiyarsa sai ya daukaka Allah. ");
INSERT INTO hauulb_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Ya na da cikakkiyar gamsuwa cewa idan Allah ya yi alkawari, shi mai iya kammalawa ne. ");
INSERT INTO hauulb_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Haka nan ne kuma aka lisafta masa wannan a matsayin adalci. ");
INSERT INTO hauulb_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","To ba'a rubuta kawai damin amfaninsa kadai ba, da aka lisafta dominsa. ");
INSERT INTO hauulb_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","A rubuce yake domin mu, domin wadanda za'a lisafta su, mu da muka bada gaskiya gare shi wanda ya tada Yesu Ubangijinmu daga matattu. ");
INSERT INTO hauulb_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Wannan shi ne wanda aka bashe shi domin zunubanmu kuma an tada shi saboda fasar mu. ");
INSERT INTO hauulb_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Tun da shike mun sami barata, sabili da bangaskiya, mun sami salama tare da Allah ta wurin Yesu Almasihu. ");
INSERT INTO hauulb_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2",". Ta wurin sa kuma mun sami iso zuwa ga alheri inda muke tsayawa albarkacin bangaskiyarmu. Muna murna da gabagadin da Allah ya ba mu game da abin da zai faru, gabagadin da zamu dandana nan gaba cikin daukakar Allah. ");
INSERT INTO hauulb_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Ba kuwa haka kadai ba, amma muna murna da shan wahalolinmu. Mun san cewa shan wuya na haifar da ");
INSERT INTO hauulb_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","Jimiri, Jimiri kuma na kawo amincewa, amincewa na kawo gabagadi game da abin da zai zo nan gaba. ");
INSERT INTO hauulb_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Wannan gabagadi wato begen da muke da shi baya kunyatarwa, domin kuwa an kwarara mana kaunar Allah a cikin zuciyarmu ta wurin Ruhu Mai Tsarki, da aka ba mu. ");
INSERT INTO hauulb_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Domin kuwa ko yayin da muke raunana, Almasihu ya mutu a lokacin da ke dai dai domin marasa ibada. ");
INSERT INTO hauulb_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","To ai kuwa yana da wuya kwarai wani mutum ya yarda ya mutu don mutumin kirki ma. Watakila, wani na iyayin kasada ya yarda ya mutu don nagarin mutum. ");
INSERT INTO hauulb_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Amma Allah ya tabbatar mana da kaunarsa a gare mu, don kuwa tun muna masu zunubi, Almasihu ya mutu domin mu. ");
INSERT INTO hauulb_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Balle ma yanzu, da muka barata ta wurin jininsa, za mu sami tsira daga fushin Allah. ");
INSERT INTO hauulb_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Domin kuwa, in tun muna makiya, aka sulhunta mu da Allah ta wurin mutuwar Dansa, balle ma, yanzu da muka sami sulhu, zamu sami tsira ta wurin ransa. ");
INSERT INTO hauulb_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Bama haka kadai ba, amma muna murna a cikin Allah ta wurin Ubangijinmu Yesu Almasihu, wanda ta wurinsa ne muka sami wannan sulhu. ");
INSERT INTO hauulb_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Saboda haka, kamar yadda ta wurin mutum daya zunubi ya shigo cikin duniya, ta haka mutuwa ta shigo ta dalilin zunubi. ");
INSERT INTO hauulb_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Domin kuwa tun kafin a bada shari'a, zunubi na nan a duniya, amma ba' a lissafin zunubi in da ba shari'a. ");
INSERT INTO hauulb_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Duk da haka, mutuwa ta mallake tun daga Adamu har Musa, har ma wadanda basu yi zunubin keta umarni irin na Adamu ba, wanda yake misalin mai zuwan nan a gaba. ");
INSERT INTO hauulb_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Amma kyautar ba kamar keta umarnin take ba. Domin in sabo da laifin mutum dayan nan ne, da yawa suke mutuwa, haka ma alherin sa da baiwarsa ta wurin mutum dayan nan, Yesu Almasihu, sai baiwar ta wadata zuwa ga masu yawa. ");
INSERT INTO hauulb_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Domin kyautar ba kamar sakamakon wannan da yayi zunubin bace. Ta haka din nan ne, hukuncin nan mai tsanani ya zo sabo da zunubin mutum dayan. Har yanzu dai, wannan baiwa ta yanci ta zo ne bayan laifuffuka masu yawa. ");
INSERT INTO hauulb_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Domin, idan sabo da laifin mutum dayan nan ne, mutuwa ta mallake, saboda dayan, haka ma wadanda suka karbi alheri mai yawa da kuma baiwar adalci ta wurin ran, Yesu Almasihu. ");
INSERT INTO hauulb_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Don haka, kamar yadda zunubin dayan ya sa hukunci ya zo kan dukka, haka ma aikin adalci na dayan zai kawo barata da rai ga mutane masu yawa. ");
INSERT INTO hauulb_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Kuma kamar yadda rashin biyayyar dayan ta sa mutane masu yawan gaske su zama masu zunubi, haka ma ta biyayyar dayan mutane da yawan gaske za su sami adalci. ");
INSERT INTO hauulb_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Amma shari'a ta zo, inda ta sa zunubi ya habaka. Amma inda zunubi ya habaka, alheri ma ya habaka ribin ribi. ");
INSERT INTO hauulb_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Wannan ya faru ne, don kamar yadda zunubi yai mallaka zuwa mutuwa, haka kuma alheri ya mallaka zuwa adalci da rai na har abada ta wurin Yesu Almasihu Ubangijin mu. ");
INSERT INTO hauulb_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Me kuwa zamu ce yanzu? Sai mu ci gaba da yin zunubi domin Alheri ya yawaita? ");
INSERT INTO hauulb_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Ba zai taba faruwa ba. 'Yaya za'ace mu da muka mutu cikin zunubi mu ci gaba da rayuwa cikin sa? ");
INSERT INTO hauulb_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Ba ku san cewa duk wadanda aka yi masu baftisma cikin Almasihu Yesu an yi masu baftisma har ya zuwa mutuwarsa ne ba? ");
INSERT INTO hauulb_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","An kuwa binne mu tare da shi, ta wurin baftisma cikin mutuwarsa. Haka kuma ya kasance ne domin kamar yadda Almasihu ya tashi daga matattu cikin daukakar Uba. Sakamakon haka muma zamu yi tafiya cikin sabuwar rayuwa. ");
INSERT INTO hauulb_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Domin kuwa idan muna tare dashi cikin kamannin mutuwarsa zamu kuwa zauna tare dashi har ga kamannin tashinsa. ");
INSERT INTO hauulb_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Mun kuma san cewa, an giciye wannan tsohon mutunmin nan namu tare dashi, domin a hallaka jikin zunubi. wanna kuwa ya kasance ne domin kada mu ci gaba da bautar zunubi. ");
INSERT INTO hauulb_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Duk kuma wanda ya mutu an ambace shi a matayin adali akan zunubi. ");
INSERT INTO hauulb_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Amma idan muka mutu tare da Almasihu, mun bada gaskiya zamu yi rayuwa tare dashi. ");
INSERT INTO hauulb_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Muna da sanen cewa an tada Almasihu daga matattu, don haka kuwa ba matacce yake ba. Mutuwa kuma bata da iko a kansa. ");
INSERT INTO hauulb_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Game da mutuwar da yayi ga zunubi yayi sau daya kuma domin dukka. Rayuwar da yake yi kuma yana yi wa Allah ne. ");
INSERT INTO hauulb_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Don haka ku ma sai ku dauki kanku a matsayin matattu ga zunubi amma rayayyu ga Allah cikin Almasihu Yesu. ");
INSERT INTO hauulb_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Sabili da haka kada ku bar zunubi yayi mulki a cikin jikinku, har ku yi biyayya ga sha'awarsa. ");
INSERT INTO hauulb_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Kada ku mika gabobin jikinku ga zunubi a matsayin kayan aikin rashin adalci. Amma ku mika kanku ga Allah rayayyu daga mutuwa. Ku kuma mika gabobin jikinku ga Allah a matsayin kayan aiki na adalci. ");
INSERT INTO hauulb_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","kada ku ba zunubi dama yayi mulki a kanku, domin ba karkashin doka kuke ba, amma karkashin alheri kuke. ");
INSERT INTO hauulb_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","To sai me? Sai mu yi zunubi wai don ba a karkashin doka muke ba amma alheri. ba zai taba faruwa ba. ");
INSERT INTO hauulb_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Ba ku san cewa duk ga wanda kuka mika kanku a matsayin bayi, a gareshi ku bayi ne ba? Wannan fa gaskiya ne, ko dai ku bayi ne ga zunubi wanda kaiwa ga mutuwa ko kuma bayi ga biyayya wanda ke kaiwa ga adalci. ");
INSERT INTO hauulb_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Amma godiya ta tabbata ga Allah! domin da ku bayin zunubi ne, amma kun yi biyayya daga zuciyarku irin salon koyarwar da aka baku. ");
INSERT INTO hauulb_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","An 'yantar daku daga bautar zunubi, an kuma maishe ku bayin adalci. ");
INSERT INTO hauulb_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Ina magana da ku kamar mutum, domin kasawarku ta nama da jini. Kamar yadda kuka mika gabobin jikinku ga kazamta da miyagun ayyuka, haka ma yanzu ku mika gabobin jikinku a matsayin bayi na adalci. ");
INSERT INTO hauulb_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Domin a lokacin da kuke bayin zunubi, ku yantattu ne ga adalci. ");
INSERT INTO hauulb_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","A wannan lokacin wanne amfani kuka samu na ayyukan da yanzu kuke jin kunyarsu? Domin kuwa sakamakon wadannan ayyuka shine mutuwa. ");
INSERT INTO hauulb_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Amma yanzu da da aka yantar daku daga zunubi aka mai da ku bayin Allah, amfaninsa ku kuwa shine tsarkakewarku. Sakamakon kuwa shine rai na har abada. ");
INSERT INTO hauulb_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Don kuwa sakamakon zunubi mutuwa ne. Amma kyautar Allah itace rai madauwami cikin Almasihu Yesu Ubangijinmu. ");
INSERT INTO hauulb_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","'Yan'uwa, ko baku sani ba (domin ina magana da wadanda suka san shari'a), cewar shari'a na mulkin mutum muddin ransa? ");
INSERT INTO hauulb_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Domin ta wurin shari'a matar aure a daure take muddin mijinta nada rai, amma idan mijinta ya mutu, ta kubuta daga shari'ar aure. ");
INSERT INTO hauulb_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","To don haka idan, mijinta na da rai, sai ta tafi ta zauna da wani mutumin, za'a kirata mazinaciya. Amma idan mijin ya mutu, ''yantarciya ce daga shari'a, domin kada ta kasance mazinaciya idan ta auri wani mutum. ");
INSERT INTO hauulb_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Domin wannan, 'yan'uwana, ku ma an sa kun mutu ga shari'a ta wurin jikin Almasihu, saboda a hada ku aure da wani, wato, ga wanda aka tashe shi daga matattu, domin mu haifawa Allah 'ya'ya. ");
INSERT INTO hauulb_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Domin sa'adda muke cikin jiki, ana motsa dabi'armu ta zunubi dake cikin jikunan mu ta wurin shari'a domin mu haifi 'ya'ya zuwa mutuwa. ");
INSERT INTO hauulb_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Amma yanzu an kubutar damu daga shari'a, mun mutu daga abin da ya daure mu, domin mu yi bauta cikin sabuntuwar Ruhu, ba cikin tsohon rubutun shari'a ba. ");
INSERT INTO hauulb_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","To me zamu ce kenan? ita shari'ar kanta zunubi ce? ba zai taba faruwa ba. Duk da haka. Idan ba ta wurin shari'a ba, ba zan taba sanin zunubi ba, in ba ta wurin shari'a ba. Ba zan taba kyashin abin wani ba, har sai da shari'a tace, “Kada kayi kyashi.” ");
INSERT INTO hauulb_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Amma zunubi, sai ya dauki zarafi ta wurin dokar, ya jawo dukkan sha'awa dake cikina. Domin in da babu shari'a, zunubi matacce ne. ");
INSERT INTO hauulb_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Ada na rayu sau daya ba tare da shari'a ba, amma da dokar ta zo, sai zunubi ya farfado, ni kuma na mutu. ");
INSERT INTO hauulb_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","Dokar wadda ta kamata ta kawo rai, sai na same ta matacciya. ");
INSERT INTO hauulb_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Domin zunubin, ya dauki zarafi ta wurin dokar, ya rude ni, kuma ta wurin dokar ya kashe ni. ");
INSERT INTO hauulb_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Domin haka, shari'ar na da tsarki, dokar na da tsarki, adalci da kuma kyau. ");
INSERT INTO hauulb_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","To abu mai kyau ya zamar mani mutuwa kenan? ba zai taba zama haka ba. Amma zunubi, domin ya nuna shi zunubi ne ta wurin abin da ke mai kyau, sai ya kawo mutuwa a cikina. Wannan ya kasance haka ne domin ta wurin dokar, zunubi ya zama cikakken zunubi. ");
INSERT INTO hauulb_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Domin mun san shari'a mai Ruhaniya ce, amma ni ina cikin jiki. An sai da ni karkashin bautar zunubi. ");
INSERT INTO hauulb_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Domin ni ma ban fahimci abin da nake aikatawa ba. Domin abin da nake so in aikata, ba shi nake aikatawa ba, kuma abin da bana so, shi nake aikatawa. ");
INSERT INTO hauulb_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Amma idan na aikata abin da bana so, na amince da shari'a kenan, cewar shari'a nada kyau. ");
INSERT INTO hauulb_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Amma yanzu ba ni ke aikata abin ba, amma zunubi da ke zaune a cikina. ");
INSERT INTO hauulb_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Domin na san a cikina, wato cikin jikina, babu wani abu mai kyau. Domin marmarin aikata abu mai kyau na tare da ni, amma ba ni iya aikatawa. ");
INSERT INTO hauulb_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Domin abu mai kyau da na ke so in aikata bana iyawa, amma muguntar da ba na so ita na ke aikatawa. ");
INSERT INTO hauulb_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","To idan na yi abin da ba ni so in aikata, wato kenan ba ni bane ke aikatawa, amma zunubin da ke zaune a cikina. ");
INSERT INTO hauulb_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Don haka, sai na iske, akwai ka'ida a cikina dake son aikata abu mai kyau, amma kuma ainihin mugunta na tare dani. ");
INSERT INTO hauulb_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Domin a cikina ina murna da shari'ar Allah. ");
INSERT INTO hauulb_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","Amma ina ganin wasu ka'idoji daban a gabobin jikina, su na yaki da wannan sabuwar ka'idar da ke cikin tunanina, suna kuma sanya ni bauta ta wurin ka'idar zunubi wadda ke cikin gabobin jikina. ");
INSERT INTO hauulb_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Ni wahalallen mutum ne! wa zai kubutar dani daga wannan jiki na mutuwa? ");
INSERT INTO hauulb_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Amma godiya ga Allah ta wurin Yesu Almasihu Ubangijinmu! Domin haka ni kaina a wannan hannu bisa ga tunani na ina bautawa shari'ar Allah. Duk da haka, ta wani gefen ina bautawa ka'idar zunubi da ke tare da jikina. ");
INSERT INTO hauulb_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Saboda haka babu kayarwa yanzu ga wadanda ke cikin Almasihu Yesu. ");
INSERT INTO hauulb_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Domin ka'idar ruhun rai a cikin Almasihu Yesu ta maishe mu 'yanttatu daga ka'idar zunubi da mutuwa. ");
INSERT INTO hauulb_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Saboda abin da shari'a bata iya aikatawa ba domin kasawa ta wurin jiki, Allah ya yi. Ya aiko da dansa a kamanin jiki mai zunubi domin ya zama hadaya domin zunubi, sai ya yi Allah wadai da zunubi a cikin jiki. ");
INSERT INTO hauulb_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Ya yi haka domin bukatar shari'a ta sami cika a cikinmu, mu da muke tafe ba ta gwargwadon jiki ba, amma ta gwargwadon ruhaniya. ");
INSERT INTO hauulb_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Wadanda ke rayuwa gwargwadon jiki sukan lura da al'amuran jiki, amma su da ke rayuwa a gwargwadon Ruhu sukan mai da hankali ga al'amuran Ruhu. ");
INSERT INTO hauulb_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","To kwallafa rai ga jiki mutuwa ce, amma kwallafa rai ga Ruhu rai ne da salama. ");
INSERT INTO hauulb_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Haka yake domin kwallafa rai ga jiki gaba yake da Allah, gama baya biyyaya ga shari'ar Allah, balle ma ya iya. ");
INSERT INTO hauulb_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Wadanda ke a jiki ba su iya faranta wa Allah zuciya. ");
INSERT INTO hauulb_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Duk da haka, ba ku cikin jiki amma a cikin Ruhu, idan gaskiya ne, Ruhun Allah na rayuwa cikinku. Amma idan wani ba shi da Ruhun Almasihu, shi ba na sa bane. ");
INSERT INTO hauulb_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","In Almasihu na cikinka, jikin ka fa matacce ne ga zunubi, amma ruhu na rayuwa bisa ga adalci. ");
INSERT INTO hauulb_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Idan Ruhun wanda ya tada Yesu daga matattu na raye a cikinku, to shi wanda ya tada Almasihu da ga matattu za ya bada rai ga jikinku masu matuwa ta wurin Ruhunsa, da ke rayuwa a cikin ku. ");
INSERT INTO hauulb_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","To, 'yan' uwa, muna da hakki amma ba bisa jiki ba, da za mu yi rayuwa bisa ga dabi'ar jiki. ");
INSERT INTO hauulb_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Gama idan kun yi rayuwa gwargwadon jiki, za ku mutu kenan, amma idan ta wurin Ruhu ku ka kashe ayyukan jiki, za ku rayu. ");
INSERT INTO hauulb_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Gama duk wadanda Ruhun Allah ke bishe su, su 'ya 'yan Allah ne. ");
INSERT INTO hauulb_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Gama ba ku karbi ruhun bauta da ke sa tsoro ba. Maimakon haka, kun karbi ruhun diyanci, ta wurinsa muke tadda murya muna kira, “Abba, Uba!” ");
INSERT INTO hauulb_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","kansa na bada shaida tare da namu ruhun cewa mu 'ya'yan Allah ne. ");
INSERT INTO hauulb_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Idan mu 'ya'ya ne, ai mu magada ne kenan, magadan Allah. Kuma mu magada ne tare da Almasihu, hakika idan mun sha wahala tare da shi za a kuma daukaka mu tare da shi. ");
INSERT INTO hauulb_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Gama na yi la'akari cewa wahalonin zamanin nan ba su isa a kwatanta su da daukakar da za'a bayyana mana ba. ");
INSERT INTO hauulb_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Saboda yadda halitta ke marmarin bayyanuwar 'ya'yan Allah. ");
INSERT INTO hauulb_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Gama an kaskantar da halitta ga banza, ba da nufin ta ba, amma na shi wanda ya kaskantar da ita. Ta na cikin tabbacin alkawarin. ");
INSERT INTO hauulb_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","Cewa halitta kanta za ta kubuta daga bautar rubewa, kuma za a kawo ta zuwa ga 'yantarwa na yabon daukakar 'ya'yan Allah. ");
INSERT INTO hauulb_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Gama mun sani dukan halitta na nishi da zafin nakuda tare har ya zuwa yanzu. ");
INSERT INTO hauulb_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Ba haka kadai ba, amma ko mu kanmu, da ke nunar farko na Ruhu—mu kanmu muna nishi acikin mu, muna jiran diyancinmu, wato ceton jikinmu kenan. ");
INSERT INTO hauulb_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Gama ta wanan hakikancewa aka cece mu. Amma dai abin da muke da tabbacin zai faru ba mu gan shi ba tukuna, domin wanene wa ke begen tabbatacce abin da yake gani? ");
INSERT INTO hauulb_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Amma idan muna da tabbacin abin da ba mu gani ba tukuna, to sai mu jjira shi da hakuri. ");
INSERT INTO hauulb_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Hakanan, Ruhu kuma ke taimako a kasawarmu. Gama ba mu da san yadda zamu yi addu'a ba, amma Ruhu kansa na roko a madadinmu da nishe-nishen da ba'a iya ambatawa. ");
INSERT INTO hauulb_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Shi da ke bidar zuciya yana sane da tunanin Ruhu, domin yana roko a madadin masu badagaskiya ta wurin nufin Allah. ");
INSERT INTO hauulb_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Mun san cewa ga wadanda ke kaunar Allah, yakan aikata dukan al'amura domin su zuwa ga alheri, ga duk wadanda aka kira bisa ga nufinsa. Dukan abubuwa sukan zama alheri. ");
INSERT INTO hauulb_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Saboda wadanda ya sani tuntuni su ne ya kardara su zama da kamanin dansa, domin ya zama dan fari a cikin 'yan'uwa masu yawa. ");
INSERT INTO hauulb_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Su da ya kaddara, ya kiraye su. Wadanda ya kira, su ya kubutar. Su da ya kubutar, sune kuma ya daukaka. ");
INSERT INTO hauulb_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Me zamu ce game da wadannan al'amura? Idan Allah na tare da mu, wake gaba da mu? ");
INSERT INTO hauulb_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Shi da baya hana dansa ba, amma ya bada shi a madadinmu dukka, me zai hana shi bamu dukkan abubuwa a yalwace tare da shi? ");
INSERT INTO hauulb_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Wa zaya kawo wata tuhuma ga zababbu na Allah? Allah ne ke “yantarwa. ");
INSERT INTO hauulb_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Wanene ke hukumtawa? Almasihu ne da ya mutu sabili da mu har ma fiye da haka, shi wanda kuma aka tasar. Yana mulki tare da Allah a wuri mai daukaka, shi ne kuma ya ke roko sabili da mu. ");
INSERT INTO hauulb_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Wa za ya raba mu da kaunar Allah? Kunci, ko bacin rai, ko tsanani, ko yunwa, ko tsiraci, ko hadari, ko takobi? ");
INSERT INTO hauulb_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Kamar yadda aka rubuta, “Saboda kai ake kisanmu dukkan yini. An mai da mu kamar tumaki yanka.” ");
INSERT INTO hauulb_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","A dukan al'amuran nan mun fi karfi a ce da mu masu nasara ta wurin shi da ke kaunar mu. ");
INSERT INTO hauulb_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Gama na tabata cewa ko mutuwa, ko rai, ko mala'iku, ko mulkoki, ko al'amuran yanzu, ko al'amura masu zuwa, ko iko, ");
INSERT INTO hauulb_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","ko tsawo, ko zurfi, kai ko wace irin halitta, ba su isa su raba mu da kaunar Allah, da ke a cikin Almasihu Yesu Ubangijin mu ba. ");
INSERT INTO hauulb_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Gaskiya ne nake gaskiya nake fada cikin Almasihu. Ba karya nake yi ba. Lamirina, na shaida a cikin Ruhu Mai Tsarki. ");
INSERT INTO hauulb_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","cewa ina da matukar bakin-ciki da takaici marar karewa a zuciyata. ");
INSERT INTO hauulb_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Dama ace, a la'anta ni, in rabu da Almasihu saboda 'yan'uwana, wato dangina da suke zuriyata bisa ga jiki. ");
INSERT INTO hauulb_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Sune Isra'ilawa, sun sami karbuwa, da daukaka, da baiwar shari'a, da yi wa Allah sujada, da alkawarai. ");
INSERT INTO hauulb_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Dukkan ubanni nasu ne daga cikinsu Almasihu ya fito bisa ga jiki- wanda shi ke Allah bisa kowa. Yabo ya tabbata a gare shi har abada. Amin. ");
INSERT INTO hauulb_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Amma ba wai alkawarin Allah ya kasa ba ne, ba dukkan Isra'ilawa ne suke Isra'ilawa na gaskiya ba. ");
INSERT INTO hauulb_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Haka nan, ba dukkan zuriyar Ibrahim ne 'ya'yansa ba. Amma ''ta wurin Ishiyaku ne za'a kira zuriyarka.'' ");
INSERT INTO hauulb_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Yana nuna mana cewa ba 'ya'yan jiki su ne 'ya'yan Allah ba. Amma 'ya'yan alkawari ne ake kirga su, kuma aka kebe su. ");
INSERT INTO hauulb_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Wanna ce kalmar alkawari, ''badi warhaka zan dawo, Saratu kuwa zata sami da.'' ");
INSERT INTO hauulb_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Amma ba wannan kadai ba, bayan Rifkatu ta dauki ciki daga gun mijinta, ubammu Ishiyaku. ");
INSERT INTO hauulb_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","Yaran nan kafin ma a haife su, balle ma a ce sun yi wani abu mai kyau ko laifi, saboda zaben da Allah yayi, bai danganta da abin da suka yi ba, ko don aiki ba, amma don shine mai kira— ");
INSERT INTO hauulb_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","kamar yadda Ya ce, mata, “babban zaya yiwa karamin bauta,'' haka nassi yace, ");
INSERT INTO hauulb_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","''Kamar yadda aka rubuta: “Yakubu na ke kauna, amma Isuwa na ki shi.” ");
INSERT INTO hauulb_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","To me zamu ce kenan? Allah ya yi rashin adalci kenan? Ko kadan. ");
INSERT INTO hauulb_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Gama ya ce wa Musa, ''Ina nuna jinkai ga wanda zan yi wa jinkai, zan ji tausayi ga wanda zan tausaya masa.'' ");
INSERT INTO hauulb_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Saboda haka, ba don wanda ke da aniya ba ne, ko kuwa wanda yake kokari ba, amma saboda Allah mai nuna jinkai. ");
INSERT INTO hauulb_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Gama nassi ya ce da Fir'auna, '' Saboda wannan dalilin ne, na tada kai, don in nuna ikona mai karfi a kanka, don sunana ya yadu ga dukkan duniya.'' ");
INSERT INTO hauulb_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Ta haka Allah ya nuna jinkansa ga wanda ya so, ya taurarar da zuciyar wanda ya ga dama. ");
INSERT INTO hauulb_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Za kuce mani, to don me, ''Yake kama mu da llaifi? Wa ya taba yin jayayya da nufinsa?'' ");
INSERT INTO hauulb_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","In ma mun duba, kai mutum wanene kai da zaka ja da Allah? Ko abin da aka gina zai ce wa magininsa, ''Don me yasa ka ginani haka?'' ");
INSERT INTO hauulb_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Ko maginin ba shi da iko akan yimbu daya da zai gina tukunya mai daraja, wata kuma tukunyar don kowanne irin aiki? ");
INSERT INTO hauulb_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","In ace Allah, dake niyyar nuna fushinsa da ikonsa, ya sanu, sai ya jure da matukar hakuri mai yawa da tukwanen fushi da ya shirya don hallakarwar fa? ");
INSERT INTO hauulb_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","To ko ma ya yi haka don ya nuna yalwar daukakarsa da take dauke da alheri, wanda ya shirya don daukakarsa tun farko? ");
INSERT INTO hauulb_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","Zai yiwu ma ya yi haka ne domin mu, mu da ya kira, ba ma daga cikin Yahudawa kadai ba, amma har ma daga cikin al'ummai? ");
INSERT INTO hauulb_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Kamar yadda ya ce a cikin littafin Yusha'u: ''zan kira wadanda ba mutanena ba mutanena, da kuma kaunatattunta wadanda ba kaunatattu ba. ");
INSERT INTO hauulb_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","Zai zama kuma a inda aka ce da su, “ku ba mutanena bane, za a kisa su 'ya'yan Allah mai rai.”' ");
INSERT INTO hauulb_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Ishaya ya yi kira game da Isra'ila, ''in a ce yawan 'ya'yan Isra'ila zasu zama kamar yashi a bakin teku, ragowarsu ne kawai za su sami ceto. ");
INSERT INTO hauulb_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","Ubangiji zai tabbatar da cikar kalmarsa a duniya, ba kuwa da dadewa ba. ");
INSERT INTO hauulb_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Yadda Ishaya ya rubuta ada, ''In da ba Ubangiji mai runduna bai bar mana zuriya ba, da zamu zama kamar Saduma, da kuma an maida mu kamar Gomarata. ");
INSERT INTO hauulb_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","To me za mu ce kenan? Ko al'ummai, da ba sa neman adalci, sun samu adalci ta wurin bangaskiya. ");
INSERT INTO hauulb_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","Amma Isra'ila, wadanda suka nemi adalcinsu ta wurin shari'a, ba su kai ga gaci ba. ");
INSERT INTO hauulb_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","To don me? don ba su neme shi da bangaskiya ba, amma ta ayyuka. Sun yi tuntube a kan dutse da zai sa laifi. ");
INSERT INTO hauulb_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","Kamar yadda aka rubuta, “Ga, shi na ajiye dutse a kan Sihiyona dutsen tuntube mai sa laifi. Ga wanda ya bada gaskiya gare shi ba zai ji kunya ba.” ");
INSERT INTO hauulb_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","'Yan'uwana, muradin zuciyata da dukkan addu'oi na ga Allah dominsu shine don su sami ceton. ");
INSERT INTO hauulb_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Domin na shaida game da su cewa suna da kwazo game da Allah, amma ba a kan sani ba. ");
INSERT INTO hauulb_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Don, ba su da sani akan adalcin Allah, suna kokarin tabbatar da adalcin kansu. Ba su bada kan su ga adalcin Allah ba. ");
INSERT INTO hauulb_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Gama Almasihu shi ne cikar doka zuwa ga adalci ga dukkan wadanda suka gaskata. ");
INSERT INTO hauulb_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Musa kam ya rubuta game da adalci da zai samu ta shari'a: ''mutumin da ya aikata adalcin shari'a, zai rayu ta wurin wannan adalcin.'' ");
INSERT INTO hauulb_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Amma adalcin da ya zo ta wurin bangaskiya yace, ''Kada ku ce a zuciyarku, wa zai hau zuwa sama?''(don ya sauko da Almasihu kasa). ");
INSERT INTO hauulb_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","Kada ku ce, ''Wa zai gangara zuwa kasa?'' (Wato wa zai fito da Almasihu daga cikin matattu). ");
INSERT INTO hauulb_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Amma me yake cewa? “ kalmar tana kusa da kai a cikin bakinka da kuma cikin zuciyarka.” Wato kalmar bangaskiya, wadda muke shaidawa. ");
INSERT INTO hauulb_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","Don idan da bakinka, ka shaida Yesu Ubangiji ne, kuma ka gaskata a zuciyarka cewa Allah ya tashe shi daga matattu, za ka sami ceto. ");
INSERT INTO hauulb_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Don da zuciya ne mutum yake gaskatawa zuwa ga adalci, da kuma baki ne yake shaida zuwa ga ceto. ");
INSERT INTO hauulb_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Don nassi na cewa, ''Duk wanda ya gaskata da shi ba zai ji kunya ba,'' ");
INSERT INTO hauulb_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Gama ba bambanci tsakanin Bayahude da Ba'al'ume. Gama dukkansu Ubangijinsu daya ne, Shi mayalwaci ne ga dukkan wanda ya kira shi. ");
INSERT INTO hauulb_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Duk wanda ya kira sunan Ubangiji zai sami ceto. ");
INSERT INTO hauulb_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","To ta yaya zasu kira ga wanda basu gaskata ba? Kuma ta yaya zasu gaskata ga wanda ba su taba jin labarinsa ba? ");
INSERT INTO hauulb_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Kuma ta yaya zasu ji in ba ayi masu wa'azi ba? Kuma ta yaya zasu yi wa'azin in ba an aike su ba? - Kamar yadda yake a rubuce, “Ina misalin kyau na kafafun wadanda ke shaida labarin farin ciki na abubuwa masu kyau!” ");
INSERT INTO hauulb_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Amma ba dukkansu ne suka ji bishara ba. Gama Ishaya ya ce, ''Ubangiji, wa ya gaskata da sakon? ");
INSERT INTO hauulb_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Saboda haka bangaskiya na zuwa ta wurin ji, jin kuwa daga maganar Almasihu. ");
INSERT INTO hauulb_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Amma na ce, “ko basu ji ba ne? I, tabbas'' muryarsu ta kai dukkan duniya, kuma kalmominsu sun kai har karshen duniya.'' ");
INSERT INTO hauulb_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","yau, na ce, ''Ko Isra'ila basu sani ba ne?'' Da farko Musa ya ce, “Zan sa kuyi fushi da kishi da abin da ba al'umma ba. Abin da nake nufi nan shine al'ummar da basu da fahinta, zan more su, in tayar maku da hankali.'' ");
INSERT INTO hauulb_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Amma Ishaya da karfin hali ya ce, ''Ga wadanda basu neme ni ba suka same ni. Na bayyana ga wadanda basu nemi ni ba. ");
INSERT INTO hauulb_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","''Amma ga Isra'ila kam ya ce, '' na mika hannu na ga masu rashin biyayya dukkan tsawon rana, domin su mutane ne masu taurin kai.'' ");
INSERT INTO hauulb_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Sai na ce, Allah ya ki mutanensa ne? Ba zai taba yiwuwa ba. Domin ni ma ba-Isra'ile ne, na zuriyar Ibrahim, a kabilar Bilyaminu. ");
INSERT INTO hauulb_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Allah bai ki mutanen sa da ya ke da rigyasaninsu ba. Ko kun san abin da nassi ya ce game da Iliya, yadda ya kai karar Isra'ila a gaban Allah? ");
INSERT INTO hauulb_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","Ya ce, ''Ubangiji, sun kashe annabawanka, sun rushe alfarwanka kuma, Ni kadai ne na rage, ga shi suna neman su kashe ni.'' ");
INSERT INTO hauulb_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Amma wacce amsa ce Allah ya ba shi? Ya ce, ''Ina da mutane dubu bakwai da na kebe don kaina, da ba su taba rusuna wa Ba'al ba.'' ");
INSERT INTO hauulb_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Ban da haka ma, ban da haka ma a wannan lokacin akwai sauran zabe na alheri. ");
INSERT INTO hauulb_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Amma tun da ta wurin alheri ne, ba ga ayyuka ba. In ba haka ba, alheri ba zai zama alheri ba kenan. ");
INSERT INTO hauulb_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Sai kuma me? Abin da Isra'ila ke nema, ba su samu ba, amma zababbun sun same shi, saura kuma sun taurare. ");
INSERT INTO hauulb_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","Kamar yadda yake a rubuce, ''Allah ya ba su ruhun rashin fahimta, ga idanu amma ba za su gani ba, ga kunnuwa amma ba za su ji ba, har zuwa wannan rana.'' ");
INSERT INTO hauulb_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Dauda kuma ya ce, ''bari teburinsu ya zama taru, da tarko, ya zama dutsen tuntube da abin ramako a gare su. ");
INSERT INTO hauulb_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Bari idanunsu ya duhunta domin kada su gani; bayansu kuma a duke kullum.'' ");
INSERT INTO hauulb_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Na ce, ''sun yi tuntube domin su fadi ne?'' Kada abu kamar haka ya faru. A maimakon haka, juyawa baya da suka yi ya sa, ceto ya zo ga Al'ummai, domin ya sa su kishi. ");
INSERT INTO hauulb_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Idan yanzu juyawa baya da sun yi ya zama arziki ga duniya, rashin su kuma arziki ga Al'ummai, yaya kwatancin girmansa zai kasance in sun zo ga kammala? ");
INSERT INTO hauulb_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Yanzu ina magana da ku ku da ke Al'ummai. Tunda yake ni ne manzo ga Al'ummai, ina kuma fahariya cikin hidimata. ");
INSERT INTO hauulb_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","Yana yiwuwa in sa ''yan'uwa na kishi, domin mu ceci wadansu su. ");
INSERT INTO hauulb_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Idan kinsu ya kawo sulhuntawa ga duniya, Karbarsu kuma zata zama yaya? Zata zama rai ne daga mutuwa. ");
INSERT INTO hauulb_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","'ya'yan farko sunan haka ma kakkabensu yake, Idan saiwar itace na nan, haka ma rassan za su zama. ");
INSERT INTO hauulb_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Amma idan an karye wasu daga cikin rassan, idan ku rassan zaitun na ainihi ne, da aka samu daga cinkinsu, kuma idan kuna da gado tare da su, acikin saiwar itacen zaitun din. ");
INSERT INTO hauulb_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","Kada ku yi fahariya a kan rassan. Amma idan kuka yi fahariya to ba ku bane masu karfafa saiwar amma saiwar ce ke karfafa ku. ");
INSERT INTO hauulb_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Kana iya cewa, ''An karye rassan domin a same ni a ciki.'' ");
INSERT INTO hauulb_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Wannan gaskiya ne! Saboda rashin bangaskiyarsu ne ya sa aka karye su daga rassan, amma ku tsaya da karfi acikin bangaskiyarku. Kada ku dauki kanku fiye da yadda ya kamata, amma ku ji tsoro. ");
INSERT INTO hauulb_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Domin idan Allah bai bar ainihin rassan ba, to ba zai bar ku ba. ");
INSERT INTO hauulb_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Ku duba yadda irin ayyuka masu tsananni na Allah. Ta daya hannun kuma, tsanannin kan zoa kan Yahudawa wadanda suka fadi. Har 'ila yau jinkai Allah ya zo maku, idan kun cigaba cikin alherinsa baza a sare ku ba. Amma in kun ki za a sare ku. ");
INSERT INTO hauulb_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Hakanan, idan ba su ci gaba cikin rashin bangaskiyarsu ba, za a maida su cikin itacen. Domin Allah zai iya sake maida su. ");
INSERT INTO hauulb_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Idan an yanke ka daga itacen zaitun da ke na jeji, har ya yiwu an hada ka cikin itacen zaitun na ainihi, yaya kuma wadannan Yahudawa wadanda sune ainihin rassan, da za'a maido cikin zaitun da ke na ainihi? ");
INSERT INTO hauulb_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Yan'uwa, ba na so ku kasance cikin duhu a game da wannan asirin, domin kada ku zama da hikima cikin tunaninku. Wannan asirin shine cewa wannan taurarewa ta faru a Isra'ila, har sai da Al'ummai suka shigo ciki. ");
INSERT INTO hauulb_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Ta haka dukan Isra'ila za su tsira, kamar yadda yake a rubuce: ''Daga cikin Sihiyona mai Kubutarwa zai fito; Zai kawar da kazanta daga cikin Yakubu. ");
INSERT INTO hauulb_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","Wannan zai zama alkawarina da su, sa'adda na kawar da zunubansu.'' ");
INSERT INTO hauulb_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","A wani bangaren kuma game da bishara, su makiya ne amamadinku, ta wani fannin kuma bisa ga zabin Allah su kaunattatu ne saboda ubanni. ");
INSERT INTO hauulb_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Domin baye-baye da kiran Allah basa canzawa. ");
INSERT INTO hauulb_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Domin ku ma da ba ku yin biyayya ga Allah, amma yanzu kun sami jinkai saboda rashin biyayyarsu. ");
INSERT INTO hauulb_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","Ta wannan hanyar dai, wadannan Yahudawan sun zama marasa biyayya. Sakamakon haka shine ta wurin jinkan da aka nuna maku, suma su samu jikai yanzu. ");
INSERT INTO hauulb_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Domin Allah ya rufe kowa ga rashin biyayya, domin ya nuna jinkai ga kowa. ");
INSERT INTO hauulb_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Ina misalin zurfin wadata da kuma hikima da sani na Allah! Hukunce-hukuncensa sun fi gaban a bincika, hanyoyinsa kuma sun fi gaban ganewa! ");
INSERT INTO hauulb_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","Don wanene ya san tunanin Ubangiji? Wanene kuma ya zama mai bashi shawara? ");
INSERT INTO hauulb_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","Ko kuma, wanene ya fara ba Allah wani abu, domin a biya shi?'' ");
INSERT INTO hauulb_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Daga wurinsa ne, ta wurinsa ne kuma, a gare shi ne kuma dukan abu suka fito. A gare shi daukaka ta tabbata har abada. Amin. ");
INSERT INTO hauulb_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Ina rokon ku 'yan'uwa, saboda yawan jinkan nan na Allah, da ku mika jikunanku hadaya mai rai, mai tsarki kuma abar karba ga Allah. wannan itace hidimarku ta zahiri. ");
INSERT INTO hauulb_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","Kada ku kamantu da wannan duniya, amma ku sami canzawa ta wurin sabunta tunaninku, kuyi haka don ku san abin da ke nagari, karbabbe, kuma cikakken nufin Allah. ");
INSERT INTO hauulb_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Don ina cewa, saboda alherin da aka bani, ka da waninku ya daukaka kansa fiye da inda Allah ya ajiye shi; a maimakon haka ku kasance da hikima, gwargwadon yadda Allah yaba kowa bangaskiya. ");
INSERT INTO hauulb_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Domin muna da gababuwa da yawa a jiki daya, amma ba dukansu ne ke yin aiki iri daya ba. ");
INSERT INTO hauulb_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","haka yake a garemu, kamar yadda muke da yawa haka cikin jikin Almasihu, dukkanmu gabobin juna ne. ");
INSERT INTO hauulb_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Muna da baye-baye dabam-dabam bisa ga alherin da aka bayar a gare mu. Idan baiwar wani anabci ne, yayi shi bisa ga iyakar bangaskiyarsa. ");
INSERT INTO hauulb_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","In wani yana da baiwar hidima, sai yayi hidimarsa. Idan baiwar wani koyarwa ce, yayi koyarwa. ");
INSERT INTO hauulb_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","Idan baiwar wani karfafawa ce, yayi ta karfafawa; Idan baiwar wani bayarwa ce, yayi ta da hannu sake; Idan baiwar wani shugabanci ne, yayi shi da kula; Idan baiwar wani nuna jinkai ne, yayi shi da sakakkiyar zuciya. ");
INSERT INTO hauulb_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Ku nuna kauna ba tare da riya ba. Ku Ki duk abin da ke mugu ku aikata abin da ke nagari. ");
INSERT INTO hauulb_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","Akan kaunar 'yan'uwa kuma, ku kaunaci juna yadda ya kamata; akan ban girma kuma, ku ba juna girma. ");
INSERT INTO hauulb_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","Akan himma kuma, kada ku yi sanyi; akan ruhu kuma, ku sa kwazo; Game da Ubangiji kuma, ku yi masa hidima. ");
INSERT INTO hauulb_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","Akan gabagadi kuma, ku yi shi da farin ciki; akan tashin hankali kuma, ku cika da hakuri; akan adu'a kuma, ku nace. ");
INSERT INTO hauulb_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","Ku zama masu biyan bukatar tsarkaka, ku zama masu karbar baki a gidajenku. ");
INSERT INTO hauulb_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Ku albarkaci masu tsananta maku, kada ku la'anta kowa. ");
INSERT INTO hauulb_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","Ku yi farinciki tare da masu farinciki; Ku yi hawaye tare da masu hawaye. ");
INSERT INTO hauulb_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","Tunanin ku ya zama daya. Kada tunaninku ya zama na fahariya, amma ku yi abokantaka da matalauta. Kada wani a cikin ku ya kasance da tunanin yafi kowa. ");
INSERT INTO hauulb_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","Kada ku rama mugunta da mugunta. Ku yi ayukan nagarta a gaban kowa. ");
INSERT INTO hauulb_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","Ku yi duk abin da za ku iya yi domin ku yi zaman salama tare da kowa. ");
INSERT INTO hauulb_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","'Yan'uwa, kada ku yi ramako, ku bar Allah ya rama maku. A rubuce yake, '' 'Ramako nawa ne; zan saka wa kowa,' in ji Ubangiji.'' ");
INSERT INTO hauulb_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","''Amma idan makiyin ka na jin yunwa, ba shi abinci ya ci. Idan yana jin kishin ruwa, ba shi ruwan sha. Idan kun yi haka, garwashin wuta ne za ku saka akan duk makiyi.'' ");
INSERT INTO hauulb_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Kada mugunta ta rinjaye ku, amma ku rinjayi mugunta ta wurin yin aikin nagarta. ");
INSERT INTO hauulb_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Bari kowa yayi biyayya da hukuma, saboda babu wata hukuma sai dai in tazo daga Allah; mahukunta da suke nan kuwa daga Allah ne. ");
INSERT INTO hauulb_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Saboda da haka duk wanda ya ja hukuma ya ja da dokar Allah; kuma dukan wadanda suka ki hukuma za su sha hukunci. ");
INSERT INTO hauulb_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","Don kuwa mahukunta ba abin tsoro ne ga masu nagarta ba, amma ga masu aikata laifi. Kuna so ku zama marasa tsoron hukuma? Kuyi abu nagari, zaku sami yabo daga yin hakan. ");
INSERT INTO hauulb_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","Saboda shi bawan Allah ne a gare ku don nagarta. Amma in kun yi abu mara kyau, kuyi tsoro, saboda ba ya dauke da takobi ba tare da dalili ba. Don shi bawan Allah ne mai saka wa mugu da fushi. ");
INSERT INTO hauulb_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","Saboda haka dole kuyi biyayya, ba don fushi ba, amma saboda lamiri. ");
INSERT INTO hauulb_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","Saboda wannan ne kuke biyan haraji. Don masu mulki bayin Allah ne, wadanda suke yin haka kullum. ");
INSERT INTO hauulb_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","Ku bawa kowa hakkinsa; haraji ga mai haraji; kudin fito ga mai fito; tsoro ga wanda ya cancanci tsoro; girma ga wanda cancanci girmamawa. ");
INSERT INTO hauulb_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","Kada ku rike bashin kowa, sai dai ku kaunaci juna. Domin duk wanda ya kaunaci dan'uwansa ya cika doka. ");
INSERT INTO hauulb_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","To, “Kada kuyi zina, kada kuyi kisa, kada kuyi sata, kada kuyi kyashi, idan har akwai wata doka kuma, an takaita ta a wannan jimlar: “Ka kaunaci dan'uwanka kamar kanka.” ");
INSERT INTO hauulb_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","Kauna bata cutar da makwabci. Domin haka, kauna tace cikar shari'a. ");
INSERT INTO hauulb_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","Saboda wannan, kun san lokaci yayi, ku farka daga barci. Domin cetonmu yana kusa fiye da yadda muke tsammani. ");
INSERT INTO hauulb_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","Dare yayi nisa, gari ya kusan wayewa. Don haka, sai mu rabu da ayyukan duhu, mu yafa makaman haske. ");
INSERT INTO hauulb_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","Sai muyi tafiya yadda ya kamata, kamar da rana, ba a cikin shashanci ko buguwa ba. Kada kuma muyi tafiya cikin fasikanci da muguwar sha'awa, ba kuma cikin husuma ko kishi ba. ");
INSERT INTO hauulb_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","Amma ku yafa Ubangiji Yesu Almasihu, kada kuwa ku tanadi halin mutumtaka, don biye wa muguwar sha'awarsa. ");
INSERT INTO hauulb_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","Ku karbi duk wanda yake da rarraunar bangaskiya, ba tare da sukar ra'ayinsa ba. ");
INSERT INTO hauulb_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","Wani yana da bangaskiyar yaci komai, wani wanda yake da rauni yakanci ganye ne kawai. ");
INSERT INTO hauulb_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","Kada wanda yake cin komai ya raina wanda baya cin kowanne abu. Kada kuma wanda baya cin kowanne abu ya shara'anta sauran da suke cin komai. Saboda Allah ya karbe shi. ");
INSERT INTO hauulb_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","Kai wanene, kai wanene da kake ganin laifin bawan wani? Tsayawarsa ko faduwarsa ai hakin maigidansa ne, amma Ubangiji yana da ikon tsai da shi. ");
INSERT INTO hauulb_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","Wani yakan daukaka wata rana fiye da sauran. Wani kuma yana daukan ranakun daidai. Kowa ya zauna a cikin hakakkewa akan ra'ayinsa. ");
INSERT INTO hauulb_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","Shi wanda ya kula da wata rana, ya kula da ita don Ubangiji. Kuma wanda yaci, yaci ne domin Ubangiji, domin yana yi wa Allah godiya. Shi wanda bai ci ba, yaki ci ne domin Ubangiji. Shima yana yi wa Allah godiya. ");
INSERT INTO hauulb_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","Domin babu wanda yake rayuwa don kansa a cikinmu, kuma babu mai mutuwa don kansa. ");
INSERT INTO hauulb_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","Domin in muna raye, muna raye don Ubangiji. Kuma in mun mutu, mun mutu ne don Ubangiji. Ashe, ko muna raye, ko a mace mu na Ubangiji ne. ");
INSERT INTO hauulb_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","Domin wannan dalilin Almasihu ya mutu ya kuma tashi, saboda ya zama Ubangiji ga matattu da rayayyu. ");
INSERT INTO hauulb_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","Amma ku don me kuke shara'anta yan'uwanku? kai kuma don me kake raina dan'uwanka? Dukan mu zamu tsaya gaban kursiyin shari'ar Allah. ");
INSERT INTO hauulb_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","Domin a rubuce yake, “ Na rantse, “inji Ubangiji”, kowacce gwiwa zata rusuna mani, kowanne harshe kuwa zai yabi Allah.” ");
INSERT INTO hauulb_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","Domin kowannenmu zai fadi abin da shi yayi da bakinsa a gaban Allah. ");
INSERT INTO hauulb_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","Saboda da haka kada muyi wa juna shari'a, amma maimakon haka ku dauki wannan kudduri, don kada kowa ya zama sanadin tuntunbe ko faduwa ga dan'uwansa. ");
INSERT INTO hauulb_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","Na sani na kuma tabbata tsakani na da Ubangiji Yesu, ba abin da yake mara tsarki ga asalinsa. Sai dai ga wanda ya dauke shi marar tsarki ne yake zama marar tsarki. ");
INSERT INTO hauulb_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","Idan har abincinka na cutar da dan'uwanka, ba ka tafiya cikin kauna. Kada ka lalata wanda Yesu ya mutu domin sa da abincinka. ");
INSERT INTO hauulb_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","Saboda haka, kada abubuwan da aka dauka kyawawa su zama abin zargi ga wadansu. ");
INSERT INTO hauulb_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","Saboda mulkin Allah ba maganar ci da sha ba ne, amma game da adalci ne, salama, da farin ciki a cikin Ruhu Mai Tsarki. ");
INSERT INTO hauulb_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","Domin wanda yake bautar Almasihu a wannan hanya, karbabbe ne ga Allah, kuma jama'a sun yarda da shi. ");
INSERT INTO hauulb_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","Don haka, mu nemi abubuwa na salama da abubuwan da zasu gina juna. ");
INSERT INTO hauulb_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","Kada ku lalata aikin Allah don abinci. Komai yana da tsarki, amma kaiton mutumin da yake cin abin da zai sa shi ya fadi. ");
INSERT INTO hauulb_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","Bashi da kyau a ci nama ko a sha ruwan inabi, ko duk abin da zai jawo faduwar dan'uwanka. ");
INSERT INTO hauulb_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","Wannan bangaskiyar da kuke da ita, ku adana ta tsakaninku da Allah. Mai albarka ne wanda zuciyarsa bata da laifi akan abin da hankalinsa ya ga daidai ne. ");
INSERT INTO hauulb_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","Duk wanda yayi shakka amma kuma yaci, ya sani yayi laifi kenan, domin ba tare da bangaskiya bane. Duk abin da ba na bangaskya bane zunubi ne. ");
INSERT INTO hauulb_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","Yanzu mu da muke da karfi ya kamata mu dau nauyi raunana, kuma bai dace mu nuna son kai ba. ");
INSERT INTO hauulb_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","Bari kowannenmu ya faranta wa makwabcinsa rai, domin wannan yana da kyau, don a gina shi. ");
INSERT INTO hauulb_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","Domin Almasihu bai faranta wa kansa rai ba. Kamar yadda aka rubuta, “zagin da wadansu suka yi masa ya sauka a kaina.” ");
INSERT INTO hauulb_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","Don abin da aka rubuta a baya an rubuta ne domin a gargade mu, domin ta hakuri da karfafawar litattafai mu sami karfi. ");
INSERT INTO hauulb_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","Yanzu Allah mai hakuri da karfafawa ya baku zuciya daya ta zaman tare da juna bisa ga halin Yesu Almasihu. ");
INSERT INTO hauulb_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","Domin ya yi haka ne da zuciya daya domin ku yi yabo da bakinku daya. ");
INSERT INTO hauulb_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","Domin ku karbi juna, kamar yadda Yesu ma ya karbe ku domin a daukaka Allah. ");
INSERT INTO hauulb_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","Saboda na ce an mai da Almasihu bawan kaciya a madadin gaskiyar Allah. Ya yi wannan ne don a tabbatar da alkawarai da aka ba kakanin kakaninmu. ");
INSERT INTO hauulb_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","Domin Al'umai su daukaka Allah saboda jinkansa, kamar yadda ya ke a arubuce, “Domin ta haka zan yabe ka cikin Al'umai in yi wakar yabon sunanka.” ");
INSERT INTO hauulb_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","Kuma an ce. “Ku yi faranciki, ku Al'ummai tare da mutanensa.” ");
INSERT INTO hauulb_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","Kuma.” Ku yabi Ubangiji, ku dukan Al'ummai; bari dukan mutane su yabe shi.” ");
INSERT INTO hauulb_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","Kuma, Ishaya ya ce “Za a sami tsatson Yessi, wanda zai tashi ya yi mulki a kan Al'umai, Al'umai za su sami karfin hali a cikinsa.” ");
INSERT INTO hauulb_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","Yanzu Allah mai karfafawa ya cika ku da dukkan farin ciki salama, saboda da bangaskiyarku, domin ku sami cikkakiyar karafafawa, ta wurin ikon Ruhu Mai Tsarki. ");
INSERT INTO hauulb_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","Ni kaina na amince da ku, yan'uwa. Kuma na amince cewa ku da kanku kuna cike da alheri, cike da dukkan sani. Na amince cewa za ku sami zarafi ku gargadi juna. ");
INSERT INTO hauulb_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","Amma ina rubuta maku da gabagadi kan wadansu abubuwa, domin in tunasheku, saboda baiwar da aka bani daga wurin Allah. ");
INSERT INTO hauulb_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","Cewa baiwar ta sa na zama bawan Almasihu Yesu da aka aika ga Al'ummai, limami na bisharar Allah. Zan yi wannan saboda baikon Al'ummai ya zama karbabbe, kuma kebbabe ga Allah ta wurin Ruhu Mai Tsarki. ");
INSERT INTO hauulb_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","Don haka ina jin dadi cikin Yesu Almasihu da abubuwa na Allah. ");
INSERT INTO hauulb_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","Domin ba ni da abin da zan ce, sai abin da Yesu ya aikata ta wurina, domin Al'ummai su yi biyayya ta magana da aiki. ");
INSERT INTO hauulb_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","Ta wurin alamu, da al'jibai, da ikon Ruhu Mai Tsarki. Daga Urushalima, da kewaye har zuwa Ilirikum, an kai bisharar Almasihu ko'ina dukka. ");
INSERT INTO hauulb_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","A cikin hanyar nan, burina in sanar da bishara, amma a inda ba a san Yesu ta wurin sunansa ba, don kada in sa gini akan harshashi wani. ");
INSERT INTO hauulb_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","Kamar yadda yake a rubuce.”Wadanda ba a taba fada wa labarinsa ba, su gane. Wadanda ba su taba jin labarinsa ba su fahimta.” ");
INSERT INTO hauulb_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","Saboda an hana ni zuwa wurin ku a lokatai da dama. ");
INSERT INTO hauulb_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","Amma yanzu bani da sauran wani wuri a lardin nan, kuma cikin shekaru masu yawa ina da marmarin in zo wurin ku. ");
INSERT INTO hauulb_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","Duk lokacin da zan tafi Asbaniya ina begen ganin ku yayin wucewa, don ku raka ni bayan na ji dadin zama da ku na dan lokaci. ");
INSERT INTO hauulb_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","Amma yanzu ina tafiya Urushalima don in yi wa tsarkaka hidima. ");
INSERT INTO hauulb_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","Domin abin farinciki ne ga mutanen Makidoniya da Akaya su yi bayarwa domin gajiyayyu masu bada gaskiya wadanda suke a Urushalima. ");
INSERT INTO hauulb_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","Suna jin dadi domin hakika kamar bashi ne a kansu. Domin Al'ummai sun yi tarayya da su cikin ayyukan ruhaniya, ya zama hakki a kansu su ma su taimake su da abubuwa. ");
INSERT INTO hauulb_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","Domin lokacin da na gama basu kudin, zan zo gareku a hanyata ta zuwa Asbaniya. ");
INSERT INTO hauulb_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","Na san cewa lokacin da na zo gareku, zan zo da cikakkun albarku na Almasihu. ");
INSERT INTO hauulb_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","Yanzu ina rokonku, yan'uwa, ta wurin Ubangiji Yesu Almasihu, da kaunar Ruhu Mai Tsarki, ku yi ta fama tare da ni a cikin yin addu'o, inku ga Allah saboda ni. ");
INSERT INTO hauulb_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","Kuyi haka saboda in tsira daga wadanda suke masu biyayya ga Yahudiya, domin kuma hidimata saboda Urushalima ta zama karbabbiya. ");
INSERT INTO hauulb_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","Ku yi addu'a cewa in zo wurinku da farinciki ta wurin nufin Allah, cewa tare da ni da ku, mu sami hutu. ");
INSERT INTO hauulb_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","Allah na salama ya kasance tare da ku duka. Amin. ");
INSERT INTO hauulb_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","Ina gabatar muku da fibi 'yar'uwarmu, wanda take hidima a Ikilisiya dake cikin Kankiriya. ");
INSERT INTO hauulb_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","Domin ku karbe ta cikin Ubangij. A hanyar da ta dace ga masu bada gaskiya, ku tsaya tare da ita cikin kowacce bukata. Domin ita da kanta ta zama da taimako ga masu yawa, har da ni ma. ");
INSERT INTO hauulb_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","Ku gai da Bilkisu da Akila abokan aiki cikin Yesu Almasihu. ");
INSERT INTO hauulb_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","Wadanda sabo da ni suka sadaukar da ransu. Ina godiya garesu, ba ni kadai ba, amma kuma da dukan Ikilisiyoyin Al 'mmai. ");
INSERT INTO hauulb_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","Gaida Ikilisiya da ke gidansu. Ku gai da Abainitas kaunataccena. Wanda shi ya fara bada gaskiya ga Almasihu a Asiya. ");
INSERT INTO hauulb_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","Ku gai da Maryamu, wadda ta yi maku aiki tukuru. ");
INSERT INTO hauulb_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","Ku gai da Andaranikas da Yuniyas, yan'uwana da abokan kurkukuna. Su sanannu ne cikin manzani, wadanda suke cikin Almasihu kafin ni. ");
INSERT INTO hauulb_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","Ku gai da Amfiliyas kaunatace na cikin Ubangiji. ");
INSERT INTO hauulb_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","Ku gai da Urbanas abokin aikinmu cikin Almasihu, da Istakis kaunataccena. ");
INSERT INTO hauulb_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","Ku gai da Abalis amintacce cikin Almasihu. Ku gai da wadanda su ke gidan Aristobulus. ");
INSERT INTO hauulb_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","Ku gai da Hirudiya, dan'uwa na, da wadanda ke gidan Narkissa, wadanda ke cikin Ubangiji. ");
INSERT INTO hauulb_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","Ku gai da Tarafina daTarafusa, masu aikin Ubangiji. ");
INSERT INTO hauulb_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","Ku gai da Barsisa kaunatacciya, wadda ta yi aikin Ubangiji da yawa. Ku gai da Rufas zababbe cikin Ubangiji da mamarsa da ni. ");
INSERT INTO hauulb_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","Ku gai da Asinkiritas da Filiguna da Hamis da Baturobas da Hamisu da kuma yan'uwa da ke tare da su. ");
INSERT INTO hauulb_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","Ku gai da Filolugus daYuliya da Niriyas da yan'uwansa, da Ulumfas da kuma dukan tsarkaka da ke tare su. ");
INSERT INTO hauulb_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","Ku gaggai da juna da tsatsarkar sumba. Dukan Ikilisiyoyin Almasihu na gaishe ku. ");
INSERT INTO hauulb_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","Yanzu ina rokon ku, yan'wa, ku yi tunani fa game da masu kawo rabuwa da tuntube. Sabanin koyarwar da ku ka koya. Ku yi nesa da su. ");
INSERT INTO hauulb_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","Domin irin mutanen nan ba sa bauta wa Ubangiji Yesu, sai dai tumbinsu. Ta dadin bakinsu suke rudin zuciyar marasa laifi. ");
INSERT INTO hauulb_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","Domin rayuwar biyayyarku takai ga kunnen kowa, na yi farin ciki da ku, amma ina so ku zama da hikima game da abin ya ke mai kyau, ku zama marasa laifi ga abin da ke na mugunta. ");
INSERT INTO hauulb_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","Allah na salama zai sa ku tattake Shaidan da sauri kalkashin sawayen ku. Alherin Ubangijin mu Yesu Almasihu ya kasance tare da ku. ");
INSERT INTO hauulb_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","Timoti abokin aikina, yana gaishe ku, haka Lukiyas da Yason da Susibataras da kuma yan'uwana. ");
INSERT INTO hauulb_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","Ni Tartiyas wanda ya rubuta wasikan nan, na gaisheku cikin Ubangiji. ");
INSERT INTO hauulb_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","Gayus mai masaukina da kuma dukan Ikilisiya, suna gaishe ku. Arastas ma'ajin birni na gaishe ku, da Kwartus dan'uwanmu. ");
INSERT INTO hauulb_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","Alherin Ubangijinmu Yesu Almasihu ya kasance tare da ku dukka. Amin. ");
INSERT INTO hauulb_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","Yanzu ga wanda ke da Ikon karfafa ku bisa ga bisharata da wa'azin Yesu Almasihu, wanda ta gare shi ne aka bayyana asiran nan da suke boye tun da dadewa, ");
INSERT INTO hauulb_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","amma yanzu sanannu ne ta wurin litattafan Annabawa bisa umarnin Allah madauwami, domin biyayyar bangaskiya cikin Al'ummai dukka. ");
INSERT INTO hauulb_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","Ga Allah mai hikima kadai, ta wurin Yesu Almasihu daukaka ta tabbata har abada. Amin. ");
INSERT INTO hauulb_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","Bulus, kirayayye daga Almsihu Yesu don zama manzo ta wurin nufin Allah, da dan'uwanmu Sastanisu, ");
INSERT INTO hauulb_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","zuwa ga Ikilisiyar Allah da ke korinti, zuwa ga wadanda aka kebe su cikin Almasihu Yesu, wadanda aka kira domin su zama al'umma maitsarki. Muna kuma rubuta wa dukan masu kira bisa sunan Ubangijinmu Yesu Almasihu a ko'ina, wato Ubangijinsu da Ubangijinmu kuma. ");
INSERT INTO hauulb_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","Bari alheri da salama su zo gare ku daga Allah Ubanmu da Ubangiji Yesu Almasihu. ");
INSERT INTO hauulb_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","Kodayaushe ina gode wa Allahna domin ku, saboda alherin Allah da Almasihu Yesu ya yi maku. ");
INSERT INTO hauulb_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","Ya ba ku arziki ta kowace hanya, cikin dukkan magana da dukkan ilimi. ");
INSERT INTO hauulb_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","Kamar yadda shaida game da Almasihu ta tabbata gaskiya a tsakaninku. ");
INSERT INTO hauulb_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","Saboda haka baku rasa wata baiwa ta ruhaniya ba yayinda kuke marmarin jiran bayyanuwar Ubangijinmu Yesu Almasihu. ");
INSERT INTO hauulb_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","Zai kuma karfafa ku zuwa karshe, saboda ku zama marasa aibi a ranar Ubangijinmu Yesu Almasihu. ");
INSERT INTO hauulb_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","Allah mai aminci ne shi wanda ya kira ku zuwa zumunta ta Dansa, Yesu Almasihu Ubangijimu. ");
INSERT INTO hauulb_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","Ina rokon ku, yan'uwa, cikin sunan Ubangijinmu Yesu Almasihu, ku yarda da juna, kada tsattsaguwa ta kasance tsakanin ku. Ina rokon ku ku zama da zuciya daya da kuma nufi daya. ");
INSERT INTO hauulb_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","Gama mutanen gidan Kulowi sun kawo kara cewa akwai tsattsaguwa a cikin ku. ");
INSERT INTO hauulb_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","Ina nufin: kowannen ku na cewa, “ Ina bayan Bulus,” ko “ Ina bayan Afollos,” ko “Ina bayan Kefas,” ko “Ina bayan Almasihu.” ");
INSERT INTO hauulb_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","Almasihu a rarrabe yake? An gicciye Bulus domin ku? Ko an yi maku baftisma a cikin sunan Bulus? ");
INSERT INTO hauulb_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","Na godewa Allah domin ban yi wa wanin ku baftisma ba, sai dai Kirisfus da Gayus. ");
INSERT INTO hauulb_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","Na yi wannan saboda kada wani ya ce an yi maku baftisma a cikin sunana. ");
INSERT INTO hauulb_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","(Na kuma yi wa iyalin gidan Sitifanas baftisma. Banda haka, ban sani ko na yi wa wani baftisma ba.) ");
INSERT INTO hauulb_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","Gama Almasihu bai aiko ni domin yin baftisma ba, amma domin yin wa'azin bishara. Bai aiko ni domin in yi wa'azi da kalmomin hikimar mutum ba, saboda kada giciyen Almasihu ya rasa ikonsa. ");
INSERT INTO hauulb_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","Gama wa'azin gicciye wauta ne ga wadanda su ke mutuwa. Amma cikin wadanda Allah ke ceto, ikon Allah ne. ");
INSERT INTO hauulb_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","Gama a rubuce yake, “Zan watsar da hikimar masu hikima. Zan dode fahimtar masu basira.” ");
INSERT INTO hauulb_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","Ina mai hikima? Ina masani? Ina mai muhawara na duniyan nan? Allah bai juya hikimar duniya zuwa wauta ba? ");
INSERT INTO hauulb_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","Tunda duniya cikin hikimarta bata san Allah ba, ya gamshi Allah ta wurin wautar wa'azi ya ceci masu bada gaskiya. ");
INSERT INTO hauulb_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","Gama Yahudawa suna bidar al'ajibai, Helinawa kuma suna neman hikima. ");
INSERT INTO hauulb_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","Amma muna wa'azin Almasihu gicciyayye, dutsen tuntube ga yahudawa da kuma wauta ga Helinawa. ");
INSERT INTO hauulb_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","Amma ga wadanda Allah ya kira, Yahudawa da Helinawa, muna wa'azin Almasihu a matsayin iko da kuma hikimar Allah. ");
INSERT INTO hauulb_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","Gama wautar Allah tafi mutane hikima, kuma rashin karfin Allah yafi mutane karfi. ");
INSERT INTO hauulb_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","Dubi kiranku, yan'uwa. Ba dukkan ku ke da hikima a ma'aunin mutane ba. Ba dukkan ku ke da iko ba. Ba dukkan ku ke da haifuwa ta sarauta ba. ");
INSERT INTO hauulb_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","Amma Allah ya zabi abubuwan da suke wofi na duniya domin ya kunyatar da masu hikima. Allah ya zabi abin da ke marar karfi a duniya domin ya kunyatar da abinda ke mai karfi. ");
INSERT INTO hauulb_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","Allah ya zabi abinda ke marar daraja da kuma renanne a duniya. Ya ma zabi abubuwan da ake dauka ba komai ba, domin ya wofinta abubuwan da ake dauka masu daraja. ");
INSERT INTO hauulb_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","Ya yi wannan ne domin kada wani ya sami dalilin fahariya a gabansa. ");
INSERT INTO hauulb_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","Domin abinda Allah ya yi, yanzu kuna cikin Almasihu Yesu, wanda ya zamar mana hikima daga Allah. Ya zama adalcinmu, da tsarkinmu da fansarmu. ");
INSERT INTO hauulb_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","A sakamakon haka, kamar yadda nassi ya ce, “Bari mai yin fahariya, ya yi fahariya cikin Ubangiji.” ");
INSERT INTO hauulb_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","Lokacin da na zo wurin ku, yan'uwa, ban zo da gwanintar magana ko hikima ba yayinda na yi shelar boyayyun bayanai game da Allah  a yayinda na bada shaida game da Allah. ");
INSERT INTO hauulb_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","Domin na kudura a zuciyata kada in san komai lokacin da nake tare da ku, sai dai Yesu Almasihu, gicciyayye. ");
INSERT INTO hauulb_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","Ina tare da ku cikin kasawa, da tsoro, da fargaba mai yawa. ");
INSERT INTO hauulb_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","Kuma sakona da shelata basu tare da kalmomin hikima masu daukar hankali. Maimakon haka, sun zo da bayyanuwar Ruhu da iko, ");
INSERT INTO hauulb_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","saboda kada bangaskiyarku ta zama cikin hikimar mutane, amma cikin ikon Allah. ");
INSERT INTO hauulb_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","Yanzu muna maganar hikima ga wadanda suka ginu, amma ba hikima ta duniyan nan ba, ko ta masu mulkin wannan zamani, wadanda suke shudewa. ");
INSERT INTO hauulb_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","Maimakon haka, muna maganar hikimar Allah ta boyayyar gaskiya, boyayyar hikima da Allah ya kaddara kafin zamanin daukakarmu. ");
INSERT INTO hauulb_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","Babu wani mai mulki na zamanin nan da ya san wannan hikimar, domin inda sun gane ta a wancan lokacin, da basu gicciye Ubangijin daukaka ba. ");
INSERT INTO hauulb_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","Amma kamar yadda yake a rubuce, “Abubuwan da babu idon da ya gani, babu kunnen da ya ji, babu zuciyar da ta yi tsammanin sa, abubuwan da Allah ya shirya wa wadanda suke kaunarsa. ");
INSERT INTO hauulb_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","Wadannan ne abubuwan da Allah ya bayyana mana ta wurin Ruhu. Gama Ruhu yana bincika komai, har ma abubuwa masu zurfi na Allah. ");
INSERT INTO hauulb_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","Gama wanene ya san tunanin mutum, sai dai ko ruhun mutumin da ke cikinsa? Haka ma, babu wanda ya san abubuwa masu zurfi na Allah sai dai Ruhun Allah. ");
INSERT INTO hauulb_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","Ba mu karbi ruhu na duniya ba, amma Ruhun da ya zo daga wurin Allah, domin mu san abubuwan da aka bamu a sake daga wurin Allah. ");
INSERT INTO hauulb_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","Muna maganar wadannan abubuwa da kalmomin da hikimar da mutum baza ta iya koyarwa ba, amma wadanda Ruhu ke koyar da mu. Ruhu yana fassara kalmomi na ruhaniya da hikima ta ruhaniya. ");
INSERT INTO hauulb_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","Mutum marar ruhaniya ba ya karbar abubuwan da suke daga Ruhun Allah, gama wauta suke a gareshi. Ba zai iya sanin su ba domin Ruhu ne yake bayyana su. ");
INSERT INTO hauulb_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","Shi wanda yake mai ruhaniya yana shari'anta dukan abubuwa, amma shi baya karkashin shari'ar sauran mutane. ");
INSERT INTO hauulb_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","“Wa zai iya sanin zuciyar Ubangiji, da zai iya ba shi umarni?” Amma mu muna da lamiri irin na Almasihu. ");
INSERT INTO hauulb_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","Amma ni, yan'uwa, ba zan iya magana da ku kamar mutane masu ruhaniya ba, amma kamar mutane masu jiki, kamar jarirai cikin Almasihu. ");
INSERT INTO hauulb_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","Na shayar da ku da Madara ba da nama ba, don baku isa cin nama ba, kuma ko yanzu ma baku isa ba. ");
INSERT INTO hauulb_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","Gama har yanzu ku masu jiki ne. Muddin akwai kishi da jayayya a tsakaninku, ashe, ku ba masu jiki ba ne, kuma kuna tafiya bisa magwajin mutane? ");
INSERT INTO hauulb_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","Domin in wani ya ce, “Ina bayan Bulus,” wani kuma ya ce, “Ina bayan Afollos,” ashe, ba zaman mutuntaka kuke yi ba? ");
INSERT INTO hauulb_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","To wanene Afollos? Wanene kuma Bulus? Bayi ne wadanda kuka bada gaskiya ta wurin su, kowannen su kuwa Allah ya bashi ayyuka. ");
INSERT INTO hauulb_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","Ni nayi shuka, Afolos yayi banruwa, amma Allah ne ya sa girma. ");
INSERT INTO hauulb_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","Don haka, da mai shukar da mai banruwan, ba komi bane. Amma Allah ne mai sa girman. ");
INSERT INTO hauulb_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","Da mai shukar, da mai banruwan, duk daya suke, kuma kowannen su zai sami nasa lada, gwargwadon aikinsa. ");
INSERT INTO hauulb_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","Gama mu abokan aiki ne na Allah. Ku gonar Allah ne, ginin Allah kuma. ");
INSERT INTO hauulb_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","Bisa ga alherin Allah da aka bani a matsayin gwanin magini, na kafa harsashi, wani kuma yana dora gini a kai. Sai dai kowane mutum, ya lura da yadda yake dora ginin. ");
INSERT INTO hauulb_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","Gama ba wanda ke iya kafa wani harsashin daban da wanda aka rigaya aka kafa, wato, Yesu Almasihu. ");
INSERT INTO hauulb_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","Yanzu fa in wani ya dora gini a kan harashin da zinariya, ko azurfa, ko duwatsu masu daraja, ko itace, ko ciyawa, ko tattaka, ");
INSERT INTO hauulb_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","aikinsa zai bayyanu, domin ranar nan zata tona shi. Gama za a bayyana shi cikin wuta. Wutar kuwa zata gwada ingancin aikin da kowa ya yi. ");
INSERT INTO hauulb_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","Duk wanda aikinsa ya tsaya, zai karbi lada; ");
INSERT INTO hauulb_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","amma duk wanda aikinsa ya kone, zai sha Asara, amma shi kansa zai tsira, sai dai kamar ta tsakiyar wuta. ");
INSERT INTO hauulb_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","Ashe, baku san ku haikalin Allah ne ba, Ruhun Allah kuma yana zaune a cikin ku? ");
INSERT INTO hauulb_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","Idan wani ya lalata haikalin Allah, Allah zai lalata shi. Gama haikalin Allah mai tsarki ne, kuma haka ku ke. ");
INSERT INTO hauulb_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","Kada kowa ya rudi kansa. Idan wani a cikin ku na ganin shi mai hikima ne a wannan zamani, bari ya zama” wawa” domin ya zama mai hikima. ");
INSERT INTO hauulb_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","Gama hikimar duniyar nan wauta ce a gun Allah. Gama a rubuce yake, “Yakan kama masu hikima a cin makircin su.” ");
INSERT INTO hauulb_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","Har wa yau, “Ubangiji ya san tunanin masu hikima banza ne.” ");
INSERT INTO hauulb_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","haka ba sauran fariya akan mutane! Domin kuwa kome naku ne, ");
INSERT INTO hauulb_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","Ko Bulus, ko Afollos, ko kefas, ko duniya, ko rai, ko mutuwa, ko abubuwa na yanzu, ko abubuwa masu zuwa. Duka naku ne, ");
INSERT INTO hauulb_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","Ku kuwa na Almasihu ne, Almasihu kuma na Allah ne. ");
INSERT INTO hauulb_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","Ga yadda za ku dauke mu, kamar bayin Almasihu da kuma masu rikon asiran Allah. ");
INSERT INTO hauulb_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","Hade da wannan, ana bukatar wakilai su zama amintattu. ");
INSERT INTO hauulb_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","Amma a gare ni, karamin abu ne ku yi mani shari'a, ko a wata kotu irin ta mutane. Gama bani yi wa kaina shari'a. ");
INSERT INTO hauulb_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","Ban sani ko akwai wani zargi a kaina ba, amma wannan bai nuna cewa bani da laifi ba. Ubangiji ne mai yi mani shari'a. ");
INSERT INTO hauulb_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","Sabili da haka, kada ku yanke shari'a kafin lokaci, kafin Ubangiji ya dawo. Zai bayyana dukkan boyayyun ayyuka na duhu, ya kuma tona nufe-nufen zuciya. San nan kowa zai samu yabonsa daga wurin Allah. ");
INSERT INTO hauulb_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","Yan'uwa, ina dora wadannan ka'idoji a kaina da Afollos domin ku, yadda ta wurin mu za ku koyi ma'anar maganar nan cewa, “kada ku zarce abin da aka rubuta.” Ya zama haka domin kada waninku ya kumbura yana nuna fifiko ga wani akan wani. ");
INSERT INTO hauulb_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","Gama wa yaga bambanci tsakanin ku da wasu? Me kuke da shi da ba kyauta kuka karba ba? Idan kyauta kuka karba, don me kuke fahariya kamar ba haka ba ne? ");
INSERT INTO hauulb_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","Kun rigaya kun sami dukkan abubuwan da kuke bukata! Kun rigaya kun zama mawadata! Kun rigaya kun fara mulki- kuma ba tare da mu ba! Hakika, marmarina shine ku yi mulki, domin mu yi mulki tare da ku. ");
INSERT INTO hauulb_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","A tunanina, mu manzanni, Allah ya sa mu a jerin karshe kamar mutanen da aka zartar wa hukuncin mutuwa. Mun zama abin kallo ga duniya, ga mala'iku, ga mutane kuma. ");
INSERT INTO hauulb_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","Mun zama marasa wayo sabili da Almasihu, amma ku masu hikima ne a cikin Almasihu. Mu raunana ne, amma ku masu karfi ne. Ana ganin mu marasa daraja, ku kuwa masu daraja. ");
INSERT INTO hauulb_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","Har zuwa wannan sa'a, muna masu yunwa da kishi, marasa tufafi masu kyau, mun sha kazamin duka, kuma mun zama marasa gidaje. ");
INSERT INTO hauulb_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","Mun yi fama sosai, muna aiki da hanuwanmu. Sa'adda an aibata mu, muna sa albarka. Sa'adda an tsananta mana, muna jurewa. ");
INSERT INTO hauulb_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","Sa'adda an zage mu, muna magana da nasiha. Mun zama, kuma har yanzu an dauke mu a matsayin kayan shara na duniya da abubuwa mafi kazamta duka. ");
INSERT INTO hauulb_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","Ban rubuta wadannan abubuwa domin in kunyata ku ba, amma domin in yi maku gyara kamar kaunatattun yayana. ");
INSERT INTO hauulb_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","Ko da kuna da masu riko dubu goma a cikin Almasihu, ba ku da ubanni da yawa. Gama ni na zama ubanku cikin Almasihu Yesu ta wurin bishara. ");
INSERT INTO hauulb_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","Don haka, ina kira gare ku da ku zama masu koyi da ni. ");
INSERT INTO hauulb_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","Shiyasa na aiko Timoti wurin ku, kaunatacce da amintaccen dana cikin Ubangiji. Zai tunashe ku hanyoyina cikin Almasihu, kamar yadda nake koyar da su ko'ina da kowace Ikilisiya. ");
INSERT INTO hauulb_