﻿USE sofia;
DROP TABLE IF EXISTS sofia.hausa_vpl;
CREATE TABLE hausa_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES hausa_vpl WRITE;
INSERT INTO hausa_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","A farko-farko, Allah ya halicci sama da ƙasa. ");
INSERT INTO hausa_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","To, ƙasa dai ba ta da siffa, babu kuma kome a cikinta, duhu ne kawai ya rufe ko’ina, Ruhun Allah kuwa yana yawo a kan ruwan. ");
INSERT INTO hausa_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Sai Allah ya ce, “Bari haske yă kasance,” sai kuwa ga haske. ");
INSERT INTO hausa_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Allah ya ga hasken yana da kyau, sai ya raba tsakanin hasken da duhu. ");
INSERT INTO hausa_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Allah ya kira hasken “yini,” ya kuma kira duhun “dare.” Yamma ta kasance, safiya kuma ta kasance, kwana ta fari ke nan. ");
INSERT INTO hausa_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Allah ya ce, “Bari sarari yă kasance tsakanin ruwaye domin yă raba ruwa da ruwa.” ");
INSERT INTO hausa_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Saboda haka Allah ya yi sarari ya raba ruwan da yake ƙarƙashin sararin da ruwan da yake bisansa. Haka kuwa ya kasance. ");
INSERT INTO hausa_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Allah ya kira sararin “sama.” Yamma ta kasance, safiya kuma ta kasance, kwana ta biyu ke nan. ");
INSERT INTO hausa_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Allah ya ce, “Bari ruwan da yake ƙarƙashin sama yă tattaru wuri ɗaya, bari kuma busasshiyar ƙasa tă bayyana.” Haka kuwa ya kasance. ");
INSERT INTO hausa_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Allah ya kira busasshiyar ƙasar “doron ƙasa,” ruwan da ya taru kuma, ya kira “tekuna.” Allah ya ga yana da kyau. ");
INSERT INTO hausa_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Sa’an nan Allah ya ce, “Bari ƙasa tă fid da tsire-tsire, da shuke-shuke, da itatuwa a bisa ƙasa masu ba da amfani da ’ya’ya a cikinsu, bisa ga irinsu.” Haka kuwa ya kasance. ");
INSERT INTO hausa_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Ƙasar ta fid da tsire-tsire, da shuke-shuke masu ba da ’ya’ya bisa ga irinsu, ta fid kuma da itatuwa masu ba da ’ya’ya da iri a cikinsu bisa ga irinsu. Allah ya ga yana da kyau. ");
INSERT INTO hausa_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Yamma ta kasance, safiya kuma ta kasance, kwana ta uku ke nan. ");
INSERT INTO hausa_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Allah kuma ya ce, “Bari haskoki su kasance a sararin sama domin su raba yini da dare, bari su zama alamu domin su nuna yanayi, da ranaku, da kuma shekaru, ");
INSERT INTO hausa_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","bari kuma haskokin su kasance a sararin sama domin su ba da haske a duniya.” Haka kuwa ya kasance. ");
INSERT INTO hausa_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Allah ya yi manyan haskoki biyu, babban hasken yă mallaki yini, ƙaramin kuma yă mallaki dare. Ya kuma yi taurari. ");
INSERT INTO hausa_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Allah ya sa su a sararin sama domin su ba da haske a duniya, ");
INSERT INTO hausa_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","su mallaki yini da kuma dare, su kuma raba haske da duhu. Allah kuwa ya ga yana da kyau. ");
INSERT INTO hausa_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Yamma ta kasance, safiya kuma ta kasance, kwana ta huɗu ke nan. ");
INSERT INTO hausa_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Allah ya ce, “Bari ruwa yă cika da halittu masu rai, bari tsuntsaye kuma su tashi sama a bisa duniya a sararin sama.” ");
INSERT INTO hausa_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Allah ya halicci manyan halittun teku, da kowane mai rai da abin da yake motsi a ruwa, bisa ga irinsu, da kuma kowane tsuntsu mai fiffike bisa ga irinsa. Allah kuwa ya ga yana da kyau. ");
INSERT INTO hausa_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Allah ya albarkace su ya ce, “Ku yi ta haihuwa ku kuma ƙaru da yawa, ku cika ruwan tekuna, bari kuma tsuntsaye su yi yawa a bisa duniya.” ");
INSERT INTO hausa_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Yamma ta kasance, safiya kuma ta kasance, kwana ta biyar ke nan. ");
INSERT INTO hausa_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Allah kuwa ya ce, “Bari ƙasa tă ba da halittu masu rai bisa ga irinsu; dabbobi da halittu masu rarrafe, da kuma namun jeji, kowane bisa ga irinsa.” Haka kuwa ya kasance. ");
INSERT INTO hausa_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Allah ya halicci namun jeji bisa ga irinsu, dabbobi bisa ga irinsu, da kuma dukan halittu masu rarrafe a ƙasa bisa ga irinsu. Allah kuwa ya ga yana da kyau. ");
INSERT INTO hausa_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Sa’an nan Allah ya ce, “Bari mu yi mutum cikin siffarmu, cikin kamanninmu, bari kuma su yi mulki a bisa kifin teku, tsuntsayen sama, da kuma dabbobi, su yi mulki a bisa dukan duniya, da kuma a bisa dukan halittu, da masu rarrafe a ƙasa.” ");
INSERT INTO hausa_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Saboda haka Allah ya halicci mutum cikin siffarsa. Cikin kamannin Allah, Allah ya halicci mutum. Miji da mace ya halicce su. ");
INSERT INTO hausa_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Allah ya albarkace su, ya kuma ce musu, “Ku yi ta haihuwa ku ƙaru da yawa, ku mamaye duniya, ku mallake ta. Ku yi mulki a bisa kifin teku, da tsuntsayen sararin sama, da kuma bisa kowace halitta mai rai wadda take rarrafe a ƙasa.” ");
INSERT INTO hausa_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Sa’an nan Allah ya ce, “Ga shi, na ba ku kowane tsiro mai ba da ’ya’ya masu kwaya da suke a fāɗin duniya, da dukan itatuwa masu ba da ’ya’ya, don su zama abinci a gare ku. ");
INSERT INTO hausa_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Na kuma ba da dukan dabbobin ƙasa, da dukan tsuntsayen sama, da dukan abin da yake rarrafe a ƙasa, da dai iyakar abin da yake numfashi; haka kuma na ba da ganyaye su zama abinci.” Haka kuwa ya kasance. ");
INSERT INTO hausa_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Allah ya ga dukan abin da ya yi, yana da kyau ƙwarai. Yamma ta kasance, safiya kuma ta kasance, kwana ta shida ke nan. ");
INSERT INTO hausa_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Ta haka aka gama yin sammai da duniya da dukan abubuwan da suke cikinsu. ");
INSERT INTO hausa_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Kafin kwana ta bakwai, Allah ya gama aikin da yake yi, saboda haka a kwana ta bakwai, ya huta daga dukan aikinsa. ");
INSERT INTO hausa_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Allah kuwa ya albarkaci kwana ta bakwai, ya kuma mai da ita mai tsarki, saboda a kanta ne ya huta daga dukan aikin halittar da ya yi. ");
INSERT INTO hausa_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Wannan shi ne asalin tarihin sammai da duniya sa’ad da aka halicce su. Sa’ad da Ubangiji Allah ya yi duniya da sammai, ");
INSERT INTO hausa_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","babu tsiro a duniya kuma ganyaye ba su tsira a busasshiyar ƙasa ko ba, gama Ubangiji Allah bai aiko da ruwan sama a kan duniya ba tukuna, babu kuma wani mutumin da zai nome ƙasar, ");
INSERT INTO hausa_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","amma dai rafuffuka suna ɓullo da ruwa daga ƙasa suna jiƙe ko’ina a fāɗin ƙasa. ");
INSERT INTO hausa_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Sa’an nan Ubangiji Allah ya yi mutum daga turɓayar ƙasa, ya kuma hura numfashin rai cikin hancinsa, mutumin kuwa ya zama rayayyen taliki. ");
INSERT INTO hausa_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","To, fa, Ubangiji Allah ya yi lambu a gabas, a Eden, a can kuwa ya sa mutumin da ya yi. ");
INSERT INTO hausa_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Ubangiji Allah ya kuma sa kowane irin itace ya tsira daga ƙasa, itace mai kyan gani, mai amfani kuma don abinci. A tsakiyar lambun kuwa akwai itacen rai da kuma itacen sanin abin da yake da kyau da abin da yake mugu. ");
INSERT INTO hausa_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Akwai wani kogi mai ba da ruwa ga lambun wanda ya gangaro daga Eden, daga nan ya rarrabu, ya zama koguna huɗu. ");
INSERT INTO hausa_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Sunan kogi na fari, Fishon. Shi ne yake malala kewaye da dukan ƙasar Hawila, inda akwai zinariya. ");
INSERT INTO hausa_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","(Zinariyar wannan ƙasa kuwa tana da kyau, akwai kuma kayan ƙanshi da duwatsun da ake kira onis a can ma.) ");
INSERT INTO hausa_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Sunan kogi na biyu, Gihon. Shi ne ya malala kewaye da ƙasar Kush. ");
INSERT INTO hausa_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Sunan kogi na uku Tigris. Wannan ne ya malala ya bi ta gefen gabashin Asshur. Kogi na huɗu kuwa shi ne Yuferites. ");
INSERT INTO hausa_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Ubangiji Allah ya ɗauko mutumin ya sa shi cikin Lambun Eden domin yă nome shi, yă kuma lura da shi. ");
INSERT INTO hausa_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Ubangiji Allah ya umarci mutumin ya ce, “Kana da ’yanci ka ci daga kowane itace a cikin lambun, ");
INSERT INTO hausa_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","amma kada ka ci daga itacen sanin abin da yake mai kyau da abin da yake mugu, gama a ranar da ka ci shi, lalle za ka mutu.” ");
INSERT INTO hausa_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Ubangiji Allah ya ce, “Bai yi kyau mutumin yă kasance shi kaɗai ba. Zan yi masa mataimakin da ya dace da shi.” ");
INSERT INTO hausa_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","To, Ubangiji Allah ya yi dukan namun jeji da dukan tsuntsayen sama daga ƙasa. Ya kawo su wurin mutumin don yă ga wanda suna zai kira su; kuma duk sunan da mutumin ya kira kowane mai rai, sunansa ke nan. ");
INSERT INTO hausa_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Saboda haka mutumin ya sa wa dukan dabbobi, da tsuntsayen sama da dukan namun jeji sunaye. Amma ba a sami mataimakin da ya dace da Adamu ba. ");
INSERT INTO hausa_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Saboda haka Ubangiji Allah ya sa mutumin ya yi barci mai nauyi; yayinda yake barci sai ya ɗauko ɗaya daga cikin haƙarƙarin mutumin, ya kuma rufe wurin da nama. ");
INSERT INTO hausa_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Sa’an nan Ubangiji Allah ya yi mace daga haƙarƙarin da ya ɗauko daga mutumin, ya kuwa kawo ta wurin mutumin. ");
INSERT INTO hausa_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Sai mutumin ya ce, “Yanzu kam wannan ƙashi ne na ƙasusuwana nama kuma na namana. Za a ce da ita ‘mace,’ gama an ciro ta daga namiji.” ");
INSERT INTO hausa_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Wannan ne ya sa mutum yakan bar mahaifinsa da mahaifiyarsa, yă manne wa matarsa, su kuma zama jiki ɗaya. ");
INSERT INTO hausa_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Mutumin da matarsa, dukansu biyu tsirara suke, ba su kuwa ji kunya ba. ");
INSERT INTO hausa_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","To, maciji dai ya fi kowane a cikin namun jejin da Ubangiji Allah ya yi wayo. Ya ce wa macen, “Tabbatacce ne Allah ya ce, ‘Kada ku ci daga kowane itace a lambu’?” ");
INSERT INTO hausa_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Macen ta ce wa macijin, “Za mu iya ci daga ’ya’ya itatuwa a lambun, ");
INSERT INTO hausa_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","amma Allah ya ce, ‘Kada ku ci daga ’ya’yan itacen da yake tsakiyar lambu, kada kuma ku taɓa shi, in ba haka ba kuwa za ku mutu.’ ” ");
INSERT INTO hausa_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Maciji ya ce wa macen, “Tabbatacce ba za ku mutu ba. ");
INSERT INTO hausa_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Gama Allah ya san cewa sa’ad da kuka ci daga itacen idanunku za su buɗe, za ku kuma zama kamar Allah, ku san abin da yake mai kyau da abin da yake mugu.” ");
INSERT INTO hausa_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Sa’ad da macen ta ga ’ya’yan itacen suna da kyau don abinci, abin sha’awa ga ido, abin marmari kuma don samun hikima, sai ta tsinka ta ci, ta kuma ba da waɗansu wa mijinta wanda yake tare da ita, shi ma ya ci. ");
INSERT INTO hausa_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Sa’an nan idanun dukansu biyu suka buɗe, suka kuma gane tsirara suke; saboda haka suka ɗinɗinka ganyayen ɓaure suka yi wa kansu sutura. ");
INSERT INTO hausa_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Da mutumin da matarsa suka ji motsin Ubangiji Allah yana takawa a lambun a sanyin yini, sai suka ɓuya daga Ubangiji Allah a cikin itatuwan lambu. ");
INSERT INTO hausa_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Amma Ubangiji Allah ya kira mutumin ya ce, “Ina kake?” ");
INSERT INTO hausa_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Ya ce, “Na ji ka a cikin lambu, na kuwa ji tsoro gama ina tsirara, saboda haka na ɓuya.” ");
INSERT INTO hausa_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Sai ya ce, “Wa ya faɗa maka cewa kana tsirara? Ko dai ka ci daga itacen da na umarce ka kada ka ci ne?” ");
INSERT INTO hausa_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Mutumin ya ce, “Macen da ka sa a nan tare da ni, ita ta ba ni waɗansu ’ya’ya daga itacen, na kuwa ci.” ");
INSERT INTO hausa_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Sai Ubangiji Allah ya ce wa matar, “Me ke nan kika yi?” Matar ta ce, “Macijin ne ya ruɗe ni, na kuwa ci.” ");
INSERT INTO hausa_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Saboda haka Ubangiji Allah ya ce wa macijin, “Saboda ka yi haka, “Na la’anta ka cikin dukan dabbobi da kuma cikin dukan namun jeji! Daga yanzu rubda ciki za ka yi tafiya turɓaya kuma za ka ci dukan kwanakin rayuwarka. ");
INSERT INTO hausa_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Zan kuma sa ƙiyayya tsakaninka da macen, tsakanin zuriyarka da zuriyarta. Zai ragargaje kanka, kai kuma za ka sari ɗiɗɗigensa.” ");
INSERT INTO hausa_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Sa’an nan ya ce wa macen, “Zan tsananta naƙudarki ainun, da azaba kuma za ki haifi ’ya’ya. Za ki riƙa yin marmarin mijinki zai kuwa yi mulki a kanki.” ");
INSERT INTO hausa_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Ga Adamu kuwa ya ce, “Saboda ka saurari matarka, ka kuma ci daga itacen da na ce, ‘Kada ka ci,’ “Za a la’anta ƙasa saboda kai. Da wahala za ka ci daga cikinta dukan kwanakin rayuwarka. ");
INSERT INTO hausa_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Za tă ba ka ƙayayyuwa da sarƙaƙƙiya za ka kuwa ci ganyayen gona. ");
INSERT INTO hausa_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Da zuffan goshinka za ka ci abincinka har ka koma ga ƙasa, da yake daga cikinta aka yi ka. Gama kai turɓaya ne, kuma ga turɓaya za ka koma.” ");
INSERT INTO hausa_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Mutumin ya sa wa matarsa suna, Hawwa’u, gama za tă zama mahaifiyar masu rai duka. ");
INSERT INTO hausa_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Ubangiji Allah ya yi tufafin fata domin Adamu da Hawwa’u, ya kuma yi musu sutura. ");
INSERT INTO hausa_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Ubangiji Allah ya kuma ce, “To, fa, mutum ya zama kamar ɗaya daga cikinmu, ya san abin da yake mai kyau da abin da yake mugu. Kada a yarda yă miƙa hannunsa yă ɗiba daga itacen rai yă ci, yă kuma rayu har abada.” ");
INSERT INTO hausa_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Saboda haka Ubangiji Allah ya kore shi daga Lambun Eden domin yă nome ƙasa wadda aka yi shi. ");
INSERT INTO hausa_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Bayan da ya kori mutumin, sai ya sa kerubobi da takobi mai harshen wuta yana jujjuyawa baya da gaba a gabashin Lambun Eden don yă tsare hanya zuwa itacen rai. ");
INSERT INTO hausa_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adamu ya kwana da matarsa Hawwa’u, ta kuwa yi ciki ta haifi Kayinu. Sai ta ce, “Da taimakon Ubangiji na sami ɗa namiji.” ");
INSERT INTO hausa_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Daga baya ta haifi ɗan’uwansa, ta kuma ba shi suna Habila. Sa’ad da suka yi girma sai Habila ya zama makiyayin tumaki, Kayinu kuwa ya zama manomi. ");
INSERT INTO hausa_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Ana nan sai Kayinu ya kawo waɗansu amfanin gona a matsayin hadaya ga Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Amma Habila ya kawo mafi kyau daga ’ya’yan fari na garkensa. Ubangiji ya yi farin ciki da sadakar da Habila ya kawo, ");
INSERT INTO hausa_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","amma bai yi farin ciki da sadakar da Kayinu ya kawo ba. Saboda haka Kayinu ya ji fushi sosai, fuskarsa kuma ta ɓace. ");
INSERT INTO hausa_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Sai Ubangiji ya ce wa Kayinu, “Don me kake fushi? Don me fuskarka ta ɓace? ");
INSERT INTO hausa_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Da ka yi abin da yake daidai, ai, da ka sami karɓuwa. Amma tun da ba ka yi abin da ba daidai ba, zunubi zai yi fakonka don yă rinjaye ka kamar naman jeji. Yana so yă mallake ka, amma tilas ka rinjaye shi.” ");
INSERT INTO hausa_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","To, Kayinu ya ce wa ɗan’uwansa Habila, “Mu tafi gona.” Yayinda suke a gona, sai Kayinu ya tasar wa Habila ya buge shi ya kashe. ");
INSERT INTO hausa_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Sai Ubangiji ya ce wa Kayinu, “Ina ɗan’uwanka Habila?” Sai Kayinu ya ce, “Ban sani ba, ni mai gadin ɗan’uwana ne?” ");
INSERT INTO hausa_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Ubangiji ya ce, “Me ke nan ka yi? Saurara! Ga jinin ɗan’uwanka yana mini kuka daga ƙasa. ");
INSERT INTO hausa_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Yanzu, kai la’ananne ne, an kuma kore ka daga ƙasa wadda ta buɗe bakinta ta shanye jinin ɗan’uwanka daga hannunka. ");
INSERT INTO hausa_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","In ka nome ƙasa, ba za tă ƙara ba ka hatsinta ba. Za ka kuma zama mai yawo barkatai a duniya.” ");
INSERT INTO hausa_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kayinu ya ce wa Ubangiji, “Horon nan ya sha ƙarfina. ");
INSERT INTO hausa_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Ga shi, yau kana kori na daga ƙasar, zan zama a ɓoye daga fuskarka, zan kuma zama mai yawo barkatai, duk wanda ya same ni kuwa zai kashe ni.” ");
INSERT INTO hausa_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Amma Ubangiji ya ce masa, “Ba haka ba ne! Duk wanda ya kashe Kayinu, za a ninƙa hukuncinsa har sau bakwai.” Sa’an nan Ubangiji ya sa wa Kayinu alama don duk wanda ya same shi kada yă kashe shi. ");
INSERT INTO hausa_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Saboda haka Kayinu ya yi tafiyarsa ya rabu da Ubangiji, ya je ya zauna ƙasar Nod a gabashin Eden. ");
INSERT INTO hausa_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kayinu ya kwana da matarsa, ta kuwa yi ciki, ta haifi Enok. A lokacin Kayinu yana gina birni, sai ya sa wa birnin sunan ɗansa Enok. ");
INSERT INTO hausa_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Aka haifa wa Enok Irad, Irad kuma ya haifi Mehujayel, Mehujayel kuma ya haifi Metushayel, Metushayel kuma ya haifin Lamek. ");
INSERT INTO hausa_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamek ya auri mata biyu, ana ce da ɗaya Ada, ɗayan kuma Zilla. ");
INSERT INTO hausa_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada ta haifi Yabal, shi ne mahaifi waɗanda suke zama a tentuna, suna kuma kiwon dabbobi. ");
INSERT INTO hausa_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Sunan ɗan’uwansa Yubal, shi ne mahaifin dukan makaɗan garaya da masu hura sarewa. ");
INSERT INTO hausa_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Zilla ma ta haifi ɗa, Tubal-Kayinu, shi ne wanda ya ƙera kowane iri kayan aiki daga tagulla da kuma ƙarfe. ’Yar’uwar Tubal-Kayinu ita ce Na’ama. ");
INSERT INTO hausa_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Wata rana, Lamek ya ce wa matansa, Ada da Zilla, “Ku saurara, matan Lamek, ku ji maganata. Na kashe wani saboda ya yi mini rauni, na kashe wani saurayi saboda ya ji mini ciwo. ");
INSERT INTO hausa_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Idan za a rama wa Kayinu har sau bakwai, lalle za a rama wa Lamek sau saba’in da bakwai ke nan.” ");
INSERT INTO hausa_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Sai Adamu ya sāke kwana da matarsa, ta haifi ɗa, aka kuma ba shi suna Set, gama ta ce, “Allah ya ba ni wani yaro a madadin Habila, tun da yake Kayinu ya kashe shi.” ");
INSERT INTO hausa_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Set ma ya haifi ɗa, ya kuma kira shi Enosh. A lokaci ne, mutane suka fara kira ga sunan Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Wannan shi ne rubutaccen tarihin zuriyar Adamu. Sa’ad da Allah ya halicci mutum, ya yi shi cikin kamannin Allah. ");
INSERT INTO hausa_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Ya halicce su namiji da ta mace, ya kuma albarkace su. Sa’ad da kuma aka halicce su, ya kira su “Mutum.” ");
INSERT INTO hausa_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Sa’ad da Adamu ya yi shekaru 130, sai ya haifi ɗa wanda ya yi kama da shi, ya kuma kira shi Set. ");
INSERT INTO hausa_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Bayan an haifi Set, Adamu ya yi shekaru 800, ya kuma haifi waɗansu ’ya’ya maza da mata. ");
INSERT INTO hausa_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Gaba ɗaya dai, Adamu ya yi shekaru 930, sa’an nan ya mutu. ");
INSERT INTO hausa_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Sa’ad da Set ya yi shekara 105, sai ya haifi Enosh. ");
INSERT INTO hausa_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Bayan ya haifi Enosh, Set ya yi shekara 807, ya kuma haifi waɗansu ’ya’ya maza da mata. ");
INSERT INTO hausa_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Gaba ɗaya dai, Set ya yi shekaru 912, sa’an nan ya mutu. ");
INSERT INTO hausa_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Sa’ad da Enosh ya yi shekara 90, sai ya haifi Kenan. ");
INSERT INTO hausa_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Bayan ya haifi Kenan, Enosh ya yi shekara 815, ya kuma haifi waɗansu ’ya’ya maza da mata. ");
INSERT INTO hausa_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Gaba ɗaya dai, Enosh ya yi shekaru 905, sa’an nan ya mutu. ");
INSERT INTO hausa_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Sa’ad da Kenan ya yi shekara 70, sai ya haifi Mahalalel. ");
INSERT INTO hausa_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Bayan ya haifi Mahalalel, Kenan ya yi shekara 840, ya kuma haifi waɗansu ’ya’ya maza da mata ");
INSERT INTO hausa_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Gaba ɗaya dai, Kenan ya yi shekara 910, sa’an nan ya mutu. ");
INSERT INTO hausa_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Sa’ad da Mahalalel ya yi shekara 65, sai ya haifi Yared. ");
INSERT INTO hausa_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Bayan ya haifi Yared, Mahalalel ya yi shekara 830, ya kuma haifi waɗansu ’ya’ya maza da mata ");
INSERT INTO hausa_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Gaba ɗaya dai, Mahalalel ya yi shekara 895, sa’an nan ya mutu. ");
INSERT INTO hausa_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Sa’ad da Yared ya yi shekara 162, sai ya haifi Enok. ");
INSERT INTO hausa_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Bayan ya haifi Enok, Yared ya yi shekaru 800, ya kuma haifi waɗansu ’ya’ya maza da mata. ");
INSERT INTO hausa_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Gaba ɗaya dai, Yared ya yi shekara 962, sa’an nan ya mutu. ");
INSERT INTO hausa_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Sa’ad da Enok ya yi shekara 65, sai ya haifi Metusela. ");
INSERT INTO hausa_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Bayan ya haifi Metusela, Enok ya kasance cikin zumunci da Allah shekaru 300, ya kuma haifi waɗansu ’ya’ya maza da mata. ");
INSERT INTO hausa_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Gaba ɗaya dai, Enok ya yi shekaru 365. ");
INSERT INTO hausa_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Enok ya kasance cikin zumunci da Allah, sa’an nan ba a ƙara ganinsa ba. Saboda Allah ya ɗauke shi. ");
INSERT INTO hausa_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Sa’ad da Metusela ya yi shekara 187, sai ya haifi Lamek. ");
INSERT INTO hausa_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Bayan ya haifi Lamek, Metusela ya yi shekaru 782, ya kuma haifi waɗansu ’ya’ya maza da mata. ");
INSERT INTO hausa_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Gaba ɗaya dai, Metusela ya yi shekaru 969, sa’an nan ya mutu. ");
INSERT INTO hausa_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Sa’ad da Lamek ya yi shekara 182, sai ya haifi ɗa. ");
INSERT INTO hausa_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Ya ba shi suna Nuhu ya kuma ce, “Zai yi mana ta’aziyya a cikin aikinmu da wahalar hannuwanmu a ƙasar da Ubangiji ya la’anta.” ");
INSERT INTO hausa_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Bayan an haifi Nuhu, Lamek ya yi shekara 595, yana kuma da ’ya’ya maza da mata. ");
INSERT INTO hausa_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Gaba ɗaya dai, Lamek ya yi shekaru 777, sa’an nan ya mutu. ");
INSERT INTO hausa_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Bayan Nuhu ya yi shekara 500, sai ya haifi Shem, Ham da Yafet. ");
INSERT INTO hausa_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Sa’ad da mutane suka fara ƙaruwa a duniya, aka kuma hahhaifi musu ’ya’ya mata, ");
INSERT INTO hausa_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","sai ’ya’yan Allah maza suka ga cewa ’ya’yan mutane mata suna da bansha’awa, sai suka zaɓi waɗanda suke so, suka aura. ");
INSERT INTO hausa_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Sa’an nan Ubangiji ya ce, “Ruhuna ba zai zauna a cikin mutum har abada ba, saboda shi mai mutuwa ne, kwanakinsa za su zama shekaru ɗari da arba’in ne.” ");
INSERT INTO hausa_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Nefilimawa suna nan a duniya a waɗancan kwanaki, da kuma kwanakin da suka bi baya, a sa’ad da ’ya’yan Allah suka kwana da ’ya’yan mutane mata, suka kuma hahhaifi musu ’ya’ya. Ai, su ne jarumawan dā, mutanen da suka shahara. ");
INSERT INTO hausa_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Ubangiji kuwa ya lura cewa muguntar mutum ta yi yawa a duniya, kuma kowane abin da yake tunani a zuciyarsa mugu ne kawai a kowanne lokaci. ");
INSERT INTO hausa_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Ubangiji ya damu da ya yi mutum a duniya, abin ya zafe shi ƙwarai. ");
INSERT INTO hausa_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Saboda haka Ubangiji ya ce, “Zan kawar da mutum, da dabbobi, da halittu masu rarrafe a ƙasa da kuma tsuntsayen sama waɗanda na halitta, daga doron ƙasa, saboda na damu da na yi su.” ");
INSERT INTO hausa_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Amma Nuhu ya sami tagomashi a gaban Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Ga tarihin Nuhu. Nuhu mutum ne mai adalci, marar abin zargi a cikin mutanen zamaninsa, ya kuma yi tafiya tare da Allah. ");
INSERT INTO hausa_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Nuhu yana da ’ya’ya maza uku, Shem, Ham da Yafet. ");
INSERT INTO hausa_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Duniya dai ta lalace sosai a gaban Allah, ta kuma cika da tashin hankali. ");
INSERT INTO hausa_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Allah ya ga yadda duniya ta lalace, gama dukan mutane a duniya sun lalatar da rayuwarsu. ");
INSERT INTO hausa_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Saboda haka, Allah ya ce wa Nuhu, “Zan kawo ƙarshen dukan mutane, gama saboda su duniya ta cika da tashin hankali. Lalle zan hallaka su da kuma duniya. ");
INSERT INTO hausa_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Saboda haka ka yi wa kanka jirgi da katakon Saifires, ka yi ɗakuna a cikinsa, ka shafe shi da ƙaro ciki da waje. ");
INSERT INTO hausa_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Ga yadda za ka gina shi; jirgin zai kasance mai tsawon ƙafa 45, fāɗinsa ƙafa 75, tsayinsa kuma ƙafa 45. ");
INSERT INTO hausa_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Ka yi masa rufi, ka kuma ba da fili inci 18 tsakanin rufin a kowane gefen jirgin. Ka sa ƙofa a gefen jirgin. Ka yi shi hawa uku, ka yi ƙofa a gefe. ");
INSERT INTO hausa_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Ga shi zan aiko da ambaliya ruwa a duniya, in hallaka dukan mai rai da yake a ƙarƙashin sama, kowace halittar da take numfashi a cikinta. Dukan abin da yake a duniya zai hallaka. ");
INSERT INTO hausa_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Amma zan kafa alkawarina da kai, kai kuma za ka shiga jirgin, kai da ’ya’yanka maza da matarka da matan ’ya’yanka tare da kai. ");
INSERT INTO hausa_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Za ka shigar da biyu na dukan halittu masu rai, namiji da ta mace a cikin jirgin, domin su rayu tare da kai. ");
INSERT INTO hausa_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Biyu na kowane irin tsuntsu, kowace irin dabba da kuma kowace irin halitta mai rarrafe a ƙasa, za su zo wurinka domin a bar su da rai. ");
INSERT INTO hausa_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Za ka ɗauki kowane irin abinci wanda za a ci, ka adana don yă zama abincinka da nasu.” ");
INSERT INTO hausa_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Nuhu ya yi kome kamar yadda Allah ya umarce shi. ");
INSERT INTO hausa_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Sa’an nan Ubangiji ya ce wa Nuhu. “Shiga jirgin, kai da dukan iyalinka, gama na ga kai mai adalci ne a wannan zamani. ");
INSERT INTO hausa_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Ka ɗauki bakwai na kowace iri tsabtaccen dabba tare da kai, namiji da ta mace, da kuma biyu na kowace dabba marar tsabta, namiji da ta mace, ");
INSERT INTO hausa_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","da kuma bakwai na kowane iri tsuntsu, namiji da ta mace, domin a bar kowane irinsu da rai a dukan duniya. ");
INSERT INTO hausa_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Kwana bakwai daga yanzu zan aiko da ruwa a duniya yini arba’in da dare arba’in, zan kuma kawar da kowace halitta mai rai da na yi daga doron ƙasa.” ");
INSERT INTO hausa_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Nuhu ya aikata duk abin da Ubangiji ya umarce shi. ");
INSERT INTO hausa_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Nuhu yana da shekaru 106 ne sa’ad da aka yi ambaliya ruwa a duniya. ");
INSERT INTO hausa_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Nuhu da matarsa da ’ya’yansa da matansu, suka shiga jirgi domin su tsira daga ruwa ambaliya. ");
INSERT INTO hausa_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Biyu-biyu daga dabbobi masu tsabta da marasa tsabta, da tsuntsaye da kuma dukan halittu masu rarrafe a ƙasa, ");
INSERT INTO hausa_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","namiji da ta mace, suka zo wurin Nuhu, suka shiga jirgi, kamar yadda Allah ya umarce Nuhu. ");
INSERT INTO hausa_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Bayan kwana bakwai kuwa ambaliya ruwa ta sauko a bisa duniya. ");
INSERT INTO hausa_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","A ranar sha bakwai ga wata na biyu, na shekara ta ɗari shida na rayuwar Nuhu, a ran nan sai dukan maɓuɓɓugai na manyan zurfafa suka fashe, tagogin sammai suka buɗe. ");
INSERT INTO hausa_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Ruwa yana ta kwararowa bisa duniya, yini arba’in da dare arba’in. ");
INSERT INTO hausa_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","A wannan rana Nuhu tare da matarsa da ’ya’yansa maza, Shem, Ham da Yafet da matansu uku suka shiga jirgi. ");
INSERT INTO hausa_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Tare da su kuwa, akwai kowane naman jeji bisa ga irinsa, da dukan dabbobin gida bisa ga irinsu, da kowace halitta mai rarrafe a ƙasa bisa ga irinta, da kowane tsuntsun gida da na jeji bisa ga irinsa, da dukan abu mai fiffike. ");
INSERT INTO hausa_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Biyu-biyu na dukan halittu masu numfashi suka zo wurin Nuhu, suka shiga jirgi. ");
INSERT INTO hausa_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Dabbobi da kowane abu mai rai da suka shiga ciki, namiji ne da ta mace, yadda Allah ya umarci Nuhu. Sa’an nan Ubangiji ya kulle jirgin daga baya. ");
INSERT INTO hausa_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Kwana arba’in ambaliya ta yi ta saukowa a duniya, sa’ad da ruwa ya yi ta ƙaruwa sai ya yi ta ɗaga jirgin sama, ya kuwa tashi can bisa duniya. ");
INSERT INTO hausa_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Ruwa ya taso, ya ƙaru ƙwarai a duniya, jirgin kuma ya yi ta yawo a bisa ruwa. ");
INSERT INTO hausa_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Ruwa ya ƙaru ƙwarai a duniya, ya kuma rufe dukan duwatsu masu tsawo a ƙarƙashin sammai. ");
INSERT INTO hausa_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Ruwan ya taso ya rufe duwatsu, zurfin ruwa daga duwatsun zuwa inda jirgin yake ya fi ƙafa ashirin. ");
INSERT INTO hausa_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Kowane abu mai rai da yake tafiya a duniya ya hallaka, tsuntsaye, dabbobin gida, namun jeji, da dukan masu rarrafe waɗanda suke rarrafe a duniya, da kuma dukan mutane. ");
INSERT INTO hausa_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Kome a busasshiyar ƙasa da yake numfashi a hancinsa ya mutu. ");
INSERT INTO hausa_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Aka kawar da kowane abu mai rai, mutane da dabbobi da halittu masu rarrafe a ƙasa, da tsuntsayen sama a doron ƙasa, duka aka kawar da su daga duniya. Nuhu kaɗai aka bari da waɗanda suke tare da shi a cikin jirgi. ");
INSERT INTO hausa_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Ruwa ya mamaye duniya har kwana ɗari da hamsin. ");
INSERT INTO hausa_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Amma Allah ya tuna da Nuhu da dukan namun jeji da dabbobin da suke tare da shi a cikin jirgi, ya kuma aika da wata iska ta hura dukan duniya, ruwan kuwa ya janye. ");
INSERT INTO hausa_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Aka toshe maɓuɓɓugan zurfafa da ƙofofin ambaliyar sammai, ruwan sama kuma ya daina saukowa daga sarari. ");
INSERT INTO hausa_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Ruwan ya janye a hankali daga ƙasa. A ƙarshen kwanaki ɗari da hamsin ɗin, ruwan ya ragu. ");
INSERT INTO hausa_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","A rana ta goma sha bakwai ga watan bakwai, jirgin ya sauka a duwatsun Ararat. ");
INSERT INTO hausa_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Ruwan ya ci gaba da janyewa har watan goma. A rana ta fari ga watan goma kuwa ƙwanƙolin duwatsun suka bayyana. ");
INSERT INTO hausa_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Bayan kwana arba’in, sai Nuhu ya buɗe tagar jirgin da ya yi, ");
INSERT INTO hausa_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","ya saki hankaka. Hankaka ya yi ta kai da kawowa har sai da ruwa ya shanye a duniya. ");
INSERT INTO hausa_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Sai ya saki kurciya don yă ga in ruwan ya janye daga doron ƙasa. ");
INSERT INTO hausa_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Amma kurciyar ba tă sami inda za tă sa ƙafafunta ba gama akwai ruwa a dukan doron ƙasa, saboda haka ta komo wurin Nuhu a jirgi. Ya miƙa hannunsa ya ɗauko kurciyar ya shigar da ita wurinsa a cikin jirgi. ");
INSERT INTO hausa_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Ya ƙara jira kwana bakwai, sai ya sāke aiken kurciyar daga jirgi. ");
INSERT INTO hausa_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Sa’ad da kurciya ta komo wurinsa da yamma, sai ga ɗanyen ganyen zaitun da ta tsinko a bakinta! Sa’an nan Nuhu ya san cewa ruwa ya janye daga duniya. ");
INSERT INTO hausa_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Ya ƙara jira kwana bakwai, sai ya sāke aiken kurciyar, amma a wannan ƙaro ba tă komo wurinsa ba. ");
INSERT INTO hausa_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","A rana ta fari ga wata na fari wanda Nuhu ya cika shekaru 601, ruwa ya shanye a ƙasa. Sai Nuhu ya buɗe murfin jirgin, ya ga cewa doron ƙasa ya bushe. ");
INSERT INTO hausa_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","A ran ashirin da bakwai ga wata na biyu, ƙasa ta bushe ƙaƙaf. ");
INSERT INTO hausa_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Sa’an nan Allah ya ce wa Nuhu, ");
INSERT INTO hausa_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Fito daga jirgin, kai da matarka da ’ya’yanka maza da matansu. ");
INSERT INTO hausa_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Ka fitar da kowane iri halitta mai rai da take tare da kai waje, tsuntsaye, dabbobi, da dukan halittu masu rarrafe a ƙasa, don su yi ta haihuwa, su yi yawa, su ƙaru a duniya.” ");
INSERT INTO hausa_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Sai Nuhu ya fito tare da matarsa da ’ya’yansa maza da matan ’ya’yansa, ");
INSERT INTO hausa_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","da kowace irin dabba, da kowane mai rarrafe, da kowane irin tsuntsu, da kowane irin abu da yake tafiya a bisa duniya, suka fito daga jirgi daki-daki bisa ga irinsu. ");
INSERT INTO hausa_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Sai Nuhu ya gina bagaden hadaya ga Ubangiji, ya ɗiba waɗansu dabbobi da tsuntsaye masu tsabta, ya yi hadaya ta ƙonawa da su a kan bagaden. ");
INSERT INTO hausa_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Da Ubangiji ya ji ƙanshi mai daɗi, sai ya ce a zuciyarsa, “Ba zan ƙara la’anta ƙasa saboda mutum ba, ko da yake dukan tunanin zuciyar mutum mugu ne tun yana ƙarami. Ba kuwa zan ƙara hallaka dukan halittu masu rai, kamar yadda na yi ba. ");
INSERT INTO hausa_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","“Muddin duniya tana nan, lokacin shuki da na girbi, lokacin sanyi da na zafi, lokacin damina da na rani, dare da rana ba za su daina ba.” ");
INSERT INTO hausa_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Sa’an nan Allah ya sa wa Nuhu da ’ya’yansa maza albarka, yana ce musu, “Ku haifi ’ya’ya, ku ƙaru, ku kuma cika duniya. ");
INSERT INTO hausa_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Dukan namun jeji da dukan tsuntsayen sama da kowace halitta mai rarrafe a ƙasa, da dukan kifayen teku, za su riƙa jin tsoronku, suna fargaba. An sa su a cikin hannuwanku. ");
INSERT INTO hausa_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Kome da yake da rai wanda yake tafiya, zai zama abincinku. Kamar yadda na ba ku kowane irin ganye, haka na ba ku kome da kome. ");
INSERT INTO hausa_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","“Akwai abu ɗaya da ba za ku ci ba, wato, nama wanda jininsa yake cikinsa tukuna. ");
INSERT INTO hausa_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Game da jinin ranka kuwa lalle zan bukaci lissafi. Zan bukaci lissafi daga kowane dabba. kuma daga kowane mutum, shi ma zan bukaci lissafi game da ran ɗan’uwansa. ");
INSERT INTO hausa_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","“Duk wanda ya zub da jinin mutum, ta hannun mutum za a zub da jininsa; gama a cikin siffar Allah ne, Allah ya yi mutum. ");
INSERT INTO hausa_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Amma ku, ku yi ta haihuwa, ku ƙaru; ku yaɗu a duniya, ku yi yawa a bisanta.” ");
INSERT INTO hausa_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Sai Allah ya ce wa Nuhu da ’ya’yansa, ");
INSERT INTO hausa_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Yanzu na kafa alkawarina da ku da zuriyarku a bayanku, ");
INSERT INTO hausa_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","da kowace halitta mai rai wadda ta kasance tare da kai; wato, tsuntsaye da dabbobin gida da kuma dukan namun jeji, duk dai iyakar abin da ya fita daga jirgin; wato, kowane mai rai na duniya. ");
INSERT INTO hausa_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Na kafa alkawarina da ku, ba za a ƙara hallaka dukan rayuka da ambaliyar ruwa ba; ba za a ƙara yin ambaliya don a hallaka duniya ba.” ");
INSERT INTO hausa_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Allah ya kuma ce, “Wannan ita ce alamar alkawarin da na yi tsakanina da ku, da kowace halitta tare da ku; alkawari na dukan zamanai masu zuwa. ");
INSERT INTO hausa_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Na sa bakan gizona cikin gizagizai, shi ne kuwa zai zama alamar alkawari tsakanina da duniya. ");
INSERT INTO hausa_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Duk sa’ad da na kawo gizagizai a bisa duniya, bakan gizo kuma ya bayyana a ciki gizagizan, ");
INSERT INTO hausa_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","zan tuna da alkawari tsakanina da ku da kuma dukan halittu masu rai na kowane iri. Ruwa ba zai sāke yin ambaliyar da za tă hallaka dukan masu rai ba. ");
INSERT INTO hausa_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Duk sa’ad da bakan gizo ya bayyana cikin gizagizan, zan gan shi in kuma tuna da madawwamin alkawari tsakanin Allah da dukan halittu masu rai, na kowane iri a duniya.” ");
INSERT INTO hausa_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Saboda haka Allah ya ce wa Nuhu, “Wannan ita ce alamar alkawarin da na kafa tsakanina da dukan masu rai a duniya.” ");
INSERT INTO hausa_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","’Ya’yan Nuhu maza, waɗanda suka fito daga cikin jirgi, su ne, Shem, Ham da Yafet. (Ham shi ne mahaifin Kan’ana.) ");
INSERT INTO hausa_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Waɗannan su ne ’ya’yan Nuhu maza uku, daga gare su ne kuma duniya za tă cika da mutane. ");
INSERT INTO hausa_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nuhu, mutumin ƙasa, shi ne farko da ya fara yin gonar inabi. ");
INSERT INTO hausa_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Sa’ad da ya sha ruwan inabin ya kuwa bugu, sai ya kwanta tsirara cikin tentinsa. ");
INSERT INTO hausa_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ham, mahaifin Kan’ana ya ga tsiraici mahaifinsa, ya kuma faɗa wa ’yan’uwansa biyu a waje. ");
INSERT INTO hausa_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Amma Shem da Yafet suka ɗauki mayafi, suka shimfiɗa a kafaɗarsu, sa’an nan suka shiga suna tafiya da baya har zuwa inda mahaifinsu yake kwance, suka rufe tsiraicinsa. Suka kau da fuskokinsu domin kada su ga tsiraicin mahaifinsu. ");
INSERT INTO hausa_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Sa’ad da Nuhu ya farka daga buguwarsa ya kuma gane abin da ƙarami ɗansa ya yi, ");
INSERT INTO hausa_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","sai ya ce, “Kan’ana la’ananne ne, zai zama bawa mafi ƙanƙanta ga ’yan’uwansa.” ");
INSERT INTO hausa_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Ya kuma ce, “Albarka ta tabbata ga Ubangiji Allah na Shem! Bari Kan’ana yă zama bawan Shem. ");
INSERT INTO hausa_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Allah yă ƙara fāɗin ƙasar Yafet; bari Yafet yă zauna a tentunan Shem, bari kuma Kan’ana yă zama bawansa.” ");
INSERT INTO hausa_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Bayan ambaliyar, Nuhu ya yi shekaru 350. ");
INSERT INTO hausa_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Gaba ɗaya dai, Nuhu ya yi shekara 950, sa’an nan ya mutu. ");
INSERT INTO hausa_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Wannan shi ne labarin Shem, Ham da Yafet, ’ya’yan Nuhu maza, waɗanda su ma sun haifi ’ya’ya maza bayan ambaliyar. ");
INSERT INTO hausa_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","’Ya’yan Yafet maza su ne, Gomer, Magog, Madai da Yaban, Tubal, Meshek, da kuma Tiras. ");
INSERT INTO hausa_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","’Ya’yan Gomer maza su ne, Ashkenaz, Rifat, da Togarma. ");
INSERT INTO hausa_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","’Ya’yan maza Yaban su ne, Elisha, Tarshish, Kittim da Rodanim. ");
INSERT INTO hausa_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","(Daga waɗannan mutane ne masu zama a bakin teku suka bazu zuwa cikin ƙasashensu da kuma cikin al’ummansu, kowanne da yarensa.) ");
INSERT INTO hausa_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","’Ya’yan Ham maza su ne, Kush, Masar, Fut, da Kan’ana. ");
INSERT INTO hausa_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","’Ya’yan Kush maza su ne, Seba, Hawila, Sabta, Ra’ama da Sabteka. ’Ya’yan Ra’ama maza kuwa su ne, Sheba da Dedan. ");
INSERT INTO hausa_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kush shi ne mahaifin Nimrod wanda ya yi girma ya zama jarumin yaƙi a duniya. ");
INSERT INTO hausa_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Shi babban maharbi ne a gaban Ubangiji. Shi ya sa akan ce, kamar Nimrod babban maharbi a gaban Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Cibiyoyin mulkinsa na farko su ne Babilon, Erek, Akkad, da Kalne a cikin Shinar. ");
INSERT INTO hausa_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Daga wannan ƙasa, sai ya tafi Assuriya, inda ya gina Ninebe, Rehobot Ir, Kala ");
INSERT INTO hausa_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","da Resen, wadda take tsakanin Ninebe da Kala; wanda yake babban birni. ");
INSERT INTO hausa_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Mizrayim shi ne mahaifin Ludiyawa, Anamawa, Lehabiyawa, Naftuhiyawa, ");
INSERT INTO hausa_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Fetrusiyawa, da Kasluhiyawa (inda Filistiyawa suka fito) da kuma Kaftorawa. ");
INSERT INTO hausa_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kan’ana shi ne mahaifin, Sidon ɗan farinsa, da na Hittiyawa, ");
INSERT INTO hausa_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Yebusiyawa, Amoriyawa, Girgashiyawa, ");
INSERT INTO hausa_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hiwiyawa, Arkiyawa, Siniyawa, ");
INSERT INTO hausa_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Arbadiyawa, Zemarawa, da Hamawa. Daga baya zuriyar Kan’aniyawa suka yaɗu ");
INSERT INTO hausa_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","har iyakar Kan’ana ta kai Sidon ta wajen Gerar har zuwa Gaza, sa’an nan ta milla zuwa Sodom, Gomorra, Adma da Zeboyim, har zuwa Lasha. ");
INSERT INTO hausa_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Waɗannan su ne ’ya’yan Ham maza bisa ga zuriyarsu da yarurrukansu, cikin ƙasashensu da kuma al’ummominsu. ");
INSERT INTO hausa_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Aka kuma haifa wa Shem, wan Yafet, ’ya’ya maza. Shem shi ne kakan ’ya’yan Eber duka. ");
INSERT INTO hausa_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","’Ya’yan Shem maza su ne, Elam, Asshur, Arfakshad, Lud da Aram. ");
INSERT INTO hausa_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","’Ya’yan Aram maza su ne, Uz, Hul, Geter da Mash. ");
INSERT INTO hausa_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arfakshad ne mahaifin Shela. Shela kuma shi ne mahaifin Eber. ");
INSERT INTO hausa_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Aka haifa wa Eber ’ya’ya maza biyu. Aka ba wa ɗaya suna Feleg, gama a zamaninsa ne aka raba duniya; aka kuma sa wa ɗan’uwansa suna Yoktan. ");
INSERT INTO hausa_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yoktan shi ne mahaifin, Almodad, Shelef, Hazarmawet, Yera, ");
INSERT INTO hausa_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Uzal, Dikla, ");
INSERT INTO hausa_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimayel, Sheba, ");
INSERT INTO hausa_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Hawila da Yobab. Dukan waɗannan ’ya’yan Yoktan maza ne. ");
INSERT INTO hausa_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Yankin da suka zauna ya miƙe daga Mesha zuwa wajen Sefar a gabashin ƙasar tudu. ");
INSERT INTO hausa_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Waɗannan su ne ’ya’yan Shem maza bisa ga zuriyarsu da yarurrukansu, cikin ƙasashensu da kuma al’ummominsu. ");
INSERT INTO hausa_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Waɗannan su ne zuriyar ’ya’yan Nuhu maza bisa ga jerin zuriyarsu cikin al’ummominsu. Daga waɗannan ne al’ummomi suka bazu ko’ina a duniya bayan ambaliya. ");
INSERT INTO hausa_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","To, a lokacin, yaren mutanen duniya ɗaya ne, maganarsu kuma ɗaya ce. ");
INSERT INTO hausa_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Yayinda mutane suke ta yin ƙaura zuwa gabas, sai suka sami fili a Shinar, suka zauna a can. ");
INSERT INTO hausa_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Suka ce wa juna, “Ku zo, mu yi tubula, mu gasa su sosai.” Suka yi amfani da tubula a maimakon duwatsu, kwalta kuma a maimakon laka. ");
INSERT INTO hausa_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Sa’an nan suka ce, “Ku zo, mu gina wa kanmu birni da hasumiyar da za tă kai har sammai, domin mu yi wa kanmu suna, don kada mu warwatsu ko’ina a doron ƙasa.” ");
INSERT INTO hausa_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Sai Ubangiji ya sauko don yă ga birni da kuma hasumiyar da mutanen suke gini. ");
INSERT INTO hausa_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Ubangiji ya ce, “Ga su, su jama’a ɗaya ce, su duka kuwa harshensu guda ne. Wannan kuwa masomi ne kawai na abin da za su iya yi, babu kuma abin da suka yi shirya yi da ba za su iya yi ba. ");
INSERT INTO hausa_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Zo, mu sauka, mu rikitar da harshensu don kada su fahimci juna.” ");
INSERT INTO hausa_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Saboda haka Ubangiji ya watsar da su daga wurin zuwa ko’ina a doron ƙasa, suka kuwa daina gina birnin. ");
INSERT INTO hausa_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Shi ya sa aka kira birnin Babel, domin a can ne Ubangiji ya rikitar da harshen dukan duniya. Daga can Ubangiji ya watsar da su ko’ina a doron ƙasa. ");
INSERT INTO hausa_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Wannan shi ne labarin Shem. Shekara biyu bayan ambaliya, sa’ad da Shem ya yi shekara 100, sai ya haifi Arfakshad. ");
INSERT INTO hausa_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Bayan ya haifi Arfakshad, Shem ya yi shekara 500, ya haifi waɗansu ’ya’ya maza da mata. ");
INSERT INTO hausa_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Sa’ad da Arfakshad ya yi shekara 35, sai ya haifi Shela. ");
INSERT INTO hausa_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Bayan ya haifi Shela kuwa, Arfakshad ya yi shekara 403, ya kuma haifi waɗansu ’ya’ya maza da mata. ");
INSERT INTO hausa_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Sa’ad da Shela ya yi shekaru 30, sai ya haifi Eber. ");
INSERT INTO hausa_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Bayan ya haifi Eber, Shela ya yi shekara 403, ya kuma haifi waɗansu ’ya’ya maza da mata. ");
INSERT INTO hausa_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Sa’ad da Eber ya yi shekaru 34, sai ya haifi Feleg. ");
INSERT INTO hausa_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Bayan ya haifi Feleg, Eber ya yi shekara 430, ya kuma haifi waɗansu ’ya’ya maza da mata. ");
INSERT INTO hausa_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Sa’ad da Feleg ya yi shekaru 30, sai ya haifi Reyu. ");
INSERT INTO hausa_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Bayan ya haifi Reyu, Feleg ya yi shekara 209, ya kuma haifi waɗansu ’ya’ya maza da mata. ");
INSERT INTO hausa_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Sa’ad da Reyu ya yi shekaru 32, sai ya haifi Serug. ");
INSERT INTO hausa_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Bayan ya haifi Serug, Reyu ya yi shekara 207, ya kuma haifi waɗansu ’ya’ya maza da mata. ");
INSERT INTO hausa_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Sa’ad da Serug ya yi shekaru 30, sai ya haifi Nahor. ");
INSERT INTO hausa_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Bayan ya haifi Nahor, Serug ya yi shekara 200, ya kuma haifi waɗansu ’ya’ya maza da mata. ");
INSERT INTO hausa_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Sa’ad da Nahor ya yi shekaru 29, sai ya haifi Tera. ");
INSERT INTO hausa_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Bayan ya haifi Tera, Nahor ya yi shekara 119, ya kuma haifi waɗansu ’ya’ya maza da mata. ");
INSERT INTO hausa_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Bayan Tera ya yi shekaru 70, sai ya haifi Abram, Nahor da Haran. ");
INSERT INTO hausa_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Wannan ita ce zuriyar Tera. Tera ya haifi Abram, Nahor da Haran. Haran kuma ya haifi Lot. ");
INSERT INTO hausa_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Yayinda mahaifinsa Tera yana da rai, Haran ya rasu a Ur ta Kaldiyawa, a ƙasar haihuwarsa. ");
INSERT INTO hausa_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abram da Nahor suka yi aure. Sunan matar Abram, Saira ne, sunan matar Nahor kuwa Milka; ita ’yar Haran ce, mahaifin Milka da Iska. ");
INSERT INTO hausa_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Saira kuwa bakararriya ce, ba ta da yara. ");
INSERT INTO hausa_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Tera ya ɗauki ɗansa Abraham, jikansa Lot ɗan Haran, da surukarsa Saira, matar Abram, tare kuwa suka bar Ur ta Kaldiyawa, don su tafi Kan’ana. Amma sa’ad da suka zo Haran sai suka zauna a can. ");
INSERT INTO hausa_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tera yi shekaru 205, ya kuma mutu a Haran. ");
INSERT INTO hausa_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Ubangiji ya ce wa Abram, “Tashi ka bar ƙasarka, da mutanenka, da iyalin mahaifinka, ka tafi ƙasar da zan nuna maka. ");
INSERT INTO hausa_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","“Zan mai da kai al’umma mai girma, zan kuma albarkace ka; zan sa sunanka yă zama mai girma, ka kuma zama sanadin albarka. ");
INSERT INTO hausa_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Zan albarkaci duk wanda ya albarkace ka, in kuma la’anci duk wanda ya la’anta ka, dukan mutanen duniya za su sami albarka ta wurinka.” ");
INSERT INTO hausa_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Saboda haka Abram ya tashi yadda Ubangiji ya faɗa masa; Lot ma ya tafi tare da shi. Abram yana da shekaru 75, sa’ad da ya tashi daga Haran. ");
INSERT INTO hausa_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Abram ya ɗauki matarsa Saira da Lot ɗan ɗan’uwansa, da dukan mallakar da suka tattara, da kuma mutanen da suka samu a Haran, suka kama hanya zuwa ƙasar Kan’ana. ");
INSERT INTO hausa_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abram ya ratsa ƙasar har zuwa wurin babban itace na More a Shekem. A lokacin Kan’aniyawa suna a ƙasar. ");
INSERT INTO hausa_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Ubangiji ya bayyana ga Abram ya ce, “Ga zuriyarka ne zan ba da wannan ƙasa.” Saboda haka Abram ya gina bagade a can ga Ubangiji, wanda ya bayyana gare shi. ");
INSERT INTO hausa_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Daga can, ya ci gaba zuwa wajen tuddai a gabashin Betel ya kafa tentinsa, Betel yana yamma, Ai, kuma a gabas. A can ya gina bagade ga Ubangiji ya kuma kira bisa sunan Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Sa’an nan Abram ya tashi ya ci gaba da tafiya zuwa wajen Negeb. ");
INSERT INTO hausa_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","To, a lokacin, an yi yunwa a ƙasar, sai Abram ya gangara zuwa Masar don yă zauna a can na ɗan lokaci, domin yunwa ta yi tsanani. ");
INSERT INTO hausa_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Yayinda yana gab da shiga Masar, sai ya ce wa matarsa Saira, “Na sani ke kyakkyawar mace ce. ");
INSERT INTO hausa_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Sa’ad da Masarawa suka ganki, za su ce, ‘Wannan matarsa ce.’ Za su kuwa kashe ni, su bar ki da rai. ");
INSERT INTO hausa_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Saboda haka ki ce ke ’yar’uwata ce, domin ta dalilinki a mutunta ni, a kuma bar ni da rai.” ");
INSERT INTO hausa_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Sa’ad da Abram ya isa Masar, Masarawa suka ga cewa Saira kyakkyawa mace ce ƙwarai. ");
INSERT INTO hausa_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Sa’ad da fadawan Fir’auna suka gan ta kuwa, sai suka yabe ta wajen Fir’auna, aka kuwa kawo ta cikin fadarsa. ");
INSERT INTO hausa_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Ya mutunta Abram sosai saboda ita, Abram kuwa ya mallaki tumaki da shanu, da jakuna maza da mata, da bayi maza da mata, da kuma raƙuma. ");
INSERT INTO hausa_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Amma Ubangiji ya wahalar da Fir’auna da gidansa da cututtuka masu zafi saboda Saira, matar Abram. ");
INSERT INTO hausa_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Saboda haka Fir’auna ya kira Abram ya ce, “Me ke nan ka yi mini? Me ya sa ba ka faɗa mini cewa ita matarka ce ba? ");
INSERT INTO hausa_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Don me ka ruɗe ni cewa, ‘Ita ’yar’uwata ce,’ har na ɗauke ta tă zama matata? To, ga matarka. Ɗauke ta ka tafi.” ");
INSERT INTO hausa_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Sa’an nan Fir’auna ya yi wa mutanensa umarni a kan Abram, suka kuwa sallame shi tare da matarsa da kuma dukan abin da yake da shi. ");
INSERT INTO hausa_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Saboda haka Abram ya haura daga Masar zuwa Negeb tare da matarsa, da dukan abin da yake da shi tare da Lot. ");
INSERT INTO hausa_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abram ya azurta ƙwarai da dabbobi, da azurfa, da kuma zinariya. ");
INSERT INTO hausa_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Daga Negeb, ya ci gaba da tafiyarsa a wurare dabam-dabam har ya kai tsakanin Betel da Ai, a inda dā ya kafa tentinsa na fari ");
INSERT INTO hausa_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","da kuma inda dā ya gina bagade. A can Abram ya kira bisa sunan Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lot wanda yake tafiya tare da Abram, shi ma yana da garken shanu da tumaki da kuma tentuna. ");
INSERT INTO hausa_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Wannan ya sa har ƙasar ba tă ishe su yayinda suke zama tare ba, saboda mallakarsu ta yi yawa har ba za su iya zama tare ba. ");
INSERT INTO hausa_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Rikici kuma ya tashi tsakanin masu kiwon dabbobin Abram da na Lot. Mazaunan ƙasar, a lokacin kuwa Kan’aniyawa da Ferizziyawa ne. ");
INSERT INTO hausa_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Saboda haka Abram ya ce wa Lot, “Kada mu bar rikici yă shiga tsakaninmu, ko kuma tsakanin masu kiwon dabbobinka da nawa, gama mu ’yan’uwa ne. ");
INSERT INTO hausa_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Ba ga dukan ƙasar tana gabanka ba? Bari mu rabu. In ka yi hagu sai ni in yi dama. In ka yi dama, sai ni in yi hagu.” ");
INSERT INTO hausa_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lot ya ɗaga idanunsa sama ya dubi kwarin Urdun, sai ya ga kwarin yana da ciyawa mai kyau ƙwarai sai ka ce lambun Ubangiji, kamar ƙasar Masar, wajajen Zowar. (Wannan fa kafin Ubangiji yă hallaka Sodom da Gomorra.) ");
INSERT INTO hausa_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Saboda haka sai Lot ya zaɓar wa kansa dukan kwarin Urdun, ya tashi ya nufi wajen gabas. Haka fa suka rabu da juna. ");
INSERT INTO hausa_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram ya zauna a ƙasar Kan’ana, yayinda Lot ya zauna cikin biranen kwari, ya kafa tentunansa kusa da Sodom. ");
INSERT INTO hausa_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Mutanen Sodom kuwa mugaye ne, sun aikata zunubi ƙwarai ga Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Bayan Lot ya rabu da Abram, sai Ubangiji ya ce wa Abram, “Ɗaga idanunka daga inda kake, ka dubi arewa da kudu, gabas da yamma. ");
INSERT INTO hausa_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Dukan ƙasar da kake gani zan ba ka, kai da zuriyarka har abada. ");
INSERT INTO hausa_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Zan sa zuriyarka tă yi yawa kamar ƙurar ƙasa, har in wani yana iya ƙidaya ƙurar, to, za a iya ƙidaya zuriyarka. ");
INSERT INTO hausa_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Tafi, ka ratsa tsawo da fāɗin ƙasar, gama zan ba ka ita.” ");
INSERT INTO hausa_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Saboda haka Abram ya cire tentunansa, ya zo ya zauna kusa da manyan itatuwan Mamre a Hebron, inda ya gina bagade ga Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","A zamanin Amrafel sarkin Shinar, shi da Ariyok sarkin Ellasar, Kedorlayomer sarkin Elam, da kuma Tidal sarkin Goyim ");
INSERT INTO hausa_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","suka tafi don su yaƙi Bera sarkin Sodom, Birsha sarkin Gomorra, Shinab sarkin Adma, Shemeber sarkin Zeboyim, da kuma sarkin Bela (wato, Zowar). ");
INSERT INTO hausa_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Dukan waɗannan sarakuna na bayan nan suka haɗa kai a Kwarin Siddim (Teku Gishiri). ");
INSERT INTO hausa_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Shekara goma sha biyu suna bauta wa Kedorlayomer, amma a shekara ta sha uku sai suka yi tawaye. ");
INSERT INTO hausa_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","A shekara ta goma sha huɗu, Kedorlayomer da sarakunan da suka haɗa kai da shi suka tafi suka cinye Refahiyawa a Ashterot Karnayim, Zuziyawa a Ham, Emawa a Shabe Kiriyatayim, ");
INSERT INTO hausa_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","da Horiyawa a ƙasar tudun Seyir har zuwa El Faran kusa da hamada. ");
INSERT INTO hausa_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Sa’an nan suka juya suka tafi En Mishfat (wato, Kadesh), suka cinye dukan ƙasar Amalekawa, da kuma Amoriyawa waɗanda suke zaune a Hazazon Tamar. ");
INSERT INTO hausa_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Sai sarkin Sodom, sarkin Gomorra, sarkin Adma, sarkin Zeboyim da sarkin Bela (wato, Zowar), suka fita suka ja dāgā a Kwarin Siddim ");
INSERT INTO hausa_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","gāba da Kedorlayomer sarkin Elam, Tidal sarkin Goyim, Amrafel sarkin Shinar da Ariyok sarkin Ellasar; sarakuna huɗu gāba da biyar. ");
INSERT INTO hausa_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Kwarin Siddim kuwa ya cika da ramummukan kwalta, sa’ad da sarakunan Sodom da Gomorra suka gudu kuwa, waɗansu mutane suka fāɗa cikin ramummukan kwaltan, sauran kuwa suka gudu zuwa tuddai. ");
INSERT INTO hausa_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Sarakunan nan huɗu suka washe dukan kayayyakin Sodom da Gomorra, da kuma dukan abincinsu, sa’an nan suka tafi. ");
INSERT INTO hausa_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Suka kuma kama Lot ɗan ɗan’uwan Abram, wanda yake zaune a Sodom, da kayayyakinsa, suka yi tafiyarsu. ");
INSERT INTO hausa_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Sai wani wanda ya tsira, ya zo ya faɗa wa Abram mutumin Ibraniyawa. Abram kuwa yana zama kusa da manyan itatuwan Mamre, Mamre mutumin Amoriyawa ne ɗan’uwan Eshkol da Aner, su kuwa abokan Abram ne. ");
INSERT INTO hausa_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Da Abram ya ji cewa an kama danginsa, sai ya tara horarrun mutane 318, da aka haifa a gidansa, ya bi sawun sarakunan da suka tafi da Lot, har Dan. ");
INSERT INTO hausa_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Da dad dare, Abram ya rarraba mutanensa don su fāɗa wa sarakunan nan, ya ɗibge su, ya kore su har zuwa Hoba, arewa da Damaskus. ");
INSERT INTO hausa_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Ya washe su da kuma dukan kayayyakinsu, ya kuma dawo da Lot danginsa da mallakarsa, tare da mata da sauran mutane. ");
INSERT INTO hausa_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Bayan Abram ya dawo daga cin Kedorlayomer da sarakunan da suka haɗa kai da shi a yaƙi, sai sarkin Sodom ya fito don yă tarye Abram a Kwarin Shabe (wato, Kwarin Sarki). ");
INSERT INTO hausa_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Sai Melkizedek sarkin Salem ya kawo burodi da ruwan inabi. Shi firist ne na Allah Mafi Ɗaukaka, ");
INSERT INTO hausa_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","ya albarkaci Abram yana cewa, “Allah Mafi Ɗaukaka Mahaliccin sama da ƙasa yă albarkace Abram. ");
INSERT INTO hausa_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Kuma albarka ta tabbata ga Allah Mafi Ɗaukaka wanda ya ba da maƙiyanka a hannunka.” Sa’an nan Abram ya ba shi kashi ɗaya bisa goma na kome. ");
INSERT INTO hausa_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Sarkin Sodom ya ce wa Abram, “Ka ba ni mutanena da ka ƙwace daga hannun sarakunan nan kawai, ka riƙe kayayyakin don kanka.” ");
INSERT INTO hausa_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Amma Abram ya ce, wa sarkin Sodom, “Na ɗaga hannu ga Ubangiji Allah Mafi Ɗaukaka, Mahaliccin sama da ƙasa, na riga na rantse ");
INSERT INTO hausa_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","cewa ba zan karɓi kome da yake naka ba, ko zare ko maɗaurin takalma, don kada ka ce, ‘Na azurta Abram.’ ");
INSERT INTO hausa_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Ba zan karɓi kome ba, sai dai abin da mutanena suka ci da kuma rabon mutanen da suka tafi tare da ni, ga Aner, Eshkol, da Mamre. Bari su ɗauki rabonsu.” ");
INSERT INTO hausa_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Bayan wannan, maganar Ubangiji ta zo wa Abram cikin mafarki cewa, “Kada ka ji tsoro, Abram. Ni ne garkuwarka, kuma ladanka zai zama mai girma.” ");
INSERT INTO hausa_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Amma Abram ya ce, “Ya Ubangiji Mai Iko Duka, mene ne za ka ba ni, ganin cewa ba na haihuwa, wanda kuma zai gāji gādon gidana shi ne Eliyezer mutumin Damaskus?” ");
INSERT INTO hausa_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Abram ya kuma ce, “Ga shi ba ka ba ni ɗa ba, don haka bawan da aka haifa a gidana ne zai zama magājina.” ");
INSERT INTO hausa_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Sa’an nan maganar Ubangiji ta zo gare shi cewa, “Wannan mutum ba zai zama magājinka ba, ɗa da yake zuwa daga jikinka ne zai zama magājinka.” ");
INSERT INTO hausa_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Sai Ubangiji ya fito da kai shi waje ya ce, “Ka dubi sammai ka kuma ƙirga taurari, in har za ka iya ƙirga su.” Sa’an nan ya ce masa, “Haka zuriyarka za tă zama.” ");
INSERT INTO hausa_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abram ya gaskata, Ubangiji kuma ya lasafta shi adalci ga Abram. ");
INSERT INTO hausa_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Ubangiji ya kuma ce wa Abram, “Ni ne Ubangiji wanda ya fitar da kai daga Ur na Kaldiyawa, domin in ba ka wannan ƙasa ka mallake ta.” ");
INSERT INTO hausa_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Amma Abram ya ce, “Ya Ubangiji Mai Iko Duka, yaya zan san cewa zan mallake ta?” ");
INSERT INTO hausa_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Saboda haka Allah ya ce masa, “Kawo mini karsana, akuya, da kuma rago kowanne yă kasance shi shekara uku ne, da kurciya da kuma ɗan tattabara.” ");
INSERT INTO hausa_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Abram ya kawo waɗannan duka a gaban Allah, ya raba kowannensu a tsakiya, ya ajiye su gab da juna, amma bai tsaga tsuntsayen a tsaka ba. ");
INSERT INTO hausa_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Sai tsuntsaye masu cin nama suka sauko a kan gawawwakin, amma Abram ya kore su. ");
INSERT INTO hausa_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Yayinda rana tana fāɗuwa, sai Abram ya yi barci mai zurfi, sai wani duhu mai kauri mai kuma bantsoro ya rufe shi. ");
INSERT INTO hausa_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Sa’an nan Ubangiji ya ce wa Abram, “Ka sani tabbatacce cewa shekaru ɗari huɗu, zuriyarka za tă zama baƙi a ƙasar da ba tasu ba, za a mai da su bayi, a kuma wulaƙanta su. ");
INSERT INTO hausa_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Amma zan hukunta al’ummar da suka yi bauta kamar bayi, daga baya kuma za su fita da mallaka mai yawa. ");
INSERT INTO hausa_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Amma kai za ka koma wurin kakanninka cikin salama a kuma binne ka da kyakkyawan tsufa. ");
INSERT INTO hausa_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","A tsara ta huɗu zuriyarka za tă komo nan, saboda zunubin Amoriyawa bai riga ya cika ba.” ");
INSERT INTO hausa_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Sa’ad da rana ta fāɗi, aka kuwa yi duhu, sai wata tukunya mai hayaƙi, mai harshen wuta mai ci, ta bayyana, ta kuma wuce tsakanin abubuwan nan da aka tsaga. ");
INSERT INTO hausa_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","A wannan rana, Ubangiji ya yi alkawari da Abram ya ce, “Ga zuriyarka na ba da wannan ƙasa, daga kogin Masar zuwa babban kogi, Yuferites ke nan, ");
INSERT INTO hausa_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","ƙasar Keniyawa, Kenizziyawa, Kadmoniyawa, ");
INSERT INTO hausa_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Hittiyawa, Ferizziyawa, Refahiyawa, ");
INSERT INTO hausa_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amoriyawa, Kan’aniyawa, Girgashiyawa da kuma Yebusiyawa.” ");
INSERT INTO hausa_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","To, Saira, matar Abram, ba tă haifa masa ’ya’ya ba. Amma tana da wata baiwa mutuniyar Masar mai suna Hagar, ");
INSERT INTO hausa_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","saboda haka sai ta ce wa Abram, “Ubangiji ya hana mini haihuwar ’ya’ya. Tafi ka kwana da baiwata; wataƙila in sami iyali ta wurinta.” Abram kuwa ya yarda da abin da Saira ta faɗa. ");
INSERT INTO hausa_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Saboda haka bayan Abram ya yi zama a Kan’ana shekaru goma, Saira matarsa ta ɗauki Hagar baiwarta ta ba wa mijinta tă zama matarsa. ");
INSERT INTO hausa_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Abram kuwa ya kwana da Hagar, ta kuma yi ciki. Sa’ad da Hagar ta gane tana da ciki, sai ta fara rena uwargijiyarta. ");
INSERT INTO hausa_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Sai Saira ta ce wa Abram, “Kai ne da alhakin wahalan nan da nake sha. Na sa baiwata a hannunka, yanzu da ta sani tana da ciki, sai ta fara rena ni. Bari Ubangiji yă shari’anta tsakanina da kai.” ");
INSERT INTO hausa_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Abram ya ce, “Baiwarki tana a hannunki? Ki yi da ita yadda kika ga ya fi kyau.” Sai Saira ta wulaƙanta Hagar; saboda haka ta gudu daga gare ta. ");
INSERT INTO hausa_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Mala’ikan Ubangiji ya sami Hagar kusa da maɓulɓula a jeji, ita ce maɓulɓular da take gefen hanya zuwa Shur. ");
INSERT INTO hausa_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Ya kuma ce mata, “Hagar, baiwar Saira, daga ina kika fito, kuma ina za ki?” Ta amsa ta ce, “Ina gudu ne daga wurin uwargijiyata Saira.” ");
INSERT INTO hausa_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Sai mala’ikan Ubangiji ya ce mata, “Koma wurin uwargijiyarki Saira, ki yi mata biyayya.” ");
INSERT INTO hausa_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Mala’ikan ya ƙara da cewa, “Zan ƙara zuriyarki har su yi yawan da ba wanda zai iya lasafta su.” ");
INSERT INTO hausa_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Mala’ikan Ubangiji ya kuma ce mata, “Ga shi kina da ciki za ki kuwa haifi ɗa. Za ki ba shi suna Ishmayel, gama Ubangiji ya ga wahalarki. ");
INSERT INTO hausa_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Zai zama mutum mai halin jakin jeji. Hannunsa zai yi gāba da kowa, hannun kowa kuma zai yi gāba da shi. Zai yi zama gāba ga dukan ’yan’uwansa.” ");
INSERT INTO hausa_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Sai ta ba wa Ubangiji wanda ya yi magana da ita, wannan suna. “Kai Allah ne wanda yake ganina,” gama ta ce, “Yanzu na ga wanda yake ganina.” ");
INSERT INTO hausa_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Shi ya sa ake kira rijiyar Beyer-Lahai-Royi tana nan har yanzu, tsakanin Kadesh da Bered. ");
INSERT INTO hausa_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Haka fa Hagar ta haifa wa Abram ɗa, Abram kuwa ya ba da suna Ishmayel ga ɗan da ta haifa. ");
INSERT INTO hausa_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Abram yana da shekaru 86 sa’ad da Hagar ta haifa masa Ishmayel. ");
INSERT INTO hausa_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Sa’ad da Abram ya yi shekaru 99, sai Ubangiji ya bayyana a gare shi ya ce, ni “Ni ne Allah Maɗaukaki, ka yi tafiya a gabana ka kuma zama marar abin zargi. ");
INSERT INTO hausa_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Zan tabbatar da alkawarina tsakanina da kai, zan kuma ƙara zuriyarka ta yi yawa.” ");
INSERT INTO hausa_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Abram ya rusuna da fuskarsa har ƙasa, Allah kuma ya ce masa, ");
INSERT INTO hausa_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Gare ni kam, wannan shi ne alkawarina da kai, za ka zama mahaifin al’ummai masu yawa. ");
INSERT INTO hausa_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Ba za a ƙara kiranka Abram ba; sunanka zai zama Ibrahim, gama na mai da kai uban al’ummai masu yawa. ");
INSERT INTO hausa_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Zan sa ka azurta sosai, zan yi al’ummai daga cikinka, sarakuna kuma za su fito daga cikinka, ");
INSERT INTO hausa_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","zan kafa alkawarina kamar madawwamin alkawari tsakanina da kai da kuma zuriyarka bayanka har tsararraki masu zuwa, in zama Allahnka da kuma Allahn zuriyarka a bayanka. ");
INSERT INTO hausa_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Dukan ƙasar Kan’ana inda kake baƙo a yanzu, zan ba da ita a matsayin madawwamiyar mallaka gare ka da kuma zuriyarka a bayanka, zan kuma zama Allahnsu.” ");
INSERT INTO hausa_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Sa’an nan Allah ya ce wa Ibrahim. “Kai fa, sai ka kiyaye alkawarina, kai da zuriyarka bayanka, har tsararraki masu zuwa. ");
INSERT INTO hausa_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Wannan shi ne alkawarina da kai da kuma zuriyarka a bayanka, alkawarin da za ka kiyaye ke nan. Kowane namiji a cikinku kuwa za a yi masa kaciya. ");
INSERT INTO hausa_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Za ku yi kaciya, za tă kuma zama alamar alkawari tsakanina da kai. ");
INSERT INTO hausa_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Daga yanzu duk namijin da aka haifa a cikinku za a yi masa kaciya a rana ta takwas har dukan zamananku, ko haifaffen gida ne, ko sayayye da kuɗi daga kowane baƙo wanda ba na zuriyarku ba. ");
INSERT INTO hausa_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Ko haifaffe a gidanka ko an sayo da kuɗi, dole a yi musu kaciya. Alkawarina cikin jikinku zai kasance madawwamin alkawari. ");
INSERT INTO hausa_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Kowane namijin da ba a yi masa kaciya a jiki ba, za a fid da shi daga cikin mutanensa; domin ya karya alkawarina.” ");
INSERT INTO hausa_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Allah ya kuma ce wa Ibrahim, “Game da Saira matarka kuwa, ba za ka ƙara kiranta Saira ba, sunanta zai zama Saratu. ");
INSERT INTO hausa_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Zan sa mata albarka, ban da haka ma, zan ba ka ɗa ta wurinta, zan sa mata albarka, za tă kuwa zama mahaifiyar al’ummai; sarakunan mutane za su fito daga gare ta.” ");
INSERT INTO hausa_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Ibrahim ya rusuna da fuskarsa har ƙasa, ya yi dariya, ya ce wa kansa, “Za a haifi ɗa wa mutum mai shekaru ɗari? Saratu za tă haifi ɗa tana da shekaru tasa’in?” ");
INSERT INTO hausa_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Ibrahim ya kuma ce wa Allah, “Me zai hana a dai bar Ishmayel kawai yă gāji alkawarin nan da ka yi mini.” ");
INSERT INTO hausa_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Sai Allah ya ce, “Duk da haka dai, matarka Saratu za tă haifi maka ɗa; za ka kuma kira shi Ishaku. A kansa zan tabbatar da madawwamin alkawarina, da kuma ga zuriyarsa da za su zo bayansa. ");
INSERT INTO hausa_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Game da Ishmayel kuwa, na ji ka. Tabbatacce zan albarkace shi, zan sa yă azurta, zai kuma ƙaru ƙwarai. Zai zama mahaifin masu mulki goma sha biyu, zan kuma maishe shi babban al’umma! ");
INSERT INTO hausa_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Amma dai zan kafa alkawarina da Ishaku wanda Saratu za tă haifa maka war haka shekara mai zuwa.” ");
INSERT INTO hausa_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Da ya gama magana da Ibrahim, sai Allah ya tashi daga gare shi. ");
INSERT INTO hausa_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","A wannan rana, Ibrahim ya ɗauki ɗansa Ishmayel da dukan waɗanda aka haifa cikin gidansa, da waɗanda aka sayo da kuɗinsa, ya kuwa yi wa kowane namiji a cikin gidansa kaciya kamar yadda Allah ya faɗa masa. ");
INSERT INTO hausa_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Ibrahim yana da shekara tasa’in da tara sa’ad da aka yi masa kaciya, ");
INSERT INTO hausa_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Ishmayel ɗansa kuma yana da shekara goma sha uku. ");
INSERT INTO hausa_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Aka yi wa Ibrahim da ɗansa Ishmayel kaciya a rana ɗaya. ");
INSERT INTO hausa_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Aka yi wa kowane namiji a gidan Ibrahim kaciya, da waɗanda aka haifa a gidansa, da waɗanda aka sayo da kuɗi daga baƙo. ");
INSERT INTO hausa_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Ubangiji ya bayyana ga Ibrahim kusa da manyan itatuwan Mamre yayinda yake zaune a mashigin tentinsa da tsakar rana. ");
INSERT INTO hausa_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Da Ibrahim ya ɗaga ido, sai ya ga mutum uku suna tsaye kusa da shi. Sa’ad da ya gan su, sai ya tashi nan da nan daga mashigin tentinsa, ya tarye su, ya rusuna har ƙasa. ");
INSERT INTO hausa_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Ya ce, “Ranka yă daɗe, in na sami tagomashi daga gare ku kada ku wuce bawanku. ");
INSERT INTO hausa_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Bari a kawo ruwa ku wanke ƙafafunku, ku huta a ƙarƙashin wannan itace. ");
INSERT INTO hausa_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Bari in samo muku wani abu ku ci don ku wartsake, sa’an nan ku ci gaba da tafiyarku; da yake kun biyo wurin bawanku.” Suka ce, “To, sai ka yi abin da ka ce.” ");
INSERT INTO hausa_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Saboda haka Ibrahim ya ruga zuwa wurin Saratu a cikin tenti ya ce, “Yi sauri, ki shirya mudu uku na gari mai laushi, ki cuɗa shi, ki yi burodi.” ");
INSERT INTO hausa_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Sa’an nan Ibrahim ya yi gudu zuwa garkensa, ya zaɓi ɗan maraƙi ya ba wa bawansa, bawansa kuma ya yi sauri ya gyara shi. ");
INSERT INTO hausa_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Sa’an nan Ibrahim ya ɗauko dambu da madara da naman ɗan maraƙin da aka gyara, ya kawo a gabansu. Yayinda suke ci, ya tsaya a gindin itace kusa da su. ");
INSERT INTO hausa_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Sai suka ce masa, “Ina Saratu matarka?” Ibrahim ya ce, “Tana can cikin tenti.” ");
INSERT INTO hausa_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Sa’an nan ɗayansu ya ce, “Lalle zan komo wurinka war haka shekara mai zuwa. Saratu matarka kuwa za tă haifi ɗa.” Saratu kuwa tana a bayansu tana ji daga mashigin tenti. ");
INSERT INTO hausa_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Ibrahim da Saratu dai sun riga sun tsufa sosai. Saratu kuma ta wuce shekarun haihuwa. ");
INSERT INTO hausa_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Saboda haka Saratu ta yi dariya da ta yi tunani a zuci tana cewa, “Bayan ƙarfina ya ƙare, maigidana kuma ya tsufa, yanzu zan sami wannan jin daɗi?” ");
INSERT INTO hausa_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Sai Ubangiji ya ce wa Ibrahim, “Me ya ba Saratu dariya har da ta ce, ‘Har zan iya haifi ɗa duk ta tsufata yanzu?’ ");
INSERT INTO hausa_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Akwai abin zai gagari Ubangiji? Zan komo wurinka a ƙayyadadden lokacin nan shekara mai zuwa kuma Saratu za tă haifi ɗa.” ");
INSERT INTO hausa_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Saratu ta ji tsoro, don haka sai ta yi ƙarya ta ce, “Ban yi dariya ba.” Ya ce, “A’a, kin yi dariya.” ");
INSERT INTO hausa_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Sai mutanen suka tashi suka nufi Sodom, Ibrahim kuwa ya yi musu rakiya, ya yi bankwana da su. ");
INSERT INTO hausa_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Sai Ubangiji ya ce, “Zan ɓoye wa Ibrahim abin da nake shirin yi? ");
INSERT INTO hausa_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Lalle Ibrahim zai zama al’umma mai girma da kuma mai iko, kuma ta wurinsa dukan al’umman duniya za su sami albarka. ");
INSERT INTO hausa_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Saboda na zaɓe shi don yă umarci ’ya’yansa da iyalinsa a bayansa su kiyaye hanyoyin Ubangiji, ta wurin yin abin da yake daidai da kuma yin adalci, domin Ubangiji ya aikata abin da ya yi wa Ibrahim alkawari.” ");
INSERT INTO hausa_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Sa’an nan Ubangiji ya ce, “Kuka a kan Sodom da Gomorra ta yi yawa, zunubinsu kuma ya yi muni sosai, ");
INSERT INTO hausa_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","zan gangara in ga ko abin da suka yi ya yi muni kamar yadda kukan ya zo gare ni, zan bincike.” ");
INSERT INTO hausa_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Sai mutanen suka juya suka nufi wajen Sodom amma Ibrahim ya ci gaba da kasance a gaban Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Sai Ibrahim ya matso wurinsa ya ce, “Za ka hallaka masu adalci tare da masu mugunta? ");
INSERT INTO hausa_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Me zai faru in akwai mutum hamshin masu adalci a cikin birnin? Ashe, za ka hallaka shi, ba za ka cece wurin saboda mutane hamsin nan masu adalcin da suke a cikinsa ba? ");
INSERT INTO hausa_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Tabbatacce ba za ka taɓa aikata irin wannan abu ba, ka kashe masu adalci tare da masu mugunta, ka ɗauka masu adalci da masu mugunta daidai? Tabbatacce ba za ka taɓa aikata irin wannan abu ba! Mai hukuncin dukan duniya ba zai aikata gaskiya ba?” ");
INSERT INTO hausa_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Ubangiji ce, “In na sami mutum hamshin masu adalci a cikin birnin Sodom, zan bar dukan birnin saboda su.” ");
INSERT INTO hausa_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Sai Ibrahim ya ƙara cewa, “Yanzu da na yi karambani har na yi magana da Ubangiji, ko da yake ni ba kome ba ne illa turɓaya da toka, ");
INSERT INTO hausa_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","in yawan masu adalci sun kāsa hamshin da mutum biyar fa? Za ka hallaka dukan birnin saboda rashin mutum biyar ɗin?” Ya ce, “In na sami mutum arba’in da biyar a wurin, ba zan hallaka shi ba.” ");
INSERT INTO hausa_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Ya sāke cewa, “In mutum arba’in kaɗai aka samu a can fa?” Ya ce, “Saboda mutum arba’in ɗin, ba zan aikata ba.” ");
INSERT INTO hausa_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Sai ya ce, “Kada Ubangiji ya yi fushi, amma bari in ƙara magana. A ce mutum talatin kaɗai aka samu a can fa?” Ya ce, “Ba zan aikata ba, in na sami mutum talatin a can.” ");
INSERT INTO hausa_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Ibrahim ya ce, “Yanzu fa da na yi karambani har na yi magana da Ubangiji, in ashirin kaɗai aka samu a can fa?” Ya ce, “Saboda ashirin ɗin, ba zan hallaka shi ba.” ");
INSERT INTO hausa_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Sa’an nan Ibrahim ya ce, “Kada Ubangiji yă yi fushi, amma bari in ƙara magana sau ɗaya tak. In aka sami mutum goma kaɗai a can fa?” Ubangiji ya ce, “Saboda goma nan, ba zan hallaka shi ba.” ");
INSERT INTO hausa_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Sa’ad da Ubangiji ya gama magana da Ibrahim, ya tafi, Ibrahim kuma ya koma gida. ");
INSERT INTO hausa_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Mala’ikun nan biyu suka iso Sodom da yamma. Lot kuwa yana zama a hanyar shiga birnin. Da ya gan su, sai ya tashi don yă tarye su, ya kuma rusuna da fuskarsa har ƙasa. ");
INSERT INTO hausa_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Ya ce, “Ranku yă daɗe, ina roƙonku ku ratsa zuwa gidan bawanku. Ku wanke ƙafafunku, ku kwana, sa’an nan ku kama hanyarku da sassafe.” Suka ce, “A’a, za mu kwana a dandali.” ");
INSERT INTO hausa_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Amma ya nace musu ƙwarai, sai suka tafi tare da shi, suka kuma shiga gidansa. Ya shirya musu abinci, ya gasa burodi marasa yisti, suka ci. ");
INSERT INTO hausa_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Kafin suka shiga barci, sai ga dukan mutane, ƙanana da manya daga kowane ɓangare na birnin Sodom, suka kewaye gidan. ");
INSERT INTO hausa_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Suka kira Lot, suka ce, “Ina mutanen da suka zo wurinka a daren nan? Fito mana da su waje domin mu kwana da su.” ");
INSERT INTO hausa_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lot ya fita daga cikin gida, ya rufe ƙofar a bayansa. Ya je wurin mutanen ");
INSERT INTO hausa_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","ya ce musu, “A’a, abokaina kada ku yi wannan mummunan abu. ");
INSERT INTO hausa_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Duba, ina da ’ya’ya mata biyu waɗanda ba su taɓa sanin namiji ba, bari in kawo muku su ku yi kome da kuke so da su. Amma kada ku taɓa waɗannan mutane, gama su baƙina ne kuma dole in tsare su.” ");
INSERT INTO hausa_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Sai mutanen birnin suka amsa, “Ba mu wuri! Wannan mutum ya zo nan kamar baƙo, ga shi yanzu yana so yă zama alƙali! Za mu wulaƙanta ka fiye da su.” Suka ci gaba da matsa wa Lot lamba, suka matsa kusa domin su fasa ƙofar. ");
INSERT INTO hausa_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Amma mutanen da suke ciki suka miƙa hannunsu, suka ja Lot zuwa cikin gida, suka rufe ƙofar. ");
INSERT INTO hausa_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Sai suka bugi mutanen da suke a bakin ƙofar gidan da makanta, ƙanana da manya duka, har suka gajiyar da kansu, suna lalluba inda ƙofar take. ");
INSERT INTO hausa_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Mutanen nan biyun suka ce wa Lot, “Kana da wani a nan, ko surukai, ko ’ya’ya maza ko mata, ko kuwa wani dai a cikin birni wanda yake naka? Ka fitar da su daga nan, ");
INSERT INTO hausa_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","gama za mu hallaka wannan wuri. Kukan da aka yi ga Ubangiji game da mutanen birnin nan ya yi yawa sosai, ya sa har ya aiko mu domin mu hallaka birnin.” ");
INSERT INTO hausa_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Saboda haka Lot ya tafi ya yi magana da surukansa waɗanda suka yi alkawari za su aure ’ya’yansa mata. Ya ce, “Ku yi sauri ku fita daga wannan wuri, gama Ubangiji yana gab da hallaka birnin.” Amma surukansa suka ɗauka wasa yake yi. ");
INSERT INTO hausa_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Gari na wayewa, sai mala’ikun nan suka ƙarfafa Lot suna cewa, “Yi sauri! Ka ɗauki matarka da ’ya’yanka biyu mata waɗanda suke a nan, don kada a shafe ku sa’ad da ake hukunta birnin.” ");
INSERT INTO hausa_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Da yana jan jiki, sai mutanen suka kama hannunsa da hannuwan matarsa da na ’ya’yansa biyu mata, suka kai su bayan birni, gama Ubangiji ya nuna musu jinƙai. ");
INSERT INTO hausa_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Da suka fitar da su, sai ɗaya daga cikin mala’ikun ya ce, “Ku gudu domin ranku; kada ku duba baya, kada kuma ku tsaya ko’ina cikin kwarin! Ku gudu zuwa cikin duwatsu, don kada a hallaka ku!” ");
INSERT INTO hausa_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Amma Lot ya ce musu, “A’a, ranka yă daɗe, ka yi haƙuri! ");
INSERT INTO hausa_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Bawanku ya riga ya sami tagomashi daga gare ku, kun kuma nuna mini alheri mai yawa. Ba zan iya in gudu zuwa duwatsu ba, wannan masifa za tă same ni, zan kuma mutu. ");
INSERT INTO hausa_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Ga ɗan gari can ya fi kusa inda zan gudu in fake. Bari in gudu zuwa can, in tsirar da raina.” ");
INSERT INTO hausa_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Sai ya ce masa, “Na yarda da abin da ka ce, ba zan hallakar da garin da ka ambata ba. ");
INSERT INTO hausa_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Gaggauta, ka gudu zuwa can, ba zan yi kome ba sai ka isa can.” (Domin haka ne ake kira garin Zowar.) ");
INSERT INTO hausa_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","A lokacin da Lot ya isa Zowar, rana ta hau. ");
INSERT INTO hausa_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Sai Ubangiji ya yi ta zuba kibiritu a bisa Sodom da Gomorra daga sama. ");
INSERT INTO hausa_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Haka ya hallakar da waɗannan birane da kuma kwarinsu gaba ɗaya, haɗe da dukan waɗanda suke zama a biranen, da kuma dukan shuke-shuke da suke cikin ƙasar. ");
INSERT INTO hausa_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Amma matar Lot ta waiwaya baya, ta kuma zama ginshiƙin gishiri. ");
INSERT INTO hausa_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Da sassafe kashegari, Ibrahim ya tashi ya koma wurin da dā ya tsaya a gaban Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Ya duba ta wajen Sodom da Gomorra, da wajen dukan filayen ƙasar, sai ya ga hayaƙi baƙin ƙirin yana tashi daga ƙasar kamar hayaƙi daga matoya. ");
INSERT INTO hausa_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Saboda haka sa’ad da Allah ya hallaka waɗannan biranen kwarin, ya tuna da Ibrahim, ya kuma fitar da Lot daga masifar da ta hallaka biranen da Lot ya zauna. ");
INSERT INTO hausa_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lot da ’ya’yansa biyu mata suka bar Zowar suka kuma zauna a cikin duwatsu, gama ya ji tsoro yă zauna a Zowar. Shi da ’ya’yansa biyu mata suka zauna a ciki wani kogo. ");
INSERT INTO hausa_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Wata rana ’yarsa babba ta ce wa ƙanuwarta, “Mahaifinmu ya tsufa, kuma babu wani mutum kusa a nan da zai yi mana ciki mu haifi ’ya’ya; yadda al’ada take a ko’ina a duniya. ");
INSERT INTO hausa_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Bari mu sa mahaifinmu yă sha ruwan inabi, sa’an nan sai mu kwana da shi, don kada zuriyar mahaifinmu ta ƙare.” ");
INSERT INTO hausa_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","A wannan dare, suka sa mahaifinsu ya sha ruwan inabi, ’yar farin ta shiga ta kwana da shi. Shi kuwa bai san sa’ad da ta kwanta ko sa’ad da ta tashi ba. ");
INSERT INTO hausa_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Kashegari, ’yar farin ta ce wa ƙanuwar, “Jiya da dare na kwana da mahaifina. Bari mu sa yă sha ruwan inabi kuma yau da dare, ke ma ki shiga ki kwana da shi, domin kada zuriyar mahaifinmu ta ƙare.” ");
INSERT INTO hausa_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Sai suka sa mahaifinsu ya sha ruwan inabi, a wannan dare ma, ƙanuwar ta shiga ta kwana da shi. Bai kuwa san sa’ad da ta kwanta ko sa’ad da ta tashi ba. ");
INSERT INTO hausa_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Ta haka ’ya’yan Lot biyu mata duk suka yi ciki daga mahaifinsu. ");
INSERT INTO hausa_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","’Yar farin ta haifi ɗa, ta kuma ba shi suna Mowab, shi ne mahaifin Mowabawa a yau. ");
INSERT INTO hausa_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","’Yar ƙaramar ma ta haifi ɗa, ta kuwa ba shi suna Ben-Ammi, shi ne mahaifin Ammonawa a yau. ");
INSERT INTO hausa_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Daga Mamre, Ibrahim ya kama hanya ya nufi wajajen Negeb, ya zauna a tsakanin Kadesh da Shur. Ya zauna a Gerar na ɗan lokaci, ");
INSERT INTO hausa_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","a can ne Ibrahim ya ce game da matarsa Saratu, “Ita ’yar’uwata ce.” Sai Abimelek sarkin Gerar ya aiko a kawo masa Saratu. ");
INSERT INTO hausa_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Amma wata rana da dad dare Allah ya zo wa Abimelek a cikin mafarki ya ce masa, “Kai da matacce ɗaya kuke, saboda matar da ka ɗauka. Ita matar aure ce.” ");
INSERT INTO hausa_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Abimelek dai bai riga ya kusace ta ba tukuna, saboda haka ya ce, “Ya Ubangiji za ka hallaka al’umma marar laifi? ");
INSERT INTO hausa_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Ba shi ne ya ce mini, ‘Ita ’yar’uwata ba ce,’ ita ma ba tă ce, ‘Shi ɗan’uwana ba ne’? Na yi haka da kyakkyawan nufi da hannuwa masu tsabta.” ");
INSERT INTO hausa_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Sai Allah ya ce masa a cikin mafarki “I, na san ka yi wannan da kyakkyawan nufi, saboda haka ne na kiyaye ka daga yin mini zunubi. Shi ya sa ban bar ka ka taɓa ta ba. ");
INSERT INTO hausa_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Yanzu ka komar da matar mutumin, gama shi annabi ne, zai kuma yi maka addu’a, za ka kuwa rayu. In ba ka komar da ita ba fa, ka sani tabbatacce kai da dukan abin da yake naka za ku mutu.” ");
INSERT INTO hausa_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Kashegari da sassafe, sai Abimelek ya tara dukan fadawansa, ya faɗa musu duk abin da ya faru, suka ji tsoro ƙwarai da gaske. ");
INSERT INTO hausa_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Sa’an nan Abimelek ya kira Ibrahim ciki ya ce, “Me ke nan ka yi mana? Ta wace hanya ce na yi maka laifi har da ka kawo irin wannan babban laifi a kaina da kuma masarautata? Ka yi mini abubuwan da bai kamata a yi ba.” ");
INSERT INTO hausa_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Abimelek ya kuma ce wa Ibrahim, “Me ya sa ka yi wannan?” ");
INSERT INTO hausa_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Ibrahim ya ce, “Na ce a raina, ‘Tabbatacce babu tsoron Allah a wannan wuri, za su kuwa kashe ni saboda matata.’ ");
INSERT INTO hausa_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Ban da haka, tabbatacce ita ’yar’uwata ce, ’yar mahaifina, ko da yake ba daga uwata ba, ta kuma zama matata. ");
INSERT INTO hausa_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Sa’ad da Allah ya sa na tashi daga gidan mahaifina na ce mata, ‘Wannan shi ne yadda za ki nuna mini ƙaunarki. Duk inda muka tafi, ki ce game da ni, “Shi ɗan’uwana ne.” ’ ” ");
INSERT INTO hausa_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Sai Abimelek ya kawo awaki da shanu da bayi maza da mata, ya ba wa Ibrahim, ya kuma komar da Saratu matarsa gare shi. ");
INSERT INTO hausa_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Abimelek ya kuma ce, “Ƙasata tana gabanka, ka zauna a duk inda kake so.” ");
INSERT INTO hausa_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Ga Saratu kuwa ya ce, “Ina ba wa ɗan’uwanki shekel dubu na azurfa, shaida ce ta tabbatarwa a idanun dukan waɗanda suke tare da ke, da kuma a gaban kowa cewa ba ki da laifi.” ");
INSERT INTO hausa_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Sai Ibrahim ya yi addu’a ga Allah, Allah kuma ya warkar da Abimelek, da matarsa da bayinsa mata domin su haihu, ");
INSERT INTO hausa_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","gama Ubangiji ya rufe kowace mahaifa a gidan Abimelek saboda Saratu, matar Ibrahim. ");
INSERT INTO hausa_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Ana nan sai Ubangiji ya nuna wa Saratu alheri kamar yadda ya ce, Ubangiji kuma ya yi wa Saratu abin da ya yi alkawari. ");
INSERT INTO hausa_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Saratu ta yi ciki, ta kuma haifa wa Ibrahim ɗa a tsufansa; a daidai lokacin da Allah ya yi masa alkawari. ");
INSERT INTO hausa_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Ibrahim ya sa wa ɗan da Saratu ta haifa masa suna Ishaku. ");
INSERT INTO hausa_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Sa’ad da ɗansa Ishaku ya kai kwana takwas da haihuwa, sai Ibrahim ya yi masa kaciya, kamar yadda Allah ya umarce shi. ");
INSERT INTO hausa_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Ibrahim yana da shekara ɗari, sa’ad da aka haifa masa ɗansa Ishaku. ");
INSERT INTO hausa_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Saratu ta ce, “Allah ya sa na yi dariya, kuma duk wanda ya ji game da wannan, zai yi dariya tare da ni.” ");
INSERT INTO hausa_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Ta kuma ƙara da cewa, “Dā, wa zai iya ce wa Ibrahim, Saratu za tă yi renon yara? Duk da haka na haifar masa ɗa cikin tsufansa.” ");
INSERT INTO hausa_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Yaron ya yi girma, aka kuma yaye shi, a ranar da aka yaye shi kuwa, Ibrahim ya yi babban biki. ");
INSERT INTO hausa_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Amma Saratu ta ga cewa yaron da Hagar, mutuniyar Masar ta haifa wa Ibrahim yana wa ɗanta Ishaku gori, ");
INSERT INTO hausa_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","sai ta ce wa Ibrahim, “Ka kori baiwan nan tare da ɗanta, saboda ɗan baiwan nan ba zai taɓa raba gādo da ɗana Ishaku ba.” ");
INSERT INTO hausa_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Al’amarin ya ɓata wa Ibrahim rai sosai domin zancen ya shafi ɗansa. ");
INSERT INTO hausa_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Amma Allah ya ce wa Ibrahim, “Kada hankalinka yă tashi game da yaron nan da kuma baiwarka. Ka saurari duk abin da Saratu ta faɗa maka, saboda ta wurin Ishaku ne za a lissafta zuriyarka. ");
INSERT INTO hausa_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Zan ba ɗan baiwan nan al’umma shi ma, domin shi zuriyarka ne.” ");
INSERT INTO hausa_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Kashegari da sassafe sai Ibrahim ya ɗauki abinci da salkar ruwa, ya ba wa Hagar. Ya ɗora su a kafaɗunta, sa’an nan ya sallame ta da yaron. Ta kama hanyarta ta kuma yi ta yawo a cikin jejin Beyersheba. ");
INSERT INTO hausa_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Sa’ad da ruwan da yake cikin salkan ya ƙare, sai ta ajiye yaron a ƙarƙashin wani ƙaramin itace. ");
INSERT INTO hausa_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Sai ta tafi, ta zauna ɗan nesa da yaron, misalin nisan harbin baka, gama ta yi tunani ta ce, “Ba zan iya kallon yaron yana mutuwa ba.” Da ta zauna nesa da yaron, sai ta fara kuka. ");
INSERT INTO hausa_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Allah kuwa ya ji yaron yana kuka, sai mala’ikan Allah ya kira Hagar daga sama ya ce mata, “Mene ne damuwarki, Hagar? Kada ki ji tsoro, Allah ya ji yaron yana kuka yayinda yake kwance a can. ");
INSERT INTO hausa_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Ki ɗaga yaron ki riƙe shi a hannu, gama zan mai da shi al’umma mai girma.” ");
INSERT INTO hausa_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Sa’an nan Allah ya buɗe idanunta ta ga wata rijiyar ruwa. Don haka sai ta tafi ta cika salkan da ruwa, ta kuma ba wa yaron ruwa ya sha. ");
INSERT INTO hausa_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Allah ya kasance da yaron, yayinda yake girma. Ya yi zama a jeji, ya kuma zama maharbi. ");
INSERT INTO hausa_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Yayinda yake zama a Jejin Faran, sai mahaifiyarsa ta samo masa mata daga Masar. ");
INSERT INTO hausa_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","A lokacin nan Abimelek da Fikol, komandan rundunoninsa suka zo suka ce wa Ibrahim, “Allah yana tare da kai a ko mene ne kake yi. ");
INSERT INTO hausa_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Yanzu ka rantse mini a nan a gaban Allah cewa, ba za ka yaudare ni ko ’ya’yana ko kuma zuriyata ba. Ka nuna mini alheri, kai da ƙasar da kake zama baƙunci kamar yadda na nuna maka.” ");
INSERT INTO hausa_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Ibrahim ya ce, “Na rantse.” ");
INSERT INTO hausa_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Sa’an nan Ibrahim ya kawo kuka ga Abimelek game da rijiyar ruwan da bayin Abimelek suka ƙwace. ");
INSERT INTO hausa_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Sai Abimelek ya ce, “Ban san wanda ya yi wannan ba. Ba ka faɗa mini ba, ban kuwa taɓa ji ba, sai yau.” ");
INSERT INTO hausa_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Sai Ibrahim ya kawo tumaki da shanu ya ba wa Abimelek, sai su biyun suka yi yarjejjeniya. ");
INSERT INTO hausa_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Ibrahim ya ware ’yan raguna bakwai daga cikin garke, ");
INSERT INTO hausa_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","sai Abimelek ya ce wa Ibrahim, “Mene ne ma’anar ’yan raguna bakwai da ka keɓe?” ");
INSERT INTO hausa_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Ibrahim ya amsa ya ce, “Ka karɓi waɗannan ’yan tumaki bakwai daga hannuna a matsayin shaida cewa ni ne na haƙa wannan rijiya.” ");
INSERT INTO hausa_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Saboda haka aka kira wurin Beyersheba, domin a nan ne su biyun suka yi rantsuwa. ");
INSERT INTO hausa_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Bayan da aka yi yarjejjeniya a Beyersheba, sai Abimelek da Fikol, komandan rundunoninsa suka koma ƙasar Filistiyawa. ");
INSERT INTO hausa_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Sai Ibrahim ya shuka itacen tsamiya a Beyersheba, a can kuma ya kira bisa sunan Ubangiji, Allah Madawwami. ");
INSERT INTO hausa_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Ibrahim kuwa ya zauna a ƙasar Filistiyawa na dogon lokaci. ");
INSERT INTO hausa_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Bayan abubuwan nan suka faru, sai Allah ya gwada Ibrahim. Ya ce masa, “Ibrahim!” Ibrahim ya amsa ya ce, “Ga ni.” ");
INSERT INTO hausa_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Sai Allah ya ce, “Ka ɗauki ɗanka, makaɗaicin ɗanka Ishaku, wanda kake ƙauna, ka tafi yankin Moriya, ka miƙa shi hadaya ta ƙonawa a can a kan ɗaya daga cikin duwatsun da zan nuna maka.” ");
INSERT INTO hausa_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Kashegari da sassafe, Ibrahim ya tashi ya ɗaura wa jakinsa sirdi. Ya ɗauki bayinsa biyu, da ɗansa Ishaku. Bayan ya faskare isashen itace saboda hadaya ta ƙonawa sai ya kama hanya zuwa wurin da Allah ya faɗa masa. ");
INSERT INTO hausa_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","A rana ta uku Ibrahim ya ɗaga ido sai ya ga wurin daga nesa. ");
INSERT INTO hausa_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Ibrahim ya ce wa bayinsa, “Ku tsaya a nan da jakin, ni da yaron kuwa mu haura can. Za mu yi sujada sa’an nan mu komo wurinku.” ");
INSERT INTO hausa_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Ibrahim ya ɗauki itace saboda hadaya ta ƙonawa ya ɗora wa ɗansa Ishaku, shi kuwa ya riƙe wuƙa da wutar. Yayinda su biyun suke tafiya, ");
INSERT INTO hausa_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","sai Ishaku ya yi tambaya, ya ce wa mahaifinsa Ibrahim, “Baba?” Ibrahim ya ce masa, “Na’am ɗana!” Ishaku ya ce, “Ga dai wuta, ga kuma itace, amma ina ɗan ragon hadaya ta ƙonawa?” ");
INSERT INTO hausa_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Ibrahim ya amsa ya ce, “Ɗana, Allah kansa zai tanada ɗan ragon hadayar ƙonawa.” Sai su biyu suka ci gaba da tafiya. ");
INSERT INTO hausa_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Sa’ad da suka isa wurin da Allah ya faɗa masa, sai Ibrahim ya gina bagade a can, ya kuma shisshirya itacen a kai. Ya ɗaura ɗansa Ishaku, ya kwantar da shi a kan itacen, a bisa bagaden. ");
INSERT INTO hausa_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Sa’an nan Ibrahim ya miƙa hannunsa ya ɗauki wuƙar don yă yanka ɗansa. ");
INSERT INTO hausa_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Amma mala’ikan Ubangiji ya kira shi daga sama ya ce, “Ibrahim, Ibrahim!” Sai Ibrahim ya amsa ya ce, “Ga ni.” ");
INSERT INTO hausa_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Mala’ikan ya ce, “Kada ka yi wa yaron nan rauni. Kada kuma ka ji masa ciwo. Yanzu na san cewa kana tsoron Allah, gama ba ka hana ni ɗanka, makaɗaicin ɗanka ba.” ");
INSERT INTO hausa_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Ibrahim ya ɗaga ido, ya duba, sai ya ga rago da ƙahoninsa a kafe a wani ɗan kurmi. Sai Ibrahim ya tafi ya kamo ragon ya miƙa shi hadaya ta ƙonawa a maimakon ɗansa. ");
INSERT INTO hausa_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Ibrahim kuwa ya ba wa wurin suna, Ubangiji Zai Tanada. Gama kamar yadda ake ce har yă zuwa yau, “A bisan dutsen Ubangiji, za a tanada.” ");
INSERT INTO hausa_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Mala’ikan Ubangiji ya kira Ibrahim daga sama sau na biyu ");
INSERT INTO hausa_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","ya ce, “Na rantse da kaina, in ji Ubangiji, domin ka yi wannan, ba ka kuwa hana ni ɗanka, makaɗaicin ɗanka ba, ");
INSERT INTO hausa_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","tabbatacce zan albarkace ka, zan kuma sa zuriyarka su yi yawa kamar taurari a sararin sama, kamar kuma yashi a bakin teku. Zuriyarka za su mallaki biranen abokan gābansu, ");
INSERT INTO hausa_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","ta wurin zuriyarka kuma dukan al’umman duniya za su sami albarka, domin ka yi mini biyayya.” ");
INSERT INTO hausa_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Sa’an nan Ibrahim ya koma wurin bayinsa, suka kuma kama hanya tare zuwa Beyersheba. Ibrahim kuwa ya yi zamansa a Beyersheba. ");
INSERT INTO hausa_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Bayan wani ɗan lokaci, sai aka faɗa wa Ibrahim cewa, “Ga shi, Milka ita ma ta haifa wa Nahor ɗan’uwanka, ’ya’ya maza; ");
INSERT INTO hausa_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","ɗan fari shi ne Uz, ɗan’uwansa kuma Buz, Kemuwel (shi ne mahaifin Aram), ");
INSERT INTO hausa_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Kesed, Hazo, Fildash; Yidlaf, da kuma Betuwel.” ");
INSERT INTO hausa_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betuwel ya haifi Rebeka. Milka ta haifa wa Nahor ɗan’uwan Ibrahim waɗannan ’ya’ya maza takwas. ");
INSERT INTO hausa_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Ban da haka ma, ƙwarƙwararsa, mai suna Reyuma, ta haifa masa ’ya’ya maza, Teba, Gaham, Tahash da kuma Ma’aka. ");
INSERT INTO hausa_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Saratu ta yi shekara ɗari da ashirin da bakwai a duniya. ");
INSERT INTO hausa_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Ta rasu a Kiriyat Arba (wato, Hebron) a ƙasar Kan’ana, Ibrahim kuwa ya tafi ya yi makokin Saratu, yana kuka saboda ita. ");
INSERT INTO hausa_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Sai Ibrahim ya tashi daga gefen matarsa da ta mutu, ya yi magana da Hittiyawa. Ya ce, ");
INSERT INTO hausa_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Ni baƙo ne, kuma baƙo a cikinku. Ku sayar mini da wani wuri yă zama wurin binnewa a nan, domin in binne mataccena.” ");
INSERT INTO hausa_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Hittiyawa suka ce wa Ibrahim, ");
INSERT INTO hausa_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Ranka yă daɗe, ka saurare mu. Kai babban yerima ne a cikinmu. Ka binne mataccenka a kabari mafi kyau na kaburburanmu. Babu waninmu da zai hana ka kabarinsa don binne mataccenka.” ");
INSERT INTO hausa_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Sai Ibrahim ya tashi ya rusuna a gaban mutanen ƙasar, wato, Hittiyawan. ");
INSERT INTO hausa_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Ya ce musu, “In kuna so in binne mataccena, sai ku ji ni, ku roƙi Efron ɗan Zohar a madadina ");
INSERT INTO hausa_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","domin yă sayar mini da kogon Makfela, wanda yake nasa, wannan da yake a ƙarshen filinsa. Ku ce masa yă sayar mini a cikakken farashi, yă zama mallakata domin makabarta tsakaninku.” ");
INSERT INTO hausa_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Efron mutumin Hitti yana zaune a cikin mutanensa, sai ya amsa wa Ibrahim a kunnuwan dukan Hittiyawa waɗanda suka zo ƙofar birni. ");
INSERT INTO hausa_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Ya ce, “A’a, ranka yă daɗe, ka ji ni, na ba ka filin, na kuma ba ka kogon da yake cikinsa. Na ba ka shi a gaban mutanena. Ka binne mataccenka.” ");
INSERT INTO hausa_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Ibrahim ya sāke rusuna a gaban mutanen ƙasar ");
INSERT INTO hausa_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","ya ce wa Efron a kunnuwansu, “Ka ji, in ka yarda. Zan biya farashin filin. Ka karɓa daga gare ni don in iya binne mataccena a can.” ");
INSERT INTO hausa_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Efron ya ce wa Ibrahim, ");
INSERT INTO hausa_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Ka saurare ni, ranka yă daɗe; darajan filin ya kai shekel ɗari huɗu na azurfa, amma mene ne wannan a tsakanina da kai? Ka binne mataccenka.” ");
INSERT INTO hausa_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Ibrahim ya yarda da sharuɗan Efron, sai ya auna masa farashin da ya faɗa a kunnuwan Hittiyawa, shekel ɗari huɗu na azurfa, bisa ga ma’aunin da ’yan kasuwa suke amfani da shi a lokacin. ");
INSERT INTO hausa_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Ta haka filin Efron a Makfela kusa da Mamre, wato, filin da kogon a cikinsa, da kuma dukan itatuwan da suke cikin iyakoki filin, aka ");
INSERT INTO hausa_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","ba wa Ibrahim a matsayin mallakarsa a gaban dukan Hittiyawa waɗanda suka zo ƙofar birnin. ");
INSERT INTO hausa_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Bayan wannan Ibrahim ya binne matarsa Saratu a kogon a filin Makfela kusa da Mamre (wanda yake a Hebron) a ƙasar Kan’ana. ");
INSERT INTO hausa_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Da filin da kuma kogon da yake cikinsa, Hittiyawa suka tabbatar wa Ibrahim a matsayin makabarta. ");
INSERT INTO hausa_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Yanzu fa Ibrahim ya tsufa, yana da shekaru masu yawa, Ubangiji kuma ya albarkace shi a kowace hanya. ");
INSERT INTO hausa_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Sai Ibrahim ya ce wa babban bawan gidansa, wanda yake lura da duk abin da yake da shi, “Sa hannunka a ƙarƙashin cinyata. ");
INSERT INTO hausa_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Ina so ka rantse da sunan Ubangiji Allah na sama da ƙasa, cewa ba za ka samo wa ɗana mata daga ’yan matan Kan’aniyawa, waɗanda nake zama cikinsu ba. ");
INSERT INTO hausa_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Amma za ka tafi ƙasata da kuma cikin ’yan’uwana, ka samo mata saboda ɗana Ishaku.” ");
INSERT INTO hausa_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Bawan ya ce masa, “Me zai faru in matar ba tă yarda tă zo tare da ni zuwa wannan ƙasa ba? In komar da ɗanka a ƙasar da ka fito ne ke nan?” ");
INSERT INTO hausa_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Ibrahim ya ce, “Ka tabbata ba ka komar da ɗana can ba.” ");
INSERT INTO hausa_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Ubangiji Allah na sama, wanda ya fitar da ni daga gidan mahaifina, da kuma ƙasar asalina wanda kuma ya yi magana da ni, ya yi mini alkawari da rantsuwa cewa, “Ga zuriyarka zan ba da wannan ƙasa, zai aika mala’ikansa yă sha gabanka domin ka samo wa ɗana mata daga can. ");
INSERT INTO hausa_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","In matar ba tă yarda tă zo tare da kai ba, za a kuɓutar da kai daga wannan rantsuwa. Sai dai kada ka kai ɗana a can.” ");
INSERT INTO hausa_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Saboda haka bawan ya sa hannunsa a ƙarƙashin cinyar maigidansa Ibrahim, ya kuma rantse masa game da wannan al’amari. ");
INSERT INTO hausa_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Sai bawan ya ɗibi raƙuma goma na maigidansa ya tafi, ɗauke da kowane irin abubuwa masu kyau daga wurin maigidansa. Ya fita don yă tafi Aram-Naharayim, ya kama hanyarsa zuwa garin Nahor. ");
INSERT INTO hausa_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Ya sa raƙuman suka durƙusa kusa da rijiya a bayan gari; wajen yamma ne, lokacin da mata sukan fita ɗiban ruwa. ");
INSERT INTO hausa_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Sai ya yi addu’a ya ce, “Ya Ubangiji Allah na maigidana Ibrahim, ka ba ni nasara yau, ka kuma nuna alheri ga maigidana Ibrahim. ");
INSERT INTO hausa_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Duba, ina tsaye a bakin rijiyar ruwa, ’ya’ya matan mutanen gari kuma suna fitowa domin ɗiban ruwa. ");
INSERT INTO hausa_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Bari yă zama sa’ad da na ce wa wata yarinya, ‘Ina roƙonki ki saukar da tulunki domin in sha,’ in ta ce, ‘Ka sha, zan kuma ba wa raƙumanka ma’; bari tă zama ita ce ka zaɓa wa bawanka Ishaku. Ta haka zan san cewa ka nuna wa maigidana alheri.” ");
INSERT INTO hausa_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Kafin ya gama addu’a, sai Rebeka ta fito da tulu a kafaɗarta. Ita ’yar Betuwel ɗan Milka, matar Nahor, ɗan’uwan Ibrahim. ");
INSERT INTO hausa_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Yarinyar kuwa kyakkyawa ce, budurwa, ba namijin da ya taɓa kwana da ita. Ta gangara zuwa rijiyar, ta cika tulunta ta kuma hauro. ");
INSERT INTO hausa_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Bawan ya yi sauri ya same ta ya ce, “Ina roƙonki ki ba ni ɗan ruwa daga tulunki.” ");
INSERT INTO hausa_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Ta ce, “Ka sha, ranka yă daɗe,” ta yi sauri ta saukar da tulun a hannuwanta, ta kuma ba shi, ya sha. ");
INSERT INTO hausa_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Bayan ta ba shi ya sha, sai ta ce, “Zan ɗebo wa raƙumanka ruwa su ma, har sai sun gama sha.” ");
INSERT INTO hausa_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Sai ta yi sauri ta juye ruwan da yake tulunta cikin kwami, ta koma zuwa rijiyar da gudu don ta ƙara ɗebo ruwa, ta kuma ɗebo isashe saboda dukan raƙumansa. ");
INSERT INTO hausa_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Mutumin bai ce uffam ba, ya dai kalle ta sosai don yă san ko Ubangiji ya ba shi nasara a tafiyarsa ko babu. ");
INSERT INTO hausa_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Sa’ad da raƙuman suka gama shan ruwa, mutumin ya fitar da zoben hanci na zinariya mai nauyin giram biyar da woroworo biyu na zinariya masu nauyin shekel goma, ya ba ta. ");
INSERT INTO hausa_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Sa’an nan ya tambaye ta ya ce, “Ke ’yar wace ce? Ina roƙonki ki faɗa mini, akwai wuri a gidan mahaifinki da za mu kwana?” ");
INSERT INTO hausa_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Sai ta ce masa, “Ni ’yar Betuwel ce ɗan da Milka ta haifa wa Nahor.” ");
INSERT INTO hausa_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Ta ƙara da cewa, “Muna da isashen ciyawa da abincin dabbobi, da kuma wuri domin ku kwana.” ");
INSERT INTO hausa_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Sa’an nan mutumin ya rusuna ya yi wa Ubangiji sujada, ");
INSERT INTO hausa_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","yana cewa, “Yabo ya tabbata ga Ubangiji Allah na maigidana Ibrahim, wanda bai daina nuna alheri da amincinsa ga maigidana ba. Ni kam, Ubangiji ya bishe ni a tafiyata zuwa gidan ’yan’uwan maigidana.” ");
INSERT INTO hausa_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Yariyan ta gudu ta faɗa wa mutanen gidan mahaifiyarta game da abubuwan nan. ");
INSERT INTO hausa_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Rebeka fa tana da wani ɗan’uwa mai suna Laban, sai ya yi hanzari ya fita zuwa wurin mutumin a rijiyar. ");
INSERT INTO hausa_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Nan da nan da ya ga zoben hancin da woroworo a hannuwan ’yar’uwansa, ya kuma ji Rebeka ta faɗa abin da mutumin ya ce mata, sai ya fita zuwa wurin mutumin, ya same shi yana tsaye wajen raƙuma kusa da rijiyar. ");
INSERT INTO hausa_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Sai ya ce, “Zo, ya kai mai albarka na Ubangiji, don me kake tsaye a waje? Gama na shirya gida da wuri domin raƙuma.” ");
INSERT INTO hausa_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Don haka mutumin ya tafi gidan, aka kuma saukar da kaya kan raƙuman. Aka kawo wa raƙuman ciyawa da abincin dabbobi, aka kuma kawo ruwa dominsa da mutanensa su wanke ƙafafunsu. ");
INSERT INTO hausa_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Sa’an nan aka ajiye abinci a gabansa, amma ya ce, “Ba zan ci ba, sai na faɗi abin da yake tafe da ni.” Sai Laban ya ce, “Faɗa mana.” ");
INSERT INTO hausa_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Saboda haka ya ce, “Ni bawan Ibrahim ne. ");
INSERT INTO hausa_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Ubangiji ya albarkaci maigidana sosai, ya kuma zama mai arziki. Ya ba shi tumaki, shanu, azurfa, zinariya, bayi maza da mata, raƙuma, da kuma jakuna. ");
INSERT INTO hausa_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Saratu matar maigidana ta haifa masa ɗa a tsufanta, ya kuma ba shi duk mallakarsa. ");
INSERT INTO hausa_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Maigidana ya sa na yi rantsuwa, ya kuma ce, ‘Kada ka ɗauko wa ɗana mata daga ’ya’ya matan Kan’aniyawa, waɗanda nake zama a ƙasarsu, ");
INSERT INTO hausa_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","amma ka tafi wajen gidan mahaifina da kuma dangina, ka ɗauko wa ɗana mata.’ ");
INSERT INTO hausa_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","“Sai na ce wa maigidana, ‘A ce matar ba tă yarda tă zo tare da ni ba fa?’ ");
INSERT INTO hausa_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","“Maigidana ya ce, ‘Ubangiji wanda yake tare da ni zai aiki mala’ikansa tare da kai, yă kuma sa tafiyarka tă yi nasara, don ka samo wa ɗana mata daga dangina, daga kuma gidan mahaifina. ");
INSERT INTO hausa_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Ta haka za ka kuɓuta daga rantsuwata sa’ad da ka tafi wurin dangina, ko ma sun ƙi su ba ka ita, za ka kuɓuta daga rantsuwata.’ ");
INSERT INTO hausa_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Sa’ad da na zo rijiya a yau, na ce, ‘Ya Ubangiji Allah na maigidana Ibrahim, ina roƙonka ka ba ni nasara a tafiyar da na yi. ");
INSERT INTO hausa_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Duba, ina tsaye kusa da wannan rijiya; in wata yarinya ta fito domin tă ɗiba ruwa, wadda in na ce mata, “Ina roƙonki bari in ɗan sha ruwa daga tulunki,” ");
INSERT INTO hausa_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","in ta ce, “Ka sha, zan kuma ba wa raƙumanka ma,” bari tă zama wadda Ubangiji ya zaɓar wa ɗan maigidana.’ ");
INSERT INTO hausa_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Kafin in gama addu’ar, a zuciyata, sai ga Rebeka ta fito da tulunta a kafaɗarta. Ta gangara zuwa rijiyar ta ɗebo ruwa, na kuma ce mata, ‘Ina roƙonki ki ba ni ɗan ruwa daga tulunki.’ ");
INSERT INTO hausa_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","“Ta yi sauri ta saukar da tulun daga kafaɗarta ta ce, ‘Sha, zan kuma ba wa raƙumanka su ma.’ Sai na sha, ta kuma shayar da raƙumana su ma. ");
INSERT INTO hausa_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","“Na tambaye ta, ‘Ke ’yar wane ne?’ “Ta ce, ‘’Yar Betuwel ɗan Nahor, wanda Milka ta haifa masa.’ “Sai na sa mata zobe a hancinta, woroworo kuma a hannuwata, ");
INSERT INTO hausa_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","na kuma sunkuya na yi wa Ubangiji sujada. Na yabi Ubangiji Allah na maigidana Ibrahim wanda ya bi da ni a hanyar da take daidai, don in samo wa ɗan maigidana jikanyar ɗan’uwansa. ");
INSERT INTO hausa_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Yanzu fa in za ku nuna wa maigidana alheri da aminci, ku faɗa mini, in kuma ba haka ba, ku faɗa mini, don in san hanyar da zan juya.” ");
INSERT INTO hausa_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Laban da Betuwel suka ce, “Wannan daga wurin Ubangiji ne, ba abin da za mu ce I, ko a’a ba. ");
INSERT INTO hausa_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Ga Rebeka, ɗauke ta ku tafi, bari tă zama matar ɗan maigidanka, yadda Ubangiji ya umarta.” ");
INSERT INTO hausa_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Sa’ad da bawan Ibrahim ya ji abin da suka ce, sai ya rusuna har ƙasa a gaban Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Sa’an nan bawan ya fito da kayan ado na zinariya da azurfa da kayayyaki na tufafi ya ba wa Rebeka; ya kuma ba wa ɗan’uwanta da mahaifiyarta kyautai masu tsada. ");
INSERT INTO hausa_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Sa’an nan shi da mutanen da suke tare da shi suka ci, suka sha, suka kuma kwana a can. Kashegari da safe da suka tashi sai ya ce, “A sallame ni in koma wurin maigidana.” ");
INSERT INTO hausa_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Amma ɗan’uwanta da mahaifiyarta suka ce, “Bari yarinyar ta ɗan zauna tare da mu kwana goma ko fiye, sa’an nan ka ta fi.” ");
INSERT INTO hausa_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Amma ya ce musu, “Kada ku tsai da ni, tun da Ubangiji ya ba ni nasara a tafiyata. Ku sallame ni domin in tafi wurin maigidana.” ");
INSERT INTO hausa_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Sa’an nan suka ce, “Bari mu kira yarinyar mu tambaye ta game da zancen.” ");
INSERT INTO hausa_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Saboda haka suka kira Rebeka suka ce mata, “Za ki tafi tare da mutumin nan?” Sai ta ce, “Zan tafi.” ");
INSERT INTO hausa_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Saboda haka suka sallame Rebeka, ’yar’uwarsu, duk da uwar goyonta da bawan Ibrahim da mutanensa. ");
INSERT INTO hausa_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Suka kuma albarkaci Rebeka suka ce mata, “’Yar’uwarmu, bari ki zama mahaifiyar dubu dubbai, bari zuriyarki su mallaki ƙofofin abokan gābansu.” ");
INSERT INTO hausa_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Sa’an nan Rebeka da bayinta mata suka shirya suka hau raƙumansu suka koma tare da mutumin. Da haka bawan ya ɗauki Rebeka ya tafi. ");
INSERT INTO hausa_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Ishaku kuwa ya zo daga Beyer-Lahai-Royi, gama yana zama a Negeb. ");
INSERT INTO hausa_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Wata rana da yamma ya fita zuwa fili domin yă yi tunani, sa’ad da ya ɗaga ido, sai ya ga raƙuma suna zuwa. ");
INSERT INTO hausa_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebeka ma ta ɗaga ido sai ta ga Ishaku. Ta sauka daga raƙuminta da sauri, ");
INSERT INTO hausa_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","ta ce wa bawan, “Wane ne mutumin can a fili, da yake zuwa yă tarye mu?” Bawan ya ce, “Maigidana ne.” Saboda haka ta ɗauki mayafinta to rufe kanta. ");
INSERT INTO hausa_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Sai bawan ya faɗa wa Ishaku duk abin da ya yi. ");
INSERT INTO hausa_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Ishaku ya kawo ta cikin tentin mahaifiyarsa Saratu, ya kuma auri Rebeka. Ta haka ta zama matarsa, ya kuwa ƙaunace ta; Ishaku kuma ya ta’azantu bayan rasuwar mahaifiyarsa. ");
INSERT INTO hausa_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Ibrahim ya auro wata mace, mai suna Ketura. ");
INSERT INTO hausa_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ta haifa masa Zimran, Yokshan, Medan, Midiyan, Ishbak da Shuwa. ");
INSERT INTO hausa_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yokshan shi ne mahaifin Sheba da Dedan. Zuriyar Dedan su ne mutanen Ashur, da mutanen Letush, da kuma mutanen Lewummin. ");
INSERT INTO hausa_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","’Ya’yan Midiyan maza su ne, Efa, Efer, Hanok, Abida, da kuma Elda’a. Dukan waɗannan zuriyar Ketura ce. ");
INSERT INTO hausa_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Ibrahim ya bar wa Ishaku kome da ya mallaka. ");
INSERT INTO hausa_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Amma yayinda Ibrahim yake da rai, ya ba wa ’ya’yan ƙwarƙwaransa maza kyautai, ya kuma sallame su daga ɗansa Ishaku zuwa ƙasashen gabas. ");
INSERT INTO hausa_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Duka-duka, Ibrahim ya yi shekara ɗari da saba’in da biyar. ");
INSERT INTO hausa_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Sa’an nan Ibrahim ya ja numfashinsa na ƙarshe, ya kuma mutu da kyakkyawar tsufa, tsoho da kuma shekaru masu yawa; aka kuma tara shi ga mutanensa. ");
INSERT INTO hausa_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","’Ya’yansa maza kuwa Ishaku da Ishmayel suka binne shi cikin kogon Makfela, kusa da Mamre, a cikin filin Efron ɗan Zohar mutumin Hitti, ");
INSERT INTO hausa_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","filin da Ibrahim ya saya daga Hittiyawa. A nan aka binne Ibrahim tare da matarsa Saratu. ");
INSERT INTO hausa_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Bayan rasuwar Ibrahim, Allah ya albarkaci ɗansa Ishaku wanda a lokacin yana zama kusa da Beyer-Lahai-Royi. ");
INSERT INTO hausa_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Waɗannan su ne zuriyar Ishmayel ɗan Ibrahim, wanda Hagar mutuniyar Masar, baranyar Saratu, ta haifa wa Ibrahim. ");
INSERT INTO hausa_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Ga jerin sunayen ’ya’yan Ishmayel maza bisa ga haihuwarsu, Nebayiwot ɗan farin Ishmayel, Kedar, Adbeyel, Mibsam, ");
INSERT INTO hausa_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mishma, Duma, Massa, ");
INSERT INTO hausa_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadad, Tema, Yetur, Nafish da Kedema. ");
INSERT INTO hausa_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Waɗannan su ne ’ya’yan Ishmayel maza, waɗanda kuma suke sunayen kabilu goma sha biyu masu mulki bisa ga wuraren zamansu da sansaninsu. ");
INSERT INTO hausa_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Duka-duka Ishmayel ya yi shekara ɗari da talatin da bakwai; sai ya ja numfashinsa na ƙarshe, ya kuma mutu, aka kuma tara shi ga mutanensa. ");
INSERT INTO hausa_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Zuriyarsa sun zauna tsakanin Hawila ne da Shur, wanda yake kusa da gabashin iyakar Masar wajen Asshur. Sun yi zaman rikici da dukan sauran ’yan’uwansu. ");
INSERT INTO hausa_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Waɗannan su ne zuriyar Ishaku ɗan Ibrahim. Ibrahim ya haifi Ishaku, ");
INSERT INTO hausa_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Ishaku yana da shekara arba’in sa’ad da ya auri Rebeka ’yar Betuwel, mutumin Aram, daga Faddan Aram, ’yar’uwar Laban mutumin Aram. ");
INSERT INTO hausa_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Ishaku ya yi addu’a ga Ubangiji a madadin matarsa, saboda ba ta haihuwa. Ubangiji ya amsa addu’arsa, matarsa Rebeka kuwa ta yi ciki. ");
INSERT INTO hausa_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Jariran suka kama kokawa da juna a cikinta, sai ta ce, “Me ya sa wannan yake faruwa da ni?” Saboda haka ta tafi don ta nemi nufin Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Ubangiji ya ce mata, “Al’ummai biyu suna a cikin mahaifarki mutum biyu da za ki haifa, za su rabu da juna, ɗayan zai fi ɗayan ƙarfi, babban kuma zai bauta wa ƙaramin.” ");
INSERT INTO hausa_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Da lokaci ya yi da za tă haihu, sai ga ’yan biyu maza a mahaifarta. ");
INSERT INTO hausa_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Wanda ya fara fita ja ne, dukan jikinsa kuwa kamar riga mai gashi. Don haka aka sa masa suna Isuwa. ");
INSERT INTO hausa_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Bayan wannan, ɗan’uwansa ya fito, da hannunsa yana riƙe da ɗiɗɗigen Isuwa; don haka aka sa masa suna Yaƙub. Ishaku yana da shekara sittin, lokacin da Rebeka ta haife su. ");
INSERT INTO hausa_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Yaran suka yi girma, Isuwa kuwa ya zama riƙaƙƙen maharbi, mutumin jeji, yayinda Yaƙub, shiru-shiru ne mai son zama a tentuna. ");
INSERT INTO hausa_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Ishaku, mai son ci naman jeji, ya ƙaunaci Isuwa, amma Rebeka ta ƙaunaci Yaƙub. ");
INSERT INTO hausa_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Wata rana sa’ad da Yaƙub yana dafa fate. Isuwa ya shigo daga jeji, da yunwa sosai. ");
INSERT INTO hausa_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Ya ce wa Yaƙub, “Ina roƙonka, ka ɗan ɗiba mini faten nan! Ina fama da yunwa!” (Shi ya sa aka kira shi Edom.) ");
INSERT INTO hausa_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Yaƙub ya amsa ya ce, “Ka fara sayar mini da matsayinka na ɗan fari tukuna.” ");
INSERT INTO hausa_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Isuwa ya ce, “Duba, ina gab da mutuwa, me matsayina na ɗan fari zai yi mini?” ");
INSERT INTO hausa_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Amma Yaƙub ya ce, “Ka rantse mini tukuna.” Don haka ya rantse masa, ya sayar da matsayinsa na ɗan fari ga Yaƙub. ");
INSERT INTO hausa_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Sa’an nan Yaƙub ya ba wa Isuwa burodi da ɗan miyan lansir. Ya ci, ya sha, sa’an nan ya tashi ya tafi. Ta haka Isuwa ya yi banza da matsayinsa na ɗan fari. ");
INSERT INTO hausa_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Aka yi yunwa a ƙasar; ban da yunwar da aka yi da fari a zamanin Ibrahim, sai Ishaku ya tafi wurin Abimelek sarkin Filistiyawa a Gerar. ");
INSERT INTO hausa_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Ubangiji kuwa ya bayyana ga Ishaku ya ce, “Kada ka gangara zuwa Masar; ka yi zauna a ƙasar da zan faɗa maka. ");
INSERT INTO hausa_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Ka zauna a wannan ƙasa na ɗan lokaci, zan kuwa kasance tare da kai, zan kuma albarkace ka. Gama zan ba da waɗannan ƙasashe gare ka da kuma zuriyarka. Zan kuma cika rantsuwar da na yi wa mahaifinka Ibrahim. ");
INSERT INTO hausa_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Zan sa zuriyarka ta yi yawa kamar taurari a sararin sama zan kuwa ba su dukan waɗannan ƙasashe, ta wurin ’ya’yanka kuma za a albarkaci dukan al’umman duniya, ");
INSERT INTO hausa_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","domin Ibrahim ya yi mini biyayya ya kuma kiyaye umarnaina, ƙa’idodina da kuma dokokina.” ");
INSERT INTO hausa_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Sai Ishaku ya zauna a Gerar. ");
INSERT INTO hausa_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Sa’ad da mutanen wurin suka tambaye shi game da matarsa, sai ya ce, “’Yar’uwata ce,” gama yana tsoro yă ce, “Ita matata ce.” Ya yi tunani, “Mutane wannan wuri za su kashe ni ta dalili Rebeka, domin kyakkyawa ce.” ");
INSERT INTO hausa_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Sa’ad da Ishaku ya daɗe a can, sai Abimelek sarkin Filistiyawa ya duba daga taga ya ga Ishaku yana rungumar matarsa Rebeka. ");
INSERT INTO hausa_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Saboda haka Abimelek ya aika Ishaku yă je, sa’an nan ya ce, “Tabbatacce ita matarka ce! Me ya sa ka ce, ‘Ita ’yar’uwata ce?’ ” Ishaku ya amsa masa ya ce, “Don na yi tsammani zan rasa raina saboda ita.” ");
INSERT INTO hausa_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Sa’an nan Abimelek ya ce, “Me ke nan ka yi mana? Da a ce wani daga mazanmu ya kwana da matarka, ai, da ka jawo laifi a kanmu.” ");
INSERT INTO hausa_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Saboda haka Abimelek ya yi umarni ga dukan mutane. “Duk wanda ya fitine wannan mutum ko matarsa, tabbatacce za a kashe shi.” ");
INSERT INTO hausa_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Ishaku ya shuka hatsi a wannan ƙasa, a shekaran nan ya yi girbi ninki ɗari, domin Ubangiji ya albarkace shi. ");
INSERT INTO hausa_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Mutumin ya arzuta, arzikinsa ya yi ta haɓaka har ya zama attajiri. ");
INSERT INTO hausa_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Ya kasance da garkunan tumaki da na shanu da bayi masu yawa, har Filistiyawa suka yi ƙyashinsa. ");
INSERT INTO hausa_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Saboda haka dukan rijiyoyin da bayin mahaifinsa suka haƙa a kwanakin da mahaifinsa Ibrahim yake da rai, Filistiyawa sun toshe su, suka kuma ciccike su da ƙasa. ");
INSERT INTO hausa_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Sai Abimelek ya ce wa Ishaku, “Fita daga cikinmu; ka fi ƙarfinmu.” ");
INSERT INTO hausa_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Saboda haka Ishaku ya fita daga can, ya yi sansani a Kwarin Gerar, ya kuma zauna a can. ");
INSERT INTO hausa_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Ishaku ya sāke tona rijiyoyi waɗanda dā aka haƙa a zamanin Ibrahim mahaifinsa, gama Filistiyawa suka tattoshe bayan mutuwar Ibrahim, ya kuma sa musu sunayen da mahaifinsa ya ba su. ");
INSERT INTO hausa_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Barorin Ishaku suka haƙa cikin kwarin suka kuwa sami rijiya mai ruwa mai kyau a can. ");
INSERT INTO hausa_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Amma makiyayan Gerar suka yi faɗa da na Ishaku suka ce, “Ruwan namu ne!” Saboda haka Ishaku ya ba wa rijiyar suna Esek, domin sun yi faɗa da shi. ");
INSERT INTO hausa_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Sai suka haƙa wata rijiya, amma suka yi faɗa a kanta ita ma, saboda haka ya ce da ita Sitna. ");
INSERT INTO hausa_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Sai Ishaku ya matsa daga can ya sāke haƙa wata rijiyar, babu wani kuma da yi faɗa a kanta. Sai ya ba ta suna Rehobot, yana cewa, “Yanzu Ubangiji ya ba mu wuri, za mu kuwa yi ta haihuwa a ƙasar.” ");
INSERT INTO hausa_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Daga can ya haura zuwa Beyersheba. ");
INSERT INTO hausa_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","A wannan dare Ubangiji ya bayyana gare shi ya ce, “Ni ne Allah na mahaifinka Ibrahim. Kada ka ji tsoro, gama ina tare da kai, zan albarkace ka, zan kuma ƙara yawan zuriyarka saboda bawana Ibrahim.” ");
INSERT INTO hausa_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Sai Ishaku ya gina bagade a can, ya kuma kira bisa sunan Ubangiji. A can ya kafa tentinsa, a can kuma bayinsa suka haƙa wata rijiya. ");
INSERT INTO hausa_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Ana cikin haka, sai Abimelek ya zo wurinsa daga Gerar, tare da Ahuzzat mai ba shi shawara da Fikol shugaban mayaƙansa. ");
INSERT INTO hausa_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Ishaku ya tambaye su, “Me ya kawo ku gare ni, da yake kun yi gāba da ni, kuka kuma kore ni?” ");
INSERT INTO hausa_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Suka amsa, “Mun ga a zahiri cewa Ubangiji yana tare da kai; saboda haka muka ce, ‘Dole rantsuwa ta kasance tsakaninmu da kai.’ Bari mu yi yarjejjeniya da kai ");
INSERT INTO hausa_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","cewa ba za ka cuce mu ba, kamar yadda ba mu fitine ka ba, amma muka yi maka kirki, muka kuma sallame ka cikin salama. Yanzu kuwa kai albarkatacce ne na Ubangiji.” ");
INSERT INTO hausa_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Sai Ishaku ya shirya musu liyafa, suka ci suka kuma sha. ");
INSERT INTO hausa_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Kashegari da sassafe sai mutanen suka yi wa juna rantsuwa. Sa’an nan Ishaku ya sallame su, suka kuwa tafi cikin salama. ");
INSERT INTO hausa_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","A wannan rana bayin Ishaku suka zo suka faɗa masa game da rijiyar da suka haƙa. Suka ce, “Mun sami ruwa!” ");
INSERT INTO hausa_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Sai ya kira ta Shiba, don haka har wa yau ana kira garin Beyersheba. ");
INSERT INTO hausa_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Sa’ad da Yaƙub ya kai shekaru arba’in da haihuwa, sai ya auri Yudit ’yar Beyeri mutumin Hitti, da kuma Basemat ’yar Elon mutumin Hitti. ");
INSERT INTO hausa_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Su ne suka zama sanadin baƙin ciki ga Ishaku da Rebeka. ");
INSERT INTO hausa_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Sa’ad da Ishaku ya tsufa idanunsa suka raunana har ba ya iya gani, sai ya kira Isuwa babban ɗansa ya ce masa, “Ɗana.” Isuwa kuwa ya amsa, ya ce “Ga ni.” ");
INSERT INTO hausa_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Ishaku ya ce, “Yanzu na tsufa kuma ban san ranar mutuwata ba. ");
INSERT INTO hausa_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Saboda haka yanzu, ka ɗauki makamanka, kwari da bakanka, ka tafi jeji ka farauto mini nama. ");
INSERT INTO hausa_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Ka shirya mini irin abinci mai daɗin da nake so, ka kawo mini in ci, domin in sa maka albarka kafin in mutu.” ");
INSERT INTO hausa_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Ashe, Rebeka tana ji sa’ad da Ishaku ya yi wa ɗansa Isuwa magana. Da Isuwa ya tafi jeji don yă farauto nama yă kawo, ");
INSERT INTO hausa_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","sai Rebeka ta ce wa ɗanta Yaƙub, “Ka ji nan, na ji mahaifinka ya ce wa ɗan’uwanka Isuwa, ");
INSERT INTO hausa_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Kawo mini nama ka shirya mini abinci mai daɗi don in ci, in sa maka albarka a gaban Ubangiji kafin in mutu.’ ");
INSERT INTO hausa_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Saboda haka ɗana, ka saurara da kyau ka kuma yi abin da na faɗa maka. ");
INSERT INTO hausa_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Je garke ka kawo mini awaki biyu kyawawa, domin in shirya abinci mai daɗi wa mahaifinka, kamar yadda dai yake so. ");
INSERT INTO hausa_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Sa’an nan ka kai wa mahaifinka yă ci, domin yă sa maka albarka kafin yă mutu.” ");
INSERT INTO hausa_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Yaƙub ya ce wa mahaifiyarsa Rebeka, “Amma ɗan’uwana Isuwa mutum ne mai gashi a jiki, ni kuma jikina sumul yake. ");
INSERT INTO hausa_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","A ce baba ya tattaɓa ni fa? Zai zama kamar ina ruɗunsa ne, wannan fa zai jawo mini la’ana a maimakon albarka.” ");
INSERT INTO hausa_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Mahaifiyarsa ta ce masa, “Ɗana, bari la’anar tă fāɗo a kaina. Kai dai yi abin da na faɗa, jeka ka kawo mini su.” ");
INSERT INTO hausa_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Sai ya tafi ya kamo su, ya kawo wa mahaifiyarsa, ta kuwa shirya abinci mai daɗi, yadda mahaifinsa yake so. ");
INSERT INTO hausa_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Sa’an nan Rebeka ta ɗauki riguna mafi kyau na Isuwa babban ɗanta, waɗanda take da su a gida ta sa wa ƙaramin ɗanta Yaƙub. ");
INSERT INTO hausa_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Sai ta mamanne gashin awakin nan biyu a hannuwansa da bayan wuyarsa wanda ba gashi. ");
INSERT INTO hausa_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Sa’an nan ta ba wa ɗanta Yaƙub abinci mai daɗi da kuma burodin da ta yi. ");
INSERT INTO hausa_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Shi kuwa ya tafi wurin mahaifinsa ya ce, “Babana.” Shi kuma ya amsa “I, ɗana, wane ne?” ");
INSERT INTO hausa_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yaƙub ya ce wa mahaifinsa, “Ni ne Isuwa ɗan farinka. Na yi yadda ka faɗa mini. Ina roƙonka tashi ka zauna ka ci naman, domin ka sa mini albarkarka.” ");
INSERT INTO hausa_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Ishaku ya tambayi ɗansa, “Yaya aka yi ka samo shi da sauri haka, ɗana?” Yaƙub ya amsa ya ce, “Ubangiji Allahnka ne ya ba ni nasara.” ");
INSERT INTO hausa_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Sai Ishaku ya ce wa Yaƙub, “Zo kusa don in taɓa ka, ɗana, domin in sani ko tabbatacce kai ne ɗana Isuwa ko babu.” ");
INSERT INTO hausa_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Yaƙub kuwa ya matsa kusa da mahaifinsa Ishaku, wanda ya tattaɓa shi, sa’an nan ya ce, “Muryan nan dai, muryar Yaƙub ce, amma hannuwan, hannuwan Isuwa ne.” ");
INSERT INTO hausa_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Bai gane shi ba, gama hannuwansa suna da gashi kamar na ɗan’uwansa Isuwa, saboda haka ya albarkace shi. ");
INSERT INTO hausa_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Ya tambaya, “Tabbatacce kai ne ɗana Isuwa?” Ya amsa ya ce “Ni ne.” ");
INSERT INTO hausa_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Sa’an nan ya ce, “Ɗana, kawo mini naman da ka farauto in ci, domin in sa maka albarka.” Yaƙub ya kawo masa ya kuwa ci; ya kuma kawo masa ruwan inabi ya kuma sha. ");
INSERT INTO hausa_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Sa’an nan mahaifinsa Ishaku ya ce masa, “Zo nan, ɗana ka sumbace ni.” ");
INSERT INTO hausa_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Saboda haka ya je gunsa ya sumbace shi. Sa’ad da Ishaku ya ji ƙanshin rigunansa, sai ya sa masa albarka ya ce, “Aha, ƙanshin ɗana yana kama da ƙanshin jejin da Ubangiji ya sa wa albarka ne. ");
INSERT INTO hausa_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Allah yă ba ka daga raɓar sama da kuma yalwar ƙasa, yalwar hatsi da sabon ruwan inabi. ");
INSERT INTO hausa_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Bari al’ummai su bauta maka mutane kuma su rusuna maka. Ka zama shugaba a kan ’yan’uwanka bari kuma ’ya’yan mahaifiyarka su rusuna maka. Bari waɗanda suka la’anta ka, su la’antu; waɗanda kuma suka sa maka albarka, su sami albarka.” ");
INSERT INTO hausa_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Bayan Ishaku ya gama sa masa albarka, Yaƙub yana fita daga mahaifinsa ke nan, sai ga ɗan’uwansa Isuwa ya dawo daga farauta. ");
INSERT INTO hausa_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Shi ma ya shirya abinci mai daɗi ya kawo wa mahaifinsa. Sa’an nan ya ce masa, “Babana, tashi ka zauna ka ci daga abin da na farauto, domin ka sa mini albarka.” ");
INSERT INTO hausa_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Mahaifinsa Ishaku ya tambaye shi, “Wane ne kai?” Ya amsa, “Ni ne ɗanka, ɗan farinka, Isuwa.” ");
INSERT INTO hausa_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Ishaku ya yi makyarkyata ƙwarai ya ce, “To, wane ne wannan da ya farauto nama ya kawo mini kafin ka zo, har na ci na kuma sa masa albarka? Tabbatacce zai zama mai albarka!” ");
INSERT INTO hausa_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Sa’ad da Isuwa ya ji kalmomin mahaifinsa, sai ya fashe da kuka mai zafi kuma da ƙarfi, ya ce wa mahaifinsa, “Ka albarkace ni, ni ma, baba!” ");
INSERT INTO hausa_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Amma ya ce, “Ɗan’uwanka ya zo da makirci ya karɓi albarkarka.” ");
INSERT INTO hausa_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Isuwa ya ce, “Ba saboda haka ne aka raɗa masa suna Yaƙub ba? Ya yi mini ƙwace sau biyu ke nan; ya ƙwace mini matsayina na ɗan fari, ga shi yanzu kuma ya karɓi albarkata.” Sa’an nan ya yi tambaya, “Ba sauran albarkar da ka rage mini?” ");
INSERT INTO hausa_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Ishaku ya amsa wa Isuwa, “Na mai da shi shugaba a kanka, na sa dukan dangoginsa su zama bayinsa, na kuma ba shi hatsi da sabon ruwan inabi. Saboda haka me kuma zan yi maka ɗana?” ");
INSERT INTO hausa_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Isuwa ya ce wa mahaifinsa, “Iyakar albarkar da kake da ita ke nan, baba? Ka albarkace ni ni ma, baba!” Sai Isuwa ya ɗaga murya ya yi kuka. ");
INSERT INTO hausa_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Mahaifinsa Ishaku ya amsa masa ya ce, “Ga shi, ni’imar ƙasar za tă nisanci mazauninka. Raɓar samaniya can ƙwanƙoli za tă nisance ka. ");
INSERT INTO hausa_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Za ka rayu ta wurin takobi za ka kuwa bauta wa ɗan’uwanka. Amma sa’ad da ka ɓalle, za ka kakkarye karkiyarsa daga wuyanka.” ");
INSERT INTO hausa_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Isuwa ya riƙe Yaƙub a zuciya saboda albarkar da mahaifinsa ya sa masa. Ya ce wa kansa, “Kwanakin mutuwar mahaifina sun yi kusa; sa’an nan zan kashe ɗan’uwana Yaƙub.” ");
INSERT INTO hausa_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Sa’ad da aka faɗa wa Rebeka abin da babban ɗanta Isuwa ya faɗa, sai ta kira ɗanta Yaƙub ta ce masa, “Ɗan’uwanka Isuwa yana ta’azantar da kansa da tunanin kashe ka. ");
INSERT INTO hausa_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","To, fa, ɗana, yi abin da na ce; gudu nan take zuwa wurin ɗan’uwana Laban a Haran. ");
INSERT INTO hausa_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Zauna tare da shi na ɗan lokaci sai ɗan’uwanka ya huce. ");
INSERT INTO hausa_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Sa’ad da ɗan’uwanka ya daina fushi da kai, ya kuma manta da abin da ka yi masa, zan aika don ka dawo daga can. Don me zan rasa ku biyu a rana guda?” ");
INSERT INTO hausa_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Sa’an nan Rebeka ta ce wa Ishaku, “Ni fa na gaji da matan Hittiyawan nan. In Yaƙub ya auri mata daga cikin matan ƙasan nan, wato, daga matan Hittiyawa irin waɗannan, rayuwata ba za tă daɗa mini kome ba.” ");
INSERT INTO hausa_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Saboda haka Ishaku ya kira Yaƙub, ya kuma albarkace shi, sa’an nan ya umarce shi ya ce, “Kada ka auri mace daga Kan’ana. ");
INSERT INTO hausa_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Tashi nan da nan ka tafi Faddan Aram, zuwa gidan mahaifin mahaifiyarka Betuwel. Ka ɗauko wa kanka mata a can daga cikin ’ya’ya matan Laban ɗan’uwan mahaifiyarka. ");
INSERT INTO hausa_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Bari Allah Maɗaukaki yă albarkace ka, yă kuma sa ka yi ta haihuwa ka riɓaɓɓanya har ka zama ƙungiyar jama’o’i. ");
INSERT INTO hausa_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Bari Allah yă ba ka da kuma zuriyarka albarkar da ya ba wa Ibrahim, don ka amshi ƙasar da kake baƙunci, ƙasar da Allah ya ba wa Ibrahim.” ");
INSERT INTO hausa_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Sa’an nan Ishaku ya sallami Yaƙub, ya kuwa tafi Faddan Aram, zuwa wurin Laban ɗan Betuwel mutumin Aram. Laban ne ɗan’uwan Rebeka, wadda take mahaifiyar Yaƙub da Isuwa. ");
INSERT INTO hausa_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Yanzu Isuwa ya san cewa Ishaku ya albarkaci Yaƙub ya kuma aike shi zuwa Faddan Aram don yă auri mata daga can, ya kuma san cewa sa’ad da ya albarkace shi, ya umarce shi cewa, “Kada ka auro wata mace daga cikin Kan’aniyawa,” ");
INSERT INTO hausa_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","ya kuma san cewa Yaƙub ya yi biyayya da mahaifinsa da kuma mahaifiyarsa, ya kuwa tafi Faddan Aram. ");
INSERT INTO hausa_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Sai Isuwa ya gane cewa matan Kan’aniyawa ba su gamshi mahaifinsa Ishaku ba; ");
INSERT INTO hausa_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","saboda haka sai ya tafi wurin Ishmayel ya auri Mahalat, ’yar’uwar Nebayiwot da kuma ’yar Ishmayel ɗan Ibrahim, ban da matan da yake da su. ");
INSERT INTO hausa_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yaƙub ya bar Beyersheba ya kama hanyar Haran. ");
INSERT INTO hausa_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Sa’ad da ya kai wani wuri, sai ya dakata domin yă kwana, gama rana ta riga ta fāɗi. Ya ɗauki dutse daga cikin duwatsun wurin, ya sa shi ya zama matashin kansa, sa’an nan ya kwanta don yă yi barci. ");
INSERT INTO hausa_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Ya yi mafarki inda ya ga wata matakalar hawa, tsaye a ƙasa, kanta ta kai sama, mala’ikun Allah kuwa suna hawa, suna sauka a kanta. ");
INSERT INTO hausa_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","A can bisantaUbangiji ya tsaya, ya kuma ce, “Ni ne Ubangiji Allah na mahaifinka Ibrahim da kuma Allah na Ishaku. Zan ba ka, kai da kuma zuriyarka, ƙasar da kake kwance a kai. ");
INSERT INTO hausa_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Zuriyarka za tă zama kamar ƙurar ƙasa, za ka kuma bazu zuwa yamma da kuma gabas, zuwa arewa da kuma kudu. Dukan mutanen duniya za su sami albarka ta wurinka da kuma ta wurin ’ya’yanka. ");
INSERT INTO hausa_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Ina tare da kai, zan lura da kai duk inda ka tafi, zan kuma dawo da kai zuwa wannan ƙasa. Ba zan rabu da kai ba sai na cika abin da na yi maka alkawari.” ");
INSERT INTO hausa_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Sa’ad da Yaƙub ya farka daga barci, sai ya yi tunani ya ce, “Tabbatacce Ubangiji yana a wannan wuri, ban kuwa sani ba.” ");
INSERT INTO hausa_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Ya ji tsoro, ya kuma ce, “Wane irin wuri ne mai banrazana haka! Lalle wannan gidan Allah ne, kuma nan ne ƙofar sama.” ");
INSERT INTO hausa_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Kashegari da sassafe, sai Yaƙub ya ɗauki dutsen da ya yi matashin kai da shi, ya kafa shi al’amudi, ya kuma zuba mai a kansa. ");
INSERT INTO hausa_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Ya kira wannan wuri Betel ko da yake dā ana kiran birnin Luz ne. ");
INSERT INTO hausa_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Sa’an nan Yaƙub ya yi alkawari cewa, “In Allah zai kasance tare da ni yă kuma lura da ni a wannan tafiya, yă kuma ba ni abinci in ci da tufafi in sa, ");
INSERT INTO hausa_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","har in dawo lafiya zuwa gidan mahaifina, to, Ubangiji zai zama Allahna ");
INSERT INTO hausa_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","kuma wannan dutsen da na kafa al’amudi, zai zama gidan Allah, kuma dukan abin da ka ba ni zan ba ka kashi ɗaya bisa goma.” ");
INSERT INTO hausa_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Sa’an nan Yaƙub ya ci gaba da tafiyarsa har ya kai ƙasar mutanen gabashi. ");
INSERT INTO hausa_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","A can ya ga rijiya a jeji da garkuna uku na tumaki kwance kusa da ita, gama a wannan rijiya ce ake shayar da garkuna. Dutsen da ake rufe bakin rijiyar mai girma ne. ");
INSERT INTO hausa_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Sa’ad da dukan garkuna suka taru a can, sai makiyayan su gungurar da dutsen daga bakin rijiyar su shayar da tumaki. Sa’an nan su mai da dutsen a wurinsa a bakin rijiya. ");
INSERT INTO hausa_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yaƙub ya tambayi makiyayan ya ce, “’Yan’uwa, ina kuka fito?” Suka amsa, “Mu daga Haran ne.” ");
INSERT INTO hausa_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Sai ya ce musu, “Kun san Laban, jikan Nahor?” Suka amsa, “I, mun san shi.” ");
INSERT INTO hausa_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Sa’an nan Yaƙub ya tambaye su, “Yana nan lafiya?” Suka ce, “I, yana lafiya, ga ma ’yarsa Rahila tafe da tumaki.” ");
INSERT INTO hausa_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Ya ce, “Duba har yanzu da sauran rana da yawa, lokaci bai kai na tara garkuna ba. Ku shayar da tumaki ku mai da su wurin kiwo.” ");
INSERT INTO hausa_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Suka amsa suka ce, “Ba za mu iya ba, sai dukan garkunan sun taru, aka kuma gungurar da dutsen daga bakin rijiyar. Sa’an nan za mu shayar da tumakin.” ");
INSERT INTO hausa_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Tun yana cikin magana da su, sai ga Rahila ta zo da tumakin mahaifinta, gama ita makiyayyiya ce. ");
INSERT INTO hausa_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Sa’ad da Yaƙub ya ga Rahila ’yar Laban, ɗan’uwan mahaifiyarsa, da tumakin Laban, sai ya tafi ya gungurar da dutsen daga bakin rijiyar, ya kuma shayar da tumakin kawunsa. ");
INSERT INTO hausa_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Sa’an nan Yaƙub ya sumbaci Rahila, ya kuma ɗaga murya ya yi kuka. ");
INSERT INTO hausa_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Ya riga ya faɗa wa Rahila cewa shi dangin mahaifinta ne kuma ɗan Rebeka. Saboda haka ta ruga da gudu ta faɗa wa mahaifinta. ");
INSERT INTO hausa_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Nan da nan, da Laban ya sami labari game da Yaƙub, ɗan ’yar’uwarsa, ya gaggauta yă sadu da shi. Sai ya rungume shi ya sumbace shi, ya kuma kawo shi gidansa, a can kuwa Yaƙub ya faɗa masa dukan waɗannan abubuwa. ");
INSERT INTO hausa_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Sa’an nan Laban ya ce masa, “Kai nama da jinina ne.” Bayan Yaƙub ya zauna da shi na wata guda cif, ");
INSERT INTO hausa_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","sai Laban ya ce masa, “Don kawai kai dangina ne na kusa, sai kawai ka yi mini aiki a banza? Faɗa mini abin da albashinka zai zama.” ");
INSERT INTO hausa_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Laban dai yana da ’ya’ya mata biyu; sunan babbar Liyatu, sunan ƙaramar kuwa Rahila. ");
INSERT INTO hausa_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Liyatu tana da raunannun idanu, amma Rahila dai tsarinta yana da kyau kuma kyakkyawa ce. ");
INSERT INTO hausa_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yaƙub ya ƙaunaci Rahila, sai ya ce, “Zan yi maka aiki na shekaru bakwai domin ƙaramar ’yarka Rahila.” ");
INSERT INTO hausa_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laban ya ce, “Ya fi kyau in ba ka ita, da in ba wani mutum dabam. Zauna tare da ni.” ");
INSERT INTO hausa_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Saboda haka Yaƙub ya yi bauta shekaru bakwai domin a ba shi Rahila, amma shekarun suka zama kamar ’yan kwanaki ne kawai gare shi saboda ƙaunar da yake mata. ");
INSERT INTO hausa_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Sa’an nan Yaƙub ya ce wa Laban, “Ba ni matata. Lokacina ya cika, ina kuma so in kwana da ita.” ");
INSERT INTO hausa_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Saboda haka Laban ya tara dukan mutanen wurin, ya yi biki. ");
INSERT INTO hausa_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Amma da yamma ta yi, sai ya ɗauki ’yarsa Liyatu ya ba da ita ga Yaƙub, sai Yaƙub ya kwana da ita. ");
INSERT INTO hausa_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Laban kuma ya ba da baranyarsa Zilfa wa ’yarsa tă zama mai hidimarta. ");
INSERT INTO hausa_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Sa’ad da safiya ta yi, sai ga Liyatu! Saboda haka Yaƙub ya ce wa Laban, “Mene ne ke nan ka yi mini? Na yi maka bauta domin Rahila, ba haka na yi ba? Don me ka ruɗe ni?” ");
INSERT INTO hausa_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laban ya amsa, “Ba al’adarmu ba ce a nan a ba da ’ya ƙarama aure kafin ’yar fari. ");
INSERT INTO hausa_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Ka gama makon amaryanci na ’yar nan; sa’an nan za mu ba ka ƙaramar ita ma, don ƙarin waɗansu shekaru bakwai na aiki.” ");
INSERT INTO hausa_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Haka kuwa Yaƙub ya yi. Ya gama mako guda da Liyatu, sa’an nan Laban ya ba shi ’yarsa Rahila tă zama matarsa. ");
INSERT INTO hausa_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Laban ya ba da baranyarsa Bilha wa ’yarsa Rahila ta zama mai hidimarta. ");
INSERT INTO hausa_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Yaƙub ya kwana da Rahila ita ma, ya kuwa ƙaunaci Rahila fiye da Liyatu. Ya kuma yi wa Laban aiki na ƙarin waɗansu shekaru bakwai. ");
INSERT INTO hausa_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Sa’ad da Ubangiji ya ga ba a ƙaunar Liyatu, sai ya buɗe mahaifarta, amma Rahila ta zama bakararriya. ");
INSERT INTO hausa_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Sai Liyatu ta yi ciki ta haifi ɗa. Ta sa masa suna Ruben, gama ta ce, “Domin Ubangiji ya ga wahalata. Tabbatacce mijina zai ƙaunace ni yanzu.” ");
INSERT INTO hausa_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Ta sāke yin ciki, sa’ad da kuma ta haifi ɗa sai ta ce, “Gama Ubangiji ya ji cewa ba a ƙaunata, ya ba ni wannan shi ma.” Saboda haka ta ba shi suna Simeyon. ");
INSERT INTO hausa_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Har yanzu ta yi ciki, sa’ad da kuma ta haifi ɗa sai ta ce, “Yanzu, a ƙarshe mijina zai manne mini, gama na haifa masa ’ya’ya maza uku.” Saboda haka ta ba shi suna Lawi. ");
INSERT INTO hausa_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Ta sāke yin ciki, sa’ad da ta haifi ɗa sai ta ce, “A wannan lokaci zan yabi Ubangiji.” Saboda haka ta ba shi suna Yahuda. Sa’an nan ta daina haihuwa. ");
INSERT INTO hausa_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Sa’ad da Rahila ta ga cewa ba tă haifa wa Yaƙub ’ya’ya ba, sai ta fara kishin ’yar’uwarta. Saboda haka ta ce wa Yaƙub, “Ka ba ni ’ya’ya, ko kuwa in mutu!” ");
INSERT INTO hausa_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Yaƙub ya fusata da ita ya ce, “Ina a matsayin Allah ne wanda ya hana ke samun ’ya’ya?” ");
INSERT INTO hausa_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Sa’an nan ta ce, “Ga Bilha, mai baiwata, ka kwana da ita don tă haifa mini ’ya’ya, ta gare ta kuwa ni ma in gina iyali.” ");
INSERT INTO hausa_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Saboda haka ta ba shi baranyarta Bilha tă zama matarsa. Yaƙub kuwa ya kwana da ita, ");
INSERT INTO hausa_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","ta kuwa yi ciki, ta kuma haifi ɗa. ");
INSERT INTO hausa_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Sa’an nan Rahila ta ce, “Allah ya baratar da ni; ya saurari roƙona ya kuma ba ni ɗa.” Saboda wannan ta ba shi suna Dan. ");
INSERT INTO hausa_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Baranyar Rahila ta sāke yin ciki ta kuma haifi wa Yaƙub ɗa na biyu. ");
INSERT INTO hausa_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Sai Rahila ta ce, “Na yi kokawa sosai da ’yar’uwata, na kuwa yi nasara.” Saboda haka ta kira shi Naftali. ");
INSERT INTO hausa_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Sa’ad da Liyatu ta ga cewa ta daina haihuwa, sai ta ɗauki mai hidimarta Zilfa ta ba da ita ga Yaƙub tă zama matarsa. ");
INSERT INTO hausa_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Baranyar Liyatu, Zilfa ta haifa wa Yaƙub ɗa. ");
INSERT INTO hausa_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Sai Liyatu ta ce, “Na yi sa’a!” Saboda haka ta ba shi suna Gad. ");
INSERT INTO hausa_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Zilfa baranyar Liyatu ta haifa wa Yaƙub ɗa na biyu. ");
INSERT INTO hausa_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Sai Liyatu ta ce, “Ni mai farin ciki ce! Mata za su ce da ni mai farin ciki.” Saboda haka ta sa masa suna Asher. ");
INSERT INTO hausa_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","A lokacin girbin alkama, sai Ruben ya je jeji ya ɗebo manta-uwa ya kawo wa mahaifiyarsa Liyatu. Sai Rahila ta ce wa Liyatu, “Ina roƙonki ki ɗan sam mini manta-uwa ɗanki.” ");
INSERT INTO hausa_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Amma ta ce mata, “Bai ishe ki ba ne da kika ƙwace mijina? Yanzu kuma kina so ki ƙwace manta-uwa na yarona?” Sai Rahila ta ce “Shi ke nan, mijina zai iya kwana da ke yau saboda manta-uwa na ɗanki.” ");
INSERT INTO hausa_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Saboda haka sa’ad da Yaƙub ya dawo daga jeji a wannan yamma sai Liyatu ta fito ta tarye shi. Ta ce, “Dole ka kwana da ni, na yi hayarka da manta-uwa na ɗana.” Saboda haka ya kwana da ita a wannan dare. ");
INSERT INTO hausa_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Allah ya saurari Liyatu, ta kuwa yi ciki ta kuma haifa wa Yaƙub ɗa na biyar. ");
INSERT INTO hausa_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Sai Liyatu ta ce, “Allah ya sāka mini saboda na ba da mai hidimata ga mijina.” Saboda haka ta ba shi suna Issakar. ");
INSERT INTO hausa_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Liyatu ta sāke yin ciki ta kuma haifa wa Yaƙub ɗa na shida. ");
INSERT INTO hausa_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Sai Liyatu ta ce, “Allah ya ba ni kyauta mai daraja. A wannan lokaci mijina zai darajarta ni, domin na haifa masa ’ya’ya maza shida.” Saboda haka ta ba shi suna Zebulun. ");
INSERT INTO hausa_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Daga baya ta haifi ’ya ta kuwa ba ta suna Dina. ");
INSERT INTO hausa_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Sai Allah ya tuna da Rahila; ya saurare ta ya kuma buɗe mahaifarta. ");
INSERT INTO hausa_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Sai ta yi ciki ta kuma haifi ɗa ta ce, “Allah ya ɗauke mini kunyata.” ");
INSERT INTO hausa_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Ta ba shi suna Yusuf, ta kuma ce, “Bari Ubangiji yă ƙara mini wani ɗa.” ");
INSERT INTO hausa_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Bayan Rahila ta haifi Yusuf, sai Yaƙub ya ce wa Laban, “Ka sallame ni don in koma ƙasata. ");
INSERT INTO hausa_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Ba ni matana da ’ya’yana, waɗanda na bauta maka dominsu, zan kuwa tafi. Ka dai san yadda na bauta maka.” ");
INSERT INTO hausa_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Amma Laban ya ce masa, “In na sami tagomashi daga gare ka, ina roƙonka ka zauna. Na gane ta wurin duba cewaUbangiji ya albarkace ni saboda kai.” ");
INSERT INTO hausa_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Ya ƙara da cewa, “Faɗa albashinka, zan kuwa biya shi.” ");
INSERT INTO hausa_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yaƙub ya ce masa, “Ka dai san yadda na yi maka aiki da kuma yadda dabbobinka suka yi yawa a hannuna. ");
INSERT INTO hausa_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Kaɗan da kake da shi kafin zuwata ya ƙaru sosai, kuma Ubangiji ya albarkace ka a duk inda na tafi. Amma yanzu, yaushe zan yi wani abu domin gidana ni ma?” ");
INSERT INTO hausa_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Sai Laban ya yi tambaya, “Me zan ba ka?” Yaƙub ya amsa ya ce, “Kada ka ba ni wani abu. Amma in za ka yi mini abu guda ɗaya, zan ci gaba da kiwon garkunanka, ina kuma lura da su. ");
INSERT INTO hausa_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Bari in ratsa cikin dukan garkunanka yau in fid da masu dabbare-dabbare da tumaki babare-babare, da kowane ɗan rago baƙi, da dabbare-dabbare da babare-babare na awaki daga ciki, waɗannan ne za su zama ladana. ");
INSERT INTO hausa_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Gaskiyata kuwa za tă zama mini shaida nan gaba, duk sa’ad da ka bincika a kan albashin da ka biya ni. Duk akuyar da take tawa da ba dabbare-dabbare ko babare-babare, ko ɗan ragon da ba baƙi ba, zai kasance sata na yi.” ");
INSERT INTO hausa_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Sai Laban ya ce, “Na yarda. Bari yă zama yadda ka faɗa.” ");
INSERT INTO hausa_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","A wannan rana ya ware dukan bunsurai da suke dabbare-dabbare da masu zāne-zāne, da dukan awakin da suke dabbare-dabbare (duka da suke da fari-fari a jikinsu), da dukan baƙaƙen tumaki, ya sa su a hannun ’ya’yansa maza. ");
INSERT INTO hausa_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Sa’an nan ya sa nisan tafiya kwana uku tsakaninsa da Yaƙub, yayinda Yaƙub ya ci gaba da lura da sauran garkunan Laban Yaƙub. ");
INSERT INTO hausa_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Yaƙub ya samo ɗanyen reshen itatuwan aduruku, da na katambiri, da na durumi, ya ɓare ya bar fararen cikin katakon rassan. ");
INSERT INTO hausa_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Sa’an nan ya zuba ɓararre rassan cikin dukan kwamame na banruwa saboda su kasance a gaban garkunan sa’ad da suka zo shan ruwa. A sa’ad da garkunan suke barbara suka kuma zo shan ruwa, ");
INSERT INTO hausa_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","sai su yi barbara a gaban rassan. Sai kuwa su haifi ƙanana masu zāne dabbare-dabbare, ko babare-babare ko masu zāne-zāne. ");
INSERT INTO hausa_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Sai Yaƙub yă ware ƙananan garken dabam, amma sai yă sa sauran su fuskanci dabbobin da suke dabbare-dabbare da kuma baƙaƙe da suke na Laban. Ta haka ya ware garkuna dabam domin kansa bai kuwa haɗa su da dabbobin Laban ba. ");
INSERT INTO hausa_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","A duk sa’ad da ƙarfafa dabbobi mata suke barbara, Yaƙub yakan zuba rassan a kwamame a gaban dabbobin saboda su yi barbara kusa da rassan, ");
INSERT INTO hausa_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","amma in dabbobin raunana ne, ba ya sa su a can. Saboda haka raunanan dabbobi suka zama na Laban, ƙarfafan kuma suka zama na Yaƙub. ");
INSERT INTO hausa_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Ta haka mutumin ya zama riƙaƙƙe mai arziki, ya kasance mai manya-manyan garkuna, da bayi mata da maza, da raƙuma da kuma jakuna. ");
INSERT INTO hausa_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Yaƙub ya ji cewa ’ya’ya Laban mazan suna cewa, “Yaƙub ya kwashe dukan abin da mahaifinmu yake da shi, ya kuma sami dukan wannan arziki daga abin da yake na mahaifinmu.” ");
INSERT INTO hausa_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Yaƙub kuma ya lura cewa halin Laban gare shi ya canja ba kamar yadda yake a dā ba. ");
INSERT INTO hausa_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Sai Ubangiji ya ce wa Yaƙub, “Koma ƙasar kakanninka da kuma danginka, zan kuwa kasance tare da kai.” ");
INSERT INTO hausa_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Saboda haka Yaƙub ya aika a ce wa Rahila da Liyatu su zo jeji inda garkunan suke. ");
INSERT INTO hausa_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Sai ya ce musu, “Na ga cewa halin mahaifinku gare ni ba kamar yadda dā yake ba, amma Allah na mahaifina yana tare da ni. ");
INSERT INTO hausa_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Kun san cewa na yi aiki wa mahaifinku da dukan ƙarfina, ");
INSERT INTO hausa_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","duk da haka mahaifinku ya cuce ni ta wurin sauya albashina sau goma. Amma dai, Allah bai yardar masa yă yi mini lahani ba. ");
INSERT INTO hausa_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","In ya ce, ‘Dabbare-dabbare ne za su zama ladanka,’ sai dukan garkunan su haifi dabbare-dabbare, in kuma ya ce, ‘Masu zāne-zāne ne za su zama ladanka,’ sai dukan garkunan su haifi ƙananan masu zāne-zāne. ");
INSERT INTO hausa_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Ta haka Allah ya kwashe dabbobin mahaifinku ya ba ni. ");
INSERT INTO hausa_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“A lokacin ɗaukar cikin garken, na taɓa yin mafarki inda na ga bunsuran da suke barbara da garken, masu dabbare-dabbare, ko babare-babare, ko masu zāne-zāne ne. ");
INSERT INTO hausa_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Sai mala’ikan Allah ya ce mini a mafarkin, ‘Yaƙub.’ Sai na amsa na ce, ‘Ga ni.’ ");
INSERT INTO hausa_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Ya ce, ‘Ɗaga idanunka ka gani, dukan bunsuran da suke hawan garken, masu dabbare-dabbare, ko babare-babare, ko masu zāne-zāne ne, gama na ga dukan abin da Laban yake yin maka. ");
INSERT INTO hausa_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ni ne Allah na Betel, inda ka zuba wa al’amudi mai, da kuma inda ka yi mini alkawari. Yanzu ka bar wannan ƙasa nan take, ka koma ƙasarka ta ainihi.’ ” ");
INSERT INTO hausa_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Sai Rahila da Liyatu suka amsa suka ce, “Muna da wani rabo a gādon kayan mahaifinmu ne? ");
INSERT INTO hausa_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Ba kamar baƙi ne yake ɗaukarmu ba? Ba sayar da mu kaɗai ya yi ba, har ma ya yi amfani da abin da aka biya saboda mu. ");
INSERT INTO hausa_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Tabbatacce dukan dukiyar da Allah ya kwashe daga mahaifinmu ya zama namu da ’ya’yanmu. Saboda haka ka yi duk abin da Allah ya faɗa maka.” ");
INSERT INTO hausa_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Sa’an nan Yaƙub ya sa ’ya’yansa da matansa a kan raƙuma, ");
INSERT INTO hausa_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","ya kuma kora dukan dabbobinsa, suka ja gabansa, tare da dukan abubuwan da ya samu a Faddan Aram, don su tafi wurin mahaifinsa Ishaku a ƙasar Kan’ana. ");
INSERT INTO hausa_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Sa’ad da Laban ya tafi don askin tumakinsa, sai Rahila ta sace gumakan gidan mahaifinta. ");
INSERT INTO hausa_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Yaƙub kuwa ya ruɗe Laban mutumin Aram da bai sanar da shi zai gudu ba. ");
INSERT INTO hausa_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Saboda haka ya gudu da dukan abin da ya mallaka, ya ƙetare Kogi, ya nufi yankin tuddan Gileyad. ");
INSERT INTO hausa_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","A rana ta uku, sai aka faɗa wa Laban cewa Yaƙub ya gudu. ");
INSERT INTO hausa_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Sai Laban ya ɗauki danginsa tare da shi, ya bi bayan Yaƙub har kwana bakwai, ya kuma same shi a yankin tuddan Gileyad. ");
INSERT INTO hausa_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Sai Allah ya bayyana ga Laban mutumin Aram a mafarki da dare, ya ce masa, “Ka yi hankali kada ka faɗa wa Yaƙub wani abu, ko mai kyau ko marar kyau.” ");
INSERT INTO hausa_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Yaƙub ya riga ya kafa tentinsa a yankin tuddan Gileyad sa’ad da Laban ya same shi. Laban da danginsa suka kafa sansani a can su ma. ");
INSERT INTO hausa_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Sai Laban ya ce wa Yaƙub, “Me ke nan ka yi? Ka ruɗe ni, ka kuma ɗauki ’ya’yana mata kamar kamammun yaƙi. ");
INSERT INTO hausa_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Me ya sa ka gudu a ɓoye ka kuma ruɗe ni? Me ya sa ba ka faɗa mini don in sallame ka da farin ciki da waƙoƙi haɗe da kiɗin ganguna da garayu ba? ");
INSERT INTO hausa_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Ba ka ma bari in sumbaci jikokina da ’ya’yana mata in yi musu bankwana ba. Ka yi wauta. ");
INSERT INTO hausa_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Ina da iko in cuce ka; amma jiya da dare Allahn mahaifinka ya faɗa mini, ‘Ka yi hankali kada ka faɗa wa Yaƙub wani abu ko mai kyau ko marar kyau.’ ");
INSERT INTO hausa_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Yanzu ka gudu domin kana marmari komawa gidan mahaifinka. Amma don me ka sace mini gumakana?” ");
INSERT INTO hausa_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yaƙub ya amsa wa Laban, “Na ji tsoro ne, domin na yi tsammani za ka ƙwace ’ya’yanka mata daga gare ni ƙarfi da yaji. ");
INSERT INTO hausa_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Amma in ka sami wani wanda yake da gumakanka, ba zai rayu ba. Kai da kanka ka duba a gaban danginmu, ko akwai wani abin da yake naka a nan tare da ni; in ka gani, ka ɗauka.” Yaƙub dai bai san cewa Rahila ta sace gumakan ba. ");
INSERT INTO hausa_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Saboda haka Laban ya shiga tentin Yaƙub, ya shiga tentin Liyatu da kuma tentuna matan nan biyu bayi, amma bai sami kome ba. Bayan ya fita daga tentin Liyatu, sai ya shiga tentin Rahila. ");
INSERT INTO hausa_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Rahila fa ta kwashe gumakan gidan ta sa su cikin sirdin raƙumi, ta kuma zauna a kansu. Laban ya bincika cikin kowane abu a tentin amma bai sami kome ba. ");
INSERT INTO hausa_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Sai Rahila ta ce wa mahaifinta, “Kada ka yi fushi, ranka yă daɗe da ban tashi tsaye a gabanka ba; gama ina al’adar mata ne.” Saboda haka ya bincika amma bai sami gumakan gidan ba. ");
INSERT INTO hausa_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Yaƙub ya fusata, ya kuma yi wa Laban faɗa. Ya tambayi Laban, “Mene ne laifina? Wanda zunubi na yi da kake farautata? ");
INSERT INTO hausa_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Yanzu da ka bincika dukan kayayyakina, me ka samu da yake na gidanka? Kawo shi nan a gaban danginka da kuma dangina, bari su zama alƙali tsakaninmu biyu. ");
INSERT INTO hausa_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“Na kasance tare da kai shekaru ashirin. Tumakinka da awakinka ba su yi ɓarin ciki ba, ban kuwa ci raguna daga garkunanka ba. ");
INSERT INTO hausa_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Ban kawo dabbobinka da namun jeji suka yayyaga; na kuma ɗauki hasarar ba? Ka nemi in biya dukan abin da aka sace da rana ko da dare. ");
INSERT INTO hausa_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Yanayin da na kasance ke nan, da rana na sha zafin rana da dare kuma na sha sanyi, ga rashin barci. ");
INSERT INTO hausa_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Haka ya kasance shekaru ashirin da na yi a gidanka. Na yi maka aiki shekaru goma sha huɗu domin ’ya’yanka mata biyu, na kuma yi shekaru shida domin garkunanka, ka kuma canja albashina sau goma. ");
INSERT INTO hausa_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Da ba don Allah na mahaifina, Allah na Ibrahim da kuma Tsoron Ishaku ya kasance tare da ni ba, tabbatacce da ka sallame ni hannu wofi. Amma Allah ya ga wahalata da famar hannuwana, ya kuwa tsawata maka da dare jiya.” ");
INSERT INTO hausa_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Laban ya amsa wa Yaƙub, “Matan, ’ya’yana ne, ’ya’yansu, ’ya’yana ne, garkunan kuma garkunana ne. Dukan abin da kake gani, nawa ne. Duk da haka me zan yi a rana ta yau ga waɗannan ’ya’yana mata, ko kuma ga ’ya’yan da suka haifa? ");
INSERT INTO hausa_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Zo, bari mu ƙulla yarjejjeniya, da kai da ni, bari kuma ta kasance shaida a tsakaninmu.” ");
INSERT INTO hausa_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Saboda haka Yaƙub ya ɗauki dutse ya kafa yă zama al’amudi. ");
INSERT INTO hausa_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Ya ce wa danginsa. “Ku tattara waɗansu duwatsu.” Sai suka kwashe duwatsu suka tsiba, suka kuwa ci abinci a can kusa da tsibin. ");
INSERT INTO hausa_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laban ya sa masa suna Yegar Sahaduta, Yaƙub kuwa ya kira shi Galeyed. ");
INSERT INTO hausa_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Laban ya ce, “Wannan tsibi, shi ne shaida tsakaninka da ni a yau.” Shi ya sa aka kira shi Galeyed. ");
INSERT INTO hausa_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Aka kuma kira shi Mizfa, domin ya ce, “Ubangiji yă sa ido tsakanin ni da kai sa’ad da muka rabu da juna. ");
INSERT INTO hausa_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Laban ya ce in ka wulaƙanta ’ya’yana mata, ko ka auri waɗansu mata ban da ’ya’yana mata, ko da yake babu wani da yake tare da mu, ka tuna cewa Allah shi ne shaida tsakaninka da ni.” ");
INSERT INTO hausa_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Laban ya kuma ce wa Yaƙub, “Ga wannan tsibi, ga kuma wannan al’amudin da na kafa tsakaninka da ni. ");
INSERT INTO hausa_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Wannan tsibin shi ne shaida, wannan al’amudi kuma shaida ne, cewa ba zan tsallake wannan tsibi zuwa gefenka don in cuce ka ba, kai kuma ba za ka tsallake wannan tsibi da al’amudi zuwa gefena don ka cuce ni ba. ");
INSERT INTO hausa_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Bari Allah na Ibrahim da Allah na Nahor, Allah na iyayensu, yă zama alƙali tsakaninmu.” Saboda haka Yaƙub ya yi rantsuwa da sunan Tsoron mahaifinsa Ishaku. ");
INSERT INTO hausa_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Ya miƙa hadaya a can a ƙasar tudu, ya kuma gayyaci danginsa zuwa wurin cin abinci. Bayan suka ci, sai suka kwana a can. ");
INSERT INTO hausa_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Da sassafe kashegari sai Laban ya sumbaci jikokinsa da ’ya’yansa mata, ya sa musu albarka. Sa’an nan ya yi bankwana da su, ya koma gida. ");
INSERT INTO hausa_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Yaƙub shi ma ya kama hanyarsa, sai mala’ikun Allah suka sadu da shi. ");
INSERT INTO hausa_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Sa’ad da Yaƙub ya gan su sai ya ce, “Wannan sansanin Allah ne!” Saboda haka ya kira wannan wuri Mahanayim. ");
INSERT INTO hausa_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Sai Yaƙub ya aiki manzanni su sha gabansa zuwa wurin ɗan’uwansa Isuwa a ƙasar Seyir, a ƙauyen Edom. ");
INSERT INTO hausa_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Ya umarce su, “Ga abin da za ku faɗa wa maigidana Isuwa, ‘Bawanka Yaƙub ya ce, na yi zama tare da Laban na kuwa kasance a can sai yanzu. ");
INSERT INTO hausa_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Ina da shanu da jakuna, tumaki da awaki, bayi maza da mata. Yanzu ina aika da wannan saƙo zuwa ga ranka yă daɗe, don in sami tagomashi a idanunka.’ ” ");
INSERT INTO hausa_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Sa’ad da manzannin suka komo wurin Yaƙub, suka ce, “Mun tafi wurin ɗan’uwanka Isuwa, yanzu kuwa yana zuwa ya sadu da kai, da kuma mutum ɗari huɗu tare da shi.” ");
INSERT INTO hausa_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Da tsoro mai yawa da kuma damuwa, Yaƙub ya rarraba mutanen da suke tare da shi ƙungiyoyi biyu, haka ma garkunan tumaki da awaki, da garkunan shanu da raƙuma. ");
INSERT INTO hausa_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Ya yi tunani, “In Isuwa ya zo ya fāɗa wa ƙungiya ɗaya, sai ƙungiya ɗayan da ta ragu ta tsira.” ");
INSERT INTO hausa_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Sa’an nan Yaƙub ya yi addu’a, “Ya Allah na mahaifina Ibrahim, Allah na mahaifina Ishaku. Ya Ubangiji kai da ka ce mini, ‘Koma ƙasarka zuwa wurin danginka, zan kuma sa ka yi albarka.’ ");
INSERT INTO hausa_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Ban cancanci dukan alheri da amincin da ka nuna wa bawanka ba. Da sanda kaɗai nake sa’ad da na ƙetare wannan Urdun, amma ga shi yanzu na zama ƙungiyoyi biyu. ");
INSERT INTO hausa_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Ka cece ni, ina roƙonka daga hannun ɗan’uwana Isuwa, gama ina tsoro zai zo yă fāɗa mini, yă karkashe mu duka, ’ya’ya da iyaye. ");
INSERT INTO hausa_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Amma ka riga ka faɗa, ‘Tabbatacce zan sa ka yi albarka. Zan kuma sa zuriyarka su zama kamar yashin teku da ba a iya ƙirgawa.’ ” ");
INSERT INTO hausa_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Ya kwana a can, daga cikin abin da yake tare da shi kuwa, ya zaɓi kyauta domin ɗan’uwansa Isuwa, ");
INSERT INTO hausa_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","awaki ɗari biyu da bunsurai ashirin, tumaki ɗari biyu da raguna ashirin, ");
INSERT INTO hausa_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","raƙuma mata talatin tare da ƙananansu, shanu arba’in da bijimai goma, jakuna mata ashirin da kuma jakuna maza goma. ");
INSERT INTO hausa_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Ya sa su a ƙarƙashin kulawar bayinsa, kowane kashin garke ya kasance a ware. Ya ce wa bayinsa, “Ku sha gabana, ku kuma ba da rata tsakanin garke da garke.” ");
INSERT INTO hausa_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Ya umarci wanda yake jagorar ya ce, “Sa’ad da ɗan’uwana Isuwa ya sadu da ku ya kuma yi tambaya, ‘Ku na wane ne, ina za ku, kuma wane ne mai dukan dabbobin nan da suke gabanku?’ ");
INSERT INTO hausa_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Sai ku ce, ‘Na bawanka Yaƙub ne. Kyauta ce wa maigidana Isuwa, yana kuma tafe a bayanmu.’ ” ");
INSERT INTO hausa_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Yaƙub ya kuma umarci na biyu da na uku da kuma dukan waɗansu da suka bi garkunan, “Sai ku faɗa irin abu guda ga Isuwa sa’ad da kuka sadu da shi. ");
INSERT INTO hausa_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Ku kuma tabbata kun ce, ‘Bawanka Yaƙub yana tafe a bayanmu.’ ” Gama Yaƙub ya yi tunani cewa, “Zan kwantar da ran Isuwa da waɗannan kyautai, kafin mu sadu fuska da fuska, wataƙila yă karɓe shi.” ");
INSERT INTO hausa_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Saboda haka kyautai Yaƙub suka sha gabansa, amma shi kansa ya kwana a sansani. ");
INSERT INTO hausa_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","A wannan dare Yaƙub ya tashi ya ɗauki matansa biyu, da matan nan biyu masu hidima da ’ya’yansa goma sha ɗaya ya haye rafin Yabbok. ");
INSERT INTO hausa_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Bayan ya sa suka haye rafin, haka ma ya tura dukan mallakarsa zuwa hayen. ");
INSERT INTO hausa_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Saboda haka sai aka bar Yaƙub shi kaɗai. Sai ga wani mutum ya zo ya yi kokawa da shi har wayewar gari. ");
INSERT INTO hausa_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Da mutumin ya ga cewa bai fi ƙarfin Yaƙub ba, sai ya bugi kwarin ƙashin cinyar Yaƙub, sai gaɓar ƙashin cinyarsa ya goce, a sa’ad da yake kokawa da mutumin. ");
INSERT INTO hausa_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Sa’an nan mutumin ya ce, “Bar ni in tafi, gama gari ya waye.” Amma Yaƙub ya amsa ya ce, “Ba zan bar ka ka tafi ba, sai ka sa mini albarka.” ");
INSERT INTO hausa_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Mutumin ya tambaye shi ya ce, “Mene ne sunanka?” Yaƙub ya amsa ya ce, “Yaƙub.” ");
INSERT INTO hausa_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Sai mutumin ya ce, “Sunanka ba zai ƙara zama Yaƙub ba, amma Isra’ila, gama ka yi kokawa da Allah da mutane, ka kuwa yi rinjaye.” ");
INSERT INTO hausa_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Yaƙub ya ce, “Ina roƙonka, faɗa mini sunanka.” Amma mutumin ya amsa ya ce, “Me ya sa kake tambayata sunana?” Sa’an nan ya albarkace shi. ");
INSERT INTO hausa_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Saboda haka Yaƙub ya kira wurin Feniyel, yana cewa, “Domin na ga Allah fuska da fuska, duk da haka aka bar ni da rai.” ");
INSERT INTO hausa_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Rana ta yi sama a sa’ad da ya wuce Fenuwel yana kuma ɗingishi saboda ƙashin cinyarsa. ");
INSERT INTO hausa_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Wannan ya sa har wa yau Isra’ilawa ba sa cin jijiyar ƙashin cinya wadda take a kwarin ƙashin cinya, domin an taɓa kwarin ƙashin cinyar Yaƙub kusa da jijiyar. ");
INSERT INTO hausa_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Yaƙub ya ɗaga ido ke nan, sai ga Isuwa yana zuwa tare da mutanensa ɗari huɗu; saboda haka sai ya rarraba ’ya’yan wa Liyatu, Rahila da kuma matan nan biyu masu hidima. ");
INSERT INTO hausa_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Ya sa matan nan biyu masu hidima da ’ya’yansu a gaba, Liyatu da ’ya’yanta biye, sa’an nan Rahila da Yusuf a baya. ");
INSERT INTO hausa_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Shi kansa ya sha gabansu, ya rusuna har ƙasa sau bakwai, kafin ya kai kusa da inda ɗan’uwansa Isuwa yake. ");
INSERT INTO hausa_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Amma Isuwa ya ruga a guje ya sadu da Yaƙub ya rungume shi; ya faɗa a wuyansa ya sumbace shi. Suka kuma yi kuka. ");
INSERT INTO hausa_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Sa’an nan Isuwa ya ɗaga ido ya ga mata da ’ya’ya. Ya yi tambaya, “Su wane ne waɗannan tare da kai?” Yaƙub ya amsa, “Su ne ’ya’yan da Allah cikin alheri ya ba bawanka.” ");
INSERT INTO hausa_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Sai matan nan biyu masu hidima da ’ya’yansu suka matso kusa suka durƙusa. ");
INSERT INTO hausa_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Biye da su, Liyatu da ’ya’yanta suka zo suka rusuna. A ƙarshe duka, sai Yusuf da Rahila suka zo, su ma suka rusuna. ");
INSERT INTO hausa_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Isuwa ya yi tambaya, “Me kake nufi da dukan abubuwan nan da na sadu da su ana korarsu?” Sai Yaƙub ya ce, “Don in sami tagomashi a idanunka ne, ranka yă daɗe.” ");
INSERT INTO hausa_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Amma Isuwa ya ce, “Na riga na sami abin da ya ishe ni, ɗan’uwana. Riƙe abin da kake da shi don kanka.” ");
INSERT INTO hausa_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Sai Yaƙub ya ce, “A’a, ina roƙonka, in na sami tagomashi a idanunka, sai ka karɓi wannan kyautai daga gare ni. Gama ganin fuskarka kamar ganin fuskar Allah ne, yanzu da ka karɓe ni da farin ciki. ");
INSERT INTO hausa_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Ina roƙonka ka karɓi kyautar da aka kawo maka, gama Allah ya yi mini alheri kuma ina da kome da nake bukata.” Ganin yadda Yaƙub ya nace, sai Isuwa ya karɓa. ");
INSERT INTO hausa_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Sa’an nan Isuwa ya ce, “Bari mu tafi, zan yi maka rakiya.” ");
INSERT INTO hausa_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Amma Yaƙub ya ce masa, “Ranka yă daɗe, ka san cewa ’ya’yan ƙanana ne, dole in lura da tumaki da shanun da suke shayar da jariransu. In aka kore su da gaggawa a rana guda kaɗai, dukan dabbobin za su mutu. ");
INSERT INTO hausa_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Saboda haka bari ranka yă daɗe yă sha gaban bawansa, ni kuma in tafi a hankali bisa ga saurin abin da ake kora a gabana da kuma saurin ’ya’yan, sai na iso wurinka ranka yă daɗe, a Seyir.” ");
INSERT INTO hausa_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Sai Isuwa ya ce, “To, bari in bar waɗansu mutanena tare da kai.” Yaƙub ya ce, “Amma me ya sa za ka yi haka? Bari dai in sami tagomashi a idanunka ranka yă daɗe.” ");
INSERT INTO hausa_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Saboda haka a wannan rana Isuwa ya kama hanyar komawa zuwa Seyir. ");
INSERT INTO hausa_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Yaƙub kuwa, ya tafi Sukkot, inda ya gina wuri domin kansa, ya kuma yi bukkoki domin dabbobinsa. Shi ya sa aka kira wurin Sukkot. ");
INSERT INTO hausa_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Bayan Yaƙub ya zo daga Faddan Aram, ya iso lafiya a birnin Shekem a Kan’ana, ya kuma kafa sansani a ƙofar birni. ");
INSERT INTO hausa_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Ya sayi fili daga ’ya’yan Hamor maza, mahaifin Shekem inda ya kafa tentinsa, a bakin azurfa ɗari. ");
INSERT INTO hausa_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","A can ya kafa bagade ya kuma kira shi El Elohe Isra’ila. ");
INSERT INTO hausa_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","To, Dina, ’yar da Liyatu ta haifa wa Yaƙub, ta je ta ziyarci matan ƙasar. ");
INSERT INTO hausa_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Sa’ad da Shekem ɗan Hamor Bahiwiye mai mulkin wurin ya gan ta, sai ya kama ta, ya kwana da ita, ya ɓata ta. ");
INSERT INTO hausa_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Zuciyarsa kuwa ta damu da son Dina ’yar Yaƙub, ya kuwa ƙaunaci yarinyar, ya yi mata magana a hankali. ");
INSERT INTO hausa_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Sai Shekem ya ce wa mahaifinsa Hamor, “Ka auro mini wannan yarinya ta zama matata.” ");
INSERT INTO hausa_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Sa’ad da Yaƙub ya ji cewa an ɓata ’yarsa Dina, sai ya yi shiru game da batun sai ’ya’yansa maza sun dawo gida, gama ’ya’yansa suna a jeji tare da dabbobinsa suna kiwo. ");
INSERT INTO hausa_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Sai Hamor mahaifin Shekem ya je don yă yi magana da Yaƙub. ");
INSERT INTO hausa_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Da ’ya’yan Yaƙub maza suka dawo daga jeji sai suka ji labarin. Abin kuwa ya zafe su ƙwarai, don Shekem ya jawo abin kunya wa jama’ar Isra’ila ta wurin kwana da ’yar Yaƙub, don bai kamata wannan abu yă faru ba. ");
INSERT INTO hausa_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Amma Hamor ya ce musu, “Ɗana Shekem ya sa zuciyarsa a kan ’yarku. Ina roƙonku ku ba shi ita yă aura. ");
INSERT INTO hausa_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Ku yi auratayya da mu; ku aurar mana da ’ya’yanku mata, ku kuma ku auro ’ya’yanmu mata wa kanku. ");
INSERT INTO hausa_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Za ku iya zauna a cikinmu, ƙasar tana nan a buɗe dominku. Ku yi zama a cikinta, ku yi sana’a, ku kuma sami dukiya.” ");
INSERT INTO hausa_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Sai Shekem ya ce wa mahaifin Dina da kuma ’yan’uwanta. “Bari in sami tagomashi a idanunku, zan kuwa ba ku duk abin da kuka tambaya. ");
INSERT INTO hausa_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Ku faɗa mini nawa ne dukiyar aure da kuma sadakin da zan kawo bisa ga yadda kuke so, zan kuwa biya duk abin da kuka ce. Ku dai bar ni in aure yarinyar ta zama matata.” ");
INSERT INTO hausa_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Domin an ɓata ’yar’uwansu Dina, sai ’ya’yan Yaƙub maza suka amsa a ha’ince yayinda suke wa Shekem da mahaifinsa Hamor magana. ");
INSERT INTO hausa_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Suka ce musu, “Ba za mu iya yin wannan abu ba, ba za mu iya ba da ’yar’uwarmu ga mutumin da ba shi da kaciya ba. Wannan zai zama abin kunya ne a gare mu. ");
INSERT INTO hausa_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Za mu yarda da wannan kaɗai ta wannan sharaɗi, cewa za ku zama kamar mu ta wurin yin wa dukan ’ya’yanku maza kaciya. ");
INSERT INTO hausa_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Sa’an nan za mu ba da ’ya’yanmu mata aure gare ku, mu kuma mu aure ’ya’yanku mata wa kanmu. Za mu zauna a cikinku mu kuma zama mutane ɗaya da ku. ");
INSERT INTO hausa_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Amma in ba za ku yarda a yi muku kaciya ba, za mu ɗauki ’yar’uwanmu mu tafi.” ");
INSERT INTO hausa_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Sharuɗansu sun gamshi Hamor da ɗansa, Shekem. ");
INSERT INTO hausa_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Saurayin wanda aka fi girmamawa a cikin dukan gidan mahaifinsa, bai ɓata lokaci a yin abin da suka ce ba, domin ya ji daɗin ’yar Yaƙub. ");
INSERT INTO hausa_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Saboda haka Hamor da ɗansa Shekem suka tafi ƙofar birninsu don su yi magana da mutanen garinsu. ");
INSERT INTO hausa_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Suka ce, “Waɗannan mutane ba su da damuwa, bari su zauna a cikin ƙasarmu, su kuma yi sana’a a ciki; ƙasar tana da isashen fili dominsu. Za mu iya auro ’ya’yansu mata, su kuma su auri namu. ");
INSERT INTO hausa_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Amma mutanen za su yarda su zauna tare da mu kamar mutane ɗaya kawai bisa wannan sharaɗi, cewa a yi wa mazanmu kaciya, kamar yadda su kansu suke. ");
INSERT INTO hausa_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Ashe, shanunsu, dukiyarsu da dukan sauran dabbobinsu, ba za su zama namu ba? Saboda haka mu yarda, za su kuwa zauna a cikinmu.” ");
INSERT INTO hausa_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Dukan mazan da suka fito ƙofar birnin suka yarda da Hamor da kuma ɗansa Shekem, aka kuwa yi wa kowane namiji a birnin kaciya. ");
INSERT INTO hausa_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Bayan kwana uku, yayinda dukansu suna cikin zafi mikin kaciya, sai biyu daga cikin ’ya’yan Yaƙub maza, Simeyon da Lawi, ’yan’uwan Dina, suka ɗauki takubansu suka fāɗa wa birnin ba labari, suka kashe kowane namiji. ");
INSERT INTO hausa_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Suka kashe Hamor da ɗansa Shekem da takobi, suka ɗauko Dina daga gidan Shekem suka tafi. ");
INSERT INTO hausa_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Sa’an nan ’ya’yan Yaƙub maza suka bi kan gawawwakin, suka washe arzikin birni saboda an ɓata ’yar’uwarsu. ");
INSERT INTO hausa_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Suka kwashe garkunansu na shanu da jakuna, da kuma kome na mutanen a birnin da kuma cikin gonaki. ");
INSERT INTO hausa_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Suka kwashe dukan dukiyarsu da dukan matansu da ’ya’yansu, suka kwashe kome da yake cikin gidaje. ");
INSERT INTO hausa_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Sai Yaƙub ya ce wa Simeyon da Lawi, “Kun jawo mini wahala ta wurin sa in zama abin ƙi ga Kan’aniyawa da Ferizziyawa, mazaunan wannan ƙasa. Mu kima ne, in kuwa suka haɗa kai gāba da ni, suka fāɗa mini, za su hallaka ni da gidana.” ");
INSERT INTO hausa_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Amma ’ya’yansa suka amsa, “To, ya dace ke nan da ya yi da ’yar’uwarmu kamar karuwa?” ");
INSERT INTO hausa_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Sa’an nan Allah ya ce wa Yaƙub, “Haura zuwa Betel ka yi zama a can, ka kuma gina bagade a can wa Allah wanda ya bayyana gare ka sa’ad da kake gudu daga ɗan’uwanka Isuwa.” ");
INSERT INTO hausa_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Saboda haka Yaƙub ya ce wa gidansa da kuma dukan waɗanda suke tare da shi, “Ku zubar da baƙin allolin da kuke da su, ku tsarkake kanku, ku kuma canja tufafinku. ");
INSERT INTO hausa_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Sa’an nan ku zo, mu haura zuwa Betel, inda zan gina bagade wa Allah wanda ya amsa mini a ranar wahalata, wanda kuma ya kasance tare da ni a dukan inda na tafi.” ");
INSERT INTO hausa_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Saboda haka suka ba Yaƙub dukan baƙin allolin da suke da su, da zoban da suke kunnuwansu, sai Yaƙub ya binne su a ƙarƙashin itacen oak a Shekem. ");
INSERT INTO hausa_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Sa’an nan suka kama hanya, tsoron Allah kuwa ya kama dukan garuruwan da suke kewayensu har babu wanda ya iya bin su. ");
INSERT INTO hausa_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Yaƙub da dukan mutanen da suke tare da shi suka zo Luz (wato, Betel) a ƙasar Kan’ana. ");
INSERT INTO hausa_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","A can ya gina bagade, ya kuma kira wurin El Betel, gama a can ne Allah ya bayyana kansa gare shi sa’ad da yake gudu daga ɗan’uwansa. ");
INSERT INTO hausa_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","To, Debora, ungozomar Rebeka ta rasu aka kuma binne ta a ƙarƙashin itacen oak, ƙasa da Betel. Saboda haka aka kira wurin Allon Bakut. ");
INSERT INTO hausa_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Bayan Yaƙub ya komo daga Faddan Aram, sai Allah ya bayyana gare shi, ya kuma albarkace shi. ");
INSERT INTO hausa_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Allah ya ce masa, “Sunanka Yaƙub ne, amma ba za a ƙara kira ka Yaƙub ba; sunanka zai zama Isra’ila.” Saboda haka ya ba shi suna Isra’ila. ");
INSERT INTO hausa_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Sai Allah ya ce masa, “Ni ne Allah Maɗaukaki, ka yi ta haihuwa, ka kuma riɓaɓɓanya. Al’umma da tarin al’ummai za su fito daga gare ka, sarakuna kuma za su fito daga jikinka. ");
INSERT INTO hausa_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Ƙasar da na ba wa Ibrahim da Ishaku, zan kuma ba ka, zan kuma ba da wannan ƙasa ga zuriyarka a bayanka.” ");
INSERT INTO hausa_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Sa’an nan Allah ya tashi sama daga gare shi a wurin da ya yi magana da shi. ");
INSERT INTO hausa_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Yaƙub kuwa ya kafa al’amudin dutse a inda Allah ya yi magana da shi, ya zuba hadaya ta sha a kansa; ya kuma zuba mai a kansa. ");
INSERT INTO hausa_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Yaƙub ya kira inda Allah ya yi magana da shi, Betel. ");
INSERT INTO hausa_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Sa’an nan suka tashi daga Betel. Yayinda suna da ɗan nisa da Efrat, sai Rahila ta fara naƙuda ta kuwa sha wahala sosai. ");
INSERT INTO hausa_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Sa’ad da take cikin zafin haihuwa, sai macen da ta karɓi haihuwar ta ce mata, “Kada ki ji tsoro, gama yanzu kin sami wani ɗa.” ");
INSERT INTO hausa_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Yayinda take jan numfashinta na ƙarshe, sai ta ba wa ɗanta suna Ben-Oni. Amma mahaifinsa ya kira shi Benyamin. ");
INSERT INTO hausa_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Ta haka Rahila ta rasu, aka kuma binne ta a hanya zuwa Efrata (wato, Betlehem). ");
INSERT INTO hausa_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Yaƙub ya kafa al’amudi bisa kabarinta, al’amudin kabarin Rahila ke nan, wanda yake can har wa yau. ");
INSERT INTO hausa_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Isra’ila ya yi gaba, ya kafa tentinsa gaba da Migdal Eder. ");
INSERT INTO hausa_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Yayinda Isra’ila yana zama a wancan yanki, Ruben ya shiga ya kwana da Bilha ƙwarƙwarar mahaifinsa, Isra’ila kuwa ya ji labari. Yaƙub ya haifi ’ya’ya maza goma sha biyu. ");
INSERT INTO hausa_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","’Ya’yan Liyatu maza, Ruben shi ne ɗan fari na Yaƙub. Sauran su ne, Simeyon, Lawi, Yahuda, Issakar da Zebulun. ");
INSERT INTO hausa_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","’Ya’yan Rahila maza su ne, Yusuf da Benyamin. ");
INSERT INTO hausa_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","’Ya’yan Bilha maza, mai hidimar Rahila su ne, Dan da Naftali. ");
INSERT INTO hausa_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","’Ya’yan Zilfa maza, mai hidimar Liyatu su ne, Gad da Asher. Waɗannan su ne ’ya’yan Yaƙub maza, waɗanda aka haifa masa a Faddan Aram. ");
INSERT INTO hausa_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Yaƙub ya dawo gida wurin mahaifinsa Ishaku a Mamre, kusa da Kiriyat Arba (wato, Hebron), inda Ibrahim da Ishaku suka zauna. ");
INSERT INTO hausa_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Ishaku ya rayu shekaru ɗari da tamanin, ");
INSERT INTO hausa_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","sa’an nan ya ja numfashinsa na ƙarshe, ya kuwa mutu, aka kuma tara shi ga mutanensa da kyakkyawan tsufa da kuma cikakken shekaru. ’Ya’yansa maza, Isuwa da Yaƙub suka binne shi. ");
INSERT INTO hausa_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Waɗannan su ne zuriyar Isuwa (wato, Edom). ");
INSERT INTO hausa_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Isuwa ya ɗauko matansa daga cikin matan Kan’ana, ya ɗauko Ada ’yar Elon mutumin Hitti, da Oholibama ’yar Ana wadda take jikanyar Zibeyon Bahiwiye ");
INSERT INTO hausa_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","ya kuma auri Basemat ’yar Ishmayel wadda take ’yar’uwar Nebayiwot. ");
INSERT INTO hausa_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada ta haifi wa Isuwa, Elifaz. Basemat kuma ta haifa masa Reyuwel. ");
INSERT INTO hausa_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholibama kuwa ta haifa masa Yewush, Yalam da Kora. Waɗannan su ne ’ya’yan Isuwa maza, waɗanda aka haifa masa a Kan’ana. ");
INSERT INTO hausa_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Isuwa ya ɗauki matansa da ’ya’yansa maza da mata da kuma dukan membobin gidansa, ya kuma ɗauki shanunsa da dukan sauran dabbobinsa, da dukan dukiyarsa da ya samu a ƙasar Kan’ana zuwa wata ƙasa nesa da ɗan’uwansa Yaƙub. ");
INSERT INTO hausa_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Mallakarsu ta yi yawa ƙwarai da ba za su iya zauna tare ba; gama ƙasar da suke zaune a ciki ba za tă ishe su su biyu ba saboda dabbobinsu. ");
INSERT INTO hausa_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Saboda haka Isuwa (wato, Edom) ya zauna a ƙasar tuddai na Seyir. ");
INSERT INTO hausa_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Wannan shi ne zuriyar Isuwa, kakan mutanen Edom, a ƙasar tuddai na Seyir. ");
INSERT INTO hausa_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Waɗannan su ne sunayen ’ya’yan Isuwa maza, Elifaz, ɗan Ada matar Isuwa, da Reyuwel ɗan Basemat matar Isuwa. ");
INSERT INTO hausa_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","’Ya’yan Elifaz maza su ne, Teman, Omar, Zefo, Gatam da Kenaz. ");
INSERT INTO hausa_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Elifaz ɗan Isuwa kuma yana da ƙwarƙwara mai suna Timna, wadda ta haifa masa Amalek. Waɗannan su ne jikokin Ada matar Isuwa. ");
INSERT INTO hausa_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","’Ya’yan Reyuwel maza su ne, Nahat, Zera, Shamma da Mizza. Waɗannan su ne jikokin Basemat matar Isuwa. ");
INSERT INTO hausa_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","’Ya’yan Oholibama maza ’yar Ana wadda take jikanyar Zibeyon, matar Isuwa, waɗanda ta haifa wa Isuwa su ne, Yewush, Yalam da Kora. ");
INSERT INTO hausa_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Waɗannan su ne manya a cikin zuriyar Isuwa, ’Ya’ya Elifaz maza ɗan farin Isuwa, Shugabannin su ne; Teman, Omar, Zefo, Kenaz, ");
INSERT INTO hausa_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Kora, Gatam da kuma Amalek. Waɗannan ne manya da suka fito daga dangin Elifaz a Edom; su ne jikokin Ada. ");
INSERT INTO hausa_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","’Ya’yan Reyuwel maza, Shugabannin su ne; Nahat, Zera, Shamma da Mizza. Waɗannan su ne manya da suka fito daga dangin Reyuwel a Edom; su ne jikokin Basemat matar Isuwa. ");
INSERT INTO hausa_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","’Ya’yan Oholibama maza matar Isuwa, Shugabannin su ne; Yewush, Yalam da Kora. Waɗannan su ne manya da suka fito daga dangin Oholibama ’yar Ana matar Isuwa. ");
INSERT INTO hausa_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Waɗannan su ne ’ya’yan Isuwa maza (wato, Edom), waɗannan ne manyansu. ");
INSERT INTO hausa_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Waɗannan su ne ’ya’yan Seyir Bahore maza, waɗanda suke zaune a yankin, Lotan, Shobal, Zibeyon, Ana, ");
INSERT INTO hausa_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dishon, Ezer da Dishan. Waɗannan su ne manyan Horiyawa, ’ya’yan Seyir, maza, a ƙasar Edom. ");
INSERT INTO hausa_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","’Ya’yan Lotan maza su ne, Hori da Homam. Timna ’yar’uwar Lotan ce. ");
INSERT INTO hausa_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","’Ya’yan Shobal maza su ne, Alwan, Manahat, Ebal, Shefo da Onam. ");
INSERT INTO hausa_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","’Ya’yan Zibeyon maza su ne, Aiya da Ana. Wannan shi ne Ana wanda ya sami maɓulɓulan ruwan zafi a hamada yayinda yake kiwon jakuna na mahaifinsa Zibeyon. ");
INSERT INTO hausa_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","’Ya’yan Ana su ne, Dishon da Oholibama ’yar Ana. ");
INSERT INTO hausa_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","’Ya’yan Dishon maza su ne, Hemdan, Eshban, Itran da Keran. ");
INSERT INTO hausa_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","’Ya’yan Ezer maza su ne, Bilhan, Za’aban da Akan. ");
INSERT INTO hausa_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","’Ya’yan Dishan maza su ne, Uz da Aran. ");
INSERT INTO hausa_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Waɗannan su ne manyan Horiyawa, Lotan, Shobal, Zibeyon, Ana, ");
INSERT INTO hausa_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Dishon, Ezer da Dishan. Waɗannan su ne manyan Horiyawa, bisa ga ɓangarorinsu, a ƙasar Seyir. ");
INSERT INTO hausa_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Waɗannan su ne sarakunan da suka yi mulki a Edom kafin wani sarki mutumin Isra’ila yă yi mulki, ");
INSERT INTO hausa_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela ɗan Beyor ya zama sarkin Edom. Sunan birninsa shi ne Dinhaba. ");
INSERT INTO hausa_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Sa’ad da Bela ya rasu, Yobab ɗan Zera daga Bozra ya gāje shi. ");
INSERT INTO hausa_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Sa’ad da Yobab ya rasu, Husham daga ƙasar Temaniyawa ya gāje shi. ");
INSERT INTO hausa_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Sa’ad da Husham ya rasu, Hadad ɗan Bedad, wanda ya ci Midiyan da yaƙi a ƙasar Mowab, ya gāje shi. Sunan birninsa shi ne Awit. ");
INSERT INTO hausa_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Sa’ad da Hadad ya rasu, Samla daga Masreka ya gāje shi. ");
INSERT INTO hausa_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Sa’ad da Samla ya rasu, Sha’ul daga Rehobot na ta kogi ya gāje shi. ");
INSERT INTO hausa_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Sa’ad da Sha’ul ya rasu, Ba’al-Hanan ɗan Akbor ya gāje shi. ");
INSERT INTO hausa_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Sa’ad da Ba’al-Hanan ɗan Akbor ya rasu, Hadad ya gāje shi. Sunan birninsa shi ne Fau, kuma sunan matarsa Mehetabel ce ’yar Matired, jikanyar Me-Zahab. ");
INSERT INTO hausa_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Waɗannan su ne manya da suka fito daga zuriyar Isuwa, bisa ga danginsu, bisa kuma ga kabilansu da yankunansu. Sunayensu su ne, Timna, Alwa, Yetet. ");
INSERT INTO hausa_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oholibama, Ela, Finon. ");
INSERT INTO hausa_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenaz, Teman, Mibzar. ");
INSERT INTO hausa_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magdiyel da Iram. Waɗannan su ne manyan Edom bisa ga mazauninsu cikin ƙasar da suka zauna. Wannan shi ne zuriyar Isuwa, kakan mutanen Edom. ");
INSERT INTO hausa_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yaƙub ya zauna a ƙasar da mahaifinsa ya zauna, wato, ƙasar Kan’ana. ");
INSERT INTO hausa_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Wannan shi ne labarin zuriyar Yaƙub. Yusuf, saurayi ne mai shekara goma sha bakwai. Shi da ’yan’uwansa, wato, ’ya’yan Bilha maza da kuma ’ya’yan Zilfa maza, matan mahaifinsa suna kiwon garkuna tare. Sai Yusuf ya kawo wa mahaifinsu rahoto marar kyau game da ’yan’uwansa. ");
INSERT INTO hausa_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Isra’ila dai ya fi ƙaunar Yusuf fiye da kowanne a cikin sauran ’ya’yansa maza, gama an haifa masa shi a cikin tsufansa. Sai ya yi masa riga mai gwanin kyau. ");
INSERT INTO hausa_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Sa’ad da ’yan’uwansa suka ga cewa mahaifinsu ya fi ƙaunarsa fiye da kowanne daga cikinsu, sai suka ƙi jininsa, ba sa kuma maganar alheri da shi. ");
INSERT INTO hausa_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Sai Yusuf ya yi mafarki, sa’ad da ya faɗa wa ’yan’uwansa, suka ƙara ƙin jininsa. ");
INSERT INTO hausa_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Ya ce musu, “Ku saurari wannan mafarkin da na yi. ");
INSERT INTO hausa_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Muna daurin dammunan hatsi a gona, sai nan da nan damina ya tashi ya tsaya, yayinda dammunanku suka taru kewaye da nawa suka rusuna masa.” ");
INSERT INTO hausa_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Sai ’yan’uwansa suka ce masa, “Kana nufin za ka yi mulki a kanmu ke nan? Ko kuwa za ka zama sarki, a bisanmu?” Suka ƙara ƙin jininsa saboda mafarkinsa da kuma abin da ya faɗa. ");
INSERT INTO hausa_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Sai Yusuf ya sāke yin wani mafarki, ya faɗa wa ’yan’uwansa. Ya ce, “Ku saurara, na sāke yin wani mafarki, a wannan lokaci, na ga rana da wata da taurari goma sha ɗaya suna rusuna mini.” ");
INSERT INTO hausa_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Sa’ad da ya faɗa wa mahaifinsa da kuma ’yan’uwansa, sai mahaifinsa ya kwaɓe shi ya ce, “Wanne irin mafarki ne haka da ka yi? Kana nufin ni da mahaifiyarka da ’yan’uwanka za mu zo gabanka mu rusuna maka?” ");
INSERT INTO hausa_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","’Yan’uwansa suka yi kishinsa, amma mahaifinsa ya riƙe batun nan a zuciya. ");
INSERT INTO hausa_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","To, ’yan’uwansa suka tafi kiwon garkunan mahaifinsu kusa da Shekem. ");
INSERT INTO hausa_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Sai Isra’ila ya ce wa Yusuf, “Kamar yadda ka sani, ’yan’uwanka suna kiwon garkuna kusa da Shekem. Zo, in aike ka gare su.” Ya ce, “To.” ");
INSERT INTO hausa_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Saboda haka Isra’ila ya ce wa Yusuf, “Jeka ka ga ko kome lafiya yake da ’yan’uwanka da kuma garkunan, ka kawo mini labari.” Sa’an nan ya sallame shi daga Kwarin Hebron. Sa’ad da Yusuf ya kai Shekem, ");
INSERT INTO hausa_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","sai wani mutum ya same shi yana yawo a cikin jeji, sai mutumin ya tambaye shi ya ce, “Me kake nema?” ");
INSERT INTO hausa_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Yusuf ya amsa ya ce, “Ina neman ’yan’uwana ne. Za ka iya faɗa mini inda suke kiwon garkunansu?” ");
INSERT INTO hausa_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Mutumin ya amsa, “Sun yi gaba daga nan. Na ji su suna cewa, ‘Bari mu je Dotan.’ ” Saboda haka Yusuf ya bi bayan ’yan’uwansa, ya kuwa same su kusa da Dotan. ");
INSERT INTO hausa_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Amma da suka gan shi daga nesa, kafin yă kai wurinsu, sai suka ƙulla su kashe shi. ");
INSERT INTO hausa_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Suka ce wa juna, “Ga mai mafarkin nan can zuwa! ");
INSERT INTO hausa_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Ku zo mu kashe shi mu kuma jefa shi a ɗaya daga cikin rijiyoyin nan, mu ce mugun naman jeji ya cinye shi. Mu ga yadda mafarkinsa zai cika.” ");
INSERT INTO hausa_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Sa’ad da Ruben ya ji wannan, sai ya yi ƙoƙari yă cece shi daga hannuwansu. Ya ce, “Kada mu ɗauki ransa. ");
INSERT INTO hausa_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Kada mu zub da wani jini. Mu dai jefa shi cikin wannan rijiya a nan cikin hamada, amma kada mu sa hannu a kansa.” Ruben ya faɗa wannan ne don yă cece shi daga gare su, yă kuma mai da shi ga mahaifinsa. ");
INSERT INTO hausa_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Saboda haka sa’ad da Yusuf ya zo wurin ’yan’uwansa, sai suka tuɓe masa rigarsa, rigan nan mai gwanin kyau da ya sa, ");
INSERT INTO hausa_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","suka kuma ɗauke shi suka jefa a cikin rijiya. To, rijiyar wofi ce, babu ruwa a ciki. ");
INSERT INTO hausa_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Da suka zauna don cin abinci, sai suka tā da idanu, suka ga ayarin mutanen Ishmayel suna zuwa daga Gileyad. An yi wa raƙumansu labtu da kayan yaji da na ƙanshi, suna kan hanyarsu za su Masar. ");
INSERT INTO hausa_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Yahuda ya ce wa ’yan’uwansa, “Me zai amfane mu in muka kashe ɗan’uwanmu muka ɓoye jininsa? ");
INSERT INTO hausa_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Ku zo, mu sayar da shi wa mutanen Ishmayelawan nan, kada mu sa hannuwanmu a kansa; ban da haka ma, shi ɗan’uwanmu ne, jiki da jininmu.” Sai ’yan’uwansa suka yarda. ");
INSERT INTO hausa_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Saboda haka sa’ad da Fataken Midiyawa suka iso, sai ’yan’uwansa suka ja Yusuf daga rijiyar, suka sayar da shi a bakin shekel ashirin na azurfa wa mutanen Ishmayel, waɗanda suka ɗauke shi zuwa Masar. ");
INSERT INTO hausa_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Sa’ad da Ruben ya dawo wurin rijiyar, sai ya tarar cewa Yusuf ba ya can, sai ya kyakkece tufafinsa. ");
INSERT INTO hausa_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Ya koma wurin ’yan’uwansa ya ce, “Yaron ba ya can! Ina zan bi yanzu?” ");
INSERT INTO hausa_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Sai suka ɗauki rigar Yusuf, suka yanka akuya suka tsoma rigar a cikin jinin. ");
INSERT INTO hausa_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Suka ɗauki rigan nan mai gwanin kyau, suka kawo wa mahaifinsu suka ce, “Mun sami wannan. Ka bincika shi ka gani ko rigar ɗanka ne.” ");
INSERT INTO hausa_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Ya gane shi, sai ya ce, “Rigar ɗana ne! Waɗansu mugayen namun jeji sun cinye shi. Tabbatacce an yayyaga Yusuf.” ");
INSERT INTO hausa_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Sa’an nan Yaƙub ya kyakkece tufafinsa, ya sa tufafin makoki, ya kuma yi makoki domin ɗansa kwanaki masu yawa. ");
INSERT INTO hausa_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Dukan ’ya’yansa maza da mata, suka zo don su ta’azantar da shi, amma ya ƙi yă ta’azantu. Ya ce, “A’a, cikin makoki zan gangara zuwa kabari wurin ɗana.” Saboda haka, mahaifin Yusuf ya yi kuka saboda shi. ");
INSERT INTO hausa_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Ana cikin haka, Midiyawa suka sayar da Yusuf a Masar wa Fotifar, ɗaya daga cikin shugabannin ’yan gadin fadar Fir’auna. ");
INSERT INTO hausa_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","A wannan lokaci, Yahuda ya bar ’yan’uwansa ya gangara don yă zauna da mutumin Adullam, mai suna Hira. ");
INSERT INTO hausa_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","A can Yahuda ya sadu da ’yar wani Bakan’ane, mai suna Shuwa. Ya aure ta, ya kuma kwana da ita; ");
INSERT INTO hausa_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","ta yi ciki, ta kuma haifi ɗa, wanda aka kira Er. ");
INSERT INTO hausa_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Ta sāke yin ciki, ta haifi wani ɗa, ta kira shi Onan. ");
INSERT INTO hausa_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Ta kuma haifi wani ɗa har yanzu, aka kuwa ba shi suna Shela. A Kezib ne ta haife shi. ");
INSERT INTO hausa_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Sai Yahuda ya auro wa Er mata, ɗansa na fari, sunanta Tamar. ");
INSERT INTO hausa_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Amma Er, ɗan farin Yahuda mugu ne a fuskar Ubangiji, saboda haka Ubangiji ya kashe shi. ");
INSERT INTO hausa_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Sa’an nan Yahuda ya ce wa Onan, “Ka kwana da matar ɗan’uwanka ka cika wajibinka gare ta a matsayin ɗan’uwan miji, don ka samar wa ɗan’uwanka ’ya’ya.” ");
INSERT INTO hausa_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Amma Onan ya san cewa ’ya’yan ba za su zama nasa ba; saboda haka a duk sa’ad da ya kwana da matar ɗan’uwansa, sai yă zub da maniyyinsa a ƙasa don kada yă samar wa ɗan’uwansa ’ya’ya. ");
INSERT INTO hausa_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Abin nan da ya yi mugunta ce a gaban Ubangiji, saboda haka Ubangiji ya kashe shi, shi ma. ");
INSERT INTO hausa_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Sai Yahuda ya ce wa surukarsa Tamar, “Ki yi zama kamar gwauruwa a gidan mahaifinki sai ɗana Shela ya yi girma.” Gama ya yi tunani, “Shi ma zai mutu, kamar ’yan’uwansa.” Saboda haka Tamar ta je ta zauna a gidan mahaifinta. ");
INSERT INTO hausa_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Bayan an daɗe sai matar Yahuda, ’yar Shuwa ta rasu. Sa’ad da Yahuda ya gama makoki, sai ya haura zuwa Timna, zuwa wurin mutanen da suke askin tumakinsa, abokinsa Hira mutumin Adullam kuwa ya tafi tare da shi. ");
INSERT INTO hausa_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Sa’ad da aka faɗa wa Tamar cewa, “Surukinki yana kan hanyarsa zuwa Timna don askin tumakinsa,” ");
INSERT INTO hausa_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","sai ta tuɓe rigunan gwaurancinta ta rufe kanta da lulluɓi don ta ɓad da kamanninta, sa’an nan ta je ta zauna a ƙofar shigar Enayim, wadda take a hanyar zuwa Timna. Gama ta lura cewa ko da yake Shela yanzu ya yi girma, ba a ba da ita gare shi ta zama matarsa ba. ");
INSERT INTO hausa_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Sa’ad da Yahuda ya gan ta, ya yi tsammani karuwa ce, gama ta lulluɓe fuskarta. ");
INSERT INTO hausa_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Bai san cewa ita surukarsa ce ba, sai ya ratse zuwa wurinta a gefen hanya ya ce, “Zo mana, in kwana da ke.” Sai ta ce, “Me za ka ba ni in na kwana da kai?” ");
INSERT INTO hausa_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Ya ce, “Zan aika miki da ɗan akuya daga garkena.” Sai ta ce, “Za ka ba ni wani abu jingina, kafin ka aika da shi?” ");
INSERT INTO hausa_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Ya ce, “Wace jingina zan ba ki?” Sai ta amsa, “Hatiminka da ka rataye a wuya da kuma sandan da yake a hannunka.” Ya ba da su gare ta, ya kuma kwana da ita, sai ta yi ciki. ");
INSERT INTO hausa_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Bayan ta tafi, sai ta tuɓe lulluɓin, ta sāke sa tufafin gwaurancinta. ");
INSERT INTO hausa_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Ana cikin haka sai Yahuda ya aika da ɗan akuya ta hannun abokinsa mutumin Adullam don yă karɓo masa jinginar daga wurin macen, amma bai same ta a can ba. ");
INSERT INTO hausa_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Ya tambayi mutanen da suke zama a can ya ce, “Ina karuwar haikalin da take a bakin hanya a Enayim?” Sai suka ce, “Ba a taɓa kasance da karuwar haikali a nan ba.” ");
INSERT INTO hausa_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Saboda haka sai ya koma zuwa wurin Yahuda ya ce, “Ban same ta ba. Ban da haka ma, mutanen da suke zama a can, sun ce, ‘Ba a taɓa kasance da wata karuwar haikali a nan ba.’ ” ");
INSERT INTO hausa_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Sa’an nan Yahuda ya ce, “Bari tă riƙe kayan kiɗa garin nema mu zama abin dariya. Ni kam, na aika da tunkiyar amma ba a same ta ba.” ");
INSERT INTO hausa_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Bayan misalin wata uku sai aka faɗa wa Yahuda cewa, “Tamar, surukarka ta yi laifin karuwanci, a sakamakon haka yanzu ta yi ciki.” Yahuda ya ce, “A fid da ita, a ƙone!” ");
INSERT INTO hausa_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Yayinda ake fitar da ita, sai ta aika saƙo zuwa wurin surukinta, ta ce, “Mutumin da yake da waɗannan kayan ne ya yi mini ciki.” Ta kuma ƙara da cewa, “Duba ko za ka gane da hatimin nan, da abin ɗamaran nan, da kuma sandan nan, ko na wane ne?” ");
INSERT INTO hausa_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yahuda ya gane su, sai ya ce, “Ai, ta fi ni gaskiya, da yake ban ba da ita ga ɗana Shela ba.” Bai kuwa ƙara kwana da ita ba. ");
INSERT INTO hausa_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Sa’ad da lokaci ya yi da za tă haihu, ashe, tagwaye ’yan maza ne suke cikinta. ");
INSERT INTO hausa_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Yayinda take haihuwa, ɗaya daga cikinsu ya fid da hannunsa; sai ungonzomar ta ɗauki jan zare ta ɗaura a hannun, ta ce, “Wannan ne ya fito da farko.” ");
INSERT INTO hausa_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Amma sa’ad da ya janye hannunsa, sai ɗan’uwansa ya fito, sai ta ce, “Wato, haka ne ka keta ka fito!” Sai aka ba shi suna Ferez. ");
INSERT INTO hausa_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Sa’an nan ɗan’uwansa wanda yake da jan zare a hannunsa ya fito, aka kuma ba shi suna Zera. ");
INSERT INTO hausa_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","To, aka kai Yusuf Masar, Fotifar wani mutumin Masar wanda yake ɗaya daga cikin hafsoshin Fir’auna, shugaban masu tsaro, ya saye shi daga mutanen Ishmayel waɗanda suka kai shi can. ");
INSERT INTO hausa_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Ubangiji kuwa yana tare da Yusuf, Yusuf kuwa yi nasara, ya zauna a gidan mutumin Masar maigidansa. ");
INSERT INTO hausa_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Sa’ad da maigidansa ya ga cewa Ubangiji yana tare da Yusuf, kuma cewa Ubangiji ya ba shi nasara a kome da ya yi, ");
INSERT INTO hausa_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","sai Yusuf ya sami tagomashi a idanunsa, ya kuma zama mai hidimarsa. Fotifar ya sa shi yă zama shugaba a gidansa, ya kuma danƙa masa kome da yake da shi. ");
INSERT INTO hausa_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Daga lokacin da ya sa shi shugaban gidansa da kuma a kan dukan abin da yake da shi, sai Ubangiji ya albarkaci gidan mutumin Masar saboda Yusuf. Albarkar Ubangiji tana a kan kome da Fotifar yake da shi a gida da kuma a jeji. ");
INSERT INTO hausa_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Saboda haka sai ya bar kome a ƙarƙashin kulawar Yusuf, bai dame kansa a wani abu ba sai dai abincin da yake ci. To, fa, Yusuf ƙaƙƙarfa ne, kyakkyawa kuma, ");
INSERT INTO hausa_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","bayan an ɗan jima sai matar maigidansa ta fara sha’awar Yusuf, sai ta ce, “Zo ka kwana da ni!” ");
INSERT INTO hausa_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Amma ya ƙi. Ya ce mata, “Ga shi kome yana a ƙarƙashina, don haka ne ma maigidana bai dami kansa da wani abu a cikin gidan nan ba; kome da ya mallaka, ya danƙa ga kulawata. ");
INSERT INTO hausa_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Babu wani da ya fi ni a wannan gida. Maigidana bai hana ni kome ba sai ke, saboda ke matarsa ce. Yaya fa, zan yi irin wannan mugun abu, in yi zunubi wa Allah?” ");
INSERT INTO hausa_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Ko da yake ta yi ta yin wa Yusuf maganar kowace rana, amma ya ƙi yă kwana da ita, ko ma yă zauna da ita. ");
INSERT INTO hausa_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Wata rana, ya shiga cikin gida don yă yi ayyukansa, ba wani daga cikin bayin gidan da yake ciki. ");
INSERT INTO hausa_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Sai ta cafke shi a riga, ta ce, “Zo ka kwana da ni!” Amma ya bar rigarsa a hannunta, ya gudu ya fita daga gidan. ");
INSERT INTO hausa_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Sa’ad da ta ga ya bar rigarsa a hannunta ya gudu ya fita daga gidan, ");
INSERT INTO hausa_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","sai ta kira bayin gidan ta ce musu, “Duba, an kawo mana wannan mutumin Ibraniyawa don yă ci mutuncinmu! Ya zo nan don yă kwana da ni, amma na yi ihu. ");
INSERT INTO hausa_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Sa’ad da ya ji na yi ihu neman taimako, sai ya bar rigarsa kusa da ni, ya gudu ya fita daga gida.” ");
INSERT INTO hausa_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Ta ajiye rigar kusa da ita sai da maigidansa ya dawo gida. ");
INSERT INTO hausa_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Sa’an nan ta faɗa masa wannan labari, “Mutumin Ibraniyawan, bawan da ka kawo mana, ya zo wurina don yă ci mutuncina. ");
INSERT INTO hausa_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Amma da zarar na yi ihu neman taimako, sai ya bar rigarsa kusa da ni, ya gudu ya fita daga gida.” ");
INSERT INTO hausa_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Sa’ad da maigidansa ya ji labarin da matarsa ta faɗa masa cewa, “Ga yadda bawanka ya yi da ni,” sai ya husata. ");
INSERT INTO hausa_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Maigidan Yusuf ya ɗauke shi ya sa a kurkuku, wurin da ake tsare ’yan kurkukun sarki. Amma yayinda Yusuf yake can a cikin kurkuku, ");
INSERT INTO hausa_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Ubangiji ya kasance tare da shi; ya nuna masa alheri, ya kuma sa ya sami tagomashi a idanun mai gadin kurkukun. ");
INSERT INTO hausa_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Saboda haka mai gadin ya sa Yusuf ya zama shugaban dukan waɗanda aka tsare a kurkukun, Yusuf ne kuma yake lura da dukan abin da ake yi a can. ");
INSERT INTO hausa_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Mai gadin ba ya sa kansa game da kome da yake ƙarƙashin kulawar Yusuf, gama Ubangiji yana tare da Yusuf, ya kuma ba shi nasara a cikin dukan abin da ya yi. ");
INSERT INTO hausa_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Bayan ɗan lokaci, sai mai riƙon kwaf da mai tuyan sarkin Masar suka yi wa maigidansu, sarkin Masar laifi. ");
INSERT INTO hausa_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Fir’auna ya yi fushi da hafsoshin nan nasa guda biyu, shugaban masu shayarwa da shugaban masu tuya, ");
INSERT INTO hausa_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","ya kuma sa su a kurkuku a cikin gidan shugaban masu tsaro, a wannan kurkukun da aka sa Yusuf. ");
INSERT INTO hausa_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Sai shugaban masu tsaro ya danƙa su a hannun Yusuf, ya kuwa yi musu hidima. Bayan sun jima cikin kurkuku, ");
INSERT INTO hausa_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","sai kowanne a cikin mutum biyun nan, mai riƙon kwaf da mai tuya na sarkin Masar, waɗanda aka sa a kurkuku, suka yi mafarki a dare ɗaya, kuma kowane mafarki ya kasance da fassara irin tasa. ");
INSERT INTO hausa_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Sa’ad da Yusuf ya zo wurinsu kashegari, sai ya ga duk sun damu. ");
INSERT INTO hausa_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Saboda haka ya tambayi hafsoshin Fir’auna, waɗanda suke a kurkuku tare da shi, a gidan maigidansa ya ce, “Me ya sa fuskokinku suke a ɓace haka?” ");
INSERT INTO hausa_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Sai suka amsa, “Mu biyu, mun yi mafarki, amma babu wani da zai fassara mana su.” Sa’an nan Yusuf ya ce musu, “Fassara ba daga Allah take zuwa ba? Ku faɗa mini mafarkanku.” ");
INSERT INTO hausa_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Sai shugaban masu shayarwa ya faɗa wa Yusuf mafarkinsa. Ya ce masa, “A cikin mafarkina, na ga kuringa a gabana, ");
INSERT INTO hausa_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","kuma a kuringar, akwai rassa uku. Nan da nan kuringar ta yi toho, ta huda, ta kuma yi nonna har suka nuna, suka zama inabi. ");
INSERT INTO hausa_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Kwaf Fir’auna kuwa yana a hannuna, na kuma ɗiba inabin na matse su cikin kwaf Fir’auna, na kuma sa kwaf ɗin a hannunsa.” ");
INSERT INTO hausa_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Yusuf ya ce masa, “Ga abin da mafarkin yake nufi, ‘Rassan nan uku, kwana uku ne. ");
INSERT INTO hausa_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Cikin kwana uku, Fir’auna zai fitar da kai, yă maido da kai a matsayinka, za ka kuwa sa kwaf Fir’auna cikin hannunsa, kamar yadda ka saba yi sa’ad da kake mai riƙon kwaf nasa. ");
INSERT INTO hausa_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Amma fa, sa’ad da kome ya zama maka da kyau, ka tuna da ni, ka kuma yi mini alheri, ka ambace ni wa Fir’auna, ka fid da ni daga wannan kurkuku. ");
INSERT INTO hausa_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Gama da ƙarfi ne aka ɗauke ni daga ƙasar Ibraniyawa, ko a nan ma ban yi wani abin da ya cancanci a sa ni cikin kurkuku ba.’ ” ");
INSERT INTO hausa_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Sa’ad da shugaban masu tuya ya ga cewa Yusuf ya ba da fassara mai gamsarwa, sai ya ce, wa Yusuf, “Ni ma na yi mafarki. A kaina, akwai kwanduna uku na burodi. ");
INSERT INTO hausa_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","A kwandon na bisa, akwai kayan iri-iri da aka toya, masu kyau domin Fir’auna, amma tsuntsaye suka ci su a kwandon da yake kaina.” ");
INSERT INTO hausa_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Yusuf ya ce, “Ga abin da mafarkin yake nufi, ‘Kwanduna uku, kwanaki uku ne. ");
INSERT INTO hausa_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Cikin kwana uku, Fir’auna zai fid da kai, yă rataye ka a kan itace. Tsuntsaye kuwa za su ci naman jikinka.’ ” ");
INSERT INTO hausa_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","To, a rana ta uku ne, ranar tunawa da haihuwar Fir’auna, ya kuwa yi biki wa dukan hafsoshinsa. Ya fid da shugaban masu shayarwa da kuma shugaban masu tuya a gaban hafsoshinsa. ");
INSERT INTO hausa_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Ya mai da shugaban masu shayarwa a matsayinsa, saboda haka shugaban masu shayarwa ya sāke sa kwaf a hannun Fir’auna, ");
INSERT INTO hausa_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","amma ya rataye shugaban masu tuya, kamar dai yadda Yusuf ya faɗa musu a fassarar mafarkan da suka yi. ");
INSERT INTO hausa_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Shugaban masu shayarwa fa, bai tuna da Yusuf ba; ya mance da shi. ");
INSERT INTO hausa_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Bayan shekaru biyu cif, Fir’auna ya yi mafarki. A mafarkin, ya ga yana tsaye kusa da Nilu, ");
INSERT INTO hausa_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","sai ga shanu bakwai masu ƙiba mulmul, suka fito daga kogin, suna kiwo a cikin kyauro. ");
INSERT INTO hausa_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Bayansu, sai ga waɗansu shanu bakwai, munana, ramammu, suka fito daga Nilu, suka tsaya kusa da waɗancan masu ƙiban, a bakin kogin. ");
INSERT INTO hausa_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Shanun nan da suke munana ramammu, suka cinye shanu bakwai nan masu ƙiba mulmul. Sai Fir’auna ya farka. ");
INSERT INTO hausa_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Ya sāke yin barci, sai ya yi mafarki na biyu; ya ga kawuna bakwai na dawa, ƙosassu masu kyau, suka yi girma a kara guda. ");
INSERT INTO hausa_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Bayansu, sai ga waɗansu kawuna bakwai na dawa, suka fito sirara waɗanda iskar gabas ta sa suka yanƙwane. ");
INSERT INTO hausa_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Siraran dawan suka haɗiye kawuna bakwai nan ƙosassu masu kyau. Sai Fir’auna ya farka, ashe, mafarki ne. ");
INSERT INTO hausa_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Da safe sai hankalinsa ya tashi, saboda haka sai ya aika a kawo dukan masu duba da masu hikima na Masar. Fir’auna ya faɗa musu mafarkansa, amma babu wanda ya iya ba shi fassararsu. ");
INSERT INTO hausa_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Sai shugaban masu shayarwa ya ce wa Fir’auna, “Yau an tuna mini da kāsawata. ");
INSERT INTO hausa_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Sai ya ci gaba ya ce, Fir’auna ya taɓa husata da bayinsa, ya kuma jefa ni da shugaban masu tuya a cikin kurkuku a gidan shugaban masu tsaro. ");
INSERT INTO hausa_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Kowannenmu ya yi mafarki a wani dare, kowane mafarki kuma ya kasance da ma’anarsa. ");
INSERT INTO hausa_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","To, wani saurayi, mutumin Ibraniyawa ya kasance a can tare da mu, bawan shugaban masu tsaro. Sai muka faɗa masa mafarkanmu, ya kuwa fassara mana su, yana ba wa kowane mutum fassarar mafarkinsa. ");
INSERT INTO hausa_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Abubuwan kuwa suka kasance daidai yadda ya fassara su gare mu; aka mai da ni a matsayina, ɗaya mutumin kuwa aka rataye shi.” ");
INSERT INTO hausa_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Sai Fir’auna ya aika a kawo Yusuf, aka kuwa kawo shi da sauri daga kurkuku. Sa’ad da ya yi aski, ya kuma canja tufafinsa, sai ya zo gaban Fir’auna. ");
INSERT INTO hausa_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Fir’auna ya ce wa Yusuf, “Na yi mafarki, kuma babu wanda ya iya fassara shi. Amma na ji an ce sa’ad da ka ji mafarki, kana iya fassara shi.” ");
INSERT INTO hausa_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Yusuf ya amsa wa Fir’auna ya ce, “Ba ni ne da iyawar ba, Allah zai iya ba wa Fir’auna amsar da yake nema.” ");
INSERT INTO hausa_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Sa’an nan Fir’auna ya ce wa Yusuf, “A cikin mafarkina, na ga ina tsaye a bakin Nilu, ");
INSERT INTO hausa_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","sai ga shanu bakwai masu ƙiba mulmul, suka fito daga kogin, suna kiwo a cikin kyauro. ");
INSERT INTO hausa_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Bayansu kuma, sai ga waɗansu shanu bakwai suka fito ƙanjamammu, munana, ramammu. Ban taɓa ganin irin munanan shanu haka a cikin dukan ƙasar Masar ba. ");
INSERT INTO hausa_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Ramammun shanun nan munana, suka cinye shanun nan bakwai masu ƙiba da suka fito da fari. ");
INSERT INTO hausa_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Amma ko bayan da suka cinye su, babu wanda zai iya faɗa cewa sun yi haka; suna nan dai munana kamar yadda suke a dā. Sai na farka. ");
INSERT INTO hausa_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“Har yanzu kuma, a cikin mafarkina na ga kawuna bakwai na dawa ƙosassu masu kyau, suna girma a kara guda. ");
INSERT INTO hausa_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Bayansu, sai ga waɗansu kawuna bakwai suka fito, yanƙwananne sirara waɗanda iskar gabas ta yanƙwane. ");
INSERT INTO hausa_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Siraran kawunan dawan nan suka haɗiye kawuna bakwai nan masu kyau. Na faɗa wannan wa masu duba, amma ba wanda ya iya fassara mini shi.” ");
INSERT INTO hausa_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Sai Yusuf ya ce wa Fir’auna, “Mafarkan Fir’auna, ɗaya ne. Allah ya bayyana wa Fir’auna abin da yake shirin yi. ");
INSERT INTO hausa_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Shanu masu kyau nan, shekaru bakwai ne, kawunan dawa bakwai ƙosassun nan kuwa shekaru bakwai ne; mafarkan iri ɗaya ne. ");
INSERT INTO hausa_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Shanun nan ramammu, munana, da suka zo daga baya, shekaru bakwai ne, haka ma kawuna dawan nan shanyayyu da iskar gabas ta yanƙwane. Shekaru ne bakwai na yunwa. ");
INSERT INTO hausa_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","“Haka yake kamar yadda na faɗa wa Fir’auna cewa Allah ya nuna wa Fir’auna abin da yake shirin yi. ");
INSERT INTO hausa_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Shekaru bakwai na yalwar abinci suna zuwa a dukan ƙasar Masar, ");
INSERT INTO hausa_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","amma shekaru bakwai na yunwa za su biyo bayansu. Tsananin yunwar za tă sa a manta da dukan isashen abincin da aka samu a ƙasar Masar, yunwa kuwa za tă rufe dukan ƙasar. ");
INSERT INTO hausa_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Ba za a tuna da isashen abincin da aka samu a ƙasar ba, domin yunwar da za tă biyo baya za tă zama da tsanani ƙwarai. ");
INSERT INTO hausa_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Dalilin da aka ba wa Fir’auna mafarkan nan kashi biyu kuwa shi ne cewa Allah ya riga ya ƙaddara al’amarin. Allah zai aikata shi, ba da daɗewa ba. ");
INSERT INTO hausa_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Yanzu fa, bari Fir’auna yă nemi mutum mai basira da kuma hikima, yă sa shi yă shugabanci ƙasar Masar. ");
INSERT INTO hausa_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Bari Fir’auna yă naɗa komishinoni a kan ƙasar don su karɓi kashi ɗaya bisa biyar na girbin Masar a lokacin shekaru bakwai na yalwar abinci. ");
INSERT INTO hausa_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Ya kamata su tara dukan abincin waɗannan shekaru masu kyau da suke zuwa, su yi ajiyar hatsin a ƙarƙashin ikon Fir’auna, don a ajiye a birane don abinci. ");
INSERT INTO hausa_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Ya kamata a adana abincin nan don ƙasar, kāriya shekaru bakwai na yunwa, domin a yi amfani da shi a lokacin shekarun yunwan da za su zo wa Masar, saboda kada ƙasar ta lalace da yunwa.” ");
INSERT INTO hausa_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Shirin ya yi wa Fir’auna da kuma dukan hafsoshinsa kyau. ");
INSERT INTO hausa_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Saboda haka Fir’auna ya tambaye su, “Za mu iya samun wani kamar wannan mutum, wannan wanda Ruhun Allah yake cikinsa?” ");
INSERT INTO hausa_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Sai Fir’auna ya ce wa Yusuf, “Da yake Allah ya ba ka sanin dukan waɗannan, babu wani mai basira da kuma hikima kamar ka. ");
INSERT INTO hausa_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Za ka shugabanci fadata, kuma dukan mutanena za su zama a ƙarƙashinka. Da sarauta kaɗai zan fi ka girma.” ");
INSERT INTO hausa_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Saboda haka Fir’auna ya ce wa Yusuf, “Ga shi na sa ka zama shugaban dukan ƙasar Masar.” ");
INSERT INTO hausa_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Sa’an nan Fir’auna ya zare zoben sarauta daga yatsarsa, ya sa shi a yatsan Yusuf. Ya sanya masa rigar lallausan lilin, ya kuma sa masa sarƙar zinariya a wuyansa. ");
INSERT INTO hausa_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Ya sa shi ya hau keken yaƙi a matsayi mai binsa na biyu, mutane kuwa suka yi shela a gabansa suna cewa, “A ba da hanya!” Ta haka ya sa shi shugaba a kan dukan ƙasar Masar. ");
INSERT INTO hausa_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Sa’an nan Fir’auna ya ce wa Yusuf, “Ni ne Fir’auna, amma in ba tare da umarninka ba, ba wanda zai ɗaga hannu ko ƙafa a cikin dukan Masar.” ");
INSERT INTO hausa_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Fir’auna ya ba wa Yusuf suna Zafenat-Faneya, ya kuma ba shi Asenat ’yar Fotifera firist na On, ta zama matarsa. Yusuf kuwa ya zaga dukan ƙasar Masar. ");
INSERT INTO hausa_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Yusuf yana zuwa shekara talatin sa’ad da ya shiga hidimar Fir’auna sarkin Masar. Yusuf kuwa ya fita daga gaban Fir’auna, ya zaga ko’ina a Masar. ");
INSERT INTO hausa_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","A shekaru bakwai na yalwa, ƙasar ta ba da amfani mai yawa. ");
INSERT INTO hausa_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Yusuf ya tattara dukan abincin da aka samu a waɗannan shekaru bakwai na yalwa a Masar, ya kuma yi ajiyarsu a cikin birane. A kowane birni, ya sa abincin da aka nome a kewayensa. ");
INSERT INTO hausa_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Sai Yusuf ya tara hatsi da yawan gaske, kamar yashi a bakin teku, har sai da ya kāsa iya auna shi, gama ba a iya aunawa. ");
INSERT INTO hausa_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Kafin shekarun yunwa su zo, Asenat ’yar Fotifera, firist na On, ta haifa wa Yusuf ’ya’ya maza biyu. ");
INSERT INTO hausa_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Yusuf ya ba wa ɗansa na fari suna Manasse ya ce, “Gama Allah ya sa na mance dukan wahalata da dukan gidan mahaifina.” ");
INSERT INTO hausa_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Ya ba wa ɗansa na biyu suna Efraim ya ce, “Gama Allah ya wadata ni cikin wahalata.” ");
INSERT INTO hausa_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Shekaru bakwai na yalwa a Masar suka zo ga ƙarshe, ");
INSERT INTO hausa_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","sai shekaru bakwai na yunwa suka soma shigowa, kamar yadda Yusuf ya faɗa. Aka yi yunwa ko’ina amma ban da ƙasar Masar. Don akwai abinci. ");
INSERT INTO hausa_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Sa’ad da dukan Masar ta fara jin yunwa, sai mutane suka yi wa Fir’auna kuka don abinci. Sai Fir’auna ya ce wa dukan Masarawa, “Ku tafi wurin Yusuf, ku kuma yi abin da ya faɗa muku.” ");
INSERT INTO hausa_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Sa’ad da yunwa ta bazu a dukan ƙasar, sai Yusuf ya buɗe gidajen ajiya, ya kuma sayar da hatsi ga Masarawa, gama yunwa ta yi tsanani a dukan Masar. ");
INSERT INTO hausa_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Dukan ƙasashe kuwa suka zo Masar don saya hatsi daga Yusuf, gama yunwa ta yi tsanani a dukan duniya. ");
INSERT INTO hausa_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Sa’ad da Yaƙub ya sami labari cewa akwai hatsi a Masar, sai ya ce wa ’ya’yansa maza, “Don me kuke duban juna kawai?” ");
INSERT INTO hausa_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Ya ci gaba, “Na ji cewa akwai hatsi a Masar. Ku gangara can ku sayo mana, domin mu rayu kada mu mutu.” ");
INSERT INTO hausa_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Sai goma daga cikin ’yan’uwan Yusuf suka gangara don su saya hatsi daga Masar. ");
INSERT INTO hausa_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Amma Yaƙub bai aiki Benyamin, ɗan’uwan Yusuf tare da sauran ba, gama yana tsoro kada wani abu yă faru da shi. ");
INSERT INTO hausa_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Sai ’ya’yan Yaƙub suka isa Masar tare da sauran mutanen don sayen abinci, gama yunwar ta kai yankin Kan’ana ma. ");
INSERT INTO hausa_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","To, Yusuf ne gwamnar ƙasar wanda yake sayar da hatsi ga dukan mutanenta. Saboda haka sa’ad da ’yan’uwan Yusuf suka isa, sai suka rusuna masa har ƙasa da fuskokinsu. ");
INSERT INTO hausa_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Nan da nan da Yusuf ya ga ’yan’uwansa, sai ya gane su, amma ya yi kamar baƙo, ya kuma yi musu magana da tsawa. Ya tambaya, “Daga ina kuka fito?” Suka amsa, “Daga ƙasar Kan’ana, don mu saya abinci.” ");
INSERT INTO hausa_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Ko da yake Yusuf ya gane ’yan’uwansa, su ba su gane shi ba. ");
INSERT INTO hausa_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Sa’an nan ya tuna da mafarkansa game da su, ya kuma ce musu, “Ku ’yan leƙen asiri ne! Kun zo don ku leƙi asirin ƙasar ku ga inda ba ta da tsaro.” ");
INSERT INTO hausa_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Suka amsa suka ce, “A’a, ranka yă daɗe, bayinka sun zo don saya abinci ne. ");
INSERT INTO hausa_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Mu duka ’ya’yan mutum ɗaya maza ne. Bayinka mutane ne masu gaskiya, ba ’yan leƙen asiri ba ne.” ");
INSERT INTO hausa_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Ya ce musu “Sam! Kun zo ne ku ga inda ƙasarmu babu tsaro.” ");
INSERT INTO hausa_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Amma suka amsa suka ce, “Bayinka dā su goma sha biyu ne, ’yan’uwa, ’ya’yan mutum guda maza, wanda yake zama a ƙasar Kan’ana. Ƙaraminmu yanzu yana tare da mahaifinmu, ɗayan kuma ya rasu.” ");
INSERT INTO hausa_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Yusuf ya ce musu, “Daidai ne yadda na faɗa muku. Ku ’yan leƙen asiri ne! ");
INSERT INTO hausa_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Ga kuwa yadda za a gwada ku. Muddin Fir’auna yana a raye, ba za ku bar wannan wuri ba sai ƙaramin ɗan’uwanku ya zo nan. ");
INSERT INTO hausa_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Ku aiki ɗaya daga cikinku yă kawo ɗan’uwanku; za a sa sauranku a kurkuku, saboda a gwada maganarku a ga ko gaskiya ce kuke faɗi. In ba haka ba, to, da ran Fir’auna, ku ’yan leƙen asiri ne!” ");
INSERT INTO hausa_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Ya kuwa sa su duka a kurkuku na kwana uku. ");
INSERT INTO hausa_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","A rana ta uku, Yusuf ya ce musu, “Ku yi wannan za ku kuwa rayu, gama ina tsoron Allah. ");
INSERT INTO hausa_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","In ku mutane masu gaskiya ne, ku bar ɗaya daga cikin ’yan’uwanku yă zauna a kurkuku, yayinda sauranku su tafi, su kai hatsi don gidajenku da suke yunwa. ");
INSERT INTO hausa_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Amma dole ku kawo ƙaramin ɗan’uwanku gare ni, saboda a tabbatar da maganarku har ba za ku mutu ba.” Suka kuwa yi haka. ");
INSERT INTO hausa_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Sai suka ce wa juna, “Tabbatacce ana hukunta mu ne saboda ɗan’uwanmu. Mun ga yadda ya yi wahala sa’ad da ya roƙe mu saboda ransa, amma ba mu saurare shi ba, shi ya sa wannan wahala ta zo mana.” ");
INSERT INTO hausa_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ruben ya amsa, “Ban faɗa muku cewa kada ku ɗauki alhakin yaron nan ba, sai kuka ƙi ji, to, yau ga alhakin jininsa muke biya.” ");
INSERT INTO hausa_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Ba su san cewa Yusuf yana jin su ba, da yake yana amfani da mai fassara ne. ");
INSERT INTO hausa_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Sai ya juya daga gare su ya yi kuka, sa’an nan ya dawo ya yi musu magana kuma. Ya sa aka ɗauke Simeyon daga gare su, aka daure shi a idanunsu. ");
INSERT INTO hausa_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Yusuf ya yi umarni a cika buhunansu da hatsi, a kuma sa azurfan kowane mutum a cikin buhunsa, a kuma ba su kalaci don tafiyarsu. Bayan aka yi musu wannan, ");
INSERT INTO hausa_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","suka jibga hatsinsu a kan jakuna, sai suka kama hanya. ");
INSERT INTO hausa_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","A wurin da suka tsaya don su kwana, ɗaya daga cikinsu ya buɗe buhunsa don yă ciyar da jakinsa, sai ya ga azurfansa a bakin buhunsa. ");
INSERT INTO hausa_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Sai ya ce wa ’yan’uwansa, “An mayar mini da azurfata. Ga shi a cikin buhuna.” Zuciyarsu ta karai, suka dubi juna suna rawan jiki, suka ce, “Mene ne wannan da Allah ya yi mana?” ");
INSERT INTO hausa_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Sa’ad da suka zo wurin mahaifinsu Yaƙub a ƙasar Kan’ana, suka faɗa masa dukan abin da ya faru da su. Suka ce, ");
INSERT INTO hausa_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Mutumin da yake shugaba a ƙasar ya yi mana matsananciyar magana, ya kuma ɗauke mu tamƙar ’yan leƙen asirin ƙasa. ");
INSERT INTO hausa_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Amma muka ce masa, ‘Mu masu gaskiya ne; mu ba ’yan leƙen asiri ba ne. ");
INSERT INTO hausa_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Dā mu ’yan’uwa ne goma sha biyu, ’ya’yan mahaifi guda maza. Ɗayanmu ya rasu, kuma ƙaramin yanzu yana tare da mahaifinmu a Kan’ana.’ ");
INSERT INTO hausa_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","“Sai mutumin wanda yake shugaba a kan ƙasar ya ce mana, ‘Ga yadda zan san ko ku mutane masu gaskiya ne. Ku bar ɗaya daga cikin ’yan’uwanku a nan tare da ni, ku ɗauki abinci domin gidajenku masu yunwa, ku tafi. ");
INSERT INTO hausa_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Amma ku kawo mini ƙaramin ɗan’uwanku domin in san cewa ku ba ’yan leƙen asiri ba ne, amma mutane ne masu gaskiya. Sa’an nan zan mayar muku da ɗan’uwanku, ku kuma iya yin sana’a a ƙasar.’ ” ");
INSERT INTO hausa_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Yayinda suke juyewa hatsi daga buhunansu, sai ga ƙunshin azurfan kowane mutum a buhunsa! Sa’ad da su da mahaifinsu suka ga ƙunshe-ƙunshen kuɗi, suka firgita. ");
INSERT INTO hausa_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Yaƙub mahaifinsu, ya ce musu, “Kun sa ni rashin ’ya’yana. Yusuf ya rasu, Simeyon kuma ba ya nan, yanzu kuma kuna so ku ɗauki Benyamin. Kome yana gāba da ni!” ");
INSERT INTO hausa_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Sai Ruben ya ce wa mahaifinsa, “Ka kashe dukan ’ya’yana maza, in ban dawo da shi gare ka ba. Ka sa shi ga kulawata, zan kuwa dawo da shi.” ");
INSERT INTO hausa_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Amma Yaƙub ya ce, “Ɗana ba zai gangara zuwa can tare da ku ba, ɗan’uwansa ya rasu, shi ne kaɗai ya rage. In wani abu ya faru da shi a tafiyar da za ku yi, za ku sa furfurata ta gangara zuwa kabari cikin baƙin ciki.” ");
INSERT INTO hausa_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","A yanzu, yunwa ta yi tsanani a ƙasar. ");
INSERT INTO hausa_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Saboda haka sa’ad da suka cinye dukan hatsin da suka kawo daga Masar, mahaifinsu ya ce musu, “Ku koma, ku sayo mana ƙarin abinci.” ");
INSERT INTO hausa_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Amma Yahuda ya ce masa, “Mutumin ya gargaɗe mu sosai cewa, ‘Ba za ku sāke ganin fuskata ba sai in ɗan’uwanku yana tare da ku.’ ");
INSERT INTO hausa_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","In za ka aika da ɗan’uwanmu tare da mu, za mu gangara mu sayo maka abinci. ");
INSERT INTO hausa_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Amma in ba za ka aika da shi ba, ba za mu gangara ba, gama mutumin ya ce mana, ‘Ba za ku sāke ganin fuskata ba sai ko in ɗan’uwanku yana tare da ku.’ ” ");
INSERT INTO hausa_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Isra’ila ya yi tambaya, “Me ya sa kuka kawo wannan damuwa a kaina ta wurin faɗa wa mutumin cewa kuna da wani ɗan’uwa?” ");
INSERT INTO hausa_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Suka amsa, “Mutumin ya yi mana tambaya sosai game da kanmu da iyalinmu. Ya tambaye mu, ‘Mahaifinku yana da rai har yanzu? Kuna da wani ɗan’uwa?’ Mu dai mun amsa tambayoyinsa ne. Ta yaya za mu sani zai ce, ‘Ku kawo ɗan’uwanku a nan’?” ");
INSERT INTO hausa_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Sa’an nan Yahuda ya ce wa Isra’ila mahaifinsa, “Ka aika saurayin tare da ni za mu kuwa tafi nan da nan, saboda mu da ’ya’yanmu mu rayu, kada mu mutu. ");
INSERT INTO hausa_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Ni kaina zan tabbatar da lafiyarsa; na ɗauki lamuninsa, a hannuna za ka neme shi. In ban dawo da shi gare ka, in sa shi nan a gabanka ba, zan ɗauki laifin a gabanka dukan kwanakina. ");
INSERT INTO hausa_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Ai, da ba mun jinkirta ba, da mun komo har sau biyu.” ");
INSERT INTO hausa_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Sa’an nan mahaifinsu Isra’ila ya ce musu, “In dole ne a yi haka, to, sai ku yi. Ku sa waɗansu amfani mafi kyau na ƙasar a buhunanku, ku ɗauka zuwa wurin mutumin a matsayin kyauta, da ɗan man ƙanshi na shafawa, da kuma ’yar zuma, da kayan yaji, da ƙaro, da tsabar citta da kuma almon. ");
INSERT INTO hausa_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Ku ɗauki ninki biyu na yawan azurfa tare da ku, gama dole ku mayar da azurfan da aka sa a cikin bakunan buhunanku. Mai yiwuwa an yi haka a kuskure ne. ");
INSERT INTO hausa_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Ku ɗauki ɗan’uwanku kuma ku koma wurin mutumin nan da nan. ");
INSERT INTO hausa_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Bari Allah Maɗaukaki yă nuna muku alheri a gaban mutumin saboda yă bar ɗan’uwanku da Benyamin su dawo tare da ku. Ni kuwa, in na yi rashi, na yi rashi.” ");
INSERT INTO hausa_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Saboda haka mutanen suka ɗauki kyautar, da kuma kuɗin da ya ninka na farko. Suka kuma ɗauki Benyamin, suka gaggauta suka gangara zuwa Masar suka kuma gabatar da kansu ga Yusuf. ");
INSERT INTO hausa_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Sa’ad da Yusuf ya ga Benyamin tare da su, sai ya ce wa mai hidimar gidansa, “Ka shigar da mutanen cikin gida, ka yanka dabba ka shirya, gama mutanen za su ci abincin rana tare da ni.” ");
INSERT INTO hausa_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Mutumin ya yi kamar yadda Yusuf ya faɗa masa, ya kuwa ɗauki mutanen zuwa gidan Yusuf. ");
INSERT INTO hausa_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Mutanen dai suka firgita sa’ad da aka ɗauke su zuwa gidansa. Suka yi tunani, “An kawo mu nan ne saboda azurfan da aka sa a cikin buhunanmu da farko. Yana so yă fāɗa mana, yă kuma sha ƙarfinmu, yă ƙwace mu kamar bayi, yă kuma kwashe jakunanmu.” ");
INSERT INTO hausa_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Saboda haka suka je wurin mai yin wa Yusuf hidima, suka yi masa magana a bakin ƙofar gida. ");
INSERT INTO hausa_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Suka ce, “Ranka yă daɗe, mun zo nan ƙaro na farko don mu saya abinci, ");
INSERT INTO hausa_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","amma a inda muka tsaya don mu kwana, da muka buɗe buhunanmu sai kowannenmu ya sami azurfansa daidai a bakin buhunsa. Saboda haka ga kuɗin a hannunmu, mun sāke komowa da su. ");
INSERT INTO hausa_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Mun kuma kawo ƙarin azurfa tare da mu don mu saya abinci. Ba mu san wa ya sa azurfanmu a cikin buhunanmu ba.” ");
INSERT INTO hausa_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Sai mai hidimar ya ce, “Ba kome, kada ku ji tsoro. Allahnku, Allahn mahaifinku ne ya ba ku dukiyar a cikin buhunanku; ni dai, na karɓi azurfanku.” Sa’an nan ya fitar musu da Simeyon. ");
INSERT INTO hausa_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Mai yin hidimar ya ɗauki mutane zuwa gidan Yusuf ya ba su ruwa su wanke ƙafafunsu, ya kuma tanada wa jakunansu abinci. ");
INSERT INTO hausa_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Suka shirya kyautansu domin isowar Yusuf da rana, gama sun ji cewa zai ci abinci a nan. ");
INSERT INTO hausa_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Sa’ad da Yusuf ya zo gida, sai suka ba shi kyautai da suka kawo, suka rusuna a gabansa har ƙasa. ");
INSERT INTO hausa_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Ya tambaye su, yaya suke, sa’an nan ya ce, “Yaya tsohon nan mahaifinku da kuka faɗa mini? Yana da rai har yanzu?” ");
INSERT INTO hausa_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Suka amsa, “Bawanka mahaifinmu yana da rai har yanzu da kuma ƙoshin lafiya.” Suka kuma rusuna suka yi mubaya’a. ");
INSERT INTO hausa_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Da ya ɗaga idanu, sai ya ga ɗan’uwansa Benyamin, ɗan mahaifiyarsa, sai ya yi tambaya, “Wannan ne ƙaramin ɗan’uwanku, wanda kuka faɗa mini a kai?” Ya kuma ce, “Allah yă yi maka albarka, ɗana.” ");
INSERT INTO hausa_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Saboda motsi mai zurfi da zuciyarsa ta yi da ganin ɗan’uwansa, sai Yusuf ya gaggauta ya fita, ya nemi wuri yă yi kuka. Ya shiga ɗakinsa ya yi kuka a can. ");
INSERT INTO hausa_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Bayan ya wanke fuskarsa, sai ya fito ya daure, ya umarta, “A kawo abinci.” ");
INSERT INTO hausa_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Sai aka raba musu abinci, nasa shi kaɗai su kuma su kaɗai, domin Masarawa ba sa cin abinci tare da Ibraniyawa, gama wannan abin ƙyama ne ga Masarawa. ");
INSERT INTO hausa_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Aka zaunar da ’yan’uwan Yusuf a gabansa bisa ga shekarunsu, daga ɗan fari zuwa auta. ’Yan’uwan kuwa suka duddubi juna suna mamaki. ");
INSERT INTO hausa_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Daga teburin da yake a gaban Yusuf aka riƙa ɗibar rabonsu ana kai musu, amma rabon Benyamin ya yi biyar ɗin na kowannensu. Suka kuwa sha, suka yi murna tare da shi. ");
INSERT INTO hausa_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Yusuf kuwa ya ba wa mai yin masa hidima a gida, waɗannan umarnai cewa, “Cika buhunan mutanen nan da abinci iyakar yadda za su iya ɗauka, ka kuma sa kuɗin kowanne a bakin buhunsa. ");
INSERT INTO hausa_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Sa’an nan ka sa kwaf nawa, wannan na azurfa a bakin buhun autan, tare da kuɗinsa na hatsi.” Sai mai hidimar ya yi kamar yadda Yusuf ya umarta. ");
INSERT INTO hausa_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Da gari ya waye, sai aka sallami mutanen tare da jakunansu. ");
INSERT INTO hausa_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Ba su yi nisa da birnin ba sa’ad da Yusuf ya ce wa mai yin masa hidima, “Tashi, ka bi waɗannan mutane nan da nan, in ka same su, ka ce musu, ‘Me ya sa kuka sāka alheri da mugunta? ");
INSERT INTO hausa_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Ba da wannan kwaf ne maigidana yake sha daga ciki yana kuma yin amfani da shi don duba? Wannan mugun abu ne da kuka yi.’ ” ");
INSERT INTO hausa_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Sa’ad da ya same su, sai ya maimaita waɗannan kalmomi gare su. ");
INSERT INTO hausa_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Amma suka ce masa, “Me ya sa ranka yă daɗe yake faɗin irin waɗannan abubuwa? Allah yă sawwaƙe bayinka su yi irin wannan abu! ");
INSERT INTO hausa_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Mun ma dawo maka da kuɗin da muka samu a cikin bakunan buhunanmu daga ƙasar Kan’ana. Saboda haka me zai sa mu saci azurfa ko zinariya daga gidan maigidanka? ");
INSERT INTO hausa_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","In aka sami wani daga cikin bayinka da shi, zai mutu; sai sauran su zama bayin mai girma.” ");
INSERT INTO hausa_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Sai ya ce, “To, shi ke nan, bari yă zama yadda kuka faɗa. Duk wanda aka same shi da kwaf na azurfan zai zama bawana, sauran kuwa za su ’yantu daga zargin.” ");
INSERT INTO hausa_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Da sauri kowannensu ya sauko da buhunsa ƙasa, ya buɗe. ");
INSERT INTO hausa_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Sa’an nan mai hidimar ya fara bincike, farawa daga babba, ya ƙare a ƙaramin. Aka kuwa sami kwaf ɗin a buhun Benyamin. ");
INSERT INTO hausa_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Ganin wannan sai suka kyakkece rigunansu. Sa’an nan suka jibga wa jakunansu kaya, suka koma birni. ");
INSERT INTO hausa_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Yusuf yana nan har yanzu a gida sa’ad da Yahuda da ’yan’uwansa suka shiga, suka fāɗi rub da ciki a ƙasa a gabansa. ");
INSERT INTO hausa_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Yusuf ya ce musu, “Mene ne wannan da kuka yi? Ba ku san cewa mutum kamar ni yana iya gane abubuwa ta wurin duba ba?” ");
INSERT INTO hausa_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yahuda ya amsa ya ce, “Me za mu ce wa ranka yă daɗe? Yaya kuma za mu wanke kanmu daga wannan zargi? Allah ya tona laifin bayinka. Ga mu, za mu zama bayinka, da mu da wanda aka sami kwaf ɗin a hannunsa.” ");
INSERT INTO hausa_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Amma Yusuf ya ce, “Allah yă sawwaƙe in yi haka! Mutumin da aka sami kwaf ɗin a hannunsa ne kaɗai zai zama bawana. Sauranku, ku koma ga mahaifinku da salama.” ");
INSERT INTO hausa_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Sai Yahuda ya haura zuwa wurinsa ya ce, “Ranka yă daɗe, roƙo nake, bari bawanka yă yi magana da ranka yă daɗe. Kada ka yi fushi da bawanka, ko da yake daidai kake da Fir’auna kansa. ");
INSERT INTO hausa_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Ranka yă daɗe ya tambayi bayinka ya ce, ‘Kuna da mahaifi ko ɗan’uwa?’ ");
INSERT INTO hausa_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Muka kuwa amsa, ‘Muna da mahaifi tsoho, akwai kuma ɗa matashi, wanda aka haifa masa cikin tsufarsa. Ɗan’uwansa ya rasu, shi ne kuwa ɗa kaɗai na mahaifiyarsa da ya rage, mahaifinsa kuwa yana ƙaunarsa.’ ");
INSERT INTO hausa_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","“Sai ka ce wa bayinka, ‘Ku kawo mini shi don in gan shi da kaina.’ ");
INSERT INTO hausa_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Muka kuwa ce wa ranka yă daɗe, ‘Saurayin ba zai iya barin mahaifinsa ba, gama in ya bar shi, mahaifinsa zai mutu.’ ");
INSERT INTO hausa_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Amma ka faɗa wa bayinka, ‘Sai kun kawo ƙaramin ɗan’uwanku tare da ku, in ba haka ba, ba za ku sāke ganin fuskata ba.’ ");
INSERT INTO hausa_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Sa’ad da muka koma wurin bawanka mahaifinmu, sai muka faɗa masa abin da ranka yă daɗe ya ce. ");
INSERT INTO hausa_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“Sai mahaifinmu ya ce, ‘Ku koma ku sayo ƙarin abinci.’ ");
INSERT INTO hausa_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Amma muka ce, ‘Ba za mu iya gangarawa ba, sai in ƙaramin ɗan’uwanmu yana tare da mu. Ba za mu iya ganin fuskar mutumin ba, sai ƙaramin ɗan’uwanmu yana tare mu.’ ");
INSERT INTO hausa_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“Bawanka mahaifinmu ya ce mana, ‘Kun san cewa matata ta haifa mini ’ya’ya biyu maza. ");
INSERT INTO hausa_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Ɗayansu ya tafi daga gare ni, na kuwa ce, “Tabbatacce an yayyage shi kaca-kaca.” Ban kuwa gan shi ba tuntuni. ");
INSERT INTO hausa_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","In kun ɗauki wannan daga wurina shi ma wani abu ya same shi, za ku kawo furfura kaina zuwa kabari cikin baƙin ciki.’ ");
INSERT INTO hausa_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","“Saboda haka yanzu, in saurayin ba ya nan tare da mu sa’ad da na koma ga bawanka mahaifina, in kuma mahaifina, wanda ransa yana daure kurkusa da ran saurayin, ");
INSERT INTO hausa_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","ya ga cewa saurayin ba ya nan, zai mutu. Bayinka za su sa bawanka, mahaifinmu, yă mutu cikin baƙin ciki, da tsufansa. ");
INSERT INTO hausa_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Gama ni baranka na ɗauki lamunin saurayin a wurin mahaifinsa da cewa, ‘In ban komo maka da shi ba, sai alhakinsa yă zauna a kaina a gaban mahaifina, dukan raina!’ ");
INSERT INTO hausa_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","“To, yanzu, ina roƙonka bari bawanka yă zauna a nan a matsayin bawanka, ranka yă daɗe a maimakon saurayin, a kuma bar saurayin yă koma da ’yan’uwansa. ");
INSERT INTO hausa_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Yaya zan koma ga mahaifina, in saurayin ba ya tare da ni? A’a! Kada ka bari in ga baƙin cikin da zai auko wa mahaifina.” ");
INSERT INTO hausa_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Yusuf bai ƙara iya daurewa a gaban dukan masu yi masa hidima ba, sai ya yi kuka da ƙarfi ya ce, “Kowa yă tashi daga gabana!” Saboda haka ba kowa a wurin sa’ad da Yusuf ya sanar da kansa ga ’yan’uwansa. ");
INSERT INTO hausa_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Sai ya yi kuka da ƙarfi har Masarawa suka ji, har labarin ya kai gidan Fir’auna. ");
INSERT INTO hausa_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Yusuf kuwa ya ce wa ’yan’uwansa, “Ni ne Yusuf! Mahaifina yana nan da rai har yanzu?” Amma ’yan’uwansa ba su iya amsa masa ba, gama sun firgita ƙwarai a gabansa. ");
INSERT INTO hausa_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Sa’an nan Yusuf ya ce wa ’yan’uwansa, “Ku zo kusa da ni.” Da suka yi haka, sai ya ce, “Ni ne ɗan’uwanku Yusuf, wannan da kuka sayar zuwa Masar! ");
INSERT INTO hausa_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Yanzu dai, kada ku damu, kada kuma ku yi fushi da kanku saboda kun sayar da ni a nan, gama Allah ya aiko ni gabanku ne don in ceci rayuka. ");
INSERT INTO hausa_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Ga shi shekaru biyu ke nan ake yunwa a ƙasar, kuma da sauran shekara biyar masu zuwa da ba za a yi noma ko girbi ba. ");
INSERT INTO hausa_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Amma Allah ya aiko ni gabanku ne don in adana muku raguwa a duniya, in kuma ceci rayukanku ta wurin ceto mai girma. ");
INSERT INTO hausa_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","“Saboda haka fa, ba ku ba ne kuka aiko ni nan, Allah ne. Ya mai da ni mahaifi ga Fir’auna, shugaban dukan gidansa da kuma mai mulkin dukan Masar. ");
INSERT INTO hausa_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Yanzu sai ku gaggauta zuwa wurin mahaifina ku faɗa masa, ‘Abin da ɗanka Yusuf ya ce; Allah ya mai da ni shugaban dukan Masar. Gangaro wurina; kada ka jinkirta. ");
INSERT INTO hausa_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Za ka yi zama a yankin Goshen, ka kasance kusa da ni. Kai, ’ya’yanka da kuma jikokinka, garkunanka da shanunka, da kuma dukan abin da kake da shi. ");
INSERT INTO hausa_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Zan tanada maka a nan, domin akwai saura shekaru biyar na yunwa masu zuwa. In ba haka ba, kai da gidanka da dukan mallakarka za ku zama gajiyayyu.’ ");
INSERT INTO hausa_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","“Ku kanku kun gani, haka ma ɗan’uwana Benyamin, cewa tabbatacce ni ne nake magana da ku. ");
INSERT INTO hausa_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Faɗa wa mahaifina game da dukan girman da aka ba ni a Masar, da kuma game da kome da kuka gani. Ku kuma kawo mahaifina a nan da sauri.” ");
INSERT INTO hausa_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Sa’an nan ya rungume ɗan’uwansa Benyamin ya yi kuka, sai Benyamin ya rungume shi yana kuka. ");
INSERT INTO hausa_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Ya sumbaci dukan ’yan’uwansa, ya kuma yi kuka a kansu. Bayan haka sai ’yan’uwansa suka yi masa magana. ");
INSERT INTO hausa_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Sa’ad da labarin ya kai fadan Fir’auna cewa ’yan’uwan Yusuf sun zo, sai Fir’auna da dukan hafsoshin suka ji daɗi. ");
INSERT INTO hausa_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Fir’auna ya ce wa Yusuf, “Faɗa wa ’yan’uwanka, ‘Yi wannan; ku jibge dabbobinku ku koma zuwa ƙasar Kan’ana, ");
INSERT INTO hausa_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Ku kawo mahaifinku da iyalanku zuwa wurina. Zan ba ku mafi kyau na ƙasar Masar, za ku kuwa ci moriyar ƙasar.’ ");
INSERT INTO hausa_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","“An kuma umarce ka, ka faɗa musu, ‘Ku yi wannan, ku ɗauki wagonu daga Masar domin ’ya’yanku da matanku, ku ɗauki mahaifinku ku zo. ");
INSERT INTO hausa_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Kada ku damu da mallakarku, gama mafi kyau na Masar za su zama naku.’ ” ");
INSERT INTO hausa_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Sai ’ya’yan Isra’ila maza suka yi haka. Yusuf ya ba su wagonu kamar yadda Fir’auna ya umarta, ya kuma ba su guzuri don tafiyarsu. ");
INSERT INTO hausa_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Ya ba da sababbin riguna ga kowannensu amma ga Benyamin ya ba shi shekel ɗari uku na azurfa da riguna kashi biyar. ");
INSERT INTO hausa_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Ga kuma abin da ya aika wa mahaifinsa, jakuna goma da aka jibge da abubuwa mafi kyau na Masar, da jakuna mata guda goma ɗauke da hatsi da burodi da waɗansu tanade-tanade don tafiyarsa. ");
INSERT INTO hausa_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Sa’an nan ya sallami ’yan’uwansa, yayinda suke barin wurin ya ce musu, “Kada ku yi faɗa a hanya!” ");
INSERT INTO hausa_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Saboda haka suka haura, suka fita daga Masar, suka zo wurin maihaifinsu Yaƙub a ƙasar Kan’ana. ");
INSERT INTO hausa_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Suka faɗa masa, “Yusuf yana da rai! Gaskiya, shi ne mai mulkin dukan Masar.” Gaban Yaƙub ya fāɗi, domin bai gaskata su ba. ");
INSERT INTO hausa_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Amma sa’ad da suka faɗa masa kome da Yusuf ya faɗa musu, da kuma sa’ad da ya ga wagonun da Yusuf ya aika don a ɗauke shi a kai da shi can, sai ya farfaɗo, ya dawo cikin hankalinsa. ");
INSERT INTO hausa_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Sai Yaƙub ya ce, “Na yarda! Ɗana Yusuf yana da rai har yanzu. Zan tafi in gan shi kafin in mutu.” ");
INSERT INTO hausa_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Saboda haka Isra’ila ya kama hanya da dukan abin da yake nasa, sa’ad da ya kai Beyersheba, sai ya miƙa hadayu ga Allah na Ishaku, mahaifinsa. ");
INSERT INTO hausa_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Allah kuwa ya yi magana ga Isra’ila a wahayi da dare ya ce, “Yaƙub! Yaƙub!” Yaƙub kuwa ya amsa ya ce, “Ga ni.” ");
INSERT INTO hausa_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Sai Allah ya ce, “Ni ne Allah, Allah na mahaifinka. Kada ka ji tsoron zuwa Masar, gama zan mai da kai al’umma mai girma a can. ");
INSERT INTO hausa_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Zan gangara zuwa Masar tare da kai, tabbatacce zan sāke dawo da kai. Kuma hannun Yusuf zai rufe idanunka.” ");
INSERT INTO hausa_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Sa’an nan Yaƙub ya bar Beyersheba, ’ya’yan Isra’ila maza, suka ɗauki mahaifinsu Yaƙub da ’ya’yansu da matansu a cikin wagonun da Fir’auna ya aika don a kawo shi. ");
INSERT INTO hausa_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Suka kuma ɗauki dabbobinsu da mallakarsu, da suka samu a Kan’ana, Yaƙub kuwa da dukan zuriyarsa suka tafi Masar. ");
INSERT INTO hausa_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Ya ɗauki ’ya’yansa maza da jikokinsa da ’ya’yansa mata da jikokinsa mata, dukan zuriyarsa zuwa Masar. ");
INSERT INTO hausa_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Waɗannan su ne sunayen ’ya’yan Isra’ila maza (Yaƙub da zuriyarsa) waɗanda suka tafi Masar, Ruben ɗan farin Yaƙub. ");
INSERT INTO hausa_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","’Ya’yan Ruben maza su ne, Hanok, Fallu, Hezron da Karmi. ");
INSERT INTO hausa_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","’Ya’yan Simeyon maza su ne, Yemuwel, Yamin, Ohad, Yakin, Zohar da Sha’ul ɗan mutuniyar Kan’ana. ");
INSERT INTO hausa_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","’Ya’yan Lawi maza su ne, Gershon, Kohat da Merari. ");
INSERT INTO hausa_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","’Ya’yan Yahuda maza su ne, Er, Onan, Shela, Ferez da Zera (amma Er da Onan sun mutu a ƙasar Kan’ana). ’Ya’yan Ferez maza su ne, Hezron da Hamul. ");
INSERT INTO hausa_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","’Ya’yan Issakar maza su ne, Tola, Fuwa, Yoshub da Shimron. ");
INSERT INTO hausa_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","’Ya’yan Zebulun maza su ne, Sered, Elon da Yaleyel. ");
INSERT INTO hausa_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Waɗannan su ne ’ya’yan Liyatu maza da ta haifa wa Yaƙub a Faddan Aram, ban da ’yarsa Dina. ’Ya’yansa maza da mata duka, mutum talatin da uku ne. ");
INSERT INTO hausa_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","’Ya’yan Gad maza su ne, Zafon, Haggi, Shuni, Ezbon, Eri, Arodi da Areli. ");
INSERT INTO hausa_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","’Ya’yan Asher maza su ne, Imna, Ishba, Ishbi da Beriya. ’Yar’uwarsu ita ce Sera. ’Ya’yan Beriya maza su ne, Heber da Malkiyel. ");
INSERT INTO hausa_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Waɗannan su ne ’ya’yan da Zilfa ta haifa wa Yaƙub, ita ce Laban ya ba wa ’yarsa Liyatu. ’Ya’yan duka, su sha shida ne. ");
INSERT INTO hausa_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","’Ya’yan Yaƙub maza waɗanda Rahila ta haifa su ne, Yusuf da Benyamin. ");
INSERT INTO hausa_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","A Masar, Asenat ’yar Fotifera, firist na On ta haifi Manasse da Efraim wa Yusuf. ");
INSERT INTO hausa_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","’Ya’yan Benyamin maza su ne, Bela, Beker, Ashbel, Gera, Na’aman, Ehi, Rosh, Muffim, Huffim da Ard. ");
INSERT INTO hausa_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Waɗannan su ne ’ya’yan Rahila maza waɗanda ta haifa wa Yaƙub, dukansu mutum goma sha huɗu ne. ");
INSERT INTO hausa_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Yaron Dan shi ne, Hushim. ");
INSERT INTO hausa_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","’Ya’yan Naftali maza su ne, Yazeyel, Guni, Yezer da Shillem. ");
INSERT INTO hausa_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Waɗannan su ne ’ya’ya mazan da Bilha ta haifa wa Yaƙub, ita ce Laban ya ba wa ’yarsa Rahila. ’Ya’yan suka su bakwai ne. ");
INSERT INTO hausa_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Dukan waɗanda suka tafi Masar tare da Yaƙub, waɗanda suke zuriyarsa kai tsaye ban da matan ’ya’yansa maza, su mutum sittin da shida ne. ");
INSERT INTO hausa_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","In aka haɗa da ’ya’yan nan maza guda biyu waɗanda aka haifa wa Yusuf a Masar, membobin iyalin Yaƙub, waɗanda suka tafi Masar, duka su saba’in ne. ");
INSERT INTO hausa_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","To, Yaƙub ya aiki Yahuda yă yi gaba yă sadu da Yusuf, don yă nuna musu hanyar da za su bi zuwa yankin Goshen. Da suka isa yankin Goshen, ");
INSERT INTO hausa_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","sai Yusuf ya kintsa keken yaƙinsa ya haura zuwa Goshen don yă taryi mahaifinsa, Isra’ila. Nan da nan da isowar Yusuf a wurin mahaifinsa, sai ya rungumi mahaifinsa, ya yi kuka na dogon lokaci. ");
INSERT INTO hausa_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Isra’ila ya ce wa Yusuf, “Yanzu ina a shirye in mutu, da yake na gani da kaina cewa har yanzu kana da rai.” ");
INSERT INTO hausa_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Sa’an nan Yusuf ya ce wa ’yan’uwansa da gidan mahaifinsa, “Zan haura in yi magana da Fir’auna, zan kuwa ce masa, ‘’Yan’uwana da gidan mahaifina, waɗanda suke zaune a ƙasar Kan’ana, sun zo wurina. ");
INSERT INTO hausa_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Mutanen fa, makiyaya ne; suna kiwon dabbobi, sun kuma zo tare da garkunansu da shanunsa da kuma kome da suka mallaka.’ ");
INSERT INTO hausa_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Sa’ad da Fir’auna ya kira ku ciki, ya yi tambaya, ‘Mece ce sana’arku?’ ");
INSERT INTO hausa_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Ku amsa, ‘Bayinka suna kiwon dabbobi ne, tun muna samari har zuwa yanzu, kamar yadda kakanninmu suka yi.’ Ta haka za a bar ku ku zauna a yankin Goshen, gama Masarawa suna ƙyamar makiyaya.” ");
INSERT INTO hausa_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Yusuf ya tafi yă faɗa wa Fir’auna, “Mahaifina da ’yan’uwana, tare da garkunansu da shanunsu da kome da suke da shi, sun zo daga ƙasar Kan’ana, suna kuwa a Goshen yanzu.” ");
INSERT INTO hausa_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Sai ya zaɓi mutum biyar daga cikin ’yan’uwansa, ya gabatar da su a gaban Fir’auna. ");
INSERT INTO hausa_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Fir’auna ya tambayi ’yan’uwan, “Mece ce sana’arku?” Suka amsa wa Fir’auna suka ce, “Bayinka makiyaya ne, kamar yadda kakanninmu suke.” ");
INSERT INTO hausa_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Suka kuma ce masa, “Mun zo, mu zauna a nan na ɗan lokaci, gama yunwa ta yi tsanani a Kan’ana, dabbobin bayinka kuma ba su da wurin kiwo. Saboda haka yanzu, muna roƙonka, bari bayinka su zauna a Goshen.” ");
INSERT INTO hausa_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Fir’auna ya ce wa Yusuf, “Mahaifinka da ’yan’uwanka sun zo maka, ");
INSERT INTO hausa_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","ƙasar Masar kuma tana gabanka, ka zaunar da mahaifinka da ’yan’uwanka a sashe mafi kyau na ƙasar, bari su zauna a Goshen. Idan kuma ka ga waɗansu a cikinsu da suka fi dacewa, sai ka sa su lura mini da shanuna.” ");
INSERT INTO hausa_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Sa’an nan Yusuf ya shigar da Yaƙub mahaifinsa, ya gabatar da shi a gaban Fir’auna. Bayan Yaƙub ya albarkaci Fir’auna, ");
INSERT INTO hausa_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","sai Fir’auna ya tambaye shi, “Shekarunka nawa da haihuwa?” ");
INSERT INTO hausa_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yaƙub kuwa ya ce wa Fir’auna, “Shekarun hijirata, shekaru ɗari da talatin ne. Shekaruna kaɗan ne cike da wahala, ba za a kuwa daidaita su da shekarun hijirar kakannina ba.” ");
INSERT INTO hausa_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Sai Yaƙub ya albarkaci Fir’auna, ya yi masa bankwana, sa’an nan ya fita. ");
INSERT INTO hausa_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Ta haka Yusuf ya zaunar da mahaifinsa da ’yan’uwansa a Masar, ya ba su mallaka a sashe mafi kyau na ƙasar, a yankin nan na Rameses, kamar yadda Fir’auna ya umarta. ");
INSERT INTO hausa_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Yusuf ya kuma tanada wa mahaifinsa da kuma ’yan’uwansa da dukan gidan mahaifinsa, abinci bisa ga yawan ’ya’yansu. ");
INSERT INTO hausa_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","A yanzu, a cikin ƙasar duka, ba abinci, gama yunwa ta yi tsanani ƙwarai, har ƙasar Masar da ƙasar Kan’ana suka shiga matsananciyar wahala! ");
INSERT INTO hausa_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Yusuf ya tattara dukan kuɗaɗen da suke a Masar da Kan’ana don biyan hatsin da suke saya, ya kuwa kawo su a fadan Fir’auna. ");
INSERT INTO hausa_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Sa’ad da kuɗin mutanen Masar da Kan’ana suka ƙare, dukan Masar ta zo wurin Yusuf ta ce, “Ka ba mu abinci. Me zai sa mu mutu a idanunka? Kuɗinmu duk sun ƙare.” ");
INSERT INTO hausa_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Yusuf ya ce, “To, ku kawo dabbobinku, zan sayar muku da abinci a madadin dabbobinku, tun da kuɗinku ya ƙare.” ");
INSERT INTO hausa_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Saboda haka suka kawo dabbobinsu wa Yusuf, ya kuma ba su abinci a madadin dawakai, tumaki da awaki, shanu da jakunansu. Ya kuwa ba su abinci a madadin dabbobinsu, a wannan shekara. ");
INSERT INTO hausa_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Sa’ad da wannan shekara ta ƙare, sai suka zo wurinsa a shekara ta biye suka ce, “Ba za mu ɓoye maka ba ranka yă daɗe, kuɗinmu sun ƙare, dabbobinmu kuma sun zama naka. Ranka yă daɗe, in ban da jikunanmu da gonakinmu, ba abin da ya rage mana. ");
INSERT INTO hausa_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Kada ka bar mu mu mutu, ka yi wata dabara! Kada ka bari mu rasa gonakinmu. Ka musaye mu da abinci, mu da gonakinmu. Mu kuwa za mu zama bayin Fir’auna. Ka ba mu iri don mu rayu, kada mu mutu, don kuma kada gonakin ƙasarmu su zama kango.” ");
INSERT INTO hausa_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Ta haka Yusuf ya saya wa Fir’auna ƙasar Masar duka, gama Masarawa duka sun sayar da gonakinsu, saboda yunwa ta tsananta musu. Ƙasar ta zama mallakar Fir’auna. ");
INSERT INTO hausa_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Yusuf kuwa ya mai da mutanen bayi, daga wannan iyakar Masar zuwa wancan. ");
INSERT INTO hausa_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Amma bai sayi gonakin firistoci ba, gama suna karɓa rabo daga Fir’auna ne, suna kuma da isashen abinci daga rabon da Fir’auna yake ba su. Dalilin ke nan da ba su sayar da gonakinsu ba. ");
INSERT INTO hausa_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Yusuf ya ce wa mutane, “Yanzu da na saye ku da kuma gonakinku a yau wa Fir’auna, ga iri don ku shuka a gonaki. ");
INSERT INTO hausa_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Amma sa’ad da hatsi suka nuna, za ku ba da kashi ɗaya bisa biyar ga Fir’auna. Sauran kashi huɗu bisa biyar kuma ku riƙe a matsayin iri don gonaki da kuma abinci wa kanku da gidajenku da kuma ’ya’yanku.” ");
INSERT INTO hausa_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Suka ce, “Ka ceci rayukanmu, in ya gamshe ka, ranka yă daɗe, za mu zama bayin Fir’auna.” ");
INSERT INTO hausa_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Ta haka Yusuf ya kafa wannan ya zama doka game da ƙasa a Masar, har yă zuwa yau cewa kashi ɗaya bisa biyar na amfani gona ya zama na Fir’auna. Gonakin firistoci ne kaɗai ba su zama na Fir’auna ba. ");
INSERT INTO hausa_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","To, Isra’ilawa suka zauna a Masar a yankin Goshen. Suka mallaki filaye a can, suka riɓaɓɓanya suka ƙaru ƙwarai. ");
INSERT INTO hausa_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yaƙub ya yi zama a Masar shekaru goma sha bakwai, yawan shekarunsa duka sun zama ɗari da arba’in da bakwai. ");
INSERT INTO hausa_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Sa’ad da lokaci ya gabato da Isra’ila zai mutu, sai ya kira ɗansa Yusuf, ya ce masa, “Ka yi mini wannan alheri, ka sa hannunka ƙarƙashin cinyar ƙafata, ka yi mini alkawari saboda ina roƙonka kaɗa ka bizne ni a Masar, ");
INSERT INTO hausa_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","amma sa’ad da na huta da kakannina, ka ɗauke ni, ka fid da ni daga Masar, ka binne ni a inda aka binne su.” Yusuf ya ce, “Zan yi yadda ka faɗa.” ");
INSERT INTO hausa_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Yaƙub ya ce, “Ka rantse mini.” Sai Yusuf ya rantse masa, Isra’ila kuwa ya yi godiya ga Allah yayinda ya jingina a kan sandansa. ");
INSERT INTO hausa_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Bayan wani lokaci aka faɗa wa Yusuf, “Mahaifinka yana ciwo.” Sai ya ɗauki ’ya’yansa maza biyu, Manasse da Efraim suka tafi tare da shi. ");
INSERT INTO hausa_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Sa’ad da aka faɗa wa Yaƙub, “Ɗanka Yusuf ya zo gare ka,” sai Isra’ila ya ƙoƙarta ya tashi ya zauna a kan gado. ");
INSERT INTO hausa_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Yaƙub ya ce wa Yusuf, “Allah Maɗaukaki ya bayyana gare ni a Luz a ƙasar Kan’ana, a can ya albarkace ni ");
INSERT INTO hausa_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","ya kuma ce mini, ‘Zan sa ka yi ta haihuwa ka kuma riɓaɓɓanya, za ka ƙaru a yawa. Zan mai da kai al’ummar mutane, zan kuma ba ka wannan ƙasa tă zama madawwamiyar mallaka ga zuriyarka a bayanka.’ ");
INSERT INTO hausa_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","“To, yanzu, ’ya’ya mazanka biyu da aka haifa maka a Masar kafin in zo a nan za su zama nawa; Efraim da Manasse za su zama nawa, kamar yadda Ruben da Simeyon suke nawa. ");
INSERT INTO hausa_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Duk waɗansu ’ya’yan da aka haifa maka bayansu za su zama naka; a yankin da suka gāda za a lissafa a ƙarƙashin sunayen ’yan’uwansu. ");
INSERT INTO hausa_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Yayinda nake dawowa daga Faddan Aram, cikin baƙin cikina Rahila ta rasu a ƙasar Kan’ana yayinda muke kan hanya, ’yar rata daga Efrata. Saboda haka na binne ta a can kusa da hanya zuwa Efrata” (wato, Betlehem). ");
INSERT INTO hausa_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Sa’ad da Isra’ila ya ga ’ya’yan Yusuf maza, sai ya yi tambaya, “Su wane ne waɗannan?” ");
INSERT INTO hausa_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yusuf ya ce wa mahaifinsa, “Su ne ’ya’yan da Allah ya ba ni a nan.” Sa’an nan Isra’ila ya ce, “Kawo mini su saboda in albarkace su.” ");
INSERT INTO hausa_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Yanzu fa idanun Isra’ila sun fara rasa ƙarfi saboda tsufa, har ba ya iya gani sosai. Saboda haka Yusuf ya kawo ’ya’yansa maza kusa da shi, sai mahaifinsa ya sumbace su ya rungume su. ");
INSERT INTO hausa_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Isra’ila ya ce wa Yusuf, “Ban yi tsammani zan ga fuskarka kuma ba, yanzu kuwa Allah ya bar ni in ga ’ya’yanka su ma.” ");
INSERT INTO hausa_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Sa’an nan Yusuf ya ɗauke su daga gwiwoyin Isra’ila ya rusuna da fuskarsa har ƙasa. ");
INSERT INTO hausa_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Yusuf ya ɗauke su biyu, Efraim a damansa zuwa hagun Isra’ila, Manasse kuma a hagunsa zuwa hannun daman Isra’ila, ya kuma kawo su kusa da shi. ");
INSERT INTO hausa_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Amma Isra’ila ya miƙa hannun damansa ya sa shi a kan Efraim, ko da yake shi ne ƙaramin, ta wurin harɗewa hannuwansa, ya sa hannun hagunsa a kan Manasse, ko da yake Manasse ne ɗan farinsa. ");
INSERT INTO hausa_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Sa’an nan ya albarkaci Yusuf ya ce, “Bari Allah a gaban wanda kakannina Ibrahim da Ishaku suka yi tafiya, Allahn da ya zama makiyayina dukan raina zuwa wannan rana, ");
INSERT INTO hausa_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Mala’ikan da ya cece ni daga dukan cuta bari yă albarkaci samarin nan. Bari a kira su da sunana da sunayen kakannina Ibrahim da Ishaku bari kuma su ƙaru ƙwarai a bisa duniya.” ");
INSERT INTO hausa_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Sa’ad da Yusuf ya ga mahaifinsa yana sa hannun damansa a kan Efraim bai ji daɗi ba; saboda haka ya ɗauke hannun mahaifinsa ya cire shi daga kan Efraim zuwa kan Manasse. ");
INSERT INTO hausa_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Yusuf ya ce masa, “A’a, mahaifina, wannan shi ne ɗan farin; ka sa hannunka na dama a kansa.” ");
INSERT INTO hausa_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Amma mahaifinsa ya ƙi ya ce, “Na sani, ɗana, na sani. Shi ma zai zama mutane, zai kuma zama mai girma. Duk da haka ɗan’uwansa zai zama mai girma fiye da shi, kuma zuriyarsa za tă zama ƙungiyar al’ummai.” ");
INSERT INTO hausa_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Ya albarkace su a wannan rana ya ce, “A cikin sunanku Isra’ila zai sa wannan albarka ‘Bari Allah yă sa ku zama kamar Efraim da Manasse.’ ” Saboda haka ya sa Efraim gaban Manasse. ");
INSERT INTO hausa_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Sa’an nan Isra’ila ya ce wa Yusuf, “Ina gab da mutuwa, amma Allah zai kasance tare da ku ");
INSERT INTO hausa_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Kuma gare ka, a matsayi wanda yake kan ’yan’uwanka, na ba da gonar da na karɓe daga Amoriyawa da takobi da kuma bakana.” ");
INSERT INTO hausa_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Sai Yaƙub ya kira ’ya’yansa maza ya ce, “Ku tattaru don in faɗa muku abin da zai faru gare ku, a kwanaki masu zuwa. ");
INSERT INTO hausa_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“Ku tattaru, ku saurara, ’ya’yan Yaƙub maza; ku saurari mahaifinku, Isra’ila. ");
INSERT INTO hausa_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“Ruben, kai ne ɗan farina, ƙarfina, alamar farko ta ƙarfina, mafi matsayi, kuma mafi iko. ");
INSERT INTO hausa_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Mai tumbatsa kamar ruwa, amma ba za ka ƙara zama mai daraja ba, gama ka hau gadon mahaifinka ka hau kujerata, ka kuma ƙazantar da shi. ");
INSERT INTO hausa_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Simeyon da Lawi ’yan’uwa ne, takubansu makamai ne na tā da hankali. ");
INSERT INTO hausa_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Ba zan shiga shawararsu ba, ba zan shiga taronsu ba, gama sun kashe maza cikin fushinsu cikin ganin dama suka kashe bijimai. ");
INSERT INTO hausa_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","La’ananne ne fushinsu, mai tsanani ne ƙwarai, hasalarsu kuwa, muguwa ce ƙwarai! Zan warwatsa su cikin Yaƙub in kuma daidaita su cikin Isra’ila. ");
INSERT INTO hausa_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Yahuda, ’yan’uwanka za su yabe ka; hannuwanka za su kasance a wuyan abokan gābanka, ’ya’yan mahaifinka maza za su rusuna maka. ");
INSERT INTO hausa_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Kai ɗan zaki ne, ya Yahuda, ka dawo daga farauta, ɗana. Kamar zaki, yakan kwanta a miƙe, kamar zakanya, wa yake da ƙarfin halin tashe shi? ");
INSERT INTO hausa_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Kursiyi ba zai tashi daga Yahuda ba, ba kuwa sandan mulki daga tsakani ƙafafunsa ba, sai ya zo ga wanda yake mai shi. Biyayyar al’umma kuwa tasa ce. ");
INSERT INTO hausa_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Zai daure jakinsa a kuringa, aholakinsa a rassa mafi kyau; zai wanke tufafinsa cikin ruwan inabi rigunansa cikin inabi ja wur kamar jini. ");
INSERT INTO hausa_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Idanunsa za su duhunce fiye da ruwan inabi, haƙorarsa farare kamar madara. ");
INSERT INTO hausa_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Zebulun zai zauna a bakin teku, yă zama tasar jiragen ruwa; iyakarsa za tă nausa zuwa Sidon. ");
INSERT INTO hausa_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“Issakar doki mai ƙarfi, kwance tsakanin buhunan sirdi. ");
INSERT INTO hausa_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Sa’ad da ya ga yadda wurin hutunsa yana da kyau da kuma daɗin da ƙasarsa take, zan tanƙware kafaɗarsa ga nauyi yă miƙa kai ga aikin dole. ");
INSERT INTO hausa_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Dan zai tanada adalci wa mutanensa kamar ɗaya cikin kabilan Isra’ila. ");
INSERT INTO hausa_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan zai zama maciji a gefen hanya, kububuwa a bakin hanya, da take saran ɗiɗɗigen doki domin mahayinsa yă fāɗi da baya. ");
INSERT INTO hausa_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“Ina zuba ido ga cetonka, ya Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“Masu fashi za su fāɗa wa Gad, amma zai runtume su. ");
INSERT INTO hausa_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“Abincin Asher zai zama a wadace, zai yi tanadin abinci iri-iri da suka dace don sarki. ");
INSERT INTO hausa_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Naftali sakakkiyar barewa ce da take haihuwar kyawawan ’ya’ya. ");
INSERT INTO hausa_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Yusuf kuringa ce mai ba da amfani. Kuringa mai ba da amfani kusa da rafi wadda rassanta na hawan bango. ");
INSERT INTO hausa_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Da ɗaci rai mahara suka fāɗa masa; suka harbe shi babu tausayi. ");
INSERT INTO hausa_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Amma bakansa yana nan daram hannuwansa masu ƙarfi ba sa jijjiguwa saboda hannun Maɗaukaki na Yaƙub, saboda Makiyayi, Dutsen Isra’ila, ");
INSERT INTO hausa_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","saboda Allah na mahaifinka, wanda ya taimake ka, saboda Maɗaukaki, wanda yake albarkace ka da albarkar sama da take bisa albarkun zurfafa da suke ƙarƙashin ƙasa albarkun mama da kuma mahaifa. ");
INSERT INTO hausa_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Albarkun mahaifi suna da girma fiye da albarkun daɗaɗɗun duwatsu fiye da yalwar madawwaman tuddai. Bari dukan waɗannan su zauna a kan Yusuf, a goshin ɗan sarki a cikin ’yan’uwansa. ");
INSERT INTO hausa_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“Benyamin kyarkeci ne mai kisa; da safe yakan cinye abin da ya farauto da yamma yakan raba ganima.” ");
INSERT INTO hausa_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Dukan waɗannan su ne kabilu goma sha biyu na Isra’ila, kuma abin da mahaifinsu ya faɗa musu ke nan sa’ad da ya albarkace su, yana ba kowane albarkar da ta dace da shi. ");
INSERT INTO hausa_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Sa’an nan ya ba su waɗannan umarnai ya ce, “Ina gab da a tara ni ga mutanena. Ku binne ni tare da kakannina a kogon da yake cikin filin Efron mutumin Hitti, ");
INSERT INTO hausa_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","kogon da yake cikin filin Makfela, kusa da Mamre a Kan’ana, wanda Ibrahim ya saya tare da filin, yă zama makabarta daga Efron mutumin Hitti. ");
INSERT INTO hausa_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","A can aka binne Ibrahim da matarsa Saratu, a can aka binne Ishaku da matarsa Rebeka, a can kuma na binne Liyatu. ");
INSERT INTO hausa_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Filin tare da kogon da yake ciki, an saya daga Hittiyawa.” ");
INSERT INTO hausa_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Sa’ad da Yaƙub ya gama ba da umarnan ga ’ya’yansa maza, sai ya ɗaga ƙafafunsa zuwa gado, ya ja numfashinsa na ƙarshe, aka kuwa tara shi ga mutanensa. ");
INSERT INTO hausa_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Yusuf kuwa ya fāɗa a kan mahaifinsa, ya yi kuka a kansa, ya kuma sumbace shi. ");
INSERT INTO hausa_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Sa’an nan Yusuf ya umarci masu maganin da suke yin masa hidima, su shafe mahaifinsa Isra’ila da maganin hana ruɓa. Saboda haka masu maganin suka shafe shi da maganin hana ruɓa. ");
INSERT INTO hausa_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Suka ɗauki kwana arba’in cif suna yin wannan, gama kwanakin da ake bukata ke nan don shafewa da maganin hana ruɓa. Masarawa kuwa suka yi makoki dominsa kwana saba’in. ");
INSERT INTO hausa_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Sa’ad da kwanakin makoki suka wuce, sai Yusuf ya ce wa iyalin gidan Fir’auna, “In na sami tagomashi a idanunku, ku yi magana da Fir’auna domina. Ku faɗa masa, ");
INSERT INTO hausa_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Mahaifina ya sa na yi rantsuwa, ya kuma ce, “Ina gab da mutuwa, ka binne ni a kabarin da na haƙa wa kaina a ƙasar Kan’ana.” Yanzu fa bari in haura in binne mahaifina, sa’an nan in dawo.’ ” ");
INSERT INTO hausa_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Fir’auna ya ce, “Haura ka binne mahaifinka, kamar yadda ya sa ka rantse za ka yi.” ");
INSERT INTO hausa_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Saboda haka Yusuf ya haura don yă binne mahaifinsa. Dukan hafsoshin Fir’auna suka yi masa rakiya tare da manyan mutanen gidan Fir’auna, da kuma dukan manyan mutanen Masar ");
INSERT INTO hausa_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","da kuma dukan membobin gidan Yusuf, da ’yan’uwansa da kuma waɗanda suke na gidan mahaifinsa. Yara kaɗai da garkunansu da kuma shanunsu ne aka bari a Goshen. ");
INSERT INTO hausa_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Kekunan yaƙi da mahayan dawakai su ma suka haura tare da shi. Babbar ƙungiya jama’a ce ƙwarai. ");
INSERT INTO hausa_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Sa’ad da suka kai masussukar Atad, kusa da Urdun, sai suka yi kuka da ƙarfi da kuma mai zafi, a can Yusuf ya yi makoki kwana bakwai saboda mahaifinsa. ");
INSERT INTO hausa_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Sa’ad da Kan’aniyawa waɗanda suke zama a can suka ga makokin a masussukan Atad, sai suka ce, “Masarawa suna bikin makoki na musamman.” Shi ya sa ake kira wannan wurin da yake kusa da Urdun, Abel-Mizrayim. ");
INSERT INTO hausa_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Haka fa ’ya’yan Yaƙub maza suka yi yadda ya umarce su. ");
INSERT INTO hausa_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Suka ɗauke shi zuwa ƙasar Kan’ana suka kuma binne shi a kogon da yake cikin filin Makfela, kusa da Mamre, wanda Ibrahim ya saya tare da filin, ya zama makabarta daga Efron mutumin Hitti. ");
INSERT INTO hausa_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Bayan ya binne mahaifinsa, sai Yusuf ya koma Masar, tare da ’yan’uwansa da kuma dukan waɗanda suka tafi tare da shi don binne mahaifinsa. ");
INSERT INTO hausa_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Sa’ad da ’yan’uwan Yusuf suka ga cewa mahaifinsu ya mutu, sai suka ce, “Mai yiwuwa Yusuf yana riƙe da mu a zuciya, wataƙila zai rama dukan abubuwa marasa kyau da muka yi masa?” ");
INSERT INTO hausa_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Saboda haka suka aika wa Yusuf suna cewa, “Mahaifinka ya bar waɗannan umarnai kafin yă rasu. ");
INSERT INTO hausa_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","Ga abin da za ku ce wa Yusuf, ‘Na roƙe ka, ka gafarta wa ’yan’uwanka zunubai da laifofin da suka aikata na abubuwa marasa kyau da suka yi maka.’ Yanzu muna roƙonka ka gafarta zunuban bayin Allah na mahaifinka.” Sa’ad da saƙonsu ya zo masa, sai Yusuf ya yi kuka. ");
INSERT INTO hausa_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","’Yan’uwansa kuwa suka zo suka fāɗi a gabansa suka ce, “Mu bayinka ne.” ");
INSERT INTO hausa_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Amma Yusuf ya ce musu, “Kada ku ji tsoro. Ni Allah ne? ");
INSERT INTO hausa_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Kun yi niyya ku yi mini lahani, amma Allah ya nufe wannan ya zama alheri don yă cika abin da yanzu yake faruwa, ceton rayuka masu yawa. ");
INSERT INTO hausa_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Saboda haka, kada ku ji tsoro. Zan tanada muku da kuma ’ya’yanku.” Ya sāke tabbatar musu, ya kuma yi musu magana ta alheri. ");
INSERT INTO hausa_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Yusuf ya zauna a Masar tare da dukan iyalin mahaifinsa. Ya rayu shekara ɗari da goma. ");
INSERT INTO hausa_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Ya kuma ga tsara ta uku ta ’ya’yan Efraim. Haka ma ’ya’yan Makir ɗan Manasse, an haife su aka sa a gwiwoyin Yusuf. ");
INSERT INTO hausa_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Sai Yusuf ya ce wa ’yan’uwansa, “Ina gab da mutuwa. Amma tabbatacce Allah zai taimake ku, yă fid da ku daga wannan ƙasa zuwa ƙasar da ya alkawarta da rantsuwa wa Ibrahim, Ishaku da kuma Yaƙub.” ");
INSERT INTO hausa_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Yusuf kuwa ya sa ’ya’yan Isra’ila maza suka yi rantsuwa, ya kuma ce, “Tabbatacce Allah zai taimake ku, ku kuma dole ku ɗauki ƙasusuwana, ku haura da su daga wannan wuri.” ");
INSERT INTO hausa_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Yusuf kuwa ya rasu yana da shekara ɗari da goma. Bayan an shafe shi da maganin hana ruɓa, sai aka sa shi a akwatin gawa a Masar.");
INSERT INTO hausa_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Waɗannan su ne sunayen ’ya’yan Isra’ila maza, waɗanda suka tafi Masar tare da Yaƙub; kowanne da iyalinsa. ");
INSERT INTO hausa_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Ruben, Simeyon, Lawi da Yahuda; ");
INSERT INTO hausa_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Issakar, Zebulun da Benyamin; ");
INSERT INTO hausa_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan da Naftali; Gad da Asher. ");
INSERT INTO hausa_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Zuriyar Yaƙub duka sun kai mutum saba’in. Yusuf ya riga ya kasance a Masar. ");
INSERT INTO hausa_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Yanzu Yusuf da dukan ’yan’uwansa da kuma dukan tsaran nan da suka tafi Masar, sun mutu, ");
INSERT INTO hausa_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","amma Isra’ilawa sun riɓaɓɓanya, suka kuma yi ta haihuwa sosai, suka yi yawan sosai, har ƙasar ta cika da su. ");
INSERT INTO hausa_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Sai wani sabon sarki wanda bai san Yusuf ba, ya hau sarautar Masar. ");
INSERT INTO hausa_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Ya ce wa mutanensa, “Duba Isra’ilawa sun yi yawa, sun fi ƙarfinmu. ");
INSERT INTO hausa_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Ku zo, mu yi dabara a kansu, in ba haka ba za su ƙaru fiye da haka, in kuwa yaƙi ya tashi tsakaninmu da abokan gāba, za su iya haɗa kai da abokan gāba, su yaƙe mu, su bar ƙasar.” ");
INSERT INTO hausa_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Saboda haka sai suka naɗa shugabannin gandu a kansu don su wahalshe su, su kuma bauta musu, suka sa su suka gina biranen Fitom da Rameses su zama biranen ajiya, domin Fir’auna. ");
INSERT INTO hausa_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Amma duk da wannan ƙarin wulaƙancin da ake yi musu, su kuwa sai daɗa riɓaɓɓanya suke ta yi. Sai tsoron Isra’ilawa ya ƙaru a zuciyar Masarawa, ");
INSERT INTO hausa_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","ganin haka sai Masarawa suka ƙara musu wahala. ");
INSERT INTO hausa_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Suka baƙanta wa Isra’ilawa rai da bauta mai wuya, ta wurin sa su yin tubali da yumɓu, da kuma kowace irin bauta a gonaki. A cikin dukan ayyukansu, Masarawa ba su ji tausayinsu ba ko kaɗan. ");
INSERT INTO hausa_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Sai Sarkin Masar ya gaya wa ungozomomin matan Ibraniyawa, wato, su Shofra da Fuwa ya ce, ");
INSERT INTO hausa_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“Sa’ad da kuke taimakon matan Ibraniyawa lokacin haihuwa, in jaririn namiji ne ku kashe shi, amma in ta mace ce, ku bar ta da rai.” ");
INSERT INTO hausa_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Amma ungozomomin nan masu tsoron Allah ne, ba su kuwa aikata abin da sarkin Masar ya gaya musu ba; suka bar jarirai maza su rayu. ");
INSERT INTO hausa_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Sai sarkin Masar ya kira ungozomomin, ya tambaye su ya ce, “Don me kuka yi haka? Don me kuka bar jarirai maza su rayu?” ");
INSERT INTO hausa_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Ungozoman suka amsa wa Fir’auna suka ce, “Ai, matan Ibraniyawa ba kamar matan Masarawa ba ne, gwarzaye ne, sukan haihu kafin ungozomomin su kai wurinsu.” ");
INSERT INTO hausa_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Saboda haka Allah ya nuna alheri wa ungozomomin, Isra’ilawa kuwa suka yi yawa fiye da dā. ");
INSERT INTO hausa_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Saboda ungozomomin suna tsoron Allah, sai Allah ya ba su iyalan kansu. ");
INSERT INTO hausa_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Sai Fir’auna ya ba da umarni wa mutanensa ya ce, “Duk yaron da yake namijin da haka haifa, dole ku jefa shi cikin kogi, amma ku bar yara mata su rayu.” ");
INSERT INTO hausa_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Ana nan, sai wani Balawe ya auri wata Balawiya, ");
INSERT INTO hausa_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","ta kuwa yi ciki, ta haifi ɗa. Sa’ad da ta ga jaririn kyakkyawa ne, sai ta ɓoye shi har watanni uku. ");
INSERT INTO hausa_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Amma da ba tă iya ɓoye shi kuma ba, sai ta yi kwandon kyauro ta shafa masa kwalta. Bayan haka sai ta sa jaririn a cikin kwandon, ta je ta ajiye kwandon tare da jaririn a cikin kyauro, a bakin kogin. ");
INSERT INTO hausa_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","’Yar’uwarsa ta tsaya da ɗan rata tana lura da abin da zai faru da shi. ");
INSERT INTO hausa_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Sai ’yar Fir’auna ta gangara zuwa kogi domin tă yi wanka, bayinta kuwa suna tafiya a bakin kogi. Sai ta ga kwandon a ciyawa, ta aiki ɗaya daga cikin masu hidimarta tă ɗauko mata. ");
INSERT INTO hausa_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Da ta buɗe kwandon, sai ta ga yaro yana kuka, ta kuwa ji tausayinsa. Ta ce, “Wannan ɗaya daga cikin jariran Ibraniyawa ne.” ");
INSERT INTO hausa_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Sai ’yar’uwarsa ta tambayi ’yar Fir’auna, ta ce, “In tafi in samo ɗaya daga cikin matan Ibraniyawa tă yi miki renon yaron?” ");
INSERT INTO hausa_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Sai ta amsa ta ce, “I, tafi.” Sai yarinyar ta tafi ta kawo mahaifiyar yaron. ");
INSERT INTO hausa_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Diyar Fir’auna ta ce mata, “Ɗauki jaririn, ki yi mini renonsa, zan kuwa biya ki.” Saboda haka ta ɗauki yaron, ta yi renonsa. ");
INSERT INTO hausa_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Sa’ad da ya yi girma, sai ta kawo shi wajen ’yar Fir’auna, ya kuwa zama ɗanta, ta kuma ba shi suna Musa, tana cewa, “Na tsamo shi daga ruwa.” ");
INSERT INTO hausa_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Wata rana, bayan Musa ya yi girma, sai ya haura, ya tafi inda mutanensa suke, ya kuma ga yadda suke shan wahala da aiki. Ya ga wani mutumin Masar yana dūkan mutumin Ibraniyawa, ɗaya daga cikin mutanensa. ");
INSERT INTO hausa_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Da ya leƙa nan da can bai kuwa ga kowa ba, sai ya kashe mutumin Masar, ya ɓoye shi a yashi. ");
INSERT INTO hausa_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Kashegari ya fita, sai ya ga Ibraniyawa biyu suna faɗa. Ya tambayi mai laifin ya ce, “Don me kake bugun ɗan’uwanka, mutumin Ibraniyawa?” ");
INSERT INTO hausa_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Mutumin ya ce masa, “Wa ya mai da kai mai mulki da mai hukunci a kanmu? Kana so ne ka kashe ni kamar yadda ka kashe mutumin Masar nan?” Sai Musa ya tsorata, ya yi tunani ya ce, “To, fa, abin nan da na yi, ya zama sananne.” ");
INSERT INTO hausa_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Da Fir’auna ya ji wannan, sai ya yi ƙoƙari yă kashe Musa, amma Musa ya gudu daga wajen Fir’auna, ya tafi ƙasar Midiyan inda ya zauna kusa da wata rijiya. ");
INSERT INTO hausa_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","To, fa, akwai wani firist na Midiyan, yana da ’ya’ya mata bakwai, suka zo su shayar da dabbobin mahaifinsu. ");
INSERT INTO hausa_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Sai waɗansu makiyaya suka zo suka kore su, amma Musa ya tashi ya taimake su ya shayar da dabbobinsu. ");
INSERT INTO hausa_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Da ’yan matan suka komo wurin Reyuwel mahaifinsu, sai ya tambaye su ya ce, “Yaya kuka dawo da wuri yau?” ");
INSERT INTO hausa_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Suka amsa suka ce, “Wani mutumin Masar ne ya taimake mu daga hannun waɗansu makiyaya. Har ma ya ɗebo ruwa ya shayar da dabbobin.” ");
INSERT INTO hausa_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Ya tambayi ’yan matansa, “To ina yake? Don me kuka bar shi a can? A gayyace shi, yă zo, yă ci wani abu.” ");
INSERT INTO hausa_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Musa ya yarda yă zauna da mutumin wanda ya ba da ’yarsa Ziffora aure da Musa. ");
INSERT INTO hausa_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Ziffora ta haifi wa Musa ɗa, ya kuma raɗa masa suna Gershom cewa, “Na zama baƙo a baƙuwar ƙasa.” ");
INSERT INTO hausa_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Ana nan dai, a kwana a tashi, sai sarkin Masar ya mutu. Isra’ilawa suka yi kuka mai zafi saboda bautarsu mai wuya, sai kukar neman taimakonsu saboda bauta, ya kai wurin Allah. ");
INSERT INTO hausa_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Allah kuwa ya ji kukansu sai ya tuna da alkawarinsa da Ibrahim da Ishaku da Yaƙub. ");
INSERT INTO hausa_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Sai Allah ya dubi Isra’ilawa, ya kuma damu da su. ");
INSERT INTO hausa_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Ana nan wata rana Musa yana kiwon tumakin Yetro surukinsa, firist na Midiyan, sai ya bi da tumaki zuwa gefe mai nisa a cikin hamada, har ya zo Horeb, dutsen Allah. ");
INSERT INTO hausa_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","A can mala’ikan Ubangiji ya bayyana a gare shi cikin harshen wuta, a ƙaramin itace. Musa ya lura cewa ko da yake wuta na ci ƙaramin itacen, amma bai ƙone ba. ");
INSERT INTO hausa_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Sai Musa ya ce, “Wannan abin mamaki ne, don me wannan itace bai ƙone ba? Bari in matso kusa in gani.” ");
INSERT INTO hausa_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Da Ubangiji ya ga Musa ya matso don yă duba, sai Allah ya yi kira daga cikin ƙaramin itacen ya ce, “Musa! Musa!” Sai Musa ya amsa ya ce, “Ga ni.” ");
INSERT INTO hausa_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Allah ya ce, “Kada ka zo kusa, tuɓe takalmanka, gama inda kake tsaye, wuri ne mai tsarki.” ");
INSERT INTO hausa_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Sai Allah ya ce, “Ni ne Allah na kakanninka, Allah na Ibrahim, Allah na Ishaku da kuma Allah na Yaƙub.” Da jin wannan, sai Musa ya ɓoye fuskarsa, domin ya ji tsoro yă dubi Allah. ");
INSERT INTO hausa_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Ubangiji ya ce, “Tabbatacce na ga azabar mutanena a Masar. Na ji su suna kuka saboda matsin da shugabannin gandunsu suke musu, na kuma damu da wahalarsu. ");
INSERT INTO hausa_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Saboda haka na sauko domin in cece su daga hannun Masarawa, in kuma fitar da su daga ƙasar Masar, in kai su ƙasa mai kyau mai fāɗi, ƙasa mai zub da madara da zuma, inda Kan’aniyawa, Hittiyawa, Amoriyawa, Ferizziyawa, Hiwiyawa da Yebusiyawa suke. ");
INSERT INTO hausa_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Yanzu kukan Isra’ilawa ya kai gare ni, na kuma ga yadda Masarawa suke wulaƙanta su ");
INSERT INTO hausa_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","To, fa, sai ka tafi. Ina aikan ka wurin Fir’auna don ka fitar da mutanena Isra’ilawa daga Masar.” ");
INSERT INTO hausa_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Amma Musa ya ce wa Allah, “Wane ni in tafi wurin Fir’auna, in kuma fitar da Isra’ilawa daga Masar?” ");
INSERT INTO hausa_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Sai Allah ya ce, “Zan kasance da tare kai. Wannan kuwa za tă zama alama a gare ka cewa Ni na aike ka. Bayan ka fitar da mutanen daga Masar, za ku yi sujada ga Allah a kan dutsen nan.” ");
INSERT INTO hausa_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Musa ya ce wa Allah, “A ce ma na tafi wurin Isra’ilawa na ce musu, ‘Allah na kakanninku ya aiko ni wurinku,’ in suka tambaye ni, ‘Mene ne sunansa?’ Me zan ce?” ");
INSERT INTO hausa_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Allah ya ce wa Musa, “NI NE wanda NINE. Abin da za ka faɗa wa Isra’ilawa ke nan cewa, ‘NI NE, ya aiko ni wurinku.’ ” ");
INSERT INTO hausa_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Allah ya kuma ce wa Musa, “Ka faɗa wa Isra’ilawa, ‘Ubangiji, Allah na kakanninka, Allah na Ibrahim, Allah na Ishaku da kuma Allah na Yaƙub, ya aiko ni wurinku.’ Wannan shi ne sunana har abada, sunan da za a tuna da ni daga tsara zuwa tsara ke nan. ");
INSERT INTO hausa_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","“Tafi ka tattara dattawan Isra’ila, ka ce musu, ‘Ubangiji, Allah na kakanninku, Allah na Ibrahim, Ishaku da Yaƙub, ya bayyana a gare ni ya ce, Na lura da ku, na kuma ga abubuwan da ake yi muku a Masar. ");
INSERT INTO hausa_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Na kuma yi alkawari, zan fitar da ku daga azabarku a Masar zuwa ƙasar Kan’aniyawa, Hittiyawa, Amoriyawa, Ferizziyawa, Hiwiyawa da Yebusiyawa, ƙasa mai zub da madara da zuma.’ ");
INSERT INTO hausa_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“Dattawan Isra’ila za su saurare ka. Sa’an nan da kai da dattawan Isra’ila, za ku tafi wurin sarkin Masar, ku ce masa, ‘Ubangiji, Allah na Ibraniyawa, ya sadu da mu. Bari mu yi tafiyar kwana uku zuwa cikin hamada domin mu yi hadaya wa Ubangiji Allahnmu.’ ");
INSERT INTO hausa_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Amma na san cewa sarkin Masar ba zai yarda ku tafi ba, sai hannu mai ƙarfi ya tilasta shi. ");
INSERT INTO hausa_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Saboda haka zan miƙa hannuna in bugi Masarawa da duk al’ajaban da zan aikata a cikinsu. Bayan haka zai bar ku, ku tafi. ");
INSERT INTO hausa_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“Zan kuma sa mutanen su sami tagomashi daga wurin Masarawa, saboda sa’ad da za ku fita, ba za ku fita hannu wofi ba. ");
INSERT INTO hausa_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Kowace mace ta tambayi maƙwabciyarta, da kuma duk wata macen da take cikin gidanta, kayayyakin azurfa da na zinariya da kuma na riguna, waɗanda za ku sa wa ’ya’yanku maza da mata. Ta haka nan za ku washe Masarawa.” ");
INSERT INTO hausa_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Musa ya amsa ya ce, “In ba su gaskata ni ba, suka kuma ce, ‘Ubangiji bai bayyana gare ka ba fa’?” ");
INSERT INTO hausa_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Sai Ubangiji ya ce, “Mene ne wannan a hannunka?” Musa ya amsa ya ce, “Sanda.” ");
INSERT INTO hausa_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Sai Ubangiji ya ce, “Jefa shi ƙasa.” Musa ya jefa shi ƙasa, sai sandan ya zama maciji, Musa kuwa ya gudu daga gare shi. ");
INSERT INTO hausa_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Sai Ubangiji ya ce masa, “Sa hannunka ka ɗauke shi ta wutsiya.” Sai Musa ya miƙa hannu, ya kama macijin, macijin kuwa ya dawo sanda a hannunsa. ");
INSERT INTO hausa_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Ubangiji ya ce, “Wannan zai sa su ba da gaskiya cewa Ubangiji, Allah na kakanninsu, Allah na Ibrahim, Allah na Ishaku, da kuma Allah da Yaƙub, ya bayyana gare ka.” ");
INSERT INTO hausa_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Sa’an nan Ubangiji ya ce, “Sa hannunka cikin rigarka.” Sai Musa ya sa hannunsa cikin rigarsa, sa’ad da ya fitar da shi, sai hannun ya a kuturce fari fat, kamar ƙanƙara. ");
INSERT INTO hausa_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Sai Ubangiji ya ce, “Yanzu, mayar da hannunka a rigarka.” Sai Musa ya sa hannunsa cikin rigarsa, da ya fitar da shi, sai hannun ya koma kamar sauran jikinsa. ");
INSERT INTO hausa_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Sa’an nan Ubangiji ya ce, “In ba su gaskata ba, ko kuma ba su kula da mu’ujiza ta fari ba, wataƙila su gaskata da ta biyun. ");
INSERT INTO hausa_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Amma in ba su gaskata mu’ujizan nan biyu ba, ko kuwa ba su saurare ka ba, sai ka ɗibo ruwa daga Nilu, ka zuba a busasshiyar ƙasa. Ruwan da ka ɗebo daga kogin zai zama jini a ƙasar.” ");
INSERT INTO hausa_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Musa ya ce wa Ubangiji, “Ya Ubangiji, ni ban mai iya magana ba ne, ban taɓa iya ba, ko a yanzu ma, bayan ka yi magana da ni, gama ni mai nauyin baki ne, mai nauyin harshe kuma.” ");
INSERT INTO hausa_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Ubangiji ya ce masa, “Wa ya ba mutum bakinsa? Wa yake maishe shi kurma ko bebe? Wa yake ba shi gani ko yă makanta shi? Ashe ba Ni Ubangiji ba ne? ");
INSERT INTO hausa_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Yanzu tafi, zan taimake ka ka yi magana, zan kuma koya maka abin da za ka faɗa.” ");
INSERT INTO hausa_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Amma Musa ya ce, “Ya Ubangiji, ina roƙonka, ka nemi wani ka aika.” ");
INSERT INTO hausa_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Sai Ubangiji ya yi fushi da Musa ya ce, “Ɗan’uwanka Haruna Balawe, ba ya nan ne? Na san ya iya magana. Ya riga ya kama hanya don yă sadu da kai, zai kuma yi farin ciki sa’ad da ya gan ka. ");
INSERT INTO hausa_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Za ka yi masa magana. Ka kuma sa masa maganata a baki; zan kuma taimake ku magana, in koya muku abin da za ku yi. ");
INSERT INTO hausa_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Zai yi magana da mutane a madadinka, zai zama kamar bakinka, kai kuwa kamar Allah a gare shi. ");
INSERT INTO hausa_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Amma ka ɗauki wannan sanda a hannunka domin yă aikata mu’ujizan.” ");
INSERT INTO hausa_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Sai Musa ya koma wurin Yetro surukinsa, ya ce masa, “Bari in koma wurin mutanena a Masar, in ga ko da mai rai a cikinsu.” Yetro ya ce, “Tafi, ka kuma sauka lafiya.” ");
INSERT INTO hausa_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Ubangiji ya riga ya gaya wa Musa a Midiyan, “Koma Masar, domin dukan mutanen da suke neman su kashe ka sun mutu.” ");
INSERT INTO hausa_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Sai Musa ya ɗauki matarsa da ’ya’yansa maza, ya sa su a kan jaki, suka kama hanya zuwa Masar. Ya kuma ɗauki sandan Allah a hannunsa. ");
INSERT INTO hausa_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Ubangiji ya ce wa Musa, “Bayan ka koma Masar, ka tabbata ka aikata dukan mu’ujizan da na sa cikin ikonka a gaban Fir’auna. Amma zan taurare zuciyarsa domin kada yă bar mutanen su tafi. ");
INSERT INTO hausa_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Sa’an nan ka gaya wa Fir’auna, ‘Ga abin da Ubangiji ya ce; Isra’ila shi ne ɗan farina, ");
INSERT INTO hausa_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","na gaya maka, “Ka bar ɗana yă tafi domin yă yi mini sujada.” Amma ka ƙi ka bari yă tafi, saboda haka zan kashe ɗan farinka.’ ” ");
INSERT INTO hausa_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Ya zama kuwa sa’ad da Musa yake masauki a kan hanya sai Ubangiji ya gamu da shi, ya nema ya kashe shi. ");
INSERT INTO hausa_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Amma Ziffora ta ɗauki dutsen ƙanƙara mai ci, ta yanke loɓar ɗanta ta taɓa ƙafafun Musa da shi. Ta ce, “Tabbatacce kai angon jini ne a gare ni.” ");
INSERT INTO hausa_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Sai Ubangiji ya ƙyale shi. (A lokacin ta ce “angon jini,” tana nufin kaciya.) ");
INSERT INTO hausa_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Ubangiji ya ce wa Haruna, “Tafi cikin hamada ka sadu da Musa.” Sai ya sadu da Musa a dutsen Allah, ya sumbace shi. ");
INSERT INTO hausa_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Sai Musa ya gaya wa Haruna dukan abin da Ubangiji ya aike yă faɗa, da kuma dukan mu’ujizan da ya umarce shi yă aikata. ");
INSERT INTO hausa_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Musa da Haruna suka tattara dukan dattawan Isra’ilawa, ");
INSERT INTO hausa_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","sai Haruna ya gaya musu dukan abin da Ubangiji ya ce wa Musa. Ya kuma aikata mu’ujizan a gaban mutanen, ");
INSERT INTO hausa_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","sai suka gaskata. Sa’ad da suka ji cewa Ubangiji ya damu da su, ya kuma ga azabarsu, sai suka durƙusa suka yi sujada. ");
INSERT INTO hausa_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Daga bisani sai Musa da Haruna suka tafi wurin Fir’auna suka ce, “Ga abin da Ubangiji, Allah na Isra’ila ya ce, ‘Bari mutanena su tafi domin su yi mini biki a hamada.’ ” ");
INSERT INTO hausa_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Fir’auna ya ce, “Wane ne Ubangiji da zan yi biyayya da shi, har in bar Isra’ila su tafi? Ban san Ubangiji ba, kuma ba zan bar Isra’ila su tafi ba.” ");
INSERT INTO hausa_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Sai suka ce, “Allah na Ibraniyawa ya sadu da mu. Yanzu bari mu ɗauki tafiyar kwana uku cikin hamada domin mu miƙa hadaya ga Ubangiji Allahnmu, don kada yă buga mu da annoba ko takobi.” ");
INSERT INTO hausa_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Amma sarkin Masar ya ce wa, “Musa da Haruna, don me kuke hana mutane yin aikinsu? Ku koma wurin aikinku!” ");
INSERT INTO hausa_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Sa’an nan Fir’auna ya ce, “Ga shi mutane sun yi yawa a ƙasar Masar, ku kuma yanzu kuna so ku hana su yin aiki.” ");
INSERT INTO hausa_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","A wannan rana Fir’auna ya ba da wannan umarni wa shugabannin masu gandu, ");
INSERT INTO hausa_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Kada ku ƙara ba wa mutanen ciyawar tattaka domin su yi tubula, bari su tafi su tattara tattaka da kansu. ");
INSERT INTO hausa_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Ku kuma bukace su su yi tubula daidai yawan tubalin da suka saba yi, kada ku rage. Ragwaye ne, shi ya sa suke kuka cewa, ‘Bari mu tafi mu yi hadaya ga Allahnmu.’ ");
INSERT INTO hausa_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Ku sa waɗannan mutane su yi aiki mai tsanani sosai, don kada su sami zarafin kasa kunne ga maganganun ƙarya.” ");
INSERT INTO hausa_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Sai shugabannin masu aikin gandu suka fita suka gaya wa mutanen Isra’ila, “Ga abin da Fir’auna ya ce, ‘Ba zan ƙara ba ku tattaka ba. ");
INSERT INTO hausa_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Ku tafi ku nemo wa kanku tattaka duk inda za ku samu, amma ba za a rage aikinku ba ko kaɗan.’ ” ");
INSERT INTO hausa_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Saboda haka mutane suka warwatsu ko’ina a Masar domin tattara bunnun da za su yi amfani da su, maimakon tattaka. ");
INSERT INTO hausa_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Shugabannin gandu suka dinga matsa musu suna cewa, “Ku cika aikin da aka bukace ku na kowace rana kamar yadda kuke yi sa’ad da kuke da tattaka.” ");
INSERT INTO hausa_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Manyan Isra’ilawa waɗanda shugabannin gandun Fir’auna suka naɗa, suka sha dūka, aka kuma yi musu tambayoyi ana cewa, “Don me ba ku cika yawan tubula na jiya da na yau kamar yadda kuka saba ba?” ");
INSERT INTO hausa_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Sai manyan Isra’ila masu bi da aikin gandu suka tafi wurin Fir’auna suka yi roƙo suna cewa, “Don me kake yi wa bayinka haka? ");
INSERT INTO hausa_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Ba a ba wa bayinka tattaka, duk da haka ana ce mana, ‘Ku yi tubula!’ Ana wa bayinka dūka, amma fa laifin na mutanenka ne.” ");
INSERT INTO hausa_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Fir’auna ya ce, “Ku ragwaye ne! Shi ya sa kuke cewa, ‘Bari mu tafi mu yi hadaya wa Ubangiji.’ ");
INSERT INTO hausa_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Ku ɓace yanzu daga nan, ku koma wurin aikinku. Ba za a ba ku tattaka ba, kuma dole ku fid da tubula kamar yadda kuka saba.” ");
INSERT INTO hausa_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Manyan Isra’ilawa da suke bi da aikin gandu suka gane cewa sun shiga uku, sa’ad da aka gaya musu, “Ba za ku rage yawan tubulan da aka bukace ku ku yi na kowace rana ba.” ");
INSERT INTO hausa_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Da suka bar Fir’auna, sai suka sadu da Musa da Haruna suna jira su sadu da su, ");
INSERT INTO hausa_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","sai suka ce, “Bari Ubangiji yă duba, yă kuma hukunta ku! Kun maishe mu abin ƙyama ga Fir’auna da bayinsa, kuka kuma sa musu takobi a hannunsu don su kashe mu.” ");
INSERT INTO hausa_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Musa ya koma wurin Ubangiji ya ce, “Ya Ubangiji, don me ka kawo wahala a kan mutanen nan? Abin da ya sa ka aiko ni ke nan? ");
INSERT INTO hausa_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Gama tun da na tafi wurin Fir’auna, na yi masa magana da sunanka, sai ya fara gasa wa mutanen nan azaba, ba ka kuma ceci mutanenka.” ");
INSERT INTO hausa_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Sa’an nan Ubangiji ya ce wa Musa, “Yanzu za ka gan abin da zan yi da Fir’auna. Zan sa shi dole yă bar su su tafi, har ma yă iza ƙyeyarsu don su bar ƙasarsa!” ");
INSERT INTO hausa_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Allah ya kuma ce wa Musa, “Ni ne Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Na bayyana ga Ibrahim, ga Ishaku da kuma ga Yaƙub a matsayin Allah Maɗaukaki, amma sunan nan nawa Ubangiji, ban bayyana kaina a gare su ba. ");
INSERT INTO hausa_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Na kuma kafa alkawari da su don in ba su ƙasar Kan’ana, inda suka yi zaman baƙunci. ");
INSERT INTO hausa_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Ban da haka ma, na ji nishe-nishen Isra’ilawa, waɗanda Masarawa suka bautar, na kuma tuna da alkawarina. ");
INSERT INTO hausa_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","“Saboda haka, ka ce wa Isra’ilawa, ‘Ni ne Ubangiji, zan kuma fitar da ku daga bauta ta Masarawa. Zan ’yantar da ku daga zama bayinsu, da ƙarfina zan fanshe ku, in kawo hukunci mai zafi a kansu, don in cece ku. ");
INSERT INTO hausa_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Zan ɗauke ku tamƙar mutanena, in kuma zama Allahnku. Sa’an nan za ku sani Ni ne Ubangiji Allahnku, wanda ya fitar da ku daga wahalar Masarawa. ");
INSERT INTO hausa_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Zan kuwa kawo ku a ƙasar da na rantse da hannun da na ɗaga sama, cewa zan ba wa Ibrahim, wa Ishaku, da kuma wa Yaƙub. Zan ba da ita gare ku gādo. Ni ne Ubangiji.’ ” ");
INSERT INTO hausa_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Musa ya faɗa wa Isra’ilawa wannan magana, amma ba su kasa kunne a gare shi ba, don ɓacin rai saboda tsananin aikin bauta. ");
INSERT INTO hausa_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Sa’an nan Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Koma ka ce wa Fir’auna sarkin Masar, yă bar Isra’ilawa su fita daga ƙasarsa.” ");
INSERT INTO hausa_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Amma Musa ya ce wa Ubangiji, “In Isra’ilawa ba su ji ni ba, yaya Fir’auna zai ji ni, da yake ina magana da ƙyar?” ");
INSERT INTO hausa_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Ubangiji ya yi magana da Musa da Haruna game da Isra’ilawa da Fir’auna sarkin Masar, ya umarce su su fitar da Isra’ilawa daga Masar. ");
INSERT INTO hausa_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Waɗannan su ne shugabannin iyalansu. ’Ya’yan Ruben maza ɗan farin Isra’ila su ne, Hanok da Fallu, Hezron da Karmi. Waɗannan su ne dangin Ruben. ");
INSERT INTO hausa_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","’Ya’yan Simeyon maza su ne, Yemuwel, Yamin, Ohad, Yakin, Zohar da Sha’ul ɗan mutuniyar Kan’ana. Waɗannan su ne dangin Simeyon. ");
INSERT INTO hausa_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Waɗannan su ne sunayen ’ya’yan Lawi maza bisa ga abin da aka rubuta, Gershon, Kohat da Merari. Lawi ya yi shekara 137. ");
INSERT INTO hausa_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","’Ya’yan Gershon maza, bisa ga dangi su ne, Libni da Shimeyi. ");
INSERT INTO hausa_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","’Ya’yan Kohat maza, su ne, Amram, Izhar, Hebron da Uzziyel. Kohat ya yi shekara 133. ");
INSERT INTO hausa_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","’Ya’yan Merari maza, su ne, Mali da Mushi. Waɗannan su ne dangin Lawi bisa ga abin da aka rubuta. ");
INSERT INTO hausa_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amram ya auri ’yar’uwar mahaifinsa Yokebed, wadda ta haifa masa Haruna da Musa. Amram ya yi shekara 137. ");
INSERT INTO hausa_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","’Ya’yan Izhar maza, su ne, Kora, Nefeg da Zikri. ");
INSERT INTO hausa_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","’Ya’yan Uzziyel maza, su ne, Mishayel, Elzafan da Sitri. ");
INSERT INTO hausa_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Haruna ya auri Elisheba, ’yar Amminadab, ’yar’uwar Nashon, sai ta haifa masa Nadab da Abihu, Eleyazar da Itamar. ");
INSERT INTO hausa_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","’Ya’yan Kora maza, su ne, Assir, Elkana da Abiyasaf. Waɗannan su ne dangin Kora. ");
INSERT INTO hausa_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Eleyazar ɗan Haruna, ya auri ɗaya daga cikin ’yan matan Futiyel, sai ta haifa masa Finehas. Waɗannan su ne shugabannin iyalan Lawi, dangi, dangi. ");
INSERT INTO hausa_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Wannan Haruna da Musa ne, waɗanda Ubangiji ya yi musu magana ya ce, “Ku fitar da Isra’ilawa daga Masar ɓangare-ɓangare.” ");
INSERT INTO hausa_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Su ne suka yi magana da Fir’auna sarkin Masar game da fitar da Isra’ilawa daga Masar, wannan Musa da Haruna. ");
INSERT INTO hausa_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Ana nan, sa’ad da Ubangiji ya yi magana da Musa a Masar, ");
INSERT INTO hausa_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","ya ce masa, “Ni ne Ubangiji. Sai ka faɗa wa Fir’auna sarkin Masar kome da na faɗa maka.” ");
INSERT INTO hausa_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Amma Musa ya ce wa Ubangiji, “Ni mai nauyin baki ne, ina magana da ƙyar, ƙaƙa Fir’auna zai kasa kunne gare ni?” ");
INSERT INTO hausa_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Sai Ubangiji ya ce wa Musa, “Duba, na maishe ka kamar Allah ga Fir’auna, ɗan’uwanka Haruna kuma zai zama annabinka. ");
INSERT INTO hausa_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Za ka faɗi kome da na umarce ka, ɗan’uwanka Haruna kuwa zai faɗa wa Fir’auna, yă bar Isra’ilawa su fita daga ƙasarsa. ");
INSERT INTO hausa_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Amma zan taurare zuciyar Fir’auna, kuma ko da na ninka mu’ujizai da kuma alamu a Masar, ");
INSERT INTO hausa_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","ba zai saurare ku ba. Don haka zan miƙa hannuna a kan Masar, in murƙushe ta da bala’i iri-iri, bayan haka zan fitar da taron mutanen Isra’ila daga ƙasar Masar ta wurin hukuntaina masu girma. ");
INSERT INTO hausa_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Masarawa kuwa za su san cewa ni ne Ubangiji sa’ad da na miƙa hannuna a kan Masar, na kuma fitar da Isra’ilawa daga gare ta.” ");
INSERT INTO hausa_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Musa da Haruna suka aikata yadda Ubangiji ya umarce su. ");
INSERT INTO hausa_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Musa yana da shekara tamanin da haihuwa, Haruna kuma yana da shekara tamanin da uku, sa’ad da suka yi magana da Fir’auna. ");
INSERT INTO hausa_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Ubangiji ya ce wa Musa da Haruna, ");
INSERT INTO hausa_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Sa’ad da Fir’auna ya ce muku, ‘Aikata wani al’ajabi,’ sai ka ce wa Haruna, ‘Ɗauki sandanka ka jefa shi a ƙasa, a gaban Fir’auna,’ zai kuwa zama maciji.” ");
INSERT INTO hausa_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Sai Musa da Haruna suka tafi wurin Fir’auna, suka yi yadda Ubangiji ya umarce su. Haruna ya jefa sandansa ƙasa, a gaban Fir’auna da bayinsa, sai sandan ya zama maciji. ");
INSERT INTO hausa_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Fir’auna kuwa ya kira masu hikima da masu sihiri, sai bokayen Masarawa ma suka yi irin abubuwan nan da bokancinsu. ");
INSERT INTO hausa_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Kowannensu ya jefa sandansa ƙasa, ya kuwa zama maciji. Amma sandan Haruna ya haɗiye sandunansu. ");
INSERT INTO hausa_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Duk da haka zuciyar Fir’auna ta taurare, bai kuwa saurare su ba, kamar dai yadda Ubangiji ya riga ya faɗa. ");
INSERT INTO hausa_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Sa’an nan Ubangiji ya ce wa Musa, “Zuciyar Fir’auna taurariya ce, ya ƙi yă bar mutanen su tafi. ");
INSERT INTO hausa_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Ka je wurin Fir’auna da safe, yayinda za shi kogi. Ka jira a bakin Nilu don ka sadu da shi, ka ɗauki sandan nan da ya canja zuwa maciji a hannunka. ");
INSERT INTO hausa_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Sa’an nan ka ce masa, ‘Ubangiji, Allah na Ibraniyawa, ya aiko ni in faɗa maka, Ka bar mutanena su tafi domin su yi mini sujada a hamada. Amma har yanzu ba ka yi biyayya ba. ");
INSERT INTO hausa_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Ga abin da Ubangiji ya ce, da wannan za ka san cewa ni ne Ubangiji. Da sandan da yake hannuna zan bugi ruwan Nilu, zai kuma zama jini. ");
INSERT INTO hausa_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Kifi a ciki Nilu za su mutu, ruwan kuma zai yi ɗoyi; Masarawa ba za su iya shan ruwansa ba.’ ” ");
INSERT INTO hausa_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Ubangiji ya ce wa Musa, “Ka ce wa Haruna, ‘Ka ɗauki sandanka, ka miƙa hannunka kan ruwan Masar, kan kogunansu da rafuffukansu da kududdufansu da kuma dukan tafkunansu, za su zama jini.’ Jini zai kasance ko’ina a Masar, har ma a cikin abubuwan ajiyar ruwansu da aka yi da itace da kuma dutse.” ");
INSERT INTO hausa_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Musa da Haruna suka yi yadda Ubangiji ya umarta. Ya ɗaga sandansa a gaban Fir’auna da bayinsa, ya bugi ruwan Nilu, dukan ruwan kuwa ya zama jini. ");
INSERT INTO hausa_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Kifin da suke cikin Nilu suka mutu, kogin kuwa ya yi wari sosai yadda Masarawa ba su iya shan ruwan ba. Jini ya bazu ko’ina a Masar. ");
INSERT INTO hausa_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Amma bokayen Masar ma suka yi abubuwan nan da sihirinsu, sai zuciyar Fir’auna ta taurare; bai saurari Musa da Haruna ba, kamar dai yadda Ubangiji ya riga ya faɗa. ");
INSERT INTO hausa_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","A maimakon yă saurara, sai ya juya ya koma fadarsa, bai ma damu da abin da aka yi ba. ");
INSERT INTO hausa_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Sai dukan Masarawa suka yi ta tonon gefen Nilu don su sami ruwan sha, domin ba su iya shan ruwan kogin ba. ");
INSERT INTO hausa_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Kwana bakwai suka wuce bayan da Ubangiji ya bugi kogin. ");
INSERT INTO hausa_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Sa’an nan Ubangiji ya ce wa Musa, “Ka je wurin Fir’auna, ka ce masa, ‘Ga abin da Ubangiji yana cewa, ka bar mutanena su tafi domin su yi mini sujada. ");
INSERT INTO hausa_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","In ka ƙi barinsu, zan hore ka da annoban kwaɗi a dukan ƙasarka. ");
INSERT INTO hausa_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Nilu zai cika da kwaɗi. Za su haura zuwa cikin fadanka da kan gadonka, cikin gidajen bayinka da kan mutanenka, cikin kwanonin toye-toyenka da na cin abincinka. ");
INSERT INTO hausa_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Kwaɗin nan za su yi ta tsalle a kanka, da kan mutanenka, da kuma kan dukan bayinka.’ ” ");
INSERT INTO hausa_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Sai Ubangiji ya ce wa Musa, “Ka ce wa Haruna, ‘Ka miƙa hannunka da sandanka bisa koguna da rafuffuka da kuma kududdufai, ka sa kwaɗi su fito su mamaye ƙasar Masar.’ ” ");
INSERT INTO hausa_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Sai Haruna ya miƙa hannunsa bisa ruwan Masar, kwaɗi kuwa suka fito, suka mamaye ƙasar Masar. ");
INSERT INTO hausa_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Amma bokaye ma suka yi abubuwan nan ta wurin sihirinsu; suka sa kwaɗi suka fito suka mamaye ƙasar Masar. ");
INSERT INTO hausa_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Fir’auna ya kira Musa da Haruna ya ce, “Yi addu’a ga Ubangiji yă ɗauke kwaɗi daga gare ni da mutanena, zan kuwa bar mutanenku su tafi su yi hadaya ga Ubangiji.” ");
INSERT INTO hausa_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Musa ya ce wa Fir’auna, “Na ba ka dama ka ba da lokacin da zan yi addu’a dominka da kuma bayinka da mutanenka, gidajenku kuwa za su rabu da kwaɗi, amma ban da waɗanda suke cikin Nilu.” ");
INSERT INTO hausa_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Fir’auna ya ce, “Gobe.” Musa ya amsa, “Za a yi kamar yadda ka faɗa, domin ka sani babu wani kamar Ubangiji, Allahnmu. ");
INSERT INTO hausa_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Kwaɗin za su bar ka da gidajenka, bayinka da mutanenka; za su kasance a Nilu ne kaɗai.” ");
INSERT INTO hausa_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Bayan Musa da Haruna sun bar Fir’auna, Sai Musa ya yi kuka ga Ubangiji saboda kwaɗin da ya kawo a bisa Fir’auna. ");
INSERT INTO hausa_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Sai Ubangiji ya yi abin da Musa ya nema. Kwaɗin suka mutu a gidaje, da filaye, da kuma gonaki. ");
INSERT INTO hausa_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Aka jibga su tsibi-tsibi, ƙasar ta yi ɗoyi saboda su. ");
INSERT INTO hausa_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Amma da Fir’auna ya ga an sami sauƙi, sai ya taurare, ya ƙi yă saurari Musa da Haruna kamar dai yadda Ubangiji ya riga ya faɗa. ");
INSERT INTO hausa_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Sa’an nan Ubangiji ya ce wa Musa, “Ka ce wa Haruna, ‘Miƙa hannunka ka bugi ƙurar ƙasa,’ dukan ƙurar ƙasar Masar kuwa za tă zama ƙwari masu cizo.” ");
INSERT INTO hausa_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Suka yi haka, da Haruna ya miƙa hannunsa da sandan, ya bugi ƙurar ƙasa, sai ƙwari masu cizo suka fito a kan mutane da dabbobi. Dukan ƙurar, ko’ina a ƙasar Masar ta zama cinnaku. ");
INSERT INTO hausa_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Sa’ad da bokayen Fir’auna suka yi ƙoƙari yin sihiri iri na rufe ido domin su fito da kwari, sai suka kāsa. Ƙwari masu cizo kuwa suka rufe mutane da dabbobi. ");
INSERT INTO hausa_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Sai bokaye suka ce wa Fir’auna, “Wannan fa da hannun Allah a ciki.” Amma zuciyar Fir’auna ta taurare, bai kuwa saurara ba, kamar dai yadda Ubangiji ya riga ya faɗa. ");
INSERT INTO hausa_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Sai Ubangiji ya ce wa Musa, “Ka tashi da sassafe ka sadu da Fir’auna a lokacin da za shi kogi, ka ce masa, ‘Ga abin da Ubangiji yana cewa, bari mutanena su tafi, don su yi mini sujada. ");
INSERT INTO hausa_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","In ba ka bar mutanena suka tafi ba, zan turo da tarin ƙuda a kanka da bayinka, a kan mutanenka da cikin gidajenka. Gidajen Masarawa za su cika da ƙudaje, har ma da ƙasa inda za su taka. ");
INSERT INTO hausa_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","“ ‘Amma zan keɓe yankin Goshen, inda mutanena suke don kada ƙudaje su taɓa wurin, domin ka sani cewa Ni, Ubangiji, ina cikin wannan ƙasa. ");
INSERT INTO hausa_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Zan sa iyaka tsakanin jama’ata da jama’arka. Gobe ne wannan mu’ujiza za tă auku.’ ” ");
INSERT INTO hausa_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Ubangiji kuwa ya yi haka. Tarin ƙuda suka zubo a fadar Fir’auna da cikin gidajen bayinsa, da ko’ina a Masar, ƙasar kuwa ta lalace saboda ƙudaje. ");
INSERT INTO hausa_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Sai Fir’auna ya kira Musa da Haruna ya ce, “Ku tafi, ku miƙa hadaya ga Allahnku, a nan a cikin ƙasar.” ");
INSERT INTO hausa_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Amma Musa ya ce, “Wannan ba zai yiwu ba. Hadayun da mukan miƙa wa Ubangiji, Allahnmu haram ne ga Masarawa. In kuwa muka miƙa hadayun da suke haram a idanunsu, ba za su jajjefe mu ba? ");
INSERT INTO hausa_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Dole mu yi tafiya kwana uku cikin hamada domin miƙa hadayu ga Ubangiji Allahnmu, yadda ya umarce mu.” ");
INSERT INTO hausa_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Fir’auna ya ce, “Zan bar ku ku tafi, don ku miƙa hadayu ga Ubangiji Allahnku, a cikin hamada, amma ba za ku tafi da nisa ba. Yanzu ku yi mini addu’a.” ");
INSERT INTO hausa_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Musa ya amsa, “Da zarar na bar ka, zan yi addu’a ga Ubangiji, gobe kuwa ƙudaje za su bar Fir’auna da fadawansa da kuma mutanensa. Sai dai a tabbata Fir’auna bai sāke yin ruɗi ta wurin ƙin barin mutane su tafi su miƙa hadayu ga Ubangiji ba.” ");
INSERT INTO hausa_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Sa’an nan Musa ya rabu da Fir’auna, ya kuma yi addu’a ga Ubangiji, ");
INSERT INTO hausa_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Ubangiji kuwa ya yi abin da Musa ya roƙa. Ƙudaje suka rabu da Fir’auna da fadawansa da kuma mutanensa; ba ƙudan da ya rage. ");
INSERT INTO hausa_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Amma a wannan lokaci ma, Fir’auna ya taurare zuciyarsa, bai kuma bar mutanen suka tafi ba. ");
INSERT INTO hausa_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Sai Ubangiji ya ce wa Musa, “Ka je wurin Fir’auna ka ce masa, ‘Ga abin da Ubangiji Allah na Ibraniyawa ya ce, “Ka bar mutanena su tafi, domin su yi mini sujada.” ");
INSERT INTO hausa_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","In ka ƙi ka bar su su tafi, kana ta riƙonsu, ");
INSERT INTO hausa_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","hannun Ubangiji zai kawo muguwar annoba a kan dabbobinka a gona, a kan dawakanka, da jakuna da raƙuma, da kuma a kan shanunka da tumaki da awaki. ");
INSERT INTO hausa_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Amma Ubangiji zai raba tsakanin dabbobin Isra’ila da na Masar, saboda kada wata dabbar Isra’ilawa ta mutu.’ ” ");
INSERT INTO hausa_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Sai Ubangiji ya sa lokaci ya ce, “Gobe Ubangiji zai yi wannan a ƙasar.” ");
INSERT INTO hausa_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Kashegari Ubangiji ya yi haka. Dukan dabbobin Masarawa suka mutu, amma babu dabba guda ta Isra’ilawan da ta mutu. ");
INSERT INTO hausa_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Fir’auna ya aiki mutane su bincika, sai suka tarar babu dabba guda ta Isra’ilawan da ta mutu. Duk da haka zuciyar Fir’auna ta taurare, bai kuwa bar mutanen su tafi ba. ");
INSERT INTO hausa_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Sa’an nan Ubangiji ya ce wa Musa da Haruna, “Ɗibi tokar matoya cike da tafin hannuwanku, Musa kuwa zai watsa tokar sama a gaban Fir’auna. ");
INSERT INTO hausa_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Za tă zama ƙura bisa dukan ƙasar Masar, sai marurai masu zafi su fiffito bisa mutane da dabbobi a dukan ƙasar.” ");
INSERT INTO hausa_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Sai suka ɗibi tokar matoya, suka tsaya a gaban Fir’auna, Musa ya watsa ta a iska, sai marurai masu zafi suka fiffito bisa mutane da dabbobi. ");
INSERT INTO hausa_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Bokaye suka kāsa tsayawa a gaban Musa saboda maruran da suke bisansu da a kan dukan Masarawa. ");
INSERT INTO hausa_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Amma Ubangiji ya taurare zuciyar Fir’auna, bai kuwa saurare Musa da Haruna ba kamar yadda Ubangiji ya riga ya ce wa Musa. ");
INSERT INTO hausa_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Sa’an nan Ubangiji ya ce wa Musa, “Tashi da sassafe, ka sadu da Fir’auna, ka ce masa, ‘Ga abin da Ubangiji, Allah na Ibraniyawa ya ce, Ka bar mutanena su tafi don su yi mini sujada, ");
INSERT INTO hausa_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","ko kuwa a wannan lokaci zan aika da cikakkiyar annoba mai ƙarfi a kanka da a kan fadawanka da mutanenka, domin ka san cewa ba kama da ni a dukan duniya. ");
INSERT INTO hausa_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Gama da ni kaina na miƙa hannuna na buge ka da jama’arka da annoba, ai, da an hallaka ku a duniya ƙaƙaf. ");
INSERT INTO hausa_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Amma na bar ka ka rayu domin in nuna maka ikona, domin kuma sunana yă zama abin darajantawa a dukan duniya. ");
INSERT INTO hausa_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Har yanzu kana gāba da mutanena, ba ka kuma bar su su tafi ba. ");
INSERT INTO hausa_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Saboda haka, gobe war haka, zan sa a yi ƙanƙara mai tsananin gaske, irin wadda Masar ba tă taɓa gani ba tun kahuwarta, har yă zuwa yanzu. ");
INSERT INTO hausa_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Yanzu, ka ba da umarni a dawo da shanunku da kuma kome da kuke da shi wanda yake a gona zuwa gida, gama ƙanƙarar za tă kashe kowane mutum ko dabba wadda take a gona wadda ba a kawo cikin gida ba, sa’ad da ta fāɗo.’ ” ");
INSERT INTO hausa_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Waɗansu daga cikin dattawan Fir’auna suka cika da tsoro saboda abin da Ubangiji ya faɗa, nan da nan suka shigo da dabbobinsu da bayinsu da sauri daga gona zuwa cikin gida. ");
INSERT INTO hausa_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Amma waɗanda ba su kula da maganar Ubangiji ba, suka bar bayinsu da dabbobi a gona. ");
INSERT INTO hausa_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Sa’an nan Ubangiji ya ce wa Musa, “Miƙa hannunka sama don a yi ƙanƙara a bisa dukan Masar, a bisa mutane da dabbobi, da bisa dukan abubuwan da suke girma a gonakin Masar.” ");
INSERT INTO hausa_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Da Musa ya miƙa sandansa sama, sai Ubangiji ya aiko da tsawa da ƙanƙara, da walƙiya har ƙasa. Ta haka Ubangiji ya yi ruwan ƙanƙara a bisa ƙasar Masar; ");
INSERT INTO hausa_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","ƙanƙara ta fāɗo, walƙiya kuma tana ta wulƙawa. Wannan ce ƙanƙara mafi munin da aka taɓa yi, a dukan ƙasar Masar, tun tarihin kahuwarta na zaman al’umma. ");
INSERT INTO hausa_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Ko’ina a Masar ƙanƙara ta bugi duk abin da yake a gonaki, mutane da dabbobi, ta bugi duk ganyaye da suke a gonaki, ta kuma ragargaza kowane itace. ");
INSERT INTO hausa_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Wuri guda kaɗai da ba a yi ruwan ƙanƙara ba, shi ne yankin Goshen, inda Isra’ilawa suke. ");
INSERT INTO hausa_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Sai Fir’auna ya aika a kira Musa da Haruna. Ya ce musu, “A wannan karo na yi zunubi. Ubangiji, shi ne da gaskiya, ni da mutane mu ke da kuskure. ");
INSERT INTO hausa_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Ku roƙi Ubangiji, yă tsai da tsawar da ƙanƙarar. Ni kuwa na yi alkawari zan bar ku ku tafi, ba za ku ƙara tsayawa a nan ba.” ");
INSERT INTO hausa_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Musa ya amsa, “To, da kyau, da zarar na fita daga birnin, zan yi addu’a ga Ubangiji, tsawar za tă tsaya, ƙanƙarar kuma za tă daina, don ku sani cewa duniya ta Ubangiji ce. ");
INSERT INTO hausa_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Amma na san cewa kai da fadawanka, har wa yau ba ku ji tsoron Ubangiji Allah ba tukuna.” ");
INSERT INTO hausa_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","(Rama da sha’ir suka lalace, gama sha’ir ya riga ya nuna, rama kuwa tana fid da kai. ");
INSERT INTO hausa_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Alkama da gero kam, ba a hallaka su ba, gama lokacin nunansu bai yi ba tukuna.) ");
INSERT INTO hausa_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Sai Musa ya tashi daga gaban Fir’auna, ya fita daga birni. Da ya miƙa hannuwansa ta wajen Ubangiji, sai tsawa da ƙanƙara suka tsaya, kwararowar ruwa kuma ta ɗauke. ");
INSERT INTO hausa_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Da Fir’auna ya ga cewa ruwa da ƙanƙara da tsawa sun daina, sai ya sāke yin zunubi. Shi da fadawansa, suka taurare zukatansu. ");
INSERT INTO hausa_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Ta haka zuciyar Fir’auna ta taurare, bai kuwa bar Isra’ilawa suka tafi ba, kamar yadda Ubangiji ya riga ya faɗa ta wurin Musa. ");
INSERT INTO hausa_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Sai Ubangiji ya ce wa Musa, “Je wurin Fir’auna, gama na riga na taurare zuciyarsa da kuma zukatan fadawansa domin in aikata waɗannan mu’ujizai nawa a tsakiyarsu, ");
INSERT INTO hausa_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","don kuma ku gaya wa ’ya’yanku da jikokinku yadda na tsananta wa Masarawa, da kuma yadda na aikata mu’ujizai a cikinsu, don ku sani ni ne Ubangiji.” ");
INSERT INTO hausa_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Sai Musa da Haruna suka tafi wurin Fir’auna suka ce masa, “Ga abin da Ubangiji, Allah na Ibraniyawa ya ce, ‘Har yaushe za ka ƙi ƙasƙantar da kanka a gabana? Ka bar mutanena su tafi domin su yi mini sujada. ");
INSERT INTO hausa_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","In ka ƙi ka bari su tafi, gobe zan aiko da fāra a ƙasarka. ");
INSERT INTO hausa_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Za su rufe fuskar ƙasar, har da ba za a iya ganin ƙasa ba. Za su cinye ɗan sauran abin da ya rage muku daga ɓarnar ƙanƙara, za su cinye dukan itatuwan da suke girma a gonakinku. ");
INSERT INTO hausa_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Za su cika gidajenka, da na fadawanka, da na dukan Masarawa, abin da iyayenka da kakanninka ba su taɓa gani ba, tun daga ranar da suka sami kansu a duniya, har yă zuwa yau.’ ” Sa’an nan Musa ya juya, ya rabu da Fir’auna. ");
INSERT INTO hausa_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Fadawan Fir’auna suka ce masa, “Har yaushe mutumin nan zai zama mana tarko? Ka bar mutanen su tafi domin su yi wa Ubangiji Allahnsu sujada. Har yanzu ba ka san cewa Masar ta lalace ba?” ");
INSERT INTO hausa_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Sa’an nan aka dawo da Musa da Haruna wurin Fir’auna. Sai ya ce, “Ku tafi, ku yi wa Ubangiji Allahnku sujada. Amma wa da wa za su tafi?” ");
INSERT INTO hausa_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Musa ya amsa, “Za mu tafi tare da ƙanananmu, da tsofaffinmu, da ’ya’yanmu maza da mata, da kuma garkunanmu na shanu da tumaki, gama dole ne mu yi bikin ga Ubangiji.” ");
INSERT INTO hausa_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Fir’auna ya ce, “Ubangiji ya taimaka bisa ga niyyarku, amma matanku da ƙanananku ba za su tafi ba! A fili yake kuna da niyyar mugunta. ");
INSERT INTO hausa_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Sam! Wannan ba zai taɓa yiwu ba, sai ko maza kaɗai su tafi su yi wa Ubangiji sujada, gama abin da kuke so ke nan.” Sa’an nan aka kori Musa da Haruna daga gaban Fir’auna. ");
INSERT INTO hausa_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Sai Ubangiji ya ce wa Musa, “Miƙa hannunka a bisa Masar domin fāra su sauko bisa ƙasar, su ci duk abin da yake girma a gonaki, duk abin da ƙanƙara ta rage.” ");
INSERT INTO hausa_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Saboda haka Musa ya miƙa sandansa bisa Masar, Ubangiji kuwa ya sa iskar gabas ta hura a kan ƙasar dukan dare da kuma dukan yini. Da safe kuwa iskar ta kawo fāra; ");
INSERT INTO hausa_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","suka mamaye ƙasar duka, suka sauka a ko’ina a ƙasar. Ba a taɓa ganin annobar fāra haka ba, ba kuwa za a ƙara ganin fāra kamar haka ba. ");
INSERT INTO hausa_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Suka rufe ƙasar har ta zama baƙi. Suka cinye abin da ƙanƙara ta rage, kowane tsiron da yake girma a gonaki, da dukan ’ya’yan itatuwa. Babu ɗanyen abin da ya ragu a kan itatuwa ko tsire-tsire a dukan ƙasar Masar. ");
INSERT INTO hausa_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Fir’auna ya kira Musa da Haruna da gaggawa ya ce, “Na yi wa Ubangiji Allahnku zunubi, na kuma yi muku. ");
INSERT INTO hausa_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Yanzu ku gafarta mini zunubina a wannan karo, ku kuma yi addu’a ga Ubangiji Allahnku yă ɗauke wannan muguwar annoba daga gare ni.” ");
INSERT INTO hausa_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Sai Musa ya bar Fir’auna ya kuma yi addu’a ga Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Sai Ubangiji ya canja iska zuwa iska mai ƙarfi ta yamma wadda ta ɗibi fārar zuwa Jan Teku. Babu fāran da suka rage a wani wuri a Masar. ");
INSERT INTO hausa_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Amma Ubangiji ya taurare zuciyar Fir’auna, bai kuwa bar Isra’ilawa suka tafi ba. ");
INSERT INTO hausa_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Sa’an nan Ubangiji ya ce wa Musa, “Miƙa hannunka sama domin a yi duhu a bisa Masar, duhun da za a iya taɓawa.” ");
INSERT INTO hausa_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Sai Musa ya miƙa hannunsa sama, aka kuma yi duhu baƙi ƙirin bisa dukan ƙasar Masar na kwana uku. ");
INSERT INTO hausa_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Ba wanda ya iya gani wani ko yă bar wurinsa na kwana uku. Amma dukan Isra’ilawa sun kasance da haske a inda suke zama. ");
INSERT INTO hausa_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Sai Fir’auna ya aika aka kira Musa, ya kuma ce, “Ku tafi, ku yi wa Ubangiji sujada. Matanku da yaranku ma za su iya tafiya tare da ku; sai dai ku bar garkunanku na shanu da tumaki.” ");
INSERT INTO hausa_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Amma Musa ya ce, “Dole ka bari mu kasance da hadayu, da kuma hadayu na ƙonawa waɗanda za mu miƙa wa Ubangiji Allahnmu. ");
INSERT INTO hausa_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Dole dabbobinmu ma su tafi tare da mu; ko kofato ma, ba za a bari a baya ba. A cikinsu ne za mu ɗibi abin da za mu yi wa Ubangiji Allahnmu sujada. Ba mu kuma san irin abin da za mu miƙa wa Ubangiji ba, sai mun kai can.” ");
INSERT INTO hausa_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Amma Ubangiji ya taurare zuciyar Fir’auna, har bai yarda yă sake su ba. ");
INSERT INTO hausa_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Fir’auna ya ce wa Musa, “Fita, ka ba ni wuri! Ka mai da hankali, kada ka ƙara bayyana a gabana, gama ran da ka sāke ganin fuskata, a ran nan za ka mutu.” ");
INSERT INTO hausa_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Musa ya amsa, “Madalla, kamar yadda ka faɗa, ba zan ƙara bayyana a gabanka ba.” ");
INSERT INTO hausa_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","To, fa, sai Ubangiji ya ce wa Musa, “Zan ƙara kawo annoba guda a kan Fir’auna da kan Masar. Bayan haka, zai bar ku, ku fita daga nan. Sa’ad da ya yi haka kuwa, zai kore ku gaba ɗaya. ");
INSERT INTO hausa_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Ka faɗa wa mutane cewa dukan maza da mata, su roƙi maƙwabtansu kayan azurfa da na zinariya.” ");
INSERT INTO hausa_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","(Ubangiji ya sa mutane suka sami tagomashi a idon Masarawa, Musa kuwa ya sami girma sosai a cikin ƙasar Masar a gaban fadawan Fir’auna da kuma a gaban jama’ar.) ");
INSERT INTO hausa_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Saboda haka Musa ya ce, “Ga abin da Ubangiji ya ce, ‘Wajen tsakar dare, zan ratsa dukan Masar. ");
INSERT INTO hausa_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Kowane ɗan fari, namiji, a Masar zai mutu, daga kan ɗan fari na Fir’auna wanda zai ci gadon sarauta, har zuwa kan ɗan fari na baiwa, wadda take niƙa, da kuma dukan ’yan farin shanu. ");
INSERT INTO hausa_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Za a yi kuka mai zafi ko’ina a Masar, irin wadda ba a taɓa yi ba, ba kuwa za a ƙara yi ba. ");
INSERT INTO hausa_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Amma a cikin Isra’ilawa, ba karen da zai yi haushi wa mutum ko dabba.’ Ta haka za ku sani Ubangiji zai bambanta tsakanin Masar da Isra’ila. ");
INSERT INTO hausa_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Dukan fadawan nan naka za su zo wurina, suna fāɗi a gabana suna cewa, ‘Ka fita, kai da dukan jama’arka!’ Sa’an nan zan fita.” Daga nan sai Musa ya fita daga gaban Fir’auna a husace. ");
INSERT INTO hausa_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Ubangiji ya ce wa Musa, “Fir’auna zai ƙi kasa kunne gare ka, sai na ƙara aikata waɗansu mu’ujizai cikin Masar.” ");
INSERT INTO hausa_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Musa da Haruna suka aikata dukan waɗannan mu’ujizai a gaban Fir’auna, amma Ubangiji ya taurare zuciyar Fir’auna, bai kuwa bar Isra’ilawa su fita daga ƙasarsa ba. ");
INSERT INTO hausa_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Ubangiji ya ce wa Musa da Haruna a Masar, ");
INSERT INTO hausa_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Wannan wata za tă zama a gare ku wata na farko, wata na fari na shekararku. ");
INSERT INTO hausa_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Ka faɗa wa dukan jama’ar Isra’ila cewa a rana ta goma ga wannan wata, kowane mutum zai ɗauki ɗan rago domin iyalinsa, ɗaya domin kowane gida. ");
INSERT INTO hausa_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","In akwai wani gidan da ba za su iya cinye rago guda ɗungum ba, saboda iyalin kima ne, to, sai su haɗa kai da maƙwabtansu, su ɗauki rago guda gwargwadon yawansu, bisa ga abin da mutum guda zai ci. ");
INSERT INTO hausa_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Dabbobin da za ku zaɓa, dole su zama bana ɗaya, namiji marar tabo, za ku kuma kamo su daga cikin tumaki ko awaki. ");
INSERT INTO hausa_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Za ku turke dabbar har rana ta goma sha huɗu ga wata, wato, sa’ad da dukan taron jama’ar Isra’ila za su yanka ragunansu da yamma. ");
INSERT INTO hausa_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Sa’an nan za su ɗauki jinin, su shafa a gefen da yake saman dogaran ƙofa na gidajen da suke cin naman dabbobin. ");
INSERT INTO hausa_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","A wannan dare, za su gasa naman, su ci da ganyaye masu ɗaci, da kuma burodi marar yisti. ");
INSERT INTO hausa_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Kada ku ci nama ɗanye, ko kuma dafaffe, amma a gasa shi, da kan, da ƙafafun, da kuma kayan cikin. ");
INSERT INTO hausa_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Kada ku bar kome yă kai gobe, abin da ya kai gobe kuwa, sai ku ƙone shi. ");
INSERT INTO hausa_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Ga yadda za ku ci shi, ku yi ɗamara, takalma kuwa a ƙafafunku, kuna riƙe da sandunan tafiya a hannunku. Ku ci shi da gaggawa; Bikin Ƙetarewa ne na Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“A wannan dare, zan ratsa Masar, in bugi kowane ɗan fari, na mutum da na dabba, zan kuma hukunta dukan gumakan Masar. Ni ne Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Jinin zai zama alama a gare ku, a gidajen da kuke; sa’ad da kuwa na ga jinin, zan ƙetare ku. Ba wata annoba mai hallakarwa da za tă taɓa ku yayinda na bugi Masar. ");
INSERT INTO hausa_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“Wannan rana za tă zama muku abin tunawa dukan zamananku masu zuwa, za ku kiyaye ta kamar biki ga Ubangiji, dawwammamiyar farilla ce har abada. ");
INSERT INTO hausa_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Kwana bakwai za ku ci burodi marar yisti. A rana ta fari, za ku fid da yisti daga gidajenku gama duk wanda ya ci abu mai yisti daga rana ta fari har zuwa rana ta bakwai, za a fid da shi daga Isra’ila. ");
INSERT INTO hausa_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","A rana ta fari, za ku yi taro mai tsarki, haka kuma za ku sāke yi a rana ta bakwai. Kada ku yi aiki a waɗannan ranaku, sai dai ku shirya abinci domin kowa, abin da za ku yi ke nan kawai. ");
INSERT INTO hausa_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","“Ku yi Bikin Burodi Marar Yisti domin a wannan rana ce na fitar da ku ɓangare-ɓangare daga Masar. Ku kiyaye wannan rana ta zama muku dawwammamiyar farilla wa tsara masu zuwa. ");
INSERT INTO hausa_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","A wata na fari, za ku ci burodi marar yisti daga yammancin ranar goma sha huɗu har zuwa yammancin ranar ashirin da ɗaya. ");
INSERT INTO hausa_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Kada a sami yisti a gidajenku har kwana bakwai. Kuma duk wanda ya ci wani abu mai yisti, za a fid da shi daga taron jama’ar Isra’ila, ko baƙo ne, ko haifaffen ɗan ƙasa. ");
INSERT INTO hausa_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Kada ku ci wani abincin da aka yi da yisti. Ko’ina kuka zauna, dole ku ci burodi marar yisti.” ");
INSERT INTO hausa_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Sa’an nan Musa ya kira dukan dattawan Isra’ila ya ce musu, “Ku je da sauri ku zaɓi dabbobin iyalanku, ku yanka ragon Bikin Ƙetarewa. ");
INSERT INTO hausa_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Ku ɗauki ƙunshin itacen hizzob, ku tsoma cikin jinin da yake a kwano, ku yayyafa wa dogaran ƙofa duka biyu, da bisa kan ƙofar. Kada wani daga cikinku yă fita daga ƙofar gidansa sai da safe. ");
INSERT INTO hausa_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Sa’ad da Ubangiji yake ratsa ƙasar don yă bugi Masarawa, zai ga jinin a bisa da kuma gefen madogaran ƙofa, zai ƙetare ƙofar, ba zai bar mai hallakawa yă shiga gidajenku, yă buge ku ba. ");
INSERT INTO hausa_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“Ku kiyaye waɗannan dokokin a matsayin dawwammamiyar farilla, da ku da ’ya’yanku har abada. ");
INSERT INTO hausa_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Sa’ad da kuka shiga ƙasar da Ubangiji zai ba ku yadda ya alkawarta, ku kiyaye wannan biki. ");
INSERT INTO hausa_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Sa’ad da kuma ’ya’yanku suka tambaye ku, ‘Mece ce manufar wannan biki?’ ");
INSERT INTO hausa_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Sai ku faɗa musu, ‘Hadaya ce ta Bikin Ƙetarewa ga Ubangiji, domin ya tsallake gidajen Isra’ilawa a Masar, lokacin da ya kashe Masarawa, amma bai taɓa gidajenmu ba.’ ” Sai mutane suka rusuna, suka yi sujada. ");
INSERT INTO hausa_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Isra’ilawa suka tafi suka yi yadda Ubangiji ya umarci Musa da Haruna. ");
INSERT INTO hausa_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Da tsakar dare, sai Ubangiji ya karkashe dukan ’ya’yan fari a ƙasar Masar, tun daga ɗan farin Fir’auna, wato, magājinsa, har zuwa ɗan fari na ɗan sarƙa da yake kurkuku, har da ’ya’yan fari na dabbobi. ");
INSERT INTO hausa_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Fir’auna da dukan fadawansa da kuma dukan Masarawa, suka tashi a cikin daren da kuka mai zafi, aka kuma ji kukan a ko’ina a cikin ƙasar Masar, gama ba gidan da ba a yi mutuwa ba. ");
INSERT INTO hausa_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","A cikin daren, Fir’auna ya aika a kira Musa da Haruna ya ce, “Ku tashi, ku da jama’arku, ku fita daga cikin jama’ata. Ku tafi, ku bauta wa Ubangiji yadda kuka ce. ");
INSERT INTO hausa_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Ku kwashi garkunanku na tumaki da na awaki, da na shanu, ku yi tafiyarku kamar yadda kuka ce, amma ku sa mini albarka.” ");
INSERT INTO hausa_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Masarawa suka matsa wa Isra’ilawa su fita daga ƙasarsu da sauri. Gama mutanen Masar sun ce, “Ai, za mu mutu duka, in ba su tafi ba!” ");
INSERT INTO hausa_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Sai mutanen suka ɗauki garin da sun kwaɓa ba yisti a ciki, tare da ƙwaryansu na aikin kwaɓan, suka nannaɗe su a mayafansu, suka rataye a kafaɗunsu. ");
INSERT INTO hausa_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Isra’ilawa kuwa suka yi yadda Musa ya umarce su, suka roƙi Masarawa kayan adonsu na azurfa da na zinariya, da kuma tufafi. ");
INSERT INTO hausa_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Ubangiji kuwa ya sa Isra’ilawa suka yi farin jini a wurin Masarawa, Masarawa kuma suka saki hannu wa mutanen, suka ba su duk abin da suka roƙa; ta haka Isra’ilawa suka washe Masarawa. ");
INSERT INTO hausa_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Isra’ilawa suka kama tafiya daga Rameses zuwa Sukkot. Akwai maza dubu ɗari shida da suke tafiya da ƙafa, ban da mata da yara. ");
INSERT INTO hausa_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Waɗansu mutane da yawa da ba Isra’ilawa ba, suka haura tare da su, da garkunan shanu, da na tumaki da awaki. ");
INSERT INTO hausa_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Suka toya burodi marar yisti da garin da aka kwaɓa wanda suka kawo daga Masar. Garin da aka kwaɓan ba shi da yisti, domin an kore su daga Masar, ba su kuwa sami damar shirya wa kansu abinci ba. ");
INSERT INTO hausa_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Zaman da Isra’ilawa suka yi a Masar, ya kai shekara 430. ");
INSERT INTO hausa_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","A ranar da shekara 430 ɗin nan suka cika, a ran nan ne dukan ɓangare-ɓangare na mutanen Ubangiji suka bar Masar. ");
INSERT INTO hausa_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Gama Ubangiji ya yi tsaro a wannan dare, domin yă fitar da su daga Masar, a wannan dare, dole dukan Isra’ilawa su yi tsaro, don su girmama Ubangiji, cikin dukan tsararraki masu zuwa. ");
INSERT INTO hausa_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Ubangiji ya ce wa Musa da Haruna, “Waɗannan ne ƙa’idodin Bikin Ƙetarewa. “Ba baƙon da zai ci shi. ");
INSERT INTO hausa_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Duk bawan da kuka sayo, yana iya ci, in dai an yi masa kaciya, ");
INSERT INTO hausa_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","amma wanda ba ya zama tare da ku na ɗinɗinɗin, da kuma wanda aka ɗauki hayansa, ba zai ci ba. ");
INSERT INTO hausa_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“Dole a ci shi a cikin gida ɗaya; kada a kai naman waje. Kada a karya wani daga ƙasusuwansa. ");
INSERT INTO hausa_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Dole dukan taron jama’ar Isra’ila su yi bikin. ");
INSERT INTO hausa_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","“Baƙon da yake zama tare da ku da yake so yă yi Bikin Ƙetarewar Ubangiji, dole yă yi wa dukan mazan da suke cikin gidansa kaciya; sa’an nan ne zai iya yin abubuwa kamar haifaffen ɗan ƙasa. ");
INSERT INTO hausa_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Wannan za tă zama dawwammamiyar farilla ta shafi ɗan ƙasa da kuma baƙon da yake zama a tsakaninku.” ");
INSERT INTO hausa_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Dukan Isra’ilawa suka yi na’am da shi, suka yi yadda Ubangiji ya umarci Musa da Haruna. ");
INSERT INTO hausa_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","A wannan rana, Ubangiji ya fito da Isra’ilawa ɓangare-ɓangare daga Masar. ");
INSERT INTO hausa_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Keɓe mini kowane ɗan fari. Ɗan fari wanda ya fara buɗe mahaifa a cikin Isra’ilawa nawa ne, ko na mutum ko na dabba.” ");
INSERT INTO hausa_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Sai Musa ya ce wa mutane, “Ku tuna da wannan rana, ranar da kuka fito daga Masar, daga ƙasar bauta, gama Ubangiji ya fito da ku da hannu mai iko. Kada ku ci wani abin da yake da yisti. ");
INSERT INTO hausa_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","A wannan rana kuka fita, wato, a watan Abib. ");
INSERT INTO hausa_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Sa’ad da Ubangiji ya kawo ku cikin ƙasar Kan’aniyawa, Hittiyawa, Amoriyawa, Hiwiyawa da Yebusiyawa, ƙasar da ya rantse wa kakanninku cewa zai ba ku, ƙasar da take zub da madara da zuma, za ku kiyaye wannan biki a wannan wata. ");
INSERT INTO hausa_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Kwana bakwai za ku ci burodi marar yisti, a kan rana ta bakwai kuma za ku yi biki ga Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Ku ci burodi marar yisti cikin kwana bakwai; kada a sami wani abu mai yisti a cikinku, ko a sami yisti a ko’ina a wurinku. ");
INSERT INTO hausa_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","A ranan nan kowa zai faɗa wa ɗanka, ‘Ina yin haka saboda abin da Ubangiji ya yi mini, sa’ad da na fita daga Masar.’ ");
INSERT INTO hausa_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Wannan abin tunawa zai zama muku alama a hannunku, da kuma a goshinku cewa dokar Ubangiji tana a bakinku. Gama Ubangiji ya fitar da ku daga Masar da hannu mai iko. ");
INSERT INTO hausa_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Dole ku kiyaye wannan farilla kowace shekara a lokacinta. ");
INSERT INTO hausa_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“Bayan Ubangiji ya kawo ku cikin ƙasar Kan’aniyawa, ya kuma ba da ita yadda ya alkawarta muku da rantsuwa, ku da kakanninku, ");
INSERT INTO hausa_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","sai ku miƙa kowane ɗan fari ga Ubangiji. Duk ɗan farin dabbobinku na Ubangiji ne. ");
INSERT INTO hausa_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Amma a fanshi kowane ɗan farin jakinku da ɗan rago. In kuwa ba za ku fanshe shi ba, sai ku karye wuyansa. Sai ku fanshe kowane ɗan farin daga cikin ’ya’yanku. ");
INSERT INTO hausa_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“A kwanaki masu zuwa, in ɗanka ya tambaye ka, ‘Mene ne manufar wannan?’ Ka faɗa masa cewa, ‘Da hannu mai iko Ubangiji ya fito da mu daga Masar, daga ƙasar bauta. ");
INSERT INTO hausa_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Sa’ad da Fir’auna ya taurare zuciyarsa, bai yarda ya sallame mu ba, sai Ubangiji ya kashe dukan ’ya’yan farin ƙasar Masar, na mutum da na dabba, gaba ɗaya. Domin haka nake yin hadaya ga Ubangiji da ’ya’yan fari, maza, da suka fara buɗe mahaifa, amma nakan fanshi dukan ’ya’yan farina maza.’ ");
INSERT INTO hausa_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Za tă kuma zama alama a hannunku da kuma shaida a goshinku cewa Ubangiji ya fito da mu daga Masar da hannunsa mai iko.” ");
INSERT INTO hausa_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Sa’ad da Fir’auna ya bar mutane su tafi, Allah bai bi da su a hanyar da ta bi ta iyakar Filistiyawa ba, ko da yake wannan hanya ce ta fi kusa. Gama Allah ya ce, “In suka fuskanci yaƙi, wataƙila su canja ra’ayinsu su koma Masar.” ");
INSERT INTO hausa_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Saboda haka Allah ya kewaye da mutanen ta hamada zuwa Jan Teku. Isra’ilawa kuwa suka fita daga Masar da shirin yaƙi. ");
INSERT INTO hausa_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Musa ya ɗauki ƙasusuwan Yusuf tare da shi, gama Yusuf ya sa Isra’ilawa su rantse masa. Ya ce, “Tabbatacce Allah zai taimake ku, sai ku ɗibi ƙasusuwana tare da ku daga wannan wuri.” ");
INSERT INTO hausa_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Bayan sun bar Sukkot sai suka kafa sansani a Etam a bakin hamada. ");
INSERT INTO hausa_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Da rana Ubangiji yakan ja gabansu a cikin al’amudin girgije domin yă bishe su a kan hanyarsu, da dare kuma a cikin al’amudin wuta domin yă ba su haske, domin su iya tafiya dare da rana. ");
INSERT INTO hausa_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Al’amudan nan biyu, na girgije da na wuta, ba su daina yi wa jama’a jagora ba. ");
INSERT INTO hausa_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Sa’an nan Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Ka faɗa wa Isra’ilawa, su juya su kafa sansani a Fi Hahirot, a tsakanin Migdol da teku. Za su kafa sansanin kai tsaye kusa da teku, wanda ya fuskanci Ba’al-Zafon. ");
INSERT INTO hausa_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Fir’auna zai yi tsammani, ‘Aha, Isra’ilawa sun rikice cikin ƙasar, hamada kuwa ta yimƙe su.’ ");
INSERT INTO hausa_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Zan kuma taurare zuciyar Fir’auna, zai kuwa bi su. Na shirya wannan domin in nuna ɗaukakata a bisa Fir’auna da ƙungiyar sojansa. Bayan wannan, mutanen Masar za su sani ni ne Ubangiji.” Sai Isra’ilawa suka yi haka. ");
INSERT INTO hausa_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Sa’ad da aka faɗa wa Fir’auna cewa Isra’ilawa sun gudu, sai Fir’auna da bayinsa suka canja ra’ayinsu game da su, suka ce, “Me muka yi? Mun bar Isra’ilawa suka tafi, mun kuwa rasa hidimarsu!” ");
INSERT INTO hausa_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Sai shi da keken yaƙinsa suka shirya, ya kuma ɗauki sojojinsa tare da shi. ");
INSERT INTO hausa_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Ya ɗauki kekunan yaƙi ɗari shida mafi kyau duka, tare da duk sauran keken yaƙin Masar, da shugabanni kuma a kan dukansu. ");
INSERT INTO hausa_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Ubangiji ya taurare zuciyar Fir’auna sarkin Masar, domin yă bi Isra’ilawa waɗanda suke tafiya ba tsoro. ");
INSERT INTO hausa_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Masarawa, dukan dawakan Fir’auna da kekunan yaƙi da mahaya da sojoji, suka bi Isra’ilawa suka cin musu yayinda suke a sansani kusa da teku kurkusa da Fi Hahirot, wanda ya fuskanci Ba’al-Zafon. ");
INSERT INTO hausa_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Da Fir’auna ya yi kusa, Isra’ilawa suka ɗaga idanu sai suka hange Masarawa daga nesa suna tā da ƙura suna zuwa. Sai suka tsorata ƙwarai, suka kuwa yi kuka ga Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Suka ce wa Musa, “Don babu makabarta a Masar ne, ka kawo mu a hamada mu mutu? Me ka yi mana ke nan da ka fitar da mu daga Masar? ");
INSERT INTO hausa_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Ba mu faɗa maka a Masar ba, cewa ‘Ka bar mu mu bauta wa Masarawa’? Ai, da ya fi mana mu bauta wa Masarawa, da a ce mu mutu a hamada!” ");
INSERT INTO hausa_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Musa ya amsa wa mutane ya ce, “Kada ku ji tsoro. Ku tsaya dai ku ga ceton da Ubangiji zai kawo muku yau. Masarawan da kuke gani yau, ba za ku ƙara ganinsu ba. ");
INSERT INTO hausa_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Ubangiji zai yi yaƙi dominku, ku dai tsaya kurum.” ");
INSERT INTO hausa_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Sa’an nan Ubangiji ya ce wa Musa, “Don me kake mini kuka? Ka faɗa wa Isra’ilawa su ci gaba da tafiya. ");
INSERT INTO hausa_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Ka ɗaga sandanka, ka miƙa shi bisa teku don ruwa yă rabu domin Isra’ilawa su wuce cikin teku a kan busasshiyar ƙasa. ");
INSERT INTO hausa_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Zan taurare zukatan Masarawa su shiga don su bi su. Ta haka zan ci nasara bisa Fir’auna da rundunansa, da keken yaƙinsa, da mahayan dawakansa. ");
INSERT INTO hausa_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Masarawa za su sani ni ne Ubangiji sa’ad da na sami nasara bisa kan Fir’auna, da keken yaƙinsa, da mahayan dawakansa.” ");
INSERT INTO hausa_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Sai mala’ikan Allah wanda yake tafiya a gaban sojojin Isra’ila, ya janye, ya koma bayansu. Al’amudin girgije shi ma ya koma, ya tsaya a bayansu, ");
INSERT INTO hausa_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","ya dawo tsakanin sojojin Masar da na Isra’ila. Duk dare, girgijen ya jawo duhu ga gefe ɗaya, haske kuma ga ɗaya gefen; saboda haka ba wanda ya kusaci wani duk dare. ");
INSERT INTO hausa_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Da Musa ya miƙa hannunsa a bisa teku, sai Ubangiji ya tura teku baya da iskar gabas mai ƙarfi duk dare, ya maishe shi busasshiyar ƙasa. Ruwa ya rabu, ");
INSERT INTO hausa_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","sai Isra’ilawa suka wuce cikin teku a kan busasshiyar ƙasa, ruwan ya zama musu katanga dama da hagu. ");
INSERT INTO hausa_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Masarawa suka bi su da dukan dawakan Fir’auna, da kekunan yaƙi, da mahayan, suka bi su cikin teku. ");
INSERT INTO hausa_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Da asubahin fāri, sai Ubangiji ya dubi ƙasa a kan sojojin Masarawa daga al’amudin wuta da kuma girgije, sai ya sa suka ruɗe. ");
INSERT INTO hausa_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Ya sa ƙafafun keken yaƙinsu suka fita don su kāsa tuƙi. Sai Masarawa suka ce, “Bari mu gudu daga Isra’ilawa gama Ubangiji yana yaƙi dominsu gāba da Masar.” ");
INSERT INTO hausa_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Sa’an nan Ubangiji ya ce wa Musa, “Miƙa hannunka bisa teku don ruwa yă koma kan Masarawa, da keken yaƙinsu, da kuma mahayansu.” ");
INSERT INTO hausa_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Musa ya miƙa hannunsa a bisa tekun, da wayewar gari kuwa teku ya koma wurinsa na dā. Masarawa suka yi ƙoƙari su gudu, sai Ubangiji ya tura su cikin teku. ");
INSERT INTO hausa_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Ruwan ya komo ya rufe keken yaƙin da mahayan, dukan sojojin Fir’aunan da suka bi bayan Isra’ilawa cikin teku, ba ko ɗaya da ya tsira. ");
INSERT INTO hausa_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Amma Isra’ilawa suka wuce cikin teku a busasshiyar ƙasa, ruwa kuwa ya yi musu katanga dama da hagu. ");
INSERT INTO hausa_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","A rana nan Ubangiji ya cece Isra’ila daga hannuwan Masarawa, Isra’ilawa kuwa suka ga gawawwakin Masarawa a bakin teku. ");
INSERT INTO hausa_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Sa’ad da Isra’ilawa suka ga iko mai girma da Ubangiji ya yi gāba da Masarawa, sai mutanen suka ji tsoron Ubangiji, suka amince da shi, da kuma bawansa Musa. ");
INSERT INTO hausa_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Sa’an nan Musa da Isra’ilawa suka rera wannan waƙa ga Ubangiji suka ce, “Zan rera waƙa ga Ubangiji gama an ɗaukaka shi ƙwarai. Doki da mahayinsa ya jefa su cikin teku. ");
INSERT INTO hausa_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","“Ubangiji ne ƙarfina da mafakata, ya zama cetona. Shi Allahna ne, zan yabe shi. Allah na kakana, zan ɗaukaka shi. ");
INSERT INTO hausa_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Ubangiji mai yaƙi ne Ubangiji ne sunansa. ");
INSERT INTO hausa_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Karusan Fir’auna da sojojinsa ya jefa cikin teku. Zaɓaɓɓun jarumawansa ya nutsar da su cikin Bahar Maliya. ");
INSERT INTO hausa_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Zurfafan ruwaye sun rufe su; suka nutse cikin zurfi kamar dutse. ");
INSERT INTO hausa_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Hannun damanka, ya Ubangiji, Mai kwarjini ne da iko, hannun damanka, ya Ubangiji, ya farfashe magabci. ");
INSERT INTO hausa_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","“A cikin girman kwarjininka ka kā da waɗanda sun yi gāba da kai. Ka aiki fushinka mai zafi ya cinye su kamar tattaka. ");
INSERT INTO hausa_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Da hucin numfashin hancinka ruwaye suka tattaru. Ruwaye masu kwararowa, suka tsaya kamar bango; ruwaye na zurfafa suka daskare a tsakiyar teku. ");
INSERT INTO hausa_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Magabci ya yi fahariya, cewa ‘Zan fafare su, in ci musu. Zan raba ganima; abin da na so ya samu. Zan ja takobina hannuna kuwa zai hallaka su.’ ");
INSERT INTO hausa_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Amma ka hura numfashinka sai teku ya rufe su. Suka nutse kamar darma cikin manyan ruwaye. ");
INSERT INTO hausa_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Wane ne cikin alloli, ya yi kamar ka, ya Ubangiji? Wane ne kamar ka, mai ɗaukaka cikin tsarki, mai banrazana cikin ɗaukaka, mai aikata al’ajabai? ");
INSERT INTO hausa_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","“Ka miƙa hannunka na dama, ƙasa ta haɗiye abokan gābanka. ");
INSERT INTO hausa_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","A cikin ƙaunarka marar iyaka, za ka bishe mutanen da ka fansa. A cikin ƙarfinka, za ka bishe su zuwa mazauninka mai tsarki. ");
INSERT INTO hausa_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Al’ummai za su ji, su yi rawar jiki tsoro zai kama mutanen Filistiya. ");
INSERT INTO hausa_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Sarakunan Edom za su tsorata, shugabannin Mowab za su yi rawar jiki, mutanen Kan’ana za su narke. ");
INSERT INTO hausa_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Razana da tsoro za su fāɗo a kansu. Da ikon hannunka za su tsaya cik kamar dutse, har sai mutanen da ka kawo sun wuce, ya Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Za ka kawo su, ka dasa su a kan dutsen nan naka inda, ya Ubangiji, ka shirya domin mazauninka, wuri mai tsarkin da hannuwanka suka kafa, ya Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","“Ubangiji zai yi mulki har abada abadin.” ");
INSERT INTO hausa_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Sa’ad da dawakai, kekunan yaƙi da mahayan dawakan Fir’auna suka shiga cikin teku, Ubangiji ya mayar da ruwan teku a kansu, amma Isra’ilawa suka wuce a cikin teku a busasshiyar ƙasa. ");
INSERT INTO hausa_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Sa’an nan Miriyam annabiya, ’yar’uwar Haruna ta ɗauki ganga a hannunta, dukan mata kuwa suka bi ta, da ganguna suna rawa. ");
INSERT INTO hausa_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Miriyam ta yi musu waƙa. “Ku rera ga Ubangiji gama ya ci gawurtacciyar nasara. Doki da mahayi, ya jefa cikin teku.” ");
INSERT INTO hausa_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Sai Musa ya jagoranci Isra’ila daga jan teku zuwa hamadar Shur. Kwana uku suka yi tafiya cikin hamada ba su sami ruwa ba. ");
INSERT INTO hausa_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Da suka zo Mara, ba su iya shan ruwan ba saboda yana da ɗaci (shi ya sa ake kira wurin Mara). ");
INSERT INTO hausa_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Sai mutanen suka yi gunaguni a kan Musa, suna cewa, “Me za mu sha?” ");
INSERT INTO hausa_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Sai Musa ya yi kuka ga Ubangiji, Ubangiji kuwa ya nuna masa wani itace. Sai ya jefa shi cikin ruwan, sai ruwan ya zama mai daɗi. A can Ubangiji ya yi musu doka da farilla, a can kuma ya gwada su. ");
INSERT INTO hausa_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Ya ce, “In kun kasa kunne ga muryar Ubangiji Allahnku kuka yi abin da yake daidai a idanunsa, in kun mai da hankali ga umarnansa, kuka kiyaye dukan farillansa, ba zan kawo muku wani ciwon da na kawo a kan Masarawa ba, gama ni ne Ubangiji da nake warkar da ku.” ");
INSERT INTO hausa_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Sai suka zo Elim inda akwai maɓulɓulan ruwa goma sha biyu da itatuwan dabino saba’in, suka sauka a can, kusa da ruwa. ");
INSERT INTO hausa_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Dukan taron Isra’ila suka tashi daga Elim suka zo hamadar Sin, wadda take tsakanin Elim da Sinai, a rana ta goma sha biyar ga wata biyu, bayan sun fito daga Masar. ");
INSERT INTO hausa_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","A hamadan, dukan taro suka yi gunaguni a kan Musa da Haruna. ");
INSERT INTO hausa_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Isra’ilawa suka ce musu, “Da ma a hannun Ubangiji ne muka mutu a Masar, inda muka zauna kewaye da tukwanen nama, muna cin duk abincin da muke so, amma kun kawo mu cikin wannan hamada don ku kashe dukan wannan taro da yunwa.” ");
INSERT INTO hausa_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Sai Ubangiji ya ce wa Musa, “Zan zubo muku burodi kamar ruwa daga sama. Mutanen za su fita kowace rana su tattara abin da zai ishe su na ranan. Ta haka zan gwada su in ga ko za su bi umarnaina. ");
INSERT INTO hausa_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","A rana ta shida za su shirya abin da suka kwaso, wannan kuwa zai zama ninki biyu na abin da sukan tattara na sauran ranaku.” ");
INSERT INTO hausa_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Saboda haka Musa da Haruna suka ce wa dukan Isra’ila, “Da yamma za ku sani Ubangiji ne ya fitar da ku daga Masar. ");
INSERT INTO hausa_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Da safe za ku ga ɗaukakar Ubangiji, saboda ya ji gunaguninku a kansa. Wane mu, da za ku yi gunaguni a kanmu?” ");
INSERT INTO hausa_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Musa ya kuma ce, “Za ku san cewa shi ne Ubangiji, sa’ad da ya ba ku nama ku ci da yamma, da kuma duk burodin da kuke so da safe, saboda ya ji gunagunin da kuka yi a kansa. Namu a wane? Ai, gunaguninku ba a kanmu ba, amma a kan Ubangiji ne.” ");
INSERT INTO hausa_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Sai Musa ya ce wa Haruna, “Ka faɗa wa dukan taron Isra’ila, ‘Ku zo gaban Ubangiji, gama ya ji gunaguninku.’ ” ");
INSERT INTO hausa_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Yayinda Haruna yake magana da dukan taron Isra’ila, sai suka duba wajen hamada, sai ga ɗaukakar Ubangiji tana bayyana a girgije. ");
INSERT INTO hausa_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Na ji gunagunin Isra’ilawa. Ka faɗa musu, ‘A tsakanin fāɗuwar rana da almuru, za ku ci nama, da safe kuma za ku ƙoshi da burodi. Sa’an nan za ku sani ni ne Ubangiji Allahnku.’ ” ");
INSERT INTO hausa_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Da yamman wannan rana, sai makware suka rufe dukan sansani, da safe kuma sai ga raɓa ta kewaye sansani. ");
INSERT INTO hausa_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Lokacin da raɓar ta watse, sai ga wani abu kamar tsaki, falle-falle kuma da laushi, fari, kamar hazo, a ƙasa. ");
INSERT INTO hausa_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Sa’ad da Isra’ilawa suka ga wannan, sai suka ce wa junansu, “Mene ne wannan?” Gama ba su san ko mene ne ba. Musa ya ce musu, “Wannan shi ne burodin da Ubangiji ya ba ku ku ci. ");
INSERT INTO hausa_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Wannan shi ne abin da Ubangiji ya umarta, ‘Kowane mutum zai tattara bisa ga bukatarsa. Ku tara rabin gallon don mutum guda da yake cikin tentinku.’ ” ");
INSERT INTO hausa_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Isra’ilawa suka yi kamar yadda aka faɗa musu, waɗansu suka tattara da yawa, waɗansu kuma kaɗan. ");
INSERT INTO hausa_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Da suka gwada a mudu, wanda ya tattara da yawa bai sami mafi yawa ba, wanda kuma ya tattara kaɗan bai sami ƙanƙani ba. Kowane mutum ya tattara daidai bukatarsa. ");
INSERT INTO hausa_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Sa’an nan Musa ya ce musu, “Kada wani yă bar saura har safe.” ");
INSERT INTO hausa_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Duk da haka waɗansu ba su kula da umarnin Musa ba, suka bar saura har safe, kashegari kuwa ta yi tsutsotsi, ta ruɓe, sai Musa ya yi fushi da su. ");
INSERT INTO hausa_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Kowace safiya, kowanne mutum yakan tattara daidai bukatarsa, lokacin da rana ta yi zafi, sai ta narke. ");
INSERT INTO hausa_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","A rana ta shida, suka tattara ninki biyu, mudu biyu ga mutum guda, sai shugabannin taron suka zo suka kawo ƙara wurin Musa. ");
INSERT INTO hausa_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Shi kuma ya ce musu, “Wannan shi ne umarnin Ubangiji, ‘Gobe za tă zama ranar hutu, Asabbaci mai tsarki ga Ubangiji. Domin haka sai ku toya abin da kuke so ku toya, ku kuma dafa abin da kuke so ku dafa. Abin da ya rage ku ajiye har safe.’ ” ");
INSERT INTO hausa_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Sai suka bar saura har safe, kamar yadda Musa ya umarta, bai kuwa yi wari ko yă yi tsutsa ba. ");
INSERT INTO hausa_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Musa ya ce, “Ku ci shi yau, saboda yau Asabbaci ne na Ubangiji. Ba za ku same shi a ƙasa a yau ba. ");
INSERT INTO hausa_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Kwana shida za ku tattara shi, amma a rana ta bakwai, Asabbaci, ba za a same shi ba.” ");
INSERT INTO hausa_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Duk da haka waɗansu mutane suka fita a ranar Asabbaci don su tattara, amma ba su sami kome ba. ");
INSERT INTO hausa_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Sai Ubangiji ya ce wa Musa, “Har yaushe za ku ƙi bin dokokina da umarnaina? ");
INSERT INTO hausa_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Ku lura fa, ai, Ubangiji ne ya ba ku Asabbaci; shi ya sa a kan ba ku burodi na kwana biyu, a rana ta shida. Kowa ya kamata yă kasance inda yake a rana ta bakwai; kada kowa yă fita.” ");
INSERT INTO hausa_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Sai mutanen suka huta a rana ta bakwai. ");
INSERT INTO hausa_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Mutanen Isra’ila suka kira burodin Manna. Manna yana nan fari kamar farin riɗi, ɗanɗanonsa kuma yana kama da masa da aka yi da zuma. ");
INSERT INTO hausa_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Musa ya ce, “Wannan shi ne abin da Ubangiji ya umarta, ‘Ku auna mudu guda na Manna, a adana ta dukan zamananku, domin kowane zamani yă ga irin abincin da na ba ku ku ci a hamada, yayinda na fitar da ku daga Masar.’ ” ");
INSERT INTO hausa_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Saboda haka Musa ya ce wa Haruna, “Ka ɗauki tulu, ka sa mudu guda na Manna a ciki. Sa’an nan ka sa shi a gaban Ubangiji, don a adana don tsararraki masu zuwa.” ");
INSERT INTO hausa_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Sai Haruna ya ajiye Mannar a gaban Akwatin Alkawari, don a adana ta kamar yadda Ubangiji ya umarci Musa. ");
INSERT INTO hausa_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Isra’ilawa suka yi shekaru arba’in suna cin Manna, har sai da suka shiga cikin ƙasar da take da mutane, suka ci Manna har zuwa kan iyakar ƙasar Kan’ana. ");
INSERT INTO hausa_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(Omer guda, daidai ne da kashi ɗaya bisa goma na Efa.) ");
INSERT INTO hausa_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Dukan taron Isra’ilawa suka kama tafiya daga Hamadar Sin, suka yi ta tafiya suna sauka a wurare dabam-dabam bisa ga umarnin Ubangiji. A ƙarshe suka sauka a Refidim, suka zauna a can, amma ba ruwan da jama’a za su sha. ");
INSERT INTO hausa_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Saboda haka suka yi wa Musa maganganun banza suka ce, “Ba mu ruwa mu sha.” Musa ya amsa ya ce, “Don me kuke mini maganganun banza? Don me kuke gwada Ubangiji?” ");
INSERT INTO hausa_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Amma mutanen suka yi fama da ƙishirwa a can, suka yi gunaguni a kan Musa. Suka ce, “Don me ka fitar da mu daga Masar, ka sa mu da ’ya’yanmu da dabbobinmu, mu mutu da ƙishirwa?” ");
INSERT INTO hausa_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Sai Musa ya yi kuka ga Ubangiji ya ce, “Me zan yi da wannan jama’a? Suna shiri su jajjefe ni da duwatsu.” ");
INSERT INTO hausa_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Ubangiji amsa wa Musa, “Ka ɗauki sandan da ka bugi ruwan Nilu da shi. Ka kira waɗansu shugabannin Isra’ila, ku wuce a gaban jama’ar. ");
INSERT INTO hausa_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Zan tsaya a can a gabanka, kusa da dutsen Horeb. Ka bugi dutsen, ruwa kuwa zai fito daga gare shi domin mutane su sha.” Sai Musa ya yi haka a idon dattawan Isra’ila. ");
INSERT INTO hausa_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Sai suka ba wa wurin suna, Massa da Meriba, saboda Isra’ilawa sun yi jayayya, suka kuma gwada Ubangiji cewa, “Ubangiji yana tsakaninmu ko babu?” ");
INSERT INTO hausa_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Amalekawa suka zo, suka yaƙi Isra’ilawa a Refidim. ");
INSERT INTO hausa_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Musa ya ce wa Yoshuwa, “Zaɓi waɗansu mazanmu, ka je ka yaƙi Amalekawa. Gobe zan tsaya a bisa tudu, da sandan Allah a hannuwana.” ");
INSERT INTO hausa_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Sai Yoshuwa ya yaƙi Amalekawa kamar yadda Musa ya umarta, Musa, Haruna da Hur kuwa suka tafi bisa tudu. ");
INSERT INTO hausa_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Muddin hannun Musa yana a miƙe, sai Isra’ilawa su yi ta cin nasara, amma da zarar hannunsa ya sauka, sai Amalekawa su yi ta cin nasara. ");
INSERT INTO hausa_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Sa’ad da hannuwan Musa suka gaji, sai Haruna da Hur suka ɗauki dutse suka sa ya zauna a kai. Sa’an nan su kuma suka tsaya gefe da gefe, suna riƙe da hannuwansa har fāɗuwar rana. ");
INSERT INTO hausa_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Sai Yoshuwa kuwa ya ci nasara a kan Amalekawa da takobi. ");
INSERT INTO hausa_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Sa’an nan Ubangiji ya ce wa Musa, “Ka rubuta wannan a cikin littafi, yă zama abin tuni, ka kuma faɗa wa Yoshuwa zan hallaka Amalekawa ƙaƙaf daga duniya.” ");
INSERT INTO hausa_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Musa ya gina bagade, sai ya kira shi Ubangiji shi ne Tutata. ");
INSERT INTO hausa_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Ya ce, “Gama an ɗaga hannuwa sama zuwa kursiyin Ubangiji, Ubangiji zai yaƙi Amalekawa daga tsara zuwa tsara.” ");
INSERT INTO hausa_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Ana nan sai Yetro firist na Midiyan, kuma surukin Musa, ya ji duk abin da Allah ya yi wa Musa da mutanensa Isra’ila, da kuma yadda Ubangiji ya fitar da Isra’ila daga Masar. ");
INSERT INTO hausa_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Bayan da Musa ya tura matarsa Ziffora gida, sai surukinsa Yetro ya karɓe ta ");
INSERT INTO hausa_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","da ’ya’yanta biyu maza. Ana kira ɗaya Gershom, domin Musa ya ce, “Na zama baƙo a baƙuwar ƙasa”; ");
INSERT INTO hausa_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","ɗayan kuma Eliyezer, domin ya ce, “Allah mahaifina ya taimake ni ya cece ni daga takobin Fir’auna.” ");
INSERT INTO hausa_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Yetro surukin Musa tare da ’ya’yan Musa da matarsa suka zo wurin Musa a hamada, inda suka kafa sansani kusa da dutsen Allah ");
INSERT INTO hausa_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Yetro ya riga ya aika wa Musa cewa, “Ni surukinka Yetro, ina zuwa wurinka tare da matarka da ’ya’yanka maza biyu.” ");
INSERT INTO hausa_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Sai Musa ya tafi yă taryi surukinsa, ya sunkuya ya yi masa sumba. Suka gai da juna, sa’an nan suka shiga tenti. ");
INSERT INTO hausa_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Musa kuwa ya faɗa wa surukinsa duk abubuwan da Ubangiji ya yi wa Fir’auna da Masarawa domin Isra’ila, da batun wahalolin da suka sha a hanya, da yadda Ubangiji ya cece su. ");
INSERT INTO hausa_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Yetro ya yi murna da jin duk abubuwa masu kyau da Ubangiji ya yi wa Isra’ila, wajen cetonsu daga hannun Masarawa. ");
INSERT INTO hausa_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","“Yabo ga Ubangiji wanda ya cece ku daga hannun Masarawa da na Fir’auna, wanda kuma ya cece mutanensa daga hannun Masarawa. ");
INSERT INTO hausa_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Yanzu na san cewa Ubangiji ya fi kowane allah, gama ya yi wannan ga masu girman kai da kuma waɗanda suka wulaƙanta Isra’ila.” ");
INSERT INTO hausa_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Sa’an nan Yetro surukin Musa, ya kawo hadaya ta ƙonawa da waɗansu hadayu wa Allah, Haruna ya zo tare da dukan dattawan Isra’ila, suka ci abinci tare da surukin Musa a gaban Allah. ");
INSERT INTO hausa_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Kashegari, Musa ya zauna domin yă yi wa mutane shari’a, sai suka tsaya kewaye da shi daga safe har yamma. ");
INSERT INTO hausa_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Sa’ad da surukinsa ya lura da duk abin da Musa yake yi saboda mutane, sai ya ce, “Mene ne wannan da kake yi wa mutane? Don me kai kaɗai kake zama kana yin shari’a wa mutane, yayinda mutanen nan suke tsaya kewaye da kai daga safe har yamma?” ");
INSERT INTO hausa_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Musa ya amsa ya ce, “Saboda mutanen suna zuwa wurina, don su nemi nufin Allah. ");
INSERT INTO hausa_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Duk lokacin da suke da gardama, akan kawo su a wurina, ni kuma sai in raba tsakaninsu, in kuma koya musu dokokin Allah da farillansa.” ");
INSERT INTO hausa_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Surukin Musa ya amsa ya ce, “Abin da kake yi ba daidai ba ne. ");
INSERT INTO hausa_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Kai da dukan mutanen da suke zuwa wurinka za ku gajiyar da kanku. Aikin ya fi ƙarfinka; ba za ka iya yinsa kai kaɗai ba. ");
INSERT INTO hausa_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Ka kasa kunne gare ni yanzu, zan ba ka shawara, Allah kuma yă kasance tare da kai. Kai za ka zama wakilin mutane a gaban Allah, ka kuma kawo gardamansu gare shi. ");
INSERT INTO hausa_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Ka koya musu dokokinsa da farillarsa, ka kuma nuna musu hanyar rayuwa da ayyukan da za su yi. ");
INSERT INTO hausa_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Amma ka zaɓi mutane masu iyawa daga dukan mutane, maza masu tsoron Allah, amintattu, masu ƙin rashawa, ka sanya su shugabanni na dubbai, ɗari-ɗari, hamsin-hamsin da goma-goma. ");
INSERT INTO hausa_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Bari waɗannan mutane su sassanta mutane a kan ƙananan matsaloli, amma kowace babban matsala, ko bukata ta musamman, sai su kawo wurinka, ƙananan matsaloli kuma sai su yanke hukuncin da kansu. Ta haka ne za su taimaka wajen ɗaukan nauyin jama’a, don su sa aikin yă zama maka da sauƙi. ");
INSERT INTO hausa_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","In ka yi haka, Allah ya umarta za ka iya jimre gajiyar, kuma dukan mutanen nan za su koma gida da murna.” ");
INSERT INTO hausa_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Musa ya kasa kunne ga surukinsa, ya kuma aikata duk abin da ya faɗa. ");
INSERT INTO hausa_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Ya zaɓi mutane masu iyawa daga cikin dukan Isra’ila, ya naɗa su shugabannin mutane, shugabanni a kan dubbai, ɗari-ɗari, hamsin-hamsin da goma-goma. ");
INSERT INTO hausa_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Suka yi hidimar alƙalanci na mutane a dukan lokaci. Gardandamin da suke da wuya, suka kawo wurin Musa, amma ƙananan batuttuwa, suka shari’anta a tsakaninsu. ");
INSERT INTO hausa_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Sa’an nan Musa ya sallame surukinsa Yetro, ya kuwa koma ƙasarsa. ");
INSERT INTO hausa_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","A rana ta farko a cikin watan uku bayan da Isra’ilawa suka bar Masar, a wannan rana, suka iso Hamadar Sinai. ");
INSERT INTO hausa_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Bayan da suka tashi daga Refidim, suka shiga Hamadar Sinai, sai Isra’ilawa suka yi sansani a gaban dutsen. ");
INSERT INTO hausa_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Sai Musa ya hau kan dutsen don yă sadu da Allah, Ubangiji kuwa ya kira shi daga dutsen ya ce, “Wannan shi ne abin da za ka faɗa wa gidan Yaƙub, da kuma abin da za ka faɗa wa mutanen Isra’ila. ");
INSERT INTO hausa_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘Ku da kanku kun ga abin da na yi wa Masar, da yadda na ɗauko ku a kan fikafikan gaggafa na kawo ku wurina. ");
INSERT INTO hausa_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Yanzu, in kuka yi mini cikakken biyayya, kuka kuma kiyaye yarjejjeniyata, to, za ku zama keɓeɓɓiyar taska a gare ni a cikin dukan al’ummai. Ko da yake duk duniya tawa ce, ");
INSERT INTO hausa_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","za ku zama firistoci masu tsarki da kuma al’umma keɓaɓɓiya a gare ni.’ Waɗannan su ne kalmomin da za ka faɗa wa Isra’ilawa.” ");
INSERT INTO hausa_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Sai Musa ya koma ya aika a kira dukan dattawan mutane, ya bayyana dukan kalmomin da Ubangiji ya umarta, ya faɗa. ");
INSERT INTO hausa_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Dukan mutane suka amsa gaba ɗaya suka ce, “Za mu yi duk abin da Ubangiji ya faɗa.” Sai Musa ya mayar wa Ubangiji amsar da mutane suka bayar. ");
INSERT INTO hausa_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Ubangiji kuwa ya ce wa Musa, “Ina zuwa wurinka a cikin baƙin hadari, domin mutane su ji ni ina maganar da kai, domin su amince da kai koyaushe.” Sa’an nan Musa ya faɗa wa Ubangiji abin da mutane suka ce. ");
INSERT INTO hausa_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Sai Ubangiji ya ce wa Musa, “Tafi wurin mutanen, ka tsarkake su yau da gobe, ka sa su wanke tufafinsu. ");
INSERT INTO hausa_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Su zama da shiri a rana ta uku, gama a ranar ce Ubangiji zai sauko a kan Dutsen Sinai a idon dukan mutane. ");
INSERT INTO hausa_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Sai ka yi wa jama’a iyaka kewaye da dutsen, ka kuma faɗa musu cewa, ‘Ku mai da hankali, kada ku hau dutsen ko ku taɓa gefensa. Duk wanda ya taɓa dutsen, lalle za a kashe shi. ");
INSERT INTO hausa_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Za a jajjefe shi da duwatsu, ko a harbe shi da kibiyoyi, ba hannun da zai taɓa shi. Mutum ko dabbar da ya taɓa, ba za a bar shi da rai ba.’ Lokacin da aka ji muryar ƙaho ne kawai za su iya taru a gindin dutsen.” ");
INSERT INTO hausa_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Bayan da Musa ya gangara wurin mutane, ya tsarkake su, sai suka wanke tufafinsu. ");
INSERT INTO hausa_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Sa’an nan ya ce wa mutane, “Ku shirya kanku domin rana ta uku. Ku ƙame kanku daga yin jima’i.” ");
INSERT INTO hausa_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","A safiyar rana ta uku, aka yi tsawa, da walƙiyoyi, sai ga girgije mai duhu a bisa dutsen, aka tsananta busar ƙaho, sai dukan jama’ar da suke cikin sansani suka yi rawar jiki. ");
INSERT INTO hausa_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Sa’an nan Musa ya jagoranci mutane daga sansani domin su sadu da Allah, sai suka tsaya a gefen dutsen. ");
INSERT INTO hausa_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Dutsen Sinai kuwa ya tunnuƙe duka da hayaƙi, gama Ubangiji ya sauko a bisan dutsen cikin wuta. Hayaƙin ya hau kamar hayaƙin da yake fitowa daga matoya, duk dutsen ya yi rawa da ƙarfi, ");
INSERT INTO hausa_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","sai karar ƙaho ya yi ta ƙaruwa. Sa’an nan Musa ya yi magana, murya Allah kuwa ta amsa masa. ");
INSERT INTO hausa_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Ubangiji ya sauko a kan ƙwanƙolin Dutsen Sinai, ya kira Musa zuwa ƙwanƙolin dutsen. Musa kuwa ya haura ");
INSERT INTO hausa_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","sai Ubangiji ya ce masa, “Ka sauka ka faɗa wa jama’a, kada su kuskura su ƙetare layin iyakan nan, garin son zuwa don ganin Ubangiji, gama duk waɗanda suka yi haka za su mutu. ");
INSERT INTO hausa_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Ko firistocin da za su kusato Ubangiji sai su tsarkake kansu, don kada in hallaka su.” ");
INSERT INTO hausa_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Musa ya ce wa Ubangiji, “Mutanen ba za su hau Dutsen Sinai ba, gama kai da kanka ka gargaɗe mu, ‘Ku sa iyaka kewaye da dutsen ku kuma tsarkake shi.’ ” ");
INSERT INTO hausa_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Ubangiji ya amsa, “Sauka ka kawo Haruna tare da kai. Amma kada firistoci da mutane su zarce iyakan nan, a kan za su zo wurin Ubangiji, don kada in hallaka su.” ");
INSERT INTO hausa_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Saboda haka Musa ya sauka wurin mutane ya kuma faɗa musu. ");
INSERT INTO hausa_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Sai Allah ya faɗi waɗannan kalmomi ya ce, ");
INSERT INTO hausa_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Ni ne Ubangiji Allahnka, wanda ya fitar da ku daga Masar, daga ƙasar bauta. ");
INSERT INTO hausa_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“Ba za ka yi wa kanka waɗansu alloli ba sai ni. ");
INSERT INTO hausa_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Ba za ka yi wa kanka waɗansu alloli a siffar wani abu a sama a bisa, ko a ƙarƙashin ƙasa, ko a ƙarƙashin ruwa ba. ");
INSERT INTO hausa_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Ba za ka durƙusa gare su, ko ka yi musu sujada ba. Gama ni, Ubangiji Allahnka mai kishi ne, nakan hukunta ’ya’ya har tsara ta uku da ta huɗu na waɗanda suke ƙina, ");
INSERT INTO hausa_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","amma ina nuna ƙauna ga tsara dubbai na waɗanda suke ƙaunata, suke kuma kiyaye umarnaina. ");
INSERT INTO hausa_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Ba za ka yi amfani da sunan Ubangiji Allahnka a banza ba, gama Ubangiji zai hukunta duk wanda ya mai da sunansa banza. ");
INSERT INTO hausa_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Ka tuna da ranar Asabbaci domin ka kiyaye ta da tsarki. ");
INSERT INTO hausa_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Kwana shida za ka yi dukan aikinka, ");
INSERT INTO hausa_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","amma rana ta bakwai Asabbaci ne ga Ubangiji, Allahnka. A ranar ba za ka yi wani aiki ba, ko kai, ko ɗanka, ko ’yarka, ko bawa, ko baiwa, ko dabbarka, ko baƙon da yake zama tare da kai. ");
INSERT INTO hausa_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Gama kwana shida Ubangiji ya halicci sama da ƙasa, da teku, da duk abin da yake cikinsu, amma ya huta a rana ta bakwai. Saboda haka Ubangiji ya albarkaci ranar Asabbaci, ya kuma mai da ita mai tsarki. ");
INSERT INTO hausa_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Ka girmama mahaifinka da mahaifiyarka, domin ka yi tsawon rai a ƙasar da Ubangiji Allahnka yake ba ka. ");
INSERT INTO hausa_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Ba za ka yi kisankai ba. ");
INSERT INTO hausa_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Ba za ka yi zina ba. ");
INSERT INTO hausa_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Ba za ka yi sata ba. ");
INSERT INTO hausa_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Ba za ka ba da shaidar ƙarya a kan maƙwabcinka ba. ");
INSERT INTO hausa_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Ba za ka yi ƙyashin gidan maƙwabcinka ba. Ba za ka yi ƙyashin matar maƙwabcinka ba, ko bawansa, ko baiwarsa, ko sansa, ko jakinsa, ko duk abin da yake na maƙwabcinka ba.” ");
INSERT INTO hausa_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Da mutane suka ga tsawa da walƙiya, suka ji karar ƙaho, suka kuma ga dutsen yana hayaƙi, sai suka yi rawar jiki don tsoro. Suka tsaya da nisa ");
INSERT INTO hausa_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","suka ce wa Musa, “Ka yi magana da mu da kanka, za mu kasa kunne. Amma kada Allah ya yi mana magana, don kada mu mutu.” ");
INSERT INTO hausa_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Musa ya ce wa mutane, “Kada ku ji tsoro, gama Allah ya zo don yă gwada ku, don ku riƙa girmama shi, don kuma kada ku yi zunubi.” ");
INSERT INTO hausa_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Sa’ad da mutane suka tsattsaya da nesa, sai Musa ya matsa kusa da girgije mai duhu, inda Allah yake. ");
INSERT INTO hausa_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Sa’an nan Ubangiji ya ce wa Musa, “Ka faɗa wa Isra’ilawa wannan. ‘Kun gani da kanku cewa na yi magana da ku daga sama. ");
INSERT INTO hausa_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Kada ku yi waɗansu alloli in ban da ni, kada ku yi wa kanku allolin azurfa ko na zinariya. ");
INSERT INTO hausa_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","“ ‘Ku yi mini bagaden ƙasa, ku kuma miƙa mini hadaya ta ƙonawa da hadaya ta salama, za ku hadayar da tumakinku da awakinku da shanu. Duk inda na sa a girmama sunana, zan zo wurinku, in sa muku albarka. ");
INSERT INTO hausa_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","In kuka yi mini bagade dutse, kada ku gina shi da sassaƙaƙƙun duwatsu, gama inda guduma ta taɓa duwatsun, sun haramtu ke nan. ");
INSERT INTO hausa_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Kada ku gina wa bagadena matakala, domin kada yayinda wani yana hawa, mutane su ga tsiraicinsa.’ ");
INSERT INTO hausa_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“Waɗannan su ne dokokin da za ka sa a gabansu. ");
INSERT INTO hausa_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“In ka sayi mutumin Ibraniyawa a matsayin bawa, zai bauta maka shekara shida. Amma a shekara ta bakwai, za ka ’yantar da shi, yă tafi ’yantacce, ba tare da ya biya kome ba. ");
INSERT INTO hausa_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","In ya zo shi kaɗai, zai tafi ’yantacce shi kaɗai; amma in yana da mata a lokacin da ya zo, za tă tafi tare da shi. ");
INSERT INTO hausa_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","In maigidansa ya yi masa aure, ta kuwa haifa masa ’ya’ya maza ko mata, matan da ’ya’yan, za su zama na maigidan, sai mutumin kaɗai zai tafi ’yantacce. ");
INSERT INTO hausa_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","“Amma in bawan ya furta ya ce, ‘Ina ƙaunar maigidana, da matata, da ’ya’yana, ba na so kuma in ’yantu,’ ");
INSERT INTO hausa_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","dole maigidansa yă kai shi gaban alƙalai. Zai kai shi ƙofa ko madogarar ƙofa, yă huda kunnensa da basilla, sa’an nan zai zama bawansa duk tsawon kwanakinsa a duniya. ");
INSERT INTO hausa_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“In mutum ya sayar da ’yarsa a matsayin baiwa, ba za a ’yantar da ita kamar bawa ba. ");
INSERT INTO hausa_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","In ba tă gamshi maigida wanda ya zaɓe ta domin kansa ba, dole yă bari a fanshe ta. Ba shi da dama yă sayar da ita ga baƙi, tun da yake bai kyauta mata ba. ");
INSERT INTO hausa_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","In ya zaɓe ta domin ɗansa, dole yă ba ta duk damar da ’ya ta mace take da shi. ");
INSERT INTO hausa_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","In ya auri wata mace, ba zai hana wa baiwar abinci da sutura ba, ba kuma zai ƙi kwana da ita ba. ");
INSERT INTO hausa_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","In bai tanada mata waɗannan abubuwa uku ba, sai tă tafi ’yantacciya, babu biyan kome. ");
INSERT INTO hausa_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“Duk wanda ya bugi mutum har ya kashe shi, lalle a kashe shi. ");
INSERT INTO hausa_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Amma in ba da nufin yă kashe shi ba, sai dai in Allah ne ya nufa haka, to, sai mutumin yă tsere zuwa inda zan nuna muku. ");
INSERT INTO hausa_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Amma in mutumin ya yi dabara har ya kashe wani mutum da gangan, sai a ɗauke shi daga bagadena a kashe shi. ");
INSERT INTO hausa_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“Duk wanda ya bugi mahaifinsa ko mahaifiyarsa, dole a kashe shi. ");
INSERT INTO hausa_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“Duk wanda ya saci mutum ya sayar da shi, ko kuwa aka iske shi a hannunsa, lalle kashe shi za a yi. ");
INSERT INTO hausa_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“Duk wanda ya la’anta mahaifinsa ko mahaifiyarsa, dole a kashe shi. ");
INSERT INTO hausa_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“Idan mutane suka yi faɗa, ɗayan ya jefa ɗayan da dutse, ko ya naushe shi amma bai mutu ba, sai dai ya yi ta jiyya, ");
INSERT INTO hausa_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","idan mutumin ya sāke tashi ya yi tafiya ko da yana dogarawa da sanda ne, wanda ya buge shi zai kuɓuta, sai dai zai biya diyyar lokacin da ya ɓata masa, yă kuma lura da shi, har yă warke sarai. ");
INSERT INTO hausa_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“In mutum ya dūke bawansa ko baiwarsa da sanda, sai bawan ko baiwar ta mutu saboda dūkan, dole a hukunta shi, ");
INSERT INTO hausa_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","amma ba za a hukunta shi ba, in bawan ko baiwar ta tashi, bayan kwana ɗaya ko biyu, tun da bawan ko baiwar mallakarsa ne. ");
INSERT INTO hausa_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“Idan mutum biyu suna faɗa, har suka yi wa mace mai ciki rauni, har ya sa ta yi ɓari, amma wani lahani bai same ta ba, za a ci wa wanda ya yi mata raunin tara bisa ga yadda mijinta ya yanka za a biya, in dai abin da ya yanka ya yi daidai da abin da alƙalai suka tsara. ");
INSERT INTO hausa_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Amma in akwai rauni mai tsanani, sai a ɗauki rai a maimakon rai, ");
INSERT INTO hausa_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","ido don ido, haƙori don haƙori, hannu don hannu, ƙafa don ƙafa, ");
INSERT INTO hausa_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","ƙuna don ƙuna, rauni don rauni, ƙujewa don ƙujewa. ");
INSERT INTO hausa_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“In mutum ya bugi bawa ko baiwa a ido, har idon ya lalace, dole yă ’yantar da shi ko ita, maimakon ido. ");
INSERT INTO hausa_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","In kuma ya fangare haƙorin bawa ko baiwa, dole yă ’yantar da bawan ko baiwar, a maimakon haƙorin. ");
INSERT INTO hausa_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“In bijimi ya kashe namiji ko ta mace, dole a jajjefe bijimin har yă mutu, ba za a kuma ci namansa ba. Amma mai bijimin ba shi da laifi. ");
INSERT INTO hausa_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","In, har an san bijimin da wannan hali, an kuma yi wa mai shi gargaɗi, amma bai ɗaura shi ba, har ya kashe namiji ko ta mace, za a jajjefe bijimin tare da mai shi, har su mutu. ");
INSERT INTO hausa_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Amma fa, in an bukace shi yă biya, zai biya don yă fanshi ransa ta wurin biyan abin da aka aza masa. ");
INSERT INTO hausa_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Wannan doka ta shafi batun bijimin da ya kashe ɗa ko ’ya. ");
INSERT INTO hausa_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","In bijimin ya kashe bawa ko baiwa, mai shi zai biya shekel talatin na azurfa wa maigidan bawan, a kuma a jajjefe bijimin. ");
INSERT INTO hausa_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“In mutum ya bar rami a buɗe, ko ya haƙa rami bai kuma rufe ba, sai saniya ko jaki ya fāɗi a ciki, ");
INSERT INTO hausa_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","Mai ramin zai biya rashin da aka yi wa mai shi, matacciyar saniyan ko jakin, zai zama na mai ramin. ");
INSERT INTO hausa_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“In bijimin mutum ya raunana bijimin wani, har ya mutu, sai mutanen biyu su sayar da mai ran, su raba kuɗin daidai, haka ma su yi da mai ran. ");
INSERT INTO hausa_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Amma fa, in tun can, an san bijimin yana da wannan halin faɗa, duk da haka mai shi bai ɗaura shi ba, dole mai shi yă biya, dabba domin dabba, matacciyar dabbar kuwa tă zama nasa. ");
INSERT INTO hausa_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“In mutum ya saci saniya ko tunkiya ya yanka, ko ya sayar, zai biya shanu biyar, a maimakon saniyar da ya sata, ko kuma tumaki huɗu, maimakon tunkiyar da ya sata. ");
INSERT INTO hausa_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","“In aka iske ɓarawo yana cikin ƙoƙarin shiga yă yi sata, aka buge shi har ya mutu, to, ba za a nemi alhakin jininsa daga wurin kowa ba; ");
INSERT INTO hausa_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","amma in ya faru bayan wayewar gari, to, za a nemi alhakin jinin ɓarawon a hannun wanda ya bugi ɓarawon. “Ɓarawon da aka kama da abin da ya sata, dole yă yi cikakkiyar ramuwa, amma in ba shi da kome, dole a sayar da shi a biya abin da ya sata. ");
INSERT INTO hausa_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","In an sami dabbar, ko saniya, ko jaki, ko tunkiya da ya sata da rai a hannunsa, dole ɓarawon yă biya taran da za a ci shi, sau biyu na kowane ɗaya. ");
INSERT INTO hausa_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“In mutum ya sa dabbobinsa su yi kiwo a fili ko a gonar inabi, ya kuma bar dabbobinsa suka yi ɓarna a cikin gonar wani, sai a sa mai dabbar yă biya tara daga amfanin gonarsa mafi kyau duka. ");
INSERT INTO hausa_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“In gobara ta tashi, ta kuma bazu cikin ƙayayyuwa, har ta cinye tarin hatsi, ko hatsin da ke tsaye, ko dukan gonar, dole wanda ya sa wutar, yă biya taran da aka yanka masa saboda ɓarnan da wutar ta yi. ");
INSERT INTO hausa_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“In mutum ya ba maƙwabcinsa azurfa, ko kaya ajiya, aka kuma sace su daga gidan maƙwabcin, in an kama ɓarawon, sai ɓarawon yă biya abin da ya sata har sau biyu. ");
INSERT INTO hausa_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Amma in ba a sami ɓarawon ba, sai wanda aka yi ajiyar a gidansa, yă bayyana a gaban alƙalai a bincika ko yana da hannu a kan kayan maƙwabcinsa. ");
INSERT INTO hausa_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","A kowane rikicin cin amana da zai shiga tsakanin mutum biyu, ko a kan bijimi, ko jaki, ko tunkiya, ko riga, kai, ko a kan kowane irin abin da ya ɓata, da ma abin da aka samu a hannun wani, in akwai jayayya, za a kawo mutumin a gaban alƙalai. Wanda alƙali ya ce shi ne mai laifi, sai yă biya ɗayan taran da za a yanka, har sau biyu. ");
INSERT INTO hausa_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“In mutum ya ba da jaki, ko saniya, ko tunkiya, ko kowace dabba wa maƙwabcinsa ajiya, sai abin ya mutu, ko ya ji rauni, ko an ɗauke shi, in ba shaida, ");
INSERT INTO hausa_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","rantsuwa ce za tă raba tsakaninsu a gaban Ubangiji cewa babu hannunsa a dukiyar maƙwabcinsa. Mai dukiyar kuwa zai yarda da rantsuwar, ba za a bukaci wanda aka bai wa amanar yă biya ba. ");
INSERT INTO hausa_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Amma idan satan dabbar ce aka yi, dole wanda aka bai wa ajiyar yă biya mai dabbar taran da aka ci masa. ");
INSERT INTO hausa_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","In naman jeji ne ya kashe ta, zai nuna gawar don shaida, ba za a kuwa sa maƙwabcin yă biya abin da naman jeji ya kashe ba. ");
INSERT INTO hausa_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“In mutum ya yi aron dabba daga wurin maƙwabcinsa, sai dabbar ta ji rauni ko ta mutu, yayinda mai shi ba ya nan, dole wanda ya yi aron dabbar yă biya. ");
INSERT INTO hausa_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Amma idan mai dabbar yana a wurin, wanda ya karɓa aron, ba zai biya kome ba. In an yi hayar dabbar ce, to, kuɗin da aka biya na hayar zai zama a madadin rashin. ");
INSERT INTO hausa_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“Idan mutum ya ruɗe budurwa, wadda ba wanda yake nemanta, ya kuma kwanta da ita, dole yă biya kuɗin aurenta, za tă kuma zama matarsa. ");
INSERT INTO hausa_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","In mahaifinta ya ƙi yă ba da ita ga mutumin, dole mutumin yă biya dukiya daidai da abin da akan biya domin budurwai. ");
INSERT INTO hausa_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“Kada ku bar maiya da rai. ");
INSERT INTO hausa_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“Duk mutumin da ya yi jima’i da dabba dole a kashe shi. ");
INSERT INTO hausa_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“Duk wanda ya yi hadaya ga wani allah ban da Ubangiji, dole a hallaka shi. ");
INSERT INTO hausa_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“Kada a wulaƙanta, ko a zalunci baƙo, domin dā ku baƙi ne a ƙasar Masar. ");
INSERT INTO hausa_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“Kada ku ci zalin gwauruwa, ko maraya. ");
INSERT INTO hausa_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","In kuka yi haka, idan kuma suka yi kuka gare ni, zan ji kukansu. ");
INSERT INTO hausa_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Zan husata, in kuma kashe ku da takobi; matanku kuma, su ma su zama gwauraye, ’ya’yanku kuwa su zama marayu. ");
INSERT INTO hausa_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“In kun ba wa jama’ata matalauta da suke tsakaninku bashin kuɗi, kada ku zama kamar masu ba da rance; kada ku sa yă biya da ruwa. ");
INSERT INTO hausa_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","In kun ɗauki mayafi maƙwabcinku a matsayin jingina, ku mayar masa kafin fāɗuwar rana, ");
INSERT INTO hausa_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","domin mayafin ne abin da yake da shi na rufe jikinsa. To, da me zai rufu yă yi barci? Sa’ad da ya yi mini kuka, zan ji, gama ni mai tausayi ne. ");
INSERT INTO hausa_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“Kada ku yi maganar saɓo ga Allah, ko ku la’anta mai mulkin mutanenku. ");
INSERT INTO hausa_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“Kada ku jinkirta fitar da zakarku daga rumbunanku, ko harajin kayan da kuka saya. “Dole ku ba ni ’ya’yan farinku maza. ");
INSERT INTO hausa_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Ku yi haka da shanunku da tumakinku. Bari su kasance da iyayensu mata, har kwana bakwai, amma ku ba ni su a rana ta takwas. ");
INSERT INTO hausa_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“Za ku kasance mutanena masu tsarki. Saboda kada ku ci naman da namun jeji suka kashe; ku jefa wa karnuka. ");
INSERT INTO hausa_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“Kada ku baza rahoton ƙarya. Kada kuma ku haɗa baki da mugayen mutane har da ku zama munafukai ta wurin ba da shaidar ƙarya. ");
INSERT INTO hausa_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","“Kada ku yi abin da ba daidai ba, don galibin mutane suna yin haka. Sa’ad da kuke ba da shaida a gaban shari’a, kada ku ba da shaidar ƙarya a kauce wa gaskiya don ku faranta wa taron jama’a rai. ");
INSERT INTO hausa_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Kada ku yi wa matalauci sonkai a gaban shari’a. ");
INSERT INTO hausa_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“In ka ga saniyar abokin gābanka, ko jakinsa ya ɓace, ka yi ƙoƙari ka mai da shi wurinsa. ");
INSERT INTO hausa_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","In ka ga jakin wani maƙiyinka ya fāɗi a ƙarƙashin kayan da ya ɗauka, kada ka bar shi can, ka yi ƙoƙari ka taimake shi. ");
INSERT INTO hausa_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“Kada ku kāsa yin adalci ga matalauci a wurin shari’a. ");
INSERT INTO hausa_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Ku yi nesa da ƙage. Kada ku kashe marar laifi tare da mai adalci, gama ba zan bar mugun yă tafi haka kawai ba. ");
INSERT INTO hausa_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","“Kada ka karɓi cin hanci, gama cin hanci yakan makanta waɗanda suke gani, yakan kuma karkatar da maganar masu adalci. ");
INSERT INTO hausa_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“Kada ka zalunci baƙo, ku kanku kun san halin baƙunci, gama dā ku baƙi ne a Masar. ");
INSERT INTO hausa_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“Shekara shida za ku nome gonakinku ku girbe amfanin gonar, ");
INSERT INTO hausa_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","amma a shekara ta bakwai za ku bar ƙasa tă huta. Sa’an nan matalautan da suke cikinku za su sami abinci daga cikinta, namun jeji kuma za su ci abin da aka bari. Ku yi haka da gonakinku na inabi, da na itatuwan zaitun. ");
INSERT INTO hausa_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“Kwana shida za ku yi aikinku, amma a rana ta bakwai, kada ku yi aiki, saboda saniyarku da jakinku su huta, haka kuma bawan da aka haifa a gidanku, da kuma baƙon da yake a cikinku yă wartsake. ");
INSERT INTO hausa_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“Ku mai da hankali, ku yi biyayya da duk abin da na faɗa muku. Kada ku kira sunaye waɗansu alloli; kada a ji su a bakinku. ");
INSERT INTO hausa_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“Sau uku a shekara za ku yi mini biki. ");
INSERT INTO hausa_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","“Ku yi Bikin Burodi Marar Yisti, kwana bakwai za ku ci burodi marar yisti, kamar yadda na umarce ku. Ku yi wannan a lokacin da aka ayana a watan Abib, gama a watan ne kuka fito daga Masar. “Kada wani yă zo a gabana hannu wofi. ");
INSERT INTO hausa_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“Ku yi Bikin Girbi da nunan fari na amfanin shuke-shuken gonarku. “Ku yi Bikin Tattarawa a ƙarshen shekara, sa’ad da kuka tattara amfani daga gonarku. ");
INSERT INTO hausa_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","“Sau uku a shekara, maza duka za su bayyana a gaban Ubangiji Mai Iko Duka. ");
INSERT INTO hausa_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“Kada ku miƙa mini hadayar jini tare da wani abu mai yisti. “Ba za a bar kitsen bikin hadayata yă kwana ba. ");
INSERT INTO hausa_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“Dole ne ku kawo mafi kyau daga nunan fari na gonakinku a gidan Ubangiji Allahnku. “Kada ku dafa ɗan akuya a cikin madarar mahaifiyarsa. ");
INSERT INTO hausa_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“Ga shi, zan aika mala’ika a gabanku, yă tsare ku a tafiyarku, yă kuma kawo ku wurin da na shirya. ");
INSERT INTO hausa_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Ku saurare shi, ku kuma kasa kunne ga abin da yake faɗa. Kada ku yi masa tawaye; ba zai gafarta tawayenku ba, gama shi wakilina ne. ");
INSERT INTO hausa_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","In kun kasa kunne sosai ga abin da yake faɗi, kuka kuma yi abin da na faɗa, zan zama magabci ga abokan gābanku, zan kuma yi hamayya da abokan hamayyanku. ");
INSERT INTO hausa_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Mala’ikana zai sha gabanku, yă kawo ku cikin ƙasar Amoriyawa, da Hittiyawa, da Ferizziyawa, da Kan’aniyawa, da Hiwiyawa, da kuma Yebusiyawa, zan kuma kawar da su. ");
INSERT INTO hausa_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Kada ku durƙusa wa allolinsu, ko ku yi musu sujada, ko kuma ku bi al’adunsu. Za ku hallaka dukan allolinsu, ku kuma farfasa keɓaɓɓun duwatsunsu. ");
INSERT INTO hausa_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Ku bauta wa Ubangiji Allahnku, albarkansa kuwa za tă kasance a kan abincinku da ruwan shanku. Zan ɗauke cuta daga cikinku. ");
INSERT INTO hausa_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","A ƙasarku, mace ba za tă yi ɓari ba, ba kuma za a sami marar haihuwa ba. Zan ba ku tsawon rai. ");
INSERT INTO hausa_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“Zan aiki razanata a gabanku, in kuma sa ruɗami a cikin kowace al’ummar da za ku sadu da ita. Zan sa duk abokan gābanku su juye da baya, su gudu. ");
INSERT INTO hausa_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Zan aiki rina a gabanku, su kori Hiwiyawa, Kan’aniyawa da kuma Hittiyawa. ");
INSERT INTO hausa_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Amma ba a shekara guda zan kore muku su ba, don kada ƙasar tă zama kufai har namun jeji su fi ƙarfinku. ");
INSERT INTO hausa_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Da kaɗan da kaɗan zan kore muku su, har yawanku yă kai yadda za ku mallaki ƙasar. ");
INSERT INTO hausa_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","“Zan kafa iyakokinku daga Jan Teku zuwa Bahar Rum, daga hamada kuma zuwa Kogi. Zan ba da mazaunan ƙasar a hannunku, za ku kuwa kore su daga gabanku. ");
INSERT INTO hausa_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Kada ku ƙulla yarjejjeniya da su, ko da allolinsu. ");
INSERT INTO hausa_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Kada ku bari su zauna a cikin ƙasarku, in har kuka bar su, za su ɓata ku da zunubinsu na bautar allolinsu, har zai yă zama muku tarko.” ");
INSERT INTO hausa_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Ana nan sai Ubangiji ya ce wa Musa, “Ku hauro zuwa wurina, kai da Haruna, Nadab da Abihu, da kuma dattawa saba’in a cikin Isra’ila. Za ku yi sujada da ɗan nisa, ");
INSERT INTO hausa_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","sai Musa kaɗai zai kusaci Ubangiji. Amma sauran kada su zo kusa, kada kuma jama’a su hau tare da shi.” ");
INSERT INTO hausa_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Sa’ad da Musa ya tafi ya faɗa wa mutanen duk kalmomin Ubangiji da dokokinsa, sai suka amsa da murya ɗaya suna cewa, “Duk abin da Ubangiji ya faɗa, za mu yi.” ");
INSERT INTO hausa_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Sai Musa ya rubuta duk abin da Ubangiji ya faɗa. Ya tashi kashegari da sassafe ya gina bagade kusa da dutsen, ya aza al’amudai goma sha biyu bisa ga kabilu goma sha biyu na Isra’ila. ");
INSERT INTO hausa_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Sai ya aiki samarin Isra’ilawa, suka miƙa hadaya ta ƙonawa, suka kuma miƙa ƙananan bijimai don hadaya ta salama ga Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Musa ya ɗauki rabin jinin ya zuba a cikin kwanoni, rabin kuma ya yayyafa a kan bagaden. ");
INSERT INTO hausa_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Sa’an nan ya ɗauki Littafin Alkawari ya karanta wa mutane. Suka amsa suka ce, “Za mu yi duk abin da Ubangiji ya faɗa; za mu yi biyayya.” ");
INSERT INTO hausa_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Musa ya kuma ɗauki jinin, ya yayyafa a kan mutanen ya ce, “Wannan shi ne jinin alkawarin da Ubangiji ya yi da ku, bisa ga dukan waɗannan kalmomi.” ");
INSERT INTO hausa_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Musa da Haruna, Nadab da Abihu, da dattawa saba’in, Allah na Isra’ila suka haura ");
INSERT INTO hausa_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","suka kuma ga Allah na Isra’ila. A ƙarƙashin ƙafafunsa akwai wani abu wanda aka yi da saffaya, mai haske kuma kamar sararin sama kansa. ");
INSERT INTO hausa_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Amma Allah bai yi wa shugabannin Isra’ila wani abu ba; suka ga Allah, suka ci suka kuma sha. ");
INSERT INTO hausa_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Ubangiji ya ce wa Musa, “Hauro wurina a kan dutse, ka tsaya a nan, zan ba ka allunan dutsen, da doka da umarnan da na rubuta don koyonsu.” ");
INSERT INTO hausa_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Sa’an nan Musa ya fita tare da Yoshuwa mataimakinsa, ya kuwa hau kan dutsen Allah. ");
INSERT INTO hausa_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Ya ce wa dattawan, “Ku jira mu a nan, sai mun dawo wurinku. Haruna da Hur suna tare da ku, in wani yana da wata damuwa, sai yă je wurinsu.” ");
INSERT INTO hausa_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Da Musa ya hau dutsen, sai girgije ya rufe dutsen, ");
INSERT INTO hausa_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","sai ɗaukakar Ubangiji ta sauka a kan Dutsen Sinai, kwana shida girgije ya rufe dutsen, a rana ta bakwai, sai Ubangiji ya kira Musa daga cikin girgijen. ");
INSERT INTO hausa_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Ga Isra’ilawa dai, ɗaukakar Ubangiji ta yi kamar wuta mai ci a kan dutse. ");
INSERT INTO hausa_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Sa’an nan Musa ya shiga girgijen ya hau kan dutsen. Ya zauna a kan dutsen yini arba’in da dare arba’in. ");
INSERT INTO hausa_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Ka faɗa wa Isra’ilawa su kawo mini hadaya. Za ka karɓi hadaya daga hannun kowane mutum wanda zuciyarsa ta yarda yă bayar. ");
INSERT INTO hausa_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","“Ga iri jerin kayan da za ka karɓo daga hannunsu, “zinariya, da azurfa, tagulla, ");
INSERT INTO hausa_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","shuɗi, shunayya da jan zare, lallausan lilin, da gashin akuya, ");
INSERT INTO hausa_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","fatun ragunan da aka wanke, fatun awaki masu kyau, itacen akashiya, ");
INSERT INTO hausa_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","mai domin fitila, kayan yaji domin man keɓewa da kuma turare mai ƙanshi, ");
INSERT INTO hausa_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","da duwatsun Onis, da duwatsun da za a mammanne a efod da ƙyallen maƙalawa a ƙirji. ");
INSERT INTO hausa_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","“Sa’an nan ka sa su yi mini wuri mai tsarki, domin in zauna a cikinsu. ");
INSERT INTO hausa_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Ka ƙera wannan tabanakul da duk kayan da suke ciki da waje, daidai yadda zan nuna maka. ");
INSERT INTO hausa_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“Ka sa a yi akwatin alkawarin da itacen ƙirya, tsawonsa kamu biyu da rabi, fāɗinsa kamu ɗaya da rabi, tsayinsa kuma kamu ɗaya da rabi. ");
INSERT INTO hausa_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Ka dalaye shi da zinariya zalla ciki da waje, za ka yi wa gefe-gefensa ado da gurun zinariya. ");
INSERT INTO hausa_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Ka kewaye akwatin da zoban zinariya huɗu ka kuma haɗa su da ƙafafunsa huɗu, zobai biyu a kowane gefe. ");
INSERT INTO hausa_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Sa’an nan ka yi sanduna da itacen ƙirya, ka dalaye su da zinariya. ");
INSERT INTO hausa_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Ka sa sandunan a cikin zoban, a gefen akwatin domin ɗaukansa. ");
INSERT INTO hausa_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Sanduna za su kasance a cikin waɗannan zoban akwatin alkawarin; ba za a cire su ba. ");
INSERT INTO hausa_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Sa’an nan ka sa Shaidar da zan ba ka, a cikin akwatin. ");
INSERT INTO hausa_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“Ka yi murfin kafara da zinariya zalla, tsawonsa kamu biyu da rabi, fāɗinsa kuma kamu ɗaya da rabi. ");
INSERT INTO hausa_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Ka kuma yi kerubobi biyu da zinariyar da aka ƙera, ka sa a gefen nan biyu na murfin. ");
INSERT INTO hausa_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Ka yi kerubobi biyu, ɗaya a wannan gefe, ɗaya kuma a ɗayan gefen; za ka manne su a kan murfin, su zama abu ɗaya. ");
INSERT INTO hausa_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Kerubobin su kasance da fikafikansu a buɗe, domin su inuwantar da murfin, za su fuskanci juna, suna duba murfin. ");
INSERT INTO hausa_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Ka sa murfin a bisa akwatin ka kuma sa allunan dokokin alkawarin da zan ba ka a ciki. ");
INSERT INTO hausa_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Can, a bisa murfin da yake tsakanin kerubobi biyu da suke bisa akwatin alkawari na Shaida, zan sadu da kai, in kuma ba ka dukan umarnai domin Isra’ilawa. ");
INSERT INTO hausa_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“Ka yi tebur da itacen ƙirya, tsawonsa kamu biyu, fāɗinsa kamu ɗaya, tsayinsa kuma kamu ɗaya da rabi. ");
INSERT INTO hausa_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Ka dalaye shi da zinariya zalla ka kuma yi masa ado kewaye da gurun zinariya. ");
INSERT INTO hausa_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Ka yi dajiya mai fāɗin tafin hannu, ka kuma yi wa dajiyar ado da gurun zinariya. ");
INSERT INTO hausa_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Ka yi zoban zinariya huɗu domin teburin, ka daure su a kusurwoyi huɗu, inda ƙafafu huɗun suke. ");
INSERT INTO hausa_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Zoban za su kasance kusa da dajiyar don riƙe sandunan da za a yi amfani don ɗaukar teburin. ");
INSERT INTO hausa_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Ka yi sandunan da itacen ƙirya, ka dalaye su da zinariya, da sandunan ne za ku riƙa ɗaukan teburin. ");
INSERT INTO hausa_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Da zinariya zalla kuma za ka yi farantansa, da kwanoninsa na tuya, da butocinsa, da kwanoninsa domin zuban hadayu. ");
INSERT INTO hausa_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Ka sa burodin Kasancewa a kan wannan tebur, yă kasance a gabana kullum. ");
INSERT INTO hausa_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“Ka yi wurin ajiye fitilar da zinariya zalla, ka kuma yi gindinsa tare da gorar jikinsa da ƙerarriyar zinariya; kwafunansa da suka yi kamar furanni, tohonsa da furanninsa su yi yadda za su zama ɗaya da shi. ");
INSERT INTO hausa_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Wurin ajiye fitilar yă kasance da rassa shida, rassan nan za su miƙe daga kowane gefe na wurin ajiye fitilan, uku a gefe guda, uku kuma a ɗaya gefen. ");
INSERT INTO hausa_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Kwafuna uku masu siffar furanni almon, da toho, da kuma furannin za su kasance a rashe guda, uku a kan rashe na biye, haka kuma a kan saura rassan shida da suka miƙe daga wurin ajiye fitilan. ");
INSERT INTO hausa_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","A bisa wurin ajiye fitilan kuwa za a kasance da kwafuna huɗu masu siffar furannin almon, da toho, da furanni. ");
INSERT INTO hausa_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Toho ɗaya zai kasance a ƙarƙashin rassa biyu na farkon da suka miƙe daga wurin ajiye fitilan, toho na biyu a ƙarƙashin rassa biyu na biye, toho na uku a ƙarƙashin rassa na uku, rassa shida ke nan duka. ");
INSERT INTO hausa_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Tohon da kuma rassan za su kasance ɗaya da wurin ajiye fitilan da aka yi da ƙerarriyar zinariya. ");
INSERT INTO hausa_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","“Sa’an nan ka yi fitilu bakwai, ka sa su a bisa wurin ajiye fitilan ta yadda za su haskaka wajen da suka fuskanta. ");
INSERT INTO hausa_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Za a yi lagwaninsa da manyan farantansa da ƙerarriyar zinariya. ");
INSERT INTO hausa_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Da zinariya zalla na talenti ɗaya za ka yi wurin ajiye fitilan da waɗannan abubuwa duka. ");
INSERT INTO hausa_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Sai ka lura ka yi su daidai bisa ga fasalin da aka nuna maka a kan dutse. ");
INSERT INTO hausa_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“Ka yi tabanakul da labule goma na lilin mai laushi a naɗe shi biyu, a saƙa labulen da ulu mai ruwan shuɗi, da ulu mai ruwan shunayya, da kuma ulu mai ruwan ja. Waɗannan labule za a yi musu zānen siffofin kerubobi, aikin gwani. ");
INSERT INTO hausa_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Dukan labulen, girmansu zai zama kamu ashirin da takwas, fāɗinsu kuwa kamu huɗu. Labulen su zama daidai wa daida. ");
INSERT INTO hausa_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Ka haɗa labule biyar tare, ka yi haka kuma da suran biyar ɗin. ");
INSERT INTO hausa_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Ka sa wa labulen rammuka da ulu mai ruwan shuɗin a gefen ƙarshe na labule ɗaya, a kuma yi haka a ƙarshen gefe na ɗaya kuma. ");
INSERT INTO hausa_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Ka yi wa labulen rammuka hamsin a ɗayan labule, ka kuma yi haka a ƙarshe ɗayan labulen, rammukan su fuskanci juna. ");
INSERT INTO hausa_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Sa’an nan ka yi maɗauri hamsin na zinariya don amfanin ɗaura labulen a haɗe, domin tabanakul yă zama ɗaya. ");
INSERT INTO hausa_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“Ka yi labule goma sha ɗaya na gashin akuya da za ka rufe tabanakul. ");
INSERT INTO hausa_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Tsawon kowanne yă zama kamu talatin, fāɗinsa kuma yă zama kamu huɗu. Labulen za su zama daidai wa daida. ");
INSERT INTO hausa_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Ka haɗa labule biyar ka ɗinka. Haka kuma za ka yi da sauran shidan. Ka naɗe shida ɗin biyu, ka yi labulen ƙofar tentin da shi. ");
INSERT INTO hausa_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Ka yi rammuka hamsin a ƙarshen gefen kashi ɗaya na labulen, haka kuma a ƙarshen kashi ɗayan. ");
INSERT INTO hausa_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Sai ka kuma yi maɗauri hamsin da tagulla, ka ɗaura su a haɗe da tentin su zama ɗaya. ");
INSERT INTO hausa_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Ragowar rabin labulen da yake a bisa tenti kuma sai a bar shi yana lilo a bayan tabanakul. ");
INSERT INTO hausa_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Tsawon labulen tenti zai zama kamu ɗaya a kowane gefe, abin da ya rage kuma sai a bar shi ya yi ta lilo a kowane gefe don yă rufe tabanakul. ");
INSERT INTO hausa_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Ka yi abin rufe tentin da fatun raguna da aka rina ja, a kansa kuma ka rufe shi da fatun shanun teku. ");
INSERT INTO hausa_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“Ka yi tabanakul da katakon itacen ƙiryar da aka kakkafa a tsaye. ");
INSERT INTO hausa_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Tsawon kowane katako zai zama kamu goma, fāɗinsa kuma kamu ɗaya da rabi, ");
INSERT INTO hausa_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","ka kafa katakan suna duban juna. Ka yi da dukan katakan tabanakul haka. ");
INSERT INTO hausa_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Ka shirya katakai ashirin a gefen kudu na tabanakul, ");
INSERT INTO hausa_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","ka kuma yi rammuka arba’in da azurfar da za a sa wa katakan nan ashirin. Za a sa kawunan katakan da aka fiƙe a cikin rammukan. ");
INSERT INTO hausa_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Game da ɗayan gefen, gefen arewa na tabanakul, za ka kafa katakai ashirin, ");
INSERT INTO hausa_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","da rammukan azurfa arba’in, biyu a ƙarƙashin kowane katako. ");
INSERT INTO hausa_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Ka kafa katakai shida don can ƙarshen katakan, wato, a wajen yamma na ƙarshen tabanakul, ");
INSERT INTO hausa_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","ka kuma kafa katakai biyu a kusurwoyi can ƙarshe. ");
INSERT INTO hausa_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Za a haɗa katakan nan a kusurwa daga ƙasa zuwa sama a daure su. Haka za a yi da katakan kusurwa na biyu. ");
INSERT INTO hausa_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Ta haka za a sami katakai takwas da rammukansu na azurfa guda goma sha shida, kowane katako yana da rammuka biyu. ");
INSERT INTO hausa_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“Ka kuma yi sanduna da itacen ƙirya. Sanduna biyar domin katakai na gefe ɗaya na tabanakul, ");
INSERT INTO hausa_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","biyar domin katakai wancan gefe, biyar kuma domin na gefe wajen yamma, can ƙarshen tabanakul. ");
INSERT INTO hausa_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Sandan da yake tsakiyar katakan, zai bi daga wannan gefe zuwa ƙarshen wancan gefe. ");
INSERT INTO hausa_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Ka dalaye dukan katakan da zinariya, ka kuma yi zoban zinariya don su riƙe sandunan. Ka kuma dalaye sandunan da zinariya. ");
INSERT INTO hausa_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","“Ka yi tabanakul bisa ga fasalin da aka nuna maka a bisa dutsen. ");
INSERT INTO hausa_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“Ka yi labule mai ruwan shuɗi, shunayya da jan zare da kuma lallausan lilin da aka tuƙa, da zānen kerubobin da mai fasaha ya yi. ");
INSERT INTO hausa_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Ka rataye shi a bisa dogayen sanduna huɗun nan na itacen ƙirya, waɗanda aka dalaye da zinariya, waɗanda suke tsaya a rammuka huɗu na azurfa. ");
INSERT INTO hausa_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Ka rataye labule daga maɗauri, ka sa akwatin alkawari a bayan labulen. Labulen zai raba Wurin Mai Tsarki da Wurin Mafi Tsarki. ");
INSERT INTO hausa_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Ka sa murfin kafara a bisa akwatin alkawari a Wuri Mafi Tsarki. ");
INSERT INTO hausa_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Ka sa tebur a gaba labulen, a gefen arewa na tabanakul, ka kuma sa wurin ajiye fitilan ɗaura da shi, a wajen kudu. ");
INSERT INTO hausa_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“Game da ƙofar shigar tenti kuwa, ka yi labule mai ruwan shuɗi, shunayya da jan zare na lallausan lilin da aka tuƙa, aikin gwani. ");
INSERT INTO hausa_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Ka yi ƙugiyoyin zinariya domin wannan labule da katakai itacen ƙirya biyar, waɗanda aka dalaye da zinariya. Ka kuma yi zubi na tagulla biyar dominsu. ");
INSERT INTO hausa_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“Ka gina bagade da itacen ƙirya, mai tsawo kamu uku, zai zama murabba’i, mai tsawo kamu biyar, fāɗi kuma kamu biyar. ");
INSERT INTO hausa_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Ka yi masa ƙaho a kowace kusurwan nan huɗu, domin bagade da ƙahoni duk su zama ɗaya, ka dalaye bagade da tagulla. ");
INSERT INTO hausa_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Ka yi duk kayan aikinsa da tagulla, tukwanensa na ɗiban toka, da manyan cokula, da kwanonin yayyafawa, da cokula masu yatsotsi don nama da kuma farantai domin wuta. ");
INSERT INTO hausa_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Ka yi raga na tagulla dominsa, ka kuma yi zoben tagulla a kowace kusurwan nan huɗu na bagaden. ");
INSERT INTO hausa_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Ka sa ragar a ƙarƙashin bagade domin tă kai tsakiyar bagade. ");
INSERT INTO hausa_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Ka yi wa bagaden sanduna da itacen ƙirya, ka dalaye su da tagulla. ");
INSERT INTO hausa_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Za a zura sandunan a cikin zoban saboda su kasance a gefe biyu na bagade a lokacin da ake ɗaukarsa. ");
INSERT INTO hausa_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Ka yi bagaden da katakai, sa’an nan ka robe cikinsa. Ka yi shi bisa ga fasalin da aka nuna maka a bisa dutsen. ");
INSERT INTO hausa_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“Ka yi fili domin tabanakul. Tsawon gefen kudu zai zama kamu ɗari da labulen da aka yi da zaren lili mai kyau, ");
INSERT INTO hausa_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","da katakai ashirin da rammukan tagulla ashirin da ƙugiyoyin azurfa da kuma rammuka a kan katakai. ");
INSERT INTO hausa_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","A wajen arewa shi ma, tsawon yă zama ƙafa ɗari. Ka kama labulen da ƙugiyoyin da aka yi da azurfa waɗanda aka manna a kan ƙarfen da aka dalaye da azurfa. ");
INSERT INTO hausa_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","“Faɗin ƙarshen filin a yamma zai zama kamu hamsin. A kuma sa labule tare da rammuka goma da kuma katakai goma. ");
INSERT INTO hausa_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","A wajen gabas can ƙarshe, wajen fitowar rana, fāɗin filin zai zama kamu hamsin. ");
INSERT INTO hausa_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Tsayin labulen ƙofa na gefe ɗaya zai zama kamu goma sha biyar, da katakai uku tare da rammukansu uku, ");
INSERT INTO hausa_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","haka kuma tsayin labule na wancan gefen, zai zama kamu goma sha biyar, da katakai uku tare da rammukansu uku. ");
INSERT INTO hausa_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","“Domin ƙofar tentin, a saƙa labule mai tsayin kamu ashirin da lallausan zaren lilin mai ruwan shuɗi, da shunayya, da jan zare, mai aikin gwani, da katakai huɗu tare da rammukansu huɗu. ");
INSERT INTO hausa_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Duk katakan da suke kewaye da filin, za a yi musu maɗaurai na azurfa da kuma ƙugiyoyi, da rammukan tagulla. ");
INSERT INTO hausa_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Tsayin filin zai zama kamu ɗari, fāɗinsa kuma kamu hamsin, tsayin labulensa na lallausan zaren lilin zai zama kamu biyar, a kuma yi rammukansa da tagulla. ");
INSERT INTO hausa_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Dukan sauran kayan da aka yi amfani da su a aikin wannan tabanakul, ko da wanda irin aiki ne za a yi da su, har da dukan dogayen turakunsa da na filin, za a yi su da tagulla ne. ");
INSERT INTO hausa_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“Ka umarci Isra’ilawa su kawo tsabtataccen mai, tatacce daga zaitun domin fitilu, saboda fitilun su yi ta ci a koyaushe. ");
INSERT INTO hausa_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","A cikin Tentin Sujada, a waje da labulen da yake a gaban Akwatin Alkawari, Haruna da ’ya’yansa za su sa fitilu su yi ta ci a gaban Ubangiji, daga yamma har safiya. Wannan za tă zama dawwammamiyar farilla a cikin Isra’ila har tsararraki masu zuwa. ");
INSERT INTO hausa_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“Ka sa a kawo maka Haruna ɗan’uwanka, tare da ’ya’yansa Nadab da Abihu, Eleyazar da Itamar daga cikin Isra’ilawa, domin su yi mini hidima a matsayin firistoci. ");
INSERT INTO hausa_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Ka yi tufafi masu tsarki domin ɗan’uwanka Haruna, domin a girmama, a kuma ɗaukaka shi. ");
INSERT INTO hausa_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Ka faɗa wa dukan gwanayen da na ba su hikima a irin abubuwan nan, cewa su yi tufafi saboda Haruna, don a tsarkakewarsa, domin yă yi mini hidima a matsayin firist. ");
INSERT INTO hausa_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Waɗannan su ne tufafin da za su ɗinka, ƙyallen maƙalawa a ƙirji, da efod, da taguwa, da doguwar riga, da rawani, da abin ɗamara. Za su yi wa ɗan’uwanka, Haruna da ’ya’yansa, waɗannan tsarkaka tufafi, don su zama firistoci masu yi mini hidima. ");
INSERT INTO hausa_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Ka sa su yi amfani da zinariya, da zare mai ruwan shuɗi da shunayya da ja, da kuma lallausan lilin. ");
INSERT INTO hausa_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“Ka yi efod da zinariya, da shuɗi, da shunayya, da jan zare, da kuma lallausan lilin, aikin gwani mai sana’a. ");
INSERT INTO hausa_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Za a yi fele biyu, gaba da baya, sa’an nan a haɗa, a ɗinka a mahaɗinsu a kafaɗa. ");
INSERT INTO hausa_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Za a yi mata abin ɗamara da irin kayan da aka yi efod da shi, wato, da zinariya, da shuɗi, da shunayya, da mulufi, da lallausan zaren lilin. ");
INSERT INTO hausa_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","“Ka ɗauki duwatsu biyu masu daraja, ka rubuta sunayen ’ya’yan Isra’ila a kai ");
INSERT INTO hausa_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","bisa ga haihuwarsu, sunaye shida a kan dutse ɗaya, saura shida kuma a kan ɗaya dutsen. ");
INSERT INTO hausa_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","A rubuta sunayen ’ya’yan Isra’ila a kan duwatsu biyun, yadda mai yin aiki da dutse mai daraja yakan zāna hatimi. Sa’an nan a sa kowane dutse a cikin tsaiko na zinariya ");
INSERT INTO hausa_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","a ɗaura su a kan ƙyallen kafaɗa efod a matsayin duwatsun tuni ga ’ya’yan Isra’ila. Haruna ne zai ɗauki sunayen a kafaɗarsa don tuni a gaban Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Ka yi tsaiko na zinariya ");
INSERT INTO hausa_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","da tuƙaƙƙun sarƙoƙi biyu kamar igiya, na zinariya zalla, ka kuma ɗaura wa tsaikunan nan biyu tuƙaƙƙun sarƙoƙi. ");
INSERT INTO hausa_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“Ka shirya ƙyallen da za a manna a ƙirji don neman nufin Allah. Sai a saƙa shi da gwaninta kamar yadda aka saƙa efod ɗin. A saƙa shi da zinariya, da shuɗi, da shunayya, da mulufi, da lallausan zaren lilin. ");
INSERT INTO hausa_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Zai zama murabba’i, tsawonsa kamu ɗaya, fāɗinsa kuma kamu ɗaya, a naɗe shi biyu. ");
INSERT INTO hausa_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Sa’an nan ka yi jeri huɗu na duwatsu masu daraja a kansa. A jeri na fari, a sa yakutu, da tofaz, da zumurrudu. ");
INSERT INTO hausa_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","A jeri na biyu, a sa turkuwoyis, da saffaya, da emeral. ");
INSERT INTO hausa_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","A jeri na uku, a sa yakin, da idon mage da ametis. ");
INSERT INTO hausa_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","A jeri na huɗu, a sa kirisolit, da onis, da yasfa. Ka sa su a tsaiko na zinariya. ");
INSERT INTO hausa_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","A bisa duwatsun nan goma sha biyu, sai a zāna sunayen ’ya’yan Isra’ila bisa ga kabilansu goma sha biyu. Za a zāna sunayen kamar hatimi. ");
INSERT INTO hausa_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“Ka yi wa ƙyallen maƙalawa a ƙirjin tuƙaƙƙun sarƙoƙin zinariya zalla. ");
INSERT INTO hausa_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Ka yi zobe biyu na zinariya saboda ƙyallen maƙalawa a ƙirjin, ka kuma ɗaura su a kusurwoyin ƙyallen maƙalawa a ƙirji. ");
INSERT INTO hausa_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Ka ɗaura sarƙoƙin zinariyan nan biyu a zoban a kusurwan ƙyallen maƙalawa a ƙirji. ");
INSERT INTO hausa_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Ka kuma sa sauran bakunan sarƙoƙin nan biyu a kan tsaikon nan biyu, kana haɗa su da ƙyallen kafaɗa na efod a gaba. ");
INSERT INTO hausa_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Ka yi zobai biyu na zinariya ka ɗaura su ga sauran kusurwoyi ƙyallen maƙalawa a ƙirji, a gefen ciki kusa da efod. ");
INSERT INTO hausa_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Ka ƙara zobai biyu, ka kuma ɗaura su a bakin ƙyallen da ya sauka daga kafaɗa ta gaban efod, kusa da mahaɗin ƙyallaye biyu a bisa ɗamara na efod. ");
INSERT INTO hausa_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Za a ɗaura zoban ƙyallen maƙalawa a ƙirji a zoban efod da shuɗiyar igiya, domin ƙyallen maƙalawa a ƙirji yă zauna a bisa abin ɗamarar efod, don kada yă kunce. ");
INSERT INTO hausa_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“Duk sa’ad da Haruna zai shiga Wuri Mai Tsarki, zai shiga riƙe da sunayen ’ya’yan Isra’ila a zuciyarsa a kan ƙyallen maƙalawa a ƙirji na neman nufin Allah, domin yă zama abin tunawa a gaban Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Ka kuma sa Urim da Tummim a ƙyallen maƙalawa a ƙirji, don su kasance a zuciyar Haruna, a duk sa’ad da zai shiga gaban Ubangiji. Haka kuwa kullum Haruna zai riƙa kai koke-koken Isra’ilawa a gaban Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“Ka yi taguwar efod da shuɗi duka, ");
INSERT INTO hausa_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","ka yanke wuya a tsakiyarta don sawa. A kuma naɗe wuyan rigar yă yi kauri domin kada yă yage. ");
INSERT INTO hausa_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Za a yi wa bakin rigar ado da fasalin ’ya’yan rumman masu launin shuɗi, da shunayya, da mulufi. A sa ƙararrawa ta zinariya a tsakankaninsu. ");
INSERT INTO hausa_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Za ka jera su bi da bi, wato, ’ya’yan rumman na biye da ƙararrawar zinariya kewaye da bakin rigar. ");
INSERT INTO hausa_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Dole Haruna yă sa shi sa’ad da yake hidima. Za a ji ƙarar ƙararrawar sa’ad da zai shiga Wuri Mai Tsarki a gaban Ubangiji, da sa’ad da ya fita, don kada yă mutu. ");
INSERT INTO hausa_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“Ka yi allo na zinariya zalla, ka kuma yi rubutu a kansa kamar na hatimi, haka, Mai tsarki ga Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Ka ɗaura shi da igiyar ruwa bula domin a haɗa shi da rawani; zai kasance a gaban rawanin. ");
INSERT INTO hausa_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Zai kasance a goshin Haruna, ta haka zai ɗauki kurakuran da ya yiwu Isra’ilawa sun yi cikin miƙa baye-bayensu masu tsarki. Zai kasance a goshin Haruna kullayaumin, domin su zama abin karɓa ga Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“Ka saƙa doguwar riga da lallausan lilin ka kuma yi hula da lallausan zaren lilin, ka kuma saƙa abin ɗamara mai ado. ");
INSERT INTO hausa_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","“Ka saƙa doguwar riga, abin ɗamara da kuma huluna domin ’ya’yan Haruna, don yă ba su girma da ɗaukaka. ");
INSERT INTO hausa_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Bayan ka sa waɗannan riguna wa ɗan’uwanka Haruna da ’ya’yansa, ka shafe su da mai, ka kuma naɗa su. Ka keɓe su domin su yi mini hidima a matsayin firistoci. ");
INSERT INTO hausa_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","“Ka yi ’yan wandunan ciki na lilin don su rufe tsiraicinsu, tsayinsu zai kama daga kwankwaso zuwa cinya. ");
INSERT INTO hausa_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Dole Haruna da ’ya’yansa su sa su sa’ad da za su shiga Tentin Sujada, ko sa’ad da suka kusace bagade domin hidima a Wuri Mai Tsarki, don kada su yi laifi, su kuma mutu. “Wannan za tă zama dawwammamiyar farilla wa Haruna da zuriyarsa har abada. ");
INSERT INTO hausa_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“Ga abin da za ka yi don ka keɓe su, don su yi mini hidima a matsayin firistoci. Ka ɗauki ɗan bijimi da raguna biyu marasa lahani. ");
INSERT INTO hausa_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Daga garin alkama mai laushi marar yisti kuwa, ka yi burodi, da wainan da aka kwaɓa da mai, da ƙosai waɗanda an barbaɗa mai a kai. ");
INSERT INTO hausa_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Ka sa waɗannan a cikin kwando. Sa’an nan ka miƙa su tare da ɗan bijimin da ragunan nan biyu. ");
INSERT INTO hausa_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Bayan haka sai ka kawo Haruna da ’ya’yansa a ƙofar Tentin Sujada ka yi musu wanka. ");
INSERT INTO hausa_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Ka ɗauki rigar ka sa wa Haruna, ka sa masa doguwar rigar, da rigar efod, da efod kanta, da ƙyallen maƙalawa a ƙirji. Ka ɗaura masa efod da ɗamarar da aka yi mata ado. ");
INSERT INTO hausa_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Ka naɗa masa rawani a kai, ka kuma sa kambi mai tsarki a bisa rawanin. ");
INSERT INTO hausa_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Ka ɗauki man shafewa ka shafe shi, ta wurin zuba man a kansa. ");
INSERT INTO hausa_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Ka kawo ’ya’yansa, ka sa musu taguwoyi, ");
INSERT INTO hausa_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","ka kuma sa musu huluna a kansu. Sa’an nan ka ɗaura wa Haruna da ’ya’yansa abin ɗamara. Su kuwa da zuriyarsu, aikin firist kuwa zai zama nasu ta wurin dawwammamiyar farilla. “Ta haka za ka keɓe Haruna da ’ya’yansa maza. ");
INSERT INTO hausa_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“Ka kuma kawo bijimin a gaban Tentin Sujada, sai Haruna da ’ya’yansa su ɗora hannuwansu a kansa. ");
INSERT INTO hausa_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Ka yanka shi a gaban Ubangiji a ƙofar Tentin Sujada. ");
INSERT INTO hausa_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Ka ɗibi jinin bijimin ka zuba a kan ƙahoni na bagade da yatsanka, sauran jinin kuwa ka zuba a gindin bagaden. ");
INSERT INTO hausa_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Sa’an nan ka ɗauki dukan kitsen da ya rufe kayan ciki, da kitsen da yake manne da hanta, da ƙoda biyu da kuma kintsen da yake a kansu, ka ƙone su a kan bagade. ");
INSERT INTO hausa_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Amma ka ƙone naman bijimin, da fatarsa, da kayan cikin, a bayan sansani. Hadaya ce ta zunubi. ");
INSERT INTO hausa_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“Ka ɗauki ɗaya daga cikin ragunan, Haruna kuwa da ’ya’yan maza za su ɗora hannuwansa a kansa. ");
INSERT INTO hausa_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Ka yanka ragon, ka ɗibi jinin, ka yayyafa shi kewaye da gefen bagaden. ");
INSERT INTO hausa_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Ka yayyanka rago gunduwa-gunduwa, ka wanke kayan cikin, da ƙafafun, da kan, ka haɗa su da gunduwoyin. ");
INSERT INTO hausa_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Sa’an nan ka ƙone ragon ɗungum a kan bagade. Hadaya ta ƙonawa ce ga Ubangiji, mai daɗin ƙanshi, wato, hadaya ce da aka ƙone da wuta ga Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“Ka ɗauki ɗayan ragon, sai Haruna da ’ya’yansa maza su ɗora hannuwansu a kansa. ");
INSERT INTO hausa_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Ka yanka ragon, ka ɗibi jinin, ka shafa a bisa leɓen kunnen Haruna na dama, da bisa leɓen kunnuwan ’ya’yansa maza na dama, da kan manyan yatsotsin hannuwansu na dama, da kuma a kan manyan yatsotsin ƙafafunsu na dama. Sauran jinin kuwa, sai ka yayyafa shi kewaye da gefen bagaden. ");
INSERT INTO hausa_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Ka ɗibi jinin da yake a kan bagade, da man shafewa, ka yafa a kan Haruna da rigunansa, da kuma a kan ’ya’yansa maza da rigunansu. Sa’an nan shi da ’ya’yansa maza da rigunansu za su tsarkake. ");
INSERT INTO hausa_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“Ka ɗebi kitse daga wannan rago, ka yanke wutsiyarsa mai kitse, ka kuma ɗebi kitsen da ya rufe kayan ciki, da kitsen da yake bisa hanta, da ƙoda biyu da kitsen da yake kansu, da cinyar dama. (Gama rago ne don naɗi.) ");
INSERT INTO hausa_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Daga kwandon burodi marar yisti, wanda yake gaban Ubangiji, ka ɗauki dunƙule ɗaya, da waina da aka yi da mai, da kuma ƙosai. ");
INSERT INTO hausa_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Ka sa dukan waɗannan a hannun Haruna da ’ya’yansa maza, su kaɗa su a gaban Ubangiji a matsayin hadaya ta kaɗawa. ");
INSERT INTO hausa_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Sa’an nan ka karɓe su daga hannuwansu, ka ƙone su a kan bagade tare da hadaya ta ƙonawa, domin ƙanshi mai daɗi ga Ubangiji, wato, hadaya ce da aka ƙone da wuta ga Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Bayan haka, ka ɗauki ƙirjin ragon domin naɗin Haruna, ka kaɗa shi a gaban Ubangiji kamar hadaya ta kaɗawa. Wannan ƙirji zai zama rabonka. ");
INSERT INTO hausa_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","“Ka tsarkake ƙirji na hadaya ta kaɗawa, da cinya ta hadaya ta ɗagawa, waɗanda za a kaɗa a kuma ɗaga na ragon naɗin, wanda yake na Haruna da kuma na ’ya’yansa maza. ");
INSERT INTO hausa_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Wannan zai zama rabon Haruna da ’ya’yansa maza daga Isra’ilawa. Gama wannan hadaya ta ɗagawa ce daga cikin hadayu na salama da Isra’ilawa za su miƙa wa Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“Keɓaɓɓun tufafin nan na Haruna za su zama na zuriyarsa bayan mutuwarsa. Da tufafin nan ne za a zuba musu mai, a keɓe su. ");
INSERT INTO hausa_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Ɗan da ya gāje shi a matsayin firist, shi ne zai sa su har kwana bakwai, lokacin da ya shiga Tentin Sujada, don yă yi aiki a Wuri Mai Tsarki. ");
INSERT INTO hausa_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“Ka ɗauki ragon naɗi, ka dafa naman a tsattsarkan wuri. ");
INSERT INTO hausa_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","A ƙofar Tentin Sujada, Haruna da ’ya’yansa maza za su ci wannan rago da burodin da yake cikin kwandon. ");
INSERT INTO hausa_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Za su ci abubuwan nan da aka yi kafara da su a lokacin tsarkakewarsu da keɓewarsu. Ba wanda zai ci, sai su kaɗai, gama abubuwan nan tsarkaka ne. ");
INSERT INTO hausa_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","In naman ragon naɗi ko wani burodin ya ragu har safiya, a ƙone shi, kada a ci gama tsarkake ne. ");
INSERT INTO hausa_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“Ka yi wa Haruna da ’ya’yansa maza duk abin da na umarce ka, ka ɗauki kwana bakwai don naɗinsu. ");
INSERT INTO hausa_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Ka miƙa bijimi ɗaya kowace rana domin hadaya don zunubi ta yin kafara. Ka tsarkake bagade ta wuri yin kafara dominsa, ka shafe shi da mai don ka tsarkake shi. ");
INSERT INTO hausa_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Kwana bakwai za ka yi kafara saboda bagaden, ka kuma tsarkake shi. Sa’an nan bagaden zai zama mafi tsarki, kuma duk abin da ya taɓa bagaden zai tsarkaka. ");
INSERT INTO hausa_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“Ga abin da za ka miƙa a bisa bagaden kowace rana. ’Yan raguna biyu masu shekara ɗaya-ɗaya. ");
INSERT INTO hausa_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Ka miƙa ɗaya da safe, ɗaya kuma da yamma. ");
INSERT INTO hausa_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Haɗe da ɗan rago na farkon, ka miƙa mudun gari mai laushi wanda an gauraye da kwalaba ɗaya na tataccen mai zaitun, da kwalaba ɗaya na ruwan inabi don hadaya ta sha. ");
INSERT INTO hausa_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Ka miƙa ɗaya ragon da yamma, tare da hadaya ta gari da hadaya ta sha kamar aka yi ta safe, mai daɗin ƙanshi, wato, hadaya ce da aka ƙone da wuta ga Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","“Wannan za tă zama hadaya ta ƙonawar da za a dinga yi kowace rana, daga tsara zuwa tsara. Za a yi ta miƙa hadayar a ƙofar Tentin Sujada a gaban Ubangiji. A can zan sadu da kai, in yi magana da kai; ");
INSERT INTO hausa_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","a can kuma zan sadu da Isra’ilawa, in kuma tsarkake wurin da ɗaukakata. ");
INSERT INTO hausa_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","“Ta haka zan tsarkake Tentin Sujada da bagaden, in kuma tsarkake Haruna da ’ya’yansa maza su yi mini hidima a matsayin firistoci. ");
INSERT INTO hausa_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Sa’an nan zan zauna a cikin Isra’ilawa, in kuma zama Allahnsu. ");
INSERT INTO hausa_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Za su san cewa ni ne Ubangiji Allahnsu, wanda ya fitar da su daga Masar saboda in zauna a cikinsu. Ni ne Ubangiji Allahnsu. ");
INSERT INTO hausa_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“Ka yi bagade da itacen ƙirya don ƙona turare. ");
INSERT INTO hausa_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Zai zama murabba’i, tsawon zai zama kamu ɗaya, fāɗi kuma kamu ɗaya, amma tsayin yă zama kamu biyu, ƙahoninsa kuma su zama ɗaya da shi. ");
INSERT INTO hausa_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Ka dalaye bisansa da kuma dukan gefe-gefensa da kuma ƙahoninsa da zinariya zalla, ka kuma yi zubi na zinariya kewaye da shi. ");
INSERT INTO hausa_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Ka yi zobai biyu na zinariya domin bagade a ƙarƙashin zubin, biyu a gefe da gefe su fuskanci juna, don su riƙe sandunan da ake amfani da su don ɗaukarsa. ");
INSERT INTO hausa_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Ka yi sandunan nan da itacen ƙirya, ka dalaye su da zinariya. ");
INSERT INTO hausa_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Ka sa bagaden a gaban labulen da yake gaban akwatin alkawari, a gaba murfin kafara wanda yake bisa akwatin alkawari, inda zan sadu da kai. ");
INSERT INTO hausa_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“Haruna zai ƙone turare a bisa bagaden kowace safiya, sa’ad da yake shirya fitilu. ");
INSERT INTO hausa_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Dole Haruna yă ƙone turare sa’ad da ya ƙuna fitilu da yamma, ta haka za a riƙa ƙona turare a gaban Ubangiji, daga tsara zuwa tsara. ");
INSERT INTO hausa_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Ba za a ƙona wani irin turare dabam a bisa wannan bagade ba, ba kuma za a miƙa hadaya ta ƙonawa, ko ta hatsi, ko ta sha a bisansa ba. ");
INSERT INTO hausa_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Sau ɗaya a shekara, Haruna zai yi kafara a bisa ƙahoninsa. Dole a yi wannan kafara ta shekara-shekara da jinin kafara ta hadaya don zunubi daga tsara zuwa tsara. Gama bagaden mafi tsarki ne ga Ubangiji.” ");
INSERT INTO hausa_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Sa’an nan Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Sa’ad da za ku ƙidaya Isra’ilawa, dole kowanne yă biya domin yă fanshe kansa ga Ubangiji a lokacin da aka ƙidaya shi. Ta haka babu wata annobar da za tă buge su sa’ad da kuke ƙidaya su. ");
INSERT INTO hausa_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Kowannen da ya ƙetare zuwa wurin waɗanda aka riga aka ƙidaya, dole yă ba da rabin shekel, bisa ga ma’aunin shekel na tsattsarkan wuri, wanda nauyinsa garwa ashirin ne. Wannan rabin shekel hadaya ce ga Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Duk waɗanda suka ƙetare, waɗanda shekarunsu ya kai ashirin ko fiye, za su ba da hadaya ga Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Masu arziki ba za su bayar fiye da rabin shekel ba, talakawa kuma ba za su bayar ƙasa da haka ba, sa’ad da za ku yi hadaya ga Ubangiji don kafara rayukanku. ");
INSERT INTO hausa_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Ku karɓi kuɗin kafara daga hannun Isra’ilawa, ku yi amfani da shi domin hidimar Tentin Sujada. Zai zama abin tunawa ga Isra’ilawa a gaban Ubangiji, don su yi kafarar rayukansu.” ");
INSERT INTO hausa_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Sa’an nan Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Ka yi daro na tagulla, ka yi masa ƙafafun da za a ajiye shi da tagulla don wanki. Ka ajiye shi tsakanin Tentin Sujada da bagade, ka zuba ruwa a ciki. ");
INSERT INTO hausa_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Haruna da ’ya’yansa maza za su wanke hannuwansu da ƙafafunsu da ruwan da yake cikinsa. ");
INSERT INTO hausa_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Duk lokacin da suka shiga Tentin Sujada, za su yi wanka, don kada su mutu. Duk lokacin da suka yi kusa da bagade don hidima ta miƙa hadayar da aka yi wa Ubangiji da wuta, ");
INSERT INTO hausa_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","za su wanke hannuwansu da ƙafafunsu, don kada su mutu. Wannan za tă zama dawwammamiyar farilla domin Haruna da zuriyarsa daga tsara zuwa tsara.” ");
INSERT INTO hausa_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Sa’an nan Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Ka ɗauki waɗannan kayan yaji masu kyau, shekel 500 na ruwan mur, rabin turaren sinnamon mai daɗin ƙanshi shekel 250, shekel 250 na turaren wuta mai ƙanshi, ");
INSERT INTO hausa_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","shekel 500 na kashiya, duk bisa ga ma’aunin shekel na tsattsarkan wuri, da moɗa na man zaitun. ");
INSERT INTO hausa_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Da waɗannan za ka yi man shafewa mai tsarki, yadda mai yin turare yake yi. Zai zama man shafewa mai tsarki. ");
INSERT INTO hausa_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Sa’an nan ka yi amfani da shi don shafa wa Tentin Sujada, da akwatin alkawari, ");
INSERT INTO hausa_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","da tebur da kuma dukan kayansa, da wurin ajiye fitila da dukan kayansa, da bagaden ƙona turare, ");
INSERT INTO hausa_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","bagaden hadaya ta ƙonawa da dukan kayansa, da daro da mazauninsa. ");
INSERT INTO hausa_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Za ka tsarkake su don su zama mafi tsarki, kuma duk abin da ya taɓa su, zai zama mai tsarki. ");
INSERT INTO hausa_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“Ka shafe Haruna da ’ya’yansa maza, ka kuma tsarkake su don su yi mini hidima a matsayin firistoci. ");
INSERT INTO hausa_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Ka faɗa wa Isra’ilawa, ‘Wannan mai, zai zama mai tsarki ne a gare ni don shafewa, daga tsara zuwa tsara. ");
INSERT INTO hausa_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Kada a zuba a jikunan mutane, kada kuma a yi wani mai irinsa. Wannan mai, mai tsarki ne, za ku kuma ɗauke shi a matsayi mai tsarki. ");
INSERT INTO hausa_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Duk wanda ya yi irin wannan mai, duk wanda kuma ya shafa shi a kan wani wanda yake ba firist ba, za a ware shi daga mutanensa.’ ” ");
INSERT INTO hausa_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Sa’an nan Ubangiji ya ce wa Musa, “Ka ɗauki kayan yaji mai ƙanshi, resin na gum, da onika, da galbanum, da kuma zallan lubban, duk nauyinsu yă zama daidai. ");
INSERT INTO hausa_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Ka yi turare mai ƙanshi yadda mai yin turare yake yi. A sa masa gishiri, yă zama tsabtatacce, tsarkakakke. ");
INSERT INTO hausa_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Ka ɗiba kaɗan daga ciki, ka niƙa, ka ajiye a gaban akwatin alkawari a cikin Tentin Sujada, inda zan sadu da kai. Zai zama mafi tsarki a gare ku. ");
INSERT INTO hausa_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Kada ku yi wani turare irinsa wa kanku; ku ɗauke shi a matsayi mai tsarki ga Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Duk wanda ya yi irinsa don jin daɗin ƙanshinsa, dole a ware shi daga mutanensa.” ");
INSERT INTO hausa_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Sai Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Duba, na zaɓi Bezalel ɗan Uri, ɗan Hur, na kabilar Yahuda, ");
INSERT INTO hausa_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","na kuma cika shi da Ruhun Allah, fasaha, azanci, da kuma sani cikin kowace irin sana’a, ");
INSERT INTO hausa_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","don yin zāne-zāne na aikin zinariya, azurfa da tagulla, ");
INSERT INTO hausa_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","don yanka da shirya duwatsu, yin aikin katako, da kuma yin kowane irin aikin sana’ar hannu. ");
INSERT INTO hausa_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Ban da haka, na zaɓi Oholiyab ɗan Ahisamak, na kabilar Dan, don yă taimake shi. Na kuma ba da fasaha ga dukan masu aikin sana’ar hannu, don yin duk abin da na umarce ka. ");
INSERT INTO hausa_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Tentin Sujada, akwatin Alkawari tare da murfin kafara a bisansa, da dukan kayan aiki na tentin, ");
INSERT INTO hausa_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","tebur da kayansa, wurin ajiye fitila na zinariya zalla, da dukan kayansa, bagaden ƙona turare, ");
INSERT INTO hausa_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","bagaden hadaya ta ƙonawa da dukan kayansa, daro tare da mazauninsa, ");
INSERT INTO hausa_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","da kuma saƙaƙƙun riguna, tsarkakan riguna don Haruna firist da rigunan ’ya’yansa maza, sa’ad da suke hidima a matsayin firistoci, ");
INSERT INTO hausa_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","da man shafewa, da turare mai ƙanshi don Wuri Mai Tsarki. Za a yi su kamar yadda na umarce ka.” ");
INSERT INTO hausa_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Sa’an nan Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Ka faɗa wa Isra’ilawa, ‘Dole ku kiyaye Asabbataina. Wannan zai zama alama tsakanina da ku daga tsara zuwa tsara, saboda ku sani ni ne Ubangiji, wanda ya mai da ku masu tsarki. ");
INSERT INTO hausa_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","“ ‘Ku kiyaye Asabbaci, domin yă zama mai tsarki a gare ku. Duk wanda ya ƙazantar da shi, za a kashe shi; duk wanda ya yi wani aiki a ranar, za a ware shi daga mutane. ");
INSERT INTO hausa_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Kwana shida, za a yi aiki, amma a rana ta bakwai, Asabbaci ne na hutu, mai tsarki ga Ubangiji. Duk wanda ya yi wani aiki a Asabbaci, za a kashe shi. ");
INSERT INTO hausa_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Isra’ilawa za su kiyaye Asabbaci, suna bikinsa daga tsara zuwa tsara a matsayin madawwamin alkawari. ");
INSERT INTO hausa_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Zai zama alama tsakanina da Isra’ilawa har abada, gama cikin kwana shida Ubangiji ya yi sama da ƙasa, a rana ta bakwai kuma ya daina aiki, ya kuma huta.’ ” ");
INSERT INTO hausa_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Sa’ad da Ubangiji ya gama yin wa Musa magana a kan Dutsen Sinai, sai ya ba shi alluna biyu na Alkawari, allunan duwatsu rubutattu da yatsan Allah. ");
INSERT INTO hausa_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Sa’ad da mutane suka ga Musa ya daɗe bai sauko daga dutse ba, sai suka taru kewaye da Haruna suka ce, “Zo, ka yi mana alloli waɗanda za su yi mana jagora. Game da wannan Musa wanda ya fitar da mu daga Masar dai, ba mu san abin da ya faru da shi ba.” ");
INSERT INTO hausa_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Haruna ya amsa musu ya ce, “Ku tuttuɓe zoban zinariya waɗanda suke kunnuwan matanku, da na ’ya’yanku maza da mata, ku kawo mini.” ");
INSERT INTO hausa_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Saboda haka dukan mutane suka tuttuɓe ’yan kunnensu suka kawo wa Haruna. ");
INSERT INTO hausa_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Sai ya karɓi abubuwan da suka ba shi, ya yi gunki na siffar ɗan maraƙi, ya sassaƙa shi da kayan aiki. Sa’ad da mutane suka gani, sai suka tā da murya suka ce, “Waɗannan su ne allolinku, ya Isra’ila, waɗanda suka fitar da ku daga Masar.” ");
INSERT INTO hausa_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Da Haruna ya ga haka, sai ya gina bagade a gaban ɗan maraƙi, ya yi shela ya ce, “Gobe akwai biki ga Ubangiji.” ");
INSERT INTO hausa_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Saboda haka kashegari, mutane suka tashi da sassafe suka miƙa hadaya ta ƙonawa, da hadaya ta salama. Bayan haka suka zauna suka ci, suka sha, suka kuma tashi suka yi rawa. ");
INSERT INTO hausa_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Sai Ubangiji ya ce wa Musa, “Sauka, gama mutanenka, waɗanda ka fitar da su daga Masar sun ƙazantu. ");
INSERT INTO hausa_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Sun yi saurin juyawa daga abin da na umarce su, sun kuma yi wa kansu gunki na siffar ɗan maraƙi. Sun yi sujada ga ɗan maraƙi, suka yi hadaya gare shi, suka kuma ce, waɗannan su ne allolinka ya Isra’ila, waɗanda suka fito da kai daga Masar.” ");
INSERT INTO hausa_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Ubangiji ya ce wa Musa, “Na ga waɗannan mutane, mutane ne masu taurinkai.” ");
INSERT INTO hausa_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Yanzu ka bar ni kurum fushina yă yi ƙuna a kansu, in hallaka su. Sa’an nan in maishe ka al’umma mai girma. ");
INSERT INTO hausa_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Amma Musa ya nemi tagomashin Ubangiji, Allahnsa ya ce, “Ya Ubangiji don me fushinka zai yi ƙuna a kan mutanenka, waɗanda ka fisshe su daga Masar da ikon hannunka mai girma? ");
INSERT INTO hausa_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Don me za ka sa Masarawa su ce, ‘Ai, da mugun nufi ne ya fito da su don yă shafe su daga fuskar duniya’? Ka juya daga fushinka mai zafi, ka ji tausayi, kada ka kawo masifa a kan mutanenka. ");
INSERT INTO hausa_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Ka tuna da bayinka Ibrahim, Ishaku da Isra’ila, waɗanda ka rantse da kanka cewa, ‘Zan mai da zuriyarka kamar taurarin sama kuma zan ba wa zuriyarka wannan ƙasa wadda na yi musu alkawari, za tă kuma zama abin gādonsu har abada.’ ” ");
INSERT INTO hausa_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Sai Ubangiji ya yi juyayi, bai kuwa kawo wa mutanensa bala’in da ya yi niyya ba. ");
INSERT INTO hausa_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Musa ya juya, ya sauka daga kan dutsen da alluna biyu na Alkawari a hannuwansa. An yi rubutun a kowane gefe, gaba da baya. ");
INSERT INTO hausa_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Allunan aikin Allah ne; rubutun kuma rubutun Allah ne, da ya zāna a kan alluna. ");
INSERT INTO hausa_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Sa’ad da Yoshuwa ya ji surutun mutane suna ihu, sai ya ce wa Musa, “Kamar akwai ƙarar yaƙi a sansani.” ");
INSERT INTO hausa_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Musa ya amsa ya ce, “Ba ƙarar nasara ba ce, ba ƙarar wanda yaƙi ya ci ba ne; ƙarar waƙa ce nake ji.” ");
INSERT INTO hausa_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Da Musa ya kusato sansanin, sai ya ga ɗan maraƙin da kuma mutane suna rawa. Sai fushinsa ya yi ƙuna, ya kuwa jefar da allunan da suke hannuwansa, allunan kuwa suka farfashe a gindin dutsen. ");
INSERT INTO hausa_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Sai ya ɗauki ɗan maraƙin da suka yi, ya ƙone a wuta; sa’an nan ya niƙa shi ya zama gari, ya barbaɗa garin a ruwa, ya sa Isra’ilawa suka sha. ");
INSERT INTO hausa_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Ya ce wa Haruna, “Mene ne waɗannan mutane suka yi maka da ka kai su ga wannan zunubi mai girma?” ");
INSERT INTO hausa_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Haruna ya amsa ya ce, “Kada ka yi fushi da ni ranka yă daɗe, ka san yadda mutanen nan suke da saurin yin mugunta. ");
INSERT INTO hausa_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Sun ce mini, ‘Ka yi mana alloli waɗanda za su yi mana jagora, game da wannan Musa dai, wanda ya fito da mu daga Masar, ba mu san abin da ya faru da shi ba.’ ");
INSERT INTO hausa_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Sai na gaya musu, ‘Duk wanda yana da kayan ado na zinariya, ya cire?’ Sa’an nan suka ba ni zinariya, sai na jefa cikin wuta, wannan ɗan maraƙi ya fito.” ");
INSERT INTO hausa_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Musa ya duba ya ga mutane sun kauce gaba ɗaya domin Haruna ya sa suka kauce, har suka zama abin dariya ga abokan gābansu. ");
INSERT INTO hausa_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Saboda haka sai ya tsaya a ƙofar sansani ya ce, “Duk wanda yake na Ubangiji yă zo wurina.” Sai dukan Lawiyawa suka taru wurinsa. ");
INSERT INTO hausa_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Sa’an nan ya ce musu, “Ga abin da Ubangiji, Allah na Isra’ila ya ce, ‘Kowane mutum yă rataya takobinsa, yă kai yă kawo daga wannan gefe zuwa wancan cikin sansani, kowa yă kashe ɗan’uwansa, da abokinsa, da kuma maƙwabcinsa.’ ” ");
INSERT INTO hausa_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Lawiyawa suka yi yadda Musa ya umarta, a ranar, mutane wajen dubu uku suka mutu. ");
INSERT INTO hausa_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Sa’an nan Musa ya ce, “An keɓe ku ga Ubangiji a yau, gama kun yi gāba da ’ya’yanku da ’yan’uwanku, ya kuma albarkace ku a wannan rana.” ");
INSERT INTO hausa_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Kashegari Musa ya ce wa mutane, “Kun yi zunubi mai girma. Amma yanzu zan hau wurin Ubangiji; wataƙila zan iya yin kafara domin zunubinku.” ");
INSERT INTO hausa_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Don haka Musa ya koma wurin Ubangiji ya ce, “Kaito, mutanen nan sun yi zunubi mai girma! Sun yi wa kansu allolin zinariya. ");
INSERT INTO hausa_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Amma yanzu, ina roƙonka ka gafarta zunubinsu, in ba haka ba, to, ka shafe ni daga littafin da ka rubuta.” ");
INSERT INTO hausa_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Ubangiji ya amsa wa Musa, “Duk wanda ya yi mini zunubi, shi zan shafe daga littafina. ");
INSERT INTO hausa_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Yanzu tafi, ka jagoranci mutanen zuwa inda na yi zance, mala’ikana kuma zai sha gabanku. Duk da haka sa’ad da lokaci ya yi da zan yi horo, zan hore su domin zunubinsu.” ");
INSERT INTO hausa_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Ubangiji kuwa ya bugi mutanen da annoba, saboda abin da suka yi da ɗan maraƙin da Haruna ya yi. ");
INSERT INTO hausa_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Sa’an nan Ubangiji ya ce wa Musa, “Ka bar wannan wuri, kai da mutanen da ka fito da su daga Masar, ka haura zuwa ƙasar da na alkawarta da rantsuwa wa Ibrahim, Ishaku da Yaƙub cewa, ‘Zan ba zuriyarka.’ ");
INSERT INTO hausa_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Zan aika da mala’ika a gabanka in kuma kori Kan’aniyawa, Amoriyawa, Hittiyawa, Ferizziyawa, Hiwiyawa da Yebusiyawa. ");
INSERT INTO hausa_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Ka haura zuwa ƙasar da take zub da madara da zuma. Amma ba zan tafi tare da ku ba, saboda ku mutane ne masu taurinkai domin mai yiwuwa in hallaka ku a hanya.” ");
INSERT INTO hausa_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Da mutane suka ji wannan mugun magana, sai suka fara makoki. Ba kuma wanda ya sa kayan ado. ");
INSERT INTO hausa_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Gama Ubangiji ya riga ya ce wa Musa, “Ka faɗa wa Isra’ilawa, ‘Ku mutane ne masu taurinkai. In na yi tafiya da ku ko na ɗan lokaci, mai yiwuwa in hallaka ku. Yanzu sai ku tuɓe kayan adonku, zan kuwa yanke shawara a kan abin da zan yi da ku.’ ” ");
INSERT INTO hausa_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Saboda haka Isra’ilawa suka tuttuɓe kayan adonsu a Dutsen Horeb. ");
INSERT INTO hausa_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Musa fa ya saba ɗaukan tenti yă kafa shi a bayan sansani da ɗan nisa, yana kiransa “Tentin Sujada.” Duk wanda yake neman wani abu daga wurin Ubangiji sai yă tafi Tentin Sujada a bayan sansani. ");
INSERT INTO hausa_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","A sa’ad da kuma Musa ya fita zuwa Tentin, dukan mutanen sukan tashi su tsaya a ƙofofin tentinsu, suna kallon Musa, sai ya shiga tentin. ");
INSERT INTO hausa_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Yayinda Musa ya shiga cikin tentin, sai al’amudin girgije yă sauko, yă tsaya a ƙofar yayinda Ubangiji yana magana da Musa. ");
INSERT INTO hausa_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Lokacin da mutane suka ga al’amudin girgije a tsaye a ƙofar tentin, sai duk su miƙe tsaye su yi sujada, kowa a ƙofar tentinsa. ");
INSERT INTO hausa_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Ubangiji yakan yi magana da Musa fuska da fuska, kamar yadda mutum yake magana da abokinsa. Sa’an nan Musa yă koma sansani, amma saurayin nan Yoshuwa ɗan Nun mai taimakonsa ba ya barin tentin. ");
INSERT INTO hausa_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Musa ya ce wa Ubangiji, “Kana ta faɗa mini cewa, ‘Ka jagoranci mutane nan,’ amma ba ka faɗa mini wanda zai tafi tare da ni ba. Ga shi ka ƙara ce mini, ‘Na san ka, na san sunanka, ka kuma sami tagomashi a wurina.’ ");
INSERT INTO hausa_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","In ka ji daɗina, ka koya mini hanyarka don in san ka, in kuma ci gaba da samun tagomashi daga gare ka. Ka tuna cewa wannan al’umma mutanenka ne.” ");
INSERT INTO hausa_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Ubangiji ya amsa ya ce, “Zan tafi tare da kai, zan kuma rage maka nauyin kaya.” ");
INSERT INTO hausa_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Musa kuwa ya ce masa, “In ba za tă tafi tare da mu ba, to, kada ka ɗaga mu daga nan. ");
INSERT INTO hausa_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Yaya wani zai sani ko ka ji daɗina da kuma mutanenka, in ba ka tafi tare da mu ba? Mene ne kuma zai bambanta ni da mutanenka daga sauran jama’ar da suke a duniya?” ");
INSERT INTO hausa_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Sai Ubangiji ya ce wa Musa, “Zan yi yadda ka faɗa, gama ka sami tagomashi a wurina, na san ka, na kuma san sunanka.” ");
INSERT INTO hausa_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Musa kuwa ya ce, “To, ka nuna mini ɗaukakarka.” ");
INSERT INTO hausa_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Sai Ubangiji ya ce, “Zan wuce a gabanka, Ni Ubangiji zan yi shelar sunana a gabanka. Zan yi alheri ga duk wanda na so in yi masa alheri, zan nuna jinƙai ga duk wanda na so in yi masa jinƙai. ");
INSERT INTO hausa_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Amma ya ce, ba za ka ga fuskata ba, don ba mutumin da zai gan ni yă rayu.” ");
INSERT INTO hausa_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Sa’an nan Ubangiji ya ce, “Ga wani wuri kusa da ni inda za ka tsaya bisa dutsen. ");
INSERT INTO hausa_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","A sa’ad da ɗaukakata tana wucewa, zan sa ka a cikin tsaguwar dutsen, in rufe ka da hannuna har sai na wuce. ");
INSERT INTO hausa_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Sa’an nan zan ɗauke hannuna, ka kuwa ga bayana; amma fuskata, ba za ka gani ba.” ");
INSERT INTO hausa_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Ubangiji ya ce wa Musa “Sassaƙa alluna biyu kamar na farko, ni kuwa in rubuta kalmomin da suke cikin alluna na farko da ka farfasa. ");
INSERT INTO hausa_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Ka shirya da safe, ka hauro kan Dutsen Sinai. Ka gabatar da kanka a gare ni a can kan dutse. ");
INSERT INTO hausa_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Ba wani da zai zo tare da kai, ko a gan shi ko’ina a kan dutsen, kada garkunan tumaki ko na shanu su yi kiwo kusa da dutsen.” ");
INSERT INTO hausa_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Saboda haka Musa ya sassaƙa alluna biyu na dutse kamar na fari, sai ya hau Dutsen Sinai da sassafe, kamar yadda Ubangiji ya umarce shi, yana kuma ɗauke da alluna biyu na dutse a hannuwansa. ");
INSERT INTO hausa_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Sa’an nan Ubangiji ya sauko a cikin girgije ya tsaya can tare da shi, ya kuma yi shelar sunansa. ");
INSERT INTO hausa_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Sai Ubangiji ya wuce a gaban Musa, ya yi shela ya ce, “Ni ne Ubangiji Allah mai tausayi, mai alheri, mai jinkirin fushi, cike da ƙauna da aminci, ");
INSERT INTO hausa_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","nakan nuna ƙauna wa dubbai, nakan kuma gafarta mugunta, tawaye da zunubi. Amma ba na barin mai laifi, ba tare da na hore shi ba; nakan hukunta ’ya’ya da jikoki har tsara ta uku da ta huɗu saboda laifin iyaye.” ");
INSERT INTO hausa_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Musa ya yi sauri ya rusuna har ƙasa, ya yi sujada. ");
INSERT INTO hausa_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Ya ce, “Ya Ubangiji, in na sami tagomashi a idanunka, bari Ubangiji yă tafi tare da mu. Ko da yake wannan mutane masu taurinkai ne, ka gafarta muguntanmu da zunubanmu, ka kuma sāke sa mu zama abin gādonka.” ");
INSERT INTO hausa_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Sai Ubangiji ya ce, “Ga shi na yi alkawari da kai. A gaban dukan mutanenka zan yi abubuwan banmamakin da ba a taɓa yinsa a cikin wata al’umma a duniya ba. Mutanen da kuke zaune cikinsu za su ga aikin bantsoro, da Ni Ubangiji zan yi muku. ");
INSERT INTO hausa_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Ku yi biyayya da umarnin da na ba ka yau. Zan kora muku Amoriyawa, Kan’aniyawa, Hittiyawa, Ferizziyawa, Hiwiyawa da Yebusiyawa. ");
INSERT INTO hausa_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Ku kula, kada ku yi yarjejjeniya da waɗanda suke zaune a ƙasar da za ku tafi, in ba haka ba, za su zama muku tarko. ");
INSERT INTO hausa_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Ku rurrushe bagadansu, ku farfashe keɓaɓɓun duwatsunsu, ku sassare ginshiƙan Asheransu. ");
INSERT INTO hausa_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Kada ku bauta wa wani allah, gama Ubangiji, wanda sunansa Kishi, Allah ne mai kishi. ");
INSERT INTO hausa_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“Ku kula, kada ku yi yarjejjeniya da mazaunan wannan ƙasa, don kada sa’ad da suke yi wa allolinsu sujada, suna miƙa musu hadaya, su gayyace ku, ku ci hadayar da suka miƙa wa allolinsu. ");
INSERT INTO hausa_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Kada ku auro wa ’ya’yanku maza ’yan matansu, waɗanda suke yi wa alloli sujada, har su sa ’ya’yanku su bi allolinsu. ");
INSERT INTO hausa_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“Kada ku yi alloli na zubi. ");
INSERT INTO hausa_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Sai ku yi Bikin Burodi Marar Yisti. Ku kuma ci burodi marar yisti har kwana bakwai, kamar yadda na umarce ku. Ku yi wannan a ƙayyadadden lokacinsa a watan Abib, gama a cikin watan ne kuka fita daga Masar. ");
INSERT INTO hausa_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“Ɗan fari na kowane mutum zai zama nawa, har da ɗan farin na dabbobi, ko na garken shanu ko na tumaki. ");
INSERT INTO hausa_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Ku fanshi ɗan farin jaki da na tunkiya, amma in ba ku fanshe shi ba, ku karya wuyansa. Ku fanshi duk ’ya’yan farinku maza. “Kada wani yă zo gabana hannu wofi. ");
INSERT INTO hausa_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“Kwana shida za ku yi aiki, amma a rana ta bakwai za ku huta; ko da lokacin noma ne, ko lokacin girbi, sai ku huta. ");
INSERT INTO hausa_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“Ku kiyaye Bikin Makoni wato, bikin girbin nunan fari na alkama, da Bikin Gama Tattara amfanin gonaki, a ƙarshen shekara. ");
INSERT INTO hausa_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Sau uku a shekara, dukan mazanku za su bayyana a gaban Ubangiji Mai Iko Duka, Allah na Isra’ila. ");
INSERT INTO hausa_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Zan kore al’umma daga gabanku, in fadada kan iyakarku, babu wanda zai yi ƙyashin ƙasarku a lokutan nan uku na shekara da kuka haura don ku bayyana a gaban Ubangiji, Allahnku. ");
INSERT INTO hausa_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“Kada ku miƙa mini jinin hadaya tare da wani abin da yana da yisti, kada kuma ku bar kowace hadaya ta Bikin Ƙetarewa ta kwana. ");
INSERT INTO hausa_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“Ku kawo nunan farin amfanin gonarku mafi kyau a gidan Ubangiji, Allahnku. “Kada ku dafa ɗan akuya a cikin madarar mahaifiyarsa.” ");
INSERT INTO hausa_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Sa’an nan Ubangiji ya ce wa Musa, “Ka rubuta waɗannan kalmomi, gama bisa ga kalmomin nan, na yi alkawari da kai da kuma Isra’ila.” ");
INSERT INTO hausa_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Musa ya kasance tare da Ubangiji kwana arba’in da dare arba’in, bai ci ba, bai sha ba. Ya kuma rubuta kalmomin alkawari a kan alluna, wato, dokoki goma. ");
INSERT INTO hausa_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Sa’ad da Musa ya sauko daga kan Dutsen Sinai tare da alluna biyu na Alkawari a hannuwansa, bai san cewa fuskarsa tana ƙyalli ba saboda zaman da ya yi a gaban Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Da Haruna da dukan Isra’ila suka ga Musa, fuskarsa kuma tana ƙyalli, sai suka ji tsoron zuwa kusa da shi. ");
INSERT INTO hausa_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Amma Musa ya kira su, sai Haruna da dukan shugabannin jama’ar suka zo wurinsa, ya kuwa yi musu magana. ");
INSERT INTO hausa_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Daga baya sai dukan Isra’ilawa suka zo kusa da shi, ya kuma ba su dukan dokokin da Ubangiji ya ba shi a Dutsen Sinai. ");
INSERT INTO hausa_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Da Musa ya gama magana da su, sai ya lulluɓe fuskarsa. ");
INSERT INTO hausa_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Amma duk sa’ad da ya je gaban Ubangiji don yă yi magana da shi, sai yă tuɓe lulluɓin har sai ya fito. Kuma duk sa’ad da ya fito yă faɗa wa Isra’ilawa abin da aka umarce shi, ");
INSERT INTO hausa_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","sai su ga fuskarsa tana ƙyalli. Sa’an nan Musa yă sāke lulluɓe fuskarsa, har sai ya shiga don yă yi magana da Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Musa ya tara dukan jama’ar Isra’ilawa ya ce musu, “Waɗannan su ne abubuwan da Ubangiji ya umarce ku, ku yi. ");
INSERT INTO hausa_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Kwana shida za ku yi aiki, amma rana ta bakwai za tă zama rana mai tsarki, Asabbaci ne na hutu ga Ubangiji. Duk wanda ya yi aiki a wannan rana dole a kashe shi. ");
INSERT INTO hausa_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Kada ku hura wuta a cikin duk mazauninku a ranar Asabbaci.” ");
INSERT INTO hausa_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Musa ya ce wa dukan jama’ar Isra’ilawa, “Ga abin da Ubangiji ya umarta. ");
INSERT INTO hausa_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Daga cikin abin da kuke da shi, ku ɗauki kyauta domin Ubangiji, duk wanda yana niyya, sai yă kawo wa Ubangiji kyauta ta, “zinariya, azurfa da tagulla; ");
INSERT INTO hausa_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","shuɗi, shunayya da jan zare, lallausan lilin, da gashin akuya; ");
INSERT INTO hausa_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","fatun rago da aka rina ja, da fatun shanun teku; da itacen ƙirya ");
INSERT INTO hausa_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","da man zaitun don fitila; da kayan yaji don man shafewa, da kuma turare mai ƙanshi; ");
INSERT INTO hausa_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","duwatsun onis, da sauran duwatsu masu daraja waɗanda za a mammanne a efod da ƙyallen maƙalawa a ƙirji. ");
INSERT INTO hausa_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“Duk waɗanda suke da fasaha a cikinku, su zo su yi dukan abin da Ubangiji ya umarta, ");
INSERT INTO hausa_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","“wato, aikin tabanakul da tentinsa tare da murfinsa, maɗauransa, katakansa, sandunansa da tussansa; ");
INSERT INTO hausa_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","akwatin alkawari da sandunansa, murfin kafara da labulen da ya rufe shi; ");
INSERT INTO hausa_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","tebur da sandunansa, da dukan kayansa da kuma burodin kasancewa; ");
INSERT INTO hausa_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","wurin ajiye fitila da yake don fitilu da kayayyakinsa, fitilu da mai don fitila; ");
INSERT INTO hausa_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","bagaden turare da sandunansa, man shafewa da turare mai ƙanshi; da labulen ƙofar shiga tabanakul; ");
INSERT INTO hausa_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","bagaden hadaya ta ƙonawa da rigarsa ta tagulla da sandunansa da duk kayayyakinsa, daron tagulla da wurin ajiye shi. ");
INSERT INTO hausa_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","Labulen filin tenti da sandunansa da tussansa, da kuma labulen ƙofar shiga fili; ");
INSERT INTO hausa_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","turakun tenti don tabanakul da kuma don filin, da igiyoyinsu; ");
INSERT INTO hausa_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","saƙaƙƙun riguna na sawa don hidima cikin wuri mai tsarki da tsarkakakkun riguna na Haruna firist, da riguna don ’ya’yansa maza lokacin da suke aiki a matsayin firistoci.” ");
INSERT INTO hausa_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Sai dukan jama’ar Isra’ilawa suka janye daga fuskar Musa, ");
INSERT INTO hausa_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","duk waɗanda suke da niyya, waɗanda kuma zukatansu suka motsa su, suka kawo kyautai wa Ubangiji, don aikin Tentin Sujada, don duk aikinsa, da don tsarkakakkun riguna. ");
INSERT INTO hausa_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Duk waɗanda suke da niyya, maza da mata, gaba ɗaya, suka kawo kayan ado na zinariya na kowane iri. ’Yan kunne, da ƙawane, da mundaye, da kayayyakin zinariya iri-iri. Dukansu suka miƙa zinariyarsu a matsayin hadaya ga Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Kowane mutumin da yake da shuɗi, shunayya ko jan zare, ko lallausan lilin, ko gashin akuya, ko fatun rago da aka rina ja, ko fatun shanun teku, suka kawo. ");
INSERT INTO hausa_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Masu miƙa kyautar azurfa, ko tagulla suka kawo su a matsayin kyautai ga Ubangiji, kuma kowane mutumin da yake da itacen ƙirya don kowane sashin aikin, ya kawo. ");
INSERT INTO hausa_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Kowace mace mai fasaha ta kaɗa zare da hannuwanta, ta kuma kawo abin da ta kaɗa na shuɗi, shunayya, ko jan zare, ko lallausan lilin. ");
INSERT INTO hausa_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Kuma dukan matan da suke da niyya, suke kuma da fasaha, suka kaɗa gashin akuya. ");
INSERT INTO hausa_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Shugabannin suka kawo duwatsun Onis. Da duwatsu masu daraja don a jera a kan efod da ƙyallen maƙalawa a ƙirji. ");
INSERT INTO hausa_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Suka kawo kayan yaji da man zaitun don fitila da don man shafewa da kuma don turare mai ƙanshi. ");
INSERT INTO hausa_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Dukan mazan Isra’ilawa da matan da suke da niyya suka kawo wa Ubangiji kyautai na yardar rai, domin dukan aikin da Ubangiji ya umarce su ta bakin Musa. ");
INSERT INTO hausa_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Sa’an nan ya ce wa Isra’ilawa, “Duba Ubangiji ya zaɓi Bezalel ɗan Uri, ɗan Hur, daga kabilar Yahuda, ");
INSERT INTO hausa_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","ya kuma cika shi da Ruhun Allah, da fasaha, azanci da kuma sani cikin dukan sana’ar hannu, ");
INSERT INTO hausa_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","don yă ƙirƙiro zāne-zāne na gwaninta waɗanda za yi da zinariya, da azurfa da kuma tagulla. ");
INSERT INTO hausa_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","Haka kuma wajen sassaƙar duwatsu na jerawa, da sassaƙar itace, da kowane irin aiki na gwaninta. ");
INSERT INTO hausa_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Ya kuma ba Bezalel da Oholiyab ɗan Ahisamak, daga kabilar Dan, iyawa don koya wa waɗansu. ");
INSERT INTO hausa_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Ya cika su da fasaha don yin kowane irin aikin sana’a, zāne-zāne, ɗinke-ɗinke shuɗi, shunayya da jan zare, da lallausan lilin, da kuma masu yin saƙa, sun gwaninta ƙwarai cikin kowane irin aikin hannu da kuma zāne-zāne. ");
INSERT INTO hausa_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Saboda haka Bezalel, Oholiyab da kowane mutumin da Ubangiji ya ba shi basira da iyawa, na sanin yadda za a yi duk aikin shirya wuri mai tsarki, za su yi aiki yadda Ubangiji ya umarta.” ");
INSERT INTO hausa_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Sa’an nan Musa ya kira Bezalel da Oholiyab da kowane mutumin da Ubangiji ya ba shi iyawa da kuma wanda ya yi niyya yă yi aiki. ");
INSERT INTO hausa_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Suka karɓa daga wurin Musa dukan kyautai da Isra’ilawa suka kawo don su yi aikin shirya wuri mai tsarki. Mutane suka ci gaba da kawo kyautai yardar rai kowace safiya. ");
INSERT INTO hausa_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Sai dukan masu fasaha waɗanda suke aikin wuri mai tsarki suka ɗan dakata ");
INSERT INTO hausa_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","suka ce wa Musa, “Mutane suna kawo fiye da abin da ake bukata domin aikin da Ubangiji ya umarta a yi.” ");
INSERT INTO hausa_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Sai Musa ya ba da umarni, suka aika ko’ina a cikin sansani cewa, “Kada namiji ko ta mace yă sāke kawo kyauta don wuri mai tsarki.” Ta haka mutane suka daina kawowa. ");
INSERT INTO hausa_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Saboda abin da suke da shi ya fi abin da ake bukata domin aikin. ");
INSERT INTO hausa_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Dukan maza masu fasaha a cikin sauran masu aikin suka yi tabanakul da labule goma na tuƙaƙƙun lallausan lilin na shuɗi, da shunayya, da jan zare, aka yi wa labulen zānen kerubobi na gwaninta. ");
INSERT INTO hausa_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Tsawon kowane labule, kamu ashirin da takwas ne, fāɗinsa kuma kamu huɗu. Dukan labulen, girmansu ɗaya ne. ");
INSERT INTO hausa_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Suka ɗinɗinke labule biyar a harhaɗe, suka kuma yi haka da sauran labule biyar ɗin. ");
INSERT INTO hausa_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Suka yi rami a gefe-gefen labulen da zaren ruwan bula, haka kuma suka yi da ɗayan gefen na biyu ɗin. ");
INSERT INTO hausa_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Suka kakkafa rammuka hamsin a daidai bakin labulen, haka kuma suka yi a kan labule na biyun. Haka aka ɗaɗɗaura rammukan nan da junansu yă zama kamar abu guda. ");
INSERT INTO hausa_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Sa’an nan suka yi maɗaurai hamsin na zinariya, suka yi amfani da su don daurin kashi biyu na labulen saboda tabanakul yă zama ɗaya. ");
INSERT INTO hausa_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Suka yi labule da gashi akuya goma sha ɗaya don tenti a bisa tabanakul. ");
INSERT INTO hausa_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Dukan labule goma sha ɗayan girmansu ɗaya ne, tsawonsa kamu talatin, fāɗinsa kuma kamu huɗu ne. ");
INSERT INTO hausa_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Suka harhaɗa labule biyar wuri ɗaya, suka kuma harhaɗa shida wuri ɗaya. ");
INSERT INTO hausa_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Sa’an nan suka yi rammuka hamsin a gefen labule na kashe na farko, haka kuma a gefen labule na ƙarshen na kashi biyar. ");
INSERT INTO hausa_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Suka yi maɗaurin tagulla hamsin don su ɗaura tenti yă zama ɗaya. ");
INSERT INTO hausa_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Sai suka yi wa tentin murfi da fatun rago da aka rina ja, a bisa wannan kuwa akwai murfin fatun shanun teku. ");
INSERT INTO hausa_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Suka yi katakan tabanakul da itacen ƙirya. ");
INSERT INTO hausa_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Tsawon kowane katako kamu goma ne, kaurinsa kuma kamu ɗaya da rabi, ");
INSERT INTO hausa_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","tare da katakai a fiƙe ɗaura da juna. Haka suka yi da dukan katakan tabanakul. ");
INSERT INTO hausa_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Suka yi katakai ashirin don gefen kudu na tabanakul ");
INSERT INTO hausa_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","suka kuma yi rammukan azurfa arba’in don katakan su shiga ƙarƙashinsu, rammuka biyu domin kowane katako, ɗaya ƙarƙashin kowanne da aka fiƙe. ");
INSERT INTO hausa_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","A ɗaya gefen, gefen arewa na tabanakul, suka yi katakai ashirin ");
INSERT INTO hausa_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","da rammuka arba’in na azurfa, biyu-biyu don kowane katako. ");
INSERT INTO hausa_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Suka yi katako shida don iyaka ta ƙarshe, wato, gefen yamma na tabanakul, ");
INSERT INTO hausa_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","aka kuma yi katakai biyu domin kusurwoyi tabanakul a iyaka ta ƙarshe. ");
INSERT INTO hausa_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","A waɗannan kusurwoyi biyu, an ninka katakan sau biyu daga ƙasa har sama, aka kuma sa su cikin zobe guda; dukansu biyu an yi su daidai. ");
INSERT INTO hausa_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Ta haka aka sami katakai takwas da rammukan azurfa goma sha shida, biyu-biyu a ƙarƙashin kowane katako. ");
INSERT INTO hausa_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Suka kuma yi sanduna na itace ƙirya, biyar domin katakan da suke a gefe guda na tabanakul, ");
INSERT INTO hausa_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","biyar domin waɗanda suke ɗayan gefen da kuma biyar domin katakan da suke gefen yamma na iyaka ta ƙarshen tabanakul. ");
INSERT INTO hausa_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Suka sa sandan da yake a tsakiya yă wuce daga wannan gefe zuwa wancan. ");
INSERT INTO hausa_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Sai suka dalaye katakan da zinariya, suka yi zoban zinariya don su riƙe sandunan. Suka kuma dalaye sandunan da zinariya. ");
INSERT INTO hausa_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Suka kuma yi labule da shuɗi, shunayya, jan zare, da kuma lallausan lilin, suka kuma yi wa labulen zānen kerubobi na gwaninta. ");
INSERT INTO hausa_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Suka yi dogayen sanduna huɗu na itacen ƙirya dominsa, suka dalaye su da zinariya. Suka yi ƙugiya na zinariya dominsa, suka yi rammuka huɗu da azurfa. ");
INSERT INTO hausa_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Suka yi wa ƙofar tenti labulen shuɗi, shunayya, jan zare, da kuma lallausan lilin, aikin gwaninta; ");
INSERT INTO hausa_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","suka kuma yi dogayen sanduna biyar da ƙugiya dominsu. Suka dalaye saman dogayen sandunan da abin daurinsu da zinariya, suka kuma yi rammukansu guda biyar da tagulla. ");
INSERT INTO hausa_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Bezalel ya yi akwatin alkawari da itacen ƙirya, tsawonsa kamu biyu da rabi, fāɗinsa kamu ɗaya da rabi, tsayinsa kamu ɗaya da rabi. ");
INSERT INTO hausa_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Ya dalaye shi da zinariya zalla, ciki da waje, ya kuma yi zubin zinariya kewaye da shi. ");
INSERT INTO hausa_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Ya yi masa zubi huɗu na zoban zinariya, ya kuma ɗaura su a ƙafafunsa huɗu, zobai biyu a wannan gefe da kuma biyu a wancan. ");
INSERT INTO hausa_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Sa’an nan ya yi sanduna na itacen ƙirya, ya dalaye shi da zinariya. ");
INSERT INTO hausa_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Sai ya sa sandunan a cikin rammukan da suke gefen Akwatin don ɗaukarsa. ");
INSERT INTO hausa_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Ya yi murfin jinƙai da zinariya zalla, wato, tsawonsa ƙafa biyu, fāɗinsa kuma ƙafa ɗaya da rabi. ");
INSERT INTO hausa_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Sa’an nan ya yi kerubobi biyu da ƙeraren zinariya a ƙarshen murfin jinƙan. ");
INSERT INTO hausa_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Ya yi kerub a iyakar gefe ɗaya, ya yi ɗayan kuma a wancan gefe; a iyakan nan biyu, ya yi su a haɗe da murfin. ");
INSERT INTO hausa_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Kerubobin suka buɗe fikafikansu sama, suka inuwatar da murfin da fikafikansu. Kerubobin suna fuskantar juna, suna kuma kallon murfin. ");
INSERT INTO hausa_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Suka yi tebur da itacen ƙirya, tsawonsa ƙafa biyu, fāɗinsa ƙafa ɗaya, tsayinsa kuma ƙafa ɗaya da rabi. ");
INSERT INTO hausa_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Sa’an nan suka dalaye shi da zinariya zalla, suka kuma yi zubi na zinariya kewaye da shi. ");
INSERT INTO hausa_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Suka kuma yi masa baki mai fāɗin tafi hannu, suka yi zubin zinariya a bisa bakin. ");
INSERT INTO hausa_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Suka yi zubin zobai huɗu na zinariya don tebur ɗin, sai suka ɗaura su a kusurwoyi huɗu inda ƙafafu huɗun suke. ");
INSERT INTO hausa_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Sa’an nan aka sa zoban kurkusa da bakin don riƙe sandunan da ake amfani da su wurin ɗaukan teburin. ");
INSERT INTO hausa_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","An yi sandunan da ake ɗaukan tebur da itacen ƙirya, aka kuma dalaye su da zinariya. ");
INSERT INTO hausa_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Suka kuma yi duk kayayyakin teburin da zinariya zalla, farantansa, kwanonin tuya, kwanoninsa, da kuma butoci domin hadaya ta sha. ");
INSERT INTO hausa_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Suka yi wurin ajiye fitila da zinariya zalla, suka yi gindinsa da kuma gorar jikinsa, da ƙerarriyar zinariya. Kwaf wurin ajiye fitila da mahaɗansa, da furanninsa, a haɗe aka yi su da wurin ajiye fitilan. ");
INSERT INTO hausa_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Akwai rassa guda shida da suka miƙe daga gefe wurin ajiyar fitilar, uku a wannan gefe, uku kuma a wancan. ");
INSERT INTO hausa_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","A reshe guda na wurin ajiye fitilan, akwai kwaf uku masu kama da tohon almon, akwai kuma uku a reshe na biye, haka kuma suke a dukan rassa shida da suke daga wurin ajiye fitilan. ");
INSERT INTO hausa_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","A bisa wurin ajiye fitilan kuma akwai kwaf huɗu da aka yi su kamar furannin almon da toho da kuma mahaɗai. ");
INSERT INTO hausa_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Toho ɗaya yana a ƙarƙashin rassa biyu waɗanda suke daga wurin ajiye fitilan, toho na biyu yana a ƙarƙashin rassa biyu na biye, toho na uku kuma yana a ƙarƙashin rassa biyu na uku, duka-duka rassa shida ne. ");
INSERT INTO hausa_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","An ƙera mahaɗai da rassa wurin ajiye fitila a haɗe. Da ƙerarriyar zinariya aka yi wurin ajiye fitilar da dukan komensa a haɗe. ");
INSERT INTO hausa_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Da zinariya zalla suka yi fitilu bakwai, da hantsuka da farantansa. ");
INSERT INTO hausa_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Daga talenti ɗaya na zinariya zalla suka yi wurin ajiye fitila da dukan kayayyakinsa. ");
INSERT INTO hausa_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Suka yi bagaden ƙona turare da itacen ƙirya. Shi bagaden, murabba’i ne, tsawonsa kamu ɗaya, fāɗinsa kamu ɗaya, tsayinsa kuma kamu biyu, ƙahoninsa kuwa a haɗe suke da shi. ");
INSERT INTO hausa_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Suka dalaye saman da dukan gefe-gefen da kuma ƙahonin da zinariya zalla, suka kuma yi zubin zinariya kewaye da shi. ");
INSERT INTO hausa_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Suka yi zobai biyu na zinariya a ƙarƙashin zubin, biyu-biyu ɗaura da juna, don su riƙe sandunan da za a ɗauka shi. ");
INSERT INTO hausa_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Suka yi sandunan da itacen ƙirya, suka kuma dalaye su da zinariya. ");
INSERT INTO hausa_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Suka kuma yi tsattsarkan mai na shafewa da kuma zalla turare mai ƙanshi, yadda mai yin turare yakan yi. ");
INSERT INTO hausa_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Suka gina bagaden ƙona hadaya da itacen ƙirya, tsawonsa kamu biyar, fāɗinsa kamu biyar, murabba’i ke nan, tsayinsa kuwa kamu uku. ");
INSERT INTO hausa_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Suka yi ƙahoni a kusurwansa huɗu, ƙahonin da bagade a haɗe suke, suka kuma dalaye bagaden da tagulla. ");
INSERT INTO hausa_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Da tagulla kuma ya yi duk kayayyakin bagaden, da kwanoni, da babban cokali, da daruna, da cokula masu yatsotsi, da farantan wuta. ");
INSERT INTO hausa_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Suka yi wa bagaden raga, tagulla kuma don yă sa shi a tsakiya. ");
INSERT INTO hausa_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Suka yi zubin zoban tagulla don riƙe sanduna a kusurwoyi huɗu na ragar tagullar. ");
INSERT INTO hausa_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Suka yi sanduna da itacen ƙirya, suka kuma dalaye su da tagulla. ");
INSERT INTO hausa_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Suka sa sandunan a cikin zoban saboda su kasance a gefen bagade don ɗaukarsa, suka yi rami cikinsa. ");
INSERT INTO hausa_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Suka yi daro da gammonsa da tagulla daga madubai na mata masu yin aiki a ƙofar Tentin Sujada. ");
INSERT INTO hausa_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Suka kuma yi filin Tentin Sujada. Suka yi labulanta na gefen kudu da lallausan lilin, tsawonsu kamu ɗari, ");
INSERT INTO hausa_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","da sanduna ashirin da rammukan sandunan tagulla ashirin, da kuma ƙugiyoyin azurfa da maɗauri a kan sandunan. ");
INSERT INTO hausa_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Tsawon labule na wajen gefen arewa kamu ɗari ne, yana kuma da sanduna guda ashirin da rammuka ashirin na tagulla, da ƙugiyoyin azurfa da maɗaurai a kan sandunan. ");
INSERT INTO hausa_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Labule na gefen yamma kamu hamsin, da sanduna guda goma, da rammuka guda goma, da ƙugiyoyin azurfa da maɗaurai a kan sandunan. ");
INSERT INTO hausa_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","A ƙarshen gefen gabas, wajen fitowar rana, shi ma fāɗinsa kamu hamsin ne. ");
INSERT INTO hausa_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Labule na gefe ɗaya na ƙofar, kamu goma sha biyar ne, da sanduna guda uku da rammukansu, ");
INSERT INTO hausa_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","akwai labule mai kamu goma sha biyar a ɗayan gefen ƙofar shiga zuwa filin Tentin Sujada, da sanduna uku da rammuka uku. ");
INSERT INTO hausa_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","An yi dukan labulan da suke kewaye da filin Tentin Sujada da lallausan zaren lilin. ");
INSERT INTO hausa_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","An yi rammukan sandunan da tagulla. An dalaye ƙugiyoyi da maɗauran da suke kan sandunan da azurfa; saboda haka dukan sandunan filin Tentin Sujada suna da maɗaurai na azurfa. ");
INSERT INTO hausa_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Aka yi wa labulen ƙofar filin Tentin Sujada ado na ɗinki da na shuɗi, da na shunayya, da na jan zare, da na lallausan lilin, aikin gwaninta. Tsawonsa kamu ashirin, kuma kamar yadda labulen filin Tentin Sujada suke, tsayinsa kamu biyar ne, ");
INSERT INTO hausa_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","da sanduna guda huɗu da rammuka guda huɗu na tagulla. Ƙugiyoyinsu da maɗauransu na azurfa ne, aka kuma dalaye bisansu da azurfa. ");
INSERT INTO hausa_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Aka yi dukan ƙarafan kafa tabanakul da kuma na kewayen filin Tentin Sujada da tagulla ne. ");
INSERT INTO hausa_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Waɗannan su ne kayayyakin da aka yi amfani da su domin aikin tabanakul, da tabanakul na Shaida, waɗanda aka rubuta bisa ga umarnin Musa ta wurin Lawiyawa, a ƙarƙashin jagorancin Itamar ɗan Haruna, firist. ");
INSERT INTO hausa_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","(Bezalel ɗan Uri, ɗan Hur, na kabilar Yahuda, ya yi dukan abin da Ubangiji ya umarci Musa; ");
INSERT INTO hausa_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","tare da shi akwai Oholiyab ɗan Ahisamak, na kabilar Dan, shi gwani ne cikin aikin zāne-zāne, da ɗinki na shuɗi, da na shunayya, da na jan zare, da na lallausan lilin.) ");
INSERT INTO hausa_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Jimillar zinariya daga hadaya ta kaɗawar da aka yi amfani da su domin aikin wuri mai tsarki ta kai talenti 29 da shekel 730, bisa ga ma’aunin shekel na tsattsarkan wuri. ");
INSERT INTO hausa_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Azurfar da aka samu daga ƙidayar taron jama’a, talenti 100 ne, da shekel 1,775, bisa ga ma’aunin shekel na tsattsarkan wuri. ");
INSERT INTO hausa_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Duk mutumin da ya shiga ƙirge daga mai shekaru ashirin zuwa gaba, ya ba da rabin shekel. Mazan da suka shiga ƙirge sun kai mutum 603,550. ");
INSERT INTO hausa_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","An yi amfani da azurfa talenti 100 don yin rammuka na wuri mai tsarki, da kuma rammukan labule, rammuka 100 daga talenti 100, talenti ɗaya don rami ɗaya. ");
INSERT INTO hausa_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Suka yi amfani da shekel 1,775 don yin ƙugiyoyi saboda sanduna, suka dalaye bisan sandunan da maɗauransu. ");
INSERT INTO hausa_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Tagullar da aka bayar daga hadaya ta kaɗawa ya kai talenti 70 da shekel 2,400. ");
INSERT INTO hausa_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Suka yi amfani da shi don yin rammukan ƙofar Tentin Sujada, da bagaden tagulla tare da ragar tagulla da dukan kayayyakinsa, ");
INSERT INTO hausa_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","da rammukan sanduna don kewaye filin, da waɗanda suke ƙofarsa, da dukan ƙarafan kafa tenti don tabanakul, da kuma don kewaye filin. ");
INSERT INTO hausa_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Daga zare mai ruwan shuɗi, da shuɗayya da kuma jan zare suka yi tsarkaken rigunan domin hidima a wuri mai tsarki. Suka kuma yi tsarkaken riguna don Haruna, yadda Ubangiji ya umarci Musa. ");
INSERT INTO hausa_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Suka yi efod na zinariya, da shuɗi, da shunayya, da jan zare, da kuma lallausan lilin. ");
INSERT INTO hausa_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Suka bubbuga zinariya ta zama falle, suka yayyanka ta zare-zare don su yi saƙa da ita, tare da zane na shuɗi, da na shunayya, da na jan zare, da na lallausan lilin, aikin gwani mai fasaha. ");
INSERT INTO hausa_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Suka yi wa efod kafaɗu, sa’an nan suka haɗa su a gefenta biyu na sama, don a iya ɗaurawa. ");
INSERT INTO hausa_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Gwanin mai saƙa ya saƙa abin ɗamarar efod. Da irin kayan da aka saƙa efod ne aka saƙa abin ɗamarar, wato, da zinariya, da shuɗi, da shunayya, da jan zare, da zaren lallausan lilin, yadda Ubangiji ya umarci Musa. ");
INSERT INTO hausa_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Suka shimfiɗa duwatsun onis, suka jera su cikin tsaiko na zinariya, suka kuma zāna sunayen ’ya’yan Isra’ila a kan duwatsun kamar yadda akan yi hatimi. ");
INSERT INTO hausa_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Sa’an nan suka ɗaura su a ƙyallen kafaɗun efod a matsayin duwatsun tuni wa ’ya’yan Isra’ila, yadda Ubangiji ya umarci Musa. ");
INSERT INTO hausa_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Suka yi ƙyallen maƙalawa a ƙirji, aikin gwani. Suka yi shi kamar efod, na zinariya, da na shuɗi, da na shunayya, da na jan zare, da kuma na lallausan lilin. ");
INSERT INTO hausa_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Ƙyallen maƙalawa a ƙirjin murabba’i ne, aka ninka shi biyu, tsawonsa da fāɗinsa kamu ɗaya-ɗaya ne. ");
INSERT INTO hausa_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Sa’an nan suka sa jeri huɗu na duwatsu masu daraja a bisansa. A jeri na farko akwai yakutu, da tofaz, da zumurrudu; ");
INSERT INTO hausa_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","a jeri na biyu akwai turkuwoyis, da saffaya, da daimon; ");
INSERT INTO hausa_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","a jeri na uku akwai yakinta, da idon mage, da ametis; ");
INSERT INTO hausa_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","a jeri na huɗu akwai beril, da onis, da yasfa. Aka sa su cikin tsaiko na zinariya. ");
INSERT INTO hausa_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Aka zāna duwatsu goma sha biyu, ɗaya don kowane sunan ’ya’yan Isra’ila goma sha biyu, kamar yadda akan yi hatimi. ");
INSERT INTO hausa_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Sai suka yi tuƙaƙƙun sarƙoƙi na zinariya zalla a kan ƙyallen maƙalawa a ƙirji. ");
INSERT INTO hausa_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Suka yi tsaiko biyu na zinariya da zoban zinariya biyu, suka kuma ɗaura zoban a kusurwoyi biyu na ƙyallen maƙalawa a ƙirji. ");
INSERT INTO hausa_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Suka ɗaura sarƙoƙi biyu na zinariya da kusurwoyi na ƙyallen maƙalawa a ƙirji. ");
INSERT INTO hausa_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Suka maƙala waɗancan bakin sarƙoƙin zinariya a tsaikon nan biyu, sa’an nan suka rataya su a kafaɗun efod daga gaba. ");
INSERT INTO hausa_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Suka yi zobai biyu na zinariya suka haɗa, suka sa su a gefe biyu na ƙyallen maƙalawa a ƙirji daga ciki kusa da efod. ");
INSERT INTO hausa_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Sa’an nan suka yi waɗansu ƙarin zobai biyu na zinariya, suka maƙale su daga ƙasa a gaban kafaɗu biyu na efod kusa da mahaɗin a bisa abin ɗamarar efod. ");
INSERT INTO hausa_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Suka ɗaura zoban ƙyallen maƙalawa a ƙirjin a zoban efod da shuɗiyar igiya don ƙyallen maƙalawa a ƙirji, ya kwanta lif a bisa kan abin ɗamarar efod don kada yă kunce daga efod, sun yi yadda Ubangiji ya umarci Musa. ");
INSERT INTO hausa_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Suka kuma saƙa taguwa ta efod da shuɗi duka, aikin gwani mai saƙa, ");
INSERT INTO hausa_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","an yi wa taguwar wuyan wundi a tsakiya kamar sulke, aka daje wuyan don kada yă kece. ");
INSERT INTO hausa_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Suka yi fasalin ’ya’yan rumman da shuɗi, da shunayya, da jan zare, da lallausan lilin kewaye da gefe-gefen taguwar. ");
INSERT INTO hausa_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Suka yi ƙararrawa da zinariya zalla, suka sa su a tsakanin fasalin ’ya’yan rumman kewaye da gefe-gefen taguwa. ");
INSERT INTO hausa_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Aka jera ƙararrawan da ’ya’yan rumman bi da bi. Haka aka jera su kewaye da gefe-gefen taguwar aiki, yadda Ubangiji ya umarci Musa. ");
INSERT INTO hausa_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Suka saƙa doguwar riga da lallausan lilin don Haruna da ’ya’yansa, aikin gwani mai saƙa, ");
INSERT INTO hausa_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","suka yi rawanin da lallausan lilin, da hulan lilin da rigunan ciki na lallausan lilin. ");
INSERT INTO hausa_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Suka yi abin ɗamara da lallausan lilin da shuɗi, shunayya da jan zare, aikin gwanin mai ɗinki, yadda Ubangiji ya umarci Musa. ");
INSERT INTO hausa_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Suka yi allo tsattsarka da zinariya tsantsa, suka zāna rubutu irin na hatimi a kansa haka, Mai tsarki ga Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Sa’an nan suka ɗaura shi da shuɗiyar igiya a gaban rawanin, yadda Ubangiji ya umarci Musa. ");
INSERT INTO hausa_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Ta haka aka gama dukan aikin tabanakul da Tentin Sujada. Isra’ilawa suka yi kome yadda Ubangiji ya umarci Musa. ");
INSERT INTO hausa_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Sa’an nan suka kawo wa Musa tabanakul, tentin da dukan kayayyakinsa, ƙugiyoyinsa, katakansa, da sandunansa, da dogayen sandunansa da rammukansa; ");
INSERT INTO hausa_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","murfi na fatun rago wanda aka rina ja, da murfi na fatun shanun teku; da kuma laɓulen ");
INSERT INTO hausa_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","akwatin Alkawari da sandunansa da murfin kafara; ");
INSERT INTO hausa_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","tebur da dukan kayayyakinsa, da burodin Kasancewa; ");
INSERT INTO hausa_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","wurin ajiye fitilu na zinariya zalla, da jerin fitilunsa da dukan kayayyakinsa, da man fitila, ");
INSERT INTO hausa_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","bagade na zinariya, da man shafewa, da turare mai ƙanshi, da labulen ƙofar shiga tenti, ");
INSERT INTO hausa_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","bagade na tagulla na raga, da sandunansa da kayan aikinsa; da daro da wurin ajiyarsa, ");
INSERT INTO hausa_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","labulen filin, sandunansa da rammukansa, labulen ƙofar shiga filin; igiyoyi da ƙarafan kafa filin; dukan kayan aikin tabanakul da Tentin Sujada; ");
INSERT INTO hausa_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","da kuma saƙaƙƙun rigunan da ake sawa don hidima a wuri mai tsarki, duk da tsarkakan riguna na Haruna firist da rigunan ’ya’yansa maza, sa’ad da suke hidima a matsayin firistoci. ");
INSERT INTO hausa_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Isra’ilawa suka yi dukan aikin nan yadda Ubangiji ya umarci Musa. ");
INSERT INTO hausa_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Musa ya duba aikin, sai ya ga cewa sun yi shi daidai yadda Ubangiji ya umarta. Sai Musa ya sa musu albarka. ");
INSERT INTO hausa_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Sa’an nan Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Ka kafa tabanakul, da Tentin Sujada, a kan rana ta fari ga watan fari. ");
INSERT INTO hausa_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Ka sa akwatin Alkawari a cikinsa, sa’an nan ka rufe shi da labule. ");
INSERT INTO hausa_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Ka shigar da teburin ka shirya kayayyakin a kansa. Sa’an nan ka shigar da wurin ajiye fitilan ka kuma sa fitilunsa. ");
INSERT INTO hausa_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Ka sa bagaden zinariya na ƙona turare a gaban akwatin Alkawari, ka kuma sa labule a ƙofar shiga tabanakul. ");
INSERT INTO hausa_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","“Ka ajiye bagade na yin hadaya ta ƙonawa a gaban ƙofar tabanakul, da Tentin Sujada; ");
INSERT INTO hausa_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","ka ajiye daron tsakanin Tentin Sujada da bagaden, ka kuma zuba ruwa a cikinsa. ");
INSERT INTO hausa_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Ka yi fili kewaye da shi, ka kuma sa labule a ƙofar shiga filin. ");
INSERT INTO hausa_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“Ka ɗauki man shafewa ka shafe tabanakul da duka abin da yake cikinsa; ka keɓe shi da dukan kayayyakinsa, zai zama tsarkake. ");
INSERT INTO hausa_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Sa’an nan ka shafe bagaden hadaya ta ƙonawa da kayansa; ka keɓe bagaden, zai zama mai tsarki. ");
INSERT INTO hausa_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Ka shafe daron da wurin ajiyarsa, ka kuma keɓe su. ");
INSERT INTO hausa_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“Ka kawo Haruna da ’ya’yansa a ƙofar Tentin Sujada ka wanke su da ruwa. ");
INSERT INTO hausa_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Sa’an nan ka sa wa Haruna tsarkakun riguna, ka shafe shi, ka kuma keɓe shi don yă yi mini hidima a matsayin firist. ");
INSERT INTO hausa_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Ka kawo ’ya’yansa maza ka sa musu taguwoyi. ");
INSERT INTO hausa_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Ka shafe su yadda ka shafe mahaifinsu, don su yi mini hidima a matsayin firistoci. Shafe musu man, zai sa su zama firistoci na ɗinɗinɗin, dukan zamanansu.” ");
INSERT INTO hausa_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Musa ya aikata dukan kome yadda Ubangiji ya umarce shi. ");
INSERT INTO hausa_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Da haka aka kafa tabanakul, a rana ta fari ga wata na fari a shekara ta biyu. ");
INSERT INTO hausa_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Sa’ad da Musa ya kafa tabanakul, ya sa rammuka a wurinsu, ya sa katakan, ya kuma sa sandunan, ya kakkafa dogayen sandunan. ");
INSERT INTO hausa_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Sa’an nan ya shimfiɗa tentin a bisa tabanakul, ya kuma sa murfi a bisa tentin, yadda Ubangiji ya umarce shi. ");
INSERT INTO hausa_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Ya ɗauki dokokin Alkawari ya sa a cikin akwatin, ya kuma zura sandunan a zoban akwatin, sa’an nan ya sa murfin kafara a bisansa. ");
INSERT INTO hausa_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Sai ya kawo akwatin a cikin tabanakul, ya kuma rataye labulen rufewa ya tsare akwatin Alkawarin, yadda Ubangiji ya umarce shi. ");
INSERT INTO hausa_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Musa ya sa teburin a Tentin Sujada, a gefen arewa na tabanakul waje da labulen. ");
INSERT INTO hausa_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Ya shirya burodin a kai a gaban Ubangiji, yadda Ubangiji ya umarce shi. ");
INSERT INTO hausa_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Ya sa wurin ajiye fitilan a Tentin Sujada ɗaura da teburin a gefen kudu na tabanakul ");
INSERT INTO hausa_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","ya kuma shirya fitilun a gaban Ubangiji, yadda Ubangiji ya umarce shi. ");
INSERT INTO hausa_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Musa ya sa bagaden zinariya a cikin Tentin Sujada a gaban labulen ");
INSERT INTO hausa_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","ya ƙone turare mai ƙanshi a kai, yadda Ubangiji ya umarce shi. ");
INSERT INTO hausa_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Sa’an nan ya sa labule a ƙofar shiga na tabanakul. ");
INSERT INTO hausa_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Ya sa bagaden hadaya ta ƙonawa kusa da ƙofar tabanakul, Tentin Sujada, sa’an nan ya miƙa hadaya ta ƙonawa da hadaya ta gari a kansa, yadda Ubangiji ya umarce shi. ");
INSERT INTO hausa_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Ya sa daro tsakanin Tentin Sujada da bagade, ya kuma zuba ruwa a cikinsa don wanki, ");
INSERT INTO hausa_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","a cikin kuwa Musa da Haruna da ’ya’yansa maza sukan wanke hannunsa da ƙafafunsu. ");
INSERT INTO hausa_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Sukan yi wanka a duk sa’ad da suka shiga Tentin Sujada, ko in suka kusaci bagade, yadda Ubangiji ya umarci Musa. ");
INSERT INTO hausa_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Sa’an nan Musa ya yi fili kewaye da tabanakul da kuma bagaden, ya rataye labule a ƙofar shiga filin. Da haka Musa ya gama aikin. ");
INSERT INTO hausa_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Sa’an nan girgije ya rufe Tentin Sujada sai ɗaukakar Ubangiji ta cika tabanakul. ");
INSERT INTO hausa_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Musa bai iya shiga Tentin Sujada ba domin girgije ya riga ya sauka a kansa, ɗaukakar Ubangiji kuwa ta cika tabanakul. ");
INSERT INTO hausa_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Cikin tafiyar Isra’ilawa duka, sukan kama tafiyarsu ne a duk sa’ad da girgijen ya tashi daga kan tabanakul. ");
INSERT INTO hausa_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Idan girgijen bai tashi ba, ba za su tashi ba, sai a ranar da ya tashi. ");
INSERT INTO hausa_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Gama a cikin tafiyarsu duka, girgijen Ubangiji yana kan tabanakul da rana, da dare kuwa wuta yake cikinsa domin dukan Isra’ilawa su gani.");
INSERT INTO hausa_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Ubangiji ya kira Musa ya yi masa magana daga cikin Tentin Sujada ya ce, ");
INSERT INTO hausa_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“Yi magana da Isra’ilawa ka ce musu, ‘Duk sa’ad da waninku ya kawo hadaya ga Ubangiji, ku kawo hadayarku ta dabba daga garkenku ta shanu ko kuwa daga tumakinku. ");
INSERT INTO hausa_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","“ ‘In hadaya ta ƙonawar daga shanu ne, sai yă miƙa namiji marar lahani. Dole yă kawo shi a ƙofar Tentin Sujada don yă zama yardajje ga Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Zai ɗibiya hannunsa a kan hadaya ta ƙonawar, za a kuwa karɓa a madadinsa don a yi kafara dominsa. ");
INSERT INTO hausa_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Zai yanka ɗan bijimin a gaban Ubangiji, Haruna kuwa da ’ya’yansa maza firist, za su kawo jinin su kuma yafa shi a kan bagaden a kowane gefe a mashigin Tentin Sujada. ");
INSERT INTO hausa_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Zai feɗe hadaya ta ƙonawar, yă yayyanka shi gunduwa-gunduwa. ");
INSERT INTO hausa_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","’Ya’yan Haruna maza waɗanda suke firistoci za su hura wuta a bagade, su kuma shirya itace a kan wutar. ");
INSERT INTO hausa_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Sa’an nan ’ya’yan Haruna maza waɗanda suke firistoci za su shirya gunduwa-gunduwar haɗe da kan da kuma kitsen a kan itace mai cin wuta wanda yake a kan bagaden. ");
INSERT INTO hausa_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Zai wanke kayan cikin da kuma ƙafafun da ruwa, firist ɗin kuwa zai ƙone dukan waɗannan a kan bagade. Hadaya ce ta ƙonawa, hadaya ce kuma wadda aka yi da wuta, mai daɗin ƙanshi ga Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“ ‘In hadaya ta ƙonawar daga garke ne, ko na tumaki, ko na awaki, zai miƙa namiji ne marar lahani. ");
INSERT INTO hausa_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Zai yanka shi a gefen arewa na bagaden a gaban Ubangiji, ’ya’yan Haruna firistoci kuwa za su yayyafa jinin dabbar a bagaden a kowane gefe. ");
INSERT INTO hausa_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Zai yanka shi gunduwa-gunduwa, firist kuwa zai shirya su haɗe da kan, da kuma kitsen a kan itace mai cin wutar da yake a kan bagade. ");
INSERT INTO hausa_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Zai wanke kayan cikin da kuma ƙafafun da ruwa, firist ɗin kuwa zai ƙone dukan waɗannan a kan bagade. Hadaya ce ta ƙonawa, hadaya ce kuma wadda aka yi da wuta, mai daɗin ƙanshi ga Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“ ‘In hadaya ga Ubangiji ɗin, hadaya ta ƙonawa ta tsuntsaye ce, zai miƙa kurciya ko ’yar tattabara. ");
INSERT INTO hausa_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Firist zai kawo ta bagade, yă murɗe wuyan tsuntsun yă ƙone shi a kan bagade; zai tsiyaye jininsa tsuntsun a gefen bagaden. ");
INSERT INTO hausa_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Amma zai ɗauki kayan cikin tsuntsun da gashin yă zubar da su a gefen bagaden a wajen gabas a wurin zuba toka. ");
INSERT INTO hausa_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Zai tsaga shi biyu a tsaka, amma ba zai raba shi ba. Firist ɗin zai ɗibiya shi a bisa itacen da yake bisa bagaden, yă ƙone shi. Hadaya ce ta ƙonawa, hadaya ce kuma wadda aka yi da wuta, mai daɗin ƙanshi ga Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“ ‘Sa’ad da wani ya kawo hadaya ta gari ga Ubangiji, hadayarsa za tă zama gari mai laushi ne. Zai zuba mai a kai, yă sa turare a kansa ");
INSERT INTO hausa_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","yă kai wa ’ya’yan Haruna maza waɗanda suke firistoci. Firist zai ɗiba gari mai laushin a tafin hannu da kuma man, tare da dukan turaren, yă ƙone wannan a sashen tunawa a kan bagade, hadaya ce da aka yi da wuta, mai daɗin ƙanshi ga Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Sauran hadaya ta garin zai zama na Haruna da ’ya’yansa; sashe mafi tsarki ne na hadayar da aka yi ga Ubangiji ta wuta. ");
INSERT INTO hausa_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“ ‘In kuka kawo toyayyen hadayar gari da aka yi daga matoya, zai ƙunshi gari mai laushi, toyayye ba tare da yisti ba, gauraye kuma da mai, ko kuwa ƙosai da aka yi ba tare da yisti ba, aka kuma kwaɓa da mai. ");
INSERT INTO hausa_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","In an toya hadaya ta garinku a kasko, sai a yi shi da gari mai laushi haɗe da mai, ba kuwa da yisti ba. ");
INSERT INTO hausa_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","A gutsuttsura shi, a zuba mai a kansa, hadaya ce ta hatsi. ");
INSERT INTO hausa_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","In hadayarku ta hatsin da aka dafa ne a tukunya, sai a yi shi da gari mai laushi da kuma mai. ");
INSERT INTO hausa_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","A kawo hatsin da aka yi da waɗannan abubuwa ga Ubangiji; a ba wa firist wanda zai ɗauka yă kai bagade. ");
INSERT INTO hausa_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Zai fid da sashen tunawa daga hadaya ta gari, yă ƙone shi a kan bagade kamar hadayar da ka yi da wuta, mai daɗin ƙanshi ga Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Sauran hadaya ta garin za tă zama ta Haruna da ’ya’yansa; sashe mafi tsarki ne na hadayun da aka yi ga Ubangiji ta wuta. ");
INSERT INTO hausa_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“ ‘Kowace hadaya ta garin da kuka kawo ga Ubangiji, dole a yi shi ba tare da yisti ba, gama ba za ku ƙone wani yisti, ko zuma a cikin hadayar da aka yi ga Ubangiji ta wuta ba. ");
INSERT INTO hausa_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Za ku iya kawo su ga Ubangiji kamar hadaya ta ’ya’yan fari, amma ba za a miƙa su a bagade kamar turare mai ƙanshi ba. ");
INSERT INTO hausa_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","A sa gishiri a dukan hadayunku na hatsi. Kada a rasa sa gishirin alkawari na Allahnku a hadayunku na hatsi, a sa gishiri a dukan hadayunku. ");
INSERT INTO hausa_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“ ‘In kuka kawo hadaya ta gari na ’ya’yan fari ga Ubangiji, sai ku miƙa ɓarzajjen kawunan sabon hatsin da aka gasa a wuta. ");
INSERT INTO hausa_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","A sa mai da turare a kansa, hadaya ce ta hatsi. ");
INSERT INTO hausa_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Firist zai ƙone sashe na ɓarzajjen hatsin da kuma mai, tare da turare don tunawa, gama hadaya ce da aka ƙone da wuta ga Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“ ‘In hadayar wani mutum, hadaya ta salama ce, ya kuma miƙa ’yar dabba daga garke, ko namiji ko ta mace ce, sai yă miƙa dabbar da ba ta da lahani a gaban Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Yă kuma ɗibiya hannunsa bisa kan hadayarsa, yă yanka ta a mashigin Tentin Sujada. Sa’an nan ’ya’yan Haruna waɗanda suke firistoci za su yayyafa jinin a kan bagade a kowane gefe. ");
INSERT INTO hausa_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Daga hadaya ta zumuncin da zai kawo, sai a miƙa waɗannan hadayu na ƙonawa ga Ubangiji a wuta; wato, dukan kitsen da ya rufe kayan ciki ko kuwa da sun shafe su, ");
INSERT INTO hausa_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","da ƙodoji biyu tare da kitsen da yake kansu kusa da kwiɓi, da kuma murfin hanta waɗanda zai cire tare da ƙodoji. ");
INSERT INTO hausa_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","’Ya’yan Haruna za su ƙone shi a kan bagade a bisa hadaya ta ƙonawa wadda take a kan itacen da yake cin wuta, kamar hadayar da ka yi da wuta, mai daɗin ƙanshi ga Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“ ‘In ya miƙa dabba ce daga garke a matsayin hadaya ta salama ga Ubangiji, zai miƙa namiji ko ta mace marar lahani. ");
INSERT INTO hausa_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","In ya miƙa ɗan rago ne, zai kawo shi a gaban Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Zai ɗibiya hannu a kan hadayarsa, yă yanka shi a gaban Tentin Sujada. Sa’an nan ’ya’yan Haruna maza za su yayyafa jinin dabbar a kowane gefe na bagade. ");
INSERT INTO hausa_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Daga hadaya ta zumuncin zai kawo, sai a miƙa waɗannan hadayu na ƙonawa ga Ubangiji a wuta, wato, kitsen, ƙibabbiya wutsiyar gaba ɗaya da ya yanka gab da ƙashin gadon baya, dukan kitsen da ya rufe kayan ciki, ko kuwa da suka shafe su, ");
INSERT INTO hausa_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","da ƙodoji biyu tare da kitsen da yake kansu kusa da kwiɓi, da kuma murfin hanta waɗanda zai cire tare da ƙodoji. ");
INSERT INTO hausa_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Firist zai ƙone su a kan bagade kamar hadayar abinci, wato, hadaya ce da aka ƙone da wuta ga Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“ ‘In yana miƙa akuya ce, zai kawo ta a gaban Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","Zai ɗibiya hannunsa a kanta yă kuma yanka ta a gaban Tentin Sujada. Sa’an nan ’ya’yan Haruna maza za su yayyafa jininta a kowane gefe na bagade. ");
INSERT INTO hausa_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Daga abin da zai miƙa sai a miƙa waɗannan hadayu na ƙonawa ga Ubangiji a wuta, wato, dukan kitsen da ya rufe kayan cikin, ko kuwa da suka shafe su, ");
INSERT INTO hausa_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","da ƙodoji biyu tare da kitsen da yake kansu kusa da kwiɓi, da kuma murfin hanta waɗanda zai cire tare da ƙodoji. ");
INSERT INTO hausa_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Firist zai ƙone su a kan bagade kamar abinci, hadaya ce da aka yi da wuta, mai daɗin ƙanshi. Dukan kitsen na Ubangiji ne. ");
INSERT INTO hausa_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","“ ‘Wannan dawwammamiyar farilla ce ga tsararraki masu zuwa, a inda za ku zauna. Ba za ku ci wani kitse ko wani jini ba.’ ” ");
INSERT INTO hausa_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“Faɗa wa Isra’ilawa cewa, ‘Sa’ad da wani ya yi zunubi ba da gangan ba, har ya karya ɗaya daga cikin dokokin Ubangiji, ");
INSERT INTO hausa_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","“ ‘In shafaffen firist ya yi zunubi, ya jawo wa jama’a laifi, dole yă kawo wa Ubangiji ɗan bijimi marar lahani a matsayin hadaya don zunubi saboda zunubin da ya yi. ");
INSERT INTO hausa_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Zai kawo bijimin a ƙofar Tentin Sujada a gaban Ubangiji. Zai ɗibiya hannunsa a kan bijimin, yă kuma yanka shi a gaban Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Sa’an nan shafaffen firist zai ɗiba jinin bijimin yă kai cikin Tentin Sujada. ");
INSERT INTO hausa_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Yă tsoma yatsarsa a cikin jinin, yă kuma yafa sau bakwai a gaban Ubangiji, a gaban labulen wuri mai tsarki. ");
INSERT INTO hausa_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Sa’an nan firist ɗin zai zuba jinin a ƙahonin bagaden turare masu ƙanshi da suke a gaban Ubangiji a Tentin Sujada. Sauran jinin bijimin zai zuba a gindin bagaden hadaya ta ƙonawa a ƙofar zuwa Tentin Sujada. ");
INSERT INTO hausa_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Zai cire dukan kitsen daga bijimin hadaya don zunubi, kitsen da ya rufe kayan cikin, ko kuwa da suka shafe su, ");
INSERT INTO hausa_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","da ƙodoji biyu tare da kitsen da yake kansu kusa da kwiɓi, da kuma murfin hanta, waɗanda zai cire tare da ƙodoji. ");
INSERT INTO hausa_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","Zai cire su daidai kamar yadda akan cire na bijimin hadaya ta salama. Sai firist ɗin yă ƙone su a kan bagaden ƙona hadaya. ");
INSERT INTO hausa_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Amma fatar ɗan bijimin, da namansa, da kansa, da ƙafafunsa, da kayan cikinsa, da hanjinsa, ");
INSERT INTO hausa_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","wato, dukan sauran bijimi, dole yă ɗauke su zuwa waje da sansani zuwa wani wuri mai tsabta inda ake zub da toka, yă ƙone shi a itacen da yake cin wuta a tarin toka. ");
INSERT INTO hausa_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“ ‘In dukan jama’ar Isra’ilawa suka yi zunubi ba da gangan ba, har suka aikata ɗaya daga cikin abubuwan da Ubangiji ya umarta kada a yi, ko da yake jama’ar ba su san batun ba, duk da haka sun yi laifi. ");
INSERT INTO hausa_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Sa’ad da suka gane da zunubin da suka aikata, dole taron su kawo ɗan bijimi a matsayin hadaya don zunubi, su kawo shi a gaban Tentin Sujada. ");
INSERT INTO hausa_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Dattawan jama’a za su ɗibiya hannuwansu a kan bijimin a gaban Ubangiji, sai a yanka bijimin a gaban Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Sa’an nan shafaffen firist zai ɗibi jinin bijimi zuwa cikin Tentin Sujada. ");
INSERT INTO hausa_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Zai tsoma yatsarsa cikin jini yă kuma yayyafa shi a gaban Ubangiji sau bakwai a gaban labule. ");
INSERT INTO hausa_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Zai zuba jinin a ƙahonin bagaden da suke gaban Ubangiji a cikin Tentin Sujada. Zai zuba sauran jinin a gindin bagaden hadaya ta ƙonawa a ƙofar zuwa Tentin Sujada. ");
INSERT INTO hausa_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Zai cire dukan kitsen daga gare shi yă ƙone a kan bagade, ");
INSERT INTO hausa_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","yă kuma yi da wannan bijimi kamar yadda ya yi da bijimi na hadaya don zunubi. Ta haka firist zai yi kafara dominsu, za a kuwa gafarta musu. ");
INSERT INTO hausa_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Sa’an nan zai ɗauki bijimin waje da sansani yă ƙone shi kamar yadda ya ƙone bijimi na fari. Wannan ita ce hadaya don zunubi domin jama’a. ");
INSERT INTO hausa_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“ ‘Sa’ad da shugaba ya yi zunubi ba da gangan ba, har ya aikata ɗaya daga cikin abubuwan da Ubangiji Allahnsa ya umarta, to, ya yi laifi. ");
INSERT INTO hausa_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","Sa’ad da aka sanar da shi game da zunubin da ya yi, dole yă kawo bunsuru marar lahani a matsayin hadayarsa. ");
INSERT INTO hausa_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Zai ɗibiya hannunsa a kan bunsurun yă kuma yanka shi a inda ake yankan hadayar ƙonawa a gaban Ubangiji. Hadaya ce ta zunubi. ");
INSERT INTO hausa_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Sa’an nan firist zai ɗibi jinin hadaya don zunubi da yatsarsa yă sa a ƙahonin bagaden hadayar ƙonawa, yă kuma zuba sauran jinin a gindin bagade. ");
INSERT INTO hausa_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Zai ƙone dukan kitse a kan bagade kamar yadda ya ƙone kitsen hadaya ta salama. Ta haka firist zai yi kafara saboda zunubin mutumin, za a kuwa gafarta masa. ");
INSERT INTO hausa_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“ ‘In wani memba a cikin jama’a ya yi zunubi ba da gangan ba, ya aikata ɗaya daga cikin abubuwan da Ubangiji ya umarta kada a yi, to, ya yi laifi. ");
INSERT INTO hausa_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","Sa’ad da aka sanar da shi game da zunubin da ya yi, dole yă kawo akuya marar lahani a matsayin hadayarsa domin zunubin da ya yi. ");
INSERT INTO hausa_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Zai ɗibiya hannunsa a kan hadaya don zunubin yă kuma yanka ta a inda ake hadaya ta ƙonawa. ");
INSERT INTO hausa_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Sa’an nan firist zai ɗibi jinin da yatsarsa yă zuba a ƙahoni a bagaden hadaya ta ƙonawa, yă kuma zuba sauran jinin a ƙasan bagade. ");
INSERT INTO hausa_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Za a ɗebe kitsenta duka kamar yadda akan ɗebe kitsen hadaya ta salama. Firist zai ƙona shi a kan bagaden don ƙanshi mai daɗi ga Ubangiji. Ta haka firist zai yi kafara dominsa, za a kuwa gafarta masa. ");
INSERT INTO hausa_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“ ‘Idan kuwa daga cikin ’yan tumaki zai ba da hadayarsa, sai ya kawo ’yar tunkiya marar lahani. ");
INSERT INTO hausa_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Zai ɗibiya hannunsa a kanta yă kuma yanka ta hadaya don zunubi a inda ake yankan hadayar ƙonawa. ");
INSERT INTO hausa_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Sa’an nan firist zai ɗibi jinin hadaya don zunubin da yatsarsa yă zuba a ƙahonin bagaden hadayar ƙonawa, yă kuma zuba sauran jinin a gindin bagade. ");
INSERT INTO hausa_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Zai kuma ɗebe kitsenta duka kamar yadda a kan ɗebe na ragon hadaya ta salama. Firist zai ƙone shi a bisa bagaden a bisa hadaya ta ƙonawa ga Ubangiji. Ta haka firist ɗin zai yi kafara dominsa saboda zunubin da ya yi, za a kuwa gafarta masa. ");
INSERT INTO hausa_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“ ‘Mutum zai yi zunubi in bai yi magana ba sa’ad da ya ji ana shelar neman shaida game da wani abin da ya gani ko kuwa ya ji, alhakin zai zauna a wuyansa. ");
INSERT INTO hausa_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","“ ‘Ko kuwa in mutum ya taɓa wani abin da yake mai ƙazanta, ko gawar naman jeji marar tsabta, ko na shanu marar tsabta, ko na halittu marasa tsabtan da suke motsi a ƙasa; ko da yake bai sani ba, ya ƙazantu ke nan, kuma ya yi laifi. ");
INSERT INTO hausa_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Ko kuwa in ya taɓa rashin tsabta na mutane, wani abin da zai sa shi rashin tsabta; ko da yake bai sani ba, sa’ad da ya gane, zai zama mai laifi. ");
INSERT INTO hausa_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Ko kuwa in mutum bai yi tunani ba, ya yi rantsuwar yin wani abu, ko mai kyau ko marar kyau; ko da yake bai sani ba, duk da haka sa’ad da ya gane zai zama mai laifi. ");
INSERT INTO hausa_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Sa’ad da wani yana da laifi a kowanne cikin waɗannan hanyoyi, dole yă furta a hanyar da ya yi zunubin ");
INSERT INTO hausa_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","kuma don zunubin da ya yi, dole yă kawo wa Ubangiji tunkiya ko akuya daga garke kamar hadaya don zunubi; firist kuwa zai yi kafara dominsa da kuma domin zunubinsa. ");
INSERT INTO hausa_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“ ‘In ba zai iya kawo tunkiyar ba, sai yă kawo kurciyoyi biyu ko tattabarai biyu ga Ubangiji a matsayin hakki don zunubinsa, ɗaya domin hadaya don zunubi ɗayan kuma domin hadaya ta ƙonawa. ");
INSERT INTO hausa_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Zai kawo su wa firist, wanda da fari zai miƙa ɗaya domin hadaya don zunubi. Zai murɗe kan daga wuyanta, ba tare da tsinke kan gaba ɗaya ba, ");
INSERT INTO hausa_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","zai kuma yayyafa jinin hadaya don zunubin a gefen bagade; a tsiyaye sauran jinin kuma a gindin bagade. Hadaya ce ta zunubi. ");
INSERT INTO hausa_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Firist zai miƙa ɗayan matsayin hadaya ta ƙonawa bisa ga yadda aka tsara, yă kuma yi kafara dominsa saboda zunubin da ya yi, za a kuwa gafarta masa. ");
INSERT INTO hausa_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“ ‘In ba zai iya kawo kurciyoyi biyu ko tattabarai biyu ba, sai yă kawo humushin garwan gari mai laushi domin hadaya don zunubi. Ba lalle ba ne yă sa mai ko turare a kansa, saboda wannan hadaya ce ta zunubi. ");
INSERT INTO hausa_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Zai kawo wa firist, firist kuwa zai ɗiba da hannu don yă kasance abin tunawa, sai yă ƙone a bisan bagaden kamar hadayar da ake ƙona da wuta ga Ubangiji. Hadaya ce ta zunubi. ");
INSERT INTO hausa_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Ta haka firist zai yi kafara dominsa saboda dukan waɗannan zunuban da ya yi, za a kuwa gafarta masa. Sauran hadayar za tă zama ta firist, kamar yadda yake bisa ga hadaya ta gari.’ ” ");
INSERT INTO hausa_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“Sa’ad da mutum ya ci amana, ya kuma yi zunubi ba da gangan ba dangane da wani cikin abubuwa masu tsarki na Ubangiji, zai kawo ga Ubangiji rago daga garke wanda ba shi da lahani saboda yin hadaya don laifinsa. Za a kimata kuɗinsa bisa ga ma’aunin shekel na tsattsarkan wuri. Hadaya ce ta laifi. ");
INSERT INTO hausa_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Dole yă biya abin da ya kāsa yi dangane da abubuwa masu tsarki, yă ƙara kashi ɗaya bisa biyar na darajar abin a kan wannan sa’an nan yă ba wa firist. Firist kuwa zai yi kafara dominsa da ragon hadaya don laifi. Za a kuwa gafarta masa. ");
INSERT INTO hausa_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“In mutum ya yi zunubi, ya aikata ɗaya daga cikin abubuwan da Ubangiji ya umarta kada a yi, ko da yake bai sani ba, shi mai laifi ne. Za a kuwa nemi hakki daga gare shi. ");
INSERT INTO hausa_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Zai kawo wa firist rago daga garke, marar lahani. Za a kimanta tamanin rago daidai da tamanin hadaya don laifi. Firist kuwa zai yi kafara don kuskuren da mutumin ya yi ba da saninsa ba, za a gafarta masa. ");
INSERT INTO hausa_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Hadaya ce ta laifi, ya yi laifi na abin da ya yi marar kyau ga Ubangiji.” ");
INSERT INTO hausa_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“In wani ya yi zunubi bai kuma yi aminci ga Ubangiji ba, wato, ta wurin yin wa abokin zamansa karya game da ajiyar da abokin ya ba shi amana, ko a kan wani alkawarin da suka yi wa juna, ko kuwa a kan yă cuci abokin, ");
INSERT INTO hausa_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","ko kuma idan ya sami abin da ya ɓace amma ya yi ƙarya cewa bai samu ba. Ko ya yi rantsuwar ƙarya a kan duk irin abubuwan da akan aikata na laifi, ");
INSERT INTO hausa_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","sa’ad da mutum ya yi irin laifin nan, ya kuwa tabbata mai laifi ne, to, sai yă komar da abin da ya ƙwace, ko abin da ya samu ta hanyar zalunci, ko abin da aka ba shi ajiya, ko abin da ya tsinta. ");
INSERT INTO hausa_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","Zai mai da abin da ya yi rantsuwar ƙarya a kai. Zai mayar wa mai abin da abinsa a yadda yake, har yă ƙara kashi ashirin bisa ɗari na abin. A ranar da zai yi hadaya don laifinsa, a ranar ce zai mayar wa mai abin da abinsa. ");
INSERT INTO hausa_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","A matsayin hakki kuwa, dole yă kawo wa firist, wato, ga Ubangiji, hadaya rago marar lahani kuma wanda aka kimanta tamaninsa daga garke don laifinsa. ");
INSERT INTO hausa_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Ta haka firist zai yi kafara dominsa a gaban Ubangiji, za a kuwa gafarta masa irin laifin da ya yi.” ");
INSERT INTO hausa_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“Ka ba Haruna da ’ya’yansa maza wannan umarni, ‘Waɗannan su ne ƙa’idodi don hadaya ta ƙonawa. Hadaya ta ƙonawa za tă kasance a bagade dukan dare, sai da safe, kuma dole a bar wutar tă yi ta ci a bisa bagaden. ");
INSERT INTO hausa_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Sa’an nan firist zai sa rigunarsa ta lilin da kuma rigar lilin da ake sa a ciki, sa’an nan yă kwashe tokan hadaya ta ƙonawa da wuta da ta ci a kan bagaden, yă sa kusa da bagaden. ");
INSERT INTO hausa_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Sa’an nan yă tuɓe waɗannan rigunan yă sa waɗansu, sa’an nan yă ɗauki tokar yă kai waje da sansani zuwa inda yake da tsabta. ");
INSERT INTO hausa_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Dole a bar wutar da take bisa bagaden tă yi ta ci; kada tă mutu. Kowace safiya firist zai ƙara itacen wuta, yă shirya hadaya ta ƙonawa a bisa wutar yă kuma ƙone kitsen hadaya ta salama a kansa. ");
INSERT INTO hausa_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Dole a bar wutar tă ci gaba da ci a bisa bagade; kada tă mutu. ");
INSERT INTO hausa_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“ ‘Waɗannan su ne ƙa’idodi domin hadaya ta gari. ’Ya’yan Haruna za su kawo ta a gaban Ubangiji, a gaban bagaden. ");
INSERT INTO hausa_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Firist zai ɗiba garin hadayar mai laushin wanda aka zuba masa mai da kuma turare cike da tafin hannu. Zai ƙona wannan a bisa bagaden, hadaya ce mai daɗin ƙanshi ga Ubangiji don tunawa. ");
INSERT INTO hausa_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Haruna da ’ya’yansa maza za su ci sauran, amma za a ci shi ba tare da yisti ba a tsattsarkan wuri; za su ci shi a harabar Tentin Sujada. ");
INSERT INTO hausa_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Ba za a toya shi da yisti ba; na ba su yă zama rabonsu daga cikin hadayun da ake ƙonawa da wuta, abu ne mafi tsarki, kamar hadaya don zunubi da laifi. ");
INSERT INTO hausa_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Kowane ɗa namiji cikin zuriyar Haruna zai iya cinsa. Wannan rabonsa ne na kullum na hadayar da aka yi ga Ubangiji da wuta. Wannan madawwamiyar doka ce cikin zamananku duka. Duk abin da ya taɓa hadayun zai tsarkaka.’ ” ");
INSERT INTO hausa_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Ubangiji ya kuma ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“Wannan ne hadayar da Haruna da ’ya’yansa maza za su kawo ga Ubangiji a ranar da za a naɗa su firistoci, humushin garwan gari mai laushi a matsayin hadaya ta gari na kullum, rabinsa da safe, rabinsa kuma da yamma. ");
INSERT INTO hausa_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","A shirya shi da mai a kwanon tuya, a kawo shi kwaɓaɓɓe sosai, a miƙa shi hadaya ta gari dunƙule-dunƙule don ƙanshi mai daɗi ga Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Duk wanda aka naɗa daga ’ya’yan Haruna yă zama firist a madadinsa, shi ne zai miƙa wannan hadayar ga Ubangiji. Zai ƙone hadayar ƙurmus. Wannan za tă zama dawwammamiyar farilla ce har abada. ");
INSERT INTO hausa_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Kowace hadaya ta gari ta firist, za a ƙone ta ƙurmus, ba za a ci ba.” ");
INSERT INTO hausa_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“Faɗa wa Haruna da ’ya’yansa maza, ‘Waɗannan su ne ƙa’idodi domin hadaya don zunubi. Za a yanka hadaya don zunubi a gaban Ubangiji a inda ake yankan hadaya ta ƙonawa; dole tă kasance mai tsarki. ");
INSERT INTO hausa_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Firist da ya miƙa ta zai ci, za a ci ta a tsattsarkan wuri, a harabar Tentin Sujada. ");
INSERT INTO hausa_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Duk abin da ya taɓa wani sashe na naman, zai zama da tsarki, kuma in wani jini ya ɗiga a riga, dole ka wanke shi a tsattsarkan wuri. ");
INSERT INTO hausa_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Dole a farfashe tukunyar lakar da aka dafa naman a ciki; amma in an dafa a tukunyar tagulla, sai a kankare tukunyar, a kuma ɗauraye da ruwa. ");
INSERT INTO hausa_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Kowane namiji a iyalin firistoci zai iya ci; gama abu ne mafi tsarki. ");
INSERT INTO hausa_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Amma duk wata hadaya don zunubi wadda aka kawo jininta cikin Tentin Sujada don a yi kafara a Wuri Mai Tsarki, ba za a ci ba. A maimako haka za a ƙone ta ɗungum. ");
INSERT INTO hausa_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“ ‘Waɗannan su ne ƙa’idodi na hadaya don laifi, hadaya ce tsattsarka. ");
INSERT INTO hausa_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Za a yanka hadaya don laifi a inda ake yanka hadaya ta ƙonawa, za a kuma yayyafa jinin a kowane gefe na bagade. ");
INSERT INTO hausa_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Za a miƙa kitsen abin hadaya duka, da wutsiya mai kitse, da kitsen da yake rufe da kayan ciki, ");
INSERT INTO hausa_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","da ƙodoji biyu da kitsen da yake a bisansu kusa da kwiɓi, da kuma rufin hanta, wanda za a cire tare da ƙodoji. ");
INSERT INTO hausa_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Firist zai ƙone su a kan bagade, hadaya ce da aka ƙone da wuta ga Ubangiji. Hadaya ce don laifi. ");
INSERT INTO hausa_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Kowane da namiji cikin iyalin firistoci zai iya ci. Sai a tsattsarkan wuri ne za a ci; gama abu mafi tsarki ne. ");
INSERT INTO hausa_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","“ ‘Hadaya don laifi kamar hadaya don zunubi take, saboda haka ƙa’ida hanyar yinsu iri ɗaya ce. Su ɗin na firist da ya yi kafara da su ne. ");
INSERT INTO hausa_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Firist da ya miƙa hadaya ta ƙonawa domin wani, zai iya ajiye fatar wa kansa. ");
INSERT INTO hausa_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Kowace hadaya ta garin da aka toya a tanda, ko aka dafa a tukunya ko a kan kaskon tuya, na firist da ya miƙa ta ne, ");
INSERT INTO hausa_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","kuma kowace hadaya ta gari wadda aka kwaɓa da mai, ko wadda ba a kwaɓa ba, ita ma, ta dukan ’ya’ya Haruna ne maza. ");
INSERT INTO hausa_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“ ‘Waɗannan su ne ƙa’idodin hadaya don zumuncin da mutum zai iya miƙa ga Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","“ ‘In ya miƙa hadayar a matsayin hadaya ta godiya ce, to, zai miƙa ta tare da burodi mai kauri marar yisti, wanda aka kwaɓa da mai, da burodi marar kauri, wanda aka shafa wa mai, da kuma burodi mai kauri da aka yi da gari mai laushi wanda aka kwaɓa sosai da mai. ");
INSERT INTO hausa_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Tare da hadayarsa don zumunci ta godiya, zai miƙa dunƙulen burodin da aka yi da yisti. ");
INSERT INTO hausa_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Zai kuma kawo ɗaya daga kowace a matsayin hadaya, baiko ne ga Ubangiji. Wannan zai zama na firist da ya yafa jinin hadaya ta salama ne. ");
INSERT INTO hausa_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Za a ci wannan nama na hadaya don zumunci ta godiya a ranar da aka miƙa ta, kada yă bar wani abu daga naman yă kwana. ");
INSERT INTO hausa_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","“ ‘In hadayarsa cika wa’adin rantsuwa ce ko kuwa ta yardar rai ce, sai a ci hadayar a ranar da ya miƙa ta, amma za a iya cin duk abin da ya rage kashegari. ");
INSERT INTO hausa_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Duk naman hadayar da ya rage har kwana uku, dole a ƙone shi. ");
INSERT INTO hausa_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Idan aka ci naman hadayarsa ta salama a rana ta uku, ba za a karɓi wanda ya ba da hadayar har ya sami albarkar hadayar ba, naman zai zama abin ƙyama, duk wanda ya ci kuwa ya yi laifi. ");
INSERT INTO hausa_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“ ‘Ba za a ci naman da ya taɓa wani abu marar tsarki ba; dole a ƙone shi. Game da sauran nama, kowa da yake mai tsarki zai iya ci. ");
INSERT INTO hausa_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Amma in wani wanda ba shi da tsarki ya ci naman hadaya ta salama ga Ubangiji, za a fid da mutumin daga cikin mutanensa. ");
INSERT INTO hausa_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Idan wani mutum ya taɓa abu marar tsarki, ko mutum ne, ko dabba ce, ko wani abu na banƙyama, ya kuma ci naman hadaya ta salama ga Ubangiji, za a fid da mutumin daga cikin mutanensa.’ ” ");
INSERT INTO hausa_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“Ka faɗa wa Isra’ilawa, ‘Kada ku ci wani kitsen shanu, ko na tumaki, ko kuwa na awaki. ");
INSERT INTO hausa_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Za a iya yin wani amfani da kitsen dabbar da ta mutu mushe, ko kitsen dabbar da namun jeji su yayyaga, amma kada a kuskura a ci. ");
INSERT INTO hausa_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Duk wanda ya ci kitsen dabbar da aka miƙa ta wuta ga Ubangiji, za a fid da shi daga mutanensa. ");
INSERT INTO hausa_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Kuma duk inda kuke zama, ba za ku ci jinin wani tsuntsu ko na dabba ba. ");
INSERT INTO hausa_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Duk wanda ya ci jini, za a fid da mutumin daga mutanensa.’ ” ");
INSERT INTO hausa_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“Faɗa wa Isra’ilawa, ‘Duk wanda ya kawo hadaya ta salama ga Ubangiji, sai ya kawo hadayarsa ga Ubangiji daga cikin hadayu na salama. ");
INSERT INTO hausa_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Da hannuwansa zai kawo hadayar da za a ƙona ga Ubangiji; zai kawo kitsen tare da ƙirjin, yă kuma kaɗa ƙirjin a gaban Ubangiji a matsayin hadaya ta kaɗawa. ");
INSERT INTO hausa_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Firist zai ƙone kitsen a bisa bagade, amma ƙirjin zai zama na Haruna da ’ya’yansa maza. ");
INSERT INTO hausa_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Za ku ba da cinya ta dama ta hadaya don zumuncinku ga firist a matsayin baiko. ");
INSERT INTO hausa_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Ɗan Haruna da ya miƙa jini da kitsen hadaya ta salama, zai ɗauki cinyar tă zama rabonsa. ");
INSERT INTO hausa_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Daga hadaya ta salama ta Isra’ilawa, na ɗauki ƙirjin da aka kaɗa da kuma cinyar da aka miƙa, na ba da su ga Haruna firist da kuma ’ya’yansa maza a matsayin rabonsu na kullum daga Isra’ilawa.’ ” ");
INSERT INTO hausa_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Wannan shi ne sashen hadayar da aka ba wa Haruna da ’ya’yansa maza, hadayar da aka yi ga Ubangiji da wuta, tun ranar da aka gabatar da su don su yi wa Ubangiji hidima a matsayin firist. ");
INSERT INTO hausa_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","A ranar da aka keɓe su, Ubangiji ya umarta cewa Isra’ilawa su ba da wannan a gare su a matsayin rabonsu na kullum, a dukan tsararraki masu zuwa. ");
INSERT INTO hausa_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Waɗannan su ne ƙa’idodi don hadaya ta ƙonawa, hadaya ta gari, hadaya don zunubi, hadaya don laifi, hadaya ta naɗi da kuma hadaya ta salama, ");
INSERT INTO hausa_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","waɗanda Ubangiji ya ba wa Musa a Dutsen Sinai, a Hamadar Sinai, a ranar da ya umarci Isra’ilawa su kawo hadayunsu ga Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Kawo Haruna da ’ya’yansa maza, ka ɗauki rigunansu, man keɓewa, bijimi domin hadaya don zunubi, ’yan raguna biyu da kuma kwandon da yake da burodi marar yisti, ");
INSERT INTO hausa_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","ka kuma tara dukan jama’a a ƙofar Tentin Sujada.” ");
INSERT INTO hausa_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Sai Musa ya yi yadda Ubangiji ya umarce shi, jama’a kuwa suka taru a ƙofar Tentin Sujada. ");
INSERT INTO hausa_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Sai Musa ya ce wa jama’ar, “Ga abin da Ubangiji ya umarta a yi.” ");
INSERT INTO hausa_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Sa’an nan Musa ya kawo Haruna da ’ya’yansa maza gaba, ya kuma wanke su da ruwa. ");
INSERT INTO hausa_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Ya sa wa Haruna taguwa, ya ɗaura igiya kewaye da shi, ya sa masa riga, ya sa masa efod. Ya kuma ɗaura masa efod wanda aka yi masa saƙar gwaninta. ");
INSERT INTO hausa_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Ya sa masa ƙyallen maƙalawa a ƙirji, ya kuma sa Urim da Tummim a ƙyallen maƙalawa a ƙirjin. ");
INSERT INTO hausa_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Sai ya naɗa masa rawani, daga gaban rawanin ya sa allon zinariya, wato, kambi tsattsarka, kamar yadda Ubangiji ya umarce shi. ");
INSERT INTO hausa_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Sa’an nan Musa ya ɗauki man keɓewa ya keɓe tabanakul da kuma kowane abin da yake cikinsa, ta haka ya tsarkake su. ");
INSERT INTO hausa_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Ya yayyafa mai a kan bagade sau bakwai, yana keɓe bagade da dukan kayayyaki, da daro, da abin da yake tsaya a kai, don yă tsarkake su. ");
INSERT INTO hausa_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Ya zuba man keɓewa a kan Haruna, ya kuma keɓe shi don yă tsarkake shi. ");
INSERT INTO hausa_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Sa’an nan ya kawo ’ya’yan Haruna maza, ya sa musu taguwoyi, ya ɗaɗɗaura igiyoyi kewaye da su, ya kuma sa musu huluna yadda Ubangiji ya umarce shi. ");
INSERT INTO hausa_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Sa’an nan ya miƙa bijimi domin hadaya don zunubi, sai Haruna da ’ya’yansa suka ɗibiya hannuwansu a bijimin. ");
INSERT INTO hausa_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Musa ya yanka bijimin ya ɗauki jinin, ya sa yatsarsa ya zuba a dukan ƙahonin bagade don yă tsarkake bagaden. Ya zuba sauran jinin a gindin bagade. Ta haka ya tsarkake shi don yă yi kafara dominsa. ");
INSERT INTO hausa_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Musa ya ɗebo dukan kitsen da yake kewaye da kayan ciki, da kuma wanda ya rufe hanta, da ƙodojin, da kuma kitsensu, ya kuma ƙone su a kan bagade. ");
INSERT INTO hausa_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Amma bijimin da fatarsa da namansa da kuma ƙashinsa ya ƙone su a bayan sansani, yadda Ubangiji ya umarce shi. ");
INSERT INTO hausa_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Sa’an nan ya miƙa ɗan rago domin hadaya ta ƙonawa, sai Haruna da ’ya’yansa maza suka ɗibiya hannuwansu a kan ɗan rago. ");
INSERT INTO hausa_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Sa’an nan Musa ya yanka ɗan ragon, ya kuma yayyafa jinin a kowane gefe na bagaden. ");
INSERT INTO hausa_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Ya yanka ragon gunduwa-gunduwa ya ƙone kan, ya kuma ƙone gunduwa-gunduwan da kitsen. ");
INSERT INTO hausa_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Ya wanke kayan cikin da ƙafafun a ruwa, ya kuma ƙone dukan ragon a bisa bagade kamar hadaya ta ƙonawa, mai daɗin ƙanshi, hadaya ce da aka ƙone da wuta ga Ubangiji, yadda Ubangiji ya umarce shi. ");
INSERT INTO hausa_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Sai ya miƙa ɗayan ɗan ragon, ɗan ragon naɗin, sai Haruna da ’ya’yansa maza suka ɗibiya hannuwansu a kan ɗan ragon. ");
INSERT INTO hausa_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Musa kuwa ya yanka ɗan ragon ya ɗibi jinin ya sa leɓatun kunnen dama na Haruna, ya kuma sa a babbar yatsarsa ta hannun dama da kuma a babbar yatsar ƙafarsa ta dama. ");
INSERT INTO hausa_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Musa ya kuma kawo ’ya’yan Haruna gaba, ya sa jini a leɓatun kunnuwansu na dama, ya kuma sa a manyan yatsotsinsu na hannun dama da kuma a manyan yatsotsinsu na ƙafafunsu na dama. Sa’an nan ya yayyafa jinin a kowane gefen bagade. ");
INSERT INTO hausa_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Ya ɗibi kitsen, da wutsiya mai kitse, da kuma dukan kitsen da ke kewaye da kayan ciki, da wanda ya rufe hanta, ƙodoji biyu da kitsensu da kuma cinya ta dama. ");
INSERT INTO hausa_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Sa’an nan daga cikin kwandon burodi marar yisti wanda yake a gaban Ubangiji, ya ɗauko dunƙulen burodi, da kuma guda da aka yi da mai, da kuma ƙosai; ya sa waɗannan a sassan kitsen, da kuma a cinya ta dama. ");
INSERT INTO hausa_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Ya sa waɗannan a hannuwan Haruna da ’ya’yansa, suka kuma kaɗa su a gaban Ubangiji a matsayin hadaya ta kaɗawa. ");
INSERT INTO hausa_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Sa’an nan Musa ya karɓe su daga hannuwansu ya ƙone a bagade a bisa hadaya ta ƙonawa a matsayin hadaya ta naɗi, mai daɗin ƙanshi, hadaya ce da aka ƙone da wuta ga Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Ya kuma ɗauki ƙirjin; rabon Musa na ɗan ragon naɗi, ya kaɗa shi a gaban Ubangiji, a matsayin hadaya ta kaɗawa, yadda Ubangiji ya umarce shi. ");
INSERT INTO hausa_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Sai Musa ya ɗibi man keɓewa da jini daga bagade, ya yayyafa su a kan Haruna da rigunansa, da kuma a kan ’ya’yansa da rigunansu, don yă tsarkake Haruna da rigunansa da kuma ’ya’yansa da rigunansu. ");
INSERT INTO hausa_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Sai Musa ya ce wa Haruna da ’ya’yansa maza, “Ku dafa naman a ƙofar Tentin Sujada, ku kuma ci shi a can tare da burodi daga kwandon naɗi, yadda na umarta, cewa, ‘Haruna da ’ya’yansa maza za su ci shi.’ ");
INSERT INTO hausa_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Sa’an nan ku ƙone sauran naman da kuma burodin. ");
INSERT INTO hausa_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Kada ku bar ƙofar Tentin Sujada har kwana bakwai, sai ranakun naɗi suka cika, gama naɗinku zai ɗauki kwana bakwai. ");
INSERT INTO hausa_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Abin da aka yi a yau umarni ne daga Ubangiji don yin kafara saboda ku. ");
INSERT INTO hausa_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Dole ku kasance a ƙofar Tentin Sujada dare da rana har kwana bakwai, ku kuma yi abin da Ubangiji yake bukata, don kada ku mutu; gama abin da aka umarce ni ke nan.” ");
INSERT INTO hausa_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Saboda haka Haruna da ’ya’yansa maza suka yi kome da Ubangiji ya umarta ta wurin Musa. ");
INSERT INTO hausa_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","A rana ta takwas, Musa ya kira Haruna da ’ya’yansa maza da kuma dattawan Isra’ila. ");
INSERT INTO hausa_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Ya ce wa Haruna, “Ka ɗauki ɗan maraƙi domin hadayarka don zunubi da kuma ɗan rago domin hadaya ta ƙonawa, dukan biyu su kasance marar lahani, ka miƙa su a gaban Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Sa’an nan ka ce wa Isra’ilawa, ‘Ku ɗauki bunsuru na yin hadaya don zunubi, da ɗan maraƙi bana ɗaya, da ɗan rago bana ɗaya marasa lahani, don hadaya ta ƙonawa, ");
INSERT INTO hausa_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","da bijimi da rago don hadayun salama, a yi hadaya da su ga Ubangiji, da hadaya ta gari da aka kwaɓa da mai, gama yau Ubangiji zai bayyana a gare ku.’ ” ");
INSERT INTO hausa_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Suka ɗauki abubuwan da Musa ya umarta zuwa gaban Tentin Sujada, sai dukan jama’a suka zo kusa suka tsaya a gaban Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Sa’an nan Musa ya ce, “Ga abin da Ubangiji ya umarce ku ku yi, domin ɗaukakar Ubangiji za tă bayyana gare ku.” ");
INSERT INTO hausa_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Musa ya ce wa Haruna, “Matsa kusa da bagaden, ka miƙa hadayarka don zunubi, da hadayarka ta ƙonawa, ka yi kafara don kanka da kuma don jama’a. Ka kuma kawo hadayar jama’a, ka yi kafara dominsu kamar yadda Ubangiji ya umarta.” ");
INSERT INTO hausa_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Sai Haruna ya matsa kusa da bagaden, ya yanka ɗan maraƙi na yin hadaya don zunubi saboda kansa. ");
INSERT INTO hausa_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","’Ya’yan Haruna maza suka kawo masa jinin, ya kuma tsoma yatsarsa a cikin jinin ya zuba cikin ƙahonin bagade; sauran jinin kuwa ya zuba a gindin bagaden. ");
INSERT INTO hausa_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","A kan bagaden, ya ƙone kitsen, ƙodojin, da abin da ya rufe hanta, daga hadaya don zunubi, yadda Ubangiji ya umarci Musa. ");
INSERT INTO hausa_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Naman da fatar kuwa ya ƙone waje da sansanin. ");
INSERT INTO hausa_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Sa’an nan ya yanka hadaya ta ƙonawa. ’Ya’yan Haruna maza suka miƙa masa jinin, ya kuwa yayyafa shi a kowane gefe na bagaden. ");
INSERT INTO hausa_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Suka miƙa masa hadaya ta ƙonawa gunduwa-gunduwa, haɗe da kan, ya kuwa ƙone su a bisa bagaden. ");
INSERT INTO hausa_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Sai ya wanke kayan ciki da ƙafafun, ya kuwa ƙone su tare da hadaya ta ƙonawa a kan bagade. ");
INSERT INTO hausa_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Sa’an nan Haruna ya kawo hadayar da take domin mutane. Ya ɗauki akuya ta hadaya don zunubin mutane, ya yanka shi, ya miƙa shi domin hadaya don zunubi kamar yadda ya yi da na farko. ");
INSERT INTO hausa_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Ya kawo hadaya ta ƙonawa ya kuma miƙa ta yadda aka tsara. ");
INSERT INTO hausa_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Ya kuma kawo hadaya ta gari, ya ɗiba a tafi hannu ya ƙone a kan bagade tare da hadaya ta ƙonawa ta safe. ");
INSERT INTO hausa_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Haruna ya yanka maraƙin da ragon a matsayin hadaya ta salama domin mutane. ’Ya’yansa maza suka miƙa masa jinin, ya kuwa yayyafa shi a kowane gefe na bagade. ");
INSERT INTO hausa_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Amma sashen kitsen maraƙin da na ragon, da wutsiya mai kitse, da kitsen da yake rufe da kayan ciki, da ƙodoji da kuma kitsen da ya rufe hanta, ");
INSERT INTO hausa_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","suka shimfiɗa waɗannan a kan ƙirjin, sa’an nan Haruna ya ƙone kitsen a kan bagade. ");
INSERT INTO hausa_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Sai Haruna ya kaɗa ƙirjin da kuma cinyar dama a gaban Ubangiji a matsayin hadaya ta kaɗawa, kamar yadda Musa ya umarta. ");
INSERT INTO hausa_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Sa’an nan Haruna ya ɗaga hannuwansa wajen mutane ya sa musu albarka. Da yake ya miƙa hadaya don zunubi, hadaya ta ƙonawa da kuma hadaya ta salama, sai ya sauka. ");
INSERT INTO hausa_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Sai Musa da Haruna suka shiga cikin Tentin Sujada. Da suka fita, sai suka sa wa mutane albarka; sai ɗaukakar Ubangiji ta bayyana ga dukan mutane. ");
INSERT INTO hausa_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Sai wuta ta fito daga gaban Ubangiji ta cinye hadaya ta ƙonawa da sassan kitsen a kan bagaden. Sa’ad da dukan mutane suka ga haka, sai suka yi ihu suna farin ciki, suka fāɗi rubda ciki, suka yi sujada. ");
INSERT INTO hausa_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","’Ya’yan Haruna maza, Nadab da Abihu suka ɗauki farantansu, suka sa wuta a ciki, suka zuba turare a kai; suka kuma miƙa haramtacciyar wuta a gaban Ubangiji, ba irin wadda Ubangiji ya umarta ba. ");
INSERT INTO hausa_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Sai wuta ta fito daga Ubangiji ta cinye su, suka kuma mutu a gaban Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Sai Musa ya ce Haruna, “Ga abin da Ubangiji yake nufi sa’ad da ya ce, “ ‘A cikin waɗanda suka kusace ni za a tabbata ni mai tsarki ne; a fuskar dukan mutane za a kuwa girmama ni.’ ” Haruna ya yi shiru. ");
INSERT INTO hausa_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Sai Musa ya kira Mishayel da Elzafan, ’ya’yan Uzziyel kawun Haruna, ya ce musu, “Ku zo nan; ku ɗauki ’yan’uwanku waje da sansani, daga gaban wuri mai tsarki.” ");
INSERT INTO hausa_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Sai suka zo suka ɗauke su, suna nan cikin taguwoyinsu, zuwa waje da sansani yadda Musa ya umarta. ");
INSERT INTO hausa_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Sa’an nan Musa ya ce wa Haruna da Eleyazar da Itamar ’ya’yansa maza, “Kada ku bar gashin kanku barkatai, kada kuma ku yage tufafinku, don kada ku mutu. Yin haka zai jawo fushin Ubangiji a kan dukan jama’a. Amma dangoginku, wato, dukan Isra’ilawa, suna iya kuka saboda waɗanda Ubangiji ya hallaka da wuta. ");
INSERT INTO hausa_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Kada ku bar ƙofar Tentin Sujada ko kuwa ku mutu, domin man Shafan Ubangiji yana kanku.” Saboda haka suka yi kamar yadda Musa ya faɗa. ");
INSERT INTO hausa_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Sa’an nan Ubangiji ya yi magana da Haruna ya ce, ");
INSERT INTO hausa_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“Kai da ’ya’yanka maza, ba za ku sha ruwan inabi ko wani abu mai sa jiri ba a duk sa’ad da za ku shiga cikin Tentin Sujada, in ba haka ba za ku mutu. Wannan dawwammamiyar farilla ce wa tsararraki masu zuwa. ");
INSERT INTO hausa_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Dole ku bambanta tsakanin mai tsarki da marar tsarki, tsakanin marar tsabta da mai tsabta, ");
INSERT INTO hausa_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","za ku kuma koyar da Isra’ilawa dukan farillan da Ubangiji ya ba su ta wurin Musa.” ");
INSERT INTO hausa_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Musa ya ce wa Haruna da Eleyazar da Itamar ’ya’yansa maza da suka ragu, “Ku ɗauki ragowar hadaya ta gari wadda aka yi hadaya ta ƙonawa da ita ga Ubangiji ku ci ba tare da yisti ba, a gefen bagaden, gama tsattsarka ne. ");
INSERT INTO hausa_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Ku ci shi a tsattsarkan wuri, gama rabonka ne da na ’ya’yanka daga cikin hadayun da akan ƙone da wuta ga Ubangiji; gama haka aka umarce ni. ");
INSERT INTO hausa_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Amma kai da ’ya’yanka maza da mata za su iya ci ƙirjin da aka kaɗa, da kuma cinyar da aka miƙa. Ku ci su a wuri mai tsabta; an ba da su gare ku da kuma ’ya’yanku a matsayin rabo daga hadaya ta salama ta Isra’ilawa. ");
INSERT INTO hausa_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Cinyar da aka miƙa da kuma ƙirjin da aka kaɗa, dole a kawo su tare da ɓangarori kitsen hadayun da aka yi ta wuri wuta, don a kaɗa a gaban Ubangiji a matsayin hadaya ta kaɗawa. Wannan zai zama na kullayaumi gare ka da ’ya’yanka, yadda Ubangiji ya umarta.” ");
INSERT INTO hausa_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Sa’ad da Musa ya nemi sani game da akuyar hadaya don zunubi, ya kuwa gane cewa an ƙone shi, sai ya yi fushi da Eleyazar da kuma Itamar, ’ya’yan Haruna maza da suka ragu, ya kuma yi tambaya, ");
INSERT INTO hausa_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“Me ya sa ba ku ci hadaya don zunubi a cikin wuri mai tsarki ba? Mafi tsaki ne; an ba ku ne don a ɗauke laifin jama’a ta wurin yin kafara saboda su a gaban Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Da yake ba a kai jininsa cikin wuri mai tsarki ba, ya kamata ku ci akuyar a wuri mai tsarki, kamar yadda na umarta.” ");
INSERT INTO hausa_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Sai Haruna ya amsa wa Musa, “Yau sun miƙa hadayarsu don zunubi da kuma hadayarsu ta ƙonawa a gaban Ubangiji, ga kuma irin waɗannan abubuwa da suka same ni, da a ce na ci hadaya don zunubi yau, da zai yi kyau ke nan a gaban Ubangiji?” ");
INSERT INTO hausa_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Da Musa ya ji haka, sai ya gamsu. ");
INSERT INTO hausa_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Ubangiji ya ce wa Musa da Haruna, ");
INSERT INTO hausa_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“Ku ce wa Isra’ilawa, ‘Cikin dabbobin da suke a doron ƙasa, waɗannan ne za ku ci. ");
INSERT INTO hausa_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Za ku iya cin dabbobin da suke da rababben kofato, waɗanda suke kuma tuƙa. ");
INSERT INTO hausa_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","“ ‘Akwai waɗanda suke tuƙa ko kuwa suna da rababben kofato kawai, duk da haka ba za ku ci su ba. Waɗannan kuwa su ne, raƙumi, ko da yake yana tuƙa, amma ba shi da rababben kofato; saboda haka cin namansa haram ne gare ku. ");
INSERT INTO hausa_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Rema, ko da yake tana tuƙa, duk da haka ba ta da rababben kofato; saboda haka namanta haram ne gare ku. ");
INSERT INTO hausa_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Zomo, ko da yake yana tuƙa, duk da haka ba shi da rababben kofato; saboda haka namansa haram ne gare ku. ");
INSERT INTO hausa_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Alade, ko da yake yana da rababben kofato, amma ba ya tuƙa, saboda haka namansa haram ne gare ku. ");
INSERT INTO hausa_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Ba za ku ci namansu ba, ko ku taɓa gawawwakinsu, gama haram ne gare ku. ");
INSERT INTO hausa_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“ ‘Cikin dukan halittu masu rai da suke a cikin ruwan tekuna da rafuffuka, za ku iya cin kowane da yake da ƙege da kamɓori. ");
INSERT INTO hausa_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Amma kowace halittar da take cikin tekuna da koguna da ba ta da ƙege da kamɓori, ko cikin dukan abubuwa masu rai a ruwa ko kuma sauran halittu a cikin ruwa za ku ɗauka su marasa tsaki ne gare ku. ");
INSERT INTO hausa_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Da yake abubuwan ƙyama ne a gare ku, ba za ku ci namansu ba, kuma dole ku yi ƙyamar gawawwakinsu. ");
INSERT INTO hausa_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Duk abin da yake a ruwa amma ba shi da ƙege ko kamɓori, za ku yi ƙyamarsa. ");
INSERT INTO hausa_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“ ‘Waɗannan su ne tsuntsayen da za ku yi ƙyamarsu, ba za ku ci su ba domin sun zama abin ƙyama. Tsuntsayen kuwa su ne, gaggafa, ungulu, baƙin ungulu, ");
INSERT INTO hausa_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","shirwa, da duk wani irin baƙin shirwa, ");
INSERT INTO hausa_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","kowane irin hankaka, ");
INSERT INTO hausa_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","mujiya mai ƙaho, jimina, shaho, da kowane irin shaho, ");
INSERT INTO hausa_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","ƙaramin ƙururu, babba da jaka, zalɓe, ");
INSERT INTO hausa_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","kazar ruwa, kwasakwasa, da ungulu, ");
INSERT INTO hausa_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","shamuwa, kowane irin jinjimi, katutu da kuma jamage. ");
INSERT INTO hausa_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“ ‘Dukan ƙwarin da suke da fikafikai masu tafiya da ƙafafu huɗu abin ƙyama ne gare ku. ");
INSERT INTO hausa_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Sai dai akwai ƙwarin da suke da fikafikai masu tafiya da ƙafafu huɗu da za ku ci; waɗanda suke da cinyoyin da suke sa su iya tsalle. ");
INSERT INTO hausa_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Za ku iya cin kowane irin fāra, gyare, ƙwanso da danginsu. ");
INSERT INTO hausa_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Amma sauran ƙananan ƙwari duka masu fikafikai, suna kuma jan ciki, abin ƙyama ne a gare ku. ");
INSERT INTO hausa_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","“ ‘Duk wanda ya taɓa mushen waɗannan dabbobi, zai ƙazantu har fāɗuwar rana. ");
INSERT INTO hausa_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Duk wanda ya ɗauki ɗaya daga cikin gawawwakinsu dole yă wanke rigunansa, zai kuma ƙazantu har zuwa yamma. ");
INSERT INTO hausa_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","“ ‘Kowace dabbar da ba ta da rababben kofato ko ba ta tuƙa, haram ce gare ku; duk wanda ya taɓa gawarsu zai ƙazantu. ");
INSERT INTO hausa_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Duk abin da yake tafiya a kan dāginsa cikin dabbobin da suke da ƙafa huɗu, haram ne a gare ku. Duk wanda ya taɓa mushensu zai ƙazantu har zuwa yamma. ");
INSERT INTO hausa_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Duk wanda ya ɗauki gawawwakinsu dole yă wanke rigunansa, zai kuma ƙazantu har yamma. Waɗannan dabbobi za su zama marasa tsabta a gare ku. ");
INSERT INTO hausa_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“ ‘Waɗannan ƙananan dabbobi da suke rarrafe a ƙasa, haram ne a gare ku, wato, murɗiya, da ɓera, da gafiya da irinsa, ");
INSERT INTO hausa_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","da tsaka, da hawainiya, da ƙadangare, da guza, da damo. ");
INSERT INTO hausa_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Dukan waɗanda suke rarrafe, za su zama marasa tsarki gare ku. Duk wanda ya taɓa su sa’ad da suka mutu, zai zama ƙazantacce har zuwa yamma. ");
INSERT INTO hausa_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Duk abin da mushensu ya fāɗa a kai, zai ƙazantu. Ko a kan itace ne, ko a bisa tufafi, ko a fata, ko a buhu, ko cikin kowane irin abu da ake amfani da shi, to, tilas a sa shi cikin ruwa, zai zama ƙazantacce har zuwa yamma, sa’an nan zai tsarkaka. ");
INSERT INTO hausa_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","In waninsu ya fāɗi a cikin tukunyar laka, kome da yake a tukunyar zai ƙazantu, kuma dole a fashe tukunyar. ");
INSERT INTO hausa_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Duk abincin da aka yarda a ci, wanda ya taɓa ruwa daga irin tukunyan nan zai zama marar tsabta, kuma duk ruwan da za a sha daga irin tukunyan nan ƙazantacce ne. ");
INSERT INTO hausa_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Kowane irin abu da mushensu ya fāɗa a kai ya ƙazantu ke nan; ko a kan murhu, ko a tukunyar dahuwa, dole a farfashe su. Su haramtattu ne kuma dole ku ɗauke su haramtattu. ");
INSERT INTO hausa_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Maɓuɓɓuga ko tafki na tarin ruwa zai ci gaba da zauna mai tsabta, amma duk wanda ya taɓa ɗaya daga cikin waɗannan gawawwakin ya haramtu. ");
INSERT INTO hausa_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","In gawa ta fāɗi a irin da za a shuka, irin zai ci gaba da zama mai tsabta. ");
INSERT INTO hausa_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Amma in an sa ruwa a irin sai kuma gawar ta fāɗi a kai, to, irin ya zama haram gare ku. ");
INSERT INTO hausa_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“ ‘In dabbar aka yarda a ci ta mutu, duk wanda ya taɓa gawarta zai ƙazantu har yamma. ");
INSERT INTO hausa_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Duk wanda ya ci wani sashe na gawar dole yă wanke rigunansa, kuma zai ƙazantu har yamma. Duk wanda ya ɗauki gawar dole yă wanke rigunansa, zai kuwa ƙazantu har yamma. ");
INSERT INTO hausa_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“ ‘Duk dabba mai rarrafe a ƙasa abin ƙyama ne; ba kuwa za a ci shi ba. ");
INSERT INTO hausa_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Ba za ku ci wani halittar da take rarrafe a ƙasa, ko tana jan ciki, ko tana tafiya a kan ƙafafu huɗu, ko a kan ƙafafu da yawa ba; abin ƙyama ne. ");
INSERT INTO hausa_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Kada ku ƙazantar da kanku ta wurin wani daga waɗannan halittu. Kada ku ƙazantar da kanku ta dalilinsu, ko a mai da ku haramtattu ta wurinsu. ");
INSERT INTO hausa_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Ni ne Ubangiji Allahnku; ku tsarkake kanku ku kuma zama da tsarki, domin Ni mai tsarki ne. Kada ku ƙazantar da kanku ta wurin wani halittar da take rarrafe a ƙasa. ");
INSERT INTO hausa_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Ni ne Ubangiji wanda ya fitar da ku daga Masar don in zama Allahnku; saboda haka ku zama da tsarki, domin Ni mai tsarki ne. ");
INSERT INTO hausa_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","“ ‘Waɗannan ne ƙa’idodi game da dabbobi, tsuntsaye, da kowane abu mai rai da yake motsi a cikin ruwa, da kowace halitta mai rarrafe a ƙasa. ");
INSERT INTO hausa_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Dole ku bambanta tsakanin haramtacce da halaltacce, tsakanin halittu masu ran da za a iya ci da waɗanda ba za a iya ci ba.’ ” ");
INSERT INTO hausa_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“Faɗa wa Isra’ilawa, ‘Macen da ta yi ciki ta kuma haihu ɗa namiji za tă ƙazantu kwana bakwai, kamar yadda takan ƙazantu a lokacin al’adarta. ");
INSERT INTO hausa_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","A rana ta takwas, za a yi wa yaron kaciya. ");
INSERT INTO hausa_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Sa’an nan dole macen ta jira kwana talatin don a tsabtacce ta daga zub da jini. Ba za tă taɓa wani abu mai tsarki, ko ta je wuri mai tsarki ba sai kwanakin tsabtaccewarta sun cika. ");
INSERT INTO hausa_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","In ta haifi ’ya ta mace ce, makoni biyu macen za tă ƙazantu kamar yadda takan kasance a lokacin al’adarta. Sa’an nan dole tă jira kwana sittin don a tsabtacce ta daga zub da jininta. ");
INSERT INTO hausa_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“ ‘Sa’ad da kwanakin tsabtaccewarta don ɗa namiji ko ’ya ta mace suka cika, sai ta kawo ɗan rago bana ɗaya wa firist a bakin ƙofar Tentin Sujada don hadaya ta ƙonawa da tattabara ko kurciya na hadaya don zunubi. ");
INSERT INTO hausa_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Firist zai miƙa su a gaban Ubangiji don yă yi kafara dominta, sa’an nan tă tsabtacce daga zub da jininta. “ ‘Waɗannan su ne ƙa’idodi domin macen da ta haifi ɗa namiji ko ’ya ta mace. ");
INSERT INTO hausa_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","In ba za tă iya kawo ɗan rago ba, sai ta kawo kurciyoyi biyu ko tattabarai biyu, ɗaya domin hadaya ta ƙonawa ɗayan kuma domin hadaya don zunubi. Ta haka firist zai yi kafara dominta, za tă kuwa zama tsabtacciya.’ ” ");
INSERT INTO hausa_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Ubangiji ya ce wa Musa da Haruna, ");
INSERT INTO hausa_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“Sa’ad da wani yana da kumburi, ko ɓamɓaroki, ko tabo a fatar jikinsa da zai iya zama cutar fatar jiki, dole a kawo shi ga Haruna firist, ko kuwa ga ɗaya a cikin ’ya’yansa maza wanda yake firist. ");
INSERT INTO hausa_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Firist zai bincika mikin da yake a fatar mai cutar, in gashin a mikin ya juya ya zama fari, mikin kuma ya zama kamar ya fi zurfin fatar jiki, wannan cutar kuturta ce. Sa’ad da firist ya bincike shi, zai furta shi marar tsarki. ");
INSERT INTO hausa_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","In tabon a fata jikinsa fari ne amma bai zama ya fi zurfin fatar jikin ba, gashin a cikinsa kuma bai juya ya zama fari ba, firist ɗin zai kaɗaice mai cutar na kwana bakwai. ");
INSERT INTO hausa_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","A rana ta bakwai firist zai bincike shi, in kuwa ya ga cewa mikin bai canja ba, bai kuwa yaɗu a fatar jikin ba, zai kaɗaice shi na waɗansu ƙarin kwana bakwai. ");
INSERT INTO hausa_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","A rana ta bakwai ɗin firist zai sāke bincike shi, in kuwa mikin ya bushe bai kuwa yaɗu a fatar jikin ba, firist ɗin zai furta shi mai tsarki; ƙurji ne kawai. Dole mutumin yă wanke rigunansa, zai kuma tsarkaka. ");
INSERT INTO hausa_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Amma in ƙurjin ya yaɗu a fatar jikinsa bayan ya nuna kansa ga firist don a furta shi tsarkake, dole yă sāke bayyana a gaban firist. ");
INSERT INTO hausa_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Firist ɗin zai bincike shi, in ƙurjin ya yaɗu a fatar jikinsa, zai furta shi marar tsarki; cuta ce mai yaɗuwa. ");
INSERT INTO hausa_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“Sa’ad da wani yana da cutar fatar jiki, dole a kawo shi ga firist. ");
INSERT INTO hausa_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Firist zai bincike shi, in kuwa farin kumburi a fatar jikin ya juyar da gashin fari in kuma akwai sabon miki a kumburi, ");
INSERT INTO hausa_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","to, cutar fatar jikin ne mai ƙarfi kuma firist zai furta shi marar tsarki. Ba zai kaɗaice shi ba, domin ya riga ya zama marar tsarki. ");
INSERT INTO hausa_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","“In cutar ta fashe ko’ina a fatar jiki, har iyakar ganin firist, ta rufe dukan fatar jikin mai fama da cutar, daga kai har zuwa ƙafa, ");
INSERT INTO hausa_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","firist zai bincike shi, in cutar ta riga ta rufe dukan jikinsa, zai furta wannan mutum tsarkakakke ne. Da yake ya juya fari fat, tsarkakakke ne. ");
INSERT INTO hausa_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Amma sa’ad da sabon miki ya bayyana a jikinsa, zai furta shi marar tsarki. ");
INSERT INTO hausa_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Sa’ad da firist ɗin ya ga sabon miki, zai furta shi marar tsarki. Sabon mikin marar tsarki, yana da cuta mai yaɗuwa. ");
INSERT INTO hausa_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","A ce sabon mikin ya canja ya juya fari, dole yă je wurin firist. ");
INSERT INTO hausa_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Firist zai bincike shi, in kuma mikin ya juya ya zama fari, firist zai furta mai cutar tsarkakakke; to, zai zama tsarkakakke. ");
INSERT INTO hausa_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“Sa’ad da wani yana da kumburi a fatar jikinsa ya kuma warke, ");
INSERT INTO hausa_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","kuma a inda ƙurjin yake, wani farin kumburi ko tabo ja-ja, fari-fari ya bayyana, dole yă gabatar da kansa ga firist. ");
INSERT INTO hausa_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Firist zai bincike shi, in kuma ya zama ya fi fatar jiki zurfi kuma gashinsa ya juya ya zama fari, firist ɗin zai furta shi marar tsarki. Cuta ce mai yaɗuwa da ta fasu a inda ƙurjin yake. ");
INSERT INTO hausa_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Amma in sa’ad da firist ya bincike shi, ya tarar babu farin gashi a ciki, kuma bai yi zurfi fiye da fatar jikin ba, ya kuma bushe, sai firist ɗin ya kaɗaice shi har kwana bakwai. ");
INSERT INTO hausa_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","In yana yaɗuwa a cikin fatar jikin, firist zai furta shi marar tsarki; cuta mai yaɗuwa ce. ");
INSERT INTO hausa_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Amma in tabon bai canja ba, bai kuma yaɗu ba, tabo ne kawai daga ƙurji, kuma firist zai furta shi tsarkakakke. ");
INSERT INTO hausa_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“Sa’ad da wani yana da ƙuna a fatar jikinsa, wurin kuwa ya yi ja-ja, ko fari-fari, ko kuwa farin tabo ya bayyana a sabon miki na ƙunan, ");
INSERT INTO hausa_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","firist zai bincike tabon, idan kuma gashin a cikinsa ya juya ya zama fari, kuma ya yi zurfi fiye da fatar jikin, cuta ce mai yaɗuwa da ta fasu daga ƙunan. Firist zai furta shi marar tsarki; cuta ce mai yaɗuwa. ");
INSERT INTO hausa_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Amma in firist ɗin ya bincike shi bai kuwa ga wani farin gashi a wurin ba, in kuma bai yi zurfi fiye da fatar jikin ba, ya kuma bushe, to, firist ɗin zai kaɗaice shi na kwana bakwai. ");
INSERT INTO hausa_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","A rana ta bakwai ɗin firist zai bincike shi, in kuma cutar tana yaɗuwa a cikin fatar jikin, firist ɗin zai furta shi marar tsarki, cutar fatar jiki ce mai yaɗuwa. ");
INSERT INTO hausa_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","In kuma wurin bai canja ba, bai kuma yaɗu cikin fatar jikin ba amma ya bushe, kumburi ne daga ƙuna, firist ɗin kuwa zai furta shi tsarkakakke; tabo ne kawai daga ƙuna. ");
INSERT INTO hausa_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“In namiji ko ta mace tana da miki a kai ko kuwa a gemu, ");
INSERT INTO hausa_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","firist zai bincike mikin, in ya yi zurfi fiye da fatar jiki, gashin ya zama rawaya, ya kuma zama siriri, firist zai furta wannan mutum marar tsarki; ƙaiƙayi ne, cuta mai yaɗuwa ce na kai ko na gemu. ");
INSERT INTO hausa_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Amma in, sa’ad da firist ya bincika wannan irin mikin, bai yi zurfi fiye da fatar jiki ba kuma babu baƙin gashi a cikinsa, firist ɗin zai kaɗaice mutum mai fama da cutar, kwana bakwai. ");
INSERT INTO hausa_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","A rana ta bakwai ɗin firist zai bincika mikin in kuwa ƙaiƙayin bai bazu ba, ba rawayan gashi kuma a ciki, babu zurfin da yake fiye da fatar jiki, ");
INSERT INTO hausa_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","dole a yi masa aski, sai dai ba zai aske wurin cutar ba, kuma firist zai kaɗaice shi kwana bakwai. ");
INSERT INTO hausa_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","A rana ta bakwai firist zai bincike ƙaiƙayin, idan bai bazu a fatar jikin ba, bai kuma yi zurfin fiye da fatar jikin ba, firist ɗin zai furta shi tsarkakakke. Dole kuma yă wanke rigunansa, zai kuwa zama tsarkakakke. ");
INSERT INTO hausa_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Amma in ƙaiƙayin ya yaɗu a cikin fatar jikin bayan aka furta shi tsarkakakke, ");
INSERT INTO hausa_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","firist ɗin zai bincike shi, in kuma ƙaiƙayin ya yaɗu a fatar jikin, firist ɗin ba ya bukatar neman ganin rawayan gashi; mutumin marar tsarki ne. ");
INSERT INTO hausa_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","In fa a ganinsa bai canja ba kuma baƙin gashi ya fito a cikinsa, ƙaiƙayin ya warke ke nan. Mutumin tsarkakakke ne, firist ɗin kuwa zai furta shi tsarkakakke. ");
INSERT INTO hausa_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“Sa’ad da namiji ko ta mace tana da farare wurare a fatar jiki, ");
INSERT INTO hausa_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","firist ya bincika su, in kuma wuraren toka-toka ne, to, ƙurji marar lahani ne ya faso a fatar jikin; wannan mutum tsarkakakke. ");
INSERT INTO hausa_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“Mutumin da ya rasa gashi kansa ya zama mai sanƙo ke nan, duk da haka mutumin tsattsarka ne. ");
INSERT INTO hausa_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","In ya rasa gashin goshinsa yana kuma da sanƙo a goshinsa, shi tsarkakakke ne. ");
INSERT INTO hausa_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Amma in yana da miki ja-ja da ya yi fari a sanƙonsa ko a goshinsa, cuta mai yaɗuwa ce take fasuwa a kai ko a goshin. ");
INSERT INTO hausa_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Sai firist ya bincike shi, in kuma kumburarren miki a kansa ko goshinsa ja-ja da fari-fari kamar cutar fatar jiki mai yaɗuwa ne, ");
INSERT INTO hausa_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","mutumin ya kamu da cutar kuma marar tsarki ne. Firist ɗin zai furta mutumin marar tsarki saboda mikin da yake a kansa. ");
INSERT INTO hausa_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“Mutum mai wannan cuta mai yaɗuwa dole yă sa yagaggun riguna, yă kuma bar gashin kansa ba gyara, yă rufe sashe ƙasa na fuskarsa, sa’an nan yă riga cewa, ‘Marar tsarki! Marar tsarki!’ ");
INSERT INTO hausa_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Muddin yana da cutar zai ci gaba da kasance marar tsarki. Dole yă yi zama shi kaɗai; dole yă yi zama waje da sansani. ");
INSERT INTO hausa_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“In akwai cutar fatar jiki a riguna, duk wani rigar ulu ko na lilin, ");
INSERT INTO hausa_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","duk wani kayan zare, ko saƙa na lilin, ko ulu, duk wani kayan fata, ko wanda aka yi da fata, ");
INSERT INTO hausa_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","in kuma cutar a cikin rigar, ko fatar, ko kayan saƙan kore-kore ne, ko ja-ja, to, cutar fatar jiki da ake samu a riguna ce mai yaɗuwa, kuma dole a nuna wa firist. ");
INSERT INTO hausa_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Firist ɗin zai bincike cutar fatar jikin da take a rigar, yă kuma kaɗaice kayan da abin ya shafe shi kwana bakwai. ");
INSERT INTO hausa_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","A rana ta bakwai ɗin zai bincike shi, in cutar rigar ta yaɗu, ko a tariyar zaren, ko a wadarin, ko a fatar, ko kuwa a duk abin da ake amfani da shi, to wannan muguwar cutar riga ce; kayan marar tsarki ne. ");
INSERT INTO hausa_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Dole yă ƙone rigar, ko tariyar zaren, ko kayan da aka saƙa na ulu ko lilin, ko kuwa na kaya da aka yi da fatar, wanda cutar ta fāɗa wa, domin cutar rigar muguwa ce, dole a ƙone kayan. ");
INSERT INTO hausa_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“Amma in sa’ad da firist ya bincike shi, cutar rigar ba ta yaɗu a rigar, ko a tariyar zare, ko a kayan da aka saƙa, ko a kayan da aka yi da fata ba, ");
INSERT INTO hausa_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","zai umarta cewa a wanke kayan da cutar ta shafa. Sa’an nan zai kaɗaice shi na waɗansu kwana bakwai. ");
INSERT INTO hausa_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Bayan an wanke kayan da cutar ta shafa, firist zai bincike shi, in kuwa cutar rigar ba tă canja yadda take ba, ko da yake ba tă yaɗu ba, marar tsarki ce. ");
INSERT INTO hausa_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","In sa’ad da firist ya bincike shi, cutar rigar ta bushe bayan da aka wanke kayan, sai yă yage sashen da cutar ta shafa na rigar, ko fatar, ko tariyar zaren, ko kuwa na kayan da aka saƙa. ");
INSERT INTO hausa_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Amma in ya sāke bayyana a rigar, ko a tariyar zaren, ko a kayan da aka saƙa, ko a kayan da aka yi da fatar, to, yana yaɗuwa ke nan, kuma dole a ƙone duk abin da yake da cutar rigar da wuta. ");
INSERT INTO hausa_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Rigar, ko tariyar zare, ko kayan da aka saƙa, ko kuwa duk kayan da aka yi da fatar da aka wanke, aka kuma fid da cutar rigar, dole a sāke wanke shi, zai kuwa zama tsarkakakke.” ");
INSERT INTO hausa_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Waɗannan su ne ƙa’idodi game da cutar fatar jiki na rigar ulu, ko rigar lilin, tariyar zare, ko kayan da aka saƙa, ko kuwa duk wani abin da aka yi da fata, don furta su tsarkakakke, ko kuwa marar tsarki. ");
INSERT INTO hausa_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“Waɗannan su ne ƙa’idodi domin mutumin da yake da cuta a lokacin tsabtaccewarsa, sa’ad da aka kawo shi ga firist. ");
INSERT INTO hausa_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Firist zai fita waje da sansani ya bincike shi. In mutumin ya warke daga cutar fatar jiki mai yaɗuwa, ");
INSERT INTO hausa_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","firist zai umarta a kawo tsuntsaye biyu masu rai, masu tsabta da itacen al’ul, jan ƙyalle da kuma hizzob saboda mutumin da za a tsabtacce. ");
INSERT INTO hausa_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Sa’an nan firist zai umarta a kashe ɗaya daga cikin tsuntsayen a bisa ruwa mai kyau a tukunyar laka. ");
INSERT INTO hausa_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Zai ɗauki tsuntsu mai rai ya tsoma shi tare da itacen al’ul, jan ƙyalle da kuma hizzob cikin jinin tsuntsun da aka yanka a bisa ruwa mai kyau. ");
INSERT INTO hausa_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Sau bakwai zai yayyafa wa mutumin da za a tsabtacce daga cutar mai yaɗuwa ya kuma furta shi tsarkakakke. Sa’an nan ya saki tsuntsu mai rai ɗin ya tafi. ");
INSERT INTO hausa_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","“Dole mutumin da aka tsabtaccen ya wanke rigunansa, ya aske dukan gashinsa ya kuma yi wanka; sa’an nan zai tsabtacce. Bayan wannan zai iya zo cikin sansani, amma dole yă tsaya waje da tentinsa kwana bakwai. ");
INSERT INTO hausa_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","A rana ta bakwai ɗin dole yă aske dukan gashinsa; dole yă aske kansa, gemunsa, gashin girarsa da sauran gashinsa. Dole yă wanke rigunansa ya kuma yi wanka, zai kuwa tsabtacce. ");
INSERT INTO hausa_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“A rana ta takwas dole yă kawo ɗan rago da ’yar tunkiya bana ɗaya, kowane marar lahani, tare da rabin garwan gari mai laushi haɗe da mai domin hadaya ta gari, da kuma moɗa ɗaya na mai. ");
INSERT INTO hausa_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Firist da ya furta shi tsarkakakke zai miƙa da wanda za a tsabtaccen da kuma hadayunsa a gaban Ubangiji a ƙofar Tentin Sujada. ");
INSERT INTO hausa_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","“Sa’ad da firist zai ɗauki ɗaya daga cikin ragunan ya kuma miƙa shi kamar hadaya don laifi, tare da moɗan mai; zai kaɗa su a gaban Ubangiji kamar hadaya kaɗawa. ");
INSERT INTO hausa_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Zai yanka ɗan ragon a tsattsarkan wuri inda ake yanka hadaya don zunubi da hadaya ta ƙonawa. Gama yadda hadaya ta zunubi ta firist ne, haka hadaya domin laifi ma, hadaya ce mafi tsarki. ");
INSERT INTO hausa_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Firist ɗin zai ɗiba jinin hadaya don laifin ya zuba a leɓatun kunnen dama na wanda za a tsabtacce, a babbar yatsar hannunsa na dama a kuma a babbar yatsar ƙafa damansa. ");
INSERT INTO hausa_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Firist ɗin zai ɗiba daga moɗan mai ɗin ya zuba a tafin hannunsa na hagu, ");
INSERT INTO hausa_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","ya tsoma yatsarsa ta dama cikin man da yake a tafin hannunsa, kuma da yatsar zai yayyafa man a gaban Ubangiji sau bakwai. ");
INSERT INTO hausa_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Firist zai sa sauran mai da yake cikin tafinsa a leɓatun kunnen dama na wanda za a tsabtacce, a babbar yatsarsa na dama da kuma a babbar yatsar ƙafarsa ta dama, a bisa jinin hadaya don laifin. ");
INSERT INTO hausa_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Sauran man a tafin hannunsa firist zai sa a kan wanda za a tsabtaccen ya kuma yi kafara dominsa a gaban Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","“Sa’an nan firist ɗin zai miƙa hadaya don zunubi ya kuma yi kafara saboda wannan da za a tsabtacce daga rashin tsarkinsa. Bayan haka, firist zai yanka hadaya ta ƙonawa ");
INSERT INTO hausa_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","ya miƙa ta a bagade, tare da hadaya ta gari, ya kuma yi kafara dominsa, zai kuwa tsabtacce. ");
INSERT INTO hausa_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“In kuwa mutumin matalauci ne ba zai iya samu waɗannan ba, to, dole yă ɗauki ɗan rago guda kamar hadaya don laifi a kaɗa don a yi kafara dominsa, tare da humushin garwa gari mai laushi haɗe da mai don hadaya ta gari, da moɗa na mai, ");
INSERT INTO hausa_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","da kurciyoyi biyu ko tattabarai biyu, wanda zai iya samu, ɗaya domin hadaya don zunubi ɗayan kuma domin hadaya ta ƙonawa. ");
INSERT INTO hausa_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","“A rana ta takwas dole yă kawo su domin tsabtaccewarsa ga firist a ƙofar Tentin Sujada, a gaban Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Firist zai ɗauki ɗan rago na hadaya don laifi tare da moɗa na mai, ya kaɗa su a gaban Ubangiji kamar hadaya ta kaɗawa. ");
INSERT INTO hausa_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Zai yanka ɗan rago domin hadaya don laifi ya kuma ɗibi jinin ya sa a leɓatun kunnen dama na wanda za a tsabtaccen, a babban yatsar hannun damansa da kuma a babban yatsar ƙafarsa na dama. ");
INSERT INTO hausa_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Firist zai zuba man a tafin hannunsa na hagu, ");
INSERT INTO hausa_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","da yatsarsa na dama zai yayyafa man daga tafinsa sau bakwai a gaban Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Daga cikin man da yake a tafinsa zai zuba a wuri da ya zuba jinin hadaya don laifi, a leɓatun kunnen dama na wanda za a tsabtaccen, a babban yatsar hannun damansa da kuma a babban yatsar ƙafa damansa. ");
INSERT INTO hausa_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Sauran man da yake cikin tafinsa firist ɗin zai zuba a kan wannan da za a tsabtaccen don a yi kafara dominsa a gaban Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Sa’an nan zai miƙa kurciyoyi ko tattabarai, waɗanda mutumin zai iya, ");
INSERT INTO hausa_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","ɗaya kamar hadaya don zunubi ɗayan kuma kamar hadaya ta ƙonawa, tare da hadaya ta gari. Ta haka firist zai yi kafara a gaban Ubangiji a madadin wanda za a tsabtacce.” ");
INSERT INTO hausa_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Waɗannan su ne ƙa’idodi domin mutumin da yake da cutar fatar jiki wanda kuma ba zai iya samun abubuwan hadaya ta kullum domin tsabtaccewarsa ba. ");
INSERT INTO hausa_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Ubangiji ya ce wa Musa da Haruna, ");
INSERT INTO hausa_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“Sa’ad da kuka shiga ƙasar Kan’ana, wadda nake ba ku kamar gādonku, na kuma sa yaɗuwa cutar fatar jiki a riga a cikin gida a wannan ƙasa, ");
INSERT INTO hausa_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","dole maigidan ya tafi ya faɗa wa firist ya ce, ‘Na ga wani abu da ya yi kamar cutar fatar jikin da take a riga a cikin gidana.’ ");
INSERT INTO hausa_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Firist zai umarci a fitar da kome a gidan kafin ya shiga ya bincike cutar fatar jiki da take a rigar, saboda babu abin da yake gidan da za a furta marar tsarki ne. Bayan haka firist zai shiga ya dudduba gidan. ");
INSERT INTO hausa_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Zai bincike cutar fatar jiki da take a riga a bangaye, in kuma yana da tabon kore-kore ko ja-ja da suka bayyana da suka yi zurfi fiye da saman bangon, ");
INSERT INTO hausa_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","firist ɗin zai fita a bakin ƙofar gidan ya rufe ta na kwana bakwai. ");
INSERT INTO hausa_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","A rana ta bakwai ɗin firist zai dawo don yă dudduba gidan. In cutar fatar jiki da take a riga ta yaɗu a bangayen, ");
INSERT INTO hausa_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","zai umarta a ciccire duwatsun da suke da cutar a zubar a wuri marar tsarki waje da birnin. ");
INSERT INTO hausa_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Dole yă sa a kankare duka shafen bangon cikin gidan a kuma zuba kayan da aka kankare a wurin marar tsarki waje da birnin. ");
INSERT INTO hausa_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Sai su ɗebi waɗansu duwatsu su sa a wuraren da suka ciccire waɗancan, su kuma ɗiba sabon laka su yi shafen gidan. ");
INSERT INTO hausa_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“In cutar fatar jiki da take ta rigar ta sāke bayyana a gidan bayan an ciccire duwatsu aka kankare gidan aka kuma yi shafe, ");
INSERT INTO hausa_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","firist zai je ya bincika shi, in kuwa cutar ta bazu a gidan, to, muguwar cuta ce; gidan marar tsarki ne. ");
INSERT INTO hausa_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Dole a rushe gidan, a fid da duwatsun, katakai da kuma dukan shafen daga birnin zuwa wuri marar tsarki. ");
INSERT INTO hausa_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","“Duk wanda ya shiga gidan yayinda aka rufe shi zai ƙazantu har yamma. ");
INSERT INTO hausa_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Duk wanda ya kwana ko ya ci abinci a gidan dole yă wanke rigunansa. ");
INSERT INTO hausa_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“Amma in firist ya zo ya bincika gidan kuma cutar fatar jiki da take ta rigar ba tă bazu ba bayan an yi wa gidan shafe, zai furta gidan tsarkakakke, domin cutar ta tafi. ");
INSERT INTO hausa_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Don a tsabtacce gidan, zai ɗauki tsuntsaye biyu da itacen al’ul, jan ƙyalle da hizzob. ");
INSERT INTO hausa_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Zai yanka ɗaya daga cikin tsuntsayen a bisa ruwa mai kyau a cikin tukunyar laka. ");
INSERT INTO hausa_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Sa’an nan zai ɗauki itacen al’ul, hizzob, jan ƙyalle da kuma tsuntsu mai ran ya tsoma su cikin jinin tsuntsun da aka yanka da kuma cikin ruwa mai kyau, ya yayyafa wa gida sau bakwai. ");
INSERT INTO hausa_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Zai tsabtacce gidan da jinin tsuntsun, ruwa mai kyau, tsuntsu mai ran, itacen al’ul, hizzob da kuma jan ƙyalle. ");
INSERT INTO hausa_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Sa’an nan zai saki tsuntsu mai rai ɗin a fili waje da birnin ya tafi. Ta haka zai yi kafara saboda gidan, gidan kuwa zai zama tsarkakakke.” ");
INSERT INTO hausa_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Waɗannan su ne ƙa’idodi saboda duk wani cuta mai yaɗuwa, don ƙaiƙayi, ");
INSERT INTO hausa_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","don cutar fatar jiki da take a riga ko a cikin gida, ");
INSERT INTO hausa_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","da kuma don kumburi, ɓamɓaroki ko tabo, ");
INSERT INTO hausa_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","don a tabbatar sa’ad da wani abu mai tsarki da marar tsarki. Waɗannan su ne ƙa’idodi domin cutar fatar jiki mai yaɗuwa da cutar fatar jikin da take a riga. ");
INSERT INTO hausa_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Ubangiji ya ce wa Musa da Haruna, ");
INSERT INTO hausa_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“Yi wa Isra’ilawa magana, ku ce musu, ‘Duk sa’ad da wani namiji yake ɗiga daga azzakarinsa, wannan ɗiga marar tsarki ne. ");
INSERT INTO hausa_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Ko ɗigar ta ci gaba da fitowa daga azzakarinsa ko an tsere ta, za tă sa mutumin yă zama marar tsarki. Ga yadda ɗigarsa za tă kawo ƙazantuwa, ");
INSERT INTO hausa_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","“ ‘Duk gadon da mutumin mai ɗigar ya kwanta a kai, zai zama marar tsarki, kuma duk abin da ya zauna a kai, zai zama marar tsarki. ");
INSERT INTO hausa_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Duk wanda ya taɓa gadonsa dole yă wanke rigunansa, yă kuma yi wanka, zai kuwa ƙazantu har yamma. ");
INSERT INTO hausa_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Duk wanda ya zauna a inda wannan mai ɗiga ya zauna a kai, dole yă wanke rigunansa yă kuma yi wanka, zai kuwa ƙazantu har yamma. ");
INSERT INTO hausa_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","“ ‘Duk wanda ya taɓa jikin mai ɗiga, dole yă wanke rigunansa, yă kuma yi wanka, zai kuma ƙazantu har yamma. ");
INSERT INTO hausa_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","“ ‘In mai ɗiga ya tofa miyau a kan wani wanda yake tsarkakakke, dole tsarkakakken nan yă wanke rigunansa, yă kuma yi wanka, zai kuma ƙazantu har yamma. ");
INSERT INTO hausa_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","“ ‘Kowane sirdi da mai ɗigar ya zauna a kai zai ƙazantu, ");
INSERT INTO hausa_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","kuma duk wanda ya taɓa wani abu cikin abubuwan da suke a ƙarƙashin sirdin zai ƙazantu har yamma; duk wanda ya ɗauki abubuwan nan dole yă wanke rigunansa, yă kuma yi wanka, zai kuwa ƙazantu har yamma. ");
INSERT INTO hausa_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","“ ‘Duk wanda mai ɗiga ya taɓa ba tare da ya wanke hannuwansa da ruwa ba, dole yă wanke rigunansa yă kuma yi wanka, zai kuma ƙazantu har yamma. ");
INSERT INTO hausa_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","“ ‘Dole a farfashe tukunya lakar da mutumin ya taɓa, kuma dole a ɗauraye duk wani abin da aka yi da katako wanda ya taɓa da ruwa. ");
INSERT INTO hausa_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“ ‘Sa’ad da aka tsabtacce mai ɗigar, zai ɗauki kwana bakwai don tsabtaccewarsa; dole yă wanke rigunansa, yă kuma yi wanka mai tsabta, zai kuwa zama tsarkakakke. ");
INSERT INTO hausa_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","A rana ta takwas dole yă ɗauki kurciyoyi biyu ko tattabarai biyu, yă zo gaban Ubangiji a ƙofar Tentin Sujada, yă ba da su ga firist. ");
INSERT INTO hausa_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Firist ɗin zai miƙa su, ɗaya domin hadaya don zunubi, ɗayan kuma domin hadaya ta ƙonawa. Ta haka zai yi kafara a gaban Ubangiji saboda mai ɗigar. ");
INSERT INTO hausa_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“ ‘Sa’ad da namiji ya ɗigar maniyyi, dole yă wanke jikinsa gaba ɗaya da ruwa, zai kuma ƙazantu har yamma. ");
INSERT INTO hausa_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Dole a wanke duk riga ko fatar da yake da maniyyin a kansa da ruwa, zai kuma ƙazantu har yamma. ");
INSERT INTO hausa_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Sa’ad da namiji ya kwana da mace ya kuwa zub da maniyyi, dole dukansu biyu su yi wanka, za su kuma ƙazantu har yamma. ");
INSERT INTO hausa_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“ ‘Sa’ad mace take al’adarta ta ƙa’ida, rashin tsabtarta ta al’adar zai ɗauki kwana bakwai, kuma duk wanda ya taɓa ta, zai ƙazantu har yamma. ");
INSERT INTO hausa_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","“ ‘Duk abin da ta kwanta a kai a lokacin al’adarta zai ƙazantu, kuma duk abin da ta zauna a kai zai ƙazantu. ");
INSERT INTO hausa_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Duk wanda ya taɓa gadonta dole yă wanke rigunansa yă kuma yi wanka, zai kuma ƙazantu har yamma. ");
INSERT INTO hausa_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Duk wanda ya taɓa wani abin da ta zauna a kai, dole yă wanke rigunansa yă kuma yi wanka, zai kuma ƙazantu har yamma. ");
INSERT INTO hausa_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Ko gado ne, ko kuwa wani abin da ta zauna a kai, sa’ad da wani ya taɓa shi, zai ƙazantu har yamma. ");
INSERT INTO hausa_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","“ ‘In namiji ya kwana da ita, al’adarta kuwa ta taɓa shi, zai ƙazantu na kwana bakwai; duk kuma gadon da ya kwanta a kai, zai ƙazantu. ");
INSERT INTO hausa_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“ ‘Idan mace tana ɗigar jini na tsawon kwanaki, ban da kwanakin ganin al’adarta, ko kuwa idan al’adarta ya wuce yawan kwanakin da ya kamata, to, za tă ƙazantu daidai kamar na kwanakin al’adar da ta saba yi. Wato, muddin tana cikin ɗiga, ta zama mai ƙazanta. ");
INSERT INTO hausa_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Duk gadon da ta kwanta yayinda ta ci gaba da ɗiga zai zama marar tsarki, kamar yadda gadonta yake a lokacin al’adarta, kuma duk abin da ta zauna a kai zai zama marar tsarki, kamar yadda yake a lokacin al’adarta. ");
INSERT INTO hausa_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Duk wanda ta taɓa su zai zama marar tsarki; dole yă wanke rigunansa yă kuma yi wanka, zai kuma ƙazantu har yamma. ");
INSERT INTO hausa_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","“ ‘Sa’ad da aka tsabtacce ta daga ɗigarta, dole tă ɗauki kwana bakwai, bayan haka za tă zama mai tsarki. ");
INSERT INTO hausa_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","A rana ta takwas, dole tă ɗauki kurciyoyi biyu ko tattabari biyu ta kawo su ga firist a bakin ƙofar Tentin Sujada. ");
INSERT INTO hausa_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Firist zai miƙa ɗaya saboda hadaya don zunubi, ɗayan kuma don hadaya ta ƙonawa. Ta haka zai yi kafara dominta a gaban Ubangiji saboda ƙazantar ɗigarta. ");
INSERT INTO hausa_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“ ‘Ta haka za ka tsarkake Isra’ilawa daga rashin tsarkinsu, domin kada su mutu saboda rashin tsarkinsu ta wurin ƙazantar da wurin zamana wanda yake tsakiyarsu.’ ” ");
INSERT INTO hausa_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Waɗannan su ne ƙa’idodi a kan wanda yake ɗiga, da wanda yake zubar da maniyyi, ");
INSERT INTO hausa_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","ƙa’idodi ne kuma ga mace wadda take al’ada, ga namiji ko macen da take ɗiga, ga kuma namijin da ya kwana da mace marar tsarki. ");
INSERT INTO hausa_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Ubangiji ya yi magana da Musa bayan mutuwar ’ya’yan Haruna biyu maza waɗanda suka mutu sa’ad da suka kusaci Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Ubangiji ya ce wa Musa, “Faɗa wa ɗan’uwanka Haruna, kada yă riƙa shiga Wuri Mafi Tsarki bayan labule koyaushe, wato, a gaban murfi wanda yake bisa akwatin alkawari, domin kada yă mutu, gama zan bayyana a cikin girgije a kan murfin. ");
INSERT INTO hausa_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","“Ga yadda Haruna zai shiga wuri mai tsarki, zai zo da ɗan bijimi domin hadaya don zunubi da kuma rago domin hadaya ta ƙonawa. ");
INSERT INTO hausa_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Zai sa toguwar lilin mai tsarki, tare da ɗan ciki na lilin; zai yi ɗamara da igiya kewaye da shi, yă kuma sa hular lilin. Waɗannan su ne riguna masu tsarki; saboda haka dole yă yi wanka kafin yă sa su. ");
INSERT INTO hausa_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Zai ɗauki bunsurai biyu daga jama’ar Isra’ilawa na hadaya don zunubi da ɗan rago don hadaya ta ƙonawa. ");
INSERT INTO hausa_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","“Haruna zai miƙa bijimi hadaya don zunubinsa yă kuma yi kafara don kansa da gidansa. ");
INSERT INTO hausa_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Sa’an nan zai ɗauki bunsurai biyu yă miƙa su a gaban Ubangiji a ƙofar Tentin Sujada. ");
INSERT INTO hausa_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Haruna zai jefa ƙuri’a don awaki biyun ɗin, ƙuri’a ɗaya domin Ubangiji, ɗayan kuma don azazel ");
INSERT INTO hausa_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Haruna zai kawo akuyar da ƙuri’a ta fāɗi a kai wa Ubangiji yă miƙa ta na hadaya don zunubi. ");
INSERT INTO hausa_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Amma za a miƙa akuyar da aka zaɓa ta wurin ƙuri’a a matsayi ta azazel da rai a gaban Ubangiji don a yi amfani da ita don kafara ta wurin korinta zuwa cikin jeji kamar azazel. ");
INSERT INTO hausa_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“Haruna zai kawo bijimi domin hadayarsa ta zunubi don yă yi kafara wa kansa da kuma domin gidansa, zai kuma yanka bijimin domin nasa hadaya don zunubi. ");
INSERT INTO hausa_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Zai ɗauki faranti cike da garwashin wuta daga bagade a gaban Ubangiji, yă kuma cika hannunsa biyu da turare mai ƙanshin da aka niƙa yă kai su bayan labule. ");
INSERT INTO hausa_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Zai sa turaren a wuta a gaban Ubangiji, hayaƙin turaren kuwa zai rufe murfin kafarar a bisa Akwatin Alkawari, don kada yă mutu. ");
INSERT INTO hausa_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Zai ɗibi jinin bijimin da yatsarsa yă yayyafa a gaban murfin kafarar; sa’an nan yă yayyafa jinin da yatsarsa sau bakwai a gaban murfin kafarar. ");
INSERT INTO hausa_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“Sa’an nan zai yanka akuya na hadaya don zunubi saboda mutane, yă kai jinin bayan labule, yă yi da shi yadda ya yi da jinin bijimin. Zai yayyafa shi a kan murfin kafarar da kuma a gabansa. ");
INSERT INTO hausa_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Ta haka zai yi kafara domin Wuri Mafi Tsarki saboda ƙazantar tawayen Isra’ilawa, da laifofinsu, da dukan zunubansu. Haka zai yi saboda Tentin Sujada wanda yake a cikinsu a tsakiyar ƙazantarsu. ");
INSERT INTO hausa_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Kada kowa yă kasance a Tentin Sujada daga lokacin da Haruna ya shiga don yă yi kafara a Wuri Mafi Tsarki har sai ya fita, bayan ya yi kafara domin kansa, gidansa da kuma dukan jama’ar Isra’ila. ");
INSERT INTO hausa_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","“Sa’an nan zai fita zuwa bagade da yake a gaban Ubangiji, yă yi kafara dominsa. Zai ɗibi jinin bijimi da na akuya yă zuba a ƙahonin bagade. ");
INSERT INTO hausa_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Zai yayyafa jinin a kan bagade da yatsarsa sau bakwai, yă tsabtacce shi yă kuma tsarkake shi daga ƙazantar Isra’ilawa. ");
INSERT INTO hausa_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“Sa’ad da Haruna ya gama yin kafara domin Wuri Mafi Tsarki, Tentin Sujada da kuma bagade, sai yă kawo akuya mai rai. ");
INSERT INTO hausa_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Haruna zai ɗibiya hannuwansa a kan akuya mai ran, yă furta a kansa dukan mugunta da tawayen Isra’ilawa, dukan zunubansu, yă kuma sa su a kan akuyan. Zai kori akuyan zuwa cikin jeji a hannun mutumin da aka ba shi aikin yin haka. ");
INSERT INTO hausa_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Akuyan zai ɗauka a kansa dukan zunubansu zuwa kaɗaitaccen wuri, a can mutumin zai sake shi a jeji. ");
INSERT INTO hausa_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“Sa’an nan Haruna zai shiga Tentin Sujada yă tuɓe rigunansa na lilin da ya sa, kafin yă shiga Wuri Mafi Tsarki, zai kuma bar su a can. ");
INSERT INTO hausa_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Zai yi wanka a tsattsarkan wuri yă sa rigunarsa na kullum. Sa’an nan zai fita yă miƙa hadaya ta ƙonawa domin kansa da hadaya ta ƙonawa domin mutane, don yă yi kafara domin kansa da kuma domin mutane. ");
INSERT INTO hausa_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Zai kuma ƙone kitsen hadaya don zunubi a kan bagade. ");
INSERT INTO hausa_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","“Dole mutumin da ya saki akuya na azazel yă wanke rigunansa yă kuma yi wanka; bayan haka zai iya shiga sansani. ");
INSERT INTO hausa_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Dole a ɗauki jini, fata, nama da kuma ƙashin bijimi da akuyan hadaya don zunubi, waɗanda aka kawo jininsu cikin Wuri Mafi Tsarki don kafara, a kai waje da sansani a ƙone. ");
INSERT INTO hausa_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Dole mutumin da ya ƙone su yă wanke rigunansa yă kuma yi wanka, bayan haka zai iya shiga sansani. ");
INSERT INTO hausa_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“Wannan za tă zama dawwammamiyar farilla a gare ku. A rana ta goma ga wata na bakwai, dole ku yi mūsu kanku, ba kuwa za ku yi wani aiki ba, ko da mutum baƙo ne a cikinku ko kuwa ɗan ƙasa, ");
INSERT INTO hausa_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","gama a wannan rana za a yi kafara dominku, don a tsarkake ku. Sa’an nan a gaban Ubangiji, za a tsarkake ku daga dukan zunubanku. ");
INSERT INTO hausa_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Asabbaci ne don hutawa, kuma dole ku yi mūsun kanku; wannan dawwammamiyar farilla ce. ");
INSERT INTO hausa_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Firist da aka keɓe aka kuma naɗa don yă gāji mahaifinsa a matsayin babban firist ne zai yi kafara. Zai sa rigunan lilin masu tsarki ");
INSERT INTO hausa_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","yă yi kafara domin Wuri Mafi Tsarki, Tentin Sujada da bagade, da kuma saboda firistoci da kuma dukan jama’ar Isra’ila. ");
INSERT INTO hausa_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","“Wannan za tă zama dawwammamiyar farilla ce gare ku. Za a riƙa yin kafara sau ɗaya a shekara saboda dukan zunuban Isra’ilawa.” Aka kuma yi haka, yadda Ubangiji ya umarci Musa. ");
INSERT INTO hausa_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“Yi magana da Haruna da ’ya’yansa maza da kuma dukan Isra’ilawa, ka ce musu, ‘Ga abin da Ubangiji ya umarta. ");
INSERT INTO hausa_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Duk mutumin Isra’ilan da ya yanka sa, ɗan rago ko akuya a sansani ko waje da shi ");
INSERT INTO hausa_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","a maimakon kawo shi a matsayin hadaya ga Ubangiji a gaban tabanakul na Ubangiji, za a ɗauki wannan mutum a matsayi mai laifin zub da jini, ya zub da jini, kuma dole a raba shi da mutanensa. ");
INSERT INTO hausa_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Wannan ya zama haka saboda Isra’ilawa su kawo wa Ubangiji hadayun da suke yi a filaye. Dole su kawo su ga firist, wato, ga Ubangiji, a ƙofar Tentin Sujada, su miƙa su a matsayin hadayun salama. ");
INSERT INTO hausa_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Firist zai yayyafa jinin a bagaden Ubangiji, a ƙofar Tentin Sujada, yă kuma ƙone kitsen kamar ƙanshi mai daɗi ga Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Kada kuma su ƙara yin hadayunsu ga gumaka masu siffar bunsurai waɗanda suka bauta wa. Wannan za tă zama dawwammamiyar farilla a gare su wa tsararraki masu zuwa.’ ");
INSERT INTO hausa_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“Faɗa musu, ‘Duk wani mutumin Isra’ila ko wani baƙon da yake zama a cikinsu wanda ya miƙa hadaya ta ƙonawa ko sadaka ");
INSERT INTO hausa_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","kuma bai kawo shi a ƙofar Tentin Sujada don yă miƙa shi ga Ubangiji ba, dole a raba wannan mutum da mutanensa. ");
INSERT INTO hausa_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“ ‘Duk mutumin Isra’ila ko baƙon da yake zama a cikinsu wanda ya ci wani jini, zan yi gāba da wannan mutum wanda ya ci jinin, za a kuma raba shi da mutanensa. ");
INSERT INTO hausa_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Gama ran halitta yana a cikin jinin, kuma na ba da shi gare ku don kafara a kan bagade, jini ne yake kafara saboda ran mutum. ");
INSERT INTO hausa_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Saboda haka na ce wa Isra’ilawa, “Babu waninku da zai ci jini, babu wani baƙon da yake zama a cikinku da zai ci jini.” ");
INSERT INTO hausa_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“ ‘Duk wani mutumin Isra’ila ko baƙon da yake zama a cikinku wanda ya ji wa wani dabba ko tsuntsu wanda ake ci ciwo, dole yă tsiyaye jinin yă rufe shi da ƙasa, ");
INSERT INTO hausa_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","domin ran kowace halitta yana cikin jini. Shi ya sa na ce wa Isra’ilawa, “Kada ku ci jinin wani halitta, domin ran kowace halitta yana cikin jinin; duk wanda ya ci shi dole a fid da shi.” ");
INSERT INTO hausa_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“ ‘Kowa, ko haifaffe ɗan ƙasa ko baƙo, da ya ci wani abin da aka sami a mace, ko naman jeji ya yayyage, dole yă wanke rigunansa, yă kuma yi wanka, zai kuma ƙazantu har yamma; sa’an nan zai tsarkake. ");
INSERT INTO hausa_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Amma in bai wanke rigunansa ya kuma yi wanka ba, alhaki zai kasance a kansa.’ ” ");
INSERT INTO hausa_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“Yi wa Isra’ilawa magana ka kuma faɗa musu cewa, ‘Ni ne Ubangiji Allahnku. ");
INSERT INTO hausa_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Kada ku yi yadda suke yi a Masar inda da kuke zama, kuma ba a ku yi kamar yadda suke yi a ƙasar Kan’ana inda nake kawo ku ba. Kada ku yi yadda suke yin abubuwa. ");
INSERT INTO hausa_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Dole ku kiyaye dokokina kuma ku lura ku bi farillaina. Ni ne Ubangiji Allahnku. ");
INSERT INTO hausa_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Ku kiyaye farillaina da dokokina, gama mutumin da ya aikata waɗannan abubuwa zai rayu ta wurinsu. Ni ne Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“ ‘Kada wani ya kusaci wani dangi na kusa don yă yi jima’i. Ni ne Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","“ ‘Kada ka ƙasƙantar da mahaifinka ta wurin kwana da mahaifiyarka. Ita mahaifiyarka ce; kada ka yi jima’i da ita. ");
INSERT INTO hausa_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","“ ‘Kada ka yi jima’i da matar mahaifinka, wannan zai ƙasƙantar da mahaifinka. ");
INSERT INTO hausa_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","“ ‘Kada ka yi jima’i da ’yar’uwarka, ko ’yar mahaifinka ko ’yar mahaifiyarka, ko an haife ta a gida ɗaya da kai ko kuwa a wani wuri dabam. ");
INSERT INTO hausa_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","“ ‘Kada ka yi jima’i da ’yar ɗanka ko ’yar ’yarka, wannan zai ƙasƙantar da kai. ");
INSERT INTO hausa_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","“ ‘Kada ka yi jima’i da ’yar matar mahaifinka wadda aka haifa wa mahaifinka; ita ’yar’uwarka ce. ");
INSERT INTO hausa_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","“ ‘Kada ka yi jima’i da ’yar’uwar mahaifinka, ita dangin mahaifinka ne na kusa. ");
INSERT INTO hausa_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","“ ‘Kada ka yi jima’i da ’yar’uwar mahaifiyarka, domin ita dangin mahaifiyarka ce na kusa. ");
INSERT INTO hausa_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","“ ‘Kada ka ƙasƙantar da ɗan’uwan mahaifinka ta wurin kusaci matarsa don ka yi jima’i da ita, ita bābarka ce. ");
INSERT INTO hausa_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","“ ‘Kada ka yi jima’i da matar ɗanka. Ita matar ɗanka ne; kada ka yi jima’i da ita. ");
INSERT INTO hausa_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","“ ‘Kada ka yi jima’i da matar ɗan’uwanka; wannan zai ƙasƙanta ɗan’uwanka. ");
INSERT INTO hausa_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","“ ‘Kada ka yi jima’i da mace da kuma ’yarta. Kada ka yi jima’i da ’yar ɗanta ko ’yar ’yarta; su danginta ne na kusa. Wannan mugun abu ne. ");
INSERT INTO hausa_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","“ ‘Kada ka auri ’yar’uwar matarka ta zama kishiyar matarka ka kuma yi jima’i da ita yayinda matarka tana da rai. ");
INSERT INTO hausa_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“ ‘Kada ka kusaci mace don ka yi jima’i da ita a lokacin ƙazantar al’adarta. ");
INSERT INTO hausa_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","“ ‘Kada ka yi jima’i da matar maƙwabcinka ka ƙazantar da kanka tare da ita. ");
INSERT INTO hausa_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","“ ‘Kada ku ba da wani daga cikin ’ya’yanku don a yi hadaya wa Molek, gama ba za ku ƙasƙantar da sunan Allahnku ba. Ni ne Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","“ ‘Kada ka kwana da namiji kamar yadda namiji yakan kwana da ta mace, wannan abin ƙyama ne. ");
INSERT INTO hausa_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","“ ‘Kada ka yi jima’i da dabba ka ƙazantar da kanka. Mace ba za tă ba da kanta ga dabba don yă yi jima’i da ita ba; wannan abin ƙyama ne. ");
INSERT INTO hausa_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“ ‘Kada ku ƙazantar da kanku da wani daga cikin waɗannan, domin haka al’umman da zan kora a gabanku suka ƙazantu. ");
INSERT INTO hausa_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Har ƙasar ma ta ƙazantu, saboda haka na hukunta ta saboda zunubinta, ƙasar kuwa ta amayar da mazaunanta. ");
INSERT INTO hausa_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Amma dole ku kiyaye farillaina da kuma dokokina. Kada haifaffe ɗan ƙasa da baƙin da suke zama a cikinku yă yi wani daga cikin waɗannan abubuwa banƙyama, ");
INSERT INTO hausa_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","gama mutanen da suka zauna a wannan ƙasa kafin ku sun aikata dukan waɗannan abubuwa, suka kuma ƙazantu. ");
INSERT INTO hausa_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Kuma in kuka ƙazantar da ƙasar, za tă amayar da ku kamar yadda ta amayar da al’umman da suka riga ku. ");
INSERT INTO hausa_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","“ ‘Duk wanda ya yi wani daga cikin waɗannan abubuwa banƙyama, dole a fid da mutumin daga cikin mutanensa. ");
INSERT INTO hausa_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Ku kiyaye umarnaina kuma kada yi ku wata al’ada mai banƙyamar da aka yi kafin ku zo kuma kada ku ƙazantar da kanku da su. Ni ne Ubangiji Allahnku.’ ” ");
INSERT INTO hausa_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“Yi wa taron jama’ar Isra’ila gaba ɗaya magana, ka ce musu, ‘Ku zama masu tsarki, domin Ni, Ubangiji Allahnku, mai tsarki ne. ");
INSERT INTO hausa_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","“ ‘Dole kowannenku yă girmama mahaifiyarsa da mahaifinsa, dole kuma ku kiyaye Asabbacina. Ni ne Ubangiji Allahnku. ");
INSERT INTO hausa_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","“ ‘Kada ku juyo ga gumaka, ko ku yi wa kanku allolin da aka yi zubi da ƙarfe. Ni ne Ubangiji Allahnku. ");
INSERT INTO hausa_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“ ‘Sa’ad da kuka miƙa hadaya ta salama ga Ubangiji, ku miƙa ta yadda za tă karɓu a madadinku. ");
INSERT INTO hausa_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Za a ci ta a ranar da kuka miƙa ta, ko kuwa a kashegarin; duk abin da ya rage har kwana ta uku dole a ƙone shi. ");
INSERT INTO hausa_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","In aka ci ta a rana ta uku, marar tsabta ce, ba kuma za a karɓe ta ba. ");
INSERT INTO hausa_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Duk wanda ya ci ta zai zama da laifi domin ya ƙazantar da abin da yake da tsarki ga Ubangiji, dole a raba mutumin nan da mutanensa. ");
INSERT INTO hausa_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“ ‘Sa’ad da kuka yi girbin amfanin gonarku, kada ku girbe har zuwa gefen gonar, ko ku yi kalan girbinku. ");
INSERT INTO hausa_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Kada ku koma gonar inabinku kuna kala, ko ku tattara ’ya’yan inabin da suka fāffāɗi. Ku bar su domin matalauta da kuma baƙi. Ni ne Ubangiji Allahnku. ");
INSERT INTO hausa_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“ ‘Kada ku yi sata. “ ‘Kada ku yi ƙarya. “ ‘Kada ku ruɗe juna. ");
INSERT INTO hausa_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","“ ‘Kada ku rantse bisa ƙarya da sunana, ta haka har ku ƙasƙantar da sunan Allahnku. Ni ne Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“ ‘Kada ku zalunci maƙwabcinku, ko ku yi masa ƙwace. “ ‘Kada ku riƙe albashin ma’aikaci yă kwana. ");
INSERT INTO hausa_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","“ ‘Kada ku zagi kurma, ko ku sa abin tuntuɓe a gaban makaho, amma ku ji tsoron Allahnku. Ni ne Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“ ‘Kada ku yi rashin adalci cikin shari’a; kada ku nuna sonkai ga matalauci, ko ku goyi bayan mai arziki, amma ku shari’anta maƙwabci cikin gaskiya. ");
INSERT INTO hausa_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","“ ‘Kada ku yi ta yawo kuna yaɗa ƙarya a cikin mutanenku. “ ‘Kada ku yi wani abin da zai sa ran maƙwabcinku cikin hatsari. Ni ne Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“ ‘Kada ka yi ƙiyayyar ɗan’uwanka a zuciya. Ka tsawata wa maƙwabcinka da gaske don kada ka sami rabo cikin laifinsa. ");
INSERT INTO hausa_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","“ ‘Kada ka nemi yin ramuwa, ko ka riƙe wani cikin mutanenka a zuciya, amma ka ƙaunaci maƙwabcinka kamar kanka. Ni ne Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“ ‘Ku kiyaye farillaina. “ ‘Kada ku sa dabbobin da ba iri ɗaya ba su yi barbara. “ ‘Kada ku yi shuki iri biyu a gonarku. “ ‘Kada ku sa rigar da aka saƙa da yadi iri biyu. ");
INSERT INTO hausa_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“ ‘In wani ya kwana da mace wadda take baiwa, wadda aka yi wa wani alkawari amma bai fanshe ta ba, ko kuwa ba a ’yantar da ita ba, dole a yi hukuncin da ya dace. Duk da haka ba za a kashe su ba, domin ba a ’yantar da ita ba. ");
INSERT INTO hausa_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Dole mutumin da ya kwana da ita yă kawo rago a ƙofar Tentin Sujada domin hadaya don laifi ga Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Da ragon hadaya don laifin ne firist zai yi kafara saboda mutumin a gaban Ubangiji saboda zunubin da ya yi, za a kuwa gafarta zunubinsa. ");
INSERT INTO hausa_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“ ‘Sa’ad da kuka shiga ƙasar kuka kuma shuka kowane irin itace mai ’ya’ya na ci, ku ɗauki ’ya’yan itatuwan nan a matsayi an hana ku ci. Shekara uku za ku ɗauka a matsayi an hana ku, ba za ku ci su ba. ");
INSERT INTO hausa_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","A shekara ta huɗu, dukan ’ya’yansu za su zama tsarkakakku, hadaya ta yabo ga Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Amma a shekara ta biyar, za ku iya cin ’ya’yan itatuwan. Ta haka girbinku zai ƙaru. Ni ne Ubangiji Allahnku. ");
INSERT INTO hausa_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“ ‘Kada ku ci wani abinci tare da jini a cikinsa. “ ‘Kada ku yi duba ko sihiri. ");
INSERT INTO hausa_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","“ ‘Ba za ka aske gefe-gefe na gashin kanka ba, ko ku aske gemunku. ");
INSERT INTO hausa_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","“ ‘Kada ku tsattsaga jikunanku saboda matattu, ba kuwa za ku yi wa kanku zāne-zāne a jiki ba. Ni ne Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“ ‘Kada ka ƙasƙantar da ’yarka ta wurin mai da ita karuwa, in ba haka ba ƙasar za tă juya ga karuwanci tă kuma cika da mugunta. ");
INSERT INTO hausa_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","“ ‘Ku kiyaye Asabbacina, ku kuma girmama wuri mai tsarkina. Ni ne Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“ ‘Kada ku juya ga masu duba, ko ku nemi shawarar bokaye, gama za ku ƙazantu ta wurinsu. Ni ne Ubangiji Allahnku. ");
INSERT INTO hausa_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“ ‘Ku miƙe tsaye a gaban tsofaffi, ku nuna bangirma ga waɗanda suka tsufa, ku kuma girmama Allahnku. Ni ne Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“ ‘Sa’ad da baƙo yana zama tare da ku a ƙasarku, kada ku wulaƙanta shi. ");
INSERT INTO hausa_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Dole ku ɗauki baƙon da yake zama tare da ku kamar haifaffe ɗan ƙasa. Ku ƙaunace shi kamar kanku, gama dā ku ma baƙi ne a Masar. Ni ne Ubangiji Allahnku. ");
INSERT INTO hausa_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“ ‘Kada ku yi amfani da mudun ƙarya sa’ad da kuke awon tsawo, nauyi, ko yawan abu. ");
INSERT INTO hausa_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Ku yi amfani da ma’auni na gaskiya da mudu na gaskiya, da kuma magwaji na gaskiya. Ni ne Ubangiji Allahnku, wanda ya fitar da ku daga Masar. ");
INSERT INTO hausa_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","“ ‘Ku kiyaye dukan farillaina da kuma dukan dokokina, ku kuma bi su. Ni ne Ubangiji.’ ” ");
INSERT INTO hausa_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“Faɗa wa Isra’ilawa cewa, ‘Duk wani mutumin Isra’ila ko baƙon da yake zama a cikin Isra’ila da ya miƙa wani daga cikin ’ya’yansa wa Molek, dole sa kashe shi. Mutanen ƙasar za su jajjefe shi. ");
INSERT INTO hausa_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Zan yi gāba da wannan mutum, zan kuma raba shi da mutanensa; gama ta wurin miƙa ’ya’yansa ga Molek, ya ƙazantar da wuri mai tsarkina, ya kuma ƙazantar da sunana mai tsarki. ");
INSERT INTO hausa_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","In mutanen ƙasar suka kau da idanunsu sa’ad da wannan mutum ya miƙa ’ya’yansa ga Molek, suka kāsa kashe shi, ");
INSERT INTO hausa_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","zan yi gāba da wannan mutum da iyalinsa, zan raba shi da kuma duk waɗanda suka bi shi cikin karuwanci ga Molek daga mutanensu. ");
INSERT INTO hausa_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“ ‘Zan yi gāba da mutumin da ya juyo ga masu duba da bokaye, don yă yi karuwanci ta wurin bin su, zan kuma raba shi daga mutanensa. ");
INSERT INTO hausa_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","“ ‘Ku tsarkake kanku, ku kuma zama da tsarki, gama Ni ne Ubangiji Allahnku. ");
INSERT INTO hausa_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Ku kiyaye farillaina, ku kuma bi su. Ni ne Ubangiji, wanda ya mai da ku masu tsarki. ");
INSERT INTO hausa_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“ ‘In wani ya zagi mahaifinsa ko mahaifiyarsa, dole a kashe shi. Domin ya zagi mahaifinsa ko mahaifiyarsa, alhakin jininsa zai zauna a kansa. ");
INSERT INTO hausa_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“ ‘In mutum ya yi zina da matar wani, da matar maƙwabcinsa, dole a kashe su biyu da suka yi zinan. ");
INSERT INTO hausa_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","“ ‘In mutum ya kwana da matar mahaifinsa, ya ƙasƙantar da mahaifinsa. Dole a kashe shi da macen, alhakin jininsu zai zauna a kansu. ");
INSERT INTO hausa_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","“ ‘In mutum ya kwana da matar ɗansa, dole a kashe su biyun. Abin da suka yi haram ne; alhakin jininsu zai zauna a kansu. ");
INSERT INTO hausa_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","“ ‘In mutum ya kwana da mutum kamar yadda ake kwana da mace, su biyun sun yi abin ƙyama. Dole a kashe su, alhakin jininsu zai zauna a kansu. ");
INSERT INTO hausa_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","“ ‘In mutum ya auri ’ya da mahaifiyarta, mugun abu ne. Da shi da su, dole a ƙone su da wuta, saboda kada mugun abu yă kasance a cikinku. ");
INSERT INTO hausa_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","“ ‘In mutum ya yi jima’i da dabba, dole a kashe shi, dole kuma ku kashe dabbar. ");
INSERT INTO hausa_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","“ ‘In mace ta kusaci dabba don tă yi jima’i da ita, ku kashe macen da dabbar. Dole a kashe su; alhakin jininsu zai zauna a kansu. ");
INSERT INTO hausa_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“ ‘In mutum ya auri ’yar’uwarsa, ko ’yar mahaifinsa, ko kuwa ta mahaifiyarsa, suka kuma yi jima’i, abin kunya ne. Dole a raba su a idanun mutanensu. Ya ƙasƙantar da ’yar’uwarsa kuma za a nemi hakki daga gare shi. ");
INSERT INTO hausa_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","“ ‘In mutum ya kwana da mace a lokacin al’adarta, duka biyunsu za a kore su daga cikin jama’arsu, gama sun karya ƙa’idodi a kan rashi tsarki. ");
INSERT INTO hausa_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","“ ‘Kada ka yi jima’i da ’yar’uwar mahaifiyarka, ko ta mahaifinka, gama wannan zai ƙasƙantar da dangi na kurkusa, dukanku za ku ɗauki laifin. ");
INSERT INTO hausa_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","“ ‘In mutum ya kwana da bābarsa, ya ƙasƙantar da kawunsa ke nan. Hakkin zai kasance a kansu, za su mutu babu ’ya’ya. ");
INSERT INTO hausa_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","“ ‘In mutum ya auri matar ɗan’uwansa, aikin rashin tsabta ne, ya ƙasƙantar da ɗan’uwansa ke nan. Za su mutu babu ’ya’ya. ");
INSERT INTO hausa_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“ ‘Ku kiyaye dukan farillaina da dokokina duka, don kada ƙasar da nake kai ku ta amayar da ku. ");
INSERT INTO hausa_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Kada ku yi zama bisa ga al’adun al’umman da zan kora a gabanku. Domin sun aikata dukan waɗannan abubuwa, na yi ƙyamarsu. ");
INSERT INTO hausa_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Amma na faɗa muku, “Za ku mallaki ƙasarsu, zan ba ku ita gādo, ƙasa mai zub da madara da zuma.” Ni ne Ubangiji Allahnku, wanda ya keɓe ku daga al’ummai. ");
INSERT INTO hausa_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","“ ‘Saboda haka sai ku bambanta tsakanin dabbobi masu tsarki da marasa tsarki, da kuma tsakanin tsuntsaye masu tsarki da marasa tsarki. Kada ku ƙazantar da kanku ta wurin wata dabba, ko tsuntsu, ko wani abin da yake rarrafe a ƙasa, waɗanda na keɓe a matsayi marasa tsarki a gare ku. ");
INSERT INTO hausa_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Ku zama tsarkakakke gare ni, gama Ni Ubangiji, mai tsarki ne, na kuma keɓe ku daga al’ummai don ku zama nawa. ");
INSERT INTO hausa_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“ ‘Namiji, ko ta macen da yake mai duba, ko maita a cikinku dole a kashe. Za ku jajjefe su da duwatsu; alhakin jininsu zai zauna a kansu.’ ” ");
INSERT INTO hausa_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Ubangiji ya ce wa Musa, “Yi magana da firistoci, ’ya’yan Haruna maza, ka ce musu, ‘Kada firist yă ƙazantar da kansa saboda wani cikin mutanensa da suka mutu, ");
INSERT INTO hausa_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","sai dai na danginsa na kusa, kamar mahaifiyarsa ko mahaifinsa, ɗansa ko ’yarsa, ɗan’uwansa, ");
INSERT INTO hausa_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","ko ’yar’uwarsa da ba tă riga ta yi aure ba, wadda take dogara gare shi, da yake ba ta da miji, saboda ita zai iya ƙazantar da kansa. ");
INSERT INTO hausa_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Kada yă ƙazantar da kansa saboda mutanen da suke da dangantakar da shi ta wurin aure, ta yin haka zai ƙazantar da kansa. ");
INSERT INTO hausa_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“ ‘Kada firistoci su aske kansu ƙwal ko su kwakkwafe gemunsu, ko su tsattsage jikunansu. ");
INSERT INTO hausa_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Dole su kasance masu tsarki ga Allahnsu, kada kuma su ɓata sunan Allahnsu. Domin sukan miƙa hadayun da aka kawo wa Ubangiji da wuta, abincin Allahnsu, saboda haka sai su kasance da tsarki. ");
INSERT INTO hausa_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","“ ‘Ba za su auri matan da karuwanci ya ɓata su, ko waɗanda mazansu suka sake su ba, gama firistoci masu tsarki ne ga Allahnsu. ");
INSERT INTO hausa_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","An ɗauke su da tsarki, domin suna miƙa abincin Allahnku. An ɗauka su masu tsarki gama Ni Ubangiji, mai tsarki ne, Ni wanda ya mai da ku masu tsarki. ");
INSERT INTO hausa_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","“ ‘In ’yar firist ta ɓata kanta ta wurin zama karuwa, ta kunyatar da mahaifinta ke nan; dole a ƙone ta da wuta. ");
INSERT INTO hausa_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“ ‘Babban firist, wanda yake ɗaya cikin ’yan’uwansa wanda aka shafe da mai a kansa, wanda kuma aka naɗa don yă sa rigunan firistoci, kada yă bar gashin kansa buzu-buzu, ko ya kyakketa rigunansa. ");
INSERT INTO hausa_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Ba zai shiga inda akwai gawa ba. Kada yă ƙazantar da kansa, ko ma ta mahaifinsa ce ko ta mahaifiyarsa. ");
INSERT INTO hausa_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","An keɓe shi domina, kada yă ƙazantar da kansa, kada kuwa yă ɓata Tentin Sujada ta wurin shiga gidan da gawa take, ko ta mahaifinsa, ko ta mahaifiyarsa ce. Ni ne Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","“ ‘Dole macen da zai aura ta kasance budurwa. ");
INSERT INTO hausa_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Ba zai auri matan da mijinta ya mutu, ko macen da mijinta ya rabu da ita, ko macen da ta ɓata kanta ta wurin karuwanci ba, sai dai yă auri budurwa daga cikin mutanensa, ");
INSERT INTO hausa_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","don kada yă ƙazantar da ’ya’yansa a cikin mutanensa. Ni ne Ubangiji, wanda ya mai da shi mai tsarki.’ ” ");
INSERT INTO hausa_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“Faɗa wa Haruna cewa, ‘Don tsararraki masu zuwa, kada ko ɗaya daga cikin zuriyarka, da yake da lahani yă zo kusa domin yă miƙa hadaya ta ci gare ni. ");
INSERT INTO hausa_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Duk mai lahani, ko makaho, ko gurgu, ko mai naƙasa, ko mai wani lahani a jiki; ");
INSERT INTO hausa_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","ko mai karyayyen ƙafa, ko mai karyayyen hannu, ");
INSERT INTO hausa_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","ko mai ƙusumbi, ko wada, ko wanda yake da lahani a ido, ko mai cuta mai sa ƙaiƙayi, ko mai kirci, ko wanda aka daƙe, ba zai yi kusa domin yă miƙa hadaya ba. ");
INSERT INTO hausa_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Ba zuriyar Haruna firist, mai lahanin da zai zo kusa don yă miƙa hadayun da aka yi ga Ubangiji da wuta. Da yake yana da lahani, ba zai zo kusa don yă miƙa abincin Allahnsa ba. ");
INSERT INTO hausa_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Zai iya cin abinci mafi tsarki na Allahnsa, haka ma abinci mai tsarki; ");
INSERT INTO hausa_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","duk da haka saboda lahaninsa, ba zai yi kusa da labule, ko yă yi kusa da bagade don kada yă ƙazantar da wuri mai tsarkina. Ni ne Ubangiji wanda yake mai da su masu tsarki.’ ” ");
INSERT INTO hausa_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Sai Musa ya faɗa wannan wa Haruna da ’ya’yansa maza da kuma dukan Isra’ilawa. ");
INSERT INTO hausa_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“Faɗa wa Haruna da ’ya’yansa maza, su lura da tsarkakakkun abubuwan da Isra’ilawa suka keɓe gare ni da bangirma, saboda ba za su ƙazantar da sunana mai tsarki ba. Ni ne Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","“Faɗa musu cewa, ‘Don tsararraki masu zuwa, in wani zuriyarku ya ƙazantu, duk da haka ya kusaci tsarkakakku hadayun da Isra’ilawa suka keɓe ga Ubangiji, dole a raba wannan mutum daga gabana. Ni ne Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","“ ‘In zuriyar Haruna yana da kuturu, ko mai ɗiga, ba zai ci daga cikin tsarkakakkun abubuwa ba, sai lokacin da ya tsarkaka. Duk wanda ya taɓa wani abu marar tsarki na mamaci, ko wanda maniyyinsa yake ɗiga, ");
INSERT INTO hausa_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","da duk kuma wanda ya taɓa wani abu mai rarrafe wanda yake ƙazantarwa, ko kuwa wani mutum mai ƙazanta, ");
INSERT INTO hausa_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","duk mutumin da ya taɓa kowane irin abu haka, zai ƙazantu har yamma, ba kuwa zai ci daga cikin tsarkakakkun abubuwan nan ba, sai ya yi wanka tukuna. ");
INSERT INTO hausa_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Sa’ad da rana ta fāɗi, zai zama tsarkakakke, bayan wannan kuwa zai iya cin tsarkakakkun hadayu, gama abincinsa ne. ");
INSERT INTO hausa_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Kada yă ci wani abin da ya mutu mushe, ko wanda namun jeji suka yayyaga, don kada yă ƙazantar da kansa. Ni ne Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“ ‘Firistoci za su kiyaye umarnaina don kada su yi laifi su mutu saboda sun rena su. Ni ne Ubangiji, wanda ya mai da su masu tsarki. ");
INSERT INTO hausa_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“ ‘Duk wanda ba daga cikin iyalin firistoci ba, ko da yake yana zama tare da su, ko kuwa an ɗauke shi yana yin musu aiki, ba zai ci daga cikin tsarkakakkun hadayun ba. ");
INSERT INTO hausa_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Amma in firist ya sayi bawa da kuɗi, ko kuwa in an haifi bawan a gidansa, wannan bawan zai iya cin tsattsarkan abincin. ");
INSERT INTO hausa_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","In ’yar firist ta auri wani da ba firist ba, ba za tă ci wani tsarkakakkun sadaka ba. ");
INSERT INTO hausa_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Amma idan ’yar firist ta zama gwauruwa ko sakakkiya, ba ta da ’ya’ya, ta kuwa dawo don tă zauna a gidan mahaifinta kamar matashiya, za tă iya cin abincin. ");
INSERT INTO hausa_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“ ‘In wani ya ci tsarkakakken abinci cikin kuskure, dole yă maido wa firist hadayar, yă kuma ƙara kashi ɗaya bisa biyar na tamanin abin. ");
INSERT INTO hausa_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Firist ɗin ba zai ƙasƙantar da tsarkakakkun hadayun da Isra’ilawa suka kawo ga Ubangiji ");
INSERT INTO hausa_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","ta wurin barinsu su ci tsarkakakkun hadayu, ta yin haka su jawo wa kansu laifin da zai bukaci biya ba. Ni ne Ubangiji, wanda ya mai da ku masu tsarki.’ ” ");
INSERT INTO hausa_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“Yi wa Haruna da ’ya’yansa maza da kuma dukan Isra’ilawa magana ka ce musu, ‘In waninku, ko mutumin Isra’ila, ko baƙon da yake zama a Isra’ila, ya kawo kyauta don hadaya ta ƙonawa ga Ubangiji, ko don yă cika alkawari, ko kuwa a matsayin hadaya ta yardar rai, ");
INSERT INTO hausa_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","dole ku miƙa dabba namiji marar lahani, daga shanu, tumaki, ko awaki, domin yă zama yardajje a madadinku. ");
INSERT INTO hausa_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Kada ku kawo wani abu mai lahani, domin ba zai zama yardajje ba a madadinku. ");
INSERT INTO hausa_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Sa’ad da wani ya kawo hadaya ta salama daga garken shanu, ko na tumaki, ga Ubangiji don yă cika wani alkawari na musamman, ko hadaya ta yardar rai, dole yă zama marar lahani, ko tabo, don yă zama yardajje. ");
INSERT INTO hausa_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Kada ku miƙa wa Ubangiji dabbobi makafi, ko naƙasassu, ko masu gundumi, ko masu ɗiga, ko masu susa, ko masu kirci. Kada ku sa wani daga cikin waɗannan a bisa bagade a matsayin hadaya, gama hadaya ce da aka ƙone da wuta ga Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Za ku iya miƙa hadaya ta yardar rai da maraƙi, ko tunkiya mai naƙasa, ko marar cikakken lafiya, amma ba za tă zama yardajje don cika alkawarin da aka yi ba. ");
INSERT INTO hausa_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Ba za ku miƙa wa Ubangiji dabbar da lunsayinta yake da ƙujewa, ko dandaƙewa, ko yagewa, ko yankewa ba. ");
INSERT INTO hausa_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Ba za ku kuma karɓi irin waɗannan dabbobi daga hannun baƙi ku miƙa su a matsayin abinci ga Allahnku ba. Ba za su zama yardajje a madadinku ba, domin sun naƙasa, suna kuma da lahani.’ ” ");
INSERT INTO hausa_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“Sa’ad da aka haifi ɗan maraƙi, tunkiya, ko akuya, sai yă kasance da mahaifiyarsa kwana bakwai. Daga rana ta takwas zuwa gaba, zai zama yardajje hadaya, hadaya ce da aka ƙone da wuta ga Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Kada a yanka saniya, ko tunkiya da ɗanta rana ɗaya. ");
INSERT INTO hausa_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","“Sa’ad da kuka miƙa hadaya ta godiya ga Ubangiji, ku miƙa ta a yadda za tă zama yardajje a madadinku. ");
INSERT INTO hausa_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Dole a ci hadayar a ranar; kada a bar saura sai da safe. Ni ne Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“Ku kiyaye dokokina, ku kuma bi su. Ni ne Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Kada ku ƙasƙantar da sunana mai tsarki. Dole Isra’ilawa su gane Ni mai tsarki ne. Ni ne Ubangiji, wanda ya keɓe ku a matsayin tsarkaka ");
INSERT INTO hausa_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","da kuma wanda ya fitar da ku daga Masar don in zama Allahnku. Ni ne Ubangiji.” ");
INSERT INTO hausa_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“Yi magana da Isra’ilawa, ka ce musu, ‘Ga ƙayyadaddun bukukkuwa, ƙayyadaddun bukukkuwan Ubangiji, da za ku sanar wa mutane su riƙa kiyayewa, su zama lokutan tarurruka masu tsarki. ");
INSERT INTO hausa_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“ ‘Akwai kwanaki shida da za ku iya yin aiki, amma rana ta bakwai, Asabbaci ne na hutu, rana mai tsarki ga jama’a. Kada ku yi wani aiki a ko’ina kuke da zama, Asabbaci ne ga Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“ ‘Waɗannan su ne bukukkuwan da Ubangiji ya kafa da tsarkakakkun taron jama’a za su yi a ƙayyadaddun lokuta. ");
INSERT INTO hausa_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Bikin Ƙetarewar Ubangiji, zai fara da yamma a ranar goma sha huɗu na wata na fari. ");
INSERT INTO hausa_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","A rana ta goma sha biyar na wannan wata, za a fara Bikin Burodi Marar Yisti na Ubangiji. Za ku yi kwana bakwai kuna cin burodi marar yisti. ");
INSERT INTO hausa_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","A rana ta fari, ku yi taro mai tsarki, ba kuwa za ku yi aiki na kullum ba. ");
INSERT INTO hausa_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Kwana bakwai za ku miƙa hadaya ga Ubangiji da wuta. A rana ta bakwai ɗin ku yi taro mai tsarki, ba za ku kuwa yi aiki na kullum ba.’ ” ");
INSERT INTO hausa_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“Yi magana da Isra’ilawa, ka ce musu, ‘Sa’ad da kuka shiga ƙasar da zan ba ku, kuka kuma girbe amfanin gonarta, sai ku kawo wa firist damin hatsi na farko da kuka girbe. ");
INSERT INTO hausa_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Zai kaɗa damin a gaban Ubangiji domin yă zama yardajje a madadinku; firist ɗin zai kaɗa shi a kashegarin Asabbaci. ");
INSERT INTO hausa_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","A ranar da kuka kaɗa damin, dole ku miƙa hadaya ta ƙonawa na ɗan rago bana ɗaya, marar lahani ga Ubangiji, ");
INSERT INTO hausa_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","tare da hadaya ta gari mai laushi, humushi biyu haɗe da mai, wato, hadaya ce da aka ƙone da wuta ga Ubangiji, mai daɗin ƙanshi, da kuma abin sha kwalaba ɗaya na ruwan inabi. ");
INSERT INTO hausa_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Ba za ku ci wani burodi, ko gasasshen hatsi, ko sabon hatsi ba, sai ran nan da kuka kawo wannan hadaya ga Allahnku. Wannan za tă zama dawwammamiyar farilla wa tsararraki masu zuwa, a duk inda kuke zama. ");
INSERT INTO hausa_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“ ‘Daga kashegarin Asabbaci, ranar da kuka kawo dami don hadaya ta kaɗawa, ku ƙirga cikakku makoni bakwai. ");
INSERT INTO hausa_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Ku ƙirga kwana hamsin har zuwa kashegarin Asabbaci na bakwai, sa’an nan ku miƙa hadaya ta sabon hatsi ga Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Daga ko’ina kuke da zama, ku kawo dunƙule biyu na humushin gari mai laushi da aka tuya da yisti, a matsayin hadaya ta kaɗawa ta ’ya’yan fari na itatuwa ga Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Tare da wannan, ku miƙa ’yan raguna bakwai, kowanne bana ɗaya-ɗaya marar lahani, bijimi da kuma raguna biyu. Za su zama hadaya ta ƙonawa ga Ubangiji, tare da hadayunsu na hatsi, da hadayunsu na sha, hadaya da aka yi da wuta, mai daɗin ƙanshi ga Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Sa’an nan ku miƙa bunsuru ɗaya na hadaya don zunubi, da ’yan raguna biyu, kowanne bana ɗaya-ɗaya, don hadaya ta salama. ");
INSERT INTO hausa_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Firist zai kaɗa ’yan raguna biyun a gaban Ubangiji, a matsayin hadaya ta kaɗawa, tare da burodin sababbin ’ya’yan fari na itatuwan. Tsarkaken hadaya ce ga Ubangiji ga firist. ");
INSERT INTO hausa_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","A wannan rana za ku yi taro mai tsarki, ba kuwa za ku yi aiki na kullum ba. Wannan za tă zama dawwammamiyar farilla wa tsararraki masu zuwa, a ko’ina kuke da zama. ");
INSERT INTO hausa_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“ ‘Sa’ad da kuka yi girbin gonarku, kada ku girbe har ƙarshen gefen gonar, ko ku yi kalar girbinku. Ku bar su wa matalauta da baƙi. Ni ne Ubangiji Allahnku.’ ” ");
INSERT INTO hausa_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“Faɗa wa Isra’ilawa cewa, ‘A ranar farko ga wata na bakwai, za tă zama ranar hutu, rana ce ta tuni da yin taro mai tsarki na sujada da za a fara busar ƙaho. ");
INSERT INTO hausa_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Kada ku yi aiki na kullum, amma ku miƙa hadaya ta ƙonawa ga Ubangiji.’ ” ");
INSERT INTO hausa_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“Rana ta goma ta wata bakwai, za tă zama Ranar Kafara. Sai ku yi taro mai tsarki don ku yi mūsun kanku ku kuma miƙa hadayar da aka yi da wuta ga Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Kada ku yi aiki a ranar, gama Ranar Kafara ce, sa’ad da za a yi kafara saboda ku a gaban Ubangiji Allahnku. ");
INSERT INTO hausa_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Duk wanda bai yi mūsun kansa a wannan rana ba, dole a raba shi daga mutanensa. ");
INSERT INTO hausa_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Zan hallaka duk wani da ya yi aiki a wannan rana daga mutanensa. ");
INSERT INTO hausa_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Sam ba za ku yi wani aiki ba. Wannan za tă zama dawwammamiyar farilla ce, wa tsararraki masu zuwa, a ko’ina kuke da zama. ");
INSERT INTO hausa_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Asabbaci ne na hutu dominku, kuma dole ku yi mūsun kanku. Daga yamman rana ta tara ga wata, har zuwa yamma na biye, za ku kiyaye Asabbacinku.” ");
INSERT INTO hausa_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“Faɗa wa Isra’ilawa cewa, ‘A ranar goma sha biyar ga wata na bakwai, za a fara Bikin Tabanakul na Ubangiji, zai kuma ɗauki kwana bakwai. ");
INSERT INTO hausa_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","A ranar farko za tă zama ta taro mai tsarki, kada ku yi aiki na kullum. ");
INSERT INTO hausa_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Kwana bakwai za ku miƙa hadayun da aka yi da wuta ga Ubangiji, a rana ta takwas, ku yi taro mai tsarki, ku kuma miƙa hadayar da aka yi da wuta ga Ubangiji. Wannan ranar rufewar taro ce; kada ku yi aiki na kullum. ");
INSERT INTO hausa_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","(“ ‘Waɗannan su ne bukukkuwan da Ubangiji ya kafa, waɗanda za ku yi a matsayin tsarkakakkun taro, don kawo hadayun da aka yi da wuta ga Ubangiji, hadayu na ƙonawa da hadayu na hatsi, sadaka da kuma hadayu na sha, da ake bukata kowace rana. ");
INSERT INTO hausa_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Waɗannan hadayu, ƙari ne a kan waɗannan na Asabbatan Ubangiji, haɗe kuma da kyautanku, da kome da kuka yi alkawari, da kuma hadayu yardar ran da za ku ba wa Ubangiji.) ");
INSERT INTO hausa_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“ ‘Saboda haka, farawa daga ranar goma sha biyar ga watan bakwai, bayan kun tara hatsin gona, ku yi bikin Ubangiji kwana bakwai; rana ta fari, rana hutu ce, rana ta takwas kuma rana hutu ce. ");
INSERT INTO hausa_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","A rana ta fari, za ku ɗebi zaɓaɓɓun ’ya’yan itatuwa daga itatuwa, da rassan dabino, rassa masu ganye, da kuma ganyayen itacen wardi na rafi, ku yi farin ciki a gaban Ubangiji Allahnku, kwana bakwai. ");
INSERT INTO hausa_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Za ku kiyaye bikin nan har kwana bakwai a kowace shekara ga Ubangiji. Wannan za tă zama dawwammamiyar farilla wa tsarraraki masu zuwa, ku kiyaye ta a wata na bakwai. ");
INSERT INTO hausa_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Ku zauna a bukkoki kwana bakwai. Dukan ’yan ƙasa haifaffun Isra’ilawa, za su zauna a bukkoki ");
INSERT INTO hausa_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","don zuriyarku tă san cewa na sa Isra’ilawa suka zauna a bukkoki sa’ad da na fitar da su daga Masar. Ni ne Ubangiji Allahnku.’ ” ");
INSERT INTO hausa_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Saboda haka Musa ya sanar wa Isra’ilawa ƙayyadaddun bukukkuwan Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“Ka umarci Isra’ilawa su kawo tsabtataccen mai na zaitun da aka matse, don ƙuna fitilun yadda harshen wutar ba zai taɓa mutuwa ba. ");
INSERT INTO hausa_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Za a ajiye su waje da labulen Wuri Mafi Tsarki a Tentin Sujada, Haruna zai riƙa kula da fitilun a gaban Ubangiji, daga yamma zuwa safiya. Wannan za tă zama dawwammamiyar farilla wa tsararraki masu zuwa. ");
INSERT INTO hausa_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Dole a ci gaba da shirya fitilu a kan wurin ajiye fitila na zinariya, a gaban Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“Ɗauki gari mai laushi a gasa dunƙulen burodi goma sha biyu, a yi amfani da humushi biyu na garwan gari don kowace burodi. ");
INSERT INTO hausa_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","A shirya su jeri biyu, guda shida a kowane jeri a kan teburin da aka yi da zinariya zalla, a gaban Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Za a zuba turare a kowane layin dunƙulen burodin don yă kasance abin tunawa a bisa burodin. Turaren zai ƙone a madadin burodin don yă zama kamar hadayar da aka miƙa da wuta ga Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Za a shirya wannan gurasa a gaban Ubangiji kowane Asabbaci, a madadin Isra’ilawa a matsayin madawwamin alkawari. ");
INSERT INTO hausa_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Wannan burodin zai zama na Haruna da ’ya’yansa maza, waɗanda za su ci a tsattsarkan wuri, gama sashe ne mafi tsarki na rabonsu na kullum na hadayar da aka yi da wuta ga Ubangiji.” ");
INSERT INTO hausa_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","To, ɗan wata mutuniyar Isra’ila wanda mahaifinsa mutumin Masar ne, ya je cikin Isra’ilawa, sai faɗa ta tashi tsakaninsa da wani mutumin Isra’ila a cikin sansani. ");
INSERT INTO hausa_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Ɗan mutuniyar Isra’ila ya saɓi Sunan Ubangiji, ya kuma la’ana shi, saboda haka aka kawo shi wa Musa. (Sunan mahaifiyarsa Shelomit ne, ’yar Dibri na kabilar Dan.) ");
INSERT INTO hausa_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Suka sa shi a gidan tsaro sai lokacin da nufin Ubangiji ya nuna musu abin da za su yi da shi. ");
INSERT INTO hausa_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Sai Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Ka kai mai saɓon nan waje da sansani. Duk waɗanda suka ji maganar da mai saɓon nan ya yi su ɗibiya hannuwansu a kansa, taron jama’a kuwa gaba ɗaya su jajjefe shi da duwatsu. ");
INSERT INTO hausa_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Faɗa wa Isra’ilawa cewa, ‘Duk wanda ya zagi Allahnsa, alhakin zai rataya a wuyansa, ");
INSERT INTO hausa_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","duk wanda ya saɓi sunan Ubangiji, dole a kashe shi. Dole jama’a gaba ɗaya su jajjefe shi da duwatsu. Ko baƙo, ko haifaffen ɗan ƙasa, sa’ad da ya saɓi Sunan Ubangiji, dole a kashe shi. ");
INSERT INTO hausa_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“ ‘Duk wanda ya kashe mutum, dole a kashe shi. ");
INSERT INTO hausa_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Duk wanda ya kashe dabbar wani, dole yă biya, rai domin rai. ");
INSERT INTO hausa_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Duk wanda ya yi wa maƙwabcinsa rauni, sai a yi masa abin da ya yi; ");
INSERT INTO hausa_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","karaya don karaya, ido don ido, haƙori don haƙori. Kamar yadda ya yi wa wani rauni, shi ma a yi masa. ");
INSERT INTO hausa_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Duk wanda ya kashe dabba, dole yă biya, amma duk wanda ya kashe mutum, dole a kashe shi. ");
INSERT INTO hausa_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Za ku kasance da doka iri ɗaya wa baƙo da kuma wa haifaffen ɗan ƙasa. Ni ne Ubangiji Allahnku.’ ” ");
INSERT INTO hausa_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Sai Musa ya yi wa Isra’ilawa magana, suka kuwa kai mai saɓon waje da sansani, suka jajjefi shi da duwatsu. Isra’ilawa suka yi yadda Ubangiji ya umarci Musa. ");
INSERT INTO hausa_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Ubangiji ya yi magana da Musa a kan Dutsen Sinai ya ce, ");
INSERT INTO hausa_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“Yi wa Isra’ilawa magana, ka ce musu, ‘Sa’ad da kuka shiga ƙasar da zan ba ku, dole ƙasar kanta ta kiyaye Asabbaci ga Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Shekara shida, za ku yi shuki, shekara shida kuma za ku aske gonakin inabinku, ku kuma tattara hatsinsu. ");
INSERT INTO hausa_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Amma a shekara ta bakwai, ƙasar za tă sami hutun Asabbaci, Asabbaci ga Ubangiji. Kada ku yi shuki a gonakinku, ko kuwa ku aske gonakinku na inabi. ");
INSERT INTO hausa_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Kada ku girbe abin da ya yi girma ba tare da ku kuka shuka ba, ko ku girbe inabin da ba ku aske ba. Ƙasar za tă kasance da shekarar hutu. ");
INSERT INTO hausa_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Duk abin da gonar ta ba da amfani a shekara ta Asabbaci, zai zama abinci gare ku, wa kanku, bayinku maza da mata, da ma’aikatan da kuka ɗauka aiki, da kuma waɗanda ba zama ɗinɗinɗin suke yi tare da ku ba, ");
INSERT INTO hausa_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","haka ma zai zama abinci domin dabbobinku, da kuma namun jeji a ƙasarku. Duk abin da ƙasar ta bayar za a ci. ");
INSERT INTO hausa_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“ ‘Ku ƙirga asabbatai bakwai na shekaru bakwai, sau bakwai. Gama asabbatai bakwai na shekaru bakwai za su yi daidai da shekaru arba’in da tara. ");
INSERT INTO hausa_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Sa’an nan a busa ƙaho a ko’ina, a rana ta goma ga wata na bakwai; a Ranar Kafara, a busa ƙaho a dukan ƙasarku. ");
INSERT INTO hausa_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Ku keɓe shekara ta hamsin ku kuma yi shelar ’yanci a dukan ƙasar ga mazaunanta. Za tă zama shekarar murna gare ku; kowannenku zai koma ga mallakar iyalinsa, kuma kowa ga danginsa. ");
INSERT INTO hausa_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Shekara ta hamsin za tă zama ta murna a gare ku; kada ku yi shuki, kada kuma ku yi girbi abin da ya yi girma da kansa, ko ku girbe inabin da ba ku lura da shi ba. ");
INSERT INTO hausa_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Gama shekara ce ta murna, za tă kuma zama mai tsarki a gare ku, ku dai ci abin da aka ɗauka kai tsaye daga gonaki. ");
INSERT INTO hausa_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","“ ‘A wannan Shekara ta Murna, kowa zai koma ga mallakarsa. ");
INSERT INTO hausa_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","“ ‘In ka sayar da gona wa wani daga mutanen ƙasarka, ko ka saya wata gona daga gare shi, kada ku cuci juna. ");
INSERT INTO hausa_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Sa’ad da mutum ya sayi fili daga abokin zamansa, kuɗin zai kasance bisa ga yawan shekara hamsin ta murna da suka wuce, da kuma bisa ga yawan shekarun noma da suka rage kafin wata shekara hamsin ta murna. ");
INSERT INTO hausa_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Idan shekarun suna da yawa, sai ku kara kuɗin filin, idan kuma shekarun ba su da yawa, sai ku rage kuɗin filin, gama ainihin abin da ake sayar maka shi ne yawan hatsin. ");
INSERT INTO hausa_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Kada ku cuci juna, amma ku ji tsoron Allahnku. Ni ne Ubangiji Allahnku. ");
INSERT INTO hausa_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“ ‘Ku bi farillaina, ku kuma yi hankali ga kiyaye dokokina, za ku kuwa zauna lafiya a ƙasar. ");
INSERT INTO hausa_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Sa’an nan ƙasar za tă ba da amfaninta, za ku kuwa ci ku ƙoshi, ku kuma zauna lafiya. ");
INSERT INTO hausa_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Mai yiwuwa ku ce, “Me za mu ci a shekara ta bakwai in ba mu yi shuki ko girbin hatsinmu ba?” ");
INSERT INTO hausa_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Zan aika muku da irin albarka a shekara ta shida har da ƙasar za tă ba da amfani isashe na shekara uku. ");
INSERT INTO hausa_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Yayinda kuke shuki a shekara ta takwas, za ku kasance da raguwa hatsi na shekarar da ta wuce, za ku kuma ci gaba da ci daga gare shi har girbin shekara ta tara yă shigo. ");
INSERT INTO hausa_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“ ‘Kada a sayar da gona ɗinɗinɗin, gama ƙasar tawa ce, ku kuwa baƙi ne kawai, kuma ’yan haya nawa. ");
INSERT INTO hausa_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Ko’ina a ƙasar da kuke da mallaka, dole ku tanadar da dama fansar ƙasar. ");
INSERT INTO hausa_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","“ ‘In ɗaya daga cikin mutanen ƙasarku ya talauta, ya kuma sayar da mallakarsa, sai danginsa na kusa yă je yă fanshi abin da mutumin ƙasarsa ya sayar. ");
INSERT INTO hausa_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","In mutumin ba shi da wanda zai fansa masa ita, shi kansa kuwa ya wadace, ya kuma sami isashen halin fansarta, ");
INSERT INTO hausa_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","sai yă lasafta yawan shekarun da aka yi tun da an sayar da filin. Kuɗin filin zai dangana ga yawan shekarun da suka rage kafin shekara hamsin ta murna da za tă zo; sa’an nan zai iya koma ga mallakarsa. ");
INSERT INTO hausa_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Amma in bai sami halin sāke biyansa ba, abin nan da ya sayar zai ci gaba da zama mallakar mai sayan, sai Shekara ta Murna. Za a maido masa da ita a Shekara ta Murna, sa’an nan zai iya koma ga mallakarsa. ");
INSERT INTO hausa_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“ ‘In mutum ya sayar da gida a birni mai katanga, yana da izini yă fanshe shi a ƙarshen shekara guda, bayan ya sayar da shi. ");
INSERT INTO hausa_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","In ba a fanshe shi a ƙarshen shekara ba, gidan da yake a birni mai katanga, zai zama mallakar na ɗinɗinɗin na mai sayan da kuma zuriyarsa. Ba za a mai da shi a Shekara ta Murna ba. ");
INSERT INTO hausa_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Amma za a ɗauki gidaje a ƙauyuka marasa katanga kewaye da su daidai da gonaki. Za a iya fanshe su, a kuma mayar da su a Shekara ta Murna. ");
INSERT INTO hausa_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","“ ‘Kullum, Lawiyawa suna da izini su fanshi gidajensu a biranen Lawiyawa waɗanda suka mallaka. ");
INSERT INTO hausa_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Saboda haka ana iya fansa mallakar Lawiyawa, wato, gidan da aka sayar a duk birnin da yake nasu, za a kuma mayar a Shekara ta Murna, gama gidaje a biranen Lawiyawa, mallakar Isra’ilawa ne. ");
INSERT INTO hausa_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Amma kada a sayar da filayen kiwo na waɗannan birane; mallakarsu ce, ta ɗinɗinɗin. ");
INSERT INTO hausa_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“ ‘In ɗaya daga ciki mutanen ƙasarku ya talauta, ba ya kuma iya tallafa wa kansa a cikinku, sai ku taimake shi kamar yadda za ku yi da baƙo a cikinku. ");
INSERT INTO hausa_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Kada ku karɓi riba ta kowace iri daga gare shi, amma ku ji tsoron Allahnku, saboda mutumin ƙasarku yă ci gaba da zama a cikinku. ");
INSERT INTO hausa_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Kada ku ba shi rancen kuɗi da ruwa, ko ku sayar masa abinci don samun riba. ");
INSERT INTO hausa_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Ni ne Ubangiji Allahnku, wanda ya fitar da ku daga Masar, don in ba ku ƙasar Kan’ana in kuma zama Allahnku. ");
INSERT INTO hausa_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“ ‘In ɗaya daga cikin mutanen ƙasarku ya talauta a cikinku, ya kuma sayar da kansa gare ku, kada ku sa yă yi kamar bawa. ");
INSERT INTO hausa_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Amma a ɗauke shi a matsayin ma’aikacin da aka ɗauka aiki, ko mazaunan da ba na ɗinɗinɗin ba a cikinku, sai yă yi muku aiki sai Shekara ta Murna. ");
INSERT INTO hausa_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Sa’an nan a sake shi da ’ya’yansa, yă kuma koma ga danginsa da mallakar kakanninsa. ");
INSERT INTO hausa_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Gama Isra’ilawa bayina ne, waɗanda na saya daga Masar, kada a sayar da su a matsayin bayi. ");
INSERT INTO hausa_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Kada ku gwada musu azaba, amma ku ji tsoron Allahnku. ");
INSERT INTO hausa_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","“ ‘Bayinku maza da mata, za su zo daga al’ummai da suke kewaye da ku, daga gare su za ku iya saya bayi. ");
INSERT INTO hausa_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Za ku iya saya waɗansu mutanen da ba sa zama ɗinɗinɗin a cikinku, da kuma membobin danginsu da aka haifa a ƙasarku. ");
INSERT INTO hausa_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Za ku iya ba da su ga ’ya’yanku a matsayin kayan gādo, za ku kuma iya mai da su bayi dukan rayuwarsu, amma kada ku yi mulki a bisa ’yan’uwanku Isra’ilawa da tsanani. ");
INSERT INTO hausa_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“ ‘In baƙo, ko wani da yake zama ba na ɗinɗinɗin ba a cikinku, ya wadace, ɗaya daga cikin mutanen ƙasarku kuwa ya talauta, ya kuma sayar da kansa ga baƙon da yake zama a cikinku, ko memba na dangin baƙon, ");
INSERT INTO hausa_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","yana da izini samun fansa, bayan ya sayar da kansa. Ɗaya daga cikin danginsa zai iya fansarsa. ");
INSERT INTO hausa_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Kawu ko yaron ɗan’uwan mahaifin wannan mutum, ko kuwa wani dangi a cikin zuriyarsa, zai iya fanshe shi. Ko kuma in ya azurta, zai iya fansar kansa. ");
INSERT INTO hausa_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Da shi da mai sayansa, za su ƙirga lokaci daga shekarar da ya sayar da kansa har zuwa Shekara ta Murna. Farashin sakinsa zai dangana a kuɗin da ake biyan ma’aikacin da aka ɗauka aiki, na yawan shekarun ne. ");
INSERT INTO hausa_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","In shekaru sun ragu, dole yă biya don fansarsa da kuɗi mai yawa fiye da wanda aka saye shi. ");
INSERT INTO hausa_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","In shekarun sun rage kaɗan ne kafin Shekara ta Murna, sai yă yi lissafin wannan, yă kuma biya fansarsa daidai wa daida. ");
INSERT INTO hausa_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Sai a yi da shi kamar ma’aikacin da aka ɗauka aiki, daga shekara zuwa shekara; dole ku tabbata mai shi bai mallake shi da tsanani ba. ");
INSERT INTO hausa_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","“ ‘Ko ma ba a fanshe shi a ɗaya daga cikin waɗannan hanyoyi ba, sai a sake shi da ’ya’yansa a Shekara ta Murna, ");
INSERT INTO hausa_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","gama Isra’ilawa nawa ne a matsayin bayi. Su bayina ne waɗanda na saya daga Masar. Ni ne Ubangiji Allahnku. ");
INSERT INTO hausa_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“ ‘Kada ku yi gumaka, ko ku kafa siffa, ko al’amudi wa kanku, kada kuma ku sa sassaƙaƙƙun duwatsu a ƙasarku don ku rusuna musu. Ni ne Ubangiji Allahnku. ");
INSERT INTO hausa_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","“ ‘Ku kiyaye Asabbataina, ku kuma ba wa wuri mai tsarkina girma. Ni ne Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“ ‘In kuka kiyaye farillaina, kuka yi biyayya da umarnaina, ");
INSERT INTO hausa_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","zan aika da ruwan sama a lokacinsa, ƙasa kuma za tă ba da hatsi, itatuwa kuma za su haihu ’ya’yansu. ");
INSERT INTO hausa_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Masussukanku za su ci gaba har lokacin girbin inabi, girbin inabi kuma zai ci gaba har lokacin shuki, za ku kuma ci duk abincin da kuke so cikin salama a ƙasarku. ");
INSERT INTO hausa_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","“ ‘Zan ba ku salama a ƙasar, za ku kuwa kwanta, kuma babu wani da zai tsorata ku. Zan kori mugayen namun jeji daga ƙasar, takobi kuma ba zai ratsa cikin ƙasarku ba. ");
INSERT INTO hausa_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Za ku kori abokan gābanku, za su kuwa fāɗi a kaifin takobi a gabanku. ");
INSERT INTO hausa_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Mutanenku biyar za su kori mutum ɗari, mutanenku ɗari kuma za su kori mutane dubu goma, abokan gābanku kuma za su fāɗi a kaifin takobi a gabanku. ");
INSERT INTO hausa_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","“ ‘Zan dube ku da idon rahama, in kuma sa ku riɓaɓɓanya ku kuma ƙaru, zan kiyaye alkawarina da ku. ");
INSERT INTO hausa_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Za ku ci gaba da cin girbin bara, har ku fitar da shi don ku sami wurin saboda sabo. ");
INSERT INTO hausa_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Zan kafa wurin zamana a cikinku, ba zan kuma yi ƙyamarku ba. ");
INSERT INTO hausa_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Zan yi tafiya a cikinki in kuma zama Allahnku, za ku kuwa zama mutanena. ");
INSERT INTO hausa_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Ni ne Ubangiji Allahnku, wanda ya fitar da ku daga Masar don kada ku ƙara zama bayi ga Masarawa; na karya sandunan wahalarku, na kuma bar ku ku yi tafiya a sake. ");
INSERT INTO hausa_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“ ‘Amma in za ku kasa kunne gare ni, ku kuma aikata dukan waɗannan umarnai, ");
INSERT INTO hausa_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","in kuka kuma ƙi farillaina, kuka yi ƙyamar dokokina, kuka kuma kāsa kiyaye umarnaina, har kuka karya alkawarina, ");
INSERT INTO hausa_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","to, zan yi muku wannan. Zan kawo muku abin bantsoro, cututtuka da zazzaɓin da zai lalatar da idonku, yă kuma sa ranku a wahala. Za ku shuka iri a banza, domin abokan gābanku ne za su ci. ");
INSERT INTO hausa_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Zan yi gāba da ku har abokan gābanku su ci ku a yaƙi, su waɗanda suke ƙinku za su yi mulki a kanku, za ku gudu ba tare da wani yana korinku ba. ");
INSERT INTO hausa_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“ ‘In bayan dukan wannan, ba ku saurare ni ba, zan hukunta ku saboda zunubanku har sau bakwai. ");
INSERT INTO hausa_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Zan karya ikonku wanda kuke fariya da shi, in hana ruwan sama, ƙasa kuma tă zama kamar tagulla. ");
INSERT INTO hausa_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Ƙarfinku zai ƙare a banza domin ƙasarku ba za tă ba da hatsi ba, balle itatuwan ƙasar su ba da ’ya’ya. ");
INSERT INTO hausa_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“ ‘In kuka ci gaba da tayar mini, kuka ƙi ku saurare ni, zan ninka wahalolinku sau bakwai, yadda ya dace da zunubanku. ");
INSERT INTO hausa_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Zan aika da mugayen namun jeji a kanku, za su kuwa kashe ’ya’yanku, su hallaka shanunku, su rage yawanku, ku zama kaɗan. Wannan zai sa a rasa mutane a kan hanyoyinku. ");
INSERT INTO hausa_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“ ‘In duk da waɗannan abubuwa, ba ku yarda da gyaran da nake yi muku ba, kuka ci gaba da yin adawa da ni, ");
INSERT INTO hausa_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","zan yi adawa da ku, zan kuma aukar muku saboda zunubanku har sau bakwai. ");
INSERT INTO hausa_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Zan kawo takobi a kanku don in yi ramuwa saboda karya alkawarin da kuka yi. Sa’ad da kuka janye zuwa cikin biranenku, zan aika da annoba a cikinku, za a kuwa ba da ku ga hannun abokan gāba. ");
INSERT INTO hausa_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Sa’ad da na yanke abincinku, mata goma za su dafa abinci a murhu ɗaya, za su kuma rarraba abincin a ma’auni. Za ku ci amma ba za ku ƙoshi ba. ");
INSERT INTO hausa_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“ ‘In duk da haka kuka ci gaba da ƙin saurare ni, kuka ci gaba da yin adawa da ni, ");
INSERT INTO hausa_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","cikin fushina, sai in yi adawa da ku, in kuma hukunta ku saboda zunubanku har sau bakwai. ");
INSERT INTO hausa_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Za ku ci naman ’ya’yanku maza da na ’ya’yanku mata. ");
INSERT INTO hausa_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Zan rurrushe dukan masujadanku, in yanke bagadanku na turare, in yi tarin gawawwakinku a kan gumakanku, zan kuma yi ƙyamarku. ");
INSERT INTO hausa_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Zan mai da biranenku kango, in lalace wuraren tsarkinku, ba zan kuma shaƙi ƙanshi hadayunku ba. ");
INSERT INTO hausa_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Zan mai da ƙasarku kango har abokan gābanku da suke zama a wurin su yi mamaki. ");
INSERT INTO hausa_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Zan watsar da ku cikin al’ummai, in kuma ja takobina in kore ku. Ƙasarku za tă zama kufai, biranenku kuma su zama kango. ");
INSERT INTO hausa_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Sa’an nan ƙasar za tă ji daɗin hutun shekarun Asabbacinta, a dukan lokutan da take kango, ku kuwa kuna a ƙasar abokan gābanku, sa’an nan ƙasar za tă huta ta ji daɗin asabbatanta. ");
INSERT INTO hausa_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","A dukan lokutan da take kango, ƙasar za tă sami hutun da ba tă samu a lokutan asabbatan da kuke zama a cikinta ba. ");
INSERT INTO hausa_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","“ ‘Ga waɗanda za su ragu kuwa, zan cika zukatansu da tsoro a ƙasashen abokan gābansu har motsin ganyen da iska ta hura zai sa su ruga da gudu. Za su yi gudu kamar suna gudu daga takobi ne, za su kuma fāɗi, ko da yake babu wanda yake korinsu. ");
INSERT INTO hausa_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Za su yi karo da juna kamar waɗanda suke tsere wa takobi, ko da yake babu wanda yake korinsu. Ta haka ba za ku iya tsaya a gaban abokan gābanku ba. ");
INSERT INTO hausa_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Za ku mutu a cikin al’ummai, ƙasar abokan gābanku za tă cinye ku. ");
INSERT INTO hausa_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Sauranku da suka ragu za su lalace a ƙasashen abokan gābansu saboda zunubansu; da kuma saboda zunuban kakanninsu. ");
INSERT INTO hausa_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“ ‘Amma in suka tuba daga zunubansu da zunuban kakanninsu, da cin amanar da suka yi mini, da kuma adawar da suka yi da ni, ");
INSERT INTO hausa_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","waɗanda suka sa na yi adawa da su har da na aika da su ƙasar abokan gābansu, sa’ad da suka ƙasƙantar da zukatansu marasa kaciya, suka kuma biya hukuncin zunubansu, ");
INSERT INTO hausa_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","zan tuna da alkawarina da Yaƙub, da alkawarina da Ishaku, da kuma alkawarina da Ibrahim, zan tuna da ƙasar. ");
INSERT INTO hausa_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Gama za su gudu su bar ƙasar, ƙasar kuwa ta ji daɗin asabbatanta yayinda take kango muddin ba su ciki. Za su biya hukuncin zunubansu domin sun ƙi dokokina, suka kuma yi ƙyamar farillaina. ");
INSERT INTO hausa_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Duk da haka, sa’ad da suke a ƙasar abokan gābansu, ba zan ƙi su, ko in yi ƙyamarsu, in hallaka su ƙaƙaf, har in karya alkawarina da su ba. Ni ne Ubangiji Allahnsu. ");
INSERT INTO hausa_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Amma saboda su, zan tuna da alkawarin da na yi da kakanninsu, waɗanda na fitar da su daga Masar a idon al’ummai, don in zama Allahnsu. Ni ne Ubangiji.’ ” ");
INSERT INTO hausa_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Waɗannan su ne farillai, da dokoki, da kuma ƙa’idodin da Ubangiji ya kafa a Dutsen Sinai, tsakaninsa da Isra’ilawa ta wurin Musa. ");
INSERT INTO hausa_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“Ka yi magana da Isra’ilawa, ka ce musu, ‘Duk sa’ad da mutum ya yi rantsuwa ta musamman zai keɓe wani ga Ubangiji, ta wurin biyan kuɗaɗen fansa, ");
INSERT INTO hausa_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","ga yadda ma’aunin biyan zai kasance, mutum mai shekara tsakanin ashirin da sittin, za a biya azurfa hamsin. ");
INSERT INTO hausa_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Mace kuma za a biya azurfa talatin. ");
INSERT INTO hausa_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Saurayi mai shekara tsakanin biyar da ashirin, za a biya azurfa ashirin, yarinya kuma azurfa goma. ");
INSERT INTO hausa_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Yaro mai shekara tsakanin wata ɗaya da shekara biyar, za a biya azurfa biyar, ’yar yarinya kuma azurfa uku. ");
INSERT INTO hausa_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Namijin da ya fi shekara sittin, za a biya azurfa goma sha biyar, mace kuma azurfa goma. ");
INSERT INTO hausa_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","In mai alkawarin matalauci ne da ba zai iya biyan ƙayyadadden abin da aka tsara ba, sai yă tafi wurin firist, shi firist kuma yă duba yadda mutumin da ya yi alkawarin zai iya biya. Sa’an nan mutumin zai biya abin da firist ya faɗa. ");
INSERT INTO hausa_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“ ‘In abin da ya yi alkawarin yardajje ne a matsayin hadaya ga Ubangiji, wannan dabbar da aka bayar ga Ubangiji, za tă zama mai tsarki. ");
INSERT INTO hausa_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Kada yă yi musayarta ko yă yi musaya mai kyau da marar kyau, ko marar kyau da mai kyau; in lalle ne yă yi musayar dabbar da wata, to, duk wannan da kuma wanda zai yi musayar da ita za su zama masu tsarki. ");
INSERT INTO hausa_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","In abin da ya yi alkawari dabba ce marar tsarki, wadda ba yardajje ba ce, a matsayin hadaya ga Ubangiji, dole a kai dabbar wa firist, ");
INSERT INTO hausa_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","wanda zai yanke hukunci dacewarta, ko mai kyau ce, ko marar kyau. Duk darajar da firist ya kimanta, haka za tă zama. ");
INSERT INTO hausa_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","In mai shi yana so yă fanshi dabbar, dole yă ƙara kashi ɗaya bisa biyar na darajarta. ");
INSERT INTO hausa_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“ ‘In mutum ya miƙa gidansa a matsayin wani abu mai tsarki ga Ubangiji, firist zai daidaita dacewar ko mai kyau ne, ko marar kyau. Duk darajar da firist ya kimanta, haka za tă zama. ");
INSERT INTO hausa_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","In mutumin da ya keɓe gidansa ya fanshe shi, dole yă ƙara kashi ɗaya bisa biyar na darajar, gidan kuma zai zama nasa. ");
INSERT INTO hausa_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“ ‘In wani ya keɓe wa Ubangiji wani sashe daga cikin gonarsa ta gādo, sai yă kimanta kuɗin gonar daidai da yawan irin da za a iya shuka a gonar. Za a kimanta kuɗin a kan shekel hamsin na irin sha’ir. ");
INSERT INTO hausa_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","In ya keɓe gonarsa a Shekara ta Murna, darajar da aka kimanta za tă zauna. ");
INSERT INTO hausa_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Amma in ya keɓe gonar bayan Shekara ta Murnan, firist zai kimanta darajar bisa ga yawan shekarun da suka rage har zuwa Shekara ta Murna mai zuwa, sai a rage darajar da aka kimanta a kanta. ");
INSERT INTO hausa_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","In mutumin da ya keɓe gonar, yana so yă fanshe ta, to, dole yă ƙara kashi ɗaya bisa biyar na darajarta, gonar kuwa tă zama nasa. ");
INSERT INTO hausa_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","In kuma bai fanshe gonar ba, ko kuwa in ya sayar wa wani dabam, ba za a taɓa fanshe ta ba. ");
INSERT INTO hausa_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Sa’ad da aka saki gonar a Shekara ta Murna, za tă zama mai tsarki, a matsayin gonar da aka miƙa ga Ubangiji, za tă zama mallakar firistoci. ");
INSERT INTO hausa_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“ ‘In mutum ya keɓe gonar da ya saya, wadda take ba sashe na gonar iyali ba, ga Ubangiji, ");
INSERT INTO hausa_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","firist zai kimanta darajarta har Shekara ta Murna, dole kuma mutumin yă biya darajarta a ranar, a matsayin wani abu mai tsarki ga Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","A Shekara ta Murna ɗin, gonar za tă dawo ga mutumin da aka saye ta daga wurinsa, wanda yake mai gonar. ");
INSERT INTO hausa_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","A kimanta kowace daraja bisa ga ma’aunin shekel na tsattsarkan wuri, gera ashirin ga shekel. ");
INSERT INTO hausa_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“ ‘Ba wani da zai iya keɓe ɗan farin dabba, da yake ɗan fari ya riga ya zama na Ubangiji, ko na saniya, ko na tunkiya, na Ubangiji ne. ");
INSERT INTO hausa_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","In tana cikin dabbobin da suke marasa tsarki, zai iya saye ta a darajar da aka kimanta, yă ƙara da kashi ɗaya bisa biyar na darajarta. In bai fanshe ta ba, sai a sayar da ita a darajar da aka kimanta. ");
INSERT INTO hausa_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“ ‘Amma babu abin da mutum ya mallaka, ya kuma keɓe ga Ubangiji, ko mutum ne, ko dabba, ko ganar iyali da za a sayar, ko a fansa; kome da aka keɓe a wannan hanya, mafi tsarki ne ga Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","“ ‘Babu wani da aka keɓe don hallaka da za a fansa; dole a kashe shi. ");
INSERT INTO hausa_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“ ‘Ushirin kome daga gona, ko hatsi daga ƙasa, ko ’ya’yan itatuwa daga itatuwa, na Ubangiji ne, mai tsarki ne ga Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","In mutum ya fanshi wani zakansa, dole yă ƙara kashi ɗaya bisa biyar na darajar. ");
INSERT INTO hausa_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Ushirin gaba ɗaya na garken shanu, da na tumaki, kowane kashi ɗaya bisa goma na dabbar da ta wuce ƙarƙashin sandan mai kiwo, za tă zama mai tsarki ga Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Kada kuwa ya zaɓa mai kyau daga marar kyau, ko yă yi musaya. In ya yi musaya kuwa, dabbar da wadda ya musayar, za su zama masu tsarki, ba kuma za a fanshe su ba.’ ” ");
INSERT INTO hausa_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Waɗannan su ne dokokin da Ubangiji ya ba wa Musa a Dutsen Sinai saboda Isra’ilawa.");
INSERT INTO hausa_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Ubangiji ya yi magana da Musa a Tentin Sujada a cikin Hamadar Sinai, a rana ta fari na watan biyu a shekara ta biyu, bayan Isra’ilawa suka fito Masar ya ce, ");
INSERT INTO hausa_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“Ka yi ƙidayan dukan al’umman Isra’ilawa bisa ga iyalansu da kabilarsu, ka rubuta kowa da sunansa bi da bi. ");
INSERT INTO hausa_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Da kai da Haruna za ku lissafta dukan mazan Isra’ila bisa ga sashensu, waɗanda suka kai shekaru ashirin ko fiye, da za su iya shiga soja. ");
INSERT INTO hausa_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Mutum ɗaya daga kowace kabila wanda yake shugaban danginsa, zai taimake ku. ");
INSERT INTO hausa_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","“Ga sunayen da za su taimake ku. “Daga kabilar Ruben, Elizur ɗan Shedeyur; ");
INSERT INTO hausa_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","daga kabilar Simeyon, Shelumiyel ɗan Zurishaddai; ");
INSERT INTO hausa_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","daga kabilar Yahuda, Nashon ɗan Amminadab; ");
INSERT INTO hausa_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","daga kabilar Issakar, Netanel ɗan Zuwar; ");
INSERT INTO hausa_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","daga kabilar Zebulun, Eliyab ɗan Helon; ");
INSERT INTO hausa_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","daga kabilar ’ya’yan Yusuf, daga Efraim, Elishama ɗan Ammihud; daga Manasse, Gamaliyel ɗan Fedazur; ");
INSERT INTO hausa_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","daga kabilar Benyamin, Abidan ɗan Gideyoni; ");
INSERT INTO hausa_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","daga kabilar Dan, Ahiyezer ɗan Ammishaddai; ");
INSERT INTO hausa_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","daga kabilar Asher, Fagiyel ɗan Okran; ");
INSERT INTO hausa_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","daga kabilar Gad, Eliyasaf ɗan Deyuwel; ");
INSERT INTO hausa_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","daga kabilar Naftali, Ahira ɗan Enan.” ");
INSERT INTO hausa_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Waɗannan su ne mutanen da aka naɗa daga cikin jama’a, shugabannin asalin kabilu. Su ne kuma shugabannin dangogin Isra’ila. ");
INSERT INTO hausa_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Sai Musa da Haruna suka ɗauki sunayen mutanen nan da aka ba su, ");
INSERT INTO hausa_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","suka kira dukan al’umma wuri ɗaya a rana ta fari ga wata na biyu. Aka kuwa rubuta mutanen bisa ga asalin kabilansu da iyalansu. Aka kuma rubuta sunayen maza ɗaya-ɗaya da suka kai shekaru ashirin ko fiye, ");
INSERT INTO hausa_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","yadda Ubangiji ya umarci Musa. Da haka ya ƙidaya su a Hamadar Sinai. ");
INSERT INTO hausa_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Daga zuriyar Ruben ɗan fari na Isra’ila. Aka rubuta sunayen dukan maza ɗaya-ɗaya da suka kai shekara ashirin ko fiye da suka isa shiga soja, bisa ga iyalansu da kabilarsu da take a rubuce. ");
INSERT INTO hausa_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Jimillar maza daga mutanen Ruben 46,500 ne. ");
INSERT INTO hausa_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Daga zuriyar Simeyon. Aka rubuta sunayen dukan maza ɗaya-ɗaya da suka kai shekara ashirin ko fiye da suka isa shiga soja, bisa ga iyalansu da kabilarsu da take a rubuce. ");
INSERT INTO hausa_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Jimillar maza daga mutanen Simeyon 59,300 ne. ");
INSERT INTO hausa_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Daga zuriyar Gad. Aka rubuta sunayen dukan maza ɗaya-ɗaya da suka kai shekara ashirin ko fiye da suka isa shiga soja, bisa ga iyalansu da kabilarsu da take a rubuce. ");
INSERT INTO hausa_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Jimillar maza daga mutanen Gad 45,650 ne. ");
INSERT INTO hausa_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Daga zuriyar Yahuda. Aka rubuta sunayen dukan maza ɗaya-ɗaya da suka kai shekara ashirin ko fiye da suka isa shiga soja, bisa ga iyalansu da kabilarsu da take a rubuce. ");
INSERT INTO hausa_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Jimillar maza daga mutanen Yahuda 74,600 ne. ");
INSERT INTO hausa_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Daga zuriyar Issakar. Aka rubuta sunayen dukan maza ɗaya-ɗaya da suka kai shekara ashirin ko fiye da suka isa shiga soja, bisa ga iyalansu da kabilarsu da take a rubuce. ");
INSERT INTO hausa_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","Jimillar maza daga mutanen Issakar 54,400 ne. ");
INSERT INTO hausa_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Daga zuriyar Zebulun. Aka rubuta sunayen dukan maza ɗaya-ɗaya da suka kai shekara ashirin ko fiye da suka isa shiga soja, bisa ga iyalansu da kabilarsu da take a rubuce. ");
INSERT INTO hausa_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Jimillar maza daga mutanen Zebulun 57,400 ne. ");
INSERT INTO hausa_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Daga ’ya’yan Yusuf. Daga zuriyar Efraim. Aka rubuta sunayen dukan maza ɗaya-ɗaya da suka kai shekara ashirin ko fiye da suka isa shiga soja, bisa ga iyalansu da kabilarsu da take a rubuce. ");
INSERT INTO hausa_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Jimillar maza daga mutanen Efraim 40,500 ne. ");
INSERT INTO hausa_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Daga zuriyar Manasse. Aka rubuta sunayen dukan maza ɗaya-ɗaya da suka kai shekara ashirin ko fiye da suka isa shiga soja, bisa ga iyalansu da kabilarsu da take a rubuce. ");
INSERT INTO hausa_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Jimillar maza daga mutanen Manasse 32,200 ne. ");
INSERT INTO hausa_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Daga zuriyar Benyamin. Aka rubuta sunayen dukan maza ɗaya-ɗaya da suka kai shekara ashirin ko fiye da suka isa shiga soja, bisa ga iyalansu da kabilarsu da take a rubuce. ");
INSERT INTO hausa_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Jimillar maza daga mutanen Benyamin 35,400 ne. ");
INSERT INTO hausa_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Daga zuriyar Dan. Aka rubuta sunayen dukan maza ɗaya-ɗaya da suka kai shekara ashirin ko fiye da suka isa shiga soja, bisa ga iyalansu da kabilarsu da take a rubuce. ");
INSERT INTO hausa_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Jimillar maza daga mutanen Dan 62,700 ne. ");
INSERT INTO hausa_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Daga zuriyar Asher. Aka rubuta sunayen dukan maza ɗaya-ɗaya da suka kai shekara ashirin ko fiye da suka isa shiga soja, bisa ga iyalansu da kabilarsu da take a rubuce. ");
INSERT INTO hausa_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Jimillar maza daga mutanen Asher 41,500 ne. ");
INSERT INTO hausa_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Daga zuriyar Naftali. Aka rubuta sunayen dukan maza ɗaya-ɗaya da suka kai shekara ashirin ko fiye da suka isa shiga soja, bisa ga iyalansu da kabilarsu da take a rubuce. ");
INSERT INTO hausa_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Jimillar maza daga mutanen Naftali kuwa 53,400 ne. ");
INSERT INTO hausa_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Waɗannan su ne mazan da Musa da Haruna, tare da shugabanni goma sha biyun nan na Isra’ila suka ƙidaya, kowa a madadin iyalinsa. ");
INSERT INTO hausa_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Dukan Isra’ilawan da suka kai shekara ashirin ko fiye da suka isa shiga soja, an ƙidaya su bisa ga iyalansu. ");
INSERT INTO hausa_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Jimillar kuwa ita ce mutum 603,550. ");
INSERT INTO hausa_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Ba a dai ƙidaya zuriyar Lawi tare da saura kabilan ba. ");
INSERT INTO hausa_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Ubangiji ya riga ya gaya wa Musa cewa, ");
INSERT INTO hausa_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Ka tabbatar ba ka ƙidaya mutanen Lawi ko kuma ka haɗe su tare a ƙidayan sauran Isra’ilawa ba. ");
INSERT INTO hausa_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","A maimakon haka sai ka naɗa Lawiyawa su lura da tabanakul Shaida, wato, kan dukan kayayyaki da kuma kome da yake na wuri mai tsarki. Za su ɗauko tabanakul da dukan kayayyakinsa; za su lura da shi, su kasance kewaye da shi. ");
INSERT INTO hausa_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Duk sa’ad da za a gusar da tabanakul, Lawiyawa ne za su saukar da shi; kuma duk sa’ad da za a kafa shi, Lawiyawa ne za su yi haka. Duk wani dabam da ya je kusa da shi za a kashe shi. ");
INSERT INTO hausa_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Sauran Isra’ilawa za su zauna ƙungiya-ƙungiya, kowane mutum a ƙungiyarsa daidai bisa ga ƙa’idarsa. ");
INSERT INTO hausa_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Amma Lawiyawa za su kafa sansaninsu kewaye da tabanakul na Shaida. Don kada fushi yă fāɗo a kan al’ummar Isra’ilawa. Hakkin Lawiyawa ne su kula da tabanakul na Shaida.” ");
INSERT INTO hausa_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Isra’ilawa suka yi duk waɗannan kamar dai yadda Ubangiji ya umarci Musa. ");
INSERT INTO hausa_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Ubangiji ya ce wa Musa da Haruna, ");
INSERT INTO hausa_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“Duk sa’ad da Isra’ilawa suka yi sansani, kowane mutum zai sauka a inda tutar ƙungiyar kabilarsa take. Sansanin zai kasance a kewaye da Tentin Sujada.” ");
INSERT INTO hausa_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Kabilar Yahuda za su yi sansani bisa ga ƙa’idarsu a gabas, wajen fitowar rana. Shugaban mutanen Yahuda kuwa shi ne Nashon ɗan Amminadab. ");
INSERT INTO hausa_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Yawan mutanen sashensa 74,600 ne. ");
INSERT INTO hausa_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Kabilar Issakar za su yi sansani biye da su. Shugabansu shi ne Netanel ɗan Zuwar. ");
INSERT INTO hausa_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Yawan mutanen sashensa 54,400 ne. ");
INSERT INTO hausa_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Kabilar Zebulun za su yi sansani biye da su. Shugabansu shi ne Eliyab ɗan Helon. ");
INSERT INTO hausa_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Yawan mutanen sashensa 57,400 ne. ");
INSERT INTO hausa_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Dukan mazan da aka ba su aiki a sansanin Yahuda bisa ga sashensu sun kai 186,400. Su ne za su ja gaba. ");
INSERT INTO hausa_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","A kudu, a nan ne sashe sansanin mutanen Ruben a ƙarƙashin ƙa’idarsu, za su yi sansani. Shugaban mutanen Ruben shi ne Elizur ɗan Shedeyur. ");
INSERT INTO hausa_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Yawan mutanen sashensa 46,500 ne. ");
INSERT INTO hausa_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Kabilar Simeyon za su yi sansani biye da su. Shugaban mutanensa shi ne Shelumiyel ɗan Zurishaddai. ");
INSERT INTO hausa_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Yawan mutanen sashensa 59,300 ne. ");
INSERT INTO hausa_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Kabilar Gad za su zama na biye. Shugaban mutanensa shi ne Eliyasaf ɗan Reyuwel. ");
INSERT INTO hausa_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Yawan mutanen sashensa 45,650 ne. ");
INSERT INTO hausa_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Dukan mazan da aka ba su aiki a sansanin Ruben, bisa ga sashensu sun kai 151,450. Su ne za su zama na biyu in za a tashi. ");
INSERT INTO hausa_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Sa’an nan Lawiyawa ɗauke da Tentin Sujada za su kasance a tsakiyar sansani sa’ad da aka tashi tafiya. Za su kama hanya kamar yadda aka dokace su su zauna a sansani, kowa a wurinsa a ƙarƙashin ƙa’idarsu. ");
INSERT INTO hausa_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Ta wajen yamma kuma sashen Efraim za su yi sansani a ƙarƙashin ƙa’idarsu. Shugaban mutanensa, shi ne Elishama ɗan Ammihud. ");
INSERT INTO hausa_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Yawan mutanen sashensa 40,500 ne. ");
INSERT INTO hausa_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Kabilar Manasse ce za tă zama ta biye. Shugabansu shi ne Gamaliyel ɗan Fedazur. ");
INSERT INTO hausa_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Yawan mutanen sashensa 32,200 ne. ");
INSERT INTO hausa_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Na biye da su su ne mutanen Benyamin. Shugaban mutanensu kuwa Abidan ɗan Gideyoni. ");
INSERT INTO hausa_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Yawan mutanen sashensa 35,400 ne. ");
INSERT INTO hausa_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Dukan mazan da aka ba su aiki a sansanin Efraim, bisa ga sashensu su kai 108,100 ne. Su ne za su zama na uku sa’ad da za a tashi. ");
INSERT INTO hausa_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","A arewa za a sami sashen sansanin Dan, a ƙarƙashin ƙa’idarsu. Shugabansu shi ne Ahiyezer ɗan Ammishaddai. ");
INSERT INTO hausa_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Yawan mutanen sashensa 62,700 ne. ");
INSERT INTO hausa_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Kabilar Asher ce za tă zama ta biye. Shugabansu shi ne Fagiyel ɗan Okran. ");
INSERT INTO hausa_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Yawan mutanen sashensa 41,500 ne. ");
INSERT INTO hausa_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Kabilar Naftali za su zama na biye da su. Shugaban mutanen kuwa shi ne Ahira ɗan Enan. ");
INSERT INTO hausa_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Yawan mutanen sashensa 53,400 ne ");
INSERT INTO hausa_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Dukan mazan da aka ba su aiki a sansanin Efraim, bisa ga sashensu su kai 157,600. Su ne za su zama na ƙarshe, ƙarƙashin ƙa’idarsu. ");
INSERT INTO hausa_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Waɗannan su ne Isra’ilawan da aka a ƙidaya bisa ga iyalansu. Dukansu da suke a sansani, mutane 603,550 ne. ");
INSERT INTO hausa_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Ba a dai ƙidaya Lawiyawa tare da sauran Isra’ilawa ba yadda Ubangiji ya umarci Musa. ");
INSERT INTO hausa_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Saboda haka Isra’ilawa suka yi duk ko mene ne da Ubangiji ya umarci Musa. Ta haka ne suka yi sansani a ƙarƙashin ƙa’idarsu kowanne tare da kabilarsa da danginsa. ");
INSERT INTO hausa_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Waɗannan su ne zuriyar Haruna da Musa a lokacin da Ubangiji ya yi magana da Musa a kan Dutsen Sinai. ");
INSERT INTO hausa_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Sunayen ’ya’yan Haruna su ne, Nadab ɗan fari, da Abihu, da Eleyazar da Itamar. ");
INSERT INTO hausa_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Waɗannan su ne sunayen ’ya’yan Haruna, shafaffun firistocin da aka naɗa domin su yi aiki firist. ");
INSERT INTO hausa_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Amma Nadab da Abihu suka fāɗi suka mutu a gaban Ubangiji a Hamadar Sinai a sa’ad da suka ƙona turare da haramtacciyar wuta a gabansa. Ba su kuwa da ’ya’ya; saboda haka Eleyazar da Itamar kaɗai suka yi aiki firist a zamanin mahaifinsu Haruna. ");
INSERT INTO hausa_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Ka kawo mutanen Lawi, ka kuma gabatar da su ga Haruna firist, don su taya shi aiki. ");
INSERT INTO hausa_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Za su yi wa Haruna da dukan al’umma aikace-aikace a Tentin Sujada, ta wurin yin aikin tabanakul. ");
INSERT INTO hausa_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Za su lura da dukan kayayyakin Tentin Sujada, suna cika hakkin Isra’ilawa ta wurin yin aiki a tabanakul. ");
INSERT INTO hausa_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Ka ba da Lawiyawa ga Haruna da ’ya’yansa; su ne za su zama Isra’ilawan da za a ba da su ɗungum gare shi. ");
INSERT INTO hausa_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Ka naɗa Haruna da ’ya’yansa su yi aiki firistoci; duk wanda ya yi shisshigi a wuri mai tsarki kuwa dole a kashe shi.” ");
INSERT INTO hausa_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Ubangiji ya kuma ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“Ga shi na ɗauki Lawiyawa daga cikin Isra’ilawa a maimakon ɗan fari na kowace mace a Isra’ila. Lawiyawa nawa ne, ");
INSERT INTO hausa_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","gama duk ’ya’yan fari nawa ne. Lokacin da karkashe duk ’ya’yan fari a Masar, na keɓe wa kaina kowane ɗan fari a Isra’ila, ko mutum, ko dabba. Za su zama nawa. Ni ne Ubangiji.” ");
INSERT INTO hausa_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Ubangiji ya yi magana da Musa a Hamadar Sinai ya ce, ");
INSERT INTO hausa_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“Ka ƙidaya Lawiyawa bisa ga iyalansu da kabilarsu. Ka ƙidaya kowane ɗan jinjiri mai wata ɗaya ko fiye.” ");
INSERT INTO hausa_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Saboda haka Musa ya ƙidaya su duka, kamar yadda maganar Ubangiji ta umarta. ");
INSERT INTO hausa_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Ga sunayen ’ya’yan Lawi, Gershon, Kohat da Merari. ");
INSERT INTO hausa_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Ga sunayen mutanen Gershon, Libni, da Shimeyi ");
INSERT INTO hausa_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Sunayen mutanen Kohat kuwa su ne, Amram, Izhar, Hebron da Uzziyel. ");
INSERT INTO hausa_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Dangin Merari su ne. Mali da Mushi. Ga kabilan Lawiyawa bisa ga iyalansu. ");
INSERT INTO hausa_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","A wajen Gershonawa, kabilarsa su ne Libniyawa, da Shimeyiyawa; waɗannan su ne mutanen Gershom. ");
INSERT INTO hausa_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Jimillar dukan jarirai maza daga wata ɗaya zuwa gaba da haihuwa su kai 7,500. ");
INSERT INTO hausa_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Kabilar Gershonawa za su yi sansani ta fuskar yamma, a bayan tabanakul. ");
INSERT INTO hausa_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Eliyasaf ɗan Layel shi ne shugaban iyalan Gershonawa. ");
INSERT INTO hausa_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","A Tentin Sujada, Gershonawa su ne za su lura da mazauni da tabanakul da kuma tentin, abubuwan rufensa, labule a ƙofar Tentin Sujada, ");
INSERT INTO hausa_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","da labulen filin da yake kewaye da tabanakul da kuma bagade, da igiyoyi, da kuma kowane abin da ya danganci aikinsu. ");
INSERT INTO hausa_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Kabilar Kohat su ne, Amramawa da Izharawa da Hebronawa da Uzziyelawa; waɗannan su ne kabilar Kohatawa. ");
INSERT INTO hausa_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Jimillar dukan jarirai maza daga wata ɗaya ko fiye, 8,600 ne. Kohatawa ne suke lura da wuri mai tsarki. ");
INSERT INTO hausa_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Kohatawa za su yi sansani a kudu da tabanakul. ");
INSERT INTO hausa_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Shugaban kabilar Kohatawa shi ne Elizafan ɗan Uzziyel. ");
INSERT INTO hausa_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Su ne da hakkin kula da akwatin alkawari, tebur, wurin ajiye fitila, bagade, kayayyakin wuri mai tsarki da ake amfani da su a sujada, labule, da kuma kome da ya danganci aikinsu. ");
INSERT INTO hausa_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Babban shugaban Lawiyawa shi ne Eleyazar ɗan Haruna, firist. An naɗa shi a kan waɗanda suke kula da wuri mai tsarki. ");
INSERT INTO hausa_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Kabilar Merari su ne Maliyawa da Mushiyawa; waɗannan su ne kabilar Merari. ");
INSERT INTO hausa_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Jimillar dukan jarirai maza daga wata ɗaya ko fiye, 6,200 ne. ");
INSERT INTO hausa_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Shugaban iyalan Merari shi ne Zuriyel ɗan Abihayil. Za su yi sansani arewa da tabanakul. ");
INSERT INTO hausa_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Kabilar Merari ne aka sa su lura da katakan tabanakul, sandunanta, dogayen sandunanta, tarukanta, dukan kayan aiki da kowane abin da ya danganci aikinsu, ");
INSERT INTO hausa_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","da ginshiƙai kewaye da filin tare da rammuka da turaku da igiyoyinsu. ");
INSERT INTO hausa_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Musa da Haruna da ’ya’yansu za su yi sansani gabas da tabanakul, wajen fitowar rana; a gaban Tentin Sujada. Su ne da hakkin lura da wuri mai tsarki a madadin Isra’ilawa. Duk wani wanda ba ya wannan aiki, ya kuma kusaci wuri mai tsarki, za a kashe shi. ");
INSERT INTO hausa_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Jimillar Lawiyawan da Musa da Haruna suka ƙidaya bisa ga umarnin Ubangiji bisa ga danginsu, haɗe da kowane jariri daga wata ɗaya ko fiye, 22,000 ne. ");
INSERT INTO hausa_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Sai Ubangiji ya ce wa Musa, “Ƙidaya dukan ’ya’yan fari na Isra’ilawa maza daga wata ɗaya da kuma fiye ka kuma rubuta sunayensu. ");
INSERT INTO hausa_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Ka ɗauko mini Lawiyawa a maimakon dukan ’ya’yan fari na Isra’ilawa, haka ma na dabbobi na Lawiyawa, a maimakon ’ya’yan fari na dabbobin Isra’ilawa. Ni ne Ubangiji.” ");
INSERT INTO hausa_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Haka Musa ya ƙidaya ’ya’yan fari na Isra’ilawa, yadda Ubangiji ya umarce shi. ");
INSERT INTO hausa_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Jimillar ’ya’yan fari maza daga wata ɗaya da kuma fiye, da aka rubuta bisa ga sunayensu, 22,273 ne. ");
INSERT INTO hausa_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Sai Ubangiji ya kuma yi magana da Musa ya ce, ");
INSERT INTO hausa_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Ka ɗauki Lawiyawa a maimakon dukan ’ya’yan fari na Isra’ila, dabbobin Lawiyawa kuma a maimakon dabbobinsu. Lawiyawa za su zama nawa. Ni ne Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Don a fanshi ’ya’yan fari 273 na Isra’ilawa da suka fi Lawiyawa yawa, ");
INSERT INTO hausa_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","ka karɓi shekel biyar domin kowannensu, bisa ga ma’aunin shekel na tsattsarkan wuri, wanda yake da nauyin gera ashirin. ");
INSERT INTO hausa_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Ka ba wa Haruna da ’ya’yansa kuɗin fansar da ya haura kai na ’ya’yan farin Isra’ilawa.” ");
INSERT INTO hausa_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Haka, Musa ya karɓi kuɗin fansar waɗanda suka haura yawan Lawiyawa. ");
INSERT INTO hausa_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Daga ’ya’yan fari na Isra’ilawa, ya karɓi azurfa masu nauyin shekel 1,365, bisa ga ma’aunin shekel na tsattsarkan wuri. ");
INSERT INTO hausa_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Sa’an nan Musa ya ba da kuɗin fansar ga Haruna da ’ya’yansa, yadda maganar Ubangiji ta umarce shi. ");
INSERT INTO hausa_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Ubangiji ya ce wa Musa da Haruna, ");
INSERT INTO hausa_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Ku yi ƙidaya Kohatawa daga Lawiyawa, bisa ga kabilarsu da iyalansu. ");
INSERT INTO hausa_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Ku ƙidaya dukan maza daga shekara talatin zuwa hamsin da suka zo domin aiki a Tentin Sujada. ");
INSERT INTO hausa_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","“Ga aikin Kohatawa a Tentin Sujada, kulawa da kayayyaki mafi tsarki. ");
INSERT INTO hausa_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Lokacin da za a tashi daga sansani, Haruna da ’ya’yansa za su shiga ciki su kunce labulen kāriya, su rufe Akwatin Alkawari da shi. ");
INSERT INTO hausa_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Sa’an nan su rufe shi da fatun shanun teku, su shimfiɗa zane mai ruwan shuɗi a bisansa, su sa masa sandunansa. ");
INSERT INTO hausa_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","“A bisa teburin Burodin Ajiyewa, za su shimfiɗa zane mai ruwan shuɗi, a kansa kuma su sa farantai, kwanoni da manyan kwanoni, da tuluna don hadayun sha; da burodin da zai ci gaba da kasancewa a kansa. ");
INSERT INTO hausa_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","A bisa waɗannan za su shimfiɗa jan zane, su rufe su da fatun shanun teku, su kuma zura masa sandunansa. ");
INSERT INTO hausa_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“Za su ɗauki zane mai ruwan shuɗi su rufe wurin ajiye fitilan da yake don fitilu, tare da fitilunsa, lagwaninsa da farantansa, da dukan tulunansa don man amfaninsu. ");
INSERT INTO hausa_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Sa’an nan su naɗe shi da kuma dukan kayayyakinsa a cikin fatar shanun teku, su sa shi a kan sandan ɗaukarsa. ");
INSERT INTO hausa_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","“A kan bagaden zinariya, za su shimfiɗa zane mai ruwan shuɗi, su kuma rufe shi da fatar shanun teku, sai a zura masa sandunansa. ");
INSERT INTO hausa_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","“Za su ɗauki dukan kayayyakin da ake amfani da su a wuri mai tsarki, su nannaɗe su da zane mai ruwan shuɗi, su rufe shi da fatar shanun teku, sa’an nan a sa su a kan sandan ɗaukarsa. ");
INSERT INTO hausa_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","“Za su kwashe tokar da take a bagaden tagulla, su shimfiɗa zane mai ruwan shuɗi a bisansa. ");
INSERT INTO hausa_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Sa’an nan su sa a kansa dukan kayayyakin da aka yi amfani da su a bagaden, haɗe da farantai don wuta, cokula masu yatsu don nama, manyan cokula, da darunan yayyafawa. A kansa za su shimfiɗa murfi na fatun shanun teku, su zura sandunan ɗaukarsa. ");
INSERT INTO hausa_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","“Bayan Haruna da ’ya’yansa suka gama rufe kayayyaki masu tsarki da dukan abubuwa masu tsarki, sa’ad da kuma aka shirya tashi daga sansani, sai Kohatawa su zo gaba, su ɗauka. Amma kada su taɓa abubuwa masu tsarki, don kada su mutu. Kohatawa za su ɗauki abubuwan da suke cikin Tentin Sujada. ");
INSERT INTO hausa_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“Eleyazar ɗan Haruna firist zai lura da man fitila da turare da hadaya ta gari na kullum da kuma keɓaɓɓen mai. Shi ne zai lura da dukan tabanakul da duk abin da yake cikinsa da kuma kayayyaki da abubuwan masu tsarki.” ");
INSERT INTO hausa_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Ubangiji ya ce wa Musa da Haruna, ");
INSERT INTO hausa_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Ku tabbata cewa ba a kawar da zuriyar Kohatawa daga Lawiyawa ba. ");
INSERT INTO hausa_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Saboda su rayu, kada su mutu sa’ad da suka zo kusa da abubuwa mafi tsarki, a yi musu wannan, wato, Haruna da ’ya’yansa za su shiga wuri mai tsarki su ba wa kowane mutum aikinsa da kuma abin da zai ɗauka. ");
INSERT INTO hausa_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Amma kada Kohatawa su shiga don su dubi abubuwa masu tsarki, ko na ɗan ƙanƙanin lokaci, in ba haka ba za su mutu.” ");
INSERT INTO hausa_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Ka ƙidaya mutanen Gershon bisa ga iyalansu da kabilarsu. ");
INSERT INTO hausa_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Ka ƙidaya maza masu shekara talatin zuwa hamsin waɗanda sukan zo hidimar aiki a Tentin Sujada. ");
INSERT INTO hausa_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","“Ga aikin kabilar Gershonawa yayinda suke aiki, suke kuma ɗaukar kaya. ");
INSERT INTO hausa_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Za su ɗauki labulen tabanakul, Tentin Sujada, kayan da za a rufe shi, da kuma kayan da za a rufe shi daga waje na fatun rufuwa na shanun teku, labulen ƙofar Tentin Sujada, ");
INSERT INTO hausa_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","labulen filin da yake kewaye da tabanakul da bagade, labulen ƙofa, igiyoyi da kuma dukan abubuwan da ake amfani da su wajen hidima. Geshonawa za su yi dukan abin da ya kamata a yi da waɗannan abubuwa. ");
INSERT INTO hausa_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Dukan hidimominsu, ko na ɗauko, ko kuma na yin wani aiki, za a yi su ne bisa ga umarnin Haruna da ’ya’yansa. Za ka ba su dukan kayan da za su ɗauka a matsayin hakkinsu. ");
INSERT INTO hausa_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Wannan shi ne hidimar da kabilar Gershonawa za su yi a Tentin Sujada. Ayyukansu za su kasance bisa ga umarnin Itamar ɗan Haruna firist. ");
INSERT INTO hausa_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“Ka ƙidaya kabilar Merari bisa ga kabilarsu da iyalansu. ");
INSERT INTO hausa_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Ka ƙidaya maza daga masu shekara talatin zuwa hamsin waɗanda sukan zo hidimar aiki a Tentin Sujada. ");
INSERT INTO hausa_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Ga aikinsu sa’ad da suke hidima a Tentin Sujada, za su ɗauki katakan tabanakul, sandunansa da dogayen sandunansa, da rammukansa, ");
INSERT INTO hausa_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","har ma da dogayen sandunan kewayen filin da rammukansu, turakun tenti, igiyoyi, da dukan kayayyaki, da kuma dukan abubuwan da suke dangane da amfaninsu. Ka ba wa kowane mutum ayyuka na musamman da zai yi. ");
INSERT INTO hausa_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Wannan ce hidimar da mutanen Merari za su yi a aikin Tentin Sujada, a ƙarƙashin jagorancin Itamar ɗan Haruna, firist.” ");
INSERT INTO hausa_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Musa, Haruna da kuma shugabannin jama’a, suka ƙidaya Kohatawa ta kabilarsu da kuma iyalansu. ");
INSERT INTO hausa_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","Dukan maza daga shekara talatin zuwa hamsin waɗanda sukan zo hidimar aiki a Tentin Sujada, ");
INSERT INTO hausa_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","da aka ƙidaya, kabila-kabila, su 2,750 ne. ");
INSERT INTO hausa_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Jimillar dukan waɗanda suke na kabilan Kohatawa, waɗanda suka yi hidimar aiki a Tentin Sujada ke nan. Musa da Haruna sun ƙidaya su bisa ga umarnin Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Aka ƙidaya mazan Gershonawa ta kabilansu da kuma iyalansu. ");
INSERT INTO hausa_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","Dukan maza daga shekara talatin zuwa hamsin waɗanda sukan zo hidimar aiki a Tentin Sujada, ");
INSERT INTO hausa_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","da aka ƙidaya kabila-kabila da kuma iyali-iyali, su 2,630 ne. ");
INSERT INTO hausa_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Jimillar waɗanda suke na kabilar Gershonawa ke nan, waɗanda suka yi hidimar aiki a Tentin Sujada. Musa da Haruna sun ƙidaya su bisa ga umarnin Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Aka ƙidaya mazan Merari ta kabilarsu da kuma iyalansu. ");
INSERT INTO hausa_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","Dukan maza daga shekara talatin zuwa hamsin waɗanda sukan zo hidimar aiki a Tentin Sujada, ");
INSERT INTO hausa_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","da aka ƙidaya kabila-kabila, su 3,200 ne. ");
INSERT INTO hausa_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Jimillar waɗanda suke na kabilar Merari ke nan. Musa da Haruna suka ƙidaya su bisa ga umarnin Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Saboda haka, Musa, Haruna da shugabannin Isra’ila, suka ƙidaya dukan Lawiyawa kabila-kabila da kuma iyali-iyali. ");
INSERT INTO hausa_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","Dukan maza daga shekara talatin zuwa hamsin waɗanda sukan zo hidimar aiki da kuma ɗaukar Tentin Sujada ");
INSERT INTO hausa_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","jimillarsu ta kai 8,580. ");
INSERT INTO hausa_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Bisa ga umarnin Ubangiji ta wurin Musa, aka ba kowa aikinsa, aka kuma faɗa musu abin da za su ɗauka. Ta haka aka ƙidaya su, yadda Ubangiji ya umarci Musa. ");
INSERT INTO hausa_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Ka umarci Isra’ilawa su kori duk wanda yake da ciwon fatan jiki, ko mai ɗiga na kowane iri, ko wanda ya ƙazantu ta wurin taɓa gawa, daga cikin sansani. ");
INSERT INTO hausa_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Ka kori maza da mata ma; ka kai su bayan sansani domin kada su ƙazantar da sansani inda nake zama a cikinsu.” ");
INSERT INTO hausa_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Isra’ilawa suka yi haka; suka kore su daga sansanin. Suka aikata yadda dai Ubangiji ya umarci Musa. ");
INSERT INTO hausa_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“Gaya wa Isra’ilawa, ‘Sa’ad da namiji ko mace ya yi wa ɗan’uwansa laifi ta kowace hanya, ta yin haka, ya yi rashin aminci ga Ubangiji, mutumin kuwa ya yi laifi ke nan ");
INSERT INTO hausa_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","kuma dole yă furta zunubin da ya yi. Dole yă yi biya cikakkiyar diyya saboda laifinsa, yă ƙara kashi ɗaya bisa biyar a kai, yă kuma bayar da shi duka ga wanda ya yi wa laifin. ");
INSERT INTO hausa_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Amma in mutumin da aka yi wa laifin ba shi da ɗan’uwa na kusa da za a biya diyya saboda laifin, sai diyyar tă zama ta Ubangiji, dole kuma a ba wa firist, haɗe da ragon da za a yi kafara da shi. ");
INSERT INTO hausa_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Dukan tsarkakakkun abubuwan da Isra’ilawa suka kawo wa firist za su zama nasa. ");
INSERT INTO hausa_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Kowace tsarkakakkiyar kyauta da mutum ya kawo nasa ne, sai dai abin da ya ba wa firist, zai zama na firist.’ ” ");
INSERT INTO hausa_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Sai Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“Yi magana da Isra’ilawa, ka ce musu, ‘In matar wani ta kauce, ta kuma yi rashin aminci gare shi ");
INSERT INTO hausa_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","ta wurin kwana da wani dabam, wannan kuwa ya kasance a ɓoye ga mijinta, rashin tsarkinta kuwa bai tonu ba (da yake babu shaida, ba a kuma kama ta tana yi ba), ");
INSERT INTO hausa_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","in kuma kishi ya sha kan mijinta kuma tana da ƙazanta, ko kuwa idan yana kishi yana kuma zatonta ko ma ba ta da ƙazanta ");
INSERT INTO hausa_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","mijin zai kai matansa a gaban firist, yă kuma kawo hadayar abubuwan da ake bukata; abubuwa kamar, garin sha’ir garwa ɗaya, amma kada yă zuba mai a kan garin sha’ir, kada kuma yă sa turaren wuta a kansa, domin hadaya ce ta miji mai tuhumar matarsa da aka kawo domin gaskiya tă fito fili. ");
INSERT INTO hausa_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“ ‘Firist zai kawo ta, yă sa tă tsaya a gaban Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Sa’an nan zai ɗebi ruwa mai tsarki a tulun laka, yă zuba ƙurar da ya ɗebo daga daɓen tabanakul a cikin ruwan. ");
INSERT INTO hausa_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Bayan da firist ya sa matan ta tsaya a gaban Ubangiji, sai yă kunce gashin kanta, yă kuma sa hadaya ta gari don tunawa a hannuwanta, hadayar gari ce ta kishi, yayinda shi kansa zai riƙe ruwa mai ɗaci, mai jawo la’ana. ");
INSERT INTO hausa_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Sa’an nan firist zai sa tă yi rantsuwa, yă kuma ce mata, “In ba wani mutumin da ya kwana da ke kuma ba ki kauce kin ƙazantar da kanki yayinda kike auren mijinki ba, kada wannan ruwa mai ɗaci, mai jawo la’ana, yă cuce ki. ");
INSERT INTO hausa_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Amma in kin kauce yayinda kike auren mijinki, kika kuma ƙazantar da kanki ta wurin kwana da wani dabam da ba mijinki ba,” ");
INSERT INTO hausa_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","(a nan firist zai sa macen a ƙarƙashin la’anar rantsuwa cewa) “bari Ubangiji yă sa mutanenki su la’ance ki, su kuma yi Allah wadai da ke, sa’ad da Ubangiji ya sa cinyarki ta shanye, cikinki kuma ya kumbura. ");
INSERT INTO hausa_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Bari wannan ruwa mai jawo la’ana, yă shiga jikinki saboda cikinki yă kumbura, cinyarki kuma yă shanye.” “ ‘Sai macen tă ce, “Amin. Bari yă zama haka.” ");
INSERT INTO hausa_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“ ‘Firist zai rubuta waɗannan la’anoni a littafi, sa’an nan yă wanke su cikin ruwa mai ɗaci. ");
INSERT INTO hausa_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Sai yă sa macen tă sha ruwa mai ɗaci, mai jawo la’ana, wannan ruwa kuwa zai shiga cikinta yă kawo mata wahala mai zafi. ");
INSERT INTO hausa_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Firist zai karɓi hadaya ta gari don kishi daga hannuwanta, yă kaɗa shi a gaban Ubangiji sa’an nan yă kawo a bagade. ");
INSERT INTO hausa_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Sa’an nan firist zai ɗiba hatsi na hadaya cike da hannunsa don hadayar tunawa, yă kuma ƙone a bagade; bayan haka sai yă sa macen tă sha ruwan. ");
INSERT INTO hausa_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","In ta ƙazantar da kanta ta kuma ci amanar mijinta, to, yayinda aka sa tă sha ruwa mai jawo la’ana, ruwan zai shiga cikinta, yă jawo mata wahala mai zafi; cikinta zai kumbura, cinyarta kuma yă shanye, tă kuwa zama la’ananniya a cikin mutanenta. ");
INSERT INTO hausa_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Amma fa, in macen ba tă ƙazantar da kanta ba, ba tă kuma da ƙazanta, za a kuɓutar da ita daga laifin, za tă kuma iya haihuwa. ");
INSERT INTO hausa_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“ ‘Wannan dai, ita ce dokar kishi sa’ad da mace ta kauce, ta kuma ƙazantar da kanta yayinda take aure da mijinta, ");
INSERT INTO hausa_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","ko kuma sa’ad da mijin yana kishi domin yana shakkar matarsa. Firist zai sa tă tsaya a gaban Ubangiji, yă kuma yi amfani da wannan doka gaba ɗaya a kanta. ");
INSERT INTO hausa_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Mijin zai zama marar laifi daga kowane laifi, amma matar za tă ɗauki muguntarta, idan ta yi laifin.’ ” ");
INSERT INTO hausa_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“Yi magana da Isra’ilawa, ka ce musu, ‘In mace, ko namiji yana so yă yi alkawari na musamman, alkawarin zaman keɓaɓɓe ga Ubangiji, a matsayin Banazare, ");
INSERT INTO hausa_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","dole yă keɓe kansa daga ruwan inabi, ko daga waɗansu abubuwa sha masu sa maye, kada kuma yă sha ruwan tsamin da aka yi daga ruwan inabi, ko daga waɗansu abubuwa sha masu sa maye. Ba zai sha ruwan ’ya’yan inabi, ko yă ci ’ya’yan inabi ɗanye ko busasshe ba. ");
INSERT INTO hausa_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Muddin yana Banazare, ba zai ci wani abin da ya fito daga ’ya’yan inabi ba, ko ƙwayar inabi, ko ɓawonsa ma. ");
INSERT INTO hausa_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“ ‘A dukan lokacin da yake a kan alkawarin keɓewarsa, reza ba zai taɓa kansa. Dole yă kasance da tsarki har ƙarshen keɓewarsa ga Ubangiji; tilas yă bar gashin kansa yă yi tsawo. ");
INSERT INTO hausa_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","A dukan kwanakin keɓewarsa ga Ubangiji, Banazarin ba zai yi kusa da gawa ba. ");
INSERT INTO hausa_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Ko da ma gawar ta mahaifinsa ce, ko ta mahaifiyarsa, ko ta ɗan mahaifiyarsa, ko kuma ta ’yar’uwarsa ce, ba zai ƙazantar da kansa saboda su ba, domin alamar keɓewarsa ga Allah tana kansa. ");
INSERT INTO hausa_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","A dukan kwanakin keɓewarsa, an tsarkake shi ga Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“ ‘In farat ɗaya wani ya mutu kusa da shi, to, keɓewarsa ta ƙazantu, dole yă aske kansa a ranar tsarkakewarsa, a rana ta bakwai. ");
INSERT INTO hausa_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Sa’an nan a rana ta takwas, tilas yă kawo wa firist ’yan kurciyoyi biyu, ko kuma ’yan tattabarai biyu a bakin ƙofar Tentin Sujada. ");
INSERT INTO hausa_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Firist kuwa zai miƙa ɗaya don hadaya ta zunubi, ɗayan kuma don hadaya ta ƙonawa, yă yi kafara dominsa, gama ya yi zunubi ta dalilin gawar. A wannan rana zai sāke keɓe kansa. ");
INSERT INTO hausa_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Dole yă keɓe kansa ga Ubangiji, har kwanakin keɓewarsa, kuma dole yă kawo ɗan rago bana ɗaya a matsayin hadayar laifi. Kwanakin baya ba sa cikin lissafi, domin ya ƙazantu a lokacin keɓewarsa. ");
INSERT INTO hausa_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“ ‘To, ga doka saboda Banazare sa’ad da kwanakin keɓewarsa suka gama. Za a kawo shi a bakin ƙofar Tentin Sujada. ");
INSERT INTO hausa_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","A can zai miƙa hadayunsa ga Ubangiji. Hadayun kuwa su ne, ɗan rago, bana ɗaya marar lahani don hadaya ta ƙonawa, ’yar tunkiya, bana ɗaya marar lahani na hadaya don zunubi, rago marar lahani don hadaya ta salama, ");
INSERT INTO hausa_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","tare da hadayu na hatsi da hadayu na sha, da kuma kwando burodi marar yisti, ƙosai da aka yi da lallausan gari kwaɓaɓɓe da mai, da kuma wainan da aka barbaɗa da mai. ");
INSERT INTO hausa_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","“ ‘Firist zai kawo su a gaban Ubangiji, yă miƙa hadaya don zunubi da hadaya ta ƙonawa. ");
INSERT INTO hausa_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Zai miƙa kwandon burodi marar yisti, yă kuma miƙa ɗan ragon hadaya ta salama tare da hadaya ta gari, da hadaya ta sha ga Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","“ ‘Sa’an nan a ƙofar Tentin Sujada, dole Banazaren yă aske gashin da ya alamta keɓewarsa, yă kwashe gashin, yă zuba a cikin wutar da take ƙarƙashin hadaya ta salama. ");
INSERT INTO hausa_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","“ ‘Bayan Banazaren ya aske gashinsa da ya alamta keɓewa, firist zai ɗauki dafaffiyar kafaɗar rago, da ƙosai da kuma waina daga cikin kwando waɗanda duka biyu marar yisti ne, yă sa su a tafin hannun keɓaɓɓen. ");
INSERT INTO hausa_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Firist zai kaɗa su a gaban Ubangiji, hadaya ce ta kaɗawa; mai tsarki ne kuma, zai zama na firist, tare da ƙirjin da aka kaɗa da kuma cinyar da aka kawo. Bayan haka, Banazaren zai iya shan ruwan inabi. ");
INSERT INTO hausa_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“ ‘Wannan ita ce dokar Banazare wanda ya yi alkawari ga Ubangiji bisa ga keɓewarsa, tare da duk abin da zai iya bayarwa. Tilas yă cika alkawarin da ya yi bisa ga dokar zaman Banazare.’ ” ");
INSERT INTO hausa_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Gaya wa Haruna da ’ya’yansa, ‘Ga yadda za ku albarkaci Isra’ilawa. Za ku ce musu, ");
INSERT INTO hausa_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","“ ‘ “Ubangiji yă albarkace ku, yă kuma kiyaye ku; ");
INSERT INTO hausa_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Ubangiji yă sa fuskarsa ta haskaka a kanku, yă kuma yi muku alheri; ");
INSERT INTO hausa_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Ubangiji yă dube ku da idon rahama, yă kuma ba ku salama.” ’ ");
INSERT INTO hausa_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","“Da haka za su sa sunana a kan Isra’ilawa, ni kuma zan albarkace su.” ");
INSERT INTO hausa_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Sa’ad da Musa ya gama kafa tabanakul, sai ya shafe shi da mai, ya tsarkake shi tare da dukan kayayyakinsa, ya kuma shafe bagaden da mai, ya tsarkake shi da dukan kayayyakinsa. ");
INSERT INTO hausa_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Sa’an nan shugabannin Isra’ila, wato, shugabannin iyalai waɗanda suke shugabancin kabilan da aka ƙidaya, suka miƙa hadayu. ");
INSERT INTO hausa_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Suka kawo kyautansu a gaban Ubangiji. Kyautayin kuwa su ne, kekunan yaƙi shida da aka rufe, da shanu goma sha biyu, saniya guda daga kowane shugaba, da kuma keken yaƙi guda daga shugabanni biyu. Suka miƙa waɗannan a gaban tabanakul. ");
INSERT INTO hausa_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Ka karɓi abubuwan nan daga gare su, domin a yi amfani da su a aikin Tentin Sujada. Ka ba da su ga Lawiyawa, a ba kowane mutum bisa ga aikinsa.” ");
INSERT INTO hausa_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Haka fa Musa ya ɗauki kekunan yaƙi da shanun ya ba wa Lawiyawa. ");
INSERT INTO hausa_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Ya ba wa Gershonawa, kekunan yaƙi biyu da shanu huɗu bisa ga aikinsu, ");
INSERT INTO hausa_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","ya kuma ya ba wa kabilar Merari kekunan yaƙi huɗu da shanu takwas bisa ga aikinsu. Aka ba da su duka a ƙarƙashin ikon Itamar ɗan Haruna, firist. ");
INSERT INTO hausa_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Amma Musa bai ba wa Kohatawa kome ba, gama aikinsu shi ne lura da kayayyaki masu tsarki waɗanda ake ɗauka a kafaɗa. ");
INSERT INTO hausa_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Sa’ad da aka shafe bagaden da mai, sai shugabannin suka kawo hadayunsu saboda keɓewarsa, suka miƙa su a bagaden. ");
INSERT INTO hausa_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Gama Ubangiji ya riga ya gaya wa Musa cewa, “Kowace rana, shugaba guda zai kawo hadayarsa saboda keɓewar bagade.” ");
INSERT INTO hausa_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Wanda ya kawo hadayarsa a rana ta farko shi ne Nashon ɗan Amminadab, shugaban mutanen Yahuda. ");
INSERT INTO hausa_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Hadayar da ya kawo ita ce, faranti guda ɗaya na azurfa, nauyinsa shekel ɗari ɗaya da talatin, da kuma daro na yayyafawa na azurfa, nauyinsa shekel saba’in, dukan biyu, an auna su bisa ga ma’aunin shekel na tsattsarkan wuri ne, kowannensu cike da lallausan gari, haɗe da mai kamar hadaya ta gari; ");
INSERT INTO hausa_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","ya kawo kwanon zinariya ɗaya, mai nauyin shekel goma, cike da turaren hayaƙi; ");
INSERT INTO hausa_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","da ƙaramin bijimi guda ɗaya, tunkiya ɗaya, da rago, dukansu bana ɗaya-ɗaya domin hadaya ta ƙonawa; ");
INSERT INTO hausa_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","ya kuma kawo bunsuru ɗaya domin hadaya don zunubi; ");
INSERT INTO hausa_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","da shanu biyu, raguna biyar, bunsurai biyar da kuma ’yan raguna biyar dukansu bana ɗaya-ɗaya, a miƙa su hadaya ta salama. Wannan ita ce hadayar Nashon ɗan Amminadab. ");
INSERT INTO hausa_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","A rana ta biyu, Netanel ɗan Zuwar, shugaban mutanen Issakar, ya kawo hadayarsa. ");
INSERT INTO hausa_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Hadayar da ya kawo ita ce, faranti guda ɗaya na azurfa, nauyinsa shekel ɗari ɗaya da talatin, da kuma daro na yayyafawa na azurfa, nauyinsa shekel saba’in, dukan biyu, an auna su bisa ga ma’aunin shekel na tsattsarkan wuri, kowannensu cike da lallausan gari, haɗe da mai kamar hadaya ta gari; ");
INSERT INTO hausa_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","ya kuma kawo kwanon zinariya ɗaya mai nauyin shekel, goma cike da turaren hayaƙi; ");
INSERT INTO hausa_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","da ƙaramin bijimi guda ɗaya, tunkiya ɗaya da rago, dukansu bana ɗaya-ɗaya domin hadaya ta ƙonawa; ");
INSERT INTO hausa_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","ya kuma kawo bunsuru ɗaya domin hadaya don zunubi; ");
INSERT INTO hausa_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","da shanu biyu, raguna biyar, bunsurai biyar da kuma ’yan raguna biyar dukansu bana ɗaya-ɗaya, a miƙa su hadaya ta salama. Wannan ita ce hadayar Netanel ɗan Zuwar. ");
INSERT INTO hausa_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","A rana ta uku, Eliyab ɗan Helon, shugaban mutanen Zebulun, ya kawo hadayarsa. ");
INSERT INTO hausa_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Hadayar da ya kawo ita ce, faranti guda ɗaya na azurfa, nauyinsa shekel ɗari ɗaya da talatin, da kuma daro na yayyafawa na azurfa, nauyinsa shekel saba’in, dukan biyu, an auna su bisa ga ma’aunin shekel na tsattsarkan wuri, kowannensu cike da lallausan gari, haɗe da mai kamar hadaya ta gari; ");
INSERT INTO hausa_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","ya kuma kawo kwanon zinariya ɗaya, mai nauyin shekel goma, cike da turaren hayaƙi; ");
INSERT INTO hausa_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","da ƙaramin bijimi guda ɗaya, tunkiya ɗaya, da rago, dukansu bana ɗaya-ɗaya domin hadaya ta ƙonawa; ");
INSERT INTO hausa_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","ya kuma kawo bunsuru ɗaya domin hadaya don zunubi; ");
INSERT INTO hausa_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","da shanu biyu, raguna biyar, bunsurai biyar da kuma ’yan raguna biyar, dukansu bana ɗaya-ɗaya, a miƙa su hadaya ta salama. Wannan ita ce hadayar Eliyab ɗan Helon. ");
INSERT INTO hausa_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","A ranan ta huɗu, Elizur ɗan Shedeyur, shugaban mutanen Ruben, ya kawo hadayarsa. ");
INSERT INTO hausa_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Hadayar da ya kawo ita ce, faranti guda ɗaya na azurfa, nauyinsa shekel ɗari ɗaya da talatin, da kuma daro na yayyafawa na azurfa, nauyinsa shekel saba’in, dukan biyu, an auna su bisa ga ma’aunin shekel na tsattsarkan wuri, kowannensu cike da lallausan gari, haɗe da mai kamar hadaya ta gari; ");
INSERT INTO hausa_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","ya kuma kawo kwanon zinariya ɗaya mai nauyin shekel goma, cike da turaren hayaƙi; ");
INSERT INTO hausa_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","da ƙaramin bijimi guda ɗaya, tunkiya ɗaya, da rago, dukansu bana ɗaya-ɗaya domin hadaya ta ƙonawa; ");
INSERT INTO hausa_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","ya kuma kawo bunsuru ɗaya domin hadaya don zunubi; ");
INSERT INTO hausa_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","da shanu biyu, raguna biyar, bunsurai biyar da kuma ’yan raguna biyar, dukansu bana ɗaya-ɗaya, a miƙa su hadaya ta salama. Wannan ita ce hadayar Elizur ɗan Shedeyur. ");
INSERT INTO hausa_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","A rana ta biyar, Shelumiyel ɗan Zurishaddai, shugaban mutanen Simeyon, ya kawo hadayarsa. ");
INSERT INTO hausa_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Hadayar da ya kawo ita ce, faranti guda ɗaya na azurfa, nauyinsa shekel ɗari ɗaya da talatin, da kuma daro na yayyafawa na azurfa, nauyinsa shekel saba’in, dukan biyu, an auna su bisa ga ma’aunin shekel na tsattsarkan wuri, kowannensu cike da lallausan gari, haɗe da mai kamar hadaya ta gari; ");
INSERT INTO hausa_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","ya kuma kawo kwanon zinariya ɗaya mai nauyin shekel goma, cike da turaren hayaƙi; ");
INSERT INTO hausa_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","da ƙaramin bijimi guda ɗaya, tunkiya ɗaya, da rago, dukansu bana ɗaya-ɗaya domin hadaya ta ƙonawa; ");
INSERT INTO hausa_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","ya kuma kawo bunsuru ɗaya domin hadaya don zunubi; ");
INSERT INTO hausa_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","da shanu biyu, raguna biyar, bunsurai biyar da kuma ’yan raguna biyar, dukansu bana ɗaya-ɗaya, a miƙa su hadaya ta salama. Wannan ita ce hadayar Shelumiyel ɗan Zurishaddai. ");
INSERT INTO hausa_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","A rana ta shida, Eliyasaf ɗan Deyuwel, shugaban mutanen Gad, ya kawo hadayarsa. ");
INSERT INTO hausa_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Hadayar da ya kawo ita ce, faranti guda ɗaya na azurfa, nauyinsa shekel ɗari ɗaya da talatin, da kuma daro na yayyafawa na azurfa, nauyinsa shekel saba’in, dukan biyu, an auna su bisa ga ma’aunin shekel na tsattsarkan wuri, kowannensu cike da lallausan gari, haɗe da mai kamar hadaya ta gari; ");
INSERT INTO hausa_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","ya kuma kawo kwanon zinariya ɗaya mai nauyin shekel goma, cike da turaren hayaƙi; ");
INSERT INTO hausa_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","da ƙaramin bijimi guda ɗaya, tunkiya ɗaya, da rago, dukansu bana ɗaya-ɗaya domin hadaya ta ƙonawa; ");
INSERT INTO hausa_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","ya kuma kawo bunsuru ɗaya domin hadaya don zunubi; ");
INSERT INTO hausa_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","da shanu biyu, raguna biyar, bunsurai biyar da kuma ’yan raguna biyar, dukansu bana ɗaya-ɗaya, a miƙa su hadaya ta salama. Wannan ita ce hadayar Eliyasaf ɗan Deyuwel. ");
INSERT INTO hausa_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","A rana ta bakwai, Elishama ɗan Ammihud, shugaban mutanen Efraim, ya kawo hadayarsa. ");
INSERT INTO hausa_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Hadayar da ya kawo ita ce, faranti guda ɗaya na azurfa, nauyinsa shekel ɗari ɗaya da talatin, da kuma daro na yayyafawa na azurfa, nauyinsa shekel saba’in, dukan biyu, an auna su bisa ga ma’aunin shekel na tsattsarkan wuri, kowannensu cike da lallausan gari, haɗe da mai kamar hadaya ta gari; ");
INSERT INTO hausa_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","kwanon zinariya ɗaya mai nauyin shekel goma, cike da turaren hayaƙi; ");
INSERT INTO hausa_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","da ƙaramin bijimi guda ɗaya, tunkiya ɗaya, da rago, dukansu bana ɗaya-ɗaya domin hadaya ta ƙonawa; ");
INSERT INTO hausa_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","ya kuma kawo bunsuru ɗaya domin hadaya don zunubi; ");
INSERT INTO hausa_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","da shanu biyu, raguna biyar, bunsurai biyar da kuma ’yan raguna biyar, dukansu bana ɗaya-ɗaya, a miƙa su hadaya ta salama. Wannan ita ce hadayar Elishama ɗan Ammihud. ");
INSERT INTO hausa_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","A rana ta takwas, Gamaliyel ɗan Fedazur, shugaban mutanen Manasse, ya kawo hadayarsa. ");
INSERT INTO hausa_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Hadayar da ya kawo ita ce, faranti guda ɗaya na azurfa, nauyinsa shekel ɗari ɗaya da talatin, da kuma daro na yayyafawa na azurfa, nauyinsa shekel saba’in, dukan biyu, an auna su bisa ga ma’aunin shekel na tsattsarkan wuri, kowannensu cike da lallausan gari, haɗe da mai kamar hadaya ta gari; ");
INSERT INTO hausa_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","kwanon zinariya ɗaya mai nauyin shekel goma, cike da turaren hayaƙi; ");
INSERT INTO hausa_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","da ƙaramin bijimi guda ɗaya, tunkiya ɗaya, da rago, dukansu bana ɗaya-ɗaya domin hadaya ta ƙonawa; ");
INSERT INTO hausa_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","ya kuma kawo bunsuru ɗaya domin hadaya don zunubi; ");
INSERT INTO hausa_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","da shanu biyu, raguna biyar, bunsurai biyar da kuma ’yan raguna biyar, dukansu bana ɗaya-ɗaya, a miƙa su hadaya ta salama. Wannan ita ce hadayar Gamaliyel ɗan Fedazur. ");
INSERT INTO hausa_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","A rana ta tara, Abidan ɗan Gideyoni, shugaban mutanen Benyamin, ya kawo hadayarsa. ");
INSERT INTO hausa_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Hadayar da ya kawo ita ce, faranti guda ɗaya na azurfa, nauyinsa shekel ɗari ɗaya da talatin, da kuma daro na yayyafawa na azurfa, nauyinsa shekel saba’in, dukan biyu, an auna su bisa ga ma’aunin shekel na tsattsarkan wuri, kowannensu cike da lallausan gari, haɗe da mai kamar hadaya ta gari; ");
INSERT INTO hausa_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","kwanon zinariya ɗaya mai nauyin shekel goma, cike da turaren hayaƙi; ");
INSERT INTO hausa_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","da ƙaramin bijimi guda ɗaya, tunkiya ɗaya, da rago, dukansu bana ɗaya-ɗaya domin hadaya ta ƙonawa; ");
INSERT INTO hausa_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","ya kuma kawo bunsuru ɗaya domin hadaya don zunubi; ");
INSERT INTO hausa_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","da shanu biyu, raguna biyar, bunsurai biyar da kuma ’yan raguna biyar, dukansu bana ɗaya-ɗaya, a miƙa su hadaya ta salama. Wannan ita ce hadayar Abidan ɗan Gideyoni. ");
INSERT INTO hausa_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","A rana ta goma, Ahiyezer ɗan Ammishaddai, shugaban mutanen Dan, ya kawo hadayarsa. ");
INSERT INTO hausa_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Hadayar da ya kawo ita ce, faranti guda ɗaya na azurfa, nauyinsa shekel ɗari ɗaya da talatin, da kuma daro na yayyafawa na azurfa, nauyinsa shekel saba’in, dukan biyu, an auna su bisa ga ma’aunin shekel na tsattsarkan wuri, kowannensu cike da lallausan gari, haɗe da mai kamar hadaya ta gari; ");
INSERT INTO hausa_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","kwanon zinariya ɗaya mai nauyin shekel goma, cike da turaren hayaƙi; ");
INSERT INTO hausa_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","da ƙaramin bijimi guda ɗaya, tunkiya ɗaya, da rago, dukansu bana ɗaya-ɗaya domin hadaya ta ƙonawa; ");
INSERT INTO hausa_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","ya kuma kawo bunsuru ɗaya domin hadaya don zunubi; ");
INSERT INTO hausa_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","da shanu biyu, raguna biyar, bunsurai biyar da kuma ’yan raguna biyar, dukansu bana ɗaya-ɗaya, a miƙa su hadaya ta salama. Wannan ita ce hadayar Ahiyezer ɗan Ammishaddai. ");
INSERT INTO hausa_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","A rana ta goma sha ɗaya, Fagiyel ɗan Okran, shugaban mutanen Asher, ya kawo hadayarsa. ");
INSERT INTO hausa_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Hadayar da ya kawo ita ce, faranti guda ɗaya na azurfa, nauyinsa shekel ɗari ɗaya da talatin, da kuma daro na yayyafawa na azurfa, nauyinsa shekel saba’in, dukan biyu, an auna su bisa ga ma’aunin shekel na tsattsarkan wuri, kowannensu cike da lallausan gari, haɗe da mai kamar hadaya ta gari; ");
INSERT INTO hausa_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","kwanon zinariya ɗaya mai nauyin shekel goma, cike da turaren hayaƙi; ");
INSERT INTO hausa_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","da ƙaramin bijimi guda ɗaya, tunkiya ɗaya, da rago, dukansu bana ɗaya-ɗaya domin hadaya ta ƙonawa; ");
INSERT INTO hausa_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","ya kuma kawo bunsuru ɗaya domin hadaya don zunubi; ");
INSERT INTO hausa_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","da shanu biyu, raguna biyar, bunsurai biyar da kuma ’yan raguna biyar, dukansu bana ɗaya-ɗaya, a miƙa su hadaya ta salama. Wannan ita ce hadayar Fagiyel ɗan Okran. ");
INSERT INTO hausa_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","A rana ta goma sha biyu, Ahira ɗan Enan, shugaban mutanen Naftali, ya kawo hadayarsa. ");
INSERT INTO hausa_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Hadayar da ya kawo ita ce, faranti guda ɗaya na azurfa, nauyinsa shekel ɗari ɗaya da talatin, da kuma daro na yayyafawa na azurfa, nauyinsa shekel saba’in, dukan biyu, an auna su bisa ga ma’aunin shekel na tsattsarkan wuri, kowannensu cike da lallausan gari, haɗe da mai kamar hadaya ta gari; ");
INSERT INTO hausa_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","kwanon zinariya ɗaya mai nauyin shekel goma, cike da turaren hayaƙi; ");
INSERT INTO hausa_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","da ƙaramin bijimi guda ɗaya, tunkiya ɗaya, da rago, dukansu bana ɗaya-ɗaya domin hadaya ta ƙonawa; ");
INSERT INTO hausa_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","ya kuma kawo bunsuru ɗaya domin hadaya don zunubi; ");
INSERT INTO hausa_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","da shanu biyu, raguna biyar, bunsurai biyar da kuma ’yan raguna biyar, dukansu bana ɗaya-ɗaya, a miƙa su hadaya ta salama. Wannan ita ce hadayar Ahira ɗan Enan. ");
INSERT INTO hausa_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Waɗannan su ne hadayun shugabannin Isra’ilawa saboda keɓewar bagade sa’ad da aka shafe shi, an kawo faranta goma sha biyu na azurfa, darunan goma sha biyu na azurfa don yayyafawa, da kuma kwanonin zinariya goma sha biyu. ");
INSERT INTO hausa_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Kowane faranti na azurfa yana da nauyin shekel ɗari da talatin, kuma kowane daro na azurfa don yayyafawa yana da nauyin shekel saba’in. Duka-duka dai, nauyin kwanonin azurfa, shekel dubu biyu ne da ɗari huɗu, bisa ga ma’aunin shekel na tsattsarkan wuri. ");
INSERT INTO hausa_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Kwanonin zinariya goma sha biyu da aka cika da turaren hayaƙi kuwa, nauyinsu shekel goma ne kowanne, bisa ga ma’aunin shekel na tsattsarkan wuri. Duka-duka dai, nauyin kwanonin zinariya, shekel ɗari ɗaya ne da ashirin. ");
INSERT INTO hausa_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Jimillar dabbobi don hadaya ta ƙonawa, ta kai ƙanana bijimai goma sha biyu, raguna goma sha biyu da ’yan raguna goma sha biyu, dukansu bana ɗaya-ɗaya, tare da hadayarsu ta hatsi. Aka yi amfani da bunsurai goma sha biyu domin hadaya don zunubi. ");
INSERT INTO hausa_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Jimillar dabbobi don hadaya ta salama, ta kai shanu ashirin huɗu, raguna sittin, bunsurai sittin da kuma ’yan raguna sittin, dukansu bana ɗaya-ɗaya. Waɗannan su ne hadayu saboda keɓewar bagade, bayan an shafe shi. ");
INSERT INTO hausa_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Sa’ad da Musa ya shiga Tentin Sujada don yă yi magana da Ubangiji, sai ya ji murya tana magana da shi daga tsakanin kerubobi biyu a bisa murfin akwatin Alkawari. A ta haka Ubangiji ya yi masa magana. ");
INSERT INTO hausa_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Yi magana da Haruna, ka ce masa, ‘Sa’ad da za ka shisshirya fitilun nan bakwai, ka shirya su yadda za su fuskanci gaba domin haskensu yă haskaka ta gaba.’ ” ");
INSERT INTO hausa_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Haka kuwa Haruna ya yi; ya shisshirya fitilun yadda za su fuskanci gaba a kan wurin ajiye fitilan, kamar dai yadda Ubangiji ya umarci Musa. ");
INSERT INTO hausa_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Ga yadda aka yi wurin ajiye fitilan. An ƙera shi da zinariya daga gindinsa har zuwa sama inda ya buɗu. Aka ƙera wurin ajiye fitilan yadda Ubangiji ya nuna wa Musa. ");
INSERT INTO hausa_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Keɓe Lawiyawa daga sauran Isra’ilawa, ka tsarkake su. ");
INSERT INTO hausa_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Ga yadda za ka tsarkake su, ka yayyafa musu ruwan tsarkakewa; ka sa su aske jikunansu duka su kuma wanke tufafinsu, ta haka za su tsarkake kansu. ");
INSERT INTO hausa_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Ka sa su ɗauki ɗan bijimi tare da lallausan garin hadaya, kwaɓaɓɓe da mai; sa’an nan, kai kuma ka ɗauki ɗan bijimi na biyu na hadaya don zunubi. ");
INSERT INTO hausa_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Ka kawo Lawiyawa a gaban Tentin Sujada, ka kuma kira taron Isra’ilawa duka. ");
INSERT INTO hausa_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Za ka kawo Lawiyawa a gaban Ubangiji, Isra’ilawa kuma za su ɗibiya musu hannuwansu. ");
INSERT INTO hausa_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Haruna zai miƙa Lawiyawa a gaban Ubangiji a matsayin hadaya ta kaɗawa daga Isra’ilawa, saboda a shirya su domin aikin Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","“Bayan Lawiyawa sun ɗibiya hannuwansu a kan bijiman, sai ka yi amfani da ɗaya a matsayin hadaya don zunubi ga Ubangiji, ɗayan kuma domin hadaya ta ƙonawa, don yin kafara saboda Lawiyawa. ");
INSERT INTO hausa_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Ka kuma sa Lawiyawa su tsaya a gaban Haruna da ’ya’yansa, sai ka miƙa su kamar hadaya ta kaɗawa ga Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Da haka za ka keɓe Lawiyawa daga sauran Isra’ilawa, Lawiyawa za su zama nawa. ");
INSERT INTO hausa_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","“Bayan ka tsarkake Lawiyawa, ka kuma miƙa su kamar hadaya ta kaɗawa, sai su zo su yi aikinsu a Tentin Sujada. ");
INSERT INTO hausa_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Gama dukansu an ba ni su daga cikin Isra’ilawa a maimakon dukan waɗanda suka fara buɗe mahaifa, wato, dukan ’ya’yan farin Isra’ilawa. Na karɓi Lawiyawa su zama nawa. ");
INSERT INTO hausa_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Kowane ɗan farin haihuwa, ko mutum, ko dabba a Isra’ila, nawa ne. Sa’ad da na kashe ’ya’yan fari a Masar, na keɓe ’ya’yan fari na Isra’ilawa wa kaina. ");
INSERT INTO hausa_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Na kuma ɗauki Lawiyawa a maimakon dukan ’ya’yan fari maza a Isra’ila. ");
INSERT INTO hausa_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Cikin dukan Isra’ilawa, na ba da Lawiyawa kyauta ga Haruna da ’ya’yansa, su yi hidima a Tentin Sujada a madadin Isra’ilawa, su kuma yi kafara dominsu saboda kada annoba ta bugi Isra’ilawa sa’ad da suka je kusa da wuri mai tsarki.” ");
INSERT INTO hausa_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Musa, Haruna da kuma dukan taron Isra’ilawa, suka yi da Lawiyawa yadda Ubangiji ya umarci Musa. ");
INSERT INTO hausa_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Lawiyawa suka tsarkake kansu, suka kuma wanke tufafinsu. Sai Haruna ya miƙa su kamar hadaya ta kaɗawa a gaban Ubangiji, ya kuma yi kafara saboda su don yă tsarkake su. ");
INSERT INTO hausa_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Bayan haka, sai Lawiyawa suka zo don su yi aikinsu a Tentin Sujada, a ƙarƙashin Haruna da ’ya’yansa. Suka yi da Lawiyawa kamar dai yadda Ubangiji ya umarci Musa. ");
INSERT INTO hausa_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“Wannan ya shafi Lawiyawa ne, wato, mazan da suka kai shekara ashirin da biyar, ko fiye, za su zo su yi aiki a Tentin Sujada, ");
INSERT INTO hausa_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","amma in suka kai shekaru hamsin da haihuwa, dole su huta daga wannan aiki na yau da kullum, su kuma daina aiki. ");
INSERT INTO hausa_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Za su iya taimakon ’yan’uwansu cikin tafiyar da ayyuka a Tentin Sujada, amma su kansu ba za su yi aikin ba. Haka fa za ka ba wa Lawiyawa aikinsu.” ");
INSERT INTO hausa_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Ubangiji ya yi magana da Musa a Hamadar Sinai, a watan farko na shekara ta biyu bayan fitarsu daga ƙasar Masar. Ya ce, ");
INSERT INTO hausa_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“Ka sa Isra’ilawa su yi Bikin Ƙetarewa a ƙayyadadden lokaci. ");
INSERT INTO hausa_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","A yi wannan bikin ƙayyadadden lokaci da yamma, a rana ta goma sha huɗu ga wannan wata, a yi shi bisa ga dokokinsa da ƙa’idodinsa.” ");
INSERT INTO hausa_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Saboda haka sai Musa ya gaya wa Isra’ilawa su yi Bikin Ƙetarewa, ");
INSERT INTO hausa_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","suka kuwa yi haka a Hamadar Sinai da yamma, a rana ta sha huɗu ga watan farko. Isra’ilawa suka yi dukan abubuwa yadda Ubangiji ya umarci Musa. ");
INSERT INTO hausa_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Amma waɗansunsu ba su iya yin Bikin Ƙetarewa a ranar ba gama sun ƙazantu ta wurin taɓa gawa. Saboda haka suka zo wurin Musa da Haruna a wannan rana ");
INSERT INTO hausa_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","suka ce wa Musa, “Mun ƙazantu saboda mun taɓa gawa, don me aka hana mu mu ba da hadaya ga Ubangiji tare da sauran Isra’ilawa a ƙayyadadden lokaci?” ");
INSERT INTO hausa_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Musa ya amsa musu ya ce, “Ku dakata sai na sami umarni daga wurin Ubangiji game da ku.” ");
INSERT INTO hausa_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Sai Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“Gaya wa Isra’ilawa cewa, ‘Sa’ad da waninku ko zuriyarku ya ƙazantu ta wurin taɓa gawa, ko kuwa ya yi tafiya mai nisa, duk da haka zai kiyaye Bikin Ƙetarewa ta Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Za su yi bikin da yamma, a rana ta sha huɗu ga wata na biyu. Za su ci naman tunkiya, tare da burodi marar yisti, da ganyaye masu ɗaci. ");
INSERT INTO hausa_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Kada su bar kome daga cikinsa yă kai safe, ko a karye ƙashinsa. Sa’ad da suke Bikin Ƙetarewa, dole su kiyaye dukan ƙa’idodinsa. ");
INSERT INTO hausa_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Amma in mutumin da yake da tsarki bai kuma yi tafiya ba, ya kuwa ƙi yă yi Bikin Ƙetarewar, dole a ware wannan mutum daga mutanensa, domin bai miƙa hadaya ga Ubangiji a ƙayyadadden lokaci ba. Wannan mutum zai ɗauki alhakin zunubinsa. ");
INSERT INTO hausa_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“ ‘Baƙon da yake zaune a cikinku wanda yake so yă yi Bikin Ƙetarewar Ubangiji, dole yă yi shi bisa ga dokokinsa da ƙa’idodinsa. Dole ku kasance da ƙa’ida ɗaya ga baƙo da kuma ɗan ƙasa.’ ” ");
INSERT INTO hausa_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","A ranar da aka kafa Tenti na Alkawari, sai girgije ya rufe shi. Daga yamma har safe, girgijen da yake bisa tabanakul ya yi kama da wuta. ");
INSERT INTO hausa_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Haka ya ci gaba da kasancewa; girgijen ya rufe shi, da dare kuma sai ya yi kamar wuta. ");
INSERT INTO hausa_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Duk sa’ad da aka ɗaga girgijen daga Tentin, sai Isra’ilawa su kama hanya; duk inda girgijen ya tsaya, a nan Isra’ilawa za su yi sansani. ");
INSERT INTO hausa_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Da umarnin Ubangiji, Isra’ilawa suke tashi. Da umarninsa kuma suke sauka. Muddin girgijen yana tsaye a bisa tabanakul, sukan yi ta zamansu a sansanoni. ");
INSERT INTO hausa_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Sa’ad da girgijen ya ci gaba da kasancewa a bisan tabanakul na dogon lokaci, Isra’ilawa sukan bi umarnin Ubangiji, ba kuwa za su tashi ba. ");
INSERT INTO hausa_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Wani lokaci girgijen yakan yi ’yan kwanaki ne kawai a bisa tabanakul; da umarnin Ubangiji sukan kafa sansani da umarninsa kuma su tashi. ");
INSERT INTO hausa_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Wani lokaci girgijen yakan zauna daga yamma har safiya ne kawai, sa’ad da kuma aka ɗaga shi da safe, sai su kama hanya. Ko da rana, ko da dare, duk sa’ad da aka ɗaga girgijen, sai su ma su tashi. ");
INSERT INTO hausa_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Ko girgijen ya yi kwana biyu a bisa tabanakul, ko wata guda, ko shekara, Isra’ilawa za su zauna a sansani ba kuwa za su tashi ba; amma sa’ad da aka ɗaga shi, sai su kuma su tashi. ");
INSERT INTO hausa_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Da umarnin Ubangiji sukan kafa sansani, da umarninsa kuma sukan tashi. Sukan bi umarnin Ubangiji, bisa ga umarninsa ta wurin Musa. ");
INSERT INTO hausa_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Ka ƙera kakaki guda biyu na azurfa, ka kuma yi amfani da su don kira taron jama’a wuri ɗaya, don kuma ka riƙa sanar da su lokacin tashi daga sansani. ");
INSERT INTO hausa_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Sa’ad da aka busa su biyu, dukan jama’a za su taru a gabanka a ƙofar Tentin Sujada. ");
INSERT INTO hausa_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","In ɗaya ne kaɗai aka busa, sai shugabannin kabilan Isra’ila, su taru a gabanka. ");
INSERT INTO hausa_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Sa’ad da aka ji karar busar kakaki, sai sansanin da yake a gabashi, su kama hanya. ");
INSERT INTO hausa_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","A kara ta biyu, sansanin da yake a kudanci, su kama hanya. Busan kakaki zai zama alama ta kama hanya. ");
INSERT INTO hausa_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","In don a tara jama’a ne, sai a busa kakaki, amma ba da irin alama ɗaya ba. ");
INSERT INTO hausa_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","“’Ya’yan Haruna, firistoci ne, za su busa kakaki. Wannan za tă zama dawwammamiyar farilla gare ku da kuma tsararraki masu zuwa. ");
INSERT INTO hausa_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Duk lokacin da za ku tafi yaƙi a ƙasarku, in akwai waɗansu da suke matsa muku, za ku yi amfani da waɗannan kakaki ta wurin hura su, alama ce, cewa za a je yaƙi. Sa’an nan Ubangiji Allahnku zai tuna da ku, yă cece ku daga maƙiyanku. ");
INSERT INTO hausa_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Haka ma in kuna cikin jin daɗinku, musamman lokacin da kuke bukukkuwanku, kamar Bikin Sabon Wata da dai kowane Bikinku, za ku hura waɗannan kakaki lokacin da kuke miƙa hadayunku na ƙonawa, da hadayunku na salama, za su kuma zama muku abin tunawa a gaban Allahnku. Ni ne Ubangiji Allahnku.” ");
INSERT INTO hausa_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","A rana ta ashirin ga wata na biyu, a shekara ta biyu, sai girgijen ya tashi daga tabanakul na Shaida. ");
INSERT INTO hausa_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Sai Isra’ilawa suka tashi daki-daki daga Hamadar Sinai, suna tafiya daga wuri zuwa wuri, har sai da girgijen ya tsaya a Hamadar Faran. ");
INSERT INTO hausa_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Suka kama hanya, a wannan lokaci, bisa umarnin Ubangiji, ta wurin Musa. ");
INSERT INTO hausa_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Ɓangarorin sansanin Yahuda suka fara tashi, bisa ga ƙa’idar da aka yi, aka kuma umarta. Nashon ɗan Amminadab ne shugaba. ");
INSERT INTO hausa_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Netanel ɗan Zuwar ne shugaban ɓangaren kabilar Issakar, ");
INSERT INTO hausa_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Eliyab ɗan Helon kuma shi ne shugaban ɓangaren kabilar Zebulun. ");
INSERT INTO hausa_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Sa’an nan aka saukar da tabanakul ƙasa, Gershonawa da mutanen Merari da suke ɗauke da shi suka kama hanya. ");
INSERT INTO hausa_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Sai ɓangarori sansanin Ruben suka biyo, bisa ga ƙa’idar da aka yi, aka kuma umarta. Elizur ɗan Shedeyur ne shugaba. ");
INSERT INTO hausa_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Shelumiyel ɗan Zurishaddai ne shugaban ɓangaren kabilar Simeyon, ");
INSERT INTO hausa_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Eliyasaf ɗan Deyuwel kuma shi ne shugaban ɓangaren kabilar Gad. ");
INSERT INTO hausa_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Sai Kohatawa suka kama hanya, ɗauke da kayayyaki masu tsarki, domin kafin su kai wurin da za a kafa sansani, a riga an kafa tabanakul. ");
INSERT INTO hausa_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Biye da waɗannan kuma sai ɓangaren sansanin kabilar Efraim suka biyo bisa ga ƙa’ida da aka yi, aka kuma umarta. Elishama ɗan Ammihud ne shugaba. ");
INSERT INTO hausa_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Gamaliyel ɗan Fedazur ne shugaban ɓangaren kabilar Manasse, ");
INSERT INTO hausa_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Abidan ɗan Gideyoni kuma shi ne shugaban ɓangaren kabilar Benyamin. ");
INSERT INTO hausa_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","A ƙarshe, a matsayi masu gadin bayan dukan ɓangarori, sai ɓangaren sansanin Dan suka tashi bisa ga ƙa’idar da aka yi, aka kuma umarta. Ahiyezer ɗan Ammishaddai ne shugaba. ");
INSERT INTO hausa_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Fagiyel ɗan Okran ne shugaban ɓangaren kabilan Asher, ");
INSERT INTO hausa_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Ahira ɗan Enan kuma shi ne shugaban kabilar Naftali. ");
INSERT INTO hausa_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Wannan shi ne tsarin tafiyar ɓangarorin Isra’ilawa, sa’ad da sukan kama hanya. ");
INSERT INTO hausa_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Sai Musa ya ce wa Hobab ɗan Reyuwel Bamidiyane surukinsa, “Yanzu fa, muna shirin tashi ne daga nan, domin mu tafi inda Ubangiji ya ce, ‘Zan ba ku.’ Ka zo tare da mu, za mu kuwa yi maka alheri, gama Ubangiji ya yi wa Isra’ilawa alkawari abubuwa masu kyau.” ");
INSERT INTO hausa_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Ya amsa, ya ce “A’a, ba zan tafi ba; zan koma ƙasata da kuma wurin mutanena.” ");
INSERT INTO hausa_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Amma Musa ya ce, “Ina roƙonka kada ka rabu da mu. Ka san inda ya kamata mu kafa sansani a hamada, za ka kuma zama idanunmu. ");
INSERT INTO hausa_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","In ka zo tare da mu, za mu raba duk abin alherin Ubangiji ya ba mu tare da kai.” ");
INSERT INTO hausa_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Saboda haka suka kama hanya daga dutsen Ubangiji, suka yi tafiya kwana uku. Akwatin alkawarin Ubangiji ya ja gabansu a waɗannan kwanaki uku, don yă samo musu masauƙi. ");
INSERT INTO hausa_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","A duk lokacin da suka tashi daga sansani, girgijen Ubangiji ya inuwantar da su da rana. ");
INSERT INTO hausa_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Duk kuma sa’ad da akwatin ya kama hanya, sai Musa ya ce, “Ka tashi, ya Ubangiji! Ka sa maƙiyanka su warwatse; masu ƙinka kuma su gudu a gabanka.” ");
INSERT INTO hausa_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Duk sa’ad da akwatin ya sauka kuma, sai Musa ya ce, “Ka komo, ya Ubangiji, a wurin dubban da ba a iya ƙidayawa na iyalan Isra’ila.” ");
INSERT INTO hausa_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Da Ubangiji ya ji gunagunin da mutanen suke yi saboda wahalarsu, sai ya husata ƙwarai. Sai wuta daga Ubangiji ta yi ta ci a cikinsu har ta ƙone waɗansu wurare na sansanin. ");
INSERT INTO hausa_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Da jama’ar suka yi wa Musa kuka, sai ya yi addu’a ga Ubangiji, wutar kuwa ta mutu. ");
INSERT INTO hausa_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Saboda haka aka kira wannan wuri Tabera, gama a wurin ne wuta daga Ubangiji ta ƙuna a cikinsu. ");
INSERT INTO hausa_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Wata rana, baƙin da suke cikinsu, suka fara kwaɗayin waɗansu abinci, har suka sa Isra’ilawa suka fara kuka, suna cewa, “Da mun sami nama mun ci mana! ");
INSERT INTO hausa_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Mun tuna da kifin da muka ci kyauta a Masar, haka ma kayan lambu irin su kukumba, guna, safa, albasa da kuma tafarnuwa. ");
INSERT INTO hausa_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Amma ga shi yanzu ba mu da wani abin marmari; in ba wannan Manna ba!” ");
INSERT INTO hausa_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Manna kuwa kamar tsabar riɗi take, kamanninta kuma kamar ƙaro ne. ");
INSERT INTO hausa_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Mutane sukan fita su tattara ta, su niƙa a dutsen niƙa, ko kuwa su daka a turmi. Su dafa, ko su yi waina da ita. Ɗanɗanonta yakan yi kamar abin da aka yi da man zaitun. ");
INSERT INTO hausa_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Sa’ad da raɓa tana saukowa da dad dare a kan sansani, Manna ma takan sauko. ");
INSERT INTO hausa_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Musa ya ji mutanen suna ta gunaguni ko’ina a cikin iyalansu, kowane mutum a ƙofar tentinsa. Ubangiji kuwa ya husata ƙwarai, sai Musa ya damu. ");
INSERT INTO hausa_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Sai ya ce wa Ubangiji, “Me ya sa ka kawo wannan damuwar a kan bawanka? Me na yi da ya ɓata maka rai har ka ɗora dukan nauyin mutanen nan a kaina? ");
INSERT INTO hausa_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Ni ne na yi cikin dukan mutanen nan? Ni ne na haife su? To, me ya sa ka ce in ɗauke su a ƙirjina kamar yadda mai reno yake rungume jariri, zuwa ƙasa wadda ka yi alkawari da rantsuwa za ka ba wa kakanninsu? ");
INSERT INTO hausa_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Ina ne zan sami nama in waɗannan mutane? Sun dinga yin mini kuka suna cewa ‘Ka ba mu nama mu ci!’ ");
INSERT INTO hausa_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Ba zan iya ɗaukan dukan mutanen nan ni kaɗai ba, nauyin ya yi mini yawa. ");
INSERT INTO hausa_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","In haka za ka yi da ni, ka kashe ni yanzu, in na sami tagomashi daga gare ka, kada ka bar ni in rayu in ga wannan baƙin ciki.” ");
INSERT INTO hausa_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Sai Ubangiji ya ce wa Musa, “Ka tattaro mini dattawa saba’in daga cikin mutanen Isra’ila, waɗanda aka sani su ne dattawa da kuma shugabanni a cikin jama’a. Ka sa su zo Tentin Sujada, su tsaya a can tare da kai. ");
INSERT INTO hausa_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Zan sauko in yi magana da kai a can, zan kuma ɗauki Ruhun da yake kanka in mai da shi wajensu. Za su taimake ka ɗaukan nauyin mutane, don yă zama ba kai kaɗai ba ne mai ɗaukan kaya. ");
INSERT INTO hausa_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","“Ka gaya wa mutane, ‘Ku tsarkake kanku don gobe, za ku ci nama. Ubangiji ya ji ku sa’ad da kuka yi kuka cewa, “Da mun sami nama mun ci mana! Ai, da ba mu da damuwa, gama lokacin da muke zama cikin Masar ba mu da damuwa!” Yanzu Ubangiji zai ba ku nama, za ku kuma ci. ");
INSERT INTO hausa_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Ba za ku ci shi na kwana ɗaya, ko biyu, ko biyar, ko goma, ko kuma kwana ashirin kaɗai ba, ");
INSERT INTO hausa_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","amma za ku ci har na wata guda cur, sai ya gundure ku a hanci har ku yi ƙyamarsa, domin kun ƙi Ubangiji wanda yake cikinku, kuka yi kuka a gabansa, kuna cewa, “Don me ma muka bar ƙasar Masar?” ’ ” ");
INSERT INTO hausa_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Amma Musa ya ce, “Ga ni a cikin mutane dubu ɗari shida tafe tare da ni, kana kuma cewa, ‘Zan ba su nama su ci har wata guda cur!’ ");
INSERT INTO hausa_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Za su ma sami isashe in har aka yanka musu garkuna tumaki da na shanu? Za su sami isashe in aka kama musu dukan kifin teku?” ");
INSERT INTO hausa_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Ubangiji ya ce wa Musa, “Akwai abin da ya fi ƙarfina ne? Bari ka gani ko abin da na ce zan yi, zai faru ko babu.” ");
INSERT INTO hausa_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Saboda haka Musa ya fita ya gaya wa jama’a abin da Ubangiji ya faɗa. Ya tattaro dattawansu saba’in, ya sa suka tsaya kewaye da Tentin Sujada. ");
INSERT INTO hausa_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Sa’an nan Ubangiji ya sauko daga girgije, ya yi magana da shi, ya kuma ɗauke Ruhun da yake kan Musa ya ɗora shi a kan dattawa saba’in nan. Sa’ad da Ruhun ya zauna a kansu, sai suka yi annabci, amma daga wannan ba su ƙara yin haka kuma ba. ");
INSERT INTO hausa_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","To, fa, akwai dattawa biyu da suka kasance a sansani, wato, Eldad da Medad. Su ma an lasafta su cikin dattawan, amma ba su fita zuwa Tentin Sujada ba. Duk da haka Ruhun ya sauka a kansu, suka kuma yi annabci a cikin sansanin. ");
INSERT INTO hausa_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Wani saurayi ya sheƙa a guje zuwa wajen Musa ya ce, “Eldad da Medad suna can suna annabci a sansani.” ");
INSERT INTO hausa_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Sai Yoshuwa ɗan Nun, wanda yake mataimakin Musa tun yana saurayi, ya amsa ya ce, “Ranka yă daɗe, Musa, ka hana su!” ");
INSERT INTO hausa_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Amma Musa ya amsa ya ce, “Kana kishi domina ne? Da ma a ce dukan mutanen Ubangiji annabawa ne, da ma a kuma ce Ubangiji ya sa Ruhunsa a kansu mana!” ");
INSERT INTO hausa_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Sai Musa da dattawan Isra’ila suka koma sansani. ");
INSERT INTO hausa_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Ana nan, sai Ubangiji ya kawo wata iska mai tsanani ta koro makware daga teku. Ta bar su birjik kewaye da sansani, tsayinsu daga ƙasa ya kai kamu biyu, misalin tafiyar nisan yini guda ta kowace fuska. ");
INSERT INTO hausa_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Dukan yini da dukan dare da kuma kashegari, mutane suka fito suka tattara makware. Ba wanda ya kāsa tara ƙasa da garwa goma. Sai suka shanya abinsu kewaye da sansanin. ");
INSERT INTO hausa_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Amma da suna cikin cin naman, tun ba su ma haɗiye ba, sai Ubangiji ya husata sosai a kan jama’ar, ya buge su da annoba mai zafi. ");
INSERT INTO hausa_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Saboda haka aka kira wannan wuri Kibrot Hatta’awa, gama a can ne aka binne mutanen nan makwaɗaita. ");
INSERT INTO hausa_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Daga Kibrot Hatta’awa, mutane suka yi tafiya zuwa Hazerot, a can suka sauka. ");
INSERT INTO hausa_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Miriyam da Haruna suka fara zargin Musa saboda matarsa ’yar ƙasar Kush da ya aura. ");
INSERT INTO hausa_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Suka ce, “Ubangiji ya yi magana ta wurin Musa ne kaɗai? Ashe, bai yi magana ta wurinmu mu ma ba?” Ubangiji kuwa ya ji wannan. ");
INSERT INTO hausa_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","(Musa kuwa mutum ne mai tawali’u ƙwarai, mafi tawali’u fiye da kowane mutum a duniya.) ");
INSERT INTO hausa_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Nan da nan Ubangiji ya ce wa Musa, da Haruna da kuma Miriyam, “Ku fita ku tafi Tentin Sujada, dukanku uku.” Sai dukansu uku suka tafi. ");
INSERT INTO hausa_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Sai Ubangiji ya sauko a cikin ginshiƙin girgije; ya tsaya a bakin ƙofar Tenti, ya kira Haruna da Miriyam. Sa’ad da su biyu suka gusa gaba, ");
INSERT INTO hausa_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","sai ya ce, “Ku ji abin da zan faɗa, “Duk lokacin da akwai annabin Ubangiji a cikinku, nakan bayyana kaina gare shi cikin wahayi, in yi magana da shi cikin mafarkai. ");
INSERT INTO hausa_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Amma ba haka nake magana da Musa bawana ba; na sa shi yă lura da dukan jama’ata Isra’ila. ");
INSERT INTO hausa_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Da shi nake magana fuska da fuska, a fili kuma, ba a kacici-kacici ba; yakan ga siffar Ubangiji. To, me ya sa ba ku ji tsoro ku yi magana a kan bawana Musa ba?” ");
INSERT INTO hausa_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Sai fushin Ubangiji ya yi ƙuna a kansu, ya kuma rabu da su. ");
INSERT INTO hausa_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Da girgijen ya tashi daga bisa Tentin, sai ga Miriyam tsaye, kuturwa, fari fat. Haruna kuwa ya juya wajenta ya ga ta kuturce; ");
INSERT INTO hausa_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","sai Haruna ya ce wa Musa, “Ranka yă daɗe, ina roƙonka kada ka hukunta mu, gama zunubin da muka yi, mun yi ne cikin wauta. ");
INSERT INTO hausa_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Kada ka sa ta zama kamar haifaffen mataccen jariri daga cikin mahaifiya wanda rabin jikin ruɓaɓɓe ne.” ");
INSERT INTO hausa_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Saboda haka sai Musa ya yi kuka ga Ubangiji ya ce, “Ya Allah, ina roƙonka ka warkar da ita!” ");
INSERT INTO hausa_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Sai Ubangiji ya ce wa Musa, “Da a ce mahaifinta ne ya tofa mata miyau a fuskarta, ashe, ba za tă ji kunya har kwana bakwai ba? A fitar da ita bayan sansani kwana bakwai; bayan haka za a iya dawo da ita.” ");
INSERT INTO hausa_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Haka aka fitar da Miriyam bayan sansani kwana bakwai, mutane kuwa ba su ci gaba da tafiya ba sai da aka dawo da ita. ");
INSERT INTO hausa_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Bayan haka sai mutane suka bar Hazerot suka sauka a Hamadan Faran. ");
INSERT INTO hausa_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Ka aiki waɗansu mutane zuwa ƙasar Kan’ana, wadda nake ba Isra’ilawa. Daga kowace kabila, ka aiki ɗaya daga cikin shugabanninta.” ");
INSERT INTO hausa_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Saboda haka bisa ga umarnin Ubangiji, Musa ya aike su daga Hamadan Faran. Dukansu kuwa shugabanni ne na Isra’ilawa. ");
INSERT INTO hausa_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Shugabannin kuwa su ne, Shammuwa ɗan Zakkur, daga kabilar Ruben; ");
INSERT INTO hausa_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Shafat ɗan Hori, daga kabilar Simeyon; ");
INSERT INTO hausa_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Kaleb ɗan Yefunne, daga kabilar Yahuda; ");
INSERT INTO hausa_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Igal ɗan Yusuf, daga kabilar Issakar; ");
INSERT INTO hausa_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Hosheya ɗan Nun, daga kabilar Efraim; ");
INSERT INTO hausa_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","daga kabilar Benyamin, Falti ɗan Rafu; ");
INSERT INTO hausa_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Gaddiyel ɗan Sodi, daga kabilar Zebulun; ");
INSERT INTO hausa_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Gaddi ɗan Susi, daga kabilar Manasse (wata kabilar Yusuf); ");
INSERT INTO hausa_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Ammiyel ɗan Gemalli, daga kabilar Dan; ");
INSERT INTO hausa_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Setur ɗan Mika’ilu, daga kabilar Asher; ");
INSERT INTO hausa_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Nabi ɗan Bofsi, daga kabilar Naftali; ");
INSERT INTO hausa_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Geyuwel ɗan Maki, daga kabilar Gad. ");
INSERT INTO hausa_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Waɗannan su ne sunayen mutanen da Musa ya aika su binciki ƙasar. (Sai Musa ya ba Hosheya ɗan Nun, suna Yoshuwa.) ");
INSERT INTO hausa_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Sa’ad da Musa ya aike su domin su binciki Kan’ana ya ce, “Ku haura, ku ratsa ta Negeb har zuwa ƙasar tudu. ");
INSERT INTO hausa_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Ku ga yadda ƙasar take, ku ga ko mutanen da suke zama a can ƙarfafa ne, ko raunannu, ko su kima ne, ko kuma suna da yawa. ");
INSERT INTO hausa_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Wace irin ƙasa ce suke zama a ciki, Mai kyau ce, ko mummuna? Waɗanne irin birane ne suke zama a ciki? Suna da katanga, ko babu? ");
INSERT INTO hausa_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Yaya ƙasar take? Tana da wadata, ko babu? Akwai itatuwa, ko babu? Ku yi iya ƙoƙarinku ku ɗebo daga cikin albarkar ƙasar ku kawo.” (Lokacin farkon nunan inabi ne.) ");
INSERT INTO hausa_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Saboda haka suka haura, suka binciki ƙasar daga Hamadan Zin har zuwa Rehob, wajen Lebo Hamat. ");
INSERT INTO hausa_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Suka kuma haura ta Negeb, suka iso Hebron, inda Ahiman, da Sheshai, da Talmai, zuriyar Anak, suke zama. (An gina Hebron da shekara bakwai kafin a gina Zowan a Masar.) ");
INSERT INTO hausa_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Da suka iso Kwarin Eshkol, sai suka yanko reshe guda na nonon inabi tare da ’ya’yansa cunkus. Mutum biyu suka ɗauka shi rataye a sanda a kafaɗarsu, suka haɗa tare da rumman da kuma ɓaure. ");
INSERT INTO hausa_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Sai aka kira wurin Kwarin Eshkol saboda nonon inabin da suka yi cunkus, wanda Isra’ilawa suka yanko a wurin. ");
INSERT INTO hausa_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","A ƙarshen kwana arba’in sai suka komo daga bincikensu. ");
INSERT INTO hausa_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Suka dawo wurin Musa, da Haruna, da dukan jama’ar Isra’ilawa, a Kadesh, a Hamadan Faran. A can suka ba da rahoton ga dukan taron da yake wurin, suka kuma nuna musu amfanin ƙasar. ");
INSERT INTO hausa_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Suka ce wa Musa, “Mun je ƙasar da ka aike mu, ƙasar tana zub da madara da zuma! Ga kuma amfaninta. ");
INSERT INTO hausa_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Amma fa mazaunan can ɗin ƙarfafa ne, an kuma kewaye biranen da manya-manyan katanga. Mun kuma ga zuriyar Anak a can. ");
INSERT INTO hausa_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Amalekawa suna zama a Negeb; Hittiyawa, Yebusiyawa da kuma Amoriyawa, suna zama ne a ƙasar tudu. Kan’aniyawa kuma suna zama kusa da teku da kuma a bakin Urdun.” ");
INSERT INTO hausa_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Sai Kaleb ya sa mutane suka yi shiru a gaban Musa, sai ya ce, “Ya kamata mu tafi mu mallaki ƙasar, gama lalle za mu iya cinta.” ");
INSERT INTO hausa_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Amma sauran mutanen da suka je tare da shi, suka ce, “Ba za mu iya kara da mutanen nan ba; sun fi mu ƙarfi.” ");
INSERT INTO hausa_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Sai suka yaɗa labari marar kyau ga Isra’ilawa game da ƙasar da suka binciko. Suka ce, “Ƙasar da muka ratsa cikinta domin mu leƙi asirinta, tana cinye waɗanda suke zama a cikinta. Dukan mutanen da muka gani a wurin, ƙatti ne. ");
INSERT INTO hausa_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Mun ga Nefilimawa a can (zuriyar Anak sun fito ne daga Nefilim). Sai muka ga kanmu kamar fāra ne kawai, haka kuwa muke a gare su.” ");
INSERT INTO hausa_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","A daren nan, sai dukan jama’ar suka tā da murya, suka yi kuka da ƙarfi. ");
INSERT INTO hausa_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Dukan Isra’ilawa suka yi gunaguni a kan Musa da Haruna, dukan taron kuwa suka ce musu, “Da ma mun mutu a Masar! Ko kuma a wannan hamada ma! ");
INSERT INTO hausa_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Don me Ubangiji yana kawo mu wannan ƙasa yă bar mu kawai mu mutu da takobi? A kuma kwashe matanmu da ’ya’yanmu ganima. Ashe, bai fi mana mu koma Masar ba?” ");
INSERT INTO hausa_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Sai suka ce wa junansu, “Mu naɗa wa kanmu shugaba, mu koma Masar.” ");
INSERT INTO hausa_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Sai Musa da Haruna suka fāɗi rubda ciki a gaban jama’ar Isra’ilawa da suka taru a can. ");
INSERT INTO hausa_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Yoshuwa ɗan Nun da Kaleb ɗan Yefunne waɗanda suke tare da masu leƙo asirin ƙasar, suka yayyage tufafinsu ");
INSERT INTO hausa_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","suka ce wa dukan taron Isra’ilawa, “Ƙasar da muka ratsa, muka kuma leƙi asirinta, tana da kyau sosai. ");
INSERT INTO hausa_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","In Ubangiji ya ji daɗinmu, zai kai mu ƙasan nan, ƙasar da take zub da madara da zuma, yă kuwa ba mu ita. ");
INSERT INTO hausa_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Sai dai kada ku tayar wa Ubangiji. Kada kuma ku ji tsoron mutane ƙasar, domin za mu gama da su. Kāriyarsu ta gama, amma Ubangiji yana nan tare da mu. Kada ku ji tsoronsu.” ");
INSERT INTO hausa_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Amma taron jama’a suka ce za su jajjefe su da duwatsu. Sai ɗaukakar Ubangiji ta bayyana a Tentin Sujada ga dukan Isra’ilawa. ");
INSERT INTO hausa_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Ubangiji ya ce wa Musa, “Har yaushe mutanen nan za su rena ni? Har yaushe za su ƙi gaskata da ni, duk da yawan mu’ujizan da nake yi a cikinsu? ");
INSERT INTO hausa_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Zan buge su duka da annoba, in hallaka su, amma zan mai da kai al’umma mai girma, da kuma ƙarfi fiye da su.” ");
INSERT INTO hausa_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Sai Musa ya ce wa Ubangiji, “Ai, Masarawa za su ji game da wannan! Da ikonka ka fitar da mutanen nan daga cikinsu. ");
INSERT INTO hausa_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Za su kuwa gaya wa mutanen wannan ƙasa. Sun riga sun ji cewa kai, ya Ubangiji, kana tare da waɗannan mutane, kuma cewa kai, ya Ubangiji, an gan ka fuska da fuska, cewa girgijenka ya tsaya bisansu, cewa kana tafiya a gabansu cikin ginshiƙin girgije da rana, da ginshiƙin wuta kuma da dare. ");
INSERT INTO hausa_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","In ka kashe dukan mutanen nan gaba ɗaya, al’ummai da suka ji wannan labari game da kai za su ce, ");
INSERT INTO hausa_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘Ubangiji ya kāsa kai waɗannan mutane a ƙasar da ya yi alkawari da rantsuwa ne, shi ya sa ya kashe su a hamada.’ ");
INSERT INTO hausa_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","“Yanzu bari Ubangiji yă nuna ikonsa, kamar dai yadda ka furta. ");
INSERT INTO hausa_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘Ubangiji mai jinkiri fushi ne, mai yawan ƙauna, mai gafarta zunubi da tawaye. Duk da haka ba ya ƙyale mai laifi, babu horo. Yana horin ’ya’ya saboda zunubin iyayensu har tsara ta uku, da ta huɗu.’ ");
INSERT INTO hausa_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Bisa ga ƙaunarka mai girma, ka gafarta zunubin mutanen nan, kamar dai yadda ka gafarta musu daga lokacin da suka bar Masar har zuwa yanzu.” ");
INSERT INTO hausa_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Ubangiji ya amsa ya ce, “Na gafarta musu, yadda ka roƙa. ");
INSERT INTO hausa_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Duk da haka, muddin ina raye, kuma muddin ɗaukakar Ubangiji ta cika dukan duniya, ");
INSERT INTO hausa_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","ko ɗaya daga cikinsu da suka ga ɗaukakata da mu’ujizai da na yi a Masar, da kuma a cikin hamada, da suka ƙi yin mini biyayya, suka kuma gwada ni har sau goma, ");
INSERT INTO hausa_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","ba ko ɗayansu da zai gan ƙasar da na yi alkawari da rantsuwa zan ba wa kakanninsu. Ba ko ɗaya da ya rena ni, da zai taɓa ganinta. ");
INSERT INTO hausa_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Amma domin Kaleb bawana ya kasance da ruhu dabam, ya kuma bi ni da zuciya ɗaya, zan kai shi cikin ƙasar da ya je, zuriyarsa kuwa za su gāje ta. ");
INSERT INTO hausa_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Da yake Amalekawa da Kan’aniyawa suna zama a kwarin, gobe sai ka koma baya, ka nufi wajen hamada ta hanyar Jan Teku.” ");
INSERT INTO hausa_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Ubangiji ya ce wa Musa da Haruna, ");
INSERT INTO hausa_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“Har yaushe wannan muguwar al’umma za tă yi gunaguni a kaina? Na ji koke-koken waɗannan Isra’ilawa masu gunaguni. ");
INSERT INTO hausa_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Saboda haka ka gaya musu cewa, ‘Muddin ina raye, in ji Ubangiji, zan yi muku daidai da abin da na ji kuke faɗa. ");
INSERT INTO hausa_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","A cikin wannan hamadan, jikunanku za su fāɗi, kowanne a cikinku mai shekara ashirin ko fiye, wanda aka ƙirga shi cikin ƙidaya, wanda kuma ya yi gunaguni a kaina, da zai shiga wannan ƙasa. ");
INSERT INTO hausa_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Ba ko ɗaya daga cikinku da zai shiga ƙasar da na ɗaga hannu na rantse, za tă zama gidanku, sai dai Kaleb ɗan Yefunne da Yoshuwa ɗan Nun. ");
INSERT INTO hausa_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Amma game da ’ya’yanku da kuka ce za a kwashe ganima, zan kawo su cikin ƙasar, su ji daɗin ƙasar wadda kuka ƙi. ");
INSERT INTO hausa_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Amma ku, jikunanku za su fāɗi a wannan hamada. ");
INSERT INTO hausa_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","’Ya’yanku za su zama makiyaya a nan, shekaru arba’in suna shan wahala domin rashin amincinku, har sai mutum na ƙarshe a cikinku ya kwanta a hamada. ");
INSERT INTO hausa_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Shekaru arba’in, shekara ɗaya a madadi kwana ɗaya cikin kwanakin arba’in da kuka ɗauka kuka leƙi asirin ƙasa, za ku sha wahala saboda zunubanku, ku kuma san abin da ake nufi da sa ni in yi gāba da ku.’ ");
INSERT INTO hausa_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Ni, Ubangiji na faɗa, zan kuwa aikata waɗannan abubuwa a kan dukan muguwar jama’an nan da suka haɗa kai, suka tayar mini. Za su sadu da ƙarshensu a wannan hamada; a nan za su mutu.” ");
INSERT INTO hausa_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Saboda haka mutanen da Musa ya aika, su leƙo asirin ƙasar, waɗanda suka komo, suka sa taron jama’a su yi gunaguni a kansa saboda sun kawo rahoto mai banrazana a kan ƙasar, ");
INSERT INTO hausa_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","waɗannan mutanen da suka kawo rahoto mai banrazana a kan ƙasar, annoba ta buge su, suka kuwa mutu a gaban Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Daga cikin mutanen da suka leƙo asirin ƙasar, Yoshuwa ɗan Nun, da Kaleb ɗan Yefunne ne, kaɗai suka rayu. ");
INSERT INTO hausa_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Da Musa ya gaya wa dukan Isra’ilawa wannan labari, sai suka yi baƙin ciki ƙwarai. ");
INSERT INTO hausa_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Kashegari da sassafe suka haura ta wajen ƙasa mai tudu suka ce, “Mun yi zunubi, za mu tafi inda Ubangiji ya yi alkawari.” ");
INSERT INTO hausa_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Amma Musa ya ce, “Don me kuke rashin biyayya da umarnin Ubangiji? Wannan ba zai yiwu ba! ");
INSERT INTO hausa_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Kada ku haura, domin Ubangiji, ba ya tare da ku. Magabtanku za su ci nasara a kanku, ");
INSERT INTO hausa_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","gama Amalekawa da Kan’aniyawa za su kara da ku a can. Domin kun juya daga Ubangiji, ba zai kasance da ku ba, za a kuma karkashe ku da takobi.” ");
INSERT INTO hausa_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Duk da haka, suka yi tsammani ba zai zama haka ba, sai suka haura ta wajen ƙasa mai tudu, Musa da akwatin alkawarin Ubangiji dai ba su gusa daga sansanin ba. ");
INSERT INTO hausa_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Sai Amalekawa da Kan’aniyawa mazaunan ƙasar tudu, suka gangaro suka auka musu, suka bubbuge su suka kokkore su har Horma. ");
INSERT INTO hausa_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“Ka yi magana da Isra’ilawa, ka ce musu, ‘Bayan kun shiga ƙasar da nake ba ku a matsayin gida, ");
INSERT INTO hausa_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","kuka yi hadayar da akan yi da wuta ga Ubangiji, daga cikin shanu, ko tumaki, abin ƙanshi mai daɗi ga Ubangiji, ko hadaya ta ƙonawa, ko hadayu don alkawura na musamman, ko hadayar yardar rai, ko kuma hadaya ta biki, ");
INSERT INTO hausa_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","sai shi wanda ya kawo hadayar yă miƙa wa Ubangiji hadaya ta gari mai laushi mai kyau, kashi ɗaya bisa goma na efa wanda aka kwaɓa da kwalaba ɗaya na mai. ");
INSERT INTO hausa_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Da kowane ɗan rago don hadaya ta ƙonawa, a shirya kwalaba ɗaya na ruwan inabi, a matsayin hadaya ta sha. ");
INSERT INTO hausa_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","“ ‘In da rago ne za a miƙa, to, sai a shirya hadaya ta gari mai laushi, garin yă zama kashi biyu bisa goma na efa. A kwaɓa shi da kashi ɗaya bisa uku na garwan mai, ");
INSERT INTO hausa_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","da kashi ɗaya bisa uku na garwan ruwan inabi, a matsayin hadaya ta sha. A miƙa ta abin ƙanshi mai daɗi ga Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","“ ‘Sa’ad da kuka shirya rago don hadaya ta ƙonawa saboda alkawari na musamman, ko hadaya ta salama ga Ubangiji, ");
INSERT INTO hausa_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","sai ku kawo hadaya ta gari tare da bijimi, kashi ɗaya bisa uku na gari mai laushi kwaɓaɓɓe da rabin garwan mai. ");
INSERT INTO hausa_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","A kuma kawo rabin garwan ruwan inabi na hadaya ta sha. Za tă zama hadayar da aka yi da wuta mai daɗin ƙanshi ga Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Haka za a yi da kowane bijimi, ko rago, ko ɗan rago, ko bunsuru. ");
INSERT INTO hausa_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Haka za a yi da kowannensu bisa ga abin da aka shirya. ");
INSERT INTO hausa_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","“ ‘Duk wanda yake ɗan ƙasa, ta haka ne dole zai aikata waɗannan abubuwa sa’ad da ya kawo hadaya da akan yi da wuta mai daɗin ƙanshi ga Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Idan baƙon da yake baƙunci a cikinku, ko kowane ne da yake tare da ku a dukan zamananku, yana so yă ba da hadayar da akan yi da wuta don a yi ƙanshi mai daɗi ga Ubangiji, dole yă yi kamar yadda kuke yi. ");
INSERT INTO hausa_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Ƙa’ida ɗaya ce ga jama’a da kuma baƙin da suke zama a cikinku, wannan za tă zama dawwammamiyar farilla a dukan tsararraki masu zuwa. Da ku, da baƙi, za ku zama ɗaya a gaban Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Doka ɗaya da ƙa’ida ɗaya za a yi aiki da ita a kan ku da kuma baƙin da suke zama a cikinku.’ ” ");
INSERT INTO hausa_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“Ka yi magana da Isra’ilawa, ka ce musu, ‘Sa’ad da kuka shiga ƙasar da ina kai ku, ");
INSERT INTO hausa_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","kuka ci abincin ƙasar, ku miƙa wani sashe na amfanin ƙasar a matsayin hadaya ga Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Ku kawo waina daga nunan fari na ɓarzajjen hatsinku, ku kuma miƙa shi a matsayin hadaya daga masussuka. ");
INSERT INTO hausa_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","A duk tsararraki masu zuwa, za ku miƙa wannan hadaya daga nunan fari na ɓarzajjen hatsinku ga Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“ ‘To, in ku a matsayin jama’a, da gangan kuka ƙi kiyaye waɗannan ƙa’idodi da Ubangiji ya ba wa Musa ba, ");
INSERT INTO hausa_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","ko wani daga cikin umarnan da Ubangiji ya ba ku ta wurinsa, daga ranar da Ubangiji ya ba da su, har zuwa tsararraki masu zuwa, ");
INSERT INTO hausa_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","in kuwa aka yi haka ba da gangan ba, kuma da rashin sani, sai duk jama’a su miƙa ɗan bijimi don hadaya ta ƙonawa mai daɗin ƙanshi ga Ubangiji, tare da ƙayyadadden hadaya ta gari, da hadaya ta sha, da kuma bunsuru na hadaya don zunubi. ");
INSERT INTO hausa_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Firist kuwa zai yi kafara domin dukan jama’ar Isra’ilawa, za a kuma gafarta musu, gama ba da gangan ba ne suka aikata, kuma sun kawo wa Ubangiji hadayar da akan yi da wuta da kuma hadaya don zunubi saboda laifinsu. ");
INSERT INTO hausa_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Za a gafarta wa dukan jama’ar Isra’ilawa, da baƙin da suke zama a cikinsu, gama duk laifin da aka yi da rashin sani, yakan shafi dukan mutane. ");
INSERT INTO hausa_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“ ‘Amma in mutum ɗaya ne kaɗai ya yi laifi ba da gangan ba, dole yă kawo akuya domin hadaya don zunubi. ");
INSERT INTO hausa_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Firist zai yi kafara a gaban Ubangiji saboda mutumin nan da ya aikata laifi ba da gangan ba, in kuwa an yi kafara saboda shi, za a gafarta masa. ");
INSERT INTO hausa_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Ƙa’ida dai za tă zama ɗaya ga duk wanda ya yi laifi ba da gangan ba, ko shi ɗan ƙasa ne, ko kuma baƙon da yake zama a cikinku. ");
INSERT INTO hausa_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“ ‘Amma duk wanda ya yi zunubi da gangan, ko shi ɗan ƙasa ne, ko baƙo, ya saɓi Ubangiji, dole a ware wannan mutum daga mutanensa, ");
INSERT INTO hausa_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","gama ya rena maganar Ubangiji, ya kuma karya umarninsa. Tabbatacce za a kashe wannan mutum, alhakinsa laifinsa kuwa yana wuyansa.’ ” ");
INSERT INTO hausa_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Yayinda Isra’ilawa suke ciki hamada, sai aka sami wani mutum yana tattara itace a ranar Asabbaci. ");
INSERT INTO hausa_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Waɗanda suka gan shi, suka kawo shi wurin Musa da Haruna da dukan taro, ");
INSERT INTO hausa_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","sai suka sa shi a gidan waƙafi don ba su riga sun san abin da za a yi da shi ba tukuna. ");
INSERT INTO hausa_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Sai Ubangiji ya ce wa Musa, “Dole mutumin yă mutu. Dole dukan taron su jajjefe shi a bayan sansani.” ");
INSERT INTO hausa_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Saboda haka taron suka ɗauke shi zuwa bayan sansani, suka kuma jajjefe shi har ya mutu, yadda Ubangiji ya umarci Musa. ");
INSERT INTO hausa_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“Ka yi magana da Isra’ilawa, ka ce musu, ‘A dukan tsararraki masu zuwa, za ku sa tuntaye a gefen rigunarku, su sa zare mai ruwan shuɗi a bisan kowane tuntu. ");
INSERT INTO hausa_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Tuntayen za su zama muku abin dubawa don ku riƙa tunawa da dukan umarnan Ubangiji, don kada ku bi son zuciyarku, da sha’awar idanunku yadda kuka taɓa yi. ");
INSERT INTO hausa_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Sa’an nan za ku riƙa tuna, ku kuma aikata dukan umarnaina ku zama tsarkaka ga Allahnku. ");
INSERT INTO hausa_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Ni ne Ubangiji Allahnku, da ya fitar da ku daga Masar, don in zama Allahnku. Ni ne Ubangiji Allahnku.’ ” ");
INSERT INTO hausa_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Kora ɗan Izhar, wanda yake Balawe ne daga dangin Kohatawa, wata rana ya nemi Datan da Abiram ’ya’yan Eliyab, da On ɗan Felet dukansu daga kabilar Ruben, suka haɗa kai ");
INSERT INTO hausa_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","suka tayar wa Musa. Sai suka nemi goyon bayan sanannun shugabannin Isra’ilawa da aka naɗa a majalisa su guda 250, ");
INSERT INTO hausa_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","tare kuwa suka zo wurin Musa da Haruna, suka ce musu, “Kun wuce gona da iri! Dukan jama’an nan masu tsarki ne, kowannensu, Ubangiji kuma yana tare da su. Me ya sa kuke ɗaukan kanku fiye da taron jama’ar Ubangiji?” ");
INSERT INTO hausa_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Da Musa ya ji haka, sai ya fāɗi rubda ciki ya yi addu’a ");
INSERT INTO hausa_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Sai ya ce wa Kora da dukan waɗannan da suke tare shi, “Da safe, Ubangiji zai nuna wane ne yake nasa, da kuma wane ne yake da tsarki. Zai kuma sa mutumin yă zo kusa da shi. Mutumin da ya zaɓa kuwa zai sa yă zo kusa da shi. ");
INSERT INTO hausa_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Kai Kora da ƙungiyarka, gobe, za ku ɗauki farantai, ");
INSERT INTO hausa_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","ku zuba wuta a ciki, ku kuma zuba musu turaren wuta a gaban Ubangiji. Sa’an nan wanda Ubangiji ya zaɓa a tsakaninmu sh ne mai tsarki. Ku Lawiyawa ku ne kuka wuce gona da iri!” ");
INSERT INTO hausa_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Musa ya kuma ce wa Kora, “Yanzu ku saurara, ku Lawiyawa! ");
INSERT INTO hausa_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Ashe, bai ishe ku ba, cewa Allah na Isra’ila, ya keɓe ku daga sauran jama’ar Isra’ilawa, ya kuma kawo ku kusa da shi don ku yi aiki a tabanakul na Ubangiji, ku kuma tsaya a gaba jama’a don ku yi musu aiki? ");
INSERT INTO hausa_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Ya kawo ku da kuma dukan ’yan’uwanku Lawiyawa kusa da shi, amma yanzu kuna ƙoƙari ku karɓi aikin firist. ");
INSERT INTO hausa_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Kai da ƙungiyarka kun haɗa kai kuna yi wa Haruna gunaguni, amma wane ne Haruna? A zahiri tawaye ne kuke wa Ubangiji.” ");
INSERT INTO hausa_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Sai Musa ya aika a kira Datan da Abiram, ’ya’yan Eliyab maza, amma suka ce, “Ba za mu zo ba! ");
INSERT INTO hausa_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Bai isa ba ne da ka fitar da mu daga ƙasar mai zub da madara da zuma, ka kawo mu nan hamada don ka kashe mu? Yanzu kuma so kake ka mai da kanka sarki a bisanmu? ");
INSERT INTO hausa_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Ban da haka ma, ai, ba ka riga ka kai mu ƙasar mai zub da madara da zuma ba, ba ka ba mu gādon filaye da gonakin annabi ba, yanzu kuma kana so ka ruɗe mu. Mun ƙi, ba za mun zo ba!” ");
INSERT INTO hausa_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Sai Musa ya husata ƙwarai, ya ce wa Ubangiji, “Kada ka karɓi hadayarsu. Ban ƙwace wani jakinsu ba, ban kuwa cuce waninsu ba.” ");
INSERT INTO hausa_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Musa ya ce wa Kora, “Da kai da kuma dukan ƙungiyarka za ku bayyana a gaban Ubangiji gobe, kai da su. Haruna ma zai kasance a can. ");
INSERT INTO hausa_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Kowannenku zai ɗauki faranti yă zuba turare a ciki. Wato, farantai 250 ke nan, a kuma miƙa su a gaban Ubangiji. Kai da Haruna za ku miƙa farantanku, ku ma.” ");
INSERT INTO hausa_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Sai kowane mutum ya ɗauki farantinsa, ya sa wuta da kuma turare a ciki, suka tsaya da Musa da Haruna a ƙofar Tentin Sujada. ");
INSERT INTO hausa_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Sa’ad da Kora ya tara mabiyansa don su yi hamayya da Musa da Haruna a ƙofar Tentin Sujada, sai ɗaukakar Ubangiji ta bayyana ga dukan taron. ");
INSERT INTO hausa_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Ubangiji ya ce wa Musa da Haruna, ");
INSERT INTO hausa_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Ku ware kanku daga taron nan don in gama da su nan take.” ");
INSERT INTO hausa_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Amma Musa da Haruna suka fāɗi rubda ciki suka tā da murya suka ce, “Ya Allah, Allahn ruhohin dukan ’yan adam, za ka husata da dukan taron ne, bayan mutum ɗaya ne ya yi zunubi?” ");
INSERT INTO hausa_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Sai Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Faɗa wa taron cewa, ‘Ku nisanci tentin Kora, da na Datan, da na Abiram.’ ” ");
INSERT INTO hausa_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Musa ya tashi ya tafi wurin Datan da Abiram, dattawan Isra’ilawa kuwa suka bi shi. ");
INSERT INTO hausa_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Ya gargaɗe taron ya ce, “Ku ƙaurace wa tentin waɗannan mugayen mutane! Kada ku taɓa kome da yake nasu, domin kada a shafe ku saboda zunubansu.” ");
INSERT INTO hausa_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Sai suka tashi daga inda tentin Kora, da Datan, da Abiram suke. Datan da Abiram kuwa suka fita suna tsaye tare da matansu da ’ya’yansu da ’yan ƙananansu a ƙofar tentinsu. ");
INSERT INTO hausa_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Sai Musa ya ce musu, “Da haka za ku san cewa Ubangiji ne ya aiko ni, in yi dukan waɗannan abubuwa, ba da nufin kaina na yi su ba. ");
INSERT INTO hausa_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","In waɗannan mutane sun mutu kamar yadda mutane suke mutuwa, in abin da yakan sami kowa shi ne ya same su, to, ba Ubangiji ne ya aiko ni ba. ");
INSERT INTO hausa_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Amma in Ubangiji ya kawo wani abu sabo, ya sa ƙasa ta buɗe bakinta, ta haɗiye su da dukan abin da suke da shi, suka gangara cikin kabari a raye, ta haka za ku sani mutanen nan sun rena Ubangiji.” ");
INSERT INTO hausa_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Nan da nan da ya gama faɗi wannan, sai ƙasa ta tsage inda Datan da Abiram suke tsaye, ");
INSERT INTO hausa_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","ta kuma buɗe bakinta, ta haɗiye su tare da mutanen gidansu da dukan mutanen Kora da dukan abin da yake mallakarsu. ");
INSERT INTO hausa_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Suka gangara cikin kabari da rai, tare dukan mallakarsu; ƙasa ta rufe su, suka hallaka, suka rabu da jama’ar. ");
INSERT INTO hausa_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Da jin kukansu, dukan Isra’ilawa da suke kewaye da su suka gudu, suna ihu, “Ƙasa za tă haɗiye mu, mu ma!” ");
INSERT INTO hausa_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Sai wuta ta fito daga wurin Ubangiji ta cinye mutane 250 da suke miƙa hadaya da turare. ");
INSERT INTO hausa_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“Ka gaya wa Eleyazar ɗan Haruna, firist, yă kawar da farantan ƙona turare daga wurin da wutar ta cinye, yă watsar da gawayin a wani wuri, gama farantan tsarkakakku ne, ");
INSERT INTO hausa_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","gama an yi amfani da farantan don miƙa mini turare. Sai ka ɗauki farantan mutanen da suka yi zunubin da ya jawo musu mutuwa ka ƙera farantan, ka yi murfin bagade da su, gama an miƙa su a gaban Ubangiji, suka zama tsarkakakku. Bari su zama alama ga Isra’ilawa.” ");
INSERT INTO hausa_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Haka Eleyazar, firist, ya tattara farantan tagulla waɗanda mutanen da aka hallaka suka kawo, ya ƙera murfin bagade da su, ");
INSERT INTO hausa_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","yadda Ubangiji ya umarce shi, ta wurin Musa. Wannan ya zama abin tuni ga Isra’ilawa domin kada wani da ba firist ba, bai kuwa fito a cikin zuriyar Haruna ba, yă zo don yă ƙona turare a gaban Ubangiji, domin kada yă zama kamar Kora da mabiyansa. ");
INSERT INTO hausa_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Kashegari dukan taron Isra’ilawa suka yi gunaguni a kan Musa da Haruna suka ce, “Kun kashe mutanen Ubangiji.” ");
INSERT INTO hausa_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Bayan haka, sai dukan jama’a suka taru domin su nuna rashin yardansu da abin da suke zato Musa da Haruna ne suka aikata. Da suka fuskanci Tentin Sujada, nan take sai girgije ya rufe shi, ɗaukaka Ubangiji kuwa ta bayyana. ");
INSERT INTO hausa_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Sai Musa da Haruna suka je gaban Tentin Sujada, ");
INSERT INTO hausa_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","Ubangiji kuma ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“Ku nisanci wannan taro, gama yanzu nan zan hallaka su.” Sai Musa da Haruna suka fāɗi rubda ciki. ");
INSERT INTO hausa_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Sai Musa ya ce wa Haruna, “Ka ɗauki farantinka ka sa turare a ciki, da wuta daga bagade, ka yi maza ka tafi wajen taron, ka yi kafara dominsu. Gama fushin Ubangiji ya riga ya sauko; an kuma fara annoba.” ");
INSERT INTO hausa_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Saboda haka Haruna ya yi kamar yadda Musa ya faɗa, ya ruga a guje zuwa tsakiyar taron. An riga an fara annobar a cikin mutane, amma Haruna ya miƙa turaren ya kuma yi kafara dominsu. ");
INSERT INTO hausa_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Ya tsaya tsakanin matattu da masu rai, annobar kuwa ta tsaya. ");
INSERT INTO hausa_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Amma mutane 14,700 ne suka mutu a annobar, ban da waɗanda suka mutu a sanadin Kora. ");
INSERT INTO hausa_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Sai Haruna ya komo wurin Musa a ƙofar Tentin Sujada, gama annobar ta ƙare. ");
INSERT INTO hausa_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Ka yi magana da Isra’ilawa, ka kuma karɓi sanduna goma sha biyu daga wurinsu, sanda guda daga kowane shugaban gidan kakanninsu. Ka rubuta sunan kowa a sandansa. ");
INSERT INTO hausa_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","A kan sandan Lawi kuwa ka rubuta sunan Haruna, gama dole a sami sanda ɗaya saboda shugaban gidan kakanninsu. ");
INSERT INTO hausa_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Ka ajiye su a Tentin Sujada, a gaba akwatin Alkawari, inda zan sadu da kai. ");
INSERT INTO hausa_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Sandan mutumin da na zaɓa zai yi toho, da haka zan raba kaina da gunagunin da Isra’ilawa suke yi.” ");
INSERT INTO hausa_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Saboda haka Musa ya yi magana da Isra’ilawa, sai shugabanninsu suka ba shi sanduna goma sha biyu, sanda ɗaya don shugaba, bisa ga gidajen kakanninsu, sandan Haruna kuma yana a cikinsu. ");
INSERT INTO hausa_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Sai Musa ya ajiye sandunan a gaban Ubangiji a cikin Tentin Sujada. ");
INSERT INTO hausa_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Kashegari da Musa ya shiga cikin Tentin Sujada sai ga sandan Haruna na gidan Lawiyawa ya yi toho, ya yi furanni, ya kuma yi ’ya’yan almon. ");
INSERT INTO hausa_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Sai Musa ya fitar wa dukan Isra’ilawa dukan sandunan da suke daga gaban Ubangiji. Suka duba, kowa kuma ya ɗauki sandansa. ");
INSERT INTO hausa_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Ubangiji ya ce wa Musa, “Ka mayar da sandan Haruna a akwatin Alkawari, don a ajiye shi alama ga masu tawaye. Wannan zai kawo ƙarshen gunaguninsu a kaina, domin kada su mutu.” ");
INSERT INTO hausa_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Musa kuwa ya aikata kamar dai yadda Ubangiji ya umarce shi. ");
INSERT INTO hausa_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Sai Isra’ilawa suka ce wa Musa, “To, ai in haka ne, mun ƙare ke nan! ");
INSERT INTO hausa_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Idan an ce duk wanda ya zo kusa da tabanakul na Ubangiji zai mutu, ai rayuwarmu kamar mun mutu ke nan.” ");
INSERT INTO hausa_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Ubangiji ya ce wa Haruna, “Kai da ’ya’yanka, da kuma iyalin mahaifinka za ku ɗauki hakkin abin da ya shafi Tentin Sujada, kai da ’ya’yanka kaɗai za ku ɗauki hakkin aikinku wanda ya shafi firistoci. ");
INSERT INTO hausa_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Ka kawo ’yan’uwanka Lawiyawa daga kabilar kakanka tare da kai, don su taimake ka sa’ad da kai da ’ya’yanka kuke hidima a gaban Tentin Sujada. ");
INSERT INTO hausa_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Za su kasance a ƙarƙashinka, su ne kuma za su yi dukan hidima ta Tenti, amma kada su je kusa da kayayyakin wuri mai tsarki, ko bagade, in ba haka ba, da kai da su, za ku mutu. ");
INSERT INTO hausa_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Za su haɗa hannu tare da kai su ɗauki nauyin lura da Tentin Sujada, dukan ayyuka a Tenti, ba kuma wanda zai zo kusa da inda kake. ");
INSERT INTO hausa_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","“Kai ne za ka ɗauki nauyin lura da wuri mai tsarki da bagade, domin kada fushi yă sāke fāɗa a kan Isra’ilawa. ");
INSERT INTO hausa_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Ni da kaina na zaɓo ’yan’uwanka Lawiyawa daga cikin Isra’ilawa a matsayin kyauta a gare ku, keɓaɓɓu don Ubangiji, domin su yi hidima a Tentin Sujada. ");
INSERT INTO hausa_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Amma kai ne kaɗai da ’ya’yanka za ku yi aiki a matsayin firistoci game da kowane abu a Tentin Sujada da kuma bayan labule. Ina ba ka aikin firist, yă zama naka. Duk wani kuma da ya zo kusa da wuri mai tsarki, dole a kashe shi.” ");
INSERT INTO hausa_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Sai Ubangiji ya ce wa Haruna, “Na ba ka aikin lura da hadayun da za a miƙa mini, dukan tsarkakan hadayun da Isra’ilawa suka ba ni, na ba ka su su zama rabonka da na ’ya’yanka har abada. ");
INSERT INTO hausa_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Kai za ka riƙe sashe mafi tsarki na hadayun da suka ragu daga wuta. Daga dukan kyautai mafi tsarki na hadayun da suka miƙa mini, ko ta gari, ko don zunubi, ko kuma don laifi, wannan kashi naka ne da ’ya’yanka. ");
INSERT INTO hausa_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Ku ci shi a matsayin abu mafi tsarki; kowane namiji zai ci. Dole ku ɗauke shi da tsarki. ");
INSERT INTO hausa_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“Har yanzu kuma duk abin da aka keɓe daga kyautai na dukan hadayun kaɗawa na Isra’ilawa naka ne. Na ba da wannan gare ka da ’ya’yanka maza da mata, a kowane lokaci. Kowa da yake da tsarki a gidanka zai iya ci. ");
INSERT INTO hausa_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","“Na ba ka duk man zaitun mafi kyau, da ruwan inabi mafi kyau duka, da hatsi mafi kyau duka na nunan farinsu da suke bayarwa ga Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Dukan nunan fari na ƙasar da suke kawo wa Ubangiji, zai zama naka. Kowa da yake da tsarki a gidanka zai iya ci. ");
INSERT INTO hausa_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“Kome a Isra’ila da aka keɓe wa Ubangiji, zai zama naka. ");
INSERT INTO hausa_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Kowane haihuwar fari, ta mutum, ko ta dabba da suka miƙa wa Ubangiji, naka ne. Amma ka fanshi kowace haihuwar fari ta mutum, ko ta dabbar da take haram. ");
INSERT INTO hausa_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Sa’ad da suke wata ɗaya da haihuwa, dole a fanshe su a bakin shekel biyar-biyar, bisa ga ma’aunin shekel na tsattsarkan wuri da ake amfani da shi, wanda nauyinsa ya kai gera ashirin. ");
INSERT INTO hausa_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","“Amma kada ka fanshe ɗan fari na saniya, tunkiya, ko akuya; gama suna da tsarki. Ka yayyafa jininsu a bisan bagade, ka kuma ƙone kitsensu kamar hadayar da ka yi da wuta, mai daɗin ƙanshi ga Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Namansu zai zama naka, haka ma ƙirji na kaɗawa da cinyar dama za su zama naka. ");
INSERT INTO hausa_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Kome da aka keɓe daga tsarkakakku hadayun da Isra’ilawa suka miƙa wa Ubangiji, na ba ka, da kai da ’ya’yanka maza da mata a matsayin zaunannen rabo. Wannan madawwamin alkawarin gishiri ne a gaban Ubangiji dominka da zuriyarka.” ");
INSERT INTO hausa_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Ubangiji ya ce wa Haruna, “Ba ka da gādo a ƙasarsu, ba kuwa za ka sami rabo daga cikinsu ba; ni ne rabonka da gādonka a cikin Isra’ilawa. ");
INSERT INTO hausa_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","“Na ba wa Lawiyawa dukan zakka na Isra’ilawa a matsayin gādonsu, saboda aikin da suke yi yayinda suke hidima a Tentin Sujada. ");
INSERT INTO hausa_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Daga yanzu zuwa gaba, kada Isra’ilawa su yi kusa da Tentin Sujada, in ba haka ba kuwa su sha hukuncin zunubinsu, su kuma mutu. ");
INSERT INTO hausa_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Lawiyawa ne za su yi aikin Tentin Sujada, su kuma ɗauki nauyin kowane laifin da aka aikata a wurin. Wannan za tă zama dawwammamiyar farilla ce daga yanzu har tsararraki masu zuwa. Ba za su sami gādo a cikin Isra’ilawa ba. ");
INSERT INTO hausa_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","A maimako haka, na ba wa Lawiyawa zakka da Isra’ilawa suka kawo domin hadaya ga Ubangiji, a matsayin gādonsu. Shi ya sa na ce game da su, ‘Ba su da gādo a cikin Isra’ilawa.’ ” ");
INSERT INTO hausa_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“Ka yi wa Lawiyawa magana, ka ce musu, ‘Sa’ad da kuka karɓi zakka daga Isra’ila da na ba ku gādo, dole ku miƙa kashi ɗaya bisa goma na wannan zakka a matsayin hadaya ga Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Za a lissafta hadayarku kamar hatsin da aka sussuka daga masussuka, ko ruwan inabi daga wurin matsewar inabi. ");
INSERT INTO hausa_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Ta haka za ku miƙa hadaya ga Ubangiji daga cikin dukan zakkar da kuka karɓa daga wurin Isra’ilawa. Daga waɗannan zakka kuwa dole ku ba Haruna firist rabon Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Dole ku miƙa wa Ubangiji rabo mafi kyau da kuma sashi mafi tsarki na kowane abin da aka ba ku.’ ");
INSERT INTO hausa_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","“Ka faɗa wa Lawiyawa cewa, ‘Sa’ad da kuka miƙa sashi mafi kyau, za a lissafta shi a matsayin abin da ya fito daga masussuka, ko wurin matsewar ruwan inabi ne. ");
INSERT INTO hausa_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Da kai da gidanka, za ku iya cin abin da ya rage a ko’ina, gama ladan aikinku ne a Tentin Sujada. ");
INSERT INTO hausa_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Ta wurin miƙa masa sashi mafi kyau, ba za ku zama masu laifi a wannan batu ba; ta haka ba za ku ƙazantar da tsarkakakkun hadayu na Isra’ilawa ba, ba kuwa za ku mutu ba.’ ” ");
INSERT INTO hausa_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Ubangiji ya ce wa Musa da Haruna, ");
INSERT INTO hausa_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“Wannan ita ce ƙa’ida wadda Ubangiji ya umarta. Faɗa wa Isra’ilawa su kawo maka jan karsana marar lahani, ko marar aibi wadda ba a taɓa sa ta tă yi noma ba. ");
INSERT INTO hausa_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Ka ba wa Eleyazar firist; a kuma kai ta bayan sansani, a yanka a gaban Eleyazar. ");
INSERT INTO hausa_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Sa’an nan Eleyazar firist zai ɗiba jininta a yatsarsa, yă yayyafa sau bakwai wajen gaban Tentin Sujada. ");
INSERT INTO hausa_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Sa’an nan a ƙone dukan karsanar, haɗe da fatarta, naman, jinin da kayan cikin, yayinda Eleyazar yake kallo. ");
INSERT INTO hausa_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Firist zai ɗauki itacen al’ul, da hizzob, da jan ulu, yă jefa su a kan karsanar da ake ƙonewa. ");
INSERT INTO hausa_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Bayan haka, dole firist yă wanke rigunarsa, yă kuma yi wanka. Sa’an nan zai iya shiga cikin sansani, amma zai kasance da ƙazanta har yamma. ");
INSERT INTO hausa_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Dole mutumin da ya ƙone ta yă wanke rigunarsa, yă kuma yi wanka, shi ma zai kasance da ƙazanta har yamma. ");
INSERT INTO hausa_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","“Mutumin da yake da tsarki, zai tara tokar karsanar, yă sa ta a wurin da yake da tsabta a bayan sansani. Jama’ar Isra’ilawa ne za su adana shi don amfani a ruwan tsabtaccewa; wannan domin tsarkakewa ne daga zunubi. ");
INSERT INTO hausa_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Dole mutumin da ya tara tokar karsanar yă wanke rigunarsa, zai kuwa kasance da ƙazanta har yamma. Wannan za tă zama dawwammamiyar farilla ta har abada ga Isra’ilawa, da kuma baƙin da suke zama a cikinsu. ");
INSERT INTO hausa_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“Duk wanda ya taɓa gawa, zai kasance da ƙazanta har kwana bakwai. ");
INSERT INTO hausa_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Dole yă tsarkake kansa da ruwa a rana ta uku, da kuma a rana ta bakwai; sa’an nan zai zama da tsarki. Amma in bai tsarkake kansa a rana ta uku da kuma a rana ta bakwai ba, ba zai kasance da tsarki ba. ");
INSERT INTO hausa_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Duk wanda ya taɓa gawar wani, bai kuma tsarkake kansa ba, ya ƙazantar da tabanakul na Ubangiji ke nan. Dole a ware wannan mutum daga cikin Isra’ilawa. Gama ba a yayyafa ruwan tsabtaccewa a kansa ba; ya ƙazantu, ya kasance da ƙazanta ke nan. ");
INSERT INTO hausa_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“Ga ƙa’idar da za a bi in mutum ya mutu a cikin tenti. Duk wanda ya shiga tentin, kuma duk wanda yake cikinsa, za su zama da ƙazanta har kwana bakwai, ");
INSERT INTO hausa_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","kuma kowane abin da ake zuba kaya, wanda ba shi da murfi a kansa, zai zama da ƙazanta. ");
INSERT INTO hausa_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","“Wanda duk yake a fili, ya kuma taɓa gawa wanda aka kashe da takobi, ko wanda ya mutu mutuwar Allah, ko ƙashin mutum, ko kabari, zai ƙazantu har bakwai. ");
INSERT INTO hausa_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“Ga wanda ya ƙazantu kuwa, a ɗiba toka daga hadaya ta ƙonawa ta tsarkakewa, a zuba a cikin tulu, sa’an nan a zuba ruwa mai gudu a kansu. ");
INSERT INTO hausa_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Sa’an nan wanda yake tsarkakakke, zai ɗauki hizzob yă tsoma a ruwa, yă yayyafa a tentin da dukan kayayyakinsa, da kuma a kan mutanen da suke wurin. Dole kuma yă yayyafa ruwan a kan duk wanda ya taɓa ƙashin mutu, ko kabari, ko kuma wanda aka kashe, ko wanda ya yi mutuwa ta Allah. ");
INSERT INTO hausa_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","A rana ta uku, da ta bakwai kuma mai tsarkakewa zai yayyafa wa marar tsarkin ruwa, a rana ta bakwai kuma yă tsarkake shi. Wanda aka tsarkaken kuwa, dole yă wanke rigunarsa, yă kuma yi wanka da yamma, zai kuma tsarkaka. ");
INSERT INTO hausa_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Amma in wanda yake da ƙazanta bai tsarkake kansa ba, dole a ware shi daga cikin jama’a, domin ya ƙazantar da wuri mai tsarki na Ubangiji. Ba a yayyafa masa ruwa na tsarkakewa ba, ya zama da ƙazanta. ");
INSERT INTO hausa_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Wannan za tă zama musu dawwammamiyar farilla. “Mutumin da ya yayyafa ruwa na tsarkakewa, shi ma dole yă wanke rigarsa. Duk wanda kuma ya taɓa ruwan tsarkakewa, zai kasance da ƙazanta har yamma. ");
INSERT INTO hausa_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Duk abin da mai ƙazanta ya taɓa, ya ƙazantu, kowa kuma ya taɓa wannan abu, ya ƙazantu ke nan, har yamma.” ");
INSERT INTO hausa_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","A watan fari, dukan jama’ar Isra’ilawa suka iso Hamadan Zin. Suka sauka a Kadesh. A nan ne Miriyam ta mutu, aka kuma bizne ta. ");
INSERT INTO hausa_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Sai aka rasa ruwa da jama’a za su sha, mutane suka taru, suka tayar wa Musa da Haruna. ");
INSERT INTO hausa_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Suka yi gunaguni wa Musa suka ce, “Da ma mun mutu sa’ad da ’yan’uwanmu suka mutu a gaban Ubangiji! ");
INSERT INTO hausa_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Don me ka kawo jama’ar Ubangiji a wannan hamada, don mu da dabbobinmu mu mutu a nan ke nan? ");
INSERT INTO hausa_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Don me ka fitar da mu daga Masar zuwa wannan banzan wuri, inda babu hatsi ko ɓaure, inabi ko rumman. Kuma babu ruwan da za a sha?” ");
INSERT INTO hausa_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Sai Musa da Haruna suka tashi daga taron, suka tafi ƙofar Tentin Sujada, suka fāɗi rubda ciki, sai ɗaukakar Ubangiji ta bayyana musu. ");
INSERT INTO hausa_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Ka ɗauki sandanka, kai da Haruna, ɗan’uwanka, ku tara jama’a, ku yi magana da dutsen a gabansu ya ba da ruwan da yake cikinsa. Za ka sa ruwa ya ɓuɓɓugo musu daga dutsen. Ta haka za ka ba taron jama’a da garkunansu ruwan sha.” ");
INSERT INTO hausa_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Sai Musa ya je ya ɗauki sandan kamar yadda Ubangiji ya umarce shi. ");
INSERT INTO hausa_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Shi da Haruna, suka tara jama’a a gaban dutsen, Musa ya ce musu, “Ku saurara, ku ’yan tawaye, dole mu kawo muku ruwa daga wannan dutse?” ");
INSERT INTO hausa_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Sai Musa ya ɗaga hannu, ya bugi dutsen sau biyu da sandansa. Ruwa kuwa ya yi ta kwararowa, jama’a da dabbobinsu suka sha. ");
INSERT INTO hausa_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Amma Ubangiji ya ce wa Musa da Haruna. “Tun da yake ba ku gaskata ni ba, ba ku kuwa ɗaukaka ni a idon Isra’ilawa ba, to, ba za ku kai taron jama’an nan a ƙasar da na ba su ba.” ");
INSERT INTO hausa_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Waɗannan su ne ruwan Meriba, inda Isra’ilawa suka yi wa Ubangiji gunaguni, inda kuma ya nuna kansa mai tsarki a cikinsu. ");
INSERT INTO hausa_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Musa ya aiki manzanni daga Kadesh zuwa wurin sarkin Edom cewa, “Ga abin da ɗan’uwanka Isra’ila ya ce ka san duk irin wahalolin da ya same mu. ");
INSERT INTO hausa_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Kakanninmu sun gangaro zuwa Masar, muka zauna can shekaru da yawa. Masarawa suka wulaƙanta mu, da kuma kakanninmu, ");
INSERT INTO hausa_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","amma da muka yi kuka a gaban Ubangiji, ya kuwa ji mu, sai ya aiko mala’ika, ya fitar da mu daga Masar. “Yanzu ga mu a Kadesh, garin da yake kan iyakar yankinka. ");
INSERT INTO hausa_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Muna roƙonka, ka yarda mana mu bi ta ƙasarka. Ba za mu bi ta wani fili, ko gonar inabi ba, ko mu sha ruwa daga wata rijiya ba. Za mu bi ta babban hanyar sarki, ba kuwa za mu kauce dama, ko hagu ba, har mu wuce yankinka.” ");
INSERT INTO hausa_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Amma Edom ya amsa ya ce, “Ba za ku bi ta nan ba; in kuka kuskura, za mu fito, mu yaƙe ku da takobi.” ");
INSERT INTO hausa_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Sai Isra’ilawa suka amsa, suka ce, “Za mu bi ta babbar hanya, in mu, ko dabbobinmu suka sha ruwanku, za mu biya. Mu dai muna so mu wuce ne kawai.” ");
INSERT INTO hausa_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Sai mutanen Edom suka sāke amsa suka ce, “Ba za ku bi nan ba dai.” Sai Edom ya fito da runduna mai ƙarfi da yawa gaske a kan Isra’ila. ");
INSERT INTO hausa_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Da yake Edom suka ƙi su bar su su ratsa yankinsu, sai Isra’ila suka juya suka janye daga gare su. ");
INSERT INTO hausa_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Dukan Jama’ar Isra’ilawa suka tashi daga Kadesh, suka zo Dutsen Hor. ");
INSERT INTO hausa_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","A Dutsen Hor, kusa da iyakar Edom, Ubangiji ya ce wa Musa da Haruna, ");
INSERT INTO hausa_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“Haruna zai rasu. Ba zai shiga ƙasar da na ba Isra’ilawa ba, domin ku biyu, kun ƙi ku bi umarnina a ruwan Meriba. ");
INSERT INTO hausa_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Ka kawo Haruna da ɗansa Eleyazar, ka kai su a bisan Dutsen Hor. ");
INSERT INTO hausa_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Ka tuɓe taguwar Haruna ka sa wa ɗansa Eleyazar, gama Haruna zai rasu a can.” ");
INSERT INTO hausa_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Musa ya yi yadda Ubangiji ya umarta. Suka hau Dutsen Hor a idon dukan jama’a. ");
INSERT INTO hausa_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Musa ya tuɓe taguwar Haruna, ya kuma sa wa Eleyazar ɗan Haruna. Nan kuwa Haruna ya mutu a bisa dutsen. Sa’an nan Musa da Eleyazar suka sauka daga dutsen, ");
INSERT INTO hausa_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","sa’ad da dukan jama’a kuwa suka ji cewa Haruna ya mutu, sai dukan gidan Isra’ila suka yi makoki dominsa har kwana talatin. ");
INSERT INTO hausa_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Sa’ad da sarkin Arad, mutumin Kan’ana, wanda yake zaune a Negeb, da ya ji cewa Isra’ila yana zuwa ta hanyar Atarim, sai ya fito, yă yaƙi Isra’ilawa, yă kuma kama waɗansunsu. ");
INSERT INTO hausa_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Sai Isra’ila suka yi alkawari wa Ubangiji suka ce, “In ka ba da waɗannan mutane a hannunmu, za mu hallaka dukan garuruwansu ƙaf.” ");
INSERT INTO hausa_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Ubangiji kuwa ya saurari kukan Isra’ila, ya kuma ba da Kan’aniyawa a gare su. Suka hallaka su da biranensu ƙaf; saboda haka aka sa wa wurin suna Horma. ");
INSERT INTO hausa_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Suka kama hanya daga Dutsen Hor ta hanya zuwa Jan Teku, don su kauce wa Edom. Amma mutane suka rasa haƙuri a hanya; ");
INSERT INTO hausa_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","suka yi wa Allah da Musa gunaguni, suka ce, “Me ya sa kuka fitar da mu daga Masar, kuka kawo mu mu mutu a wannan hamada? Babu abinci! Babu ruwa! Mu dai mun gaji da wannan abinci marar amfani!” ");
INSERT INTO hausa_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Sai Ubangiji ya aiko da macizai masu dafin a cikinsu, suka sassari mutane, Isra’ilawa masu yawa kuwa suka mutu. ");
INSERT INTO hausa_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Mutanen suka zo wurin Musa, suka ce, “Mun yi zunubi, da muka yi wa Ubangiji da kai gunaguni. Ka yi addu’a don Ubangiji yă ɗauke mana macizan nan.” Saboda haka Musa ya yi addu’a domin mutane. ");
INSERT INTO hausa_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Ubangiji ya ce wa Musa, “Ka ƙera siffar maciji ka rataye shi a bisa doguwar sanda; kowa da maciji ya sare shi, idan ya dubi macijin nan da ka rataye, zai rayu.” ");
INSERT INTO hausa_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Saboda haka Musa ya ƙera macijin tagulla, ya kuma rataye shi bisa doguwar sanda. Sa’an nan duk wanda maciji ya sare shi, ya kuma dubi macijin tagullar, zai warke. ");
INSERT INTO hausa_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Isra’ilawa suka kama hanya, suka yi sansani a Obot. ");
INSERT INTO hausa_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Sai suka tashi daga Obot, suka yi sansani a Iye Abarim a hamadar da take fuskantar Mowab, wajen fitowar rana. ");
INSERT INTO hausa_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Daga nan kuma suka ci gaba, suka yi sansani a Kwarin Zered. ");
INSERT INTO hausa_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Suka tashi daga nan, suka sauka kusa da Arnon wanda yake a hamadar da ta miƙe zuwa iyakar Amoriyawa. Arnon shi ne iyakar Mowab, wanda yake tsakanin Mowab da Amoriyawa. ");
INSERT INTO hausa_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Shi ya sa Littafin Yaƙoƙin Ubangiji ya ce, “Waheb ta cikin yankin Sufa, da kwaruruka na tuddan Arnon, ");
INSERT INTO hausa_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","da gangaren kwaruruka, wanda ya nausa zuwa garin Ar, ya kuma dangana da kan iyakar Mowab.” ");
INSERT INTO hausa_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Daga can, suka gangara zuwa Beyer, wato, rijiyar da Ubangiji ya ce wa Musa, “Ka tattara mutane duka, zan kuwa ba su ruwa.” ");
INSERT INTO hausa_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Sai Isra’ilawa suka rera wannan waƙa, “Ki ɓuɓɓugo da ruwa, Ke rijiya! Rera waƙa game da ita, ");
INSERT INTO hausa_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","game da rijiyar da ’ya’yan sarki suka haƙa, rijiyar da manyan mutane masu sandunan sarauta suka nuna da sandunansu.” Sa’an nan suka tashi daga hamadar, suka tafi Mattana, ");
INSERT INTO hausa_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","daga Mattana, suka tafi Nahaliyel, daga Nahaliyel, suka tafi Bamot, ");
INSERT INTO hausa_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","daga Bamot kuma suka tafi kwarin da yake cikin Mowab inda ƙwanƙolin Fisga yake fuskantar hamada. ");
INSERT INTO hausa_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Isra’ila suka aiki manzanni wurin Sihon sarkin Amoriyawa su ce, ");
INSERT INTO hausa_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“Ka bari mu ratsa ta ƙasarka. Ba za mu shiga wata gona ba, ba za mu kuma shiga gonar inabi, ko mu sha ruwa daga wata rijiya ba. Za mu bi ta babbar hanyar sarki, har mu fita ƙasarka.” ");
INSERT INTO hausa_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Amma Sihon bai bar Isra’ila su ratsa ta yankinsa ba. Sai ya tara dukan sojojinsa, suka fita zuwa cikin hamada, su yaƙi Isra’ila. Da ya kai Yahaz, sai ya yaƙi Isra’ila. ");
INSERT INTO hausa_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Isra’ila fa suka kashe shi da takobi, suka ƙwace ƙasarsa, tun daga kogin Arnon har zuwa kogin Yabbok, zuwa kan iyakar Ammonawa kawai, gama sun yi wa iyakansu katanga. ");
INSERT INTO hausa_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Isra’ila suka ci dukan biranen Amoriyawa, suka kuma zauna a cikinsu, haɗe da babban birnin Heshbon da dukan ƙauyukanta. ");
INSERT INTO hausa_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Sihon sarkin Amoriyawa ya yi mulkin Heshbon, bayan ya ci sarkin Mowab na dā da yaƙi, ya kuma ƙwace dukan ƙasarsa har zuwa arewancin kogin Arnon. ");
INSERT INTO hausa_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Shi ya sa Amoriyawa suka rubuta wannan waƙa game da Heshbon suka ce, “Ku zo mu sāke gina Heshbon, birnin Sihon. ");
INSERT INTO hausa_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","“Mayaƙansa sun fito kamar harshen wuta suka ƙone birnin Ar na Mowab suna hallaka ’yan ƙasar tuddan Arnon. ");
INSERT INTO hausa_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Kaitonki, Mowab! Gunkinki Kemosh ya yashe mutanenki; aka kuma kama su, aka kai su bauta wajen Sihon sarkin Amoriyawa. ");
INSERT INTO hausa_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","“Amma mun tumɓuke su, mun hallaka garuruwan Heshbon har zuwa Dibon. Mun ragargaza su har zuwa Nofa wanda ya miƙe zuwa Medeba.” ");
INSERT INTO hausa_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Ta haka Isra’ila suka zauna a ƙasar Amoriyawa. ");
INSERT INTO hausa_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Sai Musa ya aika ’yan leƙen asiri zuwa Yazer. Daga baya, sai Isra’ilawa suka ci ƙauyukan da suke kewaye, suka kuma kori Amoriyawa da suke zaune a can. ");
INSERT INTO hausa_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Sai suka juya suka haura kan hanya ta zuwa Bashan, inda Og yake sarauta, ya kuwa fito tare da dukan sojojinsa suka yi yaƙi da Isra’ila a Edireyi. ");
INSERT INTO hausa_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Ubangiji ya ce wa Musa, “Kada ka ji tsoronsa, gama na ba da shi a gare ka, da dukan sojojinsa da kuma ƙasarsa. Ka yi da shi yadda ka yi da Sihon sarkin Amoriyawa, wanda ya yi mulki a Heshbon.” ");
INSERT INTO hausa_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Ta haka suka kashe shi, tare da ’ya’yansa maza da kuma dukan sojojinsa, ba wanda ya ragu. Suka kuma mamaye ƙasarsa. ");
INSERT INTO hausa_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Sai Isra’ilawa suka kama hanya, suka tafi filayen Mowab, a wajen Urdun, a ƙetare Yeriko, suka yi sansani a can. ");
INSERT INTO hausa_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","To, fa, Balak ɗan Ziffor ya ga duk abin da Isra’ila suka yi da Amoriyawa. ");
INSERT INTO hausa_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Sai Mowab ya firgita ƙwarai saboda yawan mutanen. Tsoron Isra’ilawa ya kama su. ");
INSERT INTO hausa_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Sai Mowabawa suka ce wa dattawan Midiyawa, “Wannan taron zai lashe duk abin da ya kewaye mu kamar yadda saniya takan lashe ciyawa a fili.” Saboda haka Balak ɗan Ziffor, wanda yake sarkin Mowab a lokacin, ");
INSERT INTO hausa_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","ya aika manzanni su zo da Bala’am ɗan Beyor, wanda yake a Fetor, kusa da Kogi, a ƙasar haihuwarsa. Balak ya ce, “Ga mutane sun fito daga Masar; sun mamaye ƙasar, suka kuma yi sansani kusa da ni. ");
INSERT INTO hausa_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Ka zo yanzu ka la’anta waɗannan mutane, domin sun fi ƙarfina. Wataƙila zan iya cin nasara a kansu, in kuma kore su daga ƙasar. Gama na sani duk waɗanda ka sa musu albarka, sun zama masu albarka ke nan, waɗanda kuma ka la’anta, sun la’antu ke nan.” ");
INSERT INTO hausa_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Sai dattawan Mowab da na Midiyawa suka tashi, suka ɗauki kuɗi don duba. Da suka zo wurin Bala’am sai suka faɗa masa abin da Balak ya ce. ");
INSERT INTO hausa_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Bala’am ya ce musu, “Ku kwana a nan, ni kuwa zan faɗa muku abin da Ubangiji ya faɗa mini.” Saboda haka dattawan sarkin Mowab suka zauna da shi. ");
INSERT INTO hausa_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Sai Allah ya zo wurin Bala’am ya ce, “Su wane ne waɗannan tare da kai?” ");
INSERT INTO hausa_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Bala’am ya ce wa Allah, “Balak ɗan Ziffor, sarkin Mowab ne, ya aiko mini wannan saƙo cewa, ");
INSERT INTO hausa_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘Ga mutane sun fito daga Masar sun mamaye ƙasar. Ka zo yanzu ka la’anta mini su. Wataƙila ta haka zan yi nasara a kansu, in kuma kore su.’ ” ");
INSERT INTO hausa_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Amma Allah ya ce wa Bala’am, “Kada ka tafi tare da su. Kada ka la’anta mutanen nan, gama su masu albarka ne.” ");
INSERT INTO hausa_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Kashegari Bala’am ya tashi ya ce wa dattawan Balak, “Ku koma ƙasarku, domin Ubangiji ya hana ni in tafi tare da ku.” ");
INSERT INTO hausa_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Saboda haka dattawan Mowab suka koma wurin Balak suka ce, “Bala’am ya ƙi yă zo tare da mu.” ");
INSERT INTO hausa_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Sai Balak ya aika waɗansu dattawa masu yawa, masu daraja kuma fiye da na dā. ");
INSERT INTO hausa_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Suka zo wurin Bala’am suka ce, “Ga abin da Balak ɗan Ziffor ya ce, Kada ka bar wani abu yă hana ka zuwa wurina, ");
INSERT INTO hausa_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","gama zan ba ka lada mai yawa in kuma yi duk abin da ka ce. Ka zo ka la’anta mini waɗannan mutane.” ");
INSERT INTO hausa_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Amma Bala’am ya amsa musu ya ce, “Ko da a ce Balak zai ba ni gidansa cike da azurfa da zinariya, ba zan yi wani abu ko kaɗan saɓanin umarnin Ubangiji Allahna ba. ");
INSERT INTO hausa_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","To, fa, sai ku kwana a nan kamar yadda waɗancan suka yi, ni kuma in roƙi Ubangiji, in ji, wace magana zai ce mini.” ");
INSERT INTO hausa_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","A wannan dare, Allah ya zo wurin Bala’am ya ce, “Da yake waɗannan mutane sun zo su tafi da kai, to, ka tafi tare da su, sai dai ka yi abin da na ce ka yi ne kaɗai.” ");
INSERT INTO hausa_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Bala’am ya tashi da safe, ya ɗaura wa jakarsa sirdi, ya tafi tare da dattawan Mowab. ");
INSERT INTO hausa_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Amma Allah ya husata sa’ad da ya tafi, mala’ikan Ubangiji kuwa ya tsaya a hanya don yă hana shi. Bala’am kuwa yana kan jakarsa tare da bayinsa biyu. ");
INSERT INTO hausa_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Da jakar ta hangi mala’ikan Ubangiji tsaye a hanya da takobi a hannunsa, sai ta kauce daga hanya, ta shiga jeji. Bala’am kuwa ya buge ta don tă koma hanya. ");
INSERT INTO hausa_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Sai mala’ikan Ubangiji ya tsaya a wata matsattsiyar hanya tsakanin gonaki inabi biyu, da bango a kowane gefe. ");
INSERT INTO hausa_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Sa’ad da jakar ta ga mala’ikan Ubangiji, sai ta matse a jikin bango, ta goge ƙafar Bala’am da bangon. Saboda haka sai Bala’am ya sāke bugunta. ");
INSERT INTO hausa_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Sai mala’ikan Ubangiji ya sha gabansa, ya tsaya a ƙunƙuntaccen wuri inda ba wurin juyawa dama ko hagu. ");
INSERT INTO hausa_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Da jakar ta ga mala’ikan Ubangiji, sai ta kwanta a ƙasa, Bala’am kuwa ya husata, sai ya buge ta da sandansa. ");
INSERT INTO hausa_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Ubangiji ya buɗe bakin jakar, sai jakar ta ce wa Bala’am, “Me na yi maka da ka buge ni har sau uku?” ");
INSERT INTO hausa_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Bala’am ya ce wa jakar “Domin kin wulaƙanta ni! Da a ce ina da takobi a hannuna da zan kashe ki nan take.” ");
INSERT INTO hausa_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Jakar ta ce wa Bala’am, “Ni ba jakarka ba ce wadda kake hawa kullum, har yă zuwa yau? Na taɓa yin maka haka?” Bala’am ya ce, “A’a.” ");
INSERT INTO hausa_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Sa’an nan Ubangiji ya buɗe idanun Bala’am, ya kuwa ga mala’ikan Ubangiji tsaye a hanya da takobi a zāre. Sai ya sunkuyar da kansa, ya fāɗi rubda ciki. ");
INSERT INTO hausa_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Sa’an nan mala’ikan Ubangiji ya tambaye shi, “Don me ka buge jakarka har sau uku? Na fito ne don in hana ka, gama hanyarka ba daidai ba ce a gabana. ");
INSERT INTO hausa_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Jakar ta gan ni, ta kauce mini har sau uku. Da a ce ba tă kauce ba, lalle da na kashe ka, in kuwa bar ta da rai.” ");
INSERT INTO hausa_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Bala’am ya ce wa mala’ikan Ubangiji, “Na yi zunubi. Ban san ka tsaya a hanya don ka hana ni ba. Yanzu in ba ka ji daɗin tafiyata, sai in koma.” ");
INSERT INTO hausa_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Mala’ikan Ubangiji ya ce wa Bala’am, “Ka tafi tare da mutanen, amma abin da na faɗa maka ne kaɗai za ka faɗa.” Saboda haka Bala’am ya tafi tare da dattawan Balak. ");
INSERT INTO hausa_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Da Balak ya ji cewa Bala’am yana zuwa, sai ya fito, ya tarye shi a garin Mowabawa da suke a iyakar Arnon, a ƙarshen yankinsa. ");
INSERT INTO hausa_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Balak ya ce wa Bala’am, “Ban aika maka saƙo cikin gagawa ba? Me ya sa ba ka zo ba? Ko ban isa in sāka maka ba ne?” ");
INSERT INTO hausa_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Bala’am ya amsa ya ce, “To, ai, ga shi, na zo yanzu. Ina da wani ikon yin wata magana ne? Dole in faɗa abin da Allah ya ce in faɗa ne kawai.” ");
INSERT INTO hausa_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Sa’an nan Bala’am ya tafi tare da Balak zuwa Kiriyat-Huzot, ");
INSERT INTO hausa_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","a can ya yi hadaya da shanu da tumaki, ya kuwa aika wa Bala’am da dattawan da suke tare da shi. ");
INSERT INTO hausa_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Kashegari, Balak ya ɗauki Bala’am ya kai shi kan Bamot Ba’al, daga can ya iya ganin sassan sansanin Isra’ilawa. ");
INSERT INTO hausa_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Bala’am ya ce, “Ka gina mini bagadai bakwai a nan, ka shirya mini bijimai bakwai da raguna bakwai.” ");
INSERT INTO hausa_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balak ya yi yadda Bala’am ya faɗa, sai su biyu suka miƙa bijimi da rago a kan kowane bagade. ");
INSERT INTO hausa_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Sa’an nan Bala’am ya ce wa Balak, “Tsaya nan kusa da hadayarka, ni kuwa in koma wani wurin da yake a kaɗaice. Wataƙila Ubangiji zai sadu da ni. Duk abin da ya bayyana mini, zan faɗa maka.” Sai ya haura kan wani wurin da yake a kaɗaice a tudun. ");
INSERT INTO hausa_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Allah kuwa ya sadu da Bala’am. Bala’am ya ce, “Na shirya bagadai bakwai, na kuma miƙa bijimi guda da rago guda, a kan kowane bagade.” ");
INSERT INTO hausa_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Ubangiji ya ba wa Bala’am saƙo ya ce, “Ka koma wurin Balak, ka faɗa masa wannan saƙo.” ");
INSERT INTO hausa_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Saboda haka, sai Bala’am ya koma wurin Balak ya same shi tsaye a kusa da hadayarsa, tare da dukan dattawan Mowab. ");
INSERT INTO hausa_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Sai Bala’am ya furta abin da Allah ya faɗa masa ya ce, “Balak ya kawo ni daga Aram, sarkin Mowab ya kawo ni daga gabashin duwatsu. Ya ce, ‘Zo, ka la’anta mini Yaƙub; zo, ka tsine Isra’ila.’ ");
INSERT INTO hausa_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Yaya zan iya la’anta waɗanda Allah bai la’anta ba? Yaya zan tsine waɗanda Ubangiji bai tsine ba? ");
INSERT INTO hausa_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Daga kan duwatsu na gan su, daga bisa kan tuddai na hange su. Na ga mutane da suke zaune su kaɗai ba sa ɗauki kansu ɗaya da al’ummai ba. ");
INSERT INTO hausa_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Wa zai iya ƙidaya ƙurar Yaƙub ko yă ƙidaya kashi ɗaya bisa huɗu na Isra’ila? Bari in mutu, mutuwar adali ƙarshena kuma yă zama kamar nasu!” ");
INSERT INTO hausa_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Balak ya ce wa Bala’am, “Me ke nan ka yi mini? Na kawo ka, ka la’anta abokan gābana, sai ga shi albarka kake sa musu!” ");
INSERT INTO hausa_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Bala’am ya ce, “Ba dole in faɗa abin da Ubangiji ya sa a bakina ba?” ");
INSERT INTO hausa_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Sa’an nan Balak ya ce masa, “Zo, mu tafi wani wuri inda za ka gan su; a nan kana ganin sashe ne kawai, ba dukansu ba. Daga can kuwa, ka la’anta mini su.” ");
INSERT INTO hausa_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Saboda haka ya ɗauke shi zuwa filin Zofim a ƙwanƙolin Fisga, a can ya gina bagadai bakwai, ya kuma miƙa bijimi da rago a kan kowane bagade. ");
INSERT INTO hausa_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Bala’am ya ce wa Balak, “Tsaya nan kusa da hadayarka, ni kuwa in je in sadu da Ubangiji a can.” ");
INSERT INTO hausa_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Ubangiji ya sadu da Bala’am, ya kuma ba shi saƙo ya ce, “Koma wurin Balak ka ba shi wannan saƙo.” ");
INSERT INTO hausa_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Saboda haka ya tafi ya same Balak tsaye a kusa da hadayarsa, tare da dattawan Mowab. Balak ya tambaye Bala’am ya ce, “Mene ne Ubangiji ya ce?” ");
INSERT INTO hausa_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Sai Bala’am ya furta saƙon da aka ba shi ya ce, “Tashi, Balak, ka saurara; ka kasa kunne gare ni, ɗan Ziffor. ");
INSERT INTO hausa_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Allah ba mutum ba ne, da zai yi ƙarya, shi ba ɗan mutum ba ne, da zai canja tunaninsa. Yana maganar abin da ba zai iya aikata ba ne? Yakan kuma yi alkawarin da ba zai iya cikawa ba? ");
INSERT INTO hausa_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Na karɓi umarni in sa albarka; na kuwa sa albarka, ba zan iya janye ta ba. ");
INSERT INTO hausa_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","“Bai ga mugunta a cikin Yaƙub ba, bai kuma ga wahala a Isra’ila ba. Ubangiji Allahnsu yana tare da su; sowar Sarki yana cikinsu. ");
INSERT INTO hausa_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Allah ya fitar da su daga Masar; suna da ƙarfi iri na kutunkun ɓauna. ");
INSERT INTO hausa_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Ba wata maitar da za tă ci Yaƙub, ba sihiri da zai cuci Isra’ila. Yanzu za a ce game da Yaƙub da Isra’ila, ‘Duba abin da Allah ya yi!’ ");
INSERT INTO hausa_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Mutane sun tashi kamar ƙaƙƙarfar zakanya; sun tā da kansu kamar zaki wanda ba ya hutawa sai ya cinye naman abin da ya kama ya kuma sha jinin abin da ya kama.” ");
INSERT INTO hausa_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Sai Balak ya ce wa Bala’am, “Kada ka la’anta su, kada kuma ka sa musu albarka!” ");
INSERT INTO hausa_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Bala’am amsa ya ce, “Ban faɗa maka zan yi kaɗai abin da Ubangiji ya ce ba?” ");
INSERT INTO hausa_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Sai Balak ya ce wa Bala’am, “Zo in kai ka wani wuri. Wataƙila zai gamshi Allah, yă bari ka la’anta mini su daga can.” ");
INSERT INTO hausa_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Balak kuwa ya ɗauki Bala’am zuwa ƙwanƙolin Feyor, wanda yake fuskantar hamada. ");
INSERT INTO hausa_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Bala’am ya ce, “Ka gina mini bagadai bakwai a nan, ka kuma shirya mini bijimai bakwai da raguna bakwai.” ");
INSERT INTO hausa_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Balak ya yi yadda Bala’am ya ce, ya kuwa miƙa bijimi da rago a kan kowane bagade. ");
INSERT INTO hausa_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","To, da Bala’am ya ga cewa Ubangiji yana jin daɗin sa wa Isra’ila albarka, bai koma wajen sihiri kamar dā ba, amma ya juya fuskarsa wajen hamada. ");
INSERT INTO hausa_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Da Bala’am ya duba sai ya ga Isra’ila sun yi sansani kabila, kabila, Ruhun Allah kuwa ya sauko masa, ");
INSERT INTO hausa_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","sai ya yi annabcinsa ya ce, “Maganar Bala’am ɗan Beyor, saƙon mutumin da idanunsa ke gani sarai, ");
INSERT INTO hausa_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","maganar mutumin da ya saurari maganar Allah, maganar wanda yake ganin wahayi daga Maɗaukaki, mutumin da ya fāɗi rubda ciki, wanda kuma idanunsa suna a buɗe. ");
INSERT INTO hausa_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","“Ina misalin kyan tentunanka, ya Yaƙub, wuraren zamanka, ya Isra’ila! ");
INSERT INTO hausa_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","“Kamar kwaruruka suke a shimfiɗe, kamar lambu kusa da rafi, kamar itatuwan aloyes da Ubangiji ya dasa, kamar itatuwa al’ul kusa da ruwaye. ");
INSERT INTO hausa_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Ruwa zai kwararo daga bokitinsu; irinsu za su sami ruwa a yalwace. “Sarkinsu zai fi sarkin Agag; mulkinsu zai ɗaukaka. ");
INSERT INTO hausa_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","“Allah ya fitar da su daga Masar; suna da ƙarfin kutunkun ɓauna. Sun cinye abokan gāban, suka kakkarya ƙasusuwansu; da kibiyoyinsu suka sossoke su. ");
INSERT INTO hausa_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Kamar zaki sun laɓe sun kwanta, kamar zakanya, wa zai yi ƙarfin hali yă tashe su? “Bari waɗanda suka albarkace ka, su sami albarka waɗanda kuma suka la’anta ka, su la’antu!” ");
INSERT INTO hausa_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Fushin Balak ya ƙuna a kan Bala’am. Ya tafa hannunsa, ya ce masa, “Na kira ka don ka la’anta abokan gābana, amma sai ga shi ka sa musu albarka har sau uku. ");
INSERT INTO hausa_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Yanzu ka bar nan ka tafi gida! Na ce zan sāka maka da lada mai kyau, amma Ubangiji ya hana ka samun ladan.” ");
INSERT INTO hausa_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Bala’am ya ce wa Balak, “Ban faɗa wa ’yan aikan da ka aiko wurina ba cewa, ");
INSERT INTO hausa_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‘Ko da a ce Balak zai ba ni gidansa cike da azurfa da zinariya, ba zan yi wani abu ko kaɗan saɓanin umarnin Ubangiji Allahna ba, kuma dole in faɗa abin da Ubangiji ya ce ne kawai’? ");
INSERT INTO hausa_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Yanzu zan koma wajen mutanena, amma bari in gargaɗe ka game da abin da mutanen nan za su yi wa mutanenka cikin kwanaki masu zuwa.” ");
INSERT INTO hausa_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Sa’an nan ya furta saƙonsa. “Maganar Bala’am ɗan Beyor, saƙon mutumin da idanunsa ke gani sarai, ");
INSERT INTO hausa_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","maganar mutumin da ya saurari maganar Allah, wanda yake da sani daga Mafi Ɗaukaka, wanda yake ganin wahayi daga Maɗaukaki, wanda ya fāɗi rubda ciki, wanda kuma idanunsa suna a buɗe. ");
INSERT INTO hausa_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","“Na gan shi, amma ba yanzu ba; na hange shi, amma ba kusa ba. Tauraro zai fito daga Yaƙub; sandan mulki zai fito daga Isra’ila. Zai ragargaje goshin Mowab, kawunan dukan ’ya’yan Set. ");
INSERT INTO hausa_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Za a ci Edom da yaƙi; za a ci Seyir, abokiyar gābanta, amma Isra’ila zai ƙara ƙarfi. ");
INSERT INTO hausa_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Mai mulki zai fito daga Yaƙub yă hallaka waɗanda suka ragu a birnin.” ");
INSERT INTO hausa_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Sai Bala’am ya ga Amalek, ya kuma furta maganarsa. “Amalek yana cikin al’ummai na fari, amma zai zama na ƙarshen da za a hallaka.” ");
INSERT INTO hausa_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Sai ya ga Keniyawa, ya kuma furta maganarsa. “Wurin zamanku lafiya yake, an kuma sa sheƙarku a cikin duwatsu; ");
INSERT INTO hausa_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","duk da haka, za a hallaka ku Keniyawa sa’ad da Asshur ya kame ku.” ");
INSERT INTO hausa_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Sai ya furta maganarsa ya ce, “Wayyo, wa zai rayu sa’ad da Allah ya yi haka? ");
INSERT INTO hausa_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Jiragen ruwa za su zo daga Kittim; za su murƙushe Asshur da Eber, amma su ma za a hallaka su.” ");
INSERT INTO hausa_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Sa’an nan Bala’am ya tashi ya koma gidan, Balak kuma ya yi tafiyarsa. ");
INSERT INTO hausa_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Lokacin da Isra’ila suke a sansani a Shittim, sai maza suka fara yin lalata da matan Mowabawa, ");
INSERT INTO hausa_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","waɗanda suka gayyace su zuwa wajen hadayu na allolinsu. Mutane suka ci suka kuma yi wa waɗannan alloli sujada. ");
INSERT INTO hausa_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Ta haka Isra’ila suka sa kai a bautar gumaka Ba’al-Feyor. Ubangiji kuwa ya husata da su. ");
INSERT INTO hausa_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Ubangiji ya ce wa Musa, “Ka kama dukan shugabannin mutanen nan, ka kashe su, ka kuma bar su a tsakar rana a gaban Ubangiji, don Ubangiji yă huce daga fushin da nake yi da Isra’ila.” ");
INSERT INTO hausa_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Saboda haka Musa ya ce wa alƙalan Isra’ila, “Dole kowannenku yă kashe mutanen nan da suka haɗa kai cikin bautar Ba’al-Feyor.” ");
INSERT INTO hausa_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Sa’an nan wani mutumin Isra’ila ya kawo wata Bamidiyana a iyalinsa a idon Musa da dukan taron jama’ar Isra’ila, yayinda suke kuka a ƙofar Tentin Sujada. ");
INSERT INTO hausa_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Da Finehas ɗan Eleyazar, ɗan Haruna, firist, ya ga haka, sai ya bar taron, ya ɗauki māshi ");
INSERT INTO hausa_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","ya bi mutumin Isra’ilan nan cikin tenti, ya soke dukansu biyu, māshin ya ratsa jikin mutumin Isra’ilan har zuwa jikin macen. Sa’an nan aka tsai da annoban nan a kan Isra’ilawa. ");
INSERT INTO hausa_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Waɗanda suka mutu a wannan annoba, sun kai mutum 24,000. ");
INSERT INTO hausa_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“Finehas ɗan Eleyazar, ɗan Haruna, firist, ya kawar da fushina daga Isra’ilawa; saboda ya yi kishi irin nawa a gabansu, don haka saboda ɗaukakata ban kawo ƙarshensu ba. ");
INSERT INTO hausa_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Saboda haka ka faɗa masa cewa zan yi alkawarin salama da shi. ");
INSERT INTO hausa_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Shi da zuriyarsa za su kasance da alkawari na zama firist har abada, saboda kishinsa domin ɗaukakar Allahnsa, ya kuma yi kafara domin Isra’ilawa.” ");
INSERT INTO hausa_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Sunan mutumin Isra’ilan da aka kashe tare da macen nan Bamidiyana kuwa Zimri ne, ɗan Salu, shugaban mutanen Simeyon. ");
INSERT INTO hausa_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Sunan macen nan Bamidiyana da aka kashe kuwa Kozbi ne, ’yar Zur, wani basaraken iyalin Midiyawa. ");
INSERT INTO hausa_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“Ka ɗauki Midiyawa a matsayin abokan gāba, ka kuma kashe su, ");
INSERT INTO hausa_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","gama sun ɗauke ku a matsayin abokan gāba, sa’ad da suka ruɗe ku a kan al’amuran Feyor da ’yar’uwarsu Kozbi ’yar shugaban Midiyawa, macen da aka kashe a annoba ta dalili Feyor.” ");
INSERT INTO hausa_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Bayan annobar, sai Ubangiji ya yi magana da Musa da Eleyazar ɗan Haruna, firist ya ce, ");
INSERT INTO hausa_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“Ku ƙidaya dukan jama’ar Isra’ila daga mai shekaru ashirin zuwa gaba da za su iya aikin sojan Isra’ila.” ");
INSERT INTO hausa_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Musa da Eleyazar firist suka yi musu magana a filayen Mowab kusa da Urdun daga ƙetaren Yeriko, suka ce, ");
INSERT INTO hausa_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“Ku ƙidaya maza daga mai shekara ashirin zuwa gaba yadda Ubangiji ya umarci Musa.” Waɗannan su ne Isra’ilawan da suka fito daga Masar. ");
INSERT INTO hausa_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Zuriyar Ruben ɗan fari na Isra’ila, daga Hanok; kabilar Hanokawa; daga Fallu; kabilar Falluyawa; ");
INSERT INTO hausa_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","daga Hezron, kabilar Hezronawa; daga Karmi, kabilar Karmiyawa. ");
INSERT INTO hausa_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Waɗannan su ne kabilan Ruben; jimillarsu ta kai 43,730. ");
INSERT INTO hausa_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Ɗan Fallu kuwa shi ne Eliyab, ");
INSERT INTO hausa_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","’ya’yan Eliyab maza kuwa su ne, Nemuwel, Datan da Abiram. Datan da Abiram nan, su ne shugabannin mutanen da suka tayar wa Musa da Haruna, suna kuma cikin waɗanda suka bi Kora sa’ad da ya tayar wa Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Ƙasa kuwa ta buɗe ta haɗiye su tare da Kora, wanda ƙungiyarsa ta mutu sa’ad da wuta ta cinye mutum 250. Wannan kuwa ya zama alamar faɗakarwa. ");
INSERT INTO hausa_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Amma fa, zuriyar Kora ba tă mutu ba. ");
INSERT INTO hausa_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Zuriyar Simeyon bisa ga kabilansu, daga Nemuwel, kabilar Nemuwelawa; daga Yamin, kabilar Yaminawa; daga Yakin, kabilar Yakinawa; ");
INSERT INTO hausa_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","daga Zera, kabilar Zerawa; daga Sha’ul, kabilar Sha’ul. ");
INSERT INTO hausa_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Waɗannan su ne kabilan Simeyon; jimillarsu ta kai 22,200. ");
INSERT INTO hausa_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Zuriyar Gad bisa ga kabilansu, daga Zafon, kabilar Zafonawa; daga Haggi, kabilar Haggiwa; daga Shuni, kabilar Shunawa; ");
INSERT INTO hausa_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","daga Ozni, kabilar Ozniyawa daga Eri, kabilar Eriyawa; ");
INSERT INTO hausa_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","daga Arod, kabilar Arodiyawa; daga Areli, kabilar Areliyawa. ");
INSERT INTO hausa_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Waɗannan su ne kabilan Gad, jimillarsu ta kai 40,500. ");
INSERT INTO hausa_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Er da Onan, ’ya’yan Yahuda ne, amma sun mutu a Kan’ana. ");
INSERT INTO hausa_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Zuriyar Yahuda bisa ga kabilansu, daga Shela, kabilar Shelayawa daga Ferez, kabilar Ferezawa; daga Zera, kabilar Zerawa; ");
INSERT INTO hausa_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Zuriyar Ferez kuwa, daga Hezron, kabilar Hezronawa; daga Hamul; kabilar Hamulawa. ");
INSERT INTO hausa_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Waɗannan su ne kabilan Yahuda; jimillarsu ta kai 76,500. ");
INSERT INTO hausa_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Zuriyar Issakar bisa ga kabilansu, daga Tola, kabilar Tolatawa; daga Fuwa, kabilar Fuwayawa; ");
INSERT INTO hausa_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","daga Yashub, kabilar Yashubawa; daga Shimron, kabilar Shimronawa. ");
INSERT INTO hausa_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Waɗannan su ne kabilan Issakar; jimillarsu ta kai 64,300. ");
INSERT INTO hausa_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Zuriyar Zebulun bisa ga kabilansu, daga Sered, kabilar Seredawa; daga Elon kabilar Elonawa; daga Yaleyel; kabilar Yaleyewa. ");
INSERT INTO hausa_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Waɗannan su ne kabilan Zebulun, jimillarsu ta kai 60,500. ");
INSERT INTO hausa_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Zuriyar Yusuf bisa ga kabilansu ta wurin Manasse da Efraim. ");
INSERT INTO hausa_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Zuriyar Manasse, daga Makir, kabilar Makiriyawa (Makir shi ne mahaifin Gileyad); daga Gileyad, kabilar Gileyadawa. ");
INSERT INTO hausa_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Waɗannan su ne zuriya Gileyad, daga Iyezer, kabilar Iyezerawa; daga Helek, kabilar Helekawa; ");
INSERT INTO hausa_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","daga Asriyel, kabilar Asriyelawa; daga Shekem, kabilar Shekem; ");
INSERT INTO hausa_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","daga Shemida, kabilar Shemadawa; daga Hefer, kabilar Heferawa. ");
INSERT INTO hausa_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","(Zelofehad ɗan Hefer, ba shi da ’ya’ya maza; ’yan mata ne kaɗai ya haifa, sunayensu kuwa su ne Mala, Nowa, Hogla, Milka da Tirza.) ");
INSERT INTO hausa_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Waɗannan su ne kabilan Manasse, jimillarsu ta kai 52,700. ");
INSERT INTO hausa_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Waɗannan su ne kabilan Efraim bisa ga kabilansu, daga Shutela, kabilar Shutelawa; daga Beker, kabilar Bekerawa; daga Tahan, kabilar Tahanawa. ");
INSERT INTO hausa_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Waɗannan su ne kabilan Shutelawa, daga Eran, kabilar Eranawa. ");
INSERT INTO hausa_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Waɗannan su ne kabilan Efraim; jimillarsu ta kai 32,500. Waɗannan su ne kabilan Yusuf ta wurin kabilansu. ");
INSERT INTO hausa_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Zuriyar Benyamin bisa ga kabilansu, daga Bela, kabilar Belawa; daga Ashbel, kabilar Ashbelawa; daga Ahiram, kabilar Ahiramawa; ");
INSERT INTO hausa_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","daga Shufam, kabilar Shufamawa; daga Hufam, kabilar Hufamawa. ");
INSERT INTO hausa_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Zuriyar Bela daga Ard da Na’aman, daga Ard, kabilar Ardawa; daga Na’aman, kabilar Na’amawa; ");
INSERT INTO hausa_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Waɗannan su ne kabilan Benyamin, jimillarsu ta kai 45,600. ");
INSERT INTO hausa_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Waɗannan su ne kabilan Dan bisa ga kabilarsu, daga Shuham, kabilar Shuhamawa. Waɗannan su ne kabilan Dan. ");
INSERT INTO hausa_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Dukansu kabilan Shuhamawa ne, jimillarsu ta kai 64,400. ");
INSERT INTO hausa_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Zuriyar Asher bisa ga kabilansu, daga Imna, kabilar Imnawa daga Ishbi, kabilar Ishbiyawa; daga Beriya, kabilar Beriyawa; ");
INSERT INTO hausa_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","daga zuriyar Beriya kuwa, daga Heber, kabilar Heberawa; daga Malkiyel, kabilar Malkiyelawa. ");
INSERT INTO hausa_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","(Asher yana da ’ya mace da ake kira Sera.) ");
INSERT INTO hausa_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Waɗannan su ne kabilan Asher; jimillarsu ta kai 53,400. ");
INSERT INTO hausa_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Zuriyar Naftali bisa ga kabilansu, daga Yazeyel, kabilar Yazeyelawa; daga Guni, kabilar Guniyawa; ");
INSERT INTO hausa_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","daga Yezer, kabilar Yezerawa; daga Shillem, kabilar Shillemawa. ");
INSERT INTO hausa_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Waɗannan su ne kabilan Naftali, jimillarsu ta kai 45,400. ");
INSERT INTO hausa_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Dukan jimillar mazan Isra’ila ta kai 601,730. ");
INSERT INTO hausa_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“Ka rarraba musu ƙasar a matsayin gādo, bisa ga yawan kabila. ");
INSERT INTO hausa_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Ga ƙungiya mafi girma, ka ba ta rabo mafi girma; ga ƙaramar ƙungiya kuwa, ka ba ta ƙarami rabo; kowane zai karɓa rabonsa ga yawan mutanen da aka rubuta. ");
INSERT INTO hausa_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Ka tabbatar an rarraba ƙasar ta wurin rabo. Abin da kowace ƙungiya ta gāda zai zama bisa ga sunayen kabilar kakanninta. ");
INSERT INTO hausa_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Za a raba kowane gādo bisa ga rabo tsakanin manyan da ƙanana ƙungiyoyi.” ");
INSERT INTO hausa_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Waɗannan su ne Lawiyawa da a ƙidaya bisa ga kabilansu, daga Gershom, kabilar Gershonawa; daga Kohat, kabilar Kohatawa; daga Merari, kabilar Merari. ");
INSERT INTO hausa_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Waɗannan kuma su ne kabilan Lawiyawa, kabilar Libniyawa, kabilar Hebronawa, kabilar Maliyawa, kabilar Mushiyawa, kabilar Korayawa (Kohat shi ne kakan Amram; ");
INSERT INTO hausa_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","sunan matan Amram shi ne Yokebed, ita zuriyar Lawi ce, wadda aka haifa wa Lawiyawa a Masar. A wajen Amram kuwa ta haifi Haruna, Musa da kuma ’yar’uwarsu Miriyam. ");
INSERT INTO hausa_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Haruna shi ne mahaifin Nadab, Abihu, Eleyazar da kuma Itamar. ");
INSERT INTO hausa_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Amma Nadab da Abihu sun mutu sa’ad da suka miƙa hadaya da haramtacciyar wuta a gaban Ubangiji.) ");
INSERT INTO hausa_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Dukan ’ya’yan Lawiyawa maza daga wata ɗaya zuwa gaba, jimillarsu ta kai 23,000. Ba a ƙidaya su tare da sauran Isra’ilawa ba, domin ba a ba su gādo tare da su ba. ");
INSERT INTO hausa_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Waɗannan su ne waɗanda Musa da Eleyazar firist, suka ƙidaya sa’ad da suka ƙidaya Isra’ilawa a filaye Mowab kusa da Urdun a hayen Yeriko. ");
INSERT INTO hausa_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Ba ko ɗayansu da yake cikin waɗanda Musa da Haruna firist, suka ƙidaya sa’ad da suka ƙidaya Isra’ilawa a Hamadar Sinai. ");
INSERT INTO hausa_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Gama Ubangiji ya riga ya gaya wa waɗancan Isra’ilawa cewa lalle za su mutu a hamada, kuma ba ko ɗayansu da ya rage, sai Kaleb ɗan Yefunne da Yoshuwa ɗan Nun. ");
INSERT INTO hausa_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","’Ya’yan nan mata na Zelofehad, ɗan Hefer, ɗan Gileyad, ɗan Makir, ɗan Manasse, suna cikin kabilan Manasse ɗan Yusuf, suka tafi ƙofar shiga Tentin Sujada. Sunayensu kuwa su ne Mala, Nowa, Hogla, Milka da kuma Tirza. ");
INSERT INTO hausa_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Da suka tafi ƙofar shiga Tentin Sujada, sai suka tsaya a gaban Musa, Eleyazar firist, shugabannin da sauran taro, suka ce, ");
INSERT INTO hausa_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“Mahaifinmu ya mutu a hamada. Ba ya cikin mabiyan Kora waɗanda suka taru suka tayar wa Ubangiji, amma ya mutu ne saboda zunubinsa, bai kuma bar ’ya’ya maza ba. ");
INSERT INTO hausa_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Me ya sa sunan mahaifinmu zai ɓace a kabilarsa don kawai ba shi da ɗa? Ka ba mu gādo cikin ’yan’uwan mahaifinmu.” ");
INSERT INTO hausa_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Saboda haka Musa ya kawo maganarsu a gaban Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Ubangiji kuwa ya ce wa masa, ");
INSERT INTO hausa_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“Abin da ’ya’yan nan mata na Zelofehad suke faɗi gaskiya ne. Dole ka ba su mallaka a matsayin gādo cikin ’yan’uwan mahaifinsu, ka kuma mayar musu da gādon mahaifinsu. ");
INSERT INTO hausa_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","“Ka faɗa wa Isra’ilawa cewa, ‘In wani ya mutu ba shi da ɗa, a ba da gādonsa ga ’yarsa. ");
INSERT INTO hausa_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","In ba shi da diya, sai a ba wa ’yan’uwansa gādonsa. ");
INSERT INTO hausa_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","In ba shi da ’yan’uwa, a ba da gādonsa ga ’yan’uwan mahaifinsa. ");
INSERT INTO hausa_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","In mahaifinsa ba shi da ’yan’uwa, a ba da gādonsa ga danginsa na kusa, a kabilarsa don yă mallaka. Wannan ya zama ƙa’ida wa Isra’ilawa, yadda Ubangiji ya umarci Musa.’ ” ");
INSERT INTO hausa_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Sa’an nan Ubangiji ya ce wa Musa, “Hau bisa wannan dutse a Abarim. Ka ga ƙasar da na ba wa Isra’ilawa. ");
INSERT INTO hausa_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Bayan ka gani, kai ma za ka bi ƙafafun mutanenka, kamar yadda ɗan’uwanka Haruna ya yi, ");
INSERT INTO hausa_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","gama sa’ad da jama’a suka yi tayarwa saboda rashin ruwa a Hamadan Zin, ku biyu, ba ku kiyaye umarnina don ku ɗaukaka ni matsayin mai tsarki, a gabansu ba.” (Waɗannan su ne ruwaye na Meriba da Kadesh, a Hamadan Zin.) ");
INSERT INTO hausa_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Musa ya ce wa Ubangiji, ");
INSERT INTO hausa_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“Bari Ubangiji, Allah na ruhohin ’yan adam, yă naɗa wani a kan wannan jama’a ");
INSERT INTO hausa_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","yă shiga, yă kuma fita a gabansu, wanda zai bishe su zuwa waje, yă kuma dawo da su ciki, don kada mutanen Ubangiji su zama kamar tumakin da ba su da makiyayi.” ");
INSERT INTO hausa_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Sai Ubangiji ya ce wa Musa, “Ka ɗauki Yoshuwa ɗan Nun, mutumin da ruhun shugabanci yake a cikinsa, ka ɗibiya masa hannunka. ");
INSERT INTO hausa_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Ka sa yă tsaya a gaban Eleyazar firist, da gaban dukan jama’a, sa’an nan ka keɓe shi a gabansu. ");
INSERT INTO hausa_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Ka danƙa masa ikonka don dukan jama’a Isra’ilawa su yi masa biyayya. ");
INSERT INTO hausa_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Zai tsaya a gaban Eleyazar firist, wanda zai nemi masa shawara ta wurin Urim a gaban Ubangiji. Da umarninsa, da shi da dukan jama’ar Isra’ilawa za su fita, da umarninsa kuma za su shiga.” ");
INSERT INTO hausa_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Musa ya yi yadda Ubangiji ya umarce shi. Ya ɗauki Yoshuwa, ya sa ya tsaya a gaban Eleyazar firist, da kuma gaban dukan jama’a. ");
INSERT INTO hausa_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Sai ya ɗibiya masa hannuwansa, ya keɓe shi, yadda Ubangiji ya umarta ta wurin Musa. ");
INSERT INTO hausa_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Sai Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“Ka umarci Isra’ilawa cewa, ‘Ku tabbatar kun miƙa mini hadaya ta abinci ta wuta mai daɗin ƙanshi a gare ni, a daidai lokaci.’ ");
INSERT INTO hausa_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Ka gaya musu, ‘Ga hadaya ta ƙonawa ta kowace rana, da za ku miƙa wa Ubangiji, raguna biyu, bana ɗaya-ɗaya, marasa lahani. ");
INSERT INTO hausa_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","A miƙa rago ɗaya da safe, ɗaya kuma da yamma, ");
INSERT INTO hausa_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","tare da hadaya ta lallausan gari kashi ɗaya bisa goma na efan, kwaɓaɓɓe da kwalaba ɗaya na man zaitun mafi kyau. ");
INSERT INTO hausa_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Wannan ita ce hadaya ta ƙonawa ta kullum wadda aka kafa a Dutsen Sinai, don daɗin ƙanshi, wato, hadaya ce da aka ƙone da wuta ga Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Hadaya ta sha, za tă zama kwalaba ɗaya na ruwan inabi, da ɗan rago guda. Za a kwarara hadaya ta sha ga Ubangiji a wuri mai tsarki. ");
INSERT INTO hausa_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Ɗayan ɗan ragon kuma za a miƙa shi da yamma, tare irin hadaya ta lallausan gari, da hadaya ta sha da ka yi da safe. Wannan hadaya ce ta ƙonawa mai daɗin ƙanshi ga Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“ ‘A ranar Asabbaci, za a miƙa ’yan raguna biyu, bana ɗaya-ɗaya marasa lahani, tare da hadaya ta sha, da hadaya ta lallausan gari kashi biyu bisa goma na efa, kwaɓaɓɓe da mai. ");
INSERT INTO hausa_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Wannan ita ce hadaya ta ƙonawa ta kowace Asabbaci, ban da hadaya ta ƙonawa ta kullum, tare da ta hadaya ta sha. ");
INSERT INTO hausa_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“ ‘A rana ta fari ga kowane wata, za a miƙa wa Ubangiji hadayun ’yan bijimai biyu, rago ɗaya, da ’yan tumaki bakwai, bana ɗaya-ɗaya, dukansu kuma marasa lahani. ");
INSERT INTO hausa_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","Da kowane bijimi, a kasance da hadaya ta lallausan garin da aka kwaɓa da mai na kashi uku bisa goma na efa; da ɗan rago kuwa, a kasance da hadaya ta lallausan garin da aka kwaɓa da mai na kashi biyu bisa goma na efa; ");
INSERT INTO hausa_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","da kowane tunkiya kuma, a kasance da hadaya ta lallausan garin da aka kwaɓa da mai, na kashi ɗaya bisa goma na efa. Wannan hadaya ce da aka ƙone da wuta ga Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Da kowane bijimi, za a kasance da hadaya ta sha, na rabin kwalabar ruwan inabi; da rago kuwa, a kasance da kashi ɗaya bisa uku; da kowace tunkiya kuma, a kasance da kashi ɗaya bisa huɗu. Wannan ita ce hadaya ta ƙonawa don tsayawar kowane sabon wata na shekara. ");
INSERT INTO hausa_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Ban da hadaya ta ƙonawa ta kullum tare da hadaya ta sha, za a miƙa bunsuru ɗaya ga Ubangiji, hadaya ce don zunubi. ");
INSERT INTO hausa_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","“ ‘Za a yi Bikin Ƙetarewa ga Ubangiji a rana ta goma sha huɗu ga wata na fari. ");
INSERT INTO hausa_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","A rana ta goma sha biyar ga wannan wata, za a yi biki; kwana bakwai za a ci burodi marar yisti. ");
INSERT INTO hausa_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","A rana ta farko, za ku yi tsattsarkan taro, ba kuwa za a yi aikin da aka saba yi na kullum ba. ");
INSERT INTO hausa_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Za a miƙa hadaya ta ƙonawa da bijimai biyu, rago ɗaya, da ’yan raguna bakwai, bana ɗaya-ɗaya; dukansu kuma marasa lahani ga Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Da kowane bijimi, a shirya kashi ɗaya bisa uku na efan lallausan gari, kwaɓaɓɓe da mai; da rago guda kuwa, a shirya kashi biyu bisa goma na efan lallausan gari, kwaɓaɓɓe da mai; ");
INSERT INTO hausa_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","da kowane ’yan raguna bakwai, kashi ɗaya bisa goma. ");
INSERT INTO hausa_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","A haɗa da bunsuru guda, a matsayin hadaya don zunubi, don yin muku kafara. ");
INSERT INTO hausa_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Ku shirya wannan tare da hadaya ta ƙonawa ta kowace safiya. ");
INSERT INTO hausa_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Ta haka za a shirya abinci don hadayar da aka yi da wuta, kowace rana, har kwana bakwai don daɗin ƙanshi ga Ubangiji; a shirya shi haɗe da hadaya ta ƙonawa ta kullum, da kuma hadaya ta sha. ");
INSERT INTO hausa_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","A rana ta bakwai, za ku yi tsattsarkan taro, amma ba za a yi aikin da aka saba yi kullum ba. ");
INSERT INTO hausa_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","“ ‘A ranar nunan fari, sa’ad da za ku miƙa wa Ubangiji hadayar sabon hatsi, a lokacin Bikin Makoni, za a yi tsattsarkan taro, ba kuwa za a yi aikin da aka saba yi ba. ");
INSERT INTO hausa_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","A miƙa hadaya ta ƙonawa da ’yan bijimai biyu, rago ɗaya da ’yan raguna bakwai, bana ɗaya-ɗaya don daɗin ƙanshi ga Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","Da kowane bijimi a kasance da hadaya ta lallausan gari kashi uku bisa goma na efa, kwaɓaɓɓe da mai; da rago kuwa, a kasance da hadaya ta lallausan gari kashi biyu bisa goma na efa, kwaɓaɓɓe da mai; ");
INSERT INTO hausa_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","da kowane ’yan raguna bakwai, kashi ɗaya bisa goma. ");
INSERT INTO hausa_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","A haɗa da bunsuru guda don yin muku kafara. ");
INSERT INTO hausa_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","A miƙa waɗannan tare da hadayarsu ta sha, haɗe da hadaya ta ƙonawa ta kullum, da kuma hadayarta ta sha. A tabbata dabbobin nan marasa lahani ne. ");
INSERT INTO hausa_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“ ‘A rana ta farko ga wata na bakwai, a yi tsattsarkan taro, kada kuma a yi aikin da aka saba na kullum. Rana ce don busa ƙahoni. ");
INSERT INTO hausa_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Za a miƙa hadaya ta ƙonawa da bijimi guda, rago guda, ’yan raguna bakwai, bana ɗaya-ɗaya don daɗin ƙanshi ga Ubangiji, duka su kasance marasa lahani. ");
INSERT INTO hausa_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","Tare da bijimin za a kuma miƙa hadaya ta gari na kashi ɗaya bisa goma na efa na lallausan gari, kwaɓaɓɓe da mai; da rago guda, kashi biyu bisa goma na efa na lallausan gari, kwaɓaɓɓe da mai; ");
INSERT INTO hausa_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","kowane ’yan raguna bakwai, kashi ɗaya bisa goma. ");
INSERT INTO hausa_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","A haɗa da bunsuru guda a matsayin hadaya don zunubi, don yin muku kafara. ");
INSERT INTO hausa_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Waɗannan ƙari ne ga hadayun ƙonawa na wata-wata da na kullayaumi, tare da hadayun garinsu da hadayun sha yadda aka tsara. Hadayu ne da aka miƙa wa Ubangiji ta wuta don daɗin ƙanshi. ");
INSERT INTO hausa_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","“ ‘A rana ta goma ga wannan watan bakwai, za a yi tsattsarkan taro. Ba za ku ci abinci ba, ba kuma za ku yi aiki ba. ");
INSERT INTO hausa_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Za a miƙa hadaya ta ƙonawa da bijimi guda, rago guda, da kuma ’yan raguna bakwai, ’yan bana ɗaya-ɗaya, dukansu marasa lahani don daɗin ƙanshi ga Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Tare da bijimin a miƙa hadaya ta gari na kashi ɗaya bisa goma na efa, na lallausan gari kwaɓaɓɓe, da mai; da rago guda, kashi biyu bisa goma na efa, na lallausan gari kwaɓaɓɓe, da mai; ");
INSERT INTO hausa_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","kowane ’yan raguna bakwai, kashi ɗaya bisa goma. ");
INSERT INTO hausa_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","A haɗa da bunsuru guda a matsayin hadaya don zunubi, don yin muku kafara da kuma hadaya ta ƙonawa ta kullum; tare da hadaya ta garinta, da kuma hadayu na shansu. ");
INSERT INTO hausa_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","“ ‘A rana ta goma sha biyar ga wata na bakwai, za a yi tsattsarkan taro, ba kuwa za a yi aikin da aka saba yi ba. Ku yi biki ga Ubangiji har kwana bakwai. ");
INSERT INTO hausa_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","A miƙa hadayar da aka yi da wuta, mai daɗin ƙanshi ga Ubangiji, hadaya ta ƙonawa ta bijimai guda sha uku, raguna biyu, da ’yan raguna goma sha huɗu, bana ɗaya-ɗaya, dukansu marasa lahani. ");
INSERT INTO hausa_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Da kowane bijimai goma sha uku nan, a miƙa hadaya ta gari, kashi uku bisa goma na efa, kwaɓaɓɓe da mai; da ragunan biyu ɗin, a miƙa hadaya ta gari kashi biyu bisa goma na efa, kwaɓaɓɓe da mai; ");
INSERT INTO hausa_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","tare kuma da kowane ’yan raguna goma sha huɗu, kashi ɗaya bisa goma. ");
INSERT INTO hausa_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","A haɗa da bunsuru guda, a matsayin hadaya don zunubi, ban da hadaya ta ƙonawa na kullum tare da hadayarta, ta gari da kuma hadaya ta sha. ");
INSERT INTO hausa_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","“ ‘A rana ta biyu, a miƙa bijimai goma sha biyu, raguna biyu, da ’yan raguna goma sha huɗu, bana ɗaya-ɗaya, dukansu marasa lahani. ");
INSERT INTO hausa_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","Tare da bijiman, ragunan da ’yan ragunan a miƙa hadayarsu da gari da hadaya ta sha, bisa ga adadin da aka ƙayyade. ");
INSERT INTO hausa_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","A haɗa da bunsuru guda a matsayin hadaya, don zunubi, ban da hadaya ta ƙonawa ta kullum, tare da hadayarta ta gari da hadayunsu ta sha. ");
INSERT INTO hausa_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","“ ‘A rana ta uku za a miƙa bijimai goma sha ɗaya, raguna biyu, da kuma ’yan raguna goma sha huɗu, bana ɗaya-ɗaya, dukansu marasa lahani. ");
INSERT INTO hausa_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","Tare da bijiman, ragunan da ’yan raguna, a miƙa hadayun gari da hadayun sha, bisa ga adadin da aka ƙayyade. ");
INSERT INTO hausa_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","A haɗa da bunsuru guda a matsayin hadaya don zunubi, ban da hadaya ta ƙonawa ta kullum, tare da hadayarta ta gari da hadaya ta sha. ");
INSERT INTO hausa_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","“ ‘A rana ta huɗu a miƙa bijimai goma, raguna biyu, da ’yan raguna goma sha huɗu, bana ɗaya-ɗaya, dukansu marasa lahani. ");
INSERT INTO hausa_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","Tare da bijiman, ragunan da kuma ’yan raguna, a miƙa hadayunsu na gari da hadayu na sha bisa ga adadin da aka ƙayyade. ");
INSERT INTO hausa_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","A haɗa da bunsuru guda, a matsayin hadaya don zunubi, ban da hadaya ta ƙonawa ta kullum, tare da hadayarta ta gari da hadaya ta sha. ");
INSERT INTO hausa_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","“ ‘A rana ta biyar a miƙa bijimai tara, raguna biyu, da ’yan raguna goma sha huɗu, bana ɗaya-ɗaya, dukansu marasa lahani. ");
INSERT INTO hausa_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","Tare da bijiman, ragunan da kuma ’yan ragunan, a miƙa hadayu na gari, da hadayu na sha bisa ga adadin da aka ƙayyade. ");
INSERT INTO hausa_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","A haɗa da bunsuru guda a matsayin hadaya don zunubi, ban da hadaya ta ƙonawa ta kullum, tare da hadayarta ta gari da hadaya ta sha. ");
INSERT INTO hausa_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","“ ‘A rana ta shida a miƙa bijimai takwas, raguna biyu, da ’yan raguna goma sha huɗu, bana ɗaya-ɗaya, dukansu marasa lahani. ");
INSERT INTO hausa_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","Tare da bijiman, ragunan da kuma ’yan raguna, a miƙa hadayunsu ta gari da hadayu na sha bisa adadin da a ƙayyade. ");
INSERT INTO hausa_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","A haɗa da bunsuru guda a matsayin hadaya don zunubi, ban da hadaya ta ƙonawa ta kullum tare da hadayarta ta hatsi da hadaya ta sha. ");
INSERT INTO hausa_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","“ ‘A rana ta bakwai a miƙa bijimai bakwai, raguna biyu da ’yan raguna goma sha huɗu, bana ɗaya-ɗaya, dukansu marasa lahani. ");
INSERT INTO hausa_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","Tare da bijiman, ragunan da kuma ’yan raguna, a miƙa hadayunsu na gari, da hadayun sha bisa ga adadin da a ƙayyade. ");
INSERT INTO hausa_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","A haɗa da bunsuru guda a matsayin hadaya don zunubi, ban da hadaya ta ƙonawa ta kullum tare da hadayarta ta hatsi da hadayarta ta sha. ");
INSERT INTO hausa_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","“ ‘A rana ta takwas kuwa za a yi tsattsarkan taro, ban da aikin da aka saba. ");
INSERT INTO hausa_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","A miƙa hadayar da aka yi da wuta mai daɗin ƙanshi ga Ubangiji, a yi hadaya ta ƙonawa da bijimi guda, rago guda, da ’yan raguna bakwai, bana ɗaya-ɗaya, dukansu marasa lahani. ");
INSERT INTO hausa_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","Tare da bijimin, ragon da kuma ’yan ragunan, a miƙa hadayunsu na gari da hadayu na sha bisa ga adadin da aka ƙayyade. ");
INSERT INTO hausa_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","A haɗa da bunsuru guda a matsayin hadaya don zunubi, ban da hadaya ta ƙonawa ta kullum, tare da hadayarta ta hatsi da hadayarta ta sha. ");
INSERT INTO hausa_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","“ ‘Ban da abin da kuka yi alkawari, da kuma sadakokinku na yardar rai, a miƙa waɗannan ga Ubangiji a lokacin bukukkuwanku, hadayunku na ƙonawa, hadayu na gari, hadayu na sha da hadayu na salama.’ ” ");
INSERT INTO hausa_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","Musa ya faɗa wa Isra’ilawa dukan abin da Ubangiji ya umarce shi. ");
INSERT INTO hausa_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Musa ya ce wa shugabannin kabilan Isra’ila, “Ga abin da Ubangiji ya umarta. ");
INSERT INTO hausa_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Sa’ad da mutum ya yi wa Ubangiji alkawari, ko kuwa ya rantse zai yi wani abu, kada yă ƙi cika maganarsa, amma yă cika kome da ya faɗa. ");
INSERT INTO hausa_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","“Sa’ad da yarinya, wadda har yanzu tana a gidan mahaifinta ta yi wa Ubangiji alkawari, ko ta rantse za tă yi wani abu, ");
INSERT INTO hausa_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","mahaifinta kuwa ya ji alkawarin da ta yi, bai kuma ce mata kome ba, to, sai alkawarin da ta yi da wa’adinta su tabbata. ");
INSERT INTO hausa_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","Amma in mahaifinta ya hana ta, sa’ad da ya ji game da shi, to, ba wani daga cikin alkawari ko rantsuwar da ta yi zai tabbata; Ubangiji kuwa zai gafarta mata domin maihaifinta ya hana ta. ");
INSERT INTO hausa_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","“In ta yi aure, sai daga baya ta yi alkawari ko kuwa leɓunanta sun furta alkawari da garaje, cewa za tă yi wani abu, ");
INSERT INTO hausa_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","mijinta kuwa ya ji game da wannan, amma bai ce mata kome ba, to, alkawarin da ta yi da kuma rantsuwar da ta yi, su tabbata. ");
INSERT INTO hausa_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","Amma in mijin ya hana ta sa’ad da ya ji, zai warware alkawari da kuma rantsuwar da ta yi da garaje, Ubangiji kuwa zai gafarce ta. ");
INSERT INTO hausa_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","“Duk wani alkawari ko rantsuwar da gwauruwa, ko macen da aurenta ya mutu, ta yi, zai tabbata a kanta. ");
INSERT INTO hausa_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","“In macen aure ta yi alkawari, ko ta rantse za tă yi wani abu, ");
INSERT INTO hausa_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","mijinta kuwa ya ji game da wannan, amma bai ce mata kome ba, bai kuma hana ta ba, to, dukan alkawari da kuma rantsuwar da ta yi su tabbata a kanta. ");
INSERT INTO hausa_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","Amma in mijin ya warware su sa’ad da ya ji, to, ba wani alkawari ko rantsuwar da ya fito daga leɓunanta da zai tabbata. Mijinta ya warware su, Ubangiji kuma zai gafarce ta. ");
INSERT INTO hausa_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Mijinta yana iya tabbatar, ko yă rushe duk wani alkawari ko rantsuwar da ta ɗauka. ");
INSERT INTO hausa_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Amma in mijinta bai ce mata kome ba, to, ya tabbatar da dukan alkawarinta da kuma rantsuwarta ke nan. Ya tabbatar da su ta wurin yin shiru sa’ad da ya ji ta. ");
INSERT INTO hausa_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Amma in ya ji, sa’an nan daga baya ya hana ta, to, zai sha hukuncin laifinta.” ");
INSERT INTO hausa_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Waɗannan su ne ƙa’idodin da Ubangiji ya ba wa Musa game da dangantakar miji da matarsa, da kuma tsakanin mahaifi da ’yarsa wadda har yanzu tana a gidansa. ");
INSERT INTO hausa_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“Ka ɗaukar wa Isra’ilawa fansa, a kan Midiyawa. Bayan wannan za ka mutu, a kuwa tara ka ga mutanenka.” ");
INSERT INTO hausa_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Saboda haka Musa ya ce wa mutane, “Ku shirya waɗansu daga cikin mazanku, su tafi su yi yaƙi da Midiyawa don su ɗaukar wa Ubangiji fansa a kansu.” ");
INSERT INTO hausa_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Ku aiki maza dubu ɗaya daga kowace kabilar Isra’ila. ");
INSERT INTO hausa_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Saboda haka aka samo mayaƙa dubu goma sha biyu shiryayyu don yaƙi, maza dubu ɗaya daga kowace kabilar Isra’ila. ");
INSERT INTO hausa_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Musa ya aike su zuwa yaƙi, dubu ɗaya daga kowace kabila, tare da Finehas ɗan Eleyazar, firist, wanda ya ɗauki kayayyaki daga wuri mai tsarki da ƙahoni don kiran yaƙi. ");
INSERT INTO hausa_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Suka yi yaƙi da Midiyawa, suka kashe kowane mutum yadda Ubangiji ya umarci Musa. ");
INSERT INTO hausa_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","A cikin waɗanda aka kashe kuwa akwai Ewi, Rekem, Zur, Hur da Reba; sarakuna biyar na Mediyawa. Suka kuma kashe Bala’am ɗan Beyor da takobi. ");
INSERT INTO hausa_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Isra’ilawa suka kwashe mata da yaran Midiyawa, a matsayin bayi. Suka kwashe shanunsu da tumakinsu da kuma dukan dukiyarsu, a matsayin ganima. ");
INSERT INTO hausa_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Suka ƙone dukan garuruwan da Midiyawa suke zama, da dukan sansaninsu. ");
INSERT INTO hausa_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Suka kwashe dukan ganima haɗe da mutane da dabbobi, ");
INSERT INTO hausa_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","suka kawo bayi da ganiman nan, wurin Musa da Eleyazar firist, da kuma jama’ar Isra’ilawa, a sansaninsu a filayen Mowab kusa da Urdun daga ƙetaren Yeriko. ");
INSERT INTO hausa_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Musa, da Eleyazar firist da dukan shugabannin jama’a, suka fito suka tarye su a bayan sansani. ");
INSERT INTO hausa_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Musa kuwa ya husata da shugabannin sojojin da suke shugabannin dubbai da shugabannin ɗari-ɗarin da suka dawo daga yaƙi. ");
INSERT INTO hausa_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Ya tambaye su ya ce, “Kun bar dukan mata da rai? ");
INSERT INTO hausa_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Su ne waɗanda suka bi shawarar Bala’am suka kuma zama sanadin sa Isra’ilawa suka juya wa Ubangiji baya, har ya kawo abin da ya faru da Feyor, har annoba ya kashe dukan mutanen Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Yanzu ku kashe dukan yara maza, ku kuma kashe kowace macen da ta yi lalata da namiji, ");
INSERT INTO hausa_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","amma ku bar kowace yarinyar da ba tă taɓa yin lalata da namiji ba. ");
INSERT INTO hausa_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","“Dukanku da kuka kashe mutum, ko kuka taɓa wani da aka kashe, dole ku kasance a bayan sansani har kwana bakwai. A rana ta uku da rana ta bakwai dole ku tsabtacce kanku da kuma bayinku. ");
INSERT INTO hausa_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Ku tsarkake kowace taguwa da kuma kome da aka yi da fata, da gashin akuya, ko kuwa itace.” ");
INSERT INTO hausa_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Sa’an nan Eleyazar firist, ya ce wa sojojin da suka je yaƙi, “Wannan ita ce ƙa’idar da Ubangiji ya ba wa Musa. ");
INSERT INTO hausa_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","Zinariya, azurfa, tagulla, baƙin ƙarfe, kuza, darma ");
INSERT INTO hausa_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","da dukan abin da wuta ba ta iya ci, dole yă shiga wuta sa’an nan zai zama da tsabta. Amma dole a kuma tsarkake ta da ruwan tsarkakewa. Duk abin da wuta za tă iya ci, dole a shigar da ita a ruwan tsarkakewa. ");
INSERT INTO hausa_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","A rana ta bakwai za ku wanke tufafinku, sa’an nan za ku tsarkaka, bayan haka ku shigo sansani.” ");
INSERT INTO hausa_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Ubangiji ya yi magana da Musa ya ce, ");
INSERT INTO hausa_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“Da kai da Eleyazar firist, da shugabannin jama’a, ku ƙidaya dukan mutane da dabbobin da aka ci da yaƙi. ");
INSERT INTO hausa_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Ku kasa ganimar kashi biyu, ku ba sojojin da suka tafi yaƙi kashi ɗaya, kashi ɗaya kuma ku ba wa jama’a. ");
INSERT INTO hausa_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Daga sojojin da suka je yaƙin kuwa, ka ware ganima wa Ubangiji, ka ɗauki ɗaya daga cikin mutum ɗari biyar, da shanu ɗari biyar, da jakuna ɗari biyar, da tumaki ɗari biyar. ");
INSERT INTO hausa_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Ka ɗauki wannan sashe daga rabin rabonsu ka ba wa Eleyazar firist, a matsayin sashe na Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Daga cikin rabin rabon Isra’ilawa, ka zaɓi ɗaya daga kowane hamsin na mutane, shanu, jakuna, tumaki, awaki ko kuma sauran dabbobi. Ka ba wa Lawiyawan da suke lura da tabanakul na Ubangiji.” ");
INSERT INTO hausa_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Saboda haka Musa da Eleyazar suka aikata yadda Ubangiji ya umarci Musa. ");
INSERT INTO hausa_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Yawan ganimar da sojoji suka kawo ita ce tumaki 675,000 ");
INSERT INTO hausa_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","shanu 72,000 ");
INSERT INTO hausa_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","da jakuna 61,000. ");
INSERT INTO hausa_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","Akwai kuma mata 32,000 da ba su yi lalata ba da namiji ba. ");
INSERT INTO hausa_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Kashin da aka ba sojoji waɗanda suka tafi yaƙi shi ne, tumaki 337,500, ");
INSERT INTO hausa_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","tumakin da aka ware wa Ubangiji kuwa 657 ne; ");
INSERT INTO hausa_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","shanu 36,000, shanun da aka ware wa Ubangiji kuwa 72 ne; ");
INSERT INTO hausa_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","jakuna 30,500, jakunan da aka ware wa Ubangiji kuwa 61 ne; ");
INSERT INTO hausa_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","mutane 16,000, mutanen da aka ware wa Ubangiji kuwa 32 ne. ");
INSERT INTO hausa_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Musa ya ba wa Eleyazar abin da aka ware wa Ubangiji, kamar yadda Ubangiji ya umarci Musa. ");
INSERT INTO hausa_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","Kashin da aka ba wa Isra’ilawa, wanda Musa ya ware daga cikin na waɗanda suka tafi yaƙi, ");
INSERT INTO hausa_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","kashin da aka ba wa jama’a kuwa tumaki 337,500 ne, ");
INSERT INTO hausa_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","shanu 36,000, ");
INSERT INTO hausa_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","jakuna 30,500 ");
INSERT INTO hausa_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","da mutane 16,000. ");
INSERT INTO hausa_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Daga rabin kashi na Isra’ilawa, Musa ya ɗauki ɗaya daga cikin hamsin na mutane da na dabbobi, yadda Ubangiji ya umarce shi, ya ba wa Lawiyawan da suke lura da tabanakul na Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Sai shugabannin da suka shugabancin rundunar yaƙin, shugabanni na dubu-dubu da shugabanni na ɗari-ɗari, suka zo wurin Musa ");
INSERT INTO hausa_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","suka ce masa, “Barorinka sun ƙidaya mayaƙan da suke ƙarƙashinmu, babu ko ɗayan ya ɓace. ");
INSERT INTO hausa_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Saboda haka mun kawo wa Ubangiji hadaya na kayan zinariya da kowannenmu ya samu, mundaye, ƙawane, ’yan kunne da duwatsun wuya, don yin wa kanmu kafara a gaban Ubangiji.” ");
INSERT INTO hausa_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Musa da Eleyazar firist, suka karɓi zinariya da kayan adon duka daga gare su. ");
INSERT INTO hausa_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Dukan zinariya da shugabannin dubu-dubu da shugabannin ɗari-ɗari, waɗanda Musa da Eleyazar suka karɓa, suka kuma miƙa hadaya ga Ubangiji, nauyinta ta kai shekel 16,750. ");
INSERT INTO hausa_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Kowane soja, ya kwashi ganima wa kansa. ");
INSERT INTO hausa_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Musa da Eleyazar firist, suka karɓi zinariya daga shugabannin dubu-dubu da shugabannin ɗari-ɗari, suka kawo cikin Tentin Sujada, don su zama abin tuni ga Isra’ilawa a gaban Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Mutanen Ruben da mutanen Gad, da suke da garken shanu da kuma garke tumaki masu yawa, suka ga cewa ƙasashen Yazer da Gileyad wurare ne masu kyau don kiwon shanu da tumaki. ");
INSERT INTO hausa_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","Saboda haka suka zo wurin Musa da Eleyazar da kuma shugabannin jama’a, suka ce, ");
INSERT INTO hausa_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","“Atarot, Dibon, Yazer, Nimra, Heshbon, Eleyale, Sebam, Nebo da Beyon, ");
INSERT INTO hausa_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","ƙasar da Ubangiji ya ci da yaƙi a gaban mutane Isra’ila, suna da kyau don dabbobi, bayinku kuma suna da dabbobi.” ");
INSERT INTO hausa_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Suka ce, “In mun sami tagomashi daga gare ka bari a ba da wannan ƙasa ga bayinka, tă zama mallakanmu. Kada ka sa mu haye Urdun.” ");
INSERT INTO hausa_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Musa ya ce wa mutanen Gad da mutanen Ruben, “Wato, sai ’yan’uwanku su yi ta yaƙi ku kuwa ku zauna nan? ");
INSERT INTO hausa_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Don me za ku karya zuciya Isra’ilawa daga hayewa zuwa ƙasar da Ubangiji ya ba su? ");
INSERT INTO hausa_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Haka iyayenku suka yi sa’ad da na aike su daga Kadesh Barneya don su dubo ƙasar. ");
INSERT INTO hausa_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Gama bayan suka haura Kwarin Eshkol suka hangi ƙasar, sai suka karya zuciyar Isra’ilawa daga shigar ƙasar da Ubangiji ya ba su. ");
INSERT INTO hausa_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","A ranar kuwa Ubangiji ya husata har ya yi wannan rantsuwa cewa, ");
INSERT INTO hausa_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‘Tabbatacce ba wani daga cikin mutanen da suka fito daga Masar, tun daga mai shekara ashirin zuwa gaba, da zai ga ƙasar da na rantse zan ba Ibrahim, da Ishaku, da Yaƙub, domin ba su bi ni sosai ba, ");
INSERT INTO hausa_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","ba ko ɗaya sai dai Kaleb ɗan Yefunne Bakenizze da Yoshuwa ɗan Nun, don su ne kaɗai suka bi Ubangiji da zuciya ɗaya.’ ");
INSERT INTO hausa_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Ubangiji ya husata da Isra’ila har ya sa suka yi ta yawo a hamada shekara arba’in, sai da dukan tsaran da suka aikata wannan mugunta a gabansa, suka mutu. ");
INSERT INTO hausa_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","“Ga shi ku kuma, tarin masu zunubi, kuna tsaya a matsayin kakanninku, kuna sa Ubangiji yă sāke husata da Isra’ila. ");
INSERT INTO hausa_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","In kun juye daga binsa, zai sāke barin dukan wannan mutane a hamada, ku ne kuwa za ku zama sanadin hallakarsu.” ");
INSERT INTO hausa_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Sai suka zo wurin Musa, suka ce, “Muna so mu gina katangar dutse don dabbobinmu, da kuma birane don matanmu da ’ya’yanmu a nan. ");
INSERT INTO hausa_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","Matanmu da ’ya’yanmu za su zauna a biranen da suke da katanga, don kāriya daga mazaunan ƙasar, amma mu, za mu ɗauki makamai mu tafi tare da sauran Isra’ilawa, har mu kai su wuraren zamansu. ");
INSERT INTO hausa_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Ba za mu koma gidajenmu ba sai kowane mutumin Isra’ila ya sami gādonsa. ");
INSERT INTO hausa_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Ba za mu ci gādo tare da su a wancan hayin Urdun ba, domin mun sami gādonmu a wannan hayin gabashin Urdun.” ");
INSERT INTO hausa_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Sai Musa ya ce musu, “In za ku yi haka, in za ku sha ɗamara da makamai a gaban Ubangiji, ku tafi yaƙi, ");
INSERT INTO hausa_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","in kuma dukanku za ku yi ɗamara, ku ɗauki makaman yaƙi a hayin Urdun a gaban Ubangiji har lokacin da ya kori abokan gābansa daga gabansa, ");
INSERT INTO hausa_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","to, sa’ad da aka ci ƙasar a gaban Ubangiji, kwa kuɓuta daga alhakinku ga Ubangiji da kuma Isra’ila. Ƙasan nan kuwa za tă zama mallakarku a gaban Ubangiji. ");
INSERT INTO hausa_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","“Amma in ba ku yi haka ba, kun yi zunubi ke nan ga Ubangiji; kuma ku san cewa zunubinku zai tone ku. ");
INSERT INTO hausa_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Ku gina birane domin matanku da ’ya’yanku, ku gina katanga kuma domin dabbobinku, amma fa ku cika abin da kuka yi alkawari.” ");
INSERT INTO hausa_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Mutanen Gad da mutanen Ruben, suka ce wa Musa, “Mu bayinka za mu yi yadda ranka yă daɗe ya umarta. ");
INSERT INTO hausa_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","’Ya’yanmu da matanmu, garkunan shanunmu da na tumakinmu, za su kasance a nan biranen Gileyad. ");
INSERT INTO hausa_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","Amma bayinka, kowane mutum a cikinmu zai haye a gaban Ubangiji, zuwa yaƙi kamar yadda ranka yă daɗe ya faɗa.” ");
INSERT INTO hausa_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Sai Musa ya yi wa Eleyazar firist, da Yoshuwa ɗan Nun, da shugabannin gidajen kakannin kabilan mutanen Isra’ila kashedi a kansu, ");
INSERT INTO hausa_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","ya ce, “In kowane sojan mutanen Gad da na mutanen Ruben, ya ɗauki makaman yaƙi, ya haye Urdun tare da ku a gaban Ubangiji, to, sa’ad da a ci ƙasar a gabanku, ku ba da ƙasar Gileyad tă zama mallakarsu. ");
INSERT INTO hausa_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","Amma in ba su haye tare da ku da shirin yaƙi ba, to, sai ku ba su gādo a wancan haye kamar sauran kabilun a Kan’ana.” ");
INSERT INTO hausa_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Mutanen Gad da mutanen Ruben suka amsa, suka ce, “Barorinka za su yi abin da Ubangiji ya faɗa. ");
INSERT INTO hausa_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Za mu haye a gaban Ubangiji zuwa Kan’ana, amma mallakarmu ta gādo, za tă kasance a wannan hayi na Urdun.” ");
INSERT INTO hausa_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Sai Musa ya ba wa mutanen Gad, mutanen Ruben, da rabin mutanen Manasse ɗan Yusuf, masarautar Sihon, sarkin Amoriyawa, da masarautar Og na Bashan, dukan ƙasar, tare da biranenta da kuma yankunan da suke kewaye. ");
INSERT INTO hausa_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Mutanen Gad suka gina Dibon, Atarot, Arower, ");
INSERT INTO hausa_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","Atrot Shofan, Yazer, Yogbeha, ");
INSERT INTO hausa_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","Bet-Nimra, da Bet-Haran a matsayin birane masu katanga, suka kuma gina katanga don dabbobinsu. ");
INSERT INTO hausa_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Mutanen Ruben suka sāke gina Heshbon, Eleyale, da Kiriyatayim, ");
INSERT INTO hausa_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","haka kuma suka gina Nebo da Ba’al-Meyon (an canja waɗannan sunaye) suka kuma gina Sibma. Suka ba wa biranen da suka sāke ginawa sunaye. ");
INSERT INTO hausa_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Zuriyar Makir ɗan Manasse suka tafi Gileyad, suka ci ta da yaƙi, suka kori mutanen Amoriyawa da suke can. ");
INSERT INTO hausa_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Saboda haka Musa ya ba da Gileyad ga mutanen Makir, zuriyar Manasse, suka kuma zauna a can. ");
INSERT INTO hausa_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Yayir, wani ɗan Manasse, ya ci ƙauyukansu da yaƙi, ya kuma ba su sunan Hawwot Yayir. ");
INSERT INTO hausa_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Noba kuma ya ci Kenat da ƙauyukanta da yaƙi, ya kuma ba ta suna Noba, bisa ga sunansa. ");
INSERT INTO hausa_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Ga wuraren da Isra’ilawa suka yi sansani sa’ad da suka fito runduna-runduna a ƙarƙashin Musa da Haruna daga Masar. ");
INSERT INTO hausa_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Bisa ga umarnin Ubangiji, Musa ya rubuta wuraren tafiye-tafiyensu da sansaninsu. Ga yadda tafiye-tafiyen suka kasance. ");
INSERT INTO hausa_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","Isra’ilawa sun tashi daga Rameses a rana ta goma sha biyar, ga watan fari, kashegarin Bikin Ƙetarewa. Suka fita gabagadi a gaban dukan Masarawa, ");
INSERT INTO hausa_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","waɗanda suke binne gawawwakin ’ya’yan farinsu da Ubangiji ya karkashe; gama Ubangiji ya hukunta allolinsu. ");
INSERT INTO hausa_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","Isra’ilawa suka tashi daga Rameses, suka yi sansani a Sukkot. ");
INSERT INTO hausa_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","Suka tashi daga Sukkot, suka yi sansani a Etam, a gefen hamada. ");
INSERT INTO hausa_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","Suka tashi daga Etam, suka koma baya zuwa Fi Hahirot, wajen gabashin Ba’al-Zafon, suka yi sansani kusa da Migdol. ");
INSERT INTO hausa_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Suka tashi daga Fi Hahirot, suka ratsa cikin teku zuwa hamada, bayan sun yi tafiya kwana uku a cikin Hamadan Etam, sai suka yi sansani a Mara. ");
INSERT INTO hausa_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","Suka tashi daga Mara, suka tafi Elim, inda akwai maɓulɓulan ruwa goma sha biyu, da itatuwan dabino guda saba’in, suka yi sansani a can. ");
INSERT INTO hausa_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","Suka tashi daga Elim, suka yi sansani kusa da Jan Teku. ");
INSERT INTO hausa_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","Suka tashi daga Jan Teku, suka yi sansani a Hamadan Sin. ");
INSERT INTO hausa_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","Suka tashi daga Hamadan Sin, suka yi sansani a Dofka. ");
INSERT INTO hausa_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","Suka tashi daga Dofka, suka yi sansani a Alush. ");
INSERT INTO hausa_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","Suka tashi daga Alush, suka yi sansani a Refidim, inda babu ruwan da mutane za su sha. ");
INSERT INTO hausa_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","Suka tashi daga Refidim, suka yi sansani a Hamadan Sinai. ");
INSERT INTO hausa_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","Suka tashi daga Hamadan Sinai, suka yi sansani a Kibrot Hatta’awa. ");
INSERT INTO hausa_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","Suka tashi daga Kibrot Hatta’awa, suka yi sansani a Hazerot. ");
INSERT INTO hausa_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","Suka tashi daga Hazerot, suka yi sansani a Ritma. ");
INSERT INTO hausa_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","Suka tashi daga Ritma, suka yi sansani a Rimmon Ferez. ");
INSERT INTO hausa_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","Suka tashi daga Rimmon Ferez, suka yi sansani a Libna. ");
INSERT INTO hausa_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","Suka tashi daga Libna, suka yi sansani a Rissa. ");
INSERT INTO hausa_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","Suka tashi daga Rissa, suka yi sansani a Kehelata. ");
INSERT INTO hausa_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","Suka tashi daga Kehelata, suka yi sansani a Dutsen Shefer. ");
INSERT INTO hausa_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","Suka tashi daga Dutsen Shefer, suka yi sansani a Harada. ");
INSERT INTO hausa_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","Suka tashi daga Harada, suka yi sansani a Makhelot. ");
INSERT INTO hausa_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","Suka tashi daga Makhelot, suka yi sansani a Tahat. ");
INSERT INTO hausa_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","Suka tashi daga Tahat, suka yi sansani a Tera. ");
INSERT INTO hausa_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","Suka tashi daga Tera, suka yi sansani a Mitka. ");
INSERT INTO hausa_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","Suka tashi daga Mitka, suka yi sansani a Hashmona. ");
INSERT INTO hausa_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","Suka tashi daga Hashmona, suka yi sansani a Moserot. ");
INSERT INTO hausa_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","Suka tashi daga Moserot, suka yi sansani a Bene Ya’akan. ");
INSERT INTO hausa_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","Suka tashi daga Bene Ya’akan, suka yi sansani a Hor Haggidgad. ");
INSERT INTO hausa_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","Suka tashi daga Hor Haggidgad, suka yi sansani a Yotbata. ");
INSERT INTO hausa_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","Suka tashi daga Yotbata, suka yi sansani a Abrona. ");
INSERT INTO hausa_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","Suka tashi daga Abrona, suka yi sansani a Eziyon Geber. ");
INSERT INTO hausa_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","Suka tashi daga Eziyon Geber, suka yi sansani a Kadesh, cikin Hamadan Zin. ");
INSERT INTO hausa_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","Suka tashi daga Kadesh, suka yi sansani a Dutsen Hor, a iyakar Edom. ");
INSERT INTO hausa_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","Bisa ga umarni Ubangiji, Haruna firist, ya hau Dutsen Hor, inda ya mutu a rana ta fari ga watan biyar, a shekara ta arba’in, bayan Isra’ilawa suka fito daga Masar. ");
INSERT INTO hausa_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","Haruna yana da shekara ɗari da ashirin da uku, sa’ad da ya mutu a Dutsen Hor. ");
INSERT INTO hausa_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Sarki Arad Bakan’ane, wanda yake zaune a Negeb na Kan’ana, ya ji labari cewa Isra’ilawa suna zuwa. ");
INSERT INTO hausa_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","Suka tashi daga Dutsen Hor, suka yi sansani a Zalmona. ");
INSERT INTO hausa_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","Suka tashi daga Zalmona, suka yi sansani a Funon. ");
INSERT INTO hausa_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","Suka tashi daga Funon, suka yi sansani a Obot. ");
INSERT INTO hausa_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","Suka tashi daga Obot, suka yi sansani a Iye Abarim, a iyakar Mowab. ");
INSERT INTO hausa_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","Suka tashi daga Iyim, suka yi sansani a Dibon Gad. ");
INSERT INTO hausa_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","Suka tashi daga Dibon Gad, suka yi sansani a Almon Dibilatayim. ");
INSERT INTO hausa_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","Suka tashi daga Almon Dibilatayim, suka yi sansani a duwatsun Abarim, kusa da Nebo. ");
INSERT INTO hausa_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","Suka tashi daga duwatsun Abarim, suka yi sansani a filayen Mowab kusa da Urdun, ɗaura da Yeriko. ");
INSERT INTO hausa_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","A can filayen Mowab, suka yi sansani kusa da Urdun ɗaura da Bet-Yeshimot har zuwa Abel-Shittim. ");
INSERT INTO hausa_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","A filayen Mowab kusa da Urdun ɗaura da Yeriko ne Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“Ka gaya wa Isra’ilawa cewa, ‘Sa’ad da kuka haye Urdun zuwa Kan’ana, ");
INSERT INTO hausa_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","ku kori dukan mazaunan ƙasar a gabanku. Ku rurrushe sassaƙaƙƙun duwatsu, da siffofinsu na zubi, ku kuma rurrushe dukan masujadansu na kan tudu. ");
INSERT INTO hausa_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","Ku mallaki ƙasar, ku kuma zauna a ciki, gama na ba ku ƙasar, ku mallake ta. ");
INSERT INTO hausa_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","Ku rarraba ƙasar ta wurin jefan ƙuri’a, bisa ga kabilanku. Kabilar da take babba, a ba ta babban gādo, ƙarami kabila kuwa, a ba ta ƙaramin gādo. Duk abin da ƙuri’a ta ba su, shi zai zama nasu. Ku rarraba wannan bisa zuriyar kakanninku. ");
INSERT INTO hausa_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","“ ‘Amma in ba ku kori mazaunan ƙasar ba, waɗanda kuka bari su ci gaba da zama, za su zama muku hakki a idanunku, da kuma ƙayayyuwa a bayanku. Za su ba ku wahala a ƙasar da kuke zama. ");
INSERT INTO hausa_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","Sa’an nan kuwa zan yi muku abin da na shirya yin musu.’ ” ");
INSERT INTO hausa_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“Ka umarci Isra’ilawa, ka ce musu, ‘Sa’ad da kuka shiga Kan’ana, ƙasar da aka ba ku gādo za tă kasance da waɗannan iyakoki. ");
INSERT INTO hausa_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","“ ‘Gefenku na kudu zai haɗa da wani sashin Hamadan Zin ta iyakar Edom. A gabas, iyakarku ta kudu za tă fara daga ƙarshen Tekun Gishiri, ");
INSERT INTO hausa_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","tă ƙetare Mashigin Kunama a kudu, tă ci gaba zuwa Zin, sa’an nan tă nufi kudu da Kadesh Barneya. Sa’an nan za tă zarce zuwa Hazar Addar, tă nausa zuwa Azmon, ");
INSERT INTO hausa_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","inda za tă juya tă haɗu da Rafin Masar, tă kuma ƙarasa a Bahar Rum. ");
INSERT INTO hausa_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","“ ‘Iyakarku a yammanci, za tă kasance bakin Bahar Rum. Wannan ce za tă zama iyakarku a yamma. ");
INSERT INTO hausa_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","“ ‘Iyakarku a arewanci kuwa za tă tashi daga Bahar Rum zuwa Dutsen Hor, ");
INSERT INTO hausa_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","za tă kuma tashi daga Dutsen Hor, zuwa Lebo Hamat. Sa’an nan tă miƙe zuwa Zedad, ");
INSERT INTO hausa_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","tă ci gaba zuwa Zifron, sa’an nan tă ƙarasa a Hazar-Enan. Wannan ce za tă zama iyakarku a arewa. ");
INSERT INTO hausa_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","“ ‘Iyakarku a gabashi, za tă tashi daga Hazar-Enan zuwa Shefam. ");
INSERT INTO hausa_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","Iyakar za tă gangara daga Shefam zuwa Ribla a gefen gabashin Ayin, sa’an nan tă ci gaba a gangaren gabashin Tekun Kinneret. ");
INSERT INTO hausa_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","Sa’an nan tă gangara ta Urdun, tă ƙarasa a Tekun Gishiri. “ ‘Wannan za tă zama ƙasarku, tare da iyakokinta a kowane gefe.’ ” ");
INSERT INTO hausa_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","Sai Musa ya umarci Isra’ilawa ya ce, “Ku raba wannan ƙasa da za ku gāda ta hanyar jefa ƙuri’a. Ubangiji ya umarta cewa a ba da ita ga kabilu tara da rabi, ");
INSERT INTO hausa_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","saboda iyalan kabilar Ruben, kabilar Gad da rabin kabilar Manasse sun riga sun sami gādonsu. ");
INSERT INTO hausa_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","Waɗannan kabilu biyu da rabi, sun sami gādonsu a wancan hayin Urdun a gabashin Yeriko wajen fitowar rana.” ");
INSERT INTO hausa_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“Waɗannan su ne sunayen mutanen da za su raba muku ƙasar gādo. Eleyazar firist, da Yoshuwa ɗan Nun. ");
INSERT INTO hausa_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","Ka kuma naɗa shugaba guda ɗaya daga kowace kabila domin yă taimaka a rabon ƙasar. ");
INSERT INTO hausa_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","“Ga sunayensu. “Kaleb ɗan Yefunne, daga kabilar Yahuda; ");
INSERT INTO hausa_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","Shemuyel ɗan Ammihud, daga kabilar Simeyon ");
INSERT INTO hausa_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","Elidad ɗan Kislon, daga kabilar Benyamin; ");
INSERT INTO hausa_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","Bukki ɗan Yogli, shugaba daga kabilar Dan; ");
INSERT INTO hausa_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","Hanniyel ɗan Efod, shugaba daga kabilar Manasse ɗan Yusuf; ");
INSERT INTO hausa_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","Kemuwel ɗan Shiftan, shugaba daga kabilar Efraim ɗan Yusuf; ");
INSERT INTO hausa_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","Elizafan ɗan Farnak, shugaba daga kabilar Zebulun; ");
INSERT INTO hausa_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","Faltiyel ɗan Azzan, shugaba daga kabilar Issakar; ");
INSERT INTO hausa_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","Ahihud ɗan Shelomi, shugaba daga kabilar Asher; ");
INSERT INTO hausa_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","Fedahel ɗan Ammihud, shugaba daga kabilar Naftali.” ");
INSERT INTO hausa_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","Waɗannan su ne mutanen da Ubangiji ya umarta su raba gādo ga Isra’ilawa a ƙasar Kan’ana. ");
INSERT INTO hausa_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","A filayen Mowab, wajen Urdun, ɗaura da Yeriko, Ubangiji ya yi magana da Musa ya ce, ");
INSERT INTO hausa_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“Ka umarci Isra’ilawa su ba wa Lawiyawa garuruwan da za su zauna a ciki daga cikin gādon da Isra’ilawa za su mallaka. A kuma ba su wurin kiwo kewaye da garuruwan. ");
INSERT INTO hausa_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","Sa’an nan za su kasance da garuruwan da za su zauna, su sami fili, da kuma za su yi kiwon garkensu na shanu da tumaki da kuma sauran dabbobinsu. ");
INSERT INTO hausa_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","“Wuraren kiwo a kewayen garuruwan da za a ba wa Lawiyawa, girmansu zai zama mai fāɗin kamu dubu ɗaya daga katangar garin. ");
INSERT INTO hausa_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","A bayan garin, ka auna kamu dubu biyu a wajen gabas, kamu dubu biyu a wajen yamma, kamu dubu biyu wajen kudu, da kuma kamu dubu uku wajen arewa, a bar garin a tsakiya. Za su kasance da wannan a matsayin wurin kiwo na garuruwan. ");
INSERT INTO hausa_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","“A cikin biranen da za a ba Lawiyawa, shida daga cikin garuruwan za su zama biranen mafaka, inda wanda ya kashe mutum zai gudu yă je. Ban da wannan, a ba su waɗansu garuruwa arba’in da biyu. ");
INSERT INTO hausa_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","Duka-duka dai a ba Lawiyawa garuruwa arba’in da takwas, tare da wuraren kiwonsu. ");
INSERT INTO hausa_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","Garuruwan da za ku ba wa Lawiyawa daga ƙasar da Isra’ilawa suka mallaka, za a ba da su bisa girman gādon kowace kabila. Ka karɓi garuruwa masu yawa daga kabilar da take da garuruwa masu yawa, amma kaɗan daga kabilar da ba ta da garuruwa masu yawa.” ");
INSERT INTO hausa_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","Sa’an nan Ubangiji ya ce wa Musa, ");
INSERT INTO hausa_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“Ka yi magana da Isra’ilawa, ka ce musu, ‘Sa’ad da kuka haye Urdun zuwa Kan’ana, ");
INSERT INTO hausa_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","ku zaɓi waɗansu garuruwan da za su zama biranen mafakarku, inda wanda ya kashe mutum cikin kuskure zai iya gudu zuwa. ");
INSERT INTO hausa_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","Za su zama wuraren mafaka daga hannun mai bin hakki, don kada a kashe mai kisankai, tun ba a kai shi gaban shari’a, a gaban taron jama’a ba. ");
INSERT INTO hausa_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","Waɗannan garuruwa shida da aka bayar za su zama biranen mafakarku. ");
INSERT INTO hausa_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","A ba da uku a wannan gefe na Urdun, a kuma ba da uku a Kan’ana, su zama biranen mafaka. ");
INSERT INTO hausa_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","Waɗannan garuruwa shida za su zama wurin mafaka wa Isra’ilawa, baƙi da duk sauran mutanen da suke zama a cikinsu, saboda duk wanda ya kashe mutum cikin kuskure yă iya gudu zuwa. ");
INSERT INTO hausa_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","“ ‘In wani ya bugi wani da makami na ƙarfe har ya mutu, to, shi mai kisankai ne; sai a kashe mai kisankan nan. ");
INSERT INTO hausa_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","Ko kuwa in wani yana riƙe da dutsen da ya isa yă kashe mutum a hannunsa, ya kuma harbi wani da dutsen har ya mutu, to, shi mai kisankai ne, sai a kashe mai kisankan nan. ");
INSERT INTO hausa_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","Ko kuwa wani yana da makami na itace a hannunsa da ya isa yă kashe mutum, ya kuma bugi wani da shi har ya mutu, shi ma mai kisankai ne, sai a kashe mai kisankan nan. ");
INSERT INTO hausa_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","Sai mai bin hakkin jinin yă kashe mai kisankan, sa’ad da ya sadu da mai kisankan, sai yă kashe shi. ");
INSERT INTO hausa_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","In saboda ƙiyayya, mutum ya laɓe, ya soke wani, ko ya jefe shi da wani abu da gangan har ya mutu, ");
INSERT INTO hausa_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","ko kuwa saboda ƙiyayya ya naushe shi har ya mutu, sai a kashe wannan mutumin da ya yi haka; shi mai kisankai ne. Sai mai bin hakkin jini yă kashe mai kisankan in ya same shi. ");
INSERT INTO hausa_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","“ ‘Amma in cikin tsautsayi ne ya soke shi, ba don ƙiyayya ba, ko kuma ya jefe shi, ba da gangan ba, ");
INSERT INTO hausa_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","ko kuwa bai gan shi ba, ya jefa dutsen da zai kashe shi a kansa, ya kuwa mutu, to, da yake shi ba abokin gābansa ba ne, bai kuma yi nufi yă ji masa ba, ");
INSERT INTO hausa_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","dole taro su yi hukunci tsakanin mai laifin, da mai bin hakkin jini bisa waɗannan ƙa’idodi. ");
INSERT INTO hausa_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","Dole taro su kāre wanda ake zargi da kisa, daga mai bin hakkin jini. Su mai da shi birnin mafaka inda ya gudu ya tafi. Dole yă kasance a can sai mutuwar babban firist, wanda aka shafe da mai mai tsarki. ");
INSERT INTO hausa_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","“ ‘Amma in wanda ake zargin ya kuskura ya fita, ya kai iyakar birnin mafaka wadda ya gudu ya je, ");
INSERT INTO hausa_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","idan mai bin hakkin jinin ya same shi a bayan gari, mai bin hakkin jinin zai iya kashe mai kisankai ɗin ba tare da wani laifi ba. ");
INSERT INTO hausa_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","Dole wanda ake zargin, yă kasance a birninsa na mafaka sai bayan mutuwa babban firist; sai bayan mutuwar babban firist ne kawai zai iya komo ga mallakarsa. ");
INSERT INTO hausa_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","“ ‘Waɗannan su ne za su zama ƙa’idodin da za ku kasance da su, a dukan tsararraki masu zuwa. ");
INSERT INTO hausa_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","“ ‘Kowa da ya kashe wani, za a kashe shi a matsayin mai kisankai, bisa ga shaidar shaidu. Amma kada a kashe wani bisa ga shaidar mutum ɗaya. ");
INSERT INTO hausa_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","“ ‘Kada a karɓi fansa don ran wanda ya yi kisankai, wanda ya cancanci mutuwa. Lalle ne a kashe shi. ");
INSERT INTO hausa_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","“ ‘Kada a karɓi fansa saboda wanda ya tsere zuwa birnin mafaka don yă koma yă zauna gidansa tun babban firist bai rasu ba. ");
INSERT INTO hausa_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","“ ‘Kada ku ƙazantar da ƙasar da kuke zama a ciki. Zub da jini yakan ƙazantar da ƙasa, ba a kuma iya yin kafara saboda wannan ƙasa da aka zub da jini, sai dai ta wurin jinin mutumin da ya zub da jinin. ");
INSERT INTO hausa_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","Kada ku ƙazantar da ƙasar da kuke zama, wadda ni kuma nake zama a ciki, gama Ni Ubangiji, ina zama a cikin Isra’ilawa.’ ” ");
INSERT INTO hausa_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","Sai shugabannin gidajen iyalan Gileyad ɗan Makir, ɗan Manasse, waɗanda suka fito daga kabilar zuriyar Yusuf, suka zo, suka yi magana a gaban Musa da shugabanni, shugabannin iyalan Isra’ilawa. ");
INSERT INTO hausa_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","Suka ce, “Sa’ad da Ubangiji ya umarce ranka yă daɗe, yă raba ƙasar gādo ga Isra’ilawa ta wurin ƙuri’a, ya umarce ka, ka ba wa ’ya’ya matan nan na Zelofehad ɗan’uwanmu gādonsa. ");
INSERT INTO hausa_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","To, a ce sun auri mutane daga waɗansu kabilan Isra’ilawa fa; ka ga, za a ɗebe gādonsu daga gādon kakanninmu a ƙara wa gādon kabilan mutanen da suka aura ke nan. Ta haka za a ɗebe sashe daga gādon da aka ba mu ke nan. ");
INSERT INTO hausa_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","Sa’ad da Shekara ta Murnar Isra’ilawa ta kewayo, za a haɗa gādonsu da na kabilan mutanen da suka aura, a kuma ba su mallakar gādon da aka ɗebe daga kabilar kakanninmu.” ");
INSERT INTO hausa_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","Ta wurin umarnin Ubangiji, Musa ya ba Isra’ilawa wannan umarni, “Abin da kabilar zuriyar Yusuf suke faɗi, daidai ne. ");
INSERT INTO hausa_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","Ga abin da Ubangiji ya umarta saboda ’ya’ya matan nan na Zelofehad. Za su iya auri duk wanda suka ga dama, muddin sun yi aure a cikin kabilar kakanninsu. ");
INSERT INTO hausa_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","Ba gādon Isra’ilan da za a ba wa wata kabila daga wata kabila, gama kowane mutumin Isra’ila zai riƙe gādonsa na kabilar da ya gāda daga kakanninsa. ");
INSERT INTO hausa_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","Kowace ’ya wadda ta ci gādon ƙasa, a kowace kabilar Isra’ilawa, dole tă auri wani cikin kabilar kakanninta, saboda kowane mutumin Isra’ila yă mallaki gādon kakanninsa. ");
INSERT INTO hausa_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","Ba gādon da za a ba wa wata kabila daga wata kabila, gama kowace kabilar Isra’ilawa za tă riƙe mallaka da ta gāda.” ");
INSERT INTO hausa_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","Saboda haka ’ya’yan Zelofehad mata suka yi yadda Ubangiji ya umarci Musa. ");
INSERT INTO hausa_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","’Ya’yan Zelofehad mata, Mala, Tirza, Hogla, Milka da Nowa, suka auri ’ya’yan ’yan’uwa na gefen mahaifinsu. ");
INSERT INTO hausa_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","Suka yi aure cikin kabilar zuriyar Manasse ɗan Yusuf, gādonsu kuwa ya kasance a cikin iyali da kuma kabilar mahaifinsu. ");
INSERT INTO hausa_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","Waɗannan su ne umarnai da ƙa’idodin da Ubangiji ya ba wa Isra’ilawa ta wurin Musa, a filayen Mowab kusa da Urdun, ɗaura da Yeriko.");
INSERT INTO hausa_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","Waɗannan su ne kalmomin da Musa ya yi wa dukan Isra’ila, a hamada gabas da Urdun, wato, Araba, ɗaura da Suf, tsakanin Faran da Tofel, Laban, Hazerot da Dizahab. ");
INSERT INTO hausa_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","(Yakan ɗauki kwana goma sha ɗaya daga Horeb zuwa Kadesh Barneya ta hanyar Dutsen Seyir.) ");
INSERT INTO hausa_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","A shekara ta arba’in, a rana ta fari ga wata na goma sha ɗaya, Musa ya yi shela ga Isra’ilawa game da dukan abin da Ubangiji ya umarta shi game da su. ");
INSERT INTO hausa_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","Wannan ya faru bayan ya ci Sihon sarkin Amoriyawa wanda ya yi mulki a Heshbon da yaƙi. A Edireyi kuma ya ci Og sarkin Bashan wanda ya yi mulki a Ashtarot da yaƙi. ");
INSERT INTO hausa_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","Gabas da iyakar Mowab, Musa ya fara bayyana wannan doka, yana cewa, ");
INSERT INTO hausa_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","Ubangiji Allahnmu ya faɗa mana a Horeb cewa, “Daɗewarku a wannan dutse ya isa haka. ");
INSERT INTO hausa_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","Ku tashi, ku ci gaba zuwa ƙasar tudun Amoriyawa; ku tafi wurin dukan maƙwabta a cikin Araba, a cikin duwatsu, a gindin yammancin tuddai, a Negeb da kuma a ta kwaruruka, da ƙasar Kan’aniyawa da kuma zuwa Lebanon, har zuwa babban kogi, wato, Yuferites. ");
INSERT INTO hausa_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","Duba na riga na ba ku wannan ƙasa. Ku shiga ku mallaki ƙasar da Ubangiji ya rantse zai ba wa kakanninku, ga Ibrahim, Ishaku da kuma Yaƙub, da kuma ga zuriyarsu bayansu.” ");
INSERT INTO hausa_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","A wancan lokaci na faɗa muku cewa, “Ku kaya ne masu nauyi da ni kaɗai ba zan iya ɗauka ba. ");
INSERT INTO hausa_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","Ubangiji Allahnku ya ƙara yawanku har yau kuka zama da yawa kamar taurari a sarari. ");
INSERT INTO hausa_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","Bari Ubangiji, Allahn kakanninku yă ƙara yawanku sau dubu, yă kuma albarkace ku yadda ya yi alkawari! ");
INSERT INTO hausa_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","Amma yaya zan ɗauka dukan damuwoyinku da nawayarku da kuma faɗace-faɗacenku duka ni kaɗai? ");
INSERT INTO hausa_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","Ku zaɓi waɗansu masu hikima, masu ganewa, da kuma mutanen da ake girmama daga kowace kabilarku, zan kuma sa su a kanku.” ");
INSERT INTO hausa_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","Kuka amsa mini, kuka ce, “Abin da ka ce za ka yi, yana da kyau.” ");
INSERT INTO hausa_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","Saboda haka na ɗauko shugabannin kabilanku masu hikima, waɗanda suka saba da ma’amala da jama’a, na sa su shugabanni a gabanku, waɗansu suka zama shugabanni a kan dubu-dubu, waɗansu a kan ɗari-ɗari, waɗansu a kan hamsin-hamsin, waɗansu kuma a kan goma-goma. Na sa su zama shugabanni a kabilanku. ");
INSERT INTO hausa_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","Na kuma umarci alƙalanku a wancan lokaci, na ce, “Ku yi adalci cikin shari’a tsakanin ’yan’uwanku, ko damuwar tana tsakanin ’yan’uwa Isra’ilawa ne, ko kuwa tsakanin Isra’ilawa da baƙin da suke zaune a cikinku. ");
INSERT INTO hausa_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","Kada ku nuna sonkai a cikin hukuncinku, ku saurari kowane ɓangare, babba da ƙarami, kada ku ji tsoron wani, gama hukunci na Allah ne. Ku kawo kowane batun da ya sha ƙarfinku, zan kuwa saurare shi.” ");
INSERT INTO hausa_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","A wancan lokacin kuwa na faɗa muku dukan abin da ya kamata ku yi. ");
INSERT INTO hausa_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","Sa’an nan, muka kama hanya daga Horeb muka ratsa wajen ƙasar tudun Amoriyawa ta dukan hamadarta mai fāɗi, da kuma mai bantsoron da kuka gani, muka kuma kai Kadesh Barneya yadda Ubangiji, Allahnmu ya umarce mu. ");
INSERT INTO hausa_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","Sai na ce muku, “Kun iso ƙasar tudun Amoriyawa, wadda Ubangiji, Allahnmu yake ba mu. ");
INSERT INTO hausa_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","Duba, Ubangiji Allahnku ya ba ku ƙasar. Ku haura ku mallake ta yadda Ubangiji Allahn kakanninku ya faɗa muku. Kada ku ji tsoro, kada ku fid da zuciya.” ");
INSERT INTO hausa_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","Sai dukanku kuka zo wurina kuka ce, “Bari mu aiki mutane su yi gaba su leƙi mana asirin ƙasar, su kuma kawo mana labari game da hanyar da za mu bi, da kuma biranen da za mu shiga.” ");
INSERT INTO hausa_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","Ra’ayin nan naku ya yi mini kyau, saboda haka na zaɓe ku goma sha biyu, mutum guda daga kowace kabila. ");
INSERT INTO hausa_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","Suka tafi, suka haura zuwa ƙasar tudu, suka kai Kwarin Eshkol, suka leƙo asirin ƙasar. ");
INSERT INTO hausa_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","Suka ɗebi ’ya’yan itatuwan ƙasar, suka sauko mana da su, suka kuma ba da labari cewa, “Ƙasar da Ubangiji Allahnmu yake ba mu, kyakkyawa ce.” ");
INSERT INTO hausa_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","Amma ba ku yi niyya ku haura ba, kuka yi tawaye gāba da umarnin Ubangiji Allahnku. ");
INSERT INTO hausa_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","Kuka yi gunaguni a cikin tentunanku, kuna cewa, “Ubangiji ya ƙi mu; shi ya sa ya fitar da mu daga Masar don yă ba da mu ga hannuwan Amoriyawa su hallaka mu. ");
INSERT INTO hausa_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","Ina za mu? ’Yan’uwanmu suka sa muka fid da zuciya. Suka ce, ‘Mutanen sun fi mu ƙarfi, sun kuma fi mu tsayi; biranen manya ne, da katanga har sama. Mun ma ga Anakawa a can.’ ” ");
INSERT INTO hausa_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","Sai na ce muku, “Kada ku firgita; kada ku ji tsoronsu. ");
INSERT INTO hausa_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","Ubangiji Allahnku yana a gabanku, zai yi yaƙi saboda ku, kamar yadda ya yi a kan idanunku a Masar, ");
INSERT INTO hausa_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","da kuma a cikin hamada. A can ma kun ga yadda Ubangiji Allahnku ya riƙe ku ko’ina da kuka tafi, kamar yadda mahaifi yakan riƙe ɗansa, sai da kuka kai wannan wuri.” ");
INSERT INTO hausa_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","Duk da haka, ba ku amince da Ubangiji Allahnku ba, ");
INSERT INTO hausa_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","shi da ya sha gabanku a tafiyarku, cikin wuta da dad dare da kuma girgije da rana, don yă nemi wurare domin ku kafa sansani, don kuma yă nuna muku hanyar da za ku bi. ");
INSERT INTO hausa_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","Da Ubangiji ya ji abin da kuka faɗa, sai ya husata, ya kuma yi rantsuwa ya ce, ");
INSERT INTO hausa_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","“Babu wani a cikin wannan muguwar tsara da zai ga ƙasa mai kyau da na rantse zan ba wa kakanninku, ");
INSERT INTO hausa_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","sai dai Kaleb ɗan Yefunne. Zai gan ta, zan ba shi duk ƙasar da tafin ƙafarsa ta taka, shi da zuriyarsa, gama ya bi Ubangiji da zuciya ɗaya.” ");
INSERT INTO hausa_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","Saboda ku Ubangiji ya husata da ni, ya kuma ce, “Kai ma, ba za ka shiga ƙasar ba. ");
INSERT INTO hausa_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","Amma mataimakinka, Yoshuwa ɗan Nun, zai shiga. Ka ƙarfafa shi gama shi ne zai jagoranci Isra’ila su gāje ta. ");
INSERT INTO hausa_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","Amma ’ya’yanku ƙanana waɗanda ba su san mugunta ko nagarta ba, waɗanda kuke tsammani za a kwashe su ganima, su za su shiga ƙasar. Zan ba da ita gare su, za su kuwa mallake ta. ");
INSERT INTO hausa_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","Amma ku kam, sai ku juya, ku koma cikin hamada ta hanyar Jan Teku.” ");
INSERT INTO hausa_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","Sai kuka amsa, kuka ce, “Mun yi zunubi ga Ubangiji. Za mu haura mu yi yaƙi yadda Ubangiji Allahnmu ya umarce mu.” Saboda haka kowannenku ya yi ɗamara da kayan yaƙinsa, kuka yi tsammani zai zama muku da sauƙi ku ci ƙasar tuddai da yaƙi. ");
INSERT INTO hausa_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","Amma Ubangiji ya ce mini, “In faɗa muku, ‘Kada ku fāɗa musu da yaƙi, gama ba zai kasance tare da ku ba. Idan kuka kuskura, abokan gābanku za su murƙushe ku.’ ” ");
INSERT INTO hausa_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","Sai na faɗa muku, amma ba ku saurara ba. Kuka yi tawaye ga umarnin Ubangiji, a cikin jahilcinku kuwa kuka taka, kuka haura cikin ƙasar tudu. ");
INSERT INTO hausa_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","Amoriyawan da suke zama a waɗannan tuddai, suka fito kamar tarin ƙudan zuma gāba da ku, suka kore ku, suka fatattake ku daga Seyir har zuwa Horma. ");
INSERT INTO hausa_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","Kuka dawo, kuka yi kuka a gaban Ubangiji, amma bai kula da ku ba, balle yă saurare ku. ");
INSERT INTO hausa_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","Haka kuwa kuka zauna a Kadesh kwanaki masu yawa, kuka ci lokaci a can. ");
INSERT INTO hausa_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","Sai muka juya muka kama hanya, muka nufi hamada, ta hanyar Jan Teku yadda Ubangiji ya umarce ni. Da daɗewa muka yi ta yawo kewaye da ƙasar tudun Seyir. ");
INSERT INTO hausa_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","Sai Ubangiji ya ce mini, ");
INSERT INTO hausa_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","“Kun yi ta yawo kewaye da ƙasar tudun nan da daɗewa; yanzu ku juya, ku nufi arewa. ");
INSERT INTO hausa_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","Ka ba wa mutane waɗannan umarnai, ka ce, ‘Kuna gab da wucewa cikin yankin ’yan’uwanku, zuriyar Isuwa, wanda yake zama a Seyir. Za su ji tsoronku, amma ku yi hankali ");
INSERT INTO hausa_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","kada ku tsokane su da yaƙi, gama ba zan ba ku wata ƙasa daga cikinsu ba, ba ma wadda za tă iya isa ku sa ƙafarku a kai. Na ba wa Isuwa ƙasar tudu ta Seyir, ta zama tasa. ");
INSERT INTO hausa_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","Duk abincin za ku ci, da ruwan da za ku sha, za ku biya su.’ ” ");
INSERT INTO hausa_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","Ubangiji Allahnku ya albarkace ku cikin dukan aikin hannuwanku. Ya kiyaye ku cikin tafiyarku a duk fāɗin hamada. Waɗannan shekaru arba’in Ubangiji Allahnku ya kasance tare da ku, ba kuwa kun rasa wani abu ba. ");
INSERT INTO hausa_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","Saboda haka muka ci gaba, muka wuce ’yan’uwanmu, zuriyar Isuwa, wanda yake zama a Seyir. Muka bar hanyar Araba, wadda ta haura daga Elat da Eziyon Geber, muka nufi wajen hamadar Mowab. ");
INSERT INTO hausa_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","Sai Ubangiji ya ce mini, “Kada ku dami Mowabawa, ko ku tsokane su da yaƙi, gama ba zan ba ku wani sashe na ƙasarsu ba. Na ba da Ar ga zuriyar Lot, ta zama mallakarsu.” ");
INSERT INTO hausa_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","(Emawa, mutane ne masu ƙarfi da kuma yawa, suna kuma da tsayi kamar Anakawa, dā sun zauna a can. ");
INSERT INTO hausa_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","Kamar Anakawa, su ma an ɗauka su Refahiyawa ne, amma Mowab suna kiransu Emawa. ");
INSERT INTO hausa_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","Haka ma Horiyawa, a dā sun zauna a Seyir, amma zuriya Isuwa suka kore su. Suka hallaka Horiyawa da suke kafinsu, suka kuma zauna a wurinsu, kamar dai yadda Isra’ila ta yi a ƙasar da Ubangiji ya ba su a matsayin mallaka.) ");
INSERT INTO hausa_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","Ubangiji kuwa ya ce, “Yanzu ku tashi ku ƙetare Kwarin Zered.” Sai muka ƙetare kwarin. ");
INSERT INTO hausa_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","Dukan shekarun da muka yi a tafiyarmu daga Kadesh Barneya zuwa lokacin da muka ƙetare Kwarin Zered, sun kai shekaru talatin da takwas. A lokacin, wannan tsara gaba ɗaya ta mutanen da suka isa yaƙi sun mutu daga sansani, yadda Ubangiji ya rantse musu. ");
INSERT INTO hausa_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","Hannun Ubangiji ya yi gāba da su sai da ya hallaka su ƙaƙaf daga sansani. ");
INSERT INTO hausa_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","To, sa’ad da na ƙarshe cikin waɗannan mayaƙa a cikin mutanen ya rasu, ");
INSERT INTO hausa_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","sai Ubangiji ya ce mini, ");
INSERT INTO hausa_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","“Yau za ku wuce ta yankin Mowab a Ar. ");
INSERT INTO hausa_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","Sa’ad da kuka iso kusa da Ammonawa, kada ku dame su, ko ku tsokane su da yaƙi, gama ba zan ba ku mallakar wata ƙasar da take ta Ammonawa ba. Na riga na ba da ita mallaka ga zuriyar Lot.” ");
INSERT INTO hausa_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","(Wannan ita ma a ɗauka ta a matsayin ƙasar Refahiyawa waɗanda dā sun zauna a can ne; amma Ammonawa suna ce da su Zamzummawa. ");
INSERT INTO hausa_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","Mutane ne masu ƙarfi da kuma yawa, suna kuma da tsayi kamar Anakawa. Ubangiji ya hallaka su daga gaban Ammonawa, waɗanda suka kore su, suka kuma zauna a wurinsu. ");
INSERT INTO hausa_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","Ubangiji ya yi daidai yadda ya yi wa zuriyar Isuwa waɗanda suka zauna a ƙasar Seyir, sa’ad da ya hallaka Horiyawa a gabansu. Su kuma suka kore su, suka zauna a wurinsu. Har wa yau, zuriyar Isuwa ne suke zama a can. ");
INSERT INTO hausa_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","Kusan abu ɗaya ya faru, sa’ad da Kaftorawa daga ƙasar Kaftor suka hallaka Awwiyawa, waɗanda dā suke zaune a yankin ƙauyukan da suke kewaye da Gaza. Suka zauna a wurinsu.) ");
INSERT INTO hausa_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","“Ku fito yanzu ku ƙetare Kwarin Arnon. Duba, na ba da Sihon mutumin Amoriyawa a hannunku, na kuma ba da sarkin Heshbon da ƙasarsa. Ku fara mallake ta, ku kuma yi yaƙi da shi. ");
INSERT INTO hausa_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","A wannan rana zan fara sa tsoro da fargabanku a kan dukan al’ummai, a ƙarƙashin sama. Za su ji labarinku, za su yi rawan jiki, su kuma damu saboda ku.” ");
INSERT INTO hausa_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","Daga hamadar Kedemot, na aiki ’yan saƙo zuwa wurin Sihon sarkin Heshbon, a kan ina neman zaman lafiya, ina cewa, ");
INSERT INTO hausa_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","“Bari mu wuce cikin ƙasarka. Za mu bi ta kan hanya ne kaɗai; ba za mu ratse dama ko hagu ba. ");
INSERT INTO hausa_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","Ka sayar mana da abincin da za mu ci, da kuma ruwan da za mu sha a farashinsu na azurfa. Ka dai bar mu mu wuce ta ƙasarka kawai, ");
INSERT INTO hausa_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","kamar yadda zuriyar Isuwa, waɗanda suke zaune a Seyir, da Mowabawa, waɗanda suke zaune a Ar, suka yardar mana, gama muna so mu ƙetare Urdun zuwa ƙasa wadda Ubangiji, Allahnmu yake ba mu.” ");
INSERT INTO hausa_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","Amma Sihon sarkin Heshbon ya ƙi yă bar mu mu wuce a ciki. Gama Ubangiji Allahnku ya sa ruhunsa ya taurare don yă ba da shi a hannuwanku kamar yadda ya yi yanzu. ");
INSERT INTO hausa_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","Ubangiji ya ce mini, “Duba, na fara ba da Sihon da ƙasarsa gare ku. Yanzu ku fara cinta, ku kuma mallake ƙasarsa.” ");
INSERT INTO hausa_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","Sa’ad da Sihon da dukan sojojinsa suka fito don su sadu da mu, a yaƙi, a Yahaz, ");
INSERT INTO hausa_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","sai Ubangiji Allahnmu ya ba da shi gare mu, muka kuwa buga shi tare da ’ya’yansa maza da kuma dukan sojojinsa. ");
INSERT INTO hausa_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","A wannan lokaci mun ci dukan biranensa, muka kuma hallaka su, maza, mata da kuma yara. Ba mu bar wani da rai ba. ");
INSERT INTO hausa_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","Amma muka washe, muka kuma kwasa shanu da kuma ganima daga biranen wa kanmu. ");
INSERT INTO hausa_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","Ubangiji Allahnmu ya taimake mu muka ci Arower wadda take a gefen Kwarin Arnon, da garin da yake a cikin kwarin, har zuwa Gileyad. Babu garin da ya gaggare mu. ");
INSERT INTO hausa_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","Amma bisa ga umarnin Ubangiji Allahnmu, ba ku yi kusa da wata ƙasar Ammonawa, ko ƙasar da take gefen kwarin kogin Yabbok, ko kuwa wadda take kewaye da birane cikin tuddai ba. ");
INSERT INTO hausa_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","Biye da wannan muka juya muka haura ta hanyar wajen Bashan, inda Og, sarkin Bashan tare da dukan mayaƙansa suka fito don su sadu da mu a yaƙi, a Edireyi. ");
INSERT INTO hausa_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","Ubangiji ya ce mini, “Kada ka ji tsoronsa, gama na riga na miƙa shi da dukan mayaƙansa da kuma ƙasarsa gare ka. Yi masa abin da ka yi wa Sihon sarkin Amoriyawa, wanda ya yi mulkin Heshbon.” ");
INSERT INTO hausa_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","Saboda haka Ubangiji Allahnmu ya ba da Og, sarkin Bashan da dukan mayaƙansa a hannuwanmu. Muka karkashe su, ba mu bar wani da rai ba. ");
INSERT INTO hausa_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","A wannan lokaci muka kwashe dukan biranensa. Babu ɗaya daga birane sittin da ba mu ɗauke daga gare su ba, dukan yankin Argob, masarautar Og a Bashan. ");
INSERT INTO hausa_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","Dukan biranen nan masu katanga da suke da tsayi masu ƙofofi da ƙyamare, akwai kuma manya ƙauyukan da ba su da katanga. ");
INSERT INTO hausa_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","Muka hallaka su ƙaƙaf, kamar yadda muka yi wa Sihon sarkin Heshbon, muka hallaka kowace birni, maza, mata da yara. ");
INSERT INTO hausa_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","Amma dukan dabbobin da kuma ganimar daga biranensu muka kwaso wa kanmu. ");
INSERT INTO hausa_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","A lokacin ne muka ƙwace wannan ƙasa daga hannun sarakunan nan biyu na Amoriyawa, wato, ƙasa wadda take a hayin Urdun, daga Kwarin Arnon zuwa Dutsen Hermon. ");
INSERT INTO hausa_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","(Hermon ne Sidoniyawa suke kira Siriyon, Amoriyawa kuwa suna kira shi Senir.) ");
INSERT INTO hausa_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","Muka kama dukan biranen da suke kan tudu, da dukan Gileyad, da dukan Bashan, har zuwa Saleka da Edireyi, biranen masarautar Og a Bashan. ");
INSERT INTO hausa_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","(Og sarkin Bashan, ne kaɗai ya ragu cikin Refahiyawa. An yi gadonsa da ƙarfe, tsawon gadon ya fi ƙafa goma sha uku, fāɗinsa kuwa ƙafa shida ne. Yana nan a Rabba ta Ammonawa har yanzu.) ");
INSERT INTO hausa_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","Cikin ƙasar da muka kwasa a lokacin, na ba wa mutanen Ruben da mutanen Gad yankin arewa na Arower ta Kwarin Arnon, haɗe da rabin ƙasar tudu ta Gileyad, tare da biranenta. ");
INSERT INTO hausa_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","Sai kuma na ba wa rabin kabilar Manasse sauran rabin ƙasar tudu ta Gileyad da kuma dukan Bashan, masarautar Og (Wato, dukan yankin ƙasan nan na Argob a Bashan da dā ake kira ƙasar Refahiyawa. ");
INSERT INTO hausa_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","Yayir na zuriyar Manasse ya karɓi dukan yankin ƙasar Argob a Bashan har zuwa iyakar Geshurawa da Ma’akatiyawa. Sai ya kira ƙauyukan wurin da sunansa, Hawwot Yayir.) ");
INSERT INTO hausa_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","Na kuma ba da Gileyad ga Makir. ");
INSERT INTO hausa_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","Amma ga mutanen Ruben da mutanen Gad, na ba da yankin da ya tashi daga Gileyad, ya gangara zuwa Kwarin Arnon (tsakiyar kwarin kuwa shi ne iyaka) ya fita zuwa Kogin Yabbok, wanda yake shi ne iyakar Ammonawa. ");
INSERT INTO hausa_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","Iyakarsa daga yamma kuwa shi ne Urdun a Araba, daga Kinneret zuwa Tekun Araba (wato, Tekun Gishiri) a gangaren gindin Dutsen Fisga wajen gabas. ");
INSERT INTO hausa_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","Na umarce ku a lokacin na ce, “Ubangiji Allahnku ya ba ku wannan ƙasa ku mallake ta. Dukan mayaƙanku za su haye da shirin yaƙi a gaban ’yan’uwanku, Isra’ilawa. ");
INSERT INTO hausa_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","Amma matanku, yaranku da dabbobinku (na sani kuna da dabbobi masu yawa), su ne za ku bari a garuruwan da na ba ku, ");
INSERT INTO hausa_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","sai Ubangiji ya ba da hutu ga sauran ’yan’uwanku, yadda ya yi da ku, su ma suka sami ƙasar da Ubangiji Allahnku yake ba su, a ƙetaren Urdun, sa’an nan kowannenku zai komo ga mallakar da na ba ku.” ");
INSERT INTO hausa_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","A lokacin nan na umarci Yoshuwa na ce, “Da idanunka ka ga dukan abin da Ubangiji Allahnku ya yi da waɗannan sarakuna biyu. Haka Ubangiji zai yi da dukan masarautai a can, inda za ku. ");
INSERT INTO hausa_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","Kada ku ji tsoronsu, gama Ubangiji Allahnku zai yi yaƙi dominku.” ");
INSERT INTO hausa_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","A lokacin, na roƙi Ubangiji na ce, ");
INSERT INTO hausa_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","“Ya Ubangiji Mai Iko Duka, ka fara nuna wa bawanka ɗaukakarka da ikonka. Akwai wani allah a sama ko a duniya, wanda zai aikata waɗannan manyan ayyukan kamar ka? ");
INSERT INTO hausa_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","Ina roƙonka, bari in ƙetare in ga ƙasa mai kyau ɗin nan a ƙetaren Urdun, wannan ƙasar mai kyau ta tuddai, da kuma Lebanon.” ");
INSERT INTO hausa_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","Amma saboda ku, Ubangiji ya yi fushi da ni, bai kuwa saurare ni ba. Sai Ubangiji ya ce, “Ya isa haka, kada ka ƙara yin magana da ni game da wannan batu. ");
INSERT INTO hausa_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","Haura zuwa ƙwanƙolin Fisga, ka dubi ƙasar da idanunka daga kowane gefe, yamma, da arewa, da kudu, da kuma gabas, gama ba za ka ƙetare wannan Urdun ba. ");
INSERT INTO hausa_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","Amma ka umarci Yoshuwa, ka ƙarfafa shi, ka kuma ba shi ƙarfin gwiwa, gama shi ne zai jagoranci wannan mutane su haye, yă kuma ba su gādon ƙasar da za ka gani.” ");
INSERT INTO hausa_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","Sai muka zauna a kwari kusa da Bet-Feyor. ");
INSERT INTO hausa_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","To, ku ji, ya Isra’ila, ku kasa kunne ga ƙa’idodi da dokokin da nake shirin koya muku. Ku bi su domin ku yi tsawon rai, ku kuma shiga ku mallaki ƙasar da Ubangiji, Allahn kakanninku yake ba ku. ");
INSERT INTO hausa_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","Kada ku ƙara, kada ku rage daga cikin abin da nake umarce ku. Amma ku kiyaye umarnan nan na Ubangiji Allahnku, da na ba ku. ");
INSERT INTO hausa_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","Da idanunku, kun ga abin da Ubangiji ya yi a Ba’al-Feyor. Yadda Ubangiji Allahnku ya hallaka waɗansu daga cikinku waɗanda suka yi wa Ba’al-Feyor sujada, ");
INSERT INTO hausa_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","Amma ku da kuka manne ga Ubangiji Allahnku, kuna da rai har wa yau. ");
INSERT INTO hausa_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","Ga shi, na koya muku ƙa’idodi da dokoki, yadda Ubangiji Allahna ya umarce ni, don ku bi su a ƙasar da za ku shiga ku mallaki. ");
INSERT INTO hausa_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","Ku kiyaye su, ku aikata su, gama yin haka zai tabbatar wa sauran al’ummai, kuna da hikima da ganewa. Sa’ad da al’ummai za su ji waɗannan dokoki, za su ce, “Ba shakka, wannan babbar al’umma tana da hikima da ganewa.” ");
INSERT INTO hausa_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","Wace al’umma ce mai girma haka wadda allolinta take kusa da su yadda Ubangiji Allahnmu yake kusa da mu a duk sa’ad da muka yi addu’a gare shi? ");
INSERT INTO hausa_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","Wace al’umma ce mai girma haka wadda take da ƙa’idodi da dokoki masu adalci kamar waɗannan ƙunshin dokokin da nake sa a gabanku a yau? ");
INSERT INTO hausa_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","Ku kula, ku kuma lura da kanku sosai, don kada ku manta da abubuwan da idanunku suka gani, ko kuwa ku bari su fita daga zuciyarku muddin ranku. Ku koyar da su ga ’ya’yanku, da ’ya’yan ’ya’yanku. ");
INSERT INTO hausa_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","Ku tuna da ranar da kuka tsaya a gaban Ubangiji Allahnku a Horeb, sa’ad da ya ce mini, “Ka tara mutane a gabana, don su ji maganata, su koya yin mini bangirma muddin ransu a ƙasar, su kuma iya koyar da su ga ’ya’yansu.” ");
INSERT INTO hausa_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","Sai kuka matso kusa, kuka tsaya a gindin dutse yayinda yana cin wuta har zuwa sararin sama, ga kuma baƙin gizagizai da kuma baƙin duhu. ");
INSERT INTO hausa_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","Sai Ubangiji ya yi magana daga wutar. Kuka ji furcin kalmomin, amma ba ku ga siffar kome ba, sai dai murya kaɗai kuka ji. ");
INSERT INTO hausa_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","Ya furta alkawarinsa gare ku, Dokoki Goma, waɗanda ya umarce ku ku bi, ya kuma rubuta su a alluna biyu. ");
INSERT INTO hausa_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","Sa’an nan Ubangiji ya umarce ni a wannan lokaci, in koya muku ƙa’idodi da dokokin da za ku bi a ƙasar da kuke hayewa Urdun don mallake. ");
INSERT INTO hausa_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","Ba ku ga wata siffa a ranar da Ubangiji ya yi magana da ku a Horeb daga wuta ba. Saboda haka ku lura da kanku sosai, ");
INSERT INTO hausa_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","don kada ku lalace, ku kuma yi wa kanku gunki, siffa ta wani kama, ko a kamannin namiji, ko kuwa ta mace, ");
INSERT INTO hausa_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","ko a kamannin wata dabba a duniya, ko na wani tsuntsun da yake tashi a sama, ");
INSERT INTO hausa_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","ko kuwa a kamannin wata halittar da take rarrafe a ƙasa, ko na wani kifi a cikin ruwaye a ƙarƙashi. ");
INSERT INTO hausa_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","Sa’ad da kuka ɗaga ido kuka kali sama, kuka ga rana da wata, da taurari, da dukan halittun sama, sai ku kula fa, kada ku jarrabtu, ku ce za ku yi musu sujada, ko ku bauta musu; abubuwan nan Ubangiji Allahnku ne ya rarraba wa dukan al’umman da suke ko’ina a ƙarƙashin sararin sama. ");
INSERT INTO hausa_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","Amma ku, Ubangiji ya ɗauke ku, ya fid da ku daga matuya mai narken ƙarfe, wato, daga Masar, domin ku zama jama’arsa ta musamman kamar yadda kuke a yau. ");
INSERT INTO hausa_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","Ubangiji ya yi fushi da ni saboda ku, ya kuma yi rantsuwa cewa ba zan haye Urdun, in shiga ƙasan nan mai kyau da Ubangiji Allahnku yake ba ku gādo ba. ");
INSERT INTO hausa_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","Zan mutu a wannan ƙasa; ba zan haye Urdun ba; amma kuna gab da ƙetarewa, ku mallaki wannan ƙasa mai kyau. ");
INSERT INTO hausa_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","Ku yi hankali kada ku manta da alkawarin da Ubangiji Allahnku ya yi da ku; kada fa ku yi wa kanku gunki a kamannin wani abin da Ubangiji Allahnku ya hana. ");
INSERT INTO hausa_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","Gama Ubangiji Allahnku wuta ne mai ƙuna, Allah ne mai kishi. ");
INSERT INTO hausa_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","Bayan kun haifi ’ya’ya da jikoki, kuka kuma zauna na dogon lokaci a ƙasar, in har kuka lalace, kuka kuma yi wani irin gunki, kuna aikata mugunta a gaban Ubangiji Allahnku, kuna kuma sa shi fushi. ");
INSERT INTO hausa_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","Yau, na kira sama da duniya, su zama shaidata a kanku. Idan kuka yi rashin biyayya, lalle za ku hallaka nan da nan daga ƙasar da kuke ƙetare Urdun ku gāda. Ba za ku daɗe a cikinta ba, amma za a kawar da ku ƙaƙaf. ");
INSERT INTO hausa_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","Ubangiji zai watsar da ku a cikin mutane, ɗan kaɗan ne kaɗai za su ragu a cikin al’umman da Ubangiji zai kai ku. ");
INSERT INTO hausa_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","A can za ku bauta wa allolin da mutum ya yi, na itace da dutse da ba sa gani, ba sa ji, ba sa ci, ba kuma iya sansanawa. ");
INSERT INTO hausa_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","Amma daga can in kuka nemi Ubangiji Allahnku, da dukan zuciyarku da kuma dukan ranku, za ku same shi. ");
INSERT INTO hausa_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","Sa’ad da kuke cikin wahala saboda waɗannan abubuwan da suka same ku nan gaba, to, sai ku juyo ga Ubangiji Allahnku, ku kuma yi masa biyayya. ");
INSERT INTO hausa_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","Gama Ubangiji Allahnku, Allah ne mai jinƙai; ba zai yashe ku ko yă hallaka, ko kuma yă manta da alkawarin da ya yi da kakanninku, wanda ya tabbatar da su da rantsuwa ba. ");
INSERT INTO hausa_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","Ku bincika dukan tarihi mana, tun daga lokacin da Allah ya halicci mutane a cikin duniya har yă zuwa yanzu; ku tantambaya daga wannan kusurwa ta samaniya zuwa waccan, ko wani babban abu irin wannan ya taɓa faruwa, ko kuma an taɓa jin labarin irinsa? ");
INSERT INTO hausa_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","Akwai waɗansu mutanen da suka taɓa jin muryar Allah yana magana daga wuta, kamar yadda kuka ji har suka rayu? ");
INSERT INTO hausa_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","Akwai wani allahn da ya taɓa yin ƙoƙari yă ɗauko wa kansa wata al’umma daga wata al’umma, ta wurin gwaje-gwaje, ta wurin alamu masu banmamaki da al’ajabai, ta wurin yaƙi, ta wurin hannu mai iko, da kuma hannu mai ƙarfi, ko kuwa ta wurin ayyuka masu bangirma da na banmamaki, kamar dukan abubuwan da Ubangiji Allahnku ya yi saboda ku a Masar, a kan idanunku? ");
INSERT INTO hausa_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","An nuna muku dukan waɗannan abubuwa saboda ku san cewa Ubangiji, shi ne Allah; ban da shi, babu wani. ");
INSERT INTO hausa_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","Daga sama ya sa kuka ji muryarsa, don yă hore ku. A duniya ya nuna muku wutarsa mai girma, kuka kuma ji kalmominsa daga wuta. ");
INSERT INTO hausa_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","Domin ya ƙaunaci kakanninku, ya kuma zaɓi zuriyarsu a bayansu, ya fitar da ku daga Masar ta wurin kasancewarsa da kuma ƙarfinsa mai girma, ");
INSERT INTO hausa_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","don yă fitar da ku a gaban al’ummai da suka fi ku girma da kuma ƙarfi, ya kawo ku cikin ƙasarsu, don yă ba ku ita ta zama gādonku, kamar yadda yake a yau. ");
INSERT INTO hausa_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","Ku sani, ku kuma riƙe a zuciya a wannan rana, cewa Ubangiji shi ne Allah a sama da kuma a ƙasa. Babu wani kuma. ");
INSERT INTO hausa_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","Ku kiyaye ƙa’idodi da umarnai, waɗanda nake ba ku a yau, domin zaman lafiyarku da kuma na zuriyarku bayan ba ku, domin kuma ku yi tsawon rai a ƙasa wadda Ubangiji Allahnku yake ba ku har abada. ");
INSERT INTO hausa_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","Sa’an nan Musa ya keɓe birane uku gabas da Urdun, ");
INSERT INTO hausa_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","waɗanda duk wanda ya yi kisankai, in ba da gangan ba ne ya kashe maƙwabcinsa, wanda babu ƙiyayya tsakaninsu a dā, zai iya gudu zuwa. Zai iya gudu zuwa cikin ɗaya daga waɗannan birane, yă tsira da ransa. ");
INSERT INTO hausa_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","Biranen kuwa su ne, Bezer a dutsen hamada, don mutanen Ruben; Ramot Gileyad, don mutanen Gad; da kuma Golan a Bashan, don mutanen Manasse. ");
INSERT INTO hausa_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","Wannan ita ce dokar da Musa ya sa a gaban Isra’ilawa. ");
INSERT INTO hausa_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","Waɗannan su ne farillai, ƙa’idodi da kuma dokokin da Musa ya ba su, sa’ad da suka fito daga Masar. ");
INSERT INTO hausa_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","Sa’ad da suke a kwari kusa da Bet-Feyor, gabas da Urdun, a ƙasar Sihon sarkin Amoriyawa, wanda ya yi mulki a Heshbon, da Musa da Isra’ilawa suka ci da yaƙi sa’ad da suka fito daga Masar. ");
INSERT INTO hausa_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","Suka mallaki ƙasarsa da kuma ƙasar Og sarkin Bashan, sarakuna biyu na Amoriyawa, gabas da Urdun. ");
INSERT INTO hausa_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","Wannan ƙasa ta tashi daga Arower a kewayen Kwarin Arnon zuwa Dutsen Siyon (wato, Hermon), ");
INSERT INTO hausa_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","ya kuma haɗa da dukan Araba gabas da Urdun, har zuwa tekun Araba a gindin gangaren Fisga. ");
INSERT INTO hausa_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","Musa ya tattara dukan Isra’ila ya ce, Ku ji, ya Isra’ila, ƙa’idodi da dokokin da na furta a kunnuwanku a yau. Ku koye su, ku kuma tabbata kun bi su. ");
INSERT INTO hausa_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","Ubangiji Allahnmu ya yi alkawari da mu a Horeb. ");
INSERT INTO hausa_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","Ba da kakanninmu ba ne Ubangiji ya yi wannan alkawari, amma da mu ne, da dukanmu waɗanda muke da rai a yau. ");
INSERT INTO hausa_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","Ubangiji ya yi magana fuska da fuska da ku daga wuta a kan dutse. ");
INSERT INTO hausa_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","(A wannan lokaci na tsaya tsakanin Ubangiji da ku, don in furta muku maganar Ubangiji, domin kun ji tsoron wutar, ba ku kuwa hau dutsen ba.) Ya ce, ");
INSERT INTO hausa_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","“Ni ne Ubangiji Allahnka, wanda ya fitar da ku daga Masar, daga ƙasar bauta. ");
INSERT INTO hausa_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","“Ba za ka kasance da waɗansu alloli a gabana ba. ");
INSERT INTO hausa_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","Ba za ka yi wa kanka gunki, ko wata siffar abin da take a sama a bisa, ko siffar abin da yake a duniya a ƙasa, ko siffar abin da yake a cikin ruwa a ƙarƙashin ƙasa ba. ");
INSERT INTO hausa_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","Ba za ka rusuna musu, ko ka yi musu sujada ba. Gama Ni, Ubangiji Allahnka, Allah ne mai kishi, nakan hukunta ’ya’ya saboda zunuban iyaye har tsara ta uku da ta huɗu na waɗanda suka ƙi ni. ");
INSERT INTO hausa_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","Amma nakan nuna ƙauna ga dubban tsararraki na waɗanda suke ƙaunata, suke kuma kiyaye dokokina. ");
INSERT INTO hausa_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","Ba za ka yi amfani da sunan Ubangiji Allahnka a banza ba, gama Ubangiji zai ba wa duk mai yin amfani da sunansa a banza laifi. ");
INSERT INTO hausa_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","Ka kiyaye ranar Asabbaci ta wurin kiyaye ta da tsarki, yadda Ubangiji Allahnka ya umarce ka. ");
INSERT INTO hausa_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","Kwanaki shida za ka yi aiki, ka kuma yi dukan aikinka, ");
INSERT INTO hausa_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","amma rana ta bakwai, Asabbaci ne ga Ubangiji Allahnka. A kanta ba za ka yi wani aiki ba, ko kai, ko ɗanka, ko ’yarka, ko bawanka, ko baiwarka, ko saniyarka, ko jakinka, ko wani daga dabbobinka, ko baƙo a ƙofofinka, don bayinka maza da mata su ma su huta, kamar ka. ");
INSERT INTO hausa_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","Ka tuna fa, dā kai bawa ne a ƙasar Masar amma Ubangiji Allahnka ya fitar da kai daga can da iko da kuma ƙarfi. Saboda haka Ubangiji Allahnka ya umarce ka ka kiyaye ranar Asabbaci. ");
INSERT INTO hausa_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","Ka ba da girma ga mahaifinka da mahaifiyarka, yadda Ubangiji Allahnka ya umarce ka, don ka yi tsawon rai, ka kuma sami zaman lafiya a ƙasar da Ubangiji Allahnka yake ba ka. ");
INSERT INTO hausa_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","Kada ka yi kisankai. ");
INSERT INTO hausa_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","Kada ka yi zina. ");
INSERT INTO hausa_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","Kada ka yi sata. ");
INSERT INTO hausa_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","Kada ka ba da shaidar ƙarya a kan maƙwabcinka. ");
INSERT INTO hausa_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","Kada ka yi ƙyashin matar maƙwabcinka. Kada kuma ka yi sha’awar gidan maƙwabcinka, ko gonarsa, ko bayinsa maza da mata, ko saniyarka, ko jakinsa, ko dai wani abin da yake na maƙwabtanka.” ");
INSERT INTO hausa_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","Waɗannan su ne dokokin da Ubangiji ya furta da babbar murya ga taronku gaba ɗaya, a can dutse ta tsakiyar wuta, girgije da kuma baƙin duhu; bai kuma ƙara kome ba. Sa’an nan ya rubuta su a kan alluna biyu na dutse, ya kuma ba ni su. ");
INSERT INTO hausa_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","Sa’ad da kuka ji muryar daga duhu, yayinda dutsen yana cin wuta, dukan manyan kabilanku da dattawanku suka zo wurina. ");
INSERT INTO hausa_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","Kuka kuma ce, “Ubangiji Allahnmu ya nuna mana ɗaukakarsa da zatinsa, mun kuma ji muryarsa a tsakiyar wutar. A yau mun ga cewa mutum zai iya rayu idan ma Allah ya yi magana da shi. ");
INSERT INTO hausa_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","Amma yanzu, don me za mu mutu? Wannan wuta mai girma za tă cinye mu, za mu kuwa mutu in muka ci gaba da jin muryar Ubangiji Allahnmu. ");
INSERT INTO hausa_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","Gama wanda ɗan adam ne ya taɓa jin muryar Allah mai rai yana magana daga wuta, kamar yadda muka ji, ya kuma tsira? ");
INSERT INTO hausa_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","Kai, ka matsa kusa, ka saurara ga dukan abin da Ubangiji Allahnmu ya faɗa. Sa’an nan ka faɗa mana dukan abin da Ubangiji Allahnmu ya faɗa maka. Za mu saurara, mu kuma yi biyayya.” ");
INSERT INTO hausa_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","Ubangiji ya ji ku, sa’ad da kuka yi magana da ni, sai Ubangiji ya ce mini, “Na ji abin da wannan mutane suka faɗa maka. Abin da suka faɗa daidai ne. ");
INSERT INTO hausa_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","Kash, da a ce zukatansu za su zama masu tsorona, su kuma kiyaye dukan dokokina kullum mana, saboda kome yă zama da lafiya gare su, da kuma ’ya’yansu har abada! ");
INSERT INTO hausa_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","“Je, ka faɗa musu su koma tentunansu. ");
INSERT INTO hausa_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","Kai kuwa ka tsaya a nan tare da ni saboda in ba ka umarnai, ƙa’idodi da kuma dokoki duka, da za ka koya musu don su bi a ƙasar da nake ba su, su mallaka.” ");
INSERT INTO hausa_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","Sai ku yi hankali don ku yi abin da Ubangiji Allahnku ya umarce ku; kada ku juya dama ko hagu. ");
INSERT INTO hausa_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","Ku yi tafiya cikin dukan hanyar d